/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('4855cf04-64ac-4b61-a814-f8802858e1b8','2025-11-22 05:11:45','2025-11-22 05:11:45',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'consistent_group_snapshot_enabled','<is> True','30746da4-c537-49d5-97c7-c9a71fc7d57e','2025-11-22 05:11:39','2025-11-22 05:11:39',NULL,0);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('30746da4-c537-49d5-97c7-c9a71fc7d57e','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2025-11-22 05:11:39','2025-11-22 05:11:39',NULL,0,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`),
  KEY `ix_image_volume_cache_entries_host` (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2025-11-22 05:11:26',NULL,NULL,0,1,'default','volumes',10),('2025-11-22 05:11:26',NULL,NULL,0,2,'default','snapshots',10),('2025-11-22 05:11:26',NULL,NULL,0,3,'default','gigabytes',1000),('2025-11-22 05:11:26',NULL,NULL,0,4,'default','consistencygroups',10),('2025-11-22 05:11:26',NULL,NULL,0,5,'default','per_volume_gigabytes',-1),('2025-11-22 05:11:26',NULL,NULL,0,6,'default','groups',10);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`,`race_preventer`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2025-11-22 05:11:47','2025-11-22 06:14:07',NULL,0,1,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',369,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'02f01675-e911-4949-a767-0517df2b05ba'),('2025-11-22 05:45:33','2025-11-22 06:14:13',NULL,0,2,'cinder-backup-0','cinder-backup','cinder-backup',172,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'0b1b80c8-c798-490a-983f-b54d8d643197'),('2025-11-22 05:45:33','2025-11-22 06:14:14',NULL,0,3,'hostgroup@ceph','cinder-volume','cinder-volume',172,0,'nova',NULL,NULL,'3.18','1.39','disabled',0,NULL,NULL,'62c349b1-b2c5-430b-ba73-8b48b66d273c');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2025-11-22 05:11:39','2025-11-22 05:11:39',NULL,0,'279f33d9-932c-4da9-aa8b-5453b4db6bd4','__DEFAULT__',NULL,1,'Default Volume Type');
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2025-11-22 05:11:39','2025-11-22 05:11:39.000123',NULL,0,1,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (1,'bc918e9b-ff4a-442b-bfbd-cc3c9dd0eef8','rbd://13fdadc6-d566-5465-9ac8-a148ef130da1/images/bc918e9b-ff4a-442b-bfbd-cc3c9dd0eef8/snap','2025-11-22 05:50:24','2025-11-22 05:50:24',NULL,0,'{\"store\": \"default_backend\"}','active'),(2,'ed59cc6e-b42f-4626-b364-e0a05416df7e','rbd://13fdadc6-d566-5465-9ac8-a148ef130da1/images/ed59cc6e-b42f-4626-b364-e0a05416df7e/snap','2025-11-22 05:50:26','2025-11-22 05:50:26',NULL,0,'{\"store\": \"default_backend\"}','active');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'bc918e9b-ff4a-442b-bfbd-cc3c9dd0eef8','hw_rng_model','virtio','2025-11-22 05:50:20','2025-11-22 05:50:20',NULL,0),(2,'ed59cc6e-b42f-4626-b364-e0a05416df7e','hw_rng_model','virtio','2025-11-22 05:50:24','2025-11-22 05:50:24',NULL,0);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('bc918e9b-ff4a-442b-bfbd-cc3c9dd0eef8','cirros-0.6.2-x86_64-disk.img',21430272,'active','2025-11-22 05:50:20','2025-11-22 05:50:24',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','5830132eb4c840bd906214f1719ec76f',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('ed59cc6e-b42f-4626-b364-e0a05416df7e','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2025-11-22 05:50:24','2025-11-22 05:50:26',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','5830132eb4c840bd906214f1719ec76f',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b');
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (1,1,'image','CIM_PASD_','2025-11-22 05:10:41',NULL),(1,2,'image','CIM_RASD_','2025-11-22 05:10:41',NULL),(1,3,NULL,'CIM_SASD_','2025-11-22 05:10:42',NULL),(1,9,'image','hw_','2025-11-22 05:10:44',NULL),(1,10,'image','hw_','2025-11-22 05:10:44',NULL),(1,14,'image',NULL,'2025-11-22 05:10:45',NULL),(1,19,'image','hw_','2025-11-22 05:10:45',NULL),(1,25,'image','hw_','2025-11-22 05:10:45',NULL),(1,29,'image',NULL,'2025-11-22 05:10:46',NULL),(1,30,'image',NULL,'2025-11-22 05:10:46',NULL),(1,31,'image',NULL,'2025-11-22 05:10:46',NULL),(1,32,'image',NULL,'2025-11-22 05:10:46',NULL),(2,1,NULL,'CIM_PASD_','2025-11-22 05:10:41',NULL),(2,8,NULL,'hw_','2025-11-22 05:10:44',NULL),(2,9,NULL,'hw_','2025-11-22 05:10:44',NULL),(2,10,NULL,'hw_','2025-11-22 05:10:44',NULL),(2,11,NULL,NULL,'2025-11-22 05:10:44',NULL),(2,13,NULL,NULL,'2025-11-22 05:10:45',NULL),(2,14,NULL,NULL,'2025-11-22 05:10:45',NULL),(2,15,NULL,NULL,'2025-11-22 05:10:45',NULL),(2,16,NULL,'hw_','2025-11-22 05:10:45',NULL),(2,19,NULL,'hw_','2025-11-22 05:10:45',NULL),(2,22,NULL,NULL,'2025-11-22 05:10:45',NULL),(2,23,NULL,'hw_','2025-11-22 05:10:45',NULL),(2,24,NULL,'traits:','2025-11-22 05:10:45',NULL),(2,25,NULL,'hw_','2025-11-22 05:10:45',NULL),(2,26,NULL,NULL,'2025-11-22 05:10:45',NULL),(2,28,NULL,NULL,'2025-11-22 05:10:46',NULL),(2,29,NULL,NULL,'2025-11-22 05:10:46',NULL),(2,30,NULL,NULL,'2025-11-22 05:10:46',NULL),(2,31,NULL,NULL,'2025-11-22 05:10:46',NULL),(2,32,NULL,NULL,'2025-11-22 05:10:46',NULL),(2,33,NULL,'cinder_','2025-11-22 05:10:46',NULL),(3,1,NULL,'CIM_PASD_','2025-11-22 05:10:41',NULL),(3,2,NULL,'CIM_RASD_','2025-11-22 05:10:41',NULL),(3,3,NULL,'CIM_SASD_','2025-11-22 05:10:42',NULL),(3,4,NULL,'CIM_VSSD_','2025-11-22 05:10:43',NULL),(3,5,NULL,NULL,'2025-11-22 05:10:43',NULL),(3,6,NULL,NULL,'2025-11-22 05:10:43',NULL),(3,7,NULL,NULL,'2025-11-22 05:10:43',NULL),(3,12,NULL,'aggregate_instance_extra_specs:','2025-11-22 05:10:44',NULL),(4,1,NULL,'CIM_PASD_','2025-11-22 05:10:41',NULL),(4,2,NULL,'CIM_RASD_','2025-11-22 05:10:41',NULL),(4,3,NULL,'CIM_SASD_','2025-11-22 05:10:42',NULL),(4,4,NULL,'CIM_VSSD_','2025-11-22 05:10:43',NULL),(4,8,NULL,'hw:','2025-11-22 05:10:44',NULL),(4,9,NULL,'hw:','2025-11-22 05:10:44',NULL),(4,10,NULL,'hw:','2025-11-22 05:10:44',NULL),(4,12,NULL,'capabilities:','2025-11-22 05:10:44',NULL),(4,16,NULL,'hw:','2025-11-22 05:10:45',NULL),(4,17,NULL,NULL,'2025-11-22 05:10:45',NULL),(4,18,NULL,NULL,'2025-11-22 05:10:45',NULL),(4,19,NULL,'hw:','2025-11-22 05:10:45',NULL),(4,20,NULL,NULL,'2025-11-22 05:10:45',NULL),(4,21,NULL,NULL,'2025-11-22 05:10:45',NULL),(4,23,NULL,'hw:','2025-11-22 05:10:45',NULL),(4,24,NULL,'traits:','2025-11-22 05:10:45',NULL),(4,25,NULL,'hw:','2025-11-22 05:10:45',NULL),(5,1,'scheduler_hints',NULL,'2025-11-22 05:10:41',NULL),(5,30,'metadata',NULL,'2025-11-22 05:10:46',NULL),(5,31,'metadata',NULL,'2025-11-22 05:10:46',NULL),(5,32,'metadata',NULL,'2025-11-22 05:10:46',NULL),(6,30,NULL,NULL,'2025-11-22 05:10:46',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (1,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2025-11-22 05:10:41',NULL),(2,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2025-11-22 05:10:41',NULL),(3,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2025-11-22 05:10:42',NULL),(4,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2025-11-22 05:10:43',NULL),(5,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-11-22 05:10:43',NULL),(6,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-11-22 05:10:43',NULL),(7,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2025-11-22 05:10:43',NULL),(8,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2025-11-22 05:10:43',NULL),(9,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2025-11-22 05:10:44',NULL),(10,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2025-11-22 05:10:44',NULL),(11,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2025-11-22 05:10:44',NULL),(12,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2025-11-22 05:10:44',NULL),(13,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2025-11-22 05:10:45',NULL),(14,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2025-11-22 05:10:45',NULL),(15,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-22 05:10:45',NULL),(16,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-22 05:10:45',NULL),(17,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-22 05:10:45',NULL),(18,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2025-11-22 05:10:45',NULL),(19,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2025-11-22 05:10:45',NULL),(20,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-22 05:10:45',NULL),(21,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-22 05:10:45',NULL),(22,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-22 05:10:45',NULL),(23,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2025-11-22 05:10:45',NULL),(24,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2025-11-22 05:10:45',NULL),(25,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-22 05:10:45',NULL),(26,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-22 05:10:45',NULL),(27,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2025-11-22 05:10:45',NULL),(28,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2025-11-22 05:10:46',NULL),(29,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2025-11-22 05:10:46',NULL),(30,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2025-11-22 05:10:46',NULL),(31,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2025-11-22 05:10:46',NULL),(32,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2025-11-22 05:10:46',NULL),(33,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2025-11-22 05:10:46',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (1,17,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2025-11-22 05:10:45',NULL),(2,17,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2025-11-22 05:10:45',NULL),(3,17,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2025-11-22 05:10:45',NULL),(4,30,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2025-11-22 05:10:46',NULL),(5,30,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2025-11-22 05:10:46',NULL),(6,30,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2025-11-22 05:10:46',NULL),(7,30,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2025-11-22 05:10:46',NULL),(8,30,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-11-22 05:10:46',NULL),(9,30,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-11-22 05:10:46',NULL),(10,30,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-11-22 05:10:46',NULL),(11,30,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-11-22 05:10:46',NULL),(12,30,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-11-22 05:10:46',NULL),(13,30,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2025-11-22 05:10:46',NULL),(14,30,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2025-11-22 05:10:46',NULL),(15,30,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2025-11-22 05:10:46',NULL),(16,31,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2025-11-22 05:10:46',NULL),(17,31,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2025-11-22 05:10:46',NULL),(18,31,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2025-11-22 05:10:46',NULL),(19,31,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2025-11-22 05:10:46',NULL),(20,31,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2025-11-22 05:10:46',NULL),(21,32,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-11-22 05:10:46',NULL),(22,32,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-11-22 05:10:46',NULL),(23,32,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-11-22 05:10:46',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (1,1,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2025-11-22 05:10:41',NULL),(2,1,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2025-11-22 05:10:41',NULL),(3,1,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2025-11-22 05:10:41',NULL),(4,2,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2025-11-22 05:10:41',NULL),(5,2,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2025-11-22 05:10:42',NULL),(6,2,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2025-11-22 05:10:42',NULL),(7,2,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2025-11-22 05:10:42',NULL),(8,2,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2025-11-22 05:10:42',NULL),(9,2,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-11-22 05:10:42',NULL),(10,2,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2025-11-22 05:10:42',NULL),(11,2,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2025-11-22 05:10:42',NULL),(12,2,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2025-11-22 05:10:42',NULL),(13,2,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2025-11-22 05:10:42',NULL),(14,2,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2025-11-22 05:10:42',NULL),(15,2,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2025-11-22 05:10:42',NULL),(16,2,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2025-11-22 05:10:42',NULL),(17,2,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-11-22 05:10:42',NULL),(18,2,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2025-11-22 05:10:42',NULL),(19,2,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-11-22 05:10:42',NULL),(20,2,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2025-11-22 05:10:42',NULL),(21,2,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2025-11-22 05:10:42',NULL),(22,2,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2025-11-22 05:10:42',NULL),(23,3,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2025-11-22 05:10:42',NULL),(24,3,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2025-11-22 05:10:42',NULL),(25,3,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2025-11-22 05:10:42',NULL),(26,3,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2025-11-22 05:10:42',NULL),(27,3,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2025-11-22 05:10:42',NULL),(28,3,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-11-22 05:10:42',NULL),(29,3,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-11-22 05:10:42',NULL),(30,3,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2025-11-22 05:10:42',NULL),(31,3,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2025-11-22 05:10:42',NULL),(32,3,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-11-22 05:10:42',NULL),(33,3,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2025-11-22 05:10:42',NULL),(34,3,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-11-22 05:10:42',NULL),(35,3,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-11-22 05:10:42',NULL),(36,4,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2025-11-22 05:10:43',NULL),(37,4,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2025-11-22 05:10:43',NULL),(38,4,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2025-11-22 05:10:43',NULL),(39,4,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2025-11-22 05:10:43',NULL),(40,4,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2025-11-22 05:10:43',NULL),(41,4,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-11-22 05:10:43',NULL),(42,4,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-11-22 05:10:43',NULL),(43,4,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2025-11-22 05:10:43',NULL),(44,4,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2025-11-22 05:10:43',NULL),(45,4,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2025-11-22 05:10:43',NULL),(46,4,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2025-11-22 05:10:43',NULL),(47,4,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2025-11-22 05:10:43',NULL),(48,4,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2025-11-22 05:10:43',NULL),(49,4,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2025-11-22 05:10:43',NULL),(50,4,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2025-11-22 05:10:43',NULL),(51,4,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2025-11-22 05:10:43',NULL),(52,4,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2025-11-22 05:10:43',NULL),(53,5,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2025-11-22 05:10:43',NULL),(54,6,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2025-11-22 05:10:43',NULL),(55,7,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2025-11-22 05:10:43',NULL),(56,8,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2025-11-22 05:10:44',NULL),(57,9,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2025-11-22 05:10:44',NULL),(58,9,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2025-11-22 05:10:44',NULL),(59,10,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2025-11-22 05:10:44',NULL),(60,11,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-22 05:10:44',NULL),(61,12,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2025-11-22 05:10:44',NULL),(62,12,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2025-11-22 05:10:44',NULL),(63,12,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2025-11-22 05:10:45',NULL),(64,12,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-11-22 05:10:45',NULL),(65,12,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-11-22 05:10:45',NULL),(66,12,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-11-22 05:10:45',NULL),(67,12,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2025-11-22 05:10:45',NULL),(68,13,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2025-11-22 05:10:45',NULL),(69,13,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2025-11-22 05:10:45',NULL),(70,14,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2025-11-22 05:10:45',NULL),(71,14,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-11-22 05:10:45',NULL),(72,15,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-11-22 05:10:45',NULL),(73,15,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-11-22 05:10:45',NULL),(74,15,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2025-11-22 05:10:45',NULL),(75,15,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2025-11-22 05:10:45',NULL),(76,15,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2025-11-22 05:10:45',NULL),(77,15,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2025-11-22 05:10:45',NULL),(78,15,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\", \"bochs\"]}','2025-11-22 05:10:45',NULL),(79,15,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-22 05:10:45',NULL),(80,15,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2025-11-22 05:10:45',NULL),(81,15,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2025-11-22 05:10:45',NULL),(82,15,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, virtio, e1000e and vmxnet3. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\", \"vmxnet3\"]}','2025-11-22 05:10:45',NULL),(83,15,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-22 05:10:45',NULL),(84,15,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-22 05:10:45',NULL),(85,15,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-11-22 05:10:45',NULL),(86,15,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2025-11-22 05:10:45',NULL),(87,15,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-11-22 05:10:45',NULL),(88,16,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-22 05:10:45',NULL),(89,16,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-22 05:10:45',NULL),(90,16,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-22 05:10:45',NULL),(91,18,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2025-11-22 05:10:45',NULL),(92,18,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2025-11-22 05:10:45',NULL),(93,18,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2025-11-22 05:10:45',NULL),(94,19,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-11-22 05:10:45',NULL),(95,19,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-11-22 05:10:45',NULL),(96,19,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-11-22 05:10:45',NULL),(97,19,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-11-22 05:10:45',NULL),(98,19,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-11-22 05:10:45',NULL),(99,19,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-11-22 05:10:45',NULL),(100,20,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2025-11-22 05:10:45',NULL),(101,20,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2025-11-22 05:10:45',NULL),(102,21,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-22 05:10:45',NULL),(103,21,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-22 05:10:45',NULL),(104,22,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2025-11-22 05:10:45',NULL),(105,22,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2025-11-22 05:10:45',NULL),(106,22,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2025-11-22 05:10:45',NULL),(107,22,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2025-11-22 05:10:45',NULL),(108,22,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2025-11-22 05:10:45',NULL),(109,22,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-22 05:10:45',NULL),(110,23,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2025-11-22 05:10:45',NULL),(111,24,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-11-22 05:10:45',NULL),(112,24,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-11-22 05:10:45',NULL),(113,25,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2025-11-22 05:10:45',NULL),(114,26,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2025-11-22 05:10:45',NULL),(115,27,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2025-11-22 05:10:45',NULL),(116,27,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2025-11-22 05:10:45',NULL),(117,27,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2025-11-22 05:10:45',NULL),(118,27,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2025-11-22 05:10:45',NULL),(119,27,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-11-22 05:10:45',NULL),(120,27,'hw_cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"This specifies the CPU Mode for the guest vm\", \"type\": \"string\"}','2025-11-22 05:10:46',NULL),(121,27,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-11-22 05:10:46',NULL),(122,27,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2025-11-22 05:10:46',NULL),(123,27,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2025-11-22 05:10:46',NULL),(124,27,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2025-11-22 05:10:46',NULL),(125,28,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2025-11-22 05:10:46',NULL),(126,28,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2025-11-22 05:10:46',NULL),(127,28,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2025-11-22 05:10:46',NULL),(128,28,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2025-11-22 05:10:46',NULL),(129,29,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-11-22 05:10:46',NULL),(130,29,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-11-22 05:10:46',NULL),(131,29,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2025-11-22 05:10:46',NULL),(132,33,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2025-11-22 05:10:46',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (1,'OS::Cinder::Volume',1,'2025-11-22 05:10:41',NULL),(2,'OS::Glance::Image',1,'2025-11-22 05:10:41',NULL),(3,'OS::Nova::Aggregate',1,'2025-11-22 05:10:41',NULL),(4,'OS::Nova::Flavor',1,'2025-11-22 05:10:41',NULL),(5,'OS::Nova::Server',1,'2025-11-22 05:10:41',NULL),(6,'OS::Trove::Instance',1,'2025-11-22 05:10:46',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `user_id` (`user_id`),
  KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','044d47622a784618a29823cd785e2e31','5830132eb4c840bd906214f1719ec76f','f5b734243ad845c6b3d599eb788e62f2',0),('UserProject','044d47622a784618a29823cd785e2e31','5830132eb4c840bd906214f1719ec76f','f7a577b5cb294c28be49df12bfeb664c',0),('UserProject','044d47622a784618a29823cd785e2e31','cd7b6b90941b47f8bc0928bc047133cc','f5b734243ad845c6b3d599eb788e62f2',0),('UserProject','11dcc5b1cf0f4f4a952b208624faec1c','3c2407aa169a41c3b17fd0e7758ba8b9','66032c69f31549bbaa37296fbf6be590',0),('UserProject','11dcc5b1cf0f4f4a952b208624faec1c','3c2407aa169a41c3b17fd0e7758ba8b9','f5b734243ad845c6b3d599eb788e62f2',0),('UserProject','3f3553734ec7494eacbe5d59be680f54','3c2407aa169a41c3b17fd0e7758ba8b9','66032c69f31549bbaa37296fbf6be590',0),('UserProject','3f3553734ec7494eacbe5d59be680f54','3c2407aa169a41c3b17fd0e7758ba8b9','f5b734243ad845c6b3d599eb788e62f2',0),('UserProject','50d78bcc473442519c43aa8f1f1dc71f','3c2407aa169a41c3b17fd0e7758ba8b9','f5b734243ad845c6b3d599eb788e62f2',0),('UserProject','50d78bcc473442519c43aa8f1f1dc71f','3c2407aa169a41c3b17fd0e7758ba8b9','f603d4ac63d940f88adf921b37144226',0),('UserProject','5bcd98ae5e1141768a36c1b8b4c1527a','3c2407aa169a41c3b17fd0e7758ba8b9','66032c69f31549bbaa37296fbf6be590',0),('UserProject','5bcd98ae5e1141768a36c1b8b4c1527a','3c2407aa169a41c3b17fd0e7758ba8b9','f5b734243ad845c6b3d599eb788e62f2',0),('UserProject','9844b9207f894a67894fd6041fcd557c','3c2407aa169a41c3b17fd0e7758ba8b9','66032c69f31549bbaa37296fbf6be590',0),('UserProject','9844b9207f894a67894fd6041fcd557c','3c2407aa169a41c3b17fd0e7758ba8b9','f5b734243ad845c6b3d599eb788e62f2',0),('UserProject','9f9d6131485e44518fe0af5c507e1222','3c2407aa169a41c3b17fd0e7758ba8b9','66032c69f31549bbaa37296fbf6be590',0),('UserProject','9f9d6131485e44518fe0af5c507e1222','3c2407aa169a41c3b17fd0e7758ba8b9','f5b734243ad845c6b3d599eb788e62f2',0),('UserProject','a3b9d4aab4d542d594e3c2fa6b6303d6','3c2407aa169a41c3b17fd0e7758ba8b9','66032c69f31549bbaa37296fbf6be590',0),('UserProject','a3b9d4aab4d542d594e3c2fa6b6303d6','3c2407aa169a41c3b17fd0e7758ba8b9','f5b734243ad845c6b3d599eb788e62f2',0),('UserProject','afae489ae6db4d65b6594bf3fec7b2ec','3c2407aa169a41c3b17fd0e7758ba8b9','66032c69f31549bbaa37296fbf6be590',0),('UserProject','afae489ae6db4d65b6594bf3fec7b2ec','3c2407aa169a41c3b17fd0e7758ba8b9','f5b734243ad845c6b3d599eb788e62f2',0),('UserProject','fd0f94750ac6410eb7e1eb208b1c1022','3c2407aa169a41c3b17fd0e7758ba8b9','66032c69f31549bbaa37296fbf6be590',0),('UserProject','fd0f94750ac6410eb7e1eb208b1c1022','3c2407aa169a41c3b17fd0e7758ba8b9','f5b734243ad845c6b3d599eb788e62f2',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('0356ead7da5941d7b0246074aa65e05b',NULL,'public','d98ad7767e194ff8a9581265ed60e9ec','https://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('12d994dd1ae2468f9b72acdf171bb31c',NULL,'public','f6d050060bed4750bda9b6f47f7f3560','https://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('1a3e7f662e454efa9a1894d58681a956',NULL,'internal','b9fe11fc32ac442da752fdaab87326a6','https://manila-internal.openstack.svc:8786/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne'),('1afdd323211a4be49fe5f455c56898b2',NULL,'internal','a783e59c11794c6da9359c62f5d8c347','https://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('2c2f60ea04364026bd76aec0af1d7959',NULL,'public','d628501d98704f95a8ff259ed95391c7','https://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('35d1443d75f646e88f26398eb1e23bf6',NULL,'public','0849ec0275254e7db6e34537cf39d890','https://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('4b7dfc8904d840618e3e875850756ef7',NULL,'public','98fcdb73f800441a936e0dbb0383516c','https://manila-public-openstack.apps-crc.testing/v2','{\"name\": \"manilav2\"}',1,'regionOne'),('4d09e17d2a4a45778086827eb1b2252c',NULL,'internal','f6d050060bed4750bda9b6f47f7f3560','https://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('534fca36f68f4cd280dd1e4b69826afe',NULL,'public','b9fe11fc32ac442da752fdaab87326a6','https://manila-public-openstack.apps-crc.testing/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne'),('67ba3b6259304e0a88f63569f5e35f2d',NULL,'internal','0849ec0275254e7db6e34537cf39d890','https://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('68743fcb11bd47bba6c2b5e383ffe1df',NULL,'public','8647ab34e2b54350b2b74c07f901d331','https://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('6e0ed4f86ee543ff8ea2387cf0afcbd9',NULL,'internal','d98ad7767e194ff8a9581265ed60e9ec','https://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('70de5292f39044fea799c6b94e694411',NULL,'public','3e8fb75a9b174877b338b298705c1b34','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('9227a5827ea7403c84618a2d95b4ec6e',NULL,'internal','d628501d98704f95a8ff259ed95391c7','https://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('ad8524da1a2946c2a73a09e04026dc7d',NULL,'internal','8647ab34e2b54350b2b74c07f901d331','https://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('b5e918edf734413fb72c0901892a9934',NULL,'internal','3e8fb75a9b174877b338b298705c1b34','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('d08523a03d9941859a31efc044c8df5b',NULL,'public','a906e6d94afe4b298b2f9a10e0b39ab7','https://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('dbdcb985107948ce82445ef785595976',NULL,'internal','98fcdb73f800441a936e0dbb0383516c','https://manila-internal.openstack.svc:8786/v2','{\"name\": \"manilav2\"}',1,'regionOne'),('e53d5138c1a243b289f1c2167bb373c8',NULL,'public','a783e59c11794c6da9359c62f5d8c347','https://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('fe9d8bd653d24e33be922dd75d93d4ee',NULL,'internal','a906e6d94afe4b298b2f9a10e0b39ab7','https://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('f5b734243ad845c6b3d599eb788e62f2','f603d4ac63d940f88adf921b37144226'),('f603d4ac63d940f88adf921b37144226','4c488837e5c84b4f9d41a52099e21506');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=233 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (1,'044d47622a784618a29823cd785e2e31','default','admin',0,NULL),(2,'3f3553734ec7494eacbe5d59be680f54','default','glance',0,NULL),(3,'a3b9d4aab4d542d594e3c2fa6b6303d6','default','cinder',0,NULL),(4,'fd0f94750ac6410eb7e1eb208b1c1022','default','ceilometer',0,NULL),(5,'afae489ae6db4d65b6594bf3fec7b2ec','default','barbican',0,NULL),(6,'5bcd98ae5e1141768a36c1b8b4c1527a','default','neutron',0,NULL),(7,'9f9d6131485e44518fe0af5c507e1222','default','placement',0,NULL),(8,'9844b9207f894a67894fd6041fcd557c','default','nova',0,NULL),(9,'50d78bcc473442519c43aa8f1f1dc71f','default','swift',0,NULL),(10,'11dcc5b1cf0f4f4a952b208624faec1c','default','manila',0,NULL),(11,'8b49c4f6a70549aeb550364d3490ef56','default','demo_tempestconf',0,NULL),(12,'98d34a55bea14665afe3180a63797fa6','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=233 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (1,1,NULL,0,'$2b$12$45ftLlBifVQOoA6MLF/lEuPDKlwRxVrN3iMm.Ti3TFFxVr9x6u2zO',1763788247262864,NULL,'2025-11-22 05:10:47'),(2,2,NULL,0,'$2b$12$xwrtSfCfsNvHdBM0WdxD7.D67DIj7F6mnJ3NHkuhgZaMxcn3DMzI.',1763788312568865,NULL,'2025-11-22 05:11:52'),(3,3,NULL,0,'$2b$12$hXl9KixwMxRZgMTpfg5/4el3AGeViPfphG992h2hFv38rD5FcWGO.',1763788315704203,NULL,'2025-11-22 05:11:55'),(4,4,NULL,0,'$2b$12$o6FqElXoJaek05ijyjEo6uYqvFBoE/iixiLzcl1WtCrNEVgDorQxG',1763788317794431,NULL,'2025-11-22 05:11:57'),(5,5,NULL,0,'$2b$12$K1Ak8UL4XukoLkfbrI1aVOhOtaY8YKN0aPLDy0jFEvzAAt0ixs4ka',1763788320436171,NULL,'2025-11-22 05:12:00'),(6,6,NULL,0,'$2b$12$0.WAjqA.a/G/azGipVZyoOguKPgw1lFxJeVH7SkCp9IWsSLJB91m2',1763788323918590,NULL,'2025-11-22 05:12:03'),(7,7,NULL,0,'$2b$12$P9z0XEEY9QwlGzHcbnrRdOj7I7Aa5TJ13tYTE9aEtHZ.xT0Sjn8XC',1763788326822066,NULL,'2025-11-22 05:12:06'),(8,8,NULL,0,'$2b$12$K.xp0Fod6l0gep1ynLilFe4pk/QkMbZsvpQ.L.O7jaPUzt1LKrSeq',1763788331042864,NULL,'2025-11-22 05:12:11'),(9,9,NULL,0,'$2b$12$.VBqtPcyZGzE.n4b739fG.OZGJp/K0WkRSEwWrN.JNE8qV8bpNFIq',1763789246729509,NULL,'2025-11-22 05:27:26'),(10,10,NULL,0,'$2b$12$SDsE103pG1pF85cDardY7.Rkx7dGNvILEsslQb0t/IkprhcyAQoIC',1763790363186615,NULL,'2025-11-22 05:46:03'),(11,11,NULL,0,'$2b$12$Cf2tCD3YfcrvHBDaKk5uk./cdZU5BruxxjjvP4ovv3azhiYvCYuiO',1763790508130444,NULL,'2025-11-22 05:48:28'),(12,12,NULL,0,'$2b$12$qhReOuYKkwB/Js30CutwD.g.pM5byy5zkGHTm6VHwlROtRXRtrVkG',1763790508543739,NULL,'2025-11-22 05:48:28');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('3c2407aa169a41c3b17fd0e7758ba8b9','service','{}','service',1,'default','default',0),('5830132eb4c840bd906214f1719ec76f','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('bd1dca9c7c074263995f4b73350e4e3a','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0),('cd7b6b90941b47f8bc0928bc047133cc','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=395 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (1,NULL,NULL,'423177fd918e4f5c9dde97e5c5fdc214',NULL,NULL,NULL,NULL,'2025-11-22 05:50:48',NULL,'2025-11-22 05:50:48',NULL,NULL),(2,NULL,NULL,'3b5792ac013c4008a82597534b505ac7',NULL,NULL,NULL,NULL,'2025-11-22 05:50:48',NULL,'2025-11-22 05:50:48',NULL,NULL),(3,NULL,'fe6e59c0c7f64e818b7f7d828d7cd919',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:50:51',NULL,'2025-11-22 05:50:51',NULL,NULL),(4,NULL,'8a801f539bec428eb46925d3760a44ae',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:50:51',NULL,'2025-11-22 05:50:51',NULL,NULL),(5,NULL,NULL,'637a7ba3350a4b3bb5ffbc20465944c7',NULL,NULL,NULL,NULL,'2025-11-22 05:50:54',NULL,'2025-11-22 05:50:54',NULL,NULL),(6,NULL,'07717631d735459583939fd7b6310d50',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:50:56',NULL,'2025-11-22 05:50:56',NULL,NULL),(7,NULL,NULL,'308308c6e5dd42e48ebfb2be542cfcc9',NULL,NULL,NULL,NULL,'2025-11-22 05:50:58',NULL,'2025-11-22 05:50:58',NULL,NULL),(8,NULL,'c26f299b83af4c0e8229e10af7b2232e',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:50:59',NULL,'2025-11-22 05:50:59',NULL,NULL),(9,NULL,NULL,'4ca73289504747a3b2e35b9622146be7',NULL,NULL,NULL,NULL,'2025-11-22 05:51:01',NULL,'2025-11-22 05:51:01',NULL,NULL),(10,NULL,NULL,'674c40d778974c959aa8b594d5c20f20',NULL,NULL,NULL,NULL,'2025-11-22 05:51:02',NULL,'2025-11-22 05:51:02',NULL,NULL),(11,NULL,NULL,'f14080a6e5894c1998fe207d36c3a562',NULL,NULL,NULL,NULL,'2025-11-22 05:51:02',NULL,'2025-11-22 05:51:02',NULL,NULL),(12,NULL,'cdd04c5e93f14da4beec43292fb25ad8',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:51:03',NULL,'2025-11-22 05:51:03',NULL,NULL),(13,NULL,'dd1f0f76d8c542febd4c75985ef66d86',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:51:05',NULL,'2025-11-22 05:51:05',NULL,NULL),(14,NULL,NULL,'7b9f8e8de8184d808bcd0b01135a6c77',NULL,NULL,NULL,NULL,'2025-11-22 05:51:08',NULL,'2025-11-22 05:51:08',NULL,NULL),(15,NULL,NULL,'cfabff178c754ad5828a1d683b186689',NULL,NULL,NULL,NULL,'2025-11-22 05:51:10',NULL,'2025-11-22 05:51:10',NULL,NULL),(16,NULL,NULL,'bb828129fe5046d68b9bf613e493f5af',NULL,NULL,NULL,NULL,'2025-11-22 05:51:10',NULL,'2025-11-22 05:51:10',NULL,NULL),(17,NULL,NULL,'9395a53526744acc85a47d28e0d28556',NULL,NULL,NULL,NULL,'2025-11-22 05:51:10',NULL,'2025-11-22 05:51:10',NULL,NULL),(18,NULL,'cea48ba47c2f444882493fe802389fea',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:51:10',NULL,'2025-11-22 05:51:10',NULL,NULL),(19,NULL,'9ece7a8ade98405884af4e066937cac2',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:51:11',NULL,'2025-11-22 05:51:11',NULL,NULL),(20,NULL,'cc6d9d3a69624bf2a521f49696141883',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:51:12',NULL,'2025-11-22 05:51:12',NULL,NULL),(21,NULL,'772a2ad8da694913b6aae476f9186101',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:51:14',NULL,'2025-11-22 05:51:14',NULL,NULL),(22,NULL,NULL,'a11c054c40434e159559362d68f36160',NULL,NULL,NULL,NULL,'2025-11-22 05:51:24',NULL,'2025-11-22 05:51:24',NULL,NULL),(23,NULL,NULL,'dc084b01bca940b9bd2e760425dd5dd4',NULL,NULL,NULL,NULL,'2025-11-22 05:51:28',NULL,'2025-11-22 05:51:28',NULL,NULL),(24,NULL,NULL,'0b1d92f1a1c7486dad690575e43f9f5c',NULL,NULL,NULL,NULL,'2025-11-22 05:51:28',NULL,'2025-11-22 05:51:28',NULL,NULL),(25,NULL,NULL,'4ec9dc11277c4a1283c49e6e6a186cf5',NULL,NULL,NULL,NULL,'2025-11-22 05:51:29',NULL,'2025-11-22 05:51:29',NULL,NULL),(26,NULL,'d3e7f0afacee43b195777b9c2cc723a6',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:51:30',NULL,'2025-11-22 05:51:30',NULL,NULL),(27,NULL,'1e3fe6af68e940a7ab49ae2aeefc49f6',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:51:31',NULL,'2025-11-22 05:51:31',NULL,NULL),(28,NULL,'dd17ac9b721a4caaa440f97988ad0956',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:51:32',NULL,'2025-11-22 05:51:32',NULL,NULL),(29,NULL,NULL,'97d692664d684a41bf7266f942c5e944',NULL,NULL,NULL,NULL,'2025-11-22 05:51:34',NULL,'2025-11-22 05:51:34',NULL,NULL),(30,NULL,'c2984e26622a4732a518d623ec38d85c',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:51:35',NULL,'2025-11-22 05:51:35',NULL,NULL),(31,NULL,NULL,'4b888cf8db7b4f47bb1cf7cb4b4b1857',NULL,NULL,NULL,NULL,'2025-11-22 05:51:35',NULL,'2025-11-22 05:51:35',NULL,NULL),(32,NULL,NULL,'3a798de8dc964838b12715c65c83b403',NULL,NULL,NULL,NULL,'2025-11-22 05:51:36',NULL,'2025-11-22 05:51:36',NULL,NULL),(33,NULL,NULL,'102cc7f378974b1bb0d9d3aea253162d',NULL,NULL,NULL,NULL,'2025-11-22 05:51:36',NULL,'2025-11-22 05:51:36',NULL,NULL),(34,NULL,NULL,'77ed3093e7524efe9e92af9f684ac16a',NULL,NULL,NULL,NULL,'2025-11-22 05:51:36',NULL,'2025-11-22 05:51:36',NULL,NULL),(35,NULL,'af9cfba0650e4207a32331266304dce1',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:51:38',NULL,'2025-11-22 05:51:38',NULL,NULL),(36,NULL,'9025f62261724968b1d4a38c886fcc38',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:51:39',NULL,'2025-11-22 05:51:39',NULL,NULL),(37,NULL,'9a040dac65f744c687d2d5814d775f6c',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:51:39',NULL,'2025-11-22 05:51:39',NULL,NULL),(38,NULL,NULL,'98f921ea69fa4cd9bf74c37b645f9733',NULL,NULL,NULL,NULL,'2025-11-22 05:51:40',NULL,'2025-11-22 05:51:40',NULL,NULL),(39,NULL,'0e5f6a3a07fc4127bb51414f12d488cd',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:51:41',NULL,'2025-11-22 05:51:41',NULL,NULL),(40,NULL,NULL,'c35a295d436b4d5eb4dab47b869ab915',NULL,NULL,NULL,NULL,'2025-11-22 05:51:47',NULL,'2025-11-22 05:51:47',NULL,NULL),(41,NULL,'828f4979b50f4562ad005b00789ba129',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:51:48',NULL,'2025-11-22 05:51:48',NULL,NULL),(42,NULL,NULL,'794ffb544ee04b168bdcc02ecbb50053',NULL,NULL,NULL,NULL,'2025-11-22 05:51:57',NULL,'2025-11-22 05:51:57',NULL,NULL),(43,NULL,'790f13450b2540d1bdb71104fcc67ddf',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:51:58',NULL,'2025-11-22 05:51:58',NULL,NULL),(44,NULL,NULL,'d61c4063d8ea4dc3ae0066cb728bd79c',NULL,NULL,NULL,NULL,'2025-11-22 05:52:07',NULL,'2025-11-22 05:52:07',NULL,NULL),(45,NULL,NULL,'825bdf0dbbba49b38e9e122e772e6b7b',NULL,NULL,NULL,NULL,'2025-11-22 05:52:12',NULL,'2025-11-22 05:52:12',NULL,NULL),(46,NULL,NULL,'fb4203360dfb40e7955f26bfdb414192',NULL,NULL,NULL,NULL,'2025-11-22 05:52:12',NULL,'2025-11-22 05:52:12',NULL,NULL),(47,NULL,NULL,'19063b71466b4a099f4798ea400aed7c',NULL,NULL,NULL,NULL,'2025-11-22 05:52:12',NULL,'2025-11-22 05:52:12',NULL,NULL),(48,NULL,NULL,'2842012f4d774f89af9d1443c26b0fd4',NULL,NULL,NULL,NULL,'2025-11-22 05:52:12',NULL,'2025-11-22 05:52:12',NULL,NULL),(49,NULL,'fffa744c2146473ab31df119246a9181',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:15',NULL,'2025-11-22 05:52:15',NULL,NULL),(50,NULL,'b3ac762e6feb4232bd54d8a8c440901d',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:15',NULL,'2025-11-22 05:52:15',NULL,NULL),(51,NULL,'13ecd2dee6214669bc9c0e8a73e81158',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:17',NULL,'2025-11-22 05:52:17',NULL,NULL),(52,NULL,'1218c5e5dd6949df8f550c000dc3c24e',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:19',NULL,'2025-11-22 05:52:19',NULL,NULL),(53,NULL,NULL,'e39ba151148a410c9394932912279325',NULL,NULL,NULL,NULL,'2025-11-22 05:52:21',NULL,'2025-11-22 05:52:21',NULL,NULL),(54,NULL,'211abdbf41b04d87abcf9b04bbca8f54',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:22',NULL,'2025-11-22 05:52:22',NULL,NULL),(55,NULL,NULL,'ca8cffb070a549e3b3a19f34d69fb809',NULL,NULL,NULL,NULL,'2025-11-22 05:52:23',NULL,'2025-11-22 05:52:23',NULL,NULL),(56,NULL,'161410e8e68843c498c108a7c907faa9',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:24',NULL,'2025-11-22 05:52:24',NULL,NULL),(57,NULL,NULL,'3ca1144a55894a528a97f0906826d387',NULL,NULL,NULL,NULL,'2025-11-22 05:52:26',NULL,'2025-11-22 05:52:26',NULL,NULL),(58,NULL,NULL,'b876f51906054df2b6f8b2b2463b4cdd',NULL,NULL,NULL,NULL,'2025-11-22 05:52:28',NULL,'2025-11-22 05:52:28',NULL,NULL),(59,NULL,'1d43ad7bfa6f468cb936112ef76b83ec',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:28',NULL,'2025-11-22 05:52:28',NULL,NULL),(60,NULL,NULL,'74e34628f3024fd4a8bec2b3a4155803',NULL,NULL,NULL,NULL,'2025-11-22 05:52:28',NULL,'2025-11-22 05:52:28',NULL,NULL),(61,NULL,NULL,'b4ca90b3dd1046abbcde2a855f0f5a21',NULL,NULL,NULL,NULL,'2025-11-22 05:52:28',NULL,'2025-11-22 05:52:28',NULL,NULL),(62,NULL,NULL,'faf54e45b1fd4aeea14174a0e52f7a75',NULL,NULL,NULL,NULL,'2025-11-22 05:52:28',NULL,'2025-11-22 05:52:28',NULL,NULL),(63,NULL,NULL,'8810afe3e7cc4517816850546d149121',NULL,NULL,NULL,NULL,'2025-11-22 05:52:29',NULL,'2025-11-22 05:52:29',NULL,NULL),(64,NULL,'31d8050861d5467cbb856cbc78273d7b',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:30',NULL,'2025-11-22 05:52:30',NULL,NULL),(65,NULL,'0271786406c9484690d4bd37f69403cd',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:31',NULL,'2025-11-22 05:52:31',NULL,NULL),(66,NULL,NULL,'da8b56e53e0b4b21a8b9a579475a6d04',NULL,NULL,NULL,NULL,'2025-11-22 05:52:33',NULL,'2025-11-22 05:52:33',NULL,NULL),(67,NULL,'40e48f9772f24f8381b61a67f36c24f5',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:33',NULL,'2025-11-22 05:52:33',NULL,NULL),(68,NULL,NULL,'6287ff482a9b4c6688955b724f4fc425',NULL,NULL,NULL,NULL,'2025-11-22 05:52:33',NULL,'2025-11-22 05:52:33',NULL,NULL),(69,NULL,NULL,'cb3dd5710b0d430693a3df0f142e4ed2',NULL,NULL,NULL,NULL,'2025-11-22 05:52:33',NULL,'2025-11-22 05:52:33',NULL,NULL),(70,NULL,NULL,'b6020cfaec224c6989de1be7e4ee8cd0',NULL,NULL,NULL,NULL,'2025-11-22 05:52:34',NULL,'2025-11-22 05:52:34',NULL,NULL),(71,NULL,'37b6389e0b8c44d58693f909304c85f3',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:34',NULL,'2025-11-22 05:52:34',NULL,NULL),(72,NULL,NULL,'fbc11814d7574b4f8e6c092a50cbf082',NULL,NULL,NULL,NULL,'2025-11-22 05:52:35',NULL,'2025-11-22 05:52:35',NULL,NULL),(73,NULL,NULL,'1b9a35ff0c0c4cfdaec6030846fb6693',NULL,NULL,NULL,NULL,'2025-11-22 05:52:35',NULL,'2025-11-22 05:52:35',NULL,NULL),(74,NULL,NULL,'257b8dd433da437cb1782988769d0f28',NULL,NULL,NULL,NULL,'2025-11-22 05:52:35',NULL,'2025-11-22 05:52:35',NULL,NULL),(75,NULL,'b54790910ea74dd58100f271c112d272',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:35',NULL,'2025-11-22 05:52:35',NULL,NULL),(76,NULL,'0ad53f5f41864ff1b88c0e4a143a9d80',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:36',NULL,'2025-11-22 05:52:36',NULL,NULL),(77,NULL,'d1fac9ac1ce14feea883b2871ca5ee2d',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:36',NULL,'2025-11-22 05:52:36',NULL,NULL),(78,NULL,NULL,'0c21efc18f534ea5a7a89f1937e589da',NULL,NULL,NULL,NULL,'2025-11-22 05:52:37',NULL,'2025-11-22 05:52:37',NULL,NULL),(79,NULL,'a2a903a71ccf4800b0319560700dcf4f',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:37',NULL,'2025-11-22 05:52:37',NULL,NULL),(80,NULL,'ff1316287a9a46299cf564fdebe902b8',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:38',NULL,'2025-11-22 05:52:38',NULL,NULL),(81,NULL,NULL,'7bcfc99e3c244126816225b77ed5d231',NULL,NULL,NULL,NULL,'2025-11-22 05:52:39',NULL,'2025-11-22 05:52:39',NULL,NULL),(82,NULL,NULL,'af459d3bfab542f0ba439ea8268737f8',NULL,NULL,NULL,NULL,'2025-11-22 05:52:40',NULL,'2025-11-22 05:52:40',NULL,NULL),(83,NULL,'5d0aa082942c4645b7d683fa196ab106',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:40',NULL,'2025-11-22 05:52:40',NULL,NULL),(84,NULL,'09a9bc39855745bf8d5b80d4da01cbc0',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:41',NULL,'2025-11-22 05:52:41',NULL,NULL),(85,NULL,NULL,'6e63bd1de4a84e4fbf8d2e82eaee42e5',NULL,NULL,NULL,NULL,'2025-11-22 05:52:42',NULL,'2025-11-22 05:52:42',NULL,NULL),(86,NULL,NULL,'552e441dcd0145a7801b66283b6ccb6b',NULL,NULL,NULL,NULL,'2025-11-22 05:52:42',NULL,'2025-11-22 05:52:42',NULL,NULL),(87,NULL,NULL,'530bb08cc2fa42d8802f1bf367834ff5',NULL,NULL,NULL,NULL,'2025-11-22 05:52:42',NULL,'2025-11-22 05:52:42',NULL,NULL),(88,NULL,'734c5b7426984f15b44b207f0f806f0e',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:43',NULL,'2025-11-22 05:52:43',NULL,NULL),(89,NULL,'46695bd861444caba892d1e29b5c28bf',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:44',NULL,'2025-11-22 05:52:44',NULL,NULL),(90,NULL,NULL,'625f00565232408d9cf383ec8a96edab',NULL,NULL,NULL,NULL,'2025-11-22 05:52:45',NULL,'2025-11-22 05:52:45',NULL,NULL),(91,NULL,'95c9cad9091b471ba48543a0aea5f870',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:45',NULL,'2025-11-22 05:52:45',NULL,NULL),(92,NULL,'a4d13c902935400e9d74b443a3eb1e97',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:46',NULL,'2025-11-22 05:52:46',NULL,NULL),(93,NULL,NULL,'1e8c5395a8b04586af3fb78035526085',NULL,NULL,NULL,NULL,'2025-11-22 05:52:52',NULL,'2025-11-22 05:52:52',NULL,NULL),(94,NULL,NULL,'b50a19e93d264512a461af96b2a15f43',NULL,NULL,NULL,NULL,'2025-11-22 05:52:53',NULL,'2025-11-22 05:52:53',NULL,NULL),(95,NULL,NULL,'3c2811adb16748849d19c8510977dadd',NULL,NULL,NULL,NULL,'2025-11-22 05:52:54',NULL,'2025-11-22 05:52:54',NULL,NULL),(96,NULL,NULL,'647afc0ff5f444308e1592564e4a3a6b',NULL,NULL,NULL,NULL,'2025-11-22 05:52:54',NULL,'2025-11-22 05:52:54',NULL,NULL),(97,NULL,NULL,'8bdb01da9c6746e38ee0de4f4060537a',NULL,NULL,NULL,NULL,'2025-11-22 05:52:54',NULL,'2025-11-22 05:52:54',NULL,NULL),(98,NULL,'3693ab5a382149b390d875d0bd0cb402',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:55',NULL,'2025-11-22 05:52:55',NULL,NULL),(99,NULL,NULL,'b1ca6afe9d5f43abb0904b7191d5c731',NULL,NULL,NULL,NULL,'2025-11-22 05:52:56',NULL,'2025-11-22 05:52:56',NULL,NULL),(100,NULL,NULL,'52a75b1ac7564357aca44608d1a6d017',NULL,NULL,NULL,NULL,'2025-11-22 05:52:56',NULL,'2025-11-22 05:52:56',NULL,NULL),(101,NULL,'7739e3aecf234c8e9eb1fd5ba20d1470',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:56',NULL,'2025-11-22 05:52:56',NULL,NULL),(102,NULL,NULL,'7b35a5763e3a490b90ea39b5f4299609',NULL,NULL,NULL,NULL,'2025-11-22 05:52:56',NULL,'2025-11-22 05:52:56',NULL,NULL),(103,NULL,'1395b514e70345f7b684d6d1d3c6fbd6',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:57',NULL,'2025-11-22 05:52:57',NULL,NULL),(104,NULL,'cd96d5de7b9b46d7b199ed7ff76cc882',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:57',NULL,'2025-11-22 05:52:57',NULL,NULL),(105,NULL,'311b874790554a40ab7de4185b462831',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:58',NULL,'2025-11-22 05:52:58',NULL,NULL),(106,NULL,'0e8baa99d2a34ced8e95c9d3736c9dcd',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:52:59',NULL,'2025-11-22 05:52:59',NULL,NULL),(107,NULL,NULL,'50f50b236ad14a3cbbab823bccc30541',NULL,NULL,NULL,NULL,'2025-11-22 05:52:59',NULL,'2025-11-22 05:52:59',NULL,NULL),(108,NULL,'40aa9b7902bc4328b7673280cd4e072f',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:53:00',NULL,'2025-11-22 05:53:00',NULL,NULL),(109,NULL,NULL,'ef7d0239b371479f81b35f2be9a14e42',NULL,NULL,NULL,NULL,'2025-11-22 05:53:01',NULL,'2025-11-22 05:53:01',NULL,NULL),(110,NULL,'494ee20b4e4a4b78b9183dfeead96d6c',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:53:02',NULL,'2025-11-22 05:53:02',NULL,NULL),(111,NULL,NULL,'aa395f9ef74c4f909b82a2a199b42ae0',NULL,NULL,NULL,NULL,'2025-11-22 05:53:03',NULL,'2025-11-22 05:53:03',NULL,NULL),(112,NULL,'be3bb51f527246a7aa1656daf4f3064b',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:53:04',NULL,'2025-11-22 05:53:04',NULL,NULL),(113,NULL,NULL,'2a79d2f457754ed1ac666bbfadb1c676',NULL,NULL,NULL,NULL,'2025-11-22 05:53:04',NULL,'2025-11-22 05:53:04',NULL,NULL),(114,NULL,'25e6b38f94b44b668c94c0b2b636800c',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:53:06',NULL,'2025-11-22 05:53:06',NULL,NULL),(115,NULL,NULL,'670c0feba3bf42fca9b1f40b483e8bbe',NULL,NULL,NULL,NULL,'2025-11-22 05:53:08',NULL,'2025-11-22 05:53:08',NULL,NULL),(116,NULL,'84c23b2f436e432facef6a82ad930f5e',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:53:09',NULL,'2025-11-22 05:53:09',NULL,NULL),(117,NULL,NULL,'4de5adb2861b4b3fbe992445b625cad4',NULL,NULL,NULL,NULL,'2025-11-22 05:53:10',NULL,'2025-11-22 05:53:10',NULL,NULL),(118,NULL,'c3e25870be384f238bccdf6c103762a8',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:53:11',NULL,'2025-11-22 05:53:11',NULL,NULL),(119,NULL,NULL,'c125077b01fc41719039b560d803d946',NULL,NULL,NULL,NULL,'2025-11-22 05:53:13',NULL,'2025-11-22 05:53:13',NULL,NULL),(120,NULL,'335e21f0289449be93662857e69ffd4e',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:53:15',NULL,'2025-11-22 05:53:15',NULL,NULL),(121,NULL,NULL,'93e1aef7005949e7a52f4a2ea4560587',NULL,NULL,NULL,NULL,'2025-11-22 05:53:22',NULL,'2025-11-22 05:53:22',NULL,NULL),(122,NULL,NULL,'e136c1b06bce4b998a5350385e9229ad',NULL,NULL,NULL,NULL,'2025-11-22 05:53:24',NULL,'2025-11-22 05:53:24',NULL,NULL),(123,NULL,NULL,'d8f03b5718b045adbc9a577ce80ce1ab',NULL,NULL,NULL,NULL,'2025-11-22 05:53:24',NULL,'2025-11-22 05:53:24',NULL,NULL),(124,NULL,NULL,'4570100ddc254ff9b5862efc6d066265',NULL,NULL,NULL,NULL,'2025-11-22 05:53:24',NULL,'2025-11-22 05:53:24',NULL,NULL),(125,NULL,'b9af8b3d531f47c59702cdfaedac3564',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:53:26',NULL,'2025-11-22 05:53:26',NULL,NULL),(126,NULL,'c16b253430cb40f6bf0f328197748aef',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:53:29',NULL,'2025-11-22 05:53:29',NULL,NULL),(127,NULL,'b59c82aac0154932bb0672ff00781e5f',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:53:30',NULL,'2025-11-22 05:53:30',NULL,NULL),(128,NULL,NULL,'6d0a10b28a4b4b85911a061a9d87067a',NULL,NULL,NULL,NULL,'2025-11-22 05:53:37',NULL,'2025-11-22 05:53:37',NULL,NULL),(129,NULL,NULL,'2cbd89b4e8e144fdb68c38558213a200',NULL,NULL,NULL,NULL,'2025-11-22 05:53:37',NULL,'2025-11-22 05:53:37',NULL,NULL),(130,NULL,NULL,'33ce27b557034ebdb023db59e75914df',NULL,NULL,NULL,NULL,'2025-11-22 05:53:37',NULL,'2025-11-22 05:53:37',NULL,NULL),(131,NULL,NULL,'78147ca7963b4b35844fbdfcc4337cd6',NULL,NULL,NULL,NULL,'2025-11-22 05:53:37',NULL,'2025-11-22 05:53:37',NULL,NULL),(132,NULL,'0cf1f7dacb794b85a710e2abe55d8f9f',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:53:38',NULL,'2025-11-22 05:53:38',NULL,NULL),(133,NULL,'436c793ae1fd4a61b93034c46699dd40',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:53:40',NULL,'2025-11-22 05:53:40',NULL,NULL),(134,NULL,'8b152353f2dd4c8296b1ffe17df2c326',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:53:44',NULL,'2025-11-22 05:53:44',NULL,NULL),(135,NULL,NULL,'0d142853064944d78d828c3cf48ae331',NULL,NULL,NULL,NULL,'2025-11-22 05:53:50',NULL,'2025-11-22 05:53:50',NULL,NULL),(136,NULL,NULL,'00ffb1620d684343a7774c92d3428dc5',NULL,NULL,NULL,NULL,'2025-11-22 05:53:50',NULL,'2025-11-22 05:53:50',NULL,NULL),(137,NULL,NULL,'d2acceba21604cdabcb051db4da41f60',NULL,NULL,NULL,NULL,'2025-11-22 05:53:50',NULL,'2025-11-22 05:53:50',NULL,NULL),(138,NULL,NULL,'bcd0882452e747969042c77b5fee6601',NULL,NULL,NULL,NULL,'2025-11-22 05:53:50',NULL,'2025-11-22 05:53:50',NULL,NULL),(139,NULL,'f6d5c9596175477b8cb96cd95cd6bbd0',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:53:51',NULL,'2025-11-22 05:53:51',NULL,NULL),(140,NULL,'aa415a0077424ed589be62218428cbe0',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:53:52',NULL,'2025-11-22 05:53:52',NULL,NULL),(141,NULL,'98718666dd974523b48d01ebc9634c15',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:53:52',NULL,'2025-11-22 05:53:52',NULL,NULL),(142,NULL,NULL,'7205f7cc61cc4a3198cf050c4f63a6ce',NULL,NULL,NULL,NULL,'2025-11-22 05:54:01',NULL,'2025-11-22 05:54:01',NULL,NULL),(143,NULL,NULL,'870bd1c3327f4dd18e76b679754d1a5b',NULL,NULL,NULL,NULL,'2025-11-22 05:54:05',NULL,'2025-11-22 05:54:05',NULL,NULL),(144,NULL,NULL,'9b5bfcdf5ad54171a9698feaa812530a',NULL,NULL,NULL,NULL,'2025-11-22 05:54:06',NULL,'2025-11-22 05:54:06',NULL,NULL),(145,NULL,NULL,'f25ba0090b0044399f5d606ac594c18c',NULL,NULL,NULL,NULL,'2025-11-22 05:54:06',NULL,'2025-11-22 05:54:06',NULL,NULL),(146,NULL,NULL,'523442f54799427d8d74628d9418792d',NULL,NULL,NULL,NULL,'2025-11-22 05:54:06',NULL,'2025-11-22 05:54:06',NULL,NULL),(147,NULL,'91866c01fe054f9186b9551231947995',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:54:07',NULL,'2025-11-22 05:54:07',NULL,NULL),(148,NULL,'be4f43bf8e7f4cbab3da8e42df0990b8',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:54:08',NULL,'2025-11-22 05:54:08',NULL,NULL),(149,NULL,'acb08ef912784bb89000a87c4621bcc9',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:54:09',NULL,'2025-11-22 05:54:09',NULL,NULL),(150,NULL,NULL,'4b85609a97a14802a38f802d5689024d',NULL,NULL,NULL,NULL,'2025-11-22 05:54:12',NULL,'2025-11-22 05:54:12',NULL,NULL),(151,NULL,NULL,'5d1649630f8d474eb362f254f6feea89',NULL,NULL,NULL,NULL,'2025-11-22 05:54:13',NULL,'2025-11-22 05:54:13',NULL,NULL),(152,NULL,NULL,'c0acc593440f4aba93cebeb0a88cf188',NULL,NULL,NULL,NULL,'2025-11-22 05:54:13',NULL,'2025-11-22 05:54:13',NULL,NULL),(153,NULL,'1c76ef654a3e4144bc0a4cdf01f6107d',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:54:14',NULL,'2025-11-22 05:54:14',NULL,NULL),(154,NULL,'dbe9e1615e8e4853bdf9de8105583d83',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:54:16',NULL,'2025-11-22 05:54:16',NULL,NULL),(155,NULL,'732d2a2f4c25425ca4cc55e554c233e6',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:54:17',NULL,'2025-11-22 05:54:17',NULL,NULL),(156,NULL,NULL,'54e641a9522e40ffa67c2ca3c0b53ce6',NULL,NULL,NULL,NULL,'2025-11-22 05:54:18',NULL,'2025-11-22 05:54:18',NULL,NULL),(157,NULL,'a87583242abb48e1ba1f4d9c6aa18a9b',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:54:20',NULL,'2025-11-22 05:54:20',NULL,NULL),(158,NULL,NULL,'82169ba2c9ab4077bf4d259f3eb84696',NULL,NULL,NULL,NULL,'2025-11-22 05:54:22',NULL,'2025-11-22 05:54:22',NULL,NULL),(159,NULL,'31229a75e2604620979283f5cfaf0d50',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:54:24',NULL,'2025-11-22 05:54:24',NULL,NULL),(160,NULL,NULL,'52d0a0dfe293488093357eb07057fca4',NULL,NULL,NULL,NULL,'2025-11-22 05:54:24',NULL,'2025-11-22 05:54:24',NULL,NULL),(161,NULL,'1b61096eae0749d9ab0b8c7942d6e67a',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:54:25',NULL,'2025-11-22 05:54:25',NULL,NULL),(162,NULL,NULL,'f94221c2a5e3465891d5f148610feaf4',NULL,NULL,NULL,NULL,'2025-11-22 05:54:26',NULL,'2025-11-22 05:54:26',NULL,NULL),(163,NULL,'7800ddaccf17496d84421de3d9e05318',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:54:27',NULL,'2025-11-22 05:54:27',NULL,NULL),(164,NULL,NULL,'a0263cd808914e399a3d742107d7bb9f',NULL,NULL,NULL,NULL,'2025-11-22 05:54:28',NULL,'2025-11-22 05:54:28',NULL,NULL),(165,NULL,'8e0c40e8469d4bd29edec4e851001e24',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:54:29',NULL,'2025-11-22 05:54:29',NULL,NULL),(166,NULL,NULL,'f45dcd3dde9f4bbcba5507540c940eab',NULL,NULL,NULL,NULL,'2025-11-22 05:54:29',NULL,'2025-11-22 05:54:29',NULL,NULL),(167,NULL,'16c95fcbfaff469a9d74c5a36743dfa8',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:54:31',NULL,'2025-11-22 05:54:31',NULL,NULL),(168,NULL,NULL,'ed29f75229ed4af6b0c3bb8c36a7a319',NULL,NULL,NULL,NULL,'2025-11-22 05:54:33',NULL,'2025-11-22 05:54:33',NULL,NULL),(169,NULL,'fdeac02e18ee4556abc75d8614a33a75',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:54:34',NULL,'2025-11-22 05:54:34',NULL,NULL),(170,NULL,NULL,'173c992cd57b41129e4899b0ec89cbfb',NULL,NULL,NULL,NULL,'2025-11-22 05:54:37',NULL,'2025-11-22 05:54:37',NULL,NULL),(171,NULL,NULL,'2256793bd84244a3bcb61874a41075c5',NULL,NULL,NULL,NULL,'2025-11-22 05:54:38',NULL,'2025-11-22 05:54:38',NULL,NULL),(172,NULL,NULL,'7f869a53a810441583decc78eb1e4bf6',NULL,NULL,NULL,NULL,'2025-11-22 05:54:38',NULL,'2025-11-22 05:54:38',NULL,NULL),(173,NULL,NULL,'4a3993de61324ab4ae41b5b9d711e3a9',NULL,NULL,NULL,NULL,'2025-11-22 05:54:38',NULL,'2025-11-22 05:54:38',NULL,NULL),(174,NULL,'5c79362f5df94bb7805d87f3cb0f6a70',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:54:40',NULL,'2025-11-22 05:54:40',NULL,NULL),(175,NULL,'6d7e2b9cd5c04d3c983c69aa034b4f6a',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:54:42',NULL,'2025-11-22 05:54:42',NULL,NULL),(176,NULL,'879b9840974d4a5186ae02687052f6dc',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:54:43',NULL,'2025-11-22 05:54:43',NULL,NULL),(177,NULL,NULL,'09af92321b0f4e04bad00172c9f9fb19',NULL,NULL,NULL,NULL,'2025-11-22 05:54:44',NULL,'2025-11-22 05:54:44',NULL,NULL),(178,NULL,NULL,'5cd2161e545848cab1c577034bff12ab',NULL,NULL,NULL,NULL,'2025-11-22 05:54:48',NULL,'2025-11-22 05:54:48',NULL,NULL),(179,NULL,NULL,'6fea0abbe4904f80aadf406534c87545',NULL,NULL,NULL,NULL,'2025-11-22 05:54:48',NULL,'2025-11-22 05:54:48',NULL,NULL),(180,NULL,NULL,'99a128db6f77443bb494723f084cd665',NULL,NULL,NULL,NULL,'2025-11-22 05:54:48',NULL,'2025-11-22 05:54:48',NULL,NULL),(181,NULL,'9367e5aefdaa4751a17776b04c55db48',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:54:49',NULL,'2025-11-22 05:54:49',NULL,NULL),(182,NULL,'ff09e2486e9d4c72b3f5e832bcf1885a',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:54:51',NULL,'2025-11-22 05:54:51',NULL,NULL),(183,NULL,'5c70c7a236504e13924fa96baf0304d6',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:54:52',NULL,'2025-11-22 05:54:52',NULL,NULL),(184,NULL,NULL,'85244f77b80f4db683fa3ae1dde0ead9',NULL,NULL,NULL,NULL,'2025-11-22 05:54:54',NULL,'2025-11-22 05:54:54',NULL,NULL),(185,NULL,'c51a27683bbf4fb1b0ce52d468f129e9',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:54:55',NULL,'2025-11-22 05:54:55',NULL,NULL),(186,NULL,NULL,'b74eb62fd2f5437093ce7f3388f9f287',NULL,NULL,NULL,NULL,'2025-11-22 05:54:58',NULL,'2025-11-22 05:54:58',NULL,NULL),(187,NULL,'8243e5ecac894d3fa981c47a02ce32fe',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:54:59',NULL,'2025-11-22 05:54:59',NULL,NULL),(188,NULL,NULL,'a8578dd582854d24b8bb893e7bf6103d',NULL,NULL,NULL,NULL,'2025-11-22 05:55:08',NULL,'2025-11-22 05:55:08',NULL,NULL),(189,NULL,NULL,'d1673dc79d4b4bb394a077ca6e503d8d',NULL,NULL,NULL,NULL,'2025-11-22 05:55:12',NULL,'2025-11-22 05:55:12',NULL,NULL),(190,NULL,NULL,'0d7e34a4fb664153a6d2ef7a32f1df95',NULL,NULL,NULL,NULL,'2025-11-22 05:55:12',NULL,'2025-11-22 05:55:12',NULL,NULL),(191,NULL,NULL,'a118fe67fdb84bd1bef3675de0af7cc1',NULL,NULL,NULL,NULL,'2025-11-22 05:55:12',NULL,'2025-11-22 05:55:12',NULL,NULL),(192,NULL,NULL,'26ca92a37d7d41e58904a26944c79e14',NULL,NULL,NULL,NULL,'2025-11-22 05:55:12',NULL,'2025-11-22 05:55:12',NULL,NULL),(193,NULL,'8b69dc8609b24a13bee8bd080785898b',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:55:13',NULL,'2025-11-22 05:55:13',NULL,NULL),(194,NULL,'c1bb25e73f4845c0aa83279619d6c189',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:55:13',NULL,'2025-11-22 05:55:13',NULL,NULL),(195,NULL,'a65b8111914243d6b83686b4fec1ab48',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:55:14',NULL,'2025-11-22 05:55:14',NULL,NULL),(196,NULL,'40a20360c41d442b970022c84729e080',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:55:15',NULL,'2025-11-22 05:55:15',NULL,NULL),(197,NULL,NULL,'aeeb6db4cca84045b1983f92ef5d00d4',NULL,NULL,NULL,NULL,'2025-11-22 05:55:16',NULL,'2025-11-22 05:55:16',NULL,NULL),(198,NULL,'c80e33cc19ac431da8cff4de5e82c806',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:55:17',NULL,'2025-11-22 05:55:17',NULL,NULL),(199,NULL,NULL,'18eae05706244908975d19c9bd7020ea',NULL,NULL,NULL,NULL,'2025-11-22 05:55:18',NULL,'2025-11-22 05:55:18',NULL,NULL),(200,NULL,'059447848c6740f5a1fd3574768a8c37',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:55:19',NULL,'2025-11-22 05:55:19',NULL,NULL),(201,NULL,NULL,'fa2d2d3d46b5410f973f8341372101c8',NULL,NULL,NULL,NULL,'2025-11-22 05:55:20',NULL,'2025-11-22 05:55:20',NULL,NULL),(202,NULL,'490d61dc3c6c4a9faba7b923e912c2ce',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:55:21',NULL,'2025-11-22 05:55:21',NULL,NULL),(203,NULL,NULL,'a88463ad7d9d4a8bb491e31a042a3eaf',NULL,NULL,NULL,NULL,'2025-11-22 05:55:21',NULL,'2025-11-22 05:55:21',NULL,NULL),(204,NULL,'08cba4df4bb644768bd0aed90070e988',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:55:23',NULL,'2025-11-22 05:55:23',NULL,NULL),(205,NULL,NULL,'75372f6c434e4f14be3d45ce20a03a84',NULL,NULL,NULL,NULL,'2025-11-22 05:55:29',NULL,'2025-11-22 05:55:29',NULL,NULL),(206,NULL,NULL,'02fe04fccffb4086a89160251945aedb',NULL,NULL,NULL,NULL,'2025-11-22 05:55:30',NULL,'2025-11-22 05:55:30',NULL,NULL),(207,NULL,NULL,'4776a7f281094586887267fdd876e32c',NULL,NULL,NULL,NULL,'2025-11-22 05:55:30',NULL,'2025-11-22 05:55:30',NULL,NULL),(208,NULL,NULL,'a321ed35ead349f68448b551948327b7',NULL,NULL,NULL,NULL,'2025-11-22 05:55:30',NULL,'2025-11-22 05:55:30',NULL,NULL),(209,NULL,'3109e70846824a5ea61dce09df700861',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:55:31',NULL,'2025-11-22 05:55:31',NULL,NULL),(210,NULL,'2383fb06a29045c790fa129f8d0d854c',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:55:32',NULL,'2025-11-22 05:55:32',NULL,NULL),(211,NULL,'a882f8838dba45b9b6138a02e70f3f63',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:55:33',NULL,'2025-11-22 05:55:33',NULL,NULL),(212,NULL,NULL,'8c7fb0fcbbde48199d388fa789cf1773',NULL,NULL,NULL,NULL,'2025-11-22 05:55:39',NULL,'2025-11-22 05:55:39',NULL,NULL),(213,NULL,NULL,'85cdecc3d01f4430b4b2d42235b12283',NULL,NULL,NULL,NULL,'2025-11-22 05:55:39',NULL,'2025-11-22 05:55:39',NULL,NULL),(214,NULL,NULL,'06b7964a6dd9420f91917d919f12a29e',NULL,NULL,NULL,NULL,'2025-11-22 05:55:40',NULL,'2025-11-22 05:55:40',NULL,NULL),(215,NULL,NULL,'384443e1ee1a49bb8f8fe9e53a1a8f55',NULL,NULL,NULL,NULL,'2025-11-22 05:55:40',NULL,'2025-11-22 05:55:40',NULL,NULL),(216,NULL,'38ed23b5848e449b9e9b0e53a7f96916',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:55:41',NULL,'2025-11-22 05:55:41',NULL,NULL),(217,NULL,'3a30a5c5a0f0497d95a109c5526ede86',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:55:42',NULL,'2025-11-22 05:55:42',NULL,NULL),(218,NULL,'46cb16a9efc840e1a76e03a75ef45566',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:55:42',NULL,'2025-11-22 05:55:42',NULL,NULL),(219,NULL,NULL,'c72bf281629c4ea39a1b29159834b0f5',NULL,NULL,NULL,NULL,'2025-11-22 05:55:43',NULL,'2025-11-22 05:55:43',NULL,NULL),(220,NULL,NULL,'6ff7135d6d5e457185aa9a7edd94b865',NULL,NULL,NULL,NULL,'2025-11-22 05:55:44',NULL,'2025-11-22 05:55:44',NULL,NULL),(221,NULL,NULL,'2458340257d941d6b2d0260e7d70dfe3',NULL,NULL,NULL,NULL,'2025-11-22 05:55:44',NULL,'2025-11-22 05:55:44',NULL,NULL),(222,NULL,NULL,'e25e7733a4da46cdae10e9e0e0766198',NULL,NULL,NULL,NULL,'2025-11-22 05:55:44',NULL,'2025-11-22 05:55:44',NULL,NULL),(223,NULL,NULL,'1bc2e5d296ae4602af55b15ab59b060c',NULL,NULL,NULL,NULL,'2025-11-22 05:55:44',NULL,'2025-11-22 05:55:44',NULL,NULL),(224,NULL,'531b9bbdeb2447818ecd6f5fccb66a8a',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:55:46',NULL,'2025-11-22 05:55:46',NULL,NULL),(225,NULL,'bfe9cad3c1b94f29aa1d9587e10f9e85',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:55:47',NULL,'2025-11-22 05:55:47',NULL,NULL),(226,NULL,'d8141c49dc0c4579b08d23f319d4c26b',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:55:47',NULL,'2025-11-22 05:55:47',NULL,NULL),(227,NULL,NULL,'7719270fd38d4d169d5377976a73002c',NULL,NULL,NULL,NULL,'2025-11-22 05:55:51',NULL,'2025-11-22 05:55:51',NULL,NULL),(228,NULL,NULL,'955dc5c233b943d9982d1ee82cd2f0de',NULL,NULL,NULL,NULL,'2025-11-22 05:55:51',NULL,'2025-11-22 05:55:51',NULL,NULL),(229,NULL,NULL,'88456e0431b743db894c04ceb3ace5e2',NULL,NULL,NULL,NULL,'2025-11-22 05:55:51',NULL,'2025-11-22 05:55:51',NULL,NULL),(230,NULL,NULL,'761d6d7a4e6b4519b830d333258d75fe',NULL,NULL,NULL,NULL,'2025-11-22 05:55:52',NULL,'2025-11-22 05:55:52',NULL,NULL),(231,NULL,'f3c6b8540c4340dc9ae98c21d771609d',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:55:53',NULL,'2025-11-22 05:55:53',NULL,NULL),(232,NULL,'b65ccd7e2f5f4f95959c8fb179b60b78',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:55:54',NULL,'2025-11-22 05:55:54',NULL,NULL),(233,NULL,'8a5dc624dc774b379c26dcef4a9b4623',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:55:54',NULL,'2025-11-22 05:55:54',NULL,NULL),(234,NULL,NULL,'eb4a2a9cc4f34eed857eeb1400d6e1e8',NULL,NULL,NULL,NULL,'2025-11-22 05:55:58',NULL,'2025-11-22 05:55:58',NULL,NULL),(235,NULL,NULL,'47d35dbda65c4554a9466657dad531d9',NULL,NULL,NULL,NULL,'2025-11-22 05:55:58',NULL,'2025-11-22 05:55:58',NULL,NULL),(236,NULL,NULL,'2a0e6f59ba964ee387dbb0483a9e44e0',NULL,NULL,NULL,NULL,'2025-11-22 05:55:58',NULL,'2025-11-22 05:55:58',NULL,NULL),(237,NULL,'7c0b4b3107784ce6890ddd12d362ec8e',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:56:00',NULL,'2025-11-22 05:56:00',NULL,NULL),(238,NULL,NULL,'ca69930709004d749343ca0cbb7d2d42',NULL,NULL,NULL,NULL,'2025-11-22 05:56:01',NULL,'2025-11-22 05:56:01',NULL,NULL),(239,NULL,NULL,'7c9e496ca7fd42b3bf6260ac7f2177d6',NULL,NULL,NULL,NULL,'2025-11-22 05:56:02',NULL,'2025-11-22 05:56:02',NULL,NULL),(240,NULL,'525ba1ccf0d546c7b4118a0855306190',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:56:02',NULL,'2025-11-22 05:56:02',NULL,NULL),(241,NULL,NULL,'a34bbd807e12419982150bcdaf94ffac',NULL,NULL,NULL,NULL,'2025-11-22 05:56:02',NULL,'2025-11-22 05:56:02',NULL,NULL),(242,NULL,NULL,'d3bef283cc3b44bd8b73ce62f35a8f0f',NULL,NULL,NULL,NULL,'2025-11-22 05:56:02',NULL,'2025-11-22 05:56:02',NULL,NULL),(243,NULL,'0aa6579c96a246e3aa4d59be19103daa',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:56:05',NULL,'2025-11-22 05:56:05',NULL,NULL),(244,NULL,'02017debc0a446e3986f15039b077219',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:56:06',NULL,'2025-11-22 05:56:06',NULL,NULL),(245,NULL,'ee8dad2205134ba8bbd2c87a78a99b8b',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:56:06',NULL,'2025-11-22 05:56:06',NULL,NULL),(246,NULL,'fe21b9b15c3d454980c4e70e49f2eb68',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:56:07',NULL,'2025-11-22 05:56:07',NULL,NULL),(247,NULL,NULL,'3020f64f4acb434c8af97c0cab7fdbf5',NULL,NULL,NULL,NULL,'2025-11-22 05:56:10',NULL,'2025-11-22 05:56:10',NULL,NULL),(248,NULL,NULL,'ea75f7805c74403093c0bd716bebcc3e',NULL,NULL,NULL,NULL,'2025-11-22 05:56:11',NULL,'2025-11-22 05:56:11',NULL,NULL),(249,NULL,NULL,'ed928bd6af024a01bd97b48bb1b09ad8',NULL,NULL,NULL,NULL,'2025-11-22 05:56:12',NULL,'2025-11-22 05:56:12',NULL,NULL),(250,NULL,NULL,'b28c885d57f2488097d1e4b3d8a8a501',NULL,NULL,NULL,NULL,'2025-11-22 05:56:12',NULL,'2025-11-22 05:56:12',NULL,NULL),(251,NULL,NULL,'6fa22491224548c38451bde2851e8818',NULL,NULL,NULL,NULL,'2025-11-22 05:56:13',NULL,'2025-11-22 05:56:13',NULL,NULL),(252,NULL,NULL,'46b47f98639946d58f55c61866602751',NULL,NULL,NULL,NULL,'2025-11-22 05:56:13',NULL,'2025-11-22 05:56:13',NULL,NULL),(253,NULL,'c0e018b4fb70472eb118a16f599c24a2',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:56:14',NULL,'2025-11-22 05:56:14',NULL,NULL),(254,NULL,NULL,'9088ff75a27c420ca8f0a42460400887',NULL,NULL,NULL,NULL,'2025-11-22 05:56:16',NULL,'2025-11-22 05:56:16',NULL,NULL),(255,NULL,NULL,'6029f2c691514a51989980de9269f720',NULL,NULL,NULL,NULL,'2025-11-22 05:56:16',NULL,'2025-11-22 05:56:16',NULL,NULL),(256,NULL,'3cc17867ee9b4740b16018143bd56f95',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:56:16',NULL,'2025-11-22 05:56:16',NULL,NULL),(257,NULL,NULL,'3c56592d4dde40b499f485bd51beb21c',NULL,NULL,NULL,NULL,'2025-11-22 05:56:16',NULL,'2025-11-22 05:56:16',NULL,NULL),(258,NULL,'a7c23ffa634d48acb2f4fa428e2c4a14',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:56:17',NULL,'2025-11-22 05:56:17',NULL,NULL),(259,NULL,'dd784be88065421c852edccf31991712',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:56:17',NULL,'2025-11-22 05:56:17',NULL,NULL),(260,NULL,'64f4d6da348045c096dff252b20399cd',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:56:18',NULL,'2025-11-22 05:56:18',NULL,NULL),(261,NULL,'94bcd246264e4a03b75056b04f28dee8',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:56:19',NULL,'2025-11-22 05:56:19',NULL,NULL),(262,NULL,NULL,'792eb314397e4cddb307e3eabbf1d21d',NULL,NULL,NULL,NULL,'2025-11-22 05:56:21',NULL,'2025-11-22 05:56:21',NULL,NULL),(263,NULL,NULL,'e170cfa7c2f2440bbae8efb22d30acde',NULL,NULL,NULL,NULL,'2025-11-22 05:56:22',NULL,'2025-11-22 05:56:22',NULL,NULL),(264,NULL,NULL,'d43621ccbf0e4685a85e5bac548d78dc',NULL,NULL,NULL,NULL,'2025-11-22 05:56:22',NULL,'2025-11-22 05:56:22',NULL,NULL),(265,NULL,NULL,'3df98b41e5e34245b00fb791fcf174af',NULL,NULL,NULL,NULL,'2025-11-22 05:56:22',NULL,'2025-11-22 05:56:22',NULL,NULL),(266,NULL,NULL,'4747139915be4f5fb034aeac6b9fbfdd',NULL,NULL,NULL,NULL,'2025-11-22 05:56:23',NULL,'2025-11-22 05:56:23',NULL,NULL),(267,NULL,NULL,'4d4e495e2af243dba0ae1d8c430fed71',NULL,NULL,NULL,NULL,'2025-11-22 05:56:23',NULL,'2025-11-22 05:56:23',NULL,NULL),(268,NULL,NULL,'5b284155460b48b9bb190f00da04fd97',NULL,NULL,NULL,NULL,'2025-11-22 05:56:23',NULL,'2025-11-22 05:56:23',NULL,NULL),(269,NULL,NULL,'2c0ec8912c3f48e388ea99b19b30ab3a',NULL,NULL,NULL,NULL,'2025-11-22 05:56:23',NULL,'2025-11-22 05:56:23',NULL,NULL),(270,NULL,'a9eb0f2039954be892a0f722898ce89b',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:56:24',NULL,'2025-11-22 05:56:24',NULL,NULL),(271,NULL,'886460d00cb74802b00e3a2cf23dddfc',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:56:24',NULL,'2025-11-22 05:56:24',NULL,NULL),(272,NULL,'28e34d7770534eef833f8c3f7069a4f5',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:56:25',NULL,'2025-11-22 05:56:25',NULL,NULL),(273,NULL,'3520b2bd18fe4bc198c9b3ae61849514',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:56:27',NULL,'2025-11-22 05:56:27',NULL,NULL),(274,NULL,'7de07cd0302d4e9686a19818b2d5f0e8',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:56:28',NULL,'2025-11-22 05:56:28',NULL,NULL),(275,NULL,'b11ef49ab5944ad19989b6af7b7b6ad0',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:56:28',NULL,'2025-11-22 05:56:28',NULL,NULL),(276,NULL,NULL,'da7e1014c61944d2888458963ee6ce85',NULL,NULL,NULL,NULL,'2025-11-22 05:56:33',NULL,'2025-11-22 05:56:33',NULL,NULL),(277,NULL,'e901221ae3e949c0a2f21b3f827f2f92',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:56:34',NULL,'2025-11-22 05:56:34',NULL,NULL),(278,NULL,NULL,'320a1f2b783b4d28a2fc48543a30f6c1',NULL,NULL,NULL,NULL,'2025-11-22 05:56:50',NULL,'2025-11-22 05:56:50',NULL,NULL),(279,NULL,NULL,'ff11a55c494c4d8587c6435d27704abd',NULL,NULL,NULL,NULL,'2025-11-22 05:56:51',NULL,'2025-11-22 05:56:51',NULL,NULL),(280,NULL,NULL,'4f5c8a8f5caa48388ab293352413b72b',NULL,NULL,NULL,NULL,'2025-11-22 05:56:51',NULL,'2025-11-22 05:56:51',NULL,NULL),(281,NULL,NULL,'b5ef712d78b248778af4ee33ff17fcc9',NULL,NULL,NULL,NULL,'2025-11-22 05:56:51',NULL,'2025-11-22 05:56:51',NULL,NULL),(282,NULL,'faf3355c8660499394277773bc5931cb',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:56:53',NULL,'2025-11-22 05:56:53',NULL,NULL),(283,NULL,'0cb5c96c52bc4e89961346306e373479',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:56:54',NULL,'2025-11-22 05:56:54',NULL,NULL),(284,NULL,'5e7ce84e07a04de3afc0e815899f8ebf',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:56:56',NULL,'2025-11-22 05:56:56',NULL,NULL),(285,NULL,NULL,'c6c650722a14414d87efeb7d7cb1719e',NULL,NULL,NULL,NULL,'2025-11-22 05:57:17',NULL,'2025-11-22 05:57:17',NULL,NULL),(286,NULL,NULL,'2c8ae73c40354824a24d5be674999f62',NULL,NULL,NULL,NULL,'2025-11-22 05:57:19',NULL,'2025-11-22 05:57:19',NULL,NULL),(287,NULL,NULL,'c2522b58eb254cf58002dcb519ab137d',NULL,NULL,NULL,NULL,'2025-11-22 05:57:19',NULL,'2025-11-22 05:57:19',NULL,NULL),(288,NULL,NULL,'55f40bdc7df24340bb1bf2da95e74a45',NULL,NULL,NULL,NULL,'2025-11-22 05:57:19',NULL,'2025-11-22 05:57:19',NULL,NULL),(289,NULL,NULL,'1fcc0ff86d734510b0657f8d102dc3a0',NULL,NULL,NULL,NULL,'2025-11-22 05:57:20',NULL,'2025-11-22 05:57:20',NULL,NULL),(290,NULL,'83d9ee2c7bee42d4bba0e955f1c2e648',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:57:21',NULL,'2025-11-22 05:57:21',NULL,NULL),(291,NULL,'f0fc42a3cd4a4e75942e7132887f268d',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:57:22',NULL,'2025-11-22 05:57:22',NULL,NULL),(292,NULL,'5b579aa4ecfd4425bad6a411239dea70',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:57:22',NULL,'2025-11-22 05:57:22',NULL,NULL),(293,NULL,NULL,'57c41b494bbf4fa981ed6b0fa212fa71',NULL,NULL,NULL,NULL,'2025-11-22 05:57:32',NULL,'2025-11-22 05:57:32',NULL,NULL),(294,NULL,NULL,'0c3f51bcae6a47d3a0cab534f30f00e9',NULL,NULL,NULL,NULL,'2025-11-22 05:57:32',NULL,'2025-11-22 05:57:32',NULL,NULL),(295,NULL,NULL,'7ac92d6182b041698b7a1cc6bef65361',NULL,NULL,NULL,NULL,'2025-11-22 05:57:32',NULL,'2025-11-22 05:57:32',NULL,NULL),(296,NULL,NULL,'8290a51dcade4c6fa5553a9ee8c92585',NULL,NULL,NULL,NULL,'2025-11-22 05:57:33',NULL,'2025-11-22 05:57:33',NULL,NULL),(297,NULL,NULL,'bb87deb5a1784d73a900c6569e07129e',NULL,NULL,NULL,NULL,'2025-11-22 05:57:33',NULL,'2025-11-22 05:57:33',NULL,NULL),(298,NULL,'0147967d0f0a4653a0b3ed23aa495186',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:57:34',NULL,'2025-11-22 05:57:34',NULL,NULL),(299,NULL,'720abf9372534dd98f9029f932d01760',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:57:35',NULL,'2025-11-22 05:57:35',NULL,NULL),(300,NULL,'3ecbc36cc7f84bac8557dd18782914fa',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:57:36',NULL,'2025-11-22 05:57:36',NULL,NULL),(301,NULL,NULL,'58186e0ac2da4d539ba489a92270cb59',NULL,NULL,NULL,NULL,'2025-11-22 05:57:38',NULL,'2025-11-22 05:57:38',NULL,NULL),(302,NULL,NULL,'f75a0109975646e3acf66b53ba08f2fa',NULL,NULL,NULL,NULL,'2025-11-22 05:57:38',NULL,'2025-11-22 05:57:38',NULL,NULL),(303,NULL,NULL,'dc28907a97454b8b807fb16e0d4a4013',NULL,NULL,NULL,NULL,'2025-11-22 05:57:38',NULL,'2025-11-22 05:57:38',NULL,NULL),(304,NULL,'dff9649873e14853a686b8d07ee3079c',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:57:39',NULL,'2025-11-22 05:57:39',NULL,NULL),(305,NULL,'db75a1944ad845ea9c7d9708d52f1e25',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:57:40',NULL,'2025-11-22 05:57:40',NULL,NULL),(306,NULL,'6186fafe1c05452882a44689905c2488',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:57:41',NULL,'2025-11-22 05:57:41',NULL,NULL),(307,NULL,NULL,'4f85433201d04888bcc39d25d445fdd5',NULL,NULL,NULL,NULL,'2025-11-22 05:57:43',NULL,'2025-11-22 05:57:43',NULL,NULL),(308,NULL,NULL,'e804cf7e6a8d4e25af4b8a9ca0b7b7e7',NULL,NULL,NULL,NULL,'2025-11-22 05:57:44',NULL,'2025-11-22 05:57:44',NULL,NULL),(309,NULL,NULL,'352a935982234db49d86d1b97e1ecf23',NULL,NULL,NULL,NULL,'2025-11-22 05:57:44',NULL,'2025-11-22 05:57:44',NULL,NULL),(310,NULL,NULL,'af1501fddead40b9b6949968b4814e14',NULL,NULL,NULL,NULL,'2025-11-22 05:57:44',NULL,'2025-11-22 05:57:44',NULL,NULL),(311,NULL,'dc8f2a20469e49568849fdc83403b700',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:57:45',NULL,'2025-11-22 05:57:45',NULL,NULL),(312,NULL,NULL,'ead9df4706b64fe784f14723355f1161',NULL,NULL,NULL,NULL,'2025-11-22 05:57:46',NULL,'2025-11-22 05:57:46',NULL,NULL),(313,NULL,NULL,'02d63c20880d440aa1b33aa4889e3e36',NULL,NULL,NULL,NULL,'2025-11-22 05:57:46',NULL,'2025-11-22 05:57:46',NULL,NULL),(314,NULL,NULL,'666a1fb0961b448999721e8b40e8467a',NULL,NULL,NULL,NULL,'2025-11-22 05:57:46',NULL,'2025-11-22 05:57:46',NULL,NULL),(315,NULL,NULL,'093f9196e58446a9b6b2cdc60cc3a6ce',NULL,NULL,NULL,NULL,'2025-11-22 05:57:47',NULL,'2025-11-22 05:57:47',NULL,NULL),(316,NULL,'89b9c9285d294df09d2937630f6fe1e9',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:57:47',NULL,'2025-11-22 05:57:47',NULL,NULL),(317,NULL,'9664510098444441a79421f7b83cdc3b',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:57:48',NULL,'2025-11-22 05:57:48',NULL,NULL),(318,NULL,'55f1c531e4e74b508fefefaddb96a084',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:57:48',NULL,'2025-11-22 05:57:48',NULL,NULL),(319,NULL,'ce48439825c24d60b0b0f9fe9bb78f02',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:57:50',NULL,'2025-11-22 05:57:50',NULL,NULL),(320,NULL,'3fa68a5c9e304227b436093a7102cbea',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:57:51',NULL,'2025-11-22 05:57:51',NULL,NULL),(321,NULL,NULL,'56ebeec0b3d1437cb9eb371b54fbb446',NULL,NULL,NULL,NULL,'2025-11-22 05:57:53',NULL,'2025-11-22 05:57:53',NULL,NULL),(322,NULL,'66d4d844c08143798de395f115e110f0',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:57:54',NULL,'2025-11-22 05:57:54',NULL,NULL),(323,NULL,NULL,'82f97fe4ae1d4640bc88b2ebac597a31',NULL,NULL,NULL,NULL,'2025-11-22 05:58:07',NULL,'2025-11-22 05:58:07',NULL,NULL),(324,NULL,NULL,'85b06cd64746426188d69928ccf28eb0',NULL,NULL,NULL,NULL,'2025-11-22 05:58:15',NULL,'2025-11-22 05:58:15',NULL,NULL),(325,NULL,NULL,'2c9da9e2e97a4ccf9a4f895a56290c61',NULL,NULL,NULL,NULL,'2025-11-22 05:58:15',NULL,'2025-11-22 05:58:15',NULL,NULL),(326,NULL,NULL,'15d0f4cb527d471b88d6986b7cd8fb27',NULL,NULL,NULL,NULL,'2025-11-22 05:58:15',NULL,'2025-11-22 05:58:15',NULL,NULL),(327,NULL,'d8248996bd5e41039453878368b1e568',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:58:16',NULL,'2025-11-22 05:58:16',NULL,NULL),(328,NULL,NULL,'1b2e8d35350d4e4ea31f6988cb150958',NULL,NULL,NULL,NULL,'2025-11-22 05:58:16',NULL,'2025-11-22 05:58:16',NULL,NULL),(329,NULL,NULL,'c85f7bcc3e4d40d2bc0e6a37832e885d',NULL,NULL,NULL,NULL,'2025-11-22 05:58:17',NULL,'2025-11-22 05:58:17',NULL,NULL),(330,NULL,NULL,'593b29f65aaf4f4a801e9beed799cb4f',NULL,NULL,NULL,NULL,'2025-11-22 05:58:17',NULL,'2025-11-22 05:58:17',NULL,NULL),(331,NULL,'fab76ed5d22a49d0be1474f6fe848948',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:58:17',NULL,'2025-11-22 05:58:17',NULL,NULL),(332,NULL,NULL,'398a572de4ff4da6bc10e6f68f2e6554',NULL,NULL,NULL,NULL,'2025-11-22 05:58:17',NULL,'2025-11-22 05:58:17',NULL,NULL),(333,NULL,'e6bd63b1fa1d4232bc5b16d3b364d109',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:58:18',NULL,'2025-11-22 05:58:18',NULL,NULL),(334,NULL,'8179302d26964c999cd5f9a55ba9d33b',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:58:19',NULL,'2025-11-22 05:58:19',NULL,NULL),(335,NULL,'ab7aba755746417c955e8be055f087e4',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:58:19',NULL,'2025-11-22 05:58:19',NULL,NULL),(336,NULL,'c2dd9a66f4384f32a604e8bf6cfe4e13',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:58:20',NULL,'2025-11-22 05:58:20',NULL,NULL),(337,NULL,NULL,'135e060c52fc44c48e7f3dea40fb7352',NULL,NULL,NULL,NULL,'2025-11-22 05:58:24',NULL,'2025-11-22 05:58:24',NULL,NULL),(338,NULL,'b69436f6d3194929ace36172443c8bfa',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:58:25',NULL,'2025-11-22 05:58:25',NULL,NULL),(339,NULL,NULL,'de9e1b9b41ec4799a43241a39e840eec',NULL,NULL,NULL,NULL,'2025-11-22 05:58:33',NULL,'2025-11-22 05:58:33',NULL,NULL),(340,NULL,NULL,'24fb0d558884441cb10eb30c91564aa4',NULL,NULL,NULL,NULL,'2025-11-22 05:58:33',NULL,'2025-11-22 05:58:33',NULL,NULL),(341,NULL,NULL,'f24d802d88cc45d8bbf777a0600cf564',NULL,NULL,NULL,NULL,'2025-11-22 05:58:33',NULL,'2025-11-22 05:58:33',NULL,NULL),(342,NULL,NULL,'94446ed1aefb493389fe52a30cfb018a',NULL,NULL,NULL,NULL,'2025-11-22 05:58:33',NULL,'2025-11-22 05:58:33',NULL,NULL),(343,NULL,'c484b6b1d72f4f8b894b45aab5a4d9c4',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:58:35',NULL,'2025-11-22 05:58:35',NULL,NULL),(344,NULL,'3eda108f2172495eaa21419323938cf5',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:58:37',NULL,'2025-11-22 05:58:37',NULL,NULL),(345,NULL,NULL,'4a89caa01b82466ba5d8fd4a7a8ef38a',NULL,NULL,NULL,NULL,'2025-11-22 05:58:38',NULL,'2025-11-22 05:58:38',NULL,NULL),(346,NULL,'fc450b360ff64fcd95336520a3e8921d',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:58:39',NULL,'2025-11-22 05:58:39',NULL,NULL),(347,NULL,NULL,'4cb3f9c4072c4e558f4e89dc3002ce2d',NULL,NULL,NULL,NULL,'2025-11-22 05:58:45',NULL,'2025-11-22 05:58:45',NULL,NULL),(348,NULL,NULL,'73d5416422e14a85882b9d89bbbdcd20',NULL,NULL,NULL,NULL,'2025-11-22 05:58:46',NULL,'2025-11-22 05:58:46',NULL,NULL),(349,NULL,NULL,'4afb7ec93c8c4f8a87312c8005672b0c',NULL,NULL,NULL,NULL,'2025-11-22 05:58:46',NULL,'2025-11-22 05:58:46',NULL,NULL),(350,NULL,'1304502ff2bf4fc2bce849d08526f92d',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:58:47',NULL,'2025-11-22 05:58:47',NULL,NULL),(351,NULL,NULL,'031163d79e6e47ffaa26a3e0749b7791',NULL,NULL,NULL,NULL,'2025-11-22 05:58:48',NULL,'2025-11-22 05:58:48',NULL,NULL),(352,NULL,'48e7dd05bf8c4b088cb43187a48dc2f7',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:58:48',NULL,'2025-11-22 05:58:48',NULL,NULL),(353,NULL,'c7b71c24861c4d149532dbaefda1859f',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:58:50',NULL,'2025-11-22 05:58:50',NULL,NULL),(354,NULL,NULL,'46eb6f2a6c3142ecabeda16822197f1b',NULL,NULL,NULL,NULL,'2025-11-22 05:58:57',NULL,'2025-11-22 05:58:57',NULL,NULL),(355,NULL,NULL,'8b158ab1d8b44dc1bf495e2af2103895',NULL,NULL,NULL,NULL,'2025-11-22 05:58:57',NULL,'2025-11-22 05:58:57',NULL,NULL),(356,NULL,NULL,'4bd165ff93fb4aefb992ce1c555ae501',NULL,NULL,NULL,NULL,'2025-11-22 05:58:58',NULL,'2025-11-22 05:58:58',NULL,NULL),(357,NULL,NULL,'18142ce1b96646f3a5ab07296d723869',NULL,NULL,NULL,NULL,'2025-11-22 05:58:58',NULL,'2025-11-22 05:58:58',NULL,NULL),(358,NULL,NULL,'120367c7d9ec45569159d69c691c775d',NULL,NULL,NULL,NULL,'2025-11-22 05:58:59',NULL,'2025-11-22 05:58:59',NULL,NULL),(359,NULL,NULL,'3f8e796df1344773ba704c2944e74e59',NULL,NULL,NULL,NULL,'2025-11-22 05:58:59',NULL,'2025-11-22 05:58:59',NULL,NULL),(360,NULL,NULL,'f74db926f11e414bb45a8d027b6ac2ed',NULL,NULL,NULL,NULL,'2025-11-22 05:58:59',NULL,'2025-11-22 05:58:59',NULL,NULL),(361,NULL,'30ca8082a05f4e07a87814b0f09ad133',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:58:59',NULL,'2025-11-22 05:58:59',NULL,NULL),(362,NULL,'e65f606f7acd4fe283cae503a5bcb4dd',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:59:00',NULL,'2025-11-22 05:59:00',NULL,NULL),(363,NULL,'778e509654744831ae5d233a4539cf97',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:59:01',NULL,'2025-11-22 05:59:01',NULL,NULL),(364,NULL,'e18a5109febf4bd087c02e8de9e14d0b',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:59:01',NULL,'2025-11-22 05:59:01',NULL,NULL),(365,NULL,'d1de504de31447958bcdd11490ecfeb6',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:59:01',NULL,'2025-11-22 05:59:01',NULL,NULL),(366,NULL,'57cc59807cc747c6849cfa0c21089689',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:59:03',NULL,'2025-11-22 05:59:03',NULL,NULL),(367,NULL,NULL,'e85bd4438f9c4f3596a4c11ba7b8b6d9',NULL,NULL,NULL,NULL,'2025-11-22 05:59:16',NULL,'2025-11-22 05:59:16',NULL,NULL),(368,NULL,NULL,'010135c9a64149dbb6846c9a653da6b8',NULL,NULL,NULL,NULL,'2025-11-22 05:59:23',NULL,'2025-11-22 05:59:23',NULL,NULL),(369,NULL,NULL,'6c86d6446c4e41738693b63b5f5a067d',NULL,NULL,NULL,NULL,'2025-11-22 05:59:23',NULL,'2025-11-22 05:59:23',NULL,NULL),(370,NULL,NULL,'5f1c5625e9d94883b7f8f3ed3af0d7dc',NULL,NULL,NULL,NULL,'2025-11-22 05:59:24',NULL,'2025-11-22 05:59:24',NULL,NULL),(371,NULL,'365a12020662402b80499fb61123ead0',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:59:26',NULL,'2025-11-22 05:59:26',NULL,NULL),(372,NULL,'81c194e188704418bc65b4c9d3ad49f0',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:59:27',NULL,'2025-11-22 05:59:27',NULL,NULL),(373,NULL,'325a0f56a64040c18ae384c10457495e',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:59:28',NULL,'2025-11-22 05:59:28',NULL,NULL),(374,NULL,NULL,'b45b936b0b444d16b70a1ada876fa201',NULL,NULL,NULL,NULL,'2025-11-22 05:59:36',NULL,'2025-11-22 05:59:36',NULL,NULL),(375,NULL,NULL,'3db9dedf9593479bbad4287d9e10a4d5',NULL,NULL,NULL,NULL,'2025-11-22 05:59:50',NULL,'2025-11-22 05:59:50',NULL,NULL),(376,NULL,NULL,'8ff66a418fca49b18cdb1b3a6bfb4f98',NULL,NULL,NULL,NULL,'2025-11-22 05:59:50',NULL,'2025-11-22 05:59:50',NULL,NULL),(377,NULL,NULL,'6270efa14bd84808a366a46dd0b93867',NULL,NULL,NULL,NULL,'2025-11-22 05:59:50',NULL,'2025-11-22 05:59:50',NULL,NULL),(378,NULL,'1e3df68b14c64c2eba82d76467788260',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:59:52',NULL,'2025-11-22 05:59:52',NULL,NULL),(379,NULL,'91af9a9e093745d18cc6ffd7f9bd19c9',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:59:53',NULL,'2025-11-22 05:59:53',NULL,NULL),(380,NULL,'506b74a63c0042ef9b0ce4ed0cfa751a',NULL,NULL,NULL,NULL,NULL,'2025-11-22 05:59:54',NULL,'2025-11-22 05:59:54',NULL,NULL),(381,NULL,NULL,'c465dcde34a745afa4e56a414c849d3e',NULL,NULL,NULL,NULL,'2025-11-22 05:59:55',NULL,'2025-11-22 05:59:55',NULL,NULL),(382,NULL,NULL,'123ee1961f274fcf8727f7d4c1fb5248',NULL,NULL,NULL,NULL,'2025-11-22 06:00:03',NULL,'2025-11-22 06:00:03',NULL,NULL),(383,NULL,NULL,'c7d28ea13d074150893ac34ee68bef24',NULL,NULL,NULL,NULL,'2025-11-22 06:00:03',NULL,'2025-11-22 06:00:03',NULL,NULL),(384,NULL,NULL,'7e540c62ef58485181e944ce6dcad287',NULL,NULL,NULL,NULL,'2025-11-22 06:00:03',NULL,'2025-11-22 06:00:03',NULL,NULL),(385,NULL,'ef497337be194fcb9ce62d89ec4f8a5a',NULL,NULL,NULL,NULL,NULL,'2025-11-22 06:00:06',NULL,'2025-11-22 06:00:06',NULL,NULL),(386,NULL,'a008f8e14cf443c69e70a374c2155d93',NULL,NULL,NULL,NULL,NULL,'2025-11-22 06:00:07',NULL,'2025-11-22 06:00:07',NULL,NULL),(387,NULL,NULL,'0052063f6579411ea46ce3e967044e06',NULL,NULL,NULL,NULL,'2025-11-22 06:00:07',NULL,'2025-11-22 06:00:07',NULL,NULL),(388,NULL,'04452820616b4132a0466a91ea662775',NULL,NULL,NULL,NULL,NULL,'2025-11-22 06:00:08',NULL,'2025-11-22 06:00:08',NULL,NULL),(389,NULL,NULL,'a1a7cc23204c4cc98f8e932daf5aa165',NULL,NULL,NULL,NULL,'2025-11-22 06:00:15',NULL,'2025-11-22 06:00:15',NULL,NULL),(390,NULL,NULL,'225f70e5b79e4e399746a1f6597a6941',NULL,NULL,NULL,NULL,'2025-11-22 06:00:15',NULL,'2025-11-22 06:00:15',NULL,NULL),(391,NULL,NULL,'067361beda8341d392ebac11f19e436c',NULL,NULL,NULL,NULL,'2025-11-22 06:00:15',NULL,'2025-11-22 06:00:15',NULL,NULL),(392,NULL,'39cd34e3d99d4413afb1c277d92dcf8f',NULL,NULL,NULL,NULL,NULL,'2025-11-22 06:00:17',NULL,'2025-11-22 06:00:17',NULL,NULL),(393,NULL,'c3d88e72920740b0a874db09fe229a4d',NULL,NULL,NULL,NULL,NULL,'2025-11-22 06:00:19',NULL,'2025-11-22 06:00:19',NULL,NULL),(394,NULL,'df0e9f48b09940b181c4601e00e6db13',NULL,NULL,NULL,NULL,NULL,'2025-11-22 06:00:20',NULL,'2025-11-22 06:00:20',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('4c488837e5c84b4f9d41a52099e21506','reader','{}','<<null>>',NULL),('66032c69f31549bbaa37296fbf6be590','service','{}','<<null>>',NULL),('b63109ca44dd467cbd522bdb03d849f6','ResellerAdmin','{}','<<null>>',NULL),('f5b734243ad845c6b3d599eb788e62f2','admin','{}','<<null>>',NULL),('f603d4ac63d940f88adf921b37144226','member','{}','<<null>>',NULL),('f7a577b5cb294c28be49df12bfeb664c','swiftoperator','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('4c488837e5c84b4f9d41a52099e21506','IMMU','true'),('f5b734243ad845c6b3d599eb788e62f2','IMMU','true'),('f603d4ac63d940f88adf921b37144226','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('0849ec0275254e7db6e34537cf39d890','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('3e8fb75a9b174877b338b298705c1b34','object-store',1,'{\"name\": \"swift\", \"description\": \"OpenStack Object Storage\"}'),('8647ab34e2b54350b2b74c07f901d331','identity',1,'{\"name\": \"keystone\"}'),('98fcdb73f800441a936e0dbb0383516c','sharev2',1,'{\"description\": \"Manila V2 Service\", \"name\": \"manilav2\"}'),('a783e59c11794c6da9359c62f5d8c347','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}'),('a906e6d94afe4b298b2f9a10e0b39ab7','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}'),('b9fe11fc32ac442da752fdaab87326a6','share',1,'{\"description\": \"Manila V1 Service\", \"name\": \"manila\"}'),('d628501d98704f95a8ff259ed95391c7','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}'),('d98ad7767e194ff8a9581265ed60e9ec','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('e1479bf815e94ceb9a7257ddf49b6bba','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('f6d050060bed4750bda9b6f47f7f3560','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','044d47622a784618a29823cd785e2e31','system','f5b734243ad845c6b3d599eb788e62f2',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_user_id` (`user_id`),
  KEY `ix_token_expires` (`expires`),
  KEY `ix_token_expires_valid` (`expires`,`valid`),
  KEY `ix_token_trust_id` (`trust_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('044d47622a784618a29823cd785e2e31','{}',1,NULL,'2025-11-22 05:10:47','2025-11-22','default'),('11dcc5b1cf0f4f4a952b208624faec1c','{}',1,'3c2407aa169a41c3b17fd0e7758ba8b9','2025-11-22 05:46:03','2025-11-22','default'),('3f3553734ec7494eacbe5d59be680f54','{}',1,'3c2407aa169a41c3b17fd0e7758ba8b9','2025-11-22 05:11:52','2025-11-22','default'),('50d78bcc473442519c43aa8f1f1dc71f','{}',1,'3c2407aa169a41c3b17fd0e7758ba8b9','2025-11-22 05:27:26',NULL,'default'),('5bcd98ae5e1141768a36c1b8b4c1527a','{}',1,'3c2407aa169a41c3b17fd0e7758ba8b9','2025-11-22 05:12:04','2025-11-22','default'),('8b49c4f6a70549aeb550364d3490ef56','{\"tenantId\": \"cd7b6b90941b47f8bc0928bc047133cc\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2025-11-22 05:48:28',NULL,'default'),('9844b9207f894a67894fd6041fcd557c','{}',1,'3c2407aa169a41c3b17fd0e7758ba8b9','2025-11-22 05:12:11','2025-11-22','default'),('98d34a55bea14665afe3180a63797fa6','{\"tenantId\": \"bd1dca9c7c074263995f4b73350e4e3a\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2025-11-22 05:48:28',NULL,'default'),('9f9d6131485e44518fe0af5c507e1222','{}',1,'3c2407aa169a41c3b17fd0e7758ba8b9','2025-11-22 05:12:07','2025-11-22','default'),('a3b9d4aab4d542d594e3c2fa6b6303d6','{}',1,'3c2407aa169a41c3b17fd0e7758ba8b9','2025-11-22 05:11:55','2025-11-22','default'),('afae489ae6db4d65b6594bf3fec7b2ec','{}',1,'3c2407aa169a41c3b17fd0e7758ba8b9','2025-11-22 05:12:00',NULL,'default'),('fd0f94750ac6410eb7e1eb208b1c1022','{}',1,'3c2407aa169a41c3b17fd0e7758ba8b9','2025-11-22 05:11:58','2025-11-22','default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `manila`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `manila` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `manila`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('aebe2a413e13');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `async_operation_data`
--

DROP TABLE IF EXISTS `async_operation_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `async_operation_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `async_operation_data`
--

LOCK TABLES `async_operation_data` WRITE;
/*!40000 ALTER TABLE `async_operation_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `async_operation_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `availability_zones`
--

DROP TABLE IF EXISTS `availability_zones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `availability_zones` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `az_name_uc` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `availability_zones`
--

LOCK TABLES `availability_zones` WRITE;
/*!40000 ALTER TABLE `availability_zones` DISABLE KEYS */;
INSERT INTO `availability_zones` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`) VALUES ('2025-11-22 05:46:05.484661',NULL,NULL,'False','bb37dba6-f304-4dde-891e-648b11fb093c','nova');
/*!40000 ALTER TABLE `availability_zones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backend_info`
--

DROP TABLE IF EXISTS `backend_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backend_info` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `host` varchar(255) NOT NULL,
  `info_hash` varchar(255) NOT NULL,
  PRIMARY KEY (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backend_info`
--

LOCK TABLES `backend_info` WRITE;
/*!40000 ALTER TABLE `backend_info` DISABLE KEYS */;
INSERT INTO `backend_info` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `host`, `info_hash`) VALUES ('2025-11-22 05:46:13.752811',NULL,NULL,0,'hostgroup@cephfs','e66c0dfc0d422efa26af62f5a81dd60603e2d39a');
/*!40000 ALTER TABLE `backend_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `drivers_private_data`
--

DROP TABLE IF EXISTS `drivers_private_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `drivers_private_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `drivers_private_data`
--

LOCK TABLES `drivers_private_data` WRITE;
/*!40000 ALTER TABLE `drivers_private_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `drivers_private_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(255) DEFAULT NULL,
  `resource_id` varchar(36) DEFAULT NULL,
  `action_id` varchar(10) NOT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
INSERT INTO `messages` (`id`, `project_id`, `request_id`, `resource_type`, `resource_id`, `action_id`, `detail_id`, `message_level`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `expires_at`) VALUES ('028a2f51-e8ee-4ca4-9e75-d9b388629978','9a040dac65f744c687d2d5814d775f6c','req-f2007428-5ae9-4204-9209-1eab9009a74d','SHARE','6a899e7f-5787-4b0b-81cc-6279b40ff3cf','001','008','ERROR','2025-11-22 05:51:15.777753',NULL,NULL,'False','2025-12-22 05:51:15'),('32b9b3ce-d217-4ade-b32e-d864a000d4b3','c1bb25e73f4845c0aa83279619d6c189','req-1f427f1c-33f7-462c-bc1b-95f848497fe5','SHARE','c51b35d0-72fb-4c33-9c66-387b1f86a20f','001','008','ERROR','2025-11-22 05:54:36.042083',NULL,NULL,'False','2025-12-22 05:54:36'),('3cd1ec62-ea4e-41ec-8125-d9ede2e96501','9a040dac65f744c687d2d5814d775f6c','req-4fb61c61-ea25-4c05-926e-2beacc6d94ca','SHARE','a0d78e53-1fa5-44a4-b34b-0adf8704cec3','001','008','ERROR','2025-11-22 05:51:31.790691',NULL,NULL,'False','2025-12-22 05:51:31'),('3e859cc5-f500-43ab-a425-5bc99c9a5192','c1bb25e73f4845c0aa83279619d6c189','req-294b48f4-4a78-4f4f-80a4-951948e8de67','SHARE','73cf6a38-fffe-415b-bd26-1bc690525347','001','008','ERROR','2025-11-22 05:55:03.565981',NULL,NULL,'False','2025-12-22 05:55:03'),('6059ed1f-453e-4696-90e8-8f1b0ffaa254','c1bb25e73f4845c0aa83279619d6c189','req-c11dfb75-20d5-4b9a-841d-ffec29bb3176','SHARE','ae02f817-c399-4fe3-9e4e-d95a2069a588','001','008','ERROR','2025-11-22 05:54:47.844526',NULL,NULL,'False','2025-12-22 05:54:47'),('6dd8a714-ef33-45ac-8414-3228e09eddf4','c1bb25e73f4845c0aa83279619d6c189','req-a7f612a5-8fbc-47be-8fbc-b26789fe0701','SHARE','1fac7a35-09cc-4c47-873e-f63ac427a11e','001','008','ERROR','2025-11-22 05:54:51.753651',NULL,NULL,'False','2025-12-22 05:54:51'),('72020ef9-bd52-4492-b243-d56cb3ad5a88','9a040dac65f744c687d2d5814d775f6c','req-b3b861c6-ca3f-45c7-8be7-e9014d8eb4b1','SHARE','63401021-32bf-4f9e-abf0-806c9549b2d3','001','008','ERROR','2025-11-22 05:51:27.767079',NULL,NULL,'False','2025-12-22 05:51:27'),('7e08768c-859a-48cf-adde-d9bef9827b06','c1bb25e73f4845c0aa83279619d6c189','req-8d5cb0f6-72fb-4155-9370-f837650c3f81','SHARE','4e22476f-a1eb-4f31-841d-b0a5e59503e4','001','008','ERROR','2025-11-22 05:54:40.005140',NULL,NULL,'False','2025-12-22 05:54:40'),('7fe06668-3e30-41ee-97a3-8361e5c831e5','9a040dac65f744c687d2d5814d775f6c','req-f945eb43-7a60-490c-8db2-aa9fd3f6fd4a','SHARE','0e4c9edf-33f0-4fb6-9de3-585d7dfa83c7','001','008','ERROR','2025-11-22 05:51:23.815629',NULL,NULL,'False','2025-12-22 05:51:23'),('846952e6-2ab5-46c5-9cd9-63dce6cdf18e','c1bb25e73f4845c0aa83279619d6c189','req-fd997e52-4e46-447d-bb3b-102105441936','SHARE','e376fddc-de34-4fd0-b102-8ee7a264cef2','001','008','ERROR','2025-11-22 05:54:55.470413',NULL,NULL,'False','2025-12-22 05:54:55'),('b5378404-d666-44e3-9b97-7c08d3beba1c','c1bb25e73f4845c0aa83279619d6c189','req-8c0db870-1861-473f-8470-cc0af51f443b','SHARE','4ebcd134-e7f8-49d6-a2f6-435caceb7e8b','001','008','ERROR','2025-11-22 05:54:59.929973',NULL,NULL,'False','2025-12-22 05:54:59'),('bdff3cb2-6e5b-4c56-98b7-ea00441a9844','c1bb25e73f4845c0aa83279619d6c189','req-bc7d4bd9-b513-4fa5-b031-ca86b10a8786','SHARE','3fbb9374-949b-4b92-bd96-bf00b070b292','001','008','ERROR','2025-11-22 05:54:43.520032',NULL,NULL,'False','2025-12-22 05:54:43'),('c74b639c-4ccc-4120-b28f-b52e1c5e921c','c1bb25e73f4845c0aa83279619d6c189','req-8ae33ea3-5c4c-423f-a67f-957ab1d72de1','SHARE','a012a75f-0920-4bd5-9cef-c0c84eb53ca5','001','008','ERROR','2025-11-22 05:55:07.554498',NULL,'2025-11-22 05:55:10.927680','c74b639c-4ccc-4120-b28f-b52e1c5e921c','2025-12-22 05:55:07'),('ca245ddd-a609-49a4-bd83-480908149d96','9a040dac65f744c687d2d5814d775f6c','req-7f48b174-ba2a-41fc-b8e7-b7cbcb6ad50c','SHARE','9baa489e-8738-4bb6-9cb5-831f3a757e15','001','008','ERROR','2025-11-22 05:51:19.889340',NULL,NULL,'False','2025-12-22 05:51:19'),('db6324e4-693d-4bd3-b351-71d39b9b6ed0','525ba1ccf0d546c7b4118a0855306190','req-5dfd4ba1-2bf8-4cd2-ab32-8f1773bfff5f','SHARE','e6ebf7ae-934a-4ccf-9ab6-5b62a19c9509','010','020','ERROR','2025-11-22 05:55:20.835485',NULL,NULL,'False','2025-12-22 05:55:20'),('dfbf6e6f-b447-4925-8dba-4442de348912','c1bb25e73f4845c0aa83279619d6c189','req-b0e81a24-e78f-4f73-a26d-be313f3a931e','SHARE','f2b41e8c-9da0-47f0-8319-319f763a885f','001','008','ERROR','2025-11-22 05:54:31.893899',NULL,'2025-11-22 05:54:35.253880','dfbf6e6f-b447-4925-8dba-4442de348912','2025-12-22 05:54:31');
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `network_allocations`
--

DROP TABLE IF EXISTS `network_allocations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `network_allocations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ip_address` varchar(64) DEFAULT NULL,
  `mac_address` varchar(32) DEFAULT NULL,
  `share_server_id` varchar(36) NOT NULL,
  `label` varchar(255) DEFAULT 'user',
  `network_type` varchar(32) DEFAULT NULL,
  `segmentation_id` int(11) DEFAULT NULL,
  `ip_version` int(11) DEFAULT NULL,
  `cidr` varchar(64) DEFAULT NULL,
  `gateway` varchar(64) DEFAULT NULL,
  `mtu` int(11) DEFAULT NULL,
  `share_network_subnet_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_server_id` (`share_server_id`),
  KEY `fk_network_allocation_subnet_id_share_network_subnets` (`share_network_subnet_id`),
  CONSTRAINT `fk_network_allocation_subnet_id_share_network_subnets` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`),
  CONSTRAINT `network_allocations_ibfk_1` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `network_allocations`
--

LOCK TABLES `network_allocations` WRITE;
/*!40000 ALTER TABLE `network_allocations` DISABLE KEYS */;
/*!40000 ALTER TABLE `network_allocations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_share_type_quotas`
--

DROP TABLE IF EXISTS `project_share_type_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_share_type_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uc_quotas_per_share_types` (`share_type_id`,`resource`,`deleted`,`project_id`),
  CONSTRAINT `share_type_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_share_type_quotas`
--

LOCK TABLES `project_share_type_quotas` WRITE;
/*!40000 ALTER TABLE `project_share_type_quotas` DISABLE KEYS */;
INSERT INTO `project_share_type_quotas` (`id`, `project_id`, `resource`, `hard_limit`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `share_type_id`) VALUES (1,'0e5f6a3a07fc4127bb51414f12d488cd','shares',2,'2025-11-22 05:51:06.636747',NULL,'2025-11-22 05:51:39.603094',1,'23542ce2-0314-4df7-8304-4afa45fe5db2'),(2,'0e5f6a3a07fc4127bb51414f12d488cd','gigabytes',4,'2025-11-22 05:51:06.644002',NULL,'2025-11-22 05:51:39.603094',2,'23542ce2-0314-4df7-8304-4afa45fe5db2'),(3,'0e5f6a3a07fc4127bb51414f12d488cd','shares',2,'2025-11-22 05:51:06.768630',NULL,'2025-11-22 05:51:39.460956',3,'5e508b15-d618-4a27-8b79-1b26df71e665'),(4,'0e5f6a3a07fc4127bb51414f12d488cd','gigabytes',4,'2025-11-22 05:51:06.779543',NULL,'2025-11-22 05:51:39.460956',4,'5e508b15-d618-4a27-8b79-1b26df71e665'),(5,'0e5f6a3a07fc4127bb51414f12d488cd','shares',53,'2025-11-22 05:51:22.899499',NULL,'2025-11-22 05:51:22.998837',5,'8233e672-6ffd-441b-82d4-d8cfa745ac62'),(6,'0e5f6a3a07fc4127bb51414f12d488cd','snapshots',53,'2025-11-22 05:51:22.903225',NULL,'2025-11-22 05:51:22.998837',6,'8233e672-6ffd-441b-82d4-d8cfa745ac62'),(7,'0e5f6a3a07fc4127bb51414f12d488cd','gigabytes',1003,'2025-11-22 05:51:22.907200',NULL,'2025-11-22 05:51:22.998837',7,'8233e672-6ffd-441b-82d4-d8cfa745ac62'),(8,'0e5f6a3a07fc4127bb51414f12d488cd','snapshot_gigabytes',1003,'2025-11-22 05:51:22.910433',NULL,'2025-11-22 05:51:22.998837',8,'8233e672-6ffd-441b-82d4-d8cfa745ac62'),(9,'0e5f6a3a07fc4127bb51414f12d488cd','share_replicas',103,'2025-11-22 05:51:22.913944',NULL,'2025-11-22 05:51:22.998837',9,'8233e672-6ffd-441b-82d4-d8cfa745ac62'),(10,'0e5f6a3a07fc4127bb51414f12d488cd','replica_gigabytes',1003,'2025-11-22 05:51:22.917398',NULL,'2025-11-22 05:51:22.998837',10,'8233e672-6ffd-441b-82d4-d8cfa745ac62'),(11,'0e5f6a3a07fc4127bb51414f12d488cd','shares',53,'2025-11-22 05:51:23.709504',NULL,'2025-11-22 05:51:23.824954',11,'77493a25-15f3-46a2-aa42-8cc60bfae5bd'),(12,'0e5f6a3a07fc4127bb51414f12d488cd','snapshots',53,'2025-11-22 05:51:23.712913',NULL,'2025-11-22 05:51:23.824954',12,'77493a25-15f3-46a2-aa42-8cc60bfae5bd'),(13,'0e5f6a3a07fc4127bb51414f12d488cd','gigabytes',1003,'2025-11-22 05:51:23.716557',NULL,'2025-11-22 05:51:23.824954',13,'77493a25-15f3-46a2-aa42-8cc60bfae5bd'),(14,'0e5f6a3a07fc4127bb51414f12d488cd','snapshot_gigabytes',1003,'2025-11-22 05:51:23.720123',NULL,'2025-11-22 05:51:23.824954',14,'77493a25-15f3-46a2-aa42-8cc60bfae5bd'),(15,'0e5f6a3a07fc4127bb51414f12d488cd','share_replicas',103,'2025-11-22 05:51:23.723572',NULL,'2025-11-22 05:51:23.824954',15,'77493a25-15f3-46a2-aa42-8cc60bfae5bd'),(16,'0e5f6a3a07fc4127bb51414f12d488cd','replica_gigabytes',1003,'2025-11-22 05:51:23.727741',NULL,'2025-11-22 05:51:23.824954',16,'77493a25-15f3-46a2-aa42-8cc60bfae5bd'),(17,'0e5f6a3a07fc4127bb51414f12d488cd','shares',12,'2025-11-22 05:51:25.168004',NULL,'2025-11-22 05:51:38.948086',17,'4a044d39-acd3-45a4-9bab-4e4ff5207080'),(18,'0e5f6a3a07fc4127bb51414f12d488cd','shares',49,'2025-11-22 05:51:29.541547',NULL,'2025-11-22 05:51:38.770989',18,'b04f0ad5-a570-45a6-9168-54f1a3291141'),(19,'0e5f6a3a07fc4127bb51414f12d488cd','gigabytes',999,'2025-11-22 05:51:29.749336',NULL,'2025-11-22 05:51:38.770989',19,'b04f0ad5-a570-45a6-9168-54f1a3291141'),(20,'0e5f6a3a07fc4127bb51414f12d488cd','snapshots',49,'2025-11-22 05:51:30.499981',NULL,'2025-11-22 05:51:38.770989',20,'b04f0ad5-a570-45a6-9168-54f1a3291141'),(21,'0e5f6a3a07fc4127bb51414f12d488cd','snapshot_gigabytes',999,'2025-11-22 05:51:30.633663',NULL,'2025-11-22 05:51:38.770989',21,'b04f0ad5-a570-45a6-9168-54f1a3291141'),(22,'0e5f6a3a07fc4127bb51414f12d488cd','share_replicas',99,'2025-11-22 05:51:30.777389',NULL,'2025-11-22 05:51:38.770989',22,'b04f0ad5-a570-45a6-9168-54f1a3291141'),(23,'0e5f6a3a07fc4127bb51414f12d488cd','replica_gigabytes',999,'2025-11-22 05:51:30.880944',NULL,'2025-11-22 05:51:38.770989',23,'b04f0ad5-a570-45a6-9168-54f1a3291141'),(24,'0e5f6a3a07fc4127bb51414f12d488cd','shares',49,'2025-11-22 05:51:31.337638',NULL,'2025-11-22 05:51:38.569357',24,'052fd418-2f2e-40fe-a1af-6f6eb5e39696'),(25,'0e5f6a3a07fc4127bb51414f12d488cd','gigabytes',999,'2025-11-22 05:51:31.453862',NULL,'2025-11-22 05:51:38.569357',25,'052fd418-2f2e-40fe-a1af-6f6eb5e39696'),(26,'0e5f6a3a07fc4127bb51414f12d488cd','snapshots',49,'2025-11-22 05:51:31.560135',NULL,'2025-11-22 05:51:38.569357',26,'052fd418-2f2e-40fe-a1af-6f6eb5e39696'),(27,'0e5f6a3a07fc4127bb51414f12d488cd','snapshot_gigabytes',999,'2025-11-22 05:51:31.699468',NULL,'2025-11-22 05:51:38.569357',27,'052fd418-2f2e-40fe-a1af-6f6eb5e39696'),(28,'0e5f6a3a07fc4127bb51414f12d488cd','share_replicas',99,'2025-11-22 05:51:31.801578',NULL,'2025-11-22 05:51:38.569357',28,'052fd418-2f2e-40fe-a1af-6f6eb5e39696'),(29,'0e5f6a3a07fc4127bb51414f12d488cd','replica_gigabytes',999,'2025-11-22 05:51:31.916860',NULL,'2025-11-22 05:51:38.569357',29,'052fd418-2f2e-40fe-a1af-6f6eb5e39696'),(30,'0e5f6a3a07fc4127bb51414f12d488cd','shares',11,'2025-11-22 05:51:32.292957',NULL,'2025-11-22 05:51:38.409489',30,'9bbba06e-c405-4b53-8876-3be72e9dbdf8'),(31,'0e5f6a3a07fc4127bb51414f12d488cd','shares',-1,'2025-11-22 05:51:32.619951',NULL,'2025-11-22 05:51:38.208782',31,'2e9deb11-bcd8-4b11-9b5d-5c17bd2042da');
/*!40000 ALTER TABLE `project_share_type_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_user_quotas`
--

DROP TABLE IF EXISTS `project_user_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_user_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `resource` varchar(25) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_user_quotas`
--

LOCK TABLES `project_user_quotas` WRITE;
/*!40000 ALTER TABLE `project_user_quotas` DISABLE KEYS */;
INSERT INTO `project_user_quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `user_id`, `project_id`, `resource`, `hard_limit`) VALUES (1,'2025-11-22 05:51:06.442060',NULL,'2025-11-22 05:51:22.416248',1,'98f921ea69fa4cd9bf74c37b645f9733','0e5f6a3a07fc4127bb51414f12d488cd','shares',2),(2,'2025-11-22 05:51:06.451615',NULL,'2025-11-22 05:51:22.416248',2,'98f921ea69fa4cd9bf74c37b645f9733','0e5f6a3a07fc4127bb51414f12d488cd','gigabytes',7),(3,'2025-11-22 05:51:24.993973',NULL,'2025-11-22 05:51:25.246245',3,'98f921ea69fa4cd9bf74c37b645f9733','0e5f6a3a07fc4127bb51414f12d488cd','shares',11),(4,'2025-11-22 05:51:27.142912',NULL,'2025-11-22 05:51:27.291326',4,'98f921ea69fa4cd9bf74c37b645f9733','0e5f6a3a07fc4127bb51414f12d488cd','gigabytes',-1),(5,'2025-11-22 05:51:27.386510',NULL,'2025-11-22 05:51:27.531052',5,'98f921ea69fa4cd9bf74c37b645f9733','0e5f6a3a07fc4127bb51414f12d488cd','share_replicas',-1),(6,'2025-11-22 05:51:27.622909',NULL,'2025-11-22 05:51:27.796207',6,'98f921ea69fa4cd9bf74c37b645f9733','0e5f6a3a07fc4127bb51414f12d488cd','replica_gigabytes',-1),(7,'2025-11-22 05:51:27.904176',NULL,'2025-11-22 05:51:28.063339',7,'98f921ea69fa4cd9bf74c37b645f9733','0e5f6a3a07fc4127bb51414f12d488cd','share_networks',-1),(8,'2025-11-22 05:51:28.170568',NULL,'2025-11-22 05:51:28.318455',8,'98f921ea69fa4cd9bf74c37b645f9733','0e5f6a3a07fc4127bb51414f12d488cd','shares',-1),(9,'2025-11-22 05:51:28.420110',NULL,'2025-11-22 05:51:28.561424',9,'98f921ea69fa4cd9bf74c37b645f9733','0e5f6a3a07fc4127bb51414f12d488cd','snapshot_gigabytes',-1),(10,'2025-11-22 05:51:28.677634',NULL,'2025-11-22 05:51:29.133746',10,'98f921ea69fa4cd9bf74c37b645f9733','0e5f6a3a07fc4127bb51414f12d488cd','snapshots',-1),(11,'2025-11-22 05:51:34.541227',NULL,'2025-11-22 05:51:34.642108',11,'98f921ea69fa4cd9bf74c37b645f9733','0e5f6a3a07fc4127bb51414f12d488cd','gigabytes',999),(12,'2025-11-22 05:51:35.124627',NULL,'2025-11-22 05:51:35.200841',12,'98f921ea69fa4cd9bf74c37b645f9733','0e5f6a3a07fc4127bb51414f12d488cd','share_replicas',99),(13,'2025-11-22 05:51:35.726581',NULL,'2025-11-22 05:51:35.787557',13,'98f921ea69fa4cd9bf74c37b645f9733','0e5f6a3a07fc4127bb51414f12d488cd','replica_gigabytes',999),(14,'2025-11-22 05:51:35.952191',NULL,'2025-11-22 05:51:36.007471',14,'98f921ea69fa4cd9bf74c37b645f9733','0e5f6a3a07fc4127bb51414f12d488cd','share_networks',9),(15,'2025-11-22 05:51:36.212330',NULL,'2025-11-22 05:51:36.269739',15,'98f921ea69fa4cd9bf74c37b645f9733','0e5f6a3a07fc4127bb51414f12d488cd','shares',49),(16,'2025-11-22 05:51:36.510599',NULL,'2025-11-22 05:51:36.720879',16,'98f921ea69fa4cd9bf74c37b645f9733','0e5f6a3a07fc4127bb51414f12d488cd','snapshot_gigabytes',999),(17,'2025-11-22 05:51:37.066699',NULL,'2025-11-22 05:51:37.192306',17,'98f921ea69fa4cd9bf74c37b645f9733','0e5f6a3a07fc4127bb51414f12d488cd','snapshots',49),(18,'2025-11-22 05:51:37.500875',NULL,'2025-11-22 05:51:37.587477',18,'98f921ea69fa4cd9bf74c37b645f9733','0e5f6a3a07fc4127bb51414f12d488cd','shares',11),(19,'2025-11-22 05:51:37.855226',NULL,'2025-11-22 05:51:37.918095',19,'98f921ea69fa4cd9bf74c37b645f9733','0e5f6a3a07fc4127bb51414f12d488cd','shares',-1);
/*!40000 ALTER TABLE `project_user_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_usages_project_id` (`project_id`)
) ENGINE=InnoDB AUTO_INCREMENT=270 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `share_type_id`) VALUES ('2025-11-22 05:50:49.508635','2025-11-22 05:52:23.194076',NULL,0,1,'3ca1144a55894a528a97f0906826d387','1d43ad7bfa6f468cb936112ef76b83ec','gigabytes',0,0,NULL,NULL),('2025-11-22 05:50:49.513823','2025-11-22 05:52:23.194080',NULL,0,2,'3ca1144a55894a528a97f0906826d387','1d43ad7bfa6f468cb936112ef76b83ec','shares',0,0,NULL,NULL),('2025-11-22 05:50:49.569674','2025-11-22 05:52:23.194082','2025-11-22 05:52:26.593866',3,3,NULL,'1d43ad7bfa6f468cb936112ef76b83ec','gigabytes',0,0,NULL,'ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:50:49.572522','2025-11-22 05:52:23.194083','2025-11-22 05:52:26.593866',4,4,NULL,'1d43ad7bfa6f468cb936112ef76b83ec','shares',0,0,NULL,'ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:50:53.496755','2025-11-22 05:51:06.837246',NULL,0,5,'9395a53526744acc85a47d28e0d28556','9ece7a8ade98405884af4e066937cac2','gigabytes',0,0,NULL,NULL),('2025-11-22 05:50:53.498897','2025-11-22 05:51:06.837277',NULL,0,6,'9395a53526744acc85a47d28e0d28556','9ece7a8ade98405884af4e066937cac2','shares',0,0,NULL,NULL),('2025-11-22 05:50:53.563802','2025-11-22 05:51:06.837280','2025-11-22 05:51:09.953726',7,7,NULL,'9ece7a8ade98405884af4e066937cac2','gigabytes',0,0,NULL,'72b75a26-0b62-433e-a838-9cd3b4b43b69'),('2025-11-22 05:50:53.566986','2025-11-22 05:51:06.837282','2025-11-22 05:51:09.953726',8,8,NULL,'9ece7a8ade98405884af4e066937cac2','shares',0,0,NULL,'72b75a26-0b62-433e-a838-9cd3b4b43b69'),('2025-11-22 05:50:54.413143','2025-11-22 05:50:59.254086',NULL,0,9,'f14080a6e5894c1998fe207d36c3a562','dd1f0f76d8c542febd4c75985ef66d86','gigabytes',0,0,NULL,NULL),('2025-11-22 05:50:54.415056','2025-11-22 05:50:59.254089',NULL,0,10,'f14080a6e5894c1998fe207d36c3a562','dd1f0f76d8c542febd4c75985ef66d86','shares',0,0,NULL,NULL),('2025-11-22 05:50:54.570607','2025-11-22 05:50:59.254091','2025-11-22 05:51:02.325699',11,11,NULL,'dd1f0f76d8c542febd4c75985ef66d86','gigabytes',0,0,NULL,'5cd9ff63-cfd0-4053-a66f-0941fbf95643'),('2025-11-22 05:50:54.572835','2025-11-22 05:50:59.254093','2025-11-22 05:51:02.325699',12,12,NULL,'dd1f0f76d8c542febd4c75985ef66d86','shares',0,0,NULL,'5cd9ff63-cfd0-4053-a66f-0941fbf95643'),('2025-11-22 05:50:57.522010','2025-11-22 05:51:04.217736',NULL,0,13,'9395a53526744acc85a47d28e0d28556','9ece7a8ade98405884af4e066937cac2','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-22 05:50:57.528946','2025-11-22 05:51:04.217741',NULL,0,14,'9395a53526744acc85a47d28e0d28556','9ece7a8ade98405884af4e066937cac2','snapshots',0,0,NULL,NULL),('2025-11-22 05:50:57.538522','2025-11-22 05:51:04.217744','2025-11-22 05:51:09.953726',15,15,NULL,'9ece7a8ade98405884af4e066937cac2','snapshot_gigabytes',0,0,NULL,'72b75a26-0b62-433e-a838-9cd3b4b43b69'),('2025-11-22 05:50:57.541119','2025-11-22 05:51:04.217747','2025-11-22 05:51:09.953726',16,16,NULL,'9ece7a8ade98405884af4e066937cac2','snapshots',0,0,NULL,'72b75a26-0b62-433e-a838-9cd3b4b43b69'),('2025-11-22 05:51:06.996921','2025-11-22 05:51:18.793076','2025-11-22 05:51:22.422506',17,17,'98f921ea69fa4cd9bf74c37b645f9733','0e5f6a3a07fc4127bb51414f12d488cd','gigabytes',0,0,NULL,NULL),('2025-11-22 05:51:07.000696','2025-11-22 05:51:18.793080','2025-11-22 05:51:22.422506',18,18,'98f921ea69fa4cd9bf74c37b645f9733','0e5f6a3a07fc4127bb51414f12d488cd','shares',0,0,NULL,NULL),('2025-11-22 05:51:07.011073','2025-11-22 05:51:15.300461','2025-11-22 05:51:22.510126',19,19,NULL,'0e5f6a3a07fc4127bb51414f12d488cd','gigabytes',0,0,NULL,'23542ce2-0314-4df7-8304-4afa45fe5db2'),('2025-11-22 05:51:07.014118','2025-11-22 05:51:15.300463','2025-11-22 05:51:22.510126',20,20,NULL,'0e5f6a3a07fc4127bb51414f12d488cd','shares',0,0,NULL,'23542ce2-0314-4df7-8304-4afa45fe5db2'),('2025-11-22 05:51:11.114748','2025-11-22 05:51:18.793081','2025-11-22 05:51:22.510126',21,21,NULL,'0e5f6a3a07fc4127bb51414f12d488cd','gigabytes',0,0,NULL,'5e508b15-d618-4a27-8b79-1b26df71e665'),('2025-11-22 05:51:11.116514','2025-11-22 05:51:18.793083','2025-11-22 05:51:22.510126',22,22,NULL,'0e5f6a3a07fc4127bb51414f12d488cd','shares',0,0,NULL,'5e508b15-d618-4a27-8b79-1b26df71e665'),('2025-11-22 05:51:15.669657','2025-11-22 05:51:35.326361',NULL,0,23,'3a798de8dc964838b12715c65c83b403','9a040dac65f744c687d2d5814d775f6c','gigabytes',0,0,NULL,NULL),('2025-11-22 05:51:15.671934','2025-11-22 05:51:35.326363',NULL,0,24,'3a798de8dc964838b12715c65c83b403','9a040dac65f744c687d2d5814d775f6c','shares',0,0,NULL,NULL),('2025-11-22 05:51:15.681172','2025-11-22 05:51:19.552529','2025-11-22 05:51:36.233417',25,25,NULL,'9a040dac65f744c687d2d5814d775f6c','gigabytes',0,0,NULL,'4b9d7651-19c5-43ac-bb58-20f5ebca2afc'),('2025-11-22 05:51:15.682738','2025-11-22 05:51:19.552530','2025-11-22 05:51:36.233417',26,26,NULL,'9a040dac65f744c687d2d5814d775f6c','shares',0,0,NULL,'4b9d7651-19c5-43ac-bb58-20f5ebca2afc'),('2025-11-22 05:51:19.066610','2025-11-22 05:51:25.548861',NULL,0,27,'4ec9dc11277c4a1283c49e6e6a186cf5','dd17ac9b721a4caaa440f97988ad0956','gigabytes',0,0,NULL,NULL),('2025-11-22 05:51:19.070917','2025-11-22 05:51:25.548864',NULL,0,28,'4ec9dc11277c4a1283c49e6e6a186cf5','dd17ac9b721a4caaa440f97988ad0956','shares',0,0,NULL,NULL),('2025-11-22 05:51:19.079259','2025-11-22 05:51:25.548865','2025-11-22 05:51:28.535656',29,29,NULL,'dd17ac9b721a4caaa440f97988ad0956','gigabytes',0,0,NULL,'01f563c6-5fd0-4f02-bfc6-595c6cff9c84'),('2025-11-22 05:51:19.081737','2025-11-22 05:51:25.548866','2025-11-22 05:51:28.535656',30,30,NULL,'dd17ac9b721a4caaa440f97988ad0956','shares',0,0,NULL,'01f563c6-5fd0-4f02-bfc6-595c6cff9c84'),('2025-11-22 05:51:19.781102','2025-11-22 05:51:23.449721','2025-11-22 05:51:36.077232',31,31,NULL,'9a040dac65f744c687d2d5814d775f6c','gigabytes',0,0,NULL,'d6624012-6e58-49fd-92c2-41fff579b962'),('2025-11-22 05:51:19.783530','2025-11-22 05:51:23.449723','2025-11-22 05:51:36.077232',32,32,NULL,'9a040dac65f744c687d2d5814d775f6c','shares',0,0,NULL,'d6624012-6e58-49fd-92c2-41fff579b962'),('2025-11-22 05:51:23.692177','2025-11-22 05:51:27.451919','2025-11-22 05:51:35.927048',33,33,NULL,'9a040dac65f744c687d2d5814d775f6c','gigabytes',0,0,NULL,'ba0277e3-3973-4052-b400-a5c0085d5c63'),('2025-11-22 05:51:23.694880','2025-11-22 05:51:27.451921','2025-11-22 05:51:35.927048',34,34,NULL,'9a040dac65f744c687d2d5814d775f6c','shares',0,0,NULL,'ba0277e3-3973-4052-b400-a5c0085d5c63'),('2025-11-22 05:51:27.661805','2025-11-22 05:51:31.355572','2025-11-22 05:51:35.799484',35,35,NULL,'9a040dac65f744c687d2d5814d775f6c','shares',0,0,NULL,'170222eb-0fff-44bb-9ac3-bc5681dd8de2'),('2025-11-22 05:51:27.665107','2025-11-22 05:51:31.355573','2025-11-22 05:51:35.799484',36,36,NULL,'9a040dac65f744c687d2d5814d775f6c','gigabytes',0,0,NULL,'170222eb-0fff-44bb-9ac3-bc5681dd8de2'),('2025-11-22 05:51:28.567281','2025-11-22 05:52:19.121890',NULL,0,37,'3ca1144a55894a528a97f0906826d387','1d43ad7bfa6f468cb936112ef76b83ec','snapshots',0,0,NULL,NULL),('2025-11-22 05:51:28.569605','2025-11-22 05:52:19.121894',NULL,0,38,'3ca1144a55894a528a97f0906826d387','1d43ad7bfa6f468cb936112ef76b83ec','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-22 05:51:28.580407','2025-11-22 05:52:19.121896','2025-11-22 05:52:26.593866',39,39,NULL,'1d43ad7bfa6f468cb936112ef76b83ec','snapshots',0,0,NULL,'ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:51:28.583352','2025-11-22 05:52:19.121898','2025-11-22 05:52:26.593866',40,40,NULL,'1d43ad7bfa6f468cb936112ef76b83ec','snapshot_gigabytes',0,0,NULL,'ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:51:31.689842','2025-11-22 05:51:35.326365','2025-11-22 05:51:35.660365',41,41,NULL,'9a040dac65f744c687d2d5814d775f6c','gigabytes',0,0,NULL,'2b6b3050-6c17-4581-9b45-8c5482542326'),('2025-11-22 05:51:31.693122','2025-11-22 05:51:35.326366','2025-11-22 05:51:35.660365',42,42,NULL,'9a040dac65f744c687d2d5814d775f6c','shares',0,0,NULL,'2b6b3050-6c17-4581-9b45-8c5482542326'),('2025-11-22 05:51:37.869987','2025-11-22 05:51:37.920493','2025-11-22 05:51:41.822893',43,43,'19063b71466b4a099f4798ea400aed7c','fffa744c2146473ab31df119246a9181','shares',1,0,NULL,NULL),('2025-11-22 05:51:37.874727','2025-11-22 05:51:37.920497','2025-11-22 05:51:41.822893',44,44,'19063b71466b4a099f4798ea400aed7c','fffa744c2146473ab31df119246a9181','gigabytes',1,0,NULL,NULL),('2025-11-22 05:51:37.889065','2025-11-22 05:51:37.920499','2025-11-22 05:51:41.822893',45,45,NULL,'fffa744c2146473ab31df119246a9181','shares',1,0,NULL,'76b8f610-7bd5-4886-9698-850dd629ddbd'),('2025-11-22 05:51:37.891441','2025-11-22 05:51:37.920500','2025-11-22 05:51:41.822893',46,46,NULL,'fffa744c2146473ab31df119246a9181','gigabytes',1,0,NULL,'76b8f610-7bd5-4886-9698-850dd629ddbd'),('2025-11-22 05:51:41.992601','2025-11-22 05:51:42.193198','2025-11-22 05:51:49.707144',47,47,'19063b71466b4a099f4798ea400aed7c','fffa744c2146473ab31df119246a9181','gigabytes',2,0,NULL,NULL),('2025-11-22 05:51:41.995368','2025-11-22 05:51:42.193201','2025-11-22 05:51:49.707144',48,48,'19063b71466b4a099f4798ea400aed7c','fffa744c2146473ab31df119246a9181','shares',2,0,NULL,NULL),('2025-11-22 05:51:42.170494','2025-11-22 05:51:42.193203','2025-11-22 05:51:49.707144',49,49,NULL,'fffa744c2146473ab31df119246a9181','shares',1,0,NULL,'0c31157a-4a41-48b4-a5d8-48543e507fe9'),('2025-11-22 05:51:42.172452','2025-11-22 05:51:42.193204','2025-11-22 05:51:49.707144',50,50,NULL,'fffa744c2146473ab31df119246a9181','gigabytes',1,0,NULL,'0c31157a-4a41-48b4-a5d8-48543e507fe9'),('2025-11-22 05:51:44.388054','2025-11-22 05:52:09.450299',NULL,0,51,'825bdf0dbbba49b38e9e122e772e6b7b','1218c5e5dd6949df8f550c000dc3c24e','gigabytes',0,0,NULL,NULL),('2025-11-22 05:51:44.390877','2025-11-22 05:52:09.450303',NULL,0,52,'825bdf0dbbba49b38e9e122e772e6b7b','1218c5e5dd6949df8f550c000dc3c24e','shares',0,0,NULL,NULL),('2025-11-22 05:51:44.407605','2025-11-22 05:52:09.450305','2025-11-22 05:52:11.790237',53,53,NULL,'1218c5e5dd6949df8f550c000dc3c24e','gigabytes',0,0,NULL,'83710f66-5331-429a-9190-c955e72a6981'),('2025-11-22 05:51:44.409775','2025-11-22 05:52:09.450307','2025-11-22 05:52:11.790237',54,54,NULL,'1218c5e5dd6949df8f550c000dc3c24e','shares',0,0,NULL,'83710f66-5331-429a-9190-c955e72a6981'),('2025-11-22 05:51:45.763777','2025-11-22 05:51:46.140196','2025-11-22 05:51:49.707144',55,55,'19063b71466b4a099f4798ea400aed7c','fffa744c2146473ab31df119246a9181','snapshot_gigabytes',1,0,NULL,NULL),('2025-11-22 05:51:45.765443','2025-11-22 05:51:46.140204','2025-11-22 05:51:49.707144',56,56,'19063b71466b4a099f4798ea400aed7c','fffa744c2146473ab31df119246a9181','snapshots',1,0,NULL,NULL),('2025-11-22 05:51:45.900382','2025-11-22 05:51:46.140209','2025-11-22 05:51:49.707144',57,57,NULL,'fffa744c2146473ab31df119246a9181','snapshot_gigabytes',1,0,NULL,'0c31157a-4a41-48b4-a5d8-48543e507fe9'),('2025-11-22 05:51:45.902890','2025-11-22 05:51:46.140214','2025-11-22 05:51:49.707144',58,58,NULL,'fffa744c2146473ab31df119246a9181','snapshots',1,0,NULL,'0c31157a-4a41-48b4-a5d8-48543e507fe9'),('2025-11-22 05:52:00.579144','2025-11-22 05:52:20.312359',NULL,0,59,'ca8cffb070a549e3b3a19f34d69fb809','161410e8e68843c498c108a7c907faa9','gigabytes',0,0,NULL,NULL),('2025-11-22 05:52:00.582952','2025-11-22 05:52:20.312362',NULL,0,60,'ca8cffb070a549e3b3a19f34d69fb809','161410e8e68843c498c108a7c907faa9','shares',0,0,NULL,NULL),('2025-11-22 05:52:00.593556','2025-11-22 05:52:20.312363','2025-11-22 05:52:23.567934',61,61,NULL,'161410e8e68843c498c108a7c907faa9','gigabytes',0,0,NULL,'72fda760-d07e-4ff4-b88e-2511b31404ed'),('2025-11-22 05:52:00.596417','2025-11-22 05:52:20.312364','2025-11-22 05:52:23.567934',62,62,NULL,'161410e8e68843c498c108a7c907faa9','shares',0,0,NULL,'72fda760-d07e-4ff4-b88e-2511b31404ed'),('2025-11-22 05:52:01.459871','2025-11-22 05:52:01.491748',NULL,0,63,'19063b71466b4a099f4798ea400aed7c','fffa744c2146473ab31df119246a9181','snapshots',-1,0,NULL,NULL),('2025-11-22 05:52:01.464398','2025-11-22 05:52:01.491751',NULL,0,64,'19063b71466b4a099f4798ea400aed7c','fffa744c2146473ab31df119246a9181','snapshot_gigabytes',-1,0,NULL,NULL),('2025-11-22 05:52:01.473161','2025-11-22 05:52:01.491752','2025-11-22 05:52:07.824275',65,65,NULL,'fffa744c2146473ab31df119246a9181','snapshots',-1,0,NULL,'0c31157a-4a41-48b4-a5d8-48543e507fe9'),('2025-11-22 05:52:01.478736','2025-11-22 05:52:01.491753','2025-11-22 05:52:07.824275',66,66,NULL,'fffa744c2146473ab31df119246a9181','snapshot_gigabytes',-1,0,NULL,'0c31157a-4a41-48b4-a5d8-48543e507fe9'),('2025-11-22 05:52:04.089056','2025-11-22 05:52:17.229555',NULL,0,67,'ca8cffb070a549e3b3a19f34d69fb809','161410e8e68843c498c108a7c907faa9','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-22 05:52:04.092433','2025-11-22 05:52:17.229562',NULL,0,68,'ca8cffb070a549e3b3a19f34d69fb809','161410e8e68843c498c108a7c907faa9','snapshots',0,0,NULL,NULL),('2025-11-22 05:52:04.142910','2025-11-22 05:52:17.229565','2025-11-22 05:52:23.567934',69,69,NULL,'161410e8e68843c498c108a7c907faa9','snapshot_gigabytes',0,0,NULL,'72fda760-d07e-4ff4-b88e-2511b31404ed'),('2025-11-22 05:52:04.147853','2025-11-22 05:52:17.229568','2025-11-22 05:52:23.567934',70,70,NULL,'161410e8e68843c498c108a7c907faa9','snapshots',0,0,NULL,'72fda760-d07e-4ff4-b88e-2511b31404ed'),('2025-11-22 05:52:05.451658','2025-11-22 05:52:08.856859',NULL,0,71,'19063b71466b4a099f4798ea400aed7c','fffa744c2146473ab31df119246a9181','gigabytes',0,0,NULL,NULL),('2025-11-22 05:52:05.456972','2025-11-22 05:52:08.856863',NULL,0,72,'19063b71466b4a099f4798ea400aed7c','fffa744c2146473ab31df119246a9181','shares',0,0,NULL,NULL),('2025-11-22 05:52:05.469796','2025-11-22 05:52:05.493658','2025-11-22 05:52:07.824275',73,73,NULL,'fffa744c2146473ab31df119246a9181','gigabytes',0,0,NULL,'0c31157a-4a41-48b4-a5d8-48543e507fe9'),('2025-11-22 05:52:05.476305','2025-11-22 05:52:05.493660','2025-11-22 05:52:07.824275',74,74,NULL,'fffa744c2146473ab31df119246a9181','shares',0,0,NULL,'0c31157a-4a41-48b4-a5d8-48543e507fe9'),('2025-11-22 05:52:08.808044','2025-11-22 05:52:08.856865','2025-11-22 05:52:11.958412',75,75,NULL,'fffa744c2146473ab31df119246a9181','gigabytes',0,0,NULL,'76b8f610-7bd5-4886-9698-850dd629ddbd'),('2025-11-22 05:52:08.823790','2025-11-22 05:52:08.856866','2025-11-22 05:52:11.958412',76,76,NULL,'fffa744c2146473ab31df119246a9181','shares',0,0,NULL,'76b8f610-7bd5-4886-9698-850dd629ddbd'),('2025-11-22 05:52:24.369210','2025-11-22 05:52:29.950112',NULL,0,77,'da8b56e53e0b4b21a8b9a579475a6d04','37b6389e0b8c44d58693f909304c85f3','gigabytes',0,0,NULL,NULL),('2025-11-22 05:52:24.372123','2025-11-22 05:52:29.950115',NULL,0,78,'da8b56e53e0b4b21a8b9a579475a6d04','37b6389e0b8c44d58693f909304c85f3','shares',0,0,NULL,NULL),('2025-11-22 05:52:24.384831','2025-11-22 05:52:29.950117','2025-11-22 05:52:33.111028',79,79,NULL,'37b6389e0b8c44d58693f909304c85f3','gigabytes',0,0,NULL,'a2eae7d4-7042-401a-973a-249989b912a4'),('2025-11-22 05:52:24.386588','2025-11-22 05:52:29.950118','2025-11-22 05:52:33.111028',80,80,NULL,'37b6389e0b8c44d58693f909304c85f3','shares',0,0,NULL,'a2eae7d4-7042-401a-973a-249989b912a4'),('2025-11-22 05:52:35.695430','2025-11-22 05:52:41.864397',NULL,0,81,'625f00565232408d9cf383ec8a96edab','a4d13c902935400e9d74b443a3eb1e97','gigabytes',0,0,NULL,NULL),('2025-11-22 05:52:35.698084','2025-11-22 05:52:41.864401',NULL,0,82,'625f00565232408d9cf383ec8a96edab','a4d13c902935400e9d74b443a3eb1e97','shares',0,0,NULL,NULL),('2025-11-22 05:52:35.712137','2025-11-22 05:52:41.864403','2025-11-22 05:52:45.127239',83,83,NULL,'a4d13c902935400e9d74b443a3eb1e97','gigabytes',0,0,NULL,'d4fe4178-7457-4c27-b05c-d200652bfa09'),('2025-11-22 05:52:35.717956','2025-11-22 05:52:41.864405','2025-11-22 05:52:45.127239',84,84,NULL,'a4d13c902935400e9d74b443a3eb1e97','shares',0,0,NULL,'d4fe4178-7457-4c27-b05c-d200652bfa09'),('2025-11-22 05:52:45.767369','2025-11-22 05:56:12.477340',NULL,0,85,'9088ff75a27c420ca8f0a42460400887','94bcd246264e4a03b75056b04f28dee8','gigabytes',0,0,NULL,NULL),('2025-11-22 05:52:45.769111','2025-11-22 05:56:12.477345',NULL,0,86,'9088ff75a27c420ca8f0a42460400887','94bcd246264e4a03b75056b04f28dee8','shares',0,0,NULL,NULL),('2025-11-22 05:52:45.780134','2025-11-22 05:56:12.477348',NULL,0,87,NULL,'94bcd246264e4a03b75056b04f28dee8','gigabytes',1,0,NULL,'3f5f10b5-5a29-4a2e-a4a9-9c80d7a9b422'),('2025-11-22 05:52:45.783790','2025-11-22 05:56:12.477350',NULL,0,88,NULL,'94bcd246264e4a03b75056b04f28dee8','shares',1,0,NULL,'3f5f10b5-5a29-4a2e-a4a9-9c80d7a9b422'),('2025-11-22 05:52:46.664461','2025-11-22 05:52:52.755132',NULL,0,89,'7b35a5763e3a490b90ea39b5f4299609','0e8baa99d2a34ced8e95c9d3736c9dcd','gigabytes',0,0,NULL,NULL),('2025-11-22 05:52:46.666029','2025-11-22 05:52:52.755135',NULL,0,90,'7b35a5763e3a490b90ea39b5f4299609','0e8baa99d2a34ced8e95c9d3736c9dcd','shares',0,0,NULL,NULL),('2025-11-22 05:52:46.674433','2025-11-22 05:52:52.755136','2025-11-22 05:52:55.821595',91,91,NULL,'0e8baa99d2a34ced8e95c9d3736c9dcd','gigabytes',0,0,NULL,'f5058f8f-6143-4b6d-8d20-02b50ffa22a6'),('2025-11-22 05:52:46.676116','2025-11-22 05:52:52.755137','2025-11-22 05:52:55.821595',92,92,NULL,'0e8baa99d2a34ced8e95c9d3736c9dcd','shares',0,0,NULL,'f5058f8f-6143-4b6d-8d20-02b50ffa22a6'),('2025-11-22 05:52:49.179620','2025-11-22 05:53:06.452034',NULL,0,93,'4de5adb2861b4b3fbe992445b625cad4','c3e25870be384f238bccdf6c103762a8','gigabytes',0,0,NULL,NULL),('2025-11-22 05:52:49.183954','2025-11-22 05:53:06.452038',NULL,0,94,'4de5adb2861b4b3fbe992445b625cad4','c3e25870be384f238bccdf6c103762a8','shares',0,0,NULL,NULL),('2025-11-22 05:52:49.200459','2025-11-22 05:53:06.452040','2025-11-22 05:53:09.677579',95,95,NULL,'c3e25870be384f238bccdf6c103762a8','gigabytes',0,0,NULL,'55c95d49-aa56-4fad-870f-b645f28cd680'),('2025-11-22 05:52:49.203087','2025-11-22 05:53:06.452041','2025-11-22 05:53:09.677579',96,96,NULL,'c3e25870be384f238bccdf6c103762a8','shares',0,0,NULL,'55c95d49-aa56-4fad-870f-b645f28cd680'),('2025-11-22 05:53:09.192676','2025-11-22 05:54:02.983190',NULL,0,97,'9b5bfcdf5ad54171a9698feaa812530a','acb08ef912784bb89000a87c4621bcc9','shares',0,0,NULL,NULL),('2025-11-22 05:53:09.194787','2025-11-22 05:54:02.983193',NULL,0,98,'9b5bfcdf5ad54171a9698feaa812530a','acb08ef912784bb89000a87c4621bcc9','gigabytes',0,0,NULL,NULL),('2025-11-22 05:53:09.203379','2025-11-22 05:54:02.983194','2025-11-22 05:54:05.767975',99,99,NULL,'acb08ef912784bb89000a87c4621bcc9','shares',0,0,NULL,'16388226-9203-43cc-b11b-c8d5e0b43cf5'),('2025-11-22 05:53:09.205894','2025-11-22 05:54:02.983195','2025-11-22 05:54:05.767975',100,100,NULL,'acb08ef912784bb89000a87c4621bcc9','gigabytes',0,0,NULL,'16388226-9203-43cc-b11b-c8d5e0b43cf5'),('2025-11-22 05:53:14.331121','2025-11-22 05:54:15.618636',NULL,0,101,'54e641a9522e40ffa67c2ca3c0b53ce6','a87583242abb48e1ba1f4d9c6aa18a9b','gigabytes',0,0,NULL,NULL),('2025-11-22 05:53:14.333480','2025-11-22 05:54:15.618643',NULL,0,102,'54e641a9522e40ffa67c2ca3c0b53ce6','a87583242abb48e1ba1f4d9c6aa18a9b','shares',0,0,NULL,NULL),('2025-11-22 05:53:14.345221','2025-11-22 05:54:15.618646','2025-11-22 05:54:18.619653',103,103,NULL,'a87583242abb48e1ba1f4d9c6aa18a9b','gigabytes',0,0,NULL,'13ee97c5-d501-438f-a1cb-88b356e6aea5'),('2025-11-22 05:53:14.347771','2025-11-22 05:54:15.618649','2025-11-22 05:54:18.619653',104,104,NULL,'a87583242abb48e1ba1f4d9c6aa18a9b','shares',0,0,NULL,'13ee97c5-d501-438f-a1cb-88b356e6aea5'),('2025-11-22 05:53:18.036043','2025-11-22 05:54:12.098110',NULL,0,105,'54e641a9522e40ffa67c2ca3c0b53ce6','a87583242abb48e1ba1f4d9c6aa18a9b','snapshots',0,0,NULL,NULL),('2025-11-22 05:53:18.055188','2025-11-22 05:54:12.098114',NULL,0,106,'54e641a9522e40ffa67c2ca3c0b53ce6','a87583242abb48e1ba1f4d9c6aa18a9b','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-22 05:53:18.069938','2025-11-22 05:54:12.098117','2025-11-22 05:54:18.619653',107,107,NULL,'a87583242abb48e1ba1f4d9c6aa18a9b','snapshots',0,0,NULL,'13ee97c5-d501-438f-a1cb-88b356e6aea5'),('2025-11-22 05:53:18.073705','2025-11-22 05:54:12.098119','2025-11-22 05:54:18.619653',108,108,NULL,'a87583242abb48e1ba1f4d9c6aa18a9b','snapshot_gigabytes',0,0,NULL,'13ee97c5-d501-438f-a1cb-88b356e6aea5'),('2025-11-22 05:53:20.107768','2025-11-22 05:53:23.726799',NULL,0,109,'e136c1b06bce4b998a5350385e9229ad','c16b253430cb40f6bf0f328197748aef','share_networks',0,0,NULL,NULL),('2025-11-22 05:53:20.563126','2025-11-22 05:53:20.786769',NULL,0,110,'d8f03b5718b045adbc9a577ce80ce1ab','b59c82aac0154932bb0672ff00781e5f','share_networks',1,0,NULL,NULL),('2025-11-22 05:53:57.659922','2025-11-22 05:54:09.360594',NULL,0,111,'c0acc593440f4aba93cebeb0a88cf188','1c76ef654a3e4144bc0a4cdf01f6107d','gigabytes',0,0,NULL,NULL),('2025-11-22 05:53:57.662053','2025-11-22 05:54:09.360597',NULL,0,112,'c0acc593440f4aba93cebeb0a88cf188','1c76ef654a3e4144bc0a4cdf01f6107d','shares',0,0,NULL,NULL),('2025-11-22 05:53:57.673690','2025-11-22 05:54:09.360598','2025-11-22 05:54:12.607453',113,113,NULL,'1c76ef654a3e4144bc0a4cdf01f6107d','gigabytes',0,0,NULL,'a5b83cc3-3a22-4b5e-9258-2ea0c4739722'),('2025-11-22 05:53:57.677131','2025-11-22 05:54:09.360599','2025-11-22 05:54:12.607453',114,114,NULL,'1c76ef654a3e4144bc0a4cdf01f6107d','shares',0,0,NULL,'a5b83cc3-3a22-4b5e-9258-2ea0c4739722'),('2025-11-22 05:54:01.085711','2025-11-22 05:54:06.098378',NULL,0,115,'c0acc593440f4aba93cebeb0a88cf188','1c76ef654a3e4144bc0a4cdf01f6107d','snapshots',0,0,NULL,NULL),('2025-11-22 05:54:01.087625','2025-11-22 05:54:06.098381',NULL,0,116,'c0acc593440f4aba93cebeb0a88cf188','1c76ef654a3e4144bc0a4cdf01f6107d','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-22 05:54:01.095191','2025-11-22 05:54:06.098382','2025-11-22 05:54:12.607453',117,117,NULL,'1c76ef654a3e4144bc0a4cdf01f6107d','snapshots',0,0,NULL,'a5b83cc3-3a22-4b5e-9258-2ea0c4739722'),('2025-11-22 05:54:01.096748','2025-11-22 05:54:06.098384','2025-11-22 05:54:12.607453',118,118,NULL,'1c76ef654a3e4144bc0a4cdf01f6107d','snapshot_gigabytes',0,0,NULL,'a5b83cc3-3a22-4b5e-9258-2ea0c4739722'),('2025-11-22 05:54:14.710113','2025-11-22 05:54:26.778048',NULL,0,119,'4a3993de61324ab4ae41b5b9d711e3a9','5c79362f5df94bb7805d87f3cb0f6a70','shares',0,0,NULL,NULL),('2025-11-22 05:54:14.714018','2025-11-22 05:54:26.778051',NULL,0,120,'4a3993de61324ab4ae41b5b9d711e3a9','5c79362f5df94bb7805d87f3cb0f6a70','gigabytes',0,0,NULL,NULL),('2025-11-22 05:54:14.731478','2025-11-22 05:54:26.778052','2025-11-22 05:54:38.163988',121,121,NULL,'5c79362f5df94bb7805d87f3cb0f6a70','shares',0,0,NULL,'a4dd46bb-4dd9-48bd-92ee-1a6f0e9dbfe6'),('2025-11-22 05:54:14.734835','2025-11-22 05:54:26.778054','2025-11-22 05:54:38.163988',122,122,NULL,'5c79362f5df94bb7805d87f3cb0f6a70','gigabytes',0,0,NULL,'a4dd46bb-4dd9-48bd-92ee-1a6f0e9dbfe6'),('2025-11-22 05:54:18.413709','2025-11-22 05:54:34.469548',NULL,0,123,'2256793bd84244a3bcb61874a41075c5','879b9840974d4a5186ae02687052f6dc','gigabytes',0,0,NULL,NULL),('2025-11-22 05:54:18.415638','2025-11-22 05:54:34.469551',NULL,0,124,'2256793bd84244a3bcb61874a41075c5','879b9840974d4a5186ae02687052f6dc','shares',0,0,NULL,NULL),('2025-11-22 05:54:18.451727','2025-11-22 05:54:34.469552','2025-11-22 05:54:38.163988',125,125,NULL,'879b9840974d4a5186ae02687052f6dc','gigabytes',0,0,NULL,'a4dd46bb-4dd9-48bd-92ee-1a6f0e9dbfe6'),('2025-11-22 05:54:18.453937','2025-11-22 05:54:34.469554','2025-11-22 05:54:38.163988',126,126,NULL,'879b9840974d4a5186ae02687052f6dc','shares',0,0,NULL,'a4dd46bb-4dd9-48bd-92ee-1a6f0e9dbfe6'),('2025-11-22 05:54:31.687631','2025-11-22 05:55:11.109134',NULL,0,127,'a118fe67fdb84bd1bef3675de0af7cc1','c1bb25e73f4845c0aa83279619d6c189','gigabytes',0,0,NULL,NULL),('2025-11-22 05:54:31.691063','2025-11-22 05:55:11.109137',NULL,0,128,'a118fe67fdb84bd1bef3675de0af7cc1','c1bb25e73f4845c0aa83279619d6c189','shares',0,0,NULL,NULL),('2025-11-22 05:54:31.706233','2025-11-22 05:54:35.598176','2025-11-22 05:55:12.500694',129,129,NULL,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',0,0,NULL,'ce3f0727-d1a8-4676-a5dc-450c47e136e8'),('2025-11-22 05:54:31.708494','2025-11-22 05:54:35.598177','2025-11-22 05:55:12.500694',130,130,NULL,'c1bb25e73f4845c0aa83279619d6c189','shares',0,0,NULL,'ce3f0727-d1a8-4676-a5dc-450c47e136e8'),('2025-11-22 05:54:35.907135','2025-11-22 05:54:39.693173','2025-11-22 05:55:12.376327',131,131,NULL,'c1bb25e73f4845c0aa83279619d6c189','shares',0,0,NULL,'dcc3507b-971d-43d8-92d2-0d2d0d8c3319'),('2025-11-22 05:54:35.909530','2025-11-22 05:54:39.693174','2025-11-22 05:55:12.376327',132,132,NULL,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',0,0,NULL,'dcc3507b-971d-43d8-92d2-0d2d0d8c3319'),('2025-11-22 05:54:39.642611','2025-11-22 05:54:45.562415',NULL,0,133,'5cd2161e545848cab1c577034bff12ab','ff09e2486e9d4c72b3f5e832bcf1885a','gigabytes',0,0,NULL,NULL),('2025-11-22 05:54:39.644365','2025-11-22 05:54:45.562419',NULL,0,134,'5cd2161e545848cab1c577034bff12ab','ff09e2486e9d4c72b3f5e832bcf1885a','shares',0,0,NULL,NULL),('2025-11-22 05:54:39.669464','2025-11-22 05:54:45.562422','2025-11-22 05:54:48.030146',135,135,NULL,'ff09e2486e9d4c72b3f5e832bcf1885a','gigabytes',0,0,NULL,'4ef04f31-d6fe-496c-bd09-358cf74fb9ed'),('2025-11-22 05:54:39.673755','2025-11-22 05:54:45.562423','2025-11-22 05:54:48.030146',136,136,NULL,'ff09e2486e9d4c72b3f5e832bcf1885a','shares',0,0,NULL,'4ef04f31-d6fe-496c-bd09-358cf74fb9ed'),('2025-11-22 05:54:39.903700','2025-11-22 05:54:47.506021','2025-11-22 05:55:12.233818',137,137,NULL,'c1bb25e73f4845c0aa83279619d6c189','shares',0,0,NULL,'08c8c52d-b3da-414c-a61c-d2410111b7e1'),('2025-11-22 05:54:39.905823','2025-11-22 05:54:47.506023','2025-11-22 05:55:12.233818',138,138,NULL,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',0,0,NULL,'08c8c52d-b3da-414c-a61c-d2410111b7e1'),('2025-11-22 05:54:43.423962','2025-11-22 05:54:47.178450','2025-11-22 05:55:12.111238',139,139,NULL,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',0,0,NULL,'69975aa8-2ab7-43ef-9ea3-bf3bb458d4bc'),('2025-11-22 05:54:43.425681','2025-11-22 05:54:47.178453','2025-11-22 05:55:12.111238',140,140,NULL,'c1bb25e73f4845c0aa83279619d6c189','shares',0,0,NULL,'69975aa8-2ab7-43ef-9ea3-bf3bb458d4bc'),('2025-11-22 05:54:47.682508','2025-11-22 05:54:59.560013','2025-11-22 05:55:11.979202',141,141,NULL,'c1bb25e73f4845c0aa83279619d6c189','shares',0,0,NULL,'087a7cbd-37cd-4168-a9ba-348c6ff7993e'),('2025-11-22 05:54:47.685321','2025-11-22 05:54:59.560014','2025-11-22 05:55:11.979202',142,142,NULL,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',0,0,NULL,'087a7cbd-37cd-4168-a9ba-348c6ff7993e'),('2025-11-22 05:54:48.344187','2025-11-22 05:55:54.853879',NULL,0,143,'eb4a2a9cc4f34eed857eeb1400d6e1e8','525ba1ccf0d546c7b4118a0855306190','gigabytes',0,0,NULL,NULL),('2025-11-22 05:54:48.348080','2025-11-22 05:55:54.853883',NULL,0,144,'eb4a2a9cc4f34eed857eeb1400d6e1e8','525ba1ccf0d546c7b4118a0855306190','shares',0,0,NULL,NULL),('2025-11-22 05:54:48.358902','2025-11-22 05:55:54.853884','2025-11-22 05:55:57.897345',145,145,NULL,'525ba1ccf0d546c7b4118a0855306190','gigabytes',0,0,NULL,'6aa6c955-bb1a-4082-b637-96733e409710'),('2025-11-22 05:54:48.361904','2025-11-22 05:55:54.853886','2025-11-22 05:55:57.897345',146,146,NULL,'525ba1ccf0d546c7b4118a0855306190','shares',0,0,NULL,'6aa6c955-bb1a-4082-b637-96733e409710'),('2025-11-22 05:54:51.354180','2025-11-22 05:54:59.322666','2025-11-22 05:55:11.861612',147,147,NULL,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',0,0,NULL,'734709e5-5e22-4d51-b713-3988d1991371'),('2025-11-22 05:54:51.357057','2025-11-22 05:54:59.322668','2025-11-22 05:55:11.861612',148,148,NULL,'c1bb25e73f4845c0aa83279619d6c189','shares',0,0,NULL,'734709e5-5e22-4d51-b713-3988d1991371'),('2025-11-22 05:54:51.942204','2025-11-22 05:55:51.013889',NULL,0,149,NULL,'525ba1ccf0d546c7b4118a0855306190','shares',0,0,NULL,'0c00f43d-e8d6-4ce6-a0df-4c4d03c8513c'),('2025-11-22 05:54:51.946945','2025-11-22 05:55:51.013890',NULL,0,150,NULL,'525ba1ccf0d546c7b4118a0855306190','gigabytes',0,0,NULL,'0c00f43d-e8d6-4ce6-a0df-4c4d03c8513c'),('2025-11-22 05:54:55.332415','2025-11-22 05:54:59.038041','2025-11-22 05:55:11.722207',151,151,NULL,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',0,0,NULL,'56215025-9394-421b-abc0-95508b2f4030'),('2025-11-22 05:54:55.335701','2025-11-22 05:54:59.038043','2025-11-22 05:55:11.722207',152,152,NULL,'c1bb25e73f4845c0aa83279619d6c189','shares',0,0,NULL,'56215025-9394-421b-abc0-95508b2f4030'),('2025-11-22 05:54:59.237735','2025-11-22 05:55:47.538352',NULL,0,153,'47d35dbda65c4554a9466657dad531d9','7c0b4b3107784ce6890ddd12d362ec8e','gigabytes',0,0,NULL,NULL),('2025-11-22 05:54:59.240421','2025-11-22 05:55:47.538355',NULL,0,154,'47d35dbda65c4554a9466657dad531d9','7c0b4b3107784ce6890ddd12d362ec8e','shares',0,0,NULL,NULL),('2025-11-22 05:54:59.257453','2025-11-22 05:55:47.538356',NULL,0,155,NULL,'7c0b4b3107784ce6890ddd12d362ec8e','gigabytes',0,0,NULL,'0c00f43d-e8d6-4ce6-a0df-4c4d03c8513c'),('2025-11-22 05:54:59.260749','2025-11-22 05:55:47.538357',NULL,0,156,NULL,'7c0b4b3107784ce6890ddd12d362ec8e','shares',0,0,NULL,'0c00f43d-e8d6-4ce6-a0df-4c4d03c8513c'),('2025-11-22 05:54:59.828142','2025-11-22 05:55:07.245889','2025-11-22 05:55:11.607491',157,157,NULL,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',0,0,NULL,'b9bcbdc8-5a4b-450b-a372-7a3b2f4ae1ab'),('2025-11-22 05:54:59.831802','2025-11-22 05:55:07.245890','2025-11-22 05:55:11.607491',158,158,NULL,'c1bb25e73f4845c0aa83279619d6c189','shares',0,0,NULL,'b9bcbdc8-5a4b-450b-a372-7a3b2f4ae1ab'),('2025-11-22 05:55:03.306490','2025-11-22 05:55:07.047139','2025-11-22 05:55:11.398154',159,159,NULL,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',0,0,NULL,'f359449b-fe9e-4653-86a0-8fec8f992613'),('2025-11-22 05:55:03.308663','2025-11-22 05:55:07.047141','2025-11-22 05:55:11.398154',160,160,NULL,'c1bb25e73f4845c0aa83279619d6c189','shares',0,0,NULL,'f359449b-fe9e-4653-86a0-8fec8f992613'),('2025-11-22 05:55:04.218822','2025-11-22 05:55:09.386593',NULL,0,161,'26ca92a37d7d41e58904a26944c79e14','8b69dc8609b24a13bee8bd080785898b','shares',0,0,NULL,NULL),('2025-11-22 05:55:04.220502','2025-11-22 05:55:09.386596',NULL,0,162,'26ca92a37d7d41e58904a26944c79e14','8b69dc8609b24a13bee8bd080785898b','gigabytes',0,0,NULL,NULL),('2025-11-22 05:55:04.231184','2025-11-22 05:55:09.386597','2025-11-22 05:55:12.340005',163,163,NULL,'8b69dc8609b24a13bee8bd080785898b','shares',0,0,NULL,'e3483182-8b2a-4128-9f1a-b73d4873cc06'),('2025-11-22 05:55:04.233640','2025-11-22 05:55:09.386598','2025-11-22 05:55:12.340005',164,164,NULL,'8b69dc8609b24a13bee8bd080785898b','gigabytes',0,0,NULL,'e3483182-8b2a-4128-9f1a-b73d4873cc06'),('2025-11-22 05:55:07.440689','2025-11-22 05:55:11.109139','2025-11-22 05:55:11.211616',165,165,NULL,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',0,0,NULL,'96afc477-3877-4b27-b4cf-f6aaa221d409'),('2025-11-22 05:55:07.444336','2025-11-22 05:55:11.109162','2025-11-22 05:55:11.211616',166,166,NULL,'c1bb25e73f4845c0aa83279619d6c189','shares',0,0,NULL,'96afc477-3877-4b27-b4cf-f6aaa221d409'),('2025-11-22 05:55:27.634652','2025-11-22 05:55:29.508445',NULL,0,167,'02fe04fccffb4086a89160251945aedb','3109e70846824a5ea61dce09df700861','share_networks',1,0,NULL,NULL),('2025-11-22 05:55:28.111416','2025-11-22 05:55:43.831736','2025-11-22 05:55:57.897345',168,168,NULL,'7c0b4b3107784ce6890ddd12d362ec8e','gigabytes',0,0,NULL,'6aa6c955-bb1a-4082-b637-96733e409710'),('2025-11-22 05:55:28.114267','2025-11-22 05:55:43.831737','2025-11-22 05:55:57.897345',169,169,NULL,'7c0b4b3107784ce6890ddd12d362ec8e','shares',0,0,NULL,'6aa6c955-bb1a-4082-b637-96733e409710'),('2025-11-22 05:55:40.635651','2025-11-22 05:55:42.845558',NULL,0,170,'2458340257d941d6b2d0260e7d70dfe3','531b9bbdeb2447818ecd6f5fccb66a8a','share_networks',0,0,NULL,NULL),('2025-11-22 05:55:47.368278','2025-11-22 05:55:51.709825',NULL,0,171,'955dc5c233b943d9982d1ee82cd2f0de','b65ccd7e2f5f4f95959c8fb179b60b78','share_networks',0,0,NULL,NULL),('2025-11-22 05:55:52.655556','2025-11-22 05:55:52.693121',NULL,0,172,'ea75f7805c74403093c0bd716bebcc3e','94bcd246264e4a03b75056b04f28dee8','shares',1,0,NULL,NULL),('2025-11-22 05:55:52.657791','2025-11-22 05:55:52.693122',NULL,0,173,'ea75f7805c74403093c0bd716bebcc3e','94bcd246264e4a03b75056b04f28dee8','gigabytes',1,0,NULL,NULL),('2025-11-22 05:56:14.619565','2025-11-22 05:56:22.564391',NULL,0,174,'4d4e495e2af243dba0ae1d8c430fed71','3520b2bd18fe4bc198c9b3ae61849514','share_networks',0,0,NULL,NULL),('2025-11-22 05:56:25.979605','2025-11-22 05:57:34.562364',NULL,0,175,'58186e0ac2da4d539ba489a92270cb59','db75a1944ad845ea9c7d9708d52f1e25','gigabytes',0,0,NULL,NULL),('2025-11-22 05:56:25.984386','2025-11-22 05:57:34.562371',NULL,0,176,'58186e0ac2da4d539ba489a92270cb59','db75a1944ad845ea9c7d9708d52f1e25','shares',0,0,NULL,NULL),('2025-11-22 05:56:26.006047','2025-11-22 05:57:34.562374','2025-11-22 05:57:37.801757',177,177,NULL,'db75a1944ad845ea9c7d9708d52f1e25','gigabytes',0,0,NULL,'bc6cfada-cc8c-44a7-8599-cc459a4ac116'),('2025-11-22 05:56:26.008548','2025-11-22 05:57:34.562377','2025-11-22 05:57:37.801757',178,178,NULL,'db75a1944ad845ea9c7d9708d52f1e25','shares',0,0,NULL,'bc6cfada-cc8c-44a7-8599-cc459a4ac116'),('2025-11-22 05:56:31.054614','2025-11-22 05:56:31.107161',NULL,0,179,'da7e1014c61944d2888458963ee6ce85','e901221ae3e949c0a2f21b3f827f2f92','share_networks',1,0,NULL,NULL),('2025-11-22 05:56:34.127904','2025-11-22 05:56:47.145805',NULL,0,180,'ff11a55c494c4d8587c6435d27704abd','faf3355c8660499394277773bc5931cb','gigabytes',1,0,NULL,NULL),('2025-11-22 05:56:34.129951','2025-11-22 05:56:47.145809',NULL,0,181,'ff11a55c494c4d8587c6435d27704abd','faf3355c8660499394277773bc5931cb','shares',1,0,NULL,NULL),('2025-11-22 05:56:34.141084','2025-11-22 05:56:47.145810','2025-11-22 05:56:51.067032',182,182,NULL,'faf3355c8660499394277773bc5931cb','gigabytes',1,0,NULL,'64c44c63-ca32-44df-83e7-0d5ad0ba1c02'),('2025-11-22 05:56:34.144467','2025-11-22 05:56:47.145811','2025-11-22 05:56:51.067032',183,183,NULL,'faf3355c8660499394277773bc5931cb','shares',1,0,NULL,'64c44c63-ca32-44df-83e7-0d5ad0ba1c02'),('2025-11-22 05:56:38.187668','2025-11-22 05:56:39.225021',NULL,0,184,'4f5c8a8f5caa48388ab293352413b72b','0cb5c96c52bc4e89961346306e373479','gigabytes',0,0,NULL,NULL),('2025-11-22 05:56:38.191518','2025-11-22 05:56:39.225025',NULL,0,185,'4f5c8a8f5caa48388ab293352413b72b','0cb5c96c52bc4e89961346306e373479','shares',0,0,NULL,NULL),('2025-11-22 05:56:38.218467','2025-11-22 05:56:38.389725',NULL,0,186,'4f5c8a8f5caa48388ab293352413b72b','faf3355c8660499394277773bc5931cb','gigabytes',-1,0,NULL,NULL),('2025-11-22 05:56:38.227816','2025-11-22 05:56:38.389728',NULL,0,187,'4f5c8a8f5caa48388ab293352413b72b','faf3355c8660499394277773bc5931cb','shares',-1,0,NULL,NULL),('2025-11-22 05:56:39.205149','2025-11-22 05:56:39.225027','2025-11-22 05:56:51.067032',188,188,NULL,'0cb5c96c52bc4e89961346306e373479','gigabytes',0,0,NULL,'64c44c63-ca32-44df-83e7-0d5ad0ba1c02'),('2025-11-22 05:56:39.210293','2025-11-22 05:56:39.225029','2025-11-22 05:56:51.067032',189,189,NULL,'0cb5c96c52bc4e89961346306e373479','shares',0,0,NULL,'64c44c63-ca32-44df-83e7-0d5ad0ba1c02'),('2025-11-22 05:56:45.274960','2025-11-22 05:57:15.624033',NULL,0,190,'c2522b58eb254cf58002dcb519ab137d','f0fc42a3cd4a4e75942e7132887f268d','gigabytes',0,0,NULL,NULL),('2025-11-22 05:56:45.277413','2025-11-22 05:57:15.624035',NULL,0,191,'c2522b58eb254cf58002dcb519ab137d','f0fc42a3cd4a4e75942e7132887f268d','shares',0,0,NULL,NULL),('2025-11-22 05:56:45.286775','2025-11-22 05:57:15.624037','2025-11-22 05:57:19.436293',192,192,NULL,'f0fc42a3cd4a4e75942e7132887f268d','gigabytes',0,0,NULL,'5426bf6e-b197-4c02-be68-82ee99c5c64e'),('2025-11-22 05:56:45.288775','2025-11-22 05:57:15.624038','2025-11-22 05:57:19.436293',193,193,NULL,'f0fc42a3cd4a4e75942e7132887f268d','shares',0,0,NULL,'5426bf6e-b197-4c02-be68-82ee99c5c64e'),('2025-11-22 05:56:59.814023','2025-11-22 05:57:01.056423',NULL,0,194,'c2522b58eb254cf58002dcb519ab137d','f0fc42a3cd4a4e75942e7132887f268d','share_groups',0,0,NULL,NULL),('2025-11-22 05:57:01.016001','2025-11-22 05:57:29.242619',NULL,0,195,'57c41b494bbf4fa981ed6b0fa212fa71','3ecbc36cc7f84bac8557dd18782914fa','gigabytes',0,0,NULL,NULL),('2025-11-22 05:57:01.017809','2025-11-22 05:57:29.242622',NULL,0,196,'57c41b494bbf4fa981ed6b0fa212fa71','3ecbc36cc7f84bac8557dd18782914fa','shares',0,0,NULL,NULL),('2025-11-22 05:57:01.028164','2025-11-22 05:57:29.242623','2025-11-22 05:57:32.341463',197,197,NULL,'3ecbc36cc7f84bac8557dd18782914fa','gigabytes',0,0,NULL,'33ab82b2-9d13-455f-b64f-cb0f7247c292'),('2025-11-22 05:57:01.029899','2025-11-22 05:57:29.242624','2025-11-22 05:57:32.341463',198,198,NULL,'3ecbc36cc7f84bac8557dd18782914fa','shares',0,0,NULL,'33ab82b2-9d13-455f-b64f-cb0f7247c292'),('2025-11-22 05:57:27.939493','2025-11-22 05:58:13.062858',NULL,0,199,'c85f7bcc3e4d40d2bc0e6a37832e885d','8179302d26964c999cd5f9a55ba9d33b','gigabytes',0,0,NULL,NULL),('2025-11-22 05:57:27.941531','2025-11-22 05:58:13.062864',NULL,0,200,'c85f7bcc3e4d40d2bc0e6a37832e885d','8179302d26964c999cd5f9a55ba9d33b','shares',0,0,NULL,NULL),('2025-11-22 05:57:27.984884','2025-11-22 05:57:39.145643','2025-11-22 05:57:42.329040',201,201,NULL,'8179302d26964c999cd5f9a55ba9d33b','gigabytes',0,0,NULL,'2b6505d8-6c33-411c-9b84-112503c4c108'),('2025-11-22 05:57:27.987024','2025-11-22 05:57:39.145646','2025-11-22 05:57:42.329040',202,202,NULL,'8179302d26964c999cd5f9a55ba9d33b','shares',0,0,NULL,'2b6505d8-6c33-411c-9b84-112503c4c108'),('2025-11-22 05:57:31.600832','2025-11-22 05:58:09.618930',NULL,0,203,'c85f7bcc3e4d40d2bc0e6a37832e885d','8179302d26964c999cd5f9a55ba9d33b','snapshots',0,0,NULL,NULL),('2025-11-22 05:57:31.605672','2025-11-22 05:58:09.618933',NULL,0,204,'c85f7bcc3e4d40d2bc0e6a37832e885d','8179302d26964c999cd5f9a55ba9d33b','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-22 05:57:31.616415','2025-11-22 05:57:35.592530','2025-11-22 05:57:42.329040',205,205,NULL,'8179302d26964c999cd5f9a55ba9d33b','snapshots',0,0,NULL,'2b6505d8-6c33-411c-9b84-112503c4c108'),('2025-11-22 05:57:31.619530','2025-11-22 05:57:35.592531','2025-11-22 05:57:42.329040',206,206,NULL,'8179302d26964c999cd5f9a55ba9d33b','snapshot_gigabytes',0,0,NULL,'2b6505d8-6c33-411c-9b84-112503c4c108'),('2025-11-22 05:57:42.622211','2025-11-22 05:57:47.797629','2025-11-22 05:58:17.475060',207,207,NULL,'8179302d26964c999cd5f9a55ba9d33b','gigabytes',0,0,NULL,'e92e4c96-7852-4844-a49a-2fed8941ce22'),('2025-11-22 05:57:42.625237','2025-11-22 05:57:47.797631','2025-11-22 05:58:17.475060',208,208,NULL,'8179302d26964c999cd5f9a55ba9d33b','shares',0,0,NULL,'e92e4c96-7852-4844-a49a-2fed8941ce22'),('2025-11-22 05:57:51.198649','2025-11-22 05:58:13.062867','2025-11-22 05:58:16.223819',209,209,NULL,'8179302d26964c999cd5f9a55ba9d33b','gigabytes',0,0,NULL,'0a1faf7d-a096-4ae6-821a-0cea16578a95'),('2025-11-22 05:57:51.200757','2025-11-22 05:58:13.062870','2025-11-22 05:58:16.223819',210,210,NULL,'8179302d26964c999cd5f9a55ba9d33b','shares',0,0,NULL,'0a1faf7d-a096-4ae6-821a-0cea16578a95'),('2025-11-22 05:57:51.838452','2025-11-22 05:58:09.618934','2025-11-22 05:58:16.223819',211,211,NULL,'8179302d26964c999cd5f9a55ba9d33b','snapshots',0,0,NULL,'0a1faf7d-a096-4ae6-821a-0cea16578a95'),('2025-11-22 05:57:51.840578','2025-11-22 05:58:09.618935','2025-11-22 05:58:16.223819',212,212,NULL,'8179302d26964c999cd5f9a55ba9d33b','snapshot_gigabytes',0,0,NULL,'0a1faf7d-a096-4ae6-821a-0cea16578a95'),('2025-11-22 05:57:53.681051','2025-11-22 05:58:42.482475',NULL,0,213,'4cb3f9c4072c4e558f4e89dc3002ce2d','1304502ff2bf4fc2bce849d08526f92d','shares',0,0,NULL,NULL),('2025-11-22 05:57:53.682826','2025-11-22 05:58:42.482478',NULL,0,214,'4cb3f9c4072c4e558f4e89dc3002ce2d','1304502ff2bf4fc2bce849d08526f92d','gigabytes',0,0,NULL,NULL),('2025-11-22 05:57:53.769387','2025-11-22 05:58:42.482479','2025-11-22 05:58:45.643435',215,215,NULL,'1304502ff2bf4fc2bce849d08526f92d','shares',0,0,NULL,'d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:57:53.771242','2025-11-22 05:58:42.482481','2025-11-22 05:58:45.643435',216,216,NULL,'1304502ff2bf4fc2bce849d08526f92d','gigabytes',0,0,NULL,'d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:57:57.392463','2025-11-22 05:58:38.959968',NULL,0,217,'4cb3f9c4072c4e558f4e89dc3002ce2d','1304502ff2bf4fc2bce849d08526f92d','snapshots',0,0,NULL,NULL),('2025-11-22 05:57:57.395369','2025-11-22 05:58:38.959972',NULL,0,218,'4cb3f9c4072c4e558f4e89dc3002ce2d','1304502ff2bf4fc2bce849d08526f92d','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-22 05:57:57.426939','2025-11-22 05:58:38.959974','2025-11-22 05:58:45.643435',219,219,NULL,'1304502ff2bf4fc2bce849d08526f92d','snapshots',0,0,NULL,'d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:57:57.432290','2025-11-22 05:58:38.959976','2025-11-22 05:58:45.643435',220,220,NULL,'1304502ff2bf4fc2bce849d08526f92d','snapshot_gigabytes',0,0,NULL,'d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:57:59.901342','2025-11-22 05:58:11.891586',NULL,0,221,'85b06cd64746426188d69928ccf28eb0','fab76ed5d22a49d0be1474f6fe848948','shares',0,0,NULL,NULL),('2025-11-22 05:57:59.903716','2025-11-22 05:58:11.891590',NULL,0,222,'85b06cd64746426188d69928ccf28eb0','fab76ed5d22a49d0be1474f6fe848948','gigabytes',0,0,NULL,NULL),('2025-11-22 05:57:59.913207','2025-11-22 05:58:11.891592','2025-11-22 05:58:14.970114',223,223,NULL,'fab76ed5d22a49d0be1474f6fe848948','shares',0,0,NULL,'47b5ed1b-aab2-4f77-a767-0d9e2aea3ca1'),('2025-11-22 05:57:59.915346','2025-11-22 05:58:11.891593','2025-11-22 05:58:14.970114',224,224,NULL,'fab76ed5d22a49d0be1474f6fe848948','gigabytes',0,0,NULL,'47b5ed1b-aab2-4f77-a767-0d9e2aea3ca1'),('2025-11-22 05:58:03.339766','2025-11-22 05:58:08.334747',NULL,0,225,'85b06cd64746426188d69928ccf28eb0','fab76ed5d22a49d0be1474f6fe848948','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-22 05:58:03.343214','2025-11-22 05:58:08.334750',NULL,0,226,'85b06cd64746426188d69928ccf28eb0','fab76ed5d22a49d0be1474f6fe848948','snapshots',0,0,NULL,NULL),('2025-11-22 05:58:03.359923','2025-11-22 05:58:08.334751','2025-11-22 05:58:14.970114',227,227,NULL,'fab76ed5d22a49d0be1474f6fe848948','snapshot_gigabytes',0,0,NULL,'47b5ed1b-aab2-4f77-a767-0d9e2aea3ca1'),('2025-11-22 05:58:03.364373','2025-11-22 05:58:08.334752','2025-11-22 05:58:14.970114',228,228,NULL,'fab76ed5d22a49d0be1474f6fe848948','snapshots',0,0,NULL,'47b5ed1b-aab2-4f77-a767-0d9e2aea3ca1'),('2025-11-22 05:58:20.964447','2025-11-22 05:58:23.851484',NULL,0,229,'135e060c52fc44c48e7f3dea40fb7352','b69436f6d3194929ace36172443c8bfa','share_networks',0,0,NULL,NULL),('2025-11-22 05:58:25.426238','2025-11-22 05:58:57.566389',NULL,0,230,'120367c7d9ec45569159d69c691c775d','57cc59807cc747c6849cfa0c21089689','shares',0,0,NULL,NULL),('2025-11-22 05:58:25.427996','2025-11-22 05:58:57.566393',NULL,0,231,'120367c7d9ec45569159d69c691c775d','57cc59807cc747c6849cfa0c21089689','gigabytes',0,0,NULL,NULL),('2025-11-22 05:58:25.439605','2025-11-22 05:58:57.566395','2025-11-22 05:58:58.905583',232,232,NULL,'57cc59807cc747c6849cfa0c21089689','shares',0,0,NULL,'cfea797e-06da-4537-b54d-22f274a0b710'),('2025-11-22 05:58:25.442330','2025-11-22 05:58:57.566397','2025-11-22 05:58:58.905583',233,233,NULL,'57cc59807cc747c6849cfa0c21089689','gigabytes',0,0,NULL,'cfea797e-06da-4537-b54d-22f274a0b710'),('2025-11-22 05:58:29.082887','2025-11-22 05:58:49.126769',NULL,0,234,'120367c7d9ec45569159d69c691c775d','57cc59807cc747c6849cfa0c21089689','snapshots',0,0,NULL,NULL),('2025-11-22 05:58:29.085176','2025-11-22 05:58:49.126772',NULL,0,235,'120367c7d9ec45569159d69c691c775d','57cc59807cc747c6849cfa0c21089689','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-22 05:58:29.190821','2025-11-22 05:58:49.126773','2025-11-22 05:58:58.905583',236,236,NULL,'57cc59807cc747c6849cfa0c21089689','snapshots',0,0,NULL,'cfea797e-06da-4537-b54d-22f274a0b710'),('2025-11-22 05:58:29.208742','2025-11-22 05:58:49.126774','2025-11-22 05:58:58.905583',237,237,NULL,'57cc59807cc747c6849cfa0c21089689','snapshot_gigabytes',0,0,NULL,'cfea797e-06da-4537-b54d-22f274a0b710'),('2025-11-22 05:58:44.423428','2025-11-22 05:59:47.109101',NULL,0,238,'3db9dedf9593479bbad4287d9e10a4d5','1e3df68b14c64c2eba82d76467788260','gigabytes',0,0,NULL,NULL),('2025-11-22 05:58:44.425223','2025-11-22 05:59:47.109107',NULL,0,239,'3db9dedf9593479bbad4287d9e10a4d5','1e3df68b14c64c2eba82d76467788260','shares',0,0,NULL,NULL),('2025-11-22 05:58:44.445170','2025-11-22 05:59:47.109110','2025-11-22 05:59:50.242761',240,240,NULL,'1e3df68b14c64c2eba82d76467788260','gigabytes',0,0,NULL,'6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:58:44.447097','2025-11-22 05:59:47.109113','2025-11-22 05:59:50.242761',241,241,NULL,'1e3df68b14c64c2eba82d76467788260','shares',0,0,NULL,'6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:58:48.268304','2025-11-22 05:59:44.048453',NULL,0,242,'3db9dedf9593479bbad4287d9e10a4d5','1e3df68b14c64c2eba82d76467788260','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-22 05:58:48.273469','2025-11-22 05:59:44.048456',NULL,0,243,'3db9dedf9593479bbad4287d9e10a4d5','1e3df68b14c64c2eba82d76467788260','snapshots',0,0,NULL,NULL),('2025-11-22 05:58:48.284739','2025-11-22 05:59:44.048457','2025-11-22 05:59:50.242761',244,244,NULL,'1e3df68b14c64c2eba82d76467788260','snapshot_gigabytes',0,0,NULL,'6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:58:48.287395','2025-11-22 05:59:44.048459','2025-11-22 05:59:50.242761',245,245,NULL,'1e3df68b14c64c2eba82d76467788260','snapshots',0,0,NULL,'6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:59:06.468119','2025-11-22 06:00:00.153290',NULL,0,246,'123ee1961f274fcf8727f7d4c1fb5248','ef497337be194fcb9ce62d89ec4f8a5a','gigabytes',0,0,NULL,NULL),('2025-11-22 05:59:06.470605','2025-11-22 06:00:00.153293',NULL,0,247,'123ee1961f274fcf8727f7d4c1fb5248','ef497337be194fcb9ce62d89ec4f8a5a','shares',0,0,NULL,NULL),('2025-11-22 05:59:06.488208','2025-11-22 06:00:00.153294','2025-11-22 06:00:03.184228',248,248,NULL,'ef497337be194fcb9ce62d89ec4f8a5a','gigabytes',0,0,NULL,'229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:06.491914','2025-11-22 06:00:00.153295','2025-11-22 06:00:03.184228',249,249,NULL,'ef497337be194fcb9ce62d89ec4f8a5a','shares',0,0,NULL,'229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:08.029917','2025-11-22 05:59:20.344201',NULL,0,250,'010135c9a64149dbb6846c9a653da6b8','325a0f56a64040c18ae384c10457495e','gigabytes',0,0,NULL,NULL),('2025-11-22 05:59:08.032067','2025-11-22 05:59:20.344206',NULL,0,251,'010135c9a64149dbb6846c9a653da6b8','325a0f56a64040c18ae384c10457495e','shares',0,0,NULL,NULL),('2025-11-22 05:59:08.042818','2025-11-22 05:59:20.344208','2025-11-22 05:59:23.394148',252,252,NULL,'325a0f56a64040c18ae384c10457495e','gigabytes',0,0,NULL,'100c722e-6c00-4303-ac29-b6525536cfc3'),('2025-11-22 05:59:08.045192','2025-11-22 05:59:20.344210','2025-11-22 05:59:23.394148',253,253,NULL,'325a0f56a64040c18ae384c10457495e','shares',0,0,NULL,'100c722e-6c00-4303-ac29-b6525536cfc3'),('2025-11-22 05:59:10.120112','2025-11-22 05:59:56.599149',NULL,0,254,'123ee1961f274fcf8727f7d4c1fb5248','ef497337be194fcb9ce62d89ec4f8a5a','snapshots',0,0,NULL,NULL),('2025-11-22 05:59:10.123773','2025-11-22 05:59:56.599153',NULL,0,255,'123ee1961f274fcf8727f7d4c1fb5248','ef497337be194fcb9ce62d89ec4f8a5a','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-22 05:59:10.137802','2025-11-22 05:59:56.599154','2025-11-22 06:00:03.184228',256,256,NULL,'ef497337be194fcb9ce62d89ec4f8a5a','snapshots',0,0,NULL,'229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:10.140545','2025-11-22 05:59:56.599155','2025-11-22 06:00:03.184228',257,257,NULL,'ef497337be194fcb9ce62d89ec4f8a5a','snapshot_gigabytes',0,0,NULL,'229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:11.457989','2025-11-22 05:59:16.682670',NULL,0,258,'010135c9a64149dbb6846c9a653da6b8','325a0f56a64040c18ae384c10457495e','snapshots',0,0,NULL,NULL),('2025-11-22 05:59:11.462191','2025-11-22 05:59:16.682674',NULL,0,259,'010135c9a64149dbb6846c9a653da6b8','325a0f56a64040c18ae384c10457495e','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-22 05:59:11.474727','2025-11-22 05:59:16.682676','2025-11-22 05:59:23.394148',260,260,NULL,'325a0f56a64040c18ae384c10457495e','snapshots',0,0,NULL,'100c722e-6c00-4303-ac29-b6525536cfc3'),('2025-11-22 05:59:11.477501','2025-11-22 05:59:16.682678','2025-11-22 05:59:23.394148',261,261,NULL,'325a0f56a64040c18ae384c10457495e','snapshot_gigabytes',0,0,NULL,'100c722e-6c00-4303-ac29-b6525536cfc3'),('2025-11-22 05:59:59.338014','2025-11-22 06:00:12.262990',NULL,0,262,'a1a7cc23204c4cc98f8e932daf5aa165','39cd34e3d99d4413afb1c277d92dcf8f','gigabytes',0,0,NULL,NULL),('2025-11-22 05:59:59.341374','2025-11-22 06:00:12.262993',NULL,0,263,'a1a7cc23204c4cc98f8e932daf5aa165','39cd34e3d99d4413afb1c277d92dcf8f','shares',0,0,NULL,NULL),('2025-11-22 05:59:59.354492','2025-11-22 06:00:12.262994','2025-11-22 06:00:15.336776',264,264,NULL,'39cd34e3d99d4413afb1c277d92dcf8f','gigabytes',0,0,NULL,'4940c47f-fec8-4869-8fba-d842e9b292ea'),('2025-11-22 05:59:59.357347','2025-11-22 06:00:12.262996','2025-11-22 06:00:15.336776',265,265,NULL,'39cd34e3d99d4413afb1c277d92dcf8f','shares',0,0,NULL,'4940c47f-fec8-4869-8fba-d842e9b292ea'),('2025-11-22 06:00:02.849823','2025-11-22 06:00:08.528875',NULL,0,266,'a1a7cc23204c4cc98f8e932daf5aa165','39cd34e3d99d4413afb1c277d92dcf8f','snapshots',0,0,NULL,NULL),('2025-11-22 06:00:02.852708','2025-11-22 06:00:08.528878',NULL,0,267,'a1a7cc23204c4cc98f8e932daf5aa165','39cd34e3d99d4413afb1c277d92dcf8f','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-22 06:00:02.869966','2025-11-22 06:00:08.528879','2025-11-22 06:00:15.336776',268,268,NULL,'39cd34e3d99d4413afb1c277d92dcf8f','snapshots',0,0,NULL,'4940c47f-fec8-4869-8fba-d842e9b292ea'),('2025-11-22 06:00:02.872460','2025-11-22 06:00:08.528880','2025-11-22 06:00:15.336776',269,269,NULL,'39cd34e3d99d4413afb1c277d92dcf8f','snapshot_gigabytes',0,0,NULL,'4940c47f-fec8-4869-8fba-d842e9b292ea');
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
INSERT INTO `quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `project_id`, `resource`, `hard_limit`) VALUES (1,'2025-11-22 05:51:06.179146',NULL,'2025-11-22 05:51:22.502293',1,'0e5f6a3a07fc4127bb51414f12d488cd','shares',3),(2,'2025-11-22 05:51:06.205654',NULL,'2025-11-22 05:51:22.502293',2,'0e5f6a3a07fc4127bb51414f12d488cd','gigabytes',10),(3,'2025-11-22 05:51:22.752691',NULL,'2025-11-22 05:51:23.304464',3,'0e5f6a3a07fc4127bb51414f12d488cd','shares',55),(4,'2025-11-22 05:51:22.758158',NULL,'2025-11-22 05:51:23.304464',4,'0e5f6a3a07fc4127bb51414f12d488cd','snapshots',55),(5,'2025-11-22 05:51:22.761945',NULL,'2025-11-22 05:51:23.304464',5,'0e5f6a3a07fc4127bb51414f12d488cd','gigabytes',1005),(6,'2025-11-22 05:51:22.765854',NULL,'2025-11-22 05:51:23.304464',6,'0e5f6a3a07fc4127bb51414f12d488cd','snapshot_gigabytes',1005),(7,'2025-11-22 05:51:22.776534',NULL,'2025-11-22 05:51:23.304464',7,'0e5f6a3a07fc4127bb51414f12d488cd','share_replicas',105),(8,'2025-11-22 05:51:22.785114',NULL,'2025-11-22 05:51:23.304464',8,'0e5f6a3a07fc4127bb51414f12d488cd','replica_gigabytes',1005),(9,'2025-11-22 05:51:23.557525',NULL,'2025-11-22 05:51:24.063663',9,'0e5f6a3a07fc4127bb51414f12d488cd','shares',55),(10,'2025-11-22 05:51:23.561480',NULL,'2025-11-22 05:51:24.063663',10,'0e5f6a3a07fc4127bb51414f12d488cd','snapshots',55),(11,'2025-11-22 05:51:23.565086',NULL,'2025-11-22 05:51:24.063663',11,'0e5f6a3a07fc4127bb51414f12d488cd','gigabytes',1005),(12,'2025-11-22 05:51:23.570088',NULL,'2025-11-22 05:51:24.063663',12,'0e5f6a3a07fc4127bb51414f12d488cd','snapshot_gigabytes',1005),(13,'2025-11-22 05:51:23.575968',NULL,'2025-11-22 05:51:24.063663',13,'0e5f6a3a07fc4127bb51414f12d488cd','share_replicas',105),(14,'2025-11-22 05:51:23.580357',NULL,'2025-11-22 05:51:24.063663',14,'0e5f6a3a07fc4127bb51414f12d488cd','replica_gigabytes',1005),(15,'2025-11-22 05:51:24.299631',NULL,'2025-11-22 05:51:24.416135',15,'0e5f6a3a07fc4127bb51414f12d488cd','shares',52),(16,'2025-11-22 05:51:24.305438',NULL,'2025-11-22 05:51:24.416135',16,'0e5f6a3a07fc4127bb51414f12d488cd','snapshots',52),(17,'2025-11-22 05:51:24.310685',NULL,'2025-11-22 05:51:24.416135',17,'0e5f6a3a07fc4127bb51414f12d488cd','gigabytes',1002),(18,'2025-11-22 05:51:24.314669',NULL,'2025-11-22 05:51:24.416135',18,'0e5f6a3a07fc4127bb51414f12d488cd','snapshot_gigabytes',1002),(19,'2025-11-22 05:51:24.319749',NULL,'2025-11-22 05:51:24.416135',19,'0e5f6a3a07fc4127bb51414f12d488cd','share_networks',12),(20,'2025-11-22 05:51:24.326123',NULL,'2025-11-22 05:51:24.416135',20,'0e5f6a3a07fc4127bb51414f12d488cd','share_replicas',102),(21,'2025-11-22 05:51:24.332809',NULL,'2025-11-22 05:51:24.416135',21,'0e5f6a3a07fc4127bb51414f12d488cd','replica_gigabytes',1002),(22,'2025-11-22 05:51:24.745611',NULL,'2025-11-22 05:51:25.330456',22,'0e5f6a3a07fc4127bb51414f12d488cd','shares',13),(23,'2025-11-22 05:51:25.426874',NULL,'2025-11-22 05:51:25.562590',23,'0e5f6a3a07fc4127bb51414f12d488cd','gigabytes',-1),(24,'2025-11-22 05:51:25.684327',NULL,'2025-11-22 05:51:25.804189',24,'0e5f6a3a07fc4127bb51414f12d488cd','share_replicas',-1),(25,'2025-11-22 05:51:25.924696',NULL,'2025-11-22 05:51:26.082814',25,'0e5f6a3a07fc4127bb51414f12d488cd','replica_gigabytes',-1),(26,'2025-11-22 05:51:26.185844',NULL,'2025-11-22 05:51:26.299630',26,'0e5f6a3a07fc4127bb51414f12d488cd','share_networks',-1),(27,'2025-11-22 05:51:26.376264',NULL,'2025-11-22 05:51:26.508063',27,'0e5f6a3a07fc4127bb51414f12d488cd','shares',-1),(28,'2025-11-22 05:51:26.617614',NULL,'2025-11-22 05:51:26.746164',28,'0e5f6a3a07fc4127bb51414f12d488cd','snapshot_gigabytes',-1),(29,'2025-11-22 05:51:26.860395',NULL,'2025-11-22 05:51:27.024849',29,'0e5f6a3a07fc4127bb51414f12d488cd','snapshots',-1),(30,'2025-11-22 05:51:32.124893',NULL,'2025-11-22 05:51:32.355020',30,'0e5f6a3a07fc4127bb51414f12d488cd','shares',10),(31,'2025-11-22 05:51:32.534231',NULL,'2025-11-22 05:51:32.694279',31,'0e5f6a3a07fc4127bb51414f12d488cd','shares',10),(32,'2025-11-22 05:51:32.836034',NULL,'2025-11-22 05:51:32.895752',32,'0e5f6a3a07fc4127bb51414f12d488cd','gigabytes',1002),(33,'2025-11-22 05:51:33.161143',NULL,'2025-11-22 05:51:33.234786',33,'0e5f6a3a07fc4127bb51414f12d488cd','share_networks',12),(34,'2025-11-22 05:51:33.491603',NULL,'2025-11-22 05:51:33.546835',34,'0e5f6a3a07fc4127bb51414f12d488cd','shares',52),(35,'2025-11-22 05:51:33.921931',NULL,'2025-11-22 05:51:34.016875',35,'0e5f6a3a07fc4127bb51414f12d488cd','snapshot_gigabytes',1002),(36,'2025-11-22 05:51:34.192700',NULL,'2025-11-22 05:51:34.307663',36,'0e5f6a3a07fc4127bb51414f12d488cd','snapshots',52),(37,'2025-11-22 05:51:34.827785',NULL,'2025-11-22 05:51:34.922782',37,'0e5f6a3a07fc4127bb51414f12d488cd','share_replicas',99),(38,'2025-11-22 05:51:35.396175',NULL,'2025-11-22 05:51:35.463163',38,'0e5f6a3a07fc4127bb51414f12d488cd','replica_gigabytes',999),(39,'2025-11-22 05:51:37.375079',NULL,'2025-11-22 05:51:37.657817',39,'0e5f6a3a07fc4127bb51414f12d488cd','shares',10),(40,'2025-11-22 05:51:37.747640',NULL,'2025-11-22 05:51:38.004298',40,'0e5f6a3a07fc4127bb51414f12d488cd','shares',10),(41,'2025-11-22 05:51:41.602183',NULL,'2025-11-22 05:51:41.820415',41,'fffa744c2146473ab31df119246a9181','shares',1),(42,'2025-11-22 05:51:45.607085',NULL,'2025-11-22 05:51:49.701979',42,'fffa744c2146473ab31df119246a9181','snapshots',1),(43,'2025-11-22 05:51:57.587689',NULL,'2025-11-22 05:51:57.760742',43,'fffa744c2146473ab31df119246a9181','shares',10),(44,'2025-11-22 05:51:57.958626',NULL,'2025-11-22 05:51:58.126654',44,'fffa744c2146473ab31df119246a9181','shares',10);
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `usage_id` (`usage_id`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=976 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `share_type_id`) VALUES ('2025-11-22 05:50:49.516892',NULL,'2025-11-22 05:50:49.636960',1,1,'3ca1144a55894a528a97f0906826d387','8a0238aa-4f5d-47c0-9224-6932a0b4248a',2,'1d43ad7bfa6f468cb936112ef76b83ec','shares',1,'2025-11-23 05:50:49',NULL),('2025-11-22 05:50:49.521332',NULL,'2025-11-22 05:50:49.636960',2,2,'3ca1144a55894a528a97f0906826d387','125580d2-bc5b-451f-aca5-cbbfd83b08d4',1,'1d43ad7bfa6f468cb936112ef76b83ec','gigabytes',1,'2025-11-23 05:50:49',NULL),('2025-11-22 05:50:49.574175',NULL,'2025-11-22 05:50:49.636960',3,3,NULL,'d7a5bad8-1b05-4d14-8a45-9a11cd10b4af',4,'1d43ad7bfa6f468cb936112ef76b83ec','shares',1,'2025-11-23 05:50:49','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:50:49.575561',NULL,'2025-11-22 05:50:49.636960',4,4,NULL,'d111b301-8885-4a50-b210-3f896bb3c483',3,'1d43ad7bfa6f468cb936112ef76b83ec','gigabytes',1,'2025-11-23 05:50:49','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:50:53.500721',NULL,'2025-11-22 05:50:53.637641',5,5,'9395a53526744acc85a47d28e0d28556','f8bc24f6-485a-4b94-a5c5-f32241a3b690',6,'9ece7a8ade98405884af4e066937cac2','shares',1,'2025-11-23 05:50:53',NULL),('2025-11-22 05:50:53.501981',NULL,'2025-11-22 05:50:53.637641',6,6,'9395a53526744acc85a47d28e0d28556','1ee8d4be-ae6d-41c3-827b-73b8168a2fcc',5,'9ece7a8ade98405884af4e066937cac2','gigabytes',1,'2025-11-23 05:50:53',NULL),('2025-11-22 05:50:53.568941',NULL,'2025-11-22 05:50:53.637641',7,7,NULL,'f1b8c348-1642-4871-af72-8ef0cdf6872c',8,'9ece7a8ade98405884af4e066937cac2','shares',1,'2025-11-23 05:50:53','72b75a26-0b62-433e-a838-9cd3b4b43b69'),('2025-11-22 05:50:53.570478',NULL,'2025-11-22 05:50:53.637641',8,8,NULL,'dbed2f16-0a3c-4a13-9e0f-f88901f09431',7,'9ece7a8ade98405884af4e066937cac2','gigabytes',1,'2025-11-23 05:50:53','72b75a26-0b62-433e-a838-9cd3b4b43b69'),('2025-11-22 05:50:53.954210',NULL,'2025-11-22 05:50:54.184399',9,9,'3ca1144a55894a528a97f0906826d387','a55a3b67-0e40-40cd-8dc9-21fc00822a9b',2,'1d43ad7bfa6f468cb936112ef76b83ec','shares',1,'2025-11-23 05:50:53',NULL),('2025-11-22 05:50:53.956840',NULL,'2025-11-22 05:50:54.184399',10,10,'3ca1144a55894a528a97f0906826d387','ee7067a9-0a77-4d24-9b03-b8c88162ae7e',1,'1d43ad7bfa6f468cb936112ef76b83ec','gigabytes',1,'2025-11-23 05:50:53',NULL),('2025-11-22 05:50:53.997662',NULL,'2025-11-22 05:50:54.184399',11,11,NULL,'97b187ac-0d13-4fc9-9022-56597d276921',4,'1d43ad7bfa6f468cb936112ef76b83ec','shares',1,'2025-11-23 05:50:53','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:50:53.998753',NULL,'2025-11-22 05:50:54.184399',12,12,NULL,'4bee536f-aeb5-4437-9464-5da8e897be27',3,'1d43ad7bfa6f468cb936112ef76b83ec','gigabytes',1,'2025-11-23 05:50:53','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:50:54.416722',NULL,'2025-11-22 05:50:54.726140',13,13,'f14080a6e5894c1998fe207d36c3a562','a4a64333-8245-4ae6-aed6-41004e3c01dd',10,'dd1f0f76d8c542febd4c75985ef66d86','shares',1,'2025-11-23 05:50:54',NULL),('2025-11-22 05:50:54.418483',NULL,'2025-11-22 05:50:54.726140',14,14,'f14080a6e5894c1998fe207d36c3a562','7d901960-4499-4788-a972-6161a5f7dcae',9,'dd1f0f76d8c542febd4c75985ef66d86','gigabytes',1,'2025-11-23 05:50:54',NULL),('2025-11-22 05:50:54.576010',NULL,'2025-11-22 05:50:54.726140',15,15,NULL,'90535574-552a-4d1f-bb35-13161ad4afdb',12,'dd1f0f76d8c542febd4c75985ef66d86','shares',1,'2025-11-23 05:50:54','5cd9ff63-cfd0-4053-a66f-0941fbf95643'),('2025-11-22 05:50:54.577436',NULL,'2025-11-22 05:50:54.726140',16,16,NULL,'d4e9327e-cccd-430e-a27e-92f0b08259c1',11,'dd1f0f76d8c542febd4c75985ef66d86','gigabytes',1,'2025-11-23 05:50:54','5cd9ff63-cfd0-4053-a66f-0941fbf95643'),('2025-11-22 05:50:57.530499',NULL,'2025-11-22 05:50:57.650865',17,17,'9395a53526744acc85a47d28e0d28556','ed308f51-c4cb-4356-8f27-97997195791e',14,'9ece7a8ade98405884af4e066937cac2','snapshots',1,'2025-11-23 05:50:57',NULL),('2025-11-22 05:50:57.531564',NULL,'2025-11-22 05:50:57.650865',18,18,'9395a53526744acc85a47d28e0d28556','4f4ca180-7366-48a6-bd15-3450d86e3067',13,'9ece7a8ade98405884af4e066937cac2','snapshot_gigabytes',1,'2025-11-23 05:50:57',NULL),('2025-11-22 05:50:57.542747',NULL,'2025-11-22 05:50:57.650865',19,19,NULL,'fd33ae9b-a880-44f0-9d38-6566d14bc83f',16,'9ece7a8ade98405884af4e066937cac2','snapshots',1,'2025-11-23 05:50:57','72b75a26-0b62-433e-a838-9cd3b4b43b69'),('2025-11-22 05:50:57.543971',NULL,'2025-11-22 05:50:57.650865',20,20,NULL,'0f267fe7-2872-4e6e-9794-57f04ff9df34',15,'9ece7a8ade98405884af4e066937cac2','snapshot_gigabytes',1,'2025-11-23 05:50:57','72b75a26-0b62-433e-a838-9cd3b4b43b69'),('2025-11-22 05:50:58.170342',NULL,'2025-11-22 05:50:58.325200',21,21,'3ca1144a55894a528a97f0906826d387','e410573a-bca5-4d60-a073-138e2d730e62',1,'1d43ad7bfa6f468cb936112ef76b83ec','gigabytes',1,'2025-11-23 05:50:58',NULL),('2025-11-22 05:50:58.182457',NULL,'2025-11-22 05:50:58.325200',22,22,NULL,'d53ef755-4875-44fc-b6fb-cc9a02c5f0f0',3,'1d43ad7bfa6f468cb936112ef76b83ec','gigabytes',1,'2025-11-23 05:50:58','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:50:59.239478',NULL,'2025-11-22 05:50:59.253519',23,23,'f14080a6e5894c1998fe207d36c3a562','71097e2d-43af-45ae-b324-352de3d23fbf',10,'dd1f0f76d8c542febd4c75985ef66d86','shares',-1,'2025-11-23 05:50:59',NULL),('2025-11-22 05:50:59.240350',NULL,'2025-11-22 05:50:59.253519',24,24,'f14080a6e5894c1998fe207d36c3a562','aa8b64fe-d7a6-42b1-a92a-a5f3f7bbd745',9,'dd1f0f76d8c542febd4c75985ef66d86','gigabytes',-1,'2025-11-23 05:50:59',NULL),('2025-11-22 05:50:59.246681',NULL,'2025-11-22 05:50:59.253519',25,25,NULL,'4db5e408-87c8-4595-ab4d-b3413cf1284c',12,'dd1f0f76d8c542febd4c75985ef66d86','shares',-1,'2025-11-23 05:50:59','5cd9ff63-cfd0-4053-a66f-0941fbf95643'),('2025-11-22 05:50:59.247321',NULL,'2025-11-22 05:50:59.253519',26,26,NULL,'e453ecff-f61d-4928-b942-fdc8820d17ad',11,'dd1f0f76d8c542febd4c75985ef66d86','gigabytes',-1,'2025-11-23 05:50:59','5cd9ff63-cfd0-4053-a66f-0941fbf95643'),('2025-11-22 05:50:59.437753',NULL,'2025-11-22 05:50:59.453706',27,27,'3ca1144a55894a528a97f0906826d387','a97d666d-9e62-4b4a-babe-bfe5f508eb8c',2,'1d43ad7bfa6f468cb936112ef76b83ec','shares',-1,'2025-11-23 05:50:59',NULL),('2025-11-22 05:50:59.438667',NULL,'2025-11-22 05:50:59.453706',28,28,'3ca1144a55894a528a97f0906826d387','87a227c5-66f0-4f9c-921e-dd2b394d00f9',1,'1d43ad7bfa6f468cb936112ef76b83ec','gigabytes',-2,'2025-11-23 05:50:59',NULL),('2025-11-22 05:50:59.445152',NULL,'2025-11-22 05:50:59.453706',29,29,NULL,'e9ef0d0a-ad51-43a3-8a23-4097c8501f53',4,'1d43ad7bfa6f468cb936112ef76b83ec','shares',-1,'2025-11-23 05:50:59','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:50:59.445929',NULL,'2025-11-22 05:50:59.453706',30,30,NULL,'5b9975e4-6d26-4cd6-8a47-8d21babd7048',3,'1d43ad7bfa6f468cb936112ef76b83ec','gigabytes',-2,'2025-11-23 05:50:59','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:51:02.705076',NULL,'2025-11-22 05:51:02.744851',31,31,'3ca1144a55894a528a97f0906826d387','06c34965-d21a-443f-b5a4-8f94efc89c5e',2,'1d43ad7bfa6f468cb936112ef76b83ec','shares',1,'2025-11-23 05:51:02',NULL),('2025-11-22 05:51:02.707526',NULL,'2025-11-22 05:51:02.744851',32,32,'3ca1144a55894a528a97f0906826d387','fbc38056-326d-4e6b-b7e4-a8115662acbf',1,'1d43ad7bfa6f468cb936112ef76b83ec','gigabytes',1,'2025-11-23 05:51:02',NULL),('2025-11-22 05:51:02.716088',NULL,'2025-11-22 05:51:02.744851',33,33,NULL,'f28a870d-463d-4042-a11f-1a8173197d81',4,'1d43ad7bfa6f468cb936112ef76b83ec','shares',1,'2025-11-23 05:51:02','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:51:02.717139',NULL,'2025-11-22 05:51:02.744851',34,34,NULL,'42df55cd-4d07-493a-8969-159cbf4b8fe8',3,'1d43ad7bfa6f468cb936112ef76b83ec','gigabytes',1,'2025-11-23 05:51:02','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:51:03.452556',NULL,'2025-11-22 05:51:04.216954',35,35,'9395a53526744acc85a47d28e0d28556','1740caee-4cb8-4d62-a81e-9758c8af6f97',14,'9ece7a8ade98405884af4e066937cac2','snapshots',-1,'2025-11-23 05:51:03',NULL),('2025-11-22 05:51:03.453241',NULL,'2025-11-22 05:51:04.216954',36,36,'9395a53526744acc85a47d28e0d28556','9e307908-b70a-4331-beb0-b247fc2263f0',13,'9ece7a8ade98405884af4e066937cac2','snapshot_gigabytes',-1,'2025-11-23 05:51:03',NULL),('2025-11-22 05:51:04.036754',NULL,'2025-11-22 05:51:04.216954',37,37,NULL,'be9665ea-c76c-471a-9b4a-5e55bb0b7eca',16,'9ece7a8ade98405884af4e066937cac2','snapshots',-1,'2025-11-23 05:51:03','72b75a26-0b62-433e-a838-9cd3b4b43b69'),('2025-11-22 05:51:04.045724',NULL,'2025-11-22 05:51:04.216954',38,38,NULL,'b0dc59c7-6427-4f55-b9a2-f53326b13c7f',15,'9ece7a8ade98405884af4e066937cac2','snapshot_gigabytes',-1,'2025-11-23 05:51:03','72b75a26-0b62-433e-a838-9cd3b4b43b69'),('2025-11-22 05:51:06.426771',NULL,'2025-11-22 05:51:06.751591',39,39,'3ca1144a55894a528a97f0906826d387','e871030e-8991-4284-b263-27accc4a4e05',1,'1d43ad7bfa6f468cb936112ef76b83ec','gigabytes',1,'2025-11-23 05:51:06',NULL),('2025-11-22 05:51:06.431519',NULL,'2025-11-22 05:51:06.751591',40,40,NULL,'c5bcc769-8298-4399-96ce-73c178df5bd2',3,'1d43ad7bfa6f468cb936112ef76b83ec','gigabytes',1,'2025-11-23 05:51:06','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:51:06.763773',NULL,'2025-11-22 05:51:06.836335',41,41,'9395a53526744acc85a47d28e0d28556','3b0e68aa-1a2d-42e5-a205-5e4cd3584c67',6,'9ece7a8ade98405884af4e066937cac2','shares',-1,'2025-11-23 05:51:06',NULL),('2025-11-22 05:51:06.764490',NULL,'2025-11-22 05:51:06.836335',42,42,'9395a53526744acc85a47d28e0d28556','3870d2d2-0752-4cff-aac1-e1511343864b',5,'9ece7a8ade98405884af4e066937cac2','gigabytes',-1,'2025-11-23 05:51:06',NULL),('2025-11-22 05:51:06.789315',NULL,'2025-11-22 05:51:06.836335',43,43,NULL,'c016e856-b4f0-4aa3-9b76-cef94643ca94',8,'9ece7a8ade98405884af4e066937cac2','shares',-1,'2025-11-23 05:51:06','72b75a26-0b62-433e-a838-9cd3b4b43b69'),('2025-11-22 05:51:06.792876',NULL,'2025-11-22 05:51:06.836335',44,44,NULL,'6555a283-25af-4e6b-b3b6-1829859cfe2a',7,'9ece7a8ade98405884af4e066937cac2','gigabytes',-1,'2025-11-23 05:51:06','72b75a26-0b62-433e-a838-9cd3b4b43b69'),('2025-11-22 05:51:07.003159',NULL,'2025-11-22 05:51:07.038038',45,45,'98f921ea69fa4cd9bf74c37b645f9733','81b1d8e7-5ff6-47b1-b37c-e05b55467da2',18,'0e5f6a3a07fc4127bb51414f12d488cd','shares',1,'2025-11-23 05:51:06',NULL),('2025-11-22 05:51:07.004957',NULL,'2025-11-22 05:51:07.038038',46,46,'98f921ea69fa4cd9bf74c37b645f9733','a1f3c19a-b187-40cf-b543-388efff6c2e6',17,'0e5f6a3a07fc4127bb51414f12d488cd','gigabytes',4,'2025-11-23 05:51:06',NULL),('2025-11-22 05:51:07.015863',NULL,'2025-11-22 05:51:07.038038',47,47,NULL,'e65a5d03-d7af-40e2-97c2-09e117bf792b',20,'0e5f6a3a07fc4127bb51414f12d488cd','shares',1,'2025-11-23 05:51:06','23542ce2-0314-4df7-8304-4afa45fe5db2'),('2025-11-22 05:51:07.016903',NULL,'2025-11-22 05:51:07.038038',48,48,NULL,'d4d61dd2-7236-4b2b-aecc-f7c389e35487',19,'0e5f6a3a07fc4127bb51414f12d488cd','gigabytes',4,'2025-11-23 05:51:06','23542ce2-0314-4df7-8304-4afa45fe5db2'),('2025-11-22 05:51:10.412997',NULL,'2025-11-22 05:51:10.425726',49,49,'3ca1144a55894a528a97f0906826d387','334c9ff9-fd2e-434b-8fc0-3fee65d5195f',2,'1d43ad7bfa6f468cb936112ef76b83ec','shares',-1,'2025-11-23 05:51:10',NULL),('2025-11-22 05:51:10.413724',NULL,'2025-11-22 05:51:10.425726',50,50,'3ca1144a55894a528a97f0906826d387','98ab8e12-3401-4e94-8e0a-53c11e055bf1',1,'1d43ad7bfa6f468cb936112ef76b83ec','gigabytes',-2,'2025-11-23 05:51:10',NULL),('2025-11-22 05:51:10.419054',NULL,'2025-11-22 05:51:10.425726',51,51,NULL,'b784b576-af1a-4cd5-9257-e60985cedbc2',4,'1d43ad7bfa6f468cb936112ef76b83ec','shares',-1,'2025-11-23 05:51:10','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:51:10.419918',NULL,'2025-11-22 05:51:10.425726',52,52,NULL,'4ea6ecd8-1ea5-4c72-a1f6-02a7cedf4125',3,'1d43ad7bfa6f468cb936112ef76b83ec','gigabytes',-2,'2025-11-23 05:51:10','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:51:10.693223',NULL,'2025-11-22 05:51:10.705882',53,53,'98f921ea69fa4cd9bf74c37b645f9733','c67a70ad-3b03-4475-95a9-5b6e0a2ab46d',18,'0e5f6a3a07fc4127bb51414f12d488cd','shares',1,'2025-11-23 05:51:10',NULL),('2025-11-22 05:51:10.695887',NULL,'2025-11-22 05:51:10.705882',54,54,'98f921ea69fa4cd9bf74c37b645f9733','a32d43ab-2798-4e2d-ae7b-270819564e94',17,'0e5f6a3a07fc4127bb51414f12d488cd','gigabytes',3,'2025-11-23 05:51:10',NULL),('2025-11-22 05:51:11.104453',NULL,'2025-11-22 05:51:11.142410',55,55,'98f921ea69fa4cd9bf74c37b645f9733','b7e6ad5c-75c5-4625-8609-ec8b845f8974',18,'0e5f6a3a07fc4127bb51414f12d488cd','shares',1,'2025-11-23 05:51:11',NULL),('2025-11-22 05:51:11.106031',NULL,'2025-11-22 05:51:11.142410',56,56,'98f921ea69fa4cd9bf74c37b645f9733','3c02dcb7-1132-4ae9-a36f-71fda0bf041a',17,'0e5f6a3a07fc4127bb51414f12d488cd','gigabytes',3,'2025-11-23 05:51:11',NULL),('2025-11-22 05:51:11.117918',NULL,'2025-11-22 05:51:11.142410',57,57,NULL,'b551cd7e-cbbd-4395-b2f4-64b84f3d2475',22,'0e5f6a3a07fc4127bb51414f12d488cd','shares',1,'2025-11-23 05:51:11','5e508b15-d618-4a27-8b79-1b26df71e665'),('2025-11-22 05:51:11.119454',NULL,'2025-11-22 05:51:11.142410',58,58,NULL,'524066b8-4d76-42a6-a79d-54501e04939a',21,'0e5f6a3a07fc4127bb51414f12d488cd','gigabytes',3,'2025-11-23 05:51:11','5e508b15-d618-4a27-8b79-1b26df71e665'),('2025-11-22 05:51:13.637307',NULL,'2025-11-22 05:51:13.771072',59,59,'3ca1144a55894a528a97f0906826d387','366289bd-1bb3-4e2f-8698-4cf05d6e0f70',2,'1d43ad7bfa6f468cb936112ef76b83ec','shares',1,'2025-11-23 05:51:13',NULL),('2025-11-22 05:51:13.638407',NULL,'2025-11-22 05:51:13.771072',60,60,'3ca1144a55894a528a97f0906826d387','14a9a5d6-67f1-48d2-9a8c-f89690bfdc15',1,'1d43ad7bfa6f468cb936112ef76b83ec','gigabytes',1,'2025-11-23 05:51:13',NULL),('2025-11-22 05:51:13.676490',NULL,'2025-11-22 05:51:13.771072',61,61,NULL,'47e2e2df-6d42-437e-8e58-f8cea84919d7',4,'1d43ad7bfa6f468cb936112ef76b83ec','shares',1,'2025-11-23 05:51:13','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:51:13.677854',NULL,'2025-11-22 05:51:13.771072',62,62,NULL,'ee03f00b-4a7f-4eaa-ab42-d5a6c44eeb12',3,'1d43ad7bfa6f468cb936112ef76b83ec','gigabytes',1,'2025-11-23 05:51:13','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:51:15.283085',NULL,'2025-11-22 05:51:15.300018',63,63,'98f921ea69fa4cd9bf74c37b645f9733','e368c04d-1e62-41a8-b1d8-15f7ca5eb74f',18,'0e5f6a3a07fc4127bb51414f12d488cd','shares',-1,'2025-11-23 05:51:15',NULL),('2025-11-22 05:51:15.283866',NULL,'2025-11-22 05:51:15.300018',64,64,'98f921ea69fa4cd9bf74c37b645f9733','47b17ea6-035f-4997-bfb2-9889cfd77cae',17,'0e5f6a3a07fc4127bb51414f12d488cd','gigabytes',-4,'2025-11-23 05:51:15',NULL),('2025-11-22 05:51:15.289428',NULL,'2025-11-22 05:51:15.300018',65,65,NULL,'a1e94baa-8eca-46da-97a8-93456bf12606',20,'0e5f6a3a07fc4127bb51414f12d488cd','shares',-1,'2025-11-23 05:51:15','23542ce2-0314-4df7-8304-4afa45fe5db2'),('2025-11-22 05:51:15.290031',NULL,'2025-11-22 05:51:15.300018',66,66,NULL,'77f583b9-6815-4ab5-9d58-48a2e7ab86fa',19,'0e5f6a3a07fc4127bb51414f12d488cd','gigabytes',-4,'2025-11-23 05:51:15','23542ce2-0314-4df7-8304-4afa45fe5db2'),('2025-11-22 05:51:15.673922',NULL,'2025-11-22 05:51:15.704393',67,67,'3a798de8dc964838b12715c65c83b403','fe43ac3d-0038-4413-9769-b87f17ab68bc',24,'9a040dac65f744c687d2d5814d775f6c','shares',1,'2025-11-23 05:51:15',NULL),('2025-11-22 05:51:15.675407',NULL,'2025-11-22 05:51:15.704393',68,68,'3a798de8dc964838b12715c65c83b403','d82082c3-7a61-4afb-8512-2a42f8d35da6',23,'9a040dac65f744c687d2d5814d775f6c','gigabytes',1,'2025-11-23 05:51:15',NULL),('2025-11-22 05:51:15.684785',NULL,'2025-11-22 05:51:15.704393',69,69,NULL,'745dc2fd-5f48-4d06-b507-65581aa741a3',26,'9a040dac65f744c687d2d5814d775f6c','shares',1,'2025-11-23 05:51:15','4b9d7651-19c5-43ac-bb58-20f5ebca2afc'),('2025-11-22 05:51:15.685739',NULL,'2025-11-22 05:51:15.704393',70,70,NULL,'f5544870-9abe-4e93-bbd9-305a451b4559',25,'9a040dac65f744c687d2d5814d775f6c','gigabytes',1,'2025-11-23 05:51:15','4b9d7651-19c5-43ac-bb58-20f5ebca2afc'),('2025-11-22 05:51:18.062746',NULL,'2025-11-22 05:51:18.077756',71,71,'3ca1144a55894a528a97f0906826d387','83574969-00f0-4dd6-a4e3-58ea41850cb0',2,'1d43ad7bfa6f468cb936112ef76b83ec','shares',-1,'2025-11-23 05:51:18',NULL),('2025-11-22 05:51:18.063453',NULL,'2025-11-22 05:51:18.077756',72,72,'3ca1144a55894a528a97f0906826d387','e88d55b7-3595-41fd-a65f-80ac4d209fbe',1,'1d43ad7bfa6f468cb936112ef76b83ec','gigabytes',-1,'2025-11-23 05:51:18',NULL),('2025-11-22 05:51:18.069242',NULL,'2025-11-22 05:51:18.077756',73,73,NULL,'f18bb271-f2fb-4534-9c2f-aeb2ceb9955d',4,'1d43ad7bfa6f468cb936112ef76b83ec','shares',-1,'2025-11-23 05:51:18','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:51:18.070293',NULL,'2025-11-22 05:51:18.077756',74,74,NULL,'b154c046-fb3c-4e06-8a2e-325865f82149',3,'1d43ad7bfa6f468cb936112ef76b83ec','gigabytes',-1,'2025-11-23 05:51:18','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:51:18.773810',NULL,'2025-11-22 05:51:18.792564',75,75,'98f921ea69fa4cd9bf74c37b645f9733','6a639952-9e97-4560-8f41-ac2bda5e32c1',18,'0e5f6a3a07fc4127bb51414f12d488cd','shares',-1,'2025-11-23 05:51:18',NULL),('2025-11-22 05:51:18.774581',NULL,'2025-11-22 05:51:18.792564',76,76,'98f921ea69fa4cd9bf74c37b645f9733','ad08692d-6c53-4b52-885e-82094f36bdf4',17,'0e5f6a3a07fc4127bb51414f12d488cd','gigabytes',-3,'2025-11-23 05:51:18',NULL),('2025-11-22 05:51:18.782631',NULL,'2025-11-22 05:51:18.792564',77,77,NULL,'35fe92f7-293e-4b5d-bbdc-63e8c8a166aa',22,'0e5f6a3a07fc4127bb51414f12d488cd','shares',-1,'2025-11-23 05:51:18','5e508b15-d618-4a27-8b79-1b26df71e665'),('2025-11-22 05:51:18.783519',NULL,'2025-11-22 05:51:18.792564',78,78,NULL,'8cf6957c-9e67-4a36-b01a-64a337b3495e',21,'0e5f6a3a07fc4127bb51414f12d488cd','gigabytes',-3,'2025-11-23 05:51:18','5e508b15-d618-4a27-8b79-1b26df71e665'),('2025-11-22 05:51:19.072782',NULL,'2025-11-22 05:51:19.100161',79,79,'4ec9dc11277c4a1283c49e6e6a186cf5','aafea18d-c445-4012-b356-7b1de53b0c6a',28,'dd17ac9b721a4caaa440f97988ad0956','shares',1,'2025-11-23 05:51:19',NULL),('2025-11-22 05:51:19.073931',NULL,'2025-11-22 05:51:19.100161',80,80,'4ec9dc11277c4a1283c49e6e6a186cf5','ad2fd0e2-0d61-4ba0-ad5a-d3a7804eb013',27,'dd17ac9b721a4caaa440f97988ad0956','gigabytes',1,'2025-11-23 05:51:19',NULL),('2025-11-22 05:51:19.083320',NULL,'2025-11-22 05:51:19.100161',81,81,NULL,'67475dd5-1765-40fe-b89a-74a9f1fe61ae',30,'dd17ac9b721a4caaa440f97988ad0956','shares',1,'2025-11-23 05:51:19','01f563c6-5fd0-4f02-bfc6-595c6cff9c84'),('2025-11-22 05:51:19.084379',NULL,'2025-11-22 05:51:19.100161',82,82,NULL,'cad5633e-8f81-4aec-87ea-ecfc4abb2f06',29,'dd17ac9b721a4caaa440f97988ad0956','gigabytes',1,'2025-11-23 05:51:19','01f563c6-5fd0-4f02-bfc6-595c6cff9c84'),('2025-11-22 05:51:19.503949',NULL,'2025-11-22 05:51:19.551803',83,83,'3a798de8dc964838b12715c65c83b403','48a6d803-5ffb-408f-9503-bb1d327978f0',24,'9a040dac65f744c687d2d5814d775f6c','shares',-1,'2025-11-23 05:51:19',NULL),('2025-11-22 05:51:19.504549',NULL,'2025-11-22 05:51:19.551803',84,84,'3a798de8dc964838b12715c65c83b403','4202578e-7cdb-4e51-a276-d0ee4cfbc16e',23,'9a040dac65f744c687d2d5814d775f6c','gigabytes',-1,'2025-11-23 05:51:19',NULL),('2025-11-22 05:51:19.515798',NULL,'2025-11-22 05:51:19.551803',85,85,NULL,'2c9dda42-ef94-4181-bded-4f36b5f87338',26,'9a040dac65f744c687d2d5814d775f6c','shares',-1,'2025-11-23 05:51:19','4b9d7651-19c5-43ac-bb58-20f5ebca2afc'),('2025-11-22 05:51:19.522424',NULL,'2025-11-22 05:51:19.551803',86,86,NULL,'1bd4dae9-47cf-4ea6-8227-4f91bb833bdc',25,'9a040dac65f744c687d2d5814d775f6c','gigabytes',-1,'2025-11-23 05:51:19','4b9d7651-19c5-43ac-bb58-20f5ebca2afc'),('2025-11-22 05:51:19.773773',NULL,'2025-11-22 05:51:19.810976',87,87,'3a798de8dc964838b12715c65c83b403','ce594678-60f8-488d-8834-b7cb42df70d7',24,'9a040dac65f744c687d2d5814d775f6c','shares',1,'2025-11-23 05:51:19',NULL),('2025-11-22 05:51:19.775083',NULL,'2025-11-22 05:51:19.810976',88,88,'3a798de8dc964838b12715c65c83b403','f3a11b3d-f4af-4ef6-8be5-3288a1813885',23,'9a040dac65f744c687d2d5814d775f6c','gigabytes',1,'2025-11-23 05:51:19',NULL),('2025-11-22 05:51:19.785572',NULL,'2025-11-22 05:51:19.810976',89,89,NULL,'26a7dcd7-405c-497b-8983-ceb311283c87',32,'9a040dac65f744c687d2d5814d775f6c','shares',1,'2025-11-23 05:51:19','d6624012-6e58-49fd-92c2-41fff579b962'),('2025-11-22 05:51:19.788185',NULL,'2025-11-22 05:51:19.810976',90,90,NULL,'b428c845-8d0c-4ff8-982f-3fcb66ac6af3',31,'9a040dac65f744c687d2d5814d775f6c','gigabytes',1,'2025-11-23 05:51:19','d6624012-6e58-49fd-92c2-41fff579b962'),('2025-11-22 05:51:21.337076',NULL,'2025-11-22 05:51:21.374072',91,91,'3ca1144a55894a528a97f0906826d387','9efac3a6-79ff-43d6-b688-42437d0cb8be',2,'1d43ad7bfa6f468cb936112ef76b83ec','shares',1,'2025-11-23 05:51:21',NULL),('2025-11-22 05:51:21.340345',NULL,'2025-11-22 05:51:21.374072',92,92,'3ca1144a55894a528a97f0906826d387','b3db96ba-13c3-4093-93ce-51e67e524523',1,'1d43ad7bfa6f468cb936112ef76b83ec','gigabytes',1,'2025-11-23 05:51:21',NULL),('2025-11-22 05:51:21.349360',NULL,'2025-11-22 05:51:21.374072',93,93,NULL,'a48544f3-8b87-4e5c-b2d2-1f91842cbd77',4,'1d43ad7bfa6f468cb936112ef76b83ec','shares',1,'2025-11-23 05:51:21','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:51:21.351370',NULL,'2025-11-22 05:51:21.374072',94,94,NULL,'10daeaba-8d2c-40ec-8f11-4dc1e1de6ed7',3,'1d43ad7bfa6f468cb936112ef76b83ec','gigabytes',1,'2025-11-23 05:51:21','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:51:23.429342',NULL,'2025-11-22 05:51:23.449210',95,95,'3a798de8dc964838b12715c65c83b403','8d3d8b3a-f63c-4399-a619-aa40ea1a5f31',24,'9a040dac65f744c687d2d5814d775f6c','shares',-1,'2025-11-23 05:51:23',NULL),('2025-11-22 05:51:23.430366',NULL,'2025-11-22 05:51:23.449210',96,96,'3a798de8dc964838b12715c65c83b403','c91124bd-c223-4351-9950-a06d7ca06b26',23,'9a040dac65f744c687d2d5814d775f6c','gigabytes',-1,'2025-11-23 05:51:23',NULL),('2025-11-22 05:51:23.439776',NULL,'2025-11-22 05:51:23.449210',97,97,NULL,'2a37b658-edaa-4de4-bb81-56f49e9a988d',32,'9a040dac65f744c687d2d5814d775f6c','shares',-1,'2025-11-23 05:51:23','d6624012-6e58-49fd-92c2-41fff579b962'),('2025-11-22 05:51:23.440724',NULL,'2025-11-22 05:51:23.449210',98,98,NULL,'09754432-0bce-4c15-bf22-8571d4c6b3d4',31,'9a040dac65f744c687d2d5814d775f6c','gigabytes',-1,'2025-11-23 05:51:23','d6624012-6e58-49fd-92c2-41fff579b962'),('2025-11-22 05:51:23.683118',NULL,'2025-11-22 05:51:23.722837',99,99,'3a798de8dc964838b12715c65c83b403','c06df01c-e810-486e-8147-6f340ad883d2',24,'9a040dac65f744c687d2d5814d775f6c','shares',1,'2025-11-23 05:51:23',NULL),('2025-11-22 05:51:23.685682',NULL,'2025-11-22 05:51:23.722837',100,100,'3a798de8dc964838b12715c65c83b403','4353bcf2-5228-4855-a8c9-c3bb84226c71',23,'9a040dac65f744c687d2d5814d775f6c','gigabytes',1,'2025-11-23 05:51:23',NULL),('2025-11-22 05:51:23.696940',NULL,'2025-11-22 05:51:23.722837',101,101,NULL,'b2e71183-274c-4a6d-aa3b-df94bec3af8c',34,'9a040dac65f744c687d2d5814d775f6c','shares',1,'2025-11-23 05:51:23','ba0277e3-3973-4052-b400-a5c0085d5c63'),('2025-11-22 05:51:23.698391',NULL,'2025-11-22 05:51:23.722837',102,102,NULL,'ca71884f-dde7-4f32-a453-93aaf8c0688e',33,'9a040dac65f744c687d2d5814d775f6c','gigabytes',1,'2025-11-23 05:51:23','ba0277e3-3973-4052-b400-a5c0085d5c63'),('2025-11-22 05:51:25.429033',NULL,'2025-11-22 05:51:25.459642',103,103,'3ca1144a55894a528a97f0906826d387','50d6dbcf-b7f6-4000-a747-1d579d03f528',2,'1d43ad7bfa6f468cb936112ef76b83ec','shares',-1,'2025-11-23 05:51:25',NULL),('2025-11-22 05:51:25.430243',NULL,'2025-11-22 05:51:25.459642',104,104,'3ca1144a55894a528a97f0906826d387','70128121-cd2e-4f1d-ac85-3dcda0cf9f48',1,'1d43ad7bfa6f468cb936112ef76b83ec','gigabytes',-1,'2025-11-23 05:51:25',NULL),('2025-11-22 05:51:25.442558',NULL,'2025-11-22 05:51:25.459642',105,105,NULL,'ac920897-28d2-4acb-9540-86253f679b06',4,'1d43ad7bfa6f468cb936112ef76b83ec','shares',-1,'2025-11-23 05:51:25','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:51:25.443766',NULL,'2025-11-22 05:51:25.459642',106,106,NULL,'759885b8-7dcd-469c-8145-d6596a72739a',3,'1d43ad7bfa6f468cb936112ef76b83ec','gigabytes',-1,'2025-11-23 05:51:25','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:51:25.523760',NULL,'2025-11-22 05:51:25.548296',107,107,'4ec9dc11277c4a1283c49e6e6a186cf5','de1d16f6-4a8e-493b-b6e9-2ba27fdbab0f',28,'dd17ac9b721a4caaa440f97988ad0956','shares',-1,'2025-11-23 05:51:25',NULL),('2025-11-22 05:51:25.524714',NULL,'2025-11-22 05:51:25.548296',108,108,'4ec9dc11277c4a1283c49e6e6a186cf5','a90d0d9f-b3c0-4c18-ace0-869b1fddac34',27,'dd17ac9b721a4caaa440f97988ad0956','gigabytes',-1,'2025-11-23 05:51:25',NULL),('2025-11-22 05:51:25.535017',NULL,'2025-11-22 05:51:25.548296',109,109,NULL,'905ac109-094f-4424-8020-bc398b83593f',30,'dd17ac9b721a4caaa440f97988ad0956','shares',-1,'2025-11-23 05:51:25','01f563c6-5fd0-4f02-bfc6-595c6cff9c84'),('2025-11-22 05:51:25.535790',NULL,'2025-11-22 05:51:25.548296',110,110,NULL,'7db63e00-d4c9-48b9-b859-a2da163efddd',29,'dd17ac9b721a4caaa440f97988ad0956','gigabytes',-1,'2025-11-23 05:51:25','01f563c6-5fd0-4f02-bfc6-595c6cff9c84'),('2025-11-22 05:51:27.434760',NULL,'2025-11-22 05:51:27.450960',111,111,'3a798de8dc964838b12715c65c83b403','40e795cd-0741-4e35-90e2-68359907c67b',24,'9a040dac65f744c687d2d5814d775f6c','shares',-1,'2025-11-23 05:51:27',NULL),('2025-11-22 05:51:27.435968',NULL,'2025-11-22 05:51:27.450960',112,112,'3a798de8dc964838b12715c65c83b403','6b6f72b5-240d-4ef4-9b62-4dad5aefe092',23,'9a040dac65f744c687d2d5814d775f6c','gigabytes',-1,'2025-11-23 05:51:27',NULL),('2025-11-22 05:51:27.441830',NULL,'2025-11-22 05:51:27.450960',113,113,NULL,'7c2ca1c5-a05b-4640-9aa4-d8453c676e02',34,'9a040dac65f744c687d2d5814d775f6c','shares',-1,'2025-11-23 05:51:27','ba0277e3-3973-4052-b400-a5c0085d5c63'),('2025-11-22 05:51:27.442457',NULL,'2025-11-22 05:51:27.450960',114,114,NULL,'16fd270f-331c-478b-abc7-fe1b282deabf',33,'9a040dac65f744c687d2d5814d775f6c','gigabytes',-1,'2025-11-23 05:51:27','ba0277e3-3973-4052-b400-a5c0085d5c63'),('2025-11-22 05:51:27.650682',NULL,'2025-11-22 05:51:27.685994',115,115,'3a798de8dc964838b12715c65c83b403','d27e2a89-d141-4a1f-bfc4-de0d1526202e',24,'9a040dac65f744c687d2d5814d775f6c','shares',1,'2025-11-23 05:51:27',NULL),('2025-11-22 05:51:27.652237',NULL,'2025-11-22 05:51:27.685994',116,116,'3a798de8dc964838b12715c65c83b403','bba5761c-7184-41e9-a770-3f889181b29f',23,'9a040dac65f744c687d2d5814d775f6c','gigabytes',1,'2025-11-23 05:51:27',NULL),('2025-11-22 05:51:27.666670',NULL,'2025-11-22 05:51:27.685994',117,117,NULL,'96a2df62-b05b-4b69-95b2-32290e2b94e0',35,'9a040dac65f744c687d2d5814d775f6c','shares',1,'2025-11-23 05:51:27','170222eb-0fff-44bb-9ac3-bc5681dd8de2'),('2025-11-22 05:51:27.667706',NULL,'2025-11-22 05:51:27.685994',118,118,NULL,'30aa6f6d-2445-4842-9c71-021ed417c761',36,'9a040dac65f744c687d2d5814d775f6c','gigabytes',1,'2025-11-23 05:51:27','170222eb-0fff-44bb-9ac3-bc5681dd8de2'),('2025-11-22 05:51:28.570951',NULL,'2025-11-22 05:51:28.649471',119,119,'3ca1144a55894a528a97f0906826d387','774b5765-9111-4939-b4cc-1829ba9bb3ec',37,'1d43ad7bfa6f468cb936112ef76b83ec','snapshots',1,'2025-11-23 05:51:28',NULL),('2025-11-22 05:51:28.572430',NULL,'2025-11-22 05:51:28.649471',120,120,'3ca1144a55894a528a97f0906826d387','5a8a8aa0-094c-4104-8d5b-080868183bbf',38,'1d43ad7bfa6f468cb936112ef76b83ec','snapshot_gigabytes',1,'2025-11-23 05:51:28',NULL),('2025-11-22 05:51:28.586002',NULL,'2025-11-22 05:51:28.649471',121,121,NULL,'a5c8f36e-dcde-4b07-9266-c1bc6e4faf98',39,'1d43ad7bfa6f468cb936112ef76b83ec','snapshots',1,'2025-11-23 05:51:28','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:51:28.588051',NULL,'2025-11-22 05:51:28.649471',122,122,NULL,'c4b53aaf-6085-4287-a10c-cb0700cb63a8',40,'1d43ad7bfa6f468cb936112ef76b83ec','snapshot_gigabytes',1,'2025-11-23 05:51:28','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:51:31.336960',NULL,'2025-11-22 05:51:31.355138',123,123,'3a798de8dc964838b12715c65c83b403','27514a07-7c91-42d4-9d3e-c1a7dc67f28b',24,'9a040dac65f744c687d2d5814d775f6c','shares',-1,'2025-11-23 05:51:31',NULL),('2025-11-22 05:51:31.337624',NULL,'2025-11-22 05:51:31.355138',124,124,'3a798de8dc964838b12715c65c83b403','04baa4fe-8b7b-42b4-ab9b-3222d9a05df2',23,'9a040dac65f744c687d2d5814d775f6c','gigabytes',-1,'2025-11-23 05:51:31',NULL),('2025-11-22 05:51:31.347665',NULL,'2025-11-22 05:51:31.355138',125,125,NULL,'dc9ea4ff-d50e-4b1b-9dc2-edbf65cb0df2',35,'9a040dac65f744c687d2d5814d775f6c','shares',-1,'2025-11-23 05:51:31','170222eb-0fff-44bb-9ac3-bc5681dd8de2'),('2025-11-22 05:51:31.348408',NULL,'2025-11-22 05:51:31.355138',126,126,NULL,'f75b42e8-8dd9-4cc3-a124-e41688a6f8c6',36,'9a040dac65f744c687d2d5814d775f6c','gigabytes',-1,'2025-11-23 05:51:31','170222eb-0fff-44bb-9ac3-bc5681dd8de2'),('2025-11-22 05:51:31.681146',NULL,'2025-11-22 05:51:31.713085',127,127,'3a798de8dc964838b12715c65c83b403','b421b99a-5bd0-4312-bbc5-b6820d677d25',24,'9a040dac65f744c687d2d5814d775f6c','shares',1,'2025-11-23 05:51:31',NULL),('2025-11-22 05:51:31.682333',NULL,'2025-11-22 05:51:31.713085',128,128,'3a798de8dc964838b12715c65c83b403','2a6d8aab-9878-42d8-a1aa-a1d46d576a6c',23,'9a040dac65f744c687d2d5814d775f6c','gigabytes',1,'2025-11-23 05:51:31',NULL),('2025-11-22 05:51:31.694774',NULL,'2025-11-22 05:51:31.713085',129,129,NULL,'7ed8de3a-303a-4b78-ae7c-edef870f1bc9',42,'9a040dac65f744c687d2d5814d775f6c','shares',1,'2025-11-23 05:51:31','2b6b3050-6c17-4581-9b45-8c5482542326'),('2025-11-22 05:51:31.695848',NULL,'2025-11-22 05:51:31.713085',130,130,NULL,'28538a0c-be6e-4113-84fc-46711be18559',41,'9a040dac65f744c687d2d5814d775f6c','gigabytes',1,'2025-11-23 05:51:31','2b6b3050-6c17-4581-9b45-8c5482542326'),('2025-11-22 05:51:32.562922',NULL,'2025-11-22 05:51:32.578387',131,131,'3ca1144a55894a528a97f0906826d387','5eeb342f-ceca-461c-96e5-d7615ff0e0b1',37,'1d43ad7bfa6f468cb936112ef76b83ec','snapshots',-1,'2025-11-23 05:51:32',NULL),('2025-11-22 05:51:32.564038',NULL,'2025-11-22 05:51:32.578387',132,132,'3ca1144a55894a528a97f0906826d387','770fd7f1-cd33-43a2-a48e-576a3a1d2d16',38,'1d43ad7bfa6f468cb936112ef76b83ec','snapshot_gigabytes',-1,'2025-11-23 05:51:32',NULL),('2025-11-22 05:51:32.569009',NULL,'2025-11-22 05:51:32.578387',133,133,NULL,'f01a22aa-3ff2-423c-acbd-118a34d77580',39,'1d43ad7bfa6f468cb936112ef76b83ec','snapshots',-1,'2025-11-23 05:51:32','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:51:32.569679',NULL,'2025-11-22 05:51:32.578387',134,134,NULL,'cee6e85e-237f-4c71-b2d9-04c3bbe8223e',40,'1d43ad7bfa6f468cb936112ef76b83ec','snapshot_gigabytes',-1,'2025-11-23 05:51:32','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:51:35.265516',NULL,'2025-11-22 05:51:35.325794',135,135,'3a798de8dc964838b12715c65c83b403','b2229b5c-0335-4a7e-a4c9-5fae74c40ac3',24,'9a040dac65f744c687d2d5814d775f6c','shares',-1,'2025-11-23 05:51:35',NULL),('2025-11-22 05:51:35.267589',NULL,'2025-11-22 05:51:35.325794',136,136,'3a798de8dc964838b12715c65c83b403','83389e97-84af-4d01-a926-b09131e2e480',23,'9a040dac65f744c687d2d5814d775f6c','gigabytes',-1,'2025-11-23 05:51:35',NULL),('2025-11-22 05:51:35.316946',NULL,'2025-11-22 05:51:35.325794',137,137,NULL,'a38ccfaf-ad85-484f-ae34-c469b7b0fcc5',42,'9a040dac65f744c687d2d5814d775f6c','shares',-1,'2025-11-23 05:51:35','2b6b3050-6c17-4581-9b45-8c5482542326'),('2025-11-22 05:51:35.318076',NULL,'2025-11-22 05:51:35.325794',138,138,NULL,'b29051fb-a10d-405c-acf8-60d4c55d1fcb',41,'9a040dac65f744c687d2d5814d775f6c','gigabytes',-1,'2025-11-23 05:51:35','2b6b3050-6c17-4581-9b45-8c5482542326'),('2025-11-22 05:51:37.878297',NULL,'2025-11-22 05:51:37.919972',139,139,'19063b71466b4a099f4798ea400aed7c','d23a5b84-e52e-40af-8714-c300cc5c3eff',43,'fffa744c2146473ab31df119246a9181','shares',1,'2025-11-23 05:51:37',NULL),('2025-11-22 05:51:37.880201',NULL,'2025-11-22 05:51:37.919972',140,140,'19063b71466b4a099f4798ea400aed7c','958d7f76-c1f8-4001-8761-f07f59b3e543',44,'fffa744c2146473ab31df119246a9181','gigabytes',1,'2025-11-23 05:51:37',NULL),('2025-11-22 05:51:37.893418',NULL,'2025-11-22 05:51:37.919972',141,141,NULL,'3179f388-ee36-42d4-909c-57ac2a69b20a',45,'fffa744c2146473ab31df119246a9181','shares',1,'2025-11-23 05:51:37','76b8f610-7bd5-4886-9698-850dd629ddbd'),('2025-11-22 05:51:37.895366',NULL,'2025-11-22 05:51:37.919972',142,142,NULL,'195b995b-de44-4150-be4d-8408c2b4ff8b',46,'fffa744c2146473ab31df119246a9181','gigabytes',1,'2025-11-23 05:51:37','76b8f610-7bd5-4886-9698-850dd629ddbd'),('2025-11-22 05:51:41.778916',NULL,'2025-11-22 05:51:41.854042',143,143,'3ca1144a55894a528a97f0906826d387','4faf7f4c-4524-49ec-9359-c1c947ab3f57',37,'1d43ad7bfa6f468cb936112ef76b83ec','snapshots',1,'2025-11-23 05:51:41',NULL),('2025-11-22 05:51:41.780176',NULL,'2025-11-22 05:51:41.854042',144,144,'3ca1144a55894a528a97f0906826d387','dc718f52-d7a3-44ed-9083-cad286b972e0',38,'1d43ad7bfa6f468cb936112ef76b83ec','snapshot_gigabytes',1,'2025-11-23 05:51:41',NULL),('2025-11-22 05:51:41.787902',NULL,'2025-11-22 05:51:41.854042',145,145,NULL,'b3f9cd31-66f0-4273-8eca-0a1284459f07',39,'1d43ad7bfa6f468cb936112ef76b83ec','snapshots',1,'2025-11-23 05:51:41','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:51:41.789207',NULL,'2025-11-22 05:51:41.854042',146,146,NULL,'15147b8e-0bed-4361-99c6-59be599dc88d',40,'1d43ad7bfa6f468cb936112ef76b83ec','snapshot_gigabytes',1,'2025-11-23 05:51:41','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:51:42.162987',NULL,'2025-11-22 05:51:42.192583',147,147,'19063b71466b4a099f4798ea400aed7c','c964c931-8553-46fa-85cc-3ae136e626fd',48,'fffa744c2146473ab31df119246a9181','shares',1,'2025-11-23 05:51:42',NULL),('2025-11-22 05:51:42.164418',NULL,'2025-11-22 05:51:42.192583',148,148,'19063b71466b4a099f4798ea400aed7c','ac060367-62c6-4ae9-9f1f-f31c0e4f8e2d',47,'fffa744c2146473ab31df119246a9181','gigabytes',1,'2025-11-23 05:51:42',NULL),('2025-11-22 05:51:42.173965',NULL,'2025-11-22 05:51:42.192583',149,149,NULL,'a67b22ee-35c7-4ffc-9e3a-617f5d19c23d',49,'fffa744c2146473ab31df119246a9181','shares',1,'2025-11-23 05:51:42','0c31157a-4a41-48b4-a5d8-48543e507fe9'),('2025-11-22 05:51:42.175201',NULL,'2025-11-22 05:51:42.192583',150,150,NULL,'f3db590f-18fc-4516-bf1d-cff191052735',50,'fffa744c2146473ab31df119246a9181','gigabytes',1,'2025-11-23 05:51:42','0c31157a-4a41-48b4-a5d8-48543e507fe9'),('2025-11-22 05:51:44.392882',NULL,'2025-11-22 05:51:44.465988',151,151,'825bdf0dbbba49b38e9e122e772e6b7b','27110e5a-8cd5-4639-afaf-316fc69a3e4d',52,'1218c5e5dd6949df8f550c000dc3c24e','shares',1,'2025-11-23 05:51:44',NULL),('2025-11-22 05:51:44.394049',NULL,'2025-11-22 05:51:44.465988',152,152,'825bdf0dbbba49b38e9e122e772e6b7b','7b138a16-243d-42c7-bc8d-e9669d99327f',51,'1218c5e5dd6949df8f550c000dc3c24e','gigabytes',1,'2025-11-23 05:51:44',NULL),('2025-11-22 05:51:44.411802',NULL,'2025-11-22 05:51:44.465988',153,153,NULL,'b42562fb-5075-4234-aa87-e217c725acd5',54,'1218c5e5dd6949df8f550c000dc3c24e','shares',1,'2025-11-23 05:51:44','83710f66-5331-429a-9190-c955e72a6981'),('2025-11-22 05:51:44.413317',NULL,'2025-11-22 05:51:44.465988',154,154,NULL,'eb14ba57-64bf-499d-8773-da3101d448ca',53,'1218c5e5dd6949df8f550c000dc3c24e','gigabytes',1,'2025-11-23 05:51:44','83710f66-5331-429a-9190-c955e72a6981'),('2025-11-22 05:51:45.600093',NULL,'2025-11-22 05:51:45.784681',155,155,'3ca1144a55894a528a97f0906826d387','b080b75d-21f3-488e-b88c-cf4c30fe34a0',37,'1d43ad7bfa6f468cb936112ef76b83ec','snapshots',1,'2025-11-23 05:51:45',NULL),('2025-11-22 05:51:45.601773',NULL,'2025-11-22 05:51:45.784681',156,156,'3ca1144a55894a528a97f0906826d387','456afab7-3ad1-432b-8494-fa75f518d015',38,'1d43ad7bfa6f468cb936112ef76b83ec','snapshot_gigabytes',1,'2025-11-23 05:51:45',NULL),('2025-11-22 05:51:45.667095',NULL,'2025-11-22 05:51:45.784681',157,157,NULL,'9e858462-e35d-4f72-bfe4-de3ffa07844c',39,'1d43ad7bfa6f468cb936112ef76b83ec','snapshots',1,'2025-11-23 05:51:45','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:51:45.669751',NULL,'2025-11-22 05:51:45.784681',158,158,NULL,'0520db5c-5c7a-40c1-ac03-d69b9413aab0',40,'1d43ad7bfa6f468cb936112ef76b83ec','snapshot_gigabytes',1,'2025-11-23 05:51:45','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:51:45.767131',NULL,'2025-11-22 05:51:46.139215',159,159,'19063b71466b4a099f4798ea400aed7c','53d4d410-d3e8-4426-af21-671baede1564',56,'fffa744c2146473ab31df119246a9181','snapshots',1,'2025-11-23 05:51:45',NULL),('2025-11-22 05:51:45.769457',NULL,'2025-11-22 05:51:46.139215',160,160,'19063b71466b4a099f4798ea400aed7c','f046910c-9a77-4885-b007-551aea22e6e6',55,'fffa744c2146473ab31df119246a9181','snapshot_gigabytes',1,'2025-11-23 05:51:45',NULL),('2025-11-22 05:51:45.906904',NULL,'2025-11-22 05:51:46.139215',161,161,NULL,'2a793300-3896-4651-864d-f5f55730edd5',58,'fffa744c2146473ab31df119246a9181','snapshots',1,'2025-11-23 05:51:45','0c31157a-4a41-48b4-a5d8-48543e507fe9'),('2025-11-22 05:51:45.908196',NULL,'2025-11-22 05:51:46.139215',162,162,NULL,'1b83da83-fea3-4894-abda-fde8c06b51b6',57,'fffa744c2146473ab31df119246a9181','snapshot_gigabytes',1,'2025-11-23 05:51:45','0c31157a-4a41-48b4-a5d8-48543e507fe9'),('2025-11-22 05:51:50.645559',NULL,'2025-11-22 05:51:50.766469',163,163,'3ca1144a55894a528a97f0906826d387','e4d2b064-8ed4-49d3-a43c-0c6643ef81bb',37,'1d43ad7bfa6f468cb936112ef76b83ec','snapshots',1,'2025-11-23 05:51:50',NULL),('2025-11-22 05:51:50.646967',NULL,'2025-11-22 05:51:50.766469',164,164,'3ca1144a55894a528a97f0906826d387','eadd48c0-f057-4429-9552-21a2ad8df087',38,'1d43ad7bfa6f468cb936112ef76b83ec','snapshot_gigabytes',1,'2025-11-23 05:51:50',NULL),('2025-11-22 05:51:50.655611',NULL,'2025-11-22 05:51:50.766469',165,165,NULL,'6ab16290-6a6e-4bd8-ac03-e92178d3c4be',39,'1d43ad7bfa6f468cb936112ef76b83ec','snapshots',1,'2025-11-23 05:51:50','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:51:50.656884',NULL,'2025-11-22 05:51:50.766469',166,166,NULL,'041c2bae-fca3-4af6-9005-46c70be904a1',40,'1d43ad7bfa6f468cb936112ef76b83ec','snapshot_gigabytes',1,'2025-11-23 05:51:50','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:51:54.958944',NULL,'2025-11-22 05:51:56.204065',167,167,'3ca1144a55894a528a97f0906826d387','3c5e297f-f0bf-42e9-8acd-6f5e54e9ff9d',37,'1d43ad7bfa6f468cb936112ef76b83ec','snapshots',1,'2025-11-23 05:51:54',NULL),('2025-11-22 05:51:54.960374',NULL,'2025-11-22 05:51:56.204065',168,168,'3ca1144a55894a528a97f0906826d387','353f1a55-5434-4759-9212-6fc7fdc0aaa1',38,'1d43ad7bfa6f468cb936112ef76b83ec','snapshot_gigabytes',1,'2025-11-23 05:51:54',NULL),('2025-11-22 05:51:55.850319',NULL,'2025-11-22 05:51:56.204065',169,169,NULL,'80bded8d-9357-4126-908a-8ebd099a97ff',39,'1d43ad7bfa6f468cb936112ef76b83ec','snapshots',1,'2025-11-23 05:51:54','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:51:55.852153',NULL,'2025-11-22 05:51:56.204065',170,170,NULL,'22dcbf50-5ec1-439d-a422-96e49be87ee0',40,'1d43ad7bfa6f468cb936112ef76b83ec','snapshot_gigabytes',1,'2025-11-23 05:51:54','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:52:00.332777',NULL,'2025-11-22 05:52:00.637787',171,171,'3ca1144a55894a528a97f0906826d387','15a037c4-6942-4d06-8357-b666258b1993',37,'1d43ad7bfa6f468cb936112ef76b83ec','snapshots',1,'2025-11-23 05:52:00',NULL),('2025-11-22 05:52:00.334824',NULL,'2025-11-22 05:52:00.637787',172,172,'3ca1144a55894a528a97f0906826d387','4b20ae92-464b-453b-aa27-9b457762e059',38,'1d43ad7bfa6f468cb936112ef76b83ec','snapshot_gigabytes',1,'2025-11-23 05:52:00',NULL),('2025-11-22 05:52:00.348605',NULL,'2025-11-22 05:52:00.637787',173,173,NULL,'e3a99e77-22da-4aab-9791-c1dd6e94e2d3',39,'1d43ad7bfa6f468cb936112ef76b83ec','snapshots',1,'2025-11-23 05:52:00','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:52:00.356340',NULL,'2025-11-22 05:52:00.637787',174,174,NULL,'307127d2-df27-4fc2-821f-60797871339e',40,'1d43ad7bfa6f468cb936112ef76b83ec','snapshot_gigabytes',1,'2025-11-23 05:52:00','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:52:00.586161',NULL,'2025-11-22 05:52:00.642865',175,175,'ca8cffb070a549e3b3a19f34d69fb809','acf116d8-6cdb-47bf-b6ba-d18b99094ec4',60,'161410e8e68843c498c108a7c907faa9','shares',1,'2025-11-23 05:52:00',NULL),('2025-11-22 05:52:00.587289',NULL,'2025-11-22 05:52:00.642865',176,176,'ca8cffb070a549e3b3a19f34d69fb809','05a1e293-37c7-4cdc-8803-4b2a36e2b828',59,'161410e8e68843c498c108a7c907faa9','gigabytes',1,'2025-11-23 05:52:00',NULL),('2025-11-22 05:52:00.598242',NULL,'2025-11-22 05:52:00.642865',177,177,NULL,'6fc8239e-d38f-4bd7-a01a-88d759524812',62,'161410e8e68843c498c108a7c907faa9','shares',1,'2025-11-23 05:52:00','72fda760-d07e-4ff4-b88e-2511b31404ed'),('2025-11-22 05:52:00.599690',NULL,'2025-11-22 05:52:00.642865',178,178,NULL,'84101c81-0445-4a2c-a905-2355484ecaee',61,'161410e8e68843c498c108a7c907faa9','gigabytes',1,'2025-11-23 05:52:00','72fda760-d07e-4ff4-b88e-2511b31404ed'),('2025-11-22 05:52:01.465924',NULL,'2025-11-22 05:52:01.491363',179,179,'19063b71466b4a099f4798ea400aed7c','fdc0cdb8-9b09-4e3f-b3e6-bbb52bd0db60',63,'fffa744c2146473ab31df119246a9181','snapshots',-1,'2025-11-23 05:52:01',NULL),('2025-11-22 05:52:01.466527',NULL,'2025-11-22 05:52:01.491363',180,180,'19063b71466b4a099f4798ea400aed7c','08a5609f-ccb6-4232-a737-68dc03c1c732',64,'fffa744c2146473ab31df119246a9181','snapshot_gigabytes',-1,'2025-11-23 05:52:01',NULL),('2025-11-22 05:52:01.481011',NULL,'2025-11-22 05:52:01.491363',181,181,NULL,'837d6df7-8a63-40fe-b5bc-cb97bd4efdf1',65,'fffa744c2146473ab31df119246a9181','snapshots',-1,'2025-11-23 05:52:01','0c31157a-4a41-48b4-a5d8-48543e507fe9'),('2025-11-22 05:52:01.481783',NULL,'2025-11-22 05:52:01.491363',182,182,NULL,'d93d39d2-d418-4981-b8c8-4fe511f96a7c',66,'fffa744c2146473ab31df119246a9181','snapshot_gigabytes',-1,'2025-11-23 05:52:01','0c31157a-4a41-48b4-a5d8-48543e507fe9'),('2025-11-22 05:52:04.094993',NULL,'2025-11-22 05:52:04.243842',183,183,'ca8cffb070a549e3b3a19f34d69fb809','061eb756-6227-4940-b771-f89a37ff9ffd',68,'161410e8e68843c498c108a7c907faa9','snapshots',1,'2025-11-23 05:52:04',NULL),('2025-11-22 05:52:04.096766',NULL,'2025-11-22 05:52:04.243842',184,184,'ca8cffb070a549e3b3a19f34d69fb809','64899ef9-6461-4e9f-ba98-f46700955df8',67,'161410e8e68843c498c108a7c907faa9','snapshot_gigabytes',1,'2025-11-23 05:52:04',NULL),('2025-11-22 05:52:04.152292',NULL,'2025-11-22 05:52:04.243842',185,185,NULL,'4c5274c6-71bc-444e-9de2-88ef2a0f31c0',70,'161410e8e68843c498c108a7c907faa9','snapshots',1,'2025-11-23 05:52:04','72fda760-d07e-4ff4-b88e-2511b31404ed'),('2025-11-22 05:52:04.159215',NULL,'2025-11-22 05:52:04.243842',186,186,NULL,'d8f0decd-c85b-4a98-a22f-85416605bfb6',69,'161410e8e68843c498c108a7c907faa9','snapshot_gigabytes',1,'2025-11-23 05:52:04','72fda760-d07e-4ff4-b88e-2511b31404ed'),('2025-11-22 05:52:05.440622',NULL,'2025-11-22 05:52:05.485026',187,187,'3ca1144a55894a528a97f0906826d387','915a5e5b-a6d9-404d-a231-5823882e99f6',37,'1d43ad7bfa6f468cb936112ef76b83ec','snapshots',-1,'2025-11-23 05:52:05',NULL),('2025-11-22 05:52:05.441479',NULL,'2025-11-22 05:52:05.485026',188,188,'3ca1144a55894a528a97f0906826d387','9bd5a28c-4fc5-4e12-aa0c-0f8cc22ed736',38,'1d43ad7bfa6f468cb936112ef76b83ec','snapshot_gigabytes',-1,'2025-11-23 05:52:05',NULL),('2025-11-22 05:52:05.459944',NULL,'2025-11-22 05:52:05.493210',189,189,'19063b71466b4a099f4798ea400aed7c','380437a1-6ec7-444b-9878-d27db1ebfd83',72,'fffa744c2146473ab31df119246a9181','shares',-1,'2025-11-23 05:52:05',NULL),('2025-11-22 05:52:05.460601',NULL,'2025-11-22 05:52:05.493210',190,190,'19063b71466b4a099f4798ea400aed7c','4d6b5587-bd5d-4443-ab69-2818c992a615',71,'fffa744c2146473ab31df119246a9181','gigabytes',-1,'2025-11-23 05:52:05',NULL),('2025-11-22 05:52:05.465221',NULL,'2025-11-22 05:52:05.485026',191,191,NULL,'691fa48e-db60-40a6-8f83-bfb9ed03278f',39,'1d43ad7bfa6f468cb936112ef76b83ec','snapshots',-1,'2025-11-23 05:52:05','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:52:05.466746',NULL,'2025-11-22 05:52:05.485026',192,192,NULL,'41fe1a91-1d82-45e1-95ba-168e9f391e80',40,'1d43ad7bfa6f468cb936112ef76b83ec','snapshot_gigabytes',-1,'2025-11-23 05:52:05','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:52:05.479465',NULL,'2025-11-22 05:52:05.493210',193,193,NULL,'69dd80ce-d152-4d3a-84c2-0591a95a816e',74,'fffa744c2146473ab31df119246a9181','shares',-1,'2025-11-23 05:52:05','0c31157a-4a41-48b4-a5d8-48543e507fe9'),('2025-11-22 05:52:05.480111',NULL,'2025-11-22 05:52:05.493210',194,194,NULL,'086f3df2-0154-4375-86b3-bac206a26fcf',73,'fffa744c2146473ab31df119246a9181','gigabytes',-1,'2025-11-23 05:52:05','0c31157a-4a41-48b4-a5d8-48543e507fe9'),('2025-11-22 05:52:08.305184',NULL,'2025-11-22 05:52:08.386391',195,195,'ca8cffb070a549e3b3a19f34d69fb809','dc0a0470-4a9d-4a66-9129-b47a25d4b47c',68,'161410e8e68843c498c108a7c907faa9','snapshots',1,'2025-11-23 05:52:08',NULL),('2025-11-22 05:52:08.306497',NULL,'2025-11-22 05:52:08.386391',196,196,'ca8cffb070a549e3b3a19f34d69fb809','361bc32a-2230-4941-bbb8-f20b8f04e377',67,'161410e8e68843c498c108a7c907faa9','snapshot_gigabytes',1,'2025-11-23 05:52:08',NULL),('2025-11-22 05:52:08.312921',NULL,'2025-11-22 05:52:08.386391',197,197,NULL,'97766df5-8622-4cdf-b3d3-1c1637fe9322',70,'161410e8e68843c498c108a7c907faa9','snapshots',1,'2025-11-23 05:52:08','72fda760-d07e-4ff4-b88e-2511b31404ed'),('2025-11-22 05:52:08.313951',NULL,'2025-11-22 05:52:08.386391',198,198,NULL,'bb71975f-2775-4baf-8dcd-88a98fbd94da',69,'161410e8e68843c498c108a7c907faa9','snapshot_gigabytes',1,'2025-11-23 05:52:08','72fda760-d07e-4ff4-b88e-2511b31404ed'),('2025-11-22 05:52:08.523289',NULL,'2025-11-22 05:52:08.626758',199,199,'3ca1144a55894a528a97f0906826d387','48f34859-1413-44dd-8166-0143e2c88190',37,'1d43ad7bfa6f468cb936112ef76b83ec','snapshots',-1,'2025-11-23 05:52:08',NULL),('2025-11-22 05:52:08.524796',NULL,'2025-11-22 05:52:08.626758',200,200,'3ca1144a55894a528a97f0906826d387','00062ec8-4b0f-49a7-a273-c5f6c4e98456',38,'1d43ad7bfa6f468cb936112ef76b83ec','snapshot_gigabytes',-1,'2025-11-23 05:52:08',NULL),('2025-11-22 05:52:08.563732',NULL,'2025-11-22 05:52:08.626758',201,201,NULL,'37cda723-a839-4eda-b3e7-ca11fb7122eb',39,'1d43ad7bfa6f468cb936112ef76b83ec','snapshots',-1,'2025-11-23 05:52:08','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:52:08.567242',NULL,'2025-11-22 05:52:08.626758',202,202,NULL,'4621ee46-e650-4acf-bed2-3e8e95e29b5c',40,'1d43ad7bfa6f468cb936112ef76b83ec','snapshot_gigabytes',-1,'2025-11-23 05:52:08','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:52:08.782406',NULL,'2025-11-22 05:52:08.856229',203,203,'19063b71466b4a099f4798ea400aed7c','d5cda252-21c4-410f-bd77-3d367e5b1c06',72,'fffa744c2146473ab31df119246a9181','shares',-1,'2025-11-23 05:52:08',NULL),('2025-11-22 05:52:08.785822',NULL,'2025-11-22 05:52:08.856229',204,204,'19063b71466b4a099f4798ea400aed7c','b9673b99-0de8-44b1-9cbe-ffd1b3d2f163',71,'fffa744c2146473ab31df119246a9181','gigabytes',-1,'2025-11-23 05:52:08',NULL),('2025-11-22 05:52:08.827289',NULL,'2025-11-22 05:52:08.856229',205,205,NULL,'ef0ee623-0bd5-48c9-a970-b93a86d74d89',76,'fffa744c2146473ab31df119246a9181','shares',-1,'2025-11-23 05:52:08','76b8f610-7bd5-4886-9698-850dd629ddbd'),('2025-11-22 05:52:08.829098',NULL,'2025-11-22 05:52:08.856229',206,206,NULL,'83fc90b4-7f4c-402f-8797-278d8422e36f',75,'fffa744c2146473ab31df119246a9181','gigabytes',-1,'2025-11-23 05:52:08','76b8f610-7bd5-4886-9698-850dd629ddbd'),('2025-11-22 05:52:09.428622',NULL,'2025-11-22 05:52:09.449670',207,207,'825bdf0dbbba49b38e9e122e772e6b7b','5eb25ba8-260d-4921-a3a9-16691dabdcc8',52,'1218c5e5dd6949df8f550c000dc3c24e','shares',-1,'2025-11-23 05:52:09',NULL),('2025-11-22 05:52:09.429580',NULL,'2025-11-22 05:52:09.449670',208,208,'825bdf0dbbba49b38e9e122e772e6b7b','8b6077f7-2603-417e-a111-75fa7e87b294',51,'1218c5e5dd6949df8f550c000dc3c24e','gigabytes',-1,'2025-11-23 05:52:09',NULL),('2025-11-22 05:52:09.438070',NULL,'2025-11-22 05:52:09.449670',209,209,NULL,'03d6574c-d615-453d-a0f8-619581eae417',54,'1218c5e5dd6949df8f550c000dc3c24e','shares',-1,'2025-11-23 05:52:09','83710f66-5331-429a-9190-c955e72a6981'),('2025-11-22 05:52:09.439243',NULL,'2025-11-22 05:52:09.449670',210,210,NULL,'d64e54ea-8afe-4427-95d2-e1db5399662a',53,'1218c5e5dd6949df8f550c000dc3c24e','gigabytes',-1,'2025-11-23 05:52:09','83710f66-5331-429a-9190-c955e72a6981'),('2025-11-22 05:52:12.094227',NULL,'2025-11-22 05:52:12.115134',211,211,'3ca1144a55894a528a97f0906826d387','605b4423-4add-4f42-9886-5a759c460f51',37,'1d43ad7bfa6f468cb936112ef76b83ec','snapshots',-1,'2025-11-23 05:52:12',NULL),('2025-11-22 05:52:12.095141',NULL,'2025-11-22 05:52:12.115134',212,212,'3ca1144a55894a528a97f0906826d387','30fdc1f3-6dd0-4f29-8cc1-4430cf9e79f2',38,'1d43ad7bfa6f468cb936112ef76b83ec','snapshot_gigabytes',-1,'2025-11-23 05:52:12',NULL),('2025-11-22 05:52:12.103646',NULL,'2025-11-22 05:52:12.115134',213,213,NULL,'83877044-144a-4195-9bf8-a8875a6335c7',39,'1d43ad7bfa6f468cb936112ef76b83ec','snapshots',-1,'2025-11-23 05:52:12','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:52:12.104679',NULL,'2025-11-22 05:52:12.115134',214,214,NULL,'b4b654e3-e3bc-48cd-bff2-aa74d11b07c5',40,'1d43ad7bfa6f468cb936112ef76b83ec','snapshot_gigabytes',-1,'2025-11-23 05:52:12','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:52:13.947722',NULL,'2025-11-22 05:52:14.135227',215,215,'ca8cffb070a549e3b3a19f34d69fb809','7738cf70-32d6-453f-9be7-b3b5546ed53d',68,'161410e8e68843c498c108a7c907faa9','snapshots',-1,'2025-11-23 05:52:13',NULL),('2025-11-22 05:52:13.949161',NULL,'2025-11-22 05:52:14.135227',216,216,'ca8cffb070a549e3b3a19f34d69fb809','7cba00e1-8c1e-4209-ad12-a7e9a748ab6f',67,'161410e8e68843c498c108a7c907faa9','snapshot_gigabytes',-1,'2025-11-23 05:52:13',NULL),('2025-11-22 05:52:14.023977',NULL,'2025-11-22 05:52:14.135227',217,217,NULL,'032585a0-f031-4db3-a65e-11c6105881bc',70,'161410e8e68843c498c108a7c907faa9','snapshots',-1,'2025-11-23 05:52:13','72fda760-d07e-4ff4-b88e-2511b31404ed'),('2025-11-22 05:52:14.024788',NULL,'2025-11-22 05:52:14.135227',218,218,NULL,'518cee49-8c39-4a1a-adea-4ab9a20a2909',69,'161410e8e68843c498c108a7c907faa9','snapshot_gigabytes',-1,'2025-11-23 05:52:13','72fda760-d07e-4ff4-b88e-2511b31404ed'),('2025-11-22 05:52:16.011552',NULL,'2025-11-22 05:52:16.138276',219,219,'3ca1144a55894a528a97f0906826d387','46c6fabc-45d2-460a-aae8-33ee00c0fddb',37,'1d43ad7bfa6f468cb936112ef76b83ec','snapshots',-1,'2025-11-23 05:52:15',NULL),('2025-11-22 05:52:16.012530',NULL,'2025-11-22 05:52:16.138276',220,220,'3ca1144a55894a528a97f0906826d387','e78f9b7a-acb8-4059-a176-8c885eda460b',38,'1d43ad7bfa6f468cb936112ef76b83ec','snapshot_gigabytes',-1,'2025-11-23 05:52:15',NULL),('2025-11-22 05:52:16.065406',NULL,'2025-11-22 05:52:16.138276',221,221,NULL,'13cb1d36-ab20-429c-bdef-11d47c08962b',39,'1d43ad7bfa6f468cb936112ef76b83ec','snapshots',-1,'2025-11-23 05:52:15','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:52:16.066280',NULL,'2025-11-22 05:52:16.138276',222,222,NULL,'b76be8ad-3c2b-487f-b5be-c03465b5b512',40,'1d43ad7bfa6f468cb936112ef76b83ec','snapshot_gigabytes',-1,'2025-11-23 05:52:15','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:52:17.072924',NULL,'2025-11-22 05:52:17.228659',223,223,'ca8cffb070a549e3b3a19f34d69fb809','a58cfac4-60cb-4ba2-a0f5-840c201435ba',68,'161410e8e68843c498c108a7c907faa9','snapshots',-1,'2025-11-23 05:52:17',NULL),('2025-11-22 05:52:17.073954',NULL,'2025-11-22 05:52:17.228659',224,224,'ca8cffb070a549e3b3a19f34d69fb809','fe1566c8-e198-489c-8692-1c2b14703be2',67,'161410e8e68843c498c108a7c907faa9','snapshot_gigabytes',-1,'2025-11-23 05:52:17',NULL),('2025-11-22 05:52:17.150478',NULL,'2025-11-22 05:52:17.228659',225,225,NULL,'83320a30-9de8-4116-93f4-3c14a7b11cba',70,'161410e8e68843c498c108a7c907faa9','snapshots',-1,'2025-11-23 05:52:17','72fda760-d07e-4ff4-b88e-2511b31404ed'),('2025-11-22 05:52:17.151570',NULL,'2025-11-22 05:52:17.228659',226,226,NULL,'c0c0601f-1934-4703-a118-6fafabed4cf6',69,'161410e8e68843c498c108a7c907faa9','snapshot_gigabytes',-1,'2025-11-23 05:52:17','72fda760-d07e-4ff4-b88e-2511b31404ed'),('2025-11-22 05:52:19.102448',NULL,'2025-11-22 05:52:19.121169',227,227,'3ca1144a55894a528a97f0906826d387','e98e2afe-532a-4821-b504-dba96be3393e',37,'1d43ad7bfa6f468cb936112ef76b83ec','snapshots',-1,'2025-11-23 05:52:19',NULL),('2025-11-22 05:52:19.103484',NULL,'2025-11-22 05:52:19.121169',228,228,'3ca1144a55894a528a97f0906826d387','910dfffc-6ebd-4a00-bff3-5233c7e79adc',38,'1d43ad7bfa6f468cb936112ef76b83ec','snapshot_gigabytes',-1,'2025-11-23 05:52:19',NULL),('2025-11-22 05:52:19.109831',NULL,'2025-11-22 05:52:19.121169',229,229,NULL,'0e312e77-54e8-4b3f-b045-12439be3a9df',39,'1d43ad7bfa6f468cb936112ef76b83ec','snapshots',-1,'2025-11-23 05:52:19','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:52:19.110668',NULL,'2025-11-22 05:52:19.121169',230,230,NULL,'9ada89eb-5c29-468e-874f-29f0dfaad127',40,'1d43ad7bfa6f468cb936112ef76b83ec','snapshot_gigabytes',-1,'2025-11-23 05:52:19','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:52:20.296894',NULL,'2025-11-22 05:52:20.311701',231,231,'ca8cffb070a549e3b3a19f34d69fb809','05ea9549-7fa4-43e2-907c-ce28a27a1cf5',60,'161410e8e68843c498c108a7c907faa9','shares',-1,'2025-11-23 05:52:20',NULL),('2025-11-22 05:52:20.297851',NULL,'2025-11-22 05:52:20.311701',232,232,'ca8cffb070a549e3b3a19f34d69fb809','9d7e214c-5910-4c10-99b4-b7f935383879',59,'161410e8e68843c498c108a7c907faa9','gigabytes',-1,'2025-11-23 05:52:20',NULL),('2025-11-22 05:52:20.304084',NULL,'2025-11-22 05:52:20.311701',233,233,NULL,'62c5f0aa-2a42-4062-af8a-6ba6915a5506',62,'161410e8e68843c498c108a7c907faa9','shares',-1,'2025-11-23 05:52:20','72fda760-d07e-4ff4-b88e-2511b31404ed'),('2025-11-22 05:52:20.304734',NULL,'2025-11-22 05:52:20.311701',234,234,NULL,'2cfc85b5-7ca7-44eb-a16a-9cc6678f4daa',61,'161410e8e68843c498c108a7c907faa9','gigabytes',-1,'2025-11-23 05:52:20','72fda760-d07e-4ff4-b88e-2511b31404ed'),('2025-11-22 05:52:23.108610',NULL,'2025-11-22 05:52:23.193483',235,235,'3ca1144a55894a528a97f0906826d387','051911e8-c963-433b-8c5f-82514398a41f',2,'1d43ad7bfa6f468cb936112ef76b83ec','shares',-1,'2025-11-23 05:52:23',NULL),('2025-11-22 05:52:23.109475',NULL,'2025-11-22 05:52:23.193483',236,236,'3ca1144a55894a528a97f0906826d387','5e238a3c-e80d-4ae1-9085-5aefa828a6d4',1,'1d43ad7bfa6f468cb936112ef76b83ec','gigabytes',-1,'2025-11-23 05:52:23',NULL),('2025-11-22 05:52:23.137357',NULL,'2025-11-22 05:52:23.193483',237,237,NULL,'81aea850-33ee-4f86-8ae0-ad3abb6f268f',4,'1d43ad7bfa6f468cb936112ef76b83ec','shares',-1,'2025-11-23 05:52:23','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:52:23.138198',NULL,'2025-11-22 05:52:23.193483',238,238,NULL,'24e4b915-ecb2-4c27-90fc-139e13b56a3b',3,'1d43ad7bfa6f468cb936112ef76b83ec','gigabytes',-1,'2025-11-23 05:52:23','ae29560b-3995-49db-8651-d9dca4b5c54c'),('2025-11-22 05:52:24.373776',NULL,'2025-11-22 05:52:24.413827',239,239,'da8b56e53e0b4b21a8b9a579475a6d04','1fb0bf01-d110-480a-97fc-94f603c9ddda',78,'37b6389e0b8c44d58693f909304c85f3','shares',1,'2025-11-23 05:52:24',NULL),('2025-11-22 05:52:24.374798',NULL,'2025-11-22 05:52:24.413827',240,240,'da8b56e53e0b4b21a8b9a579475a6d04','7b90cbb3-d949-4c50-bb90-b9efae3cf54f',77,'37b6389e0b8c44d58693f909304c85f3','gigabytes',1,'2025-11-23 05:52:24',NULL),('2025-11-22 05:52:24.388105',NULL,'2025-11-22 05:52:24.413827',241,241,NULL,'00d8a39b-01dd-4f54-a5da-e794422adef0',80,'37b6389e0b8c44d58693f909304c85f3','shares',1,'2025-11-23 05:52:24','a2eae7d4-7042-401a-973a-249989b912a4'),('2025-11-22 05:52:24.389168',NULL,'2025-11-22 05:52:24.413827',242,242,NULL,'09b21197-5714-465f-a119-8e9567508031',79,'37b6389e0b8c44d58693f909304c85f3','gigabytes',1,'2025-11-23 05:52:24','a2eae7d4-7042-401a-973a-249989b912a4'),('2025-11-22 05:52:29.930436',NULL,'2025-11-22 05:52:29.949663',243,243,'da8b56e53e0b4b21a8b9a579475a6d04','2c28633b-bf26-46cd-9fc6-d0c5293f2584',78,'37b6389e0b8c44d58693f909304c85f3','shares',-1,'2025-11-23 05:52:29',NULL),('2025-11-22 05:52:29.931974',NULL,'2025-11-22 05:52:29.949663',244,244,'da8b56e53e0b4b21a8b9a579475a6d04','c1cfe576-7005-4528-9267-806aaf2da85b',77,'37b6389e0b8c44d58693f909304c85f3','gigabytes',-1,'2025-11-23 05:52:29',NULL),('2025-11-22 05:52:29.938703',NULL,'2025-11-22 05:52:29.949663',245,245,NULL,'0506efe8-4216-4f4a-b3da-a28ada22e639',80,'37b6389e0b8c44d58693f909304c85f3','shares',-1,'2025-11-23 05:52:29','a2eae7d4-7042-401a-973a-249989b912a4'),('2025-11-22 05:52:29.939593',NULL,'2025-11-22 05:52:29.949663',246,246,NULL,'258eee7e-615b-4c2f-bc33-8129a9cb3438',79,'37b6389e0b8c44d58693f909304c85f3','gigabytes',-1,'2025-11-23 05:52:29','a2eae7d4-7042-401a-973a-249989b912a4'),('2025-11-22 05:52:35.701284',NULL,'2025-11-22 05:52:35.754503',247,247,'625f00565232408d9cf383ec8a96edab','eadf3c8e-13c8-46d2-9eed-6e7ddf78e9f8',82,'a4d13c902935400e9d74b443a3eb1e97','shares',1,'2025-11-23 05:52:35',NULL),('2025-11-22 05:52:35.703000',NULL,'2025-11-22 05:52:35.754503',248,248,'625f00565232408d9cf383ec8a96edab','5cfdedc8-eef9-4727-b393-05307b07521f',81,'a4d13c902935400e9d74b443a3eb1e97','gigabytes',1,'2025-11-23 05:52:35',NULL),('2025-11-22 05:52:35.721716',NULL,'2025-11-22 05:52:35.754503',249,249,NULL,'12bcd782-231b-48ba-aaef-5c7bd0338e4a',84,'a4d13c902935400e9d74b443a3eb1e97','shares',1,'2025-11-23 05:52:35','d4fe4178-7457-4c27-b05c-d200652bfa09'),('2025-11-22 05:52:35.723321',NULL,'2025-11-22 05:52:35.754503',250,250,NULL,'b484a3c9-32fe-46b3-8d71-2a4d4665b31c',83,'a4d13c902935400e9d74b443a3eb1e97','gigabytes',1,'2025-11-23 05:52:35','d4fe4178-7457-4c27-b05c-d200652bfa09'),('2025-11-22 05:52:41.840764',NULL,'2025-11-22 05:52:41.863877',251,251,'625f00565232408d9cf383ec8a96edab','fff92c81-d630-4521-ae63-290fe3f2e2d5',82,'a4d13c902935400e9d74b443a3eb1e97','shares',-1,'2025-11-23 05:52:41',NULL),('2025-11-22 05:52:41.841862',NULL,'2025-11-22 05:52:41.863877',252,252,'625f00565232408d9cf383ec8a96edab','27f63a72-0f76-47c6-89c0-7007160e85c0',81,'a4d13c902935400e9d74b443a3eb1e97','gigabytes',-1,'2025-11-23 05:52:41',NULL),('2025-11-22 05:52:41.851486',NULL,'2025-11-22 05:52:41.863877',253,253,NULL,'8f090042-3c9f-4986-923d-96b2586ec9e1',84,'a4d13c902935400e9d74b443a3eb1e97','shares',-1,'2025-11-23 05:52:41','d4fe4178-7457-4c27-b05c-d200652bfa09'),('2025-11-22 05:52:41.852716',NULL,'2025-11-22 05:52:41.863877',254,254,NULL,'15c9ff91-5e7f-4a96-bcb5-24e023f887c6',83,'a4d13c902935400e9d74b443a3eb1e97','gigabytes',-1,'2025-11-23 05:52:41','d4fe4178-7457-4c27-b05c-d200652bfa09'),('2025-11-22 05:52:45.770583',NULL,'2025-11-22 05:52:45.817060',255,255,'9088ff75a27c420ca8f0a42460400887','cd8fc300-9ad1-4540-9374-34639ef16358',86,'94bcd246264e4a03b75056b04f28dee8','shares',1,'2025-11-23 05:52:45',NULL),('2025-11-22 05:52:45.771634',NULL,'2025-11-22 05:52:45.817060',256,256,'9088ff75a27c420ca8f0a42460400887','e2d51087-a6eb-43dd-b073-3360bfcb6a60',85,'94bcd246264e4a03b75056b04f28dee8','gigabytes',1,'2025-11-23 05:52:45',NULL),('2025-11-22 05:52:45.785513',NULL,'2025-11-22 05:52:45.817060',257,257,NULL,'981ece87-4106-460f-af94-9baadd96b59d',88,'94bcd246264e4a03b75056b04f28dee8','shares',1,'2025-11-23 05:52:45','3f5f10b5-5a29-4a2e-a4a9-9c80d7a9b422'),('2025-11-22 05:52:45.786568',NULL,'2025-11-22 05:52:45.817060',258,258,NULL,'ddbacd30-118d-46b5-90bd-7c2fd7cca857',87,'94bcd246264e4a03b75056b04f28dee8','gigabytes',1,'2025-11-23 05:52:45','3f5f10b5-5a29-4a2e-a4a9-9c80d7a9b422'),('2025-11-22 05:52:46.667830',NULL,'2025-11-22 05:52:46.697317',259,259,'7b35a5763e3a490b90ea39b5f4299609','badee873-089c-4477-ae7e-2f6d9c79d2ea',90,'0e8baa99d2a34ced8e95c9d3736c9dcd','shares',1,'2025-11-23 05:52:46',NULL),('2025-11-22 05:52:46.669226',NULL,'2025-11-22 05:52:46.697317',260,260,'7b35a5763e3a490b90ea39b5f4299609','383cc149-e1b4-48cb-930b-b4178e97f637',89,'0e8baa99d2a34ced8e95c9d3736c9dcd','gigabytes',1,'2025-11-23 05:52:46',NULL),('2025-11-22 05:52:46.677588',NULL,'2025-11-22 05:52:46.697317',261,261,NULL,'2a7da879-3c8b-4cb9-a200-072f734ea6a4',92,'0e8baa99d2a34ced8e95c9d3736c9dcd','shares',1,'2025-11-23 05:52:46','f5058f8f-6143-4b6d-8d20-02b50ffa22a6'),('2025-11-22 05:52:46.680096',NULL,'2025-11-22 05:52:46.697317',262,262,NULL,'f9039685-2f13-4153-815e-7266ad900fd9',91,'0e8baa99d2a34ced8e95c9d3736c9dcd','gigabytes',1,'2025-11-23 05:52:46','f5058f8f-6143-4b6d-8d20-02b50ffa22a6'),('2025-11-22 05:52:49.187159',NULL,'2025-11-22 05:52:49.231179',263,263,'4de5adb2861b4b3fbe992445b625cad4','b9c55352-0dde-4e20-a220-5bf7126a12dd',94,'c3e25870be384f238bccdf6c103762a8','shares',1,'2025-11-23 05:52:49',NULL),('2025-11-22 05:52:49.189903',NULL,'2025-11-22 05:52:49.231179',264,264,'4de5adb2861b4b3fbe992445b625cad4','5abb6947-d4b5-4fda-a6ef-d3a33b3289b9',93,'c3e25870be384f238bccdf6c103762a8','gigabytes',1,'2025-11-23 05:52:49',NULL),('2025-11-22 05:52:49.205560',NULL,'2025-11-22 05:52:49.231179',265,265,NULL,'98a512e4-5bd2-4a6b-a44d-0c3b04da1c75',96,'c3e25870be384f238bccdf6c103762a8','shares',1,'2025-11-23 05:52:49','55c95d49-aa56-4fad-870f-b645f28cd680'),('2025-11-22 05:52:49.207314',NULL,'2025-11-22 05:52:49.231179',266,266,NULL,'9a38c2ad-18c1-414c-ae28-b5589eee4506',95,'c3e25870be384f238bccdf6c103762a8','gigabytes',1,'2025-11-23 05:52:49','55c95d49-aa56-4fad-870f-b645f28cd680'),('2025-11-22 05:52:52.739201',NULL,'2025-11-22 05:52:52.754767',267,267,'7b35a5763e3a490b90ea39b5f4299609','67b4121d-1100-467b-8c5a-2eceeb9daecd',90,'0e8baa99d2a34ced8e95c9d3736c9dcd','shares',-1,'2025-11-23 05:52:52',NULL),('2025-11-22 05:52:52.739881',NULL,'2025-11-22 05:52:52.754767',268,268,'7b35a5763e3a490b90ea39b5f4299609','102e746d-9371-473c-a5f0-a5f1e4a5bd4c',89,'0e8baa99d2a34ced8e95c9d3736c9dcd','gigabytes',-1,'2025-11-23 05:52:52',NULL),('2025-11-22 05:52:52.746343',NULL,'2025-11-22 05:52:52.754767',269,269,NULL,'2d26ba85-14f2-4765-a1e3-5a2f96cf68b6',92,'0e8baa99d2a34ced8e95c9d3736c9dcd','shares',-1,'2025-11-23 05:52:52','f5058f8f-6143-4b6d-8d20-02b50ffa22a6'),('2025-11-22 05:52:52.747285',NULL,'2025-11-22 05:52:52.754767',270,270,NULL,'0515b7fc-87f6-4030-a392-e3c0ef48c04e',91,'0e8baa99d2a34ced8e95c9d3736c9dcd','gigabytes',-1,'2025-11-23 05:52:52','f5058f8f-6143-4b6d-8d20-02b50ffa22a6'),('2025-11-22 05:53:06.430969',NULL,'2025-11-22 05:53:06.450906',271,271,'4de5adb2861b4b3fbe992445b625cad4','c2be163e-37be-4f27-babd-cc499709d590',94,'c3e25870be384f238bccdf6c103762a8','shares',-1,'2025-11-23 05:53:06',NULL),('2025-11-22 05:53:06.431890',NULL,'2025-11-22 05:53:06.450906',272,272,'4de5adb2861b4b3fbe992445b625cad4','085fc33e-4b70-4a28-8db0-dab841014de9',93,'c3e25870be384f238bccdf6c103762a8','gigabytes',-1,'2025-11-23 05:53:06',NULL),('2025-11-22 05:53:06.437867',NULL,'2025-11-22 05:53:06.450906',273,273,NULL,'479a6724-1234-439b-a7a4-43f1b8189a3e',96,'c3e25870be384f238bccdf6c103762a8','shares',-1,'2025-11-23 05:53:06','55c95d49-aa56-4fad-870f-b645f28cd680'),('2025-11-22 05:53:06.438819',NULL,'2025-11-22 05:53:06.450906',274,274,NULL,'fbbb959e-8718-4b76-9c06-aa22e5c139fb',95,'c3e25870be384f238bccdf6c103762a8','gigabytes',-1,'2025-11-23 05:53:06','55c95d49-aa56-4fad-870f-b645f28cd680'),('2025-11-22 05:53:09.196594',NULL,'2025-11-22 05:53:09.232462',275,275,'9b5bfcdf5ad54171a9698feaa812530a','ff26dfb4-d315-4452-8aa6-6eaa6b56d86a',97,'acb08ef912784bb89000a87c4621bcc9','shares',1,'2025-11-23 05:53:09',NULL),('2025-11-22 05:53:09.197693',NULL,'2025-11-22 05:53:09.232462',276,276,'9b5bfcdf5ad54171a9698feaa812530a','854fdf2a-94a1-473e-aae2-69a39c6161e2',98,'acb08ef912784bb89000a87c4621bcc9','gigabytes',1,'2025-11-23 05:53:09',NULL),('2025-11-22 05:53:09.207982',NULL,'2025-11-22 05:53:09.232462',277,277,NULL,'ef181357-5d37-48cf-a0fd-85f529fe5037',99,'acb08ef912784bb89000a87c4621bcc9','shares',1,'2025-11-23 05:53:09','16388226-9203-43cc-b11b-c8d5e0b43cf5'),('2025-11-22 05:53:09.209566',NULL,'2025-11-22 05:53:09.232462',278,278,NULL,'837d282b-0e81-4dca-84cf-c756dd767386',100,'acb08ef912784bb89000a87c4621bcc9','gigabytes',1,'2025-11-23 05:53:09','16388226-9203-43cc-b11b-c8d5e0b43cf5'),('2025-11-22 05:53:12.779293',NULL,'2025-11-22 05:53:12.870920',279,279,'9b5bfcdf5ad54171a9698feaa812530a','24896e5a-a769-4a81-a19a-435a1bfab0ac',97,'acb08ef912784bb89000a87c4621bcc9','shares',1,'2025-11-23 05:53:12',NULL),('2025-11-22 05:53:12.781136',NULL,'2025-11-22 05:53:12.870920',280,280,'9b5bfcdf5ad54171a9698feaa812530a','e38902a6-db94-443c-933e-28bed52b4a26',98,'acb08ef912784bb89000a87c4621bcc9','gigabytes',1,'2025-11-23 05:53:12',NULL),('2025-11-22 05:53:12.797798',NULL,'2025-11-22 05:53:12.870920',281,281,NULL,'58ab0353-1d50-419a-8437-1f58c793f4c6',99,'acb08ef912784bb89000a87c4621bcc9','shares',1,'2025-11-23 05:53:12','16388226-9203-43cc-b11b-c8d5e0b43cf5'),('2025-11-22 05:53:12.799404',NULL,'2025-11-22 05:53:12.870920',282,282,NULL,'f5f35f83-6761-470f-aaa6-258fb7ff7c8e',100,'acb08ef912784bb89000a87c4621bcc9','gigabytes',1,'2025-11-23 05:53:12','16388226-9203-43cc-b11b-c8d5e0b43cf5'),('2025-11-22 05:53:14.335532',NULL,'2025-11-22 05:53:14.384314',283,283,'54e641a9522e40ffa67c2ca3c0b53ce6','560da892-7cc2-4b5a-9080-ca28025d421b',102,'a87583242abb48e1ba1f4d9c6aa18a9b','shares',1,'2025-11-23 05:53:14',NULL),('2025-11-22 05:53:14.336863',NULL,'2025-11-22 05:53:14.384314',284,284,'54e641a9522e40ffa67c2ca3c0b53ce6','60b7fa43-b74b-4847-8b93-cb035e9b8617',101,'a87583242abb48e1ba1f4d9c6aa18a9b','gigabytes',1,'2025-11-23 05:53:14',NULL),('2025-11-22 05:53:14.350423',NULL,'2025-11-22 05:53:14.384314',285,285,NULL,'dad55467-50e4-40cd-bfc9-a5c9d0ab6a35',104,'a87583242abb48e1ba1f4d9c6aa18a9b','shares',1,'2025-11-23 05:53:14','13ee97c5-d501-438f-a1cb-88b356e6aea5'),('2025-11-22 05:53:14.351922',NULL,'2025-11-22 05:53:14.384314',286,286,NULL,'e7d52950-c1ee-4606-b91b-b629cc7ea844',103,'a87583242abb48e1ba1f4d9c6aa18a9b','gigabytes',1,'2025-11-23 05:53:14','13ee97c5-d501-438f-a1cb-88b356e6aea5'),('2025-11-22 05:53:17.634395',NULL,'2025-11-22 05:53:17.652830',287,287,'9b5bfcdf5ad54171a9698feaa812530a','24059b7a-b5d1-4843-bd1c-d359e22aea04',97,'acb08ef912784bb89000a87c4621bcc9','shares',-1,'2025-11-23 05:53:17',NULL),('2025-11-22 05:53:17.635230',NULL,'2025-11-22 05:53:17.652830',288,288,'9b5bfcdf5ad54171a9698feaa812530a','4a24f44a-3eba-445d-a433-00961a862490',98,'acb08ef912784bb89000a87c4621bcc9','gigabytes',-1,'2025-11-23 05:53:17',NULL),('2025-11-22 05:53:17.642794',NULL,'2025-11-22 05:53:17.652830',289,289,NULL,'a254781d-f655-43bd-9aa0-fdf244b79a26',99,'acb08ef912784bb89000a87c4621bcc9','shares',-1,'2025-11-23 05:53:17','16388226-9203-43cc-b11b-c8d5e0b43cf5'),('2025-11-22 05:53:17.643893',NULL,'2025-11-22 05:53:17.652830',290,290,NULL,'8d3a61be-5b98-43c0-8a16-dd345b1158d4',100,'acb08ef912784bb89000a87c4621bcc9','gigabytes',-1,'2025-11-23 05:53:17','16388226-9203-43cc-b11b-c8d5e0b43cf5'),('2025-11-22 05:53:18.058458',NULL,'2025-11-22 05:53:18.153003',291,291,'54e641a9522e40ffa67c2ca3c0b53ce6','9feb4664-5858-4f8e-a441-57327ddde790',105,'a87583242abb48e1ba1f4d9c6aa18a9b','snapshots',1,'2025-11-23 05:53:17',NULL),('2025-11-22 05:53:18.060835',NULL,'2025-11-22 05:53:18.153003',292,292,'54e641a9522e40ffa67c2ca3c0b53ce6','360d39a4-1334-4dbc-a3bc-2a7774461650',106,'a87583242abb48e1ba1f4d9c6aa18a9b','snapshot_gigabytes',1,'2025-11-23 05:53:17',NULL),('2025-11-22 05:53:18.076113',NULL,'2025-11-22 05:53:18.153003',293,293,NULL,'1cba0072-4980-4984-af37-9266b9918114',107,'a87583242abb48e1ba1f4d9c6aa18a9b','snapshots',1,'2025-11-23 05:53:17','13ee97c5-d501-438f-a1cb-88b356e6aea5'),('2025-11-22 05:53:18.077989',NULL,'2025-11-22 05:53:18.153003',294,294,NULL,'1323ae93-cc24-4673-89ac-848a684a3674',108,'a87583242abb48e1ba1f4d9c6aa18a9b','snapshot_gigabytes',1,'2025-11-23 05:53:17','13ee97c5-d501-438f-a1cb-88b356e6aea5'),('2025-11-22 05:53:20.110937',NULL,'2025-11-22 05:53:20.172802',295,295,'e136c1b06bce4b998a5350385e9229ad','a40745bd-a0fa-4546-9b17-b90a94537a7f',109,'c16b253430cb40f6bf0f328197748aef','share_networks',1,'2025-11-23 05:53:20',NULL),('2025-11-22 05:53:20.569898',NULL,'2025-11-22 05:53:20.785686',296,296,'d8f03b5718b045adbc9a577ce80ce1ab','0ff1cddc-f1a5-4fa2-8476-d728cb5cc731',110,'b59c82aac0154932bb0672ff00781e5f','share_networks',1,'2025-11-23 05:53:20',NULL),('2025-11-22 05:53:20.940622',NULL,'2025-11-22 05:53:21.232669',297,297,'9b5bfcdf5ad54171a9698feaa812530a','9168b9a5-6be7-49f2-bfe5-35b290e0f09f',97,'acb08ef912784bb89000a87c4621bcc9','shares',1,'2025-11-23 05:53:20',NULL),('2025-11-22 05:53:20.942229',NULL,'2025-11-22 05:53:21.232669',298,298,'9b5bfcdf5ad54171a9698feaa812530a','3931a5c0-119e-4879-947e-f402d267c6ac',98,'acb08ef912784bb89000a87c4621bcc9','gigabytes',1,'2025-11-23 05:53:20',NULL),('2025-11-22 05:53:20.979472',NULL,'2025-11-22 05:53:21.232669',299,299,NULL,'fa319219-8405-43a4-9ae7-8dbc40b5e043',99,'acb08ef912784bb89000a87c4621bcc9','shares',1,'2025-11-23 05:53:20','16388226-9203-43cc-b11b-c8d5e0b43cf5'),('2025-11-22 05:53:20.987825',NULL,'2025-11-22 05:53:21.232669',300,300,NULL,'4b65ffa9-1432-4534-8b03-d3039a105b25',100,'acb08ef912784bb89000a87c4621bcc9','gigabytes',1,'2025-11-23 05:53:20','16388226-9203-43cc-b11b-c8d5e0b43cf5'),('2025-11-22 05:53:21.819128',NULL,'2025-11-22 05:53:22.185750',301,301,'54e641a9522e40ffa67c2ca3c0b53ce6','e5ae102d-c349-4ecb-a014-f85804b9f1fb',102,'a87583242abb48e1ba1f4d9c6aa18a9b','shares',1,'2025-11-23 05:53:21',NULL),('2025-11-22 05:53:21.820546',NULL,'2025-11-22 05:53:22.185750',302,302,'54e641a9522e40ffa67c2ca3c0b53ce6','f4b36b49-5226-44ba-90e8-013a2440689e',101,'a87583242abb48e1ba1f4d9c6aa18a9b','gigabytes',1,'2025-11-23 05:53:21',NULL),('2025-11-22 05:53:21.978100',NULL,'2025-11-22 05:53:22.185750',303,303,NULL,'065e9d94-cb4b-495b-b80e-ba1ff271d43f',104,'a87583242abb48e1ba1f4d9c6aa18a9b','shares',1,'2025-11-23 05:53:21','13ee97c5-d501-438f-a1cb-88b356e6aea5'),('2025-11-22 05:53:21.979937',NULL,'2025-11-22 05:53:22.185750',304,304,NULL,'46a09b36-a5ff-447b-bbe5-8df884dda11f',103,'a87583242abb48e1ba1f4d9c6aa18a9b','gigabytes',1,'2025-11-23 05:53:21','13ee97c5-d501-438f-a1cb-88b356e6aea5'),('2025-11-22 05:53:23.705840',NULL,'2025-11-22 05:53:23.726048',305,305,'e136c1b06bce4b998a5350385e9229ad','c9eb83da-340c-4fde-9d7a-10976854d052',109,'c16b253430cb40f6bf0f328197748aef','share_networks',-1,'2025-11-23 05:53:23',NULL),('2025-11-22 05:53:29.987029',NULL,'2025-11-22 05:53:30.174215',306,306,'9b5bfcdf5ad54171a9698feaa812530a','03c3bba4-41e8-4512-a617-5f1fb7bc989a',97,'acb08ef912784bb89000a87c4621bcc9','shares',-1,'2025-11-23 05:53:29',NULL),('2025-11-22 05:53:29.987941',NULL,'2025-11-22 05:53:30.174215',307,307,'9b5bfcdf5ad54171a9698feaa812530a','d42253e2-19c0-4c5f-9637-332d8cf00d18',98,'acb08ef912784bb89000a87c4621bcc9','gigabytes',-1,'2025-11-23 05:53:29',NULL),('2025-11-22 05:53:30.059702',NULL,'2025-11-22 05:53:30.174215',308,308,NULL,'6dafb223-b086-4f29-82d5-cd119cad9818',99,'acb08ef912784bb89000a87c4621bcc9','shares',-1,'2025-11-23 05:53:29','16388226-9203-43cc-b11b-c8d5e0b43cf5'),('2025-11-22 05:53:30.060763',NULL,'2025-11-22 05:53:30.174215',309,309,NULL,'3ca43adb-28ec-42d0-ac9a-7b080c1da5f3',100,'acb08ef912784bb89000a87c4621bcc9','gigabytes',-1,'2025-11-23 05:53:29','16388226-9203-43cc-b11b-c8d5e0b43cf5'),('2025-11-22 05:53:30.819054',NULL,'2025-11-22 05:53:30.845609',310,310,'9b5bfcdf5ad54171a9698feaa812530a','3b9ac95e-85dd-4c4e-8a41-dd7ae07703b0',97,'acb08ef912784bb89000a87c4621bcc9','shares',1,'2025-11-23 05:53:30',NULL),('2025-11-22 05:53:30.820181',NULL,'2025-11-22 05:53:30.845609',311,311,'9b5bfcdf5ad54171a9698feaa812530a','1171a730-44ba-4319-98c7-ab7cadce20a7',98,'acb08ef912784bb89000a87c4621bcc9','gigabytes',1,'2025-11-23 05:53:30',NULL),('2025-11-22 05:53:30.826117',NULL,'2025-11-22 05:53:30.845609',312,312,NULL,'8308aef5-2b09-402f-adaa-544f56d96c54',99,'acb08ef912784bb89000a87c4621bcc9','shares',1,'2025-11-23 05:53:30','16388226-9203-43cc-b11b-c8d5e0b43cf5'),('2025-11-22 05:53:30.827148',NULL,'2025-11-22 05:53:30.845609',313,313,NULL,'ecc7315b-bf8e-4485-a487-7f50f30ebaa4',100,'acb08ef912784bb89000a87c4621bcc9','gigabytes',1,'2025-11-23 05:53:30','16388226-9203-43cc-b11b-c8d5e0b43cf5'),('2025-11-22 05:53:35.196229',NULL,'2025-11-22 05:53:35.281616',314,314,'9b5bfcdf5ad54171a9698feaa812530a','55817771-b0fb-49dc-b979-29a4fa90380f',97,'acb08ef912784bb89000a87c4621bcc9','shares',-1,'2025-11-23 05:53:35',NULL),('2025-11-22 05:53:35.197292',NULL,'2025-11-22 05:53:35.281616',315,315,'9b5bfcdf5ad54171a9698feaa812530a','d560e136-7db3-4022-969f-0a4a62df0fdc',98,'acb08ef912784bb89000a87c4621bcc9','gigabytes',-1,'2025-11-23 05:53:35',NULL),('2025-11-22 05:53:35.246318',NULL,'2025-11-22 05:53:35.281616',316,316,NULL,'95fd0dce-7ba3-4492-9c80-583dde847787',99,'acb08ef912784bb89000a87c4621bcc9','shares',-1,'2025-11-23 05:53:35','16388226-9203-43cc-b11b-c8d5e0b43cf5'),('2025-11-22 05:53:35.247246',NULL,'2025-11-22 05:53:35.281616',317,317,NULL,'f0797e77-a6b5-4c6b-b3cc-1795bb9ac6ba',100,'acb08ef912784bb89000a87c4621bcc9','gigabytes',-1,'2025-11-23 05:53:35','16388226-9203-43cc-b11b-c8d5e0b43cf5'),('2025-11-22 05:53:38.233054',NULL,'2025-11-22 05:53:38.288238',318,318,'9b5bfcdf5ad54171a9698feaa812530a','b0a02f10-a01b-49d8-96a7-2835d9119fb3',97,'acb08ef912784bb89000a87c4621bcc9','shares',1,'2025-11-23 05:53:38',NULL),('2025-11-22 05:53:38.235001',NULL,'2025-11-22 05:53:38.288238',319,319,'9b5bfcdf5ad54171a9698feaa812530a','730a9a76-7b33-4f0f-be1f-b88bd8e7d5bc',98,'acb08ef912784bb89000a87c4621bcc9','gigabytes',1,'2025-11-23 05:53:38',NULL),('2025-11-22 05:53:38.251287',NULL,'2025-11-22 05:53:38.288238',320,320,NULL,'c8735151-1da9-417d-b5e0-a1a532b82e07',99,'acb08ef912784bb89000a87c4621bcc9','shares',1,'2025-11-23 05:53:38','16388226-9203-43cc-b11b-c8d5e0b43cf5'),('2025-11-22 05:53:38.254330',NULL,'2025-11-22 05:53:38.288238',321,321,NULL,'ce96ddaf-087f-4bac-a7b2-368de3d32982',100,'acb08ef912784bb89000a87c4621bcc9','gigabytes',1,'2025-11-23 05:53:38','16388226-9203-43cc-b11b-c8d5e0b43cf5'),('2025-11-22 05:53:45.720013',NULL,'2025-11-22 05:53:45.733457',322,322,'9b5bfcdf5ad54171a9698feaa812530a','579bb933-cbbf-4c0f-ab2d-f0c2d88c3461',97,'acb08ef912784bb89000a87c4621bcc9','shares',-1,'2025-11-23 05:53:45',NULL),('2025-11-22 05:53:45.720848',NULL,'2025-11-22 05:53:45.733457',323,323,'9b5bfcdf5ad54171a9698feaa812530a','9cc2865a-72ce-4781-894a-f6d37bea3ea9',98,'acb08ef912784bb89000a87c4621bcc9','gigabytes',-1,'2025-11-23 05:53:45',NULL),('2025-11-22 05:53:45.725730',NULL,'2025-11-22 05:53:45.733457',324,324,NULL,'e13c2092-c184-4e4f-83c5-3728f6812a88',99,'acb08ef912784bb89000a87c4621bcc9','shares',-1,'2025-11-23 05:53:45','16388226-9203-43cc-b11b-c8d5e0b43cf5'),('2025-11-22 05:53:45.726515',NULL,'2025-11-22 05:53:45.733457',325,325,NULL,'4aecc0bd-f84b-42a8-860b-0cb32978051d',100,'acb08ef912784bb89000a87c4621bcc9','gigabytes',-1,'2025-11-23 05:53:45','16388226-9203-43cc-b11b-c8d5e0b43cf5'),('2025-11-22 05:53:50.930766',NULL,'2025-11-22 05:53:50.966060',326,326,'9b5bfcdf5ad54171a9698feaa812530a','38800424-bd47-47e9-a244-4cd8049d24fd',97,'acb08ef912784bb89000a87c4621bcc9','shares',1,'2025-11-23 05:53:50',NULL),('2025-11-22 05:53:50.931843',NULL,'2025-11-22 05:53:50.966060',327,327,'9b5bfcdf5ad54171a9698feaa812530a','0490d3e7-6ed8-427f-b6ed-d94dc7c8fb12',98,'acb08ef912784bb89000a87c4621bcc9','gigabytes',1,'2025-11-23 05:53:50',NULL),('2025-11-22 05:53:50.936564',NULL,'2025-11-22 05:53:50.966060',328,328,NULL,'5fc38529-8695-4673-b5c6-7130c181b67b',99,'acb08ef912784bb89000a87c4621bcc9','shares',1,'2025-11-23 05:53:50','16388226-9203-43cc-b11b-c8d5e0b43cf5'),('2025-11-22 05:53:50.937614',NULL,'2025-11-22 05:53:50.966060',329,329,NULL,'462cf7a9-a53d-44c0-a430-d203c46ffc36',100,'acb08ef912784bb89000a87c4621bcc9','gigabytes',1,'2025-11-23 05:53:50','16388226-9203-43cc-b11b-c8d5e0b43cf5'),('2025-11-22 05:53:57.158989',NULL,'2025-11-22 05:53:57.174889',330,330,'9b5bfcdf5ad54171a9698feaa812530a','09b656d3-14a6-482f-9c1c-b7f702c44549',97,'acb08ef912784bb89000a87c4621bcc9','shares',-1,'2025-11-23 05:53:57',NULL),('2025-11-22 05:53:57.159713',NULL,'2025-11-22 05:53:57.174889',331,331,'9b5bfcdf5ad54171a9698feaa812530a','a550f5e5-dea8-43c1-8a5d-9b1eec3008e9',98,'acb08ef912784bb89000a87c4621bcc9','gigabytes',-1,'2025-11-23 05:53:57',NULL),('2025-11-22 05:53:57.165954',NULL,'2025-11-22 05:53:57.174889',332,332,NULL,'277b92fe-c0dd-4f57-ac62-3d15246f2735',99,'acb08ef912784bb89000a87c4621bcc9','shares',-1,'2025-11-23 05:53:57','16388226-9203-43cc-b11b-c8d5e0b43cf5'),('2025-11-22 05:53:57.166577',NULL,'2025-11-22 05:53:57.174889',333,333,NULL,'3875ba95-e14e-49d0-b0c0-947b4a009a5f',100,'acb08ef912784bb89000a87c4621bcc9','gigabytes',-1,'2025-11-23 05:53:57','16388226-9203-43cc-b11b-c8d5e0b43cf5'),('2025-11-22 05:53:57.664469',NULL,'2025-11-22 05:53:57.725390',334,334,'c0acc593440f4aba93cebeb0a88cf188','7cbc1f76-c93f-4962-9121-41bc1b9aff32',112,'1c76ef654a3e4144bc0a4cdf01f6107d','shares',1,'2025-11-23 05:53:57',NULL),('2025-11-22 05:53:57.665800',NULL,'2025-11-22 05:53:57.725390',335,335,'c0acc593440f4aba93cebeb0a88cf188','7bc80f46-7617-4eec-95ad-3b422b34457b',111,'1c76ef654a3e4144bc0a4cdf01f6107d','gigabytes',1,'2025-11-23 05:53:57',NULL),('2025-11-22 05:53:57.678751',NULL,'2025-11-22 05:53:57.725390',336,336,NULL,'71d81753-8bb7-4a42-8165-ddd7a8bda47d',114,'1c76ef654a3e4144bc0a4cdf01f6107d','shares',1,'2025-11-23 05:53:57','a5b83cc3-3a22-4b5e-9258-2ea0c4739722'),('2025-11-22 05:53:57.679998',NULL,'2025-11-22 05:53:57.725390',337,337,NULL,'cb77490b-bb03-4418-8062-950c0133a95b',113,'1c76ef654a3e4144bc0a4cdf01f6107d','gigabytes',1,'2025-11-23 05:53:57','a5b83cc3-3a22-4b5e-9258-2ea0c4739722'),('2025-11-22 05:54:01.088990',NULL,'2025-11-22 05:54:01.163925',338,338,'c0acc593440f4aba93cebeb0a88cf188','16df1a7c-409c-46d9-ac83-a383df1b8f66',115,'1c76ef654a3e4144bc0a4cdf01f6107d','snapshots',1,'2025-11-23 05:54:01',NULL),('2025-11-22 05:54:01.089945',NULL,'2025-11-22 05:54:01.163925',339,339,'c0acc593440f4aba93cebeb0a88cf188','c488b402-1535-477a-8d3b-e74839640edc',116,'1c76ef654a3e4144bc0a4cdf01f6107d','snapshot_gigabytes',1,'2025-11-23 05:54:01',NULL),('2025-11-22 05:54:01.098159',NULL,'2025-11-22 05:54:01.163925',340,340,NULL,'0f529e64-1fd0-4021-8e19-777d50737a4f',117,'1c76ef654a3e4144bc0a4cdf01f6107d','snapshots',1,'2025-11-23 05:54:01','a5b83cc3-3a22-4b5e-9258-2ea0c4739722'),('2025-11-22 05:54:01.099020',NULL,'2025-11-22 05:54:01.163925',341,341,NULL,'6132da28-1e49-4c08-bd03-66dd587481e1',118,'1c76ef654a3e4144bc0a4cdf01f6107d','snapshot_gigabytes',1,'2025-11-23 05:54:01','a5b83cc3-3a22-4b5e-9258-2ea0c4739722'),('2025-11-22 05:54:02.958103',NULL,'2025-11-22 05:54:02.982797',342,342,'9b5bfcdf5ad54171a9698feaa812530a','85aab477-39b9-4560-b9d0-d7782cec666d',97,'acb08ef912784bb89000a87c4621bcc9','shares',-1,'2025-11-23 05:54:02',NULL),('2025-11-22 05:54:02.959859',NULL,'2025-11-22 05:54:02.982797',343,343,'9b5bfcdf5ad54171a9698feaa812530a','6fb473ac-a5bb-4439-b65a-d289478bfd39',98,'acb08ef912784bb89000a87c4621bcc9','gigabytes',-1,'2025-11-23 05:54:02',NULL),('2025-11-22 05:54:02.969462',NULL,'2025-11-22 05:54:02.982797',344,344,NULL,'d718c5be-16c7-42a7-88bf-ff900b63f4b5',99,'acb08ef912784bb89000a87c4621bcc9','shares',-1,'2025-11-23 05:54:02','16388226-9203-43cc-b11b-c8d5e0b43cf5'),('2025-11-22 05:54:02.970615',NULL,'2025-11-22 05:54:02.982797',345,345,NULL,'6f65dfc3-6660-4738-8402-269b4eeda7e5',100,'acb08ef912784bb89000a87c4621bcc9','gigabytes',-1,'2025-11-23 05:54:02','16388226-9203-43cc-b11b-c8d5e0b43cf5'),('2025-11-22 05:54:06.055681',NULL,'2025-11-22 05:54:06.097896',346,346,'c0acc593440f4aba93cebeb0a88cf188','bf9ded82-edab-48ec-959f-bce67413eefe',115,'1c76ef654a3e4144bc0a4cdf01f6107d','snapshots',-1,'2025-11-23 05:54:06',NULL),('2025-11-22 05:54:06.056418',NULL,'2025-11-22 05:54:06.097896',347,347,'c0acc593440f4aba93cebeb0a88cf188','c4aab8e9-cd21-4893-9ca3-e23281a4a7b7',116,'1c76ef654a3e4144bc0a4cdf01f6107d','snapshot_gigabytes',-1,'2025-11-23 05:54:06',NULL),('2025-11-22 05:54:06.075429',NULL,'2025-11-22 05:54:06.097896',348,348,NULL,'36385dec-cf36-471a-88b4-afb80ef58d7f',117,'1c76ef654a3e4144bc0a4cdf01f6107d','snapshots',-1,'2025-11-23 05:54:06','a5b83cc3-3a22-4b5e-9258-2ea0c4739722'),('2025-11-22 05:54:06.076198',NULL,'2025-11-22 05:54:06.097896',349,349,NULL,'4f8efec0-81c7-4c3e-a62b-abb3a95cef73',118,'1c76ef654a3e4144bc0a4cdf01f6107d','snapshot_gigabytes',-1,'2025-11-23 05:54:06','a5b83cc3-3a22-4b5e-9258-2ea0c4739722'),('2025-11-22 05:54:08.284749',NULL,'2025-11-22 05:54:08.301166',350,350,'54e641a9522e40ffa67c2ca3c0b53ce6','80a59691-6565-43d9-b875-ea0962896a94',102,'a87583242abb48e1ba1f4d9c6aa18a9b','shares',-1,'2025-11-23 05:54:08',NULL),('2025-11-22 05:54:08.285541',NULL,'2025-11-22 05:54:08.301166',351,351,'54e641a9522e40ffa67c2ca3c0b53ce6','15964864-7f73-4a20-b768-26f6832ae007',101,'a87583242abb48e1ba1f4d9c6aa18a9b','gigabytes',-1,'2025-11-23 05:54:08',NULL),('2025-11-22 05:54:08.292655',NULL,'2025-11-22 05:54:08.301166',352,352,NULL,'e081344e-0688-4775-8800-214f2155ecd8',104,'a87583242abb48e1ba1f4d9c6aa18a9b','shares',-1,'2025-11-23 05:54:08','13ee97c5-d501-438f-a1cb-88b356e6aea5'),('2025-11-22 05:54:08.293818',NULL,'2025-11-22 05:54:08.301166',353,353,NULL,'affc66a6-332d-44c6-a743-6038a87ba1af',103,'a87583242abb48e1ba1f4d9c6aa18a9b','gigabytes',-1,'2025-11-23 05:54:08','13ee97c5-d501-438f-a1cb-88b356e6aea5'),('2025-11-22 05:54:09.345105',NULL,'2025-11-22 05:54:09.360164',354,354,'c0acc593440f4aba93cebeb0a88cf188','8ae4ad51-5888-4d8c-8c5b-2e559952a640',112,'1c76ef654a3e4144bc0a4cdf01f6107d','shares',-1,'2025-11-23 05:54:09',NULL),('2025-11-22 05:54:09.345785',NULL,'2025-11-22 05:54:09.360164',355,355,'c0acc593440f4aba93cebeb0a88cf188','19c28599-dc38-4ded-b943-3e1a13fea0c5',111,'1c76ef654a3e4144bc0a4cdf01f6107d','gigabytes',-1,'2025-11-23 05:54:09',NULL),('2025-11-22 05:54:09.351371',NULL,'2025-11-22 05:54:09.360164',356,356,NULL,'0d9181e4-982f-45c1-b4d7-5685af95bc55',114,'1c76ef654a3e4144bc0a4cdf01f6107d','shares',-1,'2025-11-23 05:54:09','a5b83cc3-3a22-4b5e-9258-2ea0c4739722'),('2025-11-22 05:54:09.352107',NULL,'2025-11-22 05:54:09.360164',357,357,NULL,'22468f1a-4745-4031-9b85-c611f986f623',113,'1c76ef654a3e4144bc0a4cdf01f6107d','gigabytes',-1,'2025-11-23 05:54:09','a5b83cc3-3a22-4b5e-9258-2ea0c4739722'),('2025-11-22 05:54:12.060860',NULL,'2025-11-22 05:54:12.097652',358,358,'54e641a9522e40ffa67c2ca3c0b53ce6','2fa33970-f582-4a72-8e1f-7cfb76ff59e7',105,'a87583242abb48e1ba1f4d9c6aa18a9b','snapshots',-1,'2025-11-23 05:54:12',NULL),('2025-11-22 05:54:12.062043',NULL,'2025-11-22 05:54:12.097652',359,359,'54e641a9522e40ffa67c2ca3c0b53ce6','023b32d5-002b-48d8-a654-b7946fe0c4ff',106,'a87583242abb48e1ba1f4d9c6aa18a9b','snapshot_gigabytes',-1,'2025-11-23 05:54:12',NULL),('2025-11-22 05:54:12.077582',NULL,'2025-11-22 05:54:12.097652',360,360,NULL,'ae2d7982-0be3-4b8f-901e-e5cab7b9b927',107,'a87583242abb48e1ba1f4d9c6aa18a9b','snapshots',-1,'2025-11-23 05:54:12','13ee97c5-d501-438f-a1cb-88b356e6aea5'),('2025-11-22 05:54:12.078583',NULL,'2025-11-22 05:54:12.097652',361,361,NULL,'5331b62a-9b95-418b-8868-0628e82cbbec',108,'a87583242abb48e1ba1f4d9c6aa18a9b','snapshot_gigabytes',-1,'2025-11-23 05:54:12','13ee97c5-d501-438f-a1cb-88b356e6aea5'),('2025-11-22 05:54:14.718213',NULL,'2025-11-22 05:54:14.778781',362,362,'4a3993de61324ab4ae41b5b9d711e3a9','c5231094-e9e9-4f99-bd4c-6885e465d791',119,'5c79362f5df94bb7805d87f3cb0f6a70','shares',1,'2025-11-23 05:54:14',NULL),('2025-11-22 05:54:14.721319',NULL,'2025-11-22 05:54:14.778781',363,363,'4a3993de61324ab4ae41b5b9d711e3a9','36abe4c8-85a3-447c-89d6-370a2c2d64f3',120,'5c79362f5df94bb7805d87f3cb0f6a70','gigabytes',1,'2025-11-23 05:54:14',NULL),('2025-11-22 05:54:14.737821',NULL,'2025-11-22 05:54:14.778781',364,364,NULL,'2d851213-6e08-40c9-a1ea-b2490ecaf421',121,'5c79362f5df94bb7805d87f3cb0f6a70','shares',1,'2025-11-23 05:54:14','a4dd46bb-4dd9-48bd-92ee-1a6f0e9dbfe6'),('2025-11-22 05:54:14.739607',NULL,'2025-11-22 05:54:14.778781',365,365,NULL,'fd4e12b5-bfbb-46b0-9372-e0eed074168f',122,'5c79362f5df94bb7805d87f3cb0f6a70','gigabytes',1,'2025-11-23 05:54:14','a4dd46bb-4dd9-48bd-92ee-1a6f0e9dbfe6'),('2025-11-22 05:54:15.547036',NULL,'2025-11-22 05:54:15.617798',366,366,'54e641a9522e40ffa67c2ca3c0b53ce6','a29ff516-e0d9-4a76-b341-6ea054cae6d6',102,'a87583242abb48e1ba1f4d9c6aa18a9b','shares',-1,'2025-11-23 05:54:15',NULL),('2025-11-22 05:54:15.549780',NULL,'2025-11-22 05:54:15.617798',367,367,'54e641a9522e40ffa67c2ca3c0b53ce6','ed329709-8df1-458e-ad04-7376ba412de4',101,'a87583242abb48e1ba1f4d9c6aa18a9b','gigabytes',-1,'2025-11-23 05:54:15',NULL),('2025-11-22 05:54:15.596934',NULL,'2025-11-22 05:54:15.617798',368,368,NULL,'8c442d59-d6d3-47d4-a605-d4ea355d283e',104,'a87583242abb48e1ba1f4d9c6aa18a9b','shares',-1,'2025-11-23 05:54:15','13ee97c5-d501-438f-a1cb-88b356e6aea5'),('2025-11-22 05:54:15.598414',NULL,'2025-11-22 05:54:15.617798',369,369,NULL,'4afd5f24-e745-45d0-86a8-960aee04c768',103,'a87583242abb48e1ba1f4d9c6aa18a9b','gigabytes',-1,'2025-11-23 05:54:15','13ee97c5-d501-438f-a1cb-88b356e6aea5'),('2025-11-22 05:54:18.417221',NULL,'2025-11-22 05:54:18.517093',370,370,'2256793bd84244a3bcb61874a41075c5','d9108d1f-8810-40c2-8cf1-ddfaf50d3d0f',124,'879b9840974d4a5186ae02687052f6dc','shares',1,'2025-11-23 05:54:18',NULL),('2025-11-22 05:54:18.418581',NULL,'2025-11-22 05:54:18.517093',371,371,'2256793bd84244a3bcb61874a41075c5','b249f22b-5c79-4f17-9d35-9067e6c4e57b',123,'879b9840974d4a5186ae02687052f6dc','gigabytes',1,'2025-11-23 05:54:18',NULL),('2025-11-22 05:54:18.456285',NULL,'2025-11-22 05:54:18.517093',372,372,NULL,'93e7ade7-a3fe-4200-ac7f-3e74fa9c5551',126,'879b9840974d4a5186ae02687052f6dc','shares',1,'2025-11-23 05:54:18','a4dd46bb-4dd9-48bd-92ee-1a6f0e9dbfe6'),('2025-11-22 05:54:18.457505',NULL,'2025-11-22 05:54:18.517093',373,373,NULL,'3037dc80-e26d-4ecf-9f4a-5c6ead55af05',125,'879b9840974d4a5186ae02687052f6dc','gigabytes',1,'2025-11-23 05:54:18','a4dd46bb-4dd9-48bd-92ee-1a6f0e9dbfe6'),('2025-11-22 05:54:22.743805',NULL,'2025-11-22 05:54:22.767699',374,374,'2256793bd84244a3bcb61874a41075c5','1fedf630-401c-4a5a-a603-2b91fa560bc6',124,'879b9840974d4a5186ae02687052f6dc','shares',-1,'2025-11-23 05:54:22',NULL),('2025-11-22 05:54:22.748995',NULL,'2025-11-22 05:54:22.767699',375,375,'2256793bd84244a3bcb61874a41075c5','9d0efbb7-b0e9-4fb0-982d-b74d4bb0afed',123,'879b9840974d4a5186ae02687052f6dc','gigabytes',-1,'2025-11-23 05:54:22',NULL),('2025-11-22 05:54:22.758856',NULL,'2025-11-22 05:54:22.767699',376,376,NULL,'2ae91349-9a56-4dc1-991e-f470e624196a',126,'879b9840974d4a5186ae02687052f6dc','shares',-1,'2025-11-23 05:54:22','a4dd46bb-4dd9-48bd-92ee-1a6f0e9dbfe6'),('2025-11-22 05:54:22.759605',NULL,'2025-11-22 05:54:22.767699',377,377,NULL,'8705178d-a643-46a4-a4f9-e481f9f9d54f',125,'879b9840974d4a5186ae02687052f6dc','gigabytes',-1,'2025-11-23 05:54:22','a4dd46bb-4dd9-48bd-92ee-1a6f0e9dbfe6'),('2025-11-22 05:54:26.749837',NULL,'2025-11-22 05:54:26.777628',378,378,'4a3993de61324ab4ae41b5b9d711e3a9','45003346-58e0-41f8-b94b-039b37a69838',119,'5c79362f5df94bb7805d87f3cb0f6a70','shares',-1,'2025-11-23 05:54:26',NULL),('2025-11-22 05:54:26.750839',NULL,'2025-11-22 05:54:26.777628',379,379,'4a3993de61324ab4ae41b5b9d711e3a9','ac80ffba-23c9-4841-a8fb-8e4f10b25313',120,'5c79362f5df94bb7805d87f3cb0f6a70','gigabytes',-1,'2025-11-23 05:54:26',NULL),('2025-11-22 05:54:26.766965',NULL,'2025-11-22 05:54:26.777628',380,380,NULL,'8c86bd8f-7bcf-411d-a0be-e245ac9d65b8',121,'5c79362f5df94bb7805d87f3cb0f6a70','shares',-1,'2025-11-23 05:54:26','a4dd46bb-4dd9-48bd-92ee-1a6f0e9dbfe6'),('2025-11-22 05:54:26.768186',NULL,'2025-11-22 05:54:26.777628',381,381,NULL,'34add0e4-4ee3-44d9-a176-44f129189a5c',122,'5c79362f5df94bb7805d87f3cb0f6a70','gigabytes',-1,'2025-11-23 05:54:26','a4dd46bb-4dd9-48bd-92ee-1a6f0e9dbfe6'),('2025-11-22 05:54:29.916455',NULL,'2025-11-22 05:54:29.944918',382,382,'2256793bd84244a3bcb61874a41075c5','2a03c58a-88b8-4478-bba4-2137e3826887',124,'879b9840974d4a5186ae02687052f6dc','shares',1,'2025-11-23 05:54:29',NULL),('2025-11-22 05:54:29.917629',NULL,'2025-11-22 05:54:29.944918',383,383,'2256793bd84244a3bcb61874a41075c5','bc5b5cd5-9f73-43ae-a752-c69071cc96ae',123,'879b9840974d4a5186ae02687052f6dc','gigabytes',1,'2025-11-23 05:54:29',NULL),('2025-11-22 05:54:29.923286',NULL,'2025-11-22 05:54:29.944918',384,384,NULL,'1c58dde2-29f5-4c6e-9fcc-27fda0d91509',126,'879b9840974d4a5186ae02687052f6dc','shares',1,'2025-11-23 05:54:29','a4dd46bb-4dd9-48bd-92ee-1a6f0e9dbfe6'),('2025-11-22 05:54:29.924213',NULL,'2025-11-22 05:54:29.944918',385,385,NULL,'ed73387d-a907-474f-ba6f-1e23384b139e',125,'879b9840974d4a5186ae02687052f6dc','gigabytes',1,'2025-11-23 05:54:29','a4dd46bb-4dd9-48bd-92ee-1a6f0e9dbfe6'),('2025-11-22 05:54:31.694088',NULL,'2025-11-22 05:54:31.735875',386,386,'a118fe67fdb84bd1bef3675de0af7cc1','d138f859-b24c-4e7c-839a-0acf3d50db10',128,'c1bb25e73f4845c0aa83279619d6c189','shares',1,'2025-11-23 05:54:31',NULL),('2025-11-22 05:54:31.696287',NULL,'2025-11-22 05:54:31.735875',387,387,'a118fe67fdb84bd1bef3675de0af7cc1','fac45897-7dac-49c9-af7c-8887e025f647',127,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',1,'2025-11-23 05:54:31',NULL),('2025-11-22 05:54:31.710016',NULL,'2025-11-22 05:54:31.735875',388,388,NULL,'27fbbfa2-be35-4967-86eb-5e25ca7f7bc3',130,'c1bb25e73f4845c0aa83279619d6c189','shares',1,'2025-11-23 05:54:31','ce3f0727-d1a8-4676-a5dc-450c47e136e8'),('2025-11-22 05:54:31.711089',NULL,'2025-11-22 05:54:31.735875',389,389,NULL,'d9d223a5-ee1c-491a-8107-558c379f29b4',129,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',1,'2025-11-23 05:54:31','ce3f0727-d1a8-4676-a5dc-450c47e136e8'),('2025-11-22 05:54:34.452592',NULL,'2025-11-22 05:54:34.469175',390,390,'2256793bd84244a3bcb61874a41075c5','c5c9a954-aaec-47c2-bfac-465737eb4f49',124,'879b9840974d4a5186ae02687052f6dc','shares',-1,'2025-11-23 05:54:34',NULL),('2025-11-22 05:54:34.453482',NULL,'2025-11-22 05:54:34.469175',391,391,'2256793bd84244a3bcb61874a41075c5','ca8c8d20-673d-40fd-9cae-0dc101111c7e',123,'879b9840974d4a5186ae02687052f6dc','gigabytes',-1,'2025-11-23 05:54:34',NULL),('2025-11-22 05:54:34.461914',NULL,'2025-11-22 05:54:34.469175',392,392,NULL,'27390890-a30f-4b0d-b615-25e56b3e03b7',126,'879b9840974d4a5186ae02687052f6dc','shares',-1,'2025-11-23 05:54:34','a4dd46bb-4dd9-48bd-92ee-1a6f0e9dbfe6'),('2025-11-22 05:54:34.462625',NULL,'2025-11-22 05:54:34.469175',393,393,NULL,'9898fee8-86bc-46d4-a228-d6ef0d9a5d9e',125,'879b9840974d4a5186ae02687052f6dc','gigabytes',-1,'2025-11-23 05:54:34','a4dd46bb-4dd9-48bd-92ee-1a6f0e9dbfe6'),('2025-11-22 05:54:35.586313',NULL,'2025-11-22 05:54:35.597566',394,394,'a118fe67fdb84bd1bef3675de0af7cc1','fde866cb-2c3c-49f6-a82b-3f58a7e85fe8',128,'c1bb25e73f4845c0aa83279619d6c189','shares',-1,'2025-11-23 05:54:35',NULL),('2025-11-22 05:54:35.586933',NULL,'2025-11-22 05:54:35.597566',395,395,'a118fe67fdb84bd1bef3675de0af7cc1','bdfd9638-9276-41b2-b1a8-ff95489e30ad',127,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',-1,'2025-11-23 05:54:35',NULL),('2025-11-22 05:54:35.591242',NULL,'2025-11-22 05:54:35.597566',396,396,NULL,'7a5cb83d-2445-4d08-b69c-655850452e12',130,'c1bb25e73f4845c0aa83279619d6c189','shares',-1,'2025-11-23 05:54:35','ce3f0727-d1a8-4676-a5dc-450c47e136e8'),('2025-11-22 05:54:35.591816',NULL,'2025-11-22 05:54:35.597566',397,397,NULL,'3ea89783-4878-48e5-8d2d-4a68431284a8',129,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',-1,'2025-11-23 05:54:35','ce3f0727-d1a8-4676-a5dc-450c47e136e8'),('2025-11-22 05:54:35.895522',NULL,'2025-11-22 05:54:35.937745',398,398,'a118fe67fdb84bd1bef3675de0af7cc1','1a566314-ed5a-46d1-9d64-08f384f65bc1',128,'c1bb25e73f4845c0aa83279619d6c189','shares',1,'2025-11-23 05:54:35',NULL),('2025-11-22 05:54:35.897405',NULL,'2025-11-22 05:54:35.937745',399,399,'a118fe67fdb84bd1bef3675de0af7cc1','5688f23f-993c-4d0c-94a5-216454e4cd45',127,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',1,'2025-11-23 05:54:35',NULL),('2025-11-22 05:54:35.912376',NULL,'2025-11-22 05:54:35.937745',400,400,NULL,'03bf2658-2bbe-4738-80a9-209e4711328e',131,'c1bb25e73f4845c0aa83279619d6c189','shares',1,'2025-11-23 05:54:35','dcc3507b-971d-43d8-92d2-0d2d0d8c3319'),('2025-11-22 05:54:35.913776',NULL,'2025-11-22 05:54:35.937745',401,401,NULL,'0931739e-2d81-4677-8a7b-450b637dd210',132,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',1,'2025-11-23 05:54:35','dcc3507b-971d-43d8-92d2-0d2d0d8c3319'),('2025-11-22 05:54:39.645736',NULL,'2025-11-22 05:54:39.717996',402,402,'5cd2161e545848cab1c577034bff12ab','9a846222-9a65-4077-ba6a-254f333e8ed2',134,'ff09e2486e9d4c72b3f5e832bcf1885a','shares',1,'2025-11-23 05:54:39',NULL),('2025-11-22 05:54:39.646823',NULL,'2025-11-22 05:54:39.717996',403,403,'5cd2161e545848cab1c577034bff12ab','5cb15ae3-4540-421e-9324-7e52a8012c45',133,'ff09e2486e9d4c72b3f5e832bcf1885a','gigabytes',1,'2025-11-23 05:54:39',NULL),('2025-11-22 05:54:39.677008',NULL,'2025-11-22 05:54:39.692748',404,404,'a118fe67fdb84bd1bef3675de0af7cc1','8d5a25df-86a3-49c2-b006-5d067e630cf6',128,'c1bb25e73f4845c0aa83279619d6c189','shares',-1,'2025-11-23 05:54:39',NULL),('2025-11-22 05:54:39.677360',NULL,'2025-11-22 05:54:39.717996',405,405,NULL,'a72c6969-0d75-4d59-a809-0b37b73e53b9',136,'ff09e2486e9d4c72b3f5e832bcf1885a','shares',1,'2025-11-23 05:54:39','4ef04f31-d6fe-496c-bd09-358cf74fb9ed'),('2025-11-22 05:54:39.677797',NULL,'2025-11-22 05:54:39.692748',406,406,'a118fe67fdb84bd1bef3675de0af7cc1','e6112df3-1dc9-4619-b9af-f0bf6f03e86a',127,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',-1,'2025-11-23 05:54:39',NULL),('2025-11-22 05:54:39.678758',NULL,'2025-11-22 05:54:39.717996',407,407,NULL,'0dbf76ed-3c18-45ff-aa74-985bfb0842b4',135,'ff09e2486e9d4c72b3f5e832bcf1885a','gigabytes',1,'2025-11-23 05:54:39','4ef04f31-d6fe-496c-bd09-358cf74fb9ed'),('2025-11-22 05:54:39.684057',NULL,'2025-11-22 05:54:39.692748',408,408,NULL,'b6d633cf-c45e-45ff-ae47-4b47dd92ea37',131,'c1bb25e73f4845c0aa83279619d6c189','shares',-1,'2025-11-23 05:54:39','dcc3507b-971d-43d8-92d2-0d2d0d8c3319'),('2025-11-22 05:54:39.684789',NULL,'2025-11-22 05:54:39.692748',409,409,NULL,'ead4d4ef-5ea2-4ae5-903c-87dac39d1c86',132,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',-1,'2025-11-23 05:54:39','dcc3507b-971d-43d8-92d2-0d2d0d8c3319'),('2025-11-22 05:54:39.894324',NULL,'2025-11-22 05:54:39.926209',410,410,'a118fe67fdb84bd1bef3675de0af7cc1','bf60e1ad-8ccf-4f49-b2ae-6e9f5b0e7adc',128,'c1bb25e73f4845c0aa83279619d6c189','shares',1,'2025-11-23 05:54:39',NULL),('2025-11-22 05:54:39.895595',NULL,'2025-11-22 05:54:39.926209',411,411,'a118fe67fdb84bd1bef3675de0af7cc1','7434fd59-bb03-4919-aca4-8b5286168909',127,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',1,'2025-11-23 05:54:39',NULL),('2025-11-22 05:54:39.907436',NULL,'2025-11-22 05:54:39.926209',412,412,NULL,'edd18a63-e146-4373-95f4-68d4d5d4f90f',137,'c1bb25e73f4845c0aa83279619d6c189','shares',1,'2025-11-23 05:54:39','08c8c52d-b3da-414c-a61c-d2410111b7e1'),('2025-11-22 05:54:39.908569',NULL,'2025-11-22 05:54:39.926209',413,413,NULL,'73afb37d-e18f-41c6-9572-cfc3393beff3',138,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',1,'2025-11-23 05:54:39','08c8c52d-b3da-414c-a61c-d2410111b7e1'),('2025-11-22 05:54:43.416008',NULL,'2025-11-22 05:54:43.448696',414,414,'a118fe67fdb84bd1bef3675de0af7cc1','7690fcb8-6e5c-4879-a873-a742b371dd2c',128,'c1bb25e73f4845c0aa83279619d6c189','shares',1,'2025-11-23 05:54:43',NULL),('2025-11-22 05:54:43.417410',NULL,'2025-11-22 05:54:43.448696',415,415,'a118fe67fdb84bd1bef3675de0af7cc1','20da5169-6cf3-4948-bbed-c9135f9aa33b',127,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',1,'2025-11-23 05:54:43',NULL),('2025-11-22 05:54:43.427229',NULL,'2025-11-22 05:54:43.448696',416,416,NULL,'b2122efe-5783-41bd-b799-70efc3692fe6',140,'c1bb25e73f4845c0aa83279619d6c189','shares',1,'2025-11-23 05:54:43','69975aa8-2ab7-43ef-9ea3-bf3bb458d4bc'),('2025-11-22 05:54:43.428233',NULL,'2025-11-22 05:54:43.448696',417,417,NULL,'863a7dc7-6dd7-4a7b-a12c-31cbbe9791b6',139,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',1,'2025-11-23 05:54:43','69975aa8-2ab7-43ef-9ea3-bf3bb458d4bc'),('2025-11-22 05:54:45.545159',NULL,'2025-11-22 05:54:45.561845',418,418,'5cd2161e545848cab1c577034bff12ab','42744451-8447-410a-95f0-255264db1a0b',134,'ff09e2486e9d4c72b3f5e832bcf1885a','shares',-1,'2025-11-23 05:54:45',NULL),('2025-11-22 05:54:45.545963',NULL,'2025-11-22 05:54:45.561845',419,419,'5cd2161e545848cab1c577034bff12ab','dbd957d6-a5bb-4e11-b6b6-dd28f92d6c80',133,'ff09e2486e9d4c72b3f5e832bcf1885a','gigabytes',-1,'2025-11-23 05:54:45',NULL),('2025-11-22 05:54:45.551425',NULL,'2025-11-22 05:54:45.561845',420,420,NULL,'b9054600-aca4-4697-a4fc-a8534c637d2b',136,'ff09e2486e9d4c72b3f5e832bcf1885a','shares',-1,'2025-11-23 05:54:45','4ef04f31-d6fe-496c-bd09-358cf74fb9ed'),('2025-11-22 05:54:45.552051',NULL,'2025-11-22 05:54:45.561845',421,421,NULL,'f6d21398-5967-4f10-9e87-55191294310f',135,'ff09e2486e9d4c72b3f5e832bcf1885a','gigabytes',-1,'2025-11-23 05:54:45','4ef04f31-d6fe-496c-bd09-358cf74fb9ed'),('2025-11-22 05:54:47.152984',NULL,'2025-11-22 05:54:47.177559',422,422,'a118fe67fdb84bd1bef3675de0af7cc1','65148fae-2855-4e54-9884-7d689c0825ba',128,'c1bb25e73f4845c0aa83279619d6c189','shares',-1,'2025-11-23 05:54:47',NULL),('2025-11-22 05:54:47.153978',NULL,'2025-11-22 05:54:47.177559',423,423,'a118fe67fdb84bd1bef3675de0af7cc1','7469c254-b81a-491c-a191-7984b1240c18',127,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',-1,'2025-11-23 05:54:47',NULL),('2025-11-22 05:54:47.161788',NULL,'2025-11-22 05:54:47.177559',424,424,NULL,'1d4b6fb7-ffbf-4be2-8733-43e2a3207bc3',140,'c1bb25e73f4845c0aa83279619d6c189','shares',-1,'2025-11-23 05:54:47','69975aa8-2ab7-43ef-9ea3-bf3bb458d4bc'),('2025-11-22 05:54:47.163457',NULL,'2025-11-22 05:54:47.177559',425,425,NULL,'04549c49-76ed-4c8a-a4f8-a7d3717ce3a4',139,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',-1,'2025-11-23 05:54:47','69975aa8-2ab7-43ef-9ea3-bf3bb458d4bc'),('2025-11-22 05:54:47.489812',NULL,'2025-11-22 05:54:47.505368',426,426,'a118fe67fdb84bd1bef3675de0af7cc1','481a84b5-049a-4768-a866-961834572c2e',128,'c1bb25e73f4845c0aa83279619d6c189','shares',-1,'2025-11-23 05:54:47',NULL),('2025-11-22 05:54:47.490744',NULL,'2025-11-22 05:54:47.505368',427,427,'a118fe67fdb84bd1bef3675de0af7cc1','0bb8bef9-6655-4a3d-93be-637b8b44b9b3',127,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',-1,'2025-11-23 05:54:47',NULL),('2025-11-22 05:54:47.497056',NULL,'2025-11-22 05:54:47.505368',428,428,NULL,'7293ec90-5263-4b40-a7a8-2bcfd75755e8',137,'c1bb25e73f4845c0aa83279619d6c189','shares',-1,'2025-11-23 05:54:47','08c8c52d-b3da-414c-a61c-d2410111b7e1'),('2025-11-22 05:54:47.497758',NULL,'2025-11-22 05:54:47.505368',429,429,NULL,'701c8203-62c1-45b0-9ce4-e294ac7ba02e',138,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',-1,'2025-11-23 05:54:47','08c8c52d-b3da-414c-a61c-d2410111b7e1'),('2025-11-22 05:54:47.667902',NULL,'2025-11-22 05:54:47.725645',430,430,'a118fe67fdb84bd1bef3675de0af7cc1','a4bc86e5-0e9e-4016-8244-6a1a07bef88d',128,'c1bb25e73f4845c0aa83279619d6c189','shares',1,'2025-11-23 05:54:47',NULL),('2025-11-22 05:54:47.669503',NULL,'2025-11-22 05:54:47.725645',431,431,'a118fe67fdb84bd1bef3675de0af7cc1','764faca4-18ba-41ec-a6da-16f4477bcfd7',127,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',1,'2025-11-23 05:54:47',NULL),('2025-11-22 05:54:47.696052',NULL,'2025-11-22 05:54:47.725645',432,432,NULL,'fc13a0b3-5f5d-482d-8d0c-7681d5e9eb36',141,'c1bb25e73f4845c0aa83279619d6c189','shares',1,'2025-11-23 05:54:47','087a7cbd-37cd-4168-a9ba-348c6ff7993e'),('2025-11-22 05:54:47.699166',NULL,'2025-11-22 05:54:47.725645',433,433,NULL,'0f305042-649a-4d64-b6c6-75413baecd38',142,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',1,'2025-11-23 05:54:47','087a7cbd-37cd-4168-a9ba-348c6ff7993e'),('2025-11-22 05:54:48.350235',NULL,'2025-11-22 05:54:48.394413',434,434,'eb4a2a9cc4f34eed857eeb1400d6e1e8','0186f241-5fc7-472d-b7bc-90286bb788d5',144,'525ba1ccf0d546c7b4118a0855306190','shares',1,'2025-11-23 05:54:48',NULL),('2025-11-22 05:54:48.351655',NULL,'2025-11-22 05:54:48.394413',435,435,'eb4a2a9cc4f34eed857eeb1400d6e1e8','abd4eae6-806f-4ada-b570-468dd695630c',143,'525ba1ccf0d546c7b4118a0855306190','gigabytes',1,'2025-11-23 05:54:48',NULL),('2025-11-22 05:54:48.364696',NULL,'2025-11-22 05:54:48.394413',436,436,NULL,'1eead173-4c4c-4027-86d4-9f22778c31d3',146,'525ba1ccf0d546c7b4118a0855306190','shares',1,'2025-11-23 05:54:48','6aa6c955-bb1a-4082-b637-96733e409710'),('2025-11-22 05:54:48.366493',NULL,'2025-11-22 05:54:48.394413',437,437,NULL,'a3866041-c81f-4577-86d1-b200f3cf8dea',145,'525ba1ccf0d546c7b4118a0855306190','gigabytes',1,'2025-11-23 05:54:48','6aa6c955-bb1a-4082-b637-96733e409710'),('2025-11-22 05:54:51.330226',NULL,'2025-11-22 05:54:51.461820',438,438,'a118fe67fdb84bd1bef3675de0af7cc1','bce3e5b7-1cea-4594-9ae9-41e9ee56c547',128,'c1bb25e73f4845c0aa83279619d6c189','shares',1,'2025-11-23 05:54:51',NULL),('2025-11-22 05:54:51.331425',NULL,'2025-11-22 05:54:51.461820',439,439,'a118fe67fdb84bd1bef3675de0af7cc1','44f3eec8-db71-4895-b2b3-35f91565169a',127,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',1,'2025-11-23 05:54:51',NULL),('2025-11-22 05:54:51.358719',NULL,'2025-11-22 05:54:51.461820',440,440,NULL,'e1f7515f-388f-4f2a-8719-8fd7eb3fb33b',148,'c1bb25e73f4845c0aa83279619d6c189','shares',1,'2025-11-23 05:54:51','734709e5-5e22-4d51-b713-3988d1991371'),('2025-11-22 05:54:51.359967',NULL,'2025-11-22 05:54:51.461820',441,441,NULL,'46d3b21d-b5bf-4d33-a1ca-2af6cf9c3261',147,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',1,'2025-11-23 05:54:51','734709e5-5e22-4d51-b713-3988d1991371'),('2025-11-22 05:54:51.837373',NULL,'2025-11-22 05:54:52.130457',442,442,'eb4a2a9cc4f34eed857eeb1400d6e1e8','840f7214-7998-45e0-bdcb-9660c53bd9fc',144,'525ba1ccf0d546c7b4118a0855306190','shares',1,'2025-11-23 05:54:51',NULL),('2025-11-22 05:54:51.838593',NULL,'2025-11-22 05:54:52.130457',443,443,'eb4a2a9cc4f34eed857eeb1400d6e1e8','930e4595-c723-4a94-a542-af9357399fe0',143,'525ba1ccf0d546c7b4118a0855306190','gigabytes',1,'2025-11-23 05:54:51',NULL),('2025-11-22 05:54:51.953585',NULL,'2025-11-22 05:54:52.130457',444,444,NULL,'9fc5ad7d-d5c0-4eae-bdf7-f868a8399667',149,'525ba1ccf0d546c7b4118a0855306190','shares',1,'2025-11-23 05:54:51','0c00f43d-e8d6-4ce6-a0df-4c4d03c8513c'),('2025-11-22 05:54:51.956049',NULL,'2025-11-22 05:54:52.130457',445,445,NULL,'17dcd6cc-de47-4849-a08c-f0a6a725ce7b',150,'525ba1ccf0d546c7b4118a0855306190','gigabytes',1,'2025-11-23 05:54:51','0c00f43d-e8d6-4ce6-a0df-4c4d03c8513c'),('2025-11-22 05:54:55.320518',NULL,'2025-11-22 05:54:55.373861',446,446,'a118fe67fdb84bd1bef3675de0af7cc1','09f8b63a-5bf7-418d-9c24-9f7f5127de14',128,'c1bb25e73f4845c0aa83279619d6c189','shares',1,'2025-11-23 05:54:55',NULL),('2025-11-22 05:54:55.322674',NULL,'2025-11-22 05:54:55.373861',447,447,'a118fe67fdb84bd1bef3675de0af7cc1','06011395-9572-4866-9384-1e484110ef8d',127,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',1,'2025-11-23 05:54:55',NULL),('2025-11-22 05:54:55.338981',NULL,'2025-11-22 05:54:55.373861',448,448,NULL,'74afcc4a-a538-4320-a197-7c06d17b4722',152,'c1bb25e73f4845c0aa83279619d6c189','shares',1,'2025-11-23 05:54:55','56215025-9394-421b-abc0-95508b2f4030'),('2025-11-22 05:54:55.340942',NULL,'2025-11-22 05:54:55.373861',449,449,NULL,'ead61e26-afa9-412a-b697-1581d7273f6e',151,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',1,'2025-11-23 05:54:55','56215025-9394-421b-abc0-95508b2f4030'),('2025-11-22 05:54:59.016967',NULL,'2025-11-22 05:54:59.037556',450,450,'a118fe67fdb84bd1bef3675de0af7cc1','86b8648b-b23a-49ce-9dc7-b53e041fcf9a',128,'c1bb25e73f4845c0aa83279619d6c189','shares',-1,'2025-11-23 05:54:58',NULL),('2025-11-22 05:54:59.018221',NULL,'2025-11-22 05:54:59.037556',451,451,'a118fe67fdb84bd1bef3675de0af7cc1','1406e71f-97ad-4e35-b379-f09d237f4a7d',127,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',-1,'2025-11-23 05:54:58',NULL),('2025-11-22 05:54:59.026991',NULL,'2025-11-22 05:54:59.037556',452,452,NULL,'88236335-7a94-4d44-a319-e44579d24e0a',152,'c1bb25e73f4845c0aa83279619d6c189','shares',-1,'2025-11-23 05:54:58','56215025-9394-421b-abc0-95508b2f4030'),('2025-11-22 05:54:59.028071',NULL,'2025-11-22 05:54:59.037556',453,453,NULL,'72e86643-d31a-48b9-9dd2-4271169bc5f4',151,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',-1,'2025-11-23 05:54:58','56215025-9394-421b-abc0-95508b2f4030'),('2025-11-22 05:54:59.242490',NULL,'2025-11-22 05:54:59.284156',454,454,'47d35dbda65c4554a9466657dad531d9','feead9b3-8ba0-48fa-b354-657d7df197dc',154,'7c0b4b3107784ce6890ddd12d362ec8e','shares',1,'2025-11-23 05:54:59',NULL),('2025-11-22 05:54:59.244332',NULL,'2025-11-22 05:54:59.284156',455,455,'47d35dbda65c4554a9466657dad531d9','0e83b43d-1252-41d0-8099-6a5586fb1a01',153,'7c0b4b3107784ce6890ddd12d362ec8e','gigabytes',1,'2025-11-23 05:54:59',NULL),('2025-11-22 05:54:59.262686',NULL,'2025-11-22 05:54:59.284156',456,456,NULL,'c875b0c7-3e63-4de3-9502-25783568b450',156,'7c0b4b3107784ce6890ddd12d362ec8e','shares',1,'2025-11-23 05:54:59','0c00f43d-e8d6-4ce6-a0df-4c4d03c8513c'),('2025-11-22 05:54:59.263890',NULL,'2025-11-22 05:54:59.284156',457,457,NULL,'05af8981-ffe2-42a6-a2c2-59288a65cd77',155,'7c0b4b3107784ce6890ddd12d362ec8e','gigabytes',1,'2025-11-23 05:54:59','0c00f43d-e8d6-4ce6-a0df-4c4d03c8513c'),('2025-11-22 05:54:59.300744',NULL,'2025-11-22 05:54:59.321642',458,458,'a118fe67fdb84bd1bef3675de0af7cc1','11d53587-d214-47a1-a7c3-8b6f9b0bc171',128,'c1bb25e73f4845c0aa83279619d6c189','shares',-1,'2025-11-23 05:54:59',NULL),('2025-11-22 05:54:59.301725',NULL,'2025-11-22 05:54:59.321642',459,459,'a118fe67fdb84bd1bef3675de0af7cc1','ee14c6e7-53cc-4203-89af-9f5bed93ac24',127,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',-1,'2025-11-23 05:54:59',NULL),('2025-11-22 05:54:59.308728',NULL,'2025-11-22 05:54:59.321642',460,460,NULL,'45e11824-c58d-4d9f-b9a5-afe03c59c378',148,'c1bb25e73f4845c0aa83279619d6c189','shares',-1,'2025-11-23 05:54:59','734709e5-5e22-4d51-b713-3988d1991371'),('2025-11-22 05:54:59.309585',NULL,'2025-11-22 05:54:59.321642',461,461,NULL,'89e45b5b-5d4f-41bd-8d0f-6cd76cb11742',147,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',-1,'2025-11-23 05:54:59','734709e5-5e22-4d51-b713-3988d1991371'),('2025-11-22 05:54:59.544935',NULL,'2025-11-22 05:54:59.559653',462,462,'a118fe67fdb84bd1bef3675de0af7cc1','2d8b93ad-4423-4444-9778-85eeecc5d018',128,'c1bb25e73f4845c0aa83279619d6c189','shares',-1,'2025-11-23 05:54:59',NULL),('2025-11-22 05:54:59.545814',NULL,'2025-11-22 05:54:59.559653',463,463,'a118fe67fdb84bd1bef3675de0af7cc1','6c6e4e32-9706-450d-9777-f9e597249985',127,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',-1,'2025-11-23 05:54:59',NULL),('2025-11-22 05:54:59.550705',NULL,'2025-11-22 05:54:59.559653',464,464,NULL,'54e63f45-c77a-4042-be25-9859888a9d25',141,'c1bb25e73f4845c0aa83279619d6c189','shares',-1,'2025-11-23 05:54:59','087a7cbd-37cd-4168-a9ba-348c6ff7993e'),('2025-11-22 05:54:59.551435',NULL,'2025-11-22 05:54:59.559653',465,465,NULL,'af2fc4be-f6ab-49a9-bd6a-98c0ca4274fd',142,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',-1,'2025-11-23 05:54:59','087a7cbd-37cd-4168-a9ba-348c6ff7993e'),('2025-11-22 05:54:59.813532',NULL,'2025-11-22 05:54:59.853776',466,466,'a118fe67fdb84bd1bef3675de0af7cc1','ba7992db-3776-4430-b536-b0abb4df885b',128,'c1bb25e73f4845c0aa83279619d6c189','shares',1,'2025-11-23 05:54:59',NULL),('2025-11-22 05:54:59.814830',NULL,'2025-11-22 05:54:59.853776',467,467,'a118fe67fdb84bd1bef3675de0af7cc1','e19982bb-1a04-44fd-aaff-dc141e0ad01a',127,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',1,'2025-11-23 05:54:59',NULL),('2025-11-22 05:54:59.833859',NULL,'2025-11-22 05:54:59.853776',468,468,NULL,'b9c72899-9afa-4e63-bbd1-36c526aad94b',158,'c1bb25e73f4845c0aa83279619d6c189','shares',1,'2025-11-23 05:54:59','b9bcbdc8-5a4b-450b-a372-7a3b2f4ae1ab'),('2025-11-22 05:54:59.835173',NULL,'2025-11-22 05:54:59.853776',469,469,NULL,'6703a3f6-90fa-482e-af21-629592eaa7c9',157,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',1,'2025-11-23 05:54:59','b9bcbdc8-5a4b-450b-a372-7a3b2f4ae1ab'),('2025-11-22 05:55:03.295663',NULL,'2025-11-22 05:55:03.333572',470,470,'a118fe67fdb84bd1bef3675de0af7cc1','ce41bf09-989f-475f-be85-1d365fd7f231',128,'c1bb25e73f4845c0aa83279619d6c189','shares',1,'2025-11-23 05:55:03',NULL),('2025-11-22 05:55:03.299683',NULL,'2025-11-22 05:55:03.333572',471,471,'a118fe67fdb84bd1bef3675de0af7cc1','f47f4e06-1ebe-4b92-bc57-6f00557c01b2',127,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',1,'2025-11-23 05:55:03',NULL),('2025-11-22 05:55:03.310319',NULL,'2025-11-22 05:55:03.333572',472,472,NULL,'7ec80928-7806-4a42-bc76-0855ea158ad9',160,'c1bb25e73f4845c0aa83279619d6c189','shares',1,'2025-11-23 05:55:03','f359449b-fe9e-4653-86a0-8fec8f992613'),('2025-11-22 05:55:03.311553',NULL,'2025-11-22 05:55:03.333572',473,473,NULL,'fbdabc8d-c447-47fb-9117-ae1f2afa30b2',159,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',1,'2025-11-23 05:55:03','f359449b-fe9e-4653-86a0-8fec8f992613'),('2025-11-22 05:55:04.221975',NULL,'2025-11-22 05:55:04.256678',474,474,'26ca92a37d7d41e58904a26944c79e14','ea049b01-205d-4e87-9ac2-89507e896ced',161,'8b69dc8609b24a13bee8bd080785898b','shares',1,'2025-11-23 05:55:04',NULL),('2025-11-22 05:55:04.223353',NULL,'2025-11-22 05:55:04.256678',475,475,'26ca92a37d7d41e58904a26944c79e14','f5da0e19-e4c1-4de7-9f87-5db3ad1a756d',162,'8b69dc8609b24a13bee8bd080785898b','gigabytes',1,'2025-11-23 05:55:04',NULL),('2025-11-22 05:55:04.235321',NULL,'2025-11-22 05:55:04.256678',476,476,NULL,'98ed0609-4061-4e3a-ab94-89f696cbcbf6',163,'8b69dc8609b24a13bee8bd080785898b','shares',1,'2025-11-23 05:55:04','e3483182-8b2a-4128-9f1a-b73d4873cc06'),('2025-11-22 05:55:04.236432',NULL,'2025-11-22 05:55:04.256678',477,477,NULL,'5cfed728-6837-4886-bf46-4849f3d02152',164,'8b69dc8609b24a13bee8bd080785898b','gigabytes',1,'2025-11-23 05:55:04','e3483182-8b2a-4128-9f1a-b73d4873cc06'),('2025-11-22 05:55:07.033905',NULL,'2025-11-22 05:55:07.046789',478,478,'a118fe67fdb84bd1bef3675de0af7cc1','39a7b81d-6b84-49ca-a448-bb37a1f160f9',128,'c1bb25e73f4845c0aa83279619d6c189','shares',-1,'2025-11-23 05:55:07',NULL),('2025-11-22 05:55:07.034545',NULL,'2025-11-22 05:55:07.046789',479,479,'a118fe67fdb84bd1bef3675de0af7cc1','f42b6f21-414e-4176-9e52-28ba7ec3f76d',127,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',-1,'2025-11-23 05:55:07',NULL),('2025-11-22 05:55:07.040084',NULL,'2025-11-22 05:55:07.046789',480,480,NULL,'b3ef0960-79b0-4593-83a0-16defc964afc',160,'c1bb25e73f4845c0aa83279619d6c189','shares',-1,'2025-11-23 05:55:07','f359449b-fe9e-4653-86a0-8fec8f992613'),('2025-11-22 05:55:07.040631',NULL,'2025-11-22 05:55:07.046789',481,481,NULL,'6ecd6ea8-a635-484f-aed1-ae6843f8f04c',159,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',-1,'2025-11-23 05:55:07','f359449b-fe9e-4653-86a0-8fec8f992613'),('2025-11-22 05:55:07.233814',NULL,'2025-11-22 05:55:07.245504',482,482,'a118fe67fdb84bd1bef3675de0af7cc1','6fc82309-245c-408f-bc3b-c219540b69be',128,'c1bb25e73f4845c0aa83279619d6c189','shares',-1,'2025-11-23 05:55:07',NULL),('2025-11-22 05:55:07.234533',NULL,'2025-11-22 05:55:07.245504',483,483,'a118fe67fdb84bd1bef3675de0af7cc1','1f836133-dbc8-4362-96c9-861cf3b4aef9',127,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',-1,'2025-11-23 05:55:07',NULL),('2025-11-22 05:55:07.238796',NULL,'2025-11-22 05:55:07.245504',484,484,NULL,'4156aeca-f633-4fdd-8bd4-5e596aca1245',158,'c1bb25e73f4845c0aa83279619d6c189','shares',-1,'2025-11-23 05:55:07','b9bcbdc8-5a4b-450b-a372-7a3b2f4ae1ab'),('2025-11-22 05:55:07.239358',NULL,'2025-11-22 05:55:07.245504',485,485,NULL,'7bf7a380-323b-40eb-a9f0-781d063c6dfb',157,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',-1,'2025-11-23 05:55:07','b9bcbdc8-5a4b-450b-a372-7a3b2f4ae1ab'),('2025-11-22 05:55:07.430169',NULL,'2025-11-22 05:55:07.474695',486,486,'a118fe67fdb84bd1bef3675de0af7cc1','135f2257-363a-4803-acb3-ccb49d67f87f',128,'c1bb25e73f4845c0aa83279619d6c189','shares',1,'2025-11-23 05:55:07',NULL),('2025-11-22 05:55:07.431899',NULL,'2025-11-22 05:55:07.474695',487,487,'a118fe67fdb84bd1bef3675de0af7cc1','ea2fbdd1-8812-4250-a9cb-28d04585bfa2',127,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',1,'2025-11-23 05:55:07',NULL),('2025-11-22 05:55:07.445942',NULL,'2025-11-22 05:55:07.474695',488,488,NULL,'f638aadb-74c7-4cf0-a788-269abcf301f5',166,'c1bb25e73f4845c0aa83279619d6c189','shares',1,'2025-11-23 05:55:07','96afc477-3877-4b27-b4cf-f6aaa221d409'),('2025-11-22 05:55:07.448231',NULL,'2025-11-22 05:55:07.474695',489,489,NULL,'7b1943b8-df8f-492e-8567-491458b710e8',165,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',1,'2025-11-23 05:55:07','96afc477-3877-4b27-b4cf-f6aaa221d409'),('2025-11-22 05:55:09.363824',NULL,'2025-11-22 05:55:09.386174',490,490,'26ca92a37d7d41e58904a26944c79e14','a6ee93d5-f60b-4350-9013-0c6d7256af70',161,'8b69dc8609b24a13bee8bd080785898b','shares',-1,'2025-11-23 05:55:09',NULL),('2025-11-22 05:55:09.364738',NULL,'2025-11-22 05:55:09.386174',491,491,'26ca92a37d7d41e58904a26944c79e14','d2215c67-9c6a-4b79-a8f7-3a4172cf22e4',162,'8b69dc8609b24a13bee8bd080785898b','gigabytes',-1,'2025-11-23 05:55:09',NULL),('2025-11-22 05:55:09.374500',NULL,'2025-11-22 05:55:09.386174',492,492,NULL,'91ca0487-b381-4007-b2ac-a797eb577e53',163,'8b69dc8609b24a13bee8bd080785898b','shares',-1,'2025-11-23 05:55:09','e3483182-8b2a-4128-9f1a-b73d4873cc06'),('2025-11-22 05:55:09.375676',NULL,'2025-11-22 05:55:09.386174',493,493,NULL,'2ab1bef4-a522-4bc5-a806-3a743a15a194',164,'8b69dc8609b24a13bee8bd080785898b','gigabytes',-1,'2025-11-23 05:55:09','e3483182-8b2a-4128-9f1a-b73d4873cc06'),('2025-11-22 05:55:11.091611',NULL,'2025-11-22 05:55:11.108469',494,494,'a118fe67fdb84bd1bef3675de0af7cc1','2503506e-b374-4005-a4df-de4ea94728be',128,'c1bb25e73f4845c0aa83279619d6c189','shares',-1,'2025-11-23 05:55:11',NULL),('2025-11-22 05:55:11.092334',NULL,'2025-11-22 05:55:11.108469',495,495,'a118fe67fdb84bd1bef3675de0af7cc1','81380fe2-c1e9-4dfa-9cab-7ddd4127d252',127,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',-1,'2025-11-23 05:55:11',NULL),('2025-11-22 05:55:11.098216',NULL,'2025-11-22 05:55:11.108469',496,496,NULL,'378fde39-c7e9-4827-95d0-3e473d5733d7',166,'c1bb25e73f4845c0aa83279619d6c189','shares',-1,'2025-11-23 05:55:11','96afc477-3877-4b27-b4cf-f6aaa221d409'),('2025-11-22 05:55:11.098990',NULL,'2025-11-22 05:55:11.108469',497,497,NULL,'7d4a6397-d80a-43e0-bc00-1b094f32351c',165,'c1bb25e73f4845c0aa83279619d6c189','gigabytes',-1,'2025-11-23 05:55:11','96afc477-3877-4b27-b4cf-f6aaa221d409'),('2025-11-22 05:55:27.642408',NULL,'2025-11-22 05:55:27.711385',498,498,'02fe04fccffb4086a89160251945aedb','59e5b4e1-13d6-480c-a727-1bdbd5bd0251',167,'3109e70846824a5ea61dce09df700861','share_networks',1,'2025-11-23 05:55:27',NULL),('2025-11-22 05:55:27.863389',NULL,'2025-11-22 05:55:27.942056',499,499,'02fe04fccffb4086a89160251945aedb','fa224469-7ef3-4017-a2fd-c9e376aa4f5d',167,'3109e70846824a5ea61dce09df700861','share_networks',1,'2025-11-23 05:55:27',NULL),('2025-11-22 05:55:28.100980',NULL,'2025-11-22 05:55:28.143885',500,500,'47d35dbda65c4554a9466657dad531d9','3f2d546b-98ce-4f41-83e8-fb07d3c9228e',154,'7c0b4b3107784ce6890ddd12d362ec8e','shares',1,'2025-11-23 05:55:28',NULL),('2025-11-22 05:55:28.103782',NULL,'2025-11-22 05:55:28.143885',501,501,'47d35dbda65c4554a9466657dad531d9','b39f3470-fac0-4017-b601-1b470e2f6cb6',153,'7c0b4b3107784ce6890ddd12d362ec8e','gigabytes',1,'2025-11-23 05:55:28',NULL),('2025-11-22 05:55:28.115970',NULL,'2025-11-22 05:55:28.143885',502,502,NULL,'6a7b8d2d-ec2a-4811-9796-652bbeda9504',169,'7c0b4b3107784ce6890ddd12d362ec8e','shares',1,'2025-11-23 05:55:28','6aa6c955-bb1a-4082-b637-96733e409710'),('2025-11-22 05:55:28.117166',NULL,'2025-11-22 05:55:28.143885',503,503,NULL,'ba00c402-704a-4e0d-85a2-acce86904ce9',168,'7c0b4b3107784ce6890ddd12d362ec8e','gigabytes',1,'2025-11-23 05:55:28','6aa6c955-bb1a-4082-b637-96733e409710'),('2025-11-22 05:55:28.555081',NULL,'2025-11-22 05:55:28.560655',504,504,'02fe04fccffb4086a89160251945aedb','d83da850-d59a-4446-a38d-54d9f394d1a3',167,'3109e70846824a5ea61dce09df700861','share_networks',-1,'2025-11-23 05:55:28',NULL),('2025-11-22 05:55:28.694886',NULL,'2025-11-22 05:55:28.718717',505,505,'02fe04fccffb4086a89160251945aedb','7d3e3a43-5425-410f-95d9-119c5f6dbdf1',167,'3109e70846824a5ea61dce09df700861','share_networks',1,'2025-11-23 05:55:28',NULL),('2025-11-22 05:55:29.501157',NULL,'2025-11-22 05:55:29.507999',506,506,'02fe04fccffb4086a89160251945aedb','b6d2f350-86b2-4180-85b1-2c20673402e9',167,'3109e70846824a5ea61dce09df700861','share_networks',-1,'2025-11-23 05:55:29',NULL),('2025-11-22 05:55:40.643097',NULL,'2025-11-22 05:55:40.668538',507,507,'2458340257d941d6b2d0260e7d70dfe3','343668ea-c004-4ad9-a707-bfcc9a0a0b7f',170,'531b9bbdeb2447818ecd6f5fccb66a8a','share_networks',1,'2025-11-23 05:55:40',NULL),('2025-11-22 05:55:41.005730',NULL,'2025-11-22 05:55:41.012373',508,508,'2458340257d941d6b2d0260e7d70dfe3','a993b915-813b-45c8-80a4-5b84c7121694',170,'531b9bbdeb2447818ecd6f5fccb66a8a','share_networks',-1,'2025-11-23 05:55:40',NULL),('2025-11-22 05:55:41.301757',NULL,'2025-11-22 05:55:41.336211',509,509,'2458340257d941d6b2d0260e7d70dfe3','d3a17957-e324-41c7-8c70-1fe4046465be',170,'531b9bbdeb2447818ecd6f5fccb66a8a','share_networks',1,'2025-11-23 05:55:41',NULL),('2025-11-22 05:55:42.068954',NULL,'2025-11-22 05:55:42.074614',510,510,'2458340257d941d6b2d0260e7d70dfe3','f4596924-2341-4eb8-a158-0ecbd8d50391',170,'531b9bbdeb2447818ecd6f5fccb66a8a','share_networks',-1,'2025-11-23 05:55:42',NULL),('2025-11-22 05:55:42.637948',NULL,'2025-11-22 05:55:42.669666',511,511,'2458340257d941d6b2d0260e7d70dfe3','f76ddf67-1cc3-43bd-b5ee-7fd75b12e37f',170,'531b9bbdeb2447818ecd6f5fccb66a8a','share_networks',1,'2025-11-23 05:55:42',NULL),('2025-11-22 05:55:42.838049',NULL,'2025-11-22 05:55:42.844644',512,512,'2458340257d941d6b2d0260e7d70dfe3','33a88f18-b3bd-48dd-9c12-bdb231c7fcc4',170,'531b9bbdeb2447818ecd6f5fccb66a8a','share_networks',-1,'2025-11-23 05:55:42',NULL),('2025-11-22 05:55:43.802779',NULL,'2025-11-22 05:55:43.831048',513,513,'47d35dbda65c4554a9466657dad531d9','1ecea7d6-15d5-4401-afba-4c6912b48ace',154,'7c0b4b3107784ce6890ddd12d362ec8e','shares',-1,'2025-11-23 05:55:43',NULL),('2025-11-22 05:55:43.805590',NULL,'2025-11-22 05:55:43.831048',514,514,'47d35dbda65c4554a9466657dad531d9','6af2cc35-bb9c-4959-909e-e326d7ba7bad',153,'7c0b4b3107784ce6890ddd12d362ec8e','gigabytes',-1,'2025-11-23 05:55:43',NULL),('2025-11-22 05:55:43.817347',NULL,'2025-11-22 05:55:43.831048',515,515,NULL,'84ab11ef-c3cd-432b-8e1d-c882974e0a34',169,'7c0b4b3107784ce6890ddd12d362ec8e','shares',-1,'2025-11-23 05:55:43','6aa6c955-bb1a-4082-b637-96733e409710'),('2025-11-22 05:55:43.819213',NULL,'2025-11-22 05:55:43.831048',516,516,NULL,'32bdee87-2684-443b-b415-180d6f0fcb5b',168,'7c0b4b3107784ce6890ddd12d362ec8e','gigabytes',-1,'2025-11-23 05:55:43','6aa6c955-bb1a-4082-b637-96733e409710'),('2025-11-22 05:55:47.370683',NULL,'2025-11-22 05:55:47.433665',517,517,'955dc5c233b943d9982d1ee82cd2f0de','a1e39060-1c03-4d87-b963-c233c078bf43',171,'b65ccd7e2f5f4f95959c8fb179b60b78','share_networks',1,'2025-11-23 05:55:47',NULL),('2025-11-22 05:55:47.521376',NULL,'2025-11-22 05:55:47.537956',518,518,'47d35dbda65c4554a9466657dad531d9','1f65018c-2ac5-44e6-9b24-30ccf645d420',154,'7c0b4b3107784ce6890ddd12d362ec8e','shares',-1,'2025-11-23 05:55:47',NULL),('2025-11-22 05:55:47.522080',NULL,'2025-11-22 05:55:47.537956',519,519,'47d35dbda65c4554a9466657dad531d9','f8d4a0fd-60c7-4a0c-9b19-19dccf0851a7',153,'7c0b4b3107784ce6890ddd12d362ec8e','gigabytes',-1,'2025-11-23 05:55:47',NULL),('2025-11-22 05:55:47.529649',NULL,'2025-11-22 05:55:47.537956',520,520,NULL,'d04415af-86c9-4c38-8a36-c7ddb871c051',156,'7c0b4b3107784ce6890ddd12d362ec8e','shares',-1,'2025-11-23 05:55:47','0c00f43d-e8d6-4ce6-a0df-4c4d03c8513c'),('2025-11-22 05:55:47.530363',NULL,'2025-11-22 05:55:47.537956',521,521,NULL,'df34dbf4-dc98-4ab8-9b5b-099e47d06a3c',155,'7c0b4b3107784ce6890ddd12d362ec8e','gigabytes',-1,'2025-11-23 05:55:47','0c00f43d-e8d6-4ce6-a0df-4c4d03c8513c'),('2025-11-22 05:55:48.776859',NULL,'2025-11-22 05:55:48.822290',522,522,'955dc5c233b943d9982d1ee82cd2f0de','8d55814b-fdd8-4155-8fcd-bff1e5cea3e3',171,'b65ccd7e2f5f4f95959c8fb179b60b78','share_networks',1,'2025-11-23 05:55:48',NULL),('2025-11-22 05:55:49.952575',NULL,'2025-11-22 05:55:49.960147',523,523,'955dc5c233b943d9982d1ee82cd2f0de','fafdd480-1f3e-4a06-8b88-4918b0d7e7cd',171,'b65ccd7e2f5f4f95959c8fb179b60b78','share_networks',-1,'2025-11-23 05:55:49',NULL),('2025-11-22 05:55:50.126675',NULL,'2025-11-22 05:55:50.169248',524,524,'955dc5c233b943d9982d1ee82cd2f0de','a45de1c7-6cf1-48f4-8a6e-64be1b652eaa',171,'b65ccd7e2f5f4f95959c8fb179b60b78','share_networks',1,'2025-11-23 05:55:50',NULL),('2025-11-22 05:55:50.815307',NULL,'2025-11-22 05:55:50.822339',525,525,'955dc5c233b943d9982d1ee82cd2f0de','24f838ba-291d-456c-8a97-ac81071a63ac',171,'b65ccd7e2f5f4f95959c8fb179b60b78','share_networks',-1,'2025-11-23 05:55:50',NULL),('2025-11-22 05:55:50.993881',NULL,'2025-11-22 05:55:51.013216',526,526,'eb4a2a9cc4f34eed857eeb1400d6e1e8','562772bb-d13d-407f-bcff-2b871d0039b0',144,'525ba1ccf0d546c7b4118a0855306190','shares',-1,'2025-11-23 05:55:50',NULL),('2025-11-22 05:55:50.994561',NULL,'2025-11-22 05:55:51.013216',527,527,'eb4a2a9cc4f34eed857eeb1400d6e1e8','ae02df2c-cde3-45c9-805b-f2c50b32af5f',143,'525ba1ccf0d546c7b4118a0855306190','gigabytes',-1,'2025-11-23 05:55:50',NULL),('2025-11-22 05:55:51.002204',NULL,'2025-11-22 05:55:51.013216',528,528,NULL,'195ce8fc-ea45-43db-95a7-dbfb37db77c8',149,'525ba1ccf0d546c7b4118a0855306190','shares',-1,'2025-11-23 05:55:50','0c00f43d-e8d6-4ce6-a0df-4c4d03c8513c'),('2025-11-22 05:55:51.003424',NULL,'2025-11-22 05:55:51.013216',529,529,NULL,'5b92c6a4-9afa-4f08-8e76-a9cffa7a24fc',150,'525ba1ccf0d546c7b4118a0855306190','gigabytes',-1,'2025-11-23 05:55:50','0c00f43d-e8d6-4ce6-a0df-4c4d03c8513c'),('2025-11-22 05:55:51.699880',NULL,'2025-11-22 05:55:51.709279',530,530,'955dc5c233b943d9982d1ee82cd2f0de','0e51f465-835d-4b18-b6f2-c26ca19bcc73',171,'b65ccd7e2f5f4f95959c8fb179b60b78','share_networks',-1,'2025-11-23 05:55:51',NULL),('2025-11-22 05:55:52.659338',NULL,'2025-11-22 05:55:52.692722',531,531,'ea75f7805c74403093c0bd716bebcc3e','d0a05b6f-b200-40bd-b5a6-bde42c3d0209',172,'94bcd246264e4a03b75056b04f28dee8','shares',1,'2025-11-23 05:55:52',NULL),('2025-11-22 05:55:52.660643',NULL,'2025-11-22 05:55:52.692722',532,532,'ea75f7805c74403093c0bd716bebcc3e','0695bd97-952f-48de-a594-4a90ce7c8ce0',173,'94bcd246264e4a03b75056b04f28dee8','gigabytes',1,'2025-11-23 05:55:52',NULL),('2025-11-22 05:55:52.667043',NULL,'2025-11-22 05:55:52.692722',533,533,NULL,'53858095-d0ea-4ece-96cc-94635efdba71',88,'94bcd246264e4a03b75056b04f28dee8','shares',1,'2025-11-23 05:55:52','3f5f10b5-5a29-4a2e-a4a9-9c80d7a9b422'),('2025-11-22 05:55:52.668607',NULL,'2025-11-22 05:55:52.692722',534,534,NULL,'ec794a35-52cc-4d89-be08-10d72327f98f',87,'94bcd246264e4a03b75056b04f28dee8','gigabytes',1,'2025-11-23 05:55:52','3f5f10b5-5a29-4a2e-a4a9-9c80d7a9b422'),('2025-11-22 05:55:54.833977',NULL,'2025-11-22 05:55:54.853380',535,535,'eb4a2a9cc4f34eed857eeb1400d6e1e8','3ba660b8-8ac8-4a9b-8e2a-c6c8b914d539',144,'525ba1ccf0d546c7b4118a0855306190','shares',-1,'2025-11-23 05:55:54',NULL),('2025-11-22 05:55:54.834932',NULL,'2025-11-22 05:55:54.853380',536,536,'eb4a2a9cc4f34eed857eeb1400d6e1e8','4e4f53b0-7d4c-4c35-9752-fe59228fd3a0',143,'525ba1ccf0d546c7b4118a0855306190','gigabytes',-1,'2025-11-23 05:55:54',NULL),('2025-11-22 05:55:54.842471',NULL,'2025-11-22 05:55:54.853380',537,537,NULL,'008a35d9-5d8d-45dd-91d3-3fca8a7b1611',146,'525ba1ccf0d546c7b4118a0855306190','shares',-1,'2025-11-23 05:55:54','6aa6c955-bb1a-4082-b637-96733e409710'),('2025-11-22 05:55:54.843801',NULL,'2025-11-22 05:55:54.853380',538,538,NULL,'e0a61cf3-9df1-4039-b988-4beb11768a8f',145,'525ba1ccf0d546c7b4118a0855306190','gigabytes',-1,'2025-11-23 05:55:54','6aa6c955-bb1a-4082-b637-96733e409710'),('2025-11-22 05:56:12.380673',NULL,'2025-11-22 05:56:12.476435',539,539,'9088ff75a27c420ca8f0a42460400887','bd300e48-ada2-49e7-9369-bc2e439ac7d2',86,'94bcd246264e4a03b75056b04f28dee8','shares',-1,'2025-11-23 05:56:12',NULL),('2025-11-22 05:56:12.387551',NULL,'2025-11-22 05:56:12.476435',540,540,'9088ff75a27c420ca8f0a42460400887','1306d912-f6f5-479d-8efc-292a6feaaf4d',85,'94bcd246264e4a03b75056b04f28dee8','gigabytes',-1,'2025-11-23 05:56:12',NULL),('2025-11-22 05:56:12.440785',NULL,'2025-11-22 05:56:12.476435',541,541,NULL,'f3e77db6-2fd1-4278-9671-5b5c5ba9616e',88,'94bcd246264e4a03b75056b04f28dee8','shares',-1,'2025-11-23 05:56:12','3f5f10b5-5a29-4a2e-a4a9-9c80d7a9b422'),('2025-11-22 05:56:12.442111',NULL,'2025-11-22 05:56:12.476435',542,542,NULL,'76cb6c35-baf4-4790-bae1-e70ef6cf4ab1',87,'94bcd246264e4a03b75056b04f28dee8','gigabytes',-1,'2025-11-23 05:56:12','3f5f10b5-5a29-4a2e-a4a9-9c80d7a9b422'),('2025-11-22 05:56:14.621641',NULL,'2025-11-22 05:56:14.806013',543,543,'4d4e495e2af243dba0ae1d8c430fed71','153d48b6-a685-4288-b138-2324841482f4',174,'3520b2bd18fe4bc198c9b3ae61849514','share_networks',1,'2025-11-23 05:56:14',NULL),('2025-11-22 05:56:15.626523',NULL,'2025-11-22 05:56:15.705822',544,544,'4d4e495e2af243dba0ae1d8c430fed71','4ed7a56f-5e84-4a7c-a0cb-4529342c1568',174,'3520b2bd18fe4bc198c9b3ae61849514','share_networks',1,'2025-11-23 05:56:15',NULL),('2025-11-22 05:56:16.123998',NULL,'2025-11-22 05:56:16.183546',545,545,'4d4e495e2af243dba0ae1d8c430fed71','9f5f76c8-cd42-46a1-8a38-9eff14524593',174,'3520b2bd18fe4bc198c9b3ae61849514','share_networks',1,'2025-11-23 05:56:16',NULL),('2025-11-22 05:56:16.599704',NULL,'2025-11-22 05:56:16.608967',546,546,'4d4e495e2af243dba0ae1d8c430fed71','bff97116-dcdc-45db-ad55-dd66a1c32870',174,'3520b2bd18fe4bc198c9b3ae61849514','share_networks',-1,'2025-11-23 05:56:16',NULL),('2025-11-22 05:56:16.956368',NULL,'2025-11-22 05:56:16.987191',547,547,'4d4e495e2af243dba0ae1d8c430fed71','081644c8-6e9a-4704-a381-a30b175e8224',174,'3520b2bd18fe4bc198c9b3ae61849514','share_networks',1,'2025-11-23 05:56:16',NULL),('2025-11-22 05:56:17.109705',NULL,'2025-11-22 05:56:17.141756',548,548,'4d4e495e2af243dba0ae1d8c430fed71','132e506e-0724-4d1b-a5a8-0154ff3be8ba',174,'3520b2bd18fe4bc198c9b3ae61849514','share_networks',1,'2025-11-23 05:56:17',NULL),('2025-11-22 05:56:17.318611',NULL,'2025-11-22 05:56:17.323555',549,549,'4d4e495e2af243dba0ae1d8c430fed71','14f85d27-0547-4cde-b28e-1dbff395483b',174,'3520b2bd18fe4bc198c9b3ae61849514','share_networks',-1,'2025-11-23 05:56:17',NULL),('2025-11-22 05:56:17.852465',NULL,'2025-11-22 05:56:17.860165',550,550,'4d4e495e2af243dba0ae1d8c430fed71','2cffae2f-cf7f-44f0-87d4-10cb64b5d815',174,'3520b2bd18fe4bc198c9b3ae61849514','share_networks',-1,'2025-11-23 05:56:17',NULL),('2025-11-22 05:56:19.001183',NULL,'2025-11-22 05:56:19.040859',551,551,'4d4e495e2af243dba0ae1d8c430fed71','d650e8a9-6448-4a9f-a8e4-4b87774a32ee',174,'3520b2bd18fe4bc198c9b3ae61849514','share_networks',1,'2025-11-23 05:56:18',NULL),('2025-11-22 05:56:19.192935',NULL,'2025-11-22 05:56:19.197916',552,552,'4d4e495e2af243dba0ae1d8c430fed71','b5987bff-161b-4d36-9fd8-356f7af1255c',174,'3520b2bd18fe4bc198c9b3ae61849514','share_networks',-1,'2025-11-23 05:56:19',NULL),('2025-11-22 05:56:19.553159',NULL,'2025-11-22 05:56:19.583696',553,553,'4d4e495e2af243dba0ae1d8c430fed71','ffc889f5-d45d-4a73-935c-beeee9fd16f5',174,'3520b2bd18fe4bc198c9b3ae61849514','share_networks',1,'2025-11-23 05:56:19',NULL),('2025-11-22 05:56:19.958301',NULL,'2025-11-22 05:56:19.964091',554,554,'4d4e495e2af243dba0ae1d8c430fed71','076b3c59-1e20-4188-acea-7f0290f899bf',174,'3520b2bd18fe4bc198c9b3ae61849514','share_networks',-1,'2025-11-23 05:56:19',NULL),('2025-11-22 05:56:22.193643',NULL,'2025-11-22 05:56:22.200516',555,555,'4d4e495e2af243dba0ae1d8c430fed71','9a00e660-e4f8-4dff-a65b-0c5db9e7dc13',174,'3520b2bd18fe4bc198c9b3ae61849514','share_networks',-1,'2025-11-23 05:56:22',NULL),('2025-11-22 05:56:22.557651',NULL,'2025-11-22 05:56:22.563946',556,556,'4d4e495e2af243dba0ae1d8c430fed71','1f7b5093-a182-4d0b-9a19-4c0ea98c6dfc',174,'3520b2bd18fe4bc198c9b3ae61849514','share_networks',-1,'2025-11-23 05:56:22',NULL),('2025-11-22 05:56:25.986974',NULL,'2025-11-22 05:56:26.074779',557,557,'58186e0ac2da4d539ba489a92270cb59','77d6c93e-b50e-4719-9c1d-a32755f54708',176,'db75a1944ad845ea9c7d9708d52f1e25','shares',1,'2025-11-23 05:56:25',NULL),('2025-11-22 05:56:25.991965',NULL,'2025-11-22 05:56:26.074779',558,558,'58186e0ac2da4d539ba489a92270cb59','93a26c6e-329c-4371-9686-0de37f4b459f',175,'db75a1944ad845ea9c7d9708d52f1e25','gigabytes',1,'2025-11-23 05:56:25',NULL),('2025-11-22 05:56:26.010382',NULL,'2025-11-22 05:56:26.074779',559,559,NULL,'52c12f29-7e8c-4920-8af7-7e1b525ae85f',178,'db75a1944ad845ea9c7d9708d52f1e25','shares',1,'2025-11-23 05:56:25','bc6cfada-cc8c-44a7-8599-cc459a4ac116'),('2025-11-22 05:56:26.011829',NULL,'2025-11-22 05:56:26.074779',560,560,NULL,'f148f770-af29-4acd-8eca-00d34a1727a3',177,'db75a1944ad845ea9c7d9708d52f1e25','gigabytes',1,'2025-11-23 05:56:25','bc6cfada-cc8c-44a7-8599-cc459a4ac116'),('2025-11-22 05:56:31.057852',NULL,'2025-11-22 05:56:31.106773',561,561,'da7e1014c61944d2888458963ee6ce85','4a674f2f-6770-4824-a7c6-e322aceb5310',179,'e901221ae3e949c0a2f21b3f827f2f92','share_networks',1,'2025-11-23 05:56:31',NULL),('2025-11-22 05:56:31.878973',NULL,'2025-11-22 05:56:31.931637',562,562,'58186e0ac2da4d539ba489a92270cb59','95d123ab-1f88-42da-8ded-acd717dc42e9',176,'db75a1944ad845ea9c7d9708d52f1e25','shares',1,'2025-11-23 05:56:31',NULL),('2025-11-22 05:56:31.880094',NULL,'2025-11-22 05:56:31.931637',563,563,'58186e0ac2da4d539ba489a92270cb59','a1c7830a-3910-4182-9e6f-ba8b4690b3ab',175,'db75a1944ad845ea9c7d9708d52f1e25','gigabytes',1,'2025-11-23 05:56:31',NULL),('2025-11-22 05:56:31.891542',NULL,'2025-11-22 05:56:31.931637',564,564,NULL,'5793582a-c5ac-43b6-8ab9-b044ec48ea41',178,'db75a1944ad845ea9c7d9708d52f1e25','shares',1,'2025-11-23 05:56:31','bc6cfada-cc8c-44a7-8599-cc459a4ac116'),('2025-11-22 05:56:31.892607',NULL,'2025-11-22 05:56:31.931637',565,565,NULL,'1f0fffb4-98fb-4e49-bb4d-55cbe923f193',177,'db75a1944ad845ea9c7d9708d52f1e25','gigabytes',1,'2025-11-23 05:56:31','bc6cfada-cc8c-44a7-8599-cc459a4ac116'),('2025-11-22 05:56:34.131752',NULL,'2025-11-22 05:56:34.173119',566,566,'ff11a55c494c4d8587c6435d27704abd','e7cf3606-51d1-47ca-b8b3-5616fdefd2c9',181,'faf3355c8660499394277773bc5931cb','shares',1,'2025-11-23 05:56:34',NULL),('2025-11-22 05:56:34.133106',NULL,'2025-11-22 05:56:34.173119',567,567,'ff11a55c494c4d8587c6435d27704abd','2adfa3fa-17ec-457e-81ff-c3c597714279',180,'faf3355c8660499394277773bc5931cb','gigabytes',1,'2025-11-23 05:56:34',NULL),('2025-11-22 05:56:34.146972',NULL,'2025-11-22 05:56:34.173119',568,568,NULL,'45aed7e4-4b66-469a-b34d-13ab68169e4a',183,'faf3355c8660499394277773bc5931cb','shares',1,'2025-11-23 05:56:34','64c44c63-ca32-44df-83e7-0d5ad0ba1c02'),('2025-11-22 05:56:34.148668',NULL,'2025-11-22 05:56:34.173119',569,569,NULL,'d3ecab8f-8442-4995-8d2f-fcaadeeae8fd',182,'faf3355c8660499394277773bc5931cb','gigabytes',1,'2025-11-23 05:56:34','64c44c63-ca32-44df-83e7-0d5ad0ba1c02'),('2025-11-22 05:56:38.196335',NULL,'2025-11-22 05:56:38.381003',570,570,'4f5c8a8f5caa48388ab293352413b72b','6f4ca422-3f5c-496a-b1bd-18d4d816bb64',185,'0cb5c96c52bc4e89961346306e373479','shares',1,'2025-11-23 05:56:38',NULL),('2025-11-22 05:56:38.197830',NULL,'2025-11-22 05:56:38.381003',571,571,'4f5c8a8f5caa48388ab293352413b72b','bd14afaf-64e4-4665-8ed3-5df1f2d7d516',184,'0cb5c96c52bc4e89961346306e373479','gigabytes',1,'2025-11-23 05:56:38',NULL),('2025-11-22 05:56:38.230109',NULL,'2025-11-22 05:56:38.389313',572,572,'4f5c8a8f5caa48388ab293352413b72b','e24643c5-876a-4051-8f0f-f38a92e5f6f5',187,'faf3355c8660499394277773bc5931cb','shares',-1,'2025-11-23 05:56:38',NULL),('2025-11-22 05:56:38.231030',NULL,'2025-11-22 05:56:38.389313',573,573,'4f5c8a8f5caa48388ab293352413b72b','4f8a7a32-2f60-4ebf-a160-c299f75c8c92',186,'faf3355c8660499394277773bc5931cb','gigabytes',-1,'2025-11-23 05:56:38',NULL),('2025-11-22 05:56:39.195138',NULL,'2025-11-22 05:56:39.224485',574,574,'4f5c8a8f5caa48388ab293352413b72b','54903885-7c3f-4532-bf58-c40a0ed88489',185,'0cb5c96c52bc4e89961346306e373479','shares',-1,'2025-11-23 05:56:39',NULL),('2025-11-22 05:56:39.196015',NULL,'2025-11-22 05:56:39.224485',575,575,'4f5c8a8f5caa48388ab293352413b72b','9fe2f8a4-b067-4362-b5b8-b75bd01ee793',184,'0cb5c96c52bc4e89961346306e373479','gigabytes',-1,'2025-11-23 05:56:39',NULL),('2025-11-22 05:56:39.213812',NULL,'2025-11-22 05:56:39.224485',576,576,NULL,'6cbd3ed2-366f-48aa-93b2-999b7edaceb9',189,'0cb5c96c52bc4e89961346306e373479','shares',-1,'2025-11-23 05:56:39','64c44c63-ca32-44df-83e7-0d5ad0ba1c02'),('2025-11-22 05:56:39.214786',NULL,'2025-11-22 05:56:39.224485',577,577,NULL,'c37702e3-0e1f-42de-958b-2f5f27265021',188,'0cb5c96c52bc4e89961346306e373479','gigabytes',-1,'2025-11-23 05:56:39','64c44c63-ca32-44df-83e7-0d5ad0ba1c02'),('2025-11-22 05:56:39.747890',NULL,'2025-11-22 05:56:39.777856',578,578,'58186e0ac2da4d539ba489a92270cb59','186c172b-7ef9-486a-9653-68b128afa9d8',176,'db75a1944ad845ea9c7d9708d52f1e25','shares',-1,'2025-11-23 05:56:39',NULL),('2025-11-22 05:56:39.749424',NULL,'2025-11-22 05:56:39.777856',579,579,'58186e0ac2da4d539ba489a92270cb59','c0b871bd-2a75-40b2-9db7-e63ef5d58bb4',175,'db75a1944ad845ea9c7d9708d52f1e25','gigabytes',-1,'2025-11-23 05:56:39',NULL),('2025-11-22 05:56:39.759971',NULL,'2025-11-22 05:56:39.777856',580,580,NULL,'93a4930f-bc56-4fc7-9802-a10be5689c75',178,'db75a1944ad845ea9c7d9708d52f1e25','shares',-1,'2025-11-23 05:56:39','bc6cfada-cc8c-44a7-8599-cc459a4ac116'),('2025-11-22 05:56:39.761524',NULL,'2025-11-22 05:56:39.777856',581,581,NULL,'6603ea26-e8b8-4eec-8568-0786ec8bf722',177,'db75a1944ad845ea9c7d9708d52f1e25','gigabytes',-1,'2025-11-23 05:56:39','bc6cfada-cc8c-44a7-8599-cc459a4ac116'),('2025-11-22 05:56:42.478479',NULL,'2025-11-22 05:56:42.515089',582,582,'ff11a55c494c4d8587c6435d27704abd','f4d3daee-c1c3-4a5b-9af0-e402789b3942',181,'faf3355c8660499394277773bc5931cb','shares',1,'2025-11-23 05:56:42',NULL),('2025-11-22 05:56:42.479851',NULL,'2025-11-22 05:56:42.515089',583,583,'ff11a55c494c4d8587c6435d27704abd','04e6d1ec-4560-457e-90f6-1e6c3d0ac895',180,'faf3355c8660499394277773bc5931cb','gigabytes',1,'2025-11-23 05:56:42',NULL),('2025-11-22 05:56:42.487756',NULL,'2025-11-22 05:56:42.515089',584,584,NULL,'83b4258f-7b35-4d88-b954-d98f2d483db9',183,'faf3355c8660499394277773bc5931cb','shares',1,'2025-11-23 05:56:42','64c44c63-ca32-44df-83e7-0d5ad0ba1c02'),('2025-11-22 05:56:42.489003',NULL,'2025-11-22 05:56:42.515089',585,585,NULL,'5f907c68-c843-4ebf-9b2e-3128d497f877',182,'faf3355c8660499394277773bc5931cb','gigabytes',1,'2025-11-23 05:56:42','64c44c63-ca32-44df-83e7-0d5ad0ba1c02'),('2025-11-22 05:56:42.590140',NULL,'2025-11-22 05:56:42.627135',586,586,'58186e0ac2da4d539ba489a92270cb59','5b1b0bc2-cadc-45fb-8549-2433e53c25d5',176,'db75a1944ad845ea9c7d9708d52f1e25','shares',1,'2025-11-23 05:56:42',NULL),('2025-11-22 05:56:42.591329',NULL,'2025-11-22 05:56:42.627135',587,587,'58186e0ac2da4d539ba489a92270cb59','29d69022-f0ac-41f7-ace2-7bdaed8c41b6',175,'db75a1944ad845ea9c7d9708d52f1e25','gigabytes',1,'2025-11-23 05:56:42',NULL),('2025-11-22 05:56:42.596775',NULL,'2025-11-22 05:56:42.627135',588,588,NULL,'4df1679f-8146-4a7f-8a2c-fa1802611a5e',178,'db75a1944ad845ea9c7d9708d52f1e25','shares',1,'2025-11-23 05:56:42','bc6cfada-cc8c-44a7-8599-cc459a4ac116'),('2025-11-22 05:56:42.597786',NULL,'2025-11-22 05:56:42.627135',589,589,NULL,'612315f2-6b4e-4221-8b4e-e1140d6b38db',177,'db75a1944ad845ea9c7d9708d52f1e25','gigabytes',1,'2025-11-23 05:56:42','bc6cfada-cc8c-44a7-8599-cc459a4ac116'),('2025-11-22 05:56:45.279439',NULL,'2025-11-22 05:56:45.324541',590,590,'c2522b58eb254cf58002dcb519ab137d','419f61e3-c00d-4203-9cc1-8bf2c84d3ff7',191,'f0fc42a3cd4a4e75942e7132887f268d','shares',1,'2025-11-23 05:56:45',NULL),('2025-11-22 05:56:45.280645',NULL,'2025-11-22 05:56:45.324541',591,591,'c2522b58eb254cf58002dcb519ab137d','a5b18eab-acfe-4c43-a800-03b67de2a58a',190,'f0fc42a3cd4a4e75942e7132887f268d','gigabytes',1,'2025-11-23 05:56:45',NULL),('2025-11-22 05:56:45.290441',NULL,'2025-11-22 05:56:45.324541',592,592,NULL,'5cba5b88-b931-4913-b9ea-ebc4aeec0f10',193,'f0fc42a3cd4a4e75942e7132887f268d','shares',1,'2025-11-23 05:56:45','5426bf6e-b197-4c02-be68-82ee99c5c64e'),('2025-11-22 05:56:45.291656',NULL,'2025-11-22 05:56:45.324541',593,593,NULL,'99c23fe8-78f3-4812-bd98-bbe3a4ea3e4d',192,'f0fc42a3cd4a4e75942e7132887f268d','gigabytes',1,'2025-11-23 05:56:45','5426bf6e-b197-4c02-be68-82ee99c5c64e'),('2025-11-22 05:56:47.111598',NULL,'2025-11-22 05:56:47.145343',594,594,'ff11a55c494c4d8587c6435d27704abd','7530d8c1-7830-4c9c-8c56-84c70dc8b83f',181,'faf3355c8660499394277773bc5931cb','shares',-1,'2025-11-23 05:56:47',NULL),('2025-11-22 05:56:47.113446',NULL,'2025-11-22 05:56:47.145343',595,595,'ff11a55c494c4d8587c6435d27704abd','bd810610-b687-4c05-b58e-0d8fd4829aa4',180,'faf3355c8660499394277773bc5931cb','gigabytes',-1,'2025-11-23 05:56:47',NULL),('2025-11-22 05:56:47.126197',NULL,'2025-11-22 05:56:47.145343',596,596,NULL,'b2d27a9a-0d6d-4f09-8ed4-7e8773c200ff',183,'faf3355c8660499394277773bc5931cb','shares',-1,'2025-11-23 05:56:47','64c44c63-ca32-44df-83e7-0d5ad0ba1c02'),('2025-11-22 05:56:47.132545',NULL,'2025-11-22 05:56:47.145343',597,597,NULL,'9da8bbc4-3f60-41cf-bb2c-0f28d7dd00ef',182,'faf3355c8660499394277773bc5931cb','gigabytes',-1,'2025-11-23 05:56:47','64c44c63-ca32-44df-83e7-0d5ad0ba1c02'),('2025-11-22 05:56:48.800459',NULL,'2025-11-22 05:56:48.834040',598,598,'c2522b58eb254cf58002dcb519ab137d','1c2d2082-40de-484d-84da-bcadee568631',191,'f0fc42a3cd4a4e75942e7132887f268d','shares',1,'2025-11-23 05:56:48',NULL),('2025-11-22 05:56:48.801991',NULL,'2025-11-22 05:56:48.834040',599,599,'c2522b58eb254cf58002dcb519ab137d','8c5aa5a1-5ced-4206-a06a-589452ee84ef',190,'f0fc42a3cd4a4e75942e7132887f268d','gigabytes',1,'2025-11-23 05:56:48',NULL),('2025-11-22 05:56:48.810278',NULL,'2025-11-22 05:56:48.834040',600,600,NULL,'659d63f2-e84a-4f17-8d0e-6b59f23dabd7',193,'f0fc42a3cd4a4e75942e7132887f268d','shares',1,'2025-11-23 05:56:48','5426bf6e-b197-4c02-be68-82ee99c5c64e'),('2025-11-22 05:56:48.812005',NULL,'2025-11-22 05:56:48.834040',601,601,NULL,'b9a81dbb-0869-451a-8233-c4d51b977269',192,'f0fc42a3cd4a4e75942e7132887f268d','gigabytes',1,'2025-11-23 05:56:48','5426bf6e-b197-4c02-be68-82ee99c5c64e'),('2025-11-22 05:56:50.507788',NULL,'2025-11-22 05:56:50.525397',602,602,'58186e0ac2da4d539ba489a92270cb59','8350bb4e-7b97-4f57-8f35-652d56e8b89e',176,'db75a1944ad845ea9c7d9708d52f1e25','shares',-1,'2025-11-23 05:56:50',NULL),('2025-11-22 05:56:50.508742',NULL,'2025-11-22 05:56:50.525397',603,603,'58186e0ac2da4d539ba489a92270cb59','057dd536-ffc5-4371-9671-3dcabca451a0',175,'db75a1944ad845ea9c7d9708d52f1e25','gigabytes',-1,'2025-11-23 05:56:50',NULL),('2025-11-22 05:56:50.517213',NULL,'2025-11-22 05:56:50.525397',604,604,NULL,'c1e3d39f-1950-49ac-b15e-3a41bf57f10c',178,'db75a1944ad845ea9c7d9708d52f1e25','shares',-1,'2025-11-23 05:56:50','bc6cfada-cc8c-44a7-8599-cc459a4ac116'),('2025-11-22 05:56:50.517983',NULL,'2025-11-22 05:56:50.525397',605,605,NULL,'98dc03af-4780-44c5-a6b3-0aadc3f8e446',177,'db75a1944ad845ea9c7d9708d52f1e25','gigabytes',-1,'2025-11-23 05:56:50','bc6cfada-cc8c-44a7-8599-cc459a4ac116'),('2025-11-22 05:56:52.775272',NULL,'2025-11-22 05:56:52.801186',606,606,'c2522b58eb254cf58002dcb519ab137d','14405d6b-8a70-42f9-a661-d5f1daa63b71',191,'f0fc42a3cd4a4e75942e7132887f268d','shares',-1,'2025-11-23 05:56:52',NULL),('2025-11-22 05:56:52.776145',NULL,'2025-11-22 05:56:52.801186',607,607,'c2522b58eb254cf58002dcb519ab137d','7786eed0-a0b5-474d-b9d5-4d06325e65e0',190,'f0fc42a3cd4a4e75942e7132887f268d','gigabytes',-1,'2025-11-23 05:56:52',NULL),('2025-11-22 05:56:52.782006',NULL,'2025-11-22 05:56:52.801186',608,608,NULL,'36c7da35-6728-4e63-9fd3-3fe779ab4f61',193,'f0fc42a3cd4a4e75942e7132887f268d','shares',-1,'2025-11-23 05:56:52','5426bf6e-b197-4c02-be68-82ee99c5c64e'),('2025-11-22 05:56:52.782698',NULL,'2025-11-22 05:56:52.801186',609,609,NULL,'b526053f-500c-406b-94fb-85f309bf6f75',192,'f0fc42a3cd4a4e75942e7132887f268d','gigabytes',-1,'2025-11-23 05:56:52','5426bf6e-b197-4c02-be68-82ee99c5c64e'),('2025-11-22 05:56:53.374435',NULL,'2025-11-22 05:56:53.438576',610,610,'58186e0ac2da4d539ba489a92270cb59','4d7005bc-6b94-4d7b-a978-6c8c34d4df93',176,'db75a1944ad845ea9c7d9708d52f1e25','shares',1,'2025-11-23 05:56:53',NULL),('2025-11-22 05:56:53.382096',NULL,'2025-11-22 05:56:53.438576',611,611,'58186e0ac2da4d539ba489a92270cb59','b14e1da3-0d04-4d1b-a373-0dc59dc0b134',175,'db75a1944ad845ea9c7d9708d52f1e25','gigabytes',1,'2025-11-23 05:56:53',NULL),('2025-11-22 05:56:53.396018',NULL,'2025-11-22 05:56:53.438576',612,612,NULL,'f332e5f3-204c-4b82-9718-fac6a2fc8da5',178,'db75a1944ad845ea9c7d9708d52f1e25','shares',1,'2025-11-23 05:56:53','bc6cfada-cc8c-44a7-8599-cc459a4ac116'),('2025-11-22 05:56:53.399015',NULL,'2025-11-22 05:56:53.438576',613,613,NULL,'804bb6d2-0dc5-4904-b0cc-9f0e6484ee60',177,'db75a1944ad845ea9c7d9708d52f1e25','gigabytes',1,'2025-11-23 05:56:53','bc6cfada-cc8c-44a7-8599-cc459a4ac116'),('2025-11-22 05:56:56.210804',NULL,'2025-11-22 05:56:56.225444',614,614,'c2522b58eb254cf58002dcb519ab137d','803d5d55-b2e1-4cf5-8315-69bc3e705090',191,'f0fc42a3cd4a4e75942e7132887f268d','shares',-1,'2025-11-23 05:56:56',NULL),('2025-11-22 05:56:56.211816',NULL,'2025-11-22 05:56:56.225444',615,615,'c2522b58eb254cf58002dcb519ab137d','5261611b-b71d-4a8b-b9e2-761455d4813b',190,'f0fc42a3cd4a4e75942e7132887f268d','gigabytes',-1,'2025-11-23 05:56:56',NULL),('2025-11-22 05:56:56.217982',NULL,'2025-11-22 05:56:56.225444',616,616,NULL,'c8c753db-d4ae-49cf-b60a-36acdbc58f11',193,'f0fc42a3cd4a4e75942e7132887f268d','shares',-1,'2025-11-23 05:56:56','5426bf6e-b197-4c02-be68-82ee99c5c64e'),('2025-11-22 05:56:56.218959',NULL,'2025-11-22 05:56:56.225444',617,617,NULL,'49eaeb8f-4591-4dfd-91d1-6908f50ee594',192,'f0fc42a3cd4a4e75942e7132887f268d','gigabytes',-1,'2025-11-23 05:56:56','5426bf6e-b197-4c02-be68-82ee99c5c64e'),('2025-11-22 05:56:59.819116',NULL,'2025-11-22 05:56:59.867708',618,618,'c2522b58eb254cf58002dcb519ab137d','6cbc7e86-1ff7-4654-9c84-19c4b1452ae3',194,'f0fc42a3cd4a4e75942e7132887f268d','share_groups',1,'2025-11-23 05:56:59',NULL),('2025-11-22 05:57:00.288954',NULL,'2025-11-22 05:57:00.298711',619,619,'c2522b58eb254cf58002dcb519ab137d','15c7bd35-877b-46f7-910e-746f9a7ef232',194,'f0fc42a3cd4a4e75942e7132887f268d','share_groups',-1,'2025-11-23 05:57:00',NULL),('2025-11-22 05:57:00.620736',NULL,'2025-11-22 05:57:00.641876',620,620,'c2522b58eb254cf58002dcb519ab137d','976dcf83-e62d-43b9-aa73-7d3a554571d5',194,'f0fc42a3cd4a4e75942e7132887f268d','share_groups',1,'2025-11-23 05:57:00',NULL),('2025-11-22 05:57:01.019237',NULL,'2025-11-22 05:57:01.052369',621,621,'57c41b494bbf4fa981ed6b0fa212fa71','4a0a10eb-7f6a-49b4-ab89-c988279cdf2b',196,'3ecbc36cc7f84bac8557dd18782914fa','shares',1,'2025-11-23 05:57:00',NULL),('2025-11-22 05:57:01.020234',NULL,'2025-11-22 05:57:01.052369',622,622,'57c41b494bbf4fa981ed6b0fa212fa71','c4fae1aa-cdd6-42da-9e74-c1c07504a0c6',195,'3ecbc36cc7f84bac8557dd18782914fa','gigabytes',1,'2025-11-23 05:57:00',NULL),('2025-11-22 05:57:01.031375',NULL,'2025-11-22 05:57:01.052369',623,623,NULL,'ea8daebc-d1f3-4640-9cfd-94286f16aaaa',198,'3ecbc36cc7f84bac8557dd18782914fa','shares',1,'2025-11-23 05:57:00','33ab82b2-9d13-455f-b64f-cb0f7247c292'),('2025-11-22 05:57:01.032405',NULL,'2025-11-22 05:57:01.052369',624,624,NULL,'f02c3bb0-af38-43c5-a056-56f7bd442747',197,'3ecbc36cc7f84bac8557dd18782914fa','gigabytes',1,'2025-11-23 05:57:00','33ab82b2-9d13-455f-b64f-cb0f7247c292'),('2025-11-22 05:57:01.041904',NULL,'2025-11-22 05:57:01.055868',625,625,'c2522b58eb254cf58002dcb519ab137d','c7d7b49e-d7c1-4df0-acb4-5aef738afcda',194,'f0fc42a3cd4a4e75942e7132887f268d','share_groups',-1,'2025-11-23 05:57:01',NULL),('2025-11-22 05:57:01.422051',NULL,'2025-11-22 05:57:01.436624',626,626,'58186e0ac2da4d539ba489a92270cb59','2a471867-b464-49a7-bd38-3bc2a777d347',176,'db75a1944ad845ea9c7d9708d52f1e25','shares',-1,'2025-11-23 05:57:01',NULL),('2025-11-22 05:57:01.422719',NULL,'2025-11-22 05:57:01.436624',627,627,'58186e0ac2da4d539ba489a92270cb59','c8767fc3-0cd3-4bbe-a07c-c522ff2bb399',175,'db75a1944ad845ea9c7d9708d52f1e25','gigabytes',-1,'2025-11-23 05:57:01',NULL),('2025-11-22 05:57:01.427891',NULL,'2025-11-22 05:57:01.436624',628,628,NULL,'5bfb9abc-1fda-43e8-95c2-b9b960fca707',178,'db75a1944ad845ea9c7d9708d52f1e25','shares',-1,'2025-11-23 05:57:01','bc6cfada-cc8c-44a7-8599-cc459a4ac116'),('2025-11-22 05:57:01.428724',NULL,'2025-11-22 05:57:01.436624',629,629,NULL,'7180853f-6314-405f-8f03-9965c24e8f3f',177,'db75a1944ad845ea9c7d9708d52f1e25','gigabytes',-1,'2025-11-23 05:57:01','bc6cfada-cc8c-44a7-8599-cc459a4ac116'),('2025-11-22 05:57:04.558846',NULL,'2025-11-22 05:57:04.595110',630,630,'c2522b58eb254cf58002dcb519ab137d','7e2218b2-e811-46c6-80b4-cf01d8ee86b2',191,'f0fc42a3cd4a4e75942e7132887f268d','shares',1,'2025-11-23 05:57:04',NULL),('2025-11-22 05:57:04.561018',NULL,'2025-11-22 05:57:04.595110',631,631,'c2522b58eb254cf58002dcb519ab137d','6667a969-bf7d-4e27-8216-73f99fa3e1fa',190,'f0fc42a3cd4a4e75942e7132887f268d','gigabytes',1,'2025-11-23 05:57:04',NULL),('2025-11-22 05:57:04.571490',NULL,'2025-11-22 05:57:04.595110',632,632,NULL,'821cab49-4173-40c1-ba02-af4d3e74c086',193,'f0fc42a3cd4a4e75942e7132887f268d','shares',1,'2025-11-23 05:57:04','5426bf6e-b197-4c02-be68-82ee99c5c64e'),('2025-11-22 05:57:04.574024',NULL,'2025-11-22 05:57:04.595110',633,633,NULL,'06f4a232-56c9-468a-b567-09677ba4e39b',192,'f0fc42a3cd4a4e75942e7132887f268d','gigabytes',1,'2025-11-23 05:57:04','5426bf6e-b197-4c02-be68-82ee99c5c64e'),('2025-11-22 05:57:05.179726',NULL,'2025-11-22 05:57:05.218185',634,634,'57c41b494bbf4fa981ed6b0fa212fa71','8a6846a2-8593-41c6-bdaf-1fd7caa63b2d',196,'3ecbc36cc7f84bac8557dd18782914fa','shares',1,'2025-11-23 05:57:05',NULL),('2025-11-22 05:57:05.181071',NULL,'2025-11-22 05:57:05.218185',635,635,'57c41b494bbf4fa981ed6b0fa212fa71','a465d403-c5e3-4577-8497-aa085dc298b7',195,'3ecbc36cc7f84bac8557dd18782914fa','gigabytes',1,'2025-11-23 05:57:05',NULL),('2025-11-22 05:57:05.193749',NULL,'2025-11-22 05:57:05.218185',636,636,NULL,'0758cc47-69f4-4248-80c7-61344c8a38d2',198,'3ecbc36cc7f84bac8557dd18782914fa','shares',1,'2025-11-23 05:57:05','33ab82b2-9d13-455f-b64f-cb0f7247c292'),('2025-11-22 05:57:05.194996',NULL,'2025-11-22 05:57:05.218185',637,637,NULL,'ddf8c509-0322-46a1-ae6b-309dc3e7fc11',197,'3ecbc36cc7f84bac8557dd18782914fa','gigabytes',1,'2025-11-23 05:57:05','33ab82b2-9d13-455f-b64f-cb0f7247c292'),('2025-11-22 05:57:08.563071',NULL,'2025-11-22 05:57:08.583994',638,638,'c2522b58eb254cf58002dcb519ab137d','43c92f07-016c-4bd5-9704-4df6ba46b65a',191,'f0fc42a3cd4a4e75942e7132887f268d','shares',-1,'2025-11-23 05:57:08',NULL),('2025-11-22 05:57:08.564052',NULL,'2025-11-22 05:57:08.583994',639,639,'c2522b58eb254cf58002dcb519ab137d','877bd1d1-faf9-430f-b7ea-6e917b6d666f',190,'f0fc42a3cd4a4e75942e7132887f268d','gigabytes',-1,'2025-11-23 05:57:08',NULL),('2025-11-22 05:57:08.573486',NULL,'2025-11-22 05:57:08.583994',640,640,NULL,'fcedc775-7500-4f9b-a783-12af60a417ba',193,'f0fc42a3cd4a4e75942e7132887f268d','shares',-1,'2025-11-23 05:57:08','5426bf6e-b197-4c02-be68-82ee99c5c64e'),('2025-11-22 05:57:08.574660',NULL,'2025-11-22 05:57:08.583994',641,641,NULL,'0a33264a-51e4-4906-ba6b-e8d79d7686e4',192,'f0fc42a3cd4a4e75942e7132887f268d','gigabytes',-1,'2025-11-23 05:57:08','5426bf6e-b197-4c02-be68-82ee99c5c64e'),('2025-11-22 05:57:09.049988',NULL,'2025-11-22 05:57:09.101058',642,642,'57c41b494bbf4fa981ed6b0fa212fa71','5e5e12ad-9bd1-4133-b35c-2c395f28b3db',196,'3ecbc36cc7f84bac8557dd18782914fa','shares',1,'2025-11-23 05:57:09',NULL),('2025-11-22 05:57:09.051724',NULL,'2025-11-22 05:57:09.101058',643,643,'57c41b494bbf4fa981ed6b0fa212fa71','c106f10e-c3f2-4602-90dc-939ebec80bf9',195,'3ecbc36cc7f84bac8557dd18782914fa','gigabytes',1,'2025-11-23 05:57:09',NULL),('2025-11-22 05:57:09.083217',NULL,'2025-11-22 05:57:09.101058',644,644,NULL,'5c71ab4e-e34b-46c6-a064-753a31b697e1',198,'3ecbc36cc7f84bac8557dd18782914fa','shares',1,'2025-11-23 05:57:09','33ab82b2-9d13-455f-b64f-cb0f7247c292'),('2025-11-22 05:57:09.084360',NULL,'2025-11-22 05:57:09.101058',645,645,NULL,'500f91d5-7655-4954-8085-1e07e735dffe',197,'3ecbc36cc7f84bac8557dd18782914fa','gigabytes',1,'2025-11-23 05:57:09','33ab82b2-9d13-455f-b64f-cb0f7247c292'),('2025-11-22 05:57:11.737821',NULL,'2025-11-22 05:57:11.764447',646,646,'c2522b58eb254cf58002dcb519ab137d','56e82ca8-3993-425b-91d5-dae85d7ed731',191,'f0fc42a3cd4a4e75942e7132887f268d','shares',1,'2025-11-23 05:57:11',NULL),('2025-11-22 05:57:11.739028',NULL,'2025-11-22 05:57:11.764447',647,647,'c2522b58eb254cf58002dcb519ab137d','ae082ded-5432-4ebd-ba1c-fc02cd0b894e',190,'f0fc42a3cd4a4e75942e7132887f268d','gigabytes',1,'2025-11-23 05:57:11',NULL),('2025-11-22 05:57:11.744417',NULL,'2025-11-22 05:57:11.764447',648,648,NULL,'39e28464-8aa6-401a-922a-cbd42e5eeb39',193,'f0fc42a3cd4a4e75942e7132887f268d','shares',1,'2025-11-23 05:57:11','5426bf6e-b197-4c02-be68-82ee99c5c64e'),('2025-11-22 05:57:11.745543',NULL,'2025-11-22 05:57:11.764447',649,649,NULL,'7df27d7b-5e86-4227-9a6e-0983069ec8eb',192,'f0fc42a3cd4a4e75942e7132887f268d','gigabytes',1,'2025-11-23 05:57:11','5426bf6e-b197-4c02-be68-82ee99c5c64e'),('2025-11-22 05:57:13.187915',NULL,'2025-11-22 05:57:13.225875',650,650,'57c41b494bbf4fa981ed6b0fa212fa71','915320ac-35aa-4e25-99de-35df3b5a4eab',196,'3ecbc36cc7f84bac8557dd18782914fa','shares',1,'2025-11-23 05:57:13',NULL),('2025-11-22 05:57:13.189483',NULL,'2025-11-22 05:57:13.225875',651,651,'57c41b494bbf4fa981ed6b0fa212fa71','4a278e73-a993-446d-aae7-10ded6ca4a7e',195,'3ecbc36cc7f84bac8557dd18782914fa','gigabytes',1,'2025-11-23 05:57:13',NULL),('2025-11-22 05:57:13.200886',NULL,'2025-11-22 05:57:13.225875',652,652,NULL,'2e886284-07a2-40e1-a18f-582a98aae5c5',198,'3ecbc36cc7f84bac8557dd18782914fa','shares',1,'2025-11-23 05:57:13','33ab82b2-9d13-455f-b64f-cb0f7247c292'),('2025-11-22 05:57:13.202070',NULL,'2025-11-22 05:57:13.225875',653,653,NULL,'f2d88ab7-bf2c-4039-a0b7-55d5e61f778e',197,'3ecbc36cc7f84bac8557dd18782914fa','gigabytes',1,'2025-11-23 05:57:13','33ab82b2-9d13-455f-b64f-cb0f7247c292'),('2025-11-22 05:57:15.607898',NULL,'2025-11-22 05:57:15.623695',654,654,'c2522b58eb254cf58002dcb519ab137d','43d166e0-7185-46d7-9037-a72fdd87f183',191,'f0fc42a3cd4a4e75942e7132887f268d','shares',-1,'2025-11-23 05:57:15',NULL),('2025-11-22 05:57:15.608745',NULL,'2025-11-22 05:57:15.623695',655,655,'c2522b58eb254cf58002dcb519ab137d','b3e27d7a-83bd-4cc5-9e78-33d90eff34da',190,'f0fc42a3cd4a4e75942e7132887f268d','gigabytes',-1,'2025-11-23 05:57:15',NULL),('2025-11-22 05:57:15.616857',NULL,'2025-11-22 05:57:15.623695',656,656,NULL,'da52bec1-c5fd-44b6-9986-fbe7a7cfb3fe',193,'f0fc42a3cd4a4e75942e7132887f268d','shares',-1,'2025-11-23 05:57:15','5426bf6e-b197-4c02-be68-82ee99c5c64e'),('2025-11-22 05:57:15.617448',NULL,'2025-11-22 05:57:15.623695',657,657,NULL,'25bd86a9-5c5b-40d0-b179-4fa1b312abe7',192,'f0fc42a3cd4a4e75942e7132887f268d','gigabytes',-1,'2025-11-23 05:57:15','5426bf6e-b197-4c02-be68-82ee99c5c64e'),('2025-11-22 05:57:18.201665',NULL,'2025-11-22 05:57:18.219250',658,658,'57c41b494bbf4fa981ed6b0fa212fa71','ee124599-6433-4bd0-b99b-45f37d5fecbc',196,'3ecbc36cc7f84bac8557dd18782914fa','shares',-1,'2025-11-23 05:57:18',NULL),('2025-11-22 05:57:18.202653',NULL,'2025-11-22 05:57:18.219250',659,659,'57c41b494bbf4fa981ed6b0fa212fa71','1f04fcdc-78af-47be-9e7f-47fa340c3dc8',195,'3ecbc36cc7f84bac8557dd18782914fa','gigabytes',-1,'2025-11-23 05:57:18',NULL),('2025-11-22 05:57:18.210640',NULL,'2025-11-22 05:57:18.219250',660,660,NULL,'3991742e-691e-4fc2-91dc-286495763094',198,'3ecbc36cc7f84bac8557dd18782914fa','shares',-1,'2025-11-23 05:57:18','33ab82b2-9d13-455f-b64f-cb0f7247c292'),('2025-11-22 05:57:18.211452',NULL,'2025-11-22 05:57:18.219250',661,661,NULL,'d22befff-1bd6-48c9-9f8b-e4de212fa9fc',197,'3ecbc36cc7f84bac8557dd18782914fa','gigabytes',-1,'2025-11-23 05:57:18','33ab82b2-9d13-455f-b64f-cb0f7247c292'),('2025-11-22 05:57:21.855543',NULL,'2025-11-22 05:57:21.876936',662,662,'57c41b494bbf4fa981ed6b0fa212fa71','55e4cc04-425b-48b6-acf8-d918915750e7',196,'3ecbc36cc7f84bac8557dd18782914fa','shares',-1,'2025-11-23 05:57:21',NULL),('2025-11-22 05:57:21.857402',NULL,'2025-11-22 05:57:21.876936',663,663,'57c41b494bbf4fa981ed6b0fa212fa71','d0574df7-351b-41bb-9690-42ffa9282726',195,'3ecbc36cc7f84bac8557dd18782914fa','gigabytes',-1,'2025-11-23 05:57:21',NULL),('2025-11-22 05:57:21.864075',NULL,'2025-11-22 05:57:21.876936',664,664,NULL,'03845ce1-b04d-4efe-be41-dff4cac54288',198,'3ecbc36cc7f84bac8557dd18782914fa','shares',-1,'2025-11-23 05:57:21','33ab82b2-9d13-455f-b64f-cb0f7247c292'),('2025-11-22 05:57:21.867144',NULL,'2025-11-22 05:57:21.876936',665,665,NULL,'63905bc4-4944-4220-9e30-c92513b34ab8',197,'3ecbc36cc7f84bac8557dd18782914fa','gigabytes',-1,'2025-11-23 05:57:21','33ab82b2-9d13-455f-b64f-cb0f7247c292'),('2025-11-22 05:57:25.663041',NULL,'2025-11-22 05:57:25.697293',666,666,'57c41b494bbf4fa981ed6b0fa212fa71','16f8b2b2-97ce-4b25-a0b0-027ae8460df6',196,'3ecbc36cc7f84bac8557dd18782914fa','shares',-1,'2025-11-23 05:57:25',NULL),('2025-11-22 05:57:25.664989',NULL,'2025-11-22 05:57:25.697293',667,667,'57c41b494bbf4fa981ed6b0fa212fa71','5c827064-4ae0-4902-b6e9-7b6a4fedeb4e',195,'3ecbc36cc7f84bac8557dd18782914fa','gigabytes',-1,'2025-11-23 05:57:25',NULL),('2025-11-22 05:57:25.680646',NULL,'2025-11-22 05:57:25.697293',668,668,NULL,'d61b843c-121b-42c6-b5b9-4b0ece339761',198,'3ecbc36cc7f84bac8557dd18782914fa','shares',-1,'2025-11-23 05:57:25','33ab82b2-9d13-455f-b64f-cb0f7247c292'),('2025-11-22 05:57:25.682091',NULL,'2025-11-22 05:57:25.697293',669,669,NULL,'0cf6487a-b9a2-4d69-b583-ec3237b826f1',197,'3ecbc36cc7f84bac8557dd18782914fa','gigabytes',-1,'2025-11-23 05:57:25','33ab82b2-9d13-455f-b64f-cb0f7247c292'),('2025-11-22 05:57:27.943039',NULL,'2025-11-22 05:57:28.068113',670,670,'c85f7bcc3e4d40d2bc0e6a37832e885d','8a7b8ca6-15e4-4e6e-90c0-d64b140b6584',200,'8179302d26964c999cd5f9a55ba9d33b','shares',1,'2025-11-23 05:57:27',NULL),('2025-11-22 05:57:27.944720',NULL,'2025-11-22 05:57:28.068113',671,671,'c85f7bcc3e4d40d2bc0e6a37832e885d','4157604b-5505-41b4-8613-9d09eaf4df36',199,'8179302d26964c999cd5f9a55ba9d33b','gigabytes',1,'2025-11-23 05:57:27',NULL),('2025-11-22 05:57:27.988691',NULL,'2025-11-22 05:57:28.068113',672,672,NULL,'bb83fa19-40be-4d9b-a462-e3b0b2864df4',202,'8179302d26964c999cd5f9a55ba9d33b','shares',1,'2025-11-23 05:57:27','2b6505d8-6c33-411c-9b84-112503c4c108'),('2025-11-22 05:57:27.989941',NULL,'2025-11-22 05:57:28.068113',673,673,NULL,'53941ad6-1dea-4211-bc86-f50bb726c4a3',201,'8179302d26964c999cd5f9a55ba9d33b','gigabytes',1,'2025-11-23 05:57:27','2b6505d8-6c33-411c-9b84-112503c4c108'),('2025-11-22 05:57:29.229624',NULL,'2025-11-22 05:57:29.242273',674,674,'57c41b494bbf4fa981ed6b0fa212fa71','9297b752-2c5a-4675-ba61-eea5b4f7e0c3',196,'3ecbc36cc7f84bac8557dd18782914fa','shares',-1,'2025-11-23 05:57:29',NULL),('2025-11-22 05:57:29.230454',NULL,'2025-11-22 05:57:29.242273',675,675,'57c41b494bbf4fa981ed6b0fa212fa71','ca65626a-cbdb-4d77-b689-93b954c5a25e',195,'3ecbc36cc7f84bac8557dd18782914fa','gigabytes',-1,'2025-11-23 05:57:29',NULL),('2025-11-22 05:57:29.235214',NULL,'2025-11-22 05:57:29.242273',676,676,NULL,'6f9abcc4-6711-4bcb-b6df-40b6ef19926a',198,'3ecbc36cc7f84bac8557dd18782914fa','shares',-1,'2025-11-23 05:57:29','33ab82b2-9d13-455f-b64f-cb0f7247c292'),('2025-11-22 05:57:29.235917',NULL,'2025-11-22 05:57:29.242273',677,677,NULL,'adb878a9-b66b-4cf5-b15a-f2d3537bf0ce',197,'3ecbc36cc7f84bac8557dd18782914fa','gigabytes',-1,'2025-11-23 05:57:29','33ab82b2-9d13-455f-b64f-cb0f7247c292'),('2025-11-22 05:57:31.607493',NULL,'2025-11-22 05:57:31.703734',678,678,'c85f7bcc3e4d40d2bc0e6a37832e885d','a3385d9b-77ee-4546-aa95-da59898db177',203,'8179302d26964c999cd5f9a55ba9d33b','snapshots',1,'2025-11-23 05:57:31',NULL),('2025-11-22 05:57:31.608779',NULL,'2025-11-22 05:57:31.703734',679,679,'c85f7bcc3e4d40d2bc0e6a37832e885d','330cb0e1-ece5-4721-8e29-4a93e775f0b0',204,'8179302d26964c999cd5f9a55ba9d33b','snapshot_gigabytes',1,'2025-11-23 05:57:31',NULL),('2025-11-22 05:57:31.621800',NULL,'2025-11-22 05:57:31.703734',680,680,NULL,'7bf96211-faf7-4f09-8472-cd11b699a388',205,'8179302d26964c999cd5f9a55ba9d33b','snapshots',1,'2025-11-23 05:57:31','2b6505d8-6c33-411c-9b84-112503c4c108'),('2025-11-22 05:57:31.623094',NULL,'2025-11-22 05:57:31.703734',681,681,NULL,'389b8de3-11a7-4e77-a1ed-4307c81d2585',206,'8179302d26964c999cd5f9a55ba9d33b','snapshot_gigabytes',1,'2025-11-23 05:57:31','2b6505d8-6c33-411c-9b84-112503c4c108'),('2025-11-22 05:57:34.531880',NULL,'2025-11-22 05:57:34.561498',682,682,'58186e0ac2da4d539ba489a92270cb59','4f582c71-c215-4dc2-ad82-2a077eda29e2',176,'db75a1944ad845ea9c7d9708d52f1e25','shares',-1,'2025-11-23 05:57:34',NULL),('2025-11-22 05:57:34.533527',NULL,'2025-11-22 05:57:34.561498',683,683,'58186e0ac2da4d539ba489a92270cb59','3a43759e-d131-4b65-8581-f2afea6a01f9',175,'db75a1944ad845ea9c7d9708d52f1e25','gigabytes',-1,'2025-11-23 05:57:34',NULL),('2025-11-22 05:57:34.543633',NULL,'2025-11-22 05:57:34.561498',684,684,NULL,'6c4e30e6-5950-4b6b-ada2-9537f2de3923',178,'db75a1944ad845ea9c7d9708d52f1e25','shares',-1,'2025-11-23 05:57:34','bc6cfada-cc8c-44a7-8599-cc459a4ac116'),('2025-11-22 05:57:34.545819',NULL,'2025-11-22 05:57:34.561498',685,685,NULL,'b4267242-2527-4a12-ac0b-61e8f890178d',177,'db75a1944ad845ea9c7d9708d52f1e25','gigabytes',-1,'2025-11-23 05:57:34','bc6cfada-cc8c-44a7-8599-cc459a4ac116'),('2025-11-22 05:57:35.572668',NULL,'2025-11-22 05:57:35.592027',686,686,'c85f7bcc3e4d40d2bc0e6a37832e885d','9e29511f-5fbb-4155-9f72-ee683c3c5a75',203,'8179302d26964c999cd5f9a55ba9d33b','snapshots',-1,'2025-11-23 05:57:35',NULL),('2025-11-22 05:57:35.573690',NULL,'2025-11-22 05:57:35.592027',687,687,'c85f7bcc3e4d40d2bc0e6a37832e885d','5832a277-b554-4155-8c41-922c093575af',204,'8179302d26964c999cd5f9a55ba9d33b','snapshot_gigabytes',-1,'2025-11-23 05:57:35',NULL),('2025-11-22 05:57:35.582721',NULL,'2025-11-22 05:57:35.592027',688,688,NULL,'e7073dbc-c64e-4895-9647-4132d20b39fb',205,'8179302d26964c999cd5f9a55ba9d33b','snapshots',-1,'2025-11-23 05:57:35','2b6505d8-6c33-411c-9b84-112503c4c108'),('2025-11-22 05:57:35.583636',NULL,'2025-11-22 05:57:35.592027',689,689,NULL,'d02c67f3-e2bd-47a1-b756-653dc065a54a',206,'8179302d26964c999cd5f9a55ba9d33b','snapshot_gigabytes',-1,'2025-11-23 05:57:35','2b6505d8-6c33-411c-9b84-112503c4c108'),('2025-11-22 05:57:39.125235',NULL,'2025-11-22 05:57:39.144669',690,690,'c85f7bcc3e4d40d2bc0e6a37832e885d','e913fd39-ed4c-416b-bb61-20eeafe970cb',200,'8179302d26964c999cd5f9a55ba9d33b','shares',-1,'2025-11-23 05:57:39',NULL),('2025-11-22 05:57:39.126749',NULL,'2025-11-22 05:57:39.144669',691,691,'c85f7bcc3e4d40d2bc0e6a37832e885d','6f0c480d-0a0b-4b70-a58d-d1f5b7043744',199,'8179302d26964c999cd5f9a55ba9d33b','gigabytes',-1,'2025-11-23 05:57:39',NULL),('2025-11-22 05:57:39.130992',NULL,'2025-11-22 05:57:39.144669',692,692,NULL,'49406b2b-3800-47f8-8cd3-e682551bf0ac',202,'8179302d26964c999cd5f9a55ba9d33b','shares',-1,'2025-11-23 05:57:39','2b6505d8-6c33-411c-9b84-112503c4c108'),('2025-11-22 05:57:39.131573',NULL,'2025-11-22 05:57:39.144669',693,693,NULL,'923c32f8-18df-4e2c-bc22-a4dbd31f8467',201,'8179302d26964c999cd5f9a55ba9d33b','gigabytes',-1,'2025-11-23 05:57:39','2b6505d8-6c33-411c-9b84-112503c4c108'),('2025-11-22 05:57:42.607948',NULL,'2025-11-22 05:57:42.660973',694,694,'c85f7bcc3e4d40d2bc0e6a37832e885d','e8739aca-3771-41a0-994c-a409d868a861',200,'8179302d26964c999cd5f9a55ba9d33b','shares',1,'2025-11-23 05:57:42',NULL),('2025-11-22 05:57:42.609429',NULL,'2025-11-22 05:57:42.660973',695,695,'c85f7bcc3e4d40d2bc0e6a37832e885d','6f3a1923-ae85-4fb8-8211-1a759ac61d99',199,'8179302d26964c999cd5f9a55ba9d33b','gigabytes',1,'2025-11-23 05:57:42',NULL),('2025-11-22 05:57:42.628352',NULL,'2025-11-22 05:57:42.660973',696,696,NULL,'344114de-9a7a-4b4f-af63-1dae327745ac',208,'8179302d26964c999cd5f9a55ba9d33b','shares',1,'2025-11-23 05:57:42','e92e4c96-7852-4844-a49a-2fed8941ce22'),('2025-11-22 05:57:42.631016',NULL,'2025-11-22 05:57:42.660973',697,697,NULL,'276d1369-79c3-4004-aced-5c1b575c29d9',207,'8179302d26964c999cd5f9a55ba9d33b','gigabytes',1,'2025-11-23 05:57:42','e92e4c96-7852-4844-a49a-2fed8941ce22'),('2025-11-22 05:57:47.742059',NULL,'2025-11-22 05:57:47.797108',698,698,'c85f7bcc3e4d40d2bc0e6a37832e885d','c416528b-87fe-4cd8-90a6-fc67b6c5950a',200,'8179302d26964c999cd5f9a55ba9d33b','shares',-1,'2025-11-23 05:57:47',NULL),('2025-11-22 05:57:47.742810',NULL,'2025-11-22 05:57:47.797108',699,699,'c85f7bcc3e4d40d2bc0e6a37832e885d','a5756f8f-4533-4ebb-90c1-22e10cd23c23',199,'8179302d26964c999cd5f9a55ba9d33b','gigabytes',-1,'2025-11-23 05:57:47',NULL),('2025-11-22 05:57:47.762316',NULL,'2025-11-22 05:57:47.797108',700,700,NULL,'be128185-7671-4ba6-8697-e98367f0e6b4',208,'8179302d26964c999cd5f9a55ba9d33b','shares',-1,'2025-11-23 05:57:47','e92e4c96-7852-4844-a49a-2fed8941ce22'),('2025-11-22 05:57:47.763130',NULL,'2025-11-22 05:57:47.797108',701,701,NULL,'8b2197d0-7f26-4fc7-b336-07bd7dc6a47a',207,'8179302d26964c999cd5f9a55ba9d33b','gigabytes',-1,'2025-11-23 05:57:47','e92e4c96-7852-4844-a49a-2fed8941ce22'),('2025-11-22 05:57:51.189620',NULL,'2025-11-22 05:57:51.223687',702,702,'c85f7bcc3e4d40d2bc0e6a37832e885d','e4283e1f-c9e9-48df-a0ed-c91ec319527f',200,'8179302d26964c999cd5f9a55ba9d33b','shares',1,'2025-11-23 05:57:51',NULL),('2025-11-22 05:57:51.190656',NULL,'2025-11-22 05:57:51.223687',703,703,'c85f7bcc3e4d40d2bc0e6a37832e885d','62c47d7c-2412-4033-93c2-56ac61168a62',199,'8179302d26964c999cd5f9a55ba9d33b','gigabytes',1,'2025-11-23 05:57:51',NULL),('2025-11-22 05:57:51.202206',NULL,'2025-11-22 05:57:51.223687',704,704,NULL,'a942197d-be41-4642-8c72-f062bf986458',210,'8179302d26964c999cd5f9a55ba9d33b','shares',1,'2025-11-23 05:57:51','0a1faf7d-a096-4ae6-821a-0cea16578a95'),('2025-11-22 05:57:51.203432',NULL,'2025-11-22 05:57:51.223687',705,705,NULL,'5846f8c2-7cc7-4335-9f34-04a4e16b9880',209,'8179302d26964c999cd5f9a55ba9d33b','gigabytes',1,'2025-11-23 05:57:51','0a1faf7d-a096-4ae6-821a-0cea16578a95'),('2025-11-22 05:57:51.828439',NULL,'2025-11-22 05:57:51.892814',706,706,'c85f7bcc3e4d40d2bc0e6a37832e885d','a47e00b1-ddf6-4d3c-8732-ac3660862b65',203,'8179302d26964c999cd5f9a55ba9d33b','snapshots',1,'2025-11-23 05:57:51',NULL),('2025-11-22 05:57:51.829866',NULL,'2025-11-22 05:57:51.892814',707,707,'c85f7bcc3e4d40d2bc0e6a37832e885d','b5cd952f-0b6c-4adf-9e43-dbf5df1d9944',204,'8179302d26964c999cd5f9a55ba9d33b','snapshot_gigabytes',1,'2025-11-23 05:57:51',NULL),('2025-11-22 05:57:51.842484',NULL,'2025-11-22 05:57:51.892814',708,708,NULL,'a339cbb0-8512-457f-ba37-f2d8dc015bd8',211,'8179302d26964c999cd5f9a55ba9d33b','snapshots',1,'2025-11-23 05:57:51','0a1faf7d-a096-4ae6-821a-0cea16578a95'),('2025-11-22 05:57:51.843779',NULL,'2025-11-22 05:57:51.892814',709,709,NULL,'91937ad0-2ded-4fd3-bbc6-f9723123808f',212,'8179302d26964c999cd5f9a55ba9d33b','snapshot_gigabytes',1,'2025-11-23 05:57:51','0a1faf7d-a096-4ae6-821a-0cea16578a95'),('2025-11-22 05:57:53.684667',NULL,'2025-11-22 05:57:53.835596',710,710,'4cb3f9c4072c4e558f4e89dc3002ce2d','1a81f250-9c5b-4742-9d52-1223f1ca3846',213,'1304502ff2bf4fc2bce849d08526f92d','shares',1,'2025-11-23 05:57:53',NULL),('2025-11-22 05:57:53.685772',NULL,'2025-11-22 05:57:53.835596',711,711,'4cb3f9c4072c4e558f4e89dc3002ce2d','e86d1397-924b-47f8-9457-f3fa4e64d874',214,'1304502ff2bf4fc2bce849d08526f92d','gigabytes',1,'2025-11-23 05:57:53',NULL),('2025-11-22 05:57:53.772759',NULL,'2025-11-22 05:57:53.835596',712,712,NULL,'79e4059d-8ae6-4940-959a-9852dfb11d3e',215,'1304502ff2bf4fc2bce849d08526f92d','shares',1,'2025-11-23 05:57:53','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:57:53.773992',NULL,'2025-11-22 05:57:53.835596',713,713,NULL,'bbd10296-1bbd-4e6f-a1d0-bddad7bc029a',216,'1304502ff2bf4fc2bce849d08526f92d','gigabytes',1,'2025-11-23 05:57:53','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:57:55.570453',NULL,'2025-11-22 05:57:55.772680',714,714,'c85f7bcc3e4d40d2bc0e6a37832e885d','e2b46175-e6e0-448b-8f04-4918d2de8706',200,'8179302d26964c999cd5f9a55ba9d33b','shares',1,'2025-11-23 05:57:55',NULL),('2025-11-22 05:57:55.573562',NULL,'2025-11-22 05:57:55.772680',715,715,'c85f7bcc3e4d40d2bc0e6a37832e885d','8204ac72-8f71-4d02-b908-9133eb15aec2',199,'8179302d26964c999cd5f9a55ba9d33b','gigabytes',1,'2025-11-23 05:57:55',NULL),('2025-11-22 05:57:55.605891',NULL,'2025-11-22 05:57:55.772680',716,716,NULL,'723df0f1-9e26-47e7-92b8-71f65182aed8',210,'8179302d26964c999cd5f9a55ba9d33b','shares',1,'2025-11-23 05:57:55','0a1faf7d-a096-4ae6-821a-0cea16578a95'),('2025-11-22 05:57:55.608532',NULL,'2025-11-22 05:57:55.772680',717,717,NULL,'c10e8dd7-ea79-4835-ac5b-9d73dad3d41c',209,'8179302d26964c999cd5f9a55ba9d33b','gigabytes',1,'2025-11-23 05:57:55','0a1faf7d-a096-4ae6-821a-0cea16578a95'),('2025-11-22 05:57:57.397584',NULL,'2025-11-22 05:57:57.537657',718,718,'4cb3f9c4072c4e558f4e89dc3002ce2d','ec4e7115-46e8-4748-8dc1-e1ac51bc4681',217,'1304502ff2bf4fc2bce849d08526f92d','snapshots',1,'2025-11-23 05:57:57',NULL),('2025-11-22 05:57:57.399402',NULL,'2025-11-22 05:57:57.537657',719,719,'4cb3f9c4072c4e558f4e89dc3002ce2d','de13ae11-995c-4c97-989f-178cfcb1342a',218,'1304502ff2bf4fc2bce849d08526f92d','snapshot_gigabytes',1,'2025-11-23 05:57:57',NULL),('2025-11-22 05:57:57.434194',NULL,'2025-11-22 05:57:57.537657',720,720,NULL,'c3409f38-8241-4e98-9805-148f867914b9',219,'1304502ff2bf4fc2bce849d08526f92d','snapshots',1,'2025-11-23 05:57:57','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:57:57.436717',NULL,'2025-11-22 05:57:57.537657',721,721,NULL,'d70048a9-509e-42e8-80f4-d478da00b0b1',220,'1304502ff2bf4fc2bce849d08526f92d','snapshot_gigabytes',1,'2025-11-23 05:57:57','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:57:59.542653',NULL,'2025-11-22 05:57:59.571811',722,722,'4cb3f9c4072c4e558f4e89dc3002ce2d','0eea4c52-4a4b-41ff-9bd8-3de70f716e2a',213,'1304502ff2bf4fc2bce849d08526f92d','shares',1,'2025-11-23 05:57:59',NULL),('2025-11-22 05:57:59.544104',NULL,'2025-11-22 05:57:59.571811',723,723,'4cb3f9c4072c4e558f4e89dc3002ce2d','c8b8e0cd-d5e2-4716-8739-5445eece731f',214,'1304502ff2bf4fc2bce849d08526f92d','gigabytes',1,'2025-11-23 05:57:59',NULL),('2025-11-22 05:57:59.550662',NULL,'2025-11-22 05:57:59.571811',724,724,NULL,'505fd126-3558-424d-8870-e00037336b2c',215,'1304502ff2bf4fc2bce849d08526f92d','shares',1,'2025-11-23 05:57:59','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:57:59.551912',NULL,'2025-11-22 05:57:59.571811',725,725,NULL,'001ab06c-9882-4de5-b848-200eac29896e',216,'1304502ff2bf4fc2bce849d08526f92d','gigabytes',1,'2025-11-23 05:57:59','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:57:59.905529',NULL,'2025-11-22 05:57:59.937682',726,726,'85b06cd64746426188d69928ccf28eb0','0b3faba8-f166-405f-aa2a-b03b41bc50cf',221,'fab76ed5d22a49d0be1474f6fe848948','shares',1,'2025-11-23 05:57:59',NULL),('2025-11-22 05:57:59.906681',NULL,'2025-11-22 05:57:59.937682',727,727,'85b06cd64746426188d69928ccf28eb0','b16b03a6-fc26-4ec1-ac2b-57d7a8933d61',222,'fab76ed5d22a49d0be1474f6fe848948','gigabytes',1,'2025-11-23 05:57:59',NULL),('2025-11-22 05:57:59.917245',NULL,'2025-11-22 05:57:59.937682',728,728,NULL,'72bcdb07-dd87-4a65-8805-6d521c9fb314',223,'fab76ed5d22a49d0be1474f6fe848948','shares',1,'2025-11-23 05:57:59','47b5ed1b-aab2-4f77-a767-0d9e2aea3ca1'),('2025-11-22 05:57:59.918319',NULL,'2025-11-22 05:57:59.937682',729,729,NULL,'e6e12188-8879-45e5-8c19-d10f64e7f3aa',224,'fab76ed5d22a49d0be1474f6fe848948','gigabytes',1,'2025-11-23 05:57:59','47b5ed1b-aab2-4f77-a767-0d9e2aea3ca1'),('2025-11-22 05:58:03.345290',NULL,'2025-11-22 05:58:03.497746',730,730,'85b06cd64746426188d69928ccf28eb0','30dd7a38-3634-4fc1-974e-269d0338bdef',226,'fab76ed5d22a49d0be1474f6fe848948','snapshots',1,'2025-11-23 05:58:03',NULL),('2025-11-22 05:58:03.347557',NULL,'2025-11-22 05:58:03.497746',731,731,'85b06cd64746426188d69928ccf28eb0','d589c25f-1193-4579-9e4e-a8b67c631f6c',225,'fab76ed5d22a49d0be1474f6fe848948','snapshot_gigabytes',1,'2025-11-23 05:58:03',NULL),('2025-11-22 05:58:03.373624',NULL,'2025-11-22 05:58:03.497746',732,732,NULL,'25d8d9f9-af61-4fe9-9e64-10b95aaf3f55',228,'fab76ed5d22a49d0be1474f6fe848948','snapshots',1,'2025-11-23 05:58:03','47b5ed1b-aab2-4f77-a767-0d9e2aea3ca1'),('2025-11-22 05:58:03.379595',NULL,'2025-11-22 05:58:03.497746',733,733,NULL,'ef0a1f29-42a5-4da6-a2cb-c3367360d440',227,'fab76ed5d22a49d0be1474f6fe848948','snapshot_gigabytes',1,'2025-11-23 05:58:03','47b5ed1b-aab2-4f77-a767-0d9e2aea3ca1'),('2025-11-22 05:58:03.778479',NULL,'2025-11-22 05:58:03.800858',734,734,'4cb3f9c4072c4e558f4e89dc3002ce2d','dc0b3f32-1e1c-4eb7-be0e-c8861021de38',213,'1304502ff2bf4fc2bce849d08526f92d','shares',-1,'2025-11-23 05:58:03',NULL),('2025-11-22 05:58:03.779312',NULL,'2025-11-22 05:58:03.800858',735,735,'4cb3f9c4072c4e558f4e89dc3002ce2d','91bd7ca3-d941-441e-b106-25788d11fc2d',214,'1304502ff2bf4fc2bce849d08526f92d','gigabytes',-1,'2025-11-23 05:58:03',NULL),('2025-11-22 05:58:03.786860',NULL,'2025-11-22 05:58:03.800858',736,736,NULL,'0cb31ae0-0f75-4940-bf7b-7c5296c320a8',215,'1304502ff2bf4fc2bce849d08526f92d','shares',-1,'2025-11-23 05:58:03','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:58:03.787698',NULL,'2025-11-22 05:58:03.800858',737,737,NULL,'1f6bff83-9461-40e5-a6bb-97fc2ec45601',216,'1304502ff2bf4fc2bce849d08526f92d','gigabytes',-1,'2025-11-23 05:58:03','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:58:06.221430',NULL,'2025-11-22 05:58:06.234697',738,738,'c85f7bcc3e4d40d2bc0e6a37832e885d','98e7862f-a2b5-4859-97bc-16441fbeacce',200,'8179302d26964c999cd5f9a55ba9d33b','shares',-1,'2025-11-23 05:58:06',NULL),('2025-11-22 05:58:06.222052',NULL,'2025-11-22 05:58:06.234697',739,739,'c85f7bcc3e4d40d2bc0e6a37832e885d','d34e1e39-da6f-4563-84bc-54df94504924',199,'8179302d26964c999cd5f9a55ba9d33b','gigabytes',-1,'2025-11-23 05:58:06',NULL),('2025-11-22 05:58:06.226960',NULL,'2025-11-22 05:58:06.234697',740,740,NULL,'c0e80508-db5d-4598-a2b8-8323c07f9c12',210,'8179302d26964c999cd5f9a55ba9d33b','shares',-1,'2025-11-23 05:58:06','0a1faf7d-a096-4ae6-821a-0cea16578a95'),('2025-11-22 05:58:06.227716',NULL,'2025-11-22 05:58:06.234697',741,741,NULL,'a45082cb-9af7-4b1d-b151-a7de3fe75bfa',209,'8179302d26964c999cd5f9a55ba9d33b','gigabytes',-1,'2025-11-23 05:58:06','0a1faf7d-a096-4ae6-821a-0cea16578a95'),('2025-11-22 05:58:07.278918',NULL,'2025-11-22 05:58:07.332767',742,742,'4cb3f9c4072c4e558f4e89dc3002ce2d','1dcd41fe-8ae8-463a-83ee-8fd4f3d42996',213,'1304502ff2bf4fc2bce849d08526f92d','shares',1,'2025-11-23 05:58:07',NULL),('2025-11-22 05:58:07.281540',NULL,'2025-11-22 05:58:07.332767',743,743,'4cb3f9c4072c4e558f4e89dc3002ce2d','3726f166-e5f8-4e79-b643-c9a2e8be8924',214,'1304502ff2bf4fc2bce849d08526f92d','gigabytes',2,'2025-11-23 05:58:07',NULL),('2025-11-22 05:58:07.293541',NULL,'2025-11-22 05:58:07.332767',744,744,NULL,'4766886b-7b89-45c8-bc1a-26922df42913',215,'1304502ff2bf4fc2bce849d08526f92d','shares',1,'2025-11-23 05:58:07','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:58:07.295734',NULL,'2025-11-22 05:58:07.332767',745,745,NULL,'d46939b5-bd39-4c89-84f3-727eb4636180',216,'1304502ff2bf4fc2bce849d08526f92d','gigabytes',2,'2025-11-23 05:58:07','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:58:08.318916',NULL,'2025-11-22 05:58:08.334405',746,746,'85b06cd64746426188d69928ccf28eb0','31ef9d60-4aa3-4830-8cde-69f5f3c4c9a7',226,'fab76ed5d22a49d0be1474f6fe848948','snapshots',-1,'2025-11-23 05:58:08',NULL),('2025-11-22 05:58:08.319598',NULL,'2025-11-22 05:58:08.334405',747,747,'85b06cd64746426188d69928ccf28eb0','f7096c11-d304-41cf-9cee-9e6bb88e50c2',225,'fab76ed5d22a49d0be1474f6fe848948','snapshot_gigabytes',-1,'2025-11-23 05:58:08',NULL),('2025-11-22 05:58:08.326016',NULL,'2025-11-22 05:58:08.334405',748,748,NULL,'24849f71-c872-4898-8cbd-a33ddf7607c2',228,'fab76ed5d22a49d0be1474f6fe848948','snapshots',-1,'2025-11-23 05:58:08','47b5ed1b-aab2-4f77-a767-0d9e2aea3ca1'),('2025-11-22 05:58:08.326869',NULL,'2025-11-22 05:58:08.334405',749,749,NULL,'ea726467-709e-49b3-b362-45192ca484c2',227,'fab76ed5d22a49d0be1474f6fe848948','snapshot_gigabytes',-1,'2025-11-23 05:58:08','47b5ed1b-aab2-4f77-a767-0d9e2aea3ca1'),('2025-11-22 05:58:09.604987',NULL,'2025-11-22 05:58:09.618553',750,750,'c85f7bcc3e4d40d2bc0e6a37832e885d','14acef9d-c5be-4d2b-8498-195cb8222cb0',203,'8179302d26964c999cd5f9a55ba9d33b','snapshots',-1,'2025-11-23 05:58:09',NULL),('2025-11-22 05:58:09.605776',NULL,'2025-11-22 05:58:09.618553',751,751,'c85f7bcc3e4d40d2bc0e6a37832e885d','b7beed29-c33f-4f6d-8503-88a047a19c74',204,'8179302d26964c999cd5f9a55ba9d33b','snapshot_gigabytes',-1,'2025-11-23 05:58:09',NULL),('2025-11-22 05:58:09.610679',NULL,'2025-11-22 05:58:09.618553',752,752,NULL,'7320d87e-0d45-474c-80d8-72dcbfc5058f',211,'8179302d26964c999cd5f9a55ba9d33b','snapshots',-1,'2025-11-23 05:58:09','0a1faf7d-a096-4ae6-821a-0cea16578a95'),('2025-11-22 05:58:09.611421',NULL,'2025-11-22 05:58:09.618553',753,753,NULL,'7d898187-c867-4bf5-ad0c-5efecda09466',212,'8179302d26964c999cd5f9a55ba9d33b','snapshot_gigabytes',-1,'2025-11-23 05:58:09','0a1faf7d-a096-4ae6-821a-0cea16578a95'),('2025-11-22 05:58:11.510510',NULL,'2025-11-22 05:58:11.547959',754,754,'4cb3f9c4072c4e558f4e89dc3002ce2d','87a9c745-70d0-4433-9f0f-de3351b45366',213,'1304502ff2bf4fc2bce849d08526f92d','shares',-1,'2025-11-23 05:58:11',NULL),('2025-11-22 05:58:11.512165',NULL,'2025-11-22 05:58:11.547959',755,755,'4cb3f9c4072c4e558f4e89dc3002ce2d','15ccc269-784c-4253-b7a1-19d5098ac2cc',214,'1304502ff2bf4fc2bce849d08526f92d','gigabytes',-2,'2025-11-23 05:58:11',NULL),('2025-11-22 05:58:11.528613',NULL,'2025-11-22 05:58:11.547959',756,756,NULL,'735c38b1-75ec-4f5b-a397-6097beb5e45d',215,'1304502ff2bf4fc2bce849d08526f92d','shares',-1,'2025-11-23 05:58:11','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:58:11.530461',NULL,'2025-11-22 05:58:11.547959',757,757,NULL,'7accebbb-a619-4970-8380-9511022ead08',216,'1304502ff2bf4fc2bce849d08526f92d','gigabytes',-2,'2025-11-23 05:58:11','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:58:11.873187',NULL,'2025-11-22 05:58:11.891090',758,758,'85b06cd64746426188d69928ccf28eb0','fc9796fe-061c-4026-8121-e23a494c88c0',221,'fab76ed5d22a49d0be1474f6fe848948','shares',-1,'2025-11-23 05:58:11',NULL),('2025-11-22 05:58:11.874305',NULL,'2025-11-22 05:58:11.891090',759,759,'85b06cd64746426188d69928ccf28eb0','ad2d52d1-45c0-46a1-88ee-bbb000ec094c',222,'fab76ed5d22a49d0be1474f6fe848948','gigabytes',-1,'2025-11-23 05:58:11',NULL),('2025-11-22 05:58:11.882141',NULL,'2025-11-22 05:58:11.891090',760,760,NULL,'6f6257a7-7b38-4dc5-9ccc-cd4c64f6a27a',223,'fab76ed5d22a49d0be1474f6fe848948','shares',-1,'2025-11-23 05:58:11','47b5ed1b-aab2-4f77-a767-0d9e2aea3ca1'),('2025-11-22 05:58:11.882911',NULL,'2025-11-22 05:58:11.891090',761,761,NULL,'7d59a30d-5612-4b13-a341-bc4323bb1295',224,'fab76ed5d22a49d0be1474f6fe848948','gigabytes',-1,'2025-11-23 05:58:11','47b5ed1b-aab2-4f77-a767-0d9e2aea3ca1'),('2025-11-22 05:58:13.036403',NULL,'2025-11-22 05:58:13.062004',762,762,'c85f7bcc3e4d40d2bc0e6a37832e885d','6825be3c-7308-4552-9e7c-6462c62e21f6',200,'8179302d26964c999cd5f9a55ba9d33b','shares',-1,'2025-11-23 05:58:12',NULL),('2025-11-22 05:58:13.037913',NULL,'2025-11-22 05:58:13.062004',763,763,'c85f7bcc3e4d40d2bc0e6a37832e885d','dc52baff-31cb-4c8e-aa97-9a58e56b8621',199,'8179302d26964c999cd5f9a55ba9d33b','gigabytes',-1,'2025-11-23 05:58:12',NULL),('2025-11-22 05:58:13.048089',NULL,'2025-11-22 05:58:13.062004',764,764,NULL,'4c120491-d1ef-4206-bedc-50c09bed8ae3',210,'8179302d26964c999cd5f9a55ba9d33b','shares',-1,'2025-11-23 05:58:12','0a1faf7d-a096-4ae6-821a-0cea16578a95'),('2025-11-22 05:58:13.049418',NULL,'2025-11-22 05:58:13.062004',765,765,NULL,'352ec2d3-be8e-48d4-85a9-34758f1e47b1',209,'8179302d26964c999cd5f9a55ba9d33b','gigabytes',-1,'2025-11-23 05:58:12','0a1faf7d-a096-4ae6-821a-0cea16578a95'),('2025-11-22 05:58:14.618943',NULL,'2025-11-22 05:58:14.678697',766,766,'4cb3f9c4072c4e558f4e89dc3002ce2d','0218b255-c2f0-47e3-b5f6-d441805ef8e1',213,'1304502ff2bf4fc2bce849d08526f92d','shares',1,'2025-11-23 05:58:14',NULL),('2025-11-22 05:58:14.621114',NULL,'2025-11-22 05:58:14.678697',767,767,'4cb3f9c4072c4e558f4e89dc3002ce2d','09f830f5-8a59-4e9c-9af8-7bf769dfac5e',214,'1304502ff2bf4fc2bce849d08526f92d','gigabytes',1,'2025-11-23 05:58:14',NULL),('2025-11-22 05:58:14.631710',NULL,'2025-11-22 05:58:14.678697',768,768,NULL,'c0763e8d-8111-41e5-be2d-84b1e6a15013',215,'1304502ff2bf4fc2bce849d08526f92d','shares',1,'2025-11-23 05:58:14','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:58:14.634376',NULL,'2025-11-22 05:58:14.678697',769,769,NULL,'2bbff07a-ef00-458e-9260-732dece055aa',216,'1304502ff2bf4fc2bce849d08526f92d','gigabytes',1,'2025-11-23 05:58:14','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:58:18.863225',NULL,'2025-11-22 05:58:18.881378',770,770,'4cb3f9c4072c4e558f4e89dc3002ce2d','179aeca1-ca8c-4387-a275-122eff8a6690',213,'1304502ff2bf4fc2bce849d08526f92d','shares',-1,'2025-11-23 05:58:18',NULL),('2025-11-22 05:58:18.864149',NULL,'2025-11-22 05:58:18.881378',771,771,'4cb3f9c4072c4e558f4e89dc3002ce2d','d7f9ff5a-b50e-43e8-8949-7b4db8e60468',214,'1304502ff2bf4fc2bce849d08526f92d','gigabytes',-1,'2025-11-23 05:58:18',NULL),('2025-11-22 05:58:18.870965',NULL,'2025-11-22 05:58:18.881378',772,772,NULL,'d07a023b-55e8-4af5-96b8-2f72bc6ea5f0',215,'1304502ff2bf4fc2bce849d08526f92d','shares',-1,'2025-11-23 05:58:18','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:58:18.871844',NULL,'2025-11-22 05:58:18.881378',773,773,NULL,'c3bc1b3e-2c4c-448b-b6f7-39619796c130',216,'1304502ff2bf4fc2bce849d08526f92d','gigabytes',-1,'2025-11-23 05:58:18','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:58:20.967603',NULL,'2025-11-22 05:58:21.005541',774,774,'135e060c52fc44c48e7f3dea40fb7352','38124f44-4a51-4edf-bb00-6475fd7e0292',229,'b69436f6d3194929ace36172443c8bfa','share_networks',1,'2025-11-23 05:58:20',NULL),('2025-11-22 05:58:21.852683',NULL,'2025-11-22 05:58:21.862165',775,775,'135e060c52fc44c48e7f3dea40fb7352','f5c9576c-b99a-4c96-bde2-e29a4fd8840b',229,'b69436f6d3194929ace36172443c8bfa','share_networks',-1,'2025-11-23 05:58:21',NULL),('2025-11-22 05:58:22.030646',NULL,'2025-11-22 05:58:22.083157',776,776,'4cb3f9c4072c4e558f4e89dc3002ce2d','77975656-ea5a-4b9d-90ea-e07548e96673',213,'1304502ff2bf4fc2bce849d08526f92d','shares',1,'2025-11-23 05:58:22',NULL),('2025-11-22 05:58:22.033696',NULL,'2025-11-22 05:58:22.083157',777,777,'4cb3f9c4072c4e558f4e89dc3002ce2d','4999adce-95dd-4108-9102-833cfd707d9b',214,'1304502ff2bf4fc2bce849d08526f92d','gigabytes',1,'2025-11-23 05:58:22',NULL),('2025-11-22 05:58:22.043102',NULL,'2025-11-22 05:58:22.083157',778,778,NULL,'6a35fa11-d078-4c33-b7df-ccda1d258251',215,'1304502ff2bf4fc2bce849d08526f92d','shares',1,'2025-11-23 05:58:22','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:58:22.048694',NULL,'2025-11-22 05:58:22.083157',779,779,NULL,'c7d6a4f2-f694-4c36-9319-3722357e7d56',216,'1304502ff2bf4fc2bce849d08526f92d','gigabytes',1,'2025-11-23 05:58:22','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:58:22.116238',NULL,'2025-11-22 05:58:22.155455',780,780,'135e060c52fc44c48e7f3dea40fb7352','53f39c11-14cc-45d8-8124-e583c20f854a',229,'b69436f6d3194929ace36172443c8bfa','share_networks',1,'2025-11-23 05:58:22',NULL),('2025-11-22 05:58:22.852820',NULL,'2025-11-22 05:58:22.861008',781,781,'135e060c52fc44c48e7f3dea40fb7352','7089d23a-be6b-4d10-b47c-f339479c8f19',229,'b69436f6d3194929ace36172443c8bfa','share_networks',-1,'2025-11-23 05:58:22',NULL),('2025-11-22 05:58:23.039569',NULL,'2025-11-22 05:58:23.067349',782,782,'135e060c52fc44c48e7f3dea40fb7352','1fcbba01-9c4f-4347-a86e-2c42fc351a74',229,'b69436f6d3194929ace36172443c8bfa','share_networks',1,'2025-11-23 05:58:23',NULL),('2025-11-22 05:58:23.845272',NULL,'2025-11-22 05:58:23.851143',783,783,'135e060c52fc44c48e7f3dea40fb7352','17aaf06d-52b8-48c6-8079-57604e2fef7d',229,'b69436f6d3194929ace36172443c8bfa','share_networks',-1,'2025-11-23 05:58:23',NULL),('2025-11-22 05:58:25.429634',NULL,'2025-11-22 05:58:25.472956',784,784,'120367c7d9ec45569159d69c691c775d','e3753cd1-8a37-44ec-9e55-0ace1b1e953d',230,'57cc59807cc747c6849cfa0c21089689','shares',1,'2025-11-23 05:58:25',NULL),('2025-11-22 05:58:25.430795',NULL,'2025-11-22 05:58:25.472956',785,785,'120367c7d9ec45569159d69c691c775d','7fa289a7-4c1b-4246-8e96-0d98d2c6e779',231,'57cc59807cc747c6849cfa0c21089689','gigabytes',2,'2025-11-23 05:58:25',NULL),('2025-11-22 05:58:25.444438',NULL,'2025-11-22 05:58:25.472956',786,786,NULL,'825e359d-d891-4ef3-a1e4-d749099108b6',232,'57cc59807cc747c6849cfa0c21089689','shares',1,'2025-11-23 05:58:25','cfea797e-06da-4537-b54d-22f274a0b710'),('2025-11-22 05:58:25.446964',NULL,'2025-11-22 05:58:25.472956',787,787,NULL,'ce901096-a0ec-47b4-9a7e-c1fa715d794e',233,'57cc59807cc747c6849cfa0c21089689','gigabytes',2,'2025-11-23 05:58:25','cfea797e-06da-4537-b54d-22f274a0b710'),('2025-11-22 05:58:26.522374',NULL,'2025-11-22 05:58:26.537919',788,788,'4cb3f9c4072c4e558f4e89dc3002ce2d','605e3dd2-ed8d-4dee-b5e5-3ee0153bebb1',213,'1304502ff2bf4fc2bce849d08526f92d','shares',-1,'2025-11-23 05:58:26',NULL),('2025-11-22 05:58:26.523365',NULL,'2025-11-22 05:58:26.537919',789,789,'4cb3f9c4072c4e558f4e89dc3002ce2d','fd08472d-1f38-4a04-9a03-47bdbeba5129',214,'1304502ff2bf4fc2bce849d08526f92d','gigabytes',-1,'2025-11-23 05:58:26',NULL),('2025-11-22 05:58:26.528764',NULL,'2025-11-22 05:58:26.537919',790,790,NULL,'59b59900-7547-445c-919c-354aab6f7a22',215,'1304502ff2bf4fc2bce849d08526f92d','shares',-1,'2025-11-23 05:58:26','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:58:26.529423',NULL,'2025-11-22 05:58:26.537919',791,791,NULL,'369791b8-1565-4f3a-849a-0b0a524c6008',216,'1304502ff2bf4fc2bce849d08526f92d','gigabytes',-1,'2025-11-23 05:58:26','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:58:29.087086',NULL,'2025-11-22 05:58:29.300072',792,792,'120367c7d9ec45569159d69c691c775d','64189fcc-5593-4acd-a858-58f000e116af',234,'57cc59807cc747c6849cfa0c21089689','snapshots',1,'2025-11-23 05:58:29',NULL),('2025-11-22 05:58:29.088467',NULL,'2025-11-22 05:58:29.300072',793,793,'120367c7d9ec45569159d69c691c775d','aaf43275-9091-4f69-8d2c-27e28c66d067',235,'57cc59807cc747c6849cfa0c21089689','snapshot_gigabytes',2,'2025-11-23 05:58:29',NULL),('2025-11-22 05:58:29.212475',NULL,'2025-11-22 05:58:29.300072',794,794,NULL,'e32da87e-ee18-4255-92f6-07ac2b02eddc',236,'57cc59807cc747c6849cfa0c21089689','snapshots',1,'2025-11-23 05:58:29','cfea797e-06da-4537-b54d-22f274a0b710'),('2025-11-22 05:58:29.214712',NULL,'2025-11-22 05:58:29.300072',795,795,NULL,'1e328345-f057-4105-9ca1-66d387f18f26',237,'57cc59807cc747c6849cfa0c21089689','snapshot_gigabytes',2,'2025-11-23 05:58:29','cfea797e-06da-4537-b54d-22f274a0b710'),('2025-11-22 05:58:29.687397',NULL,'2025-11-22 05:58:29.774979',796,796,'4cb3f9c4072c4e558f4e89dc3002ce2d','94cc26e8-e416-4272-afbf-40902c3b69c8',213,'1304502ff2bf4fc2bce849d08526f92d','shares',1,'2025-11-23 05:58:29',NULL),('2025-11-22 05:58:29.689631',NULL,'2025-11-22 05:58:29.774979',797,797,'4cb3f9c4072c4e558f4e89dc3002ce2d','cedfcf2c-3237-42c2-9802-18e5fabe9018',214,'1304502ff2bf4fc2bce849d08526f92d','gigabytes',1,'2025-11-23 05:58:29',NULL),('2025-11-22 05:58:29.704707',NULL,'2025-11-22 05:58:29.774979',798,798,NULL,'267047b3-80d6-4901-991f-f3e12920d456',215,'1304502ff2bf4fc2bce849d08526f92d','shares',1,'2025-11-23 05:58:29','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:58:29.705976',NULL,'2025-11-22 05:58:29.774979',799,799,NULL,'3c80409a-bd41-4527-9b65-d45dc735b9b3',216,'1304502ff2bf4fc2bce849d08526f92d','gigabytes',1,'2025-11-23 05:58:29','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:58:33.635482',NULL,'2025-11-22 05:58:33.650750',800,800,'120367c7d9ec45569159d69c691c775d','4badf95e-556e-4502-b6bc-9182ad33ec8c',234,'57cc59807cc747c6849cfa0c21089689','snapshots',-1,'2025-11-23 05:58:33',NULL),('2025-11-22 05:58:33.636307',NULL,'2025-11-22 05:58:33.650750',801,801,'120367c7d9ec45569159d69c691c775d','4025e47f-4d11-4bc0-b689-1aec4ce44aa5',235,'57cc59807cc747c6849cfa0c21089689','snapshot_gigabytes',-2,'2025-11-23 05:58:33',NULL),('2025-11-22 05:58:33.641749',NULL,'2025-11-22 05:58:33.650750',802,802,NULL,'bbd5105b-7bcf-475a-b763-e8c6287b5abf',236,'57cc59807cc747c6849cfa0c21089689','snapshots',-1,'2025-11-23 05:58:33','cfea797e-06da-4537-b54d-22f274a0b710'),('2025-11-22 05:58:33.642495',NULL,'2025-11-22 05:58:33.650750',803,803,NULL,'df82aed6-b8aa-478c-a80a-1d479d34af24',237,'57cc59807cc747c6849cfa0c21089689','snapshot_gigabytes',-2,'2025-11-23 05:58:33','cfea797e-06da-4537-b54d-22f274a0b710'),('2025-11-22 05:58:34.545100',NULL,'2025-11-22 05:58:34.564348',804,804,'4cb3f9c4072c4e558f4e89dc3002ce2d','2e1d3605-09fb-42f3-a982-3341d27c5acc',213,'1304502ff2bf4fc2bce849d08526f92d','shares',-1,'2025-11-23 05:58:34',NULL),('2025-11-22 05:58:34.545963',NULL,'2025-11-22 05:58:34.564348',805,805,'4cb3f9c4072c4e558f4e89dc3002ce2d','fd663234-4ae7-499f-a775-b525574a5a16',214,'1304502ff2bf4fc2bce849d08526f92d','gigabytes',-1,'2025-11-23 05:58:34',NULL),('2025-11-22 05:58:34.553036',NULL,'2025-11-22 05:58:34.564348',806,806,NULL,'952f1031-4962-497c-b0a3-766caa0f1b25',215,'1304502ff2bf4fc2bce849d08526f92d','shares',-1,'2025-11-23 05:58:34','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:58:34.554317',NULL,'2025-11-22 05:58:34.564348',807,807,NULL,'b2dbd12c-72d0-413d-8196-a0bc5dc207b5',216,'1304502ff2bf4fc2bce849d08526f92d','gigabytes',-1,'2025-11-23 05:58:34','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:58:37.204926',NULL,'2025-11-22 05:58:37.218825',808,808,'120367c7d9ec45569159d69c691c775d','23160f9f-9afa-4b72-b491-a855cf43f05e',230,'57cc59807cc747c6849cfa0c21089689','shares',-1,'2025-11-23 05:58:37',NULL),('2025-11-22 05:58:37.205666',NULL,'2025-11-22 05:58:37.218825',809,809,'120367c7d9ec45569159d69c691c775d','3c97da1b-46d3-4dee-aeb7-693d981af575',231,'57cc59807cc747c6849cfa0c21089689','gigabytes',-2,'2025-11-23 05:58:37',NULL),('2025-11-22 05:58:37.210844',NULL,'2025-11-22 05:58:37.218825',810,810,NULL,'88ceee51-82f7-4e1a-af78-399410e3ef9f',232,'57cc59807cc747c6849cfa0c21089689','shares',-1,'2025-11-23 05:58:37','cfea797e-06da-4537-b54d-22f274a0b710'),('2025-11-22 05:58:37.211745',NULL,'2025-11-22 05:58:37.218825',811,811,NULL,'806ef0be-42dc-432f-965f-3b9da6aae3c1',233,'57cc59807cc747c6849cfa0c21089689','gigabytes',-2,'2025-11-23 05:58:37','cfea797e-06da-4537-b54d-22f274a0b710'),('2025-11-22 05:58:38.939156',NULL,'2025-11-22 05:58:38.959414',812,812,'4cb3f9c4072c4e558f4e89dc3002ce2d','58e49800-afa1-4aef-bf9c-00f87b9cd6d4',217,'1304502ff2bf4fc2bce849d08526f92d','snapshots',-1,'2025-11-23 05:58:38',NULL),('2025-11-22 05:58:38.940215',NULL,'2025-11-22 05:58:38.959414',813,813,'4cb3f9c4072c4e558f4e89dc3002ce2d','6618090b-2f2d-4b81-872b-deb83d8d8324',218,'1304502ff2bf4fc2bce849d08526f92d','snapshot_gigabytes',-1,'2025-11-23 05:58:38',NULL),('2025-11-22 05:58:38.948664',NULL,'2025-11-22 05:58:38.959414',814,814,NULL,'1e7c72ec-190c-409c-916b-f596d8f08e42',219,'1304502ff2bf4fc2bce849d08526f92d','snapshots',-1,'2025-11-23 05:58:38','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:58:38.949692',NULL,'2025-11-22 05:58:38.959414',815,815,NULL,'3546f3ef-2c06-449e-b496-53ccd6fcab49',220,'1304502ff2bf4fc2bce849d08526f92d','snapshot_gigabytes',-1,'2025-11-23 05:58:38','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:58:40.342721',NULL,'2025-11-22 05:58:40.376877',816,816,'120367c7d9ec45569159d69c691c775d','d8476e40-c60b-49c6-8818-7537f3930eda',230,'57cc59807cc747c6849cfa0c21089689','shares',1,'2025-11-23 05:58:40',NULL),('2025-11-22 05:58:40.344150',NULL,'2025-11-22 05:58:40.376877',817,817,'120367c7d9ec45569159d69c691c775d','57feb5be-8609-4bab-b55e-c3d74c823d5e',231,'57cc59807cc747c6849cfa0c21089689','gigabytes',1,'2025-11-23 05:58:40',NULL),('2025-11-22 05:58:40.350823',NULL,'2025-11-22 05:58:40.376877',818,818,NULL,'ff249de6-94cd-4a59-8694-3b7a63d9026e',232,'57cc59807cc747c6849cfa0c21089689','shares',1,'2025-11-23 05:58:40','cfea797e-06da-4537-b54d-22f274a0b710'),('2025-11-22 05:58:40.352190',NULL,'2025-11-22 05:58:40.376877',819,819,NULL,'032b38d2-75c5-45b9-9608-ff2c75e83da0',233,'57cc59807cc747c6849cfa0c21089689','gigabytes',1,'2025-11-23 05:58:40','cfea797e-06da-4537-b54d-22f274a0b710'),('2025-11-22 05:58:42.444825',NULL,'2025-11-22 05:58:42.482080',820,820,'4cb3f9c4072c4e558f4e89dc3002ce2d','3a251698-9a35-4207-a6e2-47d8115c17af',213,'1304502ff2bf4fc2bce849d08526f92d','shares',-1,'2025-11-23 05:58:42',NULL),('2025-11-22 05:58:42.445607',NULL,'2025-11-22 05:58:42.482080',821,821,'4cb3f9c4072c4e558f4e89dc3002ce2d','78f1810f-1665-4574-a5d9-0d5d10e781c5',214,'1304502ff2bf4fc2bce849d08526f92d','gigabytes',-1,'2025-11-23 05:58:42',NULL),('2025-11-22 05:58:42.472250',NULL,'2025-11-22 05:58:42.482080',822,822,NULL,'0cf67f8f-b979-4970-b588-6e85a2f0c477',215,'1304502ff2bf4fc2bce849d08526f92d','shares',-1,'2025-11-23 05:58:42','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:58:42.473125',NULL,'2025-11-22 05:58:42.482080',823,823,NULL,'0c6d45ca-5761-454a-ab61-f68ba7add047',216,'1304502ff2bf4fc2bce849d08526f92d','gigabytes',-1,'2025-11-23 05:58:42','d59519d5-a66d-4c06-a170-dbc2876b25c1'),('2025-11-22 05:58:43.984317',NULL,'2025-11-22 05:58:44.183759',824,824,'120367c7d9ec45569159d69c691c775d','8770b170-1b2b-4ebb-9f80-dad13d58df67',234,'57cc59807cc747c6849cfa0c21089689','snapshots',1,'2025-11-23 05:58:43',NULL),('2025-11-22 05:58:43.986439',NULL,'2025-11-22 05:58:44.183759',825,825,'120367c7d9ec45569159d69c691c775d','1067c7b2-0e4e-4191-af21-243d46ff284a',235,'57cc59807cc747c6849cfa0c21089689','snapshot_gigabytes',1,'2025-11-23 05:58:43',NULL),('2025-11-22 05:58:44.019318',NULL,'2025-11-22 05:58:44.183759',826,826,NULL,'9dbf8186-be9f-42f9-889e-f64a77f2e325',236,'57cc59807cc747c6849cfa0c21089689','snapshots',1,'2025-11-23 05:58:43','cfea797e-06da-4537-b54d-22f274a0b710'),('2025-11-22 05:58:44.021055',NULL,'2025-11-22 05:58:44.183759',827,827,NULL,'549cb81c-2b8f-4748-8d0d-67a39e354c6b',237,'57cc59807cc747c6849cfa0c21089689','snapshot_gigabytes',1,'2025-11-23 05:58:43','cfea797e-06da-4537-b54d-22f274a0b710'),('2025-11-22 05:58:44.426677',NULL,'2025-11-22 05:58:44.550026',828,828,'3db9dedf9593479bbad4287d9e10a4d5','7bbd5db9-7927-4daf-8b51-9d1510f5bde1',239,'1e3df68b14c64c2eba82d76467788260','shares',1,'2025-11-23 05:58:44',NULL),('2025-11-22 05:58:44.428633',NULL,'2025-11-22 05:58:44.550026',829,829,'3db9dedf9593479bbad4287d9e10a4d5','e37ae434-a28e-4398-8b92-a0f5b856a40e',238,'1e3df68b14c64c2eba82d76467788260','gigabytes',1,'2025-11-23 05:58:44',NULL),('2025-11-22 05:58:44.449244',NULL,'2025-11-22 05:58:44.550026',830,830,NULL,'d51f938b-0984-42d4-923a-d0068c320052',241,'1e3df68b14c64c2eba82d76467788260','shares',1,'2025-11-23 05:58:44','6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:58:44.451054',NULL,'2025-11-22 05:58:44.550026',831,831,NULL,'5a3db5c4-fddb-49ea-8129-8babf70f755a',240,'1e3df68b14c64c2eba82d76467788260','gigabytes',1,'2025-11-23 05:58:44','6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:58:48.275637',NULL,'2025-11-22 05:58:48.400325',832,832,'3db9dedf9593479bbad4287d9e10a4d5','39d952f6-bd7e-4fd6-99ce-b86d550a8f19',243,'1e3df68b14c64c2eba82d76467788260','snapshots',1,'2025-11-23 05:58:48',NULL),('2025-11-22 05:58:48.277270',NULL,'2025-11-22 05:58:48.400325',833,833,'3db9dedf9593479bbad4287d9e10a4d5','ee325fe9-2ae8-4bb4-8a5d-90621a38b039',242,'1e3df68b14c64c2eba82d76467788260','snapshot_gigabytes',1,'2025-11-23 05:58:48',NULL),('2025-11-22 05:58:48.289441',NULL,'2025-11-22 05:58:48.400325',834,834,NULL,'123c3a4c-2ff2-4cdb-b87b-9b471bd33980',245,'1e3df68b14c64c2eba82d76467788260','snapshots',1,'2025-11-23 05:58:48','6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:58:48.299085',NULL,'2025-11-22 05:58:48.400325',835,835,NULL,'46c7f3a0-2cd1-4f7a-8047-644db9b5d3e6',244,'1e3df68b14c64c2eba82d76467788260','snapshot_gigabytes',1,'2025-11-23 05:58:48','6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:58:48.906172',NULL,'2025-11-22 05:58:48.937475',836,836,'3db9dedf9593479bbad4287d9e10a4d5','aeb62aa3-87e0-4a3e-ab3f-5f238a7dd906',239,'1e3df68b14c64c2eba82d76467788260','shares',1,'2025-11-23 05:58:48',NULL),('2025-11-22 05:58:48.908046',NULL,'2025-11-22 05:58:48.937475',837,837,'3db9dedf9593479bbad4287d9e10a4d5','ab989e7a-1c52-49fb-9aab-be1823fcff33',238,'1e3df68b14c64c2eba82d76467788260','gigabytes',1,'2025-11-23 05:58:48',NULL),('2025-11-22 05:58:48.915464',NULL,'2025-11-22 05:58:48.937475',838,838,NULL,'72e69bdd-db71-4557-853f-82b710d615a9',241,'1e3df68b14c64c2eba82d76467788260','shares',1,'2025-11-23 05:58:48','6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:58:48.916772',NULL,'2025-11-22 05:58:48.937475',839,839,NULL,'0605198e-49bf-40d5-b2a8-8dc0665c7541',240,'1e3df68b14c64c2eba82d76467788260','gigabytes',1,'2025-11-23 05:58:48','6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:58:49.099697',NULL,'2025-11-22 05:58:49.126376',840,840,'120367c7d9ec45569159d69c691c775d','9a406913-01b6-434e-92c6-1758311b51c6',234,'57cc59807cc747c6849cfa0c21089689','snapshots',-1,'2025-11-23 05:58:49',NULL),('2025-11-22 05:58:49.100588',NULL,'2025-11-22 05:58:49.126376',841,841,'120367c7d9ec45569159d69c691c775d','a7ba446b-1b57-42dc-b99f-e13beeca5150',235,'57cc59807cc747c6849cfa0c21089689','snapshot_gigabytes',-1,'2025-11-23 05:58:49',NULL),('2025-11-22 05:58:49.111794',NULL,'2025-11-22 05:58:49.126376',842,842,NULL,'96133688-5b0c-40e4-aed6-cdfc2609c9e9',236,'57cc59807cc747c6849cfa0c21089689','snapshots',-1,'2025-11-23 05:58:49','cfea797e-06da-4537-b54d-22f274a0b710'),('2025-11-22 05:58:49.113022',NULL,'2025-11-22 05:58:49.126376',843,843,NULL,'91499ed9-34de-4ae9-9aff-964ae5904122',237,'57cc59807cc747c6849cfa0c21089689','snapshot_gigabytes',-1,'2025-11-23 05:58:49','cfea797e-06da-4537-b54d-22f274a0b710'),('2025-11-22 05:58:57.547991',NULL,'2025-11-22 05:58:57.565881',844,844,'120367c7d9ec45569159d69c691c775d','de5199ff-3bbe-4e93-9a2b-aa4926cc435c',230,'57cc59807cc747c6849cfa0c21089689','shares',-1,'2025-11-23 05:58:57',NULL),('2025-11-22 05:58:57.548943',NULL,'2025-11-22 05:58:57.565881',845,845,'120367c7d9ec45569159d69c691c775d','8620338f-aa86-434d-b6f5-6ebdbbba7540',231,'57cc59807cc747c6849cfa0c21089689','gigabytes',-1,'2025-11-23 05:58:57',NULL),('2025-11-22 05:58:57.555414',NULL,'2025-11-22 05:58:57.565881',846,846,NULL,'77d9bef1-8a5a-4c99-a814-6158a73627b2',232,'57cc59807cc747c6849cfa0c21089689','shares',-1,'2025-11-23 05:58:57','cfea797e-06da-4537-b54d-22f274a0b710'),('2025-11-22 05:58:57.556138',NULL,'2025-11-22 05:58:57.565881',847,847,NULL,'d4ad1133-7433-42ad-88dc-d289d4dbc9b6',233,'57cc59807cc747c6849cfa0c21089689','gigabytes',-1,'2025-11-23 05:58:57','cfea797e-06da-4537-b54d-22f274a0b710'),('2025-11-22 05:59:05.290336',NULL,'2025-11-22 05:59:05.345784',848,848,'3db9dedf9593479bbad4287d9e10a4d5','b27c9419-8194-465f-931a-b14a4595d0e1',239,'1e3df68b14c64c2eba82d76467788260','shares',1,'2025-11-23 05:59:05',NULL),('2025-11-22 05:59:05.291953',NULL,'2025-11-22 05:59:05.345784',849,849,'3db9dedf9593479bbad4287d9e10a4d5','b4ae6ad4-eb82-4ee7-a88e-4ba00874b0a0',238,'1e3df68b14c64c2eba82d76467788260','gigabytes',1,'2025-11-23 05:59:05',NULL),('2025-11-22 05:59:05.302395',NULL,'2025-11-22 05:59:05.345784',850,850,NULL,'fc52f73c-2ab9-4c01-a8ef-3ccceccc6a05',241,'1e3df68b14c64c2eba82d76467788260','shares',1,'2025-11-23 05:59:05','6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:59:05.304109',NULL,'2025-11-22 05:59:05.345784',851,851,NULL,'49ca0b72-bef3-4f96-b75c-4059448bda0b',240,'1e3df68b14c64c2eba82d76467788260','gigabytes',1,'2025-11-23 05:59:05','6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:59:06.477095',NULL,'2025-11-22 05:59:06.528908',852,852,'123ee1961f274fcf8727f7d4c1fb5248','e77c8feb-8af2-4f9b-bd70-edcc11014a8e',247,'ef497337be194fcb9ce62d89ec4f8a5a','shares',1,'2025-11-23 05:59:06',NULL),('2025-11-22 05:59:06.478954',NULL,'2025-11-22 05:59:06.528908',853,853,'123ee1961f274fcf8727f7d4c1fb5248','4839affd-2f03-471f-9cd4-a9dac60cfc8e',246,'ef497337be194fcb9ce62d89ec4f8a5a','gigabytes',1,'2025-11-23 05:59:06',NULL),('2025-11-22 05:59:06.494942',NULL,'2025-11-22 05:59:06.528908',854,854,NULL,'524b7d9c-235b-45de-a686-39c517827211',249,'ef497337be194fcb9ce62d89ec4f8a5a','shares',1,'2025-11-23 05:59:06','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:06.496843',NULL,'2025-11-22 05:59:06.528908',855,855,NULL,'46f558a7-2cd0-42f6-baa8-c4d74a80e406',248,'ef497337be194fcb9ce62d89ec4f8a5a','gigabytes',1,'2025-11-23 05:59:06','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:08.033702',NULL,'2025-11-22 05:59:08.070241',856,856,'010135c9a64149dbb6846c9a653da6b8','ae664ca7-99e9-487e-869b-5d36f1fef5df',251,'325a0f56a64040c18ae384c10457495e','shares',1,'2025-11-23 05:59:08',NULL),('2025-11-22 05:59:08.034990',NULL,'2025-11-22 05:59:08.070241',857,857,'010135c9a64149dbb6846c9a653da6b8','cb8545d4-cc05-4087-87f7-d143abd85400',250,'325a0f56a64040c18ae384c10457495e','gigabytes',1,'2025-11-23 05:59:08',NULL),('2025-11-22 05:59:08.046909',NULL,'2025-11-22 05:59:08.070241',858,858,NULL,'ef99941c-cfde-4eea-91de-ea58e2ad0bfd',253,'325a0f56a64040c18ae384c10457495e','shares',1,'2025-11-23 05:59:08','100c722e-6c00-4303-ac29-b6525536cfc3'),('2025-11-22 05:59:08.048170',NULL,'2025-11-22 05:59:08.070241',859,859,NULL,'2f8e4073-c693-4a4c-815d-99c074b98845',252,'325a0f56a64040c18ae384c10457495e','gigabytes',1,'2025-11-23 05:59:08','100c722e-6c00-4303-ac29-b6525536cfc3'),('2025-11-22 05:59:08.879982',NULL,'2025-11-22 05:59:09.096623',860,860,'3db9dedf9593479bbad4287d9e10a4d5','81de368a-6aab-489c-a8c4-2b80b2c20391',238,'1e3df68b14c64c2eba82d76467788260','gigabytes',1,'2025-11-23 05:59:08',NULL),('2025-11-22 05:59:08.886526',NULL,'2025-11-22 05:59:09.096623',861,861,NULL,'234aca7f-9f56-4138-a099-35bc74544e4e',240,'1e3df68b14c64c2eba82d76467788260','gigabytes',1,'2025-11-23 05:59:08','6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:59:10.125519',NULL,'2025-11-22 05:59:10.198762',862,862,'123ee1961f274fcf8727f7d4c1fb5248','4b6a32a4-64a3-449b-81a3-c3a4ba175470',254,'ef497337be194fcb9ce62d89ec4f8a5a','snapshots',1,'2025-11-23 05:59:10',NULL),('2025-11-22 05:59:10.129558',NULL,'2025-11-22 05:59:10.198762',863,863,'123ee1961f274fcf8727f7d4c1fb5248','79db7ec1-f0f0-43d6-afb6-70595d540618',255,'ef497337be194fcb9ce62d89ec4f8a5a','snapshot_gigabytes',1,'2025-11-23 05:59:10',NULL),('2025-11-22 05:59:10.143366',NULL,'2025-11-22 05:59:10.198762',864,864,NULL,'145bbbb5-6294-4193-b2bb-680d288d7d21',256,'ef497337be194fcb9ce62d89ec4f8a5a','snapshots',1,'2025-11-23 05:59:10','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:10.144889',NULL,'2025-11-22 05:59:10.198762',865,865,NULL,'c34e63a1-36be-46f8-9724-8e0147373150',257,'ef497337be194fcb9ce62d89ec4f8a5a','snapshot_gigabytes',1,'2025-11-23 05:59:10','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:11.464763',NULL,'2025-11-22 05:59:11.577543',866,866,'010135c9a64149dbb6846c9a653da6b8','2ae25609-89be-4457-b205-84ab2a62d64f',258,'325a0f56a64040c18ae384c10457495e','snapshots',1,'2025-11-23 05:59:11',NULL),('2025-11-22 05:59:11.466441',NULL,'2025-11-22 05:59:11.577543',867,867,'010135c9a64149dbb6846c9a653da6b8','b4fa49c7-cae2-4a63-8c4d-3c9cbe6e4830',259,'325a0f56a64040c18ae384c10457495e','snapshot_gigabytes',1,'2025-11-23 05:59:11',NULL),('2025-11-22 05:59:11.479893',NULL,'2025-11-22 05:59:11.577543',868,868,NULL,'f5b2e5a4-67e1-46af-9a2d-79577f1ec723',260,'325a0f56a64040c18ae384c10457495e','snapshots',1,'2025-11-23 05:59:11','100c722e-6c00-4303-ac29-b6525536cfc3'),('2025-11-22 05:59:11.481369',NULL,'2025-11-22 05:59:11.577543',869,869,NULL,'fe293cd1-78f6-4758-9fb1-ef8b39036276',261,'325a0f56a64040c18ae384c10457495e','snapshot_gigabytes',1,'2025-11-23 05:59:11','100c722e-6c00-4303-ac29-b6525536cfc3'),('2025-11-22 05:59:12.775640',NULL,'2025-11-22 05:59:12.793939',870,870,'3db9dedf9593479bbad4287d9e10a4d5','6493376b-713c-4874-b722-d7648e096c6f',239,'1e3df68b14c64c2eba82d76467788260','shares',-1,'2025-11-23 05:59:12',NULL),('2025-11-22 05:59:12.776776',NULL,'2025-11-22 05:59:12.793939',871,871,'3db9dedf9593479bbad4287d9e10a4d5','497977d3-5c8b-4500-b340-cc045ffa4a8e',238,'1e3df68b14c64c2eba82d76467788260','gigabytes',-2,'2025-11-23 05:59:12',NULL),('2025-11-22 05:59:12.784944',NULL,'2025-11-22 05:59:12.793939',872,872,NULL,'b694595f-007b-4f87-ae77-807d4ae44205',241,'1e3df68b14c64c2eba82d76467788260','shares',-1,'2025-11-23 05:59:12','6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:59:12.786080',NULL,'2025-11-22 05:59:12.793939',873,873,NULL,'74be6b42-13a6-4023-b55b-9ebf51c2a577',240,'1e3df68b14c64c2eba82d76467788260','gigabytes',-2,'2025-11-23 05:59:12','6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:59:13.825985',NULL,'2025-11-22 05:59:13.907398',874,874,'123ee1961f274fcf8727f7d4c1fb5248','fa139cf1-21b6-4402-aa59-6297ba2a0de0',254,'ef497337be194fcb9ce62d89ec4f8a5a','snapshots',1,'2025-11-23 05:59:13',NULL),('2025-11-22 05:59:13.827795',NULL,'2025-11-22 05:59:13.907398',875,875,'123ee1961f274fcf8727f7d4c1fb5248','66759095-7b3b-4dd6-885e-171a1c6bd603',255,'ef497337be194fcb9ce62d89ec4f8a5a','snapshot_gigabytes',1,'2025-11-23 05:59:13',NULL),('2025-11-22 05:59:13.838333',NULL,'2025-11-22 05:59:13.907398',876,876,NULL,'9be16eea-fce5-4399-bdbd-288225901451',256,'ef497337be194fcb9ce62d89ec4f8a5a','snapshots',1,'2025-11-23 05:59:13','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:13.840326',NULL,'2025-11-22 05:59:13.907398',877,877,NULL,'01c9a46e-c6ea-40d8-a36e-3d7fcff3e5b1',257,'ef497337be194fcb9ce62d89ec4f8a5a','snapshot_gigabytes',1,'2025-11-23 05:59:13','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:16.667479',NULL,'2025-11-22 05:59:16.682243',878,878,'010135c9a64149dbb6846c9a653da6b8','e024284a-9011-45f7-9c44-679590f14aa9',258,'325a0f56a64040c18ae384c10457495e','snapshots',-1,'2025-11-23 05:59:16',NULL),('2025-11-22 05:59:16.668313',NULL,'2025-11-22 05:59:16.682243',879,879,'010135c9a64149dbb6846c9a653da6b8','d5612293-2c43-41f2-b3fa-262ae8521815',259,'325a0f56a64040c18ae384c10457495e','snapshot_gigabytes',-1,'2025-11-23 05:59:16',NULL),('2025-11-22 05:59:16.673913',NULL,'2025-11-22 05:59:16.682243',880,880,NULL,'ae69e195-8e74-433f-bf6f-a84f4f10e92f',260,'325a0f56a64040c18ae384c10457495e','snapshots',-1,'2025-11-23 05:59:16','100c722e-6c00-4303-ac29-b6525536cfc3'),('2025-11-22 05:59:16.674717',NULL,'2025-11-22 05:59:16.682243',881,881,NULL,'6afeb504-50a0-4dfa-9d2e-54f4b016487b',261,'325a0f56a64040c18ae384c10457495e','snapshot_gigabytes',-1,'2025-11-23 05:59:16','100c722e-6c00-4303-ac29-b6525536cfc3'),('2025-11-22 05:59:18.397095',NULL,'2025-11-22 05:59:18.421576',882,882,'123ee1961f274fcf8727f7d4c1fb5248','8b3301a1-c388-4d12-8880-5bc524954de3',254,'ef497337be194fcb9ce62d89ec4f8a5a','snapshots',-1,'2025-11-23 05:59:18',NULL),('2025-11-22 05:59:18.398370',NULL,'2025-11-22 05:59:18.421576',883,883,'123ee1961f274fcf8727f7d4c1fb5248','61a63ceb-1e1d-41e1-bb20-8e9003cec9d8',255,'ef497337be194fcb9ce62d89ec4f8a5a','snapshot_gigabytes',-1,'2025-11-23 05:59:18',NULL),('2025-11-22 05:59:18.405107',NULL,'2025-11-22 05:59:18.421576',884,884,NULL,'b3629039-4016-4832-98db-d25b09fbbe30',256,'ef497337be194fcb9ce62d89ec4f8a5a','snapshots',-1,'2025-11-23 05:59:18','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:18.405784',NULL,'2025-11-22 05:59:18.421576',885,885,NULL,'d8e896b3-b793-4474-9c08-d75cde663242',257,'ef497337be194fcb9ce62d89ec4f8a5a','snapshot_gigabytes',-1,'2025-11-23 05:59:18','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:20.295110',NULL,'2025-11-22 05:59:20.343605',886,886,'010135c9a64149dbb6846c9a653da6b8','c9854476-b00c-498f-b792-1b80ea1f2efb',251,'325a0f56a64040c18ae384c10457495e','shares',-1,'2025-11-23 05:59:20',NULL),('2025-11-22 05:59:20.296526',NULL,'2025-11-22 05:59:20.343605',887,887,'010135c9a64149dbb6846c9a653da6b8','bd4494b9-ceac-45a5-a657-266d14855a4e',250,'325a0f56a64040c18ae384c10457495e','gigabytes',-1,'2025-11-23 05:59:20',NULL),('2025-11-22 05:59:20.324586',NULL,'2025-11-22 05:59:20.343605',888,888,NULL,'ad38f990-ce13-415c-8489-ce55a9866aa1',253,'325a0f56a64040c18ae384c10457495e','shares',-1,'2025-11-23 05:59:20','100c722e-6c00-4303-ac29-b6525536cfc3'),('2025-11-22 05:59:20.325866',NULL,'2025-11-22 05:59:20.343605',889,889,NULL,'7ea3542c-6ced-4617-bb06-1a11c8d86a93',252,'325a0f56a64040c18ae384c10457495e','gigabytes',-1,'2025-11-23 05:59:20','100c722e-6c00-4303-ac29-b6525536cfc3'),('2025-11-22 05:59:20.563628',NULL,'2025-11-22 05:59:20.606957',890,890,'3db9dedf9593479bbad4287d9e10a4d5','a783299b-2138-4a5c-b106-c3aa2dec0f33',239,'1e3df68b14c64c2eba82d76467788260','shares',1,'2025-11-23 05:59:20',NULL),('2025-11-22 05:59:20.565011',NULL,'2025-11-22 05:59:20.606957',891,891,'3db9dedf9593479bbad4287d9e10a4d5','20070b31-06be-4eae-9042-395b08709ae1',238,'1e3df68b14c64c2eba82d76467788260','gigabytes',2,'2025-11-23 05:59:20',NULL),('2025-11-22 05:59:20.580380',NULL,'2025-11-22 05:59:20.606957',892,892,NULL,'c6b22208-3c47-4805-90b5-e3b30cb462ea',241,'1e3df68b14c64c2eba82d76467788260','shares',1,'2025-11-23 05:59:20','6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:59:20.581502',NULL,'2025-11-22 05:59:20.606957',893,893,NULL,'b8140730-4474-409b-a57a-e955c40dbf2d',240,'1e3df68b14c64c2eba82d76467788260','gigabytes',2,'2025-11-23 05:59:20','6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:59:21.442832',NULL,'2025-11-22 05:59:21.560581',894,894,'123ee1961f274fcf8727f7d4c1fb5248','9027640b-b5b2-4fbf-b538-06460b56cb91',254,'ef497337be194fcb9ce62d89ec4f8a5a','snapshots',1,'2025-11-23 05:59:21',NULL),('2025-11-22 05:59:21.444159',NULL,'2025-11-22 05:59:21.560581',895,895,'123ee1961f274fcf8727f7d4c1fb5248','3910dafd-7e91-4ca7-b7ab-90ed4905b983',255,'ef497337be194fcb9ce62d89ec4f8a5a','snapshot_gigabytes',1,'2025-11-23 05:59:21',NULL),('2025-11-22 05:59:21.455509',NULL,'2025-11-22 05:59:21.560581',896,896,NULL,'f84e69cc-e259-4682-9979-353d055b3514',256,'ef497337be194fcb9ce62d89ec4f8a5a','snapshots',1,'2025-11-23 05:59:21','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:21.456846',NULL,'2025-11-22 05:59:21.560581',897,897,NULL,'5ff338b4-3364-495e-bb5f-a01203c35572',257,'ef497337be194fcb9ce62d89ec4f8a5a','snapshot_gigabytes',1,'2025-11-23 05:59:21','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:24.299738',NULL,'2025-11-22 05:59:24.337470',898,898,'3db9dedf9593479bbad4287d9e10a4d5','ef68dc42-fbfb-40da-a204-27b230042116',238,'1e3df68b14c64c2eba82d76467788260','gigabytes',-1,'2025-11-23 05:59:24',NULL),('2025-11-22 05:59:24.307374',NULL,'2025-11-22 05:59:24.337470',899,899,NULL,'8063c501-79ad-48b2-b0ab-35e3dbfe9af5',240,'1e3df68b14c64c2eba82d76467788260','gigabytes',-1,'2025-11-23 05:59:24','6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:59:27.025991',NULL,'2025-11-22 05:59:27.046098',900,900,'123ee1961f274fcf8727f7d4c1fb5248','52d44f78-1d4f-4b89-ba59-296f8979bff1',254,'ef497337be194fcb9ce62d89ec4f8a5a','snapshots',-1,'2025-11-23 05:59:26',NULL),('2025-11-22 05:59:27.026898',NULL,'2025-11-22 05:59:27.046098',901,901,'123ee1961f274fcf8727f7d4c1fb5248','9c451e45-a2aa-4c9d-b21c-9c33e74b5112',255,'ef497337be194fcb9ce62d89ec4f8a5a','snapshot_gigabytes',-1,'2025-11-23 05:59:26',NULL),('2025-11-22 05:59:27.034142',NULL,'2025-11-22 05:59:27.046098',902,902,NULL,'0c24e4bd-eefe-4d64-be89-7aff54acc8fa',256,'ef497337be194fcb9ce62d89ec4f8a5a','snapshots',-1,'2025-11-23 05:59:26','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:27.035011',NULL,'2025-11-22 05:59:27.046098',903,903,NULL,'d037e8b4-0585-405b-a0e3-96ee66164493',257,'ef497337be194fcb9ce62d89ec4f8a5a','snapshot_gigabytes',-1,'2025-11-23 05:59:26','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:28.226532',NULL,'2025-11-22 05:59:28.246802',904,904,'3db9dedf9593479bbad4287d9e10a4d5','e078f5dc-e3bc-483f-894f-e43bde08262d',239,'1e3df68b14c64c2eba82d76467788260','shares',-1,'2025-11-23 05:59:28',NULL),('2025-11-22 05:59:28.227564',NULL,'2025-11-22 05:59:28.246802',905,905,'3db9dedf9593479bbad4287d9e10a4d5','06035551-5529-4a5b-a656-0ac33f203c37',238,'1e3df68b14c64c2eba82d76467788260','gigabytes',-1,'2025-11-23 05:59:28',NULL),('2025-11-22 05:59:28.236884',NULL,'2025-11-22 05:59:28.246802',906,906,NULL,'2120bba6-9fc6-476f-91ee-08767272c34d',241,'1e3df68b14c64c2eba82d76467788260','shares',-1,'2025-11-23 05:59:28','6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:59:28.237651',NULL,'2025-11-22 05:59:28.246802',907,907,NULL,'f4d9e4ba-243a-46e0-a358-79226f0dea4a',240,'1e3df68b14c64c2eba82d76467788260','gigabytes',-1,'2025-11-23 05:59:28','6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:59:30.185666',NULL,'2025-11-22 05:59:30.280806',908,908,'123ee1961f274fcf8727f7d4c1fb5248','960fb78c-d7c4-4d69-9e28-b749373d76cd',254,'ef497337be194fcb9ce62d89ec4f8a5a','snapshots',1,'2025-11-23 05:59:30',NULL),('2025-11-22 05:59:30.186858',NULL,'2025-11-22 05:59:30.280806',909,909,'123ee1961f274fcf8727f7d4c1fb5248','3d87a49c-0fa0-495d-99b0-a98c1a6a0cb6',255,'ef497337be194fcb9ce62d89ec4f8a5a','snapshot_gigabytes',1,'2025-11-23 05:59:30',NULL),('2025-11-22 05:59:30.208471',NULL,'2025-11-22 05:59:30.280806',910,910,NULL,'861eea56-4732-4deb-bfd8-6bece14f7b10',256,'ef497337be194fcb9ce62d89ec4f8a5a','snapshots',1,'2025-11-23 05:59:30','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:30.210447',NULL,'2025-11-22 05:59:30.280806',911,911,NULL,'6d93eabf-b108-43b6-b81d-e38ac1cef0f1',257,'ef497337be194fcb9ce62d89ec4f8a5a','snapshot_gigabytes',1,'2025-11-23 05:59:30','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:31.414589',NULL,'2025-11-22 05:59:31.449117',912,912,'3db9dedf9593479bbad4287d9e10a4d5','94ab3ad1-0b72-4ba0-9004-b33295b6f757',239,'1e3df68b14c64c2eba82d76467788260','shares',1,'2025-11-23 05:59:31',NULL),('2025-11-22 05:59:31.416076',NULL,'2025-11-22 05:59:31.449117',913,913,'3db9dedf9593479bbad4287d9e10a4d5','4a4901e1-ede2-445a-b527-43c155e37e6c',238,'1e3df68b14c64c2eba82d76467788260','gigabytes',1,'2025-11-23 05:59:31',NULL),('2025-11-22 05:59:31.423213',NULL,'2025-11-22 05:59:31.449117',914,914,NULL,'b38a7ab4-50e4-453e-a422-a22e83f55825',241,'1e3df68b14c64c2eba82d76467788260','shares',1,'2025-11-23 05:59:31','6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:59:31.424697',NULL,'2025-11-22 05:59:31.449117',915,915,NULL,'7349e4a8-ca12-4f83-8ec2-eced193cdcf4',240,'1e3df68b14c64c2eba82d76467788260','gigabytes',1,'2025-11-23 05:59:31','6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:59:34.369309',NULL,'2025-11-22 05:59:34.388498',916,916,'123ee1961f274fcf8727f7d4c1fb5248','972bdcc6-15a3-4703-be81-44a01efb9ab9',254,'ef497337be194fcb9ce62d89ec4f8a5a','snapshots',-1,'2025-11-23 05:59:34',NULL),('2025-11-22 05:59:34.370220',NULL,'2025-11-22 05:59:34.388498',917,917,'123ee1961f274fcf8727f7d4c1fb5248','979d7349-f784-4406-9941-38df6fdbd721',255,'ef497337be194fcb9ce62d89ec4f8a5a','snapshot_gigabytes',-1,'2025-11-23 05:59:34',NULL),('2025-11-22 05:59:34.378618',NULL,'2025-11-22 05:59:34.388498',918,918,NULL,'f26fb3a5-77aa-4874-8e16-9a41c1020824',256,'ef497337be194fcb9ce62d89ec4f8a5a','snapshots',-1,'2025-11-23 05:59:34','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:34.379803',NULL,'2025-11-22 05:59:34.388498',919,919,NULL,'3c19f8a4-4b4d-4557-993e-8dab17a497fc',257,'ef497337be194fcb9ce62d89ec4f8a5a','snapshot_gigabytes',-1,'2025-11-23 05:59:34','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:36.774323',NULL,'2025-11-22 05:59:36.789449',920,920,'3db9dedf9593479bbad4287d9e10a4d5','2b5ae30b-d055-492c-a2b8-2af137f27bdb',239,'1e3df68b14c64c2eba82d76467788260','shares',-1,'2025-11-23 05:59:36',NULL),('2025-11-22 05:59:36.775172',NULL,'2025-11-22 05:59:36.789449',921,921,'3db9dedf9593479bbad4287d9e10a4d5','b2a8ccc6-7536-4c54-b9c2-5b1a58f7124c',238,'1e3df68b14c64c2eba82d76467788260','gigabytes',-1,'2025-11-23 05:59:36',NULL),('2025-11-22 05:59:36.782214',NULL,'2025-11-22 05:59:36.789449',922,922,NULL,'20bd9137-4c50-41b0-81cb-8dbafdfe5077',241,'1e3df68b14c64c2eba82d76467788260','shares',-1,'2025-11-23 05:59:36','6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:59:36.782879',NULL,'2025-11-22 05:59:36.789449',923,923,NULL,'3a35af30-b8fc-482e-8ee7-92982e6c50ef',240,'1e3df68b14c64c2eba82d76467788260','gigabytes',-1,'2025-11-23 05:59:36','6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:59:37.424781',NULL,'2025-11-22 05:59:37.503637',924,924,'123ee1961f274fcf8727f7d4c1fb5248','0593b6ca-0f53-4668-beb8-21573b6a75d1',254,'ef497337be194fcb9ce62d89ec4f8a5a','snapshots',1,'2025-11-23 05:59:37',NULL),('2025-11-22 05:59:37.426094',NULL,'2025-11-22 05:59:37.503637',925,925,'123ee1961f274fcf8727f7d4c1fb5248','1986c156-b2e6-4dc3-b4b5-084ec902efa9',255,'ef497337be194fcb9ce62d89ec4f8a5a','snapshot_gigabytes',1,'2025-11-23 05:59:37',NULL),('2025-11-22 05:59:37.434882',NULL,'2025-11-22 05:59:37.503637',926,926,NULL,'0826c1c8-6fe0-43f6-a5d3-3e9886563cac',256,'ef497337be194fcb9ce62d89ec4f8a5a','snapshots',1,'2025-11-23 05:59:37','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:37.436405',NULL,'2025-11-22 05:59:37.503637',927,927,NULL,'ffef01c6-2575-4a84-beba-1767f4074589',257,'ef497337be194fcb9ce62d89ec4f8a5a','snapshot_gigabytes',1,'2025-11-23 05:59:37','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:40.286365',NULL,'2025-11-22 05:59:40.303741',928,928,'3db9dedf9593479bbad4287d9e10a4d5','b0f709b5-891b-4506-b963-839b0126869f',239,'1e3df68b14c64c2eba82d76467788260','shares',-1,'2025-11-23 05:59:40',NULL),('2025-11-22 05:59:40.287061',NULL,'2025-11-22 05:59:40.303741',929,929,'3db9dedf9593479bbad4287d9e10a4d5','329f4d2a-0ee3-4307-b2c4-ea232b2965a2',238,'1e3df68b14c64c2eba82d76467788260','gigabytes',-1,'2025-11-23 05:59:40',NULL),('2025-11-22 05:59:40.296071',NULL,'2025-11-22 05:59:40.303741',930,930,NULL,'7ba44d0d-c062-4e98-a70b-124f460a43d5',241,'1e3df68b14c64c2eba82d76467788260','shares',-1,'2025-11-23 05:59:40','6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:59:40.296813',NULL,'2025-11-22 05:59:40.303741',931,931,NULL,'ed0b298c-e592-43d0-a541-54d094b86b05',240,'1e3df68b14c64c2eba82d76467788260','gigabytes',-1,'2025-11-23 05:59:40','6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:59:42.847358',NULL,'2025-11-22 05:59:42.864412',932,932,'123ee1961f274fcf8727f7d4c1fb5248','7946b20e-0d1d-470e-adf5-1e7dbec3fae5',254,'ef497337be194fcb9ce62d89ec4f8a5a','snapshots',-1,'2025-11-23 05:59:42',NULL),('2025-11-22 05:59:42.848341',NULL,'2025-11-22 05:59:42.864412',933,933,'123ee1961f274fcf8727f7d4c1fb5248','dbdf67a1-9033-40d8-aba4-ee00a1c56f75',255,'ef497337be194fcb9ce62d89ec4f8a5a','snapshot_gigabytes',-1,'2025-11-23 05:59:42',NULL),('2025-11-22 05:59:42.854811',NULL,'2025-11-22 05:59:42.864412',934,934,NULL,'fdb15056-1379-4e1f-a515-e7dd1fde5269',256,'ef497337be194fcb9ce62d89ec4f8a5a','snapshots',-1,'2025-11-23 05:59:42','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:42.855788',NULL,'2025-11-22 05:59:42.864412',935,935,NULL,'9b52adae-f411-4c65-b7f6-4ead8da493f4',257,'ef497337be194fcb9ce62d89ec4f8a5a','snapshot_gigabytes',-1,'2025-11-23 05:59:42','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:43.755559',NULL,'2025-11-22 05:59:44.048017',936,936,'3db9dedf9593479bbad4287d9e10a4d5','07938ff0-2bc5-4e5c-8353-a6f0679e5940',243,'1e3df68b14c64c2eba82d76467788260','snapshots',-1,'2025-11-23 05:59:43',NULL),('2025-11-22 05:59:43.756739',NULL,'2025-11-22 05:59:44.048017',937,937,'3db9dedf9593479bbad4287d9e10a4d5','26d7bfa7-75d5-4d3e-8078-313fc896c1d0',242,'1e3df68b14c64c2eba82d76467788260','snapshot_gigabytes',-1,'2025-11-23 05:59:43',NULL),('2025-11-22 05:59:43.879764',NULL,'2025-11-22 05:59:44.048017',938,938,NULL,'071491a7-fadf-47f9-a996-1baea9b458f6',245,'1e3df68b14c64c2eba82d76467788260','snapshots',-1,'2025-11-23 05:59:43','6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:59:43.880523',NULL,'2025-11-22 05:59:44.048017',939,939,NULL,'bfb0fb27-0579-40a4-a33e-0206a3950319',244,'1e3df68b14c64c2eba82d76467788260','snapshot_gigabytes',-1,'2025-11-23 05:59:43','6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:59:47.083470',NULL,'2025-11-22 05:59:47.108368',940,940,'3db9dedf9593479bbad4287d9e10a4d5','f4b3f0ab-49d3-475c-8a39-f39df064d294',239,'1e3df68b14c64c2eba82d76467788260','shares',-1,'2025-11-23 05:59:47',NULL),('2025-11-22 05:59:47.084663',NULL,'2025-11-22 05:59:47.108368',941,941,'3db9dedf9593479bbad4287d9e10a4d5','27bcea8e-c317-4d91-aa0b-c8702fa2bf90',238,'1e3df68b14c64c2eba82d76467788260','gigabytes',-1,'2025-11-23 05:59:47',NULL),('2025-11-22 05:59:47.092819',NULL,'2025-11-22 05:59:47.108368',942,942,NULL,'1e6287a4-afa6-4da3-83e4-107b4c1cabb9',241,'1e3df68b14c64c2eba82d76467788260','shares',-1,'2025-11-23 05:59:47','6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:59:47.093918',NULL,'2025-11-22 05:59:47.108368',943,943,NULL,'9e8e1cd4-06f7-4e3a-83c2-2e197ca821e6',240,'1e3df68b14c64c2eba82d76467788260','gigabytes',-1,'2025-11-23 05:59:47','6630451a-185f-4b7a-8306-f600314a71e1'),('2025-11-22 05:59:47.143898',NULL,'2025-11-22 05:59:47.212034',944,944,'123ee1961f274fcf8727f7d4c1fb5248','ca93ca9e-8ef1-4119-aa4e-93fdade5eec3',254,'ef497337be194fcb9ce62d89ec4f8a5a','snapshots',1,'2025-11-23 05:59:47',NULL),('2025-11-22 05:59:47.145528',NULL,'2025-11-22 05:59:47.212034',945,945,'123ee1961f274fcf8727f7d4c1fb5248','d467370a-3c31-457b-8d8b-b1e3b1278d15',255,'ef497337be194fcb9ce62d89ec4f8a5a','snapshot_gigabytes',1,'2025-11-23 05:59:47',NULL),('2025-11-22 05:59:47.150716',NULL,'2025-11-22 05:59:47.212034',946,946,NULL,'4681dbe0-8dda-4b15-bf58-7c5824e3e381',256,'ef497337be194fcb9ce62d89ec4f8a5a','snapshots',1,'2025-11-23 05:59:47','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:47.151707',NULL,'2025-11-22 05:59:47.212034',947,947,NULL,'59af48ca-8d42-4af6-b3ba-47187458853c',257,'ef497337be194fcb9ce62d89ec4f8a5a','snapshot_gigabytes',1,'2025-11-23 05:59:47','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:53.054479',NULL,'2025-11-22 05:59:53.093728',948,948,'123ee1961f274fcf8727f7d4c1fb5248','dc9bba69-ecc4-4449-b581-da8a44063048',254,'ef497337be194fcb9ce62d89ec4f8a5a','snapshots',-1,'2025-11-23 05:59:53',NULL),('2025-11-22 05:59:53.055834',NULL,'2025-11-22 05:59:53.093728',949,949,'123ee1961f274fcf8727f7d4c1fb5248','d316edab-d884-4ea1-a419-e18488a92136',255,'ef497337be194fcb9ce62d89ec4f8a5a','snapshot_gigabytes',-1,'2025-11-23 05:59:53',NULL),('2025-11-22 05:59:53.074927',NULL,'2025-11-22 05:59:53.093728',950,950,NULL,'998c0c14-f9f3-486a-b128-69b6fd2af43b',256,'ef497337be194fcb9ce62d89ec4f8a5a','snapshots',-1,'2025-11-23 05:59:53','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:53.076668',NULL,'2025-11-22 05:59:53.093728',951,951,NULL,'0d3aa482-6a32-4c29-a71d-c24e5c2ba049',257,'ef497337be194fcb9ce62d89ec4f8a5a','snapshot_gigabytes',-1,'2025-11-23 05:59:53','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:56.563843',NULL,'2025-11-22 05:59:56.597826',952,952,'123ee1961f274fcf8727f7d4c1fb5248','c74924c9-4fcf-47d7-b7df-a6586fc73bac',254,'ef497337be194fcb9ce62d89ec4f8a5a','snapshots',-1,'2025-11-23 05:59:56',NULL),('2025-11-22 05:59:56.564818',NULL,'2025-11-22 05:59:56.597826',953,953,'123ee1961f274fcf8727f7d4c1fb5248','aac96248-dcca-429d-b3e7-5e0e969fb1ca',255,'ef497337be194fcb9ce62d89ec4f8a5a','snapshot_gigabytes',-1,'2025-11-23 05:59:56',NULL),('2025-11-22 05:59:56.580144',NULL,'2025-11-22 05:59:56.597826',954,954,NULL,'e04083e6-1bdf-43d8-82cd-356c2103021b',256,'ef497337be194fcb9ce62d89ec4f8a5a','snapshots',-1,'2025-11-23 05:59:56','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:56.581169',NULL,'2025-11-22 05:59:56.597826',955,955,NULL,'bcfb1c0e-8327-4b58-b09f-ef98422529eb',257,'ef497337be194fcb9ce62d89ec4f8a5a','snapshot_gigabytes',-1,'2025-11-23 05:59:56','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 05:59:59.344741',NULL,'2025-11-22 05:59:59.412888',956,956,'a1a7cc23204c4cc98f8e932daf5aa165','664cc36a-00d5-4234-b1bd-df50bd204205',263,'39cd34e3d99d4413afb1c277d92dcf8f','shares',1,'2025-11-23 05:59:59',NULL),('2025-11-22 05:59:59.346904',NULL,'2025-11-22 05:59:59.412888',957,957,'a1a7cc23204c4cc98f8e932daf5aa165','f7f7b666-5f97-4e0b-9d4f-907f4acd095d',262,'39cd34e3d99d4413afb1c277d92dcf8f','gigabytes',1,'2025-11-23 05:59:59',NULL),('2025-11-22 05:59:59.360703',NULL,'2025-11-22 05:59:59.412888',958,958,NULL,'f50589f0-5cd7-4324-85c3-fe542e112f8a',265,'39cd34e3d99d4413afb1c277d92dcf8f','shares',1,'2025-11-23 05:59:59','4940c47f-fec8-4869-8fba-d842e9b292ea'),('2025-11-22 05:59:59.369015',NULL,'2025-11-22 05:59:59.412888',959,959,NULL,'a2fab55e-d4f0-4d49-b84b-122afab037c2',264,'39cd34e3d99d4413afb1c277d92dcf8f','gigabytes',1,'2025-11-23 05:59:59','4940c47f-fec8-4869-8fba-d842e9b292ea'),('2025-11-22 06:00:00.116612',NULL,'2025-11-22 06:00:00.152809',960,960,'123ee1961f274fcf8727f7d4c1fb5248','7bd291fd-2aae-4c19-90ee-7f8d89f461bc',247,'ef497337be194fcb9ce62d89ec4f8a5a','shares',-1,'2025-11-23 06:00:00',NULL),('2025-11-22 06:00:00.117537',NULL,'2025-11-22 06:00:00.152809',961,961,'123ee1961f274fcf8727f7d4c1fb5248','e6f0ab69-862f-40a8-86e6-7ea30149f9bd',246,'ef497337be194fcb9ce62d89ec4f8a5a','gigabytes',-1,'2025-11-23 06:00:00',NULL),('2025-11-22 06:00:00.128780',NULL,'2025-11-22 06:00:00.152809',962,962,NULL,'9872e071-de98-4011-9be0-8d6335fa058d',249,'ef497337be194fcb9ce62d89ec4f8a5a','shares',-1,'2025-11-23 06:00:00','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 06:00:00.129531',NULL,'2025-11-22 06:00:00.152809',963,963,NULL,'ba16c64d-74c6-4871-8cb6-cbadcd4d7ec9',248,'ef497337be194fcb9ce62d89ec4f8a5a','gigabytes',-1,'2025-11-23 06:00:00','229f2490-4a8a-45d0-973b-52a743d76f0f'),('2025-11-22 06:00:02.855576',NULL,'2025-11-22 06:00:02.933375',964,964,'a1a7cc23204c4cc98f8e932daf5aa165','1e7545d8-4b20-4bf3-add2-57df90f3ef57',266,'39cd34e3d99d4413afb1c277d92dcf8f','snapshots',1,'2025-11-23 06:00:02',NULL),('2025-11-22 06:00:02.857476',NULL,'2025-11-22 06:00:02.933375',965,965,'a1a7cc23204c4cc98f8e932daf5aa165','d656fce5-a34b-4e35-b57e-bd4221d61b5c',267,'39cd34e3d99d4413afb1c277d92dcf8f','snapshot_gigabytes',1,'2025-11-23 06:00:02',NULL),('2025-11-22 06:00:02.874982',NULL,'2025-11-22 06:00:02.933375',966,966,NULL,'ed3494fa-3d1f-48f6-80a8-b4b33caaaef1',268,'39cd34e3d99d4413afb1c277d92dcf8f','snapshots',1,'2025-11-23 06:00:02','4940c47f-fec8-4869-8fba-d842e9b292ea'),('2025-11-22 06:00:02.877350',NULL,'2025-11-22 06:00:02.933375',967,967,NULL,'9e4b33b7-4d48-4a55-bc77-cbf8cfb71c2e',269,'39cd34e3d99d4413afb1c277d92dcf8f','snapshot_gigabytes',1,'2025-11-23 06:00:02','4940c47f-fec8-4869-8fba-d842e9b292ea'),('2025-11-22 06:00:08.516308',NULL,'2025-11-22 06:00:08.528485',968,968,'a1a7cc23204c4cc98f8e932daf5aa165','d0d74353-f231-436a-b0fe-359dd21bc2b6',266,'39cd34e3d99d4413afb1c277d92dcf8f','snapshots',-1,'2025-11-23 06:00:08',NULL),('2025-11-22 06:00:08.517003',NULL,'2025-11-22 06:00:08.528485',969,969,'a1a7cc23204c4cc98f8e932daf5aa165','4c6d206d-e44e-4759-b52d-d0c19d0e4071',267,'39cd34e3d99d4413afb1c277d92dcf8f','snapshot_gigabytes',-1,'2025-11-23 06:00:08',NULL),('2025-11-22 06:00:08.521574',NULL,'2025-11-22 06:00:08.528485',970,970,NULL,'d59f9289-8870-4cdc-9650-e569b16264d4',268,'39cd34e3d99d4413afb1c277d92dcf8f','snapshots',-1,'2025-11-23 06:00:08','4940c47f-fec8-4869-8fba-d842e9b292ea'),('2025-11-22 06:00:08.522155',NULL,'2025-11-22 06:00:08.528485',971,971,NULL,'57cf18d6-6e56-4e38-9af9-fb6aec2a5fff',269,'39cd34e3d99d4413afb1c277d92dcf8f','snapshot_gigabytes',-1,'2025-11-23 06:00:08','4940c47f-fec8-4869-8fba-d842e9b292ea'),('2025-11-22 06:00:12.201177',NULL,'2025-11-22 06:00:12.262612',972,972,'a1a7cc23204c4cc98f8e932daf5aa165','85df157c-a6c8-405e-a21d-4c232db9b360',263,'39cd34e3d99d4413afb1c277d92dcf8f','shares',-1,'2025-11-23 06:00:12',NULL),('2025-11-22 06:00:12.202489',NULL,'2025-11-22 06:00:12.262612',973,973,'a1a7cc23204c4cc98f8e932daf5aa165','cb2e3799-3a0b-4e68-b0c1-79b65e400762',262,'39cd34e3d99d4413afb1c277d92dcf8f','gigabytes',-1,'2025-11-23 06:00:12',NULL),('2025-11-22 06:00:12.243635',NULL,'2025-11-22 06:00:12.262612',974,974,NULL,'86e596d3-12b0-48d2-bf2e-b75d777c9d1b',265,'39cd34e3d99d4413afb1c277d92dcf8f','shares',-1,'2025-11-23 06:00:12','4940c47f-fec8-4869-8fba-d842e9b292ea'),('2025-11-22 06:00:12.245079',NULL,'2025-11-22 06:00:12.262612',975,975,NULL,'867f55a5-60eb-49ac-b60a-eb88614e7ac4',264,'39cd34e3d99d4413afb1c277d92dcf8f','gigabytes',-1,'2025-11-23 06:00:12','4940c47f-fec8-4869-8fba-d842e9b292ea');
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `security_services`
--

DROP TABLE IF EXISTS `security_services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `security_services` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `type` varchar(32) NOT NULL,
  `dns_ip` varchar(64) DEFAULT NULL,
  `server` varchar(255) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `user` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `ou` varchar(255) DEFAULT NULL,
  `default_ad_site` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `security_services`
--

LOCK TABLES `security_services` WRITE;
/*!40000 ALTER TABLE `security_services` DISABLE KEYS */;
INSERT INTO `security_services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `type`, `dns_ip`, `server`, `domain`, `user`, `password`, `name`, `description`, `ou`, `default_ad_site`) VALUES ('2025-11-22 05:55:30.739735','2025-11-22 05:55:31.221615','2025-11-22 05:55:31.221331','069c0055-5430-419c-b124-dbfb3cc2d17e','069c0055-5430-419c-b124-dbfb3cc2d17e','3a30a5c5a0f0497d95a109c5526ede86','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-11-22 05:55:50.338970','2025-11-22 05:55:50.581154','2025-11-22 05:55:50.580869','06addfae-8319-4f4d-beb6-84a9f3af0394','06addfae-8319-4f4d-beb6-84a9f3af0394','b65ccd7e2f5f4f95959c8fb179b60b78','ldap','203.0.113.144','203.0.113.245','tempest-ss-domain-2137492504','tempest-ss-user-607471049','tempest-ss-password-1839909597','tempest-ss-name-1800519025','tempest-ss-desc-442980136',NULL,NULL),('2025-11-22 05:55:31.501476','2025-11-22 05:55:31.659618','2025-11-22 05:55:31.659312','0aa68fc8-e768-4887-b47d-01eb13c7fc44','0aa68fc8-e768-4887-b47d-01eb13c7fc44','3a30a5c5a0f0497d95a109c5526ede86','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-11-22 05:55:33.909235','2025-11-22 05:55:34.598645','2025-11-22 05:55:34.598245','0f6008ac-794c-4e37-a52e-4f53e53fc970','0f6008ac-794c-4e37-a52e-4f53e53fc970','3a30a5c5a0f0497d95a109c5526ede86','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-11-22 05:55:32.616094','2025-11-22 05:55:32.838021','2025-11-22 05:55:32.837550','1080838f-125a-485f-b893-215f8a95119f','1080838f-125a-485f-b893-215f8a95119f','3a30a5c5a0f0497d95a109c5526ede86','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-11-22 05:51:52.183485','2025-11-22 05:51:52.621573','2025-11-22 05:51:52.621071','12b10275-d7cb-465f-b0af-a8971e7dd8da','12b10275-d7cb-465f-b0af-a8971e7dd8da','790f13450b2540d1bdb71104fcc67ddf','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-11-22 05:51:53.497839','2025-11-22 05:51:53.654570','2025-11-22 05:51:53.653840','178e9382-74a8-452b-b174-fb7e433a8dea','178e9382-74a8-452b-b174-fb7e433a8dea','790f13450b2540d1bdb71104fcc67ddf','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-11-22 05:55:50.272618',NULL,NULL,'False','19479d61-c4b4-4cd6-a641-6bbd988add8f','b65ccd7e2f5f4f95959c8fb179b60b78','ldap','203.0.113.70','203.0.113.201','tempest-ss-domain-996998296','tempest-ss-user-1533890877','tempest-ss-password-1218595845','tempest-ss-name-1115712556','tempest-ss-desc-198509457',NULL,NULL),('2025-11-22 05:51:56.660987','2025-11-22 05:51:56.820851','2025-11-22 05:51:56.820515','19cdc6af-b974-4e26-a396-e21398b9d95a','19cdc6af-b974-4e26-a396-e21398b9d95a','790f13450b2540d1bdb71104fcc67ddf','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-11-22 05:55:33.352441','2025-11-22 05:55:33.785371','2025-11-22 05:55:33.785057','1a698706-f81a-4064-90a5-768aa265ae44','1a698706-f81a-4064-90a5-768aa265ae44','3a30a5c5a0f0497d95a109c5526ede86','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-11-22 05:55:36.933010','2025-11-22 05:55:38.550732','2025-11-22 05:55:38.550161','1b0ab5d8-193a-44d5-a741-ac94223fbf79','1b0ab5d8-193a-44d5-a741-ac94223fbf79','3a30a5c5a0f0497d95a109c5526ede86','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-11-22 05:51:52.244779','2025-11-22 05:51:52.445229','2025-11-22 05:51:52.444845','23163dd5-f60d-48ab-8906-8dc7dce957ff','23163dd5-f60d-48ab-8906-8dc7dce957ff','790f13450b2540d1bdb71104fcc67ddf','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-11-22 05:55:28.563952','2025-11-22 05:55:28.715500','2025-11-22 05:55:28.715125','26b53601-df2c-472d-9be4-bf22ef6a3ee5','26b53601-df2c-472d-9be4-bf22ef6a3ee5','3a30a5c5a0f0497d95a109c5526ede86','ldap','203.0.113.249','203.0.113.121','tempest-ss-domain-139187602','tempest-ss-user-1998035981','tempest-ss-password-503498262','tempest-ss-name-671306145','tempest-ss-desc-660157500','tempest-ss-ou-875081023',NULL),('2025-11-22 05:51:56.596370','2025-11-22 05:51:57.002533','2025-11-22 05:51:57.002247','35eed26e-8438-429f-a6c8-dc81fc249792','35eed26e-8438-429f-a6c8-dc81fc249792','790f13450b2540d1bdb71104fcc67ddf','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-11-22 05:55:32.125631','2025-11-22 05:55:32.187410','2025-11-22 05:55:32.187102','382239a0-ab04-4305-9b6d-9f19f8db71e9','382239a0-ab04-4305-9b6d-9f19f8db71e9','3a30a5c5a0f0497d95a109c5526ede86','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-11-22 05:51:52.763794','2025-11-22 05:51:53.227409','2025-11-22 05:51:53.227034','3b7bbb0b-e9bd-4043-8fa6-5cf19a42d22e','3b7bbb0b-e9bd-4043-8fa6-5cf19a42d22e','790f13450b2540d1bdb71104fcc67ddf','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-11-22 05:55:30.107715','2025-11-22 05:55:30.236493','2025-11-22 05:55:30.236088','3f2ad4d7-cb7c-4f6a-95f9-51b11383bccf','3f2ad4d7-cb7c-4f6a-95f9-51b11383bccf','3a30a5c5a0f0497d95a109c5526ede86','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-11-22 05:51:53.983804','2025-11-22 05:51:54.331206','2025-11-22 05:51:54.330917','4367d3f7-5ffd-47c7-9879-ceaa5e351595','4367d3f7-5ffd-47c7-9879-ceaa5e351595','790f13450b2540d1bdb71104fcc67ddf','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2002-02-02 00:00:00.000000',NULL,NULL,'False','45150344-e500-4901-9614-73868ee2b61c','b59c82aac0154932bb0672ff00781e5f','kerberos',NULL,NULL,NULL,NULL,NULL,'sn_with_ldap_ss','fake description',NULL,NULL),('2025-11-22 05:51:56.177672','2025-11-22 05:51:56.354902','2025-11-22 05:51:56.354574','45776ba3-1df0-4783-9c5c-44910b656dc8','45776ba3-1df0-4783-9c5c-44910b656dc8','790f13450b2540d1bdb71104fcc67ddf','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-11-22 05:55:35.873894','2025-11-22 05:55:36.223555','2025-11-22 05:55:36.223088','56f9124d-dc2b-4059-8b47-a3ef97cd99ed','56f9124d-dc2b-4059-8b47-a3ef97cd99ed','38ed23b5848e449b9e9b0e53a7f96916','ldap','203.0.113.247','203.0.113.47','tempest-ss-domain-1240296967','tempest-ss-user-1308981709','tempest-ss-password-1450737568','tempest-ss-name-1145587679','tempest-ss-desc-630848992',NULL,NULL),('2025-11-22 05:55:27.067513','2025-11-22 05:55:27.330078','2025-11-22 05:55:27.329736','585c4a85-698d-4c91-a7b1-771db0c2801a','585c4a85-698d-4c91-a7b1-771db0c2801a','3a30a5c5a0f0497d95a109c5526ede86','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-11-22 05:55:35.660045','2025-11-22 05:55:36.432726','2025-11-22 05:55:36.432253','59c94f53-c6ec-467e-a043-864f9b598bfa','59c94f53-c6ec-467e-a043-864f9b598bfa','3a30a5c5a0f0497d95a109c5526ede86','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-11-22 05:55:26.335208','2025-11-22 05:55:26.488832','2025-11-22 05:55:26.488489','5c7cf349-e14e-481a-abca-213baec65751','5c7cf349-e14e-481a-abca-213baec65751','3a30a5c5a0f0497d95a109c5526ede86','active_directory','203.0.113.114','203.0.113.206','tempest-ss-domain-1102391233','tempest-ss-user-767000261','tempest-ss-password-1800103392','tempest-ss-name-601039200','tempest-ss-desc-1739477868',NULL,NULL),('2025-11-22 05:51:54.670824','2025-11-22 05:51:54.844787','2025-11-22 05:51:54.844511','5fb07100-d9ff-43c7-891a-6cf07939eadd','5fb07100-d9ff-43c7-891a-6cf07939eadd','790f13450b2540d1bdb71104fcc67ddf','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-11-22 05:55:30.941604','2025-11-22 05:55:31.079777','2025-11-22 05:55:31.079433','6382bdf1-e042-4491-8d06-28ffcca1e3b1','6382bdf1-e042-4491-8d06-28ffcca1e3b1','3a30a5c5a0f0497d95a109c5526ede86','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-11-22 05:51:56.061147','2025-11-22 05:51:56.466155','2025-11-22 05:51:56.465818','6420462e-b7d6-4afe-ab21-89c4af6e3a1a','6420462e-b7d6-4afe-ab21-89c4af6e3a1a','790f13450b2540d1bdb71104fcc67ddf','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-11-22 05:55:33.978894','2025-11-22 05:55:34.143495','2025-11-22 05:55:34.142996','68572f82-da61-4019-8b1c-1058385596b4','68572f82-da61-4019-8b1c-1058385596b4','3a30a5c5a0f0497d95a109c5526ede86','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2002-02-02 00:00:00.000000',NULL,NULL,'False','68ed71e6-bdaa-495c-ba11-10081ad6d5ed','3520b2bd18fe4bc198c9b3ae61849514','kerberos',NULL,NULL,NULL,NULL,NULL,'sn_with_ldap_ss','fake description',NULL,NULL),('2025-11-22 05:55:47.532230',NULL,NULL,'False','6eab75c0-94d4-40c4-a203-49bce98e459b','b65ccd7e2f5f4f95959c8fb179b60b78','ldap',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-22 05:55:27.534044','2025-11-22 05:55:28.271810','2025-11-22 05:55:28.271354','6fccebe6-a270-4a4d-be87-7e9b8b9f8c97','6fccebe6-a270-4a4d-be87-7e9b8b9f8c97','3a30a5c5a0f0497d95a109c5526ede86','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-11-22 05:51:54.056954','2025-11-22 05:51:54.156674','2025-11-22 05:51:54.155748','7dee113c-391f-4fb9-b5bb-4d62edaa1717','7dee113c-391f-4fb9-b5bb-4d62edaa1717','790f13450b2540d1bdb71104fcc67ddf','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-11-22 05:55:33.451145','2025-11-22 05:55:33.670392','2025-11-22 05:55:33.670092','85b3d9ae-da5e-4e89-aa67-25ac6a85a026','85b3d9ae-da5e-4e89-aa67-25ac6a85a026','3a30a5c5a0f0497d95a109c5526ede86','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-11-22 05:55:25.862836','2025-11-22 05:55:26.818176','2025-11-22 05:55:26.817800','8d50567a-e22c-463b-9439-0c412653b110','8d50567a-e22c-463b-9439-0c412653b110','3a30a5c5a0f0497d95a109c5526ede86','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-11-22 05:55:29.950622','2025-11-22 05:55:30.403586','2025-11-22 05:55:30.403195','90414fc4-411b-402e-9400-e14bfa166329','90414fc4-411b-402e-9400-e14bfa166329','3a30a5c5a0f0497d95a109c5526ede86','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-11-22 05:55:29.186346','2025-11-22 05:55:29.775689','2025-11-22 05:55:29.775195','91ade593-5b25-4b9c-a2b7-bfb47c0804a2','91ade593-5b25-4b9c-a2b7-bfb47c0804a2','3a30a5c5a0f0497d95a109c5526ede86','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-11-22 05:58:21.129638','2025-11-22 05:58:21.519281','2025-11-22 05:58:21.518903','94a5f102-699e-436f-9a7d-b14fb9d4a1e5','94a5f102-699e-436f-9a7d-b14fb9d4a1e5','b69436f6d3194929ace36172443c8bfa','ldap','203.0.113.232','203.0.113.29','tempest-ss-domain-974739347','tempest-ss-user-1901839996','tempest-ss-password-2055594940','tempest-ss-name-1601472976','tempest-ss-desc-1915650363',NULL,NULL),('2025-11-22 05:58:23.200487',NULL,NULL,'False','96d7f397-10c4-4c68-be79-7f1e5385405a','b69436f6d3194929ace36172443c8bfa','ldap','203.0.113.193','203.0.113.222','tempest-ss-domain-2146209953','tempest-ss-user-545922506','tempest-ss-password-1763680838','tempest-ss-name-506741617','tempest-ss-desc-639580128',NULL,NULL),('2025-11-22 05:55:29.266703','2025-11-22 05:55:29.609518','2025-11-22 05:55:29.609157','97b17313-3e57-433e-a0d9-1c0a18706b6f','97b17313-3e57-433e-a0d9-1c0a18706b6f','3a30a5c5a0f0497d95a109c5526ede86','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-11-22 05:55:25.990765','2025-11-22 05:55:26.060096','2025-11-22 05:55:26.059770','99ebe969-8651-4976-ac2e-f08eb61dc9c0','99ebe969-8651-4976-ac2e-f08eb61dc9c0','3a30a5c5a0f0497d95a109c5526ede86','ldap','203.0.113.114','203.0.113.206','tempest-ss-domain-1102391233','tempest-ss-user-767000261','tempest-ss-password-1800103392','tempest-ss-name-601039200','tempest-ss-desc-1739477868',NULL,NULL),('2025-11-22 05:51:51.682478','2025-11-22 05:51:52.046629','2025-11-22 05:51:52.046319','9ca3c8c0-24f3-43da-90cb-6e66ab435674','9ca3c8c0-24f3-43da-90cb-6e66ab435674','790f13450b2540d1bdb71104fcc67ddf','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-11-22 05:56:14.526190',NULL,NULL,'False','9f73dcb2-4daa-4783-9192-b3ff972f5487','3520b2bd18fe4bc198c9b3ae61849514','ldap','203.0.113.39','203.0.113.106','tempest-ss-domain-879341029','tempest-ss-user-993349409','tempest-ss-password-459666414','tempest-ss-name-797692352','tempest-ss-desc-1218993377',NULL,NULL),('2025-11-22 05:55:37.166985','2025-11-22 05:55:37.973776','2025-11-22 05:55:37.973074','a0df3aab-8154-48eb-b897-f573c88e7472','a0df3aab-8154-48eb-b897-f573c88e7472','3a30a5c5a0f0497d95a109c5526ede86','ldap','203.0.113.155','203.0.113.95','tempest-ss-domain-1075660404','tempest-ss-user-513856485','tempest-ss-password-2015329953','tempest-ss-name-1042030437','tempest-ss-desc-2203170','tempest-ss-ou-935291717',NULL),('2025-11-22 05:55:27.133189','2025-11-22 05:55:27.205737','2025-11-22 05:55:27.205379','b201ceb9-85db-471f-a9e3-998cd580e689','b201ceb9-85db-471f-a9e3-998cd580e689','3a30a5c5a0f0497d95a109c5526ede86','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-11-22 05:55:27.714062','2025-11-22 05:55:27.889929','2025-11-22 05:55:27.889520','b2b50d5a-94dc-41e9-840d-8760edc24053','b2b50d5a-94dc-41e9-840d-8760edc24053','3a30a5c5a0f0497d95a109c5526ede86','ldap','203.0.113.54','203.0.113.17','tempest-ss-domain-1967476971','tempest-ss-user-597756135','tempest-ss-password-79505317','tempest-ss-name-271482256','tempest-ss-desc-606005070',NULL,NULL),('2025-11-22 05:53:19.989312',NULL,NULL,'False','b31cda01-f325-47bf-b69b-a30dbbee7ffe','c16b253430cb40f6bf0f328197748aef','ldap','203.0.113.222','203.0.113.223','tempest-ss-domain-1976746476','tempest-ss-user-1387748027','tempest-ss-password-1772102643','tempest-ss-name-1974188802','tempest-ss-desc-1729768907',NULL,NULL),('2025-11-22 05:55:28.435004','2025-11-22 05:55:29.034053','2025-11-22 05:55:29.033677','b8063236-c191-45f0-9424-3e262f375834','b8063236-c191-45f0-9424-3e262f375834','3a30a5c5a0f0497d95a109c5526ede86','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-11-22 05:55:48.957204','2025-11-22 05:55:49.467690','2025-11-22 05:55:49.467146','b806fcb1-95d5-41d0-98e6-88925152bdea','b806fcb1-95d5-41d0-98e6-88925152bdea','b65ccd7e2f5f4f95959c8fb179b60b78','ldap','203.0.113.169','203.0.113.100','tempest-ss-domain-1700667305','tempest-ss-user-246113574','tempest-ss-password-1211730719','tempest-ss-name-176452609','tempest-ss-desc-1033041914',NULL,NULL),('2025-11-22 05:55:32.533601','2025-11-22 05:55:33.009640','2025-11-22 05:55:33.009288','bb94e6a9-5add-4122-8c9b-ce13a1964198','bb94e6a9-5add-4122-8c9b-ce13a1964198','3a30a5c5a0f0497d95a109c5526ede86','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-11-22 05:51:54.466820','2025-11-22 05:51:55.682021','2025-11-22 05:51:55.681756','c39d2756-97df-4eed-9663-d67027d15351','c39d2756-97df-4eed-9663-d67027d15351','790f13450b2540d1bdb71104fcc67ddf','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-11-22 05:56:00.361212','2025-11-22 05:56:00.517375','2025-11-22 05:56:00.516984','c9079b28-22cb-423c-8b7c-05f18245c9a9','c9079b28-22cb-423c-8b7c-05f18245c9a9','fe21b9b15c3d454980c4e70e49f2eb68','ldap','203.0.113.164','203.0.113.115','tempest-ss-domain-357299335','tempest-ss-user-701736225','tempest-ss-password-187994199','tempest-ss-name-388812363','tempest-ss-desc-891629197',NULL,NULL),('2025-11-22 05:51:52.832158','2025-11-22 05:51:53.012951','2025-11-22 05:51:53.011899','ce9fbfd1-2384-45cf-810f-d1a9902b7171','ce9fbfd1-2384-45cf-810f-d1a9902b7171','790f13450b2540d1bdb71104fcc67ddf','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-11-22 05:55:25.809821','2025-11-22 05:55:26.947450','2025-11-22 05:55:26.946957','d3c6dbde-82be-44a1-afb7-0c7f46cf2ea4','d3c6dbde-82be-44a1-afb7-0c7f46cf2ea4','3a30a5c5a0f0497d95a109c5526ede86','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-11-22 05:55:32.069569','2025-11-22 05:55:32.327448','2025-11-22 05:55:32.326923','d815a83c-2cff-4025-836e-e73af8bcd4b1','d815a83c-2cff-4025-836e-e73af8bcd4b1','3a30a5c5a0f0497d95a109c5526ede86','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-11-22 05:55:35.340567','2025-11-22 05:55:36.725422','2025-11-22 05:55:36.724952','dfaee550-829a-4bd5-a37b-d736314bd03f','dfaee550-829a-4bd5-a37b-d736314bd03f','3a30a5c5a0f0497d95a109c5526ede86','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-11-22 05:51:51.769464','2025-11-22 05:51:51.925544','2025-11-22 05:51:51.924708','e2602950-495d-4738-ba6f-5219ca9df267','e2602950-495d-4738-ba6f-5219ca9df267','790f13450b2540d1bdb71104fcc67ddf','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-11-22 05:55:28.496896','2025-11-22 05:55:28.891718','2025-11-22 05:55:28.891034','e29c8e63-855a-493c-a03d-098001fed9f1','e29c8e63-855a-493c-a03d-098001fed9f1','3a30a5c5a0f0497d95a109c5526ede86','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-11-22 05:58:22.268479',NULL,NULL,'False','e6467b91-fb98-48b2-9f13-b603d875fa9b','b69436f6d3194929ace36172443c8bfa','ldap','203.0.113.105','203.0.113.128','tempest-ss-domain-1656118042','tempest-ss-user-1024905431','tempest-ss-password-561180571','tempest-ss-name-2125723904','tempest-ss-desc-656590563',NULL,NULL),('2025-11-22 05:55:31.381334','2025-11-22 05:55:31.802122','2025-11-22 05:55:31.801830','f636ad9b-c9c9-4d8b-b56b-bc084fe9c7af','f636ad9b-c9c9-4d8b-b56b-bc084fe9c7af','3a30a5c5a0f0497d95a109c5526ede86','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-11-22 05:55:29.352709','2025-11-22 05:55:29.480614','2025-11-22 05:55:29.480350','f7ff7037-410d-417e-9625-3931acecee59','f7ff7037-410d-417e-9625-3931acecee59','3a30a5c5a0f0497d95a109c5526ede86','ldap','203.0.113.27','203.0.113.219','tempest-ss-domain-2101575452','tempest-ss-user-2114739479','tempest-ss-password-1626226467','tempest-ss-name-1820434700','tempest-ss-desc-1500281455','tempest-ss-ou-692605196',NULL),('2025-11-22 05:55:37.094633','2025-11-22 05:55:38.177007','2025-11-22 05:55:38.176606','fb0c9201-efc4-441c-b969-bfad4896a7cd','fb0c9201-efc4-441c-b969-bfad4896a7cd','3a30a5c5a0f0497d95a109c5526ede86','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-11-22 05:55:26.180524','2025-11-22 05:55:26.250411','2025-11-22 05:55:26.250110','fd26f47a-bea2-486d-a941-ba37ab0f24bd','fd26f47a-bea2-486d-a941-ba37ab0f24bd','3a30a5c5a0f0497d95a109c5526ede86','kerberos','203.0.113.114','203.0.113.206','tempest-ss-domain-1102391233','tempest-ss-user-767000261','tempest-ss-password-1800103392','tempest-ss-name-601039200','tempest-ss-desc-1739477868',NULL,NULL),('2025-11-22 05:51:53.409358','2025-11-22 05:51:53.852497','2025-11-22 05:51:53.852197','fed361df-8be8-4b37-8a30-b2fe2f413c78','fed361df-8be8-4b37-8a30-b2fe2f413c78','790f13450b2540d1bdb71104fcc67ddf','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-11-22 05:55:27.600236','2025-11-22 05:55:28.081120','2025-11-22 05:55:28.080722','ffb6b5af-b5ef-4af6-8a3e-c9a01c611aa7','ffb6b5af-b5ef-4af6-8a3e-c9a01c611aa7','3a30a5c5a0f0497d95a109c5526ede86','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL);
/*!40000 ALTER TABLE `security_services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  `state` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `service_az_id_fk` (`availability_zone_id`),
  CONSTRAINT `service_az_id_fk` FOREIGN KEY (`availability_zone_id`) REFERENCES `availability_zones` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone_id`, `state`) VALUES ('2025-11-22 05:46:05.486072','2025-11-22 06:14:11.507742',NULL,0,1,'hostgroup','manila-scheduler','manila-scheduler',168,0,'bb37dba6-f304-4dde-891e-648b11fb093c','up'),('2025-11-22 05:46:13.693633','2025-11-22 06:14:12.881122',NULL,0,2,'hostgroup@cephfs','manila-share','manila-share',166,0,'bb37dba6-f304-4dde-891e-648b11fb093c','up');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_access_map`
--

DROP TABLE IF EXISTS `share_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_access_map` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `share_id` varchar(36) NOT NULL,
  `access_type` varchar(255) DEFAULT NULL,
  `access_to` varchar(255) DEFAULT NULL,
  `access_level` varchar(2) DEFAULT NULL,
  `access_key` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_id` (`share_id`),
  CONSTRAINT `share_access_map_ibfk_1` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_access_map`
--

LOCK TABLES `share_access_map` WRITE;
/*!40000 ALTER TABLE `share_access_map` DISABLE KEYS */;
INSERT INTO `share_access_map` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_id`, `access_type`, `access_to`, `access_level`, `access_key`) VALUES ('2025-11-22 05:55:02.743146','2025-11-22 05:55:10.105907','2025-11-22 05:55:47.478895','03f5edc0-f8f9-45e6-8707-d3f95f728043','03f5edc0-f8f9-45e6-8707-d3f95f728043','c6335e86-0ed3-4c9b-a59b-df9bdda6090c','cephx','Joe','rw',NULL),('2025-11-22 05:53:11.331088','2025-11-22 05:53:15.212078','2025-11-22 05:56:12.283442','04756e31-75af-4a41-8079-ca9c190e8e65','04756e31-75af-4a41-8079-ca9c190e8e65','8efd43bb-f9b3-4447-86c4-e3920bc619c4','cephx','alice_bob','ro','AQDHTyFpnUyeJRAAlyyD84wWWS0PunLIWtcm+A=='),('2025-11-22 05:56:46.004643','2025-11-22 05:56:50.074233','2025-11-22 05:56:50.476335','0f627668-ce6c-4802-9261-95b138ffa2ae','0f627668-ce6c-4802-9261-95b138ffa2ae','8c4d1c7d-bcbe-428a-add3-a107e25e1608','cephx','tempest-cephx-id-1175252805','rw','AQCeUCFpbe8xGRAAErxLW+eeNxNUSaTEg9ulew=='),('2025-11-22 05:57:04.076808','2025-11-22 05:57:07.997562','2025-11-22 05:57:34.480096','134352ee-af6e-472f-9d03-dbfe9329da45','134352ee-af6e-472f-9d03-dbfe9329da45','82f5a7b8-b11a-4b98-ac40-9540006a2619','cephx','tempest-cephx-id-1175252805','rw','AQCwUCFpwi71GxAAz5t68TWEuf1XFjtr5fYnZw=='),('2025-11-22 05:57:25.562594','2025-11-22 05:57:29.644628','2025-11-22 05:57:34.480096','1c48eb3b-638f-45cd-9b38-e6c3ad644072','1c48eb3b-638f-45cd-9b38-e6c3ad644072','82f5a7b8-b11a-4b98-ac40-9540006a2619','cephx','tempest-cephx-id-1175252805','rw','AQDFUCFpsN0rNBAAJZSsPh0Lm+SrealSK9A+bQ=='),('2025-11-22 05:56:56.960644','2025-11-22 05:57:00.821787','2025-11-22 05:57:01.394063','1d0d02f8-dddb-4e6d-8dd6-a298adbf09bf','1d0d02f8-dddb-4e6d-8dd6-a298adbf09bf','d0a602f8-d218-45aa-b13a-279f40f10b98','cephx','tempest-cephx-id-1175252805','rw','AQCpUCFp+qDSFBAAsLU/ooygEd5Cs7dXQmiiGw=='),('2025-11-22 05:55:26.380683','2025-11-22 05:55:30.321358','2025-11-22 05:56:12.283442','1eca5452-5a04-487d-ad50-34215f1b3e8b','1eca5452-5a04-487d-ad50-34215f1b3e8b','8efd43bb-f9b3-4447-86c4-e3920bc619c4','cephx','alice_bob','ro','AQBOUCFpjvHvJxAAMWVOdMhNwDXLnNL4bUaMhg=='),('2025-11-22 05:55:20.530326','2025-11-22 05:55:54.484306','2025-11-22 05:55:54.801948','1ed76ea1-ae65-4421-88dd-ff6f6fa08356','1ed76ea1-ae65-4421-88dd-ff6f6fa08356','e6ebf7ae-934a-4ccf-9ab6-5b62a19c9509','cephx','admin','rw',NULL),('2025-11-22 05:51:51.613823','2025-11-22 05:51:56.269662','2025-11-22 05:52:09.380367','2764a8c2-dfa9-4480-b7fb-6be07c18cb8f','2764a8c2-dfa9-4480-b7fb-6be07c18cb8f','4967e6e3-b2cc-45b4-b463-17f7bce6ae8e','cephx','eve48','rw','AQB3TyFpDNRyOxAAm2JpqGuhexCYQyYbp8i6UA=='),('2025-11-22 05:53:58.805859','2025-11-22 05:54:02.955542','2025-11-22 05:56:12.283442','353afc96-7195-40d1-bdbe-3508f8b89b4c','353afc96-7195-40d1-bdbe-3508f8b89b4c','8efd43bb-f9b3-4447-86c4-e3920bc619c4','cephx','alice_bob','ro','AQD3TyFpgK9YCxAAMIIcH8WvSZQQlOJ4ObHs7Q=='),('2025-11-22 05:54:57.423177','2025-11-22 05:55:01.525191','2025-11-22 05:56:12.283442','36471043-4206-4986-a253-8bc4e33e9fbe','36471043-4206-4986-a253-8bc4e33e9fbe','8efd43bb-f9b3-4447-86c4-e3920bc619c4','cephx','alice bob','ro','AQAxUCFpNtZAKhAALA+1CDbnhN5NQQV18iIf4w=='),('2025-11-22 05:54:42.902647','2025-11-22 05:54:46.801863','2025-11-22 05:56:12.283442','374fc519-166f-4248-9dc2-f14ab591b0cf','374fc519-166f-4248-9dc2-f14ab591b0cf','8efd43bb-f9b3-4447-86c4-e3920bc619c4','cephx','alice_bob','ro','AQAjUCFp/lPFEBAAd8OTKYNBIXx6rDQ8VjXRwg=='),('2025-11-22 05:53:51.756390','2025-11-22 05:53:55.506611','2025-11-22 05:56:12.283442','38d9e08a-60b5-43b0-933c-7a9f2c421b01','38d9e08a-60b5-43b0-933c-7a9f2c421b01','8efd43bb-f9b3-4447-86c4-e3920bc619c4','cephx','alice_bob','rw','AQDwTyFpi1wEARAAu9SMpSoIv7Igd2KFtW3SQw=='),('2025-11-22 05:53:18.437632','2025-11-22 05:53:23.092155','2025-11-22 05:56:12.283442','3e92860b-0859-46a2-9937-004fb5dca790','3e92860b-0859-46a2-9937-004fb5dca790','8efd43bb-f9b3-4447-86c4-e3920bc619c4','cephx','alice bob','rw','AQDOTyFpoOMkLBAAym4LaKVGiutGVT/maYoSsA=='),('2025-11-22 05:53:36.253723','2025-11-22 05:53:40.188829','2025-11-22 05:56:12.283442','455e661b-7485-4dc7-805c-cd204f1b5a56','455e661b-7485-4dc7-805c-cd204f1b5a56','8efd43bb-f9b3-4447-86c4-e3920bc619c4','cephx','alice','rw','AQDgTyFpf4KzLhAA36u8wmdvAdkXZoza+9LyPA=='),('2025-11-22 05:55:48.226111','2025-11-22 05:56:05.688296','2025-11-22 05:56:12.283442','4cea0446-a471-44a7-829c-ce65cffc2a32','4cea0446-a471-44a7-829c-ce65cffc2a32','8efd43bb-f9b3-4447-86c4-e3920bc619c4','cephx','bob','rw','AQBkUCFplq6QIBAAJprp/25Xlt8YqBlAdrOMTw=='),('2025-11-22 05:55:11.819542','2025-11-22 05:55:15.546940','2025-11-22 05:56:12.283442','4f2a2bc5-666d-4796-bf74-e907d7d5c341','4f2a2bc5-666d-4796-bf74-e907d7d5c341','8efd43bb-f9b3-4447-86c4-e3920bc619c4','cephx','alice','ro','AQBAUCFpr59bBBAACBnbbrJGhRDiZo/P4JRQ8w=='),('2025-11-22 05:55:41.058979','2025-11-22 05:55:44.770673','2025-11-22 05:56:12.283442','5bfd9017-d337-4013-a3e4-481f52ea06ad','5bfd9017-d337-4013-a3e4-481f52ea06ad','8efd43bb-f9b3-4447-86c4-e3920bc619c4','cephx','alice bob','ro','AQBdUCFpOHZBFRAAq9zU0N64Y/zL4VkRBG3faQ=='),('2025-11-22 05:55:19.140320','2025-11-22 05:55:23.054174','2025-11-22 05:56:12.283442','5eb69032-2453-46a4-8021-7f125e8d9a30','5eb69032-2453-46a4-8021-7f125e8d9a30','8efd43bb-f9b3-4447-86c4-e3920bc619c4','cephx','alice_bob','rw','AQBHUCFp9m7jGBAAZNGyYqV9pWhzQlhXTJ2MDA=='),('2025-11-22 05:54:50.189133','2025-11-22 05:54:53.960306','2025-11-22 05:56:12.283442','62bcb270-db96-4c1e-8190-5bf62e6a3af3','62bcb270-db96-4c1e-8190-5bf62e6a3af3','8efd43bb-f9b3-4447-86c4-e3920bc619c4','cephx','alice bob','rw','AQAqUCFpwbLtJxAA8KW9Y2LT/gfDIle6aGPl+g=='),('2025-11-22 05:52:56.680661','2025-11-22 05:53:00.628750','2025-11-22 05:56:12.283442','65c41aef-c88d-431f-9803-f3c680dff4bd','65c41aef-c88d-431f-9803-f3c680dff4bd','8efd43bb-f9b3-4447-86c4-e3920bc619c4','cephx','alice','ro','AQC5TyFpSe0UAxAAnZdYXE5eKpMfnPxqbMZX0w=='),('2025-11-22 05:55:56.322110','2025-11-22 05:56:00.517179','2025-11-22 05:56:01.496613','70713793-4858-49c6-b073-946842f128a9','70713793-4858-49c6-b073-946842f128a9','6421908b-395a-471b-82f0-f6641bffe29d','cephx','bob','rw','AQBkUCFplq6QIBAAJprp/25Xlt8YqBlAdrOMTw=='),('2025-11-22 05:54:43.164842','2025-11-22 05:54:44.940849','2025-11-22 05:54:45.497553','7d80cce4-3674-4374-b22d-83482a69c7b2','7d80cce4-3674-4374-b22d-83482a69c7b2','2d84ba4d-c3d7-42b6-ab7f-d9b35fae6828','cephx','tempest-cephx-id-1135923250','rw','AQAjUCFpbdJ7JxAAShuMgNeuAi1bf84YJkxaGg=='),('2025-11-22 05:57:18.385009','2025-11-22 05:57:22.158445','2025-11-22 05:57:34.480096','876e9c94-c12b-4f69-ae29-fa1aea4e9ced','876e9c94-c12b-4f69-ae29-fa1aea4e9ced','82f5a7b8-b11a-4b98-ac40-9540006a2619','cephx','tempest-cephx-id-1175252805','rw','AQC+UCFpPRcAKRAAqrM0ujRzjpVi7a45gn529g=='),('2025-11-22 05:54:06.221955','2025-11-22 05:54:10.250789','2025-11-22 05:56:12.283442','88001cb4-d6d5-4335-ae05-8dd44758f7af','88001cb4-d6d5-4335-ae05-8dd44758f7af','8efd43bb-f9b3-4447-86c4-e3920bc619c4','cephx','alice bob','rw','AQD+TyFp7qBkLhAAwzTDw6tvtxbbejM34910Ew=='),('2025-11-22 05:52:49.428645','2025-11-22 05:52:53.156167','2025-11-22 05:56:12.283442','961f504c-524a-421a-b4f8-2adcfe8ac9fe','961f504c-524a-421a-b4f8-2adcfe8ac9fe','8efd43bb-f9b3-4447-86c4-e3920bc619c4','cephx','alice','rw','AQCxTyFpIP+NKRAAmc06pLoX+zrAtbh29OIRlw=='),('2025-11-22 05:51:48.011580','2025-11-22 05:52:08.754639','2025-11-22 05:52:09.380367','9f3e3356-9590-4a30-9a2a-61fce56bbe0c','9f3e3356-9590-4a30-9a2a-61fce56bbe0c','4967e6e3-b2cc-45b4-b463-17f7bce6ae8e','cephx','eve49','rw','AQB0TyFpkT7GExAAp+0nDBwZdFb2JRJs3W0tkg=='),('2025-11-22 05:56:35.425315','2025-11-22 05:56:39.221569','2025-11-22 05:56:39.691213','aae80ab3-9f77-4b82-8b20-1a9f4c732d5c','aae80ab3-9f77-4b82-8b20-1a9f4c732d5c','535805ac-c11f-4da9-b23b-e9f0311f7416','cephx','tempest-cephx-id-1175252805','rw','AQCTUCFpuE6mKRAA37GuLujE44l6q+y5xd4tYQ=='),('2025-11-22 05:54:13.645338','2025-11-22 05:54:17.506700','2025-11-22 05:56:12.283442','ac8d55dd-e361-4dde-8909-a1745155406c','ac8d55dd-e361-4dde-8909-a1745155406c','8efd43bb-f9b3-4447-86c4-e3920bc619c4','cephx','alice bob','ro','AQAGUCFpNmn/BhAAIGubL6taEif9GItM3HaPIw=='),('2025-11-22 05:55:04.899910','2025-11-22 05:55:08.597510','2025-11-22 05:56:12.283442','acc5b4e9-a5d8-4c39-aa0e-fc56163d1098','acc5b4e9-a5d8-4c39-aa0e-fc56163d1098','8efd43bb-f9b3-4447-86c4-e3920bc619c4','cephx','alice','rw','AQA5UCFpbI0vDxAA8fDMYPcrICdxsPm5otZgvQ=='),('2025-11-22 05:55:06.421213','2025-11-22 05:55:13.591786','2025-11-22 05:55:47.478895','ad9f1cee-67ec-4269-902c-2f6baed52f79','ad9f1cee-67ec-4269-902c-2f6baed52f79','c6335e86-0ed3-4c9b-a59b-df9bdda6090c','cephx','tempest-cephx-id-758311238','rw','AQA6UCFprJ39KxAAUm3/se+ZoLfOQ8+hCBmhmA=='),('2025-11-22 05:55:31.581115','2025-11-22 05:55:36.231637','2025-11-22 05:55:43.767522','b2f4f110-bfbd-40c6-bb7b-e6d429943600','b2f4f110-bfbd-40c6-bb7b-e6d429943600','06610748-6de1-49ce-9a00-b0cc5a383015','cephx','david','rw',NULL),('2025-11-22 05:54:20.889138','2025-11-22 05:54:24.811535','2025-11-22 05:56:12.283442','b882afd2-110a-40ff-a5ca-97066d2ccbc8','b882afd2-110a-40ff-a5ca-97066d2ccbc8','8efd43bb-f9b3-4447-86c4-e3920bc619c4','cephx','alice','rw','AQANUCFpjMXCGhAAj4DGSNFV9jBiYd7iIfDZ3g=='),('2025-11-22 05:54:28.477062','2025-11-22 05:54:32.245862','2025-11-22 05:56:12.283442','bc66a829-cc9b-465d-8b62-a9c66ff260d2','bc66a829-cc9b-465d-8b62-a9c66ff260d2','8efd43bb-f9b3-4447-86c4-e3920bc619c4','cephx','alice','ro','AQAUUCFp2WNZMRAASxIaUbevOd6Im3Q0vfP2Iw=='),('2025-11-22 05:51:59.554449','2025-11-22 05:52:04.312709','2025-11-22 05:52:09.380367','bd69cf53-32e7-42f5-8cef-2983b3bfe839','bd69cf53-32e7-42f5-8cef-2983b3bfe839','4967e6e3-b2cc-45b4-b463-17f7bce6ae8e','cephx','eve47','rw','AQB/TyFpnUk9OBAAKYqirZ4K3HWSVz6A8HaQbA=='),('2025-11-22 05:55:33.611937','2025-11-22 05:55:37.779942','2025-11-22 05:56:12.283442','ca7816b3-cb9d-491e-8f5e-43696421c17a','ca7816b3-cb9d-491e-8f5e-43696421c17a','8efd43bb-f9b3-4447-86c4-e3920bc619c4','cephx','alice bob','rw','AQBWUCFpqf65NxAAEL6to7aVI6muHBS5jw4yFQ=='),('2025-11-22 05:53:04.000976','2025-11-22 05:53:07.894465','2025-11-22 05:56:12.283442','d6a9880d-6763-44d3-bd42-3f1693887fc5','d6a9880d-6763-44d3-bd42-3f1693887fc5','8efd43bb-f9b3-4447-86c4-e3920bc619c4','cephx','alice_bob','rw','AQDATyFpvcMVGxAACwL5ievJjwGo8O2VAerDBw=='),('2025-11-22 05:53:43.446182','2025-11-22 05:53:48.372457','2025-11-22 05:56:12.283442','d8a17784-25ab-42ca-beab-c5e10420d02a','d8a17784-25ab-42ca-beab-c5e10420d02a','8efd43bb-f9b3-4447-86c4-e3920bc619c4','cephx','alice','ro','AQDoTyFpuJsnKRAAAdrjAc3C3qh4hWEVMCqgbQ=='),('2025-11-22 05:53:25.622343','2025-11-22 05:53:32.995124','2025-11-22 05:56:12.283442','da76d931-4aa5-4616-b458-652ec06272bb','da76d931-4aa5-4616-b458-652ec06272bb','8efd43bb-f9b3-4447-86c4-e3920bc619c4','cephx','alice bob','ro','AQDYTyFpNDqsHxAAM+Ee9OZQMAoVnkHyULd1Yw=='),('2025-11-22 05:54:35.456785','2025-11-22 05:54:39.420859','2025-11-22 05:56:12.283442','e1d4c75d-e631-42c3-801e-ebcdcfedefff','e1d4c75d-e631-42c3-801e-ebcdcfedefff','8efd43bb-f9b3-4447-86c4-e3920bc619c4','cephx','alice_bob','rw','AQAbUCFpABhSLRAAviu06Ud9GKSaepiBbgNfBQ=='),('2025-11-22 05:57:11.306166','2025-11-22 05:57:15.121497','2025-11-22 05:57:34.480096','eb1505b6-c7a3-40a6-9aae-924001749455','eb1505b6-c7a3-40a6-9aae-924001749455','82f5a7b8-b11a-4b98-ac40-9540006a2619','cephx','tempest-cephx-id-1175252805','rw','AQC3UCFpbWOHIxAA6veiObpXwlyTNPHj/+J55A=='),('2025-11-22 05:54:55.694455','2025-11-22 05:55:17.180064','2025-11-22 05:55:50.965162','f461d620-c1d7-43a5-b57c-b12980dca6c0','f461d620-c1d7-43a5-b57c-b12980dca6c0','e54ddc55-06e2-4ec6-9935-df702d90e2c8','cephx','Joe','rw','AQAvUCFphpcOOhAAxOFo/q3T7yhxqNSzsO0Clw=='),('2025-11-22 05:55:24.480537','2025-11-22 05:55:39.776685','2025-11-22 05:55:54.801948','f6aa75b9-bdcb-4bba-aafc-11eaaff7851f','f6aa75b9-bdcb-4bba-aafc-11eaaff7851f','e6ebf7ae-934a-4ccf-9ab6-5b62a19c9509','cephx','david','rw','AQBMUCFpFmX3KRAANsXuHuUjKg3zcdoEz02rtA==');
/*!40000 ALTER TABLE `share_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_access_rules_metadata`
--

DROP TABLE IF EXISTS `share_access_rules_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_access_rules_metadata` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `access_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `access_id` (`access_id`),
  CONSTRAINT `share_access_rules_metadata_ibfk_1` FOREIGN KEY (`access_id`) REFERENCES `share_access_map` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_access_rules_metadata`
--

LOCK TABLES `share_access_rules_metadata` WRITE;
/*!40000 ALTER TABLE `share_access_rules_metadata` DISABLE KEYS */;
INSERT INTO `share_access_rules_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `access_id`, `key`, `value`, `id`) VALUES ('2025-11-22 05:51:48.013081',NULL,'2025-11-22 05:52:09.262631','1','9f3e3356-9590-4a30-9a2a-61fce56bbe0c','key1','value1',1),('2025-11-22 05:51:48.014099','2025-11-22 05:52:07.565307','2025-11-22 05:52:09.262631','2','9f3e3356-9590-4a30-9a2a-61fce56bbe0c','key2','value6_new',2),('2025-11-22 05:51:51.615363',NULL,'2025-11-22 05:51:57.063225','3','2764a8c2-dfa9-4480-b7fb-6be07c18cb8f','key3','v3',3),('2025-11-22 05:51:51.642663',NULL,'2025-11-22 05:51:57.063225','4','2764a8c2-dfa9-4480-b7fb-6be07c18cb8f','key4','value4',4),('2025-11-22 05:51:59.555077','2025-11-22 05:52:03.307919','2025-11-22 05:52:05.268202','5','bd69cf53-32e7-42f5-8cef-2983b3bfe839','key1','vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv',5),('2025-11-22 05:51:59.555589','2025-11-22 05:52:03.462754','2025-11-22 05:52:05.268202','6','bd69cf53-32e7-42f5-8cef-2983b3bfe839','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value2',6),('2025-11-22 05:52:07.549109',NULL,'2025-11-22 05:52:09.262631','7','9f3e3356-9590-4a30-9a2a-61fce56bbe0c','key7','value7',7),('2025-11-22 05:54:43.165772',NULL,'2025-11-22 05:54:45.362982','8','7d80cce4-3674-4374-b22d-83482a69c7b2','key1','value1',8),('2025-11-22 05:57:18.386229',NULL,'2025-11-22 05:57:22.368375','9','876e9c94-c12b-4f69-ae29-fa1aea4e9ced','key1','v1',9),('2025-11-22 05:57:18.386735',NULL,'2025-11-22 05:57:22.368375','10','876e9c94-c12b-4f69-ae29-fa1aea4e9ced','key2','v2',10),('2025-11-22 05:57:25.563410',NULL,'2025-11-22 05:57:29.886211','11','1c48eb3b-638f-45cd-9b38-e6c3ad644072','key1','v1',11),('2025-11-22 05:57:25.563826',NULL,'2025-11-22 05:57:29.886211','12','1c48eb3b-638f-45cd-9b38-e6c3ad644072','key2','v2',12);
/*!40000 ALTER TABLE `share_access_rules_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_share_type_mappings`
--

DROP TABLE IF EXISTS `share_group_share_type_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_share_type_mappings` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_group_id` varchar(36) DEFAULT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_sgstm_share_group_id` (`share_group_id`),
  KEY `fk_sgstm_share_type_id` (`share_type_id`),
  CONSTRAINT `fk_sgstm_share_group_id` FOREIGN KEY (`share_group_id`) REFERENCES `share_groups` (`id`),
  CONSTRAINT `fk_sgstm_share_type_id` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_share_type_mappings`
--

LOCK TABLES `share_group_share_type_mappings` WRITE;
/*!40000 ALTER TABLE `share_group_share_type_mappings` DISABLE KEYS */;
INSERT INTO `share_group_share_type_mappings` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `share_group_id`, `share_type_id`) VALUES ('0e4f1060-1118-452f-b4d5-7ed26190e3e7','2025-11-22 05:57:00.629909',NULL,'2025-11-22 05:57:01.137180','0e4f1060-1118-452f-b4d5-7ed26190e3e7','803dbd72-541a-4f96-91c3-545ca7945362','5426bf6e-b197-4c02-be68-82ee99c5c64e'),('71da94d7-1f6b-449b-8ee9-c7431b18b086','2025-11-22 05:56:59.832944',NULL,'2025-11-22 05:57:00.336309','71da94d7-1f6b-449b-8ee9-c7431b18b086','e6d675c7-bbaf-4177-8fb3-cadda9f6eea6','5426bf6e-b197-4c02-be68-82ee99c5c64e');
/*!40000 ALTER TABLE `share_group_share_type_mappings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_snapshots`
--

DROP TABLE IF EXISTS `share_group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_snapshots` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `share_group_id` varchar(36) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_share_group_snapshots_share_group_id` (`share_group_id`),
  CONSTRAINT `fk_share_group_snapshots_share_group_id` FOREIGN KEY (`share_group_id`) REFERENCES `share_groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_snapshots`
--

LOCK TABLES `share_group_snapshots` WRITE;
/*!40000 ALTER TABLE `share_group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_type_projects`
--

DROP TABLE IF EXISTS `share_group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sgtp_project_id_uc` (`share_group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `sgtp_id_fk` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_type_projects`
--

LOCK TABLES `share_group_type_projects` WRITE;
/*!40000 ALTER TABLE `share_group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_type_share_type_mappings`
--

DROP TABLE IF EXISTS `share_group_type_share_type_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_type_share_type_mappings` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_group_type_id` varchar(36) NOT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sgtp_id_sgt_id_uc` (`share_group_type_id`),
  KEY `sgtp_id_st_id_uc` (`share_type_id`),
  CONSTRAINT `sgtp_id_sgt_id_uc` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`),
  CONSTRAINT `sgtp_id_st_id_uc` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_type_share_type_mappings`
--

LOCK TABLES `share_group_type_share_type_mappings` WRITE;
/*!40000 ALTER TABLE `share_group_type_share_type_mappings` DISABLE KEYS */;
INSERT INTO `share_group_type_share_type_mappings` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `share_group_type_id`, `share_type_id`) VALUES ('0e6aeadc-21a0-4e6a-9be5-06a4689c21e1','2025-11-22 05:56:39.237668',NULL,'2025-11-22 05:57:19.238854','0e6aeadc-21a0-4e6a-9be5-06a4689c21e1','acd0a13b-4698-4900-9290-65d4c31e5757','5426bf6e-b197-4c02-be68-82ee99c5c64e'),('91f6bf93-8914-42e7-bfdf-176399ee8edb','2025-11-22 05:58:31.218329',NULL,'2025-11-22 05:58:33.244013','91f6bf93-8914-42e7-bfdf-176399ee8edb','9e24a8de-97f1-45ee-92b5-98328e00b295','6fd6ec7f-3bec-440f-b4a3-1e22184e83a8'),('b18a3afb-6dcf-4b6b-bce8-6876fb56760e','2025-11-22 05:51:05.795917',NULL,'2025-11-22 05:51:39.824161','b18a3afb-6dcf-4b6b-bce8-6876fb56760e','ed125ac0-61f8-43a8-8ee0-78b251338106','f3cd9bee-b210-4ae4-816a-bb8ba92391c9'),('cbdc9122-e458-4db4-bd53-1166211f8031','2025-11-22 05:51:37.702943',NULL,'2025-11-22 05:52:11.785450','cbdc9122-e458-4db4-bd53-1166211f8031','f2d23598-187b-4777-9587-73121ddcd210','76b8f610-7bd5-4886-9698-850dd629ddbd');
/*!40000 ALTER TABLE `share_group_type_share_type_mappings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_type_specs`
--

DROP TABLE IF EXISTS `share_group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `spec_key` varchar(255) DEFAULT NULL,
  `spec_value` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sgtp_id_extra_specs_fk` (`share_group_type_id`),
  CONSTRAINT `sgtp_id_extra_specs_fk` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_type_specs`
--

LOCK TABLES `share_group_type_specs` WRITE;
/*!40000 ALTER TABLE `share_group_type_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_types`
--

DROP TABLE IF EXISTS `share_group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_types` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_share_group_type_name` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_types`
--

LOCK TABLES `share_group_types` WRITE;
/*!40000 ALTER TABLE `share_group_types` DISABLE KEYS */;
INSERT INTO `share_group_types` (`id`, `created_at`, `updated_at`, `deleted_at`, `is_public`, `name`, `deleted`) VALUES ('9e24a8de-97f1-45ee-92b5-98328e00b295','2025-11-22 05:58:31.217083',NULL,'2025-11-22 05:58:33.247759',1,'tempest-unique_sgtype_name-454708805','9e24a8de-97f1-45ee-92b5-98328e00b295'),('acd0a13b-4698-4900-9290-65d4c31e5757','2025-11-22 05:56:39.236522',NULL,'2025-11-22 05:57:19.240761',1,'tempest-unique_sgtype_name-54228805','acd0a13b-4698-4900-9290-65d4c31e5757'),('ed125ac0-61f8-43a8-8ee0-78b251338106','2025-11-22 05:51:05.794397',NULL,'2025-11-22 05:51:39.828921',1,'tempest-unique_sgtype_name-1008633003','ed125ac0-61f8-43a8-8ee0-78b251338106'),('f2d23598-187b-4777-9587-73121ddcd210','2025-11-22 05:51:37.702287',NULL,'2025-11-22 05:52:11.789171',1,'tempest-unique_sgtype_name-1377270201','f2d23598-187b-4777-9587-73121ddcd210');
/*!40000 ALTER TABLE `share_group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_groups`
--

DROP TABLE IF EXISTS `share_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_groups` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `host` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `source_share_group_snapshot_id` varchar(36) DEFAULT NULL,
  `share_network_id` varchar(36) DEFAULT NULL,
  `share_server_id` varchar(36) DEFAULT NULL,
  `share_group_type_id` varchar(36) DEFAULT NULL,
  `consistent_snapshot_support` enum('pool','host') DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_share_group_share_network_id` (`share_network_id`),
  KEY `fk_share_group_share_server_id` (`share_server_id`),
  KEY `sgt_id_sg_id_uc` (`share_group_type_id`),
  CONSTRAINT `fk_share_group_share_network_id` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`),
  CONSTRAINT `fk_share_group_share_server_id` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`),
  CONSTRAINT `sgt_id_sg_id_uc` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_groups`
--

LOCK TABLES `share_groups` WRITE;
/*!40000 ALTER TABLE `share_groups` DISABLE KEYS */;
INSERT INTO `share_groups` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `user_id`, `project_id`, `host`, `name`, `description`, `status`, `source_share_group_snapshot_id`, `share_network_id`, `share_server_id`, `share_group_type_id`, `consistent_snapshot_support`, `availability_zone_id`) VALUES ('803dbd72-541a-4f96-91c3-545ca7945362','2025-11-22 05:57:00.745244','2025-11-22 05:57:01.135781','2025-11-22 05:57:01.135289','803dbd72-541a-4f96-91c3-545ca7945362','c2522b58eb254cf58002dcb519ab137d','f0fc42a3cd4a4e75942e7132887f268d','hostgroup@cephfs#cephfs',NULL,NULL,'deleting',NULL,NULL,NULL,'acd0a13b-4698-4900-9290-65d4c31e5757',NULL,'bb37dba6-f304-4dde-891e-648b11fb093c'),('e6d675c7-bbaf-4177-8fb3-cadda9f6eea6','2025-11-22 05:57:00.008504','2025-11-22 05:57:00.335093','2025-11-22 05:57:00.333951','e6d675c7-bbaf-4177-8fb3-cadda9f6eea6','c2522b58eb254cf58002dcb519ab137d','f0fc42a3cd4a4e75942e7132887f268d','hostgroup@cephfs#cephfs',NULL,NULL,'deleting',NULL,NULL,NULL,'acd0a13b-4698-4900-9290-65d4c31e5757',NULL,'bb37dba6-f304-4dde-891e-648b11fb093c');
/*!40000 ALTER TABLE `share_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instance_access_map`
--

DROP TABLE IF EXISTS `share_instance_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instance_access_map` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `share_instance_id` varchar(36) DEFAULT NULL,
  `access_id` varchar(36) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `siam_instance_fk` (`share_instance_id`),
  KEY `siam_access_fk` (`access_id`),
  CONSTRAINT `siam_access_fk` FOREIGN KEY (`access_id`) REFERENCES `share_access_map` (`id`),
  CONSTRAINT `siam_instance_fk` FOREIGN KEY (`share_instance_id`) REFERENCES `share_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instance_access_map`
--

LOCK TABLES `share_instance_access_map` WRITE;
/*!40000 ALTER TABLE `share_instance_access_map` DISABLE KEYS */;
INSERT INTO `share_instance_access_map` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_instance_id`, `access_id`, `state`) VALUES ('2025-11-22 05:55:31.602845','2025-11-22 05:55:36.417263','2025-11-22 05:55:36.416843','0930956d-3876-4d3d-a103-06d655fd157f','0930956d-3876-4d3d-a103-06d655fd157f','7bcf26e0-68e7-4e86-801e-5338f311cec3','b2f4f110-bfbd-40c6-bb7b-e6d429943600','deleted'),('2025-11-22 05:55:19.161938','2025-11-22 05:55:23.308718','2025-11-22 05:55:23.308206','109d6993-1b0b-449d-9572-26e07744268d','109d6993-1b0b-449d-9572-26e07744268d','5fe2732a-575f-4985-a0be-d017e158a52a','5eb69032-2453-46a4-8021-7f125e8d9a30','deleted'),('2025-11-22 05:54:55.704655','2025-11-22 05:55:17.428974','2025-11-22 05:55:17.428555','10d169c6-5478-4125-9eba-3e9efaac7b95','10d169c6-5478-4125-9eba-3e9efaac7b95','f96efe4e-dc4d-4c2a-8b79-a56ce8d9f5a2','f461d620-c1d7-43a5-b57c-b12980dca6c0','deleted'),('2025-11-22 05:55:56.344493','2025-11-22 05:56:01.487634','2025-11-22 05:56:01.485656','39d2c065-4c1d-4d63-87ff-ad3b707a6254','39d2c065-4c1d-4d63-87ff-ad3b707a6254','298b8575-0ab5-4c93-992c-f312a6379d92','70713793-4858-49c6-b073-946842f128a9','deleted'),('2025-11-22 05:51:51.659865','2025-11-22 05:51:57.059051','2025-11-22 05:51:57.058217','3fe92e59-0b5e-4023-9835-d3c7f5d398bf','3fe92e59-0b5e-4023-9835-d3c7f5d398bf','bbda1cfd-a62a-4d0a-87fc-e66cc4fb1bbd','2764a8c2-dfa9-4480-b7fb-6be07c18cb8f','deleted'),('2025-11-22 05:55:48.249190','2025-11-22 05:56:05.938800','2025-11-22 05:56:05.938286','46a1945f-f916-416f-9d76-6fdb2e901a57','46a1945f-f916-416f-9d76-6fdb2e901a57','5fe2732a-575f-4985-a0be-d017e158a52a','4cea0446-a471-44a7-829c-ce65cffc2a32','deleted'),('2025-11-22 05:56:56.993122','2025-11-22 05:57:01.180890','2025-11-22 05:57:01.180447','46b319f6-7be2-431c-a6b0-b3022fd14a0c','46b319f6-7be2-431c-a6b0-b3022fd14a0c','194fe9d7-4252-42b8-9e5b-0b7a3e0b3774','1d0d02f8-dddb-4e6d-8dd6-a298adbf09bf','deleted'),('2025-11-22 05:51:48.036457','2025-11-22 05:52:09.259057','2025-11-22 05:52:09.258512','46d2ec2a-944b-4465-ba72-726d276e101f','46d2ec2a-944b-4465-ba72-726d276e101f','bbda1cfd-a62a-4d0a-87fc-e66cc4fb1bbd','9f3e3356-9590-4a30-9a2a-61fce56bbe0c','deleted'),('2025-11-22 05:53:11.348173','2025-11-22 05:53:15.568927','2025-11-22 05:53:15.568571','478eb872-d3d8-4ba2-9d7b-2cfb72df3ce9','478eb872-d3d8-4ba2-9d7b-2cfb72df3ce9','5fe2732a-575f-4985-a0be-d017e158a52a','04756e31-75af-4a41-8079-ca9c190e8e65','deleted'),('2025-11-22 05:56:35.438465','2025-11-22 05:56:39.522408','2025-11-22 05:56:39.521824','48683cd6-16a0-4bd1-902a-3502c6d3ee18','48683cd6-16a0-4bd1-902a-3502c6d3ee18','6e38d87a-ae0f-4d08-9b46-1181605e24ce','aae80ab3-9f77-4b82-8b20-1a9f4c732d5c','deleted'),('2025-11-22 05:54:35.471322','2025-11-22 05:54:39.759639','2025-11-22 05:54:39.759153','4c2228b9-bcde-4b42-b62e-094e359eadfc','4c2228b9-bcde-4b42-b62e-094e359eadfc','5fe2732a-575f-4985-a0be-d017e158a52a','e1d4c75d-e631-42c3-801e-ebcdcfedefff','deleted'),('2025-11-22 05:55:02.758677','2025-11-22 05:55:10.258978','2025-11-22 05:55:10.258621','503035fa-4e8f-4d91-94be-4b5c20e18610','503035fa-4e8f-4d91-94be-4b5c20e18610','fdc0a474-b1f3-43ab-b94f-a0eefb55e7b7','03f5edc0-f8f9-45e6-8707-d3f95f728043','deleted'),('2025-11-22 05:55:26.396128','2025-11-22 05:55:30.521063','2025-11-22 05:55:30.520740','51cae62a-8070-4788-bea8-51869f8714ee','51cae62a-8070-4788-bea8-51869f8714ee','5fe2732a-575f-4985-a0be-d017e158a52a','1eca5452-5a04-487d-ad50-34215f1b3e8b','deleted'),('2025-11-22 05:54:50.199752','2025-11-22 05:54:54.254036','2025-11-22 05:54:54.253547','5c306061-fd58-40e4-8c4d-dd3a0b80e0e6','5c306061-fd58-40e4-8c4d-dd3a0b80e0e6','5fe2732a-575f-4985-a0be-d017e158a52a','62bcb270-db96-4c1e-8190-5bf62e6a3af3','deleted'),('2025-11-22 05:54:57.440742','2025-11-22 05:55:01.813592','2025-11-22 05:55:01.813135','5d1114f2-57f2-4105-ba7d-62324d95f77a','5d1114f2-57f2-4105-ba7d-62324d95f77a','5fe2732a-575f-4985-a0be-d017e158a52a','36471043-4206-4986-a253-8bc4e33e9fbe','deleted'),('2025-11-22 05:54:13.657757','2025-11-22 05:54:18.671274','2025-11-22 05:54:18.670736','69ffb38f-321e-4e16-98b7-ffcdb90e4abd','69ffb38f-321e-4e16-98b7-ffcdb90e4abd','5fe2732a-575f-4985-a0be-d017e158a52a','ac8d55dd-e361-4dde-8909-a1745155406c','deleted'),('2025-11-22 05:55:06.439366','2025-11-22 05:55:13.855159','2025-11-22 05:55:13.853304','6a9b2dfd-42c4-449c-8d00-5bfe6f77d739','6a9b2dfd-42c4-449c-8d00-5bfe6f77d739','fdc0a474-b1f3-43ab-b94f-a0eefb55e7b7','ad9f1cee-67ec-4269-902c-2f6baed52f79','deleted'),('2025-11-22 05:57:11.320317','2025-11-22 05:57:15.421428','2025-11-22 05:57:15.420952','78b4a206-13b9-4ae3-abc9-0e39d9ff3420','78b4a206-13b9-4ae3-abc9-0e39d9ff3420','9842ed03-cc84-4abe-85fe-b6107828690f','eb1505b6-c7a3-40a6-9aae-924001749455','deleted'),('2025-11-22 05:54:20.910884','2025-11-22 05:54:25.130284','2025-11-22 05:54:25.129646','7d48ffe1-e9db-4627-81f5-e7505915d425','7d48ffe1-e9db-4627-81f5-e7505915d425','5fe2732a-575f-4985-a0be-d017e158a52a','b882afd2-110a-40ff-a5ca-97066d2ccbc8','deleted'),('2025-11-22 05:56:46.025978','2025-11-22 05:56:50.346462','2025-11-22 05:56:50.345905','7d8eda5e-fa78-43ba-a679-9a3f64ab47ad','7d8eda5e-fa78-43ba-a679-9a3f64ab47ad','b91da8df-240a-407a-a34e-98bfc943cf90','0f627668-ce6c-4802-9261-95b138ffa2ae','deleted'),('2025-11-22 05:55:11.830821','2025-11-22 05:55:15.824065','2025-11-22 05:55:15.823723','8c42bfb6-fc09-4a9e-8901-509e6c04a565','8c42bfb6-fc09-4a9e-8901-509e6c04a565','5fe2732a-575f-4985-a0be-d017e158a52a','4f2a2bc5-666d-4796-bf74-e907d7d5c341','deleted'),('2025-11-22 05:53:58.817688','2025-11-22 05:54:03.205729','2025-11-22 05:54:03.205233','8c4e1474-aad7-4e14-8b09-980c571a63c4','8c4e1474-aad7-4e14-8b09-980c571a63c4','5fe2732a-575f-4985-a0be-d017e158a52a','353afc96-7195-40d1-bdbe-3508f8b89b4c','deleted'),('2025-11-22 05:53:18.452007','2025-11-22 05:53:25.360706','2025-11-22 05:53:25.360342','8d5abedf-7d83-4c7b-b21f-bb24540b0a17','8d5abedf-7d83-4c7b-b21f-bb24540b0a17','5fe2732a-575f-4985-a0be-d017e158a52a','3e92860b-0859-46a2-9937-004fb5dca790','deleted'),('2025-11-22 05:54:43.189492','2025-11-22 05:54:45.360966','2025-11-22 05:54:45.360445','99e71f49-dcf6-4a71-9a4d-429906272443','99e71f49-dcf6-4a71-9a4d-429906272443','df2fb1a3-9bc8-42f7-abfc-affd30fb7b3f','7d80cce4-3674-4374-b22d-83482a69c7b2','deleted'),('2025-11-22 05:51:59.570040','2025-11-22 05:52:05.079981','2025-11-22 05:52:05.079234','9bb2208a-f0a1-48d9-a26a-57c2c9e73613','9bb2208a-f0a1-48d9-a26a-57c2c9e73613','bbda1cfd-a62a-4d0a-87fc-e66cc4fb1bbd','bd69cf53-32e7-42f5-8cef-2983b3bfe839','deleted'),('2025-11-22 05:54:42.917153','2025-11-22 05:54:47.088224','2025-11-22 05:54:47.087693','9fa4803f-aec3-4c07-94a5-cd740ce1f270','9fa4803f-aec3-4c07-94a5-cd740ce1f270','5fe2732a-575f-4985-a0be-d017e158a52a','374fc519-166f-4248-9dc2-f14ab591b0cf','deleted'),('2025-11-22 05:55:24.494783','2025-11-22 05:55:40.113330','2025-11-22 05:55:40.112896','a1df9495-3d5c-428c-a1d9-e235382174f4','a1df9495-3d5c-428c-a1d9-e235382174f4','8d03444f-9989-4f30-9672-a2032459f666','f6aa75b9-bdcb-4bba-aafc-11eaaff7851f','deleted'),('2025-11-22 05:52:49.439247','2025-11-22 05:52:53.433183','2025-11-22 05:52:53.430416','a5ceff4e-fc32-410b-ac90-8ea0831bdfb1','a5ceff4e-fc32-410b-ac90-8ea0831bdfb1','5fe2732a-575f-4985-a0be-d017e158a52a','961f504c-524a-421a-b4f8-2adcfe8ac9fe','deleted'),('2025-11-22 05:57:04.101700','2025-11-22 05:57:08.268592','2025-11-22 05:57:08.268040','abab9c15-79b1-43da-a0ee-a0aa62e2e6bf','abab9c15-79b1-43da-a0ee-a0aa62e2e6bf','9842ed03-cc84-4abe-85fe-b6107828690f','134352ee-af6e-472f-9d03-dbfe9329da45','deleted'),('2025-11-22 05:57:18.411669','2025-11-22 05:57:22.366497','2025-11-22 05:57:22.366100','af20311a-d19d-4cef-9b2d-98fbda53b28f','af20311a-d19d-4cef-9b2d-98fbda53b28f','9842ed03-cc84-4abe-85fe-b6107828690f','876e9c94-c12b-4f69-ae29-fa1aea4e9ced','deleted'),('2025-11-22 05:54:28.493829','2025-11-22 05:54:32.761713','2025-11-22 05:54:32.761180','b3913308-6460-475b-a462-47dbace9b431','b3913308-6460-475b-a462-47dbace9b431','5fe2732a-575f-4985-a0be-d017e158a52a','bc66a829-cc9b-465d-8b62-a9c66ff260d2','deleted'),('2025-11-22 05:53:25.631757','2025-11-22 05:53:33.225701','2025-11-22 05:53:33.225361','b4cd6cc3-7816-4c7e-bc2e-326067a76746','b4cd6cc3-7816-4c7e-bc2e-326067a76746','5fe2732a-575f-4985-a0be-d017e158a52a','da76d931-4aa5-4616-b458-652ec06272bb','deleted'),('2025-11-22 05:53:04.021640','2025-11-22 05:53:08.154785','2025-11-22 05:53:08.154194','c10cb936-170a-4c69-97a2-0c664dfa743c','c10cb936-170a-4c69-97a2-0c664dfa743c','5fe2732a-575f-4985-a0be-d017e158a52a','d6a9880d-6763-44d3-bd42-3f1693887fc5','deleted'),('2025-11-22 05:55:41.072898','2025-11-22 05:55:45.001497','2025-11-22 05:55:45.001083','c7d0aeec-07d5-4eac-9e0e-8b330c3fedf3','c7d0aeec-07d5-4eac-9e0e-8b330c3fedf3','5fe2732a-575f-4985-a0be-d017e158a52a','5bfd9017-d337-4013-a3e4-481f52ea06ad','deleted'),('2025-11-22 05:55:04.931834','2025-11-22 05:55:08.823704','2025-11-22 05:55:08.823348','c8738f1a-453a-4500-8bcd-b667149415c5','c8738f1a-453a-4500-8bcd-b667149415c5','5fe2732a-575f-4985-a0be-d017e158a52a','acc5b4e9-a5d8-4c39-aa0e-fc56163d1098','deleted'),('2025-11-22 05:55:33.626275','2025-11-22 05:55:39.747707','2025-11-22 05:55:39.746214','d72e4de1-333b-4e4b-b05b-53ecb17f663c','d72e4de1-333b-4e4b-b05b-53ecb17f663c','5fe2732a-575f-4985-a0be-d017e158a52a','ca7816b3-cb9d-491e-8f5e-43696421c17a','deleted'),('2025-11-22 05:55:20.547675','2025-11-22 05:55:54.696548','2025-11-22 05:55:54.696170','daf1d3b5-5a86-470c-9833-ed809949986b','daf1d3b5-5a86-470c-9833-ed809949986b','8d03444f-9989-4f30-9672-a2032459f666','1ed76ea1-ae65-4421-88dd-ff6f6fa08356','deleted'),('2025-11-22 05:53:36.272197','2025-11-22 05:53:40.444430','2025-11-22 05:53:40.443723','de1e0f17-e7d4-4410-bca6-38eba6f8daa9','de1e0f17-e7d4-4410-bca6-38eba6f8daa9','5fe2732a-575f-4985-a0be-d017e158a52a','455e661b-7485-4dc7-805c-cd204f1b5a56','deleted'),('2025-11-22 05:53:51.767527','2025-11-22 05:53:55.789772','2025-11-22 05:53:55.789164','decc8c54-02ab-40d1-b260-817baf909996','decc8c54-02ab-40d1-b260-817baf909996','5fe2732a-575f-4985-a0be-d017e158a52a','38d9e08a-60b5-43b0-933c-7a9f2c421b01','deleted'),('2025-11-22 05:53:43.472774','2025-11-22 05:53:48.608391','2025-11-22 05:53:48.608006','e23cb68b-6e53-4a5f-90fc-a5310161300e','e23cb68b-6e53-4a5f-90fc-a5310161300e','5fe2732a-575f-4985-a0be-d017e158a52a','d8a17784-25ab-42ca-beab-c5e10420d02a','deleted'),('2025-11-22 05:52:56.710849','2025-11-22 05:53:01.627462','2025-11-22 05:53:01.626808','ed115c6e-9fa2-4800-a810-d5519b9aa00b','ed115c6e-9fa2-4800-a810-d5519b9aa00b','5fe2732a-575f-4985-a0be-d017e158a52a','65c41aef-c88d-431f-9803-f3c680dff4bd','deleted'),('2025-11-22 05:57:25.575937','2025-11-22 05:57:29.884591','2025-11-22 05:57:29.884217','f095a3a1-fd78-40ad-9d75-b62af91062f2','f095a3a1-fd78-40ad-9d75-b62af91062f2','9842ed03-cc84-4abe-85fe-b6107828690f','1c48eb3b-638f-45cd-9b38-e6c3ad644072','deleted'),('2025-11-22 05:54:06.245314','2025-11-22 05:54:10.546862','2025-11-22 05:54:10.546504','fb6aacce-d22b-4f42-9ac8-603aa9a6006e','fb6aacce-d22b-4f42-9ac8-603aa9a6006e','5fe2732a-575f-4985-a0be-d017e158a52a','88001cb4-d6d5-4335-ae05-8dd44758f7af','deleted');
/*!40000 ALTER TABLE `share_instance_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instance_export_locations`
--

DROP TABLE IF EXISTS `share_instance_export_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instance_export_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `path` varchar(2000) DEFAULT NULL,
  `share_instance_id` varchar(36) DEFAULT NULL,
  `is_admin_only` tinyint(1) DEFAULT NULL,
  `uuid` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `sel_instance_id_fk` (`share_instance_id`),
  CONSTRAINT `sel_instance_id_fk` FOREIGN KEY (`share_instance_id`) REFERENCES `share_instances` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instance_export_locations`
--

LOCK TABLES `share_instance_export_locations` WRITE;
/*!40000 ALTER TABLE `share_instance_export_locations` DISABLE KEYS */;
INSERT INTO `share_instance_export_locations` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `path`, `share_instance_id`, `is_admin_only`, `uuid`) VALUES (1,'2025-11-22 05:50:51.594977','2025-11-22 05:52:23.028429','2025-11-22 05:52:23.026568',1,'192.168.122.100:6789:/volumes/_nogroup/af20cd9a-8203-491f-b76d-599ebd8046ec/395fee8f-ce36-4a47-8e0c-fb34e066b190','af20cd9a-8203-491f-b76d-599ebd8046ec',0,'f7fee538-4602-4aeb-bfeb-111e60657ce0'),(2,'2025-11-22 05:50:54.563017','2025-11-22 05:51:06.646713','2025-11-22 05:51:06.645471',2,'192.168.122.100:6789:/volumes/_nogroup/15202c81-eb7f-4a9b-b839-74d8d3eac759/9dc391b1-5afd-470d-8fab-2487de0791bf','15202c81-eb7f-4a9b-b839-74d8d3eac759',0,'409204cc-c48f-40b3-94c2-ad240cf7b4a5'),(3,'2025-11-22 05:50:55.359765','2025-11-22 05:50:59.387885','2025-11-22 05:50:59.386956',3,'192.168.122.100:6789:/volumes/_nogroup/4d695e4c-80d1-4558-8e35-fa4463b56489/4b21d2b2-9872-4ccc-a7e9-db7866368f51','4d695e4c-80d1-4558-8e35-fa4463b56489',0,'2ee40ba5-7dbe-4573-a0e8-75cedb1ad459'),(4,'2025-11-22 05:50:55.931492','2025-11-22 05:50:59.173646','2025-11-22 05:50:59.171915',4,'192.168.122.100:6789:/volumes/_nogroup/f6b1d082-aa60-414d-aa02-6f616d2261dc/624ec50d-e37b-41cd-9a3f-24b361bf305b','f6b1d082-aa60-414d-aa02-6f616d2261dc',0,'c8abfe11-4806-4b6d-b681-6f92e7f1855e'),(5,'2025-11-22 05:51:04.212131','2025-11-22 05:51:10.360231','2025-11-22 05:51:10.359242',5,'192.168.122.100:6789:/volumes/_nogroup/d9b34a10-7e37-4811-ad95-28431845630c/658dfee9-70b1-4c32-914c-e2b7c14d06b9','d9b34a10-7e37-4811-ad95-28431845630c',0,'b1b698c5-848a-4d73-8f57-5275da1b72cb'),(6,'2025-11-22 05:51:07.289942','2025-11-22 05:51:15.228754','2025-11-22 05:51:15.226920',6,'192.168.122.100:6789:/volumes/_nogroup/f30f85a5-1564-4626-84fb-0c570e11fc93/090db0d0-95bb-4470-94a0-1c11e452e02e','f30f85a5-1564-4626-84fb-0c570e11fc93',0,'61464c27-2675-4406-8222-f2bfaaeab33d'),(7,'2025-11-22 05:51:11.436723','2025-11-22 05:51:18.726671','2025-11-22 05:51:18.724927',7,'192.168.122.100:6789:/volumes/_nogroup/7d6b5119-ad0e-4013-9a5e-284fedb56378/18359726-1fec-4e2a-9fba-56371e83793c','7d6b5119-ad0e-4013-9a5e-284fedb56378',0,'eb6ebd59-011c-44bf-9344-7fe50712336e'),(8,'2025-11-22 05:51:14.266834','2025-11-22 05:51:18.015394','2025-11-22 05:51:18.014239',8,'192.168.122.100:6789:/volumes/_nogroup/2cac985c-91b9-4f35-a81a-295d69c728b5/e2200ae7-4b6a-4f57-8c55-553c59b18d66','2cac985c-91b9-4f35-a81a-295d69c728b5',0,'780b1489-c1a3-4728-9354-fd5906db8ec3'),(9,'2025-11-22 05:51:19.309481','2025-11-22 05:51:25.465659','2025-11-22 05:51:25.464135',9,'192.168.122.100:6789:/volumes/_nogroup/1f68ab23-30d2-4b25-b726-bc4bc13231e8/dbd4e1e9-3382-4e06-841d-48785f972919','1f68ab23-30d2-4b25-b726-bc4bc13231e8',0,'998a3393-b9c9-42ec-9dc9-a339d5c3d4f6'),(10,'2025-11-22 05:51:21.649075','2025-11-22 05:51:25.292752','2025-11-22 05:51:25.289423',10,'192.168.122.100:6789:/volumes/_nogroup/6c1cff93-cfe8-43e8-b934-82a3cf7b6030/861a3f9f-782d-4254-8563-004b6282d6b1','6c1cff93-cfe8-43e8-b934-82a3cf7b6030',0,'44b7f394-2b1a-4062-a6b0-6e1a2ca6e49f'),(11,'2025-11-22 05:51:38.217799','2025-11-22 05:52:08.677987','2025-11-22 05:52:08.676809',11,'192.168.122.100:6789:/volumes/_nogroup/e41b5283-9e15-4f8b-9973-4c9089dccbfc/7dab71fa-f453-44de-ae74-e39cb383661c','e41b5283-9e15-4f8b-9973-4c9089dccbfc',0,'ef7f5d34-cd2c-40d9-a716-7975702b05ac'),(12,'2025-11-22 05:51:42.431958','2025-11-22 05:52:05.280331','2025-11-22 05:52:05.276240',12,'192.168.122.100:6789:/volumes/_nogroup/f7e75bd1-474d-4276-b05f-3f57f661f123/92dccae1-0df1-413e-ac43-7f04ced2b9ff','f7e75bd1-474d-4276-b05f-3f57f661f123',0,'0dd9afe7-df15-40f5-9f19-4527c4f4c114'),(13,'2025-11-22 05:51:44.914228','2025-11-22 05:52:09.357504','2025-11-22 05:52:09.356188',13,'192.168.122.100:6789:/volumes/_nogroup/bbda1cfd-a62a-4d0a-87fc-e66cc4fb1bbd/c7221b79-0f2c-4f93-9854-768c7ef67f08','bbda1cfd-a62a-4d0a-87fc-e66cc4fb1bbd',0,'ec39d219-56e4-468b-9cca-514157262661'),(14,'2025-11-22 05:52:01.425825','2025-11-22 05:52:20.231172','2025-11-22 05:52:20.229723',14,'192.168.122.100:6789:/volumes/_nogroup/77ba3a4e-8b78-433d-9fcd-08fc8c49251b/974d306a-dde1-4a7e-a5ad-f70e5401bf47','77ba3a4e-8b78-433d-9fcd-08fc8c49251b',0,'fb7a790e-58c4-4af6-a897-d1bfecf26599'),(15,'2025-11-22 05:52:24.639765','2025-11-22 05:52:29.876124','2025-11-22 05:52:29.875033',15,'192.168.122.100:6789:/volumes/_nogroup/edcd7366-8dc9-4cca-b6b7-5918f501a054/be6873e1-11f2-4ecf-bd66-a679990ef5e5','edcd7366-8dc9-4cca-b6b7-5918f501a054',0,'1c24281e-9422-459c-acee-de29c03898aa'),(16,'2025-11-22 05:52:36.019935','2025-11-22 05:52:41.767215','2025-11-22 05:52:41.765666',16,'192.168.122.100:6789:/volumes/_nogroup/7eeb2eb3-08e3-495c-afeb-dca50ab5e8a5/bc1db3d8-8ff0-433e-aedb-ad94b12842e8','7eeb2eb3-08e3-495c-afeb-dca50ab5e8a5',0,'a9925777-4236-4a86-93e6-2850710b61fa'),(17,'2025-11-22 05:52:46.224606','2025-11-22 05:56:12.201522','2025-11-22 05:56:12.200510',17,'192.168.122.100:6789:/volumes/_nogroup/5fe2732a-575f-4985-a0be-d017e158a52a/1969f43c-19e4-483b-9ce9-418a6248dbb6','5fe2732a-575f-4985-a0be-d017e158a52a',0,'c4406626-741a-493b-be51-db79097c6cf4'),(18,'2025-11-22 05:52:46.963511','2025-11-22 05:52:52.689877','2025-11-22 05:52:52.688972',18,'192.168.122.100:6789:/volumes/_nogroup/8a3e92b9-37c2-4b00-a3e4-980f0fe980b4/b5b940e8-c013-4465-b0ec-b4309ece8439','8a3e92b9-37c2-4b00-a3e4-980f0fe980b4',0,'894892d9-6d06-41d2-8d85-478f236b3c41'),(19,'2025-11-22 05:52:49.517611','2025-11-22 05:53:06.382831','2025-11-22 05:53:06.381836',19,'192.168.122.100:6789:/volumes/_nogroup/c16ce083-3588-49bf-a148-78d666432c7e/45d846dd-52e4-4021-be9c-dd483665dab7','c16ce083-3588-49bf-a148-78d666432c7e',0,'f3e8bded-e706-4846-8484-039e08cf8685'),(20,'2025-11-22 05:53:09.512352','2025-11-22 05:54:02.893295','2025-11-22 05:54:02.890760',20,'192.168.122.100:6789:/volumes/_nogroup/6eab6156-d31f-4c5e-8b3f-a70a75baac57/2232b3a3-7c3e-452c-8b29-8a48703be23e','6eab6156-d31f-4c5e-8b3f-a70a75baac57',0,'df04b5fa-8f5d-477d-a899-d157a58d4051'),(21,'2025-11-22 05:53:13.794186','2025-11-22 05:53:17.586618','2025-11-22 05:53:17.585790',21,'192.168.122.100:6789:/volumes/_nogroup/bb542e3b-52e7-44e3-82c7-2e32e58f04ae/4125e651-4a97-44bb-80dd-1ec3f2467988','bb542e3b-52e7-44e3-82c7-2e32e58f04ae',0,'00e4d3d9-d0b2-4f09-9f3a-0e96209680e1'),(22,'2025-11-22 05:53:15.090813','2025-11-22 05:54:15.442178','2025-11-22 05:54:15.441190',22,'192.168.122.100:6789:/volumes/_nogroup/576c395a-0c7b-4d45-a49a-9d0c63369a89/fe3882fc-5c1d-4277-ae52-5cdb0f8dabd4','576c395a-0c7b-4d45-a49a-9d0c63369a89',0,'11829666-340e-40d8-818f-744968f63d04'),(23,'2025-11-22 05:53:23.077470','2025-11-22 05:53:29.891408','2025-11-22 05:53:29.889323',23,'192.168.122.100:6789:/volumes/_nogroup/4ea6c199-1cc2-4500-b5d2-1d98c6523e3d/b8b5bbe1-8eb5-4a8f-80c4-17be4b3641c8','4ea6c199-1cc2-4500-b5d2-1d98c6523e3d',0,'06d510e4-d66d-483a-9402-72f8093726f2'),(24,'2025-11-22 05:53:31.094086','2025-11-22 05:53:35.059198','2025-11-22 05:53:35.057951',24,'192.168.122.100:6789:/volumes/_nogroup/8c5801aa-d1a9-4d9f-9257-1e5c7cd7f67f/ae18627c-3451-4550-a306-dbbda1ae497f','8c5801aa-d1a9-4d9f-9257-1e5c7cd7f67f',0,'15770fd3-fef9-4ac3-ac68-b8c85ef9f826'),(25,'2025-11-22 05:53:38.660919','2025-11-22 05:53:45.645402','2025-11-22 05:53:45.643963',25,'192.168.122.100:6789:/volumes/_nogroup/cedb7eed-2602-4012-a237-08eac957da10/77a5abbe-aa03-4f9e-af5b-6e4f8be113a1','cedb7eed-2602-4012-a237-08eac957da10',0,'b84b77a3-2323-4f78-93c0-4174af473176'),(26,'2025-11-22 05:53:51.235603','2025-11-22 05:53:57.108396','2025-11-22 05:53:57.107267',26,'192.168.122.100:6789:/volumes/_nogroup/81a5c3f3-2894-44cc-9d89-89c13467813e/21c62605-f271-484b-9433-f551c39f3528','81a5c3f3-2894-44cc-9d89-89c13467813e',0,'e7dfd9a8-12bb-4529-b206-6c7fa6272a3e'),(27,'2025-11-22 05:53:57.987530','2025-11-22 05:54:09.296358','2025-11-22 05:54:09.295177',27,'192.168.122.100:6789:/volumes/_nogroup/39fe5e7b-616f-4319-8856-cfe7e482fa98/96ca081a-a20b-40f6-85a6-4c80bd24012b','39fe5e7b-616f-4319-8856-cfe7e482fa98',0,'0d70cd41-0160-4920-a4fe-6fb2414edcd9'),(28,'2025-11-22 05:54:02.842883','2025-11-22 05:54:08.221220','2025-11-22 05:54:08.219364',28,'192.168.122.100:6789:/volumes/_nogroup/2d92936c-d826-4675-9b10-c118c0461101/5706d2b5-6899-48ca-9951-7383c7ee3e88','2d92936c-d826-4675-9b10-c118c0461101',0,'aa6b3a0a-7291-4bb4-9130-7a4ef4692081'),(29,'2025-11-22 05:54:15.206236','2025-11-22 05:54:26.674528','2025-11-22 05:54:26.673163',29,'192.168.122.100:6789:/volumes/_nogroup/9c16f3c1-b6c6-4461-9394-db28e06b71e2/f67b824b-8beb-477d-8ba9-6a81941bfc81','9c16f3c1-b6c6-4461-9394-db28e06b71e2',0,'60cee0b2-11be-45fd-888a-7d3775e97488'),(30,'2025-11-22 05:54:18.897170','2025-11-22 05:54:22.680590','2025-11-22 05:54:22.677311',30,'192.168.122.100:6789:/volumes/_nogroup/48201a49-7fb5-455c-9d81-35b89fbf42a0/fa9fdca2-affd-4f18-8502-b2807de07aa9','48201a49-7fb5-455c-9d81-35b89fbf42a0',0,'e9be0069-6100-4725-ac42-2c12b85568a3'),(31,'2025-11-22 05:54:30.210942','2025-11-22 05:54:34.399219','2025-11-22 05:54:34.398016',31,'192.168.122.100:6789:/volumes/_nogroup/d572fcc0-c0a8-4fe7-b2ef-39477199386e/b0ba890e-3caf-43a9-8c21-f3269cff3d1c','d572fcc0-c0a8-4fe7-b2ef-39477199386e',0,'0e27be3c-5c91-49df-baac-9d7fed069735'),(32,'2025-11-22 05:54:39.976352','2025-11-22 05:54:45.469344','2025-11-22 05:54:45.468465',32,'192.168.122.100:6789:/volumes/_nogroup/df2fb1a3-9bc8-42f7-abfc-affd30fb7b3f/05d8faba-ecf7-45b8-97b6-351962e4dbc0','df2fb1a3-9bc8-42f7-abfc-affd30fb7b3f',0,'33db92e2-412c-4f38-ad2a-36347c9750c4'),(33,'2025-11-22 05:54:48.656281','2025-11-22 05:55:54.781481','2025-11-22 05:55:54.780602',33,'192.168.122.100:6789:/volumes/_nogroup/8d03444f-9989-4f30-9672-a2032459f666/37e2a624-9908-48cd-a1ec-1b287d7f34c6','8d03444f-9989-4f30-9672-a2032459f666',0,'12c8de26-fcfd-4de8-998a-bcd076dcf1d6'),(34,'2025-11-22 05:54:52.931950','2025-11-22 05:55:50.940448','2025-11-22 05:55:50.939437',34,'192.168.122.100:6789:/volumes/_nogroup/f96efe4e-dc4d-4c2a-8b79-a56ce8d9f5a2/c9d51eaa-c51e-44ea-97b2-112d07c2dff5','f96efe4e-dc4d-4c2a-8b79-a56ce8d9f5a2',0,'0ddf5cec-c128-4ff3-8183-5b0f2dce7f0a'),(35,'2025-11-22 05:54:59.588530','2025-11-22 05:55:47.452588','2025-11-22 05:55:47.451712',35,'192.168.122.100:6789:/volumes/_nogroup/fdc0a474-b1f3-43ab-b94f-a0eefb55e7b7/d58a3c87-177b-42b3-a6c7-d38a95691a07','fdc0a474-b1f3-43ab-b94f-a0eefb55e7b7',0,'a42ee12d-34d0-4523-b76a-5c318e4e6e11'),(36,'2025-11-22 05:55:04.504168','2025-11-22 05:55:09.290036','2025-11-22 05:55:09.288571',36,'192.168.122.100:6789:/volumes/_nogroup/f776c050-1471-4343-b299-6c3d96952946/0f179af9-6a54-49dc-8297-97efc2c89247','f776c050-1471-4343-b299-6c3d96952946',0,'8108537b-a4ea-472c-99c4-55910b9d9e3e'),(37,'2025-11-22 05:55:28.502375','2025-11-22 05:55:43.743688','2025-11-22 05:55:43.742701',37,'192.168.122.100:6789:/volumes/_nogroup/7bcf26e0-68e7-4e86-801e-5338f311cec3/ee7c5dcf-f783-40a3-8f91-0b5e06a2a160','7bcf26e0-68e7-4e86-801e-5338f311cec3',0,'3fbed100-3a39-4293-96a3-cd8ac144e802'),(38,'2025-11-22 05:55:52.968090','2025-11-22 05:55:52.967029',NULL,0,'192.168.122.100:6789:/volumes/_nogroup/298b8575-0ab5-4c93-992c-f312a6379d92/38fc03b7-57f2-4da0-9099-80a0070afed2','298b8575-0ab5-4c93-992c-f312a6379d92',0,'34f91a20-886e-4bbd-8f45-5fd15b0110e0'),(39,'2025-11-22 05:56:27.642745','2025-11-22 05:57:34.454324','2025-11-22 05:57:34.453061',39,'192.168.122.100:6789:/volumes/_nogroup/9842ed03-cc84-4abe-85fe-b6107828690f/cd47ea4e-104b-41a1-a49e-3bbe887870b3','9842ed03-cc84-4abe-85fe-b6107828690f',0,'3d585614-a181-4f24-92eb-72501824e1b1'),(40,'2025-11-22 05:56:32.286852','2025-11-22 05:56:39.654475','2025-11-22 05:56:39.650742',40,'192.168.122.100:6789:/volumes/_nogroup/6e38d87a-ae0f-4d08-9b46-1181605e24ce/dfb8d971-a771-4d78-801e-f56a0c897c67','6e38d87a-ae0f-4d08-9b46-1181605e24ce',0,'338ff673-aa15-496a-a9c4-91eb4b3c4c94'),(41,'2025-11-22 05:56:34.474779','2025-11-22 05:56:39.114169','2025-11-22 05:56:39.109761',41,'192.168.122.100:6789:/volumes/_nogroup/0e91eaa5-0ca4-4703-941f-d4b008c28620/9c5f7848-1810-45f5-90bd-4da0b4e12458','0e91eaa5-0ca4-4703-941f-d4b008c28620',0,'09d75866-726d-4992-a822-725925ed225d'),(42,'2025-11-22 05:56:42.797547','2025-11-22 05:56:47.036449','2025-11-22 05:56:47.035186',42,'192.168.122.100:6789:/volumes/_nogroup/5465065f-2d60-4371-98a8-d41c3f15e3e4/d794c03f-cc68-438f-ab53-ab449ce94a9b','5465065f-2d60-4371-98a8-d41c3f15e3e4',0,'8258678f-b25f-4c30-8f57-688ccb3d4a4b'),(43,'2025-11-22 05:56:42.946973','2025-11-22 05:56:50.449032','2025-11-22 05:56:50.447147',43,'192.168.122.100:6789:/volumes/_nogroup/b91da8df-240a-407a-a34e-98bfc943cf90/c958a687-734c-4723-975b-2d856dc5a38c','b91da8df-240a-407a-a34e-98bfc943cf90',0,'062b1197-345d-4db4-85ca-8f94880b657e'),(44,'2025-11-22 05:56:45.629866','2025-11-22 05:56:56.153036','2025-11-22 05:56:56.151413',44,'192.168.122.100:6789:/volumes/_nogroup/a73a7b16-fd1c-4116-9ec6-189608a7680b/253b1de9-d2db-4650-96f0-47bcaeb0b597','a73a7b16-fd1c-4116-9ec6-189608a7680b',0,'de2a64aa-6766-4d9b-a903-219be889aa4f'),(45,'2025-11-22 05:56:49.116467','2025-11-22 05:56:52.687915','2025-11-22 05:56:52.686918',45,'192.168.122.100:6789:/volumes/_nogroup/ff1c1ce2-dc9b-48d6-be0f-cc790f23422a/88d7f65e-95b9-4172-a95a-f4d755cdd1a6','ff1c1ce2-dc9b-48d6-be0f-cc790f23422a',0,'4aa7fefb-be42-4249-8f86-9fa71d930c68'),(46,'2025-11-22 05:56:53.697756','2025-11-22 05:57:01.374010','2025-11-22 05:57:01.373076',46,'192.168.122.100:6789:/volumes/_nogroup/194fe9d7-4252-42b8-9e5b-0b7a3e0b3774/b507e83f-d6c3-4469-82d6-9ef7401d92dc','194fe9d7-4252-42b8-9e5b-0b7a3e0b3774',0,'6bb6171b-b474-4adb-8812-7fdb6a4fe09a'),(47,'2025-11-22 05:57:01.339964','2025-11-22 05:57:29.175362','2025-11-22 05:57:29.174456',47,'192.168.122.100:6789:/volumes/_nogroup/41dc1a04-6ad1-4773-8daa-7038ec6071c5/6639e7d9-cff8-4db5-ad3e-c68816264d8c','41dc1a04-6ad1-4773-8daa-7038ec6071c5',0,'15440afd-2085-48dc-bf66-4cbba54c5922'),(48,'2025-11-22 05:57:04.871474','2025-11-22 05:57:08.474959','2025-11-22 05:57:08.473911',48,'192.168.122.100:6789:/volumes/_nogroup/1a737af8-04c5-43cf-b788-696f3029c8ea/f7876278-35ac-4d8c-8e83-4a3bf405da0d','1a737af8-04c5-43cf-b788-696f3029c8ea',0,'8f45bff5-799d-487f-bb6a-74968653ea5e'),(49,'2025-11-22 05:57:05.550981','2025-11-22 05:57:25.578511','2025-11-22 05:57:25.577408',49,'192.168.122.100:6789:/volumes/_nogroup/70f361da-7ed0-4639-8730-40afb694cc73/ad26a09a-a27a-4d84-88d3-d3aebaf8ee77','70f361da-7ed0-4639-8730-40afb694cc73',0,'4fb32fed-9595-4007-acdf-835ba17176dd'),(50,'2025-11-22 05:57:09.509519','2025-11-22 05:57:21.796844','2025-11-22 05:57:21.795453',50,'192.168.122.100:6789:/volumes/_nogroup/c4fc8a89-bd59-4c0a-8c81-0de4fa453851/96ae55b2-c10d-4c4d-aba2-7307ac091022','c4fc8a89-bd59-4c0a-8c81-0de4fa453851',0,'5c5bfd2f-4d62-43fe-8c07-a23fd259a939'),(51,'2025-11-22 05:57:12.072646','2025-11-22 05:57:15.567364','2025-11-22 05:57:15.566406',51,'192.168.122.100:6789:/volumes/_nogroup/31743d3b-c309-45ea-a481-74ddccf572f4/4dc7e141-9510-4f72-9bcc-ee72f74c5328','31743d3b-c309-45ea-a481-74ddccf572f4',0,'db9a4e29-dfec-413b-8f99-4121d62c98db'),(52,'2025-11-22 05:57:13.544675','2025-11-22 05:57:18.128471','2025-11-22 05:57:18.127531',52,'192.168.122.100:6789:/volumes/_nogroup/7ce7ccf0-07b6-4c4b-aace-04a9aa7606fd/752a5e76-6171-49b6-8d52-6564f64d5490','7ce7ccf0-07b6-4c4b-aace-04a9aa7606fd',0,'0b88e8c5-6c60-43ac-8a3d-c3f92b656ec8'),(53,'2025-11-22 05:57:28.505646','2025-11-22 05:57:39.069240','2025-11-22 05:57:39.067648',53,'192.168.122.100:6789:/volumes/_nogroup/c1465b04-fd21-4d9f-bc84-54d95bef1ba1/1dc65209-f162-4234-9229-f8408891283e','c1465b04-fd21-4d9f-bc84-54d95bef1ba1',0,'3b3769ce-f540-42f2-86e1-97d1555cb303'),(54,'2025-11-22 05:57:43.015605','2025-11-22 05:57:47.662154','2025-11-22 05:57:47.660800',54,'192.168.122.100:6789:/volumes/_nogroup/7ea7dcce-e673-4744-867d-5b02c225beea/9b4af366-8ea2-45fc-b9f3-252d74868c92','7ea7dcce-e673-4744-867d-5b02c225beea',0,'526b17c7-aa96-42ed-ab03-dada3723589b'),(55,'2025-11-22 05:57:51.574187','2025-11-22 05:58:12.960172','2025-11-22 05:58:12.959126',55,'192.168.122.100:6789:/volumes/_nogroup/3dcff5a7-454d-46f7-9ff8-546a79d1c07a/e6393510-65ec-437b-80ea-ea4e82cad1d5','3dcff5a7-454d-46f7-9ff8-546a79d1c07a',0,'ba73a334-037c-4079-8aea-b370cdde989c'),(56,'2025-11-22 05:57:54.236835','2025-11-22 05:58:42.388826','2025-11-22 05:58:42.387653',56,'192.168.122.100:6789:/volumes/_nogroup/6262f914-71c2-4411-a49e-54f30a05659d/d5298d09-be9c-4253-95cf-48a2d87c2906','6262f914-71c2-4411-a49e-54f30a05659d',0,'c7559648-0994-48a4-88dc-24f1e98ece04'),(57,'2025-11-22 05:57:59.861888','2025-11-22 05:58:03.728416','2025-11-22 05:58:03.727389',57,'192.168.122.100:6789:/volumes/_nogroup/72cb8e63-63dd-4239-8be6-4c1b98b626ca/c713e64e-23ae-4288-a076-20cc1150a405','72cb8e63-63dd-4239-8be6-4c1b98b626ca',0,'c35c18a2-7b45-461d-9408-ae4d7dce5912'),(58,'2025-11-22 05:58:00.317701','2025-11-22 05:58:11.813161','2025-11-22 05:58:11.811433',58,'192.168.122.100:6789:/volumes/_nogroup/1d9ed15f-ab31-45b4-b3cb-9a2d46be0d63/5506f158-460b-4779-ba08-d52c61847027','1d9ed15f-ab31-45b4-b3cb-9a2d46be0d63',0,'3372723b-a562-419d-a720-804c5424b453'),(59,'2025-11-22 05:58:02.468064','2025-11-22 05:58:06.140062','2025-11-22 05:58:06.138799',59,'192.168.122.100:6789:/volumes/_nogroup/3d00e64c-c6bd-4014-9d75-6c2c64f0dda9/2d2bb832-daca-4d58-88f8-adb59d3125a8','3d00e64c-c6bd-4014-9d75-6c2c64f0dda9',0,'3958c6e9-6f41-45c5-be3c-b47d46caba3c'),(60,'2025-11-22 05:58:07.684651','2025-11-22 05:58:11.424757','2025-11-22 05:58:11.423478',60,'192.168.122.100:6789:/volumes/_nogroup/f93c12a6-84cd-4937-a909-48f837e88319/f12c72f0-2484-491f-8643-f6bc6f74c9b9','f93c12a6-84cd-4937-a909-48f837e88319',0,'cefd4885-7f60-441c-aa48-d8cedb49d225'),(61,'2025-11-22 05:58:15.019654','2025-11-22 05:58:18.802899','2025-11-22 05:58:18.801108',61,'192.168.122.100:6789:/volumes/_nogroup/a58dddbc-e4f6-44cf-84c7-f24633017001/32f76b0f-e2dd-4d20-b947-6b818d336ced','a58dddbc-e4f6-44cf-84c7-f24633017001',0,'af4bb0a0-e215-44a2-b5a8-afa152137818'),(62,'2025-11-22 05:58:22.373845','2025-11-22 05:58:26.471613','2025-11-22 05:58:26.470473',62,'192.168.122.100:6789:/volumes/_nogroup/35291e42-2480-4994-b801-7fa345608cde/23fbbc94-5797-4b0f-9222-520a34c4e3b3','35291e42-2480-4994-b801-7fa345608cde',0,'311c1066-2c9f-4e45-aed8-1ab9351cebf8'),(63,'2025-11-22 05:58:25.736929','2025-11-22 05:58:37.137847','2025-11-22 05:58:37.136797',63,'192.168.122.100:6789:/volumes/_nogroup/04ec723f-2266-44ad-8738-9d300104eaa9/85ab5c73-c5e5-47f4-90d0-573d0a62e3d4','04ec723f-2266-44ad-8738-9d300104eaa9',0,'bc468445-f4d3-4cb6-87f0-65a84b51b5e9'),(64,'2025-11-22 05:58:30.551058','2025-11-22 05:58:34.469132','2025-11-22 05:58:34.467947',64,'192.168.122.100:6789:/volumes/_nogroup/074d9098-d04c-45ea-9d9a-2dcbe0a4b326/69a587a2-4d65-4b86-8897-37a4ec6539ae','074d9098-d04c-45ea-9d9a-2dcbe0a4b326',0,'684866a3-0dd1-40e4-bc28-e03a950b46d1'),(65,'2025-11-22 05:58:40.686855','2025-11-22 05:58:57.484173','2025-11-22 05:58:57.483003',65,'192.168.122.100:6789:/volumes/_nogroup/12681db0-dac5-4be1-a94e-db0502d683a8/3c568fdc-17ef-464c-a06a-00b4ff8ab443','12681db0-dac5-4be1-a94e-db0502d683a8',0,'232c9fa7-a668-41ae-b8fb-cbda17175b74'),(66,'2025-11-22 05:58:45.411572','2025-11-22 05:59:47.020846','2025-11-22 05:59:47.019695',66,'192.168.122.100:6789:/volumes/_nogroup/8ea650d4-0ea6-408a-8107-7d06795baf3e/2856a001-7e16-4367-8d2d-8c670740b800','8ea650d4-0ea6-408a-8107-7d06795baf3e',0,'10884572-a995-411b-84ae-15871212d458'),(67,'2025-11-22 05:59:02.502592','2025-11-22 05:59:40.238700','2025-11-22 05:59:40.237721',67,'192.168.122.100:6789:/volumes/_nogroup/6dd259a0-2767-493c-a1d5-a32b18495137/b0c60bd9-e586-4f2c-ae51-cb9345b16ccf','6dd259a0-2767-493c-a1d5-a32b18495137',0,'6d137ef9-ea61-46e0-9715-6755e6fcd2fe'),(68,'2025-11-22 05:59:05.660075','2025-11-22 05:59:12.710607','2025-11-22 05:59:12.709319',68,'192.168.122.100:6789:/volumes/_nogroup/ea42c00d-c230-4795-b72e-34001c4be0a8/45d523c7-48e0-4017-b73d-76f060af8d78','ea42c00d-c230-4795-b72e-34001c4be0a8',0,'8fa99fe3-42f1-4c50-a021-cfed726ddfbf'),(69,'2025-11-22 05:59:06.887708','2025-11-22 06:00:00.044976','2025-11-22 06:00:00.043991',69,'192.168.122.100:6789:/volumes/_nogroup/18e9f280-7994-4c49-95f7-6a6f9ebabd4f/6fe35774-fe7c-482e-a8a1-07deb2918d0b','18e9f280-7994-4c49-95f7-6a6f9ebabd4f',0,'77855183-64da-4263-bc55-5157967c720d'),(70,'2025-11-22 05:59:08.372584','2025-11-22 05:59:20.162348','2025-11-22 05:59:20.160891',70,'192.168.122.100:6789:/volumes/_nogroup/f58a5d10-062f-4cf1-87a0-845f4b3226dc/3c48588e-3d86-4056-9941-d6869025a183','f58a5d10-062f-4cf1-87a0-845f4b3226dc',0,'cf611992-34fb-462b-a294-8549a40a86e0'),(71,'2025-11-22 05:59:21.188346','2025-11-22 05:59:28.158466','2025-11-22 05:59:28.156854',71,'192.168.122.100:6789:/volumes/_nogroup/ae65e570-cdcd-47ba-b14c-0ccf6fa8b44d/a8455954-0cba-4103-8ac4-4cbfed9264f2','ae65e570-cdcd-47ba-b14c-0ccf6fa8b44d',0,'5fb861e9-268a-4323-8736-01883139c605'),(72,'2025-11-22 05:59:31.701131','2025-11-22 05:59:36.726634','2025-11-22 05:59:36.725718',72,'192.168.122.100:6789:/volumes/_nogroup/fe5f4c39-d36f-406f-9522-4233e36c1e1d/f6d73383-3025-47a0-b600-6fabadae1309','fe5f4c39-d36f-406f-9522-4233e36c1e1d',0,'bed3822d-6d1b-4e4f-a82d-cd285582b1c3'),(73,'2025-11-22 05:59:59.762128','2025-11-22 06:00:12.122971','2025-11-22 06:00:12.122066',73,'192.168.122.100:6789:/volumes/_nogroup/4a01560f-b8db-4a3a-8f6c-493d0f32d091/8014e49f-ebcb-4323-81dc-1b4b21f70232','4a01560f-b8db-4a3a-8f6c-493d0f32d091',0,'108c32c2-f42c-4dd4-9e5f-2cc646188c25');
/*!40000 ALTER TABLE `share_instance_export_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instance_export_locations_metadata`
--

DROP TABLE IF EXISTS `share_instance_export_locations_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instance_export_locations_metadata` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `export_location_id` int(11) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `elm_el_id_uc` (`export_location_id`,`key`,`deleted`),
  CONSTRAINT `elm_id_fk` FOREIGN KEY (`export_location_id`) REFERENCES `share_instance_export_locations` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instance_export_locations_metadata`
--

LOCK TABLES `share_instance_export_locations_metadata` WRITE;
/*!40000 ALTER TABLE `share_instance_export_locations_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_instance_export_locations_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instances`
--

DROP TABLE IF EXISTS `share_instances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instances` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `share_id` varchar(36) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `share_network_id` varchar(36) DEFAULT NULL,
  `share_server_id` varchar(36) DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  `access_rules_status` varchar(255) DEFAULT NULL,
  `replica_state` varchar(255) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  `cast_rules_to_readonly` tinyint(1) NOT NULL,
  `progress` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `si_share_network_fk` (`share_network_id`),
  KEY `si_share_server_fk` (`share_server_id`),
  KEY `si_az_id_fk` (`availability_zone_id`),
  KEY `si_st_id_fk` (`share_type_id`),
  KEY `share_instances_share_id_idx` (`share_id`),
  CONSTRAINT `si_az_id_fk` FOREIGN KEY (`availability_zone_id`) REFERENCES `availability_zones` (`id`),
  CONSTRAINT `si_share_fk` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`),
  CONSTRAINT `si_share_network_fk` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`),
  CONSTRAINT `si_share_server_fk` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`),
  CONSTRAINT `si_st_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instances`
--

LOCK TABLES `share_instances` WRITE;
/*!40000 ALTER TABLE `share_instances` DISABLE KEYS */;
INSERT INTO `share_instances` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_id`, `host`, `status`, `scheduled_at`, `launched_at`, `terminated_at`, `share_network_id`, `share_server_id`, `availability_zone_id`, `access_rules_status`, `replica_state`, `share_type_id`, `cast_rules_to_readonly`, `progress`) VALUES ('2025-11-22 05:58:25.480271','2025-11-22 05:58:37.159895','2025-11-22 05:58:37.159371','04ec723f-2266-44ad-8738-9d300104eaa9','04ec723f-2266-44ad-8738-9d300104eaa9','2181b348-c082-45ec-ab33-041e5328f0c9','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:58:25','2025-11-22 05:58:25','2025-11-22 05:58:36',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'cfea797e-06da-4537-b54d-22f274a0b710',0,'100%'),('2025-11-22 05:58:29.822394','2025-11-22 05:58:34.494544','2025-11-22 05:58:34.493480','074d9098-d04c-45ea-9d9a-2dcbe0a4b326','074d9098-d04c-45ea-9d9a-2dcbe0a4b326','147e8495-aef5-40a9-9e0b-11a0a21056a1','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:58:29','2025-11-22 05:58:30','2025-11-22 05:58:34',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'d59519d5-a66d-4c06-a170-dbc2876b25c1',0,'100%'),('2025-11-22 05:56:34.183922','2025-11-22 05:56:39.131928','2025-11-22 05:56:39.131397','0e91eaa5-0ca4-4703-941f-d4b008c28620','0e91eaa5-0ca4-4703-941f-d4b008c28620','85231eff-df4a-437f-b115-e47d4632d59f','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:56:34','2025-11-22 05:56:34','2025-11-22 05:56:38',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'64c44c63-ca32-44df-83e7-0d5ad0ba1c02',0,'100%'),('2025-11-22 05:54:31.783837','2025-11-22 05:54:35.546771','2025-11-22 05:54:35.545904','10babf3a-77b4-4f0b-806e-434f6c414830','10babf3a-77b4-4f0b-806e-434f6c414830','f2b41e8c-9da0-47f0-8319-319f763a885f','','deleted','2025-11-22 05:54:31',NULL,NULL,NULL,NULL,NULL,'active',NULL,'ce3f0727-d1a8-4676-a5dc-450c47e136e8',0,NULL),('2025-11-22 05:58:40.388789','2025-11-22 05:58:57.504094','2025-11-22 05:58:57.503420','12681db0-dac5-4be1-a94e-db0502d683a8','12681db0-dac5-4be1-a94e-db0502d683a8','4aae7a32-bf67-4f73-bf74-19367ee159cf','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:58:40','2025-11-22 05:58:40','2025-11-22 05:58:52',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'cfea797e-06da-4537-b54d-22f274a0b710',0,'100%'),('2025-11-22 05:50:53.674900','2025-11-22 05:51:06.671225','2025-11-22 05:51:06.670678','15202c81-eb7f-4a9b-b839-74d8d3eac759','15202c81-eb7f-4a9b-b839-74d8d3eac759','5bffd633-0c47-447b-981e-f37827cac197','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:50:53','2025-11-22 05:50:54','2025-11-22 05:51:06',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'72b75a26-0b62-433e-a838-9cd3b4b43b69',0,'100%'),('2025-11-22 05:59:06.540121','2025-11-22 06:00:00.059136','2025-11-22 06:00:00.058600','18e9f280-7994-4c49-95f7-6a6f9ebabd4f','18e9f280-7994-4c49-95f7-6a6f9ebabd4f','fa7e2f81-5e9b-4471-bca4-e46b171d2c36','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:59:06','2025-11-22 05:59:06','2025-11-22 05:59:59',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'229f2490-4a8a-45d0-973b-52a743d76f0f',0,'100%'),('2025-11-22 05:56:53.446006','2025-11-22 05:57:01.386144','2025-11-22 05:57:01.385624','194fe9d7-4252-42b8-9e5b-0b7a3e0b3774','194fe9d7-4252-42b8-9e5b-0b7a3e0b3774','d0a602f8-d218-45aa-b13a-279f40f10b98','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:56:53','2025-11-22 05:56:53','2025-11-22 05:57:00',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'bc6cfada-cc8c-44a7-8599-cc459a4ac116',0,'100%'),('2025-11-22 05:57:04.605581','2025-11-22 05:57:08.500875','2025-11-22 05:57:08.499414','1a737af8-04c5-43cf-b788-696f3029c8ea','1a737af8-04c5-43cf-b788-696f3029c8ea','765683c0-4613-45c1-8ada-72642ad67577','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:57:04','2025-11-22 05:57:04','2025-11-22 05:57:08',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'5426bf6e-b197-4c02-be68-82ee99c5c64e',0,'100%'),('2025-11-22 05:57:59.942978','2025-11-22 05:58:11.832409','2025-11-22 05:58:11.831647','1d9ed15f-ab31-45b4-b3cb-9a2d46be0d63','1d9ed15f-ab31-45b4-b3cb-9a2d46be0d63','59d2283f-fd13-4d0c-acda-f2c67d1bc088','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:58:00','2025-11-22 05:58:00','2025-11-22 05:58:11',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'47b5ed1b-aab2-4f77-a767-0d9e2aea3ca1',0,'100%'),('2025-11-22 05:51:19.105661','2025-11-22 05:51:25.482242','2025-11-22 05:51:25.481577','1f68ab23-30d2-4b25-b726-bc4bc13231e8','1f68ab23-30d2-4b25-b726-bc4bc13231e8','bdee9a86-edbb-4ac8-93c2-57ccdadf521c','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:51:19','2025-11-22 05:51:19','2025-11-22 05:51:25',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'01f563c6-5fd0-4f02-bfc6-595c6cff9c84',0,'100%'),('2025-11-22 05:54:51.536518','2025-11-22 05:54:59.257170','2025-11-22 05:54:59.255912','21c21f8a-9ff9-43bf-9361-88afcb532951','21c21f8a-9ff9-43bf-9361-88afcb532951','1fac7a35-09cc-4c47-873e-f63ac427a11e','','deleted','2025-11-22 05:54:51',NULL,NULL,NULL,NULL,NULL,'active',NULL,'734709e5-5e22-4d51-b713-3988d1991371',0,NULL),('2025-11-22 05:51:23.729437','2025-11-22 05:51:27.365083','2025-11-22 05:51:27.364212','27ec511b-63e8-403b-970e-3dfea58f7f24','27ec511b-63e8-403b-970e-3dfea58f7f24','0e4c9edf-33f0-4fb6-9de3-585d7dfa83c7','','deleted','2025-11-22 05:51:23',NULL,NULL,NULL,NULL,NULL,'active',NULL,'ba0277e3-3973-4052-b400-a5c0085d5c63',0,NULL),('2025-11-22 05:55:52.699085','2025-11-22 05:56:01.624696',NULL,'False','298b8575-0ab5-4c93-992c-f312a6379d92','6421908b-395a-471b-82f0-f6641bffe29d','hostgroup@cephfs#cephfs','available','2025-11-22 05:55:52','2025-11-22 05:55:52',NULL,NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'3f5f10b5-5a29-4a2e-a4a9-9c80d7a9b422',0,'100%'),('2025-11-22 05:51:13.819134','2025-11-22 05:51:18.029421','2025-11-22 05:51:18.028776','2cac985c-91b9-4f35-a81a-295d69c728b5','2cac985c-91b9-4f35-a81a-295d69c728b5','4ad36ae6-9cd6-4471-b6a3-c5688ef1f23f','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:51:13','2025-11-22 05:51:14','2025-11-22 05:51:17',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'ae29560b-3995-49db-8651-d9dca4b5c54c',0,'100%'),('2025-11-22 05:53:22.283717','2025-11-22 05:54:08.241976','2025-11-22 05:54:08.241224','2d92936c-d826-4675-9b10-c118c0461101','2d92936c-d826-4675-9b10-c118c0461101','bd3228e3-2f52-48e2-a88c-d28e65ec129c','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:53:22','2025-11-22 05:53:25','2025-11-22 05:54:08',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'13ee97c5-d501-438f-a1cb-88b356e6aea5',0,'100%'),('2025-11-22 05:57:11.770176','2025-11-22 05:57:15.579548','2025-11-22 05:57:15.579018','31743d3b-c309-45ea-a481-74ddccf572f4','31743d3b-c309-45ea-a481-74ddccf572f4','5ee936c0-72b4-469f-a052-0c7dc93a880f','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:57:11','2025-11-22 05:57:12','2025-11-22 05:57:15',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'5426bf6e-b197-4c02-be68-82ee99c5c64e',0,'100%'),('2025-11-22 05:55:07.480909','2025-11-22 05:55:11.064725','2025-11-22 05:55:11.064153','33e457b3-ce03-42f6-98f3-1f66bc81d06a','33e457b3-ce03-42f6-98f3-1f66bc81d06a','a012a75f-0920-4bd5-9cef-c0c84eb53ca5','','deleted','2025-11-22 05:55:07',NULL,NULL,NULL,NULL,NULL,'active',NULL,'96afc477-3877-4b27-b4cf-f6aaa221d409',0,NULL),('2025-11-22 05:54:43.453719','2025-11-22 05:54:47.123432','2025-11-22 05:54:47.122779','34546019-726c-449c-b058-33988574269d','34546019-726c-449c-b058-33988574269d','3fbb9374-949b-4b92-bd96-bf00b070b292','','deleted','2025-11-22 05:54:43',NULL,NULL,NULL,NULL,NULL,'active',NULL,'69975aa8-2ab7-43ef-9ea3-bf3bb458d4bc',0,NULL),('2025-11-22 05:58:22.095451','2025-11-22 05:58:26.485720','2025-11-22 05:58:26.485155','35291e42-2480-4994-b801-7fa345608cde','35291e42-2480-4994-b801-7fa345608cde','c43e7c8b-3603-42ea-aa7c-9c05f1853f0e','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:58:22','2025-11-22 05:58:22','2025-11-22 05:58:26',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'d59519d5-a66d-4c06-a170-dbc2876b25c1',0,'100%'),('2025-11-22 05:55:03.342451','2025-11-22 05:55:07.008212','2025-11-22 05:55:07.007680','37f04a42-bbeb-44af-8956-4a7716188e33','37f04a42-bbeb-44af-8956-4a7716188e33','73cf6a38-fffe-415b-bd26-1bc690525347','','deleted','2025-11-22 05:55:03',NULL,NULL,NULL,NULL,NULL,'active',NULL,'f359449b-fe9e-4653-86a0-8fec8f992613',0,NULL),('2025-11-22 05:53:57.750747','2025-11-22 05:54:09.313054','2025-11-22 05:54:09.312523','39fe5e7b-616f-4319-8856-cfe7e482fa98','39fe5e7b-616f-4319-8856-cfe7e482fa98','b14078d0-94ef-4a05-a729-d7de8cfbf0a4','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:53:57','2025-11-22 05:53:58','2025-11-22 05:54:09',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'a5b83cc3-3a22-4b5e-9258-2ea0c4739722',0,'100%'),('2025-11-22 05:57:55.789987','2025-11-22 05:58:06.160866','2025-11-22 05:58:06.160193','3d00e64c-c6bd-4014-9d75-6c2c64f0dda9','3d00e64c-c6bd-4014-9d75-6c2c64f0dda9','d9c461b7-5bb4-48ae-ba3a-231acbbfb736','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:57:55','2025-11-22 05:57:56','2025-11-22 05:58:05',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'0a1faf7d-a096-4ae6-821a-0cea16578a95',0,'100%'),('2025-11-22 05:57:51.238699','2025-11-22 05:58:12.976130','2025-11-22 05:58:12.975329','3dcff5a7-454d-46f7-9ff8-546a79d1c07a','3dcff5a7-454d-46f7-9ff8-546a79d1c07a','fa786287-7fdf-4612-aca2-817bfa149b97','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:57:51','2025-11-22 05:57:51','2025-11-22 05:58:12',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'0a1faf7d-a096-4ae6-821a-0cea16578a95',0,'100%'),('2025-11-22 05:57:01.058661','2025-11-22 05:57:29.192148','2025-11-22 05:57:29.191396','41dc1a04-6ad1-4773-8daa-7038ec6071c5','41dc1a04-6ad1-4773-8daa-7038ec6071c5','955a07b8-e5ce-48f7-afed-554d36afb2bb','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:57:01','2025-11-22 05:57:01','2025-11-22 05:57:28',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'33ab82b2-9d13-455f-b64f-cb0f7247c292',0,'100%'),('2025-11-22 05:54:18.535216','2025-11-22 05:54:22.701009','2025-11-22 05:54:22.700472','48201a49-7fb5-455c-9d81-35b89fbf42a0','48201a49-7fb5-455c-9d81-35b89fbf42a0','f3333f1b-e538-4076-90c8-83c744ff197c','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:54:18','2025-11-22 05:54:18','2025-11-22 05:54:22',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'a4dd46bb-4dd9-48bd-92ee-1a6f0e9dbfe6',0,'100%'),('2025-11-22 05:59:59.459089','2025-11-22 06:00:12.155824','2025-11-22 06:00:12.155102','4a01560f-b8db-4a3a-8f6c-493d0f32d091','4a01560f-b8db-4a3a-8f6c-493d0f32d091','511ae11a-c61d-4a3c-97ca-4eb2a5c1ee1a','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:59:59','2025-11-22 05:59:59','2025-11-22 06:00:11',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'4940c47f-fec8-4869-8fba-d842e9b292ea',0,'100%'),('2025-11-22 05:50:54.199452','2025-11-22 05:50:59.404417','2025-11-22 05:50:59.403754','4d695e4c-80d1-4558-8e35-fa4463b56489','4d695e4c-80d1-4558-8e35-fa4463b56489','0cfaf80f-3065-460f-a44d-408b8b49e173','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:50:54','2025-11-22 05:50:55','2025-11-22 05:50:59',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'ae29560b-3995-49db-8651-d9dca4b5c54c',0,'100%'),('2025-11-22 05:53:21.246182','2025-11-22 05:53:29.933963','2025-11-22 05:53:29.931677','4ea6c199-1cc2-4500-b5d2-1d98c6523e3d','4ea6c199-1cc2-4500-b5d2-1d98c6523e3d','19dc7213-05d0-44ba-8191-d795ad527b71','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:53:21','2025-11-22 05:53:24','2025-11-22 05:53:27',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'16388226-9203-43cc-b11b-c8d5e0b43cf5',0,'100%'),('2025-11-22 05:56:42.522540','2025-11-22 05:56:47.055246','2025-11-22 05:56:47.054523','5465065f-2d60-4371-98a8-d41c3f15e3e4','5465065f-2d60-4371-98a8-d41c3f15e3e4','91d3c28c-780f-4b34-8033-da786bbb63be','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:56:42','2025-11-22 05:56:42','2025-11-22 05:56:46',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'64c44c63-ca32-44df-83e7-0d5ad0ba1c02',0,'100%'),('2025-11-22 05:54:55.384572','2025-11-22 05:54:58.975341','2025-11-22 05:54:58.974120','555e0f37-6d92-4860-b215-1f4c02e065be','555e0f37-6d92-4860-b215-1f4c02e065be','e376fddc-de34-4fd0-b102-8ee7a264cef2','','deleted','2025-11-22 05:54:55',NULL,NULL,NULL,NULL,NULL,'active',NULL,'56215025-9394-421b-abc0-95508b2f4030',0,NULL),('2025-11-22 05:53:14.400481','2025-11-22 05:54:15.485038','2025-11-22 05:54:15.484495','576c395a-0c7b-4d45-a49a-9d0c63369a89','576c395a-0c7b-4d45-a49a-9d0c63369a89','d36c5b07-c6d1-453f-8e87-355ac7d60dc7','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:53:14','2025-11-22 05:53:15','2025-11-22 05:54:15',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'13ee97c5-d501-438f-a1cb-88b356e6aea5',0,'100%'),('2025-11-22 05:54:47.732788','2025-11-22 05:54:59.509500','2025-11-22 05:54:59.508803','58c43674-830c-4449-8f15-36223240b43b','58c43674-830c-4449-8f15-36223240b43b','ae02f817-c399-4fe3-9e4e-d95a2069a588','','deleted','2025-11-22 05:54:47',NULL,NULL,NULL,NULL,NULL,'active',NULL,'087a7cbd-37cd-4168-a9ba-348c6ff7993e',0,NULL),('2025-11-22 05:52:45.826690','2025-11-22 05:56:12.274912','2025-11-22 05:56:12.274361','5fe2732a-575f-4985-a0be-d017e158a52a','5fe2732a-575f-4985-a0be-d017e158a52a','8efd43bb-f9b3-4447-86c4-e3920bc619c4','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:52:45','2025-11-22 05:52:46','2025-11-22 05:56:12',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'3f5f10b5-5a29-4a2e-a4a9-9c80d7a9b422',0,'100%'),('2025-11-22 05:57:53.859609','2025-11-22 05:58:42.409548','2025-11-22 05:58:42.408849','6262f914-71c2-4411-a49e-54f30a05659d','6262f914-71c2-4411-a49e-54f30a05659d','8fc96ffe-58ec-4a01-9152-6a45bed340d3','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:57:53','2025-11-22 05:57:54','2025-11-22 05:58:42',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'d59519d5-a66d-4c06-a170-dbc2876b25c1',0,'100%'),('2025-11-22 05:54:39.932216','2025-11-22 05:54:47.457868','2025-11-22 05:54:47.457332','696381a6-1ebc-49b8-a2f8-ad12dd0a3842','696381a6-1ebc-49b8-a2f8-ad12dd0a3842','4e22476f-a1eb-4f31-841d-b0a5e59503e4','','deleted','2025-11-22 05:54:39',NULL,NULL,NULL,NULL,NULL,'active',NULL,'08c8c52d-b3da-414c-a61c-d2410111b7e1',0,NULL),('2025-11-22 05:51:21.382147','2025-11-22 05:51:25.320547','2025-11-22 05:51:25.319905','6c1cff93-cfe8-43e8-b934-82a3cf7b6030','6c1cff93-cfe8-43e8-b934-82a3cf7b6030','95514f8e-35ec-4fb8-b06a-9b72b929572f','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:51:21','2025-11-22 05:51:21','2025-11-22 05:51:25',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'ae29560b-3995-49db-8651-d9dca4b5c54c',0,'100%'),('2025-11-22 05:58:48.946397','2025-11-22 05:59:40.254960','2025-11-22 05:59:40.254428','6dd259a0-2767-493c-a1d5-a32b18495137','6dd259a0-2767-493c-a1d5-a32b18495137','66ad6cfd-e916-46a6-bd0a-171cccdc89bc','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:58:48','2025-11-22 05:58:52','2025-11-22 05:59:40',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'6630451a-185f-4b7a-8306-f600314a71e1',0,'100%'),('2025-11-22 05:56:31.942855','2025-11-22 05:56:39.679587','2025-11-22 05:56:39.678866','6e38d87a-ae0f-4d08-9b46-1181605e24ce','6e38d87a-ae0f-4d08-9b46-1181605e24ce','535805ac-c11f-4da9-b23b-e9f0311f7416','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:56:32','2025-11-22 05:56:32','2025-11-22 05:56:38',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'bc6cfada-cc8c-44a7-8599-cc459a4ac116',0,'100%'),('2025-11-22 05:53:09.242030','2025-11-22 05:54:02.911134','2025-11-22 05:54:02.910626','6eab6156-d31f-4c5e-8b3f-a70a75baac57','6eab6156-d31f-4c5e-8b3f-a70a75baac57','ebd2d532-e2e2-40cc-8718-7ba6b480684f','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:53:09','2025-11-22 05:53:09','2025-11-22 05:54:02',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'16388226-9203-43cc-b11b-c8d5e0b43cf5',0,'100%'),('2025-11-22 05:57:05.226967','2025-11-22 05:57:25.598235','2025-11-22 05:57:25.597652','70f361da-7ed0-4639-8730-40afb694cc73','70f361da-7ed0-4639-8730-40afb694cc73','d62e9bd9-0999-49d2-988c-dde42208cae5','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:57:05','2025-11-22 05:57:05','2025-11-22 05:57:25',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'33ab82b2-9d13-455f-b64f-cb0f7247c292',0,'100%'),('2025-11-22 05:57:59.578218','2025-11-22 05:58:03.743555','2025-11-22 05:58:03.743036','72cb8e63-63dd-4239-8be6-4c1b98b626ca','72cb8e63-63dd-4239-8be6-4c1b98b626ca','7fa27812-115e-40eb-9f44-8d109734f95e','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:57:59','2025-11-22 05:57:59','2025-11-22 05:58:03',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'d59519d5-a66d-4c06-a170-dbc2876b25c1',0,'100%'),('2025-11-22 05:52:00.660684','2025-11-22 05:52:20.257095','2025-11-22 05:52:20.256480','77ba3a4e-8b78-433d-9fcd-08fc8c49251b','77ba3a4e-8b78-433d-9fcd-08fc8c49251b','a5a4d39a-6afc-47ca-a64e-59baa4b6d20b','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:52:00','2025-11-22 05:52:01','2025-11-22 05:52:20',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'72fda760-d07e-4ff4-b88e-2511b31404ed',0,'100%'),('2025-11-22 05:55:28.150156','2025-11-22 05:55:43.759986','2025-11-22 05:55:43.759470','7bcf26e0-68e7-4e86-801e-5338f311cec3','7bcf26e0-68e7-4e86-801e-5338f311cec3','06610748-6de1-49ce-9a00-b0cc5a383015','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:55:28','2025-11-22 05:55:28','2025-11-22 05:55:43',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'6aa6c955-bb1a-4082-b637-96733e409710',0,'100%'),('2025-11-22 05:57:13.236434','2025-11-22 05:57:18.142990','2025-11-22 05:57:18.142469','7ce7ccf0-07b6-4c4b-aace-04a9aa7606fd','7ce7ccf0-07b6-4c4b-aace-04a9aa7606fd','454c896f-ee5c-43cc-af2b-3cf311c7ba49','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:57:13','2025-11-22 05:57:13','2025-11-22 05:57:17',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'33ab82b2-9d13-455f-b64f-cb0f7247c292',0,'100%'),('2025-11-22 05:51:11.149664','2025-11-22 05:51:18.743000','2025-11-22 05:51:18.742470','7d6b5119-ad0e-4013-9a5e-284fedb56378','7d6b5119-ad0e-4013-9a5e-284fedb56378','c1402d2f-9c53-426d-a2ae-7a63c8aac5a5','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:51:11','2025-11-22 05:51:11','2025-11-22 05:51:18',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'5e508b15-d618-4a27-8b79-1b26df71e665',0,'100%'),('2025-11-22 05:57:42.683863','2025-11-22 05:57:47.709166','2025-11-22 05:57:47.708552','7ea7dcce-e673-4744-867d-5b02c225beea','7ea7dcce-e673-4744-867d-5b02c225beea','faeaa260-b2b9-4f76-bea6-38a9e85e461b','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:57:42','2025-11-22 05:57:43','2025-11-22 05:57:47',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'e92e4c96-7852-4844-a49a-2fed8941ce22',0,'100%'),('2025-11-22 05:52:35.761751','2025-11-22 05:52:41.791452','2025-11-22 05:52:41.790577','7eeb2eb3-08e3-495c-afeb-dca50ab5e8a5','7eeb2eb3-08e3-495c-afeb-dca50ab5e8a5','49fe7532-02b6-4da3-9369-3026c6bddc7a','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:52:35','2025-11-22 05:52:36','2025-11-22 05:52:41',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'d4fe4178-7457-4c27-b05c-d200652bfa09',0,'100%'),('2025-11-22 05:53:50.972321','2025-11-22 05:53:57.123196','2025-11-22 05:53:57.122595','81a5c3f3-2894-44cc-9d89-89c13467813e','81a5c3f3-2894-44cc-9d89-89c13467813e','c9ccb6a9-0027-4763-9baa-55495ae7c41e','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:53:51','2025-11-22 05:53:51','2025-11-22 05:53:56',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'16388226-9203-43cc-b11b-c8d5e0b43cf5',0,'100%'),('2025-11-22 05:52:46.701970','2025-11-22 05:52:52.704201','2025-11-22 05:52:52.703680','8a3e92b9-37c2-4b00-a3e4-980f0fe980b4','8a3e92b9-37c2-4b00-a3e4-980f0fe980b4','50e9c087-b3da-4d49-8759-fa6cdcb53af9','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:52:46','2025-11-22 05:52:46','2025-11-22 05:52:52',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'f5058f8f-6143-4b6d-8d20-02b50ffa22a6',0,'100%'),('2025-11-22 05:53:30.851643','2025-11-22 05:53:35.147907','2025-11-22 05:53:35.147187','8c5801aa-d1a9-4d9f-9257-1e5c7cd7f67f','8c5801aa-d1a9-4d9f-9257-1e5c7cd7f67f','7369001b-8b56-4f95-95a7-cdaf74673b72','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:53:30','2025-11-22 05:53:31','2025-11-22 05:53:34',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'16388226-9203-43cc-b11b-c8d5e0b43cf5',0,'100%'),('2025-11-22 05:54:48.402475','2025-11-22 05:55:54.794098','2025-11-22 05:55:54.793587','8d03444f-9989-4f30-9672-a2032459f666','8d03444f-9989-4f30-9672-a2032459f666','e6ebf7ae-934a-4ccf-9ab6-5b62a19c9509','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:54:48','2025-11-22 05:54:48','2025-11-22 05:55:54',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'6aa6c955-bb1a-4082-b637-96733e409710',0,'100%'),('2025-11-22 05:58:44.574184','2025-11-22 05:59:47.034941','2025-11-22 05:59:47.034455','8ea650d4-0ea6-408a-8107-7d06795baf3e','8ea650d4-0ea6-408a-8107-7d06795baf3e','eb009558-f725-445d-90b6-32ce03b569d0','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:58:44','2025-11-22 05:58:45','2025-11-22 05:59:46',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'6630451a-185f-4b7a-8306-f600314a71e1',0,'100%'),('2025-11-22 05:56:26.083383','2025-11-22 05:57:34.469597','2025-11-22 05:57:34.469031','9842ed03-cc84-4abe-85fe-b6107828690f','9842ed03-cc84-4abe-85fe-b6107828690f','82f5a7b8-b11a-4b98-ac40-9540006a2619','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:56:26','2025-11-22 05:56:27','2025-11-22 05:57:34',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'bc6cfada-cc8c-44a7-8599-cc459a4ac116',0,'100%'),('2025-11-22 05:51:27.690834','2025-11-22 05:51:31.309970','2025-11-22 05:51:31.307702','9c16da92-694f-4b4f-aa11-68f8a7ba47e9','9c16da92-694f-4b4f-aa11-68f8a7ba47e9','63401021-32bf-4f9e-abf0-806c9549b2d3','','deleted','2025-11-22 05:51:27',NULL,NULL,NULL,NULL,NULL,'active',NULL,'170222eb-0fff-44bb-9ac3-bc5681dd8de2',0,NULL),('2025-11-22 05:54:14.817609','2025-11-22 05:54:26.690354','2025-11-22 05:54:26.689804','9c16f3c1-b6c6-4461-9394-db28e06b71e2','9c16f3c1-b6c6-4461-9394-db28e06b71e2','f21cb0fb-7bd7-47da-8c9d-8be6d286e1f2','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:54:14','2025-11-22 05:54:15','2025-11-22 05:54:26',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'a4dd46bb-4dd9-48bd-92ee-1a6f0e9dbfe6',0,'100%'),('2025-11-22 05:58:14.689156','2025-11-22 05:58:18.819971','2025-11-22 05:58:18.819207','a58dddbc-e4f6-44cf-84c7-f24633017001','a58dddbc-e4f6-44cf-84c7-f24633017001','25902542-4afd-4494-91f3-1388b0c6aecb','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:58:14','2025-11-22 05:58:15','2025-11-22 05:58:18',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'d59519d5-a66d-4c06-a170-dbc2876b25c1',0,'100%'),('2025-11-22 05:56:45.334438','2025-11-22 05:56:56.169041','2025-11-22 05:56:56.168337','a73a7b16-fd1c-4116-9ec6-189608a7680b','a73a7b16-fd1c-4116-9ec6-189608a7680b','c6ab1cc0-cdda-41fe-aa61-b68b6c83d06f','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:56:45','2025-11-22 05:56:45','2025-11-22 05:56:55',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'5426bf6e-b197-4c02-be68-82ee99c5c64e',0,'100%'),('2025-11-22 05:59:20.612904','2025-11-22 05:59:28.179569','2025-11-22 05:59:28.178630','ae65e570-cdcd-47ba-b14c-0ccf6fa8b44d','ae65e570-cdcd-47ba-b14c-0ccf6fa8b44d','ec39ec6c-4d9a-48ba-8699-5768bc4f8f85','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:59:20','2025-11-22 05:59:21','2025-11-22 05:59:27',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'6630451a-185f-4b7a-8306-f600314a71e1',0,'100%'),('2025-11-22 05:50:49.687938','2025-11-22 05:52:23.066153','2025-11-22 05:52:23.065245','af20cd9a-8203-491f-b76d-599ebd8046ec','af20cd9a-8203-491f-b76d-599ebd8046ec','e3f37aa3-6df4-4c21-afa2-3d3d20a6917e','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:50:49','2025-11-22 05:50:51','2025-11-22 05:52:22',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'ae29560b-3995-49db-8651-d9dca4b5c54c',0,'100%'),('2025-11-22 05:54:35.945404','2025-11-22 05:54:39.641363','2025-11-22 05:54:39.640783','b52ddca5-4662-4cc5-9f14-cee1e5e05371','b52ddca5-4662-4cc5-9f14-cee1e5e05371','c51b35d0-72fb-4c33-9c66-387b1f86a20f','','deleted','2025-11-22 05:54:35',NULL,NULL,NULL,NULL,NULL,'active',NULL,'dcc3507b-971d-43d8-92d2-0d2d0d8c3319',0,NULL),('2025-11-22 05:56:42.636972','2025-11-22 05:56:50.468902','2025-11-22 05:56:50.467958','b91da8df-240a-407a-a34e-98bfc943cf90','b91da8df-240a-407a-a34e-98bfc943cf90','8c4d1c7d-bcbe-428a-add3-a107e25e1608','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:56:42','2025-11-22 05:56:42','2025-11-22 05:56:49',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'bc6cfada-cc8c-44a7-8599-cc459a4ac116',0,'100%'),('2025-11-22 05:53:12.936928','2025-11-22 05:53:17.601195','2025-11-22 05:53:17.600567','bb542e3b-52e7-44e3-82c7-2e32e58f04ae','bb542e3b-52e7-44e3-82c7-2e32e58f04ae','e6284ec1-39ae-44d4-b9e1-86b6e30cae7b','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:53:13','2025-11-22 05:53:13','2025-11-22 05:53:17',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'16388226-9203-43cc-b11b-c8d5e0b43cf5',0,'100%'),('2025-11-22 05:51:44.488629','2025-11-22 05:52:09.373192','2025-11-22 05:52:09.372463','bbda1cfd-a62a-4d0a-87fc-e66cc4fb1bbd','bbda1cfd-a62a-4d0a-87fc-e66cc4fb1bbd','4967e6e3-b2cc-45b4-b463-17f7bce6ae8e','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:51:44','2025-11-22 05:51:44','2025-11-22 05:52:08',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'83710f66-5331-429a-9190-c955e72a6981',0,'100%'),('2025-11-22 05:57:28.088339','2025-11-22 05:57:39.088182','2025-11-22 05:57:39.087483','c1465b04-fd21-4d9f-bc84-54d95bef1ba1','c1465b04-fd21-4d9f-bc84-54d95bef1ba1','dc95832f-bd83-4269-86ac-bbbfcc21bdfa','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:57:28','2025-11-22 05:57:28','2025-11-22 05:57:38',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'2b6505d8-6c33-411c-9b84-112503c4c108',0,'100%'),('2025-11-22 05:52:49.236757','2025-11-22 05:53:06.396271','2025-11-22 05:53:06.395728','c16ce083-3588-49bf-a148-78d666432c7e','c16ce083-3588-49bf-a148-78d666432c7e','6a28629c-ec25-4d9e-89ce-28477e9b25bb','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:52:49','2025-11-22 05:52:49','2025-11-22 05:53:06',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'55c95d49-aa56-4fad-870f-b645f28cd680',0,'100%'),('2025-11-22 05:57:09.106082','2025-11-22 05:57:21.815616','2025-11-22 05:57:21.814941','c4fc8a89-bd59-4c0a-8c81-0de4fa453851','c4fc8a89-bd59-4c0a-8c81-0de4fa453851','3d52ca5b-a434-47f0-a9bc-5e058cdeadc4','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:57:09','2025-11-22 05:57:09','2025-11-22 05:57:21',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'33ab82b2-9d13-455f-b64f-cb0f7247c292',0,'100%'),('2025-11-22 05:53:38.297630','2025-11-22 05:53:45.664938','2025-11-22 05:53:45.664190','cedb7eed-2602-4012-a237-08eac957da10','cedb7eed-2602-4012-a237-08eac957da10','5dc5dd92-1904-4853-8e49-7d3d2ef9af9d','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:53:38','2025-11-22 05:53:38','2025-11-22 05:53:45',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'16388226-9203-43cc-b11b-c8d5e0b43cf5',0,'100%'),('2025-11-22 05:54:29.950959','2025-11-22 05:54:34.414198','2025-11-22 05:54:34.413568','d572fcc0-c0a8-4fe7-b2ef-39477199386e','d572fcc0-c0a8-4fe7-b2ef-39477199386e','6634bb0b-8adf-429e-9684-537da874f36d','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:54:30','2025-11-22 05:54:30','2025-11-22 05:54:34',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'a4dd46bb-4dd9-48bd-92ee-1a6f0e9dbfe6',0,'100%'),('2025-11-22 05:51:02.761778','2025-11-22 05:51:10.374560','2025-11-22 05:51:10.373870','d9b34a10-7e37-4811-ad95-28431845630c','d9b34a10-7e37-4811-ad95-28431845630c','ab6d4ef7-870a-4a7d-a86c-dcee3a6035b0','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:51:02','2025-11-22 05:51:04','2025-11-22 05:51:10',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'ae29560b-3995-49db-8651-d9dca4b5c54c',0,'100%'),('2025-11-22 05:54:39.728618','2025-11-22 05:54:45.485808','2025-11-22 05:54:45.485203','df2fb1a3-9bc8-42f7-abfc-affd30fb7b3f','df2fb1a3-9bc8-42f7-abfc-affd30fb7b3f','2d84ba4d-c3d7-42b6-ab7f-d9b35fae6828','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:54:39','2025-11-22 05:54:39','2025-11-22 05:54:44',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'4ef04f31-d6fe-496c-bd09-358cf74fb9ed',0,'100%'),('2025-11-22 05:51:15.710662','2025-11-22 05:51:19.464682','2025-11-22 05:51:19.463928','e1d5b302-437e-4b21-90df-7c6bf8fb6ae5','e1d5b302-437e-4b21-90df-7c6bf8fb6ae5','6a899e7f-5787-4b0b-81cc-6279b40ff3cf','','deleted','2025-11-22 05:51:15',NULL,NULL,NULL,NULL,NULL,'active',NULL,'4b9d7651-19c5-43ac-bb58-20f5ebca2afc',0,NULL),('2025-11-22 05:51:37.927775','2025-11-22 05:52:08.703125','2025-11-22 05:52:08.702469','e41b5283-9e15-4f8b-9973-4c9089dccbfc','e41b5283-9e15-4f8b-9973-4c9089dccbfc','94375a59-a60d-4a02-88c7-a97c1daf9744','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:51:37','2025-11-22 05:51:38','2025-11-22 05:52:08',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'76b8f610-7bd5-4886-9698-850dd629ddbd',0,'100%'),('2025-11-22 05:51:31.719711','2025-11-22 05:51:35.209715','2025-11-22 05:51:35.208948','e65582d6-1656-4557-a191-6bf6c06ec977','e65582d6-1656-4557-a191-6bf6c06ec977','a0d78e53-1fa5-44a4-b34b-0adf8704cec3','','deleted','2025-11-22 05:51:31',NULL,NULL,NULL,NULL,NULL,'active',NULL,'2b6b3050-6c17-4581-9b45-8c5482542326',0,NULL),('2025-11-22 05:59:05.356200','2025-11-22 05:59:12.728523','2025-11-22 05:59:12.727814','ea42c00d-c230-4795-b72e-34001c4be0a8','ea42c00d-c230-4795-b72e-34001c4be0a8','e86c045c-ceab-444c-a106-8615dd89c419','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:59:05','2025-11-22 05:59:05','2025-11-22 05:59:12',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'6630451a-185f-4b7a-8306-f600314a71e1',0,'100%'),('2025-11-22 05:52:24.420166','2025-11-22 05:52:29.898127','2025-11-22 05:52:29.897240','edcd7366-8dc9-4cca-b6b7-5918f501a054','edcd7366-8dc9-4cca-b6b7-5918f501a054','be478238-e7db-4a78-aa18-c53b49f1f67f','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:52:24','2025-11-22 05:52:24','2025-11-22 05:52:29',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'a2eae7d4-7042-401a-973a-249989b912a4',0,'100%'),('2025-11-22 05:51:07.045477','2025-11-22 05:51:15.250030','2025-11-22 05:51:15.249288','f30f85a5-1564-4626-84fb-0c570e11fc93','f30f85a5-1564-4626-84fb-0c570e11fc93','9641e455-326f-4fff-bb3f-88c8298ee465','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:51:07','2025-11-22 05:51:07','2025-11-22 05:51:15',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'23542ce2-0314-4df7-8304-4afa45fe5db2',0,'100%'),('2025-11-22 05:59:08.079556','2025-11-22 05:59:20.224581','2025-11-22 05:59:20.223437','f58a5d10-062f-4cf1-87a0-845f4b3226dc','f58a5d10-062f-4cf1-87a0-845f4b3226dc','d30ad785-8ea6-4ab6-b62c-a912cd632ebc','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:59:08','2025-11-22 05:59:08','2025-11-22 05:59:19',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'100c722e-6c00-4303-ac29-b6525536cfc3',0,'100%'),('2025-11-22 05:50:54.764297','2025-11-22 05:50:59.195771','2025-11-22 05:50:59.194651','f6b1d082-aa60-414d-aa02-6f616d2261dc','f6b1d082-aa60-414d-aa02-6f616d2261dc','cf2f7487-22e4-44c3-a53b-c8e5429e4682','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:50:54','2025-11-22 05:50:55','2025-11-22 05:50:59',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'5cd9ff63-cfd0-4053-a66f-0941fbf95643',0,'100%'),('2025-11-22 05:55:04.265741','2025-11-22 05:55:09.309470','2025-11-22 05:55:09.308455','f776c050-1471-4343-b299-6c3d96952946','f776c050-1471-4343-b299-6c3d96952946','47b40d49-baff-45d8-8c77-f762454c8623','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:55:04','2025-11-22 05:55:04','2025-11-22 05:55:09',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'e3483182-8b2a-4128-9f1a-b73d4873cc06',0,'100%'),('2025-11-22 05:51:42.198063','2025-11-22 05:52:05.347795','2025-11-22 05:52:05.346962','f7e75bd1-474d-4276-b05f-3f57f661f123','f7e75bd1-474d-4276-b05f-3f57f661f123','3f35616a-a117-49b4-9a27-e63f99a9bdc4','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:51:42','2025-11-22 05:51:42','2025-11-22 05:52:04',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'0c31157a-4a41-48b4-a5d8-48543e507fe9',0,'100%'),('2025-11-22 05:54:59.859509','2025-11-22 05:55:07.205820','2025-11-22 05:55:07.205190','f877ec16-dc04-4bd8-b967-33685ace23f2','f877ec16-dc04-4bd8-b967-33685ace23f2','4ebcd134-e7f8-49d6-a2f6-435caceb7e8b','','deleted','2025-11-22 05:54:59',NULL,NULL,NULL,NULL,NULL,'active',NULL,'b9bcbdc8-5a4b-450b-a372-7a3b2f4ae1ab',0,NULL),('2025-11-22 05:58:07.341717','2025-11-22 05:58:11.449899','2025-11-22 05:58:11.449352','f93c12a6-84cd-4937-a909-48f837e88319','f93c12a6-84cd-4937-a909-48f837e88319','eb32b540-d954-4b0c-a932-b3beb4bbf4e7','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:58:07','2025-11-22 05:58:07','2025-11-22 05:58:11',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'d59519d5-a66d-4c06-a170-dbc2876b25c1',0,'100%'),('2025-11-22 05:54:52.180169','2025-11-22 05:55:50.955093','2025-11-22 05:55:50.954557','f96efe4e-dc4d-4c2a-8b79-a56ce8d9f5a2','f96efe4e-dc4d-4c2a-8b79-a56ce8d9f5a2','e54ddc55-06e2-4ec6-9935-df702d90e2c8','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:54:52','2025-11-22 05:54:52','2025-11-22 05:55:50',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'0c00f43d-e8d6-4ce6-a0df-4c4d03c8513c',0,'100%'),('2025-11-22 05:51:19.818996','2025-11-22 05:51:23.377167','2025-11-22 05:51:23.376454','fa60463c-fe52-4a3c-894f-829287aa328b','fa60463c-fe52-4a3c-894f-829287aa328b','9baa489e-8738-4bb6-9cb5-831f3a757e15','','deleted','2025-11-22 05:51:19',NULL,NULL,NULL,NULL,NULL,'active',NULL,'d6624012-6e58-49fd-92c2-41fff579b962',0,NULL),('2025-11-22 05:54:59.288609','2025-11-22 05:55:47.470140','2025-11-22 05:55:47.469479','fdc0a474-b1f3-43ab-b94f-a0eefb55e7b7','fdc0a474-b1f3-43ab-b94f-a0eefb55e7b7','c6335e86-0ed3-4c9b-a59b-df9bdda6090c','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:54:59','2025-11-22 05:54:59','2025-11-22 05:55:47',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'0c00f43d-e8d6-4ce6-a0df-4c4d03c8513c',0,'100%'),('2025-11-22 05:59:31.463486','2025-11-22 05:59:36.739170','2025-11-22 05:59:36.738647','fe5f4c39-d36f-406f-9522-4233e36c1e1d','fe5f4c39-d36f-406f-9522-4233e36c1e1d','ab12d405-39c4-48b7-9363-e288809d9338','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:59:31','2025-11-22 05:59:31','2025-11-22 05:59:36',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'6630451a-185f-4b7a-8306-f600314a71e1',0,'100%'),('2025-11-22 05:56:48.839332','2025-11-22 05:56:52.736474','2025-11-22 05:56:52.735773','ff1c1ce2-dc9b-48d6-be0f-cc790f23422a','ff1c1ce2-dc9b-48d6-be0f-cc790f23422a','fde709e6-9872-4f8f-ba45-eda0da220019','hostgroup@cephfs#cephfs','deleted','2025-11-22 05:56:48','2025-11-22 05:56:49','2025-11-22 05:56:52',NULL,NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','active',NULL,'5426bf6e-b197-4c02-be68-82ee99c5c64e',0,'100%');
/*!40000 ALTER TABLE `share_instances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_metadata`
--

DROP TABLE IF EXISTS `share_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_metadata` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `share_id` (`share_id`),
  CONSTRAINT `share_metadata_ibfk_1` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=108 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_metadata`
--

LOCK TABLES `share_metadata` WRITE;
/*!40000 ALTER TABLE `share_metadata` DISABLE KEYS */;
INSERT INTO `share_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_id`, `key`, `value`) VALUES ('2025-11-22 05:50:51.544410',NULL,'2025-11-22 05:52:23.080480',1,1,'e3f37aa3-6df4-4c21-afa2-3d3d20a6917e','__mount_options','fs=cephfs'),('2025-11-22 05:50:54.407635',NULL,'2025-11-22 05:51:06.734191',2,2,'5bffd633-0c47-447b-981e-f37827cac197','__mount_options','fs=cephfs'),('2025-11-22 05:50:55.326812',NULL,'2025-11-22 05:50:59.414600',3,3,'0cfaf80f-3065-460f-a44d-408b8b49e173','__mount_options','fs=cephfs'),('2025-11-22 05:50:55.903125',NULL,'2025-11-22 05:50:59.207780',4,4,'cf2f7487-22e4-44c3-a53b-c8e5429e4682','__mount_options','fs=cephfs'),('2025-11-22 05:51:04.075811',NULL,'2025-11-22 05:51:10.383864',5,5,'ab6d4ef7-870a-4a7d-a86c-dcee3a6035b0','__mount_options','fs=cephfs'),('2025-11-22 05:51:07.274730',NULL,'2025-11-22 05:51:15.263138',6,6,'9641e455-326f-4fff-bb3f-88c8298ee465','__mount_options','fs=cephfs'),('2025-11-22 05:51:11.424287',NULL,'2025-11-22 05:51:18.751916',7,7,'c1402d2f-9c53-426d-a2ae-7a63c8aac5a5','__mount_options','fs=cephfs'),('2025-11-22 05:51:14.254766',NULL,'2025-11-22 05:51:18.039957',8,8,'4ad36ae6-9cd6-4471-b6a3-c5688ef1f23f','__mount_options','fs=cephfs'),('2025-11-22 05:51:19.298366',NULL,'2025-11-22 05:51:25.491698',9,9,'bdee9a86-edbb-4ac8-93c2-57ccdadf521c','__mount_options','fs=cephfs'),('2025-11-22 05:51:21.630815',NULL,'2025-11-22 05:51:25.341645',10,10,'95514f8e-35ec-4fb8-b06a-9b72b929572f','__mount_options','fs=cephfs'),('2025-11-22 05:51:38.207599',NULL,'2025-11-22 05:52:08.719611',11,11,'94375a59-a60d-4a02-88c7-a97c1daf9744','__mount_options','fs=cephfs'),('2025-11-22 05:51:42.421982',NULL,'2025-11-22 05:52:05.409167',12,12,'3f35616a-a117-49b4-9a27-e63f99a9bdc4','__mount_options','fs=cephfs'),('2025-11-22 05:51:44.895837',NULL,'2025-11-22 05:52:09.398989',13,13,'4967e6e3-b2cc-45b4-b463-17f7bce6ae8e','__mount_options','fs=cephfs'),('2025-11-22 05:52:01.406419',NULL,'2025-11-22 05:52:20.268220',14,14,'a5a4d39a-6afc-47ca-a64e-59baa4b6d20b','__mount_options','fs=cephfs'),('2025-11-22 05:52:24.627119',NULL,'2025-11-22 05:52:29.910529',15,15,'be478238-e7db-4a78-aa18-c53b49f1f67f','__mount_options','fs=cephfs'),('2025-11-22 05:52:36.008130',NULL,'2025-11-22 05:52:41.804134',16,16,'49fe7532-02b6-4da3-9369-3026c6bddc7a','__mount_options','fs=cephfs'),('2025-11-22 05:52:46.212407',NULL,'2025-11-22 05:56:12.323312',17,17,'8efd43bb-f9b3-4447-86c4-e3920bc619c4','__mount_options','fs=cephfs'),('2025-11-22 05:52:46.953532',NULL,'2025-11-22 05:52:52.712914',18,18,'50e9c087-b3da-4d49-8759-fa6cdcb53af9','__mount_options','fs=cephfs'),('2025-11-22 05:52:49.504190',NULL,'2025-11-22 05:53:06.408083',19,19,'6a28629c-ec25-4d9e-89ce-28477e9b25bb','__mount_options','fs=cephfs'),('2025-11-22 05:53:09.501017',NULL,'2025-11-22 05:54:02.923370',20,20,'ebd2d532-e2e2-40cc-8718-7ba6b480684f','__mount_options','fs=cephfs'),('2025-11-22 05:53:13.767670',NULL,'2025-11-22 05:53:17.611405',21,21,'e6284ec1-39ae-44d4-b9e1-86b6e30cae7b','__mount_options','fs=cephfs'),('2025-11-22 05:53:14.365636',NULL,'2025-11-22 05:54:15.496942',22,22,'d36c5b07-c6d1-453f-8e87-355ac7d60dc7','foo_key_share_1','foo_value_share_1'),('2025-11-22 05:53:14.366217',NULL,'2025-11-22 05:54:15.496942',23,23,'d36c5b07-c6d1-453f-8e87-355ac7d60dc7','bar_key_share_1','foo_value_share_1'),('2025-11-22 05:53:15.054997',NULL,'2025-11-22 05:54:15.496942',24,24,'d36c5b07-c6d1-453f-8e87-355ac7d60dc7','__mount_options','fs=cephfs'),('2025-11-22 05:53:16.654825',NULL,'2025-11-22 05:53:17.611405',25,25,'e6284ec1-39ae-44d4-b9e1-86b6e30cae7b','key5','value5'),('2025-11-22 05:53:16.658666',NULL,'2025-11-22 05:53:17.611405',26,26,'e6284ec1-39ae-44d4-b9e1-86b6e30cae7b','key6','value6'),('2025-11-22 05:53:16.881754',NULL,'2025-11-22 05:53:17.611405',27,27,'e6284ec1-39ae-44d4-b9e1-86b6e30cae7b','key7','value7'),('2025-11-22 05:53:16.884925',NULL,'2025-11-22 05:53:17.611405',28,28,'e6284ec1-39ae-44d4-b9e1-86b6e30cae7b','key8','value8'),('2025-11-22 05:53:22.045992',NULL,'2025-11-22 05:54:08.258625',29,29,'bd3228e3-2f52-48e2-a88c-d28e65ec129c','foo_key_share_2','foo_value_share_2'),('2025-11-22 05:53:22.046443',NULL,'2025-11-22 05:54:08.258625',30,30,'bd3228e3-2f52-48e2-a88c-d28e65ec129c','bar_key_share_2','foo_value_share_2'),('2025-11-22 05:53:23.023560',NULL,'2025-11-22 05:53:29.947657',31,31,'19dc7213-05d0-44ba-8191-d795ad527b71','__mount_options','fs=cephfs'),('2025-11-22 05:53:24.124632',NULL,'2025-11-22 05:54:08.258625',32,32,'bd3228e3-2f52-48e2-a88c-d28e65ec129c','__mount_options','fs=cephfs'),('2025-11-22 05:53:25.384615',NULL,'2025-11-22 05:53:29.947657',33,33,'19dc7213-05d0-44ba-8191-d795ad527b71','key3','value3'),('2025-11-22 05:53:25.388598',NULL,'2025-11-22 05:53:29.947657',34,34,'19dc7213-05d0-44ba-8191-d795ad527b71','key4','value4'),('2025-11-22 05:53:25.392067',NULL,'2025-11-22 05:53:29.947657',35,35,'19dc7213-05d0-44ba-8191-d795ad527b71','key.5.1','value.5'),('2025-11-22 05:53:30.832158',NULL,'2025-11-22 05:53:35.162736',36,36,'7369001b-8b56-4f95-95a7-cdaf74673b72','key1','value1'),('2025-11-22 05:53:30.832611',NULL,'2025-11-22 05:53:35.162736',37,37,'7369001b-8b56-4f95-95a7-cdaf74673b72','key2','value2'),('2025-11-22 05:53:31.078669',NULL,'2025-11-22 05:53:35.162736',38,38,'7369001b-8b56-4f95-95a7-cdaf74673b72','__mount_options','fs=cephfs'),('2025-11-22 05:53:38.651032',NULL,'2025-11-22 05:53:45.683627',39,39,'5dc5dd92-1904-4853-8e49-7d3d2ef9af9d','__mount_options','fs=cephfs'),('2025-11-22 05:53:41.918671','2025-11-22 05:53:43.250056','2025-11-22 05:53:45.683627',40,40,'5dc5dd92-1904-4853-8e49-7d3d2ef9af9d','key9','value13'),('2025-11-22 05:53:41.921757',NULL,'2025-11-22 05:53:45.683627',41,41,'5dc5dd92-1904-4853-8e49-7d3d2ef9af9d','key10','value10'),('2025-11-22 05:53:43.273305',NULL,'2025-11-22 05:53:45.683627',42,42,'5dc5dd92-1904-4853-8e49-7d3d2ef9af9d','key11','value11'),('2025-11-22 05:53:49.085345',NULL,'2025-11-22 05:54:02.923370',43,43,'ebd2d532-e2e2-40cc-8718-7ba6b480684f','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value'),('2025-11-22 05:53:49.477190','2025-11-22 05:53:50.529903','2025-11-22 05:54:02.923370',44,44,'ebd2d532-e2e2-40cc-8718-7ba6b480684f','key','v'),('2025-11-22 05:53:49.898320',NULL,'2025-11-22 05:54:02.923370',45,45,'ebd2d532-e2e2-40cc-8718-7ba6b480684f','k','value'),('2025-11-22 05:53:51.224395',NULL,'2025-11-22 05:53:57.135952',46,46,'c9ccb6a9-0027-4763-9baa-55495ae7c41e','__mount_options','fs=cephfs'),('2025-11-22 05:53:54.633973',NULL,'2025-11-22 05:53:57.135952',47,47,'c9ccb6a9-0027-4763-9baa-55495ae7c41e','key9','value9'),('2025-11-22 05:53:54.641620',NULL,'2025-11-22 05:53:57.135952',48,48,'c9ccb6a9-0027-4763-9baa-55495ae7c41e','key10','value10'),('2025-11-22 05:53:55.289828',NULL,'2025-11-22 05:53:57.135952',49,49,'c9ccb6a9-0027-4763-9baa-55495ae7c41e','key11','value11'),('2025-11-22 05:53:55.296351',NULL,'2025-11-22 05:53:57.135952',50,50,'c9ccb6a9-0027-4763-9baa-55495ae7c41e','key12','value12'),('2025-11-22 05:53:57.979127',NULL,'2025-11-22 05:54:09.322725',51,51,'b14078d0-94ef-4a05-a729-d7de8cfbf0a4','__mount_options','fs=cephfs'),('2025-11-22 05:54:00.486876',NULL,'2025-11-22 05:54:02.923370',52,52,'ebd2d532-e2e2-40cc-8718-7ba6b480684f','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value'),('2025-11-22 05:54:00.840172',NULL,'2025-11-22 05:54:02.923370',53,53,'ebd2d532-e2e2-40cc-8718-7ba6b480684f','key','vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv'),('2025-11-22 05:54:01.159051',NULL,'2025-11-22 05:54:02.923370',54,54,'ebd2d532-e2e2-40cc-8718-7ba6b480684f','k','value'),('2025-11-22 05:54:01.549839',NULL,'2025-11-22 05:54:02.923370',55,55,'ebd2d532-e2e2-40cc-8718-7ba6b480684f','key','v'),('2025-11-22 05:54:15.184947',NULL,'2025-11-22 05:54:26.704634',56,56,'f21cb0fb-7bd7-47da-8c9d-8be6d286e1f2','__mount_options','fs=cephfs'),('2025-11-22 05:54:18.879556',NULL,'2025-11-22 05:54:22.712829',57,57,'f3333f1b-e538-4076-90c8-83c744ff197c','__mount_options','fs=cephfs'),('2025-11-22 05:54:30.199451',NULL,'2025-11-22 05:54:34.424615',58,58,'6634bb0b-8adf-429e-9684-537da874f36d','__mount_options','fs=cephfs'),('2025-11-22 05:54:39.965219',NULL,'2025-11-22 05:54:45.501680',59,59,'2d84ba4d-c3d7-42b6-ab7f-d9b35fae6828','__mount_options','fs=cephfs'),('2025-11-22 05:54:48.645030',NULL,'2025-11-22 05:55:54.804893',60,60,'e6ebf7ae-934a-4ccf-9ab6-5b62a19c9509','__mount_options','fs=cephfs'),('2025-11-22 05:54:52.848517',NULL,'2025-11-22 05:55:50.968891',61,61,'e54ddc55-06e2-4ec6-9935-df702d90e2c8','__mount_options','fs=cephfs'),('2025-11-22 05:54:59.569730',NULL,'2025-11-22 05:55:47.490775',62,62,'c6335e86-0ed3-4c9b-a59b-df9bdda6090c','__mount_options','fs=cephfs'),('2025-11-22 05:55:04.242858',NULL,'2025-11-22 05:55:09.320502',63,63,'47b40d49-baff-45d8-8c77-f762454c8623','key','value'),('2025-11-22 05:55:04.495330',NULL,'2025-11-22 05:55:09.320502',64,64,'47b40d49-baff-45d8-8c77-f762454c8623','__mount_options','fs=cephfs'),('2025-11-22 05:55:28.479591',NULL,'2025-11-22 05:55:43.771308',65,65,'06610748-6de1-49ce-9a00-b0cc5a383015','__mount_options','fs=cephfs'),('2025-11-22 05:55:52.958757',NULL,NULL,0,66,'6421908b-395a-471b-82f0-f6641bffe29d','__mount_options','fs=cephfs'),('2025-11-22 05:56:27.612110',NULL,'2025-11-22 05:57:34.488128',67,67,'82f5a7b8-b11a-4b98-ac40-9540006a2619','__mount_options','fs=cephfs'),('2025-11-22 05:56:32.267652',NULL,'2025-11-22 05:56:39.700182',68,68,'535805ac-c11f-4da9-b23b-e9f0311f7416','__mount_options','fs=cephfs'),('2025-11-22 05:56:34.464848',NULL,'2025-11-22 05:56:39.145979',69,69,'85231eff-df4a-437f-b115-e47d4632d59f','__mount_options','fs=cephfs'),('2025-11-22 05:56:42.782497',NULL,'2025-11-22 05:56:47.067383',70,70,'91d3c28c-780f-4b34-8033-da786bbb63be','__mount_options','fs=cephfs'),('2025-11-22 05:56:42.930090',NULL,'2025-11-22 05:56:50.481045',71,71,'8c4d1c7d-bcbe-428a-add3-a107e25e1608','__mount_options','fs=cephfs'),('2025-11-22 05:56:45.619086',NULL,'2025-11-22 05:56:56.180836',72,72,'c6ab1cc0-cdda-41fe-aa61-b68b6c83d06f','__mount_options','fs=cephfs'),('2025-11-22 05:56:49.107187',NULL,'2025-11-22 05:56:52.751655',73,73,'fde709e6-9872-4f8f-ba45-eda0da220019','__mount_options','fs=cephfs'),('2025-11-22 05:56:53.685782',NULL,'2025-11-22 05:57:01.397819',74,74,'d0a602f8-d218-45aa-b13a-279f40f10b98','__mount_options','fs=cephfs'),('2025-11-22 05:57:01.305675',NULL,'2025-11-22 05:57:29.204706',75,75,'955a07b8-e5ce-48f7-afed-554d36afb2bb','__mount_options','fs=cephfs'),('2025-11-22 05:57:04.855685',NULL,'2025-11-22 05:57:08.525213',76,76,'765683c0-4613-45c1-8ada-72642ad67577','__mount_options','fs=cephfs'),('2025-11-22 05:57:05.511584',NULL,'2025-11-22 05:57:25.610164',77,77,'d62e9bd9-0999-49d2-988c-dde42208cae5','__mount_options','fs=cephfs'),('2025-11-22 05:57:09.498581',NULL,'2025-11-22 05:57:21.828146',78,78,'3d52ca5b-a434-47f0-a9bc-5e058cdeadc4','__mount_options','fs=cephfs'),('2025-11-22 05:57:12.056899',NULL,'2025-11-22 05:57:15.587777',79,79,'5ee936c0-72b4-469f-a052-0c7dc93a880f','__mount_options','fs=cephfs'),('2025-11-22 05:57:13.533073',NULL,'2025-11-22 05:57:18.172674',80,80,'454c896f-ee5c-43cc-af2b-3cf311c7ba49','__mount_options','fs=cephfs'),('2025-11-22 05:57:28.478451',NULL,'2025-11-22 05:57:39.098000',81,81,'dc95832f-bd83-4269-86ac-bbbfcc21bdfa','__mount_options','fs=cephfs'),('2025-11-22 05:57:42.993729',NULL,'2025-11-22 05:57:47.719331',82,82,'faeaa260-b2b9-4f76-bea6-38a9e85e461b','__mount_options','fs=cephfs'),('2025-11-22 05:57:51.526554',NULL,'2025-11-22 05:58:12.994033',83,83,'fa786287-7fdf-4612-aca2-817bfa149b97','__mount_options','fs=cephfs'),('2025-11-22 05:57:54.221565',NULL,'2025-11-22 05:58:42.420006',84,84,'8fc96ffe-58ec-4a01-9152-6a45bed340d3','__mount_options','fs=cephfs'),('2025-11-22 05:57:56.364181',NULL,'2025-11-22 05:58:06.200912',85,85,'d9c461b7-5bb4-48ae-ba3a-231acbbfb736','__mount_options','fs=cephfs'),('2025-11-22 05:57:59.846170',NULL,'2025-11-22 05:58:03.754798',86,86,'7fa27812-115e-40eb-9f44-8d109734f95e','__mount_options','fs=cephfs'),('2025-11-22 05:58:00.283211',NULL,'2025-11-22 05:58:11.848001',87,87,'59d2283f-fd13-4d0c-acda-f2c67d1bc088','__mount_options','fs=cephfs'),('2025-11-22 05:58:07.675217',NULL,'2025-11-22 05:58:11.465941',88,88,'eb32b540-d954-4b0c-a932-b3beb4bbf4e7','__mount_options','fs=cephfs'),('2025-11-22 05:58:15.007905',NULL,'2025-11-22 05:58:18.834404',89,89,'25902542-4afd-4494-91f3-1388b0c6aecb','__mount_options','fs=cephfs'),('2025-11-22 05:58:22.359497',NULL,'2025-11-22 05:58:26.495708',90,90,'c43e7c8b-3603-42ea-aa7c-9c05f1853f0e','__mount_options','fs=cephfs'),('2025-11-22 05:58:25.723297',NULL,'2025-11-22 05:58:37.180055',91,91,'2181b348-c082-45ec-ab33-041e5328f0c9','__mount_options','fs=cephfs'),('2025-11-22 05:58:30.536984',NULL,'2025-11-22 05:58:34.513197',92,92,'147e8495-aef5-40a9-9e0b-11a0a21056a1','__mount_options','fs=cephfs'),('2025-11-22 05:58:40.674627',NULL,'2025-11-22 05:58:57.519766',93,93,'4aae7a32-bf67-4f73-bf74-19367ee159cf','__mount_options','fs=cephfs'),('2025-11-22 05:58:44.493323',NULL,'2025-11-22 05:59:47.047334',94,94,'eb009558-f725-445d-90b6-32ce03b569d0','foo_key_share_1','foo_value_share_1'),('2025-11-22 05:58:44.493673',NULL,'2025-11-22 05:59:47.047334',95,95,'eb009558-f725-445d-90b6-32ce03b569d0','bar_key_share_1','foo_value_share_1'),('2025-11-22 05:58:45.391066',NULL,'2025-11-22 05:59:47.047334',96,96,'eb009558-f725-445d-90b6-32ce03b569d0','__mount_options','fs=cephfs'),('2025-11-22 05:58:48.922285',NULL,'2025-11-22 05:59:40.263935',97,97,'66ad6cfd-e916-46a6-bd0a-171cccdc89bc','foo_key_share_2','foo_value_share_2'),('2025-11-22 05:58:48.922665',NULL,'2025-11-22 05:59:40.263935',98,98,'66ad6cfd-e916-46a6-bd0a-171cccdc89bc','bar_key_share_2','foo_value_share_2'),('2025-11-22 05:58:52.489797',NULL,'2025-11-22 05:59:40.263935',99,99,'66ad6cfd-e916-46a6-bd0a-171cccdc89bc','__mount_options','fs=cephfs'),('2025-11-22 05:59:05.646971',NULL,'2025-11-22 05:59:12.745471',100,100,'e86c045c-ceab-444c-a106-8615dd89c419','__mount_options','fs=cephfs'),('2025-11-22 05:59:06.869837',NULL,'2025-11-22 06:00:00.072593',101,101,'fa7e2f81-5e9b-4471-bca4-e46b171d2c36','__mount_options','fs=cephfs'),('2025-11-22 05:59:08.053877',NULL,'2025-11-22 05:59:20.244310',102,102,'d30ad785-8ea6-4ab6-b62c-a912cd632ebc','foo_key_share_1','foo_value_share_1'),('2025-11-22 05:59:08.054327',NULL,'2025-11-22 05:59:20.244310',103,103,'d30ad785-8ea6-4ab6-b62c-a912cd632ebc','bar_key_share_1','foo_value_share_1'),('2025-11-22 05:59:08.351979',NULL,'2025-11-22 05:59:20.244310',104,104,'d30ad785-8ea6-4ab6-b62c-a912cd632ebc','__mount_options','fs=cephfs'),('2025-11-22 05:59:21.157198',NULL,'2025-11-22 05:59:28.193083',105,105,'ec39ec6c-4d9a-48ba-8699-5768bc4f8f85','__mount_options','fs=cephfs'),('2025-11-22 05:59:31.690715',NULL,'2025-11-22 05:59:36.748743',106,106,'ab12d405-39c4-48b7-9363-e288809d9338','__mount_options','fs=cephfs'),('2025-11-22 05:59:59.749745',NULL,'2025-11-22 06:00:12.167841',107,107,'511ae11a-c61d-4a3c-97ca-4eb2a5c1ee1a','__mount_options','fs=cephfs');
/*!40000 ALTER TABLE `share_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_network_security_service_association`
--

DROP TABLE IF EXISTS `share_network_security_service_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_network_security_service_association` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_network_id` varchar(36) NOT NULL,
  `security_service_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `share_network_id` (`share_network_id`),
  KEY `security_service_id` (`security_service_id`),
  CONSTRAINT `share_network_security_service_association_ibfk_1` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`),
  CONSTRAINT `share_network_security_service_association_ibfk_2` FOREIGN KEY (`security_service_id`) REFERENCES `security_services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_network_security_service_association`
--

LOCK TABLES `share_network_security_service_association` WRITE;
/*!40000 ALTER TABLE `share_network_security_service_association` DISABLE KEYS */;
INSERT INTO `share_network_security_service_association` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_network_id`, `security_service_id`) VALUES ('2025-11-22 05:53:20.358873','2025-11-22 05:53:23.459658','2025-11-22 05:53:23.458687',1,1,'5ed46204-7345-4cb9-b8ce-8275fe799478','b31cda01-f325-47bf-b69b-a30dbbee7ffe'),('2025-11-22 05:53:21.008221',NULL,NULL,0,2,'69cd8220-2015-4d44-a93c-861e811e8046','45150344-e500-4901-9614-73868ee2b61c'),('2025-11-22 05:55:48.150221','2025-11-22 05:55:51.673092','2025-11-22 05:55:51.672384',3,3,'cf3c5f21-e29a-4549-86f9-d30c8bbd4bff','6eab75c0-94d4-40c4-a203-49bce98e459b'),('2025-11-22 05:55:49.104019','2025-11-22 05:55:49.365604','2025-11-22 05:55:49.364497',4,4,'21526a1f-d08e-4d13-8077-6e85ae626305','b806fcb1-95d5-41d0-98e6-88925152bdea'),('2025-11-22 05:55:50.424640','2025-11-22 05:55:50.779590','2025-11-22 05:55:50.779318',5,5,'bfabce0b-2458-49e2-819d-559b1c253ec9','19479d61-c4b4-4cd6-a641-6bbd988add8f'),('2025-11-22 05:56:14.946869','2025-11-22 05:56:22.513451','2025-11-22 05:56:22.513141',6,6,'1745b22d-f24f-48a9-a68a-d55e85c351c5','9f73dcb2-4daa-4783-9192-b3ff972f5487'),('2025-11-22 05:56:15.865322','2025-11-22 05:56:22.111565','2025-11-22 05:56:22.110466',7,7,'680f0a24-9dbd-4766-8e2b-ff1d0e566983','68ed71e6-bdaa-495c-ba11-10081ad6d5ed'),('2025-11-22 05:58:21.297803','2025-11-22 05:58:21.420990','2025-11-22 05:58:21.420707',8,8,'139695e2-b4f0-4b0e-ac4b-2e77c86510a3','94a5f102-699e-436f-9a7d-b14fb9d4a1e5'),('2025-11-22 05:58:22.373207','2025-11-22 05:58:22.817739','2025-11-22 05:58:22.817453',9,9,'b7809354-a44f-4d91-9628-c3e9c9203081','e6467b91-fb98-48b2-9f13-b603d875fa9b'),('2025-11-22 05:58:23.300166','2025-11-22 05:58:23.440657','2025-11-22 05:58:23.440359',10,10,'f4520c87-9e42-4ed0-a0ac-42daca10cd2e','96d7f397-10c4-4c68-be79-7f1e5385405a'),('2025-11-22 05:58:23.541995','2025-11-22 05:58:23.797048','2025-11-22 05:58:23.796656',11,11,'f4520c87-9e42-4ed0-a0ac-42daca10cd2e','96d7f397-10c4-4c68-be79-7f1e5385405a');
/*!40000 ALTER TABLE `share_network_security_service_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_network_subnet_metadata`
--

DROP TABLE IF EXISTS `share_network_subnet_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_network_subnet_metadata` (
  `deleted` varchar(36) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_network_subnet_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `share_network_subnet_id` (`share_network_subnet_id`),
  CONSTRAINT `share_network_subnet_metadata_ibfk_1` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_network_subnet_metadata`
--

LOCK TABLES `share_network_subnet_metadata` WRITE;
/*!40000 ALTER TABLE `share_network_subnet_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_network_subnet_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_network_subnets`
--

DROP TABLE IF EXISTS `share_network_subnets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_network_subnets` (
  `id` varchar(36) NOT NULL,
  `neutron_net_id` varchar(36) DEFAULT NULL,
  `neutron_subnet_id` varchar(36) DEFAULT NULL,
  `network_type` varchar(32) DEFAULT NULL,
  `cidr` varchar(64) DEFAULT NULL,
  `segmentation_id` int(11) DEFAULT NULL,
  `gateway` varchar(64) DEFAULT NULL,
  `mtu` int(11) DEFAULT NULL,
  `share_network_id` varchar(36) DEFAULT NULL,
  `ip_version` int(11) DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_share_network_subnets_share_network_id_share_networks` (`share_network_id`),
  KEY `fk_share_network_subnets_availaility_zone_id_availability_zones` (`availability_zone_id`),
  CONSTRAINT `fk_share_network_subnets_availaility_zone_id_availability_zones` FOREIGN KEY (`availability_zone_id`) REFERENCES `availability_zones` (`id`),
  CONSTRAINT `fk_share_network_subnets_share_network_id_share_networks` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_network_subnets`
--

LOCK TABLES `share_network_subnets` WRITE;
/*!40000 ALTER TABLE `share_network_subnets` DISABLE KEYS */;
INSERT INTO `share_network_subnets` (`id`, `neutron_net_id`, `neutron_subnet_id`, `network_type`, `cidr`, `segmentation_id`, `gateway`, `mtu`, `share_network_id`, `ip_version`, `availability_zone_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES ('144fb36c-98bf-4b40-90ba-f47b5d57ecdd','tempest-net-id-2020380758','tempest-subnet-id-284689134',NULL,NULL,NULL,NULL,NULL,'19faaf4d-a652-4f05-8fee-ff48a89af53b',NULL,NULL,'2025-11-22 05:56:17.128267',NULL,NULL,'False'),('1637083b-e91a-4be7-bb70-c6162d26284b','tempest-net-id-1294645167','tempest-subnet-id-1855663082',NULL,NULL,NULL,NULL,NULL,'172e8e38-d6c9-47ec-a651-f9c5e2c324fb',NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','2025-11-22 05:55:41.476747','2025-11-22 05:55:41.772061','2025-11-22 05:55:41.771469','1637083b-e91a-4be7-bb70-c6162d26284b'),('1e83f307-202b-426d-adbf-3ebfffbf8237','tempest-net-id-860370500','tempest-subnet-id-1897055043',NULL,NULL,NULL,NULL,NULL,'b7809354-a44f-4d91-9628-c3e9c9203081',NULL,NULL,'2025-11-22 05:58:22.132930',NULL,NULL,'False'),('20bcc114-3be0-49d9-8976-b599e119e6c0','tempest-net-id-294280843','tempest-subnet-id-560323682',NULL,NULL,NULL,NULL,NULL,'fbc4cb56-ca52-4d5c-af30-c5971dd73bad',NULL,NULL,'2025-11-22 05:55:42.661084',NULL,NULL,'False'),('274897ad-c8b4-4950-adf1-770cebc56300',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'cf3c5f21-e29a-4549-86f9-d30c8bbd4bff',NULL,NULL,'2025-11-22 05:55:47.419965',NULL,NULL,'False'),('3c8b7117-d382-4d62-8859-92ba34693983',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'ec82f362-063a-4ca3-9bbd-10cf011ef83c',NULL,NULL,'2025-11-22 05:55:27.930877',NULL,NULL,'False'),('59bf68e6-a7ac-48d8-9f10-46908ca7da7e','tempest-net-id-666827605','tempest-subnet-id-448671845',NULL,NULL,NULL,NULL,NULL,'bfabce0b-2458-49e2-819d-559b1c253ec9',NULL,NULL,'2025-11-22 05:55:50.157522',NULL,NULL,'False'),('6b264539-5bd1-4e31-ac38-d655faf72fa1','tempest-net-id-417578979','tempest-subnet-id-590926985',NULL,NULL,NULL,NULL,NULL,'03a9d88e-d665-4fba-802c-bf4db40991ab',NULL,NULL,'2025-11-22 05:56:19.571047',NULL,NULL,'False'),('6e31155d-549f-407a-a9a3-db36d7f3a789','tempest-net-id-520027370','tempest-subnet-id-721165222',NULL,NULL,NULL,NULL,NULL,'139695e2-b4f0-4b0e-ac4b-2e77c86510a3',NULL,NULL,'2025-11-22 05:58:20.990371',NULL,NULL,'False'),('82742c62-b7b0-47a8-ac43-b4145e4b75bc','1111','2222','vlan','10.0.0.0/24',1000,NULL,NULL,'5ed46204-7345-4cb9-b8ce-8275fe799478',4,NULL,'2002-02-02 00:00:00.000000',NULL,NULL,'False'),('8d9d6164-a555-49b0-b593-66fbcb0fa041','test net id','test subnet id','local','10.0.0.0/13',2000,NULL,NULL,'69cd8220-2015-4d44-a93c-861e811e8046',6,NULL,'2003-03-03 00:00:00.000000',NULL,NULL,'False'),('91d3d579-a061-433b-b4a2-3ad7210e9205','test net id','test subnet id','local','10.0.0.0/13',2000,NULL,NULL,'680f0a24-9dbd-4766-8e2b-ff1d0e566983',6,NULL,'2003-03-03 00:00:00.000000',NULL,NULL,'False'),('950e1ec4-7702-4168-bd41-8a442ad04f70','tempest-net-id-36861964','tempest-subnet-id-92875298',NULL,NULL,NULL,NULL,NULL,'f4520c87-9e42-4ed0-a0ac-42daca10cd2e',NULL,NULL,'2025-11-22 05:58:23.058365',NULL,NULL,'False'),('976528b5-5dd5-4f6c-a018-ecc0cbd7c598',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'18ff00d4-e717-4f72-8d23-7c56251e33c5',NULL,NULL,'2025-11-22 05:56:31.095985',NULL,NULL,'False'),('9c63459e-5e65-49ab-83db-29584a268a4e','tempest-net-id-2020380758','tempest-subnet-id-284689134',NULL,NULL,NULL,NULL,NULL,'8f9f63a8-cfda-4aba-9221-af45c93da54a',NULL,NULL,'2025-11-22 05:56:16.978181',NULL,NULL,'False'),('9deb8fdd-b04e-49d0-bfd9-984240424c91',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'172e8e38-d6c9-47ec-a651-f9c5e2c324fb',NULL,NULL,'2025-11-22 05:55:41.325994',NULL,NULL,'False'),('9f3d42f1-23cd-4f0f-97fb-511d14bc7d4b','tempest-net-id-1530596096','tempest-subnet-id-1794318723',NULL,NULL,NULL,NULL,NULL,'21526a1f-d08e-4d13-8077-6e85ae626305',NULL,NULL,'2025-11-22 05:55:48.805557',NULL,NULL,'False'),('a1d687dc-2ca1-40c8-a604-e4bc323c1dd3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'b4d9cc1d-0597-4f36-bf5e-acb7a5397fa6',NULL,NULL,'2025-11-22 05:55:28.711502',NULL,NULL,'False'),('aeec2928-06fa-4f5b-abbd-5e079c235e90','tempest-net-id-2022022790','tempest-subnet-id-544123519','vlan','10.0.0.0/24',1000,NULL,NULL,'1745b22d-f24f-48a9-a68a-d55e85c351c5',4,NULL,'2002-02-02 00:00:00.000000','2025-11-22 05:56:20.777016',NULL,'False'),('d00f91f0-b516-429a-ab1d-e0319fb8fa58',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1c8ae48c-27ba-463e-be9a-6b0be9e5f31f',NULL,NULL,'2025-11-22 05:55:40.660705',NULL,NULL,'False'),('d04ae5f7-5e27-4464-86e2-f1a7740ad217',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2682e468-f99f-4e8b-8077-0d7d0d44e86c',NULL,NULL,'2025-11-22 05:55:27.679011',NULL,NULL,'False'),('d2623a95-ba24-48b4-9afe-c01e69bec10e','tempest-net-id-417578979','tempest-subnet-id-590926985',NULL,NULL,NULL,NULL,NULL,'03d66ab3-b2d2-488b-a0d1-7652cdc10093',NULL,NULL,'2025-11-22 05:56:19.031366',NULL,NULL,'False'),('deff6ce8-8ad8-49db-98d5-8c2c23056d0c','tempest-net-id-993264158','tempest-subnet-id-24993475',NULL,NULL,NULL,NULL,NULL,'ec82f362-063a-4ca3-9bbd-10cf011ef83c',NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','2025-11-22 05:55:28.204785','2025-11-22 05:55:28.346191','2025-11-22 05:55:28.345439','deff6ce8-8ad8-49db-98d5-8c2c23056d0c'),('e606575f-dc34-496c-ab94-917cd2456c83','tempest-net-id-405308122','tempest-subnet-id-1239196614',NULL,NULL,NULL,NULL,NULL,'b7f240e1-8dcf-4e07-b86b-b79bfcc8be72',NULL,NULL,'2025-11-22 05:56:16.158064',NULL,NULL,'False'),('f9483008-9b28-43c2-ae11-2f3e5a947138','tempest-net-id-169938833','tempest-subnet-id-161496470',NULL,NULL,NULL,NULL,NULL,'b4d9cc1d-0597-4f36-bf5e-acb7a5397fa6',NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','2025-11-22 05:55:29.061831','2025-11-22 05:55:29.247583','2025-11-22 05:55:29.246873','f9483008-9b28-43c2-ae11-2f3e5a947138'),('f9dbed50-0c12-4f9a-a260-c4670a8f45d4','tempest-net-id-1252572833','tempest-subnet-id-2019182178',NULL,NULL,NULL,NULL,NULL,'18ff00d4-e717-4f72-8d23-7c56251e33c5',NULL,'bb37dba6-f304-4dde-891e-648b11fb093c','2025-11-22 05:56:32.522580','2025-11-22 05:56:32.709605','2025-11-22 05:56:32.709067','f9dbed50-0c12-4f9a-a260-c4670a8f45d4');
/*!40000 ALTER TABLE `share_network_subnets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_networks`
--

DROP TABLE IF EXISTS `share_networks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_networks` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(36) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_networks`
--

LOCK TABLES `share_networks` WRITE;
/*!40000 ALTER TABLE `share_networks` DISABLE KEYS */;
INSERT INTO `share_networks` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `user_id`, `name`, `description`, `status`) VALUES ('2025-11-22 05:56:19.556708','2025-11-22 05:56:19.930495','2025-11-22 05:56:19.929921','03a9d88e-d665-4fba-802c-bf4db40991ab','03a9d88e-d665-4fba-802c-bf4db40991ab','3520b2bd18fe4bc198c9b3ae61849514','4d4e495e2af243dba0ae1d8c430fed71','tempest-sn-name-752656795','tempest-sn-desc-838994377','active'),('2025-11-22 05:56:19.014532','2025-11-22 05:56:19.174605','2025-11-22 05:56:19.174111','03d66ab3-b2d2-488b-a0d1-7652cdc10093','03d66ab3-b2d2-488b-a0d1-7652cdc10093','3520b2bd18fe4bc198c9b3ae61849514','4d4e495e2af243dba0ae1d8c430fed71','tempest-sn-name-752656795','tempest-sn-desc-838994377','active'),('2025-11-22 05:58:20.973448','2025-11-22 05:58:21.823820','2025-11-22 05:58:21.823215','139695e2-b4f0-4b0e-ac4b-2e77c86510a3','139695e2-b4f0-4b0e-ac4b-2e77c86510a3','b69436f6d3194929ace36172443c8bfa','135e060c52fc44c48e7f3dea40fb7352','tempest-sn-name-2005484258','tempest-sn-desc-204707397','active'),('2025-11-22 05:55:41.307385','2025-11-22 05:55:42.054458','2025-11-22 05:55:42.054025','172e8e38-d6c9-47ec-a651-f9c5e2c324fb','172e8e38-d6c9-47ec-a651-f9c5e2c324fb','531b9bbdeb2447818ecd6f5fccb66a8a','2458340257d941d6b2d0260e7d70dfe3',NULL,NULL,'active'),('2002-02-02 00:00:00.000000','2025-11-22 05:56:22.535803','2025-11-22 05:56:22.535306','1745b22d-f24f-48a9-a68a-d55e85c351c5','1745b22d-f24f-48a9-a68a-d55e85c351c5','3520b2bd18fe4bc198c9b3ae61849514','4d4e495e2af243dba0ae1d8c430fed71','tempest-sn-name-1903294675','tempest-sn-desc-1061080077','active'),('2025-11-22 05:56:31.062455',NULL,NULL,'False','18ff00d4-e717-4f72-8d23-7c56251e33c5','e901221ae3e949c0a2f21b3f827f2f92','da7e1014c61944d2888458963ee6ce85',NULL,NULL,'active'),('2025-11-22 05:56:17.114920','2025-11-22 05:56:17.299186','2025-11-22 05:56:17.298765','19faaf4d-a652-4f05-8fee-ff48a89af53b','19faaf4d-a652-4f05-8fee-ff48a89af53b','3520b2bd18fe4bc198c9b3ae61849514','4d4e495e2af243dba0ae1d8c430fed71','tempest-sn-name-47722600','tempest-sn-desc-941090565','active'),('2025-11-22 05:55:40.647469','2025-11-22 05:55:40.989147','2025-11-22 05:55:40.988419','1c8ae48c-27ba-463e-be9a-6b0be9e5f31f','1c8ae48c-27ba-463e-be9a-6b0be9e5f31f','531b9bbdeb2447818ecd6f5fccb66a8a','2458340257d941d6b2d0260e7d70dfe3',NULL,NULL,'active'),('2025-11-22 05:55:48.783071','2025-11-22 05:55:49.925469','2025-11-22 05:55:49.923899','21526a1f-d08e-4d13-8077-6e85ae626305','21526a1f-d08e-4d13-8077-6e85ae626305','b65ccd7e2f5f4f95959c8fb179b60b78','955dc5c233b943d9982d1ee82cd2f0de','tempest-sn-name-1189203045','tempest-sn-desc-842501749','active'),('2025-11-22 05:55:27.654514','2025-11-22 05:55:28.538378','2025-11-22 05:55:28.537855','2682e468-f99f-4e8b-8077-0d7d0d44e86c','2682e468-f99f-4e8b-8077-0d7d0d44e86c','3109e70846824a5ea61dce09df700861','02fe04fccffb4086a89160251945aedb',NULL,NULL,'active'),('2002-02-02 00:00:00.000000','2025-11-22 05:53:23.673218','2025-11-22 05:53:23.671769','5ed46204-7345-4cb9-b8ce-8275fe799478','5ed46204-7345-4cb9-b8ce-8275fe799478','c16b253430cb40f6bf0f328197748aef','e136c1b06bce4b998a5350385e9229ad','sn_with_ldap_ss','fake description','active'),('2003-03-03 00:00:00.000000','2025-11-22 05:56:22.160192','2025-11-22 05:56:22.159302','680f0a24-9dbd-4766-8e2b-ff1d0e566983','680f0a24-9dbd-4766-8e2b-ff1d0e566983','3520b2bd18fe4bc198c9b3ae61849514','4d4e495e2af243dba0ae1d8c430fed71','sn_with_kerberos_ss','fake description','active'),('2003-03-03 00:00:00.000000',NULL,NULL,'False','69cd8220-2015-4d44-a93c-861e811e8046','b59c82aac0154932bb0672ff00781e5f','d8f03b5718b045adbc9a577ce80ce1ab','sn_with_kerberos_ss','fake description','active'),('2025-11-22 05:56:16.963849','2025-11-22 05:56:17.828665','2025-11-22 05:56:17.827854','8f9f63a8-cfda-4aba-9221-af45c93da54a','8f9f63a8-cfda-4aba-9221-af45c93da54a','3520b2bd18fe4bc198c9b3ae61849514','4d4e495e2af243dba0ae1d8c430fed71','tempest-sn-name-47722600','tempest-sn-desc-941090565','active'),('2025-11-22 05:55:28.698973','2025-11-22 05:55:29.483581','2025-11-22 05:55:29.482900','b4d9cc1d-0597-4f36-bf5e-acb7a5397fa6','b4d9cc1d-0597-4f36-bf5e-acb7a5397fa6','3109e70846824a5ea61dce09df700861','02fe04fccffb4086a89160251945aedb',NULL,NULL,'active'),('2025-11-22 05:58:22.120481','2025-11-22 05:58:22.833124','2025-11-22 05:58:22.832682','b7809354-a44f-4d91-9628-c3e9c9203081','b7809354-a44f-4d91-9628-c3e9c9203081','b69436f6d3194929ace36172443c8bfa','135e060c52fc44c48e7f3dea40fb7352','tempest-sn-name-997222110','tempest-sn-desc-1338289617','active'),('2025-11-22 05:56:16.133320','2025-11-22 05:56:16.559934','2025-11-22 05:56:16.559198','b7f240e1-8dcf-4e07-b86b-b79bfcc8be72','b7f240e1-8dcf-4e07-b86b-b79bfcc8be72','3520b2bd18fe4bc198c9b3ae61849514','4d4e495e2af243dba0ae1d8c430fed71','tempest-sn-name-1912702061','tempest-sn-desc-1292809563','active'),('2025-11-22 05:55:50.133709','2025-11-22 05:55:50.793314','2025-11-22 05:55:50.792861','bfabce0b-2458-49e2-819d-559b1c253ec9','bfabce0b-2458-49e2-819d-559b1c253ec9','b65ccd7e2f5f4f95959c8fb179b60b78','955dc5c233b943d9982d1ee82cd2f0de','tempest-sn-name-1073198377','tempest-sn-desc-450138800','active'),('2025-11-22 05:55:47.376219','2025-11-22 05:55:51.685765','2025-11-22 05:55:51.685382','cf3c5f21-e29a-4549-86f9-d30c8bbd4bff','cf3c5f21-e29a-4549-86f9-d30c8bbd4bff','b65ccd7e2f5f4f95959c8fb179b60b78','955dc5c233b943d9982d1ee82cd2f0de',NULL,NULL,'active'),('2025-11-22 05:55:27.887670',NULL,NULL,'False','ec82f362-063a-4ca3-9bbd-10cf011ef83c','3109e70846824a5ea61dce09df700861','02fe04fccffb4086a89160251945aedb',NULL,NULL,'active'),('2025-11-22 05:58:23.043925','2025-11-22 05:58:23.820719','2025-11-22 05:58:23.820204','f4520c87-9e42-4ed0-a0ac-42daca10cd2e','f4520c87-9e42-4ed0-a0ac-42daca10cd2e','b69436f6d3194929ace36172443c8bfa','135e060c52fc44c48e7f3dea40fb7352','tempest-sn-name-296418305','tempest-sn-desc-1207187552','active'),('2025-11-22 05:55:42.648007','2025-11-22 05:55:42.818530','2025-11-22 05:55:42.817435','fbc4cb56-ca52-4d5c-af30-c5971dd73bad','fbc4cb56-ca52-4d5c-af30-c5971dd73bad','531b9bbdeb2447818ecd6f5fccb66a8a','2458340257d941d6b2d0260e7d70dfe3','tempest-sn-name-567728267','tempest-sn-desc-86897833','active');
/*!40000 ALTER TABLE `share_networks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_server_backend_details`
--

DROP TABLE IF EXISTS `share_server_backend_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_server_backend_details` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_server_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `share_server_id` (`share_server_id`),
  CONSTRAINT `share_server_backend_details_ibfk_1` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_server_backend_details`
--

LOCK TABLES `share_server_backend_details` WRITE;
/*!40000 ALTER TABLE `share_server_backend_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_server_backend_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_server_share_network_subnet_mappings`
--

DROP TABLE IF EXISTS `share_server_share_network_subnet_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_server_share_network_subnet_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_server_id` varchar(36) NOT NULL,
  `share_network_subnet_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_ss_sns_m_share_server_id_share_servers` (`share_server_id`),
  KEY `fk_ss_sns_m_share_network_subnet_id_share_network_subnets` (`share_network_subnet_id`),
  CONSTRAINT `fk_ss_sns_m_share_network_subnet_id_share_network_subnets` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`),
  CONSTRAINT `fk_ss_sns_m_share_server_id_share_servers` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_server_share_network_subnet_mappings`
--

LOCK TABLES `share_server_share_network_subnet_mappings` WRITE;
/*!40000 ALTER TABLE `share_server_share_network_subnet_mappings` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_server_share_network_subnet_mappings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_servers`
--

DROP TABLE IF EXISTS `share_servers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_servers` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `host` varchar(255) DEFAULT NULL,
  `status` varchar(32) DEFAULT NULL,
  `is_auto_deletable` tinyint(1) DEFAULT NULL,
  `identifier` varchar(255) DEFAULT NULL,
  `task_state` varchar(255) DEFAULT NULL,
  `source_share_server_id` varchar(36) DEFAULT NULL,
  `security_service_update_support` tinyint(1) NOT NULL DEFAULT 0,
  `network_allocation_update_support` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `fk_share_servers_source_share_server_id` (`source_share_server_id`),
  CONSTRAINT `fk_share_servers_source_share_server_id` FOREIGN KEY (`source_share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_servers`
--

LOCK TABLES `share_servers` WRITE;
/*!40000 ALTER TABLE `share_servers` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_servers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_access_map`
--

DROP TABLE IF EXISTS `share_snapshot_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_access_map` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_snapshot_id` varchar(36) DEFAULT NULL,
  `access_type` varchar(255) DEFAULT NULL,
  `access_to` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ssam_snapshot_fk` (`share_snapshot_id`),
  CONSTRAINT `ssam_snapshot_fk` FOREIGN KEY (`share_snapshot_id`) REFERENCES `share_snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_access_map`
--

LOCK TABLES `share_snapshot_access_map` WRITE;
/*!40000 ALTER TABLE `share_snapshot_access_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_snapshot_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_instance_access_map`
--

DROP TABLE IF EXISTS `share_snapshot_instance_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_instance_access_map` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_snapshot_instance_id` varchar(36) DEFAULT NULL,
  `access_id` varchar(36) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ssiam_snapshot_instance_fk` (`share_snapshot_instance_id`),
  KEY `ssam_access_fk` (`access_id`),
  CONSTRAINT `ssam_access_fk` FOREIGN KEY (`access_id`) REFERENCES `share_snapshot_access_map` (`id`),
  CONSTRAINT `ssiam_snapshot_instance_fk` FOREIGN KEY (`share_snapshot_instance_id`) REFERENCES `share_snapshot_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_instance_access_map`
--

LOCK TABLES `share_snapshot_instance_access_map` WRITE;
/*!40000 ALTER TABLE `share_snapshot_instance_access_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_snapshot_instance_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_instance_export_locations`
--

DROP TABLE IF EXISTS `share_snapshot_instance_export_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_instance_export_locations` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_snapshot_instance_id` varchar(36) DEFAULT NULL,
  `path` varchar(2000) DEFAULT NULL,
  `is_admin_only` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ssiel_snapshot_instance_fk` (`share_snapshot_instance_id`),
  CONSTRAINT `ssiel_snapshot_instance_fk` FOREIGN KEY (`share_snapshot_instance_id`) REFERENCES `share_snapshot_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_instance_export_locations`
--

LOCK TABLES `share_snapshot_instance_export_locations` WRITE;
/*!40000 ALTER TABLE `share_snapshot_instance_export_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_snapshot_instance_export_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_instances`
--

DROP TABLE IF EXISTS `share_snapshot_instances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_instances` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `share_instance_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `share_proto` varchar(255) DEFAULT NULL,
  `share_group_snapshot_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ssi_snapshot_fk` (`snapshot_id`),
  KEY `ssi_share_instance_fk` (`share_instance_id`),
  CONSTRAINT `ssi_share_instance_fk` FOREIGN KEY (`share_instance_id`) REFERENCES `share_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_instances`
--

LOCK TABLES `share_snapshot_instances` WRITE;
/*!40000 ALTER TABLE `share_snapshot_instances` DISABLE KEYS */;
INSERT INTO `share_snapshot_instances` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `snapshot_id`, `share_instance_id`, `status`, `progress`, `provider_location`, `user_id`, `project_id`, `size`, `share_proto`, `share_group_snapshot_id`) VALUES ('2025-11-22 05:59:30.239331','2025-11-22 05:59:34.297053','2025-11-22 05:59:34.295817','069edcb7-8804-49a7-b7ef-0c39ebac6aee','069edcb7-8804-49a7-b7ef-0c39ebac6aee','91849941-04fc-4d5c-809e-4a9e43af8a9b','18e9f280-7994-4c49-95f7-6a6f9ebabd4f','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-22 05:51:28.610651','2025-11-22 05:51:32.509321','2025-11-22 05:51:32.508304','31459069-a7a6-4f0a-9109-45df237fe792','31459069-a7a6-4f0a-9109-45df237fe792','fcd19511-0693-413f-9530-f3c80d5b7b7b','af20cd9a-8203-491f-b76d-599ebd8046ec','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-22 05:58:44.077663','2025-11-22 05:58:49.025872','2025-11-22 05:58:49.025375','45cbbe81-54f3-4d33-b6ed-0541e70b79ac','45cbbe81-54f3-4d33-b6ed-0541e70b79ac','b64ec859-00ea-4356-8f9d-6f1d033496e0','12681db0-dac5-4be1-a94e-db0502d683a8','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-22 05:58:29.261664','2025-11-22 05:58:33.586048','2025-11-22 05:58:33.585567','4b7ccb8c-a586-453d-ac99-e365a37bb6c2','4b7ccb8c-a586-453d-ac99-e365a37bb6c2','aef441a3-a76b-4305-8686-8c0b89f2f1b9','04ec723f-2266-44ad-8738-9d300104eaa9','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-22 05:58:48.340324','2025-11-22 05:59:43.688564','2025-11-22 05:59:43.687581','4b9a1734-eccd-4930-a293-83126ba93df5','4b9a1734-eccd-4930-a293-83126ba93df5','7cb6a540-aa78-41e5-b112-51878416b681','8ea650d4-0ea6-408a-8107-7d06795baf3e','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-22 05:51:46.056985','2025-11-22 05:52:01.395528','2025-11-22 05:52:01.394912','6333f3c4-9243-4f46-8066-55fc353398c5','6333f3c4-9243-4f46-8066-55fc353398c5','72703134-9023-42d9-b1e8-9374f84d84cc','f7e75bd1-474d-4276-b05f-3f57f661f123','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-22 05:59:10.164598','2025-11-22 05:59:56.513791','2025-11-22 05:59:56.513346','69301942-28c7-4014-a246-50ecf9648404','69301942-28c7-4014-a246-50ecf9648404','d375caa0-bb8d-47a9-9906-e56f6c4b9b10','18e9f280-7994-4c49-95f7-6a6f9ebabd4f','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-22 05:57:51.862888','2025-11-22 05:58:09.567448','2025-11-22 05:58:09.567021','6932ae0a-642f-4769-a012-4989a1eed830','6932ae0a-642f-4769-a012-4989a1eed830','396d061d-06cf-48da-a32e-5cf66e8782c8','3dcff5a7-454d-46f7-9ff8-546a79d1c07a','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-22 05:51:56.099780','2025-11-22 05:52:08.377192','2025-11-22 05:52:08.376706','79c53c5a-19fb-4b76-97fa-30294fb2fef4','79c53c5a-19fb-4b76-97fa-30294fb2fef4','eed29854-f0de-4f56-8a27-13ce2bfe06fa','af20cd9a-8203-491f-b76d-599ebd8046ec','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-22 05:59:47.171192','2025-11-22 05:59:53.014066','2025-11-22 05:59:53.013431','81755b2d-8933-4607-923d-d11f8165f30d','81755b2d-8933-4607-923d-d11f8165f30d','b3b5af82-6f64-44d3-be30-5f5255e6da69','18e9f280-7994-4c49-95f7-6a6f9ebabd4f','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-22 05:59:13.870168','2025-11-22 05:59:18.343883','2025-11-22 05:59:18.343320','84b80663-4f8e-4ed8-afc4-2b3b3f9e14c9','84b80663-4f8e-4ed8-afc4-2b3b3f9e14c9','6a5d1464-36eb-4f65-a22f-d6e8dfb31c4d','18e9f280-7994-4c49-95f7-6a6f9ebabd4f','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-22 05:59:11.505851','2025-11-22 05:59:16.620988','2025-11-22 05:59:16.620405','85eccfbd-7b38-4356-b114-dfaefadf6ee5','85eccfbd-7b38-4356-b114-dfaefadf6ee5','e8c4aec1-9bed-494d-9cc6-4b106df55c19','f58a5d10-062f-4cf1-87a0-845f4b3226dc','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-22 05:52:04.188016','2025-11-22 05:52:16.936535','2025-11-22 05:52:16.935637','979934f6-2426-4486-ba3a-3345281db1dc','979934f6-2426-4486-ba3a-3345281db1dc','43b15887-e470-4d86-be86-556764cf9b47','77ba3a4e-8b78-433d-9fcd-08fc8c49251b','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-22 05:52:08.340070','2025-11-22 05:52:13.859128','2025-11-22 05:52:13.858292','9c40e4f1-cfe4-4e0b-b18c-817da5de7558','9c40e4f1-cfe4-4e0b-b18c-817da5de7558','b447fbc6-f84c-471a-b434-4cf442d5d06a','77ba3a4e-8b78-433d-9fcd-08fc8c49251b','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-22 05:50:57.563699','2025-11-22 05:51:03.383924','2025-11-22 05:51:03.383278','9dfa855e-1208-478c-a1ee-6451e9ea868d','9dfa855e-1208-478c-a1ee-6451e9ea868d','1aa7681a-db1a-45b0-a136-7ab46880c277','15202c81-eb7f-4a9b-b839-74d8d3eac759','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-22 05:51:45.708139','2025-11-22 05:52:15.949836','2025-11-22 05:52:15.948091','9f1c2860-61dc-4837-880d-0143164bc5fc','9f1c2860-61dc-4837-880d-0143164bc5fc','4986e2cb-c9fa-4cc5-9de1-755b64f9eec7','af20cd9a-8203-491f-b76d-599ebd8046ec','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-22 05:53:18.104670','2025-11-22 05:54:11.984754','2025-11-22 05:54:11.983909','b4b7b05d-0976-4cf3-a526-f3a3648db0ed','b4b7b05d-0976-4cf3-a526-f3a3648db0ed','ab580b6a-b19b-46ad-8a5e-1d8d79733bf6','576c395a-0c7b-4d45-a49a-9d0c63369a89','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-22 05:59:37.461522','2025-11-22 05:59:42.781055','2025-11-22 05:59:42.780140','b4f5f2ab-bb7c-43c0-aeca-d65879453a15','b4f5f2ab-bb7c-43c0-aeca-d65879453a15','a1f4aa87-8f0d-4096-b514-6eead3321ab7','18e9f280-7994-4c49-95f7-6a6f9ebabd4f','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-22 05:51:41.808713','2025-11-22 05:52:19.038979','2025-11-22 05:52:19.038437','b86c0998-2bb5-4425-91b4-757abf28bbdc','b86c0998-2bb5-4425-91b4-757abf28bbdc','a9d28ae0-d3cd-4cd7-a310-a66b9a7b4131','af20cd9a-8203-491f-b76d-599ebd8046ec','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-22 05:52:00.571798','2025-11-22 05:52:05.299008','2025-11-22 05:52:05.298154','c83418fc-b7ae-4ce7-b133-d4b0a2f96738','c83418fc-b7ae-4ce7-b133-d4b0a2f96738','79d46880-5e77-4edf-a5df-f85c46a3035c','af20cd9a-8203-491f-b76d-599ebd8046ec','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-22 05:57:57.470093','2025-11-22 05:58:38.883398','2025-11-22 05:58:38.882534','d41398b5-1031-4e8d-933e-c6c94e22ca32','d41398b5-1031-4e8d-933e-c6c94e22ca32','d70e8843-02c1-482f-aebd-63710671186e','6262f914-71c2-4411-a49e-54f30a05659d','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-22 05:54:01.113620','2025-11-22 05:54:05.968446','2025-11-22 05:54:05.967714','e075958d-e50e-4903-9677-98e9d6e8b448','e075958d-e50e-4903-9677-98e9d6e8b448','ace986ad-e44f-45e0-bae4-482714700fcb','39fe5e7b-616f-4319-8856-cfe7e482fa98','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-22 05:51:50.697146','2025-11-22 05:52:12.041103','2025-11-22 05:52:12.040444','e0c50c16-9008-44de-a6d9-9420a0cf8d15','e0c50c16-9008-44de-a6d9-9420a0cf8d15','e8012c7d-6e57-4d5f-8dd3-7b9d07a9c2be','af20cd9a-8203-491f-b76d-599ebd8046ec','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-22 05:57:31.641919','2025-11-22 05:57:35.506639','2025-11-22 05:57:35.505736','e71660f7-dae4-4a03-8eba-3b01c731a81b','e71660f7-dae4-4a03-8eba-3b01c731a81b','ed5a4ca5-3621-4605-bdac-e3cb3da09c16','c1465b04-fd21-4d9f-bc84-54d95bef1ba1','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-22 06:00:02.901208','2025-11-22 06:00:08.475510','2025-11-22 06:00:08.475086','f12cbc90-6f8e-4e88-9d93-d7bc80b572a3','f12cbc90-6f8e-4e88-9d93-d7bc80b572a3','41f46daf-9a06-4ed4-add0-ee36e9947701','4a01560f-b8db-4a3a-8f6c-493d0f32d091','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-22 05:59:21.477189','2025-11-22 05:59:26.977404','2025-11-22 05:59:26.976814','f3ed6427-14c4-4c3c-91df-3002a87409c7','f3ed6427-14c4-4c3c-91df-3002a87409c7','667e8bfa-a29c-4ad9-967f-02f89f43b812','18e9f280-7994-4c49-95f7-6a6f9ebabd4f','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-22 05:58:03.416117','2025-11-22 05:58:08.275383','2025-11-22 05:58:08.274962','ff3e7232-40bd-4efc-8a3f-80318631d2e5','ff3e7232-40bd-4efc-8a3f-80318631d2e5','2ac4478c-6307-4031-b8c6-c0bc836a8aab','1d9ed15f-ab31-45b4-b3cb-9a2d46be0d63','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `share_snapshot_instances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_metadata`
--

DROP TABLE IF EXISTS `share_snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_metadata` (
  `deleted` varchar(36) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `share_snapshot_id` (`share_snapshot_id`),
  CONSTRAINT `share_snapshot_metadata_ibfk_1` FOREIGN KEY (`share_snapshot_id`) REFERENCES `share_snapshots` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_metadata`
--

LOCK TABLES `share_snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `share_snapshot_metadata` DISABLE KEYS */;
INSERT INTO `share_snapshot_metadata` (`deleted`, `created_at`, `updated_at`, `deleted_at`, `share_snapshot_id`, `key`, `value`, `id`) VALUES ('1','2025-11-22 05:59:17.275145','2025-11-22 05:59:17.563989','2025-11-22 05:59:18.360090','6a5d1464-36eb-4f65-a22f-d6e8dfb31c4d','key5','value5',1),('2','2025-11-22 05:59:17.281361','2025-11-22 05:59:17.605222','2025-11-22 05:59:18.360090','6a5d1464-36eb-4f65-a22f-d6e8dfb31c4d','key6','value6',2),('3','2025-11-22 05:59:17.635788',NULL,'2025-11-22 05:59:18.360090','6a5d1464-36eb-4f65-a22f-d6e8dfb31c4d','key7','value7',3),('4','2025-11-22 05:59:17.637980',NULL,'2025-11-22 05:59:18.360090','6a5d1464-36eb-4f65-a22f-d6e8dfb31c4d','key8','value8',4),('5','2025-11-22 05:59:25.352033','2025-11-22 05:59:25.924118','2025-11-22 05:59:26.990197','667e8bfa-a29c-4ad9-967f-02f89f43b812','key3','value3',5),('6','2025-11-22 05:59:25.356727','2025-11-22 05:59:26.127111','2025-11-22 05:59:26.990197','667e8bfa-a29c-4ad9-967f-02f89f43b812','key4','value4',6),('7','2025-11-22 05:59:25.361520','2025-11-22 05:59:26.283322','2025-11-22 05:59:26.990197','667e8bfa-a29c-4ad9-967f-02f89f43b812','key.5.1','value.5',7),('8','2025-11-22 05:59:30.237881',NULL,'2025-11-22 05:59:34.320633','91849941-04fc-4d5c-809e-4a9e43af8a9b','key1','value1',8),('9','2025-11-22 05:59:30.238450',NULL,'2025-11-22 05:59:34.320633','91849941-04fc-4d5c-809e-4a9e43af8a9b','key2','value2',9),('10','2025-11-22 05:59:40.885429','2025-11-22 05:59:42.072290','2025-11-22 05:59:42.806951','a1f4aa87-8f0d-4096-b514-6eead3321ab7','key9','value13',10),('11','2025-11-22 05:59:40.888044','2025-11-22 05:59:42.261106','2025-11-22 05:59:42.806951','a1f4aa87-8f0d-4096-b514-6eead3321ab7','key10','value10',11),('12','2025-11-22 05:59:41.408825','2025-11-22 05:59:42.397185','2025-11-22 05:59:42.806951','a1f4aa87-8f0d-4096-b514-6eead3321ab7','key11','value11',12),('13','2025-11-22 05:59:45.929218','2025-11-22 05:59:53.234218','2025-11-22 05:59:56.524494','d375caa0-bb8d-47a9-9906-e56f6c4b9b10','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value',13),('14','2025-11-22 05:59:46.250708','2025-11-22 05:59:53.263501','2025-11-22 05:59:56.524494','d375caa0-bb8d-47a9-9906-e56f6c4b9b10','key','v',14),('15','2025-11-22 05:59:46.619757','2025-11-22 05:59:53.290892','2025-11-22 05:59:56.524494','d375caa0-bb8d-47a9-9906-e56f6c4b9b10','k','value',15),('16','2025-11-22 05:59:50.621651','2025-11-22 05:59:51.980136','2025-11-22 05:59:53.025416','b3b5af82-6f64-44d3-be30-5f5255e6da69','key9','value9',16),('17','2025-11-22 05:59:50.624545','2025-11-22 05:59:52.189445','2025-11-22 05:59:53.025416','b3b5af82-6f64-44d3-be30-5f5255e6da69','key10','value10',17),('18','2025-11-22 05:59:51.352146','2025-11-22 05:59:52.353669','2025-11-22 05:59:53.025416','b3b5af82-6f64-44d3-be30-5f5255e6da69','key11','value11',18),('19','2025-11-22 05:59:51.354388','2025-11-22 05:59:52.511939','2025-11-22 05:59:53.025416','b3b5af82-6f64-44d3-be30-5f5255e6da69','key12','value12',19),('20','2025-11-22 05:59:53.336808','2025-11-22 05:59:53.731768','2025-11-22 05:59:56.524494','d375caa0-bb8d-47a9-9906-e56f6c4b9b10','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value',20),('21','2025-11-22 05:59:53.766081','2025-11-22 05:59:54.134701','2025-11-22 05:59:56.524494','d375caa0-bb8d-47a9-9906-e56f6c4b9b10','key','vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv',21),('22','2025-11-22 05:59:54.173379','2025-11-22 05:59:54.612809','2025-11-22 05:59:56.524494','d375caa0-bb8d-47a9-9906-e56f6c4b9b10','k','value',22),('23','2025-11-22 05:59:54.642210',NULL,'2025-11-22 05:59:56.524494','d375caa0-bb8d-47a9-9906-e56f6c4b9b10','key','v',23);
/*!40000 ALTER TABLE `share_snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshots`
--

DROP TABLE IF EXISTS `share_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshots` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `share_id` varchar(36) NOT NULL,
  `size` int(11) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `share_size` int(11) DEFAULT NULL,
  `share_proto` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_id` (`share_id`),
  CONSTRAINT `share_snapshots_ibfk_1` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshots`
--

LOCK TABLES `share_snapshots` WRITE;
/*!40000 ALTER TABLE `share_snapshots` DISABLE KEYS */;
INSERT INTO `share_snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `share_id`, `size`, `display_name`, `display_description`, `share_size`, `share_proto`) VALUES ('2025-11-22 05:50:57.560184','2025-11-22 05:51:03.407758','2025-11-22 05:51:03.406949','1aa7681a-db1a-45b0-a136-7ab46880c277','1aa7681a-db1a-45b0-a136-7ab46880c277','9395a53526744acc85a47d28e0d28556','9ece7a8ade98405884af4e066937cac2','5bffd633-0c47-447b-981e-f37827cac197',1,'tempest-tempest-created-share-snap-265369375','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-22 05:58:03.415089','2025-11-22 05:58:08.289523','2025-11-22 05:58:08.289119','2ac4478c-6307-4031-b8c6-c0bc836a8aab','2ac4478c-6307-4031-b8c6-c0bc836a8aab','85b06cd64746426188d69928ccf28eb0','fab76ed5d22a49d0be1474f6fe848948','59d2283f-fd13-4d0c-acda-f2c67d1bc088',1,'tempest-tempest-created-share-snap-159094359','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-22 05:57:51.862001','2025-11-22 05:58:09.583964','2025-11-22 05:58:09.583546','396d061d-06cf-48da-a32e-5cf66e8782c8','396d061d-06cf-48da-a32e-5cf66e8782c8','c85f7bcc3e4d40d2bc0e6a37832e885d','8179302d26964c999cd5f9a55ba9d33b','fa786287-7fdf-4612-aca2-817bfa149b97',1,'tempest-tempest-created-share-snap-576805338','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-22 06:00:02.900402','2025-11-22 06:00:08.490197','2025-11-22 06:00:08.489207','41f46daf-9a06-4ed4-add0-ee36e9947701','41f46daf-9a06-4ed4-add0-ee36e9947701','a1a7cc23204c4cc98f8e932daf5aa165','39cd34e3d99d4413afb1c277d92dcf8f','511ae11a-c61d-4a3c-97ca-4eb2a5c1ee1a',1,'tempest-tempest-new-name-for-snapshot-464902350','tempest-tempest-new-description-for-snapshot-586497296',1,'CEPHFS'),('2025-11-22 05:52:04.184786','2025-11-22 05:52:16.966124','2025-11-22 05:52:16.965433','43b15887-e470-4d86-be86-556764cf9b47','43b15887-e470-4d86-be86-556764cf9b47','ca8cffb070a549e3b3a19f34d69fb809','161410e8e68843c498c108a7c907faa9','a5a4d39a-6afc-47ca-a64e-59baa4b6d20b',1,'tempest-tempest-created-share-snap-1107277465','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-22 05:51:45.706870','2025-11-22 05:52:15.972889','2025-11-22 05:52:15.972081','4986e2cb-c9fa-4cc5-9de1-755b64f9eec7','4986e2cb-c9fa-4cc5-9de1-755b64f9eec7','3ca1144a55894a528a97f0906826d387','1d43ad7bfa6f468cb936112ef76b83ec','e3f37aa3-6df4-4c21-afa2-3d3d20a6917e',1,'tempest-tempest-created-share-snap-1009564532','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-22 05:59:21.476297','2025-11-22 05:59:26.992660','2025-11-22 05:59:26.991790','667e8bfa-a29c-4ad9-967f-02f89f43b812','667e8bfa-a29c-4ad9-967f-02f89f43b812','123ee1961f274fcf8727f7d4c1fb5248','ef497337be194fcb9ce62d89ec4f8a5a','fa7e2f81-5e9b-4471-bca4-e46b171d2c36',1,'tempest-tempest-created-share-snap-1817834551','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-22 05:59:13.868937','2025-11-22 05:59:18.362322','2025-11-22 05:59:18.361668','6a5d1464-36eb-4f65-a22f-d6e8dfb31c4d','6a5d1464-36eb-4f65-a22f-d6e8dfb31c4d','123ee1961f274fcf8727f7d4c1fb5248','ef497337be194fcb9ce62d89ec4f8a5a','fa7e2f81-5e9b-4471-bca4-e46b171d2c36',1,'tempest-tempest-created-share-snap-170784036','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-22 05:51:46.055016','2025-11-22 05:52:01.416435','2025-11-22 05:52:01.415924','72703134-9023-42d9-b1e8-9374f84d84cc','72703134-9023-42d9-b1e8-9374f84d84cc','19063b71466b4a099f4798ea400aed7c','fffa744c2146473ab31df119246a9181','3f35616a-a117-49b4-9a27-e63f99a9bdc4',1,'tempest-tempest-created-share-snap-213462556','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-22 05:52:00.568946','2025-11-22 05:52:05.333470','2025-11-22 05:52:05.332908','79d46880-5e77-4edf-a5df-f85c46a3035c','79d46880-5e77-4edf-a5df-f85c46a3035c','3ca1144a55894a528a97f0906826d387','1d43ad7bfa6f468cb936112ef76b83ec','e3f37aa3-6df4-4c21-afa2-3d3d20a6917e',1,'tempest-tempest-created-share-snap-271545023','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-22 05:58:48.338530','2025-11-22 05:59:43.723098','2025-11-22 05:59:43.722344','7cb6a540-aa78-41e5-b112-51878416b681','7cb6a540-aa78-41e5-b112-51878416b681','3db9dedf9593479bbad4287d9e10a4d5','1e3df68b14c64c2eba82d76467788260','eb009558-f725-445d-90b6-32ce03b569d0',1,'tempest-tempest-snapshot-name-75301694','tempest-tempest-snapshot-description-1806563132',1,'CEPHFS'),('2025-11-22 05:59:30.237020','2025-11-22 05:59:34.323368','2025-11-22 05:59:34.322556','91849941-04fc-4d5c-809e-4a9e43af8a9b','91849941-04fc-4d5c-809e-4a9e43af8a9b','123ee1961f274fcf8727f7d4c1fb5248','ef497337be194fcb9ce62d89ec4f8a5a','fa7e2f81-5e9b-4471-bca4-e46b171d2c36',1,'tempest-tempest-created-share-snap-657836444','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-22 05:59:37.460208','2025-11-22 05:59:42.809687','2025-11-22 05:59:42.808896','a1f4aa87-8f0d-4096-b514-6eead3321ab7','a1f4aa87-8f0d-4096-b514-6eead3321ab7','123ee1961f274fcf8727f7d4c1fb5248','ef497337be194fcb9ce62d89ec4f8a5a','fa7e2f81-5e9b-4471-bca4-e46b171d2c36',1,'tempest-tempest-created-share-snap-391640372','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-22 05:51:41.807740','2025-11-22 05:52:19.058918','2025-11-22 05:52:19.058389','a9d28ae0-d3cd-4cd7-a310-a66b9a7b4131','a9d28ae0-d3cd-4cd7-a310-a66b9a7b4131','3ca1144a55894a528a97f0906826d387','1d43ad7bfa6f468cb936112ef76b83ec','e3f37aa3-6df4-4c21-afa2-3d3d20a6917e',1,'tempest-tempest-created-share-snap-1498351443','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-22 05:53:18.103619','2025-11-22 05:54:12.017916','2025-11-22 05:54:12.017105','ab580b6a-b19b-46ad-8a5e-1d8d79733bf6','ab580b6a-b19b-46ad-8a5e-1d8d79733bf6','54e641a9522e40ffa67c2ca3c0b53ce6','a87583242abb48e1ba1f4d9c6aa18a9b','d36c5b07-c6d1-453f-8e87-355ac7d60dc7',1,'tempest-tempest-snapshot-name-1106993667','tempest-tempest-snapshot-description-597109874',1,'CEPHFS'),('2025-11-22 05:54:01.112826','2025-11-22 05:54:05.984751','2025-11-22 05:54:05.984291','ace986ad-e44f-45e0-bae4-482714700fcb','ace986ad-e44f-45e0-bae4-482714700fcb','c0acc593440f4aba93cebeb0a88cf188','1c76ef654a3e4144bc0a4cdf01f6107d','b14078d0-94ef-4a05-a729-d7de8cfbf0a4',1,'tempest-tempest-created-share-snap-1787600195','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-22 05:58:29.259914','2025-11-22 05:58:33.600028','2025-11-22 05:58:33.599645','aef441a3-a76b-4305-8686-8c0b89f2f1b9','aef441a3-a76b-4305-8686-8c0b89f2f1b9','120367c7d9ec45569159d69c691c775d','57cc59807cc747c6849cfa0c21089689','2181b348-c082-45ec-ab33-041e5328f0c9',2,'tempest-tempest-created-share-snap-1271055204','Tempest\'s snapshot',2,'CEPHFS'),('2025-11-22 05:59:47.170218','2025-11-22 05:59:53.026903','2025-11-22 05:59:53.026491','b3b5af82-6f64-44d3-be30-5f5255e6da69','b3b5af82-6f64-44d3-be30-5f5255e6da69','123ee1961f274fcf8727f7d4c1fb5248','ef497337be194fcb9ce62d89ec4f8a5a','fa7e2f81-5e9b-4471-bca4-e46b171d2c36',1,'tempest-tempest-created-share-snap-1322032112','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-22 05:52:08.338775','2025-11-22 05:52:13.882552','2025-11-22 05:52:13.881976','b447fbc6-f84c-471a-b434-4cf442d5d06a','b447fbc6-f84c-471a-b434-4cf442d5d06a','ca8cffb070a549e3b3a19f34d69fb809','161410e8e68843c498c108a7c907faa9','a5a4d39a-6afc-47ca-a64e-59baa4b6d20b',1,'tempest-tempest-created-share-snap-951269559','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-22 05:58:44.076627','2025-11-22 05:58:49.048589','2025-11-22 05:58:49.048121','b64ec859-00ea-4356-8f9d-6f1d033496e0','b64ec859-00ea-4356-8f9d-6f1d033496e0','120367c7d9ec45569159d69c691c775d','57cc59807cc747c6849cfa0c21089689','4aae7a32-bf67-4f73-bf74-19367ee159cf',1,'tempest-tempest-created-share-snap-602755362','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-22 05:59:10.163618','2025-11-22 05:59:56.525869','2025-11-22 05:59:56.525459','d375caa0-bb8d-47a9-9906-e56f6c4b9b10','d375caa0-bb8d-47a9-9906-e56f6c4b9b10','123ee1961f274fcf8727f7d4c1fb5248','ef497337be194fcb9ce62d89ec4f8a5a','fa7e2f81-5e9b-4471-bca4-e46b171d2c36',1,'tempest-tempest-snapshot-name-1158500657','tempest-tempest-snapshot-description-1263800983',1,'CEPHFS'),('2025-11-22 05:57:57.468464','2025-11-22 05:58:38.907315','2025-11-22 05:58:38.906777','d70e8843-02c1-482f-aebd-63710671186e','d70e8843-02c1-482f-aebd-63710671186e','4cb3f9c4072c4e558f4e89dc3002ce2d','1304502ff2bf4fc2bce849d08526f92d','8fc96ffe-58ec-4a01-9152-6a45bed340d3',1,'tempest-tempest-snapshot-name-1860836887','tempest-tempest-snapshot-description-507865444',1,'CEPHFS'),('2025-11-22 05:51:50.695343','2025-11-22 05:52:12.057214','2025-11-22 05:52:12.055927','e8012c7d-6e57-4d5f-8dd3-7b9d07a9c2be','e8012c7d-6e57-4d5f-8dd3-7b9d07a9c2be','3ca1144a55894a528a97f0906826d387','1d43ad7bfa6f468cb936112ef76b83ec','e3f37aa3-6df4-4c21-afa2-3d3d20a6917e',1,'tempest-tempest-created-share-snap-353057512','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-22 05:59:11.503743','2025-11-22 05:59:16.638598','2025-11-22 05:59:16.638166','e8c4aec1-9bed-494d-9cc6-4b106df55c19','e8c4aec1-9bed-494d-9cc6-4b106df55c19','010135c9a64149dbb6846c9a653da6b8','325a0f56a64040c18ae384c10457495e','d30ad785-8ea6-4ab6-b62c-a912cd632ebc',1,'tempest-tempest-snapshot-name-960710539','tempest-tempest-snapshot-description-1920752508',1,'CEPHFS'),('2025-11-22 05:57:31.640964','2025-11-22 05:57:35.539749','2025-11-22 05:57:35.539080','ed5a4ca5-3621-4605-bdac-e3cb3da09c16','ed5a4ca5-3621-4605-bdac-e3cb3da09c16','c85f7bcc3e4d40d2bc0e6a37832e885d','8179302d26964c999cd5f9a55ba9d33b','dc95832f-bd83-4269-86ac-bbbfcc21bdfa',1,'tempest-tempest-created-share-snap-537931868','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-22 05:51:56.097856','2025-11-22 05:52:08.411191','2025-11-22 05:52:08.410793','eed29854-f0de-4f56-8a27-13ce2bfe06fa','eed29854-f0de-4f56-8a27-13ce2bfe06fa','3ca1144a55894a528a97f0906826d387','1d43ad7bfa6f468cb936112ef76b83ec','e3f37aa3-6df4-4c21-afa2-3d3d20a6917e',1,'tempest-tempest-created-share-snap-1396544806','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-22 05:51:28.609074','2025-11-22 05:51:32.528147','2025-11-22 05:51:32.527643','fcd19511-0693-413f-9530-f3c80d5b7b7b','fcd19511-0693-413f-9530-f3c80d5b7b7b','3ca1144a55894a528a97f0906826d387','1d43ad7bfa6f468cb936112ef76b83ec','e3f37aa3-6df4-4c21-afa2-3d3d20a6917e',1,'tempest-tempest-created-share-snap-2033466096','Tempest\'s snapshot',1,'CEPHFS');
/*!40000 ALTER TABLE `share_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_type_extra_specs`
--

DROP TABLE IF EXISTS `share_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_type_extra_specs` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_type_id` varchar(36) NOT NULL,
  `spec_key` varchar(255) DEFAULT NULL,
  `spec_value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `st_id_fk` (`share_type_id`),
  CONSTRAINT `st_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=293 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_type_extra_specs`
--

LOCK TABLES `share_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `share_type_extra_specs` DISABLE KEYS */;
INSERT INTO `share_type_extra_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_type_id`, `spec_key`, `spec_value`) VALUES ('2025-11-22 05:47:29.544015',NULL,NULL,0,1,'0c00f43d-e8d6-4ce6-a0df-4c4d03c8513c','driver_handles_share_servers','False'),('2025-11-22 05:47:33.770674',NULL,NULL,0,2,'0c00f43d-e8d6-4ce6-a0df-4c4d03c8513c','snapshot_support','True'),('2025-11-22 05:47:33.777356',NULL,NULL,0,3,'0c00f43d-e8d6-4ce6-a0df-4c4d03c8513c','create_share_from_snapshot_support','True'),('2025-11-22 05:50:49.152450',NULL,'2025-11-22 05:52:26.402655',4,4,'ae29560b-3995-49db-8651-d9dca4b5c54c','driver_handles_share_servers','False'),('2025-11-22 05:50:49.152930',NULL,'2025-11-22 05:52:26.402655',5,5,'ae29560b-3995-49db-8651-d9dca4b5c54c','snapshot_support','True'),('2025-11-22 05:50:53.221121',NULL,'2025-11-22 05:51:09.911518',6,6,'72b75a26-0b62-433e-a838-9cd3b4b43b69','driver_handles_share_servers','False'),('2025-11-22 05:50:53.221568',NULL,'2025-11-22 05:51:09.911518',7,7,'72b75a26-0b62-433e-a838-9cd3b4b43b69','snapshot_support','True'),('2025-11-22 05:50:54.204340',NULL,'2025-11-22 05:51:02.314246',8,8,'5cd9ff63-cfd0-4053-a66f-0941fbf95643','driver_handles_share_servers','False'),('2025-11-22 05:51:05.722725',NULL,'2025-11-22 05:51:39.990981',9,9,'f3cd9bee-b210-4ae4-816a-bb8ba92391c9','driver_handles_share_servers','False'),('2025-11-22 05:51:05.723410',NULL,'2025-11-22 05:51:39.990981',10,10,'f3cd9bee-b210-4ae4-816a-bb8ba92391c9','snapshot_support','True'),('2025-11-22 05:51:05.724135',NULL,'2025-11-22 05:51:39.990981',11,11,'f3cd9bee-b210-4ae4-816a-bb8ba92391c9','create_share_from_snapshot_support','True'),('2025-11-22 05:51:05.915788',NULL,'2025-11-22 05:51:39.596118',12,12,'23542ce2-0314-4df7-8304-4afa45fe5db2','driver_handles_share_servers','False'),('2025-11-22 05:51:06.040427',NULL,'2025-11-22 05:51:39.453492',13,13,'5e508b15-d618-4a27-8b79-1b26df71e665','driver_handles_share_servers','False'),('2025-11-22 05:51:07.341519',NULL,'2025-11-22 05:51:08.487085',14,14,'95e8259f-6244-4173-8b6e-60866827a197','driver_handles_share_servers','False'),('2025-11-22 05:51:07.415430',NULL,'2025-11-22 05:51:08.487085',15,15,'95e8259f-6244-4173-8b6e-60866827a197','key1','value1'),('2025-11-22 05:51:07.418215',NULL,'2025-11-22 05:51:08.487085',16,16,'95e8259f-6244-4173-8b6e-60866827a197','key2','value2'),('2025-11-22 05:51:15.528668',NULL,'2025-11-22 05:51:36.225628',17,17,'4b9d7651-19c5-43ac-bb58-20f5ebca2afc','driver_handles_share_servers','False'),('2025-11-22 05:51:15.529442',NULL,'2025-11-22 05:51:36.225628',18,18,'4b9d7651-19c5-43ac-bb58-20f5ebca2afc','vendor_name','foobar'),('2025-11-22 05:51:18.982747',NULL,'2025-11-22 05:51:28.528740',19,19,'01f563c6-5fd0-4f02-bfc6-595c6cff9c84','driver_handles_share_servers','False'),('2025-11-22 05:51:19.657318',NULL,'2025-11-22 05:51:36.064292',20,20,'d6624012-6e58-49fd-92c2-41fff579b962','driver_handles_share_servers','False'),('2025-11-22 05:51:19.658470',NULL,'2025-11-22 05:51:36.064292',21,21,'d6624012-6e58-49fd-92c2-41fff579b962','vendor_name','foobar'),('2025-11-22 05:51:22.596599',NULL,'2025-11-22 05:51:39.320927',22,22,'8233e672-6ffd-441b-82d4-d8cfa745ac62','driver_handles_share_servers','False'),('2025-11-22 05:51:23.398843',NULL,'2025-11-22 05:51:39.177532',23,23,'77493a25-15f3-46a2-aa42-8cc60bfae5bd','driver_handles_share_servers','False'),('2025-11-22 05:51:23.537964',NULL,'2025-11-22 05:51:35.917033',24,24,'ba0277e3-3973-4052-b400-a5c0085d5c63','driver_handles_share_servers','False'),('2025-11-22 05:51:23.538480',NULL,'2025-11-22 05:51:35.917033',25,25,'ba0277e3-3973-4052-b400-a5c0085d5c63','vendor_name','foobar'),('2025-11-22 05:51:24.593949',NULL,'2025-11-22 05:51:38.941615',26,26,'4a044d39-acd3-45a4-9bab-4e4ff5207080','driver_handles_share_servers','False'),('2025-11-22 05:51:27.550127',NULL,'2025-11-22 05:51:35.788101',27,27,'170222eb-0fff-44bb-9ac3-bc5681dd8de2','driver_handles_share_servers','False'),('2025-11-22 05:51:27.550625',NULL,'2025-11-22 05:51:35.788101',28,28,'170222eb-0fff-44bb-9ac3-bc5681dd8de2','vendor_name','foobar'),('2025-11-22 05:51:29.314274',NULL,'2025-11-22 05:51:38.762889',29,29,'b04f0ad5-a570-45a6-9168-54f1a3291141','driver_handles_share_servers','False'),('2025-11-22 05:51:31.121049',NULL,'2025-11-22 05:51:38.563028',30,30,'052fd418-2f2e-40fe-a1af-6f6eb5e39696','driver_handles_share_servers','False'),('2025-11-22 05:51:31.489952',NULL,'2025-11-22 05:51:35.641631',31,31,'2b6b3050-6c17-4581-9b45-8c5482542326','driver_handles_share_servers','False'),('2025-11-22 05:51:31.490435',NULL,'2025-11-22 05:51:35.641631',32,32,'2b6b3050-6c17-4581-9b45-8c5482542326','vendor_name','foobar'),('2025-11-22 05:51:32.042689',NULL,'2025-11-22 05:51:38.403568',33,33,'9bbba06e-c405-4b53-8876-3be72e9dbdf8','driver_handles_share_servers','False'),('2025-11-22 05:51:32.425491',NULL,'2025-11-22 05:51:38.199896',34,34,'2e9deb11-bcd8-4b11-9b5d-5c17bd2042da','driver_handles_share_servers','False'),('2025-11-22 05:51:37.629208',NULL,'2025-11-22 05:52:11.936447',35,35,'76b8f610-7bd5-4886-9698-850dd629ddbd','driver_handles_share_servers','False'),('2025-11-22 05:51:42.067668',NULL,'2025-11-22 05:52:07.809126',36,36,'0c31157a-4a41-48b4-a5d8-48543e507fe9','driver_handles_share_servers','False'),('2025-11-22 05:51:42.069221',NULL,'2025-11-22 05:52:07.809126',37,37,'0c31157a-4a41-48b4-a5d8-48543e507fe9','snapshot_support','True'),('2025-11-22 05:51:44.222955',NULL,'2025-11-22 05:52:11.778407',38,38,'83710f66-5331-429a-9190-c955e72a6981','driver_handles_share_servers','False'),('2025-11-22 05:51:44.386400',NULL,'2025-11-22 05:51:47.127693',39,39,'feebd432-84a2-4e7f-a3ae-e490288352c9','driver_handles_share_servers','False'),('2025-11-22 05:51:44.565478',NULL,'2025-11-22 05:51:46.984024',40,40,'b4dd835c-50ee-4d3d-9b5b-d5dc61928de6','driver_handles_share_servers','False'),('2025-11-22 05:51:44.774056',NULL,'2025-11-22 05:51:46.843629',41,41,'69d77033-b403-482f-a76b-521f128bf2ff','driver_handles_share_servers','False'),('2025-11-22 05:51:44.975231',NULL,'2025-11-22 05:51:46.706982',42,42,'9044cf35-08fa-4f88-91bc-a4664783acf4','driver_handles_share_servers','False'),('2025-11-22 05:51:45.136884',NULL,'2025-11-22 05:51:46.518795',43,43,'0b24104b-e5fa-43aa-9217-b79a7544b800','driver_handles_share_servers','False'),('2025-11-22 05:51:45.137377',NULL,'2025-11-22 05:51:46.518795',44,44,'0b24104b-e5fa-43aa-9217-b79a7544b800','share_backend_name','tempest-fake_name-1977611132'),('2025-11-22 05:51:45.257988',NULL,'2025-11-22 05:51:46.359860',45,45,'31fd064a-1f49-4b93-8bdd-1a1b58b5d141','driver_handles_share_servers','False'),('2025-11-22 05:51:45.258396',NULL,'2025-11-22 05:51:46.359860',46,46,'31fd064a-1f49-4b93-8bdd-1a1b58b5d141','share_backend_name','tempest-fake_name-1948582087'),('2025-11-22 05:51:45.484283',NULL,'2025-11-22 05:51:46.190671',47,47,'25226c08-c4cd-4886-a741-ddb6316c35b7','driver_handles_share_servers','False'),('2025-11-22 05:51:45.484799',NULL,'2025-11-22 05:51:46.190671',48,48,'25226c08-c4cd-4886-a741-ddb6316c35b7','share_backend_name','tempest-fake_name-386127497'),('2025-11-22 05:51:45.634346',NULL,'2025-11-22 05:51:45.836715',49,49,'eeb9e6f3-5b8f-4400-9dd6-a80d3e877ad0','driver_handles_share_servers','False'),('2025-11-22 05:51:45.634778',NULL,'2025-11-22 05:51:45.836715',50,50,'eeb9e6f3-5b8f-4400-9dd6-a80d3e877ad0','share_backend_name','tempest-fake_name-1467316764'),('2025-11-22 05:51:50.587990',NULL,'2025-11-22 05:52:00.576531',51,51,'5008c592-2a6d-453e-a8f8-8b109c952a95','driver_handles_share_servers','False'),('2025-11-22 05:51:50.833965',NULL,'2025-11-22 05:52:00.247883',52,52,'8fd11717-20ba-4169-9684-c338bfd7f478','driver_handles_share_servers','False'),('2025-11-22 05:51:51.289902',NULL,'2025-11-22 05:52:00.091351',53,53,'bf52b356-0305-440f-896e-3f5f94c2e6d8','driver_handles_share_servers','False'),('2025-11-22 05:51:52.374307',NULL,'2025-11-22 05:51:59.920676',54,54,'140dced9-0b54-49c4-b747-47037d6ddfe6','driver_handles_share_servers','False'),('2025-11-22 05:51:52.540326',NULL,'2025-11-22 05:51:59.572878',55,55,'eb23f0c5-9f94-46c8-843b-a3d9252db2c9','driver_handles_share_servers','False'),('2025-11-22 05:51:52.686920',NULL,'2025-11-22 05:51:59.354517',56,56,'1fbc3e9e-b8c3-4c06-b9aa-7d3e3800158c','driver_handles_share_servers','False'),('2025-11-22 05:51:55.228706',NULL,'2025-11-22 05:51:59.086684',57,57,'c893e52e-491a-418b-927a-7a29d16cb0a2','driver_handles_share_servers','False'),('2025-11-22 05:51:56.079889',NULL,'2025-11-22 05:51:58.940959',58,58,'1cc43803-fb4c-451c-994b-bdd547f71652','driver_handles_share_servers','False'),('2025-11-22 05:51:56.338281',NULL,'2025-11-22 05:51:58.794842',59,59,'144b3d2e-181b-4b90-95cd-bbc348d7b0ae','driver_handles_share_servers','False'),('2025-11-22 05:51:56.548986',NULL,'2025-11-22 05:51:58.635922',60,60,'8f79b927-98c1-4e61-a9f8-e94b57ede2c6','driver_handles_share_servers','False'),('2025-11-22 05:51:57.479060',NULL,'2025-11-22 05:51:58.466968',61,61,'49b49815-2ccc-4f01-85a6-b53bc89a25b7','driver_handles_share_servers','False'),('2025-11-22 05:51:57.842736',NULL,'2025-11-22 05:51:58.214220',62,62,'f80cf8b4-5907-4fa2-84be-22615363ecca','driver_handles_share_servers','False'),('2025-11-22 05:52:00.249113',NULL,'2025-11-22 05:52:23.553240',63,63,'72fda760-d07e-4ff4-b88e-2511b31404ed','driver_handles_share_servers','False'),('2025-11-22 05:52:00.249566',NULL,'2025-11-22 05:52:23.553240',64,64,'72fda760-d07e-4ff4-b88e-2511b31404ed','snapshot_support','True'),('2025-11-22 05:52:24.190530',NULL,'2025-11-22 05:52:33.086526',65,65,'a2eae7d4-7042-401a-973a-249989b912a4','driver_handles_share_servers','False'),('2025-11-22 05:52:30.195882',NULL,'2025-11-22 05:52:42.008577',66,66,'603187a6-cda6-47ce-835c-b276acaf653c','driver_handles_share_servers','False'),('2025-11-22 05:52:30.196473',NULL,'2025-11-22 05:52:42.008577',67,67,'603187a6-cda6-47ce-835c-b276acaf653c','key','value'),('2025-11-22 05:52:30.584931',NULL,'2025-11-22 05:52:41.840199',68,68,'425cfd9e-d222-4067-b459-38222a86a24c','driver_handles_share_servers','False'),('2025-11-22 05:52:30.585505',NULL,'2025-11-22 05:52:41.840199',69,69,'425cfd9e-d222-4067-b459-38222a86a24c','key','value'),('2025-11-22 05:52:30.766762',NULL,'2025-11-22 05:52:41.459833',70,70,'1907ed4b-e4b3-4aa2-b11f-ca25ad1e2c90','driver_handles_share_servers','False'),('2025-11-22 05:52:30.769293',NULL,'2025-11-22 05:52:41.459833',71,71,'1907ed4b-e4b3-4aa2-b11f-ca25ad1e2c90','key','value'),('2025-11-22 05:52:31.135431',NULL,'2025-11-22 05:52:41.225296',72,72,'03856cfa-e6c7-4022-9769-40b9ff233887','driver_handles_share_servers','False'),('2025-11-22 05:52:31.135980',NULL,'2025-11-22 05:52:41.225296',73,73,'03856cfa-e6c7-4022-9769-40b9ff233887','key','value'),('2025-11-22 05:52:31.483991',NULL,'2025-11-22 05:52:40.987796',74,74,'872ad9b2-2ecd-430a-bd6d-62cc625427a9','driver_handles_share_servers','False'),('2025-11-22 05:52:31.484651',NULL,'2025-11-22 05:52:40.987796',75,75,'872ad9b2-2ecd-430a-bd6d-62cc625427a9','key','value'),('2025-11-22 05:52:31.781863',NULL,'2025-11-22 05:52:40.796279',76,76,'3bae97ba-f673-4963-ad81-79e59e21e39e','driver_handles_share_servers','False'),('2025-11-22 05:52:31.782372',NULL,'2025-11-22 05:52:40.796279',77,77,'3bae97ba-f673-4963-ad81-79e59e21e39e','key','value'),('2025-11-22 05:52:32.004582',NULL,'2025-11-22 05:52:40.578543',78,78,'03b6bd4a-a9e3-40bb-ac09-d37a4fb04d46','driver_handles_share_servers','False'),('2025-11-22 05:52:32.004919',NULL,'2025-11-22 05:52:40.578543',79,79,'03b6bd4a-a9e3-40bb-ac09-d37a4fb04d46','key','value'),('2025-11-22 05:52:32.293100',NULL,'2025-11-22 05:52:40.327099',80,80,'4168c176-2525-46f3-a185-5b4384d492d6','driver_handles_share_servers','False'),('2025-11-22 05:52:32.293729',NULL,'2025-11-22 05:52:40.327099',81,81,'4168c176-2525-46f3-a185-5b4384d492d6','key','value'),('2025-11-22 05:52:32.699653',NULL,'2025-11-22 05:52:40.173947',82,82,'34073d12-3adf-4902-81ed-f1d04b794efb','driver_handles_share_servers','False'),('2025-11-22 05:52:32.700093',NULL,'2025-11-22 05:52:40.173947',83,83,'34073d12-3adf-4902-81ed-f1d04b794efb','key','value'),('2025-11-22 05:52:32.893447',NULL,'2025-11-22 05:52:40.055662',84,84,'9a1ef266-310d-46ad-87d6-30ddf4baf4cf','driver_handles_share_servers','False'),('2025-11-22 05:52:32.893836',NULL,'2025-11-22 05:52:40.055662',85,85,'9a1ef266-310d-46ad-87d6-30ddf4baf4cf','key','value'),('2025-11-22 05:52:33.080479',NULL,'2025-11-22 05:52:39.861716',86,86,'6202d096-e814-457f-8daa-c3670b08f4a8','driver_handles_share_servers','False'),('2025-11-22 05:52:33.080877',NULL,'2025-11-22 05:52:39.861716',87,87,'6202d096-e814-457f-8daa-c3670b08f4a8','key','value'),('2025-11-22 05:52:33.818889',NULL,'2025-11-22 05:52:39.553621',88,88,'edfc69e5-46d1-43d5-b47d-d794743aa0f1','driver_handles_share_servers','False'),('2025-11-22 05:52:33.822029',NULL,'2025-11-22 05:52:39.553621',89,89,'edfc69e5-46d1-43d5-b47d-d794743aa0f1','key','value'),('2025-11-22 05:52:34.174138',NULL,'2025-11-22 05:52:39.392568',90,90,'f3fe8eeb-698d-46b7-8a6a-75d5c1be73de','driver_handles_share_servers','False'),('2025-11-22 05:52:34.174772',NULL,'2025-11-22 05:52:39.392568',91,91,'f3fe8eeb-698d-46b7-8a6a-75d5c1be73de','key','value'),('2025-11-22 05:52:34.361817',NULL,'2025-11-22 05:52:39.104921',92,92,'62759468-8bc6-4bd5-8aeb-6935ba6bff11','driver_handles_share_servers','False'),('2025-11-22 05:52:34.365659',NULL,'2025-11-22 05:52:39.104921',93,93,'62759468-8bc6-4bd5-8aeb-6935ba6bff11','key','value'),('2025-11-22 05:52:34.546629',NULL,'2025-11-22 05:52:38.948509',94,94,'0b262734-ad33-4062-8abb-d8b7675836f2','driver_handles_share_servers','False'),('2025-11-22 05:52:34.547214',NULL,'2025-11-22 05:52:38.948509',95,95,'0b262734-ad33-4062-8abb-d8b7675836f2','key','value'),('2025-11-22 05:52:34.711061',NULL,'2025-11-22 05:52:38.806073',96,96,'7e239560-e792-455e-a40d-21fa34c61f57','driver_handles_share_servers','False'),('2025-11-22 05:52:34.712333',NULL,'2025-11-22 05:52:38.806073',97,97,'7e239560-e792-455e-a40d-21fa34c61f57','key','value'),('2025-11-22 05:52:35.135225',NULL,'2025-11-22 05:52:38.676224',98,98,'a7c8e66d-1f58-4b5b-9f44-e43a526fd141','driver_handles_share_servers','False'),('2025-11-22 05:52:35.135655',NULL,'2025-11-22 05:52:38.676224',99,99,'a7c8e66d-1f58-4b5b-9f44-e43a526fd141','key','value'),('2025-11-22 05:52:35.452400',NULL,'2025-11-22 05:52:45.117475',100,100,'d4fe4178-7457-4c27-b05c-d200652bfa09','driver_handles_share_servers','False'),('2025-11-22 05:52:35.872511',NULL,'2025-11-22 05:52:38.536647',101,101,'f30f5b98-5f4f-4060-bc6c-623eace78e2c','driver_handles_share_servers','False'),('2025-11-22 05:52:35.872855',NULL,'2025-11-22 05:52:38.536647',102,102,'f30f5b98-5f4f-4060-bc6c-623eace78e2c','key','value'),('2025-11-22 05:52:36.262713',NULL,'2025-11-22 05:52:38.398218',103,103,'cb072283-9f02-4dc5-a0f8-fec20e9fdef2','driver_handles_share_servers','False'),('2025-11-22 05:52:36.263073',NULL,'2025-11-22 05:52:38.398218',104,104,'cb072283-9f02-4dc5-a0f8-fec20e9fdef2','key','value'),('2025-11-22 05:52:36.566217',NULL,'2025-11-22 05:52:38.105784',105,105,'927e539e-96c1-46dd-81c8-cdb5f7e1f6e9','driver_handles_share_servers','False'),('2025-11-22 05:52:36.567682',NULL,'2025-11-22 05:52:38.105784',106,106,'927e539e-96c1-46dd-81c8-cdb5f7e1f6e9','key','value'),('2025-11-22 05:52:36.881206',NULL,'2025-11-22 05:52:37.908910',107,107,'17f15c6e-d929-46d4-adc5-a6be4f4042d2','driver_handles_share_servers','False'),('2025-11-22 05:52:36.881641',NULL,'2025-11-22 05:52:37.908910',108,108,'17f15c6e-d929-46d4-adc5-a6be4f4042d2','key','value'),('2025-11-22 05:52:37.218099',NULL,'2025-11-22 05:52:37.670120',109,109,'5fe71c1c-2e20-49fe-bfce-5d7d818c49e8','driver_handles_share_servers','False'),('2025-11-22 05:52:37.218485',NULL,'2025-11-22 05:52:37.670120',110,110,'5fe71c1c-2e20-49fe-bfce-5d7d818c49e8','key','value'),('2025-11-22 05:52:45.485202',NULL,NULL,0,111,'3f5f10b5-5a29-4a2e-a4a9-9c80d7a9b422','driver_handles_share_servers','False'),('2025-11-22 05:52:46.570535',NULL,'2025-11-22 05:52:55.810640',112,112,'f5058f8f-6143-4b6d-8d20-02b50ffa22a6','driver_handles_share_servers','False'),('2025-11-22 05:52:49.064492',NULL,'2025-11-22 05:53:09.664069',113,113,'55c95d49-aa56-4fad-870f-b645f28cd680','driver_handles_share_servers','False'),('2025-11-22 05:52:49.065318',NULL,'2025-11-22 05:53:09.664069',114,114,'55c95d49-aa56-4fad-870f-b645f28cd680','storage_protocol','cephfs'),('2025-11-22 05:52:51.041581',NULL,'2025-11-22 05:52:53.758383',115,115,'2a3b6bc1-bdcb-402b-bd2b-78f8b0bd818f','driver_handles_share_servers','False'),('2025-11-22 05:52:51.042532',NULL,'2025-11-22 05:52:53.758383',116,116,'2a3b6bc1-bdcb-402b-bd2b-78f8b0bd818f','key','value'),('2025-11-22 05:52:51.723337',NULL,'2025-11-22 05:52:53.581634',117,117,'8491cc75-c0ab-454f-b988-ba17b9d517fd','driver_handles_share_servers','False'),('2025-11-22 05:52:52.532823',NULL,'2025-11-22 05:52:53.445952',118,118,'ab671b11-b220-418f-8a6d-51180eb8ab69','driver_handles_share_servers','False'),('2025-11-22 05:52:52.534873',NULL,'2025-11-22 05:52:53.445952',119,119,'ab671b11-b220-418f-8a6d-51180eb8ab69','key','value'),('2025-11-22 05:52:52.803180',NULL,'2025-11-22 05:52:53.289055',120,120,'b4f0d32e-d735-4f82-b317-f51cfe7581fe','driver_handles_share_servers','False'),('2025-11-22 05:52:52.803906',NULL,'2025-11-22 05:52:53.289055',121,121,'b4f0d32e-d735-4f82-b317-f51cfe7581fe','key','value'),('2025-11-22 05:52:53.006434',NULL,'2025-11-22 05:53:05.676477',122,122,'5b4f4cbc-48d5-4d29-ad00-60b38ff60589','driver_handles_share_servers','False'),('2025-11-22 05:52:53.006791',NULL,'2025-11-22 05:53:05.676477',123,123,'5b4f4cbc-48d5-4d29-ad00-60b38ff60589','key','value'),('2025-11-22 05:52:53.806959',NULL,'2025-11-22 05:52:53.901554',124,124,'197d1aaf-241f-479f-b884-bafc7bd19e6e','driver_handles_share_servers','False'),('2025-11-22 05:52:54.297540',NULL,'2025-11-22 05:53:05.517326',125,125,'1e0529b0-b87c-4a42-af75-aed32f2b1e07','driver_handles_share_servers','False'),('2025-11-22 05:52:54.298030',NULL,'2025-11-22 05:53:05.517326',126,126,'1e0529b0-b87c-4a42-af75-aed32f2b1e07','key','value'),('2025-11-22 05:52:54.298530',NULL,'2025-11-22 05:53:05.517326',127,127,'1e0529b0-b87c-4a42-af75-aed32f2b1e07','snapshot_support','True'),('2025-11-22 05:52:54.584782',NULL,'2025-11-22 05:53:05.248485',128,128,'f01c2e8a-eb88-4741-a87a-8a5a5320797f','driver_handles_share_servers','False'),('2025-11-22 05:52:54.585236',NULL,'2025-11-22 05:53:05.248485',129,129,'f01c2e8a-eb88-4741-a87a-8a5a5320797f','key','value'),('2025-11-22 05:52:54.585657',NULL,'2025-11-22 05:53:05.248485',130,130,'f01c2e8a-eb88-4741-a87a-8a5a5320797f','snapshot_support','True'),('2025-11-22 05:52:54.784984',NULL,'2025-11-22 05:53:05.078685',131,131,'03b33e3a-31d1-4da2-a0fe-5ce05ff929da','driver_handles_share_servers','False'),('2025-11-22 05:52:54.785478',NULL,'2025-11-22 05:53:05.078685',132,132,'03b33e3a-31d1-4da2-a0fe-5ce05ff929da','key','value'),('2025-11-22 05:52:54.785846',NULL,'2025-11-22 05:53:05.078685',133,133,'03b33e3a-31d1-4da2-a0fe-5ce05ff929da','snapshot_support','True'),('2025-11-22 05:52:54.916312',NULL,'2025-11-22 05:53:04.808467',134,134,'9417ee22-b9f6-4797-89cd-39fd5abe9135','driver_handles_share_servers','False'),('2025-11-22 05:52:54.916693',NULL,'2025-11-22 05:53:04.808467',135,135,'9417ee22-b9f6-4797-89cd-39fd5abe9135','key','value'),('2025-11-22 05:52:55.067376',NULL,'2025-11-22 05:53:04.509969',136,136,'5ee5b4c7-89c7-4cfa-891c-2d7bcd575182','driver_handles_share_servers','False'),('2025-11-22 05:52:55.067873',NULL,'2025-11-22 05:53:04.509969',137,137,'5ee5b4c7-89c7-4cfa-891c-2d7bcd575182','key','value'),('2025-11-22 05:52:55.207248',NULL,'2025-11-22 05:53:04.238940',138,138,'88e43784-8c63-49fb-ac73-2cce89b82e39','driver_handles_share_servers','False'),('2025-11-22 05:52:55.207928',NULL,'2025-11-22 05:53:04.238940',139,139,'88e43784-8c63-49fb-ac73-2cce89b82e39','snapshot_support','True'),('2025-11-22 05:52:55.375946',NULL,'2025-11-22 05:53:03.983475',140,140,'1f576066-00b9-4af8-a80c-bbf936452bfe','driver_handles_share_servers','False'),('2025-11-22 05:52:55.376366',NULL,'2025-11-22 05:53:03.983475',141,141,'1f576066-00b9-4af8-a80c-bbf936452bfe','snapshot_support','True'),('2025-11-22 05:52:55.596065',NULL,'2025-11-22 05:53:03.777341',142,142,'6f5ed99c-8cfb-4bc9-9469-15e1d7edec3a','driver_handles_share_servers','False'),('2025-11-22 05:52:55.596533',NULL,'2025-11-22 05:53:03.777341',143,143,'6f5ed99c-8cfb-4bc9-9469-15e1d7edec3a','snapshot_support','True'),('2025-11-22 05:52:55.809157',NULL,'2025-11-22 05:53:03.587228',144,144,'53085466-456a-417b-98ea-35a93acfef05','driver_handles_share_servers','False'),('2025-11-22 05:52:55.940720',NULL,'2025-11-22 05:53:03.400148',145,145,'8d56291d-4678-46e8-adf2-b16c7018d3ac','driver_handles_share_servers','False'),('2025-11-22 05:52:56.171366',NULL,'2025-11-22 05:53:03.232998',146,146,'b684b7a7-b5b7-4b71-98ab-2075c7e194d9','driver_handles_share_servers','False'),('2025-11-22 05:52:56.696023',NULL,'2025-11-22 05:53:03.016680',147,147,'573752c0-cab3-4fae-ae61-8ebd64ad55fa','driver_handles_share_servers','False'),('2025-11-22 05:52:56.966220',NULL,'2025-11-22 05:53:02.749422',148,148,'4bfaf8ed-d445-40fb-927e-f96722a3e482','driver_handles_share_servers','False'),('2025-11-22 05:52:57.288066',NULL,'2025-11-22 05:53:02.552415',149,149,'1b04d2c0-9e8a-40bc-a52a-d07abd676951','driver_handles_share_servers','False'),('2025-11-22 05:52:57.288481',NULL,'2025-11-22 05:53:02.552415',150,150,'1b04d2c0-9e8a-40bc-a52a-d07abd676951','key','value'),('2025-11-22 05:52:57.431854',NULL,'2025-11-22 05:53:02.424119',151,151,'422593c6-efc1-433f-8110-7f3b2f5f5568','driver_handles_share_servers','False'),('2025-11-22 05:52:57.436773',NULL,'2025-11-22 05:53:02.424119',152,152,'422593c6-efc1-433f-8110-7f3b2f5f5568','key','value'),('2025-11-22 05:52:57.652668',NULL,'2025-11-22 05:53:02.257598',153,153,'f803ee57-6fed-4472-a724-f97c7489848f','driver_handles_share_servers','False'),('2025-11-22 05:52:57.653168',NULL,'2025-11-22 05:53:02.257598',154,154,'f803ee57-6fed-4472-a724-f97c7489848f','key','value'),('2025-11-22 05:52:57.895512',NULL,'2025-11-22 05:53:01.977386',155,155,'f4b57031-c863-462d-b0df-3dbcc781ddd6','driver_handles_share_servers','False'),('2025-11-22 05:52:57.895977',NULL,'2025-11-22 05:53:01.977386',156,156,'f4b57031-c863-462d-b0df-3dbcc781ddd6','key','value'),('2025-11-22 05:52:58.122747',NULL,'2025-11-22 05:53:01.691437',157,157,'ed0b85e7-1d3e-4221-9594-2660c7b1b5b9','driver_handles_share_servers','False'),('2025-11-22 05:52:58.132865',NULL,'2025-11-22 05:53:01.691437',158,158,'ed0b85e7-1d3e-4221-9594-2660c7b1b5b9','key','value'),('2025-11-22 05:52:58.304809',NULL,'2025-11-22 05:53:01.494998',159,159,'bb635c61-397b-4df9-82f9-f01996cca1da','driver_handles_share_servers','False'),('2025-11-22 05:52:58.305395',NULL,'2025-11-22 05:53:01.494998',160,160,'bb635c61-397b-4df9-82f9-f01996cca1da','key','value'),('2025-11-22 05:52:58.520702',NULL,'2025-11-22 05:53:01.134455',161,161,'3646d514-9059-4233-93c6-542ac6d2bdb6','driver_handles_share_servers','False'),('2025-11-22 05:52:58.521312',NULL,'2025-11-22 05:53:01.134455',162,162,'3646d514-9059-4233-93c6-542ac6d2bdb6','key','value'),('2025-11-22 05:52:58.732076',NULL,'2025-11-22 05:53:00.808098',163,163,'7a558026-2393-46cb-ad66-ac4fa7c318c2','driver_handles_share_servers','False'),('2025-11-22 05:52:58.732637',NULL,'2025-11-22 05:53:00.808098',164,164,'7a558026-2393-46cb-ad66-ac4fa7c318c2','key','value'),('2025-11-22 05:52:58.995132',NULL,'2025-11-22 05:53:00.567531',165,165,'5b2c628b-eecc-4ec0-9c26-17d8814f5cfc','driver_handles_share_servers','False'),('2025-11-22 05:52:58.995735',NULL,'2025-11-22 05:53:00.567531',166,166,'5b2c628b-eecc-4ec0-9c26-17d8814f5cfc','key','value'),('2025-11-22 05:52:59.140367',NULL,'2025-11-22 05:53:00.225206',167,167,'33972030-16a6-4b81-8893-97cf624f04a8','driver_handles_share_servers','False'),('2025-11-22 05:52:59.141095',NULL,'2025-11-22 05:53:00.225206',168,168,'33972030-16a6-4b81-8893-97cf624f04a8','key','value'),('2025-11-22 05:52:59.401540',NULL,'2025-11-22 05:53:00.038718',169,169,'fa6930af-2185-464e-a571-758926335181','driver_handles_share_servers','False'),('2025-11-22 05:52:59.402409',NULL,'2025-11-22 05:53:00.038718',170,170,'fa6930af-2185-464e-a571-758926335181','key','value'),('2025-11-22 05:52:59.677991',NULL,'2025-11-22 05:52:59.875885',171,171,'8b217c05-7915-4d29-8796-7eef50875e3b','driver_handles_share_servers','False'),('2025-11-22 05:52:59.679036',NULL,'2025-11-22 05:52:59.875885',172,172,'8b217c05-7915-4d29-8796-7eef50875e3b','key','value'),('2025-11-22 05:53:09.027061',NULL,'2025-11-22 05:54:05.750751',173,173,'16388226-9203-43cc-b11b-c8d5e0b43cf5','driver_handles_share_servers','False'),('2025-11-22 05:53:11.636012',NULL,'2025-11-22 05:53:13.513391',174,174,'6e49142e-626b-42ba-ac4c-1cb61d4d8fdd','driver_handles_share_servers','False'),('2025-11-22 05:53:12.368344',NULL,'2025-11-22 05:53:12.716126',175,175,'cf1fca7b-b814-45dd-891c-8e87f476c40f','driver_handles_share_servers','False'),('2025-11-22 05:53:12.950240',NULL,'2025-11-22 05:53:13.217588',176,176,'7611f9d7-3a00-48ed-b161-ad70691170a4','driver_handles_share_servers','False'),('2025-11-22 05:53:14.142207',NULL,'2025-11-22 05:54:18.587729',177,177,'13ee97c5-d501-438f-a1cb-88b356e6aea5','driver_handles_share_servers','False'),('2025-11-22 05:53:14.142571',NULL,'2025-11-22 05:54:18.587729',178,178,'13ee97c5-d501-438f-a1cb-88b356e6aea5','storage_protocol','cephfs'),('2025-11-22 05:53:14.142849',NULL,'2025-11-22 05:54:18.587729',179,179,'13ee97c5-d501-438f-a1cb-88b356e6aea5','snapshot_support','True'),('2025-11-22 05:53:14.144011',NULL,'2025-11-22 05:54:18.587729',180,180,'13ee97c5-d501-438f-a1cb-88b356e6aea5','create_share_from_snapshot_support','True'),('2025-11-22 05:53:57.521124',NULL,'2025-11-22 05:54:12.589939',181,181,'a5b83cc3-3a22-4b5e-9258-2ea0c4739722','driver_handles_share_servers','False'),('2025-11-22 05:53:57.521836',NULL,'2025-11-22 05:54:12.589939',182,182,'a5b83cc3-3a22-4b5e-9258-2ea0c4739722','snapshot_support','True'),('2025-11-22 05:54:14.530998',NULL,'2025-11-22 05:54:38.143771',183,183,'a4dd46bb-4dd9-48bd-92ee-1a6f0e9dbfe6','driver_handles_share_servers','False'),('2025-11-22 05:54:19.882396',NULL,'2025-11-22 05:54:24.113947',184,184,'6b0c406a-f035-4b37-b2d2-4c6ac06297ee','driver_handles_share_servers','False'),('2025-11-22 05:54:20.014987',NULL,'2025-11-22 05:54:20.110946',185,185,'6b0c406a-f035-4b37-b2d2-4c6ac06297ee','key1','value1'),('2025-11-22 05:54:20.016957',NULL,'2025-11-22 05:54:24.113947',186,186,'6b0c406a-f035-4b37-b2d2-4c6ac06297ee','key2','value2'),('2025-11-22 05:54:20.252308',NULL,'2025-11-22 05:54:23.734484',187,187,'cfc7af5e-d0a1-4db0-a5e2-eb81cb1b5212','driver_handles_share_servers','False'),('2025-11-22 05:54:20.561439',NULL,'2025-11-22 05:54:23.734484',188,188,'cfc7af5e-d0a1-4db0-a5e2-eb81cb1b5212','key1','value1'),('2025-11-22 05:54:20.564213',NULL,'2025-11-22 05:54:23.734484',189,189,'cfc7af5e-d0a1-4db0-a5e2-eb81cb1b5212','key2','value2'),('2025-11-22 05:54:20.738077',NULL,'2025-11-22 05:54:21.007550',190,190,'cfc7af5e-d0a1-4db0-a5e2-eb81cb1b5212','snapshot_support','True'),('2025-11-22 05:54:21.173010',NULL,'2025-11-22 05:54:23.587613',191,191,'104502b6-cf8e-4bfb-9d6c-8fac21c88331','driver_handles_share_servers','False'),('2025-11-22 05:54:21.283774',NULL,'2025-11-22 05:54:23.587613',192,192,'104502b6-cf8e-4bfb-9d6c-8fac21c88331','key1','value1'),('2025-11-22 05:54:21.287759',NULL,'2025-11-22 05:54:23.587613',193,193,'104502b6-cf8e-4bfb-9d6c-8fac21c88331','key2','value2'),('2025-11-22 05:54:21.381714',NULL,'2025-11-22 05:54:21.722871',194,194,'104502b6-cf8e-4bfb-9d6c-8fac21c88331','snapshot_support','True'),('2025-11-22 05:54:21.918442',NULL,'2025-11-22 05:54:23.379048',195,195,'cad45d55-537a-476b-8bcb-07992c2d9a0f','driver_handles_share_servers','False'),('2025-11-22 05:54:21.999192',NULL,'2025-11-22 05:54:23.379048',196,196,'cad45d55-537a-476b-8bcb-07992c2d9a0f','key1','value1'),('2025-11-22 05:54:22.001131','2025-11-22 05:54:22.094191','2025-11-22 05:54:23.379048',197,197,'cad45d55-537a-476b-8bcb-07992c2d9a0f','key2','value2_updated'),('2025-11-22 05:54:22.604078',NULL,'2025-11-22 05:54:23.178000',198,198,'7adb754f-7a76-4a0b-81e5-9fac3b310170','driver_handles_share_servers','False'),('2025-11-22 05:54:22.683670','2025-11-22 05:54:22.765342','2025-11-22 05:54:23.178000',199,199,'7adb754f-7a76-4a0b-81e5-9fac3b310170','key1','fake_value1_updated'),('2025-11-22 05:54:22.685912',NULL,'2025-11-22 05:54:23.178000',200,200,'7adb754f-7a76-4a0b-81e5-9fac3b310170','key2','value2'),('2025-11-22 05:54:31.503758',NULL,'2025-11-22 05:55:12.494458',201,201,'ce3f0727-d1a8-4676-a5dc-450c47e136e8','driver_handles_share_servers','False'),('2025-11-22 05:54:31.504172',NULL,'2025-11-22 05:55:12.494458',202,202,'ce3f0727-d1a8-4676-a5dc-450c47e136e8','vendor_name','foobar'),('2025-11-22 05:54:35.682242',NULL,'2025-11-22 05:55:12.368431',203,203,'dcc3507b-971d-43d8-92d2-0d2d0d8c3319','driver_handles_share_servers','False'),('2025-11-22 05:54:35.683314',NULL,'2025-11-22 05:55:12.368431',204,204,'dcc3507b-971d-43d8-92d2-0d2d0d8c3319','vendor_name','foobar'),('2025-11-22 05:54:39.478354',NULL,'2025-11-22 05:54:48.023297',205,205,'4ef04f31-d6fe-496c-bd09-358cf74fb9ed','driver_handles_share_servers','False'),('2025-11-22 05:54:39.784198',NULL,'2025-11-22 05:55:12.226072',206,206,'08c8c52d-b3da-414c-a61c-d2410111b7e1','driver_handles_share_servers','False'),('2025-11-22 05:54:39.784659',NULL,'2025-11-22 05:55:12.226072',207,207,'08c8c52d-b3da-414c-a61c-d2410111b7e1','vendor_name','foobar'),('2025-11-22 05:54:43.267220',NULL,'2025-11-22 05:55:12.101922',208,208,'69975aa8-2ab7-43ef-9ea3-bf3bb458d4bc','driver_handles_share_servers','False'),('2025-11-22 05:54:43.267976',NULL,'2025-11-22 05:55:12.101922',209,209,'69975aa8-2ab7-43ef-9ea3-bf3bb458d4bc','vendor_name','foobar'),('2025-11-22 05:54:47.563198',NULL,'2025-11-22 05:55:11.971431',210,210,'087a7cbd-37cd-4168-a9ba-348c6ff7993e','driver_handles_share_servers','False'),('2025-11-22 05:54:47.563588',NULL,'2025-11-22 05:55:11.971431',211,211,'087a7cbd-37cd-4168-a9ba-348c6ff7993e','vendor_name','foobar'),('2025-11-22 05:54:48.166427',NULL,'2025-11-22 05:55:57.885710',212,212,'6aa6c955-bb1a-4082-b637-96733e409710','driver_handles_share_servers','False'),('2025-11-22 05:54:51.205124',NULL,'2025-11-22 05:55:11.854507',213,213,'734709e5-5e22-4d51-b713-3988d1991371','driver_handles_share_servers','False'),('2025-11-22 05:54:51.205729',NULL,'2025-11-22 05:55:11.854507',214,214,'734709e5-5e22-4d51-b713-3988d1991371','vendor_name','foobar'),('2025-11-22 05:54:55.221395',NULL,'2025-11-22 05:55:11.716055',215,215,'56215025-9394-421b-abc0-95508b2f4030','driver_handles_share_servers','False'),('2025-11-22 05:54:55.221717',NULL,'2025-11-22 05:55:11.716055',216,216,'56215025-9394-421b-abc0-95508b2f4030','vendor_name','foobar'),('2025-11-22 05:54:59.706737',NULL,'2025-11-22 05:55:11.597738',217,217,'b9bcbdc8-5a4b-450b-a372-7a3b2f4ae1ab','driver_handles_share_servers','False'),('2025-11-22 05:54:59.707164',NULL,'2025-11-22 05:55:11.597738',218,218,'b9bcbdc8-5a4b-450b-a372-7a3b2f4ae1ab','vendor_name','foobar'),('2025-11-22 05:55:03.183449',NULL,'2025-11-22 05:55:11.388638',219,219,'f359449b-fe9e-4653-86a0-8fec8f992613','driver_handles_share_servers','False'),('2025-11-22 05:55:03.183847',NULL,'2025-11-22 05:55:11.388638',220,220,'f359449b-fe9e-4653-86a0-8fec8f992613','vendor_name','foobar'),('2025-11-22 05:55:04.134883',NULL,'2025-11-22 05:55:12.331438',221,221,'e3483182-8b2a-4128-9f1a-b73d4873cc06','driver_handles_share_servers','False'),('2025-11-22 05:55:07.314336',NULL,'2025-11-22 05:55:11.200220',222,222,'96afc477-3877-4b27-b4cf-f6aaa221d409','driver_handles_share_servers','False'),('2025-11-22 05:55:07.315450',NULL,'2025-11-22 05:55:11.200220',223,223,'96afc477-3877-4b27-b4cf-f6aaa221d409','vendor_name','foobar'),('2025-11-22 05:55:25.695496',NULL,'2025-11-22 05:55:39.673548',224,224,'2f0b3a7d-f01b-42f3-a793-334c04c6eb88','driver_handles_share_servers','False'),('2025-11-22 05:55:27.498146',NULL,'2025-11-22 05:55:30.175243',225,225,'58025a57-6b88-4552-9b84-2f94c0f89a1a','driver_handles_share_servers','False'),('2025-11-22 05:55:40.521025',NULL,'2025-11-22 05:55:44.298777',226,226,'74bdce4e-83c2-495d-939a-8e70e009df33','driver_handles_share_servers','False'),('2025-11-22 05:55:47.632960',NULL,'2025-11-22 05:55:51.371647',227,227,'dc878306-a1ad-4669-810b-2240d01da5dd','driver_handles_share_servers','False'),('2025-11-22 05:56:00.164628',NULL,'2025-11-22 05:56:02.136685',228,228,'61170f9a-c7ac-4b87-b413-c54777d961f1','driver_handles_share_servers','False'),('2025-11-22 05:56:14.342005',NULL,'2025-11-22 05:56:22.823488',229,229,'bc148b41-c4b4-450d-9fb4-e61454af1efe','driver_handles_share_servers','False'),('2025-11-22 05:56:25.726462',NULL,'2025-11-22 05:57:37.780706',230,230,'bc6cfada-cc8c-44a7-8599-cc459a4ac116','driver_handles_share_servers','False'),('2025-11-22 05:56:31.336049',NULL,'2025-11-22 05:56:33.348706',231,231,'d99c4e9d-6f6b-41d5-a5ff-4aa88f590db4','driver_handles_share_servers','False'),('2025-11-22 05:56:33.920315',NULL,'2025-11-22 05:56:51.058934',232,232,'64c44c63-ca32-44df-83e7-0d5ad0ba1c02','driver_handles_share_servers','False'),('2025-11-22 05:56:39.157124',NULL,'2025-11-22 05:57:19.423671',233,233,'5426bf6e-b197-4c02-be68-82ee99c5c64e','driver_handles_share_servers','False'),('2025-11-22 05:56:39.607961',NULL,'2025-11-22 05:56:39.831701',234,234,'ebaa9ed0-76f9-47f9-9711-c3282af3b9bd','driver_handles_share_servers','False'),('2025-11-22 05:56:39.609633',NULL,'2025-11-22 05:56:39.831701',235,235,'ebaa9ed0-76f9-47f9-9711-c3282af3b9bd','availability_zones','az1,az2,az 3'),('2025-11-22 05:56:40.062700',NULL,'2025-11-22 05:56:40.354506',236,236,'799e3cdc-a9e1-4b19-a6ba-d66c9d3787dc','driver_handles_share_servers','False'),('2025-11-22 05:56:40.063177',NULL,'2025-11-22 05:56:40.354506',237,237,'799e3cdc-a9e1-4b19-a6ba-d66c9d3787dc','availability_zones','az1,az2,az 3'),('2025-11-22 05:56:40.678062',NULL,'2025-11-22 05:56:40.871850',238,238,'325b7c80-250a-4369-905a-d88a7445fed3','driver_handles_share_servers','False'),('2025-11-22 05:56:40.678730',NULL,'2025-11-22 05:56:40.871850',239,239,'325b7c80-250a-4369-905a-d88a7445fed3','availability_zones','az1,az2,az 3'),('2025-11-22 05:56:41.099120',NULL,'2025-11-22 05:56:41.787690',240,240,'112ba62f-5862-4c76-bcce-fa0a5682862d','driver_handles_share_servers','False'),('2025-11-22 05:56:41.099591',NULL,'2025-11-22 05:56:41.787690',241,241,'112ba62f-5862-4c76-bcce-fa0a5682862d','availability_zones','az1,az2,az 3'),('2025-11-22 05:56:41.483427',NULL,'2025-11-22 05:56:41.658651',242,242,'f821d7e7-5b91-486d-ac54-52650a9f6f42','driver_handles_share_servers','False'),('2025-11-22 05:56:41.930000',NULL,'2025-11-22 05:56:42.561523',243,243,'fc98bae2-5025-4ab9-b9a1-d9d2694cba6e','driver_handles_share_servers','False'),('2025-11-22 05:56:41.930732',NULL,'2025-11-22 05:56:42.561523',244,244,'fc98bae2-5025-4ab9-b9a1-d9d2694cba6e','availability_zones','az1,az2,az 3'),('2025-11-22 05:56:42.052411',NULL,'2025-11-22 05:56:42.210342',245,245,'07b212af-acc9-43ba-ac8b-05cab5ab0352','driver_handles_share_servers','False'),('2025-11-22 05:56:42.721072',NULL,'2025-11-22 05:56:43.146966',246,246,'daf1ea78-d498-4294-b391-0fd9f00b8dbe','driver_handles_share_servers','False'),('2025-11-22 05:56:42.721957',NULL,'2025-11-22 05:56:43.146966',247,247,'daf1ea78-d498-4294-b391-0fd9f00b8dbe','availability_zones','az1,az2,az 3'),('2025-11-22 05:56:42.805018',NULL,'2025-11-22 05:56:42.977219',248,248,'85cf8301-0cc9-4d6d-856e-f39f52e513ea','driver_handles_share_servers','False'),('2025-11-22 05:56:43.306329',NULL,'2025-11-22 05:56:43.801000',249,249,'489e7515-4181-4654-8d8c-8204b89e91c1','driver_handles_share_servers','False'),('2025-11-22 05:56:43.307080',NULL,'2025-11-22 05:56:43.801000',250,250,'489e7515-4181-4654-8d8c-8204b89e91c1','availability_zones','az1,az2,az 3'),('2025-11-22 05:56:43.409427',NULL,'2025-11-22 05:56:43.631226',251,251,'7c9eb107-859d-4970-bac0-fe1e5f9f893d','driver_handles_share_servers','False'),('2025-11-22 05:56:43.968824',NULL,'2025-11-22 05:56:44.407040',252,252,'665af06e-ea13-4cb3-bd51-d7acdcb3c679','driver_handles_share_servers','False'),('2025-11-22 05:56:43.969537',NULL,'2025-11-22 05:56:44.407040',253,253,'665af06e-ea13-4cb3-bd51-d7acdcb3c679','availability_zones','az1,az2,az 3'),('2025-11-22 05:56:44.043950',NULL,'2025-11-22 05:56:44.198480',254,254,'26694f36-b63b-4899-b0a2-2cd447cf2d88','driver_handles_share_servers','False'),('2025-11-22 05:56:44.579654',NULL,'2025-11-22 05:56:45.023935',255,255,'b69c42d9-b167-44ae-9b10-c198e5722678','driver_handles_share_servers','False'),('2025-11-22 05:56:44.580327',NULL,'2025-11-22 05:56:45.023935',256,256,'b69c42d9-b167-44ae-9b10-c198e5722678','availability_zones','az1,az2,az 3'),('2025-11-22 05:56:44.690474',NULL,'2025-11-22 05:56:44.845645',257,257,'00864c65-e825-43fb-a6be-a9dc8a1e2ffb','driver_handles_share_servers','False'),('2025-11-22 05:56:45.152540','2025-11-22 05:56:59.579977','2025-11-22 05:57:19.423671',258,258,'5426bf6e-b197-4c02-be68-82ee99c5c64e','availability_zones','nova'),('2025-11-22 05:57:00.815013',NULL,'2025-11-22 05:57:32.334963',259,259,'33ab82b2-9d13-455f-b64f-cb0f7247c292','driver_handles_share_servers','False'),('2025-11-22 05:57:27.752004',NULL,'2025-11-22 05:58:17.468552',260,260,'e92e4c96-7852-4844-a49a-2fed8941ce22','driver_handles_share_servers','False'),('2025-11-22 05:57:27.813080',NULL,'2025-11-22 05:57:42.318785',261,261,'2b6505d8-6c33-411c-9b84-112503c4c108','driver_handles_share_servers','False'),('2025-11-22 05:57:27.813482',NULL,'2025-11-22 05:57:42.318785',262,262,'2b6505d8-6c33-411c-9b84-112503c4c108','snapshot_support','True'),('2025-11-22 05:57:41.225714',NULL,'2025-11-22 05:57:43.924877',263,263,'8890da9c-5419-40fe-9500-71ebafb39efd','driver_handles_share_servers','False'),('2025-11-22 05:57:41.391066',NULL,'2025-11-22 05:57:43.752916',264,264,'d99e0d35-abd1-459c-a4f3-a968684a65c8','driver_handles_share_servers','False'),('2025-11-22 05:57:51.095138',NULL,'2025-11-22 05:58:16.215632',265,265,'0a1faf7d-a096-4ae6-821a-0cea16578a95','driver_handles_share_servers','False'),('2025-11-22 05:57:51.095478',NULL,'2025-11-22 05:58:16.215632',266,266,'0a1faf7d-a096-4ae6-821a-0cea16578a95','snapshot_support','True'),('2025-11-22 05:57:51.095846',NULL,'2025-11-22 05:58:16.215632',267,267,'0a1faf7d-a096-4ae6-821a-0cea16578a95','create_share_from_snapshot_support','True'),('2025-11-22 05:57:53.502035',NULL,'2025-11-22 05:58:45.628011',268,268,'d59519d5-a66d-4c06-a170-dbc2876b25c1','driver_handles_share_servers','False'),('2025-11-22 05:57:53.502511',NULL,'2025-11-22 05:58:45.628011',269,269,'d59519d5-a66d-4c06-a170-dbc2876b25c1','snapshot_support','True'),('2025-11-22 05:57:59.684448',NULL,'2025-11-22 05:58:14.961910',270,270,'47b5ed1b-aab2-4f77-a767-0d9e2aea3ca1','driver_handles_share_servers','False'),('2025-11-22 05:57:59.685172',NULL,'2025-11-22 05:58:14.961910',271,271,'47b5ed1b-aab2-4f77-a767-0d9e2aea3ca1','snapshot_support','True'),('2025-11-22 05:58:25.266140',NULL,'2025-11-22 05:58:58.896581',272,272,'cfea797e-06da-4537-b54d-22f274a0b710','driver_handles_share_servers','False'),('2025-11-22 05:58:25.266641',NULL,'2025-11-22 05:58:58.896581',273,273,'cfea797e-06da-4537-b54d-22f274a0b710','snapshot_support','True'),('2025-11-22 05:58:25.267053',NULL,'2025-11-22 05:58:58.896581',274,274,'cfea797e-06da-4537-b54d-22f274a0b710','create_share_from_snapshot_support','True'),('2025-11-22 05:58:31.134722',NULL,'2025-11-22 05:58:33.409406',275,275,'6fd6ec7f-3bec-440f-b4a3-1e22184e83a8','driver_handles_share_servers','False'),('2025-11-22 05:58:31.748846','2025-11-22 05:58:32.125607','2025-11-22 05:58:33.409406',276,276,'6fd6ec7f-3bec-440f-b4a3-1e22184e83a8','availability_zones','az_that_doesnt_exist'),('2025-11-22 05:58:31.834127',NULL,'2025-11-22 05:58:31.963232',277,277,'789f2051-0dd9-4315-8ed4-6eca8fc94ab4','driver_handles_share_servers','False'),('2025-11-22 05:58:44.259622',NULL,'2025-11-22 05:59:50.229382',278,278,'6630451a-185f-4b7a-8306-f600314a71e1','driver_handles_share_servers','False'),('2025-11-22 05:58:44.260095',NULL,'2025-11-22 05:59:50.229382',279,279,'6630451a-185f-4b7a-8306-f600314a71e1','snapshot_support','True'),('2025-11-22 05:58:44.260580',NULL,'2025-11-22 05:59:50.229382',280,280,'6630451a-185f-4b7a-8306-f600314a71e1','create_share_from_snapshot_support','True'),('2025-11-22 05:58:55.021393',NULL,'2025-11-22 05:58:57.745606',281,281,'00550c92-4d6c-4d8a-b174-eae6ca798dad','driver_handles_share_servers','False'),('2025-11-22 05:58:55.105765',NULL,'2025-11-22 05:58:57.519528',282,282,'c12abeeb-9ad3-45f8-8565-bc934c59ab9b','driver_handles_share_servers','False'),('2025-11-22 05:58:55.106403',NULL,'2025-11-22 05:58:57.519528',283,283,'c12abeeb-9ad3-45f8-8565-bc934c59ab9b','provisioning:max_share_size','5'),('2025-11-22 05:58:55.106899',NULL,'2025-11-22 05:58:57.519528',284,284,'c12abeeb-9ad3-45f8-8565-bc934c59ab9b','provisioning:min_share_size','2'),('2025-11-22 05:59:06.321099',NULL,'2025-11-22 06:00:03.167209',285,285,'229f2490-4a8a-45d0-973b-52a743d76f0f','driver_handles_share_servers','False'),('2025-11-22 05:59:06.321632',NULL,'2025-11-22 06:00:03.167209',286,286,'229f2490-4a8a-45d0-973b-52a743d76f0f','snapshot_support','True'),('2025-11-22 05:59:06.322110',NULL,'2025-11-22 06:00:03.167209',287,287,'229f2490-4a8a-45d0-973b-52a743d76f0f','create_share_from_snapshot_support','True'),('2025-11-22 05:59:07.867423',NULL,'2025-11-22 05:59:23.313683',288,288,'100c722e-6c00-4303-ac29-b6525536cfc3','driver_handles_share_servers','False'),('2025-11-22 05:59:07.868026',NULL,'2025-11-22 05:59:23.313683',289,289,'100c722e-6c00-4303-ac29-b6525536cfc3','snapshot_support','True'),('2025-11-22 05:59:07.868491',NULL,'2025-11-22 05:59:23.313683',290,290,'100c722e-6c00-4303-ac29-b6525536cfc3','create_share_from_snapshot_support','True'),('2025-11-22 05:59:58.976677',NULL,'2025-11-22 06:00:15.325169',291,291,'4940c47f-fec8-4869-8fba-d842e9b292ea','driver_handles_share_servers','False'),('2025-11-22 05:59:58.977562',NULL,'2025-11-22 06:00:15.325169',292,292,'4940c47f-fec8-4869-8fba-d842e9b292ea','snapshot_support','True');
/*!40000 ALTER TABLE `share_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_type_projects`
--

DROP TABLE IF EXISTS `share_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `stp_project_id_uc` (`share_type_id`,`project_id`,`deleted`),
  CONSTRAINT `stp_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_type_projects`
--

LOCK TABLES `share_type_projects` WRITE;
/*!40000 ALTER TABLE `share_type_projects` DISABLE KEYS */;
INSERT INTO `share_type_projects` (`id`, `created_at`, `updated_at`, `deleted_at`, `share_type_id`, `project_id`, `deleted`) VALUES (1,'2025-11-22 05:52:53.404684',NULL,'2025-11-22 05:52:53.614852','5b4f4cbc-48d5-4d29-ad00-60b38ff60589','c3e25870be384f238bccdf6c103762a8',1);
/*!40000 ALTER TABLE `share_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_types`
--

DROP TABLE IF EXISTS `share_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_types` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `st_name_uc` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_types`
--

LOCK TABLES `share_types` WRITE;
/*!40000 ALTER TABLE `share_types` DISABLE KEYS */;
INSERT INTO `share_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `is_public`, `description`) VALUES ('2025-11-22 05:58:55.020398',NULL,'2025-11-22 05:58:57.750792','00550c92-4d6c-4d8a-b174-eae6ca798dad','00550c92-4d6c-4d8a-b174-eae6ca798dad','tempest-typeshare-type-1013896714',1,NULL),('2025-11-22 05:56:44.689163',NULL,'2025-11-22 05:56:44.850218','00864c65-e825-43fb-a6be-a9dc8a1e2ffb','00864c65-e825-43fb-a6be-a9dc8a1e2ffb','tempest-support_any_az_share_type-1433073906',1,NULL),('2025-11-22 05:51:18.981945',NULL,'2025-11-22 05:51:28.530852','01f563c6-5fd0-4f02-bfc6-595c6cff9c84','01f563c6-5fd0-4f02-bfc6-595c6cff9c84','tempest-typeshare-type-1749235358',1,NULL),('2025-11-22 05:52:31.134684',NULL,'2025-11-22 05:52:41.229189','03856cfa-e6c7-4022-9769-40b9ff233887','03856cfa-e6c7-4022-9769-40b9ff233887','tempest-typeshare-type-473316966',1,NULL),('2025-11-22 05:52:54.783830',NULL,'2025-11-22 05:53:05.081045','03b33e3a-31d1-4da2-a0fe-5ce05ff929da','03b33e3a-31d1-4da2-a0fe-5ce05ff929da','tempest-tempest-manila-1868205473',1,NULL),('2025-11-22 05:52:32.003948',NULL,'2025-11-22 05:52:40.580824','03b6bd4a-a9e3-40bb-ac09-d37a4fb04d46','03b6bd4a-a9e3-40bb-ac09-d37a4fb04d46','tempest-typeshare-type-660400129',1,NULL),('2025-11-22 05:51:31.120442',NULL,'2025-11-22 05:51:38.566185','052fd418-2f2e-40fe-a1af-6f6eb5e39696','052fd418-2f2e-40fe-a1af-6f6eb5e39696','tempest-typeshare-type-229882711',0,NULL),('2025-11-22 05:56:42.051689',NULL,'2025-11-22 05:56:42.219460','07b212af-acc9-43ba-ac8b-05cab5ab0352','07b212af-acc9-43ba-ac8b-05cab5ab0352','tempest-support_any_az_share_type-30541600',1,NULL),('2025-11-22 05:54:47.562578',NULL,'2025-11-22 05:55:11.974082','087a7cbd-37cd-4168-a9ba-348c6ff7993e','087a7cbd-37cd-4168-a9ba-348c6ff7993e','tempest-share-type-731184899',1,NULL),('2025-11-22 05:54:39.783331',NULL,'2025-11-22 05:55:12.229044','08c8c52d-b3da-414c-a61c-d2410111b7e1','08c8c52d-b3da-414c-a61c-d2410111b7e1','tempest-share-type-2133966593',1,NULL),('2025-11-22 05:57:51.094487',NULL,'2025-11-22 05:58:16.218183','0a1faf7d-a096-4ae6-821a-0cea16578a95','0a1faf7d-a096-4ae6-821a-0cea16578a95','tempest-typeshare-type-335049211',1,NULL),('2025-11-22 05:51:45.135981',NULL,'2025-11-22 05:51:46.523204','0b24104b-e5fa-43aa-9217-b79a7544b800','0b24104b-e5fa-43aa-9217-b79a7544b800','tempest-unique_st_name-235568829',1,NULL),('2025-11-22 05:52:34.544846',NULL,'2025-11-22 05:52:38.951006','0b262734-ad33-4062-8abb-d8b7675836f2','0b262734-ad33-4062-8abb-d8b7675836f2','tempest-typeshare-type-458967987',1,NULL),('2025-11-22 05:47:29.540689',NULL,NULL,'False','0c00f43d-e8d6-4ce6-a0df-4c4d03c8513c','default',1,NULL),('2025-11-22 05:51:42.062369',NULL,'2025-11-22 05:52:07.812871','0c31157a-4a41-48b4-a5d8-48543e507fe9','0c31157a-4a41-48b4-a5d8-48543e507fe9','tempest-typeshare-type-1314875290',1,NULL),('2025-11-22 05:59:07.866222',NULL,'2025-11-22 05:59:23.319561','100c722e-6c00-4303-ac29-b6525536cfc3','100c722e-6c00-4303-ac29-b6525536cfc3','tempest-typeshare-type-467404165',1,NULL),('2025-11-22 05:54:21.172162',NULL,'2025-11-22 05:54:23.589786','104502b6-cf8e-4bfb-9d6c-8fac21c88331','104502b6-cf8e-4bfb-9d6c-8fac21c88331','tempest-share-type-2143194785',1,NULL),('2025-11-22 05:56:41.098372',NULL,'2025-11-22 05:56:41.790567','112ba62f-5862-4c76-bcce-fa0a5682862d','112ba62f-5862-4c76-bcce-fa0a5682862d','tempest-support_some_azs_share_type-966788843',1,NULL),('2025-11-22 05:53:14.141513',NULL,'2025-11-22 05:54:18.591200','13ee97c5-d501-438f-a1cb-88b356e6aea5','13ee97c5-d501-438f-a1cb-88b356e6aea5','tempest-typeshare-type-1014737382',1,NULL),('2025-11-22 05:51:52.373421',NULL,'2025-11-22 05:51:59.922824','140dced9-0b54-49c4-b747-47037d6ddfe6','140dced9-0b54-49c4-b747-47037d6ddfe6','tempest-typeshare-type-750541986',1,NULL),('2025-11-22 05:51:56.337074',NULL,'2025-11-22 05:51:58.797178','144b3d2e-181b-4b90-95cd-bbc348d7b0ae','144b3d2e-181b-4b90-95cd-bbc348d7b0ae','tempest-typeshare-type-440192784',1,NULL),('2025-11-22 05:53:09.026331',NULL,'2025-11-22 05:54:05.753939','16388226-9203-43cc-b11b-c8d5e0b43cf5','16388226-9203-43cc-b11b-c8d5e0b43cf5','tempest-typeshare-type-307334003',1,NULL),('2025-11-22 05:51:27.549286',NULL,'2025-11-22 05:51:35.790485','170222eb-0fff-44bb-9ac3-bc5681dd8de2','170222eb-0fff-44bb-9ac3-bc5681dd8de2','tempest-share-type-822324038',1,NULL),('2025-11-22 05:52:36.880681',NULL,'2025-11-22 05:52:37.911534','17f15c6e-d929-46d4-adc5-a6be4f4042d2','17f15c6e-d929-46d4-adc5-a6be4f4042d2','tempest-typeshare-type-84997062',1,NULL),('2025-11-22 05:52:30.766086',NULL,'2025-11-22 05:52:41.466832','1907ed4b-e4b3-4aa2-b11f-ca25ad1e2c90','1907ed4b-e4b3-4aa2-b11f-ca25ad1e2c90','tempest-typeshare-type-1575011061',1,NULL),('2025-11-22 05:52:53.806343',NULL,'2025-11-22 05:52:53.903652','197d1aaf-241f-479f-b884-bafc7bd19e6e','197d1aaf-241f-479f-b884-bafc7bd19e6e','tempest-tempest-manila-1472137148',1,NULL),('2025-11-22 05:52:57.287425','2025-11-22 05:52:57.359639','2025-11-22 05:53:02.555718','1b04d2c0-9e8a-40bc-a52a-d07abd676951','1b04d2c0-9e8a-40bc-a52a-d07abd676951','tempest-type_updated-1618513517',1,'description_updated'),('2025-11-22 05:51:56.078964',NULL,'2025-11-22 05:51:58.945525','1cc43803-fb4c-451c-994b-bdd547f71652','1cc43803-fb4c-451c-994b-bdd547f71652','tempest-typeshare-type-1596077361',1,NULL),('2025-11-22 05:52:54.296087',NULL,'2025-11-22 05:53:05.522964','1e0529b0-b87c-4a42-af75-aed32f2b1e07','1e0529b0-b87c-4a42-af75-aed32f2b1e07','tempest-tempest-manila-1206721802',1,NULL),('2025-11-22 05:52:55.375103',NULL,'2025-11-22 05:53:04.002432','1f576066-00b9-4af8-a80c-bbf936452bfe','1f576066-00b9-4af8-a80c-bbf936452bfe','tempest-tempest-manila-413280066',1,NULL),('2025-11-22 05:51:52.686129',NULL,'2025-11-22 05:51:59.358562','1fbc3e9e-b8c3-4c06-b9aa-7d3e3800158c','1fbc3e9e-b8c3-4c06-b9aa-7d3e3800158c','tempest-typeshare-type-518977396',1,NULL),('2025-11-22 05:59:06.320078',NULL,'2025-11-22 06:00:03.172555','229f2490-4a8a-45d0-973b-52a743d76f0f','229f2490-4a8a-45d0-973b-52a743d76f0f','tempest-typeshare-type-132045695',1,NULL),('2025-11-22 05:51:05.914947',NULL,'2025-11-22 05:51:39.599688','23542ce2-0314-4df7-8304-4afa45fe5db2','23542ce2-0314-4df7-8304-4afa45fe5db2','tempest-typeshare-type-1116295262',1,NULL),('2025-11-22 05:51:45.483465',NULL,'2025-11-22 05:51:46.194043','25226c08-c4cd-4886-a741-ddb6316c35b7','25226c08-c4cd-4886-a741-ddb6316c35b7','tempest-unique_st_name-934625350',1,NULL),('2025-11-22 05:56:44.043121',NULL,'2025-11-22 05:56:44.202223','26694f36-b63b-4899-b0a2-2cd447cf2d88','26694f36-b63b-4899-b0a2-2cd447cf2d88','tempest-support_any_az_share_type-1453320407',1,NULL),('2025-11-22 05:52:51.039917',NULL,'2025-11-22 05:52:53.761981','2a3b6bc1-bdcb-402b-bd2b-78f8b0bd818f','2a3b6bc1-bdcb-402b-bd2b-78f8b0bd818f','tempest-typeshare-type-15710087',1,NULL),('2025-11-22 05:57:27.812163',NULL,'2025-11-22 05:57:42.322815','2b6505d8-6c33-411c-9b84-112503c4c108','2b6505d8-6c33-411c-9b84-112503c4c108','tempest-typeshare-type-1066272145',1,NULL),('2025-11-22 05:51:31.488822',NULL,'2025-11-22 05:51:35.647884','2b6b3050-6c17-4581-9b45-8c5482542326','2b6b3050-6c17-4581-9b45-8c5482542326','tempest-share-type-1790104075',1,NULL),('2025-11-22 05:51:32.424683',NULL,'2025-11-22 05:51:38.203991','2e9deb11-bcd8-4b11-9b5d-5c17bd2042da','2e9deb11-bcd8-4b11-9b5d-5c17bd2042da','tempest-typeshare-type-386187472',1,NULL),('2025-11-22 05:55:25.694764',NULL,'2025-11-22 05:55:39.678909','2f0b3a7d-f01b-42f3-a793-334c04c6eb88','2f0b3a7d-f01b-42f3-a793-334c04c6eb88','tempest-typeshare-type-1773883205',1,NULL),('2025-11-22 05:51:45.257190',NULL,'2025-11-22 05:51:46.362560','31fd064a-1f49-4b93-8bdd-1a1b58b5d141','31fd064a-1f49-4b93-8bdd-1a1b58b5d141','tempest-unique_st_name-1299712081',1,NULL),('2025-11-22 05:56:40.672062',NULL,'2025-11-22 05:56:40.874076','325b7c80-250a-4369-905a-d88a7445fed3','325b7c80-250a-4369-905a-d88a7445fed3','tempest-az_share_type-1083992512',1,NULL),('2025-11-22 05:52:59.139568','2025-11-22 05:52:59.237689','2025-11-22 05:53:00.230572','33972030-16a6-4b81-8893-97cf624f04a8','33972030-16a6-4b81-8893-97cf624f04a8','tempest-tempest-manila-1217557077',0,'Description for share type'),('2025-11-22 05:57:00.814037',NULL,'2025-11-22 05:57:32.337016','33ab82b2-9d13-455f-b64f-cb0f7247c292','33ab82b2-9d13-455f-b64f-cb0f7247c292','tempest-typeshare-type-1969568900',1,NULL),('2025-11-22 05:52:32.698615',NULL,'2025-11-22 05:52:40.175946','34073d12-3adf-4902-81ed-f1d04b794efb','34073d12-3adf-4902-81ed-f1d04b794efb','tempest-typeshare-type-2082911346',1,NULL),('2025-11-22 05:52:58.520026','2025-11-22 05:52:58.653091','2025-11-22 05:53:01.137565','3646d514-9059-4233-93c6-542ac6d2bdb6','3646d514-9059-4233-93c6-542ac6d2bdb6','tempest-type_updated-1587783009',1,'Description for share type'),('2025-11-22 05:52:31.780695',NULL,'2025-11-22 05:52:40.798863','3bae97ba-f673-4963-ad81-79e59e21e39e','3bae97ba-f673-4963-ad81-79e59e21e39e','tempest-typeshare-type-1287838101',1,NULL),('2025-11-22 05:52:45.483929',NULL,NULL,'False','3f5f10b5-5a29-4a2e-a4a9-9c80d7a9b422','tempest-typeshare-type-730157527',1,NULL),('2025-11-22 05:52:32.290034',NULL,'2025-11-22 05:52:40.330460','4168c176-2525-46f3-a185-5b4384d492d6','4168c176-2525-46f3-a185-5b4384d492d6','tempest-typeshare-type-1483944808',1,NULL),('2025-11-22 05:52:57.427853','2025-11-22 05:52:57.568055','2025-11-22 05:53:02.426993','422593c6-efc1-433f-8110-7f3b2f5f5568','422593c6-efc1-433f-8110-7f3b2f5f5568','tempest-type_updated-1115519055',1,'Description for share type'),('2025-11-22 05:52:30.583721',NULL,'2025-11-22 05:52:41.842874','425cfd9e-d222-4067-b459-38222a86a24c','425cfd9e-d222-4067-b459-38222a86a24c','tempest-typeshare-type-402065188',1,NULL),('2025-11-22 05:57:59.683150',NULL,'2025-11-22 05:58:14.965429','47b5ed1b-aab2-4f77-a767-0d9e2aea3ca1','47b5ed1b-aab2-4f77-a767-0d9e2aea3ca1','tempest-typeshare-type-2126202865',1,NULL),('2025-11-22 05:56:43.305179',NULL,'2025-11-22 05:56:43.804234','489e7515-4181-4654-8d8c-8204b89e91c1','489e7515-4181-4654-8d8c-8204b89e91c1','tempest-support_some_azs_share_type-1817476144',1,NULL),('2025-11-22 05:59:58.975388',NULL,'2025-11-22 06:00:15.329960','4940c47f-fec8-4869-8fba-d842e9b292ea','4940c47f-fec8-4869-8fba-d842e9b292ea','tempest-typeshare-type-1163633783',1,NULL),('2025-11-22 05:51:57.477955',NULL,'2025-11-22 05:51:58.469544','49b49815-2ccc-4f01-85a6-b53bc89a25b7','49b49815-2ccc-4f01-85a6-b53bc89a25b7','tempest-typeshare-type-1124655978',1,NULL),('2025-11-22 05:51:24.592745',NULL,'2025-11-22 05:51:38.945032','4a044d39-acd3-45a4-9bab-4e4ff5207080','4a044d39-acd3-45a4-9bab-4e4ff5207080','tempest-typeshare-type-1962483915',1,NULL),('2025-11-22 05:51:15.527563',NULL,'2025-11-22 05:51:36.228319','4b9d7651-19c5-43ac-bb58-20f5ebca2afc','4b9d7651-19c5-43ac-bb58-20f5ebca2afc','tempest-share-type-1891791259',1,NULL),('2025-11-22 05:52:56.965421',NULL,'2025-11-22 05:53:02.751515','4bfaf8ed-d445-40fb-927e-f96722a3e482','4bfaf8ed-d445-40fb-927e-f96722a3e482','tempest-tempest-manila-2098570717',1,NULL),('2025-11-22 05:54:39.477073',NULL,'2025-11-22 05:54:48.025574','4ef04f31-d6fe-496c-bd09-358cf74fb9ed','4ef04f31-d6fe-496c-bd09-358cf74fb9ed','tempest-typeshare-type-991309613',1,NULL),('2025-11-22 05:51:50.586840',NULL,'2025-11-22 05:52:00.578462','5008c592-2a6d-453e-a8f8-8b109c952a95','5008c592-2a6d-453e-a8f8-8b109c952a95','tempest-typeshare-type-1651710904',1,NULL),('2025-11-22 05:52:55.808221',NULL,'2025-11-22 05:53:03.589383','53085466-456a-417b-98ea-35a93acfef05','53085466-456a-417b-98ea-35a93acfef05','tempest-tempest-manila-1935149344',1,NULL),('2025-11-22 05:56:39.155848',NULL,'2025-11-22 05:57:19.428683','5426bf6e-b197-4c02-be68-82ee99c5c64e','5426bf6e-b197-4c02-be68-82ee99c5c64e','tempest-typeshare-type-895598600',1,NULL),('2025-11-22 05:52:49.063046',NULL,'2025-11-22 05:53:09.667647','55c95d49-aa56-4fad-870f-b645f28cd680','55c95d49-aa56-4fad-870f-b645f28cd680','tempest-share-type-497138142',1,NULL),('2025-11-22 05:54:55.220710',NULL,'2025-11-22 05:55:11.718229','56215025-9394-421b-abc0-95508b2f4030','56215025-9394-421b-abc0-95508b2f4030','tempest-share-type-317564311',1,NULL),('2025-11-22 05:52:56.694882',NULL,'2025-11-22 05:53:03.019554','573752c0-cab3-4fae-ae61-8ebd64ad55fa','573752c0-cab3-4fae-ae61-8ebd64ad55fa','tempest-tempest-manila-1955608640',1,NULL),('2025-11-22 05:55:27.496129',NULL,'2025-11-22 05:55:30.180757','58025a57-6b88-4552-9b84-2f94c0f89a1a','58025a57-6b88-4552-9b84-2f94c0f89a1a','tempest-typeshare-type-256623885',1,NULL),('2025-11-22 05:52:58.994189','2025-11-22 05:52:59.062768','2025-11-22 05:53:00.569779','5b2c628b-eecc-4ec0-9c26-17d8814f5cfc','5b2c628b-eecc-4ec0-9c26-17d8814f5cfc','tempest-tempest-manila-901705951',1,'Description for share type'),('2025-11-22 05:52:53.005538',NULL,'2025-11-22 05:53:05.680948','5b4f4cbc-48d5-4d29-ad00-60b38ff60589','5b4f4cbc-48d5-4d29-ad00-60b38ff60589','tempest-tempest-manila-1171270483',0,NULL),('2025-11-22 05:50:54.202921',NULL,'2025-11-22 05:51:02.318392','5cd9ff63-cfd0-4053-a66f-0941fbf95643','5cd9ff63-cfd0-4053-a66f-0941fbf95643','tempest-typeshare-type-163004318',1,NULL),('2025-11-22 05:51:06.038807',NULL,'2025-11-22 05:51:39.455762','5e508b15-d618-4a27-8b79-1b26df71e665','5e508b15-d618-4a27-8b79-1b26df71e665','tempest-typeshare-type-1256061664',1,NULL),('2025-11-22 05:52:55.066152',NULL,'2025-11-22 05:53:04.512986','5ee5b4c7-89c7-4cfa-891c-2d7bcd575182','5ee5b4c7-89c7-4cfa-891c-2d7bcd575182','tempest-tempest-manila-653606003',1,'Description for share type'),('2025-11-22 05:52:37.217328',NULL,'2025-11-22 05:52:37.675959','5fe71c1c-2e20-49fe-bfce-5d7d818c49e8','5fe71c1c-2e20-49fe-bfce-5d7d818c49e8','tempest-typeshare-type-227565930',1,NULL),('2025-11-22 05:52:30.194886',NULL,'2025-11-22 05:52:42.011285','603187a6-cda6-47ce-835c-b276acaf653c','603187a6-cda6-47ce-835c-b276acaf653c','tempest-typeshare-type-1007062823',1,NULL),('2025-11-22 05:56:00.163901',NULL,'2025-11-22 05:56:02.138968','61170f9a-c7ac-4b87-b413-c54777d961f1','61170f9a-c7ac-4b87-b413-c54777d961f1','tempest-typeshare-type-849961515',1,NULL),('2025-11-22 05:52:33.079767',NULL,'2025-11-22 05:52:39.864299','6202d096-e814-457f-8daa-c3670b08f4a8','6202d096-e814-457f-8daa-c3670b08f4a8','tempest-typeshare-type-1345822181',1,NULL),('2025-11-22 05:52:34.361082',NULL,'2025-11-22 05:52:39.107495','62759468-8bc6-4bd5-8aeb-6935ba6bff11','62759468-8bc6-4bd5-8aeb-6935ba6bff11','tempest-typeshare-type-233550041',1,NULL),('2025-11-22 05:56:33.919498',NULL,'2025-11-22 05:56:51.061754','64c44c63-ca32-44df-83e7-0d5ad0ba1c02','64c44c63-ca32-44df-83e7-0d5ad0ba1c02','tempest-typeshare-type-544184760',1,NULL),('2025-11-22 05:58:44.258607',NULL,'2025-11-22 05:59:50.235122','6630451a-185f-4b7a-8306-f600314a71e1','6630451a-185f-4b7a-8306-f600314a71e1','tempest-typeshare-type-1789435889',1,NULL),('2025-11-22 05:56:43.967350',NULL,'2025-11-22 05:56:44.409377','665af06e-ea13-4cb3-bd51-d7acdcb3c679','665af06e-ea13-4cb3-bd51-d7acdcb3c679','tempest-support_some_azs_share_type-1543589610',1,NULL),('2025-11-22 05:54:43.265361',NULL,'2025-11-22 05:55:12.104758','69975aa8-2ab7-43ef-9ea3-bf3bb458d4bc','69975aa8-2ab7-43ef-9ea3-bf3bb458d4bc','tempest-share-type-209716407',1,NULL),('2025-11-22 05:51:44.773426',NULL,'2025-11-22 05:51:46.846681','69d77033-b403-482f-a76b-521f128bf2ff','69d77033-b403-482f-a76b-521f128bf2ff','tempest-typeshare-type-1232819335',1,NULL),('2025-11-22 05:54:48.165523',NULL,'2025-11-22 05:55:57.889300','6aa6c955-bb1a-4082-b637-96733e409710','6aa6c955-bb1a-4082-b637-96733e409710','tempest-typeshare-type-1717509188',1,NULL),('2025-11-22 05:54:19.863547',NULL,'2025-11-22 05:54:24.116457','6b0c406a-f035-4b37-b2d2-4c6ac06297ee','6b0c406a-f035-4b37-b2d2-4c6ac06297ee','tempest-share-type-1496959003',1,NULL),('2025-11-22 05:53:11.635396',NULL,'2025-11-22 05:53:13.518197','6e49142e-626b-42ba-ac4c-1cb61d4d8fdd','6e49142e-626b-42ba-ac4c-1cb61d4d8fdd','tempest-typeshare-type-1874795987',1,NULL),('2025-11-22 05:52:55.595388',NULL,'2025-11-22 05:53:03.779387','6f5ed99c-8cfb-4bc9-9469-15e1d7edec3a','6f5ed99c-8cfb-4bc9-9469-15e1d7edec3a','tempest-tempest-manila-1269524264',1,NULL),('2025-11-22 05:58:31.133778',NULL,'2025-11-22 05:58:33.411810','6fd6ec7f-3bec-440f-b4a3-1e22184e83a8','6fd6ec7f-3bec-440f-b4a3-1e22184e83a8','tempest-typeshare-type-242337611',1,NULL),('2025-11-22 05:50:53.219757',NULL,'2025-11-22 05:51:09.913670','72b75a26-0b62-433e-a838-9cd3b4b43b69','72b75a26-0b62-433e-a838-9cd3b4b43b69','tempest-typeshare-type-853322880',1,NULL),('2025-11-22 05:52:00.248413',NULL,'2025-11-22 05:52:23.555221','72fda760-d07e-4ff4-b88e-2511b31404ed','72fda760-d07e-4ff4-b88e-2511b31404ed','tempest-typeshare-type-1733023193',1,NULL),('2025-11-22 05:54:51.204103',NULL,'2025-11-22 05:55:11.857326','734709e5-5e22-4d51-b713-3988d1991371','734709e5-5e22-4d51-b713-3988d1991371','tempest-share-type-1983218220',1,NULL),('2025-11-22 05:55:40.520244',NULL,'2025-11-22 05:55:44.301759','74bdce4e-83c2-495d-939a-8e70e009df33','74bdce4e-83c2-495d-939a-8e70e009df33','tempest-typeshare-type-1726453559',1,NULL),('2025-11-22 05:53:12.948378',NULL,'2025-11-22 05:53:13.221989','7611f9d7-3a00-48ed-b161-ad70691170a4','7611f9d7-3a00-48ed-b161-ad70691170a4','tempest-tempest-manila-1475258618',0,NULL),('2025-11-22 05:51:37.628536',NULL,'2025-11-22 05:52:11.939757','76b8f610-7bd5-4886-9698-850dd629ddbd','76b8f610-7bd5-4886-9698-850dd629ddbd','tempest-typeshare-type-1677659303',1,NULL),('2025-11-22 05:51:23.397716',NULL,'2025-11-22 05:51:39.183822','77493a25-15f3-46a2-aa42-8cc60bfae5bd','77493a25-15f3-46a2-aa42-8cc60bfae5bd','tempest-typeshare-type-1552189719',0,NULL),('2025-11-22 05:58:31.833381',NULL,'2025-11-22 05:58:31.966223','789f2051-0dd9-4315-8ed4-6eca8fc94ab4','789f2051-0dd9-4315-8ed4-6eca8fc94ab4','tempest-support_any_az_share_type-603224978',1,NULL),('2025-11-22 05:56:40.061876',NULL,'2025-11-22 05:56:40.356609','799e3cdc-a9e1-4b19-a6ba-d66c9d3787dc','799e3cdc-a9e1-4b19-a6ba-d66c9d3787dc','tempest-az_share_type-1990027089',1,NULL),('2025-11-22 05:52:58.731170','2025-11-22 05:52:58.864047','2025-11-22 05:53:00.812004','7a558026-2393-46cb-ad66-ac4fa7c318c2','7a558026-2393-46cb-ad66-ac4fa7c318c2','tempest-tempest-manila-1847246473',1,'description_updated'),('2025-11-22 05:54:22.603336',NULL,'2025-11-22 05:54:23.181235','7adb754f-7a76-4a0b-81e5-9fac3b310170','7adb754f-7a76-4a0b-81e5-9fac3b310170','tempest-share-type-1920771663',1,NULL),('2025-11-22 05:56:43.408681',NULL,'2025-11-22 05:56:43.636098','7c9eb107-859d-4970-bac0-fe1e5f9f893d','7c9eb107-859d-4970-bac0-fe1e5f9f893d','tempest-support_any_az_share_type-1045319028',1,NULL),('2025-11-22 05:52:34.709193',NULL,'2025-11-22 05:52:38.808467','7e239560-e792-455e-a40d-21fa34c61f57','7e239560-e792-455e-a40d-21fa34c61f57','tempest-typeshare-type-1298789714',1,NULL),('2025-11-22 05:51:22.595773',NULL,'2025-11-22 05:51:39.323500','8233e672-6ffd-441b-82d4-d8cfa745ac62','8233e672-6ffd-441b-82d4-d8cfa745ac62','tempest-typeshare-type-283177299',1,NULL),('2025-11-22 05:51:44.221744',NULL,'2025-11-22 05:52:11.781587','83710f66-5331-429a-9190-c955e72a6981','83710f66-5331-429a-9190-c955e72a6981','tempest-typeshare-type-1030390793',1,NULL),('2025-11-22 05:52:51.722309',NULL,'2025-11-22 05:52:53.585810','8491cc75-c0ab-454f-b988-ba17b9d517fd','8491cc75-c0ab-454f-b988-ba17b9d517fd','tempest-share-type-1040198252',0,NULL),('2025-11-22 05:56:42.803806',NULL,'2025-11-22 05:56:42.980740','85cf8301-0cc9-4d6d-856e-f39f52e513ea','85cf8301-0cc9-4d6d-856e-f39f52e513ea','tempest-support_any_az_share_type-1269355041',1,NULL),('2025-11-22 05:52:31.483186',NULL,'2025-11-22 05:52:40.997735','872ad9b2-2ecd-430a-bd6d-62cc625427a9','872ad9b2-2ecd-430a-bd6d-62cc625427a9','tempest-typeshare-type-1423515578',1,NULL),('2025-11-22 05:57:41.224864',NULL,'2025-11-22 05:57:43.927160','8890da9c-5419-40fe-9500-71ebafb39efd','8890da9c-5419-40fe-9500-71ebafb39efd','tempest-typeshare-type-128476697',1,NULL),('2025-11-22 05:52:55.205349',NULL,'2025-11-22 05:53:04.241870','88e43784-8c63-49fb-ac73-2cce89b82e39','88e43784-8c63-49fb-ac73-2cce89b82e39','tempest-tempest-manila-651638644',1,NULL),('2025-11-22 05:52:59.676291','2025-11-22 05:52:59.778006','2025-11-22 05:52:59.878462','8b217c05-7915-4d29-8796-7eef50875e3b','8b217c05-7915-4d29-8796-7eef50875e3b','tempest-tempest-manila-1636584682',1,NULL),('2025-11-22 05:52:55.939898',NULL,'2025-11-22 05:53:03.402226','8d56291d-4678-46e8-adf2-b16c7018d3ac','8d56291d-4678-46e8-adf2-b16c7018d3ac','tempest-tempest-manila-108003648',1,'Description for share type'),('2025-11-22 05:51:56.548180',NULL,'2025-11-22 05:51:58.638310','8f79b927-98c1-4e61-a9f8-e94b57ede2c6','8f79b927-98c1-4e61-a9f8-e94b57ede2c6','tempest-typeshare-type-541133398',1,NULL),('2025-11-22 05:51:50.832313',NULL,'2025-11-22 05:52:00.250913','8fd11717-20ba-4169-9684-c338bfd7f478','8fd11717-20ba-4169-9684-c338bfd7f478','tempest-typeshare-type-2078616030',1,NULL),('2025-11-22 05:51:44.974203',NULL,'2025-11-22 05:51:46.708972','9044cf35-08fa-4f88-91bc-a4664783acf4','9044cf35-08fa-4f88-91bc-a4664783acf4','tempest-typeshare-type-1758747064',1,NULL),('2025-11-22 05:52:36.564736',NULL,'2025-11-22 05:52:38.108507','927e539e-96c1-46dd-81c8-cdb5f7e1f6e9','927e539e-96c1-46dd-81c8-cdb5f7e1f6e9','tempest-typeshare-type-414431583',1,NULL),('2025-11-22 05:52:54.915605',NULL,'2025-11-22 05:53:04.813235','9417ee22-b9f6-4797-89cd-39fd5abe9135','9417ee22-b9f6-4797-89cd-39fd5abe9135','tempest-tempest-manila-2129669424',1,NULL),('2025-11-22 05:51:07.340875',NULL,'2025-11-22 05:51:08.490876','95e8259f-6244-4173-8b6e-60866827a197','95e8259f-6244-4173-8b6e-60866827a197','tempest-share-type-755248108',1,NULL),('2025-11-22 05:55:07.313588',NULL,'2025-11-22 05:55:11.205171','96afc477-3877-4b27-b4cf-f6aaa221d409','96afc477-3877-4b27-b4cf-f6aaa221d409','tempest-share-type-131200069',1,NULL),('2025-11-22 05:52:32.892729',NULL,'2025-11-22 05:52:40.058873','9a1ef266-310d-46ad-87d6-30ddf4baf4cf','9a1ef266-310d-46ad-87d6-30ddf4baf4cf','tempest-typeshare-type-173622676',1,NULL),('2025-11-22 05:51:32.041822',NULL,'2025-11-22 05:51:38.405865','9bbba06e-c405-4b53-8876-3be72e9dbdf8','9bbba06e-c405-4b53-8876-3be72e9dbdf8','tempest-typeshare-type-1817136746',1,NULL),('2025-11-22 05:52:24.186866',NULL,'2025-11-22 05:52:33.089663','a2eae7d4-7042-401a-973a-249989b912a4','a2eae7d4-7042-401a-973a-249989b912a4','tempest-typeshare-type-228812199',1,NULL),('2025-11-22 05:54:14.530330',NULL,'2025-11-22 05:54:38.147213','a4dd46bb-4dd9-48bd-92ee-1a6f0e9dbfe6','a4dd46bb-4dd9-48bd-92ee-1a6f0e9dbfe6','tempest-typeshare-type-1896598794',1,NULL),('2025-11-22 05:53:57.519976',NULL,'2025-11-22 05:54:12.595919','a5b83cc3-3a22-4b5e-9258-2ea0c4739722','a5b83cc3-3a22-4b5e-9258-2ea0c4739722','tempest-typeshare-type-1195419378',1,NULL),('2025-11-22 05:52:35.134371',NULL,'2025-11-22 05:52:38.678552','a7c8e66d-1f58-4b5b-9f44-e43a526fd141','a7c8e66d-1f58-4b5b-9f44-e43a526fd141','tempest-typeshare-type-1780028057',1,NULL),('2025-11-22 05:52:52.531494',NULL,'2025-11-22 05:52:53.450029','ab671b11-b220-418f-8a6d-51180eb8ab69','ab671b11-b220-418f-8a6d-51180eb8ab69','tempest-typeshare-type-889703415',1,NULL),('2025-11-22 05:50:49.151507',NULL,'2025-11-22 05:52:26.407011','ae29560b-3995-49db-8651-d9dca4b5c54c','ae29560b-3995-49db-8651-d9dca4b5c54c','tempest-typeshare-type-435806288',1,NULL),('2025-11-22 05:51:29.313135',NULL,'2025-11-22 05:51:38.766141','b04f0ad5-a570-45a6-9168-54f1a3291141','b04f0ad5-a570-45a6-9168-54f1a3291141','tempest-typeshare-type-1319945608',1,NULL),('2025-11-22 05:51:44.563868',NULL,'2025-11-22 05:51:46.986191','b4dd835c-50ee-4d3d-9b5b-d5dc61928de6','b4dd835c-50ee-4d3d-9b5b-d5dc61928de6','tempest-typeshare-type-17596649',1,NULL),('2025-11-22 05:52:52.802010',NULL,'2025-11-22 05:52:53.293383','b4f0d32e-d735-4f82-b317-f51cfe7581fe','b4f0d32e-d735-4f82-b317-f51cfe7581fe','tempest-typeshare-type-1879882280',1,NULL),('2025-11-22 05:52:56.170727',NULL,'2025-11-22 05:53:03.235771','b684b7a7-b5b7-4b71-98ab-2075c7e194d9','b684b7a7-b5b7-4b71-98ab-2075c7e194d9','tempest-tempest-manila-1325317817',1,NULL),('2025-11-22 05:56:44.578553',NULL,'2025-11-22 05:56:45.026309','b69c42d9-b167-44ae-9b10-c198e5722678','b69c42d9-b167-44ae-9b10-c198e5722678','tempest-support_some_azs_share_type-85311079',1,NULL),('2025-11-22 05:54:59.705934',NULL,'2025-11-22 05:55:11.601493','b9bcbdc8-5a4b-450b-a372-7a3b2f4ae1ab','b9bcbdc8-5a4b-450b-a372-7a3b2f4ae1ab','tempest-share-type-1922194115',1,NULL),('2025-11-22 05:51:23.537137',NULL,'2025-11-22 05:51:35.920372','ba0277e3-3973-4052-b400-a5c0085d5c63','ba0277e3-3973-4052-b400-a5c0085d5c63','tempest-share-type-453665554',1,NULL),('2025-11-22 05:52:58.303827','2025-11-22 05:52:58.452031','2025-11-22 05:53:01.501037','bb635c61-397b-4df9-82f9-f01996cca1da','bb635c61-397b-4df9-82f9-f01996cca1da','tempest-type_updated-993496009',1,'description_updated'),('2025-11-22 05:56:14.340788',NULL,'2025-11-22 05:56:22.826393','bc148b41-c4b4-450d-9fb4-e61454af1efe','bc148b41-c4b4-450d-9fb4-e61454af1efe','tempest-typeshare-type-1631023322',1,NULL),('2025-11-22 05:56:25.725539',NULL,'2025-11-22 05:57:37.786575','bc6cfada-cc8c-44a7-8599-cc459a4ac116','bc6cfada-cc8c-44a7-8599-cc459a4ac116','tempest-typeshare-type-1098013889',1,NULL),('2025-11-22 05:51:51.287974',NULL,'2025-11-22 05:52:00.094635','bf52b356-0305-440f-896e-3f5f94c2e6d8','bf52b356-0305-440f-896e-3f5f94c2e6d8','tempest-typeshare-type-278409591',1,NULL),('2025-11-22 05:58:55.102609',NULL,'2025-11-22 05:58:57.524420','c12abeeb-9ad3-45f8-8565-bc934c59ab9b','c12abeeb-9ad3-45f8-8565-bc934c59ab9b','tempest-typeshare-type-96988242',1,NULL),('2025-11-22 05:51:55.227896',NULL,'2025-11-22 05:51:59.091524','c893e52e-491a-418b-927a-7a29d16cb0a2','c893e52e-491a-418b-927a-7a29d16cb0a2','tempest-typeshare-type-673715894',1,NULL),('2025-11-22 05:54:21.917729',NULL,'2025-11-22 05:54:23.382577','cad45d55-537a-476b-8bcb-07992c2d9a0f','cad45d55-537a-476b-8bcb-07992c2d9a0f','tempest-share-type-1456031481',1,NULL),('2025-11-22 05:52:36.262097',NULL,'2025-11-22 05:52:38.401612','cb072283-9f02-4dc5-a0f8-fec20e9fdef2','cb072283-9f02-4dc5-a0f8-fec20e9fdef2','tempest-typeshare-type-1162812978',1,NULL),('2025-11-22 05:54:31.502917',NULL,'2025-11-22 05:55:12.496664','ce3f0727-d1a8-4676-a5dc-450c47e136e8','ce3f0727-d1a8-4676-a5dc-450c47e136e8','tempest-share-type-475105101',1,NULL),('2025-11-22 05:53:12.365363',NULL,'2025-11-22 05:53:12.719345','cf1fca7b-b814-45dd-891c-8e87f476c40f','cf1fca7b-b814-45dd-891c-8e87f476c40f','tempest-tempest-manila-514469482',1,NULL),('2025-11-22 05:54:20.251594',NULL,'2025-11-22 05:54:23.738075','cfc7af5e-d0a1-4db0-a5e2-eb81cb1b5212','cfc7af5e-d0a1-4db0-a5e2-eb81cb1b5212','tempest-share-type-1731180648',1,NULL),('2025-11-22 05:58:25.265193',NULL,'2025-11-22 05:58:58.898715','cfea797e-06da-4537-b54d-22f274a0b710','cfea797e-06da-4537-b54d-22f274a0b710','tempest-typeshare-type-344646003',1,NULL),('2025-11-22 05:52:35.451485',NULL,'2025-11-22 05:52:45.121231','d4fe4178-7457-4c27-b05c-d200652bfa09','d4fe4178-7457-4c27-b05c-d200652bfa09','tempest-typeshare-type-633845048',1,NULL),('2025-11-22 05:57:53.499945',NULL,'2025-11-22 05:58:45.634064','d59519d5-a66d-4c06-a170-dbc2876b25c1','d59519d5-a66d-4c06-a170-dbc2876b25c1','tempest-typeshare-type-131374444',1,NULL),('2025-11-22 05:51:19.655634',NULL,'2025-11-22 05:51:36.068146','d6624012-6e58-49fd-92c2-41fff579b962','d6624012-6e58-49fd-92c2-41fff579b962','tempest-share-type-6411002',1,NULL),('2025-11-22 05:56:31.335323',NULL,'2025-11-22 05:56:33.351427','d99c4e9d-6f6b-41d5-a5ff-4aa88f590db4','d99c4e9d-6f6b-41d5-a5ff-4aa88f590db4','tempest-typeshare-type-558413281',1,NULL),('2025-11-22 05:57:41.390039',NULL,'2025-11-22 05:57:43.755296','d99e0d35-abd1-459c-a4f3-a968684a65c8','d99e0d35-abd1-459c-a4f3-a968684a65c8','tempest-typeshare-type-1404620657',1,NULL),('2025-11-22 05:56:42.720501',NULL,'2025-11-22 05:56:43.149741','daf1ea78-d498-4294-b391-0fd9f00b8dbe','daf1ea78-d498-4294-b391-0fd9f00b8dbe','tempest-support_some_azs_share_type-1254379864',1,NULL),('2025-11-22 05:55:47.632299',NULL,'2025-11-22 05:55:51.373741','dc878306-a1ad-4669-810b-2240d01da5dd','dc878306-a1ad-4669-810b-2240d01da5dd','tempest-typeshare-type-266939622',1,NULL),('2025-11-22 05:54:35.680591',NULL,'2025-11-22 05:55:12.371203','dcc3507b-971d-43d8-92d2-0d2d0d8c3319','dcc3507b-971d-43d8-92d2-0d2d0d8c3319','tempest-share-type-1877142265',1,NULL),('2025-11-22 05:55:04.133809',NULL,'2025-11-22 05:55:12.333871','e3483182-8b2a-4128-9f1a-b73d4873cc06','e3483182-8b2a-4128-9f1a-b73d4873cc06','tempest-typeshare-type-1048917834',1,NULL),('2025-11-22 05:57:27.751054',NULL,'2025-11-22 05:58:17.470829','e92e4c96-7852-4844-a49a-2fed8941ce22','e92e4c96-7852-4844-a49a-2fed8941ce22','tempest-typeshare-type-1058499900',1,NULL),('2025-11-22 05:51:52.539150',NULL,'2025-11-22 05:51:59.575676','eb23f0c5-9f94-46c8-843b-a3d9252db2c9','eb23f0c5-9f94-46c8-843b-a3d9252db2c9','tempest-typeshare-type-379821077',1,NULL),('2025-11-22 05:56:39.606866',NULL,'2025-11-22 05:56:39.835038','ebaa9ed0-76f9-47f9-9711-c3282af3b9bd','ebaa9ed0-76f9-47f9-9711-c3282af3b9bd','tempest-az_share_type-1419698194',1,NULL),('2025-11-22 05:52:58.101555','2025-11-22 05:52:58.228036','2025-11-22 05:53:01.694395','ed0b85e7-1d3e-4221-9594-2660c7b1b5b9','ed0b85e7-1d3e-4221-9594-2660c7b1b5b9','tempest-tempest-manila-628173629',0,'Description for share type'),('2025-11-22 05:52:33.814379',NULL,'2025-11-22 05:52:39.559034','edfc69e5-46d1-43d5-b47d-d794743aa0f1','edfc69e5-46d1-43d5-b47d-d794743aa0f1','tempest-typeshare-type-40181942',1,NULL),('2025-11-22 05:51:45.633060',NULL,'2025-11-22 05:51:45.839513','eeb9e6f3-5b8f-4400-9dd6-a80d3e877ad0','eeb9e6f3-5b8f-4400-9dd6-a80d3e877ad0','tempest-unique_st_name-1983990590',1,NULL),('2025-11-22 05:52:54.583991',NULL,'2025-11-22 05:53:05.253839','f01c2e8a-eb88-4741-a87a-8a5a5320797f','f01c2e8a-eb88-4741-a87a-8a5a5320797f','tempest-tempest-manila-573504783',1,NULL),('2025-11-22 05:52:35.870377',NULL,'2025-11-22 05:52:38.542566','f30f5b98-5f4f-4060-bc6c-623eace78e2c','f30f5b98-5f4f-4060-bc6c-623eace78e2c','tempest-typeshare-type-1627478006',1,NULL),('2025-11-22 05:55:03.182717',NULL,'2025-11-22 05:55:11.392547','f359449b-fe9e-4653-86a0-8fec8f992613','f359449b-fe9e-4653-86a0-8fec8f992613','tempest-share-type-1828858551',1,NULL),('2025-11-22 05:51:05.721200',NULL,'2025-11-22 05:51:39.994298','f3cd9bee-b210-4ae4-816a-bb8ba92391c9','f3cd9bee-b210-4ae4-816a-bb8ba92391c9','tempest-typeshare-type-474107391',1,NULL),('2025-11-22 05:52:34.173390',NULL,'2025-11-22 05:52:39.395480','f3fe8eeb-698d-46b7-8a6a-75d5c1be73de','f3fe8eeb-698d-46b7-8a6a-75d5c1be73de','tempest-typeshare-type-681071615',1,NULL),('2025-11-22 05:52:57.894644','2025-11-22 05:52:57.958954','2025-11-22 05:53:01.981081','f4b57031-c863-462d-b0df-3dbcc781ddd6','f4b57031-c863-462d-b0df-3dbcc781ddd6','tempest-tempest-manila-1683132615',1,'Description for share type'),('2025-11-22 05:52:46.569684',NULL,'2025-11-22 05:52:55.812982','f5058f8f-6143-4b6d-8d20-02b50ffa22a6','f5058f8f-6143-4b6d-8d20-02b50ffa22a6','tempest-typeshare-type-1653360922',1,NULL),('2025-11-22 05:52:57.651983','2025-11-22 05:52:57.729008','2025-11-22 05:53:02.261662','f803ee57-6fed-4472-a724-f97c7489848f','f803ee57-6fed-4472-a724-f97c7489848f','tempest-tempest-manila-983311229',1,'description_updated'),('2025-11-22 05:51:57.841746',NULL,'2025-11-22 05:51:58.216462','f80cf8b4-5907-4fa2-84be-22615363ecca','f80cf8b4-5907-4fa2-84be-22615363ecca','tempest-typeshare-type-2080508570',1,NULL),('2025-11-22 05:56:41.482530',NULL,'2025-11-22 05:56:41.661524','f821d7e7-5b91-486d-ac54-52650a9f6f42','f821d7e7-5b91-486d-ac54-52650a9f6f42','tempest-support_any_az_share_type-797814975',1,NULL),('2025-11-22 05:52:59.400467','2025-11-22 05:52:59.589027','2025-11-22 05:53:00.041365','fa6930af-2185-464e-a571-758926335181','fa6930af-2185-464e-a571-758926335181','tempest-tempest-manila-1216688890',1,NULL),('2025-11-22 05:56:41.926390',NULL,'2025-11-22 05:56:42.564120','fc98bae2-5025-4ab9-b9a1-d9d2694cba6e','fc98bae2-5025-4ab9-b9a1-d9d2694cba6e','tempest-support_some_azs_share_type-1601027414',1,NULL),('2025-11-22 05:51:44.385729',NULL,'2025-11-22 05:51:47.130341','feebd432-84a2-4e7f-a3ae-e490288352c9','feebd432-84a2-4e7f-a3ae-e490288352c9','tempest-typeshare-type-587392644',1,NULL);
/*!40000 ALTER TABLE `share_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shares`
--

DROP TABLE IF EXISTS `shares`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `shares` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `share_proto` varchar(255) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `snapshot_support` tinyint(1) DEFAULT NULL,
  `share_group_id` varchar(36) DEFAULT NULL,
  `source_share_group_snapshot_member_id` varchar(36) DEFAULT NULL,
  `task_state` varchar(255) DEFAULT NULL,
  `replication_type` varchar(255) DEFAULT NULL,
  `create_share_from_snapshot_support` tinyint(1) DEFAULT NULL,
  `revert_to_snapshot_support` tinyint(1) DEFAULT NULL,
  `mount_snapshot_support` tinyint(1) DEFAULT NULL,
  `is_soft_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `scheduled_to_be_deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_shares_share_group_id` (`share_group_id`),
  CONSTRAINT `fk_shares_share_group_id` FOREIGN KEY (`share_group_id`) REFERENCES `share_groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shares`
--

LOCK TABLES `shares` WRITE;
/*!40000 ALTER TABLE `shares` DISABLE KEYS */;
INSERT INTO `shares` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `size`, `display_name`, `display_description`, `snapshot_id`, `share_proto`, `is_public`, `snapshot_support`, `share_group_id`, `source_share_group_snapshot_member_id`, `task_state`, `replication_type`, `create_share_from_snapshot_support`, `revert_to_snapshot_support`, `mount_snapshot_support`, `is_soft_deleted`, `scheduled_to_be_deleted_at`) VALUES ('2025-11-22 05:55:28.123220','2025-11-22 05:55:43.773035','2025-11-22 05:55:43.772601','06610748-6de1-49ce-9a00-b0cc5a383015','06610748-6de1-49ce-9a00-b0cc5a383015','47d35dbda65c4554a9466657dad531d9','7c0b4b3107784ce6890ddd12d362ec8e',1,'tempest-tempest-created-share-1590646868','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:50:54.033037','2025-11-22 05:50:59.415950','2025-11-22 05:50:59.415653','0cfaf80f-3065-460f-a44d-408b8b49e173','0cfaf80f-3065-460f-a44d-408b8b49e173','3ca1144a55894a528a97f0906826d387','1d43ad7bfa6f468cb936112ef76b83ec',2,'tempest-tempest-created-share-53624678','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:51:23.703370','2025-11-22 05:51:27.403528','2025-11-22 05:51:27.402688','0e4c9edf-33f0-4fb6-9de3-585d7dfa83c7','0e4c9edf-33f0-4fb6-9de3-585d7dfa83c7','3a798de8dc964838b12715c65c83b403','9a040dac65f744c687d2d5814d775f6c',1,'tempest-tempest-created-share-346167031','tempest-tempest-created-share-desc-1992795829',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:58:29.735206','2025-11-22 05:58:34.516041','2025-11-22 05:58:34.515105','147e8495-aef5-40a9-9e0b-11a0a21056a1','147e8495-aef5-40a9-9e0b-11a0a21056a1','4cb3f9c4072c4e558f4e89dc3002ce2d','1304502ff2bf4fc2bce849d08526f92d',1,'tempest-tempest-created-share-846170115','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:53:21.024241','2025-11-22 05:53:29.949245','2025-11-22 05:53:29.948987','19dc7213-05d0-44ba-8191-d795ad527b71','19dc7213-05d0-44ba-8191-d795ad527b71','9b5bfcdf5ad54171a9698feaa812530a','acb08ef912784bb89000a87c4621bcc9',1,'tempest-tempest-created-share-527771165','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:54:51.369863','2025-11-22 05:54:59.273047','2025-11-22 05:54:59.272675','1fac7a35-09cc-4c47-873e-f63ac427a11e','1fac7a35-09cc-4c47-873e-f63ac427a11e','a118fe67fdb84bd1bef3675de0af7cc1','c1bb25e73f4845c0aa83279619d6c189',1,'tempest-tempest-created-share-1223792254','tempest-tempest-created-share-desc-1086639824',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:58:25.458318','2025-11-22 05:58:37.182292','2025-11-22 05:58:37.181849','2181b348-c082-45ec-ab33-041e5328f0c9','2181b348-c082-45ec-ab33-041e5328f0c9','120367c7d9ec45569159d69c691c775d','57cc59807cc747c6849cfa0c21089689',2,'tempest-tempest-created-share-1104311623','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-22 05:58:14.641576','2025-11-22 05:58:18.836189','2025-11-22 05:58:18.835799','25902542-4afd-4494-91f3-1388b0c6aecb','25902542-4afd-4494-91f3-1388b0c6aecb','4cb3f9c4072c4e558f4e89dc3002ce2d','1304502ff2bf4fc2bce849d08526f92d',1,'tempest-tempest-created-share-2025096986','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:54:39.692513','2025-11-22 05:54:45.503644','2025-11-22 05:54:45.503137','2d84ba4d-c3d7-42b6-ab7f-d9b35fae6828','2d84ba4d-c3d7-42b6-ab7f-d9b35fae6828','5cd2161e545848cab1c577034bff12ab','ff09e2486e9d4c72b3f5e832bcf1885a',1,'tempest-tempest-created-share-1621951793','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:57:09.088126','2025-11-22 05:57:21.830162','2025-11-22 05:57:21.829714','3d52ca5b-a434-47f0-a9bc-5e058cdeadc4','3d52ca5b-a434-47f0-a9bc-5e058cdeadc4','57c41b494bbf4fa981ed6b0fa212fa71','3ecbc36cc7f84bac8557dd18782914fa',1,'tempest-tempest-share-name-149339462','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:51:42.180049','2025-11-22 05:52:05.412813','2025-11-22 05:52:05.412281','3f35616a-a117-49b4-9a27-e63f99a9bdc4','3f35616a-a117-49b4-9a27-e63f99a9bdc4','19063b71466b4a099f4798ea400aed7c','fffa744c2146473ab31df119246a9181',1,'tempest-tempest-created-share-535458211','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:54:43.432042','2025-11-22 05:54:47.132755','2025-11-22 05:54:47.132375','3fbb9374-949b-4b92-bd96-bf00b070b292','3fbb9374-949b-4b92-bd96-bf00b070b292','a118fe67fdb84bd1bef3675de0af7cc1','c1bb25e73f4845c0aa83279619d6c189',1,'tempest-tempest-created-share-929808690','tempest-tempest-created-share-desc-1691819521',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:57:13.207011','2025-11-22 05:57:18.175139','2025-11-22 05:57:18.174587','454c896f-ee5c-43cc-af2b-3cf311c7ba49','454c896f-ee5c-43cc-af2b-3cf311c7ba49','57c41b494bbf4fa981ed6b0fa212fa71','3ecbc36cc7f84bac8557dd18782914fa',1,'tempest-tempest-share-name-1249159114','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:55:04.241779','2025-11-22 05:55:09.322175','2025-11-22 05:55:09.321809','47b40d49-baff-45d8-8c77-f762454c8623','47b40d49-baff-45d8-8c77-f762454c8623','26ca92a37d7d41e58904a26944c79e14','8b69dc8609b24a13bee8bd080785898b',1,'public_share','public_share_desc',NULL,'CEPHFS',1,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:51:44.445455','2025-11-22 05:52:09.401070','2025-11-22 05:52:09.400590','4967e6e3-b2cc-45b4-b463-17f7bce6ae8e','4967e6e3-b2cc-45b4-b463-17f7bce6ae8e','825bdf0dbbba49b38e9e122e772e6b7b','1218c5e5dd6949df8f550c000dc3c24e',1,'tempest-tempest-created-share-119177607','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:52:35.736627','2025-11-22 05:52:41.806289','2025-11-22 05:52:41.805790','49fe7532-02b6-4da3-9369-3026c6bddc7a','49fe7532-02b6-4da3-9369-3026c6bddc7a','625f00565232408d9cf383ec8a96edab','a4d13c902935400e9d74b443a3eb1e97',1,'tempest-tempest-created-share-869586680','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:58:40.358911','2025-11-22 05:58:57.521604','2025-11-22 05:58:57.521143','4aae7a32-bf67-4f73-bf74-19367ee159cf','4aae7a32-bf67-4f73-bf74-19367ee159cf','120367c7d9ec45569159d69c691c775d','57cc59807cc747c6849cfa0c21089689',1,'tempest-tempest-created-share-1241666407','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-22 05:51:13.729584','2025-11-22 05:51:18.041374','2025-11-22 05:51:18.040926','4ad36ae6-9cd6-4471-b6a3-c5688ef1f23f','4ad36ae6-9cd6-4471-b6a3-c5688ef1f23f','3ca1144a55894a528a97f0906826d387','1d43ad7bfa6f468cb936112ef76b83ec',1,'tempest-tempest-created-share-893625217','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:54:39.914023','2025-11-22 05:54:47.468837','2025-11-22 05:54:47.468535','4e22476f-a1eb-4f31-841d-b0a5e59503e4','4e22476f-a1eb-4f31-841d-b0a5e59503e4','a118fe67fdb84bd1bef3675de0af7cc1','c1bb25e73f4845c0aa83279619d6c189',1,'tempest-tempest-created-share-1739441689','tempest-tempest-created-share-desc-108502100',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:54:59.839408','2025-11-22 05:55:07.216481','2025-11-22 05:55:07.216139','4ebcd134-e7f8-49d6-a2f6-435caceb7e8b','4ebcd134-e7f8-49d6-a2f6-435caceb7e8b','a118fe67fdb84bd1bef3675de0af7cc1','c1bb25e73f4845c0aa83279619d6c189',1,'tempest-tempest-created-share-1573741896','tempest-tempest-created-share-desc-853327359',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:52:46.684869','2025-11-22 05:52:52.714636','2025-11-22 05:52:52.714350','50e9c087-b3da-4d49-8759-fa6cdcb53af9','50e9c087-b3da-4d49-8759-fa6cdcb53af9','7b35a5763e3a490b90ea39b5f4299609','0e8baa99d2a34ced8e95c9d3736c9dcd',1,'tempest-tempest-created-share-1941341286','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:59:59.382331','2025-11-22 06:00:12.169511','2025-11-22 06:00:12.169064','511ae11a-c61d-4a3c-97ca-4eb2a5c1ee1a','511ae11a-c61d-4a3c-97ca-4eb2a5c1ee1a','a1a7cc23204c4cc98f8e932daf5aa165','39cd34e3d99d4413afb1c277d92dcf8f',1,'tempest-tempest-new-name-1101434013','tempest-tempest-new-description-228186089',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:56:31.909293','2025-11-22 05:56:39.706718','2025-11-22 05:56:39.705752','535805ac-c11f-4da9-b23b-e9f0311f7416','535805ac-c11f-4da9-b23b-e9f0311f7416','58186e0ac2da4d539ba489a92270cb59','db75a1944ad845ea9c7d9708d52f1e25',1,'tempest-tempest-created-share-619627192','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:57:59.923767','2025-11-22 05:58:11.849591','2025-11-22 05:58:11.849226','59d2283f-fd13-4d0c-acda-f2c67d1bc088','59d2283f-fd13-4d0c-acda-f2c67d1bc088','85b06cd64746426188d69928ccf28eb0','fab76ed5d22a49d0be1474f6fe848948',1,'tempest-tempest-created-share-222582078','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:50:53.586734','2025-11-22 05:51:06.736939','2025-11-22 05:51:06.736455','5bffd633-0c47-447b-981e-f37827cac197','5bffd633-0c47-447b-981e-f37827cac197','9395a53526744acc85a47d28e0d28556','9ece7a8ade98405884af4e066937cac2',1,'tempest-tempest-created-share-101277355','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:53:38.264011','2025-11-22 05:53:45.685312','2025-11-22 05:53:45.684858','5dc5dd92-1904-4853-8e49-7d3d2ef9af9d','5dc5dd92-1904-4853-8e49-7d3d2ef9af9d','9b5bfcdf5ad54171a9698feaa812530a','acb08ef912784bb89000a87c4621bcc9',1,'tempest-tempest-created-share-1901121219','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:57:11.750133','2025-11-22 05:57:15.589096','2025-11-22 05:57:15.588720','5ee936c0-72b4-469f-a052-0c7dc93a880f','5ee936c0-72b4-469f-a052-0c7dc93a880f','c2522b58eb254cf58002dcb519ab137d','f0fc42a3cd4a4e75942e7132887f268d',1,'tempest-tempest-created-share-682324638','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:51:27.672433','2025-11-22 05:51:31.321243','2025-11-22 05:51:31.320897','63401021-32bf-4f9e-abf0-806c9549b2d3','63401021-32bf-4f9e-abf0-806c9549b2d3','3a798de8dc964838b12715c65c83b403','9a040dac65f744c687d2d5814d775f6c',1,'tempest-tempest-created-share-1409480793','tempest-tempest-created-share-desc-121749658',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:55:52.674100',NULL,NULL,'False','6421908b-395a-471b-82f0-f6641bffe29d','ea75f7805c74403093c0bd716bebcc3e','94bcd246264e4a03b75056b04f28dee8',1,'tempest-tempest-created-share-1582932837','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:54:29.931246','2025-11-22 05:54:34.427421','2025-11-22 05:54:34.426965','6634bb0b-8adf-429e-9684-537da874f36d','6634bb0b-8adf-429e-9684-537da874f36d','2256793bd84244a3bcb61874a41075c5','879b9840974d4a5186ae02687052f6dc',1,'tempest-tempest-new-share-name-836410880','share is now updated',NULL,'CEPHFS',1,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:58:48.921505','2025-11-22 05:59:40.265284','2025-11-22 05:59:40.264919','66ad6cfd-e916-46a6-bd0a-171cccdc89bc','66ad6cfd-e916-46a6-bd0a-171cccdc89bc','3db9dedf9593479bbad4287d9e10a4d5','1e3df68b14c64c2eba82d76467788260',1,'tempest-tempest-share-name-908384807','tempest-tempest-share-description-1032186460','7cb6a540-aa78-41e5-b112-51878416b681','CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-22 05:52:49.212401','2025-11-22 05:53:06.409558','2025-11-22 05:53:06.409177','6a28629c-ec25-4d9e-89ce-28477e9b25bb','6a28629c-ec25-4d9e-89ce-28477e9b25bb','4de5adb2861b4b3fbe992445b625cad4','c3e25870be384f238bccdf6c103762a8',1,'tempest-share-213727445','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:51:15.689816','2025-11-22 05:51:19.488314','2025-11-22 05:51:19.487761','6a899e7f-5787-4b0b-81cc-6279b40ff3cf','6a899e7f-5787-4b0b-81cc-6279b40ff3cf','3a798de8dc964838b12715c65c83b403','9a040dac65f744c687d2d5814d775f6c',1,'tempest-tempest-created-share-640142285','tempest-tempest-created-share-desc-4060995',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:53:30.831097','2025-11-22 05:53:35.164894','2025-11-22 05:53:35.164406','7369001b-8b56-4f95-95a7-cdaf74673b72','7369001b-8b56-4f95-95a7-cdaf74673b72','9b5bfcdf5ad54171a9698feaa812530a','acb08ef912784bb89000a87c4621bcc9',1,'tempest-tempest-created-share-378840839','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:55:03.316757','2025-11-22 05:55:07.018026','2025-11-22 05:55:07.017744','73cf6a38-fffe-415b-bd26-1bc690525347','73cf6a38-fffe-415b-bd26-1bc690525347','a118fe67fdb84bd1bef3675de0af7cc1','c1bb25e73f4845c0aa83279619d6c189',1,'tempest-tempest-created-share-1063737029','tempest-tempest-created-share-desc-566304736',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:57:04.578506','2025-11-22 05:57:08.527938','2025-11-22 05:57:08.527213','765683c0-4613-45c1-8ada-72642ad67577','765683c0-4613-45c1-8ada-72642ad67577','c2522b58eb254cf58002dcb519ab137d','f0fc42a3cd4a4e75942e7132887f268d',1,'tempest-tempest-created-share-1169750199','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:57:59.556472','2025-11-22 05:58:03.756702','2025-11-22 05:58:03.756310','7fa27812-115e-40eb-9f44-8d109734f95e','7fa27812-115e-40eb-9f44-8d109734f95e','4cb3f9c4072c4e558f4e89dc3002ce2d','1304502ff2bf4fc2bce849d08526f92d',1,'tempest-tempest-created-share-564435226','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:56:26.017864','2025-11-22 05:57:34.491332','2025-11-22 05:57:34.490600','82f5a7b8-b11a-4b98-ac40-9540006a2619','82f5a7b8-b11a-4b98-ac40-9540006a2619','58186e0ac2da4d539ba489a92270cb59','db75a1944ad845ea9c7d9708d52f1e25',1,'tempest-tempest-created-share-283804147','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:56:34.154080','2025-11-22 05:56:39.147673','2025-11-22 05:56:39.147309','85231eff-df4a-437f-b115-e47d4632d59f','85231eff-df4a-437f-b115-e47d4632d59f','4f5c8a8f5caa48388ab293352413b72b','0cb5c96c52bc4e89961346306e373479',1,'tempest-tempest-share-name-2042391659','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:56:42.604293','2025-11-22 05:56:50.482589','2025-11-22 05:56:50.482222','8c4d1c7d-bcbe-428a-add3-a107e25e1608','8c4d1c7d-bcbe-428a-add3-a107e25e1608','58186e0ac2da4d539ba489a92270cb59','db75a1944ad845ea9c7d9708d52f1e25',1,'tempest-tempest-created-share-2052876778','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:52:45.800028','2025-11-22 05:56:12.326146','2025-11-22 05:56:12.325626','8efd43bb-f9b3-4447-86c4-e3920bc619c4','8efd43bb-f9b3-4447-86c4-e3920bc619c4','9088ff75a27c420ca8f0a42460400887','94bcd246264e4a03b75056b04f28dee8',1,'tempest-tempest-created-share-1444789363','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:57:53.799791','2025-11-22 05:58:42.421330','2025-11-22 05:58:42.420998','8fc96ffe-58ec-4a01-9152-6a45bed340d3','8fc96ffe-58ec-4a01-9152-6a45bed340d3','4cb3f9c4072c4e558f4e89dc3002ce2d','1304502ff2bf4fc2bce849d08526f92d',1,'tempest-tempest-share-name-1337599409','tempest-tempest-share-description-1879335965',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:56:42.494600','2025-11-22 05:56:47.069045','2025-11-22 05:56:47.068630','91d3c28c-780f-4b34-8033-da786bbb63be','91d3c28c-780f-4b34-8033-da786bbb63be','ff11a55c494c4d8587c6435d27704abd','faf3355c8660499394277773bc5931cb',1,'tempest-tempest-share-name-1299979798','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:51:37.900906','2025-11-22 05:52:08.721392','2025-11-22 05:52:08.720976','94375a59-a60d-4a02-88c7-a97c1daf9744','94375a59-a60d-4a02-88c7-a97c1daf9744','19063b71466b4a099f4798ea400aed7c','fffa744c2146473ab31df119246a9181',1,'tempest-tempest-created-share-1365357751','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:51:21.357337','2025-11-22 05:51:25.343652','2025-11-22 05:51:25.343176','95514f8e-35ec-4fb8-b06a-9b72b929572f','95514f8e-35ec-4fb8-b06a-9b72b929572f','3ca1144a55894a528a97f0906826d387','1d43ad7bfa6f468cb936112ef76b83ec',1,'tempest-tempest-created-share-377496850','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:57:01.036169','2025-11-22 05:57:29.207187','2025-11-22 05:57:29.206101','955a07b8-e5ce-48f7-afed-554d36afb2bb','955a07b8-e5ce-48f7-afed-554d36afb2bb','57c41b494bbf4fa981ed6b0fa212fa71','3ecbc36cc7f84bac8557dd18782914fa',1,'tempest-tempest-share-name-981513377','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:51:07.022167','2025-11-22 05:51:15.264929','2025-11-22 05:51:15.264590','9641e455-326f-4fff-bb3f-88c8298ee465','9641e455-326f-4fff-bb3f-88c8298ee465','98f921ea69fa4cd9bf74c37b645f9733','0e5f6a3a07fc4127bb51414f12d488cd',4,'tempest-tempest-created-share-329108463','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:51:19.795901','2025-11-22 05:51:23.392109','2025-11-22 05:51:23.391593','9baa489e-8738-4bb6-9cb5-831f3a757e15','9baa489e-8738-4bb6-9cb5-831f3a757e15','3a798de8dc964838b12715c65c83b403','9a040dac65f744c687d2d5814d775f6c',1,'tempest-tempest-created-share-1165124594','tempest-tempest-created-share-desc-1272700124',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:55:07.454449','2025-11-22 05:55:11.073873','2025-11-22 05:55:11.073578','a012a75f-0920-4bd5-9cef-c0c84eb53ca5','a012a75f-0920-4bd5-9cef-c0c84eb53ca5','a118fe67fdb84bd1bef3675de0af7cc1','c1bb25e73f4845c0aa83279619d6c189',1,'tempest-tempest-created-share-1825372391','tempest-tempest-created-share-desc-1424185423',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:51:31.699962','2025-11-22 05:51:35.241067','2025-11-22 05:51:35.240521','a0d78e53-1fa5-44a4-b34b-0adf8704cec3','a0d78e53-1fa5-44a4-b34b-0adf8704cec3','3a798de8dc964838b12715c65c83b403','9a040dac65f744c687d2d5814d775f6c',1,'tempest-tempest-created-share-1118942732','tempest-tempest-created-share-desc-295080337',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:52:00.612928','2025-11-22 05:52:20.269621','2025-11-22 05:52:20.269226','a5a4d39a-6afc-47ca-a64e-59baa4b6d20b','a5a4d39a-6afc-47ca-a64e-59baa4b6d20b','ca8cffb070a549e3b3a19f34d69fb809','161410e8e68843c498c108a7c907faa9',1,'tempest-tempest-created-share-2007608989','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:59:31.429637','2025-11-22 05:59:36.750065','2025-11-22 05:59:36.749729','ab12d405-39c4-48b7-9363-e288809d9338','ab12d405-39c4-48b7-9363-e288809d9338','3db9dedf9593479bbad4287d9e10a4d5','1e3df68b14c64c2eba82d76467788260',1,'tempest-tempest-created-share-237412857','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-22 05:51:02.724207','2025-11-22 05:51:10.385445','2025-11-22 05:51:10.385055','ab6d4ef7-870a-4a7d-a86c-dcee3a6035b0','ab6d4ef7-870a-4a7d-a86c-dcee3a6035b0','3ca1144a55894a528a97f0906826d387','1d43ad7bfa6f468cb936112ef76b83ec',2,'tempest-tempest-created-share-426990755','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:54:47.707077','2025-11-22 05:54:59.522293','2025-11-22 05:54:59.521903','ae02f817-c399-4fe3-9e4e-d95a2069a588','ae02f817-c399-4fe3-9e4e-d95a2069a588','a118fe67fdb84bd1bef3675de0af7cc1','c1bb25e73f4845c0aa83279619d6c189',1,'tempest-tempest-created-share-167869126','tempest-tempest-created-share-desc-2086376525',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:53:57.687834','2025-11-22 05:54:09.324227','2025-11-22 05:54:09.323920','b14078d0-94ef-4a05-a729-d7de8cfbf0a4','b14078d0-94ef-4a05-a729-d7de8cfbf0a4','c0acc593440f4aba93cebeb0a88cf188','1c76ef654a3e4144bc0a4cdf01f6107d',1,'tempest-tempest-created-share-1033522478','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:53:22.044813','2025-11-22 05:54:08.261135','2025-11-22 05:54:08.260592','bd3228e3-2f52-48e2-a88c-d28e65ec129c','bd3228e3-2f52-48e2-a88c-d28e65ec129c','54e641a9522e40ffa67c2ca3c0b53ce6','a87583242abb48e1ba1f4d9c6aa18a9b',1,'tempest-tempest-share-name-89279123','tempest-tempest-share-description-1303008558','ab580b6a-b19b-46ad-8a5e-1d8d79733bf6','CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-22 05:51:19.088790','2025-11-22 05:51:25.493223','2025-11-22 05:51:25.492793','bdee9a86-edbb-4ac8-93c2-57ccdadf521c','bdee9a86-edbb-4ac8-93c2-57ccdadf521c','4ec9dc11277c4a1283c49e6e6a186cf5','dd17ac9b721a4caaa440f97988ad0956',1,'tempest-tempest-created-share-48257427','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:52:24.393161','2025-11-22 05:52:29.911966','2025-11-22 05:52:29.911578','be478238-e7db-4a78-aa18-c53b49f1f67f','be478238-e7db-4a78-aa18-c53b49f1f67f','da8b56e53e0b4b21a8b9a579475a6d04','37b6389e0b8c44d58693f909304c85f3',1,'tempest-tempest-created-share-285368917','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:51:11.123382','2025-11-22 05:51:18.753500','2025-11-22 05:51:18.753058','c1402d2f-9c53-426d-a2ae-7a63c8aac5a5','c1402d2f-9c53-426d-a2ae-7a63c8aac5a5','98f921ea69fa4cd9bf74c37b645f9733','0e5f6a3a07fc4127bb51414f12d488cd',3,'tempest-tempest-created-share-636042948','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:58:22.056593','2025-11-22 05:58:26.499106','2025-11-22 05:58:26.498706','c43e7c8b-3603-42ea-aa7c-9c05f1853f0e','c43e7c8b-3603-42ea-aa7c-9c05f1853f0e','4cb3f9c4072c4e558f4e89dc3002ce2d','1304502ff2bf4fc2bce849d08526f92d',1,'tempest-tempest-created-share-117699506','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:54:35.918589','2025-11-22 05:54:39.651639','2025-11-22 05:54:39.651160','c51b35d0-72fb-4c33-9c66-387b1f86a20f','c51b35d0-72fb-4c33-9c66-387b1f86a20f','a118fe67fdb84bd1bef3675de0af7cc1','c1bb25e73f4845c0aa83279619d6c189',1,'tempest-tempest-created-share-719161448','tempest-tempest-created-share-desc-686131518',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:54:59.271872','2025-11-22 05:55:47.493074','2025-11-22 05:55:47.492690','c6335e86-0ed3-4c9b-a59b-df9bdda6090c','c6335e86-0ed3-4c9b-a59b-df9bdda6090c','47d35dbda65c4554a9466657dad531d9','7c0b4b3107784ce6890ddd12d362ec8e',1,'tempest-tempest-created-share-96969388','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-22 05:56:45.303680','2025-11-22 05:56:56.183118','2025-11-22 05:56:56.182650','c6ab1cc0-cdda-41fe-aa61-b68b6c83d06f','c6ab1cc0-cdda-41fe-aa61-b68b6c83d06f','c2522b58eb254cf58002dcb519ab137d','f0fc42a3cd4a4e75942e7132887f268d',1,'tempest-tempest-created-share-244775439','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:53:50.942314','2025-11-22 05:53:57.137840','2025-11-22 05:53:57.137480','c9ccb6a9-0027-4763-9baa-55495ae7c41e','c9ccb6a9-0027-4763-9baa-55495ae7c41e','9b5bfcdf5ad54171a9698feaa812530a','acb08ef912784bb89000a87c4621bcc9',1,'tempest-tempest-created-share-2114553383','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:50:54.653847','2025-11-22 05:50:59.210041','2025-11-22 05:50:59.209377','cf2f7487-22e4-44c3-a53b-c8e5429e4682','cf2f7487-22e4-44c3-a53b-c8e5429e4682','f14080a6e5894c1998fe207d36c3a562','dd1f0f76d8c542febd4c75985ef66d86',1,'tempest-tempest-created-share-459651886','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:56:53.412648','2025-11-22 05:57:01.399267','2025-11-22 05:57:01.398806','d0a602f8-d218-45aa-b13a-279f40f10b98','d0a602f8-d218-45aa-b13a-279f40f10b98','58186e0ac2da4d539ba489a92270cb59','db75a1944ad845ea9c7d9708d52f1e25',1,'tempest-tempest-created-share-2005534629','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:59:08.053110','2025-11-22 05:59:20.246167','2025-11-22 05:59:20.245623','d30ad785-8ea6-4ab6-b62c-a912cd632ebc','d30ad785-8ea6-4ab6-b62c-a912cd632ebc','010135c9a64149dbb6846c9a653da6b8','325a0f56a64040c18ae384c10457495e',1,'tempest-tempest-share-name-1745413333','tempest-tempest-share-description-507044739',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-22 05:53:14.364158','2025-11-22 05:54:15.498573','2025-11-22 05:54:15.498189','d36c5b07-c6d1-453f-8e87-355ac7d60dc7','d36c5b07-c6d1-453f-8e87-355ac7d60dc7','54e641a9522e40ffa67c2ca3c0b53ce6','a87583242abb48e1ba1f4d9c6aa18a9b',1,'tempest-tempest-share-name-793979539','tempest-tempest-share-description-1583974792',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-22 05:57:05.201568','2025-11-22 05:57:25.612163','2025-11-22 05:57:25.611692','d62e9bd9-0999-49d2-988c-dde42208cae5','d62e9bd9-0999-49d2-988c-dde42208cae5','57c41b494bbf4fa981ed6b0fa212fa71','3ecbc36cc7f84bac8557dd18782914fa',1,'tempest-tempest-share-name-1199771691','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:57:55.674153','2025-11-22 05:58:06.202420','2025-11-22 05:58:06.202063','d9c461b7-5bb4-48ae-ba3a-231acbbfb736','d9c461b7-5bb4-48ae-ba3a-231acbbfb736','c85f7bcc3e4d40d2bc0e6a37832e885d','8179302d26964c999cd5f9a55ba9d33b',1,'tempest-tempest-created-share-1194584495','Tempest\'s share','396d061d-06cf-48da-a32e-5cf66e8782c8','CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-22 05:57:28.040382','2025-11-22 05:57:39.100385','2025-11-22 05:57:39.099990','dc95832f-bd83-4269-86ac-bbbfcc21bdfa','dc95832f-bd83-4269-86ac-bbbfcc21bdfa','c85f7bcc3e4d40d2bc0e6a37832e885d','8179302d26964c999cd5f9a55ba9d33b',1,'tempest-tempest-created-share-1044609196','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:54:55.349247','2025-11-22 05:54:58.988341','2025-11-22 05:54:58.987931','e376fddc-de34-4fd0-b102-8ee7a264cef2','e376fddc-de34-4fd0-b102-8ee7a264cef2','a118fe67fdb84bd1bef3675de0af7cc1','c1bb25e73f4845c0aa83279619d6c189',1,'tempest-tempest-created-share-107085586','tempest-tempest-created-share-desc-630423302',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:50:49.584109','2025-11-22 05:52:23.083298','2025-11-22 05:52:23.082615','e3f37aa3-6df4-4c21-afa2-3d3d20a6917e','e3f37aa3-6df4-4c21-afa2-3d3d20a6917e','3ca1144a55894a528a97f0906826d387','1d43ad7bfa6f468cb936112ef76b83ec',1,'tempest-tempest-created-share-491735317','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:54:52.092648','2025-11-22 05:55:50.970662','2025-11-22 05:55:50.970150','e54ddc55-06e2-4ec6-9935-df702d90e2c8','e54ddc55-06e2-4ec6-9935-df702d90e2c8','eb4a2a9cc4f34eed857eeb1400d6e1e8','525ba1ccf0d546c7b4118a0855306190',1,'tempest-tempest-created-share-485840169','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-22 05:53:12.827503','2025-11-22 05:53:17.613382','2025-11-22 05:53:17.612926','e6284ec1-39ae-44d4-b9e1-86b6e30cae7b','e6284ec1-39ae-44d4-b9e1-86b6e30cae7b','9b5bfcdf5ad54171a9698feaa812530a','acb08ef912784bb89000a87c4621bcc9',1,'tempest-tempest-created-share-981030567','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:54:48.373197','2025-11-22 05:55:54.806170','2025-11-22 05:55:54.805818','e6ebf7ae-934a-4ccf-9ab6-5b62a19c9509','e6ebf7ae-934a-4ccf-9ab6-5b62a19c9509','eb4a2a9cc4f34eed857eeb1400d6e1e8','525ba1ccf0d546c7b4118a0855306190',1,'tempest-tempest-created-share-1346931048','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:59:05.315710','2025-11-22 05:59:12.747566','2025-11-22 05:59:12.747091','e86c045c-ceab-444c-a106-8615dd89c419','e86c045c-ceab-444c-a106-8615dd89c419','3db9dedf9593479bbad4287d9e10a4d5','1e3df68b14c64c2eba82d76467788260',2,'tempest-tempest-created-share-1482715733','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-22 05:58:44.492012','2025-11-22 05:59:47.048911','2025-11-22 05:59:47.048590','eb009558-f725-445d-90b6-32ce03b569d0','eb009558-f725-445d-90b6-32ce03b569d0','3db9dedf9593479bbad4287d9e10a4d5','1e3df68b14c64c2eba82d76467788260',1,'tempest-tempest-share-name-1921641302','tempest-tempest-share-description-1662008560',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-22 05:58:07.303116','2025-11-22 05:58:11.468681','2025-11-22 05:58:11.468277','eb32b540-d954-4b0c-a932-b3beb4bbf4e7','eb32b540-d954-4b0c-a932-b3beb4bbf4e7','4cb3f9c4072c4e558f4e89dc3002ce2d','1304502ff2bf4fc2bce849d08526f92d',2,'tempest-tempest-created-share-1730150793','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:53:09.216662','2025-11-22 05:54:02.924988','2025-11-22 05:54:02.924652','ebd2d532-e2e2-40cc-8718-7ba6b480684f','ebd2d532-e2e2-40cc-8718-7ba6b480684f','9b5bfcdf5ad54171a9698feaa812530a','acb08ef912784bb89000a87c4621bcc9',1,'tempest-tempest-created-share-1059202987','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:59:20.588143','2025-11-22 05:59:28.194919','2025-11-22 05:59:28.194415','ec39ec6c-4d9a-48ba-8699-5768bc4f8f85','ec39ec6c-4d9a-48ba-8699-5768bc4f8f85','3db9dedf9593479bbad4287d9e10a4d5','1e3df68b14c64c2eba82d76467788260',1,'tempest-tempest-created-share-423058678','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-22 05:54:14.751506','2025-11-22 05:54:26.706500','2025-11-22 05:54:26.706090','f21cb0fb-7bd7-47da-8c9d-8be6d286e1f2','f21cb0fb-7bd7-47da-8c9d-8be6d286e1f2','4a3993de61324ab4ae41b5b9d711e3a9','5c79362f5df94bb7805d87f3cb0f6a70',1,'public_share - must be visible to all projects in the cloud','public_share_desc',NULL,'CEPHFS',1,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:54:31.716840','2025-11-22 05:54:35.571176','2025-11-22 05:54:35.570607','f2b41e8c-9da0-47f0-8319-319f763a885f','f2b41e8c-9da0-47f0-8319-319f763a885f','a118fe67fdb84bd1bef3675de0af7cc1','c1bb25e73f4845c0aa83279619d6c189',1,'tempest-tempest-created-share-1890262340','tempest-tempest-created-share-desc-374257261',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:54:18.465364','2025-11-22 05:54:22.714459','2025-11-22 05:54:22.714073','f3333f1b-e538-4076-90c8-83c744ff197c','f3333f1b-e538-4076-90c8-83c744ff197c','2256793bd84244a3bcb61874a41075c5','879b9840974d4a5186ae02687052f6dc',1,'private_share','private share in the primary user project',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:57:51.210033','2025-11-22 05:58:12.996148','2025-11-22 05:58:12.995759','fa786287-7fdf-4612-aca2-817bfa149b97','fa786287-7fdf-4612-aca2-817bfa149b97','c85f7bcc3e4d40d2bc0e6a37832e885d','8179302d26964c999cd5f9a55ba9d33b',1,'tempest-tempest-created-share-1091018745','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-22 05:59:06.503852','2025-11-22 06:00:00.074473','2025-11-22 06:00:00.073990','fa7e2f81-5e9b-4471-bca4-e46b171d2c36','fa7e2f81-5e9b-4471-bca4-e46b171d2c36','123ee1961f274fcf8727f7d4c1fb5248','ef497337be194fcb9ce62d89ec4f8a5a',1,'tempest-tempest-share-name-979517078','tempest-tempest-share-description-1045867966',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-22 05:57:42.637518','2025-11-22 05:57:47.720877','2025-11-22 05:57:47.720535','faeaa260-b2b9-4f76-bea6-38a9e85e461b','faeaa260-b2b9-4f76-bea6-38a9e85e461b','c85f7bcc3e4d40d2bc0e6a37832e885d','8179302d26964c999cd5f9a55ba9d33b',1,'tempest-tempest-created-share-100883687','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-22 05:56:48.817636','2025-11-22 05:56:52.753312','2025-11-22 05:56:52.752844','fde709e6-9872-4f8f-ba45-eda0da220019','fde709e6-9872-4f8f-ba45-eda0da220019','c2522b58eb254cf58002dcb519ab137d','f0fc42a3cd4a4e75942e7132887f268d',1,'tempest-tempest-created-share-980012727','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL);
/*!40000 ALTER TABLE `shares` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `resource_id` varchar(36) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime(6) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
INSERT INTO `transfers` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `resource_id`, `resource_type`, `display_name`, `salt`, `crypt_hash`, `expires_at`, `source_project_id`, `destination_project_id`, `accepted`) VALUES ('047673c8-8a89-414d-babb-2a26be07df9b','2025-11-22 05:56:45.974471',NULL,'2025-11-22 05:56:46.415526','047673c8-8a89-414d-babb-2a26be07df9b','91d3c28c-780f-4b34-8033-da786bbb63be','share','tempest_share_transfer','a73edefa','f6896a74da4d167c9d2d3fbcdf6ebd3539d070eae6ba13fea589dd2ae8a367b4','2025-11-22 06:01:45.972655','faf3355c8660499394277773bc5931cb',NULL,0),('30dbe86d-9dad-455a-a144-3301e74a5fbb','2025-11-22 05:57:08.593310',NULL,'2025-11-22 05:57:08.847592','30dbe86d-9dad-455a-a144-3301e74a5fbb','d62e9bd9-0999-49d2-988c-dde42208cae5','share','tempest-tempest-created-share-transfer-1266711127','95479679','cad84b4fc1b615c98bbcc432c3b2014bf020fcf3ac3dd24156759f8c0291f83a','2025-11-22 06:02:08.590876','3ecbc36cc7f84bac8557dd18782914fa',NULL,0),('5815e7b6-dea3-4a9a-b72d-8daf0cacc01a','2025-11-22 05:57:16.627761',NULL,'2025-11-22 05:57:16.899280','5815e7b6-dea3-4a9a-b72d-8daf0cacc01a','454c896f-ee5c-43cc-af2b-3cf311c7ba49','share','tempest-tempest-created-share-transfer-1634583092','d5068930','3ea04e7e141de188fbcf42c87b67689257cc60dee76afa27bd8007ea4e3cd6b5','2025-11-22 06:02:16.626685','3ecbc36cc7f84bac8557dd18782914fa',NULL,0),('9b3491e2-1a10-46d9-bd3e-c4fa54a70a08','2025-11-22 05:56:37.808606','2025-11-22 05:56:38.372146','2025-11-22 05:56:38.372144','1','85231eff-df4a-437f-b115-e47d4632d59f','share','tempest-tempest-created-share-transfer-693752748','66f18543','bc787173a839b803c2e51753bc6731469d5bdb9c91abba26dd0fac410f68d358','2025-11-22 06:01:37.806965','faf3355c8660499394277773bc5931cb','0cb5c96c52bc4e89961346306e373479',1),('b980c7b5-ba13-4b19-b595-20470a4e5be7','2025-11-22 05:57:04.480513',NULL,'2025-11-22 05:57:04.961820','b980c7b5-ba13-4b19-b595-20470a4e5be7','955a07b8-e5ce-48f7-afed-554d36afb2bb','share','tempest-tempest-created-share-transfer-112659414','e0f4cbbc','da71b47ef66713b2dc4ac2c523be7e0d8ea441ffc6bfb7e6638db85bab810533','2025-11-22 06:02:04.478587','3ecbc36cc7f84bac8557dd18782914fa',NULL,0),('c96c5a19-3f19-4d8c-9b9d-30b38a4361a7','2025-11-22 05:57:12.595706',NULL,'2025-11-22 05:57:12.859033','c96c5a19-3f19-4d8c-9b9d-30b38a4361a7','3d52ca5b-a434-47f0-a9bc-5e058cdeadc4','share','tempest-tempest-created-share-transfer-1104480886','037b475f','2e1af3769e0c8b3a3dbffbb074984fac6534d558c44e60e9b4b5d9313d60af95','2025-11-22 06:02:12.594851','3ecbc36cc7f84bac8557dd18782914fa',NULL,0);
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `mysql`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `mysql` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;

USE `mysql`;

--
-- Table structure for table `general_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `general_log` (
  `event_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `command_type` varchar(64) NOT NULL,
  `argument` mediumtext NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='General log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slow_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `slow_log` (
  `start_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `query_time` time(6) NOT NULL,
  `lock_time` time(6) NOT NULL,
  `rows_sent` bigint(20) unsigned NOT NULL,
  `rows_examined` bigint(20) unsigned NOT NULL,
  `db` varchar(512) NOT NULL,
  `last_insert_id` int(11) NOT NULL,
  `insert_id` int(11) NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `sql_text` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `rows_affected` bigint(20) unsigned NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Slow log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `column_stats`
--

DROP TABLE IF EXISTS `column_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `column_stats` (
  `db_name` varchar(64) NOT NULL,
  `table_name` varchar(64) NOT NULL,
  `column_name` varchar(64) NOT NULL,
  `min_value` varbinary(255) DEFAULT NULL,
  `max_value` varbinary(255) DEFAULT NULL,
  `nulls_ratio` decimal(12,4) DEFAULT NULL,
  `avg_length` decimal(12,4) DEFAULT NULL,
  `avg_frequency` decimal(12,4) DEFAULT NULL,
  `hist_size` tinyint(3) unsigned DEFAULT NULL,
  `hist_type` enum('SINGLE_PREC_HB','DOUBLE_PREC_HB') DEFAULT NULL,
  `histogram` varbinary(255) DEFAULT NULL,
  PRIMARY KEY (`db_name`,`table_name`,`column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='Statistics on Columns';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `column_stats`
--

LOCK TABLES `column_stats` WRITE;
/*!40000 ALTER TABLE `column_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `column_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `columns_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Table_name` char(64) NOT NULL DEFAULT '',
  `Column_name` char(64) NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `db` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_history_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT INTO `db` (`Host`, `Db`, `User`, `Select_priv`, `Insert_priv`, `Update_priv`, `Delete_priv`, `Create_priv`, `Drop_priv`, `Grant_priv`, `References_priv`, `Index_priv`, `Alter_priv`, `Create_tmp_table_priv`, `Lock_tables_priv`, `Create_view_priv`, `Show_view_priv`, `Create_routine_priv`, `Alter_routine_priv`, `Execute_priv`, `Event_priv`, `Trigger_priv`, `Delete_history_priv`) VALUES ('localhost','keystone','keystone_4fc8','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','keystone','keystone_4fc8','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','glance','glance_0c45','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','placement','placement_b756','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','glance','glance_0c45','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','placement','placement_b756','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','barbican','barbican_d2da','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','neutron','neutron_bacb','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','cinder','cinder_ea58','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','barbican','barbican_d2da','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','neutron','neutron_bacb','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','cinder','cinder_ea58','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_api','nova_api_b75c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_cell0','nova_cell0_36d8','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_api','nova_api_b75c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_cell0','nova_cell0_36d8','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','manila','manila_50ec','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','manila','manila_50ec','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` char(141) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','IGNORE_BAD_TABLE_OPTIONS','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH','EMPTY_STRING_IS_NULL','SIMULTANEOUS_ASSIGNMENT','TIME_ROUND_FRACTIONAL') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob DEFAULT NULL,
  PRIMARY KEY (`db`,`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `func` (
  `name` char(64) NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT 0,
  `dl` char(128) NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `global_priv`
--

DROP TABLE IF EXISTS `global_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Priv` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '{}' CHECK (json_valid(`Priv`)),
  PRIMARY KEY (`Host`,`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_priv`
--

LOCK TABLES `global_priv` WRITE;
/*!40000 ALTER TABLE `global_priv` DISABLE KEYS */;
INSERT INTO `global_priv` (`Host`, `User`, `Priv`) VALUES ('localhost','mariadb.sys','{\"access\":0,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"\",\"account_locked\":true,\"password_last_changed\":0}'),('localhost','root','{\"access\": 549755813887, \"plugin\": \"mysql_native_password\", \"authentication_string\": \"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\", \"auth_or\": [{}],\"version_id\":100529,\"password_last_changed\":1763788176}'),('%','root','{\"access\":549755813887,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\",\"password_last_changed\":1763788176}'),('localhost','keystone_4fc8','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B66E94F579535D80117A0849CAA657E300513671\",\"password_last_changed\":1763788191}'),('%','keystone_4fc8','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B66E94F579535D80117A0849CAA657E300513671\",\"password_last_changed\":1763788191}'),('localhost','glance_0c45','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*3B4C97B86693267DADB80F142011F5D7CAFBEDF5\",\"password_last_changed\":1763788191}'),('localhost','placement_b756','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*34F425BA93442FE51CDE326B4C7F581C8AE43A23\",\"password_last_changed\":1763788191}'),('%','glance_0c45','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*3B4C97B86693267DADB80F142011F5D7CAFBEDF5\",\"password_last_changed\":1763788191}'),('%','placement_b756','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*34F425BA93442FE51CDE326B4C7F581C8AE43A23\",\"password_last_changed\":1763788191}'),('localhost','barbican_d2da','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*D9AB47131EB3927F9EBADA326024C83A0169D1C2\",\"password_last_changed\":1763788229}'),('localhost','neutron_bacb','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*3DBEBC5206AE0FBCE3BB5C3400641862CB70A11A\",\"password_last_changed\":1763788229}'),('localhost','cinder_ea58','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*E39A7481EDC3EAEFAE4287555BC3C113FECC024C\",\"password_last_changed\":1763788229}'),('%','barbican_d2da','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*D9AB47131EB3927F9EBADA326024C83A0169D1C2\",\"password_last_changed\":1763788229}'),('%','neutron_bacb','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*3DBEBC5206AE0FBCE3BB5C3400641862CB70A11A\",\"password_last_changed\":1763788229}'),('%','cinder_ea58','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*E39A7481EDC3EAEFAE4287555BC3C113FECC024C\",\"password_last_changed\":1763788229}'),('localhost','nova_api_b75c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*80BFDAFDD6E8E56013C16C0D1A39C73E167D5EDB\",\"password_last_changed\":1763788334}'),('localhost','nova_cell0_36d8','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*480CAE98E555DDB88E8CDA177D8FE5DA83DC9A59\",\"password_last_changed\":1763788334}'),('%','nova_api_b75c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*80BFDAFDD6E8E56013C16C0D1A39C73E167D5EDB\",\"password_last_changed\":1763788335}'),('%','nova_cell0_36d8','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*480CAE98E555DDB88E8CDA177D8FE5DA83DC9A59\",\"password_last_changed\":1763788335}'),('localhost','manila_50ec','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*F58031375674E4A21D8BF6F7AAAD16ADA7AF08B7\",\"password_last_changed\":1763790329}'),('%','manila_50ec','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*F58031375674E4A21D8BF6F7AAAD16ADA7AF08B7\",\"password_last_changed\":1763790329}');
/*!40000 ALTER TABLE `global_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gtid_slave_pos`
--

DROP TABLE IF EXISTS `gtid_slave_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gtid_slave_pos` (
  `domain_id` int(10) unsigned NOT NULL,
  `sub_id` bigint(20) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `seq_no` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`domain_id`,`sub_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Replication slave GTID position';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gtid_slave_pos`
--

LOCK TABLES `gtid_slave_pos` WRITE;
/*!40000 ALTER TABLE `gtid_slave_pos` DISABLE KEYS */;
/*!40000 ALTER TABLE `gtid_slave_pos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT INTO `help_category` (`help_category_id`, `name`, `parent_category_id`, `url`) VALUES (1,'Contents',0,''),(2,'Polygon Properties',34,''),(3,'WKT',34,''),(4,'Numeric Functions',37,''),(5,'Plugins',1,''),(6,'MBR',34,''),(7,'Control Flow Functions',37,''),(8,'Transactions',1,''),(9,'Help Metadata',1,''),(10,'Account Management',1,''),(11,'Point Properties',34,''),(12,'Encryption Functions',37,''),(13,'LineString Properties',34,''),(14,'Miscellaneous Functions',37,''),(15,'Logical Operators',47,''),(16,'Functions and Modifiers for Use with GROUP BY',1,''),(17,'Information Functions',37,''),(18,'Assignment Operators',47,''),(19,'Comparison Operators',47,''),(20,'Bit Functions',37,''),(21,'Table Maintenance',1,''),(22,'User-Defined Functions',1,''),(23,'Data Types',1,''),(24,'Compound Statements',1,''),(25,'Geometry Constructors',34,''),(26,'Administration',1,''),(27,'Data Manipulation',1,''),(28,'Utility',1,''),(29,'Language Structure',1,''),(30,'Geometry Relations',34,''),(31,'Date and Time Functions',37,''),(32,'WKB',34,''),(33,'Procedures',1,''),(34,'Geographic Features',1,''),(35,'Geometry Properties',34,''),(36,'String Functions',37,''),(37,'Functions',1,''),(38,'Data Definition',1,''),(39,'Sequences',1,''),(40,'JSON Functions',37,''),(41,'Window Functions',37,''),(42,'Spider Functions',37,''),(43,'Dynamic Column Functions',37,''),(44,'Galera Functions',37,''),(45,'Temporal Tables',1,''),(46,'GeoJSON',34,''),(47,'Operators',1,''),(48,'Arithmetic Operators',47,''),(49,'Replication',1,''),(50,'Prepared Statements',1,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT INTO `help_keyword` (`help_keyword_id`, `name`) VALUES (1,'work'),(2,'locks'),(3,'locking'),(4,'drop'),(5,'super'),(6,'usage'),(7,'binlog admin'),(8,'binlog monitor'),(9,'binlog replay'),(10,'connection admin'),(11,'federated admin'),(12,'grant option'),(13,'read_only admin'),(14,'replica monitor'),(15,'replication replica'),(16,'roles'),(17,'values'),(18,'value'),(19,'not'),(20,'and'),(21,'or'),(22,':='),(23,'assignment operator'),(24,'='),(25,'!='),(26,'<>'),(27,'not equal'),(28,'less than'),(29,'less than or equal'),(30,'NULL-safe equal'),(31,'equal'),(32,'greater than'),(33,'greater than or equal'),(34,'bitwise and'),(35,'shift left'),(36,'shift right'),(37,'bitwise xor'),(38,'bitwise or'),(39,'bitwise not'),(40,'returns'),(41,'udfs'),(42,'udf calling sequences'),(43,'udf security'),(44,'int1'),(45,'int2'),(46,'int3'),(47,'integer'),(48,'int4'),(49,'int8'),(50,'dec'),(51,'numeric'),(52,'fixed'),(53,'number'),(54,'real'),(55,'double precision'),(56,'nchar'),(57,'long'),(58,'long varchar'),(59,'repeat'),(60,'declare'),(61,'cursor'),(62,'show'),(63,'columns'),(64,'kill connection'),(65,'kill query'),(66,'delete returning'),(67,'sql_big_result'),(68,'minus'),(69,'cte'),(70,'insert returning'),(71,'queries'),(72,'query'),(73,'explain format'),(74,'explain format json'),(75,'rlike'),(76,'character_length'),(77,'escape'),(78,'mode'),(79,'trim_oracle'),(80,'schedule'),(81,'row_format'),(82,'starts'),(83,'host'),(84,'generated columns'),(85,'virtual columns'),(86,'computed columns'),(87,'hidden columns'),(88,'nextval'),(89,'lastval'),(90,'+'),(91,'addition operator'),(92,'/'),(93,'division operator'),(94,'%'),(95,'modulo operator'),(96,'*'),(97,'multiplication operator'),(98,'-'),(99,'subtraction operator'),(100,'master_ssl_verify_cert'),(101,'start replica'),(102,'stop replica'),(103,'reset slave'),(104,'reset replica'),(105,'drop prepare'),(106,'deallocate prepare');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`),
  KEY `help_topic_id` (`help_topic_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT INTO `help_relation` (`help_topic_id`, `help_keyword_id`) VALUES (94,1),(97,2),(99,2),(101,2),(116,2),(147,2),(152,2),(157,2),(161,2),(162,2),(338,2),(438,2),(97,3),(99,3),(101,3),(116,3),(147,3),(152,3),(157,3),(161,3),(162,3),(338,3),(438,3),(106,4),(112,4),(250,4),(687,4),(697,4),(713,4),(714,4),(715,4),(716,4),(717,4),(718,4),(719,4),(720,4),(722,4),(723,4),(731,4),(107,5),(107,6),(107,7),(107,8),(107,9),(107,10),(107,11),(107,12),(107,13),(107,14),(107,15),(115,16),(166,17),(166,18),(167,19),(168,20),(170,21),(210,22),(210,23),(211,23),(211,24),(212,25),(212,26),(212,27),(213,28),(214,29),(215,30),(216,31),(217,32),(218,33),(232,34),(233,35),(234,36),(236,37),(237,38),(238,39),(249,40),(251,41),(252,42),(253,43),(255,44),(257,45),(258,46),(259,47),(259,48),(260,49),(261,50),(261,51),(261,52),(261,53),(263,54),(263,55),(269,56),(275,57),(275,58),(304,59),(664,59),(311,60),(311,61),(331,62),(332,62),(333,62),(334,62),(335,62),(342,62),(343,62),(344,62),(345,62),(346,62),(347,62),(354,62),(356,62),(357,62),(358,62),(359,62),(360,62),(361,62),(362,62),(363,62),(364,62),(365,62),(366,62),(367,62),(368,62),(369,62),(370,62),(371,62),(372,62),(373,62),(374,62),(375,62),(376,62),(377,62),(378,62),(379,62),(380,62),(381,62),(382,62),(383,62),(384,62),(385,62),(386,62),(387,62),(388,62),(389,62),(390,62),(391,62),(392,62),(393,62),(394,62),(395,62),(396,62),(397,62),(398,62),(408,62),(409,62),(333,63),(403,64),(403,65),(410,66),(414,67),(425,68),(431,69),(432,69),(433,69),(453,70),(460,71),(460,72),(466,73),(466,74),(622,75),(632,76),(651,77),(657,78),(678,79),(689,80),(696,81),(701,82),(707,83),(711,84),(711,85),(711,86),(712,87),(732,88),(733,89),(804,90),(804,91),(805,92),(805,93),(806,94),(806,95),(807,96),(807,97),(808,98),(808,99),(809,100),(810,101),(811,102),(812,103),(812,104),(816,105),(816,106);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
INSERT INTO `help_topic` (`help_topic_id`, `name`, `help_category_id`, `description`, `example`, `url`) VALUES (1,'HELP_DATE',9,'Help Contents generated from the MariaDB Knowledge Base on 23 January 2023.','',''),(2,'HELP_VERSION',9,'Help Contents generated for MariaDB 10.5 from the MariaDB Knowledge Base on 23 January 2023.','',''),(3,'AREA',2,'A synonym for ST_AREA.\n\nURL: https://mariadb.com/kb/en/polygon-properties-area/','','https://mariadb.com/kb/en/polygon-properties-area/'),(4,'CENTROID',2,'A synonym for ST_CENTROID.\n\nURL: https://mariadb.com/kb/en/centroid/','','https://mariadb.com/kb/en/centroid/'),(5,'ExteriorRing',2,'A synonym for ST_ExteriorRing.\n\nURL: https://mariadb.com/kb/en/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/polygon-properties-exteriorring/'),(6,'InteriorRingN',2,'A synonym for ST_InteriorRingN.\n\nURL: https://mariadb.com/kb/en/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/polygon-properties-interiorringn/'),(7,'NumInteriorRings',2,'A synonym for ST_NumInteriorRings.\n\nURL: https://mariadb.com/kb/en/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/polygon-properties-numinteriorrings/'),(8,'ST_AREA',2,'Syntax\n------\n\nST_Area(poly)\nArea(poly)\n\nDescription\n-----------\n\nReturns as a double-precision number the area of the Polygon value poly, as\nmeasured in its spatial reference system.\n\nST_Area() and Area() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\n\nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/st_area/','','https://mariadb.com/kb/en/st_area/'),(9,'ST_CENTROID',2,'Syntax\n------\n\nST_Centroid(mpoly)\nCentroid(mpoly)\n\nDescription\n-----------\n\nReturns a point reflecting the mathematical centroid (geometric center) for\nthe MultiPolygon mpoly. The resulting point will not necessarily be on the\nMultiPolygon.\n\nST_Centroid() and Centroid() are synonyms.\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0 0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n+--------------+\n| center       |\n+--------------+\n| POINT(10 10) |\n+--------------+\n\nURL: https://mariadb.com/kb/en/st_centroid/','','https://mariadb.com/kb/en/st_centroid/'),(10,'ST_ExteriorRing',2,'Syntax\n------\n\nST_ExteriorRing(poly)\nExteriorRing(poly)\n\nDescription\n-----------\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() and ExteriorRing() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_exteriorring/','','https://mariadb.com/kb/en/st_exteriorring/'),(11,'ST_InteriorRingN',2,'Syntax\n------\n\nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n\nDescription\n-----------\n\nReturns the N-th interior ring for the Polygon value poly as a LineString.\nRings are numbered beginning with 1.\n\nST_InteriorRingN() and InteriorRingN() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_interiorringn/','','https://mariadb.com/kb/en/st_interiorringn/'),(12,'ST_NumInteriorRings',2,'Syntax\n------\n\nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n\nDescription\n-----------\n\nReturns an integer containing the number of interior rings in the Polygon\nvalue poly.\n\nNote that according the the OpenGIS standard, a POLYGON should have exactly\none ExteriorRing and all other rings should lie within that ExteriorRing and\nthus be the InteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several \'ExteriorRings\'. In the case of\nthere being multiple, non-overlapping exterior rings ST_NumInteriorRings()\nwill return 1.\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/st_numinteriorrings/','','https://mariadb.com/kb/en/st_numinteriorrings/'),(14,'AsText',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-astext/','','https://mariadb.com/kb/en/wkt-astext/'),(15,'AsWKT',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-aswkt/','','https://mariadb.com/kb/en/wkt-aswkt/'),(16,'GeomCollFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/wkt-geomcollfromtext/'),(17,'GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromtext/','','https://mariadb.com/kb/en/geometrycollectionfromtext/'),(18,'GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/geometryfromtext/','','https://mariadb.com/kb/en/geometryfromtext/'),(19,'GeomFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomfromtext/','','https://mariadb.com/kb/en/wkt-geomfromtext/'),(20,'LineFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/wkt-linefromtext/','','https://mariadb.com/kb/en/wkt-linefromtext/'),(21,'LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/linestringfromtext/','','https://mariadb.com/kb/en/linestringfromtext/'),(22,'MLineFromText',3,'Syntax\n------\n\nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n\nMLineFromText() and MultiLineStringFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\nINSERT INTO gis_multi_line VALUES\n  (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16\n23,16 48))\')),\n  (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n  (MLineFromWKB(AsWKB(MultiLineString(\n   LineString(Point(1, 2), Point(3, 5)),\n   LineString(Point(2, 5), Point(5, 8), Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/mlinefromtext/','','https://mariadb.com/kb/en/mlinefromtext/'),(23,'MPointFromText',3,'Syntax\n------\n\nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nMPointFromText() and MultiPointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/mpointfromtext/','','https://mariadb.com/kb/en/mpointfromtext/'),(13,'WKT Definition',3,'Description\n-----------\n\nThe Well-Known Text (WKT) representation of Geometry is designed to exchange\ngeometry data in ASCII form. Examples of the basic geometry types include:\n\n+-----------------------------------------------------------------------------+\n| Geometry Types                                                              |\n+-----------------------------------------------------------------------------+\n| POINT                                                                       |\n+-----------------------------------------------------------------------------+\n| LINESTRING                                                                  |\n+-----------------------------------------------------------------------------+\n| POLYGON                                                                     |\n+-----------------------------------------------------------------------------+\n| MULTIPOINT                                                                  |\n+-----------------------------------------------------------------------------+\n| MULTILINESTRING                                                             |\n+-----------------------------------------------------------------------------+\n| MULTIPOLYGON                                                                |\n+-----------------------------------------------------------------------------+\n| GEOMETRYCOLLECTION                                                          |\n+-----------------------------------------------------------------------------+\n| GEOMETRY                                                                    |\n+-----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/wkt-definition/','','https://mariadb.com/kb/en/wkt-definition/'),(24,'MPolyFromText',3,'Syntax\n------\n\nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nMPolyFromText() and MultiPolygonFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(\n   LineString(Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/mpolyfromtext/','','https://mariadb.com/kb/en/mpolyfromtext/'),(25,'MultiLineStringFromText',3,'A synonym for MLineFromText.\n\nURL: https://mariadb.com/kb/en/multilinestringfromtext/','','https://mariadb.com/kb/en/multilinestringfromtext/'),(26,'MultiPointFromText',3,'A synonym for MPointFromText.\n\nURL: https://mariadb.com/kb/en/multipointfromtext/','','https://mariadb.com/kb/en/multipointfromtext/'),(27,'MultiPolygonFromText',3,'A synonym for MPolyFromText.\n\nURL: https://mariadb.com/kb/en/multipolygonfromtext/','','https://mariadb.com/kb/en/multipolygonfromtext/'),(28,'PointFromText',3,'A synonym for ST_PointFromText.\n\nURL: https://mariadb.com/kb/en/wkt-pointfromtext/','','https://mariadb.com/kb/en/wkt-pointfromtext/'),(29,'PolyFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/wkt-polyfromtext/','','https://mariadb.com/kb/en/wkt-polyfromtext/'),(30,'PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/polygonfromtext/','','https://mariadb.com/kb/en/polygonfromtext/'),(31,'ST_AsText',3,'Syntax\n------\n\nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKT representation and\nreturns the string result.\n\nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all synonyms.\n\nExamples\n--------\n\nSET @g = \'LineString(1 1,4 4,6 6)\';\n\nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6)        |\n+--------------------------------+\n\nURL: https://mariadb.com/kb/en/st_astext/','','https://mariadb.com/kb/en/st_astext/'),(32,'ST_ASWKT',3,'A synonym for ST_ASTEXT().\n\nURL: https://mariadb.com/kb/en/st_aswkt/','','https://mariadb.com/kb/en/st_aswkt/'),(33,'ST_GeomCollFromText',3,'Syntax\n------\n\nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(), GeomCollFromText() and\nGeometryCollectionFromText() are all synonyms.\n\nExample\n-------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/st_geomcollfromtext/','','https://mariadb.com/kb/en/st_geomcollfromtext/'),(34,'ST_GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/st_geometrycollectionfromtext/'),(35,'ST_GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/st_geometryfromtext/','','https://mariadb.com/kb/en/st_geometryfromtext/'),(36,'ST_GeomFromText',3,'Syntax\n------\n\nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKT representation and SRID.\n\nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n\nExample\n-------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nURL: https://mariadb.com/kb/en/st_geomfromtext/','','https://mariadb.com/kb/en/st_geomfromtext/'),(37,'ST_LineFromText',3,'Syntax\n------\n\nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nST_LineFromText(), ST_LineStringFromText(), ST_LineFromText() and\nST_LineStringFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_line  (g LINESTRING);\nSHOW FIELDS FROM gis_line;\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/st_linefromtext/','','https://mariadb.com/kb/en/st_linefromtext/'),(38,'ST_LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/st_linestringfromtext/','','https://mariadb.com/kb/en/st_linestringfromtext/'),(39,'ST_PointFromText',3,'Syntax\n------\n\nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKT representation and SRID.\n\nST_PointFromText() and PointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_point  (g POINT);\nSHOW FIELDS FROM gis_point;\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/st_pointfromtext/','','https://mariadb.com/kb/en/st_pointfromtext/'),(40,'ST_PolyFromText',3,'Syntax\n------\n\nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\'));\n\nURL: https://mariadb.com/kb/en/st_polyfromtext/','','https://mariadb.com/kb/en/st_polyfromtext/'),(41,'ST_PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/st_polygonfromtext/','','https://mariadb.com/kb/en/st_polygonfromtext/'),(42,'DIV',4,'Syntax\n------\n\nDIV\n\nDescription\n-----------\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for non-integer operands that exceed BIGINT range.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a division by zero produces\nan error. Otherwise, it returns NULL.\n\nThe remainder of a division can be obtained using the MOD operator.\n\nExamples\n--------\n\nSELECT 300 DIV 7;\n+-----------+\n| 300 DIV 7 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT 300 DIV 0;\n+-----------+\n| 300 DIV 0 |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/div/','','https://mariadb.com/kb/en/div/'),(43,'ABS',4,'Syntax\n------\n\nABS(X)\n\nDescription\n-----------\n\nReturns the absolute (non-negative) value of X. If X is not a number, it is\nconverted to a numeric type.\n\nExamples\n--------\n\nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n|      42 |\n+---------+\n\nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n|       42 |\n+----------+\n\nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n|               19940101 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/abs/','','https://mariadb.com/kb/en/abs/'),(44,'ACOS',4,'Syntax\n------\n\nACOS(X)\n\nDescription\n-----------\n\nReturns the arc cosine of X, that is, the value whose cosine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n|         NULL |\n+--------------+\n\nSELECT ACOS(0);\n+-----------------+\n| ACOS(0)         |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234)      |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/acos/','','https://mariadb.com/kb/en/acos/'),(45,'ASIN',4,'Syntax\n------\n\nASIN(X)\n\nDescription\n-----------\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns NULL if\nX is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2)          |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n\nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n\nSHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n\nURL: https://mariadb.com/kb/en/asin/','','https://mariadb.com/kb/en/asin/'),(46,'ATAN',4,'Syntax\n------\n\nATAN(X)\n\nDescription\n-----------\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nExamples\n--------\n\nSELECT ATAN(2);\n+--------------------+\n| ATAN(2)            |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n\nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2)            |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/atan/','','https://mariadb.com/kb/en/atan/'),(47,'ATAN2',4,'Syntax\n------\n\nATAN(Y,X), ATAN2(Y,X)\n\nDescription\n-----------\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both arguments\nare used to determine the quadrant of the result.\n\nExamples\n--------\n\nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2)          |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n\nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0)      |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/atan2/','','https://mariadb.com/kb/en/atan2/'),(48,'CEIL',4,'Syntax\n------\n\nCEIL(X)\n\nDescription\n-----------\n\nCEIL() is a synonym for CEILING().\n\nURL: https://mariadb.com/kb/en/ceil/','','https://mariadb.com/kb/en/ceil/'),(49,'CEILING',4,'Syntax\n------\n\nCEILING(X)\n\nDescription\n-----------\n\nReturns the smallest integer value not less than X.\n\nExamples\n--------\n\nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n|             -1 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/ceiling/','','https://mariadb.com/kb/en/ceiling/'),(51,'COS',4,'Syntax\n------\n\nCOS(X)\n\nDescription\n-----------\n\nReturns the cosine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n|        -1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/cos/','','https://mariadb.com/kb/en/cos/'),(52,'COT',4,'Syntax\n------\n\nCOT(X)\n\nDescription\n-----------\n\nReturns the cotangent of X.\n\nExamples\n--------\n\nSELECT COT(42);\n+--------------------+\n| COT(42)            |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n\nSELECT COT(12);\n+---------------------+\n| COT(12)             |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n\nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in \'cot(0)\'\n\nURL: https://mariadb.com/kb/en/cot/','','https://mariadb.com/kb/en/cot/'),(54,'DEGREES',4,'Syntax\n------\n\nDEGREES(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from radians to degrees.\n\nThis is the converse of the RADIANS() function.\n\nExamples\n--------\n\nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n|           180 |\n+---------------+\n\nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n|                90 |\n+-------------------+\n\nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45)     |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/degrees/','','https://mariadb.com/kb/en/degrees/'),(55,'EXP',4,'Syntax\n------\n\nEXP(X)\n\nDescription\n-----------\n\nReturns the value of e (the base of natural logarithms) raised to the power of\nX. The inverse of this function is LOG() (using a single argument only) or\nLN().\n\nIf X is NULL, this function returns NULL.\n\nExamples\n--------\n\nSELECT EXP(2);\n+------------------+\n| EXP(2)           |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n\nSELECT EXP(-2);\n+--------------------+\n| EXP(-2)            |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n\nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n|      1 |\n+--------+\n\nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/exp/','','https://mariadb.com/kb/en/exp/'),(50,'CONV',4,'Syntax\n------\n\nCONV(N,from_base,to_base)\n\nDescription\n-----------\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base to_base.\n\nReturns NULL if any argument is NULL, or if the second or third argument are\nnot in the allowed range.\n\nThe argument N is interpreted as an integer, but may be specified as an\ninteger or a string. The minimum base is 2 and the maximum base is 36. If\nto_base is a negative number, N is regarded as a signed number. Otherwise, N\nis treated as unsigned. CONV() works with 64-bit precision.\n\nSome shortcuts for this function are also available: BIN(), OCT(), HEX(),\nUNHEX(). Also, MariaDB allows binary literal values and hexadecimal literal\nvalues.\n\nExamples\n--------\n\nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010           |\n+----------------+\n\nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172             |\n+-----------------+\n\nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H               |\n+------------------+\n\nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42                           |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/conv/','','https://mariadb.com/kb/en/conv/'),(53,'CRC32',4,'Syntax\n------\n\n<= MariaDB 10.7\n\nCRC32(expr)\n\nFrom MariaDB 10.8\n\nCRC32([par,]expr)\n\nDescription\n-----------\n\nComputes a cyclic redundancy check (CRC) value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is expected to\nbe a string and (if possible) is treated as one if it is not.\n\nUses the ISO 3309 polynomial that used by zlib and many others. MariaDB 10.8\nintroduced the CRC32C() function, which uses the alternate Castagnoli\npolynomia.\n\nMariaDB starting with 10.8\n--------------------------\nOften, CRC is computed in pieces. To facilitate this, MariaDB 10.8.0\nintroduced an optional parameter: CRC32(\'MariaDB\')=CRC32(CRC32(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n|       4227209140 |\n+------------------+\n\nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n|       2594253378 |\n+------------------+\n\nFrom MariaDB 10.8.0\n\nSELECT CRC32(CRC32(\'Maria\'),\'DB\');\n+----------------------------+\n| CRC32(CRC32(\'Maria\'),\'DB\') |\n+----------------------------+\n|                 4227209140 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/crc32/','','https://mariadb.com/kb/en/crc32/'),(56,'FLOOR',4,'Syntax\n------\n\nFLOOR(X)\n\nDescription\n-----------\n\nReturns the largest integer value not greater than X.\n\nExamples\n--------\n\nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n|           -2 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/floor/','','https://mariadb.com/kb/en/floor/'),(57,'LN',4,'Syntax\n------\n\nLN(X)\n\nDescription\n-----------\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X. If X\nis less than or equal to 0, or NULL, then NULL is returned.\n\nThe inverse of this function is EXP().\n\nExamples\n--------\n\nSELECT LN(2);\n+-------------------+\n| LN(2)             |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n|   NULL |\n+--------+\n\nURL: https://mariadb.com/kb/en/ln/','','https://mariadb.com/kb/en/ln/'),(58,'LOG',4,'Syntax\n------\n\nLOG(X), LOG(B,X)\n\nDescription\n-----------\n\nIf called with one parameter, this function returns the natural logarithm of\nX. If X is less than or equal to 0, then NULL is returned.\n\nIf called with two parameters, it returns the logarithm of X to the base B. If\nB is <= 1 or X <= 0, the function returns NULL.\n\nIf any argument is NULL, the function returns NULL.\n\nThe inverse of this function (when called with a single argument) is the EXP()\nfunction.\n\nExamples\n--------\n\nLOG(X):\n\nSELECT LOG(2);\n+-------------------+\n| LOG(2)            |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LOG(-2);\n+---------+\n| LOG(-2) |\n+---------+\n|    NULL |\n+---------+\n\nLOG(B,X)\n\nSELECT LOG(2,16);\n+-----------+\n| LOG(2,16) |\n+-----------+\n|         4 |\n+-----------+\n\nSELECT LOG(3,27);\n+-----------+\n| LOG(3,27) |\n+-----------+\n|         3 |\n+-----------+\n\nSELECT LOG(3,1);\n+----------+\n| LOG(3,1) |\n+----------+\n|        0 |\n+----------+\n\nSELECT LOG(3,0);\n+----------+\n| LOG(3,0) |\n+----------+\n|     NULL |\n+----------+\n\nURL: https://mariadb.com/kb/en/log/','','https://mariadb.com/kb/en/log/'),(59,'LOG10',4,'Syntax\n------\n\nLOG10(X)\n\nDescription\n-----------\n\nReturns the base-10 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG10(2);\n+-------------------+\n| LOG10(2)          |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n\nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n|          2 |\n+------------+\n\nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/log10/','','https://mariadb.com/kb/en/log10/'),(60,'LOG2',4,'Syntax\n------\n\nLOG2(X)\n\nDescription\n-----------\n\nReturns the base-2 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n|                  42 |\n+---------------------+\n\nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n|          16 |\n+-------------+\n\nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n|       NULL |\n+------------+\n\nURL: https://mariadb.com/kb/en/log2/','','https://mariadb.com/kb/en/log2/'),(62,'OCT',4,'Syntax\n------\n\nOCT(N)\n\nDescription\n-----------\n\nReturns a string representation of the octal value of N, where N is a longlong\n(BIGINT) number. This is equivalent to CONV(N,10,8). Returns NULL if N is NULL.\n\nExamples\n--------\n\nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42      |\n+---------+\n\nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14      |\n+---------+\n\nURL: https://mariadb.com/kb/en/oct/','','https://mariadb.com/kb/en/oct/'),(63,'PI',4,'Syntax\n------\n\nPI()\n\nDescription\n-----------\n\nReturns the value of π (pi). The default number of decimal places displayed is\nsix, but MariaDB uses the full double-precision value internally.\n\nExamples\n--------\n\nSELECT PI();\n+----------+\n| PI()     |\n+----------+\n| 3.141593 |\n+----------+\n\nSELECT PI()+0.0000000000000000000000;\n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n|      3.1415926535897931159980 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/pi/','','https://mariadb.com/kb/en/pi/'),(64,'POW',4,'Syntax\n------\n\nPOW(X,Y)\n\nDescription\n-----------\n\nReturns the value of X raised to the power of Y.\n\nPOWER() is a synonym.\n\nExamples\n--------\n\nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n|        8 |\n+----------+\n\nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n|      0.25 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/pow/','','https://mariadb.com/kb/en/pow/'),(65,'POWER',4,'Syntax\n------\n\nPOWER(X,Y)\n\nDescription\n-----------\n\nThis is a synonym for POW(), which returns the value of X raised to the power\nof Y.\n\nURL: https://mariadb.com/kb/en/power/','','https://mariadb.com/kb/en/power/'),(61,'MOD',4,'Syntax\n------\n\nMOD(N,M), N % M, N MOD M\n\nDescription\n-----------\n\nModulo operation. Returns the remainder of N divided by M. See also Modulo\nOperator.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any number modulus zero\nproduces an error. Otherwise, it returns NULL.\n\nThe integer part of a division can be obtained using DIV.\n\nExamples\n--------\n\nSELECT 1042 % 50;\n+-----------+\n| 1042 % 50 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n|            4 |\n+--------------+\n\nSELECT 253 % 7;\n+---------+\n| 253 % 7 |\n+---------+\n|       1 |\n+---------+\n\nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n|         2 |\n+-----------+\n\nSELECT 29 MOD 9;\n+----------+\n| 29 MOD 9 |\n+----------+\n|        2 |\n+----------+\n\nURL: https://mariadb.com/kb/en/mod/','','https://mariadb.com/kb/en/mod/'),(66,'RADIANS',4,'Syntax\n------\n\nRADIANS(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from degrees to radians. Note that π radians\nequals 180 degrees.\n\nThis is the converse of the DEGREES() function.\n\nExamples\n--------\n\nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45)       |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n\nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90)     |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI())      |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n\nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180)     |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/radians/','','https://mariadb.com/kb/en/radians/'),(67,'RAND',4,'Syntax\n------\n\nRAND(), RAND(N)\n\nDescription\n-----------\n\nReturns a random DOUBLE precision floating point value v in the range 0 <= v <\n1.0. If a constant integer argument N is specified, it is used as the seed\nvalue, which produces a repeatable sequence of column values. In the example\nbelow, note that the sequences of values produced by RAND(3) is the same both\nplaces where it occurs.\n\nIn a WHERE clause, RAND() is evaluated each time the WHERE is executed.\n\nStatements using the RAND() function are not safe for statement-based\nreplication.\n\nPractical uses\n--------------\n\nThe expression to get a random integer from a given range is the following:\n\nFLOOR(min_value + RAND() * (max_value - min_value +1))\n\nRAND() is often used to read random rows from a table, as follows:\n\nSELECT * FROM my_table ORDER BY RAND() LIMIT 10;\n\nNote, however, that this technique should never be used on a large table as it\nwill be extremely slow. MariaDB will read all rows in the table, generate a\nrandom value for each of them, order them, and finally will apply the LIMIT\nclause.\n\nExamples\n--------\n\nCREATE TABLE t (i INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.255651095188829 |\n|    2 | 0.833920199269355 |\n|    3 |  0.40264774151393 |\n+------+-------------------+\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.511478140495232 |\n|    2 | 0.349447508668012 |\n|    3 | 0.212803152588013 |\n+------+-------------------+\n\nUsing the same seed, the same sequence will be returned:\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nGenerating a random number from 5 to 15:\n\nSELECT FLOOR(5 + (RAND() * 11));\n\nURL: https://mariadb.com/kb/en/rand/','','https://mariadb.com/kb/en/rand/'),(68,'ROUND',4,'Syntax\n------\n\nROUND(X), ROUND(X,D)\n\nDescription\n-----------\n\nRounds the argument X to D decimal places. D defaults to 0 if not specified. D\ncan be negative to cause D digits left of the decimal point of the value X to\nbecome zero.\n\nThe rounding algorithm depends on the data type of X:\n\n* for floating point types (FLOAT, DOUBLE) the C libraries rounding function\nis used, so the behavior *may* differ between operating systems\n* for fixed point types (DECIMAL, DEC/NUMBER/FIXED) the \"round half up\" rule\nis used, meaning that e.g. a value ending in exactly .5 is always rounded up.\n\nExamples\n--------\n\nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n|           -1 |\n+--------------+\n\nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n|           -2 |\n+--------------+\n\nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n|           2 |\n+-------------+\n\nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n|             1.3 |\n+-----------------+\n\nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n|                20 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/round/','','https://mariadb.com/kb/en/round/'),(69,'SIGN',4,'Syntax\n------\n\nSIGN(X)\n\nDescription\n-----------\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X is\nnegative, zero, or positive.\n\nExamples\n--------\n\nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n|        -1 |\n+-----------+\n\nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n|       0 |\n+---------+\n\nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/sign/','','https://mariadb.com/kb/en/sign/'),(70,'SIN',4,'Syntax\n------\n\nSIN(X)\n\nDescription\n-----------\n\nReturns the sine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT SIN(PI());\n+----------------------+\n| SIN(PI())            |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n\nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n|                0 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/sin/','','https://mariadb.com/kb/en/sin/'),(71,'SQRT',4,'Syntax\n------\n\nSQRT(X)\n\nDescription\n-----------\n\nReturns the square root of X. If X is negative, NULL is returned.\n\nExamples\n--------\n\nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n|       2 |\n+---------+\n\nSELECT SQRT(20);\n+------------------+\n| SQRT(20)         |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n\nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n|         42 |\n+------------+\n\nURL: https://mariadb.com/kb/en/sqrt/','','https://mariadb.com/kb/en/sqrt/'),(72,'TAN',4,'Syntax\n------\n\nTAN(X)\n\nDescription\n-----------\n\nReturns the tangent of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n|      0.9999999999999999 |\n+-------------------------+\n\nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI())             |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n\nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1)     |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n\nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/tan/','','https://mariadb.com/kb/en/tan/'),(73,'TRUNCATE',4,'This page documents the TRUNCATE function. See TRUNCATE TABLE for the DDL\nstatement.\n\nSyntax\n------\n\nTRUNCATE(X,D)\n\nDescription\n-----------\n\nReturns the number X, truncated to D decimal places. If D is 0, the result has\nno decimal point or fractional part. D can be negative to cause D digits left\nof the decimal point of the value X to become zero.\n\nExamples\n--------\n\nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n|               1.2 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n|               1.9 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n|               -1.9 |\n+--------------------+\n\nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n|              100 |\n+------------------+\n\nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n|                  1028 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/truncate/','','https://mariadb.com/kb/en/truncate/'),(74,'INSTALL PLUGIN',5,'Syntax\n------\n\nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement installs an individual plugin from the specified library. To\ninstall the whole library (which could be required), use INSTALL SONAME. See\nalso Installing a Plugin.\n\nplugin_name is the name of the plugin as defined in the plugin declaration\nstructure contained in the library file. Plugin names are not case sensitive.\nFor maximal compatibility, plugin names should be limited to ASCII letters,\ndigits, and underscore, because they are used in C source files, shell command\nlines, M4 and Bourne shell scripts, and SQL environments.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension can be omitted (which makes the statement look\nthe same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nINSTALL PLUGIN causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nPLUGIN only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a note instead of\nan error if the specified plugin already exists. See SHOW WARNINGS.\n\nExamples\n--------\n\nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n\nThe extension can also be omitted:\n\nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected (0.104 sec)\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------+\n| Level | Code | Message                            |\n+-------+------+------------------------------------+\n| Note  | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n\nURL: https://mariadb.com/kb/en/install-plugin/','','https://mariadb.com/kb/en/install-plugin/'),(78,'Plugin Overview',5,'Plugins are server components that enhance MariaDB in some way. These can be\nanything from new storage engines, plugins for enhancing full-text parsing, or\neven small enhancements, such as a plugin to get a timestamp as an integer.\n\nQuerying Plugin Information\n---------------------------\n\nThere are a number of ways to see which plugins are currently active.\n\nA server almost always has a large number of active plugins, because the\nserver contains a large number of built-in plugins, which are active by\ndefault and cannot be uninstalled.\n\nQuerying Plugin Information with SHOW PLUGINS\n---------------------------------------------\n\nThe SHOW PLUGINS statement can be used to query information about all active\nplugins.\n\nFor example:\n\nSHOW PLUGINS\\G;\n********************** 1. row **********************\n Name: binlog\n Status: ACTIVE\n Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n********************** 2. row **********************\n Name: mysql_native_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n********************** 3. row **********************\n Name: mysql_old_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n...\n\nIf a plugin\'s Library column has a NULL value, then the plugin is built-in,\nand it cannot be uninstalled.\n\nQuerying Plugin Information with information_schema.PLUGINS\n-----------------------------------------------------------\n\nThe information_schema.PLUGINS table can be queried to get more detailed\ninformation about plugins.\n\nFor example:\n\nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row ***************************\n     PLUGIN_NAME: CSV\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: Brian Aker, MySQL AB\n  PLUGIN_DESCRIPTION: CSV storage engine\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row ***************************\n     PLUGIN_NAME: MEMORY\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: MySQL AB\n  PLUGIN_DESCRIPTION: Hash based, stored in memory, useful for temporary\ntables\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n\nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value, then the plugin is\nbuilt-in, and it cannot be uninstalled.\n\nQuerying Plugin Information with mysql.plugin\n---------------------------------------------\n\nThe mysql.plugin table can be queried to get information about installed\nplugins.\n\nThis table only contains information about plugins that have been installed\nvia the following methods:\n\n* The INSTALL SONAME statement.\n* The INSTALL PLUGIN statement.\n* The mysql_plugin utility.\n\nThis table does not contain information about:\n\n* Built-in plugins.\n* Plugins loaded with the --plugin-load-add option.\n* Plugins loaded with the --plugin-load option.\n\nThis table only contains enough information to reload the plugin when the\nserver is restarted, which means it only contains the plugin name and the\nplugin library.\n\nFor example:\n\nSELECT * FROM mysql.plugin;\n\n+------+------------+\n| name | dl         |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n\nInstalling a Plugin\n-------------------\n\nThere are three primary ways to install a plugin:\n\n* A plugin can be installed dynamically with an SQL statement.\n* A plugin can be installed with a mysqld option, but it requires a server\nrestart.\n* A plugin can be installed with the mysql_plugin utility, while the server is\ncompletely offline.\n\nWhen you are installing a plugin, you also have to ensure that:\n\n* The server\'s plugin directory is properly configured, and the plugin\'s\nlibrary is in the plugin directory.\n* The server\'s minimum plugin maturity is properly configured, and the plugin\nis mature enough to be installed.\n\nInstalling a Plugin Dynamically\n-------------------------------\n\nA plugin can be installed dynamically by executing either the INSTALL SONAME\nor the INSTALL PLUGIN statement.\n\nIf a plugin is installed with one of these statements, then a record will be\nadded to the mysql.plugins table for the plugin. This means that the plugin\nwill automatically be loaded every time the server restarts, unless\nspecifically uninstalled or deactivated.\n\nInstalling a Plugin with INSTALL SONAME\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL SONAME\nstatement. INSTALL SONAME installs all plugins from the given plugin library.\nThis could be required for some plugin libraries.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin), you could execute the\nfollowing:\n\nINSTALL SONAME \'server_audit\';\n\nInstalling a Plugin with INSTALL PLUGIN\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL PLUGIN\nstatement. INSTALL PLUGIN installs a single plugin from the given plugin\nlibrary.\n\nFor example, to install the server_audit audit plugin from the server_audit\nplugin library, you could execute the following:\n\nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n\nInstalling a Plugin with Plugin Load Options\n--------------------------------------------\n\nA plugin can be installed with a mysqld option by providing either the\n--plugin-load-add or the --plugin-load option.\n\nIf a plugin is installed with one of these options, then a record will not be\nadded to the mysql.plugins table for the plugin. This means that if the server\nis restarted without the same option set, then the plugin will not\nautomatically be loaded.\n\nInstalling a Plugin with --plugin-load-add\n------------------------------------------\n\nYou can install a plugin with the --plugin-load-add option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load-add option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nSpecial care must be taken when specifying both the --plugin-load option and\nthe --plugin-load-add option together. The --plugin-load option resets the\nplugin load list, and this can cause unexpected problems if you are not aware.\nThe --plugin-load-add option does not reset the plugin load list, so it is\nmuch safer to use. See Specifying Multiple Plugin Load Options for more\ninformation.\n\nInstalling a Plugin with --plugin-load\n--------------------------------------\n\nYou can install a plugin with the --plugin-load option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load=\'server_audit;ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option together. The --plugin-load option resets the plugin\nload list, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use. See Specifying Multiple Plugin Load Options for more information.\n\nSpecifying Multiple Plugin Load Options\n---------------------------------------\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use.\n\nThis can have the following consequences:\n\n* If the --plugin-load option is specified multiple times, then only the last\ninstance will have any effect. For example, in the following case, the first\ninstance of the option is reset:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* If the --plugin-load option is specified after the --plugin-load-add option,\nthen it will also reset the changes made by that option. For example, in the\nfollowing case, the --plugin-load-add option does not do anything, because the\nsubsequent --plugin-load option resets the plugin load list:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* In contrast, if the --plugin-load option is specified before the\n--plugin-load-add option, then it will work fine, because the\n--plugin-load-add option does not reset the plugin load list. For example, in\nthe following case, both plugins are properly loaded:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nInstalling a Plugin with mysql_plugin\n----------