/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('772eed46-2e22-4e3d-a1b2-dcba5321f582','2026-01-21 11:27:07','2026-01-21 11:27:07',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
INSERT INTO `encryption` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `cipher`, `control_location`, `key_size`, `provider`, `volume_type_id`, `encryption_id`) VALUES ('2026-01-21 11:51:17','2026-01-21 11:51:27','2026-01-21 11:51:27',1,'aes-cbc-essiv','front-end',256,'nova.volume.encryptors.luks.LuksEncryptor','d47944a7-10e8-4c29-b037-5e146aa0d6af','f7205663-2b2e-4bc6-abd5-c3d0020ce537');
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'consistent_group_snapshot_enabled','<is> True','0fb8fb75-08c2-4e0f-9b7e-82fe68f2eca8','2026-01-21 11:26:56','2026-01-21 11:26:56',NULL,0);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('0fb8fb75-08c2-4e0f-9b7e-82fe68f2eca8','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2026-01-21 11:26:56','2026-01-21 11:26:56',NULL,0,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`),
  KEY `ix_image_volume_cache_entries_host` (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2026-01-21 11:26:56',NULL,NULL,0,1,'default','volumes',10),('2026-01-21 11:26:56',NULL,NULL,0,2,'default','snapshots',10),('2026-01-21 11:26:56',NULL,NULL,0,3,'default','gigabytes',1000),('2026-01-21 11:26:56',NULL,NULL,0,4,'default','consistencygroups',10),('2026-01-21 11:26:56',NULL,NULL,0,5,'default','per_volume_gigabytes',-1),('2026-01-21 11:26:56',NULL,NULL,0,6,'default','groups',10);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`,`race_preventer`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2026-01-21 11:27:04','2026-01-21 12:17:47',NULL,0,1,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',300,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'fa4d39fa-0fa6-4d89-80ee-1ae615a5688f');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2026-01-21 11:26:56','2026-01-21 11:26:56',NULL,0,'7d164010-a362-4dbe-8d37-ffbbf93982a9','__DEFAULT__',NULL,1,'Default Volume Type'),('2026-01-21 11:51:17',NULL,'2026-01-21 11:51:27',1,'d47944a7-10e8-4c29-b037-5e146aa0d6af','LUKS',NULL,1,NULL);
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2026-01-21 11:26:56','2026-01-21 11:26:56.000123',NULL,0,1,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (1,'72c09ccb-dfdf-460c-ac3a-9d637d6339b1','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/72c09ccb-dfdf-460c-ac3a-9d637d6339b1','2026-01-21 11:48:19','2026-01-21 11:48:19',NULL,0,'{\"store\": \"default_backend\"}','active'),(2,'a9e15625-47e3-44b5-b241-d2da0e923282','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/a9e15625-47e3-44b5-b241-d2da0e923282','2026-01-21 11:48:20','2026-01-21 11:48:20',NULL,0,'{\"store\": \"default_backend\"}','active');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'72c09ccb-dfdf-460c-ac3a-9d637d6339b1','hw_rng_model','virtio','2026-01-21 11:48:18','2026-01-21 11:48:18',NULL,0),(2,'a9e15625-47e3-44b5-b241-d2da0e923282','hw_rng_model','virtio','2026-01-21 11:48:19','2026-01-21 11:48:19',NULL,0);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('72c09ccb-dfdf-460c-ac3a-9d637d6339b1','cirros-0.6.2-x86_64-disk.img',21430272,'active','2026-01-21 11:48:18','2026-01-21 11:48:19',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','8d6df07ed5c54b3ebd7550a0bf0138aa',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('a9e15625-47e3-44b5-b241-d2da0e923282','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2026-01-21 11:48:19','2026-01-21 11:48:20',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','8d6df07ed5c54b3ebd7550a0bf0138aa',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b');
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (1,1,'image','CIM_PASD_','2026-01-21 11:25:59',NULL),(1,2,'image','CIM_RASD_','2026-01-21 11:25:59',NULL),(1,3,NULL,'CIM_SASD_','2026-01-21 11:25:59',NULL),(1,9,'image','hw_','2026-01-21 11:26:00',NULL),(1,10,'image','hw_','2026-01-21 11:26:00',NULL),(1,14,'image',NULL,'2026-01-21 11:26:00',NULL),(1,19,'image','hw_','2026-01-21 11:26:00',NULL),(1,25,'image','hw_','2026-01-21 11:26:00',NULL),(1,29,'image',NULL,'2026-01-21 11:26:00',NULL),(1,30,'image',NULL,'2026-01-21 11:26:00',NULL),(1,31,'image',NULL,'2026-01-21 11:26:00',NULL),(1,32,'image',NULL,'2026-01-21 11:26:00',NULL),(2,1,NULL,'CIM_PASD_','2026-01-21 11:25:59',NULL),(2,8,NULL,'hw_','2026-01-21 11:26:00',NULL),(2,9,NULL,'hw_','2026-01-21 11:26:00',NULL),(2,10,NULL,'hw_','2026-01-21 11:26:00',NULL),(2,11,NULL,NULL,'2026-01-21 11:26:00',NULL),(2,13,NULL,NULL,'2026-01-21 11:26:00',NULL),(2,14,NULL,NULL,'2026-01-21 11:26:00',NULL),(2,15,NULL,NULL,'2026-01-21 11:26:00',NULL),(2,16,NULL,'hw_','2026-01-21 11:26:00',NULL),(2,19,NULL,'hw_','2026-01-21 11:26:00',NULL),(2,22,NULL,NULL,'2026-01-21 11:26:00',NULL),(2,23,NULL,'hw_','2026-01-21 11:26:00',NULL),(2,24,NULL,'traits:','2026-01-21 11:26:00',NULL),(2,25,NULL,'hw_','2026-01-21 11:26:00',NULL),(2,26,NULL,NULL,'2026-01-21 11:26:00',NULL),(2,28,NULL,NULL,'2026-01-21 11:26:00',NULL),(2,29,NULL,NULL,'2026-01-21 11:26:00',NULL),(2,30,NULL,NULL,'2026-01-21 11:26:00',NULL),(2,31,NULL,NULL,'2026-01-21 11:26:00',NULL),(2,32,NULL,NULL,'2026-01-21 11:26:00',NULL),(2,33,NULL,'cinder_','2026-01-21 11:26:00',NULL),(3,1,NULL,'CIM_PASD_','2026-01-21 11:25:59',NULL),(3,2,NULL,'CIM_RASD_','2026-01-21 11:25:59',NULL),(3,3,NULL,'CIM_SASD_','2026-01-21 11:25:59',NULL),(3,4,NULL,'CIM_VSSD_','2026-01-21 11:25:59',NULL),(3,5,NULL,NULL,'2026-01-21 11:26:00',NULL),(3,6,NULL,NULL,'2026-01-21 11:26:00',NULL),(3,7,NULL,NULL,'2026-01-21 11:26:00',NULL),(3,12,NULL,'aggregate_instance_extra_specs:','2026-01-21 11:26:00',NULL),(4,1,NULL,'CIM_PASD_','2026-01-21 11:25:59',NULL),(4,2,NULL,'CIM_RASD_','2026-01-21 11:25:59',NULL),(4,3,NULL,'CIM_SASD_','2026-01-21 11:25:59',NULL),(4,4,NULL,'CIM_VSSD_','2026-01-21 11:25:59',NULL),(4,8,NULL,'hw:','2026-01-21 11:26:00',NULL),(4,9,NULL,'hw:','2026-01-21 11:26:00',NULL),(4,10,NULL,'hw:','2026-01-21 11:26:00',NULL),(4,12,NULL,'capabilities:','2026-01-21 11:26:00',NULL),(4,16,NULL,'hw:','2026-01-21 11:26:00',NULL),(4,17,NULL,NULL,'2026-01-21 11:26:00',NULL),(4,18,NULL,NULL,'2026-01-21 11:26:00',NULL),(4,19,NULL,'hw:','2026-01-21 11:26:00',NULL),(4,20,NULL,NULL,'2026-01-21 11:26:00',NULL),(4,21,NULL,NULL,'2026-01-21 11:26:00',NULL),(4,23,NULL,'hw:','2026-01-21 11:26:00',NULL),(4,24,NULL,'traits:','2026-01-21 11:26:00',NULL),(4,25,NULL,'hw:','2026-01-21 11:26:00',NULL),(5,1,'scheduler_hints',NULL,'2026-01-21 11:25:59',NULL),(5,30,'metadata',NULL,'2026-01-21 11:26:00',NULL),(5,31,'metadata',NULL,'2026-01-21 11:26:00',NULL),(5,32,'metadata',NULL,'2026-01-21 11:26:00',NULL),(6,30,NULL,NULL,'2026-01-21 11:26:00',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (1,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2026-01-21 11:25:59',NULL),(2,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2026-01-21 11:25:59',NULL),(3,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2026-01-21 11:25:59',NULL),(4,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2026-01-21 11:25:59',NULL),(5,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2026-01-21 11:26:00',NULL),(6,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2026-01-21 11:26:00',NULL),(7,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2026-01-21 11:26:00',NULL),(8,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2026-01-21 11:26:00',NULL),(9,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2026-01-21 11:26:00',NULL),(10,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2026-01-21 11:26:00',NULL),(11,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2026-01-21 11:26:00',NULL),(12,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2026-01-21 11:26:00',NULL),(13,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2026-01-21 11:26:00',NULL),(14,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2026-01-21 11:26:00',NULL),(15,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-21 11:26:00',NULL),(16,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-21 11:26:00',NULL),(17,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-21 11:26:00',NULL),(18,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2026-01-21 11:26:00',NULL),(19,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2026-01-21 11:26:00',NULL),(20,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-21 11:26:00',NULL),(21,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-21 11:26:00',NULL),(22,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-21 11:26:00',NULL),(23,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2026-01-21 11:26:00',NULL),(24,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2026-01-21 11:26:00',NULL),(25,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-21 11:26:00',NULL),(26,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-21 11:26:00',NULL),(27,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2026-01-21 11:26:00',NULL),(28,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2026-01-21 11:26:00',NULL),(29,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2026-01-21 11:26:00',NULL),(30,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2026-01-21 11:26:00',NULL),(31,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2026-01-21 11:26:00',NULL),(32,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2026-01-21 11:26:00',NULL),(33,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2026-01-21 11:26:00',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (1,17,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2026-01-21 11:26:00',NULL),(2,17,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2026-01-21 11:26:00',NULL),(3,17,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2026-01-21 11:26:00',NULL),(4,30,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2026-01-21 11:26:00',NULL),(5,30,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2026-01-21 11:26:00',NULL),(6,30,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2026-01-21 11:26:00',NULL),(7,30,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2026-01-21 11:26:00',NULL),(8,30,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-01-21 11:26:00',NULL),(9,30,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-01-21 11:26:00',NULL),(10,30,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2026-01-21 11:26:00',NULL),(11,30,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2026-01-21 11:26:00',NULL),(12,30,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-01-21 11:26:00',NULL),(13,30,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2026-01-21 11:26:00',NULL),(14,30,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2026-01-21 11:26:00',NULL),(15,30,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2026-01-21 11:26:00',NULL),(16,31,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2026-01-21 11:26:00',NULL),(17,31,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2026-01-21 11:26:00',NULL),(18,31,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2026-01-21 11:26:00',NULL),(19,31,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2026-01-21 11:26:00',NULL),(20,31,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2026-01-21 11:26:00',NULL),(21,32,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-01-21 11:26:00',NULL),(22,32,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-01-21 11:26:00',NULL),(23,32,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-01-21 11:26:00',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (1,1,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2026-01-21 11:25:59',NULL),(2,1,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2026-01-21 11:25:59',NULL),(3,1,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2026-01-21 11:25:59',NULL),(4,2,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2026-01-21 11:25:59',NULL),(5,2,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2026-01-21 11:25:59',NULL),(6,2,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2026-01-21 11:25:59',NULL),(7,2,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2026-01-21 11:25:59',NULL),(8,2,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2026-01-21 11:25:59',NULL),(9,2,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2026-01-21 11:25:59',NULL),(10,2,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2026-01-21 11:25:59',NULL),(11,2,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2026-01-21 11:25:59',NULL),(12,2,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2026-01-21 11:25:59',NULL),(13,2,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2026-01-21 11:25:59',NULL),(14,2,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2026-01-21 11:25:59',NULL),(15,2,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2026-01-21 11:25:59',NULL),(16,2,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2026-01-21 11:25:59',NULL),(17,2,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2026-01-21 11:25:59',NULL),(18,2,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2026-01-21 11:25:59',NULL),(19,2,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2026-01-21 11:25:59',NULL),(20,2,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2026-01-21 11:25:59',NULL),(21,2,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2026-01-21 11:25:59',NULL),(22,2,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2026-01-21 11:25:59',NULL),(23,3,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2026-01-21 11:25:59',NULL),(24,3,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2026-01-21 11:25:59',NULL),(25,3,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2026-01-21 11:25:59',NULL),(26,3,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2026-01-21 11:25:59',NULL),(27,3,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2026-01-21 11:25:59',NULL),(28,3,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2026-01-21 11:25:59',NULL),(29,3,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2026-01-21 11:25:59',NULL),(30,3,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2026-01-21 11:25:59',NULL),(31,3,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2026-01-21 11:25:59',NULL),(32,3,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2026-01-21 11:25:59',NULL),(33,3,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2026-01-21 11:25:59',NULL),(34,3,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2026-01-21 11:25:59',NULL),(35,3,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2026-01-21 11:25:59',NULL),(36,4,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2026-01-21 11:25:59',NULL),(37,4,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2026-01-21 11:25:59',NULL),(38,4,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2026-01-21 11:25:59',NULL),(39,4,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2026-01-21 11:25:59',NULL),(40,4,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2026-01-21 11:25:59',NULL),(41,4,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL),(42,4,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL),(43,4,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL),(44,4,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL),(45,4,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL),(46,4,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL),(47,4,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL),(48,4,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL),(49,4,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL),(50,4,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL),(51,4,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL),(52,4,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL),(53,5,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2026-01-21 11:26:00',NULL),(54,6,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2026-01-21 11:26:00',NULL),(55,7,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2026-01-21 11:26:00',NULL),(56,8,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2026-01-21 11:26:00',NULL),(57,9,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2026-01-21 11:26:00',NULL),(58,9,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2026-01-21 11:26:00',NULL),(59,10,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL),(60,11,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-21 11:26:00',NULL),(61,12,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2026-01-21 11:26:00',NULL),(62,12,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2026-01-21 11:26:00',NULL),(63,12,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2026-01-21 11:26:00',NULL),(64,12,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-01-21 11:26:00',NULL),(65,12,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-01-21 11:26:00',NULL),(66,12,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-01-21 11:26:00',NULL),(67,12,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2026-01-21 11:26:00',NULL),(68,13,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2026-01-21 11:26:00',NULL),(69,13,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2026-01-21 11:26:00',NULL),(70,14,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2026-01-21 11:26:00',NULL),(71,14,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-01-21 11:26:00',NULL),(72,15,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2026-01-21 11:26:00',NULL),(73,15,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2026-01-21 11:26:00',NULL),(74,15,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2026-01-21 11:26:00',NULL),(75,15,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2026-01-21 11:26:00',NULL),(76,15,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL),(77,15,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2026-01-21 11:26:00',NULL),(78,15,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\", \"bochs\"]}','2026-01-21 11:26:00',NULL),(79,15,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-21 11:26:00',NULL),(80,15,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL),(81,15,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2026-01-21 11:26:00',NULL),(82,15,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, virtio, e1000e and vmxnet3. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\", \"vmxnet3\"]}','2026-01-21 11:26:00',NULL),(83,15,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-21 11:26:00',NULL),(84,15,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-21 11:26:00',NULL),(85,15,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-01-21 11:26:00',NULL),(86,15,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2026-01-21 11:26:00',NULL),(87,15,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-01-21 11:26:00',NULL),(88,16,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-21 11:26:00',NULL),(89,16,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-21 11:26:00',NULL),(90,16,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-21 11:26:00',NULL),(91,18,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2026-01-21 11:26:00',NULL),(92,18,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2026-01-21 11:26:00',NULL),(93,18,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2026-01-21 11:26:00',NULL),(94,19,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2026-01-21 11:26:00',NULL),(95,19,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2026-01-21 11:26:00',NULL),(96,19,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2026-01-21 11:26:00',NULL),(97,19,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2026-01-21 11:26:00',NULL),(98,19,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2026-01-21 11:26:00',NULL),(99,19,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2026-01-21 11:26:00',NULL),(100,20,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2026-01-21 11:26:00',NULL),(101,20,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL),(102,21,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-21 11:26:00',NULL),(103,21,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-21 11:26:00',NULL),(104,22,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2026-01-21 11:26:00',NULL),(105,22,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2026-01-21 11:26:00',NULL),(106,22,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2026-01-21 11:26:00',NULL),(107,22,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2026-01-21 11:26:00',NULL),(108,22,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2026-01-21 11:26:00',NULL),(109,22,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-21 11:26:00',NULL),(110,23,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2026-01-21 11:26:00',NULL),(111,24,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2026-01-21 11:26:00',NULL),(112,24,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2026-01-21 11:26:00',NULL),(113,25,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2026-01-21 11:26:00',NULL),(114,26,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2026-01-21 11:26:00',NULL),(115,27,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2026-01-21 11:26:00',NULL),(116,27,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2026-01-21 11:26:00',NULL),(117,27,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2026-01-21 11:26:00',NULL),(118,27,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL),(119,27,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL),(120,27,'hw_cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"This specifies the CPU Mode for the guest vm\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL),(121,27,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL),(122,27,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL),(123,27,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL),(124,27,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2026-01-21 11:26:00',NULL),(125,28,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL),(126,28,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL),(127,28,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2026-01-21 11:26:00',NULL),(128,28,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2026-01-21 11:26:00',NULL),(129,29,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL),(130,29,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL),(131,29,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL),(132,33,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2026-01-21 11:26:00',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (1,'OS::Cinder::Volume',1,'2026-01-21 11:25:59',NULL),(2,'OS::Glance::Image',1,'2026-01-21 11:25:59',NULL),(3,'OS::Nova::Aggregate',1,'2026-01-21 11:25:59',NULL),(4,'OS::Nova::Flavor',1,'2026-01-21 11:25:59',NULL),(5,'OS::Nova::Server',1,'2026-01-21 11:25:59',NULL),(6,'OS::Trove::Instance',1,'2026-01-21 11:26:00',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `heat`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `heat` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `heat`;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `resource_action` varchar(255) DEFAULT NULL,
  `resource_status` varchar(255) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `physical_resource_id` varchar(255) DEFAULT NULL,
  `resource_status_reason` varchar(255) DEFAULT NULL,
  `resource_type` varchar(255) DEFAULT NULL,
  `resource_properties` blob DEFAULT NULL,
  `rsrc_prop_data_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `stack_id` (`stack_id`),
  KEY `ev_rsrc_prop_data_ref` (`rsrc_prop_data_id`),
  CONSTRAINT `ev_rsrc_prop_data_ref` FOREIGN KEY (`rsrc_prop_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `event_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1512 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `event`
--

LOCK TABLES `event` WRITE;
/*!40000 ALTER TABLE `event` DISABLE KEYS */;
INSERT INTO `event` (`id`, `uuid`, `stack_id`, `created_at`, `updated_at`, `resource_action`, `resource_status`, `resource_name`, `physical_resource_id`, `resource_status_reason`, `resource_type`, `resource_properties`, `rsrc_prop_data_id`) VALUES (1,'792b9747-2abb-4cde-8690-c0fd70721399','87791753-832b-4e25-bdb8-97a4781e4260','2026-01-21 11:48:36',NULL,'CREATE','IN_PROGRESS','api-485390504-envstack','87791753-832b-4e25-bdb8-97a4781e4260','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(2,'04681447-3ff0-483c-8f87-fa0352d8409b','d20ca28a-624b-41b3-96e7-a3e77927a0cf','2026-01-21 11:48:36',NULL,'CREATE','IN_PROGRESS','api-1892183375-rsrcstack','d20ca28a-624b-41b3-96e7-a3e77927a0cf','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(3,'ec77439c-9321-4bf7-80ba-a0d94f476728','87791753-832b-4e25-bdb8-97a4781e4260','2026-01-21 11:48:36',NULL,'CREATE','IN_PROGRESS','test','api-485390504-envstack-test-2owollozrcli','state changed','OS::Heat::TestResource',NULL,1),(4,'e5d8aad2-a3d8-499e-b4d8-760e10b85f81','87791753-832b-4e25-bdb8-97a4781e4260','2026-01-21 11:48:36',NULL,'CREATE','COMPLETE','test','api-485390504-envstack-test-2owollozrcli','state changed','OS::Heat::TestResource',NULL,1),(5,'520aa22a-d3d7-4069-9fd4-82f8bb22cc50','87791753-832b-4e25-bdb8-97a4781e4260','2026-01-21 11:48:36',NULL,'CREATE','COMPLETE','api-485390504-envstack','87791753-832b-4e25-bdb8-97a4781e4260','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(6,'8c0bcd7c-a4b8-43c0-92d7-ee2570a6cca7','d20ca28a-624b-41b3-96e7-a3e77927a0cf','2026-01-21 11:48:36',NULL,'CREATE','IN_PROGRESS','test','api-1892183375-rsrcstack-test-mxf3d4frp5kz','state changed','OS::Heat::TestResource',NULL,2),(7,'4f3d355b-e78d-467e-88fd-8306ef1a4464','d20ca28a-624b-41b3-96e7-a3e77927a0cf','2026-01-21 11:48:36',NULL,'CREATE','COMPLETE','test','api-1892183375-rsrcstack-test-mxf3d4frp5kz','state changed','OS::Heat::TestResource',NULL,2),(8,'c629d164-2d24-4339-8407-f6447eff78c9','d20ca28a-624b-41b3-96e7-a3e77927a0cf','2026-01-21 11:48:36',NULL,'CREATE','COMPLETE','api-1892183375-rsrcstack','d20ca28a-624b-41b3-96e7-a3e77927a0cf','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(9,'405e24d4-3add-4f63-957b-bf2de3903077','cb36b365-7a1d-4fe1-bc43-ac090d0aecde','2026-01-21 11:48:36',NULL,'CREATE','IN_PROGRESS','api-2116806331-rsrcstack','cb36b365-7a1d-4fe1-bc43-ac090d0aecde','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(10,'1a712039-0f10-4d5e-810a-6ed6fd2d7baa','67276495-f395-43ca-a615-65805149eefd','2026-01-21 11:48:36',NULL,'CREATE','IN_PROGRESS','api-736530183-envstack','67276495-f395-43ca-a615-65805149eefd','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(11,'17d087af-08f6-4a7d-9461-3d82d2861996','cb36b365-7a1d-4fe1-bc43-ac090d0aecde','2026-01-21 11:48:36',NULL,'CREATE','IN_PROGRESS','test','api-2116806331-rsrcstack-test-2ermiswyp5mp','state changed','OS::Heat::TestResource',NULL,3),(12,'a50b136a-68f1-4cb7-846a-f2f2ace78feb','cb36b365-7a1d-4fe1-bc43-ac090d0aecde','2026-01-21 11:48:36',NULL,'CREATE','COMPLETE','test','api-2116806331-rsrcstack-test-2ermiswyp5mp','state changed','OS::Heat::TestResource',NULL,3),(13,'cf3361a8-4e9f-4757-8c22-27eb2d9153fb','67276495-f395-43ca-a615-65805149eefd','2026-01-21 11:48:36',NULL,'CREATE','IN_PROGRESS','test','api-736530183-envstack-test-rma7xjou2dd2','state changed','OS::Heat::TestResource',NULL,4),(14,'f47631e9-b98f-4116-ba87-b968663098f6','cb36b365-7a1d-4fe1-bc43-ac090d0aecde','2026-01-21 11:48:36',NULL,'CREATE','COMPLETE','api-2116806331-rsrcstack','cb36b365-7a1d-4fe1-bc43-ac090d0aecde','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(15,'9a02224a-d9c8-4997-8c82-94a82b26a25a','67276495-f395-43ca-a615-65805149eefd','2026-01-21 11:48:36',NULL,'CREATE','COMPLETE','test','api-736530183-envstack-test-rma7xjou2dd2','state changed','OS::Heat::TestResource',NULL,4),(16,'cb910701-6d54-4c50-a6db-57f2f1f211d8','67276495-f395-43ca-a615-65805149eefd','2026-01-21 11:48:36',NULL,'CREATE','COMPLETE','api-736530183-envstack','67276495-f395-43ca-a615-65805149eefd','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(17,'20a33616-477a-41bb-b95e-257673fc772e','67276495-f395-43ca-a615-65805149eefd','2026-01-21 11:48:36',NULL,'DELETE','IN_PROGRESS','api-736530183-envstack','67276495-f395-43ca-a615-65805149eefd','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(18,'36d0059e-1b3f-4e55-aaf6-8f3960d0c217','67276495-f395-43ca-a615-65805149eefd','2026-01-21 11:48:36',NULL,'DELETE','IN_PROGRESS','test','api-736530183-envstack-test-rma7xjou2dd2','state changed','OS::Heat::TestResource',NULL,4),(19,'a0a33ba2-19fc-408c-8495-81700a5eac21','67276495-f395-43ca-a615-65805149eefd','2026-01-21 11:48:37',NULL,'DELETE','COMPLETE','test','api-736530183-envstack-test-rma7xjou2dd2','state changed','OS::Heat::TestResource',NULL,4),(20,'5ce8b2d5-6fcc-40ac-9051-4b59599fc3f3','67276495-f395-43ca-a615-65805149eefd','2026-01-21 11:48:37',NULL,'DELETE','COMPLETE','api-736530183-envstack','67276495-f395-43ca-a615-65805149eefd','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(21,'f064f0df-cfef-41e7-9fcd-1ddfa5d0f68f','cb36b365-7a1d-4fe1-bc43-ac090d0aecde','2026-01-21 11:48:37',NULL,'CHECK','FAILED','test','api-2116806331-rsrcstack-test-2ermiswyp5mp','resource deleted','OS::Heat::TestResource',NULL,3),(22,'ca569d12-8841-45d5-b16e-c047c66f5cd4','d20ca28a-624b-41b3-96e7-a3e77927a0cf','2026-01-21 11:48:39',NULL,'CHECK','FAILED','test','api-1892183375-rsrcstack-test-mxf3d4frp5kz','resource deleted','OS::Heat::TestResource',NULL,2),(23,'184f4ecf-6371-4d4d-9d5f-cfc9cd68b9e7','d20ca28a-624b-41b3-96e7-a3e77927a0cf','2026-01-21 11:48:40',NULL,'DELETE','IN_PROGRESS','api-1892183375-rsrcstack','d20ca28a-624b-41b3-96e7-a3e77927a0cf','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(24,'f374dc60-d56a-4251-b991-e17e0b12cd1f','d20ca28a-624b-41b3-96e7-a3e77927a0cf','2026-01-21 11:48:40',NULL,'DELETE','IN_PROGRESS','test','api-1892183375-rsrcstack-test-mxf3d4frp5kz','state changed','OS::Heat::TestResource',NULL,2),(25,'524e34ac-9527-4812-85b3-99d0e229cf3d','d20ca28a-624b-41b3-96e7-a3e77927a0cf','2026-01-21 11:48:40',NULL,'DELETE','COMPLETE','test','api-1892183375-rsrcstack-test-mxf3d4frp5kz','state changed','OS::Heat::TestResource',NULL,2),(26,'a5f32348-5050-4067-8ba0-14482a89d6af','d20ca28a-624b-41b3-96e7-a3e77927a0cf','2026-01-21 11:48:40',NULL,'DELETE','COMPLETE','api-1892183375-rsrcstack','d20ca28a-624b-41b3-96e7-a3e77927a0cf','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(27,'0d7d0b6b-5d0c-496e-89aa-152461d9c3bb','52709945-6920-4b5c-a6b3-87373cdb9b8d','2026-01-21 11:48:40',NULL,'CREATE','IN_PROGRESS','api-2116806331-empty','52709945-6920-4b5c-a6b3-87373cdb9b8d','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(28,'10a0164c-11c3-470a-82a0-5179a6a3ef63','52709945-6920-4b5c-a6b3-87373cdb9b8d','2026-01-21 11:48:40',NULL,'CREATE','COMPLETE','api-2116806331-empty','52709945-6920-4b5c-a6b3-87373cdb9b8d','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(29,'037b9b04-1bb0-4011-bb52-523956b5d74e','54e07fe7-ef07-41da-83d1-c46060ca2fd0','2026-01-21 11:48:41',NULL,'CREATE','IN_PROGRESS','api-736530183-empty','54e07fe7-ef07-41da-83d1-c46060ca2fd0','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(30,'b42ad205-e5a5-4159-b4c9-7bdc76c3f412','54e07fe7-ef07-41da-83d1-c46060ca2fd0','2026-01-21 11:48:41',NULL,'CREATE','COMPLETE','api-736530183-empty','54e07fe7-ef07-41da-83d1-c46060ca2fd0','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(31,'6ceba412-bb71-4b44-9c5f-e8df4223305b','6268584d-cf69-44cb-bdf0-9d8f6bd81b57','2026-01-21 11:48:41',NULL,'CREATE','IN_PROGRESS','api-485390504-rsrcstack','6268584d-cf69-44cb-bdf0-9d8f6bd81b57','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(32,'a7ede733-b98d-4559-be4f-0bb7cb8570cc','6268584d-cf69-44cb-bdf0-9d8f6bd81b57','2026-01-21 11:48:41',NULL,'CREATE','IN_PROGRESS','test','api-485390504-rsrcstack-test-nizl2bdu6zw2','state changed','OS::Heat::TestResource',NULL,5),(33,'81a0cd63-8efe-4234-80fa-55bb677544fd','6268584d-cf69-44cb-bdf0-9d8f6bd81b57','2026-01-21 11:48:41',NULL,'CREATE','COMPLETE','test','api-485390504-rsrcstack-test-nizl2bdu6zw2','state changed','OS::Heat::TestResource',NULL,5),(34,'6f428657-c794-4da5-aa19-2c80cc868c78','6268584d-cf69-44cb-bdf0-9d8f6bd81b57','2026-01-21 11:48:41',NULL,'CREATE','COMPLETE','api-485390504-rsrcstack','6268584d-cf69-44cb-bdf0-9d8f6bd81b57','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(35,'49eb5ea9-d2e7-42b8-b81b-0c5f230b55dc','52709945-6920-4b5c-a6b3-87373cdb9b8d','2026-01-21 11:48:41',NULL,'DELETE','IN_PROGRESS','api-2116806331-empty','52709945-6920-4b5c-a6b3-87373cdb9b8d','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(36,'debd9227-5aeb-42d4-9da0-2ec6480b2301','52709945-6920-4b5c-a6b3-87373cdb9b8d','2026-01-21 11:48:41',NULL,'DELETE','COMPLETE','api-2116806331-empty','52709945-6920-4b5c-a6b3-87373cdb9b8d','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(37,'3b74e7ae-5595-4d20-915c-9181b13025d3','54e07fe7-ef07-41da-83d1-c46060ca2fd0','2026-01-21 11:48:41',NULL,'DELETE','IN_PROGRESS','api-736530183-empty','54e07fe7-ef07-41da-83d1-c46060ca2fd0','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(38,'2181ed58-65f8-48b1-baa7-3a0d36098889','54e07fe7-ef07-41da-83d1-c46060ca2fd0','2026-01-21 11:48:41',NULL,'DELETE','COMPLETE','api-736530183-empty','54e07fe7-ef07-41da-83d1-c46060ca2fd0','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(39,'c99180a1-6ef1-417b-93cf-975083c28e52','6268584d-cf69-44cb-bdf0-9d8f6bd81b57','2026-01-21 11:48:42',NULL,'CHECK','FAILED','test','api-485390504-rsrcstack-test-nizl2bdu6zw2','resource deleted','OS::Heat::TestResource',NULL,5),(40,'e2c23501-5a65-477c-a34a-e66614d24270','9198ff61-9b07-4021-90de-0b7fac23b80d','2026-01-21 11:48:42',NULL,'CREATE','IN_PROGRESS','api-2116806331-stack','9198ff61-9b07-4021-90de-0b7fac23b80d','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(41,'cf96078a-fc50-43ef-92cc-26996dfaed1a','9198ff61-9b07-4021-90de-0b7fac23b80d','2026-01-21 11:48:42',NULL,'CREATE','IN_PROGRESS','test','api-2116806331-stack-test-ppifdnbemxn3','state changed','OS::Heat::TestResource',NULL,6),(42,'65e5c1be-06c6-4f88-9d20-fced7bdd46a6','9198ff61-9b07-4021-90de-0b7fac23b80d','2026-01-21 11:48:42',NULL,'CREATE','COMPLETE','test','api-2116806331-stack-test-ppifdnbemxn3','state changed','OS::Heat::TestResource',NULL,6),(43,'560a47ee-97c8-4e9d-81a0-e8009815f291','9198ff61-9b07-4021-90de-0b7fac23b80d','2026-01-21 11:48:42',NULL,'CREATE','COMPLETE','api-2116806331-stack','9198ff61-9b07-4021-90de-0b7fac23b80d','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(44,'ab1ce075-e6d3-4eea-abf6-fdaa6e189c68','4f10c6b8-0472-4108-b086-fd59f41f35b5','2026-01-21 11:48:42',NULL,'CREATE','IN_PROGRESS','api-736530183-stack','4f10c6b8-0472-4108-b086-fd59f41f35b5','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(45,'a81bbf27-7651-46fd-b0cc-374fa0cffcfc','4f10c6b8-0472-4108-b086-fd59f41f35b5','2026-01-21 11:48:42',NULL,'CREATE','IN_PROGRESS','test','api-736530183-stack-test-npaysgq4zcb6','state changed','OS::Heat::TestResource',NULL,7),(46,'034f9056-0e72-455e-bcf3-900bbcf69574','4f10c6b8-0472-4108-b086-fd59f41f35b5','2026-01-21 11:48:42',NULL,'CREATE','COMPLETE','test','api-736530183-stack-test-npaysgq4zcb6','state changed','OS::Heat::TestResource',NULL,7),(47,'fc6ded3b-e17b-421e-a4a5-0b41a1072c35','4f10c6b8-0472-4108-b086-fd59f41f35b5','2026-01-21 11:48:42',NULL,'CREATE','COMPLETE','api-736530183-stack','4f10c6b8-0472-4108-b086-fd59f41f35b5','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(48,'5ae9d75f-7127-45f8-ad44-1af3b02f3423','9198ff61-9b07-4021-90de-0b7fac23b80d','2026-01-21 11:48:43',NULL,'UPDATE','IN_PROGRESS','api-2116806331-stack','9198ff61-9b07-4021-90de-0b7fac23b80d','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(49,'6fe4b32b-3204-4223-b6f6-d154db9c5949','9198ff61-9b07-4021-90de-0b7fac23b80d','2026-01-21 11:48:43',NULL,'UPDATE','IN_PROGRESS','test','api-2116806331-stack-test-ppifdnbemxn3','state changed','OS::Heat::TestResource',NULL,6),(50,'ee260792-a006-4d95-ba0d-325b15f1f9c0','4f10c6b8-0472-4108-b086-fd59f41f35b5','2026-01-21 11:48:43',NULL,'UPDATE','IN_PROGRESS','api-736530183-stack','4f10c6b8-0472-4108-b086-fd59f41f35b5','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(51,'e1ca61b7-e29b-409e-8a10-a44c43a51023','4f10c6b8-0472-4108-b086-fd59f41f35b5','2026-01-21 11:48:43',NULL,'UPDATE','IN_PROGRESS','test','api-736530183-stack-test-npaysgq4zcb6','state changed','OS::Heat::TestResource',NULL,7),(52,'6da098bb-b896-4fa7-bbd8-f43afa001265','6674648f-cf2c-44b1-b17e-af096ff84242','2026-01-21 11:48:43',NULL,'CREATE','IN_PROGRESS','api-1892183375-empty','6674648f-cf2c-44b1-b17e-af096ff84242','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(53,'f898520e-37a9-4e3a-a975-f5a1fbc95f76','6674648f-cf2c-44b1-b17e-af096ff84242','2026-01-21 11:48:43',NULL,'CREATE','COMPLETE','api-1892183375-empty','6674648f-cf2c-44b1-b17e-af096ff84242','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(54,'43be6887-07b0-441c-bc89-c8f730f7cd3e','6674648f-cf2c-44b1-b17e-af096ff84242','2026-01-21 11:48:44',NULL,'DELETE','IN_PROGRESS','api-1892183375-empty','6674648f-cf2c-44b1-b17e-af096ff84242','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(55,'7fb9c2d1-2265-4d80-aa88-363977a7b53d','6674648f-cf2c-44b1-b17e-af096ff84242','2026-01-21 11:48:44',NULL,'DELETE','COMPLETE','api-1892183375-empty','6674648f-cf2c-44b1-b17e-af096ff84242','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(56,'4c68b34d-acd1-4847-bec0-41590d1e58ed','b6cf8cab-9fd7-4409-90b4-24e91be8a8d4','2026-01-21 11:48:45',NULL,'CREATE','IN_PROGRESS','api-485390504-empty','b6cf8cab-9fd7-4409-90b4-24e91be8a8d4','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(57,'4a499339-7964-4fa3-8aef-a6a795dfd071','8e7f35e3-6de2-4d40-ae21-5912ea3a8986','2026-01-21 11:48:45',NULL,'CREATE','IN_PROGRESS','api-1892183375-stack','8e7f35e3-6de2-4d40-ae21-5912ea3a8986','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(58,'20c0c21f-9a13-4ef5-b8af-10a3ad7ab5e7','b6cf8cab-9fd7-4409-90b4-24e91be8a8d4','2026-01-21 11:48:45',NULL,'CREATE','COMPLETE','api-485390504-empty','b6cf8cab-9fd7-4409-90b4-24e91be8a8d4','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(59,'e96cf802-0603-4a71-9c9c-001dfc353d28','9198ff61-9b07-4021-90de-0b7fac23b80d','2026-01-21 11:48:45',NULL,'UPDATE','COMPLETE','test','api-2116806331-stack-test-ppifdnbemxn3','state changed','OS::Heat::TestResource',NULL,8),(60,'af9df468-831b-4c7a-9fd9-9eec596fe025','8e7f35e3-6de2-4d40-ae21-5912ea3a8986','2026-01-21 11:48:45',NULL,'CREATE','IN_PROGRESS','test','api-1892183375-stack-test-mlkonfnt3ohv','state changed','OS::Heat::TestResource',NULL,9),(61,'0222353b-9eca-4cf4-823b-47d5632bdfa4','9198ff61-9b07-4021-90de-0b7fac23b80d','2026-01-21 11:48:45',NULL,'UPDATE','COMPLETE','api-2116806331-stack','9198ff61-9b07-4021-90de-0b7fac23b80d','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(62,'9ec669ba-7fc3-4f9e-a063-da84292d27b5','8e7f35e3-6de2-4d40-ae21-5912ea3a8986','2026-01-21 11:48:45',NULL,'CREATE','COMPLETE','test','api-1892183375-stack-test-mlkonfnt3ohv','state changed','OS::Heat::TestResource',NULL,9),(63,'94a0342c-f99d-46a9-bca0-b007e5f4ffe0','8e7f35e3-6de2-4d40-ae21-5912ea3a8986','2026-01-21 11:48:45',NULL,'CREATE','COMPLETE','api-1892183375-stack','8e7f35e3-6de2-4d40-ae21-5912ea3a8986','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(64,'e768664a-f668-45f5-9d1c-d9ea16c888fc','4f10c6b8-0472-4108-b086-fd59f41f35b5','2026-01-21 11:48:45',NULL,'UPDATE','COMPLETE','test','api-736530183-stack-test-npaysgq4zcb6','state changed','OS::Heat::TestResource',NULL,10),(65,'4501fec9-a931-4c90-8b72-9bc51ec80288','4f10c6b8-0472-4108-b086-fd59f41f35b5','2026-01-21 11:48:45',NULL,'UPDATE','COMPLETE','api-736530183-stack','4f10c6b8-0472-4108-b086-fd59f41f35b5','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(66,'4a661de0-5a43-4706-b25f-2442b7c98858','b6cf8cab-9fd7-4409-90b4-24e91be8a8d4','2026-01-21 11:48:45',NULL,'DELETE','IN_PROGRESS','api-485390504-empty','b6cf8cab-9fd7-4409-90b4-24e91be8a8d4','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(67,'d58780ac-3822-431a-819b-0948f0766c4b','b6cf8cab-9fd7-4409-90b4-24e91be8a8d4','2026-01-21 11:48:45',NULL,'DELETE','COMPLETE','api-485390504-empty','b6cf8cab-9fd7-4409-90b4-24e91be8a8d4','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(68,'87d35b1f-b243-461c-ab61-29470f1e9d24','9198ff61-9b07-4021-90de-0b7fac23b80d','2026-01-21 11:48:45',NULL,'UPDATE','IN_PROGRESS','api-2116806331-stack','9198ff61-9b07-4021-90de-0b7fac23b80d','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(69,'ea84d24b-c421-4683-bebb-036ef4030a4b','4f10c6b8-0472-4108-b086-fd59f41f35b5','2026-01-21 11:48:45',NULL,'UPDATE','IN_PROGRESS','api-736530183-stack','4f10c6b8-0472-4108-b086-fd59f41f35b5','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(70,'6f87c137-acb7-47f6-bff1-c71593090526','9198ff61-9b07-4021-90de-0b7fac23b80d','2026-01-21 11:48:46',NULL,'UPDATE','IN_PROGRESS','test','api-2116806331-stack-test-ppifdnbemxn3','state changed','OS::Heat::TestResource',NULL,8),(71,'0e953776-e422-44de-ad48-25c39e6461e0','4f10c6b8-0472-4108-b086-fd59f41f35b5','2026-01-21 11:48:46',NULL,'UPDATE','IN_PROGRESS','test','api-736530183-stack-test-npaysgq4zcb6','state changed','OS::Heat::TestResource',NULL,10),(72,'8a016b40-1ec4-41ce-aae4-57cf0ec80b52','8e7f35e3-6de2-4d40-ae21-5912ea3a8986','2026-01-21 11:48:46',NULL,'UPDATE','IN_PROGRESS','api-1892183375-stack','8e7f35e3-6de2-4d40-ae21-5912ea3a8986','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(73,'2af152f4-b619-4adc-8904-3a85fd1bc81e','8e7f35e3-6de2-4d40-ae21-5912ea3a8986','2026-01-21 11:48:46',NULL,'UPDATE','IN_PROGRESS','test','api-1892183375-stack-test-mlkonfnt3ohv','state changed','OS::Heat::TestResource',NULL,9),(74,'7da7a6ea-60de-4e17-ade4-401a7ebf17fa','a1f99d50-aa51-4cad-9b96-faac6562e7a6','2026-01-21 11:48:46',NULL,'CREATE','IN_PROGRESS','api-485390504-stack','a1f99d50-aa51-4cad-9b96-faac6562e7a6','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(75,'015f3dcf-958c-4e86-94cb-fba9de79c910','a1f99d50-aa51-4cad-9b96-faac6562e7a6','2026-01-21 11:48:46',NULL,'CREATE','IN_PROGRESS','test','api-485390504-stack-test-xsoi3zvtilvi','state changed','OS::Heat::TestResource',NULL,11),(76,'761a868d-7bdc-4256-b649-1758bb3e83e5','a1f99d50-aa51-4cad-9b96-faac6562e7a6','2026-01-21 11:48:46',NULL,'CREATE','COMPLETE','test','api-485390504-stack-test-xsoi3zvtilvi','state changed','OS::Heat::TestResource',NULL,11),(77,'1db49099-671d-4204-a9f8-24b2ef9d2e7d','a1f99d50-aa51-4cad-9b96-faac6562e7a6','2026-01-21 11:48:46',NULL,'CREATE','COMPLETE','api-485390504-stack','a1f99d50-aa51-4cad-9b96-faac6562e7a6','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(78,'d85ef8e1-dcbc-4314-a2c4-5c009bbbd648','a1f99d50-aa51-4cad-9b96-faac6562e7a6','2026-01-21 11:48:47',NULL,'UPDATE','IN_PROGRESS','api-485390504-stack','a1f99d50-aa51-4cad-9b96-faac6562e7a6','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(79,'4e322c77-3841-41dd-9824-835200d394bf','a1f99d50-aa51-4cad-9b96-faac6562e7a6','2026-01-21 11:48:47',NULL,'UPDATE','IN_PROGRESS','test','api-485390504-stack-test-xsoi3zvtilvi','state changed','OS::Heat::TestResource',NULL,11),(80,'20d93bb6-9410-4a86-ba7d-77cfa3b49a21','9198ff61-9b07-4021-90de-0b7fac23b80d','2026-01-21 11:48:48',NULL,'UPDATE','COMPLETE','test','api-2116806331-stack-test-ppifdnbemxn3','state changed','OS::Heat::TestResource',NULL,12),(81,'8b26a83e-0d36-4e58-a38d-89dff6296239','8e7f35e3-6de2-4d40-ae21-5912ea3a8986','2026-01-21 11:48:48',NULL,'UPDATE','COMPLETE','test','api-1892183375-stack-test-mlkonfnt3ohv','state changed','OS::Heat::TestResource',NULL,14),(82,'5e5d600e-d8a1-4f2c-96e2-21ced3cab9a9','4f10c6b8-0472-4108-b086-fd59f41f35b5','2026-01-21 11:48:48',NULL,'UPDATE','COMPLETE','test','api-736530183-stack-test-npaysgq4zcb6','state changed','OS::Heat::TestResource',NULL,13),(83,'84d8a8ed-2a42-4cab-956a-3e1202510917','8e7f35e3-6de2-4d40-ae21-5912ea3a8986','2026-01-21 11:48:48',NULL,'UPDATE','COMPLETE','api-1892183375-stack','8e7f35e3-6de2-4d40-ae21-5912ea3a8986','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(84,'f7f50e5c-37a1-4f08-ba34-b484ccf77797','9198ff61-9b07-4021-90de-0b7fac23b80d','2026-01-21 11:48:48',NULL,'UPDATE','COMPLETE','api-2116806331-stack','9198ff61-9b07-4021-90de-0b7fac23b80d','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(85,'15f4adb1-6bbe-4a8b-aa1d-705971ae85af','4f10c6b8-0472-4108-b086-fd59f41f35b5','2026-01-21 11:48:48',NULL,'UPDATE','COMPLETE','api-736530183-stack','4f10c6b8-0472-4108-b086-fd59f41f35b5','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(86,'a5262316-f307-47ee-8a58-9dc0dbb0e11a','a1f99d50-aa51-4cad-9b96-faac6562e7a6','2026-01-21 11:48:49',NULL,'UPDATE','COMPLETE','test','api-485390504-stack-test-xsoi3zvtilvi','state changed','OS::Heat::TestResource',NULL,15),(87,'b0a9c46d-913d-466d-8290-36eebaf78a47','a1f99d50-aa51-4cad-9b96-faac6562e7a6','2026-01-21 11:48:49',NULL,'UPDATE','COMPLETE','api-485390504-stack','a1f99d50-aa51-4cad-9b96-faac6562e7a6','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(88,'4aeb7b03-8063-4914-8c47-347c26d88792','a1f99d50-aa51-4cad-9b96-faac6562e7a6','2026-01-21 11:48:50',NULL,'UPDATE','IN_PROGRESS','api-485390504-stack','a1f99d50-aa51-4cad-9b96-faac6562e7a6','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(89,'657b5864-d4e9-408a-a800-aec0dd5d243f','a1f99d50-aa51-4cad-9b96-faac6562e7a6','2026-01-21 11:48:50',NULL,'UPDATE','IN_PROGRESS','test','api-485390504-stack-test-xsoi3zvtilvi','state changed','OS::Heat::TestResource',NULL,15),(90,'bfd91d7d-bc9e-4326-a49e-7eaae63618e7','9198ff61-9b07-4021-90de-0b7fac23b80d','2026-01-21 11:48:51',NULL,'DELETE','IN_PROGRESS','api-2116806331-stack','9198ff61-9b07-4021-90de-0b7fac23b80d','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(91,'1b63d124-a61e-4a68-8249-13e1b171243a','9198ff61-9b07-4021-90de-0b7fac23b80d','2026-01-21 11:48:51',NULL,'DELETE','IN_PROGRESS','test','api-2116806331-stack-test-ppifdnbemxn3','state changed','OS::Heat::TestResource',NULL,12),(92,'f35c8093-b3f4-405f-a3a4-385bcb86181a','9198ff61-9b07-4021-90de-0b7fac23b80d','2026-01-21 11:48:51',NULL,'DELETE','COMPLETE','test','api-2116806331-stack-test-ppifdnbemxn3','state changed','OS::Heat::TestResource',NULL,12),(93,'7527ce05-655a-463e-b0b7-9b7aa73fd068','9198ff61-9b07-4021-90de-0b7fac23b80d','2026-01-21 11:48:51',NULL,'DELETE','COMPLETE','api-2116806331-stack','9198ff61-9b07-4021-90de-0b7fac23b80d','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(94,'29202553-ca9f-4011-8b1b-48e0ad07a7fb','9036f089-1726-4db1-9174-bbe9cc6810a2','2026-01-21 11:48:52',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-1304445430','9036f089-1726-4db1-9174-bbe9cc6810a2','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(95,'0cbe5e14-6d2e-43da-9d36-0b7bc549db88','9036f089-1726-4db1-9174-bbe9cc6810a2','2026-01-21 11:48:52',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-1304445430-net-44bomnjxcacu','state changed','OS::Neutron::Net',NULL,NULL),(96,'dbf808d9-e009-40fe-b2af-3c18b5c63e9e','969ba6aa-41c3-4805-baa6-2d988a0767d9','2026-01-21 11:48:52',NULL,'CREATE','IN_PROGRESS','UpdatePortTest-250805131','969ba6aa-41c3-4805-baa6-2d988a0767d9','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(97,'74f96e18-b2fa-4cb9-b21a-7835478cc14a','969ba6aa-41c3-4805-baa6-2d988a0767d9','2026-01-21 11:48:52',NULL,'CREATE','IN_PROGRESS','net','UpdatePortTest-250805131-net-ewjfmlsf6hk6','state changed','OS::Neutron::Net',NULL,NULL),(98,'3ff71329-86dd-490d-9e87-807921a447e4','a1f99d50-aa51-4cad-9b96-faac6562e7a6','2026-01-21 11:48:52',NULL,'UPDATE','COMPLETE','test','api-485390504-stack-test-xsoi3zvtilvi','state changed','OS::Heat::TestResource',NULL,16),(99,'a9f3f13d-62d6-41c9-bca0-2de85b112734','a1f99d50-aa51-4cad-9b96-faac6562e7a6','2026-01-21 11:48:52',NULL,'UPDATE','COMPLETE','api-485390504-stack','a1f99d50-aa51-4cad-9b96-faac6562e7a6','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(100,'8f98fdb1-2bb2-4918-aff0-8fee25040a02','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:48:52',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-1943635260','f2da6721-6e76-4187-a126-a4b260ddbda9','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(101,'908f13be-e6fc-4d12-a255-19f0e54bb8ee','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:48:52',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-1943635260-trunk_net_one-yiwlvpuj5zcl','state changed','OS::Neutron::Net',NULL,NULL),(102,'db28aaa4-9d99-44f0-b9c2-1faf72f91f75','9036f089-1726-4db1-9174-bbe9cc6810a2','2026-01-21 11:48:52',NULL,'CREATE','COMPLETE','net','ec9c3d74-94b2-465d-9700-dcdf321ea66b','state changed','OS::Neutron::Net',NULL,NULL),(103,'63355971-903f-4fc3-8e5f-d19f05941a7a','9036f089-1726-4db1-9174-bbe9cc6810a2','2026-01-21 11:48:53',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-1304445430-subnet-dlgrbejokdnx','state changed','OS::Neutron::Subnet',NULL,17),(104,'f739517a-0212-45c7-92dc-c5f91d172635','969ba6aa-41c3-4805-baa6-2d988a0767d9','2026-01-21 11:48:53',NULL,'CREATE','COMPLETE','net','3811b843-1191-4806-9b27-c3e748e231fd','state changed','OS::Neutron::Net',NULL,NULL),(105,'b64d9419-11ab-474f-ac46-033ced736e99','969ba6aa-41c3-4805-baa6-2d988a0767d9','2026-01-21 11:48:53',NULL,'CREATE','IN_PROGRESS','subnet','UpdatePortTest-250805131-subnet-7ajuffep26zs','state changed','OS::Neutron::Subnet',NULL,18),(106,'849bf246-6343-43c3-b6cd-404b0a7a197f','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:48:53',NULL,'CREATE','COMPLETE','trunk_net_one','7f219b54-86f6-44e3-86cf-243b418b95ea','state changed','OS::Neutron::Net',NULL,NULL),(107,'e25c5d25-a29b-45fb-923d-b7c649e243f3','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:48:53',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-1943635260-trunk_subnet_one-kfzptvey6xtf','state changed','OS::Neutron::Subnet',NULL,19),(108,'650fdd8b-646f-4100-8c1c-92c9bf6bd9f5','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:48:53',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-1943635260-parent_net-jdmuscsvaz66','state changed','OS::Neutron::Net',NULL,NULL),(109,'25d56670-bdd6-48eb-a040-ff803ee48110','969ba6aa-41c3-4805-baa6-2d988a0767d9','2026-01-21 11:48:53',NULL,'CREATE','COMPLETE','subnet','922c5084-88c6-4243-823c-37fc868ab12b','state changed','OS::Neutron::Subnet',NULL,18),(110,'44ebea4c-81c5-4953-97d3-bfc7ec8f9d68','9036f089-1726-4db1-9174-bbe9cc6810a2','2026-01-21 11:48:53',NULL,'CREATE','COMPLETE','subnet','66d4bd6d-69d3-4fe1-a210-3cb2be1acd93','state changed','OS::Neutron::Subnet',NULL,17),(111,'9cd93f01-a8b3-4079-a4f0-06e55ef351d4','9036f089-1726-4db1-9174-bbe9cc6810a2','2026-01-21 11:48:53',NULL,'CREATE','COMPLETE','UpdateSubnetTest-1304445430','9036f089-1726-4db1-9174-bbe9cc6810a2','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(112,'c46605c6-16b2-4302-a57d-4b84ee3c8bc7','969ba6aa-41c3-4805-baa6-2d988a0767d9','2026-01-21 11:48:53',NULL,'CREATE','IN_PROGRESS','port','UpdatePortTest-250805131-port-e37jnsf7gwmc','state changed','OS::Neutron::Port',NULL,20),(113,'9afffa06-e03f-4069-93b0-52381a7cf7f4','a09fb5bd-6204-4fac-b2ea-0624f40a5b0d','2026-01-21 11:48:54',NULL,'CREATE','IN_PROGRESS','EncryptedParametersTest-859287547','a09fb5bd-6204-4fac-b2ea-0624f40a5b0d','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(114,'cef85b21-da94-4b85-99d9-2a80e981387d','a09fb5bd-6204-4fac-b2ea-0624f40a5b0d','2026-01-21 11:48:54',NULL,'CREATE','IN_PROGRESS','server_with_encrypted_property','En-287547-server_with_encrypted_property-57ktamedbshp','state changed','OS::Nova::Server',NULL,21),(115,'055e17c6-0387-4308-97ef-0c6a65eaf2c0','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:48:54',NULL,'CREATE','COMPLETE','parent_net','e4393cde-e6c8-4bf8-a5e9-d0369150e594','state changed','OS::Neutron::Net',NULL,NULL),(116,'d8da0ec4-36d2-4217-9191-0e395afd6384','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:48:54',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-1943635260-parent_subnet-ygypp5jx7bgp','state changed','OS::Neutron::Subnet',NULL,22),(117,'cecd952d-5ea9-4331-822c-45224725510b','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:48:54',NULL,'CREATE','COMPLETE','trunk_subnet_one','3b39cb20-2b10-40d3-9de2-9220cad3d4f4','state changed','OS::Neutron::Subnet',NULL,19),(118,'e51f7237-013a-436c-bff4-70dd37fdc5d4','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:48:54',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-1943635260-trunk_net_two-ieo5urlgddr3','state changed','OS::Neutron::Net',NULL,NULL),(119,'ced65fcf-f2dd-431e-8474-5af61586810b','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:48:54',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-1943635260-sub_port_one-zjf6yrdzrcg7','state changed','OS::Neutron::Port',NULL,23),(120,'72bfa6b8-2731-4dea-bdf0-debb5320a5b0','969ba6aa-41c3-4805-baa6-2d988a0767d9','2026-01-21 11:48:54',NULL,'CREATE','COMPLETE','port','04119e7c-3498-4a4d-a41f-7dfba75af10f','state changed','OS::Neutron::Port',NULL,20),(121,'d2b43cb0-2a94-49b2-b4c0-957cef299c60','969ba6aa-41c3-4805-baa6-2d988a0767d9','2026-01-21 11:48:55',NULL,'CREATE','IN_PROGRESS','test','UpdatePortTest-250805131-test-4x4z5efzoqgc','state changed','OS::Heat::TestResource',NULL,25),(122,'5d04b2b9-7241-45d1-90d5-b4517c061216','969ba6aa-41c3-4805-baa6-2d988a0767d9','2026-01-21 11:48:55',NULL,'CREATE','COMPLETE','test','UpdatePortTest-250805131-test-4x4z5efzoqgc','state changed','OS::Heat::TestResource',NULL,25),(123,'d61ac691-e729-4a91-8d65-91a5ce8ecfc0','969ba6aa-41c3-4805-baa6-2d988a0767d9','2026-01-21 11:48:55',NULL,'CREATE','COMPLETE','UpdatePortTest-250805131','969ba6aa-41c3-4805-baa6-2d988a0767d9','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(124,'2901e0d9-f95c-4d3f-913e-904232f85c90','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:48:56',NULL,'CREATE','COMPLETE','trunk_net_two','0ef98077-903c-4874-855b-171ffda59242','state changed','OS::Neutron::Net',NULL,NULL),(125,'bfffcfa7-e998-4b53-842d-644a72944bdd','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:48:56',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-1943635260-trunk_subnet_two-3dzgbom4cxks','state changed','OS::Neutron::Subnet',NULL,26),(126,'b51aae90-5cfd-4c8c-837c-8887ecab2968','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:48:56',NULL,'CREATE','COMPLETE','sub_port_one','0e5a2803-815c-4754-96bf-1e570f049773','state changed','OS::Neutron::Port',NULL,23),(127,'a9c5ad98-f5f6-475b-93d7-2d406d89fd12','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:48:57',NULL,'CREATE','COMPLETE','parent_subnet','f1613363-eef1-4f7c-b25f-61ea154654c3','state changed','OS::Neutron::Subnet',NULL,22),(128,'ec86ca0a-a40e-4682-9975-bcac11fa804d','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:48:57',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-1943635260-parent_port-ex244hukoi4p','state changed','OS::Neutron::Port',NULL,28),(129,'7dadd734-c2c2-4b12-b750-dc07c8f09964','969ba6aa-41c3-4805-baa6-2d988a0767d9','2026-01-21 11:48:57',NULL,'UPDATE','IN_PROGRESS','UpdatePortTest-250805131','969ba6aa-41c3-4805-baa6-2d988a0767d9','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(130,'04253f28-4561-4f3a-809e-af334621d559','9036f089-1726-4db1-9174-bbe9cc6810a2','2026-01-21 11:48:57',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-1304445430','9036f089-1726-4db1-9174-bbe9cc6810a2','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(131,'70614bbc-6bf7-4d09-ba06-29e45d402d31','9036f089-1726-4db1-9174-bbe9cc6810a2','2026-01-21 11:48:57',NULL,'UPDATE','IN_PROGRESS','subnet','66d4bd6d-69d3-4fe1-a210-3cb2be1acd93','state changed','OS::Neutron::Subnet',NULL,17),(132,'f040164c-b743-4229-b6e8-0fc81f0bb195','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:48:57',NULL,'CREATE','COMPLETE','parent_port','671bf162-11dc-425b-a4bc-a1be333fd51f','state changed','OS::Neutron::Port',NULL,28),(133,'1a23c032-faa8-4b27-ace5-042058bd3d59','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:48:58',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-1943635260-trunk-63gt53kpgbzf','state changed','OS::Neutron::Trunk',NULL,29),(134,'3f86818d-6402-4ed6-af86-b97e6fa3733e','969ba6aa-41c3-4805-baa6-2d988a0767d9','2026-01-21 11:48:58',NULL,'UPDATE','IN_PROGRESS','port','04119e7c-3498-4a4d-a41f-7dfba75af10f','state changed','OS::Neutron::Port',NULL,20),(135,'0885b358-8e47-4b36-acab-707452160381','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:48:58',NULL,'CREATE','COMPLETE','trunk_subnet_two','f5483e53-8a83-49e1-b64b-1085434f337b','state changed','OS::Neutron::Subnet',NULL,26),(136,'37e62e51-e9f6-4590-ba20-42fb7cacddb0','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:48:58',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-1943635260-sub_port_two-nemovg47aczu','state changed','OS::Neutron::Port',NULL,30),(137,'9342f338-11fe-4cc2-ac10-6bf181c51458','9036f089-1726-4db1-9174-bbe9cc6810a2','2026-01-21 11:48:58',NULL,'UPDATE','COMPLETE','subnet','66d4bd6d-69d3-4fe1-a210-3cb2be1acd93','state changed','OS::Neutron::Subnet',NULL,31),(138,'3cefcdb0-63ec-426a-b0cd-ec8af6dd1e5f','9036f089-1726-4db1-9174-bbe9cc6810a2','2026-01-21 11:48:58',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-1304445430','9036f089-1726-4db1-9174-bbe9cc6810a2','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(139,'29a22ae0-3464-4b74-9000-d46d1a57e9fa','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:48:59',NULL,'CREATE','COMPLETE','trunk','910df9e5-faec-4585-98a1-26fdc4a081a0','state changed','OS::Neutron::Trunk',NULL,29),(140,'5dc78fe2-9be9-42ea-9353-4775ba12699f','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:48:59',NULL,'CREATE','COMPLETE','sub_port_two','2fc495fb-1817-4915-a957-07aa70045928','state changed','OS::Neutron::Port',NULL,30),(141,'ed24b186-b10c-47f6-91d7-d3aa9ba80323','969ba6aa-41c3-4805-baa6-2d988a0767d9','2026-01-21 11:48:59',NULL,'UPDATE','COMPLETE','port','04119e7c-3498-4a4d-a41f-7dfba75af10f','state changed','OS::Neutron::Port',NULL,32),(142,'f1318587-b1bf-4d56-93a3-c513cc03737e','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:48:59',NULL,'CREATE','COMPLETE','UpdateTrunkTest-1943635260','f2da6721-6e76-4187-a126-a4b260ddbda9','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(143,'36eaa82f-ce12-4cbc-93f8-498599bb04e3','969ba6aa-41c3-4805-baa6-2d988a0767d9','2026-01-21 11:48:59',NULL,'UPDATE','COMPLETE','UpdatePortTest-250805131','969ba6aa-41c3-4805-baa6-2d988a0767d9','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(144,'0a1dc593-2cd0-438b-9b4c-36a0423ca6b4','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:49:01',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-1943635260','f2da6721-6e76-4187-a126-a4b260ddbda9','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(145,'942f016b-946b-4bdf-876f-7f6898fe4fc0','969ba6aa-41c3-4805-baa6-2d988a0767d9','2026-01-21 11:49:01',NULL,'DELETE','IN_PROGRESS','UpdatePortTest-250805131','969ba6aa-41c3-4805-baa6-2d988a0767d9','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(146,'aa4aecdc-724b-462e-b78a-65aaf570f6aa','969ba6aa-41c3-4805-baa6-2d988a0767d9','2026-01-21 11:49:02',NULL,'DELETE','IN_PROGRESS','test','UpdatePortTest-250805131-test-4x4z5efzoqgc','state changed','OS::Heat::TestResource',NULL,25),(147,'a829c91b-b2b3-4528-9564-8b1464d8272b','969ba6aa-41c3-4805-baa6-2d988a0767d9','2026-01-21 11:49:02',NULL,'DELETE','COMPLETE','test','UpdatePortTest-250805131-test-4x4z5efzoqgc','state changed','OS::Heat::TestResource',NULL,25),(148,'a564a68c-b127-4ffc-a10b-11fd94a69312','969ba6aa-41c3-4805-baa6-2d988a0767d9','2026-01-21 11:49:02',NULL,'DELETE','IN_PROGRESS','port','04119e7c-3498-4a4d-a41f-7dfba75af10f','state changed','OS::Neutron::Port',NULL,32),(149,'b8d8e0fb-a3b9-4561-8bc9-8e3a89752552','9036f089-1726-4db1-9174-bbe9cc6810a2','2026-01-21 11:49:02',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-1304445430','9036f089-1726-4db1-9174-bbe9cc6810a2','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(150,'6c7ffc10-5d3d-49eb-aade-5126d4e88792','9036f089-1726-4db1-9174-bbe9cc6810a2','2026-01-21 11:49:02',NULL,'DELETE','IN_PROGRESS','subnet','66d4bd6d-69d3-4fe1-a210-3cb2be1acd93','state changed','OS::Neutron::Subnet',NULL,31),(151,'18cd2e7c-9246-4526-8f5c-23472ffeb7a2','9036f089-1726-4db1-9174-bbe9cc6810a2','2026-01-21 11:49:02',NULL,'DELETE','COMPLETE','subnet','66d4bd6d-69d3-4fe1-a210-3cb2be1acd93','state changed','OS::Neutron::Subnet',NULL,31),(152,'e245cb4d-e280-4413-8ff0-9cfa75147d11','9036f089-1726-4db1-9174-bbe9cc6810a2','2026-01-21 11:49:02',NULL,'DELETE','IN_PROGRESS','net','ec9c3d74-94b2-465d-9700-dcdf321ea66b','state changed','OS::Neutron::Net',NULL,NULL),(153,'d69329ef-0639-41c9-8eb5-c4598b654da3','969ba6aa-41c3-4805-baa6-2d988a0767d9','2026-01-21 11:49:02',NULL,'DELETE','COMPLETE','port','04119e7c-3498-4a4d-a41f-7dfba75af10f','state changed','OS::Neutron::Port',NULL,32),(154,'e8ad5f64-ab41-425a-ad4c-ab0673a7f8ea','969ba6aa-41c3-4805-baa6-2d988a0767d9','2026-01-21 11:49:02',NULL,'DELETE','IN_PROGRESS','subnet','922c5084-88c6-4243-823c-37fc868ab12b','state changed','OS::Neutron::Subnet',NULL,18),(155,'e4406ce8-406f-466e-8627-840dd1f7b204','969ba6aa-41c3-4805-baa6-2d988a0767d9','2026-01-21 11:49:03',NULL,'DELETE','COMPLETE','subnet','922c5084-88c6-4243-823c-37fc868ab12b','state changed','OS::Neutron::Subnet',NULL,18),(156,'7409c9f1-1ec3-4f1f-983b-0aa9f5ee24f9','969ba6aa-41c3-4805-baa6-2d988a0767d9','2026-01-21 11:49:03',NULL,'DELETE','IN_PROGRESS','net','3811b843-1191-4806-9b27-c3e748e231fd','state changed','OS::Neutron::Net',NULL,NULL),(157,'e882b15f-1aa3-46e2-b8c6-5a276f6386be','9036f089-1726-4db1-9174-bbe9cc6810a2','2026-01-21 11:49:03',NULL,'DELETE','COMPLETE','net','ec9c3d74-94b2-465d-9700-dcdf321ea66b','state changed','OS::Neutron::Net',NULL,NULL),(158,'b35d1e7b-8ed3-4893-bc2b-79c6eef498bd','9036f089-1726-4db1-9174-bbe9cc6810a2','2026-01-21 11:49:03',NULL,'DELETE','COMPLETE','UpdateSubnetTest-1304445430','9036f089-1726-4db1-9174-bbe9cc6810a2','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(159,'857d672a-7bae-4bfd-a8d4-0af26b9fad4f','969ba6aa-41c3-4805-baa6-2d988a0767d9','2026-01-21 11:49:03',NULL,'DELETE','COMPLETE','net','3811b843-1191-4806-9b27-c3e748e231fd','state changed','OS::Neutron::Net',NULL,NULL),(160,'efdcec67-5411-44d8-ba38-695b5aa32ffc','969ba6aa-41c3-4805-baa6-2d988a0767d9','2026-01-21 11:49:03',NULL,'DELETE','COMPLETE','UpdatePortTest-250805131','969ba6aa-41c3-4805-baa6-2d988a0767d9','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(161,'c319496f-deac-438e-97af-9133bcd719dd','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:49:04',NULL,'UPDATE','IN_PROGRESS','trunk','910df9e5-faec-4585-98a1-26fdc4a081a0','state changed','OS::Neutron::Trunk',NULL,29),(162,'a8184e8f-4ea8-4e4a-b5a5-39d1b6f0effd','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:49:05',NULL,'UPDATE','COMPLETE','trunk','910df9e5-faec-4585-98a1-26fdc4a081a0','state changed','OS::Neutron::Trunk',NULL,35),(163,'3376d8a5-464d-4738-a7e2-5e5e5f3f70d0','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:49:05',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-1943635260','f2da6721-6e76-4187-a126-a4b260ddbda9','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(164,'606abc87-ce56-4335-b68b-8b366165f601','a09fb5bd-6204-4fac-b2ea-0624f40a5b0d','2026-01-21 11:49:05',NULL,'CREATE','COMPLETE','server_with_encrypted_property','339eb7cd-fd41-4c85-8e90-8c04a28b6725','state changed','OS::Nova::Server',NULL,21),(165,'cded5c00-1faa-46a9-a83e-397c890b6ebc','a09fb5bd-6204-4fac-b2ea-0624f40a5b0d','2026-01-21 11:49:05',NULL,'CREATE','COMPLETE','EncryptedParametersTest-859287547','a09fb5bd-6204-4fac-b2ea-0624f40a5b0d','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(166,'99d7bea7-9b15-41a6-a95a-7f0fde112f00','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:49:06',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-1943635260','f2da6721-6e76-4187-a126-a4b260ddbda9','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(167,'386650e0-6cca-4b4d-b52a-b6a68b0e8d2b','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:49:06',NULL,'DELETE','IN_PROGRESS','trunk','910df9e5-faec-4585-98a1-26fdc4a081a0','state changed','OS::Neutron::Trunk',NULL,35),(168,'3b34a78b-470a-41c5-b77a-0de253ae6231','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:49:06',NULL,'DELETE','COMPLETE','trunk','910df9e5-faec-4585-98a1-26fdc4a081a0','state changed','OS::Neutron::Trunk',NULL,35),(169,'4084c906-a7ac-4372-ab85-1aa8f6847fec','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:49:06',NULL,'DELETE','IN_PROGRESS','sub_port_one','0e5a2803-815c-4754-96bf-1e570f049773','state changed','OS::Neutron::Port',NULL,23),(170,'8a7fc343-a6e4-45f6-8edb-18e0f748b2cf','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:49:06',NULL,'DELETE','IN_PROGRESS','sub_port_two','2fc495fb-1817-4915-a957-07aa70045928','state changed','OS::Neutron::Port',NULL,30),(171,'fd45a593-b684-43dd-9121-a4fa99a50fe7','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:49:06',NULL,'DELETE','IN_PROGRESS','parent_port','671bf162-11dc-425b-a4bc-a1be333fd51f','state changed','OS::Neutron::Port',NULL,28),(172,'b6e0c0fe-a4db-4986-91f8-844dcf637d58','a09fb5bd-6204-4fac-b2ea-0624f40a5b0d','2026-01-21 11:49:07',NULL,'DELETE','IN_PROGRESS','EncryptedParametersTest-859287547','a09fb5bd-6204-4fac-b2ea-0624f40a5b0d','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(173,'a69ff752-9121-4d3c-b0b3-e7985b0fac1e','a09fb5bd-6204-4fac-b2ea-0624f40a5b0d','2026-01-21 11:49:07',NULL,'DELETE','IN_PROGRESS','server_with_encrypted_property','339eb7cd-fd41-4c85-8e90-8c04a28b6725','state changed','OS::Nova::Server',NULL,21),(174,'6ad7d032-f594-4984-b24d-544dafe239e6','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:49:07',NULL,'DELETE','COMPLETE','sub_port_two','2fc495fb-1817-4915-a957-07aa70045928','state changed','OS::Neutron::Port',NULL,30),(175,'1d3a1c1b-4194-401e-bc76-602636b97ce6','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:49:07',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','f5483e53-8a83-49e1-b64b-1085434f337b','state changed','OS::Neutron::Subnet',NULL,26),(176,'c42e53aa-6a0e-4e1f-9eb4-0b4f9e1bfe24','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:49:07',NULL,'DELETE','COMPLETE','parent_port','671bf162-11dc-425b-a4bc-a1be333fd51f','state changed','OS::Neutron::Port',NULL,28),(177,'3e0a5af4-28fe-44e0-a8fc-ff018355d11b','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:49:07',NULL,'DELETE','COMPLETE','sub_port_one','0e5a2803-815c-4754-96bf-1e570f049773','state changed','OS::Neutron::Port',NULL,23),(178,'afe56165-df2a-440e-9a61-14426d1d42f0','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:49:07',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','3b39cb20-2b10-40d3-9de2-9220cad3d4f4','state changed','OS::Neutron::Subnet',NULL,19),(179,'bd66fa1a-7b7f-477c-b710-d3a0d33f3865','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:49:07',NULL,'DELETE','IN_PROGRESS','parent_subnet','f1613363-eef1-4f7c-b25f-61ea154654c3','state changed','OS::Neutron::Subnet',NULL,22),(180,'6d5635f4-9df6-4106-b2ee-4f127489e536','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:07',NULL,'CREATE','IN_PROGRESS','UpdatePortTest-1874336544','a87a1013-5151-4078-b161-7cd0d1f2732e','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(181,'34eac49a-caa7-4536-b409-6bc01e1c4959','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:07',NULL,'CREATE','IN_PROGRESS','net','UpdatePortTest-1874336544-net-wp5lui7uavag','state changed','OS::Neutron::Net',NULL,NULL),(182,'c050dae8-58d7-4f3a-8f13-170dabb0c5bf','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:49:07',NULL,'DELETE','COMPLETE','trunk_subnet_two','f5483e53-8a83-49e1-b64b-1085434f337b','state changed','OS::Neutron::Subnet',NULL,26),(183,'1693b289-ab74-48d5-b72f-725452cdfc9b','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:49:07',NULL,'DELETE','COMPLETE','parent_subnet','f1613363-eef1-4f7c-b25f-61ea154654c3','state changed','OS::Neutron::Subnet',NULL,22),(184,'2bcd8b21-77b1-436d-a9aa-4f8a3d089edc','db0d8406-58f5-4eb8-bc97-33536064c0b9','2026-01-21 11:49:07',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-122967512','db0d8406-58f5-4eb8-bc97-33536064c0b9','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(185,'76b46af7-48f3-488d-ab7f-f6f88e9befd3','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:49:07',NULL,'DELETE','IN_PROGRESS','trunk_net_two','0ef98077-903c-4874-855b-171ffda59242','state changed','OS::Neutron::Net',NULL,NULL),(186,'d2827cb9-5ed3-4f8f-a92f-be0d08036d89','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:49:07',NULL,'DELETE','IN_PROGRESS','parent_net','e4393cde-e6c8-4bf8-a5e9-d0369150e594','state changed','OS::Neutron::Net',NULL,NULL),(187,'36a1646a-c541-478c-9af7-4c93a07d9b1a','db0d8406-58f5-4eb8-bc97-33536064c0b9','2026-01-21 11:49:07',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-122967512-net-flxqojjw332k','state changed','OS::Neutron::Net',NULL,NULL),(188,'2e04223d-b9da-4e95-a30f-922dbb02ff84','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:49:07',NULL,'DELETE','COMPLETE','trunk_subnet_one','3b39cb20-2b10-40d3-9de2-9220cad3d4f4','state changed','OS::Neutron::Subnet',NULL,19),(189,'c71069a8-4c7c-4911-8858-5d38615b56e1','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:49:07',NULL,'DELETE','IN_PROGRESS','trunk_net_one','7f219b54-86f6-44e3-86cf-243b418b95ea','state changed','OS::Neutron::Net',NULL,NULL),(190,'9dd6831b-8c71-48fc-ae26-d55b02b69a12','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:49:08',NULL,'DELETE','COMPLETE','trunk_net_two','0ef98077-903c-4874-855b-171ffda59242','state changed','OS::Neutron::Net',NULL,NULL),(191,'8586ea0d-dad8-4b1f-bb63-d34adbee43c3','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:49:08',NULL,'DELETE','COMPLETE','parent_net','e4393cde-e6c8-4bf8-a5e9-d0369150e594','state changed','OS::Neutron::Net',NULL,NULL),(192,'6522ae6c-cbc6-4f6e-bd08-792e09ec1773','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:09',NULL,'CREATE','COMPLETE','net','ce84737d-2122-46a5-8210-58ef919fc471','state changed','OS::Neutron::Net',NULL,NULL),(193,'36386f8e-6a40-4f6b-a569-242bdf14a2ad','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:09',NULL,'CREATE','IN_PROGRESS','subnet','UpdatePortTest-1874336544-subnet-2ieievhzwb5u','state changed','OS::Neutron::Subnet',NULL,37),(194,'6d25b53b-bfd0-426b-a02d-193552682a24','db0d8406-58f5-4eb8-bc97-33536064c0b9','2026-01-21 11:49:09',NULL,'CREATE','COMPLETE','net','b49a204f-b0fa-44f3-a6cf-dbbef5cfdb28','state changed','OS::Neutron::Net',NULL,NULL),(195,'98c7c5f5-09ad-42bb-963b-2c2ae49a0d01','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:49:09',NULL,'DELETE','COMPLETE','trunk_net_one','7f219b54-86f6-44e3-86cf-243b418b95ea','state changed','OS::Neutron::Net',NULL,NULL),(196,'c1425194-321a-449b-9e1b-0c3f610b71fa','f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:49:09',NULL,'DELETE','COMPLETE','UpdateTrunkTest-1943635260','f2da6721-6e76-4187-a126-a4b260ddbda9','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(197,'c9ae8ea7-3796-47da-9f96-ea9291084dc9','db0d8406-58f5-4eb8-bc97-33536064c0b9','2026-01-21 11:49:09',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-122967512-subnet-me5ppvk6nj7w','state changed','OS::Neutron::Subnet',NULL,38),(198,'6f846752-957a-419e-a908-c6515d901413','a09fb5bd-6204-4fac-b2ea-0624f40a5b0d','2026-01-21 11:49:09',NULL,'DELETE','COMPLETE','server_with_encrypted_property','339eb7cd-fd41-4c85-8e90-8c04a28b6725','state changed','OS::Nova::Server',NULL,21),(199,'777e9180-5969-4f1d-bdf4-3b9ee89a3994','a09fb5bd-6204-4fac-b2ea-0624f40a5b0d','2026-01-21 11:49:09',NULL,'DELETE','COMPLETE','EncryptedParametersTest-859287547','a09fb5bd-6204-4fac-b2ea-0624f40a5b0d','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(200,'159f89c0-3ab4-443d-8ffe-413fc1714e99','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:09',NULL,'CREATE','COMPLETE','subnet','75e43cea-8fde-4ba2-9f47-2022a8a832f5','state changed','OS::Neutron::Subnet',NULL,37),(201,'a41f526a-7381-4f79-ad81-ad3b15353721','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:09',NULL,'CREATE','IN_PROGRESS','port','UpdatePortTest-1874336544-port-wsa6hs2neyjn','state changed','OS::Neutron::Port',NULL,39),(202,'acfc3d50-7ff9-4e0d-be85-c3d78326a0a8','db0d8406-58f5-4eb8-bc97-33536064c0b9','2026-01-21 11:49:10',NULL,'CREATE','COMPLETE','subnet','09f0687d-be52-41a5-b609-5c206198573d','state changed','OS::Neutron::Subnet',NULL,38),(203,'288dd44b-d823-473a-ac81-91ff18365b18','db0d8406-58f5-4eb8-bc97-33536064c0b9','2026-01-21 11:49:10',NULL,'CREATE','COMPLETE','UpdateSubnetTest-122967512','db0d8406-58f5-4eb8-bc97-33536064c0b9','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(204,'cdc79482-e396-4ca6-a924-9dd296807edc','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:10',NULL,'CREATE','COMPLETE','port','30b3c16c-20fb-4fa4-89cf-7b85091962db','state changed','OS::Neutron::Port',NULL,39),(205,'362dd14f-b862-4e7c-b05e-7767936d71c6','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:10',NULL,'CREATE','IN_PROGRESS','test','UpdatePortTest-1874336544-test-6akydeisgo63','state changed','OS::Heat::TestResource',NULL,41),(206,'1d2b342d-cb60-47c2-9575-c255a8e403de','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:10',NULL,'CREATE','COMPLETE','test','UpdatePortTest-1874336544-test-6akydeisgo63','state changed','OS::Heat::TestResource',NULL,41),(207,'e1a7a265-ac5b-40ea-b431-03b6b72f035d','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:10',NULL,'CREATE','COMPLETE','UpdatePortTest-1874336544','a87a1013-5151-4078-b161-7cd0d1f2732e','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(208,'9d0213be-e2a9-413f-ac6e-f82e086a3420','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:11',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-219271161','c9dd4243-191a-4a39-8267-073b47cef24a','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(209,'6d5065d1-7800-4cd7-9292-f9e25b6c208d','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:11',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-219271161-parent_net-k37icbfm6v66','state changed','OS::Neutron::Net',NULL,NULL),(210,'779bcbe6-28d0-412f-8757-86f177f85e5e','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:12',NULL,'CREATE','COMPLETE','parent_net','71b25559-a0fd-4e5f-9ebf-8810b36bfd52','state changed','OS::Neutron::Net',NULL,NULL),(211,'37bbcaab-b741-4e18-a8dd-442a3ba6cf4a','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:12',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-219271161-parent_subnet-glpx5ejlkpfe','state changed','OS::Neutron::Subnet',NULL,43),(212,'7a62ee74-4298-4f3b-9e8c-481e8dec39cd','db0d8406-58f5-4eb8-bc97-33536064c0b9','2026-01-21 11:49:12',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-122967512','db0d8406-58f5-4eb8-bc97-33536064c0b9','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(213,'f61f3100-9448-4d19-9e28-28de0fd3c91b','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:12',NULL,'UPDATE','IN_PROGRESS','UpdatePortTest-1874336544','a87a1013-5151-4078-b161-7cd0d1f2732e','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(214,'8a404f32-8b64-4726-a677-96678d6798a1','aa5fe92b-0d83-4605-ac05-6096edf46c87','2026-01-21 11:49:12',NULL,'CREATE','IN_PROGRESS','server_with_port','aa5fe92b-0d83-4605-ac05-6096edf46c87','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(215,'6bef8576-f7f3-48de-aed8-2304d3e945e1','db0d8406-58f5-4eb8-bc97-33536064c0b9','2026-01-21 11:49:12',NULL,'UPDATE','IN_PROGRESS','subnet','09f0687d-be52-41a5-b609-5c206198573d','state changed','OS::Neutron::Subnet',NULL,38),(216,'74facf35-ae02-4421-9505-3bb0bfb13f78','aa5fe92b-0d83-4605-ac05-6096edf46c87','2026-01-21 11:49:12',NULL,'CREATE','IN_PROGRESS','net','server_with_port-net-je3agcunijh6','state changed','OS::Neutron::Net',NULL,44),(217,'88ffdbfa-9741-4d21-baeb-af72b7e2085c','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:12',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-219271161-trunk_net_two-jc2qhna2cn5l','state changed','OS::Neutron::Net',NULL,NULL),(218,'924686c9-1ed3-4372-a1a1-d5795303d5d6','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:13',NULL,'UPDATE','IN_PROGRESS','port','30b3c16c-20fb-4fa4-89cf-7b85091962db','state changed','OS::Neutron::Port',NULL,39),(219,'f8add940-87e6-40ea-a64c-5e2822f269f6','aa5fe92b-0d83-4605-ac05-6096edf46c87','2026-01-21 11:49:14',NULL,'CREATE','COMPLETE','net','0d216dc4-08c7-4c79-9890-347b3967b8d0','state changed','OS::Neutron::Net',NULL,44),(220,'51f2525c-4865-4598-93d2-0de74b726513','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:14',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-219271161-trunk_net_one-rn7zubqlxawd','state changed','OS::Neutron::Net',NULL,NULL),(221,'1f5e18fc-8cb8-4559-89a2-cceaec2033f7','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:14',NULL,'CREATE','COMPLETE','trunk_net_two','0dc0f61e-d359-4009-8df5-b85f84f6aa12','state changed','OS::Neutron::Net',NULL,NULL),(222,'aa83f973-95ef-4fe7-a041-6bca10aa1aea','aa5fe92b-0d83-4605-ac05-6096edf46c87','2026-01-21 11:49:14',NULL,'CREATE','IN_PROGRESS','subnet','server_with_port-subnet-ngaqckxbvi76','state changed','OS::Neutron::Subnet',NULL,45),(223,'133830bc-4825-4a47-bdd7-5d367fc96b19','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:14',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-219271161-trunk_subnet_two-3ayokuzma365','state changed','OS::Neutron::Subnet',NULL,46),(224,'6749c8cb-5126-44d5-acd8-93eadb7c6744','db0d8406-58f5-4eb8-bc97-33536064c0b9','2026-01-21 11:49:14',NULL,'UPDATE','COMPLETE','subnet','09f0687d-be52-41a5-b609-5c206198573d','state changed','OS::Neutron::Subnet',NULL,47),(225,'1f3f13b1-d153-4dc8-a492-5757cbfc6119','db0d8406-58f5-4eb8-bc97-33536064c0b9','2026-01-21 11:49:14',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-122967512','db0d8406-58f5-4eb8-bc97-33536064c0b9','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(226,'6fca9029-226a-445f-bb5d-2fcc2654638c','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:14',NULL,'CREATE','COMPLETE','parent_subnet','e51f6eab-ef2e-4f68-ba12-f6dfbeb38d66','state changed','OS::Neutron::Subnet',NULL,43),(227,'438382e7-a361-49a6-9452-6c3c697a1233','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:14',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-219271161-parent_port-g7njft4zmtvz','state changed','OS::Neutron::Port',NULL,48),(228,'d807d6b2-92d7-43b4-ba5e-a08472980d61','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:15',NULL,'CREATE','COMPLETE','trunk_net_one','11b02936-21f2-4dba-843d-46eb6ca5c23b','state changed','OS::Neutron::Net',NULL,NULL),(229,'3960f21d-3a31-4cc0-9bbb-3669c3caebce','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:15',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-219271161-trunk_subnet_one-2czuoxcjhmwa','state changed','OS::Neutron::Subnet',NULL,49),(230,'814d6d65-2c5d-4d7a-9b96-2db572bc031f','aa5fe92b-0d83-4605-ac05-6096edf46c87','2026-01-21 11:49:15',NULL,'CREATE','COMPLETE','subnet','4372117e-4248-4dfd-9e36-53aa08cc5053','state changed','OS::Neutron::Subnet',NULL,45),(231,'2e249a41-beca-4055-a8e7-8f3ded97cab1','aa5fe92b-0d83-4605-ac05-6096edf46c87','2026-01-21 11:49:15',NULL,'CREATE','IN_PROGRESS','port','server_with_port-port-77644igagj27','state changed','OS::Neutron::Port',NULL,50),(232,'047851b8-9515-465e-8360-a175eb21af9a','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:15',NULL,'UPDATE','COMPLETE','port','30b3c16c-20fb-4fa4-89cf-7b85091962db','The Resource port requires replacement.','OS::Neutron::Port',NULL,39),(233,'fb70cb8b-7767-4010-a5d5-56cb1cb2d073','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:15',NULL,'CREATE','IN_PROGRESS','port','UpdatePortTest-1874336544-port-46a7lipjng4b','state changed','OS::Neutron::Port',NULL,51),(234,'8b791df7-6f7e-4f97-81a0-42cdc9bff018','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:16',NULL,'CREATE','COMPLETE','parent_port','c38d4a29-45b3-40d1-851f-eb814bdabda5','state changed','OS::Neutron::Port',NULL,48),(235,'5e8dad06-8868-4f69-9ee1-d19c9c64127b','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:16',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-219271161-trunk-umnfz2cbr7pw','state changed','OS::Neutron::Trunk',NULL,52),(236,'e280356a-f63f-401e-b160-6f9a6441735d','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:16',NULL,'CREATE','COMPLETE','trunk_subnet_two','87e19108-0e81-4d0d-b0b6-ac3d9da05c01','state changed','OS::Neutron::Subnet',NULL,46),(237,'0df80c75-7a94-4ba2-a30d-8e9296292987','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:16',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-219271161-sub_port_two-ukvtfkmhpy2m','state changed','OS::Neutron::Port',NULL,53),(238,'3376a7b4-2ebd-4aef-919f-f737233bc5ba','aa5fe92b-0d83-4605-ac05-6096edf46c87','2026-01-21 11:49:16',NULL,'CREATE','COMPLETE','port','f4e611c0-d2ea-47a0-9fed-6207aee8fad3','state changed','OS::Neutron::Port',NULL,50),(239,'debdba89-c47b-4fd5-95af-e67e0d345162','aa5fe92b-0d83-4605-ac05-6096edf46c87','2026-01-21 11:49:16',NULL,'CREATE','IN_PROGRESS','server','server_with_port-server-wf7e5yjtiiyb','state changed','OS::Nova::Server',NULL,54),(240,'5200dead-adf3-4385-baf1-b11c1b6047b6','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:16',NULL,'CREATE','COMPLETE','trunk_subnet_one','037b2d99-15b0-44b1-a656-f1f534c0ab63','state changed','OS::Neutron::Subnet',NULL,49),(241,'9e98769c-4eaa-424d-8f4e-ccc2a7d585fc','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:16',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-219271161-sub_port_one-m5ubqnectrhq','state changed','OS::Neutron::Port',NULL,55),(242,'076b8901-c90b-4776-bd4e-232ed69bdc2f','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:16',NULL,'CREATE','COMPLETE','port','5242051d-6540-4f59-8bef-3531fa220c06','state changed','OS::Neutron::Port',NULL,51),(243,'7b1fe670-c4f4-463a-aad6-f9e8ce1b50f9','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:16',NULL,'CREATE','COMPLETE','trunk','8af12ce0-66b1-4789-9e5f-f51ef1408ef6','state changed','OS::Neutron::Trunk',NULL,52),(244,'ef8d11a1-3a77-4eec-855b-9126298170de','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:17',NULL,'DELETE','IN_PROGRESS','port','30b3c16c-20fb-4fa4-89cf-7b85091962db','state changed','OS::Neutron::Port',NULL,39),(245,'f8255a99-1a46-496c-aa42-3f6a1a9e3972','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:17',NULL,'CREATE','COMPLETE','sub_port_two','ec88303a-1f6e-4b42-b373-7b0d0b48b596','state changed','OS::Neutron::Port',NULL,53),(246,'95bfe7ec-8fe8-4b26-854d-a46e0388323f','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:17',NULL,'CREATE','COMPLETE','sub_port_one','17d1ff55-cd1b-413a-acbf-e7f4ec6180f3','state changed','OS::Neutron::Port',NULL,55),(247,'3c7650a6-8710-4cc5-a7f5-09dd8f9cd729','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:17',NULL,'CREATE','COMPLETE','UpdateTrunkTest-219271161','c9dd4243-191a-4a39-8267-073b47cef24a','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(248,'7a157804-4861-4eb7-9642-7733c402fbea','db0d8406-58f5-4eb8-bc97-33536064c0b9','2026-01-21 11:49:17',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-122967512','db0d8406-58f5-4eb8-bc97-33536064c0b9','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(249,'826211be-d929-4711-bae6-2ad0fefc774a','db0d8406-58f5-4eb8-bc97-33536064c0b9','2026-01-21 11:49:17',NULL,'DELETE','IN_PROGRESS','subnet','09f0687d-be52-41a5-b609-5c206198573d','state changed','OS::Neutron::Subnet',NULL,47),(250,'ad65e000-19f8-422f-9193-865c996bec32','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:17',NULL,'DELETE','COMPLETE','port','30b3c16c-20fb-4fa4-89cf-7b85091962db','state changed','OS::Neutron::Port',NULL,39),(251,'104edab2-1002-4ad4-a131-25713635ecf2','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:17',NULL,'UPDATE','COMPLETE','UpdatePortTest-1874336544','a87a1013-5151-4078-b161-7cd0d1f2732e','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(252,'bb691295-352d-4f58-a003-142bfa81d4e6','db0d8406-58f5-4eb8-bc97-33536064c0b9','2026-01-21 11:49:17',NULL,'DELETE','COMPLETE','subnet','09f0687d-be52-41a5-b609-5c206198573d','state changed','OS::Neutron::Subnet',NULL,47),(253,'90f04097-dedf-404e-b60d-379566ca4a85','db0d8406-58f5-4eb8-bc97-33536064c0b9','2026-01-21 11:49:17',NULL,'DELETE','IN_PROGRESS','net','b49a204f-b0fa-44f3-a6cf-dbbef5cfdb28','state changed','OS::Neutron::Net',NULL,NULL),(254,'38a5afb4-1626-45d0-938d-83b4a417a452','db0d8406-58f5-4eb8-bc97-33536064c0b9','2026-01-21 11:49:19',NULL,'DELETE','COMPLETE','net','b49a204f-b0fa-44f3-a6cf-dbbef5cfdb28','state changed','OS::Neutron::Net',NULL,NULL),(255,'f34d85ee-b11f-42f7-8330-e76b4d371f28','db0d8406-58f5-4eb8-bc97-33536064c0b9','2026-01-21 11:49:19',NULL,'DELETE','COMPLETE','UpdateSubnetTest-122967512','db0d8406-58f5-4eb8-bc97-33536064c0b9','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(256,'19a083f0-09f5-45dc-92c8-b673c8971980','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:20',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-219271161','c9dd4243-191a-4a39-8267-073b47cef24a','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(257,'0f71fb08-632b-4fc0-97bd-441ee0d66b2e','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:21',NULL,'DELETE','IN_PROGRESS','UpdatePortTest-1874336544','a87a1013-5151-4078-b161-7cd0d1f2732e','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(258,'e14ce7a7-bea9-4c2b-84a1-d50f822ffb89','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:22',NULL,'DELETE','IN_PROGRESS','port','5242051d-6540-4f59-8bef-3531fa220c06','state changed','OS::Neutron::Port',NULL,51),(259,'30b60f15-1d22-4070-a03c-0d4c29cff15e','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:22',NULL,'DELETE','COMPLETE','port','5242051d-6540-4f59-8bef-3531fa220c06','state changed','OS::Neutron::Port',NULL,51),(260,'033504bd-98b4-41d2-9070-286c324a834e','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:22',NULL,'DELETE','IN_PROGRESS','subnet','75e43cea-8fde-4ba2-9f47-2022a8a832f5','state changed','OS::Neutron::Subnet',NULL,37),(261,'2f3033be-2950-43dc-8ff3-4bba927633fd','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:23',NULL,'DELETE','IN_PROGRESS','test','UpdatePortTest-1874336544-test-6akydeisgo63','state changed','OS::Heat::TestResource',NULL,41),(262,'15cb0e52-c185-4cd1-8561-cfe2bcf31468','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:23',NULL,'DELETE','COMPLETE','test','UpdatePortTest-1874336544-test-6akydeisgo63','state changed','OS::Heat::TestResource',NULL,41),(263,'9cce3863-8e35-4196-8a5b-6348c956f6d3','6c038782-44a6-4f1a-a6e0-4827cc803bc3','2026-01-21 11:49:23',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-368818728','6c038782-44a6-4f1a-a6e0-4827cc803bc3','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(264,'3754e096-4284-48e2-a3f6-3fa15134442b','6c038782-44a6-4f1a-a6e0-4827cc803bc3','2026-01-21 11:49:23',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-368818728-net-wwxdhgeqqjzg','state changed','OS::Neutron::Net',NULL,NULL),(265,'22452530-4fea-4f0d-8b9d-a8470fd40698','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:23',NULL,'DELETE','COMPLETE','subnet','75e43cea-8fde-4ba2-9f47-2022a8a832f5','state changed','OS::Neutron::Subnet',NULL,37),(266,'6550a59e-691d-4f89-8aa1-ce88c9adce85','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:23',NULL,'DELETE','IN_PROGRESS','net','ce84737d-2122-46a5-8210-58ef919fc471','state changed','OS::Neutron::Net',NULL,NULL),(267,'f7893ef4-ad19-4e4f-a44b-1b4500994382','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:23',NULL,'UPDATE','IN_PROGRESS','trunk','8af12ce0-66b1-4789-9e5f-f51ef1408ef6','state changed','OS::Neutron::Trunk',NULL,52),(268,'93cd12b4-268e-4aa0-83c1-521e56a16c59','6c038782-44a6-4f1a-a6e0-4827cc803bc3','2026-01-21 11:49:24',NULL,'CREATE','COMPLETE','net','3c72fd72-2d04-47f0-ac76-cee5d5aee494','state changed','OS::Neutron::Net',NULL,NULL),(269,'a05546bd-4fd3-41c2-a56f-5b2baaeb720b','6c038782-44a6-4f1a-a6e0-4827cc803bc3','2026-01-21 11:49:24',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-368818728-subnet-6efp2agx3nfb','state changed','OS::Neutron::Subnet',NULL,58),(270,'a53aeee9-9583-4982-8e56-76365bf861ca','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:25',NULL,'DELETE','COMPLETE','net','ce84737d-2122-46a5-8210-58ef919fc471','state changed','OS::Neutron::Net',NULL,NULL),(271,'23b4692a-f471-430e-af29-c2a87be2803f','a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:25',NULL,'DELETE','COMPLETE','UpdatePortTest-1874336544','a87a1013-5151-4078-b161-7cd0d1f2732e','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(272,'71fb1977-eaba-40a2-b1f1-1127b21e973f','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:25',NULL,'UPDATE','COMPLETE','trunk','8af12ce0-66b1-4789-9e5f-f51ef1408ef6','state changed','OS::Neutron::Trunk',NULL,59),(273,'38b3e2aa-e635-433b-a673-186eedfaf13e','6c038782-44a6-4f1a-a6e0-4827cc803bc3','2026-01-21 11:49:26',NULL,'CREATE','COMPLETE','subnet','c99b34b4-08ad-4b20-b75a-b0ae26727ec8','state changed','OS::Neutron::Subnet',NULL,58),(274,'d0b41142-3b4b-4bbe-ad92-982183b7a116','6c038782-44a6-4f1a-a6e0-4827cc803bc3','2026-01-21 11:49:26',NULL,'CREATE','COMPLETE','UpdateSubnetTest-368818728','6c038782-44a6-4f1a-a6e0-4827cc803bc3','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(275,'9cd84da1-0e68-4a14-8ee7-ddc7be774f05','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:26',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-219271161','c9dd4243-191a-4a39-8267-073b47cef24a','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(276,'50fa27ed-2dac-4dd0-afbf-4bd6b4950ff7','aa5fe92b-0d83-4605-ac05-6096edf46c87','2026-01-21 11:49:26',NULL,'CREATE','COMPLETE','server','2e4decb8-ef75-42b8-bbb1-540b0009cd41','state changed','OS::Nova::Server',NULL,54),(277,'79572cec-85bd-4c79-8617-faa5f1a45cbf','aa5fe92b-0d83-4605-ac05-6096edf46c87','2026-01-21 11:49:26',NULL,'CREATE','COMPLETE','server_with_port','aa5fe92b-0d83-4605-ac05-6096edf46c87','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(278,'8ae6104d-df35-4bd7-b7db-2043c786349d','6c038782-44a6-4f1a-a6e0-4827cc803bc3','2026-01-21 11:49:28',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-368818728','6c038782-44a6-4f1a-a6e0-4827cc803bc3','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(279,'f2b55707-4098-409d-95b0-bc479ebd3e78','6c038782-44a6-4f1a-a6e0-4827cc803bc3','2026-01-21 11:49:28',NULL,'UPDATE','IN_PROGRESS','subnet','c99b34b4-08ad-4b20-b75a-b0ae26727ec8','state changed','OS::Neutron::Subnet',NULL,58),(280,'557a1430-9433-45d7-9389-24af9e03cfda','6c038782-44a6-4f1a-a6e0-4827cc803bc3','2026-01-21 11:49:29',NULL,'UPDATE','COMPLETE','subnet','c99b34b4-08ad-4b20-b75a-b0ae26727ec8','state changed','OS::Neutron::Subnet',NULL,61),(281,'27b898b8-4aa5-48a3-a2dd-4b2f727e9ead','6c038782-44a6-4f1a-a6e0-4827cc803bc3','2026-01-21 11:49:29',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-368818728','6c038782-44a6-4f1a-a6e0-4827cc803bc3','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(282,'90af4c60-a711-42cc-bcf4-1fcbb34e87af','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:29',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-219271161','c9dd4243-191a-4a39-8267-073b47cef24a','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(283,'be41329b-5856-488d-928a-b1f47e37daed','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:29',NULL,'DELETE','IN_PROGRESS','trunk','8af12ce0-66b1-4789-9e5f-f51ef1408ef6','state changed','OS::Neutron::Trunk',NULL,59),(284,'0a8f27f4-8d53-42c1-8a67-bf4133ea0c46','aa5fe92b-0d83-4605-ac05-6096edf46c87','2026-01-21 11:49:29',NULL,'DELETE','IN_PROGRESS','server_with_port','aa5fe92b-0d83-4605-ac05-6096edf46c87','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(285,'0bb157fa-d0de-497f-9826-2c0af4228a6b','aa5fe92b-0d83-4605-ac05-6096edf46c87','2026-01-21 11:49:29',NULL,'DELETE','IN_PROGRESS','server','2e4decb8-ef75-42b8-bbb1-540b0009cd41','state changed','OS::Nova::Server',NULL,54),(286,'c8e50dd8-3bd2-4e28-8ddf-ea2a302d6d2d','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:29',NULL,'DELETE','COMPLETE','trunk','8af12ce0-66b1-4789-9e5f-f51ef1408ef6','state changed','OS::Neutron::Trunk',NULL,59),(287,'db5a5419-4009-40fc-943c-ae8ab1b4ce02','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:29',NULL,'DELETE','IN_PROGRESS','parent_port','c38d4a29-45b3-40d1-851f-eb814bdabda5','state changed','OS::Neutron::Port',NULL,48),(288,'db7a66c4-55d6-4d45-9ead-05fc98dfcd8b','d2910e40-27de-491e-84bb-455bd2056f13','2026-01-21 11:49:29',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-2126207766','d2910e40-27de-491e-84bb-455bd2056f13','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(289,'dc21f170-578d-4f0d-b8be-cc080f602527','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:29',NULL,'DELETE','IN_PROGRESS','sub_port_one','17d1ff55-cd1b-413a-acbf-e7f4ec6180f3','state changed','OS::Neutron::Port',NULL,55),(290,'1a916b0f-8924-447d-af3f-89235948fdf0','d2910e40-27de-491e-84bb-455bd2056f13','2026-01-21 11:49:29',NULL,'CREATE','IN_PROGRESS','random1','RemoteStackTest-2126207766-random1-2laxvlahxui6','state changed','OS::Heat::RandomString',NULL,NULL),(291,'73e2db2d-e8be-4696-9d6e-3459c9a02107','d2910e40-27de-491e-84bb-455bd2056f13','2026-01-21 11:49:29',NULL,'CREATE','COMPLETE','random1','RemoteStackTest-2126207766-random1-2laxvlahxui6','state changed','OS::Heat::RandomString',NULL,NULL),(292,'41d8e942-7df9-4bf4-be84-2fc8819950f1','d2910e40-27de-491e-84bb-455bd2056f13','2026-01-21 11:49:29',NULL,'CREATE','COMPLETE','RemoteStackTest-2126207766','d2910e40-27de-491e-84bb-455bd2056f13','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(293,'327b2be5-401d-473b-9abf-491007b123f4','d2910e40-27de-491e-84bb-455bd2056f13','2026-01-21 11:49:30',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-2126207766','d2910e40-27de-491e-84bb-455bd2056f13','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(294,'2e51b5b8-6951-4a45-82bd-4daf4f0e267c','d2910e40-27de-491e-84bb-455bd2056f13','2026-01-21 11:49:30',NULL,'DELETE','IN_PROGRESS','random1','RemoteStackTest-2126207766-random1-2laxvlahxui6','state changed','OS::Heat::RandomString',NULL,NULL),(295,'2a519b75-c3c2-4686-89e2-63aa5f5bf7f2','d2910e40-27de-491e-84bb-455bd2056f13','2026-01-21 11:49:30',NULL,'DELETE','COMPLETE','random1','RemoteStackTest-2126207766-random1-2laxvlahxui6','state changed','OS::Heat::RandomString',NULL,NULL),(296,'9a0015f5-976f-4035-9e3d-e4a604ae63ec','d2910e40-27de-491e-84bb-455bd2056f13','2026-01-21 11:49:30',NULL,'DELETE','COMPLETE','RemoteStackTest-2126207766','d2910e40-27de-491e-84bb-455bd2056f13','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(297,'f9cbdb81-2b26-4915-98e9-012223441689','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:30',NULL,'DELETE','COMPLETE','parent_port','c38d4a29-45b3-40d1-851f-eb814bdabda5','state changed','OS::Neutron::Port',NULL,48),(298,'90871d2e-2d18-4bf5-9831-afc3768f0cb1','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:30',NULL,'DELETE','COMPLETE','sub_port_one','17d1ff55-cd1b-413a-acbf-e7f4ec6180f3','state changed','OS::Neutron::Port',NULL,55),(299,'58d274df-ce45-44f3-b3fe-8038dac6b074','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:30',NULL,'DELETE','IN_PROGRESS','sub_port_two','ec88303a-1f6e-4b42-b373-7b0d0b48b596','state changed','OS::Neutron::Port',NULL,53),(300,'d7d9b919-f84d-499d-a06a-d44ea71660f1','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:30',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','037b2d99-15b0-44b1-a656-f1f534c0ab63','state changed','OS::Neutron::Subnet',NULL,49),(301,'65bb3d4c-1770-4722-b042-dd25ea883ecb','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:30',NULL,'DELETE','IN_PROGRESS','parent_subnet','e51f6eab-ef2e-4f68-ba12-f6dfbeb38d66','state changed','OS::Neutron::Subnet',NULL,43),(302,'38a4c2ae-bddf-4905-a9e9-bd20b28f1b68','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:31',NULL,'DELETE','COMPLETE','trunk_subnet_one','037b2d99-15b0-44b1-a656-f1f534c0ab63','state changed','OS::Neutron::Subnet',NULL,49),(303,'9793f8cb-4e3e-4ff0-a80f-b83aaa13add5','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:31',NULL,'DELETE','COMPLETE','parent_subnet','e51f6eab-ef2e-4f68-ba12-f6dfbeb38d66','state changed','OS::Neutron::Subnet',NULL,43),(304,'0c83d570-050a-436f-a2cd-d80cd35810b6','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:31',NULL,'DELETE','COMPLETE','sub_port_two','ec88303a-1f6e-4b42-b373-7b0d0b48b596','state changed','OS::Neutron::Port',NULL,53),(305,'d3c6f6bc-ef2d-4bcb-817d-cf31a1a39b67','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:31',NULL,'DELETE','IN_PROGRESS','trunk_net_one','11b02936-21f2-4dba-843d-46eb6ca5c23b','state changed','OS::Neutron::Net',NULL,NULL),(306,'302cb0de-ca7a-4f92-999d-8db204d96706','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:31',NULL,'DELETE','IN_PROGRESS','parent_net','71b25559-a0fd-4e5f-9ebf-8810b36bfd52','state changed','OS::Neutron::Net',NULL,NULL),(307,'536110af-c1f0-4a62-9a70-7d0861a4c7d3','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:31',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','87e19108-0e81-4d0d-b0b6-ac3d9da05c01','state changed','OS::Neutron::Subnet',NULL,46),(308,'e79777fe-ff30-49b1-834e-121eca6f209b','aa5fe92b-0d83-4605-ac05-6096edf46c87','2026-01-21 11:49:31',NULL,'DELETE','COMPLETE','server','2e4decb8-ef75-42b8-bbb1-540b0009cd41','state changed','OS::Nova::Server',NULL,54),(309,'cfaa11ad-2d8d-4803-93ab-5a029eb69edb','aa5fe92b-0d83-4605-ac05-6096edf46c87','2026-01-21 11:49:31',NULL,'DELETE','IN_PROGRESS','port','f4e611c0-d2ea-47a0-9fed-6207aee8fad3','state changed','OS::Neutron::Port',NULL,50),(310,'3577f334-de87-4635-95c4-540129b568b3','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:31',NULL,'DELETE','COMPLETE','trunk_subnet_two','87e19108-0e81-4d0d-b0b6-ac3d9da05c01','state changed','OS::Neutron::Subnet',NULL,46),(311,'6e9a374d-b4ff-4ac1-8c18-d2252cc8be57','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:31',NULL,'DELETE','IN_PROGRESS','trunk_net_two','0dc0f61e-d359-4009-8df5-b85f84f6aa12','state changed','OS::Neutron::Net',NULL,NULL),(312,'105ecc43-ea1d-45dd-a95a-8fa0aff24e65','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:31',NULL,'DELETE','COMPLETE','trunk_net_one','11b02936-21f2-4dba-843d-46eb6ca5c23b','state changed','OS::Neutron::Net',NULL,NULL),(313,'90a25d23-9321-4cfb-b92d-ed1e14b79fef','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:31',NULL,'DELETE','COMPLETE','parent_net','71b25559-a0fd-4e5f-9ebf-8810b36bfd52','state changed','OS::Neutron::Net',NULL,NULL),(314,'eda123b0-97b3-4c0a-8e01-4686c8489c19','aa5fe92b-0d83-4605-ac05-6096edf46c87','2026-01-21 11:49:32',NULL,'DELETE','COMPLETE','port','f4e611c0-d2ea-47a0-9fed-6207aee8fad3','state changed','OS::Neutron::Port',NULL,50),(315,'9fe333cd-80db-40ee-a981-b42393af4acf','aa5fe92b-0d83-4605-ac05-6096edf46c87','2026-01-21 11:49:32',NULL,'DELETE','IN_PROGRESS','subnet','4372117e-4248-4dfd-9e36-53aa08cc5053','state changed','OS::Neutron::Subnet',NULL,45),(316,'16a5a6c8-5fb7-455a-8dbb-31da1f79a45e','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:32',NULL,'DELETE','COMPLETE','trunk_net_two','0dc0f61e-d359-4009-8df5-b85f84f6aa12','state changed','OS::Neutron::Net',NULL,NULL),(317,'3ad97271-087c-4050-9641-c6cf6aa5b136','c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:32',NULL,'DELETE','COMPLETE','UpdateTrunkTest-219271161','c9dd4243-191a-4a39-8267-073b47cef24a','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(318,'79f7a8c3-0e2b-4cf9-8ef2-7303032278f9','aa5fe92b-0d83-4605-ac05-6096edf46c87','2026-01-21 11:49:32',NULL,'DELETE','COMPLETE','subnet','4372117e-4248-4dfd-9e36-53aa08cc5053','state changed','OS::Neutron::Subnet',NULL,45),(319,'3021a67c-15a0-48ba-a4b2-6b83603a5d9b','aa5fe92b-0d83-4605-ac05-6096edf46c87','2026-01-21 11:49:32',NULL,'DELETE','IN_PROGRESS','net','0d216dc4-08c7-4c79-9890-347b3967b8d0','state changed','OS::Neutron::Net',NULL,44),(320,'35e3a3bd-f418-4eb9-ba4f-9ed053ca9e35','aa5fe92b-0d83-4605-ac05-6096edf46c87','2026-01-21 11:49:32',NULL,'DELETE','COMPLETE','net','0d216dc4-08c7-4c79-9890-347b3967b8d0','state changed','OS::Neutron::Net',NULL,44),(321,'b4542c82-b440-4323-95d7-ea9fc9b27031','aa5fe92b-0d83-4605-ac05-6096edf46c87','2026-01-21 11:49:32',NULL,'DELETE','COMPLETE','server_with_port','aa5fe92b-0d83-4605-ac05-6096edf46c87','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(322,'3bfed24c-4391-4202-84c8-c72f255a04a1','6c038782-44a6-4f1a-a6e0-4827cc803bc3','2026-01-21 11:49:33',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-368818728','6c038782-44a6-4f1a-a6e0-4827cc803bc3','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(323,'cbf709d0-bc16-4e7f-90f4-304a520dc970','6c038782-44a6-4f1a-a6e0-4827cc803bc3','2026-01-21 11:49:33',NULL,'DELETE','IN_PROGRESS','subnet','c99b34b4-08ad-4b20-b75a-b0ae26727ec8','state changed','OS::Neutron::Subnet',NULL,61),(324,'fb83e894-526d-4e12-b12d-f3dc6d6b2269','6c038782-44a6-4f1a-a6e0-4827cc803bc3','2026-01-21 11:49:33',NULL,'DELETE','COMPLETE','subnet','c99b34b4-08ad-4b20-b75a-b0ae26727ec8','state changed','OS::Neutron::Subnet',NULL,61),(325,'3121bef2-2dac-4852-896f-4b9cfdde1abb','6c038782-44a6-4f1a-a6e0-4827cc803bc3','2026-01-21 11:49:33',NULL,'DELETE','IN_PROGRESS','net','3c72fd72-2d04-47f0-ac76-cee5d5aee494','state changed','OS::Neutron::Net',NULL,NULL),(326,'fbaf8ee0-01e2-45d9-a0a5-f4a6ea08a3a2','6c038782-44a6-4f1a-a6e0-4827cc803bc3','2026-01-21 11:49:34',NULL,'DELETE','COMPLETE','net','3c72fd72-2d04-47f0-ac76-cee5d5aee494','state changed','OS::Neutron::Net',NULL,NULL),(327,'b224eac5-185f-444c-91e0-9b74e6998aac','6c038782-44a6-4f1a-a6e0-4827cc803bc3','2026-01-21 11:49:34',NULL,'DELETE','COMPLETE','UpdateSubnetTest-368818728','6c038782-44a6-4f1a-a6e0-4827cc803bc3','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(328,'2254d056-f31d-4c33-8e8f-46a8496566f5','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:34',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-575895988','5439694a-2a97-4221-8138-18cd70a88942','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(329,'88c66b7c-9721-4350-b5e6-ad53340ef256','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:34',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-575895988-trunk_net_one-e25hhu4givk7','state changed','OS::Neutron::Net',NULL,NULL),(330,'1218ce0f-cd87-4ed3-8f5e-942c71596521','1003d0e3-20a6-4f6c-bdb1-2629b35132a3','2026-01-21 11:49:35',NULL,'CREATE','IN_PROGRESS','server_with_sub_ip','1003d0e3-20a6-4f6c-bdb1-2629b35132a3','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(331,'e9d3cbfc-62f7-40e3-b6c5-0705854ccbd6','1003d0e3-20a6-4f6c-bdb1-2629b35132a3','2026-01-21 11:49:35',NULL,'CREATE','IN_PROGRESS','net','server_with_sub_ip-net-yexxqop44jxg','state changed','OS::Neutron::Net',NULL,64),(332,'3602ebdb-ce12-4ff7-b5ba-8270ccd25f24','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:35',NULL,'CREATE','COMPLETE','trunk_net_one','7ef73f0f-f718-4de7-a03b-cba3430cb33e','state changed','OS::Neutron::Net',NULL,NULL),(333,'f7192360-4e70-4cbb-8575-ae4db73e8311','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:35',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-575895988-trunk_subnet_one-qcryfpqrclx6','state changed','OS::Neutron::Subnet',NULL,65),(334,'26b84b2b-bc7f-438b-983e-57fc7ac7f58a','f7c6bff2-aca2-412a-9a33-d35c6e2eee2e','2026-01-21 11:49:35',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-1644753654','f7c6bff2-aca2-412a-9a33-d35c6e2eee2e','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(335,'3d55a5dd-7c13-4ca5-8a16-08506134b8df','f7c6bff2-aca2-412a-9a33-d35c6e2eee2e','2026-01-21 11:49:35',NULL,'CREATE','IN_PROGRESS','my_stack','RemoteStackTest-1644753654-my_stack-cmnjnuuv4kub','state changed','OS::Heat::Stack',NULL,66),(336,'df65cf96-7229-4614-b039-538ae9ed4090','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:35',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-575895988-parent_net-4jgchn5hlrs3','state changed','OS::Neutron::Net',NULL,NULL),(337,'dbb911ed-d050-4625-ab56-a0a047a11212','1003d0e3-20a6-4f6c-bdb1-2629b35132a3','2026-01-21 11:49:36',NULL,'CREATE','COMPLETE','net','bf8cff3d-82d4-456e-bf5f-5fbfa66bcb26','state changed','OS::Neutron::Net',NULL,64),(338,'413fe2d7-1cf6-4496-a9c9-cd606cc327eb','1003d0e3-20a6-4f6c-bdb1-2629b35132a3','2026-01-21 11:49:36',NULL,'CREATE','IN_PROGRESS','subnet','server_with_sub_ip-subnet-ppu5fr2mt2ea','state changed','OS::Neutron::Subnet',NULL,67),(339,'4833aa05-0be0-4ba1-be14-78f9763254c6','1003d0e3-20a6-4f6c-bdb1-2629b35132a3','2026-01-21 11:49:36',NULL,'CREATE','IN_PROGRESS','security_group','server_with_sub_ip-security_group-hifounf6bc7e','state changed','OS::Neutron::SecurityGroup',NULL,68),(340,'c0c575bf-c98b-4dfd-8e59-1df51f847d82','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:36',NULL,'CREATE','COMPLETE','parent_net','67c98f4d-d9b0-4c18-a67f-26fd4a8f1d18','state changed','OS::Neutron::Net',NULL,NULL),(341,'5cf104df-aee6-4707-956b-35c75bcd8259','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:36',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-575895988-parent_subnet-uh5fav2m2gcf','state changed','OS::Neutron::Subnet',NULL,69),(342,'53ed50e7-831d-4e85-b866-399e2cefcc3c','6148d142-290b-423e-b02d-7372ca81b44c','2026-01-21 11:49:36',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-1644753654-my_stack-cmnjnuuv4kub','6148d142-290b-423e-b02d-7372ca81b44c','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(343,'3e374074-e74b-4a1f-b850-0688b4563525','6148d142-290b-423e-b02d-7372ca81b44c','2026-01-21 11:49:36',NULL,'CREATE','IN_PROGRESS','random1','RemoteStackTest-1644753654-my_stack-cmnjnuuv4kub-random1-dbstk5k4a3hu','state changed','OS::Heat::RandomString',NULL,NULL),(344,'23ecfb60-540e-408e-8aea-57f8a0b32abc','6148d142-290b-423e-b02d-7372ca81b44c','2026-01-21 11:49:36',NULL,'CREATE','COMPLETE','random1','RemoteStackTest-1644753654-my_stack-cmnjnuuv4kub-random1-dbstk5k4a3hu','state changed','OS::Heat::RandomString',NULL,NULL),(345,'24fa7644-f60b-4b7b-a784-b15831dd4320','6148d142-290b-423e-b02d-7372ca81b44c','2026-01-21 11:49:36',NULL,'CREATE','COMPLETE','RemoteStackTest-1644753654-my_stack-cmnjnuuv4kub','6148d142-290b-423e-b02d-7372ca81b44c','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(346,'714379d7-f336-458b-acf9-1f3b77bb8270','f7c6bff2-aca2-412a-9a33-d35c6e2eee2e','2026-01-21 11:49:36',NULL,'CREATE','COMPLETE','my_stack','6148d142-290b-423e-b02d-7372ca81b44c','state changed','OS::Heat::Stack',NULL,66),(347,'75929b92-ff02-4530-a1bf-fac4558a4fe3','f7c6bff2-aca2-412a-9a33-d35c6e2eee2e','2026-01-21 11:49:36',NULL,'CREATE','COMPLETE','RemoteStackTest-1644753654','f7c6bff2-aca2-412a-9a33-d35c6e2eee2e','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(348,'ad655dc4-8673-46e7-b474-0dfaa2dd9eca','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:36',NULL,'CREATE','COMPLETE','trunk_subnet_one','937af032-5031-48de-b5e9-25ae47d12afb','state changed','OS::Neutron::Subnet',NULL,65),(349,'6b945f56-9f8d-4ef3-9d55-ae54456f0b17','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:36',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-575895988-sub_port_one-bobwmsi253t6','state changed','OS::Neutron::Port',NULL,70),(350,'e5e8cdc8-a660-4397-99b1-37e5437c1766','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:36',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-575895988-trunk_net_two-j3pggfxgwols','state changed','OS::Neutron::Net',NULL,NULL),(351,'7b33164b-3de4-42eb-b899-497ed8c88ed7','1003d0e3-20a6-4f6c-bdb1-2629b35132a3','2026-01-21 11:49:37',NULL,'CREATE','COMPLETE','security_group','85f1dbaf-6920-4ded-bd81-9df1b1677c29','state changed','OS::Neutron::SecurityGroup',NULL,68),(352,'590bbc77-1d15-4caf-b618-056af32b6f2c','1003d0e3-20a6-4f6c-bdb1-2629b35132a3','2026-01-21 11:49:37',NULL,'CREATE','COMPLETE','subnet','05debbb3-7225-4376-9d45-5b54cdc2536c','state changed','OS::Neutron::Subnet',NULL,67),(353,'61e64577-e7b3-4ac6-85a3-0e99b30a8645','1003d0e3-20a6-4f6c-bdb1-2629b35132a3','2026-01-21 11:49:37',NULL,'CREATE','IN_PROGRESS','server','server_with_sub_ip-server-zyr3vf5vfn4j','state changed','OS::Nova::Server',NULL,71),(354,'b4085bf4-e41a-4718-9779-8f000aa2da37','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:37',NULL,'CREATE','COMPLETE','parent_subnet','82dc47cf-00cd-4c3a-8ae5-3697a83e6e57','state changed','OS::Neutron::Subnet',NULL,69),(355,'3392205c-2ca7-4611-a589-655ab2ea67d0','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:37',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-575895988-parent_port-2wj6v325decm','state changed','OS::Neutron::Port',NULL,72),(356,'2e6bc80a-bb1e-44de-910e-ba45d7828970','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:37',NULL,'CREATE','COMPLETE','trunk_net_two','b0d6c17a-5feb-4851-b5ae-78f92022d6dd','state changed','OS::Neutron::Net',NULL,NULL),(357,'9ce920cb-7cd2-40a4-89fe-24e2cc821cdf','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:37',NULL,'CREATE','COMPLETE','sub_port_one','a16117ae-49df-4fac-81b6-fd16f28b516e','state changed','OS::Neutron::Port',NULL,70),(358,'3d9b11de-c1cc-4897-a3aa-95048e1b8b54','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:37',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-575895988-trunk_subnet_two-eqcjkfwcf4qy','state changed','OS::Neutron::Subnet',NULL,73),(359,'d477364e-d124-4d3d-be54-0fb7181b3bfc','2f7aa387-a933-49b3-9dae-b1c258a5c26e','2026-01-21 11:49:38',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-1118526834','2f7aa387-a933-49b3-9dae-b1c258a5c26e','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(360,'b3a0ca5b-601c-49c2-9ee6-cfec3651c820','2f7aa387-a933-49b3-9dae-b1c258a5c26e','2026-01-21 11:49:38',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-1118526834-net-xmec4opxlg6i','state changed','OS::Neutron::Net',NULL,NULL),(361,'ef5766d2-867e-4377-9b24-853a5f69671a','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:38',NULL,'CREATE','COMPLETE','parent_port','ce035354-160a-41fc-a703-9f1d5ae24d62','state changed','OS::Neutron::Port',NULL,72),(362,'e6fc33a4-23b2-4838-aa2d-be5d238ce057','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:38',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-575895988-trunk-73tc4ccpuwyq','state changed','OS::Neutron::Trunk',NULL,74),(363,'9770cbe7-0a65-40cd-b195-e34e18dff502','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:38',NULL,'CREATE','COMPLETE','trunk_subnet_two','754bfc4d-df28-4b3d-9fc3-ae2253760d4a','state changed','OS::Neutron::Subnet',NULL,73),(364,'ce0384c1-a87d-49a1-8883-d9de0d8aeb65','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:38',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-575895988-sub_port_two-vbhcsiwbpvmg','state changed','OS::Neutron::Port',NULL,75),(365,'eb07f4fc-6aa7-4001-84a2-98a75bfdfa94','2f7aa387-a933-49b3-9dae-b1c258a5c26e','2026-01-21 11:49:39',NULL,'CREATE','COMPLETE','net','a2ce8685-8bee-4eec-8bbb-bb4a01b19226','state changed','OS::Neutron::Net',NULL,NULL),(366,'24baeca1-c7b1-445f-95dd-63cd34befdca','2f7aa387-a933-49b3-9dae-b1c258a5c26e','2026-01-21 11:49:39',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-1118526834-subnet-asjo7bpdegur','state changed','OS::Neutron::Subnet',NULL,76),(367,'da389ed0-3d4e-44eb-86d8-3bc6c4ee1466','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:39',NULL,'CREATE','COMPLETE','trunk','a5ad4273-97ad-4537-a849-a67bebf09449','state changed','OS::Neutron::Trunk',NULL,74),(368,'ea704e82-0341-4ffc-abf2-68a363b00380','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:39',NULL,'CREATE','COMPLETE','sub_port_two','a4278404-bd89-4246-81d5-b2440604c3a8','state changed','OS::Neutron::Port',NULL,75),(369,'3806123e-fb16-4041-9362-7cd4c12d97f7','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:39',NULL,'CREATE','COMPLETE','UpdateTrunkTest-575895988','5439694a-2a97-4221-8138-18cd70a88942','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(370,'e9569d3c-91ef-474a-b87a-3609a43f12f7','2f7aa387-a933-49b3-9dae-b1c258a5c26e','2026-01-21 11:49:40',NULL,'CREATE','COMPLETE','subnet','03490cba-984b-44cd-bea7-83b5538fd5f5','state changed','OS::Neutron::Subnet',NULL,76),(371,'34caf793-fd7e-4589-b638-4269431d66e9','2f7aa387-a933-49b3-9dae-b1c258a5c26e','2026-01-21 11:49:40',NULL,'CREATE','COMPLETE','UpdateSubnetTest-1118526834','2f7aa387-a933-49b3-9dae-b1c258a5c26e','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(372,'5ba0dba3-43ff-40cd-bfa1-1622af0d65ee','f7c6bff2-aca2-412a-9a33-d35c6e2eee2e','2026-01-21 11:49:40',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-1644753654','f7c6bff2-aca2-412a-9a33-d35c6e2eee2e','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(373,'3fd50454-5137-47f3-8244-14ad26bf86c3','f7c6bff2-aca2-412a-9a33-d35c6e2eee2e','2026-01-21 11:49:41',NULL,'DELETE','IN_PROGRESS','my_stack','6148d142-290b-423e-b02d-7372ca81b44c','state changed','OS::Heat::Stack',NULL,66),(374,'aca76554-5747-4dab-be69-a728f519bfd6','6148d142-290b-423e-b02d-7372ca81b44c','2026-01-21 11:49:41',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-1644753654-my_stack-cmnjnuuv4kub','6148d142-290b-423e-b02d-7372ca81b44c','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(375,'bff31602-14a7-4fb2-ae4c-5e4fe5b5a2b0','6148d142-290b-423e-b02d-7372ca81b44c','2026-01-21 11:49:41',NULL,'DELETE','IN_PROGRESS','random1','RemoteStackTest-1644753654-my_stack-cmnjnuuv4kub-random1-dbstk5k4a3hu','state changed','OS::Heat::RandomString',NULL,NULL),(376,'64f3301d-a5be-4a7e-a468-05ec522b986c','6148d142-290b-423e-b02d-7372ca81b44c','2026-01-21 11:49:41',NULL,'DELETE','COMPLETE','random1','RemoteStackTest-1644753654-my_stack-cmnjnuuv4kub-random1-dbstk5k4a3hu','state changed','OS::Heat::RandomString',NULL,NULL),(377,'3ba46b80-742a-4bc1-81f7-574642ef09a9','6148d142-290b-423e-b02d-7372ca81b44c','2026-01-21 11:49:41',NULL,'DELETE','COMPLETE','RemoteStackTest-1644753654-my_stack-cmnjnuuv4kub','6148d142-290b-423e-b02d-7372ca81b44c','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(378,'73850086-50ea-4249-ba5f-ceac6ea6e83f','f7c6bff2-aca2-412a-9a33-d35c6e2eee2e','2026-01-21 11:49:41',NULL,'DELETE','COMPLETE','my_stack','6148d142-290b-423e-b02d-7372ca81b44c','state changed','OS::Heat::Stack',NULL,66),(379,'9d2d0e89-4240-4982-8d10-7eddee956200','f7c6bff2-aca2-412a-9a33-d35c6e2eee2e','2026-01-21 11:49:41',NULL,'DELETE','COMPLETE','RemoteStackTest-1644753654','f7c6bff2-aca2-412a-9a33-d35c6e2eee2e','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(380,'eb00ab3f-417e-49c0-9b3c-2424ae9169bf','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:44',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-575895988','5439694a-2a97-4221-8138-18cd70a88942','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(381,'19d73ff8-e2fd-421e-affc-6e85ec15b13b','2f7aa387-a933-49b3-9dae-b1c258a5c26e','2026-01-21 11:49:45',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-1118526834','2f7aa387-a933-49b3-9dae-b1c258a5c26e','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(382,'75d9f171-af1e-4b05-974a-ddffaea9f120','2f7aa387-a933-49b3-9dae-b1c258a5c26e','2026-01-21 11:49:45',NULL,'UPDATE','IN_PROGRESS','subnet','03490cba-984b-44cd-bea7-83b5538fd5f5','state changed','OS::Neutron::Subnet',NULL,76),(383,'fceefd3c-3f6c-4557-ad91-c73a7edd4742','2f7aa387-a933-49b3-9dae-b1c258a5c26e','2026-01-21 11:49:46',NULL,'UPDATE','COMPLETE','subnet','03490cba-984b-44cd-bea7-83b5538fd5f5','state changed','OS::Neutron::Subnet',NULL,79),(384,'852ee851-e764-4ef4-b90a-14c71921b010','2f7aa387-a933-49b3-9dae-b1c258a5c26e','2026-01-21 11:49:46',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-1118526834','2f7aa387-a933-49b3-9dae-b1c258a5c26e','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(385,'bc5a73a8-f8a2-4756-85e1-806bc2f0cac4','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:47',NULL,'UPDATE','IN_PROGRESS','trunk','a5ad4273-97ad-4537-a849-a67bebf09449','state changed','OS::Neutron::Trunk',NULL,74),(386,'dc835522-e801-4623-a3be-6395aa840ceb','f61d157a-f715-4d69-8626-bee6625e900d','2026-01-21 11:49:48',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-763348251','f61d157a-f715-4d69-8626-bee6625e900d','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(387,'596a2bc2-bb52-436c-b4fc-7d0031f8e8d0','1003d0e3-20a6-4f6c-bdb1-2629b35132a3','2026-01-21 11:49:48',NULL,'CREATE','COMPLETE','server','46a64a00-a7e7-4c45-bc7b-dccc9561715a','state changed','OS::Nova::Server',NULL,71),(388,'881800aa-a7b2-4b3b-b453-d8c83e61ee4f','1003d0e3-20a6-4f6c-bdb1-2629b35132a3','2026-01-21 11:49:48',NULL,'CREATE','COMPLETE','server_with_sub_ip','1003d0e3-20a6-4f6c-bdb1-2629b35132a3','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(389,'0841c6bc-6c9d-49fa-a2f5-5ddbc9e5e0db','f61d157a-f715-4d69-8626-bee6625e900d','2026-01-21 11:49:48',NULL,'CREATE','IN_PROGRESS','my_stack','RemoteStackTest-763348251-my_stack-kbzkiri4q7ts','state changed','OS::Heat::Stack',NULL,80),(390,'a8dff429-1f16-433f-9407-abff15182e6f','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:48',NULL,'UPDATE','COMPLETE','trunk','a5ad4273-97ad-4537-a849-a67bebf09449','state changed','OS::Neutron::Trunk',NULL,81),(391,'ab7f32ea-e6a3-4a11-ae2e-4bdcb1296aa2','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:48',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-575895988','5439694a-2a97-4221-8138-18cd70a88942','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(392,'ba148c99-e86a-4ba9-a780-a648ecec383c','38aad380-1fb2-4b3d-a021-fe517820438c','2026-01-21 11:49:49',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-763348251-my_stack-kbzkiri4q7ts','38aad380-1fb2-4b3d-a021-fe517820438c','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(393,'3bea5ed3-09d3-48f2-9345-17fb29b02b65','38aad380-1fb2-4b3d-a021-fe517820438c','2026-01-21 11:49:49',NULL,'CREATE','IN_PROGRESS','random1','RemoteStackTest-763348251-my_stack-kbzkiri4q7ts-random1-d2ayhlda6iys','state changed','OS::Heat::RandomString',NULL,NULL),(394,'1ea798b6-fa56-4782-859f-85832408ba54','38aad380-1fb2-4b3d-a021-fe517820438c','2026-01-21 11:49:49',NULL,'CREATE','COMPLETE','random1','RemoteStackTest-763348251-my_stack-kbzkiri4q7ts-random1-d2ayhlda6iys','state changed','OS::Heat::RandomString',NULL,NULL),(395,'7345ed95-4334-4e1f-8824-cfbc7365ec33','38aad380-1fb2-4b3d-a021-fe517820438c','2026-01-21 11:49:49',NULL,'CREATE','COMPLETE','RemoteStackTest-763348251-my_stack-kbzkiri4q7ts','38aad380-1fb2-4b3d-a021-fe517820438c','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(396,'a4d35092-7d4b-40da-9f50-8f6da8eb71e9','f61d157a-f715-4d69-8626-bee6625e900d','2026-01-21 11:49:49',NULL,'CREATE','COMPLETE','my_stack','38aad380-1fb2-4b3d-a021-fe517820438c','state changed','OS::Heat::Stack',NULL,80),(397,'012ed694-92bb-4590-a52e-ffed48ec2cc0','f61d157a-f715-4d69-8626-bee6625e900d','2026-01-21 11:49:49',NULL,'CREATE','COMPLETE','RemoteStackTest-763348251','f61d157a-f715-4d69-8626-bee6625e900d','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(398,'60e86802-a7d8-4aaf-acdb-b6f040f10a8d','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:49',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-575895988','5439694a-2a97-4221-8138-18cd70a88942','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(399,'5d475ccb-a1a2-4672-8a63-bdaeb19b2ec0','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:49',NULL,'DELETE','IN_PROGRESS','sub_port_two','a4278404-bd89-4246-81d5-b2440604c3a8','state changed','OS::Neutron::Port',NULL,75),(400,'56c5b97c-e210-4d4d-96b3-e13799e64de8','2f7aa387-a933-49b3-9dae-b1c258a5c26e','2026-01-21 11:49:49',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-1118526834','2f7aa387-a933-49b3-9dae-b1c258a5c26e','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(401,'a585ba20-5a55-49e3-b172-1b074d6a5f8a','2f7aa387-a933-49b3-9dae-b1c258a5c26e','2026-01-21 11:49:50',NULL,'DELETE','IN_PROGRESS','subnet','03490cba-984b-44cd-bea7-83b5538fd5f5','state changed','OS::Neutron::Subnet',NULL,79),(402,'608d8649-3378-4ba6-aee5-4b63e3035d51','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:50',NULL,'DELETE','COMPLETE','sub_port_two','a4278404-bd89-4246-81d5-b2440604c3a8','state changed','OS::Neutron::Port',NULL,75),(403,'eba9cd84-ecbe-4a8e-b1bb-ca0e284f7a5c','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:50',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','754bfc4d-df28-4b3d-9fc3-ae2253760d4a','state changed','OS::Neutron::Subnet',NULL,73),(404,'fe84ac06-5f9d-4466-9cd3-83346a80b677','1003d0e3-20a6-4f6c-bdb1-2629b35132a3','2026-01-21 11:49:50',NULL,'DELETE','IN_PROGRESS','server_with_sub_ip','1003d0e3-20a6-4f6c-bdb1-2629b35132a3','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(405,'fa1769fe-23d0-4c38-bf89-f29414b6c658','2f7aa387-a933-49b3-9dae-b1c258a5c26e','2026-01-21 11:49:50',NULL,'DELETE','COMPLETE','subnet','03490cba-984b-44cd-bea7-83b5538fd5f5','state changed','OS::Neutron::Subnet',NULL,79),(406,'e2d4df5f-7f1e-44a4-b98e-b5f7092e4866','2f7aa387-a933-49b3-9dae-b1c258a5c26e','2026-01-21 11:49:50',NULL,'DELETE','IN_PROGRESS','net','a2ce8685-8bee-4eec-8bbb-bb4a01b19226','state changed','OS::Neutron::Net',NULL,NULL),(407,'05c05017-e1fd-4ba9-85f4-8444df3d56a0','1003d0e3-20a6-4f6c-bdb1-2629b35132a3','2026-01-21 11:49:50',NULL,'DELETE','IN_PROGRESS','server','46a64a00-a7e7-4c45-bc7b-dccc9561715a','state changed','OS::Nova::Server',NULL,71),(408,'ce8cd806-a77f-4b0b-9bd0-a5fc32d7931c','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:50',NULL,'DELETE','COMPLETE','trunk_subnet_two','754bfc4d-df28-4b3d-9fc3-ae2253760d4a','state changed','OS::Neutron::Subnet',NULL,73),(409,'99b2a631-acbb-4fd3-834b-3a2e82bd1d13','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:50',NULL,'DELETE','IN_PROGRESS','trunk_net_two','b0d6c17a-5feb-4851-b5ae-78f92022d6dd','state changed','OS::Neutron::Net',NULL,NULL),(410,'25157e2b-8d18-4cde-a440-871d9eac3695','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:50',NULL,'DELETE','IN_PROGRESS','trunk','a5ad4273-97ad-4537-a849-a67bebf09449','state changed','OS::Neutron::Trunk',NULL,81),(411,'b02e047e-8c7b-4701-b20a-2415767d0f07','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:50',NULL,'DELETE','COMPLETE','trunk','a5ad4273-97ad-4537-a849-a67bebf09449','state changed','OS::Neutron::Trunk',NULL,81),(412,'9fa02d9d-e969-4631-bbbd-48104cc0785d','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:50',NULL,'DELETE','IN_PROGRESS','parent_port','ce035354-160a-41fc-a703-9f1d5ae24d62','state changed','OS::Neutron::Port',NULL,72),(413,'d4b5a322-d05f-4469-bcdd-c3491aedbf33','2f7aa387-a933-49b3-9dae-b1c258a5c26e','2026-01-21 11:49:51',NULL,'DELETE','COMPLETE','net','a2ce8685-8bee-4eec-8bbb-bb4a01b19226','state changed','OS::Neutron::Net',NULL,NULL),(414,'494121a0-d6da-4550-8608-c0758d90a2d5','2f7aa387-a933-49b3-9dae-b1c258a5c26e','2026-01-21 11:49:51',NULL,'DELETE','COMPLETE','UpdateSubnetTest-1118526834','2f7aa387-a933-49b3-9dae-b1c258a5c26e','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(415,'5e6523b8-6961-4126-b4af-ff4dfd088ccf','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:51',NULL,'DELETE','COMPLETE','trunk_net_two','b0d6c17a-5feb-4851-b5ae-78f92022d6dd','state changed','OS::Neutron::Net',NULL,NULL),(416,'29e7d6ea-8751-4864-8d04-c301fa6cda9b','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:51',NULL,'DELETE','COMPLETE','parent_port','ce035354-160a-41fc-a703-9f1d5ae24d62','state changed','OS::Neutron::Port',NULL,72),(417,'f1708b05-d29b-44ac-af2d-9ccb7b26610e','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:51',NULL,'DELETE','IN_PROGRESS','parent_subnet','82dc47cf-00cd-4c3a-8ae5-3697a83e6e57','state changed','OS::Neutron::Subnet',NULL,69),(418,'82ebed40-37ae-4cab-9475-e8748b14d74f','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:51',NULL,'DELETE','IN_PROGRESS','sub_port_one','a16117ae-49df-4fac-81b6-fd16f28b516e','state changed','OS::Neutron::Port',NULL,70),(419,'5335362d-d1ad-4311-8117-726a5c800147','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:51',NULL,'DELETE','COMPLETE','parent_subnet','82dc47cf-00cd-4c3a-8ae5-3697a83e6e57','state changed','OS::Neutron::Subnet',NULL,69),(420,'531ff314-9382-4c87-85b7-a8dc6eb023e9','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:51',NULL,'DELETE','IN_PROGRESS','parent_net','67c98f4d-d9b0-4c18-a67f-26fd4a8f1d18','state changed','OS::Neutron::Net',NULL,NULL),(421,'46ec2680-d97c-4a3d-adf8-7267936c4d24','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:52',NULL,'DELETE','COMPLETE','sub_port_one','a16117ae-49df-4fac-81b6-fd16f28b516e','state changed','OS::Neutron::Port',NULL,70),(422,'c2bfa459-ec5a-4d25-b72d-a4ad7bb4f0b9','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:52',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','937af032-5031-48de-b5e9-25ae47d12afb','state changed','OS::Neutron::Subnet',NULL,65),(423,'072f7710-2ae3-442c-be12-b8c208a5a357','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:52',NULL,'DELETE','COMPLETE','parent_net','67c98f4d-d9b0-4c18-a67f-26fd4a8f1d18','state changed','OS::Neutron::Net',NULL,NULL),(424,'9ebf68c0-41eb-4d3a-bbce-beb68e8beea9','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:52',NULL,'DELETE','COMPLETE','trunk_subnet_one','937af032-5031-48de-b5e9-25ae47d12afb','state changed','OS::Neutron::Subnet',NULL,65),(425,'1a102690-883d-4274-8e21-d927f347a0ab','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:52',NULL,'DELETE','IN_PROGRESS','trunk_net_one','7ef73f0f-f718-4de7-a03b-cba3430cb33e','state changed','OS::Neutron::Net',NULL,NULL),(426,'c36472f2-27f3-4191-a965-926fb96d9e1f','1003d0e3-20a6-4f6c-bdb1-2629b35132a3','2026-01-21 11:49:52',NULL,'DELETE','COMPLETE','server','46a64a00-a7e7-4c45-bc7b-dccc9561715a','state changed','OS::Nova::Server',NULL,71),(427,'045ab296-5bd7-4e11-a3da-031c5c6ff945','1003d0e3-20a6-4f6c-bdb1-2629b35132a3','2026-01-21 11:49:52',NULL,'DELETE','IN_PROGRESS','security_group','85f1dbaf-6920-4ded-bd81-9df1b1677c29','state changed','OS::Neutron::SecurityGroup',NULL,68),(428,'80a623fc-461c-4962-8d21-736ede1f737e','1003d0e3-20a6-4f6c-bdb1-2629b35132a3','2026-01-21 11:49:52',NULL,'DELETE','IN_PROGRESS','subnet','05debbb3-7225-4376-9d45-5b54cdc2536c','state changed','OS::Neutron::Subnet',NULL,67),(429,'d810f682-4dbc-402c-8421-4da501db8063','f61d157a-f715-4d69-8626-bee6625e900d','2026-01-21 11:49:52',NULL,'SUSPEND','IN_PROGRESS','RemoteStackTest-763348251','f61d157a-f715-4d69-8626-bee6625e900d','Stack SUSPEND started','OS::Heat::Stack',NULL,NULL),(430,'06ffdbc6-2e51-44a2-9b71-adb10dbf41ed','f61d157a-f715-4d69-8626-bee6625e900d','2026-01-21 11:49:52',NULL,'SUSPEND','IN_PROGRESS','my_stack','38aad380-1fb2-4b3d-a021-fe517820438c','state changed','OS::Heat::Stack',NULL,80),(431,'d70f24df-028b-4733-9ae9-1be4b282b3da','38aad380-1fb2-4b3d-a021-fe517820438c','2026-01-21 11:49:52',NULL,'SUSPEND','IN_PROGRESS','RemoteStackTest-763348251-my_stack-kbzkiri4q7ts','38aad380-1fb2-4b3d-a021-fe517820438c','Stack SUSPEND started','OS::Heat::Stack',NULL,NULL),(432,'bcfb4cc0-b3e0-46dc-bd62-52312898daf6','38aad380-1fb2-4b3d-a021-fe517820438c','2026-01-21 11:49:53',NULL,'SUSPEND','IN_PROGRESS','random1','RemoteStackTest-763348251-my_stack-kbzkiri4q7ts-random1-d2ayhlda6iys','state changed','OS::Heat::RandomString',NULL,NULL),(433,'80a25c14-2b69-4569-b916-6e5e7415f875','38aad380-1fb2-4b3d-a021-fe517820438c','2026-01-21 11:49:53',NULL,'SUSPEND','COMPLETE','random1','RemoteStackTest-763348251-my_stack-kbzkiri4q7ts-random1-d2ayhlda6iys','state changed','OS::Heat::RandomString',NULL,NULL),(434,'1e42a656-f0af-49b3-914e-8ad8a636544e','38aad380-1fb2-4b3d-a021-fe517820438c','2026-01-21 11:49:53',NULL,'SUSPEND','COMPLETE','RemoteStackTest-763348251-my_stack-kbzkiri4q7ts','38aad380-1fb2-4b3d-a021-fe517820438c','Stack SUSPEND completed successfully','OS::Heat::Stack',NULL,NULL),(435,'9ccbe1e0-6651-47b3-9f6b-c8f06a00b438','f61d157a-f715-4d69-8626-bee6625e900d','2026-01-21 11:49:53',NULL,'SUSPEND','COMPLETE','my_stack','38aad380-1fb2-4b3d-a021-fe517820438c','state changed','OS::Heat::Stack',NULL,80),(436,'dec19b74-79f6-427b-bb57-d8dc941ce1e5','f61d157a-f715-4d69-8626-bee6625e900d','2026-01-21 11:49:53',NULL,'SUSPEND','COMPLETE','RemoteStackTest-763348251','f61d157a-f715-4d69-8626-bee6625e900d','Stack SUSPEND completed successfully','OS::Heat::Stack',NULL,NULL),(437,'78ed809c-8c71-4b72-85f6-3a5762ad88f7','1003d0e3-20a6-4f6c-bdb1-2629b35132a3','2026-01-21 11:49:53',NULL,'DELETE','COMPLETE','subnet','05debbb3-7225-4376-9d45-5b54cdc2536c','state changed','OS::Neutron::Subnet',NULL,67),(438,'3e0eb655-dbe9-4527-acf3-5a453a5da8b2','1003d0e3-20a6-4f6c-bdb1-2629b35132a3','2026-01-21 11:49:53',NULL,'DELETE','IN_PROGRESS','net','bf8cff3d-82d4-456e-bf5f-5fbfa66bcb26','state changed','OS::Neutron::Net',NULL,64),(439,'1069ca5b-ebb8-4692-b3d2-2cf4bf8c3bba','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:53',NULL,'DELETE','COMPLETE','trunk_net_one','7ef73f0f-f718-4de7-a03b-cba3430cb33e','state changed','OS::Neutron::Net',NULL,NULL),(440,'f25d2d7b-77a3-44b5-81df-12d57dc38909','5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:53',NULL,'DELETE','COMPLETE','UpdateTrunkTest-575895988','5439694a-2a97-4221-8138-18cd70a88942','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(441,'e0c99ad1-3fb0-48af-85cf-3cd8376b8749','1003d0e3-20a6-4f6c-bdb1-2629b35132a3','2026-01-21 11:49:54',NULL,'DELETE','COMPLETE','net','bf8cff3d-82d4-456e-bf5f-5fbfa66bcb26','state changed','OS::Neutron::Net',NULL,64),(442,'737991ef-f9ff-45c8-98c2-9dbb7e1058b7','1003d0e3-20a6-4f6c-bdb1-2629b35132a3','2026-01-21 11:49:54',NULL,'DELETE','COMPLETE','security_group','85f1dbaf-6920-4ded-bd81-9df1b1677c29','state changed','OS::Neutron::SecurityGroup',NULL,68),(443,'1993f029-0a6f-437e-9382-73213b085a7d','1003d0e3-20a6-4f6c-bdb1-2629b35132a3','2026-01-21 11:49:54',NULL,'DELETE','COMPLETE','server_with_sub_ip','1003d0e3-20a6-4f6c-bdb1-2629b35132a3','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(444,'7024476f-3d00-4a9d-8d69-92450a162eb5','f1cabc12-90f5-4e11-b356-3243fcc57cb9','2026-01-21 11:49:55',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-976401956','f1cabc12-90f5-4e11-b356-3243fcc57cb9','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(445,'5a06a706-edca-4057-8958-6f1f76692d99','f1cabc12-90f5-4e11-b356-3243fcc57cb9','2026-01-21 11:49:55',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-976401956-net-ydtzbtoxf5yk','state changed','OS::Neutron::Net',NULL,NULL),(446,'549d7865-8f09-41b3-8517-1d9583711042','f1cabc12-90f5-4e11-b356-3243fcc57cb9','2026-01-21 11:49:56',NULL,'CREATE','COMPLETE','net','90cadcd2-650f-4425-bc4d-f70355b6e2bc','state changed','OS::Neutron::Net',NULL,NULL),(447,'20702e0f-89b8-41f4-8ffb-205c05a59856','f1cabc12-90f5-4e11-b356-3243fcc57cb9','2026-01-21 11:49:56',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-976401956-subnet-o66jgv3fafgj','state changed','OS::Neutron::Subnet',NULL,85),(448,'f266beec-343e-4b35-8639-f817ee1548d0','f61d157a-f715-4d69-8626-bee6625e900d','2026-01-21 11:49:57',NULL,'RESUME','IN_PROGRESS','RemoteStackTest-763348251','f61d157a-f715-4d69-8626-bee6625e900d','Stack RESUME started','OS::Heat::Stack',NULL,NULL),(449,'68a92044-9a2b-4430-b979-a21ef1962aab','f61d157a-f715-4d69-8626-bee6625e900d','2026-01-21 11:49:57',NULL,'RESUME','IN_PROGRESS','my_stack','38aad380-1fb2-4b3d-a021-fe517820438c','state changed','OS::Heat::Stack',NULL,80),(450,'8d5d2757-fd95-44e3-b388-f864d097c527','f1cabc12-90f5-4e11-b356-3243fcc57cb9','2026-01-21 11:49:57',NULL,'CREATE','COMPLETE','subnet','3ddbee5a-74d7-4bb5-a962-a1bdb1b4d2c6','state changed','OS::Neutron::Subnet',NULL,85),(451,'45b99376-bb3e-456f-bdee-b2bbe3b52b08','f1cabc12-90f5-4e11-b356-3243fcc57cb9','2026-01-21 11:49:57',NULL,'CREATE','COMPLETE','UpdateSubnetTest-976401956','f1cabc12-90f5-4e11-b356-3243fcc57cb9','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(452,'8f1f7adc-67c5-45d4-a9e1-3e09da3f1409','38aad380-1fb2-4b3d-a021-fe517820438c','2026-01-21 11:49:58',NULL,'RESUME','IN_PROGRESS','RemoteStackTest-763348251-my_stack-kbzkiri4q7ts','38aad380-1fb2-4b3d-a021-fe517820438c','Stack RESUME started','OS::Heat::Stack',NULL,NULL),(453,'9fd6b1ca-0cc5-4b36-aa43-3f280637fecc','38aad380-1fb2-4b3d-a021-fe517820438c','2026-01-21 11:49:58',NULL,'RESUME','IN_PROGRESS','random1','RemoteStackTest-763348251-my_stack-kbzkiri4q7ts-random1-d2ayhlda6iys','state changed','OS::Heat::RandomString',NULL,NULL),(454,'e7b23acd-a403-43be-a601-0faead3340db','38aad380-1fb2-4b3d-a021-fe517820438c','2026-01-21 11:49:58',NULL,'RESUME','COMPLETE','random1','RemoteStackTest-763348251-my_stack-kbzkiri4q7ts-random1-d2ayhlda6iys','state changed','OS::Heat::RandomString',NULL,NULL),(455,'110e48f7-bae2-45d4-b22a-6245c72b4cd5','38aad380-1fb2-4b3d-a021-fe517820438c','2026-01-21 11:49:58',NULL,'RESUME','COMPLETE','RemoteStackTest-763348251-my_stack-kbzkiri4q7ts','38aad380-1fb2-4b3d-a021-fe517820438c','Stack RESUME completed successfully','OS::Heat::Stack',NULL,NULL),(456,'43d2d941-e555-49c9-a3f9-fbdca40ad646','f61d157a-f715-4d69-8626-bee6625e900d','2026-01-21 11:49:58',NULL,'RESUME','COMPLETE','my_stack','38aad380-1fb2-4b3d-a021-fe517820438c','state changed','OS::Heat::Stack',NULL,80),(457,'13965da7-5358-415e-9014-fb3191beaa23','f61d157a-f715-4d69-8626-bee6625e900d','2026-01-21 11:49:58',NULL,'RESUME','COMPLETE','RemoteStackTest-763348251','f61d157a-f715-4d69-8626-bee6625e900d','Stack RESUME completed successfully','OS::Heat::Stack',NULL,NULL),(458,'fbc19e9b-6b17-45d4-b4b0-26bb86f45123','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:49:59',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-408612344','437ee61a-e4be-4a47-b741-ce15891367c9','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(459,'5feefecc-4e8a-4947-b4ad-ac1db2547591','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:49:59',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-408612344-trunk_net_two-uxidv2wwppwg','state changed','OS::Neutron::Net',NULL,NULL),(460,'a01c4364-fa88-4c1c-8b0c-4eb95754b890','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:49:59',NULL,'CREATE','COMPLETE','trunk_net_two','efd5e132-6838-4062-a519-ce03dd2a850d','state changed','OS::Neutron::Net',NULL,NULL),(461,'43028801-6a30-49f2-88e3-35bdba9d445c','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:49:59',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-408612344-trunk_subnet_two-f3qlbsxppvsk','state changed','OS::Neutron::Subnet',NULL,86),(462,'42c9c7b5-0b60-4a13-938e-8e23cba9a0a6','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','2026-01-21 11:50:00',NULL,'CREATE','IN_PROGRESS','create_server_with_sub_ip','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(463,'edfb1946-9e1a-41cb-b6f9-a23b51b3a570','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','2026-01-21 11:50:00',NULL,'CREATE','IN_PROGRESS','net','create_server_with_sub_ip-net-7q6wrnc2nhn2','state changed','OS::Neutron::Net',NULL,87),(464,'dfabc91e-94ca-44a6-aee4-0c4a6aea3b61','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:00',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-408612344-trunk_net_one-rmix4l6sm4ub','state changed','OS::Neutron::Net',NULL,NULL),(465,'aaeb8160-ca5e-4bc7-aaaf-0fd61e8c6bbc','f1cabc12-90f5-4e11-b356-3243fcc57cb9','2026-01-21 11:50:00',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-976401956','f1cabc12-90f5-4e11-b356-3243fcc57cb9','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(466,'946efb09-6b92-4dad-9e82-645cbd8dab4e','f1cabc12-90f5-4e11-b356-3243fcc57cb9','2026-01-21 11:50:00',NULL,'UPDATE','IN_PROGRESS','subnet','3ddbee5a-74d7-4bb5-a962-a1bdb1b4d2c6','state changed','OS::Neutron::Subnet',NULL,85),(467,'4a8cb862-e588-4acd-bf04-0d2c29218eda','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:00',NULL,'CREATE','COMPLETE','trunk_subnet_two','0e8035f6-1653-46d4-8cc4-fb6c48c2f9b2','state changed','OS::Neutron::Subnet',NULL,86),(468,'7f7e0386-5609-4e3e-836d-3fe1b720d45d','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:01',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-408612344-sub_port_two-g26eery34jww','state changed','OS::Neutron::Port',NULL,89),(469,'28106c68-3f1b-4901-97b5-679bac861678','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','2026-01-21 11:50:01',NULL,'CREATE','COMPLETE','net','e066e7ad-4955-4f17-9b45-284183d092e8','state changed','OS::Neutron::Net',NULL,87),(470,'48837b3f-d66a-43bc-937c-907b10fa5aeb','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','2026-01-21 11:50:01',NULL,'CREATE','IN_PROGRESS','subnet_b','create_server_with_sub_ip-subnet_b-kll63ovifgna','state changed','OS::Neutron::Subnet',NULL,90),(471,'bdb1c383-efc3-4966-bad2-dbcfeae7d380','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','2026-01-21 11:50:01',NULL,'CREATE','IN_PROGRESS','subnet_a','create_server_with_sub_ip-subnet_a-6o3qgmipjgnw','state changed','OS::Neutron::Subnet',NULL,91),(472,'8a643873-82e9-4a27-aa33-fa0b37c2dd0d','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:01',NULL,'CREATE','COMPLETE','trunk_net_one','cfe08323-cb33-42c0-a863-a027bbdbd3b2','state changed','OS::Neutron::Net',NULL,NULL),(473,'39871860-edd1-455f-a337-0a0b93857339','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:01',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-408612344-trunk_subnet_one-tp5dx5rry2ge','state changed','OS::Neutron::Subnet',NULL,92),(474,'b449776d-2558-4bf3-81f4-31ca32cb2d6f','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:01',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-408612344-parent_net-ovchlnkhlpog','state changed','OS::Neutron::Net',NULL,NULL),(475,'2712dee3-9737-4491-8f93-74d17d355606','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','2026-01-21 11:50:01',NULL,'CREATE','COMPLETE','subnet_a','b79eb021-355d-4986-9de8-116394afc2da','state changed','OS::Neutron::Subnet',NULL,91),(476,'a513d9cc-71ab-446e-8c25-c229d2b9be7a','f1cabc12-90f5-4e11-b356-3243fcc57cb9','2026-01-21 11:50:02',NULL,'UPDATE','COMPLETE','subnet','3ddbee5a-74d7-4bb5-a962-a1bdb1b4d2c6','state changed','OS::Neutron::Subnet',NULL,93),(477,'d22f20eb-f11b-4b5d-8ae4-9d8f5b141be5','f1cabc12-90f5-4e11-b356-3243fcc57cb9','2026-01-21 11:50:02',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-976401956','f1cabc12-90f5-4e11-b356-3243fcc57cb9','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(478,'889d1694-ca77-4b87-a654-32400e29269a','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:02',NULL,'CREATE','COMPLETE','sub_port_two','a42e30b7-9193-417d-b09e-39d20fe3ce3d','state changed','OS::Neutron::Port',NULL,89),(479,'8fe8badf-084f-48da-b725-c3e27d46ff69','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:02',NULL,'CREATE','COMPLETE','parent_net','b27daec5-85c4-49ef-9598-daced17cb2da','state changed','OS::Neutron::Net',NULL,NULL),(480,'e7aea00a-f9fd-4d55-aae9-10770ca60122','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:02',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-408612344-parent_subnet-xjfwsfy526s2','state changed','OS::Neutron::Subnet',NULL,94),(481,'6b5e6b2e-2e91-498c-9d29-9bcf919ec21a','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:02',NULL,'CREATE','COMPLETE','trunk_subnet_one','4bf41a56-a2f9-494c-8f42-d8d8e1cb0dcb','state changed','OS::Neutron::Subnet',NULL,92),(482,'82c065d1-d4a5-46e4-b947-5a9e163e7213','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','2026-01-21 11:50:02',NULL,'CREATE','COMPLETE','subnet_b','cd713b2a-e247-494a-ba6d-958d3a88f862','state changed','OS::Neutron::Subnet',NULL,90),(483,'a1213dfc-f589-4382-aa8b-41eb6529d2d2','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:02',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-408612344-sub_port_one-tbvk2rjmm5gk','state changed','OS::Neutron::Port',NULL,95),(484,'996e01cf-f738-4b7e-81c3-63bf934d6342','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','2026-01-21 11:50:02',NULL,'CREATE','IN_PROGRESS','server','create_server_with_sub_ip-server-qxzttmqvw765','state changed','OS::Nova::Server',NULL,96),(485,'ebdb7693-ca1b-4300-b16a-b6e4aaa769e3','f61d157a-f715-4d69-8626-bee6625e900d','2026-01-21 11:50:02',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-763348251','f61d157a-f715-4d69-8626-bee6625e900d','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(486,'a7c3e4c2-31aa-4a21-93f8-79e4cfa58fad','f61d157a-f715-4d69-8626-bee6625e900d','2026-01-21 11:50:02',NULL,'DELETE','IN_PROGRESS','my_stack','38aad380-1fb2-4b3d-a021-fe517820438c','state changed','OS::Heat::Stack',NULL,80),(487,'e4573ed5-96ed-4176-8418-ec008b381e47','38aad380-1fb2-4b3d-a021-fe517820438c','2026-01-21 11:50:03',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-763348251-my_stack-kbzkiri4q7ts','38aad380-1fb2-4b3d-a021-fe517820438c','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(488,'7411d166-9ce8-420b-942c-2d5376a8a5b5','38aad380-1fb2-4b3d-a021-fe517820438c','2026-01-21 11:50:03',NULL,'DELETE','IN_PROGRESS','random1','RemoteStackTest-763348251-my_stack-kbzkiri4q7ts-random1-d2ayhlda6iys','state changed','OS::Heat::RandomString',NULL,NULL),(489,'c79e7477-79e1-440a-9d13-0d5430e6f7bf','38aad380-1fb2-4b3d-a021-fe517820438c','2026-01-21 11:50:03',NULL,'DELETE','COMPLETE','random1','RemoteStackTest-763348251-my_stack-kbzkiri4q7ts-random1-d2ayhlda6iys','state changed','OS::Heat::RandomString',NULL,NULL),(490,'207f0daf-2bc7-4cc2-bb80-45ce6ff10ef6','38aad380-1fb2-4b3d-a021-fe517820438c','2026-01-21 11:50:03',NULL,'DELETE','COMPLETE','RemoteStackTest-763348251-my_stack-kbzkiri4q7ts','38aad380-1fb2-4b3d-a021-fe517820438c','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(491,'a514d267-c9a7-409d-9105-1700bf9fdfba','f61d157a-f715-4d69-8626-bee6625e900d','2026-01-21 11:50:03',NULL,'DELETE','COMPLETE','my_stack','38aad380-1fb2-4b3d-a021-fe517820438c','state changed','OS::Heat::Stack',NULL,80),(492,'6c130453-d94c-4b4c-b371-1779ffc01b86','f61d157a-f715-4d69-8626-bee6625e900d','2026-01-21 11:50:03',NULL,'DELETE','COMPLETE','RemoteStackTest-763348251','f61d157a-f715-4d69-8626-bee6625e900d','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(493,'0a031174-cef4-47b1-8b5a-19b59c6bd748','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:03',NULL,'CREATE','COMPLETE','parent_subnet','789aaee9-b7f7-44b4-be44-7bb9f5621fe4','state changed','OS::Neutron::Subnet',NULL,94),(494,'9c7178e3-6aef-4fd9-b00c-39e11d501966','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:03',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-408612344-parent_port-6i6si3ymaj7f','state changed','OS::Neutron::Port',NULL,97),(495,'fc83c195-ddf9-4da2-8423-f7ac9f0dfc20','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:03',NULL,'CREATE','COMPLETE','sub_port_one','0d8eaabf-1a63-42c8-98da-84fd9e609b6c','state changed','OS::Neutron::Port',NULL,95),(496,'f5832d23-0312-44e4-b3f8-fc9ba68b3814','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:04',NULL,'CREATE','COMPLETE','parent_port','e6c0c506-e4a4-493c-b770-f67d9305fa4c','state changed','OS::Neutron::Port',NULL,97),(497,'937467cc-4f6d-49a1-8165-48bd82c4e131','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:04',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-408612344-trunk-p3sec6hwu66t','state changed','OS::Neutron::Trunk',NULL,98),(498,'39c01e56-5216-4f9c-81c7-9c3167079561','f1cabc12-90f5-4e11-b356-3243fcc57cb9','2026-01-21 11:50:05',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-976401956','f1cabc12-90f5-4e11-b356-3243fcc57cb9','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(499,'c00a0aa3-3894-4928-b10b-e37cab16b1d1','f1cabc12-90f5-4e11-b356-3243fcc57cb9','2026-01-21 11:50:05',NULL,'DELETE','IN_PROGRESS','subnet','3ddbee5a-74d7-4bb5-a962-a1bdb1b4d2c6','state changed','OS::Neutron::Subnet',NULL,93),(500,'058f78cb-cebc-4c54-8c35-dc14ad1d9f18','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:05',NULL,'CREATE','COMPLETE','trunk','b51aeda9-0c14-4d3b-b055-17cfd0a6a87c','state changed','OS::Neutron::Trunk',NULL,98),(501,'73176802-5140-4c1e-99ff-affa19ac4cd2','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:05',NULL,'CREATE','COMPLETE','UpdateTrunkTest-408612344','437ee61a-e4be-4a47-b741-ce15891367c9','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(502,'fa046eca-23eb-4c5d-b357-9fa18aa870ec','f1cabc12-90f5-4e11-b356-3243fcc57cb9','2026-01-21 11:50:06',NULL,'DELETE','COMPLETE','subnet','3ddbee5a-74d7-4bb5-a962-a1bdb1b4d2c6','state changed','OS::Neutron::Subnet',NULL,93),(503,'56042cdd-1d61-4304-ac98-2afc9e2ff294','f1cabc12-90f5-4e11-b356-3243fcc57cb9','2026-01-21 11:50:06',NULL,'DELETE','IN_PROGRESS','net','90cadcd2-650f-4425-bc4d-f70355b6e2bc','state changed','OS::Neutron::Net',NULL,NULL),(504,'f09a7445-127c-4aba-9ec6-d01d2ef61a3a','f1cabc12-90f5-4e11-b356-3243fcc57cb9','2026-01-21 11:50:07',NULL,'DELETE','COMPLETE','net','90cadcd2-650f-4425-bc4d-f70355b6e2bc','state changed','OS::Neutron::Net',NULL,NULL),(505,'3a18a3c4-424b-45b6-80ab-be20e7ea1976','f1cabc12-90f5-4e11-b356-3243fcc57cb9','2026-01-21 11:50:07',NULL,'DELETE','COMPLETE','UpdateSubnetTest-976401956','f1cabc12-90f5-4e11-b356-3243fcc57cb9','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(506,'7a74bb86-09f7-4773-8be2-42b1377b5484','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:08',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-408612344','437ee61a-e4be-4a47-b741-ce15891367c9','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(507,'9f44389c-7084-47a0-96e8-a5da00dc1cb4','ec97ad01-1c3d-4447-954d-7fd960a76124','2026-01-21 11:50:08',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-842759927','ec97ad01-1c3d-4447-954d-7fd960a76124','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(508,'6184263d-8549-45c2-a8cf-ad81db5f818a','ec97ad01-1c3d-4447-954d-7fd960a76124','2026-01-21 11:50:08',NULL,'CREATE','IN_PROGRESS','my_stack','RemoteStackTest-842759927-my_stack-i3ilo3gkf3zk','state changed','OS::Heat::Stack',NULL,100),(509,'5939f5d4-b31d-4a11-87cd-e1c806fe014d','2039e3cd-e025-4a9b-8d03-e755306d3b83','2026-01-21 11:50:09',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-842759927-my_stack-i3ilo3gkf3zk','2039e3cd-e025-4a9b-8d03-e755306d3b83','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(510,'534953b5-a98f-494b-b411-c5c2b0bda021','2039e3cd-e025-4a9b-8d03-e755306d3b83','2026-01-21 11:50:09',NULL,'CREATE','IN_PROGRESS','random1','RemoteStackTest-842759927-my_stack-i3ilo3gkf3zk-random1-okukr76arkac','state changed','OS::Heat::RandomString',NULL,NULL),(511,'d1e911db-7bfa-41dc-8f10-033c42be4155','2039e3cd-e025-4a9b-8d03-e755306d3b83','2026-01-21 11:50:09',NULL,'CREATE','COMPLETE','random1','RemoteStackTest-842759927-my_stack-i3ilo3gkf3zk-random1-okukr76arkac','state changed','OS::Heat::RandomString',NULL,NULL),(512,'d48caf30-daa5-4d07-b93e-2a61da36bb76','2039e3cd-e025-4a9b-8d03-e755306d3b83','2026-01-21 11:50:09',NULL,'CREATE','COMPLETE','RemoteStackTest-842759927-my_stack-i3ilo3gkf3zk','2039e3cd-e025-4a9b-8d03-e755306d3b83','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(513,'a1f8cf0e-4792-4c4d-b361-1bc2630de218','ec97ad01-1c3d-4447-954d-7fd960a76124','2026-01-21 11:50:09',NULL,'CREATE','COMPLETE','my_stack','2039e3cd-e025-4a9b-8d03-e755306d3b83','state changed','OS::Heat::Stack',NULL,100),(514,'c6f47c41-ecf7-467e-a1dd-cf572cefaf9f','ec97ad01-1c3d-4447-954d-7fd960a76124','2026-01-21 11:50:09',NULL,'CREATE','COMPLETE','RemoteStackTest-842759927','ec97ad01-1c3d-4447-954d-7fd960a76124','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(515,'2c96cb7c-35b4-4eec-b34d-10c3f3e965e9','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:11',NULL,'UPDATE','IN_PROGRESS','trunk','b51aeda9-0c14-4d3b-b055-17cfd0a6a87c','state changed','OS::Neutron::Trunk',NULL,98),(516,'bd97cb78-56fd-4eee-8f27-20af2f707e5c','6e2b1add-2f56-4b2a-a2e7-b48b258eb3e3','2026-01-21 11:50:11',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-1034942007','6e2b1add-2f56-4b2a-a2e7-b48b258eb3e3','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(517,'01fd044d-2c33-41e3-b27e-9999ca8e1f46','6e2b1add-2f56-4b2a-a2e7-b48b258eb3e3','2026-01-21 11:50:11',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-1034942007-net-qonhwgyuel74','state changed','OS::Neutron::Net',NULL,NULL),(518,'0f0d8037-316f-40f7-9b78-67eed9179d91','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','2026-01-21 11:50:12',NULL,'CREATE','COMPLETE','server','3cbefdca-2564-4dda-bd4e-1b3999a27019','state changed','OS::Nova::Server',NULL,96),(519,'92fd4d41-0d54-4719-8eb7-a4431aac7248','6e2b1add-2f56-4b2a-a2e7-b48b258eb3e3','2026-01-21 11:50:12',NULL,'CREATE','COMPLETE','net','6830bbfb-ac04-4d6a-91a6-2abf834e167d','state changed','OS::Neutron::Net',NULL,NULL),(520,'7dbefbc0-a34d-4541-be1d-f081ffa64de7','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','2026-01-21 11:50:12',NULL,'CREATE','COMPLETE','create_server_with_sub_ip','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(521,'0337547e-1f17-40a8-9636-4cb218cea3f3','6e2b1add-2f56-4b2a-a2e7-b48b258eb3e3','2026-01-21 11:50:12',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-1034942007-subnet-nlqmgdaiq6t4','state changed','OS::Neutron::Subnet',NULL,101),(522,'94294955-4f47-4709-be2d-0e5dfd3c7862','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:12',NULL,'UPDATE','COMPLETE','trunk','b51aeda9-0c14-4d3b-b055-17cfd0a6a87c','state changed','OS::Neutron::Trunk',NULL,102),(523,'d8c966a8-f777-44b0-ad56-955014ebc3eb','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:12',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-408612344','437ee61a-e4be-4a47-b741-ce15891367c9','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(524,'eec82afb-4089-45d2-b8b8-fe7f237509e3','6e2b1add-2f56-4b2a-a2e7-b48b258eb3e3','2026-01-21 11:50:12',NULL,'CREATE','COMPLETE','subnet','7a235fce-91d1-4235-b6be-1b23cd92fbe0','state changed','OS::Neutron::Subnet',NULL,101),(525,'ac131747-9528-414e-973d-918404d071e8','6e2b1add-2f56-4b2a-a2e7-b48b258eb3e3','2026-01-21 11:50:12',NULL,'CREATE','COMPLETE','UpdateSubnetTest-1034942007','6e2b1add-2f56-4b2a-a2e7-b48b258eb3e3','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(526,'b7938fb3-5b3a-4d84-989c-18d28e74395f','ec97ad01-1c3d-4447-954d-7fd960a76124','2026-01-21 11:50:14',NULL,'UPDATE','IN_PROGRESS','RemoteStackTest-842759927','ec97ad01-1c3d-4447-954d-7fd960a76124','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(527,'a8d21754-6dc9-420c-847e-04a4a0e4f5a9','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','2026-01-21 11:50:14',NULL,'UPDATE','IN_PROGRESS','create_server_with_sub_ip','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(528,'b87f7455-64e0-4174-b4d6-d717d6ed07ce','ec97ad01-1c3d-4447-954d-7fd960a76124','2026-01-21 11:50:14',NULL,'UPDATE','IN_PROGRESS','my_stack','2039e3cd-e025-4a9b-8d03-e755306d3b83','state changed','OS::Heat::Stack',NULL,100),(529,'a53955bc-92b8-44b6-9b7c-439b1432e8de','2039e3cd-e025-4a9b-8d03-e755306d3b83','2026-01-21 11:50:16',NULL,'UPDATE','IN_PROGRESS','RemoteStackTest-842759927-my_stack-i3ilo3gkf3zk','2039e3cd-e025-4a9b-8d03-e755306d3b83','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(530,'27910c44-785d-43ca-a4c0-e2fa15f14028','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','2026-01-21 11:50:16',NULL,'UPDATE','IN_PROGRESS','server','3cbefdca-2564-4dda-bd4e-1b3999a27019','state changed','OS::Nova::Server',NULL,96),(531,'dc11efd7-a855-478f-a384-87503ad561dd','2039e3cd-e025-4a9b-8d03-e755306d3b83','2026-01-21 11:50:16',NULL,'DELETE','IN_PROGRESS','random1','RemoteStackTest-842759927-my_stack-i3ilo3gkf3zk-random1-okukr76arkac','state changed','OS::Heat::RandomString',NULL,NULL),(532,'9c7c0ba2-049a-4928-accb-eccc9e7fa641','2039e3cd-e025-4a9b-8d03-e755306d3b83','2026-01-21 11:50:16',NULL,'DELETE','COMPLETE','random1','RemoteStackTest-842759927-my_stack-i3ilo3gkf3zk-random1-okukr76arkac','state changed','OS::Heat::RandomString',NULL,NULL),(533,'8798b00d-c78e-4a05-8f68-133415d101b1','2039e3cd-e025-4a9b-8d03-e755306d3b83','2026-01-21 11:50:17',NULL,'CREATE','IN_PROGRESS','random2','RemoteStackTest-842759927-my_stack-i3ilo3gkf3zk-random2-hectanopikam','state changed','OS::Heat::RandomString',NULL,NULL),(534,'ed9f8ee3-0691-4ae8-9144-f59d610fd344','6e2b1add-2f56-4b2a-a2e7-b48b258eb3e3','2026-01-21 11:50:17',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-1034942007','6e2b1add-2f56-4b2a-a2e7-b48b258eb3e3','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(535,'983ab4a4-aa81-451f-8d83-9a18b222f8fa','2039e3cd-e025-4a9b-8d03-e755306d3b83','2026-01-21 11:50:17',NULL,'CREATE','COMPLETE','random2','RemoteStackTest-842759927-my_stack-i3ilo3gkf3zk-random2-hectanopikam','state changed','OS::Heat::RandomString',NULL,NULL),(536,'5556945c-2087-4d17-bda7-995bc35c0daf','2039e3cd-e025-4a9b-8d03-e755306d3b83','2026-01-21 11:50:17',NULL,'UPDATE','COMPLETE','RemoteStackTest-842759927-my_stack-i3ilo3gkf3zk','2039e3cd-e025-4a9b-8d03-e755306d3b83','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(537,'7a3e80d8-2674-4d6a-9109-fa2e3465762b','6e2b1add-2f56-4b2a-a2e7-b48b258eb3e3','2026-01-21 11:50:17',NULL,'UPDATE','IN_PROGRESS','subnet','7a235fce-91d1-4235-b6be-1b23cd92fbe0','state changed','OS::Neutron::Subnet',NULL,101),(538,'19532629-2112-4302-a111-d15a99b78477','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:18',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-408612344','437ee61a-e4be-4a47-b741-ce15891367c9','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(539,'a33c24dd-9f5c-4891-90ee-913606ab5587','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:18',NULL,'DELETE','IN_PROGRESS','trunk','b51aeda9-0c14-4d3b-b055-17cfd0a6a87c','state changed','OS::Neutron::Trunk',NULL,102),(540,'178692f2-ce9b-4603-8106-460dcd224fd5','ec97ad01-1c3d-4447-954d-7fd960a76124','2026-01-21 11:50:19',NULL,'UPDATE','COMPLETE','my_stack','2039e3cd-e025-4a9b-8d03-e755306d3b83','state changed','OS::Heat::Stack',NULL,106),(541,'0ac0ad59-0c9b-4bdf-9ae1-7ad6f3ab1aa0','ec97ad01-1c3d-4447-954d-7fd960a76124','2026-01-21 11:50:19',NULL,'UPDATE','COMPLETE','RemoteStackTest-842759927','ec97ad01-1c3d-4447-954d-7fd960a76124','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(542,'52c676ce-5860-4690-8c76-b5d6e18ce4f3','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:19',NULL,'DELETE','IN_PROGRESS','sub_port_two','a42e30b7-9193-417d-b09e-39d20fe3ce3d','state changed','OS::Neutron::Port',NULL,89),(543,'28714aa7-f9e7-4e1f-82ec-d4e6425ac567','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:19',NULL,'DELETE','COMPLETE','trunk','b51aeda9-0c14-4d3b-b055-17cfd0a6a87c','state changed','OS::Neutron::Trunk',NULL,102),(544,'0ccf4a8d-70cb-4dc4-94fb-4a4795b3bd22','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:19',NULL,'DELETE','IN_PROGRESS','sub_port_one','0d8eaabf-1a63-42c8-98da-84fd9e609b6c','state changed','OS::Neutron::Port',NULL,95),(545,'f84c306e-e68c-4a1d-97ff-b7433bef3bf1','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:19',NULL,'DELETE','IN_PROGRESS','parent_port','e6c0c506-e4a4-493c-b770-f67d9305fa4c','state changed','OS::Neutron::Port',NULL,97),(546,'3927546d-0c4f-4db5-bf1b-83ba5c9b8a81','6e2b1add-2f56-4b2a-a2e7-b48b258eb3e3','2026-01-21 11:50:20',NULL,'UPDATE','COMPLETE','subnet','7a235fce-91d1-4235-b6be-1b23cd92fbe0','state changed','OS::Neutron::Subnet',NULL,107),(547,'02753152-343b-478c-96fb-04f65084daf0','6e2b1add-2f56-4b2a-a2e7-b48b258eb3e3','2026-01-21 11:50:20',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-1034942007','6e2b1add-2f56-4b2a-a2e7-b48b258eb3e3','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(548,'b2d2953c-0d16-439e-a996-48f48a6015e8','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:20',NULL,'DELETE','COMPLETE','sub_port_two','a42e30b7-9193-417d-b09e-39d20fe3ce3d','state changed','OS::Neutron::Port',NULL,89),(549,'293ebd3f-9b90-4581-a973-89a043402618','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:20',NULL,'DELETE','COMPLETE','sub_port_one','0d8eaabf-1a63-42c8-98da-84fd9e609b6c','state changed','OS::Neutron::Port',NULL,95),(550,'0de30e7b-d4a6-4bbb-a49d-381643e297d4','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:20',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','0e8035f6-1653-46d4-8cc4-fb6c48c2f9b2','state changed','OS::Neutron::Subnet',NULL,86),(551,'d561c48e-60bd-4b80-ba76-4b8ffa60e3c3','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:20',NULL,'DELETE','COMPLETE','parent_port','e6c0c506-e4a4-493c-b770-f67d9305fa4c','state changed','OS::Neutron::Port',NULL,97),(552,'cd4e851d-6372-424b-9940-c068844ac25c','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:20',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','4bf41a56-a2f9-494c-8f42-d8d8e1cb0dcb','state changed','OS::Neutron::Subnet',NULL,92),(553,'eea45065-4b23-4a74-aa3b-9e097f6a266f','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:20',NULL,'DELETE','IN_PROGRESS','parent_subnet','789aaee9-b7f7-44b4-be44-7bb9f5621fe4','state changed','OS::Neutron::Subnet',NULL,94),(554,'beaecef3-603d-4fba-a2fe-15046447158b','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:20',NULL,'DELETE','COMPLETE','trunk_subnet_two','0e8035f6-1653-46d4-8cc4-fb6c48c2f9b2','state changed','OS::Neutron::Subnet',NULL,86),(555,'23beb80a-481b-4fc9-9188-f1080ad7f868','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:20',NULL,'DELETE','IN_PROGRESS','trunk_net_two','efd5e132-6838-4062-a519-ce03dd2a850d','state changed','OS::Neutron::Net',NULL,NULL),(556,'8efd8f55-1e49-4d91-b88d-e337d4d18b52','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:20',NULL,'DELETE','COMPLETE','trunk_subnet_one','4bf41a56-a2f9-494c-8f42-d8d8e1cb0dcb','state changed','OS::Neutron::Subnet',NULL,92),(557,'665fe15c-1853-426d-956c-36e633f6ca8d','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:20',NULL,'DELETE','COMPLETE','parent_subnet','789aaee9-b7f7-44b4-be44-7bb9f5621fe4','state changed','OS::Neutron::Subnet',NULL,94),(558,'0da95c3b-c318-485c-a121-a8f56e3d5760','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:20',NULL,'DELETE','IN_PROGRESS','parent_net','b27daec5-85c4-49ef-9598-daced17cb2da','state changed','OS::Neutron::Net',NULL,NULL),(559,'290a04c1-ab81-4d0d-9699-e1dd91eec6a9','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:20',NULL,'DELETE','IN_PROGRESS','trunk_net_one','cfe08323-cb33-42c0-a863-a027bbdbd3b2','state changed','OS::Neutron::Net',NULL,NULL),(560,'4f4e68fb-2a10-4327-a675-b6d4740420ac','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:21',NULL,'DELETE','COMPLETE','parent_net','b27daec5-85c4-49ef-9598-daced17cb2da','state changed','OS::Neutron::Net',NULL,NULL),(561,'721813f9-359a-4cfd-99d0-76fe87e5b17c','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:21',NULL,'DELETE','COMPLETE','trunk_net_two','efd5e132-6838-4062-a519-ce03dd2a850d','state changed','OS::Neutron::Net',NULL,NULL),(562,'1471a775-87e1-4e36-90e8-ec70c0c9b1fd','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:21',NULL,'DELETE','COMPLETE','trunk_net_one','cfe08323-cb33-42c0-a863-a027bbdbd3b2','state changed','OS::Neutron::Net',NULL,NULL),(563,'89ac95f4-c835-413f-bc65-2ce2afdb7b9e','437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:50:21',NULL,'DELETE','COMPLETE','UpdateTrunkTest-408612344','437ee61a-e4be-4a47-b741-ce15891367c9','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(564,'23c68bec-1ec7-45f7-802d-389b0d50b5d2','6e2b1add-2f56-4b2a-a2e7-b48b258eb3e3','2026-01-21 11:50:21',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-1034942007','6e2b1add-2f56-4b2a-a2e7-b48b258eb3e3','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(565,'7de52fea-a9eb-4f45-b51d-3f17e7c49c28','6e2b1add-2f56-4b2a-a2e7-b48b258eb3e3','2026-01-21 11:50:21',NULL,'DELETE','IN_PROGRESS','subnet','7a235fce-91d1-4235-b6be-1b23cd92fbe0','state changed','OS::Neutron::Subnet',NULL,107),(566,'4ef5a75a-303f-477b-8e09-dee917c94f42','6e2b1add-2f56-4b2a-a2e7-b48b258eb3e3','2026-01-21 11:50:22',NULL,'DELETE','COMPLETE','subnet','7a235fce-91d1-4235-b6be-1b23cd92fbe0','state changed','OS::Neutron::Subnet',NULL,107),(567,'9d6a79c8-010f-4a6b-ac4f-1d50c67510d4','6e2b1add-2f56-4b2a-a2e7-b48b258eb3e3','2026-01-21 11:50:22',NULL,'DELETE','IN_PROGRESS','net','6830bbfb-ac04-4d6a-91a6-2abf834e167d','state changed','OS::Neutron::Net',NULL,NULL),(568,'347e8eb1-a79a-4a23-9220-95be3dd3dcba','6e2b1add-2f56-4b2a-a2e7-b48b258eb3e3','2026-01-21 11:50:23',NULL,'DELETE','COMPLETE','net','6830bbfb-ac04-4d6a-91a6-2abf834e167d','state changed','OS::Neutron::Net',NULL,NULL),(569,'691b8585-62cc-44f9-94de-8a1acbd4dbdd','6e2b1add-2f56-4b2a-a2e7-b48b258eb3e3','2026-01-21 11:50:23',NULL,'DELETE','COMPLETE','UpdateSubnetTest-1034942007','6e2b1add-2f56-4b2a-a2e7-b48b258eb3e3','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(570,'bc3e7d0b-978c-454f-8cae-888c37af9102','ec97ad01-1c3d-4447-954d-7fd960a76124','2026-01-21 11:50:24',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-842759927','ec97ad01-1c3d-4447-954d-7fd960a76124','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(571,'f03f65e5-61b2-4c13-ac2d-283587bdf04b','ec97ad01-1c3d-4447-954d-7fd960a76124','2026-01-21 11:50:24',NULL,'DELETE','IN_PROGRESS','my_stack','2039e3cd-e025-4a9b-8d03-e755306d3b83','state changed','OS::Heat::Stack',NULL,106),(572,'15cd5991-3cf4-4736-a3a5-eb3d1103cba2','2039e3cd-e025-4a9b-8d03-e755306d3b83','2026-01-21 11:50:24',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-842759927-my_stack-i3ilo3gkf3zk','2039e3cd-e025-4a9b-8d03-e755306d3b83','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(573,'4be8f00f-aaf2-48f3-86f6-a87e30405660','2039e3cd-e025-4a9b-8d03-e755306d3b83','2026-01-21 11:50:24',NULL,'DELETE','IN_PROGRESS','random2','RemoteStackTest-842759927-my_stack-i3ilo3gkf3zk-random2-hectanopikam','state changed','OS::Heat::RandomString',NULL,NULL),(574,'d0486b48-d738-4ddc-9be2-6d1945b4d23f','2039e3cd-e025-4a9b-8d03-e755306d3b83','2026-01-21 11:50:24',NULL,'DELETE','COMPLETE','random2','RemoteStackTest-842759927-my_stack-i3ilo3gkf3zk-random2-hectanopikam','state changed','OS::Heat::RandomString',NULL,NULL),(575,'3d710224-bfd8-465e-b6b8-5227a8e6b038','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:24',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-1549168250','5d7eda9e-81f7-4021-beda-f9db9e7058a7','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(576,'4de81186-332b-4535-814e-8deab2f80d12','2039e3cd-e025-4a9b-8d03-e755306d3b83','2026-01-21 11:50:24',NULL,'DELETE','COMPLETE','RemoteStackTest-842759927-my_stack-i3ilo3gkf3zk','2039e3cd-e025-4a9b-8d03-e755306d3b83','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(577,'5c2677e6-2f67-4a4b-a714-bdbb2224a766','ec97ad01-1c3d-4447-954d-7fd960a76124','2026-01-21 11:50:24',NULL,'DELETE','COMPLETE','my_stack','2039e3cd-e025-4a9b-8d03-e755306d3b83','state changed','OS::Heat::Stack',NULL,106),(578,'6746706a-1bc6-43a8-8346-b048e42c78b4','ec97ad01-1c3d-4447-954d-7fd960a76124','2026-01-21 11:50:24',NULL,'DELETE','COMPLETE','RemoteStackTest-842759927','ec97ad01-1c3d-4447-954d-7fd960a76124','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(579,'88621c34-1528-4e42-baa7-b845f7ce62c7','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:24',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-1549168250-trunk_net_one-ia4d4pfpotu6','state changed','OS::Neutron::Net',NULL,NULL),(580,'2dc19f30-7dc6-4ee6-8f95-16085a3b8374','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:25',NULL,'CREATE','COMPLETE','trunk_net_one','86bba8eb-3413-4f62-9fe6-ff848cbc20ed','state changed','OS::Neutron::Net',NULL,NULL),(581,'2293ec92-a120-491f-8a83-ecdc9c05384c','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:25',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-1549168250-trunk_subnet_one-qnweaogz75yi','state changed','OS::Neutron::Subnet',NULL,109),(582,'bd91fb61-827f-4e40-851b-053558b5f23f','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:26',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-1549168250-trunk_net_two-ynpuwxwitdrq','state changed','OS::Neutron::Net',NULL,NULL),(583,'29b43ece-4e6d-4282-9890-2dfe0644cce7','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:26',NULL,'CREATE','COMPLETE','trunk_net_two','08cfb3a7-9284-44e8-910c-6af21dc8688b','state changed','OS::Neutron::Net',NULL,NULL),(584,'4fb7ef72-7f1a-41d5-a633-d7b3f8dc9373','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:26',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-1549168250-trunk_subnet_two-mf5jvgsknmvn','state changed','OS::Neutron::Subnet',NULL,110),(585,'c2cd13ec-9773-473e-bf54-dc7ce70e83f8','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:26',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-1549168250-parent_net-7x4geuti3agl','state changed','OS::Neutron::Net',NULL,NULL),(586,'b1f8ed7b-afc9-48e9-bfa7-6740ce70be9e','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:27',NULL,'CREATE','COMPLETE','trunk_subnet_one','c2f48c67-e762-4621-885d-8cc61dd10835','state changed','OS::Neutron::Subnet',NULL,109),(587,'8bee9849-424f-4ed5-9144-2bc9ede5982f','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:27',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-1549168250-sub_port_one-f7pgl3t4whfh','state changed','OS::Neutron::Port',NULL,111),(588,'33d55489-4ba4-437d-9422-23bfe148994b','38dfaedd-5ab8-4310-8eeb-ed650e0d43ef','2026-01-21 11:50:27',NULL,'CREATE','IN_PROGRESS','HooksTest-1789230450','38dfaedd-5ab8-4310-8eeb-ed650e0d43ef','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(589,'6f10baa6-99d6-49ed-970e-cc06646bc49b','38dfaedd-5ab8-4310-8eeb-ed650e0d43ef','2026-01-21 11:50:27',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-1789230450-foo_step1-275frdujujwo','state changed','OS::Heat::RandomString',NULL,NULL),(590,'2b3469e8-b976-4d52-b57f-a1120b09d296','38dfaedd-5ab8-4310-8eeb-ed650e0d43ef','2026-01-21 11:50:27',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-1789230450-foo_step1-275frdujujwo','state changed','OS::Heat::RandomString',NULL,NULL),(591,'9eb88fad-3192-4146-a0cf-3a7c5288b8df','38dfaedd-5ab8-4310-8eeb-ed650e0d43ef','2026-01-21 11:50:27',NULL,'INIT','COMPLETE','foo_step2',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(592,'7cae7ab1-aa96-4444-bff7-fb45f7f3ca7e','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:27',NULL,'CREATE','COMPLETE','parent_net','aff2b0f4-9b44-42a0-816d-fccd7afbf024','state changed','OS::Neutron::Net',NULL,NULL),(593,'baa49883-4535-417f-b519-1b2864f55c8a','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:27',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-1549168250-parent_subnet-gldrwac6pcqh','state changed','OS::Neutron::Subnet',NULL,112),(594,'671ca519-bf5f-40f7-890e-fac953d9cbab','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:28',NULL,'CREATE','COMPLETE','trunk_subnet_two','8cdf4a2d-b787-4235-acff-da81f2437dd8','state changed','OS::Neutron::Subnet',NULL,110),(595,'f7c9c22d-cf6a-42fa-a46e-bf3032e63d93','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:28',NULL,'CREATE','COMPLETE','sub_port_one','e306ac42-012f-44ae-94ef-38ca25e2d340','state changed','OS::Neutron::Port',NULL,111),(596,'fce14eb9-4490-434d-8aa4-0c0093a760e0','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:28',NULL,'CREATE','COMPLETE','parent_subnet','7b253ec9-723f-46ae-9b19-3d8429b2ae45','state changed','OS::Neutron::Subnet',NULL,112),(597,'670b5470-04b6-44f2-aa2a-b542bbbf461b','38dfaedd-5ab8-4310-8eeb-ed650e0d43ef','2026-01-21 11:50:28',NULL,'INIT','COMPLETE','foo_step2',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(598,'c3485149-2d94-41ec-befd-1e2864a88f98','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:28',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-1549168250-sub_port_two-rsdpnzg6kxof','state changed','OS::Neutron::Port',NULL,113),(599,'65b997e3-1be6-4282-89e1-71b6490290d0','38dfaedd-5ab8-4310-8eeb-ed650e0d43ef','2026-01-21 11:50:28',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-1789230450-foo_step2-gpns5j7iomja','state changed','OS::Heat::RandomString',NULL,NULL),(600,'77576036-c7f0-4859-9f83-8f9fb529d685','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:28',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-1549168250-parent_port-d47qlzdruxxx','state changed','OS::Neutron::Port',NULL,114),(601,'4c56e50d-e11d-4a41-b0cd-2297d0aa7eda','38dfaedd-5ab8-4310-8eeb-ed650e0d43ef','2026-01-21 11:50:29',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1789230450-foo_step2-gpns5j7iomja','state changed','OS::Heat::RandomString',NULL,NULL),(602,'a269dd21-4a0f-480e-a454-6b0b5e33f34c','38dfaedd-5ab8-4310-8eeb-ed650e0d43ef','2026-01-21 11:50:29',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-1789230450-foo_step3-yugaxzzryi6l','state changed','OS::Heat::RandomString',NULL,NULL),(603,'085f089d-1c19-4742-93f8-44659f26aae4','38dfaedd-5ab8-4310-8eeb-ed650e0d43ef','2026-01-21 11:50:29',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-1789230450-foo_step3-yugaxzzryi6l','state changed','OS::Heat::RandomString',NULL,NULL),(604,'035cdaf2-3b4c-4881-ad34-b6393ce34c55','38dfaedd-5ab8-4310-8eeb-ed650e0d43ef','2026-01-21 11:50:29',NULL,'CREATE','COMPLETE','HooksTest-1789230450','38dfaedd-5ab8-4310-8eeb-ed650e0d43ef','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(605,'5e4a373d-e689-4ef8-a19d-041cc632edd7','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:29',NULL,'CREATE','COMPLETE','parent_port','6b83d18a-296c-4b99-b632-eadf14e0c431','state changed','OS::Neutron::Port',NULL,114),(606,'f82c8132-45be-48a8-8ff0-ef9917476379','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:29',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-1549168250-trunk-rli6k6h3sxlw','state changed','OS::Neutron::Trunk',NULL,115),(607,'d3a0931b-376d-4aa3-9935-9f3c87849e55','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:30',NULL,'CREATE','COMPLETE','sub_port_two','d8c0ba67-fa2b-447d-82fd-96cff5af8bac','state changed','OS::Neutron::Port',NULL,113),(608,'0320505f-7b0d-4809-a992-3a6bf927e37a','f0dca769-a303-42af-9a3e-326de6978ff5','2026-01-21 11:50:30',NULL,'CREATE','IN_PROGRESS','ResourcesList-1503661181','f0dca769-a303-42af-9a3e-326de6978ff5','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(609,'36f3a233-b24a-490c-8b92-783d1eb77aff','f0dca769-a303-42af-9a3e-326de6978ff5','2026-01-21 11:50:30',NULL,'CREATE','IN_PROGRESS','test1','ResourcesList-1503661181-test1-7zgmzxp3dfsm','state changed','OS::Heat::TestResource',NULL,116),(610,'05e20d50-f93f-41bb-ae27-c402f574a7f3','f0dca769-a303-42af-9a3e-326de6978ff5','2026-01-21 11:50:30',NULL,'CREATE','COMPLETE','test1','ResourcesList-1503661181-test1-7zgmzxp3dfsm','state changed','OS::Heat::TestResource',NULL,116),(611,'c69abd1d-ac2d-4e63-996b-e3a56a8ed747','f0dca769-a303-42af-9a3e-326de6978ff5','2026-01-21 11:50:30',NULL,'CREATE','IN_PROGRESS','test2','ResourcesList-1503661181-test2-lwebiotfasuu','state changed','OS::Heat::TestResource',NULL,117),(612,'f1ebe57d-3c94-4bc3-b545-e5ff64adce7b','f0dca769-a303-42af-9a3e-326de6978ff5','2026-01-21 11:50:30',NULL,'CREATE','COMPLETE','test2','ResourcesList-1503661181-test2-lwebiotfasuu','state changed','OS::Heat::TestResource',NULL,117),(613,'88cab77f-805a-4724-80b4-d74fc6582689','f0dca769-a303-42af-9a3e-326de6978ff5','2026-01-21 11:50:30',NULL,'CREATE','COMPLETE','ResourcesList-1503661181','f0dca769-a303-42af-9a3e-326de6978ff5','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(614,'fa32670a-87a9-4dab-88c8-d249ebd15603','f0dca769-a303-42af-9a3e-326de6978ff5','2026-01-21 11:50:30',NULL,'DELETE','IN_PROGRESS','ResourcesList-1503661181','f0dca769-a303-42af-9a3e-326de6978ff5','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(615,'53f12092-4464-4d8a-b3ae-a93e805f38c7','f0dca769-a303-42af-9a3e-326de6978ff5','2026-01-21 11:50:30',NULL,'DELETE','IN_PROGRESS','test2','ResourcesList-1503661181-test2-lwebiotfasuu','state changed','OS::Heat::TestResource',NULL,117),(616,'ce18d04f-869c-4e67-a174-e62b860531d0','f0dca769-a303-42af-9a3e-326de6978ff5','2026-01-21 11:50:31',NULL,'DELETE','COMPLETE','test2','ResourcesList-1503661181-test2-lwebiotfasuu','state changed','OS::Heat::TestResource',NULL,117),(617,'ebea0f88-4905-4be9-a8ed-8fd16b710e26','f0dca769-a303-42af-9a3e-326de6978ff5','2026-01-21 11:50:31',NULL,'DELETE','IN_PROGRESS','test1','ResourcesList-1503661181-test1-7zgmzxp3dfsm','state changed','OS::Heat::TestResource',NULL,116),(618,'9ab6bbe2-a499-4226-91c6-093561e3d4fa','f0dca769-a303-42af-9a3e-326de6978ff5','2026-01-21 11:50:31',NULL,'DELETE','COMPLETE','test1','ResourcesList-1503661181-test1-7zgmzxp3dfsm','state changed','OS::Heat::TestResource',NULL,116),(619,'330510c1-17da-4195-9f28-764abaae9d97','f0dca769-a303-42af-9a3e-326de6978ff5','2026-01-21 11:50:31',NULL,'DELETE','COMPLETE','ResourcesList-1503661181','f0dca769-a303-42af-9a3e-326de6978ff5','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(620,'2932aa01-5243-40ec-8d96-eac461bf0ae1','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:31',NULL,'CREATE','COMPLETE','trunk','d6c718b9-c505-4bae-9c86-0740b3fceceb','state changed','OS::Neutron::Trunk',NULL,115),(621,'b84207ea-2cfa-4372-bd01-d4c05a5f0f77','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:31',NULL,'CREATE','COMPLETE','UpdateTrunkTest-1549168250','5d7eda9e-81f7-4021-beda-f9db9e7058a7','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(622,'cc8493d1-eb5d-402f-bb07-5d6fa66f7283','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','2026-01-21 11:50:32',NULL,'UPDATE','COMPLETE','server','3cbefdca-2564-4dda-bd4e-1b3999a27019','state changed','OS::Nova::Server',NULL,118),(623,'1cf74fc8-a59a-43fd-ae97-c8631ccfe289','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','2026-01-21 11:50:32',NULL,'UPDATE','COMPLETE','create_server_with_sub_ip','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(624,'a09e5b40-cb33-4e60-8e8b-c20a310e0124','38dfaedd-5ab8-4310-8eeb-ed650e0d43ef','2026-01-21 11:50:33',NULL,'DELETE','IN_PROGRESS','HooksTest-1789230450','38dfaedd-5ab8-4310-8eeb-ed650e0d43ef','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(625,'196ec4cd-9971-4852-b8d4-dcf18417b18d','38dfaedd-5ab8-4310-8eeb-ed650e0d43ef','2026-01-21 11:50:33',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-1789230450-foo_step3-yugaxzzryi6l','state changed','OS::Heat::RandomString',NULL,NULL),(626,'5483bd17-dc48-43bf-b07a-42c221dc5ab8','38dfaedd-5ab8-4310-8eeb-ed650e0d43ef','2026-01-21 11:50:33',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-1789230450-foo_step3-yugaxzzryi6l','state changed','OS::Heat::RandomString',NULL,NULL),(627,'ca536728-a32d-4bb8-8bf1-367607debca5','38dfaedd-5ab8-4310-8eeb-ed650e0d43ef','2026-01-21 11:50:33',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-1789230450-foo_step2-gpns5j7iomja','state changed','OS::Heat::RandomString',NULL,NULL),(628,'77d2e328-16fa-4644-9f5b-5246b5ab52b5','38dfaedd-5ab8-4310-8eeb-ed650e0d43ef','2026-01-21 11:50:33',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-1789230450-foo_step2-gpns5j7iomja','state changed','OS::Heat::RandomString',NULL,NULL),(629,'40a7e0c7-a4cf-4048-9aea-73ee4d4f76f7','38dfaedd-5ab8-4310-8eeb-ed650e0d43ef','2026-01-21 11:50:33',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-1789230450-foo_step1-275frdujujwo','state changed','OS::Heat::RandomString',NULL,NULL),(630,'40bc74ae-a192-40c8-a64b-813329455482','38dfaedd-5ab8-4310-8eeb-ed650e0d43ef','2026-01-21 11:50:33',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-1789230450-foo_step1-275frdujujwo','state changed','OS::Heat::RandomString',NULL,NULL),(631,'a6168d0d-a3d3-46c5-b099-0259f5066c04','38dfaedd-5ab8-4310-8eeb-ed650e0d43ef','2026-01-21 11:50:33',NULL,'DELETE','COMPLETE','HooksTest-1789230450','38dfaedd-5ab8-4310-8eeb-ed650e0d43ef','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(632,'dfef5a1b-c201-4f87-a7a9-ac8bf612832b','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:34',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-1549168250','5d7eda9e-81f7-4021-beda-f9db9e7058a7','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(633,'e1a1cc75-cc65-4440-8db8-2679303fbbe8','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','2026-01-21 11:50:36',NULL,'DELETE','IN_PROGRESS','create_server_with_sub_ip','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(634,'e376e30b-a47d-4aee-baa5-e55790436bdc','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','2026-01-21 11:50:36',NULL,'DELETE','IN_PROGRESS','server','3cbefdca-2564-4dda-bd4e-1b3999a27019','state changed','OS::Nova::Server',NULL,118),(635,'46225fa8-97d5-49a5-8bd4-b038711db884','6f75ad05-2e01-411d-b127-da7968e32873','2026-01-21 11:50:36',NULL,'CREATE','IN_PROGRESS','ResourcesList-1955174437','6f75ad05-2e01-411d-b127-da7968e32873','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(636,'d918f39c-cae8-4dc6-94bd-182a0b1b1311','6f75ad05-2e01-411d-b127-da7968e32873','2026-01-21 11:50:36',NULL,'CREATE','IN_PROGRESS','test1','ResourcesList-1955174437-test1-bjqqgpgnszpo','state changed','OS::Heat::TestResource',NULL,120),(637,'b9bd65ae-3df8-41a1-83ab-6f4aa693fa62','6f75ad05-2e01-411d-b127-da7968e32873','2026-01-21 11:50:36',NULL,'CREATE','COMPLETE','test1','ResourcesList-1955174437-test1-bjqqgpgnszpo','state changed','OS::Heat::TestResource',NULL,120),(638,'2086b0c2-b13e-4b75-9708-7a7e507c8237','6f75ad05-2e01-411d-b127-da7968e32873','2026-01-21 11:50:36',NULL,'CREATE','IN_PROGRESS','test2','ResourcesList-1955174437-test2-bplv7wuht7gy','state changed','OS::Heat::TestResource',NULL,121),(639,'12baeda3-e634-41c8-8203-ece41bf84d46','6f75ad05-2e01-411d-b127-da7968e32873','2026-01-21 11:50:36',NULL,'CREATE','COMPLETE','test2','ResourcesList-1955174437-test2-bplv7wuht7gy','state changed','OS::Heat::TestResource',NULL,121),(640,'fd309654-484d-41f0-973e-15c3521abf9d','6f75ad05-2e01-411d-b127-da7968e32873','2026-01-21 11:50:36',NULL,'CREATE','COMPLETE','ResourcesList-1955174437','6f75ad05-2e01-411d-b127-da7968e32873','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(641,'4c10c4f0-7df1-4200-86d4-ddfc92ea10d1','6f75ad05-2e01-411d-b127-da7968e32873','2026-01-21 11:50:37',NULL,'DELETE','IN_PROGRESS','ResourcesList-1955174437','6f75ad05-2e01-411d-b127-da7968e32873','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(642,'83518955-8a88-4ec1-8ca5-ea3c5445e8ae','6f75ad05-2e01-411d-b127-da7968e32873','2026-01-21 11:50:37',NULL,'DELETE','IN_PROGRESS','test2','ResourcesList-1955174437-test2-bplv7wuht7gy','state changed','OS::Heat::TestResource',NULL,121),(643,'a5fe29a5-304e-420b-9dd1-1c29481fbd39','6f75ad05-2e01-411d-b127-da7968e32873','2026-01-21 11:50:37',NULL,'DELETE','COMPLETE','test2','ResourcesList-1955174437-test2-bplv7wuht7gy','state changed','OS::Heat::TestResource',NULL,121),(644,'2b1a3ad0-1219-419c-ae49-43a038958804','6f75ad05-2e01-411d-b127-da7968e32873','2026-01-21 11:50:37',NULL,'DELETE','IN_PROGRESS','test1','ResourcesList-1955174437-test1-bjqqgpgnszpo','state changed','OS::Heat::TestResource',NULL,120),(645,'aabe7844-77d7-4232-b77b-0096f2469ed1','6f75ad05-2e01-411d-b127-da7968e32873','2026-01-21 11:50:37',NULL,'DELETE','COMPLETE','test1','ResourcesList-1955174437-test1-bjqqgpgnszpo','state changed','OS::Heat::TestResource',NULL,120),(646,'40e34bf8-96df-40e4-bf0f-a40158857d90','6f75ad05-2e01-411d-b127-da7968e32873','2026-01-21 11:50:37',NULL,'DELETE','COMPLETE','ResourcesList-1955174437','6f75ad05-2e01-411d-b127-da7968e32873','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(647,'bd26b150-c233-47c7-8b51-e3fc6ed7fc35','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:37',NULL,'UPDATE','IN_PROGRESS','trunk','d6c718b9-c505-4bae-9c86-0740b3fceceb','state changed','OS::Neutron::Trunk',NULL,115),(648,'8d3e8e78-a059-45e1-9232-2f27cc85e3b5','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','2026-01-21 11:50:37',NULL,'DELETE','COMPLETE','server','3cbefdca-2564-4dda-bd4e-1b3999a27019','state changed','OS::Nova::Server',NULL,118),(649,'66af1e1c-ab4a-4e9f-a1f3-396cff7c0dce','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','2026-01-21 11:50:38',NULL,'DELETE','IN_PROGRESS','subnet_a','b79eb021-355d-4986-9de8-116394afc2da','state changed','OS::Neutron::Subnet',NULL,91),(650,'997ed4c0-2488-4b06-b22e-061f5b3b288d','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','2026-01-21 11:50:38',NULL,'DELETE','IN_PROGRESS','subnet_b','cd713b2a-e247-494a-ba6d-958d3a88f862','state changed','OS::Neutron::Subnet',NULL,90),(651,'9725797d-0d0d-490a-a17b-1f0b8ed02031','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','2026-01-21 11:50:38',NULL,'DELETE','COMPLETE','subnet_b','cd713b2a-e247-494a-ba6d-958d3a88f862','state changed','OS::Neutron::Subnet',NULL,90),(652,'cde67588-ec76-4224-8862-017e7f336839','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','2026-01-21 11:50:38',NULL,'DELETE','COMPLETE','subnet_a','b79eb021-355d-4986-9de8-116394afc2da','state changed','OS::Neutron::Subnet',NULL,91),(653,'d264741c-a67a-4409-9452-004ee32bff33','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','2026-01-21 11:50:38',NULL,'DELETE','IN_PROGRESS','net','e066e7ad-4955-4f17-9b45-284183d092e8','state changed','OS::Neutron::Net',NULL,87),(654,'c80f2a69-967b-481b-9615-5510408f7502','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:38',NULL,'UPDATE','COMPLETE','trunk','d6c718b9-c505-4bae-9c86-0740b3fceceb','state changed','OS::Neutron::Trunk',NULL,122),(655,'ef719d96-2e3f-4f3e-b2de-1277bc23e59b','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:38',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-1549168250','5d7eda9e-81f7-4021-beda-f9db9e7058a7','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(656,'25fce708-e343-4d8e-8c07-e57f27d9e4e4','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','2026-01-21 11:50:38',NULL,'DELETE','COMPLETE','net','e066e7ad-4955-4f17-9b45-284183d092e8','state changed','OS::Neutron::Net',NULL,87),(657,'c3dbe3b5-dedb-4560-ba9d-68f888616892','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','2026-01-21 11:50:38',NULL,'DELETE','COMPLETE','create_server_with_sub_ip','fcb1db83-860b-4e99-80ef-9c5e790ab2f3','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(658,'d5a852bb-985d-4fa7-9e69-d908e5a7e754','59903018-4f7f-4406-93e4-9a5df11e0c9a','2026-01-21 11:50:39',NULL,'CREATE','IN_PROGRESS','HooksTest-1354691914','59903018-4f7f-4406-93e4-9a5df11e0c9a','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(659,'b080a305-d932-439c-b33a-1e6bf54a2796','59903018-4f7f-4406-93e4-9a5df11e0c9a','2026-01-21 11:50:39',NULL,'CREATE','IN_PROGRESS','nested','HooksTest-1354691914-nested-77did4cequy6','state changed','nested.yaml',NULL,NULL),(660,'efd5b437-df79-4ada-8823-c517c4249bc8','f63d3a31-6155-4a14-a121-0cbde886688d','2026-01-21 11:50:39',NULL,'CREATE','IN_PROGRESS','HooksTest-1354691914-nested-77did4cequy6','f63d3a31-6155-4a14-a121-0cbde886688d','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(661,'417c252d-8d7b-4840-9f3b-a48687ada7ff','f63d3a31-6155-4a14-a121-0cbde886688d','2026-01-21 11:50:39',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-1354691914-nested-77did4cequy6-foo_step1-rwuwlpa5wenj','state changed','OS::Heat::RandomString',NULL,NULL),(662,'b529f0ab-ae39-4ea5-9dc4-c3e9a787b853','f63d3a31-6155-4a14-a121-0cbde886688d','2026-01-21 11:50:39',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-1354691914-nested-77did4cequy6-foo_step1-rwuwlpa5wenj','state changed','OS::Heat::RandomString',NULL,NULL),(663,'57608cde-0aa1-4280-84e0-d064bedb29e1','f63d3a31-6155-4a14-a121-0cbde886688d','2026-01-21 11:50:39',NULL,'INIT','COMPLETE','foo_step2',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(664,'076d55a8-72a1-48f3-b903-0c827052647f','99b9b78a-e606-4a1c-b7e6-a4504566e32a','2026-01-21 11:50:42',NULL,'CREATE','IN_PROGRESS','StackEventsTest-803524309','99b9b78a-e606-4a1c-b7e6-a4504566e32a','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(665,'8f14898b-b312-408d-bcb5-88375a2dbf3e','99b9b78a-e606-4a1c-b7e6-a4504566e32a','2026-01-21 11:50:42',NULL,'CREATE','IN_PROGRESS','test_resource','StackEventsTest-803524309-test_resource-s7b4dezqezcj','state changed','OS::Heat::TestResource',NULL,123),(666,'7e0cf715-4cce-45aa-a049-973893674d35','99b9b78a-e606-4a1c-b7e6-a4504566e32a','2026-01-21 11:50:42',NULL,'CREATE','COMPLETE','test_resource','StackEventsTest-803524309-test_resource-s7b4dezqezcj','state changed','OS::Heat::TestResource',NULL,123),(667,'5eac01f6-7a4a-46fd-9402-8507cc2e92a7','99b9b78a-e606-4a1c-b7e6-a4504566e32a','2026-01-21 11:50:42',NULL,'CREATE','COMPLETE','StackEventsTest-803524309','99b9b78a-e606-4a1c-b7e6-a4504566e32a','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(668,'8a3315df-0231-4236-92b9-23fe1f637ff2','60c9f6be-9f4d-41c8-ba88-fe804e066c78','2026-01-21 11:50:43',NULL,'CREATE','IN_PROGRESS','RemoteDeeplyNestedStackTest-1211336967','60c9f6be-9f4d-41c8-ba88-fe804e066c78','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(669,'fcb879ed-1d78-461f-b67b-ac61c36c3caa','60c9f6be-9f4d-41c8-ba88-fe804e066c78','2026-01-21 11:50:43',NULL,'CREATE','IN_PROGRESS','network_stack','RemoteDeeplyNestedStackTest-1211336967-network_stack-t6x4ia43xeu7','state changed','OS::Heat::Stack',NULL,125),(670,'93127687-6838-41ef-bb97-f3c73fe46e8f','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:43',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-1549168250','5d7eda9e-81f7-4021-beda-f9db9e7058a7','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(671,'e852dc41-6e20-440e-ac10-e39a8068f500','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:43',NULL,'DELETE','IN_PROGRESS','sub_port_two','d8c0ba67-fa2b-447d-82fd-96cff5af8bac','state changed','OS::Neutron::Port',NULL,113),(672,'4f417e7d-160a-4639-aa2f-9958fe581385','99b9b78a-e606-4a1c-b7e6-a4504566e32a','2026-01-21 11:50:44',NULL,'DELETE','IN_PROGRESS','StackEventsTest-803524309','99b9b78a-e606-4a1c-b7e6-a4504566e32a','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(673,'fb428a8c-3257-49a7-907e-7158cbe6e3f1','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:44',NULL,'DELETE','COMPLETE','sub_port_two','d8c0ba67-fa2b-447d-82fd-96cff5af8bac','state changed','OS::Neutron::Port',NULL,113),(674,'c72b1a44-8acc-45b3-85ec-1cc6684d0fc4','92ea70b7-aaa0-4c63-b2ed-116941755760','2026-01-21 11:50:44',NULL,'CREATE','IN_PROGRESS','RemoteDeeplyNestedStackTest-1211336967-network_stack-t6x4ia43xeu7','92ea70b7-aaa0-4c63-b2ed-116941755760','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(675,'86c6421f-c23e-4c41-8ebb-652f298f9b83','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:44',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','8cdf4a2d-b787-4235-acff-da81f2437dd8','state changed','OS::Neutron::Subnet',NULL,110),(676,'8e6b20f2-cf5b-4088-b5f1-a7e5113a06c3','99b9b78a-e606-4a1c-b7e6-a4504566e32a','2026-01-21 11:50:44',NULL,'DELETE','IN_PROGRESS','test_resource','StackEventsTest-803524309-test_resource-s7b4dezqezcj','state changed','OS::Heat::TestResource',NULL,123),(677,'d97cf6d5-5c77-455e-962f-71064653f1ab','92ea70b7-aaa0-4c63-b2ed-116941755760','2026-01-21 11:50:44',NULL,'CREATE','IN_PROGRESS','network_stack_as_custom_type','RemoteDeeplyNestedStackTest-1211336967-network_stack-t6x4ia43xeu7-network_stack_as_custom_type-cojyn4b3zxfb','state changed','file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml',NULL,126),(678,'939b3a61-fe3d-427d-8801-43fc6d5996b9','99b9b78a-e606-4a1c-b7e6-a4504566e32a','2026-01-21 11:50:44',NULL,'DELETE','COMPLETE','test_resource','StackEventsTest-803524309-test_resource-s7b4dezqezcj','state changed','OS::Heat::TestResource',NULL,123),(679,'6b20db1c-3d21-4d21-b3f9-6271f550182e','99b9b78a-e606-4a1c-b7e6-a4504566e32a','2026-01-21 11:50:44',NULL,'DELETE','COMPLETE','StackEventsTest-803524309','99b9b78a-e606-4a1c-b7e6-a4504566e32a','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(680,'8645788e-d59e-4a9e-8033-144c192dd770','51c122a5-cd4c-47b0-acd5-17a455f5297b','2026-01-21 11:50:44',NULL,'CREATE','IN_PROGRESS','RemoteDeeplyNestedStackTest-1211336967-network_stack-t6x4ia43xeu7-network_stack_as_custom_type-cojyn4b3zxfb','51c122a5-cd4c-47b0-acd5-17a455f5297b','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(681,'e2d1772b-9805-4bff-b11c-263bfaea35ce','51c122a5-cd4c-47b0-acd5-17a455f5297b','2026-01-21 11:50:44',NULL,'CREATE','IN_PROGRESS','router','RemoteDeeplyNestedStackTest-1211336967-network_stack-t6x4ia43xeu7-network_stack_as_custom_type-cojyn4b3zxfb-router-6f4b3lalga27','state changed','OS::Neutron::Router',NULL,127),(682,'539d3f4f-5087-4bb5-b062-633a6a00a036','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:44',NULL,'DELETE','COMPLETE','trunk_subnet_two','8cdf4a2d-b787-4235-acff-da81f2437dd8','state changed','OS::Neutron::Subnet',NULL,110),(683,'07ff9c1b-0c9a-4a26-9bd4-28f9c09bd7b1','f63d3a31-6155-4a14-a121-0cbde886688d','2026-01-21 11:50:44',NULL,'INIT','COMPLETE','foo_step2',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(684,'5da7008b-156a-422b-a64e-f12568942c8a','f63d3a31-6155-4a14-a121-0cbde886688d','2026-01-21 11:50:44',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-1354691914-nested-77did4cequy6-foo_step2-3pcuvwwlprhq','state changed','OS::Heat::RandomString',NULL,NULL),(685,'1b408bf5-db92-4f46-bf12-5f091628050b','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:44',NULL,'DELETE','IN_PROGRESS','trunk_net_two','08cfb3a7-9284-44e8-910c-6af21dc8688b','state changed','OS::Neutron::Net',NULL,NULL),(686,'40e4e3df-934a-4697-9cec-ad0e6964ceac','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:44',NULL,'DELETE','IN_PROGRESS','trunk','d6c718b9-c505-4bae-9c86-0740b3fceceb','state changed','OS::Neutron::Trunk',NULL,122),(687,'20b182c7-2329-4d63-bffe-84946942365d','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:45',NULL,'DELETE','COMPLETE','trunk','d6c718b9-c505-4bae-9c86-0740b3fceceb','state changed','OS::Neutron::Trunk',NULL,122),(688,'1d0dea3a-4909-43b6-a4f2-0460dbdcb901','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:45',NULL,'DELETE','IN_PROGRESS','parent_port','6b83d18a-296c-4b99-b632-eadf14e0c431','state changed','OS::Neutron::Port',NULL,114),(689,'799e8e11-364a-44c1-9fea-3f66037d9ca7','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:45',NULL,'DELETE','IN_PROGRESS','sub_port_one','e306ac42-012f-44ae-94ef-38ca25e2d340','state changed','OS::Neutron::Port',NULL,111),(690,'9f318b58-52ed-4591-8917-949968ad9520','f63d3a31-6155-4a14-a121-0cbde886688d','2026-01-21 11:50:45',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1354691914-nested-77did4cequy6-foo_step2-3pcuvwwlprhq','state changed','OS::Heat::RandomString',NULL,NULL),(691,'dfa7ee76-508d-4114-8310-2befe3f66c8d','f63d3a31-6155-4a14-a121-0cbde886688d','2026-01-21 11:50:45',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-1354691914-nested-77did4cequy6-foo_step3-fo2hpzfz2jup','state changed','OS::Heat::RandomString',NULL,NULL),(692,'e65030b0-9a81-404e-a25d-f9cc8fb570ae','f63d3a31-6155-4a14-a121-0cbde886688d','2026-01-21 11:50:45',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-1354691914-nested-77did4cequy6-foo_step3-fo2hpzfz2jup','state changed','OS::Heat::RandomString',NULL,NULL),(693,'ab161f36-73cc-4973-a589-34d845556e95','f63d3a31-6155-4a14-a121-0cbde886688d','2026-01-21 11:50:45',NULL,'CREATE','COMPLETE','HooksTest-1354691914-nested-77did4cequy6','f63d3a31-6155-4a14-a121-0cbde886688d','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(694,'8b37dbfb-cddf-4f65-b2da-11c86ed506ff','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:46',NULL,'DELETE','COMPLETE','trunk_net_two','08cfb3a7-9284-44e8-910c-6af21dc8688b','state changed','OS::Neutron::Net',NULL,NULL),(695,'ff77f170-b5f2-4b1e-a055-38fb5e46f530','59903018-4f7f-4406-93e4-9a5df11e0c9a','2026-01-21 11:50:46',NULL,'CREATE','COMPLETE','nested','f63d3a31-6155-4a14-a121-0cbde886688d','state changed','nested.yaml',NULL,NULL),(696,'011e1dfa-1e49-49f7-a273-0704dbc3d946','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:46',NULL,'DELETE','COMPLETE','parent_port','6b83d18a-296c-4b99-b632-eadf14e0c431','state changed','OS::Neutron::Port',NULL,114),(697,'06ba372a-bb4f-4e45-ad6d-753c4a08e840','59903018-4f7f-4406-93e4-9a5df11e0c9a','2026-01-21 11:50:46',NULL,'CREATE','COMPLETE','HooksTest-1354691914','59903018-4f7f-4406-93e4-9a5df11e0c9a','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(698,'b632b83f-4187-40ab-bc36-662e8f41a0d6','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:46',NULL,'DELETE','COMPLETE','sub_port_one','e306ac42-012f-44ae-94ef-38ca25e2d340','state changed','OS::Neutron::Port',NULL,111),(699,'a2ebf28a-1d16-40ae-9bfd-24bbe0265bd7','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:46',NULL,'DELETE','IN_PROGRESS','parent_subnet','7b253ec9-723f-46ae-9b19-3d8429b2ae45','state changed','OS::Neutron::Subnet',NULL,112),(700,'199f5045-2094-48d9-8f2b-0be4568eec51','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:46',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','c2f48c67-e762-4621-885d-8cc61dd10835','state changed','OS::Neutron::Subnet',NULL,109),(701,'b8ad8618-287c-48c1-82d7-4ce02a17e359','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:47',NULL,'DELETE','COMPLETE','trunk_subnet_one','c2f48c67-e762-4621-885d-8cc61dd10835','state changed','OS::Neutron::Subnet',NULL,109),(702,'d8483a36-218d-470f-bce0-24df53d1d90d','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:47',NULL,'DELETE','IN_PROGRESS','trunk_net_one','86bba8eb-3413-4f62-9fe6-ff848cbc20ed','state changed','OS::Neutron::Net',NULL,NULL),(703,'eefa7cf4-8637-44d0-aa1d-9b1f95adce89','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:47',NULL,'DELETE','COMPLETE','parent_subnet','7b253ec9-723f-46ae-9b19-3d8429b2ae45','state changed','OS::Neutron::Subnet',NULL,112),(704,'22c69b02-decd-4ce7-882c-db74283a9ad8','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:47',NULL,'DELETE','IN_PROGRESS','parent_net','aff2b0f4-9b44-42a0-816d-fccd7afbf024','state changed','OS::Neutron::Net',NULL,NULL),(705,'e39cadfa-d9d4-4739-a812-eb85bd8736b4','51c122a5-cd4c-47b0-acd5-17a455f5297b','2026-01-21 11:50:47',NULL,'CREATE','COMPLETE','router','83e41f34-c4d2-44f6-af6f-01e68c2fa58b','state changed','OS::Neutron::Router',NULL,127),(706,'36e4de4a-0168-47e7-83c2-efc87ab07158','51c122a5-cd4c-47b0-acd5-17a455f5297b','2026-01-21 11:50:47',NULL,'CREATE','COMPLETE','RemoteDeeplyNestedStackTest-1211336967-network_stack-t6x4ia43xeu7-network_stack_as_custom_type-cojyn4b3zxfb','51c122a5-cd4c-47b0-acd5-17a455f5297b','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(707,'49f7d201-e4c2-46c3-bc2c-2a8a587c9e40','92ea70b7-aaa0-4c63-b2ed-116941755760','2026-01-21 11:50:47',NULL,'CREATE','COMPLETE','network_stack_as_custom_type','51c122a5-cd4c-47b0-acd5-17a455f5297b','state changed','file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml',NULL,126),(708,'bb9440df-6cda-49d6-a6e6-9d7d08f537ff','92ea70b7-aaa0-4c63-b2ed-116941755760','2026-01-21 11:50:47',NULL,'CREATE','COMPLETE','RemoteDeeplyNestedStackTest-1211336967-network_stack-t6x4ia43xeu7','92ea70b7-aaa0-4c63-b2ed-116941755760','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(709,'3585a7ea-ea02-4094-8354-232830ecf4e6','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:47',NULL,'DELETE','COMPLETE','trunk_net_one','86bba8eb-3413-4f62-9fe6-ff848cbc20ed','state changed','OS::Neutron::Net',NULL,NULL),(710,'c9c29faf-2ce3-4a52-ba95-ae379307e3d1','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:47',NULL,'DELETE','COMPLETE','parent_net','aff2b0f4-9b44-42a0-816d-fccd7afbf024','state changed','OS::Neutron::Net',NULL,NULL),(711,'c8684347-2693-4fe9-a37a-479f9cb80819','5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:47',NULL,'DELETE','COMPLETE','UpdateTrunkTest-1549168250','5d7eda9e-81f7-4021-beda-f9db9e7058a7','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(712,'5e16e9c8-0fee-4af1-a420-a3fc5c791114','60c9f6be-9f4d-41c8-ba88-fe804e066c78','2026-01-21 11:50:48',NULL,'CREATE','COMPLETE','network_stack','92ea70b7-aaa0-4c63-b2ed-116941755760','state changed','OS::Heat::Stack',NULL,125),(713,'cea783e6-166c-4e7e-b341-f950fef5e796','60c9f6be-9f4d-41c8-ba88-fe804e066c78','2026-01-21 11:50:48',NULL,'CREATE','COMPLETE','RemoteDeeplyNestedStackTest-1211336967','60c9f6be-9f4d-41c8-ba88-fe804e066c78','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(714,'d0ccffeb-bc38-4039-b1d2-18e8e57d8c38','59903018-4f7f-4406-93e4-9a5df11e0c9a','2026-01-21 11:50:50',NULL,'DELETE','IN_PROGRESS','HooksTest-1354691914','59903018-4f7f-4406-93e4-9a5df11e0c9a','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(715,'e26f76c6-fe42-430f-b589-fcc6754107fd','59903018-4f7f-4406-93e4-9a5df11e0c9a','2026-01-21 11:50:50',NULL,'DELETE','IN_PROGRESS','nested','f63d3a31-6155-4a14-a121-0cbde886688d','state changed','nested.yaml',NULL,NULL),(716,'870724c0-5f4e-4866-856d-328ee0348b7e','f63d3a31-6155-4a14-a121-0cbde886688d','2026-01-21 11:50:50',NULL,'DELETE','IN_PROGRESS','HooksTest-1354691914-nested-77did4cequy6','f63d3a31-6155-4a14-a121-0cbde886688d','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(717,'207e0fbc-e91f-46af-a50d-b3d8ffc02e6d','f63d3a31-6155-4a14-a121-0cbde886688d','2026-01-21 11:50:50',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-1354691914-nested-77did4cequy6-foo_step3-fo2hpzfz2jup','state changed','OS::Heat::RandomString',NULL,NULL),(718,'85bfb02e-3efa-4497-a3e2-ba0b62c21201','f63d3a31-6155-4a14-a121-0cbde886688d','2026-01-21 11:50:50',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-1354691914-nested-77did4cequy6-foo_step3-fo2hpzfz2jup','state changed','OS::Heat::RandomString',NULL,NULL),(719,'16f52e8f-6411-48e1-a5e9-62cb365d3df0','f63d3a31-6155-4a14-a121-0cbde886688d','2026-01-21 11:50:50',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-1354691914-nested-77did4cequy6-foo_step2-3pcuvwwlprhq','state changed','OS::Heat::RandomString',NULL,NULL),(720,'82065fee-de11-4b7b-9324-a5d8ff6b6c93','f63d3a31-6155-4a14-a121-0cbde886688d','2026-01-21 11:50:50',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-1354691914-nested-77did4cequy6-foo_step2-3pcuvwwlprhq','state changed','OS::Heat::RandomString',NULL,NULL),(721,'dce3c7a9-929f-4ef2-9d6d-bf8bfa83f0d2','f63d3a31-6155-4a14-a121-0cbde886688d','2026-01-21 11:50:50',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-1354691914-nested-77did4cequy6-foo_step1-rwuwlpa5wenj','state changed','OS::Heat::RandomString',NULL,NULL),(722,'0bb97454-35a9-4c63-9e28-79c530ac361a','f63d3a31-6155-4a14-a121-0cbde886688d','2026-01-21 11:50:50',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-1354691914-nested-77did4cequy6-foo_step1-rwuwlpa5wenj','state changed','OS::Heat::RandomString',NULL,NULL),(723,'44b574be-9bbf-42bc-a182-78c788b24f1c','f63d3a31-6155-4a14-a121-0cbde886688d','2026-01-21 11:50:50',NULL,'DELETE','COMPLETE','HooksTest-1354691914-nested-77did4cequy6','f63d3a31-6155-4a14-a121-0cbde886688d','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(724,'ee2bd24a-f310-480c-a498-570ff1657332','59903018-4f7f-4406-93e4-9a5df11e0c9a','2026-01-21 11:50:51',NULL,'DELETE','COMPLETE','nested','f63d3a31-6155-4a14-a121-0cbde886688d','state changed','nested.yaml',NULL,NULL),(725,'697a6175-37b6-466e-a282-69e787bd907e','59903018-4f7f-4406-93e4-9a5df11e0c9a','2026-01-21 11:50:51',NULL,'DELETE','COMPLETE','HooksTest-1354691914','59903018-4f7f-4406-93e4-9a5df11e0c9a','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(726,'cd5fbdc8-0b52-4de8-ab29-d9ddcda78a3c','60c9f6be-9f4d-41c8-ba88-fe804e066c78','2026-01-21 11:50:51',NULL,'DELETE','IN_PROGRESS','RemoteDeeplyNestedStackTest-1211336967','60c9f6be-9f4d-41c8-ba88-fe804e066c78','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(727,'f10c4801-1772-4e20-9ea2-c083f9ece271','60c9f6be-9f4d-41c8-ba88-fe804e066c78','2026-01-21 11:50:51',NULL,'DELETE','IN_PROGRESS','network_stack','92ea70b7-aaa0-4c63-b2ed-116941755760','state changed','OS::Heat::Stack',NULL,125),(728,'5cfe2df2-4f9c-4867-8365-1f5a5e73536d','92ea70b7-aaa0-4c63-b2ed-116941755760','2026-01-21 11:50:52',NULL,'DELETE','IN_PROGRESS','RemoteDeeplyNestedStackTest-1211336967-network_stack-t6x4ia43xeu7','92ea70b7-aaa0-4c63-b2ed-116941755760','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(729,'ac9c655b-db59-41ca-99a4-b4ac189bdedd','92ea70b7-aaa0-4c63-b2ed-116941755760','2026-01-21 11:50:52',NULL,'DELETE','IN_PROGRESS','network_stack_as_custom_type','51c122a5-cd4c-47b0-acd5-17a455f5297b','state changed','file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml',NULL,126),(730,'ecbe4cec-c9d1-4ce0-b1de-4daf29b8ea40','51c122a5-cd4c-47b0-acd5-17a455f5297b','2026-01-21 11:50:52',NULL,'DELETE','IN_PROGRESS','RemoteDeeplyNestedStackTest-1211336967-network_stack-t6x4ia43xeu7-network_stack_as_custom_type-cojyn4b3zxfb','51c122a5-cd4c-47b0-acd5-17a455f5297b','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(731,'5877a78a-b0c9-4717-8afd-67ed54b4dbc6','51c122a5-cd4c-47b0-acd5-17a455f5297b','2026-01-21 11:50:52',NULL,'DELETE','IN_PROGRESS','router','83e41f34-c4d2-44f6-af6f-01e68c2fa58b','state changed','OS::Neutron::Router',NULL,127),(732,'c7c3a1dd-d23b-4a72-b16e-33e2a9f6e540','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:50:52',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-1824116201','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(733,'80f34509-21cc-4410-9b19-b4aff48d92a9','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:50:52',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-1824116201-parent_net-mie2ynxf3ext','state changed','OS::Neutron::Net',NULL,NULL),(734,'058b4939-8546-4f8e-b076-883b982e4df2','51c122a5-cd4c-47b0-acd5-17a455f5297b','2026-01-21 11:50:53',NULL,'DELETE','COMPLETE','router','83e41f34-c4d2-44f6-af6f-01e68c2fa58b','state changed','OS::Neutron::Router',NULL,127),(735,'a3e602d2-1a33-4190-918c-34845e0772b4','51c122a5-cd4c-47b0-acd5-17a455f5297b','2026-01-21 11:50:53',NULL,'DELETE','COMPLETE','RemoteDeeplyNestedStackTest-1211336967-network_stack-t6x4ia43xeu7-network_stack_as_custom_type-cojyn4b3zxfb','51c122a5-cd4c-47b0-acd5-17a455f5297b','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(736,'ac9d2d10-3f54-4f0c-a778-1536b2d2be40','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:50:53',NULL,'CREATE','COMPLETE','parent_net','73d9de56-8c2f-49f2-a863-0c6f78cc6595','state changed','OS::Neutron::Net',NULL,NULL),(737,'8d80f13e-b1ec-4d54-a13d-f03daea3e606','92ea70b7-aaa0-4c63-b2ed-116941755760','2026-01-21 11:50:53',NULL,'DELETE','COMPLETE','network_stack_as_custom_type','51c122a5-cd4c-47b0-acd5-17a455f5297b','state changed','file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml',NULL,126),(738,'cb943c12-00ae-4d0c-9206-516d5c5ce927','92ea70b7-aaa0-4c63-b2ed-116941755760','2026-01-21 11:50:53',NULL,'DELETE','COMPLETE','RemoteDeeplyNestedStackTest-1211336967-network_stack-t6x4ia43xeu7','92ea70b7-aaa0-4c63-b2ed-116941755760','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(739,'93e97325-cbd8-4400-bf53-17b56cea5f2b','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:50:53',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-1824116201-parent_subnet-hjhe3vmuzqhg','state changed','OS::Neutron::Subnet',NULL,130),(740,'f1419780-d342-4c37-a0fb-7d56e553594d','60c9f6be-9f4d-41c8-ba88-fe804e066c78','2026-01-21 11:50:53',NULL,'DELETE','COMPLETE','network_stack','92ea70b7-aaa0-4c63-b2ed-116941755760','state changed','OS::Heat::Stack',NULL,125),(741,'c9722aac-6a91-4d7d-90ae-27a43e5be15c','60c9f6be-9f4d-41c8-ba88-fe804e066c78','2026-01-21 11:50:53',NULL,'DELETE','COMPLETE','RemoteDeeplyNestedStackTest-1211336967','60c9f6be-9f4d-41c8-ba88-fe804e066c78','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(742,'ddc31647-8521-4a0d-a77a-4435fd79f96c','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:50:53',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-1824116201-trunk_net_one-k4yx747zxpfa','state changed','OS::Neutron::Net',NULL,NULL),(743,'2f232990-739e-41cf-a8fd-a6ae1e975fac','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:50:54',NULL,'CREATE','COMPLETE','parent_subnet','631a2d5d-3c10-4550-80f0-14e74aa21044','state changed','OS::Neutron::Subnet',NULL,130),(744,'44e34347-5194-49ce-bf9e-2d842f289ea3','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:50:54',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-1824116201-parent_port-n5erens7xr5t','state changed','OS::Neutron::Port',NULL,131),(745,'0310be47-d4d5-4a2d-a627-df05951632fe','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:50:54',NULL,'CREATE','COMPLETE','trunk_net_one','35639def-2c90-479e-8355-34646781670e','state changed','OS::Neutron::Net',NULL,NULL),(746,'60944027-cb5f-498c-a1e8-1dcd35d23602','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:50:54',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-1824116201-trunk_subnet_one-cxwhx4hnkm27','state changed','OS::Neutron::Subnet',NULL,132),(747,'571518db-18b2-493f-bb69-34e4a4524ce6','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:50:54',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-1824116201-trunk_net_two-7owhthz7my3g','state changed','OS::Neutron::Net',NULL,NULL),(748,'5eb40f95-d168-4349-9b1a-01ebb5dcbeb9','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:50:55',NULL,'CREATE','COMPLETE','parent_port','744a0c95-6054-4c24-b6a3-a4cb3b9ade78','state changed','OS::Neutron::Port',NULL,131),(749,'33c324d7-81c6-4a7e-ad05-1ca0534e1309','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:50:55',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-1824116201-trunk-7pclfejofhug','state changed','OS::Neutron::Trunk',NULL,133),(750,'1913b835-361a-416a-85c0-8aa75a50bc59','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:50:55',NULL,'CREATE','COMPLETE','trunk_net_two','d909d83b-be53-4dc4-99de-7acc7ff7c4f5','state changed','OS::Neutron::Net',NULL,NULL),(751,'acc879b3-f9af-451c-8e3a-1ee370a43533','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:50:55',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-1824116201-trunk_subnet_two-3jezzsjqqzhs','state changed','OS::Neutron::Subnet',NULL,134),(752,'1eb030a9-a6bc-43a4-b74c-50559e251f38','5e0b5b52-dabc-41c9-9124-d353e5de592b','2026-01-21 11:50:55',NULL,'CREATE','IN_PROGRESS','HooksTest-29776859','5e0b5b52-dabc-41c9-9124-d353e5de592b','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(753,'9dab2590-3a0e-4b47-b8ee-ff6ab7804b37','5e0b5b52-dabc-41c9-9124-d353e5de592b','2026-01-21 11:50:55',NULL,'INIT','COMPLETE','foo_step1',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(754,'f303efc5-b785-4766-9070-b68538a017da','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:50:55',NULL,'CREATE','COMPLETE','trunk_subnet_one','02f2dbf6-2f53-401a-bdcd-c264b82c76fe','state changed','OS::Neutron::Subnet',NULL,132),(755,'6cb614ac-afe2-49f8-bbd2-6774f9127108','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:50:55',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-1824116201-sub_port_one-h3w7z4qia2jt','state changed','OS::Neutron::Port',NULL,135),(756,'4820ea16-3566-4049-abdd-5f80678aca1f','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:50:55',NULL,'CREATE','COMPLETE','trunk','56d4b8ca-c241-498c-bfeb-d55df9b4b6e5','state changed','OS::Neutron::Trunk',NULL,133),(757,'4e87f2de-b5ac-45af-9aa2-980d4ce05453','5e0b5b52-dabc-41c9-9124-d353e5de592b','2026-01-21 11:50:56',NULL,'INIT','COMPLETE','foo_step1',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(758,'31fd5f1d-f65e-4b60-b94b-8ce88345ea57','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:50:56',NULL,'CREATE','COMPLETE','trunk_subnet_two','f09baa94-a3e0-425a-8f44-8dc6538d9195','state changed','OS::Neutron::Subnet',NULL,134),(759,'b6701aac-9322-42d5-bb3e-555290c5995d','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:50:56',NULL,'CREATE','COMPLETE','sub_port_one','1fb7fafd-5f29-44d0-9b45-5cf23efac7e1','state changed','OS::Neutron::Port',NULL,135),(760,'5ecd96bc-d56e-4f66-af28-498abd53cb9b','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:50:56',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-1824116201-sub_port_two-pjejm27yv4xe','state changed','OS::Neutron::Port',NULL,136),(761,'822cca59-a88f-4a92-9782-10e53489ba94','5e0b5b52-dabc-41c9-9124-d353e5de592b','2026-01-21 11:50:56',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-29776859-foo_step1-qbr3qhj6za7o','state changed','OS::Heat::RandomString',NULL,NULL),(762,'2a49113c-7a7e-48bd-80c4-1ff8d0d14ec9','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:50:57',NULL,'CREATE','COMPLETE','sub_port_two','f649152e-2982-481f-8939-7d075e9a1c14','state changed','OS::Neutron::Port',NULL,136),(763,'47836ad2-a85f-481a-9bf0-092a90fd8537','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:50:57',NULL,'CREATE','COMPLETE','UpdateTrunkTest-1824116201','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(764,'4ad9b304-6cd8-40cd-b6d3-7b0f5599e922','5e0b5b52-dabc-41c9-9124-d353e5de592b','2026-01-21 11:50:57',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-29776859-foo_step1-qbr3qhj6za7o','state changed','OS::Heat::RandomString',NULL,NULL),(765,'c0d5fc80-7082-4c58-b488-c8c5977c54fa','5e0b5b52-dabc-41c9-9124-d353e5de592b','2026-01-21 11:50:57',NULL,'INIT','COMPLETE','foo_step2',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(766,'d2b3ce01-ce36-4c11-8845-c19246fb1021','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:51:05',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-1824116201','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(767,'cd445f28-7ed4-4b10-8a94-60eded19cc96','5e0b5b52-dabc-41c9-9124-d353e5de592b','2026-01-21 11:51:06',NULL,'INIT','COMPLETE','foo_step2',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(768,'28cec2b9-ffea-4808-9cc9-93e0d2b2d57b','5e0b5b52-dabc-41c9-9124-d353e5de592b','2026-01-21 11:51:06',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-29776859-foo_step2-en6frwnkgyjb','state changed','OS::Heat::RandomString',NULL,NULL),(769,'c7e503c4-94c2-45e2-a384-df640ca9d126','5e0b5b52-dabc-41c9-9124-d353e5de592b','2026-01-21 11:51:07',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-29776859-foo_step2-en6frwnkgyjb','state changed','OS::Heat::RandomString',NULL,NULL),(770,'398de14f-ff46-443b-90d0-96d95fa49d73','5e0b5b52-dabc-41c9-9124-d353e5de592b','2026-01-21 11:51:07',NULL,'INIT','COMPLETE','foo_step3',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(771,'1fd1a47b-a409-49e8-9bdd-0cd2413ff2cf','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:51:08',NULL,'UPDATE','IN_PROGRESS','trunk','56d4b8ca-c241-498c-bfeb-d55df9b4b6e5','state changed','OS::Neutron::Trunk',NULL,133),(772,'50458580-f3ba-480c-a9d9-c19681590837','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:51:09',NULL,'UPDATE','COMPLETE','trunk','56d4b8ca-c241-498c-bfeb-d55df9b4b6e5','state changed','OS::Neutron::Trunk',NULL,137),(773,'5a3f61f1-d04c-4e09-9d1c-4788428e05ed','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:51:09',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-1824116201','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(774,'ca99fd36-e44d-4150-844a-4237f529a216','5e0b5b52-dabc-41c9-9124-d353e5de592b','2026-01-21 11:51:10',NULL,'INIT','COMPLETE','foo_step3',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(775,'16dc7347-b519-49f5-91d3-5dcb54b5135f','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:51:10',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-1824116201','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(776,'a9555ab5-9986-4d88-a4dd-209dd290d7c8','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:51:10',NULL,'DELETE','IN_PROGRESS','sub_port_two','f649152e-2982-481f-8939-7d075e9a1c14','state changed','OS::Neutron::Port',NULL,136),(777,'7c023aa6-3f65-4a9f-93fd-d7cbf4530227','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:51:11',NULL,'DELETE','COMPLETE','sub_port_two','f649152e-2982-481f-8939-7d075e9a1c14','state changed','OS::Neutron::Port',NULL,136),(778,'50fd3e90-80f3-4be1-b741-537875eb310d','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:51:11',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','f09baa94-a3e0-425a-8f44-8dc6538d9195','state changed','OS::Neutron::Subnet',NULL,134),(779,'f337fd80-afa1-4cdb-9f28-53c9bf56665a','5e0b5b52-dabc-41c9-9124-d353e5de592b','2026-01-21 11:51:11',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-29776859-foo_step3-k6vjigkqgpvw','state changed','OS::Heat::RandomString',NULL,NULL),(780,'cbf18518-7b92-40ec-b327-a8d78b9bea89','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:51:11',NULL,'DELETE','COMPLETE','trunk_subnet_two','f09baa94-a3e0-425a-8f44-8dc6538d9195','state changed','OS::Neutron::Subnet',NULL,134),(781,'6c2cf510-aa9b-4732-8c66-d67967cfc88e','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:51:11',NULL,'DELETE','IN_PROGRESS','trunk_net_two','d909d83b-be53-4dc4-99de-7acc7ff7c4f5','state changed','OS::Neutron::Net',NULL,NULL),(782,'507c04a4-fcfb-4a9b-aa64-6cba5a41ae4b','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:51:11',NULL,'DELETE','IN_PROGRESS','sub_port_one','1fb7fafd-5f29-44d0-9b45-5cf23efac7e1','state changed','OS::Neutron::Port',NULL,135),(783,'aeb781ed-562d-4098-a694-c703f0ea7e96','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:51:11',NULL,'DELETE','COMPLETE','trunk_net_two','d909d83b-be53-4dc4-99de-7acc7ff7c4f5','state changed','OS::Neutron::Net',NULL,NULL),(784,'71bcffba-d87b-4726-96da-b03fc45f6f9d','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:51:12',NULL,'DELETE','COMPLETE','sub_port_one','1fb7fafd-5f29-44d0-9b45-5cf23efac7e1','state changed','OS::Neutron::Port',NULL,135),(785,'47aec5dd-7519-44e5-8271-80e0d824e849','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:51:12',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','02f2dbf6-2f53-401a-bdcd-c264b82c76fe','state changed','OS::Neutron::Subnet',NULL,132),(786,'0448ec2e-c0c5-4136-ba07-74a983b627e3','5e0b5b52-dabc-41c9-9124-d353e5de592b','2026-01-21 11:51:12',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-29776859-foo_step3-k6vjigkqgpvw','state changed','OS::Heat::RandomString',NULL,NULL),(787,'08754c9c-343b-44cd-a8a8-50ee586f2c77','5e0b5b52-dabc-41c9-9124-d353e5de592b','2026-01-21 11:51:12',NULL,'CREATE','COMPLETE','HooksTest-29776859','5e0b5b52-dabc-41c9-9124-d353e5de592b','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(788,'bba4da53-4e04-4c52-8e08-7b26201b69e4','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:51:12',NULL,'DELETE','COMPLETE','trunk_subnet_one','02f2dbf6-2f53-401a-bdcd-c264b82c76fe','state changed','OS::Neutron::Subnet',NULL,132),(789,'de947781-119d-4df2-84da-d2733240dc6a','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:51:12',NULL,'DELETE','IN_PROGRESS','trunk_net_one','35639def-2c90-479e-8355-34646781670e','state changed','OS::Neutron::Net',NULL,NULL),(790,'1425c308-4ed0-4b36-b5c9-36025aa183cd','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:51:12',NULL,'DELETE','IN_PROGRESS','trunk','56d4b8ca-c241-498c-bfeb-d55df9b4b6e5','state changed','OS::Neutron::Trunk',NULL,137),(791,'a90d3b9f-98a7-42dd-8957-cae1855af6b0','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:51:13',NULL,'DELETE','COMPLETE','trunk_net_one','35639def-2c90-479e-8355-34646781670e','state changed','OS::Neutron::Net',NULL,NULL),(792,'a17f726f-ba4a-4f62-be5d-a34886a0fd93','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:51:13',NULL,'DELETE','COMPLETE','trunk','56d4b8ca-c241-498c-bfeb-d55df9b4b6e5','state changed','OS::Neutron::Trunk',NULL,137),(793,'a1a2565d-b709-4296-95fa-c68fb524a5d2','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:51:13',NULL,'DELETE','IN_PROGRESS','parent_port','744a0c95-6054-4c24-b6a3-a4cb3b9ade78','state changed','OS::Neutron::Port',NULL,131),(794,'0bd696b8-16c8-41bb-8867-ece7cb3f6ee8','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:51:13',NULL,'DELETE','COMPLETE','parent_port','744a0c95-6054-4c24-b6a3-a4cb3b9ade78','state changed','OS::Neutron::Port',NULL,131),(795,'1171ce7d-72b9-4fff-a6e3-6604b2fe5a33','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:51:13',NULL,'DELETE','IN_PROGRESS','parent_subnet','631a2d5d-3c10-4550-80f0-14e74aa21044','state changed','OS::Neutron::Subnet',NULL,130),(796,'07202291-e10f-4ce7-8410-652b07c6c2d7','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:51:13',NULL,'DELETE','COMPLETE','parent_subnet','631a2d5d-3c10-4550-80f0-14e74aa21044','state changed','OS::Neutron::Subnet',NULL,130),(797,'6722d2be-d825-425c-a1b1-745b3d8c58c0','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:51:13',NULL,'DELETE','IN_PROGRESS','parent_net','73d9de56-8c2f-49f2-a863-0c6f78cc6595','state changed','OS::Neutron::Net',NULL,NULL),(798,'02890301-f596-4823-b6fb-8fea157fbbdd','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:51:14',NULL,'DELETE','COMPLETE','parent_net','73d9de56-8c2f-49f2-a863-0c6f78cc6595','state changed','OS::Neutron::Net',NULL,NULL),(799,'38d4c78c-8b85-468b-9332-eab4fa8b1ca2','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:51:14',NULL,'DELETE','COMPLETE','UpdateTrunkTest-1824116201','d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(800,'e18b413f-ed53-4d57-aad3-2b5f4734b34b','5e0b5b52-dabc-41c9-9124-d353e5de592b','2026-01-21 11:51:16',NULL,'DELETE','IN_PROGRESS','HooksTest-29776859','5e0b5b52-dabc-41c9-9124-d353e5de592b','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(801,'71576954-298c-4ce6-91a6-e737eb7c8b1b','5e0b5b52-dabc-41c9-9124-d353e5de592b','2026-01-21 11:51:16',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-29776859-foo_step3-k6vjigkqgpvw','state changed','OS::Heat::RandomString',NULL,NULL),(802,'d9f6e310-b012-41c3-8d88-f0ddf51ba898','5e0b5b52-dabc-41c9-9124-d353e5de592b','2026-01-21 11:51:16',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-29776859-foo_step3-k6vjigkqgpvw','state changed','OS::Heat::RandomString',NULL,NULL),(803,'80af8494-99f3-4dc1-9d6e-af8934a27179','5e0b5b52-dabc-41c9-9124-d353e5de592b','2026-01-21 11:51:16',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-29776859-foo_step2-en6frwnkgyjb','state changed','OS::Heat::RandomString',NULL,NULL),(804,'bb2b8016-d771-4b5d-a13f-5fffb7480e9b','5e0b5b52-dabc-41c9-9124-d353e5de592b','2026-01-21 11:51:16',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-29776859-foo_step2-en6frwnkgyjb','state changed','OS::Heat::RandomString',NULL,NULL),(805,'337459fb-f200-413a-9b7a-5326774710fb','5e0b5b52-dabc-41c9-9124-d353e5de592b','2026-01-21 11:51:16',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-29776859-foo_step1-qbr3qhj6za7o','state changed','OS::Heat::RandomString',NULL,NULL),(806,'876d51d7-ba27-4f6d-be1a-6ef740afbc12','5e0b5b52-dabc-41c9-9124-d353e5de592b','2026-01-21 11:51:16',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-29776859-foo_step1-qbr3qhj6za7o','state changed','OS::Heat::RandomString',NULL,NULL),(807,'debce320-2bfc-48a0-856b-1094cdedf052','5e0b5b52-dabc-41c9-9124-d353e5de592b','2026-01-21 11:51:16',NULL,'DELETE','COMPLETE','HooksTest-29776859','5e0b5b52-dabc-41c9-9124-d353e5de592b','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(808,'47767c36-ae3c-4b26-881e-459778a3c49f','d88a5c8d-92b2-4324-bf8a-d57bbbac839a','2026-01-21 11:51:17',NULL,'CREATE','IN_PROGRESS','EncryptionVolTypeTest-1636502822','d88a5c8d-92b2-4324-bf8a-d57bbbac839a','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(809,'899f0eec-bb10-4207-9e3d-b913ba72c976','d88a5c8d-92b2-4324-bf8a-d57bbbac839a','2026-01-21 11:51:17',NULL,'CREATE','IN_PROGRESS','my_volume_type','EncryptionVolTypeTest-1636502822-my_volume_type-zvrew2fzbcnn','state changed','OS::Cinder::VolumeType',NULL,139),(810,'6baa3e08-e70b-4bc4-b62e-5ce4a9271174','d88a5c8d-92b2-4324-bf8a-d57bbbac839a','2026-01-21 11:51:17',NULL,'CREATE','COMPLETE','my_volume_type','d47944a7-10e8-4c29-b037-5e146aa0d6af','state changed','OS::Cinder::VolumeType',NULL,139),(811,'52a231e1-8411-4889-b34e-a0767fb2016c','d88a5c8d-92b2-4324-bf8a-d57bbbac839a','2026-01-21 11:51:17',NULL,'CREATE','IN_PROGRESS','my_encrypted_vol_type','EncryptionVolTypeTest-1636502822-my_encrypted_vol_type-2azhowbbh7ym','state changed','OS::Cinder::EncryptedVolumeType',NULL,140),(812,'212cfdf9-0ce3-4048-9252-528d154c9c1d','d88a5c8d-92b2-4324-bf8a-d57bbbac839a','2026-01-21 11:51:17',NULL,'CREATE','COMPLETE','my_encrypted_vol_type','d47944a7-10e8-4c29-b037-5e146aa0d6af','state changed','OS::Cinder::EncryptedVolumeType',NULL,140),(813,'dc6b4dbe-0a49-4951-afb6-3dfc390cff57','d88a5c8d-92b2-4324-bf8a-d57bbbac839a','2026-01-21 11:51:17',NULL,'CREATE','COMPLETE','EncryptionVolTypeTest-1636502822','d88a5c8d-92b2-4324-bf8a-d57bbbac839a','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(814,'c471bcf8-db25-4be5-a200-63921f33e6eb','3355e3b4-022a-4e52-8851-ece1bcb4bfc5','2026-01-21 11:51:21',NULL,'CREATE','IN_PROGRESS','HooksTest-2071588984','3355e3b4-022a-4e52-8851-ece1bcb4bfc5','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(815,'9a4abe19-865c-4487-a74f-8801e2dca853','3355e3b4-022a-4e52-8851-ece1bcb4bfc5','2026-01-21 11:51:21',NULL,'CREATE','IN_PROGRESS','rg','HooksTest-2071588984-rg-x2kapzuklayt','state changed','OS::Heat::ResourceGroup',NULL,141),(816,'a65cc5c3-0cff-4655-b381-e2b538be420a','069bb98e-bc45-4668-8bb8-b75cdf63a38b','2026-01-21 11:51:21',NULL,'CREATE','IN_PROGRESS','HooksTest-2071588984-rg-x2kapzuklayt','069bb98e-bc45-4668-8bb8-b75cdf63a38b','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(817,'89417e5d-850c-4dcf-b167-b0b95453a7ff','069bb98e-bc45-4668-8bb8-b75cdf63a38b','2026-01-21 11:51:21',NULL,'CREATE','IN_PROGRESS','0','HooksTest-2071588984-rg-x2kapzuklayt-0-24yo3jeshdmf','state changed','OS::Heat::RandomString',NULL,NULL),(818,'e285141b-5e95-4676-8f37-7e232903ddf4','069bb98e-bc45-4668-8bb8-b75cdf63a38b','2026-01-21 11:51:21',NULL,'CREATE','COMPLETE','0','HooksTest-2071588984-rg-x2kapzuklayt-0-24yo3jeshdmf','state changed','OS::Heat::RandomString',NULL,NULL),(819,'12b783f7-7a77-4c92-850b-ed1a83dd2fa6','069bb98e-bc45-4668-8bb8-b75cdf63a38b','2026-01-21 11:51:21',NULL,'CREATE','COMPLETE','HooksTest-2071588984-rg-x2kapzuklayt','069bb98e-bc45-4668-8bb8-b75cdf63a38b','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(820,'d33ed134-2699-46e5-bc58-a0f43f3bc22e','d88a5c8d-92b2-4324-bf8a-d57bbbac839a','2026-01-21 11:51:22',NULL,'UPDATE','IN_PROGRESS','EncryptionVolTypeTest-1636502822','d88a5c8d-92b2-4324-bf8a-d57bbbac839a','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(821,'e4f18499-9ec0-4497-a6c0-7e7be09c7a33','d88a5c8d-92b2-4324-bf8a-d57bbbac839a','2026-01-21 11:51:22',NULL,'UPDATE','IN_PROGRESS','my_encrypted_vol_type','d47944a7-10e8-4c29-b037-5e146aa0d6af','state changed','OS::Cinder::EncryptedVolumeType',NULL,140),(822,'18ef7a1a-41fa-4d57-90f7-4f4d3c72f3a8','d88a5c8d-92b2-4324-bf8a-d57bbbac839a','2026-01-21 11:51:22',NULL,'UPDATE','COMPLETE','my_encrypted_vol_type','d47944a7-10e8-4c29-b037-5e146aa0d6af','state changed','OS::Cinder::EncryptedVolumeType',NULL,142),(823,'eeff07d0-1994-4e9c-b90e-d81dc060aaeb','d88a5c8d-92b2-4324-bf8a-d57bbbac839a','2026-01-21 11:51:22',NULL,'UPDATE','COMPLETE','EncryptionVolTypeTest-1636502822','d88a5c8d-92b2-4324-bf8a-d57bbbac839a','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(824,'7daca94d-765d-414f-a734-785c2c5610f9','3355e3b4-022a-4e52-8851-ece1bcb4bfc5','2026-01-21 11:51:22',NULL,'CREATE','COMPLETE','rg','069bb98e-bc45-4668-8bb8-b75cdf63a38b','state changed','OS::Heat::ResourceGroup',NULL,141),(825,'582d851e-b284-4d4d-9eeb-2a3d4120a4c8','3355e3b4-022a-4e52-8851-ece1bcb4bfc5','2026-01-21 11:51:22',NULL,'CREATE','COMPLETE','HooksTest-2071588984','3355e3b4-022a-4e52-8851-ece1bcb4bfc5','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(826,'b6ace6e6-e4f1-4e09-9d57-3ec0d24cb6b6','3355e3b4-022a-4e52-8851-ece1bcb4bfc5','2026-01-21 11:51:26',NULL,'UPDATE','IN_PROGRESS','HooksTest-2071588984','3355e3b4-022a-4e52-8851-ece1bcb4bfc5','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(827,'7af8cca8-d2ce-4c2c-a2aa-c14e3cbbc9e8','3355e3b4-022a-4e52-8851-ece1bcb4bfc5','2026-01-21 11:51:26',NULL,'CREATE','COMPLETE','rg','069bb98e-bc45-4668-8bb8-b75cdf63a38b','UPDATE paused until Hook pre-update is cleared','OS::Heat::ResourceGroup',NULL,141),(828,'74dd6387-d121-4aff-a03b-9b7bca437d81','3355e3b4-022a-4e52-8851-ece1bcb4bfc5','2026-01-21 11:51:27',NULL,'CREATE','COMPLETE','rg','069bb98e-bc45-4668-8bb8-b75cdf63a38b','Hook pre-update is cleared','OS::Heat::ResourceGroup',NULL,141),(829,'058fbdc1-7b2d-4b68-bcb7-256d91d676cf','d88a5c8d-92b2-4324-bf8a-d57bbbac839a','2026-01-21 11:51:27',NULL,'DELETE','IN_PROGRESS','EncryptionVolTypeTest-1636502822','d88a5c8d-92b2-4324-bf8a-d57bbbac839a','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(830,'678df411-20dd-4ae4-b49c-10d6afe03d6e','d88a5c8d-92b2-4324-bf8a-d57bbbac839a','2026-01-21 11:51:27',NULL,'DELETE','IN_PROGRESS','my_encrypted_vol_type','d47944a7-10e8-4c29-b037-5e146aa0d6af','state changed','OS::Cinder::EncryptedVolumeType',NULL,142),(831,'e1e1d093-38b9-4770-88d1-224db7c785c5','d88a5c8d-92b2-4324-bf8a-d57bbbac839a','2026-01-21 11:51:27',NULL,'DELETE','COMPLETE','my_encrypted_vol_type','d47944a7-10e8-4c29-b037-5e146aa0d6af','state changed','OS::Cinder::EncryptedVolumeType',NULL,142),(832,'1bb24c78-a969-4a04-976b-dc27baa4f0ea','3355e3b4-022a-4e52-8851-ece1bcb4bfc5','2026-01-21 11:51:27',NULL,'UPDATE','IN_PROGRESS','rg','069bb98e-bc45-4668-8bb8-b75cdf63a38b','state changed','OS::Heat::ResourceGroup',NULL,141),(833,'843a394b-56b9-4c60-9a75-b34cc4340704','d88a5c8d-92b2-4324-bf8a-d57bbbac839a','2026-01-21 11:51:27',NULL,'DELETE','IN_PROGRESS','my_volume_type','d47944a7-10e8-4c29-b037-5e146aa0d6af','state changed','OS::Cinder::VolumeType',NULL,139),(834,'cbda9afb-4f99-496a-a094-2605204179dd','d88a5c8d-92b2-4324-bf8a-d57bbbac839a','2026-01-21 11:51:27',NULL,'DELETE','COMPLETE','my_volume_type','d47944a7-10e8-4c29-b037-5e146aa0d6af','state changed','OS::Cinder::VolumeType',NULL,139),(835,'f2e4cee6-9154-4fe1-80ac-edcc9d44f8fb','d88a5c8d-92b2-4324-bf8a-d57bbbac839a','2026-01-21 11:51:27',NULL,'DELETE','COMPLETE','EncryptionVolTypeTest-1636502822','d88a5c8d-92b2-4324-bf8a-d57bbbac839a','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(836,'dc1e6627-15a5-49df-bbb6-5e0b96b0cc31','069bb98e-bc45-4668-8bb8-b75cdf63a38b','2026-01-21 11:51:27',NULL,'UPDATE','IN_PROGRESS','HooksTest-2071588984-rg-x2kapzuklayt','069bb98e-bc45-4668-8bb8-b75cdf63a38b','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(837,'23d0c306-ef7a-46f8-8f2f-bb995dd70d7e','069bb98e-bc45-4668-8bb8-b75cdf63a38b','2026-01-21 11:51:29',NULL,'CREATE','IN_PROGRESS','1','HooksTest-2071588984-rg-x2kapzuklayt-1-d4ynge7upn7c','state changed','OS::Heat::RandomString',NULL,NULL),(838,'fa4d0fce-8088-4527-a669-9cdd9cfa8b62','069bb98e-bc45-4668-8bb8-b75cdf63a38b','2026-01-21 11:51:29',NULL,'CREATE','COMPLETE','1','HooksTest-2071588984-rg-x2kapzuklayt-1-d4ynge7upn7c','state changed','OS::Heat::RandomString',NULL,NULL),(839,'4627ba09-5ae9-4745-94a9-186419541bb2','069bb98e-bc45-4668-8bb8-b75cdf63a38b','2026-01-21 11:51:29',NULL,'UPDATE','COMPLETE','HooksTest-2071588984-rg-x2kapzuklayt','069bb98e-bc45-4668-8bb8-b75cdf63a38b','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(840,'f71010e7-be19-44c8-863b-685109dd73c9','3355e3b4-022a-4e52-8851-ece1bcb4bfc5','2026-01-21 11:51:30',NULL,'UPDATE','COMPLETE','rg','069bb98e-bc45-4668-8bb8-b75cdf63a38b','state changed','OS::Heat::ResourceGroup',NULL,143),(841,'4a2912e5-f849-42d9-8c72-badc610b576f','3355e3b4-022a-4e52-8851-ece1bcb4bfc5','2026-01-21 11:51:30',NULL,'UPDATE','COMPLETE','HooksTest-2071588984','3355e3b4-022a-4e52-8851-ece1bcb4bfc5','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(842,'db913712-de02-466f-b929-0dbc7a2e35d2','3355e3b4-022a-4e52-8851-ece1bcb4bfc5','2026-01-21 11:51:32',NULL,'DELETE','IN_PROGRESS','HooksTest-2071588984','3355e3b4-022a-4e52-8851-ece1bcb4bfc5','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(843,'234ca1b8-f6c9-4a67-a685-3c1757628a45','3355e3b4-022a-4e52-8851-ece1bcb4bfc5','2026-01-21 11:51:32',NULL,'DELETE','IN_PROGRESS','rg','069bb98e-bc45-4668-8bb8-b75cdf63a38b','state changed','OS::Heat::ResourceGroup',NULL,143),(844,'84eec8db-c234-4a5b-ac68-d8effa079de4','069bb98e-bc45-4668-8bb8-b75cdf63a38b','2026-01-21 11:51:33',NULL,'DELETE','IN_PROGRESS','HooksTest-2071588984-rg-x2kapzuklayt','069bb98e-bc45-4668-8bb8-b75cdf63a38b','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(845,'a14efec1-12c6-4a6b-8735-626c8d0d38cf','069bb98e-bc45-4668-8bb8-b75cdf63a38b','2026-01-21 11:51:33',NULL,'DELETE','IN_PROGRESS','1','HooksTest-2071588984-rg-x2kapzuklayt-1-d4ynge7upn7c','state changed','OS::Heat::RandomString',NULL,NULL),(846,'40124b19-b68a-461f-a39b-47d3dc0ee436','069bb98e-bc45-4668-8bb8-b75cdf63a38b','2026-01-21 11:51:33',NULL,'DELETE','COMPLETE','1','HooksTest-2071588984-rg-x2kapzuklayt-1-d4ynge7upn7c','state changed','OS::Heat::RandomString',NULL,NULL),(847,'5204a093-86ac-4d54-aa00-74d33e480004','069bb98e-bc45-4668-8bb8-b75cdf63a38b','2026-01-21 11:51:34',NULL,'DELETE','IN_PROGRESS','0','HooksTest-2071588984-rg-x2kapzuklayt-0-24yo3jeshdmf','state changed','OS::Heat::RandomString',NULL,NULL),(848,'d5f5031a-4fd8-4bd6-acc2-6c6b9d59199e','069bb98e-bc45-4668-8bb8-b75cdf63a38b','2026-01-21 11:51:34',NULL,'DELETE','COMPLETE','0','HooksTest-2071588984-rg-x2kapzuklayt-0-24yo3jeshdmf','state changed','OS::Heat::RandomString',NULL,NULL),(849,'b18fbc6f-7474-4b23-84dc-6c5e0d25ed73','069bb98e-bc45-4668-8bb8-b75cdf63a38b','2026-01-21 11:51:34',NULL,'DELETE','COMPLETE','HooksTest-2071588984-rg-x2kapzuklayt','069bb98e-bc45-4668-8bb8-b75cdf63a38b','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(850,'ecd19a03-eb82-41e9-ba26-336f9d325a99','a1bf221f-f68f-4027-9fb0-2173e5749a38','2026-01-21 11:51:34',NULL,'CREATE','IN_PROGRESS','ExternalReferencesTest-1721981834','a1bf221f-f68f-4027-9fb0-2173e5749a38','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(851,'1e60cec2-a1f5-4e53-affc-7e84771ef0e9','a1bf221f-f68f-4027-9fb0-2173e5749a38','2026-01-21 11:51:35',NULL,'ADOPT','IN_PROGRESS','test1','ExternalReferencesTest-1721981834-test1-vkerzxcofgbj','state changed','OS::Heat::TestResource',NULL,NULL),(852,'3a387781-b52b-4c2c-800c-0fb93f26b12e','a1bf221f-f68f-4027-9fb0-2173e5749a38','2026-01-21 11:51:35',NULL,'ADOPT','COMPLETE','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(853,'c440393b-e154-4581-a425-6c58fc7db367','a1bf221f-f68f-4027-9fb0-2173e5749a38','2026-01-21 11:51:35',NULL,'CHECK','COMPLETE','test1','foobar','CHECK not supported for OS::Heat::TestResource','OS::Heat::TestResource',NULL,NULL),(854,'d31ef139-2d6d-4061-852e-128d584ed29c','3355e3b4-022a-4e52-8851-ece1bcb4bfc5','2026-01-21 11:51:35',NULL,'DELETE','COMPLETE','rg','069bb98e-bc45-4668-8bb8-b75cdf63a38b','state changed','OS::Heat::ResourceGroup',NULL,143),(855,'df3853f5-da50-4133-b4db-f1a57f192425','a1bf221f-f68f-4027-9fb0-2173e5749a38','2026-01-21 11:51:35',NULL,'CREATE','COMPLETE','ExternalReferencesTest-1721981834','a1bf221f-f68f-4027-9fb0-2173e5749a38','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(856,'e92afbd6-faaf-42b5-8121-a3e67a318be2','3355e3b4-022a-4e52-8851-ece1bcb4bfc5','2026-01-21 11:51:35',NULL,'DELETE','COMPLETE','HooksTest-2071588984','3355e3b4-022a-4e52-8851-ece1bcb4bfc5','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(857,'bf655a47-bf99-4bd6-a274-5783b39c9342','a1bf221f-f68f-4027-9fb0-2173e5749a38','2026-01-21 11:51:35',NULL,'DELETE','IN_PROGRESS','ExternalReferencesTest-1721981834','a1bf221f-f68f-4027-9fb0-2173e5749a38','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(858,'015ee828-63fb-4ee6-8449-46fe13676cf3','a1bf221f-f68f-4027-9fb0-2173e5749a38','2026-01-21 11:51:36',NULL,'DELETE','IN_PROGRESS','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(859,'4c16ef17-5e5d-48c4-aa73-fdb733c70257','a1bf221f-f68f-4027-9fb0-2173e5749a38','2026-01-21 11:51:36',NULL,'DELETE','COMPLETE','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(860,'8c595d0d-29b8-4b73-b52c-960462d28422','a1bf221f-f68f-4027-9fb0-2173e5749a38','2026-01-21 11:51:36',NULL,'DELETE','COMPLETE','ExternalReferencesTest-1721981834','a1bf221f-f68f-4027-9fb0-2173e5749a38','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(861,'ffc14e13-b782-4384-b988-a8784b58ea2b','aed69e16-a140-42ad-a0f1-c75066c446bb','2026-01-21 11:51:40',NULL,'CREATE','IN_PROGRESS','HooksTest-419121912','aed69e16-a140-42ad-a0f1-c75066c446bb','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(862,'1860653f-c57f-4c1a-8bb9-f8c064b504dc','aed69e16-a140-42ad-a0f1-c75066c446bb','2026-01-21 11:51:41',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-419121912-foo_step1-jo2sg3shjojz','state changed','OS::Heat::RandomString',NULL,NULL),(863,'2f836b17-4bfa-401e-9097-9aa13a6c5a33','aed69e16-a140-42ad-a0f1-c75066c446bb','2026-01-21 11:51:41',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-419121912-foo_step1-jo2sg3shjojz','state changed','OS::Heat::RandomString',NULL,NULL),(864,'c8b90241-8894-4b40-97da-857db89629d2','aed69e16-a140-42ad-a0f1-c75066c446bb','2026-01-21 11:51:41',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-419121912-foo_step2-mklpvhcytjbk','state changed','OS::Heat::RandomString',NULL,NULL),(865,'a2d46893-9c14-4cbe-b10f-363bc20c15e8','aed69e16-a140-42ad-a0f1-c75066c446bb','2026-01-21 11:51:41',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-419121912-foo_step2-mklpvhcytjbk','state changed','OS::Heat::RandomString',NULL,NULL),(866,'39180bbb-6d06-4328-be28-bddee2852cb1','aed69e16-a140-42ad-a0f1-c75066c446bb','2026-01-21 11:51:41',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-419121912-foo_step3-cs2qntqgrlwk','state changed','OS::Heat::RandomString',NULL,NULL),(867,'023a12fb-a7e4-417b-817e-ae7b144f0477','aed69e16-a140-42ad-a0f1-c75066c446bb','2026-01-21 11:51:41',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-419121912-foo_step3-cs2qntqgrlwk','state changed','OS::Heat::RandomString',NULL,NULL),(868,'40432b00-441f-4de3-af64-e461ab1a15d1','aed69e16-a140-42ad-a0f1-c75066c446bb','2026-01-21 11:51:41',NULL,'CREATE','COMPLETE','HooksTest-419121912','aed69e16-a140-42ad-a0f1-c75066c446bb','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(869,'5b9ef980-0368-4f30-be64-ffa7d2977870','02e1c7e0-8bd2-4e3f-86da-ec694a312ed1','2026-01-21 11:51:42',NULL,'CREATE','IN_PROGRESS','ExternalReferencesTest-1822175871','02e1c7e0-8bd2-4e3f-86da-ec694a312ed1','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(870,'3e609192-08aa-4152-a112-d4bca5405828','02e1c7e0-8bd2-4e3f-86da-ec694a312ed1','2026-01-21 11:51:42',NULL,'ADOPT','IN_PROGRESS','test1','ExternalReferencesTest-1822175871-test1-3p752qogn5hv','state changed','OS::Heat::TestResource',NULL,NULL),(871,'8663267d-331b-4563-bb34-c45da4d9ef39','02e1c7e0-8bd2-4e3f-86da-ec694a312ed1','2026-01-21 11:51:42',NULL,'ADOPT','COMPLETE','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(872,'153d7afd-e0c0-42de-a99f-055b1a5c5ecd','02e1c7e0-8bd2-4e3f-86da-ec694a312ed1','2026-01-21 11:51:42',NULL,'CHECK','COMPLETE','test1','foobar','CHECK not supported for OS::Heat::TestResource','OS::Heat::TestResource',NULL,NULL),(873,'b28b92d8-d605-459b-8da2-1a2f6198ebf5','02e1c7e0-8bd2-4e3f-86da-ec694a312ed1','2026-01-21 11:51:42',NULL,'CREATE','COMPLETE','ExternalReferencesTest-1822175871','02e1c7e0-8bd2-4e3f-86da-ec694a312ed1','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(874,'89e13ca3-1bec-4704-b887-828b57941634','02e1c7e0-8bd2-4e3f-86da-ec694a312ed1','2026-01-21 11:51:43',NULL,'UPDATE','IN_PROGRESS','ExternalReferencesTest-1822175871','02e1c7e0-8bd2-4e3f-86da-ec694a312ed1','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(875,'4f232a0e-3ddc-47b9-9da4-5fb6136ed085','02e1c7e0-8bd2-4e3f-86da-ec694a312ed1','2026-01-21 11:51:43',NULL,'UPDATE','COMPLETE','ExternalReferencesTest-1822175871','02e1c7e0-8bd2-4e3f-86da-ec694a312ed1','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(876,'8bc4cc50-7f47-43b8-be8c-c226050bf9e6','aed69e16-a140-42ad-a0f1-c75066c446bb','2026-01-21 11:51:46',NULL,'UPDATE','IN_PROGRESS','HooksTest-419121912','aed69e16-a140-42ad-a0f1-c75066c446bb','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(877,'264e3542-cbe7-4db4-9cd9-da81012c437a','aed69e16-a140-42ad-a0f1-c75066c446bb','2026-01-21 11:51:46',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-419121912-foo_step2-mklpvhcytjbk','UPDATE paused until Hook pre-update is cleared','OS::Heat::RandomString',NULL,NULL),(878,'bca7ee30-97d5-474f-94d9-25d6a9732f26','aed69e16-a140-42ad-a0f1-c75066c446bb','2026-01-21 11:51:48',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-419121912-foo_step2-mklpvhcytjbk','Hook pre-update is cleared','OS::Heat::RandomString',NULL,NULL),(879,'53063d3b-7cb9-4a97-aa8f-988950e74b50','02e1c7e0-8bd2-4e3f-86da-ec694a312ed1','2026-01-21 11:51:48',NULL,'DELETE','IN_PROGRESS','ExternalReferencesTest-1822175871','02e1c7e0-8bd2-4e3f-86da-ec694a312ed1','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(880,'ff909153-7fe9-4686-86da-841d4d271178','aed69e16-a140-42ad-a0f1-c75066c446bb','2026-01-21 11:51:48',NULL,'UPDATE','COMPLETE','HooksTest-419121912','aed69e16-a140-42ad-a0f1-c75066c446bb','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(881,'9635b8bb-847f-4e45-900b-54bba0a627aa','02e1c7e0-8bd2-4e3f-86da-ec694a312ed1','2026-01-21 11:51:48',NULL,'DELETE','IN_PROGRESS','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(882,'7c9e985b-5102-487b-8101-29b3ad6833be','02e1c7e0-8bd2-4e3f-86da-ec694a312ed1','2026-01-21 11:51:48',NULL,'DELETE','COMPLETE','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(883,'81af4985-ed99-44c9-9edb-878d47678aae','02e1c7e0-8bd2-4e3f-86da-ec694a312ed1','2026-01-21 11:51:48',NULL,'DELETE','COMPLETE','ExternalReferencesTest-1822175871','02e1c7e0-8bd2-4e3f-86da-ec694a312ed1','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(884,'13304982-657c-49b4-8d72-1ec18f202742','aed69e16-a140-42ad-a0f1-c75066c446bb','2026-01-21 11:51:49',NULL,'DELETE','IN_PROGRESS','HooksTest-419121912','aed69e16-a140-42ad-a0f1-c75066c446bb','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(885,'a86208c1-61e3-4585-bfaa-aece04d3bb1a','aed69e16-a140-42ad-a0f1-c75066c446bb','2026-01-21 11:51:49',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-419121912-foo_step3-cs2qntqgrlwk','state changed','OS::Heat::RandomString',NULL,NULL),(886,'79b2ce1b-1bf3-4a74-accb-2afa3429e763','aed69e16-a140-42ad-a0f1-c75066c446bb','2026-01-21 11:51:49',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-419121912-foo_step3-cs2qntqgrlwk','state changed','OS::Heat::RandomString',NULL,NULL),(887,'c556ecb2-1844-4a09-8ebb-4b90fa1d2308','aed69e16-a140-42ad-a0f1-c75066c446bb','2026-01-21 11:51:49',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-419121912-foo_step2-mklpvhcytjbk','state changed','OS::Heat::RandomString',NULL,NULL),(888,'d8b8cbb7-1558-445c-851f-89e2a8976678','aed69e16-a140-42ad-a0f1-c75066c446bb','2026-01-21 11:51:49',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-419121912-foo_step2-mklpvhcytjbk','state changed','OS::Heat::RandomString',NULL,NULL),(889,'2aa210e8-8059-474f-b012-fe1f1aa81277','aed69e16-a140-42ad-a0f1-c75066c446bb','2026-01-21 11:51:49',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-419121912-foo_step1-jo2sg3shjojz','state changed','OS::Heat::RandomString',NULL,NULL),(890,'6535529f-2cfc-4fd9-b22a-dc9edcf3b603','aed69e16-a140-42ad-a0f1-c75066c446bb','2026-01-21 11:51:49',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-419121912-foo_step1-jo2sg3shjojz','state changed','OS::Heat::RandomString',NULL,NULL),(891,'b1cc189f-5d95-455d-869b-93da8d81c5ab','aed69e16-a140-42ad-a0f1-c75066c446bb','2026-01-21 11:51:49',NULL,'DELETE','COMPLETE','HooksTest-419121912','aed69e16-a140-42ad-a0f1-c75066c446bb','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(892,'7731a269-f2cd-499f-9a1a-666a5c6bc52f','12e44383-ac0d-4511-885e-5eaa79aa7756','2026-01-21 11:51:55',NULL,'CREATE','IN_PROGRESS','ExternalReferencesTest-1406052766','12e44383-ac0d-4511-885e-5eaa79aa7756','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(893,'c82f44f5-2adb-4417-932a-f84a429cdbfd','12e44383-ac0d-4511-885e-5eaa79aa7756','2026-01-21 11:51:55',NULL,'CREATE','IN_PROGRESS','test1','ExternalReferencesTest-1406052766-test1-uctbzufusnw5','state changed','OS::Heat::TestResource',NULL,NULL),(894,'34c35583-4864-4f82-a3f5-e0fec3f246dd','12e44383-ac0d-4511-885e-5eaa79aa7756','2026-01-21 11:51:55',NULL,'CREATE','COMPLETE','test1','ExternalReferencesTest-1406052766-test1-uctbzufusnw5','state changed','OS::Heat::TestResource',NULL,NULL),(895,'20e03cb1-4680-4808-a913-d122aaa8701e','12e44383-ac0d-4511-885e-5eaa79aa7756','2026-01-21 11:51:55',NULL,'CREATE','COMPLETE','ExternalReferencesTest-1406052766','12e44383-ac0d-4511-885e-5eaa79aa7756','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(896,'50d29a08-c2c0-4ad2-bac2-5c8d02298926','594f2d7d-226c-4a0f-82ee-b60214d287ba','2026-01-21 11:51:55',NULL,'CREATE','IN_PROGRESS','HooksTest-1654173811','594f2d7d-226c-4a0f-82ee-b60214d287ba','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(897,'e6cd690d-69a8-44b0-aae4-ea0215feffe0','594f2d7d-226c-4a0f-82ee-b60214d287ba','2026-01-21 11:51:55',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-1654173811-foo_step1-if7a35lqtwnx','state changed','OS::Heat::RandomString',NULL,NULL),(898,'dcdfb0ac-d095-4fe1-ae2d-48328d6d6f74','594f2d7d-226c-4a0f-82ee-b60214d287ba','2026-01-21 11:51:55',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-1654173811-foo_step1-if7a35lqtwnx','state changed','OS::Heat::RandomString',NULL,NULL),(899,'fd49dd28-f92a-4f9e-8d3e-9837bcd6aa5b','594f2d7d-226c-4a0f-82ee-b60214d287ba','2026-01-21 11:51:55',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-1654173811-foo_step2-onydwm7dvjog','state changed','OS::Heat::RandomString',NULL,NULL),(900,'08186a20-87af-43d2-a877-2f028c2472c0','594f2d7d-226c-4a0f-82ee-b60214d287ba','2026-01-21 11:51:55',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1654173811-foo_step2-onydwm7dvjog','state changed','OS::Heat::RandomString',NULL,NULL),(901,'185a41b6-0734-4bb4-87c9-92f7d1d44966','594f2d7d-226c-4a0f-82ee-b60214d287ba','2026-01-21 11:51:55',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-1654173811-foo_step3-vmshao3pj2zi','state changed','OS::Heat::RandomString',NULL,NULL),(902,'fa197506-5109-4335-959e-47fcc226721b','594f2d7d-226c-4a0f-82ee-b60214d287ba','2026-01-21 11:51:55',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-1654173811-foo_step3-vmshao3pj2zi','state changed','OS::Heat::RandomString',NULL,NULL),(903,'5a0f2512-5ffa-4847-8704-12614320a25d','594f2d7d-226c-4a0f-82ee-b60214d287ba','2026-01-21 11:51:55',NULL,'CREATE','COMPLETE','HooksTest-1654173811','594f2d7d-226c-4a0f-82ee-b60214d287ba','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(904,'c1be36e2-f63a-4b15-b1e7-8d65576892e4','12e44383-ac0d-4511-885e-5eaa79aa7756','2026-01-21 11:51:56',NULL,'UPDATE','IN_PROGRESS','ExternalReferencesTest-1406052766','12e44383-ac0d-4511-885e-5eaa79aa7756','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(905,'c61b6da4-4aad-4d67-96b1-21a32e1dea17','12e44383-ac0d-4511-885e-5eaa79aa7756','2026-01-21 11:51:56',NULL,'UPDATE','FAILED','ExternalReferencesTest-1406052766','12e44383-ac0d-4511-885e-5eaa79aa7756','Resource UPDATE failed: NotSupported: resources.test1: Update to property external_id of test1 (OS::Heat::TestResource) is not supported.','OS::Heat::Stack',NULL,NULL),(906,'0e9a9e7e-b970-4b1a-a02c-79b8a0e6384e','594f2d7d-226c-4a0f-82ee-b60214d287ba','2026-01-21 11:51:56',NULL,'UPDATE','IN_PROGRESS','HooksTest-1654173811','594f2d7d-226c-4a0f-82ee-b60214d287ba','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(907,'5b37d099-e72c-43e2-820b-ac187340902e','594f2d7d-226c-4a0f-82ee-b60214d287ba','2026-01-21 11:51:56',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1654173811-foo_step2-onydwm7dvjog','UPDATE paused until Hook pre-update is cleared','OS::Heat::RandomString',NULL,NULL),(908,'cabc1cc5-62d6-4eb6-9532-1e67719bccd2','594f2d7d-226c-4a0f-82ee-b60214d287ba','2026-01-21 11:51:57',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1654173811-foo_step2-onydwm7dvjog','Hook pre-update is cleared','OS::Heat::RandomString',NULL,NULL),(909,'0ece8365-5c0c-4892-99d9-ffc9f706561a','594f2d7d-226c-4a0f-82ee-b60214d287ba','2026-01-21 11:51:57',NULL,'UPDATE','IN_PROGRESS','foo_step2','HooksTest-1654173811-foo_step2-onydwm7dvjog','state changed','OS::Heat::RandomString',NULL,NULL),(910,'8dcf8fe4-07dd-4927-8353-268bbbc16c2a','594f2d7d-226c-4a0f-82ee-b60214d287ba','2026-01-21 11:51:57',NULL,'UPDATE','COMPLETE','foo_step2','HooksTest-1654173811-foo_step2-onydwm7dvjog','The Resource foo_step2 requires replacement.','OS::Heat::RandomString',NULL,NULL),(911,'64da846c-0fdd-4905-a077-a31f5d5b44f1','594f2d7d-226c-4a0f-82ee-b60214d287ba','2026-01-21 11:51:57',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-1654173811-foo_step2-zliy2gzdwrgv','state changed','OS::Heat::RandomString',NULL,144),(912,'5579902d-d8e1-42d2-9420-8b049d432034','594f2d7d-226c-4a0f-82ee-b60214d287ba','2026-01-21 11:51:57',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1654173811-foo_step2-zliy2gzdwrgv','state changed','OS::Heat::RandomString',NULL,144),(913,'96d54b60-2def-49c7-938d-d7a2a5722767','594f2d7d-226c-4a0f-82ee-b60214d287ba','2026-01-21 11:51:57',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-1654173811-foo_step2-onydwm7dvjog','state changed','OS::Heat::RandomString',NULL,NULL),(914,'3f852b03-8007-4e27-99b5-7efacf243c62','594f2d7d-226c-4a0f-82ee-b60214d287ba','2026-01-21 11:51:57',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-1654173811-foo_step2-onydwm7dvjog','state changed','OS::Heat::RandomString',NULL,NULL),(915,'e78535ad-ccbe-4b77-8bb6-4ceeec222f73','594f2d7d-226c-4a0f-82ee-b60214d287ba','2026-01-21 11:51:57',NULL,'UPDATE','COMPLETE','HooksTest-1654173811','594f2d7d-226c-4a0f-82ee-b60214d287ba','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(916,'8e538ca5-3882-4e12-bf9e-8f27d8f7e2de','12e44383-ac0d-4511-885e-5eaa79aa7756','2026-01-21 11:52:00',NULL,'DELETE','IN_PROGRESS','ExternalReferencesTest-1406052766','12e44383-ac0d-4511-885e-5eaa79aa7756','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(917,'1b95cc16-8595-48d5-9f7f-f564c000f51e','12e44383-ac0d-4511-885e-5eaa79aa7756','2026-01-21 11:52:00',NULL,'DELETE','IN_PROGRESS','test1','ExternalReferencesTest-1406052766-test1-uctbzufusnw5','state changed','OS::Heat::TestResource',NULL,NULL),(918,'19bd550a-dfca-4546-b4c8-a45af7639a82','12e44383-ac0d-4511-885e-5eaa79aa7756','2026-01-21 11:52:00',NULL,'DELETE','COMPLETE','test1','ExternalReferencesTest-1406052766-test1-uctbzufusnw5','state changed','OS::Heat::TestResource',NULL,NULL),(919,'b30846f3-13f8-4f20-a6b1-a4196fffd49e','12e44383-ac0d-4511-885e-5eaa79aa7756','2026-01-21 11:52:00',NULL,'DELETE','COMPLETE','ExternalReferencesTest-1406052766','12e44383-ac0d-4511-885e-5eaa79aa7756','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(920,'67f33863-826d-494c-aad7-e75d785365fd','594f2d7d-226c-4a0f-82ee-b60214d287ba','2026-01-21 11:52:03',NULL,'DELETE','IN_PROGRESS','HooksTest-1654173811','594f2d7d-226c-4a0f-82ee-b60214d287ba','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(921,'eedf83c3-384b-420d-b23b-d97732302c1d','594f2d7d-226c-4a0f-82ee-b60214d287ba','2026-01-21 11:52:03',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-1654173811-foo_step3-vmshao3pj2zi','state changed','OS::Heat::RandomString',NULL,NULL),(922,'e0a43c47-dba9-45f0-9eec-cc2bb310b5f7','594f2d7d-226c-4a0f-82ee-b60214d287ba','2026-01-21 11:52:03',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-1654173811-foo_step3-vmshao3pj2zi','state changed','OS::Heat::RandomString',NULL,NULL),(923,'c4564c8a-dbae-4a9a-adb3-e7881cbf6d8b','594f2d7d-226c-4a0f-82ee-b60214d287ba','2026-01-21 11:52:05',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-1654173811-foo_step2-zliy2gzdwrgv','state changed','OS::Heat::RandomString',NULL,144),(924,'e9123f1a-831e-4a8b-aac3-14cae7faa823','594f2d7d-226c-4a0f-82ee-b60214d287ba','2026-01-21 11:52:05',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-1654173811-foo_step2-zliy2gzdwrgv','state changed','OS::Heat::RandomString',NULL,144),(925,'51ed3e96-b3ab-453e-a8d7-3ddceb16948c','594f2d7d-226c-4a0f-82ee-b60214d287ba','2026-01-21 11:52:06',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-1654173811-foo_step1-if7a35lqtwnx','state changed','OS::Heat::RandomString',NULL,NULL),(926,'5161313c-95b1-4d77-b239-0b38f33f5130','594f2d7d-226c-4a0f-82ee-b60214d287ba','2026-01-21 11:52:06',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-1654173811-foo_step1-if7a35lqtwnx','state changed','OS::Heat::RandomString',NULL,NULL),(927,'647c292b-c39a-4d5c-a142-2357bfc19e31','594f2d7d-226c-4a0f-82ee-b60214d287ba','2026-01-21 11:52:06',NULL,'DELETE','COMPLETE','HooksTest-1654173811','594f2d7d-226c-4a0f-82ee-b60214d287ba','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(928,'54e48cdb-1579-452e-b0e7-dd3fe2fae1b9','5968210c-61dd-41e0-9ccc-cc2eed2e9966','2026-01-21 11:52:07',NULL,'CREATE','IN_PROGRESS','add_network','5968210c-61dd-41e0-9ccc-cc2eed2e9966','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(929,'c658d729-d02c-4d01-99e3-096b595ec42d','5968210c-61dd-41e0-9ccc-cc2eed2e9966','2026-01-21 11:52:07',NULL,'CREATE','IN_PROGRESS','net','add_network-net-jm2noaahx5un','state changed','OS::Neutron::Net',NULL,145),(930,'651c7530-e01c-4e8f-a0a8-a4485c501ee7','5968210c-61dd-41e0-9ccc-cc2eed2e9966','2026-01-21 11:52:08',NULL,'CREATE','COMPLETE','net','050e2666-0245-43ea-8b8d-0dcb88a82b55','state changed','OS::Neutron::Net',NULL,145),(931,'18fc0643-ba99-4dc9-8310-237bb7db4f4c','5968210c-61dd-41e0-9ccc-cc2eed2e9966','2026-01-21 11:52:09',NULL,'CREATE','IN_PROGRESS','subnet','add_network-subnet-yvpv7bf4f7dh','state changed','OS::Neutron::Subnet',NULL,146),(932,'7b1ba768-e6c8-4139-88d6-3ca863d7c040','9afef6c4-848e-486f-9d8b-33162651be74','2026-01-21 11:52:10',NULL,'CREATE','IN_PROGRESS','StackOutputsTest-1064902002','9afef6c4-848e-486f-9d8b-33162651be74','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(933,'6075d79d-c8b2-4dcd-8dd5-81474d7d466e','9afef6c4-848e-486f-9d8b-33162651be74','2026-01-21 11:52:10',NULL,'CREATE','IN_PROGRESS','parent','StackOutputsTest-1064902002-parent-epryjjowwecd','state changed','1.yaml',NULL,NULL),(934,'d2b82543-0fc7-4ca0-8fa0-54e4a2ae07aa','7cebc90a-b5fa-4bc5-b106-bd24443762cf','2026-01-21 11:52:10',NULL,'CREATE','IN_PROGRESS','StackOutputsTest-1064902002-parent-epryjjowwecd','7cebc90a-b5fa-4bc5-b106-bd24443762cf','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(935,'94147e57-144c-49c9-8eca-3a26aa8a7d96','7cebc90a-b5fa-4bc5-b106-bd24443762cf','2026-01-21 11:52:10',NULL,'CREATE','IN_PROGRESS','test_resource_b','StackOutputsTest-1064902002-parent-epryjjowwecd-test_resource_b-6quweuei7t4c','state changed','OS::Heat::TestResource',NULL,147),(936,'1473cef1-11c7-4ca9-8f07-4ac4d9ba8b84','7cebc90a-b5fa-4bc5-b106-bd24443762cf','2026-01-21 11:52:10',NULL,'CREATE','COMPLETE','test_resource_b','StackOutputsTest-1064902002-parent-epryjjowwecd-test_resource_b-6quweuei7t4c','state changed','OS::Heat::TestResource',NULL,147),(937,'444d71ab-0731-4135-9f62-1a0efd972578','5968210c-61dd-41e0-9ccc-cc2eed2e9966','2026-01-21 11:52:10',NULL,'CREATE','COMPLETE','subnet','ecc340ac-bffe-4d60-8aa4-e23dba086c69','state changed','OS::Neutron::Subnet',NULL,146),(938,'40e74019-09da-414a-854b-6e66b4cd97d6','5968210c-61dd-41e0-9ccc-cc2eed2e9966','2026-01-21 11:52:10',NULL,'CREATE','IN_PROGRESS','server','add_network-server-5kazbcrt3s4w','state changed','OS::Nova::Server',NULL,148),(939,'7bbc8436-7218-46f4-80c6-b9776b659b7c','7cebc90a-b5fa-4bc5-b106-bd24443762cf','2026-01-21 11:52:11',NULL,'CREATE','IN_PROGRESS','test_resource_a','StackOutputsTest-1064902002-parent-epryjjowwecd-test_resource_a-ch6p3qvaak7g','state changed','OS::Heat::TestResource',NULL,149),(940,'c95a0246-61e6-4561-a876-c486794f1399','7cebc90a-b5fa-4bc5-b106-bd24443762cf','2026-01-21 11:52:11',NULL,'CREATE','COMPLETE','test_resource_a','StackOutputsTest-1064902002-parent-epryjjowwecd-test_resource_a-ch6p3qvaak7g','state changed','OS::Heat::TestResource',NULL,149),(941,'06b84fdb-fcc8-496e-b137-b0aed9f82bf0','7cebc90a-b5fa-4bc5-b106-bd24443762cf','2026-01-21 11:52:11',NULL,'CREATE','COMPLETE','StackOutputsTest-1064902002-parent-epryjjowwecd','7cebc90a-b5fa-4bc5-b106-bd24443762cf','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(942,'f170ce02-60a0-422e-98ae-e9c0b1d1c43c','9afef6c4-848e-486f-9d8b-33162651be74','2026-01-21 11:52:12',NULL,'CREATE','COMPLETE','parent','7cebc90a-b5fa-4bc5-b106-bd24443762cf','state changed','1.yaml',NULL,NULL),(943,'0983381c-40e3-453f-8819-b0701cbaef54','9afef6c4-848e-486f-9d8b-33162651be74','2026-01-21 11:52:12',NULL,'CREATE','COMPLETE','StackOutputsTest-1064902002','9afef6c4-848e-486f-9d8b-33162651be74','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(944,'90898ff6-c3a8-4a57-9ade-41d488c7e23b','9afef6c4-848e-486f-9d8b-33162651be74','2026-01-21 11:52:14',NULL,'UPDATE','IN_PROGRESS','StackOutputsTest-1064902002','9afef6c4-848e-486f-9d8b-33162651be74','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(945,'be1c3531-478b-4cb1-8d98-88f046159073','9afef6c4-848e-486f-9d8b-33162651be74','2026-01-21 11:52:15',NULL,'UPDATE','IN_PROGRESS','parent','7cebc90a-b5fa-4bc5-b106-bd24443762cf','state changed','1.yaml',NULL,NULL),(946,'28186917-90f6-4b31-90e1-f3b508fe6ddf','7cebc90a-b5fa-4bc5-b106-bd24443762cf','2026-01-21 11:52:15',NULL,'UPDATE','IN_PROGRESS','StackOutputsTest-1064902002-parent-epryjjowwecd','7cebc90a-b5fa-4bc5-b106-bd24443762cf','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(947,'2e8a7dc0-9797-4ce4-baaa-e58cef1d04eb','7cebc90a-b5fa-4bc5-b106-bd24443762cf','2026-01-21 11:52:16',NULL,'UPDATE','COMPLETE','StackOutputsTest-1064902002-parent-epryjjowwecd','7cebc90a-b5fa-4bc5-b106-bd24443762cf','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(948,'7252ded9-d0f9-414d-abcc-bbcf4482c7be','9afef6c4-848e-486f-9d8b-33162651be74','2026-01-21 11:52:17',NULL,'UPDATE','COMPLETE','parent','7cebc90a-b5fa-4bc5-b106-bd24443762cf','state changed','1.yaml',NULL,NULL),(949,'37b9210d-57a5-48e7-ad76-4c97ec76cd58','9afef6c4-848e-486f-9d8b-33162651be74','2026-01-21 11:52:17',NULL,'UPDATE','COMPLETE','StackOutputsTest-1064902002','9afef6c4-848e-486f-9d8b-33162651be74','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(950,'9125221c-b11f-4742-8b8e-6879e4eb120a','9afef6c4-848e-486f-9d8b-33162651be74','2026-01-21 11:52:20',NULL,'DELETE','IN_PROGRESS','StackOutputsTest-1064902002','9afef6c4-848e-486f-9d8b-33162651be74','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(951,'d4102931-55f6-495b-98e0-9a7e7c83dded','9afef6c4-848e-486f-9d8b-33162651be74','2026-01-21 11:52:20',NULL,'DELETE','IN_PROGRESS','parent','7cebc90a-b5fa-4bc5-b106-bd24443762cf','state changed','1.yaml',NULL,NULL),(952,'3cee00bc-c9d2-4c56-addf-3cc7658b6b60','7cebc90a-b5fa-4bc5-b106-bd24443762cf','2026-01-21 11:52:20',NULL,'DELETE','IN_PROGRESS','StackOutputsTest-1064902002-parent-epryjjowwecd','7cebc90a-b5fa-4bc5-b106-bd24443762cf','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(953,'3463cdb0-ee8e-4ac4-9c15-2d502d07899d','7cebc90a-b5fa-4bc5-b106-bd24443762cf','2026-01-21 11:52:20',NULL,'DELETE','IN_PROGRESS','test_resource_b','StackOutputsTest-1064902002-parent-epryjjowwecd-test_resource_b-6quweuei7t4c','state changed','OS::Heat::TestResource',NULL,147),(954,'35b01dfc-1b5e-4ee7-a985-cf51dd68ebe0','7cebc90a-b5fa-4bc5-b106-bd24443762cf','2026-01-21 11:52:20',NULL,'DELETE','COMPLETE','test_resource_b','StackOutputsTest-1064902002-parent-epryjjowwecd-test_resource_b-6quweuei7t4c','state changed','OS::Heat::TestResource',NULL,147),(955,'bc627d97-10a9-49b0-a914-ad99f046e135','7cebc90a-b5fa-4bc5-b106-bd24443762cf','2026-01-21 11:52:21',NULL,'DELETE','IN_PROGRESS','test_resource_a','StackOutputsTest-1064902002-parent-epryjjowwecd-test_resource_a-ch6p3qvaak7g','state changed','OS::Heat::TestResource',NULL,149),(956,'5fb5a24b-8fb6-4e96-9d37-71e91da63373','7cebc90a-b5fa-4bc5-b106-bd24443762cf','2026-01-21 11:52:21',NULL,'DELETE','COMPLETE','test_resource_a','StackOutputsTest-1064902002-parent-epryjjowwecd-test_resource_a-ch6p3qvaak7g','state changed','OS::Heat::TestResource',NULL,149),(957,'8e70a76e-a7cf-4bf0-ab3c-f8458adeae62','5968210c-61dd-41e0-9ccc-cc2eed2e9966','2026-01-21 11:52:21',NULL,'CREATE','COMPLETE','server','0ec61f11-f224-4b9c-bb32-0e6c96145fec','state changed','OS::Nova::Server',NULL,148),(958,'61052073-03d7-4969-8c47-d010147511a7','7cebc90a-b5fa-4bc5-b106-bd24443762cf','2026-01-21 11:52:21',NULL,'DELETE','COMPLETE','StackOutputsTest-1064902002-parent-epryjjowwecd','7cebc90a-b5fa-4bc5-b106-bd24443762cf','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(959,'0c79fbd4-872a-4834-993b-7607d2ecee8a','5968210c-61dd-41e0-9ccc-cc2eed2e9966','2026-01-21 11:52:21',NULL,'CREATE','COMPLETE','add_network','5968210c-61dd-41e0-9ccc-cc2eed2e9966','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(960,'c3dca086-7939-4d75-8682-42a2cb54be0e','9afef6c4-848e-486f-9d8b-33162651be74','2026-01-21 11:52:25',NULL,'DELETE','COMPLETE','parent','7cebc90a-b5fa-4bc5-b106-bd24443762cf','state changed','1.yaml',NULL,NULL),(961,'f1e27a38-15c0-4101-bc52-f830c0ec2aea','9afef6c4-848e-486f-9d8b-33162651be74','2026-01-21 11:52:26',NULL,'DELETE','COMPLETE','StackOutputsTest-1064902002','9afef6c4-848e-486f-9d8b-33162651be74','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(962,'3c181e43-0904-408b-a5bd-cead8f238387','5968210c-61dd-41e0-9ccc-cc2eed2e9966','2026-01-21 11:52:28',NULL,'UPDATE','IN_PROGRESS','add_network','5968210c-61dd-41e0-9ccc-cc2eed2e9966','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(963,'2c9c4004-49cb-462c-859c-2ed9fe0772f7','5968210c-61dd-41e0-9ccc-cc2eed2e9966','2026-01-21 11:52:29',NULL,'UPDATE','IN_PROGRESS','server','0ec61f11-f224-4b9c-bb32-0e6c96145fec','state changed','OS::Nova::Server',NULL,148),(964,'e6191695-671c-4bfc-9ccd-e4fefc1f1eaa','67d0c244-c3d1-431e-8c3b-b008ec050d70','2026-01-21 11:52:31',NULL,'CREATE','IN_PROGRESS','StackOutputsTest-223675962','67d0c244-c3d1-431e-8c3b-b008ec050d70','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(965,'586604d3-ca8d-4ec4-8176-622a2e5dc569','67d0c244-c3d1-431e-8c3b-b008ec050d70','2026-01-21 11:52:31',NULL,'CREATE','IN_PROGRESS','test_resource_a','StackOutputsTest-223675962-test_resource_a-hk46nyf2r7xk','state changed','OS::Heat::TestResource',NULL,152),(966,'3aafb580-8bd5-4dc6-832b-15ccc91d078d','67d0c244-c3d1-431e-8c3b-b008ec050d70','2026-01-21 11:52:31',NULL,'CREATE','COMPLETE','test_resource_a','StackOutputsTest-223675962-test_resource_a-hk46nyf2r7xk','state changed','OS::Heat::TestResource',NULL,152),(967,'6e9526a4-de64-4259-a567-11ea34826d66','5968210c-61dd-41e0-9ccc-cc2eed2e9966','2026-01-21 11:52:31',NULL,'UPDATE','COMPLETE','server','0ec61f11-f224-4b9c-bb32-0e6c96145fec','state changed','OS::Nova::Server',NULL,153),(968,'4c0740d5-a8a5-45b7-96f5-e96bb7771169','5968210c-61dd-41e0-9ccc-cc2eed2e9966','2026-01-21 11:52:31',NULL,'UPDATE','COMPLETE','add_network','5968210c-61dd-41e0-9ccc-cc2eed2e9966','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(969,'4eba1006-cce9-4a4f-b422-05d04fdab03f','67d0c244-c3d1-431e-8c3b-b008ec050d70','2026-01-21 11:52:32',NULL,'CREATE','IN_PROGRESS','test_resource_b','StackOutputsTest-223675962-test_resource_b-iiexuginho45','state changed','OS::Heat::TestResource',NULL,154),(970,'00e91d72-33cb-4b4e-8a3e-cc6dbd391bde','67d0c244-c3d1-431e-8c3b-b008ec050d70','2026-01-21 11:52:32',NULL,'CREATE','COMPLETE','test_resource_b','StackOutputsTest-223675962-test_resource_b-iiexuginho45','state changed','OS::Heat::TestResource',NULL,154),(971,'3b018510-ea98-4bd9-aff9-42ef867de34e','67d0c244-c3d1-431e-8c3b-b008ec050d70','2026-01-21 11:52:32',NULL,'CREATE','COMPLETE','StackOutputsTest-223675962','67d0c244-c3d1-431e-8c3b-b008ec050d70','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(972,'7f9cbe3f-4525-4471-9d8b-59e854042134','5968210c-61dd-41e0-9ccc-cc2eed2e9966','2026-01-21 11:52:33',NULL,'DELETE','IN_PROGRESS','add_network','5968210c-61dd-41e0-9ccc-cc2eed2e9966','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(973,'2b2e25a9-2fd1-4ba0-8b1f-b73d37032a4e','5968210c-61dd-41e0-9ccc-cc2eed2e9966','2026-01-21 11:52:33',NULL,'DELETE','IN_PROGRESS','server','0ec61f11-f224-4b9c-bb32-0e6c96145fec','state changed','OS::Nova::Server',NULL,153),(974,'2991570d-fcb0-47f4-be49-f62a1c2b1fc3','67d0c244-c3d1-431e-8c3b-b008ec050d70','2026-01-21 11:52:36',NULL,'DELETE','IN_PROGRESS','StackOutputsTest-223675962','67d0c244-c3d1-431e-8c3b-b008ec050d70','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(975,'0641b7ed-2c91-4610-8b2f-0065b6c18dde','67d0c244-c3d1-431e-8c3b-b008ec050d70','2026-01-21 11:52:36',NULL,'DELETE','IN_PROGRESS','test_resource_a','StackOutputsTest-223675962-test_resource_a-hk46nyf2r7xk','state changed','OS::Heat::TestResource',NULL,152),(976,'2044d352-9485-44bd-99bf-53d11aa07bd7','67d0c244-c3d1-431e-8c3b-b008ec050d70','2026-01-21 11:52:36',NULL,'DELETE','COMPLETE','test_resource_a','StackOutputsTest-223675962-test_resource_a-hk46nyf2r7xk','state changed','OS::Heat::TestResource',NULL,152),(977,'43bf066b-6f6f-41c5-baf3-05b84485345c','5968210c-61dd-41e0-9ccc-cc2eed2e9966','2026-01-21 11:52:37',NULL,'DELETE','COMPLETE','server','0ec61f11-f224-4b9c-bb32-0e6c96145fec','state changed','OS::Nova::Server',NULL,153),(978,'b8fab000-9c62-4faf-8a3c-ff10e95584f4','67d0c244-c3d1-431e-8c3b-b008ec050d70','2026-01-21 11:52:37',NULL,'DELETE','IN_PROGRESS','test_resource_b','StackOutputsTest-223675962-test_resource_b-iiexuginho45','state changed','OS::Heat::TestResource',NULL,154),(979,'1d17cda2-2212-4883-a6d4-1e7bdc6dc1bd','67d0c244-c3d1-431e-8c3b-b008ec050d70','2026-01-21 11:52:37',NULL,'DELETE','COMPLETE','test_resource_b','StackOutputsTest-223675962-test_resource_b-iiexuginho45','state changed','OS::Heat::TestResource',NULL,154),(980,'3fdd1273-ac62-4981-8eea-5b268e6fc6a6','5968210c-61dd-41e0-9ccc-cc2eed2e9966','2026-01-21 11:52:37',NULL,'DELETE','IN_PROGRESS','subnet','ecc340ac-bffe-4d60-8aa4-e23dba086c69','state changed','OS::Neutron::Subnet',NULL,146),(981,'9be56f64-9c38-4088-93a5-0aed19c0ce0c','67d0c244-c3d1-431e-8c3b-b008ec050d70','2026-01-21 11:52:37',NULL,'DELETE','COMPLETE','StackOutputsTest-223675962','67d0c244-c3d1-431e-8c3b-b008ec050d70','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(982,'d2535d1a-9ad8-4690-941c-835cb35b5c84','5968210c-61dd-41e0-9ccc-cc2eed2e9966','2026-01-21 11:52:38',NULL,'DELETE','COMPLETE','subnet','ecc340ac-bffe-4d60-8aa4-e23dba086c69','state changed','OS::Neutron::Subnet',NULL,146),(983,'1487f43a-64f5-4aab-97cc-ba7d0668f90a','5968210c-61dd-41e0-9ccc-cc2eed2e9966','2026-01-21 11:52:38',NULL,'DELETE','IN_PROGRESS','net','050e2666-0245-43ea-8b8d-0dcb88a82b55','state changed','OS::Neutron::Net',NULL,145),(984,'d861fe28-0f0b-46d2-a824-f5f7cac14d23','5968210c-61dd-41e0-9ccc-cc2eed2e9966','2026-01-21 11:52:38',NULL,'DELETE','COMPLETE','net','050e2666-0245-43ea-8b8d-0dcb88a82b55','state changed','OS::Neutron::Net',NULL,145),(985,'53c04917-e3b8-4fbc-93b1-24407b02b8bc','5968210c-61dd-41e0-9ccc-cc2eed2e9966','2026-01-21 11:52:38',NULL,'DELETE','COMPLETE','add_network','5968210c-61dd-41e0-9ccc-cc2eed2e9966','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(986,'6aeaaf4b-5b6b-486a-8ad1-dc95745df39f','cdcc3a60-4faa-4773-973d-f221a24e87ae','2026-01-21 11:52:41',NULL,'CREATE','IN_PROGRESS','StackOutputsTest-168968450','cdcc3a60-4faa-4773-973d-f221a24e87ae','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(987,'45d2cd34-b117-490c-85c4-6569be5c8d6a','cdcc3a60-4faa-4773-973d-f221a24e87ae','2026-01-21 11:52:41',NULL,'CREATE','IN_PROGRESS','test_resource_a','StackOutputsTest-168968450-test_resource_a-5cnnqhl6l3qo','state changed','OS::Heat::TestResource',NULL,156),(988,'56c8a610-1299-466d-9a23-f517ac8ebc06','cdcc3a60-4faa-4773-973d-f221a24e87ae','2026-01-21 11:52:41',NULL,'CREATE','COMPLETE','test_resource_a','StackOutputsTest-168968450-test_resource_a-5cnnqhl6l3qo','state changed','OS::Heat::TestResource',NULL,156),(989,'7fbf88d9-21fe-451c-8d34-8ab174e87004','cdcc3a60-4faa-4773-973d-f221a24e87ae','2026-01-21 11:52:41',NULL,'CREATE','COMPLETE','StackOutputsTest-168968450','cdcc3a60-4faa-4773-973d-f221a24e87ae','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(990,'612c49b0-bd09-480e-86c9-dfb664f67e79','cdcc3a60-4faa-4773-973d-f221a24e87ae','2026-01-21 11:52:44',NULL,'UPDATE','IN_PROGRESS','StackOutputsTest-168968450','cdcc3a60-4faa-4773-973d-f221a24e87ae','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(991,'b3207ed0-0f86-44f3-9948-3b45a7e5c0d2','cdcc3a60-4faa-4773-973d-f221a24e87ae','2026-01-21 11:52:45',NULL,'CREATE','IN_PROGRESS','test_resource_b','StackOutputsTest-168968450-test_resource_b-o4n4f7f2hu5v','state changed','OS::Heat::TestResource',NULL,157),(992,'8409baba-89a7-4e1a-a7f8-b96d0500bbf0','cdcc3a60-4faa-4773-973d-f221a24e87ae','2026-01-21 11:52:45',NULL,'CREATE','COMPLETE','test_resource_b','StackOutputsTest-168968450-test_resource_b-o4n4f7f2hu5v','state changed','OS::Heat::TestResource',NULL,157),(993,'8d4d4282-e730-4e34-9258-a2322c62069c','cdcc3a60-4faa-4773-973d-f221a24e87ae','2026-01-21 11:52:45',NULL,'UPDATE','COMPLETE','StackOutputsTest-168968450','cdcc3a60-4faa-4773-973d-f221a24e87ae','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(994,'d899627a-f9dd-43aa-b034-5728948c4585','2c704a7d-00e4-4953-a7e6-24ed6a857da0','2026-01-21 11:52:46',NULL,'CREATE','IN_PROGRESS','same_fixed_ip','2c704a7d-00e4-4953-a7e6-24ed6a857da0','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(995,'342be20a-793e-43c4-a49a-3370a44c7008','2c704a7d-00e4-4953-a7e6-24ed6a857da0','2026-01-21 11:52:46',NULL,'CREATE','IN_PROGRESS','net','same_fixed_ip-net-dkz4vo3s73n7','state changed','OS::Neutron::Net',NULL,158),(996,'3a6a46ff-4133-44ac-9137-1238bc78534f','2c704a7d-00e4-4953-a7e6-24ed6a857da0','2026-01-21 11:52:47',NULL,'CREATE','COMPLETE','net','b50afd0d-c012-4629-b497-6fd1b5e6d0c9','state changed','OS::Neutron::Net',NULL,158),(997,'3bc65694-0f9f-4b6a-9abd-354b67d4cca2','2c704a7d-00e4-4953-a7e6-24ed6a857da0','2026-01-21 11:52:47',NULL,'CREATE','IN_PROGRESS','subnet','same_fixed_ip-subnet-dc7qvhtk5wca','state changed','OS::Neutron::Subnet',NULL,159),(998,'d57b27ea-fd01-4536-a7a0-545f116bae51','2c704a7d-00e4-4953-a7e6-24ed6a857da0','2026-01-21 11:52:48',NULL,'CREATE','COMPLETE','subnet','f2bb0338-2051-4b73-946a-09367050033d','state changed','OS::Neutron::Subnet',NULL,159),(999,'f5ee3e75-567a-416b-9c99-8a7e56c92a9a','2c704a7d-00e4-4953-a7e6-24ed6a857da0','2026-01-21 11:52:48',NULL,'CREATE','IN_PROGRESS','server','same_fixed_ip-server-xk22trqaiuuh','state changed','OS::Nova::Server',NULL,160),(1000,'4308bc6d-96df-41ff-940e-b8f49049ca9d','cdcc3a60-4faa-4773-973d-f221a24e87ae','2026-01-21 11:52:49',NULL,'DELETE','IN_PROGRESS','StackOutputsTest-168968450','cdcc3a60-4faa-4773-973d-f221a24e87ae','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1001,'7042b6f6-3e03-4bf5-b86f-282dad0221c8','cdcc3a60-4faa-4773-973d-f221a24e87ae','2026-01-21 11:52:49',NULL,'DELETE','IN_PROGRESS','test_resource_b','StackOutputsTest-168968450-test_resource_b-o4n4f7f2hu5v','state changed','OS::Heat::TestResource',NULL,157),(1002,'d5f9fed3-5054-44df-be8d-4cbb032cd3f2','cdcc3a60-4faa-4773-973d-f221a24e87ae','2026-01-21 11:52:49',NULL,'DELETE','COMPLETE','test_resource_b','StackOutputsTest-168968450-test_resource_b-o4n4f7f2hu5v','state changed','OS::Heat::TestResource',NULL,157),(1003,'b7302800-3e0f-4d66-9932-101e63e69b20','cdcc3a60-4faa-4773-973d-f221a24e87ae','2026-01-21 11:52:49',NULL,'DELETE','IN_PROGRESS','test_resource_a','StackOutputsTest-168968450-test_resource_a-5cnnqhl6l3qo','state changed','OS::Heat::TestResource',NULL,156),(1004,'0c159eb5-78d9-4338-8107-085549489922','cdcc3a60-4faa-4773-973d-f221a24e87ae','2026-01-21 11:52:49',NULL,'DELETE','COMPLETE','test_resource_a','StackOutputsTest-168968450-test_resource_a-5cnnqhl6l3qo','state changed','OS::Heat::TestResource',NULL,156),(1005,'e2b8b1c0-a69f-4f8a-a8a4-4c5e847f61b9','cdcc3a60-4faa-4773-973d-f221a24e87ae','2026-01-21 11:52:50',NULL,'DELETE','COMPLETE','StackOutputsTest-168968450','cdcc3a60-4faa-4773-973d-f221a24e87ae','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1006,'bcc5096a-dba6-4384-ac92-6f4004d475a1','0fc99612-a45e-481b-bc93-1eb90201b6cf','2026-01-21 11:52:55',NULL,'CREATE','IN_PROGRESS','StackTagTest-983706630','0fc99612-a45e-481b-bc93-1eb90201b6cf','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1007,'d10e61dc-5f60-44a6-8965-cc461debc3b8','0fc99612-a45e-481b-bc93-1eb90201b6cf','2026-01-21 11:52:55',NULL,'CREATE','IN_PROGRESS','not-used','StackTagTest-983706630-not-used-zt4h7mphhxuk','state changed','OS::Heat::TestResource',NULL,161),(1008,'d08f7617-71d8-4878-b08e-35689cb2f3e8','0fc99612-a45e-481b-bc93-1eb90201b6cf','2026-01-21 11:52:58',NULL,'CREATE','COMPLETE','not-used','StackTagTest-983706630-not-used-zt4h7mphhxuk','state changed','OS::Heat::TestResource',NULL,161),(1009,'c1591092-a5d5-4838-baec-ec25a79c13be','0fc99612-a45e-481b-bc93-1eb90201b6cf','2026-01-21 11:52:58',NULL,'CREATE','COMPLETE','StackTagTest-983706630','0fc99612-a45e-481b-bc93-1eb90201b6cf','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1010,'25e5d794-fafd-4750-8d05-a323a24215a9','2c704a7d-00e4-4953-a7e6-24ed6a857da0','2026-01-21 11:52:58',NULL,'CREATE','COMPLETE','server','2ae4866a-95a9-4281-8e7c-0a14f0c3e323','state changed','OS::Nova::Server',NULL,160),(1011,'b2dec470-b1ab-448e-9312-5f0f9c26266d','2c704a7d-00e4-4953-a7e6-24ed6a857da0','2026-01-21 11:52:58',NULL,'CREATE','COMPLETE','same_fixed_ip','2c704a7d-00e4-4953-a7e6-24ed6a857da0','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1012,'18ae9747-3b47-4e3d-9972-8812f45a0054','0fc99612-a45e-481b-bc93-1eb90201b6cf','2026-01-21 11:53:00',NULL,'DELETE','IN_PROGRESS','StackTagTest-983706630','0fc99612-a45e-481b-bc93-1eb90201b6cf','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1013,'09b86f37-b30a-4c34-add7-7056e0e9edf5','0fc99612-a45e-481b-bc93-1eb90201b6cf','2026-01-21 11:53:00',NULL,'DELETE','IN_PROGRESS','not-used','StackTagTest-983706630-not-used-zt4h7mphhxuk','state changed','OS::Heat::TestResource',NULL,161),(1014,'0403ed7a-c6e8-400b-bdb4-193c50a38431','0fc99612-a45e-481b-bc93-1eb90201b6cf','2026-01-21 11:53:02',NULL,'DELETE','COMPLETE','not-used','StackTagTest-983706630-not-used-zt4h7mphhxuk','state changed','OS::Heat::TestResource',NULL,161),(1015,'cd8f2367-2e12-4bbc-9cce-865d3717320e','0fc99612-a45e-481b-bc93-1eb90201b6cf','2026-01-21 11:53:02',NULL,'DELETE','COMPLETE','StackTagTest-983706630','0fc99612-a45e-481b-bc93-1eb90201b6cf','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1016,'ac605455-942e-42a1-adcc-fcb7ae516bc5','2c704a7d-00e4-4953-a7e6-24ed6a857da0','2026-01-21 11:53:03',NULL,'UPDATE','IN_PROGRESS','same_fixed_ip','2c704a7d-00e4-4953-a7e6-24ed6a857da0','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1017,'00631a95-edc3-42ea-b6de-3c7956d2a9f0','2c704a7d-00e4-4953-a7e6-24ed6a857da0','2026-01-21 11:53:03',NULL,'UPDATE','IN_PROGRESS','server','2ae4866a-95a9-4281-8e7c-0a14f0c3e323','state changed','OS::Nova::Server',NULL,160),(1018,'9c2aed52-5d2b-49a7-a5bf-4d5b628d4df1','339ac678-d09b-40f7-aa91-2b81781b6554','2026-01-21 11:53:05',NULL,'CREATE','IN_PROGRESS','StackTagTest-435937917','339ac678-d09b-40f7-aa91-2b81781b6554','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1019,'e14e2db9-b1a1-49a6-8cd6-90abfd1d96fc','339ac678-d09b-40f7-aa91-2b81781b6554','2026-01-21 11:53:05',NULL,'CREATE','IN_PROGRESS','not-used','StackTagTest-435937917-not-used-gqhyqoqfmxqq','state changed','OS::Heat::TestResource',NULL,163),(1020,'235ea597-b199-4ed0-8585-1c15b83eee2a','2c704a7d-00e4-4953-a7e6-24ed6a857da0','2026-01-21 11:53:05',NULL,'UPDATE','COMPLETE','server','2ae4866a-95a9-4281-8e7c-0a14f0c3e323','state changed','OS::Nova::Server',NULL,164),(1021,'eee2ba1e-abbb-4b19-b8f5-c8a6270fa844','2c704a7d-00e4-4953-a7e6-24ed6a857da0','2026-01-21 11:53:05',NULL,'UPDATE','COMPLETE','same_fixed_ip','2c704a7d-00e4-4953-a7e6-24ed6a857da0','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1022,'53c8f2b4-ce0f-42f2-a8a9-0cce17b75e4f','339ac678-d09b-40f7-aa91-2b81781b6554','2026-01-21 11:53:08',NULL,'CREATE','COMPLETE','not-used','StackTagTest-435937917-not-used-gqhyqoqfmxqq','state changed','OS::Heat::TestResource',NULL,163),(1023,'bc49f5d1-36ec-472b-be9e-9dcacec9820f','339ac678-d09b-40f7-aa91-2b81781b6554','2026-01-21 11:53:08',NULL,'CREATE','COMPLETE','StackTagTest-435937917','339ac678-d09b-40f7-aa91-2b81781b6554','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1024,'adacf010-241f-4413-99e7-d0e2d64e1996','2c704a7d-00e4-4953-a7e6-24ed6a857da0','2026-01-21 11:53:10',NULL,'DELETE','IN_PROGRESS','same_fixed_ip','2c704a7d-00e4-4953-a7e6-24ed6a857da0','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1025,'70e235c3-b0cd-4d04-be6c-ac09435b1350','2c704a7d-00e4-4953-a7e6-24ed6a857da0','2026-01-21 11:53:10',NULL,'DELETE','IN_PROGRESS','server','2ae4866a-95a9-4281-8e7c-0a14f0c3e323','state changed','OS::Nova::Server',NULL,164),(1026,'3198bd9f-24ba-43e7-b066-de297cf9f9de','339ac678-d09b-40f7-aa91-2b81781b6554','2026-01-21 11:53:10',NULL,'UPDATE','IN_PROGRESS','StackTagTest-435937917','339ac678-d09b-40f7-aa91-2b81781b6554','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1027,'5689de65-a328-4482-ada6-479ac9f862fa','339ac678-d09b-40f7-aa91-2b81781b6554','2026-01-21 11:53:10',NULL,'UPDATE','IN_PROGRESS','not-used','StackTagTest-435937917-not-used-gqhyqoqfmxqq','state changed','OS::Heat::TestResource',NULL,163),(1028,'2e58545c-853d-4f88-bc03-e2ef0edc63a3','339ac678-d09b-40f7-aa91-2b81781b6554','2026-01-21 11:53:12',NULL,'UPDATE','COMPLETE','not-used','StackTagTest-435937917-not-used-gqhyqoqfmxqq','state changed','OS::Heat::TestResource',NULL,166),(1029,'dcdeb4b1-278b-4196-a7df-c05510f48fe7','339ac678-d09b-40f7-aa91-2b81781b6554','2026-01-21 11:53:12',NULL,'UPDATE','COMPLETE','StackTagTest-435937917','339ac678-d09b-40f7-aa91-2b81781b6554','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1030,'e81a68a2-cb84-46aa-b5da-98f3f38b58fa','2c704a7d-00e4-4953-a7e6-24ed6a857da0','2026-01-21 11:53:12',NULL,'DELETE','COMPLETE','server','2ae4866a-95a9-4281-8e7c-0a14f0c3e323','state changed','OS::Nova::Server',NULL,164),(1031,'d04ee23f-338b-4d76-88ec-d983e3cf06fb','2c704a7d-00e4-4953-a7e6-24ed6a857da0','2026-01-21 11:53:12',NULL,'DELETE','IN_PROGRESS','subnet','f2bb0338-2051-4b73-946a-09367050033d','state changed','OS::Neutron::Subnet',NULL,159),(1032,'60a13e23-e247-4d53-a6b9-b8d2936c1bbc','2c704a7d-00e4-4953-a7e6-24ed6a857da0','2026-01-21 11:53:13',NULL,'DELETE','COMPLETE','subnet','f2bb0338-2051-4b73-946a-09367050033d','state changed','OS::Neutron::Subnet',NULL,159),(1033,'e00840c1-3007-4eb0-81f2-942bfae3e563','2c704a7d-00e4-4953-a7e6-24ed6a857da0','2026-01-21 11:53:13',NULL,'DELETE','IN_PROGRESS','net','b50afd0d-c012-4629-b497-6fd1b5e6d0c9','state changed','OS::Neutron::Net',NULL,158),(1034,'d91b5082-69aa-4ed4-9adf-d77728add199','2c704a7d-00e4-4953-a7e6-24ed6a857da0','2026-01-21 11:53:14',NULL,'DELETE','COMPLETE','net','b50afd0d-c012-4629-b497-6fd1b5e6d0c9','state changed','OS::Neutron::Net',NULL,158),(1035,'7b3e0618-b6a0-4c50-a725-34e71b6956fd','2c704a7d-00e4-4953-a7e6-24ed6a857da0','2026-01-21 11:53:14',NULL,'DELETE','COMPLETE','same_fixed_ip','2c704a7d-00e4-4953-a7e6-24ed6a857da0','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1036,'b396f24c-9a94-4db7-ba73-17f483593bdf','339ac678-d09b-40f7-aa91-2b81781b6554','2026-01-21 11:53:15',NULL,'UPDATE','IN_PROGRESS','StackTagTest-435937917','339ac678-d09b-40f7-aa91-2b81781b6554','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1037,'efb2a020-1610-4cc8-a15b-ebe831274d71','339ac678-d09b-40f7-aa91-2b81781b6554','2026-01-21 11:53:15',NULL,'UPDATE','IN_PROGRESS','not-used','StackTagTest-435937917-not-used-gqhyqoqfmxqq','state changed','OS::Heat::TestResource',NULL,166),(1038,'e5fb966b-1059-4803-8a5e-eba23740b060','339ac678-d09b-40f7-aa91-2b81781b6554','2026-01-21 11:53:17',NULL,'UPDATE','COMPLETE','not-used','StackTagTest-435937917-not-used-gqhyqoqfmxqq','state changed','OS::Heat::TestResource',NULL,167),(1039,'8dfa5a87-0149-4832-92f3-5b9a4ad9c4ad','339ac678-d09b-40f7-aa91-2b81781b6554','2026-01-21 11:53:17',NULL,'UPDATE','COMPLETE','StackTagTest-435937917','339ac678-d09b-40f7-aa91-2b81781b6554','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1040,'d3b0e2d1-5c16-46f7-b79b-390b059dc862','339ac678-d09b-40f7-aa91-2b81781b6554','2026-01-21 11:53:19',NULL,'DELETE','IN_PROGRESS','StackTagTest-435937917','339ac678-d09b-40f7-aa91-2b81781b6554','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1041,'7db0a601-20e1-4765-ab71-9f79dd1e5d7a','339ac678-d09b-40f7-aa91-2b81781b6554','2026-01-21 11:53:19',NULL,'DELETE','IN_PROGRESS','not-used','StackTagTest-435937917-not-used-gqhyqoqfmxqq','state changed','OS::Heat::TestResource',NULL,167),(1042,'9ad68fe9-340f-4ec5-a587-0c5ae93d0b66','b338b76c-9675-4bf8-b895-c4c328d3d3f1','2026-01-21 11:53:21',NULL,'CREATE','IN_PROGRESS','add_subnet','b338b76c-9675-4bf8-b895-c4c328d3d3f1','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1043,'83b7591d-5186-488b-973f-806f3e09878f','b338b76c-9675-4bf8-b895-c4c328d3d3f1','2026-01-21 11:53:21',NULL,'CREATE','IN_PROGRESS','net','add_subnet-net-w6jkbjyv2yxi','state changed','OS::Neutron::Net',NULL,168),(1044,'86b87916-8027-4cc7-a1aa-197baec94c38','339ac678-d09b-40f7-aa91-2b81781b6554','2026-01-21 11:53:22',NULL,'DELETE','COMPLETE','not-used','StackTagTest-435937917-not-used-gqhyqoqfmxqq','state changed','OS::Heat::TestResource',NULL,167),(1045,'18a52076-f4e4-41cd-af5b-1d318404a781','339ac678-d09b-40f7-aa91-2b81781b6554','2026-01-21 11:53:22',NULL,'DELETE','COMPLETE','StackTagTest-435937917','339ac678-d09b-40f7-aa91-2b81781b6554','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1046,'34e4ac8e-931f-45ec-9795-9b3421c336f2','b338b76c-9675-4bf8-b895-c4c328d3d3f1','2026-01-21 11:53:22',NULL,'CREATE','COMPLETE','net','bd3013fb-148f-450f-beae-4553a43c068e','state changed','OS::Neutron::Net',NULL,168),(1047,'4efe2456-458f-4e2e-b530-0aa9f39bf329','b338b76c-9675-4bf8-b895-c4c328d3d3f1','2026-01-21 11:53:22',NULL,'CREATE','IN_PROGRESS','subnet','add_subnet-subnet-zoqy252rlyn2','state changed','OS::Neutron::Subnet',NULL,169),(1048,'5545e658-31cc-4507-a31e-0b8bf5d6f43d','b338b76c-9675-4bf8-b895-c4c328d3d3f1','2026-01-21 11:53:23',NULL,'CREATE','COMPLETE','subnet','de6ae73b-a2dc-4a06-aa11-d8a189215e81','state changed','OS::Neutron::Subnet',NULL,169),(1049,'cf993c2a-c35c-41c5-9006-4e848ab062df','b338b76c-9675-4bf8-b895-c4c328d3d3f1','2026-01-21 11:53:23',NULL,'CREATE','IN_PROGRESS','server','add_subnet-server-to7fwydfd2l4','state changed','OS::Nova::Server',NULL,170),(1050,'2d043863-aa18-425b-b2f7-fb3b0d107253','1a8cd320-745e-420c-8ac3-b3f6ac66f0aa','2026-01-21 11:53:25',NULL,'CREATE','IN_PROGRESS','TemplateAPITest-937944392','1a8cd320-745e-420c-8ac3-b3f6ac66f0aa','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1051,'09e126a7-6bfa-4e39-9ebf-7853c8adf550','1a8cd320-745e-420c-8ac3-b3f6ac66f0aa','2026-01-21 11:53:25',NULL,'CREATE','IN_PROGRESS','test1','TemplateAPITest-937944392-test1-wpbeklgql3tc','state changed','OS::Heat::TestResource',NULL,171),(1052,'71bf23d9-3cbc-4768-8b29-7748e0c1dbdb','1a8cd320-745e-420c-8ac3-b3f6ac66f0aa','2026-01-21 11:53:25',NULL,'CREATE','COMPLETE','test1','TemplateAPITest-937944392-test1-wpbeklgql3tc','state changed','OS::Heat::TestResource',NULL,171),(1053,'b22aabee-02c9-4231-886c-f8c9bb89a59d','1a8cd320-745e-420c-8ac3-b3f6ac66f0aa','2026-01-21 11:53:25',NULL,'CREATE','COMPLETE','TemplateAPITest-937944392','1a8cd320-745e-420c-8ac3-b3f6ac66f0aa','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1054,'94a5da22-1949-4739-b07e-575ea264f94b','1a8cd320-745e-420c-8ac3-b3f6ac66f0aa','2026-01-21 11:53:26',NULL,'DELETE','IN_PROGRESS','TemplateAPITest-937944392','1a8cd320-745e-420c-8ac3-b3f6ac66f0aa','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1055,'80904f0f-f99c-43a6-81cd-71c4d8c4982c','1a8cd320-745e-420c-8ac3-b3f6ac66f0aa','2026-01-21 11:53:26',NULL,'DELETE','IN_PROGRESS','test1','TemplateAPITest-937944392-test1-wpbeklgql3tc','state changed','OS::Heat::TestResource',NULL,171),(1056,'37ff8d81-fc78-4ada-b011-b7954f26cb15','1a8cd320-745e-420c-8ac3-b3f6ac66f0aa','2026-01-21 11:53:26',NULL,'DELETE','COMPLETE','test1','TemplateAPITest-937944392-test1-wpbeklgql3tc','state changed','OS::Heat::TestResource',NULL,171),(1057,'e8152a8f-9dca-459b-ba0e-f725bd1d975e','1a8cd320-745e-420c-8ac3-b3f6ac66f0aa','2026-01-21 11:53:26',NULL,'DELETE','COMPLETE','TemplateAPITest-937944392','1a8cd320-745e-420c-8ac3-b3f6ac66f0aa','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1058,'8022c3b1-fc0a-47bf-b15e-11912c5dd31b','b338b76c-9675-4bf8-b895-c4c328d3d3f1','2026-01-21 11:53:34',NULL,'CREATE','COMPLETE','server','e6a9a7ed-145f-4356-91c9-7237aed23168','state changed','OS::Nova::Server',NULL,170),(1059,'b98b67eb-fb8f-482b-b58c-dd9fb8451f2f','b338b76c-9675-4bf8-b895-c4c328d3d3f1','2026-01-21 11:53:34',NULL,'CREATE','COMPLETE','add_subnet','b338b76c-9675-4bf8-b895-c4c328d3d3f1','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1060,'d5f0462b-4f50-4c7b-9423-6423f780d042','b338b76c-9675-4bf8-b895-c4c328d3d3f1','2026-01-21 11:53:43',NULL,'UPDATE','IN_PROGRESS','add_subnet','b338b76c-9675-4bf8-b895-c4c328d3d3f1','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1061,'929e5cd8-195b-445d-998c-d0321b5c8c22','b338b76c-9675-4bf8-b895-c4c328d3d3f1','2026-01-21 11:53:43',NULL,'UPDATE','IN_PROGRESS','server','e6a9a7ed-145f-4356-91c9-7237aed23168','state changed','OS::Nova::Server',NULL,170),(1062,'29616e2a-90b9-453c-9504-c4919c7444dd','b338b76c-9675-4bf8-b895-c4c328d3d3f1','2026-01-21 11:53:45',NULL,'UPDATE','COMPLETE','server','e6a9a7ed-145f-4356-91c9-7237aed23168','state changed','OS::Nova::Server',NULL,173),(1063,'7fb6da48-321e-42d8-a04d-73193fdd6c6b','b338b76c-9675-4bf8-b895-c4c328d3d3f1','2026-01-21 11:53:45',NULL,'UPDATE','COMPLETE','add_subnet','b338b76c-9675-4bf8-b895-c4c328d3d3f1','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1064,'dfd12244-57cf-431e-8c94-ecfc8a024265','b338b76c-9675-4bf8-b895-c4c328d3d3f1','2026-01-21 11:53:48',NULL,'DELETE','IN_PROGRESS','add_subnet','b338b76c-9675-4bf8-b895-c4c328d3d3f1','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1065,'c530a038-a6f4-4ed6-bfda-7e6bea329e95','b338b76c-9675-4bf8-b895-c4c328d3d3f1','2026-01-21 11:53:48',NULL,'DELETE','IN_PROGRESS','server','e6a9a7ed-145f-4356-91c9-7237aed23168','state changed','OS::Nova::Server',NULL,173),(1066,'b736dea3-3971-4dfb-834f-bfbca35a92d3','b338b76c-9675-4bf8-b895-c4c328d3d3f1','2026-01-21 11:53:50',NULL,'DELETE','COMPLETE','server','e6a9a7ed-145f-4356-91c9-7237aed23168','state changed','OS::Nova::Server',NULL,173),(1067,'eeabe7de-78ea-4191-b933-3ac5c579828f','b338b76c-9675-4bf8-b895-c4c328d3d3f1','2026-01-21 11:53:50',NULL,'DELETE','IN_PROGRESS','subnet','de6ae73b-a2dc-4a06-aa11-d8a189215e81','state changed','OS::Neutron::Subnet',NULL,169),(1068,'e833f0de-e44b-4afa-83b4-229b17869602','b338b76c-9675-4bf8-b895-c4c328d3d3f1','2026-01-21 11:53:50',NULL,'DELETE','COMPLETE','subnet','de6ae73b-a2dc-4a06-aa11-d8a189215e81','state changed','OS::Neutron::Subnet',NULL,169),(1069,'3cb22e2f-9af6-494f-a0b4-bad3a673d0a1','b338b76c-9675-4bf8-b895-c4c328d3d3f1','2026-01-21 11:53:50',NULL,'DELETE','IN_PROGRESS','net','bd3013fb-148f-450f-beae-4553a43c068e','state changed','OS::Neutron::Net',NULL,168),(1070,'8a1b36d8-ec66-42af-91ba-5646b081136e','b338b76c-9675-4bf8-b895-c4c328d3d3f1','2026-01-21 11:53:50',NULL,'DELETE','COMPLETE','net','bd3013fb-148f-450f-beae-4553a43c068e','state changed','OS::Neutron::Net',NULL,168),(1071,'40dedcca-b30e-462e-9b6a-a59b21407492','b338b76c-9675-4bf8-b895-c4c328d3d3f1','2026-01-21 11:53:50',NULL,'DELETE','COMPLETE','add_subnet','b338b76c-9675-4bf8-b895-c4c328d3d3f1','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1072,'33559efe-cc24-4ba1-914b-e5362e5baed2','ef69d52b-7819-4054-8568-13b5bbba11f5','2026-01-21 11:53:55',NULL,'CREATE','IN_PROGRESS','multi_networks_swaps','ef69d52b-7819-4054-8568-13b5bbba11f5','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1073,'8a725eb4-bf04-40c0-b2ce-3baae5abe768','ef69d52b-7819-4054-8568-13b5bbba11f5','2026-01-21 11:53:55',NULL,'CREATE','IN_PROGRESS','net','multi_networks_swaps-net-4m6effqabhbd','state changed','OS::Neutron::Net',NULL,175),(1074,'cf55e089-b0ac-408b-8e7e-141381a17d11','ef69d52b-7819-4054-8568-13b5bbba11f5','2026-01-21 11:53:56',NULL,'CREATE','COMPLETE','net','b6c655e3-0f07-4e83-be80-7e54d04ecd04','state changed','OS::Neutron::Net',NULL,175),(1075,'09ddd5cf-4000-462e-b3be-121a6ae103d3','ef69d52b-7819-4054-8568-13b5bbba11f5','2026-01-21 11:53:56',NULL,'CREATE','IN_PROGRESS','subnet','multi_networks_swaps-subnet-lpucwmelkzsa','state changed','OS::Neutron::Subnet',NULL,176),(1076,'5eba44bf-cc94-464c-a035-f6f1a5a8743a','ef69d52b-7819-4054-8568-13b5bbba11f5','2026-01-21 11:53:57',NULL,'CREATE','COMPLETE','subnet','219f2f0a-5f6d-4e87-bb0c-8ea3653944cb','state changed','OS::Neutron::Subnet',NULL,176),(1077,'d0ef2b01-2cc5-4774-9c5b-583a37560f52','ef69d52b-7819-4054-8568-13b5bbba11f5','2026-01-21 11:53:57',NULL,'CREATE','IN_PROGRESS','server','multi_networks_swaps-server-af3bfnxiffem','state changed','OS::Nova::Server',NULL,177),(1078,'e7e2ff9f-47aa-4d49-b509-fbe8d4e921c4','ef69d52b-7819-4054-8568-13b5bbba11f5','2026-01-21 11:54:10',NULL,'CREATE','COMPLETE','server','859f5add-b553-45cc-91af-3f51c4c2fd64','state changed','OS::Nova::Server',NULL,177),(1079,'0f183f71-c1bd-42c6-a680-5249ce6b117f','ef69d52b-7819-4054-8568-13b5bbba11f5','2026-01-21 11:54:10',NULL,'CREATE','COMPLETE','multi_networks_swaps','ef69d52b-7819-4054-8568-13b5bbba11f5','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1080,'7d43c07e-606b-4afd-b8b5-74c150aacc33','ef69d52b-7819-4054-8568-13b5bbba11f5','2026-01-21 11:54:15',NULL,'UPDATE','IN_PROGRESS','multi_networks_swaps','ef69d52b-7819-4054-8568-13b5bbba11f5','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1081,'0815d8ae-54a2-4fca-ba11-2af0f3b90691','ef69d52b-7819-4054-8568-13b5bbba11f5','2026-01-21 11:54:15',NULL,'UPDATE','IN_PROGRESS','server','859f5add-b553-45cc-91af-3f51c4c2fd64','state changed','OS::Nova::Server',NULL,177),(1082,'625210da-593e-4fe1-817a-a0aa7660d5ad','ef69d52b-7819-4054-8568-13b5bbba11f5','2026-01-21 11:54:17',NULL,'UPDATE','COMPLETE','server','859f5add-b553-45cc-91af-3f51c4c2fd64','state changed','OS::Nova::Server',NULL,179),(1083,'e49dbd7c-e5df-4355-abe8-a1b9b67f042b','ef69d52b-7819-4054-8568-13b5bbba11f5','2026-01-21 11:54:18',NULL,'UPDATE','COMPLETE','multi_networks_swaps','ef69d52b-7819-4054-8568-13b5bbba11f5','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1084,'ae3891b5-4b45-45fc-941a-b02a2d815ac3','ef69d52b-7819-4054-8568-13b5bbba11f5','2026-01-21 11:54:24',NULL,'DELETE','IN_PROGRESS','multi_networks_swaps','ef69d52b-7819-4054-8568-13b5bbba11f5','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1085,'1ac7da4f-d47c-412b-98a4-544132373be7','ef69d52b-7819-4054-8568-13b5bbba11f5','2026-01-21 11:54:24',NULL,'DELETE','IN_PROGRESS','server','859f5add-b553-45cc-91af-3f51c4c2fd64','state changed','OS::Nova::Server',NULL,179),(1086,'a5e70b95-6af6-403a-9c44-8ac780393407','ef69d52b-7819-4054-8568-13b5bbba11f5','2026-01-21 11:54:26',NULL,'DELETE','COMPLETE','server','859f5add-b553-45cc-91af-3f51c4c2fd64','state changed','OS::Nova::Server',NULL,179),(1087,'5c12c942-119e-4935-9dde-03f0dc667f50','ef69d52b-7819-4054-8568-13b5bbba11f5','2026-01-21 11:54:26',NULL,'DELETE','IN_PROGRESS','subnet','219f2f0a-5f6d-4e87-bb0c-8ea3653944cb','state changed','OS::Neutron::Subnet',NULL,176),(1088,'65638520-3eef-4340-9917-9265cf96821c','ef69d52b-7819-4054-8568-13b5bbba11f5','2026-01-21 11:54:27',NULL,'DELETE','COMPLETE','subnet','219f2f0a-5f6d-4e87-bb0c-8ea3653944cb','state changed','OS::Neutron::Subnet',NULL,176),(1089,'b7102f9a-e829-4e4c-8a98-9d0ae2618f29','ef69d52b-7819-4054-8568-13b5bbba11f5','2026-01-21 11:54:27',NULL,'DELETE','IN_PROGRESS','net','b6c655e3-0f07-4e83-be80-7e54d04ecd04','state changed','OS::Neutron::Net',NULL,175),(1090,'60fcecf6-39a3-4fbe-80cb-ec699cb2f7a1','ef69d52b-7819-4054-8568-13b5bbba11f5','2026-01-21 11:54:28',NULL,'DELETE','COMPLETE','net','b6c655e3-0f07-4e83-be80-7e54d04ecd04','state changed','OS::Neutron::Net',NULL,175),(1091,'031e48f1-fd87-4b56-82a8-9b3ca4c1ebb1','ef69d52b-7819-4054-8568-13b5bbba11f5','2026-01-21 11:54:28',NULL,'DELETE','COMPLETE','multi_networks_swaps','ef69d52b-7819-4054-8568-13b5bbba11f5','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1092,'6299bcc6-7f29-418c-b0bb-d17b593cec73','202336cd-9078-4183-8bd4-e7a0e6f7bf55','2026-01-21 11:54:35',NULL,'CREATE','IN_PROGRESS','swap_network_port','202336cd-9078-4183-8bd4-e7a0e6f7bf55','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1093,'fd0ba02d-5f9f-4140-8462-d6d521c00add','202336cd-9078-4183-8bd4-e7a0e6f7bf55','2026-01-21 11:54:35',NULL,'CREATE','IN_PROGRESS','net','swap_network_port-net-ibbky37uwehu','state changed','OS::Neutron::Net',NULL,181),(1094,'3f941e59-83a8-479c-b5d5-66ee8f5b8970','202336cd-9078-4183-8bd4-e7a0e6f7bf55','2026-01-21 11:54:36',NULL,'CREATE','COMPLETE','net','13b0d6b4-2dfe-4ce7-bdb1-ac84aa1c8758','state changed','OS::Neutron::Net',NULL,181),(1095,'f92b4feb-14fc-4192-b9ae-ab0d0abe9b33','202336cd-9078-4183-8bd4-e7a0e6f7bf55','2026-01-21 11:54:36',NULL,'CREATE','IN_PROGRESS','subnet','swap_network_port-subnet-rxtmbdqlawl6','state changed','OS::Neutron::Subnet',NULL,182),(1096,'ae8026bf-e575-45a5-82ae-2522447c0e92','202336cd-9078-4183-8bd4-e7a0e6f7bf55','2026-01-21 11:54:37',NULL,'CREATE','COMPLETE','subnet','dff0677e-2641-42de-be4a-f82699e66f9f','state changed','OS::Neutron::Subnet',NULL,182),(1097,'3a02a149-ba8c-48ae-bf33-0673d7784d4d','202336cd-9078-4183-8bd4-e7a0e6f7bf55','2026-01-21 11:54:37',NULL,'CREATE','IN_PROGRESS','server','swap_network_port-server-dnz63msdr7jm','state changed','OS::Nova::Server',NULL,183),(1098,'65945231-93d2-4d68-96a0-822ce7bcc848','202336cd-9078-4183-8bd4-e7a0e6f7bf55','2026-01-21 11:54:47',NULL,'CREATE','COMPLETE','server','075faef6-789f-4911-9f89-3b040f150c74','state changed','OS::Nova::Server',NULL,183),(1099,'76258f68-7a9c-48a5-9703-16e1653668df','202336cd-9078-4183-8bd4-e7a0e6f7bf55','2026-01-21 11:54:47',NULL,'CREATE','COMPLETE','swap_network_port','202336cd-9078-4183-8bd4-e7a0e6f7bf55','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1100,'c0b44389-f3ae-4731-92d6-ee17fc1aab4d','202336cd-9078-4183-8bd4-e7a0e6f7bf55','2026-01-21 11:54:52',NULL,'UPDATE','IN_PROGRESS','swap_network_port','202336cd-9078-4183-8bd4-e7a0e6f7bf55','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1101,'95662108-4136-41a6-ac15-86fe8a1e176b','202336cd-9078-4183-8bd4-e7a0e6f7bf55','2026-01-21 11:54:53',NULL,'UPDATE','IN_PROGRESS','server','075faef6-789f-4911-9f89-3b040f150c74','state changed','OS::Nova::Server',NULL,183),(1102,'540c8f22-3250-4460-95cc-51f8152c800c','202336cd-9078-4183-8bd4-e7a0e6f7bf55','2026-01-21 11:54:56',NULL,'UPDATE','COMPLETE','server','075faef6-789f-4911-9f89-3b040f150c74','state changed','OS::Nova::Server',NULL,185),(1103,'9143b2a6-f464-4d5a-8a36-aa15ebbcd41b','202336cd-9078-4183-8bd4-e7a0e6f7bf55','2026-01-21 11:54:56',NULL,'UPDATE','COMPLETE','swap_network_port','202336cd-9078-4183-8bd4-e7a0e6f7bf55','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1104,'5f6d2fca-0711-4f4a-bb65-5ce204ab003b','202336cd-9078-4183-8bd4-e7a0e6f7bf55','2026-01-21 11:54:58',NULL,'DELETE','IN_PROGRESS','swap_network_port','202336cd-9078-4183-8bd4-e7a0e6f7bf55','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1105,'dc611b66-6c28-42c2-b9cc-042e395e7839','202336cd-9078-4183-8bd4-e7a0e6f7bf55','2026-01-21 11:54:58',NULL,'DELETE','IN_PROGRESS','server','075faef6-789f-4911-9f89-3b040f150c74','state changed','OS::Nova::Server',NULL,185),(1106,'9046f0a5-abf4-42e3-a90a-40fefe715987','202336cd-9078-4183-8bd4-e7a0e6f7bf55','2026-01-21 11:55:01',NULL,'DELETE','COMPLETE','server','075faef6-789f-4911-9f89-3b040f150c74','state changed','OS::Nova::Server',NULL,185),(1107,'d0f2585c-1f93-4f0b-a251-07579e376590','202336cd-9078-4183-8bd4-e7a0e6f7bf55','2026-01-21 11:55:01',NULL,'DELETE','IN_PROGRESS','subnet','dff0677e-2641-42de-be4a-f82699e66f9f','state changed','OS::Neutron::Subnet',NULL,182),(1108,'003298be-17b1-4202-ba9a-b737fd2312ea','202336cd-9078-4183-8bd4-e7a0e6f7bf55','2026-01-21 11:55:02',NULL,'DELETE','COMPLETE','subnet','dff0677e-2641-42de-be4a-f82699e66f9f','state changed','OS::Neutron::Subnet',NULL,182),(1109,'bda1d9a8-97d7-4941-a14c-098141297072','202336cd-9078-4183-8bd4-e7a0e6f7bf55','2026-01-21 11:55:02',NULL,'DELETE','IN_PROGRESS','net','13b0d6b4-2dfe-4ce7-bdb1-ac84aa1c8758','state changed','OS::Neutron::Net',NULL,181),(1110,'701ae572-dc74-46bc-8e51-5d6a54fe3cbb','202336cd-9078-4183-8bd4-e7a0e6f7bf55','2026-01-21 11:55:03',NULL,'DELETE','COMPLETE','net','13b0d6b4-2dfe-4ce7-bdb1-ac84aa1c8758','state changed','OS::Neutron::Net',NULL,181),(1111,'f923864a-0588-4086-87c3-b2f00ebb6a6e','202336cd-9078-4183-8bd4-e7a0e6f7bf55','2026-01-21 11:55:03',NULL,'DELETE','COMPLETE','swap_network_port','202336cd-9078-4183-8bd4-e7a0e6f7bf55','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1112,'d689649a-0236-44aa-921c-d6fdb1c61fd8','211f7d4b-e422-4e6f-8ef5-f479ac0c0b0f','2026-01-21 11:55:10',NULL,'CREATE','IN_PROGRESS','swap_network_subnet','211f7d4b-e422-4e6f-8ef5-f479ac0c0b0f','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1113,'52418c84-2024-41a0-8f89-173421aeb4eb','211f7d4b-e422-4e6f-8ef5-f479ac0c0b0f','2026-01-21 11:55:10',NULL,'CREATE','IN_PROGRESS','net','swap_network_subnet-net-kz2ojnw3fiwf','state changed','OS::Neutron::Net',NULL,187),(1114,'a064705d-7762-480b-9e64-a9b79d3eeeeb','211f7d4b-e422-4e6f-8ef5-f479ac0c0b0f','2026-01-21 11:55:12',NULL,'CREATE','COMPLETE','net','b8b84fb5-4598-4a5d-adc2-15ac770b4a3d','state changed','OS::Neutron::Net',NULL,187),(1115,'06c2cea2-d50f-4c8d-bf7c-1aa5212d6410','211f7d4b-e422-4e6f-8ef5-f479ac0c0b0f','2026-01-21 11:55:12',NULL,'CREATE','IN_PROGRESS','subnet','swap_network_subnet-subnet-tto5crghpari','state changed','OS::Neutron::Subnet',NULL,188),(1116,'49530f15-9cdd-455a-a4ee-ea6b6416c870','211f7d4b-e422-4e6f-8ef5-f479ac0c0b0f','2026-01-21 11:55:13',NULL,'CREATE','COMPLETE','subnet','27964a86-9187-42b5-8b58-c2dbcb193476','state changed','OS::Neutron::Subnet',NULL,188),(1117,'da4d9483-6da5-4cae-8203-990504d77d7f','211f7d4b-e422-4e6f-8ef5-f479ac0c0b0f','2026-01-21 11:55:13',NULL,'CREATE','IN_PROGRESS','server','swap_network_subnet-server-63bbtrgptouo','state changed','OS::Nova::Server',NULL,189),(1118,'27ccb57f-fa94-4191-ac4e-1dcb1c2c02e3','211f7d4b-e422-4e6f-8ef5-f479ac0c0b0f','2026-01-21 11:55:25',NULL,'CREATE','COMPLETE','server','58f5c1b6-12b9-41bc-8290-8faadee7d83c','state changed','OS::Nova::Server',NULL,189),(1119,'6d8fefa9-493a-4cd0-88a6-ec9f3e713632','211f7d4b-e422-4e6f-8ef5-f479ac0c0b0f','2026-01-21 11:55:25',NULL,'CREATE','COMPLETE','swap_network_subnet','211f7d4b-e422-4e6f-8ef5-f479ac0c0b0f','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1120,'30898b80-505f-48cb-b66a-3d97ea2fa02e','211f7d4b-e422-4e6f-8ef5-f479ac0c0b0f','2026-01-21 11:55:31',NULL,'UPDATE','IN_PROGRESS','swap_network_subnet','211f7d4b-e422-4e6f-8ef5-f479ac0c0b0f','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1121,'8b750f36-aed1-4a55-9460-75f9b0382d59','211f7d4b-e422-4e6f-8ef5-f479ac0c0b0f','2026-01-21 11:55:32',NULL,'UPDATE','IN_PROGRESS','server','58f5c1b6-12b9-41bc-8290-8faadee7d83c','state changed','OS::Nova::Server',NULL,189),(1122,'129fb422-6061-4783-9e22-ed27ef4fdb12','211f7d4b-e422-4e6f-8ef5-f479ac0c0b0f','2026-01-21 11:55:34',NULL,'UPDATE','COMPLETE','server','58f5c1b6-12b9-41bc-8290-8faadee7d83c','state changed','OS::Nova::Server',NULL,191),(1123,'7811ae8e-5ad6-45cd-8378-9aa91b5d535c','211f7d4b-e422-4e6f-8ef5-f479ac0c0b0f','2026-01-21 11:55:34',NULL,'UPDATE','COMPLETE','swap_network_subnet','211f7d4b-e422-4e6f-8ef5-f479ac0c0b0f','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1124,'0f4788eb-80a6-4705-8c5d-d9663f039fc8','211f7d4b-e422-4e6f-8ef5-f479ac0c0b0f','2026-01-21 11:55:38',NULL,'DELETE','IN_PROGRESS','swap_network_subnet','211f7d4b-e422-4e6f-8ef5-f479ac0c0b0f','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1125,'017b2c71-cd54-45d0-979d-4f49fbc8fd41','211f7d4b-e422-4e6f-8ef5-f479ac0c0b0f','2026-01-21 11:55:39',NULL,'DELETE','IN_PROGRESS','server','58f5c1b6-12b9-41bc-8290-8faadee7d83c','state changed','OS::Nova::Server',NULL,191),(1126,'27aac8c3-a6ba-4815-9ad7-6b5c66c6a2ff','211f7d4b-e422-4e6f-8ef5-f479ac0c0b0f','2026-01-21 11:55:41',NULL,'DELETE','COMPLETE','server','58f5c1b6-12b9-41bc-8290-8faadee7d83c','state changed','OS::Nova::Server',NULL,191),(1127,'55ef1abe-fda0-4c90-900c-d8b55899404b','211f7d4b-e422-4e6f-8ef5-f479ac0c0b0f','2026-01-21 11:55:41',NULL,'DELETE','IN_PROGRESS','subnet','27964a86-9187-42b5-8b58-c2dbcb193476','state changed','OS::Neutron::Subnet',NULL,188),(1128,'f5a61c42-3d2c-4471-9b94-f3e99d30259e','211f7d4b-e422-4e6f-8ef5-f479ac0c0b0f','2026-01-21 11:55:41',NULL,'DELETE','COMPLETE','subnet','27964a86-9187-42b5-8b58-c2dbcb193476','state changed','OS::Neutron::Subnet',NULL,188),(1129,'b755c8ba-e820-4c52-abc7-18e8855af2e0','211f7d4b-e422-4e6f-8ef5-f479ac0c0b0f','2026-01-21 11:55:41',NULL,'DELETE','IN_PROGRESS','net','b8b84fb5-4598-4a5d-adc2-15ac770b4a3d','state changed','OS::Neutron::Net',NULL,187),(1130,'cd1a842e-5d41-4f7c-a474-d2e43ffed361','211f7d4b-e422-4e6f-8ef5-f479ac0c0b0f','2026-01-21 11:55:42',NULL,'DELETE','COMPLETE','net','b8b84fb5-4598-4a5d-adc2-15ac770b4a3d','state changed','OS::Neutron::Net',NULL,187),(1131,'1288f5b4-5f24-4d35-8537-e0e60b54a0ec','211f7d4b-e422-4e6f-8ef5-f479ac0c0b0f','2026-01-21 11:55:42',NULL,'DELETE','COMPLETE','swap_network_subnet','211f7d4b-e422-4e6f-8ef5-f479ac0c0b0f','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1132,'2790a011-4d2e-461d-8047-1a0c0f3ac648','1b75e245-458b-462b-9bb6-774ec0d13913','2026-01-21 11:55:46',NULL,'CREATE','IN_PROGRESS','swap_subnet_network','1b75e245-458b-462b-9bb6-774ec0d13913','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1133,'e72b7edf-d552-4af3-8598-3d0263afee86','1b75e245-458b-462b-9bb6-774ec0d13913','2026-01-21 11:55:46',NULL,'CREATE','IN_PROGRESS','net','swap_subnet_network-net-z3ukudjzzhfj','state changed','OS::Neutron::Net',NULL,193),(1134,'a69c9065-2ee8-46ef-b941-1080a942842f','1b75e245-458b-462b-9bb6-774ec0d13913','2026-01-21 11:55:47',NULL,'CREATE','COMPLETE','net','805ee308-2055-4719-83b4-cf4e00fb3ce5','state changed','OS::Neutron::Net',NULL,193),(1135,'4376089f-be6a-48f2-84fb-58f3ebe323be','1b75e245-458b-462b-9bb6-774ec0d13913','2026-01-21 11:55:47',NULL,'CREATE','IN_PROGRESS','subnet','swap_subnet_network-subnet-ynor3k72x5xn','state changed','OS::Neutron::Subnet',NULL,194),(1136,'8e18d87d-7bd9-45c5-8798-7ff4ece28d04','1b75e245-458b-462b-9bb6-774ec0d13913','2026-01-21 11:55:48',NULL,'CREATE','COMPLETE','subnet','579765c2-40c2-47f8-b31b-4040e7e5c2e9','state changed','OS::Neutron::Subnet',NULL,194),(1137,'db273de9-8bf7-472b-ba7d-2cfb1ea2ccaa','1b75e245-458b-462b-9bb6-774ec0d13913','2026-01-21 11:55:48',NULL,'CREATE','IN_PROGRESS','server','swap_subnet_network-server-yp4grd5vc4r6','state changed','OS::Nova::Server',NULL,195),(1138,'d82ef642-f093-4770-be1a-da6e7f53e465','1b75e245-458b-462b-9bb6-774ec0d13913','2026-01-21 11:55:56',NULL,'CREATE','COMPLETE','server','64576ca9-6019-4364-8536-3f602566bc5e','state changed','OS::Nova::Server',NULL,195),(1139,'d1b3801a-3bda-4938-a20a-045de248f265','1b75e245-458b-462b-9bb6-774ec0d13913','2026-01-21 11:55:56',NULL,'CREATE','COMPLETE','swap_subnet_network','1b75e245-458b-462b-9bb6-774ec0d13913','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1140,'9527a0b9-2c70-42e9-8cce-61d9cae24bc4','1b75e245-458b-462b-9bb6-774ec0d13913','2026-01-21 11:56:04',NULL,'UPDATE','IN_PROGRESS','swap_subnet_network','1b75e245-458b-462b-9bb6-774ec0d13913','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1141,'77eb4c38-d925-42ba-ae1f-7313e914b534','1b75e245-458b-462b-9bb6-774ec0d13913','2026-01-21 11:56:04',NULL,'UPDATE','IN_PROGRESS','server','64576ca9-6019-4364-8536-3f602566bc5e','state changed','OS::Nova::Server',NULL,195),(1142,'b4393ca7-6ea1-4616-aedd-a034e38d326e','1b75e245-458b-462b-9bb6-774ec0d13913','2026-01-21 11:56:07',NULL,'UPDATE','COMPLETE','server','64576ca9-6019-4364-8536-3f602566bc5e','state changed','OS::Nova::Server',NULL,197),(1143,'d22d5dd3-6e0e-4df1-b889-4144abf26417','1b75e245-458b-462b-9bb6-774ec0d13913','2026-01-21 11:56:07',NULL,'UPDATE','COMPLETE','swap_subnet_network','1b75e245-458b-462b-9bb6-774ec0d13913','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1144,'fa6e052f-02b7-40e2-b80f-c6d9e4f1c247','1b75e245-458b-462b-9bb6-774ec0d13913','2026-01-21 11:56:10',NULL,'DELETE','IN_PROGRESS','swap_subnet_network','1b75e245-458b-462b-9bb6-774ec0d13913','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1145,'fc6d4f2d-6d52-40ba-aa2d-4a82b94f86a1','1b75e245-458b-462b-9bb6-774ec0d13913','2026-01-21 11:56:10',NULL,'DELETE','IN_PROGRESS','server','64576ca9-6019-4364-8536-3f602566bc5e','state changed','OS::Nova::Server',NULL,197),(1146,'c299ff01-3d52-4cd2-a506-07d294ed5859','1b75e245-458b-462b-9bb6-774ec0d13913','2026-01-21 11:56:14',NULL,'DELETE','COMPLETE','server','64576ca9-6019-4364-8536-3f602566bc5e','state changed','OS::Nova::Server',NULL,197),(1147,'f446fa3d-f86c-40a9-90cd-381b9dfd1a62','1b75e245-458b-462b-9bb6-774ec0d13913','2026-01-21 11:56:14',NULL,'DELETE','IN_PROGRESS','subnet','579765c2-40c2-47f8-b31b-4040e7e5c2e9','state changed','OS::Neutron::Subnet',NULL,194),(1148,'1af6f3b3-09e8-44cc-ad08-1a5cb8eeeb65','1b75e245-458b-462b-9bb6-774ec0d13913','2026-01-21 11:56:14',NULL,'DELETE','COMPLETE','subnet','579765c2-40c2-47f8-b31b-4040e7e5c2e9','state changed','OS::Neutron::Subnet',NULL,194),(1149,'4f855d84-b806-4908-9ec2-62d01f1500d5','1b75e245-458b-462b-9bb6-774ec0d13913','2026-01-21 11:56:14',NULL,'DELETE','IN_PROGRESS','net','805ee308-2055-4719-83b4-cf4e00fb3ce5','state changed','OS::Neutron::Net',NULL,193),(1150,'46a60ba5-cdec-4210-860d-ac2565c8750f','1b75e245-458b-462b-9bb6-774ec0d13913','2026-01-21 11:56:15',NULL,'DELETE','COMPLETE','net','805ee308-2055-4719-83b4-cf4e00fb3ce5','state changed','OS::Neutron::Net',NULL,193),(1151,'b27ebf5b-1ce0-47bb-bc43-94247e292f77','1b75e245-458b-462b-9bb6-774ec0d13913','2026-01-21 11:56:15',NULL,'DELETE','COMPLETE','swap_subnet_network','1b75e245-458b-462b-9bb6-774ec0d13913','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1152,'86080d4f-6954-4ba0-8bd8-8bc3318d41a2','75aa1f8b-2bc3-4ad5-b440-9654060c77dd','2026-01-21 11:56:21',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-100537633','75aa1f8b-2bc3-4ad5-b440-9654060c77dd','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1153,'3b52c034-4847-4a57-a94d-d2d19c574046','75aa1f8b-2bc3-4ad5-b440-9654060c77dd','2026-01-21 11:56:21',NULL,'CREATE','IN_PROGRESS','server','ParallelDeploymentsTest-100537633-server-zdupfj5nw5k3','state changed','OS::Nova::Server',NULL,199),(1154,'2767e0e8-1bb8-4796-8543-e902cb60b7b6','75aa1f8b-2bc3-4ad5-b440-9654060c77dd','2026-01-21 11:56:30',NULL,'CREATE','COMPLETE','server','4ff9a573-1e19-46f3-8efa-47cd3724747a','state changed','OS::Nova::Server',NULL,199),(1155,'2b5783ec-bef5-459f-8f80-8947c4d35579','75aa1f8b-2bc3-4ad5-b440-9654060c77dd','2026-01-21 11:56:30',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-100537633','75aa1f8b-2bc3-4ad5-b440-9654060c77dd','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1156,'c4f56ac4-90f6-4d1d-8187-fcbc9d51e81d','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:56:35',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-2113435203','827ee19c-f116-4d62-bf09-2e58e17938e5','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1157,'f2b0d58a-9a88-4895-bd0a-61decd450468','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:56:35',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-2113435203-config-kda4gp3pbhat','state changed','OS::Heat::SoftwareConfig',NULL,200),(1158,'d7b1b990-812b-47d6-a764-db43a28587c1','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:56:35',NULL,'CREATE','COMPLETE','config','c4a706e4-b583-4904-a857-cecb8b5d950f','state changed','OS::Heat::SoftwareConfig',NULL,200),(1159,'3a59694e-a320-4e55-a3d2-611668037a38','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:56:35',NULL,'CREATE','IN_PROGRESS','dep_3','ParallelDeploymentsTest-2113435203-dep_3-ly2wln4m4uz2','state changed','OS::Heat::SoftwareDeployments',NULL,201),(1160,'9a86a292-c930-4ca6-9497-b24e6aa16b4f','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:56:35',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-2113435203-dep_0-7tgcbpbbur7m','state changed','OS::Heat::SoftwareDeployments',NULL,202),(1161,'989e5aae-7fa4-4989-8b54-fb1af523427e','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:56:35',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-2113435203-dep_2-mlh47nro7bwk','state changed','OS::Heat::SoftwareDeployments',NULL,203),(1162,'a8f907de-a7e9-43ad-b9f6-2f413ea78a94','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:56:35',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-2113435203-dep_1-nl3oxy2eraww','state changed','OS::Heat::SoftwareDeployments',NULL,204),(1163,'cf517c5a-1e5f-4bc2-823a-dd451760d812','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:56:35',NULL,'CREATE','IN_PROGRESS','dep_4','ParallelDeploymentsTest-2113435203-dep_4-igyerhnpcpyu','state changed','OS::Heat::SoftwareDeployments',NULL,205),(1164,'1667fffe-3cee-497e-98b9-52b2083b377e','90b49099-672c-4cef-aa9b-a4c5f809f1db','2026-01-21 11:56:35',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-2113435203-dep_3-ly2wln4m4uz2','90b49099-672c-4cef-aa9b-a4c5f809f1db','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1165,'c4a5610d-d578-461d-8d92-870506cf77db','236bc67a-e3b5-46a5-a6b7-40a6167fbd9f','2026-01-21 11:56:35',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-2113435203-dep_0-7tgcbpbbur7m','236bc67a-e3b5-46a5-a6b7-40a6167fbd9f','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1166,'a1dbb199-24b5-46ec-8411-0b738b5b39dc','b483ae4a-d046-41f1-8621-671b02bbc747','2026-01-21 11:56:35',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-2113435203-dep_2-mlh47nro7bwk','b483ae4a-d046-41f1-8621-671b02bbc747','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1167,'ae35b451-6315-4eab-82ac-67395ab63956','7c8a47da-b70c-465c-8524-7bc7ecd81aa8','2026-01-21 11:56:35',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-2113435203-dep_4-igyerhnpcpyu','7c8a47da-b70c-465c-8524-7bc7ecd81aa8','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1168,'94acee4d-cd71-434b-a5c9-0b3f03f44c70','0fc1b119-7102-4fcf-b4ba-7ddd95cc2010','2026-01-21 11:56:35',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-2113435203-dep_1-nl3oxy2eraww','0fc1b119-7102-4fcf-b4ba-7ddd95cc2010','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1169,'bcc69112-6f8b-4b96-a77c-1f0534c5a027','b483ae4a-d046-41f1-8621-671b02bbc747','2026-01-21 11:56:35',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-2113435203-dep_2-mlh47nro7bwk-0-7lm254a7bjiw','state changed','OS::Heat::SoftwareDeployment',NULL,206),(1170,'b4b286a4-229c-4909-b200-952294a08c03','236bc67a-e3b5-46a5-a6b7-40a6167fbd9f','2026-01-21 11:56:35',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-2113435203-dep_0-7tgcbpbbur7m-0-dv3ekh3qwxl5','state changed','OS::Heat::SoftwareDeployment',NULL,207),(1171,'ad517459-6e6b-4429-b147-cd2db724ec94','90b49099-672c-4cef-aa9b-a4c5f809f1db','2026-01-21 11:56:35',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-2113435203-dep_3-ly2wln4m4uz2-0-nxdz76g6hjrp','state changed','OS::Heat::SoftwareDeployment',NULL,208),(1172,'a9f59e6e-96ff-4541-905f-e30677a923ec','7c8a47da-b70c-465c-8524-7bc7ecd81aa8','2026-01-21 11:56:35',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-2113435203-dep_4-igyerhnpcpyu-0-5hex6gxox3kl','state changed','OS::Heat::SoftwareDeployment',NULL,209),(1173,'007a252f-6e05-49fe-a576-1f1109f1d9d1','0fc1b119-7102-4fcf-b4ba-7ddd95cc2010','2026-01-21 11:56:35',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-2113435203-dep_1-nl3oxy2eraww-0-4c447d2fj2yx','state changed','OS::Heat::SoftwareDeployment',NULL,210),(1174,'328a78be-5ad3-4dd3-a215-a2f11722770f','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:56:36',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-301952452','13987ec4-949c-42d2-baa5-adc025c61eb8','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1175,'fcaade96-18da-4740-b754-3ff8daaf583a','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:56:36',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-301952452-config-qzekmjpsqeb2','state changed','OS::Heat::SoftwareConfig',NULL,211),(1176,'1b4e4956-48db-40ae-a15f-48c9ee643d1e','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:56:36',NULL,'CREATE','COMPLETE','config','40e09982-598f-4462-add4-00eda355d0ef','state changed','OS::Heat::SoftwareConfig',NULL,211),(1177,'9e9008bc-2aa7-4dfa-9e71-97266cbc4628','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:56:36',NULL,'CREATE','IN_PROGRESS','dep_3','ParallelDeploymentsTest-301952452-dep_3-zff3ak6gzvaf','state changed','OS::Heat::SoftwareDeployments',NULL,212),(1178,'61ced022-1f14-41d9-83f7-1baccb3ca5c2','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:56:36',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-301952452-dep_0-by5sjpmxhjke','state changed','OS::Heat::SoftwareDeployments',NULL,213),(1179,'61b92a05-d4be-4816-ad05-66930c7c0e6a','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:56:36',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-301952452-dep_1-xbabmewwqmyx','state changed','OS::Heat::SoftwareDeployments',NULL,214),(1180,'ee3ca9e1-8e51-4b06-a59a-180063f8bbce','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:56:36',NULL,'CREATE','IN_PROGRESS','dep_4','ParallelDeploymentsTest-301952452-dep_4-bsszwontpt7g','state changed','OS::Heat::SoftwareDeployments',NULL,215),(1181,'295a3884-a77e-40b0-912b-d20f13d6fb50','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:56:36',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-301952452-dep_2-zibtn4kmuwn7','state changed','OS::Heat::SoftwareDeployments',NULL,216),(1182,'eceabe8f-455c-4410-93f3-6fedb7ef360f','dd905c26-f0e4-4a6d-8899-67dc446009ed','2026-01-21 11:56:36',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-301952452-dep_0-by5sjpmxhjke','dd905c26-f0e4-4a6d-8899-67dc446009ed','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1183,'46bb18ad-fbe2-43f2-8cdf-f8631c19eb31','4d407931-8eea-444e-880e-21e6f15b7a60','2026-01-21 11:56:37',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-301952452-dep_3-zff3ak6gzvaf','4d407931-8eea-444e-880e-21e6f15b7a60','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1184,'57df345e-59cc-497d-a79f-d365c2bfec22','03b749f2-7523-4278-8861-784c4ebc22e5','2026-01-21 11:56:37',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-301952452-dep_1-xbabmewwqmyx','03b749f2-7523-4278-8861-784c4ebc22e5','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1185,'589af303-d9c5-4ea2-85b9-e90324e87645','58fc8ddd-3677-4a8a-a759-27fd0c26425f','2026-01-21 11:56:37',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-301952452-dep_4-bsszwontpt7g','58fc8ddd-3677-4a8a-a759-27fd0c26425f','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1186,'ba11310b-bfbf-45b9-a38e-e3e462ebb0f5','21acd278-066f-43a1-a33b-9ceaf407dc2e','2026-01-21 11:56:37',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-301952452-dep_2-zibtn4kmuwn7','21acd278-066f-43a1-a33b-9ceaf407dc2e','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1187,'3466866f-5528-4932-93ec-6e6b3e033b96','4d407931-8eea-444e-880e-21e6f15b7a60','2026-01-21 11:56:37',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-301952452-dep_3-zff3ak6gzvaf-0-dp2x5mkyfcxx','state changed','OS::Heat::SoftwareDeployment',NULL,217),(1188,'01c1b279-3eac-4947-9db2-c1d19b267ba8','21acd278-066f-43a1-a33b-9ceaf407dc2e','2026-01-21 11:56:37',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-301952452-dep_2-zibtn4kmuwn7-0-ny6okq6llkdz','state changed','OS::Heat::SoftwareDeployment',NULL,219),(1189,'e024c58d-c599-40a5-948c-f32f28bf58c9','03b749f2-7523-4278-8861-784c4ebc22e5','2026-01-21 11:56:37',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-301952452-dep_1-xbabmewwqmyx-0-ik5b6vycxls2','state changed','OS::Heat::SoftwareDeployment',NULL,218),(1190,'13973674-c87a-46c6-a487-a2dabd0b56bb','dd905c26-f0e4-4a6d-8899-67dc446009ed','2026-01-21 11:56:37',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-301952452-dep_0-by5sjpmxhjke-0-czyluezou3qs','state changed','OS::Heat::SoftwareDeployment',NULL,220),(1191,'359bd9b0-99fd-4618-9e30-b72e529f6d7c','58fc8ddd-3677-4a8a-a759-27fd0c26425f','2026-01-21 11:56:37',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-301952452-dep_4-bsszwontpt7g-0-adin6vhxgpck','state changed','OS::Heat::SoftwareDeployment',NULL,221),(1192,'70be065d-2f2f-4344-842c-e5be2c7f3471','7925f319-fd76-4c59-9868-414fbb354c71','2026-01-21 11:56:46',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1866873809','7925f319-fd76-4c59-9868-414fbb354c71','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1193,'9008fa23-631d-4f09-92bc-04325d7c5b9f','7925f319-fd76-4c59-9868-414fbb354c71','2026-01-21 11:56:46',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-1866873809-config-olibzcxzogzw','state changed','OS::Heat::SoftwareConfig',NULL,222),(1194,'3bc43370-b1f4-4b0c-9980-60e446e63baf','7925f319-fd76-4c59-9868-414fbb354c71','2026-01-21 11:56:46',NULL,'CREATE','COMPLETE','config','a6d3dfa2-e685-4854-ae22-24ba8b422c62','state changed','OS::Heat::SoftwareConfig',NULL,222),(1195,'d6309c70-5d10-491a-b234-0028119936c9','7925f319-fd76-4c59-9868-414fbb354c71','2026-01-21 11:56:46',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-1866873809-dep_0-mgo3wzakbg2x','state changed','OS::Heat::SoftwareDeployments',NULL,223),(1196,'9340edec-ed80-4143-81c7-d2df99f32c37','7925f319-fd76-4c59-9868-414fbb354c71','2026-01-21 11:56:46',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-1866873809-dep_2-aye4jz7qukex','state changed','OS::Heat::SoftwareDeployments',NULL,224),(1197,'38531aa7-5b53-42db-9b90-cd53c4841952','7925f319-fd76-4c59-9868-414fbb354c71','2026-01-21 11:56:46',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-1866873809-dep_1-kwk4zudk72bz','state changed','OS::Heat::SoftwareDeployments',NULL,225),(1198,'070c0919-1647-4754-aad9-b8fdc066c249','768e741e-9b75-4382-838e-d927c997a82a','2026-01-21 11:56:46',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1866873809-dep_0-mgo3wzakbg2x','768e741e-9b75-4382-838e-d927c997a82a','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1199,'2a2ce64f-44c9-43be-9be8-ad9a5d7dd23b','bbd1ce7e-39ea-4ea2-96ad-edfd62e07da1','2026-01-21 11:56:46',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1866873809-dep_2-aye4jz7qukex','bbd1ce7e-39ea-4ea2-96ad-edfd62e07da1','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1200,'752c0309-af41-48bf-b36d-498239a96ea5','7cf68aa3-10a1-4ffc-8f40-9a7889af38a2','2026-01-21 11:56:46',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1866873809-dep_1-kwk4zudk72bz','7cf68aa3-10a1-4ffc-8f40-9a7889af38a2','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1201,'595276e2-d45d-45b2-aee3-bd7d8678de62','768e741e-9b75-4382-838e-d927c997a82a','2026-01-21 11:56:46',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1866873809-dep_0-mgo3wzakbg2x-0-haqmorjnwjga','state changed','OS::Heat::SoftwareDeployment',NULL,226),(1202,'d4c2a019-f217-48b1-b3d0-cbd4723c114a','7cf68aa3-10a1-4ffc-8f40-9a7889af38a2','2026-01-21 11:56:46',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1866873809-dep_1-kwk4zudk72bz-0-gd4rzndiszvf','state changed','OS::Heat::SoftwareDeployment',NULL,227),(1203,'2505060e-94e8-4790-955e-62ced486ff89','bbd1ce7e-39ea-4ea2-96ad-edfd62e07da1','2026-01-21 11:56:46',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1866873809-dep_2-aye4jz7qukex-0-qsg4xu6pyupi','state changed','OS::Heat::SoftwareDeployment',NULL,228),(1204,'6f3dc668-29f2-425c-85f3-2b3bd7668a94','178a131a-ce79-4ee2-bb62-94a2a0796054','2026-01-21 11:56:47',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-2096988093','178a131a-ce79-4ee2-bb62-94a2a0796054','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1205,'9b74a8f6-c28a-4ead-a83a-52552a21e14f','178a131a-ce79-4ee2-bb62-94a2a0796054','2026-01-21 11:56:47',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-2096988093-config-eqia6rqts3ur','state changed','OS::Heat::SoftwareConfig',NULL,229),(1206,'b788e40e-9364-4b3b-831e-b2c3cbabbbd7','178a131a-ce79-4ee2-bb62-94a2a0796054','2026-01-21 11:56:47',NULL,'CREATE','COMPLETE','config','6ba63002-f444-4cd2-b43c-7362c3007d78','state changed','OS::Heat::SoftwareConfig',NULL,229),(1207,'471c4669-0c6b-48c3-956e-50b428f6e8c9','178a131a-ce79-4ee2-bb62-94a2a0796054','2026-01-21 11:56:47',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-2096988093-dep_0-fg7gck55feyd','state changed','OS::Heat::SoftwareDeployments',NULL,230),(1208,'4d528de9-3738-4ad2-b278-fc8654a3e658','178a131a-ce79-4ee2-bb62-94a2a0796054','2026-01-21 11:56:47',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-2096988093-dep_1-akxfm7rpww5j','state changed','OS::Heat::SoftwareDeployments',NULL,231),(1209,'9188daea-342c-436f-b7e9-d7708beaef3f','178a131a-ce79-4ee2-bb62-94a2a0796054','2026-01-21 11:56:47',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-2096988093-dep_2-rxdn3qcwg4t2','state changed','OS::Heat::SoftwareDeployments',NULL,232),(1210,'601a4b11-cb13-4914-b0f0-bc4b9a4890a5','38523b7b-7e98-41c7-a395-896f117d20cc','2026-01-21 11:56:47',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-2096988093-dep_0-fg7gck55feyd','38523b7b-7e98-41c7-a395-896f117d20cc','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1211,'4ac414a0-46d3-4114-9bda-a4af2cdd00a9','ec836e4b-c437-4849-8199-b6e01e5c729a','2026-01-21 11:56:47',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-2096988093-dep_1-akxfm7rpww5j','ec836e4b-c437-4849-8199-b6e01e5c729a','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1212,'7d96d369-0f51-4fda-b640-cecfe613b4f8','0294945d-6703-4230-98ab-4d690fc3dbc0','2026-01-21 11:56:47',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-2096988093-dep_2-rxdn3qcwg4t2','0294945d-6703-4230-98ab-4d690fc3dbc0','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1213,'40a5995c-b352-4a79-8c8b-1ffa11fd172d','38523b7b-7e98-41c7-a395-896f117d20cc','2026-01-21 11:56:47',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-2096988093-dep_0-fg7gck55feyd-0-5hlcnkmbixox','state changed','OS::Heat::SoftwareDeployment',NULL,233),(1214,'89eac7a0-a7c7-4c05-9c98-ea03eaba9f91','ec836e4b-c437-4849-8199-b6e01e5c729a','2026-01-21 11:56:47',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-2096988093-dep_1-akxfm7rpww5j-0-lgplgv7oddmk','state changed','OS::Heat::SoftwareDeployment',NULL,234),(1215,'47a5d334-2014-430a-a600-060771267e21','0294945d-6703-4230-98ab-4d690fc3dbc0','2026-01-21 11:56:47',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-2096988093-dep_2-rxdn3qcwg4t2-0-dh5a5yspnch4','state changed','OS::Heat::SoftwareDeployment',NULL,235),(1216,'c3ffa837-ba9c-4b13-baba-b3b0b56cbad7','dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','2026-01-21 11:56:49',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-125988841','dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1217,'f926e536-ed86-44b1-b5e4-ec31fe1eca3e','dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','2026-01-21 11:56:49',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-125988841-config-x46yetakhaqb','state changed','OS::Heat::SoftwareConfig',NULL,236),(1218,'f1ca3163-c259-435e-b509-e50ce4f5fbb7','dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','2026-01-21 11:56:49',NULL,'CREATE','COMPLETE','config','d2cbf5cf-4d45-416a-b5b2-0613e8b26bd8','state changed','OS::Heat::SoftwareConfig',NULL,236),(1219,'0929c57f-df1e-47fd-b7c0-74034e7a9907','dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','2026-01-21 11:56:49',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-125988841-dep_0-l3zl7pnvvcf4','state changed','OS::Heat::SoftwareDeployments',NULL,237),(1220,'3ae445da-96e8-48bb-bbe9-269f82e90443','dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','2026-01-21 11:56:49',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-125988841-dep_2-okv2ldgsvg7p','state changed','OS::Heat::SoftwareDeployments',NULL,238),(1221,'1ab865f8-7985-4bdc-ab82-766f2550176b','dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','2026-01-21 11:56:49',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-125988841-dep_1-4gq4fnryqpmh','state changed','OS::Heat::SoftwareDeployments',NULL,239),(1222,'211dc30d-3dd0-4098-9b30-6ae7d24fc19a','2775bcdb-7752-4db2-b0c0-132c2db0ac3d','2026-01-21 11:56:49',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-125988841-dep_0-l3zl7pnvvcf4','2775bcdb-7752-4db2-b0c0-132c2db0ac3d','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1223,'dd4fce07-d4a5-4a78-9e5b-7841390b84eb','73c75274-23fe-4304-afa9-7f421c5e396c','2026-01-21 11:56:49',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-125988841-dep_2-okv2ldgsvg7p','73c75274-23fe-4304-afa9-7f421c5e396c','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1224,'fd4ee491-c5fd-4c04-96cf-0e673ea5ecc8','f50745fa-ce29-4543-a581-b048a3fdd80b','2026-01-21 11:56:49',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-125988841-dep_1-4gq4fnryqpmh','f50745fa-ce29-4543-a581-b048a3fdd80b','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1225,'e90ea002-31f5-4b47-983e-dc9df82e0e63','2775bcdb-7752-4db2-b0c0-132c2db0ac3d','2026-01-21 11:56:49',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-125988841-dep_0-l3zl7pnvvcf4-0-ibyqys6wkpkc','state changed','OS::Heat::SoftwareDeployment',NULL,240),(1226,'6bd06c68-e2ba-4964-8a85-4980f34ae490','73c75274-23fe-4304-afa9-7f421c5e396c','2026-01-21 11:56:49',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-125988841-dep_2-okv2ldgsvg7p-0-bylfkbdm2t5l','state changed','OS::Heat::SoftwareDeployment',NULL,241),(1227,'5364b581-c2ba-42e1-b9c3-3be54f5bf65e','f50745fa-ce29-4543-a581-b048a3fdd80b','2026-01-21 11:56:49',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-125988841-dep_1-4gq4fnryqpmh-0-jrpp3wzexlrm','state changed','OS::Heat::SoftwareDeployment',NULL,242),(1228,'e74d08a0-8bfc-416d-a4c5-cb9ea1f6a9c5','2775bcdb-7752-4db2-b0c0-132c2db0ac3d','2026-01-21 11:56:58',NULL,'SIGNAL','IN_PROGRESS','0','229963ad-2d3b-4aad-beb1-5f43aaedd68f','Signal: deployment 229963ad-2d3b-4aad-beb1-5f43aaedd68f succeeded','OS::Heat::SoftwareDeployment',NULL,240),(1229,'368f798d-b720-4497-aefe-f9b1f5db8ca1','2775bcdb-7752-4db2-b0c0-132c2db0ac3d','2026-01-21 11:56:58',NULL,'CREATE','COMPLETE','0','229963ad-2d3b-4aad-beb1-5f43aaedd68f','state changed','OS::Heat::SoftwareDeployment',NULL,240),(1230,'2210cb56-ed12-435e-9002-dadc7f5ece27','2775bcdb-7752-4db2-b0c0-132c2db0ac3d','2026-01-21 11:56:58',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-125988841-dep_0-l3zl7pnvvcf4','2775bcdb-7752-4db2-b0c0-132c2db0ac3d','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1231,'d508ff65-54c5-49f5-befb-a716560efa1e','f50745fa-ce29-4543-a581-b048a3fdd80b','2026-01-21 11:56:59',NULL,'SIGNAL','IN_PROGRESS','0','a483aea1-6db7-466c-b249-a39859e4ee63','Signal: deployment a483aea1-6db7-466c-b249-a39859e4ee63 succeeded','OS::Heat::SoftwareDeployment',NULL,242),(1232,'23edd5aa-66f8-4440-98ed-1baa84321c6c','dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','2026-01-21 11:56:59',NULL,'CREATE','COMPLETE','dep_0','2775bcdb-7752-4db2-b0c0-132c2db0ac3d','state changed','OS::Heat::SoftwareDeployments',NULL,237),(1233,'fe1c42fe-a083-4b0e-9cd7-ed3468b6d6d3','f50745fa-ce29-4543-a581-b048a3fdd80b','2026-01-21 11:56:59',NULL,'CREATE','COMPLETE','0','a483aea1-6db7-466c-b249-a39859e4ee63','state changed','OS::Heat::SoftwareDeployment',NULL,242),(1234,'67ed248b-b547-4a4b-8cd2-7ed2384d45db','f50745fa-ce29-4543-a581-b048a3fdd80b','2026-01-21 11:56:59',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-125988841-dep_1-4gq4fnryqpmh','f50745fa-ce29-4543-a581-b048a3fdd80b','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1235,'c8ceefec-2e10-45d1-9a10-5a4d4ee056a2','73c75274-23fe-4304-afa9-7f421c5e396c','2026-01-21 11:56:59',NULL,'SIGNAL','IN_PROGRESS','0','c98b90d2-d0e6-4bd5-b9ed-fa4d27bd95ea','Signal: deployment c98b90d2-d0e6-4bd5-b9ed-fa4d27bd95ea succeeded','OS::Heat::SoftwareDeployment',NULL,241),(1236,'80566cac-4d60-467c-9bda-1840ef8e01b5','dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','2026-01-21 11:57:00',NULL,'CREATE','COMPLETE','dep_1','f50745fa-ce29-4543-a581-b048a3fdd80b','state changed','OS::Heat::SoftwareDeployments',NULL,239),(1237,'dfeeca32-eb34-4d15-9ae3-3ef00bf610a0','73c75274-23fe-4304-afa9-7f421c5e396c','2026-01-21 11:57:00',NULL,'CREATE','COMPLETE','0','c98b90d2-d0e6-4bd5-b9ed-fa4d27bd95ea','state changed','OS::Heat::SoftwareDeployment',NULL,241),(1238,'9f0c7768-8d5f-4a96-b5ff-fe0a65664783','73c75274-23fe-4304-afa9-7f421c5e396c','2026-01-21 11:57:00',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-125988841-dep_2-okv2ldgsvg7p','73c75274-23fe-4304-afa9-7f421c5e396c','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1239,'6bb09f41-33d6-43ea-9227-20df9debbe3c','bbd1ce7e-39ea-4ea2-96ad-edfd62e07da1','2026-01-21 11:57:00',NULL,'SIGNAL','IN_PROGRESS','0','bbb683ce-56f8-420f-882b-46972d5c4f18','Signal: deployment bbb683ce-56f8-420f-882b-46972d5c4f18 succeeded','OS::Heat::SoftwareDeployment',NULL,228),(1240,'effc0b93-a3af-43a4-9cf0-157889390c65','dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','2026-01-21 11:57:01',NULL,'CREATE','COMPLETE','dep_2','73c75274-23fe-4304-afa9-7f421c5e396c','state changed','OS::Heat::SoftwareDeployments',NULL,238),(1241,'fc1e324a-57cf-490e-8fac-bfd2613b13d7','dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','2026-01-21 11:57:01',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-125988841','dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1242,'531fd66e-1c53-48b6-bfe5-779b3911f3d1','bbd1ce7e-39ea-4ea2-96ad-edfd62e07da1','2026-01-21 11:57:01',NULL,'CREATE','COMPLETE','0','bbb683ce-56f8-420f-882b-46972d5c4f18','state changed','OS::Heat::SoftwareDeployment',NULL,228),(1243,'88d47d34-4910-483a-908f-b6156c7369cb','bbd1ce7e-39ea-4ea2-96ad-edfd62e07da1','2026-01-21 11:57:01',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1866873809-dep_2-aye4jz7qukex','bbd1ce7e-39ea-4ea2-96ad-edfd62e07da1','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1244,'88198c60-00e4-40d0-8eeb-8158463a89f1','7cf68aa3-10a1-4ffc-8f40-9a7889af38a2','2026-01-21 11:57:01',NULL,'SIGNAL','IN_PROGRESS','0','be1cc34d-fe63-4f74-b18c-578fd70f36e1','Signal: deployment be1cc34d-fe63-4f74-b18c-578fd70f36e1 succeeded','OS::Heat::SoftwareDeployment',NULL,227),(1245,'cc9bf651-e601-48d4-8512-2a56b4b77266','7925f319-fd76-4c59-9868-414fbb354c71','2026-01-21 11:57:02',NULL,'CREATE','COMPLETE','dep_2','bbd1ce7e-39ea-4ea2-96ad-edfd62e07da1','state changed','OS::Heat::SoftwareDeployments',NULL,224),(1246,'71c3e295-42f4-4fd7-9e6c-a56352128e3c','7cf68aa3-10a1-4ffc-8f40-9a7889af38a2','2026-01-21 11:57:02',NULL,'CREATE','COMPLETE','0','be1cc34d-fe63-4f74-b18c-578fd70f36e1','state changed','OS::Heat::SoftwareDeployment',NULL,227),(1247,'35ec7b8d-162f-4271-add8-bfd7626961c1','7cf68aa3-10a1-4ffc-8f40-9a7889af38a2','2026-01-21 11:57:02',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1866873809-dep_1-kwk4zudk72bz','7cf68aa3-10a1-4ffc-8f40-9a7889af38a2','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1248,'ef3683c1-87e5-4ec8-92a5-8b36a0d4dfd8','768e741e-9b75-4382-838e-d927c997a82a','2026-01-21 11:57:02',NULL,'SIGNAL','IN_PROGRESS','0','d4cce53a-1dbf-4f9a-afab-8fb47ebd9db7','Signal: deployment d4cce53a-1dbf-4f9a-afab-8fb47ebd9db7 succeeded','OS::Heat::SoftwareDeployment',NULL,226),(1249,'8fe1aee7-0afa-4fe8-9f6e-9d5cb5af6a59','38523b7b-7e98-41c7-a395-896f117d20cc','2026-01-21 11:57:03',NULL,'SIGNAL','IN_PROGRESS','0','aecc5573-506e-41a0-a76f-0bf14b0430f0','Signal: deployment aecc5573-506e-41a0-a76f-0bf14b0430f0 succeeded','OS::Heat::SoftwareDeployment',NULL,233),(1250,'efb26b2f-fd67-4717-8483-090a9126feb3','ec836e4b-c437-4849-8199-b6e01e5c729a','2026-01-21 11:57:03',NULL,'SIGNAL','IN_PROGRESS','0','6d51d120-2c7e-44ea-b977-77fc4356adee','Signal: deployment 6d51d120-2c7e-44ea-b977-77fc4356adee succeeded','OS::Heat::SoftwareDeployment',NULL,234),(1251,'bab16491-b1d9-4ea2-9b8f-19c4b9b3ed59','0294945d-6703-4230-98ab-4d690fc3dbc0','2026-01-21 11:57:03',NULL,'SIGNAL','IN_PROGRESS','0','a4558362-343c-407f-95a2-1512e9beccd0','Signal: deployment a4558362-343c-407f-95a2-1512e9beccd0 succeeded','OS::Heat::SoftwareDeployment',NULL,235),(1252,'5f45b0e3-0811-40ee-8191-afb8ffb53f95','7925f319-fd76-4c59-9868-414fbb354c71','2026-01-21 11:57:03',NULL,'CREATE','COMPLETE','dep_1','7cf68aa3-10a1-4ffc-8f40-9a7889af38a2','state changed','OS::Heat::SoftwareDeployments',NULL,225),(1253,'1755ad35-773c-434a-ac2e-b5b128ecd4e8','768e741e-9b75-4382-838e-d927c997a82a','2026-01-21 11:57:03',NULL,'CREATE','COMPLETE','0','d4cce53a-1dbf-4f9a-afab-8fb47ebd9db7','state changed','OS::Heat::SoftwareDeployment',NULL,226),(1254,'2e1b1b4f-5937-4367-8b42-0f5a6a85cdd9','0294945d-6703-4230-98ab-4d690fc3dbc0','2026-01-21 11:57:03',NULL,'CREATE','COMPLETE','0','a4558362-343c-407f-95a2-1512e9beccd0','state changed','OS::Heat::SoftwareDeployment',NULL,235),(1255,'a6741d02-a4b7-481d-bda4-98814fe0efbc','768e741e-9b75-4382-838e-d927c997a82a','2026-01-21 11:57:03',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1866873809-dep_0-mgo3wzakbg2x','768e741e-9b75-4382-838e-d927c997a82a','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1256,'a10f41c3-9eda-4e0e-9522-6e131fa041d6','38523b7b-7e98-41c7-a395-896f117d20cc','2026-01-21 11:57:03',NULL,'CREATE','COMPLETE','0','aecc5573-506e-41a0-a76f-0bf14b0430f0','state changed','OS::Heat::SoftwareDeployment',NULL,233),(1257,'2d0a4d09-807e-4cd4-908d-78963ac3c305','ec836e4b-c437-4849-8199-b6e01e5c729a','2026-01-21 11:57:03',NULL,'CREATE','COMPLETE','0','6d51d120-2c7e-44ea-b977-77fc4356adee','state changed','OS::Heat::SoftwareDeployment',NULL,234),(1258,'46b18125-7140-45db-a557-6d85252f0124','0294945d-6703-4230-98ab-4d690fc3dbc0','2026-01-21 11:57:03',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-2096988093-dep_2-rxdn3qcwg4t2','0294945d-6703-4230-98ab-4d690fc3dbc0','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1259,'954ecc31-5cbe-4493-9893-0a60dabbf116','38523b7b-7e98-41c7-a395-896f117d20cc','2026-01-21 11:57:03',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-2096988093-dep_0-fg7gck55feyd','38523b7b-7e98-41c7-a395-896f117d20cc','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1260,'81e9c377-d81e-4049-ae4c-448e6066fe5c','ec836e4b-c437-4849-8199-b6e01e5c729a','2026-01-21 11:57:03',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-2096988093-dep_1-akxfm7rpww5j','ec836e4b-c437-4849-8199-b6e01e5c729a','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1261,'3502f327-b277-46e1-8523-c61da2909283','236bc67a-e3b5-46a5-a6b7-40a6167fbd9f','2026-01-21 11:57:03',NULL,'SIGNAL','IN_PROGRESS','0','45c37430-9c0e-43e8-bf73-301193fc278b','Signal: deployment 45c37430-9c0e-43e8-bf73-301193fc278b succeeded','OS::Heat::SoftwareDeployment',NULL,207),(1262,'0c90fe14-a8ef-42a2-91de-a92af40ab999','7c8a47da-b70c-465c-8524-7bc7ecd81aa8','2026-01-21 11:57:04',NULL,'SIGNAL','IN_PROGRESS','0','4fcda30a-22ed-4947-b8a6-ffdcdff81b3f','Signal: deployment 4fcda30a-22ed-4947-b8a6-ffdcdff81b3f succeeded','OS::Heat::SoftwareDeployment',NULL,209),(1263,'093c0be3-5d82-47b9-8b1a-bac4cbecb649','178a131a-ce79-4ee2-bb62-94a2a0796054','2026-01-21 11:57:04',NULL,'CREATE','COMPLETE','dep_0','38523b7b-7e98-41c7-a395-896f117d20cc','state changed','OS::Heat::SoftwareDeployments',NULL,230),(1264,'27894063-1aa6-4e11-943b-bf0c8d705783','178a131a-ce79-4ee2-bb62-94a2a0796054','2026-01-21 11:57:04',NULL,'CREATE','COMPLETE','dep_1','ec836e4b-c437-4849-8199-b6e01e5c729a','state changed','OS::Heat::SoftwareDeployments',NULL,231),(1265,'b5adc18b-bad5-4c44-af7e-66fc137b7c85','178a131a-ce79-4ee2-bb62-94a2a0796054','2026-01-21 11:57:04',NULL,'CREATE','COMPLETE','dep_2','0294945d-6703-4230-98ab-4d690fc3dbc0','state changed','OS::Heat::SoftwareDeployments',NULL,232),(1266,'2053418a-fc6e-444b-8720-971c265eb49f','7925f319-fd76-4c59-9868-414fbb354c71','2026-01-21 11:57:04',NULL,'CREATE','COMPLETE','dep_0','768e741e-9b75-4382-838e-d927c997a82a','state changed','OS::Heat::SoftwareDeployments',NULL,223),(1267,'a08ff1c6-ea36-45a6-abed-3c8082795486','7925f319-fd76-4c59-9868-414fbb354c71','2026-01-21 11:57:04',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1866873809','7925f319-fd76-4c59-9868-414fbb354c71','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1268,'8d3ae7a1-0d7c-481f-9588-51d38d2c4899','178a131a-ce79-4ee2-bb62-94a2a0796054','2026-01-21 11:57:04',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-2096988093','178a131a-ce79-4ee2-bb62-94a2a0796054','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1269,'1b4ce7a6-3038-4cc9-89b3-1e965b13c451','7c8a47da-b70c-465c-8524-7bc7ecd81aa8','2026-01-21 11:57:04',NULL,'CREATE','COMPLETE','0','4fcda30a-22ed-4947-b8a6-ffdcdff81b3f','state changed','OS::Heat::SoftwareDeployment',NULL,209),(1270,'22511838-1809-4e95-9114-8bc06b84227d','236bc67a-e3b5-46a5-a6b7-40a6167fbd9f','2026-01-21 11:57:04',NULL,'CREATE','COMPLETE','0','45c37430-9c0e-43e8-bf73-301193fc278b','state changed','OS::Heat::SoftwareDeployment',NULL,207),(1271,'679bd509-85b7-48df-81ba-ba1972b76cbe','236bc67a-e3b5-46a5-a6b7-40a6167fbd9f','2026-01-21 11:57:04',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-2113435203-dep_0-7tgcbpbbur7m','236bc67a-e3b5-46a5-a6b7-40a6167fbd9f','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1272,'db7e979f-5874-448f-b73b-e0507dd181bc','7c8a47da-b70c-465c-8524-7bc7ecd81aa8','2026-01-21 11:57:04',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-2113435203-dep_4-igyerhnpcpyu','7c8a47da-b70c-465c-8524-7bc7ecd81aa8','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1273,'fd60c858-89a7-44a3-b292-3ee853c801c4','90b49099-672c-4cef-aa9b-a4c5f809f1db','2026-01-21 11:57:04',NULL,'SIGNAL','IN_PROGRESS','0','98d8588f-5537-4791-a906-f943c1aa080c','Signal: deployment 98d8588f-5537-4791-a906-f943c1aa080c succeeded','OS::Heat::SoftwareDeployment',NULL,208),(1274,'153991d5-5813-4680-83c1-38a20b59231c','0fc1b119-7102-4fcf-b4ba-7ddd95cc2010','2026-01-21 11:57:04',NULL,'SIGNAL','IN_PROGRESS','0','b891d246-fc70-49c4-884f-6539522f0ce9','Signal: deployment b891d246-fc70-49c4-884f-6539522f0ce9 succeeded','OS::Heat::SoftwareDeployment',NULL,210),(1275,'eb836256-64c2-45ff-b2cb-bf4168eae194','b483ae4a-d046-41f1-8621-671b02bbc747','2026-01-21 11:57:05',NULL,'SIGNAL','IN_PROGRESS','0','fd07b3d7-0694-4083-be86-0bcd82f6537b','Signal: deployment fd07b3d7-0694-4083-be86-0bcd82f6537b succeeded','OS::Heat::SoftwareDeployment',NULL,206),(1276,'f88b142f-2be0-409d-af23-f04c7ce89e52','dd905c26-f0e4-4a6d-8899-67dc446009ed','2026-01-21 11:57:05',NULL,'SIGNAL','IN_PROGRESS','0','01077e57-44ee-49a1-a7e4-613187be81cd','Signal: deployment 01077e57-44ee-49a1-a7e4-613187be81cd succeeded','OS::Heat::SoftwareDeployment',NULL,220),(1277,'8eaa1f1b-adf9-4790-bf75-d93a3ac73d99','4d407931-8eea-444e-880e-21e6f15b7a60','2026-01-21 11:57:05',NULL,'SIGNAL','IN_PROGRESS','0','49816317-336a-44c8-88cb-e88cb6fc048a','Signal: deployment 49816317-336a-44c8-88cb-e88cb6fc048a succeeded','OS::Heat::SoftwareDeployment',NULL,217),(1278,'df2a9e7c-8257-4f1d-947b-7e9848fc31e9','03b749f2-7523-4278-8861-784c4ebc22e5','2026-01-21 11:57:05',NULL,'SIGNAL','IN_PROGRESS','0','28822956-8878-4706-9fc0-1a42f239ee92','Signal: deployment 28822956-8878-4706-9fc0-1a42f239ee92 succeeded','OS::Heat::SoftwareDeployment',NULL,218),(1279,'c5c87a5a-8b81-4f59-b17f-e4ae1083c687','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:57:05',NULL,'CREATE','COMPLETE','dep_4','7c8a47da-b70c-465c-8524-7bc7ecd81aa8','state changed','OS::Heat::SoftwareDeployments',NULL,205),(1280,'f2f9ef50-491f-4990-9fbc-c1e5abcad283','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:57:05',NULL,'CREATE','COMPLETE','dep_0','236bc67a-e3b5-46a5-a6b7-40a6167fbd9f','state changed','OS::Heat::SoftwareDeployments',NULL,202),(1281,'cc9e0e01-d5ed-410b-9085-a6ad8c2b6f18','90b49099-672c-4cef-aa9b-a4c5f809f1db','2026-01-21 11:57:05',NULL,'CREATE','COMPLETE','0','98d8588f-5537-4791-a906-f943c1aa080c','state changed','OS::Heat::SoftwareDeployment',NULL,208),(1282,'2c9c3124-3318-4dab-81ab-8f1eebb12e6e','90b49099-672c-4cef-aa9b-a4c5f809f1db','2026-01-21 11:57:05',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-2113435203-dep_3-ly2wln4m4uz2','90b49099-672c-4cef-aa9b-a4c5f809f1db','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1283,'784ef654-2bcc-46c3-b04a-13ac6fde20e1','dd905c26-f0e4-4a6d-8899-67dc446009ed','2026-01-21 11:57:05',NULL,'CREATE','COMPLETE','0','01077e57-44ee-49a1-a7e4-613187be81cd','state changed','OS::Heat::SoftwareDeployment',NULL,220),(1284,'a3408c63-a6b4-4d96-84cc-e25d2ab46098','0fc1b119-7102-4fcf-b4ba-7ddd95cc2010','2026-01-21 11:57:05',NULL,'CREATE','COMPLETE','0','b891d246-fc70-49c4-884f-6539522f0ce9','state changed','OS::Heat::SoftwareDeployment',NULL,210),(1285,'21a368e2-43a6-4cc5-95e0-d91df632733b','dd905c26-f0e4-4a6d-8899-67dc446009ed','2026-01-21 11:57:05',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-301952452-dep_0-by5sjpmxhjke','dd905c26-f0e4-4a6d-8899-67dc446009ed','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1286,'a59b8113-1c1c-4909-80d5-441492fcabf0','4d407931-8eea-444e-880e-21e6f15b7a60','2026-01-21 11:57:05',NULL,'CREATE','COMPLETE','0','49816317-336a-44c8-88cb-e88cb6fc048a','state changed','OS::Heat::SoftwareDeployment',NULL,217),(1287,'5da3bf7d-e25d-4cf0-8c62-00dbe5b4e7c8','03b749f2-7523-4278-8861-784c4ebc22e5','2026-01-21 11:57:05',NULL,'CREATE','COMPLETE','0','28822956-8878-4706-9fc0-1a42f239ee92','state changed','OS::Heat::SoftwareDeployment',NULL,218),(1288,'880a64cf-ac9e-4467-92ec-c40224ac52eb','b483ae4a-d046-41f1-8621-671b02bbc747','2026-01-21 11:57:05',NULL,'CREATE','COMPLETE','0','fd07b3d7-0694-4083-be86-0bcd82f6537b','state changed','OS::Heat::SoftwareDeployment',NULL,206),(1289,'6fe765c9-0c1d-4b06-97f8-51c4f301271a','4d407931-8eea-444e-880e-21e6f15b7a60','2026-01-21 11:57:05',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-301952452-dep_3-zff3ak6gzvaf','4d407931-8eea-444e-880e-21e6f15b7a60','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1290,'9cd18563-86ea-415b-acf4-484aed5befc2','0fc1b119-7102-4fcf-b4ba-7ddd95cc2010','2026-01-21 11:57:05',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-2113435203-dep_1-nl3oxy2eraww','0fc1b119-7102-4fcf-b4ba-7ddd95cc2010','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1291,'85ded2c4-e96d-4c1d-a5b9-576eba5de797','03b749f2-7523-4278-8861-784c4ebc22e5','2026-01-21 11:57:05',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-301952452-dep_1-xbabmewwqmyx','03b749f2-7523-4278-8861-784c4ebc22e5','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1292,'b30c5c7d-765c-409c-bc69-5c5316a793be','b483ae4a-d046-41f1-8621-671b02bbc747','2026-01-21 11:57:05',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-2113435203-dep_2-mlh47nro7bwk','b483ae4a-d046-41f1-8621-671b02bbc747','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1293,'68897904-d3fa-41d4-b301-5beae746c21d','21acd278-066f-43a1-a33b-9ceaf407dc2e','2026-01-21 11:57:05',NULL,'SIGNAL','IN_PROGRESS','0','bb0034b4-c39b-4b27-94e5-c9295077b29f','Signal: deployment bb0034b4-c39b-4b27-94e5-c9295077b29f succeeded','OS::Heat::SoftwareDeployment',NULL,219),(1294,'6e599f42-7bd6-4120-9327-efc09703f052','58fc8ddd-3677-4a8a-a759-27fd0c26425f','2026-01-21 11:57:05',NULL,'SIGNAL','IN_PROGRESS','0','e8764909-1933-49af-8f5c-8e6613584996','Signal: deployment e8764909-1933-49af-8f5c-8e6613584996 succeeded','OS::Heat::SoftwareDeployment',NULL,221),(1295,'4ed2264b-c135-4555-99d2-d4eb13736ea3','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:57:07',NULL,'CREATE','COMPLETE','dep_2','b483ae4a-d046-41f1-8621-671b02bbc747','state changed','OS::Heat::SoftwareDeployments',NULL,203),(1296,'b9565938-bcf9-423d-945b-7f4f080b0e24','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:57:07',NULL,'CREATE','COMPLETE','dep_1','03b749f2-7523-4278-8861-784c4ebc22e5','state changed','OS::Heat::SoftwareDeployments',NULL,214),(1297,'71374fb6-b125-4764-82c5-8b6bef71c05d','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:57:07',NULL,'CREATE','COMPLETE','dep_3','90b49099-672c-4cef-aa9b-a4c5f809f1db','state changed','OS::Heat::SoftwareDeployments',NULL,201),(1298,'a5ba4c55-eb04-405e-9745-4f5263486fd4','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:57:07',NULL,'CREATE','COMPLETE','dep_0','dd905c26-f0e4-4a6d-8899-67dc446009ed','state changed','OS::Heat::SoftwareDeployments',NULL,213),(1299,'09b923f1-7463-45b1-8947-7cf9fec33260','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:57:07',NULL,'CREATE','COMPLETE','dep_1','0fc1b119-7102-4fcf-b4ba-7ddd95cc2010','state changed','OS::Heat::SoftwareDeployments',NULL,204),(1300,'93a17069-992a-42dd-9267-5a9cd19ba1ab','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:57:07',NULL,'CREATE','COMPLETE','dep_3','4d407931-8eea-444e-880e-21e6f15b7a60','state changed','OS::Heat::SoftwareDeployments',NULL,212),(1301,'3e3a80a8-59aa-4c5f-8979-53fb8a434232','58fc8ddd-3677-4a8a-a759-27fd0c26425f','2026-01-21 11:57:07',NULL,'CREATE','COMPLETE','0','e8764909-1933-49af-8f5c-8e6613584996','state changed','OS::Heat::SoftwareDeployment',NULL,221),(1302,'5b034bb0-54c6-42a7-ab68-ef2c7030a52d','21acd278-066f-43a1-a33b-9ceaf407dc2e','2026-01-21 11:57:07',NULL,'CREATE','COMPLETE','0','bb0034b4-c39b-4b27-94e5-c9295077b29f','state changed','OS::Heat::SoftwareDeployment',NULL,219),(1303,'39dc1d49-cd45-4d1e-8b24-e2c15415810a','21acd278-066f-43a1-a33b-9ceaf407dc2e','2026-01-21 11:57:07',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-301952452-dep_2-zibtn4kmuwn7','21acd278-066f-43a1-a33b-9ceaf407dc2e','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1304,'83eea1f5-4d67-4b6f-b20b-205067082f66','58fc8ddd-3677-4a8a-a759-27fd0c26425f','2026-01-21 11:57:07',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-301952452-dep_4-bsszwontpt7g','58fc8ddd-3677-4a8a-a759-27fd0c26425f','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1305,'e0d09d31-8320-413e-8583-6b608ed31ea5','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:57:07',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-2113435203','827ee19c-f116-4d62-bf09-2e58e17938e5','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1306,'2a28878c-fd67-4e04-a17d-8c4d7c732c86','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:57:08',NULL,'CREATE','COMPLETE','dep_2','21acd278-066f-43a1-a33b-9ceaf407dc2e','state changed','OS::Heat::SoftwareDeployments',NULL,216),(1307,'1366751b-e76f-4b70-8c7b-5e86ea0f9629','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:57:08',NULL,'CREATE','COMPLETE','dep_4','58fc8ddd-3677-4a8a-a759-27fd0c26425f','state changed','OS::Heat::SoftwareDeployments',NULL,215),(1308,'66ff8475-bf81-4c33-872b-a3427ad91e15','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:57:08',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-301952452','13987ec4-949c-42d2-baa5-adc025c61eb8','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1309,'66f47e11-40e6-40c6-90cb-64c185b33b7e','dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','2026-01-21 11:57:10',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-125988841','dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1310,'f6521fb3-4f8f-4f40-84ce-59eb65ed0464','dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','2026-01-21 11:57:10',NULL,'DELETE','IN_PROGRESS','dep_0','2775bcdb-7752-4db2-b0c0-132c2db0ac3d','state changed','OS::Heat::SoftwareDeployments',NULL,237),(1311,'4b4dd2f4-6e7b-48a4-a9be-4d8b08ddc7b0','2775bcdb-7752-4db2-b0c0-132c2db0ac3d','2026-01-21 11:57:10',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-125988841-dep_0-l3zl7pnvvcf4','2775bcdb-7752-4db2-b0c0-132c2db0ac3d','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1312,'ebb361fc-363d-42e7-aecb-599a7be7c72f','2775bcdb-7752-4db2-b0c0-132c2db0ac3d','2026-01-21 11:57:10',NULL,'DELETE','IN_PROGRESS','0','229963ad-2d3b-4aad-beb1-5f43aaedd68f','state changed','OS::Heat::SoftwareDeployment',NULL,240),(1313,'0b48beb5-508a-4fc7-afd8-f2cf4f4fe3a4','2775bcdb-7752-4db2-b0c0-132c2db0ac3d','2026-01-21 11:57:11',NULL,'DELETE','COMPLETE','0','229963ad-2d3b-4aad-beb1-5f43aaedd68f','state changed','OS::Heat::SoftwareDeployment',NULL,240),(1314,'9953c5c1-85af-4486-b885-5082bdcc2a2b','dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','2026-01-21 11:57:11',NULL,'DELETE','IN_PROGRESS','dep_2','73c75274-23fe-4304-afa9-7f421c5e396c','state changed','OS::Heat::SoftwareDeployments',NULL,238),(1315,'5f75df42-6420-43da-a81f-d72dc56427ab','2775bcdb-7752-4db2-b0c0-132c2db0ac3d','2026-01-21 11:57:11',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-125988841-dep_0-l3zl7pnvvcf4','2775bcdb-7752-4db2-b0c0-132c2db0ac3d','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1316,'a82ee383-7fe8-4e5e-b677-e560f078540e','73c75274-23fe-4304-afa9-7f421c5e396c','2026-01-21 11:57:11',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-125988841-dep_2-okv2ldgsvg7p','73c75274-23fe-4304-afa9-7f421c5e396c','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1317,'81a102b0-2cf2-4a8c-9cf5-2c0894193ef6','73c75274-23fe-4304-afa9-7f421c5e396c','2026-01-21 11:57:11',NULL,'DELETE','IN_PROGRESS','0','c98b90d2-d0e6-4bd5-b9ed-fa4d27bd95ea','state changed','OS::Heat::SoftwareDeployment',NULL,241),(1318,'de72bf5a-62e3-4820-bd4c-928fc0d53e33','dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','2026-01-21 11:57:12',NULL,'DELETE','COMPLETE','dep_0','2775bcdb-7752-4db2-b0c0-132c2db0ac3d','state changed','OS::Heat::SoftwareDeployments',NULL,237),(1319,'6de1763e-dada-4846-b0c0-63c3f7205101','dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','2026-01-21 11:57:12',NULL,'DELETE','IN_PROGRESS','dep_1','f50745fa-ce29-4543-a581-b048a3fdd80b','state changed','OS::Heat::SoftwareDeployments',NULL,239),(1320,'c20a6b8f-a0ca-48cb-8553-ae94625b28f0','f50745fa-ce29-4543-a581-b048a3fdd80b','2026-01-21 11:57:12',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-125988841-dep_1-4gq4fnryqpmh','f50745fa-ce29-4543-a581-b048a3fdd80b','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1321,'df6ddd93-c19a-49fb-a860-096efdeccfda','f50745fa-ce29-4543-a581-b048a3fdd80b','2026-01-21 11:57:12',NULL,'DELETE','IN_PROGRESS','0','a483aea1-6db7-466c-b249-a39859e4ee63','state changed','OS::Heat::SoftwareDeployment',NULL,242),(1322,'e812b163-9e0b-44ad-931a-d450d22be556','73c75274-23fe-4304-afa9-7f421c5e396c','2026-01-21 11:57:12',NULL,'DELETE','COMPLETE','0','c98b90d2-d0e6-4bd5-b9ed-fa4d27bd95ea','state changed','OS::Heat::SoftwareDeployment',NULL,241),(1323,'8f9f77cf-eb04-4d98-84e5-f1f99813b9ea','73c75274-23fe-4304-afa9-7f421c5e396c','2026-01-21 11:57:12',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-125988841-dep_2-okv2ldgsvg7p','73c75274-23fe-4304-afa9-7f421c5e396c','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1324,'a89ba77a-6bb3-4568-942f-76090193ce5f','dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','2026-01-21 11:57:13',NULL,'DELETE','COMPLETE','dep_2','73c75274-23fe-4304-afa9-7f421c5e396c','state changed','OS::Heat::SoftwareDeployments',NULL,238),(1325,'46c7a877-8944-4ddb-9a85-98fe94545263','f50745fa-ce29-4543-a581-b048a3fdd80b','2026-01-21 11:57:13',NULL,'DELETE','COMPLETE','0','a483aea1-6db7-466c-b249-a39859e4ee63','state changed','OS::Heat::SoftwareDeployment',NULL,242),(1326,'516c9350-0e97-4380-9968-206a7f1a5f1e','f50745fa-ce29-4543-a581-b048a3fdd80b','2026-01-21 11:57:13',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-125988841-dep_1-4gq4fnryqpmh','f50745fa-ce29-4543-a581-b048a3fdd80b','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1327,'4fce1a3c-69d2-4261-a8ad-b3193562dd22','dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','2026-01-21 11:57:14',NULL,'DELETE','COMPLETE','dep_1','f50745fa-ce29-4543-a581-b048a3fdd80b','state changed','OS::Heat::SoftwareDeployments',NULL,239),(1328,'83c2c9cb-e69d-49b5-ab58-2abaf111e080','dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','2026-01-21 11:57:14',NULL,'DELETE','IN_PROGRESS','config','d2cbf5cf-4d45-416a-b5b2-0613e8b26bd8','state changed','OS::Heat::SoftwareConfig',NULL,236),(1329,'757650e8-ba10-4371-a866-bfc88c1d6371','dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','2026-01-21 11:57:14',NULL,'DELETE','COMPLETE','config','d2cbf5cf-4d45-416a-b5b2-0613e8b26bd8','state changed','OS::Heat::SoftwareConfig',NULL,236),(1330,'84dcf5ca-009b-4877-bef5-a8680b00a726','dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','2026-01-21 11:57:14',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-125988841','dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1331,'fac2898d-0d30-4a79-a603-176f91218727','178a131a-ce79-4ee2-bb62-94a2a0796054','2026-01-21 11:57:19',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-2096988093','178a131a-ce79-4ee2-bb62-94a2a0796054','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1332,'2fbbba39-0ec2-4c00-947f-3e8d2e712e4a','178a131a-ce79-4ee2-bb62-94a2a0796054','2026-01-21 11:57:19',NULL,'DELETE','IN_PROGRESS','dep_1','ec836e4b-c437-4849-8199-b6e01e5c729a','state changed','OS::Heat::SoftwareDeployments',NULL,231),(1333,'f4d4976a-c09f-4ee1-bf84-50f940c8f4de','ec836e4b-c437-4849-8199-b6e01e5c729a','2026-01-21 11:57:19',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-2096988093-dep_1-akxfm7rpww5j','ec836e4b-c437-4849-8199-b6e01e5c729a','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1334,'63def740-0e40-4539-a58b-72d801e40b44','ec836e4b-c437-4849-8199-b6e01e5c729a','2026-01-21 11:57:19',NULL,'DELETE','IN_PROGRESS','0','6d51d120-2c7e-44ea-b977-77fc4356adee','state changed','OS::Heat::SoftwareDeployment',NULL,234),(1335,'7f90deb9-2f40-49d0-a5c3-a8a8bba5f310','ec836e4b-c437-4849-8199-b6e01e5c729a','2026-01-21 11:57:20',NULL,'DELETE','COMPLETE','0','6d51d120-2c7e-44ea-b977-77fc4356adee','state changed','OS::Heat::SoftwareDeployment',NULL,234),(1336,'8c4d7716-8db7-418b-becf-d2a6d613468e','ec836e4b-c437-4849-8199-b6e01e5c729a','2026-01-21 11:57:20',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-2096988093-dep_1-akxfm7rpww5j','ec836e4b-c437-4849-8199-b6e01e5c729a','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1337,'4ec70266-48a8-4618-800a-3b407c5fa1d1','178a131a-ce79-4ee2-bb62-94a2a0796054','2026-01-21 11:57:20',NULL,'DELETE','IN_PROGRESS','dep_0','38523b7b-7e98-41c7-a395-896f117d20cc','state changed','OS::Heat::SoftwareDeployments',NULL,230),(1338,'88f04f7c-b3fe-44e3-b6b2-7f6efe82deef','178a131a-ce79-4ee2-bb62-94a2a0796054','2026-01-21 11:57:21',NULL,'DELETE','COMPLETE','dep_1','ec836e4b-c437-4849-8199-b6e01e5c729a','state changed','OS::Heat::SoftwareDeployments',NULL,231),(1339,'1a6d2573-69b7-4cf8-9a7f-11787ac1672f','38523b7b-7e98-41c7-a395-896f117d20cc','2026-01-21 11:57:21',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-2096988093-dep_0-fg7gck55feyd','38523b7b-7e98-41c7-a395-896f117d20cc','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1340,'a461df03-0f01-4813-b999-b205dc3ca72b','38523b7b-7e98-41c7-a395-896f117d20cc','2026-01-21 11:57:21',NULL,'DELETE','IN_PROGRESS','0','aecc5573-506e-41a0-a76f-0bf14b0430f0','state changed','OS::Heat::SoftwareDeployment',NULL,233),(1341,'56443d02-14c6-432a-a342-623c440fd879','178a131a-ce79-4ee2-bb62-94a2a0796054','2026-01-21 11:57:21',NULL,'DELETE','IN_PROGRESS','dep_2','0294945d-6703-4230-98ab-4d690fc3dbc0','state changed','OS::Heat::SoftwareDeployments',NULL,232),(1342,'9267fe89-4cf7-4ebf-a2b0-4920fad8383b','0294945d-6703-4230-98ab-4d690fc3dbc0','2026-01-21 11:57:22',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-2096988093-dep_2-rxdn3qcwg4t2','0294945d-6703-4230-98ab-4d690fc3dbc0','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1343,'af5156b4-c016-4731-8c40-ef117ba176bc','0294945d-6703-4230-98ab-4d690fc3dbc0','2026-01-21 11:57:22',NULL,'DELETE','IN_PROGRESS','0','a4558362-343c-407f-95a2-1512e9beccd0','state changed','OS::Heat::SoftwareDeployment',NULL,235),(1344,'48f3bd20-4d70-4548-982e-5de4aa210074','38523b7b-7e98-41c7-a395-896f117d20cc','2026-01-21 11:57:22',NULL,'DELETE','COMPLETE','0','aecc5573-506e-41a0-a76f-0bf14b0430f0','state changed','OS::Heat::SoftwareDeployment',NULL,233),(1345,'e3d3e18e-396e-4fb2-a097-22a78e9f2012','38523b7b-7e98-41c7-a395-896f117d20cc','2026-01-21 11:57:22',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-2096988093-dep_0-fg7gck55feyd','38523b7b-7e98-41c7-a395-896f117d20cc','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1346,'8ead4f98-63a3-4b1a-a048-917fa1c4014c','178a131a-ce79-4ee2-bb62-94a2a0796054','2026-01-21 11:57:22',NULL,'DELETE','COMPLETE','dep_0','38523b7b-7e98-41c7-a395-896f117d20cc','state changed','OS::Heat::SoftwareDeployments',NULL,230),(1347,'f3881cc3-99b8-411e-8dff-1ef7baf69898','0294945d-6703-4230-98ab-4d690fc3dbc0','2026-01-21 11:57:22',NULL,'DELETE','COMPLETE','0','a4558362-343c-407f-95a2-1512e9beccd0','state changed','OS::Heat::SoftwareDeployment',NULL,235),(1348,'7fd61369-03ef-4e9f-93dc-48c654230cfb','0294945d-6703-4230-98ab-4d690fc3dbc0','2026-01-21 11:57:22',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-2096988093-dep_2-rxdn3qcwg4t2','0294945d-6703-4230-98ab-4d690fc3dbc0','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1349,'0a6f8c4f-dd5a-419b-a18b-59ee8b9fff5d','178a131a-ce79-4ee2-bb62-94a2a0796054','2026-01-21 11:57:23',NULL,'DELETE','COMPLETE','dep_2','0294945d-6703-4230-98ab-4d690fc3dbc0','state changed','OS::Heat::SoftwareDeployments',NULL,232),(1350,'6780fd00-860e-49d9-bbc7-bea8c6752732','178a131a-ce79-4ee2-bb62-94a2a0796054','2026-01-21 11:57:23',NULL,'DELETE','IN_PROGRESS','config','6ba63002-f444-4cd2-b43c-7362c3007d78','state changed','OS::Heat::SoftwareConfig',NULL,229),(1351,'2ac58cec-d7e4-4bf8-9171-b97c5e6a07b1','178a131a-ce79-4ee2-bb62-94a2a0796054','2026-01-21 11:57:23',NULL,'DELETE','COMPLETE','config','6ba63002-f444-4cd2-b43c-7362c3007d78','state changed','OS::Heat::SoftwareConfig',NULL,229),(1352,'00f2955d-5686-4f5d-b048-9d11510ea743','178a131a-ce79-4ee2-bb62-94a2a0796054','2026-01-21 11:57:23',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-2096988093','178a131a-ce79-4ee2-bb62-94a2a0796054','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1353,'a400b4c6-a647-4b0d-a60c-207e83bedbdc','7925f319-fd76-4c59-9868-414fbb354c71','2026-01-21 11:57:29',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1866873809','7925f319-fd76-4c59-9868-414fbb354c71','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1354,'18f22970-4c60-4ac6-b6c6-aeea467c26c8','7925f319-fd76-4c59-9868-414fbb354c71','2026-01-21 11:57:29',NULL,'DELETE','IN_PROGRESS','dep_2','bbd1ce7e-39ea-4ea2-96ad-edfd62e07da1','state changed','OS::Heat::SoftwareDeployments',NULL,224),(1355,'7444cc53-4b88-4203-a833-50f334e02eaf','bbd1ce7e-39ea-4ea2-96ad-edfd62e07da1','2026-01-21 11:57:29',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1866873809-dep_2-aye4jz7qukex','bbd1ce7e-39ea-4ea2-96ad-edfd62e07da1','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1356,'54c77ec1-fd87-4730-be70-9108e3bea103','bbd1ce7e-39ea-4ea2-96ad-edfd62e07da1','2026-01-21 11:57:29',NULL,'DELETE','IN_PROGRESS','0','bbb683ce-56f8-420f-882b-46972d5c4f18','state changed','OS::Heat::SoftwareDeployment',NULL,228),(1357,'74e5d551-7afb-4fee-bdff-86fba1984422','bbd1ce7e-39ea-4ea2-96ad-edfd62e07da1','2026-01-21 11:57:30',NULL,'DELETE','COMPLETE','0','bbb683ce-56f8-420f-882b-46972d5c4f18','state changed','OS::Heat::SoftwareDeployment',NULL,228),(1358,'18a6a728-6f37-432c-b178-bf570dbd4174','bbd1ce7e-39ea-4ea2-96ad-edfd62e07da1','2026-01-21 11:57:30',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1866873809-dep_2-aye4jz7qukex','bbd1ce7e-39ea-4ea2-96ad-edfd62e07da1','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1359,'1dac841b-6038-409c-b4fe-205230d0df0f','7925f319-fd76-4c59-9868-414fbb354c71','2026-01-21 11:57:31',NULL,'DELETE','COMPLETE','dep_2','bbd1ce7e-39ea-4ea2-96ad-edfd62e07da1','state changed','OS::Heat::SoftwareDeployments',NULL,224),(1360,'eecd9a3a-c099-4242-a84e-3d41057c17c0','7925f319-fd76-4c59-9868-414fbb354c71','2026-01-21 11:57:31',NULL,'DELETE','IN_PROGRESS','dep_1','7cf68aa3-10a1-4ffc-8f40-9a7889af38a2','state changed','OS::Heat::SoftwareDeployments',NULL,225),(1361,'a4b95efb-8aa2-423a-9541-cc5ab157900d','7cf68aa3-10a1-4ffc-8f40-9a7889af38a2','2026-01-21 11:57:31',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1866873809-dep_1-kwk4zudk72bz','7cf68aa3-10a1-4ffc-8f40-9a7889af38a2','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1362,'cecba189-5cdc-4de3-9303-fbad009cedba','7cf68aa3-10a1-4ffc-8f40-9a7889af38a2','2026-01-21 11:57:31',NULL,'DELETE','IN_PROGRESS','0','be1cc34d-fe63-4f74-b18c-578fd70f36e1','state changed','OS::Heat::SoftwareDeployment',NULL,227),(1363,'c5bd25a0-f893-41d1-9d4b-5798aee0543a','7925f319-fd76-4c59-9868-414fbb354c71','2026-01-21 11:57:32',NULL,'DELETE','IN_PROGRESS','dep_0','768e741e-9b75-4382-838e-d927c997a82a','state changed','OS::Heat::SoftwareDeployments',NULL,223),(1364,'b4c4f712-8a12-4e49-8f95-10efab2f09dd','768e741e-9b75-4382-838e-d927c997a82a','2026-01-21 11:57:32',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1866873809-dep_0-mgo3wzakbg2x','768e741e-9b75-4382-838e-d927c997a82a','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1365,'a65054dd-f30a-4129-b3f7-62626f7c6990','768e741e-9b75-4382-838e-d927c997a82a','2026-01-21 11:57:32',NULL,'DELETE','IN_PROGRESS','0','d4cce53a-1dbf-4f9a-afab-8fb47ebd9db7','state changed','OS::Heat::SoftwareDeployment',NULL,226),(1366,'9dd80f8e-4b89-4d22-b620-a0fd16589f9e','7cf68aa3-10a1-4ffc-8f40-9a7889af38a2','2026-01-21 11:57:32',NULL,'DELETE','COMPLETE','0','be1cc34d-fe63-4f74-b18c-578fd70f36e1','state changed','OS::Heat::SoftwareDeployment',NULL,227),(1367,'44afd14b-cffc-4306-a874-6bf3b2ca04a0','7cf68aa3-10a1-4ffc-8f40-9a7889af38a2','2026-01-21 11:57:32',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1866873809-dep_1-kwk4zudk72bz','7cf68aa3-10a1-4ffc-8f40-9a7889af38a2','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1368,'cf17ed1c-820c-44ba-9937-5184e09913dc','7925f319-fd76-4c59-9868-414fbb354c71','2026-01-21 11:57:32',NULL,'DELETE','COMPLETE','dep_1','7cf68aa3-10a1-4ffc-8f40-9a7889af38a2','state changed','OS::Heat::SoftwareDeployments',NULL,225),(1369,'181a8335-ef53-4a23-a735-cf5a811d2818','768e741e-9b75-4382-838e-d927c997a82a','2026-01-21 11:57:32',NULL,'DELETE','COMPLETE','0','d4cce53a-1dbf-4f9a-afab-8fb47ebd9db7','state changed','OS::Heat::SoftwareDeployment',NULL,226),(1370,'a63214fe-cd4d-4058-9c64-0c03c069df7f','768e741e-9b75-4382-838e-d927c997a82a','2026-01-21 11:57:32',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1866873809-dep_0-mgo3wzakbg2x','768e741e-9b75-4382-838e-d927c997a82a','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1371,'bff1de64-5efa-4e6a-b779-c918fbea9f30','7925f319-fd76-4c59-9868-414fbb354c71','2026-01-21 11:57:33',NULL,'DELETE','COMPLETE','dep_0','768e741e-9b75-4382-838e-d927c997a82a','state changed','OS::Heat::SoftwareDeployments',NULL,223),(1372,'142ef25b-0d82-4e2c-855f-515098248232','7925f319-fd76-4c59-9868-414fbb354c71','2026-01-21 11:57:33',NULL,'DELETE','IN_PROGRESS','config','a6d3dfa2-e685-4854-ae22-24ba8b422c62','state changed','OS::Heat::SoftwareConfig',NULL,222),(1373,'a01cda1f-66f8-4384-9f17-43d8fe934537','7925f319-fd76-4c59-9868-414fbb354c71','2026-01-21 11:57:33',NULL,'DELETE','COMPLETE','config','a6d3dfa2-e685-4854-ae22-24ba8b422c62','state changed','OS::Heat::SoftwareConfig',NULL,222),(1374,'8e805c69-d83f-48d2-94bf-f3063e9e2a4a','7925f319-fd76-4c59-9868-414fbb354c71','2026-01-21 11:57:33',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1866873809','7925f319-fd76-4c59-9868-414fbb354c71','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1375,'fabb0a42-6b67-4281-92b0-70f15ccaca8e','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:57:34',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-301952452','13987ec4-949c-42d2-baa5-adc025c61eb8','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1376,'9e827f29-93d3-46e7-8eab-1761837f1171','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:57:34',NULL,'DELETE','IN_PROGRESS','dep_3','4d407931-8eea-444e-880e-21e6f15b7a60','state changed','OS::Heat::SoftwareDeployments',NULL,212),(1377,'3e27cfcd-fd41-4cf7-9262-c9777c6acadf','4d407931-8eea-444e-880e-21e6f15b7a60','2026-01-21 11:57:34',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-301952452-dep_3-zff3ak6gzvaf','4d407931-8eea-444e-880e-21e6f15b7a60','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1378,'08cf8415-3754-43b2-b751-232f764edaf6','4d407931-8eea-444e-880e-21e6f15b7a60','2026-01-21 11:57:34',NULL,'DELETE','IN_PROGRESS','0','49816317-336a-44c8-88cb-e88cb6fc048a','state changed','OS::Heat::SoftwareDeployment',NULL,217),(1379,'329c4a0e-c967-4d16-846d-6df4d21e24d3','4d407931-8eea-444e-880e-21e6f15b7a60','2026-01-21 11:57:35',NULL,'DELETE','COMPLETE','0','49816317-336a-44c8-88cb-e88cb6fc048a','state changed','OS::Heat::SoftwareDeployment',NULL,217),(1380,'bdef786f-eb7e-47bd-8f79-0e8c0392f0b8','4d407931-8eea-444e-880e-21e6f15b7a60','2026-01-21 11:57:35',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-301952452-dep_3-zff3ak6gzvaf','4d407931-8eea-444e-880e-21e6f15b7a60','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1381,'38a07616-ed53-4cd1-8ba9-0ce1cb56f466','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:57:35',NULL,'DELETE','IN_PROGRESS','dep_4','58fc8ddd-3677-4a8a-a759-27fd0c26425f','state changed','OS::Heat::SoftwareDeployments',NULL,215),(1382,'4add3ce0-75d1-48da-a938-67af10d66393','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:57:35',NULL,'DELETE','COMPLETE','dep_3','4d407931-8eea-444e-880e-21e6f15b7a60','state changed','OS::Heat::SoftwareDeployments',NULL,212),(1383,'18c7cced-90f8-4d6f-9e21-de3ece734393','58fc8ddd-3677-4a8a-a759-27fd0c26425f','2026-01-21 11:57:35',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-301952452-dep_4-bsszwontpt7g','58fc8ddd-3677-4a8a-a759-27fd0c26425f','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1384,'eccf0883-4f5f-49ca-87a5-01b5908b108e','58fc8ddd-3677-4a8a-a759-27fd0c26425f','2026-01-21 11:57:35',NULL,'DELETE','IN_PROGRESS','0','e8764909-1933-49af-8f5c-8e6613584996','state changed','OS::Heat::SoftwareDeployment',NULL,221),(1385,'1a88bc72-dcc0-41b8-a559-10e8c2d6ceac','58fc8ddd-3677-4a8a-a759-27fd0c26425f','2026-01-21 11:57:36',NULL,'DELETE','COMPLETE','0','e8764909-1933-49af-8f5c-8e6613584996','state changed','OS::Heat::SoftwareDeployment',NULL,221),(1386,'817fbbd7-88bd-44d7-959d-783a1731e893','58fc8ddd-3677-4a8a-a759-27fd0c26425f','2026-01-21 11:57:36',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-301952452-dep_4-bsszwontpt7g','58fc8ddd-3677-4a8a-a759-27fd0c26425f','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1387,'ab65b38a-4e86-44e6-bea9-6ad70ab22087','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:57:36',NULL,'DELETE','IN_PROGRESS','dep_0','dd905c26-f0e4-4a6d-8899-67dc446009ed','state changed','OS::Heat::SoftwareDeployments',NULL,213),(1388,'479fc86e-7bbf-40b4-b4fc-4763dec257c1','dd905c26-f0e4-4a6d-8899-67dc446009ed','2026-01-21 11:57:36',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-301952452-dep_0-by5sjpmxhjke','dd905c26-f0e4-4a6d-8899-67dc446009ed','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1389,'2a63d49f-27f6-46de-a6e0-e54086b58f50','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:57:36',NULL,'DELETE','COMPLETE','dep_4','58fc8ddd-3677-4a8a-a759-27fd0c26425f','state changed','OS::Heat::SoftwareDeployments',NULL,215),(1390,'2a4f4628-ab5f-40a0-814f-0e6f251ef856','dd905c26-f0e4-4a6d-8899-67dc446009ed','2026-01-21 11:57:36',NULL,'DELETE','IN_PROGRESS','0','01077e57-44ee-49a1-a7e4-613187be81cd','state changed','OS::Heat::SoftwareDeployment',NULL,220),(1391,'cdfabfde-25f4-4272-adf6-59bc05846abb','dd905c26-f0e4-4a6d-8899-67dc446009ed','2026-01-21 11:57:37',NULL,'DELETE','COMPLETE','0','01077e57-44ee-49a1-a7e4-613187be81cd','state changed','OS::Heat::SoftwareDeployment',NULL,220),(1392,'ea61f6b7-822f-4c54-8e38-cd356d5557a8','dd905c26-f0e4-4a6d-8899-67dc446009ed','2026-01-21 11:57:37',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-301952452-dep_0-by5sjpmxhjke','dd905c26-f0e4-4a6d-8899-67dc446009ed','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1393,'42801233-5b4a-45cc-85b8-8daca4517de1','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:57:37',NULL,'DELETE','IN_PROGRESS','dep_2','21acd278-066f-43a1-a33b-9ceaf407dc2e','state changed','OS::Heat::SoftwareDeployments',NULL,216),(1394,'2208fd32-1578-4147-a802-e0baaf7a85b7','21acd278-066f-43a1-a33b-9ceaf407dc2e','2026-01-21 11:57:37',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-301952452-dep_2-zibtn4kmuwn7','21acd278-066f-43a1-a33b-9ceaf407dc2e','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1395,'8b016578-94bd-4b00-a5ae-78d34a4d4be5','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:57:37',NULL,'DELETE','COMPLETE','dep_0','dd905c26-f0e4-4a6d-8899-67dc446009ed','state changed','OS::Heat::SoftwareDeployments',NULL,213),(1396,'629f2259-c083-4690-b3a6-8d6335a51fe5','21acd278-066f-43a1-a33b-9ceaf407dc2e','2026-01-21 11:57:37',NULL,'DELETE','IN_PROGRESS','0','bb0034b4-c39b-4b27-94e5-c9295077b29f','state changed','OS::Heat::SoftwareDeployment',NULL,219),(1397,'9dbb0172-f700-4899-a02d-41b6571505b2','21acd278-066f-43a1-a33b-9ceaf407dc2e','2026-01-21 11:57:38',NULL,'DELETE','COMPLETE','0','bb0034b4-c39b-4b27-94e5-c9295077b29f','state changed','OS::Heat::SoftwareDeployment',NULL,219),(1398,'ddc94dea-658c-447b-bf03-bc0f59fe6f77','21acd278-066f-43a1-a33b-9ceaf407dc2e','2026-01-21 11:57:38',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-301952452-dep_2-zibtn4kmuwn7','21acd278-066f-43a1-a33b-9ceaf407dc2e','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1399,'6e04ece1-97aa-4ec4-a812-0ab3ecb3fa4d','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:57:39',NULL,'DELETE','COMPLETE','dep_2','21acd278-066f-43a1-a33b-9ceaf407dc2e','state changed','OS::Heat::SoftwareDeployments',NULL,216),(1400,'99e9ae23-e7af-4898-8572-acbb81ca9c1f','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:57:39',NULL,'DELETE','IN_PROGRESS','dep_1','03b749f2-7523-4278-8861-784c4ebc22e5','state changed','OS::Heat::SoftwareDeployments',NULL,214),(1401,'32fd3ec0-e0b9-449c-95bb-1861e1a59fcf','03b749f2-7523-4278-8861-784c4ebc22e5','2026-01-21 11:57:39',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-301952452-dep_1-xbabmewwqmyx','03b749f2-7523-4278-8861-784c4ebc22e5','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1402,'20f39d52-4e64-4294-88c2-7ac6dbc31ee1','03b749f2-7523-4278-8861-784c4ebc22e5','2026-01-21 11:57:39',NULL,'DELETE','IN_PROGRESS','0','28822956-8878-4706-9fc0-1a42f239ee92','state changed','OS::Heat::SoftwareDeployment',NULL,218),(1403,'43116262-3669-44e1-939f-ce2da4e8eee7','03b749f2-7523-4278-8861-784c4ebc22e5','2026-01-21 11:57:40',NULL,'DELETE','COMPLETE','0','28822956-8878-4706-9fc0-1a42f239ee92','state changed','OS::Heat::SoftwareDeployment',NULL,218),(1404,'01fadfc2-a16c-4b9a-b4d1-f9d98cc921ed','03b749f2-7523-4278-8861-784c4ebc22e5','2026-01-21 11:57:40',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-301952452-dep_1-xbabmewwqmyx','03b749f2-7523-4278-8861-784c4ebc22e5','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1405,'c8fa02e1-e324-43e4-81bf-5b2ab7f8f0e9','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:57:40',NULL,'DELETE','COMPLETE','dep_1','03b749f2-7523-4278-8861-784c4ebc22e5','state changed','OS::Heat::SoftwareDeployments',NULL,214),(1406,'a5026e0f-345b-439d-a571-30aec2134567','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:57:40',NULL,'DELETE','IN_PROGRESS','config','40e09982-598f-4462-add4-00eda355d0ef','state changed','OS::Heat::SoftwareConfig',NULL,211),(1407,'988496f0-4499-4f60-83ec-ee114fc314fe','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:57:40',NULL,'DELETE','COMPLETE','config','40e09982-598f-4462-add4-00eda355d0ef','state changed','OS::Heat::SoftwareConfig',NULL,211),(1408,'4a6deff9-bf87-4b0d-b0ca-0c03ed840c89','13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:57:40',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-301952452','13987ec4-949c-42d2-baa5-adc025c61eb8','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1409,'b3beab2a-8bce-4d78-93d5-ede21b386f77','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:57:44',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-2113435203','827ee19c-f116-4d62-bf09-2e58e17938e5','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1410,'54389d57-dc52-4bd4-bd89-bd08be34ccb9','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:57:44',NULL,'DELETE','IN_PROGRESS','dep_1','0fc1b119-7102-4fcf-b4ba-7ddd95cc2010','state changed','OS::Heat::SoftwareDeployments',NULL,204),(1411,'aa3040c4-5c1c-461d-b64e-ea5b2821963c','0fc1b119-7102-4fcf-b4ba-7ddd95cc2010','2026-01-21 11:57:45',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-2113435203-dep_1-nl3oxy2eraww','0fc1b119-7102-4fcf-b4ba-7ddd95cc2010','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1412,'4ad2b03e-7907-4901-9df8-aa36bad4c77f','0fc1b119-7102-4fcf-b4ba-7ddd95cc2010','2026-01-21 11:57:45',NULL,'DELETE','IN_PROGRESS','0','b891d246-fc70-49c4-884f-6539522f0ce9','state changed','OS::Heat::SoftwareDeployment',NULL,210),(1413,'06118d35-a7b0-41b1-b6bd-5ef3c7d48b46','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:57:45',NULL,'DELETE','IN_PROGRESS','dep_3','90b49099-672c-4cef-aa9b-a4c5f809f1db','state changed','OS::Heat::SoftwareDeployments',NULL,201),(1414,'a9bca6de-f552-446d-85aa-665386666393','90b49099-672c-4cef-aa9b-a4c5f809f1db','2026-01-21 11:57:45',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-2113435203-dep_3-ly2wln4m4uz2','90b49099-672c-4cef-aa9b-a4c5f809f1db','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1415,'9c670de5-521c-4fae-bf23-636e69aa1228','90b49099-672c-4cef-aa9b-a4c5f809f1db','2026-01-21 11:57:46',NULL,'DELETE','IN_PROGRESS','0','98d8588f-5537-4791-a906-f943c1aa080c','state changed','OS::Heat::SoftwareDeployment',NULL,208),(1416,'645379a9-bcbd-47fa-bfae-5a42ccca8afc','0fc1b119-7102-4fcf-b4ba-7ddd95cc2010','2026-01-21 11:57:46',NULL,'DELETE','COMPLETE','0','b891d246-fc70-49c4-884f-6539522f0ce9','state changed','OS::Heat::SoftwareDeployment',NULL,210),(1417,'9ade287b-dc33-4bdd-bdd3-e168add46667','0fc1b119-7102-4fcf-b4ba-7ddd95cc2010','2026-01-21 11:57:46',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-2113435203-dep_1-nl3oxy2eraww','0fc1b119-7102-4fcf-b4ba-7ddd95cc2010','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1418,'781ce6fa-4b15-425f-94b5-a583be47a76b','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:57:46',NULL,'DELETE','COMPLETE','dep_1','0fc1b119-7102-4fcf-b4ba-7ddd95cc2010','state changed','OS::Heat::SoftwareDeployments',NULL,204),(1419,'c68860df-ea31-4536-bf55-e0f3620d5625','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:57:46',NULL,'DELETE','IN_PROGRESS','dep_4','7c8a47da-b70c-465c-8524-7bc7ecd81aa8','state changed','OS::Heat::SoftwareDeployments',NULL,205),(1420,'32bad3a6-6ddc-46f7-b103-e6f65eb6efbf','7c8a47da-b70c-465c-8524-7bc7ecd81aa8','2026-01-21 11:57:46',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-2113435203-dep_4-igyerhnpcpyu','7c8a47da-b70c-465c-8524-7bc7ecd81aa8','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1421,'0100494a-68d8-4237-b77b-db5786e4a34e','90b49099-672c-4cef-aa9b-a4c5f809f1db','2026-01-21 11:57:46',NULL,'DELETE','COMPLETE','0','98d8588f-5537-4791-a906-f943c1aa080c','state changed','OS::Heat::SoftwareDeployment',NULL,208),(1422,'93a5792c-59c6-4340-bc84-c2e5d2688d84','90b49099-672c-4cef-aa9b-a4c5f809f1db','2026-01-21 11:57:46',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-2113435203-dep_3-ly2wln4m4uz2','90b49099-672c-4cef-aa9b-a4c5f809f1db','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1423,'ab78370d-eec7-4fe1-9ba4-09ab0cb6948c','7c8a47da-b70c-465c-8524-7bc7ecd81aa8','2026-01-21 11:57:46',NULL,'DELETE','IN_PROGRESS','0','4fcda30a-22ed-4947-b8a6-ffdcdff81b3f','state changed','OS::Heat::SoftwareDeployment',NULL,209),(1424,'c837fd8a-7f81-4a03-8b62-544ab76733e4','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:57:47',NULL,'DELETE','COMPLETE','dep_3','90b49099-672c-4cef-aa9b-a4c5f809f1db','state changed','OS::Heat::SoftwareDeployments',NULL,201),(1425,'b5a33a8d-f002-4a38-ba7c-7e58a8a6c5ef','7c8a47da-b70c-465c-8524-7bc7ecd81aa8','2026-01-21 11:57:47',NULL,'DELETE','COMPLETE','0','4fcda30a-22ed-4947-b8a6-ffdcdff81b3f','state changed','OS::Heat::SoftwareDeployment',NULL,209),(1426,'4a58f9f1-3e8f-4557-a83c-27e508795b54','7c8a47da-b70c-465c-8524-7bc7ecd81aa8','2026-01-21 11:57:47',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-2113435203-dep_4-igyerhnpcpyu','7c8a47da-b70c-465c-8524-7bc7ecd81aa8','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1427,'b819f462-2d94-4c6f-8eba-480375d91c7e','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:57:47',NULL,'DELETE','IN_PROGRESS','dep_0','236bc67a-e3b5-46a5-a6b7-40a6167fbd9f','state changed','OS::Heat::SoftwareDeployments',NULL,202),(1428,'33ccdb8a-4d31-4f6d-91ed-07e6cd654c1d','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:57:48',NULL,'DELETE','COMPLETE','dep_4','7c8a47da-b70c-465c-8524-7bc7ecd81aa8','state changed','OS::Heat::SoftwareDeployments',NULL,205),(1429,'67af7d66-e9d7-437d-a367-540b76ddda8e','236bc67a-e3b5-46a5-a6b7-40a6167fbd9f','2026-01-21 11:57:48',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-2113435203-dep_0-7tgcbpbbur7m','236bc67a-e3b5-46a5-a6b7-40a6167fbd9f','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1430,'39e47185-f50f-4a83-8f98-a9f7acda0260','236bc67a-e3b5-46a5-a6b7-40a6167fbd9f','2026-01-21 11:57:48',NULL,'DELETE','IN_PROGRESS','0','45c37430-9c0e-43e8-bf73-301193fc278b','state changed','OS::Heat::SoftwareDeployment',NULL,207),(1431,'aeaa8802-eef1-436e-8788-7a964ee62723','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:57:48',NULL,'DELETE','IN_PROGRESS','dep_2','b483ae4a-d046-41f1-8621-671b02bbc747','state changed','OS::Heat::SoftwareDeployments',NULL,203),(1432,'abd07a33-8277-4b0a-97a8-15f0a4a88131','b483ae4a-d046-41f1-8621-671b02bbc747','2026-01-21 11:57:48',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-2113435203-dep_2-mlh47nro7bwk','b483ae4a-d046-41f1-8621-671b02bbc747','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1433,'2e75b823-6ed7-471e-bbca-4cf7d3b848b2','b483ae4a-d046-41f1-8621-671b02bbc747','2026-01-21 11:57:49',NULL,'DELETE','IN_PROGRESS','0','fd07b3d7-0694-4083-be86-0bcd82f6537b','state changed','OS::Heat::SoftwareDeployment',NULL,206),(1434,'e097d4f5-195e-4e82-aef1-4a3bc852e11e','236bc67a-e3b5-46a5-a6b7-40a6167fbd9f','2026-01-21 11:57:49',NULL,'DELETE','COMPLETE','0','45c37430-9c0e-43e8-bf73-301193fc278b','state changed','OS::Heat::SoftwareDeployment',NULL,207),(1435,'bbf325d9-abc5-4d4e-93b6-507a550e5bf1','236bc67a-e3b5-46a5-a6b7-40a6167fbd9f','2026-01-21 11:57:49',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-2113435203-dep_0-7tgcbpbbur7m','236bc67a-e3b5-46a5-a6b7-40a6167fbd9f','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1436,'ba54e27e-454a-48c0-8289-106d055e8e5f','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:57:49',NULL,'DELETE','COMPLETE','dep_0','236bc67a-e3b5-46a5-a6b7-40a6167fbd9f','state changed','OS::Heat::SoftwareDeployments',NULL,202),(1437,'518149e1-a771-49cf-bc32-d1759448ac22','b483ae4a-d046-41f1-8621-671b02bbc747','2026-01-21 11:57:49',NULL,'DELETE','COMPLETE','0','fd07b3d7-0694-4083-be86-0bcd82f6537b','state changed','OS::Heat::SoftwareDeployment',NULL,206),(1438,'b2593ee4-8d35-497e-be2e-311a8a1b55e1','b483ae4a-d046-41f1-8621-671b02bbc747','2026-01-21 11:57:49',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-2113435203-dep_2-mlh47nro7bwk','b483ae4a-d046-41f1-8621-671b02bbc747','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1439,'04641b5b-ab8f-4f4e-85cb-55cf6c0dec42','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:57:50',NULL,'DELETE','COMPLETE','dep_2','b483ae4a-d046-41f1-8621-671b02bbc747','state changed','OS::Heat::SoftwareDeployments',NULL,203),(1440,'8bf9c626-ef87-41a0-ba08-9bcfa97ac99d','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:57:50',NULL,'DELETE','IN_PROGRESS','config','c4a706e4-b583-4904-a857-cecb8b5d950f','state changed','OS::Heat::SoftwareConfig',NULL,200),(1441,'8120e979-81fd-48bd-994b-3a160fcbb296','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:57:50',NULL,'DELETE','COMPLETE','config','c4a706e4-b583-4904-a857-cecb8b5d950f','state changed','OS::Heat::SoftwareConfig',NULL,200),(1442,'601bbac9-7414-44d4-8442-b80457245668','827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:57:50',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-2113435203','827ee19c-f116-4d62-bf09-2e58e17938e5','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1443,'c9f1634d-087e-464d-a272-6c2864b97805','75aa1f8b-2bc3-4ad5-b440-9654060c77dd','2026-01-21 11:57:54',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-100537633','75aa1f8b-2bc3-4ad5-b440-9654060c77dd','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1444,'2480e2ec-a5a3-403f-9399-993d527a6f75','75aa1f8b-2bc3-4ad5-b440-9654060c77dd','2026-01-21 11:57:54',NULL,'DELETE','IN_PROGRESS','server','4ff9a573-1e19-46f3-8efa-47cd3724747a','state changed','OS::Nova::Server',NULL,199),(1445,'cdd19857-aaf5-4d71-977f-91ab82b4ec9a','75aa1f8b-2bc3-4ad5-b440-9654060c77dd','2026-01-21 11:57:57',NULL,'DELETE','COMPLETE','server','4ff9a573-1e19-46f3-8efa-47cd3724747a','state changed','OS::Nova::Server',NULL,199),(1446,'72c7e271-4ef1-463f-abaa-d779c5d867f2','75aa1f8b-2bc3-4ad5-b440-9654060c77dd','2026-01-21 11:57:57',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-100537633','75aa1f8b-2bc3-4ad5-b440-9654060c77dd','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1447,'19f7a810-e75b-4205-aeb5-d200ba9a29a6','07d48bd2-c4a6-48f0-b38a-55a48240c4f2','2026-01-21 11:58:01',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1801240307','07d48bd2-c4a6-48f0-b38a-55a48240c4f2','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1448,'0226423c-5708-4b92-8401-c88f89a1dfcb','07d48bd2-c4a6-48f0-b38a-55a48240c4f2','2026-01-21 11:58:01',NULL,'CREATE','IN_PROGRESS','server','Pa-llelDeploymentsTest-1801240307-server-l3v3hve2c2jv','state changed','OS::Nova::Server',NULL,243),(1449,'f4c624e0-45dd-48bf-8431-bad6013faaab','07d48bd2-c4a6-48f0-b38a-55a48240c4f2','2026-01-21 11:58:13',NULL,'CREATE','COMPLETE','server','b6d9ed1d-62f0-4eaf-a42a-e78ed70b7a90','state changed','OS::Nova::Server',NULL,243),(1450,'622bc17d-a167-4890-9973-34ec023ee33e','07d48bd2-c4a6-48f0-b38a-55a48240c4f2','2026-01-21 11:58:13',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1801240307','07d48bd2-c4a6-48f0-b38a-55a48240c4f2','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1451,'63974271-ac4f-43a4-a4b0-a614ccb39ec8','583fccda-82d0-4453-a7eb-b69b1e858b36','2026-01-21 11:58:15',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-678810249','583fccda-82d0-4453-a7eb-b69b1e858b36','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1452,'3d25a8dd-8e5a-41ab-89c6-aa4e927c0145','583fccda-82d0-4453-a7eb-b69b1e858b36','2026-01-21 11:58:15',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-678810249-config-oa3tpvbcs3ei','state changed','OS::Heat::SoftwareConfig',NULL,244),(1453,'26d720ad-8825-479e-a754-a201832e3d5b','583fccda-82d0-4453-a7eb-b69b1e858b36','2026-01-21 11:58:15',NULL,'CREATE','COMPLETE','config','0be577d3-9c5a-4d36-b5a9-25fc7e2c64ee','state changed','OS::Heat::SoftwareConfig',NULL,244),(1454,'735a6742-caf0-4edb-bd53-465321518f18','583fccda-82d0-4453-a7eb-b69b1e858b36','2026-01-21 11:58:15',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-678810249-dep_0-7aqo4akkstd2','state changed','OS::Heat::SoftwareDeployments',NULL,245),(1455,'e6c55d3d-3ea6-46c3-aca4-6e5606b4e583','583fccda-82d0-4453-a7eb-b69b1e858b36','2026-01-21 11:58:15',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-678810249-dep_2-hkjvd7k7z5xg','state changed','OS::Heat::SoftwareDeployments',NULL,246),(1456,'cb85117f-803b-4334-af53-56b6e6654f41','583fccda-82d0-4453-a7eb-b69b1e858b36','2026-01-21 11:58:15',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-678810249-dep_1-455bzdgsccg7','state changed','OS::Heat::SoftwareDeployments',NULL,247),(1457,'74c6317f-441c-45d5-a531-b2b8ae77cb54','e7e2e1d3-7821-48bb-98ed-a65003138bee','2026-01-21 11:58:15',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-678810249-dep_0-7aqo4akkstd2','e7e2e1d3-7821-48bb-98ed-a65003138bee','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1458,'bb804203-44d1-4d66-b78b-4718ae84cf0a','49b2775c-7eb4-4372-8d12-d36b21230b6f','2026-01-21 11:58:16',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-678810249-dep_2-hkjvd7k7z5xg','49b2775c-7eb4-4372-8d12-d36b21230b6f','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1459,'7346d9e5-6d19-4bc6-b50b-a487273d7755','887daa38-49b9-481a-b495-1489c0632c6e','2026-01-21 11:58:16',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-678810249-dep_1-455bzdgsccg7','887daa38-49b9-481a-b495-1489c0632c6e','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1460,'9098cd2f-3a3a-497e-9d27-a8dffa2c4a81','e7e2e1d3-7821-48bb-98ed-a65003138bee','2026-01-21 11:58:16',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-678810249-dep_0-7aqo4akkstd2-0-escmvlt3biea','state changed','OS::Heat::SoftwareDeployment',NULL,248),(1461,'f640bf2f-4876-442d-8dd4-97c91b5ef701','887daa38-49b9-481a-b495-1489c0632c6e','2026-01-21 11:58:16',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-678810249-dep_1-455bzdgsccg7-0-bxekcwd2bchc','state changed','OS::Heat::SoftwareDeployment',NULL,249),(1462,'46c47d1f-d5fb-49e0-aa0f-aad43dc2e704','49b2775c-7eb4-4372-8d12-d36b21230b6f','2026-01-21 11:58:16',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-678810249-dep_2-hkjvd7k7z5xg-0-cp6djdp6mzcp','state changed','OS::Heat::SoftwareDeployment',NULL,250),(1463,'83ad4ee7-5c71-4a51-8333-6eb012b8eac8','583fccda-82d0-4453-a7eb-b69b1e858b36','2026-01-21 11:59:17',NULL,'CREATE','FAILED','dep_1','887daa38-49b9-481a-b495-1489c0632c6e','CREATE aborted (Task create from SoftwareDeployments \"dep_1\" Stack \"ParallelDeploymentsTest-678810249\" [583fccda-82d0-4453-a7eb-b69b1e858b36] Timed out)','OS::Heat::SoftwareDeployments',NULL,247),(1464,'b8168cef-0e13-4d53-b05b-249a391d3332','583fccda-82d0-4453-a7eb-b69b1e858b36','2026-01-21 11:59:17',NULL,'CREATE','FAILED','dep_0','e7e2e1d3-7821-48bb-98ed-a65003138bee','CREATE aborted (Task create from SoftwareDeployments \"dep_0\" Stack \"ParallelDeploymentsTest-678810249\" [583fccda-82d0-4453-a7eb-b69b1e858b36] Timed out)','OS::Heat::SoftwareDeployments',NULL,245),(1465,'1d59eb35-a846-4c8f-b82b-e0cb106d6052','887daa38-49b9-481a-b495-1489c0632c6e','2026-01-21 11:59:17',NULL,'CREATE','FAILED','ParallelDeploymentsTest-678810249-dep_1-455bzdgsccg7','887daa38-49b9-481a-b495-1489c0632c6e','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1466,'cffde044-6aa0-41e8-8264-c0263077d7e5','583fccda-82d0-4453-a7eb-b69b1e858b36','2026-01-21 11:59:17',NULL,'CREATE','FAILED','dep_2','49b2775c-7eb4-4372-8d12-d36b21230b6f','CREATE aborted (Task create from SoftwareDeployments \"dep_2\" Stack \"ParallelDeploymentsTest-678810249\" [583fccda-82d0-4453-a7eb-b69b1e858b36] Timed out)','OS::Heat::SoftwareDeployments',NULL,246),(1467,'480d3ce7-d760-4308-8b1c-7b7b08b46c46','49b2775c-7eb4-4372-8d12-d36b21230b6f','2026-01-21 11:59:17',NULL,'CREATE','FAILED','ParallelDeploymentsTest-678810249-dep_2-hkjvd7k7z5xg','49b2775c-7eb4-4372-8d12-d36b21230b6f','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1468,'e187db0b-7a15-47a8-ba49-d88297de4d55','e7e2e1d3-7821-48bb-98ed-a65003138bee','2026-01-21 11:59:17',NULL,'CREATE','FAILED','ParallelDeploymentsTest-678810249-dep_0-7aqo4akkstd2','e7e2e1d3-7821-48bb-98ed-a65003138bee','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1469,'d1419bd6-b90b-46fc-b02b-65cb700cb2c0','583fccda-82d0-4453-a7eb-b69b1e858b36','2026-01-21 11:59:17',NULL,'CREATE','FAILED','ParallelDeploymentsTest-678810249','583fccda-82d0-4453-a7eb-b69b1e858b36','Timed out','OS::Heat::Stack',NULL,NULL),(1470,'630c680d-c577-44b3-980f-c1fefca05acd','583fccda-82d0-4453-a7eb-b69b1e858b36','2026-01-21 11:59:17',NULL,'CREATE','FAILED','ParallelDeploymentsTest-678810249','583fccda-82d0-4453-a7eb-b69b1e858b36','Timed out','OS::Heat::Stack',NULL,NULL),(1471,'efd1bacd-23d7-4aae-90a3-5d1cf1331b82','583fccda-82d0-4453-a7eb-b69b1e858b36','2026-01-21 11:59:17',NULL,'CREATE','FAILED','ParallelDeploymentsTest-678810249','583fccda-82d0-4453-a7eb-b69b1e858b36','Timed out','OS::Heat::Stack',NULL,NULL),(1472,'6ac029e2-418e-4973-b17e-8a13b869897e','49b2775c-7eb4-4372-8d12-d36b21230b6f','2026-01-21 11:59:17',NULL,'CREATE','FAILED','0','d6c14c84-2f9e-4b0b-88d0-112d25c7e634','CREATE aborted (Task create from SoftwareDeployment \"0\" Stack \"ParallelDeploymentsTest-678810249-dep_2-hkjvd7k7z5xg\" [49b2775c-7eb4-4372-8d12-d36b21230b6f] Timed out)','OS::Heat::SoftwareDeployment',NULL,250),(1473,'e84daac4-f884-4f38-8328-c92954c9aca6','e7e2e1d3-7821-48bb-98ed-a65003138bee','2026-01-21 11:59:17',NULL,'CREATE','FAILED','0','7655ae43-fc68-4c99-a6be-ac73681e6c62','CREATE aborted (Task create from SoftwareDeployment \"0\" Stack \"ParallelDeploymentsTest-678810249-dep_0-7aqo4akkstd2\" [e7e2e1d3-7821-48bb-98ed-a65003138bee] Timed out)','OS::Heat::SoftwareDeployment',NULL,248),(1474,'19751f92-6bda-4a4c-a3fb-79107de1f12a','887daa38-49b9-481a-b495-1489c0632c6e','2026-01-21 11:59:17',NULL,'CREATE','FAILED','0','5df3280b-e0be-4081-be20-74f6b8df8f57','CREATE aborted (Task create from SoftwareDeployment \"0\" Stack \"ParallelDeploymentsTest-678810249-dep_1-455bzdgsccg7\" [887daa38-49b9-481a-b495-1489c0632c6e] Timed out)','OS::Heat::SoftwareDeployment',NULL,249),(1475,'b672aed5-3b9f-4fda-9e5f-03187bcad0c2','e7e2e1d3-7821-48bb-98ed-a65003138bee','2026-01-21 11:59:17',NULL,'CREATE','FAILED','ParallelDeploymentsTest-678810249-dep_0-7aqo4akkstd2','e7e2e1d3-7821-48bb-98ed-a65003138bee','Timed out','OS::Heat::Stack',NULL,NULL),(1476,'24b124b7-56a4-4546-baa5-3b4c060aca2b','49b2775c-7eb4-4372-8d12-d36b21230b6f','2026-01-21 11:59:17',NULL,'CREATE','FAILED','ParallelDeploymentsTest-678810249-dep_2-hkjvd7k7z5xg','49b2775c-7eb4-4372-8d12-d36b21230b6f','Timed out','OS::Heat::Stack',NULL,NULL),(1477,'40ed0c20-a0ea-474e-83a9-0ac140ea05c1','887daa38-49b9-481a-b495-1489c0632c6e','2026-01-21 11:59:18',NULL,'CREATE','FAILED','ParallelDeploymentsTest-678810249-dep_1-455bzdgsccg7','887daa38-49b9-481a-b495-1489c0632c6e','Timed out','OS::Heat::Stack',NULL,NULL),(1478,'0a12fd7e-1500-4f42-a284-493cf28c3436','583fccda-82d0-4453-a7eb-b69b1e858b36','2026-01-21 11:59:24',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-678810249','583fccda-82d0-4453-a7eb-b69b1e858b36','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1479,'291a0a48-bd2e-4d5e-ab68-ff7270d23772','583fccda-82d0-4453-a7eb-b69b1e858b36','2026-01-21 11:59:24',NULL,'DELETE','IN_PROGRESS','dep_2','49b2775c-7eb4-4372-8d12-d36b21230b6f','state changed','OS::Heat::SoftwareDeployments',NULL,246),(1480,'dd4b3f8f-061b-438e-bc10-f475250bf378','49b2775c-7eb4-4372-8d12-d36b21230b6f','2026-01-21 11:59:24',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-678810249-dep_2-hkjvd7k7z5xg','49b2775c-7eb4-4372-8d12-d36b21230b6f','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1481,'97edfdad-ed70-4085-b8de-356052438e2b','49b2775c-7eb4-4372-8d12-d36b21230b6f','2026-01-21 11:59:25',NULL,'DELETE','IN_PROGRESS','0','d6c14c84-2f9e-4b0b-88d0-112d25c7e634','state changed','OS::Heat::SoftwareDeployment',NULL,250),(1482,'a7a2839a-ecb0-42e1-a38e-c9c17c320bc8','583fccda-82d0-4453-a7eb-b69b1e858b36','2026-01-21 11:59:25',NULL,'DELETE','IN_PROGRESS','dep_1','887daa38-49b9-481a-b495-1489c0632c6e','state changed','OS::Heat::SoftwareDeployments',NULL,247),(1483,'d0892915-13a3-4f89-81b7-09da340bd43f','887daa38-49b9-481a-b495-1489c0632c6e','2026-01-21 11:59:25',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-678810249-dep_1-455bzdgsccg7','887daa38-49b9-481a-b495-1489c0632c6e','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1484,'f3e9029c-32cc-4f7f-b9e8-07315a10c255','887daa38-49b9-481a-b495-1489c0632c6e','2026-01-21 11:59:25',NULL,'DELETE','IN_PROGRESS','0','5df3280b-e0be-4081-be20-74f6b8df8f57','state changed','OS::Heat::SoftwareDeployment',NULL,249),(1485,'d17c6272-a503-4d49-adc4-6e4ac806a90b','49b2775c-7eb4-4372-8d12-d36b21230b6f','2026-01-21 11:59:26',NULL,'DELETE','COMPLETE','0','d6c14c84-2f9e-4b0b-88d0-112d25c7e634','state changed','OS::Heat::SoftwareDeployment',NULL,250),(1486,'fcb8c5d2-0c45-407f-8c61-bbdbe3bb9687','49b2775c-7eb4-4372-8d12-d36b21230b6f','2026-01-21 11:59:26',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-678810249-dep_2-hkjvd7k7z5xg','49b2775c-7eb4-4372-8d12-d36b21230b6f','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1487,'6e07c532-a51c-4fcf-8c23-555390b3b8cb','887daa38-49b9-481a-b495-1489c0632c6e','2026-01-21 11:59:26',NULL,'DELETE','COMPLETE','0','5df3280b-e0be-4081-be20-74f6b8df8f57','state changed','OS::Heat::SoftwareDeployment',NULL,249),(1488,'3b13a6a7-0b3c-4464-bc05-338f8b5cc3e2','887daa38-49b9-481a-b495-1489c0632c6e','2026-01-21 11:59:26',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-678810249-dep_1-455bzdgsccg7','887daa38-49b9-481a-b495-1489c0632c6e','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1489,'86fd4953-766c-4f8b-8879-75f4eb73d967','583fccda-82d0-4453-a7eb-b69b1e858b36','2026-01-21 11:59:26',NULL,'DELETE','IN_PROGRESS','dep_0','e7e2e1d3-7821-48bb-98ed-a65003138bee','state changed','OS::Heat::SoftwareDeployments',NULL,245),(1490,'07350acf-f671-4896-9dd2-a5d9bff02f3d','e7e2e1d3-7821-48bb-98ed-a65003138bee','2026-01-21 11:59:26',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-678810249-dep_0-7aqo4akkstd2','e7e2e1d3-7821-48bb-98ed-a65003138bee','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1491,'723f5e9a-e372-4891-a367-9b0110925b1a','583fccda-82d0-4453-a7eb-b69b1e858b36','2026-01-21 11:59:26',NULL,'DELETE','COMPLETE','dep_1','887daa38-49b9-481a-b495-1489c0632c6e','state changed','OS::Heat::SoftwareDeployments',NULL,247),(1492,'97e43327-e3b3-4a43-9e74-682a1def42c3','583fccda-82d0-4453-a7eb-b69b1e858b36','2026-01-21 11:59:26',NULL,'DELETE','COMPLETE','dep_2','49b2775c-7eb4-4372-8d12-d36b21230b6f','state changed','OS::Heat::SoftwareDeployments',NULL,246),(1493,'6aeb5776-0f8a-411d-8015-128e091e6e28','e7e2e1d3-7821-48bb-98ed-a65003138bee','2026-01-21 11:59:27',NULL,'DELETE','IN_PROGRESS','0','7655ae43-fc68-4c99-a6be-ac73681e6c62','state changed','OS::Heat::SoftwareDeployment',NULL,248),(1494,'c39d0e24-e8bd-47fd-bb8f-cb6b7aa514a9','e7e2e1d3-7821-48bb-98ed-a65003138bee','2026-01-21 11:59:28',NULL,'DELETE','COMPLETE','0','7655ae43-fc68-4c99-a6be-ac73681e6c62','state changed','OS::Heat::SoftwareDeployment',NULL,248),(1495,'9e4abf28-dbca-4012-8be3-54e69d86c731','e7e2e1d3-7821-48bb-98ed-a65003138bee','2026-01-21 11:59:28',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-678810249-dep_0-7aqo4akkstd2','e7e2e1d3-7821-48bb-98ed-a65003138bee','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1496,'8dffa265-c938-4030-becf-2c929505d8a4','583fccda-82d0-4453-a7eb-b69b1e858b36','2026-01-21 11:59:29',NULL,'DELETE','COMPLETE','dep_0','e7e2e1d3-7821-48bb-98ed-a65003138bee','state changed','OS::Heat::SoftwareDeployments',NULL,245),(1497,'fc6c854e-4c1d-4ade-93c9-c301cea4c9b1','583fccda-82d0-4453-a7eb-b69b1e858b36','2026-01-21 11:59:29',NULL,'DELETE','IN_PROGRESS','config','0be577d3-9c5a-4d36-b5a9-25fc7e2c64ee','state changed','OS::Heat::SoftwareConfig',NULL,244),(1498,'a513fab1-fb06-43f1-8b60-68b4f8cf5751','583fccda-82d0-4453-a7eb-b69b1e858b36','2026-01-21 11:59:29',NULL,'DELETE','COMPLETE','config','0be577d3-9c5a-4d36-b5a9-25fc7e2c64ee','state changed','OS::Heat::SoftwareConfig',NULL,244),(1499,'02ce46de-c397-4793-ba0e-18e6ca780b14','583fccda-82d0-4453-a7eb-b69b1e858b36','2026-01-21 11:59:29',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-678810249','583fccda-82d0-4453-a7eb-b69b1e858b36','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1500,'af36101b-c1f5-4a38-b3be-30501dd178ca','07d48bd2-c4a6-48f0-b38a-55a48240c4f2','2026-01-21 11:59:34',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1801240307','07d48bd2-c4a6-48f0-b38a-55a48240c4f2','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1501,'885586d0-70e0-41bc-b2ec-f855c5053e04','07d48bd2-c4a6-48f0-b38a-55a48240c4f2','2026-01-21 11:59:34',NULL,'DELETE','IN_PROGRESS','server','b6d9ed1d-62f0-4eaf-a42a-e78ed70b7a90','state changed','OS::Nova::Server',NULL,243),(1502,'7b68edcf-e984-4dfd-ae5b-c8a065b28fc9','07d48bd2-c4a6-48f0-b38a-55a48240c4f2','2026-01-21 11:59:37',NULL,'DELETE','COMPLETE','server','b6d9ed1d-62f0-4eaf-a42a-e78ed70b7a90','state changed','OS::Nova::Server',NULL,243),(1503,'2f1725b3-4ad3-41ad-b746-5b59ebd9dc0d','07d48bd2-c4a6-48f0-b38a-55a48240c4f2','2026-01-21 11:59:37',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1801240307','07d48bd2-c4a6-48f0-b38a-55a48240c4f2','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1504,'3fe0c0e9-67d9-475b-861c-a6e565096866','55dbaf3b-ca7a-4249-8532-32591a78c378','2026-01-21 11:59:44',NULL,'CREATE','IN_PROGRESS','StackUnicodeTemplateTest-2029350488','55dbaf3b-ca7a-4249-8532-32591a78c378','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1505,'97820aa2-23b7-48a1-8063-229e9936167b','55dbaf3b-ca7a-4249-8532-32591a78c378','2026-01-21 11:59:44',NULL,'CREATE','IN_PROGRESS','资源','StackUnicodeTemplateTest-2029350488-资源-ijssoouskeyz','state changed','OS::Heat::RandomString',NULL,251),(1506,'0749b99b-b286-4df8-9922-622bc72f566a','55dbaf3b-ca7a-4249-8532-32591a78c378','2026-01-21 11:59:44',NULL,'CREATE','COMPLETE','资源','StackUnicodeTemplateTest-2029350488-资源-ijssoouskeyz','state changed','OS::Heat::RandomString',NULL,251),(1507,'5e9daa4f-0cf2-4a6e-96a8-598c3a9fe59f','55dbaf3b-ca7a-4249-8532-32591a78c378','2026-01-21 11:59:44',NULL,'CREATE','COMPLETE','StackUnicodeTemplateTest-2029350488','55dbaf3b-ca7a-4249-8532-32591a78c378','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1508,'cd8f3e1a-0d6f-4735-8607-4466a5ed01ca','55dbaf3b-ca7a-4249-8532-32591a78c378','2026-01-21 11:59:44',NULL,'DELETE','IN_PROGRESS','StackUnicodeTemplateTest-2029350488','55dbaf3b-ca7a-4249-8532-32591a78c378','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1509,'04b6f1a9-5c38-476c-810f-0d8bba2a0b94','55dbaf3b-ca7a-4249-8532-32591a78c378','2026-01-21 11:59:44',NULL,'DELETE','IN_PROGRESS','资源','StackUnicodeTemplateTest-2029350488-资源-ijssoouskeyz','state changed','OS::Heat::RandomString',NULL,251),(1510,'8b3e6b7b-071e-43b5-baba-976df54c9de1','55dbaf3b-ca7a-4249-8532-32591a78c378','2026-01-21 11:59:44',NULL,'DELETE','COMPLETE','资源','StackUnicodeTemplateTest-2029350488-资源-ijssoouskeyz','state changed','OS::Heat::RandomString',NULL,251),(1511,'2422ef99-c063-405e-b6c9-fb0f43340508','55dbaf3b-ca7a-4249-8532-32591a78c378','2026-01-21 11:59:45',NULL,'DELETE','COMPLETE','StackUnicodeTemplateTest-2029350488','55dbaf3b-ca7a-4249-8532-32591a78c378','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL);
/*!40000 ALTER TABLE `event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('heat','/usr/lib/python3.9/site-packages/heat/db/sqlalchemy/migrate_repo',86);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raw_template`
--

DROP TABLE IF EXISTS `raw_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `raw_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `template` longtext DEFAULT NULL,
  `files` longtext DEFAULT NULL,
  `environment` longtext DEFAULT NULL,
  `files_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_tmpl_files_fkey_ref` (`files_id`),
  CONSTRAINT `raw_tmpl_files_fkey_ref` FOREIGN KEY (`files_id`) REFERENCES `raw_template_files` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=240 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raw_template`
--

LOCK TABLES `raw_template` WRITE;
/*!40000 ALTER TABLE `raw_template` DISABLE KEYS */;
INSERT INTO `raw_template` (`id`, `created_at`, `updated_at`, `template`, `files`, `environment`, `files_id`) VALUES (2,'2026-01-21 11:48:35',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}}}}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"test\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(3,'2026-01-21 11:48:35',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(5,'2026-01-21 11:48:36',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"test\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(7,'2026-01-21 11:48:40',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(9,'2026-01-21 11:48:40',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(10,'2026-01-21 11:48:41',NULL,'{\"heat_template_version\": \"2016-04-08\"}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(12,'2026-01-21 11:48:41',NULL,'{\"heat_template_version\": \"2016-04-08\"}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(18,'2026-01-21 11:48:44',NULL,'{\"heat_template_version\": \"2016-04-08\"}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(20,'2026-01-21 11:48:45',NULL,'{\"heat_template_version\": \"2016-04-08\"}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(23,'2026-01-21 11:48:45',NULL,'{\"heat_template_version\": \"pike\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}, \"action_wait_secs\": {\"update\": 1}}}}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"new_patched_value\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(24,'2026-01-21 11:48:46',NULL,'{\"heat_template_version\": \"pike\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}, \"action_wait_secs\": {\"update\": 1}}}}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"new_value\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(26,'2026-01-21 11:48:50',NULL,'{\"heat_template_version\": \"pike\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}, \"action_wait_secs\": {\"update\": 1}}}}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"new_patched_value\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(30,'2026-01-21 11:48:51',NULL,'{\"heat_template_version\": \"pike\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"new_patched_value\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(35,'2026-01-21 11:49:01',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create port wit ip_address.\", \"parameters\": {\"mac\": {\"type\": \"string\", \"default\": \"00-00-00-00-BB-BB\"}}, \"resources\": {}, \"outputs\": {\"port_ip\": {\"value\": {\"get_attr\": [\"port\", \"fixed_ips\", 0, \"ip_address\"]}}, \"mac_address\": {\"value\": {\"get_attr\": [\"port\", \"mac_address\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(36,'2026-01-21 11:49:02',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(37,'2026-01-21 11:49:06',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(40,'2026-01-21 11:49:07',NULL,'{\"heat_template_version\": \"2014-10-16\", \"parameters\": {\"image\": {\"type\": \"string\"}, \"flavor\": {\"type\": \"string\"}, \"network\": {\"type\": \"string\"}, \"foo\": {\"type\": \"string\", \"description\": \"parameter with encryption turned on\", \"hidden\": true, \"default\": \"secret\"}}, \"resources\": {}, \"outputs\": {\"encrypted_foo_param\": {\"description\": \"encrypted param\", \"value\": {\"get_param\": \"foo\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\", \"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"network\": \"heat_tempestconf_network\", \"foo\": \"my_encrypted_foo\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(45,'2026-01-21 11:49:17',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(47,'2026-01-21 11:49:21',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create port wit ip_address.\", \"parameters\": {\"mac\": {\"type\": \"string\", \"default\": \"00-00-00-00-BB-BB\"}}, \"resources\": {}, \"outputs\": {\"port_ip\": {\"value\": {\"get_attr\": [\"port\", \"fixed_ips\", 0, \"ip_address\"]}}, \"mac_address\": {\"value\": {\"get_attr\": [\"port\", \"mac_address\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"mac\": \"00-00-00-00-AA-AA\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(51,'2026-01-21 11:49:29',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(52,'2026-01-21 11:49:29',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server with port.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(53,'2026-01-21 11:49:30',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"remote_key\": {\"value\": {\"get_attr\": [\"random1\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(54,'2026-01-21 11:49:33',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(60,'2026-01-21 11:49:40',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"key\": {\"value\": {\"get_attr\": [\"my_stack\", \"outputs\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',1),(61,'2026-01-21 11:49:41',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"remote_key\": {\"value\": {\"get_attr\": [\"random1\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',2),(66,'2026-01-21 11:49:49',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(67,'2026-01-21 11:49:49',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(68,'2026-01-21 11:49:50',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server with subnet and fixed_ip.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"networks\": {\"value\": {\"get_attr\": [\"server\", \"networks\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(73,'2026-01-21 11:50:02',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"key\": {\"value\": {\"get_attr\": [\"my_stack\", \"outputs\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',3),(74,'2026-01-21 11:50:03',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"remote_key\": {\"value\": {\"get_attr\": [\"random1\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',4),(75,'2026-01-21 11:50:05',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(84,'2026-01-21 11:50:18',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(85,'2026-01-21 11:50:21',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(87,'2026-01-21 11:50:24',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"key\": {\"value\": {\"get_attr\": [\"my_stack\", \"outputs\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',7),(88,'2026-01-21 11:50:24',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"remote_key\": {\"value\": {\"get_attr\": [\"random2\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',8),(91,'2026-01-21 11:50:30',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(92,'2026-01-21 11:50:33',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_step2\": {\"hooks\": \"pre-create\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(95,'2026-01-21 11:50:36',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"networks\": {\"value\": {\"get_attr\": [\"server\", \"networks\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(96,'2026-01-21 11:50:37',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(102,'2026-01-21 11:50:43',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(103,'2026-01-21 11:50:44',NULL,'{\"heat_template_version\": \"2014-10-16\", \"parameters\": null, \"resources\": {}, \"outputs\": {\"resource_id\": {\"description\": \"ID of resource\", \"value\": {\"get_resource\": \"test_resource\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(105,'2026-01-21 11:50:50',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"nested\": {\"foo_step2\": {\"hooks\": \"pre-create\"}}}, \"nested.yaml\": \"nested.yaml\"}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',9),(106,'2026-01-21 11:50:50',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_step2\": {\"hooks\": \"pre-create\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',9),(107,'2026-01-21 11:50:51',NULL,'{\"description\": \"The root stack (containing a remote stack) for the deeply-nested remote\\nstack test.\\n\", \"heat_template_version\": \"2015-10-15\", \"outputs\": {\"router\": {\"value\": {\"get_attr\": [\"network_stack\", \"outputs\", \"router\"]}}}, \"parameters\": {\"name\": {\"constraints\": [{\"allowed_pattern\": \"[a-z][a-z0-9-]{1,}\"}], \"description\": \"Name of the router\", \"type\": \"string\"}, \"network_name\": {\"constraints\": [{\"custom_constraint\": \"neutron.network\"}], \"description\": \"The public network to connect to\", \"type\": \"string\"}, \"region\": {\"default\": \"RegionOne\", \"description\": \"The region in which to create the remote stack\", \"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"name\": \"remote-nested\", \"network_name\": \"public\", \"region\": \"regionOne\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',10),(108,'2026-01-21 11:50:52',NULL,'{\"heat_template_version\": \"2015-10-15\", \"description\": \"The intermediate stack (containing a local nested stack) to be instantiated\\nremotely in the remote deeply-nested stack test.\\n\", \"parameters\": {\"name\": {\"type\": \"string\", \"description\": \"Name of the router\", \"constraints\": [{\"allowed_pattern\": \"[a-z][a-z0-9-]{1,}\"}]}, \"network_name\": {\"type\": \"string\", \"description\": \"The public network to connect to\", \"constraints\": [{\"custom_constraint\": \"neutron.network\"}]}}, \"resources\": {}, \"outputs\": {\"router\": {\"value\": {\"get_attr\": [\"network_stack_as_custom_type\", \"router\"]}}}}','null','{\"resource_registry\": {\"resources\": {}, \"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\": \"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\"}, \"parameters\": {\"name\": \"remote-nested\", \"network_name\": \"public\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',11),(110,'2026-01-21 11:50:52',NULL,'{\"heat_template_version\": \"2015-10-15\", \"description\": \"The base stack (containing an actual resource) for the remote deeply-nested\\nstack test.\\n\", \"parameters\": {\"name\": {\"type\": \"string\", \"description\": \"Name of the router\", \"constraints\": [{\"allowed_pattern\": \"[a-z][a-z0-9-]{1,}\"}]}, \"network_name\": {\"type\": \"string\", \"description\": \"The network to connect to\", \"constraints\": [{\"custom_constraint\": \"neutron.network\"}]}}, \"resources\": {}, \"outputs\": {\"router\": {\"value\": {\"get_resource\": \"router\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"name\": \"remote-nested\", \"network_name\": \"public\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',11),(113,'2026-01-21 11:51:10',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(114,'2026-01-21 11:51:16',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_*\": {\"hooks\": \"pre-create\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(120,'2026-01-21 11:51:27',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create encryption volume type.\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(122,'2026-01-21 11:51:32',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"rg\": {\"hooks\": \"pre-update\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(123,'2026-01-21 11:51:33',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}, \"outputs\": {\"refs_map\": {\"value\": {\"0\": {\"get_resource\": \"0\"}, \"1\": {\"get_resource\": \"1\"}}}}}','null','{\"resource_registry\": {\"resources\": {\"hooks\": \"pre-update\"}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(125,'2026-01-21 11:51:35',NULL,'{\"heat_template_version\": \"2016-10-14\", \"resources\": {}, \"outputs\": {\"str\": {\"value\": {\"get_resource\": \"test1\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(130,'2026-01-21 11:51:48',NULL,'{\"heat_template_version\": \"2016-10-14\", \"resources\": {}, \"outputs\": {\"str\": {\"value\": {\"get_resource\": \"test1\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(131,'2026-01-21 11:51:49',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_step2\": {\"hooks\": \"pre-update\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(132,'2026-01-21 11:51:54',NULL,'{\"heat_template_version\": \"2016-10-14\", \"resources\": {\"test1\": {\"type\": \"OS::Heat::TestResource\"}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(136,'2026-01-21 11:52:00',NULL,'{\"heat_template_version\": \"2016-10-14\", \"resources\": {}, \"outputs\": {\"str\": {\"value\": {\"get_resource\": \"test1\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(137,'2026-01-21 11:52:03',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_step2\": {\"hooks\": \"pre-update\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(143,'2026-01-21 11:52:20',NULL,'{\"heat_template_version\": \"2015-10-15\", \"resources\": {}, \"outputs\": {\"resource_output_a\": {\"value\": {\"get_attr\": [\"parent\", \"resource_output_a\"]}, \"description\": \"parent a\"}, \"resource_output_b\": {\"value\": {\"get_attr\": [\"parent\", \"resource_output_b\"]}, \"description\": \"parent b\"}}}','null','{\"resource_registry\": {\"resources\": {}, \"1.yaml\": \"1.yaml\"}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',13),(144,'2026-01-21 11:52:20',NULL,'{\"heat_template_version\": \"2015-10-15\", \"resources\": {}, \"outputs\": {\"resource_output_a\": {\"description\": \"Output of resource a\", \"value\": {\"get_attr\": [\"test_resource_a\", \"output\"]}}, \"resource_output_b\": {\"description\": \"Output of resource b\", \"value\": {\"get_param\": \"foo\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',13),(147,'2026-01-21 11:52:33',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(148,'2026-01-21 11:52:36',NULL,'{\"heat_template_version\": \"2015-10-15\", \"resources\": {}, \"outputs\": {\"resource_output_a\": {\"description\": \"Output of resource a\", \"value\": {\"get_attr\": [\"test_resource_a\", \"output\"]}}, \"resource_output_b\": {\"description\": \"Output of resource b\", \"value\": {\"get_attr\": [\"test_resource_b\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(152,'2026-01-21 11:52:49',NULL,'{\"heat_template_version\": \"2015-10-15\", \"resources\": {}, \"outputs\": {\"output_value\": {\"description\": \"Output of resource b\", \"value\": {\"get_attr\": [\"test_resource_b\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(154,'2026-01-21 11:53:00',NULL,'{\"heat_template_version\": \"2014-10-16\", \"description\": \"foo\", \"parameters\": {\"input\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(157,'2026-01-21 11:53:10',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(160,'2026-01-21 11:53:19',NULL,'{\"heat_template_version\": \"2014-10-16\", \"description\": \"foo\", \"parameters\": {\"input\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"input\": \"none\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(163,'2026-01-21 11:53:26',NULL,'{\"heat_template_version\": \"2014-10-16\", \"description\": \"Test Template APIs\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(165,'2026-01-21 11:53:48',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(168,'2026-01-21 11:54:24',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(171,'2026-01-21 11:54:58',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(174,'2026-01-21 11:55:38',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(177,'2026-01-21 11:56:10',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(203,'2026-01-21 11:57:10',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(204,'2026-01-21 11:57:10',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(205,'2026-01-21 11:57:11',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(206,'2026-01-21 11:57:12',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(207,'2026-01-21 11:57:19',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(208,'2026-01-21 11:57:19',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(209,'2026-01-21 11:57:21',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(210,'2026-01-21 11:57:21',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(211,'2026-01-21 11:57:29',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(212,'2026-01-21 11:57:29',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(213,'2026-01-21 11:57:31',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(214,'2026-01-21 11:57:32',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(215,'2026-01-21 11:57:34',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(216,'2026-01-21 11:57:34',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(217,'2026-01-21 11:57:35',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(218,'2026-01-21 11:57:36',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(219,'2026-01-21 11:57:37',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(220,'2026-01-21 11:57:39',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(221,'2026-01-21 11:57:44',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(222,'2026-01-21 11:57:45',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(223,'2026-01-21 11:57:45',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(224,'2026-01-21 11:57:46',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(225,'2026-01-21 11:57:48',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(226,'2026-01-21 11:57:48',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(227,'2026-01-21 11:57:54',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}, \"network\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"server\": {\"value\": {\"get_resource\": \"server\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"network\": \"heat_tempestconf_network\", \"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(233,'2026-01-21 11:59:24',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"b6d9ed1d-62f0-4eaf-a42a-e78ed70b7a90\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(234,'2026-01-21 11:59:24',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(235,'2026-01-21 11:59:25',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(236,'2026-01-21 11:59:26',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(237,'2026-01-21 11:59:34',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}, \"network\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"server\": {\"value\": {\"get_resource\": \"server\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"network\": \"heat_tempestconf_network\", \"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(239,'2026-01-21 11:59:44',NULL,'{\"heat_template_version\": \"2014-10-16\", \"description\": \"\\u8fd9\\u662f\\u4e00\\u4e2a\\u63cf\\u8ff0\", \"parameters\": {\"\\u53c2\\u6570\": {\"type\": \"number\", \"default\": 10, \"label\": \"\\u6807\\u7b7e\", \"description\": \"\\u8fd9\\u662f\\u4e00\\u4e2a\\u63cf\\u8ff0\"}}, \"resources\": {}, \"outputs\": {\"\\u8f93\\u51fa\": {\"description\": \"\\u8fd9\\u662f\\u4e00\\u4e2a\\u63cf\\u8ff0\", \"value\": {\"get_attr\": [\"\\u8d44\\u6e90\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL);
/*!40000 ALTER TABLE `raw_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raw_template_files`
--

DROP TABLE IF EXISTS `raw_template_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `raw_template_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `files` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raw_template_files`
--

LOCK TABLES `raw_template_files` WRITE;
/*!40000 ALTER TABLE `raw_template_files` DISABLE KEYS */;
INSERT INTO `raw_template_files` (`id`, `files`, `created_at`, `updated_at`) VALUES (1,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}','2026-01-21 11:49:35',NULL),(2,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}','2026-01-21 11:49:35',NULL),(3,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}','2026-01-21 11:49:47',NULL),(4,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}','2026-01-21 11:49:48',NULL),(7,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random2:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random2, value]}\\n\"}','2026-01-21 11:50:14',NULL),(8,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random2:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random2, value]}\\n\"}','2026-01-21 11:50:16',NULL),(9,'{\"nested.yaml\": \"heat_template_version: \'2014-10-16\'\\nresources:\\n  foo_step1:\\n    type: OS::Heat::RandomString\\n  foo_step2:\\n    depends_on: foo_step1\\n    type: OS::Heat::RandomString\\n  foo_step3:\\n    depends_on: foo_step2\\n    type: OS::Heat::RandomString\\n\"}','2026-01-21 11:50:38',NULL),(10,'{\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The base stack (containing an actual resource) for the remote deeply-nested\\\\nstack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"router\\\": {\\\"type\\\": \\\"OS::Neutron::Router\\\", \\\"properties\\\": {\\\"name\\\": {\\\"list_join\\\": [\\\"-\\\", [{\\\"get_param\\\": \\\"name\\\"}, \\\"router\\\"]]}, \\\"external_gateway_info\\\": {\\\"network\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_resource\\\": \\\"router\\\"}}}}\", \"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_intermediate.yaml\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The intermediate stack (containing a local nested stack) to be instantiated\\\\nremotely in the remote deeply-nested stack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The public network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"network_stack_as_custom_type\\\": {\\\"type\\\": \\\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\\\", \\\"properties\\\": {\\\"name\\\": {\\\"get_param\\\": \\\"name\\\"}, \\\"network_name\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_attr\\\": [\\\"network_stack_as_custom_type\\\", \\\"router\\\"]}}}}\"}','2026-01-21 11:50:42',NULL),(11,'{\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The base stack (containing an actual resource) for the remote deeply-nested\\\\nstack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"router\\\": {\\\"type\\\": \\\"OS::Neutron::Router\\\", \\\"properties\\\": {\\\"name\\\": {\\\"list_join\\\": [\\\"-\\\", [{\\\"get_param\\\": \\\"name\\\"}, \\\"router\\\"]]}, \\\"external_gateway_info\\\": {\\\"network\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_resource\\\": \\\"router\\\"}}}}\", \"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_intermediate.yaml\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The intermediate stack (containing a local nested stack) to be instantiated\\\\nremotely in the remote deeply-nested stack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The public network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"network_stack_as_custom_type\\\": {\\\"type\\\": \\\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\\\", \\\"properties\\\": {\\\"name\\\": {\\\"get_param\\\": \\\"name\\\"}, \\\"network_name\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_attr\\\": [\\\"network_stack_as_custom_type\\\", \\\"router\\\"]}}}}\"}','2026-01-21 11:50:43',NULL),(13,'{\"1.yaml\": \"\\nheat_template_version: 2015-10-15\\nresources:\\n  test_resource_a:\\n    type: OS::Heat::TestResource\\n    properties:\\n      value: \'a\'\\n  test_resource_b:\\n    type: OS::Heat::TestResource\\n    properties:\\n      value: \'b\'\\noutputs:\\n  resource_output_a:\\n    description: \'Output of resource a\'\\n    value: { get_attr: [test_resource_a, output] }\\n  resource_output_b:\\n    description: \'Output of resource b\'\\n    value: { get_param: foo }\\n\"}','2026-01-21 11:52:14',NULL);
/*!40000 ALTER TABLE `raw_template_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource`
--

DROP TABLE IF EXISTS `resource`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `nova_instance` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  `rsrc_metadata` longtext DEFAULT NULL,
  `properties_data` longtext DEFAULT NULL,
  `engine_id` varchar(36) DEFAULT NULL,
  `atomic_key` int(11) DEFAULT NULL,
  `needed_by` longtext DEFAULT NULL,
  `requires` longtext DEFAULT NULL,
  `replaces` int(11) DEFAULT NULL,
  `replaced_by` int(11) DEFAULT NULL,
  `current_template_id` int(11) DEFAULT NULL,
  `properties_data_encrypted` tinyint(1) DEFAULT NULL,
  `root_stack_id` varchar(36) DEFAULT NULL,
  `rsrc_prop_data_id` int(11) DEFAULT NULL,
  `attr_data_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `stack_id` (`stack_id`),
  KEY `current_template_id` (`current_template_id`),
  KEY `ix_resource_root_stack_id` (`root_stack_id`),
  KEY `rsrc_rsrc_prop_data_ref` (`rsrc_prop_data_id`),
  KEY `rsrc_attr_data_ref` (`attr_data_id`),
  CONSTRAINT `resource_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`),
  CONSTRAINT `resource_ibfk_2` FOREIGN KEY (`current_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `rsrc_attr_data_ref` FOREIGN KEY (`attr_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `rsrc_rsrc_prop_data_ref` FOREIGN KEY (`rsrc_prop_data_id`) REFERENCES `resource_properties_data` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=229 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource`
--

LOCK TABLES `resource` WRITE;
/*!40000 ALTER TABLE `resource` DISABLE KEYS */;
INSERT INTO `resource` (`id`, `uuid`, `nova_instance`, `name`, `created_at`, `updated_at`, `action`, `status`, `status_reason`, `stack_id`, `rsrc_metadata`, `properties_data`, `engine_id`, `atomic_key`, `needed_by`, `requires`, `replaces`, `replaced_by`, `current_template_id`, `properties_data_encrypted`, `root_stack_id`, `rsrc_prop_data_id`, `attr_data_id`) VALUES (1,'dd988968-ce5a-4d3a-b3d8-a8160344d32d','api-485390504-envstack-test-2owollozrcli','test','2026-01-21 11:48:36',NULL,'CREATE','COMPLETE','state changed','87791753-832b-4e25-bdb8-97a4781e4260','{}','null',NULL,2,'[]','[]',NULL,NULL,2,NULL,'87791753-832b-4e25-bdb8-97a4781e4260',1,NULL),(3,'ad87f58f-2c44-4d12-9405-f1eee46dc14b','api-2116806331-rsrcstack-test-2ermiswyp5mp','test','2026-01-21 11:48:36',NULL,'CHECK','FAILED','resource deleted','cb36b365-7a1d-4fe1-bc43-ac090d0aecde','{}','null',NULL,4,'[]','[]',NULL,NULL,3,NULL,'cb36b365-7a1d-4fe1-bc43-ac090d0aecde',3,NULL),(5,'474f66da-2bd0-46a3-8823-12c031658b68','api-485390504-rsrcstack-test-nizl2bdu6zw2','test','2026-01-21 11:48:41',NULL,'CHECK','FAILED','resource deleted','6268584d-cf69-44cb-bdf0-9d8f6bd81b57','{}','null',NULL,4,'[]','[]',NULL,NULL,7,NULL,'6268584d-cf69-44cb-bdf0-9d8f6bd81b57',5,NULL),(7,'a1cc883e-1891-46bc-8dd0-11d95c864f48','api-736530183-stack-test-npaysgq4zcb6','test','2026-01-21 11:48:42','2026-01-21 11:48:46','UPDATE','COMPLETE','state changed','4f10c6b8-0472-4108-b086-fd59f41f35b5','{}','null',NULL,6,'[]','[]',NULL,NULL,23,NULL,'4f10c6b8-0472-4108-b086-fd59f41f35b5',13,NULL),(8,'5b3db8f5-4e69-462d-8fd6-40a309e0b94b','api-1892183375-stack-test-mlkonfnt3ohv','test','2026-01-21 11:48:45','2026-01-21 11:48:46','UPDATE','COMPLETE','state changed','8e7f35e3-6de2-4d40-ae21-5912ea3a8986','{}','null',NULL,4,'[]','[]',NULL,NULL,24,NULL,'8e7f35e3-6de2-4d40-ae21-5912ea3a8986',14,NULL),(9,'6b342ea8-c8de-4bc9-9a20-c9849bc29c68','api-485390504-stack-test-xsoi3zvtilvi','test','2026-01-21 11:48:46','2026-01-21 11:48:50','UPDATE','COMPLETE','state changed','a1f99d50-aa51-4cad-9b96-faac6562e7a6','{}','null',NULL,6,'[]','[]',NULL,NULL,26,NULL,'a1f99d50-aa51-4cad-9b96-faac6562e7a6',16,NULL);
/*!40000 ALTER TABLE `resource` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_data`
--

DROP TABLE IF EXISTS `resource_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  `redact` tinyint(1) DEFAULT NULL,
  `decrypt_method` varchar(64) DEFAULT NULL,
  `resource_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_resource_id` (`resource_id`),
  CONSTRAINT `fk_resource_id` FOREIGN KEY (`resource_id`) REFERENCES `resource` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=250 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_data`
--

LOCK TABLES `resource_data` WRITE;
/*!40000 ALTER TABLE `resource_data` DISABLE KEYS */;
INSERT INTO `resource_data` (`id`, `created_at`, `updated_at`, `key`, `value`, `redact`, `decrypt_method`, `resource_id`) VALUES (1,'2026-01-21 11:48:36',NULL,'value','test',0,'',1),(3,'2026-01-21 11:48:36',NULL,'value','test',0,'',3),(5,'2026-01-21 11:48:41',NULL,'value','test',0,'',5),(7,'2026-01-21 11:48:42','2026-01-21 11:48:46','value','new_patched_value',0,'',7),(8,'2026-01-21 11:48:45','2026-01-21 11:48:46','value','new_value',0,'',8),(9,'2026-01-21 11:48:46','2026-01-21 11:48:50','value','new_patched_value',0,'',9);
/*!40000 ALTER TABLE `resource_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_properties_data`
--

DROP TABLE IF EXISTS `resource_properties_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource_properties_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `data` longtext DEFAULT NULL,
  `encrypted` tinyint(1) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=252 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_properties_data`
--

LOCK TABLES `resource_properties_data` WRITE;
/*!40000 ALTER TABLE `resource_properties_data` DISABLE KEYS */;
INSERT INTO `resource_properties_data` (`id`, `data`, `encrypted`, `created_at`, `updated_at`) VALUES (1,'{\"value\": \"test\"}',0,'2026-01-21 11:48:36',NULL),(2,'{\"value\": \"test\"}',0,'2026-01-21 11:48:36',NULL),(3,'{\"value\": \"test\"}',0,'2026-01-21 11:48:36',NULL),(4,'{\"value\": \"test\"}',0,'2026-01-21 11:48:36',NULL),(5,'{\"value\": \"test\"}',0,'2026-01-21 11:48:41',NULL),(6,'{\"value\": \"value\"}',0,'2026-01-21 11:48:42',NULL),(7,'{\"value\": \"value\"}',0,'2026-01-21 11:48:42',NULL),(8,'{\"value\": \"new_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2026-01-21 11:48:45',NULL),(9,'{\"value\": \"value\"}',0,'2026-01-21 11:48:45',NULL),(10,'{\"value\": \"new_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2026-01-21 11:48:45',NULL),(11,'{\"value\": \"value\"}',0,'2026-01-21 11:48:46',NULL),(12,'{\"value\": \"new_patched_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2026-01-21 11:48:48',NULL),(13,'{\"value\": \"new_patched_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2026-01-21 11:48:48',NULL),(14,'{\"value\": \"new_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2026-01-21 11:48:48',NULL),(15,'{\"value\": \"new_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2026-01-21 11:48:49',NULL),(16,'{\"value\": \"new_patched_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2026-01-21 11:48:52',NULL),(17,'{\"network\": \"ec9c3d74-94b2-465d-9700-dcdf321ea66b\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2026-01-21 11:48:53',NULL),(18,'{\"enable_dhcp\": false, \"network\": \"3811b843-1191-4806-9b27-c3e748e231fd\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-01-21 11:48:53',NULL),(19,'{\"cidr\": \"10.10.0.0/16\", \"network\": \"7f219b54-86f6-44e3-86cf-243b418b95ea\"}',0,'2026-01-21 11:48:53',NULL),(20,'{\"network\": \"3811b843-1191-4806-9b27-c3e748e231fd\", \"mac_address\": \"00-00-00-00-BB-BB\", \"fixed_ips\": [{\"subnet\": \"922c5084-88c6-4243-823c-37fc868ab12b\", \"ip_address\": \"11.11.11.11\"}]}',0,'2026-01-21 11:48:53',NULL),(21,'{\"name\": \"my_encrypted_foo\", \"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\", \"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"networks\": [{\"network\": \"heat_tempestconf_network\"}]}',0,'2026-01-21 11:48:54',NULL),(22,'{\"cidr\": \"10.0.0.0/16\", \"network\": \"e4393cde-e6c8-4bf8-a5e9-d0369150e594\"}',0,'2026-01-21 11:48:54',NULL),(23,'{\"name\": \"trunk_sub_port_one\", \"network\": \"7f219b54-86f6-44e3-86cf-243b418b95ea\"}',0,'2026-01-21 11:48:54',NULL),(25,'{\"value\": \"Test1\", \"fail\": false}',0,'2026-01-21 11:48:55',NULL),(26,'{\"cidr\": \"10.20.0.0/16\", \"network\": \"0ef98077-903c-4874-855b-171ffda59242\"}',0,'2026-01-21 11:48:56',NULL),(28,'{\"name\": \"trunk_parent_port\", \"network\": \"e4393cde-e6c8-4bf8-a5e9-d0369150e594\"}',0,'2026-01-21 11:48:57',NULL),(29,'{\"name\": \"test_trunk\", \"port\": \"671bf162-11dc-425b-a4bc-a1be333fd51f\", \"sub_ports\": [{\"port\": \"0e5a2803-815c-4754-96bf-1e570f049773\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2026-01-21 11:48:57',NULL),(30,'{\"name\": \"trunk_sub_port_two\", \"network\": \"0ef98077-903c-4874-855b-171ffda59242\"}',0,'2026-01-21 11:48:58',NULL),(31,'{\"network\": \"ec9c3d74-94b2-465d-9700-dcdf321ea66b\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.100\"}]}',0,'2026-01-21 11:48:58',NULL),(32,'{\"network\": \"3811b843-1191-4806-9b27-c3e748e231fd\", \"mac_address\": \"00-00-00-00-BB-BB\", \"fixed_ips\": [{\"subnet\": \"922c5084-88c6-4243-823c-37fc868ab12b\"}]}',0,'2026-01-21 11:48:59',NULL),(35,'{\"name\": \"test_trunk\", \"port\": \"671bf162-11dc-425b-a4bc-a1be333fd51f\", \"sub_ports\": [{\"port\": \"0e5a2803-815c-4754-96bf-1e570f049773\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}, {\"port\": \"2fc495fb-1817-4915-a957-07aa70045928\", \"segmentation_id\": 20, \"segmentation_type\": \"vlan\"}]}',0,'2026-01-21 11:49:05',NULL),(37,'{\"enable_dhcp\": false, \"network\": \"ce84737d-2122-46a5-8210-58ef919fc471\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-01-21 11:49:09',NULL),(38,'{\"network\": \"b49a204f-b0fa-44f3-a6cf-dbbef5cfdb28\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2026-01-21 11:49:09',NULL),(39,'{\"network\": \"ce84737d-2122-46a5-8210-58ef919fc471\", \"mac_address\": \"00-00-00-00-BB-BB\", \"fixed_ips\": [{\"subnet\": \"75e43cea-8fde-4ba2-9f47-2022a8a832f5\", \"ip_address\": \"11.11.11.11\"}]}',0,'2026-01-21 11:49:09',NULL),(41,'{\"value\": \"Test1\", \"fail\": false}',0,'2026-01-21 11:49:10',NULL),(43,'{\"network\": \"71b25559-a0fd-4e5f-9ebf-8810b36bfd52\", \"cidr\": \"10.0.0.0/16\"}',0,'2026-01-21 11:49:12',NULL),(44,'{\"name\": \"server_with_port_net\"}',0,'2026-01-21 11:49:12',NULL),(45,'{\"network\": \"0d216dc4-08c7-4c79-9890-347b3967b8d0\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-01-21 11:49:14',NULL),(46,'{\"network\": \"0dc0f61e-d359-4009-8df5-b85f84f6aa12\", \"cidr\": \"10.20.0.0/16\"}',0,'2026-01-21 11:49:14',NULL),(47,'{\"network\": \"b49a204f-b0fa-44f3-a6cf-dbbef5cfdb28\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": []}',0,'2026-01-21 11:49:14',NULL),(48,'{\"network\": \"71b25559-a0fd-4e5f-9ebf-8810b36bfd52\", \"name\": \"trunk_parent_port\"}',0,'2026-01-21 11:49:14',NULL),(49,'{\"network\": \"11b02936-21f2-4dba-843d-46eb6ca5c23b\", \"cidr\": \"10.10.0.0/16\"}',0,'2026-01-21 11:49:15',NULL),(50,'{\"network\": \"0d216dc4-08c7-4c79-9890-347b3967b8d0\", \"fixed_ips\": [{\"subnet\": \"4372117e-4248-4dfd-9e36-53aa08cc5053\", \"ip_address\": \"11.11.11.11\"}]}',0,'2026-01-21 11:49:15',NULL),(51,'{\"network\": \"ce84737d-2122-46a5-8210-58ef919fc471\", \"mac_address\": \"00-00-00-00-AA-AA\", \"fixed_ips\": [{\"subnet\": \"75e43cea-8fde-4ba2-9f47-2022a8a832f5\", \"ip_address\": \"11.11.11.11\"}]}',0,'2026-01-21 11:49:15',NULL),(52,'{\"name\": \"test_trunk\", \"port\": \"c38d4a29-45b3-40d1-851f-eb814bdabda5\", \"sub_ports\": null}',0,'2026-01-21 11:49:16',NULL),(53,'{\"network\": \"0dc0f61e-d359-4009-8df5-b85f84f6aa12\", \"name\": \"trunk_sub_port_two\"}',0,'2026-01-21 11:49:16',NULL),(54,'{\"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\", \"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"networks\": [{\"port\": \"f4e611c0-d2ea-47a0-9fed-6207aee8fad3\"}]}',0,'2026-01-21 11:49:16',NULL),(55,'{\"network\": \"11b02936-21f2-4dba-843d-46eb6ca5c23b\", \"name\": \"trunk_sub_port_one\"}',0,'2026-01-21 11:49:16',NULL),(58,'{\"network\": \"3c72fd72-2d04-47f0-ac76-cee5d5aee494\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2026-01-21 11:49:24',NULL),(59,'{\"name\": \"test_trunk\", \"port\": \"c38d4a29-45b3-40d1-851f-eb814bdabda5\", \"sub_ports\": [{\"port\": \"17d1ff55-cd1b-413a-acbf-e7f4ec6180f3\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2026-01-21 11:49:25',NULL),(61,'{\"network\": \"3c72fd72-2d04-47f0-ac76-cee5d5aee494\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.9\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2026-01-21 11:49:28',NULL),(64,'{\"name\": \"my_net\"}',0,'2026-01-21 11:49:35',NULL),(65,'{\"cidr\": \"10.10.0.0/16\", \"network\": \"7ef73f0f-f718-4de7-a03b-cba3430cb33e\"}',0,'2026-01-21 11:49:35',NULL),(66,'{\"context\": {\"region_name\": \"regionOne\"}, \"template\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}',0,'2026-01-21 11:49:35',NULL),(67,'{\"network\": \"bf8cff3d-82d4-456e-bf5f-5fbfa66bcb26\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-01-21 11:49:36',NULL),(68,'{\"name\": \"the_sg\", \"description\": \"Ping and SSH\", \"rules\": [{\"protocol\": \"icmp\"}, {\"protocol\": \"tcp\", \"port_range_min\": 22, \"port_range_max\": 22}]}',0,'2026-01-21 11:49:36',NULL),(69,'{\"cidr\": \"10.0.0.0/16\", \"network\": \"67c98f4d-d9b0-4c18-a67f-26fd4a8f1d18\"}',0,'2026-01-21 11:49:36',NULL),(70,'{\"name\": \"trunk_sub_port_one\", \"network\": \"7ef73f0f-f718-4de7-a03b-cba3430cb33e\"}',0,'2026-01-21 11:49:36',NULL),(71,'{\"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\", \"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"networks\": [{\"subnet\": \"05debbb3-7225-4376-9d45-5b54cdc2536c\", \"fixed_ip\": \"11.11.11.11\"}], \"security_groups\": [\"85f1dbaf-6920-4ded-bd81-9df1b1677c29\"]}',0,'2026-01-21 11:49:37',NULL),(72,'{\"name\": \"trunk_parent_port\", \"network\": \"67c98f4d-d9b0-4c18-a67f-26fd4a8f1d18\"}',0,'2026-01-21 11:49:37',NULL),(73,'{\"cidr\": \"10.20.0.0/16\", \"network\": \"b0d6c17a-5feb-4851-b5ae-78f92022d6dd\"}',0,'2026-01-21 11:49:37',NULL),(74,'{\"name\": \"test_trunk\", \"port\": \"ce035354-160a-41fc-a703-9f1d5ae24d62\", \"sub_ports\": [{\"port\": \"a16117ae-49df-4fac-81b6-fd16f28b516e\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2026-01-21 11:49:38',NULL),(75,'{\"name\": \"trunk_sub_port_two\", \"network\": \"b0d6c17a-5feb-4851-b5ae-78f92022d6dd\"}',0,'2026-01-21 11:49:38',NULL),(76,'{\"network\": \"a2ce8685-8bee-4eec-8bbb-bb4a01b19226\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2026-01-21 11:49:39',NULL),(79,'{\"network\": \"a2ce8685-8bee-4eec-8bbb-bb4a01b19226\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": null, \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2026-01-21 11:49:46',NULL),(80,'{\"context\": {\"region_name\": \"regionOne\"}, \"template\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}',0,'2026-01-21 11:49:48',NULL),(81,'{\"name\": \"test_trunk\", \"port\": \"ce035354-160a-41fc-a703-9f1d5ae24d62\", \"sub_ports\": []}',0,'2026-01-21 11:49:48',NULL),(85,'{\"network\": \"90cadcd2-650f-4425-bc4d-f70355b6e2bc\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2026-01-21 11:49:56',NULL),(86,'{\"cidr\": \"10.20.0.0/16\", \"network\": \"efd5e132-6838-4062-a519-ce03dd2a850d\"}',0,'2026-01-21 11:49:59',NULL),(87,'{\"name\": \"the_net\"}',0,'2026-01-21 11:50:00',NULL),(89,'{\"name\": \"trunk_sub_port_two\", \"network\": \"efd5e132-6838-4062-a519-ce03dd2a850d\"}',0,'2026-01-21 11:50:00',NULL),(90,'{\"network\": \"e066e7ad-4955-4f17-9b45-284183d092e8\", \"cidr\": \"12.12.12.0/24\", \"name\": \"subnet_b\"}',0,'2026-01-21 11:50:01',NULL),(91,'{\"network\": \"e066e7ad-4955-4f17-9b45-284183d092e8\", \"cidr\": \"11.11.11.0/24\", \"name\": \"subnet_a\"}',0,'2026-01-21 11:50:01',NULL),(92,'{\"cidr\": \"10.10.0.0/16\", \"network\": \"cfe08323-cb33-42c0-a863-a027bbdbd3b2\"}',0,'2026-01-21 11:50:01',NULL),(93,'{\"network\": \"90cadcd2-650f-4425-bc4d-f70355b6e2bc\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\"}',0,'2026-01-21 11:50:02',NULL),(94,'{\"cidr\": \"10.0.0.0/16\", \"network\": \"b27daec5-85c4-49ef-9598-daced17cb2da\"}',0,'2026-01-21 11:50:02',NULL),(95,'{\"name\": \"trunk_sub_port_one\", \"network\": \"cfe08323-cb33-42c0-a863-a027bbdbd3b2\"}',0,'2026-01-21 11:50:02',NULL),(96,'{\"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\", \"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"networks\": [{\"subnet\": \"b79eb021-355d-4986-9de8-116394afc2da\"}]}',0,'2026-01-21 11:50:02',NULL),(97,'{\"name\": \"trunk_parent_port\", \"network\": \"b27daec5-85c4-49ef-9598-daced17cb2da\"}',0,'2026-01-21 11:50:03',NULL),(98,'{\"name\": \"test_trunk\", \"port\": \"e6c0c506-e4a4-493c-b770-f67d9305fa4c\", \"sub_ports\": [{\"port\": \"0d8eaabf-1a63-42c8-98da-84fd9e609b6c\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}, {\"port\": \"a42e30b7-9193-417d-b09e-39d20fe3ce3d\", \"segmentation_id\": 20, \"segmentation_type\": \"vlan\"}]}',0,'2026-01-21 11:50:04',NULL),(100,'{\"context\": {\"region_name\": \"regionOne\"}, \"template\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}',0,'2026-01-21 11:50:08',NULL),(101,'{\"network\": \"6830bbfb-ac04-4d6a-91a6-2abf834e167d\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2026-01-21 11:50:12',NULL),(102,'{\"name\": \"test_trunk\", \"port\": \"e6c0c506-e4a4-493c-b770-f67d9305fa4c\", \"sub_ports\": [{\"port\": \"0d8eaabf-1a63-42c8-98da-84fd9e609b6c\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2026-01-21 11:50:12',NULL),(106,'{\"context\": {\"region_name\": \"regionOne\"}, \"template\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random2:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random2, value]}\\n\"}',0,'2026-01-21 11:50:19',NULL),(107,'{\"network\": \"6830bbfb-ac04-4d6a-91a6-2abf834e167d\", \"cidr\": \"11.11.11.0/24\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2026-01-21 11:50:20',NULL),(109,'{\"cidr\": \"10.10.0.0/16\", \"network\": \"86bba8eb-3413-4f62-9fe6-ff848cbc20ed\"}',0,'2026-01-21 11:50:25',NULL),(110,'{\"cidr\": \"10.20.0.0/16\", \"network\": \"08cfb3a7-9284-44e8-910c-6af21dc8688b\"}',0,'2026-01-21 11:50:26',NULL),(111,'{\"name\": \"trunk_sub_port_one\", \"network\": \"86bba8eb-3413-4f62-9fe6-ff848cbc20ed\"}',0,'2026-01-21 11:50:27',NULL),(112,'{\"cidr\": \"10.0.0.0/16\", \"network\": \"aff2b0f4-9b44-42a0-816d-fccd7afbf024\"}',0,'2026-01-21 11:50:27',NULL),(113,'{\"name\": \"trunk_sub_port_two\", \"network\": \"08cfb3a7-9284-44e8-910c-6af21dc8688b\"}',0,'2026-01-21 11:50:28',NULL),(114,'{\"name\": \"trunk_parent_port\", \"network\": \"aff2b0f4-9b44-42a0-816d-fccd7afbf024\"}',0,'2026-01-21 11:50:28',NULL),(115,'{\"name\": \"test_trunk\", \"port\": \"6b83d18a-296c-4b99-b632-eadf14e0c431\", \"sub_ports\": [{\"port\": \"e306ac42-012f-44ae-94ef-38ca25e2d340\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2026-01-21 11:50:29',NULL),(116,'{\"value\": \"Test1\"}',0,'2026-01-21 11:50:30',NULL),(117,'{\"value\": \"Test2\"}',0,'2026-01-21 11:50:30',NULL),(118,'{\"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\", \"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"networks\": [{\"subnet\": \"cd713b2a-e247-494a-ba6d-958d3a88f862\"}]}',0,'2026-01-21 11:50:32',NULL),(120,'{\"value\": \"Test1\"}',0,'2026-01-21 11:50:36',NULL),(121,'{\"value\": \"Test2\"}',0,'2026-01-21 11:50:36',NULL),(122,'{\"name\": \"test_trunk\", \"port\": \"6b83d18a-296c-4b99-b632-eadf14e0c431\", \"sub_ports\": [{\"port\": \"e306ac42-012f-44ae-94ef-38ca25e2d340\", \"segmentation_id\": 99, \"segmentation_type\": \"vlan\"}]}',0,'2026-01-21 11:50:38',NULL),(123,'{\"value\": \"test1\", \"fail\": false, \"update_replace\": false, \"wait_secs\": 0}',0,'2026-01-21 11:50:42',NULL),(125,'{\"context\": {\"region_name\": \"regionOne\"}, \"parameters\": {\"name\": \"remote-nested\", \"network_name\": \"public\"}, \"template\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The intermediate stack (containing a local nested stack) to be instantiated\\\\nremotely in the remote deeply-nested stack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The public network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"network_stack_as_custom_type\\\": {\\\"type\\\": \\\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\\\", \\\"properties\\\": {\\\"name\\\": {\\\"get_param\\\": \\\"name\\\"}, \\\"network_name\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_attr\\\": [\\\"network_stack_as_custom_type\\\", \\\"router\\\"]}}}}\"}',0,'2026-01-21 11:50:43',NULL),(126,'{\"name\": \"remote-nested\", \"network_name\": \"public\"}',0,'2026-01-21 11:50:44',NULL),(127,'{\"name\": \"remote-nested-router\", \"external_gateway_info\": {\"network\": \"public\"}}',0,'2026-01-21 11:50:44',NULL),(130,'{\"network\": \"73d9de56-8c2f-49f2-a863-0c6f78cc6595\", \"cidr\": \"10.0.0.0/16\"}',0,'2026-01-21 11:50:53',NULL),(131,'{\"network\": \"73d9de56-8c2f-49f2-a863-0c6f78cc6595\", \"name\": \"trunk_parent_port\"}',0,'2026-01-21 11:50:54',NULL),(132,'{\"network\": \"35639def-2c90-479e-8355-34646781670e\", \"cidr\": \"10.10.0.0/16\"}',0,'2026-01-21 11:50:54',NULL),(133,'{\"name\": \"test_trunk\", \"port\": \"744a0c95-6054-4c24-b6a3-a4cb3b9ade78\", \"sub_ports\": null}',0,'2026-01-21 11:50:55',NULL),(134,'{\"network\": \"d909d83b-be53-4dc4-99de-7acc7ff7c4f5\", \"cidr\": \"10.20.0.0/16\"}',0,'2026-01-21 11:50:55',NULL),(135,'{\"network\": \"35639def-2c90-479e-8355-34646781670e\", \"name\": \"trunk_sub_port_one\"}',0,'2026-01-21 11:50:55',NULL),(136,'{\"network\": \"d909d83b-be53-4dc4-99de-7acc7ff7c4f5\", \"name\": \"trunk_sub_port_two\"}',0,'2026-01-21 11:50:56',NULL),(137,'{\"description\": \"This is a test trunk\", \"name\": \"pineapple\", \"port\": \"744a0c95-6054-4c24-b6a3-a4cb3b9ade78\", \"sub_ports\": null}',0,'2026-01-21 11:51:09',NULL),(139,'{\"name\": \"LUKS\"}',0,'2026-01-21 11:51:17',NULL),(140,'{\"provider\": \"nova.volume.encryptors.luks.LuksEncryptor\", \"control_location\": \"front-end\", \"cipher\": \"aes-xts-plain64\", \"key_size\": 512, \"volume_type\": \"d47944a7-10e8-4c29-b037-5e146aa0d6af\"}',0,'2026-01-21 11:51:17',NULL),(141,'{\"count\": 1, \"resource_def\": {\"type\": \"OS::Heat::RandomString\"}}',0,'2026-01-21 11:51:21',NULL),(142,'{\"provider\": \"nova.volume.encryptors.luks.LuksEncryptor\", \"control_location\": \"front-end\", \"cipher\": \"aes-cbc-essiv\", \"key_size\": 256, \"volume_type\": \"d47944a7-10e8-4c29-b037-5e146aa0d6af\"}',0,'2026-01-21 11:51:22',NULL),(143,'{\"count\": 2, \"resource_def\": {\"type\": \"OS::Heat::RandomString\"}}',0,'2026-01-21 11:51:30',NULL),(144,'{\"length\": 10}',0,'2026-01-21 11:51:57',NULL),(145,'{\"name\": \"the_net\"}',0,'2026-01-21 11:52:07',NULL),(146,'{\"name\": \"the_subnet\", \"network\": \"050e2666-0245-43ea-8b8d-0dcb88a82b55\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-01-21 11:52:08',NULL),(147,'{\"value\": \"b\"}',0,'2026-01-21 11:52:10',NULL),(148,'{\"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\", \"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"networks\": [{\"subnet\": \"ecc340ac-bffe-4d60-8aa4-e23dba086c69\"}]}',0,'2026-01-21 11:52:10',NULL),(149,'{\"value\": \"a\"}',0,'2026-01-21 11:52:11',NULL),(152,'{\"value\": \"a\"}',0,'2026-01-21 11:52:31',NULL),(153,'{\"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\", \"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"networks\": [{\"network\": \"050e2666-0245-43ea-8b8d-0dcb88a82b55\", \"subnet\": \"ecc340ac-bffe-4d60-8aa4-e23dba086c69\"}]}',0,'2026-01-21 11:52:31',NULL),(154,'{\"value\": \"b\"}',0,'2026-01-21 11:52:32',NULL),(156,'{\"value\": \"foo\"}',0,'2026-01-21 11:52:41',NULL),(157,'{\"value\": \"foo\"}',0,'2026-01-21 11:52:45',NULL),(158,'{\"name\": \"the_net\"}',0,'2026-01-21 11:52:46',NULL),(159,'{\"name\": \"the_subnet\", \"network\": \"b50afd0d-c012-4629-b497-6fd1b5e6d0c9\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-01-21 11:52:47',NULL),(160,'{\"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\", \"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"networks\": [{\"network\": \"b50afd0d-c012-4629-b497-6fd1b5e6d0c9\"}]}',0,'2026-01-21 11:52:48',NULL),(161,'{\"wait_secs\": 1, \"value\": \"test\"}',0,'2026-01-21 11:52:55',NULL),(163,'{\"wait_secs\": 1, \"value\": \"test\"}',0,'2026-01-21 11:53:05',NULL),(164,'{\"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\", \"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"networks\": [{\"network\": \"b50afd0d-c012-4629-b497-6fd1b5e6d0c9\", \"fixed_ip\": \"11.11.11.250\"}]}',0,'2026-01-21 11:53:05',NULL),(166,'{\"wait_secs\": 1, \"value\": \"next\"}',0,'2026-01-21 11:53:12',NULL),(167,'{\"wait_secs\": 1, \"value\": \"none\"}',0,'2026-01-21 11:53:17',NULL),(168,'{\"name\": \"the_net\"}',0,'2026-01-21 11:53:21',NULL),(169,'{\"name\": \"the_subnet\", \"network\": \"bd3013fb-148f-450f-beae-4553a43c068e\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-01-21 11:53:22',NULL),(170,'{\"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\", \"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"networks\": [{\"network\": \"bd3013fb-148f-450f-beae-4553a43c068e\"}]}',0,'2026-01-21 11:53:23',NULL),(171,'{\"update_replace\": false, \"wait_secs\": 0, \"value\": \"Test1\", \"fail\": false}',0,'2026-01-21 11:53:25',NULL),(173,'{\"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\", \"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"networks\": [{\"network\": \"bd3013fb-148f-450f-beae-4553a43c068e\", \"subnet\": \"de6ae73b-a2dc-4a06-aa11-d8a189215e81\"}]}',0,'2026-01-21 11:53:45',NULL),(175,'{\"name\": \"the_net\"}',0,'2026-01-21 11:53:55',NULL),(176,'{\"name\": \"the_subnet\", \"network\": \"b6c655e3-0f07-4e83-be80-7e54d04ecd04\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-01-21 11:53:56',NULL),(177,'{\"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\", \"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"networks\": [{\"network\": \"b6c655e3-0f07-4e83-be80-7e54d04ecd04\"}, {\"network\": \"b6c655e3-0f07-4e83-be80-7e54d04ecd04\", \"fixed_ip\": \"11.11.11.33\"}, {\"subnet\": \"219f2f0a-5f6d-4e87-bb0c-8ea3653944cb\"}]}',0,'2026-01-21 11:53:57',NULL),(179,'{\"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\", \"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"networks\": [{\"subnet\": \"219f2f0a-5f6d-4e87-bb0c-8ea3653944cb\"}, {\"network\": \"b6c655e3-0f07-4e83-be80-7e54d04ecd04\"}, {\"network\": \"b6c655e3-0f07-4e83-be80-7e54d04ecd04\", \"subnet\": \"219f2f0a-5f6d-4e87-bb0c-8ea3653944cb\"}]}',0,'2026-01-21 11:54:17',NULL),(181,'{\"name\": \"the_net\"}',0,'2026-01-21 11:54:35',NULL),(182,'{\"name\": \"the_subnet\", \"network\": \"13b0d6b4-2dfe-4ce7-bdb1-ac84aa1c8758\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-01-21 11:54:36',NULL),(183,'{\"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\", \"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"networks\": [{\"network\": \"13b0d6b4-2dfe-4ce7-bdb1-ac84aa1c8758\"}]}',0,'2026-01-21 11:54:37',NULL),(185,'{\"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\", \"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"networks\": [{\"port\": \"8bf6184e-9034-407e-9b11-f0f4bc0e9bc1\"}]}',0,'2026-01-21 11:54:56',NULL),(187,'{\"name\": \"the_net\"}',0,'2026-01-21 11:55:10',NULL),(188,'{\"name\": \"the_subnet\", \"network\": \"b8b84fb5-4598-4a5d-adc2-15ac770b4a3d\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-01-21 11:55:12',NULL),(189,'{\"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\", \"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"networks\": [{\"network\": \"b8b84fb5-4598-4a5d-adc2-15ac770b4a3d\"}]}',0,'2026-01-21 11:55:13',NULL),(191,'{\"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\", \"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"networks\": [{\"subnet\": \"27964a86-9187-42b5-8b58-c2dbcb193476\"}]}',0,'2026-01-21 11:55:34',NULL),(193,'{\"name\": \"the_net\"}',0,'2026-01-21 11:55:46',NULL),(194,'{\"name\": \"the_subnet\", \"network\": \"805ee308-2055-4719-83b4-cf4e00fb3ce5\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-01-21 11:55:47',NULL),(195,'{\"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\", \"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"networks\": [{\"subnet\": \"579765c2-40c2-47f8-b31b-4040e7e5c2e9\"}]}',0,'2026-01-21 11:55:48',NULL),(197,'{\"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\", \"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"networks\": [{\"network\": \"805ee308-2055-4719-83b4-cf4e00fb3ce5\"}]}',0,'2026-01-21 11:56:07',NULL),(199,'{\"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\", \"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"user_data_format\": \"SOFTWARE_CONFIG\", \"networks\": [{\"network\": \"heat_tempestconf_network\"}]}',0,'2026-01-21 11:56:21',NULL),(200,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2026-01-21 11:56:35',NULL),(201,'{\"config\": \"c4a706e4-b583-4904-a857-cecb8b5d950f\", \"servers\": {\"0\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}}',0,'2026-01-21 11:56:35',NULL),(202,'{\"config\": \"c4a706e4-b583-4904-a857-cecb8b5d950f\", \"servers\": {\"0\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}}',0,'2026-01-21 11:56:35',NULL),(203,'{\"config\": \"c4a706e4-b583-4904-a857-cecb8b5d950f\", \"servers\": {\"0\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}}',0,'2026-01-21 11:56:35',NULL),(204,'{\"config\": \"c4a706e4-b583-4904-a857-cecb8b5d950f\", \"servers\": {\"0\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}}',0,'2026-01-21 11:56:35',NULL),(205,'{\"config\": \"c4a706e4-b583-4904-a857-cecb8b5d950f\", \"servers\": {\"0\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}}',0,'2026-01-21 11:56:35',NULL),(206,'{\"config\": \"c4a706e4-b583-4904-a857-cecb8b5d950f\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}',0,'2026-01-21 11:56:35',NULL),(207,'{\"config\": \"c4a706e4-b583-4904-a857-cecb8b5d950f\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}',0,'2026-01-21 11:56:35',NULL),(208,'{\"config\": \"c4a706e4-b583-4904-a857-cecb8b5d950f\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}',0,'2026-01-21 11:56:35',NULL),(209,'{\"config\": \"c4a706e4-b583-4904-a857-cecb8b5d950f\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}',0,'2026-01-21 11:56:35',NULL),(210,'{\"config\": \"c4a706e4-b583-4904-a857-cecb8b5d950f\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}',0,'2026-01-21 11:56:35',NULL),(211,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2026-01-21 11:56:36',NULL),(212,'{\"config\": \"40e09982-598f-4462-add4-00eda355d0ef\", \"servers\": {\"0\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}}',0,'2026-01-21 11:56:36',NULL),(213,'{\"config\": \"40e09982-598f-4462-add4-00eda355d0ef\", \"servers\": {\"0\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}}',0,'2026-01-21 11:56:36',NULL),(214,'{\"config\": \"40e09982-598f-4462-add4-00eda355d0ef\", \"servers\": {\"0\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}}',0,'2026-01-21 11:56:36',NULL),(215,'{\"config\": \"40e09982-598f-4462-add4-00eda355d0ef\", \"servers\": {\"0\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}}',0,'2026-01-21 11:56:36',NULL),(216,'{\"config\": \"40e09982-598f-4462-add4-00eda355d0ef\", \"servers\": {\"0\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}}',0,'2026-01-21 11:56:36',NULL),(217,'{\"config\": \"40e09982-598f-4462-add4-00eda355d0ef\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}',0,'2026-01-21 11:56:37',NULL),(218,'{\"config\": \"40e09982-598f-4462-add4-00eda355d0ef\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}',0,'2026-01-21 11:56:37',NULL),(219,'{\"config\": \"40e09982-598f-4462-add4-00eda355d0ef\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}',0,'2026-01-21 11:56:37',NULL),(220,'{\"config\": \"40e09982-598f-4462-add4-00eda355d0ef\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}',0,'2026-01-21 11:56:37',NULL),(221,'{\"config\": \"40e09982-598f-4462-add4-00eda355d0ef\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}',0,'2026-01-21 11:56:37',NULL),(222,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2026-01-21 11:56:46',NULL),(223,'{\"config\": \"a6d3dfa2-e685-4854-ae22-24ba8b422c62\", \"servers\": {\"0\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}}',0,'2026-01-21 11:56:46',NULL),(224,'{\"config\": \"a6d3dfa2-e685-4854-ae22-24ba8b422c62\", \"servers\": {\"0\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}}',0,'2026-01-21 11:56:46',NULL),(225,'{\"config\": \"a6d3dfa2-e685-4854-ae22-24ba8b422c62\", \"servers\": {\"0\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}}',0,'2026-01-21 11:56:46',NULL),(226,'{\"config\": \"a6d3dfa2-e685-4854-ae22-24ba8b422c62\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}',0,'2026-01-21 11:56:46',NULL),(227,'{\"config\": \"a6d3dfa2-e685-4854-ae22-24ba8b422c62\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}',0,'2026-01-21 11:56:46',NULL),(228,'{\"config\": \"a6d3dfa2-e685-4854-ae22-24ba8b422c62\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}',0,'2026-01-21 11:56:46',NULL),(229,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2026-01-21 11:56:47',NULL),(230,'{\"config\": \"6ba63002-f444-4cd2-b43c-7362c3007d78\", \"servers\": {\"0\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}}',0,'2026-01-21 11:56:47',NULL),(231,'{\"config\": \"6ba63002-f444-4cd2-b43c-7362c3007d78\", \"servers\": {\"0\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}}',0,'2026-01-21 11:56:47',NULL),(232,'{\"config\": \"6ba63002-f444-4cd2-b43c-7362c3007d78\", \"servers\": {\"0\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}}',0,'2026-01-21 11:56:47',NULL),(233,'{\"config\": \"6ba63002-f444-4cd2-b43c-7362c3007d78\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}',0,'2026-01-21 11:56:47',NULL),(234,'{\"config\": \"6ba63002-f444-4cd2-b43c-7362c3007d78\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}',0,'2026-01-21 11:56:47',NULL),(235,'{\"config\": \"6ba63002-f444-4cd2-b43c-7362c3007d78\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}',0,'2026-01-21 11:56:47',NULL),(236,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2026-01-21 11:56:49',NULL),(237,'{\"config\": \"d2cbf5cf-4d45-416a-b5b2-0613e8b26bd8\", \"servers\": {\"0\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}}',0,'2026-01-21 11:56:49',NULL),(238,'{\"config\": \"d2cbf5cf-4d45-416a-b5b2-0613e8b26bd8\", \"servers\": {\"0\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}}',0,'2026-01-21 11:56:49',NULL),(239,'{\"config\": \"d2cbf5cf-4d45-416a-b5b2-0613e8b26bd8\", \"servers\": {\"0\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}}',0,'2026-01-21 11:56:49',NULL),(240,'{\"config\": \"d2cbf5cf-4d45-416a-b5b2-0613e8b26bd8\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}',0,'2026-01-21 11:56:49',NULL),(241,'{\"config\": \"d2cbf5cf-4d45-416a-b5b2-0613e8b26bd8\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}',0,'2026-01-21 11:56:49',NULL),(242,'{\"config\": \"d2cbf5cf-4d45-416a-b5b2-0613e8b26bd8\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"4ff9a573-1e19-46f3-8efa-47cd3724747a\"}',0,'2026-01-21 11:56:49',NULL),(243,'{\"image\": \"72c09ccb-dfdf-460c-ac3a-9d637d6339b1\", \"flavor\": \"f5e955ce-edbc-46fb-af56-4b2a8e7022a0\", \"user_data_format\": \"SOFTWARE_CONFIG\", \"networks\": [{\"network\": \"heat_tempestconf_network\"}]}',0,'2026-01-21 11:58:01',NULL),(244,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2026-01-21 11:58:15',NULL),(245,'{\"config\": \"0be577d3-9c5a-4d36-b5a9-25fc7e2c64ee\", \"servers\": {\"0\": \"b6d9ed1d-62f0-4eaf-a42a-e78ed70b7a90\"}}',0,'2026-01-21 11:58:15',NULL),(246,'{\"config\": \"0be577d3-9c5a-4d36-b5a9-25fc7e2c64ee\", \"servers\": {\"0\": \"b6d9ed1d-62f0-4eaf-a42a-e78ed70b7a90\"}}',0,'2026-01-21 11:58:15',NULL),(247,'{\"config\": \"0be577d3-9c5a-4d36-b5a9-25fc7e2c64ee\", \"servers\": {\"0\": \"b6d9ed1d-62f0-4eaf-a42a-e78ed70b7a90\"}}',0,'2026-01-21 11:58:15',NULL),(248,'{\"config\": \"0be577d3-9c5a-4d36-b5a9-25fc7e2c64ee\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"b6d9ed1d-62f0-4eaf-a42a-e78ed70b7a90\"}',0,'2026-01-21 11:58:16',NULL),(249,'{\"config\": \"0be577d3-9c5a-4d36-b5a9-25fc7e2c64ee\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"b6d9ed1d-62f0-4eaf-a42a-e78ed70b7a90\"}',0,'2026-01-21 11:58:16',NULL),(250,'{\"config\": \"0be577d3-9c5a-4d36-b5a9-25fc7e2c64ee\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"b6d9ed1d-62f0-4eaf-a42a-e78ed70b7a90\"}',0,'2026-01-21 11:58:16',NULL),(251,'{\"length\": 10}',0,'2026-01-21 11:59:44',NULL);
/*!40000 ALTER TABLE `resource_properties_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(36) NOT NULL,
  `engine_id` varchar(36) NOT NULL,
  `host` varchar(255) NOT NULL,
  `hostname` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `topic` varchar(255) NOT NULL,
  `report_interval` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `engine_id`, `host`, `hostname`, `binary`, `topic`, `report_interval`, `created_at`, `updated_at`, `deleted_at`) VALUES ('2b268524-19eb-4ec4-bf28-ab0b58270d6a','c5928629-527b-45f3-a310-74ec77f85a5f','heat-engine-5bc6fc99dd-nv45v','heat-engine-5bc6fc99dd-nv45v','heat-engine','engine',60,'2026-01-21 11:27:47','2026-01-21 12:17:47',NULL),('4c58afe0-43ae-4360-9144-addc4ac39745','953578df-fbbc-4faf-88a9-c52d77da2d29','heat-engine-656b845fb4-qst2s','heat-engine-656b845fb4-qst2s','heat-engine','engine',60,'2026-01-21 11:27:36','2026-01-21 11:28:11','2026-01-21 11:28:11'),('625c2d87-fe89-4a85-ad91-536db5e6aa09','1982e386-c7c1-4ca3-a2b7-e4831dd5e0cb','heat-engine-5bc6fc99dd-nv45v','heat-engine-5bc6fc99dd-nv45v','heat-engine','engine',60,'2026-01-21 11:27:47','2026-01-21 12:17:47',NULL),('cb1d21da-20af-4db8-9246-70af19a8cd77','eb869577-51a6-48bb-8858-db6c8bcce102','heat-engine-5bc6fc99dd-nv45v','heat-engine-5bc6fc99dd-nv45v','heat-engine','engine',60,'2026-01-21 11:27:47','2026-01-21 12:17:47',NULL),('cc5f6f7a-9b35-4930-ade8-0968536e8913','81e3d276-a85b-4dfc-8d53-7f682eccaffb','heat-engine-656b845fb4-qst2s','heat-engine-656b845fb4-qst2s','heat-engine','engine',60,'2026-01-21 11:27:36','2026-01-21 11:28:11','2026-01-21 11:28:11'),('d33baa2b-f348-4df0-a1f5-fe7224fa0f4c','64411325-31bb-4d82-9782-1b044d963f34','heat-engine-656b845fb4-qst2s','heat-engine-656b845fb4-qst2s','heat-engine','engine',60,'2026-01-21 11:27:35','2026-01-21 11:28:11','2026-01-21 11:28:11'),('e442f04d-d745-4fca-b1a5-e744a967ce07','5c0b86a5-88c7-41f7-9e57-f7aa5987011c','heat-engine-656b845fb4-qst2s','heat-engine-656b845fb4-qst2s','heat-engine','engine',60,'2026-01-21 11:27:36','2026-01-21 11:28:11','2026-01-21 11:28:11'),('fa743b1d-be37-4623-b987-3d4d6742dae3','ef552b71-62e2-4242-867f-03766c8b07c3','heat-engine-5bc6fc99dd-nv45v','heat-engine-5bc6fc99dd-nv45v','heat-engine','engine',60,'2026-01-21 11:27:47','2026-01-21 12:17:47',NULL);
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot`
--

DROP TABLE IF EXISTS `snapshot`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot` (
  `id` varchar(36) NOT NULL,
  `stack_id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` varchar(255) DEFAULT NULL,
  `data` longtext DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stack_id` (`stack_id`),
  KEY `ix_snapshot_tenant` (`tenant`),
  CONSTRAINT `snapshot_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot`
--

LOCK TABLES `snapshot` WRITE;
/*!40000 ALTER TABLE `snapshot` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `software_config`
--

DROP TABLE IF EXISTS `software_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `software_config` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `group` varchar(255) DEFAULT NULL,
  `config` longtext DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_software_config_tenant` (`tenant`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `software_config`
--

LOCK TABLES `software_config` WRITE;
/*!40000 ALTER TABLE `software_config` DISABLE KEYS */;
INSERT INTO `software_config` (`id`, `created_at`, `updated_at`, `name`, `group`, `config`, `tenant`) VALUES ('6a00be84-6e09-4fca-881f-4c0ac39070eb','2026-01-21 11:48:41',NULL,'api-1892183375-config','script','{\"inputs\": [], \"outputs\": [], \"options\": {}, \"config\": \"#!/bin/sh -x\\\\necho hello\"}','6335f7a2d173450c9047bebcdde38d0a'),('bb99c2f0-e7a8-4242-81c5-8c24a6d75692','2026-01-21 11:48:37',NULL,'api-736530183-config','script','{\"inputs\": [], \"outputs\": [], \"options\": {}, \"config\": \"#!/bin/sh -x\\\\necho hello\"}','6335f7a2d173450c9047bebcdde38d0a');
/*!40000 ALTER TABLE `software_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `software_deployment`
--

DROP TABLE IF EXISTS `software_deployment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `software_deployment` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `server_id` varchar(36) NOT NULL,
  `config_id` varchar(36) NOT NULL,
  `input_values` longtext DEFAULT NULL,
  `output_values` longtext DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  `stack_user_project_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `config_id` (`config_id`),
  KEY `ix_software_deployment_created_at` (`created_at`),
  KEY `ix_software_deployment_server_id` (`server_id`),
  KEY `ix_software_deployment_tenant` (`tenant`),
  CONSTRAINT `software_deployment_ibfk_1` FOREIGN KEY (`config_id`) REFERENCES `software_config` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `software_deployment`
--

LOCK TABLES `software_deployment` WRITE;
/*!40000 ALTER TABLE `software_deployment` DISABLE KEYS */;
INSERT INTO `software_deployment` (`id`, `created_at`, `updated_at`, `server_id`, `config_id`, `input_values`, `output_values`, `action`, `status`, `status_reason`, `tenant`, `stack_user_project_id`) VALUES ('1edbb188-1046-4597-8c15-99fbebbf399b','2026-01-21 11:48:41','2026-01-21 11:48:42','dummy_server','6a00be84-6e09-4fca-881f-4c0ac39070eb','{}','null','ACTION1','COMPLETE','completed','6335f7a2d173450c9047bebcdde38d0a',NULL);
/*!40000 ALTER TABLE `software_deployment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack`
--

DROP TABLE IF EXISTS `stack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `raw_template_id` int(11) NOT NULL,
  `prev_raw_template_id` int(11) DEFAULT NULL,
  `user_creds_id` int(11) DEFAULT NULL,
  `username` varchar(256) DEFAULT NULL,
  `owner_id` varchar(36) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `timeout` int(11) DEFAULT NULL,
  `tenant` varchar(256) DEFAULT NULL,
  `disable_rollback` tinyint(1) NOT NULL,
  `stack_user_project_id` varchar(64) DEFAULT NULL,
  `backup` tinyint(1) DEFAULT NULL,
  `nested_depth` int(11) DEFAULT NULL,
  `convergence` tinyint(1) DEFAULT NULL,
  `current_traversal` varchar(36) DEFAULT NULL,
  `current_deps` longtext DEFAULT NULL,
  `parent_resource_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_template_id` (`raw_template_id`),
  KEY `prev_raw_template_id` (`prev_raw_template_id`),
  KEY `user_creds_id` (`user_creds_id`),
  KEY `ix_stack_name` (`name`),
  KEY `ix_stack_owner_id` (`owner_id`),
  KEY `ix_stack_tenant` (`tenant`(255)),
  CONSTRAINT `stack_ibfk_1` FOREIGN KEY (`raw_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `stack_ibfk_2` FOREIGN KEY (`prev_raw_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `stack_ibfk_3` FOREIGN KEY (`user_creds_id`) REFERENCES `user_creds` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack`
--

LOCK TABLES `stack` WRITE;
/*!40000 ALTER TABLE `stack` DISABLE KEYS */;
INSERT INTO `stack` (`id`, `created_at`, `updated_at`, `deleted_at`, `name`, `raw_template_id`, `prev_raw_template_id`, `user_creds_id`, `username`, `owner_id`, `action`, `status`, `status_reason`, `timeout`, `tenant`, `disable_rollback`, `stack_user_project_id`, `backup`, `nested_depth`, `convergence`, `current_traversal`, `current_deps`, `parent_resource_name`) VALUES ('0294945d-6703-4230-98ab-4d690fc3dbc0','2026-01-21 11:56:47','2026-01-21 11:57:21','2026-01-21 11:57:22','ParallelDeploymentsTest-2096988093-dep_2-rxdn3qcwg4t2',210,NULL,NULL,'demo_tempestconf','178a131a-ce79-4ee2-bb62-94a2a0796054','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'996a4594b6c34bc596fa590dc0a5d725',0,1,1,'b4551155-c88e-4a81-aa2b-37c00e8e1ca6','{\"edges\": [[[212, false], null]]}','dep_2'),('02e1c7e0-8bd2-4e3f-86da-ec694a312ed1','2026-01-21 11:51:41','2026-01-21 11:51:48','2026-01-21 11:51:49','ExternalReferencesTest-1822175871',130,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'d8e49b5f741a41efb7dbbb3732e21367',0,0,1,'6e9dd8c0-05e5-41cc-8b5a-368f1551c72c','{\"edges\": [[[139, false], null]]}',NULL),('03b749f2-7523-4278-8861-784c4ebc22e5','2026-01-21 11:56:36','2026-01-21 11:57:39','2026-01-21 11:57:40','ParallelDeploymentsTest-301952452-dep_1-xbabmewwqmyx',220,NULL,NULL,'demo_tempestconf','13987ec4-949c-42d2-baa5-adc025c61eb8','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'6d9f58676951409b84e51e882ef511f8',0,1,1,'c048c534-42e0-46c8-9fc8-61336939ca6b','{\"edges\": [[[196, false], null]]}','dep_1'),('069bb98e-bc45-4668-8bb8-b75cdf63a38b','2026-01-21 11:51:21','2026-01-21 11:51:33','2026-01-21 11:51:34','HooksTest-2071588984-rg-x2kapzuklayt',123,NULL,NULL,'demo_tempestconf','3355e3b4-022a-4e52-8851-ece1bcb4bfc5','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'c68ba029a21444769e68d55cd2f5dde7',0,1,1,'2284381a-9ace-45f1-9479-207151b32f44','{\"edges\": [[[133, false], null], [[134, false], null]]}','rg'),('07d48bd2-c4a6-48f0-b38a-55a48240c4f2','2026-01-21 11:58:00','2026-01-21 11:59:34','2026-01-21 11:59:37','ParallelDeploymentsTest-1801240307',237,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'c029e46453ac4a25a51c0fff1db80d12',0,0,1,'1a0d45ef-2049-4768-916d-45453bf58915','{\"edges\": [[[220, false], null]]}',NULL),('0fc1b119-7102-4fcf-b4ba-7ddd95cc2010','2026-01-21 11:56:35','2026-01-21 11:57:45','2026-01-21 11:57:46','ParallelDeploymentsTest-2113435203-dep_1-nl3oxy2eraww',222,NULL,NULL,'demo_tempestconf','827ee19c-f116-4d62-bf09-2e58e17938e5','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'a6731b2bae82427a880b455378785be2',0,1,1,'b40cac18-2c76-44be-a890-17332299ba89','{\"edges\": [[[187, false], null]]}','dep_1'),('0fc99612-a45e-481b-bc93-1eb90201b6cf','2026-01-21 11:52:55','2026-01-21 11:53:00','2026-01-21 11:53:03','StackTagTest-983706630',154,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'c6dea24d74d24346a97280f615ae645f',0,0,1,'3ad56789-36c3-4e7b-ab12-71a797522d84','{\"edges\": [[[158, false], null]]}',NULL),('1003d0e3-20a6-4f6c-bdb1-2629b35132a3','2026-01-21 11:49:34','2026-01-21 11:49:50','2026-01-21 11:49:54','server_with_sub_ip',68,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'8a80c4c0da5141ecb6f9959abf6ef27d',0,0,1,'78296d9d-3f74-4660-8658-c191d0154835','{\"edges\": [[[64, false], [61, false]], [[62, false], [61, false]], [[63, false], [62, false]]]}',NULL),('12e44383-ac0d-4511-885e-5eaa79aa7756','2026-01-21 11:51:54','2026-01-21 11:52:00','2026-01-21 11:52:01','ExternalReferencesTest-1406052766',136,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'e3cf99fb1f7d4eeb86725e2b46990190',0,0,1,'2708f0b9-0b99-4710-b4f8-ef3abba12450','{\"edges\": [[[140, false], null]]}',NULL),('13987ec4-949c-42d2-baa5-adc025c61eb8','2026-01-21 11:56:36','2026-01-21 11:57:34','2026-01-21 11:57:42','ParallelDeploymentsTest-301952452',215,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'6d9f58676951409b84e51e882ef511f8',0,0,1,'b4e9dfed-fc3b-4ca7-ac33-c43d828099e5','{\"edges\": [[[193, false], [190, false]], [[193, false], [188, false]], [[193, false], [189, false]], [[193, false], [192, false]], [[193, false], [191, false]]]}',NULL),('178a131a-ce79-4ee2-bb62-94a2a0796054','2026-01-21 11:56:46','2026-01-21 11:57:19','2026-01-21 11:57:24','ParallelDeploymentsTest-2096988093',207,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'996a4594b6c34bc596fa590dc0a5d725',0,0,1,'10b2070a-5e2c-45fb-a25a-264e6fce96be','{\"edges\": [[[209, false], [207, false]], [[209, false], [208, false]], [[209, false], [206, false]]]}',NULL),('1a8cd320-745e-420c-8ac3-b3f6ac66f0aa','2026-01-21 11:53:25','2026-01-21 11:53:26','2026-01-21 11:53:26','TemplateAPITest-937944392',163,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'d7037c984b694b13adb44271f89764d3',0,0,1,'365aeefc-7741-4ef1-9510-57a55cade0d6','{\"edges\": [[[163, false], null]]}',NULL),('1b75e245-458b-462b-9bb6-774ec0d13913','2026-01-21 11:55:46','2026-01-21 11:56:10','2026-01-21 11:56:16','swap_subnet_network',177,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'7f526226d5e1462191b48337c6af952b',0,0,1,'e32fdf8d-9eeb-4c60-b5c1-6bc71a705b3a','{\"edges\": [[[175, false], [173, false]], [[175, false], [174, false]], [[174, false], [173, false]]]}',NULL),('202336cd-9078-4183-8bd4-e7a0e6f7bf55','2026-01-21 11:54:34','2026-01-21 11:54:58','2026-01-21 11:55:05','swap_network_port',171,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'0093844eddca45e5bf1e0cdb1ad401a3',0,0,1,'da22f401-2291-48b8-96d2-a9ba8943b764','{\"edges\": [[[169, false], [168, false]], [[168, false], [167, false]]]}',NULL),('2039e3cd-e025-4a9b-8d03-e755306d3b83','2026-01-21 11:50:08','2026-01-21 11:50:24','2026-01-21 11:50:25','RemoteStackTest-842759927-my_stack-i3ilo3gkf3zk',88,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'6335f7a2d173450c9047bebcdde38d0a',1,'7ebdaab16a7046d9b1810de2e144605c',0,0,1,'582a2722-c840-46df-8e31-51fe5828a329','{\"edges\": [[[91, false], null]]}',NULL),('211f7d4b-e422-4e6f-8ef5-f479ac0c0b0f','2026-01-21 11:55:10','2026-01-21 11:55:38','2026-01-21 11:55:43','swap_network_subnet',174,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'b60f91cd489a4ca2bac4bf88d5bbe310',0,0,1,'bb2bae4b-f7b4-4342-bd06-a69cee329881','{\"edges\": [[[172, false], [171, false]], [[171, false], [170, false]]]}',NULL),('21acd278-066f-43a1-a33b-9ceaf407dc2e','2026-01-21 11:56:37','2026-01-21 11:57:37','2026-01-21 11:57:38','ParallelDeploymentsTest-301952452-dep_2-zibtn4kmuwn7',219,NULL,NULL,'demo_tempestconf','13987ec4-949c-42d2-baa5-adc025c61eb8','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'6d9f58676951409b84e51e882ef511f8',0,1,1,'a99fca69-38be-477d-be83-e8f0e24976bb','{\"edges\": [[[197, false], null]]}','dep_2'),('236bc67a-e3b5-46a5-a6b7-40a6167fbd9f','2026-01-21 11:56:35','2026-01-21 11:57:48','2026-01-21 11:57:49','ParallelDeploymentsTest-2113435203-dep_0-7tgcbpbbur7m',225,NULL,NULL,'demo_tempestconf','827ee19c-f116-4d62-bf09-2e58e17938e5','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'a6731b2bae82427a880b455378785be2',0,1,1,'f2dc5185-836f-4071-880f-25e8f3a43571','{\"edges\": [[[183, false], null]]}','dep_0'),('2775bcdb-7752-4db2-b0c0-132c2db0ac3d','2026-01-21 11:56:49','2026-01-21 11:57:10','2026-01-21 11:57:11','ParallelDeploymentsTest-125988841-dep_0-l3zl7pnvvcf4',204,NULL,NULL,'demo_tempestconf','dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'c553a8b5c9d04925b4bc723194566ec9',0,1,1,'ad0bef3c-5612-4793-9a66-ba422396818c','{\"edges\": [[[217, false], null]]}','dep_0'),('2c704a7d-00e4-4953-a7e6-24ed6a857da0','2026-01-21 11:52:45','2026-01-21 11:53:10','2026-01-21 11:53:15','same_fixed_ip',157,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'282856f165974f59af8ec95def113cc0',0,0,1,'9b083b69-f131-4f1e-a753-ce9c73f5ae4b','{\"edges\": [[[157, false], [156, false]], [[157, false], [155, false]], [[156, false], [155, false]]]}',NULL),('2f7aa387-a933-49b3-9dae-b1c258a5c26e','2026-01-21 11:49:37','2026-01-21 11:49:49','2026-01-21 11:49:51','UpdateSubnetTest-1118526834',67,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'5ee0aa036559426788d4575aa6e3e86b',0,0,1,'45871188-a04c-4511-b2fb-4b071890967a','{\"edges\": [[[68, false], [67, false]]]}',NULL),('3355e3b4-022a-4e52-8851-ece1bcb4bfc5','2026-01-21 11:51:21','2026-01-21 11:51:32','2026-01-21 11:51:35','HooksTest-2071588984',122,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'c68ba029a21444769e68d55cd2f5dde7',0,0,1,'1edfd601-4f3e-4ef3-a0cb-6e4a7b90d0b0','{\"edges\": [[[132, false], null]]}',NULL),('339ac678-d09b-40f7-aa91-2b81781b6554','2026-01-21 11:53:05','2026-01-21 11:53:19','2026-01-21 11:53:22','StackTagTest-435937917',160,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'f8977d7d4d4342c18240ae34a16fe35d',0,0,1,'9cd3b262-814c-4a78-8662-ab3e61487f85','{\"edges\": [[[159, false], null]]}',NULL),('38523b7b-7e98-41c7-a395-896f117d20cc','2026-01-21 11:56:47','2026-01-21 11:57:20','2026-01-21 11:57:22','ParallelDeploymentsTest-2096988093-dep_0-fg7gck55feyd',209,NULL,NULL,'demo_tempestconf','178a131a-ce79-4ee2-bb62-94a2a0796054','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'996a4594b6c34bc596fa590dc0a5d725',0,1,1,'ac572077-1c94-4320-90d4-d2baa46f21cc','{\"edges\": [[[211, false], null]]}','dep_0'),('38aad380-1fb2-4b3d-a021-fe517820438c','2026-01-21 11:49:48','2026-01-21 11:50:03','2026-01-21 11:50:03','RemoteStackTest-763348251-my_stack-kbzkiri4q7ts',74,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'6335f7a2d173450c9047bebcdde38d0a',1,'bf3877701a2f48ae9709ee97bbb7cce7',0,0,1,'16c5e9c4-51e6-42b1-97ed-37f0fd75d2ef','{\"edges\": [[[70, false], null]]}',NULL),('38dfaedd-5ab8-4310-8eeb-ed650e0d43ef','2026-01-21 11:50:27','2026-01-21 11:50:33','2026-01-21 11:50:34','HooksTest-1789230450',92,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'80635150a05344f994768dfd5d01e1b2',0,0,1,'413469ba-281f-4ba4-acdb-26614d9ed763','{\"edges\": [[[103, false], [102, false]], [[104, false], [103, false]]]}',NULL),('437ee61a-e4be-4a47-b741-ce15891367c9','2026-01-21 11:49:58','2026-01-21 11:50:18','2026-01-21 11:50:22','UpdateTrunkTest-408612344',84,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'e42d7f5cedbd4edc9c0d41618cf2037b',0,0,1,'7e28f9f8-2f5a-49ff-9868-e445d02202dc','{\"edges\": [[[75, false], [73, false]], [[74, false], [73, false]], [[80, false], [74, false]], [[80, false], [79, false]], [[79, false], [74, false]], [[78, false], [77, false]], [[78, false], [75, false]], [[77, false], [75, false]], [[82, false], [81, false]], [[82, false], [76, false]], [[81, false], [76, false]]]}',NULL),('49b2775c-7eb4-4372-8d12-d36b21230b6f','2026-01-21 11:58:15','2026-01-21 11:59:24','2026-01-21 11:59:26','ParallelDeploymentsTest-678810249-dep_2-hkjvd7k7z5xg',234,NULL,NULL,'demo_tempestconf','583fccda-82d0-4453-a7eb-b69b1e858b36','DELETE','COMPLETE','Stack DELETE completed successfully',1,'6335f7a2d173450c9047bebcdde38d0a',1,'f031647957494af6a20f295978d4d8d4',0,1,1,'a7c18697-1246-4ca7-a59d-eda66795d1c3','{\"edges\": [[[226, false], null]]}','dep_2'),('4d407931-8eea-444e-880e-21e6f15b7a60','2026-01-21 11:56:36','2026-01-21 11:57:34','2026-01-21 11:57:35','ParallelDeploymentsTest-301952452-dep_3-zff3ak6gzvaf',216,NULL,NULL,'demo_tempestconf','13987ec4-949c-42d2-baa5-adc025c61eb8','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'6d9f58676951409b84e51e882ef511f8',0,1,1,'d79ce7a2-c7bf-4588-81d0-2cde820253e7','{\"edges\": [[[195, false], null]]}','dep_3'),('4f10c6b8-0472-4108-b086-fd59f41f35b5','2026-01-21 11:48:42','2026-01-21 11:48:45',NULL,'api-736530183-stack',23,NULL,9,'demo_tempestconf',NULL,'UPDATE','COMPLETE','Stack UPDATE completed successfully',NULL,'6335f7a2d173450c9047bebcdde38d0a',1,'c745d612611a4641a5e0169f09f4ba2d',0,0,1,'2a1a352c-7995-40dd-99ac-bac2ca5d2dd5','{\"edges\": [[[7, false], [7, true]]]}',NULL),('51c122a5-cd4c-47b0-acd5-17a455f5297b','2026-01-21 11:50:44','2026-01-21 11:50:52','2026-01-21 11:50:53','RemoteDeeplyNestedStackTest-1211336967-network_stack-t6x4ia43xeu7-network_stack_as_custom_type-cojyn4b3zxfb',110,NULL,NULL,'demo_tempestconf','92ea70b7-aaa0-4c63-b2ed-116941755760','DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'6335f7a2d173450c9047bebcdde38d0a',1,'d95a0ef37ecd4adcb4b22599e0f4ca42',0,1,1,'d92d31d4-3cbd-460d-a94a-c75ac03552d5','{\"edges\": [[[116, false], null]]}','network_stack_as_custom_type'),('52709945-6920-4b5c-a6b3-87373cdb9b8d','2026-01-21 11:48:40','2026-01-21 11:48:41','2026-01-21 11:48:42','api-2116806331-empty',10,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'6335f7a2d173450c9047bebcdde38d0a',1,'f381750732d849b5b3215af5e5deb710',0,0,1,'462907ff-18e0-44a2-bb68-f57553d0789b','{\"edges\": []}',NULL),('5439694a-2a97-4221-8138-18cd70a88942','2026-01-21 11:49:34','2026-01-21 11:49:49','2026-01-21 11:49:54','UpdateTrunkTest-575895988',66,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'51e327c71fdb4f73b35d14c8b6304789',0,0,1,'baf1fb41-3370-417c-b219-7b5ae3bc8c0d','{\"edges\": [[[53, false], [51, false]], [[57, false], [56, false]], [[57, false], [52, false]], [[56, false], [52, false]], [[55, false], [53, false]], [[55, false], [54, false]], [[54, false], [53, false]], [[60, false], [58, false]], [[60, false], [59, false]], [[59, false], [58, false]]]}',NULL),('54e07fe7-ef07-41da-83d1-c46060ca2fd0','2026-01-21 11:48:40','2026-01-21 11:48:41','2026-01-21 11:48:42','api-736530183-empty',12,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'6335f7a2d173450c9047bebcdde38d0a',1,'1871dbcd46e54ad3a249c3df4e206da2',0,0,1,'aee3b87a-34b9-4d77-9b92-1fbb19819d61','{\"edges\": []}',NULL),('55dbaf3b-ca7a-4249-8532-32591a78c378','2026-01-21 11:59:43','2026-01-21 11:59:44','2026-01-21 11:59:45','StackUnicodeTemplateTest-2029350488',239,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'744b0e8f38414feda7e1b025a7334ec5',0,0,1,'7c2c7469-3755-4239-964b-090c00ab2939','{\"edges\": [[[228, false], null]]}',NULL),('583fccda-82d0-4453-a7eb-b69b1e858b36','2026-01-21 11:58:15','2026-01-21 11:59:24','2026-01-21 11:59:30','ParallelDeploymentsTest-678810249',233,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1,'6335f7a2d173450c9047bebcdde38d0a',1,'f031647957494af6a20f295978d4d8d4',0,0,1,'aa541a09-2a3f-46c5-8f37-c7d219f85df1','{\"edges\": [[[224, false], [221, false]], [[224, false], [222, false]], [[224, false], [223, false]]]}',NULL),('58fc8ddd-3677-4a8a-a759-27fd0c26425f','2026-01-21 11:56:36','2026-01-21 11:57:35','2026-01-21 11:57:36','ParallelDeploymentsTest-301952452-dep_4-bsszwontpt7g',217,NULL,NULL,'demo_tempestconf','13987ec4-949c-42d2-baa5-adc025c61eb8','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'6d9f58676951409b84e51e882ef511f8',0,1,1,'abfcd814-ca78-428b-b92b-761659a2acb5','{\"edges\": [[[198, false], null]]}','dep_4'),('594f2d7d-226c-4a0f-82ee-b60214d287ba','2026-01-21 11:51:55','2026-01-21 11:52:03','2026-01-21 11:52:06','HooksTest-1654173811',137,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'739abf3c45b24f578276d589e4991ac9',0,0,1,'9854a3ca-1728-4203-87ba-e5c6180baa99','{\"edges\": [[[143, false], [144, false]], [[141, false], null]]}',NULL),('5968210c-61dd-41e0-9ccc-cc2eed2e9966','2026-01-21 11:52:06','2026-01-21 11:52:33','2026-01-21 11:52:40','add_network',147,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'e732906f395d404297d72bd7832f5526',0,0,1,'c9fdbc72-ac86-47bd-859f-ec94ab34f4f7','{\"edges\": [[[147, false], [145, false]], [[147, false], [146, false]], [[146, false], [145, false]]]}',NULL),('59903018-4f7f-4406-93e4-9a5df11e0c9a','2026-01-21 11:50:38','2026-01-21 11:50:50','2026-01-21 11:50:51','HooksTest-1354691914',105,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'0c86fc59a0e34c209946759020015604',0,0,1,'29bce0a1-769f-40e9-940d-1b35ba8c3604','{\"edges\": [[[109, false], null]]}',NULL),('5d7eda9e-81f7-4021-beda-f9db9e7058a7','2026-01-21 11:50:24','2026-01-21 11:50:43','2026-01-21 11:50:48','UpdateTrunkTest-1549168250',102,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'70b2cf9fe9c145dfab1263390975d5a9',0,0,1,'6975a385-c1ac-41b6-a0d8-6f0ae127909f','{\"edges\": [[[94, false], [92, false]], [[93, false], [92, false]], [[98, false], [97, false]], [[98, false], [93, false]], [[97, false], [93, false]], [[96, false], [94, false]], [[96, false], [95, false]], [[95, false], [94, false]], [[101, false], [99, false]], [[101, false], [100, false]], [[100, false], [99, false]]]}',NULL),('5e0b5b52-dabc-41c9-9124-d353e5de592b','2026-01-21 11:50:55','2026-01-21 11:51:16','2026-01-21 11:51:16','HooksTest-29776859',114,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'2bb711701f9649ec9bae2aa9a8172e1a',0,0,1,'6b1c8ffa-c041-405b-9814-1bd220f20b43','{\"edges\": [[[129, false], [128, false]], [[128, false], [127, false]]]}',NULL),('60c9f6be-9f4d-41c8-ba88-fe804e066c78','2026-01-21 11:50:42','2026-01-21 11:50:51','2026-01-21 11:50:54','RemoteDeeplyNestedStackTest-1211336967',107,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'e9ac463bd1d545bd95388250a1d2cb85',0,0,1,'acce2a61-8a59-49f2-a38d-091311b6c89d','{\"edges\": [[[114, false], null]]}',NULL),('6148d142-290b-423e-b02d-7372ca81b44c','2026-01-21 11:49:36','2026-01-21 11:49:41','2026-01-21 11:49:41','RemoteStackTest-1644753654-my_stack-cmnjnuuv4kub',61,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'6335f7a2d173450c9047bebcdde38d0a',1,'469c0172b8c646eb9e0f87dc04f4ad5e',0,0,1,'58c8c1ad-69eb-4628-af5d-11b73a68bd4c','{\"edges\": [[[66, false], null]]}',NULL),('6268584d-cf69-44cb-bdf0-9d8f6bd81b57','2026-01-21 11:48:40',NULL,NULL,'api-485390504-rsrcstack',7,NULL,7,'demo_tempestconf',NULL,'CREATE','COMPLETE','Stack CREATE completed successfully',NULL,'6335f7a2d173450c9047bebcdde38d0a',1,'f430a92690954625b63dbd9ab646bc2c',0,0,1,'51dc136b-41d5-48e5-802c-f8cac1fc3a64','{\"edges\": [[[5, true], null]]}',NULL),('6674648f-cf2c-44b1-b17e-af096ff84242','2026-01-21 11:48:43','2026-01-21 11:48:44','2026-01-21 11:48:45','api-1892183375-empty',18,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'6335f7a2d173450c9047bebcdde38d0a',1,'5a3ffe6db04b4403b47ee861e42545bc',0,0,1,'5493551a-fcd5-44fc-a912-729b48673526','{\"edges\": []}',NULL),('67276495-f395-43ca-a615-65805149eefd','2026-01-21 11:48:36','2026-01-21 11:48:36','2026-01-21 11:48:37','api-736530183-envstack',5,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'6335f7a2d173450c9047bebcdde38d0a',1,'99d969b39a2d4c5eb9b1a7cc74798f30',0,0,1,'90127353-1a7d-4f96-afbb-889094c2927f','{\"edges\": [[[4, false], null]]}',NULL),('67d0c244-c3d1-431e-8c3b-b008ec050d70','2026-01-21 11:52:30','2026-01-21 11:52:36','2026-01-21 11:52:38','StackOutputsTest-223675962',148,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'8bf31717d740468c827d4c961f40b50b',0,0,1,'bdd22e76-c3b1-4db1-898c-8df7a43909a8','{\"edges\": [[[151, false], null], [[152, false], null]]}',NULL),('6c038782-44a6-4f1a-a6e0-4827cc803bc3','2026-01-21 11:49:22','2026-01-21 11:49:33','2026-01-21 11:49:34','UpdateSubnetTest-368818728',54,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'389a9d75183b423aa93fed80ea42edfc',0,0,1,'12e403ec-1235-4d86-8592-ab13f0f5e296','{\"edges\": [[[49, false], [48, false]]]}',NULL),('6e2b1add-2f56-4b2a-a2e7-b48b258eb3e3','2026-01-21 11:50:10','2026-01-21 11:50:21','2026-01-21 11:50:23','UpdateSubnetTest-1034942007',85,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'f7be73b0e9b54a55855357d7472d15f7',0,0,1,'90218624-bebc-4c49-b000-3df37e22b866','{\"edges\": [[[90, false], [89, false]]]}',NULL),('6f75ad05-2e01-411d-b127-da7968e32873','2026-01-21 11:50:36','2026-01-21 11:50:37','2026-01-21 11:50:37','ResourcesList-1955174437',96,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'d95126f2e37c46da822d2f0fb4e57d0d',0,0,1,'3f80e289-b4cf-4556-993a-990b433b8010','{\"edges\": [[[108, false], [107, false]]]}',NULL),('73c75274-23fe-4304-afa9-7f421c5e396c','2026-01-21 11:56:49','2026-01-21 11:57:11','2026-01-21 11:57:12','ParallelDeploymentsTest-125988841-dep_2-okv2ldgsvg7p',205,NULL,NULL,'demo_tempestconf','dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'c553a8b5c9d04925b4bc723194566ec9',0,1,1,'1baa32e1-6ca9-49c9-a7fa-9e63c5303b6a','{\"edges\": [[[218, false], null]]}','dep_2'),('75aa1f8b-2bc3-4ad5-b440-9654060c77dd','2026-01-21 11:56:20','2026-01-21 11:57:54','2026-01-21 11:57:57','ParallelDeploymentsTest-100537633',227,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'46333260ec0843d8aa5cb148eaa91036',0,0,1,'2e040030-1825-4184-bc26-0a67eb97000d','{\"edges\": [[[176, false], null]]}',NULL),('768e741e-9b75-4382-838e-d927c997a82a','2026-01-21 11:56:46','2026-01-21 11:57:32','2026-01-21 11:57:32','ParallelDeploymentsTest-1866873809-dep_0-mgo3wzakbg2x',214,NULL,NULL,'demo_tempestconf','7925f319-fd76-4c59-9868-414fbb354c71','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'610a29a4a80e425f83879dc98f2c9676',0,1,1,'37162bcc-3d3d-47d9-ac73-a6c5e93ce2c4','{\"edges\": [[[203, false], null]]}','dep_0'),('7925f319-fd76-4c59-9868-414fbb354c71','2026-01-21 11:56:45','2026-01-21 11:57:29','2026-01-21 11:57:34','ParallelDeploymentsTest-1866873809',211,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'610a29a4a80e425f83879dc98f2c9676',0,0,1,'e704c0f5-6e61-4487-be17-3923f326692c','{\"edges\": [[[202, false], [199, false]], [[202, false], [200, false]], [[202, false], [201, false]]]}',NULL),('7c8a47da-b70c-465c-8524-7bc7ecd81aa8','2026-01-21 11:56:35','2026-01-21 11:57:46','2026-01-21 11:57:47','ParallelDeploymentsTest-2113435203-dep_4-igyerhnpcpyu',224,NULL,NULL,'demo_tempestconf','827ee19c-f116-4d62-bf09-2e58e17938e5','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'a6731b2bae82427a880b455378785be2',0,1,1,'bfbf5294-9068-454d-a3e0-a9a0c06c1de2','{\"edges\": [[[186, false], null]]}','dep_4'),('7cebc90a-b5fa-4bc5-b106-bd24443762cf','2026-01-21 11:52:10','2026-01-21 11:52:20','2026-01-21 11:52:21','StackOutputsTest-1064902002-parent-epryjjowwecd',144,NULL,NULL,'demo_tempestconf','9afef6c4-848e-486f-9d8b-33162651be74','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'799709ec49d34ad4a0580ff7dfa95c94',0,1,1,'92d4a1be-78c8-4184-89d6-3de96e335ec0','{\"edges\": [[[150, false], null], [[149, false], null]]}','parent'),('7cf68aa3-10a1-4ffc-8f40-9a7889af38a2','2026-01-21 11:56:46','2026-01-21 11:57:31','2026-01-21 11:57:32','ParallelDeploymentsTest-1866873809-dep_1-kwk4zudk72bz',213,NULL,NULL,'demo_tempestconf','7925f319-fd76-4c59-9868-414fbb354c71','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'610a29a4a80e425f83879dc98f2c9676',0,1,1,'8213b5a5-aa22-41be-b37d-579597207baa','{\"edges\": [[[205, false], null]]}','dep_1'),('827ee19c-f116-4d62-bf09-2e58e17938e5','2026-01-21 11:56:35','2026-01-21 11:57:44','2026-01-21 11:57:50','ParallelDeploymentsTest-2113435203',221,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'a6731b2bae82427a880b455378785be2',0,0,1,'cd4433e7-3cc5-4131-8af5-d2b2129ab538','{\"edges\": [[[182, false], [181, false]], [[182, false], [179, false]], [[182, false], [177, false]], [[182, false], [180, false]], [[182, false], [178, false]]]}',NULL),('87791753-832b-4e25-bdb8-97a4781e4260','2026-01-21 11:48:35',NULL,NULL,'api-485390504-envstack',2,NULL,2,'demo_tempestconf',NULL,'CREATE','COMPLETE','Stack CREATE completed successfully',NULL,'6335f7a2d173450c9047bebcdde38d0a',1,'93a27d5377f84dd6b3137ee4b4106e6b',0,0,1,'9133ab42-4bc8-4ce6-957a-f87a7292b3b1','{\"edges\": [[[1, true], null]]}',NULL),('887daa38-49b9-481a-b495-1489c0632c6e','2026-01-21 11:58:15','2026-01-21 11:59:25','2026-01-21 11:59:26','ParallelDeploymentsTest-678810249-dep_1-455bzdgsccg7',235,NULL,NULL,'demo_tempestconf','583fccda-82d0-4453-a7eb-b69b1e858b36','DELETE','COMPLETE','Stack DELETE completed successfully',1,'6335f7a2d173450c9047bebcdde38d0a',1,'f031647957494af6a20f295978d4d8d4',0,1,1,'2dfac513-6c4c-42d9-af6c-3a2911382fef','{\"edges\": [[[227, false], null]]}','dep_1'),('8e7f35e3-6de2-4d40-ae21-5912ea3a8986','2026-01-21 11:48:44','2026-01-21 11:48:46',NULL,'api-1892183375-stack',24,NULL,12,'demo_tempestconf',NULL,'UPDATE','COMPLETE','Stack UPDATE completed successfully',NULL,'6335f7a2d173450c9047bebcdde38d0a',1,'ac0270e4243944058b784b3888f21549',0,0,1,'60484a39-6be6-46dd-9e1a-45a2b5218ca9','{\"edges\": [[[8, false], [8, true]]]}',NULL),('9036f089-1726-4db1-9174-bbe9cc6810a2','2026-01-21 11:48:51','2026-01-21 11:49:02','2026-01-21 11:49:04','UpdateSubnetTest-1304445430',36,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'79718884f1574663b42f1607411a8534',0,0,1,'c718b5e0-d477-4aed-a085-658297239d80','{\"edges\": [[[11, false], [10, false]]]}',NULL),('90b49099-672c-4cef-aa9b-a4c5f809f1db','2026-01-21 11:56:35','2026-01-21 11:57:45','2026-01-21 11:57:46','ParallelDeploymentsTest-2113435203-dep_3-ly2wln4m4uz2',223,NULL,NULL,'demo_tempestconf','827ee19c-f116-4d62-bf09-2e58e17938e5','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'a6731b2bae82427a880b455378785be2',0,1,1,'30c5e9e5-456e-4d5e-ab7b-f4ba918d9859','{\"edges\": [[[185, false], null]]}','dep_3'),('9198ff61-9b07-4021-90de-0b7fac23b80d','2026-01-21 11:48:42','2026-01-21 11:48:51','2026-01-21 11:48:52','api-2116806331-stack',30,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'6335f7a2d173450c9047bebcdde38d0a',1,'5c171884aebe420db059128289383827',0,0,1,'3264131a-587d-4a8a-9b9e-9793ec2ba1ff','{\"edges\": [[[6, false], null]]}',NULL),('92ea70b7-aaa0-4c63-b2ed-116941755760','2026-01-21 11:50:43','2026-01-21 11:50:52','2026-01-21 11:50:53','RemoteDeeplyNestedStackTest-1211336967-network_stack-t6x4ia43xeu7',108,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'6335f7a2d173450c9047bebcdde38d0a',1,'d95a0ef37ecd4adcb4b22599e0f4ca42',0,0,1,'c67d358f-638e-487d-8d74-c9668755efe8','{\"edges\": [[[115, false], null]]}',NULL),('969ba6aa-41c3-4805-baa6-2d988a0767d9','2026-01-21 11:48:51','2026-01-21 11:49:01','2026-01-21 11:49:04','UpdatePortTest-250805131',35,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'5f6e0f5219474375a17c3c059516b485',0,0,1,'d750c4f4-6eb4-4b42-9223-4e5ce52188a5','{\"edges\": [[[13, false], [12, false]], [[15, false], [13, false]], [[15, false], [14, false]], [[14, false], [13, false]]]}',NULL),('99b9b78a-e606-4a1c-b7e6-a4504566e32a','2026-01-21 11:50:41','2026-01-21 11:50:43','2026-01-21 11:50:44','StackEventsTest-803524309',103,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'73598e79f7434d0ebf6e01c652aeb08b',0,0,1,'2281778d-9226-4269-baf2-76942b694bd3','{\"edges\": [[[113, false], null]]}',NULL),('9afef6c4-848e-486f-9d8b-33162651be74','2026-01-21 11:52:09','2026-01-21 11:52:20','2026-01-21 11:52:26','StackOutputsTest-1064902002',143,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'799709ec49d34ad4a0580ff7dfa95c94',0,0,1,'089c9dbf-b00c-4006-b0a7-c6dc59de5d82','{\"edges\": [[[148, false], null]]}',NULL),('a09fb5bd-6204-4fac-b2ea-0624f40a5b0d','2026-01-21 11:48:54','2026-01-21 11:49:07','2026-01-21 11:49:09','EncryptedParametersTest-859287547',40,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'80ef1944f45f48c4bfa5901371ee1b08',0,0,1,'d3cbb0dc-a97e-4e13-a0eb-ab2d86d30b20','{\"edges\": [[[26, false], null]]}',NULL),('a1bf221f-f68f-4027-9fb0-2173e5749a38','2026-01-21 11:51:34','2026-01-21 11:51:35','2026-01-21 11:51:36','ExternalReferencesTest-1721981834',125,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'71241249dcef4993bbfa4b3140ff8ce2',0,0,1,'3957baf2-0117-4118-bfc3-f5d54a6b90e0','{\"edges\": [[[135, false], null]]}',NULL),('a1f99d50-aa51-4cad-9b96-faac6562e7a6','2026-01-21 11:48:46','2026-01-21 11:48:50',NULL,'api-485390504-stack',26,NULL,13,'demo_tempestconf',NULL,'UPDATE','COMPLETE','Stack UPDATE completed successfully',NULL,'6335f7a2d173450c9047bebcdde38d0a',1,'f1da49f947fa47129529e647efc944cd',0,0,1,'228f887e-c1d6-491f-a61c-8fd778dd2567','{\"edges\": [[[9, false], [9, true]]]}',NULL),('a87a1013-5151-4078-b161-7cd0d1f2732e','2026-01-21 11:49:07','2026-01-21 11:49:21','2026-01-21 11:49:25','UpdatePortTest-1874336544',47,NULL,NULL,'admin',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'8d6df07ed5c54b3ebd7550a0bf0138aa',1,'1a06037a8b20464d9e3729f179f03e85',0,0,1,'769cbd7b-0050-49d8-8080-60192be11bbe','{\"edges\": [[[27, false], null], [[29, false], [47, false]], [[30, false], [47, false]], [[30, false], [29, false]]]}',NULL),('aa5fe92b-0d83-4605-ac05-6096edf46c87','2026-01-21 11:49:12','2026-01-21 11:49:29','2026-01-21 11:49:33','server_with_port',52,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'b3a9a25418534dab9fd1db401e5e2210',0,0,1,'487448fe-62df-4b82-be26-360d6dc61ae6','{\"edges\": [[[45, false], [44, false]], [[45, false], [43, false]], [[44, false], [43, false]], [[46, false], [44, false]], [[46, false], [45, false]]]}',NULL),('aed69e16-a140-42ad-a0f1-c75066c446bb','2026-01-21 11:51:39','2026-01-21 11:51:49','2026-01-21 11:51:50','HooksTest-419121912',131,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'97011fdccc964b358d60838e79b037ba',0,0,1,'1a14df83-777b-4e2e-8ba0-2788b0c839e0','{\"edges\": [[[138, false], [137, false]], [[137, false], [136, false]]]}',NULL),('b338b76c-9675-4bf8-b895-c4c328d3d3f1','2026-01-21 11:53:20','2026-01-21 11:53:48','2026-01-21 11:53:51','add_subnet',165,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'f5226b34b8484c568c8a3930740f7736',0,0,1,'7f6a39b6-bff6-4a0a-810a-e5b996d16780','{\"edges\": [[[162, false], [161, false]], [[162, false], [160, false]], [[161, false], [160, false]]]}',NULL),('b483ae4a-d046-41f1-8621-671b02bbc747','2026-01-21 11:56:35','2026-01-21 11:57:48','2026-01-21 11:57:49','ParallelDeploymentsTest-2113435203-dep_2-mlh47nro7bwk',226,NULL,NULL,'demo_tempestconf','827ee19c-f116-4d62-bf09-2e58e17938e5','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'a6731b2bae82427a880b455378785be2',0,1,1,'0a4b2288-e299-49f3-95ba-33f3c88059ba','{\"edges\": [[[184, false], null]]}','dep_2'),('b6cf8cab-9fd7-4409-90b4-24e91be8a8d4','2026-01-21 11:48:44','2026-01-21 11:48:45','2026-01-21 11:48:46','api-485390504-empty',20,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'6335f7a2d173450c9047bebcdde38d0a',1,'ca11ec1f8a414479ba85d11be2151393',0,0,1,'1c7bbc91-66da-450f-8210-20c0372feb0a','{\"edges\": []}',NULL),('bbd1ce7e-39ea-4ea2-96ad-edfd62e07da1','2026-01-21 11:56:46','2026-01-21 11:57:29','2026-01-21 11:57:30','ParallelDeploymentsTest-1866873809-dep_2-aye4jz7qukex',212,NULL,NULL,'demo_tempestconf','7925f319-fd76-4c59-9868-414fbb354c71','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'610a29a4a80e425f83879dc98f2c9676',0,1,1,'7126490d-e64f-46db-80fd-6e8db860e089','{\"edges\": [[[204, false], null]]}','dep_2'),('c9dd4243-191a-4a39-8267-073b47cef24a','2026-01-21 11:49:11','2026-01-21 11:49:29','2026-01-21 11:49:32','UpdateTrunkTest-219271161',51,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'395784ea071849f1bbbe0a420c672792',0,0,1,'fcc157b9-65e2-49fe-bd39-e4b7d468399b','{\"edges\": [[[38, false], [33, false]], [[34, false], [33, false]], [[36, false], [34, false]], [[36, false], [35, false]], [[35, false], [34, false]], [[42, false], [37, false]], [[42, false], [41, false]], [[41, false], [37, false]], [[40, false], [39, false]], [[40, false], [38, false]], [[39, false], [38, false]]]}',NULL),('cb36b365-7a1d-4fe1-bc43-ac090d0aecde','2026-01-21 11:48:36',NULL,NULL,'api-2116806331-rsrcstack',3,NULL,3,'demo_tempestconf',NULL,'CREATE','COMPLETE','Stack CREATE completed successfully',NULL,'6335f7a2d173450c9047bebcdde38d0a',1,'505333bddf064d27acc4924fede5fa25',0,0,1,'1e210693-1bc7-46d8-be0f-7e29f87cb77b','{\"edges\": [[[3, true], null]]}',NULL),('cdcc3a60-4faa-4773-973d-f221a24e87ae','2026-01-21 11:52:41','2026-01-21 11:52:49','2026-01-21 11:52:50','StackOutputsTest-168968450',152,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'b03cfbb5962d4ef7acbc7604561a1fd1',0,0,1,'36d73a25-0af7-4455-868c-883b37a32704','{\"edges\": [[[153, false], [154, false]]]}',NULL),('d155e912-e8d7-4f5e-b5e6-dd54eb04baf6','2026-01-21 11:50:52','2026-01-21 11:51:10','2026-01-21 11:51:15','UpdateTrunkTest-1824116201',113,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'0edbd1f49ab04db486cbcfa9d8181921',0,0,1,'b75bb60f-7857-4f20-82a9-916509e1ea0d','{\"edges\": [[[118, false], [117, false]], [[120, false], [118, false]], [[120, false], [119, false]], [[119, false], [118, false]], [[126, false], [121, false]], [[126, false], [125, false]], [[125, false], [121, false]], [[124, false], [123, false]], [[124, false], [122, false]], [[123, false], [122, false]]]}',NULL),('d20ca28a-624b-41b3-96e7-a3e77927a0cf','2026-01-21 11:48:35','2026-01-21 11:48:40','2026-01-21 11:48:41','api-1892183375-rsrcstack',9,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'6335f7a2d173450c9047bebcdde38d0a',1,'c64ed9258b1047a5ab2ae4eb51d09854',0,0,1,'09ef336a-d26f-4c74-8666-bd7e51610515','{\"edges\": [[[2, false], null]]}',NULL),('d2910e40-27de-491e-84bb-455bd2056f13','2026-01-21 11:49:29','2026-01-21 11:49:30','2026-01-21 11:49:30','RemoteStackTest-2126207766',53,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'852502748f0c4646bb8bafc34c76c1a6',0,0,1,'a5c1e77a-0333-4fae-a8ff-ac55f9a3e099','{\"edges\": [[[50, false], null]]}',NULL),('d88a5c8d-92b2-4324-bf8a-d57bbbac839a','2026-01-21 11:51:16','2026-01-21 11:51:27','2026-01-21 11:51:28','EncryptionVolTypeTest-1636502822',120,NULL,NULL,'admin',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'8d6df07ed5c54b3ebd7550a0bf0138aa',1,'9ed73464653a4d1480f04956ffb548b4',0,0,1,'500a38c7-6d43-4daf-8cd9-42ff87b40101','{\"edges\": [[[131, false], [130, false]]]}',NULL),('db0d8406-58f5-4eb8-bc97-33536064c0b9','2026-01-21 11:49:07','2026-01-21 11:49:17','2026-01-21 11:49:19','UpdateSubnetTest-122967512',45,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'28df6f5702df4ed59a18142b0f802a12',0,0,1,'47dcfd6a-c48d-4645-b502-b42f46952747','{\"edges\": [[[32, false], [31, false]]]}',NULL),('dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','2026-01-21 11:56:48','2026-01-21 11:57:10','2026-01-21 11:57:15','ParallelDeploymentsTest-125988841',203,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'c553a8b5c9d04925b4bc723194566ec9',0,0,1,'02c2d4cc-62c2-4fa1-8284-00bc3b55dccb','{\"edges\": [[[216, false], [215, false]], [[216, false], [213, false]], [[216, false], [214, false]]]}',NULL),('dd905c26-f0e4-4a6d-8899-67dc446009ed','2026-01-21 11:56:36','2026-01-21 11:57:36','2026-01-21 11:57:37','ParallelDeploymentsTest-301952452-dep_0-by5sjpmxhjke',218,NULL,NULL,'demo_tempestconf','13987ec4-949c-42d2-baa5-adc025c61eb8','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'6d9f58676951409b84e51e882ef511f8',0,1,1,'c2b539e6-3dbc-4ee0-9450-ca0428b9aad2','{\"edges\": [[[194, false], null]]}','dep_0'),('e7e2e1d3-7821-48bb-98ed-a65003138bee','2026-01-21 11:58:15','2026-01-21 11:59:26','2026-01-21 11:59:28','ParallelDeploymentsTest-678810249-dep_0-7aqo4akkstd2',236,NULL,NULL,'demo_tempestconf','583fccda-82d0-4453-a7eb-b69b1e858b36','DELETE','COMPLETE','Stack DELETE completed successfully',1,'6335f7a2d173450c9047bebcdde38d0a',1,'f031647957494af6a20f295978d4d8d4',0,1,1,'d1dc9bda-a15d-423e-80e1-f2fc0066bb2d','{\"edges\": [[[225, false], null]]}','dep_0'),('ec836e4b-c437-4849-8199-b6e01e5c729a','2026-01-21 11:56:47','2026-01-21 11:57:19','2026-01-21 11:57:20','ParallelDeploymentsTest-2096988093-dep_1-akxfm7rpww5j',208,NULL,NULL,'demo_tempestconf','178a131a-ce79-4ee2-bb62-94a2a0796054','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'996a4594b6c34bc596fa590dc0a5d725',0,1,1,'a549846b-324e-4986-9c6f-6817cb75121f','{\"edges\": [[[210, false], null]]}','dep_1'),('ec97ad01-1c3d-4447-954d-7fd960a76124','2026-01-21 11:50:08','2026-01-21 11:50:24','2026-01-21 11:50:25','RemoteStackTest-842759927',87,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'34672b2b7f2e4ab6917a98058366875e',0,0,1,'8804ca2e-8411-475c-846a-a9c5154645ee','{\"edges\": [[[87, false], null]]}',NULL),('ef69d52b-7819-4054-8568-13b5bbba11f5','2026-01-21 11:53:54','2026-01-21 11:54:24','2026-01-21 11:54:29','multi_networks_swaps',168,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'0284cd831e384c408c299b525c6dda9a',0,0,1,'455b3841-cdba-4cb0-8995-2b78d3b58026','{\"edges\": [[[166, false], [164, false]], [[166, false], [165, false]], [[165, false], [164, false]]]}',NULL),('f0dca769-a303-42af-9a3e-326de6978ff5','2026-01-21 11:50:29','2026-01-21 11:50:30','2026-01-21 11:50:31','ResourcesList-1503661181',91,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'64113763493a470fb244c225cd01856b',0,0,1,'b2b27f94-4789-4081-9bca-9a9f71a6d4a4','{\"edges\": [[[106, false], [105, false]]]}',NULL),('f1cabc12-90f5-4e11-b356-3243fcc57cb9','2026-01-21 11:49:55','2026-01-21 11:50:05','2026-01-21 11:50:07','UpdateSubnetTest-976401956',75,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'65bd1c1abe314e67948b000e9963016f',0,0,1,'3566ad02-31a3-4d85-87d9-5d36d7053cc9','{\"edges\": [[[72, false], [71, false]]]}',NULL),('f2da6721-6e76-4187-a126-a4b260ddbda9','2026-01-21 11:48:51','2026-01-21 11:49:06','2026-01-21 11:49:09','UpdateTrunkTest-1943635260',37,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'6b6065e808734544b57c6ae36b1d6aa9',0,0,1,'3f9554fa-7b9f-4308-b106-5184eeda3b36','{\"edges\": [[[23, false], [16, false]], [[18, false], [16, false]], [[17, false], [16, false]], [[22, false], [17, false]], [[22, false], [21, false]], [[21, false], [17, false]], [[20, false], [18, false]], [[20, false], [19, false]], [[19, false], [18, false]], [[25, false], [23, false]], [[25, false], [24, false]], [[24, false], [23, false]]]}',NULL),('f50745fa-ce29-4543-a581-b048a3fdd80b','2026-01-21 11:56:49','2026-01-21 11:57:12','2026-01-21 11:57:13','ParallelDeploymentsTest-125988841-dep_1-4gq4fnryqpmh',206,NULL,NULL,'demo_tempestconf','dbc88dba-8d13-4ef1-8ead-a7bcaa157ae8','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'c553a8b5c9d04925b4bc723194566ec9',0,1,1,'2366d27f-16dc-4116-b9e6-a42a038ed504','{\"edges\": [[[219, false], null]]}','dep_1'),('f61d157a-f715-4d69-8626-bee6625e900d','2026-01-21 11:49:47','2026-01-21 11:50:02','2026-01-21 11:50:03','RemoteStackTest-763348251',73,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'c223b41999ca471f9b49cc7ce781d255',0,0,1,'a7409432-922d-4b68-a302-7f434cc1b14b','{\"edges\": [[[69, false], null]]}',NULL),('f63d3a31-6155-4a14-a121-0cbde886688d','2026-01-21 11:50:39','2026-01-21 11:50:50','2026-01-21 11:50:50','HooksTest-1354691914-nested-77did4cequy6',106,NULL,NULL,'demo_tempestconf','59903018-4f7f-4406-93e4-9a5df11e0c9a','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'0c86fc59a0e34c209946759020015604',0,1,1,'3a454855-316f-4f83-8cb0-1ab25c978344','{\"edges\": [[[112, false], [111, false]], [[111, false], [110, false]]]}','nested'),('f7c6bff2-aca2-412a-9a33-d35c6e2eee2e','2026-01-21 11:49:35','2026-01-21 11:49:40','2026-01-21 11:49:41','RemoteStackTest-1644753654',60,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'3d616d86c1c540bc83fadc343b59c33c',0,0,1,'1464816c-6fda-47ff-af2b-99a8d1fd1516','{\"edges\": [[[65, false], null]]}',NULL),('fcb1db83-860b-4e99-80ef-9c5e790ab2f3','2026-01-21 11:49:59','2026-01-21 11:50:36','2026-01-21 11:50:39','create_server_with_sub_ip',95,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6335f7a2d173450c9047bebcdde38d0a',1,'0854c3a12bdd445a99c4d75ee2b9c1eb',0,0,1,'20eb2c44-759b-45b3-86cd-8e5dbb042720','{\"edges\": [[[85, false], [83, false]], [[84, false], [83, false]], [[86, false], [85, false]], [[86, false], [84, false]]]}',NULL);
/*!40000 ALTER TABLE `stack` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack_lock`
--

DROP TABLE IF EXISTS `stack_lock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack_lock` (
  `stack_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `engine_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`stack_id`),
  CONSTRAINT `stack_lock_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack_lock`
--

LOCK TABLES `stack_lock` WRITE;
/*!40000 ALTER TABLE `stack_lock` DISABLE KEYS */;
/*!40000 ALTER TABLE `stack_lock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack_tag`
--

DROP TABLE IF EXISTS `stack_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `tag` varchar(80) DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stack_id` (`stack_id`),
  CONSTRAINT `stack_tag_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack_tag`
--

LOCK TABLES `stack_tag` WRITE;
/*!40000 ALTER TABLE `stack_tag` DISABLE KEYS */;
INSERT INTO `stack_tag` (`id`, `created_at`, `updated_at`, `tag`, `stack_id`) VALUES (1,'2026-01-21 11:52:55',NULL,'foo','0fc99612-a45e-481b-bc93-1eb90201b6cf'),(2,'2026-01-21 11:52:55',NULL,'data-processing-cluster','0fc99612-a45e-481b-bc93-1eb90201b6cf');
/*!40000 ALTER TABLE `stack_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_point`
--

DROP TABLE IF EXISTS `sync_point`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sync_point` (
  `entity_id` varchar(36) NOT NULL,
  `traversal_id` varchar(36) NOT NULL,
  `is_update` tinyint(1) NOT NULL,
  `atomic_key` int(11) NOT NULL,
  `stack_id` varchar(36) NOT NULL,
  `input_data` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`traversal_id`,`is_update`),
  KEY `fk_stack_id` (`stack_id`),
  CONSTRAINT `fk_stack_id` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_point`
--

LOCK TABLES `sync_point` WRITE;
/*!40000 ALTER TABLE `sync_point` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_point` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_creds`
--

DROP TABLE IF EXISTS `user_creds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_creds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `username` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `region_name` varchar(255) DEFAULT NULL,
  `decrypt_method` varchar(64) DEFAULT NULL,
  `tenant` varchar(1024) DEFAULT NULL,
  `auth_url` text DEFAULT NULL,
  `tenant_id` varchar(256) DEFAULT NULL,
  `trust_id` varchar(255) DEFAULT NULL,
  `trustor_user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=76 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_creds`
--

LOCK TABLES `user_creds` WRITE;
/*!40000 ALTER TABLE `user_creds` DISABLE KEYS */;
INSERT INTO `user_creds` (`id`, `created_at`, `updated_at`, `username`, `password`, `region_name`, `decrypt_method`, `tenant`, `auth_url`, `tenant_id`, `trust_id`, `trustor_user_id`) VALUES (2,'2026-01-21 11:48:35',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','6335f7a2d173450c9047bebcdde38d0a','gAAAAABpcL0T7FPNEh8S7lzYprN8nCLRX3wxdOwxeC31-xa3GxhEcNKZiIrX9_wMd16fB3L0f6ZkZDLBeIzlUWqOBpAUDDVDiAO7qUOZ-e9pyDx6wTMPu5SaoCfEAty-GevmHi7hzk9t','ef2e3c75fd8442f0a8c2533f70ba24bb'),(3,'2026-01-21 11:48:36',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','6335f7a2d173450c9047bebcdde38d0a','gAAAAABpcL0UdIEioZ0Ap9Sm3GcQmqv059xSUi0WgDmltSRIpw_8SEWpnRJSrXDCATzZf8I4W0iOgIHSlqyVPMpAOghiujY8WuGjVQp9mp8YXb7Lz-s2Lkf2K-QjYVQOjX49HSoNxIfR','ef2e3c75fd8442f0a8c2533f70ba24bb'),(7,'2026-01-21 11:48:40',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','6335f7a2d173450c9047bebcdde38d0a','gAAAAABpcL0Y_tuRraxf-cMQoA6LZ__YtWpcsf-PMZPE2_6HsuMRE6yW6F-g2xGMey0a_h2PS7VfGtW_6PyF_dlzC7-llSsL60DVzUXiyY_5usDGdf8G65tIsmtA7HmSMGsGtHXTWvmg','ef2e3c75fd8442f0a8c2533f70ba24bb'),(9,'2026-01-21 11:48:42',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','6335f7a2d173450c9047bebcdde38d0a','gAAAAABpcL0aH48a7QB_HpuqJc-zMDkxH5fAt23RcjLs_lp53k5ujWnSmEMl1NT1pdu7vjj3k19EwZIBaN1kzbQrhlBsWs_D_w_m4HNea7PZ2rWwpxn794qYyCfStsSa97ysCx2qrWkg','ef2e3c75fd8442f0a8c2533f70ba24bb'),(12,'2026-01-21 11:48:44',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','6335f7a2d173450c9047bebcdde38d0a','gAAAAABpcL0cE7ITF_2e-QdUxYziuSUu_JOvSVRIiw_C3OkFCpbfsAISfZntNGuBThEdz7NzTPmjSZMIM91shdseRXi1wGAMonfkhcMChP53oDk6BOrbYC7j1nVHwwSOkfVonuok10yT','ef2e3c75fd8442f0a8c2533f70ba24bb'),(13,'2026-01-21 11:48:46',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','6335f7a2d173450c9047bebcdde38d0a','gAAAAABpcL0eecp7w227EfCVk7HtjgjDLrJxYUlDAECDxoQdchMkN6XWiyDpRde3JVwAbuuow1XYmhX6sfj1--XAz_l24Z4VOXO7WGGwX7LaBF1DtwKvQIZNETTVN9-8e00uwrGZanwN','ef2e3c75fd8442f0a8c2533f70ba24bb');
/*!40000 ALTER TABLE `user_creds` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `user_id` (`user_id`),
  KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','28b1191f51d74f55b1a8bad42e523072','aeebbda5de93441581d6d2839ea5dc83','1c5fd2b15a2846629aff3c2883e22df9',0),('UserProject','28b1191f51d74f55b1a8bad42e523072','aeebbda5de93441581d6d2839ea5dc83','af657000208b444589860609500f7a2b',0),('UserProject','346aa228901043c8aacf73c3190b0005','aeebbda5de93441581d6d2839ea5dc83','1c5fd2b15a2846629aff3c2883e22df9',0),('UserProject','346aa228901043c8aacf73c3190b0005','aeebbda5de93441581d6d2839ea5dc83','af657000208b444589860609500f7a2b',0),('UserProject','4548b45b553f47658d370ca3661a9b5f','aeebbda5de93441581d6d2839ea5dc83','1c5fd2b15a2846629aff3c2883e22df9',0),('UserProject','4548b45b553f47658d370ca3661a9b5f','aeebbda5de93441581d6d2839ea5dc83','af657000208b444589860609500f7a2b',0),('UserProject','4fdf2caadaf54f2eb9b4192bf7b58df8','aeebbda5de93441581d6d2839ea5dc83','1c5fd2b15a2846629aff3c2883e22df9',0),('UserProject','4fdf2caadaf54f2eb9b4192bf7b58df8','aeebbda5de93441581d6d2839ea5dc83','af657000208b444589860609500f7a2b',0),('UserProject','5f55d208cb974764b75cc63cfc0c99a2','aeebbda5de93441581d6d2839ea5dc83','1c5fd2b15a2846629aff3c2883e22df9',0),('UserProject','5f55d208cb974764b75cc63cfc0c99a2','aeebbda5de93441581d6d2839ea5dc83','af657000208b444589860609500f7a2b',0),('UserProject','755d8d6f57964bf38856c4aa4338ac1e','aeebbda5de93441581d6d2839ea5dc83','1c5fd2b15a2846629aff3c2883e22df9',0),('UserProject','755d8d6f57964bf38856c4aa4338ac1e','aeebbda5de93441581d6d2839ea5dc83','44c8d9a28d99401bb3144ae3862c456f',0),('UserProject','755d8d6f57964bf38856c4aa4338ac1e','aeebbda5de93441581d6d2839ea5dc83','af657000208b444589860609500f7a2b',0),('UserProject','ade56004518d4d0c8dbff39b592e3f09','6335f7a2d173450c9047bebcdde38d0a','1c5fd2b15a2846629aff3c2883e22df9',0),('UserProject','ade56004518d4d0c8dbff39b592e3f09','8d6df07ed5c54b3ebd7550a0bf0138aa','1c5fd2b15a2846629aff3c2883e22df9',0),('UserProject','bf47cfa4086b48268a116c0918bb182e','aeebbda5de93441581d6d2839ea5dc83','1c5fd2b15a2846629aff3c2883e22df9',0),('UserProject','bf47cfa4086b48268a116c0918bb182e','aeebbda5de93441581d6d2839ea5dc83','af657000208b444589860609500f7a2b',0),('UserProject','ccb9366be88c425a8aa822d14935c5a3','aeebbda5de93441581d6d2839ea5dc83','1c5fd2b15a2846629aff3c2883e22df9',0),('UserProject','ccb9366be88c425a8aa822d14935c5a3','aeebbda5de93441581d6d2839ea5dc83','af657000208b444589860609500f7a2b',0),('UserProject','ef2e3c75fd8442f0a8c2533f70ba24bb','6335f7a2d173450c9047bebcdde38d0a','4c5c9f2d2de54302b926fec0864134f6',0),('UserProject','f121ad4df1604e4a86b7d2c3debdfd0f','aeebbda5de93441581d6d2839ea5dc83','1c5fd2b15a2846629aff3c2883e22df9',0),('UserProject','f121ad4df1604e4a86b7d2c3debdfd0f','aeebbda5de93441581d6d2839ea5dc83','af657000208b444589860609500f7a2b',0),('UserDomain','171a520d7d0b41bd92c983b88545ed9d','7cca0740546d4f758ee8a3a0b88f0d11','1c5fd2b15a2846629aff3c2883e22df9',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('015bc708e6244e66a45996481f081c42',NULL,'internal','71e43d8eeb8c49239956edd329263dc4','https://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('10766e5fcac44eb49e214814aefc5b33',NULL,'internal','7a8148a86caf42f1bb77512b0aed9d12','https://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('131b18911c554c899dd3983a59b1af03',NULL,'internal','048f932c6f8f433685ebdc8627504937','https://swift-internal.openstack.svc:8080/v1/AUTH_%(tenant_id)s','{\"name\": \"swift\"}',1,'regionOne'),('17a31d4cf9094d2ba1922f31c7c76a9a',NULL,'internal','0a4b3a984ddb4675ba2558f3811cc63a','https://heat-api-internal.openstack.svc:8004/v1/%(tenant_id)s','{\"name\": \"heat\"}',1,'regionOne'),('2c77ed7bf0b44a2aab94ad7c4706f33b',NULL,'internal','caf4289f3fa44bd6800d39ba4898b093','https://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('305f2c035bd94cd69bb6d350c32e20f8',NULL,'public','caf4289f3fa44bd6800d39ba4898b093','https://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('3820ed5d231c4e09a7efe1c5b3d7d47a',NULL,'internal','6a7fb4354b6044368c2ade645b9c072f','https://heat-cfnapi-internal.openstack.svc:8000/v1','{\"name\": \"heat-cfn\"}',1,'regionOne'),('4b3774f0f6a34be1b79e911c2b63281a',NULL,'public','64f7270540f94dd9978151e62e91c207','https://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('5ae72b179ca74943bffc247891114000',NULL,'internal','974b52b1ef3e4e47bb8b925467ca883d','https://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('77f7dfde48ad4b9f8343a3f9ea70c9d4',NULL,'public','71e43d8eeb8c49239956edd329263dc4','https://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('8415841719464b46881c6e24770ad5e7',NULL,'public','7a8148a86caf42f1bb77512b0aed9d12','https://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('85e7fe9db8f942c3b16d1e58058b0be9',NULL,'public','6a7fb4354b6044368c2ade645b9c072f','https://heat-cfnapi-public-openstack.apps-crc.testing/v1','{\"name\": \"heat-cfn\"}',1,'regionOne'),('a07b694c76234e14bfd656875c778a31',NULL,'public','0a4b3a984ddb4675ba2558f3811cc63a','https://heat-api-public-openstack.apps-crc.testing/v1/%(tenant_id)s','{\"name\": \"heat\"}',1,'regionOne'),('c3d29796e7694611a2466a7d5da64404',NULL,'internal','a02cac0eff5346bd9262688c62e6e6dd','https://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('d3a9f036580446468e687b272566e74b',NULL,'public','ce0c65984ff1453e9095d2e9c49b9516','https://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('d631f3a5d8cb45b18ca7f03aa39e2399',NULL,'public','974b52b1ef3e4e47bb8b925467ca883d','https://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('db6a2bef675c4f0cb5ad6461fad6a24b',NULL,'public','048f932c6f8f433685ebdc8627504937','https://swift-public-openstack.apps-crc.testing/v1/AUTH_%(tenant_id)s','{\"name\": \"swift\"}',1,'regionOne'),('e957453092bc45559d7049fe284fafd2',NULL,'public','a02cac0eff5346bd9262688c62e6e6dd','https://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('f7e8135d885f4f179cc6609250d8d830',NULL,'internal','64f7270540f94dd9978151e62e91c207','https://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('fb7c3756a9a64f10ad45157b31962b39',NULL,'internal','ce0c65984ff1453e9095d2e9c49b9516','https://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('1c5fd2b15a2846629aff3c2883e22df9','4c5c9f2d2de54302b926fec0864134f6'),('4c5c9f2d2de54302b926fec0864134f6','841ee0e43b3f490286b6e45d6dfdf729');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (1,'ade56004518d4d0c8dbff39b592e3f09','default','admin',0,NULL),(2,'f121ad4df1604e4a86b7d2c3debdfd0f','default','glance',0,NULL),(3,'ccb9366be88c425a8aa822d14935c5a3','default','nova',0,NULL),(4,'346aa228901043c8aacf73c3190b0005','default','neutron',0,NULL),(5,'4548b45b553f47658d370ca3661a9b5f','default','swift',0,NULL),(6,'755d8d6f57964bf38856c4aa4338ac1e','default','ceilometer',0,NULL),(7,'171a520d7d0b41bd92c983b88545ed9d','7cca0740546d4f758ee8a3a0b88f0d11','heat_stack_domain_admin',0,NULL),(8,'28b1191f51d74f55b1a8bad42e523072','default','placement',0,NULL),(9,'5f55d208cb974764b75cc63cfc0c99a2','default','barbican',0,NULL),(10,'bf47cfa4086b48268a116c0918bb182e','default','cinder',0,NULL),(11,'4fdf2caadaf54f2eb9b4192bf7b58df8','default','heat',0,NULL),(12,'ef2e3c75fd8442f0a8c2533f70ba24bb','default','demo_tempestconf',0,NULL),(13,'c7403d5df2bc4eafa3d63e254d7c9b00','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (1,1,NULL,0,'$2b$12$fSnxZCI2HKexUh9.Cl2R3OD9ZEh.TdRa5IR2z7fARk4eVtUWzHrfO',1768994784974768,NULL,'2026-01-21 11:26:24'),(2,2,NULL,0,'$2b$12$XRv1FVulKDmjz/O7.sBeyee3R7fzv.I3tvEBedZVYJcKctwq0kvWe',1768994841310150,NULL,'2026-01-21 11:27:21'),(3,3,NULL,0,'$2b$12$Viq5jPRDjG9MzHGvENdQUef6y4KyNJe3Y424WzjBkz2DGeTubwm/W',1768994843576516,NULL,'2026-01-21 11:27:23'),(4,4,NULL,0,'$2b$12$WJWzyTzPrtXMENsywSN3C.5En1gGvADeHBpe5OOsGvAs01Ypcd4k.',1768994846126370,NULL,'2026-01-21 11:27:26'),(5,5,NULL,0,'$2b$12$D4mZKul7oiiPbKE6dym/4Ob/o1BBsIqgfgEkJq4oEMKscaUteCqxO',1768994847890589,NULL,'2026-01-21 11:27:27'),(6,6,NULL,0,'$2b$12$Fn.MipGZWzHPlU.QiDc5mugeZadtqAsHZosXuaKfphZdpAoyWhJLG',1768994850012455,NULL,'2026-01-21 11:27:30'),(7,7,NULL,0,'$2b$12$uDYgYxNqzwcwkdtt6Z91AuseJwNghIcE6e6/rJDSdTtUUKW/zeCoq',1768994851499224,NULL,'2026-01-21 11:27:31'),(8,8,NULL,0,'$2b$12$GvXK1HggotMh19WAOHR4OuZqxu81JjEpP8XEIR9Zgf4MsHW3nIpc.',1768994852983225,NULL,'2026-01-21 11:27:32'),(9,9,NULL,0,'$2b$12$C8Z1cazhAN.w4XZZnxQXNeE5AK5ckH8f9NLDJ.k.CQrdi7FDOEw4K',1768994858696348,NULL,'2026-01-21 11:27:38'),(10,10,NULL,0,'$2b$12$qKSxHZtRjqb6Wj6zpohFGOo.mqJYpmdA649/sWcaq.NSEfOhtzp0m',1768994870089432,NULL,'2026-01-21 11:27:50'),(11,11,NULL,0,'$2b$12$CRf1LEnJcxcFoe3Rg7/4ouPvAtR9WuBg1sirgcC7jN/2JKiKSFgzO',1768994873369745,NULL,'2026-01-21 11:27:53'),(12,12,NULL,0,'$2b$12$wiCTxzOY.F667A6tbi5ENOuApfIxK.WDGWYLPcCDQ0hlPPmiXw5tm',1768996092638157,NULL,'2026-01-21 11:48:12'),(13,13,NULL,0,'$2b$12$Hq3sM259VYFOoFa.k.1gtuoB1kNMLLBUwt8u7eo36LCEm1roqYxSa',1768996092999846,NULL,'2026-01-21 11:48:12');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('505333bddf064d27acc4924fede5fa25','6335f7a2d173450c9047bebcdde38d0a-cb36b365-7a1d-4fe1-bc43-ac090d0','{}','Heat stack user project',1,'7cca0740546d4f758ee8a3a0b88f0d11','7cca0740546d4f758ee8a3a0b88f0d11',0),('6335f7a2d173450c9047bebcdde38d0a','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('773576be49dd4a13ba5ce02b0f3734a7','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0),('7cca0740546d4f758ee8a3a0b88f0d11','heat_stack','{}','Domain for Heat stacks',1,'<<keystone.domain.root>>',NULL,1),('8d6df07ed5c54b3ebd7550a0bf0138aa','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0),('93a27d5377f84dd6b3137ee4b4106e6b','6335f7a2d173450c9047bebcdde38d0a-87791753-832b-4e25-bdb8-97a4781','{}','Heat stack user project',1,'7cca0740546d4f758ee8a3a0b88f0d11','7cca0740546d4f758ee8a3a0b88f0d11',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('ac0270e4243944058b784b3888f21549','6335f7a2d173450c9047bebcdde38d0a-8e7f35e3-6de2-4d40-ae21-5912ea3','{}','Heat stack user project',1,'7cca0740546d4f758ee8a3a0b88f0d11','7cca0740546d4f758ee8a3a0b88f0d11',0),('aeebbda5de93441581d6d2839ea5dc83','service','{}','service',1,'default','default',0),('c745d612611a4641a5e0169f09f4ba2d','6335f7a2d173450c9047bebcdde38d0a-4f10c6b8-0472-4108-b086-fd59f41','{}','Heat stack user project',1,'7cca0740546d4f758ee8a3a0b88f0d11','7cca0740546d4f758ee8a3a0b88f0d11',0),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1),('f1da49f947fa47129529e647efc944cd','6335f7a2d173450c9047bebcdde38d0a-a1f99d50-aa51-4cad-9b96-faac656','{}','Heat stack user project',1,'7cca0740546d4f758ee8a3a0b88f0d11','7cca0740546d4f758ee8a3a0b88f0d11',0),('f430a92690954625b63dbd9ab646bc2c','6335f7a2d173450c9047bebcdde38d0a-6268584d-cf69-44cb-bdf0-9d8f6bd','{}','Heat stack user project',1,'7cca0740546d4f758ee8a3a0b88f0d11','7cca0740546d4f758ee8a3a0b88f0d11',0);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=163 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (1,NULL,NULL,NULL,NULL,'de61822dc1c84d2ba6df2d653f260fd0',NULL,NULL,'2026-01-21 11:48:37',NULL,'2026-01-21 11:48:37',NULL,NULL),(2,NULL,'99d969b39a2d4c5eb9b1a7cc74798f30',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:48:37',NULL,'2026-01-21 11:48:37',NULL,NULL),(3,NULL,NULL,NULL,NULL,'93846e9c4c074b41aaa494e4c1a881f7',NULL,NULL,'2026-01-21 11:48:40',NULL,'2026-01-21 11:48:40',NULL,NULL),(4,NULL,'c64ed9258b1047a5ab2ae4eb51d09854',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:48:41',NULL,'2026-01-21 11:48:41',NULL,NULL),(5,NULL,NULL,NULL,NULL,'733f1a52a47b4e8a82435261421a028f',NULL,NULL,'2026-01-21 11:48:41',NULL,'2026-01-21 11:48:41',NULL,NULL),(6,NULL,NULL,NULL,NULL,'25c566be9e604c4ab3829d3a6641d2f8',NULL,NULL,'2026-01-21 11:48:41',NULL,'2026-01-21 11:48:41',NULL,NULL),(7,NULL,'f381750732d849b5b3215af5e5deb710',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:48:42',NULL,'2026-01-21 11:48:42',NULL,NULL),(8,NULL,'1871dbcd46e54ad3a249c3df4e206da2',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:48:42',NULL,'2026-01-21 11:48:42',NULL,NULL),(9,NULL,NULL,NULL,NULL,'762535e085d14f75867ea13f31f3386c',NULL,NULL,'2026-01-21 11:48:44',NULL,'2026-01-21 11:48:44',NULL,NULL),(10,NULL,'5a3ffe6db04b4403b47ee861e42545bc',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:48:45',NULL,'2026-01-21 11:48:45',NULL,NULL),(11,NULL,NULL,NULL,NULL,'d1c9fa1f7b86409982b3648d16af4a39',NULL,NULL,'2026-01-21 11:48:45',NULL,'2026-01-21 11:48:45',NULL,NULL),(12,NULL,'ca11ec1f8a414479ba85d11be2151393',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:48:46',NULL,'2026-01-21 11:48:46',NULL,NULL),(13,NULL,NULL,NULL,NULL,'66f8006fe1e34f77ae86bc7f17c39702',NULL,NULL,'2026-01-21 11:48:52',NULL,'2026-01-21 11:48:52',NULL,NULL),(14,NULL,'5c171884aebe420db059128289383827',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:48:52',NULL,'2026-01-21 11:48:52',NULL,NULL),(15,NULL,NULL,NULL,NULL,'d2722ecfcdfe4791b893d4834d997b98',NULL,NULL,'2026-01-21 11:49:03',NULL,'2026-01-21 11:49:03',NULL,NULL),(16,NULL,NULL,NULL,NULL,'3fab8fdf8fe44e50be1d6d8a1e210451',NULL,NULL,'2026-01-21 11:49:04',NULL,'2026-01-21 11:49:04',NULL,NULL),(17,NULL,'79718884f1574663b42f1607411a8534',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:49:04',NULL,'2026-01-21 11:49:04',NULL,NULL),(18,NULL,'5f6e0f5219474375a17c3c059516b485',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:49:04',NULL,'2026-01-21 11:49:04',NULL,NULL),(19,NULL,NULL,NULL,NULL,'98aa830b7c5946a79d2b69e1d0e7574b',NULL,NULL,'2026-01-21 11:49:09',NULL,'2026-01-21 11:49:09',NULL,NULL),(20,NULL,NULL,NULL,NULL,'47229c5e84ea4c3cacbe4667b511eb5c',NULL,NULL,'2026-01-21 11:49:09',NULL,'2026-01-21 11:49:09',NULL,NULL),(21,NULL,'6b6065e808734544b57c6ae36b1d6aa9',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:49:09',NULL,'2026-01-21 11:49:09',NULL,NULL),(22,NULL,'80ef1944f45f48c4bfa5901371ee1b08',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:49:09',NULL,'2026-01-21 11:49:09',NULL,NULL),(23,NULL,NULL,NULL,NULL,'ccc2a11c76a841f096c974525257b339',NULL,NULL,'2026-01-21 11:49:19',NULL,'2026-01-21 11:49:19',NULL,NULL),(24,NULL,'28df6f5702df4ed59a18142b0f802a12',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:49:19',NULL,'2026-01-21 11:49:19',NULL,NULL),(25,NULL,NULL,NULL,NULL,'ebe7478de918458ea5d0e207d24f879a',NULL,NULL,'2026-01-21 11:49:25',NULL,'2026-01-21 11:49:25',NULL,NULL),(26,NULL,'1a06037a8b20464d9e3729f179f03e85',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:49:25',NULL,'2026-01-21 11:49:25',NULL,NULL),(27,NULL,NULL,NULL,NULL,'e94cf01a656f4e96a64746964118128f',NULL,NULL,'2026-01-21 11:49:30',NULL,'2026-01-21 11:49:30',NULL,NULL),(28,NULL,'852502748f0c4646bb8bafc34c76c1a6',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:49:30',NULL,'2026-01-21 11:49:30',NULL,NULL),(29,NULL,NULL,NULL,NULL,'5d6a904b67c644dfa57b48bb90fb6e71',NULL,NULL,'2026-01-21 11:49:32',NULL,'2026-01-21 11:49:32',NULL,NULL),(30,NULL,'395784ea071849f1bbbe0a420c672792',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:49:32',NULL,'2026-01-21 11:49:32',NULL,NULL),(31,NULL,NULL,NULL,NULL,'570a703a045344f483aba662ab019d27',NULL,NULL,'2026-01-21 11:49:32',NULL,'2026-01-21 11:49:32',NULL,NULL),(32,NULL,'b3a9a25418534dab9fd1db401e5e2210',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:49:33',NULL,'2026-01-21 11:49:33',NULL,NULL),(33,NULL,NULL,NULL,NULL,'5ea1edbcf8dd48949404e785750925be',NULL,NULL,'2026-01-21 11:49:34',NULL,'2026-01-21 11:49:34',NULL,NULL),(34,NULL,'389a9d75183b423aa93fed80ea42edfc',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:49:34',NULL,'2026-01-21 11:49:34',NULL,NULL),(35,NULL,NULL,NULL,NULL,'b78c5e83a6b24f3389c98ab09b19e0f9',NULL,NULL,'2026-01-21 11:49:41',NULL,'2026-01-21 11:49:41',NULL,NULL),(36,NULL,NULL,NULL,NULL,'60c8f8767650461faf9d4100958f76a6',NULL,NULL,'2026-01-21 11:49:41',NULL,'2026-01-21 11:49:41',NULL,NULL),(37,NULL,'469c0172b8c646eb9e0f87dc04f4ad5e',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:49:41',NULL,'2026-01-21 11:49:41',NULL,NULL),(38,NULL,'3d616d86c1c540bc83fadc343b59c33c',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:49:41',NULL,'2026-01-21 11:49:41',NULL,NULL),(39,NULL,NULL,NULL,NULL,'fa73bea95f0b4d869b60de713c0cb008',NULL,NULL,'2026-01-21 11:49:51',NULL,'2026-01-21 11:49:51',NULL,NULL),(40,NULL,'5ee0aa036559426788d4575aa6e3e86b',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:49:51',NULL,'2026-01-21 11:49:51',NULL,NULL),(41,NULL,NULL,NULL,NULL,'3f1fa252b63149dfa138c870406c1f05',NULL,NULL,'2026-01-21 11:49:53',NULL,'2026-01-21 11:49:53',NULL,NULL),(42,NULL,'51e327c71fdb4f73b35d14c8b6304789',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:49:54',NULL,'2026-01-21 11:49:54',NULL,NULL),(43,NULL,NULL,NULL,NULL,'c8b48c52be9b41c4861412c9cb96fc4c',NULL,NULL,'2026-01-21 11:49:54',NULL,'2026-01-21 11:49:54',NULL,NULL),(44,NULL,'8a80c4c0da5141ecb6f9959abf6ef27d',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:49:54',NULL,'2026-01-21 11:49:54',NULL,NULL),(45,NULL,NULL,NULL,NULL,'46236679337146c6985a12d347cf9233',NULL,NULL,'2026-01-21 11:50:03',NULL,'2026-01-21 11:50:03',NULL,NULL),(46,NULL,NULL,NULL,NULL,'455b1ca4664d442c877f88caae0b6280',NULL,NULL,'2026-01-21 11:50:03',NULL,'2026-01-21 11:50:03',NULL,NULL),(47,NULL,'bf3877701a2f48ae9709ee97bbb7cce7',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:50:03',NULL,'2026-01-21 11:50:03',NULL,NULL),(48,NULL,'c223b41999ca471f9b49cc7ce781d255',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:50:03',NULL,'2026-01-21 11:50:03',NULL,NULL),(49,NULL,NULL,NULL,NULL,'e913d0826cac46eb8bab71095df587ab',NULL,NULL,'2026-01-21 11:50:07',NULL,'2026-01-21 11:50:07',NULL,NULL),(50,NULL,'65bd1c1abe314e67948b000e9963016f',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:50:07',NULL,'2026-01-21 11:50:07',NULL,NULL),(51,NULL,NULL,NULL,NULL,'2028ab04b4dc4e49bfcaa1389e304c41',NULL,NULL,'2026-01-21 11:50:21',NULL,'2026-01-21 11:50:21',NULL,NULL),(52,NULL,'e42d7f5cedbd4edc9c0d41618cf2037b',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:50:22',NULL,'2026-01-21 11:50:22',NULL,NULL),(53,NULL,NULL,NULL,NULL,'8788151704b345468f78fa7e8ceb8294',NULL,NULL,'2026-01-21 11:50:23',NULL,'2026-01-21 11:50:23',NULL,NULL),(54,NULL,'f7be73b0e9b54a55855357d7472d15f7',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:50:23',NULL,'2026-01-21 11:50:23',NULL,NULL),(55,NULL,NULL,NULL,NULL,'a475d7daf1b34ad09a59f01dc8f13ce5',NULL,NULL,'2026-01-21 11:50:24',NULL,'2026-01-21 11:50:24',NULL,NULL),(56,NULL,NULL,NULL,NULL,'bbde736ce3874d6a8f9be224545a0841',NULL,NULL,'2026-01-21 11:50:24',NULL,'2026-01-21 11:50:24',NULL,NULL),(57,NULL,'7ebdaab16a7046d9b1810de2e144605c',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:50:25',NULL,'2026-01-21 11:50:25',NULL,NULL),(58,NULL,'34672b2b7f2e4ab6917a98058366875e',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:50:25',NULL,'2026-01-21 11:50:25',NULL,NULL),(59,NULL,NULL,NULL,NULL,'4dbe6b25b43d40d4bb5a7889dac99435',NULL,NULL,'2026-01-21 11:50:31',NULL,'2026-01-21 11:50:31',NULL,NULL),(60,NULL,'64113763493a470fb244c225cd01856b',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:50:31',NULL,'2026-01-21 11:50:31',NULL,NULL),(61,NULL,NULL,NULL,NULL,'0856d842d0454b5cb51b67edeb059422',NULL,NULL,'2026-01-21 11:50:33',NULL,'2026-01-21 11:50:33',NULL,NULL),(62,NULL,'80635150a05344f994768dfd5d01e1b2',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:50:34',NULL,'2026-01-21 11:50:34',NULL,NULL),(63,NULL,NULL,NULL,NULL,'ce743e5dd79e4b17a419e804c44554a1',NULL,NULL,'2026-01-21 11:50:37',NULL,'2026-01-21 11:50:37',NULL,NULL),(64,NULL,'d95126f2e37c46da822d2f0fb4e57d0d',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:50:37',NULL,'2026-01-21 11:50:37',NULL,NULL),(65,NULL,NULL,NULL,NULL,'05b2615a8a7447d5934efdff901bc23a',NULL,NULL,'2026-01-21 11:50:38',NULL,'2026-01-21 11:50:38',NULL,NULL),(66,NULL,'0854c3a12bdd445a99c4d75ee2b9c1eb',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:50:39',NULL,'2026-01-21 11:50:39',NULL,NULL),(67,NULL,NULL,NULL,NULL,'f1cbfb6fa1544cfdb70a3b5c63c0e952',NULL,NULL,'2026-01-21 11:50:44',NULL,'2026-01-21 11:50:44',NULL,NULL),(68,NULL,'73598e79f7434d0ebf6e01c652aeb08b',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:50:44',NULL,'2026-01-21 11:50:44',NULL,NULL),(69,NULL,NULL,NULL,NULL,'2e04295f4f154e67b8c89df7a4cbcf37',NULL,NULL,'2026-01-21 11:50:47',NULL,'2026-01-21 11:50:47',NULL,NULL),(70,NULL,'70b2cf9fe9c145dfab1263390975d5a9',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:50:48',NULL,'2026-01-21 11:50:48',NULL,NULL),(71,NULL,NULL,NULL,NULL,'84299f8b95de44a198d986e495633b82',NULL,NULL,'2026-01-21 11:50:51',NULL,'2026-01-21 11:50:51',NULL,NULL),(72,NULL,'0c86fc59a0e34c209946759020015604',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:50:51',NULL,'2026-01-21 11:50:51',NULL,NULL),(73,NULL,NULL,NULL,NULL,'24ab0fcc43a24f2fadbeac8d63bbf70c',NULL,NULL,'2026-01-21 11:50:53',NULL,'2026-01-21 11:50:53',NULL,NULL),(74,NULL,NULL,NULL,NULL,'958aa48c4da94cfd8f583d74b4547e26',NULL,NULL,'2026-01-21 11:50:53',NULL,'2026-01-21 11:50:53',NULL,NULL),(75,NULL,'d95a0ef37ecd4adcb4b22599e0f4ca42',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:50:53',NULL,'2026-01-21 11:50:53',NULL,NULL),(76,NULL,'e9ac463bd1d545bd95388250a1d2cb85',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:50:54',NULL,'2026-01-21 11:50:54',NULL,NULL),(77,NULL,NULL,NULL,NULL,'b8c65a0cab84465d80ee836f0b1f06fe',NULL,NULL,'2026-01-21 11:51:14',NULL,'2026-01-21 11:51:14',NULL,NULL),(78,NULL,'0edbd1f49ab04db486cbcfa9d8181921',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:51:14',NULL,'2026-01-21 11:51:14',NULL,NULL),(79,NULL,NULL,NULL,NULL,'9d54813b9d3a4bcfbb0d7a20a1ecf6ee',NULL,NULL,'2026-01-21 11:51:16',NULL,'2026-01-21 11:51:16',NULL,NULL),(80,NULL,'2bb711701f9649ec9bae2aa9a8172e1a',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:51:16',NULL,'2026-01-21 11:51:16',NULL,NULL),(81,NULL,NULL,NULL,NULL,'98399daba441454388c22a0ecf3f5611',NULL,NULL,'2026-01-21 11:51:27',NULL,'2026-01-21 11:51:27',NULL,NULL),(82,NULL,'9ed73464653a4d1480f04956ffb548b4',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:51:28',NULL,'2026-01-21 11:51:28',NULL,NULL),(83,NULL,NULL,NULL,NULL,'a31bfa21889e4cc5a79109b9ea745349',NULL,NULL,'2026-01-21 11:51:35',NULL,'2026-01-21 11:51:35',NULL,NULL),(84,NULL,'c68ba029a21444769e68d55cd2f5dde7',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:51:35',NULL,'2026-01-21 11:51:35',NULL,NULL),(85,NULL,NULL,NULL,NULL,'838176548da04631b8cdb98de10b49ec',NULL,NULL,'2026-01-21 11:51:36',NULL,'2026-01-21 11:51:36',NULL,NULL),(86,NULL,'71241249dcef4993bbfa4b3140ff8ce2',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:51:36',NULL,'2026-01-21 11:51:36',NULL,NULL),(87,NULL,NULL,NULL,NULL,'a24a5616d0df40478bac4e96b424a615',NULL,NULL,'2026-01-21 11:51:48',NULL,'2026-01-21 11:51:48',NULL,NULL),(88,NULL,'d8e49b5f741a41efb7dbbb3732e21367',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:51:49',NULL,'2026-01-21 11:51:49',NULL,NULL),(89,NULL,NULL,NULL,NULL,'27148798c5ce4ea9820375dfd0808a74',NULL,NULL,'2026-01-21 11:51:49',NULL,'2026-01-21 11:51:49',NULL,NULL),(90,NULL,'97011fdccc964b358d60838e79b037ba',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:51:50',NULL,'2026-01-21 11:51:50',NULL,NULL),(91,NULL,NULL,NULL,NULL,'106700c7cd834a85a6eb13f4e9b311ff',NULL,NULL,'2026-01-21 11:52:00',NULL,'2026-01-21 11:52:00',NULL,NULL),(92,NULL,'e3cf99fb1f7d4eeb86725e2b46990190',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:52:01',NULL,'2026-01-21 11:52:01',NULL,NULL),(93,NULL,NULL,NULL,NULL,'65bac965c1bf485fa2953d0847383ffd',NULL,NULL,'2026-01-21 11:52:06',NULL,'2026-01-21 11:52:06',NULL,NULL),(94,NULL,'739abf3c45b24f578276d589e4991ac9',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:52:06',NULL,'2026-01-21 11:52:06',NULL,NULL),(95,NULL,NULL,NULL,NULL,'f1a677cdde6d49369aff4bf3180b72be',NULL,NULL,'2026-01-21 11:52:26',NULL,'2026-01-21 11:52:26',NULL,NULL),(96,NULL,'799709ec49d34ad4a0580ff7dfa95c94',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:52:26',NULL,'2026-01-21 11:52:26',NULL,NULL),(97,NULL,NULL,NULL,NULL,'27ae63562612448e9ef07939fc658c04',NULL,NULL,'2026-01-21 11:52:37',NULL,'2026-01-21 11:52:37',NULL,NULL),(98,NULL,'8bf31717d740468c827d4c961f40b50b',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:52:37',NULL,'2026-01-21 11:52:37',NULL,NULL),(99,NULL,NULL,NULL,NULL,'422e50d7b8f3488fb88041f8b5f17383',NULL,NULL,'2026-01-21 11:52:38',NULL,'2026-01-21 11:52:38',NULL,NULL),(100,NULL,'e732906f395d404297d72bd7832f5526',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:52:40',NULL,'2026-01-21 11:52:40',NULL,NULL),(101,NULL,NULL,NULL,NULL,'668afc65e2d44959a374c9d7d4f114b0',NULL,NULL,'2026-01-21 11:52:50',NULL,'2026-01-21 11:52:50',NULL,NULL),(102,NULL,'b03cfbb5962d4ef7acbc7604561a1fd1',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:52:50',NULL,'2026-01-21 11:52:50',NULL,NULL),(103,NULL,NULL,NULL,NULL,'8b6d19b4f9134cf69bcd97e4c748abe2',NULL,NULL,'2026-01-21 11:53:02',NULL,'2026-01-21 11:53:02',NULL,NULL),(104,NULL,'c6dea24d74d24346a97280f615ae645f',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:53:02',NULL,'2026-01-21 11:53:02',NULL,NULL),(105,NULL,NULL,NULL,NULL,'e6cec711dfbb48e4a7ad517275491456',NULL,NULL,'2026-01-21 11:53:14',NULL,'2026-01-21 11:53:14',NULL,NULL),(106,NULL,'282856f165974f59af8ec95def113cc0',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:53:15',NULL,'2026-01-21 11:53:15',NULL,NULL),(107,NULL,NULL,NULL,NULL,'c4b7113d2d294f5e9aedfbc3658f2cae',NULL,NULL,'2026-01-21 11:53:22',NULL,'2026-01-21 11:53:22',NULL,NULL),(108,NULL,'f8977d7d4d4342c18240ae34a16fe35d',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:53:22',NULL,'2026-01-21 11:53:22',NULL,NULL),(109,NULL,NULL,NULL,NULL,'7094159ada6e44549b4d072b4e6f1015',NULL,NULL,'2026-01-21 11:53:26',NULL,'2026-01-21 11:53:26',NULL,NULL),(110,NULL,'d7037c984b694b13adb44271f89764d3',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:53:26',NULL,'2026-01-21 11:53:26',NULL,NULL),(111,NULL,NULL,NULL,NULL,'689f77cd87634e52978b032f75a79cf4',NULL,NULL,'2026-01-21 11:53:51',NULL,'2026-01-21 11:53:51',NULL,NULL),(112,NULL,'f5226b34b8484c568c8a3930740f7736',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:53:51',NULL,'2026-01-21 11:53:51',NULL,NULL),(113,NULL,NULL,NULL,NULL,'c647bfa184e24931a7650ec4df015280',NULL,NULL,'2026-01-21 11:54:28',NULL,'2026-01-21 11:54:28',NULL,NULL),(114,NULL,'0284cd831e384c408c299b525c6dda9a',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:54:28',NULL,'2026-01-21 11:54:28',NULL,NULL),(115,NULL,NULL,NULL,NULL,'30e87f06fcc54f019afef539b9317328',NULL,NULL,'2026-01-21 11:55:03',NULL,'2026-01-21 11:55:03',NULL,NULL),(116,NULL,'0093844eddca45e5bf1e0cdb1ad401a3',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:55:04',NULL,'2026-01-21 11:55:04',NULL,NULL),(117,NULL,NULL,NULL,NULL,'ff1424397714432b818f5bc3986989c4',NULL,NULL,'2026-01-21 11:55:42',NULL,'2026-01-21 11:55:42',NULL,NULL),(118,NULL,'b60f91cd489a4ca2bac4bf88d5bbe310',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:55:42',NULL,'2026-01-21 11:55:42',NULL,NULL),(119,NULL,NULL,NULL,NULL,'bc3ffd6f0e8643919c5e52c409989cbc',NULL,NULL,'2026-01-21 11:56:15',NULL,'2026-01-21 11:56:15',NULL,NULL),(120,NULL,'7f526226d5e1462191b48337c6af952b',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:56:16',NULL,'2026-01-21 11:56:16',NULL,NULL),(121,NULL,NULL,'6a8447e8882647e5a8bef478c32d4937',NULL,NULL,NULL,NULL,'2026-01-21 11:57:10',NULL,'2026-01-21 11:57:10',NULL,NULL),(122,NULL,NULL,'56072b5663c34e38b1177a44be4a40df',NULL,NULL,NULL,NULL,'2026-01-21 11:57:12',NULL,'2026-01-21 11:57:12',NULL,NULL),(123,NULL,NULL,'cb875ee028c5439db991790f43837a6a',NULL,NULL,NULL,NULL,'2026-01-21 11:57:13',NULL,'2026-01-21 11:57:13',NULL,NULL),(124,NULL,NULL,NULL,NULL,'23acb0c9173f484cb410069b3e1666c2',NULL,NULL,'2026-01-21 11:57:14',NULL,'2026-01-21 11:57:14',NULL,NULL),(125,NULL,'c553a8b5c9d04925b4bc723194566ec9',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:57:15',NULL,'2026-01-21 11:57:15',NULL,NULL),(126,NULL,NULL,'ac9309cc9743470ab955ea24a9c5a0b4',NULL,NULL,NULL,NULL,'2026-01-21 11:57:20',NULL,'2026-01-21 11:57:20',NULL,NULL),(127,NULL,NULL,'77aff1b190c74be6bd1a7cfcf413e2ec',NULL,NULL,NULL,NULL,'2026-01-21 11:57:22',NULL,'2026-01-21 11:57:22',NULL,NULL),(128,NULL,NULL,'7e64149d7dbe41758fbef552a6a02a95',NULL,NULL,NULL,NULL,'2026-01-21 11:57:22',NULL,'2026-01-21 11:57:22',NULL,NULL),(129,NULL,NULL,NULL,NULL,'4b2556e23d3f4808b77eb06eaa56bb8d',NULL,NULL,'2026-01-21 11:57:23',NULL,'2026-01-21 11:57:23',NULL,NULL),(130,NULL,'996a4594b6c34bc596fa590dc0a5d725',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:57:24',NULL,'2026-01-21 11:57:24',NULL,NULL),(131,NULL,NULL,'b4cb20f8f9464304aa8e4013fe8e7dd3',NULL,NULL,NULL,NULL,'2026-01-21 11:57:30',NULL,'2026-01-21 11:57:30',NULL,NULL),(132,NULL,NULL,'24a560cf93534e1fa0c55bc3b8deee7f',NULL,NULL,NULL,NULL,'2026-01-21 11:57:32',NULL,'2026-01-21 11:57:32',NULL,NULL),(133,NULL,NULL,'933d2c1d7bf04b51ac88a79163d92191',NULL,NULL,NULL,NULL,'2026-01-21 11:57:32',NULL,'2026-01-21 11:57:32',NULL,NULL),(134,NULL,NULL,NULL,NULL,'55dca6ba08ce4e28a22c17f57678bace',NULL,NULL,'2026-01-21 11:57:33',NULL,'2026-01-21 11:57:33',NULL,NULL),(135,NULL,'610a29a4a80e425f83879dc98f2c9676',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:57:34',NULL,'2026-01-21 11:57:34',NULL,NULL),(136,NULL,NULL,'35a60a0b537743de97ce536de3eb8abe',NULL,NULL,NULL,NULL,'2026-01-21 11:57:35',NULL,'2026-01-21 11:57:35',NULL,NULL),(137,NULL,NULL,'205d9d16daf341efa882ff5130606792',NULL,NULL,NULL,NULL,'2026-01-21 11:57:36',NULL,'2026-01-21 11:57:36',NULL,NULL),(138,NULL,NULL,'6f26921ff8b64ba593449296089de0d5',NULL,NULL,NULL,NULL,'2026-01-21 11:57:37',NULL,'2026-01-21 11:57:37',NULL,NULL),(139,NULL,NULL,'fd4cea296e934df5b5c791fc6ec28117',NULL,NULL,NULL,NULL,'2026-01-21 11:57:38',NULL,'2026-01-21 11:57:38',NULL,NULL),(140,NULL,NULL,'47bd111a7355470d892c5a3f1ddd9d1c',NULL,NULL,NULL,NULL,'2026-01-21 11:57:40',NULL,'2026-01-21 11:57:40',NULL,NULL),(141,NULL,NULL,NULL,NULL,'db16600794634664ab9a7991189a3343',NULL,NULL,'2026-01-21 11:57:40',NULL,'2026-01-21 11:57:40',NULL,NULL),(142,NULL,'6d9f58676951409b84e51e882ef511f8',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:57:41',NULL,'2026-01-21 11:57:41',NULL,NULL),(143,NULL,NULL,'f16044894592442fb103f125a6060692',NULL,NULL,NULL,NULL,'2026-01-21 11:57:46',NULL,'2026-01-21 11:57:46',NULL,NULL),(144,NULL,NULL,'3586891ac3e24801aa16c0aa46398490',NULL,NULL,NULL,NULL,'2026-01-21 11:57:46',NULL,'2026-01-21 11:57:46',NULL,NULL),(145,NULL,NULL,'492098c473c347febbad91eb00122483',NULL,NULL,NULL,NULL,'2026-01-21 11:57:47',NULL,'2026-01-21 11:57:47',NULL,NULL),(146,NULL,NULL,'5bed60de26284688ad0cb3e6dd109914',NULL,NULL,NULL,NULL,'2026-01-21 11:57:49',NULL,'2026-01-21 11:57:49',NULL,NULL),(147,NULL,NULL,'a69b996ef97e4556ab4d1bfece26dd3b',NULL,NULL,NULL,NULL,'2026-01-21 11:57:49',NULL,'2026-01-21 11:57:49',NULL,NULL),(148,NULL,NULL,NULL,NULL,'4e64a7d41a524051bf6293401a62fce8',NULL,NULL,'2026-01-21 11:57:50',NULL,'2026-01-21 11:57:50',NULL,NULL),(149,NULL,'a6731b2bae82427a880b455378785be2',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:57:50',NULL,'2026-01-21 11:57:50',NULL,NULL),(150,NULL,NULL,'b6bafb66ca7c481b96c9873742a0e3c5',NULL,NULL,NULL,NULL,'2026-01-21 11:57:55',NULL,'2026-01-21 11:57:55',NULL,NULL),(151,NULL,NULL,NULL,NULL,'78fd354d9e174717b8b61fce8b3fa911',NULL,NULL,'2026-01-21 11:57:57',NULL,'2026-01-21 11:57:57',NULL,NULL),(152,NULL,'46333260ec0843d8aa5cb148eaa91036',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:57:57',NULL,'2026-01-21 11:57:57',NULL,NULL),(153,NULL,NULL,'fbd2a770aa5e4e1aa403c23344937f88',NULL,NULL,NULL,NULL,'2026-01-21 11:59:26',NULL,'2026-01-21 11:59:26',NULL,NULL),(154,NULL,NULL,'aa144f3bc0024ea9b9aadd9025bcff8a',NULL,NULL,NULL,NULL,'2026-01-21 11:59:26',NULL,'2026-01-21 11:59:26',NULL,NULL),(155,NULL,NULL,'664128ada5a144c4963df5f9238ebfb0',NULL,NULL,NULL,NULL,'2026-01-21 11:59:28',NULL,'2026-01-21 11:59:28',NULL,NULL),(156,NULL,NULL,NULL,NULL,'2b701cc18941499cb1f386845da1b9b2',NULL,NULL,'2026-01-21 11:59:29',NULL,'2026-01-21 11:59:29',NULL,NULL),(157,NULL,'f031647957494af6a20f295978d4d8d4',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:59:30',NULL,'2026-01-21 11:59:30',NULL,NULL),(158,NULL,NULL,'791db366810c40359396bc3ff62c279a',NULL,NULL,NULL,NULL,'2026-01-21 11:59:35',NULL,'2026-01-21 11:59:35',NULL,NULL),(159,NULL,NULL,NULL,NULL,'a90deb8c53794f5f894f642503d155b6',NULL,NULL,'2026-01-21 11:59:37',NULL,'2026-01-21 11:59:37',NULL,NULL),(160,NULL,'c029e46453ac4a25a51c0fff1db80d12',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:59:37',NULL,'2026-01-21 11:59:37',NULL,NULL),(161,NULL,NULL,NULL,NULL,'1b045cacef95437ea853ea26be5b35f8',NULL,NULL,'2026-01-21 11:59:45',NULL,'2026-01-21 11:59:45',NULL,NULL),(162,NULL,'744b0e8f38414feda7e1b025a7334ec5',NULL,NULL,NULL,NULL,NULL,'2026-01-21 11:59:45',NULL,'2026-01-21 11:59:45',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('018cd1a1506f489092d611b81627c512','swiftoperator','{}','<<null>>',NULL),('1c5fd2b15a2846629aff3c2883e22df9','admin','{}','<<null>>',NULL),('44c8d9a28d99401bb3144ae3862c456f','SwiftSystemReader','{}','<<null>>',NULL),('4c5c9f2d2de54302b926fec0864134f6','member','{}','<<null>>',NULL),('573d86e1c3f54f5d9380001e8917a873','heat_stack_user','{}','<<null>>',NULL),('841ee0e43b3f490286b6e45d6dfdf729','reader','{}','<<null>>',NULL),('9adbaa5631e548c7bc92f2fecbed6a28','ResellerAdmin','{}','<<null>>',NULL),('af657000208b444589860609500f7a2b','service','{}','<<null>>',NULL),('c785d633d7f44d05b1de51f939f1843d','SwiftProjectReader','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('1c5fd2b15a2846629aff3c2883e22df9','IMMU','true'),('4c5c9f2d2de54302b926fec0864134f6','IMMU','true'),('841ee0e43b3f490286b6e45d6dfdf729','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('048f932c6f8f433685ebdc8627504937','object-store',1,'{\"description\": \"Swift Object Storage\", \"name\": \"swift\"}'),('0631327d6b564883a26d162da0cc9da5','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('0a4b3a984ddb4675ba2558f3811cc63a','orchestration',1,'{\"description\": \"Heat API service\", \"name\": \"heat\"}'),('64f7270540f94dd9978151e62e91c207','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('6a7fb4354b6044368c2ade645b9c072f','cloudformation',1,'{\"description\": \"Heat Cloudformation API service\", \"name\": \"heat-cfn\"}'),('71e43d8eeb8c49239956edd329263dc4','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}'),('7a8148a86caf42f1bb77512b0aed9d12','identity',1,'{\"name\": \"keystone\"}'),('974b52b1ef3e4e47bb8b925467ca883d','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('a02cac0eff5346bd9262688c62e6e6dd','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('caf4289f3fa44bd6800d39ba4898b093','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}'),('ce0c65984ff1453e9095d2e9c49b9516','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','ade56004518d4d0c8dbff39b592e3f09','system','1c5fd2b15a2846629aff3c2883e22df9',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_expires` (`expires`),
  KEY `ix_token_user_id` (`user_id`),
  KEY `ix_token_expires_valid` (`expires`,`valid`),
  KEY `ix_token_trust_id` (`trust_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
INSERT INTO `trust` (`id`, `trustor_user_id`, `trustee_user_id`, `project_id`, `impersonation`, `deleted_at`, `expires_at`, `remaining_uses`, `extra`, `expires_at_int`, `redelegated_trust_id`, `redelegation_count`) VALUES ('3e95ac5ad2a449928e2ce5b1bb8ca1d5','ef2e3c75fd8442f0a8c2533f70ba24bb','4fdf2caadaf54f2eb9b4192bf7b58df8','6335f7a2d173450c9047bebcdde38d0a',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"841ee0e43b3f490286b6e45d6dfdf729\"}, {\"id\": \"4c5c9f2d2de54302b926fec0864134f6\"}]}',NULL,NULL,0),('52bb2edbbc444c0fb814d7a996a26f7e','ef2e3c75fd8442f0a8c2533f70ba24bb','4fdf2caadaf54f2eb9b4192bf7b58df8','6335f7a2d173450c9047bebcdde38d0a',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"4c5c9f2d2de54302b926fec0864134f6\"}, {\"id\": \"841ee0e43b3f490286b6e45d6dfdf729\"}]}',NULL,NULL,0),('587fe60bea9a476cbcc7ed818894ce41','ef2e3c75fd8442f0a8c2533f70ba24bb','4fdf2caadaf54f2eb9b4192bf7b58df8','6335f7a2d173450c9047bebcdde38d0a',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"841ee0e43b3f490286b6e45d6dfdf729\"}, {\"id\": \"4c5c9f2d2de54302b926fec0864134f6\"}]}',NULL,NULL,0),('5c2f5e6c8c8e4696b2c6245efc78896c','ef2e3c75fd8442f0a8c2533f70ba24bb','4fdf2caadaf54f2eb9b4192bf7b58df8','6335f7a2d173450c9047bebcdde38d0a',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"4c5c9f2d2de54302b926fec0864134f6\"}, {\"id\": \"841ee0e43b3f490286b6e45d6dfdf729\"}]}',NULL,NULL,0),('64d1e5fdf08542c3b3fd2d8a3c93b7d7','ef2e3c75fd8442f0a8c2533f70ba24bb','4fdf2caadaf54f2eb9b4192bf7b58df8','6335f7a2d173450c9047bebcdde38d0a',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"841ee0e43b3f490286b6e45d6dfdf729\"}, {\"id\": \"4c5c9f2d2de54302b926fec0864134f6\"}]}',NULL,NULL,0),('fbbea6d5a609489eafe26dbf7802e189','ef2e3c75fd8442f0a8c2533f70ba24bb','4fdf2caadaf54f2eb9b4192bf7b58df8','6335f7a2d173450c9047bebcdde38d0a',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"841ee0e43b3f490286b6e45d6dfdf729\"}, {\"id\": \"4c5c9f2d2de54302b926fec0864134f6\"}]}',NULL,NULL,0);
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
INSERT INTO `trust_role` (`trust_id`, `role_id`) VALUES ('05b2615a8a7447d5934efdff901bc23a','4c5c9f2d2de54302b926fec0864134f6'),('05b2615a8a7447d5934efdff901bc23a','841ee0e43b3f490286b6e45d6dfdf729'),('0856d842d0454b5cb51b67edeb059422','4c5c9f2d2de54302b926fec0864134f6'),('0856d842d0454b5cb51b67edeb059422','841ee0e43b3f490286b6e45d6dfdf729'),('106700c7cd834a85a6eb13f4e9b311ff','4c5c9f2d2de54302b926fec0864134f6'),('106700c7cd834a85a6eb13f4e9b311ff','841ee0e43b3f490286b6e45d6dfdf729'),('1b045cacef95437ea853ea26be5b35f8','4c5c9f2d2de54302b926fec0864134f6'),('1b045cacef95437ea853ea26be5b35f8','841ee0e43b3f490286b6e45d6dfdf729'),('2028ab04b4dc4e49bfcaa1389e304c41','4c5c9f2d2de54302b926fec0864134f6'),('2028ab04b4dc4e49bfcaa1389e304c41','841ee0e43b3f490286b6e45d6dfdf729'),('23acb0c9173f484cb410069b3e1666c2','4c5c9f2d2de54302b926fec0864134f6'),('23acb0c9173f484cb410069b3e1666c2','841ee0e43b3f490286b6e45d6dfdf729'),('24ab0fcc43a24f2fadbeac8d63bbf70c','4c5c9f2d2de54302b926fec0864134f6'),('24ab0fcc43a24f2fadbeac8d63bbf70c','841ee0e43b3f490286b6e45d6dfdf729'),('25c566be9e604c4ab3829d3a6641d2f8','4c5c9f2d2de54302b926fec0864134f6'),('25c566be9e604c4ab3829d3a6641d2f8','841ee0e43b3f490286b6e45d6dfdf729'),('27148798c5ce4ea9820375dfd0808a74','4c5c9f2d2de54302b926fec0864134f6'),('27148798c5ce4ea9820375dfd0808a74','841ee0e43b3f490286b6e45d6dfdf729'),('27ae63562612448e9ef07939fc658c04','4c5c9f2d2de54302b926fec0864134f6'),('27ae63562612448e9ef07939fc658c04','841ee0e43b3f490286b6e45d6dfdf729'),('2b701cc18941499cb1f386845da1b9b2','4c5c9f2d2de54302b926fec0864134f6'),('2b701cc18941499cb1f386845da1b9b2','841ee0e43b3f490286b6e45d6dfdf729'),('2e04295f4f154e67b8c89df7a4cbcf37','4c5c9f2d2de54302b926fec0864134f6'),('2e04295f4f154e67b8c89df7a4cbcf37','841ee0e43b3f490286b6e45d6dfdf729'),('30e87f06fcc54f019afef539b9317328','4c5c9f2d2de54302b926fec0864134f6'),('30e87f06fcc54f019afef539b9317328','841ee0e43b3f490286b6e45d6dfdf729'),('3e95ac5ad2a449928e2ce5b1bb8ca1d5','4c5c9f2d2de54302b926fec0864134f6'),('3e95ac5ad2a449928e2ce5b1bb8ca1d5','841ee0e43b3f490286b6e45d6dfdf729'),('3f1fa252b63149dfa138c870406c1f05','4c5c9f2d2de54302b926fec0864134f6'),('3f1fa252b63149dfa138c870406c1f05','841ee0e43b3f490286b6e45d6dfdf729'),('3fab8fdf8fe44e50be1d6d8a1e210451','4c5c9f2d2de54302b926fec0864134f6'),('3fab8fdf8fe44e50be1d6d8a1e210451','841ee0e43b3f490286b6e45d6dfdf729'),('422e50d7b8f3488fb88041f8b5f17383','4c5c9f2d2de54302b926fec0864134f6'),('422e50d7b8f3488fb88041f8b5f17383','841ee0e43b3f490286b6e45d6dfdf729'),('455b1ca4664d442c877f88caae0b6280','4c5c9f2d2de54302b926fec0864134f6'),('455b1ca4664d442c877f88caae0b6280','841ee0e43b3f490286b6e45d6dfdf729'),('46236679337146c6985a12d347cf9233','4c5c9f2d2de54302b926fec0864134f6'),('46236679337146c6985a12d347cf9233','841ee0e43b3f490286b6e45d6dfdf729'),('47229c5e84ea4c3cacbe4667b511eb5c','4c5c9f2d2de54302b926fec0864134f6'),('47229c5e84ea4c3cacbe4667b511eb5c','841ee0e43b3f490286b6e45d6dfdf729'),('4b2556e23d3f4808b77eb06eaa56bb8d','4c5c9f2d2de54302b926fec0864134f6'),('4b2556e23d3f4808b77eb06eaa56bb8d','841ee0e43b3f490286b6e45d6dfdf729'),('4dbe6b25b43d40d4bb5a7889dac99435','4c5c9f2d2de54302b926fec0864134f6'),('4dbe6b25b43d40d4bb5a7889dac99435','841ee0e43b3f490286b6e45d6dfdf729'),('4e64a7d41a524051bf6293401a62fce8','4c5c9f2d2de54302b926fec0864134f6'),('4e64a7d41a524051bf6293401a62fce8','841ee0e43b3f490286b6e45d6dfdf729'),('52bb2edbbc444c0fb814d7a996a26f7e','4c5c9f2d2de54302b926fec0864134f6'),('52bb2edbbc444c0fb814d7a996a26f7e','841ee0e43b3f490286b6e45d6dfdf729'),('55dca6ba08ce4e28a22c17f57678bace','4c5c9f2d2de54302b926fec0864134f6'),('55dca6ba08ce4e28a22c17f57678bace','841ee0e43b3f490286b6e45d6dfdf729'),('570a703a045344f483aba662ab019d27','4c5c9f2d2de54302b926fec0864134f6'),('570a703a045344f483aba662ab019d27','841ee0e43b3f490286b6e45d6dfdf729'),('587fe60bea9a476cbcc7ed818894ce41','4c5c9f2d2de54302b926fec0864134f6'),('587fe60bea9a476cbcc7ed818894ce41','841ee0e43b3f490286b6e45d6dfdf729'),('5c2f5e6c8c8e4696b2c6245efc78896c','4c5c9f2d2de54302b926fec0864134f6'),('5c2f5e6c8c8e4696b2c6245efc78896c','841ee0e43b3f490286b6e45d6dfdf729'),('5d6a904b67c644dfa57b48bb90fb6e71','4c5c9f2d2de54302b926fec0864134f6'),('5d6a904b67c644dfa57b48bb90fb6e71','841ee0e43b3f490286b6e45d6dfdf729'),('5ea1edbcf8dd48949404e785750925be','4c5c9f2d2de54302b926fec0864134f6'),('5ea1edbcf8dd48949404e785750925be','841ee0e43b3f490286b6e45d6dfdf729'),('60c8f8767650461faf9d4100958f76a6','4c5c9f2d2de54302b926fec0864134f6'),('60c8f8767650461faf9d4100958f76a6','841ee0e43b3f490286b6e45d6dfdf729'),('64d1e5fdf08542c3b3fd2d8a3c93b7d7','4c5c9f2d2de54302b926fec0864134f6'),('64d1e5fdf08542c3b3fd2d8a3c93b7d7','841ee0e43b3f490286b6e45d6dfdf729'),('65bac965c1bf485fa2953d0847383ffd','4c5c9f2d2de54302b926fec0864134f6'),('65bac965c1bf485fa2953d0847383ffd','841ee0e43b3f490286b6e45d6dfdf729'),('668afc65e2d44959a374c9d7d4f114b0','4c5c9f2d2de54302b926fec0864134f6'),('668afc65e2d44959a374c9d7d4f114b0','841ee0e43b3f490286b6e45d6dfdf729'),('66f8006fe1e34f77ae86bc7f17c39702','4c5c9f2d2de54302b926fec0864134f6'),('66f8006fe1e34f77ae86bc7f17c39702','841ee0e43b3f490286b6e45d6dfdf729'),('689f77cd87634e52978b032f75a79cf4','4c5c9f2d2de54302b926fec0864134f6'),('689f77cd87634e52978b032f75a79cf4','841ee0e43b3f490286b6e45d6dfdf729'),('7094159ada6e44549b4d072b4e6f1015','4c5c9f2d2de54302b926fec0864134f6'),('7094159ada6e44549b4d072b4e6f1015','841ee0e43b3f490286b6e45d6dfdf729'),('733f1a52a47b4e8a82435261421a028f','4c5c9f2d2de54302b926fec0864134f6'),('733f1a52a47b4e8a82435261421a028f','841ee0e43b3f490286b6e45d6dfdf729'),('762535e085d14f75867ea13f31f3386c','4c5c9f2d2de54302b926fec0864134f6'),('762535e085d14f75867ea13f31f3386c','841ee0e43b3f490286b6e45d6dfdf729'),('78fd354d9e174717b8b61fce8b3fa911','4c5c9f2d2de54302b926fec0864134f6'),('78fd354d9e174717b8b61fce8b3fa911','841ee0e43b3f490286b6e45d6dfdf729'),('838176548da04631b8cdb98de10b49ec','4c5c9f2d2de54302b926fec0864134f6'),('838176548da04631b8cdb98de10b49ec','841ee0e43b3f490286b6e45d6dfdf729'),('84299f8b95de44a198d986e495633b82','4c5c9f2d2de54302b926fec0864134f6'),('84299f8b95de44a198d986e495633b82','841ee0e43b3f490286b6e45d6dfdf729'),('8788151704b345468f78fa7e8ceb8294','4c5c9f2d2de54302b926fec0864134f6'),('8788151704b345468f78fa7e8ceb8294','841ee0e43b3f490286b6e45d6dfdf729'),('8b6d19b4f9134cf69bcd97e4c748abe2','4c5c9f2d2de54302b926fec0864134f6'),('8b6d19b4f9134cf69bcd97e4c748abe2','841ee0e43b3f490286b6e45d6dfdf729'),('93846e9c4c074b41aaa494e4c1a881f7','4c5c9f2d2de54302b926fec0864134f6'),('93846e9c4c074b41aaa494e4c1a881f7','841ee0e43b3f490286b6e45d6dfdf729'),('958aa48c4da94cfd8f583d74b4547e26','4c5c9f2d2de54302b926fec0864134f6'),('958aa48c4da94cfd8f583d74b4547e26','841ee0e43b3f490286b6e45d6dfdf729'),('98399daba441454388c22a0ecf3f5611','1c5fd2b15a2846629aff3c2883e22df9'),('98399daba441454388c22a0ecf3f5611','4c5c9f2d2de54302b926fec0864134f6'),('98399daba441454388c22a0ecf3f5611','841ee0e43b3f490286b6e45d6dfdf729'),('98aa830b7c5946a79d2b69e1d0e7574b','4c5c9f2d2de54302b926fec0864134f6'),('98aa830b7c5946a79d2b69e1d0e7574b','841ee0e43b3f490286b6e45d6dfdf729'),('9d54813b9d3a4bcfbb0d7a20a1ecf6ee','4c5c9f2d2de54302b926fec0864134f6'),('9d54813b9d3a4bcfbb0d7a20a1ecf6ee','841ee0e43b3f490286b6e45d6dfdf729'),('a24a5616d0df40478bac4e96b424a615','4c5c9f2d2de54302b926fec0864134f6'),('a24a5616d0df40478bac4e96b424a615','841ee0e43b3f490286b6e45d6dfdf729'),('a31bfa21889e4cc5a79109b9ea745349','4c5c9f2d2de54302b926fec0864134f6'),('a31bfa21889e4cc5a79109b9ea745349','841ee0e43b3f490286b6e45d6dfdf729'),('a475d7daf1b34ad09a59f01dc8f13ce5','4c5c9f2d2de54302b926fec0864134f6'),('a475d7daf1b34ad09a59f01dc8f13ce5','841ee0e43b3f490286b6e45d6dfdf729'),('a90deb8c53794f5f894f642503d155b6','4c5c9f2d2de54302b926fec0864134f6'),('a90deb8c53794f5f894f642503d155b6','841ee0e43b3f490286b6e45d6dfdf729'),('b78c5e83a6b24f3389c98ab09b19e0f9','4c5c9f2d2de54302b926fec0864134f6'),('b78c5e83a6b24f3389c98ab09b19e0f9','841ee0e43b3f490286b6e45d6dfdf729'),('b8c65a0cab84465d80ee836f0b1f06fe','4c5c9f2d2de54302b926fec0864134f6'),('b8c65a0cab84465d80ee836f0b1f06fe','841ee0e43b3f490286b6e45d6dfdf729'),('bbde736ce3874d6a8f9be224545a0841','4c5c9f2d2de54302b926fec0864134f6'),('bbde736ce3874d6a8f9be224545a0841','841ee0e43b3f490286b6e45d6dfdf729'),('bc3ffd6f0e8643919c5e52c409989cbc','4c5c9f2d2de54302b926fec0864134f6'),('bc3ffd6f0e8643919c5e52c409989cbc','841ee0e43b3f490286b6e45d6dfdf729'),('c4b7113d2d294f5e9aedfbc3658f2cae','4c5c9f2d2de54302b926fec0864134f6'),('c4b7113d2d294f5e9aedfbc3658f2cae','841ee0e43b3f490286b6e45d6dfdf729'),('c647bfa184e24931a7650ec4df015280','4c5c9f2d2de54302b926fec0864134f6'),('c647bfa184e24931a7650ec4df015280','841ee0e43b3f490286b6e45d6dfdf729'),('c8b48c52be9b41c4861412c9cb96fc4c','4c5c9f2d2de54302b926fec0864134f6'),('c8b48c52be9b41c4861412c9cb96fc4c','841ee0e43b3f490286b6e45d6dfdf729'),('ccc2a11c76a841f096c974525257b339','4c5c9f2d2de54302b926fec0864134f6'),('ccc2a11c76a841f096c974525257b339','841ee0e43b3f490286b6e45d6dfdf729'),('ce743e5dd79e4b17a419e804c44554a1','4c5c9f2d2de54302b926fec0864134f6'),('ce743e5dd79e4b17a419e804c44554a1','841ee0e43b3f490286b6e45d6dfdf729'),('d1c9fa1f7b86409982b3648d16af4a39','4c5c9f2d2de54302b926fec0864134f6'),('d1c9fa1f7b86409982b3648d16af4a39','841ee0e43b3f490286b6e45d6dfdf729'),('d2722ecfcdfe4791b893d4834d997b98','4c5c9f2d2de54302b926fec0864134f6'),('d2722ecfcdfe4791b893d4834d997b98','841ee0e43b3f490286b6e45d6dfdf729'),('db16600794634664ab9a7991189a3343','4c5c9f2d2de54302b926fec0864134f6'),('db16600794634664ab9a7991189a3343','841ee0e43b3f490286b6e45d6dfdf729'),('de61822dc1c84d2ba6df2d653f260fd0','4c5c9f2d2de54302b926fec0864134f6'),('de61822dc1c84d2ba6df2d653f260fd0','841ee0e43b3f490286b6e45d6dfdf729'),('e6cec711dfbb48e4a7ad517275491456','4c5c9f2d2de54302b926fec0864134f6'),('e6cec711dfbb48e4a7ad517275491456','841ee0e43b3f490286b6e45d6dfdf729'),('e913d0826cac46eb8bab71095df587ab','4c5c9f2d2de54302b926fec0864134f6'),('e913d0826cac46eb8bab71095df587ab','841ee0e43b3f490286b6e45d6dfdf729'),('e94cf01a656f4e96a64746964118128f','4c5c9f2d2de54302b926fec0864134f6'),('e94cf01a656f4e96a64746964118128f','841ee0e43b3f490286b6e45d6dfdf729'),('ebe7478de918458ea5d0e207d24f879a','1c5fd2b15a2846629aff3c2883e22df9'),('ebe7478de918458ea5d0e207d24f879a','4c5c9f2d2de54302b926fec0864134f6'),('ebe7478de918458ea5d0e207d24f879a','841ee0e43b3f490286b6e45d6dfdf729'),('f1a677cdde6d49369aff4bf3180b72be','4c5c9f2d2de54302b926fec0864134f6'),('f1a677cdde6d49369aff4bf3180b72be','841ee0e43b3f490286b6e45d6dfdf729'),('f1cbfb6fa1544cfdb70a3b5c63c0e952','4c5c9f2d2de54302b926fec0864134f6'),('f1cbfb6fa1544cfdb70a3b5c63c0e952','841ee0e43b3f490286b6e45d6dfdf729'),('fa73bea95f0b4d869b60de713c0cb008','4c5c9f2d2de54302b926fec0864134f6'),('fa73bea95f0b4d869b60de713c0cb008','841ee0e43b3f490286b6e45d6dfdf729'),('fbbea6d5a609489eafe26dbf7802e189','4c5c9f2d2de54302b926fec0864134f6'),('fbbea6d5a609489eafe26dbf7802e189','841ee0e43b3f490286b6e45d6dfdf729'),('ff1424397714432b818f5bc3986989c4','4c5c9f2d2de54302b926fec0864134f6'),('ff1424397714432b818f5bc3986989c4','841ee0e43b3f490286b6e45d6dfdf729');
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('171a520d7d0b41bd92c983b88545ed9d','{}',1,NULL,'2026-01-21 11:27:31','2026-01-21','7cca0740546d4f758ee8a3a0b88f0d11'),('28b1191f51d74f55b1a8bad42e523072','{}',1,'aeebbda5de93441581d6d2839ea5dc83','2026-01-21 11:27:33','2026-01-21','default'),('346aa228901043c8aacf73c3190b0005','{}',1,'aeebbda5de93441581d6d2839ea5dc83','2026-01-21 11:27:26','2026-01-21','default'),('4548b45b553f47658d370ca3661a9b5f','{}',1,'aeebbda5de93441581d6d2839ea5dc83','2026-01-21 11:27:28','2026-01-21','default'),('4fdf2caadaf54f2eb9b4192bf7b58df8','{}',1,'aeebbda5de93441581d6d2839ea5dc83','2026-01-21 11:27:53','2026-01-21','default'),('5f55d208cb974764b75cc63cfc0c99a2','{}',1,'aeebbda5de93441581d6d2839ea5dc83','2026-01-21 11:27:38',NULL,'default'),('755d8d6f57964bf38856c4aa4338ac1e','{}',1,'aeebbda5de93441581d6d2839ea5dc83','2026-01-21 11:27:30','2026-01-21','default'),('ade56004518d4d0c8dbff39b592e3f09','{}',1,NULL,'2026-01-21 11:26:25','2026-01-21','default'),('bf47cfa4086b48268a116c0918bb182e','{}',1,'aeebbda5de93441581d6d2839ea5dc83','2026-01-21 11:27:50','2026-01-21','default'),('c7403d5df2bc4eafa3d63e254d7c9b00','{\"tenantId\": \"773576be49dd4a13ba5ce02b0f3734a7\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2026-01-21 11:48:13',NULL,'default'),('ccb9366be88c425a8aa822d14935c5a3','{}',1,'aeebbda5de93441581d6d2839ea5dc83','2026-01-21 11:27:23','2026-01-21','default'),('ef2e3c75fd8442f0a8c2533f70ba24bb','{\"tenantId\": \"6335f7a2d173450c9047bebcdde38d0a\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2026-01-21 11:48:12','2026-01-21','default'),('f121ad4df1604e4a86b7d2c3debdfd0f','{}',1,'aeebbda5de93441581d6d2839ea5dc83','2026-01-21 11:27:21','2026-01-21','default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `mysql`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `mysql` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;

USE `mysql`;

--
-- Table structure for table `general_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `general_log` (
  `event_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `command_type` varchar(64) NOT NULL,
  `argument` mediumtext NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='General log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slow_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `slow_log` (
  `start_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `query_time` time(6) NOT NULL,
  `lock_time` time(6) NOT NULL,
  `rows_sent` bigint(20) unsigned NOT NULL,
  `rows_examined` bigint(20) unsigned NOT NULL,
  `db` varchar(512) NOT NULL,
  `last_insert_id` int(11) NOT NULL,
  `insert_id` int(11) NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `sql_text` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `rows_affected` bigint(20) unsigned NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Slow log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `column_stats`
--

DROP TABLE IF EXISTS `column_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `column_stats` (
  `db_name` varchar(64) NOT NULL,
  `table_name` varchar(64) NOT NULL,
  `column_name` varchar(64) NOT NULL,
  `min_value` varbinary(255) DEFAULT NULL,
  `max_value` varbinary(255) DEFAULT NULL,
  `nulls_ratio` decimal(12,4) DEFAULT NULL,
  `avg_length` decimal(12,4) DEFAULT NULL,
  `avg_frequency` decimal(12,4) DEFAULT NULL,
  `hist_size` tinyint(3) unsigned DEFAULT NULL,
  `hist_type` enum('SINGLE_PREC_HB','DOUBLE_PREC_HB') DEFAULT NULL,
  `histogram` varbinary(255) DEFAULT NULL,
  PRIMARY KEY (`db_name`,`table_name`,`column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='Statistics on Columns';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `column_stats`
--

LOCK TABLES `column_stats` WRITE;
/*!40000 ALTER TABLE `column_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `column_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `columns_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Table_name` char(64) NOT NULL DEFAULT '',
  `Column_name` char(64) NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `db` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_history_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT INTO `db` (`Host`, `Db`, `User`, `Select_priv`, `Insert_priv`, `Update_priv`, `Delete_priv`, `Create_priv`, `Drop_priv`, `Grant_priv`, `References_priv`, `Index_priv`, `Alter_priv`, `Create_tmp_table_priv`, `Lock_tables_priv`, `Create_view_priv`, `Show_view_priv`, `Create_routine_priv`, `Alter_routine_priv`, `Execute_priv`, `Event_priv`, `Trigger_priv`, `Delete_history_priv`) VALUES ('localhost','keystone','keystone_383b','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','keystone','keystone_383b','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','placement','placement_a0fd','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','placement','placement_a0fd','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','glance','glance_0697','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','glance','glance_0697','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','heat','heat_2619','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','heat','heat_2619','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','barbican','barbican_3c9f','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','barbican','barbican_3c9f','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','cinder','cinder_60f6','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','cinder','cinder_60f6','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','neutron','neutron_0662','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','neutron','neutron_0662','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_api','nova_api_91fe','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_api','nova_api_91fe','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_cell0','nova_cell0_90fb','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_cell0','nova_cell0_90fb','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` char(141) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','IGNORE_BAD_TABLE_OPTIONS','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH','EMPTY_STRING_IS_NULL','SIMULTANEOUS_ASSIGNMENT','TIME_ROUND_FRACTIONAL') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob DEFAULT NULL,
  PRIMARY KEY (`db`,`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `func` (
  `name` char(64) NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT 0,
  `dl` char(128) NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `global_priv`
--

DROP TABLE IF EXISTS `global_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Priv` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '{}' CHECK (json_valid(`Priv`)),
  PRIMARY KEY (`Host`,`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_priv`
--

LOCK TABLES `global_priv` WRITE;
/*!40000 ALTER TABLE `global_priv` DISABLE KEYS */;
INSERT INTO `global_priv` (`Host`, `User`, `Priv`) VALUES ('localhost','mariadb.sys','{\"access\":0,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"\",\"account_locked\":true,\"password_last_changed\":0}'),('localhost','root','{\"access\": 549755813887, \"plugin\": \"mysql_native_password\", \"authentication_string\": \"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\", \"auth_or\": [{}],\"version_id\":100529,\"password_last_changed\":1768994742}'),('%','root','{\"access\":549755813887,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\",\"password_last_changed\":1768994742}'),('localhost','keystone_383b','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*2A7DD77D36E92F0863C3B78FD0310A1A50BCEEB1\",\"password_last_changed\":1768994735}'),('%','keystone_383b','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*2A7DD77D36E92F0863C3B78FD0310A1A50BCEEB1\",\"password_last_changed\":1768994735}'),('localhost','placement_a0fd','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*C03FB7AD9BDBEACFE6F179D4C4F24AF497150913\",\"password_last_changed\":1768994735}'),('%','placement_a0fd','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*C03FB7AD9BDBEACFE6F179D4C4F24AF497150913\",\"password_last_changed\":1768994735}'),('localhost','glance_0697','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*CBC72F421FC9DF48AA89DF4097F942C6728BBE96\",\"password_last_changed\":1768994741}'),('%','glance_0697','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*CBC72F421FC9DF48AA89DF4097F942C6728BBE96\",\"password_last_changed\":1768994741}'),('localhost','heat_2619','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*79769F22364004ED53BA2AAC98AE0430F140ED28\",\"password_last_changed\":1768994773}'),('%','heat_2619','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*79769F22364004ED53BA2AAC98AE0430F140ED28\",\"password_last_changed\":1768994773}'),('localhost','barbican_3c9f','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*8D038113C5BAB0395E856EFBD1847C6CB1C7EEC6\",\"password_last_changed\":1768994773}'),('%','barbican_3c9f','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*8D038113C5BAB0395E856EFBD1847C6CB1C7EEC6\",\"password_last_changed\":1768994773}'),('localhost','cinder_60f6','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*231C47775520EA94880A2C75C995BAA3900AF2C5\",\"password_last_changed\":1768994773}'),('%','cinder_60f6','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*231C47775520EA94880A2C75C995BAA3900AF2C5\",\"password_last_changed\":1768994773}'),('localhost','neutron_0662','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*6AB35A0549D287E44E4B2AAE0AAAC5B7489E2144\",\"password_last_changed\":1768994773}'),('%','neutron_0662','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*6AB35A0549D287E44E4B2AAE0AAAC5B7489E2144\",\"password_last_changed\":1768994773}'),('localhost','nova_api_91fe','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*D93CF3BB0C1542635F1739262D2DA260D4CEB207\",\"password_last_changed\":1768994849}'),('%','nova_api_91fe','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*D93CF3BB0C1542635F1739262D2DA260D4CEB207\",\"password_last_changed\":1768994849}'),('localhost','nova_cell0_90fb','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*09B44A0494C88AAB04377B3833CCA0C9B5EB3861\",\"password_last_changed\":1768994849}'),('%','nova_cell0_90fb','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*09B44A0494C88AAB04377B3833CCA0C9B5EB3861\",\"password_last_changed\":1768994849}');
/*!40000 ALTER TABLE `global_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gtid_slave_pos`
--

DROP TABLE IF EXISTS `gtid_slave_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gtid_slave_pos` (
  `domain_id` int(10) unsigned NOT NULL,
  `sub_id` bigint(20) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `seq_no` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`domain_id`,`sub_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Replication slave GTID position';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gtid_slave_pos`
--

LOCK TABLES `gtid_slave_pos` WRITE;
/*!40000 ALTER TABLE `gtid_slave_pos` DISABLE KEYS */;
/*!40000 ALTER TABLE `gtid_slave_pos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT INTO `help_category` (`help_category_id`, `name`, `parent_category_id`, `url`) VALUES (1,'Contents',0,''),(2,'Polygon Properties',34,''),(3,'WKT',34,''),(4,'Numeric Functions',37,''),(5,'Plugins',1,''),(6,'MBR',34,''),(7,'Control Flow Functions',37,''),(8,'Transactions',1,''),(9,'Help Metadata',1,''),(10,'Account Management',1,''),(11,'Point Properties',34,''),(12,'Encryption Functions',37,''),(13,'LineString Properties',34,''),(14,'Miscellaneous Functions',37,''),(15,'Logical Operators',47,''),(16,'Functions and Modifiers for Use with GROUP BY',1,''),(17,'Information Functions',37,''),(18,'Assignment Operators',47,''),(19,'Comparison Operators',47,''),(20,'Bit Functions',37,''),(21,'Table Maintenance',1,''),(22,'User-Defined Functions',1,''),(23,'Data Types',1,''),(24,'Compound Statements',1,''),(25,'Geometry Constructors',34,''),(26,'Administration',1,''),(27,'Data Manipulation',1,''),(28,'Utility',1,''),(29,'Language Structure',1,''),(30,'Geometry Relations',34,''),(31,'Date and Time Functions',37,''),(32,'WKB',34,''),(33,'Procedures',1,''),(34,'Geographic Features',1,''),(35,'Geometry Properties',34,''),(36,'String Functions',37,''),(37,'Functions',1,''),(38,'Data Definition',1,''),(39,'Sequences',1,''),(40,'JSON Functions',37,''),(41,'Window Functions',37,''),(42,'Spider Functions',37,''),(43,'Dynamic Column Functions',37,''),(44,'Galera Functions',37,''),(45,'Temporal Tables',1,''),(46,'GeoJSON',34,''),(47,'Operators',1,''),(48,'Arithmetic Operators',47,''),(49,'Replication',1,''),(50,'Prepared Statements',1,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT INTO `help_keyword` (`help_keyword_id`, `name`) VALUES (1,'work'),(2,'locks'),(3,'locking'),(4,'drop'),(5,'super'),(6,'usage'),(7,'binlog admin'),(8,'binlog monitor'),(9,'binlog replay'),(10,'connection admin'),(11,'federated admin'),(12,'grant option'),(13,'read_only admin'),(14,'replica monitor'),(15,'replication replica'),(16,'roles'),(17,'values'),(18,'value'),(19,'not'),(20,'and'),(21,'or'),(22,':='),(23,'assignment operator'),(24,'='),(25,'!='),(26,'<>'),(27,'not equal'),(28,'less than'),(29,'less than or equal'),(30,'NULL-safe equal'),(31,'equal'),(32,'greater than'),(33,'greater than or equal'),(34,'bitwise and'),(35,'shift left'),(36,'shift right'),(37,'bitwise xor'),(38,'bitwise or'),(39,'bitwise not'),(40,'returns'),(41,'udfs'),(42,'udf calling sequences'),(43,'udf security'),(44,'int1'),(45,'int2'),(46,'int3'),(47,'integer'),(48,'int4'),(49,'int8'),(50,'dec'),(51,'numeric'),(52,'fixed'),(53,'number'),(54,'real'),(55,'double precision'),(56,'nchar'),(57,'long'),(58,'long varchar'),(59,'repeat'),(60,'declare'),(61,'cursor'),(62,'show'),(63,'columns'),(64,'kill connection'),(65,'kill query'),(66,'delete returning'),(67,'sql_big_result'),(68,'minus'),(69,'cte'),(70,'insert returning'),(71,'queries'),(72,'query'),(73,'explain format'),(74,'explain format json'),(75,'rlike'),(76,'character_length'),(77,'escape'),(78,'mode'),(79,'trim_oracle'),(80,'schedule'),(81,'row_format'),(82,'starts'),(83,'host'),(84,'generated columns'),(85,'virtual columns'),(86,'computed columns'),(87,'hidden columns'),(88,'nextval'),(89,'lastval'),(90,'+'),(91,'addition operator'),(92,'/'),(93,'division operator'),(94,'%'),(95,'modulo operator'),(96,'*'),(97,'multiplication operator'),(98,'-'),(99,'subtraction operator'),(100,'master_ssl_verify_cert'),(101,'start replica'),(102,'stop replica'),(103,'reset slave'),(104,'reset replica'),(105,'drop prepare'),(106,'deallocate prepare');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`),
  KEY `help_topic_id` (`help_topic_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT INTO `help_relation` (`help_topic_id`, `help_keyword_id`) VALUES (94,1),(97,2),(99,2),(101,2),(116,2),(147,2),(152,2),(157,2),(161,2),(162,2),(338,2),(438,2),(97,3),(99,3),(101,3),(116,3),(147,3),(152,3),(157,3),(161,3),(162,3),(338,3),(438,3),(106,4),(112,4),(250,4),(687,4),(697,4),(713,4),(714,4),(715,4),(716,4),(717,4),(718,4),(719,4),(720,4),(722,4),(723,4),(731,4),(107,5),(107,6),(107,7),(107,8),(107,9),(107,10),(107,11),(107,12),(107,13),(107,14),(107,15),(115,16),(166,17),(166,18),(167,19),(168,20),(170,21),(210,22),(210,23),(211,23),(211,24),(212,25),(212,26),(212,27),(213,28),(214,29),(215,30),(216,31),(217,32),(218,33),(232,34),(233,35),(234,36),(236,37),(237,38),(238,39),(249,40),(251,41),(252,42),(253,43),(255,44),(257,45),(258,46),(259,47),(259,48),(260,49),(261,50),(261,51),(261,52),(261,53),(263,54),(263,55),(269,56),(275,57),(275,58),(304,59),(664,59),(311,60),(311,61),(331,62),(332,62),(333,62),(334,62),(335,62),(342,62),(343,62),(344,62),(345,62),(346,62),(347,62),(354,62),(356,62),(357,62),(358,62),(359,62),(360,62),(361,62),(362,62),(363,62),(364,62),(365,62),(366,62),(367,62),(368,62),(369,62),(370,62),(371,62),(372,62),(373,62),(374,62),(375,62),(376,62),(377,62),(378,62),(379,62),(380,62),(381,62),(382,62),(383,62),(384,62),(385,62),(386,62),(387,62),(388,62),(389,62),(390,62),(391,62),(392,62),(393,62),(394,62),(395,62),(396,62),(397,62),(398,62),(408,62),(409,62),(333,63),(403,64),(403,65),(410,66),(414,67),(425,68),(431,69),(432,69),(433,69),(453,70),(460,71),(460,72),(466,73),(466,74),(622,75),(632,76),(651,77),(657,78),(678,79),(689,80),(696,81),(701,82),(707,83),(711,84),(711,85),(711,86),(712,87),(732,88),(733,89),(804,90),(804,91),(805,92),(805,93),(806,94),(806,95),(807,96),(807,97),(808,98),(808,99),(809,100),(810,101),(811,102),(812,103),(812,104),(816,105),(816,106);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
INSERT INTO `help_topic` (`help_topic_id`, `name`, `help_category_id`, `description`, `example`, `url`) VALUES (1,'HELP_DATE',9,'Help Contents generated from the MariaDB Knowledge Base on 23 January 2023.','',''),(2,'HELP_VERSION',9,'Help Contents generated for MariaDB 10.5 from the MariaDB Knowledge Base on 23 January 2023.','',''),(3,'AREA',2,'A synonym for ST_AREA.\n\nURL: https://mariadb.com/kb/en/polygon-properties-area/','','https://mariadb.com/kb/en/polygon-properties-area/'),(4,'CENTROID',2,'A synonym for ST_CENTROID.\n\nURL: https://mariadb.com/kb/en/centroid/','','https://mariadb.com/kb/en/centroid/'),(5,'ExteriorRing',2,'A synonym for ST_ExteriorRing.\n\nURL: https://mariadb.com/kb/en/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/polygon-properties-exteriorring/'),(6,'InteriorRingN',2,'A synonym for ST_InteriorRingN.\n\nURL: https://mariadb.com/kb/en/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/polygon-properties-interiorringn/'),(7,'NumInteriorRings',2,'A synonym for ST_NumInteriorRings.\n\nURL: https://mariadb.com/kb/en/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/polygon-properties-numinteriorrings/'),(8,'ST_AREA',2,'Syntax\n------\n\nST_Area(poly)\nArea(poly)\n\nDescription\n-----------\n\nReturns as a double-precision number the area of the Polygon value poly, as\nmeasured in its spatial reference system.\n\nST_Area() and Area() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\n\nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/st_area/','','https://mariadb.com/kb/en/st_area/'),(9,'ST_CENTROID',2,'Syntax\n------\n\nST_Centroid(mpoly)\nCentroid(mpoly)\n\nDescription\n-----------\n\nReturns a point reflecting the mathematical centroid (geometric center) for\nthe MultiPolygon mpoly. The resulting point will not necessarily be on the\nMultiPolygon.\n\nST_Centroid() and Centroid() are synonyms.\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0 0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n+--------------+\n| center       |\n+--------------+\n| POINT(10 10) |\n+--------------+\n\nURL: https://mariadb.com/kb/en/st_centroid/','','https://mariadb.com/kb/en/st_centroid/'),(10,'ST_ExteriorRing',2,'Syntax\n------\n\nST_ExteriorRing(poly)\nExteriorRing(poly)\n\nDescription\n-----------\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() and ExteriorRing() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_exteriorring/','','https://mariadb.com/kb/en/st_exteriorring/'),(11,'ST_InteriorRingN',2,'Syntax\n------\n\nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n\nDescription\n-----------\n\nReturns the N-th interior ring for the Polygon value poly as a LineString.\nRings are numbered beginning with 1.\n\nST_InteriorRingN() and InteriorRingN() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_interiorringn/','','https://mariadb.com/kb/en/st_interiorringn/'),(12,'ST_NumInteriorRings',2,'Syntax\n------\n\nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n\nDescription\n-----------\n\nReturns an integer containing the number of interior rings in the Polygon\nvalue poly.\n\nNote that according the the OpenGIS standard, a POLYGON should have exactly\none ExteriorRing and all other rings should lie within that ExteriorRing and\nthus be the InteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several \'ExteriorRings\'. In the case of\nthere being multiple, non-overlapping exterior rings ST_NumInteriorRings()\nwill return 1.\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/st_numinteriorrings/','','https://mariadb.com/kb/en/st_numinteriorrings/'),(14,'AsText',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-astext/','','https://mariadb.com/kb/en/wkt-astext/'),(15,'AsWKT',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-aswkt/','','https://mariadb.com/kb/en/wkt-aswkt/'),(16,'GeomCollFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/wkt-geomcollfromtext/'),(17,'GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromtext/','','https://mariadb.com/kb/en/geometrycollectionfromtext/'),(18,'GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/geometryfromtext/','','https://mariadb.com/kb/en/geometryfromtext/'),(19,'GeomFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomfromtext/','','https://mariadb.com/kb/en/wkt-geomfromtext/'),(20,'LineFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/wkt-linefromtext/','','https://mariadb.com/kb/en/wkt-linefromtext/'),(21,'LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/linestringfromtext/','','https://mariadb.com/kb/en/linestringfromtext/'),(22,'MLineFromText',3,'Syntax\n------\n\nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n\nMLineFromText() and MultiLineStringFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\nINSERT INTO gis_multi_line VALUES\n  (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16\n23,16 48))\')),\n  (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n  (MLineFromWKB(AsWKB(MultiLineString(\n   LineString(Point(1, 2), Point(3, 5)),\n   LineString(Point(2, 5), Point(5, 8), Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/mlinefromtext/','','https://mariadb.com/kb/en/mlinefromtext/'),(23,'MPointFromText',3,'Syntax\n------\n\nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nMPointFromText() and MultiPointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/mpointfromtext/','','https://mariadb.com/kb/en/mpointfromtext/'),(13,'WKT Definition',3,'Description\n-----------\n\nThe Well-Known Text (WKT) representation of Geometry is designed to exchange\ngeometry data in ASCII form. Examples of the basic geometry types include:\n\n+-----------------------------------------------------------------------------+\n| Geometry Types                                                              |\n+-----------------------------------------------------------------------------+\n| POINT                                                                       |\n+-----------------------------------------------------------------------------+\n| LINESTRING                                                                  |\n+-----------------------------------------------------------------------------+\n| POLYGON                                                                     |\n+-----------------------------------------------------------------------------+\n| MULTIPOINT                                                                  |\n+-----------------------------------------------------------------------------+\n| MULTILINESTRING                                                             |\n+-----------------------------------------------------------------------------+\n| MULTIPOLYGON                                                                |\n+-----------------------------------------------------------------------------+\n| GEOMETRYCOLLECTION                                                          |\n+-----------------------------------------------------------------------------+\n| GEOMETRY                                                                    |\n+-----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/wkt-definition/','','https://mariadb.com/kb/en/wkt-definition/'),(24,'MPolyFromText',3,'Syntax\n------\n\nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nMPolyFromText() and MultiPolygonFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(\n   LineString(Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/mpolyfromtext/','','https://mariadb.com/kb/en/mpolyfromtext/'),(25,'MultiLineStringFromText',3,'A synonym for MLineFromText.\n\nURL: https://mariadb.com/kb/en/multilinestringfromtext/','','https://mariadb.com/kb/en/multilinestringfromtext/'),(26,'MultiPointFromText',3,'A synonym for MPointFromText.\n\nURL: https://mariadb.com/kb/en/multipointfromtext/','','https://mariadb.com/kb/en/multipointfromtext/'),(27,'MultiPolygonFromText',3,'A synonym for MPolyFromText.\n\nURL: https://mariadb.com/kb/en/multipolygonfromtext/','','https://mariadb.com/kb/en/multipolygonfromtext/'),(28,'PointFromText',3,'A synonym for ST_PointFromText.\n\nURL: https://mariadb.com/kb/en/wkt-pointfromtext/','','https://mariadb.com/kb/en/wkt-pointfromtext/'),(29,'PolyFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/wkt-polyfromtext/','','https://mariadb.com/kb/en/wkt-polyfromtext/'),(30,'PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/polygonfromtext/','','https://mariadb.com/kb/en/polygonfromtext/'),(31,'ST_AsText',3,'Syntax\n------\n\nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKT representation and\nreturns the string result.\n\nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all synonyms.\n\nExamples\n--------\n\nSET @g = \'LineString(1 1,4 4,6 6)\';\n\nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6)        |\n+--------------------------------+\n\nURL: https://mariadb.com/kb/en/st_astext/','','https://mariadb.com/kb/en/st_astext/'),(32,'ST_ASWKT',3,'A synonym for ST_ASTEXT().\n\nURL: https://mariadb.com/kb/en/st_aswkt/','','https://mariadb.com/kb/en/st_aswkt/'),(33,'ST_GeomCollFromText',3,'Syntax\n------\n\nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(), GeomCollFromText() and\nGeometryCollectionFromText() are all synonyms.\n\nExample\n-------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/st_geomcollfromtext/','','https://mariadb.com/kb/en/st_geomcollfromtext/'),(34,'ST_GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/st_geometrycollectionfromtext/'),(35,'ST_GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/st_geometryfromtext/','','https://mariadb.com/kb/en/st_geometryfromtext/'),(36,'ST_GeomFromText',3,'Syntax\n------\n\nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKT representation and SRID.\n\nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n\nExample\n-------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nURL: https://mariadb.com/kb/en/st_geomfromtext/','','https://mariadb.com/kb/en/st_geomfromtext/'),(37,'ST_LineFromText',3,'Syntax\n------\n\nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nST_LineFromText(), ST_LineStringFromText(), ST_LineFromText() and\nST_LineStringFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_line  (g LINESTRING);\nSHOW FIELDS FROM gis_line;\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/st_linefromtext/','','https://mariadb.com/kb/en/st_linefromtext/'),(38,'ST_LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/st_linestringfromtext/','','https://mariadb.com/kb/en/st_linestringfromtext/'),(39,'ST_PointFromText',3,'Syntax\n------\n\nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKT representation and SRID.\n\nST_PointFromText() and PointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_point  (g POINT);\nSHOW FIELDS FROM gis_point;\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/st_pointfromtext/','','https://mariadb.com/kb/en/st_pointfromtext/'),(40,'ST_PolyFromText',3,'Syntax\n------\n\nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\'));\n\nURL: https://mariadb.com/kb/en/st_polyfromtext/','','https://mariadb.com/kb/en/st_polyfromtext/'),(41,'ST_PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/st_polygonfromtext/','','https://mariadb.com/kb/en/st_polygonfromtext/'),(42,'DIV',4,'Syntax\n------\n\nDIV\n\nDescription\n-----------\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for non-integer operands that exceed BIGINT range.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a division by zero produces\nan error. Otherwise, it returns NULL.\n\nThe remainder of a division can be obtained using the MOD operator.\n\nExamples\n--------\n\nSELECT 300 DIV 7;\n+-----------+\n| 300 DIV 7 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT 300 DIV 0;\n+-----------+\n| 300 DIV 0 |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/div/','','https://mariadb.com/kb/en/div/'),(43,'ABS',4,'Syntax\n------\n\nABS(X)\n\nDescription\n-----------\n\nReturns the absolute (non-negative) value of X. If X is not a number, it is\nconverted to a numeric type.\n\nExamples\n--------\n\nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n|      42 |\n+---------+\n\nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n|       42 |\n+----------+\n\nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n|               19940101 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/abs/','','https://mariadb.com/kb/en/abs/'),(44,'ACOS',4,'Syntax\n------\n\nACOS(X)\n\nDescription\n-----------\n\nReturns the arc cosine of X, that is, the value whose cosine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n|         NULL |\n+--------------+\n\nSELECT ACOS(0);\n+-----------------+\n| ACOS(0)         |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234)      |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/acos/','','https://mariadb.com/kb/en/acos/'),(45,'ASIN',4,'Syntax\n------\n\nASIN(X)\n\nDescription\n-----------\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns NULL if\nX is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2)          |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n\nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n\nSHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n\nURL: https://mariadb.com/kb/en/asin/','','https://mariadb.com/kb/en/asin/'),(46,'ATAN',4,'Syntax\n------\n\nATAN(X)\n\nDescription\n-----------\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nExamples\n--------\n\nSELECT ATAN(2);\n+--------------------+\n| ATAN(2)            |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n\nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2)            |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/atan/','','https://mariadb.com/kb/en/atan/'),(47,'ATAN2',4,'Syntax\n------\n\nATAN(Y,X), ATAN2(Y,X)\n\nDescription\n-----------\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both arguments\nare used to determine the quadrant of the result.\n\nExamples\n--------\n\nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2)          |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n\nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0)      |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/atan2/','','https://mariadb.com/kb/en/atan2/'),(48,'CEIL',4,'Syntax\n------\n\nCEIL(X)\n\nDescription\n-----------\n\nCEIL() is a synonym for CEILING().\n\nURL: https://mariadb.com/kb/en/ceil/','','https://mariadb.com/kb/en/ceil/'),(49,'CEILING',4,'Syntax\n------\n\nCEILING(X)\n\nDescription\n-----------\n\nReturns the smallest integer value not less than X.\n\nExamples\n--------\n\nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n|             -1 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/ceiling/','','https://mariadb.com/kb/en/ceiling/'),(51,'COS',4,'Syntax\n------\n\nCOS(X)\n\nDescription\n-----------\n\nReturns the cosine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n|        -1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/cos/','','https://mariadb.com/kb/en/cos/'),(52,'COT',4,'Syntax\n------\n\nCOT(X)\n\nDescription\n-----------\n\nReturns the cotangent of X.\n\nExamples\n--------\n\nSELECT COT(42);\n+--------------------+\n| COT(42)            |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n\nSELECT COT(12);\n+---------------------+\n| COT(12)             |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n\nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in \'cot(0)\'\n\nURL: https://mariadb.com/kb/en/cot/','','https://mariadb.com/kb/en/cot/'),(54,'DEGREES',4,'Syntax\n------\n\nDEGREES(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from radians to degrees.\n\nThis is the converse of the RADIANS() function.\n\nExamples\n--------\n\nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n|           180 |\n+---------------+\n\nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n|                90 |\n+-------------------+\n\nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45)     |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/degrees/','','https://mariadb.com/kb/en/degrees/'),(55,'EXP',4,'Syntax\n------\n\nEXP(X)\n\nDescription\n-----------\n\nReturns the value of e (the base of natural logarithms) raised to the power of\nX. The inverse of this function is LOG() (using a single argument only) or\nLN().\n\nIf X is NULL, this function returns NULL.\n\nExamples\n--------\n\nSELECT EXP(2);\n+------------------+\n| EXP(2)           |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n\nSELECT EXP(-2);\n+--------------------+\n| EXP(-2)            |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n\nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n|      1 |\n+--------+\n\nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/exp/','','https://mariadb.com/kb/en/exp/'),(50,'CONV',4,'Syntax\n------\n\nCONV(N,from_base,to_base)\n\nDescription\n-----------\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base to_base.\n\nReturns NULL if any argument is NULL, or if the second or third argument are\nnot in the allowed range.\n\nThe argument N is interpreted as an integer, but may be specified as an\ninteger or a string. The minimum base is 2 and the maximum base is 36. If\nto_base is a negative number, N is regarded as a signed number. Otherwise, N\nis treated as unsigned. CONV() works with 64-bit precision.\n\nSome shortcuts for this function are also available: BIN(), OCT(), HEX(),\nUNHEX(). Also, MariaDB allows binary literal values and hexadecimal literal\nvalues.\n\nExamples\n--------\n\nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010           |\n+----------------+\n\nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172             |\n+-----------------+\n\nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H               |\n+------------------+\n\nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42                           |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/conv/','','https://mariadb.com/kb/en/conv/'),(53,'CRC32',4,'Syntax\n------\n\n<= MariaDB 10.7\n\nCRC32(expr)\n\nFrom MariaDB 10.8\n\nCRC32([par,]expr)\n\nDescription\n-----------\n\nComputes a cyclic redundancy check (CRC) value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is expected to\nbe a string and (if possible) is treated as one if it is not.\n\nUses the ISO 3309 polynomial that used by zlib and many others. MariaDB 10.8\nintroduced the CRC32C() function, which uses the alternate Castagnoli\npolynomia.\n\nMariaDB starting with 10.8\n--------------------------\nOften, CRC is computed in pieces. To facilitate this, MariaDB 10.8.0\nintroduced an optional parameter: CRC32(\'MariaDB\')=CRC32(CRC32(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n|       4227209140 |\n+------------------+\n\nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n|       2594253378 |\n+------------------+\n\nFrom MariaDB 10.8.0\n\nSELECT CRC32(CRC32(\'Maria\'),\'DB\');\n+----------------------------+\n| CRC32(CRC32(\'Maria\'),\'DB\') |\n+----------------------------+\n|                 4227209140 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/crc32/','','https://mariadb.com/kb/en/crc32/'),(56,'FLOOR',4,'Syntax\n------\n\nFLOOR(X)\n\nDescription\n-----------\n\nReturns the largest integer value not greater than X.\n\nExamples\n--------\n\nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n|           -2 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/floor/','','https://mariadb.com/kb/en/floor/'),(57,'LN',4,'Syntax\n------\n\nLN(X)\n\nDescription\n-----------\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X. If X\nis less than or equal to 0, or NULL, then NULL is returned.\n\nThe inverse of this function is EXP().\n\nExamples\n--------\n\nSELECT LN(2);\n+-------------------+\n| LN(2)             |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n|   NULL |\n+--------+\n\nURL: https://mariadb.com/kb/en/ln/','','https://mariadb.com/kb/en/ln/'),(58,'LOG',4,'Syntax\n------\n\nLOG(X), LOG(B,X)\n\nDescription\n-----------\n\nIf called with one parameter, this function returns the natural logarithm of\nX. If X is less than or equal to 0, then NULL is returned.\n\nIf called with two parameters, it returns the logarithm of X to the base B. If\nB is <= 1 or X <= 0, the function returns NULL.\n\nIf any argument is NULL, the function returns NULL.\n\nThe inverse of this function (when called with a single argument) is the EXP()\nfunction.\n\nExamples\n--------\n\nLOG(X):\n\nSELECT LOG(2);\n+-------------------+\n| LOG(2)            |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LOG(-2);\n+---------+\n| LOG(-2) |\n+---------+\n|    NULL |\n+---------+\n\nLOG(B,X)\n\nSELECT LOG(2,16);\n+-----------+\n| LOG(2,16) |\n+-----------+\n|         4 |\n+-----------+\n\nSELECT LOG(3,27);\n+-----------+\n| LOG(3,27) |\n+-----------+\n|         3 |\n+-----------+\n\nSELECT LOG(3,1);\n+----------+\n| LOG(3,1) |\n+----------+\n|        0 |\n+----------+\n\nSELECT LOG(3,0);\n+----------+\n| LOG(3,0) |\n+----------+\n|     NULL |\n+----------+\n\nURL: https://mariadb.com/kb/en/log/','','https://mariadb.com/kb/en/log/'),(59,'LOG10',4,'Syntax\n------\n\nLOG10(X)\n\nDescription\n-----------\n\nReturns the base-10 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG10(2);\n+-------------------+\n| LOG10(2)          |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n\nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n|          2 |\n+------------+\n\nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/log10/','','https://mariadb.com/kb/en/log10/'),(60,'LOG2',4,'Syntax\n------\n\nLOG2(X)\n\nDescription\n-----------\n\nReturns the base-2 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n|                  42 |\n+---------------------+\n\nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n|          16 |\n+-------------+\n\nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n|       NULL |\n+------------+\n\nURL: https://mariadb.com/kb/en/log2/','','https://mariadb.com/kb/en/log2/'),(62,'OCT',4,'Syntax\n------\n\nOCT(N)\n\nDescription\n-----------\n\nReturns a string representation of the octal value of N, where N is a longlong\n(BIGINT) number. This is equivalent to CONV(N,10,8). Returns NULL if N is NULL.\n\nExamples\n--------\n\nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42      |\n+---------+\n\nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14      |\n+---------+\n\nURL: https://mariadb.com/kb/en/oct/','','https://mariadb.com/kb/en/oct/'),(63,'PI',4,'Syntax\n------\n\nPI()\n\nDescription\n-----------\n\nReturns the value of π (pi). The default number of decimal places displayed is\nsix, but MariaDB uses the full double-precision value internally.\n\nExamples\n--------\n\nSELECT PI();\n+----------+\n| PI()     |\n+----------+\n| 3.141593 |\n+----------+\n\nSELECT PI()+0.0000000000000000000000;\n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n|      3.1415926535897931159980 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/pi/','','https://mariadb.com/kb/en/pi/'),(64,'POW',4,'Syntax\n------\n\nPOW(X,Y)\n\nDescription\n-----------\n\nReturns the value of X raised to the power of Y.\n\nPOWER() is a synonym.\n\nExamples\n--------\n\nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n|        8 |\n+----------+\n\nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n|      0.25 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/pow/','','https://mariadb.com/kb/en/pow/'),(65,'POWER',4,'Syntax\n------\n\nPOWER(X,Y)\n\nDescription\n-----------\n\nThis is a synonym for POW(), which returns the value of X raised to the power\nof Y.\n\nURL: https://mariadb.com/kb/en/power/','','https://mariadb.com/kb/en/power/'),(61,'MOD',4,'Syntax\n------\n\nMOD(N,M), N % M, N MOD M\n\nDescription\n-----------\n\nModulo operation. Returns the remainder of N divided by M. See also Modulo\nOperator.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any number modulus zero\nproduces an error. Otherwise, it returns NULL.\n\nThe integer part of a division can be obtained using DIV.\n\nExamples\n--------\n\nSELECT 1042 % 50;\n+-----------+\n| 1042 % 50 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n|            4 |\n+--------------+\n\nSELECT 253 % 7;\n+---------+\n| 253 % 7 |\n+---------+\n|       1 |\n+---------+\n\nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n|         2 |\n+-----------+\n\nSELECT 29 MOD 9;\n+----------+\n| 29 MOD 9 |\n+----------+\n|        2 |\n+----------+\n\nURL: https://mariadb.com/kb/en/mod/','','https://mariadb.com/kb/en/mod/'),(66,'RADIANS',4,'Syntax\n------\n\nRADIANS(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from degrees to radians. Note that π radians\nequals 180 degrees.\n\nThis is the converse of the DEGREES() function.\n\nExamples\n--------\n\nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45)       |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n\nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90)     |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI())      |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n\nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180)     |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/radians/','','https://mariadb.com/kb/en/radians/'),(67,'RAND',4,'Syntax\n------\n\nRAND(), RAND(N)\n\nDescription\n-----------\n\nReturns a random DOUBLE precision floating point value v in the range 0 <= v <\n1.0. If a constant integer argument N is specified, it is used as the seed\nvalue, which produces a repeatable sequence of column values. In the example\nbelow, note that the sequences of values produced by RAND(3) is the same both\nplaces where it occurs.\n\nIn a WHERE clause, RAND() is evaluated each time the WHERE is executed.\n\nStatements using the RAND() function are not safe for statement-based\nreplication.\n\nPractical uses\n--------------\n\nThe expression to get a random integer from a given range is the following:\n\nFLOOR(min_value + RAND() * (max_value - min_value +1))\n\nRAND() is often used to read random rows from a table, as follows:\n\nSELECT * FROM my_table ORDER BY RAND() LIMIT 10;\n\nNote, however, that this technique should never be used on a large table as it\nwill be extremely slow. MariaDB will read all rows in the table, generate a\nrandom value for each of them, order them, and finally will apply the LIMIT\nclause.\n\nExamples\n--------\n\nCREATE TABLE t (i INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.255651095188829 |\n|    2 | 0.833920199269355 |\n|    3 |  0.40264774151393 |\n+------+-------------------+\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.511478140495232 |\n|    2 | 0.349447508668012 |\n|    3 | 0.212803152588013 |\n+------+-------------------+\n\nUsing the same seed, the same sequence will be returned:\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nGenerating a random number from 5 to 15:\n\nSELECT FLOOR(5 + (RAND() * 11));\n\nURL: https://mariadb.com/kb/en/rand/','','https://mariadb.com/kb/en/rand/'),(68,'ROUND',4,'Syntax\n------\n\nROUND(X), ROUND(X,D)\n\nDescription\n-----------\n\nRounds the argument X to D decimal places. D defaults to 0 if not specified. D\ncan be negative to cause D digits left of the decimal point of the value X to\nbecome zero.\n\nThe rounding algorithm depends on the data type of X:\n\n* for floating point types (FLOAT, DOUBLE) the C libraries rounding function\nis used, so the behavior *may* differ between operating systems\n* for fixed point types (DECIMAL, DEC/NUMBER/FIXED) the \"round half up\" rule\nis used, meaning that e.g. a value ending in exactly .5 is always rounded up.\n\nExamples\n--------\n\nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n|           -1 |\n+--------------+\n\nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n|           -2 |\n+--------------+\n\nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n|           2 |\n+-------------+\n\nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n|             1.3 |\n+-----------------+\n\nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n|                20 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/round/','','https://mariadb.com/kb/en/round/'),(69,'SIGN',4,'Syntax\n------\n\nSIGN(X)\n\nDescription\n-----------\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X is\nnegative, zero, or positive.\n\nExamples\n--------\n\nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n|        -1 |\n+-----------+\n\nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n|       0 |\n+---------+\n\nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/sign/','','https://mariadb.com/kb/en/sign/'),(70,'SIN',4,'Syntax\n------\n\nSIN(X)\n\nDescription\n-----------\n\nReturns the sine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT SIN(PI());\n+----------------------+\n| SIN(PI())            |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n\nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n|                0 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/sin/','','https://mariadb.com/kb/en/sin/'),(71,'SQRT',4,'Syntax\n------\n\nSQRT(X)\n\nDescription\n-----------\n\nReturns the square root of X. If X is negative, NULL is returned.\n\nExamples\n--------\n\nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n|       2 |\n+---------+\n\nSELECT SQRT(20);\n+------------------+\n| SQRT(20)         |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n\nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n|         42 |\n+------------+\n\nURL: https://mariadb.com/kb/en/sqrt/','','https://mariadb.com/kb/en/sqrt/'),(72,'TAN',4,'Syntax\n------\n\nTAN(X)\n\nDescription\n-----------\n\nReturns the tangent of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n|      0.9999999999999999 |\n+-------------------------+\n\nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI())             |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n\nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1)     |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n\nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/tan/','','https://mariadb.com/kb/en/tan/'),(73,'TRUNCATE',4,'This page documents the TRUNCATE function. See TRUNCATE TABLE for the DDL\nstatement.\n\nSyntax\n------\n\nTRUNCATE(X,D)\n\nDescription\n-----------\n\nReturns the number X, truncated to D decimal places. If D is 0, the result has\nno decimal point or fractional part. D can be negative to cause D digits left\nof the decimal point of the value X to become zero.\n\nExamples\n--------\n\nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n|               1.2 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n|               1.9 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n|               -1.9 |\n+--------------------+\n\nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n|              100 |\n+------------------+\n\nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n|                  1028 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/truncate/','','https://mariadb.com/kb/en/truncate/'),(74,'INSTALL PLUGIN',5,'Syntax\n------\n\nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement installs an individual plugin from the specified library. To\ninstall the whole library (which could be required), use INSTALL SONAME. See\nalso Installing a Plugin.\n\nplugin_name is the name of the plugin as defined in the plugin declaration\nstructure contained in the library file. Plugin names are not case sensitive.\nFor maximal compatibility, plugin names should be limited to ASCII letters,\ndigits, and underscore, because they are used in C source files, shell command\nlines, M4 and Bourne shell scripts, and SQL environments.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension can be omitted (which makes the statement look\nthe same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nINSTALL PLUGIN causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nPLUGIN only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a note instead of\nan error if the specified plugin already exists. See SHOW WARNINGS.\n\nExamples\n--------\n\nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n\nThe extension can also be omitted:\n\nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected (0.104 sec)\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------+\n| Level | Code | Message                            |\n+-------+------+------------------------------------+\n| Note  | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n\nURL: https://mariadb.com/kb/en/install-plugin/','','https://mariadb.com/kb/en/install-plugin/'),(78,'Plugin Overview',5,'Plugins are server components that enhance MariaDB in some way. These can be\nanything from new storage engines, plugins for enhancing full-text parsing, or\neven small enhancements, such as a plugin to get a timestamp as an integer.\n\nQuerying Plugin Information\n---------------------------\n\nThere are a number of ways to see which plugins are currently active.\n\nA server almost always has a large number of active plugins, because the\nserver contains a large number of built-in plugins, which are active by\ndefault and cannot be uninstalled.\n\nQuerying Plugin Information with SHOW PLUGINS\n---------------------------------------------\n\nThe SHOW PLUGINS statement can be used to query information about all active\nplugins.\n\nFor example:\n\nSHOW PLUGINS\\G;\n********************** 1. row **********************\n Name: binlog\n Status: ACTIVE\n Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n********************** 2. row **********************\n Name: mysql_native_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n********************** 3. row **********************\n Name: mysql_old_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n...\n\nIf a plugin\'s Library column has a NULL value, then the plugin is built-in,\nand it cannot be uninstalled.\n\nQuerying Plugin Information with information_schema.PLUGINS\n-----------------------------------------------------------\n\nThe information_schema.PLUGINS table can be queried to get more detailed\ninformation about plugins.\n\nFor example:\n\nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row ***************************\n     PLUGIN_NAME: CSV\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: Brian Aker, MySQL AB\n  PLUGIN_DESCRIPTION: CSV storage engine\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row ***************************\n     PLUGIN_NAME: MEMORY\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: MySQL AB\n  PLUGIN_DESCRIPTION: Hash based, stored in memory, useful for temporary\ntables\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n\nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value, then the plugin is\nbuilt-in, and it cannot be uninstalled.\n\nQuerying Plugin Information with mysql.plugin\n---------------------------------------------\n\nThe mysql.plugin table can be queried to get information about installed\nplugins.\n\nThis table only contains information about plugins that have been installed\nvia the following methods:\n\n* The INSTALL SONAME statement.\n* The INSTALL PLUGIN statement.\n* The mysql_plugin utility.\n\nThis table does not contain information about:\n\n* Built-in plugins.\n* Plugins loaded with the --plugin-load-add option.\n* Plugins loaded with the --plugin-load option.\n\nThis table only contains enough information to reload the plugin when the\nserver is restarted, which means it only contains the plugin name and the\nplugin library.\n\nFor example:\n\nSELECT * FROM mysql.plugin;\n\n+------+------------+\n| name | dl         |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n\nInstalling a Plugin\n-------------------\n\nThere are three primary ways to install a plugin:\n\n* A plugin can be installed dynamically with an SQL statement.\n* A plugin can be installed with a mysqld option, but it requires a server\nrestart.\n* A plugin can be installed with the mysql_plugin utility, while the server is\ncompletely offline.\n\nWhen you are installing a plugin, you also have to ensure that:\n\n* The server\'s plugin directory is properly configured, and the plugin\'s\nlibrary is in the plugin directory.\n* The server\'s minimum plugin maturity is properly configured, and the plugin\nis mature enough to be installed.\n\nInstalling a Plugin Dynamically\n-------------------------------\n\nA plugin can be installed dynamically by executing either the INSTALL SONAME\nor the INSTALL PLUGIN statement.\n\nIf a plugin is installed with one of these statements, then a record will be\nadded to the mysql.plugins table for the plugin. This means that the plugin\nwill automatically be loaded every time the server restarts, unless\nspecifically uninstalled or deactivated.\n\nInstalling a Plugin with INSTALL SONAME\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL SONAME\nstatement. INSTALL SONAME installs all plugins from the given plugin library.\nThis could be required for some plugin libraries.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin), you could execute the\nfollowing:\n\nINSTALL SONAME \'server_audit\';\n\nInstalling a Plugin with INSTALL PLUGIN\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL PLUGIN\nstatement. INSTALL PLUGIN installs a single plugin from the given plugin\nlibrary.\n\nFor example, to install the server_audit audit plugin from the server_audit\nplugin library, you could execute the following:\n\nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n\nInstalling a Plugin with Plugin Load Options\n--------------------------------------------\n\nA plugin can be installed with a mysqld option by providing either the\n--plugin-load-add or the --plugin-load option.\n\nIf a plugin is installed with one of these options, then a record will not be\nadded to the mysql.plugins table for the plugin. This means that if the server\nis restarted without the same option set, then the plugin will not\nautomatically be loaded.\n\nInstalling a Plugin with --plugin-load-add\n------------------------------------------\n\nYou can install a plugin with the --plugin-load-add option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load-add option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nSpecial care must be taken when specifying both the --plugin-load option and\nthe --plugin-load-add option together. The --plugin-load option resets the\nplugin load list, and this can cause unexpected problems if you are not aware.\nThe --plugin-load-add option does not reset the plugin load list, so it is\nmuch safer to use. See Specifying Multiple Plugin Load Options for more\ninformation.\n\nInstalling a Plugin with --plugin-load\n--------------------------------------\n\nYou can install a plugin with the --plugin-load option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load=\'server_audit;ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option together. The --plugin-load option resets the plugin\nload list, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use. See Specifying Multiple Plugin Load Options for more information.\n\nSpecifying Multiple Plugin Load Options\n---------------------------------------\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use.\n\nThis can have the following consequences:\n\n* If the --plugin-load option is specified multiple times, then only the last\ninstance will have any effect. For example, in the following case, the first\ninstance of the option is reset:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* If the --plugin-load option is specified after the --plugin-load-add option,\nthen it will also reset the changes made by that option. For example, in the\nfollowing case, the --plugin-load-add option does not do anything, because the\nsubsequent --plugin-load option resets the plugin load list:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* In contrast, if the --plugin-load option is specified before the\n--plugin-load-add option, then it will work fine, because the\n--plugin-load-add option does not reset the plugin load list. For example, in\nthe following case, both plugins are properly loaded:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nInstalling a Plugin with mysql_plugin\n-------------------------------------\n\nA plugin can be installed with the mysql_plugin utility if the server is\ncompletely offline.\n\nThe syntax is:\n\nmysql_plugin [options] <plugin> ENABLE|DISABLE\n\nFor example, to install the server_audit audit plugin, you could execute the\nfollowing:\n\nmysql_plugin server_audit ENABLE\n\nIf a plugin is installed with this utility, then a record will be added to the\nmysql.plugins table for the plugin. This means that the plugin will\nautomatically be loaded every time the server restarts, unless specifically\nuninstalled or deactivated.\n\nConfiguring the Plugin Directory\n--------------------------------\n\nWhen a plugin is being installed, the server looks for the plugin\'s library in\nthe server\'s plugin directory. This directory is configured by the plugin_dir\nsystem variable. This can be specified as a command-line argument to mysqld or\nit can be specified in a relevant server option group in an option file. For\nexample:\n\n[mariadb]\n...\nplugin_dir = /usr/lib64/mysql/plugin\n\nConfiguring the Minimum Plugin Maturity\n---------------------------------------\n\nWhen a plugin is being installed, the server compares the plugin\'s maturity\nlevel against the server\'s minimum allowed plugin maturity. This can help\nprevent users from using unstable plugins on production servers. This minimum\nplugin maturity is configured by the plugin_maturity system variable. This can\nbe specified as a command-line argument to mysqld or it can be specified in a\nrelevant server option group in an option file. For example:\n\n[mariadb]\n...\nplugin_maturity = stable\n\nConfiguring Plugin Activation at Server Startup\n-----------------------------------------------\n\nA plugin will be loaded by default when the server starts if:\n\n* The plugin was installed with the INSTALL SONAME statement.\n* The plugin was installed with the INSTALL PLUGIN statement.\n* The plugin was installed with the mysql_plugin utility.\n* The server is configured to load the plugin with the --plugin-load-add\noption.\n* The server is configured to load the plugin with the --plugin-load option.\n\nThis behavior can be changed with special options that take the form\n--plugin-name. For example, for the server_audit audit plugin, the special\noption is called --server-audit.\n\nThe possible values for these special options are:\n\n+---------------------------------------+------------------------------------+\n| Option Value                          | Description                        |\n+---------------------------------------+------------------------------------+\n| OFF                                   | Disables the plugin without        |\n|                                       | removing it from the               |\n|                                       | mysql.plugins table.               |\n+---------------------------------------+------------------------------------+\n| ON                                    | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will still continue         |\n|                                       | starting up, but the plugin will   |\n|                                       | be disabled.                       |\n+---------------------------------------+------------------------------------+\n| FORCE                                 | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error.                             |\n+---------------------------------------+------------------------------------+\n| FORCE_PLUS_PERMANENT                  | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error. In addition, the plugin     |\n|                                       | cannot be uninstalled with         |\n|                                       | UNINSTALL SONAME or UNINSTALL      |\n|                                       | PLUGIN while the server is         |\n|                                       | running.                           |\n+---------------------------------------+------------------------------------+\n\nA plugin\'s status can be found by looking at the PLUGIN_STATUS column of the\ninformation_schema.PLUGINS table.\n\nUninstalling Plugins\n--------------------\n\nPlugins that are found in the mysql.plugin table, that is those that were\ninstalled with INSTALL SONAME, INSTALL PLUGIN or mysql_plugin can be\nuninstalled in one of two ways:\n\n* The UNINSTALL SONAME or the UNINSTALL PLUGIN statement while the server is\nrunning\n* With mysql_plugin while the server is offline.\n\nPlugins that were enabled as a --plugin-load option do not need to be\nuninstalled. If --plugin-load is omitted the next time the server starts, or\nthe plugin is not listed as one of the --plugin-load entries, the plugin will\nnot be loaded.\n\nUNINSTALL PLUGIN uninstalls a single installed plugin, while UNINSTALL SONAME\nuninstalls all plugins belonging to a given library.\n\nURL: https://mariadb.com/kb/en/plugin-overview/','','https://mariadb.com/kb/en/plugin-overview/'),(79,'MBR Definition',6,'Description\n-----------\n\nThe MBR (Minimum Bounding Rectangle), or Envelope is the bounding geometry,\nformed by the minimum and maximum (X,Y) coordinates:\n\nExamples\n--------\n\n((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n\nURL: https://mariadb.com/kb/en/mbr-definition/','','https://mariadb.com/kb/en/mbr-definition/'),(80,'MBRContains',6,'Syntax\n------\n\nMBRContains(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\ncontains the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRWithin().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\n\nSET @g2 = GeomFromText(\'Point(1 1)\');\n\nSELECT MBRContains(@g1,@g2), MBRContains(@g2,@g1);\n+----------------------+----------------------+\n| MBRContains(@g1,@g2) | MBRContains(@g2,@g1) |\n+----------------------+----------------------+\n|                    1 |                    0 |\n+----------------------+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrcontains/','','https://mariadb.com/kb/en/mbrcontains/'),(82,'MBREqual',6,'Syntax\n------\n\nMBREqual(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are the same.\n\nExamples\n--------\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 2)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 2, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 3)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 4, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 0 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/mbrequal/','','https://mariadb.com/kb/en/mbrequal/'),(86,'MBRWithin',6,'Syntax\n------\n\nMBRWithin(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1 is\nwithin the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRContains().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((0 0,0 5,5 5,5 0,0 0))\');\nSELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+\n\nURL: https://mariadb.com/kb/en/mbrwithin/','','https://mariadb.com/kb/en/mbrwithin/'),(75,'UNINSTALL PLUGIN',5,'Syntax\n------\n\nUNINSTALL PLUGIN [IF EXISTS] plugin_name\n\nDescription\n-----------\n\nThis statement removes a single installed plugin. To uninstall the whole\nlibrary which contains the plugin, use UNINSTALL SONAME. You cannot uninstall\na plugin if any table that uses it is open.\n\nplugin_name must be the name of some plugin that is listed in the mysql.plugin\ntable. The server executes the plugin\'s deinitialization function and removes\nthe row for the plugin from the mysql.plugin table, so that subsequent server\nrestarts will not load and initialize the plugin. UNINSTALL PLUGIN does not\nremove the plugin\'s shared library file.\n\nTo use UNINSTALL PLUGIN, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nUNINSTALL PLUGIN example;\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------+\n| Level | Code | Message                       |\n+-------+------+-------------------------------+\n| Note  | 1305 | PLUGIN example does not exist |\n+-------+------+-------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-plugin/','','https://mariadb.com/kb/en/uninstall-plugin/'),(76,'INSTALL SONAME',5,'Syntax\n------\n\nINSTALL SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of INSTALL PLUGIN. It installs all plugins from a\ngiven plugin_library. See INSTALL PLUGIN for details.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL SONAME adds one or more lines to the mysql.plugin table that describes\nthe plugin. This table contains the plugin name and library file name.\n\nINSTALL SONAME causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL SONAME also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL SONAME, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nSONAME only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nIf you need to install only one plugin from a library, use the INSTALL PLUGIN\nstatement.\n\nExamples\n--------\n\nTo load the XtraDB storage engine and all of its information_schema tables\nwith one statement, use\n\nINSTALL SONAME \'ha_xtradb\';\n\nThis statement can be used instead of INSTALL PLUGIN even when the library\ncontains only one plugin:\n\nINSTALL SONAME \'ha_sequence\';\n\nURL: https://mariadb.com/kb/en/install-soname/','','https://mariadb.com/kb/en/install-soname/'),(77,'UNINSTALL SONAME',5,'Syntax\n------\n\nUNINSTALL SONAME  [IF EXISTS] \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of UNINSTALL PLUGIN statement, that removes all\nplugins belonging to a specified plugin_library. See UNINSTALL PLUGIN for\ndetails.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nTo use UNINSTALL SONAME, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin library does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nTo uninstall the XtraDB plugin and all of its information_schema tables with\none statement, use\n\nUNINSTALL SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------------+\n| Level | Code | Message                             |\n+-------+------+-------------------------------------+\n| Note  | 1305 | SONAME ha_example.so does not exist |\n+-------+------+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-soname/','','https://mariadb.com/kb/en/uninstall-soname/'),(90,'NULLIF',7,'Syntax\n------\n\nNULLIF(expr1,expr2)\n\nDescription\n-----------\n\nReturns NULL if expr1 = expr2 is true, otherwise returns expr1. This is the\nsame as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1 END.\n\nExamples\n--------\n\nSELECT NULLIF(1,1);\n+-------------+\n| NULLIF(1,1) |\n+-------------+\n|        NULL |\n+-------------+\n\nSELECT NULLIF(1,2);\n+-------------+\n| NULLIF(1,2) |\n+-------------+\n|           1 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/nullif/','','https://mariadb.com/kb/en/nullif/'),(91,'NVL',7,'MariaDB starting with 10.3\n--------------------------\nFrom MariaDB 10.3, NVL is a synonym for IFNULL.\n\nURL: https://mariadb.com/kb/en/nvl/','','https://mariadb.com/kb/en/nvl/'),(92,'NVL2',7,'MariaDB starting with 10.3\n--------------------------\nThe NLV2 function was introduced in MariaDB 10.3.0.\n\nSyntax\n------\n\nNVL2(expr1,expr2,expr3)\n\nDescription\n-----------\n\nThe NVL2 function returns a value based on whether a specified expression is\nNULL or not. If expr1 is not NULL, then NVL2 returns expr2. If expr1 is NULL,\nthen NVL2 returns expr3.\n\nExamples\n--------\n\nSELECT NVL2(NULL,1,2);\n+----------------+\n| NVL2(NULL,1,2) |\n+----------------+\n|              2 |\n+----------------+\n\nSELECT NVL2(\'x\',1,2);\n+---------------+\n| NVL2(\'x\',1,2) |\n+---------------+\n|             1 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/nvl2/','','https://mariadb.com/kb/en/nvl2/'),(81,'MBRDisjoint',6,'Syntax\n------\n\nMBRDisjoint(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are disjoint. Two geometries are disjoint if they do not\nintersect, that is touch or overlap.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECTmbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrdisjoint/','','https://mariadb.com/kb/en/mbrdisjoint/'),(83,'MBRIntersects',6,'Syntax\n------\n\nMBRIntersects(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 intersect.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      1 |\n+------------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      0 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/mbrintersects/','','https://mariadb.com/kb/en/mbrintersects/'),(84,'MBROverlaps',6,'Syntax\n------\n\nMBROverlaps(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 overlap. The term spatially overlaps is used if two\ngeometries intersect and their intersection results in a geometry of the same\ndimension but not equal to either of the given geometries.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbroverlaps/','','https://mariadb.com/kb/en/mbroverlaps/'),(85,'MBRTouches',6,'Syntax\n------\n\nMBRTouches(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 touch. Two geometries spatially touch if the interiors of\nthe geometries do not intersect, but the boundary of one of the geometries\nintersects either the boundary or the interior of the other.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   1 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/mbrtouches/','','https://mariadb.com/kb/en/mbrtouches/'),(87,'CASE OPERATOR',7,'Syntax\n------\n\nCASE value WHEN [compare_value] THEN result [WHEN [compare_value] THEN\nresult ...] [ELSE result] END\n\nCASE WHEN [condition] THEN result [WHEN [condition] THEN result ...]\n[ELSE result] END\n\nDescription\n-----------\n\nThe first version returns the result where value=compare_value. The second\nversion returns the result for the first condition that is true. If there was\nno matching result value, the result after ELSE is returned, or NULL if there\nis no ELSE part.\n\nThere is also a CASE statement, which differs from the CASE operator described\nhere.\n\nExamples\n--------\n\nSELECT CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END;\n+------------------------------------------------------------+\n| CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END |\n+------------------------------------------------------------+\n| one                                                        |\n+------------------------------------------------------------+\n\nSELECT CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END;\n+--------------------------------------------+\n| CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END |\n+--------------------------------------------+\n| true                                       |\n+--------------------------------------------+\n\nSELECT CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END;\n+-----------------------------------------------------+\n| CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END |\n+-----------------------------------------------------+\n|                                                NULL |\n+-----------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/case-operator/','','https://mariadb.com/kb/en/case-operator/'),(101,'UNLOCK TABLES',8,'Syntax\n------\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\nSee LOCK TABLES for more information.\n\nIn addition to releasing table locks acquired by the LOCK TABLES statement,\nthe UNLOCK TABLES statement also releases the global read lock acquired by the\nFLUSH TABLES WITH READ LOCK statement. The FLUSH TABLES WITH READ LOCK\nstatement is very useful for performing backups. See FLUSH for more\ninformation about FLUSH TABLES WITH READ LOCK.\n\nURL: https://mariadb.com/kb/en/transactions-unlock-tables/','','https://mariadb.com/kb/en/transactions-unlock-tables/'),(103,'XA Transactions',8,'Overview\n--------\n\nThe MariaDB XA implementation is based on the X/Open CAE document Distributed\nTransaction Processing: The XA Specification. This document is published by\nThe Open Group and available at\nhttp://www.opengroup.org/public/pubs/catalog/c193.htm.\n\nXA transactions are designed to allow distributed transactions, where a\ntransaction manager (the application) controls a transaction which involves\nmultiple resources. Such resources are usually DBMSs, but could be resources\nof any type. The whole set of required transactional operations is called a\nglobal transaction. Each subset of operations which involve a single resource\nis called a local transaction. XA used a 2-phases commit (2PC). With the first\ncommit, the transaction manager tells each resource to prepare an effective\ncommit, and waits for a confirm message. The changes are not still made\neffective at this point. If any of the resources encountered an error, the\ntransaction manager will rollback the global transaction. If all resources\ncommunicate that the first commit is successful, the transaction manager can\nrequire a second commit, which makes the changes effective.\n\nIn MariaDB, XA transactions can only be used with storage engines that support\nthem. At least InnoDB, TokuDB, SPIDER and MyRocks support them. For InnoDB,\nuntil MariaDB 10.2, XA transactions can be disabled by setting the\ninnodb_support_xa server system variable to 0. From MariaDB 10.3, XA\ntransactions are always supported.\n\nLike regular transactions, XA transactions create metadata locks on accessed\ntables.\n\nXA transactions require REPEATABLE READ as a minimum isolation level. However,\ndistributed transactions should always use SERIALIZABLE.\n\nTrying to start more than one XA transaction at the same time produces a 1400\nerror (SQLSTATE \'XAE09\'). The same error is produced when attempting to start\nan XA transaction while a regular transaction is in effect. Trying to start a\nregular transaction while an XA transaction is in effect produces a 1399 error\n(SQLSTATE \'XAE07\').\n\nThe statements that cause an implicit COMMIT for regular transactions produce\na 1400 error (SQLSTATE \'XAE09\') if a XA transaction is in effect.\n\nInternal XA vs External XA\n--------------------------\n\nXA transactions are an overloaded term in MariaDB. If a storage engine is\nXA-capable, it can mean one or both of these:\n\n* It supports MariaDB\'s internal two-phase commit API. This is transparent to\nthe user. Sometimes this is called \"internal XA\", since MariaDB\'s internal\ntransaction coordinator log can handle coordinating these transactions.\n\n* It supports XA transactions, with the XA START, XA PREPARE, XA COMMIT, etc.\nstatements. Sometimes this is called \"external XA\", since it requires the use\nof an external transaction coordinator to use this feature properly.\n\nTransaction Coordinator Log\n---------------------------\n\nIf you have two or more XA-capable storage engines enabled, then a transaction\ncoordinator log must be available.\n\nThere are currently two implementations of the transaction coordinator log:\n\n* Binary log-based transaction coordinator log\n* Memory-mapped file-based transaction coordinator log\n\nIf the binary log is enabled on a server, then the server will use the binary\nlog-based transaction coordinator log. Otherwise, it will use the\nmemory-mapped file-based transaction coordinator log.\n\nSee Transaction Coordinator Log for more information.\n\nSyntax\n------\n\nXA {START|BEGIN} xid [JOIN|RESUME]\n\nXA END xid [SUSPEND [FOR MIGRATE]]\n\nXA PREPARE xid\n\nXA COMMIT xid [ONE PHASE]\n\nXA ROLLBACK xid\n\nXA RECOVER [FORMAT=[\'RAW\'|\'SQL\']]\n\nxid: gtrid [, bqual [, formatID ]]\n\nThe interface to XA transactions is a set of SQL statements starting with XA.\nEach statement changes a transaction\'s state, determining which actions it can\nperform. A transaction which does not exist is in the NON-EXISTING state.\n\nXA START (or BEGIN) starts a transaction and defines its xid (a transaction\nidentifier). The JOIN or RESUME keywords have no effect. The new transaction\nwill be in ACTIVE state.\n\nThe xid can have 3 components, though only the first one is mandatory. gtrid\nis a quoted string representing a global transaction identifier. bqual is a\nquoted string representing a local transaction identifier. formatID is an\nunsigned integer indicating the format used for the first two components; if\nnot specified, defaults to 1. MariaDB does not interpret in any way these\ncomponents, and only uses them to identify a transaction. xids of transactions\nin effect must be unique.\n\nXA END declares that the specified ACTIVE transaction is finished and it\nchanges its state to IDLE. SUSPEND [FOR MIGRATE] has no effect.\n\nXA PREPARE prepares an IDLE transaction for commit, changing its state to\nPREPARED. This is the first commit.\n\nXA COMMIT definitely commits and terminates a transaction which has already\nbeen PREPARED. If the ONE PHASE clause is specified, this statements performs\na 1-phase commit on an IDLE transaction.\n\nXA ROLLBACK rolls back and terminates an IDLE or PREPARED transaction.\n\nXA RECOVER shows information about all PREPARED transactions.\n\nWhen trying to execute an operation which is not allowed for the transaction\'s\ncurrent state, an error is produced:\n\nXA COMMIT \'test\' ONE PHASE;\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  ACTIVE state\n\nXA COMMIT \'test2\';\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  NON-EXISTING state\n\nXA RECOVER\n----------\n\nThe XA RECOVER statement shows information about all transactions which are in\nthe PREPARED state. It does not matter which connection created the\ntransaction: if it has been PREPARED, it appears. But this does not mean that\na connection can commit or rollback a transaction which was started by another\nconnection. Note that transactions using a 1-phase commit are never in the\nPREPARED state, so they cannot be shown by XA RECOVER.\n\nXA RECOVER produces four columns:\n\nXA RECOVER;\n+----------+--------------+--------------+------+\n| formatID | gtrid_length | bqual_length | data |\n+----------+--------------+--------------+------+\n|        1 |            4 |            0 | test |\n+----------+--------------+--------------+------+\n\nMariaDB starting with 10.3.3\n----------------------------\nYou can use XA RECOVER FORMAT=\'SQL\' to get the data in a human readable form\nthat can be directly copy-pasted into XA COMMIT or XA ROLLBACK. This is\nparticularly useful for binary xid generated by some transaction coordinators.\n\nformatID is the formatID part of xid.\n\ndata are the gtrid and bqual parts of xid, concatenated.\n\ngtrid_length and bqual_length are the lengths of gtrid and bqual, respectevely.\n\nExamples\n--------\n\n2-phases commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA PREPARE \'test\';\n\nXA COMMIT \'test\';\n\n1-phase commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA COMMIT \'test\' ONE PHASE;\n\nHuman-readable:\n\nxa start \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\ninsert t1 values (40);\n\nxa end \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa prepare \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa recover format=\'RAW\';\n+----------+--------------+--------------+--------------------+\n| formatID | gtrid_length | bqual_length | data               |\n+----------+--------------+--------------+--------------------+\n34      67v78abc       11 |            7 | 12\ndef |\n+----------+--------------+--------------+--------------------+\n\nxa recover format=\'SQL\';\n+----------+--------------+--------------+-------------------------------------\n---------+\n| formatID | gtrid_length | bqual_length | data                               \n     |\n+----------+--------------+--------------+-------------------------------------\n---------+\n|        3 |           11 |            7 |\nX\'31320d3334093637763738\',X\'6162630a646566\',3 |\n+----------+--------------+--------------+-------------------------------------\n---------+\n\nxa rollback X\'31320d3334093637763738\',X\'6162630a646566\',3;\n\nKnown Issues\n------------\n\nMariaDB Galera Cluster\n----------------------\n\nMariaDB Galera Cluster does not support XA transactions.\n\nHowever, MariaDB Galera Cluster builds include a built-in plugin called wsrep.\nPrior to MariaDB 10.4.3, this plugin was internally considered an XA-capable\nstorage engine. Consequently, these MariaDB Galera Cluster builds have\nmultiple XA-capable storage engines by default, even if the only \"real\"\nstorage engine that supports external XA transactions enabled on these builds\nby default is InnoDB. Therefore, when using one these builds MariaDB would be\nforced to use a transaction coordinator log by default, which could have\nperformance implications.\n\nSee Transaction Coordinator Log Overview: MariaDB Galera Cluster for more\ninformation.\n\nURL: https://mariadb.com/kb/en/xa-transactions/','','https://mariadb.com/kb/en/xa-transactions/'),(104,'CREATE USER',10,'Syntax\n------\n\nCREATE [OR REPLACE] USER [IF NOT EXISTS] \n user_specification [,user_specification ...] \n [REQUIRE {NONE | tls_option [[AND] tls_option ...] }]\n [WITH resource_option [resource_option ...] ]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe CREATE USER statement creates new MariaDB accounts. To use it, you must\nhave the global CREATE USER privilege or the INSERT privilege for the mysql\ndatabase. For each account, CREATE USER creates a new row in mysql.user (until\nMariaDB 10.3 this is a table, from MariaDB 10.4 it\'s a view) or\nmysql.global_priv_table (from MariaDB 10.4) that has no privileges.\n\nIf any of the specified accounts, or any permissions for the specified\naccounts, already exist, then the server returns ERROR 1396 (HY000). If an\nerror occurs, CREATE USER will still create the accounts that do not result in\nan error. Only one error is produced for all users which have not been created:\n\nERROR 1396 (HY000): \n Operation CREATE USER failed for \'u1\'@\'%\',\'u2\'@\'%\'\n\nCREATE USER, DROP USER, CREATE ROLE, and DROP ROLE all produce the same error\ncode when they fail.\n\nSee Account Names below for details on how account names are specified.\n\nOR REPLACE\n----------\n\nIf the optional OR REPLACE clause is used, it is basically a shortcut for:\n\nDROP USER IF EXISTS name;\nCREATE USER name ...;\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE OR REPLACE USER foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected (0.00 sec)\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a warning instead\nof an error if the specified user already exists.\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE USER IF NOT EXISTS foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+----------------------------------------------------+\n| Level | Code | Message                                            |\n+-------+------+----------------------------------------------------+\n| Note  | 1973 | Can\'t create user \'foo2\'@\'test\'; it already exists |\n+-------+------+----------------------------------------------------+\n\nAuthentication Options\n----------------------\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored in the\nmysql.user/mysql.global_priv_table table.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nCREATE USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored in the\nmysql.user/mysql.global_priv_table table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nCREATE USER foo2@test IDENTIFIED BY PASSWORD\n\'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nCREATE USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nCREATE USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\') OR\nunix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+--------------------------------