from django.conf import settings


settings.POLICY_FILES.update({
    'share': 'manila_policy.yaml',
})

settings.DEFAULT_POLICY_FILES.update({
    'share': 'default_policies/manila.yaml',
})

# Sample
# settings.LOGGING['loggers'].update({
#     'manilaclient': {
#         'handlers': ['console'],
#         'level': 'DEBUG',
#         'propagate': False,
#     }
# })
settings.LOGGING['loggers'].update({
    'manilaclient': {
        # 'handlers': ['console'],
        'handlers': ['file'],
        # level': 'DEBUG',
        'level': 'DEBUG',
        'propagate': False,
    }
})

# The OPENSTACK_MANILA_FEATURES settings can be used to enable or disable
# the UI for the various services provided by Manila.
#OPENSTACK_MANILA_FEATURES = {
#    'enable_share_groups': True,
#    'enable_replication': True,
#    'enable_migration': True,
#    'enable_public_share_type_creation': True,
#    'enable_public_share_group_type_creation': True,
#    'enable_public_shares': True,
#    'enabled_share_protocols': ['NFS', 'CIFS', 'GlusterFS', 'HDFS', 'CephFS',
#                                'MapRFS'],
#}
OPENSTACK_MANILA_FEATURES = {
    'enable_migration': True,
    'enable_public_share_group_type_creation': True,
    'enable_public_share_type_creation': True,
    'enable_public_shares': True,
    'enable_replication': True,
    'enable_share_groups': True,
    'enabled_share_protocols': ['NFS', 'CIFS', 'GlusterFS', 'HDFS', 'CephFS', 'MapRFS'],
}
