/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('3144ccd8-c1ea-4dc2-95ed-e1892fbbaccb','2025-12-16 15:16:10','2025-12-16 15:16:10',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
INSERT INTO `encryption` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `cipher`, `control_location`, `key_size`, `provider`, `volume_type_id`, `encryption_id`) VALUES ('2025-12-16 15:44:15','2025-12-16 15:44:26','2025-12-16 15:44:26',1,'aes-cbc-essiv','front-end',256,'nova.volume.encryptors.luks.LuksEncryptor','d04bb176-d999-4187-87a7-3c1ee17cecb3','d732dfec-c1e8-401f-a4d4-5f31b230e809');
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'consistent_group_snapshot_enabled','<is> True','084da1d5-60ba-4b75-a31d-f3462556924d','2025-12-16 15:15:55','2025-12-16 15:15:55',NULL,0);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('084da1d5-60ba-4b75-a31d-f3462556924d','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2025-12-16 15:15:55','2025-12-16 15:15:55',NULL,0,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`),
  KEY `ix_image_volume_cache_entries_host` (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2025-12-16 15:15:52',NULL,NULL,0,1,'default','volumes',10),('2025-12-16 15:15:52',NULL,NULL,0,2,'default','snapshots',10),('2025-12-16 15:15:52',NULL,NULL,0,3,'default','gigabytes',1000),('2025-12-16 15:15:52',NULL,NULL,0,4,'default','consistencygroups',10),('2025-12-16 15:15:52',NULL,NULL,0,5,'default','per_volume_gigabytes',-1),('2025-12-16 15:15:52',NULL,NULL,0,6,'default','groups',10);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`,`race_preventer`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2025-12-16 15:16:08','2025-12-16 16:06:26',NULL,0,1,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',297,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'c2074b9b-92ea-466a-a110-4f1e98ec9cd6');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2025-12-16 15:15:55','2025-12-16 15:15:55',NULL,0,'081c48a8-cc50-498b-8375-6737592efe57','__DEFAULT__',NULL,1,'Default Volume Type'),('2025-12-16 15:44:14',NULL,'2025-12-16 15:44:26',1,'d04bb176-d999-4187-87a7-3c1ee17cecb3','LUKS',NULL,1,NULL);
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2025-12-16 15:15:55','2025-12-16 15:15:55.000123',NULL,0,1,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (1,'8d3807d2-80b9-4410-b94e-b58593119409','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/8d3807d2-80b9-4410-b94e-b58593119409','2025-12-16 15:43:25','2025-12-16 15:43:25',NULL,0,'{\"store\": \"default_backend\"}','active'),(2,'da254856-418a-4db9-97af-d8e7d7427ab6','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/da254856-418a-4db9-97af-d8e7d7427ab6','2025-12-16 15:43:26','2025-12-16 15:43:26',NULL,0,'{\"store\": \"default_backend\"}','active');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'8d3807d2-80b9-4410-b94e-b58593119409','hw_rng_model','virtio','2025-12-16 15:43:23','2025-12-16 15:43:23',NULL,0),(2,'da254856-418a-4db9-97af-d8e7d7427ab6','hw_rng_model','virtio','2025-12-16 15:43:25','2025-12-16 15:43:25',NULL,0);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('8d3807d2-80b9-4410-b94e-b58593119409','cirros-0.6.2-x86_64-disk.img',21430272,'active','2025-12-16 15:43:23','2025-12-16 15:43:25',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','a2d874eb451e455db9e546be3b064c5e',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('da254856-418a-4db9-97af-d8e7d7427ab6','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2025-12-16 15:43:25','2025-12-16 15:43:26',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','a2d874eb451e455db9e546be3b064c5e',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b');
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (1,1,'image','CIM_PASD_','2025-12-16 15:14:54',NULL),(1,2,'image','CIM_RASD_','2025-12-16 15:14:54',NULL),(1,3,NULL,'CIM_SASD_','2025-12-16 15:14:54',NULL),(1,9,'image','hw_','2025-12-16 15:14:55',NULL),(1,10,'image','hw_','2025-12-16 15:14:55',NULL),(1,14,'image',NULL,'2025-12-16 15:14:55',NULL),(1,19,'image','hw_','2025-12-16 15:14:55',NULL),(1,25,'image','hw_','2025-12-16 15:14:55',NULL),(1,29,'image',NULL,'2025-12-16 15:14:56',NULL),(1,30,'image',NULL,'2025-12-16 15:14:56',NULL),(1,31,'image',NULL,'2025-12-16 15:14:56',NULL),(1,32,'image',NULL,'2025-12-16 15:14:56',NULL),(2,1,NULL,'CIM_PASD_','2025-12-16 15:14:54',NULL),(2,8,NULL,'hw_','2025-12-16 15:14:55',NULL),(2,9,NULL,'hw_','2025-12-16 15:14:55',NULL),(2,10,NULL,'hw_','2025-12-16 15:14:55',NULL),(2,11,NULL,NULL,'2025-12-16 15:14:55',NULL),(2,13,NULL,NULL,'2025-12-16 15:14:55',NULL),(2,14,NULL,NULL,'2025-12-16 15:14:55',NULL),(2,15,NULL,NULL,'2025-12-16 15:14:55',NULL),(2,16,NULL,'hw_','2025-12-16 15:14:55',NULL),(2,19,NULL,'hw_','2025-12-16 15:14:55',NULL),(2,22,NULL,NULL,'2025-12-16 15:14:55',NULL),(2,23,NULL,'hw_','2025-12-16 15:14:55',NULL),(2,24,NULL,'traits:','2025-12-16 15:14:55',NULL),(2,25,NULL,'hw_','2025-12-16 15:14:55',NULL),(2,26,NULL,NULL,'2025-12-16 15:14:55',NULL),(2,28,NULL,NULL,'2025-12-16 15:14:55',NULL),(2,29,NULL,NULL,'2025-12-16 15:14:56',NULL),(2,30,NULL,NULL,'2025-12-16 15:14:56',NULL),(2,31,NULL,NULL,'2025-12-16 15:14:56',NULL),(2,32,NULL,NULL,'2025-12-16 15:14:56',NULL),(2,33,NULL,'cinder_','2025-12-16 15:14:56',NULL),(3,1,NULL,'CIM_PASD_','2025-12-16 15:14:54',NULL),(3,2,NULL,'CIM_RASD_','2025-12-16 15:14:54',NULL),(3,3,NULL,'CIM_SASD_','2025-12-16 15:14:54',NULL),(3,4,NULL,'CIM_VSSD_','2025-12-16 15:14:54',NULL),(3,5,NULL,NULL,'2025-12-16 15:14:54',NULL),(3,6,NULL,NULL,'2025-12-16 15:14:55',NULL),(3,7,NULL,NULL,'2025-12-16 15:14:55',NULL),(3,12,NULL,'aggregate_instance_extra_specs:','2025-12-16 15:14:55',NULL),(4,1,NULL,'CIM_PASD_','2025-12-16 15:14:54',NULL),(4,2,NULL,'CIM_RASD_','2025-12-16 15:14:54',NULL),(4,3,NULL,'CIM_SASD_','2025-12-16 15:14:54',NULL),(4,4,NULL,'CIM_VSSD_','2025-12-16 15:14:54',NULL),(4,8,NULL,'hw:','2025-12-16 15:14:55',NULL),(4,9,NULL,'hw:','2025-12-16 15:14:55',NULL),(4,10,NULL,'hw:','2025-12-16 15:14:55',NULL),(4,12,NULL,'capabilities:','2025-12-16 15:14:55',NULL),(4,16,NULL,'hw:','2025-12-16 15:14:55',NULL),(4,17,NULL,NULL,'2025-12-16 15:14:55',NULL),(4,18,NULL,NULL,'2025-12-16 15:14:55',NULL),(4,19,NULL,'hw:','2025-12-16 15:14:55',NULL),(4,20,NULL,NULL,'2025-12-16 15:14:55',NULL),(4,21,NULL,NULL,'2025-12-16 15:14:55',NULL),(4,23,NULL,'hw:','2025-12-16 15:14:55',NULL),(4,24,NULL,'traits:','2025-12-16 15:14:55',NULL),(4,25,NULL,'hw:','2025-12-16 15:14:55',NULL),(5,1,'scheduler_hints',NULL,'2025-12-16 15:14:54',NULL),(5,30,'metadata',NULL,'2025-12-16 15:14:56',NULL),(5,31,'metadata',NULL,'2025-12-16 15:14:56',NULL),(5,32,'metadata',NULL,'2025-12-16 15:14:56',NULL),(6,30,NULL,NULL,'2025-12-16 15:14:56',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (1,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2025-12-16 15:14:54',NULL),(2,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2025-12-16 15:14:54',NULL),(3,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2025-12-16 15:14:54',NULL),(4,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2025-12-16 15:14:54',NULL),(5,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-12-16 15:14:54',NULL),(6,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-12-16 15:14:54',NULL),(7,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2025-12-16 15:14:55',NULL),(8,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2025-12-16 15:14:55',NULL),(9,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2025-12-16 15:14:55',NULL),(10,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2025-12-16 15:14:55',NULL),(11,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2025-12-16 15:14:55',NULL),(12,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2025-12-16 15:14:55',NULL),(13,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2025-12-16 15:14:55',NULL),(14,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2025-12-16 15:14:55',NULL),(15,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-16 15:14:55',NULL),(16,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-16 15:14:55',NULL),(17,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-16 15:14:55',NULL),(18,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2025-12-16 15:14:55',NULL),(19,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2025-12-16 15:14:55',NULL),(20,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-16 15:14:55',NULL),(21,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-16 15:14:55',NULL),(22,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-16 15:14:55',NULL),(23,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2025-12-16 15:14:55',NULL),(24,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2025-12-16 15:14:55',NULL),(25,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-16 15:14:55',NULL),(26,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-16 15:14:55',NULL),(27,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2025-12-16 15:14:55',NULL),(28,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2025-12-16 15:14:55',NULL),(29,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2025-12-16 15:14:56',NULL),(30,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2025-12-16 15:14:56',NULL),(31,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2025-12-16 15:14:56',NULL),(32,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2025-12-16 15:14:56',NULL),(33,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2025-12-16 15:14:56',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (1,17,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2025-12-16 15:14:55',NULL),(2,17,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2025-12-16 15:14:55',NULL),(3,17,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2025-12-16 15:14:55',NULL),(4,30,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2025-12-16 15:14:56',NULL),(5,30,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2025-12-16 15:14:56',NULL),(6,30,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2025-12-16 15:14:56',NULL),(7,30,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2025-12-16 15:14:56',NULL),(8,30,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-12-16 15:14:56',NULL),(9,30,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-12-16 15:14:56',NULL),(10,30,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-12-16 15:14:56',NULL),(11,30,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-12-16 15:14:56',NULL),(12,30,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-12-16 15:14:56',NULL),(13,30,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2025-12-16 15:14:56',NULL),(14,30,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2025-12-16 15:14:56',NULL),(15,30,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2025-12-16 15:14:56',NULL),(16,31,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2025-12-16 15:14:56',NULL),(17,31,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2025-12-16 15:14:56',NULL),(18,31,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2025-12-16 15:14:56',NULL),(19,31,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2025-12-16 15:14:56',NULL),(20,31,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2025-12-16 15:14:56',NULL),(21,32,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-12-16 15:14:56',NULL),(22,32,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-12-16 15:14:56',NULL),(23,32,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-12-16 15:14:56',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (1,1,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2025-12-16 15:14:54',NULL),(2,1,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2025-12-16 15:14:54',NULL),(3,1,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2025-12-16 15:14:54',NULL),(4,2,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(5,2,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(6,2,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(7,2,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2025-12-16 15:14:54',NULL),(8,2,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2025-12-16 15:14:54',NULL),(9,2,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-12-16 15:14:54',NULL),(10,2,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(11,2,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2025-12-16 15:14:54',NULL),(12,2,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(13,2,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(14,2,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(15,2,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(16,2,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(17,2,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-12-16 15:14:54',NULL),(18,2,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(19,2,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(20,2,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(21,2,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(22,2,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(23,3,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2025-12-16 15:14:54',NULL),(24,3,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(25,3,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2025-12-16 15:14:54',NULL),(26,3,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2025-12-16 15:14:54',NULL),(27,3,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(28,3,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(29,3,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(30,3,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(31,3,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(32,3,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(33,3,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(34,3,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(35,3,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(36,4,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2025-12-16 15:14:54',NULL),(37,4,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2025-12-16 15:14:54',NULL),(38,4,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2025-12-16 15:14:54',NULL),(39,4,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(40,4,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(41,4,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(42,4,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(43,4,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(44,4,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(45,4,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(46,4,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(47,4,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(48,4,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(49,4,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(50,4,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(51,4,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(52,4,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2025-12-16 15:14:54',NULL),(53,5,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2025-12-16 15:14:54',NULL),(54,6,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2025-12-16 15:14:55',NULL),(55,7,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2025-12-16 15:14:55',NULL),(56,8,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2025-12-16 15:14:55',NULL),(57,9,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2025-12-16 15:14:55',NULL),(58,9,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2025-12-16 15:14:55',NULL),(59,10,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2025-12-16 15:14:55',NULL),(60,11,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-16 15:14:55',NULL),(61,12,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2025-12-16 15:14:55',NULL),(62,12,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2025-12-16 15:14:55',NULL),(63,12,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2025-12-16 15:14:55',NULL),(64,12,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-12-16 15:14:55',NULL),(65,12,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-12-16 15:14:55',NULL),(66,12,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-12-16 15:14:55',NULL),(67,12,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2025-12-16 15:14:55',NULL),(68,13,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2025-12-16 15:14:55',NULL),(69,13,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2025-12-16 15:14:55',NULL),(70,14,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2025-12-16 15:14:55',NULL),(71,14,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-12-16 15:14:55',NULL),(72,15,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-12-16 15:14:55',NULL),(73,15,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-12-16 15:14:55',NULL),(74,15,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2025-12-16 15:14:55',NULL),(75,15,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2025-12-16 15:14:55',NULL),(76,15,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2025-12-16 15:14:55',NULL),(77,15,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2025-12-16 15:14:55',NULL),(78,15,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\", \"bochs\"]}','2025-12-16 15:14:55',NULL),(79,15,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-16 15:14:55',NULL),(80,15,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2025-12-16 15:14:55',NULL),(81,15,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2025-12-16 15:14:55',NULL),(82,15,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, virtio, e1000e and vmxnet3. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\", \"vmxnet3\"]}','2025-12-16 15:14:55',NULL),(83,15,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-16 15:14:55',NULL),(84,15,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-16 15:14:55',NULL),(85,15,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-12-16 15:14:55',NULL),(86,15,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2025-12-16 15:14:55',NULL),(87,15,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-12-16 15:14:55',NULL),(88,16,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-16 15:14:55',NULL),(89,16,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-16 15:14:55',NULL),(90,16,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-16 15:14:55',NULL),(91,18,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2025-12-16 15:14:55',NULL),(92,18,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2025-12-16 15:14:55',NULL),(93,18,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2025-12-16 15:14:55',NULL),(94,19,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-12-16 15:14:55',NULL),(95,19,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-12-16 15:14:55',NULL),(96,19,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-12-16 15:14:55',NULL),(97,19,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-12-16 15:14:55',NULL),(98,19,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-12-16 15:14:55',NULL),(99,19,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-12-16 15:14:55',NULL),(100,20,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2025-12-16 15:14:55',NULL),(101,20,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2025-12-16 15:14:55',NULL),(102,21,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-16 15:14:55',NULL),(103,21,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-16 15:14:55',NULL),(104,22,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2025-12-16 15:14:55',NULL),(105,22,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2025-12-16 15:14:55',NULL),(106,22,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2025-12-16 15:14:55',NULL),(107,22,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2025-12-16 15:14:55',NULL),(108,22,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2025-12-16 15:14:55',NULL),(109,22,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-16 15:14:55',NULL),(110,23,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2025-12-16 15:14:55',NULL),(111,24,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-12-16 15:14:55',NULL),(112,24,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-12-16 15:14:55',NULL),(113,25,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2025-12-16 15:14:55',NULL),(114,26,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2025-12-16 15:14:55',NULL),(115,27,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2025-12-16 15:14:55',NULL),(116,27,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2025-12-16 15:14:55',NULL),(117,27,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2025-12-16 15:14:55',NULL),(118,27,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2025-12-16 15:14:55',NULL),(119,27,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-12-16 15:14:55',NULL),(120,27,'hw_cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"This specifies the CPU Mode for the guest vm\", \"type\": \"string\"}','2025-12-16 15:14:55',NULL),(121,27,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-12-16 15:14:55',NULL),(122,27,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2025-12-16 15:14:55',NULL),(123,27,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2025-12-16 15:14:55',NULL),(124,27,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2025-12-16 15:14:55',NULL),(125,28,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2025-12-16 15:14:55',NULL),(126,28,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2025-12-16 15:14:55',NULL),(127,28,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2025-12-16 15:14:55',NULL),(128,28,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2025-12-16 15:14:56',NULL),(129,29,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-12-16 15:14:56',NULL),(130,29,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-12-16 15:14:56',NULL),(131,29,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2025-12-16 15:14:56',NULL),(132,33,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2025-12-16 15:14:56',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (1,'OS::Cinder::Volume',1,'2025-12-16 15:14:54',NULL),(2,'OS::Glance::Image',1,'2025-12-16 15:14:54',NULL),(3,'OS::Nova::Aggregate',1,'2025-12-16 15:14:54',NULL),(4,'OS::Nova::Flavor',1,'2025-12-16 15:14:54',NULL),(5,'OS::Nova::Server',1,'2025-12-16 15:14:54',NULL),(6,'OS::Trove::Instance',1,'2025-12-16 15:14:56',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `heat`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `heat` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `heat`;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `resource_action` varchar(255) DEFAULT NULL,
  `resource_status` varchar(255) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `physical_resource_id` varchar(255) DEFAULT NULL,
  `resource_status_reason` varchar(255) DEFAULT NULL,
  `resource_type` varchar(255) DEFAULT NULL,
  `resource_properties` blob DEFAULT NULL,
  `rsrc_prop_data_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `stack_id` (`stack_id`),
  KEY `ev_rsrc_prop_data_ref` (`rsrc_prop_data_id`),
  CONSTRAINT `ev_rsrc_prop_data_ref` FOREIGN KEY (`rsrc_prop_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `event_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1524 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `event`
--

LOCK TABLES `event` WRITE;
/*!40000 ALTER TABLE `event` DISABLE KEYS */;
INSERT INTO `event` (`id`, `uuid`, `stack_id`, `created_at`, `updated_at`, `resource_action`, `resource_status`, `resource_name`, `physical_resource_id`, `resource_status_reason`, `resource_type`, `resource_properties`, `rsrc_prop_data_id`) VALUES (1,'ad60712e-83d2-4def-add7-43780e2fe108','40dd6637-b6c2-4a67-82db-d2283c2d323b','2025-12-16 15:43:46',NULL,'CREATE','IN_PROGRESS','api-902272075-envstack','40dd6637-b6c2-4a67-82db-d2283c2d323b','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(2,'1081a713-0c76-4071-a510-682445681213','57b21988-2b6c-4d16-8c6b-498a33e6fb0f','2025-12-16 15:43:46',NULL,'CREATE','IN_PROGRESS','api-1464377815-envstack','57b21988-2b6c-4d16-8c6b-498a33e6fb0f','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(3,'b81cc9ed-938c-4c5e-8cad-b545bbb865c4','40dd6637-b6c2-4a67-82db-d2283c2d323b','2025-12-16 15:43:46',NULL,'CREATE','IN_PROGRESS','test','api-902272075-envstack-test-7n3umx7sw56i','state changed','OS::Heat::TestResource',NULL,1),(4,'7732ac1f-69b3-4223-b2e5-a25cbf81d966','bb7c0259-ff79-464c-b821-75f954c9a816','2025-12-16 15:43:46',NULL,'CREATE','IN_PROGRESS','api-442899664-envstack','bb7c0259-ff79-464c-b821-75f954c9a816','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(5,'f2a1d006-90f4-45cb-abc7-fa4cb2ce969b','57b21988-2b6c-4d16-8c6b-498a33e6fb0f','2025-12-16 15:43:46',NULL,'CREATE','IN_PROGRESS','test','api-1464377815-envstack-test-smaouit5rqlt','state changed','OS::Heat::TestResource',NULL,2),(6,'1e10c42a-2de0-43f4-9f4a-a4a0faddd0cf','40dd6637-b6c2-4a67-82db-d2283c2d323b','2025-12-16 15:43:46',NULL,'CREATE','COMPLETE','test','api-902272075-envstack-test-7n3umx7sw56i','state changed','OS::Heat::TestResource',NULL,1),(7,'e934adf6-13df-4d92-a775-03f8170fe802','40dd6637-b6c2-4a67-82db-d2283c2d323b','2025-12-16 15:43:46',NULL,'CREATE','COMPLETE','api-902272075-envstack','40dd6637-b6c2-4a67-82db-d2283c2d323b','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(8,'cd2d6851-cc42-4c09-934b-f591e7bc167f','57b21988-2b6c-4d16-8c6b-498a33e6fb0f','2025-12-16 15:43:47',NULL,'CREATE','COMPLETE','test','api-1464377815-envstack-test-smaouit5rqlt','state changed','OS::Heat::TestResource',NULL,2),(9,'152fd19b-d819-4dac-bf19-5fa9a6fd28d8','bb7c0259-ff79-464c-b821-75f954c9a816','2025-12-16 15:43:47',NULL,'CREATE','IN_PROGRESS','test','api-442899664-envstack-test-qyr46hsxklfv','state changed','OS::Heat::TestResource',NULL,3),(10,'a0da5092-0e22-4609-93f9-ff8bb488b869','57b21988-2b6c-4d16-8c6b-498a33e6fb0f','2025-12-16 15:43:47',NULL,'CREATE','COMPLETE','api-1464377815-envstack','57b21988-2b6c-4d16-8c6b-498a33e6fb0f','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(11,'00660c30-59df-4a26-8b98-d6e584395334','bb7c0259-ff79-464c-b821-75f954c9a816','2025-12-16 15:43:47',NULL,'CREATE','COMPLETE','test','api-442899664-envstack-test-qyr46hsxklfv','state changed','OS::Heat::TestResource',NULL,3),(12,'5bf3b61e-7a3a-40cf-bbc7-0308ce6eed91','bb7c0259-ff79-464c-b821-75f954c9a816','2025-12-16 15:43:47',NULL,'CREATE','COMPLETE','api-442899664-envstack','bb7c0259-ff79-464c-b821-75f954c9a816','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(13,'da6ada55-3a80-4bda-bc58-1975c44a6ff9','bdc8fd20-a3af-4063-992d-faddbf78cd2f','2025-12-16 15:43:47',NULL,'CREATE','IN_PROGRESS','api-813963596-envstack','bdc8fd20-a3af-4063-992d-faddbf78cd2f','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(14,'d24e16ea-e95e-4346-ac8d-67d83046bf2f','bdc8fd20-a3af-4063-992d-faddbf78cd2f','2025-12-16 15:43:47',NULL,'CREATE','IN_PROGRESS','test','api-813963596-envstack-test-ah3g7vj4ocbr','state changed','OS::Heat::TestResource',NULL,4),(15,'e7bec3a8-1102-4447-89bb-39b28def60a5','bdc8fd20-a3af-4063-992d-faddbf78cd2f','2025-12-16 15:43:47',NULL,'CREATE','COMPLETE','test','api-813963596-envstack-test-ah3g7vj4ocbr','state changed','OS::Heat::TestResource',NULL,4),(16,'38fabef7-0280-4d76-b3a2-3c3b0180f90b','bdc8fd20-a3af-4063-992d-faddbf78cd2f','2025-12-16 15:43:47',NULL,'CREATE','COMPLETE','api-813963596-envstack','bdc8fd20-a3af-4063-992d-faddbf78cd2f','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(17,'ccc29fb0-acea-4343-9853-42e8acbbd86c','61644de6-5a50-49ec-849e-4d04ca5001d1','2025-12-16 15:43:48',NULL,'CREATE','IN_PROGRESS','api-442899664-rsrcstack','61644de6-5a50-49ec-849e-4d04ca5001d1','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(18,'7ec679d2-788d-4345-ac0e-992ca72872cc','61644de6-5a50-49ec-849e-4d04ca5001d1','2025-12-16 15:43:48',NULL,'CREATE','IN_PROGRESS','test','api-442899664-rsrcstack-test-725yc3htx3vl','state changed','OS::Heat::TestResource',NULL,5),(19,'29c43c8c-f2a8-4073-973d-f5da93b8d0c0','61644de6-5a50-49ec-849e-4d04ca5001d1','2025-12-16 15:43:48',NULL,'CREATE','COMPLETE','test','api-442899664-rsrcstack-test-725yc3htx3vl','state changed','OS::Heat::TestResource',NULL,5),(20,'e82ef758-60ba-4669-a3f3-7486883febdb','61644de6-5a50-49ec-849e-4d04ca5001d1','2025-12-16 15:43:48',NULL,'CREATE','COMPLETE','api-442899664-rsrcstack','61644de6-5a50-49ec-849e-4d04ca5001d1','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(21,'a57399e3-97c1-4b32-8fff-e689a002647e','c3e36837-2427-4bae-8974-8ed5fe929ded','2025-12-16 15:43:49',NULL,'CREATE','IN_PROGRESS','api-813963596-rsrcstack','c3e36837-2427-4bae-8974-8ed5fe929ded','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(22,'c4b8783a-695a-4e54-9f2c-520981902014','c3e36837-2427-4bae-8974-8ed5fe929ded','2025-12-16 15:43:49',NULL,'CREATE','IN_PROGRESS','test','api-813963596-rsrcstack-test-yh6l4hvjy3tu','state changed','OS::Heat::TestResource',NULL,6),(23,'e2698d53-85e4-40f4-be26-7c34036aba2b','c3e36837-2427-4bae-8974-8ed5fe929ded','2025-12-16 15:43:49',NULL,'CREATE','COMPLETE','test','api-813963596-rsrcstack-test-yh6l4hvjy3tu','state changed','OS::Heat::TestResource',NULL,6),(24,'e959d452-7531-4a2c-8052-a5cf47158c2a','c3e36837-2427-4bae-8974-8ed5fe929ded','2025-12-16 15:43:49',NULL,'CREATE','COMPLETE','api-813963596-rsrcstack','c3e36837-2427-4bae-8974-8ed5fe929ded','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(25,'6def11fb-59ca-41ee-a02b-9ca820efa0c5','40dd6637-b6c2-4a67-82db-d2283c2d323b','2025-12-16 15:43:49',NULL,'DELETE','IN_PROGRESS','api-902272075-envstack','40dd6637-b6c2-4a67-82db-d2283c2d323b','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(26,'b6fbcbc2-0ea1-465f-8f5d-3ca5f6344cae','40dd6637-b6c2-4a67-82db-d2283c2d323b','2025-12-16 15:43:49',NULL,'DELETE','IN_PROGRESS','test','api-902272075-envstack-test-7n3umx7sw56i','state changed','OS::Heat::TestResource',NULL,1),(27,'6bd366e2-38fb-4a97-a1d4-006e003d8eae','40dd6637-b6c2-4a67-82db-d2283c2d323b','2025-12-16 15:43:49',NULL,'DELETE','COMPLETE','test','api-902272075-envstack-test-7n3umx7sw56i','state changed','OS::Heat::TestResource',NULL,1),(28,'27a1fe2c-485b-453f-bff9-a1b4a122f000','40dd6637-b6c2-4a67-82db-d2283c2d323b','2025-12-16 15:43:50',NULL,'DELETE','COMPLETE','api-902272075-envstack','40dd6637-b6c2-4a67-82db-d2283c2d323b','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(29,'913e3cd4-3bb4-4ee3-b655-659bb848f332','c3e36837-2427-4bae-8974-8ed5fe929ded','2025-12-16 15:43:50',NULL,'CHECK','FAILED','test','api-813963596-rsrcstack-test-yh6l4hvjy3tu','resource deleted','OS::Heat::TestResource',NULL,6),(30,'b56087df-7ff0-48bd-8888-b5c5e07526f2','d86d5f46-7405-4fe4-a7fe-98b2c8ec7eea','2025-12-16 15:43:51',NULL,'CREATE','IN_PROGRESS','api-1464377815-rsrcstack','d86d5f46-7405-4fe4-a7fe-98b2c8ec7eea','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(31,'8003b1a5-f29f-472d-9625-611df28a7139','2daa1675-538f-42f8-a294-31918c670fb0','2025-12-16 15:43:51',NULL,'CREATE','IN_PROGRESS','api-902272075-rsrcstack','2daa1675-538f-42f8-a294-31918c670fb0','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(32,'bba5ecd9-0647-4bc7-b698-bc8370270a95','d86d5f46-7405-4fe4-a7fe-98b2c8ec7eea','2025-12-16 15:43:51',NULL,'CREATE','IN_PROGRESS','test','api-1464377815-rsrcstack-test-o3br3q2muvlp','state changed','OS::Heat::TestResource',NULL,7),(33,'7d1bcef9-ac91-42eb-b241-7941f168dae6','2daa1675-538f-42f8-a294-31918c670fb0','2025-12-16 15:43:51',NULL,'CREATE','IN_PROGRESS','test','api-902272075-rsrcstack-test-mlwompukg4fm','state changed','OS::Heat::TestResource',NULL,8),(34,'977d7546-5104-4225-9338-95149b7e23cc','d86d5f46-7405-4fe4-a7fe-98b2c8ec7eea','2025-12-16 15:43:52',NULL,'CREATE','COMPLETE','test','api-1464377815-rsrcstack-test-o3br3q2muvlp','state changed','OS::Heat::TestResource',NULL,7),(35,'e3ac47b3-40d5-4e7e-b545-255f3743e13f','2daa1675-538f-42f8-a294-31918c670fb0','2025-12-16 15:43:52',NULL,'CREATE','COMPLETE','test','api-902272075-rsrcstack-test-mlwompukg4fm','state changed','OS::Heat::TestResource',NULL,8),(36,'a4b46ec6-50f7-4b05-8205-fe9c94ac1b58','d86d5f46-7405-4fe4-a7fe-98b2c8ec7eea','2025-12-16 15:43:52',NULL,'CREATE','COMPLETE','api-1464377815-rsrcstack','d86d5f46-7405-4fe4-a7fe-98b2c8ec7eea','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(37,'78b3245c-710e-4706-9efd-428021ed28e6','2daa1675-538f-42f8-a294-31918c670fb0','2025-12-16 15:43:52',NULL,'CREATE','COMPLETE','api-902272075-rsrcstack','2daa1675-538f-42f8-a294-31918c670fb0','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(38,'413deca1-945b-41f8-aac4-82f94c810629','d86d5f46-7405-4fe4-a7fe-98b2c8ec7eea','2025-12-16 15:43:55',NULL,'CHECK','FAILED','test','api-1464377815-rsrcstack-test-o3br3q2muvlp','resource deleted','OS::Heat::TestResource',NULL,7),(39,'dc4151f8-2c4b-47b6-b3dd-4b28be3046d8','2daa1675-538f-42f8-a294-31918c670fb0','2025-12-16 15:43:55',NULL,'CHECK','FAILED','test','api-902272075-rsrcstack-test-mlwompukg4fm','resource deleted','OS::Heat::TestResource',NULL,8),(40,'812683a2-0700-4b33-8841-09273c9513fa','ff30dbd1-3d08-4e29-9740-eaf2660d2297','2025-12-16 15:43:55',NULL,'CREATE','IN_PROGRESS','api-442899664-empty','ff30dbd1-3d08-4e29-9740-eaf2660d2297','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(41,'80a7ad69-8144-40cb-bc9e-c91230447692','ff30dbd1-3d08-4e29-9740-eaf2660d2297','2025-12-16 15:43:55',NULL,'CREATE','COMPLETE','api-442899664-empty','ff30dbd1-3d08-4e29-9740-eaf2660d2297','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(42,'b44604e7-13a1-42f0-b4bd-c5165d3ed7e2','ff30dbd1-3d08-4e29-9740-eaf2660d2297','2025-12-16 15:43:57',NULL,'DELETE','IN_PROGRESS','api-442899664-empty','ff30dbd1-3d08-4e29-9740-eaf2660d2297','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(43,'f341e9c2-292b-4e3a-b8af-b1c68a6c02bf','ff30dbd1-3d08-4e29-9740-eaf2660d2297','2025-12-16 15:43:57',NULL,'DELETE','COMPLETE','api-442899664-empty','ff30dbd1-3d08-4e29-9740-eaf2660d2297','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(44,'b664460e-c23c-4d50-bca1-fded1619e5d6','2daa1675-538f-42f8-a294-31918c670fb0','2025-12-16 15:43:57',NULL,'DELETE','IN_PROGRESS','api-902272075-rsrcstack','2daa1675-538f-42f8-a294-31918c670fb0','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(45,'ebb3249b-f34c-4af3-894e-f84b50ab1d63','2daa1675-538f-42f8-a294-31918c670fb0','2025-12-16 15:43:58',NULL,'DELETE','IN_PROGRESS','test','api-902272075-rsrcstack-test-mlwompukg4fm','state changed','OS::Heat::TestResource',NULL,8),(46,'bb1f04eb-f1c2-4ac1-8ba6-fe6a950fa1d2','2daa1675-538f-42f8-a294-31918c670fb0','2025-12-16 15:43:58',NULL,'DELETE','COMPLETE','test','api-902272075-rsrcstack-test-mlwompukg4fm','state changed','OS::Heat::TestResource',NULL,8),(47,'a5351c63-dbcb-4436-9933-2de1108a08a5','2daa1675-538f-42f8-a294-31918c670fb0','2025-12-16 15:43:58',NULL,'DELETE','COMPLETE','api-902272075-rsrcstack','2daa1675-538f-42f8-a294-31918c670fb0','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(48,'ad4d569f-f9cb-4d51-8a23-53e9f78dae03','6c54c1e8-3450-48de-8a6b-abc87fdcb345','2025-12-16 15:43:59',NULL,'CREATE','IN_PROGRESS','api-813963596-empty','6c54c1e8-3450-48de-8a6b-abc87fdcb345','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(49,'561f76a0-48cf-4602-b5f4-05be71dd4ece','6c54c1e8-3450-48de-8a6b-abc87fdcb345','2025-12-16 15:43:59',NULL,'CREATE','COMPLETE','api-813963596-empty','6c54c1e8-3450-48de-8a6b-abc87fdcb345','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(50,'cac164a6-8f94-423f-8a5a-fa8cafcc4c3f','8606424d-0c4c-44e0-9d9d-aa9a306ff574','2025-12-16 15:43:59',NULL,'CREATE','IN_PROGRESS','api-442899664-stack','8606424d-0c4c-44e0-9d9d-aa9a306ff574','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(51,'b2fed0f9-f077-4972-9a81-17e5f9586895','8606424d-0c4c-44e0-9d9d-aa9a306ff574','2025-12-16 15:43:59',NULL,'CREATE','IN_PROGRESS','test','api-442899664-stack-test-4g25dznaydw4','state changed','OS::Heat::TestResource',NULL,9),(52,'3e402b8e-fa58-4ee5-be81-265449cc58ec','8606424d-0c4c-44e0-9d9d-aa9a306ff574','2025-12-16 15:43:59',NULL,'CREATE','COMPLETE','test','api-442899664-stack-test-4g25dznaydw4','state changed','OS::Heat::TestResource',NULL,9),(53,'2c6aa79c-6463-4b37-8edf-13e82a587ade','8606424d-0c4c-44e0-9d9d-aa9a306ff574','2025-12-16 15:43:59',NULL,'CREATE','COMPLETE','api-442899664-stack','8606424d-0c4c-44e0-9d9d-aa9a306ff574','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(54,'76f334d4-efcd-4b37-872d-0639ffe202f1','6c54c1e8-3450-48de-8a6b-abc87fdcb345','2025-12-16 15:43:59',NULL,'DELETE','IN_PROGRESS','api-813963596-empty','6c54c1e8-3450-48de-8a6b-abc87fdcb345','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(55,'fbcd02c3-6386-408a-83cd-224ea03ac6e4','6c54c1e8-3450-48de-8a6b-abc87fdcb345','2025-12-16 15:43:59',NULL,'DELETE','COMPLETE','api-813963596-empty','6c54c1e8-3450-48de-8a6b-abc87fdcb345','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(56,'709f2130-ae05-4994-9d45-66a77737888b','ff434bb3-7cc5-4848-9d1e-8f0f46ac0718','2025-12-16 15:44:00',NULL,'CREATE','IN_PROGRESS','api-813963596-stack','ff434bb3-7cc5-4848-9d1e-8f0f46ac0718','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(57,'769571d9-d97a-4138-8926-86530fd24b6f','ff434bb3-7cc5-4848-9d1e-8f0f46ac0718','2025-12-16 15:44:00',NULL,'CREATE','IN_PROGRESS','test','api-813963596-stack-test-6trqvbbxxxs2','state changed','OS::Heat::TestResource',NULL,10),(58,'21664218-3de6-444f-b0d5-4ad126fb28da','ff434bb3-7cc5-4848-9d1e-8f0f46ac0718','2025-12-16 15:44:01',NULL,'CREATE','COMPLETE','test','api-813963596-stack-test-6trqvbbxxxs2','state changed','OS::Heat::TestResource',NULL,10),(59,'1b653b39-7824-4b88-a876-55e6c711bc97','ff434bb3-7cc5-4848-9d1e-8f0f46ac0718','2025-12-16 15:44:01',NULL,'CREATE','COMPLETE','api-813963596-stack','ff434bb3-7cc5-4848-9d1e-8f0f46ac0718','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(60,'15e93114-028f-462c-8e9f-0b26a5bcf79c','d3ea3a2b-3310-4264-a5e9-5e3e694abad8','2025-12-16 15:44:01',NULL,'CREATE','IN_PROGRESS','api-1464377815-empty','d3ea3a2b-3310-4264-a5e9-5e3e694abad8','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(61,'41dc58ec-8b29-4910-a434-4ca24e4268c2','d3ea3a2b-3310-4264-a5e9-5e3e694abad8','2025-12-16 15:44:01',NULL,'CREATE','COMPLETE','api-1464377815-empty','d3ea3a2b-3310-4264-a5e9-5e3e694abad8','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(62,'5b356fc0-202d-41c7-b340-c7e2c5ebb4c5','d3ea3a2b-3310-4264-a5e9-5e3e694abad8','2025-12-16 15:44:01',NULL,'DELETE','IN_PROGRESS','api-1464377815-empty','d3ea3a2b-3310-4264-a5e9-5e3e694abad8','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(63,'9d378415-f100-4847-8bbb-c5fd272d1809','d3ea3a2b-3310-4264-a5e9-5e3e694abad8','2025-12-16 15:44:01',NULL,'DELETE','COMPLETE','api-1464377815-empty','d3ea3a2b-3310-4264-a5e9-5e3e694abad8','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(64,'96a5e57c-ac2f-47c1-bbd2-a878e0c0c96c','8606424d-0c4c-44e0-9d9d-aa9a306ff574','2025-12-16 15:44:02',NULL,'UPDATE','IN_PROGRESS','api-442899664-stack','8606424d-0c4c-44e0-9d9d-aa9a306ff574','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(65,'e7ab386a-15f3-4f65-ada4-5e122b38ae42','8606424d-0c4c-44e0-9d9d-aa9a306ff574','2025-12-16 15:44:02',NULL,'UPDATE','IN_PROGRESS','test','api-442899664-stack-test-4g25dznaydw4','state changed','OS::Heat::TestResource',NULL,9),(66,'c67f951c-00db-45a8-ab5e-2de08fb8a51f','538c1c0b-52c5-4656-a5f6-52bdc8723cb7','2025-12-16 15:44:02',NULL,'CREATE','IN_PROGRESS','api-1464377815-stack','538c1c0b-52c5-4656-a5f6-52bdc8723cb7','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(67,'630002a8-b49b-4f66-bf6e-546160d3fde9','f548867f-5f65-4614-ae3a-5b56dfbe1b1d','2025-12-16 15:44:02',NULL,'CREATE','IN_PROGRESS','api-902272075-empty','f548867f-5f65-4614-ae3a-5b56dfbe1b1d','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(68,'fd3eaa2f-742b-4813-a5c8-065e41f71561','f548867f-5f65-4614-ae3a-5b56dfbe1b1d','2025-12-16 15:44:02',NULL,'CREATE','COMPLETE','api-902272075-empty','f548867f-5f65-4614-ae3a-5b56dfbe1b1d','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(69,'3e229127-82d1-456a-b818-a600507a5a51','538c1c0b-52c5-4656-a5f6-52bdc8723cb7','2025-12-16 15:44:02',NULL,'CREATE','IN_PROGRESS','test','api-1464377815-stack-test-p6kvqap2bpmi','state changed','OS::Heat::TestResource',NULL,11),(70,'02c1b55c-91e5-48c8-8bb9-70ea4ae4899b','538c1c0b-52c5-4656-a5f6-52bdc8723cb7','2025-12-16 15:44:02',NULL,'CREATE','COMPLETE','test','api-1464377815-stack-test-p6kvqap2bpmi','state changed','OS::Heat::TestResource',NULL,11),(71,'05796992-47b8-4b02-bb05-82f016e43dad','538c1c0b-52c5-4656-a5f6-52bdc8723cb7','2025-12-16 15:44:02',NULL,'CREATE','COMPLETE','api-1464377815-stack','538c1c0b-52c5-4656-a5f6-52bdc8723cb7','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(72,'bd171a42-2562-4f4a-a70c-3b03019f434d','f548867f-5f65-4614-ae3a-5b56dfbe1b1d','2025-12-16 15:44:03',NULL,'DELETE','IN_PROGRESS','api-902272075-empty','f548867f-5f65-4614-ae3a-5b56dfbe1b1d','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(73,'d46d67cc-326d-456b-87d0-76e0e5ed91d6','f548867f-5f65-4614-ae3a-5b56dfbe1b1d','2025-12-16 15:44:03',NULL,'DELETE','COMPLETE','api-902272075-empty','f548867f-5f65-4614-ae3a-5b56dfbe1b1d','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(74,'8509bad7-3337-42c6-a18b-4c094af67eaf','538c1c0b-52c5-4656-a5f6-52bdc8723cb7','2025-12-16 15:44:03',NULL,'UPDATE','IN_PROGRESS','api-1464377815-stack','538c1c0b-52c5-4656-a5f6-52bdc8723cb7','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(75,'e27d9d74-e27d-4e91-80f1-6fa903367061','538c1c0b-52c5-4656-a5f6-52bdc8723cb7','2025-12-16 15:44:03',NULL,'UPDATE','IN_PROGRESS','test','api-1464377815-stack-test-p6kvqap2bpmi','state changed','OS::Heat::TestResource',NULL,11),(76,'3288def7-90c3-463a-b9c6-ee7567fc8f12','ff434bb3-7cc5-4848-9d1e-8f0f46ac0718','2025-12-16 15:44:04',NULL,'UPDATE','IN_PROGRESS','api-813963596-stack','ff434bb3-7cc5-4848-9d1e-8f0f46ac0718','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(77,'8e51aeeb-8339-4912-8cd6-e3dc5571e184','ff434bb3-7cc5-4848-9d1e-8f0f46ac0718','2025-12-16 15:44:04',NULL,'UPDATE','IN_PROGRESS','test','api-813963596-stack-test-6trqvbbxxxs2','state changed','OS::Heat::TestResource',NULL,10),(78,'22a20f17-725e-4947-b448-9f22eaaa7abd','8606424d-0c4c-44e0-9d9d-aa9a306ff574','2025-12-16 15:44:04',NULL,'UPDATE','COMPLETE','test','api-442899664-stack-test-4g25dznaydw4','state changed','OS::Heat::TestResource',NULL,12),(79,'a1af37fc-d703-42ba-88d4-211f767d649b','4a688e03-5c63-4f31-92b1-d98783bc8d29','2025-12-16 15:44:04',NULL,'CREATE','IN_PROGRESS','api-902272075-stack','4a688e03-5c63-4f31-92b1-d98783bc8d29','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(80,'879fd37b-b39e-4d4c-8e86-151f6b897d5e','8606424d-0c4c-44e0-9d9d-aa9a306ff574','2025-12-16 15:44:04',NULL,'UPDATE','COMPLETE','api-442899664-stack','8606424d-0c4c-44e0-9d9d-aa9a306ff574','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(81,'504ce910-afe3-4380-877f-01a067b4983b','4a688e03-5c63-4f31-92b1-d98783bc8d29','2025-12-16 15:44:04',NULL,'CREATE','IN_PROGRESS','test','api-902272075-stack-test-c4wsboj62vql','state changed','OS::Heat::TestResource',NULL,13),(82,'88ff43b6-1673-4c32-9d44-1f4ea8edc501','4a688e03-5c63-4f31-92b1-d98783bc8d29','2025-12-16 15:44:04',NULL,'CREATE','COMPLETE','test','api-902272075-stack-test-c4wsboj62vql','state changed','OS::Heat::TestResource',NULL,13),(83,'31f2fb68-b76d-4ffd-9306-2963db007a1b','4a688e03-5c63-4f31-92b1-d98783bc8d29','2025-12-16 15:44:04',NULL,'CREATE','COMPLETE','api-902272075-stack','4a688e03-5c63-4f31-92b1-d98783bc8d29','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(84,'76a4b30a-1adb-4659-b0a2-d68cb93da02d','4a688e03-5c63-4f31-92b1-d98783bc8d29','2025-12-16 15:44:05',NULL,'UPDATE','IN_PROGRESS','api-902272075-stack','4a688e03-5c63-4f31-92b1-d98783bc8d29','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(85,'22c797b2-5b29-4a68-8daf-af6acd522992','4a688e03-5c63-4f31-92b1-d98783bc8d29','2025-12-16 15:44:05',NULL,'UPDATE','IN_PROGRESS','test','api-902272075-stack-test-c4wsboj62vql','state changed','OS::Heat::TestResource',NULL,13),(86,'6d8567a9-099a-454f-aab9-0eabe9789600','538c1c0b-52c5-4656-a5f6-52bdc8723cb7','2025-12-16 15:44:05',NULL,'UPDATE','COMPLETE','test','api-1464377815-stack-test-p6kvqap2bpmi','state changed','OS::Heat::TestResource',NULL,14),(87,'64a314c7-fa45-4fd0-b097-8cc011253224','538c1c0b-52c5-4656-a5f6-52bdc8723cb7','2025-12-16 15:44:06',NULL,'UPDATE','COMPLETE','api-1464377815-stack','538c1c0b-52c5-4656-a5f6-52bdc8723cb7','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(88,'6c87cf9a-ac01-4945-96b8-65cf820a63fd','ff434bb3-7cc5-4848-9d1e-8f0f46ac0718','2025-12-16 15:44:06',NULL,'UPDATE','COMPLETE','test','api-813963596-stack-test-6trqvbbxxxs2','state changed','OS::Heat::TestResource',NULL,15),(89,'ca0b6750-e94f-40fe-ade1-7cd0c7848f72','538c1c0b-52c5-4656-a5f6-52bdc8723cb7','2025-12-16 15:44:07',NULL,'UPDATE','IN_PROGRESS','api-1464377815-stack','538c1c0b-52c5-4656-a5f6-52bdc8723cb7','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(90,'1be83e8e-578f-4385-b98c-5773642a4ead','ff434bb3-7cc5-4848-9d1e-8f0f46ac0718','2025-12-16 15:44:07',NULL,'UPDATE','COMPLETE','api-813963596-stack','ff434bb3-7cc5-4848-9d1e-8f0f46ac0718','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(91,'133d3219-ca3b-46c5-a629-d69c0ddd21c5','538c1c0b-52c5-4656-a5f6-52bdc8723cb7','2025-12-16 15:44:07',NULL,'UPDATE','IN_PROGRESS','test','api-1464377815-stack-test-p6kvqap2bpmi','state changed','OS::Heat::TestResource',NULL,14),(92,'00e70e6e-90f8-4f27-92d1-ac6fb840f71c','8260713d-fdcd-4191-af23-f6434fb03aa7','2025-12-16 15:44:07',NULL,'CREATE','IN_PROGRESS','UpdatePortTest-1000067181','8260713d-fdcd-4191-af23-f6434fb03aa7','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(93,'67ea1f76-2134-4462-b0ab-7f7f4d6eba00','8260713d-fdcd-4191-af23-f6434fb03aa7','2025-12-16 15:44:07',NULL,'CREATE','IN_PROGRESS','net','UpdatePortTest-1000067181-net-cnhmuevbdsjz','state changed','OS::Neutron::Net',NULL,NULL),(94,'351f0336-82f6-4f1b-b06b-d5ddb7e9d7e2','4a688e03-5c63-4f31-92b1-d98783bc8d29','2025-12-16 15:44:07',NULL,'UPDATE','COMPLETE','test','api-902272075-stack-test-c4wsboj62vql','state changed','OS::Heat::TestResource',NULL,16),(95,'af7790a1-985e-4924-8815-199162ca4866','4a688e03-5c63-4f31-92b1-d98783bc8d29','2025-12-16 15:44:08',NULL,'UPDATE','COMPLETE','api-902272075-stack','4a688e03-5c63-4f31-92b1-d98783bc8d29','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(96,'202563f5-6061-4ed2-b03b-fe4c67a678df','8260713d-fdcd-4191-af23-f6434fb03aa7','2025-12-16 15:44:08',NULL,'CREATE','COMPLETE','net','2ba0875f-b538-4f72-8cc4-68dc5554e198','state changed','OS::Neutron::Net',NULL,NULL),(97,'05860333-aaa0-4864-a557-75618e611225','8260713d-fdcd-4191-af23-f6434fb03aa7','2025-12-16 15:44:09',NULL,'CREATE','IN_PROGRESS','subnet','UpdatePortTest-1000067181-subnet-ufhx5cjjivkm','state changed','OS::Neutron::Subnet',NULL,17),(98,'50fbb3ae-7836-47a8-98a2-ec7456e25f40','538c1c0b-52c5-4656-a5f6-52bdc8723cb7','2025-12-16 15:44:09',NULL,'UPDATE','COMPLETE','test','api-1464377815-stack-test-p6kvqap2bpmi','state changed','OS::Heat::TestResource',NULL,18),(99,'acd567bb-4922-49e1-8067-486194ce986b','538c1c0b-52c5-4656-a5f6-52bdc8723cb7','2025-12-16 15:44:09',NULL,'UPDATE','COMPLETE','api-1464377815-stack','538c1c0b-52c5-4656-a5f6-52bdc8723cb7','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(100,'da61da5b-a535-4a8a-ad92-3c3ca183cab3','8260713d-fdcd-4191-af23-f6434fb03aa7','2025-12-16 15:44:09',NULL,'CREATE','COMPLETE','subnet','de7a866e-4c1c-433c-a14e-2d67e44ec573','state changed','OS::Neutron::Subnet',NULL,17),(101,'93d7b893-3928-4e7d-94bd-66f658f2e7bf','8260713d-fdcd-4191-af23-f6434fb03aa7','2025-12-16 15:44:09',NULL,'CREATE','IN_PROGRESS','port','UpdatePortTest-1000067181-port-qatphhd3gdg3','state changed','OS::Neutron::Port',NULL,19),(102,'e11795bf-4091-40e1-b67c-9990279c9f21','ff434bb3-7cc5-4848-9d1e-8f0f46ac0718','2025-12-16 15:44:09',NULL,'UPDATE','IN_PROGRESS','api-813963596-stack','ff434bb3-7cc5-4848-9d1e-8f0f46ac0718','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(103,'024aa734-6d30-4e1e-a7d9-5d46a8571452','ff434bb3-7cc5-4848-9d1e-8f0f46ac0718','2025-12-16 15:44:10',NULL,'UPDATE','IN_PROGRESS','test','api-813963596-stack-test-6trqvbbxxxs2','state changed','OS::Heat::TestResource',NULL,15),(104,'379a5ede-382c-4364-8e0c-ef15318139b7','4a688e03-5c63-4f31-92b1-d98783bc8d29','2025-12-16 15:44:10',NULL,'UPDATE','IN_PROGRESS','api-902272075-stack','4a688e03-5c63-4f31-92b1-d98783bc8d29','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(105,'026f3887-f6ea-4de7-855b-bbf98a4f53a4','4a688e03-5c63-4f31-92b1-d98783bc8d29','2025-12-16 15:44:10',NULL,'UPDATE','IN_PROGRESS','test','api-902272075-stack-test-c4wsboj62vql','state changed','OS::Heat::TestResource',NULL,16),(106,'5196b61a-2f6d-4b13-ac04-85413ca2187e','8260713d-fdcd-4191-af23-f6434fb03aa7','2025-12-16 15:44:11',NULL,'CREATE','COMPLETE','port','babb0559-26e0-4d11-a6f8-726a2c6eef66','state changed','OS::Neutron::Port',NULL,19),(107,'65ee1698-f0fb-4a31-91d2-7ffad1cae456','8260713d-fdcd-4191-af23-f6434fb03aa7','2025-12-16 15:44:11',NULL,'CREATE','IN_PROGRESS','test','UpdatePortTest-1000067181-test-gvl6pym7xyxt','state changed','OS::Heat::TestResource',NULL,21),(108,'a9a047f9-7716-434f-a0d3-7d999553e292','8260713d-fdcd-4191-af23-f6434fb03aa7','2025-12-16 15:44:11',NULL,'CREATE','COMPLETE','test','UpdatePortTest-1000067181-test-gvl6pym7xyxt','state changed','OS::Heat::TestResource',NULL,21),(109,'bf132d1e-a818-46b8-9a4c-62de52d30b70','8260713d-fdcd-4191-af23-f6434fb03aa7','2025-12-16 15:44:11',NULL,'CREATE','COMPLETE','UpdatePortTest-1000067181','8260713d-fdcd-4191-af23-f6434fb03aa7','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(110,'577ba053-dbdc-4b87-ab3b-e428591d9cfb','6d86f0cb-94d2-4040-ab94-f01bd5c0a1a1','2025-12-16 15:44:11',NULL,'CREATE','IN_PROGRESS','EncryptedParametersTest-223744132','6d86f0cb-94d2-4040-ab94-f01bd5c0a1a1','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(111,'0055dd52-80c9-4890-bade-780c97e95bd1','6d86f0cb-94d2-4040-ab94-f01bd5c0a1a1','2025-12-16 15:44:11',NULL,'CREATE','IN_PROGRESS','server_with_encrypted_property','En-744132-server_with_encrypted_property-rjaha6usrosd','state changed','OS::Nova::Server',NULL,22),(112,'cf4c50da-e207-4708-b095-dfcf0d9956ce','ff434bb3-7cc5-4848-9d1e-8f0f46ac0718','2025-12-16 15:44:12',NULL,'UPDATE','COMPLETE','test','api-813963596-stack-test-6trqvbbxxxs2','state changed','OS::Heat::TestResource',NULL,23),(113,'bdc77841-2390-4e79-8682-d246e6e5d0aa','ff434bb3-7cc5-4848-9d1e-8f0f46ac0718','2025-12-16 15:44:12',NULL,'UPDATE','COMPLETE','api-813963596-stack','ff434bb3-7cc5-4848-9d1e-8f0f46ac0718','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(114,'7444e7a2-a065-48b6-a2d5-e5cd03038e14','4a688e03-5c63-4f31-92b1-d98783bc8d29','2025-12-16 15:44:12',NULL,'UPDATE','COMPLETE','test','api-902272075-stack-test-c4wsboj62vql','state changed','OS::Heat::TestResource',NULL,24),(115,'6bf859ec-babe-4729-a5b3-2b5b2734ac38','8260713d-fdcd-4191-af23-f6434fb03aa7','2025-12-16 15:44:12',NULL,'UPDATE','IN_PROGRESS','UpdatePortTest-1000067181','8260713d-fdcd-4191-af23-f6434fb03aa7','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(116,'8226a9b6-21cf-4d99-b107-faeb2fe5e801','4a688e03-5c63-4f31-92b1-d98783bc8d29','2025-12-16 15:44:12',NULL,'UPDATE','COMPLETE','api-902272075-stack','4a688e03-5c63-4f31-92b1-d98783bc8d29','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(117,'315003de-f18b-461a-9fc5-254643395f67','8260713d-fdcd-4191-af23-f6434fb03aa7','2025-12-16 15:44:13',NULL,'UPDATE','IN_PROGRESS','port','babb0559-26e0-4d11-a6f8-726a2c6eef66','state changed','OS::Neutron::Port',NULL,19),(118,'3eb14602-2999-4e21-bd80-587e21978ad5','cad69cc4-2572-4bdb-8c9e-1c3092e995d2','2025-12-16 15:44:14',NULL,'CREATE','IN_PROGRESS','EncryptionVolTypeTest-646776626','cad69cc4-2572-4bdb-8c9e-1c3092e995d2','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(119,'5e42682b-a6a9-4eed-96ba-30a177160506','cad69cc4-2572-4bdb-8c9e-1c3092e995d2','2025-12-16 15:44:14',NULL,'CREATE','IN_PROGRESS','my_volume_type','EncryptionVolTypeTest-646776626-my_volume_type-dbwp7fu7djsj','state changed','OS::Cinder::VolumeType',NULL,25),(120,'c24fff1a-3ce8-46c3-8eba-1798c019ead0','cad69cc4-2572-4bdb-8c9e-1c3092e995d2','2025-12-16 15:44:14',NULL,'CREATE','COMPLETE','my_volume_type','d04bb176-d999-4187-87a7-3c1ee17cecb3','state changed','OS::Cinder::VolumeType',NULL,25),(121,'2697c7e6-f656-4768-b8a2-b29acf4aeef1','8260713d-fdcd-4191-af23-f6434fb03aa7','2025-12-16 15:44:15',NULL,'UPDATE','COMPLETE','port','babb0559-26e0-4d11-a6f8-726a2c6eef66','state changed','OS::Neutron::Port',NULL,27),(122,'cbba838d-c252-4a8f-a319-75e378d641f0','cad69cc4-2572-4bdb-8c9e-1c3092e995d2','2025-12-16 15:44:15',NULL,'CREATE','IN_PROGRESS','my_encrypted_vol_type','EncryptionVolTypeTest-646776626-my_encrypted_vol_type-usuk5xhq2q5s','state changed','OS::Cinder::EncryptedVolumeType',NULL,26),(123,'aeb23e92-6844-4af2-b1e2-ed1a7e284ebd','cad69cc4-2572-4bdb-8c9e-1c3092e995d2','2025-12-16 15:44:15',NULL,'CREATE','COMPLETE','my_encrypted_vol_type','d04bb176-d999-4187-87a7-3c1ee17cecb3','state changed','OS::Cinder::EncryptedVolumeType',NULL,26),(124,'d0852075-8f17-4d2d-85bb-dfbc1ed61fef','cad69cc4-2572-4bdb-8c9e-1c3092e995d2','2025-12-16 15:44:15',NULL,'CREATE','COMPLETE','EncryptionVolTypeTest-646776626','cad69cc4-2572-4bdb-8c9e-1c3092e995d2','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(125,'f711eec3-2800-4dde-9219-c9ded4aa1472','8260713d-fdcd-4191-af23-f6434fb03aa7','2025-12-16 15:44:15',NULL,'UPDATE','COMPLETE','UpdatePortTest-1000067181','8260713d-fdcd-4191-af23-f6434fb03aa7','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(126,'11caede7-45de-49a9-b302-d3fdad3058d9','4a688e03-5c63-4f31-92b1-d98783bc8d29','2025-12-16 15:44:15',NULL,'DELETE','IN_PROGRESS','api-902272075-stack','4a688e03-5c63-4f31-92b1-d98783bc8d29','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(127,'abe589f5-9cb4-4419-a3cd-6fbd27f71361','4a688e03-5c63-4f31-92b1-d98783bc8d29','2025-12-16 15:44:15',NULL,'DELETE','IN_PROGRESS','test','api-902272075-stack-test-c4wsboj62vql','state changed','OS::Heat::TestResource',NULL,24),(128,'8c250472-abd0-4286-a3bf-bd77cc834b35','4a688e03-5c63-4f31-92b1-d98783bc8d29','2025-12-16 15:44:15',NULL,'DELETE','COMPLETE','test','api-902272075-stack-test-c4wsboj62vql','state changed','OS::Heat::TestResource',NULL,24),(129,'5beb977a-01b3-4c5f-b699-236db1ed07bd','4a688e03-5c63-4f31-92b1-d98783bc8d29','2025-12-16 15:44:15',NULL,'DELETE','COMPLETE','api-902272075-stack','4a688e03-5c63-4f31-92b1-d98783bc8d29','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(130,'1cad49f4-6368-4516-9db5-4fac5fca3ab2','8260713d-fdcd-4191-af23-f6434fb03aa7','2025-12-16 15:44:17',NULL,'DELETE','IN_PROGRESS','UpdatePortTest-1000067181','8260713d-fdcd-4191-af23-f6434fb03aa7','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(131,'c450f4bf-2cdb-4625-8155-5c1377cd07ac','8260713d-fdcd-4191-af23-f6434fb03aa7','2025-12-16 15:44:17',NULL,'DELETE','IN_PROGRESS','test','UpdatePortTest-1000067181-test-gvl6pym7xyxt','state changed','OS::Heat::TestResource',NULL,21),(132,'1ac150fa-67f8-4010-b187-d6215f0a908d','8260713d-fdcd-4191-af23-f6434fb03aa7','2025-12-16 15:44:17',NULL,'DELETE','COMPLETE','test','UpdatePortTest-1000067181-test-gvl6pym7xyxt','state changed','OS::Heat::TestResource',NULL,21),(133,'418e799b-e26c-4ae3-95c3-3cc32912ef8a','08ee559b-7930-4499-beaf-db872d98e2e0','2025-12-16 15:44:17',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-966863901','08ee559b-7930-4499-beaf-db872d98e2e0','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(134,'6a997c04-5c8a-4688-ac2c-014f8767d1b1','8260713d-fdcd-4191-af23-f6434fb03aa7','2025-12-16 15:44:17',NULL,'DELETE','IN_PROGRESS','port','babb0559-26e0-4d11-a6f8-726a2c6eef66','state changed','OS::Neutron::Port',NULL,27),(135,'30dc306d-5a1c-4bdd-9c1b-17361d7aadaf','08ee559b-7930-4499-beaf-db872d98e2e0','2025-12-16 15:44:17',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-966863901-net-pyhv7zjgph5a','state changed','OS::Neutron::Net',NULL,NULL),(136,'cadc50ad-b8a6-4647-ad8c-35bf2d137895','8260713d-fdcd-4191-af23-f6434fb03aa7','2025-12-16 15:44:18',NULL,'DELETE','COMPLETE','port','babb0559-26e0-4d11-a6f8-726a2c6eef66','state changed','OS::Neutron::Port',NULL,27),(137,'7fe6877a-738c-4c62-900c-a59cb2296299','8260713d-fdcd-4191-af23-f6434fb03aa7','2025-12-16 15:44:18',NULL,'DELETE','IN_PROGRESS','subnet','de7a866e-4c1c-433c-a14e-2d67e44ec573','state changed','OS::Neutron::Subnet',NULL,17),(138,'8dce9bc9-6b67-42d7-8a7f-10db035d8b7f','08ee559b-7930-4499-beaf-db872d98e2e0','2025-12-16 15:44:18',NULL,'CREATE','COMPLETE','net','7abadcb6-58cc-46e9-b83e-dc22c778e6a8','state changed','OS::Neutron::Net',NULL,NULL),(139,'dfadc143-52f4-4c09-a03f-1886415d0dc0','8260713d-fdcd-4191-af23-f6434fb03aa7','2025-12-16 15:44:18',NULL,'DELETE','COMPLETE','subnet','de7a866e-4c1c-433c-a14e-2d67e44ec573','state changed','OS::Neutron::Subnet',NULL,17),(140,'92e84496-3ec9-4da7-8cca-5e3960a2e121','08ee559b-7930-4499-beaf-db872d98e2e0','2025-12-16 15:44:18',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-966863901-subnet-fvi4efu2zfpn','state changed','OS::Neutron::Subnet',NULL,29),(141,'cb954040-2b8f-4eed-bebb-b076501d0fa6','8260713d-fdcd-4191-af23-f6434fb03aa7','2025-12-16 15:44:19',NULL,'DELETE','IN_PROGRESS','net','2ba0875f-b538-4f72-8cc4-68dc5554e198','state changed','OS::Neutron::Net',NULL,NULL),(142,'efdaf51c-da49-4192-95ff-603a906bf766','cad69cc4-2572-4bdb-8c9e-1c3092e995d2','2025-12-16 15:44:20',NULL,'UPDATE','IN_PROGRESS','EncryptionVolTypeTest-646776626','cad69cc4-2572-4bdb-8c9e-1c3092e995d2','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(143,'07880c2f-5410-4158-aacd-2e9007fdd2c6','8260713d-fdcd-4191-af23-f6434fb03aa7','2025-12-16 15:44:20',NULL,'DELETE','COMPLETE','net','2ba0875f-b538-4f72-8cc4-68dc5554e198','state changed','OS::Neutron::Net',NULL,NULL),(144,'7907cf29-0f81-4d4b-b80a-92931aad73c6','8260713d-fdcd-4191-af23-f6434fb03aa7','2025-12-16 15:44:20',NULL,'DELETE','COMPLETE','UpdatePortTest-1000067181','8260713d-fdcd-4191-af23-f6434fb03aa7','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(145,'b0c74d35-b6cd-483e-99a5-1797a115cd5d','cad69cc4-2572-4bdb-8c9e-1c3092e995d2','2025-12-16 15:44:20',NULL,'UPDATE','IN_PROGRESS','my_encrypted_vol_type','d04bb176-d999-4187-87a7-3c1ee17cecb3','state changed','OS::Cinder::EncryptedVolumeType',NULL,26),(146,'4fe23e3f-99e3-425c-8020-7164f6e8f40f','cad69cc4-2572-4bdb-8c9e-1c3092e995d2','2025-12-16 15:44:20',NULL,'UPDATE','COMPLETE','my_encrypted_vol_type','d04bb176-d999-4187-87a7-3c1ee17cecb3','state changed','OS::Cinder::EncryptedVolumeType',NULL,30),(147,'324f81f4-1ce6-4a50-8c85-16f8d1a20962','cad69cc4-2572-4bdb-8c9e-1c3092e995d2','2025-12-16 15:44:20',NULL,'UPDATE','COMPLETE','EncryptionVolTypeTest-646776626','cad69cc4-2572-4bdb-8c9e-1c3092e995d2','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(148,'87e67586-dbab-4e52-87c8-94ec601a7a30','08ee559b-7930-4499-beaf-db872d98e2e0','2025-12-16 15:44:21',NULL,'CREATE','COMPLETE','subnet','7a035a94-8772-4843-ac94-6a3dd6f87467','state changed','OS::Neutron::Subnet',NULL,29),(149,'f8c72e01-9156-4335-99fe-a322eb3f0049','08ee559b-7930-4499-beaf-db872d98e2e0','2025-12-16 15:44:21',NULL,'CREATE','COMPLETE','UpdateSubnetTest-966863901','08ee559b-7930-4499-beaf-db872d98e2e0','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(150,'79da3eba-5f31-493c-a213-e81df66c3fe4','08ee559b-7930-4499-beaf-db872d98e2e0','2025-12-16 15:44:23',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-966863901','08ee559b-7930-4499-beaf-db872d98e2e0','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(151,'eecd2b3c-718a-48a8-bf3d-eceb72e89cb5','08ee559b-7930-4499-beaf-db872d98e2e0','2025-12-16 15:44:23',NULL,'UPDATE','IN_PROGRESS','subnet','7a035a94-8772-4843-ac94-6a3dd6f87467','state changed','OS::Neutron::Subnet',NULL,29),(152,'22939a7b-15e3-45bf-90c4-2a058e23ebe2','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:23',NULL,'CREATE','IN_PROGRESS','UpdatePortTest-362328687','faf9dd92-37dd-4c82-b953-42462946708c','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(153,'372c0da6-fa42-4ffc-9744-4d46e6ca241f','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:23',NULL,'CREATE','IN_PROGRESS','net','UpdatePortTest-362328687-net-p7ahktez2peo','state changed','OS::Neutron::Net',NULL,NULL),(154,'7b5fe4ca-94ac-491b-8770-98709742bd60','08ee559b-7930-4499-beaf-db872d98e2e0','2025-12-16 15:44:25',NULL,'UPDATE','COMPLETE','subnet','7a035a94-8772-4843-ac94-6a3dd6f87467','state changed','OS::Neutron::Subnet',NULL,32),(155,'bc067f02-26cc-4c90-9267-5e58f8df6047','08ee559b-7930-4499-beaf-db872d98e2e0','2025-12-16 15:44:25',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-966863901','08ee559b-7930-4499-beaf-db872d98e2e0','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(156,'8d11a628-27e0-4c94-aeb4-0717f515355b','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:25',NULL,'CREATE','COMPLETE','net','988675ee-d62e-4a1c-b165-d59556789c7c','state changed','OS::Neutron::Net',NULL,NULL),(157,'646d7357-391f-426f-bf0c-ec85e3b9e2e1','cad69cc4-2572-4bdb-8c9e-1c3092e995d2','2025-12-16 15:44:25',NULL,'DELETE','IN_PROGRESS','EncryptionVolTypeTest-646776626','cad69cc4-2572-4bdb-8c9e-1c3092e995d2','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(158,'76a93582-3cee-4806-8b7b-dfbcd1049ed8','cad69cc4-2572-4bdb-8c9e-1c3092e995d2','2025-12-16 15:44:26',NULL,'DELETE','IN_PROGRESS','my_encrypted_vol_type','d04bb176-d999-4187-87a7-3c1ee17cecb3','state changed','OS::Cinder::EncryptedVolumeType',NULL,30),(159,'cebf4e34-1305-4a95-a518-5068eb022429','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:26',NULL,'CREATE','IN_PROGRESS','subnet','UpdatePortTest-362328687-subnet-zp2ncqp24pyj','state changed','OS::Neutron::Subnet',NULL,33),(160,'8d0fb5f2-2d95-4709-a929-8a70b166cfc9','cad69cc4-2572-4bdb-8c9e-1c3092e995d2','2025-12-16 15:44:26',NULL,'DELETE','COMPLETE','my_encrypted_vol_type','d04bb176-d999-4187-87a7-3c1ee17cecb3','state changed','OS::Cinder::EncryptedVolumeType',NULL,30),(161,'bcdffec8-6506-468a-a29e-059b03f02629','cad69cc4-2572-4bdb-8c9e-1c3092e995d2','2025-12-16 15:44:26',NULL,'DELETE','IN_PROGRESS','my_volume_type','d04bb176-d999-4187-87a7-3c1ee17cecb3','state changed','OS::Cinder::VolumeType',NULL,25),(162,'4e7bb8e5-eb91-4857-bda1-cc8cf29d90dd','cad69cc4-2572-4bdb-8c9e-1c3092e995d2','2025-12-16 15:44:26',NULL,'DELETE','COMPLETE','my_volume_type','d04bb176-d999-4187-87a7-3c1ee17cecb3','state changed','OS::Cinder::VolumeType',NULL,25),(163,'af2f6903-0c41-438a-9f30-2b3462621333','cad69cc4-2572-4bdb-8c9e-1c3092e995d2','2025-12-16 15:44:26',NULL,'DELETE','COMPLETE','EncryptionVolTypeTest-646776626','cad69cc4-2572-4bdb-8c9e-1c3092e995d2','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(164,'5c01bc4e-ac6c-4c36-a8a4-8f083d790862','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:26',NULL,'CREATE','COMPLETE','subnet','005da2bf-fde6-41c6-b433-07a99386645d','state changed','OS::Neutron::Subnet',NULL,33),(165,'4a7fe844-c93c-4c3c-b91f-01dbbe358af3','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:26',NULL,'CREATE','IN_PROGRESS','port','UpdatePortTest-362328687-port-jyc4n7adcfjf','state changed','OS::Neutron::Port',NULL,34),(166,'9c6b52e6-7b91-4fb5-b86a-cb2211f14341','08ee559b-7930-4499-beaf-db872d98e2e0','2025-12-16 15:44:29',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-966863901','08ee559b-7930-4499-beaf-db872d98e2e0','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(167,'8269473d-b52b-496a-bc43-92a329404520','08ee559b-7930-4499-beaf-db872d98e2e0','2025-12-16 15:44:29',NULL,'DELETE','IN_PROGRESS','subnet','7a035a94-8772-4843-ac94-6a3dd6f87467','state changed','OS::Neutron::Subnet',NULL,32),(168,'3e72cd3a-0459-4949-a846-45a828316a44','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:29',NULL,'CREATE','COMPLETE','port','651f2e4d-4ff3-4d0e-b0de-360b948c6022','state changed','OS::Neutron::Port',NULL,34),(169,'4b3d6dc3-fc45-455f-8652-20d6c0d4011f','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:30',NULL,'CREATE','IN_PROGRESS','test','UpdatePortTest-362328687-test-c52jrqw662tz','state changed','OS::Heat::TestResource',NULL,37),(170,'7c7bcf2c-5289-42e4-a1ab-4913d62e7f60','08ee559b-7930-4499-beaf-db872d98e2e0','2025-12-16 15:44:30',NULL,'DELETE','COMPLETE','subnet','7a035a94-8772-4843-ac94-6a3dd6f87467','state changed','OS::Neutron::Subnet',NULL,32),(171,'21b0eba3-751e-4393-a319-320e33dc916a','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:30',NULL,'CREATE','COMPLETE','test','UpdatePortTest-362328687-test-c52jrqw662tz','state changed','OS::Heat::TestResource',NULL,37),(172,'7597f965-beef-45c2-a6f3-b9534891cefd','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:30',NULL,'CREATE','COMPLETE','UpdatePortTest-362328687','faf9dd92-37dd-4c82-b953-42462946708c','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(173,'d703cd7b-52f7-4a25-82b1-ec0caafd9e22','6d86f0cb-94d2-4040-ab94-f01bd5c0a1a1','2025-12-16 15:44:30',NULL,'CREATE','COMPLETE','server_with_encrypted_property','83863477-977c-4078-b9f7-2896a4167802','state changed','OS::Nova::Server',NULL,22),(174,'3fb99f43-c0cf-4296-9d49-d2e6742cd7fd','08ee559b-7930-4499-beaf-db872d98e2e0','2025-12-16 15:44:30',NULL,'DELETE','IN_PROGRESS','net','7abadcb6-58cc-46e9-b83e-dc22c778e6a8','state changed','OS::Neutron::Net',NULL,NULL),(175,'bad574a0-4e47-447a-a3fc-4a7c6c022345','6d86f0cb-94d2-4040-ab94-f01bd5c0a1a1','2025-12-16 15:44:30',NULL,'CREATE','COMPLETE','EncryptedParametersTest-223744132','6d86f0cb-94d2-4040-ab94-f01bd5c0a1a1','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(176,'cf6c5b31-e862-47b3-a9e1-505229e18913','08ee559b-7930-4499-beaf-db872d98e2e0','2025-12-16 15:44:31',NULL,'DELETE','COMPLETE','net','7abadcb6-58cc-46e9-b83e-dc22c778e6a8','state changed','OS::Neutron::Net',NULL,NULL),(177,'326b25fa-aa75-4acd-b412-d7c82930833b','08ee559b-7930-4499-beaf-db872d98e2e0','2025-12-16 15:44:31',NULL,'DELETE','COMPLETE','UpdateSubnetTest-966863901','08ee559b-7930-4499-beaf-db872d98e2e0','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(178,'493ffe64-6e36-454c-bbd5-8fc6fcd6ad57','c182542f-8886-45e3-92f1-2c88388c9805','2025-12-16 15:44:32',NULL,'CREATE','IN_PROGRESS','ExternalReferencesTest-602729546','c182542f-8886-45e3-92f1-2c88388c9805','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(179,'daf3db38-8e60-4c00-8731-c7e03dcff4ec','c182542f-8886-45e3-92f1-2c88388c9805','2025-12-16 15:44:32',NULL,'ADOPT','IN_PROGRESS','test1','ExternalReferencesTest-602729546-test1-apc5clqx43py','state changed','OS::Heat::TestResource',NULL,NULL),(180,'fa116455-e8ef-492d-afa2-a0cd445b6813','c182542f-8886-45e3-92f1-2c88388c9805','2025-12-16 15:44:32',NULL,'ADOPT','COMPLETE','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(181,'6380368e-f1bb-4636-913f-735bf3c20a45','c182542f-8886-45e3-92f1-2c88388c9805','2025-12-16 15:44:32',NULL,'CHECK','COMPLETE','test1','foobar','CHECK not supported for OS::Heat::TestResource','OS::Heat::TestResource',NULL,NULL),(182,'f1d7347e-624b-41cd-8cfe-f1f60bfaefb1','c182542f-8886-45e3-92f1-2c88388c9805','2025-12-16 15:44:32',NULL,'CREATE','COMPLETE','ExternalReferencesTest-602729546','c182542f-8886-45e3-92f1-2c88388c9805','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(183,'c741f7a2-6702-481d-96f4-99670348b98a','c182542f-8886-45e3-92f1-2c88388c9805','2025-12-16 15:44:33',NULL,'DELETE','IN_PROGRESS','ExternalReferencesTest-602729546','c182542f-8886-45e3-92f1-2c88388c9805','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(184,'1f9048cf-4e12-47b3-92af-2b5936c0f657','c182542f-8886-45e3-92f1-2c88388c9805','2025-12-16 15:44:33',NULL,'DELETE','IN_PROGRESS','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(185,'ae778c0d-7b1d-4a3c-a0e5-62f828dc51a6','c182542f-8886-45e3-92f1-2c88388c9805','2025-12-16 15:44:33',NULL,'DELETE','COMPLETE','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(186,'c3b0fd39-be61-43b8-a895-52a7021f48cf','c182542f-8886-45e3-92f1-2c88388c9805','2025-12-16 15:44:33',NULL,'DELETE','COMPLETE','ExternalReferencesTest-602729546','c182542f-8886-45e3-92f1-2c88388c9805','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(187,'febac0ba-e2aa-4924-b782-d0e72cacbbde','6d86f0cb-94d2-4040-ab94-f01bd5c0a1a1','2025-12-16 15:44:34',NULL,'DELETE','IN_PROGRESS','EncryptedParametersTest-223744132','6d86f0cb-94d2-4040-ab94-f01bd5c0a1a1','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(188,'d00ddba6-a17c-4797-bd10-b8911fe95cd3','6d86f0cb-94d2-4040-ab94-f01bd5c0a1a1','2025-12-16 15:44:34',NULL,'DELETE','IN_PROGRESS','server_with_encrypted_property','83863477-977c-4078-b9f7-2896a4167802','state changed','OS::Nova::Server',NULL,22),(189,'2aa4c60f-51a0-488e-88e7-6dd44110c9f4','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:34',NULL,'UPDATE','IN_PROGRESS','UpdatePortTest-362328687','faf9dd92-37dd-4c82-b953-42462946708c','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(190,'46699c0b-7999-490b-9719-871cc33d9ab3','3aa1f8fd-af1d-4aef-a4c8-11d33effdfbe','2025-12-16 15:44:35',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-1556041256','3aa1f8fd-af1d-4aef-a4c8-11d33effdfbe','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(191,'8c098ad0-58fd-4f6a-a4d0-69b231bb7480','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:35',NULL,'UPDATE','IN_PROGRESS','port','651f2e4d-4ff3-4d0e-b0de-360b948c6022','state changed','OS::Neutron::Port',NULL,34),(192,'f6a51299-ddb0-491c-bc41-a28c6c649afd','3aa1f8fd-af1d-4aef-a4c8-11d33effdfbe','2025-12-16 15:44:35',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-1556041256-net-3fjwwfk47umg','state changed','OS::Neutron::Net',NULL,NULL),(193,'59f9d424-3faf-4bdf-85db-6c1746c0e372','3aa1f8fd-af1d-4aef-a4c8-11d33effdfbe','2025-12-16 15:44:36',NULL,'CREATE','COMPLETE','net','9e153c3a-e85a-4b7d-a89c-337a302db45c','state changed','OS::Neutron::Net',NULL,NULL),(194,'843436d9-6e06-47a1-98ef-8a6eb85d640b','3aa1f8fd-af1d-4aef-a4c8-11d33effdfbe','2025-12-16 15:44:36',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-1556041256-subnet-57g5wmnzpnoa','state changed','OS::Neutron::Subnet',NULL,38),(195,'90765bf7-f80f-4a3e-8834-eabffb296219','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:37',NULL,'UPDATE','COMPLETE','port','651f2e4d-4ff3-4d0e-b0de-360b948c6022','The Resource port requires replacement.','OS::Neutron::Port',NULL,34),(196,'b125890e-a447-4dc9-a6f8-6682785a29c2','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:37',NULL,'CREATE','IN_PROGRESS','port','UpdatePortTest-362328687-port-xupnjzvkfaiv','state changed','OS::Neutron::Port',NULL,39),(197,'39b5436a-f688-4937-85cc-58ffcc764abd','6d86f0cb-94d2-4040-ab94-f01bd5c0a1a1','2025-12-16 15:44:37',NULL,'DELETE','COMPLETE','server_with_encrypted_property','83863477-977c-4078-b9f7-2896a4167802','state changed','OS::Nova::Server',NULL,22),(198,'cfdcdc55-8129-457c-971d-7f9ad10d51e5','6d86f0cb-94d2-4040-ab94-f01bd5c0a1a1','2025-12-16 15:44:37',NULL,'DELETE','COMPLETE','EncryptedParametersTest-223744132','6d86f0cb-94d2-4040-ab94-f01bd5c0a1a1','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(199,'ee4b71cc-6df8-48fe-9679-8c4b580c9050','3aa1f8fd-af1d-4aef-a4c8-11d33effdfbe','2025-12-16 15:44:37',NULL,'CREATE','COMPLETE','subnet','207f9bf8-3f92-4f20-b897-84577d4decca','state changed','OS::Neutron::Subnet',NULL,38),(200,'641a1ff7-6aef-427d-bd9c-9846ba8777dc','3aa1f8fd-af1d-4aef-a4c8-11d33effdfbe','2025-12-16 15:44:37',NULL,'CREATE','COMPLETE','UpdateSubnetTest-1556041256','3aa1f8fd-af1d-4aef-a4c8-11d33effdfbe','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(201,'ca1d2d04-3bd9-4761-af06-26dcf3acf232','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:38',NULL,'CREATE','COMPLETE','port','4cc7fe87-3b15-410b-b4a7-43a6b577c726','state changed','OS::Neutron::Port',NULL,39),(202,'acfe9295-5f4b-4218-a876-d1beb1a2cfda','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:38',NULL,'DELETE','IN_PROGRESS','port','651f2e4d-4ff3-4d0e-b0de-360b948c6022','state changed','OS::Neutron::Port',NULL,34),(203,'79bbb5b3-4486-4132-b964-6ba0b300e9d8','5160f4e7-e7c9-46a6-be44-5025e0ec4a5c','2025-12-16 15:44:38',NULL,'CREATE','IN_PROGRESS','ExternalReferencesTest-173842663','5160f4e7-e7c9-46a6-be44-5025e0ec4a5c','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(204,'fdfcd27e-d867-4ecf-8da8-c1ed1fb20e81','5160f4e7-e7c9-46a6-be44-5025e0ec4a5c','2025-12-16 15:44:38',NULL,'ADOPT','IN_PROGRESS','test1','ExternalReferencesTest-173842663-test1-xnbfvtzx2whj','state changed','OS::Heat::TestResource',NULL,NULL),(205,'808cd7a6-a01e-4752-84db-f8fcfbab3ec3','5160f4e7-e7c9-46a6-be44-5025e0ec4a5c','2025-12-16 15:44:38',NULL,'ADOPT','COMPLETE','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(206,'b06be222-7a41-4af7-914b-07d6e1077c99','5160f4e7-e7c9-46a6-be44-5025e0ec4a5c','2025-12-16 15:44:38',NULL,'CHECK','COMPLETE','test1','foobar','CHECK not supported for OS::Heat::TestResource','OS::Heat::TestResource',NULL,NULL),(207,'883a2c8b-6a3c-4c8b-a00f-162d820c2d2c','5160f4e7-e7c9-46a6-be44-5025e0ec4a5c','2025-12-16 15:44:39',NULL,'CREATE','COMPLETE','ExternalReferencesTest-173842663','5160f4e7-e7c9-46a6-be44-5025e0ec4a5c','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(208,'0d0fe5cc-0fb1-429e-8839-b2a857aabf71','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:39',NULL,'DELETE','COMPLETE','port','651f2e4d-4ff3-4d0e-b0de-360b948c6022','state changed','OS::Neutron::Port',NULL,34),(209,'3c79afe0-5cd3-4977-af83-1bc718e714f1','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:39',NULL,'UPDATE','COMPLETE','UpdatePortTest-362328687','faf9dd92-37dd-4c82-b953-42462946708c','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(210,'363263c0-3016-46f9-93ce-03b290306a5b','5160f4e7-e7c9-46a6-be44-5025e0ec4a5c','2025-12-16 15:44:39',NULL,'UPDATE','IN_PROGRESS','ExternalReferencesTest-173842663','5160f4e7-e7c9-46a6-be44-5025e0ec4a5c','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(211,'279e6873-f239-40d4-95bc-9ac82bf6f080','5160f4e7-e7c9-46a6-be44-5025e0ec4a5c','2025-12-16 15:44:40',NULL,'UPDATE','COMPLETE','ExternalReferencesTest-173842663','5160f4e7-e7c9-46a6-be44-5025e0ec4a5c','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(212,'70c518cf-18cf-4a1e-a1a7-3b42adadc237','3aa1f8fd-af1d-4aef-a4c8-11d33effdfbe','2025-12-16 15:44:40',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-1556041256','3aa1f8fd-af1d-4aef-a4c8-11d33effdfbe','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(213,'1bc8ccda-caae-4901-a14e-795ec32cb9e2','dc24dfa9-4a55-4812-a358-1e5307817ecd','2025-12-16 15:44:40',NULL,'CREATE','IN_PROGRESS','server_with_port','dc24dfa9-4a55-4812-a358-1e5307817ecd','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(214,'5e28730c-835f-4ac5-baab-8c9ca59d9edf','3aa1f8fd-af1d-4aef-a4c8-11d33effdfbe','2025-12-16 15:44:40',NULL,'UPDATE','IN_PROGRESS','subnet','207f9bf8-3f92-4f20-b897-84577d4decca','state changed','OS::Neutron::Subnet',NULL,38),(215,'741d79df-b62a-4ead-a0a6-1b93ee8a48da','dc24dfa9-4a55-4812-a358-1e5307817ecd','2025-12-16 15:44:40',NULL,'CREATE','IN_PROGRESS','net','server_with_port-net-xoxia4txqsgh','state changed','OS::Neutron::Net',NULL,42),(216,'4583e892-51bb-44f4-99f9-b9c0dac4b53d','3aa1f8fd-af1d-4aef-a4c8-11d33effdfbe','2025-12-16 15:44:41',NULL,'UPDATE','COMPLETE','subnet','207f9bf8-3f92-4f20-b897-84577d4decca','state changed','OS::Neutron::Subnet',NULL,43),(217,'8ae301d0-0a9c-4fe1-9de5-b7d9f38c9c18','3aa1f8fd-af1d-4aef-a4c8-11d33effdfbe','2025-12-16 15:44:41',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-1556041256','3aa1f8fd-af1d-4aef-a4c8-11d33effdfbe','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(218,'032c5d53-1f8f-4577-945d-97ec2a5f8f4e','dc24dfa9-4a55-4812-a358-1e5307817ecd','2025-12-16 15:44:41',NULL,'CREATE','COMPLETE','net','f378d5a5-e48e-46f1-aed5-87cc280c42e6','state changed','OS::Neutron::Net',NULL,42),(219,'89eaa94b-4a7b-49f9-a813-bfda1ba3ee94','dc24dfa9-4a55-4812-a358-1e5307817ecd','2025-12-16 15:44:42',NULL,'CREATE','IN_PROGRESS','subnet','server_with_port-subnet-xvbouw6comi6','state changed','OS::Neutron::Subnet',NULL,44),(220,'9fc2a14d-b105-48da-8700-8a8a859a9629','dc24dfa9-4a55-4812-a358-1e5307817ecd','2025-12-16 15:44:43',NULL,'CREATE','COMPLETE','subnet','f0914cc6-fe72-49b0-9a1c-c542de5422d8','state changed','OS::Neutron::Subnet',NULL,44),(221,'3eaaa1be-60ca-4822-beca-abf5e41001f2','dc24dfa9-4a55-4812-a358-1e5307817ecd','2025-12-16 15:44:43',NULL,'CREATE','IN_PROGRESS','port','server_with_port-port-ko2vmngxtmhx','state changed','OS::Neutron::Port',NULL,45),(222,'9016cc8d-5fb8-4a31-b85f-8bb2a22f8d52','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:43',NULL,'DELETE','IN_PROGRESS','UpdatePortTest-362328687','faf9dd92-37dd-4c82-b953-42462946708c','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(223,'dc924c90-fee4-4d69-84d8-c3850130887f','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:43',NULL,'DELETE','IN_PROGRESS','port','4cc7fe87-3b15-410b-b4a7-43a6b577c726','state changed','OS::Neutron::Port',NULL,39),(224,'60a5bb33-f884-410b-9356-62c37039753b','dc24dfa9-4a55-4812-a358-1e5307817ecd','2025-12-16 15:44:44',NULL,'CREATE','COMPLETE','port','c91e7f46-d34e-425c-bb07-8bf710b279d0','state changed','OS::Neutron::Port',NULL,45),(225,'e7d28939-2401-41df-939b-8ed23aa5867f','dc24dfa9-4a55-4812-a358-1e5307817ecd','2025-12-16 15:44:44',NULL,'CREATE','IN_PROGRESS','server','server_with_port-server-gxi3x4ohzzdc','state changed','OS::Nova::Server',NULL,46),(226,'1b785e8d-1c9f-4591-97a7-9dd369f3d454','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:44',NULL,'DELETE','COMPLETE','port','4cc7fe87-3b15-410b-b4a7-43a6b577c726','state changed','OS::Neutron::Port',NULL,39),(227,'d302a5b3-36e8-4a32-892a-0d18f0deebc4','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:44',NULL,'DELETE','IN_PROGRESS','subnet','005da2bf-fde6-41c6-b433-07a99386645d','state changed','OS::Neutron::Subnet',NULL,33),(228,'8da6f8b1-8263-4f99-a356-3ab2d325473c','5160f4e7-e7c9-46a6-be44-5025e0ec4a5c','2025-12-16 15:44:44',NULL,'DELETE','IN_PROGRESS','ExternalReferencesTest-173842663','5160f4e7-e7c9-46a6-be44-5025e0ec4a5c','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(229,'9473cd57-7b55-4d9b-9414-88d77d98040a','5160f4e7-e7c9-46a6-be44-5025e0ec4a5c','2025-12-16 15:44:44',NULL,'DELETE','IN_PROGRESS','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(230,'62ed49f6-d6e0-4bda-b6fc-cb19de25668a','5160f4e7-e7c9-46a6-be44-5025e0ec4a5c','2025-12-16 15:44:44',NULL,'DELETE','COMPLETE','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(231,'70518a3e-b722-4f31-a501-8b38b13910aa','5160f4e7-e7c9-46a6-be44-5025e0ec4a5c','2025-12-16 15:44:44',NULL,'DELETE','COMPLETE','ExternalReferencesTest-173842663','5160f4e7-e7c9-46a6-be44-5025e0ec4a5c','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(232,'1bd9be35-0282-4dd2-bfed-eaab4ea15729','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:44',NULL,'DELETE','COMPLETE','subnet','005da2bf-fde6-41c6-b433-07a99386645d','state changed','OS::Neutron::Subnet',NULL,33),(233,'0997880c-3656-4000-afa2-bfeca33ad7a8','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:44',NULL,'DELETE','IN_PROGRESS','test','UpdatePortTest-362328687-test-c52jrqw662tz','state changed','OS::Heat::TestResource',NULL,37),(234,'d79f5048-3471-4ab6-bf89-e2156ae3228c','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:44',NULL,'DELETE','COMPLETE','test','UpdatePortTest-362328687-test-c52jrqw662tz','state changed','OS::Heat::TestResource',NULL,37),(235,'c1024848-fe7d-4e7b-914f-0dfa3e4712f3','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:44',NULL,'DELETE','IN_PROGRESS','net','988675ee-d62e-4a1c-b165-d59556789c7c','state changed','OS::Neutron::Net',NULL,NULL),(236,'d3021da1-1766-4832-8ded-b79194bd4ec9','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:45',NULL,'DELETE','COMPLETE','net','988675ee-d62e-4a1c-b165-d59556789c7c','state changed','OS::Neutron::Net',NULL,NULL),(237,'acbcafee-d4e5-4f4e-8e42-aadaf983dc1d','faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:45',NULL,'DELETE','COMPLETE','UpdatePortTest-362328687','faf9dd92-37dd-4c82-b953-42462946708c','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(238,'e4247fb3-9777-436b-bf7c-ed7c88c6e26b','3aa1f8fd-af1d-4aef-a4c8-11d33effdfbe','2025-12-16 15:44:45',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-1556041256','3aa1f8fd-af1d-4aef-a4c8-11d33effdfbe','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(239,'a79232c9-bb0c-4e62-835a-5c5963b0a5fe','3aa1f8fd-af1d-4aef-a4c8-11d33effdfbe','2025-12-16 15:44:45',NULL,'DELETE','IN_PROGRESS','subnet','207f9bf8-3f92-4f20-b897-84577d4decca','state changed','OS::Neutron::Subnet',NULL,43),(240,'2db3cf5c-f0fb-4656-b653-e6fe33005216','3aa1f8fd-af1d-4aef-a4c8-11d33effdfbe','2025-12-16 15:44:46',NULL,'DELETE','COMPLETE','subnet','207f9bf8-3f92-4f20-b897-84577d4decca','state changed','OS::Neutron::Subnet',NULL,43),(241,'7f5abc50-00b4-4f25-b278-e5d87eebc00f','3aa1f8fd-af1d-4aef-a4c8-11d33effdfbe','2025-12-16 15:44:46',NULL,'DELETE','IN_PROGRESS','net','9e153c3a-e85a-4b7d-a89c-337a302db45c','state changed','OS::Neutron::Net',NULL,NULL),(242,'32919d96-ba6a-4a16-826a-6fdcde4b751d','3aa1f8fd-af1d-4aef-a4c8-11d33effdfbe','2025-12-16 15:44:46',NULL,'DELETE','COMPLETE','net','9e153c3a-e85a-4b7d-a89c-337a302db45c','state changed','OS::Neutron::Net',NULL,NULL),(243,'0aaf5775-363d-4e90-9076-4cd35798ed9e','3aa1f8fd-af1d-4aef-a4c8-11d33effdfbe','2025-12-16 15:44:46',NULL,'DELETE','COMPLETE','UpdateSubnetTest-1556041256','3aa1f8fd-af1d-4aef-a4c8-11d33effdfbe','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(244,'70ba122e-6c5f-4e23-aa89-592a9ce90e23','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:44:50',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-765035019','6c086204-9386-488e-9d66-a50e7726acf8','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(245,'9b6ef451-df78-41cc-8d74-c0836d5d0990','17b2458c-423c-4abe-89f1-cedd7b87d864','2025-12-16 15:44:50',NULL,'CREATE','IN_PROGRESS','ExternalReferencesTest-1942669871','17b2458c-423c-4abe-89f1-cedd7b87d864','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(246,'c8a5444c-334a-4308-afff-67eb5600f921','17b2458c-423c-4abe-89f1-cedd7b87d864','2025-12-16 15:44:50',NULL,'CREATE','IN_PROGRESS','test1','ExternalReferencesTest-1942669871-test1-v6ubu4kbxxdo','state changed','OS::Heat::TestResource',NULL,NULL),(247,'2393ea4d-86da-4618-995f-1aec215879e1','17b2458c-423c-4abe-89f1-cedd7b87d864','2025-12-16 15:44:50',NULL,'CREATE','COMPLETE','test1','ExternalReferencesTest-1942669871-test1-v6ubu4kbxxdo','state changed','OS::Heat::TestResource',NULL,NULL),(248,'6642ad4b-17fa-4149-bde2-a8a177d0c653','17b2458c-423c-4abe-89f1-cedd7b87d864','2025-12-16 15:44:50',NULL,'CREATE','COMPLETE','ExternalReferencesTest-1942669871','17b2458c-423c-4abe-89f1-cedd7b87d864','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(249,'7226f80d-a978-4435-b3e3-0935b65e587e','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:44:50',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-765035019-trunk_net_one-ugbfdvkbhvzs','state changed','OS::Neutron::Net',NULL,NULL),(250,'5433353e-d751-4739-ad8e-bbb2a10c3fc4','d167ccd0-b456-4c81-a33e-417b0c2ab6e9','2025-12-16 15:44:51',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-1759798492','d167ccd0-b456-4c81-a33e-417b0c2ab6e9','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(251,'a00b8b22-3795-4022-b4a0-f87b42dba589','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:44:51',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-765035019-trunk_net_two-vps5lme3qc3f','state changed','OS::Neutron::Net',NULL,NULL),(252,'fec78e15-a82a-431a-a7de-41d6c7eb5cf5','d167ccd0-b456-4c81-a33e-417b0c2ab6e9','2025-12-16 15:44:52',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-1759798492-net-yx7vvknf336y','state changed','OS::Neutron::Net',NULL,NULL),(253,'37791fbf-773e-45a6-8375-b80767304767','17b2458c-423c-4abe-89f1-cedd7b87d864','2025-12-16 15:44:52',NULL,'UPDATE','IN_PROGRESS','ExternalReferencesTest-1942669871','17b2458c-423c-4abe-89f1-cedd7b87d864','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(254,'68f42924-2693-4513-a669-69d613d22235','17b2458c-423c-4abe-89f1-cedd7b87d864','2025-12-16 15:44:52',NULL,'UPDATE','FAILED','ExternalReferencesTest-1942669871','17b2458c-423c-4abe-89f1-cedd7b87d864','Resource UPDATE failed: NotSupported: resources.test1: Update to property external_id of test1 (OS::Heat::TestResource) is not supported.','OS::Heat::Stack',NULL,NULL),(255,'60239312-ba69-4baf-bded-a5e53fdde6de','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:44:52',NULL,'CREATE','COMPLETE','trunk_net_one','0ca8ec8d-723c-4457-b398-3d5955310c13','state changed','OS::Neutron::Net',NULL,NULL),(256,'9811ae1c-b0b6-431f-a9be-f07ae05f5c96','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:44:52',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-765035019-trunk_subnet_one-gpejk6mjgfmi','state changed','OS::Neutron::Subnet',NULL,48),(257,'d0032997-199d-4c9b-af2c-629412fbec00','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:44:52',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-765035019-parent_net-pacgawqawmj3','state changed','OS::Neutron::Net',NULL,NULL),(258,'25971828-810b-4bd4-b604-fb59b113ba0e','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:44:52',NULL,'CREATE','COMPLETE','trunk_net_two','2cd1ce60-1078-4e20-b428-8b5d8ce8fe70','state changed','OS::Neutron::Net',NULL,NULL),(259,'653a23bd-5f91-4f00-8750-91a9d17e7ffb','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:44:53',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-765035019-trunk_subnet_two-xdaneaszehlu','state changed','OS::Neutron::Subnet',NULL,49),(260,'3cbadd51-d525-451f-9a77-57217bf2eba1','d167ccd0-b456-4c81-a33e-417b0c2ab6e9','2025-12-16 15:44:53',NULL,'CREATE','COMPLETE','net','dd0c9566-c4ee-48a9-b5e2-13a52faec3cf','state changed','OS::Neutron::Net',NULL,NULL),(261,'52245d59-c8aa-4d4c-8bee-1a500d482b21','d167ccd0-b456-4c81-a33e-417b0c2ab6e9','2025-12-16 15:44:53',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-1759798492-subnet-67hqi2mjkewo','state changed','OS::Neutron::Subnet',NULL,50),(262,'b289c630-d555-4982-bae8-062741ce42c0','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:44:53',NULL,'CREATE','COMPLETE','trunk_subnet_one','b2b3994e-f06c-4469-bd72-ffa0145bcb41','state changed','OS::Neutron::Subnet',NULL,48),(263,'2d889868-aa14-43e8-ae0f-5f13c88092f1','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:44:53',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-765035019-sub_port_one-ax6v3t4an5md','state changed','OS::Neutron::Port',NULL,51),(264,'3e0a6e3b-a3b5-47bb-8d96-33cd60d014f2','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:44:55',NULL,'CREATE','COMPLETE','sub_port_one','30d7f562-ba64-43b0-a732-b0e77b761876','state changed','OS::Neutron::Port',NULL,51),(265,'e5aabbaf-e712-4126-8fa7-f806045d389b','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:44:55',NULL,'CREATE','COMPLETE','parent_net','533e452e-ba58-4d8c-a238-9a69e80d5bb6','state changed','OS::Neutron::Net',NULL,NULL),(266,'9ab74f27-6866-4775-8af2-4e818e5d4772','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:44:55',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-765035019-parent_subnet-ttm36axme6oa','state changed','OS::Neutron::Subnet',NULL,52),(267,'8f6f8e87-2ae2-4194-8629-2dbc2db1821e','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:44:56',NULL,'CREATE','COMPLETE','trunk_subnet_two','f36588c3-e4f3-4003-9a79-7cd327f302f3','state changed','OS::Neutron::Subnet',NULL,49),(268,'c2c7e319-92a4-4882-8b5f-186ed08a94c4','d167ccd0-b456-4c81-a33e-417b0c2ab6e9','2025-12-16 15:44:56',NULL,'CREATE','COMPLETE','subnet','04a60756-a939-4c15-91d8-40e76ef19f7d','state changed','OS::Neutron::Subnet',NULL,50),(269,'ef7b1890-a19d-4333-a557-6d5ceb40ca36','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:44:56',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-765035019-sub_port_two-mncfhqce6bli','state changed','OS::Neutron::Port',NULL,53),(270,'9b8811d1-92e5-41da-8d46-fad78c11ef62','d167ccd0-b456-4c81-a33e-417b0c2ab6e9','2025-12-16 15:44:56',NULL,'CREATE','COMPLETE','UpdateSubnetTest-1759798492','d167ccd0-b456-4c81-a33e-417b0c2ab6e9','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(271,'c4245385-e28b-45af-b6fe-0080d4863801','17b2458c-423c-4abe-89f1-cedd7b87d864','2025-12-16 15:44:56',NULL,'DELETE','IN_PROGRESS','ExternalReferencesTest-1942669871','17b2458c-423c-4abe-89f1-cedd7b87d864','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(272,'42da13d9-e1ee-4726-9440-6d63d2329b5d','17b2458c-423c-4abe-89f1-cedd7b87d864','2025-12-16 15:44:56',NULL,'DELETE','IN_PROGRESS','test1','ExternalReferencesTest-1942669871-test1-v6ubu4kbxxdo','state changed','OS::Heat::TestResource',NULL,NULL),(273,'3327dea4-035a-4003-87df-9b1be556a7df','17b2458c-423c-4abe-89f1-cedd7b87d864','2025-12-16 15:44:56',NULL,'DELETE','COMPLETE','test1','ExternalReferencesTest-1942669871-test1-v6ubu4kbxxdo','state changed','OS::Heat::TestResource',NULL,NULL),(274,'6af6a690-8ab1-4313-8666-4e57c6260d46','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:44:56',NULL,'CREATE','COMPLETE','parent_subnet','43a1907e-4d6c-48b5-8573-43bc1e941fd3','state changed','OS::Neutron::Subnet',NULL,52),(275,'d747f070-6205-4c46-bef4-7a2785bcdc95','17b2458c-423c-4abe-89f1-cedd7b87d864','2025-12-16 15:44:56',NULL,'DELETE','COMPLETE','ExternalReferencesTest-1942669871','17b2458c-423c-4abe-89f1-cedd7b87d864','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(276,'08e79ba5-40ff-41fa-ad8e-8510dd531545','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:44:56',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-765035019-parent_port-ij3ubyswirbs','state changed','OS::Neutron::Port',NULL,55),(277,'6a165bea-f87c-498c-aa87-7ca5d2774d1c','d167ccd0-b456-4c81-a33e-417b0c2ab6e9','2025-12-16 15:44:57',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-1759798492','d167ccd0-b456-4c81-a33e-417b0c2ab6e9','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(278,'3ca68f9f-5a3c-489b-90bf-becfa153f7e8','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:44:57',NULL,'CREATE','COMPLETE','sub_port_two','09a6543a-a053-4d74-b407-85188bc8afb3','state changed','OS::Neutron::Port',NULL,53),(279,'9fe4b5eb-88be-45f4-9dfd-68854c35b492','d167ccd0-b456-4c81-a33e-417b0c2ab6e9','2025-12-16 15:44:57',NULL,'UPDATE','IN_PROGRESS','subnet','04a60756-a939-4c15-91d8-40e76ef19f7d','state changed','OS::Neutron::Subnet',NULL,50),(280,'6aa68bb2-5178-49b5-8907-1788e8be5938','dc24dfa9-4a55-4812-a358-1e5307817ecd','2025-12-16 15:44:57',NULL,'CREATE','COMPLETE','server','4d64284e-6061-49bc-b049-da302f21ef2d','state changed','OS::Nova::Server',NULL,46),(281,'cb6a019a-fc10-4a9d-9afe-3a6467a1fcfa','dc24dfa9-4a55-4812-a358-1e5307817ecd','2025-12-16 15:44:57',NULL,'CREATE','COMPLETE','server_with_port','dc24dfa9-4a55-4812-a358-1e5307817ecd','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(282,'3d7f151b-bc64-4433-9a5c-efb515e4913b','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:44:57',NULL,'CREATE','COMPLETE','parent_port','b8b6bf6f-631b-477d-aacc-4b6367ac72f1','state changed','OS::Neutron::Port',NULL,55),(283,'3c3d06f0-1f46-48fd-a3b2-fcf493617df7','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:44:57',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-765035019-trunk-uiddzuj6ylxm','state changed','OS::Neutron::Trunk',NULL,56),(284,'36673dcc-626b-4392-b7be-b783528bcbe6','d167ccd0-b456-4c81-a33e-417b0c2ab6e9','2025-12-16 15:44:58',NULL,'UPDATE','COMPLETE','subnet','04a60756-a939-4c15-91d8-40e76ef19f7d','state changed','OS::Neutron::Subnet',NULL,57),(285,'cc426f78-3a34-41a5-b738-7fa1556f7757','dc24dfa9-4a55-4812-a358-1e5307817ecd','2025-12-16 15:44:58',NULL,'DELETE','IN_PROGRESS','server_with_port','dc24dfa9-4a55-4812-a358-1e5307817ecd','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(286,'988948d1-04ef-4610-a2d5-1f923eedd346','d167ccd0-b456-4c81-a33e-417b0c2ab6e9','2025-12-16 15:44:58',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-1759798492','d167ccd0-b456-4c81-a33e-417b0c2ab6e9','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(287,'6e8474a8-8872-414a-869a-59b92712263d','dc24dfa9-4a55-4812-a358-1e5307817ecd','2025-12-16 15:44:58',NULL,'DELETE','IN_PROGRESS','server','4d64284e-6061-49bc-b049-da302f21ef2d','state changed','OS::Nova::Server',NULL,46),(288,'dfc90503-2fa2-47b9-a110-57dc37f5aa38','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:44:59',NULL,'CREATE','COMPLETE','trunk','03a05b05-ff9e-4bac-a95e-6261cf2ed0ae','state changed','OS::Neutron::Trunk',NULL,56),(289,'ae7c3854-64db-4c75-b469-31b0621ef510','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:44:59',NULL,'CREATE','COMPLETE','UpdateTrunkTest-765035019','6c086204-9386-488e-9d66-a50e7726acf8','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(290,'d67a936e-0751-4466-a231-bbb4f96eb231','dc24dfa9-4a55-4812-a358-1e5307817ecd','2025-12-16 15:45:01',NULL,'DELETE','COMPLETE','server','4d64284e-6061-49bc-b049-da302f21ef2d','state changed','OS::Nova::Server',NULL,46),(291,'e0f31bdc-27f7-417c-baf6-a0d0e2cc90f8','dc24dfa9-4a55-4812-a358-1e5307817ecd','2025-12-16 15:45:01',NULL,'DELETE','IN_PROGRESS','port','c91e7f46-d34e-425c-bb07-8bf710b279d0','state changed','OS::Neutron::Port',NULL,45),(292,'fd242c52-b4d9-4b1a-97f7-a70497bccdf4','d167ccd0-b456-4c81-a33e-417b0c2ab6e9','2025-12-16 15:45:02',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-1759798492','d167ccd0-b456-4c81-a33e-417b0c2ab6e9','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(293,'1cc63919-ded0-46a4-a185-c0d8017becbc','d167ccd0-b456-4c81-a33e-417b0c2ab6e9','2025-12-16 15:45:02',NULL,'DELETE','IN_PROGRESS','subnet','04a60756-a939-4c15-91d8-40e76ef19f7d','state changed','OS::Neutron::Subnet',NULL,57),(294,'2f70a35c-22bd-4bca-a13d-0474b2914a8b','dc24dfa9-4a55-4812-a358-1e5307817ecd','2025-12-16 15:45:02',NULL,'DELETE','COMPLETE','port','c91e7f46-d34e-425c-bb07-8bf710b279d0','state changed','OS::Neutron::Port',NULL,45),(295,'666c5b39-099a-4f5c-90c5-f546ef1774b2','dc24dfa9-4a55-4812-a358-1e5307817ecd','2025-12-16 15:45:02',NULL,'DELETE','IN_PROGRESS','subnet','f0914cc6-fe72-49b0-9a1c-c542de5422d8','state changed','OS::Neutron::Subnet',NULL,44),(296,'67531644-979d-4370-9ed4-64b9da70ac13','d167ccd0-b456-4c81-a33e-417b0c2ab6e9','2025-12-16 15:45:03',NULL,'DELETE','COMPLETE','subnet','04a60756-a939-4c15-91d8-40e76ef19f7d','state changed','OS::Neutron::Subnet',NULL,57),(297,'9cdef527-ae2e-477d-af6c-feb5a81b8f4d','aece8a1c-3be3-4415-9d3f-9c9512d2cf0f','2025-12-16 15:45:03',NULL,'CREATE','IN_PROGRESS','HooksTest-632604305','aece8a1c-3be3-4415-9d3f-9c9512d2cf0f','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(298,'37597e47-0032-4d15-884a-ab8ded453042','d167ccd0-b456-4c81-a33e-417b0c2ab6e9','2025-12-16 15:45:03',NULL,'DELETE','IN_PROGRESS','net','dd0c9566-c4ee-48a9-b5e2-13a52faec3cf','state changed','OS::Neutron::Net',NULL,NULL),(299,'41fa9865-2c40-47ef-9eed-f8aa7008b071','aece8a1c-3be3-4415-9d3f-9c9512d2cf0f','2025-12-16 15:45:03',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-632604305-foo_step1-c6fqwkyz4nf2','state changed','OS::Heat::RandomString',NULL,NULL),(300,'0ee0de33-fc50-4520-9b6c-afd0c62a1606','aece8a1c-3be3-4415-9d3f-9c9512d2cf0f','2025-12-16 15:45:03',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-632604305-foo_step1-c6fqwkyz4nf2','state changed','OS::Heat::RandomString',NULL,NULL),(301,'b7bb1bb9-7a8b-4066-ba35-b8a7243a8688','aece8a1c-3be3-4415-9d3f-9c9512d2cf0f','2025-12-16 15:45:03',NULL,'INIT','COMPLETE','foo_step2',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(302,'ce56bff3-1c49-4535-95cc-853ee81c02ad','dc24dfa9-4a55-4812-a358-1e5307817ecd','2025-12-16 15:45:03',NULL,'DELETE','COMPLETE','subnet','f0914cc6-fe72-49b0-9a1c-c542de5422d8','state changed','OS::Neutron::Subnet',NULL,44),(303,'9d4bdf43-096e-45f6-a878-c82a09357225','dc24dfa9-4a55-4812-a358-1e5307817ecd','2025-12-16 15:45:03',NULL,'DELETE','IN_PROGRESS','net','f378d5a5-e48e-46f1-aed5-87cc280c42e6','state changed','OS::Neutron::Net',NULL,42),(304,'39c7af6b-e406-4ce1-b6e1-502f1febed2a','d167ccd0-b456-4c81-a33e-417b0c2ab6e9','2025-12-16 15:45:04',NULL,'DELETE','COMPLETE','net','dd0c9566-c4ee-48a9-b5e2-13a52faec3cf','state changed','OS::Neutron::Net',NULL,NULL),(305,'ffc87d11-fd35-4f13-80c3-ef81e2862de6','d167ccd0-b456-4c81-a33e-417b0c2ab6e9','2025-12-16 15:45:04',NULL,'DELETE','COMPLETE','UpdateSubnetTest-1759798492','d167ccd0-b456-4c81-a33e-417b0c2ab6e9','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(306,'0c6ba8df-6895-4b9c-9c50-eadb60ecd7ab','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:45:04',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-765035019','6c086204-9386-488e-9d66-a50e7726acf8','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(307,'a0a5787b-f739-4cca-89ba-e3292ff6e3ed','dc24dfa9-4a55-4812-a358-1e5307817ecd','2025-12-16 15:45:04',NULL,'DELETE','COMPLETE','net','f378d5a5-e48e-46f1-aed5-87cc280c42e6','state changed','OS::Neutron::Net',NULL,42),(308,'5badd634-1bbb-4552-bd3f-15816fb10ada','aece8a1c-3be3-4415-9d3f-9c9512d2cf0f','2025-12-16 15:45:04',NULL,'INIT','COMPLETE','foo_step2',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(309,'cb6db318-2e66-42d0-bab6-477edff55027','dc24dfa9-4a55-4812-a358-1e5307817ecd','2025-12-16 15:45:04',NULL,'DELETE','COMPLETE','server_with_port','dc24dfa9-4a55-4812-a358-1e5307817ecd','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(310,'a671566d-06ba-4c4e-8344-dfe6028e1e4e','aece8a1c-3be3-4415-9d3f-9c9512d2cf0f','2025-12-16 15:45:04',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-632604305-foo_step2-ok4peso6isoo','state changed','OS::Heat::RandomString',NULL,NULL),(311,'4a137435-d90f-40f3-a77b-61d792c0be11','aece8a1c-3be3-4415-9d3f-9c9512d2cf0f','2025-12-16 15:45:05',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-632604305-foo_step2-ok4peso6isoo','state changed','OS::Heat::RandomString',NULL,NULL),(312,'a5f530d4-3338-484b-b8f6-d22c5055a493','aece8a1c-3be3-4415-9d3f-9c9512d2cf0f','2025-12-16 15:45:05',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-632604305-foo_step3-2dym5qydxt44','state changed','OS::Heat::RandomString',NULL,NULL),(313,'62aa0d42-00fb-4543-9de5-ac12b85cdd99','aece8a1c-3be3-4415-9d3f-9c9512d2cf0f','2025-12-16 15:45:05',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-632604305-foo_step3-2dym5qydxt44','state changed','OS::Heat::RandomString',NULL,NULL),(314,'6a34f1bc-1af8-45c6-8a11-62f4ee27eff1','aece8a1c-3be3-4415-9d3f-9c9512d2cf0f','2025-12-16 15:45:05',NULL,'CREATE','COMPLETE','HooksTest-632604305','aece8a1c-3be3-4415-9d3f-9c9512d2cf0f','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(315,'b734bf0a-aa29-43c5-ae8e-90bfd63a8f1b','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:45:08',NULL,'UPDATE','IN_PROGRESS','trunk','03a05b05-ff9e-4bac-a95e-6261cf2ed0ae','state changed','OS::Neutron::Trunk',NULL,56),(316,'faa8e807-c5b2-4390-a4d7-bbdc0cce9de1','ab6b1518-741d-46cc-b916-eb32929e403b','2025-12-16 15:45:08',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-138587764','ab6b1518-741d-46cc-b916-eb32929e403b','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(317,'257dfdfb-9c7c-4337-a488-96d79352f553','ab6b1518-741d-46cc-b916-eb32929e403b','2025-12-16 15:45:08',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-138587764-net-lulea5jye5gp','state changed','OS::Neutron::Net',NULL,NULL),(318,'d0308201-3ad1-4557-ac05-b45ca5e49a22','66bc5d13-49c7-4625-9ba6-96c8ed066846','2025-12-16 15:45:08',NULL,'CREATE','IN_PROGRESS','server_with_sub_ip','66bc5d13-49c7-4625-9ba6-96c8ed066846','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(319,'774305cb-d210-463b-bc80-5b306f6d7eb2','66bc5d13-49c7-4625-9ba6-96c8ed066846','2025-12-16 15:45:08',NULL,'CREATE','IN_PROGRESS','net','server_with_sub_ip-net-nvdzddxkabz4','state changed','OS::Neutron::Net',NULL,59),(320,'919ca486-a97f-4ab1-8056-018ffdabd8d3','ab6b1518-741d-46cc-b916-eb32929e403b','2025-12-16 15:45:09',NULL,'CREATE','COMPLETE','net','9180c4d8-8da9-4d71-a9bd-e8b674e4c693','state changed','OS::Neutron::Net',NULL,NULL),(321,'969fd535-8124-4f29-9444-d677a703f727','ab6b1518-741d-46cc-b916-eb32929e403b','2025-12-16 15:45:09',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-138587764-subnet-zsz62cwyxogu','state changed','OS::Neutron::Subnet',NULL,60),(322,'2737e987-e109-4e0d-8e82-2851885d4a8b','aece8a1c-3be3-4415-9d3f-9c9512d2cf0f','2025-12-16 15:45:09',NULL,'DELETE','IN_PROGRESS','HooksTest-632604305','aece8a1c-3be3-4415-9d3f-9c9512d2cf0f','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(323,'ee46f0e3-a8a6-41b3-b61b-bba40af2dd29','aece8a1c-3be3-4415-9d3f-9c9512d2cf0f','2025-12-16 15:45:09',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-632604305-foo_step3-2dym5qydxt44','state changed','OS::Heat::RandomString',NULL,NULL),(324,'003dedc5-be60-4a49-8c6b-a7842788e5f1','aece8a1c-3be3-4415-9d3f-9c9512d2cf0f','2025-12-16 15:45:09',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-632604305-foo_step3-2dym5qydxt44','state changed','OS::Heat::RandomString',NULL,NULL),(325,'286ee544-98a7-4f0a-91c7-51802b6a9ba9','66bc5d13-49c7-4625-9ba6-96c8ed066846','2025-12-16 15:45:09',NULL,'CREATE','IN_PROGRESS','security_group','server_with_sub_ip-security_group-fnfiw3atxr6a','state changed','OS::Neutron::SecurityGroup',NULL,61),(326,'3b5dd82d-5492-4891-8e6b-0abf0b4092c8','aece8a1c-3be3-4415-9d3f-9c9512d2cf0f','2025-12-16 15:45:09',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-632604305-foo_step2-ok4peso6isoo','state changed','OS::Heat::RandomString',NULL,NULL),(327,'9c85256d-c039-4383-92b3-4dd1182c3277','aece8a1c-3be3-4415-9d3f-9c9512d2cf0f','2025-12-16 15:45:09',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-632604305-foo_step2-ok4peso6isoo','state changed','OS::Heat::RandomString',NULL,NULL),(328,'d21cf4bf-417d-493c-aa0c-01c94c4610b3','aece8a1c-3be3-4415-9d3f-9c9512d2cf0f','2025-12-16 15:45:10',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-632604305-foo_step1-c6fqwkyz4nf2','state changed','OS::Heat::RandomString',NULL,NULL),(329,'621a5cfa-3cb2-475a-813b-3952de143571','aece8a1c-3be3-4415-9d3f-9c9512d2cf0f','2025-12-16 15:45:10',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-632604305-foo_step1-c6fqwkyz4nf2','state changed','OS::Heat::RandomString',NULL,NULL),(330,'84462bd3-d143-41c5-a27b-3c7b200c9e24','aece8a1c-3be3-4415-9d3f-9c9512d2cf0f','2025-12-16 15:45:10',NULL,'DELETE','COMPLETE','HooksTest-632604305','aece8a1c-3be3-4415-9d3f-9c9512d2cf0f','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(331,'db7fa1de-7604-41cd-b11d-9ce0f7234ccc','66bc5d13-49c7-4625-9ba6-96c8ed066846','2025-12-16 15:45:10',NULL,'CREATE','COMPLETE','net','5e9d93a8-0edf-4366-849d-4cdce659d7ff','state changed','OS::Neutron::Net',NULL,59),(332,'52e31a8b-349a-4dca-911a-4fc6f1a8a97a','66bc5d13-49c7-4625-9ba6-96c8ed066846','2025-12-16 15:45:10',NULL,'CREATE','IN_PROGRESS','subnet','server_with_sub_ip-subnet-xiiw6oirspqo','state changed','OS::Neutron::Subnet',NULL,62),(333,'395bb2c4-2193-4311-83e8-a7ecad36cd9b','ab6b1518-741d-46cc-b916-eb32929e403b','2025-12-16 15:45:10',NULL,'CREATE','COMPLETE','subnet','c20447ad-17ae-41d4-b041-f2209f6609d9','state changed','OS::Neutron::Subnet',NULL,60),(334,'35dd9824-9185-48a5-80b9-095bd82c1e70','ab6b1518-741d-46cc-b916-eb32929e403b','2025-12-16 15:45:10',NULL,'CREATE','COMPLETE','UpdateSubnetTest-138587764','ab6b1518-741d-46cc-b916-eb32929e403b','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(335,'a994707e-aef6-43e6-b0ec-b72ce5b5a480','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:45:10',NULL,'UPDATE','COMPLETE','trunk','03a05b05-ff9e-4bac-a95e-6261cf2ed0ae','state changed','OS::Neutron::Trunk',NULL,63),(336,'1a89a6c3-b3eb-4b9c-bfc3-4fa583f8099c','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:45:11',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-765035019','6c086204-9386-488e-9d66-a50e7726acf8','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(337,'94d74213-b277-4182-871a-4cc2b19e027b','66bc5d13-49c7-4625-9ba6-96c8ed066846','2025-12-16 15:45:11',NULL,'CREATE','COMPLETE','security_group','3344d1af-601e-4d73-9366-76869ef76422','state changed','OS::Neutron::SecurityGroup',NULL,61),(338,'0a3725ae-b9f4-4e31-a3cd-826b09b82c0c','66bc5d13-49c7-4625-9ba6-96c8ed066846','2025-12-16 15:45:11',NULL,'CREATE','COMPLETE','subnet','c724bacf-87a6-417b-9728-f0f393c13ee5','state changed','OS::Neutron::Subnet',NULL,62),(339,'d4188233-7aa2-459d-a228-ee787288b20b','66bc5d13-49c7-4625-9ba6-96c8ed066846','2025-12-16 15:45:11',NULL,'CREATE','IN_PROGRESS','server','server_with_sub_ip-server-smggwr22xoe5','state changed','OS::Nova::Server',NULL,64),(340,'6b0ce92b-a019-44c7-a13c-ea9c406fd711','ab6b1518-741d-46cc-b916-eb32929e403b','2025-12-16 15:45:13',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-138587764','ab6b1518-741d-46cc-b916-eb32929e403b','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(341,'e8f014aa-c468-4300-bae8-ab7ac7e46108','ab6b1518-741d-46cc-b916-eb32929e403b','2025-12-16 15:45:14',NULL,'UPDATE','IN_PROGRESS','subnet','c20447ad-17ae-41d4-b041-f2209f6609d9','state changed','OS::Neutron::Subnet',NULL,60),(342,'8ed3c976-4c26-4133-ae7e-04f7b1d8e2ea','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:45:14',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-765035019','6c086204-9386-488e-9d66-a50e7726acf8','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(343,'4f62a693-f05b-42d9-a95d-5aa586f6076f','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:45:14',NULL,'DELETE','IN_PROGRESS','trunk','03a05b05-ff9e-4bac-a95e-6261cf2ed0ae','state changed','OS::Neutron::Trunk',NULL,63),(344,'a982c405-f741-41cb-a4e4-01739e3cb61f','ab6b1518-741d-46cc-b916-eb32929e403b','2025-12-16 15:45:15',NULL,'UPDATE','COMPLETE','subnet','c20447ad-17ae-41d4-b041-f2209f6609d9','state changed','OS::Neutron::Subnet',NULL,67),(345,'b18370e8-1dc9-44e1-85aa-87a9989f9f78','ab6b1518-741d-46cc-b916-eb32929e403b','2025-12-16 15:45:15',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-138587764','ab6b1518-741d-46cc-b916-eb32929e403b','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(346,'85f70764-5182-4d06-8f52-3dbe0a6c14f9','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:45:15',NULL,'DELETE','COMPLETE','trunk','03a05b05-ff9e-4bac-a95e-6261cf2ed0ae','state changed','OS::Neutron::Trunk',NULL,63),(347,'57c7ec17-be33-4232-9183-ab88d98603ad','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:45:15',NULL,'DELETE','IN_PROGRESS','parent_port','b8b6bf6f-631b-477d-aacc-4b6367ac72f1','state changed','OS::Neutron::Port',NULL,55),(348,'22866c31-244e-4c27-9b47-ff05cb058213','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:45:15',NULL,'DELETE','IN_PROGRESS','sub_port_one','30d7f562-ba64-43b0-a732-b0e77b761876','state changed','OS::Neutron::Port',NULL,51),(349,'67cfc138-dd17-4a11-bdcf-b5fc912e62ec','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:45:15',NULL,'DELETE','IN_PROGRESS','sub_port_two','09a6543a-a053-4d74-b407-85188bc8afb3','state changed','OS::Neutron::Port',NULL,53),(350,'77fc4748-a765-4b20-96a6-223155771516','697c6e6a-55db-4b0a-b86a-9cab8ffec23e','2025-12-16 15:45:15',NULL,'CREATE','IN_PROGRESS','HooksTest-1320952685','697c6e6a-55db-4b0a-b86a-9cab8ffec23e','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(351,'76cab503-4eac-4f7a-be10-b356a3c02ec2','697c6e6a-55db-4b0a-b86a-9cab8ffec23e','2025-12-16 15:45:15',NULL,'CREATE','IN_PROGRESS','nested','HooksTest-1320952685-nested-sdbz2ssevv6m','state changed','nested.yaml',NULL,NULL),(352,'987920ff-fac3-4596-b16a-4efc6f7ee687','9001ce9e-8520-4430-89ae-c26ecd5bcecf','2025-12-16 15:45:15',NULL,'CREATE','IN_PROGRESS','HooksTest-1320952685-nested-sdbz2ssevv6m','9001ce9e-8520-4430-89ae-c26ecd5bcecf','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(353,'6562c6cd-f443-4435-8572-ea9f6effa9bb','9001ce9e-8520-4430-89ae-c26ecd5bcecf','2025-12-16 15:45:15',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-1320952685-nested-sdbz2ssevv6m-foo_step1-h7htk3u2gybs','state changed','OS::Heat::RandomString',NULL,NULL),(354,'794b691a-e9bf-4835-b6da-e2d0017916ce','9001ce9e-8520-4430-89ae-c26ecd5bcecf','2025-12-16 15:45:15',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-1320952685-nested-sdbz2ssevv6m-foo_step1-h7htk3u2gybs','state changed','OS::Heat::RandomString',NULL,NULL),(355,'d67e27e1-d723-4220-94d3-42d152a767c0','9001ce9e-8520-4430-89ae-c26ecd5bcecf','2025-12-16 15:45:15',NULL,'INIT','COMPLETE','foo_step2',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(356,'33ad6a23-1a15-46fb-8a66-5a671fcfb6fe','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:45:15',NULL,'DELETE','COMPLETE','sub_port_two','09a6543a-a053-4d74-b407-85188bc8afb3','state changed','OS::Neutron::Port',NULL,53),(357,'81556d50-0048-4214-9214-25ebbb8589ed','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:45:15',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','f36588c3-e4f3-4003-9a79-7cd327f302f3','state changed','OS::Neutron::Subnet',NULL,49),(358,'9033ea36-f993-486d-875c-840fc1514ecf','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:45:15',NULL,'DELETE','COMPLETE','parent_port','b8b6bf6f-631b-477d-aacc-4b6367ac72f1','state changed','OS::Neutron::Port',NULL,55),(359,'af637bc9-e523-4c0e-abad-532fd52694b9','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:45:16',NULL,'DELETE','COMPLETE','sub_port_one','30d7f562-ba64-43b0-a732-b0e77b761876','state changed','OS::Neutron::Port',NULL,51),(360,'7dc174f3-bc08-4ead-aea6-58e545d876e0','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:45:16',NULL,'DELETE','IN_PROGRESS','parent_subnet','43a1907e-4d6c-48b5-8573-43bc1e941fd3','state changed','OS::Neutron::Subnet',NULL,52),(361,'cb6d08f0-c8fd-475d-a0e9-d709969b49e0','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:45:16',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','b2b3994e-f06c-4469-bd72-ffa0145bcb41','state changed','OS::Neutron::Subnet',NULL,48),(362,'04f71520-598a-48a0-a601-bfb864ab93e2','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:45:16',NULL,'DELETE','COMPLETE','trunk_subnet_two','f36588c3-e4f3-4003-9a79-7cd327f302f3','state changed','OS::Neutron::Subnet',NULL,49),(363,'7baff20c-2f9d-43e3-90b7-7f969c9dd760','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:45:16',NULL,'DELETE','COMPLETE','parent_subnet','43a1907e-4d6c-48b5-8573-43bc1e941fd3','state changed','OS::Neutron::Subnet',NULL,52),(364,'e6b4e015-37d8-4174-a160-e0c97a8a37f0','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:45:16',NULL,'DELETE','IN_PROGRESS','trunk_net_two','2cd1ce60-1078-4e20-b428-8b5d8ce8fe70','state changed','OS::Neutron::Net',NULL,NULL),(365,'feae53f6-e13d-47d7-ba28-31f46a1c8da3','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:45:16',NULL,'DELETE','COMPLETE','trunk_subnet_one','b2b3994e-f06c-4469-bd72-ffa0145bcb41','state changed','OS::Neutron::Subnet',NULL,48),(366,'f9205d11-46de-4f01-8a16-338df39e040a','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:45:16',NULL,'DELETE','IN_PROGRESS','parent_net','533e452e-ba58-4d8c-a238-9a69e80d5bb6','state changed','OS::Neutron::Net',NULL,NULL),(367,'3ef8fcc2-2d61-44ee-bf00-2e1d6f730801','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:45:16',NULL,'DELETE','IN_PROGRESS','trunk_net_one','0ca8ec8d-723c-4457-b398-3d5955310c13','state changed','OS::Neutron::Net',NULL,NULL),(368,'7a7cbe52-3cbd-49f5-a868-a5f64e051fd0','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:45:17',NULL,'DELETE','COMPLETE','trunk_net_two','2cd1ce60-1078-4e20-b428-8b5d8ce8fe70','state changed','OS::Neutron::Net',NULL,NULL),(369,'11e6d932-fbda-4dd0-90f7-58c91c39a632','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:45:17',NULL,'DELETE','COMPLETE','parent_net','533e452e-ba58-4d8c-a238-9a69e80d5bb6','state changed','OS::Neutron::Net',NULL,NULL),(370,'878e755d-36f5-4648-8bb7-60f748615523','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:45:17',NULL,'DELETE','COMPLETE','trunk_net_one','0ca8ec8d-723c-4457-b398-3d5955310c13','state changed','OS::Neutron::Net',NULL,NULL),(371,'eb10dbb6-45b1-452e-9809-96ea8b9aafef','6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:45:17',NULL,'DELETE','COMPLETE','UpdateTrunkTest-765035019','6c086204-9386-488e-9d66-a50e7726acf8','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(372,'f743e2fd-8048-4155-b828-98b3d0f331d8','ab6b1518-741d-46cc-b916-eb32929e403b','2025-12-16 15:45:18',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-138587764','ab6b1518-741d-46cc-b916-eb32929e403b','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(373,'6550e885-dbd6-445d-8429-a5cc4d558e67','ab6b1518-741d-46cc-b916-eb32929e403b','2025-12-16 15:45:18',NULL,'DELETE','IN_PROGRESS','subnet','c20447ad-17ae-41d4-b041-f2209f6609d9','state changed','OS::Neutron::Subnet',NULL,67),(374,'50076c13-dfe1-4ee7-ac3c-b7367c9bff24','ab6b1518-741d-46cc-b916-eb32929e403b','2025-12-16 15:45:19',NULL,'DELETE','COMPLETE','subnet','c20447ad-17ae-41d4-b041-f2209f6609d9','state changed','OS::Neutron::Subnet',NULL,67),(375,'8197d3a9-b3cd-4714-8bbd-5ff101d4a2f3','ab6b1518-741d-46cc-b916-eb32929e403b','2025-12-16 15:45:19',NULL,'DELETE','IN_PROGRESS','net','9180c4d8-8da9-4d71-a9bd-e8b674e4c693','state changed','OS::Neutron::Net',NULL,NULL),(376,'7ee39344-ac94-4676-8403-9a978964f11c','ab6b1518-741d-46cc-b916-eb32929e403b','2025-12-16 15:45:19',NULL,'DELETE','COMPLETE','net','9180c4d8-8da9-4d71-a9bd-e8b674e4c693','state changed','OS::Neutron::Net',NULL,NULL),(377,'d8f3ac54-e6c5-4207-b23e-11062d1608a5','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:19',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-1882122261','8c180679-a4c4-4a37-9fc5-693018752629','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(378,'7da5feea-209e-49c4-8993-65a2e21b26fe','ab6b1518-741d-46cc-b916-eb32929e403b','2025-12-16 15:45:19',NULL,'DELETE','COMPLETE','UpdateSubnetTest-138587764','ab6b1518-741d-46cc-b916-eb32929e403b','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(379,'51054e81-0183-49c6-8b3c-39f008e636e3','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:20',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-1882122261-trunk_net_one-s5p62h5oqxtx','state changed','OS::Neutron::Net',NULL,NULL),(380,'fbadee09-f5ea-48ef-990a-470da51ad719','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:20',NULL,'CREATE','COMPLETE','trunk_net_one','a5ef03ab-efa9-427a-b1a8-50fff1f527a0','state changed','OS::Neutron::Net',NULL,NULL),(381,'42bd9168-8f7b-473d-b22c-c297d23e90c9','9001ce9e-8520-4430-89ae-c26ecd5bcecf','2025-12-16 15:45:20',NULL,'INIT','COMPLETE','foo_step2',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(382,'554a15af-716c-497c-87b9-1ae9b812059d','9001ce9e-8520-4430-89ae-c26ecd5bcecf','2025-12-16 15:45:20',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-1320952685-nested-sdbz2ssevv6m-foo_step2-cae4mkysky36','state changed','OS::Heat::RandomString',NULL,NULL),(383,'65acd47c-ca43-4510-a633-f8d97759801c','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:21',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-1882122261-trunk_subnet_one-kcaw3i2yrbka','state changed','OS::Neutron::Subnet',NULL,69),(384,'199a7bae-b73b-4c82-870a-4ac2e6103716','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:21',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-1882122261-trunk_net_two-p7tkjvgv2646','state changed','OS::Neutron::Net',NULL,NULL),(385,'de67465e-c674-4950-8891-7c8e67e3f7ba','9001ce9e-8520-4430-89ae-c26ecd5bcecf','2025-12-16 15:45:22',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1320952685-nested-sdbz2ssevv6m-foo_step2-cae4mkysky36','state changed','OS::Heat::RandomString',NULL,NULL),(386,'06997be8-6eb0-4d98-a10c-1489fbcb3ade','9001ce9e-8520-4430-89ae-c26ecd5bcecf','2025-12-16 15:45:22',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-1320952685-nested-sdbz2ssevv6m-foo_step3-k6x2nfdbh3ja','state changed','OS::Heat::RandomString',NULL,NULL),(387,'4322641f-1933-4f07-95ff-e9b619369abc','9001ce9e-8520-4430-89ae-c26ecd5bcecf','2025-12-16 15:45:22',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-1320952685-nested-sdbz2ssevv6m-foo_step3-k6x2nfdbh3ja','state changed','OS::Heat::RandomString',NULL,NULL),(388,'ab18dccb-17f4-40b4-b86f-3390f07c6a97','9001ce9e-8520-4430-89ae-c26ecd5bcecf','2025-12-16 15:45:22',NULL,'CREATE','COMPLETE','HooksTest-1320952685-nested-sdbz2ssevv6m','9001ce9e-8520-4430-89ae-c26ecd5bcecf','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(389,'015c39ef-df64-45d7-ae9e-2641899aded6','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:22',NULL,'CREATE','COMPLETE','trunk_net_two','aa6f5415-3ace-472b-bbed-867e73e1c80f','state changed','OS::Neutron::Net',NULL,NULL),(390,'3ec15304-543b-445a-a4f3-c3763453273d','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:22',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-1882122261-parent_net-y25fi2oxsrbu','state changed','OS::Neutron::Net',NULL,NULL),(391,'eaa83410-5120-4ffe-ab3a-9b0ecdea7d4d','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:22',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-1882122261-trunk_subnet_two-fddtrvq6qmnu','state changed','OS::Neutron::Subnet',NULL,70),(392,'4c0b6802-e96e-44bb-809e-0247e4cdccee','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:22',NULL,'CREATE','COMPLETE','trunk_subnet_one','467b6540-0e00-45f3-821b-47b3571ff11d','state changed','OS::Neutron::Subnet',NULL,69),(393,'314d24b9-dbb0-42e0-8540-b97b82f6c4e0','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:22',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-1882122261-sub_port_one-jpijpkozck5g','state changed','OS::Neutron::Port',NULL,71),(394,'7a3deec2-d835-4a3e-956b-e82440848d73','697c6e6a-55db-4b0a-b86a-9cab8ffec23e','2025-12-16 15:45:22',NULL,'CREATE','COMPLETE','nested','9001ce9e-8520-4430-89ae-c26ecd5bcecf','state changed','nested.yaml',NULL,NULL),(395,'f49b0054-369d-4540-883f-0b53a4b922b2','697c6e6a-55db-4b0a-b86a-9cab8ffec23e','2025-12-16 15:45:22',NULL,'CREATE','COMPLETE','HooksTest-1320952685','697c6e6a-55db-4b0a-b86a-9cab8ffec23e','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(396,'2b82da69-75a6-437a-9ef1-d995d9908f91','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:22',NULL,'CREATE','COMPLETE','parent_net','f4e43340-6711-403b-bd8a-8f626953da7e','state changed','OS::Neutron::Net',NULL,NULL),(397,'fcd90bca-bb0a-48b3-874c-454d4271092a','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:22',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-1882122261-parent_subnet-p42a5uylhz4g','state changed','OS::Neutron::Subnet',NULL,72),(398,'b74e442c-f4ac-4d2a-83e0-59c65e301172','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:23',NULL,'CREATE','COMPLETE','sub_port_one','4744b553-17ed-4d47-bf14-5417484a7740','state changed','OS::Neutron::Port',NULL,71),(399,'609c9c13-e0aa-43f2-a1fe-f265455a7ef4','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:23',NULL,'CREATE','COMPLETE','trunk_subnet_two','08c3245e-b943-4d4d-8f3a-75e7f27edc96','state changed','OS::Neutron::Subnet',NULL,70),(400,'470c268e-78c1-4e75-b73c-9bb2770e8657','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:23',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-1882122261-sub_port_two-s4enuezxrlgv','state changed','OS::Neutron::Port',NULL,73),(401,'20472dd6-aa9b-4753-ab37-ca50ae0ebceb','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:24',NULL,'CREATE','COMPLETE','parent_subnet','92ace10a-8246-45b8-9505-b7e31fcc3d7b','state changed','OS::Neutron::Subnet',NULL,72),(402,'0ea6010f-55ac-4fce-80d0-d30578883cdb','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:24',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-1882122261-parent_port-aye6aamu6tbz','state changed','OS::Neutron::Port',NULL,74),(403,'b2064e74-5fb6-41f6-ad9a-d91f3adfa79d','66bc5d13-49c7-4625-9ba6-96c8ed066846','2025-12-16 15:45:24',NULL,'CREATE','COMPLETE','server','d7263344-ecb0-4e21-bc04-3fa4bec1cec0','state changed','OS::Nova::Server',NULL,64),(404,'39f412b7-a360-4c82-b36b-c092c88453a6','8538e2ba-965b-4b33-80e5-83f71aeda10f','2025-12-16 15:45:24',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-637759540','8538e2ba-965b-4b33-80e5-83f71aeda10f','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(405,'bd0d91c5-19bc-4309-a792-ac67b0e6ec44','66bc5d13-49c7-4625-9ba6-96c8ed066846','2025-12-16 15:45:24',NULL,'CREATE','COMPLETE','server_with_sub_ip','66bc5d13-49c7-4625-9ba6-96c8ed066846','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(406,'8dc6a7a4-d708-4c13-b932-215d96c09590','8538e2ba-965b-4b33-80e5-83f71aeda10f','2025-12-16 15:45:24',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-637759540-net-kylgi2kdu2mr','state changed','OS::Neutron::Net',NULL,NULL),(407,'a980f0ce-9cff-4d82-a9b6-944752b172b1','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:25',NULL,'CREATE','COMPLETE','sub_port_two','1a0d9c3c-ff94-40fe-a16a-fa36d5b7c08e','state changed','OS::Neutron::Port',NULL,73),(408,'4ca51861-7c18-4495-86c9-2e2e3d26fef2','697c6e6a-55db-4b0a-b86a-9cab8ffec23e','2025-12-16 15:45:25',NULL,'DELETE','IN_PROGRESS','HooksTest-1320952685','697c6e6a-55db-4b0a-b86a-9cab8ffec23e','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(409,'0e5eb297-c87a-4834-9205-f2152479b270','697c6e6a-55db-4b0a-b86a-9cab8ffec23e','2025-12-16 15:45:25',NULL,'DELETE','IN_PROGRESS','nested','9001ce9e-8520-4430-89ae-c26ecd5bcecf','state changed','nested.yaml',NULL,NULL),(410,'95bb31c4-4471-49a6-b170-dadb8054fa59','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:25',NULL,'CREATE','COMPLETE','parent_port','def2457d-6f59-48ab-adda-200ebf60ac79','state changed','OS::Neutron::Port',NULL,74),(411,'7e3ae98d-5607-4797-8900-cd2634c4cab8','9001ce9e-8520-4430-89ae-c26ecd5bcecf','2025-12-16 15:45:25',NULL,'DELETE','IN_PROGRESS','HooksTest-1320952685-nested-sdbz2ssevv6m','9001ce9e-8520-4430-89ae-c26ecd5bcecf','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(412,'88cf7b3d-fe0d-4227-a940-d1fc000ad11b','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:25',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-1882122261-trunk-v5g2zaiprih2','state changed','OS::Neutron::Trunk',NULL,75),(413,'3c6a29e9-41eb-48ef-abe0-3bbe44b4e4e8','8538e2ba-965b-4b33-80e5-83f71aeda10f','2025-12-16 15:45:25',NULL,'CREATE','COMPLETE','net','27c8ec9f-3315-455d-9159-e9193f7de3fd','state changed','OS::Neutron::Net',NULL,NULL),(414,'777e9b24-a3ee-49ce-a593-62d3fc5092c7','8538e2ba-965b-4b33-80e5-83f71aeda10f','2025-12-16 15:45:25',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-637759540-subnet-lpu7j2s3srqu','state changed','OS::Neutron::Subnet',NULL,76),(415,'bfa37765-2beb-4d80-adb3-217d6fb6f60a','9001ce9e-8520-4430-89ae-c26ecd5bcecf','2025-12-16 15:45:25',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-1320952685-nested-sdbz2ssevv6m-foo_step3-k6x2nfdbh3ja','state changed','OS::Heat::RandomString',NULL,NULL),(416,'6928cbe8-6e51-47f7-95a9-b45ea8baa744','9001ce9e-8520-4430-89ae-c26ecd5bcecf','2025-12-16 15:45:25',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-1320952685-nested-sdbz2ssevv6m-foo_step3-k6x2nfdbh3ja','state changed','OS::Heat::RandomString',NULL,NULL),(417,'e8cfe7b2-e25b-4695-9a2d-2248d0b12302','9001ce9e-8520-4430-89ae-c26ecd5bcecf','2025-12-16 15:45:26',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-1320952685-nested-sdbz2ssevv6m-foo_step2-cae4mkysky36','state changed','OS::Heat::RandomString',NULL,NULL),(418,'31ecf621-4fda-4ecd-af9b-36975037aa72','9001ce9e-8520-4430-89ae-c26ecd5bcecf','2025-12-16 15:45:27',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-1320952685-nested-sdbz2ssevv6m-foo_step2-cae4mkysky36','state changed','OS::Heat::RandomString',NULL,NULL),(419,'7dbf464d-6985-4d29-9061-796d1cabd509','9001ce9e-8520-4430-89ae-c26ecd5bcecf','2025-12-16 15:45:27',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-1320952685-nested-sdbz2ssevv6m-foo_step1-h7htk3u2gybs','state changed','OS::Heat::RandomString',NULL,NULL),(420,'105061d1-2dbc-4d36-be4f-4617761d6de6','9001ce9e-8520-4430-89ae-c26ecd5bcecf','2025-12-16 15:45:27',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-1320952685-nested-sdbz2ssevv6m-foo_step1-h7htk3u2gybs','state changed','OS::Heat::RandomString',NULL,NULL),(421,'fb6e2bdf-26c3-4150-ac5c-458c5ef1e76e','9001ce9e-8520-4430-89ae-c26ecd5bcecf','2025-12-16 15:45:28',NULL,'DELETE','COMPLETE','HooksTest-1320952685-nested-sdbz2ssevv6m','9001ce9e-8520-4430-89ae-c26ecd5bcecf','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(422,'82400b92-5463-4623-8e94-b8abf4ec7816','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:28',NULL,'CREATE','COMPLETE','trunk','dd5280ed-20eb-4742-852b-ca55ff07587b','state changed','OS::Neutron::Trunk',NULL,75),(423,'7a0c3c1a-3219-4e6d-86f2-8bb3187c2b22','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:28',NULL,'CREATE','COMPLETE','UpdateTrunkTest-1882122261','8c180679-a4c4-4a37-9fc5-693018752629','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(424,'0d9a2cea-7035-46e8-8cc9-6f1f33cc8d0e','8538e2ba-965b-4b33-80e5-83f71aeda10f','2025-12-16 15:45:28',NULL,'CREATE','COMPLETE','subnet','1e490ec1-18f1-4573-b41f-eb45904c0127','state changed','OS::Neutron::Subnet',NULL,76),(425,'7476d8b6-9652-471b-a371-99f027eec0b3','8538e2ba-965b-4b33-80e5-83f71aeda10f','2025-12-16 15:45:28',NULL,'CREATE','COMPLETE','UpdateSubnetTest-637759540','8538e2ba-965b-4b33-80e5-83f71aeda10f','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(426,'38a7124c-0d08-4a78-800d-447265dc932b','697c6e6a-55db-4b0a-b86a-9cab8ffec23e','2025-12-16 15:45:29',NULL,'DELETE','COMPLETE','nested','9001ce9e-8520-4430-89ae-c26ecd5bcecf','state changed','nested.yaml',NULL,NULL),(427,'4f54593a-f485-49d0-a5c5-fe513210452a','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:29',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-1882122261','8c180679-a4c4-4a37-9fc5-693018752629','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(428,'31fb7951-1450-4762-ae48-3ff2f1554382','697c6e6a-55db-4b0a-b86a-9cab8ffec23e','2025-12-16 15:45:29',NULL,'DELETE','COMPLETE','HooksTest-1320952685','697c6e6a-55db-4b0a-b86a-9cab8ffec23e','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(429,'ab7622e2-dcf3-4af4-aaa3-e67cc3bfc32f','66bc5d13-49c7-4625-9ba6-96c8ed066846','2025-12-16 15:45:30',NULL,'DELETE','IN_PROGRESS','server_with_sub_ip','66bc5d13-49c7-4625-9ba6-96c8ed066846','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(430,'77ff12f3-5be0-4592-9c0b-c90ac6cc5ee5','66bc5d13-49c7-4625-9ba6-96c8ed066846','2025-12-16 15:45:30',NULL,'DELETE','IN_PROGRESS','server','d7263344-ecb0-4e21-bc04-3fa4bec1cec0','state changed','OS::Nova::Server',NULL,64),(431,'8d10cfe3-460d-4f82-bc07-8c9c7bd637d6','8538e2ba-965b-4b33-80e5-83f71aeda10f','2025-12-16 15:45:30',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-637759540','8538e2ba-965b-4b33-80e5-83f71aeda10f','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(432,'072b7c8b-d54f-4d34-91e2-a81370831f67','8538e2ba-965b-4b33-80e5-83f71aeda10f','2025-12-16 15:45:32',NULL,'UPDATE','IN_PROGRESS','subnet','1e490ec1-18f1-4573-b41f-eb45904c0127','state changed','OS::Neutron::Subnet',NULL,76),(433,'5449c370-eb82-4cee-afcc-0313dc0b9005','8538e2ba-965b-4b33-80e5-83f71aeda10f','2025-12-16 15:45:33',NULL,'UPDATE','COMPLETE','subnet','1e490ec1-18f1-4573-b41f-eb45904c0127','state changed','OS::Neutron::Subnet',NULL,79),(434,'462b3b1f-97db-4027-adf1-d686c703f47d','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:33',NULL,'UPDATE','IN_PROGRESS','trunk','dd5280ed-20eb-4742-852b-ca55ff07587b','state changed','OS::Neutron::Trunk',NULL,75),(435,'b8a06430-c4b9-48c1-ab1e-976f15f40418','8538e2ba-965b-4b33-80e5-83f71aeda10f','2025-12-16 15:45:33',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-637759540','8538e2ba-965b-4b33-80e5-83f71aeda10f','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(436,'8d9b64ac-668b-4565-8ac5-aeabe149a7d9','66bc5d13-49c7-4625-9ba6-96c8ed066846','2025-12-16 15:45:34',NULL,'DELETE','COMPLETE','server','d7263344-ecb0-4e21-bc04-3fa4bec1cec0','state changed','OS::Nova::Server',NULL,64),(437,'3b658074-d162-4664-b7e1-ae304ab91511','66bc5d13-49c7-4625-9ba6-96c8ed066846','2025-12-16 15:45:34',NULL,'DELETE','IN_PROGRESS','security_group','3344d1af-601e-4d73-9366-76869ef76422','state changed','OS::Neutron::SecurityGroup',NULL,61),(438,'f988dc3c-4368-4394-911b-cdd79993775e','66bc5d13-49c7-4625-9ba6-96c8ed066846','2025-12-16 15:45:35',NULL,'DELETE','IN_PROGRESS','subnet','c724bacf-87a6-417b-9728-f0f393c13ee5','state changed','OS::Neutron::Subnet',NULL,62),(439,'27fd6446-ede6-4968-a4a4-fdd23a135432','66bc5d13-49c7-4625-9ba6-96c8ed066846','2025-12-16 15:45:36',NULL,'DELETE','COMPLETE','subnet','c724bacf-87a6-417b-9728-f0f393c13ee5','state changed','OS::Neutron::Subnet',NULL,62),(440,'cf22d45f-bf1f-4d0f-a139-dd3ea1250e46','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:36',NULL,'UPDATE','COMPLETE','trunk','dd5280ed-20eb-4742-852b-ca55ff07587b','state changed','OS::Neutron::Trunk',NULL,81),(441,'53cfda0d-9137-437f-8006-ee7532167d9c','66bc5d13-49c7-4625-9ba6-96c8ed066846','2025-12-16 15:45:36',NULL,'DELETE','IN_PROGRESS','net','5e9d93a8-0edf-4366-849d-4cdce659d7ff','state changed','OS::Neutron::Net',NULL,59),(442,'3450aa29-272f-432f-806d-6977e269dd8c','8538e2ba-965b-4b33-80e5-83f71aeda10f','2025-12-16 15:45:36',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-637759540','8538e2ba-965b-4b33-80e5-83f71aeda10f','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(443,'131cdd37-726c-4d2b-bb62-2c5edf8f02b1','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:36',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-1882122261','8c180679-a4c4-4a37-9fc5-693018752629','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(444,'1db2ddc3-bd09-4cce-b340-0c647e84ee05','4c07c631-500b-41b9-ab5f-28461b4804d9','2025-12-16 15:45:36',NULL,'CREATE','IN_PROGRESS','HooksTest-1967944382','4c07c631-500b-41b9-ab5f-28461b4804d9','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(445,'80c6e8a0-95a0-4f80-9dc6-84f033545562','8538e2ba-965b-4b33-80e5-83f71aeda10f','2025-12-16 15:45:36',NULL,'DELETE','IN_PROGRESS','subnet','1e490ec1-18f1-4573-b41f-eb45904c0127','state changed','OS::Neutron::Subnet',NULL,79),(446,'0de9d3cc-fc16-4c8d-907e-c6912988a7bf','4c07c631-500b-41b9-ab5f-28461b4804d9','2025-12-16 15:45:36',NULL,'INIT','COMPLETE','foo_step1',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(447,'ad448dac-083f-49b8-bb71-e991dcd04387','66bc5d13-49c7-4625-9ba6-96c8ed066846','2025-12-16 15:45:37',NULL,'DELETE','COMPLETE','net','5e9d93a8-0edf-4366-849d-4cdce659d7ff','state changed','OS::Neutron::Net',NULL,59),(448,'c6e3d042-78a9-46de-ad30-a3bcca9fbe76','66bc5d13-49c7-4625-9ba6-96c8ed066846','2025-12-16 15:45:37',NULL,'DELETE','COMPLETE','security_group','3344d1af-601e-4d73-9366-76869ef76422','state changed','OS::Neutron::SecurityGroup',NULL,61),(449,'604d40c0-6d8e-4669-a7cd-f785398d569d','8538e2ba-965b-4b33-80e5-83f71aeda10f','2025-12-16 15:45:37',NULL,'DELETE','COMPLETE','subnet','1e490ec1-18f1-4573-b41f-eb45904c0127','state changed','OS::Neutron::Subnet',NULL,79),(450,'7fe81f13-36e0-450f-9baa-7d11a3351448','66bc5d13-49c7-4625-9ba6-96c8ed066846','2025-12-16 15:45:37',NULL,'DELETE','COMPLETE','server_with_sub_ip','66bc5d13-49c7-4625-9ba6-96c8ed066846','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(451,'89db3674-937c-449c-83e6-77631742d53c','8538e2ba-965b-4b33-80e5-83f71aeda10f','2025-12-16 15:45:37',NULL,'DELETE','IN_PROGRESS','net','27c8ec9f-3315-455d-9159-e9193f7de3fd','state changed','OS::Neutron::Net',NULL,NULL),(452,'ad942dd2-5d2f-4a72-acaf-dcc1ca91809c','4c07c631-500b-41b9-ab5f-28461b4804d9','2025-12-16 15:45:37',NULL,'INIT','COMPLETE','foo_step1',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(453,'261ac8b4-bfc3-4aa6-8e9b-5fc77515a167','4c07c631-500b-41b9-ab5f-28461b4804d9','2025-12-16 15:45:37',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-1967944382-foo_step1-qkrhc54fco7f','state changed','OS::Heat::RandomString',NULL,NULL),(454,'9616f345-602f-415a-af1d-64f0ee7551b1','8538e2ba-965b-4b33-80e5-83f71aeda10f','2025-12-16 15:45:37',NULL,'DELETE','COMPLETE','net','27c8ec9f-3315-455d-9159-e9193f7de3fd','state changed','OS::Neutron::Net',NULL,NULL),(455,'41899d40-f1e2-4650-bf8b-79f8678b163c','8538e2ba-965b-4b33-80e5-83f71aeda10f','2025-12-16 15:45:37',NULL,'DELETE','COMPLETE','UpdateSubnetTest-637759540','8538e2ba-965b-4b33-80e5-83f71aeda10f','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(456,'bd11cc5a-44f4-4a5f-8a96-f91c140c9ade','4c07c631-500b-41b9-ab5f-28461b4804d9','2025-12-16 15:45:38',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-1967944382-foo_step1-qkrhc54fco7f','state changed','OS::Heat::RandomString',NULL,NULL),(457,'0df992bb-dd6d-468a-8e60-8de78d4eadc4','4c07c631-500b-41b9-ab5f-28461b4804d9','2025-12-16 15:45:39',NULL,'INIT','COMPLETE','foo_step2',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(458,'62b50cbe-0ee2-46f2-afc7-f8bdabf31542','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:40',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-1882122261','8c180679-a4c4-4a37-9fc5-693018752629','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(459,'72d90f73-91b6-4074-a9fe-6ce806baa7d8','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:40',NULL,'DELETE','IN_PROGRESS','trunk','dd5280ed-20eb-4742-852b-ca55ff07587b','state changed','OS::Neutron::Trunk',NULL,81),(460,'537fc8f4-37cb-4243-a7f0-ff5688e797d5','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:40',NULL,'DELETE','COMPLETE','trunk','dd5280ed-20eb-4742-852b-ca55ff07587b','state changed','OS::Neutron::Trunk',NULL,81),(461,'3db620b1-e077-4989-936b-98f25eb911f1','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:41',NULL,'DELETE','IN_PROGRESS','sub_port_one','4744b553-17ed-4d47-bf14-5417484a7740','state changed','OS::Neutron::Port',NULL,71),(462,'2810e4c1-aaa1-4768-bd88-7f819b973d6e','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:41',NULL,'DELETE','IN_PROGRESS','parent_port','def2457d-6f59-48ab-adda-200ebf60ac79','state changed','OS::Neutron::Port',NULL,74),(463,'5c5c7066-cc5f-4eac-b5c6-82ab383c114f','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:41',NULL,'DELETE','IN_PROGRESS','sub_port_two','1a0d9c3c-ff94-40fe-a16a-fa36d5b7c08e','state changed','OS::Neutron::Port',NULL,73),(464,'caf09796-5a1e-4e49-8e68-78425615e601','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:41',NULL,'DELETE','COMPLETE','parent_port','def2457d-6f59-48ab-adda-200ebf60ac79','state changed','OS::Neutron::Port',NULL,74),(465,'4b148000-9b83-4e97-b248-c0287b1b5905','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:41',NULL,'DELETE','IN_PROGRESS','parent_subnet','92ace10a-8246-45b8-9505-b7e31fcc3d7b','state changed','OS::Neutron::Subnet',NULL,72),(466,'96ed3abe-c678-4656-bfa7-dbbf4e84077d','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:41',NULL,'DELETE','COMPLETE','sub_port_one','4744b553-17ed-4d47-bf14-5417484a7740','state changed','OS::Neutron::Port',NULL,71),(467,'fdd1d69c-7a15-4222-9c68-83628fafdd15','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:41',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','467b6540-0e00-45f3-821b-47b3571ff11d','state changed','OS::Neutron::Subnet',NULL,69),(468,'9ba05441-6e27-42ac-be32-e5a21b2c0bb7','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:42',NULL,'DELETE','COMPLETE','sub_port_two','1a0d9c3c-ff94-40fe-a16a-fa36d5b7c08e','state changed','OS::Neutron::Port',NULL,73),(469,'a62b5494-70ab-4791-b24b-8ce1c47e7649','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:42',NULL,'DELETE','COMPLETE','parent_subnet','92ace10a-8246-45b8-9505-b7e31fcc3d7b','state changed','OS::Neutron::Subnet',NULL,72),(470,'91952e20-d4de-4b2d-a6e2-3d7759f7d843','7dcd0513-2b7b-4076-9abd-3e6390741252','2025-12-16 15:45:42',NULL,'CREATE','IN_PROGRESS','create_server_with_sub_ip','7dcd0513-2b7b-4076-9abd-3e6390741252','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(471,'50439748-321a-4d67-88d7-3f2ed06eb61a','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:42',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','08c3245e-b943-4d4d-8f3a-75e7f27edc96','state changed','OS::Neutron::Subnet',NULL,70),(472,'4161b3d8-10cb-4ff8-a97c-96028f2a7ad6','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:42',NULL,'DELETE','IN_PROGRESS','parent_net','f4e43340-6711-403b-bd8a-8f626953da7e','state changed','OS::Neutron::Net',NULL,NULL),(473,'ebdd97e9-f645-4be8-b887-190209dcb1fb','7dcd0513-2b7b-4076-9abd-3e6390741252','2025-12-16 15:45:42',NULL,'CREATE','IN_PROGRESS','net','create_server_with_sub_ip-net-tz2dfnho2xa5','state changed','OS::Neutron::Net',NULL,83),(474,'7174674d-bbb6-4bbf-836c-735b31f651ce','b2d03b09-2e79-423a-b882-e84637086794','2025-12-16 15:45:42',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-227927417','b2d03b09-2e79-423a-b882-e84637086794','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(475,'93504ab5-b79b-49e9-8c20-af6da0b72901','b2d03b09-2e79-423a-b882-e84637086794','2025-12-16 15:45:42',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-227927417-net-vzifhbfrgvoe','state changed','OS::Neutron::Net',NULL,NULL),(476,'8f3a8559-a8ee-4334-ad9a-5484fede9bdd','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:42',NULL,'DELETE','COMPLETE','trunk_subnet_one','467b6540-0e00-45f3-821b-47b3571ff11d','state changed','OS::Neutron::Subnet',NULL,69),(477,'1c67e05e-fa45-4488-8551-d1313dd97ec0','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:42',NULL,'DELETE','IN_PROGRESS','trunk_net_one','a5ef03ab-efa9-427a-b1a8-50fff1f527a0','state changed','OS::Neutron::Net',NULL,NULL),(478,'aafffec0-5717-4b50-9efb-1288851e225d','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:42',NULL,'DELETE','COMPLETE','trunk_subnet_two','08c3245e-b943-4d4d-8f3a-75e7f27edc96','state changed','OS::Neutron::Subnet',NULL,70),(479,'f44f1b55-0dc6-4fed-bddc-98d5078ee623','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:43',NULL,'DELETE','IN_PROGRESS','trunk_net_two','aa6f5415-3ace-472b-bbed-867e73e1c80f','state changed','OS::Neutron::Net',NULL,NULL),(480,'14e114d6-4b41-4d6c-95be-a29c0760f6b6','b2d03b09-2e79-423a-b882-e84637086794','2025-12-16 15:45:43',NULL,'CREATE','COMPLETE','net','3c4b0bbe-70fe-44a0-b21f-207a2bec29bc','state changed','OS::Neutron::Net',NULL,NULL),(481,'077ba7c9-cd5b-472a-bba2-ce5467790008','4c07c631-500b-41b9-ab5f-28461b4804d9','2025-12-16 15:45:43',NULL,'INIT','COMPLETE','foo_step2',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(482,'3fff69ff-b113-4d14-8b2e-b8725c745f84','b2d03b09-2e79-423a-b882-e84637086794','2025-12-16 15:45:43',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-227927417-subnet-4lyfxn5uiamd','state changed','OS::Neutron::Subnet',NULL,84),(483,'806da6b4-41bf-4292-b225-a03fc339b9b3','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:44',NULL,'DELETE','COMPLETE','parent_net','f4e43340-6711-403b-bd8a-8f626953da7e','state changed','OS::Neutron::Net',NULL,NULL),(484,'50f86dae-ea22-47dd-b668-1b4c6883c60a','4c07c631-500b-41b9-ab5f-28461b4804d9','2025-12-16 15:45:44',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-1967944382-foo_step2-fp5trkqe3onw','state changed','OS::Heat::RandomString',NULL,NULL),(485,'b6654c9e-c2c2-4ded-a9a3-d5c3a4954c0d','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:44',NULL,'DELETE','COMPLETE','trunk_net_one','a5ef03ab-efa9-427a-b1a8-50fff1f527a0','state changed','OS::Neutron::Net',NULL,NULL),(486,'c1c06160-1844-46dc-9fde-e00adfd26eae','7dcd0513-2b7b-4076-9abd-3e6390741252','2025-12-16 15:45:44',NULL,'CREATE','COMPLETE','net','4768f982-89e1-4200-835b-e7d7b8dfc57d','state changed','OS::Neutron::Net',NULL,83),(487,'0cf9e45f-042f-4ae7-ba9b-f2378a5749a9','7dcd0513-2b7b-4076-9abd-3e6390741252','2025-12-16 15:45:45',NULL,'CREATE','IN_PROGRESS','subnet_a','create_server_with_sub_ip-subnet_a-uckggbwfo4ra','state changed','OS::Neutron::Subnet',NULL,85),(488,'4f19cd3b-d07b-44d0-ac32-f521103e8c8b','7dcd0513-2b7b-4076-9abd-3e6390741252','2025-12-16 15:45:45',NULL,'CREATE','IN_PROGRESS','subnet_b','create_server_with_sub_ip-subnet_b-nwgsrvsxd6r6','state changed','OS::Neutron::Subnet',NULL,86),(489,'b0d74c4e-07f4-478d-a3ba-41604e35a139','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:45',NULL,'DELETE','COMPLETE','trunk_net_two','aa6f5415-3ace-472b-bbed-867e73e1c80f','state changed','OS::Neutron::Net',NULL,NULL),(490,'c6558182-59b7-4fa0-a595-95d4927fcb8c','8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:45',NULL,'DELETE','COMPLETE','UpdateTrunkTest-1882122261','8c180679-a4c4-4a37-9fc5-693018752629','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(491,'7a173879-2b8d-4bf6-91fb-dd220540e3fa','4c07c631-500b-41b9-ab5f-28461b4804d9','2025-12-16 15:45:45',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1967944382-foo_step2-fp5trkqe3onw','state changed','OS::Heat::RandomString',NULL,NULL),(492,'2ea125c0-f0c3-455a-821a-c96ba47ff558','4c07c631-500b-41b9-ab5f-28461b4804d9','2025-12-16 15:45:45',NULL,'INIT','COMPLETE','foo_step3',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(493,'45b09bfa-2287-4885-a743-6fe93ee81de2','b2d03b09-2e79-423a-b882-e84637086794','2025-12-16 15:45:45',NULL,'CREATE','COMPLETE','subnet','7f0ebe8d-694d-4def-91a2-9e24fcd09c3f','state changed','OS::Neutron::Subnet',NULL,84),(494,'def041a5-1e97-477c-8a5e-5e73c358632f','b2d03b09-2e79-423a-b882-e84637086794','2025-12-16 15:45:45',NULL,'CREATE','COMPLETE','UpdateSubnetTest-227927417','b2d03b09-2e79-423a-b882-e84637086794','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(495,'c8cafcff-8b71-44f1-979f-36f828d423e8','7dcd0513-2b7b-4076-9abd-3e6390741252','2025-12-16 15:45:46',NULL,'CREATE','COMPLETE','subnet_b','e674ccc0-7d4c-46f1-99f4-73e87c7f3440','state changed','OS::Neutron::Subnet',NULL,86),(496,'bb9e81f8-774b-4668-abcd-2a8bba6ecfc3','7dcd0513-2b7b-4076-9abd-3e6390741252','2025-12-16 15:45:47',NULL,'CREATE','COMPLETE','subnet_a','f6b995f7-acc8-421f-af3c-8ff5fdd1f7d9','state changed','OS::Neutron::Subnet',NULL,85),(497,'09686f23-0bec-4145-88ab-3ecf069484d0','7dcd0513-2b7b-4076-9abd-3e6390741252','2025-12-16 15:45:47',NULL,'CREATE','IN_PROGRESS','server','create_server_with_sub_ip-server-okkyol2tsc7b','state changed','OS::Nova::Server',NULL,88),(498,'f6e3164c-a3ff-419c-b97b-35f1b363cbef','b2d03b09-2e79-423a-b882-e84637086794','2025-12-16 15:45:47',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-227927417','b2d03b09-2e79-423a-b882-e84637086794','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(499,'f22cfa10-1fb2-4601-bc7a-b2ca4f9cbba3','b2d03b09-2e79-423a-b882-e84637086794','2025-12-16 15:45:48',NULL,'UPDATE','IN_PROGRESS','subnet','7f0ebe8d-694d-4def-91a2-9e24fcd09c3f','state changed','OS::Neutron::Subnet',NULL,84),(500,'4568b093-fa77-4752-9efb-a6cd93ff8c2e','4c07c631-500b-41b9-ab5f-28461b4804d9','2025-12-16 15:45:48',NULL,'INIT','COMPLETE','foo_step3',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(501,'e86e23cf-0173-4f29-975b-d7fdb29c91f6','b2d03b09-2e79-423a-b882-e84637086794','2025-12-16 15:45:48',NULL,'UPDATE','COMPLETE','subnet','7f0ebe8d-694d-4def-91a2-9e24fcd09c3f','state changed','OS::Neutron::Subnet',NULL,89),(502,'1e4fa691-e1ca-43ac-bd17-1eea071f536f','b2d03b09-2e79-423a-b882-e84637086794','2025-12-16 15:45:48',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-227927417','b2d03b09-2e79-423a-b882-e84637086794','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(503,'94bf051d-4278-4e10-928d-05b66e58154d','4c07c631-500b-41b9-ab5f-28461b4804d9','2025-12-16 15:45:49',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-1967944382-foo_step3-viasdc5te5qa','state changed','OS::Heat::RandomString',NULL,NULL),(504,'d33208eb-afc0-48ff-ad14-ef7886f0cf0c','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:45:50',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-893536808','2f071904-94aa-4752-919d-4282450ef5e1','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(505,'de11f5b3-4db6-4caa-ba40-5695e273d3b2','4c07c631-500b-41b9-ab5f-28461b4804d9','2025-12-16 15:45:50',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-1967944382-foo_step3-viasdc5te5qa','state changed','OS::Heat::RandomString',NULL,NULL),(506,'c160085b-e725-4529-87c7-c3f4e79a3753','4c07c631-500b-41b9-ab5f-28461b4804d9','2025-12-16 15:45:50',NULL,'CREATE','COMPLETE','HooksTest-1967944382','4c07c631-500b-41b9-ab5f-28461b4804d9','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(507,'ad7eb4f4-d8d7-485f-8a4b-9a53f1686fef','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:45:50',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-893536808-trunk_net_one-re6txmthqath','state changed','OS::Neutron::Net',NULL,NULL),(508,'9827d99a-254c-46b7-9ac6-d50b7733ce2a','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:45:51',NULL,'CREATE','COMPLETE','trunk_net_one','e68a87ac-d08c-4e62-b8d3-4e1c49892fa8','state changed','OS::Neutron::Net',NULL,NULL),(509,'2a88256e-c7ef-4781-9d16-e2676c2843b2','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:45:51',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-893536808-trunk_subnet_one-tyvelv44uktq','state changed','OS::Neutron::Subnet',NULL,90),(510,'e4c951a6-f297-4421-a20d-aacc90a516fd','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:45:51',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-893536808-trunk_net_two-rnsp2jrako74','state changed','OS::Neutron::Net',NULL,NULL),(511,'8f34466d-12cd-40e6-b6f6-d0d8744d9f26','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:45:52',NULL,'CREATE','COMPLETE','trunk_net_two','497cbd63-9e9c-4cce-a0f2-fd39dc7e8149','state changed','OS::Neutron::Net',NULL,NULL),(512,'32a9f02d-0424-480e-9c78-28855eba5488','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:45:52',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-893536808-trunk_subnet_two-hhy3zfaj4riv','state changed','OS::Neutron::Subnet',NULL,91),(513,'c6c11a7c-aca8-4ab6-af61-8883fbeb1261','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:45:52',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-893536808-parent_net-trk5uvzinlnw','state changed','OS::Neutron::Net',NULL,NULL),(514,'255ce3e7-6c73-490e-ac8f-17f0c1306239','b2d03b09-2e79-423a-b882-e84637086794','2025-12-16 15:45:52',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-227927417','b2d03b09-2e79-423a-b882-e84637086794','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(515,'745ece55-313f-4434-883d-7374bde8f9fa','b2d03b09-2e79-423a-b882-e84637086794','2025-12-16 15:45:52',NULL,'DELETE','IN_PROGRESS','subnet','7f0ebe8d-694d-4def-91a2-9e24fcd09c3f','state changed','OS::Neutron::Subnet',NULL,89),(516,'090d008e-af59-45dc-9b65-fe64d5575206','4c07c631-500b-41b9-ab5f-28461b4804d9','2025-12-16 15:45:53',NULL,'DELETE','IN_PROGRESS','HooksTest-1967944382','4c07c631-500b-41b9-ab5f-28461b4804d9','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(517,'40796922-be9a-43e8-9768-048ab1b330b0','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:45:53',NULL,'CREATE','COMPLETE','trunk_subnet_one','fd58f751-963d-4271-992f-0c9badcc10a7','state changed','OS::Neutron::Subnet',NULL,90),(518,'b9322515-462b-4180-b9e5-cbaaa41e31ac','4c07c631-500b-41b9-ab5f-28461b4804d9','2025-12-16 15:45:53',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-1967944382-foo_step3-viasdc5te5qa','state changed','OS::Heat::RandomString',NULL,NULL),(519,'8d3acd36-fcb1-41d2-a6e8-f0bc2ff96f6c','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:45:53',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-893536808-sub_port_one-k62sgjz2ra34','state changed','OS::Neutron::Port',NULL,93),(520,'f0326223-ea3f-4b87-9687-f06a79564e3e','4c07c631-500b-41b9-ab5f-28461b4804d9','2025-12-16 15:45:53',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-1967944382-foo_step3-viasdc5te5qa','state changed','OS::Heat::RandomString',NULL,NULL),(521,'0cb80726-097a-4b7e-b475-8024342e30c4','4c07c631-500b-41b9-ab5f-28461b4804d9','2025-12-16 15:45:53',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-1967944382-foo_step2-fp5trkqe3onw','state changed','OS::Heat::RandomString',NULL,NULL),(522,'c4b5803d-bc4f-4c83-be60-01fd87cdac7a','4c07c631-500b-41b9-ab5f-28461b4804d9','2025-12-16 15:45:53',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-1967944382-foo_step2-fp5trkqe3onw','state changed','OS::Heat::RandomString',NULL,NULL),(523,'9e2efd3d-55d4-4656-8da4-298125a22069','4c07c631-500b-41b9-ab5f-28461b4804d9','2025-12-16 15:45:53',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-1967944382-foo_step1-qkrhc54fco7f','state changed','OS::Heat::RandomString',NULL,NULL),(524,'ac9b784e-9d99-44f2-a07f-944feb182ccc','4c07c631-500b-41b9-ab5f-28461b4804d9','2025-12-16 15:45:53',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-1967944382-foo_step1-qkrhc54fco7f','state changed','OS::Heat::RandomString',NULL,NULL),(525,'527a2b0c-b4a9-4849-b678-945e5e257695','b2d03b09-2e79-423a-b882-e84637086794','2025-12-16 15:45:53',NULL,'DELETE','COMPLETE','subnet','7f0ebe8d-694d-4def-91a2-9e24fcd09c3f','state changed','OS::Neutron::Subnet',NULL,89),(526,'da578d08-ce66-4b37-bb02-1b7c978c7f2d','4c07c631-500b-41b9-ab5f-28461b4804d9','2025-12-16 15:45:53',NULL,'DELETE','COMPLETE','HooksTest-1967944382','4c07c631-500b-41b9-ab5f-28461b4804d9','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(527,'359f460a-35b2-41d4-bd19-4b7939d85272','b2d03b09-2e79-423a-b882-e84637086794','2025-12-16 15:45:53',NULL,'DELETE','IN_PROGRESS','net','3c4b0bbe-70fe-44a0-b21f-207a2bec29bc','state changed','OS::Neutron::Net',NULL,NULL),(528,'5271085f-d741-4a1b-b4dc-fbb6eebfcae0','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:45:53',NULL,'CREATE','COMPLETE','parent_net','dd48bbb4-98c4-4bce-8f1b-d8ae7e245c9a','state changed','OS::Neutron::Net',NULL,NULL),(529,'bb9423ef-caf2-4194-a271-fd6073063715','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:45:53',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-893536808-parent_subnet-3zev24lf3pby','state changed','OS::Neutron::Subnet',NULL,94),(530,'6d6867f2-e94e-4b38-9b5b-3f994a0c153e','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:45:54',NULL,'CREATE','COMPLETE','trunk_subnet_two','1ef79977-40f1-417b-80a8-a85c97944dc1','state changed','OS::Neutron::Subnet',NULL,91),(531,'83c7fe8f-b047-40df-9b0d-5d823010740f','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:45:54',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-893536808-sub_port_two-npjvtasfq5jp','state changed','OS::Neutron::Port',NULL,95),(532,'e3cfc3a3-24d9-4f97-938b-46e8ef4e7f99','b2d03b09-2e79-423a-b882-e84637086794','2025-12-16 15:45:54',NULL,'DELETE','COMPLETE','net','3c4b0bbe-70fe-44a0-b21f-207a2bec29bc','state changed','OS::Neutron::Net',NULL,NULL),(533,'7a068c7c-4b6b-4edc-a4fe-23d445f1c72d','b2d03b09-2e79-423a-b882-e84637086794','2025-12-16 15:45:54',NULL,'DELETE','COMPLETE','UpdateSubnetTest-227927417','b2d03b09-2e79-423a-b882-e84637086794','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(534,'f4c37399-9fc4-4f4a-89f6-9ffb888ba39e','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:45:54',NULL,'CREATE','COMPLETE','sub_port_one','22970da7-630d-48de-8c48-1232de46054a','state changed','OS::Neutron::Port',NULL,93),(535,'44dfb695-1363-46d6-b52a-0b1aa92403d6','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:45:55',NULL,'CREATE','COMPLETE','parent_subnet','2ba6f43c-dfab-4bc8-90ba-39cbb3cb5112','state changed','OS::Neutron::Subnet',NULL,94),(536,'73485ec4-e58c-4201-bc1f-a3e7e31c44cc','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:45:55',NULL,'CREATE','COMPLETE','sub_port_two','58f084a2-d25c-4741-a781-f0e60afad0cd','state changed','OS::Neutron::Port',NULL,95),(537,'c79fb8c2-0b17-4e83-a10a-dc1db1e57386','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:45:55',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-893536808-parent_port-42g3trhnpqs4','state changed','OS::Neutron::Port',NULL,96),(538,'75a3b0b7-263b-4764-a074-db1fbeb1e794','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:45:56',NULL,'CREATE','COMPLETE','parent_port','80b28691-b2e3-476f-97a4-b7b3c34c30ca','state changed','OS::Neutron::Port',NULL,96),(539,'72c6eed9-b7fe-4dad-bacb-48a6faecc82b','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:45:56',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-893536808-trunk-5j5i4fcslriq','state changed','OS::Neutron::Trunk',NULL,97),(540,'5b4acec0-e0da-43ba-b95b-8d4879130e9b','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:45:57',NULL,'CREATE','COMPLETE','trunk','7b70c9b5-7aa1-4dc2-a5fd-29acbb3c6097','state changed','OS::Neutron::Trunk',NULL,97),(541,'ccde90d5-6a51-46d5-8d96-2644eccbfc74','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:45:57',NULL,'CREATE','COMPLETE','UpdateTrunkTest-893536808','2f071904-94aa-4752-919d-4282450ef5e1','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(542,'4d7f5c13-168c-4aa1-a932-c4edaa09010d','7dcd0513-2b7b-4076-9abd-3e6390741252','2025-12-16 15:45:58',NULL,'CREATE','COMPLETE','server','47969cde-8042-4912-9dc5-68baf6728ffb','state changed','OS::Nova::Server',NULL,88),(543,'887d9a32-53c2-41d6-a6ad-8a97bef26381','7dcd0513-2b7b-4076-9abd-3e6390741252','2025-12-16 15:45:58',NULL,'CREATE','COMPLETE','create_server_with_sub_ip','7dcd0513-2b7b-4076-9abd-3e6390741252','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(544,'e4e62c27-e619-4480-88da-293884802635','05fdd3ab-69bd-4a63-9ace-ba29648e3fce','2025-12-16 15:45:58',NULL,'CREATE','IN_PROGRESS','StackOutputsTest-958285426','05fdd3ab-69bd-4a63-9ace-ba29648e3fce','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(545,'39fde242-414f-4db3-9a1d-ac96f4d9d829','05fdd3ab-69bd-4a63-9ace-ba29648e3fce','2025-12-16 15:45:58',NULL,'CREATE','IN_PROGRESS','parent','StackOutputsTest-958285426-parent-rdmyikl57on5','state changed','1.yaml',NULL,NULL),(546,'b69f04b4-690f-44b0-96eb-a585f684aa2d','edafdf4f-b38e-44f1-937c-7096617eaa83','2025-12-16 15:45:58',NULL,'CREATE','IN_PROGRESS','StackOutputsTest-958285426-parent-rdmyikl57on5','edafdf4f-b38e-44f1-937c-7096617eaa83','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(547,'a7afc186-6481-4de9-bbee-7dc2d82398c9','edafdf4f-b38e-44f1-937c-7096617eaa83','2025-12-16 15:45:58',NULL,'CREATE','IN_PROGRESS','test_resource_a','StackOutputsTest-958285426-parent-rdmyikl57on5-test_resource_a-hasekutlthno','state changed','OS::Heat::TestResource',NULL,98),(548,'8cd8321c-dc10-4c2d-b022-ef2370ca0fbc','edafdf4f-b38e-44f1-937c-7096617eaa83','2025-12-16 15:45:58',NULL,'CREATE','COMPLETE','test_resource_a','StackOutputsTest-958285426-parent-rdmyikl57on5-test_resource_a-hasekutlthno','state changed','OS::Heat::TestResource',NULL,98),(549,'f1f78c84-9877-405e-984b-f377c2fe3246','5756f7bd-aaf3-4b07-9cb4-ae8fa3e9b4dd','2025-12-16 15:45:58',NULL,'CREATE','IN_PROGRESS','HooksTest-720324335','5756f7bd-aaf3-4b07-9cb4-ae8fa3e9b4dd','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(550,'deb7103d-d22d-4551-b804-4ec36b3a73bc','5756f7bd-aaf3-4b07-9cb4-ae8fa3e9b4dd','2025-12-16 15:45:58',NULL,'CREATE','IN_PROGRESS','rg','HooksTest-720324335-rg-zvsray4uhdfi','state changed','OS::Heat::ResourceGroup',NULL,99),(551,'0e84ff6e-a5c4-4b75-a4a4-930f7ae840fe','713d07a9-6f40-4f17-8d78-33b6ba2e5268','2025-12-16 15:45:58',NULL,'CREATE','IN_PROGRESS','HooksTest-720324335-rg-zvsray4uhdfi','713d07a9-6f40-4f17-8d78-33b6ba2e5268','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(552,'b22d385c-7686-40b6-bcec-d0b69c7ee8fe','713d07a9-6f40-4f17-8d78-33b6ba2e5268','2025-12-16 15:45:58',NULL,'CREATE','IN_PROGRESS','0','HooksTest-720324335-rg-zvsray4uhdfi-0-yvrvtfkqjuzi','state changed','OS::Heat::RandomString',NULL,NULL),(553,'702b8a3c-a327-4ce0-8120-a7524f855f4f','713d07a9-6f40-4f17-8d78-33b6ba2e5268','2025-12-16 15:45:58',NULL,'CREATE','COMPLETE','0','HooksTest-720324335-rg-zvsray4uhdfi-0-yvrvtfkqjuzi','state changed','OS::Heat::RandomString',NULL,NULL),(554,'7b6a16f7-5d93-481b-87b5-f84b74bc6b29','713d07a9-6f40-4f17-8d78-33b6ba2e5268','2025-12-16 15:45:58',NULL,'CREATE','COMPLETE','HooksTest-720324335-rg-zvsray4uhdfi','713d07a9-6f40-4f17-8d78-33b6ba2e5268','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(555,'31d9fa43-d1be-49b0-92ce-63f8ce2123dc','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:45:59',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-893536808','2f071904-94aa-4752-919d-4282450ef5e1','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(556,'909c9e9e-5d6f-458d-b6c5-eebafc6986de','edafdf4f-b38e-44f1-937c-7096617eaa83','2025-12-16 15:45:59',NULL,'CREATE','IN_PROGRESS','test_resource_b','StackOutputsTest-958285426-parent-rdmyikl57on5-test_resource_b-gfva2r6voy5b','state changed','OS::Heat::TestResource',NULL,100),(557,'84486efc-5c06-49d9-8e97-f6086527d717','edafdf4f-b38e-44f1-937c-7096617eaa83','2025-12-16 15:45:59',NULL,'CREATE','COMPLETE','test_resource_b','StackOutputsTest-958285426-parent-rdmyikl57on5-test_resource_b-gfva2r6voy5b','state changed','OS::Heat::TestResource',NULL,100),(558,'16d0ec87-a83b-4097-bc66-b29e8b013567','edafdf4f-b38e-44f1-937c-7096617eaa83','2025-12-16 15:45:59',NULL,'CREATE','COMPLETE','StackOutputsTest-958285426-parent-rdmyikl57on5','edafdf4f-b38e-44f1-937c-7096617eaa83','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(559,'11cfdb18-4d78-4ea9-8307-a23938f7a173','5756f7bd-aaf3-4b07-9cb4-ae8fa3e9b4dd','2025-12-16 15:45:59',NULL,'CREATE','COMPLETE','rg','713d07a9-6f40-4f17-8d78-33b6ba2e5268','state changed','OS::Heat::ResourceGroup',NULL,99),(560,'b62dc34e-bff8-4ed4-988b-79938d6b945c','5756f7bd-aaf3-4b07-9cb4-ae8fa3e9b4dd','2025-12-16 15:45:59',NULL,'CREATE','COMPLETE','HooksTest-720324335','5756f7bd-aaf3-4b07-9cb4-ae8fa3e9b4dd','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(561,'8f52ba61-8953-4f79-b6df-b2b62664b887','05fdd3ab-69bd-4a63-9ace-ba29648e3fce','2025-12-16 15:46:00',NULL,'CREATE','COMPLETE','parent','edafdf4f-b38e-44f1-937c-7096617eaa83','state changed','1.yaml',NULL,NULL),(562,'c14d4746-efd6-4b06-92c2-8b7e10791f3d','05fdd3ab-69bd-4a63-9ace-ba29648e3fce','2025-12-16 15:46:00',NULL,'CREATE','COMPLETE','StackOutputsTest-958285426','05fdd3ab-69bd-4a63-9ace-ba29648e3fce','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(563,'fffbd288-21fc-4db9-b107-1fe1de1c9ea7','7dcd0513-2b7b-4076-9abd-3e6390741252','2025-12-16 15:46:01',NULL,'UPDATE','IN_PROGRESS','create_server_with_sub_ip','7dcd0513-2b7b-4076-9abd-3e6390741252','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(564,'a8a6b1ce-a934-49a7-9338-84c16dea45d4','7dcd0513-2b7b-4076-9abd-3e6390741252','2025-12-16 15:46:02',NULL,'UPDATE','IN_PROGRESS','server','47969cde-8042-4912-9dc5-68baf6728ffb','state changed','OS::Nova::Server',NULL,88),(565,'4239f3c5-9bfa-4177-9359-54f5575192af','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:46:03',NULL,'UPDATE','IN_PROGRESS','trunk','7b70c9b5-7aa1-4dc2-a5fd-29acbb3c6097','state changed','OS::Neutron::Trunk',NULL,97),(566,'e744511a-ccc2-4f0e-b6b9-97811e19fc88','05fdd3ab-69bd-4a63-9ace-ba29648e3fce','2025-12-16 15:46:03',NULL,'UPDATE','IN_PROGRESS','StackOutputsTest-958285426','05fdd3ab-69bd-4a63-9ace-ba29648e3fce','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(567,'17807ff0-7ebd-4643-b06a-392005ea76f7','05fdd3ab-69bd-4a63-9ace-ba29648e3fce','2025-12-16 15:46:04',NULL,'UPDATE','IN_PROGRESS','parent','edafdf4f-b38e-44f1-937c-7096617eaa83','state changed','1.yaml',NULL,NULL),(568,'0a222cea-5fd3-4459-9d9f-edc96e73f647','5756f7bd-aaf3-4b07-9cb4-ae8fa3e9b4dd','2025-12-16 15:46:05',NULL,'UPDATE','IN_PROGRESS','HooksTest-720324335','5756f7bd-aaf3-4b07-9cb4-ae8fa3e9b4dd','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(569,'fdbabaab-9ee9-490e-b916-486d49a123e8','edafdf4f-b38e-44f1-937c-7096617eaa83','2025-12-16 15:46:05',NULL,'UPDATE','IN_PROGRESS','StackOutputsTest-958285426-parent-rdmyikl57on5','edafdf4f-b38e-44f1-937c-7096617eaa83','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(570,'6afce581-9a4d-40bf-b0e1-d74b50665c8f','5756f7bd-aaf3-4b07-9cb4-ae8fa3e9b4dd','2025-12-16 15:46:05',NULL,'CREATE','COMPLETE','rg','713d07a9-6f40-4f17-8d78-33b6ba2e5268','UPDATE paused until Hook pre-update is cleared','OS::Heat::ResourceGroup',NULL,99),(571,'1dca94ee-fb4e-47df-a392-bd1d4648fc96','edafdf4f-b38e-44f1-937c-7096617eaa83','2025-12-16 15:46:07',NULL,'UPDATE','COMPLETE','StackOutputsTest-958285426-parent-rdmyikl57on5','edafdf4f-b38e-44f1-937c-7096617eaa83','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(572,'c449e9b7-f8a0-4e8e-b25f-e5f3002e1845','5756f7bd-aaf3-4b07-9cb4-ae8fa3e9b4dd','2025-12-16 15:46:07',NULL,'CREATE','COMPLETE','rg','713d07a9-6f40-4f17-8d78-33b6ba2e5268','Hook pre-update is cleared','OS::Heat::ResourceGroup',NULL,99),(573,'5cfffe46-7d31-44a1-a79b-a71dfc36c7b7','05fdd3ab-69bd-4a63-9ace-ba29648e3fce','2025-12-16 15:46:07',NULL,'UPDATE','COMPLETE','parent','edafdf4f-b38e-44f1-937c-7096617eaa83','state changed','1.yaml',NULL,NULL),(574,'87d9894e-b4d5-45df-a105-c342081a34fb','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:46:07',NULL,'UPDATE','COMPLETE','trunk','7b70c9b5-7aa1-4dc2-a5fd-29acbb3c6097','state changed','OS::Neutron::Trunk',NULL,102),(575,'5e3ef1d4-28d7-4c16-a81e-3d81e1f185f7','5756f7bd-aaf3-4b07-9cb4-ae8fa3e9b4dd','2025-12-16 15:46:07',NULL,'UPDATE','IN_PROGRESS','rg','713d07a9-6f40-4f17-8d78-33b6ba2e5268','state changed','OS::Heat::ResourceGroup',NULL,99),(576,'3e9e8ad1-9ae8-4b64-a2fd-58098d11633e','05fdd3ab-69bd-4a63-9ace-ba29648e3fce','2025-12-16 15:46:08',NULL,'UPDATE','COMPLETE','StackOutputsTest-958285426','05fdd3ab-69bd-4a63-9ace-ba29648e3fce','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(577,'5464c983-dccc-4545-90f9-9c5d6751a71b','713d07a9-6f40-4f17-8d78-33b6ba2e5268','2025-12-16 15:46:08',NULL,'UPDATE','IN_PROGRESS','HooksTest-720324335-rg-zvsray4uhdfi','713d07a9-6f40-4f17-8d78-33b6ba2e5268','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(578,'c9ba9039-1995-4ca0-bf90-fcd1524667ec','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:46:08',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-893536808','2f071904-94aa-4752-919d-4282450ef5e1','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(579,'1e25bd14-217d-4338-8573-fba644c765fe','713d07a9-6f40-4f17-8d78-33b6ba2e5268','2025-12-16 15:46:10',NULL,'CREATE','IN_PROGRESS','1','HooksTest-720324335-rg-zvsray4uhdfi-1-s2enc2y4uoj3','state changed','OS::Heat::RandomString',NULL,NULL),(580,'263ae206-90cc-49ed-bc09-458de775c0a8','713d07a9-6f40-4f17-8d78-33b6ba2e5268','2025-12-16 15:46:10',NULL,'CREATE','COMPLETE','1','HooksTest-720324335-rg-zvsray4uhdfi-1-s2enc2y4uoj3','state changed','OS::Heat::RandomString',NULL,NULL),(581,'60c6d9b6-8f0c-40c2-b426-5896faf1b44e','713d07a9-6f40-4f17-8d78-33b6ba2e5268','2025-12-16 15:46:10',NULL,'UPDATE','COMPLETE','HooksTest-720324335-rg-zvsray4uhdfi','713d07a9-6f40-4f17-8d78-33b6ba2e5268','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(582,'0c5e50f2-19cc-49ee-a2c5-762ff0bff290','05fdd3ab-69bd-4a63-9ace-ba29648e3fce','2025-12-16 15:46:10',NULL,'DELETE','IN_PROGRESS','StackOutputsTest-958285426','05fdd3ab-69bd-4a63-9ace-ba29648e3fce','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(583,'365dd06a-47f2-4f50-b0dc-2df6678849ad','05fdd3ab-69bd-4a63-9ace-ba29648e3fce','2025-12-16 15:46:10',NULL,'DELETE','IN_PROGRESS','parent','edafdf4f-b38e-44f1-937c-7096617eaa83','state changed','1.yaml',NULL,NULL),(584,'cfa1b55f-5f4e-4a2d-b013-76d35ff4de4b','edafdf4f-b38e-44f1-937c-7096617eaa83','2025-12-16 15:46:10',NULL,'DELETE','IN_PROGRESS','StackOutputsTest-958285426-parent-rdmyikl57on5','edafdf4f-b38e-44f1-937c-7096617eaa83','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(585,'4d59ede6-8b5c-4bad-97ad-8d3a77e0b16c','edafdf4f-b38e-44f1-937c-7096617eaa83','2025-12-16 15:46:10',NULL,'DELETE','IN_PROGRESS','test_resource_b','StackOutputsTest-958285426-parent-rdmyikl57on5-test_resource_b-gfva2r6voy5b','state changed','OS::Heat::TestResource',NULL,100),(586,'ffc27cad-9b99-461b-aad0-58868dc194cd','edafdf4f-b38e-44f1-937c-7096617eaa83','2025-12-16 15:46:10',NULL,'DELETE','COMPLETE','test_resource_b','StackOutputsTest-958285426-parent-rdmyikl57on5-test_resource_b-gfva2r6voy5b','state changed','OS::Heat::TestResource',NULL,100),(587,'630beb2a-399e-4021-b650-c5bda0c3b532','5756f7bd-aaf3-4b07-9cb4-ae8fa3e9b4dd','2025-12-16 15:46:10',NULL,'UPDATE','COMPLETE','rg','713d07a9-6f40-4f17-8d78-33b6ba2e5268','state changed','OS::Heat::ResourceGroup',NULL,104),(588,'5b9c17ca-15ec-45ea-992a-163ce0228313','5756f7bd-aaf3-4b07-9cb4-ae8fa3e9b4dd','2025-12-16 15:46:11',NULL,'UPDATE','COMPLETE','HooksTest-720324335','5756f7bd-aaf3-4b07-9cb4-ae8fa3e9b4dd','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(589,'31fe5739-1fa0-4289-bfe6-c79bfd2110d9','edafdf4f-b38e-44f1-937c-7096617eaa83','2025-12-16 15:46:11',NULL,'DELETE','IN_PROGRESS','test_resource_a','StackOutputsTest-958285426-parent-rdmyikl57on5-test_resource_a-hasekutlthno','state changed','OS::Heat::TestResource',NULL,98),(590,'a21147d1-f410-41f1-add2-7a56ab0e6ff1','edafdf4f-b38e-44f1-937c-7096617eaa83','2025-12-16 15:46:11',NULL,'DELETE','COMPLETE','test_resource_a','StackOutputsTest-958285426-parent-rdmyikl57on5-test_resource_a-hasekutlthno','state changed','OS::Heat::TestResource',NULL,98),(591,'b647b55a-ef1b-4c54-b59f-2ec07708ef5b','edafdf4f-b38e-44f1-937c-7096617eaa83','2025-12-16 15:46:11',NULL,'DELETE','COMPLETE','StackOutputsTest-958285426-parent-rdmyikl57on5','edafdf4f-b38e-44f1-937c-7096617eaa83','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(592,'02f52c5f-9965-47fd-97b8-bc95f7efb953','5756f7bd-aaf3-4b07-9cb4-ae8fa3e9b4dd','2025-12-16 15:46:12',NULL,'DELETE','IN_PROGRESS','HooksTest-720324335','5756f7bd-aaf3-4b07-9cb4-ae8fa3e9b4dd','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(593,'c103b0f6-a543-4adb-96a4-be5bf600fbe4','05fdd3ab-69bd-4a63-9ace-ba29648e3fce','2025-12-16 15:46:12',NULL,'DELETE','COMPLETE','parent','edafdf4f-b38e-44f1-937c-7096617eaa83','state changed','1.yaml',NULL,NULL),(594,'c00db949-5860-4f41-8746-2871d8e7f12c','05fdd3ab-69bd-4a63-9ace-ba29648e3fce','2025-12-16 15:46:12',NULL,'DELETE','COMPLETE','StackOutputsTest-958285426','05fdd3ab-69bd-4a63-9ace-ba29648e3fce','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(595,'1cc012d0-3e00-4fd5-a13d-fd816093fddb','5756f7bd-aaf3-4b07-9cb4-ae8fa3e9b4dd','2025-12-16 15:46:12',NULL,'DELETE','IN_PROGRESS','rg','713d07a9-6f40-4f17-8d78-33b6ba2e5268','state changed','OS::Heat::ResourceGroup',NULL,104),(596,'3e275da1-5090-4cae-a6aa-f2717b6a0ed1','713d07a9-6f40-4f17-8d78-33b6ba2e5268','2025-12-16 15:46:13',NULL,'DELETE','IN_PROGRESS','HooksTest-720324335-rg-zvsray4uhdfi','713d07a9-6f40-4f17-8d78-33b6ba2e5268','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(597,'f28c0294-db55-4d43-a740-b39390fd4df0','713d07a9-6f40-4f17-8d78-33b6ba2e5268','2025-12-16 15:46:13',NULL,'DELETE','IN_PROGRESS','0','HooksTest-720324335-rg-zvsray4uhdfi-0-yvrvtfkqjuzi','state changed','OS::Heat::RandomString',NULL,NULL),(598,'ac7ef242-0d60-4365-8534-bfc885facae5','713d07a9-6f40-4f17-8d78-33b6ba2e5268','2025-12-16 15:46:13',NULL,'DELETE','COMPLETE','0','HooksTest-720324335-rg-zvsray4uhdfi-0-yvrvtfkqjuzi','state changed','OS::Heat::RandomString',NULL,NULL),(599,'1c7be0f9-222c-4c66-b452-6970c3a3016d','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:46:13',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-893536808','2f071904-94aa-4752-919d-4282450ef5e1','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(600,'90de4b30-9b56-4ba3-a3c6-e9df240eff41','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:46:13',NULL,'DELETE','IN_PROGRESS','trunk','7b70c9b5-7aa1-4dc2-a5fd-29acbb3c6097','state changed','OS::Neutron::Trunk',NULL,102),(601,'e7a1a707-875f-4b0d-9944-d5cb917ab0a4','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:46:13',NULL,'DELETE','COMPLETE','trunk','7b70c9b5-7aa1-4dc2-a5fd-29acbb3c6097','state changed','OS::Neutron::Trunk',NULL,102),(602,'a7733239-96ab-4c00-8cc6-1fa5e7da3616','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:46:13',NULL,'DELETE','IN_PROGRESS','parent_port','80b28691-b2e3-476f-97a4-b7b3c34c30ca','state changed','OS::Neutron::Port',NULL,96),(603,'55b886ff-31aa-4d07-abeb-a74f517fda93','713d07a9-6f40-4f17-8d78-33b6ba2e5268','2025-12-16 15:46:14',NULL,'DELETE','IN_PROGRESS','1','HooksTest-720324335-rg-zvsray4uhdfi-1-s2enc2y4uoj3','state changed','OS::Heat::RandomString',NULL,NULL),(604,'7994dacd-b529-44e9-93c9-682a9a38f923','713d07a9-6f40-4f17-8d78-33b6ba2e5268','2025-12-16 15:46:14',NULL,'DELETE','COMPLETE','1','HooksTest-720324335-rg-zvsray4uhdfi-1-s2enc2y4uoj3','state changed','OS::Heat::RandomString',NULL,NULL),(605,'1a015129-52b9-4c51-ada9-0b07d4e73a0a','713d07a9-6f40-4f17-8d78-33b6ba2e5268','2025-12-16 15:46:14',NULL,'DELETE','COMPLETE','HooksTest-720324335-rg-zvsray4uhdfi','713d07a9-6f40-4f17-8d78-33b6ba2e5268','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(606,'05c7f7b3-0f2c-475d-b7e3-7edc44f5456e','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:46:14',NULL,'DELETE','COMPLETE','parent_port','80b28691-b2e3-476f-97a4-b7b3c34c30ca','state changed','OS::Neutron::Port',NULL,96),(607,'ef1c8fee-fe98-4d0d-9be8-5ce21b3bdd57','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:46:14',NULL,'DELETE','IN_PROGRESS','parent_subnet','2ba6f43c-dfab-4bc8-90ba-39cbb3cb5112','state changed','OS::Neutron::Subnet',NULL,94),(608,'a63754d2-30dd-4e1f-a4dc-519d079875da','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:46:14',NULL,'DELETE','IN_PROGRESS','sub_port_one','22970da7-630d-48de-8c48-1232de46054a','state changed','OS::Neutron::Port',NULL,93),(609,'aa018ae6-903b-41ee-a21e-53b1fa17df6e','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:46:14',NULL,'DELETE','COMPLETE','parent_subnet','2ba6f43c-dfab-4bc8-90ba-39cbb3cb5112','state changed','OS::Neutron::Subnet',NULL,94),(610,'f66ff31d-beff-4182-ba44-b2949248519c','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:46:14',NULL,'DELETE','IN_PROGRESS','parent_net','dd48bbb4-98c4-4bce-8f1b-d8ae7e245c9a','state changed','OS::Neutron::Net',NULL,NULL),(611,'1d4df8b3-4b6a-4374-b99c-57830795e791','5756f7bd-aaf3-4b07-9cb4-ae8fa3e9b4dd','2025-12-16 15:46:15',NULL,'DELETE','COMPLETE','rg','713d07a9-6f40-4f17-8d78-33b6ba2e5268','state changed','OS::Heat::ResourceGroup',NULL,104),(612,'968027a6-a761-4abb-ab32-f826614365d8','5756f7bd-aaf3-4b07-9cb4-ae8fa3e9b4dd','2025-12-16 15:46:15',NULL,'DELETE','COMPLETE','HooksTest-720324335','5756f7bd-aaf3-4b07-9cb4-ae8fa3e9b4dd','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(613,'a6e408f8-bba5-4d1f-a639-43924fffbdaf','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:46:15',NULL,'DELETE','COMPLETE','sub_port_one','22970da7-630d-48de-8c48-1232de46054a','state changed','OS::Neutron::Port',NULL,93),(614,'d41ad8cb-8845-4ffa-8dad-a175a7a14506','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:46:15',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','fd58f751-963d-4271-992f-0c9badcc10a7','state changed','OS::Neutron::Subnet',NULL,90),(615,'abc666d0-e7bf-4ded-b75e-917d23a0b324','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:46:16',NULL,'DELETE','COMPLETE','parent_net','dd48bbb4-98c4-4bce-8f1b-d8ae7e245c9a','state changed','OS::Neutron::Net',NULL,NULL),(616,'014b4dd4-ef0c-4b3c-aeb3-402f250f708b','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:46:16',NULL,'DELETE','COMPLETE','trunk_subnet_one','fd58f751-963d-4271-992f-0c9badcc10a7','state changed','OS::Neutron::Subnet',NULL,90),(617,'b04390e5-c32b-43c2-bb09-bc5a0579ca3b','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:46:16',NULL,'DELETE','IN_PROGRESS','sub_port_two','58f084a2-d25c-4741-a781-f0e60afad0cd','state changed','OS::Neutron::Port',NULL,95),(618,'867a3f95-ff72-4d87-8b2f-85ecba3f32e0','d48accfb-4bf1-4e41-9366-9bd13c556bf2','2025-12-16 15:46:16',NULL,'CREATE','IN_PROGRESS','StackOutputsTest-1029112348','d48accfb-4bf1-4e41-9366-9bd13c556bf2','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(619,'b0a3487e-e22c-431d-bffd-d8bb96d8fd0f','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:46:16',NULL,'DELETE','IN_PROGRESS','trunk_net_one','e68a87ac-d08c-4e62-b8d3-4e1c49892fa8','state changed','OS::Neutron::Net',NULL,NULL),(620,'460a2412-9c59-4195-93bc-79ab3fb530b7','d48accfb-4bf1-4e41-9366-9bd13c556bf2','2025-12-16 15:46:16',NULL,'CREATE','IN_PROGRESS','test_resource_a','StackOutputsTest-1029112348-test_resource_a-mgnauey5asaf','state changed','OS::Heat::TestResource',NULL,106),(621,'ec50f13f-105d-4617-9b78-f06b34c0104a','d48accfb-4bf1-4e41-9366-9bd13c556bf2','2025-12-16 15:46:17',NULL,'CREATE','COMPLETE','test_resource_a','StackOutputsTest-1029112348-test_resource_a-mgnauey5asaf','state changed','OS::Heat::TestResource',NULL,106),(622,'07b435ea-a518-4d06-88a9-8098310738c6','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:46:17',NULL,'DELETE','COMPLETE','sub_port_two','58f084a2-d25c-4741-a781-f0e60afad0cd','state changed','OS::Neutron::Port',NULL,95),(623,'1e128e97-dbab-4d90-9e94-7d50e6b31281','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:46:17',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','1ef79977-40f1-417b-80a8-a85c97944dc1','state changed','OS::Neutron::Subnet',NULL,91),(624,'1b5c4f5e-aff7-40e6-86a2-1988bd79ec1f','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:46:17',NULL,'DELETE','COMPLETE','trunk_net_one','e68a87ac-d08c-4e62-b8d3-4e1c49892fa8','state changed','OS::Neutron::Net',NULL,NULL),(625,'6ae2594f-eced-4829-bf1b-d69581736613','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:46:17',NULL,'DELETE','COMPLETE','trunk_subnet_two','1ef79977-40f1-417b-80a8-a85c97944dc1','state changed','OS::Neutron::Subnet',NULL,91),(626,'5a7ab5e2-ede6-4a3b-9640-2f26f9c60a7c','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:46:17',NULL,'DELETE','IN_PROGRESS','trunk_net_two','497cbd63-9e9c-4cce-a0f2-fd39dc7e8149','state changed','OS::Neutron::Net',NULL,NULL),(627,'f19b3af3-e9d6-4928-a251-6e9bf61cb679','d48accfb-4bf1-4e41-9366-9bd13c556bf2','2025-12-16 15:46:17',NULL,'CREATE','IN_PROGRESS','test_resource_b','StackOutputsTest-1029112348-test_resource_b-ykazmmamqpcy','state changed','OS::Heat::TestResource',NULL,107),(628,'52590d69-5a1e-4bb9-93de-61d667417869','d48accfb-4bf1-4e41-9366-9bd13c556bf2','2025-12-16 15:46:18',NULL,'CREATE','COMPLETE','test_resource_b','StackOutputsTest-1029112348-test_resource_b-ykazmmamqpcy','state changed','OS::Heat::TestResource',NULL,107),(629,'5a377aed-f837-4941-8f78-f51e633c3c4b','d48accfb-4bf1-4e41-9366-9bd13c556bf2','2025-12-16 15:46:18',NULL,'CREATE','COMPLETE','StackOutputsTest-1029112348','d48accfb-4bf1-4e41-9366-9bd13c556bf2','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(630,'aa2efc89-64e3-4fdb-82f6-c2e7337436e3','dbf8d2a1-37c1-4e86-ac7f-0d103ac50c64','2025-12-16 15:46:18',NULL,'CREATE','IN_PROGRESS','HooksTest-1903585384','dbf8d2a1-37c1-4e86-ac7f-0d103ac50c64','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(631,'68456292-1412-4601-8c95-2112d62d8890','dbf8d2a1-37c1-4e86-ac7f-0d103ac50c64','2025-12-16 15:46:18',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-1903585384-foo_step1-vomhrq5ni2cw','state changed','OS::Heat::RandomString',NULL,NULL),(632,'8f4758e1-34a5-419c-af7b-1e7ee30bbe74','dbf8d2a1-37c1-4e86-ac7f-0d103ac50c64','2025-12-16 15:46:18',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-1903585384-foo_step1-vomhrq5ni2cw','state changed','OS::Heat::RandomString',NULL,NULL),(633,'739153f5-d493-4f04-9971-f51cc8bf0041','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:46:18',NULL,'DELETE','COMPLETE','trunk_net_two','497cbd63-9e9c-4cce-a0f2-fd39dc7e8149','state changed','OS::Neutron::Net',NULL,NULL),(634,'fb2a9f12-099c-4c47-bc16-782f8214683b','2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:46:18',NULL,'DELETE','COMPLETE','UpdateTrunkTest-893536808','2f071904-94aa-4752-919d-4282450ef5e1','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(635,'ccce95c3-35bf-4d7a-afb7-7407ba2bab8c','dbf8d2a1-37c1-4e86-ac7f-0d103ac50c64','2025-12-16 15:46:18',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-1903585384-foo_step2-m26uk5ke2kna','state changed','OS::Heat::RandomString',NULL,NULL),(636,'5dc9ee0c-0e29-49ed-a817-615d11f54efa','dbf8d2a1-37c1-4e86-ac7f-0d103ac50c64','2025-12-16 15:46:18',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1903585384-foo_step2-m26uk5ke2kna','state changed','OS::Heat::RandomString',NULL,NULL),(637,'8fa34267-1d4a-4c4a-b484-e54c6e9b730b','dbf8d2a1-37c1-4e86-ac7f-0d103ac50c64','2025-12-16 15:46:18',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-1903585384-foo_step3-ikpttgb4qu7l','state changed','OS::Heat::RandomString',NULL,NULL),(638,'c267a595-42d6-4195-91d1-002bcca17dba','dbf8d2a1-37c1-4e86-ac7f-0d103ac50c64','2025-12-16 15:46:18',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-1903585384-foo_step3-ikpttgb4qu7l','state changed','OS::Heat::RandomString',NULL,NULL),(639,'380c513d-c320-489e-8f58-57107be15d4b','dbf8d2a1-37c1-4e86-ac7f-0d103ac50c64','2025-12-16 15:46:18',NULL,'CREATE','COMPLETE','HooksTest-1903585384','dbf8d2a1-37c1-4e86-ac7f-0d103ac50c64','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(640,'655e01ba-a9e8-4ff6-b11a-47ec6a0aad4c','dbf8d2a1-37c1-4e86-ac7f-0d103ac50c64','2025-12-16 15:46:19',NULL,'UPDATE','IN_PROGRESS','HooksTest-1903585384','dbf8d2a1-37c1-4e86-ac7f-0d103ac50c64','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(641,'5596668b-1466-46f4-9965-faeeded05d0d','dbf8d2a1-37c1-4e86-ac7f-0d103ac50c64','2025-12-16 15:46:20',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1903585384-foo_step2-m26uk5ke2kna','UPDATE paused until Hook pre-update is cleared','OS::Heat::RandomString',NULL,NULL),(642,'e8a294bf-8905-4571-8173-39deea7d6cec','dbf8d2a1-37c1-4e86-ac7f-0d103ac50c64','2025-12-16 15:46:20',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1903585384-foo_step2-m26uk5ke2kna','Hook pre-update is cleared','OS::Heat::RandomString',NULL,NULL),(643,'d5b2720d-6afd-4404-98f2-ea63fb4c3538','dbf8d2a1-37c1-4e86-ac7f-0d103ac50c64','2025-12-16 15:46:21',NULL,'UPDATE','COMPLETE','HooksTest-1903585384','dbf8d2a1-37c1-4e86-ac7f-0d103ac50c64','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(644,'eef7fb49-aa39-416d-ac1c-173d88f95e87','d48accfb-4bf1-4e41-9366-9bd13c556bf2','2025-12-16 15:46:21',NULL,'DELETE','IN_PROGRESS','StackOutputsTest-1029112348','d48accfb-4bf1-4e41-9366-9bd13c556bf2','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(645,'6e32d75e-0156-423d-823b-563a99772e2f','7dcd0513-2b7b-4076-9abd-3e6390741252','2025-12-16 15:46:21',NULL,'UPDATE','COMPLETE','server','47969cde-8042-4912-9dc5-68baf6728ffb','state changed','OS::Nova::Server',NULL,108),(646,'0b285f84-bff0-464e-8c48-78d318b08aa6','d48accfb-4bf1-4e41-9366-9bd13c556bf2','2025-12-16 15:46:22',NULL,'DELETE','IN_PROGRESS','test_resource_b','StackOutputsTest-1029112348-test_resource_b-ykazmmamqpcy','state changed','OS::Heat::TestResource',NULL,107),(647,'e28cf505-98fd-4ddf-ac1e-ef7e452fde64','d48accfb-4bf1-4e41-9366-9bd13c556bf2','2025-12-16 15:46:22',NULL,'DELETE','COMPLETE','test_resource_b','StackOutputsTest-1029112348-test_resource_b-ykazmmamqpcy','state changed','OS::Heat::TestResource',NULL,107),(648,'bdacbe0b-cda9-4533-9b48-7db0ebb28644','7dcd0513-2b7b-4076-9abd-3e6390741252','2025-12-16 15:46:22',NULL,'UPDATE','COMPLETE','create_server_with_sub_ip','7dcd0513-2b7b-4076-9abd-3e6390741252','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(649,'610c9ae5-97cc-4be4-92cf-26ed0dcf24e4','d48accfb-4bf1-4e41-9366-9bd13c556bf2','2025-12-16 15:46:23',NULL,'DELETE','IN_PROGRESS','test_resource_a','StackOutputsTest-1029112348-test_resource_a-mgnauey5asaf','state changed','OS::Heat::TestResource',NULL,106),(650,'3b89df38-cbfd-4419-8a04-753e62e8469f','d48accfb-4bf1-4e41-9366-9bd13c556bf2','2025-12-16 15:46:23',NULL,'DELETE','COMPLETE','test_resource_a','StackOutputsTest-1029112348-test_resource_a-mgnauey5asaf','state changed','OS::Heat::TestResource',NULL,106),(651,'4f3ce805-acb4-4138-a6c8-25d87318e2ea','d48accfb-4bf1-4e41-9366-9bd13c556bf2','2025-12-16 15:46:23',NULL,'DELETE','COMPLETE','StackOutputsTest-1029112348','d48accfb-4bf1-4e41-9366-9bd13c556bf2','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(652,'02c22e75-a977-4fce-8d0e-ed6a49944e59','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:23',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-1611514538','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(653,'f1fb1dc1-64b3-4017-a3ca-35a782d34f3a','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:23',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-1611514538-trunk_net_one-ollepteod77g','state changed','OS::Neutron::Net',NULL,NULL),(654,'380d4519-4187-4a09-ab57-88424831b1cb','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:24',NULL,'CREATE','COMPLETE','trunk_net_one','912786b5-4d96-4604-9200-4054360eefcd','state changed','OS::Neutron::Net',NULL,NULL),(655,'5919b4af-352a-405c-ac31-1e6ebd5341bb','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:24',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-1611514538-trunk_subnet_one-s5jkforefuds','state changed','OS::Neutron::Subnet',NULL,110),(656,'2003c7ef-bccb-457d-b424-521ba3d0ef35','7dcd0513-2b7b-4076-9abd-3e6390741252','2025-12-16 15:46:24',NULL,'DELETE','IN_PROGRESS','create_server_with_sub_ip','7dcd0513-2b7b-4076-9abd-3e6390741252','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(657,'bcc237b0-a8a8-4d26-825c-a530a424b44c','7dcd0513-2b7b-4076-9abd-3e6390741252','2025-12-16 15:46:24',NULL,'DELETE','IN_PROGRESS','server','47969cde-8042-4912-9dc5-68baf6728ffb','state changed','OS::Nova::Server',NULL,108),(658,'b6053e69-0799-46f9-bdbf-11ab7180316b','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:24',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-1611514538-parent_net-x4koununedtk','state changed','OS::Neutron::Net',NULL,NULL),(659,'505d0c93-f9d1-4586-92ad-ceac1f9e43b3','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:25',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-1611514538-trunk_net_two-sorc27rnl2ab','state changed','OS::Neutron::Net',NULL,NULL),(660,'9248d2c9-3fb6-4e2c-811f-8bdb0e0de487','dbf8d2a1-37c1-4e86-ac7f-0d103ac50c64','2025-12-16 15:46:25',NULL,'DELETE','IN_PROGRESS','HooksTest-1903585384','dbf8d2a1-37c1-4e86-ac7f-0d103ac50c64','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(661,'b828e8b7-ab77-4cd2-9a0b-1c87ba95d911','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:25',NULL,'CREATE','COMPLETE','parent_net','fcad9b20-c585-458b-9fc4-c4ff6a2c62dc','state changed','OS::Neutron::Net',NULL,NULL),(662,'7e85f65c-ca95-45ed-bfce-f7940b945f0b','dbf8d2a1-37c1-4e86-ac7f-0d103ac50c64','2025-12-16 15:46:25',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-1903585384-foo_step3-ikpttgb4qu7l','state changed','OS::Heat::RandomString',NULL,NULL),(663,'3cf7923e-9d73-4953-b0b8-ffefcdf54d96','dbf8d2a1-37c1-4e86-ac7f-0d103ac50c64','2025-12-16 15:46:25',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-1903585384-foo_step3-ikpttgb4qu7l','state changed','OS::Heat::RandomString',NULL,NULL),(664,'4b26eb45-cf4d-4d4d-b31a-7ef08c51ecb8','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:25',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-1611514538-parent_subnet-nipjwsotrpmp','state changed','OS::Neutron::Subnet',NULL,111),(665,'9d3cc6f4-7351-4635-9116-8f89a93457db','dbf8d2a1-37c1-4e86-ac7f-0d103ac50c64','2025-12-16 15:46:25',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-1903585384-foo_step2-m26uk5ke2kna','state changed','OS::Heat::RandomString',NULL,NULL),(666,'c745d174-1276-455b-9406-ff188bfdb6c9','dbf8d2a1-37c1-4e86-ac7f-0d103ac50c64','2025-12-16 15:46:25',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-1903585384-foo_step2-m26uk5ke2kna','state changed','OS::Heat::RandomString',NULL,NULL),(667,'808488ee-84b8-4aa5-9519-3bf5df80f8b1','dbf8d2a1-37c1-4e86-ac7f-0d103ac50c64','2025-12-16 15:46:25',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-1903585384-foo_step1-vomhrq5ni2cw','state changed','OS::Heat::RandomString',NULL,NULL),(668,'0bb8a7c2-0d5d-4a80-8bbf-3a5621c13f56','dbf8d2a1-37c1-4e86-ac7f-0d103ac50c64','2025-12-16 15:46:25',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-1903585384-foo_step1-vomhrq5ni2cw','state changed','OS::Heat::RandomString',NULL,NULL),(669,'142b11de-38a2-46a8-bd41-5c44d1db566d','dbf8d2a1-37c1-4e86-ac7f-0d103ac50c64','2025-12-16 15:46:25',NULL,'DELETE','COMPLETE','HooksTest-1903585384','dbf8d2a1-37c1-4e86-ac7f-0d103ac50c64','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(670,'c51e7e83-c2c4-4bdf-ab7d-fb19b61251cb','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:25',NULL,'CREATE','COMPLETE','trunk_subnet_one','0f789e58-c8c5-4143-9563-ab6f2025b94d','state changed','OS::Neutron::Subnet',NULL,110),(671,'1119adb9-3068-48a3-a73c-844035330f43','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:25',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-1611514538-sub_port_one-tt3v5z27iuyh','state changed','OS::Neutron::Port',NULL,112),(672,'968207ad-45df-492c-984a-54deb9232c4a','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:26',NULL,'CREATE','COMPLETE','trunk_net_two','4092e016-5bd4-4d05-9e43-9adeafacfa5d','state changed','OS::Neutron::Net',NULL,NULL),(673,'90eb29b4-a07f-4bf0-9227-9592acb64ce0','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:26',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-1611514538-trunk_subnet_two-zhwkmwtmcl37','state changed','OS::Neutron::Subnet',NULL,113),(674,'25e53ca5-d5b4-4d60-93b1-e4855c265899','7dcd0513-2b7b-4076-9abd-3e6390741252','2025-12-16 15:46:26',NULL,'DELETE','COMPLETE','server','47969cde-8042-4912-9dc5-68baf6728ffb','state changed','OS::Nova::Server',NULL,108),(675,'23f8c5e6-d7a8-402d-99d5-60277834a124','7dcd0513-2b7b-4076-9abd-3e6390741252','2025-12-16 15:46:26',NULL,'DELETE','IN_PROGRESS','subnet_b','e674ccc0-7d4c-46f1-99f4-73e87c7f3440','state changed','OS::Neutron::Subnet',NULL,86),(676,'2ce49d72-6a01-4a4c-9746-9f3cfbca0ab0','7dcd0513-2b7b-4076-9abd-3e6390741252','2025-12-16 15:46:26',NULL,'DELETE','IN_PROGRESS','subnet_a','f6b995f7-acc8-421f-af3c-8ff5fdd1f7d9','state changed','OS::Neutron::Subnet',NULL,85),(677,'25a11ad2-3b69-476e-8ab4-4da0cb8061e4','7dcd0513-2b7b-4076-9abd-3e6390741252','2025-12-16 15:46:26',NULL,'DELETE','COMPLETE','subnet_b','e674ccc0-7d4c-46f1-99f4-73e87c7f3440','state changed','OS::Neutron::Subnet',NULL,86),(678,'97bac1be-dd64-46fb-81d7-ca6b8fc6b1b8','7dcd0513-2b7b-4076-9abd-3e6390741252','2025-12-16 15:46:27',NULL,'DELETE','COMPLETE','subnet_a','f6b995f7-acc8-421f-af3c-8ff5fdd1f7d9','state changed','OS::Neutron::Subnet',NULL,85),(679,'0971b604-90a6-4704-ae34-1e9b17b04c5f','7dcd0513-2b7b-4076-9abd-3e6390741252','2025-12-16 15:46:27',NULL,'DELETE','IN_PROGRESS','net','4768f982-89e1-4200-835b-e7d7b8dfc57d','state changed','OS::Neutron::Net',NULL,83),(680,'a6299db1-c242-468e-93f6-7ee6277d59e8','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:27',NULL,'CREATE','COMPLETE','sub_port_one','902f344c-b299-4b46-b8bf-adb92a77a93a','state changed','OS::Neutron::Port',NULL,112),(681,'efada906-0bd4-47d2-ab95-e5b4c47a41e2','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:27',NULL,'CREATE','COMPLETE','parent_subnet','380a7ad2-fc95-4855-a436-07916dfe0bfd','state changed','OS::Neutron::Subnet',NULL,111),(682,'5aa141a4-1861-4e7a-a46e-46a39ce406ca','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:27',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-1611514538-parent_port-fatnzfieqiag','state changed','OS::Neutron::Port',NULL,114),(683,'608de242-04f3-4732-9544-8113bd666ec6','d02d8ef5-e863-4f6c-963c-b88750d600d9','2025-12-16 15:46:27',NULL,'CREATE','IN_PROGRESS','StackOutputsTest-1999888672','d02d8ef5-e863-4f6c-963c-b88750d600d9','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(684,'17dcdb2c-f954-44be-8b1d-dde9aef86e88','d02d8ef5-e863-4f6c-963c-b88750d600d9','2025-12-16 15:46:27',NULL,'CREATE','IN_PROGRESS','test_resource_a','StackOutputsTest-1999888672-test_resource_a-jn2lkkl4t4zd','state changed','OS::Heat::TestResource',NULL,115),(685,'46beb097-5854-496e-bb9e-80f7d373b23d','d02d8ef5-e863-4f6c-963c-b88750d600d9','2025-12-16 15:46:27',NULL,'CREATE','COMPLETE','test_resource_a','StackOutputsTest-1999888672-test_resource_a-jn2lkkl4t4zd','state changed','OS::Heat::TestResource',NULL,115),(686,'93b52bd2-cd8f-44a7-abe3-ed4f7a3376a3','d02d8ef5-e863-4f6c-963c-b88750d600d9','2025-12-16 15:46:27',NULL,'CREATE','COMPLETE','StackOutputsTest-1999888672','d02d8ef5-e863-4f6c-963c-b88750d600d9','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(687,'f8eaf3ea-f28a-4952-a50b-c89eb472e98b','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:27',NULL,'CREATE','COMPLETE','trunk_subnet_two','26ffcdb6-6747-4eec-b350-39e6e15b2344','state changed','OS::Neutron::Subnet',NULL,113),(688,'d1cf0669-54ce-44a2-8c1d-4b6249b37c0c','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:27',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-1611514538-sub_port_two-z57ifbix7sxi','state changed','OS::Neutron::Port',NULL,116),(689,'b7da5865-07fe-448c-afba-d39c0b2b9f96','7dcd0513-2b7b-4076-9abd-3e6390741252','2025-12-16 15:46:27',NULL,'DELETE','COMPLETE','net','4768f982-89e1-4200-835b-e7d7b8dfc57d','state changed','OS::Neutron::Net',NULL,83),(690,'8ed1f1c5-81a1-43ed-889d-10bec14a2548','7dcd0513-2b7b-4076-9abd-3e6390741252','2025-12-16 15:46:27',NULL,'DELETE','COMPLETE','create_server_with_sub_ip','7dcd0513-2b7b-4076-9abd-3e6390741252','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(691,'8f75e31d-6d59-4fbf-8b87-99e8797a4126','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:28',NULL,'CREATE','COMPLETE','parent_port','d1514cc2-c0f7-4d13-8c0f-08db7d96cac1','state changed','OS::Neutron::Port',NULL,114),(692,'94ea92cd-7239-4de4-b828-10bf26b3f4ad','d02d8ef5-e863-4f6c-963c-b88750d600d9','2025-12-16 15:46:28',NULL,'UPDATE','IN_PROGRESS','StackOutputsTest-1999888672','d02d8ef5-e863-4f6c-963c-b88750d600d9','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(693,'05da6c84-c765-4e3c-8e2d-0d184b462b06','d02d8ef5-e863-4f6c-963c-b88750d600d9','2025-12-16 15:46:28',NULL,'CREATE','IN_PROGRESS','test_resource_b','StackOutputsTest-1999888672-test_resource_b-t5vtmqwmlgty','state changed','OS::Heat::TestResource',NULL,117),(694,'5fe3d8ef-cd9b-4041-8056-537f02e0b5ce','d02d8ef5-e863-4f6c-963c-b88750d600d9','2025-12-16 15:46:28',NULL,'CREATE','COMPLETE','test_resource_b','StackOutputsTest-1999888672-test_resource_b-t5vtmqwmlgty','state changed','OS::Heat::TestResource',NULL,117),(695,'94a55801-3c57-4933-bb3a-1bc6161c3a14','d02d8ef5-e863-4f6c-963c-b88750d600d9','2025-12-16 15:46:28',NULL,'UPDATE','COMPLETE','StackOutputsTest-1999888672','d02d8ef5-e863-4f6c-963c-b88750d600d9','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(696,'3f4f420a-dc26-4ec7-9fb6-f56901619986','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:28',NULL,'CREATE','COMPLETE','sub_port_two','c4df6435-8872-47d2-a7e5-556badfc04d7','state changed','OS::Neutron::Port',NULL,116),(697,'968706e2-6afc-47b0-89e2-063ce62a0ff1','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:28',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-1611514538-trunk-442flkoijaus','state changed','OS::Neutron::Trunk',NULL,118),(698,'dbbdf4e0-e578-4ce0-a8c1-126406579bec','02a74aa1-045e-4e27-8526-21195d65f316','2025-12-16 15:46:29',NULL,'CREATE','IN_PROGRESS','ResourcesList-1396389386','02a74aa1-045e-4e27-8526-21195d65f316','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(699,'9103f980-2467-4e49-8577-af54cd2ec800','02a74aa1-045e-4e27-8526-21195d65f316','2025-12-16 15:46:30',NULL,'CREATE','IN_PROGRESS','test1','ResourcesList-1396389386-test1-z5mmocu4mcoy','state changed','OS::Heat::TestResource',NULL,119),(700,'9418ecc9-4cad-4027-8756-d1ca9e27fa17','02a74aa1-045e-4e27-8526-21195d65f316','2025-12-16 15:46:30',NULL,'CREATE','COMPLETE','test1','ResourcesList-1396389386-test1-z5mmocu4mcoy','state changed','OS::Heat::TestResource',NULL,119),(701,'642942c1-96c4-4940-be2d-5cc4f9ccb6db','02a74aa1-045e-4e27-8526-21195d65f316','2025-12-16 15:46:30',NULL,'CREATE','IN_PROGRESS','test2','ResourcesList-1396389386-test2-3gmevbvkpu5k','state changed','OS::Heat::TestResource',NULL,120),(702,'84b2f084-213d-4722-a485-def9f9f267b1','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:30',NULL,'CREATE','COMPLETE','trunk','25f282cf-4d87-4134-b6dd-66cf663491d9','state changed','OS::Neutron::Trunk',NULL,118),(703,'e067b932-2968-4fd9-8ed6-62a65e38511c','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:30',NULL,'CREATE','COMPLETE','UpdateTrunkTest-1611514538','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(704,'e2609c1c-e247-4267-91ad-28d46fb2c313','02a74aa1-045e-4e27-8526-21195d65f316','2025-12-16 15:46:30',NULL,'CREATE','COMPLETE','test2','ResourcesList-1396389386-test2-3gmevbvkpu5k','state changed','OS::Heat::TestResource',NULL,120),(705,'a8f9621c-fab6-4dc8-b5ed-08e074cc59d0','02a74aa1-045e-4e27-8526-21195d65f316','2025-12-16 15:46:30',NULL,'CREATE','COMPLETE','ResourcesList-1396389386','02a74aa1-045e-4e27-8526-21195d65f316','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(706,'70c9cb67-32a2-4912-8874-078bbebb92f0','02a74aa1-045e-4e27-8526-21195d65f316','2025-12-16 15:46:30',NULL,'DELETE','IN_PROGRESS','ResourcesList-1396389386','02a74aa1-045e-4e27-8526-21195d65f316','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(707,'9cc69cf2-5626-4e5f-afa1-f6c8d93ea50c','02a74aa1-045e-4e27-8526-21195d65f316','2025-12-16 15:46:30',NULL,'DELETE','IN_PROGRESS','test2','ResourcesList-1396389386-test2-3gmevbvkpu5k','state changed','OS::Heat::TestResource',NULL,120),(708,'39c8e453-682d-4ceb-9e1d-910db18dd5ae','02a74aa1-045e-4e27-8526-21195d65f316','2025-12-16 15:46:30',NULL,'DELETE','COMPLETE','test2','ResourcesList-1396389386-test2-3gmevbvkpu5k','state changed','OS::Heat::TestResource',NULL,120),(709,'80b330a4-9645-4ebf-afba-6d4fa335e58a','02a74aa1-045e-4e27-8526-21195d65f316','2025-12-16 15:46:30',NULL,'DELETE','IN_PROGRESS','test1','ResourcesList-1396389386-test1-z5mmocu4mcoy','state changed','OS::Heat::TestResource',NULL,119),(710,'6106a583-cab5-4312-aea9-af905716602d','02a74aa1-045e-4e27-8526-21195d65f316','2025-12-16 15:46:30',NULL,'DELETE','COMPLETE','test1','ResourcesList-1396389386-test1-z5mmocu4mcoy','state changed','OS::Heat::TestResource',NULL,119),(711,'35302e95-bb92-4741-937b-87807227f6d7','02a74aa1-045e-4e27-8526-21195d65f316','2025-12-16 15:46:30',NULL,'DELETE','COMPLETE','ResourcesList-1396389386','02a74aa1-045e-4e27-8526-21195d65f316','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(712,'0169dfb8-4bf6-47f5-904f-820020df7679','162c02b0-a7c7-42d6-89be-d713006a54b6','2025-12-16 15:46:31',NULL,'CREATE','IN_PROGRESS','HooksTest-1655336191','162c02b0-a7c7-42d6-89be-d713006a54b6','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(713,'894de630-c0d7-4eb2-8566-0c11fb999b6e','162c02b0-a7c7-42d6-89be-d713006a54b6','2025-12-16 15:46:31',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-1655336191-foo_step1-f2petsjzj5dw','state changed','OS::Heat::RandomString',NULL,NULL),(714,'a2690e20-f67e-4e47-96ea-aeb9ee37010b','162c02b0-a7c7-42d6-89be-d713006a54b6','2025-12-16 15:46:31',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-1655336191-foo_step1-f2petsjzj5dw','state changed','OS::Heat::RandomString',NULL,NULL),(715,'e83091b2-db9e-45c3-8f03-56194bde248e','162c02b0-a7c7-42d6-89be-d713006a54b6','2025-12-16 15:46:31',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-1655336191-foo_step2-nn5bgf7ymfye','state changed','OS::Heat::RandomString',NULL,NULL),(716,'29ea82a4-5e39-4d78-b4f6-bf9a06c7afd0','162c02b0-a7c7-42d6-89be-d713006a54b6','2025-12-16 15:46:31',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1655336191-foo_step2-nn5bgf7ymfye','state changed','OS::Heat::RandomString',NULL,NULL),(717,'82175921-e71f-464d-9c96-987ee36b5990','162c02b0-a7c7-42d6-89be-d713006a54b6','2025-12-16 15:46:31',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-1655336191-foo_step3-znyvi2ohichg','state changed','OS::Heat::RandomString',NULL,NULL),(718,'48f185c2-854d-441e-ba1c-d9986cb976e8','162c02b0-a7c7-42d6-89be-d713006a54b6','2025-12-16 15:46:31',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-1655336191-foo_step3-znyvi2ohichg','state changed','OS::Heat::RandomString',NULL,NULL),(719,'ec4a3b1a-f333-462a-9052-f4c7f2d95714','162c02b0-a7c7-42d6-89be-d713006a54b6','2025-12-16 15:46:31',NULL,'CREATE','COMPLETE','HooksTest-1655336191','162c02b0-a7c7-42d6-89be-d713006a54b6','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(720,'50cd4c7b-74de-48a2-82b6-9368f7984a78','162c02b0-a7c7-42d6-89be-d713006a54b6','2025-12-16 15:46:32',NULL,'UPDATE','IN_PROGRESS','HooksTest-1655336191','162c02b0-a7c7-42d6-89be-d713006a54b6','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(721,'bc10a384-f634-4ec2-bf97-aaa55291c610','162c02b0-a7c7-42d6-89be-d713006a54b6','2025-12-16 15:46:32',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1655336191-foo_step2-nn5bgf7ymfye','UPDATE paused until Hook pre-update is cleared','OS::Heat::RandomString',NULL,NULL),(722,'1af3dfea-fb00-453c-a554-daba16fb2b68','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:32',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-1611514538','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(723,'bc6afff0-f707-43a5-9e91-a5962ca781dd','162c02b0-a7c7-42d6-89be-d713006a54b6','2025-12-16 15:46:33',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1655336191-foo_step2-nn5bgf7ymfye','Hook pre-update is cleared','OS::Heat::RandomString',NULL,NULL),(724,'78ce2136-e818-4d75-85f7-0db5f259e0f0','162c02b0-a7c7-42d6-89be-d713006a54b6','2025-12-16 15:46:33',NULL,'UPDATE','IN_PROGRESS','foo_step2','HooksTest-1655336191-foo_step2-nn5bgf7ymfye','state changed','OS::Heat::RandomString',NULL,NULL),(725,'cff71067-83b7-4546-81b0-5b372c49f763','d02d8ef5-e863-4f6c-963c-b88750d600d9','2025-12-16 15:46:33',NULL,'DELETE','IN_PROGRESS','StackOutputsTest-1999888672','d02d8ef5-e863-4f6c-963c-b88750d600d9','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(726,'05c1e0ac-4f84-46ec-8a76-43f6783125d3','162c02b0-a7c7-42d6-89be-d713006a54b6','2025-12-16 15:46:33',NULL,'UPDATE','COMPLETE','foo_step2','HooksTest-1655336191-foo_step2-nn5bgf7ymfye','The Resource foo_step2 requires replacement.','OS::Heat::RandomString',NULL,NULL),(727,'60c06cf5-f012-46f3-a7a7-e9548fcd3718','162c02b0-a7c7-42d6-89be-d713006a54b6','2025-12-16 15:46:34',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-1655336191-foo_step2-zfnjqkum3hgk','state changed','OS::Heat::RandomString',NULL,121),(728,'a7fb7beb-d6ee-4541-b949-ca7ded174bb6','d02d8ef5-e863-4f6c-963c-b88750d600d9','2025-12-16 15:46:34',NULL,'DELETE','IN_PROGRESS','test_resource_b','StackOutputsTest-1999888672-test_resource_b-t5vtmqwmlgty','state changed','OS::Heat::TestResource',NULL,117),(729,'507e2b59-3192-4b4b-a88f-c43853c2bfaf','162c02b0-a7c7-42d6-89be-d713006a54b6','2025-12-16 15:46:34',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1655336191-foo_step2-zfnjqkum3hgk','state changed','OS::Heat::RandomString',NULL,121),(730,'6581f5f3-346c-48ab-9262-651260f71576','d02d8ef5-e863-4f6c-963c-b88750d600d9','2025-12-16 15:46:34',NULL,'DELETE','COMPLETE','test_resource_b','StackOutputsTest-1999888672-test_resource_b-t5vtmqwmlgty','state changed','OS::Heat::TestResource',NULL,117),(731,'0ac8da0b-57cf-4b1c-a2e9-9331865900d8','d02d8ef5-e863-4f6c-963c-b88750d600d9','2025-12-16 15:46:34',NULL,'DELETE','IN_PROGRESS','test_resource_a','StackOutputsTest-1999888672-test_resource_a-jn2lkkl4t4zd','state changed','OS::Heat::TestResource',NULL,115),(732,'cc419c63-cb13-4461-a883-80b83cb18e6d','d02d8ef5-e863-4f6c-963c-b88750d600d9','2025-12-16 15:46:34',NULL,'DELETE','COMPLETE','test_resource_a','StackOutputsTest-1999888672-test_resource_a-jn2lkkl4t4zd','state changed','OS::Heat::TestResource',NULL,115),(733,'08fedee2-b3b9-474b-a846-ccb72a4402d9','d02d8ef5-e863-4f6c-963c-b88750d600d9','2025-12-16 15:46:34',NULL,'DELETE','COMPLETE','StackOutputsTest-1999888672','d02d8ef5-e863-4f6c-963c-b88750d600d9','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(734,'7283bb73-4d1d-46a4-ae55-050c66ceb00f','162c02b0-a7c7-42d6-89be-d713006a54b6','2025-12-16 15:46:34',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-1655336191-foo_step2-nn5bgf7ymfye','state changed','OS::Heat::RandomString',NULL,NULL),(735,'7ad9791a-19ec-46fc-b3e7-d7d9982a9dcc','162c02b0-a7c7-42d6-89be-d713006a54b6','2025-12-16 15:46:34',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-1655336191-foo_step2-nn5bgf7ymfye','state changed','OS::Heat::RandomString',NULL,NULL),(736,'7ef3378c-5418-424e-8c82-d706d3d24853','162c02b0-a7c7-42d6-89be-d713006a54b6','2025-12-16 15:46:34',NULL,'UPDATE','COMPLETE','HooksTest-1655336191','162c02b0-a7c7-42d6-89be-d713006a54b6','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(737,'c522aab6-cca0-4257-97a3-1b2ed10c6588','dd76fd8d-e13e-4217-aa12-aa85cd0c1544','2025-12-16 15:46:36',NULL,'CREATE','IN_PROGRESS','ResourcesList-78929858','dd76fd8d-e13e-4217-aa12-aa85cd0c1544','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(738,'3e6badff-ab81-4d03-a30d-1e23df8ba5f3','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:36',NULL,'UPDATE','IN_PROGRESS','trunk','25f282cf-4d87-4134-b6dd-66cf663491d9','state changed','OS::Neutron::Trunk',NULL,118),(739,'c39c190c-d8c2-4f5f-8b85-e1d033c81449','dd76fd8d-e13e-4217-aa12-aa85cd0c1544','2025-12-16 15:46:36',NULL,'CREATE','IN_PROGRESS','test1','ResourcesList-78929858-test1-xqyxvwlpgixa','state changed','OS::Heat::TestResource',NULL,122),(740,'162a41d1-a87f-4a9a-bacb-fcd8d6f37ada','dd76fd8d-e13e-4217-aa12-aa85cd0c1544','2025-12-16 15:46:36',NULL,'CREATE','COMPLETE','test1','ResourcesList-78929858-test1-xqyxvwlpgixa','state changed','OS::Heat::TestResource',NULL,122),(741,'f2e68de6-630e-450b-a1c6-2bcd97da57cb','dd76fd8d-e13e-4217-aa12-aa85cd0c1544','2025-12-16 15:46:36',NULL,'CREATE','IN_PROGRESS','test2','ResourcesList-78929858-test2-xwli7sf7aalt','state changed','OS::Heat::TestResource',NULL,123),(742,'ebf1cecb-d9dd-4027-86a6-fab501e76ea2','dd76fd8d-e13e-4217-aa12-aa85cd0c1544','2025-12-16 15:46:36',NULL,'CREATE','COMPLETE','test2','ResourcesList-78929858-test2-xwli7sf7aalt','state changed','OS::Heat::TestResource',NULL,123),(743,'67c8534d-5d1d-4b97-8095-7e987de45ce5','dd76fd8d-e13e-4217-aa12-aa85cd0c1544','2025-12-16 15:46:36',NULL,'CREATE','COMPLETE','ResourcesList-78929858','dd76fd8d-e13e-4217-aa12-aa85cd0c1544','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(744,'c96712ef-2f94-4a68-a4a0-e9dc290028ba','dd76fd8d-e13e-4217-aa12-aa85cd0c1544','2025-12-16 15:46:38',NULL,'DELETE','IN_PROGRESS','ResourcesList-78929858','dd76fd8d-e13e-4217-aa12-aa85cd0c1544','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(745,'6f3f3a48-a152-4e84-9839-8b8cade82178','dd76fd8d-e13e-4217-aa12-aa85cd0c1544','2025-12-16 15:46:38',NULL,'DELETE','IN_PROGRESS','test2','ResourcesList-78929858-test2-xwli7sf7aalt','state changed','OS::Heat::TestResource',NULL,123),(746,'8be9f7c2-98b8-460c-97c0-fbfa336e22e7','dd76fd8d-e13e-4217-aa12-aa85cd0c1544','2025-12-16 15:46:38',NULL,'DELETE','COMPLETE','test2','ResourcesList-78929858-test2-xwli7sf7aalt','state changed','OS::Heat::TestResource',NULL,123),(747,'b8beafef-bd24-4289-9196-9096d9a30da0','dd76fd8d-e13e-4217-aa12-aa85cd0c1544','2025-12-16 15:46:38',NULL,'DELETE','IN_PROGRESS','test1','ResourcesList-78929858-test1-xqyxvwlpgixa','state changed','OS::Heat::TestResource',NULL,122),(748,'5c13ccb8-33d2-4108-98ec-e64838a84411','dd76fd8d-e13e-4217-aa12-aa85cd0c1544','2025-12-16 15:46:39',NULL,'DELETE','COMPLETE','test1','ResourcesList-78929858-test1-xqyxvwlpgixa','state changed','OS::Heat::TestResource',NULL,122),(749,'225bca4c-4c29-4034-9af5-10b4e2f47d48','dd76fd8d-e13e-4217-aa12-aa85cd0c1544','2025-12-16 15:46:39',NULL,'DELETE','COMPLETE','ResourcesList-78929858','dd76fd8d-e13e-4217-aa12-aa85cd0c1544','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(750,'04f89680-c5a7-4aa1-baf1-dd26374ba9aa','162c02b0-a7c7-42d6-89be-d713006a54b6','2025-12-16 15:46:39',NULL,'DELETE','IN_PROGRESS','HooksTest-1655336191','162c02b0-a7c7-42d6-89be-d713006a54b6','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(751,'81fcd606-5826-47a6-b732-1208e0a514df','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:39',NULL,'UPDATE','COMPLETE','trunk','25f282cf-4d87-4134-b6dd-66cf663491d9','state changed','OS::Neutron::Trunk',NULL,124),(752,'910b5093-b393-429e-a92e-b491741f90e8','162c02b0-a7c7-42d6-89be-d713006a54b6','2025-12-16 15:46:39',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-1655336191-foo_step2-zfnjqkum3hgk','state changed','OS::Heat::RandomString',NULL,121),(753,'08dddb05-f85e-4f5c-a0d8-e161343ac69c','162c02b0-a7c7-42d6-89be-d713006a54b6','2025-12-16 15:46:39',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-1655336191-foo_step2-zfnjqkum3hgk','state changed','OS::Heat::RandomString',NULL,121),(754,'6004825a-1c7c-4384-8e85-a54437b9a2dd','162c02b0-a7c7-42d6-89be-d713006a54b6','2025-12-16 15:46:39',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-1655336191-foo_step1-f2petsjzj5dw','state changed','OS::Heat::RandomString',NULL,NULL),(755,'fb23b449-d108-4013-a6c5-8de2c9670a9e','162c02b0-a7c7-42d6-89be-d713006a54b6','2025-12-16 15:46:39',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-1655336191-foo_step1-f2petsjzj5dw','state changed','OS::Heat::RandomString',NULL,NULL),(756,'9679b53f-ac29-470c-9899-9f4ed6f05406','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:39',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-1611514538','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(757,'eec9b8a0-0d55-4641-929c-07d0dc351239','162c02b0-a7c7-42d6-89be-d713006a54b6','2025-12-16 15:46:40',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-1655336191-foo_step3-znyvi2ohichg','state changed','OS::Heat::RandomString',NULL,NULL),(758,'36e7de5f-1994-4e35-900f-0b942c25743c','162c02b0-a7c7-42d6-89be-d713006a54b6','2025-12-16 15:46:40',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-1655336191-foo_step3-znyvi2ohichg','state changed','OS::Heat::RandomString',NULL,NULL),(759,'d308aada-85bd-4567-8e0d-51c3c3bc38c9','162c02b0-a7c7-42d6-89be-d713006a54b6','2025-12-16 15:46:40',NULL,'DELETE','COMPLETE','HooksTest-1655336191','162c02b0-a7c7-42d6-89be-d713006a54b6','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(760,'667beaa7-5632-4042-a242-e092e53fa1cb','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:42',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-1611514538','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(761,'643ce3f0-b850-4655-a713-08934a58d225','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:43',NULL,'DELETE','IN_PROGRESS','sub_port_two','c4df6435-8872-47d2-a7e5-556badfc04d7','state changed','OS::Neutron::Port',NULL,116),(762,'3f5aed54-4e7b-472c-846a-8934267bab6f','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:44',NULL,'DELETE','COMPLETE','sub_port_two','c4df6435-8872-47d2-a7e5-556badfc04d7','state changed','OS::Neutron::Port',NULL,116),(763,'5a8279ba-e99a-4105-8f8e-467d14ae7e49','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:44',NULL,'DELETE','IN_PROGRESS','trunk','25f282cf-4d87-4134-b6dd-66cf663491d9','state changed','OS::Neutron::Trunk',NULL,124),(764,'58a75a5a-dd23-4f94-95ef-6e849f8454ca','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:44',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','26ffcdb6-6747-4eec-b350-39e6e15b2344','state changed','OS::Neutron::Subnet',NULL,113),(765,'65aaf605-faed-4f47-8d32-8874f48f2e92','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:44',NULL,'DELETE','COMPLETE','trunk','25f282cf-4d87-4134-b6dd-66cf663491d9','state changed','OS::Neutron::Trunk',NULL,124),(766,'1cc4fc93-3f26-4883-950f-2d5eb6446ad8','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:44',NULL,'DELETE','IN_PROGRESS','sub_port_one','902f344c-b299-4b46-b8bf-adb92a77a93a','state changed','OS::Neutron::Port',NULL,112),(767,'ec5cffff-7cac-4ca9-bb53-005dfa24ce3e','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:44',NULL,'DELETE','COMPLETE','trunk_subnet_two','26ffcdb6-6747-4eec-b350-39e6e15b2344','state changed','OS::Neutron::Subnet',NULL,113),(768,'9ce49ee9-7ec6-439b-ae35-3236f81fa757','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:44',NULL,'DELETE','IN_PROGRESS','parent_port','d1514cc2-c0f7-4d13-8c0f-08db7d96cac1','state changed','OS::Neutron::Port',NULL,114),(769,'d7ff8550-7eae-4859-831e-a5f9d58d5ac2','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:44',NULL,'DELETE','IN_PROGRESS','trunk_net_two','4092e016-5bd4-4d05-9e43-9adeafacfa5d','state changed','OS::Neutron::Net',NULL,NULL),(770,'1b5e47a3-1180-4129-9033-315ba25516cf','84e8374e-8283-4692-ae62-2a35a9ce21a2','2025-12-16 15:46:45',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-2020059004','84e8374e-8283-4692-ae62-2a35a9ce21a2','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(771,'4f041be2-6f5e-4762-8f45-cbf3e189e1ef','84e8374e-8283-4692-ae62-2a35a9ce21a2','2025-12-16 15:46:45',NULL,'CREATE','IN_PROGRESS','server','Pa-llelDeploymentsTest-2020059004-server-h34jhfy5yu2d','state changed','OS::Nova::Server',NULL,126),(772,'f23bef47-5bb1-4176-9054-ad503e333cbd','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:45',NULL,'DELETE','COMPLETE','trunk_net_two','4092e016-5bd4-4d05-9e43-9adeafacfa5d','state changed','OS::Neutron::Net',NULL,NULL),(773,'e95fc47c-4c0f-4c6d-bc3f-9412fb1c2c65','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:45',NULL,'DELETE','COMPLETE','sub_port_one','902f344c-b299-4b46-b8bf-adb92a77a93a','state changed','OS::Neutron::Port',NULL,112),(774,'7ba4c269-0269-43a9-877e-55c7a1fa4506','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:45',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','0f789e58-c8c5-4143-9563-ab6f2025b94d','state changed','OS::Neutron::Subnet',NULL,110),(775,'7640d5d9-a241-4fc8-a5c8-40ab81e85613','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:45',NULL,'DELETE','COMPLETE','parent_port','d1514cc2-c0f7-4d13-8c0f-08db7d96cac1','state changed','OS::Neutron::Port',NULL,114),(776,'2a4e0311-4422-46ec-a90b-c98d2c575e43','9ab7fb5a-2105-4706-b669-bcc095a42071','2025-12-16 15:46:45',NULL,'CREATE','IN_PROGRESS','add_network','9ab7fb5a-2105-4706-b669-bcc095a42071','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(777,'27cdf099-2653-489e-b30b-525e996a0560','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:45',NULL,'DELETE','IN_PROGRESS','parent_subnet','380a7ad2-fc95-4855-a436-07916dfe0bfd','state changed','OS::Neutron::Subnet',NULL,111),(778,'31730488-05b1-4c42-84cb-fa8bd93e4751','9ab7fb5a-2105-4706-b669-bcc095a42071','2025-12-16 15:46:45',NULL,'CREATE','IN_PROGRESS','net','add_network-net-4h2jqgwnsods','state changed','OS::Neutron::Net',NULL,127),(779,'2d97820d-229f-4e7e-96fa-23c7c886a584','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:45',NULL,'DELETE','COMPLETE','parent_subnet','380a7ad2-fc95-4855-a436-07916dfe0bfd','state changed','OS::Neutron::Subnet',NULL,111),(780,'ae03fe90-3039-4bd9-82cc-d15ab16998ec','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:45',NULL,'DELETE','IN_PROGRESS','parent_net','fcad9b20-c585-458b-9fc4-c4ff6a2c62dc','state changed','OS::Neutron::Net',NULL,NULL),(781,'cffdf404-536c-4359-849e-c2b237e5a414','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:46',NULL,'DELETE','COMPLETE','trunk_subnet_one','0f789e58-c8c5-4143-9563-ab6f2025b94d','state changed','OS::Neutron::Subnet',NULL,110),(782,'3ed93645-efed-4a0e-99b2-4eaf5fc5ceda','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:46',NULL,'DELETE','IN_PROGRESS','trunk_net_one','912786b5-4d96-4604-9200-4054360eefcd','state changed','OS::Neutron::Net',NULL,NULL),(783,'9ab878d0-a1c9-4957-97e2-53b7e4618f15','9ab7fb5a-2105-4706-b669-bcc095a42071','2025-12-16 15:46:46',NULL,'CREATE','COMPLETE','net','23494041-f651-4d38-bdd8-f795ef41c456','state changed','OS::Neutron::Net',NULL,127),(784,'314b9001-158b-4e9f-a57f-ebded2ce4b37','9ab7fb5a-2105-4706-b669-bcc095a42071','2025-12-16 15:46:46',NULL,'CREATE','IN_PROGRESS','subnet','add_network-subnet-icugj2tw5pux','state changed','OS::Neutron::Subnet',NULL,128),(785,'98ba24cc-54e7-4ada-ac9f-47e9e340c50f','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:46',NULL,'DELETE','COMPLETE','parent_net','fcad9b20-c585-458b-9fc4-c4ff6a2c62dc','state changed','OS::Neutron::Net',NULL,NULL),(786,'4beb3c12-55a8-4b1b-9a93-e06d8b2de59e','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:46',NULL,'DELETE','COMPLETE','trunk_net_one','912786b5-4d96-4604-9200-4054360eefcd','state changed','OS::Neutron::Net',NULL,NULL),(787,'c2324035-22b1-4c1d-8fc3-9b9e71a155d0','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:46',NULL,'DELETE','COMPLETE','UpdateTrunkTest-1611514538','4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(788,'7b6de2d3-0f1f-4a16-9a63-e4f9d63876f9','9ab7fb5a-2105-4706-b669-bcc095a42071','2025-12-16 15:46:48',NULL,'CREATE','COMPLETE','subnet','283b9a23-d171-469e-8baa-b374439a4388','state changed','OS::Neutron::Subnet',NULL,128),(789,'e4f0f345-e5df-4aa1-a77c-0b2a1a4d3a2c','9ab7fb5a-2105-4706-b669-bcc095a42071','2025-12-16 15:46:48',NULL,'CREATE','IN_PROGRESS','server','add_network-server-z7jrhpiyihda','state changed','OS::Nova::Server',NULL,129),(790,'220bf238-172f-4469-b754-7ed34265aef3','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:46:52',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-759910396','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(791,'3de2a3af-fcfa-4351-93c9-9fe1b060ac22','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:46:53',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-759910396-trunk_net_one-lqzxqc4ybk6c','state changed','OS::Neutron::Net',NULL,NULL),(792,'88c60bbd-13de-4665-9d10-977bbc33c7b0','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:46:54',NULL,'CREATE','COMPLETE','trunk_net_one','c3c765ed-09fc-431f-bfb4-1d5631f8909f','state changed','OS::Neutron::Net',NULL,NULL),(793,'57c5c8cd-1e4e-49d3-9f25-8ffbd831cd34','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:46:54',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-759910396-trunk_subnet_one-rtl6rga3sxun','state changed','OS::Neutron::Subnet',NULL,130),(794,'16c85b50-c4e0-4f7e-88cb-2d65b38b52e1','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:46:54',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-759910396-trunk_net_two-loiqsfzajitl','state changed','OS::Neutron::Net',NULL,NULL),(795,'3ced060f-3f6c-4364-bb2e-d2f953be8bfa','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:46:55',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-759910396-parent_net-tgoi6iqtuw3u','state changed','OS::Neutron::Net',NULL,NULL),(796,'8fc272fe-13a1-45b9-8ef3-1072c40b3ecb','84e8374e-8283-4692-ae62-2a35a9ce21a2','2025-12-16 15:46:55',NULL,'CREATE','COMPLETE','server','6ff592d2-64da-422f-be47-7488a1aa9068','state changed','OS::Nova::Server',NULL,126),(797,'80b854fa-4de0-48bb-8910-93d70fee9d70','84e8374e-8283-4692-ae62-2a35a9ce21a2','2025-12-16 15:46:55',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-2020059004','84e8374e-8283-4692-ae62-2a35a9ce21a2','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(798,'1f0237b0-28e2-4e03-8277-8c3d0b509a1f','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:46:55',NULL,'CREATE','COMPLETE','trunk_net_two','83861d7c-305e-4e04-bda8-c992e55ea6bc','state changed','OS::Neutron::Net',NULL,NULL),(799,'cfff425a-0462-4abb-92c4-0fd1d26ef58d','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:46:55',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-759910396-trunk_subnet_two-c6jaxdxjrfjt','state changed','OS::Neutron::Subnet',NULL,131),(800,'956fc199-36e9-4308-b0e2-61e96328b7c3','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:46:56',NULL,'CREATE','COMPLETE','parent_net','dc1985da-5cb3-40e2-93d3-5de234bbbd5f','state changed','OS::Neutron::Net',NULL,NULL),(801,'28ecec1d-b65d-436c-8e7e-040e19610752','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:46:56',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-759910396-parent_subnet-rbsk3acmwslq','state changed','OS::Neutron::Subnet',NULL,132),(802,'174f6916-4e2a-4a9c-bde6-eb819f5a67bd','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:46:56',NULL,'CREATE','COMPLETE','trunk_subnet_one','bc21b24a-8db8-4d03-bb64-6fe8c7cdab86','state changed','OS::Neutron::Subnet',NULL,130),(803,'74dd5d25-823f-4ed4-a213-9dc888a3a536','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:46:56',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-759910396-sub_port_one-2zueror2xsdu','state changed','OS::Neutron::Port',NULL,133),(804,'116c95c1-ad5a-4287-9c64-25d635e142da','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:46:56',NULL,'CREATE','COMPLETE','trunk_subnet_two','28caf69c-5f07-4316-b20b-8e93d8c30a96','state changed','OS::Neutron::Subnet',NULL,131),(805,'f3816660-a339-4ad3-98af-8802714f6b39','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:46:57',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-759910396-sub_port_two-gijj6i2p3glx','state changed','OS::Neutron::Port',NULL,134),(806,'28550c01-56ec-4a77-a4e5-6616750e24c5','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:46:57',NULL,'CREATE','COMPLETE','sub_port_two','c2315699-6280-4b7a-90e0-b503477da695','state changed','OS::Neutron::Port',NULL,134),(807,'c043440a-8585-4369-8028-559365780af7','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:46:57',NULL,'CREATE','COMPLETE','sub_port_one','04089cf6-3387-4902-916c-0f03749b91b8','state changed','OS::Neutron::Port',NULL,133),(808,'ad060e48-3769-4f1b-bee9-bcdcb13ed3ab','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:46:58',NULL,'CREATE','COMPLETE','parent_subnet','40ace754-0a81-47c8-a5c1-7f24cb439c95','state changed','OS::Neutron::Subnet',NULL,132),(809,'649e1b5f-2934-4e9a-a557-5491e2b3fda7','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:46:58',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-759910396-parent_port-tqjumkxlzkxw','state changed','OS::Neutron::Port',NULL,135),(810,'f2333c4b-648f-4fb0-bea6-92541c970a35','9ab7fb5a-2105-4706-b669-bcc095a42071','2025-12-16 15:46:58',NULL,'CREATE','COMPLETE','server','a75a815c-48d9-41eb-8004-b3012305e26a','state changed','OS::Nova::Server',NULL,129),(811,'1a723cf5-55d5-46d6-874c-0c05021da9a2','9ab7fb5a-2105-4706-b669-bcc095a42071','2025-12-16 15:46:58',NULL,'CREATE','COMPLETE','add_network','9ab7fb5a-2105-4706-b669-bcc095a42071','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(812,'7fc86649-af9a-42cd-bb33-4601e6bdde7f','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:46:58',NULL,'CREATE','COMPLETE','parent_port','0f592a27-5b60-4215-8729-c9c3594e0ce6','state changed','OS::Neutron::Port',NULL,135),(813,'4d04ccea-d796-4b52-8f05-f99462831a04','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:46:58',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-759910396-trunk-a6rvv5suwg4q','state changed','OS::Neutron::Trunk',NULL,136),(814,'83c9a7ac-56dd-4d78-bda7-b4e04048d4f1','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:46:59',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-615637284','476128fb-2e52-4d49-a4a7-c6e01d256343','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(815,'f77dfa0f-e523-4e1e-90b9-8051a6642f45','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:46:59',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-615637284-config-yf3vi2hxzklo','state changed','OS::Heat::SoftwareConfig',NULL,137),(816,'180312e3-4223-40b0-9142-4629e6b66eb0','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:46:59',NULL,'CREATE','COMPLETE','config','1ef18178-43af-4577-b255-a43922f9655b','state changed','OS::Heat::SoftwareConfig',NULL,137),(817,'abf9ea83-9051-4ec5-96c2-d92d7c9bb7f2','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:46:59',NULL,'CREATE','IN_PROGRESS','dep_4','ParallelDeploymentsTest-615637284-dep_4-ubaedu76zued','state changed','OS::Heat::SoftwareDeployments',NULL,138),(818,'544ea6ff-0f8a-49c6-9f43-f78a69794727','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:46:59',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-615637284-dep_2-523kyhjuun3y','state changed','OS::Heat::SoftwareDeployments',NULL,139),(819,'3adcba98-d4a6-46b2-b38a-df42f8087394','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:46:59',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-615637284-dep_1-dosh4mmsqtuw','state changed','OS::Heat::SoftwareDeployments',NULL,140),(820,'711d2ec6-0e5c-4a88-bf18-a4bb0c0d41ad','a0407c9d-9f4a-42f2-8907-8cb867120a66','2025-12-16 15:46:59',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-615637284-dep_4-ubaedu76zued','a0407c9d-9f4a-42f2-8907-8cb867120a66','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(821,'5b10ecca-d8bb-4b6d-b098-4b38b9cd7d9b','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:46:59',NULL,'CREATE','IN_PROGRESS','dep_3','ParallelDeploymentsTest-615637284-dep_3-2uy3tkfij6uf','state changed','OS::Heat::SoftwareDeployments',NULL,141),(822,'17cdeff4-2ee7-4563-9a92-19e45f1dc2e2','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:46:59',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-615637284-dep_0-bn6krfvthvel','state changed','OS::Heat::SoftwareDeployments',NULL,142),(823,'f1bf4e07-f836-47d2-93aa-9056cd409e0d','dce84e82-2761-493e-aed6-c2ceb3240413','2025-12-16 15:46:59',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-615637284-dep_2-523kyhjuun3y','dce84e82-2761-493e-aed6-c2ceb3240413','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(824,'18e21ede-034a-4e31-9ab2-d56825158c7e','ac1887a9-4f8c-4d57-82b2-146244a4d030','2025-12-16 15:46:59',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-615637284-dep_3-2uy3tkfij6uf','ac1887a9-4f8c-4d57-82b2-146244a4d030','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(825,'6bec2af0-7db9-44cb-9d87-4c2f8aa68fbb','91481ff0-416c-4925-9261-b5efdd2eb473','2025-12-16 15:46:59',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-615637284-dep_1-dosh4mmsqtuw','91481ff0-416c-4925-9261-b5efdd2eb473','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(826,'53c88deb-104a-4d04-99a4-062eaf8d7810','bccb90e9-49c9-467e-9118-68f3d8f2f773','2025-12-16 15:46:59',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-615637284-dep_0-bn6krfvthvel','bccb90e9-49c9-467e-9118-68f3d8f2f773','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(827,'fe939a2e-50e2-465a-b047-a92e869556ce','a0407c9d-9f4a-42f2-8907-8cb867120a66','2025-12-16 15:46:59',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-615637284-dep_4-ubaedu76zued-0-tchjhgxz64f2','state changed','OS::Heat::SoftwareDeployment',NULL,143),(828,'1f8bc4ba-031c-4e59-9be0-61d49d9335ae','dce84e82-2761-493e-aed6-c2ceb3240413','2025-12-16 15:46:59',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-615637284-dep_2-523kyhjuun3y-0-viawguee3phe','state changed','OS::Heat::SoftwareDeployment',NULL,144),(829,'1df7a06f-0248-47b1-bb09-d62210a44097','91481ff0-416c-4925-9261-b5efdd2eb473','2025-12-16 15:46:59',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-615637284-dep_1-dosh4mmsqtuw-0-demrzvd3dpqu','state changed','OS::Heat::SoftwareDeployment',NULL,145),(830,'6e868bff-a8d8-485f-9b9c-6ca17ad17658','ac1887a9-4f8c-4d57-82b2-146244a4d030','2025-12-16 15:46:59',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-615637284-dep_3-2uy3tkfij6uf-0-jirfrxllzpl2','state changed','OS::Heat::SoftwareDeployment',NULL,146),(831,'abe25fa6-7df5-48b3-9cf2-1ba2d8d31eac','bccb90e9-49c9-467e-9118-68f3d8f2f773','2025-12-16 15:46:59',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-615637284-dep_0-bn6krfvthvel-0-cklzpc2mtoav','state changed','OS::Heat::SoftwareDeployment',NULL,147),(832,'b930f66d-7461-4e5a-8bdb-aadba240be43','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:00',NULL,'CREATE','COMPLETE','trunk','bfe912a9-10be-41a4-86a7-68197a8de337','state changed','OS::Neutron::Trunk',NULL,136),(833,'32462014-b62a-41a2-b475-27f562e15514','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:00',NULL,'CREATE','COMPLETE','UpdateTrunkTest-759910396','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(834,'ee8aad0e-d580-45e7-8561-0e1bf66298a7','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:00',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1647814900','138389d7-d792-4166-9ea5-e6898ba1daa0','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(835,'e2d16972-659e-4edd-848c-621332175f4d','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:00',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-1647814900-config-ndgphtkatd3c','state changed','OS::Heat::SoftwareConfig',NULL,148),(836,'886f2ac2-d599-450f-83a5-f61725307889','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:00',NULL,'CREATE','COMPLETE','config','99fb65cf-4365-49e1-8020-908c27816470','state changed','OS::Heat::SoftwareConfig',NULL,148),(837,'be4de30f-145e-4d21-b5bc-70ae02a21f4d','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:00',NULL,'CREATE','IN_PROGRESS','dep_4','ParallelDeploymentsTest-1647814900-dep_4-3v7275z7674o','state changed','OS::Heat::SoftwareDeployments',NULL,149),(838,'88497558-86fc-4aa2-afa0-c256291c4bab','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:01',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-1647814900-dep_1-bng2hoi7rvvv','state changed','OS::Heat::SoftwareDeployments',NULL,150),(839,'66704a1d-6d28-4534-a524-162cc1902cab','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:01',NULL,'CREATE','IN_PROGRESS','dep_3','ParallelDeploymentsTest-1647814900-dep_3-s7owfmvnomrx','state changed','OS::Heat::SoftwareDeployments',NULL,151),(840,'6eaa475b-9527-4ea4-9140-42d634abb6ff','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:01',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-1647814900-dep_2-oplhguqu7k5l','state changed','OS::Heat::SoftwareDeployments',NULL,152),(841,'d22172ac-d1c5-4ab2-b61d-4d30c36eefdb','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:01',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-1647814900-dep_0-77xgibe5oqko','state changed','OS::Heat::SoftwareDeployments',NULL,153),(842,'b241151d-cafa-4a33-9a87-862ec25322eb','9d685eb1-0c77-410a-a31c-69846cc343ec','2025-12-16 15:47:01',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1647814900-dep_4-3v7275z7674o','9d685eb1-0c77-410a-a31c-69846cc343ec','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(843,'8ae66d92-e56e-4f06-b948-4e0facca3248','610e789f-9f5a-4e53-9462-bafa5aafa5a8','2025-12-16 15:47:01',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1647814900-dep_1-bng2hoi7rvvv','610e789f-9f5a-4e53-9462-bafa5aafa5a8','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(844,'fed2d110-8714-4eaf-bd03-1f7009fe211a','ce2f7836-6308-407a-bbdc-3121334a461d','2025-12-16 15:47:01',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1647814900-dep_3-s7owfmvnomrx','ce2f7836-6308-407a-bbdc-3121334a461d','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(845,'11c0639c-5892-43ee-97e5-6565ded25365','60cddedb-576e-440b-85b8-27b1e2c5a50e','2025-12-16 15:47:01',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1647814900-dep_2-oplhguqu7k5l','60cddedb-576e-440b-85b8-27b1e2c5a50e','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(846,'7d76b4aa-d93a-4ad0-b02b-38b964fd5bcc','d28b5b24-4f08-4f19-a491-61dde3d5bd59','2025-12-16 15:47:01',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1647814900-dep_0-77xgibe5oqko','d28b5b24-4f08-4f19-a491-61dde3d5bd59','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(847,'a4b45a01-3aaa-498a-89bd-729d1e71282f','610e789f-9f5a-4e53-9462-bafa5aafa5a8','2025-12-16 15:47:01',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1647814900-dep_1-bng2hoi7rvvv-0-u2qbasqphon4','state changed','OS::Heat::SoftwareDeployment',NULL,154),(848,'0154ded1-c1f3-47a7-b2c3-80045fed9680','d28b5b24-4f08-4f19-a491-61dde3d5bd59','2025-12-16 15:47:01',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1647814900-dep_0-77xgibe5oqko-0-646qmf6abwpx','state changed','OS::Heat::SoftwareDeployment',NULL,156),(849,'c2396935-1201-4cef-8f9b-f83e1366be80','ce2f7836-6308-407a-bbdc-3121334a461d','2025-12-16 15:47:01',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1647814900-dep_3-s7owfmvnomrx-0-sxybbvjeoeiv','state changed','OS::Heat::SoftwareDeployment',NULL,157),(850,'66fd3e2c-d40b-4f1c-a98e-4eff1e98d31b','9d685eb1-0c77-410a-a31c-69846cc343ec','2025-12-16 15:47:01',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1647814900-dep_4-3v7275z7674o-0-ugkfasnlgaav','state changed','OS::Heat::SoftwareDeployment',NULL,155),(851,'a19d40e9-3b20-44fc-8b8d-e722bd27ad9f','60cddedb-576e-440b-85b8-27b1e2c5a50e','2025-12-16 15:47:01',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1647814900-dep_2-oplhguqu7k5l-0-da3fofdtmlj2','state changed','OS::Heat::SoftwareDeployment',NULL,158),(852,'7a7ceed3-f1e5-439d-a79f-ec7fae09f801','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:02',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-759910396','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(853,'02cbdcbc-f8f2-40f0-8ea6-44292949404e','9ab7fb5a-2105-4706-b669-bcc095a42071','2025-12-16 15:47:04',NULL,'UPDATE','IN_PROGRESS','add_network','9ab7fb5a-2105-4706-b669-bcc095a42071','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(854,'955c0ce0-5167-4285-b4f1-d2cb5567bc22','9ab7fb5a-2105-4706-b669-bcc095a42071','2025-12-16 15:47:05',NULL,'UPDATE','IN_PROGRESS','server','a75a815c-48d9-41eb-8004-b3012305e26a','state changed','OS::Nova::Server',NULL,129),(855,'80fbf179-369f-4b99-a31e-d117c9a36b83','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:05',NULL,'UPDATE','IN_PROGRESS','trunk','bfe912a9-10be-41a4-86a7-68197a8de337','state changed','OS::Neutron::Trunk',NULL,136),(856,'f759514c-38bb-4fd9-a453-e31765e3843a','8cbe1304-65fc-48b3-867d-2eecb51467cb','2025-12-16 15:47:06',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1451864420','8cbe1304-65fc-48b3-867d-2eecb51467cb','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(857,'7002f60f-513a-45e5-8d11-b3fa831ccc5f','8cbe1304-65fc-48b3-867d-2eecb51467cb','2025-12-16 15:47:06',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-1451864420-config-2pkl6gwaafvl','state changed','OS::Heat::SoftwareConfig',NULL,160),(858,'ede4e435-476b-4e5c-acc8-71f985e94a82','8cbe1304-65fc-48b3-867d-2eecb51467cb','2025-12-16 15:47:06',NULL,'CREATE','COMPLETE','config','c2803206-ff5d-4f45-add9-94708ecd153c','state changed','OS::Heat::SoftwareConfig',NULL,160),(859,'48131a85-7582-4462-b96b-f98ba12ee6d1','8cbe1304-65fc-48b3-867d-2eecb51467cb','2025-12-16 15:47:06',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-1451864420-dep_0-ki2ca4j6eite','state changed','OS::Heat::SoftwareDeployments',NULL,161),(860,'fa145a75-c110-4ac5-8880-3b22cf76aa90','8cbe1304-65fc-48b3-867d-2eecb51467cb','2025-12-16 15:47:06',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-1451864420-dep_2-aphjxdseiqss','state changed','OS::Heat::SoftwareDeployments',NULL,162),(861,'88550904-fb7a-40e2-9b03-b24701731ce0','8cbe1304-65fc-48b3-867d-2eecb51467cb','2025-12-16 15:47:06',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-1451864420-dep_1-ffrutgqryu3u','state changed','OS::Heat::SoftwareDeployments',NULL,163),(862,'a318205a-f364-443d-b82e-02686132c876','470d3c81-710c-4c77-b962-0273fa2913fd','2025-12-16 15:47:06',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1451864420-dep_2-aphjxdseiqss','470d3c81-710c-4c77-b962-0273fa2913fd','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(863,'aa42314f-b206-47b9-9156-4177caca4b7b','bda9f4bf-8230-42c0-aba8-d0cd924b9104','2025-12-16 15:47:06',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1451864420-dep_1-ffrutgqryu3u','bda9f4bf-8230-42c0-aba8-d0cd924b9104','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(864,'a89ff79a-ec46-42ce-8ff3-6105da9cc712','0b946e60-1c76-4965-bea2-b0311d7ecb3d','2025-12-16 15:47:06',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1451864420-dep_0-ki2ca4j6eite','0b946e60-1c76-4965-bea2-b0311d7ecb3d','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(865,'00c86807-1f00-494b-bb48-83a0de0d3e05','bda9f4bf-8230-42c0-aba8-d0cd924b9104','2025-12-16 15:47:06',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1451864420-dep_1-ffrutgqryu3u-0-wsnxakqyunhc','state changed','OS::Heat::SoftwareDeployment',NULL,164),(866,'e7e9b78f-5069-4f76-a3f8-d8dea3a3228d','0b946e60-1c76-4965-bea2-b0311d7ecb3d','2025-12-16 15:47:06',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1451864420-dep_0-ki2ca4j6eite-0-3sqmr6c4avmy','state changed','OS::Heat::SoftwareDeployment',NULL,165),(867,'1a467374-9f03-4c3c-8288-ecab5303dff0','470d3c81-710c-4c77-b962-0273fa2913fd','2025-12-16 15:47:06',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1451864420-dep_2-aphjxdseiqss-0-bgrfjnsp2dh4','state changed','OS::Heat::SoftwareDeployment',NULL,166),(868,'d15058a5-1a2c-4410-9e3e-9f9b7f59c0d5','7d5d6aa4-f847-42c2-a6b5-202cd43079dd','2025-12-16 15:47:07',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-166388227','7d5d6aa4-f847-42c2-a6b5-202cd43079dd','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(869,'256d8adb-246f-4814-bc46-615cf046f7f3','7d5d6aa4-f847-42c2-a6b5-202cd43079dd','2025-12-16 15:47:07',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-166388227-config-lkbjwex6fgl7','state changed','OS::Heat::SoftwareConfig',NULL,167),(870,'7194b4dd-ded2-4120-b084-f446691cdfcb','7d5d6aa4-f847-42c2-a6b5-202cd43079dd','2025-12-16 15:47:07',NULL,'CREATE','COMPLETE','config','39586321-3a89-43ba-9a93-9d92a3aa0ce0','state changed','OS::Heat::SoftwareConfig',NULL,167),(871,'f2cbe0c8-9159-4d71-ba09-d2a4849bed14','7d5d6aa4-f847-42c2-a6b5-202cd43079dd','2025-12-16 15:47:07',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-166388227-dep_2-l42jnylktmrk','state changed','OS::Heat::SoftwareDeployments',NULL,168),(872,'b1a00fce-62ce-492d-a03c-512037c0c926','7d5d6aa4-f847-42c2-a6b5-202cd43079dd','2025-12-16 15:47:07',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-166388227-dep_1-qfnm6pu36tjx','state changed','OS::Heat::SoftwareDeployments',NULL,169),(873,'6b2c598b-14d2-4d04-9390-839a66f72318','7d5d6aa4-f847-42c2-a6b5-202cd43079dd','2025-12-16 15:47:07',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-166388227-dep_0-j6mitznpjgh2','state changed','OS::Heat::SoftwareDeployments',NULL,170),(874,'40fc3954-12b4-47f1-bbdd-00c1243063b2','81183c40-92d8-4cb3-b34a-5e8a08bf6838','2025-12-16 15:47:07',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-166388227-dep_2-l42jnylktmrk','81183c40-92d8-4cb3-b34a-5e8a08bf6838','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(875,'08abfe54-07c8-4d07-abc9-669c80113b1f','11320322-f309-491f-99d1-acc21a7df6a7','2025-12-16 15:47:07',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-166388227-dep_1-qfnm6pu36tjx','11320322-f309-491f-99d1-acc21a7df6a7','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(876,'0d8bba80-d9fc-42eb-8c27-38790c71bddf','e92f965d-2a4c-42f2-898e-53250534243a','2025-12-16 15:47:07',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-166388227-dep_0-j6mitznpjgh2','e92f965d-2a4c-42f2-898e-53250534243a','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(877,'bea8b0bf-8456-434e-81b6-3809dce154fa','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:07',NULL,'UPDATE','COMPLETE','trunk','bfe912a9-10be-41a4-86a7-68197a8de337','state changed','OS::Neutron::Trunk',NULL,171),(878,'520293d9-1687-4cc4-ae56-19a04089d443','81183c40-92d8-4cb3-b34a-5e8a08bf6838','2025-12-16 15:47:07',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-166388227-dep_2-l42jnylktmrk-0-y2ltrnnvurff','state changed','OS::Heat::SoftwareDeployment',NULL,172),(879,'69205f67-edd0-4a0d-b286-dc5390928c4d','11320322-f309-491f-99d1-acc21a7df6a7','2025-12-16 15:47:07',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-166388227-dep_1-qfnm6pu36tjx-0-bkfgzyudjk2t','state changed','OS::Heat::SoftwareDeployment',NULL,173),(880,'471d1ae3-78b0-4e06-ac41-4347805e5d41','e92f965d-2a4c-42f2-898e-53250534243a','2025-12-16 15:47:07',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-166388227-dep_0-j6mitznpjgh2-0-26g6bxa2iscb','state changed','OS::Heat::SoftwareDeployment',NULL,174),(881,'a901bede-33d0-4d6f-aa49-69dcef922c92','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:08',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-759910396','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(882,'8680a421-8595-45b1-b168-7fd99fff5565','bdd251f1-d1ac-4e1c-b9db-eb87ee880162','2025-12-16 15:47:08',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1219149794','bdd251f1-d1ac-4e1c-b9db-eb87ee880162','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(883,'37f085ff-1b2c-49e3-9cb5-03164140b10d','bdd251f1-d1ac-4e1c-b9db-eb87ee880162','2025-12-16 15:47:09',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-1219149794-config-yn2pk6vw6bi7','state changed','OS::Heat::SoftwareConfig',NULL,175),(884,'809c5465-a428-4cdd-88b0-943527932582','bdd251f1-d1ac-4e1c-b9db-eb87ee880162','2025-12-16 15:47:09',NULL,'CREATE','COMPLETE','config','d4fb3320-1c65-424f-819b-1508b2cf5132','state changed','OS::Heat::SoftwareConfig',NULL,175),(885,'007ee740-a9f0-49c4-8c12-19180bf75808','9ab7fb5a-2105-4706-b669-bcc095a42071','2025-12-16 15:47:09',NULL,'UPDATE','COMPLETE','server','a75a815c-48d9-41eb-8004-b3012305e26a','state changed','OS::Nova::Server',NULL,176),(886,'58fbc902-3118-4b1b-973e-24e15ceb0146','bdd251f1-d1ac-4e1c-b9db-eb87ee880162','2025-12-16 15:47:09',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-1219149794-dep_1-4tkg2xu6xebi','state changed','OS::Heat::SoftwareDeployments',NULL,177),(887,'140e3038-a6c6-46f1-961e-fafedc8636aa','bdd251f1-d1ac-4e1c-b9db-eb87ee880162','2025-12-16 15:47:09',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-1219149794-dep_0-4bn6sp7mlgbq','state changed','OS::Heat::SoftwareDeployments',NULL,178),(888,'956e5496-d9f1-4ccf-8477-3aad4d3fd11e','09858d30-a346-46a6-9cec-34353693ccc8','2025-12-16 15:47:09',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1219149794-dep_1-4tkg2xu6xebi','09858d30-a346-46a6-9cec-34353693ccc8','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(889,'8be177a5-e53c-4851-b912-8ef2d4d22418','bdd251f1-d1ac-4e1c-b9db-eb87ee880162','2025-12-16 15:47:09',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-1219149794-dep_2-pz4htxfr3vh7','state changed','OS::Heat::SoftwareDeployments',NULL,179),(890,'43bede84-2dc6-4483-9901-63c89f15e464','9ab7fb5a-2105-4706-b669-bcc095a42071','2025-12-16 15:47:09',NULL,'UPDATE','COMPLETE','add_network','9ab7fb5a-2105-4706-b669-bcc095a42071','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(891,'3d62d906-39bc-4bfc-9b91-974bdd405947','0e8521aa-fdb8-4bc8-9cd7-014feb606679','2025-12-16 15:47:09',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1219149794-dep_2-pz4htxfr3vh7','0e8521aa-fdb8-4bc8-9cd7-014feb606679','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(892,'6be3ec66-d96b-4cfc-b4ad-4e7b08bbfb33','09858d30-a346-46a6-9cec-34353693ccc8','2025-12-16 15:47:09',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1219149794-dep_1-4tkg2xu6xebi-0-ouu7zx7iqvf6','state changed','OS::Heat::SoftwareDeployment',NULL,180),(893,'b63f93c3-7b02-4f49-8081-223874684bdb','33ae0948-8dca-4462-b6d0-e88feb56faa2','2025-12-16 15:47:09',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1219149794-dep_0-4bn6sp7mlgbq','33ae0948-8dca-4462-b6d0-e88feb56faa2','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(894,'6b150bd2-c84c-4001-8cde-df832423b55d','0e8521aa-fdb8-4bc8-9cd7-014feb606679','2025-12-16 15:47:09',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1219149794-dep_2-pz4htxfr3vh7-0-prvk6pdi3rgp','state changed','OS::Heat::SoftwareDeployment',NULL,181),(895,'ed1c86e6-d02b-43ac-a05e-658bcd0a124f','33ae0948-8dca-4462-b6d0-e88feb56faa2','2025-12-16 15:47:09',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1219149794-dep_0-4bn6sp7mlgbq-0-d2fw7qlfjnv6','state changed','OS::Heat::SoftwareDeployment',NULL,182),(896,'089cee70-11df-40f8-b918-49711ab87582','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:12',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-759910396','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(897,'cc166efc-7c26-45c1-93e2-fdb3512c3847','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:14',NULL,'DELETE','IN_PROGRESS','sub_port_two','c2315699-6280-4b7a-90e0-b503477da695','state changed','OS::Neutron::Port',NULL,134),(898,'5e4c6dad-4da0-4843-8315-31af51cdcf68','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:14',NULL,'DELETE','COMPLETE','sub_port_two','c2315699-6280-4b7a-90e0-b503477da695','state changed','OS::Neutron::Port',NULL,134),(899,'133cec48-d3ad-44da-a0a4-14a3a2425252','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:14',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','28caf69c-5f07-4316-b20b-8e93d8c30a96','state changed','OS::Neutron::Subnet',NULL,131),(900,'cd8786a1-e346-447d-9027-ee3b1a6db46b','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:15',NULL,'DELETE','IN_PROGRESS','trunk','bfe912a9-10be-41a4-86a7-68197a8de337','state changed','OS::Neutron::Trunk',NULL,171),(901,'cb67bde6-2b30-4004-9849-febf20e2ce0f','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:16',NULL,'DELETE','COMPLETE','trunk_subnet_two','28caf69c-5f07-4316-b20b-8e93d8c30a96','state changed','OS::Neutron::Subnet',NULL,131),(902,'1c373e29-9ea4-44ab-a313-324f76535695','0e8521aa-fdb8-4bc8-9cd7-014feb606679','2025-12-16 15:47:16',NULL,'SIGNAL','IN_PROGRESS','0','3c0b8636-8844-40e2-81b1-2c5ee7fed793','Signal: deployment 3c0b8636-8844-40e2-81b1-2c5ee7fed793 succeeded','OS::Heat::SoftwareDeployment',NULL,181),(903,'a977cf98-7655-4c0b-9e0b-ffcae634738e','0e8521aa-fdb8-4bc8-9cd7-014feb606679','2025-12-16 15:47:17',NULL,'CREATE','COMPLETE','0','3c0b8636-8844-40e2-81b1-2c5ee7fed793','state changed','OS::Heat::SoftwareDeployment',NULL,181),(904,'78dec112-6253-469c-841a-91d9fe2e96bf','33ae0948-8dca-4462-b6d0-e88feb56faa2','2025-12-16 15:47:17',NULL,'SIGNAL','IN_PROGRESS','0','b219c552-0497-43c3-b9c7-1f6caa8f1265','Signal: deployment b219c552-0497-43c3-b9c7-1f6caa8f1265 succeeded','OS::Heat::SoftwareDeployment',NULL,182),(905,'1a5115e9-dad2-4bdd-97ec-4e288be9c7c2','0e8521aa-fdb8-4bc8-9cd7-014feb606679','2025-12-16 15:47:18',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1219149794-dep_2-pz4htxfr3vh7','0e8521aa-fdb8-4bc8-9cd7-014feb606679','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(906,'682aa210-801f-4066-a9e4-c25a8c978941','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:18',NULL,'DELETE','IN_PROGRESS','trunk_net_two','83861d7c-305e-4e04-bda8-c992e55ea6bc','state changed','OS::Neutron::Net',NULL,NULL),(907,'83220735-354f-44e4-ac19-86502e568635','33ae0948-8dca-4462-b6d0-e88feb56faa2','2025-12-16 15:47:18',NULL,'CREATE','COMPLETE','0','b219c552-0497-43c3-b9c7-1f6caa8f1265','state changed','OS::Heat::SoftwareDeployment',NULL,182),(908,'171adeb4-dbee-40eb-b294-e39f547251e9','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:18',NULL,'DELETE','COMPLETE','trunk','bfe912a9-10be-41a4-86a7-68197a8de337','state changed','OS::Neutron::Trunk',NULL,171),(909,'bd897fe4-a577-4f0a-ad88-d43f2e3044cd','33ae0948-8dca-4462-b6d0-e88feb56faa2','2025-12-16 15:47:18',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1219149794-dep_0-4bn6sp7mlgbq','33ae0948-8dca-4462-b6d0-e88feb56faa2','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(910,'64e75a71-476c-4e50-af21-1670f4e1dbcb','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:18',NULL,'DELETE','IN_PROGRESS','sub_port_one','04089cf6-3387-4902-916c-0f03749b91b8','state changed','OS::Neutron::Port',NULL,133),(911,'d8dcab95-732a-43a4-a33c-5b3733a98f78','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:18',NULL,'DELETE','IN_PROGRESS','parent_port','0f592a27-5b60-4215-8729-c9c3594e0ce6','state changed','OS::Neutron::Port',NULL,135),(912,'f422303b-bd2f-48f9-8a62-09e482be2dcf','09858d30-a346-46a6-9cec-34353693ccc8','2025-12-16 15:47:18',NULL,'SIGNAL','IN_PROGRESS','0','d540b5ed-b7ba-4dbf-9293-5fd9e0b2c231','Signal: deployment d540b5ed-b7ba-4dbf-9293-5fd9e0b2c231 succeeded','OS::Heat::SoftwareDeployment',NULL,180),(913,'094eb1c8-b6a1-4728-9553-1a866ca0a84f','9ab7fb5a-2105-4706-b669-bcc095a42071','2025-12-16 15:47:18',NULL,'DELETE','IN_PROGRESS','add_network','9ab7fb5a-2105-4706-b669-bcc095a42071','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(914,'1fca40ee-aa03-45a6-a070-7d597b140355','9ab7fb5a-2105-4706-b669-bcc095a42071','2025-12-16 15:47:18',NULL,'DELETE','IN_PROGRESS','server','a75a815c-48d9-41eb-8004-b3012305e26a','state changed','OS::Nova::Server',NULL,176),(915,'816e9324-0941-43e8-896a-0a770e7d1bc7','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:18',NULL,'DELETE','COMPLETE','trunk_net_two','83861d7c-305e-4e04-bda8-c992e55ea6bc','state changed','OS::Neutron::Net',NULL,NULL),(916,'b5859196-e3a7-4c34-b295-4b8f858d6a70','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:18',NULL,'DELETE','COMPLETE','sub_port_one','04089cf6-3387-4902-916c-0f03749b91b8','state changed','OS::Neutron::Port',NULL,133),(917,'c5b7951f-7270-4229-a28c-cefd339df9be','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:18',NULL,'DELETE','COMPLETE','parent_port','0f592a27-5b60-4215-8729-c9c3594e0ce6','state changed','OS::Neutron::Port',NULL,135),(918,'e04c85a6-5e24-430c-8502-36a0dae946a3','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:18',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','bc21b24a-8db8-4d03-bb64-6fe8c7cdab86','state changed','OS::Neutron::Subnet',NULL,130),(919,'f0d49701-b0fa-4909-9462-12c48f4d8498','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:18',NULL,'DELETE','IN_PROGRESS','parent_subnet','40ace754-0a81-47c8-a5c1-7f24cb439c95','state changed','OS::Neutron::Subnet',NULL,132),(920,'4dec1821-dceb-4a8c-8bb7-3a5675a05d15','bdd251f1-d1ac-4e1c-b9db-eb87ee880162','2025-12-16 15:47:19',NULL,'CREATE','COMPLETE','dep_2','0e8521aa-fdb8-4bc8-9cd7-014feb606679','state changed','OS::Heat::SoftwareDeployments',NULL,179),(921,'cddec784-31af-4470-84d3-5ec905fcd228','bdd251f1-d1ac-4e1c-b9db-eb87ee880162','2025-12-16 15:47:19',NULL,'CREATE','COMPLETE','dep_0','33ae0948-8dca-4462-b6d0-e88feb56faa2','state changed','OS::Heat::SoftwareDeployments',NULL,178),(922,'9ba3bf40-8961-4137-8e4d-37c37d562805','09858d30-a346-46a6-9cec-34353693ccc8','2025-12-16 15:47:19',NULL,'CREATE','COMPLETE','0','d540b5ed-b7ba-4dbf-9293-5fd9e0b2c231','state changed','OS::Heat::SoftwareDeployment',NULL,180),(923,'6952dc5a-7646-4923-a649-ec4d6c712408','0b946e60-1c76-4965-bea2-b0311d7ecb3d','2025-12-16 15:47:19',NULL,'SIGNAL','IN_PROGRESS','0','0358d0d8-5d46-47e9-b1c9-f4909329014a','Signal: deployment 0358d0d8-5d46-47e9-b1c9-f4909329014a succeeded','OS::Heat::SoftwareDeployment',NULL,165),(924,'21b5d631-3980-4c25-a72f-f6c2a7cfa3c7','09858d30-a346-46a6-9cec-34353693ccc8','2025-12-16 15:47:19',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1219149794-dep_1-4tkg2xu6xebi','09858d30-a346-46a6-9cec-34353693ccc8','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(925,'bbfd639c-14d8-4899-afe8-8d2864b42496','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:19',NULL,'DELETE','COMPLETE','trunk_subnet_one','bc21b24a-8db8-4d03-bb64-6fe8c7cdab86','state changed','OS::Neutron::Subnet',NULL,130),(926,'e0e2c946-7b30-4225-9287-a5f6a0843916','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:19',NULL,'DELETE','COMPLETE','parent_subnet','40ace754-0a81-47c8-a5c1-7f24cb439c95','state changed','OS::Neutron::Subnet',NULL,132),(927,'0fe75414-db77-4bf6-8a7e-f9c00e62ff7e','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:19',NULL,'DELETE','IN_PROGRESS','trunk_net_one','c3c765ed-09fc-431f-bfb4-1d5631f8909f','state changed','OS::Neutron::Net',NULL,NULL),(928,'f5cc82c8-62ab-4e32-9b9f-2418ba52352c','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:19',NULL,'DELETE','IN_PROGRESS','parent_net','dc1985da-5cb3-40e2-93d3-5de234bbbd5f','state changed','OS::Neutron::Net',NULL,NULL),(929,'b8201849-9890-4139-9720-666bea124e51','0b946e60-1c76-4965-bea2-b0311d7ecb3d','2025-12-16 15:47:20',NULL,'CREATE','COMPLETE','0','0358d0d8-5d46-47e9-b1c9-f4909329014a','state changed','OS::Heat::SoftwareDeployment',NULL,165),(930,'fc99fa76-29ac-4cd7-9c03-c3a4918520ac','bdd251f1-d1ac-4e1c-b9db-eb87ee880162','2025-12-16 15:47:20',NULL,'CREATE','COMPLETE','dep_1','09858d30-a346-46a6-9cec-34353693ccc8','state changed','OS::Heat::SoftwareDeployments',NULL,177),(931,'05add89f-98b5-4238-96cf-383c42f35233','470d3c81-710c-4c77-b962-0273fa2913fd','2025-12-16 15:47:20',NULL,'SIGNAL','IN_PROGRESS','0','75b9fd5e-369c-4ff0-9fa3-eb5d5c33167e','Signal: deployment 75b9fd5e-369c-4ff0-9fa3-eb5d5c33167e succeeded','OS::Heat::SoftwareDeployment',NULL,166),(932,'54de090f-a7c4-4f45-b064-12af5429455a','bdd251f1-d1ac-4e1c-b9db-eb87ee880162','2025-12-16 15:47:20',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1219149794','bdd251f1-d1ac-4e1c-b9db-eb87ee880162','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(933,'a7cd2984-c2c6-4c79-9c69-401e39f2de09','0b946e60-1c76-4965-bea2-b0311d7ecb3d','2025-12-16 15:47:20',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1451864420-dep_0-ki2ca4j6eite','0b946e60-1c76-4965-bea2-b0311d7ecb3d','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(934,'5ab7c6aa-1025-4924-b0ec-fd382bb30050','bda9f4bf-8230-42c0-aba8-d0cd924b9104','2025-12-16 15:47:21',NULL,'SIGNAL','IN_PROGRESS','0','b26c88ec-fd3b-421f-b00d-fd2329a36ef5','Signal: deployment b26c88ec-fd3b-421f-b00d-fd2329a36ef5 succeeded','OS::Heat::SoftwareDeployment',NULL,164),(935,'73dc98e8-fe68-4547-9605-f17bcd99d411','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:21',NULL,'DELETE','COMPLETE','parent_net','dc1985da-5cb3-40e2-93d3-5de234bbbd5f','state changed','OS::Neutron::Net',NULL,NULL),(936,'00eba2b7-24d0-484f-84fb-2679a2f10b95','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:21',NULL,'DELETE','COMPLETE','trunk_net_one','c3c765ed-09fc-431f-bfb4-1d5631f8909f','state changed','OS::Neutron::Net',NULL,NULL),(937,'7b94036e-77d9-44ac-be5d-753478398707','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:47:21',NULL,'DELETE','COMPLETE','UpdateTrunkTest-759910396','c3543e55-42f5-43a5-93f9-58ed5ebf18d5','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(938,'e8faac3f-a50e-4f2a-9ba4-c2f9fd1aca91','ce2f7836-6308-407a-bbdc-3121334a461d','2025-12-16 15:47:21',NULL,'SIGNAL','IN_PROGRESS','0','6e00e032-fdd3-442a-8d31-6e42397779a2','Signal: deployment 6e00e032-fdd3-442a-8d31-6e42397779a2 succeeded','OS::Heat::SoftwareDeployment',NULL,157),(939,'1594cdb0-67fe-432c-9b13-3b81443f1511','9d685eb1-0c77-410a-a31c-69846cc343ec','2025-12-16 15:47:21',NULL,'SIGNAL','IN_PROGRESS','0','1fce20b2-3f6a-49e0-86b2-e4a1bbdd8d40','Signal: deployment 1fce20b2-3f6a-49e0-86b2-e4a1bbdd8d40 succeeded','OS::Heat::SoftwareDeployment',NULL,155),(940,'3d0271de-0326-42d9-b03e-69881f98dcf0','d28b5b24-4f08-4f19-a491-61dde3d5bd59','2025-12-16 15:47:21',NULL,'SIGNAL','IN_PROGRESS','0','3f02aaac-d4f7-4cc4-b79b-5cab1195d017','Signal: deployment 3f02aaac-d4f7-4cc4-b79b-5cab1195d017 succeeded','OS::Heat::SoftwareDeployment',NULL,156),(941,'2d0ca6a2-f13c-46b4-be05-771bdd83d13f','8cbe1304-65fc-48b3-867d-2eecb51467cb','2025-12-16 15:47:21',NULL,'CREATE','COMPLETE','dep_0','0b946e60-1c76-4965-bea2-b0311d7ecb3d','state changed','OS::Heat::SoftwareDeployments',NULL,161),(942,'683298c0-6202-4e25-825c-86b7f26dba20','bda9f4bf-8230-42c0-aba8-d0cd924b9104','2025-12-16 15:47:21',NULL,'CREATE','COMPLETE','0','b26c88ec-fd3b-421f-b00d-fd2329a36ef5','state changed','OS::Heat::SoftwareDeployment',NULL,164),(943,'29c40074-d285-4253-885b-36a6819a1868','d28b5b24-4f08-4f19-a491-61dde3d5bd59','2025-12-16 15:47:21',NULL,'CREATE','COMPLETE','0','3f02aaac-d4f7-4cc4-b79b-5cab1195d017','state changed','OS::Heat::SoftwareDeployment',NULL,156),(944,'2ef3afec-2262-4f59-8540-113cc993c3f5','9d685eb1-0c77-410a-a31c-69846cc343ec','2025-12-16 15:47:21',NULL,'CREATE','COMPLETE','0','1fce20b2-3f6a-49e0-86b2-e4a1bbdd8d40','state changed','OS::Heat::SoftwareDeployment',NULL,155),(945,'3ee5069e-0187-4781-afef-2fdfb6bfc5b1','ce2f7836-6308-407a-bbdc-3121334a461d','2025-12-16 15:47:21',NULL,'CREATE','COMPLETE','0','6e00e032-fdd3-442a-8d31-6e42397779a2','state changed','OS::Heat::SoftwareDeployment',NULL,157),(946,'ee3f933b-ac32-4cc5-8321-39cacb5a37af','470d3c81-710c-4c77-b962-0273fa2913fd','2025-12-16 15:47:21',NULL,'CREATE','COMPLETE','0','75b9fd5e-369c-4ff0-9fa3-eb5d5c33167e','state changed','OS::Heat::SoftwareDeployment',NULL,166),(947,'6df33bd8-9cba-41d1-b313-6125af29a2af','bda9f4bf-8230-42c0-aba8-d0cd924b9104','2025-12-16 15:47:21',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1451864420-dep_1-ffrutgqryu3u','bda9f4bf-8230-42c0-aba8-d0cd924b9104','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(948,'3f025148-f1d1-42db-b96b-192fa2b34f28','d28b5b24-4f08-4f19-a491-61dde3d5bd59','2025-12-16 15:47:21',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1647814900-dep_0-77xgibe5oqko','d28b5b24-4f08-4f19-a491-61dde3d5bd59','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(949,'26d63e33-092c-4db6-bffb-d1f25846f1ac','ce2f7836-6308-407a-bbdc-3121334a461d','2025-12-16 15:47:21',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1647814900-dep_3-s7owfmvnomrx','ce2f7836-6308-407a-bbdc-3121334a461d','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(950,'0e218918-bc00-4336-8e6a-a0b332579a72','9d685eb1-0c77-410a-a31c-69846cc343ec','2025-12-16 15:47:21',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1647814900-dep_4-3v7275z7674o','9d685eb1-0c77-410a-a31c-69846cc343ec','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(951,'c0f76ed2-f725-41ad-a1f3-392b9d4fd502','470d3c81-710c-4c77-b962-0273fa2913fd','2025-12-16 15:47:21',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1451864420-dep_2-aphjxdseiqss','470d3c81-710c-4c77-b962-0273fa2913fd','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(952,'9adc818d-e336-476c-91bb-5022282c9d77','8cbe1304-65fc-48b3-867d-2eecb51467cb','2025-12-16 15:47:22',NULL,'CREATE','COMPLETE','dep_1','bda9f4bf-8230-42c0-aba8-d0cd924b9104','state changed','OS::Heat::SoftwareDeployments',NULL,163),(953,'eafff24c-d496-4ae9-9ccf-dc82bbf97547','60cddedb-576e-440b-85b8-27b1e2c5a50e','2025-12-16 15:47:22',NULL,'SIGNAL','IN_PROGRESS','0','710678ae-31ce-45bb-8e11-71aea37e01b0','Signal: deployment 710678ae-31ce-45bb-8e11-71aea37e01b0 succeeded','OS::Heat::SoftwareDeployment',NULL,158),(954,'e82b755c-99ec-437e-8574-dfd3d1272840','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:22',NULL,'CREATE','COMPLETE','dep_3','ce2f7836-6308-407a-bbdc-3121334a461d','state changed','OS::Heat::SoftwareDeployments',NULL,151),(955,'c19da853-d756-43ef-9a4d-72caa9ea25c5','9ab7fb5a-2105-4706-b669-bcc095a42071','2025-12-16 15:47:22',NULL,'DELETE','COMPLETE','server','a75a815c-48d9-41eb-8004-b3012305e26a','state changed','OS::Nova::Server',NULL,176),(956,'3c61d41d-65ce-40cc-a15b-fab18069bf88','9ab7fb5a-2105-4706-b669-bcc095a42071','2025-12-16 15:47:22',NULL,'DELETE','IN_PROGRESS','subnet','283b9a23-d171-469e-8baa-b374439a4388','state changed','OS::Neutron::Subnet',NULL,128),(957,'8141f787-f5ac-4d38-827f-5e55a2ad91d3','610e789f-9f5a-4e53-9462-bafa5aafa5a8','2025-12-16 15:47:22',NULL,'SIGNAL','IN_PROGRESS','0','e20ef1e8-475c-441c-b522-40b349a8ed9d','Signal: deployment e20ef1e8-475c-441c-b522-40b349a8ed9d succeeded','OS::Heat::SoftwareDeployment',NULL,154),(958,'d39ec481-6776-4b48-83f6-c6099917aa8c','9ab7fb5a-2105-4706-b669-bcc095a42071','2025-12-16 15:47:22',NULL,'DELETE','COMPLETE','subnet','283b9a23-d171-469e-8baa-b374439a4388','state changed','OS::Neutron::Subnet',NULL,128),(959,'b83711a7-6daf-4dbd-ac2f-ee44eef3be5e','9ab7fb5a-2105-4706-b669-bcc095a42071','2025-12-16 15:47:22',NULL,'DELETE','IN_PROGRESS','net','23494041-f651-4d38-bdd8-f795ef41c456','state changed','OS::Neutron::Net',NULL,127),(960,'94307d8e-c4db-4e85-a487-a154f1c382e4','8cbe1304-65fc-48b3-867d-2eecb51467cb','2025-12-16 15:47:22',NULL,'CREATE','COMPLETE','dep_2','470d3c81-710c-4c77-b962-0273fa2913fd','state changed','OS::Heat::SoftwareDeployments',NULL,162),(961,'902d09bc-a200-4100-97aa-ff01564e92cf','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:22',NULL,'CREATE','COMPLETE','dep_0','d28b5b24-4f08-4f19-a491-61dde3d5bd59','state changed','OS::Heat::SoftwareDeployments',NULL,153),(962,'f8d03bae-ea5d-4ff5-a1af-2c8b2eeebd57','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:22',NULL,'CREATE','COMPLETE','dep_4','9d685eb1-0c77-410a-a31c-69846cc343ec','state changed','OS::Heat::SoftwareDeployments',NULL,149),(963,'dfa9c671-3797-4d32-99a3-25659a09088d','8cbe1304-65fc-48b3-867d-2eecb51467cb','2025-12-16 15:47:22',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1451864420','8cbe1304-65fc-48b3-867d-2eecb51467cb','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(964,'d0b18d43-bab6-4166-97a8-cfa7dbf5b9fb','60cddedb-576e-440b-85b8-27b1e2c5a50e','2025-12-16 15:47:22',NULL,'CREATE','COMPLETE','0','710678ae-31ce-45bb-8e11-71aea37e01b0','state changed','OS::Heat::SoftwareDeployment',NULL,158),(965,'e32c645e-5375-48f5-8e12-3cc2114c9034','610e789f-9f5a-4e53-9462-bafa5aafa5a8','2025-12-16 15:47:22',NULL,'CREATE','COMPLETE','0','e20ef1e8-475c-441c-b522-40b349a8ed9d','state changed','OS::Heat::SoftwareDeployment',NULL,154),(966,'5ed1d95b-eda5-44f4-b30f-fcdddac1ab6b','610e789f-9f5a-4e53-9462-bafa5aafa5a8','2025-12-16 15:47:22',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1647814900-dep_1-bng2hoi7rvvv','610e789f-9f5a-4e53-9462-bafa5aafa5a8','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(967,'29116f3e-fd11-476b-8077-a87f780f4a1f','60cddedb-576e-440b-85b8-27b1e2c5a50e','2025-12-16 15:47:22',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1647814900-dep_2-oplhguqu7k5l','60cddedb-576e-440b-85b8-27b1e2c5a50e','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(968,'187a3ea8-23a3-4411-a8ed-5aa89599bcbd','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:23',NULL,'CREATE','COMPLETE','dep_2','60cddedb-576e-440b-85b8-27b1e2c5a50e','state changed','OS::Heat::SoftwareDeployments',NULL,152),(969,'30152849-93ba-417c-bcda-30c24a4fe1e4','81183c40-92d8-4cb3-b34a-5e8a08bf6838','2025-12-16 15:47:23',NULL,'SIGNAL','IN_PROGRESS','0','2aab19c9-68da-4551-8988-5b0e4566eb0c','Signal: deployment 2aab19c9-68da-4551-8988-5b0e4566eb0c succeeded','OS::Heat::SoftwareDeployment',NULL,172),(970,'f141540a-d364-4f48-a3c6-71228037144a','9ab7fb5a-2105-4706-b669-bcc095a42071','2025-12-16 15:47:23',NULL,'DELETE','COMPLETE','net','23494041-f651-4d38-bdd8-f795ef41c456','state changed','OS::Neutron::Net',NULL,127),(971,'f2241743-95ef-466d-a6e7-f97ef50f22dd','9ab7fb5a-2105-4706-b669-bcc095a42071','2025-12-16 15:47:23',NULL,'DELETE','COMPLETE','add_network','9ab7fb5a-2105-4706-b669-bcc095a42071','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(972,'c4e4218f-2f6b-4b07-bbde-da6eca34f77b','11320322-f309-491f-99d1-acc21a7df6a7','2025-12-16 15:47:23',NULL,'SIGNAL','IN_PROGRESS','0','9cc81e0b-9537-4561-a5ec-0f68ad27d3dc','Signal: deployment 9cc81e0b-9537-4561-a5ec-0f68ad27d3dc succeeded','OS::Heat::SoftwareDeployment',NULL,173),(973,'44596b07-e8b6-4fc0-a72d-633954a4b96d','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:23',NULL,'CREATE','COMPLETE','dep_1','610e789f-9f5a-4e53-9462-bafa5aafa5a8','state changed','OS::Heat::SoftwareDeployments',NULL,150),(974,'edc9ff11-000b-4ff0-b110-2293c8f00440','e92f965d-2a4c-42f2-898e-53250534243a','2025-12-16 15:47:23',NULL,'SIGNAL','IN_PROGRESS','0','982007d6-86a8-4858-a00d-48c1c6a02266','Signal: deployment 982007d6-86a8-4858-a00d-48c1c6a02266 succeeded','OS::Heat::SoftwareDeployment',NULL,174),(975,'a54bede3-98ca-49e1-b31e-dccd03e71c6f','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:23',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1647814900','138389d7-d792-4166-9ea5-e6898ba1daa0','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(976,'5e3d682d-fe85-4475-9318-c7e70392c84e','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:23',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-1027559740','84793008-ef3d-4877-bba7-01648ba2a2bb','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(977,'70631efc-d9ea-4fe3-9afb-2429a4480b34','81183c40-92d8-4cb3-b34a-5e8a08bf6838','2025-12-16 15:47:23',NULL,'CREATE','COMPLETE','0','2aab19c9-68da-4551-8988-5b0e4566eb0c','state changed','OS::Heat::SoftwareDeployment',NULL,172),(978,'75d1aeac-b582-4713-bb61-45b8e338511f','81183c40-92d8-4cb3-b34a-5e8a08bf6838','2025-12-16 15:47:23',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-166388227-dep_2-l42jnylktmrk','81183c40-92d8-4cb3-b34a-5e8a08bf6838','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(979,'43013290-8f97-4289-baf8-df4abf944799','e92f965d-2a4c-42f2-898e-53250534243a','2025-12-16 15:47:23',NULL,'CREATE','COMPLETE','0','982007d6-86a8-4858-a00d-48c1c6a02266','state changed','OS::Heat::SoftwareDeployment',NULL,174),(980,'4b0fd67d-7ff4-481c-98fc-aec92302e37b','11320322-f309-491f-99d1-acc21a7df6a7','2025-12-16 15:47:23',NULL,'CREATE','COMPLETE','0','9cc81e0b-9537-4561-a5ec-0f68ad27d3dc','state changed','OS::Heat::SoftwareDeployment',NULL,173),(981,'de47bff4-a729-41e9-b81e-31f09d19567b','e92f965d-2a4c-42f2-898e-53250534243a','2025-12-16 15:47:23',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-166388227-dep_0-j6mitznpjgh2','e92f965d-2a4c-42f2-898e-53250534243a','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(982,'b0b7c62d-fce8-4cf4-9cd6-ba3ab75e9a95','11320322-f309-491f-99d1-acc21a7df6a7','2025-12-16 15:47:23',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-166388227-dep_1-qfnm6pu36tjx','11320322-f309-491f-99d1-acc21a7df6a7','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(983,'85cc8b7a-5d99-4a1b-bb9e-e9c362e449d8','7d5d6aa4-f847-42c2-a6b5-202cd43079dd','2025-12-16 15:47:24',NULL,'CREATE','COMPLETE','dep_1','11320322-f309-491f-99d1-acc21a7df6a7','state changed','OS::Heat::SoftwareDeployments',NULL,169),(984,'f6923b74-b2ea-4d6f-817f-ab2a2a77cfcd','bccb90e9-49c9-467e-9118-68f3d8f2f773','2025-12-16 15:47:24',NULL,'SIGNAL','IN_PROGRESS','0','0329e7b1-9210-4101-86cd-4539c9e76e54','Signal: deployment 0329e7b1-9210-4101-86cd-4539c9e76e54 succeeded','OS::Heat::SoftwareDeployment',NULL,147),(985,'bd55b0bc-c44d-4277-a7b4-9cb4cdbc54df','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:24',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-1027559740-trunk_net_one-q7cjnldb4tum','state changed','OS::Neutron::Net',NULL,NULL),(986,'00bbb89b-e985-4b49-90e5-1c6783578165','ac1887a9-4f8c-4d57-82b2-146244a4d030','2025-12-16 15:47:24',NULL,'SIGNAL','IN_PROGRESS','0','2b2647e5-81ac-43ca-881d-147fe4d5d511','Signal: deployment 2b2647e5-81ac-43ca-881d-147fe4d5d511 succeeded','OS::Heat::SoftwareDeployment',NULL,146),(987,'d26a19eb-0d55-444e-9a6c-05915eb2eeea','7d5d6aa4-f847-42c2-a6b5-202cd43079dd','2025-12-16 15:47:24',NULL,'CREATE','COMPLETE','dep_0','e92f965d-2a4c-42f2-898e-53250534243a','state changed','OS::Heat::SoftwareDeployments',NULL,170),(988,'398c8d72-da29-461f-8470-05f4917d812c','a0407c9d-9f4a-42f2-8907-8cb867120a66','2025-12-16 15:47:24',NULL,'SIGNAL','IN_PROGRESS','0','8350c0c0-7ba3-4228-83f6-0b468fbf683d','Signal: deployment 8350c0c0-7ba3-4228-83f6-0b468fbf683d succeeded','OS::Heat::SoftwareDeployment',NULL,143),(989,'8ca5a462-a39e-43c6-851f-38b914a7ad55','7d5d6aa4-f847-42c2-a6b5-202cd43079dd','2025-12-16 15:47:24',NULL,'CREATE','COMPLETE','dep_2','81183c40-92d8-4cb3-b34a-5e8a08bf6838','state changed','OS::Heat::SoftwareDeployments',NULL,168),(990,'e41af5e8-835b-45e9-8fb7-476d23e0b41a','7d5d6aa4-f847-42c2-a6b5-202cd43079dd','2025-12-16 15:47:24',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-166388227','7d5d6aa4-f847-42c2-a6b5-202cd43079dd','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(991,'73d48a6d-cfbb-4675-9146-1b62daf59a9c','a0407c9d-9f4a-42f2-8907-8cb867120a66','2025-12-16 15:47:24',NULL,'CREATE','COMPLETE','0','8350c0c0-7ba3-4228-83f6-0b468fbf683d','state changed','OS::Heat::SoftwareDeployment',NULL,143),(992,'59ca8018-c7d3-4bdc-9fce-e0e9dfb896ae','ac1887a9-4f8c-4d57-82b2-146244a4d030','2025-12-16 15:47:24',NULL,'CREATE','COMPLETE','0','2b2647e5-81ac-43ca-881d-147fe4d5d511','state changed','OS::Heat::SoftwareDeployment',NULL,146),(993,'369463af-327d-439d-b267-5922563efe92','bccb90e9-49c9-467e-9118-68f3d8f2f773','2025-12-16 15:47:24',NULL,'CREATE','COMPLETE','0','0329e7b1-9210-4101-86cd-4539c9e76e54','state changed','OS::Heat::SoftwareDeployment',NULL,147),(994,'454ca12c-7f7f-4026-b4d8-4e3897a4acb8','ac1887a9-4f8c-4d57-82b2-146244a4d030','2025-12-16 15:47:24',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-615637284-dep_3-2uy3tkfij6uf','ac1887a9-4f8c-4d57-82b2-146244a4d030','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(995,'c9dd5b21-4d34-49c2-ac70-17b77aa70145','bccb90e9-49c9-467e-9118-68f3d8f2f773','2025-12-16 15:47:24',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-615637284-dep_0-bn6krfvthvel','bccb90e9-49c9-467e-9118-68f3d8f2f773','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(996,'70c0838c-567e-4fb6-8445-b5f19791a2cf','a0407c9d-9f4a-42f2-8907-8cb867120a66','2025-12-16 15:47:24',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-615637284-dep_4-ubaedu76zued','a0407c9d-9f4a-42f2-8907-8cb867120a66','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(997,'f8af9e0c-9ee7-4409-bf86-12974b0ad9d2','91481ff0-416c-4925-9261-b5efdd2eb473','2025-12-16 15:47:25',NULL,'SIGNAL','IN_PROGRESS','0','99e2d99f-79d0-41f7-8040-ff6c275b494d','Signal: deployment 99e2d99f-79d0-41f7-8040-ff6c275b494d succeeded','OS::Heat::SoftwareDeployment',NULL,145),(998,'371987b8-eb7b-4250-8052-b2780d218b39','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:25',NULL,'CREATE','COMPLETE','trunk_net_one','ae45907c-8899-46e5-bf8f-77b32a65291c','state changed','OS::Neutron::Net',NULL,NULL),(999,'f32c05ee-e66d-48f4-8b3a-fd784087d833','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:25',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-1027559740-trunk_subnet_one-q6dvwftweb66','state changed','OS::Neutron::Subnet',NULL,185),(1000,'00d53868-ba0d-421b-92f3-66c083de5ab1','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:47:25',NULL,'CREATE','COMPLETE','dep_4','a0407c9d-9f4a-42f2-8907-8cb867120a66','state changed','OS::Heat::SoftwareDeployments',NULL,138),(1001,'48ab162c-636b-4e27-a334-8ad70bbcef58','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:47:25',NULL,'CREATE','COMPLETE','dep_0','bccb90e9-49c9-467e-9118-68f3d8f2f773','state changed','OS::Heat::SoftwareDeployments',NULL,142),(1002,'f0a41edd-9990-4539-b33f-6e602b9aa6c2','dce84e82-2761-493e-aed6-c2ceb3240413','2025-12-16 15:47:25',NULL,'SIGNAL','IN_PROGRESS','0','ace28ec1-449f-4db9-a178-8f4625551197','Signal: deployment ace28ec1-449f-4db9-a178-8f4625551197 succeeded','OS::Heat::SoftwareDeployment',NULL,144),(1003,'88e99739-afea-45c0-a582-a9bf5ca769b1','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:25',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-1027559740-parent_net-4zuhukk4m4fw','state changed','OS::Neutron::Net',NULL,NULL),(1004,'f5cbfb37-73ce-44a5-a106-7835c45070b7','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:47:25',NULL,'CREATE','COMPLETE','dep_3','ac1887a9-4f8c-4d57-82b2-146244a4d030','state changed','OS::Heat::SoftwareDeployments',NULL,141),(1005,'28de7f8d-73eb-4599-9f17-b264c6a624b3','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:25',NULL,'CREATE','COMPLETE','parent_net','4c6b9260-6e80-4e1a-bacf-5696e9e3cb7b','state changed','OS::Neutron::Net',NULL,NULL),(1006,'2fda38f5-4680-4529-918b-85abcca89592','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:25',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-1027559740-parent_subnet-7zv4tzjavpbh','state changed','OS::Neutron::Subnet',NULL,186),(1007,'7f123d1f-335e-493d-b618-04312e1f7b6d','91481ff0-416c-4925-9261-b5efdd2eb473','2025-12-16 15:47:25',NULL,'CREATE','COMPLETE','0','99e2d99f-79d0-41f7-8040-ff6c275b494d','state changed','OS::Heat::SoftwareDeployment',NULL,145),(1008,'36f0fc6c-9636-44eb-889f-2b411db35d44','dce84e82-2761-493e-aed6-c2ceb3240413','2025-12-16 15:47:25',NULL,'CREATE','COMPLETE','0','ace28ec1-449f-4db9-a178-8f4625551197','state changed','OS::Heat::SoftwareDeployment',NULL,144),(1009,'f83ff5d6-6f2e-4553-b05d-e59f46f0987b','dce84e82-2761-493e-aed6-c2ceb3240413','2025-12-16 15:47:25',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-615637284-dep_2-523kyhjuun3y','dce84e82-2761-493e-aed6-c2ceb3240413','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1010,'a05ce1c2-90e0-4306-ad35-d31525865892','91481ff0-416c-4925-9261-b5efdd2eb473','2025-12-16 15:47:25',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-615637284-dep_1-dosh4mmsqtuw','91481ff0-416c-4925-9261-b5efdd2eb473','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1011,'76e97640-27cc-45aa-9850-0096ff69f900','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:47:26',NULL,'CREATE','COMPLETE','dep_1','91481ff0-416c-4925-9261-b5efdd2eb473','state changed','OS::Heat::SoftwareDeployments',NULL,140),(1012,'c4fa629f-e382-4994-8f91-c0e819d1c2a9','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:47:26',NULL,'CREATE','COMPLETE','dep_2','dce84e82-2761-493e-aed6-c2ceb3240413','state changed','OS::Heat::SoftwareDeployments',NULL,139),(1013,'c58a83ba-2838-4cc7-abda-e8eda3bdaba5','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:26',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-1027559740-trunk_net_two-2janifjoffq6','state changed','OS::Neutron::Net',NULL,NULL),(1014,'29e7c87a-393c-4cb7-8ace-51d9deb9d154','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:47:27',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-615637284','476128fb-2e52-4d49-a4a7-c6e01d256343','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1015,'a956bcf0-c3a4-4f03-8abd-aee4556c8b56','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:28',NULL,'CREATE','COMPLETE','trunk_subnet_one','8277c254-a59f-4347-85d0-e78e8d82cc4a','state changed','OS::Neutron::Subnet',NULL,185),(1016,'989b67eb-cb10-48a2-9f0d-96af2533fd20','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:28',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-1027559740-sub_port_one-kajqxgodejo3','state changed','OS::Neutron::Port',NULL,187),(1017,'ee1495eb-6772-4de2-af99-f47597cafe68','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:28',NULL,'CREATE','COMPLETE','trunk_net_two','048ba4a7-d19f-400a-8ff4-cffb5d1d3345','state changed','OS::Neutron::Net',NULL,NULL),(1018,'7353e7a1-02d7-4c72-b26a-ab71117201d7','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:28',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-1027559740-trunk_subnet_two-s32vrq5z4zec','state changed','OS::Neutron::Subnet',NULL,188),(1019,'49fba6ec-2cae-46ad-a798-6f6a2935f765','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:29',NULL,'CREATE','COMPLETE','parent_subnet','cb64fa46-3986-4154-a192-4b44ca008af3','state changed','OS::Neutron::Subnet',NULL,186),(1020,'0baae214-9d38-49fb-bb96-071fe16779e4','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:29',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-1027559740-parent_port-7ispzscrtiez','state changed','OS::Neutron::Port',NULL,189),(1021,'c8b8c6a3-0918-4069-b950-af4b9d2fd53c','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:29',NULL,'CREATE','COMPLETE','sub_port_one','8187d339-6af4-425a-a940-0f8e1d186903','state changed','OS::Neutron::Port',NULL,187),(1022,'782f39b3-b422-43b1-bb33-0767a20e0b6f','ad2d8147-5f63-41a6-8dcd-b0c2da6c31b3','2025-12-16 15:47:29',NULL,'CREATE','IN_PROGRESS','same_fixed_ip','ad2d8147-5f63-41a6-8dcd-b0c2da6c31b3','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1023,'6dc4f88a-48fa-4fd1-8741-590cdc8fe2fc','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:29',NULL,'CREATE','COMPLETE','trunk_subnet_two','fb33113a-7176-4701-ba50-f65900cc7fcd','state changed','OS::Neutron::Subnet',NULL,188),(1024,'629015c8-105f-4918-9850-26b94817d04e','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:29',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-1027559740-sub_port_two-n734fhhgruyb','state changed','OS::Neutron::Port',NULL,190),(1025,'ca668263-d1be-4b09-a02a-5b7f98dcc760','ad2d8147-5f63-41a6-8dcd-b0c2da6c31b3','2025-12-16 15:47:29',NULL,'CREATE','IN_PROGRESS','net','same_fixed_ip-net-nzyn7lfkkt7n','state changed','OS::Neutron::Net',NULL,191),(1026,'633a6142-6a83-49bf-9f49-6151c2c344de','bdd251f1-d1ac-4e1c-b9db-eb87ee880162','2025-12-16 15:47:29',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1219149794','bdd251f1-d1ac-4e1c-b9db-eb87ee880162','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1027,'f5943b25-c689-4054-893f-c82cca94ab5d','bdd251f1-d1ac-4e1c-b9db-eb87ee880162','2025-12-16 15:47:29',NULL,'DELETE','IN_PROGRESS','dep_0','33ae0948-8dca-4462-b6d0-e88feb56faa2','state changed','OS::Heat::SoftwareDeployments',NULL,178),(1028,'d6f37c70-56a2-40cf-a838-f7567ca38570','33ae0948-8dca-4462-b6d0-e88feb56faa2','2025-12-16 15:47:29',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1219149794-dep_0-4bn6sp7mlgbq','33ae0948-8dca-4462-b6d0-e88feb56faa2','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1029,'fd312b81-084d-4e8c-97cb-2af1abab4687','33ae0948-8dca-4462-b6d0-e88feb56faa2','2025-12-16 15:47:29',NULL,'DELETE','IN_PROGRESS','0','b219c552-0497-43c3-b9c7-1f6caa8f1265','state changed','OS::Heat::SoftwareDeployment',NULL,182),(1030,'95085684-8b37-44df-a022-265783fe439c','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:30',NULL,'CREATE','COMPLETE','parent_port','25601d8d-dab4-446a-b13b-51e838b40f3a','state changed','OS::Neutron::Port',NULL,189),(1031,'b38cc581-cb2a-4071-a30a-0db8ff277479','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:30',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-1027559740-trunk-37rq4hsjpfuj','state changed','OS::Neutron::Trunk',NULL,192),(1032,'0e737a4b-c2f8-4bee-b596-7ca3e28b642a','ad2d8147-5f63-41a6-8dcd-b0c2da6c31b3','2025-12-16 15:47:30',NULL,'CREATE','COMPLETE','net','186dc40e-8340-42bb-b8c7-8f0a3d40e539','state changed','OS::Neutron::Net',NULL,191),(1033,'11814cb1-64cf-4b9c-98ee-67831ae224ae','ad2d8147-5f63-41a6-8dcd-b0c2da6c31b3','2025-12-16 15:47:30',NULL,'CREATE','IN_PROGRESS','subnet','same_fixed_ip-subnet-ncshe6wmr7bp','state changed','OS::Neutron::Subnet',NULL,193),(1034,'4c607365-7999-4de2-b053-c3b02242360b','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:30',NULL,'CREATE','COMPLETE','sub_port_two','4953bee6-5b27-46ad-ac48-2695a6d1b581','state changed','OS::Neutron::Port',NULL,190),(1035,'b1f46168-d89e-43d0-97e3-2760fbde31e5','33ae0948-8dca-4462-b6d0-e88feb56faa2','2025-12-16 15:47:30',NULL,'DELETE','COMPLETE','0','b219c552-0497-43c3-b9c7-1f6caa8f1265','state changed','OS::Heat::SoftwareDeployment',NULL,182),(1036,'bcbd5fa8-696e-4949-b8ab-ad1259fcacb4','33ae0948-8dca-4462-b6d0-e88feb56faa2','2025-12-16 15:47:30',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1219149794-dep_0-4bn6sp7mlgbq','33ae0948-8dca-4462-b6d0-e88feb56faa2','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1037,'a9e9c21f-83d3-4997-8553-52cf030677ec','bdd251f1-d1ac-4e1c-b9db-eb87ee880162','2025-12-16 15:47:30',NULL,'DELETE','IN_PROGRESS','dep_2','0e8521aa-fdb8-4bc8-9cd7-014feb606679','state changed','OS::Heat::SoftwareDeployments',NULL,179),(1038,'71c036a6-4e49-4a33-9f6d-ea85952a8a7e','0e8521aa-fdb8-4bc8-9cd7-014feb606679','2025-12-16 15:47:30',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1219149794-dep_2-pz4htxfr3vh7','0e8521aa-fdb8-4bc8-9cd7-014feb606679','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1039,'0a8d7a0e-d44c-451f-9dad-5f6f374c30ee','bdd251f1-d1ac-4e1c-b9db-eb87ee880162','2025-12-16 15:47:30',NULL,'DELETE','COMPLETE','dep_0','33ae0948-8dca-4462-b6d0-e88feb56faa2','state changed','OS::Heat::SoftwareDeployments',NULL,178),(1040,'ddc25683-ef69-4b23-b2f4-e76433bbd899','0e8521aa-fdb8-4bc8-9cd7-014feb606679','2025-12-16 15:47:30',NULL,'DELETE','IN_PROGRESS','0','3c0b8636-8844-40e2-81b1-2c5ee7fed793','state changed','OS::Heat::SoftwareDeployment',NULL,181),(1041,'ccab338a-abd6-444d-b1e5-fc3badc300a9','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:30',NULL,'CREATE','COMPLETE','trunk','f7a7d2f3-7eea-4c07-9ba2-37f91cd620cf','state changed','OS::Neutron::Trunk',NULL,192),(1042,'cef173b4-4d88-466f-9702-e6c5f830b9da','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:31',NULL,'CREATE','COMPLETE','UpdateTrunkTest-1027559740','84793008-ef3d-4877-bba7-01648ba2a2bb','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1043,'9a99bc83-9f98-4298-85f6-bc735503afa7','0e8521aa-fdb8-4bc8-9cd7-014feb606679','2025-12-16 15:47:31',NULL,'DELETE','COMPLETE','0','3c0b8636-8844-40e2-81b1-2c5ee7fed793','state changed','OS::Heat::SoftwareDeployment',NULL,181),(1044,'3f9c1b22-523c-4efd-8095-b09f0194fd07','0e8521aa-fdb8-4bc8-9cd7-014feb606679','2025-12-16 15:47:31',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1219149794-dep_2-pz4htxfr3vh7','0e8521aa-fdb8-4bc8-9cd7-014feb606679','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1045,'6f3f0afc-097a-4fde-838e-0e69cbc1de6b','ad2d8147-5f63-41a6-8dcd-b0c2da6c31b3','2025-12-16 15:47:31',NULL,'CREATE','COMPLETE','subnet','340cfe7a-6068-4069-b07b-5c7da7ba9392','state changed','OS::Neutron::Subnet',NULL,193),(1046,'a0a2c32c-38d9-4e48-a8a5-9a764bc3ee9f','ad2d8147-5f63-41a6-8dcd-b0c2da6c31b3','2025-12-16 15:47:31',NULL,'CREATE','IN_PROGRESS','server','same_fixed_ip-server-yviv6deka5cx','state changed','OS::Nova::Server',NULL,194),(1047,'823d44c5-f0dd-46d2-877e-bfd7797d9e5a','bdd251f1-d1ac-4e1c-b9db-eb87ee880162','2025-12-16 15:47:31',NULL,'DELETE','IN_PROGRESS','dep_1','09858d30-a346-46a6-9cec-34353693ccc8','state changed','OS::Heat::SoftwareDeployments',NULL,177),(1048,'053bafa7-c0b0-445c-ae06-e5831a7eea54','09858d30-a346-46a6-9cec-34353693ccc8','2025-12-16 15:47:31',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1219149794-dep_1-4tkg2xu6xebi','09858d30-a346-46a6-9cec-34353693ccc8','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1049,'f44eb84d-e4cc-4d81-a47a-b41606658697','bdd251f1-d1ac-4e1c-b9db-eb87ee880162','2025-12-16 15:47:31',NULL,'DELETE','COMPLETE','dep_2','0e8521aa-fdb8-4bc8-9cd7-014feb606679','state changed','OS::Heat::SoftwareDeployments',NULL,179),(1050,'96ac29dc-d8a2-4db0-b5cf-399a8ca29531','09858d30-a346-46a6-9cec-34353693ccc8','2025-12-16 15:47:31',NULL,'DELETE','IN_PROGRESS','0','d540b5ed-b7ba-4dbf-9293-5fd9e0b2c231','state changed','OS::Heat::SoftwareDeployment',NULL,180),(1051,'fa53ce35-e931-470f-aaae-1d6eb9d49e52','09858d30-a346-46a6-9cec-34353693ccc8','2025-12-16 15:47:32',NULL,'DELETE','COMPLETE','0','d540b5ed-b7ba-4dbf-9293-5fd9e0b2c231','state changed','OS::Heat::SoftwareDeployment',NULL,180),(1052,'ac5ec47d-4d91-4365-b4a3-116bdb0ba05b','09858d30-a346-46a6-9cec-34353693ccc8','2025-12-16 15:47:32',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1219149794-dep_1-4tkg2xu6xebi','09858d30-a346-46a6-9cec-34353693ccc8','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1053,'9f7b8640-c0ac-48d3-8bda-da163b85865d','bdd251f1-d1ac-4e1c-b9db-eb87ee880162','2025-12-16 15:47:33',NULL,'DELETE','COMPLETE','dep_1','09858d30-a346-46a6-9cec-34353693ccc8','state changed','OS::Heat::SoftwareDeployments',NULL,177),(1054,'0f6ddac8-ba83-41d1-83a7-1605c0d7fb0f','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:33',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-1027559740','84793008-ef3d-4877-bba7-01648ba2a2bb','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1055,'05770ab5-aa9b-4b47-a9e7-2918a4ce1f75','bdd251f1-d1ac-4e1c-b9db-eb87ee880162','2025-12-16 15:47:34',NULL,'DELETE','IN_PROGRESS','config','d4fb3320-1c65-424f-819b-1508b2cf5132','state changed','OS::Heat::SoftwareConfig',NULL,175),(1056,'01017d7b-4779-4541-a49c-ba21ea0a7cbd','bdd251f1-d1ac-4e1c-b9db-eb87ee880162','2025-12-16 15:47:34',NULL,'DELETE','COMPLETE','config','d4fb3320-1c65-424f-819b-1508b2cf5132','state changed','OS::Heat::SoftwareConfig',NULL,175),(1057,'dcfad8ed-79c0-4081-9a8a-bca674659504','bdd251f1-d1ac-4e1c-b9db-eb87ee880162','2025-12-16 15:47:34',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1219149794','bdd251f1-d1ac-4e1c-b9db-eb87ee880162','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1058,'25915ce7-3f4a-4579-8ec9-c0e1b08b1054','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:37',NULL,'UPDATE','IN_PROGRESS','trunk','f7a7d2f3-7eea-4c07-9ba2-37f91cd620cf','state changed','OS::Neutron::Trunk',NULL,192),(1059,'1e397063-63eb-4426-ac52-c6ac6d6b1cae','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:38',NULL,'UPDATE','COMPLETE','trunk','f7a7d2f3-7eea-4c07-9ba2-37f91cd620cf','state changed','OS::Neutron::Trunk',NULL,195),(1060,'c65b88ef-9521-40e7-a841-b9e581f5a70b','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:38',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-1027559740','84793008-ef3d-4877-bba7-01648ba2a2bb','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1061,'b9af4529-d166-4ac2-b52f-156af813c9a7','7d5d6aa4-f847-42c2-a6b5-202cd43079dd','2025-12-16 15:47:38',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-166388227','7d5d6aa4-f847-42c2-a6b5-202cd43079dd','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1062,'0cafbd8d-a1e4-405e-b8b6-c39f582993e1','7d5d6aa4-f847-42c2-a6b5-202cd43079dd','2025-12-16 15:47:39',NULL,'DELETE','IN_PROGRESS','dep_1','11320322-f309-491f-99d1-acc21a7df6a7','state changed','OS::Heat::SoftwareDeployments',NULL,169),(1063,'ae22e77f-30bd-4e4f-bd9b-c4588f287749','11320322-f309-491f-99d1-acc21a7df6a7','2025-12-16 15:47:39',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-166388227-dep_1-qfnm6pu36tjx','11320322-f309-491f-99d1-acc21a7df6a7','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1064,'3b3a2660-e079-40f5-a662-63d4ca9a9b1e','11320322-f309-491f-99d1-acc21a7df6a7','2025-12-16 15:47:39',NULL,'DELETE','IN_PROGRESS','0','9cc81e0b-9537-4561-a5ec-0f68ad27d3dc','state changed','OS::Heat::SoftwareDeployment',NULL,173),(1065,'a29b8761-d546-4da8-863f-b7243b5ae19c','7d5d6aa4-f847-42c2-a6b5-202cd43079dd','2025-12-16 15:47:40',NULL,'DELETE','IN_PROGRESS','dep_0','e92f965d-2a4c-42f2-898e-53250534243a','state changed','OS::Heat::SoftwareDeployments',NULL,170),(1066,'ee085479-83ac-4c63-8770-d445fd445734','e92f965d-2a4c-42f2-898e-53250534243a','2025-12-16 15:47:40',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-166388227-dep_0-j6mitznpjgh2','e92f965d-2a4c-42f2-898e-53250534243a','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1067,'981f9594-e306-49bd-ac9a-f2a2f50ee4f1','e92f965d-2a4c-42f2-898e-53250534243a','2025-12-16 15:47:40',NULL,'DELETE','IN_PROGRESS','0','982007d6-86a8-4858-a00d-48c1c6a02266','state changed','OS::Heat::SoftwareDeployment',NULL,174),(1068,'04a4bacf-fdc5-414d-9d26-d0a2ba8a7b2a','11320322-f309-491f-99d1-acc21a7df6a7','2025-12-16 15:47:40',NULL,'DELETE','COMPLETE','0','9cc81e0b-9537-4561-a5ec-0f68ad27d3dc','state changed','OS::Heat::SoftwareDeployment',NULL,173),(1069,'d09d8b3e-646d-4299-9fb1-c28cd50bd7db','11320322-f309-491f-99d1-acc21a7df6a7','2025-12-16 15:47:40',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-166388227-dep_1-qfnm6pu36tjx','11320322-f309-491f-99d1-acc21a7df6a7','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1070,'1fb19422-cbe5-487b-b3e5-8c7d0a2af1af','7d5d6aa4-f847-42c2-a6b5-202cd43079dd','2025-12-16 15:47:41',NULL,'DELETE','IN_PROGRESS','dep_2','81183c40-92d8-4cb3-b34a-5e8a08bf6838','state changed','OS::Heat::SoftwareDeployments',NULL,168),(1071,'6492b83a-1187-4a78-97da-2af102fcfe64','7d5d6aa4-f847-42c2-a6b5-202cd43079dd','2025-12-16 15:47:41',NULL,'DELETE','COMPLETE','dep_1','11320322-f309-491f-99d1-acc21a7df6a7','state changed','OS::Heat::SoftwareDeployments',NULL,169),(1072,'e1eeaaa4-01e9-4ec5-a593-183a26eba61e','81183c40-92d8-4cb3-b34a-5e8a08bf6838','2025-12-16 15:47:41',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-166388227-dep_2-l42jnylktmrk','81183c40-92d8-4cb3-b34a-5e8a08bf6838','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1073,'87667a99-6b57-4a11-b376-9a2f61b55024','81183c40-92d8-4cb3-b34a-5e8a08bf6838','2025-12-16 15:47:41',NULL,'DELETE','IN_PROGRESS','0','2aab19c9-68da-4551-8988-5b0e4566eb0c','state changed','OS::Heat::SoftwareDeployment',NULL,172),(1074,'cdc19dc9-e89a-4e20-840a-10d8e5747c70','e92f965d-2a4c-42f2-898e-53250534243a','2025-12-16 15:47:41',NULL,'DELETE','COMPLETE','0','982007d6-86a8-4858-a00d-48c1c6a02266','state changed','OS::Heat::SoftwareDeployment',NULL,174),(1075,'927caff4-658c-437b-ad75-3421c89259ae','e92f965d-2a4c-42f2-898e-53250534243a','2025-12-16 15:47:41',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-166388227-dep_0-j6mitznpjgh2','e92f965d-2a4c-42f2-898e-53250534243a','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1076,'aa04f215-1441-4f02-bcde-d9db4a79a1a5','7d5d6aa4-f847-42c2-a6b5-202cd43079dd','2025-12-16 15:47:42',NULL,'DELETE','COMPLETE','dep_0','e92f965d-2a4c-42f2-898e-53250534243a','state changed','OS::Heat::SoftwareDeployments',NULL,170),(1077,'9464e1b1-030b-4078-a841-10eb1ed7c7d8','81183c40-92d8-4cb3-b34a-5e8a08bf6838','2025-12-16 15:47:42',NULL,'DELETE','COMPLETE','0','2aab19c9-68da-4551-8988-5b0e4566eb0c','state changed','OS::Heat::SoftwareDeployment',NULL,172),(1078,'1623eac8-736c-498d-9501-3927c9430798','81183c40-92d8-4cb3-b34a-5e8a08bf6838','2025-12-16 15:47:42',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-166388227-dep_2-l42jnylktmrk','81183c40-92d8-4cb3-b34a-5e8a08bf6838','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1079,'e3368671-4404-4cad-91c4-19b4767e4718','7d5d6aa4-f847-42c2-a6b5-202cd43079dd','2025-12-16 15:47:43',NULL,'DELETE','COMPLETE','dep_2','81183c40-92d8-4cb3-b34a-5e8a08bf6838','state changed','OS::Heat::SoftwareDeployments',NULL,168),(1080,'966c8797-3f90-44ce-854b-d7ddb8f3cc5c','7d5d6aa4-f847-42c2-a6b5-202cd43079dd','2025-12-16 15:47:43',NULL,'DELETE','IN_PROGRESS','config','39586321-3a89-43ba-9a93-9d92a3aa0ce0','state changed','OS::Heat::SoftwareConfig',NULL,167),(1081,'e3f3a244-d35e-4fe5-8a3c-1ba1d97b1f23','7d5d6aa4-f847-42c2-a6b5-202cd43079dd','2025-12-16 15:47:43',NULL,'DELETE','COMPLETE','config','39586321-3a89-43ba-9a93-9d92a3aa0ce0','state changed','OS::Heat::SoftwareConfig',NULL,167),(1082,'9c52ab13-2b36-4619-bce6-710d266ec078','7d5d6aa4-f847-42c2-a6b5-202cd43079dd','2025-12-16 15:47:43',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-166388227','7d5d6aa4-f847-42c2-a6b5-202cd43079dd','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1083,'b25dde09-c94b-4d57-8989-ba874c149272','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:43',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-1027559740','84793008-ef3d-4877-bba7-01648ba2a2bb','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1084,'7e2b42e3-8562-4a32-87e4-10d828de86a6','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:44',NULL,'DELETE','IN_PROGRESS','sub_port_one','8187d339-6af4-425a-a940-0f8e1d186903','state changed','OS::Neutron::Port',NULL,187),(1085,'2db06fb0-2971-489a-9396-bf8ed5efb918','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:45',NULL,'DELETE','IN_PROGRESS','trunk','f7a7d2f3-7eea-4c07-9ba2-37f91cd620cf','state changed','OS::Neutron::Trunk',NULL,195),(1086,'2ecb7561-16cc-4fbc-b4f0-e7a2480a31bb','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:45',NULL,'DELETE','COMPLETE','sub_port_one','8187d339-6af4-425a-a940-0f8e1d186903','state changed','OS::Neutron::Port',NULL,187),(1087,'6bf74c5b-d2be-4c97-8916-e5e894ebcc55','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:45',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','8277c254-a59f-4347-85d0-e78e8d82cc4a','state changed','OS::Neutron::Subnet',NULL,185),(1088,'c8fbe5c9-3b36-4169-9dc2-0a5f6288b241','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:45',NULL,'DELETE','COMPLETE','trunk','f7a7d2f3-7eea-4c07-9ba2-37f91cd620cf','state changed','OS::Neutron::Trunk',NULL,195),(1089,'81ecf4bf-038b-47f5-941e-e6704d625ce1','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:45',NULL,'DELETE','IN_PROGRESS','parent_port','25601d8d-dab4-446a-b13b-51e838b40f3a','state changed','OS::Neutron::Port',NULL,189),(1090,'66e2dbf9-8c30-4954-b29c-8335205259ba','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:45',NULL,'DELETE','COMPLETE','trunk_subnet_one','8277c254-a59f-4347-85d0-e78e8d82cc4a','state changed','OS::Neutron::Subnet',NULL,185),(1091,'6d17945b-ad17-41be-8c91-48ba5a1a34f4','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:45',NULL,'DELETE','IN_PROGRESS','trunk_net_one','ae45907c-8899-46e5-bf8f-77b32a65291c','state changed','OS::Neutron::Net',NULL,NULL),(1092,'f9019944-56b6-41e0-8766-854932cca105','ad2d8147-5f63-41a6-8dcd-b0c2da6c31b3','2025-12-16 15:47:45',NULL,'CREATE','COMPLETE','server','c2f5c3df-c30c-428c-9edd-5a38f9d8ae3f','state changed','OS::Nova::Server',NULL,194),(1093,'551180f9-7e29-478f-94fc-7a0e105627a8','ad2d8147-5f63-41a6-8dcd-b0c2da6c31b3','2025-12-16 15:47:45',NULL,'CREATE','COMPLETE','same_fixed_ip','ad2d8147-5f63-41a6-8dcd-b0c2da6c31b3','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1094,'c11a177b-9d74-4f07-b091-71432eaf4f7b','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:45',NULL,'DELETE','COMPLETE','parent_port','25601d8d-dab4-446a-b13b-51e838b40f3a','state changed','OS::Neutron::Port',NULL,189),(1095,'2a52ddc2-d894-4746-a52c-8d7ae8daabcd','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:45',NULL,'DELETE','IN_PROGRESS','parent_subnet','cb64fa46-3986-4154-a192-4b44ca008af3','state changed','OS::Neutron::Subnet',NULL,186),(1096,'78e3b582-7676-4cad-be6c-3db2dfd6b113','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:46',NULL,'DELETE','IN_PROGRESS','sub_port_two','4953bee6-5b27-46ad-ac48-2695a6d1b581','state changed','OS::Neutron::Port',NULL,190),(1097,'b879e49b-c691-4465-9b51-ea0fa9c5e0e9','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:46',NULL,'DELETE','COMPLETE','trunk_net_one','ae45907c-8899-46e5-bf8f-77b32a65291c','state changed','OS::Neutron::Net',NULL,NULL),(1098,'ba2ef164-3f50-4d21-ac06-3662a89de9bc','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:46',NULL,'DELETE','COMPLETE','parent_subnet','cb64fa46-3986-4154-a192-4b44ca008af3','state changed','OS::Neutron::Subnet',NULL,186),(1099,'e7f43409-aae6-404b-80e3-9d556250af49','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:46',NULL,'DELETE','IN_PROGRESS','parent_net','4c6b9260-6e80-4e1a-bacf-5696e9e3cb7b','state changed','OS::Neutron::Net',NULL,NULL),(1100,'2ccdc980-1456-482a-bdb2-c50bd8f2640a','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:46',NULL,'DELETE','COMPLETE','sub_port_two','4953bee6-5b27-46ad-ac48-2695a6d1b581','state changed','OS::Neutron::Port',NULL,190),(1101,'31cde342-08e5-4638-9c91-25f3d84f6441','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:46',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','fb33113a-7176-4701-ba50-f65900cc7fcd','state changed','OS::Neutron::Subnet',NULL,188),(1102,'2afaa4b1-53c0-4071-960b-176d913c7015','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:46',NULL,'DELETE','COMPLETE','parent_net','4c6b9260-6e80-4e1a-bacf-5696e9e3cb7b','state changed','OS::Neutron::Net',NULL,NULL),(1103,'4f2619d6-6f7b-46ac-afbd-8fa9650fa2d3','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:47',NULL,'DELETE','COMPLETE','trunk_subnet_two','fb33113a-7176-4701-ba50-f65900cc7fcd','state changed','OS::Neutron::Subnet',NULL,188),(1104,'c6fe2d02-c433-4369-a0e8-46e8eeae8970','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:47',NULL,'DELETE','IN_PROGRESS','trunk_net_two','048ba4a7-d19f-400a-8ff4-cffb5d1d3345','state changed','OS::Neutron::Net',NULL,NULL),(1105,'8032d958-60fc-4356-9265-5ceb32dbfbcf','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:47',NULL,'DELETE','COMPLETE','trunk_net_two','048ba4a7-d19f-400a-8ff4-cffb5d1d3345','state changed','OS::Neutron::Net',NULL,NULL),(1106,'9cb0e217-3b75-44c7-a52b-6b2e61ee3039','8cbe1304-65fc-48b3-867d-2eecb51467cb','2025-12-16 15:47:47',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1451864420','8cbe1304-65fc-48b3-867d-2eecb51467cb','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1107,'eac59973-c960-4d51-85a3-587ffbea8a3b','84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:48',NULL,'DELETE','COMPLETE','UpdateTrunkTest-1027559740','84793008-ef3d-4877-bba7-01648ba2a2bb','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1108,'6e0b1d8d-75b0-424a-a49c-7821c6041d5d','8cbe1304-65fc-48b3-867d-2eecb51467cb','2025-12-16 15:47:48',NULL,'DELETE','IN_PROGRESS','dep_0','0b946e60-1c76-4965-bea2-b0311d7ecb3d','state changed','OS::Heat::SoftwareDeployments',NULL,161),(1109,'bbd04e7e-607f-48e0-850f-6e5eb229e53c','0b946e60-1c76-4965-bea2-b0311d7ecb3d','2025-12-16 15:47:48',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1451864420-dep_0-ki2ca4j6eite','0b946e60-1c76-4965-bea2-b0311d7ecb3d','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1110,'639d2d2e-80bc-4f5e-824c-b9a1e52ce314','0b946e60-1c76-4965-bea2-b0311d7ecb3d','2025-12-16 15:47:48',NULL,'DELETE','IN_PROGRESS','0','0358d0d8-5d46-47e9-b1c9-f4909329014a','state changed','OS::Heat::SoftwareDeployment',NULL,165),(1111,'6b9885f8-3c82-416f-94fc-4e0fa5d1c833','0b946e60-1c76-4965-bea2-b0311d7ecb3d','2025-12-16 15:47:48',NULL,'DELETE','COMPLETE','0','0358d0d8-5d46-47e9-b1c9-f4909329014a','state changed','OS::Heat::SoftwareDeployment',NULL,165),(1112,'d20c0179-3cec-4fc6-824e-4479bd48e795','0b946e60-1c76-4965-bea2-b0311d7ecb3d','2025-12-16 15:47:48',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1451864420-dep_0-ki2ca4j6eite','0b946e60-1c76-4965-bea2-b0311d7ecb3d','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1113,'7bb44371-9991-45fa-9acc-ace644611881','8cbe1304-65fc-48b3-867d-2eecb51467cb','2025-12-16 15:47:49',NULL,'DELETE','IN_PROGRESS','dep_2','470d3c81-710c-4c77-b962-0273fa2913fd','state changed','OS::Heat::SoftwareDeployments',NULL,162),(1114,'8224a87d-58d5-4f67-8fdc-6be3445a3bdd','470d3c81-710c-4c77-b962-0273fa2913fd','2025-12-16 15:47:49',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1451864420-dep_2-aphjxdseiqss','470d3c81-710c-4c77-b962-0273fa2913fd','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1115,'40d6207c-77e9-4228-890e-61741304660b','8cbe1304-65fc-48b3-867d-2eecb51467cb','2025-12-16 15:47:49',NULL,'DELETE','COMPLETE','dep_0','0b946e60-1c76-4965-bea2-b0311d7ecb3d','state changed','OS::Heat::SoftwareDeployments',NULL,161),(1116,'fcb36290-9e79-491b-b7cf-068394631f9b','470d3c81-710c-4c77-b962-0273fa2913fd','2025-12-16 15:47:49',NULL,'DELETE','IN_PROGRESS','0','75b9fd5e-369c-4ff0-9fa3-eb5d5c33167e','state changed','OS::Heat::SoftwareDeployment',NULL,166),(1117,'600a70ee-da1a-4281-81d9-51cb61947b8a','ad2d8147-5f63-41a6-8dcd-b0c2da6c31b3','2025-12-16 15:47:49',NULL,'UPDATE','IN_PROGRESS','same_fixed_ip','ad2d8147-5f63-41a6-8dcd-b0c2da6c31b3','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1118,'4f68535a-a12c-48e3-87a1-58626ee02d66','8cbe1304-65fc-48b3-867d-2eecb51467cb','2025-12-16 15:47:50',NULL,'DELETE','IN_PROGRESS','dep_1','bda9f4bf-8230-42c0-aba8-d0cd924b9104','state changed','OS::Heat::SoftwareDeployments',NULL,163),(1119,'35df258b-b158-4fed-8b91-0650ceaf0aaa','470d3c81-710c-4c77-b962-0273fa2913fd','2025-12-16 15:47:50',NULL,'DELETE','COMPLETE','0','75b9fd5e-369c-4ff0-9fa3-eb5d5c33167e','state changed','OS::Heat::SoftwareDeployment',NULL,166),(1120,'c752715b-ca60-4fb0-b4b6-2639d8d5750e','bda9f4bf-8230-42c0-aba8-d0cd924b9104','2025-12-16 15:47:50',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1451864420-dep_1-ffrutgqryu3u','bda9f4bf-8230-42c0-aba8-d0cd924b9104','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1121,'06909662-856e-400d-8b2d-c48277ac3be4','470d3c81-710c-4c77-b962-0273fa2913fd','2025-12-16 15:47:50',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1451864420-dep_2-aphjxdseiqss','470d3c81-710c-4c77-b962-0273fa2913fd','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1122,'caae1856-53e7-4da6-b4f7-7b876f637d6e','8cbe1304-65fc-48b3-867d-2eecb51467cb','2025-12-16 15:47:50',NULL,'DELETE','COMPLETE','dep_2','470d3c81-710c-4c77-b962-0273fa2913fd','state changed','OS::Heat::SoftwareDeployments',NULL,162),(1123,'0a336b9e-b345-4145-bbd8-f5c49222b5c8','bda9f4bf-8230-42c0-aba8-d0cd924b9104','2025-12-16 15:47:50',NULL,'DELETE','IN_PROGRESS','0','b26c88ec-fd3b-421f-b00d-fd2329a36ef5','state changed','OS::Heat::SoftwareDeployment',NULL,164),(1124,'5551de40-83e6-437a-9e8a-1214004ffbee','ad2d8147-5f63-41a6-8dcd-b0c2da6c31b3','2025-12-16 15:47:50',NULL,'UPDATE','IN_PROGRESS','server','c2f5c3df-c30c-428c-9edd-5a38f9d8ae3f','state changed','OS::Nova::Server',NULL,194),(1125,'7a68ef2d-3a20-4fc7-aae5-ffa0c3f522ee','bda9f4bf-8230-42c0-aba8-d0cd924b9104','2025-12-16 15:47:50',NULL,'DELETE','COMPLETE','0','b26c88ec-fd3b-421f-b00d-fd2329a36ef5','state changed','OS::Heat::SoftwareDeployment',NULL,164),(1126,'c0f43669-04d2-4cb9-bc9b-3b28391cb03a','bda9f4bf-8230-42c0-aba8-d0cd924b9104','2025-12-16 15:47:50',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1451864420-dep_1-ffrutgqryu3u','bda9f4bf-8230-42c0-aba8-d0cd924b9104','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1127,'69bc0837-da26-412d-916b-3933a30d3592','8cbe1304-65fc-48b3-867d-2eecb51467cb','2025-12-16 15:47:51',NULL,'DELETE','COMPLETE','dep_1','bda9f4bf-8230-42c0-aba8-d0cd924b9104','state changed','OS::Heat::SoftwareDeployments',NULL,163),(1128,'653e1eca-4e18-4d96-a185-21aa13a99cb8','8cbe1304-65fc-48b3-867d-2eecb51467cb','2025-12-16 15:47:51',NULL,'DELETE','IN_PROGRESS','config','c2803206-ff5d-4f45-add9-94708ecd153c','state changed','OS::Heat::SoftwareConfig',NULL,160),(1129,'f86e301c-8032-4324-b8c2-df387497c2c3','8cbe1304-65fc-48b3-867d-2eecb51467cb','2025-12-16 15:47:51',NULL,'DELETE','COMPLETE','config','c2803206-ff5d-4f45-add9-94708ecd153c','state changed','OS::Heat::SoftwareConfig',NULL,160),(1130,'eabf60e8-50f2-4066-acb3-ec8db5d727e2','8cbe1304-65fc-48b3-867d-2eecb51467cb','2025-12-16 15:47:51',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1451864420','8cbe1304-65fc-48b3-867d-2eecb51467cb','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1131,'11e3f731-00a4-43fa-8d45-d2c4a11834d7','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:52',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1647814900','138389d7-d792-4166-9ea5-e6898ba1daa0','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1132,'1eb52463-da26-4f20-a23b-ed6f75530eb7','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:52',NULL,'DELETE','IN_PROGRESS','dep_0','d28b5b24-4f08-4f19-a491-61dde3d5bd59','state changed','OS::Heat::SoftwareDeployments',NULL,153),(1133,'be83b2b0-438f-45fb-8c69-f2f019bd5160','d28b5b24-4f08-4f19-a491-61dde3d5bd59','2025-12-16 15:47:53',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1647814900-dep_0-77xgibe5oqko','d28b5b24-4f08-4f19-a491-61dde3d5bd59','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1134,'f8cfab34-3b31-4be9-963d-770feb20b0ec','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:53',NULL,'DELETE','IN_PROGRESS','dep_1','610e789f-9f5a-4e53-9462-bafa5aafa5a8','state changed','OS::Heat::SoftwareDeployments',NULL,150),(1135,'9d309644-529a-4a89-9ca7-a9f6dc793c2b','ad2d8147-5f63-41a6-8dcd-b0c2da6c31b3','2025-12-16 15:47:53',NULL,'UPDATE','COMPLETE','server','c2f5c3df-c30c-428c-9edd-5a38f9d8ae3f','state changed','OS::Nova::Server',NULL,198),(1136,'c3c5de35-6ba3-4aed-92ec-de0e74478f03','610e789f-9f5a-4e53-9462-bafa5aafa5a8','2025-12-16 15:47:54',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1647814900-dep_1-bng2hoi7rvvv','610e789f-9f5a-4e53-9462-bafa5aafa5a8','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1137,'2284dfd3-b8cd-484c-a79e-6ed3d46ff771','d28b5b24-4f08-4f19-a491-61dde3d5bd59','2025-12-16 15:47:54',NULL,'DELETE','IN_PROGRESS','0','3f02aaac-d4f7-4cc4-b79b-5cab1195d017','state changed','OS::Heat::SoftwareDeployment',NULL,156),(1138,'c62d6bb3-960b-4d6c-9892-1502650be1d9','610e789f-9f5a-4e53-9462-bafa5aafa5a8','2025-12-16 15:47:54',NULL,'DELETE','IN_PROGRESS','0','e20ef1e8-475c-441c-b522-40b349a8ed9d','state changed','OS::Heat::SoftwareDeployment',NULL,154),(1139,'43521aad-9afe-4d89-b49a-7ad95593731a','ad2d8147-5f63-41a6-8dcd-b0c2da6c31b3','2025-12-16 15:47:54',NULL,'UPDATE','COMPLETE','same_fixed_ip','ad2d8147-5f63-41a6-8dcd-b0c2da6c31b3','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1140,'7b85d6b4-4a7f-4610-ac2c-03a8597e8655','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:54',NULL,'DELETE','IN_PROGRESS','dep_4','9d685eb1-0c77-410a-a31c-69846cc343ec','state changed','OS::Heat::SoftwareDeployments',NULL,149),(1141,'81c15e74-ba9b-4683-8ee5-42636c9a3735','9d685eb1-0c77-410a-a31c-69846cc343ec','2025-12-16 15:47:55',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1647814900-dep_4-3v7275z7674o','9d685eb1-0c77-410a-a31c-69846cc343ec','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1142,'da95e7de-8202-436c-ab28-11d1d92ed912','9d685eb1-0c77-410a-a31c-69846cc343ec','2025-12-16 15:47:55',NULL,'DELETE','IN_PROGRESS','0','1fce20b2-3f6a-49e0-86b2-e4a1bbdd8d40','state changed','OS::Heat::SoftwareDeployment',NULL,155),(1143,'316d5684-c82e-4ca0-94c8-f647e8fa626c','d28b5b24-4f08-4f19-a491-61dde3d5bd59','2025-12-16 15:47:55',NULL,'DELETE','COMPLETE','0','3f02aaac-d4f7-4cc4-b79b-5cab1195d017','state changed','OS::Heat::SoftwareDeployment',NULL,156),(1144,'52653a02-6a78-41d4-b300-b01f010e6dbc','d28b5b24-4f08-4f19-a491-61dde3d5bd59','2025-12-16 15:47:55',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1647814900-dep_0-77xgibe5oqko','d28b5b24-4f08-4f19-a491-61dde3d5bd59','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1145,'875a39ad-6c8d-4caf-a928-ac6457f60e2d','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:55',NULL,'DELETE','IN_PROGRESS','dep_3','ce2f7836-6308-407a-bbdc-3121334a461d','state changed','OS::Heat::SoftwareDeployments',NULL,151),(1146,'144f7906-1b60-4186-a47e-f366acb9a434','ce2f7836-6308-407a-bbdc-3121334a461d','2025-12-16 15:47:55',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1647814900-dep_3-s7owfmvnomrx','ce2f7836-6308-407a-bbdc-3121334a461d','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1147,'2a6ac3fe-74b8-4b0e-aab9-857fbc5b0556','ce2f7836-6308-407a-bbdc-3121334a461d','2025-12-16 15:47:55',NULL,'DELETE','IN_PROGRESS','0','6e00e032-fdd3-442a-8d31-6e42397779a2','state changed','OS::Heat::SoftwareDeployment',NULL,157),(1148,'b197aca4-d545-40c0-a368-ea484da283af','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:56',NULL,'DELETE','COMPLETE','dep_0','d28b5b24-4f08-4f19-a491-61dde3d5bd59','state changed','OS::Heat::SoftwareDeployments',NULL,153),(1149,'149f1827-7218-431b-9c19-40dcece6fc71','610e789f-9f5a-4e53-9462-bafa5aafa5a8','2025-12-16 15:47:56',NULL,'DELETE','COMPLETE','0','e20ef1e8-475c-441c-b522-40b349a8ed9d','state changed','OS::Heat::SoftwareDeployment',NULL,154),(1150,'5664ca87-729d-445a-8070-b11be919a642','610e789f-9f5a-4e53-9462-bafa5aafa5a8','2025-12-16 15:47:56',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1647814900-dep_1-bng2hoi7rvvv','610e789f-9f5a-4e53-9462-bafa5aafa5a8','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1151,'92959c56-8c49-4302-a489-8f38532d2fc2','9d685eb1-0c77-410a-a31c-69846cc343ec','2025-12-16 15:47:56',NULL,'DELETE','COMPLETE','0','1fce20b2-3f6a-49e0-86b2-e4a1bbdd8d40','state changed','OS::Heat::SoftwareDeployment',NULL,155),(1152,'0a326b4b-5a97-41b1-b5aa-2197a1a5a5dd','9d685eb1-0c77-410a-a31c-69846cc343ec','2025-12-16 15:47:56',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1647814900-dep_4-3v7275z7674o','9d685eb1-0c77-410a-a31c-69846cc343ec','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1153,'6610bc0a-6fd6-490a-9e71-77e0053e199c','ce2f7836-6308-407a-bbdc-3121334a461d','2025-12-16 15:47:56',NULL,'DELETE','COMPLETE','0','6e00e032-fdd3-442a-8d31-6e42397779a2','state changed','OS::Heat::SoftwareDeployment',NULL,157),(1154,'546d9169-5418-4333-8ea1-6fc8d54cd6f1','ce2f7836-6308-407a-bbdc-3121334a461d','2025-12-16 15:47:56',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1647814900-dep_3-s7owfmvnomrx','ce2f7836-6308-407a-bbdc-3121334a461d','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1155,'281f95bd-2f7f-452e-b812-b86343f92fad','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:56',NULL,'DELETE','IN_PROGRESS','dep_2','60cddedb-576e-440b-85b8-27b1e2c5a50e','state changed','OS::Heat::SoftwareDeployments',NULL,152),(1156,'6a0b570a-d229-46c6-898f-b322d8e8bb21','60cddedb-576e-440b-85b8-27b1e2c5a50e','2025-12-16 15:47:56',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1647814900-dep_2-oplhguqu7k5l','60cddedb-576e-440b-85b8-27b1e2c5a50e','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1157,'817dae53-805c-47ca-8fd0-9108af1bdd76','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:56',NULL,'DELETE','COMPLETE','dep_3','ce2f7836-6308-407a-bbdc-3121334a461d','state changed','OS::Heat::SoftwareDeployments',NULL,151),(1158,'12b4ca36-bba3-43e2-b8c4-f69cfd52b63f','60cddedb-576e-440b-85b8-27b1e2c5a50e','2025-12-16 15:47:56',NULL,'DELETE','IN_PROGRESS','0','710678ae-31ce-45bb-8e11-71aea37e01b0','state changed','OS::Heat::SoftwareDeployment',NULL,158),(1159,'dc62ad84-445a-471e-8370-48435649fad6','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:57',NULL,'DELETE','COMPLETE','dep_1','610e789f-9f5a-4e53-9462-bafa5aafa5a8','state changed','OS::Heat::SoftwareDeployments',NULL,150),(1160,'170a0d6f-e443-4766-8b51-2374c41518fe','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:57',NULL,'DELETE','COMPLETE','dep_4','9d685eb1-0c77-410a-a31c-69846cc343ec','state changed','OS::Heat::SoftwareDeployments',NULL,149),(1161,'0ddc33b3-6486-4586-a36a-b6c277d42f0c','af3bef1c-23ea-4de8-8f9e-990b21f7874a','2025-12-16 15:47:57',NULL,'CREATE','IN_PROGRESS','StackTagTest-36062930','af3bef1c-23ea-4de8-8f9e-990b21f7874a','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1162,'c96500b9-437e-4712-8ec0-d5dc6c90af34','af3bef1c-23ea-4de8-8f9e-990b21f7874a','2025-12-16 15:47:57',NULL,'CREATE','IN_PROGRESS','not-used','StackTagTest-36062930-not-used-tb6kseod6aym','state changed','OS::Heat::TestResource',NULL,199),(1163,'0753fc9f-0edd-4227-835b-dfcc512acb4c','60cddedb-576e-440b-85b8-27b1e2c5a50e','2025-12-16 15:47:57',NULL,'DELETE','COMPLETE','0','710678ae-31ce-45bb-8e11-71aea37e01b0','state changed','OS::Heat::SoftwareDeployment',NULL,158),(1164,'616303bb-b287-4028-9bac-c0f82f557c23','60cddedb-576e-440b-85b8-27b1e2c5a50e','2025-12-16 15:47:57',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1647814900-dep_2-oplhguqu7k5l','60cddedb-576e-440b-85b8-27b1e2c5a50e','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1165,'fac59f56-293d-4bc8-b989-c52f24605765','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:57',NULL,'DELETE','COMPLETE','dep_2','60cddedb-576e-440b-85b8-27b1e2c5a50e','state changed','OS::Heat::SoftwareDeployments',NULL,152),(1166,'2f442395-8e9a-4c3b-9aef-04d44172b9aa','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:57',NULL,'DELETE','IN_PROGRESS','config','99fb65cf-4365-49e1-8020-908c27816470','state changed','OS::Heat::SoftwareConfig',NULL,148),(1167,'1307eb52-301e-4544-87db-261c020d6dfc','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:57',NULL,'DELETE','COMPLETE','config','99fb65cf-4365-49e1-8020-908c27816470','state changed','OS::Heat::SoftwareConfig',NULL,148),(1168,'35b6d814-5223-483b-adc9-d268fe3fc6a1','138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:57',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1647814900','138389d7-d792-4166-9ea5-e6898ba1daa0','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1169,'dd56f378-9740-4691-8227-236f04a8ad71','af3bef1c-23ea-4de8-8f9e-990b21f7874a','2025-12-16 15:47:59',NULL,'CREATE','COMPLETE','not-used','StackTagTest-36062930-not-used-tb6kseod6aym','state changed','OS::Heat::TestResource',NULL,199),(1170,'cce02981-9eba-4e7a-b9f0-9d743ad725d8','af3bef1c-23ea-4de8-8f9e-990b21f7874a','2025-12-16 15:47:59',NULL,'CREATE','COMPLETE','StackTagTest-36062930','af3bef1c-23ea-4de8-8f9e-990b21f7874a','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1171,'8443e8fd-6868-4e4a-a0a6-db736990342d','ad2d8147-5f63-41a6-8dcd-b0c2da6c31b3','2025-12-16 15:48:00',NULL,'DELETE','IN_PROGRESS','same_fixed_ip','ad2d8147-5f63-41a6-8dcd-b0c2da6c31b3','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1172,'8422a277-b8a6-4d19-b078-b85a1665bd7e','ad2d8147-5f63-41a6-8dcd-b0c2da6c31b3','2025-12-16 15:48:01',NULL,'DELETE','IN_PROGRESS','server','c2f5c3df-c30c-428c-9edd-5a38f9d8ae3f','state changed','OS::Nova::Server',NULL,198),(1173,'c77b9d6a-2b73-45d7-8e3a-7d3a6b204385','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:48:01',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-615637284','476128fb-2e52-4d49-a4a7-c6e01d256343','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1174,'0de0cddd-b38d-4170-a7a7-ea9f51b00dc2','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:48:01',NULL,'DELETE','IN_PROGRESS','dep_3','ac1887a9-4f8c-4d57-82b2-146244a4d030','state changed','OS::Heat::SoftwareDeployments',NULL,141),(1175,'1b4e3f9f-2f99-4b52-9037-94dbd6a5139c','ac1887a9-4f8c-4d57-82b2-146244a4d030','2025-12-16 15:48:01',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-615637284-dep_3-2uy3tkfij6uf','ac1887a9-4f8c-4d57-82b2-146244a4d030','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1176,'4bfe8fbf-03fa-4fbc-a78a-5f45b0e68755','ac1887a9-4f8c-4d57-82b2-146244a4d030','2025-12-16 15:48:01',NULL,'DELETE','IN_PROGRESS','0','2b2647e5-81ac-43ca-881d-147fe4d5d511','state changed','OS::Heat::SoftwareDeployment',NULL,146),(1177,'3a1b03e0-70eb-4dbd-add8-a07d11f12b28','ac1887a9-4f8c-4d57-82b2-146244a4d030','2025-12-16 15:48:02',NULL,'DELETE','COMPLETE','0','2b2647e5-81ac-43ca-881d-147fe4d5d511','state changed','OS::Heat::SoftwareDeployment',NULL,146),(1178,'7594f8f1-0578-4022-8e15-337f0cbc8342','ac1887a9-4f8c-4d57-82b2-146244a4d030','2025-12-16 15:48:02',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-615637284-dep_3-2uy3tkfij6uf','ac1887a9-4f8c-4d57-82b2-146244a4d030','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1179,'b5b9d752-c067-478e-8fc0-a44f9c00311a','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:48:02',NULL,'DELETE','IN_PROGRESS','dep_0','bccb90e9-49c9-467e-9118-68f3d8f2f773','state changed','OS::Heat::SoftwareDeployments',NULL,142),(1180,'7527ea22-6bee-4f43-852e-ea3fb83ac202','bccb90e9-49c9-467e-9118-68f3d8f2f773','2025-12-16 15:48:02',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-615637284-dep_0-bn6krfvthvel','bccb90e9-49c9-467e-9118-68f3d8f2f773','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1181,'4e9615fc-51de-4962-a489-d3e2adc82155','af3bef1c-23ea-4de8-8f9e-990b21f7874a','2025-12-16 15:48:02',NULL,'DELETE','IN_PROGRESS','StackTagTest-36062930','af3bef1c-23ea-4de8-8f9e-990b21f7874a','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1182,'e7a4cf33-c59d-47be-b0e6-9bb6c6e998fc','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:48:02',NULL,'DELETE','COMPLETE','dep_3','ac1887a9-4f8c-4d57-82b2-146244a4d030','state changed','OS::Heat::SoftwareDeployments',NULL,141),(1183,'8ba1aa0a-3573-4327-b4c1-a7cb7b881d89','bccb90e9-49c9-467e-9118-68f3d8f2f773','2025-12-16 15:48:02',NULL,'DELETE','IN_PROGRESS','0','0329e7b1-9210-4101-86cd-4539c9e76e54','state changed','OS::Heat::SoftwareDeployment',NULL,147),(1184,'146c30a9-c985-4afa-9d66-cc7956c2d3fb','af3bef1c-23ea-4de8-8f9e-990b21f7874a','2025-12-16 15:48:02',NULL,'DELETE','IN_PROGRESS','not-used','StackTagTest-36062930-not-used-tb6kseod6aym','state changed','OS::Heat::TestResource',NULL,199),(1185,'f47227e6-ed54-48eb-999a-68aee1633d6d','ad2d8147-5f63-41a6-8dcd-b0c2da6c31b3','2025-12-16 15:48:03',NULL,'DELETE','COMPLETE','server','c2f5c3df-c30c-428c-9edd-5a38f9d8ae3f','state changed','OS::Nova::Server',NULL,198),(1186,'fd6efc4b-cb02-4734-9c16-50f256fa897e','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:48:03',NULL,'DELETE','IN_PROGRESS','dep_4','a0407c9d-9f4a-42f2-8907-8cb867120a66','state changed','OS::Heat::SoftwareDeployments',NULL,138),(1187,'d9e23539-686c-4208-9012-9b9da14741f0','af3bef1c-23ea-4de8-8f9e-990b21f7874a','2025-12-16 15:48:04',NULL,'DELETE','COMPLETE','not-used','StackTagTest-36062930-not-used-tb6kseod6aym','state changed','OS::Heat::TestResource',NULL,199),(1188,'2117a2a1-500c-4964-b3bf-68751a82f001','ad2d8147-5f63-41a6-8dcd-b0c2da6c31b3','2025-12-16 15:48:05',NULL,'DELETE','IN_PROGRESS','subnet','340cfe7a-6068-4069-b07b-5c7da7ba9392','state changed','OS::Neutron::Subnet',NULL,193),(1189,'cdc6c2fc-aed6-4940-8fd6-bc1211f2c840','a0407c9d-9f4a-42f2-8907-8cb867120a66','2025-12-16 15:48:05',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-615637284-dep_4-ubaedu76zued','a0407c9d-9f4a-42f2-8907-8cb867120a66','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1190,'a42714a6-6744-4055-875c-71fc4342fec7','af3bef1c-23ea-4de8-8f9e-990b21f7874a','2025-12-16 15:48:05',NULL,'DELETE','COMPLETE','StackTagTest-36062930','af3bef1c-23ea-4de8-8f9e-990b21f7874a','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1191,'d4896413-b9bf-4e14-9a4b-6b5340ca817b','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:48:05',NULL,'DELETE','IN_PROGRESS','dep_2','dce84e82-2761-493e-aed6-c2ceb3240413','state changed','OS::Heat::SoftwareDeployments',NULL,139),(1192,'009d7ba6-c197-456d-aa25-5099ad970d98','dce84e82-2761-493e-aed6-c2ceb3240413','2025-12-16 15:48:05',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-615637284-dep_2-523kyhjuun3y','dce84e82-2761-493e-aed6-c2ceb3240413','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1193,'5f1a12c6-c023-460d-ba34-7425432f2593','bccb90e9-49c9-467e-9118-68f3d8f2f773','2025-12-16 15:48:05',NULL,'DELETE','COMPLETE','0','0329e7b1-9210-4101-86cd-4539c9e76e54','state changed','OS::Heat::SoftwareDeployment',NULL,147),(1194,'30323307-a8c8-475d-bebc-1ea4ef67c1e9','a0407c9d-9f4a-42f2-8907-8cb867120a66','2025-12-16 15:48:05',NULL,'DELETE','IN_PROGRESS','0','8350c0c0-7ba3-4228-83f6-0b468fbf683d','state changed','OS::Heat::SoftwareDeployment',NULL,143),(1195,'80bd7811-7703-41dc-8ca4-67b9a46c7cbd','bccb90e9-49c9-467e-9118-68f3d8f2f773','2025-12-16 15:48:05',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-615637284-dep_0-bn6krfvthvel','bccb90e9-49c9-467e-9118-68f3d8f2f773','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1196,'f39f90ba-dacf-4d94-94e6-5ac6160ed96d','dce84e82-2761-493e-aed6-c2ceb3240413','2025-12-16 15:48:05',NULL,'DELETE','IN_PROGRESS','0','ace28ec1-449f-4db9-a178-8f4625551197','state changed','OS::Heat::SoftwareDeployment',NULL,144),(1197,'335303dd-043f-4d30-9fa8-0a40fb2e545e','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:48:05',NULL,'DELETE','IN_PROGRESS','dep_1','91481ff0-416c-4925-9261-b5efdd2eb473','state changed','OS::Heat::SoftwareDeployments',NULL,140),(1198,'1b1588e9-801f-4f18-9faa-fbd03b5027f8','91481ff0-416c-4925-9261-b5efdd2eb473','2025-12-16 15:48:05',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-615637284-dep_1-dosh4mmsqtuw','91481ff0-416c-4925-9261-b5efdd2eb473','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1199,'98285f39-e351-42af-a476-5b5ad99ce2d8','91481ff0-416c-4925-9261-b5efdd2eb473','2025-12-16 15:48:05',NULL,'DELETE','IN_PROGRESS','0','99e2d99f-79d0-41f7-8040-ff6c275b494d','state changed','OS::Heat::SoftwareDeployment',NULL,145),(1200,'9b7ab9b8-c41c-447f-966f-22df80d116ee','ad2d8147-5f63-41a6-8dcd-b0c2da6c31b3','2025-12-16 15:48:05',NULL,'DELETE','COMPLETE','subnet','340cfe7a-6068-4069-b07b-5c7da7ba9392','state changed','OS::Neutron::Subnet',NULL,193),(1201,'58d52fef-92da-46ca-88c6-ff14d97212b8','ad2d8147-5f63-41a6-8dcd-b0c2da6c31b3','2025-12-16 15:48:05',NULL,'DELETE','IN_PROGRESS','net','186dc40e-8340-42bb-b8c7-8f0a3d40e539','state changed','OS::Neutron::Net',NULL,191),(1202,'8e754ea7-9cfa-4eb6-a9a8-53065e73adc6','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:48:05',NULL,'DELETE','COMPLETE','dep_0','bccb90e9-49c9-467e-9118-68f3d8f2f773','state changed','OS::Heat::SoftwareDeployments',NULL,142),(1203,'45b37542-6c18-409f-9e0b-ea7bf99c07d0','a0407c9d-9f4a-42f2-8907-8cb867120a66','2025-12-16 15:48:06',NULL,'DELETE','COMPLETE','0','8350c0c0-7ba3-4228-83f6-0b468fbf683d','state changed','OS::Heat::SoftwareDeployment',NULL,143),(1204,'fbb2ca87-2556-4c1b-a966-0903c600c865','dce84e82-2761-493e-aed6-c2ceb3240413','2025-12-16 15:48:06',NULL,'DELETE','COMPLETE','0','ace28ec1-449f-4db9-a178-8f4625551197','state changed','OS::Heat::SoftwareDeployment',NULL,144),(1205,'16a7dfc0-07dd-4827-94f2-f69e00223a1d','dce84e82-2761-493e-aed6-c2ceb3240413','2025-12-16 15:48:06',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-615637284-dep_2-523kyhjuun3y','dce84e82-2761-493e-aed6-c2ceb3240413','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1206,'b8d552a2-b86c-4cf6-ba75-ace604d87163','a0407c9d-9f4a-42f2-8907-8cb867120a66','2025-12-16 15:48:06',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-615637284-dep_4-ubaedu76zued','a0407c9d-9f4a-42f2-8907-8cb867120a66','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1207,'df9f9ffd-17bd-44a8-ae71-10955acc404d','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:48:06',NULL,'DELETE','COMPLETE','dep_2','dce84e82-2761-493e-aed6-c2ceb3240413','state changed','OS::Heat::SoftwareDeployments',NULL,139),(1208,'c9ecb273-227f-41d4-a9d6-34ec10d90fda','91481ff0-416c-4925-9261-b5efdd2eb473','2025-12-16 15:48:06',NULL,'DELETE','COMPLETE','0','99e2d99f-79d0-41f7-8040-ff6c275b494d','state changed','OS::Heat::SoftwareDeployment',NULL,145),(1209,'311a9532-620c-48bd-b2c1-2a93bb2ab161','91481ff0-416c-4925-9261-b5efdd2eb473','2025-12-16 15:48:06',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-615637284-dep_1-dosh4mmsqtuw','91481ff0-416c-4925-9261-b5efdd2eb473','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1210,'0996240e-5015-4b8f-aa3b-73248a25a1c0','ad2d8147-5f63-41a6-8dcd-b0c2da6c31b3','2025-12-16 15:48:06',NULL,'DELETE','COMPLETE','net','186dc40e-8340-42bb-b8c7-8f0a3d40e539','state changed','OS::Neutron::Net',NULL,191),(1211,'e80a8c54-3b4f-44c9-a834-2e1b16ec61a1','ad2d8147-5f63-41a6-8dcd-b0c2da6c31b3','2025-12-16 15:48:06',NULL,'DELETE','COMPLETE','same_fixed_ip','ad2d8147-5f63-41a6-8dcd-b0c2da6c31b3','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1212,'e72b1813-4037-49ab-8b30-623eb8eac980','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:48:06',NULL,'DELETE','COMPLETE','dep_1','91481ff0-416c-4925-9261-b5efdd2eb473','state changed','OS::Heat::SoftwareDeployments',NULL,140),(1213,'c7cc1a8c-1423-49e0-8c9f-6e36ad290c2c','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:48:07',NULL,'DELETE','COMPLETE','dep_4','a0407c9d-9f4a-42f2-8907-8cb867120a66','state changed','OS::Heat::SoftwareDeployments',NULL,138),(1214,'d928b980-f05e-4fc5-83b0-d8342e42364f','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:48:07',NULL,'DELETE','IN_PROGRESS','config','1ef18178-43af-4577-b255-a43922f9655b','state changed','OS::Heat::SoftwareConfig',NULL,137),(1215,'57806a3a-654c-4442-a5b9-9a9571427138','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:48:08',NULL,'DELETE','COMPLETE','config','1ef18178-43af-4577-b255-a43922f9655b','state changed','OS::Heat::SoftwareConfig',NULL,137),(1216,'ef7d1748-736d-48da-aef1-9bbe9a1152c9','476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:48:08',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-615637284','476128fb-2e52-4d49-a4a7-c6e01d256343','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1217,'bafe1508-3461-428a-9bbc-2ce18786acfe','9c9b6a4c-1270-4c34-85e2-3883ebd38a9c','2025-12-16 15:48:08',NULL,'CREATE','IN_PROGRESS','StackTagTest-1854058341','9c9b6a4c-1270-4c34-85e2-3883ebd38a9c','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1218,'344bdddc-e484-4fc3-a413-3f53a5c58fab','9c9b6a4c-1270-4c34-85e2-3883ebd38a9c','2025-12-16 15:48:08',NULL,'CREATE','IN_PROGRESS','not-used','StackTagTest-1854058341-not-used-amtlazpgckw5','state changed','OS::Heat::TestResource',NULL,201),(1219,'5c46a96d-5ffd-4ec4-b0ea-ef34e726dc03','84e8374e-8283-4692-ae62-2a35a9ce21a2','2025-12-16 15:48:10',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-2020059004','84e8374e-8283-4692-ae62-2a35a9ce21a2','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1220,'1de151c7-5bda-416c-8d92-892ce53f9f4f','84e8374e-8283-4692-ae62-2a35a9ce21a2','2025-12-16 15:48:10',NULL,'DELETE','IN_PROGRESS','server','6ff592d2-64da-422f-be47-7488a1aa9068','state changed','OS::Nova::Server',NULL,126),(1221,'5a1cb733-8f65-4685-8fd8-16f0cefcd356','9c9b6a4c-1270-4c34-85e2-3883ebd38a9c','2025-12-16 15:48:10',NULL,'CREATE','COMPLETE','not-used','StackTagTest-1854058341-not-used-amtlazpgckw5','state changed','OS::Heat::TestResource',NULL,201),(1222,'d62ce5b8-9925-40d5-812e-02f05978e21b','9c9b6a4c-1270-4c34-85e2-3883ebd38a9c','2025-12-16 15:48:10',NULL,'CREATE','COMPLETE','StackTagTest-1854058341','9c9b6a4c-1270-4c34-85e2-3883ebd38a9c','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1223,'f244dedc-175b-413e-baff-98cec9444d59','a6db82eb-2271-48a6-99b2-618a93847934','2025-12-16 15:48:11',NULL,'CREATE','IN_PROGRESS','add_subnet','a6db82eb-2271-48a6-99b2-618a93847934','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1224,'890a5c1a-3550-4f87-ac2c-4617e2f650e0','a6db82eb-2271-48a6-99b2-618a93847934','2025-12-16 15:48:12',NULL,'CREATE','IN_PROGRESS','net','add_subnet-net-n43tpjhhnrqo','state changed','OS::Neutron::Net',NULL,202),(1225,'ad07e59f-f665-4b3c-9d58-a3b3c866c8d5','a6db82eb-2271-48a6-99b2-618a93847934','2025-12-16 15:48:12',NULL,'CREATE','COMPLETE','net','f0043a08-afd4-4678-8421-44da438726fe','state changed','OS::Neutron::Net',NULL,202),(1226,'29db96f5-3913-45bd-b29c-4b461f7572ff','a6db82eb-2271-48a6-99b2-618a93847934','2025-12-16 15:48:12',NULL,'CREATE','IN_PROGRESS','subnet','add_subnet-subnet-d26ikj4qjwdn','state changed','OS::Neutron::Subnet',NULL,203),(1227,'2e03834f-c472-46e9-87af-57921e8f0a45','84e8374e-8283-4692-ae62-2a35a9ce21a2','2025-12-16 15:48:13',NULL,'DELETE','COMPLETE','server','6ff592d2-64da-422f-be47-7488a1aa9068','state changed','OS::Nova::Server',NULL,126),(1228,'a4603a35-b94e-4b0d-8bc3-156f2827e5bc','84e8374e-8283-4692-ae62-2a35a9ce21a2','2025-12-16 15:48:13',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-2020059004','84e8374e-8283-4692-ae62-2a35a9ce21a2','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1229,'71d6b058-462c-4e3a-b706-6a4b20436084','a6db82eb-2271-48a6-99b2-618a93847934','2025-12-16 15:48:15',NULL,'CREATE','COMPLETE','subnet','50b03234-1f80-4dd2-b1dd-e0e4ce4c7eaa','state changed','OS::Neutron::Subnet',NULL,203),(1230,'f4f6c8f2-6463-4120-b154-b2bdc09206d3','a6db82eb-2271-48a6-99b2-618a93847934','2025-12-16 15:48:15',NULL,'CREATE','IN_PROGRESS','server','add_subnet-server-taeqvhblvhlx','state changed','OS::Nova::Server',NULL,204),(1231,'e2190294-88fb-4ba5-b408-f5c324c1d643','9c9b6a4c-1270-4c34-85e2-3883ebd38a9c','2025-12-16 15:48:15',NULL,'UPDATE','IN_PROGRESS','StackTagTest-1854058341','9c9b6a4c-1270-4c34-85e2-3883ebd38a9c','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1232,'676fe37f-3adc-43d5-8612-e32a5dd78850','9c9b6a4c-1270-4c34-85e2-3883ebd38a9c','2025-12-16 15:48:16',NULL,'UPDATE','IN_PROGRESS','not-used','StackTagTest-1854058341-not-used-amtlazpgckw5','state changed','OS::Heat::TestResource',NULL,201),(1233,'6f327866-6a4c-44fd-b796-b8cf64ac0ffe','4d7ea472-c5cf-4020-8a45-9f4b818927f7','2025-12-16 15:48:17',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-305141961','4d7ea472-c5cf-4020-8a45-9f4b818927f7','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1234,'ab73caf9-c46f-4ab4-8fd0-dd12df78f95d','4d7ea472-c5cf-4020-8a45-9f4b818927f7','2025-12-16 15:48:17',NULL,'CREATE','IN_PROGRESS','server','ParallelDeploymentsTest-305141961-server-nycvmiohhgid','state changed','OS::Nova::Server',NULL,205),(1235,'ad66f964-6820-474c-9981-9e2de0050a15','9c9b6a4c-1270-4c34-85e2-3883ebd38a9c','2025-12-16 15:48:18',NULL,'UPDATE','COMPLETE','not-used','StackTagTest-1854058341-not-used-amtlazpgckw5','state changed','OS::Heat::TestResource',NULL,206),(1236,'8b8a9c81-a33f-42bf-80f7-a573bbb0f9f3','9c9b6a4c-1270-4c34-85e2-3883ebd38a9c','2025-12-16 15:48:18',NULL,'UPDATE','COMPLETE','StackTagTest-1854058341','9c9b6a4c-1270-4c34-85e2-3883ebd38a9c','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1237,'1c900a02-dc90-4047-8c95-737587688db4','9c9b6a4c-1270-4c34-85e2-3883ebd38a9c','2025-12-16 15:48:21',NULL,'UPDATE','IN_PROGRESS','StackTagTest-1854058341','9c9b6a4c-1270-4c34-85e2-3883ebd38a9c','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1238,'30c5a2c9-18c2-4531-8998-56730022b6e2','9c9b6a4c-1270-4c34-85e2-3883ebd38a9c','2025-12-16 15:48:21',NULL,'UPDATE','IN_PROGRESS','not-used','StackTagTest-1854058341-not-used-amtlazpgckw5','state changed','OS::Heat::TestResource',NULL,206),(1239,'3e6f942d-5d60-45db-b67a-30706b5f5d96','9c9b6a4c-1270-4c34-85e2-3883ebd38a9c','2025-12-16 15:48:23',NULL,'UPDATE','COMPLETE','not-used','StackTagTest-1854058341-not-used-amtlazpgckw5','state changed','OS::Heat::TestResource',NULL,207),(1240,'6b6729b5-65bd-45bd-a121-718dd2f9f966','9c9b6a4c-1270-4c34-85e2-3883ebd38a9c','2025-12-16 15:48:24',NULL,'UPDATE','COMPLETE','StackTagTest-1854058341','9c9b6a4c-1270-4c34-85e2-3883ebd38a9c','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1241,'0c39f0d7-c716-4167-8caf-a5bf7989bd04','9c9b6a4c-1270-4c34-85e2-3883ebd38a9c','2025-12-16 15:48:26',NULL,'DELETE','IN_PROGRESS','StackTagTest-1854058341','9c9b6a4c-1270-4c34-85e2-3883ebd38a9c','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1242,'a0d07f6b-1a48-4eef-84e1-9c63d984a34d','9c9b6a4c-1270-4c34-85e2-3883ebd38a9c','2025-12-16 15:48:27',NULL,'DELETE','IN_PROGRESS','not-used','StackTagTest-1854058341-not-used-amtlazpgckw5','state changed','OS::Heat::TestResource',NULL,207),(1243,'e0be2f04-cf7d-48bf-ae05-70f75627dfbc','9c9b6a4c-1270-4c34-85e2-3883ebd38a9c','2025-12-16 15:48:29',NULL,'DELETE','COMPLETE','not-used','StackTagTest-1854058341-not-used-amtlazpgckw5','state changed','OS::Heat::TestResource',NULL,207),(1244,'e7947d7b-811f-4344-bf1a-a078223b4107','9c9b6a4c-1270-4c34-85e2-3883ebd38a9c','2025-12-16 15:48:29',NULL,'DELETE','COMPLETE','StackTagTest-1854058341','9c9b6a4c-1270-4c34-85e2-3883ebd38a9c','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1245,'957e1f33-668f-4809-8a31-f0502d4aa384','a6db82eb-2271-48a6-99b2-618a93847934','2025-12-16 15:48:29',NULL,'CREATE','COMPLETE','server','6f241b9f-7e5d-4516-a8a2-9cb1b3121eec','state changed','OS::Nova::Server',NULL,204),(1246,'d53b3357-99e5-463c-8c64-04847232a26f','a6db82eb-2271-48a6-99b2-618a93847934','2025-12-16 15:48:29',NULL,'CREATE','COMPLETE','add_subnet','a6db82eb-2271-48a6-99b2-618a93847934','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1247,'757b081a-f4e9-4a5f-9502-3885efa60359','4d7ea472-c5cf-4020-8a45-9f4b818927f7','2025-12-16 15:48:31',NULL,'CREATE','COMPLETE','server','1b2ae6fb-2f83-44b7-a283-cc4cec490f5f','state changed','OS::Nova::Server',NULL,205),(1248,'ce915abd-5b5b-4bab-b471-4fd2208d2d44','4d7ea472-c5cf-4020-8a45-9f4b818927f7','2025-12-16 15:48:31',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-305141961','4d7ea472-c5cf-4020-8a45-9f4b818927f7','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1249,'a66604bf-b7f2-4d88-b109-7481f004637d','7b4a51e6-9e97-4c2f-963e-4a6e20c09e5c','2025-12-16 15:48:34',NULL,'CREATE','IN_PROGRESS','StackUnicodeTemplateTest-1663997320','7b4a51e6-9e97-4c2f-963e-4a6e20c09e5c','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1250,'7db6b853-fac4-4ce8-b923-08d44844f57e','7b4a51e6-9e97-4c2f-963e-4a6e20c09e5c','2025-12-16 15:48:34',NULL,'CREATE','IN_PROGRESS','资源','StackUnicodeTemplateTest-1663997320-资源-in3fcg3jmev5','state changed','OS::Heat::RandomString',NULL,208),(1251,'849ab3f5-8793-4424-9716-f6f843ab22f1','7b4a51e6-9e97-4c2f-963e-4a6e20c09e5c','2025-12-16 15:48:34',NULL,'CREATE','COMPLETE','资源','StackUnicodeTemplateTest-1663997320-资源-in3fcg3jmev5','state changed','OS::Heat::RandomString',NULL,208),(1252,'4ed99127-4747-418a-adab-e4571ddfc960','7b4a51e6-9e97-4c2f-963e-4a6e20c09e5c','2025-12-16 15:48:34',NULL,'CREATE','COMPLETE','StackUnicodeTemplateTest-1663997320','7b4a51e6-9e97-4c2f-963e-4a6e20c09e5c','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1253,'29746082-6740-49fc-8161-f6aa0974fa7a','7b4a51e6-9e97-4c2f-963e-4a6e20c09e5c','2025-12-16 15:48:35',NULL,'DELETE','IN_PROGRESS','StackUnicodeTemplateTest-1663997320','7b4a51e6-9e97-4c2f-963e-4a6e20c09e5c','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1254,'44269d53-57fd-4e68-8b16-0d933e10d05d','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','2025-12-16 15:48:35',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-2096521252','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1255,'3b739b16-dd36-4aef-9829-c7ffa4c69340','7b4a51e6-9e97-4c2f-963e-4a6e20c09e5c','2025-12-16 15:48:35',NULL,'DELETE','IN_PROGRESS','资源','StackUnicodeTemplateTest-1663997320-资源-in3fcg3jmev5','state changed','OS::Heat::RandomString',NULL,208),(1256,'9ea57a74-9188-47dc-802e-6a5302f939c2','7b4a51e6-9e97-4c2f-963e-4a6e20c09e5c','2025-12-16 15:48:35',NULL,'DELETE','COMPLETE','资源','StackUnicodeTemplateTest-1663997320-资源-in3fcg3jmev5','state changed','OS::Heat::RandomString',NULL,208),(1257,'834c31e0-c14d-4fe1-9050-41f2825c1589','7b4a51e6-9e97-4c2f-963e-4a6e20c09e5c','2025-12-16 15:48:35',NULL,'DELETE','COMPLETE','StackUnicodeTemplateTest-1663997320','7b4a51e6-9e97-4c2f-963e-4a6e20c09e5c','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1258,'0b03d0b5-07c7-48d2-8b9b-81cecd8ede64','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','2025-12-16 15:48:35',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-2096521252-config-id27brul3msv','state changed','OS::Heat::SoftwareConfig',NULL,209),(1259,'796fe209-1602-4614-8f02-cbaa531ee30e','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','2025-12-16 15:48:35',NULL,'CREATE','COMPLETE','config','6967c451-f021-42cd-8651-7c7a654e2fc5','state changed','OS::Heat::SoftwareConfig',NULL,209),(1260,'49fa4242-e01a-4ca1-a0c9-c020e5f79ed5','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','2025-12-16 15:48:35',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-2096521252-dep_1-b6wqywoen3tc','state changed','OS::Heat::SoftwareDeployments',NULL,210),(1261,'16a5545c-b067-445c-945b-cd09cf93b6ff','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','2025-12-16 15:48:35',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-2096521252-dep_0-azwr43qlug65','state changed','OS::Heat::SoftwareDeployments',NULL,211),(1262,'f4d11f49-e579-41d3-9a91-b7ea44b48159','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','2025-12-16 15:48:35',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-2096521252-dep_2-wh2k2orfjp55','state changed','OS::Heat::SoftwareDeployments',NULL,212),(1263,'c00cd9d8-b922-4622-ba23-38e66e147c0e','7ce7898f-841d-4bc9-a049-455b9e2903dc','2025-12-16 15:48:35',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-2096521252-dep_1-b6wqywoen3tc','7ce7898f-841d-4bc9-a049-455b9e2903dc','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1264,'1c47a973-85ab-4e9f-82ba-e12a0fe4918c','db65656d-9c00-4c7d-854e-30cf1bd7d01a','2025-12-16 15:48:35',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-2096521252-dep_0-azwr43qlug65','db65656d-9c00-4c7d-854e-30cf1bd7d01a','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1265,'e1f0a113-d993-46c7-8ac0-e245003cf0f4','31bad9da-4fc9-4936-ba1b-a18c0cf56383','2025-12-16 15:48:35',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-2096521252-dep_2-wh2k2orfjp55','31bad9da-4fc9-4936-ba1b-a18c0cf56383','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1266,'1ff3f537-ec1f-4fb3-b03a-8788421a3306','db65656d-9c00-4c7d-854e-30cf1bd7d01a','2025-12-16 15:48:35',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-2096521252-dep_0-azwr43qlug65-0-tbjczfdqvd6q','state changed','OS::Heat::SoftwareDeployment',NULL,214),(1267,'bb89ad0e-8a8f-4758-811a-2a3b83285da7','7ce7898f-841d-4bc9-a049-455b9e2903dc','2025-12-16 15:48:35',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-2096521252-dep_1-b6wqywoen3tc-0-aofizc2zi3qf','state changed','OS::Heat::SoftwareDeployment',NULL,215),(1268,'b055ac87-689f-4e27-bcb8-aa2c4fbac3be','31bad9da-4fc9-4936-ba1b-a18c0cf56383','2025-12-16 15:48:35',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-2096521252-dep_2-wh2k2orfjp55-0-yj53yss7ri3c','state changed','OS::Heat::SoftwareDeployment',NULL,216),(1269,'16ef67b5-5f22-4a1d-89ff-ecb25d77a72c','a6db82eb-2271-48a6-99b2-618a93847934','2025-12-16 15:48:37',NULL,'UPDATE','IN_PROGRESS','add_subnet','a6db82eb-2271-48a6-99b2-618a93847934','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1270,'a6f0fb87-cf06-4165-8745-f3a4b3da1cfe','a6db82eb-2271-48a6-99b2-618a93847934','2025-12-16 15:48:38',NULL,'UPDATE','IN_PROGRESS','server','6f241b9f-7e5d-4516-a8a2-9cb1b3121eec','state changed','OS::Nova::Server',NULL,204),(1271,'cd8fcd0c-a143-45e8-994e-24bb15fac145','a6db82eb-2271-48a6-99b2-618a93847934','2025-12-16 15:48:41',NULL,'UPDATE','COMPLETE','server','6f241b9f-7e5d-4516-a8a2-9cb1b3121eec','state changed','OS::Nova::Server',NULL,217),(1272,'f9bee6ce-3be5-4a94-8f6c-42b1d8d48521','a6db82eb-2271-48a6-99b2-618a93847934','2025-12-16 15:48:41',NULL,'UPDATE','COMPLETE','add_subnet','a6db82eb-2271-48a6-99b2-618a93847934','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1273,'936afe6c-fb2b-420c-9c02-1e1c2537e3e5','a6db82eb-2271-48a6-99b2-618a93847934','2025-12-16 15:48:50',NULL,'DELETE','IN_PROGRESS','add_subnet','a6db82eb-2271-48a6-99b2-618a93847934','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1274,'73a5ae2d-d694-45d8-989a-08135705dbcc','a6db82eb-2271-48a6-99b2-618a93847934','2025-12-16 15:48:51',NULL,'DELETE','IN_PROGRESS','server','6f241b9f-7e5d-4516-a8a2-9cb1b3121eec','state changed','OS::Nova::Server',NULL,217),(1275,'e9587bbe-23c8-4acb-8cc6-9b17834ea67a','a6db82eb-2271-48a6-99b2-618a93847934','2025-12-16 15:48:54',NULL,'DELETE','COMPLETE','server','6f241b9f-7e5d-4516-a8a2-9cb1b3121eec','state changed','OS::Nova::Server',NULL,217),(1276,'2d225055-3c0e-48c3-8145-16d703204768','a6db82eb-2271-48a6-99b2-618a93847934','2025-12-16 15:48:54',NULL,'DELETE','IN_PROGRESS','subnet','50b03234-1f80-4dd2-b1dd-e0e4ce4c7eaa','state changed','OS::Neutron::Subnet',NULL,203),(1277,'9c84327f-4e02-4ba9-b424-2a938722fad9','a6db82eb-2271-48a6-99b2-618a93847934','2025-12-16 15:48:54',NULL,'DELETE','COMPLETE','subnet','50b03234-1f80-4dd2-b1dd-e0e4ce4c7eaa','state changed','OS::Neutron::Subnet',NULL,203),(1278,'deef5f84-a129-4460-a0fd-cf433f25f4b4','a6db82eb-2271-48a6-99b2-618a93847934','2025-12-16 15:48:54',NULL,'DELETE','IN_PROGRESS','net','f0043a08-afd4-4678-8421-44da438726fe','state changed','OS::Neutron::Net',NULL,202),(1279,'17433323-28b4-47dc-b0e0-7202bcfe2800','a6db82eb-2271-48a6-99b2-618a93847934','2025-12-16 15:48:55',NULL,'DELETE','COMPLETE','net','f0043a08-afd4-4678-8421-44da438726fe','state changed','OS::Neutron::Net',NULL,202),(1280,'17b8bd24-46be-44e4-9b0e-327703bc13f0','a6db82eb-2271-48a6-99b2-618a93847934','2025-12-16 15:48:55',NULL,'DELETE','COMPLETE','add_subnet','a6db82eb-2271-48a6-99b2-618a93847934','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1281,'e6a85961-03d8-4aae-a27e-e1e2e3b1e4fd','9c28d729-435a-4134-98b0-9ebc654292a3','2025-12-16 15:49:01',NULL,'CREATE','IN_PROGRESS','multi_networks_swaps','9c28d729-435a-4134-98b0-9ebc654292a3','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1282,'63c691b0-948c-42fa-a0cc-549fc84986e0','9c28d729-435a-4134-98b0-9ebc654292a3','2025-12-16 15:49:01',NULL,'CREATE','IN_PROGRESS','net','multi_networks_swaps-net-dwbkgugne7n4','state changed','OS::Neutron::Net',NULL,219),(1283,'fca3aea1-3b98-4e66-867c-8ae289d5a881','9c28d729-435a-4134-98b0-9ebc654292a3','2025-12-16 15:49:02',NULL,'CREATE','COMPLETE','net','c3ff3bcd-bdf9-43e0-81e4-483c30d44f37','state changed','OS::Neutron::Net',NULL,219),(1284,'853dd479-4bd9-4271-b4da-48f9c63b7fee','9c28d729-435a-4134-98b0-9ebc654292a3','2025-12-16 15:49:02',NULL,'CREATE','IN_PROGRESS','subnet','multi_networks_swaps-subnet-dlkhjfdrcyqg','state changed','OS::Neutron::Subnet',NULL,220),(1285,'a1678f15-f0ce-41b6-b09f-abf28ec1c5cc','9c28d729-435a-4134-98b0-9ebc654292a3','2025-12-16 15:49:04',NULL,'CREATE','COMPLETE','subnet','8b4acda8-764f-427b-8461-f7a41f38ecb9','state changed','OS::Neutron::Subnet',NULL,220),(1286,'5cf9aaa1-060d-49a6-8836-d328994a4820','9c28d729-435a-4134-98b0-9ebc654292a3','2025-12-16 15:49:04',NULL,'CREATE','IN_PROGRESS','server','multi_networks_swaps-server-d42cl57ho7fz','state changed','OS::Nova::Server',NULL,221),(1287,'7bdde54c-59ed-4e60-abe4-70be991696f7','9c28d729-435a-4134-98b0-9ebc654292a3','2025-12-16 15:49:32',NULL,'CREATE','COMPLETE','server','aceffe96-ac33-4ff4-a5df-d107cd42cc5f','state changed','OS::Nova::Server',NULL,221),(1288,'50535a39-a245-447d-ac82-f6213b0f17e3','9c28d729-435a-4134-98b0-9ebc654292a3','2025-12-16 15:49:32',NULL,'CREATE','COMPLETE','multi_networks_swaps','9c28d729-435a-4134-98b0-9ebc654292a3','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1289,'7bf8c72e-7804-47cd-9fa1-687eab353e3d','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','2025-12-16 15:49:35',NULL,'CREATE','FAILED','dep_0','db65656d-9c00-4c7d-854e-30cf1bd7d01a','CREATE aborted (Task create from SoftwareDeployments \"dep_0\" Stack \"ParallelDeploymentsTest-2096521252\" [32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c] Timed out)','OS::Heat::SoftwareDeployments',NULL,211),(1290,'e5792a52-8091-4695-8e22-b471eb45c740','db65656d-9c00-4c7d-854e-30cf1bd7d01a','2025-12-16 15:49:35',NULL,'CREATE','FAILED','ParallelDeploymentsTest-2096521252-dep_0-azwr43qlug65','db65656d-9c00-4c7d-854e-30cf1bd7d01a','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1291,'84e72dbe-5061-42ac-a746-ce7ab8032159','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','2025-12-16 15:49:35',NULL,'CREATE','FAILED','dep_1','7ce7898f-841d-4bc9-a049-455b9e2903dc','CREATE aborted (Task create from SoftwareDeployments \"dep_1\" Stack \"ParallelDeploymentsTest-2096521252\" [32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c] Timed out)','OS::Heat::SoftwareDeployments',NULL,210),(1292,'1a8b804c-2746-436c-9dde-19aeb0472aa7','7ce7898f-841d-4bc9-a049-455b9e2903dc','2025-12-16 15:49:35',NULL,'CREATE','FAILED','ParallelDeploymentsTest-2096521252-dep_1-b6wqywoen3tc','7ce7898f-841d-4bc9-a049-455b9e2903dc','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1293,'28c0a5b5-843a-4167-9154-2d97deee34dd','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','2025-12-16 15:49:35',NULL,'CREATE','FAILED','ParallelDeploymentsTest-2096521252','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','Timed out','OS::Heat::Stack',NULL,NULL),(1294,'172c106c-4bf9-45e9-8ff5-c555c8a2a144','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','2025-12-16 15:49:35',NULL,'CREATE','FAILED','ParallelDeploymentsTest-2096521252','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','Timed out','OS::Heat::Stack',NULL,NULL),(1295,'74e26a67-b497-4a57-955c-57572b38337f','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','2025-12-16 15:49:35',NULL,'CREATE','FAILED','dep_2','31bad9da-4fc9-4936-ba1b-a18c0cf56383','CREATE aborted (Task create from SoftwareDeployments \"dep_2\" Stack \"ParallelDeploymentsTest-2096521252\" [32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c] Timed out)','OS::Heat::SoftwareDeployments',NULL,212),(1296,'f85a786a-fc5a-482c-b6d0-28a875a1fba8','31bad9da-4fc9-4936-ba1b-a18c0cf56383','2025-12-16 15:49:35',NULL,'CREATE','FAILED','ParallelDeploymentsTest-2096521252-dep_2-wh2k2orfjp55','31bad9da-4fc9-4936-ba1b-a18c0cf56383','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1297,'920f3f55-8738-4159-8c1a-b03f1f9cb2bb','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','2025-12-16 15:49:35',NULL,'CREATE','FAILED','ParallelDeploymentsTest-2096521252','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','Timed out','OS::Heat::Stack',NULL,NULL),(1298,'39473ef5-a1f5-4964-98fe-aafd85ab6dbd','31bad9da-4fc9-4936-ba1b-a18c0cf56383','2025-12-16 15:49:35',NULL,'CREATE','FAILED','0','08522852-b513-48aa-a5f3-7b93c1575294','CREATE aborted (Task create from SoftwareDeployment \"0\" Stack \"ParallelDeploymentsTest-2096521252-dep_2-wh2k2orfjp55\" [31bad9da-4fc9-4936-ba1b-a18c0cf56383] Timed out)','OS::Heat::SoftwareDeployment',NULL,216),(1299,'3deff716-d8fa-434f-abc0-935a0de406d8','31bad9da-4fc9-4936-ba1b-a18c0cf56383','2025-12-16 15:49:35',NULL,'CREATE','FAILED','ParallelDeploymentsTest-2096521252-dep_2-wh2k2orfjp55','31bad9da-4fc9-4936-ba1b-a18c0cf56383','Timed out','OS::Heat::Stack',NULL,NULL),(1300,'e8875357-96e2-4720-a70b-fc23136f6b4b','db65656d-9c00-4c7d-854e-30cf1bd7d01a','2025-12-16 15:49:35',NULL,'CREATE','FAILED','0','09a65f93-5a27-4a37-8fd3-2bc6d3868be2','CREATE aborted (Task create from SoftwareDeployment \"0\" Stack \"ParallelDeploymentsTest-2096521252-dep_0-azwr43qlug65\" [db65656d-9c00-4c7d-854e-30cf1bd7d01a] Timed out)','OS::Heat::SoftwareDeployment',NULL,214),(1301,'25dd7b3d-104e-4280-a1df-a0c075054b02','db65656d-9c00-4c7d-854e-30cf1bd7d01a','2025-12-16 15:49:35',NULL,'CREATE','FAILED','ParallelDeploymentsTest-2096521252-dep_0-azwr43qlug65','db65656d-9c00-4c7d-854e-30cf1bd7d01a','Timed out','OS::Heat::Stack',NULL,NULL),(1302,'c650aa93-f82e-4f58-8815-e4b7d7fc1589','7ce7898f-841d-4bc9-a049-455b9e2903dc','2025-12-16 15:49:36',NULL,'CREATE','FAILED','0','582d6db0-00f7-4d26-92f2-bee8e942a244','CREATE aborted (Task create from SoftwareDeployment \"0\" Stack \"ParallelDeploymentsTest-2096521252-dep_1-b6wqywoen3tc\" [7ce7898f-841d-4bc9-a049-455b9e2903dc] Timed out)','OS::Heat::SoftwareDeployment',NULL,215),(1303,'4bafa7b5-128f-4c7e-aabe-db367c1c3d91','7ce7898f-841d-4bc9-a049-455b9e2903dc','2025-12-16 15:49:36',NULL,'CREATE','FAILED','ParallelDeploymentsTest-2096521252-dep_1-b6wqywoen3tc','7ce7898f-841d-4bc9-a049-455b9e2903dc','Timed out','OS::Heat::Stack',NULL,NULL),(1304,'19d4838c-b1d0-4842-91eb-1956de9c4815','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','2025-12-16 15:49:36',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-2096521252','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1305,'cfc526a4-6cb0-4d98-9335-eb4acf7c18e0','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','2025-12-16 15:49:37',NULL,'DELETE','IN_PROGRESS','dep_0','db65656d-9c00-4c7d-854e-30cf1bd7d01a','state changed','OS::Heat::SoftwareDeployments',NULL,211),(1306,'76f007fe-e724-45e4-8da9-6c76b85895d6','db65656d-9c00-4c7d-854e-30cf1bd7d01a','2025-12-16 15:49:37',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-2096521252-dep_0-azwr43qlug65','db65656d-9c00-4c7d-854e-30cf1bd7d01a','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1307,'b8ea93e5-fff2-46ca-b31c-1c1c0d65c0c9','db65656d-9c00-4c7d-854e-30cf1bd7d01a','2025-12-16 15:49:38',NULL,'DELETE','IN_PROGRESS','0','09a65f93-5a27-4a37-8fd3-2bc6d3868be2','state changed','OS::Heat::SoftwareDeployment',NULL,214),(1308,'fc9b0a2f-df69-41b7-8b0c-97c311664658','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','2025-12-16 15:49:38',NULL,'DELETE','IN_PROGRESS','dep_2','31bad9da-4fc9-4936-ba1b-a18c0cf56383','state changed','OS::Heat::SoftwareDeployments',NULL,212),(1309,'2a5fba11-bc06-4dfd-9edd-0b79763b9efe','31bad9da-4fc9-4936-ba1b-a18c0cf56383','2025-12-16 15:49:38',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-2096521252-dep_2-wh2k2orfjp55','31bad9da-4fc9-4936-ba1b-a18c0cf56383','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1310,'0b0b429e-5d64-4c9a-a114-add8f128650d','31bad9da-4fc9-4936-ba1b-a18c0cf56383','2025-12-16 15:49:38',NULL,'DELETE','IN_PROGRESS','0','08522852-b513-48aa-a5f3-7b93c1575294','state changed','OS::Heat::SoftwareDeployment',NULL,216),(1311,'0a85f74a-9568-4742-b6d4-eaa7af05ed96','db65656d-9c00-4c7d-854e-30cf1bd7d01a','2025-12-16 15:49:38',NULL,'DELETE','COMPLETE','0','09a65f93-5a27-4a37-8fd3-2bc6d3868be2','state changed','OS::Heat::SoftwareDeployment',NULL,214),(1312,'18b3c6d2-f3e7-478d-bfcf-1944a7319acb','db65656d-9c00-4c7d-854e-30cf1bd7d01a','2025-12-16 15:49:38',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-2096521252-dep_0-azwr43qlug65','db65656d-9c00-4c7d-854e-30cf1bd7d01a','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1313,'4d58f01c-041f-4c89-981d-b4ff21c0fbf7','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','2025-12-16 15:49:39',NULL,'DELETE','IN_PROGRESS','dep_1','7ce7898f-841d-4bc9-a049-455b9e2903dc','state changed','OS::Heat::SoftwareDeployments',NULL,210),(1314,'8430e715-fecb-4918-a0f0-465f57e8b42b','7ce7898f-841d-4bc9-a049-455b9e2903dc','2025-12-16 15:49:39',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-2096521252-dep_1-b6wqywoen3tc','7ce7898f-841d-4bc9-a049-455b9e2903dc','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1315,'ac36a363-b782-4b35-8f59-5b5943727f12','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','2025-12-16 15:49:39',NULL,'DELETE','COMPLETE','dep_0','db65656d-9c00-4c7d-854e-30cf1bd7d01a','state changed','OS::Heat::SoftwareDeployments',NULL,211),(1316,'0ee46a85-9f31-4483-94c8-7fe5f086fdee','7ce7898f-841d-4bc9-a049-455b9e2903dc','2025-12-16 15:49:39',NULL,'DELETE','IN_PROGRESS','0','582d6db0-00f7-4d26-92f2-bee8e942a244','state changed','OS::Heat::SoftwareDeployment',NULL,215),(1317,'4cfb1e35-c93e-4aa8-85ad-b18391258200','31bad9da-4fc9-4936-ba1b-a18c0cf56383','2025-12-16 15:49:39',NULL,'DELETE','COMPLETE','0','08522852-b513-48aa-a5f3-7b93c1575294','state changed','OS::Heat::SoftwareDeployment',NULL,216),(1318,'04377de4-92da-4905-b28b-abb6b2f6e3d6','31bad9da-4fc9-4936-ba1b-a18c0cf56383','2025-12-16 15:49:39',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-2096521252-dep_2-wh2k2orfjp55','31bad9da-4fc9-4936-ba1b-a18c0cf56383','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1319,'7d712713-3ca9-42ad-b328-d971f6f7b6bc','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','2025-12-16 15:49:40',NULL,'DELETE','COMPLETE','dep_2','31bad9da-4fc9-4936-ba1b-a18c0cf56383','state changed','OS::Heat::SoftwareDeployments',NULL,212),(1320,'ace388af-dee8-4b19-a060-dd3d40099329','7ce7898f-841d-4bc9-a049-455b9e2903dc','2025-12-16 15:49:41',NULL,'DELETE','COMPLETE','0','582d6db0-00f7-4d26-92f2-bee8e942a244','state changed','OS::Heat::SoftwareDeployment',NULL,215),(1321,'cba22e8f-25ba-4c84-ac18-942b32251a00','9c28d729-435a-4134-98b0-9ebc654292a3','2025-12-16 15:49:41',NULL,'UPDATE','IN_PROGRESS','multi_networks_swaps','9c28d729-435a-4134-98b0-9ebc654292a3','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1322,'9bce924b-0261-4d81-870c-daf77cf37c1d','7ce7898f-841d-4bc9-a049-455b9e2903dc','2025-12-16 15:49:41',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-2096521252-dep_1-b6wqywoen3tc','7ce7898f-841d-4bc9-a049-455b9e2903dc','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1323,'7b66ad68-3ec1-41cd-b363-714d002d1434','9c28d729-435a-4134-98b0-9ebc654292a3','2025-12-16 15:49:42',NULL,'UPDATE','IN_PROGRESS','server','aceffe96-ac33-4ff4-a5df-d107cd42cc5f','state changed','OS::Nova::Server',NULL,221),(1324,'955cac41-9c26-4bb5-a5ce-a95fcab82708','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','2025-12-16 15:49:43',NULL,'DELETE','COMPLETE','dep_1','7ce7898f-841d-4bc9-a049-455b9e2903dc','state changed','OS::Heat::SoftwareDeployments',NULL,210),(1325,'58c25181-de64-44b9-afa9-7d3959175f57','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','2025-12-16 15:49:43',NULL,'DELETE','IN_PROGRESS','config','6967c451-f021-42cd-8651-7c7a654e2fc5','state changed','OS::Heat::SoftwareConfig',NULL,209),(1326,'26203926-dfe0-464d-bbb0-ba790c703267','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','2025-12-16 15:49:43',NULL,'DELETE','COMPLETE','config','6967c451-f021-42cd-8651-7c7a654e2fc5','state changed','OS::Heat::SoftwareConfig',NULL,209),(1327,'9b9a1e2a-09e1-4a14-b643-6849ce7fc476','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','2025-12-16 15:49:43',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-2096521252','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1328,'9dfca701-7d5b-40a9-b38c-82946c368080','9c28d729-435a-4134-98b0-9ebc654292a3','2025-12-16 15:49:46',NULL,'UPDATE','COMPLETE','server','aceffe96-ac33-4ff4-a5df-d107cd42cc5f','state changed','OS::Nova::Server',NULL,223),(1329,'b20b69e7-32fb-473c-ace6-7a43a1af360d','4d7ea472-c5cf-4020-8a45-9f4b818927f7','2025-12-16 15:49:46',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-305141961','4d7ea472-c5cf-4020-8a45-9f4b818927f7','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1330,'3cd75252-8b3c-4347-903c-9f9bb583386d','9c28d729-435a-4134-98b0-9ebc654292a3','2025-12-16 15:49:46',NULL,'UPDATE','COMPLETE','multi_networks_swaps','9c28d729-435a-4134-98b0-9ebc654292a3','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1331,'b56adb20-f16d-45cd-baff-53706019d2bb','4d7ea472-c5cf-4020-8a45-9f4b818927f7','2025-12-16 15:49:46',NULL,'DELETE','IN_PROGRESS','server','1b2ae6fb-2f83-44b7-a283-cc4cec490f5f','state changed','OS::Nova::Server',NULL,205),(1332,'45b3a476-1855-4141-8da3-215f43554ff7','4d7ea472-c5cf-4020-8a45-9f4b818927f7','2025-12-16 15:49:52',NULL,'DELETE','COMPLETE','server','1b2ae6fb-2f83-44b7-a283-cc4cec490f5f','state changed','OS::Nova::Server',NULL,205),(1333,'716e8ee6-dc97-4300-8cbc-82b74ef004d7','4d7ea472-c5cf-4020-8a45-9f4b818927f7','2025-12-16 15:49:52',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-305141961','4d7ea472-c5cf-4020-8a45-9f4b818927f7','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1334,'706f4ecf-7fe8-4a51-b23e-f55e8ed73a2f','9c28d729-435a-4134-98b0-9ebc654292a3','2025-12-16 15:49:54',NULL,'DELETE','IN_PROGRESS','multi_networks_swaps','9c28d729-435a-4134-98b0-9ebc654292a3','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1335,'18185d65-3402-4cf0-8602-ce57af3a4978','9c28d729-435a-4134-98b0-9ebc654292a3','2025-12-16 15:49:54',NULL,'DELETE','IN_PROGRESS','server','aceffe96-ac33-4ff4-a5df-d107cd42cc5f','state changed','OS::Nova::Server',NULL,223),(1336,'d1254255-7641-47b0-92c9-9b274b401505','b97f8228-df37-4ef0-92f2-a5b9dd50b5f8','2025-12-16 15:49:57',NULL,'CREATE','IN_PROGRESS','TemplateAPITest-1727151759','b97f8228-df37-4ef0-92f2-a5b9dd50b5f8','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1337,'aa411877-fbbb-4ba8-b8da-f0478b6827b8','b97f8228-df37-4ef0-92f2-a5b9dd50b5f8','2025-12-16 15:49:57',NULL,'CREATE','IN_PROGRESS','test1','TemplateAPITest-1727151759-test1-r6e53aqkbk25','state changed','OS::Heat::TestResource',NULL,225),(1338,'79855018-968b-4ed7-95e3-990dfce9e9d0','b97f8228-df37-4ef0-92f2-a5b9dd50b5f8','2025-12-16 15:49:57',NULL,'CREATE','COMPLETE','test1','TemplateAPITest-1727151759-test1-r6e53aqkbk25','state changed','OS::Heat::TestResource',NULL,225),(1339,'9f511324-5e8c-4dc4-9a71-6415e019310d','b97f8228-df37-4ef0-92f2-a5b9dd50b5f8','2025-12-16 15:49:57',NULL,'CREATE','COMPLETE','TemplateAPITest-1727151759','b97f8228-df37-4ef0-92f2-a5b9dd50b5f8','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1340,'3685be14-6325-476e-b91b-cc2bd15d3a84','b97f8228-df37-4ef0-92f2-a5b9dd50b5f8','2025-12-16 15:49:57',NULL,'DELETE','IN_PROGRESS','TemplateAPITest-1727151759','b97f8228-df37-4ef0-92f2-a5b9dd50b5f8','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1341,'b2804388-79ba-43ae-af70-cb5fbe53ed28','b97f8228-df37-4ef0-92f2-a5b9dd50b5f8','2025-12-16 15:49:57',NULL,'DELETE','IN_PROGRESS','test1','TemplateAPITest-1727151759-test1-r6e53aqkbk25','state changed','OS::Heat::TestResource',NULL,225),(1342,'e26bf319-7375-4bd2-b356-180ac71dc4e0','b97f8228-df37-4ef0-92f2-a5b9dd50b5f8','2025-12-16 15:49:57',NULL,'DELETE','COMPLETE','test1','TemplateAPITest-1727151759-test1-r6e53aqkbk25','state changed','OS::Heat::TestResource',NULL,225),(1343,'17820c8c-18d7-4015-b3de-e85131e936db','b97f8228-df37-4ef0-92f2-a5b9dd50b5f8','2025-12-16 15:49:57',NULL,'DELETE','COMPLETE','TemplateAPITest-1727151759','b97f8228-df37-4ef0-92f2-a5b9dd50b5f8','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1344,'96ca22f3-4c71-4dfd-88c4-e50e50c84d29','9c28d729-435a-4134-98b0-9ebc654292a3','2025-12-16 15:50:02',NULL,'DELETE','COMPLETE','server','aceffe96-ac33-4ff4-a5df-d107cd42cc5f','state changed','OS::Nova::Server',NULL,223),(1345,'c5fa77d4-b443-40bd-9394-ff79213bbf84','9c28d729-435a-4134-98b0-9ebc654292a3','2025-12-16 15:50:02',NULL,'DELETE','IN_PROGRESS','subnet','8b4acda8-764f-427b-8461-f7a41f38ecb9','state changed','OS::Neutron::Subnet',NULL,220),(1346,'12b17314-8ce2-488b-8764-f662e6712747','9c28d729-435a-4134-98b0-9ebc654292a3','2025-12-16 15:50:02',NULL,'DELETE','COMPLETE','subnet','8b4acda8-764f-427b-8461-f7a41f38ecb9','state changed','OS::Neutron::Subnet',NULL,220),(1347,'9244a30e-ab77-48a5-a329-90d414a022a9','9c28d729-435a-4134-98b0-9ebc654292a3','2025-12-16 15:50:02',NULL,'DELETE','IN_PROGRESS','net','c3ff3bcd-bdf9-43e0-81e4-483c30d44f37','state changed','OS::Neutron::Net',NULL,219),(1348,'268f1134-efe7-4b52-86d4-aba1c2c60bee','9c28d729-435a-4134-98b0-9ebc654292a3','2025-12-16 15:50:03',NULL,'DELETE','COMPLETE','net','c3ff3bcd-bdf9-43e0-81e4-483c30d44f37','state changed','OS::Neutron::Net',NULL,219),(1349,'9ef1355b-a8b1-4f6a-9268-9b6036f15e23','9c28d729-435a-4134-98b0-9ebc654292a3','2025-12-16 15:50:03',NULL,'DELETE','COMPLETE','multi_networks_swaps','9c28d729-435a-4134-98b0-9ebc654292a3','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1350,'50ab5cf6-fb09-4346-aec2-1841ce443163','5c1d20bd-04c3-4cf6-8ce7-4e77b46c6511','2025-12-16 15:50:05',NULL,'CREATE','IN_PROGRESS','RemoteDeeplyNestedStackTest-508630137','5c1d20bd-04c3-4cf6-8ce7-4e77b46c6511','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1351,'612aea5d-7b66-467d-a3f2-d9699b16498a','5c1d20bd-04c3-4cf6-8ce7-4e77b46c6511','2025-12-16 15:50:06',NULL,'CREATE','IN_PROGRESS','network_stack','RemoteDeeplyNestedStackTest-508630137-network_stack-ofw6sbnpv463','state changed','OS::Heat::Stack',NULL,226),(1352,'778e22f5-8a54-442f-9174-6169055657cd','83948b1f-e809-4cf7-9d27-fb14fabacae6','2025-12-16 15:50:07',NULL,'CREATE','IN_PROGRESS','RemoteDeeplyNestedStackTest-508630137-network_stack-ofw6sbnpv463','83948b1f-e809-4cf7-9d27-fb14fabacae6','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1353,'c32c05bf-92d6-4947-ae39-1a893477c785','83948b1f-e809-4cf7-9d27-fb14fabacae6','2025-12-16 15:50:07',NULL,'CREATE','IN_PROGRESS','network_stack_as_custom_type','RemoteDeeplyNestedStackTest-508630137-network_stack-ofw6sbnpv463-network_stack_as_custom_type-pzasodfxerv4','state changed','file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml',NULL,227),(1354,'e4145ff2-6e9d-40db-828e-87f242e6677f','f617316a-b411-4e5b-82bf-9a4b725744c1','2025-12-16 15:50:08',NULL,'CREATE','IN_PROGRESS','RemoteDeeplyNestedStackTest-508630137-network_stack-ofw6sbnpv463-network_stack_as_custom_type-pzasodfxerv4','f617316a-b411-4e5b-82bf-9a4b725744c1','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1355,'d5d75396-cd22-4aa8-a538-9f104d22df1c','f617316a-b411-4e5b-82bf-9a4b725744c1','2025-12-16 15:50:08',NULL,'CREATE','IN_PROGRESS','router','RemoteDeeplyNestedStackTest-508630137-network_stack-ofw6sbnpv463-network_stack_as_custom_type-pzasodfxerv4-router-c7vky4botk2a','state changed','OS::Neutron::Router',NULL,228),(1356,'057dff1a-10d7-497e-a2c3-1ef4d01a8242','6cba10af-327d-4759-8fc6-bb51c95440ac','2025-12-16 15:50:09',NULL,'CREATE','IN_PROGRESS','swap_network_port','6cba10af-327d-4759-8fc6-bb51c95440ac','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1357,'b14026ad-e482-49d1-af83-201dc5c1686d','6cba10af-327d-4759-8fc6-bb51c95440ac','2025-12-16 15:50:09',NULL,'CREATE','IN_PROGRESS','net','swap_network_port-net-m4lkp3ockwxn','state changed','OS::Neutron::Net',NULL,229),(1358,'076fd527-cc37-4628-8451-9f36b301842d','f617316a-b411-4e5b-82bf-9a4b725744c1','2025-12-16 15:50:11',NULL,'CREATE','COMPLETE','router','1183906a-a99b-4516-9e5c-cc6aefa3f32c','state changed','OS::Neutron::Router',NULL,228),(1359,'2ea22e10-a795-4dee-8303-b53c87c95eae','f617316a-b411-4e5b-82bf-9a4b725744c1','2025-12-16 15:50:11',NULL,'CREATE','COMPLETE','RemoteDeeplyNestedStackTest-508630137-network_stack-ofw6sbnpv463-network_stack_as_custom_type-pzasodfxerv4','f617316a-b411-4e5b-82bf-9a4b725744c1','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1360,'e2e81e73-1456-4a91-8395-7d47d9289b32','83948b1f-e809-4cf7-9d27-fb14fabacae6','2025-12-16 15:50:11',NULL,'CREATE','COMPLETE','network_stack_as_custom_type','f617316a-b411-4e5b-82bf-9a4b725744c1','state changed','file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml',NULL,227),(1361,'d0b541b0-8945-48da-a2fa-9aefbb35ccea','83948b1f-e809-4cf7-9d27-fb14fabacae6','2025-12-16 15:50:11',NULL,'CREATE','COMPLETE','RemoteDeeplyNestedStackTest-508630137-network_stack-ofw6sbnpv463','83948b1f-e809-4cf7-9d27-fb14fabacae6','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1362,'4bfa18bc-5417-4f60-9ea4-81ef7ecfa25c','6cba10af-327d-4759-8fc6-bb51c95440ac','2025-12-16 15:50:11',NULL,'CREATE','COMPLETE','net','9cd91509-ea97-4436-87a4-2f533f7f8645','state changed','OS::Neutron::Net',NULL,229),(1363,'74713eb2-0464-44e7-938d-2b1daa37c692','6cba10af-327d-4759-8fc6-bb51c95440ac','2025-12-16 15:50:11',NULL,'CREATE','IN_PROGRESS','subnet','swap_network_port-subnet-j4qwyq3dvyqp','state changed','OS::Neutron::Subnet',NULL,230),(1364,'f03f4453-fffd-402b-afe7-4542419a3f05','5c1d20bd-04c3-4cf6-8ce7-4e77b46c6511','2025-12-16 15:50:12',NULL,'CREATE','COMPLETE','network_stack','83948b1f-e809-4cf7-9d27-fb14fabacae6','state changed','OS::Heat::Stack',NULL,226),(1365,'5f888d32-25f3-4f7c-b33d-881b13b901e2','5c1d20bd-04c3-4cf6-8ce7-4e77b46c6511','2025-12-16 15:50:12',NULL,'CREATE','COMPLETE','RemoteDeeplyNestedStackTest-508630137','5c1d20bd-04c3-4cf6-8ce7-4e77b46c6511','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1366,'4d826e17-e86c-4499-aca8-6e1b02e6d786','6cba10af-327d-4759-8fc6-bb51c95440ac','2025-12-16 15:50:13',NULL,'CREATE','COMPLETE','subnet','301752fa-6b09-489a-a386-2aba027d9bbd','state changed','OS::Neutron::Subnet',NULL,230),(1367,'0b36d5cf-8b66-4094-bd45-ab5bd3cdebe0','6cba10af-327d-4759-8fc6-bb51c95440ac','2025-12-16 15:50:13',NULL,'CREATE','IN_PROGRESS','server','swap_network_port-server-4qxkdhnjeeyz','state changed','OS::Nova::Server',NULL,232),(1368,'f6db6256-58f6-4884-bc21-aca79f6291e2','5c1d20bd-04c3-4cf6-8ce7-4e77b46c6511','2025-12-16 15:50:14',NULL,'DELETE','IN_PROGRESS','RemoteDeeplyNestedStackTest-508630137','5c1d20bd-04c3-4cf6-8ce7-4e77b46c6511','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1369,'ccfa19d7-e7b0-40fb-9c7f-e7153952e167','5c1d20bd-04c3-4cf6-8ce7-4e77b46c6511','2025-12-16 15:50:14',NULL,'DELETE','IN_PROGRESS','network_stack','83948b1f-e809-4cf7-9d27-fb14fabacae6','state changed','OS::Heat::Stack',NULL,226),(1370,'c815d664-98d7-4f14-92ba-f5ad73941e94','83948b1f-e809-4cf7-9d27-fb14fabacae6','2025-12-16 15:50:15',NULL,'DELETE','IN_PROGRESS','RemoteDeeplyNestedStackTest-508630137-network_stack-ofw6sbnpv463','83948b1f-e809-4cf7-9d27-fb14fabacae6','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1371,'be9a03f5-cc9a-49d2-ab7c-646a6cd617d4','83948b1f-e809-4cf7-9d27-fb14fabacae6','2025-12-16 15:50:15',NULL,'DELETE','IN_PROGRESS','network_stack_as_custom_type','f617316a-b411-4e5b-82bf-9a4b725744c1','state changed','file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml',NULL,227),(1372,'7cc61509-c888-4c2c-af87-d66a7ba5c34b','f617316a-b411-4e5b-82bf-9a4b725744c1','2025-12-16 15:50:15',NULL,'DELETE','IN_PROGRESS','RemoteDeeplyNestedStackTest-508630137-network_stack-ofw6sbnpv463-network_stack_as_custom_type-pzasodfxerv4','f617316a-b411-4e5b-82bf-9a4b725744c1','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1373,'18453272-96fb-4b55-87c7-15928f71c0c1','f617316a-b411-4e5b-82bf-9a4b725744c1','2025-12-16 15:50:15',NULL,'DELETE','IN_PROGRESS','router','1183906a-a99b-4516-9e5c-cc6aefa3f32c','state changed','OS::Neutron::Router',NULL,228),(1374,'f0d1f1cd-bc51-40d3-ad34-b1f06e7a7d13','f617316a-b411-4e5b-82bf-9a4b725744c1','2025-12-16 15:50:16',NULL,'DELETE','COMPLETE','router','1183906a-a99b-4516-9e5c-cc6aefa3f32c','state changed','OS::Neutron::Router',NULL,228),(1375,'a9ddb01c-c3fd-4cbb-acbd-af9874934f0f','f617316a-b411-4e5b-82bf-9a4b725744c1','2025-12-16 15:50:16',NULL,'DELETE','COMPLETE','RemoteDeeplyNestedStackTest-508630137-network_stack-ofw6sbnpv463-network_stack_as_custom_type-pzasodfxerv4','f617316a-b411-4e5b-82bf-9a4b725744c1','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1376,'6728e245-5fbd-407d-bb39-751a2fdf73ed','83948b1f-e809-4cf7-9d27-fb14fabacae6','2025-12-16 15:50:18',NULL,'DELETE','COMPLETE','network_stack_as_custom_type','f617316a-b411-4e5b-82bf-9a4b725744c1','state changed','file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml',NULL,227),(1377,'bf1bac5f-223d-44fb-b6e1-bc6bdd3a017c','83948b1f-e809-4cf7-9d27-fb14fabacae6','2025-12-16 15:50:19',NULL,'DELETE','COMPLETE','RemoteDeeplyNestedStackTest-508630137-network_stack-ofw6sbnpv463','83948b1f-e809-4cf7-9d27-fb14fabacae6','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1378,'380bd4de-3585-498a-af93-79fd9ab8f6a5','5c1d20bd-04c3-4cf6-8ce7-4e77b46c6511','2025-12-16 15:50:20',NULL,'DELETE','COMPLETE','network_stack','83948b1f-e809-4cf7-9d27-fb14fabacae6','state changed','OS::Heat::Stack',NULL,226),(1379,'b03c7353-7410-4a4c-856a-6130dbade71b','5c1d20bd-04c3-4cf6-8ce7-4e77b46c6511','2025-12-16 15:50:20',NULL,'DELETE','COMPLETE','RemoteDeeplyNestedStackTest-508630137','5c1d20bd-04c3-4cf6-8ce7-4e77b46c6511','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1380,'5a43fd20-a877-4246-9673-b5650b07ffc1','6cba10af-327d-4759-8fc6-bb51c95440ac','2025-12-16 15:50:28',NULL,'CREATE','COMPLETE','server','801b6935-2c14-408c-b594-ab825983bf7a','state changed','OS::Nova::Server',NULL,232),(1381,'7b83e8df-4997-46e0-b1b9-857b0eaa7ce1','6cba10af-327d-4759-8fc6-bb51c95440ac','2025-12-16 15:50:28',NULL,'CREATE','COMPLETE','swap_network_port','6cba10af-327d-4759-8fc6-bb51c95440ac','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1382,'79fbf138-40b2-4239-b83e-5486188022c6','6cba10af-327d-4759-8fc6-bb51c95440ac','2025-12-16 15:50:36',NULL,'UPDATE','IN_PROGRESS','swap_network_port','6cba10af-327d-4759-8fc6-bb51c95440ac','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1383,'48ffe013-36fe-477c-bc2d-24a34d05c5a4','6cba10af-327d-4759-8fc6-bb51c95440ac','2025-12-16 15:50:37',NULL,'UPDATE','IN_PROGRESS','server','801b6935-2c14-408c-b594-ab825983bf7a','state changed','OS::Nova::Server',NULL,232),(1384,'2240a944-9973-465d-87a5-e44d48092201','6cba10af-327d-4759-8fc6-bb51c95440ac','2025-12-16 15:50:40',NULL,'UPDATE','COMPLETE','server','801b6935-2c14-408c-b594-ab825983bf7a','state changed','OS::Nova::Server',NULL,235),(1385,'d641b2d5-bc90-4097-904f-7b4198c496a3','6cba10af-327d-4759-8fc6-bb51c95440ac','2025-12-16 15:50:40',NULL,'UPDATE','COMPLETE','swap_network_port','6cba10af-327d-4759-8fc6-bb51c95440ac','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1386,'e8da8967-4f4e-49c4-8383-4f95434021e6','6cba10af-327d-4759-8fc6-bb51c95440ac','2025-12-16 15:50:41',NULL,'DELETE','IN_PROGRESS','swap_network_port','6cba10af-327d-4759-8fc6-bb51c95440ac','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1387,'d2a7adce-7b12-4334-827f-f8015ba76850','6cba10af-327d-4759-8fc6-bb51c95440ac','2025-12-16 15:50:42',NULL,'DELETE','IN_PROGRESS','server','801b6935-2c14-408c-b594-ab825983bf7a','state changed','OS::Nova::Server',NULL,235),(1388,'b6cc9ea1-85d0-490d-b8a2-649825aa8941','6cba10af-327d-4759-8fc6-bb51c95440ac','2025-12-16 15:50:44',NULL,'DELETE','COMPLETE','server','801b6935-2c14-408c-b594-ab825983bf7a','state changed','OS::Nova::Server',NULL,235),(1389,'0fbf9642-74cf-4e4a-9a60-65be09b3bc09','6cba10af-327d-4759-8fc6-bb51c95440ac','2025-12-16 15:50:44',NULL,'DELETE','IN_PROGRESS','subnet','301752fa-6b09-489a-a386-2aba027d9bbd','state changed','OS::Neutron::Subnet',NULL,230),(1390,'78a8d64d-67eb-47a3-80d7-e878ae6077f4','6cba10af-327d-4759-8fc6-bb51c95440ac','2025-12-16 15:50:44',NULL,'DELETE','COMPLETE','subnet','301752fa-6b09-489a-a386-2aba027d9bbd','state changed','OS::Neutron::Subnet',NULL,230),(1391,'4f1808f8-53ae-4006-8478-5f30772774d7','6cba10af-327d-4759-8fc6-bb51c95440ac','2025-12-16 15:50:44',NULL,'DELETE','IN_PROGRESS','net','9cd91509-ea97-4436-87a4-2f533f7f8645','state changed','OS::Neutron::Net',NULL,229),(1392,'1e25936a-1b49-4c21-990a-e120a8487caf','6cba10af-327d-4759-8fc6-bb51c95440ac','2025-12-16 15:50:45',NULL,'DELETE','COMPLETE','net','9cd91509-ea97-4436-87a4-2f533f7f8645','state changed','OS::Neutron::Net',NULL,229),(1393,'7fb04bcc-a412-42e8-9c0c-e05bfee87112','6cba10af-327d-4759-8fc6-bb51c95440ac','2025-12-16 15:50:45',NULL,'DELETE','COMPLETE','swap_network_port','6cba10af-327d-4759-8fc6-bb51c95440ac','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1394,'755523f1-1b17-4aab-914a-dc1e402ca40f','077f54b0-6d90-44a3-8b30-79dba984ecf6','2025-12-16 15:50:48',NULL,'CREATE','IN_PROGRESS','swap_network_subnet','077f54b0-6d90-44a3-8b30-79dba984ecf6','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1395,'842aa8e5-f2e5-4f26-9cee-8cc2adc24169','077f54b0-6d90-44a3-8b30-79dba984ecf6','2025-12-16 15:50:50',NULL,'CREATE','IN_PROGRESS','net','swap_network_subnet-net-3honr7k2uvdo','state changed','OS::Neutron::Net',NULL,237),(1396,'1a5ed9f8-3425-424e-ae6e-bf2945b4c13d','077f54b0-6d90-44a3-8b30-79dba984ecf6','2025-12-16 15:50:52',NULL,'CREATE','COMPLETE','net','bf176080-a3d9-4ac0-b5a5-11f582703c71','state changed','OS::Neutron::Net',NULL,237),(1397,'91574ec4-5d7d-4ca1-af51-7a9b405a082f','077f54b0-6d90-44a3-8b30-79dba984ecf6','2025-12-16 15:50:52',NULL,'CREATE','IN_PROGRESS','subnet','swap_network_subnet-subnet-23ixxmphqczn','state changed','OS::Neutron::Subnet',NULL,238),(1398,'d3912c8a-7e04-419e-9ca9-9c3fb28784c3','077f54b0-6d90-44a3-8b30-79dba984ecf6','2025-12-16 15:50:54',NULL,'CREATE','COMPLETE','subnet','57c9b6c8-a043-4415-bec1-676a185df6cd','state changed','OS::Neutron::Subnet',NULL,238),(1399,'f69e3c22-af4b-4194-b7a9-78a2b1b2bd4c','077f54b0-6d90-44a3-8b30-79dba984ecf6','2025-12-16 15:50:54',NULL,'CREATE','IN_PROGRESS','server','swap_network_subnet-server-ravefb4e73uq','state changed','OS::Nova::Server',NULL,239),(1400,'79a7ac5a-1ba5-4932-a1bf-698f7d62c2f1','077f54b0-6d90-44a3-8b30-79dba984ecf6','2025-12-16 15:51:07',NULL,'CREATE','COMPLETE','server','d650029a-d506-49dc-a5cb-6886fdf8d129','state changed','OS::Nova::Server',NULL,239),(1401,'6e279f52-5bdd-4ce1-bb0a-d41f58f2c2ab','077f54b0-6d90-44a3-8b30-79dba984ecf6','2025-12-16 15:51:07',NULL,'CREATE','COMPLETE','swap_network_subnet','077f54b0-6d90-44a3-8b30-79dba984ecf6','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1402,'825a7085-7d09-4022-97a2-94de303eb9a2','077f54b0-6d90-44a3-8b30-79dba984ecf6','2025-12-16 15:51:11',NULL,'UPDATE','IN_PROGRESS','swap_network_subnet','077f54b0-6d90-44a3-8b30-79dba984ecf6','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1403,'a0455955-c2f7-49a6-85f0-eb21040dc1e4','077f54b0-6d90-44a3-8b30-79dba984ecf6','2025-12-16 15:51:11',NULL,'UPDATE','IN_PROGRESS','server','d650029a-d506-49dc-a5cb-6886fdf8d129','state changed','OS::Nova::Server',NULL,239),(1404,'ad6f86ef-5c7f-4a75-b3d1-74d566f574a2','077f54b0-6d90-44a3-8b30-79dba984ecf6','2025-12-16 15:51:15',NULL,'UPDATE','COMPLETE','server','d650029a-d506-49dc-a5cb-6886fdf8d129','state changed','OS::Nova::Server',NULL,241),(1405,'beb22304-4599-4f48-8af8-7ac17049c1ce','077f54b0-6d90-44a3-8b30-79dba984ecf6','2025-12-16 15:51:16',NULL,'UPDATE','COMPLETE','swap_network_subnet','077f54b0-6d90-44a3-8b30-79dba984ecf6','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1406,'e52704fe-c49d-42a2-906b-8fa9385ac0ec','077f54b0-6d90-44a3-8b30-79dba984ecf6','2025-12-16 15:51:23',NULL,'DELETE','IN_PROGRESS','swap_network_subnet','077f54b0-6d90-44a3-8b30-79dba984ecf6','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1407,'52e53cd1-9f3f-467e-a7e7-7f5439b8ab51','077f54b0-6d90-44a3-8b30-79dba984ecf6','2025-12-16 15:51:23',NULL,'DELETE','IN_PROGRESS','server','d650029a-d506-49dc-a5cb-6886fdf8d129','state changed','OS::Nova::Server',NULL,241),(1408,'223989a8-135f-4341-bb57-fdebba35c8f3','077f54b0-6d90-44a3-8b30-79dba984ecf6','2025-12-16 15:51:25',NULL,'DELETE','COMPLETE','server','d650029a-d506-49dc-a5cb-6886fdf8d129','state changed','OS::Nova::Server',NULL,241),(1409,'7e15df43-6e5e-4a79-9122-9464ae0f7a45','077f54b0-6d90-44a3-8b30-79dba984ecf6','2025-12-16 15:51:25',NULL,'DELETE','IN_PROGRESS','subnet','57c9b6c8-a043-4415-bec1-676a185df6cd','state changed','OS::Neutron::Subnet',NULL,238),(1410,'ce24046b-bd52-4aaf-9736-e4e916386b5f','077f54b0-6d90-44a3-8b30-79dba984ecf6','2025-12-16 15:51:25',NULL,'DELETE','COMPLETE','subnet','57c9b6c8-a043-4415-bec1-676a185df6cd','state changed','OS::Neutron::Subnet',NULL,238),(1411,'6fa7b2c9-bc81-4b83-9516-a71c68f5c513','077f54b0-6d90-44a3-8b30-79dba984ecf6','2025-12-16 15:51:25',NULL,'DELETE','IN_PROGRESS','net','bf176080-a3d9-4ac0-b5a5-11f582703c71','state changed','OS::Neutron::Net',NULL,237),(1412,'35167158-276d-43b9-81f0-3aa8ef1a5b8c','077f54b0-6d90-44a3-8b30-79dba984ecf6','2025-12-16 15:51:26',NULL,'DELETE','COMPLETE','net','bf176080-a3d9-4ac0-b5a5-11f582703c71','state changed','OS::Neutron::Net',NULL,237),(1413,'0f8dc53c-6273-4404-b459-87a060ec6f45','077f54b0-6d90-44a3-8b30-79dba984ecf6','2025-12-16 15:51:26',NULL,'DELETE','COMPLETE','swap_network_subnet','077f54b0-6d90-44a3-8b30-79dba984ecf6','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1414,'af0752e5-e6ae-4f47-8f1b-b622285cc2b8','832db642-8498-4f68-bfb1-831831fbfa27','2025-12-16 15:51:37',NULL,'CREATE','IN_PROGRESS','swap_subnet_network','832db642-8498-4f68-bfb1-831831fbfa27','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1415,'abd657e8-7ca7-4587-90d0-1eff20c01a21','832db642-8498-4f68-bfb1-831831fbfa27','2025-12-16 15:51:37',NULL,'CREATE','IN_PROGRESS','net','swap_subnet_network-net-cel3ozvakirm','state changed','OS::Neutron::Net',NULL,243),(1416,'461e9bc5-e762-4823-bc8c-1cedfe47dfe1','832db642-8498-4f68-bfb1-831831fbfa27','2025-12-16 15:51:37',NULL,'CREATE','COMPLETE','net','6fbc67b3-e8bb-40e7-8269-7e09473fed7d','state changed','OS::Neutron::Net',NULL,243),(1417,'68918a3f-b57f-4fda-bb67-235d33fd9256','832db642-8498-4f68-bfb1-831831fbfa27','2025-12-16 15:51:38',NULL,'CREATE','IN_PROGRESS','subnet','swap_subnet_network-subnet-ncjq3pelknqk','state changed','OS::Neutron::Subnet',NULL,244),(1418,'321b2538-8b4e-404b-990d-d39e8a87187a','832db642-8498-4f68-bfb1-831831fbfa27','2025-12-16 15:51:39',NULL,'CREATE','COMPLETE','subnet','0ceca7ff-6710-48b2-ad32-4228a903d760','state changed','OS::Neutron::Subnet',NULL,244),(1419,'cfe409fd-00bf-4e5d-a24b-398ee22d3d84','832db642-8498-4f68-bfb1-831831fbfa27','2025-12-16 15:51:39',NULL,'CREATE','IN_PROGRESS','server','swap_subnet_network-server-ty5i2rz63opm','state changed','OS::Nova::Server',NULL,245),(1420,'327ac756-213a-4e14-9400-08df5e2b39af','832db642-8498-4f68-bfb1-831831fbfa27','2025-12-16 15:51:56',NULL,'CREATE','COMPLETE','server','3910ee0a-8bef-4df9-baa4-a17278247e42','state changed','OS::Nova::Server',NULL,245),(1421,'69dc6804-f3bb-41ee-abad-ba82fb4086c8','832db642-8498-4f68-bfb1-831831fbfa27','2025-12-16 15:51:56',NULL,'CREATE','COMPLETE','swap_subnet_network','832db642-8498-4f68-bfb1-831831fbfa27','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1422,'5e0ab32f-10ed-4465-b28f-50fdc0e0f740','832db642-8498-4f68-bfb1-831831fbfa27','2025-12-16 15:52:04',NULL,'UPDATE','IN_PROGRESS','swap_subnet_network','832db642-8498-4f68-bfb1-831831fbfa27','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1423,'38790aad-54dc-4321-b36c-141457b56344','832db642-8498-4f68-bfb1-831831fbfa27','2025-12-16 15:52:08',NULL,'UPDATE','IN_PROGRESS','server','3910ee0a-8bef-4df9-baa4-a17278247e42','state changed','OS::Nova::Server',NULL,245),(1424,'23a40e82-4b78-4743-b4b4-192172979f8a','832db642-8498-4f68-bfb1-831831fbfa27','2025-12-16 15:52:12',NULL,'UPDATE','COMPLETE','server','3910ee0a-8bef-4df9-baa4-a17278247e42','state changed','OS::Nova::Server',NULL,247),(1425,'c7785a46-3d07-4067-b4b6-a9defe79a974','832db642-8498-4f68-bfb1-831831fbfa27','2025-12-16 15:52:12',NULL,'UPDATE','COMPLETE','swap_subnet_network','832db642-8498-4f68-bfb1-831831fbfa27','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1426,'542d03b5-0d8b-4c76-8b55-12f92f7494f8','832db642-8498-4f68-bfb1-831831fbfa27','2025-12-16 15:52:17',NULL,'DELETE','IN_PROGRESS','swap_subnet_network','832db642-8498-4f68-bfb1-831831fbfa27','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1427,'458fa866-5720-445b-b0ab-cd6c99057c8a','832db642-8498-4f68-bfb1-831831fbfa27','2025-12-16 15:52:17',NULL,'DELETE','IN_PROGRESS','server','3910ee0a-8bef-4df9-baa4-a17278247e42','state changed','OS::Nova::Server',NULL,247),(1428,'af4f09b0-dd99-4f67-b95a-6b88e968ebe1','832db642-8498-4f68-bfb1-831831fbfa27','2025-12-16 15:52:20',NULL,'DELETE','COMPLETE','server','3910ee0a-8bef-4df9-baa4-a17278247e42','state changed','OS::Nova::Server',NULL,247),(1429,'5d196a07-07f3-44dd-b5ff-91ca251380d0','832db642-8498-4f68-bfb1-831831fbfa27','2025-12-16 15:52:20',NULL,'DELETE','IN_PROGRESS','subnet','0ceca7ff-6710-48b2-ad32-4228a903d760','state changed','OS::Neutron::Subnet',NULL,244),(1430,'78a0b5d1-16ca-4a0c-ab70-cb315296c8e3','832db642-8498-4f68-bfb1-831831fbfa27','2025-12-16 15:52:20',NULL,'DELETE','COMPLETE','subnet','0ceca7ff-6710-48b2-ad32-4228a903d760','state changed','OS::Neutron::Subnet',NULL,244),(1431,'4b757a96-3dbb-411f-8df6-b3fd402948b1','832db642-8498-4f68-bfb1-831831fbfa27','2025-12-16 15:52:20',NULL,'DELETE','IN_PROGRESS','net','6fbc67b3-e8bb-40e7-8269-7e09473fed7d','state changed','OS::Neutron::Net',NULL,243),(1432,'f58a4455-57ed-4f28-b4f3-260bd8de18a3','832db642-8498-4f68-bfb1-831831fbfa27','2025-12-16 15:52:21',NULL,'DELETE','COMPLETE','net','6fbc67b3-e8bb-40e7-8269-7e09473fed7d','state changed','OS::Neutron::Net',NULL,243),(1433,'dbeb3685-8788-4ac3-83d9-ad28ceedc28f','832db642-8498-4f68-bfb1-831831fbfa27','2025-12-16 15:52:21',NULL,'DELETE','COMPLETE','swap_subnet_network','832db642-8498-4f68-bfb1-831831fbfa27','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1434,'9e61be39-61bd-439d-8306-79292130101f','0ebf5862-2cb2-46e4-8693-fef462380eb3','2025-12-16 15:52:27',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-1404119128','0ebf5862-2cb2-46e4-8693-fef462380eb3','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1435,'bd8a3df8-07aa-4a76-9711-a10686766622','0ebf5862-2cb2-46e4-8693-fef462380eb3','2025-12-16 15:52:27',NULL,'CREATE','IN_PROGRESS','random1','RemoteStackTest-1404119128-random1-oet47qvkjjvm','state changed','OS::Heat::RandomString',NULL,NULL),(1436,'6dde9686-35e7-434e-a8dc-043e81f5069b','0ebf5862-2cb2-46e4-8693-fef462380eb3','2025-12-16 15:52:27',NULL,'CREATE','COMPLETE','random1','RemoteStackTest-1404119128-random1-oet47qvkjjvm','state changed','OS::Heat::RandomString',NULL,NULL),(1437,'234f500b-a327-4610-ba3a-ed1b91744cc1','0ebf5862-2cb2-46e4-8693-fef462380eb3','2025-12-16 15:52:27',NULL,'CREATE','COMPLETE','RemoteStackTest-1404119128','0ebf5862-2cb2-46e4-8693-fef462380eb3','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1438,'75591508-7620-4ee5-855d-9439038ad4dc','0ebf5862-2cb2-46e4-8693-fef462380eb3','2025-12-16 15:52:28',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-1404119128','0ebf5862-2cb2-46e4-8693-fef462380eb3','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1439,'35a45b6f-ee63-4a8e-a279-cfb5b35caca3','0ebf5862-2cb2-46e4-8693-fef462380eb3','2025-12-16 15:52:28',NULL,'DELETE','IN_PROGRESS','random1','RemoteStackTest-1404119128-random1-oet47qvkjjvm','state changed','OS::Heat::RandomString',NULL,NULL),(1440,'b1781f11-96fc-46bf-8dc0-e760cd1bcf8f','0ebf5862-2cb2-46e4-8693-fef462380eb3','2025-12-16 15:52:28',NULL,'DELETE','COMPLETE','random1','RemoteStackTest-1404119128-random1-oet47qvkjjvm','state changed','OS::Heat::RandomString',NULL,NULL),(1441,'1a2480b8-f356-44ab-a9f0-9779d9cf2438','0ebf5862-2cb2-46e4-8693-fef462380eb3','2025-12-16 15:52:28',NULL,'DELETE','COMPLETE','RemoteStackTest-1404119128','0ebf5862-2cb2-46e4-8693-fef462380eb3','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1442,'f5844c78-7bdb-4eea-ba92-dc081b319c0a','13af92fa-6eda-4266-8286-03652fa948f3','2025-12-16 15:52:35',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-638563469','13af92fa-6eda-4266-8286-03652fa948f3','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1443,'9b205966-507a-4e71-8660-32ed38489d3d','13af92fa-6eda-4266-8286-03652fa948f3','2025-12-16 15:52:35',NULL,'CREATE','IN_PROGRESS','my_stack','RemoteStackTest-638563469-my_stack-je5jek63izk2','state changed','OS::Heat::Stack',NULL,249),(1444,'17538858-10aa-4062-8ce0-2905888b19f3','4e4f7436-0104-4c5d-957e-cda3bfc86ee3','2025-12-16 15:52:36',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-638563469-my_stack-je5jek63izk2','4e4f7436-0104-4c5d-957e-cda3bfc86ee3','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1445,'ab24f413-3bcd-4bcf-9b30-99098073526b','4e4f7436-0104-4c5d-957e-cda3bfc86ee3','2025-12-16 15:52:36',NULL,'CREATE','IN_PROGRESS','random1','RemoteStackTest-638563469-my_stack-je5jek63izk2-random1-77svlio2w4xn','state changed','OS::Heat::RandomString',NULL,NULL),(1446,'e5f08246-301b-4969-b27b-f4a9e1a9d9f5','4e4f7436-0104-4c5d-957e-cda3bfc86ee3','2025-12-16 15:52:36',NULL,'CREATE','COMPLETE','random1','RemoteStackTest-638563469-my_stack-je5jek63izk2-random1-77svlio2w4xn','state changed','OS::Heat::RandomString',NULL,NULL),(1447,'5a20a298-3def-4aa9-a957-8605321e5fe3','4e4f7436-0104-4c5d-957e-cda3bfc86ee3','2025-12-16 15:52:36',NULL,'CREATE','COMPLETE','RemoteStackTest-638563469-my_stack-je5jek63izk2','4e4f7436-0104-4c5d-957e-cda3bfc86ee3','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1448,'2846265e-9773-4e14-9f08-65ddc11d9aa8','13af92fa-6eda-4266-8286-03652fa948f3','2025-12-16 15:52:36',NULL,'CREATE','COMPLETE','my_stack','4e4f7436-0104-4c5d-957e-cda3bfc86ee3','state changed','OS::Heat::Stack',NULL,249),(1449,'1cc93b6f-d724-4881-99c3-5a2770a7ef0f','13af92fa-6eda-4266-8286-03652fa948f3','2025-12-16 15:52:36',NULL,'CREATE','COMPLETE','RemoteStackTest-638563469','13af92fa-6eda-4266-8286-03652fa948f3','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1450,'f4206627-619f-4ef0-a137-4af139887306','13af92fa-6eda-4266-8286-03652fa948f3','2025-12-16 15:52:41',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-638563469','13af92fa-6eda-4266-8286-03652fa948f3','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1451,'aece5793-657e-49c0-b4b0-39cb378709dd','13af92fa-6eda-4266-8286-03652fa948f3','2025-12-16 15:52:41',NULL,'DELETE','IN_PROGRESS','my_stack','4e4f7436-0104-4c5d-957e-cda3bfc86ee3','state changed','OS::Heat::Stack',NULL,249),(1452,'1b7e8e7c-06b0-49b9-801f-3572f4d994d7','4e4f7436-0104-4c5d-957e-cda3bfc86ee3','2025-12-16 15:52:42',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-638563469-my_stack-je5jek63izk2','4e4f7436-0104-4c5d-957e-cda3bfc86ee3','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1453,'1c2e1dc8-fd81-4046-8c19-bdeefa4cd9bf','4e4f7436-0104-4c5d-957e-cda3bfc86ee3','2025-12-16 15:52:42',NULL,'DELETE','IN_PROGRESS','random1','RemoteStackTest-638563469-my_stack-je5jek63izk2-random1-77svlio2w4xn','state changed','OS::Heat::RandomString',NULL,NULL),(1454,'a72e492f-5238-405e-bc33-41487ea0f95b','4e4f7436-0104-4c5d-957e-cda3bfc86ee3','2025-12-16 15:52:42',NULL,'DELETE','COMPLETE','random1','RemoteStackTest-638563469-my_stack-je5jek63izk2-random1-77svlio2w4xn','state changed','OS::Heat::RandomString',NULL,NULL),(1455,'c3bcd86f-26ef-4889-9536-4b3d9ef922c2','4e4f7436-0104-4c5d-957e-cda3bfc86ee3','2025-12-16 15:52:42',NULL,'DELETE','COMPLETE','RemoteStackTest-638563469-my_stack-je5jek63izk2','4e4f7436-0104-4c5d-957e-cda3bfc86ee3','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1456,'16a4c86c-bea9-48f1-96fa-0ea5d6faf409','13af92fa-6eda-4266-8286-03652fa948f3','2025-12-16 15:52:42',NULL,'DELETE','COMPLETE','my_stack','4e4f7436-0104-4c5d-957e-cda3bfc86ee3','state changed','OS::Heat::Stack',NULL,249),(1457,'569c0cb5-773a-452d-9042-9319c776f9e8','13af92fa-6eda-4266-8286-03652fa948f3','2025-12-16 15:52:42',NULL,'DELETE','COMPLETE','RemoteStackTest-638563469','13af92fa-6eda-4266-8286-03652fa948f3','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1458,'bf003428-6209-40aa-9b94-b3cdf0494706','3bf90bbb-b9e3-47e3-95f9-d876f4016597','2025-12-16 15:52:51',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-982505025','3bf90bbb-b9e3-47e3-95f9-d876f4016597','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1459,'0b5ce6c0-1768-4a92-9c3b-6ec0fced0f6e','3bf90bbb-b9e3-47e3-95f9-d876f4016597','2025-12-16 15:52:51',NULL,'CREATE','IN_PROGRESS','my_stack','RemoteStackTest-982505025-my_stack-r7ze345pctbu','state changed','OS::Heat::Stack',NULL,251),(1460,'8c48ea6a-a2bb-452d-8b56-d8d76cedf848','4393b09a-49b4-425b-944c-d87722a8fa1a','2025-12-16 15:52:52',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-982505025-my_stack-r7ze345pctbu','4393b09a-49b4-425b-944c-d87722a8fa1a','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1461,'5b0859fd-44ae-4d66-a09d-c43f9361f6d1','4393b09a-49b4-425b-944c-d87722a8fa1a','2025-12-16 15:52:52',NULL,'CREATE','IN_PROGRESS','random1','RemoteStackTest-982505025-my_stack-r7ze345pctbu-random1-jz5sj7klq3jf','state changed','OS::Heat::RandomString',NULL,NULL),(1462,'7455e804-aa60-413e-8506-d2a57ab5a0ba','4393b09a-49b4-425b-944c-d87722a8fa1a','2025-12-16 15:52:52',NULL,'CREATE','COMPLETE','random1','RemoteStackTest-982505025-my_stack-r7ze345pctbu-random1-jz5sj7klq3jf','state changed','OS::Heat::RandomString',NULL,NULL),(1463,'067d4389-79f4-4ec8-ac57-ee38071fb8bd','4393b09a-49b4-425b-944c-d87722a8fa1a','2025-12-16 15:52:52',NULL,'CREATE','COMPLETE','RemoteStackTest-982505025-my_stack-r7ze345pctbu','4393b09a-49b4-425b-944c-d87722a8fa1a','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1464,'385eac1b-33eb-442f-8e85-d43c2f92dea4','3bf90bbb-b9e3-47e3-95f9-d876f4016597','2025-12-16 15:52:53',NULL,'CREATE','COMPLETE','my_stack','4393b09a-49b4-425b-944c-d87722a8fa1a','state changed','OS::Heat::Stack',NULL,251),(1465,'1694c63c-c126-4d36-9be9-2b270bb0b999','3bf90bbb-b9e3-47e3-95f9-d876f4016597','2025-12-16 15:52:53',NULL,'CREATE','COMPLETE','RemoteStackTest-982505025','3bf90bbb-b9e3-47e3-95f9-d876f4016597','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1466,'006d73de-7d4f-4977-b7b0-015839964a05','3bf90bbb-b9e3-47e3-95f9-d876f4016597','2025-12-16 15:52:55',NULL,'SUSPEND','IN_PROGRESS','RemoteStackTest-982505025','3bf90bbb-b9e3-47e3-95f9-d876f4016597','Stack SUSPEND started','OS::Heat::Stack',NULL,NULL),(1467,'83d31f70-6424-4b4b-8ef5-512b9249db48','3bf90bbb-b9e3-47e3-95f9-d876f4016597','2025-12-16 15:52:55',NULL,'SUSPEND','IN_PROGRESS','my_stack','4393b09a-49b4-425b-944c-d87722a8fa1a','state changed','OS::Heat::Stack',NULL,251),(1468,'cecb0e90-23b5-4770-869e-c79823e689f6','4393b09a-49b4-425b-944c-d87722a8fa1a','2025-12-16 15:52:56',NULL,'SUSPEND','IN_PROGRESS','RemoteStackTest-982505025-my_stack-r7ze345pctbu','4393b09a-49b4-425b-944c-d87722a8fa1a','Stack SUSPEND started','OS::Heat::Stack',NULL,NULL),(1469,'dce7cfbe-08ab-4a51-b274-4c4453408bcd','4393b09a-49b4-425b-944c-d87722a8fa1a','2025-12-16 15:52:56',NULL,'SUSPEND','IN_PROGRESS','random1','RemoteStackTest-982505025-my_stack-r7ze345pctbu-random1-jz5sj7klq3jf','state changed','OS::Heat::RandomString',NULL,NULL),(1470,'b87f3b21-2084-424c-9b6b-fc48b5af9315','4393b09a-49b4-425b-944c-d87722a8fa1a','2025-12-16 15:52:56',NULL,'SUSPEND','COMPLETE','random1','RemoteStackTest-982505025-my_stack-r7ze345pctbu-random1-jz5sj7klq3jf','state changed','OS::Heat::RandomString',NULL,NULL),(1471,'e0f28954-6c69-44fb-a152-0251d45d1ae4','4393b09a-49b4-425b-944c-d87722a8fa1a','2025-12-16 15:52:56',NULL,'SUSPEND','COMPLETE','RemoteStackTest-982505025-my_stack-r7ze345pctbu','4393b09a-49b4-425b-944c-d87722a8fa1a','Stack SUSPEND completed successfully','OS::Heat::Stack',NULL,NULL),(1472,'331b8591-d429-499a-a73c-74f82e0065ad','3bf90bbb-b9e3-47e3-95f9-d876f4016597','2025-12-16 15:52:56',NULL,'SUSPEND','COMPLETE','my_stack','4393b09a-49b4-425b-944c-d87722a8fa1a','state changed','OS::Heat::Stack',NULL,251),(1473,'761b03ed-e032-46cc-9379-06cb634370f9','3bf90bbb-b9e3-47e3-95f9-d876f4016597','2025-12-16 15:52:56',NULL,'SUSPEND','COMPLETE','RemoteStackTest-982505025','3bf90bbb-b9e3-47e3-95f9-d876f4016597','Stack SUSPEND completed successfully','OS::Heat::Stack',NULL,NULL),(1474,'ac266d98-a45c-4844-a11d-3ce39b35783d','3bf90bbb-b9e3-47e3-95f9-d876f4016597','2025-12-16 15:53:01',NULL,'RESUME','IN_PROGRESS','RemoteStackTest-982505025','3bf90bbb-b9e3-47e3-95f9-d876f4016597','Stack RESUME started','OS::Heat::Stack',NULL,NULL),(1475,'0ad3d860-7cd8-4f1f-ae7d-a6b7d290f2e1','3bf90bbb-b9e3-47e3-95f9-d876f4016597','2025-12-16 15:53:01',NULL,'RESUME','IN_PROGRESS','my_stack','4393b09a-49b4-425b-944c-d87722a8fa1a','state changed','OS::Heat::Stack',NULL,251),(1476,'48f644ad-8fa7-4218-985d-fb18057f500f','4393b09a-49b4-425b-944c-d87722a8fa1a','2025-12-16 15:53:02',NULL,'RESUME','IN_PROGRESS','RemoteStackTest-982505025-my_stack-r7ze345pctbu','4393b09a-49b4-425b-944c-d87722a8fa1a','Stack RESUME started','OS::Heat::Stack',NULL,NULL),(1477,'685a5b2a-a44c-4430-aa08-68328426cf64','4393b09a-49b4-425b-944c-d87722a8fa1a','2025-12-16 15:53:02',NULL,'RESUME','IN_PROGRESS','random1','RemoteStackTest-982505025-my_stack-r7ze345pctbu-random1-jz5sj7klq3jf','state changed','OS::Heat::RandomString',NULL,NULL),(1478,'b47f86da-c42a-4656-bb1e-483bd69aeaa1','4393b09a-49b4-425b-944c-d87722a8fa1a','2025-12-16 15:53:02',NULL,'RESUME','COMPLETE','random1','RemoteStackTest-982505025-my_stack-r7ze345pctbu-random1-jz5sj7klq3jf','state changed','OS::Heat::RandomString',NULL,NULL),(1479,'ef8cf1e4-460b-40a3-83e3-e3afcd1f45b0','4393b09a-49b4-425b-944c-d87722a8fa1a','2025-12-16 15:53:02',NULL,'RESUME','COMPLETE','RemoteStackTest-982505025-my_stack-r7ze345pctbu','4393b09a-49b4-425b-944c-d87722a8fa1a','Stack RESUME completed successfully','OS::Heat::Stack',NULL,NULL),(1480,'69fef40a-c0c3-434f-833d-8ac9b92e47b6','3bf90bbb-b9e3-47e3-95f9-d876f4016597','2025-12-16 15:53:02',NULL,'RESUME','COMPLETE','my_stack','4393b09a-49b4-425b-944c-d87722a8fa1a','state changed','OS::Heat::Stack',NULL,251),(1481,'bfb30c1e-f42b-4e81-90b8-040b61d873d3','3bf90bbb-b9e3-47e3-95f9-d876f4016597','2025-12-16 15:53:02',NULL,'RESUME','COMPLETE','RemoteStackTest-982505025','3bf90bbb-b9e3-47e3-95f9-d876f4016597','Stack RESUME completed successfully','OS::Heat::Stack',NULL,NULL),(1482,'9931ab64-7779-43a4-bed8-b5173d1401b7','3bf90bbb-b9e3-47e3-95f9-d876f4016597','2025-12-16 15:53:09',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-982505025','3bf90bbb-b9e3-47e3-95f9-d876f4016597','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1483,'4dcaf001-6529-47de-9b13-cce397fc468d','3bf90bbb-b9e3-47e3-95f9-d876f4016597','2025-12-16 15:53:09',NULL,'DELETE','IN_PROGRESS','my_stack','4393b09a-49b4-425b-944c-d87722a8fa1a','state changed','OS::Heat::Stack',NULL,251),(1484,'7e64d379-8b6f-48a1-ac76-1346069859f0','4393b09a-49b4-425b-944c-d87722a8fa1a','2025-12-16 15:53:10',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-982505025-my_stack-r7ze345pctbu','4393b09a-49b4-425b-944c-d87722a8fa1a','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1485,'95cb45ea-0452-42df-a9d7-81f0ec1151a4','4393b09a-49b4-425b-944c-d87722a8fa1a','2025-12-16 15:53:10',NULL,'DELETE','IN_PROGRESS','random1','RemoteStackTest-982505025-my_stack-r7ze345pctbu-random1-jz5sj7klq3jf','state changed','OS::Heat::RandomString',NULL,NULL),(1486,'d4551583-eef9-4de2-9b24-ff027ecd91f3','4393b09a-49b4-425b-944c-d87722a8fa1a','2025-12-16 15:53:10',NULL,'DELETE','COMPLETE','random1','RemoteStackTest-982505025-my_stack-r7ze345pctbu-random1-jz5sj7klq3jf','state changed','OS::Heat::RandomString',NULL,NULL),(1487,'c126942f-ac64-40c8-ab70-205ac6b9650d','4393b09a-49b4-425b-944c-d87722a8fa1a','2025-12-16 15:53:10',NULL,'DELETE','COMPLETE','RemoteStackTest-982505025-my_stack-r7ze345pctbu','4393b09a-49b4-425b-944c-d87722a8fa1a','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1488,'5a276c52-7c8a-49d2-bee6-bbf8b04d7e86','3bf90bbb-b9e3-47e3-95f9-d876f4016597','2025-12-16 15:53:10',NULL,'DELETE','COMPLETE','my_stack','4393b09a-49b4-425b-944c-d87722a8fa1a','state changed','OS::Heat::Stack',NULL,251),(1489,'71ed7265-be05-4b15-9d2e-b4ad91f448df','3bf90bbb-b9e3-47e3-95f9-d876f4016597','2025-12-16 15:53:10',NULL,'DELETE','COMPLETE','RemoteStackTest-982505025','3bf90bbb-b9e3-47e3-95f9-d876f4016597','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1490,'b4b927bf-dabf-4ad9-be7d-b56c7e294efe','d996c9a7-562a-44e2-b7d9-a878e5a4528c','2025-12-16 15:53:17',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-628457373','d996c9a7-562a-44e2-b7d9-a878e5a4528c','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1491,'c8973aa0-1060-4142-8f96-5e3860aabff1','d996c9a7-562a-44e2-b7d9-a878e5a4528c','2025-12-16 15:53:17',NULL,'CREATE','IN_PROGRESS','my_stack','RemoteStackTest-628457373-my_stack-grhdfsiwdt5v','state changed','OS::Heat::Stack',NULL,252),(1492,'7acd0e70-dea0-4571-b5f5-75cddfb4afc2','e7c45c7a-1653-4624-8d62-a93026ec3a11','2025-12-16 15:53:18',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-628457373-my_stack-grhdfsiwdt5v','e7c45c7a-1653-4624-8d62-a93026ec3a11','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1493,'663a418b-083b-4b00-8398-ffdd4aed596d','e7c45c7a-1653-4624-8d62-a93026ec3a11','2025-12-16 15:53:18',NULL,'CREATE','IN_PROGRESS','random1','RemoteStackTest-628457373-my_stack-grhdfsiwdt5v-random1-o2aawrjozhf4','state changed','OS::Heat::RandomString',NULL,NULL),(1494,'62a20340-34ba-46d7-9bfe-b1aefe9b60aa','e7c45c7a-1653-4624-8d62-a93026ec3a11','2025-12-16 15:53:18',NULL,'CREATE','COMPLETE','random1','RemoteStackTest-628457373-my_stack-grhdfsiwdt5v-random1-o2aawrjozhf4','state changed','OS::Heat::RandomString',NULL,NULL),(1495,'4f971a48-4402-48b4-b851-75261a926f3a','e7c45c7a-1653-4624-8d62-a93026ec3a11','2025-12-16 15:53:18',NULL,'CREATE','COMPLETE','RemoteStackTest-628457373-my_stack-grhdfsiwdt5v','e7c45c7a-1653-4624-8d62-a93026ec3a11','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1496,'4d7457b3-71e1-4677-9705-9ea9cb10e04a','d996c9a7-562a-44e2-b7d9-a878e5a4528c','2025-12-16 15:53:19',NULL,'CREATE','COMPLETE','my_stack','e7c45c7a-1653-4624-8d62-a93026ec3a11','state changed','OS::Heat::Stack',NULL,252),(1497,'f841695e-8aa1-49eb-8053-2900f1ccee18','d996c9a7-562a-44e2-b7d9-a878e5a4528c','2025-12-16 15:53:19',NULL,'CREATE','COMPLETE','RemoteStackTest-628457373','d996c9a7-562a-44e2-b7d9-a878e5a4528c','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1498,'cb26a14f-49c5-4927-ad29-1694fcad39a9','d996c9a7-562a-44e2-b7d9-a878e5a4528c','2025-12-16 15:53:24',NULL,'UPDATE','IN_PROGRESS','RemoteStackTest-628457373','d996c9a7-562a-44e2-b7d9-a878e5a4528c','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1499,'eea690a3-1462-4f94-bdb4-e406a5cb5927','d996c9a7-562a-44e2-b7d9-a878e5a4528c','2025-12-16 15:53:24',NULL,'UPDATE','IN_PROGRESS','my_stack','e7c45c7a-1653-4624-8d62-a93026ec3a11','state changed','OS::Heat::Stack',NULL,252),(1500,'09701227-f055-4a65-96a2-4149b81304b1','e7c45c7a-1653-4624-8d62-a93026ec3a11','2025-12-16 15:53:25',NULL,'UPDATE','IN_PROGRESS','RemoteStackTest-628457373-my_stack-grhdfsiwdt5v','e7c45c7a-1653-4624-8d62-a93026ec3a11','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1501,'1ab67d08-e77b-47e2-9af5-5678f366b475','e7c45c7a-1653-4624-8d62-a93026ec3a11','2025-12-16 15:53:25',NULL,'DELETE','IN_PROGRESS','random1','RemoteStackTest-628457373-my_stack-grhdfsiwdt5v-random1-o2aawrjozhf4','state changed','OS::Heat::RandomString',NULL,NULL),(1502,'6a5c8574-c676-48ea-8ee2-5669a455c975','e7c45c7a-1653-4624-8d62-a93026ec3a11','2025-12-16 15:53:25',NULL,'DELETE','COMPLETE','random1','RemoteStackTest-628457373-my_stack-grhdfsiwdt5v-random1-o2aawrjozhf4','state changed','OS::Heat::RandomString',NULL,NULL),(1503,'d88baab5-ee0e-4251-93fb-380b3ea0fa54','e7c45c7a-1653-4624-8d62-a93026ec3a11','2025-12-16 15:53:26',NULL,'CREATE','IN_PROGRESS','random2','RemoteStackTest-628457373-my_stack-grhdfsiwdt5v-random2-qtbnv2gt63xl','state changed','OS::Heat::RandomString',NULL,NULL),(1504,'2de6a6a2-6afc-4e04-9f8c-70d30fefdb6c','e7c45c7a-1653-4624-8d62-a93026ec3a11','2025-12-16 15:53:26',NULL,'CREATE','COMPLETE','random2','RemoteStackTest-628457373-my_stack-grhdfsiwdt5v-random2-qtbnv2gt63xl','state changed','OS::Heat::RandomString',NULL,NULL),(1505,'c03a3044-6a7a-40ec-8e1d-4a8fb3382f33','e7c45c7a-1653-4624-8d62-a93026ec3a11','2025-12-16 15:53:26',NULL,'UPDATE','COMPLETE','RemoteStackTest-628457373-my_stack-grhdfsiwdt5v','e7c45c7a-1653-4624-8d62-a93026ec3a11','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1506,'d21bffc9-31e6-42f1-be7f-0ebf1b3000f8','d996c9a7-562a-44e2-b7d9-a878e5a4528c','2025-12-16 15:53:28',NULL,'UPDATE','COMPLETE','my_stack','e7c45c7a-1653-4624-8d62-a93026ec3a11','state changed','OS::Heat::Stack',NULL,253),(1507,'58231ace-47bf-4649-9075-1f5b6a421455','d996c9a7-562a-44e2-b7d9-a878e5a4528c','2025-12-16 15:53:28',NULL,'UPDATE','COMPLETE','RemoteStackTest-628457373','d996c9a7-562a-44e2-b7d9-a878e5a4528c','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1508,'fe65b1a8-3339-44d7-b4de-1ab58f0f3a8a','d996c9a7-562a-44e2-b7d9-a878e5a4528c','2025-12-16 15:53:29',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-628457373','d996c9a7-562a-44e2-b7d9-a878e5a4528c','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1509,'ba8e45be-3657-4784-a8ec-9dde70294ad3','d996c9a7-562a-44e2-b7d9-a878e5a4528c','2025-12-16 15:53:29',NULL,'DELETE','IN_PROGRESS','my_stack','e7c45c7a-1653-4624-8d62-a93026ec3a11','state changed','OS::Heat::Stack',NULL,253),(1510,'a7f7d7e0-ab12-4857-87f0-2d8cc7c5e25e','e7c45c7a-1653-4624-8d62-a93026ec3a11','2025-12-16 15:53:29',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-628457373-my_stack-grhdfsiwdt5v','e7c45c7a-1653-4624-8d62-a93026ec3a11','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1511,'31962e85-aa41-44a5-9c44-ecac4e3b1e7a','e7c45c7a-1653-4624-8d62-a93026ec3a11','2025-12-16 15:53:30',NULL,'DELETE','IN_PROGRESS','random2','RemoteStackTest-628457373-my_stack-grhdfsiwdt5v-random2-qtbnv2gt63xl','state changed','OS::Heat::RandomString',NULL,NULL),(1512,'eb1d0ebe-dec1-4a24-8b62-3059225529ce','e7c45c7a-1653-4624-8d62-a93026ec3a11','2025-12-16 15:53:30',NULL,'DELETE','COMPLETE','random2','RemoteStackTest-628457373-my_stack-grhdfsiwdt5v-random2-qtbnv2gt63xl','state changed','OS::Heat::RandomString',NULL,NULL),(1513,'b12b8701-e4be-4a0e-8fdd-0940145b3e79','e7c45c7a-1653-4624-8d62-a93026ec3a11','2025-12-16 15:53:30',NULL,'DELETE','COMPLETE','RemoteStackTest-628457373-my_stack-grhdfsiwdt5v','e7c45c7a-1653-4624-8d62-a93026ec3a11','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1514,'70c64a90-836d-4660-b90e-3d9183b428c2','d996c9a7-562a-44e2-b7d9-a878e5a4528c','2025-12-16 15:53:30',NULL,'DELETE','COMPLETE','my_stack','e7c45c7a-1653-4624-8d62-a93026ec3a11','state changed','OS::Heat::Stack',NULL,253),(1515,'4a271b28-6503-41b9-9f8e-5a46e7be6973','d996c9a7-562a-44e2-b7d9-a878e5a4528c','2025-12-16 15:53:30',NULL,'DELETE','COMPLETE','RemoteStackTest-628457373','d996c9a7-562a-44e2-b7d9-a878e5a4528c','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1516,'fd8a28c5-3e91-4d8f-9977-c72d9a9287e7','e6dd329c-bca6-44b2-b461-347820c4c943','2025-12-16 15:53:36',NULL,'CREATE','IN_PROGRESS','StackEventsTest-1022542315','e6dd329c-bca6-44b2-b461-347820c4c943','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1517,'429c06c0-6ba6-4613-82f6-4d12c9bb96b7','e6dd329c-bca6-44b2-b461-347820c4c943','2025-12-16 15:53:36',NULL,'CREATE','IN_PROGRESS','test_resource','StackEventsTest-1022542315-test_resource-ddecxx7v4mje','state changed','OS::Heat::TestResource',NULL,254),(1518,'2ae7212e-2129-4c8e-ac6a-6e16a288b94b','e6dd329c-bca6-44b2-b461-347820c4c943','2025-12-16 15:53:36',NULL,'CREATE','COMPLETE','test_resource','StackEventsTest-1022542315-test_resource-ddecxx7v4mje','state changed','OS::Heat::TestResource',NULL,254),(1519,'ee69b7da-524c-452d-a2e1-50ef4809e959','e6dd329c-bca6-44b2-b461-347820c4c943','2025-12-16 15:53:36',NULL,'CREATE','COMPLETE','StackEventsTest-1022542315','e6dd329c-bca6-44b2-b461-347820c4c943','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1520,'ddd55133-9fb5-4299-8225-c4240c7255e3','e6dd329c-bca6-44b2-b461-347820c4c943','2025-12-16 15:53:38',NULL,'DELETE','IN_PROGRESS','StackEventsTest-1022542315','e6dd329c-bca6-44b2-b461-347820c4c943','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1521,'9adbab18-d86a-4521-947a-ffda3c1c07a8','e6dd329c-bca6-44b2-b461-347820c4c943','2025-12-16 15:53:38',NULL,'DELETE','IN_PROGRESS','test_resource','StackEventsTest-1022542315-test_resource-ddecxx7v4mje','state changed','OS::Heat::TestResource',NULL,254),(1522,'b032e812-9010-4ade-8c4d-42984b9f2f4a','e6dd329c-bca6-44b2-b461-347820c4c943','2025-12-16 15:53:38',NULL,'DELETE','COMPLETE','test_resource','StackEventsTest-1022542315-test_resource-ddecxx7v4mje','state changed','OS::Heat::TestResource',NULL,254),(1523,'32041dde-f1e2-4d1a-8376-b49dc30906d6','e6dd329c-bca6-44b2-b461-347820c4c943','2025-12-16 15:53:38',NULL,'DELETE','COMPLETE','StackEventsTest-1022542315','e6dd329c-bca6-44b2-b461-347820c4c943','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL);
/*!40000 ALTER TABLE `event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('heat','/usr/lib/python3.9/site-packages/heat/db/sqlalchemy/migrate_repo',86);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raw_template`
--

DROP TABLE IF EXISTS `raw_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `raw_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `template` longtext DEFAULT NULL,
  `files` longtext DEFAULT NULL,
  `environment` longtext DEFAULT NULL,
  `files_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_tmpl_files_fkey_ref` (`files_id`),
  CONSTRAINT `raw_tmpl_files_fkey_ref` FOREIGN KEY (`files_id`) REFERENCES `raw_template_files` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=243 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raw_template`
--

LOCK TABLES `raw_template` WRITE;
/*!40000 ALTER TABLE `raw_template` DISABLE KEYS */;
INSERT INTO `raw_template` (`id`, `created_at`, `updated_at`, `template`, `files`, `environment`, `files_id`) VALUES (2,'2025-12-16 15:43:45',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}}}}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"test\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(3,'2025-12-16 15:43:45',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}}}}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"test\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(4,'2025-12-16 15:43:45',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}}}}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"test\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(5,'2025-12-16 15:43:47',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(6,'2025-12-16 15:43:48',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(7,'2025-12-16 15:43:49',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"test\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(8,'2025-12-16 15:43:50',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(11,'2025-12-16 15:43:57',NULL,'{\"heat_template_version\": \"2016-04-08\"}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(13,'2025-12-16 15:43:57',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(15,'2025-12-16 15:43:59',NULL,'{\"heat_template_version\": \"2016-04-08\"}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(18,'2025-12-16 15:44:01',NULL,'{\"heat_template_version\": \"2016-04-08\"}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(21,'2025-12-16 15:44:02',NULL,'{\"heat_template_version\": \"pike\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}, \"action_wait_secs\": {\"update\": 1}}}}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"new_value\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(22,'2025-12-16 15:44:03',NULL,'{\"heat_template_version\": \"2016-04-08\"}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(28,'2025-12-16 15:44:06',NULL,'{\"heat_template_version\": \"pike\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}, \"action_wait_secs\": {\"update\": 1}}}}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"new_patched_value\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(29,'2025-12-16 15:44:09',NULL,'{\"heat_template_version\": \"pike\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}, \"action_wait_secs\": {\"update\": 1}}}}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"new_patched_value\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(34,'2025-12-16 15:44:15',NULL,'{\"heat_template_version\": \"pike\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"new_patched_value\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(36,'2025-12-16 15:44:17',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create port wit ip_address.\", \"parameters\": {\"mac\": {\"type\": \"string\", \"default\": \"00-00-00-00-BB-BB\"}}, \"resources\": {}, \"outputs\": {\"port_ip\": {\"value\": {\"get_attr\": [\"port\", \"fixed_ips\", 0, \"ip_address\"]}}, \"mac_address\": {\"value\": {\"get_attr\": [\"port\", \"mac_address\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(40,'2025-12-16 15:44:25',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create encryption volume type.\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(41,'2025-12-16 15:44:29',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(43,'2025-12-16 15:44:33',NULL,'{\"heat_template_version\": \"2016-10-14\", \"resources\": {}, \"outputs\": {\"str\": {\"value\": {\"get_resource\": \"test1\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(44,'2025-12-16 15:44:34',NULL,'{\"heat_template_version\": \"2014-10-16\", \"parameters\": {\"image\": {\"type\": \"string\"}, \"flavor\": {\"type\": \"string\"}, \"network\": {\"type\": \"string\"}, \"foo\": {\"type\": \"string\", \"description\": \"parameter with encryption turned on\", \"hidden\": true, \"default\": \"secret\"}}, \"resources\": {}, \"outputs\": {\"encrypted_foo_param\": {\"description\": \"encrypted param\", \"value\": {\"get_param\": \"foo\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\", \"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"network\": \"heat_tempestconf_network\", \"foo\": \"my_encrypted_foo\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(51,'2025-12-16 15:44:43',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create port wit ip_address.\", \"parameters\": {\"mac\": {\"type\": \"string\", \"default\": \"00-00-00-00-BB-BB\"}}, \"resources\": {}, \"outputs\": {\"port_ip\": {\"value\": {\"get_attr\": [\"port\", \"fixed_ips\", 0, \"ip_address\"]}}, \"mac_address\": {\"value\": {\"get_attr\": [\"port\", \"mac_address\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"mac\": \"00-00-00-00-AA-AA\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(52,'2025-12-16 15:44:44',NULL,'{\"heat_template_version\": \"2016-10-14\", \"resources\": {}, \"outputs\": {\"str\": {\"value\": {\"get_resource\": \"test1\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(53,'2025-12-16 15:44:45',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(55,'2025-12-16 15:44:49',NULL,'{\"heat_template_version\": \"2016-10-14\", \"resources\": {\"test1\": {\"type\": \"OS::Heat::TestResource\"}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(58,'2025-12-16 15:44:56',NULL,'{\"heat_template_version\": \"2016-10-14\", \"resources\": {}, \"outputs\": {\"str\": {\"value\": {\"get_resource\": \"test1\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(60,'2025-12-16 15:44:58',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server with port.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(62,'2025-12-16 15:45:02',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(66,'2025-12-16 15:45:09',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_step2\": {\"hooks\": \"pre-create\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(69,'2025-12-16 15:45:14',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(71,'2025-12-16 15:45:18',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(74,'2025-12-16 15:45:25',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"nested\": {\"foo_step2\": {\"hooks\": \"pre-create\"}}}, \"nested.yaml\": \"nested.yaml\"}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',1),(75,'2025-12-16 15:45:25',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_step2\": {\"hooks\": \"pre-create\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',1),(77,'2025-12-16 15:45:30',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server with subnet and fixed_ip.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"networks\": {\"value\": {\"get_attr\": [\"server\", \"networks\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(80,'2025-12-16 15:45:36',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(81,'2025-12-16 15:45:40',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(86,'2025-12-16 15:45:52',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(87,'2025-12-16 15:45:53',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_*\": {\"hooks\": \"pre-create\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(98,'2025-12-16 15:46:10',NULL,'{\"heat_template_version\": \"2015-10-15\", \"resources\": {}, \"outputs\": {\"resource_output_a\": {\"value\": {\"get_attr\": [\"parent\", \"resource_output_a\"]}, \"description\": \"parent a\"}, \"resource_output_b\": {\"value\": {\"get_attr\": [\"parent\", \"resource_output_b\"]}, \"description\": \"parent b\"}}}','null','{\"resource_registry\": {\"resources\": {}, \"1.yaml\": \"1.yaml\"}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',3),(99,'2025-12-16 15:46:10',NULL,'{\"heat_template_version\": \"2015-10-15\", \"resources\": {}, \"outputs\": {\"resource_output_a\": {\"description\": \"Output of resource a\", \"value\": {\"get_attr\": [\"test_resource_a\", \"output\"]}}, \"resource_output_b\": {\"description\": \"Output of resource b\", \"value\": {\"get_param\": \"foo\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',3),(100,'2025-12-16 15:46:12',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"rg\": {\"hooks\": \"pre-update\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(101,'2025-12-16 15:46:13',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}, \"outputs\": {\"refs_map\": {\"value\": {\"0\": {\"get_resource\": \"0\"}, \"1\": {\"get_resource\": \"1\"}}}}}','null','{\"resource_registry\": {\"resources\": {\"hooks\": \"pre-update\"}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(102,'2025-12-16 15:46:13',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(106,'2025-12-16 15:46:21',NULL,'{\"heat_template_version\": \"2015-10-15\", \"resources\": {}, \"outputs\": {\"resource_output_a\": {\"description\": \"Output of resource a\", \"value\": {\"get_attr\": [\"test_resource_a\", \"output\"]}}, \"resource_output_b\": {\"description\": \"Output of resource b\", \"value\": {\"get_attr\": [\"test_resource_b\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(108,'2025-12-16 15:46:24',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"networks\": {\"value\": {\"get_attr\": [\"server\", \"networks\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(109,'2025-12-16 15:46:25',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_step2\": {\"hooks\": \"pre-update\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(114,'2025-12-16 15:46:30',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(117,'2025-12-16 15:46:33',NULL,'{\"heat_template_version\": \"2015-10-15\", \"resources\": {}, \"outputs\": {\"output_value\": {\"description\": \"Output of resource b\", \"value\": {\"get_attr\": [\"test_resource_b\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(119,'2025-12-16 15:46:38',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(120,'2025-12-16 15:46:39',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_step2\": {\"hooks\": \"pre-update\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(121,'2025-12-16 15:46:42',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(151,'2025-12-16 15:47:12',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(152,'2025-12-16 15:47:18',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(155,'2025-12-16 15:47:29',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(156,'2025-12-16 15:47:29',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(157,'2025-12-16 15:47:30',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(158,'2025-12-16 15:47:31',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(160,'2025-12-16 15:47:38',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(161,'2025-12-16 15:47:39',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(162,'2025-12-16 15:47:40',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(163,'2025-12-16 15:47:41',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(164,'2025-12-16 15:47:43',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(165,'2025-12-16 15:47:47',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(166,'2025-12-16 15:47:48',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(167,'2025-12-16 15:47:49',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(169,'2025-12-16 15:47:50',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(170,'2025-12-16 15:47:52',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(171,'2025-12-16 15:47:53',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(172,'2025-12-16 15:47:54',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(173,'2025-12-16 15:47:55',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(174,'2025-12-16 15:47:55',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(176,'2025-12-16 15:47:56',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(177,'2025-12-16 15:48:00',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(178,'2025-12-16 15:48:01',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(179,'2025-12-16 15:48:01',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(180,'2025-12-16 15:48:02',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(181,'2025-12-16 15:48:02',NULL,'{\"heat_template_version\": \"2014-10-16\", \"description\": \"foo\", \"parameters\": {\"input\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(182,'2025-12-16 15:48:04',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(183,'2025-12-16 15:48:05',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(184,'2025-12-16 15:48:05',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(186,'2025-12-16 15:48:10',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}, \"network\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"server\": {\"value\": {\"get_resource\": \"server\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"network\": \"heat_tempestconf_network\", \"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(191,'2025-12-16 15:48:26',NULL,'{\"heat_template_version\": \"2014-10-16\", \"description\": \"foo\", \"parameters\": {\"input\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"input\": \"none\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(194,'2025-12-16 15:48:35',NULL,'{\"heat_template_version\": \"2014-10-16\", \"description\": \"\\u8fd9\\u662f\\u4e00\\u4e2a\\u63cf\\u8ff0\", \"parameters\": {\"\\u53c2\\u6570\": {\"type\": \"number\", \"default\": 10, \"label\": \"\\u6807\\u7b7e\", \"description\": \"\\u8fd9\\u662f\\u4e00\\u4e2a\\u63cf\\u8ff0\"}}, \"resources\": {}, \"outputs\": {\"\\u8f93\\u51fa\": {\"description\": \"\\u8fd9\\u662f\\u4e00\\u4e2a\\u63cf\\u8ff0\", \"value\": {\"get_attr\": [\"\\u8d44\\u6e90\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(199,'2025-12-16 15:48:50',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(201,'2025-12-16 15:49:36',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"1b2ae6fb-2f83-44b7-a283-cc4cec490f5f\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(202,'2025-12-16 15:49:37',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(203,'2025-12-16 15:49:38',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(204,'2025-12-16 15:49:39',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(206,'2025-12-16 15:49:46',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}, \"network\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"server\": {\"value\": {\"get_resource\": \"server\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"network\": \"heat_tempestconf_network\", \"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(207,'2025-12-16 15:49:54',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(209,'2025-12-16 15:49:57',NULL,'{\"heat_template_version\": \"2014-10-16\", \"description\": \"Test Template APIs\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(214,'2025-12-16 15:50:14',NULL,'{\"description\": \"The root stack (containing a remote stack) for the deeply-nested remote\\nstack test.\\n\", \"heat_template_version\": \"2015-10-15\", \"outputs\": {\"router\": {\"value\": {\"get_attr\": [\"network_stack\", \"outputs\", \"router\"]}}}, \"parameters\": {\"name\": {\"constraints\": [{\"allowed_pattern\": \"[a-z][a-z0-9-]{1,}\"}], \"description\": \"Name of the router\", \"type\": \"string\"}, \"network_name\": {\"constraints\": [{\"custom_constraint\": \"neutron.network\"}], \"description\": \"The public network to connect to\", \"type\": \"string\"}, \"region\": {\"default\": \"RegionOne\", \"description\": \"The region in which to create the remote stack\", \"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"name\": \"remote-nested\", \"network_name\": \"public\", \"region\": \"regionOne\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',4),(215,'2025-12-16 15:50:15',NULL,'{\"heat_template_version\": \"2015-10-15\", \"description\": \"The intermediate stack (containing a local nested stack) to be instantiated\\nremotely in the remote deeply-nested stack test.\\n\", \"parameters\": {\"name\": {\"type\": \"string\", \"description\": \"Name of the router\", \"constraints\": [{\"allowed_pattern\": \"[a-z][a-z0-9-]{1,}\"}]}, \"network_name\": {\"type\": \"string\", \"description\": \"The public network to connect to\", \"constraints\": [{\"custom_constraint\": \"neutron.network\"}]}}, \"resources\": {}, \"outputs\": {\"router\": {\"value\": {\"get_attr\": [\"network_stack_as_custom_type\", \"router\"]}}}}','null','{\"resource_registry\": {\"resources\": {}, \"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\": \"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\"}, \"parameters\": {\"name\": \"remote-nested\", \"network_name\": \"public\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',5),(216,'2025-12-16 15:50:15',NULL,'{\"heat_template_version\": \"2015-10-15\", \"description\": \"The base stack (containing an actual resource) for the remote deeply-nested\\nstack test.\\n\", \"parameters\": {\"name\": {\"type\": \"string\", \"description\": \"Name of the router\", \"constraints\": [{\"allowed_pattern\": \"[a-z][a-z0-9-]{1,}\"}]}, \"network_name\": {\"type\": \"string\", \"description\": \"The network to connect to\", \"constraints\": [{\"custom_constraint\": \"neutron.network\"}]}}, \"resources\": {}, \"outputs\": {\"router\": {\"value\": {\"get_resource\": \"router\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"name\": \"remote-nested\", \"network_name\": \"public\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',5),(218,'2025-12-16 15:50:41',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(221,'2025-12-16 15:51:23',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(224,'2025-12-16 15:52:17',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(226,'2025-12-16 15:52:28',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"remote_key\": {\"value\": {\"get_attr\": [\"random1\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(229,'2025-12-16 15:52:41',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"key\": {\"value\": {\"get_attr\": [\"my_stack\", \"outputs\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',6),(230,'2025-12-16 15:52:42',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"remote_key\": {\"value\": {\"get_attr\": [\"random1\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',7),(233,'2025-12-16 15:53:08',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"key\": {\"value\": {\"get_attr\": [\"my_stack\", \"outputs\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',8),(234,'2025-12-16 15:53:09',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"remote_key\": {\"value\": {\"get_attr\": [\"random1\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',9),(239,'2025-12-16 15:53:29',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"key\": {\"value\": {\"get_attr\": [\"my_stack\", \"outputs\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',12),(240,'2025-12-16 15:53:29',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"remote_key\": {\"value\": {\"get_attr\": [\"random2\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',13),(242,'2025-12-16 15:53:38',NULL,'{\"heat_template_version\": \"2014-10-16\", \"parameters\": null, \"resources\": {}, \"outputs\": {\"resource_id\": {\"description\": \"ID of resource\", \"value\": {\"get_resource\": \"test_resource\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL);
/*!40000 ALTER TABLE `raw_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raw_template_files`
--

DROP TABLE IF EXISTS `raw_template_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `raw_template_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `files` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raw_template_files`
--

LOCK TABLES `raw_template_files` WRITE;
/*!40000 ALTER TABLE `raw_template_files` DISABLE KEYS */;
INSERT INTO `raw_template_files` (`id`, `files`, `created_at`, `updated_at`) VALUES (1,'{\"nested.yaml\": \"heat_template_version: \'2014-10-16\'\\nresources:\\n  foo_step1:\\n    type: OS::Heat::RandomString\\n  foo_step2:\\n    depends_on: foo_step1\\n    type: OS::Heat::RandomString\\n  foo_step3:\\n    depends_on: foo_step2\\n    type: OS::Heat::RandomString\\n\"}','2025-12-16 15:45:14',NULL),(3,'{\"1.yaml\": \"\\nheat_template_version: 2015-10-15\\nresources:\\n  test_resource_a:\\n    type: OS::Heat::TestResource\\n    properties:\\n      value: \'a\'\\n  test_resource_b:\\n    type: OS::Heat::TestResource\\n    properties:\\n      value: \'b\'\\noutputs:\\n  resource_output_a:\\n    description: \'Output of resource a\'\\n    value: { get_attr: [test_resource_a, output] }\\n  resource_output_b:\\n    description: \'Output of resource b\'\\n    value: { get_param: foo }\\n\"}','2025-12-16 15:46:03',NULL),(4,'{\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The base stack (containing an actual resource) for the remote deeply-nested\\\\nstack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"router\\\": {\\\"type\\\": \\\"OS::Neutron::Router\\\", \\\"properties\\\": {\\\"name\\\": {\\\"list_join\\\": [\\\"-\\\", [{\\\"get_param\\\": \\\"name\\\"}, \\\"router\\\"]]}, \\\"external_gateway_info\\\": {\\\"network\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_resource\\\": \\\"router\\\"}}}}\", \"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_intermediate.yaml\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The intermediate stack (containing a local nested stack) to be instantiated\\\\nremotely in the remote deeply-nested stack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The public network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"network_stack_as_custom_type\\\": {\\\"type\\\": \\\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\\\", \\\"properties\\\": {\\\"name\\\": {\\\"get_param\\\": \\\"name\\\"}, \\\"network_name\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_attr\\\": [\\\"network_stack_as_custom_type\\\", \\\"router\\\"]}}}}\"}','2025-12-16 15:50:04',NULL),(5,'{\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The base stack (containing an actual resource) for the remote deeply-nested\\\\nstack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"router\\\": {\\\"type\\\": \\\"OS::Neutron::Router\\\", \\\"properties\\\": {\\\"name\\\": {\\\"list_join\\\": [\\\"-\\\", [{\\\"get_param\\\": \\\"name\\\"}, \\\"router\\\"]]}, \\\"external_gateway_info\\\": {\\\"network\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_resource\\\": \\\"router\\\"}}}}\", \"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_intermediate.yaml\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The intermediate stack (containing a local nested stack) to be instantiated\\\\nremotely in the remote deeply-nested stack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The public network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"network_stack_as_custom_type\\\": {\\\"type\\\": \\\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\\\", \\\"properties\\\": {\\\"name\\\": {\\\"get_param\\\": \\\"name\\\"}, \\\"network_name\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_attr\\\": [\\\"network_stack_as_custom_type\\\", \\\"router\\\"]}}}}\"}','2025-12-16 15:50:06',NULL),(6,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}','2025-12-16 15:52:34',NULL),(7,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}','2025-12-16 15:52:35',NULL),(8,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}','2025-12-16 15:52:50',NULL),(9,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}','2025-12-16 15:52:51',NULL),(12,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random2:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random2, value]}\\n\"}','2025-12-16 15:53:24',NULL),(13,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random2:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random2, value]}\\n\"}','2025-12-16 15:53:25',NULL);
/*!40000 ALTER TABLE `raw_template_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource`
--

DROP TABLE IF EXISTS `resource`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `nova_instance` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  `rsrc_metadata` longtext DEFAULT NULL,
  `properties_data` longtext DEFAULT NULL,
  `engine_id` varchar(36) DEFAULT NULL,
  `atomic_key` int(11) DEFAULT NULL,
  `needed_by` longtext DEFAULT NULL,
  `requires` longtext DEFAULT NULL,
  `replaces` int(11) DEFAULT NULL,
  `replaced_by` int(11) DEFAULT NULL,
  `current_template_id` int(11) DEFAULT NULL,
  `properties_data_encrypted` tinyint(1) DEFAULT NULL,
  `root_stack_id` varchar(36) DEFAULT NULL,
  `rsrc_prop_data_id` int(11) DEFAULT NULL,
  `attr_data_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `stack_id` (`stack_id`),
  KEY `current_template_id` (`current_template_id`),
  KEY `ix_resource_root_stack_id` (`root_stack_id`),
  KEY `rsrc_rsrc_prop_data_ref` (`rsrc_prop_data_id`),
  KEY `rsrc_attr_data_ref` (`attr_data_id`),
  CONSTRAINT `resource_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`),
  CONSTRAINT `resource_ibfk_2` FOREIGN KEY (`current_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `rsrc_attr_data_ref` FOREIGN KEY (`attr_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `rsrc_rsrc_prop_data_ref` FOREIGN KEY (`rsrc_prop_data_id`) REFERENCES `resource_properties_data` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=232 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource`
--

LOCK TABLES `resource` WRITE;
/*!40000 ALTER TABLE `resource` DISABLE KEYS */;
INSERT INTO `resource` (`id`, `uuid`, `nova_instance`, `name`, `created_at`, `updated_at`, `action`, `status`, `status_reason`, `stack_id`, `rsrc_metadata`, `properties_data`, `engine_id`, `atomic_key`, `needed_by`, `requires`, `replaces`, `replaced_by`, `current_template_id`, `properties_data_encrypted`, `root_stack_id`, `rsrc_prop_data_id`, `attr_data_id`) VALUES (2,'27d8c173-0ea2-4930-90d7-e7b921445acd','api-1464377815-envstack-test-smaouit5rqlt','test','2025-12-16 15:43:46',NULL,'CREATE','COMPLETE','state changed','57b21988-2b6c-4d16-8c6b-498a33e6fb0f','{}','null',NULL,2,'[]','[]',NULL,NULL,3,NULL,'57b21988-2b6c-4d16-8c6b-498a33e6fb0f',2,NULL),(3,'e5752cb5-3cf1-4862-95c7-3c7cf5a79564','api-442899664-envstack-test-qyr46hsxklfv','test','2025-12-16 15:43:46',NULL,'CREATE','COMPLETE','state changed','bb7c0259-ff79-464c-b821-75f954c9a816','{}','null',NULL,2,'[]','[]',NULL,NULL,2,NULL,'bb7c0259-ff79-464c-b821-75f954c9a816',3,NULL),(4,'53c70831-66fd-401f-a21e-caee2f651851','api-813963596-envstack-test-ah3g7vj4ocbr','test','2025-12-16 15:43:47',NULL,'CREATE','COMPLETE','state changed','bdc8fd20-a3af-4063-992d-faddbf78cd2f','{}','null',NULL,2,'[]','[]',NULL,NULL,4,NULL,'bdc8fd20-a3af-4063-992d-faddbf78cd2f',4,NULL),(5,'cf3beeab-b816-4feb-a94a-0393da5c7eec','api-442899664-rsrcstack-test-725yc3htx3vl','test','2025-12-16 15:43:48',NULL,'CREATE','COMPLETE','state changed','61644de6-5a50-49ec-849e-4d04ca5001d1','{}','null',NULL,2,'[]','[]',NULL,NULL,5,NULL,'61644de6-5a50-49ec-849e-4d04ca5001d1',5,NULL),(6,'ea9c6e74-cbe1-4c1f-a90f-c4f619cb8201','api-813963596-rsrcstack-test-yh6l4hvjy3tu','test','2025-12-16 15:43:49',NULL,'CHECK','FAILED','resource deleted','c3e36837-2427-4bae-8974-8ed5fe929ded','{}','null',NULL,4,'[]','[]',NULL,NULL,6,NULL,'c3e36837-2427-4bae-8974-8ed5fe929ded',6,NULL),(7,'34ca556f-31dc-476c-99f6-da3e94a6eca3','api-1464377815-rsrcstack-test-o3br3q2muvlp','test','2025-12-16 15:43:51',NULL,'CHECK','FAILED','resource deleted','d86d5f46-7405-4fe4-a7fe-98b2c8ec7eea','{}','null',NULL,4,'[]','[]',NULL,NULL,8,NULL,'d86d5f46-7405-4fe4-a7fe-98b2c8ec7eea',7,NULL),(9,'5a0c0edc-5d1e-4e1b-92bc-0ec7c7627440','api-442899664-stack-test-4g25dznaydw4','test','2025-12-16 15:43:59','2025-12-16 15:44:02','UPDATE','COMPLETE','state changed','8606424d-0c4c-44e0-9d9d-aa9a306ff574','{}','null',NULL,4,'[]','[]',NULL,NULL,21,NULL,'8606424d-0c4c-44e0-9d9d-aa9a306ff574',12,NULL),(10,'437bde5a-30a8-4f4e-ae52-0374c3c6dac0','api-813963596-stack-test-6trqvbbxxxs2','test','2025-12-16 15:44:00','2025-12-16 15:44:10','UPDATE','COMPLETE','state changed','ff434bb3-7cc5-4848-9d1e-8f0f46ac0718','{}','null',NULL,6,'[]','[]',NULL,NULL,29,NULL,'ff434bb3-7cc5-4848-9d1e-8f0f46ac0718',23,NULL),(11,'1fa0bd88-5580-47f9-b23e-b769574069a8','api-1464377815-stack-test-p6kvqap2bpmi','test','2025-12-16 15:44:02','2025-12-16 15:44:07','UPDATE','COMPLETE','state changed','538c1c0b-52c5-4656-a5f6-52bdc8723cb7','{}','null',NULL,6,'[]','[]',NULL,NULL,28,NULL,'538c1c0b-52c5-4656-a5f6-52bdc8723cb7',18,NULL);
/*!40000 ALTER TABLE `resource` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_data`
--

DROP TABLE IF EXISTS `resource_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  `redact` tinyint(1) DEFAULT NULL,
  `decrypt_method` varchar(64) DEFAULT NULL,
  `resource_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_resource_id` (`resource_id`),
  CONSTRAINT `fk_resource_id` FOREIGN KEY (`resource_id`) REFERENCES `resource` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=253 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_data`
--

LOCK TABLES `resource_data` WRITE;
/*!40000 ALTER TABLE `resource_data` DISABLE KEYS */;
INSERT INTO `resource_data` (`id`, `created_at`, `updated_at`, `key`, `value`, `redact`, `decrypt_method`, `resource_id`) VALUES (2,'2025-12-16 15:43:46',NULL,'value','test',0,'',2),(3,'2025-12-16 15:43:47',NULL,'value','test',0,'',3),(4,'2025-12-16 15:43:47',NULL,'value','test',0,'',4),(5,'2025-12-16 15:43:48',NULL,'value','test',0,'',5),(6,'2025-12-16 15:43:49',NULL,'value','test',0,'',6),(7,'2025-12-16 15:43:51',NULL,'value','test',0,'',7),(9,'2025-12-16 15:43:59','2025-12-16 15:44:02','value','new_value',0,'',9),(10,'2025-12-16 15:44:00','2025-12-16 15:44:10','value','new_patched_value',0,'',10),(11,'2025-12-16 15:44:02','2025-12-16 15:44:07','value','new_patched_value',0,'',11);
/*!40000 ALTER TABLE `resource_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_properties_data`
--

DROP TABLE IF EXISTS `resource_properties_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource_properties_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `data` longtext DEFAULT NULL,
  `encrypted` tinyint(1) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=255 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_properties_data`
--

LOCK TABLES `resource_properties_data` WRITE;
/*!40000 ALTER TABLE `resource_properties_data` DISABLE KEYS */;
INSERT INTO `resource_properties_data` (`id`, `data`, `encrypted`, `created_at`, `updated_at`) VALUES (1,'{\"value\": \"test\"}',0,'2025-12-16 15:43:46',NULL),(2,'{\"value\": \"test\"}',0,'2025-12-16 15:43:46',NULL),(3,'{\"value\": \"test\"}',0,'2025-12-16 15:43:47',NULL),(4,'{\"value\": \"test\"}',0,'2025-12-16 15:43:47',NULL),(5,'{\"value\": \"test\"}',0,'2025-12-16 15:43:48',NULL),(6,'{\"value\": \"test\"}',0,'2025-12-16 15:43:49',NULL),(7,'{\"value\": \"test\"}',0,'2025-12-16 15:43:51',NULL),(8,'{\"value\": \"test\"}',0,'2025-12-16 15:43:51',NULL),(9,'{\"value\": \"value\"}',0,'2025-12-16 15:43:59',NULL),(10,'{\"value\": \"value\"}',0,'2025-12-16 15:44:00',NULL),(11,'{\"value\": \"value\"}',0,'2025-12-16 15:44:02',NULL),(12,'{\"value\": \"new_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2025-12-16 15:44:04',NULL),(13,'{\"value\": \"value\"}',0,'2025-12-16 15:44:04',NULL),(14,'{\"value\": \"new_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2025-12-16 15:44:05',NULL),(15,'{\"value\": \"new_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2025-12-16 15:44:06',NULL),(16,'{\"value\": \"new_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2025-12-16 15:44:07',NULL),(17,'{\"enable_dhcp\": false, \"network\": \"2ba0875f-b538-4f72-8cc4-68dc5554e198\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-12-16 15:44:08',NULL),(18,'{\"value\": \"new_patched_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2025-12-16 15:44:09',NULL),(19,'{\"network\": \"2ba0875f-b538-4f72-8cc4-68dc5554e198\", \"mac_address\": \"00-00-00-00-BB-BB\", \"fixed_ips\": [{\"subnet\": \"de7a866e-4c1c-433c-a14e-2d67e44ec573\", \"ip_address\": \"11.11.11.11\"}]}',0,'2025-12-16 15:44:09',NULL),(21,'{\"value\": \"Test1\", \"fail\": false}',0,'2025-12-16 15:44:11',NULL),(22,'{\"name\": \"my_encrypted_foo\", \"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\", \"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"networks\": [{\"network\": \"heat_tempestconf_network\"}]}',0,'2025-12-16 15:44:11',NULL),(23,'{\"value\": \"new_patched_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2025-12-16 15:44:12',NULL),(24,'{\"value\": \"new_patched_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2025-12-16 15:44:12',NULL),(25,'{\"name\": \"LUKS\"}',0,'2025-12-16 15:44:14',NULL),(26,'{\"provider\": \"nova.volume.encryptors.luks.LuksEncryptor\", \"control_location\": \"front-end\", \"cipher\": \"aes-xts-plain64\", \"key_size\": 512, \"volume_type\": \"d04bb176-d999-4187-87a7-3c1ee17cecb3\"}',0,'2025-12-16 15:44:14',NULL),(27,'{\"network\": \"2ba0875f-b538-4f72-8cc4-68dc5554e198\", \"mac_address\": \"00-00-00-00-BB-BB\", \"fixed_ips\": [{\"subnet\": \"de7a866e-4c1c-433c-a14e-2d67e44ec573\"}]}',0,'2025-12-16 15:44:15',NULL),(29,'{\"network\": \"7abadcb6-58cc-46e9-b83e-dc22c778e6a8\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2025-12-16 15:44:18',NULL),(30,'{\"provider\": \"nova.volume.encryptors.luks.LuksEncryptor\", \"control_location\": \"front-end\", \"cipher\": \"aes-cbc-essiv\", \"key_size\": 256, \"volume_type\": \"d04bb176-d999-4187-87a7-3c1ee17cecb3\"}',0,'2025-12-16 15:44:20',NULL),(32,'{\"network\": \"7abadcb6-58cc-46e9-b83e-dc22c778e6a8\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.100\"}]}',0,'2025-12-16 15:44:25',NULL),(33,'{\"enable_dhcp\": false, \"network\": \"988675ee-d62e-4a1c-b165-d59556789c7c\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-12-16 15:44:26',NULL),(34,'{\"network\": \"988675ee-d62e-4a1c-b165-d59556789c7c\", \"mac_address\": \"00-00-00-00-BB-BB\", \"fixed_ips\": [{\"subnet\": \"005da2bf-fde6-41c6-b433-07a99386645d\", \"ip_address\": \"11.11.11.11\"}]}',0,'2025-12-16 15:44:26',NULL),(37,'{\"value\": \"Test1\", \"fail\": false}',0,'2025-12-16 15:44:30',NULL),(38,'{\"network\": \"9e153c3a-e85a-4b7d-a89c-337a302db45c\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2025-12-16 15:44:36',NULL),(39,'{\"network\": \"988675ee-d62e-4a1c-b165-d59556789c7c\", \"mac_address\": \"00-00-00-00-AA-AA\", \"fixed_ips\": [{\"subnet\": \"005da2bf-fde6-41c6-b433-07a99386645d\", \"ip_address\": \"11.11.11.11\"}]}',0,'2025-12-16 15:44:37',NULL),(42,'{\"name\": \"server_with_port_net\"}',0,'2025-12-16 15:44:40',NULL),(43,'{\"network\": \"9e153c3a-e85a-4b7d-a89c-337a302db45c\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": []}',0,'2025-12-16 15:44:41',NULL),(44,'{\"network\": \"f378d5a5-e48e-46f1-aed5-87cc280c42e6\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-12-16 15:44:41',NULL),(45,'{\"network\": \"f378d5a5-e48e-46f1-aed5-87cc280c42e6\", \"fixed_ips\": [{\"subnet\": \"f0914cc6-fe72-49b0-9a1c-c542de5422d8\", \"ip_address\": \"11.11.11.11\"}]}',0,'2025-12-16 15:44:43',NULL),(46,'{\"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\", \"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"networks\": [{\"port\": \"c91e7f46-d34e-425c-bb07-8bf710b279d0\"}]}',0,'2025-12-16 15:44:44',NULL),(48,'{\"cidr\": \"10.10.0.0/16\", \"network\": \"0ca8ec8d-723c-4457-b398-3d5955310c13\"}',0,'2025-12-16 15:44:52',NULL),(49,'{\"cidr\": \"10.20.0.0/16\", \"network\": \"2cd1ce60-1078-4e20-b428-8b5d8ce8fe70\"}',0,'2025-12-16 15:44:52',NULL),(50,'{\"network\": \"dd0c9566-c4ee-48a9-b5e2-13a52faec3cf\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2025-12-16 15:44:53',NULL),(51,'{\"name\": \"trunk_sub_port_one\", \"network\": \"0ca8ec8d-723c-4457-b398-3d5955310c13\"}',0,'2025-12-16 15:44:53',NULL),(52,'{\"cidr\": \"10.0.0.0/16\", \"network\": \"533e452e-ba58-4d8c-a238-9a69e80d5bb6\"}',0,'2025-12-16 15:44:55',NULL),(53,'{\"name\": \"trunk_sub_port_two\", \"network\": \"2cd1ce60-1078-4e20-b428-8b5d8ce8fe70\"}',0,'2025-12-16 15:44:56',NULL),(55,'{\"name\": \"trunk_parent_port\", \"network\": \"533e452e-ba58-4d8c-a238-9a69e80d5bb6\"}',0,'2025-12-16 15:44:56',NULL),(56,'{\"name\": \"test_trunk\", \"port\": \"b8b6bf6f-631b-477d-aacc-4b6367ac72f1\", \"sub_ports\": [{\"port\": \"30d7f562-ba64-43b0-a732-b0e77b761876\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2025-12-16 15:44:57',NULL),(57,'{\"network\": \"dd0c9566-c4ee-48a9-b5e2-13a52faec3cf\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.9\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2025-12-16 15:44:58',NULL),(59,'{\"name\": \"my_net\"}',0,'2025-12-16 15:45:08',NULL),(60,'{\"network\": \"9180c4d8-8da9-4d71-a9bd-e8b674e4c693\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2025-12-16 15:45:09',NULL),(61,'{\"name\": \"the_sg\", \"description\": \"Ping and SSH\", \"rules\": [{\"protocol\": \"icmp\"}, {\"protocol\": \"tcp\", \"port_range_min\": 22, \"port_range_max\": 22}]}',0,'2025-12-16 15:45:09',NULL),(62,'{\"network\": \"5e9d93a8-0edf-4366-849d-4cdce659d7ff\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-12-16 15:45:10',NULL),(63,'{\"name\": \"test_trunk\", \"port\": \"b8b6bf6f-631b-477d-aacc-4b6367ac72f1\", \"sub_ports\": [{\"port\": \"30d7f562-ba64-43b0-a732-b0e77b761876\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}, {\"port\": \"09a6543a-a053-4d74-b407-85188bc8afb3\", \"segmentation_id\": 20, \"segmentation_type\": \"vlan\"}]}',0,'2025-12-16 15:45:10',NULL),(64,'{\"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\", \"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"networks\": [{\"subnet\": \"c724bacf-87a6-417b-9728-f0f393c13ee5\", \"fixed_ip\": \"11.11.11.11\"}], \"security_groups\": [\"3344d1af-601e-4d73-9366-76869ef76422\"]}',0,'2025-12-16 15:45:11',NULL),(67,'{\"network\": \"9180c4d8-8da9-4d71-a9bd-e8b674e4c693\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": null, \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2025-12-16 15:45:15',NULL),(69,'{\"network\": \"a5ef03ab-efa9-427a-b1a8-50fff1f527a0\", \"cidr\": \"10.10.0.0/16\"}',0,'2025-12-16 15:45:21',NULL),(70,'{\"network\": \"aa6f5415-3ace-472b-bbed-867e73e1c80f\", \"cidr\": \"10.20.0.0/16\"}',0,'2025-12-16 15:45:22',NULL),(71,'{\"network\": \"a5ef03ab-efa9-427a-b1a8-50fff1f527a0\", \"name\": \"trunk_sub_port_one\"}',0,'2025-12-16 15:45:22',NULL),(72,'{\"network\": \"f4e43340-6711-403b-bd8a-8f626953da7e\", \"cidr\": \"10.0.0.0/16\"}',0,'2025-12-16 15:45:22',NULL),(73,'{\"network\": \"aa6f5415-3ace-472b-bbed-867e73e1c80f\", \"name\": \"trunk_sub_port_two\"}',0,'2025-12-16 15:45:23',NULL),(74,'{\"network\": \"f4e43340-6711-403b-bd8a-8f626953da7e\", \"name\": \"trunk_parent_port\"}',0,'2025-12-16 15:45:24',NULL),(75,'{\"name\": \"test_trunk\", \"port\": \"def2457d-6f59-48ab-adda-200ebf60ac79\", \"sub_ports\": null}',0,'2025-12-16 15:45:25',NULL),(76,'{\"network\": \"27c8ec9f-3315-455d-9159-e9193f7de3fd\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2025-12-16 15:45:25',NULL),(79,'{\"network\": \"27c8ec9f-3315-455d-9159-e9193f7de3fd\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\"}',0,'2025-12-16 15:45:33',NULL),(81,'{\"name\": \"test_trunk\", \"port\": \"def2457d-6f59-48ab-adda-200ebf60ac79\", \"sub_ports\": [{\"port\": \"4744b553-17ed-4d47-bf14-5417484a7740\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2025-12-16 15:45:36',NULL),(83,'{\"name\": \"the_net\"}',0,'2025-12-16 15:45:42',NULL),(84,'{\"network\": \"3c4b0bbe-70fe-44a0-b21f-207a2bec29bc\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2025-12-16 15:45:43',NULL),(85,'{\"network\": \"4768f982-89e1-4200-835b-e7d7b8dfc57d\", \"cidr\": \"11.11.11.0/24\", \"name\": \"subnet_a\"}',0,'2025-12-16 15:45:45',NULL),(86,'{\"network\": \"4768f982-89e1-4200-835b-e7d7b8dfc57d\", \"cidr\": \"12.12.12.0/24\", \"name\": \"subnet_b\"}',0,'2025-12-16 15:45:45',NULL),(88,'{\"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\", \"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"networks\": [{\"subnet\": \"f6b995f7-acc8-421f-af3c-8ff5fdd1f7d9\"}]}',0,'2025-12-16 15:45:47',NULL),(89,'{\"network\": \"3c4b0bbe-70fe-44a0-b21f-207a2bec29bc\", \"cidr\": \"11.11.11.0/24\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2025-12-16 15:45:48',NULL),(90,'{\"cidr\": \"10.10.0.0/16\", \"network\": \"e68a87ac-d08c-4e62-b8d3-4e1c49892fa8\"}',0,'2025-12-16 15:45:51',NULL),(91,'{\"cidr\": \"10.20.0.0/16\", \"network\": \"497cbd63-9e9c-4cce-a0f2-fd39dc7e8149\"}',0,'2025-12-16 15:45:52',NULL),(93,'{\"name\": \"trunk_sub_port_one\", \"network\": \"e68a87ac-d08c-4e62-b8d3-4e1c49892fa8\"}',0,'2025-12-16 15:45:53',NULL),(94,'{\"cidr\": \"10.0.0.0/16\", \"network\": \"dd48bbb4-98c4-4bce-8f1b-d8ae7e245c9a\"}',0,'2025-12-16 15:45:53',NULL),(95,'{\"name\": \"trunk_sub_port_two\", \"network\": \"497cbd63-9e9c-4cce-a0f2-fd39dc7e8149\"}',0,'2025-12-16 15:45:54',NULL),(96,'{\"name\": \"trunk_parent_port\", \"network\": \"dd48bbb4-98c4-4bce-8f1b-d8ae7e245c9a\"}',0,'2025-12-16 15:45:55',NULL),(97,'{\"name\": \"test_trunk\", \"port\": \"80b28691-b2e3-476f-97a4-b7b3c34c30ca\", \"sub_ports\": [{\"port\": \"22970da7-630d-48de-8c48-1232de46054a\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2025-12-16 15:45:56',NULL),(98,'{\"value\": \"a\"}',0,'2025-12-16 15:45:58',NULL),(99,'{\"count\": 1, \"resource_def\": {\"type\": \"OS::Heat::RandomString\"}}',0,'2025-12-16 15:45:58',NULL),(100,'{\"value\": \"b\"}',0,'2025-12-16 15:45:59',NULL),(102,'{\"name\": \"test_trunk\", \"port\": \"80b28691-b2e3-476f-97a4-b7b3c34c30ca\", \"sub_ports\": []}',0,'2025-12-16 15:46:07',NULL),(104,'{\"count\": 2, \"resource_def\": {\"type\": \"OS::Heat::RandomString\"}}',0,'2025-12-16 15:46:10',NULL),(106,'{\"value\": \"a\"}',0,'2025-12-16 15:46:16',NULL),(107,'{\"value\": \"b\"}',0,'2025-12-16 15:46:17',NULL),(108,'{\"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\", \"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"networks\": [{\"subnet\": \"e674ccc0-7d4c-46f1-99f4-73e87c7f3440\"}]}',0,'2025-12-16 15:46:21',NULL),(110,'{\"cidr\": \"10.10.0.0/16\", \"network\": \"912786b5-4d96-4604-9200-4054360eefcd\"}',0,'2025-12-16 15:46:24',NULL),(111,'{\"cidr\": \"10.0.0.0/16\", \"network\": \"fcad9b20-c585-458b-9fc4-c4ff6a2c62dc\"}',0,'2025-12-16 15:46:25',NULL),(112,'{\"name\": \"trunk_sub_port_one\", \"network\": \"912786b5-4d96-4604-9200-4054360eefcd\"}',0,'2025-12-16 15:46:25',NULL),(113,'{\"cidr\": \"10.20.0.0/16\", \"network\": \"4092e016-5bd4-4d05-9e43-9adeafacfa5d\"}',0,'2025-12-16 15:46:26',NULL),(114,'{\"name\": \"trunk_parent_port\", \"network\": \"fcad9b20-c585-458b-9fc4-c4ff6a2c62dc\"}',0,'2025-12-16 15:46:27',NULL),(115,'{\"value\": \"foo\"}',0,'2025-12-16 15:46:27',NULL),(116,'{\"name\": \"trunk_sub_port_two\", \"network\": \"4092e016-5bd4-4d05-9e43-9adeafacfa5d\"}',0,'2025-12-16 15:46:27',NULL),(117,'{\"value\": \"foo\"}',0,'2025-12-16 15:46:28',NULL),(118,'{\"name\": \"test_trunk\", \"port\": \"d1514cc2-c0f7-4d13-8c0f-08db7d96cac1\", \"sub_ports\": [{\"port\": \"902f344c-b299-4b46-b8bf-adb92a77a93a\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}, {\"port\": \"c4df6435-8872-47d2-a7e5-556badfc04d7\", \"segmentation_id\": 20, \"segmentation_type\": \"vlan\"}]}',0,'2025-12-16 15:46:28',NULL),(119,'{\"value\": \"Test1\"}',0,'2025-12-16 15:46:30',NULL),(120,'{\"value\": \"Test2\"}',0,'2025-12-16 15:46:30',NULL),(121,'{\"length\": 10}',0,'2025-12-16 15:46:34',NULL),(122,'{\"value\": \"Test1\"}',0,'2025-12-16 15:46:36',NULL),(123,'{\"value\": \"Test2\"}',0,'2025-12-16 15:46:36',NULL),(124,'{\"name\": \"test_trunk\", \"port\": \"d1514cc2-c0f7-4d13-8c0f-08db7d96cac1\", \"sub_ports\": [{\"port\": \"902f344c-b299-4b46-b8bf-adb92a77a93a\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2025-12-16 15:46:39',NULL),(126,'{\"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\", \"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"user_data_format\": \"SOFTWARE_CONFIG\", \"networks\": [{\"network\": \"heat_tempestconf_network\"}]}',0,'2025-12-16 15:46:45',NULL),(127,'{\"name\": \"the_net\"}',0,'2025-12-16 15:46:45',NULL),(128,'{\"name\": \"the_subnet\", \"network\": \"23494041-f651-4d38-bdd8-f795ef41c456\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-12-16 15:46:46',NULL),(129,'{\"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\", \"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"networks\": [{\"subnet\": \"283b9a23-d171-469e-8baa-b374439a4388\"}]}',0,'2025-12-16 15:46:48',NULL),(130,'{\"cidr\": \"10.10.0.0/16\", \"network\": \"c3c765ed-09fc-431f-bfb4-1d5631f8909f\"}',0,'2025-12-16 15:46:54',NULL),(131,'{\"cidr\": \"10.20.0.0/16\", \"network\": \"83861d7c-305e-4e04-bda8-c992e55ea6bc\"}',0,'2025-12-16 15:46:55',NULL),(132,'{\"cidr\": \"10.0.0.0/16\", \"network\": \"dc1985da-5cb3-40e2-93d3-5de234bbbd5f\"}',0,'2025-12-16 15:46:56',NULL),(133,'{\"name\": \"trunk_sub_port_one\", \"network\": \"c3c765ed-09fc-431f-bfb4-1d5631f8909f\"}',0,'2025-12-16 15:46:56',NULL),(134,'{\"name\": \"trunk_sub_port_two\", \"network\": \"83861d7c-305e-4e04-bda8-c992e55ea6bc\"}',0,'2025-12-16 15:46:57',NULL),(135,'{\"name\": \"trunk_parent_port\", \"network\": \"dc1985da-5cb3-40e2-93d3-5de234bbbd5f\"}',0,'2025-12-16 15:46:58',NULL),(136,'{\"name\": \"test_trunk\", \"port\": \"0f592a27-5b60-4215-8729-c9c3594e0ce6\", \"sub_ports\": [{\"port\": \"04089cf6-3387-4902-916c-0f03749b91b8\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2025-12-16 15:46:58',NULL),(137,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2025-12-16 15:46:59',NULL),(138,'{\"config\": \"1ef18178-43af-4577-b255-a43922f9655b\", \"servers\": {\"0\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}}',0,'2025-12-16 15:46:59',NULL),(139,'{\"config\": \"1ef18178-43af-4577-b255-a43922f9655b\", \"servers\": {\"0\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}}',0,'2025-12-16 15:46:59',NULL),(140,'{\"config\": \"1ef18178-43af-4577-b255-a43922f9655b\", \"servers\": {\"0\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}}',0,'2025-12-16 15:46:59',NULL),(141,'{\"config\": \"1ef18178-43af-4577-b255-a43922f9655b\", \"servers\": {\"0\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}}',0,'2025-12-16 15:46:59',NULL),(142,'{\"config\": \"1ef18178-43af-4577-b255-a43922f9655b\", \"servers\": {\"0\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}}',0,'2025-12-16 15:46:59',NULL),(143,'{\"config\": \"1ef18178-43af-4577-b255-a43922f9655b\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}',0,'2025-12-16 15:46:59',NULL),(144,'{\"config\": \"1ef18178-43af-4577-b255-a43922f9655b\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}',0,'2025-12-16 15:46:59',NULL),(145,'{\"config\": \"1ef18178-43af-4577-b255-a43922f9655b\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}',0,'2025-12-16 15:46:59',NULL),(146,'{\"config\": \"1ef18178-43af-4577-b255-a43922f9655b\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}',0,'2025-12-16 15:46:59',NULL),(147,'{\"config\": \"1ef18178-43af-4577-b255-a43922f9655b\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}',0,'2025-12-16 15:46:59',NULL),(148,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2025-12-16 15:47:00',NULL),(149,'{\"config\": \"99fb65cf-4365-49e1-8020-908c27816470\", \"servers\": {\"0\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}}',0,'2025-12-16 15:47:00',NULL),(150,'{\"config\": \"99fb65cf-4365-49e1-8020-908c27816470\", \"servers\": {\"0\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}}',0,'2025-12-16 15:47:00',NULL),(151,'{\"config\": \"99fb65cf-4365-49e1-8020-908c27816470\", \"servers\": {\"0\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}}',0,'2025-12-16 15:47:01',NULL),(152,'{\"config\": \"99fb65cf-4365-49e1-8020-908c27816470\", \"servers\": {\"0\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}}',0,'2025-12-16 15:47:01',NULL),(153,'{\"config\": \"99fb65cf-4365-49e1-8020-908c27816470\", \"servers\": {\"0\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}}',0,'2025-12-16 15:47:01',NULL),(154,'{\"config\": \"99fb65cf-4365-49e1-8020-908c27816470\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}',0,'2025-12-16 15:47:01',NULL),(155,'{\"config\": \"99fb65cf-4365-49e1-8020-908c27816470\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}',0,'2025-12-16 15:47:01',NULL),(156,'{\"config\": \"99fb65cf-4365-49e1-8020-908c27816470\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}',0,'2025-12-16 15:47:01',NULL),(157,'{\"config\": \"99fb65cf-4365-49e1-8020-908c27816470\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}',0,'2025-12-16 15:47:01',NULL),(158,'{\"config\": \"99fb65cf-4365-49e1-8020-908c27816470\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}',0,'2025-12-16 15:47:01',NULL),(160,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2025-12-16 15:47:06',NULL),(161,'{\"config\": \"c2803206-ff5d-4f45-add9-94708ecd153c\", \"servers\": {\"0\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}}',0,'2025-12-16 15:47:06',NULL),(162,'{\"config\": \"c2803206-ff5d-4f45-add9-94708ecd153c\", \"servers\": {\"0\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}}',0,'2025-12-16 15:47:06',NULL),(163,'{\"config\": \"c2803206-ff5d-4f45-add9-94708ecd153c\", \"servers\": {\"0\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}}',0,'2025-12-16 15:47:06',NULL),(164,'{\"config\": \"c2803206-ff5d-4f45-add9-94708ecd153c\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}',0,'2025-12-16 15:47:06',NULL),(165,'{\"config\": \"c2803206-ff5d-4f45-add9-94708ecd153c\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}',0,'2025-12-16 15:47:06',NULL),(166,'{\"config\": \"c2803206-ff5d-4f45-add9-94708ecd153c\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}',0,'2025-12-16 15:47:06',NULL),(167,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2025-12-16 15:47:07',NULL),(168,'{\"config\": \"39586321-3a89-43ba-9a93-9d92a3aa0ce0\", \"servers\": {\"0\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}}',0,'2025-12-16 15:47:07',NULL),(169,'{\"config\": \"39586321-3a89-43ba-9a93-9d92a3aa0ce0\", \"servers\": {\"0\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}}',0,'2025-12-16 15:47:07',NULL),(170,'{\"config\": \"39586321-3a89-43ba-9a93-9d92a3aa0ce0\", \"servers\": {\"0\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}}',0,'2025-12-16 15:47:07',NULL),(171,'{\"name\": \"test_trunk\", \"port\": \"0f592a27-5b60-4215-8729-c9c3594e0ce6\", \"sub_ports\": [{\"port\": \"04089cf6-3387-4902-916c-0f03749b91b8\", \"segmentation_id\": 99, \"segmentation_type\": \"vlan\"}]}',0,'2025-12-16 15:47:07',NULL),(172,'{\"config\": \"39586321-3a89-43ba-9a93-9d92a3aa0ce0\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}',0,'2025-12-16 15:47:07',NULL),(173,'{\"config\": \"39586321-3a89-43ba-9a93-9d92a3aa0ce0\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}',0,'2025-12-16 15:47:07',NULL),(174,'{\"config\": \"39586321-3a89-43ba-9a93-9d92a3aa0ce0\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}',0,'2025-12-16 15:47:07',NULL),(175,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2025-12-16 15:47:09',NULL),(176,'{\"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\", \"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"networks\": [{\"network\": \"23494041-f651-4d38-bdd8-f795ef41c456\", \"subnet\": \"283b9a23-d171-469e-8baa-b374439a4388\"}]}',0,'2025-12-16 15:47:09',NULL),(177,'{\"config\": \"d4fb3320-1c65-424f-819b-1508b2cf5132\", \"servers\": {\"0\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}}',0,'2025-12-16 15:47:09',NULL),(178,'{\"config\": \"d4fb3320-1c65-424f-819b-1508b2cf5132\", \"servers\": {\"0\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}}',0,'2025-12-16 15:47:09',NULL),(179,'{\"config\": \"d4fb3320-1c65-424f-819b-1508b2cf5132\", \"servers\": {\"0\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}}',0,'2025-12-16 15:47:09',NULL),(180,'{\"config\": \"d4fb3320-1c65-424f-819b-1508b2cf5132\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}',0,'2025-12-16 15:47:09',NULL),(181,'{\"config\": \"d4fb3320-1c65-424f-819b-1508b2cf5132\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}',0,'2025-12-16 15:47:09',NULL),(182,'{\"config\": \"d4fb3320-1c65-424f-819b-1508b2cf5132\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"6ff592d2-64da-422f-be47-7488a1aa9068\"}',0,'2025-12-16 15:47:09',NULL),(185,'{\"network\": \"ae45907c-8899-46e5-bf8f-77b32a65291c\", \"cidr\": \"10.10.0.0/16\"}',0,'2025-12-16 15:47:25',NULL),(186,'{\"network\": \"4c6b9260-6e80-4e1a-bacf-5696e9e3cb7b\", \"cidr\": \"10.0.0.0/16\"}',0,'2025-12-16 15:47:25',NULL),(187,'{\"network\": \"ae45907c-8899-46e5-bf8f-77b32a65291c\", \"name\": \"trunk_sub_port_one\"}',0,'2025-12-16 15:47:28',NULL),(188,'{\"network\": \"048ba4a7-d19f-400a-8ff4-cffb5d1d3345\", \"cidr\": \"10.20.0.0/16\"}',0,'2025-12-16 15:47:28',NULL),(189,'{\"network\": \"4c6b9260-6e80-4e1a-bacf-5696e9e3cb7b\", \"name\": \"trunk_parent_port\"}',0,'2025-12-16 15:47:29',NULL),(190,'{\"network\": \"048ba4a7-d19f-400a-8ff4-cffb5d1d3345\", \"name\": \"trunk_sub_port_two\"}',0,'2025-12-16 15:47:29',NULL),(191,'{\"name\": \"the_net\"}',0,'2025-12-16 15:47:29',NULL),(192,'{\"name\": \"test_trunk\", \"port\": \"25601d8d-dab4-446a-b13b-51e838b40f3a\", \"sub_ports\": null}',0,'2025-12-16 15:47:30',NULL),(193,'{\"name\": \"the_subnet\", \"network\": \"186dc40e-8340-42bb-b8c7-8f0a3d40e539\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-12-16 15:47:30',NULL),(194,'{\"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\", \"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"networks\": [{\"network\": \"186dc40e-8340-42bb-b8c7-8f0a3d40e539\"}]}',0,'2025-12-16 15:47:31',NULL),(195,'{\"description\": \"This is a test trunk\", \"name\": \"pineapple\", \"port\": \"25601d8d-dab4-446a-b13b-51e838b40f3a\", \"sub_ports\": null}',0,'2025-12-16 15:47:38',NULL),(198,'{\"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\", \"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"networks\": [{\"network\": \"186dc40e-8340-42bb-b8c7-8f0a3d40e539\", \"fixed_ip\": \"11.11.11.9\"}]}',0,'2025-12-16 15:47:53',NULL),(199,'{\"wait_secs\": 1, \"value\": \"test\"}',0,'2025-12-16 15:47:57',NULL),(201,'{\"wait_secs\": 1, \"value\": \"test\"}',0,'2025-12-16 15:48:08',NULL),(202,'{\"name\": \"the_net\"}',0,'2025-12-16 15:48:12',NULL),(203,'{\"name\": \"the_subnet\", \"network\": \"f0043a08-afd4-4678-8421-44da438726fe\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-12-16 15:48:12',NULL),(204,'{\"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\", \"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"networks\": [{\"network\": \"f0043a08-afd4-4678-8421-44da438726fe\"}]}',0,'2025-12-16 15:48:15',NULL),(205,'{\"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\", \"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"user_data_format\": \"SOFTWARE_CONFIG\", \"networks\": [{\"network\": \"heat_tempestconf_network\"}]}',0,'2025-12-16 15:48:17',NULL),(206,'{\"wait_secs\": 1, \"value\": \"next\"}',0,'2025-12-16 15:48:18',NULL),(207,'{\"wait_secs\": 1, \"value\": \"none\"}',0,'2025-12-16 15:48:23',NULL),(208,'{\"length\": 10}',0,'2025-12-16 15:48:34',NULL),(209,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2025-12-16 15:48:35',NULL),(210,'{\"config\": \"6967c451-f021-42cd-8651-7c7a654e2fc5\", \"servers\": {\"0\": \"1b2ae6fb-2f83-44b7-a283-cc4cec490f5f\"}}',0,'2025-12-16 15:48:35',NULL),(211,'{\"config\": \"6967c451-f021-42cd-8651-7c7a654e2fc5\", \"servers\": {\"0\": \"1b2ae6fb-2f83-44b7-a283-cc4cec490f5f\"}}',0,'2025-12-16 15:48:35',NULL),(212,'{\"config\": \"6967c451-f021-42cd-8651-7c7a654e2fc5\", \"servers\": {\"0\": \"1b2ae6fb-2f83-44b7-a283-cc4cec490f5f\"}}',0,'2025-12-16 15:48:35',NULL),(214,'{\"config\": \"6967c451-f021-42cd-8651-7c7a654e2fc5\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"1b2ae6fb-2f83-44b7-a283-cc4cec490f5f\"}',0,'2025-12-16 15:48:35',NULL),(215,'{\"config\": \"6967c451-f021-42cd-8651-7c7a654e2fc5\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"1b2ae6fb-2f83-44b7-a283-cc4cec490f5f\"}',0,'2025-12-16 15:48:35',NULL),(216,'{\"config\": \"6967c451-f021-42cd-8651-7c7a654e2fc5\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"1b2ae6fb-2f83-44b7-a283-cc4cec490f5f\"}',0,'2025-12-16 15:48:35',NULL),(217,'{\"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\", \"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"networks\": [{\"network\": \"f0043a08-afd4-4678-8421-44da438726fe\", \"subnet\": \"50b03234-1f80-4dd2-b1dd-e0e4ce4c7eaa\"}]}',0,'2025-12-16 15:48:41',NULL),(219,'{\"name\": \"the_net\"}',0,'2025-12-16 15:49:01',NULL),(220,'{\"name\": \"the_subnet\", \"network\": \"c3ff3bcd-bdf9-43e0-81e4-483c30d44f37\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-12-16 15:49:02',NULL),(221,'{\"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\", \"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"networks\": [{\"network\": \"c3ff3bcd-bdf9-43e0-81e4-483c30d44f37\"}, {\"network\": \"c3ff3bcd-bdf9-43e0-81e4-483c30d44f37\", \"fixed_ip\": \"11.11.11.33\"}, {\"subnet\": \"8b4acda8-764f-427b-8461-f7a41f38ecb9\"}]}',0,'2025-12-16 15:49:04',NULL),(223,'{\"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\", \"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"networks\": [{\"subnet\": \"8b4acda8-764f-427b-8461-f7a41f38ecb9\"}, {\"network\": \"c3ff3bcd-bdf9-43e0-81e4-483c30d44f37\"}, {\"network\": \"c3ff3bcd-bdf9-43e0-81e4-483c30d44f37\", \"subnet\": \"8b4acda8-764f-427b-8461-f7a41f38ecb9\"}]}',0,'2025-12-16 15:49:46',NULL),(225,'{\"update_replace\": false, \"wait_secs\": 0, \"value\": \"Test1\", \"fail\": false}',0,'2025-12-16 15:49:57',NULL),(226,'{\"context\": {\"region_name\": \"regionOne\"}, \"parameters\": {\"name\": \"remote-nested\", \"network_name\": \"public\"}, \"template\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The intermediate stack (containing a local nested stack) to be instantiated\\\\nremotely in the remote deeply-nested stack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The public network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"network_stack_as_custom_type\\\": {\\\"type\\\": \\\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\\\", \\\"properties\\\": {\\\"name\\\": {\\\"get_param\\\": \\\"name\\\"}, \\\"network_name\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_attr\\\": [\\\"network_stack_as_custom_type\\\", \\\"router\\\"]}}}}\"}',0,'2025-12-16 15:50:05',NULL),(227,'{\"name\": \"remote-nested\", \"network_name\": \"public\"}',0,'2025-12-16 15:50:07',NULL),(228,'{\"name\": \"remote-nested-router\", \"external_gateway_info\": {\"network\": \"public\"}}',0,'2025-12-16 15:50:08',NULL),(229,'{\"name\": \"the_net\"}',0,'2025-12-16 15:50:09',NULL),(230,'{\"name\": \"the_subnet\", \"network\": \"9cd91509-ea97-4436-87a4-2f533f7f8645\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-12-16 15:50:11',NULL),(232,'{\"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\", \"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"networks\": [{\"network\": \"9cd91509-ea97-4436-87a4-2f533f7f8645\"}]}',0,'2025-12-16 15:50:13',NULL),(235,'{\"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\", \"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"networks\": [{\"port\": \"82532e23-fe08-47e9-b025-244c3866c69e\"}]}',0,'2025-12-16 15:50:40',NULL),(237,'{\"name\": \"the_net\"}',0,'2025-12-16 15:50:49',NULL),(238,'{\"name\": \"the_subnet\", \"network\": \"bf176080-a3d9-4ac0-b5a5-11f582703c71\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-12-16 15:50:52',NULL),(239,'{\"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\", \"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"networks\": [{\"network\": \"bf176080-a3d9-4ac0-b5a5-11f582703c71\"}]}',0,'2025-12-16 15:50:54',NULL),(241,'{\"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\", \"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"networks\": [{\"subnet\": \"57c9b6c8-a043-4415-bec1-676a185df6cd\"}]}',0,'2025-12-16 15:51:15',NULL),(243,'{\"name\": \"the_net\"}',0,'2025-12-16 15:51:37',NULL),(244,'{\"name\": \"the_subnet\", \"network\": \"6fbc67b3-e8bb-40e7-8269-7e09473fed7d\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-12-16 15:51:38',NULL),(245,'{\"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\", \"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"networks\": [{\"subnet\": \"0ceca7ff-6710-48b2-ad32-4228a903d760\"}]}',0,'2025-12-16 15:51:39',NULL),(247,'{\"image\": \"8d3807d2-80b9-4410-b94e-b58593119409\", \"flavor\": \"9a00e7a1-3353-4862-b57a-bd1661304076\", \"networks\": [{\"network\": \"6fbc67b3-e8bb-40e7-8269-7e09473fed7d\"}]}',0,'2025-12-16 15:52:11',NULL),(249,'{\"context\": {\"region_name\": \"regionOne\"}, \"template\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}',0,'2025-12-16 15:52:35',NULL),(251,'{\"context\": {\"region_name\": \"regionOne\"}, \"template\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}',0,'2025-12-16 15:52:51',NULL),(252,'{\"context\": {\"region_name\": \"regionOne\"}, \"template\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}',0,'2025-12-16 15:53:17',NULL),(253,'{\"context\": {\"region_name\": \"regionOne\"}, \"template\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random2:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random2, value]}\\n\"}',0,'2025-12-16 15:53:27',NULL),(254,'{\"value\": \"test1\", \"fail\": false, \"update_replace\": false, \"wait_secs\": 0}',0,'2025-12-16 15:53:36',NULL);
/*!40000 ALTER TABLE `resource_properties_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(36) NOT NULL,
  `engine_id` varchar(36) NOT NULL,
  `host` varchar(255) NOT NULL,
  `hostname` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `topic` varchar(255) NOT NULL,
  `report_interval` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `engine_id`, `host`, `hostname`, `binary`, `topic`, `report_interval`, `created_at`, `updated_at`, `deleted_at`) VALUES ('14e9a11a-accb-4b3e-80a8-11b332af267f','b9bb854c-6c17-4654-b580-a84f665f9c63','heat-engine-59fcc7f56d-krpcl','heat-engine-59fcc7f56d-krpcl','heat-engine','engine',60,'2025-12-16 15:16:37','2025-12-16 16:05:38',NULL),('4348074f-9aae-4f3b-9f18-20bfc702cc35','357d6517-8346-4504-af65-67ddd992ffb9','heat-engine-c49bc9464-wb445','heat-engine-c49bc9464-wb445','heat-engine','engine',60,'2025-12-16 15:16:36','2025-12-16 15:16:59','2025-12-16 15:16:59'),('7f3ccb8b-bb8e-4112-9266-ca254186cd31','110a37a6-a8f5-4841-9719-567d884b6d4e','heat-engine-c49bc9464-wb445','heat-engine-c49bc9464-wb445','heat-engine','engine',60,'2025-12-16 15:16:36','2025-12-16 15:16:59','2025-12-16 15:16:59'),('bee2ff1d-8eca-4001-a8bf-e10cf200c3b0','5a8548a3-b3f3-469b-aacf-a7d21369302d','heat-engine-c49bc9464-wb445','heat-engine-c49bc9464-wb445','heat-engine','engine',60,'2025-12-16 15:16:36','2025-12-16 15:16:59','2025-12-16 15:16:59'),('c1188140-73e4-49a7-b49a-08751a84808b','37f13baf-83b1-4dfc-906f-6b062cd13bc9','heat-engine-59fcc7f56d-krpcl','heat-engine-59fcc7f56d-krpcl','heat-engine','engine',60,'2025-12-16 15:16:37','2025-12-16 16:05:38',NULL),('d5e5f769-6303-4c6c-a5b7-dc96b42d979d','19cf5904-9dc9-485a-ae12-9ef8e9607647','heat-engine-c49bc9464-wb445','heat-engine-c49bc9464-wb445','heat-engine','engine',60,'2025-12-16 15:16:36','2025-12-16 15:16:59','2025-12-16 15:16:59'),('ee9fbaae-2888-45ce-8898-08d94c4b9426','15ff09b3-2cc2-48e7-b75f-3221c0a51a30','heat-engine-59fcc7f56d-krpcl','heat-engine-59fcc7f56d-krpcl','heat-engine','engine',60,'2025-12-16 15:16:37','2025-12-16 16:05:38',NULL),('f4b83fa4-34cd-4fd8-b51c-2ba911a89986','fa0d6495-4a7d-4c03-932c-dbeed9282c9f','heat-engine-59fcc7f56d-krpcl','heat-engine-59fcc7f56d-krpcl','heat-engine','engine',60,'2025-12-16 15:16:37','2025-12-16 16:05:38',NULL);
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot`
--

DROP TABLE IF EXISTS `snapshot`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot` (
  `id` varchar(36) NOT NULL,
  `stack_id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` varchar(255) DEFAULT NULL,
  `data` longtext DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stack_id` (`stack_id`),
  KEY `ix_snapshot_tenant` (`tenant`),
  CONSTRAINT `snapshot_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot`
--

LOCK TABLES `snapshot` WRITE;
/*!40000 ALTER TABLE `snapshot` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `software_config`
--

DROP TABLE IF EXISTS `software_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `software_config` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `group` varchar(255) DEFAULT NULL,
  `config` longtext DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_software_config_tenant` (`tenant`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `software_config`
--

LOCK TABLES `software_config` WRITE;
/*!40000 ALTER TABLE `software_config` DISABLE KEYS */;
INSERT INTO `software_config` (`id`, `created_at`, `updated_at`, `name`, `group`, `config`, `tenant`) VALUES ('4a9e64e0-efa4-4c0a-ba14-7ed3ad135bb2','2025-12-16 15:43:59',NULL,'api-902272075-config','script','{\"inputs\": [], \"outputs\": [], \"options\": {}, \"config\": \"#!/bin/sh -x\\\\necho hello\"}','a1d76f472c5c41faa4158134dd714a29'),('ea3b0dad-0012-4231-8836-ad57937cac99','2025-12-16 15:43:52',NULL,'api-813963596-config','script','{\"inputs\": [], \"outputs\": [], \"options\": {}, \"config\": \"#!/bin/sh -x\\\\necho hello\"}','a1d76f472c5c41faa4158134dd714a29'),('f072a321-3767-4421-a977-5b81648efee0','2025-12-16 15:43:50',NULL,'api-442899664-config','script','{\"inputs\": [], \"outputs\": [], \"options\": {}, \"config\": \"#!/bin/sh -x\\\\necho hello\"}','a1d76f472c5c41faa4158134dd714a29');
/*!40000 ALTER TABLE `software_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `software_deployment`
--

DROP TABLE IF EXISTS `software_deployment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `software_deployment` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `server_id` varchar(36) NOT NULL,
  `config_id` varchar(36) NOT NULL,
  `input_values` longtext DEFAULT NULL,
  `output_values` longtext DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  `stack_user_project_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `config_id` (`config_id`),
  KEY `ix_software_deployment_created_at` (`created_at`),
  KEY `ix_software_deployment_tenant` (`tenant`),
  KEY `ix_software_deployment_server_id` (`server_id`),
  CONSTRAINT `software_deployment_ibfk_1` FOREIGN KEY (`config_id`) REFERENCES `software_config` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `software_deployment`
--

LOCK TABLES `software_deployment` WRITE;
/*!40000 ALTER TABLE `software_deployment` DISABLE KEYS */;
INSERT INTO `software_deployment` (`id`, `created_at`, `updated_at`, `server_id`, `config_id`, `input_values`, `output_values`, `action`, `status`, `status_reason`, `tenant`, `stack_user_project_id`) VALUES ('35f5a19b-391c-4a04-9043-21ae52dad8de','2025-12-16 15:43:51','2025-12-16 15:43:52','dummy_server','f072a321-3767-4421-a977-5b81648efee0','{}','null','ACTION1','COMPLETE','completed','a1d76f472c5c41faa4158134dd714a29',NULL),('a67f373b-10d0-4975-bd36-c2bffa8ca155','2025-12-16 15:43:54',NULL,'dummy_server','ea3b0dad-0012-4231-8836-ad57937cac99','{}','null','ACTION0',NULL,'None','a1d76f472c5c41faa4158134dd714a29',NULL);
/*!40000 ALTER TABLE `software_deployment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack`
--

DROP TABLE IF EXISTS `stack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `raw_template_id` int(11) NOT NULL,
  `prev_raw_template_id` int(11) DEFAULT NULL,
  `user_creds_id` int(11) DEFAULT NULL,
  `username` varchar(256) DEFAULT NULL,
  `owner_id` varchar(36) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `timeout` int(11) DEFAULT NULL,
  `tenant` varchar(256) DEFAULT NULL,
  `disable_rollback` tinyint(1) NOT NULL,
  `stack_user_project_id` varchar(64) DEFAULT NULL,
  `backup` tinyint(1) DEFAULT NULL,
  `nested_depth` int(11) DEFAULT NULL,
  `convergence` tinyint(1) DEFAULT NULL,
  `current_traversal` varchar(36) DEFAULT NULL,
  `current_deps` longtext DEFAULT NULL,
  `parent_resource_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_template_id` (`raw_template_id`),
  KEY `prev_raw_template_id` (`prev_raw_template_id`),
  KEY `user_creds_id` (`user_creds_id`),
  KEY `ix_stack_owner_id` (`owner_id`),
  KEY `ix_stack_name` (`name`),
  KEY `ix_stack_tenant` (`tenant`(255)),
  CONSTRAINT `stack_ibfk_1` FOREIGN KEY (`raw_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `stack_ibfk_2` FOREIGN KEY (`prev_raw_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `stack_ibfk_3` FOREIGN KEY (`user_creds_id`) REFERENCES `user_creds` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack`
--

LOCK TABLES `stack` WRITE;
/*!40000 ALTER TABLE `stack` DISABLE KEYS */;
INSERT INTO `stack` (`id`, `created_at`, `updated_at`, `deleted_at`, `name`, `raw_template_id`, `prev_raw_template_id`, `user_creds_id`, `username`, `owner_id`, `action`, `status`, `status_reason`, `timeout`, `tenant`, `disable_rollback`, `stack_user_project_id`, `backup`, `nested_depth`, `convergence`, `current_traversal`, `current_deps`, `parent_resource_name`) VALUES ('02a74aa1-045e-4e27-8526-21195d65f316','2025-12-16 15:46:29','2025-12-16 15:46:30','2025-12-16 15:46:31','ResourcesList-1396389386',114,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'3883d257d82047b18ddeea20ba6dc6d3',0,0,1,'1c83b3e0-a207-46f5-8df3-0faacbb6ff6a','{\"edges\": [[[116, false], [115, false]]]}',NULL),('05fdd3ab-69bd-4a63-9ace-ba29648e3fce','2025-12-16 15:45:57','2025-12-16 15:46:10','2025-12-16 15:46:13','StackOutputsTest-958285426',98,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'06cb2b5438d84fb3b4b69a66ae5e82de',0,0,1,'a108262f-a8ac-4c43-9d57-8270196977dc','{\"edges\": [[[92, false], null]]}',NULL),('077f54b0-6d90-44a3-8b30-79dba984ecf6','2025-12-16 15:50:48','2025-12-16 15:51:23','2025-12-16 15:51:30','swap_network_subnet',221,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'de192c2956d948d49527668744f4f257',0,0,1,'7e62905f-b36b-4d05-b1f1-4a6e7eacb13c','{\"edges\": [[[219, false], [218, false]], [[218, false], [217, false]]]}',NULL),('08ee559b-7930-4499-beaf-db872d98e2e0','2025-12-16 15:44:17','2025-12-16 15:44:29','2025-12-16 15:44:32','UpdateSubnetTest-966863901',41,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'b8632f5d854c4037bf2a15b946b5f6ed',0,0,1,'dd031962-aca0-4451-ab78-651e9c16ce9a','{\"edges\": [[[21, false], [20, false]]]}',NULL),('09858d30-a346-46a6-9cec-34353693ccc8','2025-12-16 15:47:09','2025-12-16 15:47:31','2025-12-16 15:47:32','ParallelDeploymentsTest-1219149794-dep_1-4tkg2xu6xebi',158,NULL,NULL,'demo_tempestconf','bdd251f1-d1ac-4e1c-b9db-eb87ee880162','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'55432981b5d74422bdbe9751541e9c69',0,1,1,'f2a0ec6c-c245-4d52-8905-fb0a6f19cd3f','{\"edges\": [[[177, false], null]]}','dep_1'),('0b946e60-1c76-4965-bea2-b0311d7ecb3d','2025-12-16 15:47:06','2025-12-16 15:47:48','2025-12-16 15:47:49','ParallelDeploymentsTest-1451864420-dep_0-ki2ca4j6eite',166,NULL,NULL,'demo_tempestconf','8cbe1304-65fc-48b3-867d-2eecb51467cb','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'8b7821b2d01143c585c7fab254d28764',0,1,1,'4d2bcd2d-009d-4867-892b-5fe8995c77c5','{\"edges\": [[[165, false], null]]}','dep_0'),('0e8521aa-fdb8-4bc8-9cd7-014feb606679','2025-12-16 15:47:09','2025-12-16 15:47:30','2025-12-16 15:47:31','ParallelDeploymentsTest-1219149794-dep_2-pz4htxfr3vh7',157,NULL,NULL,'demo_tempestconf','bdd251f1-d1ac-4e1c-b9db-eb87ee880162','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'55432981b5d74422bdbe9751541e9c69',0,1,1,'b340b3c5-d93b-45af-b79f-6d96afe8f142','{\"edges\": [[[178, false], null]]}','dep_2'),('0ebf5862-2cb2-46e4-8693-fef462380eb3','2025-12-16 15:52:27','2025-12-16 15:52:28','2025-12-16 15:52:30','RemoteStackTest-1404119128',226,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'2cae36eac24948f8a805c981630d0fd5',0,0,1,'44dacf18-4ab8-43d9-a825-06a23398dedf','{\"edges\": [[[223, false], null]]}',NULL),('11320322-f309-491f-99d1-acc21a7df6a7','2025-12-16 15:47:07','2025-12-16 15:47:39','2025-12-16 15:47:40','ParallelDeploymentsTest-166388227-dep_1-qfnm6pu36tjx',161,NULL,NULL,'demo_tempestconf','7d5d6aa4-f847-42c2-a6b5-202cd43079dd','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'fdd02b2ea25a4828b32ed19a07bdf8ba',0,1,1,'4131844d-cbac-49c0-b559-a509ae0b97ab','{\"edges\": [[[171, false], null]]}','dep_1'),('138389d7-d792-4166-9ea5-e6898ba1daa0','2025-12-16 15:47:00','2025-12-16 15:47:52','2025-12-16 15:47:58','ParallelDeploymentsTest-1647814900',170,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'9eed10f7c4044610a04e5d48e02211bf',0,0,1,'38ce1a94-1eaf-4e84-b0bb-1108fc7eefd8','{\"edges\": [[[153, false], [150, false]], [[153, false], [148, false]], [[153, false], [151, false]], [[153, false], [149, false]], [[153, false], [152, false]]]}',NULL),('13af92fa-6eda-4266-8286-03652fa948f3','2025-12-16 15:52:34','2025-12-16 15:52:41','2025-12-16 15:52:43','RemoteStackTest-638563469',229,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'50451e2896fc427ea0cb9e8f83fea547',0,0,1,'61d4e3dc-92a4-4cc1-bbe6-9a88d3b129c2','{\"edges\": [[[224, false], null]]}',NULL),('162c02b0-a7c7-42d6-89be-d713006a54b6','2025-12-16 15:46:30','2025-12-16 15:46:39','2025-12-16 15:46:41','HooksTest-1655336191',120,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'1f8cd56706ff44afaf5541208aabb51a',0,0,1,'d015abec-7b3c-4394-9824-e4a9a4c6d8d1','{\"edges\": [[[117, false], null], [[119, false], [120, false]]]}',NULL),('17b2458c-423c-4abe-89f1-cedd7b87d864','2025-12-16 15:44:50','2025-12-16 15:44:56','2025-12-16 15:44:57','ExternalReferencesTest-1942669871',58,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'bc157a430ef54a4d8252852fde75fc9a',0,0,1,'1917f01b-b4a7-490d-936e-b1408cc21e51','{\"edges\": [[[40, false], null]]}',NULL),('2daa1675-538f-42f8-a294-31918c670fb0','2025-12-16 15:43:51','2025-12-16 15:43:57','2025-12-16 15:43:59','api-902272075-rsrcstack',13,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'a1d76f472c5c41faa4158134dd714a29',1,'368c062d7e0a401882c1e0ab837b02ab',0,0,1,'9355e00f-f26b-45d6-8cf4-75913e8f657a','{\"edges\": [[[8, false], null]]}',NULL),('2f071904-94aa-4752-919d-4282450ef5e1','2025-12-16 15:45:49','2025-12-16 15:46:13','2025-12-16 15:46:19','UpdateTrunkTest-893536808',102,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'a66d42e30f45448cad3cc4071387a472',0,0,1,'087774fd-711f-4d62-bf9b-a5edd1cb0d83','{\"edges\": [[[86, false], [82, false]], [[85, false], [83, false]], [[85, false], [84, false]], [[84, false], [83, false]], [[88, false], [86, false]], [[88, false], [87, false]], [[87, false], [86, false]], [[91, false], [89, false]], [[91, false], [90, false]], [[90, false], [89, false]]]}',NULL),('31bad9da-4fc9-4936-ba1b-a18c0cf56383','2025-12-16 15:48:35','2025-12-16 15:49:38','2025-12-16 15:49:39','ParallelDeploymentsTest-2096521252-dep_2-wh2k2orfjp55',203,NULL,NULL,'demo_tempestconf','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','DELETE','COMPLETE','Stack DELETE completed successfully',1,'a1d76f472c5c41faa4158134dd714a29',1,'29c50621ca294751819a45ca441b1d7a',0,1,1,'db58c657-1212-4cc6-bd73-e960c856e43f','{\"edges\": [[[206, false], null]]}','dep_2'),('32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','2025-12-16 15:48:35','2025-12-16 15:49:36','2025-12-16 15:49:43','ParallelDeploymentsTest-2096521252',201,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1,'a1d76f472c5c41faa4158134dd714a29',1,'29c50621ca294751819a45ca441b1d7a',0,0,1,'1fd1e159-7dfc-40de-8ac5-ff8d1272b7dd','{\"edges\": [[[203, false], [202, false]], [[203, false], [200, false]], [[203, false], [201, false]]]}',NULL),('33ae0948-8dca-4462-b6d0-e88feb56faa2','2025-12-16 15:47:09','2025-12-16 15:47:29','2025-12-16 15:47:30','ParallelDeploymentsTest-1219149794-dep_0-4bn6sp7mlgbq',156,NULL,NULL,'demo_tempestconf','bdd251f1-d1ac-4e1c-b9db-eb87ee880162','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'55432981b5d74422bdbe9751541e9c69',0,1,1,'66f65cdd-7fa8-4438-b54d-a4f75cdab660','{\"edges\": [[[179, false], null]]}','dep_0'),('3aa1f8fd-af1d-4aef-a4c8-11d33effdfbe','2025-12-16 15:44:34','2025-12-16 15:44:45','2025-12-16 15:44:47','UpdateSubnetTest-1556041256',53,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'f8ed914456ff4055a74dac02803d9152',0,0,1,'5410630d-d5de-4f24-aa79-8c853c7c8644','{\"edges\": [[[28, false], [27, false]]]}',NULL),('3bf90bbb-b9e3-47e3-95f9-d876f4016597','2025-12-16 15:52:50','2025-12-16 15:53:08','2025-12-16 15:53:11','RemoteStackTest-982505025',233,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'5bd3579642b5483cbe86a3fade3de430',0,0,1,'02d522d1-1fb1-46a9-acc4-dae6d4c3beb9','{\"edges\": [[[226, false], null]]}',NULL),('40dd6637-b6c2-4a67-82db-d2283c2d323b','2025-12-16 15:43:46','2025-12-16 15:43:49','2025-12-16 15:43:51','api-902272075-envstack',7,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'a1d76f472c5c41faa4158134dd714a29',1,'9ec51a09790c4497a08209faa3576588',0,0,1,'47fd8fa2-4e02-440a-86ca-00c136a90b74','{\"edges\": [[[1, false], null]]}',NULL),('4393b09a-49b4-425b-944c-d87722a8fa1a','2025-12-16 15:52:52','2025-12-16 15:53:09','2025-12-16 15:53:11','RemoteStackTest-982505025-my_stack-r7ze345pctbu',234,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'a1d76f472c5c41faa4158134dd714a29',1,'a9331cc49f484b5f8864953244851036',0,0,1,'30ca9280-4a9c-4446-8d65-39b7165d4a67','{\"edges\": [[[227, false], null]]}',NULL),('470d3c81-710c-4c77-b962-0273fa2913fd','2025-12-16 15:47:06','2025-12-16 15:47:49','2025-12-16 15:47:50','ParallelDeploymentsTest-1451864420-dep_2-aphjxdseiqss',167,NULL,NULL,'demo_tempestconf','8cbe1304-65fc-48b3-867d-2eecb51467cb','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'8b7821b2d01143c585c7fab254d28764',0,1,1,'cb957321-f5a3-4830-8263-3f94244e32bc','{\"edges\": [[[164, false], null]]}','dep_2'),('476128fb-2e52-4d49-a4a7-c6e01d256343','2025-12-16 15:46:58','2025-12-16 15:48:01','2025-12-16 15:48:08','ParallelDeploymentsTest-615637284',178,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'907f46d1ce234553bd8f5524d2036bf5',0,0,1,'7de6d5db-6bca-410e-b786-9d12ba50a4f1','{\"edges\": [[[142, false], [140, false]], [[142, false], [141, false]], [[142, false], [137, false]], [[142, false], [138, false]], [[142, false], [139, false]]]}',NULL),('4a688e03-5c63-4f31-92b1-d98783bc8d29','2025-12-16 15:44:04','2025-12-16 15:44:15','2025-12-16 15:44:16','api-902272075-stack',34,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'a1d76f472c5c41faa4158134dd714a29',1,'1433f9d2e9d94f3d9f9cb8195f351720',0,0,1,'04087e32-11d7-42e1-95db-daa0335df1bb','{\"edges\": [[[12, false], null]]}',NULL),('4bd6cc20-a27e-4cf0-b6cb-e1af3e215e27','2025-12-16 15:46:22','2025-12-16 15:46:42','2025-12-16 15:46:47','UpdateTrunkTest-1611514538',121,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'8eda65caab4140bcb971cf78e131f119',0,0,1,'030118f9-7745-4cb0-99b4-02afa2a9defb','{\"edges\": [[[107, false], [103, false]], [[104, false], [103, false]], [[106, false], [104, false]], [[106, false], [105, false]], [[105, false], [104, false]], [[112, false], [107, false]], [[112, false], [111, false]], [[111, false], [107, false]], [[110, false], [109, false]], [[110, false], [108, false]], [[109, false], [108, false]]]}',NULL),('4c07c631-500b-41b9-ab5f-28461b4804d9','2025-12-16 15:45:36','2025-12-16 15:45:53','2025-12-16 15:45:54','HooksTest-1967944382',87,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'9c2e894176734b39877e4c0f88346759',0,0,1,'bea2fa92-4ee4-4be2-9a1a-76fe41c9b817','{\"edges\": [[[74, false], [73, false]], [[75, false], [74, false]]]}',NULL),('4d7ea472-c5cf-4020-8a45-9f4b818927f7','2025-12-16 15:48:16','2025-12-16 15:49:46','2025-12-16 15:49:52','ParallelDeploymentsTest-305141961',206,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'63c2ae0ba49b442bbdde23524ecc160a',0,0,1,'f72ab949-d145-4f94-94c1-85af2fc5fd2a','{\"edges\": [[[198, false], null]]}',NULL),('4e4f7436-0104-4c5d-957e-cda3bfc86ee3','2025-12-16 15:52:35','2025-12-16 15:52:42','2025-12-16 15:52:43','RemoteStackTest-638563469-my_stack-je5jek63izk2',230,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'a1d76f472c5c41faa4158134dd714a29',1,'6ec4004d1919468abc42c25806bfe2d2',0,0,1,'4682da62-9515-4595-93d4-4c306fe82156','{\"edges\": [[[225, false], null]]}',NULL),('5160f4e7-e7c9-46a6-be44-5025e0ec4a5c','2025-12-16 15:44:38','2025-12-16 15:44:44','2025-12-16 15:44:45','ExternalReferencesTest-173842663',52,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'61b1b38c96eb464fa30fb3c6dd2f1e19',0,0,1,'8888dabd-617e-4bdd-bd6c-344a3fe549f3','{\"edges\": [[[30, false], null]]}',NULL),('538c1c0b-52c5-4656-a5f6-52bdc8723cb7','2025-12-16 15:44:02','2025-12-16 15:44:06',NULL,'api-1464377815-stack',28,NULL,14,'demo_tempestconf',NULL,'UPDATE','COMPLETE','Stack UPDATE completed successfully',NULL,'a1d76f472c5c41faa4158134dd714a29',1,'8e19dc32f60d4c55afae88e1d34e0d27',0,0,1,'6ffcba56-b879-49cc-b817-96caed0dcd99','{\"edges\": [[[11, false], [11, true]]]}',NULL),('5756f7bd-aaf3-4b07-9cb4-ae8fa3e9b4dd','2025-12-16 15:45:58','2025-12-16 15:46:12','2025-12-16 15:46:16','HooksTest-720324335',100,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'f9d4aae5f5b342f283e547c298e1583d',0,0,1,'d6e6ae4e-7c3b-4141-9574-c152d65d87e2','{\"edges\": [[[95, false], null]]}',NULL),('57b21988-2b6c-4d16-8c6b-498a33e6fb0f','2025-12-16 15:43:46',NULL,NULL,'api-1464377815-envstack',3,NULL,2,'demo_tempestconf',NULL,'CREATE','COMPLETE','Stack CREATE completed successfully',NULL,'a1d76f472c5c41faa4158134dd714a29',1,'731b91ba596e4499b3008b082a44fc7f',0,0,1,'7a50889c-9cc0-462c-9c82-eac419e51c9f','{\"edges\": [[[2, true], null]]}',NULL),('5c1d20bd-04c3-4cf6-8ce7-4e77b46c6511','2025-12-16 15:50:04','2025-12-16 15:50:14','2025-12-16 15:50:20','RemoteDeeplyNestedStackTest-508630137',214,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'7464b73752c44a1d96b1e0b426cb1004',0,0,1,'54be0298-9554-4016-a65d-fe6d813c1797','{\"edges\": [[[211, false], null]]}',NULL),('60cddedb-576e-440b-85b8-27b1e2c5a50e','2025-12-16 15:47:01','2025-12-16 15:47:56','2025-12-16 15:47:57','ParallelDeploymentsTest-1647814900-dep_2-oplhguqu7k5l',176,NULL,NULL,'demo_tempestconf','138389d7-d792-4166-9ea5-e6898ba1daa0','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'9eed10f7c4044610a04e5d48e02211bf',0,1,1,'f8e82d87-c19e-422a-ae3f-73d01c23c0e9','{\"edges\": [[[158, false], null]]}','dep_2'),('610e789f-9f5a-4e53-9462-bafa5aafa5a8','2025-12-16 15:47:01','2025-12-16 15:47:54','2025-12-16 15:47:56','ParallelDeploymentsTest-1647814900-dep_1-bng2hoi7rvvv',172,NULL,NULL,'demo_tempestconf','138389d7-d792-4166-9ea5-e6898ba1daa0','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'9eed10f7c4044610a04e5d48e02211bf',0,1,1,'9210c6ea-c9a9-49d8-a5f8-9b637688f5b4','{\"edges\": [[[155, false], null]]}','dep_1'),('61644de6-5a50-49ec-849e-4d04ca5001d1','2025-12-16 15:43:47',NULL,NULL,'api-442899664-rsrcstack',5,NULL,5,'demo_tempestconf',NULL,'CREATE','COMPLETE','Stack CREATE completed successfully',NULL,'a1d76f472c5c41faa4158134dd714a29',1,'a66c17e3d0044dfba340a8fa7f6bda5d',0,0,1,'35accadb-3442-4896-9313-097deee96709','{\"edges\": [[[5, true], null]]}',NULL),('66bc5d13-49c7-4625-9ba6-96c8ed066846','2025-12-16 15:45:08','2025-12-16 15:45:30','2025-12-16 15:45:37','server_with_sub_ip',77,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'cd3c1582204841488ca760ab2902f78d',0,0,1,'47d920c6-cd3a-4389-adcf-28f9b8b69c5e','{\"edges\": [[[55, false], [53, false]], [[54, false], [53, false]], [[56, false], [55, false]]]}',NULL),('697c6e6a-55db-4b0a-b86a-9cab8ffec23e','2025-12-16 15:45:14','2025-12-16 15:45:25','2025-12-16 15:45:30','HooksTest-1320952685',74,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'a034b6a54e6d42d7832f9b98d8e3fc48',0,0,1,'f3a63e40-1107-4348-a19d-aefe779349c6','{\"edges\": [[[57, false], null]]}',NULL),('6c086204-9386-488e-9d66-a50e7726acf8','2025-12-16 15:44:49','2025-12-16 15:45:14','2025-12-16 15:45:18','UpdateTrunkTest-765035019',69,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'81db4a1fb811483ab55dc2231c005ace',0,0,1,'463b8e72-8d5e-4457-a62e-5253124c589d','{\"edges\": [[[43, false], [35, false]], [[39, false], [35, false]], [[36, false], [35, false]], [[38, false], [36, false]], [[38, false], [37, false]], [[37, false], [36, false]], [[42, false], [39, false]], [[42, false], [41, false]], [[41, false], [39, false]], [[45, false], [44, false]], [[45, false], [43, false]], [[44, false], [43, false]]]}',NULL),('6c54c1e8-3450-48de-8a6b-abc87fdcb345','2025-12-16 15:43:58','2025-12-16 15:43:59','2025-12-16 15:44:00','api-813963596-empty',15,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'a1d76f472c5c41faa4158134dd714a29',1,'e950f218d67d4949a0d9133c5b6173ad',0,0,1,'9f7aea10-fb8f-40ba-b705-54d91cb56f7c','{\"edges\": []}',NULL),('6cba10af-327d-4759-8fc6-bb51c95440ac','2025-12-16 15:50:09','2025-12-16 15:50:41','2025-12-16 15:50:46','swap_network_port',218,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'4baca59afb994e79846a1d788eb8a3b6',0,0,1,'0727b219-55c3-4f5a-ad4e-ad84c292fb9a','{\"edges\": [[[216, false], [215, false]], [[215, false], [214, false]]]}',NULL),('6d86f0cb-94d2-4040-ab94-f01bd5c0a1a1','2025-12-16 15:44:11','2025-12-16 15:44:34','2025-12-16 15:44:38','EncryptedParametersTest-223744132',44,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'b2f43d5299e640fabc9af685f499706f',0,0,1,'ca427c76-df10-4aa3-b316-ac2e6e6ec263','{\"edges\": [[[17, false], null]]}',NULL),('713d07a9-6f40-4f17-8d78-33b6ba2e5268','2025-12-16 15:45:58','2025-12-16 15:46:13','2025-12-16 15:46:14','HooksTest-720324335-rg-zvsray4uhdfi',101,NULL,NULL,'demo_tempestconf','5756f7bd-aaf3-4b07-9cb4-ae8fa3e9b4dd','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'f9d4aae5f5b342f283e547c298e1583d',0,1,1,'1550d92e-c7db-4232-9f8c-08d4479bf895','{\"edges\": [[[96, false], null], [[97, false], null]]}','rg'),('7b4a51e6-9e97-4c2f-963e-4a6e20c09e5c','2025-12-16 15:48:33','2025-12-16 15:48:35','2025-12-16 15:48:36','StackUnicodeTemplateTest-1663997320',194,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'ea413a5fc9a04cf8b476b498b791c4f5',0,0,1,'ea9faf0a-04aa-446d-8b71-d774642fec73','{\"edges\": [[[199, false], null]]}',NULL),('7ce7898f-841d-4bc9-a049-455b9e2903dc','2025-12-16 15:48:35','2025-12-16 15:49:39','2025-12-16 15:49:42','ParallelDeploymentsTest-2096521252-dep_1-b6wqywoen3tc',204,NULL,NULL,'demo_tempestconf','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','DELETE','COMPLETE','Stack DELETE completed successfully',1,'a1d76f472c5c41faa4158134dd714a29',1,'29c50621ca294751819a45ca441b1d7a',0,1,1,'0fc8579d-1383-4553-bd61-79546583c114','{\"edges\": [[[204, false], null]]}','dep_1'),('7d5d6aa4-f847-42c2-a6b5-202cd43079dd','2025-12-16 15:47:06','2025-12-16 15:47:38','2025-12-16 15:47:44','ParallelDeploymentsTest-166388227',160,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'fdd02b2ea25a4828b32ed19a07bdf8ba',0,0,1,'74c857fc-88a0-4167-bbc1-0091b3c2ff42','{\"edges\": [[[169, false], [167, false]], [[169, false], [168, false]], [[169, false], [166, false]]]}',NULL),('7dcd0513-2b7b-4076-9abd-3e6390741252','2025-12-16 15:45:41','2025-12-16 15:46:24','2025-12-16 15:46:28','create_server_with_sub_ip',108,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'b0a50270805d4796abdaaa8bba41d662',0,0,1,'aae628c6-7914-4eef-b1b9-da752651b301','{\"edges\": [[[78, false], [76, false]], [[77, false], [76, false]], [[79, false], [77, false]], [[79, false], [78, false]]]}',NULL),('81183c40-92d8-4cb3-b34a-5e8a08bf6838','2025-12-16 15:47:07','2025-12-16 15:47:41','2025-12-16 15:47:42','ParallelDeploymentsTest-166388227-dep_2-l42jnylktmrk',163,NULL,NULL,'demo_tempestconf','7d5d6aa4-f847-42c2-a6b5-202cd43079dd','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'fdd02b2ea25a4828b32ed19a07bdf8ba',0,1,1,'e5a226bb-28ff-4c27-99c2-842144971398','{\"edges\": [[[170, false], null]]}','dep_2'),('8260713d-fdcd-4191-af23-f6434fb03aa7','2025-12-16 15:44:06','2025-12-16 15:44:17','2025-12-16 15:44:21','UpdatePortTest-1000067181',36,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'6fa822cda401414fba8be2d3387fad70',0,0,1,'b0efb7e3-014b-4e67-b497-52f67ab7aa57','{\"edges\": [[[16, false], [15, false]], [[16, false], [14, false]], [[14, false], [13, false]], [[15, false], [14, false]]]}',NULL),('832db642-8498-4f68-bfb1-831831fbfa27','2025-12-16 15:51:36','2025-12-16 15:52:17','2025-12-16 15:52:22','swap_subnet_network',224,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'ba1b9fa3e5ed40a5a977e19ca3985e94',0,0,1,'ebe06c28-d6c5-4673-a03b-afff17469820','{\"edges\": [[[222, false], [221, false]], [[222, false], [220, false]], [[221, false], [220, false]]]}',NULL),('83948b1f-e809-4cf7-9d27-fb14fabacae6','2025-12-16 15:50:07','2025-12-16 15:50:15','2025-12-16 15:50:20','RemoteDeeplyNestedStackTest-508630137-network_stack-ofw6sbnpv463',215,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'a1d76f472c5c41faa4158134dd714a29',1,'27b187bccbf3403c938f6dd239fc8dd1',0,0,1,'6c08950c-bdb1-4e26-b0b6-d8124080b88e','{\"edges\": [[[212, false], null]]}',NULL),('84793008-ef3d-4877-bba7-01648ba2a2bb','2025-12-16 15:47:23','2025-12-16 15:47:43','2025-12-16 15:47:48','UpdateTrunkTest-1027559740',164,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'a75316c1026d45af8d5afd9a50466404',0,0,1,'637258a2-069b-4706-b043-9c4ccb6c0ff2','{\"edges\": [[[182, false], [180, false]], [[182, false], [181, false]], [[181, false], [180, false]], [[184, false], [183, false]], [[186, false], [184, false]], [[186, false], [185, false]], [[185, false], [184, false]], [[189, false], [188, false]], [[189, false], [187, false]], [[188, false], [187, false]]]}',NULL),('84e8374e-8283-4692-ae62-2a35a9ce21a2','2025-12-16 15:46:44','2025-12-16 15:48:10','2025-12-16 15:48:14','ParallelDeploymentsTest-2020059004',186,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'cfdd877b656441fe8503defd5359102a',0,0,1,'079494d8-3b69-435b-b9b8-4e6b413c7455','{\"edges\": [[[123, false], null]]}',NULL),('8538e2ba-965b-4b33-80e5-83f71aeda10f','2025-12-16 15:45:23','2025-12-16 15:45:36','2025-12-16 15:45:39','UpdateSubnetTest-637759540',80,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'3a450ace3a4540928805187f471e4d59',0,0,1,'2bd2ae6a-1d4a-4a58-bf80-bee2b61ed5ef','{\"edges\": [[[72, false], [71, false]]]}',NULL),('8606424d-0c4c-44e0-9d9d-aa9a306ff574','2025-12-16 15:43:58','2025-12-16 15:44:02',NULL,'api-442899664-stack',21,NULL,11,'demo_tempestconf',NULL,'UPDATE','COMPLETE','Stack UPDATE completed successfully',NULL,'a1d76f472c5c41faa4158134dd714a29',1,'12a7d3c8539a441d99e5f296f2162c09',0,0,1,'fdaf024f-332c-4556-977b-e209c1c918e1','{\"edges\": [[[9, false], [9, true]]]}',NULL),('8c180679-a4c4-4a37-9fc5-693018752629','2025-12-16 15:45:19','2025-12-16 15:45:40','2025-12-16 15:45:45','UpdateTrunkTest-1882122261',81,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'b888dade4108483899eff67c658f3a24',0,0,1,'c0b3b170-b839-46d7-bb52-d147fc3875d0','{\"edges\": [[[61, false], [64, false]], [[63, false], [61, false]], [[63, false], [62, false]], [[62, false], [61, false]], [[65, false], [64, false]], [[67, false], [66, false]], [[67, false], [65, false]], [[66, false], [65, false]], [[70, false], [69, false]], [[70, false], [68, false]], [[69, false], [68, false]]]}',NULL),('8cbe1304-65fc-48b3-867d-2eecb51467cb','2025-12-16 15:47:05','2025-12-16 15:47:47','2025-12-16 15:47:51','ParallelDeploymentsTest-1451864420',165,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'8b7821b2d01143c585c7fab254d28764',0,0,1,'9bdf4cb4-b5f1-4501-ab94-8f0a5dc00c13','{\"edges\": [[[162, false], [161, false]], [[162, false], [159, false]], [[162, false], [160, false]]]}',NULL),('9001ce9e-8520-4430-89ae-c26ecd5bcecf','2025-12-16 15:45:15','2025-12-16 15:45:25','2025-12-16 15:45:28','HooksTest-1320952685-nested-sdbz2ssevv6m',75,NULL,NULL,'demo_tempestconf','697c6e6a-55db-4b0a-b86a-9cab8ffec23e','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'a034b6a54e6d42d7832f9b98d8e3fc48',0,1,1,'430df5de-74a4-4e51-be18-fdd78f9a825f','{\"edges\": [[[59, false], [58, false]], [[60, false], [59, false]]]}','nested'),('91481ff0-416c-4925-9261-b5efdd2eb473','2025-12-16 15:46:59','2025-12-16 15:48:05','2025-12-16 15:48:06','ParallelDeploymentsTest-615637284-dep_1-dosh4mmsqtuw',184,NULL,NULL,'demo_tempestconf','476128fb-2e52-4d49-a4a7-c6e01d256343','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'907f46d1ce234553bd8f5524d2036bf5',0,1,1,'975c5403-0568-4ef6-948f-6ee8c235a681','{\"edges\": [[[146, false], null]]}','dep_1'),('9ab7fb5a-2105-4706-b669-bcc095a42071','2025-12-16 15:46:45','2025-12-16 15:47:18','2025-12-16 15:47:24','add_network',152,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'00ea663645814cbea34c8201be383ce8',0,0,1,'ec439970-b78c-43d0-a40b-2b071795bd39','{\"edges\": [[[126, false], [124, false]], [[126, false], [125, false]], [[125, false], [124, false]]]}',NULL),('9c28d729-435a-4134-98b0-9ebc654292a3','2025-12-16 15:49:01','2025-12-16 15:49:54','2025-12-16 15:50:04','multi_networks_swaps',207,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'42b4bbefe91e46b289294a80ffb13a73',0,0,1,'aee865db-dfde-41f3-993e-e7f1a1c41d61','{\"edges\": [[[209, false], [207, false]], [[209, false], [208, false]], [[208, false], [207, false]]]}',NULL),('9c9b6a4c-1270-4c34-85e2-3883ebd38a9c','2025-12-16 15:48:08','2025-12-16 15:48:26','2025-12-16 15:48:29','StackTagTest-1854058341',191,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'d74b88defd064e0382099783fa740f2d',0,0,1,'062d8f44-9782-4373-8934-233e15e1bf5c','{\"edges\": [[[194, false], null]]}',NULL),('9d685eb1-0c77-410a-a31c-69846cc343ec','2025-12-16 15:47:01','2025-12-16 15:47:55','2025-12-16 15:47:56','ParallelDeploymentsTest-1647814900-dep_4-3v7275z7674o',173,NULL,NULL,'demo_tempestconf','138389d7-d792-4166-9ea5-e6898ba1daa0','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'9eed10f7c4044610a04e5d48e02211bf',0,1,1,'c4a6bd98-9beb-46fa-b7c9-14aa6e30ac09','{\"edges\": [[[154, false], null]]}','dep_4'),('a0407c9d-9f4a-42f2-8907-8cb867120a66','2025-12-16 15:46:59','2025-12-16 15:48:04','2025-12-16 15:48:06','ParallelDeploymentsTest-615637284-dep_4-ubaedu76zued',182,NULL,NULL,'demo_tempestconf','476128fb-2e52-4d49-a4a7-c6e01d256343','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'907f46d1ce234553bd8f5524d2036bf5',0,1,1,'d86c754f-b086-47a0-9f07-aba110325f76','{\"edges\": [[[143, false], null]]}','dep_4'),('a6db82eb-2271-48a6-99b2-618a93847934','2025-12-16 15:48:11','2025-12-16 15:48:50','2025-12-16 15:48:56','add_subnet',199,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'991037f2982242dd9113477d656b66dc',0,0,1,'e9ecede6-2afd-461e-b5bf-038bad67bfe3','{\"edges\": [[[197, false], [196, false]], [[197, false], [195, false]], [[196, false], [195, false]]]}',NULL),('ab6b1518-741d-46cc-b916-eb32929e403b','2025-12-16 15:45:07','2025-12-16 15:45:18','2025-12-16 15:45:20','UpdateSubnetTest-138587764',71,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'590575305d504649bde90c4fa3b54935',0,0,1,'f6d6f935-0586-48b2-be2b-26dafc450b9e','{\"edges\": [[[52, false], [51, false]]]}',NULL),('ac1887a9-4f8c-4d57-82b2-146244a4d030','2025-12-16 15:46:59','2025-12-16 15:48:01','2025-12-16 15:48:02','ParallelDeploymentsTest-615637284-dep_3-2uy3tkfij6uf',179,NULL,NULL,'demo_tempestconf','476128fb-2e52-4d49-a4a7-c6e01d256343','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'907f46d1ce234553bd8f5524d2036bf5',0,1,1,'2d3f5252-3c67-4f81-bb3b-9a857c54ed5f','{\"edges\": [[[145, false], null]]}','dep_3'),('ad2d8147-5f63-41a6-8dcd-b0c2da6c31b3','2025-12-16 15:47:29','2025-12-16 15:48:00','2025-12-16 15:48:07','same_fixed_ip',177,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'c87bcd777d6a450c9a88a7163fca0d55',0,0,1,'8fb3b5fb-c697-47eb-a5d1-17b1402f4891','{\"edges\": [[[192, false], [191, false]], [[192, false], [190, false]], [[191, false], [190, false]]]}',NULL),('aece8a1c-3be3-4415-9d3f-9c9512d2cf0f','2025-12-16 15:45:02','2025-12-16 15:45:09','2025-12-16 15:45:10','HooksTest-632604305',66,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'d35b256cb42d4f38b9b87d08220deeaf',0,0,1,'66c3acd9-1153-4c32-b50f-e73d45282ce6','{\"edges\": [[[49, false], [48, false]], [[50, false], [49, false]]]}',NULL),('af3bef1c-23ea-4de8-8f9e-990b21f7874a','2025-12-16 15:47:56','2025-12-16 15:48:02','2025-12-16 15:48:05','StackTagTest-36062930',181,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'7f037f7454ce4280aafba86a04c0a217',0,0,1,'32e30658-3c69-4c08-ab05-24a9877bfda4','{\"edges\": [[[193, false], null]]}',NULL),('b2d03b09-2e79-423a-b882-e84637086794','2025-12-16 15:45:41','2025-12-16 15:45:52','2025-12-16 15:45:54','UpdateSubnetTest-227927417',86,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'04a1f6aceb6f4ad7ab2e9765d258239a',0,0,1,'664a669b-9eac-4463-a5dd-f63ae2a97a4c','{\"edges\": [[[81, false], [80, false]]]}',NULL),('b97f8228-df37-4ef0-92f2-a5b9dd50b5f8','2025-12-16 15:49:56','2025-12-16 15:49:57','2025-12-16 15:49:59','TemplateAPITest-1727151759',209,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'5938d40b84664d3da3289c874fed0460',0,0,1,'57f656ff-0e50-49e5-8274-42ce486e71f9','{\"edges\": [[[210, false], null]]}',NULL),('bb7c0259-ff79-464c-b821-75f954c9a816','2025-12-16 15:43:46',NULL,NULL,'api-442899664-envstack',2,NULL,3,'demo_tempestconf',NULL,'CREATE','COMPLETE','Stack CREATE completed successfully',NULL,'a1d76f472c5c41faa4158134dd714a29',1,'d681a3cf95a44b3699bdd747e2fbfe88',0,0,1,'e7848bff-8e90-4660-aae4-5ef657c8225b','{\"edges\": [[[3, true], null]]}',NULL),('bccb90e9-49c9-467e-9118-68f3d8f2f773','2025-12-16 15:46:59','2025-12-16 15:48:02','2025-12-16 15:48:05','ParallelDeploymentsTest-615637284-dep_0-bn6krfvthvel',180,NULL,NULL,'demo_tempestconf','476128fb-2e52-4d49-a4a7-c6e01d256343','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'907f46d1ce234553bd8f5524d2036bf5',0,1,1,'8b00acb3-45e1-48bf-be7d-2c33950171f5','{\"edges\": [[[147, false], null]]}','dep_0'),('bda9f4bf-8230-42c0-aba8-d0cd924b9104','2025-12-16 15:47:06','2025-12-16 15:47:50','2025-12-16 15:47:51','ParallelDeploymentsTest-1451864420-dep_1-ffrutgqryu3u',169,NULL,NULL,'demo_tempestconf','8cbe1304-65fc-48b3-867d-2eecb51467cb','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'8b7821b2d01143c585c7fab254d28764',0,1,1,'6142e0ce-def2-4d34-8b58-4674a46a777c','{\"edges\": [[[163, false], null]]}','dep_1'),('bdc8fd20-a3af-4063-992d-faddbf78cd2f','2025-12-16 15:43:46',NULL,NULL,'api-813963596-envstack',4,NULL,4,'demo_tempestconf',NULL,'CREATE','COMPLETE','Stack CREATE completed successfully',NULL,'a1d76f472c5c41faa4158134dd714a29',1,'bef8dc386946430d9805a45a40f95009',0,0,1,'43bc387d-454f-40ad-b3c5-b5d9dc73ba92','{\"edges\": [[[4, true], null]]}',NULL),('bdd251f1-d1ac-4e1c-b9db-eb87ee880162','2025-12-16 15:47:08','2025-12-16 15:47:29','2025-12-16 15:47:35','ParallelDeploymentsTest-1219149794',155,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'55432981b5d74422bdbe9751541e9c69',0,0,1,'0509224a-cc20-4d86-8206-2bf469199a58','{\"edges\": [[[176, false], [175, false]], [[176, false], [173, false]], [[176, false], [174, false]]]}',NULL),('c182542f-8886-45e3-92f1-2c88388c9805','2025-12-16 15:44:31','2025-12-16 15:44:33','2025-12-16 15:44:34','ExternalReferencesTest-602729546',43,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'b8d29ed60a234483a1398a060c9ca1f1',0,0,1,'f8a6e0af-db09-42a8-bcf3-2a2cb9c4802f','{\"edges\": [[[26, false], null]]}',NULL),('c3543e55-42f5-43a5-93f9-58ed5ebf18d5','2025-12-16 15:46:52','2025-12-16 15:47:12','2025-12-16 15:47:21','UpdateTrunkTest-759910396',151,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'2198ed0d60d848129d60e3eef3132e2c',0,0,1,'368c086e-d35a-48c4-8dc5-76cddc409491','{\"edges\": [[[131, false], [127, false]], [[128, false], [127, false]], [[130, false], [129, false]], [[130, false], [128, false]], [[129, false], [128, false]], [[133, false], [132, false]], [[133, false], [131, false]], [[132, false], [131, false]], [[136, false], [134, false]], [[136, false], [135, false]], [[135, false], [134, false]]]}',NULL),('c3e36837-2427-4bae-8974-8ed5fe929ded','2025-12-16 15:43:48',NULL,NULL,'api-813963596-rsrcstack',6,NULL,6,'demo_tempestconf',NULL,'CREATE','COMPLETE','Stack CREATE completed successfully',NULL,'a1d76f472c5c41faa4158134dd714a29',1,'7007717ee252419989523c5b833d0df7',0,0,1,'8cf864b4-4d39-4207-a79c-19a899cd007e','{\"edges\": [[[6, true], null]]}',NULL),('cad69cc4-2572-4bdb-8c9e-1c3092e995d2','2025-12-16 15:44:13','2025-12-16 15:44:25','2025-12-16 15:44:27','EncryptionVolTypeTest-646776626',40,NULL,NULL,'admin',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a2d874eb451e455db9e546be3b064c5e',1,'f7d7af1f6d20429ba86585c2d43f400b',0,0,1,'6cb74b37-b968-4e1c-a55f-f8f9109c1bac','{\"edges\": [[[19, false], [18, false]]]}',NULL),('ce2f7836-6308-407a-bbdc-3121334a461d','2025-12-16 15:47:01','2025-12-16 15:47:55','2025-12-16 15:47:56','ParallelDeploymentsTest-1647814900-dep_3-s7owfmvnomrx',174,NULL,NULL,'demo_tempestconf','138389d7-d792-4166-9ea5-e6898ba1daa0','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'9eed10f7c4044610a04e5d48e02211bf',0,1,1,'74577e50-a923-4bb3-8726-c3d829ec9d71','{\"edges\": [[[156, false], null]]}','dep_3'),('d02d8ef5-e863-4f6c-963c-b88750d600d9','2025-12-16 15:46:27','2025-12-16 15:46:33','2025-12-16 15:46:34','StackOutputsTest-1999888672',117,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'ce7823009e2a453fa0ce791f19d1aef2',0,0,1,'a999345f-4a24-4e4f-abed-4f243a446e81','{\"edges\": [[[113, false], [114, false]]]}',NULL),('d167ccd0-b456-4c81-a33e-417b0c2ab6e9','2025-12-16 15:44:50','2025-12-16 15:45:02','2025-12-16 15:45:04','UpdateSubnetTest-1759798492',62,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'7cbefaf8f78344068562fd1bd7fbbe37',0,0,1,'c61b251c-f920-45c7-9564-41b56ede10f9','{\"edges\": [[[47, false], [46, false]]]}',NULL),('d28b5b24-4f08-4f19-a491-61dde3d5bd59','2025-12-16 15:47:01','2025-12-16 15:47:52','2025-12-16 15:47:55','ParallelDeploymentsTest-1647814900-dep_0-77xgibe5oqko',171,NULL,NULL,'demo_tempestconf','138389d7-d792-4166-9ea5-e6898ba1daa0','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'9eed10f7c4044610a04e5d48e02211bf',0,1,1,'4a4c230e-4d6a-4bd4-a878-0df0a6f44d8c','{\"edges\": [[[157, false], null]]}','dep_0'),('d3ea3a2b-3310-4264-a5e9-5e3e694abad8','2025-12-16 15:44:01','2025-12-16 15:44:01','2025-12-16 15:44:02','api-1464377815-empty',18,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'a1d76f472c5c41faa4158134dd714a29',1,'4d1905d6c675442681ea3067c66b5a6f',0,0,1,'2a66dd88-a798-4272-8e35-17aaa0f4745e','{\"edges\": []}',NULL),('d48accfb-4bf1-4e41-9366-9bd13c556bf2','2025-12-16 15:46:16','2025-12-16 15:46:21','2025-12-16 15:46:23','StackOutputsTest-1029112348',106,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'4f5b1cd3dc624b77862cdc295f3054b4',0,0,1,'ad57b342-b143-447c-b78f-5bf1adf02843','{\"edges\": [[[98, false], null], [[99, false], null]]}',NULL),('d86d5f46-7405-4fe4-a7fe-98b2c8ec7eea','2025-12-16 15:43:51',NULL,NULL,'api-1464377815-rsrcstack',8,NULL,7,'demo_tempestconf',NULL,'CREATE','COMPLETE','Stack CREATE completed successfully',NULL,'a1d76f472c5c41faa4158134dd714a29',1,'5bc5c378735448a183ba112dde3a2e8f',0,0,1,'d0841c58-bf2c-45f0-860c-8053fee1df8f','{\"edges\": [[[7, true], null]]}',NULL),('d996c9a7-562a-44e2-b7d9-a878e5a4528c','2025-12-16 15:53:16','2025-12-16 15:53:29','2025-12-16 15:53:30','RemoteStackTest-628457373',239,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'fbc2e3303359428e8055a4e67bc9dabc',0,0,1,'201a28a5-3d7d-4e47-b5ea-461d4ba66481','{\"edges\": [[[228, false], null]]}',NULL),('db65656d-9c00-4c7d-854e-30cf1bd7d01a','2025-12-16 15:48:35','2025-12-16 15:49:37','2025-12-16 15:49:39','ParallelDeploymentsTest-2096521252-dep_0-azwr43qlug65',202,NULL,NULL,'demo_tempestconf','32cb5f6a-56ff-44cf-b71e-a0e950ae9d5c','DELETE','COMPLETE','Stack DELETE completed successfully',1,'a1d76f472c5c41faa4158134dd714a29',1,'29c50621ca294751819a45ca441b1d7a',0,1,1,'4110631b-a01a-4f3a-8cc8-2299a036ce93','{\"edges\": [[[205, false], null]]}','dep_0'),('dbf8d2a1-37c1-4e86-ac7f-0d103ac50c64','2025-12-16 15:46:18','2025-12-16 15:46:25','2025-12-16 15:46:26','HooksTest-1903585384',109,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'1f8d112038ea4d9dbeea809d3cfb7122',0,0,1,'322231ae-04d5-4da6-8ef1-4e4a4a494eae','{\"edges\": [[[101, false], [100, false]], [[102, false], [101, false]]]}',NULL),('dc24dfa9-4a55-4812-a358-1e5307817ecd','2025-12-16 15:44:40','2025-12-16 15:44:58','2025-12-16 15:45:05','server_with_port',60,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'7bea8e5fd5884a24ac58b27edfa2eee3',0,0,1,'82ebf48f-1ee2-4abc-9f6c-998e66963daf','{\"edges\": [[[33, false], [31, false]], [[33, false], [32, false]], [[32, false], [31, false]], [[34, false], [33, false]], [[34, false], [32, false]]]}',NULL),('dce84e82-2761-493e-aed6-c2ceb3240413','2025-12-16 15:46:59','2025-12-16 15:48:05','2025-12-16 15:48:06','ParallelDeploymentsTest-615637284-dep_2-523kyhjuun3y',183,NULL,NULL,'demo_tempestconf','476128fb-2e52-4d49-a4a7-c6e01d256343','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'907f46d1ce234553bd8f5524d2036bf5',0,1,1,'5c527f7d-50d9-4217-b879-c2a378dbee02','{\"edges\": [[[144, false], null]]}','dep_2'),('dd76fd8d-e13e-4217-aa12-aa85cd0c1544','2025-12-16 15:46:36','2025-12-16 15:46:38','2025-12-16 15:46:39','ResourcesList-78929858',119,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'d3bc39987b5f4040b5321b14176ec3ad',0,0,1,'ba84533f-c2b3-41f6-a67e-cf41ca2af9a2','{\"edges\": [[[122, false], [121, false]]]}',NULL),('e6dd329c-bca6-44b2-b461-347820c4c943','2025-12-16 15:53:36','2025-12-16 15:53:38','2025-12-16 15:53:39','StackEventsTest-1022542315',242,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'3486dc346f224e3d89204f33cbe14571',0,0,1,'c0fb1b28-e43e-4dae-a2a5-79331f812cdd','{\"edges\": [[[231, false], null]]}',NULL),('e7c45c7a-1653-4624-8d62-a93026ec3a11','2025-12-16 15:53:18','2025-12-16 15:53:29','2025-12-16 15:53:30','RemoteStackTest-628457373-my_stack-grhdfsiwdt5v',240,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'a1d76f472c5c41faa4158134dd714a29',1,'932e9d9601354d648537568cd5d11e5f',0,0,1,'3c01c1f4-6322-4c40-95cd-b53fe2e81047','{\"edges\": [[[230, false], null]]}',NULL),('e92f965d-2a4c-42f2-898e-53250534243a','2025-12-16 15:47:07','2025-12-16 15:47:40','2025-12-16 15:47:41','ParallelDeploymentsTest-166388227-dep_0-j6mitznpjgh2',162,NULL,NULL,'demo_tempestconf','7d5d6aa4-f847-42c2-a6b5-202cd43079dd','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'fdd02b2ea25a4828b32ed19a07bdf8ba',0,1,1,'407d2a43-7b9d-446f-84bf-9d891472b4d8','{\"edges\": [[[172, false], null]]}','dep_0'),('edafdf4f-b38e-44f1-937c-7096617eaa83','2025-12-16 15:45:58','2025-12-16 15:46:10','2025-12-16 15:46:12','StackOutputsTest-958285426-parent-rdmyikl57on5',99,NULL,NULL,'demo_tempestconf','05fdd3ab-69bd-4a63-9ace-ba29648e3fce','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a1d76f472c5c41faa4158134dd714a29',1,'06cb2b5438d84fb3b4b69a66ae5e82de',0,1,1,'e0bb07bc-4166-4659-939c-8b1d047ca079','{\"edges\": [[[93, false], null], [[94, false], null]]}','parent'),('f548867f-5f65-4614-ae3a-5b56dfbe1b1d','2025-12-16 15:44:02','2025-12-16 15:44:03','2025-12-16 15:44:04','api-902272075-empty',22,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'a1d76f472c5c41faa4158134dd714a29',1,'5fe1d1dd97c8477eb4ef498cf91eba68',0,0,1,'263c5bfe-c77b-4971-bc65-6da9eb269ebc','{\"edges\": []}',NULL),('f617316a-b411-4e5b-82bf-9a4b725744c1','2025-12-16 15:50:08','2025-12-16 15:50:15','2025-12-16 15:50:16','RemoteDeeplyNestedStackTest-508630137-network_stack-ofw6sbnpv463-network_stack_as_custom_type-pzasodfxerv4',216,NULL,NULL,'demo_tempestconf','83948b1f-e809-4cf7-9d27-fb14fabacae6','DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'a1d76f472c5c41faa4158134dd714a29',1,'27b187bccbf3403c938f6dd239fc8dd1',0,1,1,'33c007c0-ee20-405a-8c2c-4065912bed2c','{\"edges\": [[[213, false], null]]}','network_stack_as_custom_type'),('faf9dd92-37dd-4c82-b953-42462946708c','2025-12-16 15:44:23','2025-12-16 15:44:43','2025-12-16 15:44:46','UpdatePortTest-362328687',51,NULL,NULL,'admin',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'a2d874eb451e455db9e546be3b064c5e',1,'1ead1488ab2841129943e31604563930',0,0,1,'f4eac9b6-c788-46b2-aa39-3e882b669f8c','{\"edges\": [[[22, false], null], [[24, false], [29, false]], [[25, false], [29, false]], [[25, false], [24, false]]]}',NULL),('ff30dbd1-3d08-4e29-9740-eaf2660d2297','2025-12-16 15:43:55','2025-12-16 15:43:57','2025-12-16 15:43:58','api-442899664-empty',11,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'a1d76f472c5c41faa4158134dd714a29',1,'86111f0079b141668d0f56dde183fa2c',0,0,1,'9e21a7bd-af96-49ba-92c3-70dbe7b9b934','{\"edges\": []}',NULL),('ff434bb3-7cc5-4848-9d1e-8f0f46ac0718','2025-12-16 15:44:00','2025-12-16 15:44:09',NULL,'api-813963596-stack',29,NULL,12,'demo_tempestconf',NULL,'UPDATE','COMPLETE','Stack UPDATE completed successfully',NULL,'a1d76f472c5c41faa4158134dd714a29',1,'343787a27d2e46f595aee2ec4606f433',0,0,1,'2b4de975-58a6-4ecd-808d-e30e9b2e66ba','{\"edges\": [[[10, false], [10, true]]]}',NULL);
/*!40000 ALTER TABLE `stack` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack_lock`
--

DROP TABLE IF EXISTS `stack_lock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack_lock` (
  `stack_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `engine_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`stack_id`),
  CONSTRAINT `stack_lock_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack_lock`
--

LOCK TABLES `stack_lock` WRITE;
/*!40000 ALTER TABLE `stack_lock` DISABLE KEYS */;
/*!40000 ALTER TABLE `stack_lock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack_tag`
--

DROP TABLE IF EXISTS `stack_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `tag` varchar(80) DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stack_id` (`stack_id`),
  CONSTRAINT `stack_tag_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack_tag`
--

LOCK TABLES `stack_tag` WRITE;
/*!40000 ALTER TABLE `stack_tag` DISABLE KEYS */;
INSERT INTO `stack_tag` (`id`, `created_at`, `updated_at`, `tag`, `stack_id`) VALUES (1,'2025-12-16 15:47:56',NULL,'foo','af3bef1c-23ea-4de8-8f9e-990b21f7874a'),(2,'2025-12-16 15:47:56',NULL,'data-processing-cluster','af3bef1c-23ea-4de8-8f9e-990b21f7874a');
/*!40000 ALTER TABLE `stack_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_point`
--

DROP TABLE IF EXISTS `sync_point`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sync_point` (
  `entity_id` varchar(36) NOT NULL,
  `traversal_id` varchar(36) NOT NULL,
  `is_update` tinyint(1) NOT NULL,
  `atomic_key` int(11) NOT NULL,
  `stack_id` varchar(36) NOT NULL,
  `input_data` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`traversal_id`,`is_update`),
  KEY `fk_stack_id` (`stack_id`),
  CONSTRAINT `fk_stack_id` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_point`
--

LOCK TABLES `sync_point` WRITE;
/*!40000 ALTER TABLE `sync_point` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_point` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_creds`
--

DROP TABLE IF EXISTS `user_creds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_creds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `username` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `region_name` varchar(255) DEFAULT NULL,
  `decrypt_method` varchar(64) DEFAULT NULL,
  `tenant` varchar(1024) DEFAULT NULL,
  `auth_url` text DEFAULT NULL,
  `tenant_id` varchar(256) DEFAULT NULL,
  `trust_id` varchar(255) DEFAULT NULL,
  `trustor_user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_creds`
--

LOCK TABLES `user_creds` WRITE;
/*!40000 ALTER TABLE `user_creds` DISABLE KEYS */;
INSERT INTO `user_creds` (`id`, `created_at`, `updated_at`, `username`, `password`, `region_name`, `decrypt_method`, `tenant`, `auth_url`, `tenant_id`, `trust_id`, `trustor_user_id`) VALUES (2,'2025-12-16 15:43:46',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','a1d76f472c5c41faa4158134dd714a29','gAAAAABpQX4ydIATeyaSVum_WYNF4qmwvQr3MFmj-KUV1Ky5OFjwGU3bei_J496RJoRfaak-35o1Kc-XqTxgrWNmr84XdDueEgkzUkadxpOHKm7UQ4p2pDySbwfLuZRl2UVBVjjtBrX7','ecae539dbc2149c18cc30a7bfe376ce5'),(3,'2025-12-16 15:43:46',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','a1d76f472c5c41faa4158134dd714a29','gAAAAABpQX4ynRnpDojoQaF2eNyWT4PP270mhAuemf2kGJ-j1HITyzT5vxJ89yhdiHno8hSouVWPL4OuwnKcuF__TSePn6lkgUDMQFMXDvHw4z4mamFKeUHS1HnR-cbfMVP_MMAv1dsh','ecae539dbc2149c18cc30a7bfe376ce5'),(4,'2025-12-16 15:43:46',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','a1d76f472c5c41faa4158134dd714a29','gAAAAABpQX4yAi6lAAfuMQdr3UKCallVZYObPby2co8RP1CE2KhwCY0ZSFHWHIClYBouD_-nuB9Xff5jdXW_2JqApyB1X_rjLLwNinvcWY2yO-Oih5ip9rb-fG5k1zMKgZEmZShyAk_j','ecae539dbc2149c18cc30a7bfe376ce5'),(5,'2025-12-16 15:43:47',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','a1d76f472c5c41faa4158134dd714a29','gAAAAABpQX4zLHg3cVAyxtow-9JTUABPLlbKk_BsyTiEQ2WnCjJPMNlrXG3w5FWDi-kyUKbRB_VWVUetsGlvu5XPhRpVSXQsNGOv-Qqt5H8YNz4Z88evApYDJgpCBm61ja5HdDwotkud','ecae539dbc2149c18cc30a7bfe376ce5'),(6,'2025-12-16 15:43:48',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','a1d76f472c5c41faa4158134dd714a29','gAAAAABpQX40Tp34kYnCp14l3CgXG5b-WkAzZXkeidPesS7VFvvLbviK3VWtWG-d2OHyrAZD22V27pMtY5vz-SMytkUKjyr8azE9h6TrtemdLkvN0Rf1GC7o5peFCWbYU_tKbq7y6z-y','ecae539dbc2149c18cc30a7bfe376ce5'),(7,'2025-12-16 15:43:51',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','a1d76f472c5c41faa4158134dd714a29','gAAAAABpQX43EyCs_5tot9DiEROF7jxVcK3j2yyJZFadY_AKPU5JECgI8ShLOImubFOpBRhWdZMA_NQZ5QAH4wvTaRNsDeyCmv7fCMc3t0jkIgA0-sQMfwrQZVy9aJ2d3B8rF5U-ehCU','ecae539dbc2149c18cc30a7bfe376ce5'),(11,'2025-12-16 15:43:58',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','a1d76f472c5c41faa4158134dd714a29','gAAAAABpQX4-4G-R2QpTHIgHHRtB2vtprf3NnqrEXV0lOv9ydqbh83KQ_ZrsXqbHzcysa7oVo42VI3TeZZA06g-4KHQPHpZiOst3rzyVastcNcfjzgoJj4np1jgDgY4vM9a0taPlrZTf','ecae539dbc2149c18cc30a7bfe376ce5'),(12,'2025-12-16 15:44:00',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','a1d76f472c5c41faa4158134dd714a29','gAAAAABpQX5AKY-mleNo31nZpoVHai-dWoWVdWIkHVbnYCoCP9HySbqsjk0svq3DOPmkJ0rLbjBWir7ckZaLUMPoEyzhtE1x4Vs3ebkXkNMzI6PQT0iYwp2FW3otlyjLzMdWKztStIcf','ecae539dbc2149c18cc30a7bfe376ce5'),(14,'2025-12-16 15:44:02',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','a1d76f472c5c41faa4158134dd714a29','gAAAAABpQX5CdHrpjucQVVRAgyOzUvX6cOFq99fDe81jt5z3U_-BsP_UbuPQwhiL-zND1FmWuZ_nzhsXbNpC1sx4_LdjxNqiua-tn6Yh6_d7uMeI_k0-ZQryJf2LH1Yz4bVznBgTsdKy','ecae539dbc2149c18cc30a7bfe376ce5');
/*!40000 ALTER TABLE `user_creds` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `external_id` (`external_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','26b2b6895c2c44f1b2aff566e9d1811f','13a37d0163bf46c7adb9285bf1d8990f','4bb3767521294a128b8f8124a01be0b5',0),('UserProject','26b2b6895c2c44f1b2aff566e9d1811f','13a37d0163bf46c7adb9285bf1d8990f','897d13fff8b74640bfbbedeac5a66ba3',0),('UserProject','35b73a3389ef48dfa9ada047442b987b','13a37d0163bf46c7adb9285bf1d8990f','4bb3767521294a128b8f8124a01be0b5',0),('UserProject','35b73a3389ef48dfa9ada047442b987b','13a37d0163bf46c7adb9285bf1d8990f','897d13fff8b74640bfbbedeac5a66ba3',0),('UserProject','7d01aa0505f14b82898c65d8bac8a487','13a37d0163bf46c7adb9285bf1d8990f','4bb3767521294a128b8f8124a01be0b5',0),('UserProject','7d01aa0505f14b82898c65d8bac8a487','13a37d0163bf46c7adb9285bf1d8990f','897d13fff8b74640bfbbedeac5a66ba3',0),('UserProject','7d01aa0505f14b82898c65d8bac8a487','13a37d0163bf46c7adb9285bf1d8990f','f740dcc92d7d403badb62560dcf800f8',0),('UserProject','82ff9b7390d945a5a88d6fe48c6f42b4','a1d76f472c5c41faa4158134dd714a29','897d13fff8b74640bfbbedeac5a66ba3',0),('UserProject','82ff9b7390d945a5a88d6fe48c6f42b4','a2d874eb451e455db9e546be3b064c5e','897d13fff8b74640bfbbedeac5a66ba3',0),('UserProject','84a607660d884a7baef3327f48342c40','13a37d0163bf46c7adb9285bf1d8990f','4bb3767521294a128b8f8124a01be0b5',0),('UserProject','84a607660d884a7baef3327f48342c40','13a37d0163bf46c7adb9285bf1d8990f','897d13fff8b74640bfbbedeac5a66ba3',0),('UserProject','8eb47f68ce0240d7a56bbbb41d267986','13a37d0163bf46c7adb9285bf1d8990f','4bb3767521294a128b8f8124a01be0b5',0),('UserProject','8eb47f68ce0240d7a56bbbb41d267986','13a37d0163bf46c7adb9285bf1d8990f','897d13fff8b74640bfbbedeac5a66ba3',0),('UserProject','960094c791ae466295e45611ab960fc7','13a37d0163bf46c7adb9285bf1d8990f','4bb3767521294a128b8f8124a01be0b5',0),('UserProject','960094c791ae466295e45611ab960fc7','13a37d0163bf46c7adb9285bf1d8990f','897d13fff8b74640bfbbedeac5a66ba3',0),('UserProject','9c05bd9bf2d14e859427cc2c46a6c2b2','13a37d0163bf46c7adb9285bf1d8990f','4bb3767521294a128b8f8124a01be0b5',0),('UserProject','9c05bd9bf2d14e859427cc2c46a6c2b2','13a37d0163bf46c7adb9285bf1d8990f','897d13fff8b74640bfbbedeac5a66ba3',0),('UserProject','c9794a7c6d7e4bf09d6ed563bb6536e1','13a37d0163bf46c7adb9285bf1d8990f','4bb3767521294a128b8f8124a01be0b5',0),('UserProject','c9794a7c6d7e4bf09d6ed563bb6536e1','13a37d0163bf46c7adb9285bf1d8990f','897d13fff8b74640bfbbedeac5a66ba3',0),('UserProject','df27e3a707344a4da8ba9cce3cdb0a92','13a37d0163bf46c7adb9285bf1d8990f','4bb3767521294a128b8f8124a01be0b5',0),('UserProject','df27e3a707344a4da8ba9cce3cdb0a92','13a37d0163bf46c7adb9285bf1d8990f','897d13fff8b74640bfbbedeac5a66ba3',0),('UserProject','ecae539dbc2149c18cc30a7bfe376ce5','a1d76f472c5c41faa4158134dd714a29','3d9e32e52cff430782ff93d9bcb197d0',0),('UserDomain','7d3deaf17fc24841a9aaec68e8c0e2f5','64b01a74480240668bed479759066e9d','897d13fff8b74640bfbbedeac5a66ba3',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('0457eb96a54f4cb0a6ded6bbdf7cc72e',NULL,'public','555f8e126eeb476d91c04da7f6e16177','https://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('0b92910f164549829cbaff97631155fb',NULL,'internal','bc48602256024b5e963e040593ee0558','https://heat-api-internal.openstack.svc:8004/v1/%(tenant_id)s','{\"name\": \"heat\"}',1,'regionOne'),('10dcb3abbb744a40a4f5d875988b3766',NULL,'internal','ca40cbda16fb4023b451aaa042cb7e62','https://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('17a04de6a25247cebdebe9f47685f05e',NULL,'internal','d40c0625f3de4239a9c746508875ce91','https://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('1fc2dfe3c3784d42a22770cbae8e3be8',NULL,'public','fe0762ef00f54ea489d8a73b0ee7fb7c','https://heat-cfnapi-public-openstack.apps-crc.testing/v1','{\"name\": \"heat-cfn\"}',1,'regionOne'),('31206902f48e439284ce1533c3a2fca4',NULL,'internal','7665e4dc19f34ad580b0a968074c4615','https://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('3fdfe416947649eb918e90b267d5d4eb',NULL,'public','f93bb7c638d74d838904c3c303b8a488','https://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('44598222d4ed42de81e08e7b3231a7ec',NULL,'internal','a621c776ed1f47bb81626772aa947752','https://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('49e794a59a614327ab4eea462f7dad31',NULL,'public','a621c776ed1f47bb81626772aa947752','https://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('7673046f079e44f697b83fbc131a512d',NULL,'public','0d4d4960a7a948a6bab38077a71be210','https://swift-public-openstack.apps-crc.testing/v1/AUTH_%(tenant_id)s','{\"name\": \"swift\"}',1,'regionOne'),('7f3fc67a4ef04ebfb1c9a9292e9d7489',NULL,'public','6c828b0dbad044129e35ce86508560d0','https://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('9d5a2a9ba2c842c297d16d62982322db',NULL,'internal','6c828b0dbad044129e35ce86508560d0','https://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('b0463d5ff31547bfae07986e712d06ea',NULL,'internal','f93bb7c638d74d838904c3c303b8a488','https://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('b509a4ed273f4648a11966dde9710a26',NULL,'public','ca40cbda16fb4023b451aaa042cb7e62','https://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('ca28ead55e9c47d787c010fcc0953d01',NULL,'internal','555f8e126eeb476d91c04da7f6e16177','https://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('ddb5accdb51a423ebb1309d020f07191',NULL,'internal','0d4d4960a7a948a6bab38077a71be210','https://swift-internal.openstack.svc:8080/v1/AUTH_%(tenant_id)s','{\"name\": \"swift\"}',1,'regionOne'),('e111ddcdaa574689ab5fdfe61d4ac90e',NULL,'public','d40c0625f3de4239a9c746508875ce91','https://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('e1c48c3af82b44428f7e0e667d55cb0d',NULL,'public','bc48602256024b5e963e040593ee0558','https://heat-api-public-openstack.apps-crc.testing/v1/%(tenant_id)s','{\"name\": \"heat\"}',1,'regionOne'),('f0e5069451b4424c92f0db897de7cf8e',NULL,'internal','fe0762ef00f54ea489d8a73b0ee7fb7c','https://heat-cfnapi-internal.openstack.svc:8000/v1','{\"name\": \"heat-cfn\"}',1,'regionOne'),('fc749cb299de4292b7acd6c382498961',NULL,'public','7665e4dc19f34ad580b0a968074c4615','https://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('3d9e32e52cff430782ff93d9bcb197d0','04c0b6cccc0246a087bf1022739654dc'),('897d13fff8b74640bfbbedeac5a66ba3','3d9e32e52cff430782ff93d9bcb197d0');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (1,'82ff9b7390d945a5a88d6fe48c6f42b4','default','admin',0,NULL),(2,'c9794a7c6d7e4bf09d6ed563bb6536e1','default','cinder',0,NULL),(3,'7d3deaf17fc24841a9aaec68e8c0e2f5','64b01a74480240668bed479759066e9d','heat_stack_domain_admin',0,NULL),(4,'26b2b6895c2c44f1b2aff566e9d1811f','default','glance',0,NULL),(5,'960094c791ae466295e45611ab960fc7','default','nova',0,NULL),(6,'84a607660d884a7baef3327f48342c40','default','barbican',0,NULL),(7,'7d01aa0505f14b82898c65d8bac8a487','default','ceilometer',0,NULL),(8,'9c05bd9bf2d14e859427cc2c46a6c2b2','default','swift',0,NULL),(9,'df27e3a707344a4da8ba9cce3cdb0a92','default','placement',0,NULL),(10,'35b73a3389ef48dfa9ada047442b987b','default','neutron',0,NULL),(11,'8eb47f68ce0240d7a56bbbb41d267986','default','heat',0,NULL),(12,'ecae539dbc2149c18cc30a7bfe376ce5','default','demo_tempestconf',0,NULL),(13,'12531aea3d6649df87382a5e64a8a932','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (1,1,NULL,0,'$2b$12$wjYoq.S1kiKBDF7Fg5B9Nu6URsSHSEYkCLqnuHM/bGnqQX25LVyZy',1765898112244780,NULL,'2025-12-16 15:15:12'),(2,2,NULL,0,'$2b$12$KrCoLyqQn5W39kg2Hdt4SurxXb2mBeTNAHklHK5LOkiSFBeT/umjK',1765898179952730,NULL,'2025-12-16 15:16:19'),(3,3,NULL,0,'$2b$12$B4iDJPjd/.NAWNQ00HF8aebGnTG7pGIaNf2XThgEdZAcIdSuKDIB.',1765898182626863,NULL,'2025-12-16 15:16:22'),(4,4,NULL,0,'$2b$12$aIRvDYNP3WERXyAEtqmzxe2eoSJTtGjY7VX/gD01zayJ1Eu6.AMzm',1765898186559610,NULL,'2025-12-16 15:16:26'),(5,5,NULL,0,'$2b$12$BS3BojS71JX9Y1ON.cIRwOf5YTwb/MZVhzMaJKG8ZuHUSQyGJ6J4a',1765898189532207,NULL,'2025-12-16 15:16:29'),(6,6,NULL,0,'$2b$12$ktbEdYU6JViWyWaLZVwV5.8YNaO7.qwoZW/9NM.6R3xBr43RhmCCy',1765898194886485,NULL,'2025-12-16 15:16:34'),(7,7,NULL,0,'$2b$12$UZqbA1to/vfP5A1Da86K6emf.kIZ/79kINlM4wVzRlziZ5BbU/mXO',1765898201053621,NULL,'2025-12-16 15:16:41'),(8,8,NULL,0,'$2b$12$gybeu1gw7YsUieUfp9XIcuTWZUgx1nRmZXimXOJwR2IBZMdzz4A4G',1765898206913519,NULL,'2025-12-16 15:16:46'),(9,9,NULL,0,'$2b$12$2fll8NoaG3miM2n3Bq3oM.0nBRZsrnovpilM15vYX4NPsAush6pRW',1765898212344806,NULL,'2025-12-16 15:16:52'),(10,10,NULL,0,'$2b$12$WFXCfX9RLI2ivdQX087qKejQ3qnZ0UPee0FgImke8cHshQ79/XODO',1765898216244824,NULL,'2025-12-16 15:16:56'),(11,11,NULL,0,'$2b$12$a8sFGWTMXPb4Cq6VppmQ4uCvX.ztnqLcn.tncIYjg0V0CGlLjoD.2',1765898235719516,NULL,'2025-12-16 15:17:15'),(12,12,NULL,0,'$2b$12$Ha6JO4o14graPkWYwQEOe.ehlLGerKqAzTCAF2QWhZZgMu.tdZkda',1765899796094246,NULL,'2025-12-16 15:43:16'),(13,13,NULL,0,'$2b$12$Al1FLdhprUv/ARlz0Ha5zubC7hd6ipGf.uxgru.w0lNSSddM3TuAO',1765899796545749,NULL,'2025-12-16 15:43:16');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('12a7d3c8539a441d99e5f296f2162c09','a1d76f472c5c41faa4158134dd714a29-8606424d-0c4c-44e0-9d9d-aa9a306','{}','Heat stack user project',1,'64b01a74480240668bed479759066e9d','64b01a74480240668bed479759066e9d',0),('13a37d0163bf46c7adb9285bf1d8990f','service','{}','service',1,'default','default',0),('343787a27d2e46f595aee2ec4606f433','a1d76f472c5c41faa4158134dd714a29-ff434bb3-7cc5-4848-9d1e-8f0f46a','{}','Heat stack user project',1,'64b01a74480240668bed479759066e9d','64b01a74480240668bed479759066e9d',0),('5bc5c378735448a183ba112dde3a2e8f','a1d76f472c5c41faa4158134dd714a29-d86d5f46-7405-4fe4-a7fe-98b2c8e','{}','Heat stack user project',1,'64b01a74480240668bed479759066e9d','64b01a74480240668bed479759066e9d',0),('64b01a74480240668bed479759066e9d','heat_stack','{}','Domain for Heat stacks',1,'<<keystone.domain.root>>',NULL,1),('7007717ee252419989523c5b833d0df7','a1d76f472c5c41faa4158134dd714a29-c3e36837-2427-4bae-8974-8ed5fe9','{}','Heat stack user project',1,'64b01a74480240668bed479759066e9d','64b01a74480240668bed479759066e9d',0),('731b91ba596e4499b3008b082a44fc7f','a1d76f472c5c41faa4158134dd714a29-57b21988-2b6c-4d16-8c6b-498a33e','{}','Heat stack user project',1,'64b01a74480240668bed479759066e9d','64b01a74480240668bed479759066e9d',0),('8e19dc32f60d4c55afae88e1d34e0d27','a1d76f472c5c41faa4158134dd714a29-538c1c0b-52c5-4656-a5f6-52bdc87','{}','Heat stack user project',1,'64b01a74480240668bed479759066e9d','64b01a74480240668bed479759066e9d',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('a1d76f472c5c41faa4158134dd714a29','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('a2d874eb451e455db9e546be3b064c5e','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0),('a66c17e3d0044dfba340a8fa7f6bda5d','a1d76f472c5c41faa4158134dd714a29-61644de6-5a50-49ec-849e-4d04ca5','{}','Heat stack user project',1,'64b01a74480240668bed479759066e9d','64b01a74480240668bed479759066e9d',0),('bef8dc386946430d9805a45a40f95009','a1d76f472c5c41faa4158134dd714a29-bdc8fd20-a3af-4063-992d-faddbf7','{}','Heat stack user project',1,'64b01a74480240668bed479759066e9d','64b01a74480240668bed479759066e9d',0),('d681a3cf95a44b3699bdd747e2fbfe88','a1d76f472c5c41faa4158134dd714a29-bb7c0259-ff79-464c-b821-75f954c','{}','Heat stack user project',1,'64b01a74480240668bed479759066e9d','64b01a74480240668bed479759066e9d',0),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1),('eea821bb883d4acf8a28e2a417eb2567','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=163 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (1,NULL,NULL,NULL,NULL,'2f73d00ad6414e8aa8de1fb0cab56ec3',NULL,NULL,'2025-12-16 15:43:50',NULL,'2025-12-16 15:43:50',NULL,NULL),(2,NULL,'9ec51a09790c4497a08209faa3576588',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:43:51',NULL,'2025-12-16 15:43:51',NULL,NULL),(3,NULL,NULL,NULL,NULL,'296a8ff4293e46cdb176e748e34bd0e4',NULL,NULL,'2025-12-16 15:43:58',NULL,'2025-12-16 15:43:58',NULL,NULL),(4,NULL,NULL,NULL,NULL,'7d3de9b8516e4c24b6d639f27a4a3f54',NULL,NULL,'2025-12-16 15:43:58',NULL,'2025-12-16 15:43:58',NULL,NULL),(5,NULL,'86111f0079b141668d0f56dde183fa2c',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:43:58',NULL,'2025-12-16 15:43:58',NULL,NULL),(6,NULL,'368c062d7e0a401882c1e0ab837b02ab',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:43:59',NULL,'2025-12-16 15:43:59',NULL,NULL),(7,NULL,NULL,NULL,NULL,'685c91e324904ead982e2a5ac8057b25',NULL,NULL,'2025-12-16 15:44:00',NULL,'2025-12-16 15:44:00',NULL,NULL),(8,NULL,'e950f218d67d4949a0d9133c5b6173ad',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:44:00',NULL,'2025-12-16 15:44:00',NULL,NULL),(9,NULL,NULL,NULL,NULL,'f44ede1814ff482e865b917a1e7b3a86',NULL,NULL,'2025-12-16 15:44:02',NULL,'2025-12-16 15:44:02',NULL,NULL),(10,NULL,'4d1905d6c675442681ea3067c66b5a6f',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:44:02',NULL,'2025-12-16 15:44:02',NULL,NULL),(11,NULL,NULL,NULL,NULL,'f5c5ca530aad44a28c647314b5a8ba12',NULL,NULL,'2025-12-16 15:44:03',NULL,'2025-12-16 15:44:03',NULL,NULL),(12,NULL,'5fe1d1dd97c8477eb4ef498cf91eba68',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:44:04',NULL,'2025-12-16 15:44:04',NULL,NULL),(13,NULL,NULL,NULL,NULL,'0b281c5e99044f3c9cc57fda8d13d0d3',NULL,NULL,'2025-12-16 15:44:16',NULL,'2025-12-16 15:44:16',NULL,NULL),(14,NULL,'1433f9d2e9d94f3d9f9cb8195f351720',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:44:16',NULL,'2025-12-16 15:44:16',NULL,NULL),(15,NULL,NULL,NULL,NULL,'9719be6072534bc3a87831a9dd31110c',NULL,NULL,'2025-12-16 15:44:20',NULL,'2025-12-16 15:44:20',NULL,NULL),(16,NULL,'6fa822cda401414fba8be2d3387fad70',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:44:21',NULL,'2025-12-16 15:44:21',NULL,NULL),(17,NULL,NULL,NULL,NULL,'758510299e2645bd88d7a9414ffaa733',NULL,NULL,'2025-12-16 15:44:26',NULL,'2025-12-16 15:44:26',NULL,NULL),(18,NULL,'f7d7af1f6d20429ba86585c2d43f400b',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:44:27',NULL,'2025-12-16 15:44:27',NULL,NULL),(19,NULL,NULL,NULL,NULL,'0ed3a457f5404f4a923858521b02be98',NULL,NULL,'2025-12-16 15:44:32',NULL,'2025-12-16 15:44:32',NULL,NULL),(20,NULL,'b8632f5d854c4037bf2a15b946b5f6ed',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:44:32',NULL,'2025-12-16 15:44:32',NULL,NULL),(21,NULL,NULL,NULL,NULL,'73c2def40e13465d9de71903d5719c80',NULL,NULL,'2025-12-16 15:44:33',NULL,'2025-12-16 15:44:33',NULL,NULL),(22,NULL,'b8d29ed60a234483a1398a060c9ca1f1',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:44:34',NULL,'2025-12-16 15:44:34',NULL,NULL),(23,NULL,NULL,NULL,NULL,'29403af510c14f27a6d0276b70cbfc2a',NULL,NULL,'2025-12-16 15:44:37',NULL,'2025-12-16 15:44:37',NULL,NULL),(24,NULL,'b2f43d5299e640fabc9af685f499706f',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:44:38',NULL,'2025-12-16 15:44:38',NULL,NULL),(25,NULL,NULL,NULL,NULL,'d2e21d0fab5d441b877910d42dd663d3',NULL,NULL,'2025-12-16 15:44:44',NULL,'2025-12-16 15:44:44',NULL,NULL),(26,NULL,'61b1b38c96eb464fa30fb3c6dd2f1e19',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:44:45',NULL,'2025-12-16 15:44:45',NULL,NULL),(27,NULL,NULL,NULL,NULL,'ee0090d99b9340d0986ac444cabda234',NULL,NULL,'2025-12-16 15:44:45',NULL,'2025-12-16 15:44:45',NULL,NULL),(28,NULL,'1ead1488ab2841129943e31604563930',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:44:46',NULL,'2025-12-16 15:44:46',NULL,NULL),(29,NULL,NULL,NULL,NULL,'1b04adf6270846529cd4bf0bb3278e84',NULL,NULL,'2025-12-16 15:44:46',NULL,'2025-12-16 15:44:46',NULL,NULL),(30,NULL,'f8ed914456ff4055a74dac02803d9152',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:44:47',NULL,'2025-12-16 15:44:47',NULL,NULL),(31,NULL,NULL,NULL,NULL,'91a5a1849583408a95684c950a06a9f8',NULL,NULL,'2025-12-16 15:44:56',NULL,'2025-12-16 15:44:56',NULL,NULL),(32,NULL,'bc157a430ef54a4d8252852fde75fc9a',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:44:57',NULL,'2025-12-16 15:44:57',NULL,NULL),(33,NULL,NULL,NULL,NULL,'76b92f14caef4bbd82b96a55c22acfa4',NULL,NULL,'2025-12-16 15:45:04',NULL,'2025-12-16 15:45:04',NULL,NULL),(34,NULL,NULL,NULL,NULL,'54e7d34da1cc4d7b90cc6d8aaacd98bb',NULL,NULL,'2025-12-16 15:45:04',NULL,'2025-12-16 15:45:04',NULL,NULL),(35,NULL,'7cbefaf8f78344068562fd1bd7fbbe37',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:45:04',NULL,'2025-12-16 15:45:04',NULL,NULL),(36,NULL,'7bea8e5fd5884a24ac58b27edfa2eee3',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:45:05',NULL,'2025-12-16 15:45:05',NULL,NULL),(37,NULL,NULL,NULL,NULL,'328ae514e9fa441faaba6950ac4217a8',NULL,NULL,'2025-12-16 15:45:10',NULL,'2025-12-16 15:45:10',NULL,NULL),(38,NULL,'d35b256cb42d4f38b9b87d08220deeaf',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:45:10',NULL,'2025-12-16 15:45:10',NULL,NULL),(39,NULL,NULL,NULL,NULL,'f1f31744f4cd47b39e5784da715a3df2',NULL,NULL,'2025-12-16 15:45:17',NULL,'2025-12-16 15:45:17',NULL,NULL),(40,NULL,'81db4a1fb811483ab55dc2231c005ace',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:45:18',NULL,'2025-12-16 15:45:18',NULL,NULL),(41,NULL,NULL,NULL,NULL,'1a59867fece644dabc53cee51865e586',NULL,NULL,'2025-12-16 15:45:20',NULL,'2025-12-16 15:45:20',NULL,NULL),(42,NULL,'590575305d504649bde90c4fa3b54935',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:45:20',NULL,'2025-12-16 15:45:20',NULL,NULL),(43,NULL,NULL,NULL,NULL,'76837b647c3348a9ae8a7edd768b0dd5',NULL,NULL,'2025-12-16 15:45:30',NULL,'2025-12-16 15:45:30',NULL,NULL),(44,NULL,'a034b6a54e6d42d7832f9b98d8e3fc48',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:45:30',NULL,'2025-12-16 15:45:30',NULL,NULL),(45,NULL,NULL,NULL,NULL,'3c0171f5f10b4936ae094f7d6a587be7',NULL,NULL,'2025-12-16 15:45:37',NULL,'2025-12-16 15:45:37',NULL,NULL),(46,NULL,'cd3c1582204841488ca760ab2902f78d',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:45:37',NULL,'2025-12-16 15:45:37',NULL,NULL),(47,NULL,NULL,NULL,NULL,'38c94dd31f6e42739d0b99519b1cee84',NULL,NULL,'2025-12-16 15:45:38',NULL,'2025-12-16 15:45:38',NULL,NULL),(48,NULL,'3a450ace3a4540928805187f471e4d59',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:45:39',NULL,'2025-12-16 15:45:39',NULL,NULL),(49,NULL,NULL,NULL,NULL,'bee0fb5fbd534b689bb00b7240d7c1b8',NULL,NULL,'2025-12-16 15:45:45',NULL,'2025-12-16 15:45:45',NULL,NULL),(50,NULL,'b888dade4108483899eff67c658f3a24',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:45:45',NULL,'2025-12-16 15:45:45',NULL,NULL),(51,NULL,NULL,NULL,NULL,'5785e85c73cb4432bf12e73117d842ce',NULL,NULL,'2025-12-16 15:45:53',NULL,'2025-12-16 15:45:53',NULL,NULL),(52,NULL,'9c2e894176734b39877e4c0f88346759',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:45:54',NULL,'2025-12-16 15:45:54',NULL,NULL),(53,NULL,NULL,NULL,NULL,'d5f4092d45014263bc4ab1addb65ae7c',NULL,NULL,'2025-12-16 15:45:54',NULL,'2025-12-16 15:45:54',NULL,NULL),(54,NULL,'04a1f6aceb6f4ad7ab2e9765d258239a',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:45:54',NULL,'2025-12-16 15:45:54',NULL,NULL),(55,NULL,NULL,NULL,NULL,'08784ddb729b4eef876b2451969c0ce6',NULL,NULL,'2025-12-16 15:46:13',NULL,'2025-12-16 15:46:13',NULL,NULL),(56,NULL,'06cb2b5438d84fb3b4b69a66ae5e82de',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:46:13',NULL,'2025-12-16 15:46:13',NULL,NULL),(57,NULL,NULL,NULL,NULL,'0316fc898d634033b2a77713a25cf132',NULL,NULL,'2025-12-16 15:46:15',NULL,'2025-12-16 15:46:15',NULL,NULL),(58,NULL,'f9d4aae5f5b342f283e547c298e1583d',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:46:16',NULL,'2025-12-16 15:46:16',NULL,NULL),(59,NULL,NULL,NULL,NULL,'9f4a432a2a56448d8bbd779ca62129ad',NULL,NULL,'2025-12-16 15:46:18',NULL,'2025-12-16 15:46:18',NULL,NULL),(60,NULL,'a66d42e30f45448cad3cc4071387a472',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:46:19',NULL,'2025-12-16 15:46:19',NULL,NULL),(61,NULL,NULL,NULL,NULL,'03e0e7823bcd4f1d9d6b7168379533dc',NULL,NULL,'2025-12-16 15:46:23',NULL,'2025-12-16 15:46:23',NULL,NULL),(62,NULL,'4f5b1cd3dc624b77862cdc295f3054b4',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:46:23',NULL,'2025-12-16 15:46:23',NULL,NULL),(63,NULL,NULL,NULL,NULL,'bc27dc0c8d0a4cbabc431c40d890d247',NULL,NULL,'2025-12-16 15:46:25',NULL,'2025-12-16 15:46:25',NULL,NULL),(64,NULL,'1f8d112038ea4d9dbeea809d3cfb7122',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:46:26',NULL,'2025-12-16 15:46:26',NULL,NULL),(65,NULL,NULL,NULL,NULL,'d7eafb9318f141d68c89f7507b9e2ac1',NULL,NULL,'2025-12-16 15:46:28',NULL,'2025-12-16 15:46:28',NULL,NULL),(66,NULL,'b0a50270805d4796abdaaa8bba41d662',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:46:28',NULL,'2025-12-16 15:46:28',NULL,NULL),(67,NULL,NULL,NULL,NULL,'69b6984390f74b9692d4e30e5f945b93',NULL,NULL,'2025-12-16 15:46:30',NULL,'2025-12-16 15:46:30',NULL,NULL),(68,NULL,'3883d257d82047b18ddeea20ba6dc6d3',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:46:31',NULL,'2025-12-16 15:46:31',NULL,NULL),(69,NULL,NULL,NULL,NULL,'7712257b8ba54919b16b3220c83d0bf3',NULL,NULL,'2025-12-16 15:46:34',NULL,'2025-12-16 15:46:34',NULL,NULL),(70,NULL,'ce7823009e2a453fa0ce791f19d1aef2',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:46:34',NULL,'2025-12-16 15:46:34',NULL,NULL),(71,NULL,NULL,NULL,NULL,'beaffd5056f948c78d7fe58bbc9c9458',NULL,NULL,'2025-12-16 15:46:39',NULL,'2025-12-16 15:46:39',NULL,NULL),(72,NULL,'d3bc39987b5f4040b5321b14176ec3ad',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:46:39',NULL,'2025-12-16 15:46:39',NULL,NULL),(73,NULL,NULL,NULL,NULL,'18bf3f6064724a0681a8d3875c6605d8',NULL,NULL,'2025-12-16 15:46:40',NULL,'2025-12-16 15:46:40',NULL,NULL),(74,NULL,'1f8cd56706ff44afaf5541208aabb51a',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:46:41',NULL,'2025-12-16 15:46:41',NULL,NULL),(75,NULL,NULL,NULL,NULL,'8f0bab05a41a4030984732bfce035092',NULL,NULL,'2025-12-16 15:46:46',NULL,'2025-12-16 15:46:46',NULL,NULL),(76,NULL,'8eda65caab4140bcb971cf78e131f119',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:46:47',NULL,'2025-12-16 15:46:47',NULL,NULL),(77,NULL,NULL,NULL,NULL,'49cf500c10514d36b7e1f1d1d10ee259',NULL,NULL,'2025-12-16 15:47:21',NULL,'2025-12-16 15:47:21',NULL,NULL),(78,NULL,'2198ed0d60d848129d60e3eef3132e2c',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:47:21',NULL,'2025-12-16 15:47:21',NULL,NULL),(79,NULL,NULL,NULL,NULL,'48329292e14244c991567fe751726401',NULL,NULL,'2025-12-16 15:47:23',NULL,'2025-12-16 15:47:23',NULL,NULL),(80,NULL,'00ea663645814cbea34c8201be383ce8',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:47:24',NULL,'2025-12-16 15:47:24',NULL,NULL),(81,NULL,NULL,'bcce05e3202d41fb95d1a7cec3594eca',NULL,NULL,NULL,NULL,'2025-12-16 15:47:30',NULL,'2025-12-16 15:47:30',NULL,NULL),(82,NULL,NULL,'62e86abf97a14ba3abe8a00e1e97ff8e',NULL,NULL,NULL,NULL,'2025-12-16 15:47:31',NULL,'2025-12-16 15:47:31',NULL,NULL),(83,NULL,NULL,'806e53c695464b9bb91716de1696006b',NULL,NULL,NULL,NULL,'2025-12-16 15:47:32',NULL,'2025-12-16 15:47:32',NULL,NULL),(84,NULL,NULL,NULL,NULL,'4f469b34024e4d438fcee530702acd5c',NULL,NULL,'2025-12-16 15:47:34',NULL,'2025-12-16 15:47:34',NULL,NULL),(85,NULL,'55432981b5d74422bdbe9751541e9c69',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:47:35',NULL,'2025-12-16 15:47:35',NULL,NULL),(86,NULL,NULL,'33bdad9ce55347c6a123c14f9e207871',NULL,NULL,NULL,NULL,'2025-12-16 15:47:40',NULL,'2025-12-16 15:47:40',NULL,NULL),(87,NULL,NULL,'0b60a2205dcc4a3ea83899ead77ba575',NULL,NULL,NULL,NULL,'2025-12-16 15:47:41',NULL,'2025-12-16 15:47:41',NULL,NULL),(88,NULL,NULL,'c63a4ae9a1864ebc8dac5c21ec5d3dfb',NULL,NULL,NULL,NULL,'2025-12-16 15:47:42',NULL,'2025-12-16 15:47:42',NULL,NULL),(89,NULL,NULL,NULL,NULL,'4824b4f15f2c454a86e254a70c08ab79',NULL,NULL,'2025-12-16 15:47:43',NULL,'2025-12-16 15:47:43',NULL,NULL),(90,NULL,'fdd02b2ea25a4828b32ed19a07bdf8ba',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:47:44',NULL,'2025-12-16 15:47:44',NULL,NULL),(91,NULL,NULL,NULL,NULL,'c85a442e22c6474aaeb16ebee63da90f',NULL,NULL,'2025-12-16 15:47:48',NULL,'2025-12-16 15:47:48',NULL,NULL),(92,NULL,'a75316c1026d45af8d5afd9a50466404',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:47:48',NULL,'2025-12-16 15:47:48',NULL,NULL),(93,NULL,NULL,'6f1c72de57dd417c8ba4771b173696d9',NULL,NULL,NULL,NULL,'2025-12-16 15:47:48',NULL,'2025-12-16 15:47:48',NULL,NULL),(94,NULL,NULL,'d6ccfbd813be4a5580bfdef56e516722',NULL,NULL,NULL,NULL,'2025-12-16 15:47:50',NULL,'2025-12-16 15:47:50',NULL,NULL),(95,NULL,NULL,'2602d669dbbd4584a9b973de3fd0d225',NULL,NULL,NULL,NULL,'2025-12-16 15:47:50',NULL,'2025-12-16 15:47:50',NULL,NULL),(96,NULL,NULL,NULL,NULL,'4cfab5f0051146328ba27512a773eea8',NULL,NULL,'2025-12-16 15:47:51',NULL,'2025-12-16 15:47:51',NULL,NULL),(97,NULL,'8b7821b2d01143c585c7fab254d28764',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:47:51',NULL,'2025-12-16 15:47:51',NULL,NULL),(98,NULL,NULL,'42a2f49def2c41448c60e2c639f184e2',NULL,NULL,NULL,NULL,'2025-12-16 15:47:55',NULL,'2025-12-16 15:47:55',NULL,NULL),(99,NULL,NULL,'d72d1023e41b474eb71d3009305d51af',NULL,NULL,NULL,NULL,'2025-12-16 15:47:56',NULL,'2025-12-16 15:47:56',NULL,NULL),(100,NULL,NULL,'8c4d966ae4ab4dadbdebb664fee539e9',NULL,NULL,NULL,NULL,'2025-12-16 15:47:56',NULL,'2025-12-16 15:47:56',NULL,NULL),(101,NULL,NULL,'6c82022221124255873e4b348015078e',NULL,NULL,NULL,NULL,'2025-12-16 15:47:56',NULL,'2025-12-16 15:47:56',NULL,NULL),(102,NULL,NULL,'d03baaae5c26422fb26c056060ff4378',NULL,NULL,NULL,NULL,'2025-12-16 15:47:57',NULL,'2025-12-16 15:47:57',NULL,NULL),(103,NULL,NULL,NULL,NULL,'80666192c9ac47bbabe68d39d7252cee',NULL,NULL,'2025-12-16 15:47:58',NULL,'2025-12-16 15:47:58',NULL,NULL),(104,NULL,'9eed10f7c4044610a04e5d48e02211bf',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:47:58',NULL,'2025-12-16 15:47:58',NULL,NULL),(105,NULL,NULL,'c7da2ce4eeeb449f99f434aff055dae0',NULL,NULL,NULL,NULL,'2025-12-16 15:48:02',NULL,'2025-12-16 15:48:02',NULL,NULL),(106,NULL,NULL,'5e7a903d80b74dcf96612b45f8cdee50',NULL,NULL,NULL,NULL,'2025-12-16 15:48:05',NULL,'2025-12-16 15:48:05',NULL,NULL),(107,NULL,NULL,NULL,NULL,'3384ba7708f9456f9148f1839c741411',NULL,NULL,'2025-12-16 15:48:05',NULL,'2025-12-16 15:48:05',NULL,NULL),(108,NULL,'7f037f7454ce4280aafba86a04c0a217',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:48:05',NULL,'2025-12-16 15:48:05',NULL,NULL),(109,NULL,NULL,'5315001f89ed4869984e7726c5f7a5ef',NULL,NULL,NULL,NULL,'2025-12-16 15:48:05',NULL,'2025-12-16 15:48:05',NULL,NULL),(110,NULL,NULL,'b52bd59546874465a75ea836818d6d26',NULL,NULL,NULL,NULL,'2025-12-16 15:48:06',NULL,'2025-12-16 15:48:06',NULL,NULL),(111,NULL,NULL,'ae04e0106f5642a9b5187659331a30a3',NULL,NULL,NULL,NULL,'2025-12-16 15:48:06',NULL,'2025-12-16 15:48:06',NULL,NULL),(112,NULL,NULL,NULL,NULL,'42153a81b3264d4d85d2006c8421d757',NULL,NULL,'2025-12-16 15:48:06',NULL,'2025-12-16 15:48:06',NULL,NULL),(113,NULL,'c87bcd777d6a450c9a88a7163fca0d55',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:48:07',NULL,'2025-12-16 15:48:07',NULL,NULL),(114,NULL,NULL,NULL,NULL,'5f75f1aaae3f4c5e846a664554ad9595',NULL,NULL,'2025-12-16 15:48:08',NULL,'2025-12-16 15:48:08',NULL,NULL),(115,NULL,'907f46d1ce234553bd8f5524d2036bf5',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:48:08',NULL,'2025-12-16 15:48:08',NULL,NULL),(116,NULL,NULL,'731e904e596940a28abd8dc4e8bcff2e',NULL,NULL,NULL,NULL,'2025-12-16 15:48:11',NULL,'2025-12-16 15:48:11',NULL,NULL),(117,NULL,NULL,NULL,NULL,'a50bec48eb4c4482b685a9633780217c',NULL,NULL,'2025-12-16 15:48:14',NULL,'2025-12-16 15:48:14',NULL,NULL),(118,NULL,'cfdd877b656441fe8503defd5359102a',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:48:14',NULL,'2025-12-16 15:48:14',NULL,NULL),(119,NULL,NULL,NULL,NULL,'4b6069e5718e46f799c43ba22ecd1a6a',NULL,NULL,'2025-12-16 15:48:29',NULL,'2025-12-16 15:48:29',NULL,NULL),(120,NULL,'d74b88defd064e0382099783fa740f2d',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:48:29',NULL,'2025-12-16 15:48:29',NULL,NULL),(121,NULL,NULL,NULL,NULL,'e3cd28eed4b14a2c8f11de3f1c730694',NULL,NULL,'2025-12-16 15:48:35',NULL,'2025-12-16 15:48:35',NULL,NULL),(122,NULL,'ea413a5fc9a04cf8b476b498b791c4f5',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:48:36',NULL,'2025-12-16 15:48:36',NULL,NULL),(123,NULL,NULL,NULL,NULL,'279b4c24cfbf4dcab0251abd52fb82b8',NULL,NULL,'2025-12-16 15:48:55',NULL,'2025-12-16 15:48:55',NULL,NULL),(124,NULL,'991037f2982242dd9113477d656b66dc',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:48:56',NULL,'2025-12-16 15:48:56',NULL,NULL),(125,NULL,NULL,'9b35bbc17fa0466e8caaeb35510fd17b',NULL,NULL,NULL,NULL,'2025-12-16 15:49:38',NULL,'2025-12-16 15:49:38',NULL,NULL),(126,NULL,NULL,'819fe53dc33641b4b2f457c7f00215c3',NULL,NULL,NULL,NULL,'2025-12-16 15:49:39',NULL,'2025-12-16 15:49:39',NULL,NULL),(127,NULL,NULL,'de3deb146b054401a5686608969fd5af',NULL,NULL,NULL,NULL,'2025-12-16 15:49:40',NULL,'2025-12-16 15:49:40',NULL,NULL),(128,NULL,NULL,NULL,NULL,'b628150152b14d3696523bfffde29c81',NULL,NULL,'2025-12-16 15:49:43',NULL,'2025-12-16 15:49:43',NULL,NULL),(129,NULL,'29c50621ca294751819a45ca441b1d7a',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:49:43',NULL,'2025-12-16 15:49:43',NULL,NULL),(130,NULL,NULL,'9c9948948ad84eac8437530628f94d11',NULL,NULL,NULL,NULL,'2025-12-16 15:49:48',NULL,'2025-12-16 15:49:48',NULL,NULL),(131,NULL,NULL,NULL,NULL,'9be8f849f2dd4c72bb4bf0d674439ccf',NULL,NULL,'2025-12-16 15:49:52',NULL,'2025-12-16 15:49:52',NULL,NULL),(132,NULL,'63c2ae0ba49b442bbdde23524ecc160a',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:49:52',NULL,'2025-12-16 15:49:52',NULL,NULL),(133,NULL,NULL,NULL,NULL,'ee73c99bd0ba43b19c3b8fea4f423057',NULL,NULL,'2025-12-16 15:49:57',NULL,'2025-12-16 15:49:57',NULL,NULL),(134,NULL,'5938d40b84664d3da3289c874fed0460',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:49:58',NULL,'2025-12-16 15:49:58',NULL,NULL),(135,NULL,NULL,NULL,NULL,'b2f9534a78bc4bc4a4d58db5c3d71597',NULL,NULL,'2025-12-16 15:50:03',NULL,'2025-12-16 15:50:03',NULL,NULL),(136,NULL,'42b4bbefe91e46b289294a80ffb13a73',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:50:04',NULL,'2025-12-16 15:50:04',NULL,NULL),(137,NULL,NULL,NULL,NULL,'5b7edaec97d144cabf48bacdcc6c6da0',NULL,NULL,'2025-12-16 15:50:20',NULL,'2025-12-16 15:50:20',NULL,NULL),(138,NULL,NULL,NULL,NULL,'a96376d84ddf448bb314a0767b153f0e',NULL,NULL,'2025-12-16 15:50:20',NULL,'2025-12-16 15:50:20',NULL,NULL),(139,NULL,'27b187bccbf3403c938f6dd239fc8dd1',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:50:20',NULL,'2025-12-16 15:50:20',NULL,NULL),(140,NULL,'7464b73752c44a1d96b1e0b426cb1004',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:50:20',NULL,'2025-12-16 15:50:20',NULL,NULL),(141,NULL,NULL,NULL,NULL,'0e8c57e1e8d84e269d7a3f0dd2f9fd7e',NULL,NULL,'2025-12-16 15:50:45',NULL,'2025-12-16 15:50:45',NULL,NULL),(142,NULL,'4baca59afb994e79846a1d788eb8a3b6',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:50:45',NULL,'2025-12-16 15:50:45',NULL,NULL),(143,NULL,NULL,NULL,NULL,'ff023c0bc0064a10adc0d52c3244c4d0',NULL,NULL,'2025-12-16 15:51:26',NULL,'2025-12-16 15:51:26',NULL,NULL),(144,NULL,'de192c2956d948d49527668744f4f257',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:51:27',NULL,'2025-12-16 15:51:27',NULL,NULL),(145,NULL,NULL,NULL,NULL,'20b604dc3d1141a38f2327342579abea',NULL,NULL,'2025-12-16 15:52:21',NULL,'2025-12-16 15:52:21',NULL,NULL),(146,NULL,'ba1b9fa3e5ed40a5a977e19ca3985e94',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:52:22',NULL,'2025-12-16 15:52:22',NULL,NULL),(147,NULL,NULL,NULL,NULL,'674ef843504f4f6b9e9d9b7522ca5455',NULL,NULL,'2025-12-16 15:52:28',NULL,'2025-12-16 15:52:28',NULL,NULL),(148,NULL,'2cae36eac24948f8a805c981630d0fd5',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:52:29',NULL,'2025-12-16 15:52:29',NULL,NULL),(149,NULL,NULL,NULL,NULL,'8fc7ae2e2c4d4eb49d005e4de9f4acd0',NULL,NULL,'2025-12-16 15:52:42',NULL,'2025-12-16 15:52:42',NULL,NULL),(150,NULL,NULL,NULL,NULL,'ad588f02ef6640aab8a79c12014e7cb9',NULL,NULL,'2025-12-16 15:52:42',NULL,'2025-12-16 15:52:42',NULL,NULL),(151,NULL,'6ec4004d1919468abc42c25806bfe2d2',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:52:42',NULL,'2025-12-16 15:52:42',NULL,NULL),(152,NULL,'50451e2896fc427ea0cb9e8f83fea547',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:52:43',NULL,'2025-12-16 15:52:43',NULL,NULL),(153,NULL,NULL,NULL,NULL,'cc8ecaa6f508495f81235768635cfaa6',NULL,NULL,'2025-12-16 15:53:10',NULL,'2025-12-16 15:53:10',NULL,NULL),(154,NULL,NULL,NULL,NULL,'bac3914ac8164ab7863d05278a6ef599',NULL,NULL,'2025-12-16 15:53:10',NULL,'2025-12-16 15:53:10',NULL,NULL),(155,NULL,'a9331cc49f484b5f8864953244851036',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:53:11',NULL,'2025-12-16 15:53:11',NULL,NULL),(156,NULL,'5bd3579642b5483cbe86a3fade3de430',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:53:11',NULL,'2025-12-16 15:53:11',NULL,NULL),(157,NULL,NULL,NULL,NULL,'75a645de9d4347a6abb6a1648dc26197',NULL,NULL,'2025-12-16 15:53:30',NULL,'2025-12-16 15:53:30',NULL,NULL),(158,NULL,NULL,NULL,NULL,'5c178c3180504eb1a82976a8cc885d28',NULL,NULL,'2025-12-16 15:53:30',NULL,'2025-12-16 15:53:30',NULL,NULL),(159,NULL,'932e9d9601354d648537568cd5d11e5f',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:53:30',NULL,'2025-12-16 15:53:30',NULL,NULL),(160,NULL,'fbc2e3303359428e8055a4e67bc9dabc',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:53:30',NULL,'2025-12-16 15:53:30',NULL,NULL),(161,NULL,NULL,NULL,NULL,'394902b897384fef92b095a01153e1b0',NULL,NULL,'2025-12-16 15:53:38',NULL,'2025-12-16 15:53:38',NULL,NULL),(162,NULL,'3486dc346f224e3d89204f33cbe14571',NULL,NULL,NULL,NULL,NULL,'2025-12-16 15:53:38',NULL,'2025-12-16 15:53:38',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('04c0b6cccc0246a087bf1022739654dc','reader','{}','<<null>>',NULL),('055d307a473f4902a59525a00bf72881','SwiftProjectReader','{}','<<null>>',NULL),('3d9e32e52cff430782ff93d9bcb197d0','member','{}','<<null>>',NULL),('4bb3767521294a128b8f8124a01be0b5','service','{}','<<null>>',NULL),('897d13fff8b74640bfbbedeac5a66ba3','admin','{}','<<null>>',NULL),('cd0c707923194ef0b9c93d002ebd0bb8','heat_stack_user','{}','<<null>>',NULL),('d9d60e0ad3624e7aa5cccc00d3088cc5','ResellerAdmin','{}','<<null>>',NULL),('f740dcc92d7d403badb62560dcf800f8','SwiftSystemReader','{}','<<null>>',NULL),('fa810b0f1e514c288076eba26b84563e','swiftoperator','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('04c0b6cccc0246a087bf1022739654dc','IMMU','true'),('3d9e32e52cff430782ff93d9bcb197d0','IMMU','true'),('897d13fff8b74640bfbbedeac5a66ba3','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('0d4d4960a7a948a6bab38077a71be210','object-store',1,'{\"description\": \"Swift Object Storage\", \"name\": \"swift\"}'),('555f8e126eeb476d91c04da7f6e16177','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}'),('6c828b0dbad044129e35ce86508560d0','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}'),('7665e4dc19f34ad580b0a968074c4615','identity',1,'{\"name\": \"keystone\"}'),('a621c776ed1f47bb81626772aa947752','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('b8a1f9a439a241c2940e3a5dc279e0c2','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('bc48602256024b5e963e040593ee0558','orchestration',1,'{\"description\": \"Heat API service\", \"name\": \"heat\"}'),('ca40cbda16fb4023b451aaa042cb7e62','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('d40c0625f3de4239a9c746508875ce91','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('f93bb7c638d74d838904c3c303b8a488','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}'),('fe0762ef00f54ea489d8a73b0ee7fb7c','cloudformation',1,'{\"description\": \"Heat Cloudformation API service\", \"name\": \"heat-cfn\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','82ff9b7390d945a5a88d6fe48c6f42b4','system','897d13fff8b74640bfbbedeac5a66ba3',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_trust_id` (`trust_id`),
  KEY `ix_token_expires` (`expires`),
  KEY `ix_token_user_id` (`user_id`),
  KEY `ix_token_expires_valid` (`expires`,`valid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
INSERT INTO `trust` (`id`, `trustor_user_id`, `trustee_user_id`, `project_id`, `impersonation`, `deleted_at`, `expires_at`, `remaining_uses`, `extra`, `expires_at_int`, `redelegated_trust_id`, `redelegation_count`) VALUES ('07cd7580fae54e379eb02f5804c45a2b','ecae539dbc2149c18cc30a7bfe376ce5','8eb47f68ce0240d7a56bbbb41d267986','a1d76f472c5c41faa4158134dd714a29',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"04c0b6cccc0246a087bf1022739654dc\"}, {\"id\": \"3d9e32e52cff430782ff93d9bcb197d0\"}]}',NULL,NULL,0),('4075bbcfa3384e1895c9d9bacf28a87c','ecae539dbc2149c18cc30a7bfe376ce5','8eb47f68ce0240d7a56bbbb41d267986','a1d76f472c5c41faa4158134dd714a29',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"3d9e32e52cff430782ff93d9bcb197d0\"}, {\"id\": \"04c0b6cccc0246a087bf1022739654dc\"}]}',NULL,NULL,0),('51a548eb46d044f7bf2f0bdf4fe83ffd','ecae539dbc2149c18cc30a7bfe376ce5','8eb47f68ce0240d7a56bbbb41d267986','a1d76f472c5c41faa4158134dd714a29',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"04c0b6cccc0246a087bf1022739654dc\"}, {\"id\": \"3d9e32e52cff430782ff93d9bcb197d0\"}]}',NULL,NULL,0),('66a8ce8c82374c2ca26e0b7ee1e42f00','ecae539dbc2149c18cc30a7bfe376ce5','8eb47f68ce0240d7a56bbbb41d267986','a1d76f472c5c41faa4158134dd714a29',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"3d9e32e52cff430782ff93d9bcb197d0\"}, {\"id\": \"04c0b6cccc0246a087bf1022739654dc\"}]}',NULL,NULL,0),('69b74d925a4b49a6aceb67d79411b1ca','ecae539dbc2149c18cc30a7bfe376ce5','8eb47f68ce0240d7a56bbbb41d267986','a1d76f472c5c41faa4158134dd714a29',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"3d9e32e52cff430782ff93d9bcb197d0\"}, {\"id\": \"04c0b6cccc0246a087bf1022739654dc\"}]}',NULL,NULL,0),('70362a4b564f401fbf9f059033328bba','ecae539dbc2149c18cc30a7bfe376ce5','8eb47f68ce0240d7a56bbbb41d267986','a1d76f472c5c41faa4158134dd714a29',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"3d9e32e52cff430782ff93d9bcb197d0\"}, {\"id\": \"04c0b6cccc0246a087bf1022739654dc\"}]}',NULL,NULL,0),('839a72dc4e5a4d4c866c56ca88c32fd5','ecae539dbc2149c18cc30a7bfe376ce5','8eb47f68ce0240d7a56bbbb41d267986','a1d76f472c5c41faa4158134dd714a29',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"3d9e32e52cff430782ff93d9bcb197d0\"}, {\"id\": \"04c0b6cccc0246a087bf1022739654dc\"}]}',NULL,NULL,0),('ac80da51bb1d46178da47dc923b92163','ecae539dbc2149c18cc30a7bfe376ce5','8eb47f68ce0240d7a56bbbb41d267986','a1d76f472c5c41faa4158134dd714a29',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"04c0b6cccc0246a087bf1022739654dc\"}, {\"id\": \"3d9e32e52cff430782ff93d9bcb197d0\"}]}',NULL,NULL,0),('d3c1c22619d4499cb241cdb3151befa7','ecae539dbc2149c18cc30a7bfe376ce5','8eb47f68ce0240d7a56bbbb41d267986','a1d76f472c5c41faa4158134dd714a29',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"3d9e32e52cff430782ff93d9bcb197d0\"}, {\"id\": \"04c0b6cccc0246a087bf1022739654dc\"}]}',NULL,NULL,0);
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
INSERT INTO `trust_role` (`trust_id`, `role_id`) VALUES ('0316fc898d634033b2a77713a25cf132','04c0b6cccc0246a087bf1022739654dc'),('0316fc898d634033b2a77713a25cf132','3d9e32e52cff430782ff93d9bcb197d0'),('03e0e7823bcd4f1d9d6b7168379533dc','04c0b6cccc0246a087bf1022739654dc'),('03e0e7823bcd4f1d9d6b7168379533dc','3d9e32e52cff430782ff93d9bcb197d0'),('07cd7580fae54e379eb02f5804c45a2b','04c0b6cccc0246a087bf1022739654dc'),('07cd7580fae54e379eb02f5804c45a2b','3d9e32e52cff430782ff93d9bcb197d0'),('08784ddb729b4eef876b2451969c0ce6','04c0b6cccc0246a087bf1022739654dc'),('08784ddb729b4eef876b2451969c0ce6','3d9e32e52cff430782ff93d9bcb197d0'),('0b281c5e99044f3c9cc57fda8d13d0d3','04c0b6cccc0246a087bf1022739654dc'),('0b281c5e99044f3c9cc57fda8d13d0d3','3d9e32e52cff430782ff93d9bcb197d0'),('0e8c57e1e8d84e269d7a3f0dd2f9fd7e','04c0b6cccc0246a087bf1022739654dc'),('0e8c57e1e8d84e269d7a3f0dd2f9fd7e','3d9e32e52cff430782ff93d9bcb197d0'),('0ed3a457f5404f4a923858521b02be98','04c0b6cccc0246a087bf1022739654dc'),('0ed3a457f5404f4a923858521b02be98','3d9e32e52cff430782ff93d9bcb197d0'),('18bf3f6064724a0681a8d3875c6605d8','04c0b6cccc0246a087bf1022739654dc'),('18bf3f6064724a0681a8d3875c6605d8','3d9e32e52cff430782ff93d9bcb197d0'),('1a59867fece644dabc53cee51865e586','04c0b6cccc0246a087bf1022739654dc'),('1a59867fece644dabc53cee51865e586','3d9e32e52cff430782ff93d9bcb197d0'),('1b04adf6270846529cd4bf0bb3278e84','04c0b6cccc0246a087bf1022739654dc'),('1b04adf6270846529cd4bf0bb3278e84','3d9e32e52cff430782ff93d9bcb197d0'),('20b604dc3d1141a38f2327342579abea','04c0b6cccc0246a087bf1022739654dc'),('20b604dc3d1141a38f2327342579abea','3d9e32e52cff430782ff93d9bcb197d0'),('279b4c24cfbf4dcab0251abd52fb82b8','04c0b6cccc0246a087bf1022739654dc'),('279b4c24cfbf4dcab0251abd52fb82b8','3d9e32e52cff430782ff93d9bcb197d0'),('29403af510c14f27a6d0276b70cbfc2a','04c0b6cccc0246a087bf1022739654dc'),('29403af510c14f27a6d0276b70cbfc2a','3d9e32e52cff430782ff93d9bcb197d0'),('296a8ff4293e46cdb176e748e34bd0e4','04c0b6cccc0246a087bf1022739654dc'),('296a8ff4293e46cdb176e748e34bd0e4','3d9e32e52cff430782ff93d9bcb197d0'),('2f73d00ad6414e8aa8de1fb0cab56ec3','04c0b6cccc0246a087bf1022739654dc'),('2f73d00ad6414e8aa8de1fb0cab56ec3','3d9e32e52cff430782ff93d9bcb197d0'),('328ae514e9fa441faaba6950ac4217a8','04c0b6cccc0246a087bf1022739654dc'),('328ae514e9fa441faaba6950ac4217a8','3d9e32e52cff430782ff93d9bcb197d0'),('3384ba7708f9456f9148f1839c741411','04c0b6cccc0246a087bf1022739654dc'),('3384ba7708f9456f9148f1839c741411','3d9e32e52cff430782ff93d9bcb197d0'),('38c94dd31f6e42739d0b99519b1cee84','04c0b6cccc0246a087bf1022739654dc'),('38c94dd31f6e42739d0b99519b1cee84','3d9e32e52cff430782ff93d9bcb197d0'),('394902b897384fef92b095a01153e1b0','04c0b6cccc0246a087bf1022739654dc'),('394902b897384fef92b095a01153e1b0','3d9e32e52cff430782ff93d9bcb197d0'),('3c0171f5f10b4936ae094f7d6a587be7','04c0b6cccc0246a087bf1022739654dc'),('3c0171f5f10b4936ae094f7d6a587be7','3d9e32e52cff430782ff93d9bcb197d0'),('4075bbcfa3384e1895c9d9bacf28a87c','04c0b6cccc0246a087bf1022739654dc'),('4075bbcfa3384e1895c9d9bacf28a87c','3d9e32e52cff430782ff93d9bcb197d0'),('42153a81b3264d4d85d2006c8421d757','04c0b6cccc0246a087bf1022739654dc'),('42153a81b3264d4d85d2006c8421d757','3d9e32e52cff430782ff93d9bcb197d0'),('4824b4f15f2c454a86e254a70c08ab79','04c0b6cccc0246a087bf1022739654dc'),('4824b4f15f2c454a86e254a70c08ab79','3d9e32e52cff430782ff93d9bcb197d0'),('48329292e14244c991567fe751726401','04c0b6cccc0246a087bf1022739654dc'),('48329292e14244c991567fe751726401','3d9e32e52cff430782ff93d9bcb197d0'),('49cf500c10514d36b7e1f1d1d10ee259','04c0b6cccc0246a087bf1022739654dc'),('49cf500c10514d36b7e1f1d1d10ee259','3d9e32e52cff430782ff93d9bcb197d0'),('4b6069e5718e46f799c43ba22ecd1a6a','04c0b6cccc0246a087bf1022739654dc'),('4b6069e5718e46f799c43ba22ecd1a6a','3d9e32e52cff430782ff93d9bcb197d0'),('4cfab5f0051146328ba27512a773eea8','04c0b6cccc0246a087bf1022739654dc'),('4cfab5f0051146328ba27512a773eea8','3d9e32e52cff430782ff93d9bcb197d0'),('4f469b34024e4d438fcee530702acd5c','04c0b6cccc0246a087bf1022739654dc'),('4f469b34024e4d438fcee530702acd5c','3d9e32e52cff430782ff93d9bcb197d0'),('51a548eb46d044f7bf2f0bdf4fe83ffd','04c0b6cccc0246a087bf1022739654dc'),('51a548eb46d044f7bf2f0bdf4fe83ffd','3d9e32e52cff430782ff93d9bcb197d0'),('54e7d34da1cc4d7b90cc6d8aaacd98bb','04c0b6cccc0246a087bf1022739654dc'),('54e7d34da1cc4d7b90cc6d8aaacd98bb','3d9e32e52cff430782ff93d9bcb197d0'),('5785e85c73cb4432bf12e73117d842ce','04c0b6cccc0246a087bf1022739654dc'),('5785e85c73cb4432bf12e73117d842ce','3d9e32e52cff430782ff93d9bcb197d0'),('5b7edaec97d144cabf48bacdcc6c6da0','04c0b6cccc0246a087bf1022739654dc'),('5b7edaec97d144cabf48bacdcc6c6da0','3d9e32e52cff430782ff93d9bcb197d0'),('5c178c3180504eb1a82976a8cc885d28','04c0b6cccc0246a087bf1022739654dc'),('5c178c3180504eb1a82976a8cc885d28','3d9e32e52cff430782ff93d9bcb197d0'),('5f75f1aaae3f4c5e846a664554ad9595','04c0b6cccc0246a087bf1022739654dc'),('5f75f1aaae3f4c5e846a664554ad9595','3d9e32e52cff430782ff93d9bcb197d0'),('66a8ce8c82374c2ca26e0b7ee1e42f00','04c0b6cccc0246a087bf1022739654dc'),('66a8ce8c82374c2ca26e0b7ee1e42f00','3d9e32e52cff430782ff93d9bcb197d0'),('674ef843504f4f6b9e9d9b7522ca5455','04c0b6cccc0246a087bf1022739654dc'),('674ef843504f4f6b9e9d9b7522ca5455','3d9e32e52cff430782ff93d9bcb197d0'),('685c91e324904ead982e2a5ac8057b25','04c0b6cccc0246a087bf1022739654dc'),('685c91e324904ead982e2a5ac8057b25','3d9e32e52cff430782ff93d9bcb197d0'),('69b6984390f74b9692d4e30e5f945b93','04c0b6cccc0246a087bf1022739654dc'),('69b6984390f74b9692d4e30e5f945b93','3d9e32e52cff430782ff93d9bcb197d0'),('69b74d925a4b49a6aceb67d79411b1ca','04c0b6cccc0246a087bf1022739654dc'),('69b74d925a4b49a6aceb67d79411b1ca','3d9e32e52cff430782ff93d9bcb197d0'),('70362a4b564f401fbf9f059033328bba','04c0b6cccc0246a087bf1022739654dc'),('70362a4b564f401fbf9f059033328bba','3d9e32e52cff430782ff93d9bcb197d0'),('73c2def40e13465d9de71903d5719c80','04c0b6cccc0246a087bf1022739654dc'),('73c2def40e13465d9de71903d5719c80','3d9e32e52cff430782ff93d9bcb197d0'),('758510299e2645bd88d7a9414ffaa733','04c0b6cccc0246a087bf1022739654dc'),('758510299e2645bd88d7a9414ffaa733','3d9e32e52cff430782ff93d9bcb197d0'),('758510299e2645bd88d7a9414ffaa733','897d13fff8b74640bfbbedeac5a66ba3'),('75a645de9d4347a6abb6a1648dc26197','04c0b6cccc0246a087bf1022739654dc'),('75a645de9d4347a6abb6a1648dc26197','3d9e32e52cff430782ff93d9bcb197d0'),('76837b647c3348a9ae8a7edd768b0dd5','04c0b6cccc0246a087bf1022739654dc'),('76837b647c3348a9ae8a7edd768b0dd5','3d9e32e52cff430782ff93d9bcb197d0'),('76b92f14caef4bbd82b96a55c22acfa4','04c0b6cccc0246a087bf1022739654dc'),('76b92f14caef4bbd82b96a55c22acfa4','3d9e32e52cff430782ff93d9bcb197d0'),('7712257b8ba54919b16b3220c83d0bf3','04c0b6cccc0246a087bf1022739654dc'),('7712257b8ba54919b16b3220c83d0bf3','3d9e32e52cff430782ff93d9bcb197d0'),('7d3de9b8516e4c24b6d639f27a4a3f54','04c0b6cccc0246a087bf1022739654dc'),('7d3de9b8516e4c24b6d639f27a4a3f54','3d9e32e52cff430782ff93d9bcb197d0'),('80666192c9ac47bbabe68d39d7252cee','04c0b6cccc0246a087bf1022739654dc'),('80666192c9ac47bbabe68d39d7252cee','3d9e32e52cff430782ff93d9bcb197d0'),('839a72dc4e5a4d4c866c56ca88c32fd5','04c0b6cccc0246a087bf1022739654dc'),('839a72dc4e5a4d4c866c56ca88c32fd5','3d9e32e52cff430782ff93d9bcb197d0'),('8f0bab05a41a4030984732bfce035092','04c0b6cccc0246a087bf1022739654dc'),('8f0bab05a41a4030984732bfce035092','3d9e32e52cff430782ff93d9bcb197d0'),('8fc7ae2e2c4d4eb49d005e4de9f4acd0','04c0b6cccc0246a087bf1022739654dc'),('8fc7ae2e2c4d4eb49d005e4de9f4acd0','3d9e32e52cff430782ff93d9bcb197d0'),('91a5a1849583408a95684c950a06a9f8','04c0b6cccc0246a087bf1022739654dc'),('91a5a1849583408a95684c950a06a9f8','3d9e32e52cff430782ff93d9bcb197d0'),('9719be6072534bc3a87831a9dd31110c','04c0b6cccc0246a087bf1022739654dc'),('9719be6072534bc3a87831a9dd31110c','3d9e32e52cff430782ff93d9bcb197d0'),('9be8f849f2dd4c72bb4bf0d674439ccf','04c0b6cccc0246a087bf1022739654dc'),('9be8f849f2dd4c72bb4bf0d674439ccf','3d9e32e52cff430782ff93d9bcb197d0'),('9f4a432a2a56448d8bbd779ca62129ad','04c0b6cccc0246a087bf1022739654dc'),('9f4a432a2a56448d8bbd779ca62129ad','3d9e32e52cff430782ff93d9bcb197d0'),('a50bec48eb4c4482b685a9633780217c','04c0b6cccc0246a087bf1022739654dc'),('a50bec48eb4c4482b685a9633780217c','3d9e32e52cff430782ff93d9bcb197d0'),('a96376d84ddf448bb314a0767b153f0e','04c0b6cccc0246a087bf1022739654dc'),('a96376d84ddf448bb314a0767b153f0e','3d9e32e52cff430782ff93d9bcb197d0'),('ac80da51bb1d46178da47dc923b92163','04c0b6cccc0246a087bf1022739654dc'),('ac80da51bb1d46178da47dc923b92163','3d9e32e52cff430782ff93d9bcb197d0'),('ad588f02ef6640aab8a79c12014e7cb9','04c0b6cccc0246a087bf1022739654dc'),('ad588f02ef6640aab8a79c12014e7cb9','3d9e32e52cff430782ff93d9bcb197d0'),('b2f9534a78bc4bc4a4d58db5c3d71597','04c0b6cccc0246a087bf1022739654dc'),('b2f9534a78bc4bc4a4d58db5c3d71597','3d9e32e52cff430782ff93d9bcb197d0'),('b628150152b14d3696523bfffde29c81','04c0b6cccc0246a087bf1022739654dc'),('b628150152b14d3696523bfffde29c81','3d9e32e52cff430782ff93d9bcb197d0'),('bac3914ac8164ab7863d05278a6ef599','04c0b6cccc0246a087bf1022739654dc'),('bac3914ac8164ab7863d05278a6ef599','3d9e32e52cff430782ff93d9bcb197d0'),('bc27dc0c8d0a4cbabc431c40d890d247','04c0b6cccc0246a087bf1022739654dc'),('bc27dc0c8d0a4cbabc431c40d890d247','3d9e32e52cff430782ff93d9bcb197d0'),('beaffd5056f948c78d7fe58bbc9c9458','04c0b6cccc0246a087bf1022739654dc'),('beaffd5056f948c78d7fe58bbc9c9458','3d9e32e52cff430782ff93d9bcb197d0'),('bee0fb5fbd534b689bb00b7240d7c1b8','04c0b6cccc0246a087bf1022739654dc'),('bee0fb5fbd534b689bb00b7240d7c1b8','3d9e32e52cff430782ff93d9bcb197d0'),('c85a442e22c6474aaeb16ebee63da90f','04c0b6cccc0246a087bf1022739654dc'),('c85a442e22c6474aaeb16ebee63da90f','3d9e32e52cff430782ff93d9bcb197d0'),('cc8ecaa6f508495f81235768635cfaa6','04c0b6cccc0246a087bf1022739654dc'),('cc8ecaa6f508495f81235768635cfaa6','3d9e32e52cff430782ff93d9bcb197d0'),('d2e21d0fab5d441b877910d42dd663d3','04c0b6cccc0246a087bf1022739654dc'),('d2e21d0fab5d441b877910d42dd663d3','3d9e32e52cff430782ff93d9bcb197d0'),('d3c1c22619d4499cb241cdb3151befa7','04c0b6cccc0246a087bf1022739654dc'),('d3c1c22619d4499cb241cdb3151befa7','3d9e32e52cff430782ff93d9bcb197d0'),('d5f4092d45014263bc4ab1addb65ae7c','04c0b6cccc0246a087bf1022739654dc'),('d5f4092d45014263bc4ab1addb65ae7c','3d9e32e52cff430782ff93d9bcb197d0'),('d7eafb9318f141d68c89f7507b9e2ac1','04c0b6cccc0246a087bf1022739654dc'),('d7eafb9318f141d68c89f7507b9e2ac1','3d9e32e52cff430782ff93d9bcb197d0'),('e3cd28eed4b14a2c8f11de3f1c730694','04c0b6cccc0246a087bf1022739654dc'),('e3cd28eed4b14a2c8f11de3f1c730694','3d9e32e52cff430782ff93d9bcb197d0'),('ee0090d99b9340d0986ac444cabda234','04c0b6cccc0246a087bf1022739654dc'),('ee0090d99b9340d0986ac444cabda234','3d9e32e52cff430782ff93d9bcb197d0'),('ee0090d99b9340d0986ac444cabda234','897d13fff8b74640bfbbedeac5a66ba3'),('ee73c99bd0ba43b19c3b8fea4f423057','04c0b6cccc0246a087bf1022739654dc'),('ee73c99bd0ba43b19c3b8fea4f423057','3d9e32e52cff430782ff93d9bcb197d0'),('f1f31744f4cd47b39e5784da715a3df2','04c0b6cccc0246a087bf1022739654dc'),('f1f31744f4cd47b39e5784da715a3df2','3d9e32e52cff430782ff93d9bcb197d0'),('f44ede1814ff482e865b917a1e7b3a86','04c0b6cccc0246a087bf1022739654dc'),('f44ede1814ff482e865b917a1e7b3a86','3d9e32e52cff430782ff93d9bcb197d0'),('f5c5ca530aad44a28c647314b5a8ba12','04c0b6cccc0246a087bf1022739654dc'),('f5c5ca530aad44a28c647314b5a8ba12','3d9e32e52cff430782ff93d9bcb197d0'),('ff023c0bc0064a10adc0d52c3244c4d0','04c0b6cccc0246a087bf1022739654dc'),('ff023c0bc0064a10adc0d52c3244c4d0','3d9e32e52cff430782ff93d9bcb197d0');
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('12531aea3d6649df87382a5e64a8a932','{\"tenantId\": \"eea821bb883d4acf8a28e2a417eb2567\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2025-12-16 15:43:16',NULL,'default'),('26b2b6895c2c44f1b2aff566e9d1811f','{}',1,'13a37d0163bf46c7adb9285bf1d8990f','2025-12-16 15:16:26','2025-12-16','default'),('35b73a3389ef48dfa9ada047442b987b','{}',1,'13a37d0163bf46c7adb9285bf1d8990f','2025-12-16 15:16:56','2025-12-16','default'),('7d01aa0505f14b82898c65d8bac8a487','{}',1,'13a37d0163bf46c7adb9285bf1d8990f','2025-12-16 15:16:41','2025-12-16','default'),('7d3deaf17fc24841a9aaec68e8c0e2f5','{}',1,NULL,'2025-12-16 15:16:22','2025-12-16','64b01a74480240668bed479759066e9d'),('82ff9b7390d945a5a88d6fe48c6f42b4','{}',1,NULL,'2025-12-16 15:15:12','2025-12-16','default'),('84a607660d884a7baef3327f48342c40','{}',1,'13a37d0163bf46c7adb9285bf1d8990f','2025-12-16 15:16:35',NULL,'default'),('8eb47f68ce0240d7a56bbbb41d267986','{}',1,'13a37d0163bf46c7adb9285bf1d8990f','2025-12-16 15:17:15','2025-12-16','default'),('960094c791ae466295e45611ab960fc7','{}',1,'13a37d0163bf46c7adb9285bf1d8990f','2025-12-16 15:16:29','2025-12-16','default'),('9c05bd9bf2d14e859427cc2c46a6c2b2','{}',1,'13a37d0163bf46c7adb9285bf1d8990f','2025-12-16 15:16:47','2025-12-16','default'),('c9794a7c6d7e4bf09d6ed563bb6536e1','{}',1,'13a37d0163bf46c7adb9285bf1d8990f','2025-12-16 15:16:20','2025-12-16','default'),('df27e3a707344a4da8ba9cce3cdb0a92','{}',1,'13a37d0163bf46c7adb9285bf1d8990f','2025-12-16 15:16:52','2025-12-16','default'),('ecae539dbc2149c18cc30a7bfe376ce5','{\"tenantId\": \"a1d76f472c5c41faa4158134dd714a29\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2025-12-16 15:43:16','2025-12-16','default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `mysql`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `mysql` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;

USE `mysql`;

--
-- Table structure for table `general_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `general_log` (
  `event_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `command_type` varchar(64) NOT NULL,
  `argument` mediumtext NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='General log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slow_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `slow_log` (
  `start_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `query_time` time(6) NOT NULL,
  `lock_time` time(6) NOT NULL,
  `rows_sent` bigint(20) unsigned NOT NULL,
  `rows_examined` bigint(20) unsigned NOT NULL,
  `db` varchar(512) NOT NULL,
  `last_insert_id` int(11) NOT NULL,
  `insert_id` int(11) NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `sql_text` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `rows_affected` bigint(20) unsigned NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Slow log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `column_stats`
--

DROP TABLE IF EXISTS `column_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `column_stats` (
  `db_name` varchar(64) NOT NULL,
  `table_name` varchar(64) NOT NULL,
  `column_name` varchar(64) NOT NULL,
  `min_value` varbinary(255) DEFAULT NULL,
  `max_value` varbinary(255) DEFAULT NULL,
  `nulls_ratio` decimal(12,4) DEFAULT NULL,
  `avg_length` decimal(12,4) DEFAULT NULL,
  `avg_frequency` decimal(12,4) DEFAULT NULL,
  `hist_size` tinyint(3) unsigned DEFAULT NULL,
  `hist_type` enum('SINGLE_PREC_HB','DOUBLE_PREC_HB') DEFAULT NULL,
  `histogram` varbinary(255) DEFAULT NULL,
  PRIMARY KEY (`db_name`,`table_name`,`column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='Statistics on Columns';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `column_stats`
--

LOCK TABLES `column_stats` WRITE;
/*!40000 ALTER TABLE `column_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `column_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `columns_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Table_name` char(64) NOT NULL DEFAULT '',
  `Column_name` char(64) NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `db` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_history_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT INTO `db` (`Host`, `Db`, `User`, `Select_priv`, `Insert_priv`, `Update_priv`, `Delete_priv`, `Create_priv`, `Drop_priv`, `Grant_priv`, `References_priv`, `Index_priv`, `Alter_priv`, `Create_tmp_table_priv`, `Lock_tables_priv`, `Create_view_priv`, `Show_view_priv`, `Create_routine_priv`, `Alter_routine_priv`, `Execute_priv`, `Event_priv`, `Trigger_priv`, `Delete_history_priv`) VALUES ('localhost','keystone','keystone_6a2c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','keystone','keystone_6a2c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','placement','placement_4fce','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','placement','placement_4fce','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','glance','glance_5251','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','glance','glance_5251','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','heat','heat_4908','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','barbican','barbican_bb88','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','cinder','cinder_aacd','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','heat','heat_4908','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','barbican','barbican_bb88','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','cinder','cinder_aacd','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','neutron','neutron_7302','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','neutron','neutron_7302','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_cell0','nova_cell0_52a3','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_cell0','nova_cell0_52a3','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_api','nova_api_9435','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_api','nova_api_9435','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` char(141) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','IGNORE_BAD_TABLE_OPTIONS','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH','EMPTY_STRING_IS_NULL','SIMULTANEOUS_ASSIGNMENT','TIME_ROUND_FRACTIONAL') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob DEFAULT NULL,
  PRIMARY KEY (`db`,`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `func` (
  `name` char(64) NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT 0,
  `dl` char(128) NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `global_priv`
--

DROP TABLE IF EXISTS `global_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Priv` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '{}' CHECK (json_valid(`Priv`)),
  PRIMARY KEY (`Host`,`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_priv`
--

LOCK TABLES `global_priv` WRITE;
/*!40000 ALTER TABLE `global_priv` DISABLE KEYS */;
INSERT INTO `global_priv` (`Host`, `User`, `Priv`) VALUES ('localhost','mariadb.sys','{\"access\":0,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"\",\"account_locked\":true,\"password_last_changed\":0}'),('localhost','root','{\"access\": 549755813887, \"plugin\": \"mysql_native_password\", \"authentication_string\": \"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\", \"auth_or\": [{}],\"version_id\":100529,\"password_last_changed\":1765898038}'),('%','root','{\"access\":549755813887,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\",\"password_last_changed\":1765898038}'),('localhost','keystone_6a2c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*BADA1578342C04F0EF2FBBB9A1E63FF0FC4F3E89\",\"password_last_changed\":1765898066}'),('%','keystone_6a2c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*BADA1578342C04F0EF2FBBB9A1E63FF0FC4F3E89\",\"password_last_changed\":1765898066}'),('localhost','placement_4fce','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*A6F6F4E2AAA5773E3B3A390FFE9BCD1965D05E1F\",\"password_last_changed\":1765898066}'),('%','placement_4fce','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*A6F6F4E2AAA5773E3B3A390FFE9BCD1965D05E1F\",\"password_last_changed\":1765898066}'),('localhost','glance_5251','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*FB00A407F0E89AA67AFEED193C3CFE200B7A6CA9\",\"password_last_changed\":1765898067}'),('%','glance_5251','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*FB00A407F0E89AA67AFEED193C3CFE200B7A6CA9\",\"password_last_changed\":1765898067}'),('localhost','heat_4908','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*C7B7B765B004696205AA1ECFCEBAD22285B79DA2\",\"password_last_changed\":1765898089}'),('localhost','barbican_bb88','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*D48A7F3B8A98BF8DEA8621F0D58B12B780188F55\",\"password_last_changed\":1765898089}'),('localhost','cinder_aacd','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*9908D70E19FF8266E0868016AB8C21C83EABB28D\",\"password_last_changed\":1765898089}'),('%','heat_4908','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*C7B7B765B004696205AA1ECFCEBAD22285B79DA2\",\"password_last_changed\":1765898089}'),('%','barbican_bb88','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*D48A7F3B8A98BF8DEA8621F0D58B12B780188F55\",\"password_last_changed\":1765898089}'),('%','cinder_aacd','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*9908D70E19FF8266E0868016AB8C21C83EABB28D\",\"password_last_changed\":1765898089}'),('localhost','neutron_7302','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*614FC38D0189BD95407B9CA9F63F4B0EC169E643\",\"password_last_changed\":1765898089}'),('%','neutron_7302','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*614FC38D0189BD95407B9CA9F63F4B0EC169E643\",\"password_last_changed\":1765898089}'),('localhost','nova_cell0_52a3','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*A2607168DA3A9207E5A7534437520AF6DCD8AC88\",\"password_last_changed\":1765898197}'),('%','nova_cell0_52a3','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*A2607168DA3A9207E5A7534437520AF6DCD8AC88\",\"password_last_changed\":1765898197}'),('localhost','nova_api_9435','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*FA768637D0AB3EB906D20E3029DE6B949B698491\",\"password_last_changed\":1765898197}'),('%','nova_api_9435','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*FA768637D0AB3EB906D20E3029DE6B949B698491\",\"password_last_changed\":1765898197}');
/*!40000 ALTER TABLE `global_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gtid_slave_pos`
--

DROP TABLE IF EXISTS `gtid_slave_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gtid_slave_pos` (
  `domain_id` int(10) unsigned NOT NULL,
  `sub_id` bigint(20) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `seq_no` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`domain_id`,`sub_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Replication slave GTID position';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gtid_slave_pos`
--

LOCK TABLES `gtid_slave_pos` WRITE;
/*!40000 ALTER TABLE `gtid_slave_pos` DISABLE KEYS */;
/*!40000 ALTER TABLE `gtid_slave_pos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT INTO `help_category` (`help_category_id`, `name`, `parent_category_id`, `url`) VALUES (1,'Contents',0,''),(2,'Polygon Properties',34,''),(3,'WKT',34,''),(4,'Numeric Functions',37,''),(5,'Plugins',1,''),(6,'MBR',34,''),(7,'Control Flow Functions',37,''),(8,'Transactions',1,''),(9,'Help Metadata',1,''),(10,'Account Management',1,''),(11,'Point Properties',34,''),(12,'Encryption Functions',37,''),(13,'LineString Properties',34,''),(14,'Miscellaneous Functions',37,''),(15,'Logical Operators',47,''),(16,'Functions and Modifiers for Use with GROUP BY',1,''),(17,'Information Functions',37,''),(18,'Assignment Operators',47,''),(19,'Comparison Operators',47,''),(20,'Bit Functions',37,''),(21,'Table Maintenance',1,''),(22,'User-Defined Functions',1,''),(23,'Data Types',1,''),(24,'Compound Statements',1,''),(25,'Geometry Constructors',34,''),(26,'Administration',1,''),(27,'Data Manipulation',1,''),(28,'Utility',1,''),(29,'Language Structure',1,''),(30,'Geometry Relations',34,''),(31,'Date and Time Functions',37,''),(32,'WKB',34,''),(33,'Procedures',1,''),(34,'Geographic Features',1,''),(35,'Geometry Properties',34,''),(36,'String Functions',37,''),(37,'Functions',1,''),(38,'Data Definition',1,''),(39,'Sequences',1,''),(40,'JSON Functions',37,''),(41,'Window Functions',37,''),(42,'Spider Functions',37,''),(43,'Dynamic Column Functions',37,''),(44,'Galera Functions',37,''),(45,'Temporal Tables',1,''),(46,'GeoJSON',34,''),(47,'Operators',1,''),(48,'Arithmetic Operators',47,''),(49,'Replication',1,''),(50,'Prepared Statements',1,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT INTO `help_keyword` (`help_keyword_id`, `name`) VALUES (1,'work'),(2,'locks'),(3,'locking'),(4,'drop'),(5,'super'),(6,'usage'),(7,'binlog admin'),(8,'binlog monitor'),(9,'binlog replay'),(10,'connection admin'),(11,'federated admin'),(12,'grant option'),(13,'read_only admin'),(14,'replica monitor'),(15,'replication replica'),(16,'roles'),(17,'values'),(18,'value'),(19,'not'),(20,'and'),(21,'or'),(22,':='),(23,'assignment operator'),(24,'='),(25,'!='),(26,'<>'),(27,'not equal'),(28,'less than'),(29,'less than or equal'),(30,'NULL-safe equal'),(31,'equal'),(32,'greater than'),(33,'greater than or equal'),(34,'bitwise and'),(35,'shift left'),(36,'shift right'),(37,'bitwise xor'),(38,'bitwise or'),(39,'bitwise not'),(40,'returns'),(41,'udfs'),(42,'udf calling sequences'),(43,'udf security'),(44,'int1'),(45,'int2'),(46,'int3'),(47,'integer'),(48,'int4'),(49,'int8'),(50,'dec'),(51,'numeric'),(52,'fixed'),(53,'number'),(54,'real'),(55,'double precision'),(56,'nchar'),(57,'long'),(58,'long varchar'),(59,'repeat'),(60,'declare'),(61,'cursor'),(62,'show'),(63,'columns'),(64,'kill connection'),(65,'kill query'),(66,'delete returning'),(67,'sql_big_result'),(68,'minus'),(69,'cte'),(70,'insert returning'),(71,'queries'),(72,'query'),(73,'explain format'),(74,'explain format json'),(75,'rlike'),(76,'character_length'),(77,'escape'),(78,'mode'),(79,'trim_oracle'),(80,'schedule'),(81,'row_format'),(82,'starts'),(83,'host'),(84,'generated columns'),(85,'virtual columns'),(86,'computed columns'),(87,'hidden columns'),(88,'nextval'),(89,'lastval'),(90,'+'),(91,'addition operator'),(92,'/'),(93,'division operator'),(94,'%'),(95,'modulo operator'),(96,'*'),(97,'multiplication operator'),(98,'-'),(99,'subtraction operator'),(100,'master_ssl_verify_cert'),(101,'start replica'),(102,'stop replica'),(103,'reset slave'),(104,'reset replica'),(105,'drop prepare'),(106,'deallocate prepare');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`),
  KEY `help_topic_id` (`help_topic_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT INTO `help_relation` (`help_topic_id`, `help_keyword_id`) VALUES (94,1),(97,2),(99,2),(101,2),(116,2),(147,2),(152,2),(157,2),(161,2),(162,2),(338,2),(438,2),(97,3),(99,3),(101,3),(116,3),(147,3),(152,3),(157,3),(161,3),(162,3),(338,3),(438,3),(106,4),(112,4),(250,4),(687,4),(697,4),(713,4),(714,4),(715,4),(716,4),(717,4),(718,4),(719,4),(720,4),(722,4),(723,4),(731,4),(107,5),(107,6),(107,7),(107,8),(107,9),(107,10),(107,11),(107,12),(107,13),(107,14),(107,15),(115,16),(166,17),(166,18),(167,19),(168,20),(170,21),(210,22),(210,23),(211,23),(211,24),(212,25),(212,26),(212,27),(213,28),(214,29),(215,30),(216,31),(217,32),(218,33),(232,34),(233,35),(234,36),(236,37),(237,38),(238,39),(249,40),(251,41),(252,42),(253,43),(255,44),(257,45),(258,46),(259,47),(259,48),(260,49),(261,50),(261,51),(261,52),(261,53),(263,54),(263,55),(269,56),(275,57),(275,58),(304,59),(664,59),(311,60),(311,61),(331,62),(332,62),(333,62),(334,62),(335,62),(342,62),(343,62),(344,62),(345,62),(346,62),(347,62),(354,62),(356,62),(357,62),(358,62),(359,62),(360,62),(361,62),(362,62),(363,62),(364,62),(365,62),(366,62),(367,62),(368,62),(369,62),(370,62),(371,62),(372,62),(373,62),(374,62),(375,62),(376,62),(377,62),(378,62),(379,62),(380,62),(381,62),(382,62),(383,62),(384,62),(385,62),(386,62),(387,62),(388,62),(389,62),(390,62),(391,62),(392,62),(393,62),(394,62),(395,62),(396,62),(397,62),(398,62),(408,62),(409,62),(333,63),(403,64),(403,65),(410,66),(414,67),(425,68),(431,69),(432,69),(433,69),(453,70),(460,71),(460,72),(466,73),(466,74),(622,75),(632,76),(651,77),(657,78),(678,79),(689,80),(696,81),(701,82),(707,83),(711,84),(711,85),(711,86),(712,87),(732,88),(733,89),(804,90),(804,91),(805,92),(805,93),(806,94),(806,95),(807,96),(807,97),(808,98),(808,99),(809,100),(810,101),(811,102),(812,103),(812,104),(816,105),(816,106);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
INSERT INTO `help_topic` (`help_topic_id`, `name`, `help_category_id`, `description`, `example`, `url`) VALUES (1,'HELP_DATE',9,'Help Contents generated from the MariaDB Knowledge Base on 23 January 2023.','',''),(2,'HELP_VERSION',9,'Help Contents generated for MariaDB 10.5 from the MariaDB Knowledge Base on 23 January 2023.','',''),(3,'AREA',2,'A synonym for ST_AREA.\n\nURL: https://mariadb.com/kb/en/polygon-properties-area/','','https://mariadb.com/kb/en/polygon-properties-area/'),(4,'CENTROID',2,'A synonym for ST_CENTROID.\n\nURL: https://mariadb.com/kb/en/centroid/','','https://mariadb.com/kb/en/centroid/'),(5,'ExteriorRing',2,'A synonym for ST_ExteriorRing.\n\nURL: https://mariadb.com/kb/en/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/polygon-properties-exteriorring/'),(6,'InteriorRingN',2,'A synonym for ST_InteriorRingN.\n\nURL: https://mariadb.com/kb/en/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/polygon-properties-interiorringn/'),(7,'NumInteriorRings',2,'A synonym for ST_NumInteriorRings.\n\nURL: https://mariadb.com/kb/en/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/polygon-properties-numinteriorrings/'),(8,'ST_AREA',2,'Syntax\n------\n\nST_Area(poly)\nArea(poly)\n\nDescription\n-----------\n\nReturns as a double-precision number the area of the Polygon value poly, as\nmeasured in its spatial reference system.\n\nST_Area() and Area() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\n\nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/st_area/','','https://mariadb.com/kb/en/st_area/'),(9,'ST_CENTROID',2,'Syntax\n------\n\nST_Centroid(mpoly)\nCentroid(mpoly)\n\nDescription\n-----------\n\nReturns a point reflecting the mathematical centroid (geometric center) for\nthe MultiPolygon mpoly. The resulting point will not necessarily be on the\nMultiPolygon.\n\nST_Centroid() and Centroid() are synonyms.\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0 0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n+--------------+\n| center       |\n+--------------+\n| POINT(10 10) |\n+--------------+\n\nURL: https://mariadb.com/kb/en/st_centroid/','','https://mariadb.com/kb/en/st_centroid/'),(10,'ST_ExteriorRing',2,'Syntax\n------\n\nST_ExteriorRing(poly)\nExteriorRing(poly)\n\nDescription\n-----------\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() and ExteriorRing() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_exteriorring/','','https://mariadb.com/kb/en/st_exteriorring/'),(11,'ST_InteriorRingN',2,'Syntax\n------\n\nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n\nDescription\n-----------\n\nReturns the N-th interior ring for the Polygon value poly as a LineString.\nRings are numbered beginning with 1.\n\nST_InteriorRingN() and InteriorRingN() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_interiorringn/','','https://mariadb.com/kb/en/st_interiorringn/'),(12,'ST_NumInteriorRings',2,'Syntax\n------\n\nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n\nDescription\n-----------\n\nReturns an integer containing the number of interior rings in the Polygon\nvalue poly.\n\nNote that according the the OpenGIS standard, a POLYGON should have exactly\none ExteriorRing and all other rings should lie within that ExteriorRing and\nthus be the InteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several \'ExteriorRings\'. In the case of\nthere being multiple, non-overlapping exterior rings ST_NumInteriorRings()\nwill return 1.\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/st_numinteriorrings/','','https://mariadb.com/kb/en/st_numinteriorrings/'),(14,'AsText',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-astext/','','https://mariadb.com/kb/en/wkt-astext/'),(15,'AsWKT',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-aswkt/','','https://mariadb.com/kb/en/wkt-aswkt/'),(16,'GeomCollFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/wkt-geomcollfromtext/'),(17,'GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromtext/','','https://mariadb.com/kb/en/geometrycollectionfromtext/'),(18,'GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/geometryfromtext/','','https://mariadb.com/kb/en/geometryfromtext/'),(19,'GeomFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomfromtext/','','https://mariadb.com/kb/en/wkt-geomfromtext/'),(20,'LineFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/wkt-linefromtext/','','https://mariadb.com/kb/en/wkt-linefromtext/'),(21,'LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/linestringfromtext/','','https://mariadb.com/kb/en/linestringfromtext/'),(22,'MLineFromText',3,'Syntax\n------\n\nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n\nMLineFromText() and MultiLineStringFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\nINSERT INTO gis_multi_line VALUES\n  (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16\n23,16 48))\')),\n  (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n  (MLineFromWKB(AsWKB(MultiLineString(\n   LineString(Point(1, 2), Point(3, 5)),\n   LineString(Point(2, 5), Point(5, 8), Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/mlinefromtext/','','https://mariadb.com/kb/en/mlinefromtext/'),(23,'MPointFromText',3,'Syntax\n------\n\nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nMPointFromText() and MultiPointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/mpointfromtext/','','https://mariadb.com/kb/en/mpointfromtext/'),(13,'WKT Definition',3,'Description\n-----------\n\nThe Well-Known Text (WKT) representation of Geometry is designed to exchange\ngeometry data in ASCII form. Examples of the basic geometry types include:\n\n+-----------------------------------------------------------------------------+\n| Geometry Types                                                              |\n+-----------------------------------------------------------------------------+\n| POINT                                                                       |\n+-----------------------------------------------------------------------------+\n| LINESTRING                                                                  |\n+-----------------------------------------------------------------------------+\n| POLYGON                                                                     |\n+-----------------------------------------------------------------------------+\n| MULTIPOINT                                                                  |\n+-----------------------------------------------------------------------------+\n| MULTILINESTRING                                                             |\n+-----------------------------------------------------------------------------+\n| MULTIPOLYGON                                                                |\n+-----------------------------------------------------------------------------+\n| GEOMETRYCOLLECTION                                                          |\n+-----------------------------------------------------------------------------+\n| GEOMETRY                                                                    |\n+-----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/wkt-definition/','','https://mariadb.com/kb/en/wkt-definition/'),(24,'MPolyFromText',3,'Syntax\n------\n\nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nMPolyFromText() and MultiPolygonFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(\n   LineString(Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/mpolyfromtext/','','https://mariadb.com/kb/en/mpolyfromtext/'),(25,'MultiLineStringFromText',3,'A synonym for MLineFromText.\n\nURL: https://mariadb.com/kb/en/multilinestringfromtext/','','https://mariadb.com/kb/en/multilinestringfromtext/'),(26,'MultiPointFromText',3,'A synonym for MPointFromText.\n\nURL: https://mariadb.com/kb/en/multipointfromtext/','','https://mariadb.com/kb/en/multipointfromtext/'),(27,'MultiPolygonFromText',3,'A synonym for MPolyFromText.\n\nURL: https://mariadb.com/kb/en/multipolygonfromtext/','','https://mariadb.com/kb/en/multipolygonfromtext/'),(28,'PointFromText',3,'A synonym for ST_PointFromText.\n\nURL: https://mariadb.com/kb/en/wkt-pointfromtext/','','https://mariadb.com/kb/en/wkt-pointfromtext/'),(29,'PolyFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/wkt-polyfromtext/','','https://mariadb.com/kb/en/wkt-polyfromtext/'),(30,'PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/polygonfromtext/','','https://mariadb.com/kb/en/polygonfromtext/'),(31,'ST_AsText',3,'Syntax\n------\n\nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKT representation and\nreturns the string result.\n\nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all synonyms.\n\nExamples\n--------\n\nSET @g = \'LineString(1 1,4 4,6 6)\';\n\nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6)        |\n+--------------------------------+\n\nURL: https://mariadb.com/kb/en/st_astext/','','https://mariadb.com/kb/en/st_astext/'),(32,'ST_ASWKT',3,'A synonym for ST_ASTEXT().\n\nURL: https://mariadb.com/kb/en/st_aswkt/','','https://mariadb.com/kb/en/st_aswkt/'),(33,'ST_GeomCollFromText',3,'Syntax\n------\n\nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(), GeomCollFromText() and\nGeometryCollectionFromText() are all synonyms.\n\nExample\n-------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/st_geomcollfromtext/','','https://mariadb.com/kb/en/st_geomcollfromtext/'),(34,'ST_GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/st_geometrycollectionfromtext/'),(35,'ST_GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/st_geometryfromtext/','','https://mariadb.com/kb/en/st_geometryfromtext/'),(36,'ST_GeomFromText',3,'Syntax\n------\n\nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKT representation and SRID.\n\nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n\nExample\n-------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nURL: https://mariadb.com/kb/en/st_geomfromtext/','','https://mariadb.com/kb/en/st_geomfromtext/'),(37,'ST_LineFromText',3,'Syntax\n------\n\nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nST_LineFromText(), ST_LineStringFromText(), ST_LineFromText() and\nST_LineStringFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_line  (g LINESTRING);\nSHOW FIELDS FROM gis_line;\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/st_linefromtext/','','https://mariadb.com/kb/en/st_linefromtext/'),(38,'ST_LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/st_linestringfromtext/','','https://mariadb.com/kb/en/st_linestringfromtext/'),(39,'ST_PointFromText',3,'Syntax\n------\n\nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKT representation and SRID.\n\nST_PointFromText() and PointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_point  (g POINT);\nSHOW FIELDS FROM gis_point;\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/st_pointfromtext/','','https://mariadb.com/kb/en/st_pointfromtext/'),(40,'ST_PolyFromText',3,'Syntax\n------\n\nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\'));\n\nURL: https://mariadb.com/kb/en/st_polyfromtext/','','https://mariadb.com/kb/en/st_polyfromtext/'),(41,'ST_PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/st_polygonfromtext/','','https://mariadb.com/kb/en/st_polygonfromtext/'),(42,'DIV',4,'Syntax\n------\n\nDIV\n\nDescription\n-----------\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for non-integer operands that exceed BIGINT range.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a division by zero produces\nan error. Otherwise, it returns NULL.\n\nThe remainder of a division can be obtained using the MOD operator.\n\nExamples\n--------\n\nSELECT 300 DIV 7;\n+-----------+\n| 300 DIV 7 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT 300 DIV 0;\n+-----------+\n| 300 DIV 0 |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/div/','','https://mariadb.com/kb/en/div/'),(43,'ABS',4,'Syntax\n------\n\nABS(X)\n\nDescription\n-----------\n\nReturns the absolute (non-negative) value of X. If X is not a number, it is\nconverted to a numeric type.\n\nExamples\n--------\n\nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n|      42 |\n+---------+\n\nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n|       42 |\n+----------+\n\nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n|               19940101 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/abs/','','https://mariadb.com/kb/en/abs/'),(44,'ACOS',4,'Syntax\n------\n\nACOS(X)\n\nDescription\n-----------\n\nReturns the arc cosine of X, that is, the value whose cosine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n|         NULL |\n+--------------+\n\nSELECT ACOS(0);\n+-----------------+\n| ACOS(0)         |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234)      |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/acos/','','https://mariadb.com/kb/en/acos/'),(45,'ASIN',4,'Syntax\n------\n\nASIN(X)\n\nDescription\n-----------\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns NULL if\nX is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2)          |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n\nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n\nSHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n\nURL: https://mariadb.com/kb/en/asin/','','https://mariadb.com/kb/en/asin/'),(46,'ATAN',4,'Syntax\n------\n\nATAN(X)\n\nDescription\n-----------\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nExamples\n--------\n\nSELECT ATAN(2);\n+--------------------+\n| ATAN(2)            |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n\nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2)            |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/atan/','','https://mariadb.com/kb/en/atan/'),(47,'ATAN2',4,'Syntax\n------\n\nATAN(Y,X), ATAN2(Y,X)\n\nDescription\n-----------\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both arguments\nare used to determine the quadrant of the result.\n\nExamples\n--------\n\nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2)          |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n\nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0)      |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/atan2/','','https://mariadb.com/kb/en/atan2/'),(48,'CEIL',4,'Syntax\n------\n\nCEIL(X)\n\nDescription\n-----------\n\nCEIL() is a synonym for CEILING().\n\nURL: https://mariadb.com/kb/en/ceil/','','https://mariadb.com/kb/en/ceil/'),(49,'CEILING',4,'Syntax\n------\n\nCEILING(X)\n\nDescription\n-----------\n\nReturns the smallest integer value not less than X.\n\nExamples\n--------\n\nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n|             -1 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/ceiling/','','https://mariadb.com/kb/en/ceiling/'),(51,'COS',4,'Syntax\n------\n\nCOS(X)\n\nDescription\n-----------\n\nReturns the cosine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n|        -1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/cos/','','https://mariadb.com/kb/en/cos/'),(52,'COT',4,'Syntax\n------\n\nCOT(X)\n\nDescription\n-----------\n\nReturns the cotangent of X.\n\nExamples\n--------\n\nSELECT COT(42);\n+--------------------+\n| COT(42)            |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n\nSELECT COT(12);\n+---------------------+\n| COT(12)             |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n\nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in \'cot(0)\'\n\nURL: https://mariadb.com/kb/en/cot/','','https://mariadb.com/kb/en/cot/'),(54,'DEGREES',4,'Syntax\n------\n\nDEGREES(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from radians to degrees.\n\nThis is the converse of the RADIANS() function.\n\nExamples\n--------\n\nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n|           180 |\n+---------------+\n\nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n|                90 |\n+-------------------+\n\nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45)     |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/degrees/','','https://mariadb.com/kb/en/degrees/'),(55,'EXP',4,'Syntax\n------\n\nEXP(X)\n\nDescription\n-----------\n\nReturns the value of e (the base of natural logarithms) raised to the power of\nX. The inverse of this function is LOG() (using a single argument only) or\nLN().\n\nIf X is NULL, this function returns NULL.\n\nExamples\n--------\n\nSELECT EXP(2);\n+------------------+\n| EXP(2)           |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n\nSELECT EXP(-2);\n+--------------------+\n| EXP(-2)            |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n\nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n|      1 |\n+--------+\n\nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/exp/','','https://mariadb.com/kb/en/exp/'),(50,'CONV',4,'Syntax\n------\n\nCONV(N,from_base,to_base)\n\nDescription\n-----------\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base to_base.\n\nReturns NULL if any argument is NULL, or if the second or third argument are\nnot in the allowed range.\n\nThe argument N is interpreted as an integer, but may be specified as an\ninteger or a string. The minimum base is 2 and the maximum base is 36. If\nto_base is a negative number, N is regarded as a signed number. Otherwise, N\nis treated as unsigned. CONV() works with 64-bit precision.\n\nSome shortcuts for this function are also available: BIN(), OCT(), HEX(),\nUNHEX(). Also, MariaDB allows binary literal values and hexadecimal literal\nvalues.\n\nExamples\n--------\n\nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010           |\n+----------------+\n\nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172             |\n+-----------------+\n\nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H               |\n+------------------+\n\nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42                           |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/conv/','','https://mariadb.com/kb/en/conv/'),(53,'CRC32',4,'Syntax\n------\n\n<= MariaDB 10.7\n\nCRC32(expr)\n\nFrom MariaDB 10.8\n\nCRC32([par,]expr)\n\nDescription\n-----------\n\nComputes a cyclic redundancy check (CRC) value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is expected to\nbe a string and (if possible) is treated as one if it is not.\n\nUses the ISO 3309 polynomial that used by zlib and many others. MariaDB 10.8\nintroduced the CRC32C() function, which uses the alternate Castagnoli\npolynomia.\n\nMariaDB starting with 10.8\n--------------------------\nOften, CRC is computed in pieces. To facilitate this, MariaDB 10.8.0\nintroduced an optional parameter: CRC32(\'MariaDB\')=CRC32(CRC32(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n|       4227209140 |\n+------------------+\n\nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n|       2594253378 |\n+------------------+\n\nFrom MariaDB 10.8.0\n\nSELECT CRC32(CRC32(\'Maria\'),\'DB\');\n+----------------------------+\n| CRC32(CRC32(\'Maria\'),\'DB\') |\n+----------------------------+\n|                 4227209140 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/crc32/','','https://mariadb.com/kb/en/crc32/'),(56,'FLOOR',4,'Syntax\n------\n\nFLOOR(X)\n\nDescription\n-----------\n\nReturns the largest integer value not greater than X.\n\nExamples\n--------\n\nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n|           -2 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/floor/','','https://mariadb.com/kb/en/floor/'),(57,'LN',4,'Syntax\n------\n\nLN(X)\n\nDescription\n-----------\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X. If X\nis less than or equal to 0, or NULL, then NULL is returned.\n\nThe inverse of this function is EXP().\n\nExamples\n--------\n\nSELECT LN(2);\n+-------------------+\n| LN(2)             |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n|   NULL |\n+--------+\n\nURL: https://mariadb.com/kb/en/ln/','','https://mariadb.com/kb/en/ln/'),(58,'LOG',4,'Syntax\n------\n\nLOG(X), LOG(B,X)\n\nDescription\n-----------\n\nIf called with one parameter, this function returns the natural logarithm of\nX. If X is less than or equal to 0, then NULL is returned.\n\nIf called with two parameters, it returns the logarithm of X to the base B. If\nB is <= 1 or X <= 0, the function returns NULL.\n\nIf any argument is NULL, the function returns NULL.\n\nThe inverse of this function (when called with a single argument) is the EXP()\nfunction.\n\nExamples\n--------\n\nLOG(X):\n\nSELECT LOG(2);\n+-------------------+\n| LOG(2)            |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LOG(-2);\n+---------+\n| LOG(-2) |\n+---------+\n|    NULL |\n+---------+\n\nLOG(B,X)\n\nSELECT LOG(2,16);\n+-----------+\n| LOG(2,16) |\n+-----------+\n|         4 |\n+-----------+\n\nSELECT LOG(3,27);\n+-----------+\n| LOG(3,27) |\n+-----------+\n|         3 |\n+-----------+\n\nSELECT LOG(3,1);\n+----------+\n| LOG(3,1) |\n+----------+\n|        0 |\n+----------+\n\nSELECT LOG(3,0);\n+----------+\n| LOG(3,0) |\n+----------+\n|     NULL |\n+----------+\n\nURL: https://mariadb.com/kb/en/log/','','https://mariadb.com/kb/en/log/'),(59,'LOG10',4,'Syntax\n------\n\nLOG10(X)\n\nDescription\n-----------\n\nReturns the base-10 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG10(2);\n+-------------------+\n| LOG10(2)          |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n\nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n|          2 |\n+------------+\n\nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/log10/','','https://mariadb.com/kb/en/log10/'),(60,'LOG2',4,'Syntax\n------\n\nLOG2(X)\n\nDescription\n-----------\n\nReturns the base-2 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n|                  42 |\n+---------------------+\n\nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n|          16 |\n+-------------+\n\nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n|       NULL |\n+------------+\n\nURL: https://mariadb.com/kb/en/log2/','','https://mariadb.com/kb/en/log2/'),(62,'OCT',4,'Syntax\n------\n\nOCT(N)\n\nDescription\n-----------\n\nReturns a string representation of the octal value of N, where N is a longlong\n(BIGINT) number. This is equivalent to CONV(N,10,8). Returns NULL if N is NULL.\n\nExamples\n--------\n\nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42      |\n+---------+\n\nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14      |\n+---------+\n\nURL: https://mariadb.com/kb/en/oct/','','https://mariadb.com/kb/en/oct/'),(63,'PI',4,'Syntax\n------\n\nPI()\n\nDescription\n-----------\n\nReturns the value of π (pi). The default number of decimal places displayed is\nsix, but MariaDB uses the full double-precision value internally.\n\nExamples\n--------\n\nSELECT PI();\n+----------+\n| PI()     |\n+----------+\n| 3.141593 |\n+----------+\n\nSELECT PI()+0.0000000000000000000000;\n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n|      3.1415926535897931159980 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/pi/','','https://mariadb.com/kb/en/pi/'),(64,'POW',4,'Syntax\n------\n\nPOW(X,Y)\n\nDescription\n-----------\n\nReturns the value of X raised to the power of Y.\n\nPOWER() is a synonym.\n\nExamples\n--------\n\nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n|        8 |\n+----------+\n\nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n|      0.25 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/pow/','','https://mariadb.com/kb/en/pow/'),(65,'POWER',4,'Syntax\n------\n\nPOWER(X,Y)\n\nDescription\n-----------\n\nThis is a synonym for POW(), which returns the value of X raised to the power\nof Y.\n\nURL: https://mariadb.com/kb/en/power/','','https://mariadb.com/kb/en/power/'),(61,'MOD',4,'Syntax\n------\n\nMOD(N,M), N % M, N MOD M\n\nDescription\n-----------\n\nModulo operation. Returns the remainder of N divided by M. See also Modulo\nOperator.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any number modulus zero\nproduces an error. Otherwise, it returns NULL.\n\nThe integer part of a division can be obtained using DIV.\n\nExamples\n--------\n\nSELECT 1042 % 50;\n+-----------+\n| 1042 % 50 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n|            4 |\n+--------------+\n\nSELECT 253 % 7;\n+---------+\n| 253 % 7 |\n+---------+\n|       1 |\n+---------+\n\nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n|         2 |\n+-----------+\n\nSELECT 29 MOD 9;\n+----------+\n| 29 MOD 9 |\n+----------+\n|        2 |\n+----------+\n\nURL: https://mariadb.com/kb/en/mod/','','https://mariadb.com/kb/en/mod/'),(66,'RADIANS',4,'Syntax\n------\n\nRADIANS(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from degrees to radians. Note that π radians\nequals 180 degrees.\n\nThis is the converse of the DEGREES() function.\n\nExamples\n--------\n\nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45)       |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n\nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90)     |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI())      |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n\nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180)     |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/radians/','','https://mariadb.com/kb/en/radians/'),(67,'RAND',4,'Syntax\n------\n\nRAND(), RAND(N)\n\nDescription\n-----------\n\nReturns a random DOUBLE precision floating point value v in the range 0 <= v <\n1.0. If a constant integer argument N is specified, it is used as the seed\nvalue, which produces a repeatable sequence of column values. In the example\nbelow, note that the sequences of values produced by RAND(3) is the same both\nplaces where it occurs.\n\nIn a WHERE clause, RAND() is evaluated each time the WHERE is executed.\n\nStatements using the RAND() function are not safe for statement-based\nreplication.\n\nPractical uses\n--------------\n\nThe expression to get a random integer from a given range is the following:\n\nFLOOR(min_value + RAND() * (max_value - min_value +1))\n\nRAND() is often used to read random rows from a table, as follows:\n\nSELECT * FROM my_table ORDER BY RAND() LIMIT 10;\n\nNote, however, that this technique should never be used on a large table as it\nwill be extremely slow. MariaDB will read all rows in the table, generate a\nrandom value for each of them, order them, and finally will apply the LIMIT\nclause.\n\nExamples\n--------\n\nCREATE TABLE t (i INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.255651095188829 |\n|    2 | 0.833920199269355 |\n|    3 |  0.40264774151393 |\n+------+-------------------+\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.511478140495232 |\n|    2 | 0.349447508668012 |\n|    3 | 0.212803152588013 |\n+------+-------------------+\n\nUsing the same seed, the same sequence will be returned:\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nGenerating a random number from 5 to 15:\n\nSELECT FLOOR(5 + (RAND() * 11));\n\nURL: https://mariadb.com/kb/en/rand/','','https://mariadb.com/kb/en/rand/'),(68,'ROUND',4,'Syntax\n------\n\nROUND(X), ROUND(X,D)\n\nDescription\n-----------\n\nRounds the argument X to D decimal places. D defaults to 0 if not specified. D\ncan be negative to cause D digits left of the decimal point of the value X to\nbecome zero.\n\nThe rounding algorithm depends on the data type of X:\n\n* for floating point types (FLOAT, DOUBLE) the C libraries rounding function\nis used, so the behavior *may* differ between operating systems\n* for fixed point types (DECIMAL, DEC/NUMBER/FIXED) the \"round half up\" rule\nis used, meaning that e.g. a value ending in exactly .5 is always rounded up.\n\nExamples\n--------\n\nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n|           -1 |\n+--------------+\n\nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n|           -2 |\n+--------------+\n\nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n|           2 |\n+-------------+\n\nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n|             1.3 |\n+-----------------+\n\nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n|                20 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/round/','','https://mariadb.com/kb/en/round/'),(69,'SIGN',4,'Syntax\n------\n\nSIGN(X)\n\nDescription\n-----------\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X is\nnegative, zero, or positive.\n\nExamples\n--------\n\nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n|        -1 |\n+-----------+\n\nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n|       0 |\n+---------+\n\nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/sign/','','https://mariadb.com/kb/en/sign/'),(70,'SIN',4,'Syntax\n------\n\nSIN(X)\n\nDescription\n-----------\n\nReturns the sine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT SIN(PI());\n+----------------------+\n| SIN(PI())            |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n\nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n|                0 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/sin/','','https://mariadb.com/kb/en/sin/'),(71,'SQRT',4,'Syntax\n------\n\nSQRT(X)\n\nDescription\n-----------\n\nReturns the square root of X. If X is negative, NULL is returned.\n\nExamples\n--------\n\nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n|       2 |\n+---------+\n\nSELECT SQRT(20);\n+------------------+\n| SQRT(20)         |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n\nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n|         42 |\n+------------+\n\nURL: https://mariadb.com/kb/en/sqrt/','','https://mariadb.com/kb/en/sqrt/'),(72,'TAN',4,'Syntax\n------\n\nTAN(X)\n\nDescription\n-----------\n\nReturns the tangent of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n|      0.9999999999999999 |\n+-------------------------+\n\nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI())             |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n\nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1)     |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n\nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/tan/','','https://mariadb.com/kb/en/tan/'),(73,'TRUNCATE',4,'This page documents the TRUNCATE function. See TRUNCATE TABLE for the DDL\nstatement.\n\nSyntax\n------\n\nTRUNCATE(X,D)\n\nDescription\n-----------\n\nReturns the number X, truncated to D decimal places. If D is 0, the result has\nno decimal point or fractional part. D can be negative to cause D digits left\nof the decimal point of the value X to become zero.\n\nExamples\n--------\n\nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n|               1.2 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n|               1.9 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n|               -1.9 |\n+--------------------+\n\nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n|              100 |\n+------------------+\n\nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n|                  1028 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/truncate/','','https://mariadb.com/kb/en/truncate/'),(74,'INSTALL PLUGIN',5,'Syntax\n------\n\nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement installs an individual plugin from the specified library. To\ninstall the whole library (which could be required), use INSTALL SONAME. See\nalso Installing a Plugin.\n\nplugin_name is the name of the plugin as defined in the plugin declaration\nstructure contained in the library file. Plugin names are not case sensitive.\nFor maximal compatibility, plugin names should be limited to ASCII letters,\ndigits, and underscore, because they are used in C source files, shell command\nlines, M4 and Bourne shell scripts, and SQL environments.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension can be omitted (which makes the statement look\nthe same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nINSTALL PLUGIN causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nPLUGIN only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a note instead of\nan error if the specified plugin already exists. See SHOW WARNINGS.\n\nExamples\n--------\n\nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n\nThe extension can also be omitted:\n\nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected (0.104 sec)\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------+\n| Level | Code | Message                            |\n+-------+------+------------------------------------+\n| Note  | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n\nURL: https://mariadb.com/kb/en/install-plugin/','','https://mariadb.com/kb/en/install-plugin/'),(78,'Plugin Overview',5,'Plugins are server components that enhance MariaDB in some way. These can be\nanything from new storage engines, plugins for enhancing full-text parsing, or\neven small enhancements, such as a plugin to get a timestamp as an integer.\n\nQuerying Plugin Information\n---------------------------\n\nThere are a number of ways to see which plugins are currently active.\n\nA server almost always has a large number of active plugins, because the\nserver contains a large number of built-in plugins, which are active by\ndefault and cannot be uninstalled.\n\nQuerying Plugin Information with SHOW PLUGINS\n---------------------------------------------\n\nThe SHOW PLUGINS statement can be used to query information about all active\nplugins.\n\nFor example:\n\nSHOW PLUGINS\\G;\n********************** 1. row **********************\n Name: binlog\n Status: ACTIVE\n Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n********************** 2. row **********************\n Name: mysql_native_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n********************** 3. row **********************\n Name: mysql_old_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n...\n\nIf a plugin\'s Library column has a NULL value, then the plugin is built-in,\nand it cannot be uninstalled.\n\nQuerying Plugin Information with information_schema.PLUGINS\n-----------------------------------------------------------\n\nThe information_schema.PLUGINS table can be queried to get more detailed\ninformation about plugins.\n\nFor example:\n\nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row ***************************\n     PLUGIN_NAME: CSV\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: Brian Aker, MySQL AB\n  PLUGIN_DESCRIPTION: CSV storage engine\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row ***************************\n     PLUGIN_NAME: MEMORY\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: MySQL AB\n  PLUGIN_DESCRIPTION: Hash based, stored in memory, useful for temporary\ntables\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n\nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value, then the plugin is\nbuilt-in, and it cannot be uninstalled.\n\nQuerying Plugin Information with mysql.plugin\n---------------------------------------------\n\nThe mysql.plugin table can be queried to get information about installed\nplugins.\n\nThis table only contains information about plugins that have been installed\nvia the following methods:\n\n* The INSTALL SONAME statement.\n* The INSTALL PLUGIN statement.\n* The mysql_plugin utility.\n\nThis table does not contain information about:\n\n* Built-in plugins.\n* Plugins loaded with the --plugin-load-add option.\n* Plugins loaded with the --plugin-load option.\n\nThis table only contains enough information to reload the plugin when the\nserver is restarted, which means it only contains the plugin name and the\nplugin library.\n\nFor example:\n\nSELECT * FROM mysql.plugin;\n\n+------+------------+\n| name | dl         |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n\nInstalling a Plugin\n-------------------\n\nThere are three primary ways to install a plugin:\n\n* A plugin can be installed dynamically with an SQL statement.\n* A plugin can be installed with a mysqld option, but it requires a server\nrestart.\n* A plugin can be installed with the mysql_plugin utility, while the server is\ncompletely offline.\n\nWhen you are installing a plugin, you also have to ensure that:\n\n* The server\'s plugin directory is properly configured, and the plugin\'s\nlibrary is in the plugin directory.\n* The server\'s minimum plugin maturity is properly configured, and the plugin\nis mature enough to be installed.\n\nInstalling a Plugin Dynamically\n-------------------------------\n\nA plugin can be installed dynamically by executing either the INSTALL SONAME\nor the INSTALL PLUGIN statement.\n\nIf a plugin is installed with one of these statements, then a record will be\nadded to the mysql.plugins table for the plugin. This means that the plugin\nwill automatically be loaded every time the server restarts, unless\nspecifically uninstalled or deactivated.\n\nInstalling a Plugin with INSTALL SONAME\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL SONAME\nstatement. INSTALL SONAME installs all plugins from the given plugin library.\nThis could be required for some plugin libraries.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin), you could execute the\nfollowing:\n\nINSTALL SONAME \'server_audit\';\n\nInstalling a Plugin with INSTALL PLUGIN\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL PLUGIN\nstatement. INSTALL PLUGIN installs a single plugin from the given plugin\nlibrary.\n\nFor example, to install the server_audit audit plugin from the server_audit\nplugin library, you could execute the following:\n\nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n\nInstalling a Plugin with Plugin Load Options\n--------------------------------------------\n\nA plugin can be installed with a mysqld option by providing either the\n--plugin-load-add or the --plugin-load option.\n\nIf a plugin is installed with one of these options, then a record will not be\nadded to the mysql.plugins table for the plugin. This means that if the server\nis restarted without the same option set, then the plugin will not\nautomatically be loaded.\n\nInstalling a Plugin with --plugin-load-add\n------------------------------------------\n\nYou can install a plugin with the --plugin-load-add option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load-add option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nSpecial care must be taken when specifying both the --plugin-load option and\nthe --plugin-load-add option together. The --plugin-load option resets the\nplugin load list, and this can cause unexpected problems if you are not aware.\nThe --plugin-load-add option does not reset the plugin load list, so it is\nmuch safer to use. See Specifying Multiple Plugin Load Options for more\ninformation.\n\nInstalling a Plugin with --plugin-load\n--------------------------------------\n\nYou can install a plugin with the --plugin-load option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load=\'server_audit;ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option together. The --plugin-load option resets the plugin\nload list, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use. See Specifying Multiple Plugin Load Options for more information.\n\nSpecifying Multiple Plugin Load Options\n---------------------------------------\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use.\n\nThis can have the following consequences:\n\n* If the --plugin-load option is specified multiple times, then only the last\ninstance will have any effect. For example, in the following case, the first\ninstance of the option is reset:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* If the --plugin-load option is specified after the --plugin-load-add option,\nthen it will also reset the changes made by that option. For example, in the\nfollowing case, the --plugin-load-add option does not do anything, because the\nsubsequent --plugin-load option resets the plugin load list:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* In contrast, if the --plugin-load option is specified before the\n--plugin-load-add option, then it will work fine, because the\n--plugin-load-add option does not reset the plugin load list. For example, in\nthe following case, both plugins are properly loaded:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nInstalling a Plugin with mysql_plugin\n-------------------------------------\n\nA plugin can be installed with the mysql_plugin utility if the server is\ncompletely offline.\n\nThe syntax is:\n\nmysql_plugin [options] <plugin> ENABLE|DISABLE\n\nFor example, to install the server_audit audit plugin, you could execute the\nfollowing:\n\nmysql_plugin server_audit ENABLE\n\nIf a plugin is installed with this utility, then a record will be added to the\nmysql.plugins table for the plugin. This means that the plugin will\nautomatically be loaded every time the server restarts, unless specifically\nuninstalled or deactivated.\n\nConfiguring the Plugin Directory\n--------------------------------\n\nWhen a plugin is being installed, the server looks for the plugin\'s library in\nthe server\'s plugin directory. This directory is configured by the plugin_dir\nsystem variable. This can be specified as a command-line argument to mysqld or\nit can be specified in a relevant server option group in an option file. For\nexample:\n\n[mariadb]\n...\nplugin_dir = /usr/lib64/mysql/plugin\n\nConfiguring the Minimum Plugin Maturity\n---------------------------------------\n\nWhen a plugin is being installed, the server compares the plugin\'s maturity\nlevel against the server\'s minimum allowed plugin maturity. This can help\nprevent users from using unstable plugins on production servers. This minimum\nplugin maturity is configured by the plugin_maturity system variable. This can\nbe specified as a command-line argument to mysqld or it can be specified in a\nrelevant server option group in an option file. For example:\n\n[mariadb]\n...\nplugin_maturity = stable\n\nConfiguring Plugin Activation at Server Startup\n-----------------------------------------------\n\nA plugin will be loaded by default when the server starts if:\n\n* The plugin was installed with the INSTALL SONAME statement.\n* The plugin was installed with the INSTALL PLUGIN statement.\n* The plugin was installed with the mysql_plugin utility.\n* The server is configured to load the plugin with the --plugin-load-add\noption.\n* The server is configured to load the plugin with the --plugin-load option.\n\nThis behavior can be changed with special options that take the form\n--plugin-name. For example, for the server_audit audit plugin, the special\noption is called --server-audit.\n\nThe possible values for these special options are:\n\n+---------------------------------------+------------------------------------+\n| Option Value                          | Description                        |\n+---------------------------------------+------------------------------------+\n| OFF                                   | Disables the plugin without        |\n|                                       | removing it from the               |\n|                                       | mysql.plugins table.               |\n+---------------------------------------+------------------------------------+\n| ON                                    | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will still continue         |\n|                                       | starting up, but the plugin will   |\n|                                       | be disabled.                       |\n+---------------------------------------+------------------------------------+\n| FORCE                                 | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error.                             |\n+---------------------------------------+------------------------------------+\n| FORCE_PLUS_PERMANENT                  | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error. In addition, the plugin     |\n|                                       | cannot be uninstalled with         |\n|                                       | UNINSTALL SONAME or UNINSTALL      |\n|                                       | PLUGIN while the server is         |\n|                                       | running.                           |\n+---------------------------------------+------------------------------------+\n\nA plugin\'s status can be found by looking at the PLUGIN_STATUS column of the\ninformation_schema.PLUGINS table.\n\nUninstalling Plugins\n--------------------\n\nPlugins that are found in the mysql.plugin table, that is those that were\ninstalled with INSTALL SONAME, INSTALL PLUGIN or mysql_plugin can be\nuninstalled in one of two ways:\n\n* The UNINSTALL SONAME or the UNINSTALL PLUGIN statement while the server is\nrunning\n* With mysql_plugin while the server is offline.\n\nPlugins that were enabled as a --plugin-load option do not need to be\nuninstalled. If --plugin-load is omitted the next time the server starts, or\nthe plugin is not listed as one of the --plugin-load entries, the plugin will\nnot be loaded.\n\nUNINSTALL PLUGIN uninstalls a single installed plugin, while UNINSTALL SONAME\nuninstalls all plugins belonging to a given library.\n\nURL: https://mariadb.com/kb/en/plugin-overview/','','https://mariadb.com/kb/en/plugin-overview/'),(79,'MBR Definition',6,'Description\n-----------\n\nThe MBR (Minimum Bounding Rectangle), or Envelope is the bounding geometry,\nformed by the minimum and maximum (X,Y) coordinates:\n\nExamples\n--------\n\n((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n\nURL: https://mariadb.com/kb/en/mbr-definition/','','https://mariadb.com/kb/en/mbr-definition/'),(80,'MBRContains',6,'Syntax\n------\n\nMBRContains(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\ncontains the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRWithin().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\n\nSET @g2 = GeomFromText(\'Point(1 1)\');\n\nSELECT MBRContains(@g1,@g2), MBRContains(@g2,@g1);\n+----------------------+----------------------+\n| MBRContains(@g1,@g2) | MBRContains(@g2,@g1) |\n+----------------------+----------------------+\n|                    1 |                    0 |\n+----------------------+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrcontains/','','https://mariadb.com/kb/en/mbrcontains/'),(82,'MBREqual',6,'Syntax\n------\n\nMBREqual(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are the same.\n\nExamples\n--------\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 2)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 2, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 3)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 4, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 0 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/mbrequal/','','https://mariadb.com/kb/en/mbrequal/'),(86,'MBRWithin',6,'Syntax\n------\n\nMBRWithin(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1 is\nwithin the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRContains().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((0 0,0 5,5 5,5 0,0 0))\');\nSELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+\n\nURL: https://mariadb.com/kb/en/mbrwithin/','','https://mariadb.com/kb/en/mbrwithin/'),(75,'UNINSTALL PLUGIN',5,'Syntax\n------\n\nUNINSTALL PLUGIN [IF EXISTS] plugin_name\n\nDescription\n-----------\n\nThis statement removes a single installed plugin. To uninstall the whole\nlibrary which contains the plugin, use UNINSTALL SONAME. You cannot uninstall\na plugin if any table that uses it is open.\n\nplugin_name must be the name of some plugin that is listed in the mysql.plugin\ntable. The server executes the plugin\'s deinitialization function and removes\nthe row for the plugin from the mysql.plugin table, so that subsequent server\nrestarts will not load and initialize the plugin. UNINSTALL PLUGIN does not\nremove the plugin\'s shared library file.\n\nTo use UNINSTALL PLUGIN, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nUNINSTALL PLUGIN example;\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------+\n| Level | Code | Message                       |\n+-------+------+-------------------------------+\n| Note  | 1305 | PLUGIN example does not exist |\n+-------+------+-------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-plugin/','','https://mariadb.com/kb/en/uninstall-plugin/'),(76,'INSTALL SONAME',5,'Syntax\n------\n\nINSTALL SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of INSTALL PLUGIN. It installs all plugins from a\ngiven plugin_library. See INSTALL PLUGIN for details.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL SONAME adds one or more lines to the mysql.plugin table that describes\nthe plugin. This table contains the plugin name and library file name.\n\nINSTALL SONAME causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL SONAME also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL SONAME, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nSONAME only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nIf you need to install only one plugin from a library, use the INSTALL PLUGIN\nstatement.\n\nExamples\n--------\n\nTo load the XtraDB storage engine and all of its information_schema tables\nwith one statement, use\n\nINSTALL SONAME \'ha_xtradb\';\n\nThis statement can be used instead of INSTALL PLUGIN even when the library\ncontains only one plugin:\n\nINSTALL SONAME \'ha_sequence\';\n\nURL: https://mariadb.com/kb/en/install-soname/','','https://mariadb.com/kb/en/install-soname/'),(77,'UNINSTALL SONAME',5,'Syntax\n------\n\nUNINSTALL SONAME  [IF EXISTS] \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of UNINSTALL PLUGIN statement, that removes all\nplugins belonging to a specified plugin_library. See UNINSTALL PLUGIN for\ndetails.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nTo use UNINSTALL SONAME, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin library does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nTo uninstall the XtraDB plugin and all of its information_schema tables with\none statement, use\n\nUNINSTALL SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------------+\n| Level | Code | Message                             |\n+-------+------+-------------------------------------+\n| Note  | 1305 | SONAME ha_example.so does not exist |\n+-------+------+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-soname/','','https://mariadb.com/kb/en/uninstall-soname/'),(90,'NULLIF',7,'Syntax\n------\n\nNULLIF(expr1,expr2)\n\nDescription\n-----------\n\nReturns NULL if expr1 = expr2 is true, otherwise returns expr1. This is the\nsame as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1 END.\n\nExamples\n--------\n\nSELECT NULLIF(1,1);\n+-------------+\n| NULLIF(1,1) |\n+-------------+\n|        NULL |\n+-------------+\n\nSELECT NULLIF(1,2);\n+-------------+\n| NULLIF(1,2) |\n+-------------+\n|           1 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/nullif/','','https://mariadb.com/kb/en/nullif/'),(91,'NVL',7,'MariaDB starting with 10.3\n--------------------------\nFrom MariaDB 10.3, NVL is a synonym for IFNULL.\n\nURL: https://mariadb.com/kb/en/nvl/','','https://mariadb.com/kb/en/nvl/'),(92,'NVL2',7,'MariaDB starting with 10.3\n--------------------------\nThe NLV2 function was introduced in MariaDB 10.3.0.\n\nSyntax\n------\n\nNVL2(expr1,expr2,expr3)\n\nDescription\n-----------\n\nThe NVL2 function returns a value based on whether a specified expression is\nNULL or not. If expr1 is not NULL, then NVL2 returns expr2. If expr1 is NULL,\nthen NVL2 returns expr3.\n\nExamples\n--------\n\nSELECT NVL2(NULL,1,2);\n+----------------+\n| NVL2(NULL,1,2) |\n+----------------+\n|              2 |\n+----------------+\n\nSELECT NVL2(\'x\',1,2);\n+---------------+\n| NVL2(\'x\',1,2) |\n+---------------+\n|             1 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/nvl2/','','https://mariadb.com/kb/en/nvl2/'),(81,'MBRDisjoint',6,'Syntax\n------\n\nMBRDisjoint(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are disjoint. Two geometries are disjoint if they do not\nintersect, that is touch or overlap.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECTmbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrdisjoint/','','https://mariadb.com/kb/en/mbrdisjoint/'),(83,'MBRIntersects',6,'Syntax\n------\n\nMBRIntersects(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 intersect.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      1 |\n+------------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      0 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/mbrintersects/','','https://mariadb.com/kb/en/mbrintersects/'),(84,'MBROverlaps',6,'Syntax\n------\n\nMBROverlaps(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 overlap. The term spatially overlaps is used if two\ngeometries intersect and their intersection results in a geometry of the same\ndimension but not equal to either of the given geometries.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbroverlaps/','','https://mariadb.com/kb/en/mbroverlaps/'),(85,'MBRTouches',6,'Syntax\n------\n\nMBRTouches(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 touch. Two geometries spatially touch if the interiors of\nthe geometries do not intersect, but the boundary of one of the geometries\nintersects either the boundary or the interior of the other.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   1 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/mbrtouches/','','https://mariadb.com/kb/en/mbrtouches/'),(87,'CASE OPERATOR',7,'Syntax\n------\n\nCASE value WHEN [compare_value] THEN result [WHEN [compare_value] THEN\nresult ...] [ELSE result] END\n\nCASE WHEN [condition] THEN result [WHEN [condition] THEN result ...]\n[ELSE result] END\n\nDescription\n-----------\n\nThe first version returns the result where value=compare_value. The second\nversion returns the result for the first condition that is true. If there was\nno matching result value, the result after ELSE is returned, or NULL if there\nis no ELSE part.\n\nThere is also a CASE statement, which differs from the CASE operator described\nhere.\n\nExamples\n--------\n\nSELECT CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END;\n+------------------------------------------------------------+\n| CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END |\n+------------------------------------------------------------+\n| one                                                        |\n+------------------------------------------------------------+\n\nSELECT CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END;\n+--------------------------------------------+\n| CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END |\n+--------------------------------------------+\n| true                                       |\n+--------------------------------------------+\n\nSELECT CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END;\n+-----------------------------------------------------+\n| CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END |\n+-----------------------------------------------------+\n|                                                NULL |\n+-----------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/case-operator/','','https://mariadb.com/kb/en/case-operator/'),(101,'UNLOCK TABLES',8,'Syntax\n------\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\nSee LOCK TABLES for more information.\n\nIn addition to releasing table locks acquired by the LOCK TABLES statement,\nthe UNLOCK TABLES statement also releases the global read lock acquired by the\nFLUSH TABLES WITH READ LOCK statement. The FLUSH TABLES WITH READ LOCK\nstatement is very useful for performing backups. See FLUSH for more\ninformation about FLUSH TABLES WITH READ LOCK.\n\nURL: https://mariadb.com/kb/en/transactions-unlock-tables/','','https://mariadb.com/kb/en/transactions-unlock-tables/'),(103,'XA Transactions',8,'Overview\n--------\n\nThe MariaDB XA implementation is based on the X/Open CAE document Distributed\nTransaction Processing: The XA Specification. This document is published by\nThe Open Group and available at\nhttp://www.opengroup.org/public/pubs/catalog/c193.htm.\n\nXA transactions are designed to allow distributed transactions, where a\ntransaction manager (the application) controls a transaction which involves\nmultiple resources. Such resources are usually DBMSs, but could be resources\nof any type. The whole set of required transactional operations is called a\nglobal transaction. Each subset of operations which involve a single resource\nis called a local transaction. XA used a 2-phases commit (2PC). With the first\ncommit, the transaction manager tells each resource to prepare an effective\ncommit, and waits for a confirm message. The changes are not still made\neffective at this point. If any of the resources encountered an error, the\ntransaction manager will rollback the global transaction. If all resources\ncommunicate that the first commit is successful, the transaction manager can\nrequire a second commit, which makes the changes effective.\n\nIn MariaDB, XA transactions can only be used with storage engines that support\nthem. At least InnoDB, TokuDB, SPIDER and MyRocks support them. For InnoDB,\nuntil MariaDB 10.2, XA transactions can be disabled by setting the\ninnodb_support_xa server system variable to 0. From MariaDB 10.3, XA\ntransactions are always supported.\n\nLike regular transactions, XA transactions create metadata locks on accessed\ntables.\n\nXA transactions require REPEATABLE READ as a minimum isolation level. However,\ndistributed transactions should always use SERIALIZABLE.\n\nTrying to start more than one XA transaction at the same time produces a 1400\nerror (SQLSTATE \'XAE09\'). The same error is produced when attempting to start\nan XA transaction while a regular transaction is in effect. Trying to start a\nregular transaction while an XA transaction is in effect produces a 1399 error\n(SQLSTATE \'XAE07\').\n\nThe statements that cause an implicit COMMIT for regular transactions produce\na 1400 error (SQLSTATE \'XAE09\') if a XA transaction is in effect.\n\nInternal XA vs External XA\n--------------------------\n\nXA transactions are an overloaded term in MariaDB. If a storage engine is\nXA-capable, it can mean one or both of these:\n\n* It supports MariaDB\'s internal two-phase commit API. This is transparent to\nthe user. Sometimes this is called \"internal XA\", since MariaDB\'s internal\ntransaction coordinator log can handle coordinating these transactions.\n\n* It supports XA transactions, with the XA START, XA PREPARE, XA COMMIT, etc.\nstatements. Sometimes this is called \"external XA\", since it requires the use\nof an external transaction coordinator to use this feature properly.\n\nTransaction Coordinator Log\n---------------------------\n\nIf you have two or more XA-capable storage engines enabled, then a transaction\ncoordinator log must be available.\n\nThere are currently two implementations of the transaction coordinator log:\n\n* Binary log-based transaction coordinator log\n* Memory-mapped file-based transaction coordinator log\n\nIf the binary log is enabled on a server, then the server will use the binary\nlog-based transaction coordinator log. Otherwise, it will use the\nmemory-mapped file-based transaction coordinator log.\n\nSee Transaction Coordinator Log for more information.\n\nSyntax\n------\n\nXA {START|BEGIN} xid [JOIN|RESUME]\n\nXA END xid [SUSPEND [FOR MIGRATE]]\n\nXA PREPARE xid\n\nXA COMMIT xid [ONE PHASE]\n\nXA ROLLBACK xid\n\nXA RECOVER [FORMAT=[\'RAW\'|\'SQL\']]\n\nxid: gtrid [, bqual [, formatID ]]\n\nThe interface to XA transactions is a set of SQL statements starting with XA.\nEach statement changes a transaction\'s state, determining which actions it can\nperform. A transaction which does not exist is in the NON-EXISTING state.\n\nXA START (or BEGIN) starts a transaction and defines its xid (a transaction\nidentifier). The JOIN or RESUME keywords have no effect. The new transaction\nwill be in ACTIVE state.\n\nThe xid can have 3 components, though only the first one is mandatory. gtrid\nis a quoted string representing a global transaction identifier. bqual is a\nquoted string representing a local transaction identifier. formatID is an\nunsigned integer indicating the format used for the first two components; if\nnot specified, defaults to 1. MariaDB does not interpret in any way these\ncomponents, and only uses them to identify a transaction. xids of transactions\nin effect must be unique.\n\nXA END declares that the specified ACTIVE transaction is finished and it\nchanges its state to IDLE. SUSPEND [FOR MIGRATE] has no effect.\n\nXA PREPARE prepares an IDLE transaction for commit, changing its state to\nPREPARED. This is the first commit.\n\nXA COMMIT definitely commits and terminates a transaction which has already\nbeen PREPARED. If the ONE PHASE clause is specified, this statements performs\na 1-phase commit on an IDLE transaction.\n\nXA ROLLBACK rolls back and terminates an IDLE or PREPARED transaction.\n\nXA RECOVER shows information about all PREPARED transactions.\n\nWhen trying to execute an operation which is not allowed for the transaction\'s\ncurrent state, an error is produced:\n\nXA COMMIT \'test\' ONE PHASE;\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  ACTIVE state\n\nXA COMMIT \'test2\';\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  NON-EXISTING state\n\nXA RECOVER\n----------\n\nThe XA RECOVER statement shows information about all transactions which are in\nthe PREPARED state. It does not matter which connection created the\ntransaction: if it has been PREPARED, it appears. But this does not mean that\na connection can commit or rollback a transaction which was started by another\nconnection. Note that transactions using a 1-phase commit are never in the\nPREPARED state, so they cannot be shown by XA RECOVER.\n\nXA RECOVER produces four columns:\n\nXA RECOVER;\n+----------+--------------+--------------+------+\n| formatID | gtrid_length | bqual_length | data |\n+----------+--------------+--------------+------+\n|        1 |            4 |            0 | test |\n+----------+--------------+--------------+------+\n\nMariaDB starting with 10.3.3\n----------------------------\nYou can use XA RECOVER FORMAT=\'SQL\' to get the data in a human readable form\nthat can be directly copy-pasted into XA COMMIT or XA ROLLBACK. This is\nparticularly useful for binary xid generated by some transaction coordinators.\n\nformatID is the formatID part of xid.\n\ndata are the gtrid and bqual parts of xid, concatenated.\n\ngtrid_length and bqual_length are the lengths of gtrid and bqual, respectevely.\n\nExamples\n--------\n\n2-phases commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA PREPARE \'test\';\n\nXA COMMIT \'test\';\n\n1-phase commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA COMMIT \'test\' ONE PHASE;\n\nHuman-readable:\n\nxa start \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\ninsert t1 values (40);\n\nxa end \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa prepare \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa recover format=\'RAW\';\n+----------+--------------+--------------+--------------------+\n| formatID | gtrid_length | bqual_length | data               |\n+----------+--------------+--------------+--------------------+\n34      67v78abc       11 |            7 | 12\ndef |\n+----------+--------------+--------------+--------------------+\n\nxa recover format=\'SQL\';\n+----------+--------------+--------------+-------------------------------------\n---------+\n| formatID | gtrid_length | bqual_length | data                               \n     |\n+----------+--------------+--------------+-------------------------------------\n---------+\n|        3 |           11 |            7 |\nX\'31320d3334093637763738\',X\'6162630a646566\',3 |\n+----------+--------------+--------------+-------------------------------------\n---------+\n\nxa rollback X\'31320d3334093637763738\',X\'6162630a646566\',3;\n\nKnown Issues\n------------\n\nMariaDB Galera Cluste