/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('6e615730-4f24-4977-a1e3-1a4819a65b32','2025-10-01 16:19:45','2025-10-01 16:19:45',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'consistent_group_snapshot_enabled','<is> True','c5dc0db6-4ae9-4139-9a1a-3f1b5afd7df1','2025-10-01 16:19:56','2025-10-01 16:19:56',NULL,0);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('c5dc0db6-4ae9-4139-9a1a-3f1b5afd7df1','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2025-10-01 16:19:56','2025-10-01 16:19:56',NULL,0,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`),
  KEY `ix_image_volume_cache_entries_host` (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2025-10-01 16:19:54',NULL,NULL,0,1,'default','volumes',10),('2025-10-01 16:19:54',NULL,NULL,0,2,'default','snapshots',10),('2025-10-01 16:19:54',NULL,NULL,0,3,'default','gigabytes',1000),('2025-10-01 16:19:54',NULL,NULL,0,4,'default','consistencygroups',10),('2025-10-01 16:19:54',NULL,NULL,0,5,'default','per_volume_gigabytes',-1),('2025-10-01 16:19:54',NULL,NULL,0,6,'default','groups',10);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`,`race_preventer`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2025-10-01 16:20:04','2025-10-01 17:23:18',NULL,0,1,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',375,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'e20608fa-e070-4df7-a0b9-feb26cbd8d0e'),('2025-10-01 16:54:35','2025-10-01 17:23:26',NULL,0,2,'cinder-backup-0','cinder-backup','cinder-backup',173,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'76b72731-ce49-41e8-9fd3-63378371bfb6'),('2025-10-01 16:54:35','2025-10-01 17:23:27',NULL,0,3,'hostgroup@ceph','cinder-volume','cinder-volume',173,0,'nova',NULL,NULL,'3.18','1.39','disabled',0,NULL,NULL,'dbd41fdd-ea50-4f4f-b4ae-d1744443bbd1');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2025-10-01 16:19:56','2025-10-01 16:19:56',NULL,0,'64053eb3-0e64-4ed5-bd87-2492371e66e1','__DEFAULT__',NULL,1,'Default Volume Type');
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2025-10-01 16:19:56','2025-10-01 16:19:56.000123',NULL,0,1,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (1,'1a49ca0a-cf93-4ec3-97b2-200f7572429a','rbd://f44264e3-e26a-5bd3-9e84-b4ba651d9cf5/images/1a49ca0a-cf93-4ec3-97b2-200f7572429a/snap','2025-10-01 16:59:54','2025-10-01 16:59:54',NULL,0,'{\"store\": \"default_backend\"}','active'),(2,'3ae8cd26-7a77-45f0-a953-5eece0d770b4','rbd://f44264e3-e26a-5bd3-9e84-b4ba651d9cf5/images/3ae8cd26-7a77-45f0-a953-5eece0d770b4/snap','2025-10-01 16:59:57','2025-10-01 16:59:57',NULL,0,'{\"store\": \"default_backend\"}','active');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'1a49ca0a-cf93-4ec3-97b2-200f7572429a','hw_rng_model','virtio','2025-10-01 16:59:51','2025-10-01 16:59:51',NULL,0),(2,'3ae8cd26-7a77-45f0-a953-5eece0d770b4','hw_rng_model','virtio','2025-10-01 16:59:55','2025-10-01 16:59:55',NULL,0);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('1a49ca0a-cf93-4ec3-97b2-200f7572429a','cirros-0.6.2-x86_64-disk.img',21430272,'active','2025-10-01 16:59:51','2025-10-01 16:59:54',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','fc20e0a59557470e8cf5189ec2e95a2e',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('3ae8cd26-7a77-45f0-a953-5eece0d770b4','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2025-10-01 16:59:55','2025-10-01 16:59:57',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','fc20e0a59557470e8cf5189ec2e95a2e',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b');
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (1,1,'image','CIM_PASD_','2025-10-01 16:18:59',NULL),(1,2,'image','CIM_RASD_','2025-10-01 16:18:59',NULL),(1,3,NULL,'CIM_SASD_','2025-10-01 16:19:00',NULL),(1,9,'image','hw_','2025-10-01 16:19:01',NULL),(1,10,'image','hw_','2025-10-01 16:19:02',NULL),(1,14,'image',NULL,'2025-10-01 16:19:02',NULL),(1,19,'image','hw_','2025-10-01 16:19:02',NULL),(1,25,'image','hw_','2025-10-01 16:19:03',NULL),(1,29,'image',NULL,'2025-10-01 16:19:03',NULL),(1,30,'image',NULL,'2025-10-01 16:19:03',NULL),(1,31,'image',NULL,'2025-10-01 16:19:03',NULL),(1,32,'image',NULL,'2025-10-01 16:19:03',NULL),(2,1,NULL,'CIM_PASD_','2025-10-01 16:18:59',NULL),(2,8,NULL,'hw_','2025-10-01 16:19:01',NULL),(2,9,NULL,'hw_','2025-10-01 16:19:01',NULL),(2,10,NULL,'hw_','2025-10-01 16:19:02',NULL),(2,11,NULL,NULL,'2025-10-01 16:19:02',NULL),(2,13,NULL,NULL,'2025-10-01 16:19:02',NULL),(2,14,NULL,NULL,'2025-10-01 16:19:02',NULL),(2,15,NULL,NULL,'2025-10-01 16:19:02',NULL),(2,16,NULL,'hw_','2025-10-01 16:19:02',NULL),(2,19,NULL,'hw_','2025-10-01 16:19:02',NULL),(2,22,NULL,NULL,'2025-10-01 16:19:03',NULL),(2,23,NULL,'hw_','2025-10-01 16:19:03',NULL),(2,24,NULL,'traits:','2025-10-01 16:19:03',NULL),(2,25,NULL,'hw_','2025-10-01 16:19:03',NULL),(2,26,NULL,NULL,'2025-10-01 16:19:03',NULL),(2,28,NULL,NULL,'2025-10-01 16:19:03',NULL),(2,29,NULL,NULL,'2025-10-01 16:19:03',NULL),(2,30,NULL,NULL,'2025-10-01 16:19:03',NULL),(2,31,NULL,NULL,'2025-10-01 16:19:03',NULL),(2,32,NULL,NULL,'2025-10-01 16:19:03',NULL),(2,33,NULL,'cinder_','2025-10-01 16:19:03',NULL),(3,1,NULL,'CIM_PASD_','2025-10-01 16:18:59',NULL),(3,2,NULL,'CIM_RASD_','2025-10-01 16:18:59',NULL),(3,3,NULL,'CIM_SASD_','2025-10-01 16:19:00',NULL),(3,4,NULL,'CIM_VSSD_','2025-10-01 16:19:00',NULL),(3,5,NULL,NULL,'2025-10-01 16:19:01',NULL),(3,6,NULL,NULL,'2025-10-01 16:19:01',NULL),(3,7,NULL,NULL,'2025-10-01 16:19:01',NULL),(3,12,NULL,'aggregate_instance_extra_specs:','2025-10-01 16:19:02',NULL),(4,1,NULL,'CIM_PASD_','2025-10-01 16:18:59',NULL),(4,2,NULL,'CIM_RASD_','2025-10-01 16:18:59',NULL),(4,3,NULL,'CIM_SASD_','2025-10-01 16:19:00',NULL),(4,4,NULL,'CIM_VSSD_','2025-10-01 16:19:00',NULL),(4,8,NULL,'hw:','2025-10-01 16:19:01',NULL),(4,9,NULL,'hw:','2025-10-01 16:19:01',NULL),(4,10,NULL,'hw:','2025-10-01 16:19:02',NULL),(4,12,NULL,'capabilities:','2025-10-01 16:19:02',NULL),(4,16,NULL,'hw:','2025-10-01 16:19:02',NULL),(4,17,NULL,NULL,'2025-10-01 16:19:02',NULL),(4,18,NULL,NULL,'2025-10-01 16:19:02',NULL),(4,19,NULL,'hw:','2025-10-01 16:19:02',NULL),(4,20,NULL,NULL,'2025-10-01 16:19:02',NULL),(4,21,NULL,NULL,'2025-10-01 16:19:02',NULL),(4,23,NULL,'hw:','2025-10-01 16:19:03',NULL),(4,24,NULL,'traits:','2025-10-01 16:19:03',NULL),(4,25,NULL,'hw:','2025-10-01 16:19:03',NULL),(5,1,'scheduler_hints',NULL,'2025-10-01 16:18:59',NULL),(5,30,'metadata',NULL,'2025-10-01 16:19:03',NULL),(5,31,'metadata',NULL,'2025-10-01 16:19:03',NULL),(5,32,'metadata',NULL,'2025-10-01 16:19:03',NULL),(6,30,NULL,NULL,'2025-10-01 16:19:03',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (1,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2025-10-01 16:18:59',NULL),(2,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2025-10-01 16:18:59',NULL),(3,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2025-10-01 16:19:00',NULL),(4,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2025-10-01 16:19:00',NULL),(5,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-10-01 16:19:01',NULL),(6,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-10-01 16:19:01',NULL),(7,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2025-10-01 16:19:01',NULL),(8,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2025-10-01 16:19:01',NULL),(9,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2025-10-01 16:19:01',NULL),(10,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2025-10-01 16:19:01',NULL),(11,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2025-10-01 16:19:02',NULL),(12,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2025-10-01 16:19:02',NULL),(13,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2025-10-01 16:19:02',NULL),(14,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2025-10-01 16:19:02',NULL),(15,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-10-01 16:19:02',NULL),(16,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-10-01 16:19:02',NULL),(17,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-10-01 16:19:02',NULL),(18,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2025-10-01 16:19:02',NULL),(19,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2025-10-01 16:19:02',NULL),(20,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-10-01 16:19:02',NULL),(21,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-10-01 16:19:02',NULL),(22,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-10-01 16:19:03',NULL),(23,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2025-10-01 16:19:03',NULL),(24,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2025-10-01 16:19:03',NULL),(25,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-10-01 16:19:03',NULL),(26,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-10-01 16:19:03',NULL),(27,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2025-10-01 16:19:03',NULL),(28,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2025-10-01 16:19:03',NULL),(29,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2025-10-01 16:19:03',NULL),(30,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2025-10-01 16:19:03',NULL),(31,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2025-10-01 16:19:03',NULL),(32,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2025-10-01 16:19:03',NULL),(33,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2025-10-01 16:19:03',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (1,17,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2025-10-01 16:19:02',NULL),(2,17,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2025-10-01 16:19:02',NULL),(3,17,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2025-10-01 16:19:02',NULL),(4,30,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2025-10-01 16:19:03',NULL),(5,30,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2025-10-01 16:19:03',NULL),(6,30,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2025-10-01 16:19:03',NULL),(7,30,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2025-10-01 16:19:03',NULL),(8,30,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-10-01 16:19:03',NULL),(9,30,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-10-01 16:19:03',NULL),(10,30,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-10-01 16:19:03',NULL),(11,30,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-10-01 16:19:03',NULL),(12,30,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-10-01 16:19:03',NULL),(13,30,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2025-10-01 16:19:03',NULL),(14,30,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2025-10-01 16:19:03',NULL),(15,30,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2025-10-01 16:19:03',NULL),(16,31,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2025-10-01 16:19:03',NULL),(17,31,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2025-10-01 16:19:03',NULL),(18,31,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2025-10-01 16:19:03',NULL),(19,31,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2025-10-01 16:19:03',NULL),(20,31,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2025-10-01 16:19:03',NULL),(21,32,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-10-01 16:19:03',NULL),(22,32,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-10-01 16:19:03',NULL),(23,32,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-10-01 16:19:03',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (1,1,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2025-10-01 16:18:59',NULL),(2,1,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2025-10-01 16:18:59',NULL),(3,1,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2025-10-01 16:18:59',NULL),(4,2,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2025-10-01 16:18:59',NULL),(5,2,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2025-10-01 16:18:59',NULL),(6,2,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2025-10-01 16:18:59',NULL),(7,2,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2025-10-01 16:18:59',NULL),(8,2,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2025-10-01 16:18:59',NULL),(9,2,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-10-01 16:18:59',NULL),(10,2,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2025-10-01 16:18:59',NULL),(11,2,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2025-10-01 16:18:59',NULL),(12,2,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2025-10-01 16:18:59',NULL),(13,2,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2025-10-01 16:18:59',NULL),(14,2,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2025-10-01 16:18:59',NULL),(15,2,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2025-10-01 16:18:59',NULL),(16,2,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2025-10-01 16:18:59',NULL),(17,2,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-10-01 16:18:59',NULL),(18,2,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2025-10-01 16:18:59',NULL),(19,2,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-10-01 16:18:59',NULL),(20,2,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2025-10-01 16:18:59',NULL),(21,2,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2025-10-01 16:18:59',NULL),(22,2,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2025-10-01 16:19:00',NULL),(23,3,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2025-10-01 16:19:00',NULL),(24,3,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2025-10-01 16:19:00',NULL),(25,3,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2025-10-01 16:19:00',NULL),(26,3,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2025-10-01 16:19:00',NULL),(27,3,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2025-10-01 16:19:00',NULL),(28,3,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-10-01 16:19:00',NULL),(29,3,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-10-01 16:19:00',NULL),(30,3,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2025-10-01 16:19:00',NULL),(31,3,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2025-10-01 16:19:00',NULL),(32,3,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-10-01 16:19:00',NULL),(33,3,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2025-10-01 16:19:00',NULL),(34,3,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-10-01 16:19:00',NULL),(35,3,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-10-01 16:19:00',NULL),(36,4,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2025-10-01 16:19:00',NULL),(37,4,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2025-10-01 16:19:00',NULL),(38,4,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2025-10-01 16:19:00',NULL),(39,4,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2025-10-01 16:19:00',NULL),(40,4,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2025-10-01 16:19:00',NULL),(41,4,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-10-01 16:19:00',NULL),(42,4,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-10-01 16:19:00',NULL),(43,4,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2025-10-01 16:19:00',NULL),(44,4,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2025-10-01 16:19:00',NULL),(45,4,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2025-10-01 16:19:00',NULL),(46,4,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2025-10-01 16:19:00',NULL),(47,4,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2025-10-01 16:19:00',NULL),(48,4,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2025-10-01 16:19:00',NULL),(49,4,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2025-10-01 16:19:00',NULL),(50,4,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2025-10-01 16:19:00',NULL),(51,4,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2025-10-01 16:19:00',NULL),(52,4,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2025-10-01 16:19:01',NULL),(53,5,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2025-10-01 16:19:01',NULL),(54,6,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2025-10-01 16:19:01',NULL),(55,7,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2025-10-01 16:19:01',NULL),(56,8,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2025-10-01 16:19:01',NULL),(57,9,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2025-10-01 16:19:01',NULL),(58,9,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2025-10-01 16:19:01',NULL),(59,10,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2025-10-01 16:19:02',NULL),(60,11,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2025-10-01 16:19:02',NULL),(61,12,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2025-10-01 16:19:02',NULL),(62,12,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2025-10-01 16:19:02',NULL),(63,12,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2025-10-01 16:19:02',NULL),(64,12,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-10-01 16:19:02',NULL),(65,12,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-10-01 16:19:02',NULL),(66,12,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-10-01 16:19:02',NULL),(67,12,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2025-10-01 16:19:02',NULL),(68,13,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2025-10-01 16:19:02',NULL),(69,13,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2025-10-01 16:19:02',NULL),(70,14,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2025-10-01 16:19:02',NULL),(71,14,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-10-01 16:19:02',NULL),(72,15,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-10-01 16:19:02',NULL),(73,15,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-10-01 16:19:02',NULL),(74,15,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2025-10-01 16:19:02',NULL),(75,15,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2025-10-01 16:19:02',NULL),(76,15,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2025-10-01 16:19:02',NULL),(77,15,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2025-10-01 16:19:02',NULL),(78,15,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\", \"bochs\"]}','2025-10-01 16:19:02',NULL),(79,15,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2025-10-01 16:19:02',NULL),(80,15,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2025-10-01 16:19:02',NULL),(81,15,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2025-10-01 16:19:02',NULL),(82,15,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, virtio, e1000e and vmxnet3. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\", \"vmxnet3\"]}','2025-10-01 16:19:02',NULL),(83,15,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-10-01 16:19:02',NULL),(84,15,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-10-01 16:19:02',NULL),(85,15,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-10-01 16:19:02',NULL),(86,15,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2025-10-01 16:19:02',NULL),(87,15,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-10-01 16:19:02',NULL),(88,16,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2025-10-01 16:19:02',NULL),(89,16,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-10-01 16:19:02',NULL),(90,16,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-10-01 16:19:02',NULL),(91,18,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2025-10-01 16:19:02',NULL),(92,18,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2025-10-01 16:19:02',NULL),(93,18,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2025-10-01 16:19:02',NULL),(94,19,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-10-01 16:19:02',NULL),(95,19,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-10-01 16:19:02',NULL),(96,19,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-10-01 16:19:02',NULL),(97,19,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-10-01 16:19:02',NULL),(98,19,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-10-01 16:19:02',NULL),(99,19,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-10-01 16:19:02',NULL),(100,20,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2025-10-01 16:19:02',NULL),(101,20,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2025-10-01 16:19:02',NULL),(102,21,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2025-10-01 16:19:02',NULL),(103,21,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2025-10-01 16:19:03',NULL),(104,22,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2025-10-01 16:19:03',NULL),(105,22,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2025-10-01 16:19:03',NULL),(106,22,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2025-10-01 16:19:03',NULL),(107,22,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2025-10-01 16:19:03',NULL),(108,22,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2025-10-01 16:19:03',NULL),(109,22,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-10-01 16:19:03',NULL),(110,23,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2025-10-01 16:19:03',NULL),(111,24,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-10-01 16:19:03',NULL),(112,24,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-10-01 16:19:03',NULL),(113,25,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2025-10-01 16:19:03',NULL),(114,26,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2025-10-01 16:19:03',NULL),(115,27,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2025-10-01 16:19:03',NULL),(116,27,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2025-10-01 16:19:03',NULL),(117,27,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2025-10-01 16:19:03',NULL),(118,27,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2025-10-01 16:19:03',NULL),(119,27,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-10-01 16:19:03',NULL),(120,27,'hw_cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"This specifies the CPU Mode for the guest vm\", \"type\": \"string\"}','2025-10-01 16:19:03',NULL),(121,27,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-10-01 16:19:03',NULL),(122,27,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2025-10-01 16:19:03',NULL),(123,27,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2025-10-01 16:19:03',NULL),(124,27,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2025-10-01 16:19:03',NULL),(125,28,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2025-10-01 16:19:03',NULL),(126,28,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2025-10-01 16:19:03',NULL),(127,28,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2025-10-01 16:19:03',NULL),(128,28,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2025-10-01 16:19:03',NULL),(129,29,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-10-01 16:19:03',NULL),(130,29,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-10-01 16:19:03',NULL),(131,29,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2025-10-01 16:19:03',NULL),(132,33,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2025-10-01 16:19:03',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (1,'OS::Cinder::Volume',1,'2025-10-01 16:18:59',NULL),(2,'OS::Glance::Image',1,'2025-10-01 16:18:59',NULL),(3,'OS::Nova::Aggregate',1,'2025-10-01 16:18:59',NULL),(4,'OS::Nova::Flavor',1,'2025-10-01 16:18:59',NULL),(5,'OS::Nova::Server',1,'2025-10-01 16:18:59',NULL),(6,'OS::Trove::Instance',1,'2025-10-01 16:19:03',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `user_id` (`user_id`),
  KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','1e7cb4fd596344d3a28ba912440bb994','d71d1a0c80274beaa9fa95a28a8fe346','8a68648697574401b53f564960fd61b3',0),('UserProject','1e7cb4fd596344d3a28ba912440bb994','d71d1a0c80274beaa9fa95a28a8fe346','de14787aa646471b870c7a38d426f499',0),('UserProject','2a8b9f442cfe40c0ade56e5615df3f86','d71d1a0c80274beaa9fa95a28a8fe346','8a68648697574401b53f564960fd61b3',0),('UserProject','2a8b9f442cfe40c0ade56e5615df3f86','d71d1a0c80274beaa9fa95a28a8fe346','de14787aa646471b870c7a38d426f499',0),('UserProject','3170bc846d9740d4be0e3e873ca04a7a','d71d1a0c80274beaa9fa95a28a8fe346','8a68648697574401b53f564960fd61b3',0),('UserProject','3170bc846d9740d4be0e3e873ca04a7a','d71d1a0c80274beaa9fa95a28a8fe346','de14787aa646471b870c7a38d426f499',0),('UserProject','39c4052e56fa42f19855653f980c1235','92de8884ad3248ec8c4c2392254b47dc','de14787aa646471b870c7a38d426f499',0),('UserProject','39c4052e56fa42f19855653f980c1235','fc20e0a59557470e8cf5189ec2e95a2e','91c7523f411b477e8a0bb4b31d04cbbe',0),('UserProject','39c4052e56fa42f19855653f980c1235','fc20e0a59557470e8cf5189ec2e95a2e','de14787aa646471b870c7a38d426f499',0),('UserProject','7cc625222d1440d2aaeef272e538fa9b','d71d1a0c80274beaa9fa95a28a8fe346','8a68648697574401b53f564960fd61b3',0),('UserProject','7cc625222d1440d2aaeef272e538fa9b','d71d1a0c80274beaa9fa95a28a8fe346','de14787aa646471b870c7a38d426f499',0),('UserProject','87e1344ec184480ea428441d78497712','d71d1a0c80274beaa9fa95a28a8fe346','8a68648697574401b53f564960fd61b3',0),('UserProject','87e1344ec184480ea428441d78497712','d71d1a0c80274beaa9fa95a28a8fe346','de14787aa646471b870c7a38d426f499',0),('UserProject','afebc63b810b4e318f6f8d5ddaf76e2a','d71d1a0c80274beaa9fa95a28a8fe346','8a68648697574401b53f564960fd61b3',0),('UserProject','afebc63b810b4e318f6f8d5ddaf76e2a','d71d1a0c80274beaa9fa95a28a8fe346','de14787aa646471b870c7a38d426f499',0),('UserProject','b37ef411ccd643c78ba7ab709abbb2aa','d71d1a0c80274beaa9fa95a28a8fe346','49ba82507399441bac92440e3c1fab3a',0),('UserProject','b37ef411ccd643c78ba7ab709abbb2aa','d71d1a0c80274beaa9fa95a28a8fe346','de14787aa646471b870c7a38d426f499',0),('UserProject','d0552c4d46f047b8b2e18eaaf950be7d','d71d1a0c80274beaa9fa95a28a8fe346','8a68648697574401b53f564960fd61b3',0),('UserProject','d0552c4d46f047b8b2e18eaaf950be7d','d71d1a0c80274beaa9fa95a28a8fe346','de14787aa646471b870c7a38d426f499',0),('UserProject','deda12cecd7e4e0ba98c335b177911c4','d71d1a0c80274beaa9fa95a28a8fe346','8a68648697574401b53f564960fd61b3',0),('UserProject','deda12cecd7e4e0ba98c335b177911c4','d71d1a0c80274beaa9fa95a28a8fe346','de14787aa646471b870c7a38d426f499',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('0bf222c572e044d9b01a561422cf4d64',NULL,'public','be08e452dc984d7d8f30be2a6a71b7a7','https://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('1a4833b57e5f46938eb18db9a6346fd7',NULL,'public','43c9e2706c65471ca1e34bf302b45bcf','https://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('597b43b8738349eebab10b0b19c3eff5',NULL,'internal','6c68618ad3314a56bfd5d8b69115c502','https://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('5b506460e59640138765a54d27e99365',NULL,'internal','be08e452dc984d7d8f30be2a6a71b7a7','https://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('65299100e19c4fa6b5ffe0f4578c742c',NULL,'internal','75cb545e48b14961a17d5ccaae53ce5d','https://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('6b03a0b436734defa680da74ae13e81a',NULL,'public','00d5d24e87684b5588acb93e1fe76116','https://manila-public-openstack.apps-crc.testing/v2','{\"name\": \"manilav2\"}',1,'regionOne'),('74d076b3b180438490b05b9b4ed77355',NULL,'internal','00d5d24e87684b5588acb93e1fe76116','https://manila-internal.openstack.svc:8786/v2','{\"name\": \"manilav2\"}',1,'regionOne'),('782a0bf732fa4dcfbba9742e0f1dcca8',NULL,'internal','899a890dfbd548029183dc732c564492','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('7865f74b13f8461e96a9d2d8e8ff3cc3',NULL,'public','899a890dfbd548029183dc732c564492','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('8516c37c3cbd41d081fe2573b4e6c56d',NULL,'public','75cb545e48b14961a17d5ccaae53ce5d','https://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('87904575bd564acc95406b3dcb35c2e0',NULL,'internal','43c9e2706c65471ca1e34bf302b45bcf','https://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('88abe685bd5c41ca9f1826954b78f797',NULL,'internal','b1b284a1545c4d59b22e38fd89987e72','https://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('8b8357658675437a8df1ce6b1f891047',NULL,'internal','2ceda381770947c6843d0e4a0649e8cb','https://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('8ee4ebd077324e569c7aebb88af2141f',NULL,'internal','ea2ac4606426449fb0b329c3ca405bb5','https://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('9c3a8ff75c184655b8302057c2515fb4',NULL,'internal','fdd1281862d14f339ef5cf59971ac7a3','https://manila-internal.openstack.svc:8786/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne'),('9c8fb1deac284081a31b6e97a02b73d7',NULL,'public','2ceda381770947c6843d0e4a0649e8cb','https://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('b9f601faff064f24924bde53f2008ec9',NULL,'public','ea2ac4606426449fb0b329c3ca405bb5','https://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('ba1138f2482c4faf980200d4987d2812',NULL,'public','fdd1281862d14f339ef5cf59971ac7a3','https://manila-public-openstack.apps-crc.testing/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne'),('bda2b1e4c0724795a25b550443894214',NULL,'public','b1b284a1545c4d59b22e38fd89987e72','https://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('d91e15cd29a94858bdcd129663b9acf7',NULL,'public','6c68618ad3314a56bfd5d8b69115c502','https://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('49ba82507399441bac92440e3c1fab3a','e5625c9a9f9a460397271eaedd726eac'),('de14787aa646471b870c7a38d426f499','49ba82507399441bac92440e3c1fab3a');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=233 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (1,'39c4052e56fa42f19855653f980c1235','default','admin',0,NULL),(2,'3170bc846d9740d4be0e3e873ca04a7a','default','barbican',0,NULL),(3,'1e7cb4fd596344d3a28ba912440bb994','default','neutron',0,NULL),(4,'deda12cecd7e4e0ba98c335b177911c4','default','glance',0,NULL),(5,'d0552c4d46f047b8b2e18eaaf950be7d','default','nova',0,NULL),(6,'2a8b9f442cfe40c0ade56e5615df3f86','default','placement',0,NULL),(7,'afebc63b810b4e318f6f8d5ddaf76e2a','default','cinder',0,NULL),(8,'87e1344ec184480ea428441d78497712','default','ceilometer',0,NULL),(9,'b37ef411ccd643c78ba7ab709abbb2aa','default','swift',0,NULL),(10,'7cc625222d1440d2aaeef272e538fa9b','default','manila',0,NULL),(11,'b3781d9cac084739bb2df1a4fbe2a6b3','default','demo_tempestconf',0,NULL),(12,'271b99e4429d4875abd7ec0f99939057','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=233 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (1,1,NULL,0,'$2b$12$.Z4ICtRaiNKXSv/BKSoNSeWs5enSB6lzjsKLppeCs0fPQII20mI4C',1759335543910661,NULL,'2025-10-01 16:19:03'),(2,2,NULL,0,'$2b$12$CID9k9ZeiHZPbtcSfLbu5uzogocyR8iMmR2GAqzSH2CKLPsN1.59i',1759335614075544,NULL,'2025-10-01 16:20:14'),(3,3,NULL,0,'$2b$12$4AO4xcJC2UZqLivT6H31ruhrN4QHUQdObCCGbx4IWMLlSqbK0qlMm',1759335616801136,NULL,'2025-10-01 16:20:16'),(4,4,NULL,0,'$2b$12$EPGwf5IO2cUynoZbK8jVseZBKh9N0/eOA7xI4JG/e5F.gNXCf9/5C',1759335618870949,NULL,'2025-10-01 16:20:18'),(5,5,NULL,0,'$2b$12$OPT494xV3YyKbRoXyLPgrecyaJjPW.Oe3M92NYYIRC9OIZMglGtLa',1759335621911852,NULL,'2025-10-01 16:20:21'),(6,6,NULL,0,'$2b$12$DYZlhf5YmmmGCi2.ehyOmOxoU7dOIodsQuKglvahFeLQ0s1IDkR5q',1759335626826033,NULL,'2025-10-01 16:20:26'),(7,7,NULL,0,'$2b$12$z475xAHR5GpZ6csW3VEw3.G7xyUFw/j2k0SAhdX3s7NEjltFkf2HO',1759335633256896,NULL,'2025-10-01 16:20:33'),(8,8,NULL,0,'$2b$12$zgP2SYmaQ4Dh1B3DEbSc4OZlTI2OgvyZBS25VFKVWgyQa8OTmapWO',1759335636063174,NULL,'2025-10-01 16:20:36'),(9,9,NULL,0,'$2b$12$/opEX/1NtnLvaCK3/I5pC.XcJAo9aomL2amdSBh3jaVaO7mS6h4Cq',1759336581244928,NULL,'2025-10-01 16:36:21'),(10,10,NULL,0,'$2b$12$g4nwBWFLDsTtKWY7jQXL7O9OYwfo/3nGfCsMbISPAhd6Fa82jTFem',1759337728406024,NULL,'2025-10-01 16:55:28'),(11,11,NULL,0,'$2b$12$upRcxcnQQd2lmb6KghWy5.G3ioKvqKiBoP5gxxpuez6bWmXuLNvYu',1759337892392463,NULL,'2025-10-01 16:58:12'),(12,12,NULL,0,'$2b$12$xOUbbCBeLVcPpP2Y64TyfOTxfWdvFfsGdGRQhxdsWW..h4cNfNmai',1759337892894535,NULL,'2025-10-01 16:58:12');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('4e21223ccd944d679ecff96ac51b78f5','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0),('92de8884ad3248ec8c4c2392254b47dc','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('d71d1a0c80274beaa9fa95a28a8fe346','service','{}','service',1,'default','default',0),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1),('fc20e0a59557470e8cf5189ec2e95a2e','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=395 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (1,NULL,NULL,'68fccba4055e4b40af4e0a05bfaeba72',NULL,NULL,NULL,NULL,'2025-10-01 17:00:13',NULL,'2025-10-01 17:00:13',NULL,NULL),(2,NULL,'c2b5045116cf4e63a928f316dacead46',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:00:15',NULL,'2025-10-01 17:00:15',NULL,NULL),(3,NULL,NULL,'37c97230fa0448318b135f22b2b86a84',NULL,NULL,NULL,NULL,'2025-10-01 17:00:18',NULL,'2025-10-01 17:00:18',NULL,NULL),(4,NULL,'5f44a51eef344156ad0037990a657afe',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:00:20',NULL,'2025-10-01 17:00:20',NULL,NULL),(5,NULL,NULL,'af18463a414c41149e5d2d9fee691fd8',NULL,NULL,NULL,NULL,'2025-10-01 17:00:22',NULL,'2025-10-01 17:00:22',NULL,NULL),(6,NULL,'279167dd54004d6eaf5bb41a15724ca4',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:00:23',NULL,'2025-10-01 17:00:23',NULL,NULL),(7,NULL,NULL,'7768a3fd4f7141eb978db625843bd2f2',NULL,NULL,NULL,NULL,'2025-10-01 17:00:24',NULL,'2025-10-01 17:00:24',NULL,NULL),(8,NULL,NULL,'432be2a771b44c7e939e38ab66f34c71',NULL,NULL,NULL,NULL,'2025-10-01 17:00:25',NULL,'2025-10-01 17:00:25',NULL,NULL),(9,NULL,'3475477b4a1e4f819b3ff14720d2dc6d',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:00:26',NULL,'2025-10-01 17:00:26',NULL,NULL),(10,NULL,NULL,'d85d59876c6c458c8e07fcef2d79e11f',NULL,NULL,NULL,NULL,'2025-10-01 17:00:28',NULL,'2025-10-01 17:00:28',NULL,NULL),(11,NULL,NULL,'68a8d16ce46b4c8ea4b343166c9cab57',NULL,NULL,NULL,NULL,'2025-10-01 17:00:28',NULL,'2025-10-01 17:00:28',NULL,NULL),(12,NULL,NULL,'9a9acde81ed247abb3489b780e975188',NULL,NULL,NULL,NULL,'2025-10-01 17:00:28',NULL,'2025-10-01 17:00:28',NULL,NULL),(13,NULL,NULL,'795436ca4abe4e0e8da2ee3bc5b1dbda',NULL,NULL,NULL,NULL,'2025-10-01 17:00:28',NULL,'2025-10-01 17:00:28',NULL,NULL),(14,NULL,'a5c30f3eee10444f98a9d7ba91213c13',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:00:29',NULL,'2025-10-01 17:00:29',NULL,NULL),(15,NULL,'6badfdfbe2a045ddb89da25e4b9cf66c',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:00:30',NULL,'2025-10-01 17:00:30',NULL,NULL),(16,NULL,'5a045ee1aca840c1b06a87a19daaac31',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:00:30',NULL,'2025-10-01 17:00:30',NULL,NULL),(17,NULL,'85a428afb52742d3b601161e8821da9f',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:00:31',NULL,'2025-10-01 17:00:31',NULL,NULL),(18,NULL,NULL,'f97e04da15914c28b7da633c0639369b',NULL,NULL,NULL,NULL,'2025-10-01 17:00:32',NULL,'2025-10-01 17:00:32',NULL,NULL),(19,NULL,'9736f636afca442dbdc820772d7ee2cf',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:00:33',NULL,'2025-10-01 17:00:33',NULL,NULL),(20,NULL,NULL,'857e97b21393401d8a13c23da144568d',NULL,NULL,NULL,NULL,'2025-10-01 17:00:37',NULL,'2025-10-01 17:00:37',NULL,NULL),(21,NULL,'dadfee3239e247638485303aa489a012',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:00:38',NULL,'2025-10-01 17:00:38',NULL,NULL),(22,NULL,NULL,'5c2d071184a04b57979f0260c9b86c47',NULL,NULL,NULL,NULL,'2025-10-01 17:00:41',NULL,'2025-10-01 17:00:41',NULL,NULL),(23,NULL,NULL,'a3dea8f9044447e2872189b40599c9a2',NULL,NULL,NULL,NULL,'2025-10-01 17:00:45',NULL,'2025-10-01 17:00:45',NULL,NULL),(24,NULL,NULL,'2f018c6b54264c0c965f2279123bb2b8',NULL,NULL,NULL,NULL,'2025-10-01 17:00:45',NULL,'2025-10-01 17:00:45',NULL,NULL),(25,NULL,NULL,'df0b2d6216a142dc92cd2a29e14daf63',NULL,NULL,NULL,NULL,'2025-10-01 17:00:45',NULL,'2025-10-01 17:00:45',NULL,NULL),(26,NULL,NULL,'0c2a887dd4a845859f0669eb83fe675c',NULL,NULL,NULL,NULL,'2025-10-01 17:00:45',NULL,'2025-10-01 17:00:45',NULL,NULL),(27,NULL,'458670268592410a8e9d3b6e74657ef8',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:00:47',NULL,'2025-10-01 17:00:47',NULL,NULL),(28,NULL,'1f4a5d54519f4f46897a6eba8668a5c4',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:00:47',NULL,'2025-10-01 17:00:47',NULL,NULL),(29,NULL,'3b070cbc3e9f4af28b0758b866474914',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:00:47',NULL,'2025-10-01 17:00:47',NULL,NULL),(30,NULL,'80b644a7915946368cf9d0bb3b6ad7f4',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:00:48',NULL,'2025-10-01 17:00:48',NULL,NULL),(31,NULL,NULL,'aff16e38eefd4e66b0b620d67bc65d6e',NULL,NULL,NULL,NULL,'2025-10-01 17:00:49',NULL,'2025-10-01 17:00:49',NULL,NULL),(32,NULL,NULL,'ca467e8fca124733bcc5eeea87598415',NULL,NULL,NULL,NULL,'2025-10-01 17:00:50',NULL,'2025-10-01 17:00:50',NULL,NULL),(33,NULL,'efef7d21275549538c8a121a0599e3f4',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:00:50',NULL,'2025-10-01 17:00:50',NULL,NULL),(34,NULL,'695ecc4435ad4930b1485d49316799f2',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:00:51',NULL,'2025-10-01 17:00:51',NULL,NULL),(35,NULL,NULL,'9df5e8ec2ac8436b9b644cd1d934abae',NULL,NULL,NULL,NULL,'2025-10-01 17:00:53',NULL,'2025-10-01 17:00:53',NULL,NULL),(36,NULL,'75bc12d9d597457fa0078e98a93158cb',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:00:54',NULL,'2025-10-01 17:00:54',NULL,NULL),(37,NULL,NULL,'ab0bb68e7d54488ab7e6fb2db1628204',NULL,NULL,NULL,NULL,'2025-10-01 17:00:55',NULL,'2025-10-01 17:00:55',NULL,NULL),(38,NULL,'145646611246417d828b11de09ec4aa6',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:00:56',NULL,'2025-10-01 17:00:56',NULL,NULL),(39,NULL,NULL,'1aa196bfcf1c4f3ea851428962ef3537',NULL,NULL,NULL,NULL,'2025-10-01 17:00:58',NULL,'2025-10-01 17:00:58',NULL,NULL),(40,NULL,'3d13a24f7a894224bf628de0600bb279',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:00:59',NULL,'2025-10-01 17:00:59',NULL,NULL),(41,NULL,NULL,'788e5deebc354b55ad7d75286414a648',NULL,NULL,NULL,NULL,'2025-10-01 17:01:00',NULL,'2025-10-01 17:01:00',NULL,NULL),(42,NULL,'639c71c1337b42d28441f2ba0bed3a48',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:01:02',NULL,'2025-10-01 17:01:02',NULL,NULL),(43,NULL,NULL,'e009c0e230c844949c8cffcff0e4a364',NULL,NULL,NULL,NULL,'2025-10-01 17:01:04',NULL,'2025-10-01 17:01:04',NULL,NULL),(44,NULL,NULL,'9d181eb7360047fe9f9da2083f4ee89e',NULL,NULL,NULL,NULL,'2025-10-01 17:01:07',NULL,'2025-10-01 17:01:07',NULL,NULL),(45,NULL,NULL,'c1be58390bfe4d5eab68bc3a377e6486',NULL,NULL,NULL,NULL,'2025-10-01 17:01:07',NULL,'2025-10-01 17:01:07',NULL,NULL),(46,NULL,NULL,'6252cdf35d8a4fc389eb848261d7fe32',NULL,NULL,NULL,NULL,'2025-10-01 17:01:08',NULL,'2025-10-01 17:01:08',NULL,NULL),(47,NULL,NULL,'f79f600423c448578d2bc6d005a958df',NULL,NULL,NULL,NULL,'2025-10-01 17:01:08',NULL,'2025-10-01 17:01:08',NULL,NULL),(48,NULL,NULL,'71434392df47488584aa5a9d7f61d072',NULL,NULL,NULL,NULL,'2025-10-01 17:01:09',NULL,'2025-10-01 17:01:09',NULL,NULL),(49,NULL,'c4e8745452034ddba348d20a98e4572d',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:01:09',NULL,'2025-10-01 17:01:09',NULL,NULL),(50,NULL,NULL,'f957ca836e884fa9a876a7cb9b8cddd1',NULL,NULL,NULL,NULL,'2025-10-01 17:01:09',NULL,'2025-10-01 17:01:09',NULL,NULL),(51,NULL,NULL,'e013624a95e345818869614d1274de1b',NULL,NULL,NULL,NULL,'2025-10-01 17:01:09',NULL,'2025-10-01 17:01:09',NULL,NULL),(52,NULL,'57a031110ac84332a5b2338a71926a98',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:01:10',NULL,'2025-10-01 17:01:10',NULL,NULL),(53,NULL,'b07e4df865184e31a588924251802d8f',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:01:10',NULL,'2025-10-01 17:01:10',NULL,NULL),(54,NULL,'3b50b43474364652a994835c35c0d254',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:01:11',NULL,'2025-10-01 17:01:11',NULL,NULL),(55,NULL,'65bb0cb1011d4e238ac6bc8073e024c2',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:01:11',NULL,'2025-10-01 17:01:11',NULL,NULL),(56,NULL,'76cfa482e54f4f6d9cec649c247dce9a',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:01:12',NULL,'2025-10-01 17:01:12',NULL,NULL),(57,NULL,NULL,'3ebd98d2fd344e9690059fcf007b4d13',NULL,NULL,NULL,NULL,'2025-10-01 17:01:18',NULL,'2025-10-01 17:01:18',NULL,NULL),(58,NULL,NULL,'39dcddf14b7a42c1adb9b85235a21a4b',NULL,NULL,NULL,NULL,'2025-10-01 17:01:19',NULL,'2025-10-01 17:01:19',NULL,NULL),(59,NULL,NULL,'0c9a2b7a2a104381bc71bbd6352fb248',NULL,NULL,NULL,NULL,'2025-10-01 17:01:19',NULL,'2025-10-01 17:01:19',NULL,NULL),(60,NULL,NULL,'c152993685134b8cbf58c8f725253f13',NULL,NULL,NULL,NULL,'2025-10-01 17:01:19',NULL,'2025-10-01 17:01:19',NULL,NULL),(61,NULL,NULL,'675dc5e53691498a85efcdb811e5a848',NULL,NULL,NULL,NULL,'2025-10-01 17:01:20',NULL,'2025-10-01 17:01:20',NULL,NULL),(62,NULL,'ebe75cd46b3f49c6886f05450bd49977',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:01:21',NULL,'2025-10-01 17:01:21',NULL,NULL),(63,NULL,NULL,'afbf15b176594b999a50ea15bf84d237',NULL,NULL,NULL,NULL,'2025-10-01 17:01:21',NULL,'2025-10-01 17:01:21',NULL,NULL),(64,NULL,'fddf2e8f31614cd6afbfcdeff763553b',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:01:21',NULL,'2025-10-01 17:01:21',NULL,NULL),(65,NULL,'187921476265406e8a25392050a04f7d',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:01:22',NULL,'2025-10-01 17:01:22',NULL,NULL),(66,NULL,'c4ae009f89aa49ccadaaeed54f17efe5',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:01:22',NULL,'2025-10-01 17:01:22',NULL,NULL),(67,NULL,'9f36ca7a89904fa698c071df8d0d7823',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:01:22',NULL,'2025-10-01 17:01:22',NULL,NULL),(68,NULL,NULL,'18775df5cba54b9496e58f7832226368',NULL,NULL,NULL,NULL,'2025-10-01 17:01:28',NULL,'2025-10-01 17:01:28',NULL,NULL),(69,NULL,'c744f2682a224071abf19dec2f92a5a1',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:01:29',NULL,'2025-10-01 17:01:29',NULL,NULL),(70,NULL,NULL,'b6fe6aff620349d68d0c70d72f082c3e',NULL,NULL,NULL,NULL,'2025-10-01 17:01:31',NULL,'2025-10-01 17:01:31',NULL,NULL),(71,NULL,'aef6b349a1254f5d9f6fbf2eed0b9a82',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:01:32',NULL,'2025-10-01 17:01:32',NULL,NULL),(72,NULL,NULL,'ad01093c198e4a56a21e719bca3c1c99',NULL,NULL,NULL,NULL,'2025-10-01 17:01:35',NULL,'2025-10-01 17:01:35',NULL,NULL),(73,NULL,'3851664c4bd84bd1a017dff446d19e72',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:01:36',NULL,'2025-10-01 17:01:36',NULL,NULL),(74,NULL,NULL,'bc229f8c94a44b21a6d53a6133bb0323',NULL,NULL,NULL,NULL,'2025-10-01 17:01:37',NULL,'2025-10-01 17:01:37',NULL,NULL),(75,NULL,NULL,'5f41b86b9bfd46e293622504f0dcd57b',NULL,NULL,NULL,NULL,'2025-10-01 17:01:39',NULL,'2025-10-01 17:01:39',NULL,NULL),(76,NULL,'e0d548fb976f437db0740dce27e87e93',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:01:41',NULL,'2025-10-01 17:01:41',NULL,NULL),(77,NULL,NULL,'9d4e8e828d6f4539a6841cc33ded7fff',NULL,NULL,NULL,NULL,'2025-10-01 17:01:43',NULL,'2025-10-01 17:01:43',NULL,NULL),(78,NULL,NULL,'564d9fbe1bfc423bb8fa276e2b337a48',NULL,NULL,NULL,NULL,'2025-10-01 17:01:44',NULL,'2025-10-01 17:01:44',NULL,NULL),(79,NULL,NULL,'3ab57cba916c46739f6832018030305a',NULL,NULL,NULL,NULL,'2025-10-01 17:01:45',NULL,'2025-10-01 17:01:45',NULL,NULL),(80,NULL,'4339bc009e414765a393d06277578d2f',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:01:45',NULL,'2025-10-01 17:01:45',NULL,NULL),(81,NULL,NULL,'c7bd5ab094534136b1906389e4264c0b',NULL,NULL,NULL,NULL,'2025-10-01 17:01:45',NULL,'2025-10-01 17:01:45',NULL,NULL),(82,NULL,'756b231c8c724081bed78676d19a02ec',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:01:46',NULL,'2025-10-01 17:01:46',NULL,NULL),(83,NULL,NULL,'07aa5bd6b64f48e1a435d4a6e5ee19c8',NULL,NULL,NULL,NULL,'2025-10-01 17:01:47',NULL,'2025-10-01 17:01:47',NULL,NULL),(84,NULL,'5232375a7ee44459892cafa7ff522734',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:01:48',NULL,'2025-10-01 17:01:48',NULL,NULL),(85,NULL,'2dcb2001346f4c1da29277c4da439a7d',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:01:48',NULL,'2025-10-01 17:01:48',NULL,NULL),(86,NULL,'529bcabe400744b5af6f319ddbd212f2',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:01:49',NULL,'2025-10-01 17:01:49',NULL,NULL),(87,NULL,NULL,'fe47b8bc62ac405888417ad3b1ff8dc4',NULL,NULL,NULL,NULL,'2025-10-01 17:01:51',NULL,'2025-10-01 17:01:51',NULL,NULL),(88,NULL,'01891bb7dfbd4df498ce1746868d3937',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:01:53',NULL,'2025-10-01 17:01:53',NULL,NULL),(89,NULL,NULL,'f01d6292274540ac84c2c1da0ccbaedb',NULL,NULL,NULL,NULL,'2025-10-01 17:01:55',NULL,'2025-10-01 17:01:55',NULL,NULL),(90,NULL,'2204ae41373c4a57a26d8e752f9c9721',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:01:56',NULL,'2025-10-01 17:01:56',NULL,NULL),(91,NULL,NULL,'c6466ff6bfbe42fea4b5dd5ceae9a1ac',NULL,NULL,NULL,NULL,'2025-10-01 17:02:02',NULL,'2025-10-01 17:02:02',NULL,NULL),(92,NULL,NULL,'37cd3cf1f65a4baa91ed853f47c50231',NULL,NULL,NULL,NULL,'2025-10-01 17:02:02',NULL,'2025-10-01 17:02:02',NULL,NULL),(93,NULL,NULL,'6a15d40a45124535a83180d6272fd983',NULL,NULL,NULL,NULL,'2025-10-01 17:02:02',NULL,'2025-10-01 17:02:02',NULL,NULL),(94,NULL,NULL,'f5afcae71aac446f89997818d081932e',NULL,NULL,NULL,NULL,'2025-10-01 17:02:02',NULL,'2025-10-01 17:02:02',NULL,NULL),(95,NULL,'92976b2fb37646c8a5adb8a4b74ff6ed',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:02:05',NULL,'2025-10-01 17:02:05',NULL,NULL),(96,NULL,'ceb589eaa5b243fda8e2182e4a402811',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:02:06',NULL,'2025-10-01 17:02:06',NULL,NULL),(97,NULL,'bc1b5c0289d84d15828ef88f9edf1f72',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:02:07',NULL,'2025-10-01 17:02:07',NULL,NULL),(98,NULL,NULL,'0330a1c6d11e45b8a6e21e8e46c29677',NULL,NULL,NULL,NULL,'2025-10-01 17:02:15',NULL,'2025-10-01 17:02:15',NULL,NULL),(99,NULL,'0e7ac90f0c9f41cbb8e463ae95d18d81',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:02:16',NULL,'2025-10-01 17:02:16',NULL,NULL),(100,NULL,NULL,'518493a9f55543fd815b7a9417bd6076',NULL,NULL,NULL,NULL,'2025-10-01 17:02:17',NULL,'2025-10-01 17:02:17',NULL,NULL),(101,NULL,NULL,'b92b509d372144dd8cbe29e18bab1676',NULL,NULL,NULL,NULL,'2025-10-01 17:02:18',NULL,'2025-10-01 17:02:18',NULL,NULL),(102,NULL,NULL,'2979836575324d71b09c7801f18e275a',NULL,NULL,NULL,NULL,'2025-10-01 17:02:18',NULL,'2025-10-01 17:02:18',NULL,NULL),(103,NULL,NULL,'559501bf42ce4daab8b14ced6e0516c4',NULL,NULL,NULL,NULL,'2025-10-01 17:02:18',NULL,'2025-10-01 17:02:18',NULL,NULL),(104,NULL,NULL,'36ad6c15684e4d6ab7be8c28be58817a',NULL,NULL,NULL,NULL,'2025-10-01 17:02:19',NULL,'2025-10-01 17:02:19',NULL,NULL),(105,NULL,'e7862d18aeb143d49259310c073583be',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:02:19',NULL,'2025-10-01 17:02:19',NULL,NULL),(106,NULL,NULL,'e14d827a1ced4dcdb939a0c9219ae489',NULL,NULL,NULL,NULL,'2025-10-01 17:02:20',NULL,'2025-10-01 17:02:20',NULL,NULL),(107,NULL,'93237b12b0e749b49673feae4f2ca56f',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:02:20',NULL,'2025-10-01 17:02:20',NULL,NULL),(108,NULL,'7c51f0bcc0854a3dbd21a803893cab2e',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:02:21',NULL,'2025-10-01 17:02:21',NULL,NULL),(109,NULL,'4743342a50a447f89df320c01c1cbcc9',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:02:21',NULL,'2025-10-01 17:02:21',NULL,NULL),(110,NULL,NULL,'0bf1e0c75fb749d6a3f4e1d941f3d52c',NULL,NULL,NULL,NULL,'2025-10-01 17:02:28',NULL,'2025-10-01 17:02:28',NULL,NULL),(111,NULL,NULL,'7e72d1d688404571bf9d4b09d1c60b9d',NULL,NULL,NULL,NULL,'2025-10-01 17:02:28',NULL,'2025-10-01 17:02:28',NULL,NULL),(112,NULL,NULL,'ea1821978b91472190eb48dbc2127e63',NULL,NULL,NULL,NULL,'2025-10-01 17:02:28',NULL,'2025-10-01 17:02:28',NULL,NULL),(113,NULL,'d10cb690cc5e4d1a81023db746c83f50',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:02:30',NULL,'2025-10-01 17:02:30',NULL,NULL),(114,NULL,'b82ca4a47b704d7cb227220d014ec2b8',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:02:31',NULL,'2025-10-01 17:02:31',NULL,NULL),(115,NULL,NULL,'c18d05c377af4944b11a505e25d1740c',NULL,NULL,NULL,NULL,'2025-10-01 17:02:33',NULL,'2025-10-01 17:02:33',NULL,NULL),(116,NULL,'0146329fc8d749b394ed822844000f6d',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:02:33',NULL,'2025-10-01 17:02:33',NULL,NULL),(117,NULL,NULL,'80d2a1b42ca045d1a68209a92f15994d',NULL,NULL,NULL,NULL,'2025-10-01 17:02:36',NULL,'2025-10-01 17:02:36',NULL,NULL),(118,NULL,NULL,'78b086e847004b62afe5af39856fde36',NULL,NULL,NULL,NULL,'2025-10-01 17:02:37',NULL,'2025-10-01 17:02:37',NULL,NULL),(119,NULL,NULL,'74c02f1b2a524f26b572bd8b03f1843a',NULL,NULL,NULL,NULL,'2025-10-01 17:02:38',NULL,'2025-10-01 17:02:38',NULL,NULL),(120,NULL,'e337c5efe0ad4684a0bd1e44326c1337',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:02:38',NULL,'2025-10-01 17:02:38',NULL,NULL),(121,NULL,NULL,'0fc8d89ad29f495783c39738774ff7cd',NULL,NULL,NULL,NULL,'2025-10-01 17:02:38',NULL,'2025-10-01 17:02:38',NULL,NULL),(122,NULL,'c7d1942f9bcc4269bffefcd50f2767c6',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:02:40',NULL,'2025-10-01 17:02:40',NULL,NULL),(123,NULL,NULL,'7fc12e59084f436c91f593807589f9e8',NULL,NULL,NULL,NULL,'2025-10-01 17:02:40',NULL,'2025-10-01 17:02:40',NULL,NULL),(124,NULL,'0cf9bcaddb894769aa11a9db043e61b5',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:02:41',NULL,'2025-10-01 17:02:41',NULL,NULL),(125,NULL,'f49b6034bbe54eac9cfb682184f2dd93',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:02:43',NULL,'2025-10-01 17:02:43',NULL,NULL),(126,NULL,'d36f1681b7b349a5bf71bdac8eae5902',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:02:43',NULL,'2025-10-01 17:02:43',NULL,NULL),(127,NULL,NULL,'148249f30c6048fba1cf9a7a1c95e410',NULL,NULL,NULL,NULL,'2025-10-01 17:02:45',NULL,'2025-10-01 17:02:45',NULL,NULL),(128,NULL,'2508f30634354d9990b8270ad8a15c7f',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:02:47',NULL,'2025-10-01 17:02:47',NULL,NULL),(129,NULL,NULL,'300a60a0708a4bdc9ad4b55615bce0dc',NULL,NULL,NULL,NULL,'2025-10-01 17:02:48',NULL,'2025-10-01 17:02:48',NULL,NULL),(130,NULL,NULL,'7b7b6f82426848dc984e282a4a4ae2bb',NULL,NULL,NULL,NULL,'2025-10-01 17:02:50',NULL,'2025-10-01 17:02:50',NULL,NULL),(131,NULL,NULL,'fc49af266cfe4d59863aada4672aa662',NULL,NULL,NULL,NULL,'2025-10-01 17:02:50',NULL,'2025-10-01 17:02:50',NULL,NULL),(132,NULL,NULL,'32a880816fc64d17968ecefb6252ac17',NULL,NULL,NULL,NULL,'2025-10-01 17:02:50',NULL,'2025-10-01 17:02:50',NULL,NULL),(133,NULL,NULL,'f18feb453c53491c8bbb8a9d0f49ef12',NULL,NULL,NULL,NULL,'2025-10-01 17:02:50',NULL,'2025-10-01 17:02:50',NULL,NULL),(134,NULL,'f15311ab27ef411d82024fc6390e3f6d',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:02:52',NULL,'2025-10-01 17:02:52',NULL,NULL),(135,NULL,'c94187db343744088ee9bc7e394d1a24',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:02:53',NULL,'2025-10-01 17:02:53',NULL,NULL),(136,NULL,'11a5b7dc37254d8aafd35c0590d1f6ec',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:02:54',NULL,'2025-10-01 17:02:54',NULL,NULL),(137,NULL,NULL,'3dce165987c44fe28fc0096cce9ddb2b',NULL,NULL,NULL,NULL,'2025-10-01 17:02:54',NULL,'2025-10-01 17:02:54',NULL,NULL),(138,NULL,NULL,'75ea967e68254ee782e5bb30e32c5cd6',NULL,NULL,NULL,NULL,'2025-10-01 17:02:54',NULL,'2025-10-01 17:02:54',NULL,NULL),(139,NULL,NULL,'9f5e8f4bbf644fbeb1461eb0d47bf5f3',NULL,NULL,NULL,NULL,'2025-10-01 17:02:56',NULL,'2025-10-01 17:02:56',NULL,NULL),(140,NULL,'06efa1ba477e45208d5ba21e3e7c2703',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:02:57',NULL,'2025-10-01 17:02:57',NULL,NULL),(141,NULL,NULL,'193355ac44574a1e830e5f4cb2753d5d',NULL,NULL,NULL,NULL,'2025-10-01 17:02:58',NULL,'2025-10-01 17:02:58',NULL,NULL),(142,NULL,'970c44341f864243974aae42a8269155',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:02:58',NULL,'2025-10-01 17:02:58',NULL,NULL),(143,NULL,'46200aa1a3d249ce8c11feea182895f1',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:02:59',NULL,'2025-10-01 17:02:59',NULL,NULL),(144,NULL,'85fabbe1c0644f7eb600f681b70e71b5',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:03:00',NULL,'2025-10-01 17:03:00',NULL,NULL),(145,NULL,NULL,'c3e8659efcb745b6b49e65751ee8781f',NULL,NULL,NULL,NULL,'2025-10-01 17:03:02',NULL,'2025-10-01 17:03:02',NULL,NULL),(146,NULL,NULL,'ace96eaa2247411584c3dc71e0a31aec',NULL,NULL,NULL,NULL,'2025-10-01 17:03:02',NULL,'2025-10-01 17:03:02',NULL,NULL),(147,NULL,'2597cdbb2f4444bebdd4e4cd6f339a07',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:03:03',NULL,'2025-10-01 17:03:03',NULL,NULL),(148,NULL,'3a783b798490439ca667be2bfab5c0d9',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:03:03',NULL,'2025-10-01 17:03:03',NULL,NULL),(149,NULL,NULL,'5d42052fc66a4fdcb2b15b1dbd76c40d',NULL,NULL,NULL,NULL,'2025-10-01 17:03:08',NULL,'2025-10-01 17:03:08',NULL,NULL),(150,NULL,NULL,'cd8929702f0f4bd784a17d15887e90dd',NULL,NULL,NULL,NULL,'2025-10-01 17:03:08',NULL,'2025-10-01 17:03:08',NULL,NULL),(151,NULL,NULL,'4d7909c53a4249ad9067e08209a15e0a',NULL,NULL,NULL,NULL,'2025-10-01 17:03:08',NULL,'2025-10-01 17:03:08',NULL,NULL),(152,NULL,NULL,'1abf712d439c40a6a7af27e20d291ac1',NULL,NULL,NULL,NULL,'2025-10-01 17:03:08',NULL,'2025-10-01 17:03:08',NULL,NULL),(153,NULL,'7eeb0900b10d469eadf52437e1becb30',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:03:09',NULL,'2025-10-01 17:03:09',NULL,NULL),(154,NULL,'952021d59abb4fae827eeca1cd0821ac',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:03:10',NULL,'2025-10-01 17:03:10',NULL,NULL),(155,NULL,'61cd3d8b676940e5a07a15ffea736c1a',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:03:11',NULL,'2025-10-01 17:03:11',NULL,NULL),(156,NULL,NULL,'6d1711f06efc4ef6b78fef5b38b0dd6d',NULL,NULL,NULL,NULL,'2025-10-01 17:03:15',NULL,'2025-10-01 17:03:15',NULL,NULL),(157,NULL,NULL,'4a00322d3b8a40408084627599b3ac2c',NULL,NULL,NULL,NULL,'2025-10-01 17:03:15',NULL,'2025-10-01 17:03:15',NULL,NULL),(158,NULL,NULL,'d8e19cca5aa4424ea3616a74152cc30a',NULL,NULL,NULL,NULL,'2025-10-01 17:03:15',NULL,'2025-10-01 17:03:15',NULL,NULL),(159,NULL,NULL,'267ae173c45c4cc9a82e93cc07b95ab5',NULL,NULL,NULL,NULL,'2025-10-01 17:03:16',NULL,'2025-10-01 17:03:16',NULL,NULL),(160,NULL,'8b1f1acaa11844068cdc3fef2ff36927',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:03:17',NULL,'2025-10-01 17:03:17',NULL,NULL),(161,NULL,'45aa95d9d1db48b3a2509eb95a855adb',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:03:18',NULL,'2025-10-01 17:03:18',NULL,NULL),(162,NULL,'a2b9bc9ce296496f963cab9ed31ce26e',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:03:18',NULL,'2025-10-01 17:03:18',NULL,NULL),(163,NULL,NULL,'9067353b927842dbadd16dcb12f93b3d',NULL,NULL,NULL,NULL,'2025-10-01 17:03:25',NULL,'2025-10-01 17:03:25',NULL,NULL),(164,NULL,'a307fd4b882d45898ca085500fbf65b4',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:03:26',NULL,'2025-10-01 17:03:26',NULL,NULL),(165,NULL,NULL,'7e378c3c10674187b2040158399b4639',NULL,NULL,NULL,NULL,'2025-10-01 17:03:36',NULL,'2025-10-01 17:03:36',NULL,NULL),(166,NULL,NULL,'76eea8115d324be1a5ea0e97a79df9d8',NULL,NULL,NULL,NULL,'2025-10-01 17:03:37',NULL,'2025-10-01 17:03:37',NULL,NULL),(167,NULL,NULL,'d68a134fb2894956b0088cb7a9513af9',NULL,NULL,NULL,NULL,'2025-10-01 17:03:37',NULL,'2025-10-01 17:03:37',NULL,NULL),(168,NULL,NULL,'8d6d05b6af14439e914624888a0bc115',NULL,NULL,NULL,NULL,'2025-10-01 17:03:38',NULL,'2025-10-01 17:03:38',NULL,NULL),(169,NULL,NULL,'a685dbc107b84fb391b8d384374e4f76',NULL,NULL,NULL,NULL,'2025-10-01 17:03:38',NULL,'2025-10-01 17:03:38',NULL,NULL),(170,NULL,NULL,'5989c1a0322c4271ba669efdcbd9e0c7',NULL,NULL,NULL,NULL,'2025-10-01 17:03:38',NULL,'2025-10-01 17:03:38',NULL,NULL),(171,NULL,NULL,'b1ccf5e2177c454290ee71815d0669ae',NULL,NULL,NULL,NULL,'2025-10-01 17:03:38',NULL,'2025-10-01 17:03:38',NULL,NULL),(172,NULL,NULL,'84f8e3752e5f496aaefa6a4f72228b73',NULL,NULL,NULL,NULL,'2025-10-01 17:03:39',NULL,'2025-10-01 17:03:39',NULL,NULL),(173,NULL,'9bd13d2e911f47bd8088546be105109c',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:03:39',NULL,'2025-10-01 17:03:39',NULL,NULL),(174,NULL,'ea69928a550948da8bc33622ba2d80e2',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:03:40',NULL,'2025-10-01 17:03:40',NULL,NULL),(175,NULL,'3c98571bb56f43cab2b3f06f19982ff2',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:03:41',NULL,'2025-10-01 17:03:41',NULL,NULL),(176,NULL,'7b1e00c53169454580f740e6e2aa7938',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:03:41',NULL,'2025-10-01 17:03:41',NULL,NULL),(177,NULL,'01bc5d037e3c4524ae56d7d17d262d0d',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:03:41',NULL,'2025-10-01 17:03:41',NULL,NULL),(178,NULL,'87f228a9335c4b8aa7a218e59b8ff28d',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:03:42',NULL,'2025-10-01 17:03:42',NULL,NULL),(179,NULL,NULL,'b259fb2f386b4f95a5ea40bf88b00e3d',NULL,NULL,NULL,NULL,'2025-10-01 17:03:47',NULL,'2025-10-01 17:03:47',NULL,NULL),(180,NULL,NULL,'6cb72c6b4b99483db06dbef3558ce15e',NULL,NULL,NULL,NULL,'2025-10-01 17:03:47',NULL,'2025-10-01 17:03:47',NULL,NULL),(181,NULL,NULL,'ceaebad8327748198120b7ae72bd778b',NULL,NULL,NULL,NULL,'2025-10-01 17:03:47',NULL,'2025-10-01 17:03:47',NULL,NULL),(182,NULL,NULL,'672153c0270743a7aca812e6bc4b217e',NULL,NULL,NULL,NULL,'2025-10-01 17:03:48',NULL,'2025-10-01 17:03:48',NULL,NULL),(183,NULL,'a3aad027ade04563b004e51f89cab174',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:03:49',NULL,'2025-10-01 17:03:49',NULL,NULL),(184,NULL,NULL,'36a04d5b60a045018453ecc11012424f',NULL,NULL,NULL,NULL,'2025-10-01 17:03:50',NULL,'2025-10-01 17:03:50',NULL,NULL),(185,NULL,'540123caba3a4559986f2e1c8ba362b0',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:03:50',NULL,'2025-10-01 17:03:50',NULL,NULL),(186,NULL,NULL,'c09dbb0e26b54de6b5ba772109c45853',NULL,NULL,NULL,NULL,'2025-10-01 17:03:50',NULL,'2025-10-01 17:03:50',NULL,NULL),(187,NULL,NULL,'78909bf96e0d47dc97e54edcd723e963',NULL,NULL,NULL,NULL,'2025-10-01 17:03:50',NULL,'2025-10-01 17:03:50',NULL,NULL),(188,NULL,NULL,'0f06a6e5673247619315da306cb87b14',NULL,NULL,NULL,NULL,'2025-10-01 17:03:50',NULL,'2025-10-01 17:03:50',NULL,NULL),(189,NULL,'37383f5a9e4e4864a202da06ad1fdbc5',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:03:51',NULL,'2025-10-01 17:03:51',NULL,NULL),(190,NULL,'9d5ee9dab62a49d0915109819e0559e2',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:03:52',NULL,'2025-10-01 17:03:52',NULL,NULL),(191,NULL,'5996360ac7cf488083d20c8fdddd171e',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:03:53',NULL,'2025-10-01 17:03:53',NULL,NULL),(192,NULL,'ba644d06236b4f928b914648a014fefa',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:03:54',NULL,'2025-10-01 17:03:54',NULL,NULL),(193,NULL,NULL,'d70551727e3545b8896f975cb3bb388b',NULL,NULL,NULL,NULL,'2025-10-01 17:04:01',NULL,'2025-10-01 17:04:01',NULL,NULL),(194,NULL,NULL,'ed9c7605c9ba47fa826456bdb7485f23',NULL,NULL,NULL,NULL,'2025-10-01 17:04:02',NULL,'2025-10-01 17:04:02',NULL,NULL),(195,NULL,NULL,'c3147f467f954e73897d2e84f3fe5300',NULL,NULL,NULL,NULL,'2025-10-01 17:04:02',NULL,'2025-10-01 17:04:02',NULL,NULL),(196,NULL,NULL,'2243b683cb7e4f9dac1d6db6e466eedf',NULL,NULL,NULL,NULL,'2025-10-01 17:04:02',NULL,'2025-10-01 17:04:02',NULL,NULL),(197,NULL,'76020c94a59c417e8bed7e7ea0fbb3bf',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:04:04',NULL,'2025-10-01 17:04:04',NULL,NULL),(198,NULL,'e15acb661e3342ec9834de8d5a0c99c1',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:04:04',NULL,'2025-10-01 17:04:04',NULL,NULL),(199,NULL,'75a094f475934c518588a9d07ca89e99',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:04:06',NULL,'2025-10-01 17:04:06',NULL,NULL),(200,NULL,NULL,'b2685616371841959873dec890fa5385',NULL,NULL,NULL,NULL,'2025-10-01 17:04:12',NULL,'2025-10-01 17:04:12',NULL,NULL),(201,NULL,'5473075ec2e4439eadc201afc270390c',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:04:13',NULL,'2025-10-01 17:04:13',NULL,NULL),(202,NULL,NULL,'d3857a6623a949779e0c503efdf7b5ba',NULL,NULL,NULL,NULL,'2025-10-01 17:04:18',NULL,'2025-10-01 17:04:18',NULL,NULL),(203,NULL,NULL,'665905086fc748ccbd22b608ef064c5d',NULL,NULL,NULL,NULL,'2025-10-01 17:04:18',NULL,'2025-10-01 17:04:18',NULL,NULL),(204,NULL,NULL,'1785cf03c04a4b1982dfa3e70cad2fad',NULL,NULL,NULL,NULL,'2025-10-01 17:04:18',NULL,'2025-10-01 17:04:18',NULL,NULL),(205,NULL,NULL,'876ba11c269b4a50be9ab5ffcf21a0a2',NULL,NULL,NULL,NULL,'2025-10-01 17:04:19',NULL,'2025-10-01 17:04:19',NULL,NULL),(206,NULL,'e9065858b00240999eb59881a3308548',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:04:20',NULL,'2025-10-01 17:04:20',NULL,NULL),(207,NULL,'ac2c6932cc4d4ad2aac215004406c960',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:04:21',NULL,'2025-10-01 17:04:21',NULL,NULL),(208,NULL,NULL,'405e7f0fbb234477aa64965a42446d70',NULL,NULL,NULL,NULL,'2025-10-01 17:04:22',NULL,'2025-10-01 17:04:22',NULL,NULL),(209,NULL,NULL,'499139097b714ae9917adb1275ba7c8d',NULL,NULL,NULL,NULL,'2025-10-01 17:04:22',NULL,'2025-10-01 17:04:22',NULL,NULL),(210,NULL,'813885fb3d0d4b16bda7b87787dcbdf8',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:04:23',NULL,'2025-10-01 17:04:23',NULL,NULL),(211,NULL,NULL,'af1ecebdfb8240c8beb80560ee6a3888',NULL,NULL,NULL,NULL,'2025-10-01 17:04:26',NULL,'2025-10-01 17:04:26',NULL,NULL),(212,NULL,NULL,'0e5069509e1b4a3fba307dac6547b514',NULL,NULL,NULL,NULL,'2025-10-01 17:04:27',NULL,'2025-10-01 17:04:27',NULL,NULL),(213,NULL,NULL,'8912ba95908e45ac96f026820b569c0c',NULL,NULL,NULL,NULL,'2025-10-01 17:04:35',NULL,'2025-10-01 17:04:35',NULL,NULL),(214,NULL,NULL,'c81efae3d7fb4bb4a8d72cba2a092c43',NULL,NULL,NULL,NULL,'2025-10-01 17:04:35',NULL,'2025-10-01 17:04:35',NULL,NULL),(215,NULL,NULL,'3e51e90ff8394a918eb6c6407f63cb7a',NULL,NULL,NULL,NULL,'2025-10-01 17:04:39',NULL,'2025-10-01 17:04:39',NULL,NULL),(216,NULL,'d34130abdb3e47a3876b6c297a20fffb',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:04:39',NULL,'2025-10-01 17:04:39',NULL,NULL),(217,NULL,'a0ac8ec815504b8dae62c40a55008f52',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:04:40',NULL,'2025-10-01 17:04:40',NULL,NULL),(218,NULL,NULL,'af8da6febaae4dfe9de0fa747a5ef119',NULL,NULL,NULL,NULL,'2025-10-01 17:04:40',NULL,'2025-10-01 17:04:40',NULL,NULL),(219,NULL,NULL,'215059d06b1f437a84c98c525318fc71',NULL,NULL,NULL,NULL,'2025-10-01 17:04:40',NULL,'2025-10-01 17:04:40',NULL,NULL),(220,NULL,NULL,'c663e8073c5c4271ab2ce43e3f99f1b2',NULL,NULL,NULL,NULL,'2025-10-01 17:04:41',NULL,'2025-10-01 17:04:41',NULL,NULL),(221,NULL,'bc6d430e276a4224a2043bda6ff6d26d',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:04:42',NULL,'2025-10-01 17:04:42',NULL,NULL),(222,NULL,'d7270bd14938443caacbacdbd21d7c3b',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:04:43',NULL,'2025-10-01 17:04:43',NULL,NULL),(223,NULL,'493f6298a259455eb5393532d2f78a40',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:04:46',NULL,'2025-10-01 17:04:46',NULL,NULL),(224,NULL,'220545ce6f424d4187770842929567dc',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:04:46',NULL,'2025-10-01 17:04:46',NULL,NULL),(225,NULL,'4efb7e605e5b4d6e978a579c7b4bca94',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:04:48',NULL,'2025-10-01 17:04:48',NULL,NULL),(226,NULL,NULL,'63b4843f64be4ea993f1b91859d02657',NULL,NULL,NULL,NULL,'2025-10-01 17:05:17',NULL,'2025-10-01 17:05:17',NULL,NULL),(227,NULL,NULL,'d6dae67f198f483d86a85008b5959866',NULL,NULL,NULL,NULL,'2025-10-01 17:05:30',NULL,'2025-10-01 17:05:30',NULL,NULL),(228,NULL,NULL,'d0c0ffc90809482c8626b2e61d341f16',NULL,NULL,NULL,NULL,'2025-10-01 17:05:32',NULL,'2025-10-01 17:05:32',NULL,NULL),(229,NULL,'a1cd9e94225644748568dfbc4af1058a',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:05:32',NULL,'2025-10-01 17:05:32',NULL,NULL),(230,NULL,NULL,'54ba8996efb04657b725d27d5fed40ba',NULL,NULL,NULL,NULL,'2025-10-01 17:05:33',NULL,'2025-10-01 17:05:33',NULL,NULL),(231,NULL,NULL,'417411c54c8140bdb9220b2256b0ca04',NULL,NULL,NULL,NULL,'2025-10-01 17:05:33',NULL,'2025-10-01 17:05:33',NULL,NULL),(232,NULL,'321695f4f7e544d4b36cfa7241b8e946',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:05:35',NULL,'2025-10-01 17:05:35',NULL,NULL),(233,NULL,'142a9e3e18a94a7db810f3fa364db2c9',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:05:36',NULL,'2025-10-01 17:05:36',NULL,NULL),(234,NULL,'23b43441437342609cce9f7f9d4d5521',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:05:37',NULL,'2025-10-01 17:05:37',NULL,NULL),(235,NULL,NULL,'511030b152b446a699c3db8a50bdbf21',NULL,NULL,NULL,NULL,'2025-10-01 17:05:52',NULL,'2025-10-01 17:05:52',NULL,NULL),(236,NULL,NULL,'df02024b7253478a972cfb5e85481a06',NULL,NULL,NULL,NULL,'2025-10-01 17:06:00',NULL,'2025-10-01 17:06:00',NULL,NULL),(237,NULL,NULL,'09f29295317a46d6b8c0b29e6210e6f7',NULL,NULL,NULL,NULL,'2025-10-01 17:06:04',NULL,'2025-10-01 17:06:04',NULL,NULL),(238,NULL,NULL,'19c4c99985ad4779b3f653268adf001f',NULL,NULL,NULL,NULL,'2025-10-01 17:06:04',NULL,'2025-10-01 17:06:04',NULL,NULL),(239,NULL,NULL,'c30600f3e1b84a5f85934eee608f7eab',NULL,NULL,NULL,NULL,'2025-10-01 17:06:04',NULL,'2025-10-01 17:06:04',NULL,NULL),(240,NULL,'ad666ccc4f754e07a5041ffb5aaf32ae',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:05',NULL,'2025-10-01 17:06:05',NULL,NULL),(241,NULL,'9a80fcbd9c1246e7896e6846d9803fa4',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:06',NULL,'2025-10-01 17:06:06',NULL,NULL),(242,NULL,NULL,'bdbab5c8cbd84614a605693d09049109',NULL,NULL,NULL,NULL,'2025-10-01 17:06:06',NULL,'2025-10-01 17:06:06',NULL,NULL),(243,NULL,NULL,'5acd4d62fc8e4eeabaae2462d3c7a8fa',NULL,NULL,NULL,NULL,'2025-10-01 17:06:06',NULL,'2025-10-01 17:06:06',NULL,NULL),(244,NULL,NULL,'4f2737b9c59b4e6ab714f0a6de683f09',NULL,NULL,NULL,NULL,'2025-10-01 17:06:07',NULL,'2025-10-01 17:06:07',NULL,NULL),(245,NULL,'00f82d57a4854cec8cea8d6cb642dfc9',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:07',NULL,'2025-10-01 17:06:07',NULL,NULL),(246,NULL,'fb3120e923574f759bb16e2e2d603473',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:08',NULL,'2025-10-01 17:06:08',NULL,NULL),(247,NULL,'86a0062edb9a4a3293bf2e93012e4f13',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:08',NULL,'2025-10-01 17:06:08',NULL,NULL),(248,NULL,'0a07effcdf144e84839ce291a244bc9a',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:10',NULL,'2025-10-01 17:06:10',NULL,NULL),(249,NULL,NULL,'a179f3283a7c489188dd2ab208b7a489',NULL,NULL,NULL,NULL,'2025-10-01 17:06:12',NULL,'2025-10-01 17:06:12',NULL,NULL),(250,NULL,'a3aa9f6ceddc48c1b4afd62d8bbdef91',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:13',NULL,'2025-10-01 17:06:13',NULL,NULL),(251,NULL,NULL,'ab745f75e09a40cea1808368f82c0297',NULL,NULL,NULL,NULL,'2025-10-01 17:06:16',NULL,'2025-10-01 17:06:16',NULL,NULL),(252,NULL,NULL,'bbe9b26c815c44cb9bf87c8ab647d6f0',NULL,NULL,NULL,NULL,'2025-10-01 17:06:16',NULL,'2025-10-01 17:06:16',NULL,NULL),(253,NULL,'8b2c53e72b304ed58c7323214b5da098',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:17',NULL,'2025-10-01 17:06:17',NULL,NULL),(254,NULL,NULL,'04f5ceff16e74a1bb67c0b5ed79dce63',NULL,NULL,NULL,NULL,'2025-10-01 17:06:20',NULL,'2025-10-01 17:06:20',NULL,NULL),(255,NULL,NULL,'4f3e38f4f15e4b9b835f181280a9b9ac',NULL,NULL,NULL,NULL,'2025-10-01 17:06:20',NULL,'2025-10-01 17:06:20',NULL,NULL),(256,NULL,NULL,'7d3ee3e3b40b470f9b379baa8df39b29',NULL,NULL,NULL,NULL,'2025-10-01 17:06:20',NULL,'2025-10-01 17:06:20',NULL,NULL),(257,NULL,NULL,'a84c199209eb41a5a879f2fd2c4ec522',NULL,NULL,NULL,NULL,'2025-10-01 17:06:20',NULL,'2025-10-01 17:06:20',NULL,NULL),(258,NULL,NULL,'173ca489ed484f4d9628dc0a289d1dba',NULL,NULL,NULL,NULL,'2025-10-01 17:06:20',NULL,'2025-10-01 17:06:20',NULL,NULL),(259,NULL,'8c95d7d4c61e4a5bbe4dc2e0f6e03fd9',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:21',NULL,'2025-10-01 17:06:21',NULL,NULL),(260,NULL,'200675cc01534e47ab39ff1a40e697e7',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:22',NULL,'2025-10-01 17:06:22',NULL,NULL),(261,NULL,'7ad0536be5d74e8fb3ea6212befc359c',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:23',NULL,'2025-10-01 17:06:23',NULL,NULL),(262,NULL,NULL,'6ae885d77a5748a299ec5daaece928c1',NULL,NULL,NULL,NULL,'2025-10-01 17:06:25',NULL,'2025-10-01 17:06:25',NULL,NULL),(263,NULL,NULL,'aedb848f248447dda9e8a32913df0ef4',NULL,NULL,NULL,NULL,'2025-10-01 17:06:25',NULL,'2025-10-01 17:06:25',NULL,NULL),(264,NULL,NULL,'94ca99f3f1224658b37bc584cd99cf17',NULL,NULL,NULL,NULL,'2025-10-01 17:06:25',NULL,'2025-10-01 17:06:25',NULL,NULL),(265,NULL,NULL,'479a8213847341bc98ccc7947f810ef7',NULL,NULL,NULL,NULL,'2025-10-01 17:06:25',NULL,'2025-10-01 17:06:25',NULL,NULL),(266,NULL,'2b427e169d0f4bf4b0a9a88bc681bde7',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:26',NULL,'2025-10-01 17:06:26',NULL,NULL),(267,NULL,NULL,'b69c219101f84896b764936cded7e7a9',NULL,NULL,NULL,NULL,'2025-10-01 17:06:26',NULL,'2025-10-01 17:06:26',NULL,NULL),(268,NULL,'e12c9ccda80f4f609977560b9c50b6df',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:27',NULL,'2025-10-01 17:06:27',NULL,NULL),(269,NULL,NULL,'8945292d68314360add2298ae9496343',NULL,NULL,NULL,NULL,'2025-10-01 17:06:28',NULL,'2025-10-01 17:06:28',NULL,NULL),(270,NULL,'e674593677b648f488d4dec1a18da0b4',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:28',NULL,'2025-10-01 17:06:28',NULL,NULL),(271,NULL,NULL,'5a8c689bf73e4db7b827dd26f5816164',NULL,NULL,NULL,NULL,'2025-10-01 17:06:28',NULL,'2025-10-01 17:06:28',NULL,NULL),(272,NULL,NULL,'271dea99b7c3483498d18bd5188e352b',NULL,NULL,NULL,NULL,'2025-10-01 17:06:28',NULL,'2025-10-01 17:06:28',NULL,NULL),(273,NULL,NULL,'a4c4f16b7b7b42b5bed37f20bdbb1ade',NULL,NULL,NULL,NULL,'2025-10-01 17:06:29',NULL,'2025-10-01 17:06:29',NULL,NULL),(274,NULL,'1841221f332340a299707d253063659f',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:29',NULL,'2025-10-01 17:06:29',NULL,NULL),(275,NULL,'75a7f15d6a5e40ca947e6e1e3d139686',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:30',NULL,'2025-10-01 17:06:30',NULL,NULL),(276,NULL,'e16ddfb1536d4e6eab98cda995d4c1dc',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:31',NULL,'2025-10-01 17:06:31',NULL,NULL),(277,NULL,'89da7f149c6d414e94627e6e6c634ced',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:31',NULL,'2025-10-01 17:06:31',NULL,NULL),(278,NULL,NULL,'fd21124949da42eda789fac8f31b0935',NULL,NULL,NULL,NULL,'2025-10-01 17:06:32',NULL,'2025-10-01 17:06:32',NULL,NULL),(279,NULL,'612b31d02b794c3f9289bb35f7a3b4cd',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:32',NULL,'2025-10-01 17:06:32',NULL,NULL),(280,NULL,NULL,'d88e041e4eaa43388516c8fd4fec8ef5',NULL,NULL,NULL,NULL,'2025-10-01 17:06:34',NULL,'2025-10-01 17:06:34',NULL,NULL),(281,NULL,NULL,'c04f3603bf2c4d64a30783c8082a7dd1',NULL,NULL,NULL,NULL,'2025-10-01 17:06:34',NULL,'2025-10-01 17:06:34',NULL,NULL),(282,NULL,NULL,'63c8e84a71e54ddc86ad6b3d8faadde9',NULL,NULL,NULL,NULL,'2025-10-01 17:06:35',NULL,'2025-10-01 17:06:35',NULL,NULL),(283,NULL,NULL,'5d6cedb0656e41908577b7d8a29b0a97',NULL,NULL,NULL,NULL,'2025-10-01 17:06:35',NULL,'2025-10-01 17:06:35',NULL,NULL),(284,NULL,'6ae49bca545e4a36966b518c8a3f062a',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:37',NULL,'2025-10-01 17:06:37',NULL,NULL),(285,NULL,'c05db78bde5e475aa24b44c37583b382',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:38',NULL,'2025-10-01 17:06:38',NULL,NULL),(286,NULL,'b4fe6049d91e48c78e743eb1b991cb98',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:38',NULL,'2025-10-01 17:06:38',NULL,NULL),(287,NULL,NULL,'c0d8712c5da945d1ba492d2950f68d35',NULL,NULL,NULL,NULL,'2025-10-01 17:06:39',NULL,'2025-10-01 17:06:39',NULL,NULL),(288,NULL,NULL,'3572c7c2cffe41d38251a3c1a7076b90',NULL,NULL,NULL,NULL,'2025-10-01 17:06:39',NULL,'2025-10-01 17:06:39',NULL,NULL),(289,NULL,NULL,'ddcbc7cc5f94400198c42f04297f2f3b',NULL,NULL,NULL,NULL,'2025-10-01 17:06:40',NULL,'2025-10-01 17:06:40',NULL,NULL),(290,NULL,NULL,'ee81ef2193d94037b379c9da907fcd3d',NULL,NULL,NULL,NULL,'2025-10-01 17:06:40',NULL,'2025-10-01 17:06:40',NULL,NULL),(291,NULL,'40c3564ff57e4cfca7dd255e456bdcb2',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:41',NULL,'2025-10-01 17:06:41',NULL,NULL),(292,NULL,NULL,'7ac29778e4964b7798470672755fd998',NULL,NULL,NULL,NULL,'2025-10-01 17:06:41',NULL,'2025-10-01 17:06:41',NULL,NULL),(293,NULL,'474ce14ab62141b7bff365fe5a1e2c6c',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:42',NULL,'2025-10-01 17:06:42',NULL,NULL),(294,NULL,'f0decfacac5f4099a3f5eb577af8de17',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:42',NULL,'2025-10-01 17:06:42',NULL,NULL),(295,NULL,'d5f39e9828774cb39d706e290a8fc1dc',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:44',NULL,'2025-10-01 17:06:44',NULL,NULL),(296,NULL,NULL,'13c52b1d5b7048f4bf4952658e63fbac',NULL,NULL,NULL,NULL,'2025-10-01 17:06:45',NULL,'2025-10-01 17:06:45',NULL,NULL),(297,NULL,NULL,'0b783d940fb94fc2b1171161433cd60a',NULL,NULL,NULL,NULL,'2025-10-01 17:06:46',NULL,'2025-10-01 17:06:46',NULL,NULL),(298,NULL,NULL,'d7bf4662159e44cf868a4b9aabcb2904',NULL,NULL,NULL,NULL,'2025-10-01 17:06:46',NULL,'2025-10-01 17:06:46',NULL,NULL),(299,NULL,'1dd38e8e995543ea9f3667b44746e174',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:48',NULL,'2025-10-01 17:06:48',NULL,NULL),(300,NULL,NULL,'7f64c97f01d745219a4bd763f763f698',NULL,NULL,NULL,NULL,'2025-10-01 17:06:48',NULL,'2025-10-01 17:06:48',NULL,NULL),(301,NULL,'0bc40c8916a44ea982f6a65c70b07455',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:49',NULL,'2025-10-01 17:06:49',NULL,NULL),(302,NULL,'7b8bec1247f54479b803a9ec7e7655de',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:50',NULL,'2025-10-01 17:06:50',NULL,NULL),(303,NULL,'35930237cd2a46bb994acbd6888ff8fb',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:06:51',NULL,'2025-10-01 17:06:51',NULL,NULL),(304,NULL,NULL,'1cd31a49650c4d64bdac506fe579b766',NULL,NULL,NULL,NULL,'2025-10-01 17:07:00',NULL,'2025-10-01 17:07:00',NULL,NULL),(305,NULL,NULL,'38ae86a37a0b4939a6f90ce219165e47',NULL,NULL,NULL,NULL,'2025-10-01 17:07:01',NULL,'2025-10-01 17:07:01',NULL,NULL),(306,NULL,NULL,'5e50bca9e13941e8bd8bebfa9f3ce046',NULL,NULL,NULL,NULL,'2025-10-01 17:07:01',NULL,'2025-10-01 17:07:01',NULL,NULL),(307,NULL,NULL,'34a0469698104b738aa8b1a109d9032f',NULL,NULL,NULL,NULL,'2025-10-01 17:07:01',NULL,'2025-10-01 17:07:01',NULL,NULL),(308,NULL,'4b397f8953734945aad09b0945f6bb59',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:07:03',NULL,'2025-10-01 17:07:03',NULL,NULL),(309,NULL,'30cd3ce4e43d4122b839b6e5f4bf6511',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:07:05',NULL,'2025-10-01 17:07:05',NULL,NULL),(310,NULL,NULL,'6749f87606dd4f08a0576460396bfd30',NULL,NULL,NULL,NULL,'2025-10-01 17:07:05',NULL,'2025-10-01 17:07:05',NULL,NULL),(311,NULL,'05e6d683e5fc4b17b019d91e11d18cc5',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:07:05',NULL,'2025-10-01 17:07:05',NULL,NULL),(312,NULL,NULL,'037949b9900249a7955ff4d9bbc9b52b',NULL,NULL,NULL,NULL,'2025-10-01 17:07:11',NULL,'2025-10-01 17:07:11',NULL,NULL),(313,NULL,NULL,'26740e34b15544f1b21b2dd5632bb499',NULL,NULL,NULL,NULL,'2025-10-01 17:07:12',NULL,'2025-10-01 17:07:12',NULL,NULL),(314,NULL,NULL,'cfcbabc7ba3a4ffaaa1a8251697219d5',NULL,NULL,NULL,NULL,'2025-10-01 17:07:12',NULL,'2025-10-01 17:07:12',NULL,NULL),(315,NULL,NULL,'9eb8692d647c47729e04694e8aa6e8d2',NULL,NULL,NULL,NULL,'2025-10-01 17:07:12',NULL,'2025-10-01 17:07:12',NULL,NULL),(316,NULL,NULL,'fdec41847e24465299bb1f75d3e480d2',NULL,NULL,NULL,NULL,'2025-10-01 17:07:13',NULL,'2025-10-01 17:07:13',NULL,NULL),(317,NULL,NULL,'3cbeb636cca44d1e8eb6bea7fbb00106',NULL,NULL,NULL,NULL,'2025-10-01 17:07:13',NULL,'2025-10-01 17:07:13',NULL,NULL),(318,NULL,NULL,'5efd8d3b2614494ea1b2318f47c2f9a2',NULL,NULL,NULL,NULL,'2025-10-01 17:07:13',NULL,'2025-10-01 17:07:13',NULL,NULL),(319,NULL,'4d4bedd260ce4649a0f94da032f4f081',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:07:14',NULL,'2025-10-01 17:07:14',NULL,NULL),(320,NULL,'7697ecff3b5f413c99a5ace837dd6970',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:07:14',NULL,'2025-10-01 17:07:14',NULL,NULL),(321,NULL,'c876e4d730b546ddbbdcac41c0b7d6ee',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:07:15',NULL,'2025-10-01 17:07:15',NULL,NULL),(322,NULL,'d56760002957408b98d6e02018faf9f1',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:07:15',NULL,'2025-10-01 17:07:15',NULL,NULL),(323,NULL,'88393d3820ec459a8348b8d11288d55e',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:07:16',NULL,'2025-10-01 17:07:16',NULL,NULL),(324,NULL,'c04ac6d35d324385a61615bbc6d98977',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:07:17',NULL,'2025-10-01 17:07:17',NULL,NULL),(325,NULL,NULL,'fead8106301a48b099cc8b6ee62b40d7',NULL,NULL,NULL,NULL,'2025-10-01 17:07:23',NULL,'2025-10-01 17:07:23',NULL,NULL),(326,NULL,NULL,'f46e946745654defa37738eb157a5bb7',NULL,NULL,NULL,NULL,'2025-10-01 17:07:24',NULL,'2025-10-01 17:07:24',NULL,NULL),(327,NULL,NULL,'aafc72ff30234914804a949a432ca497',NULL,NULL,NULL,NULL,'2025-10-01 17:07:24',NULL,'2025-10-01 17:07:24',NULL,NULL),(328,NULL,NULL,'0bac97b2d5844b04aab89acbcbd45212',NULL,NULL,NULL,NULL,'2025-10-01 17:07:24',NULL,'2025-10-01 17:07:24',NULL,NULL),(329,NULL,'4161eb58353e491498db7d2f59f5027f',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:07:25',NULL,'2025-10-01 17:07:25',NULL,NULL),(330,NULL,'b495cc881bdd46aa9b1e2944818723ff',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:07:26',NULL,'2025-10-01 17:07:26',NULL,NULL),(331,NULL,'2a1c8bcc37f04566ae64e5d47a1b1f8e',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:07:27',NULL,'2025-10-01 17:07:27',NULL,NULL),(332,NULL,NULL,'39c61ac615a943d6820aa74f77ef2894',NULL,NULL,NULL,NULL,'2025-10-01 17:08:06',NULL,'2025-10-01 17:08:06',NULL,NULL),(333,NULL,NULL,'8395fbe4aa1a4d9bb181f7e321703f61',NULL,NULL,NULL,NULL,'2025-10-01 17:08:06',NULL,'2025-10-01 17:08:06',NULL,NULL),(334,NULL,NULL,'fd03429abc714edda14a41eca133d2ce',NULL,NULL,NULL,NULL,'2025-10-01 17:08:06',NULL,'2025-10-01 17:08:06',NULL,NULL),(335,NULL,NULL,'5c42f98686a442a1b0b1daccd60ee434',NULL,NULL,NULL,NULL,'2025-10-01 17:08:06',NULL,'2025-10-01 17:08:06',NULL,NULL),(336,NULL,'f63de858e3a74f88a78eaacea59850c5',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:08:08',NULL,'2025-10-01 17:08:08',NULL,NULL),(337,NULL,'d840f79c5037498c933acb023e044e49',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:08:11',NULL,'2025-10-01 17:08:11',NULL,NULL),(338,NULL,'a6e61eabf95a423b9f418918ae9b4971',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:08:13',NULL,'2025-10-01 17:08:13',NULL,NULL),(339,NULL,NULL,'711061d8d3254b2fa6b93be4c155f808',NULL,NULL,NULL,NULL,'2025-10-01 17:08:17',NULL,'2025-10-01 17:08:17',NULL,NULL),(340,NULL,NULL,'fcbf8552ba484efaa8cae2712992af80',NULL,NULL,NULL,NULL,'2025-10-01 17:08:18',NULL,'2025-10-01 17:08:18',NULL,NULL),(341,NULL,NULL,'c44858436b204ec9a54bce8c53e51ac0',NULL,NULL,NULL,NULL,'2025-10-01 17:08:18',NULL,'2025-10-01 17:08:18',NULL,NULL),(342,NULL,NULL,'dd9f18c22ac741ca92d4257d859236f4',NULL,NULL,NULL,NULL,'2025-10-01 17:08:19',NULL,'2025-10-01 17:08:19',NULL,NULL),(343,NULL,NULL,'3a2259ee6a834f7e9fce662a31b09458',NULL,NULL,NULL,NULL,'2025-10-01 17:08:20',NULL,'2025-10-01 17:08:20',NULL,NULL),(344,NULL,'3fa786165f634c0dbdbc6f660780ae4f',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:08:20',NULL,'2025-10-01 17:08:20',NULL,NULL),(345,NULL,NULL,'91ddd8da8f424927b61211570995ce5c',NULL,NULL,NULL,NULL,'2025-10-01 17:08:20',NULL,'2025-10-01 17:08:20',NULL,NULL),(346,NULL,NULL,'65611c98a08049888b60a753719589b5',NULL,NULL,NULL,NULL,'2025-10-01 17:08:20',NULL,'2025-10-01 17:08:20',NULL,NULL),(347,NULL,NULL,'4a4f2aaf99a849b1aab55f62e1882d35',NULL,NULL,NULL,NULL,'2025-10-01 17:08:20',NULL,'2025-10-01 17:08:20',NULL,NULL),(348,NULL,'384850ddb88c4d3798b3a3d365973ad0',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:08:20',NULL,'2025-10-01 17:08:20',NULL,NULL),(349,NULL,'8f932bdf23544dbab4a530baaa54351c',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:08:21',NULL,'2025-10-01 17:08:21',NULL,NULL),(350,NULL,'77bfd2f29370415aa4cead9c320fad51',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:08:22',NULL,'2025-10-01 17:08:22',NULL,NULL),(351,NULL,'f8f579ebcfb34350a380d2b7d2e89114',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:08:23',NULL,'2025-10-01 17:08:23',NULL,NULL),(352,NULL,'4109429279ba4716835310c4368a5846',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:08:24',NULL,'2025-10-01 17:08:24',NULL,NULL),(353,NULL,NULL,'ebb7809ba6ba4608938ca9de71ead919',NULL,NULL,NULL,NULL,'2025-10-01 17:08:25',NULL,'2025-10-01 17:08:25',NULL,NULL),(354,NULL,NULL,'d1d2438b79df420cb9a77f5822bc32da',NULL,NULL,NULL,NULL,'2025-10-01 17:08:32',NULL,'2025-10-01 17:08:32',NULL,NULL),(355,NULL,NULL,'0bd89a33373e459096c397bb0c77c7d4',NULL,NULL,NULL,NULL,'2025-10-01 17:08:32',NULL,'2025-10-01 17:08:32',NULL,NULL),(356,NULL,NULL,'0fb38d35d49e4f70a454c1e572290370',NULL,NULL,NULL,NULL,'2025-10-01 17:08:32',NULL,'2025-10-01 17:08:32',NULL,NULL),(357,NULL,NULL,'4854dfa526114bb7886b9365253bfe1f',NULL,NULL,NULL,NULL,'2025-10-01 17:08:33',NULL,'2025-10-01 17:08:33',NULL,NULL),(358,NULL,NULL,'e660ba5c7b304e2abc80f9b99bdd51af',NULL,NULL,NULL,NULL,'2025-10-01 17:08:34',NULL,'2025-10-01 17:08:34',NULL,NULL),(359,NULL,NULL,'e9d33879698e40ff8d4e9f861b4b08a6',NULL,NULL,NULL,NULL,'2025-10-01 17:08:35',NULL,'2025-10-01 17:08:35',NULL,NULL),(360,NULL,NULL,'9393e89295c54ae8b56ff895121f3ed0',NULL,NULL,NULL,NULL,'2025-10-01 17:08:35',NULL,'2025-10-01 17:08:35',NULL,NULL),(361,NULL,'4154bdba9d4e411cae22bb2f9134dc77',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:08:36',NULL,'2025-10-01 17:08:36',NULL,NULL),(362,NULL,'f8651f7a5bed4bf9a690f47a357f3583',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:08:37',NULL,'2025-10-01 17:08:37',NULL,NULL),(363,NULL,'c40766b9a0bd4055b437edefaf1b80e0',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:08:37',NULL,'2025-10-01 17:08:37',NULL,NULL),(364,NULL,'22e7abed695641eb93c9a14731025276',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:08:38',NULL,'2025-10-01 17:08:38',NULL,NULL),(365,NULL,'acc89f527f0547178bf5d59b5dc2bacf',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:08:38',NULL,'2025-10-01 17:08:38',NULL,NULL),(366,NULL,'29266081bf264ee18aad20d4882a428c',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:08:39',NULL,'2025-10-01 17:08:39',NULL,NULL),(367,NULL,NULL,'f37ee448462446659fbf83e88c5744d6',NULL,NULL,NULL,NULL,'2025-10-01 17:09:16',NULL,'2025-10-01 17:09:16',NULL,NULL),(368,NULL,NULL,'1bcf3990c34341488ff134d67569a00c',NULL,NULL,NULL,NULL,'2025-10-01 17:09:27',NULL,'2025-10-01 17:09:27',NULL,NULL),(369,NULL,NULL,'01a20f347f494c7aa5195b13814bde1a',NULL,NULL,NULL,NULL,'2025-10-01 17:09:27',NULL,'2025-10-01 17:09:27',NULL,NULL),(370,NULL,NULL,'17df114b3f8844cdaf77f5164036730a',NULL,NULL,NULL,NULL,'2025-10-01 17:09:27',NULL,'2025-10-01 17:09:27',NULL,NULL),(371,NULL,'a942627ec05749c09a975132ee6031d6',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:09:29',NULL,'2025-10-01 17:09:29',NULL,NULL),(372,NULL,'33dcce57e3a144ab924fd43618f1d535',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:09:30',NULL,'2025-10-01 17:09:30',NULL,NULL),(373,NULL,'a79dfecc555c4512ae09390afe275969',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:09:31',NULL,'2025-10-01 17:09:31',NULL,NULL),(374,NULL,NULL,'306e5ad3580e4d86a6891dc838895720',NULL,NULL,NULL,NULL,'2025-10-01 17:09:36',NULL,'2025-10-01 17:09:36',NULL,NULL),(375,NULL,NULL,'0aa9a60680634949b8cb62ee05ce82a0',NULL,NULL,NULL,NULL,'2025-10-01 17:09:44',NULL,'2025-10-01 17:09:44',NULL,NULL),(376,NULL,NULL,'c6801335b5594dc38e737626407c353c',NULL,NULL,NULL,NULL,'2025-10-01 17:09:50',NULL,'2025-10-01 17:09:50',NULL,NULL),(377,NULL,NULL,'3e6d135617ae46d0881a207dda746ae1',NULL,NULL,NULL,NULL,'2025-10-01 17:09:50',NULL,'2025-10-01 17:09:50',NULL,NULL),(378,NULL,NULL,'005157417b7b45ea9784e0618e940751',NULL,NULL,NULL,NULL,'2025-10-01 17:09:50',NULL,'2025-10-01 17:09:50',NULL,NULL),(379,NULL,NULL,'8535d97e92664479824a211407aa1fdc',NULL,NULL,NULL,NULL,'2025-10-01 17:09:51',NULL,'2025-10-01 17:09:51',NULL,NULL),(380,NULL,NULL,'6c141d4faa904b5cb205c49c6ffe1a16',NULL,NULL,NULL,NULL,'2025-10-01 17:09:51',NULL,'2025-10-01 17:09:51',NULL,NULL),(381,NULL,NULL,'903db411892b4baf879a19256b6c882a',NULL,NULL,NULL,NULL,'2025-10-01 17:09:51',NULL,'2025-10-01 17:09:51',NULL,NULL),(382,NULL,'c1cc701a1f854a6d82fee135022ccffd',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:09:52',NULL,'2025-10-01 17:09:52',NULL,NULL),(383,NULL,'de347de1118b411ebfd0f325ed505b5c',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:09:53',NULL,'2025-10-01 17:09:53',NULL,NULL),(384,NULL,'2d1156e4dd1a4bcf99d7af9680c3c563',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:09:53',NULL,'2025-10-01 17:09:53',NULL,NULL),(385,NULL,'33d19ced8e6446b2aa380bb59885feb1',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:09:54',NULL,'2025-10-01 17:09:54',NULL,NULL),(386,NULL,'08d5796b2ca248fda36bbace56cb2b5e',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:09:54',NULL,'2025-10-01 17:09:54',NULL,NULL),(387,NULL,'0103e60cf08a41ecb4737770562548a5',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:09:55',NULL,'2025-10-01 17:09:55',NULL,NULL),(388,NULL,NULL,'b77dc48fe9c84c488a34be054110c49d',NULL,NULL,NULL,NULL,'2025-10-01 17:10:07',NULL,'2025-10-01 17:10:07',NULL,NULL),(389,NULL,NULL,'7b4f3ac1db9d4257ad4205e53cd20033',NULL,NULL,NULL,NULL,'2025-10-01 17:10:14',NULL,'2025-10-01 17:10:14',NULL,NULL),(390,NULL,NULL,'784980e4677e44e393251041618abb31',NULL,NULL,NULL,NULL,'2025-10-01 17:10:14',NULL,'2025-10-01 17:10:14',NULL,NULL),(391,NULL,NULL,'1415419cfe4f43489cde9f4fc7aa1cfb',NULL,NULL,NULL,NULL,'2025-10-01 17:10:14',NULL,'2025-10-01 17:10:14',NULL,NULL),(392,NULL,'c3d5199d78da4dd98e40ba779c34c3ee',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:10:16',NULL,'2025-10-01 17:10:16',NULL,NULL),(393,NULL,'e168bce9fe04489288d3480d858b4158',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:10:17',NULL,'2025-10-01 17:10:17',NULL,NULL),(394,NULL,'2e342a65db494df4bf6bf288f6274207',NULL,NULL,NULL,NULL,NULL,'2025-10-01 17:10:18',NULL,'2025-10-01 17:10:18',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('49ba82507399441bac92440e3c1fab3a','member','{}','<<null>>',NULL),('6797d3b60fd744e398361ce41444b0b3','ResellerAdmin','{}','<<null>>',NULL),('8a68648697574401b53f564960fd61b3','service','{}','<<null>>',NULL),('91c7523f411b477e8a0bb4b31d04cbbe','swiftoperator','{}','<<null>>',NULL),('de14787aa646471b870c7a38d426f499','admin','{}','<<null>>',NULL),('e5625c9a9f9a460397271eaedd726eac','reader','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('49ba82507399441bac92440e3c1fab3a','IMMU','true'),('de14787aa646471b870c7a38d426f499','IMMU','true'),('e5625c9a9f9a460397271eaedd726eac','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('00d5d24e87684b5588acb93e1fe76116','sharev2',1,'{\"description\": \"Manila V2 Service\", \"name\": \"manilav2\"}'),('2ceda381770947c6843d0e4a0649e8cb','identity',1,'{\"name\": \"keystone\"}'),('43c9e2706c65471ca1e34bf302b45bcf','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('6c68618ad3314a56bfd5d8b69115c502','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}'),('7507713193b9408c8a05735ee7e9d372','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('75cb545e48b14961a17d5ccaae53ce5d','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}'),('899a890dfbd548029183dc732c564492','object-store',1,'{\"name\": \"swift\", \"description\": \"OpenStack Object Storage\"}'),('b1b284a1545c4d59b22e38fd89987e72','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('be08e452dc984d7d8f30be2a6a71b7a7','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}'),('ea2ac4606426449fb0b329c3ca405bb5','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('fdd1281862d14f339ef5cf59971ac7a3','share',1,'{\"description\": \"Manila V1 Service\", \"name\": \"manila\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','39c4052e56fa42f19855653f980c1235','system','de14787aa646471b870c7a38d426f499',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_expires` (`expires`),
  KEY `ix_token_trust_id` (`trust_id`),
  KEY `ix_token_user_id` (`user_id`),
  KEY `ix_token_expires_valid` (`expires`,`valid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('1e7cb4fd596344d3a28ba912440bb994','{}',1,'d71d1a0c80274beaa9fa95a28a8fe346','2025-10-01 16:20:17','2025-10-01','default'),('271b99e4429d4875abd7ec0f99939057','{\"tenantId\": \"4e21223ccd944d679ecff96ac51b78f5\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2025-10-01 16:58:13',NULL,'default'),('2a8b9f442cfe40c0ade56e5615df3f86','{}',1,'d71d1a0c80274beaa9fa95a28a8fe346','2025-10-01 16:20:27','2025-10-01','default'),('3170bc846d9740d4be0e3e873ca04a7a','{}',1,'d71d1a0c80274beaa9fa95a28a8fe346','2025-10-01 16:20:14',NULL,'default'),('39c4052e56fa42f19855653f980c1235','{}',1,NULL,'2025-10-01 16:19:04','2025-10-01','default'),('7cc625222d1440d2aaeef272e538fa9b','{}',1,'d71d1a0c80274beaa9fa95a28a8fe346','2025-10-01 16:55:28','2025-10-01','default'),('87e1344ec184480ea428441d78497712','{}',1,'d71d1a0c80274beaa9fa95a28a8fe346','2025-10-01 16:20:36','2025-10-01','default'),('afebc63b810b4e318f6f8d5ddaf76e2a','{}',1,'d71d1a0c80274beaa9fa95a28a8fe346','2025-10-01 16:20:33','2025-10-01','default'),('b3781d9cac084739bb2df1a4fbe2a6b3','{\"tenantId\": \"92de8884ad3248ec8c4c2392254b47dc\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2025-10-01 16:58:12',NULL,'default'),('b37ef411ccd643c78ba7ab709abbb2aa','{}',1,'d71d1a0c80274beaa9fa95a28a8fe346','2025-10-01 16:36:21',NULL,'default'),('d0552c4d46f047b8b2e18eaaf950be7d','{}',1,'d71d1a0c80274beaa9fa95a28a8fe346','2025-10-01 16:20:22','2025-10-01','default'),('deda12cecd7e4e0ba98c335b177911c4','{}',1,'d71d1a0c80274beaa9fa95a28a8fe346','2025-10-01 16:20:19','2025-10-01','default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `manila`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `manila` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `manila`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('aebe2a413e13');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `async_operation_data`
--

DROP TABLE IF EXISTS `async_operation_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `async_operation_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `async_operation_data`
--

LOCK TABLES `async_operation_data` WRITE;
/*!40000 ALTER TABLE `async_operation_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `async_operation_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `availability_zones`
--

DROP TABLE IF EXISTS `availability_zones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `availability_zones` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `az_name_uc` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `availability_zones`
--

LOCK TABLES `availability_zones` WRITE;
/*!40000 ALTER TABLE `availability_zones` DISABLE KEYS */;
INSERT INTO `availability_zones` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`) VALUES ('2025-10-01 16:55:31.519731',NULL,NULL,'False','2495df03-e710-42a7-9e3a-64fa89e58a2e','nova');
/*!40000 ALTER TABLE `availability_zones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backend_info`
--

DROP TABLE IF EXISTS `backend_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backend_info` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `host` varchar(255) NOT NULL,
  `info_hash` varchar(255) NOT NULL,
  PRIMARY KEY (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backend_info`
--

LOCK TABLES `backend_info` WRITE;
/*!40000 ALTER TABLE `backend_info` DISABLE KEYS */;
INSERT INTO `backend_info` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `host`, `info_hash`) VALUES ('2025-10-01 16:55:39.394249',NULL,NULL,0,'hostgroup@cephfs','e66c0dfc0d422efa26af62f5a81dd60603e2d39a');
/*!40000 ALTER TABLE `backend_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `drivers_private_data`
--

DROP TABLE IF EXISTS `drivers_private_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `drivers_private_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `drivers_private_data`
--

LOCK TABLES `drivers_private_data` WRITE;
/*!40000 ALTER TABLE `drivers_private_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `drivers_private_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(255) DEFAULT NULL,
  `resource_id` varchar(36) DEFAULT NULL,
  `action_id` varchar(10) NOT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
INSERT INTO `messages` (`id`, `project_id`, `request_id`, `resource_type`, `resource_id`, `action_id`, `detail_id`, `message_level`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `expires_at`) VALUES ('028d47aa-6b31-4ed8-adc1-a2a17138f45c','a1cd9e94225644748568dfbc4af1058a','req-c63509b9-ac78-4d32-b740-e53bdc1fda06','SHARE','82afcb55-ab13-400e-b95c-60fdd65c2ff7','001','008','ERROR','2025-10-01 17:04:52.443144',NULL,NULL,'False','2025-10-31 17:04:52'),('105ce787-fac0-49bb-bfee-d9b22aafeffb','f15311ab27ef411d82024fc6390e3f6d','req-81ae97b9-5c84-460f-a71f-705cd8a3e119','SHARE','dab13563-4d57-413d-bd06-6648b3c43113','001','008','ERROR','2025-10-01 17:02:39.928022',NULL,NULL,'False','2025-10-31 17:02:39'),('1b285712-0670-4a36-8603-6e059973465f','a1cd9e94225644748568dfbc4af1058a','req-2e80ce3c-ceae-4ff0-8c26-be9e2c74da94','SHARE','5fd34ab3-1557-4811-b421-fd2bdc80fe5c','001','008','ERROR','2025-10-01 17:05:13.992492',NULL,NULL,'False','2025-10-31 17:05:13'),('1d988980-3003-48e0-b0ab-b8c5284c7217','f15311ab27ef411d82024fc6390e3f6d','req-66a41164-dcd2-4783-a191-be18ed696c02','SHARE','9ec5bfe3-1c19-49c4-95ce-fa6b337dda04','001','008','ERROR','2025-10-01 17:02:44.094962',NULL,NULL,'False','2025-10-31 17:02:44'),('368bfbef-bc88-4bd6-8fe6-dda3533ff92d','a1cd9e94225644748568dfbc4af1058a','req-4b553e8a-46bd-4368-ae72-b1419a11842a','SHARE','47b52b31-2fc8-48a3-aa03-8f7b058143a9','001','008','ERROR','2025-10-01 17:04:48.132341',NULL,NULL,'False','2025-10-31 17:04:48'),('5109d5ec-044c-4ef1-ac09-dbea74c84b6b','f15311ab27ef411d82024fc6390e3f6d','req-416163ab-bee2-47d9-8be0-57fec1e827ef','SHARE','44260837-c979-44ee-a03a-ac05c7b8646a','001','008','ERROR','2025-10-01 17:02:35.833492',NULL,NULL,'False','2025-10-31 17:02:35'),('5d44a6e8-4713-442a-909c-07348c4c3d49','a1cd9e94225644748568dfbc4af1058a','req-880fa43c-60e8-408d-8932-54b3acffd2ee','SHARE','ec007ccb-27a7-4458-b286-526d906c9733','001','008','ERROR','2025-10-01 17:05:09.450180',NULL,NULL,'False','2025-10-31 17:05:09'),('6c782463-a615-422c-9c7d-c9263f787347','a1cd9e94225644748568dfbc4af1058a','req-413409f5-8110-4457-9b87-9657587ea126','SHARE','4fec8b23-dcb5-4ef4-9f12-9e9ccd47d8d5','001','008','ERROR','2025-10-01 17:05:22.528673',NULL,'2025-10-01 17:05:25.857547','6c782463-a615-422c-9c7d-c9263f787347','2025-10-31 17:05:22'),('763e5c9c-e798-45a4-9790-b55405f50b80','f15311ab27ef411d82024fc6390e3f6d','req-ad8a2912-a5cb-493a-84da-14250b000925','SHARE','cf0992a6-7788-4ae9-911d-8b443f293993','001','008','ERROR','2025-10-01 17:02:31.617881',NULL,NULL,'False','2025-10-31 17:02:31'),('bd4739c7-856a-41d8-8d1e-03366a9e4a3f','a1cd9e94225644748568dfbc4af1058a','req-c7cb5e36-9557-47e8-a503-ced305e431a4','SHARE','bcea9c48-c6b9-4586-b3e5-bae5a301e1f0','001','008','ERROR','2025-10-01 17:04:56.303586',NULL,NULL,'False','2025-10-31 17:04:56'),('c0ff1a20-f2ad-4fd4-802a-187dc04f6f68','a1cd9e94225644748568dfbc4af1058a','req-e0af7bbc-57c8-43db-b72b-61779ea43227','SHARE','bca3e7d0-34c7-4c18-ab69-45a419864f77','001','008','ERROR','2025-10-01 17:05:00.963880',NULL,NULL,'False','2025-10-31 17:05:00'),('c17dc441-426b-44d2-a739-6d8fef2ddad4','f15311ab27ef411d82024fc6390e3f6d','req-8304cca2-4b9b-4e5f-831e-10713e616446','SHARE','dc6e4ceb-a1a6-4e65-a0ea-9ff537eaa173','001','008','ERROR','2025-10-01 17:02:27.479171',NULL,NULL,'False','2025-10-31 17:02:27'),('d1b69d3d-2e45-43fc-a032-9cbbe68922a5','a1cd9e94225644748568dfbc4af1058a','req-79c9ec72-df6b-4751-a9c8-b3498e61932d','SHARE','2686dbe8-432c-4e15-94fc-e2c57311eadb','001','008','ERROR','2025-10-01 17:04:43.529985',NULL,'2025-10-01 17:04:46.761569','d1b69d3d-2e45-43fc-a032-9cbbe68922a5','2025-10-31 17:04:43'),('d3ee070a-beba-436c-93bc-7190adace836','a1cd9e94225644748568dfbc4af1058a','req-2e9e56d2-13b4-466c-bf07-5682b6b8465a','SHARE','3dcbb834-7746-46f2-a0a5-c2863b1199a5','001','008','ERROR','2025-10-01 17:05:17.628449',NULL,NULL,'False','2025-10-31 17:05:17'),('d474bc95-526a-4d9b-95ec-3c7b785e0d8e','a1cd9e94225644748568dfbc4af1058a','req-6ba76db5-31c4-4704-a424-a8ebbddf3e1f','SHARE','a7ee0331-e686-4283-9719-930d79c77201','001','008','ERROR','2025-10-01 17:05:05.776764',NULL,NULL,'False','2025-10-31 17:05:05'),('f9bfcf4a-c1fb-448f-bce6-f9cdb25b577c','86a0062edb9a4a3293bf2e93012e4f13','req-447f50c9-0ea7-4dde-b6b7-1a0cb053e581','SHARE','7b1893fd-a87d-4134-86a0-88945c063bc6','010','020','ERROR','2025-10-01 17:05:33.466429',NULL,NULL,'False','2025-10-31 17:05:33');
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `network_allocations`
--

DROP TABLE IF EXISTS `network_allocations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `network_allocations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ip_address` varchar(64) DEFAULT NULL,
  `mac_address` varchar(32) DEFAULT NULL,
  `share_server_id` varchar(36) NOT NULL,
  `label` varchar(255) DEFAULT 'user',
  `network_type` varchar(32) DEFAULT NULL,
  `segmentation_id` int(11) DEFAULT NULL,
  `ip_version` int(11) DEFAULT NULL,
  `cidr` varchar(64) DEFAULT NULL,
  `gateway` varchar(64) DEFAULT NULL,
  `mtu` int(11) DEFAULT NULL,
  `share_network_subnet_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_server_id` (`share_server_id`),
  KEY `fk_network_allocation_subnet_id_share_network_subnets` (`share_network_subnet_id`),
  CONSTRAINT `fk_network_allocation_subnet_id_share_network_subnets` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`),
  CONSTRAINT `network_allocations_ibfk_1` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `network_allocations`
--

LOCK TABLES `network_allocations` WRITE;
/*!40000 ALTER TABLE `network_allocations` DISABLE KEYS */;
/*!40000 ALTER TABLE `network_allocations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_share_type_quotas`
--

DROP TABLE IF EXISTS `project_share_type_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_share_type_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uc_quotas_per_share_types` (`share_type_id`,`resource`,`deleted`,`project_id`),
  CONSTRAINT `share_type_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_share_type_quotas`
--

LOCK TABLES `project_share_type_quotas` WRITE;
/*!40000 ALTER TABLE `project_share_type_quotas` DISABLE KEYS */;
INSERT INTO `project_share_type_quotas` (`id`, `project_id`, `resource`, `hard_limit`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `share_type_id`) VALUES (1,'a307fd4b882d45898ca085500fbf65b4','shares',2,'2025-10-01 17:02:50.959311',NULL,'2025-10-01 17:03:24.777617',1,'f75be615-3c48-49cc-844c-502b209bf197'),(2,'a307fd4b882d45898ca085500fbf65b4','gigabytes',4,'2025-10-01 17:02:50.976565',NULL,'2025-10-01 17:03:24.777617',2,'f75be615-3c48-49cc-844c-502b209bf197'),(3,'a307fd4b882d45898ca085500fbf65b4','shares',2,'2025-10-01 17:02:51.120556',NULL,'2025-10-01 17:03:24.538870',3,'2324d49d-b8b2-4a6a-82f9-af40a075e8cc'),(4,'a307fd4b882d45898ca085500fbf65b4','gigabytes',4,'2025-10-01 17:02:51.179836',NULL,'2025-10-01 17:03:24.538870',4,'2324d49d-b8b2-4a6a-82f9-af40a075e8cc'),(5,'a307fd4b882d45898ca085500fbf65b4','shares',53,'2025-10-01 17:03:09.160154',NULL,'2025-10-01 17:03:09.253243',5,'10518bc6-daa5-426d-8b9b-bea60fd26e94'),(6,'a307fd4b882d45898ca085500fbf65b4','snapshots',53,'2025-10-01 17:03:09.167093',NULL,'2025-10-01 17:03:09.253243',6,'10518bc6-daa5-426d-8b9b-bea60fd26e94'),(7,'a307fd4b882d45898ca085500fbf65b4','gigabytes',1003,'2025-10-01 17:03:09.172926',NULL,'2025-10-01 17:03:09.253243',7,'10518bc6-daa5-426d-8b9b-bea60fd26e94'),(8,'a307fd4b882d45898ca085500fbf65b4','snapshot_gigabytes',1003,'2025-10-01 17:03:09.178253',NULL,'2025-10-01 17:03:09.253243',8,'10518bc6-daa5-426d-8b9b-bea60fd26e94'),(9,'a307fd4b882d45898ca085500fbf65b4','share_replicas',103,'2025-10-01 17:03:09.182823',NULL,'2025-10-01 17:03:09.253243',9,'10518bc6-daa5-426d-8b9b-bea60fd26e94'),(10,'a307fd4b882d45898ca085500fbf65b4','replica_gigabytes',1003,'2025-10-01 17:03:09.187431',NULL,'2025-10-01 17:03:09.253243',10,'10518bc6-daa5-426d-8b9b-bea60fd26e94'),(11,'a307fd4b882d45898ca085500fbf65b4','shares',53,'2025-10-01 17:03:09.854761',NULL,'2025-10-01 17:03:10.030814',11,'f5ad5227-c6e8-40fa-bc1a-78dc60435009'),(12,'a307fd4b882d45898ca085500fbf65b4','snapshots',53,'2025-10-01 17:03:09.860152',NULL,'2025-10-01 17:03:10.030814',12,'f5ad5227-c6e8-40fa-bc1a-78dc60435009'),(13,'a307fd4b882d45898ca085500fbf65b4','gigabytes',1003,'2025-10-01 17:03:09.865487',NULL,'2025-10-01 17:03:10.030814',13,'f5ad5227-c6e8-40fa-bc1a-78dc60435009'),(14,'a307fd4b882d45898ca085500fbf65b4','snapshot_gigabytes',1003,'2025-10-01 17:03:09.870418',NULL,'2025-10-01 17:03:10.030814',14,'f5ad5227-c6e8-40fa-bc1a-78dc60435009'),(15,'a307fd4b882d45898ca085500fbf65b4','share_replicas',103,'2025-10-01 17:03:09.875612',NULL,'2025-10-01 17:03:10.030814',15,'f5ad5227-c6e8-40fa-bc1a-78dc60435009'),(16,'a307fd4b882d45898ca085500fbf65b4','replica_gigabytes',1003,'2025-10-01 17:03:09.880712',NULL,'2025-10-01 17:03:10.030814',16,'f5ad5227-c6e8-40fa-bc1a-78dc60435009'),(17,'a307fd4b882d45898ca085500fbf65b4','shares',12,'2025-10-01 17:03:10.995201',NULL,'2025-10-01 17:03:24.029847',17,'1e8b23c3-fec4-481f-bca8-785b91ecd471'),(18,'a307fd4b882d45898ca085500fbf65b4','shares',49,'2025-10-01 17:03:15.631421',NULL,'2025-10-01 17:03:23.891978',18,'adb48059-bd3b-4a73-9615-acd31e4e1de5'),(19,'a307fd4b882d45898ca085500fbf65b4','gigabytes',999,'2025-10-01 17:03:15.834106',NULL,'2025-10-01 17:03:23.891978',19,'adb48059-bd3b-4a73-9615-acd31e4e1de5'),(20,'a307fd4b882d45898ca085500fbf65b4','snapshots',49,'2025-10-01 17:03:16.017643',NULL,'2025-10-01 17:03:23.891978',20,'adb48059-bd3b-4a73-9615-acd31e4e1de5'),(21,'a307fd4b882d45898ca085500fbf65b4','snapshot_gigabytes',999,'2025-10-01 17:03:16.207160',NULL,'2025-10-01 17:03:23.891978',21,'adb48059-bd3b-4a73-9615-acd31e4e1de5'),(22,'a307fd4b882d45898ca085500fbf65b4','share_replicas',99,'2025-10-01 17:03:16.423548',NULL,'2025-10-01 17:03:23.891978',22,'adb48059-bd3b-4a73-9615-acd31e4e1de5'),(23,'a307fd4b882d45898ca085500fbf65b4','replica_gigabytes',999,'2025-10-01 17:03:16.592316',NULL,'2025-10-01 17:03:23.891978',23,'adb48059-bd3b-4a73-9615-acd31e4e1de5'),(24,'a307fd4b882d45898ca085500fbf65b4','shares',49,'2025-10-01 17:03:16.950528',NULL,'2025-10-01 17:03:23.687158',24,'69275896-415f-46f0-96b3-9e732a8063e5'),(25,'a307fd4b882d45898ca085500fbf65b4','gigabytes',999,'2025-10-01 17:03:17.141864',NULL,'2025-10-01 17:03:23.687158',25,'69275896-415f-46f0-96b3-9e732a8063e5'),(26,'a307fd4b882d45898ca085500fbf65b4','snapshots',49,'2025-10-01 17:03:17.252727',NULL,'2025-10-01 17:03:23.687158',26,'69275896-415f-46f0-96b3-9e732a8063e5'),(27,'a307fd4b882d45898ca085500fbf65b4','snapshot_gigabytes',999,'2025-10-01 17:03:17.390257',NULL,'2025-10-01 17:03:23.687158',27,'69275896-415f-46f0-96b3-9e732a8063e5'),(28,'a307fd4b882d45898ca085500fbf65b4','share_replicas',99,'2025-10-01 17:03:17.631527',NULL,'2025-10-01 17:03:23.687158',28,'69275896-415f-46f0-96b3-9e732a8063e5'),(29,'a307fd4b882d45898ca085500fbf65b4','replica_gigabytes',999,'2025-10-01 17:03:17.736631',NULL,'2025-10-01 17:03:23.687158',29,'69275896-415f-46f0-96b3-9e732a8063e5'),(30,'a307fd4b882d45898ca085500fbf65b4','shares',11,'2025-10-01 17:03:18.101487',NULL,'2025-10-01 17:03:23.535653',30,'6e216c3a-8c2a-4f53-b63e-836538e9b658'),(31,'a307fd4b882d45898ca085500fbf65b4','shares',-1,'2025-10-01 17:03:18.572644',NULL,'2025-10-01 17:03:23.341121',31,'ab8dfc02-86b2-47ba-a5c9-2f5c2387b26e');
/*!40000 ALTER TABLE `project_share_type_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_user_quotas`
--

DROP TABLE IF EXISTS `project_user_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_user_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `resource` varchar(25) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_user_quotas`
--

LOCK TABLES `project_user_quotas` WRITE;
/*!40000 ALTER TABLE `project_user_quotas` DISABLE KEYS */;
INSERT INTO `project_user_quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `user_id`, `project_id`, `resource`, `hard_limit`) VALUES (1,'2025-10-01 17:02:50.740625',NULL,'2025-10-01 17:03:08.425268',1,'9067353b927842dbadd16dcb12f93b3d','a307fd4b882d45898ca085500fbf65b4','shares',2),(2,'2025-10-01 17:02:50.750488',NULL,'2025-10-01 17:03:08.425268',2,'9067353b927842dbadd16dcb12f93b3d','a307fd4b882d45898ca085500fbf65b4','gigabytes',7),(3,'2025-10-01 17:03:10.901128',NULL,'2025-10-01 17:03:11.142447',3,'9067353b927842dbadd16dcb12f93b3d','a307fd4b882d45898ca085500fbf65b4','shares',11),(4,'2025-10-01 17:03:13.447566',NULL,'2025-10-01 17:03:13.647763',4,'9067353b927842dbadd16dcb12f93b3d','a307fd4b882d45898ca085500fbf65b4','gigabytes',-1),(5,'2025-10-01 17:03:13.734893',NULL,'2025-10-01 17:03:13.901325',5,'9067353b927842dbadd16dcb12f93b3d','a307fd4b882d45898ca085500fbf65b4','share_replicas',-1),(6,'2025-10-01 17:03:14.076886',NULL,'2025-10-01 17:03:14.207103',6,'9067353b927842dbadd16dcb12f93b3d','a307fd4b882d45898ca085500fbf65b4','replica_gigabytes',-1),(7,'2025-10-01 17:03:14.295727',NULL,'2025-10-01 17:03:14.507967',7,'9067353b927842dbadd16dcb12f93b3d','a307fd4b882d45898ca085500fbf65b4','share_networks',-1),(8,'2025-10-01 17:03:14.708593',NULL,'2025-10-01 17:03:14.843663',8,'9067353b927842dbadd16dcb12f93b3d','a307fd4b882d45898ca085500fbf65b4','shares',-1),(9,'2025-10-01 17:03:14.962867',NULL,'2025-10-01 17:03:15.081315',9,'9067353b927842dbadd16dcb12f93b3d','a307fd4b882d45898ca085500fbf65b4','snapshot_gigabytes',-1),(10,'2025-10-01 17:03:15.163901',NULL,'2025-10-01 17:03:15.305233',10,'9067353b927842dbadd16dcb12f93b3d','a307fd4b882d45898ca085500fbf65b4','snapshots',-1),(11,'2025-10-01 17:03:20.015771',NULL,'2025-10-01 17:03:20.113397',11,'9067353b927842dbadd16dcb12f93b3d','a307fd4b882d45898ca085500fbf65b4','gigabytes',999),(12,'2025-10-01 17:03:20.537162',NULL,'2025-10-01 17:03:20.590719',12,'9067353b927842dbadd16dcb12f93b3d','a307fd4b882d45898ca085500fbf65b4','share_replicas',99),(13,'2025-10-01 17:03:21.027626',NULL,'2025-10-01 17:03:21.099635',13,'9067353b927842dbadd16dcb12f93b3d','a307fd4b882d45898ca085500fbf65b4','replica_gigabytes',999),(14,'2025-10-01 17:03:21.448512',NULL,'2025-10-01 17:03:21.536479',14,'9067353b927842dbadd16dcb12f93b3d','a307fd4b882d45898ca085500fbf65b4','share_networks',9),(15,'2025-10-01 17:03:21.777775',NULL,'2025-10-01 17:03:21.835936',15,'9067353b927842dbadd16dcb12f93b3d','a307fd4b882d45898ca085500fbf65b4','shares',49),(16,'2025-10-01 17:03:22.008857',NULL,'2025-10-01 17:03:22.063584',16,'9067353b927842dbadd16dcb12f93b3d','a307fd4b882d45898ca085500fbf65b4','snapshot_gigabytes',999),(17,'2025-10-01 17:03:22.385330',NULL,'2025-10-01 17:03:22.469298',17,'9067353b927842dbadd16dcb12f93b3d','a307fd4b882d45898ca085500fbf65b4','snapshots',49),(18,'2025-10-01 17:03:22.669400',NULL,'2025-10-01 17:03:22.758527',18,'9067353b927842dbadd16dcb12f93b3d','a307fd4b882d45898ca085500fbf65b4','shares',11),(19,'2025-10-01 17:03:23.004787',NULL,'2025-10-01 17:03:23.077542',19,'9067353b927842dbadd16dcb12f93b3d','a307fd4b882d45898ca085500fbf65b4','shares',-1);
/*!40000 ALTER TABLE `project_user_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_usages_project_id` (`project_id`)
) ENGINE=InnoDB AUTO_INCREMENT=270 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `share_type_id`) VALUES ('2025-10-01 17:00:13.483100','2025-10-01 17:01:51.021975',NULL,0,1,'f01d6292274540ac84c2c1da0ccbaedb','2204ae41373c4a57a26d8e752f9c9721','gigabytes',0,0,NULL,NULL),('2025-10-01 17:00:13.487947','2025-10-01 17:01:51.021979',NULL,0,2,'f01d6292274540ac84c2c1da0ccbaedb','2204ae41373c4a57a26d8e752f9c9721','shares',0,0,NULL,NULL),('2025-10-01 17:00:13.549619','2025-10-01 17:01:51.021980','2025-10-01 17:01:54.554208',3,3,NULL,'2204ae41373c4a57a26d8e752f9c9721','gigabytes',0,0,NULL,'8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:00:13.552621','2025-10-01 17:01:51.021982','2025-10-01 17:01:54.554208',4,4,NULL,'2204ae41373c4a57a26d8e752f9c9721','shares',0,0,NULL,'8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:00:13.889359','2025-10-01 17:00:14.095341','2025-10-01 17:00:15.244219',5,5,'0c2a887dd4a845859f0669eb83fe675c','1f4a5d54519f4f46897a6eba8668a5c4','shares',1,0,NULL,NULL),('2025-10-01 17:00:13.893039','2025-10-01 17:00:14.095346','2025-10-01 17:00:15.244219',6,6,'0c2a887dd4a845859f0669eb83fe675c','1f4a5d54519f4f46897a6eba8668a5c4','gigabytes',1,0,NULL,NULL),('2025-10-01 17:00:13.947874','2025-10-01 17:00:14.095347','2025-10-01 17:00:15.244219',7,7,NULL,'1f4a5d54519f4f46897a6eba8668a5c4','shares',1,0,NULL,'eeda9f95-f5c3-4f07-b12e-0b18f7c8da37'),('2025-10-01 17:00:13.950854','2025-10-01 17:00:14.095348','2025-10-01 17:00:15.244219',8,8,NULL,'1f4a5d54519f4f46897a6eba8668a5c4','gigabytes',1,0,NULL,'eeda9f95-f5c3-4f07-b12e-0b18f7c8da37'),('2025-10-01 17:00:15.542977','2025-10-01 17:00:16.167395','2025-10-01 17:00:23.781093',9,9,'0c2a887dd4a845859f0669eb83fe675c','1f4a5d54519f4f46897a6eba8668a5c4','gigabytes',2,0,NULL,NULL),('2025-10-01 17:00:15.548475','2025-10-01 17:00:16.167401','2025-10-01 17:00:23.781093',10,10,'0c2a887dd4a845859f0669eb83fe675c','1f4a5d54519f4f46897a6eba8668a5c4','shares',2,0,NULL,NULL),('2025-10-01 17:00:15.978140','2025-10-01 17:00:16.167404','2025-10-01 17:00:23.781093',11,11,NULL,'1f4a5d54519f4f46897a6eba8668a5c4','shares',1,0,NULL,'9a2a36a8-eb90-44b3-beb1-6fa464aeb5a0'),('2025-10-01 17:00:15.980994','2025-10-01 17:00:16.167406','2025-10-01 17:00:23.781093',12,12,NULL,'1f4a5d54519f4f46897a6eba8668a5c4','gigabytes',1,0,NULL,'9a2a36a8-eb90-44b3-beb1-6fa464aeb5a0'),('2025-10-01 17:00:17.498849','2025-10-01 17:00:24.975959',NULL,0,13,'795436ca4abe4e0e8da2ee3bc5b1dbda','85a428afb52742d3b601161e8821da9f','gigabytes',0,0,NULL,NULL),('2025-10-01 17:00:17.502084','2025-10-01 17:00:24.975961',NULL,0,14,'795436ca4abe4e0e8da2ee3bc5b1dbda','85a428afb52742d3b601161e8821da9f','shares',0,0,NULL,NULL),('2025-10-01 17:00:17.565131','2025-10-01 17:00:24.975963','2025-10-01 17:00:28.159910',15,15,NULL,'85a428afb52742d3b601161e8821da9f','gigabytes',0,0,NULL,'fc0b7d99-26ca-4334-8407-02cec26a8f38'),('2025-10-01 17:00:17.569801','2025-10-01 17:00:24.975964','2025-10-01 17:00:28.159910',16,16,NULL,'85a428afb52742d3b601161e8821da9f','shares',0,0,NULL,'fc0b7d99-26ca-4334-8407-02cec26a8f38'),('2025-10-01 17:00:19.855535','2025-10-01 17:00:20.039284','2025-10-01 17:00:23.781093',17,17,'0c2a887dd4a845859f0669eb83fe675c','1f4a5d54519f4f46897a6eba8668a5c4','snapshots',1,0,NULL,NULL),('2025-10-01 17:00:19.861315','2025-10-01 17:00:20.039286','2025-10-01 17:00:23.781093',18,18,'0c2a887dd4a845859f0669eb83fe675c','1f4a5d54519f4f46897a6eba8668a5c4','snapshot_gigabytes',1,0,NULL,NULL),('2025-10-01 17:00:19.896894','2025-10-01 17:00:20.039288','2025-10-01 17:00:23.781093',19,19,NULL,'1f4a5d54519f4f46897a6eba8668a5c4','snapshots',1,0,NULL,'9a2a36a8-eb90-44b3-beb1-6fa464aeb5a0'),('2025-10-01 17:00:19.900596','2025-10-01 17:00:20.039289','2025-10-01 17:00:23.781093',20,20,NULL,'1f4a5d54519f4f46897a6eba8668a5c4','snapshot_gigabytes',1,0,NULL,'9a2a36a8-eb90-44b3-beb1-6fa464aeb5a0'),('2025-10-01 17:00:35.087523','2025-10-01 17:00:35.121929',NULL,0,21,'0c2a887dd4a845859f0669eb83fe675c','1f4a5d54519f4f46897a6eba8668a5c4','snapshot_gigabytes',-1,0,NULL,NULL),('2025-10-01 17:00:35.092299','2025-10-01 17:00:35.121931',NULL,0,22,'0c2a887dd4a845859f0669eb83fe675c','1f4a5d54519f4f46897a6eba8668a5c4','snapshots',-1,0,NULL,NULL),('2025-10-01 17:00:35.106345','2025-10-01 17:00:35.121933','2025-10-01 17:00:41.571925',23,23,NULL,'1f4a5d54519f4f46897a6eba8668a5c4','snapshot_gigabytes',-1,0,NULL,'9a2a36a8-eb90-44b3-beb1-6fa464aeb5a0'),('2025-10-01 17:00:35.109876','2025-10-01 17:00:35.121934','2025-10-01 17:00:41.571925',24,24,NULL,'1f4a5d54519f4f46897a6eba8668a5c4','snapshots',-1,0,NULL,'9a2a36a8-eb90-44b3-beb1-6fa464aeb5a0'),('2025-10-01 17:00:36.111817','2025-10-01 17:00:42.243405',NULL,0,25,'df0b2d6216a142dc92cd2a29e14daf63','3b070cbc3e9f4af28b0758b866474914','shares',0,0,NULL,NULL),('2025-10-01 17:00:36.115298','2025-10-01 17:00:42.243408',NULL,0,26,'df0b2d6216a142dc92cd2a29e14daf63','3b070cbc3e9f4af28b0758b866474914','gigabytes',0,0,NULL,NULL),('2025-10-01 17:00:36.126225','2025-10-01 17:00:42.243410','2025-10-01 17:00:45.036752',27,27,NULL,'3b070cbc3e9f4af28b0758b866474914','shares',0,0,NULL,'e8d8a1fc-ec5d-43c2-aabc-ffea9e499c55'),('2025-10-01 17:00:36.130409','2025-10-01 17:00:42.243412','2025-10-01 17:00:45.036752',28,28,NULL,'3b070cbc3e9f4af28b0758b866474914','gigabytes',0,0,NULL,'e8d8a1fc-ec5d-43c2-aabc-ffea9e499c55'),('2025-10-01 17:00:38.473001','2025-10-01 17:00:42.292172',NULL,0,29,'0c2a887dd4a845859f0669eb83fe675c','1f4a5d54519f4f46897a6eba8668a5c4','gigabytes',0,0,NULL,NULL),('2025-10-01 17:00:38.476894','2025-10-01 17:00:42.292174',NULL,0,30,'0c2a887dd4a845859f0669eb83fe675c','1f4a5d54519f4f46897a6eba8668a5c4','shares',0,0,NULL,NULL),('2025-10-01 17:00:38.488575','2025-10-01 17:00:38.502700','2025-10-01 17:00:41.571925',31,31,NULL,'1f4a5d54519f4f46897a6eba8668a5c4','gigabytes',0,0,NULL,'9a2a36a8-eb90-44b3-beb1-6fa464aeb5a0'),('2025-10-01 17:00:38.492105','2025-10-01 17:00:38.502702','2025-10-01 17:00:41.571925',32,32,NULL,'1f4a5d54519f4f46897a6eba8668a5c4','shares',0,0,NULL,'9a2a36a8-eb90-44b3-beb1-6fa464aeb5a0'),('2025-10-01 17:00:40.778344','2025-10-01 17:00:46.484476',NULL,0,33,'aff16e38eefd4e66b0b620d67bc65d6e','efef7d21275549538c8a121a0599e3f4','gigabytes',0,0,NULL,NULL),('2025-10-01 17:00:40.780236','2025-10-01 17:00:46.484480',NULL,0,34,'aff16e38eefd4e66b0b620d67bc65d6e','efef7d21275549538c8a121a0599e3f4','shares',0,0,NULL,NULL),('2025-10-01 17:00:40.789571','2025-10-01 17:00:46.484481','2025-10-01 17:00:49.553770',35,35,NULL,'efef7d21275549538c8a121a0599e3f4','gigabytes',0,0,NULL,'3ec8827a-3829-4912-bb29-3f95aeb0ed67'),('2025-10-01 17:00:40.791408','2025-10-01 17:00:46.484483','2025-10-01 17:00:49.553770',36,36,NULL,'efef7d21275549538c8a121a0599e3f4','shares',0,0,NULL,'3ec8827a-3829-4912-bb29-3f95aeb0ed67'),('2025-10-01 17:00:42.277355','2025-10-01 17:00:42.292175','2025-10-01 17:00:45.495371',37,37,NULL,'1f4a5d54519f4f46897a6eba8668a5c4','gigabytes',0,0,NULL,'eeda9f95-f5c3-4f07-b12e-0b18f7c8da37'),('2025-10-01 17:00:42.280466','2025-10-01 17:00:42.292176','2025-10-01 17:00:45.495371',38,38,NULL,'1f4a5d54519f4f46897a6eba8668a5c4','shares',0,0,NULL,'eeda9f95-f5c3-4f07-b12e-0b18f7c8da37'),('2025-10-01 17:00:51.389083','2025-10-01 17:01:46.799518',NULL,0,39,'f01d6292274540ac84c2c1da0ccbaedb','2204ae41373c4a57a26d8e752f9c9721','snapshots',0,0,NULL,NULL),('2025-10-01 17:00:51.392074','2025-10-01 17:01:46.799522',NULL,0,40,'f01d6292274540ac84c2c1da0ccbaedb','2204ae41373c4a57a26d8e752f9c9721','snapshot_gigabytes',0,0,NULL,NULL),('2025-10-01 17:00:51.408568','2025-10-01 17:01:46.799524','2025-10-01 17:01:54.554208',41,41,NULL,'2204ae41373c4a57a26d8e752f9c9721','snapshots',0,0,NULL,'8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:00:51.411904','2025-10-01 17:01:46.799525','2025-10-01 17:01:54.554208',42,42,NULL,'2204ae41373c4a57a26d8e752f9c9721','snapshot_gigabytes',0,0,NULL,'8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:01:01.966241','2025-10-01 17:01:18.259300',NULL,0,43,'afbf15b176594b999a50ea15bf84d237','c4ae009f89aa49ccadaaeed54f17efe5','gigabytes',0,0,NULL,NULL),('2025-10-01 17:01:01.967922','2025-10-01 17:01:18.259303',NULL,0,44,'afbf15b176594b999a50ea15bf84d237','c4ae009f89aa49ccadaaeed54f17efe5','shares',0,0,NULL,NULL),('2025-10-01 17:01:02.025509','2025-10-01 17:01:18.259304','2025-10-01 17:01:21.330649',45,45,NULL,'c4ae009f89aa49ccadaaeed54f17efe5','gigabytes',0,0,NULL,'0b6fb7a2-3c89-4ce6-afa0-08dffd4c10d5'),('2025-10-01 17:01:02.027983','2025-10-01 17:01:18.259306','2025-10-01 17:01:21.330649',46,46,NULL,'c4ae009f89aa49ccadaaeed54f17efe5','shares',0,0,NULL,'0b6fb7a2-3c89-4ce6-afa0-08dffd4c10d5'),('2025-10-01 17:01:12.976184','2025-10-01 17:01:17.182632',NULL,0,47,'675dc5e53691498a85efcdb811e5a848','fddf2e8f31614cd6afbfcdeff763553b','shares',0,0,NULL,NULL),('2025-10-01 17:01:12.980802','2025-10-01 17:01:17.182635',NULL,0,48,'675dc5e53691498a85efcdb811e5a848','fddf2e8f31614cd6afbfcdeff763553b','gigabytes',0,0,NULL,NULL),('2025-10-01 17:01:12.999413','2025-10-01 17:01:17.182637','2025-10-01 17:01:20.455622',49,49,NULL,'fddf2e8f31614cd6afbfcdeff763553b','shares',0,0,NULL,'b4e112a6-2cd3-4161-a1d9-6a2b26c3ae12'),('2025-10-01 17:01:13.001696','2025-10-01 17:01:17.182638','2025-10-01 17:01:20.455622',50,50,NULL,'fddf2e8f31614cd6afbfcdeff763553b','gigabytes',0,0,NULL,'b4e112a6-2cd3-4161-a1d9-6a2b26c3ae12'),('2025-10-01 17:01:25.184227','2025-10-01 17:02:12.741715',NULL,0,51,'0330a1c6d11e45b8a6e21e8e46c29677','0e7ac90f0c9f41cbb8e463ae95d18d81','gigabytes',0,0,NULL,NULL),('2025-10-01 17:01:25.196313','2025-10-01 17:02:12.741719',NULL,0,52,'0330a1c6d11e45b8a6e21e8e46c29677','0e7ac90f0c9f41cbb8e463ae95d18d81','shares',0,0,NULL,NULL),('2025-10-01 17:01:25.216103','2025-10-01 17:02:12.741721','2025-10-01 17:02:15.585138',53,53,NULL,'0e7ac90f0c9f41cbb8e463ae95d18d81','gigabytes',0,0,NULL,'f0348654-6331-4c8a-89cf-95b9f1fa588d'),('2025-10-01 17:01:25.221301','2025-10-01 17:02:12.741723','2025-10-01 17:02:15.585138',54,54,NULL,'0e7ac90f0c9f41cbb8e463ae95d18d81','shares',0,0,NULL,'f0348654-6331-4c8a-89cf-95b9f1fa588d'),('2025-10-01 17:01:26.671903','2025-10-01 17:01:43.383259',NULL,0,55,'c7bd5ab094534136b1906389e4264c0b','756b231c8c724081bed78676d19a02ec','gigabytes',0,0,NULL,NULL),('2025-10-01 17:01:26.673726','2025-10-01 17:01:43.383262',NULL,0,56,'c7bd5ab094534136b1906389e4264c0b','756b231c8c724081bed78676d19a02ec','shares',0,0,NULL,NULL),('2025-10-01 17:01:26.683149','2025-10-01 17:01:43.383263','2025-10-01 17:01:44.751730',57,57,NULL,'756b231c8c724081bed78676d19a02ec','gigabytes',0,0,NULL,'89fda32e-eb53-4bb7-8ebe-24317a4a69c0'),('2025-10-01 17:01:26.685725','2025-10-01 17:01:43.383265','2025-10-01 17:01:44.751730',58,58,NULL,'756b231c8c724081bed78676d19a02ec','shares',0,0,NULL,'89fda32e-eb53-4bb7-8ebe-24317a4a69c0'),('2025-10-01 17:01:28.821121','2025-10-01 17:02:08.897639',NULL,0,59,'0330a1c6d11e45b8a6e21e8e46c29677','0e7ac90f0c9f41cbb8e463ae95d18d81','snapshots',0,0,NULL,NULL),('2025-10-01 17:01:28.823548','2025-10-01 17:02:08.897641',NULL,0,60,'0330a1c6d11e45b8a6e21e8e46c29677','0e7ac90f0c9f41cbb8e463ae95d18d81','snapshot_gigabytes',0,0,NULL,NULL),('2025-10-01 17:01:28.842336','2025-10-01 17:02:08.897643','2025-10-01 17:02:15.585138',61,61,NULL,'0e7ac90f0c9f41cbb8e463ae95d18d81','snapshots',0,0,NULL,'f0348654-6331-4c8a-89cf-95b9f1fa588d'),('2025-10-01 17:01:28.845570','2025-10-01 17:02:08.897644','2025-10-01 17:02:15.585138',62,62,NULL,'0e7ac90f0c9f41cbb8e463ae95d18d81','snapshot_gigabytes',0,0,NULL,'f0348654-6331-4c8a-89cf-95b9f1fa588d'),('2025-10-01 17:01:30.213847','2025-10-01 17:01:39.790181',NULL,0,63,'c7bd5ab094534136b1906389e4264c0b','756b231c8c724081bed78676d19a02ec','snapshots',0,0,NULL,NULL),('2025-10-01 17:01:30.216238','2025-10-01 17:01:39.790184',NULL,0,64,'c7bd5ab094534136b1906389e4264c0b','756b231c8c724081bed78676d19a02ec','snapshot_gigabytes',0,0,NULL,NULL),('2025-10-01 17:01:30.229290','2025-10-01 17:01:39.790185','2025-10-01 17:01:44.751730',65,65,NULL,'756b231c8c724081bed78676d19a02ec','snapshots',0,0,NULL,'89fda32e-eb53-4bb7-8ebe-24317a4a69c0'),('2025-10-01 17:01:30.233005','2025-10-01 17:01:39.790186','2025-10-01 17:01:44.751730',66,66,NULL,'756b231c8c724081bed78676d19a02ec','snapshot_gigabytes',0,0,NULL,'89fda32e-eb53-4bb7-8ebe-24317a4a69c0'),('2025-10-01 17:01:54.740859','2025-10-01 17:02:06.394580',NULL,0,67,'559501bf42ce4daab8b14ced6e0516c4','4743342a50a447f89df320c01c1cbcc9','shares',0,0,NULL,NULL),('2025-10-01 17:01:54.743144','2025-10-01 17:02:06.394583',NULL,0,68,'559501bf42ce4daab8b14ced6e0516c4','4743342a50a447f89df320c01c1cbcc9','gigabytes',0,0,NULL,NULL),('2025-10-01 17:01:54.777409','2025-10-01 17:02:06.394584','2025-10-01 17:02:17.845859',69,69,NULL,'4743342a50a447f89df320c01c1cbcc9','shares',0,0,NULL,'dd944c2a-e556-4a92-a900-c197e5952e3a'),('2025-10-01 17:01:54.795466','2025-10-01 17:02:06.394585','2025-10-01 17:02:17.845859',70,70,NULL,'4743342a50a447f89df320c01c1cbcc9','gigabytes',0,0,NULL,'dd944c2a-e556-4a92-a900-c197e5952e3a'),('2025-10-01 17:01:58.711539','2025-10-01 17:02:14.406542',NULL,0,71,'b92b509d372144dd8cbe29e18bab1676','e7862d18aeb143d49259310c073583be','gigabytes',0,0,NULL,NULL),('2025-10-01 17:01:58.715652','2025-10-01 17:02:14.406546',NULL,0,72,'b92b509d372144dd8cbe29e18bab1676','e7862d18aeb143d49259310c073583be','shares',0,0,NULL,NULL),('2025-10-01 17:01:58.735311','2025-10-01 17:02:14.406548','2025-10-01 17:02:17.845859',73,73,NULL,'e7862d18aeb143d49259310c073583be','gigabytes',0,0,NULL,'dd944c2a-e556-4a92-a900-c197e5952e3a'),('2025-10-01 17:01:58.738965','2025-10-01 17:02:14.406550','2025-10-01 17:02:17.845859',74,74,NULL,'e7862d18aeb143d49259310c073583be','shares',0,0,NULL,'dd944c2a-e556-4a92-a900-c197e5952e3a'),('2025-10-01 17:01:58.971154','2025-10-01 17:02:50.990519',NULL,0,75,'3dce165987c44fe28fc0096cce9ddb2b','06efa1ba477e45208d5ba21e3e7c2703','shares',0,0,NULL,NULL),('2025-10-01 17:01:58.972942','2025-10-01 17:02:50.990523',NULL,0,76,'3dce165987c44fe28fc0096cce9ddb2b','06efa1ba477e45208d5ba21e3e7c2703','gigabytes',0,0,NULL,NULL),('2025-10-01 17:01:58.980740','2025-10-01 17:02:50.990525','2025-10-01 17:02:54.213653',77,77,NULL,'06efa1ba477e45208d5ba21e3e7c2703','shares',0,0,NULL,'354dd354-8b0a-40a4-9641-b0e3560a975d'),('2025-10-01 17:01:58.983510','2025-10-01 17:02:50.990527','2025-10-01 17:02:54.213653',78,78,NULL,'06efa1ba477e45208d5ba21e3e7c2703','gigabytes',0,0,NULL,'354dd354-8b0a-40a4-9641-b0e3560a975d'),('2025-10-01 17:02:11.823386','2025-10-01 17:02:26.083888',NULL,0,79,'ea1821978b91472190eb48dbc2127e63','0146329fc8d749b394ed822844000f6d','gigabytes',0,0,NULL,NULL),('2025-10-01 17:02:11.825882','2025-10-01 17:02:26.083919',NULL,0,80,'ea1821978b91472190eb48dbc2127e63','0146329fc8d749b394ed822844000f6d','shares',0,0,NULL,NULL),('2025-10-01 17:02:11.858247','2025-10-01 17:02:26.083922','2025-10-01 17:02:27.853189',81,81,NULL,'0146329fc8d749b394ed822844000f6d','gigabytes',0,0,NULL,'cd7fa723-e40d-401a-9a30-e34fb52e7764'),('2025-10-01 17:02:11.861549','2025-10-01 17:02:26.083923','2025-10-01 17:02:27.853189',82,82,NULL,'0146329fc8d749b394ed822844000f6d','shares',0,0,NULL,'cd7fa723-e40d-401a-9a30-e34fb52e7764'),('2025-10-01 17:02:15.457769','2025-10-01 17:02:21.065169',NULL,0,83,'ea1821978b91472190eb48dbc2127e63','0146329fc8d749b394ed822844000f6d','snapshots',0,0,NULL,NULL),('2025-10-01 17:02:15.460957','2025-10-01 17:02:21.065172',NULL,0,84,'ea1821978b91472190eb48dbc2127e63','0146329fc8d749b394ed822844000f6d','snapshot_gigabytes',0,0,NULL,NULL),('2025-10-01 17:02:15.473483','2025-10-01 17:02:21.065174','2025-10-01 17:02:27.853189',85,85,NULL,'0146329fc8d749b394ed822844000f6d','snapshots',0,0,NULL,'cd7fa723-e40d-401a-9a30-e34fb52e7764'),('2025-10-01 17:02:15.476554','2025-10-01 17:02:21.065176','2025-10-01 17:02:27.853189',86,86,NULL,'0146329fc8d749b394ed822844000f6d','snapshot_gigabytes',0,0,NULL,'cd7fa723-e40d-401a-9a30-e34fb52e7764'),('2025-10-01 17:02:27.328004','2025-10-01 17:02:48.218249',NULL,0,87,'7b7b6f82426848dc984e282a4a4ae2bb','f15311ab27ef411d82024fc6390e3f6d','shares',0,0,NULL,NULL),('2025-10-01 17:02:27.331254','2025-10-01 17:02:48.218252',NULL,0,88,'7b7b6f82426848dc984e282a4a4ae2bb','f15311ab27ef411d82024fc6390e3f6d','gigabytes',0,0,NULL,NULL),('2025-10-01 17:02:27.346510','2025-10-01 17:02:31.233835','2025-10-01 17:02:49.749448',89,89,NULL,'f15311ab27ef411d82024fc6390e3f6d','shares',0,0,NULL,'3f2b10b6-f512-41f8-802d-43b4c478360e'),('2025-10-01 17:02:27.349749','2025-10-01 17:02:31.233836','2025-10-01 17:02:49.749448',90,90,NULL,'f15311ab27ef411d82024fc6390e3f6d','gigabytes',0,0,NULL,'3f2b10b6-f512-41f8-802d-43b4c478360e'),('2025-10-01 17:02:29.075631','2025-10-01 17:02:34.510230',NULL,0,91,'0fc8d89ad29f495783c39738774ff7cd','d36f1681b7b349a5bf71bdac8eae5902','shares',0,0,NULL,NULL),('2025-10-01 17:02:29.081668','2025-10-01 17:02:34.510232',NULL,0,92,'0fc8d89ad29f495783c39738774ff7cd','d36f1681b7b349a5bf71bdac8eae5902','gigabytes',0,0,NULL,NULL),('2025-10-01 17:02:29.097601','2025-10-01 17:02:34.510234','2025-10-01 17:02:37.618018',93,93,NULL,'d36f1681b7b349a5bf71bdac8eae5902','shares',0,0,NULL,'07c916e4-5e73-4eaa-9e77-984c3d94747e'),('2025-10-01 17:02:29.100504','2025-10-01 17:02:34.510235','2025-10-01 17:02:37.618018',94,94,NULL,'d36f1681b7b349a5bf71bdac8eae5902','gigabytes',0,0,NULL,'07c916e4-5e73-4eaa-9e77-984c3d94747e'),('2025-10-01 17:02:31.488803','2025-10-01 17:02:35.198521','2025-10-01 17:02:49.572363',95,95,NULL,'f15311ab27ef411d82024fc6390e3f6d','gigabytes',0,0,NULL,'bb28b531-7011-4456-8d2d-6fe0cb38ac18'),('2025-10-01 17:02:31.490953','2025-10-01 17:02:35.198523','2025-10-01 17:02:49.572363',96,96,NULL,'f15311ab27ef411d82024fc6390e3f6d','shares',0,0,NULL,'bb28b531-7011-4456-8d2d-6fe0cb38ac18'),('2025-10-01 17:02:35.630700','2025-10-01 17:02:39.394202','2025-10-01 17:02:49.431542',97,97,NULL,'f15311ab27ef411d82024fc6390e3f6d','gigabytes',0,0,NULL,'584a5070-565d-40c4-835e-9ead21030114'),('2025-10-01 17:02:35.632930','2025-10-01 17:02:39.394203','2025-10-01 17:02:49.431542',98,98,NULL,'f15311ab27ef411d82024fc6390e3f6d','shares',0,0,NULL,'584a5070-565d-40c4-835e-9ead21030114'),('2025-10-01 17:02:39.803023','2025-10-01 17:02:43.590565','2025-10-01 17:02:49.113718',99,99,NULL,'f15311ab27ef411d82024fc6390e3f6d','gigabytes',0,0,NULL,'4211893b-b8e2-4a67-bb8a-d9c7ef2f16a2'),('2025-10-01 17:02:39.805503','2025-10-01 17:02:43.590567','2025-10-01 17:02:49.113718',100,100,NULL,'f15311ab27ef411d82024fc6390e3f6d','shares',0,0,NULL,'4211893b-b8e2-4a67-bb8a-d9c7ef2f16a2'),('2025-10-01 17:02:44.000377','2025-10-01 17:02:48.218254','2025-10-01 17:02:48.885987',101,101,NULL,'f15311ab27ef411d82024fc6390e3f6d','shares',0,0,NULL,'4fc47fc1-7587-4c59-80e9-5db74e7ecbe3'),('2025-10-01 17:02:44.002101','2025-10-01 17:02:48.218255','2025-10-01 17:02:48.885987',102,102,NULL,'f15311ab27ef411d82024fc6390e3f6d','gigabytes',0,0,NULL,'4fc47fc1-7587-4c59-80e9-5db74e7ecbe3'),('2025-10-01 17:02:49.477516','2025-10-01 17:06:21.880783',NULL,0,103,'6ae885d77a5748a299ec5daaece928c1','1841221f332340a299707d253063659f','gigabytes',0,0,NULL,NULL),('2025-10-01 17:02:49.479702','2025-10-01 17:06:21.880787',NULL,0,104,'6ae885d77a5748a299ec5daaece928c1','1841221f332340a299707d253063659f','shares',0,0,NULL,NULL),('2025-10-01 17:02:49.497736','2025-10-01 17:06:21.880789',NULL,0,105,NULL,'1841221f332340a299707d253063659f','gigabytes',1,0,NULL,'3454de97-e8db-4b3e-a708-5ac562e85e73'),('2025-10-01 17:02:49.500016','2025-10-01 17:06:21.880791',NULL,0,106,NULL,'1841221f332340a299707d253063659f','shares',1,0,NULL,'3454de97-e8db-4b3e-a708-5ac562e85e73'),('2025-10-01 17:02:51.521296','2025-10-01 17:03:04.473292','2025-10-01 17:03:08.427892',107,107,'9067353b927842dbadd16dcb12f93b3d','a307fd4b882d45898ca085500fbf65b4','shares',0,0,NULL,NULL),('2025-10-01 17:02:51.523143','2025-10-01 17:03:04.473294','2025-10-01 17:03:08.427892',108,108,'9067353b927842dbadd16dcb12f93b3d','a307fd4b882d45898ca085500fbf65b4','gigabytes',0,0,NULL,NULL),('2025-10-01 17:02:51.556783','2025-10-01 17:03:01.184449','2025-10-01 17:03:08.594393',109,109,NULL,'a307fd4b882d45898ca085500fbf65b4','shares',0,0,NULL,'f75be615-3c48-49cc-844c-502b209bf197'),('2025-10-01 17:02:51.558695','2025-10-01 17:03:01.184450','2025-10-01 17:03:08.594393',110,110,NULL,'a307fd4b882d45898ca085500fbf65b4','gigabytes',0,0,NULL,'f75be615-3c48-49cc-844c-502b209bf197'),('2025-10-01 17:02:56.671342','2025-10-01 17:03:04.473296','2025-10-01 17:03:08.594393',111,111,NULL,'a307fd4b882d45898ca085500fbf65b4','gigabytes',0,0,NULL,'2324d49d-b8b2-4a6a-82f9-af40a075e8cc'),('2025-10-01 17:02:56.673674','2025-10-01 17:03:04.473297','2025-10-01 17:03:08.594393',112,112,NULL,'a307fd4b882d45898ca085500fbf65b4','shares',0,0,NULL,'2324d49d-b8b2-4a6a-82f9-af40a075e8cc'),('2025-10-01 17:03:08.424398','2025-10-01 17:04:25.094740',NULL,0,113,'0e5069509e1b4a3fba307dac6547b514','a0ac8ec815504b8dae62c40a55008f52','gigabytes',0,0,NULL,NULL),('2025-10-01 17:03:08.427353','2025-10-01 17:04:25.094743',NULL,0,114,'0e5069509e1b4a3fba307dac6547b514','a0ac8ec815504b8dae62c40a55008f52','shares',0,0,NULL,NULL),('2025-10-01 17:03:08.442379','2025-10-01 17:04:25.094745','2025-10-01 17:04:26.640744',115,115,NULL,'a0ac8ec815504b8dae62c40a55008f52','gigabytes',0,0,NULL,'3c11362f-fb50-4637-8fe6-18550ac367e4'),('2025-10-01 17:03:08.444652','2025-10-01 17:04:25.094747','2025-10-01 17:04:26.640744',116,116,NULL,'a0ac8ec815504b8dae62c40a55008f52','shares',0,0,NULL,'3c11362f-fb50-4637-8fe6-18550ac367e4'),('2025-10-01 17:03:34.454528','2025-10-01 17:03:37.332613',NULL,0,117,'76eea8115d324be1a5ea0e97a79df9d8','01bc5d037e3c4524ae56d7d17d262d0d','share_networks',0,0,NULL,NULL),('2025-10-01 17:03:35.044075','2025-10-01 17:03:35.241027',NULL,0,118,'d68a134fb2894956b0088cb7a9513af9','9bd13d2e911f47bd8088546be105109c','share_networks',1,0,NULL,NULL),('2025-10-01 17:03:47.412409','2025-10-01 17:03:49.602562',NULL,0,119,'c09dbb0e26b54de6b5ba772109c45853','ba644d06236b4f928b914648a014fefa','share_networks',1,0,NULL,NULL),('2025-10-01 17:03:53.438082','2025-10-01 17:04:10.402555',NULL,0,120,'b2685616371841959873dec890fa5385','5473075ec2e4439eadc201afc270390c','shares',0,0,NULL,NULL),('2025-10-01 17:03:53.439748','2025-10-01 17:04:10.402557',NULL,0,121,'b2685616371841959873dec890fa5385','5473075ec2e4439eadc201afc270390c','gigabytes',0,0,NULL,NULL),('2025-10-01 17:03:53.453925','2025-10-01 17:04:10.402559','2025-10-01 17:04:12.172360',122,122,NULL,'5473075ec2e4439eadc201afc270390c','shares',0,0,NULL,'7c91cae8-1d42-4bfe-95c0-52e8e38ffe43'),('2025-10-01 17:03:53.456262','2025-10-01 17:04:10.402560','2025-10-01 17:04:12.172360',123,123,NULL,'5473075ec2e4439eadc201afc270390c','gigabytes',0,0,NULL,'7c91cae8-1d42-4bfe-95c0-52e8e38ffe43'),('2025-10-01 17:03:56.934925','2025-10-01 17:04:05.898913',NULL,0,124,'b2685616371841959873dec890fa5385','5473075ec2e4439eadc201afc270390c','snapshots',0,0,NULL,NULL),('2025-10-01 17:03:56.936981','2025-10-01 17:04:05.898915',NULL,0,125,'b2685616371841959873dec890fa5385','5473075ec2e4439eadc201afc270390c','snapshot_gigabytes',0,0,NULL,NULL),('2025-10-01 17:03:56.944961','2025-10-01 17:04:05.898917','2025-10-01 17:04:12.172360',126,126,NULL,'5473075ec2e4439eadc201afc270390c','snapshots',0,0,NULL,'7c91cae8-1d42-4bfe-95c0-52e8e38ffe43'),('2025-10-01 17:03:56.946808','2025-10-01 17:04:05.898918','2025-10-01 17:04:12.172360',127,127,NULL,'5473075ec2e4439eadc201afc270390c','snapshot_gigabytes',0,0,NULL,'7c91cae8-1d42-4bfe-95c0-52e8e38ffe43'),('2025-10-01 17:03:58.844495','2025-10-01 17:04:00.802922',NULL,0,128,'ed9c7605c9ba47fa826456bdb7485f23','76020c94a59c417e8bed7e7ea0fbb3bf','share_networks',0,0,NULL,NULL),('2025-10-01 17:04:11.638824','2025-10-01 17:04:36.041170',NULL,0,129,'af8da6febaae4dfe9de0fa747a5ef119','220545ce6f424d4187770842929567dc','gigabytes',1,0,NULL,NULL),('2025-10-01 17:04:11.640758','2025-10-01 17:04:36.041174',NULL,0,130,'af8da6febaae4dfe9de0fa747a5ef119','220545ce6f424d4187770842929567dc','shares',1,0,NULL,NULL),('2025-10-01 17:04:11.653363','2025-10-01 17:04:36.041176','2025-10-01 17:04:40.110462',131,131,NULL,'220545ce6f424d4187770842929567dc','gigabytes',1,0,NULL,'b7c65449-bea8-4815-b156-f9df3fa11183'),('2025-10-01 17:04:11.656752','2025-10-01 17:04:36.041178','2025-10-01 17:04:40.110462',132,132,NULL,'220545ce6f424d4187770842929567dc','shares',1,0,NULL,'b7c65449-bea8-4815-b156-f9df3fa11183'),('2025-10-01 17:04:15.690125','2025-10-01 17:04:19.555416',NULL,0,133,'215059d06b1f437a84c98c525318fc71','d7270bd14938443caacbacdbd21d7c3b','gigabytes',0,0,NULL,NULL),('2025-10-01 17:04:15.691782','2025-10-01 17:04:19.555419',NULL,0,134,'215059d06b1f437a84c98c525318fc71','d7270bd14938443caacbacdbd21d7c3b','shares',0,0,NULL,NULL),('2025-10-01 17:04:15.712170','2025-10-01 17:04:18.672377',NULL,0,135,'215059d06b1f437a84c98c525318fc71','220545ce6f424d4187770842929567dc','gigabytes',-1,0,NULL,NULL),('2025-10-01 17:04:15.714095','2025-10-01 17:04:18.672380',NULL,0,136,'215059d06b1f437a84c98c525318fc71','220545ce6f424d4187770842929567dc','shares',-1,0,NULL,NULL),('2025-10-01 17:04:19.530107','2025-10-01 17:04:19.555420','2025-10-01 17:04:40.110462',137,137,NULL,'d7270bd14938443caacbacdbd21d7c3b','gigabytes',0,0,NULL,'b7c65449-bea8-4815-b156-f9df3fa11183'),('2025-10-01 17:04:19.532806','2025-10-01 17:04:19.555421','2025-10-01 17:04:40.110462',138,138,NULL,'d7270bd14938443caacbacdbd21d7c3b','shares',0,0,NULL,'b7c65449-bea8-4815-b156-f9df3fa11183'),('2025-10-01 17:04:43.119853','2025-10-01 17:05:26.480653',NULL,0,139,'d6dae67f198f483d86a85008b5959866','a1cd9e94225644748568dfbc4af1058a','gigabytes',0,0,NULL,NULL),('2025-10-01 17:04:43.121545','2025-10-01 17:05:26.480656',NULL,0,140,'d6dae67f198f483d86a85008b5959866','a1cd9e94225644748568dfbc4af1058a','shares',0,0,NULL,NULL),('2025-10-01 17:04:43.142745','2025-10-01 17:04:47.273955','2025-10-01 17:05:30.262440',141,141,NULL,'a1cd9e94225644748568dfbc4af1058a','gigabytes',0,0,NULL,'37485c41-bf1c-4f76-96dd-017b9efb3945'),('2025-10-01 17:04:43.145504','2025-10-01 17:04:47.273957','2025-10-01 17:05:30.262440',142,142,NULL,'a1cd9e94225644748568dfbc4af1058a','shares',0,0,NULL,'37485c41-bf1c-4f76-96dd-017b9efb3945'),('2025-10-01 17:04:47.612492','2025-10-01 17:04:51.928982','2025-10-01 17:05:30.112150',143,143,NULL,'a1cd9e94225644748568dfbc4af1058a','shares',0,0,NULL,'f9da0eae-4f7c-4b85-af50-4858ad082260'),('2025-10-01 17:04:47.614829','2025-10-01 17:04:51.928984','2025-10-01 17:05:30.112150',144,144,NULL,'a1cd9e94225644748568dfbc4af1058a','gigabytes',0,0,NULL,'f9da0eae-4f7c-4b85-af50-4858ad082260'),('2025-10-01 17:04:52.096301','2025-10-01 17:06:03.760625',NULL,0,145,'bdbab5c8cbd84614a605693d09049109','86a0062edb9a4a3293bf2e93012e4f13','gigabytes',0,0,NULL,NULL),('2025-10-01 17:04:52.098230','2025-10-01 17:06:03.760628',NULL,0,146,'bdbab5c8cbd84614a605693d09049109','86a0062edb9a4a3293bf2e93012e4f13','shares',0,0,NULL,NULL),('2025-10-01 17:04:52.115198','2025-10-01 17:06:03.760629','2025-10-01 17:06:06.643805',147,147,NULL,'86a0062edb9a4a3293bf2e93012e4f13','gigabytes',0,0,NULL,'b09f42fb-ab61-4f61-a72d-bb65a506d3d5'),('2025-10-01 17:04:52.117308','2025-10-01 17:06:03.760631','2025-10-01 17:06:06.643805',148,148,NULL,'86a0062edb9a4a3293bf2e93012e4f13','shares',0,0,NULL,'b09f42fb-ab61-4f61-a72d-bb65a506d3d5'),('2025-10-01 17:04:52.269535','2025-10-01 17:05:00.113228','2025-10-01 17:05:29.612715',149,149,NULL,'a1cd9e94225644748568dfbc4af1058a','shares',0,0,NULL,'7913e282-46b6-4065-b63e-e5013b78d303'),('2025-10-01 17:04:52.275144','2025-10-01 17:05:00.113229','2025-10-01 17:05:29.612715',150,150,NULL,'a1cd9e94225644748568dfbc4af1058a','gigabytes',0,0,NULL,'7913e282-46b6-4065-b63e-e5013b78d303'),('2025-10-01 17:04:54.109198','2025-10-01 17:05:29.629665',NULL,0,151,'d0c0ffc90809482c8626b2e61d341f16','23b43441437342609cce9f7f9d4d5521','gigabytes',0,0,NULL,NULL),('2025-10-01 17:04:54.111858','2025-10-01 17:05:29.629668',NULL,0,152,'d0c0ffc90809482c8626b2e61d341f16','23b43441437342609cce9f7f9d4d5521','shares',0,0,NULL,NULL),('2025-10-01 17:04:54.164382','2025-10-01 17:05:29.629669','2025-10-01 17:05:31.981160',153,153,NULL,'23b43441437342609cce9f7f9d4d5521','gigabytes',0,0,NULL,'e67af6d6-3813-468e-96d3-f52430ec7993'),('2025-10-01 17:04:54.166176','2025-10-01 17:05:29.629671','2025-10-01 17:05:31.981160',154,154,NULL,'23b43441437342609cce9f7f9d4d5521','shares',0,0,NULL,'e67af6d6-3813-468e-96d3-f52430ec7993'),('2025-10-01 17:04:55.896873','2025-10-01 17:06:00.176215',NULL,0,155,NULL,'86a0062edb9a4a3293bf2e93012e4f13','gigabytes',0,0,NULL,'a8a00136-83b3-4010-b21e-0ef332301b8d'),('2025-10-01 17:04:55.899436','2025-10-01 17:06:00.176217',NULL,0,156,NULL,'86a0062edb9a4a3293bf2e93012e4f13','shares',0,0,NULL,'a8a00136-83b3-4010-b21e-0ef332301b8d'),('2025-10-01 17:04:56.090808','2025-10-01 17:04:59.768146','2025-10-01 17:05:29.266386',157,157,NULL,'a1cd9e94225644748568dfbc4af1058a','gigabytes',0,0,NULL,'f6d05e71-de10-42a2-8555-e5899975f59e'),('2025-10-01 17:04:56.092755','2025-10-01 17:04:59.768147','2025-10-01 17:05:29.266386',158,158,NULL,'a1cd9e94225644748568dfbc4af1058a','shares',0,0,NULL,'f6d05e71-de10-42a2-8555-e5899975f59e'),('2025-10-01 17:05:00.390681','2025-10-01 17:05:13.621610','2025-10-01 17:05:28.804109',159,159,NULL,'a1cd9e94225644748568dfbc4af1058a','gigabytes',0,0,NULL,'039a05c1-a5d1-442b-b2f7-1c7883683b48'),('2025-10-01 17:05:00.392524','2025-10-01 17:05:13.621611','2025-10-01 17:05:28.804109',160,160,NULL,'a1cd9e94225644748568dfbc4af1058a','shares',0,0,NULL,'039a05c1-a5d1-442b-b2f7-1c7883683b48'),('2025-10-01 17:05:02.978686','2025-10-01 17:05:56.861931',NULL,0,161,'5acd4d62fc8e4eeabaae2462d3c7a8fa','fb3120e923574f759bb16e2e2d603473','gigabytes',0,0,NULL,NULL),('2025-10-01 17:05:02.980590','2025-10-01 17:05:56.861934',NULL,0,162,'5acd4d62fc8e4eeabaae2462d3c7a8fa','fb3120e923574f759bb16e2e2d603473','shares',0,0,NULL,NULL),('2025-10-01 17:05:03.035968','2025-10-01 17:05:56.861935',NULL,0,163,NULL,'fb3120e923574f759bb16e2e2d603473','gigabytes',0,0,NULL,'a8a00136-83b3-4010-b21e-0ef332301b8d'),('2025-10-01 17:05:03.037864','2025-10-01 17:05:56.861936',NULL,0,164,NULL,'fb3120e923574f759bb16e2e2d603473','shares',0,0,NULL,'a8a00136-83b3-4010-b21e-0ef332301b8d'),('2025-10-01 17:05:05.306741','2025-10-01 17:05:13.295355','2025-10-01 17:05:28.378866',165,165,NULL,'a1cd9e94225644748568dfbc4af1058a','shares',0,0,NULL,'ff31a3ee-a999-42cd-b0e7-6b0804664d3d'),('2025-10-01 17:05:05.320375','2025-10-01 17:05:13.295356','2025-10-01 17:05:28.378866',166,166,NULL,'a1cd9e94225644748568dfbc4af1058a','gigabytes',0,0,NULL,'ff31a3ee-a999-42cd-b0e7-6b0804664d3d'),('2025-10-01 17:05:09.313834','2025-10-01 17:05:13.056158','2025-10-01 17:05:27.992076',167,167,NULL,'a1cd9e94225644748568dfbc4af1058a','gigabytes',0,0,NULL,'00ca740c-3b33-4184-8684-9c836e09c2c9'),('2025-10-01 17:05:09.315897','2025-10-01 17:05:13.056160','2025-10-01 17:05:27.992076',168,168,NULL,'a1cd9e94225644748568dfbc4af1058a','shares',0,0,NULL,'00ca740c-3b33-4184-8684-9c836e09c2c9'),('2025-10-01 17:05:13.847025','2025-10-01 17:05:21.707715','2025-10-01 17:05:27.224400',169,169,NULL,'a1cd9e94225644748568dfbc4af1058a','shares',0,0,NULL,'bf0700f6-e269-4e6e-8ad2-2c76437dcb49'),('2025-10-01 17:05:13.849259','2025-10-01 17:05:21.707716','2025-10-01 17:05:27.224400',170,170,NULL,'a1cd9e94225644748568dfbc4af1058a','gigabytes',0,0,NULL,'bf0700f6-e269-4e6e-8ad2-2c76437dcb49'),('2025-10-01 17:05:17.351340','2025-10-01 17:05:21.329332','2025-10-01 17:05:26.993219',171,171,NULL,'a1cd9e94225644748568dfbc4af1058a','gigabytes',0,0,NULL,'5c4f6639-cfc2-4866-9875-6cc9e6501c89'),('2025-10-01 17:05:17.353610','2025-10-01 17:05:21.329334','2025-10-01 17:05:26.993219',172,172,NULL,'a1cd9e94225644748568dfbc4af1058a','shares',0,0,NULL,'5c4f6639-cfc2-4866-9875-6cc9e6501c89'),('2025-10-01 17:05:22.342058','2025-10-01 17:05:26.480658','2025-10-01 17:05:26.833280',173,173,NULL,'a1cd9e94225644748568dfbc4af1058a','shares',0,0,NULL,'0e7badfe-7b64-4ef5-9cae-3e2a73bd3271'),('2025-10-01 17:05:22.346383','2025-10-01 17:05:26.480660','2025-10-01 17:05:26.833280',174,174,NULL,'a1cd9e94225644748568dfbc4af1058a','gigabytes',0,0,NULL,'0e7badfe-7b64-4ef5-9cae-3e2a73bd3271'),('2025-10-01 17:05:38.412657','2025-10-01 17:06:01.556835',NULL,0,175,'09f29295317a46d6b8c0b29e6210e6f7','ad666ccc4f754e07a5041ffb5aaf32ae','gigabytes',0,0,NULL,NULL),('2025-10-01 17:05:38.414567','2025-10-01 17:06:01.556838',NULL,0,176,'09f29295317a46d6b8c0b29e6210e6f7','ad666ccc4f754e07a5041ffb5aaf32ae','shares',0,0,NULL,NULL),('2025-10-01 17:05:38.424155','2025-10-01 17:06:01.556839','2025-10-01 17:06:04.034304',177,177,NULL,'ad666ccc4f754e07a5041ffb5aaf32ae','gigabytes',0,0,NULL,'80224da1-67c8-4766-8a84-e16e713a12a0'),('2025-10-01 17:05:38.426420','2025-10-01 17:06:01.556840','2025-10-01 17:06:04.034304',178,178,NULL,'ad666ccc4f754e07a5041ffb5aaf32ae','shares',0,0,NULL,'80224da1-67c8-4766-8a84-e16e713a12a0'),('2025-10-01 17:05:38.450429','2025-10-01 17:05:53.388712','2025-10-01 17:06:06.643805',179,179,NULL,'fb3120e923574f759bb16e2e2d603473','gigabytes',0,0,NULL,'b09f42fb-ab61-4f61-a72d-bb65a506d3d5'),('2025-10-01 17:05:38.453450','2025-10-01 17:05:53.388713','2025-10-01 17:06:06.643805',180,180,NULL,'fb3120e923574f759bb16e2e2d603473','shares',0,0,NULL,'b09f42fb-ab61-4f61-a72d-bb65a506d3d5'),('2025-10-01 17:05:41.535991','2025-10-01 17:06:36.512830',NULL,0,181,'c0d8712c5da945d1ba492d2950f68d35','40c3564ff57e4cfca7dd255e456bdcb2','gigabytes',0,0,NULL,NULL),('2025-10-01 17:05:41.538939','2025-10-01 17:06:36.512833',NULL,0,182,'c0d8712c5da945d1ba492d2950f68d35','40c3564ff57e4cfca7dd255e456bdcb2','shares',0,0,NULL,NULL),('2025-10-01 17:05:41.550002','2025-10-01 17:06:36.512834','2025-10-01 17:06:39.652171',183,183,NULL,'40c3564ff57e4cfca7dd255e456bdcb2','gigabytes',0,0,NULL,'af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:05:41.552508','2025-10-01 17:06:36.512835','2025-10-01 17:06:39.652171',184,184,NULL,'40c3564ff57e4cfca7dd255e456bdcb2','shares',0,0,NULL,'af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:05:44.936155','2025-10-01 17:06:32.670708',NULL,0,185,'c0d8712c5da945d1ba492d2950f68d35','40c3564ff57e4cfca7dd255e456bdcb2','snapshots',0,0,NULL,NULL),('2025-10-01 17:05:44.937991','2025-10-01 17:06:32.670711',NULL,0,186,'c0d8712c5da945d1ba492d2950f68d35','40c3564ff57e4cfca7dd255e456bdcb2','snapshot_gigabytes',0,0,NULL,NULL),('2025-10-01 17:05:44.948451','2025-10-01 17:06:32.670712','2025-10-01 17:06:39.652171',187,187,NULL,'40c3564ff57e4cfca7dd255e456bdcb2','snapshots',0,0,NULL,'af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:05:44.951180','2025-10-01 17:06:32.670713','2025-10-01 17:06:39.652171',188,188,NULL,'40c3564ff57e4cfca7dd255e456bdcb2','snapshot_gigabytes',0,0,NULL,'af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:06:06.063477','2025-10-01 17:06:06.098031',NULL,0,189,'173ca489ed484f4d9628dc0a289d1dba','1841221f332340a299707d253063659f','gigabytes',1,0,NULL,NULL),('2025-10-01 17:06:06.065523','2025-10-01 17:06:06.098033',NULL,0,190,'173ca489ed484f4d9628dc0a289d1dba','1841221f332340a299707d253063659f','shares',1,0,NULL,NULL),('2025-10-01 17:06:11.744027','2025-10-01 17:06:17.570897',NULL,0,191,'04f5ceff16e74a1bb67c0b5ed79dce63','8c95d7d4c61e4a5bbe4dc2e0f6e03fd9','shares',0,0,NULL,NULL),('2025-10-01 17:06:11.746636','2025-10-01 17:06:17.570900',NULL,0,192,'04f5ceff16e74a1bb67c0b5ed79dce63','8c95d7d4c61e4a5bbe4dc2e0f6e03fd9','gigabytes',0,0,NULL,NULL),('2025-10-01 17:06:11.755912','2025-10-01 17:06:17.570902','2025-10-01 17:06:20.071780',193,193,NULL,'8c95d7d4c61e4a5bbe4dc2e0f6e03fd9','shares',0,0,NULL,'55334669-db93-4cfa-8367-2b8ce2d4cd8b'),('2025-10-01 17:06:11.759652','2025-10-01 17:06:17.570904','2025-10-01 17:06:20.071780',194,194,NULL,'8c95d7d4c61e4a5bbe4dc2e0f6e03fd9','gigabytes',0,0,NULL,'55334669-db93-4cfa-8367-2b8ce2d4cd8b'),('2025-10-01 17:06:14.914440','2025-10-01 17:06:14.966986',NULL,0,195,'bbe9b26c815c44cb9bf87c8ab647d6f0','8b2c53e72b304ed58c7323214b5da098','share_networks',1,0,NULL,NULL),('2025-10-01 17:06:22.680638','2025-10-01 17:06:27.770398',NULL,0,196,'8945292d68314360add2298ae9496343','89da7f149c6d414e94627e6e6c634ced','share_networks',0,0,NULL,NULL),('2025-10-01 17:06:36.410436','2025-10-01 17:06:42.554385',NULL,0,197,'13c52b1d5b7048f4bf4952658e63fbac','1dd38e8e995543ea9f3667b44746e174','gigabytes',0,0,NULL,NULL),('2025-10-01 17:06:36.413129','2025-10-01 17:06:42.554387',NULL,0,198,'13c52b1d5b7048f4bf4952658e63fbac','1dd38e8e995543ea9f3667b44746e174','shares',0,0,NULL,NULL),('2025-10-01 17:06:36.430525','2025-10-01 17:06:42.554389','2025-10-01 17:06:45.622742',199,199,NULL,'1dd38e8e995543ea9f3667b44746e174','gigabytes',0,0,NULL,'1db0c391-0940-40b9-8519-f4e0c69684f3'),('2025-10-01 17:06:36.433177','2025-10-01 17:06:42.554390','2025-10-01 17:06:45.622742',200,200,NULL,'1dd38e8e995543ea9f3667b44746e174','shares',0,0,NULL,'1db0c391-0940-40b9-8519-f4e0c69684f3'),('2025-10-01 17:06:37.993770','2025-10-01 17:08:13.716760',NULL,0,201,'fcbf8552ba484efaa8cae2712992af80','384850ddb88c4d3798b3a3d365973ad0','gigabytes',0,0,NULL,NULL),('2025-10-01 17:06:37.999244','2025-10-01 17:08:13.716763',NULL,0,202,'fcbf8552ba484efaa8cae2712992af80','384850ddb88c4d3798b3a3d365973ad0','shares',0,0,NULL,NULL),('2025-10-01 17:06:38.025259','2025-10-01 17:06:49.688863','2025-10-01 17:06:53.059262',203,203,NULL,'384850ddb88c4d3798b3a3d365973ad0','gigabytes',0,0,NULL,'c5837613-7660-4253-b4d4-3a77d14c481c'),('2025-10-01 17:06:38.032270','2025-10-01 17:06:49.688865','2025-10-01 17:06:53.059262',204,204,NULL,'384850ddb88c4d3798b3a3d365973ad0','shares',0,0,NULL,'c5837613-7660-4253-b4d4-3a77d14c481c'),('2025-10-01 17:06:41.701367','2025-10-01 17:08:11.472978',NULL,0,205,'fcbf8552ba484efaa8cae2712992af80','384850ddb88c4d3798b3a3d365973ad0','snapshots',0,0,NULL,NULL),('2025-10-01 17:06:41.703142','2025-10-01 17:08:11.472982',NULL,0,206,'fcbf8552ba484efaa8cae2712992af80','384850ddb88c4d3798b3a3d365973ad0','snapshot_gigabytes',0,0,NULL,NULL),('2025-10-01 17:06:41.746850','2025-10-01 17:06:45.844797','2025-10-01 17:06:53.059262',207,207,NULL,'384850ddb88c4d3798b3a3d365973ad0','snapshots',0,0,NULL,'c5837613-7660-4253-b4d4-3a77d14c481c'),('2025-10-01 17:06:41.749747','2025-10-01 17:06:45.844799','2025-10-01 17:06:53.059262',208,208,NULL,'384850ddb88c4d3798b3a3d365973ad0','snapshot_gigabytes',0,0,NULL,'c5837613-7660-4253-b4d4-3a77d14c481c'),('2025-10-01 17:06:44.986082','2025-10-01 17:06:48.436592',NULL,0,209,'7f64c97f01d745219a4bd763f763f698','7b8bec1247f54479b803a9ec7e7655de','share_networks',0,0,NULL,NULL),('2025-10-01 17:06:53.401277','2025-10-01 17:06:59.092480','2025-10-01 17:08:18.497459',210,210,NULL,'384850ddb88c4d3798b3a3d365973ad0','shares',0,0,NULL,'8478d453-a6b0-4b46-9199-1966caf8d4cf'),('2025-10-01 17:06:53.403305','2025-10-01 17:06:59.092481','2025-10-01 17:08:18.497459',211,211,NULL,'384850ddb88c4d3798b3a3d365973ad0','gigabytes',0,0,NULL,'8478d453-a6b0-4b46-9199-1966caf8d4cf'),('2025-10-01 17:06:56.432520','2025-10-01 17:07:01.317708',NULL,0,212,'38ae86a37a0b4939a6f90ce219165e47','30cd3ce4e43d4122b839b6e5f4bf6511','share_networks',0,0,NULL,NULL),('2025-10-01 17:06:57.177745','2025-10-01 17:07:12.501536',NULL,0,213,'fdec41847e24465299bb1f75d3e480d2','7697ecff3b5f413c99a5ace837dd6970','shares',0,0,NULL,NULL),('2025-10-01 17:06:57.180359','2025-10-01 17:07:12.501538',NULL,0,214,'fdec41847e24465299bb1f75d3e480d2','7697ecff3b5f413c99a5ace837dd6970','gigabytes',0,0,NULL,NULL),('2025-10-01 17:06:57.198680','2025-10-01 17:07:12.501540','2025-10-01 17:07:12.869485',215,215,NULL,'7697ecff3b5f413c99a5ace837dd6970','shares',0,0,NULL,'5efa3b2a-601c-4ea8-9cf6-c5c76a3276c5'),('2025-10-01 17:06:57.201126','2025-10-01 17:07:12.501541','2025-10-01 17:07:12.869485',216,216,NULL,'7697ecff3b5f413c99a5ace837dd6970','gigabytes',0,0,NULL,'5efa3b2a-601c-4ea8-9cf6-c5c76a3276c5'),('2025-10-01 17:07:00.793375','2025-10-01 17:07:08.844730',NULL,0,217,'fdec41847e24465299bb1f75d3e480d2','7697ecff3b5f413c99a5ace837dd6970','snapshots',0,0,NULL,NULL),('2025-10-01 17:07:00.795385','2025-10-01 17:07:08.844733',NULL,0,218,'fdec41847e24465299bb1f75d3e480d2','7697ecff3b5f413c99a5ace837dd6970','snapshot_gigabytes',0,0,NULL,NULL),('2025-10-01 17:07:00.860362','2025-10-01 17:07:08.844734','2025-10-01 17:07:12.869485',219,219,NULL,'7697ecff3b5f413c99a5ace837dd6970','snapshots',0,0,NULL,'5efa3b2a-601c-4ea8-9cf6-c5c76a3276c5'),('2025-10-01 17:07:00.863353','2025-10-01 17:07:08.844735','2025-10-01 17:07:12.869485',220,220,NULL,'7697ecff3b5f413c99a5ace837dd6970','snapshot_gigabytes',0,0,NULL,'5efa3b2a-601c-4ea8-9cf6-c5c76a3276c5'),('2025-10-01 17:07:01.216972','2025-10-01 17:08:13.716764','2025-10-01 17:08:16.962756',221,221,NULL,'384850ddb88c4d3798b3a3d365973ad0','shares',0,0,NULL,'2e37e456-1985-407a-9e7d-7cfaa41f9bf5'),('2025-10-01 17:07:01.218734','2025-10-01 17:08:13.716765','2025-10-01 17:08:16.962756',222,222,NULL,'384850ddb88c4d3798b3a3d365973ad0','gigabytes',0,0,NULL,'2e37e456-1985-407a-9e7d-7cfaa41f9bf5'),('2025-10-01 17:07:04.933006','2025-10-01 17:08:11.472983','2025-10-01 17:08:16.962756',223,223,NULL,'384850ddb88c4d3798b3a3d365973ad0','snapshots',0,0,NULL,'2e37e456-1985-407a-9e7d-7cfaa41f9bf5'),('2025-10-01 17:07:04.934946','2025-10-01 17:08:11.472984','2025-10-01 17:08:16.962756',224,224,NULL,'384850ddb88c4d3798b3a3d365973ad0','snapshot_gigabytes',0,0,NULL,'2e37e456-1985-407a-9e7d-7cfaa41f9bf5'),('2025-10-01 17:07:26.740808','2025-10-01 17:08:02.890551',NULL,0,225,'8395fbe4aa1a4d9bb181f7e321703f61','f63de858e3a74f88a78eaacea59850c5','gigabytes',0,0,NULL,NULL),('2025-10-01 17:07:26.742780','2025-10-01 17:08:02.890554',NULL,0,226,'8395fbe4aa1a4d9bb181f7e321703f61','f63de858e3a74f88a78eaacea59850c5','shares',0,0,NULL,NULL),('2025-10-01 17:07:26.752991','2025-10-01 17:08:02.890555','2025-10-01 17:08:06.447768',227,227,NULL,'f63de858e3a74f88a78eaacea59850c5','gigabytes',0,0,NULL,'955aef9f-9d20-4cc2-94d6-c8222f9248a9'),('2025-10-01 17:07:26.755603','2025-10-01 17:08:02.890557','2025-10-01 17:08:06.447768',228,228,NULL,'f63de858e3a74f88a78eaacea59850c5','shares',0,0,NULL,'955aef9f-9d20-4cc2-94d6-c8222f9248a9'),('2025-10-01 17:07:32.374746','2025-10-01 17:08:30.154476',NULL,0,229,'e660ba5c7b304e2abc80f9b99bdd51af','29266081bf264ee18aad20d4882a428c','gigabytes',0,0,NULL,NULL),('2025-10-01 17:07:32.389397','2025-10-01 17:08:30.154479',NULL,0,230,'e660ba5c7b304e2abc80f9b99bdd51af','29266081bf264ee18aad20d4882a428c','shares',0,0,NULL,NULL),('2025-10-01 17:07:32.415930','2025-10-01 17:08:30.154481','2025-10-01 17:08:33.409878',231,231,NULL,'29266081bf264ee18aad20d4882a428c','gigabytes',0,0,NULL,'97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:07:32.418018','2025-10-01 17:08:30.154482','2025-10-01 17:08:33.409878',232,232,NULL,'29266081bf264ee18aad20d4882a428c','shares',0,0,NULL,'97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:07:36.217272','2025-10-01 17:08:26.342832',NULL,0,233,'e660ba5c7b304e2abc80f9b99bdd51af','29266081bf264ee18aad20d4882a428c','snapshots',0,0,NULL,NULL),('2025-10-01 17:07:36.219941','2025-10-01 17:08:26.342834',NULL,0,234,'e660ba5c7b304e2abc80f9b99bdd51af','29266081bf264ee18aad20d4882a428c','snapshot_gigabytes',0,0,NULL,NULL),('2025-10-01 17:07:36.264229','2025-10-01 17:08:26.342836','2025-10-01 17:08:33.409878',235,235,NULL,'29266081bf264ee18aad20d4882a428c','snapshots',0,0,NULL,'97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:07:36.267123','2025-10-01 17:08:26.342837','2025-10-01 17:08:33.409878',236,236,NULL,'29266081bf264ee18aad20d4882a428c','snapshot_gigabytes',0,0,NULL,'97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:07:41.220328','2025-10-01 17:07:48.252990',NULL,0,237,'8395fbe4aa1a4d9bb181f7e321703f61','f63de858e3a74f88a78eaacea59850c5','share_groups',0,0,NULL,NULL),('2025-10-01 17:08:26.368511','2025-10-01 17:09:46.990776',NULL,0,238,'c6801335b5594dc38e737626407c353c','2d1156e4dd1a4bcf99d7af9680c3c563','shares',0,0,NULL,NULL),('2025-10-01 17:08:26.370485','2025-10-01 17:09:46.990779',NULL,0,239,'c6801335b5594dc38e737626407c353c','2d1156e4dd1a4bcf99d7af9680c3c563','gigabytes',0,0,NULL,NULL),('2025-10-01 17:08:26.379315','2025-10-01 17:09:46.990780','2025-10-01 17:09:50.097226',240,240,NULL,'2d1156e4dd1a4bcf99d7af9680c3c563','shares',0,0,NULL,'48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:08:26.381575','2025-10-01 17:09:46.990782','2025-10-01 17:09:50.097226',241,241,NULL,'2d1156e4dd1a4bcf99d7af9680c3c563','gigabytes',0,0,NULL,'48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:08:30.266271','2025-10-01 17:09:43.834697',NULL,0,242,'c6801335b5594dc38e737626407c353c','2d1156e4dd1a4bcf99d7af9680c3c563','snapshots',0,0,NULL,NULL),('2025-10-01 17:08:30.268656','2025-10-01 17:09:43.834699',NULL,0,243,'c6801335b5594dc38e737626407c353c','2d1156e4dd1a4bcf99d7af9680c3c563','snapshot_gigabytes',0,0,NULL,NULL),('2025-10-01 17:08:30.282879','2025-10-01 17:09:43.834701','2025-10-01 17:09:50.097226',244,244,NULL,'2d1156e4dd1a4bcf99d7af9680c3c563','snapshots',0,0,NULL,'48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:08:30.286095','2025-10-01 17:09:43.834702','2025-10-01 17:09:50.097226',245,245,NULL,'2d1156e4dd1a4bcf99d7af9680c3c563','snapshot_gigabytes',0,0,NULL,'48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:08:43.091669','2025-10-01 17:09:25.529013',NULL,0,246,'1bcf3990c34341488ff134d67569a00c','a942627ec05749c09a975132ee6031d6','shares',0,0,NULL,NULL),('2025-10-01 17:08:43.096366','2025-10-01 17:09:25.529019',NULL,0,247,'1bcf3990c34341488ff134d67569a00c','a942627ec05749c09a975132ee6031d6','gigabytes',0,0,NULL,NULL),('2025-10-01 17:08:43.105295','2025-10-01 17:09:25.529022','2025-10-01 17:09:27.302056',248,248,NULL,'a942627ec05749c09a975132ee6031d6','shares',0,0,NULL,'5207f340-b3fd-4fd8-95e5-1228cababcc3'),('2025-10-01 17:08:43.107578','2025-10-01 17:09:25.529025','2025-10-01 17:09:27.302056',249,249,NULL,'a942627ec05749c09a975132ee6031d6','gigabytes',0,0,NULL,'5207f340-b3fd-4fd8-95e5-1228cababcc3'),('2025-10-01 17:08:55.803814','2025-10-01 17:09:21.478963',NULL,0,250,'1bcf3990c34341488ff134d67569a00c','a942627ec05749c09a975132ee6031d6','snapshot_gigabytes',0,0,NULL,NULL),('2025-10-01 17:08:55.807403','2025-10-01 17:09:21.478966',NULL,0,251,'1bcf3990c34341488ff134d67569a00c','a942627ec05749c09a975132ee6031d6','snapshots',0,0,NULL,NULL),('2025-10-01 17:08:55.859178','2025-10-01 17:09:21.478968','2025-10-01 17:09:27.302056',252,252,NULL,'a942627ec05749c09a975132ee6031d6','snapshot_gigabytes',0,0,NULL,'5207f340-b3fd-4fd8-95e5-1228cababcc3'),('2025-10-01 17:08:55.861965','2025-10-01 17:09:21.478970','2025-10-01 17:09:27.302056',253,253,NULL,'a942627ec05749c09a975132ee6031d6','snapshots',0,0,NULL,'5207f340-b3fd-4fd8-95e5-1228cababcc3'),('2025-10-01 17:09:36.353670','2025-10-01 17:09:48.311754',NULL,0,254,'8535d97e92664479824a211407aa1fdc','0103e60cf08a41ecb4737770562548a5','gigabytes',0,0,NULL,NULL),('2025-10-01 17:09:36.355578','2025-10-01 17:09:48.311757',NULL,0,255,'8535d97e92664479824a211407aa1fdc','0103e60cf08a41ecb4737770562548a5','shares',0,0,NULL,NULL),('2025-10-01 17:09:36.362768','2025-10-01 17:09:48.311758','2025-10-01 17:09:51.459964',256,256,NULL,'0103e60cf08a41ecb4737770562548a5','gigabytes',0,0,NULL,'b2b70e19-2ae4-4aea-be0a-96f3e01586b6'),('2025-10-01 17:09:36.364477','2025-10-01 17:09:48.311759','2025-10-01 17:09:51.459964',257,257,NULL,'0103e60cf08a41ecb4737770562548a5','shares',0,0,NULL,'b2b70e19-2ae4-4aea-be0a-96f3e01586b6'),('2025-10-01 17:09:39.808580','2025-10-01 17:09:45.411439',NULL,0,258,'8535d97e92664479824a211407aa1fdc','0103e60cf08a41ecb4737770562548a5','snapshots',0,0,NULL,NULL),('2025-10-01 17:09:39.815110','2025-10-01 17:09:45.411443',NULL,0,259,'8535d97e92664479824a211407aa1fdc','0103e60cf08a41ecb4737770562548a5','snapshot_gigabytes',0,0,NULL,NULL),('2025-10-01 17:09:39.836422','2025-10-01 17:09:45.411445','2025-10-01 17:09:51.459964',260,260,NULL,'0103e60cf08a41ecb4737770562548a5','snapshots',0,0,NULL,'b2b70e19-2ae4-4aea-be0a-96f3e01586b6'),('2025-10-01 17:09:39.838767','2025-10-01 17:09:45.411447','2025-10-01 17:09:51.459964',261,261,NULL,'0103e60cf08a41ecb4737770562548a5','snapshot_gigabytes',0,0,NULL,'b2b70e19-2ae4-4aea-be0a-96f3e01586b6'),('2025-10-01 17:09:58.992220','2025-10-01 17:10:11.093464',NULL,0,262,'7b4f3ac1db9d4257ad4205e53cd20033','e168bce9fe04489288d3480d858b4158','gigabytes',0,0,NULL,NULL),('2025-10-01 17:09:58.996163','2025-10-01 17:10:11.093468',NULL,0,263,'7b4f3ac1db9d4257ad4205e53cd20033','e168bce9fe04489288d3480d858b4158','shares',0,0,NULL,NULL),('2025-10-01 17:09:59.008312','2025-10-01 17:10:11.093470','2025-10-01 17:10:14.188009',264,264,NULL,'e168bce9fe04489288d3480d858b4158','gigabytes',0,0,NULL,'4f903460-2d3d-42ea-bed9-eacdc72380eb'),('2025-10-01 17:09:59.010473','2025-10-01 17:10:11.093472','2025-10-01 17:10:14.188009',265,265,NULL,'e168bce9fe04489288d3480d858b4158','shares',0,0,NULL,'4f903460-2d3d-42ea-bed9-eacdc72380eb'),('2025-10-01 17:10:02.401787','2025-10-01 17:10:07.713892',NULL,0,266,'7b4f3ac1db9d4257ad4205e53cd20033','e168bce9fe04489288d3480d858b4158','snapshot_gigabytes',0,0,NULL,NULL),('2025-10-01 17:10:02.404157','2025-10-01 17:10:07.713895',NULL,0,267,'7b4f3ac1db9d4257ad4205e53cd20033','e168bce9fe04489288d3480d858b4158','snapshots',0,0,NULL,NULL),('2025-10-01 17:10:02.417162','2025-10-01 17:10:07.713897','2025-10-01 17:10:14.188009',268,268,NULL,'e168bce9fe04489288d3480d858b4158','snapshot_gigabytes',0,0,NULL,'4f903460-2d3d-42ea-bed9-eacdc72380eb'),('2025-10-01 17:10:02.419928','2025-10-01 17:10:07.713899','2025-10-01 17:10:14.188009',269,269,NULL,'e168bce9fe04489288d3480d858b4158','snapshots',0,0,NULL,'4f903460-2d3d-42ea-bed9-eacdc72380eb');
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
INSERT INTO `quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `project_id`, `resource`, `hard_limit`) VALUES (1,'2025-10-01 17:00:14.874290',NULL,'2025-10-01 17:00:15.240024',1,'1f4a5d54519f4f46897a6eba8668a5c4','shares',1),(2,'2025-10-01 17:00:19.719566',NULL,'2025-10-01 17:00:23.773073',2,'1f4a5d54519f4f46897a6eba8668a5c4','snapshots',1),(3,'2025-10-01 17:00:30.618654',NULL,'2025-10-01 17:00:30.794896',3,'1f4a5d54519f4f46897a6eba8668a5c4','shares',10),(4,'2025-10-01 17:00:31.028767',NULL,'2025-10-01 17:00:31.254088',4,'1f4a5d54519f4f46897a6eba8668a5c4','shares',10),(5,'2025-10-01 17:02:50.512749',NULL,'2025-10-01 17:03:08.589739',5,'a307fd4b882d45898ca085500fbf65b4','shares',3),(6,'2025-10-01 17:02:50.527688',NULL,'2025-10-01 17:03:08.589739',6,'a307fd4b882d45898ca085500fbf65b4','gigabytes',10),(7,'2025-10-01 17:03:09.015346',NULL,'2025-10-01 17:03:09.453887',7,'a307fd4b882d45898ca085500fbf65b4','shares',55),(8,'2025-10-01 17:03:09.023279',NULL,'2025-10-01 17:03:09.453887',8,'a307fd4b882d45898ca085500fbf65b4','snapshots',55),(9,'2025-10-01 17:03:09.027069',NULL,'2025-10-01 17:03:09.453887',9,'a307fd4b882d45898ca085500fbf65b4','gigabytes',1005),(10,'2025-10-01 17:03:09.030746',NULL,'2025-10-01 17:03:09.453887',10,'a307fd4b882d45898ca085500fbf65b4','snapshot_gigabytes',1005),(11,'2025-10-01 17:03:09.035939',NULL,'2025-10-01 17:03:09.453887',11,'a307fd4b882d45898ca085500fbf65b4','share_replicas',105),(12,'2025-10-01 17:03:09.041158',NULL,'2025-10-01 17:03:09.453887',12,'a307fd4b882d45898ca085500fbf65b4','replica_gigabytes',1005),(13,'2025-10-01 17:03:09.710081',NULL,'2025-10-01 17:03:10.224498',13,'a307fd4b882d45898ca085500fbf65b4','shares',55),(14,'2025-10-01 17:03:09.713501',NULL,'2025-10-01 17:03:10.224498',14,'a307fd4b882d45898ca085500fbf65b4','snapshots',55),(15,'2025-10-01 17:03:09.717030',NULL,'2025-10-01 17:03:10.224498',15,'a307fd4b882d45898ca085500fbf65b4','gigabytes',1005),(16,'2025-10-01 17:03:09.725989',NULL,'2025-10-01 17:03:10.224498',16,'a307fd4b882d45898ca085500fbf65b4','snapshot_gigabytes',1005),(17,'2025-10-01 17:03:09.730562',NULL,'2025-10-01 17:03:10.224498',17,'a307fd4b882d45898ca085500fbf65b4','share_replicas',105),(18,'2025-10-01 17:03:09.736608',NULL,'2025-10-01 17:03:10.224498',18,'a307fd4b882d45898ca085500fbf65b4','replica_gigabytes',1005),(19,'2025-10-01 17:03:10.447116',NULL,'2025-10-01 17:03:10.589998',19,'a307fd4b882d45898ca085500fbf65b4','shares',52),(20,'2025-10-01 17:03:10.452196',NULL,'2025-10-01 17:03:10.589998',20,'a307fd4b882d45898ca085500fbf65b4','snapshots',52),(21,'2025-10-01 17:03:10.457214',NULL,'2025-10-01 17:03:10.589998',21,'a307fd4b882d45898ca085500fbf65b4','gigabytes',1002),(22,'2025-10-01 17:03:10.460296',NULL,'2025-10-01 17:03:10.589998',22,'a307fd4b882d45898ca085500fbf65b4','snapshot_gigabytes',1002),(23,'2025-10-01 17:03:10.466890',NULL,'2025-10-01 17:03:10.589998',23,'a307fd4b882d45898ca085500fbf65b4','share_networks',12),(24,'2025-10-01 17:03:10.471758',NULL,'2025-10-01 17:03:10.589998',24,'a307fd4b882d45898ca085500fbf65b4','share_replicas',102),(25,'2025-10-01 17:03:10.474564',NULL,'2025-10-01 17:03:10.589998',25,'a307fd4b882d45898ca085500fbf65b4','replica_gigabytes',1002),(26,'2025-10-01 17:03:10.801963',NULL,'2025-10-01 17:03:11.229517',26,'a307fd4b882d45898ca085500fbf65b4','shares',13),(27,'2025-10-01 17:03:11.323097',NULL,'2025-10-01 17:03:11.449248',27,'a307fd4b882d45898ca085500fbf65b4','gigabytes',-1),(28,'2025-10-01 17:03:11.520806',NULL,'2025-10-01 17:03:11.646624',28,'a307fd4b882d45898ca085500fbf65b4','share_replicas',-1),(29,'2025-10-01 17:03:11.726553',NULL,'2025-10-01 17:03:11.837419',29,'a307fd4b882d45898ca085500fbf65b4','replica_gigabytes',-1),(30,'2025-10-01 17:03:12.058170',NULL,'2025-10-01 17:03:12.292783',30,'a307fd4b882d45898ca085500fbf65b4','share_networks',-1),(31,'2025-10-01 17:03:12.401675',NULL,'2025-10-01 17:03:12.706291',31,'a307fd4b882d45898ca085500fbf65b4','shares',-1),(32,'2025-10-01 17:03:12.820865',NULL,'2025-10-01 17:03:13.056164',32,'a307fd4b882d45898ca085500fbf65b4','snapshot_gigabytes',-1),(33,'2025-10-01 17:03:13.138531',NULL,'2025-10-01 17:03:13.288515',33,'a307fd4b882d45898ca085500fbf65b4','snapshots',-1),(34,'2025-10-01 17:03:18.001348',NULL,'2025-10-01 17:03:18.190392',34,'a307fd4b882d45898ca085500fbf65b4','shares',10),(35,'2025-10-01 17:03:18.450289',NULL,'2025-10-01 17:03:18.652859',35,'a307fd4b882d45898ca085500fbf65b4','shares',10),(36,'2025-10-01 17:03:18.797846',NULL,'2025-10-01 17:03:18.854529',36,'a307fd4b882d45898ca085500fbf65b4','gigabytes',1002),(37,'2025-10-01 17:03:18.987155',NULL,'2025-10-01 17:03:19.147123',37,'a307fd4b882d45898ca085500fbf65b4','share_networks',12),(38,'2025-10-01 17:03:19.311737',NULL,'2025-10-01 17:03:19.373372',38,'a307fd4b882d45898ca085500fbf65b4','shares',52),(39,'2025-10-01 17:03:19.512823',NULL,'2025-10-01 17:03:19.574700',39,'a307fd4b882d45898ca085500fbf65b4','snapshot_gigabytes',1002),(40,'2025-10-01 17:03:19.735202',NULL,'2025-10-01 17:03:19.864839',40,'a307fd4b882d45898ca085500fbf65b4','snapshots',52),(41,'2025-10-01 17:03:20.282953',NULL,'2025-10-01 17:03:20.401683',41,'a307fd4b882d45898ca085500fbf65b4','share_replicas',99),(42,'2025-10-01 17:03:20.736516',NULL,'2025-10-01 17:03:20.861377',42,'a307fd4b882d45898ca085500fbf65b4','replica_gigabytes',999),(43,'2025-10-01 17:03:22.563789',NULL,'2025-10-01 17:03:22.821748',43,'a307fd4b882d45898ca085500fbf65b4','shares',10),(44,'2025-10-01 17:03:22.924640',NULL,'2025-10-01 17:03:23.155237',44,'a307fd4b882d45898ca085500fbf65b4','shares',10);
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `usage_id` (`usage_id`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=976 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `share_type_id`) VALUES ('2025-10-01 17:00:13.490201',NULL,'2025-10-01 17:00:13.691945',1,1,'f01d6292274540ac84c2c1da0ccbaedb','9838838b-01c3-4e2a-bf04-658a73dd2cd2',2,'2204ae41373c4a57a26d8e752f9c9721','shares',1,'2025-10-02 17:00:13',NULL),('2025-10-01 17:00:13.492542',NULL,'2025-10-01 17:00:13.691945',2,2,'f01d6292274540ac84c2c1da0ccbaedb','5e7a3239-cd9d-49a2-ba29-a78ec18163e3',1,'2204ae41373c4a57a26d8e752f9c9721','gigabytes',1,'2025-10-02 17:00:13',NULL),('2025-10-01 17:00:13.554519',NULL,'2025-10-01 17:00:13.691945',3,3,NULL,'ca83cba3-64e7-4a09-bcaf-2103396b66d6',4,'2204ae41373c4a57a26d8e752f9c9721','shares',1,'2025-10-02 17:00:13','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:00:13.555852',NULL,'2025-10-01 17:00:13.691945',4,4,NULL,'308cf151-1833-48b1-9dc8-66010f91e0ca',3,'2204ae41373c4a57a26d8e752f9c9721','gigabytes',1,'2025-10-02 17:00:13','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:00:13.902539',NULL,'2025-10-01 17:00:14.088260',5,5,'0c2a887dd4a845859f0669eb83fe675c','a1a1aeff-73c4-434a-88b8-7698a6c14814',5,'1f4a5d54519f4f46897a6eba8668a5c4','shares',1,'2025-10-02 17:00:13',NULL),('2025-10-01 17:00:13.906482',NULL,'2025-10-01 17:00:14.088260',6,6,'0c2a887dd4a845859f0669eb83fe675c','dce38824-49c1-445e-8009-508955c36721',6,'1f4a5d54519f4f46897a6eba8668a5c4','gigabytes',1,'2025-10-02 17:00:13',NULL),('2025-10-01 17:00:13.952388',NULL,'2025-10-01 17:00:14.088260',7,7,NULL,'1cd259f4-3b41-430b-980a-d6e1f7416b13',7,'1f4a5d54519f4f46897a6eba8668a5c4','shares',1,'2025-10-02 17:00:13','eeda9f95-f5c3-4f07-b12e-0b18f7c8da37'),('2025-10-01 17:00:13.953400',NULL,'2025-10-01 17:00:14.088260',8,8,NULL,'3f717e16-d2f1-42ab-be81-ed2755a3ccb0',8,'1f4a5d54519f4f46897a6eba8668a5c4','gigabytes',1,'2025-10-02 17:00:13','eeda9f95-f5c3-4f07-b12e-0b18f7c8da37'),('2025-10-01 17:00:15.910857',NULL,'2025-10-01 17:00:16.166647',9,9,'0c2a887dd4a845859f0669eb83fe675c','1f85a46c-47c6-49bb-a891-49331152e229',10,'1f4a5d54519f4f46897a6eba8668a5c4','shares',1,'2025-10-02 17:00:15',NULL),('2025-10-01 17:00:15.912364',NULL,'2025-10-01 17:00:16.166647',10,10,'0c2a887dd4a845859f0669eb83fe675c','d4dfc2a2-2ce2-44f0-b3bc-2fb8fe4bff60',9,'1f4a5d54519f4f46897a6eba8668a5c4','gigabytes',1,'2025-10-02 17:00:15',NULL),('2025-10-01 17:00:15.983298',NULL,'2025-10-01 17:00:16.166647',11,11,NULL,'0031b069-65e8-4ca0-966c-f7a40fb71579',11,'1f4a5d54519f4f46897a6eba8668a5c4','shares',1,'2025-10-02 17:00:15','9a2a36a8-eb90-44b3-beb1-6fa464aeb5a0'),('2025-10-01 17:00:15.984757',NULL,'2025-10-01 17:00:16.166647',12,12,NULL,'bb3b31d3-fcca-47e9-adb5-aa53b64a909e',12,'1f4a5d54519f4f46897a6eba8668a5c4','gigabytes',1,'2025-10-02 17:00:15','9a2a36a8-eb90-44b3-beb1-6fa464aeb5a0'),('2025-10-01 17:00:17.504854',NULL,'2025-10-01 17:00:17.703491',13,13,'795436ca4abe4e0e8da2ee3bc5b1dbda','7cb84426-1b21-422c-8443-5b50aee499b3',14,'85a428afb52742d3b601161e8821da9f','shares',1,'2025-10-02 17:00:17',NULL),('2025-10-01 17:00:17.506730',NULL,'2025-10-01 17:00:17.703491',14,14,'795436ca4abe4e0e8da2ee3bc5b1dbda','e4b04b5b-f377-4cb7-819a-9fac642c7025',13,'85a428afb52742d3b601161e8821da9f','gigabytes',1,'2025-10-02 17:00:17',NULL),('2025-10-01 17:00:17.543542',NULL,'2025-10-01 17:00:17.922160',15,15,'f01d6292274540ac84c2c1da0ccbaedb','08423553-c9fa-4c29-95c1-08f03d8bc7af',2,'2204ae41373c4a57a26d8e752f9c9721','shares',1,'2025-10-02 17:00:17',NULL),('2025-10-01 17:00:17.547449',NULL,'2025-10-01 17:00:17.922160',16,16,'f01d6292274540ac84c2c1da0ccbaedb','939e2c51-b7d7-4338-8ae9-e1d2eca02ebe',1,'2204ae41373c4a57a26d8e752f9c9721','gigabytes',1,'2025-10-02 17:00:17',NULL),('2025-10-01 17:00:17.572481',NULL,'2025-10-01 17:00:17.703491',17,17,NULL,'ccd5a7fe-d858-4023-85b7-9db1abc7af5a',16,'85a428afb52742d3b601161e8821da9f','shares',1,'2025-10-02 17:00:17','fc0b7d99-26ca-4334-8407-02cec26a8f38'),('2025-10-01 17:00:17.574265',NULL,'2025-10-01 17:00:17.703491',18,18,NULL,'3db8e4f9-f79e-44ae-9eca-60331a412f63',15,'85a428afb52742d3b601161e8821da9f','gigabytes',1,'2025-10-02 17:00:17','fc0b7d99-26ca-4334-8407-02cec26a8f38'),('2025-10-01 17:00:17.585214',NULL,'2025-10-01 17:00:17.922160',19,19,NULL,'71fda93b-9f99-46eb-8a7a-dcad69370c12',4,'2204ae41373c4a57a26d8e752f9c9721','shares',1,'2025-10-02 17:00:17','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:00:17.590870',NULL,'2025-10-01 17:00:17.922160',20,20,NULL,'71faf736-bdc5-4ac3-abb4-6d0700bf3ffd',3,'2204ae41373c4a57a26d8e752f9c9721','gigabytes',1,'2025-10-02 17:00:17','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:00:19.863777',NULL,'2025-10-01 17:00:20.038825',21,21,'0c2a887dd4a845859f0669eb83fe675c','d234f280-4ecb-4465-936e-493cbad16db4',17,'1f4a5d54519f4f46897a6eba8668a5c4','snapshots',1,'2025-10-02 17:00:19',NULL),('2025-10-01 17:00:19.864958',NULL,'2025-10-01 17:00:20.038825',22,22,'0c2a887dd4a845859f0669eb83fe675c','5df6660a-0c0b-4339-9f4f-9ed2a8739751',18,'1f4a5d54519f4f46897a6eba8668a5c4','snapshot_gigabytes',1,'2025-10-02 17:00:19',NULL),('2025-10-01 17:00:19.902691',NULL,'2025-10-01 17:00:20.038825',23,23,NULL,'dc008223-8769-41c6-aa0a-3e32db4e3f09',19,'1f4a5d54519f4f46897a6eba8668a5c4','snapshots',1,'2025-10-02 17:00:19','9a2a36a8-eb90-44b3-beb1-6fa464aeb5a0'),('2025-10-01 17:00:19.903709',NULL,'2025-10-01 17:00:20.038825',24,24,NULL,'2e2689ab-a61f-4b51-b7e4-de9358624e93',20,'1f4a5d54519f4f46897a6eba8668a5c4','snapshot_gigabytes',1,'2025-10-02 17:00:19','9a2a36a8-eb90-44b3-beb1-6fa464aeb5a0'),('2025-10-01 17:00:21.674311',NULL,'2025-10-01 17:00:21.780632',25,25,'f01d6292274540ac84c2c1da0ccbaedb','ebeade60-ed29-4cc8-8663-0277e37e578b',1,'2204ae41373c4a57a26d8e752f9c9721','gigabytes',1,'2025-10-02 17:00:21',NULL),('2025-10-01 17:00:21.681697',NULL,'2025-10-01 17:00:21.780632',26,26,NULL,'59e0848e-67f3-404d-994a-e5ff64368c04',3,'2204ae41373c4a57a26d8e752f9c9721','gigabytes',1,'2025-10-02 17:00:21','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:00:23.097785',NULL,'2025-10-01 17:00:23.124201',27,27,'f01d6292274540ac84c2c1da0ccbaedb','585c9752-f568-4fc4-b192-5409d276844e',2,'2204ae41373c4a57a26d8e752f9c9721','shares',-1,'2025-10-02 17:00:23',NULL),('2025-10-01 17:00:23.100330',NULL,'2025-10-01 17:00:23.124201',28,28,'f01d6292274540ac84c2c1da0ccbaedb','b5600312-fdb4-42b1-b7c4-a5f7478cd9a9',1,'2204ae41373c4a57a26d8e752f9c9721','gigabytes',-2,'2025-10-02 17:00:23',NULL),('2025-10-01 17:00:23.111319',NULL,'2025-10-01 17:00:23.124201',29,29,NULL,'6a9c517a-fc81-4bda-86b7-a3a69b56e596',4,'2204ae41373c4a57a26d8e752f9c9721','shares',-1,'2025-10-02 17:00:23','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:00:23.112298',NULL,'2025-10-01 17:00:23.124201',30,30,NULL,'4ed91447-f77f-4ad6-bf13-db63a7e8c4b6',3,'2204ae41373c4a57a26d8e752f9c9721','gigabytes',-2,'2025-10-02 17:00:23','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:00:24.939147',NULL,'2025-10-01 17:00:24.975502',31,31,'795436ca4abe4e0e8da2ee3bc5b1dbda','8ea86c35-761e-4652-beac-a407eedfeaf7',14,'85a428afb52742d3b601161e8821da9f','shares',-1,'2025-10-02 17:00:24',NULL),('2025-10-01 17:00:24.939890',NULL,'2025-10-01 17:00:24.975502',32,32,'795436ca4abe4e0e8da2ee3bc5b1dbda','3d9283d6-b02e-4042-b47f-5d2f10caf41c',13,'85a428afb52742d3b601161e8821da9f','gigabytes',-1,'2025-10-02 17:00:24',NULL),('2025-10-01 17:00:24.963619',NULL,'2025-10-01 17:00:24.975502',33,33,NULL,'c1a82d6a-fc4b-4a35-ac0b-ff27bcd9e5e3',16,'85a428afb52742d3b601161e8821da9f','shares',-1,'2025-10-02 17:00:24','fc0b7d99-26ca-4334-8407-02cec26a8f38'),('2025-10-01 17:00:24.964450',NULL,'2025-10-01 17:00:24.975502',34,34,NULL,'6494de66-7640-41cb-9d19-f3d71fb1fe92',15,'85a428afb52742d3b601161e8821da9f','gigabytes',-1,'2025-10-02 17:00:24','fc0b7d99-26ca-4334-8407-02cec26a8f38'),('2025-10-01 17:00:26.167255',NULL,'2025-10-01 17:00:26.213851',35,35,'f01d6292274540ac84c2c1da0ccbaedb','2b40ac92-2309-4395-bed4-6961bee56059',2,'2204ae41373c4a57a26d8e752f9c9721','shares',1,'2025-10-02 17:00:26',NULL),('2025-10-01 17:00:26.168445',NULL,'2025-10-01 17:00:26.213851',36,36,'f01d6292274540ac84c2c1da0ccbaedb','69258d99-813b-44e7-bc19-9a1ba89612c4',1,'2204ae41373c4a57a26d8e752f9c9721','gigabytes',1,'2025-10-02 17:00:26',NULL),('2025-10-01 17:00:26.176416',NULL,'2025-10-01 17:00:26.213851',37,37,NULL,'41cffe0c-568d-415d-90ca-b274512392e8',4,'2204ae41373c4a57a26d8e752f9c9721','shares',1,'2025-10-02 17:00:26','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:00:26.178513',NULL,'2025-10-01 17:00:26.213851',38,38,NULL,'96de0b60-0f60-4137-b50a-7758fa4313f7',3,'2204ae41373c4a57a26d8e752f9c9721','gigabytes',1,'2025-10-02 17:00:26','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:00:29.609034',NULL,'2025-10-01 17:00:29.984112',39,39,'f01d6292274540ac84c2c1da0ccbaedb','3077d52d-0861-448f-815c-71b1efa93fd4',1,'2204ae41373c4a57a26d8e752f9c9721','gigabytes',1,'2025-10-02 17:00:29',NULL),('2025-10-01 17:00:29.615201',NULL,'2025-10-01 17:00:29.984112',40,40,NULL,'9a1b6f30-6f77-456b-9806-32ac4372c23e',3,'2204ae41373c4a57a26d8e752f9c9721','gigabytes',1,'2025-10-02 17:00:29','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:00:33.607896',NULL,'2025-10-01 17:00:33.627851',41,41,'f01d6292274540ac84c2c1da0ccbaedb','b37ce7e6-bb21-4324-b4ed-ce95919f878d',2,'2204ae41373c4a57a26d8e752f9c9721','shares',-1,'2025-10-02 17:00:33',NULL),('2025-10-01 17:00:33.609408',NULL,'2025-10-01 17:00:33.627851',42,42,'f01d6292274540ac84c2c1da0ccbaedb','12b65527-69e0-4bbc-896f-1cbc7c012259',1,'2204ae41373c4a57a26d8e752f9c9721','gigabytes',-2,'2025-10-02 17:00:33',NULL),('2025-10-01 17:00:33.617084',NULL,'2025-10-01 17:00:33.627851',43,43,NULL,'4d0df26c-e83f-4450-bf0b-1ec7cd995469',4,'2204ae41373c4a57a26d8e752f9c9721','shares',-1,'2025-10-02 17:00:33','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:00:33.617696',NULL,'2025-10-01 17:00:33.627851',44,44,NULL,'4516e64b-fb6c-4ee8-b863-705ec454cfed',3,'2204ae41373c4a57a26d8e752f9c9721','gigabytes',-2,'2025-10-02 17:00:33','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:00:35.094800',NULL,'2025-10-01 17:00:35.121505',45,45,'0c2a887dd4a845859f0669eb83fe675c','814266f1-0910-4092-83d2-035e0bac8d7f',22,'1f4a5d54519f4f46897a6eba8668a5c4','snapshots',-1,'2025-10-02 17:00:35',NULL),('2025-10-01 17:00:35.096137',NULL,'2025-10-01 17:00:35.121505',46,46,'0c2a887dd4a845859f0669eb83fe675c','e3d24b46-9401-4bfd-936c-6c5e5fda7690',21,'1f4a5d54519f4f46897a6eba8668a5c4','snapshot_gigabytes',-1,'2025-10-02 17:00:35',NULL),('2025-10-01 17:00:35.112763',NULL,'2025-10-01 17:00:35.121505',47,47,NULL,'94074188-fdff-4a9d-a17b-e4a5d2481628',24,'1f4a5d54519f4f46897a6eba8668a5c4','snapshots',-1,'2025-10-02 17:00:35','9a2a36a8-eb90-44b3-beb1-6fa464aeb5a0'),('2025-10-01 17:00:35.113629',NULL,'2025-10-01 17:00:35.121505',48,48,NULL,'42d4523d-48e6-4772-aa7d-509211365ef0',23,'1f4a5d54519f4f46897a6eba8668a5c4','snapshot_gigabytes',-1,'2025-10-02 17:00:35','9a2a36a8-eb90-44b3-beb1-6fa464aeb5a0'),('2025-10-01 17:00:36.117326',NULL,'2025-10-01 17:00:36.161410',49,49,'df0b2d6216a142dc92cd2a29e14daf63','922fee5d-c91a-44cb-9d7c-94e39de425cd',25,'3b070cbc3e9f4af28b0758b866474914','shares',1,'2025-10-02 17:00:36',NULL),('2025-10-01 17:00:36.118550',NULL,'2025-10-01 17:00:36.161410',50,50,'df0b2d6216a142dc92cd2a29e14daf63','d7a468bb-2ff5-454e-8af3-20d9d6a29264',26,'3b070cbc3e9f4af28b0758b866474914','gigabytes',1,'2025-10-02 17:00:36',NULL),('2025-10-01 17:00:36.133496',NULL,'2025-10-01 17:00:36.161410',51,51,NULL,'74c64fe4-42d8-47d2-9e0f-6cc2a9288643',27,'3b070cbc3e9f4af28b0758b866474914','shares',1,'2025-10-02 17:00:36','e8d8a1fc-ec5d-43c2-aabc-ffea9e499c55'),('2025-10-01 17:00:36.135153',NULL,'2025-10-01 17:00:36.161410',52,52,NULL,'4795d68e-ff31-4c59-be2d-40e5cbf3599a',28,'3b070cbc3e9f4af28b0758b866474914','gigabytes',1,'2025-10-02 17:00:36','e8d8a1fc-ec5d-43c2-aabc-ffea9e499c55'),('2025-10-01 17:00:36.738316',NULL,'2025-10-01 17:00:36.770496',53,53,'f01d6292274540ac84c2c1da0ccbaedb','5ec8f502-cd39-4490-83c6-e0836133a1cc',2,'2204ae41373c4a57a26d8e752f9c9721','shares',1,'2025-10-02 17:00:36',NULL),('2025-10-01 17:00:36.739604',NULL,'2025-10-01 17:00:36.770496',54,54,'f01d6292274540ac84c2c1da0ccbaedb','f9a98dbc-5946-41f0-a772-3bdf6982e875',1,'2204ae41373c4a57a26d8e752f9c9721','gigabytes',1,'2025-10-02 17:00:36',NULL),('2025-10-01 17:00:36.750368',NULL,'2025-10-01 17:00:36.770496',55,55,NULL,'031b5700-ef85-41f2-bcb1-b2daed14c01c',4,'2204ae41373c4a57a26d8e752f9c9721','shares',1,'2025-10-02 17:00:36','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:00:36.751442',NULL,'2025-10-01 17:00:36.770496',56,56,NULL,'68347cce-9429-4ff3-a943-931923b04140',3,'2204ae41373c4a57a26d8e752f9c9721','gigabytes',1,'2025-10-02 17:00:36','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:00:38.481647',NULL,'2025-10-01 17:00:38.502246',57,57,'0c2a887dd4a845859f0669eb83fe675c','277717b7-0e07-47b4-a1de-887345d23ea9',30,'1f4a5d54519f4f46897a6eba8668a5c4','shares',-1,'2025-10-02 17:00:38',NULL),('2025-10-01 17:00:38.482360',NULL,'2025-10-01 17:00:38.502246',58,58,'0c2a887dd4a845859f0669eb83fe675c','b42f5910-94dc-4246-8b44-1591ff94ba2c',29,'1f4a5d54519f4f46897a6eba8668a5c4','gigabytes',-1,'2025-10-02 17:00:38',NULL),('2025-10-01 17:00:38.494659',NULL,'2025-10-01 17:00:38.502246',59,59,NULL,'0196c4bd-e0d1-405c-8557-867b10110fe0',32,'1f4a5d54519f4f46897a6eba8668a5c4','shares',-1,'2025-10-02 17:00:38','9a2a36a8-eb90-44b3-beb1-6fa464aeb5a0'),('2025-10-01 17:00:38.495271',NULL,'2025-10-01 17:00:38.502246',60,60,NULL,'3e478245-b111-4466-8b5f-a210d13c52f0',31,'1f4a5d54519f4f46897a6eba8668a5c4','gigabytes',-1,'2025-10-02 17:00:38','9a2a36a8-eb90-44b3-beb1-6fa464aeb5a0'),('2025-10-01 17:00:40.689580',NULL,'2025-10-01 17:00:40.725317',61,61,'f01d6292274540ac84c2c1da0ccbaedb','c9f91cf1-2ce4-4507-96d5-accd37bf6ee5',2,'2204ae41373c4a57a26d8e752f9c9721','shares',-1,'2025-10-02 17:00:40',NULL),('2025-10-01 17:00:40.690523',NULL,'2025-10-01 17:00:40.725317',62,62,'f01d6292274540ac84c2c1da0ccbaedb','eab297a2-3242-4039-8b70-b5e9ecddcb02',1,'2204ae41373c4a57a26d8e752f9c9721','gigabytes',-1,'2025-10-02 17:00:40',NULL),('2025-10-01 17:00:40.705943',NULL,'2025-10-01 17:00:40.725317',63,63,NULL,'614099b6-5ca5-4359-b127-eb47dbc25def',4,'2204ae41373c4a57a26d8e752f9c9721','shares',-1,'2025-10-02 17:00:40','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:00:40.706704',NULL,'2025-10-01 17:00:40.725317',64,64,NULL,'6140e500-0c1b-4cbd-8061-e4b4b6db0433',3,'2204ae41373c4a57a26d8e752f9c9721','gigabytes',-1,'2025-10-02 17:00:40','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:00:40.782354',NULL,'2025-10-01 17:00:40.816634',65,65,'aff16e38eefd4e66b0b620d67bc65d6e','5d2729cd-f6ac-4e25-8404-06f9a0498f42',34,'efef7d21275549538c8a121a0599e3f4','shares',1,'2025-10-02 17:00:40',NULL),('2025-10-01 17:00:40.783687',NULL,'2025-10-01 17:00:40.816634',66,66,'aff16e38eefd4e66b0b620d67bc65d6e','39d23c9a-51b2-49ad-9916-05653fa894e5',33,'efef7d21275549538c8a121a0599e3f4','gigabytes',1,'2025-10-02 17:00:40',NULL),('2025-10-01 17:00:40.793005',NULL,'2025-10-01 17:00:40.816634',67,67,NULL,'05d80cca-0a2f-4650-a597-dcac82b62788',36,'efef7d21275549538c8a121a0599e3f4','shares',1,'2025-10-02 17:00:40','3ec8827a-3829-4912-bb29-3f95aeb0ed67'),('2025-10-01 17:00:40.794339',NULL,'2025-10-01 17:00:40.816634',68,68,NULL,'717d1e9f-69c8-40ef-be93-56461d7b43bf',35,'efef7d21275549538c8a121a0599e3f4','gigabytes',1,'2025-10-02 17:00:40','3ec8827a-3829-4912-bb29-3f95aeb0ed67'),('2025-10-01 17:00:42.172966',NULL,'2025-10-01 17:00:42.242968',69,69,'df0b2d6216a142dc92cd2a29e14daf63','2abcc89a-0d6b-412c-a5d1-d26ca5bcd998',25,'3b070cbc3e9f4af28b0758b866474914','shares',-1,'2025-10-02 17:00:42',NULL),('2025-10-01 17:00:42.177024',NULL,'2025-10-01 17:00:42.242968',70,70,'df0b2d6216a142dc92cd2a29e14daf63','66a2006e-ff58-4e32-9ff4-b590e6aa33eb',26,'3b070cbc3e9f4af28b0758b866474914','gigabytes',-1,'2025-10-02 17:00:42',NULL),('2025-10-01 17:00:42.205983',NULL,'2025-10-01 17:00:42.242968',71,71,NULL,'4d9cc7e8-39a6-4e5f-b297-4f0bd6259e48',27,'3b070cbc3e9f4af28b0758b866474914','shares',-1,'2025-10-02 17:00:42','e8d8a1fc-ec5d-43c2-aabc-ffea9e499c55'),('2025-10-01 17:00:42.207869',NULL,'2025-10-01 17:00:42.242968',72,72,NULL,'3379f0d4-1588-4a52-b68d-57f2f0950295',28,'3b070cbc3e9f4af28b0758b866474914','gigabytes',-1,'2025-10-02 17:00:42','e8d8a1fc-ec5d-43c2-aabc-ffea9e499c55'),('2025-10-01 17:00:42.269613',NULL,'2025-10-01 17:00:42.291822',73,73,'0c2a887dd4a845859f0669eb83fe675c','5f500bfd-bb03-45e7-acc1-7fa9495ef86a',30,'1f4a5d54519f4f46897a6eba8668a5c4','shares',-1,'2025-10-02 17:00:42',NULL),('2025-10-01 17:00:42.270282',NULL,'2025-10-01 17:00:42.291822',74,74,'0c2a887dd4a845859f0669eb83fe675c','c4cf9b7c-6284-465c-aff3-85a4542f94fb',29,'1f4a5d54519f4f46897a6eba8668a5c4','gigabytes',-1,'2025-10-02 17:00:42',NULL),('2025-10-01 17:00:42.283058',NULL,'2025-10-01 17:00:42.291822',75,75,NULL,'7cc2646e-52b1-4d56-9915-14fd7890b9e4',38,'1f4a5d54519f4f46897a6eba8668a5c4','shares',-1,'2025-10-02 17:00:42','eeda9f95-f5c3-4f07-b12e-0b18f7c8da37'),('2025-10-01 17:00:42.283715',NULL,'2025-10-01 17:00:42.291822',76,76,NULL,'f8749005-0ab5-45c9-8919-fd4bb08e60cc',37,'1f4a5d54519f4f46897a6eba8668a5c4','gigabytes',-1,'2025-10-02 17:00:42','eeda9f95-f5c3-4f07-b12e-0b18f7c8da37'),('2025-10-01 17:00:43.885615',NULL,'2025-10-01 17:00:43.913670',77,77,'f01d6292274540ac84c2c1da0ccbaedb','2b04225f-b8e9-4639-befb-8a617fa13eda',2,'2204ae41373c4a57a26d8e752f9c9721','shares',1,'2025-10-02 17:00:43',NULL),('2025-10-01 17:00:43.887199',NULL,'2025-10-01 17:00:43.913670',78,78,'f01d6292274540ac84c2c1da0ccbaedb','b7471140-5c06-4d95-b34b-644fb290d614',1,'2204ae41373c4a57a26d8e752f9c9721','gigabytes',1,'2025-10-02 17:00:43',NULL),('2025-10-01 17:00:43.893943',NULL,'2025-10-01 17:00:43.913670',79,79,NULL,'7af6783a-f0cb-4fc7-9584-8473a82239e4',4,'2204ae41373c4a57a26d8e752f9c9721','shares',1,'2025-10-02 17:00:43','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:00:43.895137',NULL,'2025-10-01 17:00:43.913670',80,80,NULL,'7207af41-92ce-4865-be2b-67c70522371a',3,'2204ae41373c4a57a26d8e752f9c9721','gigabytes',1,'2025-10-02 17:00:43','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:00:46.438776',NULL,'2025-10-01 17:00:46.483958',81,81,'aff16e38eefd4e66b0b620d67bc65d6e','7d134826-a492-4c18-9bed-37603ce6e4c0',34,'efef7d21275549538c8a121a0599e3f4','shares',-1,'2025-10-02 17:00:46',NULL),('2025-10-01 17:00:46.439749',NULL,'2025-10-01 17:00:46.483958',82,82,'aff16e38eefd4e66b0b620d67bc65d6e','121a577f-ca28-467f-b70f-09c51562405a',33,'efef7d21275549538c8a121a0599e3f4','gigabytes',-1,'2025-10-02 17:00:46',NULL),('2025-10-01 17:00:46.449823',NULL,'2025-10-01 17:00:46.483958',83,83,NULL,'d4063724-377b-44bf-bc21-a6f368642cf6',36,'efef7d21275549538c8a121a0599e3f4','shares',-1,'2025-10-02 17:00:46','3ec8827a-3829-4912-bb29-3f95aeb0ed67'),('2025-10-01 17:00:46.450766',NULL,'2025-10-01 17:00:46.483958',84,84,NULL,'751532d5-0b96-46c1-93fe-95237c036632',35,'efef7d21275549538c8a121a0599e3f4','gigabytes',-1,'2025-10-02 17:00:46','3ec8827a-3829-4912-bb29-3f95aeb0ed67'),('2025-10-01 17:00:47.881477',NULL,'2025-10-01 17:00:47.898574',85,85,'f01d6292274540ac84c2c1da0ccbaedb','7835c590-ba6e-4558-921c-5a67269a344e',2,'2204ae41373c4a57a26d8e752f9c9721','shares',-1,'2025-10-02 17:00:47',NULL),('2025-10-01 17:00:47.882247',NULL,'2025-10-01 17:00:47.898574',86,86,'f01d6292274540ac84c2c1da0ccbaedb','3d4a8855-d7ea-40f0-92c7-a95b1cb7b2b2',1,'2204ae41373c4a57a26d8e752f9c9721','gigabytes',-1,'2025-10-02 17:00:47',NULL),('2025-10-01 17:00:47.888753',NULL,'2025-10-01 17:00:47.898574',87,87,NULL,'b00bf848-270c-4ac5-97a1-3209264d9121',4,'2204ae41373c4a57a26d8e752f9c9721','shares',-1,'2025-10-02 17:00:47','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:00:47.889469',NULL,'2025-10-01 17:00:47.898574',88,88,NULL,'0e6e6270-1e92-4839-968c-a09d937793d3',3,'2204ae41373c4a57a26d8e752f9c9721','gigabytes',-1,'2025-10-02 17:00:47','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:00:51.393695',NULL,'2025-10-01 17:00:51.484466',89,89,'f01d6292274540ac84c2c1da0ccbaedb','e2f27954-a029-48a9-ae9a-7fbad83f83c9',39,'2204ae41373c4a57a26d8e752f9c9721','snapshots',1,'2025-10-02 17:00:51',NULL),('2025-10-01 17:00:51.396455',NULL,'2025-10-01 17:00:51.484466',90,90,'f01d6292274540ac84c2c1da0ccbaedb','e79466f8-6bab-4a6e-aa2d-41183417f26e',40,'2204ae41373c4a57a26d8e752f9c9721','snapshot_gigabytes',1,'2025-10-02 17:00:51',NULL),('2025-10-01 17:00:51.414370',NULL,'2025-10-01 17:00:51.484466',91,91,NULL,'0f072aac-48c8-4be7-9bb3-bd6f81f455ac',41,'2204ae41373c4a57a26d8e752f9c9721','snapshots',1,'2025-10-02 17:00:51','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:00:51.415627',NULL,'2025-10-01 17:00:51.484466',92,92,NULL,'ad8fc676-5462-4699-9de2-f58e13b60728',42,'2204ae41373c4a57a26d8e752f9c9721','snapshot_gigabytes',1,'2025-10-02 17:00:51','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:00:55.695739',NULL,'2025-10-01 17:00:55.726829',93,93,'f01d6292274540ac84c2c1da0ccbaedb','c55b85a0-4ad4-4385-9bac-0c3a66bcba8c',39,'2204ae41373c4a57a26d8e752f9c9721','snapshots',-1,'2025-10-02 17:00:55',NULL),('2025-10-01 17:00:55.696637',NULL,'2025-10-01 17:00:55.726829',94,94,'f01d6292274540ac84c2c1da0ccbaedb','36033788-a1a7-4560-bbc1-9f2ed2bcafee',40,'2204ae41373c4a57a26d8e752f9c9721','snapshot_gigabytes',-1,'2025-10-02 17:00:55',NULL),('2025-10-01 17:00:55.704549',NULL,'2025-10-01 17:00:55.726829',95,95,NULL,'776939f0-94e2-4d55-99e8-e747b788aa6f',41,'2204ae41373c4a57a26d8e752f9c9721','snapshots',-1,'2025-10-02 17:00:55','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:00:55.705742',NULL,'2025-10-01 17:00:55.726829',96,96,NULL,'72e52055-c761-402c-8ef6-7717f389b7b5',42,'2204ae41373c4a57a26d8e752f9c9721','snapshot_gigabytes',-1,'2025-10-02 17:00:55','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:01:01.969406',NULL,'2025-10-01 17:01:02.070679',97,97,'afbf15b176594b999a50ea15bf84d237','134dec5e-f92e-451c-aa0e-eb4a17f4f1de',44,'c4ae009f89aa49ccadaaeed54f17efe5','shares',1,'2025-10-02 17:01:01',NULL),('2025-10-01 17:01:01.970395',NULL,'2025-10-01 17:01:02.070679',98,98,'afbf15b176594b999a50ea15bf84d237','485bbaee-5b42-4255-97fe-1087699d8699',43,'c4ae009f89aa49ccadaaeed54f17efe5','gigabytes',1,'2025-10-02 17:01:01',NULL),('2025-10-01 17:01:02.029967',NULL,'2025-10-01 17:01:02.070679',99,99,NULL,'54a21c7a-c578-44d2-bc21-59b8a448ada6',46,'c4ae009f89aa49ccadaaeed54f17efe5','shares',1,'2025-10-02 17:01:01','0b6fb7a2-3c89-4ce6-afa0-08dffd4c10d5'),('2025-10-01 17:01:02.031329',NULL,'2025-10-01 17:01:02.070679',100,100,NULL,'68863186-2309-4f71-aab2-5ae29b0a28ab',45,'c4ae009f89aa49ccadaaeed54f17efe5','gigabytes',1,'2025-10-02 17:01:01','0b6fb7a2-3c89-4ce6-afa0-08dffd4c10d5'),('2025-10-01 17:01:04.994237',NULL,'2025-10-01 17:01:05.109662',101,101,'f01d6292274540ac84c2c1da0ccbaedb','879ec8cd-20a9-4812-9b15-1895770ad2e9',39,'2204ae41373c4a57a26d8e752f9c9721','snapshots',1,'2025-10-02 17:01:04',NULL),('2025-10-01 17:01:04.997109',NULL,'2025-10-01 17:01:05.109662',102,102,'f01d6292274540ac84c2c1da0ccbaedb','d7cfe00a-664c-4358-877e-730e01ac196a',40,'2204ae41373c4a57a26d8e752f9c9721','snapshot_gigabytes',1,'2025-10-02 17:01:04',NULL),('2025-10-01 17:01:05.010541',NULL,'2025-10-01 17:01:05.109662',103,103,NULL,'236daff7-ca8e-4a0c-a1f1-7742e03ec090',41,'2204ae41373c4a57a26d8e752f9c9721','snapshots',1,'2025-10-02 17:01:04','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:01:05.013214',NULL,'2025-10-01 17:01:05.109662',104,104,NULL,'37dfb6a7-4d5b-4351-86bb-7b895312af53',42,'2204ae41373c4a57a26d8e752f9c9721','snapshot_gigabytes',1,'2025-10-02 17:01:04','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:01:09.178905',NULL,'2025-10-01 17:01:09.264694',105,105,'f01d6292274540ac84c2c1da0ccbaedb','5bfe61a2-01b3-486d-a0e9-de4453ffff17',39,'2204ae41373c4a57a26d8e752f9c9721','snapshots',1,'2025-10-02 17:01:09',NULL),('2025-10-01 17:01:09.181763',NULL,'2025-10-01 17:01:09.264694',106,106,'f01d6292274540ac84c2c1da0ccbaedb','37135606-b9f2-4eca-bc6d-068a624d2236',40,'2204ae41373c4a57a26d8e752f9c9721','snapshot_gigabytes',1,'2025-10-02 17:01:09',NULL),('2025-10-01 17:01:09.192276',NULL,'2025-10-01 17:01:09.264694',107,107,NULL,'35ef88b4-e861-43c5-80ca-b3874b47f7c6',41,'2204ae41373c4a57a26d8e752f9c9721','snapshots',1,'2025-10-02 17:01:09','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:01:09.193924',NULL,'2025-10-01 17:01:09.264694',108,108,NULL,'42fe181f-8b71-43a2-8e51-4f87b7e6382b',42,'2204ae41373c4a57a26d8e752f9c9721','snapshot_gigabytes',1,'2025-10-02 17:01:09','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:01:12.987613',NULL,'2025-10-01 17:01:13.027886',109,109,'675dc5e53691498a85efcdb811e5a848','67093095-9fe2-4b3b-8caa-5d7acf319472',47,'fddf2e8f31614cd6afbfcdeff763553b','shares',1,'2025-10-02 17:01:12',NULL),('2025-10-01 17:01:12.989145',NULL,'2025-10-01 17:01:13.027886',110,110,'675dc5e53691498a85efcdb811e5a848','54f336c3-0e17-4862-abc1-a992655daf4e',48,'fddf2e8f31614cd6afbfcdeff763553b','gigabytes',1,'2025-10-02 17:01:12',NULL),('2025-10-01 17:01:13.004160',NULL,'2025-10-01 17:01:13.027886',111,111,NULL,'b19ca655-7230-42fc-ae38-4a30520b33bb',49,'fddf2e8f31614cd6afbfcdeff763553b','shares',1,'2025-10-02 17:01:12','b4e112a6-2cd3-4161-a1d9-6a2b26c3ae12'),('2025-10-01 17:01:13.005553',NULL,'2025-10-01 17:01:13.027886',112,112,NULL,'bc14a99c-f7f2-4ba8-b99c-21b967d368cb',50,'fddf2e8f31614cd6afbfcdeff763553b','gigabytes',1,'2025-10-02 17:01:12','b4e112a6-2cd3-4161-a1d9-6a2b26c3ae12'),('2025-10-01 17:01:13.199564',NULL,'2025-10-01 17:01:13.274317',113,113,'f01d6292274540ac84c2c1da0ccbaedb','2f328f6d-4520-43c4-8b03-b61a0e4475f3',39,'2204ae41373c4a57a26d8e752f9c9721','snapshots',1,'2025-10-02 17:01:13',NULL),('2025-10-01 17:01:13.200668',NULL,'2025-10-01 17:01:13.274317',114,114,'f01d6292274540ac84c2c1da0ccbaedb','31bb688f-92b2-4716-bca4-c1a866b11a83',40,'2204ae41373c4a57a26d8e752f9c9721','snapshot_gigabytes',1,'2025-10-02 17:01:13',NULL),('2025-10-01 17:01:13.207106',NULL,'2025-10-01 17:01:13.274317',115,115,NULL,'e870267e-19e0-4f3c-bdb4-11b4a1d8c2bf',41,'2204ae41373c4a57a26d8e752f9c9721','snapshots',1,'2025-10-02 17:01:13','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:01:13.208193',NULL,'2025-10-01 17:01:13.274317',116,116,NULL,'c0cfddb8-743b-4f0b-ab8f-0d78b5a5aed1',42,'2204ae41373c4a57a26d8e752f9c9721','snapshot_gigabytes',1,'2025-10-02 17:01:13','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:01:17.166034',NULL,'2025-10-01 17:01:17.182143',117,117,'675dc5e53691498a85efcdb811e5a848','37b8d73e-0ed1-4c16-9cda-7d3dbd8e91df',47,'fddf2e8f31614cd6afbfcdeff763553b','shares',-1,'2025-10-02 17:01:17',NULL),('2025-10-01 17:01:17.166864',NULL,'2025-10-01 17:01:17.182143',118,118,'675dc5e53691498a85efcdb811e5a848','8ce29c60-370d-4bf2-a34e-f77f6c79ab83',48,'fddf2e8f31614cd6afbfcdeff763553b','gigabytes',-1,'2025-10-02 17:01:17',NULL),('2025-10-01 17:01:17.172651',NULL,'2025-10-01 17:01:17.182143',119,119,NULL,'52c8a78f-49f9-45ba-ba2e-19aeb33b19c1',49,'fddf2e8f31614cd6afbfcdeff763553b','shares',-1,'2025-10-02 17:01:17','b4e112a6-2cd3-4161-a1d9-6a2b26c3ae12'),('2025-10-01 17:01:17.173381',NULL,'2025-10-01 17:01:17.182143',120,120,NULL,'7c421639-da5f-4041-b399-4776b01c7e5a',50,'fddf2e8f31614cd6afbfcdeff763553b','gigabytes',-1,'2025-10-02 17:01:17','b4e112a6-2cd3-4161-a1d9-6a2b26c3ae12'),('2025-10-01 17:01:17.390375',NULL,'2025-10-01 17:01:17.458907',121,121,'f01d6292274540ac84c2c1da0ccbaedb','3f956910-8fec-4238-909b-f0c3a26ee427',39,'2204ae41373c4a57a26d8e752f9c9721','snapshots',1,'2025-10-02 17:01:17',NULL),('2025-10-01 17:01:17.391506',NULL,'2025-10-01 17:01:17.458907',122,122,'f01d6292274540ac84c2c1da0ccbaedb','3d21cdea-5e80-487b-94df-85e8322f024e',40,'2204ae41373c4a57a26d8e752f9c9721','snapshot_gigabytes',1,'2025-10-02 17:01:17',NULL),('2025-10-01 17:01:17.397125',NULL,'2025-10-01 17:01:17.458907',123,123,NULL,'1c6048a3-9c65-41cc-b8c7-7c6c02c059f6',41,'2204ae41373c4a57a26d8e752f9c9721','snapshots',1,'2025-10-02 17:01:17','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:01:17.398507',NULL,'2025-10-01 17:01:17.458907',124,124,NULL,'cc0690a6-a8c0-41ae-808b-f9999a122c13',42,'2204ae41373c4a57a26d8e752f9c9721','snapshot_gigabytes',1,'2025-10-02 17:01:17','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:01:18.233718',NULL,'2025-10-01 17:01:18.258816',125,125,'afbf15b176594b999a50ea15bf84d237','c34d663b-d469-4578-8b7f-b370a032e266',44,'c4ae009f89aa49ccadaaeed54f17efe5','shares',-1,'2025-10-02 17:01:18',NULL),('2025-10-01 17:01:18.234999',NULL,'2025-10-01 17:01:18.258816',126,126,'afbf15b176594b999a50ea15bf84d237','ecbec85e-a1fe-4cad-9249-9f21ba968cc3',43,'c4ae009f89aa49ccadaaeed54f17efe5','gigabytes',-1,'2025-10-02 17:01:18',NULL),('2025-10-01 17:01:18.245295',NULL,'2025-10-01 17:01:18.258816',127,127,NULL,'27dc836e-78a8-4118-9bce-66bc0af5f09b',46,'c4ae009f89aa49ccadaaeed54f17efe5','shares',-1,'2025-10-02 17:01:18','0b6fb7a2-3c89-4ce6-afa0-08dffd4c10d5'),('2025-10-01 17:01:18.246665',NULL,'2025-10-01 17:01:18.258816',128,128,NULL,'67590726-88bf-4160-a715-fceec6aa67d3',45,'c4ae009f89aa49ccadaaeed54f17efe5','gigabytes',-1,'2025-10-02 17:01:18','0b6fb7a2-3c89-4ce6-afa0-08dffd4c10d5'),('2025-10-01 17:01:21.649266',NULL,'2025-10-01 17:01:21.724129',129,129,'f01d6292274540ac84c2c1da0ccbaedb','3457dc98-7075-42c8-9b16-9a10b3551bd7',39,'2204ae41373c4a57a26d8e752f9c9721','snapshots',1,'2025-10-02 17:01:21',NULL),('2025-10-01 17:01:21.650693',NULL,'2025-10-01 17:01:21.724129',130,130,'f01d6292274540ac84c2c1da0ccbaedb','80783db2-9bd7-42bf-939a-12087424c9fe',40,'2204ae41373c4a57a26d8e752f9c9721','snapshot_gigabytes',1,'2025-10-02 17:01:21',NULL),('2025-10-01 17:01:21.657024',NULL,'2025-10-01 17:01:21.724129',131,131,NULL,'5dd48753-7712-4c5e-81e8-3c1134631240',41,'2204ae41373c4a57a26d8e752f9c9721','snapshots',1,'2025-10-02 17:01:21','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:01:21.658268',NULL,'2025-10-01 17:01:21.724129',132,132,NULL,'c02ece8d-b443-4612-9965-5f82c77edc3f',42,'2204ae41373c4a57a26d8e752f9c9721','snapshot_gigabytes',1,'2025-10-02 17:01:21','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:01:25.199562',NULL,'2025-10-01 17:01:25.289032',133,133,'0330a1c6d11e45b8a6e21e8e46c29677','a2dcad58-5c8d-4d25-ad51-7366f3016918',52,'0e7ac90f0c9f41cbb8e463ae95d18d81','shares',1,'2025-10-02 17:01:25',NULL),('2025-10-01 17:01:25.205228',NULL,'2025-10-01 17:01:25.289032',134,134,'0330a1c6d11e45b8a6e21e8e46c29677','0a11ec8b-7913-4c19-a67b-e8c58fa245f4',51,'0e7ac90f0c9f41cbb8e463ae95d18d81','gigabytes',1,'2025-10-02 17:01:25',NULL),('2025-10-01 17:01:25.224615',NULL,'2025-10-01 17:01:25.289032',135,135,NULL,'18d7f8ba-715a-46ba-a0d6-43c53ea005fe',54,'0e7ac90f0c9f41cbb8e463ae95d18d81','shares',1,'2025-10-02 17:01:25','f0348654-6331-4c8a-89cf-95b9f1fa588d'),('2025-10-01 17:01:25.238317',NULL,'2025-10-01 17:01:25.289032',136,136,NULL,'99a5a869-a690-4c08-97cd-7f6948842457',53,'0e7ac90f0c9f41cbb8e463ae95d18d81','gigabytes',1,'2025-10-02 17:01:25','f0348654-6331-4c8a-89cf-95b9f1fa588d'),('2025-10-01 17:01:26.438389',NULL,'2025-10-01 17:01:26.455122',137,137,'f01d6292274540ac84c2c1da0ccbaedb','abefd0a5-8d6b-4757-86f7-ae61e27e57b8',39,'2204ae41373c4a57a26d8e752f9c9721','snapshots',-1,'2025-10-02 17:01:26',NULL),('2025-10-01 17:01:26.439312',NULL,'2025-10-01 17:01:26.455122',138,138,'f01d6292274540ac84c2c1da0ccbaedb','ecf0721d-b366-4d66-8a32-e3e5decfb7fb',40,'2204ae41373c4a57a26d8e752f9c9721','snapshot_gigabytes',-1,'2025-10-02 17:01:26',NULL),('2025-10-01 17:01:26.445173',NULL,'2025-10-01 17:01:26.455122',139,139,NULL,'d2fc337c-5e32-4491-af1c-f336f7a3ad9e',41,'2204ae41373c4a57a26d8e752f9c9721','snapshots',-1,'2025-10-02 17:01:26','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:01:26.445843',NULL,'2025-10-01 17:01:26.455122',140,140,NULL,'18a93e15-b819-4958-b506-d4cf7e7977c2',42,'2204ae41373c4a57a26d8e752f9c9721','snapshot_gigabytes',-1,'2025-10-02 17:01:26','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:01:26.675207',NULL,'2025-10-01 17:01:26.715496',141,141,'c7bd5ab094534136b1906389e4264c0b','006e35ee-19b8-45a5-b1dc-f27d9cfc38eb',56,'756b231c8c724081bed78676d19a02ec','shares',1,'2025-10-02 17:01:26',NULL),('2025-10-01 17:01:26.676270',NULL,'2025-10-01 17:01:26.715496',142,142,'c7bd5ab094534136b1906389e4264c0b','905db86c-82cd-4106-bb0c-6f6606391edb',55,'756b231c8c724081bed78676d19a02ec','gigabytes',1,'2025-10-02 17:01:26',NULL),('2025-10-01 17:01:26.688011',NULL,'2025-10-01 17:01:26.715496',143,143,NULL,'b05da87a-f255-47e0-8ccd-4f20c6d311d1',58,'756b231c8c724081bed78676d19a02ec','shares',1,'2025-10-02 17:01:26','89fda32e-eb53-4bb7-8ebe-24317a4a69c0'),('2025-10-01 17:01:26.689375',NULL,'2025-10-01 17:01:26.715496',144,144,NULL,'f5fdedfd-b414-4f77-8900-b29ce6d34772',57,'756b231c8c724081bed78676d19a02ec','gigabytes',1,'2025-10-02 17:01:26','89fda32e-eb53-4bb7-8ebe-24317a4a69c0'),('2025-10-01 17:01:28.825650',NULL,'2025-10-01 17:01:28.939458',145,145,'0330a1c6d11e45b8a6e21e8e46c29677','e98d19c7-7e46-45c7-a4dc-5f88ff0bfbe3',59,'0e7ac90f0c9f41cbb8e463ae95d18d81','snapshots',1,'2025-10-02 17:01:28',NULL),('2025-10-01 17:01:28.826870',NULL,'2025-10-01 17:01:28.939458',146,146,'0330a1c6d11e45b8a6e21e8e46c29677','1b119f03-fc40-4920-af00-f383ca550075',60,'0e7ac90f0c9f41cbb8e463ae95d18d81','snapshot_gigabytes',1,'2025-10-02 17:01:28',NULL),('2025-10-01 17:01:28.847959',NULL,'2025-10-01 17:01:28.939458',147,147,NULL,'6279fc4e-bfdf-4c37-b4d5-ee3c17815b04',61,'0e7ac90f0c9f41cbb8e463ae95d18d81','snapshots',1,'2025-10-02 17:01:28','f0348654-6331-4c8a-89cf-95b9f1fa588d'),('2025-10-01 17:01:28.849718',NULL,'2025-10-01 17:01:28.939458',148,148,NULL,'579fb863-d327-4458-ac06-7211f18dcb79',62,'0e7ac90f0c9f41cbb8e463ae95d18d81','snapshot_gigabytes',1,'2025-10-02 17:01:28','f0348654-6331-4c8a-89cf-95b9f1fa588d'),('2025-10-01 17:01:30.218415',NULL,'2025-10-01 17:01:30.296031',149,149,'c7bd5ab094534136b1906389e4264c0b','3dfb9678-9ae9-4bd4-b11d-e876718b3349',63,'756b231c8c724081bed78676d19a02ec','snapshots',1,'2025-10-02 17:01:30',NULL),('2025-10-01 17:01:30.219949',NULL,'2025-10-01 17:01:30.296031',150,150,'c7bd5ab094534136b1906389e4264c0b','d0f49ef3-65bc-4cb9-97bf-562e7a0ef251',64,'756b231c8c724081bed78676d19a02ec','snapshot_gigabytes',1,'2025-10-02 17:01:30',NULL),('2025-10-01 17:01:30.235708',NULL,'2025-10-01 17:01:30.296031',151,151,NULL,'86a7b231-b374-4e50-987f-cbe3dd6cb614',65,'756b231c8c724081bed78676d19a02ec','snapshots',1,'2025-10-02 17:01:30','89fda32e-eb53-4bb7-8ebe-24317a4a69c0'),('2025-10-01 17:01:30.237378',NULL,'2025-10-01 17:01:30.296031',152,152,NULL,'82c42fef-5d33-4ac9-aabe-7d2e104ddf6d',66,'756b231c8c724081bed78676d19a02ec','snapshot_gigabytes',1,'2025-10-02 17:01:30','89fda32e-eb53-4bb7-8ebe-24317a4a69c0'),('2025-10-01 17:01:32.577390',NULL,'2025-10-01 17:01:32.628146',153,153,'0330a1c6d11e45b8a6e21e8e46c29677','6b3fdd48-75eb-41d0-b144-19ce38b2ea32',52,'0e7ac90f0c9f41cbb8e463ae95d18d81','shares',1,'2025-10-02 17:01:32',NULL),('2025-10-01 17:01:32.578570',NULL,'2025-10-01 17:01:32.628146',154,154,'0330a1c6d11e45b8a6e21e8e46c29677','920969da-4d68-452a-b77d-7d0d8664ce8e',51,'0e7ac90f0c9f41cbb8e463ae95d18d81','gigabytes',1,'2025-10-02 17:01:32',NULL),('2025-10-01 17:01:32.584251',NULL,'2025-10-01 17:01:32.628146',155,155,NULL,'6b0499b6-277f-4814-9ad0-5313169f5cb1',54,'0e7ac90f0c9f41cbb8e463ae95d18d81','shares',1,'2025-10-02 17:01:32','f0348654-6331-4c8a-89cf-95b9f1fa588d'),('2025-10-01 17:01:32.585523',NULL,'2025-10-01 17:01:32.628146',156,156,NULL,'3b16e05e-9f3c-4f84-bf89-fb105cb3dd90',53,'0e7ac90f0c9f41cbb8e463ae95d18d81','gigabytes',1,'2025-10-02 17:01:32','f0348654-6331-4c8a-89cf-95b9f1fa588d'),('2025-10-01 17:01:32.748359',NULL,'2025-10-01 17:01:36.354655',157,157,'f01d6292274540ac84c2c1da0ccbaedb','0e9a499e-8d76-49ad-a2be-92c4252b5cb7',39,'2204ae41373c4a57a26d8e752f9c9721','snapshots',-1,'2025-10-02 17:01:32',NULL),('2025-10-01 17:01:32.750106',NULL,'2025-10-01 17:01:36.354655',158,158,'f01d6292274540ac84c2c1da0ccbaedb','042b5168-2c9f-4469-93ee-9aa1571e5249',40,'2204ae41373c4a57a26d8e752f9c9721','snapshot_gigabytes',-1,'2025-10-02 17:01:32',NULL),('2025-10-01 17:01:34.100444',NULL,'2025-10-01 17:01:36.354655',159,159,NULL,'810c22f6-6372-4a0b-b6e7-03215d392c8c',41,'2204ae41373c4a57a26d8e752f9c9721','snapshots',-1,'2025-10-02 17:01:32','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:01:34.102973',NULL,'2025-10-01 17:01:36.354655',160,160,NULL,'b426d6a9-e1fe-42e9-8c76-0cee43a26572',42,'2204ae41373c4a57a26d8e752f9c9721','snapshot_gigabytes',-1,'2025-10-02 17:01:32','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:01:38.658697',NULL,'2025-10-01 17:01:38.695378',161,161,'f01d6292274540ac84c2c1da0ccbaedb','619e2845-6ff1-4e9a-9333-45906434a8d0',39,'2204ae41373c4a57a26d8e752f9c9721','snapshots',-1,'2025-10-02 17:01:38',NULL),('2025-10-01 17:01:38.660388',NULL,'2025-10-01 17:01:38.695378',162,162,'f01d6292274540ac84c2c1da0ccbaedb','438a1b4d-7d3f-4f69-8a94-7903bbd28c4d',40,'2204ae41373c4a57a26d8e752f9c9721','snapshot_gigabytes',-1,'2025-10-02 17:01:38',NULL),('2025-10-01 17:01:38.673517',NULL,'2025-10-01 17:01:38.695378',163,163,NULL,'b616e55c-3a32-4e66-8845-834f6bf1ef16',41,'2204ae41373c4a57a26d8e752f9c9721','snapshots',-1,'2025-10-02 17:01:38','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:01:38.674478',NULL,'2025-10-01 17:01:38.695378',164,164,NULL,'fb4ce51e-786c-44cd-a409-4cc9fefb183f',42,'2204ae41373c4a57a26d8e752f9c9721','snapshot_gigabytes',-1,'2025-10-02 17:01:38','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:01:39.756461',NULL,'2025-10-01 17:01:39.789795',165,165,'c7bd5ab094534136b1906389e4264c0b','87be7ddb-5f44-4237-84ae-063550c9dd5f',63,'756b231c8c724081bed78676d19a02ec','snapshots',-1,'2025-10-02 17:01:39',NULL),('2025-10-01 17:01:39.758529',NULL,'2025-10-01 17:01:39.789795',166,166,'c7bd5ab094534136b1906389e4264c0b','2d4fdb5d-2c7c-43cf-8658-9bb5e4bfc847',64,'756b231c8c724081bed78676d19a02ec','snapshot_gigabytes',-1,'2025-10-02 17:01:39',NULL),('2025-10-01 17:01:39.770760',NULL,'2025-10-01 17:01:39.789795',167,167,NULL,'531f6704-7430-443c-9aed-932df31ec8f2',65,'756b231c8c724081bed78676d19a02ec','snapshots',-1,'2025-10-02 17:01:39','89fda32e-eb53-4bb7-8ebe-24317a4a69c0'),('2025-10-01 17:01:39.777348',NULL,'2025-10-01 17:01:39.789795',168,168,NULL,'6632f920-b18f-40a9-b2f7-18b86eff951c',66,'756b231c8c724081bed78676d19a02ec','snapshot_gigabytes',-1,'2025-10-02 17:01:39','89fda32e-eb53-4bb7-8ebe-24317a4a69c0'),('2025-10-01 17:01:43.196439',NULL,'2025-10-01 17:01:43.227013',169,169,'f01d6292274540ac84c2c1da0ccbaedb','fd8a6210-062e-4f6f-85fc-e7730d5fcb86',39,'2204ae41373c4a57a26d8e752f9c9721','snapshots',-1,'2025-10-02 17:01:43',NULL),('2025-10-01 17:01:43.197379',NULL,'2025-10-01 17:01:43.227013',170,170,'f01d6292274540ac84c2c1da0ccbaedb','11195fe4-610a-4857-ace6-a9edcf4b45ea',40,'2204ae41373c4a57a26d8e752f9c9721','snapshot_gigabytes',-1,'2025-10-02 17:01:43',NULL),('2025-10-01 17:01:43.204734',NULL,'2025-10-01 17:01:43.227013',171,171,NULL,'5531a3c3-17c6-44bc-b05b-ba99d710291e',41,'2204ae41373c4a57a26d8e752f9c9721','snapshots',-1,'2025-10-02 17:01:43','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:01:43.206537',NULL,'2025-10-01 17:01:43.227013',172,172,NULL,'30166472-7d8e-4132-b0c3-d780615b619d',42,'2204ae41373c4a57a26d8e752f9c9721','snapshot_gigabytes',-1,'2025-10-02 17:01:43','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:01:43.368105',NULL,'2025-10-01 17:01:43.382851',173,173,'c7bd5ab094534136b1906389e4264c0b','515e444f-39ed-45b7-9920-ec3a3f1e7d43',56,'756b231c8c724081bed78676d19a02ec','shares',-1,'2025-10-02 17:01:43',NULL),('2025-10-01 17:01:43.368766',NULL,'2025-10-01 17:01:43.382851',174,174,'c7bd5ab094534136b1906389e4264c0b','05c99728-7101-4d68-821c-17a336c5c029',55,'756b231c8c724081bed78676d19a02ec','gigabytes',-1,'2025-10-02 17:01:43',NULL),('2025-10-01 17:01:43.374800',NULL,'2025-10-01 17:01:43.382851',175,175,NULL,'d753fc9f-9185-4ea5-b59d-b9a3d01086b8',58,'756b231c8c724081bed78676d19a02ec','shares',-1,'2025-10-02 17:01:43','89fda32e-eb53-4bb7-8ebe-24317a4a69c0'),('2025-10-01 17:01:43.375826',NULL,'2025-10-01 17:01:43.382851',176,176,NULL,'8dbb727c-a05f-48ea-9f80-b4d2f5ea078c',57,'756b231c8c724081bed78676d19a02ec','gigabytes',-1,'2025-10-02 17:01:43','89fda32e-eb53-4bb7-8ebe-24317a4a69c0'),('2025-10-01 17:01:46.770839',NULL,'2025-10-01 17:01:46.798939',177,177,'f01d6292274540ac84c2c1da0ccbaedb','f04d6b45-c0ec-4028-a0fa-b5814e6ca551',39,'2204ae41373c4a57a26d8e752f9c9721','snapshots',-1,'2025-10-02 17:01:46',NULL),('2025-10-01 17:01:46.771704',NULL,'2025-10-01 17:01:46.798939',178,178,'f01d6292274540ac84c2c1da0ccbaedb','6db7d218-9536-47ed-8bba-c6b45643fa55',40,'2204ae41373c4a57a26d8e752f9c9721','snapshot_gigabytes',-1,'2025-10-02 17:01:46',NULL),('2025-10-01 17:01:46.782069',NULL,'2025-10-01 17:01:46.798939',179,179,NULL,'64a76b8f-8d95-4cf4-82c2-e22fe0b6b01b',41,'2204ae41373c4a57a26d8e752f9c9721','snapshots',-1,'2025-10-02 17:01:46','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:01:46.783076',NULL,'2025-10-01 17:01:46.798939',180,180,NULL,'4f0ef817-a995-4380-82b8-071d84f5186d',42,'2204ae41373c4a57a26d8e752f9c9721','snapshot_gigabytes',-1,'2025-10-02 17:01:46','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:01:50.837411',NULL,'2025-10-01 17:01:51.021393',181,181,'f01d6292274540ac84c2c1da0ccbaedb','0f697e59-6ce1-4aa0-83a3-d0dfa29aee83',2,'2204ae41373c4a57a26d8e752f9c9721','shares',-1,'2025-10-02 17:01:50',NULL),('2025-10-01 17:01:50.838116',NULL,'2025-10-01 17:01:51.021393',182,182,'f01d6292274540ac84c2c1da0ccbaedb','d05623cb-5173-431b-894a-aea73d38791a',1,'2204ae41373c4a57a26d8e752f9c9721','gigabytes',-1,'2025-10-02 17:01:50',NULL),('2025-10-01 17:01:50.949144',NULL,'2025-10-01 17:01:51.021393',183,183,NULL,'35641c95-884a-4a85-8665-55b23f30ffa2',4,'2204ae41373c4a57a26d8e752f9c9721','shares',-1,'2025-10-02 17:01:50','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:01:50.950844',NULL,'2025-10-01 17:01:51.021393',184,184,NULL,'73341174-653b-4785-9744-5c02d955be61',3,'2204ae41373c4a57a26d8e752f9c9721','gigabytes',-1,'2025-10-02 17:01:50','8844ab0c-8acf-432e-bb69-abd01348cc0a'),('2025-10-01 17:01:54.744617',NULL,'2025-10-01 17:01:54.839147',185,185,'559501bf42ce4daab8b14ced6e0516c4','47e2a45a-2057-4505-b7f7-bd8202d535ff',67,'4743342a50a447f89df320c01c1cbcc9','shares',1,'2025-10-02 17:01:54',NULL),('2025-10-01 17:01:54.745757',NULL,'2025-10-01 17:01:54.839147',186,186,'559501bf42ce4daab8b14ced6e0516c4','007c0124-c61a-4776-b784-05c01e96d903',68,'4743342a50a447f89df320c01c1cbcc9','gigabytes',1,'2025-10-02 17:01:54',NULL),('2025-10-01 17:01:54.797814',NULL,'2025-10-01 17:01:54.839147',187,187,NULL,'1c4417e2-d0ce-4e58-be5c-a80a67b061b4',69,'4743342a50a447f89df320c01c1cbcc9','shares',1,'2025-10-02 17:01:54','dd944c2a-e556-4a92-a900-c197e5952e3a'),('2025-10-01 17:01:54.799168',NULL,'2025-10-01 17:01:54.839147',188,188,NULL,'170216e6-b90b-49d1-a02c-8edf0ea42fc4',70,'4743342a50a447f89df320c01c1cbcc9','gigabytes',1,'2025-10-02 17:01:54','dd944c2a-e556-4a92-a900-c197e5952e3a'),('2025-10-01 17:01:58.717600',NULL,'2025-10-01 17:01:58.770526',189,189,'b92b509d372144dd8cbe29e18bab1676','f7ce3308-4a22-4678-bcd4-4d80a263201f',72,'e7862d18aeb143d49259310c073583be','shares',1,'2025-10-02 17:01:58',NULL),('2025-10-01 17:01:58.721642',NULL,'2025-10-01 17:01:58.770526',190,190,'b92b509d372144dd8cbe29e18bab1676','e32adf0e-09f2-45be-afe6-1393eeab32d1',71,'e7862d18aeb143d49259310c073583be','gigabytes',1,'2025-10-02 17:01:58',NULL),('2025-10-01 17:01:58.741203',NULL,'2025-10-01 17:01:58.770526',191,191,NULL,'71744f53-456d-4bb1-b338-75a786c475d6',74,'e7862d18aeb143d49259310c073583be','shares',1,'2025-10-02 17:01:58','dd944c2a-e556-4a92-a900-c197e5952e3a'),('2025-10-01 17:01:58.743197',NULL,'2025-10-01 17:01:58.770526',192,192,NULL,'bb5b22dd-1f77-4a1f-a882-cb73d69d191f',73,'e7862d18aeb143d49259310c073583be','gigabytes',1,'2025-10-02 17:01:58','dd944c2a-e556-4a92-a900-c197e5952e3a'),('2025-10-01 17:01:58.974566',NULL,'2025-10-01 17:01:59.008273',193,193,'3dce165987c44fe28fc0096cce9ddb2b','4e50bdc5-875a-47c4-9f56-7ffada52c49c',75,'06efa1ba477e45208d5ba21e3e7c2703','shares',1,'2025-10-02 17:01:58',NULL),('2025-10-01 17:01:58.975618',NULL,'2025-10-01 17:01:59.008273',194,194,'3dce165987c44fe28fc0096cce9ddb2b','616a6cd8-b5ea-4da7-a981-38435ad4914d',76,'06efa1ba477e45208d5ba21e3e7c2703','gigabytes',1,'2025-10-02 17:01:58',NULL),('2025-10-01 17:01:58.985540',NULL,'2025-10-01 17:01:59.008273',195,195,NULL,'0de8255e-a23e-48a5-a070-106060f35537',77,'06efa1ba477e45208d5ba21e3e7c2703','shares',1,'2025-10-02 17:01:58','354dd354-8b0a-40a4-9641-b0e3560a975d'),('2025-10-01 17:01:58.986632',NULL,'2025-10-01 17:01:59.008273',196,196,NULL,'ca89a94c-3e75-4f9f-8df9-ec26799382fd',78,'06efa1ba477e45208d5ba21e3e7c2703','gigabytes',1,'2025-10-02 17:01:58','354dd354-8b0a-40a4-9641-b0e3560a975d'),('2025-10-01 17:02:02.605437',NULL,'2025-10-01 17:02:02.636146',197,197,'3dce165987c44fe28fc0096cce9ddb2b','dbe3bc37-2144-4ae1-b07c-d26d405f76e7',75,'06efa1ba477e45208d5ba21e3e7c2703','shares',1,'2025-10-02 17:02:02',NULL),('2025-10-01 17:02:02.607039',NULL,'2025-10-01 17:02:02.636146',198,198,'3dce165987c44fe28fc0096cce9ddb2b','086d191e-157b-420d-af23-b883ccfec5a8',76,'06efa1ba477e45208d5ba21e3e7c2703','gigabytes',1,'2025-10-02 17:02:02',NULL),('2025-10-01 17:02:02.613691',NULL,'2025-10-01 17:02:02.636146',199,199,NULL,'59db08f8-8d3d-4efe-9eca-228e7b65b553',77,'06efa1ba477e45208d5ba21e3e7c2703','shares',1,'2025-10-02 17:02:02','354dd354-8b0a-40a4-9641-b0e3560a975d'),('2025-10-01 17:02:02.616536',NULL,'2025-10-01 17:02:02.636146',200,200,NULL,'d4eb83e6-df9c-4a32-b585-d6478e015539',78,'06efa1ba477e45208d5ba21e3e7c2703','gigabytes',1,'2025-10-02 17:02:02','354dd354-8b0a-40a4-9641-b0e3560a975d'),('2025-10-01 17:02:02.771579',NULL,'2025-10-01 17:02:02.868610',201,201,'b92b509d372144dd8cbe29e18bab1676','a1af07f5-9623-43c9-9f4d-4c8f66dcf801',72,'e7862d18aeb143d49259310c073583be','shares',-1,'2025-10-02 17:02:02',NULL),('2025-10-01 17:02:02.774753',NULL,'2025-10-01 17:02:02.868610',202,202,'b92b509d372144dd8cbe29e18bab1676','8e119906-5000-4cce-91ac-778b10210226',71,'e7862d18aeb143d49259310c073583be','gigabytes',-1,'2025-10-02 17:02:02',NULL),('2025-10-01 17:02:02.790857',NULL,'2025-10-01 17:02:02.868610',203,203,NULL,'02bf13bb-779b-452a-bd8a-813a63a6aef6',74,'e7862d18aeb143d49259310c073583be','shares',-1,'2025-10-02 17:02:02','dd944c2a-e556-4a92-a900-c197e5952e3a'),('2025-10-01 17:02:02.792177',NULL,'2025-10-01 17:02:02.868610',204,204,NULL,'30f3787c-7eb1-4892-9b46-69b01aefaa85',73,'e7862d18aeb143d49259310c073583be','gigabytes',-1,'2025-10-02 17:02:02','dd944c2a-e556-4a92-a900-c197e5952e3a'),('2025-10-01 17:02:05.549675',NULL,'2025-10-01 17:02:05.573679',205,205,'0330a1c6d11e45b8a6e21e8e46c29677','6c60994e-8ec4-495d-9901-2118f2e0f63b',52,'0e7ac90f0c9f41cbb8e463ae95d18d81','shares',-1,'2025-10-02 17:02:05',NULL),('2025-10-01 17:02:05.550638',NULL,'2025-10-01 17:02:05.573679',206,206,'0330a1c6d11e45b8a6e21e8e46c29677','9c5a5b1c-3e2d-47c2-bcc9-b13275d246bf',51,'0e7ac90f0c9f41cbb8e463ae95d18d81','gigabytes',-1,'2025-10-02 17:02:05',NULL),('2025-10-01 17:02:05.559968',NULL,'2025-10-01 17:02:05.573679',207,207,NULL,'53c2c711-a4ee-4010-911d-c42f9995538d',54,'0e7ac90f0c9f41cbb8e463ae95d18d81','shares',-1,'2025-10-02 17:02:05','f0348654-6331-4c8a-89cf-95b9f1fa588d'),('2025-10-01 17:02:05.561560',NULL,'2025-10-01 17:02:05.573679',208,208,NULL,'c5b6fe07-55c2-4ae3-b914-83580b20f180',53,'0e7ac90f0c9f41cbb8e463ae95d18d81','gigabytes',-1,'2025-10-02 17:02:05','f0348654-6331-4c8a-89cf-95b9f1fa588d'),('2025-10-01 17:02:06.379546',NULL,'2025-10-01 17:02:06.394178',209,209,'559501bf42ce4daab8b14ced6e0516c4','d35d478f-5044-43b9-b227-da003cdc9ff7',67,'4743342a50a447f89df320c01c1cbcc9','shares',-1,'2025-10-02 17:02:06',NULL),('2025-10-01 17:02:06.380400',NULL,'2025-10-01 17:02:06.394178',210,210,'559501bf42ce4daab8b14ced6e0516c4','14470fb5-0fea-4964-a779-effdb679e29e',68,'4743342a50a447f89df320c01c1cbcc9','gigabytes',-1,'2025-10-02 17:02:06',NULL),('2025-10-01 17:02:06.385947',NULL,'2025-10-01 17:02:06.394178',211,211,NULL,'a8dfe32b-d63b-4102-bb0e-ac6e96bddbd2',69,'4743342a50a447f89df320c01c1cbcc9','shares',-1,'2025-10-02 17:02:06','dd944c2a-e556-4a92-a900-c197e5952e3a'),('2025-10-01 17:02:06.386709',NULL,'2025-10-01 17:02:06.394178',212,212,NULL,'400f7203-e557-47bc-a219-d6935cfc6047',70,'4743342a50a447f89df320c01c1cbcc9','gigabytes',-1,'2025-10-02 17:02:06','dd944c2a-e556-4a92-a900-c197e5952e3a'),('2025-10-01 17:02:07.344879',NULL,'2025-10-01 17:02:07.360765',213,213,'3dce165987c44fe28fc0096cce9ddb2b','570947db-7f70-4ce1-8381-e5ed78477d86',75,'06efa1ba477e45208d5ba21e3e7c2703','shares',-1,'2025-10-02 17:02:07',NULL),('2025-10-01 17:02:07.345744',NULL,'2025-10-01 17:02:07.360765',214,214,'3dce165987c44fe28fc0096cce9ddb2b','91c1827d-30d9-49c8-ba41-f9a9b9e8f0e6',76,'06efa1ba477e45208d5ba21e3e7c2703','gigabytes',-1,'2025-10-02 17:02:07',NULL),('2025-10-01 17:02:07.351428',NULL,'2025-10-01 17:02:07.360765',215,215,NULL,'6387572a-f0f7-4359-a09c-89d55dcd4491',77,'06efa1ba477e45208d5ba21e3e7c2703','shares',-1,'2025-10-02 17:02:07','354dd354-8b0a-40a4-9641-b0e3560a975d'),('2025-10-01 17:02:07.352039',NULL,'2025-10-01 17:02:07.360765',216,216,NULL,'368c21cf-7ce2-43d2-b8aa-0e1e1e4b12d7',78,'06efa1ba477e45208d5ba21e3e7c2703','gigabytes',-1,'2025-10-02 17:02:07','354dd354-8b0a-40a4-9641-b0e3560a975d'),('2025-10-01 17:02:08.877870',NULL,'2025-10-01 17:02:08.897184',217,217,'0330a1c6d11e45b8a6e21e8e46c29677','ec3b94d7-199f-4560-acde-f8eea4c6fa60',59,'0e7ac90f0c9f41cbb8e463ae95d18d81','snapshots',-1,'2025-10-02 17:02:08',NULL),('2025-10-01 17:02:08.878700',NULL,'2025-10-01 17:02:08.897184',218,218,'0330a1c6d11e45b8a6e21e8e46c29677','5517faa9-c089-41f8-a26b-2cf223348d84',60,'0e7ac90f0c9f41cbb8e463ae95d18d81','snapshot_gigabytes',-1,'2025-10-02 17:02:08',NULL),('2025-10-01 17:02:08.885107',NULL,'2025-10-01 17:02:08.897184',219,219,NULL,'8241154c-c1a5-4461-b432-2627647a29ea',61,'0e7ac90f0c9f41cbb8e463ae95d18d81','snapshots',-1,'2025-10-02 17:02:08','f0348654-6331-4c8a-89cf-95b9f1fa588d'),('2025-10-01 17:02:08.885939',NULL,'2025-10-01 17:02:08.897184',220,220,NULL,'203654ba-9179-460a-8508-bded90ec7ffd',62,'0e7ac90f0c9f41cbb8e463ae95d18d81','snapshot_gigabytes',-1,'2025-10-02 17:02:08','f0348654-6331-4c8a-89cf-95b9f1fa588d'),('2025-10-01 17:02:09.769868',NULL,'2025-10-01 17:02:09.823348',221,221,'b92b509d372144dd8cbe29e18bab1676','095a462c-c6d7-459c-a1ed-6d28db8a5603',72,'e7862d18aeb143d49259310c073583be','shares',1,'2025-10-02 17:02:09',NULL),('2025-10-01 17:02:09.771209',NULL,'2025-10-01 17:02:09.823348',222,222,'b92b509d372144dd8cbe29e18bab1676','f13a2268-8113-4f53-8caf-72d754c98edf',71,'e7862d18aeb143d49259310c073583be','gigabytes',1,'2025-10-02 17:02:09',NULL),('2025-10-01 17:02:09.788418',NULL,'2025-10-01 17:02:09.823348',223,223,NULL,'8a525933-b4ce-471f-a95c-1767c3893a91',74,'e7862d18aeb143d49259310c073583be','shares',1,'2025-10-02 17:02:09','dd944c2a-e556-4a92-a900-c197e5952e3a'),('2025-10-01 17:02:09.792833',NULL,'2025-10-01 17:02:09.823348',224,224,NULL,'518e84d4-d5f9-44a0-a0ef-20f1fd889817',73,'e7862d18aeb143d49259310c073583be','gigabytes',1,'2025-10-02 17:02:09','dd944c2a-e556-4a92-a900-c197e5952e3a'),('2025-10-01 17:02:10.499706',NULL,'2025-10-01 17:02:10.535276',225,225,'3dce165987c44fe28fc0096cce9ddb2b','3d150bfd-9c95-436f-b291-f68733c5200e',75,'06efa1ba477e45208d5ba21e3e7c2703','shares',1,'2025-10-02 17:02:10',NULL),('2025-10-01 17:02:10.501404',NULL,'2025-10-01 17:02:10.535276',226,226,'3dce165987c44fe28fc0096cce9ddb2b','cf3ef20f-bce0-4156-8224-f6009269cae8',76,'06efa1ba477e45208d5ba21e3e7c2703','gigabytes',1,'2025-10-02 17:02:10',NULL),('2025-10-01 17:02:10.510188',NULL,'2025-10-01 17:02:10.535276',227,227,NULL,'388aab67-2e94-4670-8a3d-c1852de9ee26',77,'06efa1ba477e45208d5ba21e3e7c2703','shares',1,'2025-10-02 17:02:10','354dd354-8b0a-40a4-9641-b0e3560a975d'),('2025-10-01 17:02:10.511300',NULL,'2025-10-01 17:02:10.535276',228,228,NULL,'724e9a9b-b04c-4daf-8bca-18d9c1a506ae',78,'06efa1ba477e45208d5ba21e3e7c2703','gigabytes',1,'2025-10-02 17:02:10','354dd354-8b0a-40a4-9641-b0e3560a975d'),('2025-10-01 17:02:11.828485',NULL,'2025-10-01 17:02:11.916548',229,229,'ea1821978b91472190eb48dbc2127e63','d6f41eb5-3e9b-49aa-a40f-c9af2b4ad457',80,'0146329fc8d749b394ed822844000f6d','shares',1,'2025-10-02 17:02:11',NULL),('2025-10-01 17:02:11.830262',NULL,'2025-10-01 17:02:11.916548',230,230,'ea1821978b91472190eb48dbc2127e63','78c2f7cb-a983-40fc-8665-074ab0e938ae',79,'0146329fc8d749b394ed822844000f6d','gigabytes',1,'2025-10-02 17:02:11',NULL),('2025-10-01 17:02:11.865110',NULL,'2025-10-01 17:02:11.916548',231,231,NULL,'35453871-70a2-426f-ad30-81ff5792b3e4',82,'0146329fc8d749b394ed822844000f6d','shares',1,'2025-10-02 17:02:11','cd7fa723-e40d-401a-9a30-e34fb52e7764'),('2025-10-01 17:02:11.867019',NULL,'2025-10-01 17:02:11.916548',232,232,NULL,'78763912-ae10-47a6-936d-adaa91bb58ac',81,'0146329fc8d749b394ed822844000f6d','gigabytes',1,'2025-10-02 17:02:11','cd7fa723-e40d-401a-9a30-e34fb52e7764'),('2025-10-01 17:02:12.676808',NULL,'2025-10-01 17:02:12.741067',233,233,'0330a1c6d11e45b8a6e21e8e46c29677','2b5dab63-8ed5-453a-9309-9cd2ef339141',52,'0e7ac90f0c9f41cbb8e463ae95d18d81','shares',-1,'2025-10-02 17:02:12',NULL),('2025-10-01 17:02:12.679870',NULL,'2025-10-01 17:02:12.741067',234,234,'0330a1c6d11e45b8a6e21e8e46c29677','216cf3ec-484b-472a-80c7-8286bf855cfd',51,'0e7ac90f0c9f41cbb8e463ae95d18d81','gigabytes',-1,'2025-10-02 17:02:12',NULL),('2025-10-01 17:02:12.715134',NULL,'2025-10-01 17:02:12.741067',235,235,NULL,'84174486-f483-4e22-ab25-f7842d7b0402',54,'0e7ac90f0c9f41cbb8e463ae95d18d81','shares',-1,'2025-10-02 17:02:12','f0348654-6331-4c8a-89cf-95b9f1fa588d'),('2025-10-01 17:02:12.716030',NULL,'2025-10-01 17:02:12.741067',236,236,NULL,'45314953-7b88-44b8-9abb-d72fe14da3a7',53,'0e7ac90f0c9f41cbb8e463ae95d18d81','gigabytes',-1,'2025-10-02 17:02:12','f0348654-6331-4c8a-89cf-95b9f1fa588d'),('2025-10-01 17:02:14.364808',NULL,'2025-10-01 17:02:14.405982',237,237,'b92b509d372144dd8cbe29e18bab1676','1f8cf52a-7f1c-4233-a4fa-c63a6f06bcc5',72,'e7862d18aeb143d49259310c073583be','shares',-1,'2025-10-02 17:02:14',NULL),('2025-10-01 17:02:14.365945',NULL,'2025-10-01 17:02:14.405982',238,238,'b92b509d372144dd8cbe29e18bab1676','1f0e936b-0541-44e8-b889-5e9b4c572819',71,'e7862d18aeb143d49259310c073583be','gigabytes',-1,'2025-10-02 17:02:14',NULL),('2025-10-01 17:02:14.386847',NULL,'2025-10-01 17:02:14.405982',239,239,NULL,'6855ba29-39f6-4cfc-bd37-ed7f573db662',74,'e7862d18aeb143d49259310c073583be','shares',-1,'2025-10-02 17:02:14','dd944c2a-e556-4a92-a900-c197e5952e3a'),('2025-10-01 17:02:14.387896',NULL,'2025-10-01 17:02:14.405982',240,240,NULL,'11655a50-31a3-422c-a673-120f0565818c',73,'e7862d18aeb143d49259310c073583be','gigabytes',-1,'2025-10-02 17:02:14','dd944c2a-e556-4a92-a900-c197e5952e3a'),('2025-10-01 17:02:15.462909',NULL,'2025-10-01 17:02:15.563630',241,241,'ea1821978b91472190eb48dbc2127e63','6e04ece1-7764-4dd1-af50-863ba853dd54',83,'0146329fc8d749b394ed822844000f6d','snapshots',1,'2025-10-02 17:02:15',NULL),('2025-10-01 17:02:15.464271',NULL,'2025-10-01 17:02:15.563630',242,242,'ea1821978b91472190eb48dbc2127e63','2dc4129b-bb6a-4999-9eac-d6e297ff3dee',84,'0146329fc8d749b394ed822844000f6d','snapshot_gigabytes',1,'2025-10-02 17:02:15',NULL),('2025-10-01 17:02:15.478700',NULL,'2025-10-01 17:02:15.563630',243,243,NULL,'c80007f8-c4d5-4efa-92e1-fa0e9fee691c',85,'0146329fc8d749b394ed822844000f6d','snapshots',1,'2025-10-02 17:02:15','cd7fa723-e40d-401a-9a30-e34fb52e7764'),('2025-10-01 17:02:15.479851',NULL,'2025-10-01 17:02:15.563630',244,244,NULL,'ca56864b-3f7a-40b5-a15d-5dfb929adc8f',86,'0146329fc8d749b394ed822844000f6d','snapshot_gigabytes',1,'2025-10-02 17:02:15','cd7fa723-e40d-401a-9a30-e34fb52e7764'),('2025-10-01 17:02:15.885037',NULL,'2025-10-01 17:02:15.900966',245,245,'3dce165987c44fe28fc0096cce9ddb2b','a8b0650f-cce8-4d0f-9abf-f4bcf4f1a43f',75,'06efa1ba477e45208d5ba21e3e7c2703','shares',-1,'2025-10-02 17:02:15',NULL),('2025-10-01 17:02:15.886209',NULL,'2025-10-01 17:02:15.900966',246,246,'3dce165987c44fe28fc0096cce9ddb2b','46b5f0a4-2c3d-48fd-991b-55800986683f',76,'06efa1ba477e45208d5ba21e3e7c2703','gigabytes',-1,'2025-10-02 17:02:15',NULL),('2025-10-01 17:02:15.892742',NULL,'2025-10-01 17:02:15.900966',247,247,NULL,'c4c7f796-d81f-49a1-adba-36032b571a08',77,'06efa1ba477e45208d5ba21e3e7c2703','shares',-1,'2025-10-02 17:02:15','354dd354-8b0a-40a4-9641-b0e3560a975d'),('2025-10-01 17:02:15.893802',NULL,'2025-10-01 17:02:15.900966',248,248,NULL,'e6a8f84f-ecea-4f32-abb8-8c71dc9427b6',78,'06efa1ba477e45208d5ba21e3e7c2703','gigabytes',-1,'2025-10-02 17:02:15','354dd354-8b0a-40a4-9641-b0e3560a975d'),('2025-10-01 17:02:18.861590',NULL,'2025-10-01 17:02:18.890774',249,249,'3dce165987c44fe28fc0096cce9ddb2b','9b7572dc-ac1e-4c8e-bc82-13a84ee64c44',75,'06efa1ba477e45208d5ba21e3e7c2703','shares',1,'2025-10-02 17:02:18',NULL),('2025-10-01 17:02:18.862756',NULL,'2025-10-01 17:02:18.890774',250,250,'3dce165987c44fe28fc0096cce9ddb2b','8fa2b9d5-ad9f-495e-82f0-c99623d8ea13',76,'06efa1ba477e45208d5ba21e3e7c2703','gigabytes',1,'2025-10-02 17:02:18',NULL),('2025-10-01 17:02:18.867912',NULL,'2025-10-01 17:02:18.890774',251,251,NULL,'a51ec168-0280-42cb-9d8a-55385c76800d',77,'06efa1ba477e45208d5ba21e3e7c2703','shares',1,'2025-10-02 17:02:18','354dd354-8b0a-40a4-9641-b0e3560a975d'),('2025-10-01 17:02:18.870962',NULL,'2025-10-01 17:02:18.890774',252,252,NULL,'47fe174e-e708-4bca-b71b-921df8ca2f4a',78,'06efa1ba477e45208d5ba21e3e7c2703','gigabytes',1,'2025-10-02 17:02:18','354dd354-8b0a-40a4-9641-b0e3560a975d'),('2025-10-01 17:02:21.044119',NULL,'2025-10-01 17:02:21.064588',253,253,'ea1821978b91472190eb48dbc2127e63','22ef500a-5076-4b2b-89f1-4c3a33782ee6',83,'0146329fc8d749b394ed822844000f6d','snapshots',-1,'2025-10-02 17:02:21',NULL),('2025-10-01 17:02:21.045095',NULL,'2025-10-01 17:02:21.064588',254,254,'ea1821978b91472190eb48dbc2127e63','1e1ff2be-0532-433a-a0a5-388c27290d17',84,'0146329fc8d749b394ed822844000f6d','snapshot_gigabytes',-1,'2025-10-02 17:02:21',NULL),('2025-10-01 17:02:21.054141',NULL,'2025-10-01 17:02:21.064588',255,255,NULL,'65b8b8ce-dc74-48c6-98f7-c5dc0c4f80bb',85,'0146329fc8d749b394ed822844000f6d','snapshots',-1,'2025-10-02 17:02:21','cd7fa723-e40d-401a-9a30-e34fb52e7764'),('2025-10-01 17:02:21.055332',NULL,'2025-10-01 17:02:21.064588',256,256,NULL,'3bce0bcd-79f7-48cf-9323-6529ffae2d99',86,'0146329fc8d749b394ed822844000f6d','snapshot_gigabytes',-1,'2025-10-02 17:02:21','cd7fa723-e40d-401a-9a30-e34fb52e7764'),('2025-10-01 17:02:23.177546',NULL,'2025-10-01 17:02:23.214238',257,257,'3dce165987c44fe28fc0096cce9ddb2b','23ec46c0-5fea-4884-88a4-9d7689fba53a',75,'06efa1ba477e45208d5ba21e3e7c2703','shares',-1,'2025-10-02 17:02:23',NULL),('2025-10-01 17:02:23.178283',NULL,'2025-10-01 17:02:23.214238',258,258,'3dce165987c44fe28fc0096cce9ddb2b','44fd13ac-b150-4b87-baed-a126cef53c78',76,'06efa1ba477e45208d5ba21e3e7c2703','gigabytes',-1,'2025-10-02 17:02:23',NULL),('2025-10-01 17:02:23.194208',NULL,'2025-10-01 17:02:23.214238',259,259,NULL,'0e726032-a258-4011-bb78-0029656ae1d4',77,'06efa1ba477e45208d5ba21e3e7c2703','shares',-1,'2025-10-02 17:02:23','354dd354-8b0a-40a4-9641-b0e3560a975d'),('2025-10-01 17:02:23.194928',NULL,'2025-10-01 17:02:23.214238',260,260,NULL,'4b20d0ae-99d7-4c07-87d5-4f809bf30139',78,'06efa1ba477e45208d5ba21e3e7c2703','gigabytes',-1,'2025-10-02 17:02:23','354dd354-8b0a-40a4-9641-b0e3560a975d'),('2025-10-01 17:02:25.339709',NULL,'2025-10-01 17:02:26.082440',261,261,'ea1821978b91472190eb48dbc2127e63','43041559-81eb-4221-8201-c7b50d710d9a',80,'0146329fc8d749b394ed822844000f6d','shares',-1,'2025-10-02 17:02:25',NULL),('2025-10-01 17:02:25.340741',NULL,'2025-10-01 17:02:26.082440',262,262,'ea1821978b91472190eb48dbc2127e63','39467aaf-e978-4448-93df-2e867de5632c',79,'0146329fc8d749b394ed822844000f6d','gigabytes',-1,'2025-10-02 17:02:25',NULL),('2025-10-01 17:02:26.006711',NULL,'2025-10-01 17:02:26.082440',263,263,NULL,'f55f86ce-d8fa-4c32-b830-d0d6f0324c45',82,'0146329fc8d749b394ed822844000f6d','shares',-1,'2025-10-02 17:02:25','cd7fa723-e40d-401a-9a30-e34fb52e7764'),('2025-10-01 17:02:26.013163',NULL,'2025-10-01 17:02:26.082440',264,264,NULL,'069115b1-45f1-43ec-896f-b758371beb16',81,'0146329fc8d749b394ed822844000f6d','gigabytes',-1,'2025-10-02 17:02:25','cd7fa723-e40d-401a-9a30-e34fb52e7764'),('2025-10-01 17:02:26.392413',NULL,'2025-10-01 17:02:26.517126',265,265,'3dce165987c44fe28fc0096cce9ddb2b','91e28191-2220-4106-864b-2f8956e315af',75,'06efa1ba477e45208d5ba21e3e7c2703','shares',1,'2025-10-02 17:02:26',NULL),('2025-10-01 17:02:26.393527',NULL,'2025-10-01 17:02:26.517126',266,266,'3dce165987c44fe28fc0096cce9ddb2b','49a3a64c-8cd0-42f9-9d21-7690da37ec99',76,'06efa1ba477e45208d5ba21e3e7c2703','gigabytes',1,'2025-10-02 17:02:26',NULL),('2025-10-01 17:02:26.418090',NULL,'2025-10-01 17:02:26.517126',267,267,NULL,'172b9ae9-a624-41e4-a839-55724358f72c',77,'06efa1ba477e45208d5ba21e3e7c2703','shares',1,'2025-10-02 17:02:26','354dd354-8b0a-40a4-9641-b0e3560a975d'),('2025-10-01 17:02:26.419390',NULL,'2025-10-01 17:02:26.517126',268,268,NULL,'1a9624b0-70f5-4817-a163-fa3bf821fb82',78,'06efa1ba477e45208d5ba21e3e7c2703','gigabytes',1,'2025-10-02 17:02:26','354dd354-8b0a-40a4-9641-b0e3560a975d'),('2025-10-01 17:02:27.333231',NULL,'2025-10-01 17:02:27.385684',269,269,'7b7b6f82426848dc984e282a4a4ae2bb','77732399-290f-471c-87ef-0e91f93d4241',87,'f15311ab27ef411d82024fc6390e3f6d','shares',1,'2025-10-02 17:02:27',NULL),('2025-10-01 17:02:27.334672',NULL,'2025-10-01 17:02:27.385684',270,270,'7b7b6f82426848dc984e282a4a4ae2bb','96f24d2a-09be-4cab-a4e6-dd388ab20275',88,'f15311ab27ef411d82024fc6390e3f6d','gigabytes',1,'2025-10-02 17:02:27',NULL),('2025-10-01 17:02:27.353972',NULL,'2025-10-01 17:02:27.385684',271,271,NULL,'802c724d-27fb-4a6f-8c86-3f02376ef5b2',89,'f15311ab27ef411d82024fc6390e3f6d','shares',1,'2025-10-02 17:02:27','3f2b10b6-f512-41f8-802d-43b4c478360e'),('2025-10-01 17:02:27.355652',NULL,'2025-10-01 17:02:27.385684',272,272,NULL,'c4e0a6f6-a3e9-48a6-a40b-d357245df4b2',90,'f15311ab27ef411d82024fc6390e3f6d','gigabytes',1,'2025-10-02 17:02:27','3f2b10b6-f512-41f8-802d-43b4c478360e'),('2025-10-01 17:02:29.084998',NULL,'2025-10-01 17:02:29.152393',273,273,'0fc8d89ad29f495783c39738774ff7cd','d9f3f09f-9d43-44b0-a7af-4337638d9ade',91,'d36f1681b7b349a5bf71bdac8eae5902','shares',1,'2025-10-02 17:02:29',NULL),('2025-10-01 17:02:29.086896',NULL,'2025-10-01 17:02:29.152393',274,274,'0fc8d89ad29f495783c39738774ff7cd','feec87f4-70f8-4b6e-a71d-5a137ed6aeda',92,'d36f1681b7b349a5bf71bdac8eae5902','gigabytes',1,'2025-10-02 17:02:29',NULL),('2025-10-01 17:02:29.103474',NULL,'2025-10-01 17:02:29.152393',275,275,NULL,'6c6ed206-1176-4ed0-97ef-567f74f54ee0',93,'d36f1681b7b349a5bf71bdac8eae5902','shares',1,'2025-10-02 17:02:29','07c916e4-5e73-4eaa-9e77-984c3d94747e'),('2025-10-01 17:02:29.105658',NULL,'2025-10-01 17:02:29.152393',276,276,NULL,'33aeef4a-64e8-47bb-9e64-356cd88c6b78',94,'d36f1681b7b349a5bf71bdac8eae5902','gigabytes',1,'2025-10-02 17:02:29','07c916e4-5e73-4eaa-9e77-984c3d94747e'),('2025-10-01 17:02:31.187854',NULL,'2025-10-01 17:02:31.232992',277,277,'7b7b6f82426848dc984e282a4a4ae2bb','ccd5d589-5427-4890-b8ed-8abaf5233979',87,'f15311ab27ef411d82024fc6390e3f6d','shares',-1,'2025-10-02 17:02:31',NULL),('2025-10-01 17:02:31.188672',NULL,'2025-10-01 17:02:31.232992',278,278,'7b7b6f82426848dc984e282a4a4ae2bb','b95e8730-a0c1-4a92-b90d-7c98b2bf39b8',88,'f15311ab27ef411d82024fc6390e3f6d','gigabytes',-1,'2025-10-02 17:02:31',NULL),('2025-10-01 17:02:31.207560',NULL,'2025-10-01 17:02:31.232992',279,279,NULL,'9b8a02d8-908e-43f3-a345-5aec87706336',89,'f15311ab27ef411d82024fc6390e3f6d','shares',-1,'2025-10-02 17:02:31','3f2b10b6-f512-41f8-802d-43b4c478360e'),('2025-10-01 17:02:31.211319',NULL,'2025-10-01 17:02:31.232992',280,280,NULL,'46aae7c3-eceb-446a-93e4-fe10b30bfcad',90,'f15311ab27ef411d82024fc6390e3f6d','gigabytes',-1,'2025-10-02 17:02:31','3f2b10b6-f512-41f8-802d-43b4c478360e'),('2025-10-01 17:02:31.479549',NULL,'2025-10-01 17:02:31.518200',281,281,'7b7b6f82426848dc984e282a4a4ae2bb','d217f919-25b2-4bb6-9c10-0cd2fe2bc55e',87,'f15311ab27ef411d82024fc6390e3f6d','shares',1,'2025-10-02 17:02:31',NULL),('2025-10-01 17:02:31.480771',NULL,'2025-10-01 17:02:31.518200',282,282,'7b7b6f82426848dc984e282a4a4ae2bb','67bb116f-4233-4340-a9a5-1cf9aab41fe7',88,'f15311ab27ef411d82024fc6390e3f6d','gigabytes',1,'2025-10-02 17:02:31',NULL),('2025-10-01 17:02:31.492554',NULL,'2025-10-01 17:02:31.518200',283,283,NULL,'54b56b47-79c2-4d4d-ab1e-dc5b65b5ef44',96,'f15311ab27ef411d82024fc6390e3f6d','shares',1,'2025-10-02 17:02:31','bb28b531-7011-4456-8d2d-6fe0cb38ac18'),('2025-10-01 17:02:31.494166',NULL,'2025-10-01 17:02:31.518200',284,284,NULL,'42e96a09-cb6c-4514-b600-ed91965f2cf2',95,'f15311ab27ef411d82024fc6390e3f6d','gigabytes',1,'2025-10-02 17:02:31','bb28b531-7011-4456-8d2d-6fe0cb38ac18'),('2025-10-01 17:02:32.405091',NULL,'2025-10-01 17:02:32.811002',285,285,'3dce165987c44fe28fc0096cce9ddb2b','2e14ac94-d988-4809-b5e6-8d6dbb8b13c9',75,'06efa1ba477e45208d5ba21e3e7c2703','shares',-1,'2025-10-02 17:02:32',NULL),('2025-10-01 17:02:32.406934',NULL,'2025-10-01 17:02:32.811002',286,286,'3dce165987c44fe28fc0096cce9ddb2b','139db001-d330-48f3-b411-2527fd95a4b2',76,'06efa1ba477e45208d5ba21e3e7c2703','gigabytes',-1,'2025-10-02 17:02:32',NULL),('2025-10-01 17:02:32.462693',NULL,'2025-10-01 17:02:32.811002',287,287,NULL,'fe838c41-451c-42c4-a564-9b4d14323298',77,'06efa1ba477e45208d5ba21e3e7c2703','shares',-1,'2025-10-02 17:02:32','354dd354-8b0a-40a4-9641-b0e3560a975d'),('2025-10-01 17:02:32.463531',NULL,'2025-10-01 17:02:32.811002',288,288,NULL,'d2403457-2861-42ab-aa95-a01b43ca1bd3',78,'06efa1ba477e45208d5ba21e3e7c2703','gigabytes',-1,'2025-10-02 17:02:32','354dd354-8b0a-40a4-9641-b0e3560a975d'),('2025-10-01 17:02:34.474907',NULL,'2025-10-01 17:02:34.509825',289,289,'0fc8d89ad29f495783c39738774ff7cd','0ff1a5f2-1e2a-4d5f-94a5-48c44ea234a0',91,'d36f1681b7b349a5bf71bdac8eae5902','shares',-1,'2025-10-02 17:02:34',NULL),('2025-10-01 17:02:34.475989',NULL,'2025-10-01 17:02:34.509825',290,290,'0fc8d89ad29f495783c39738774ff7cd','26f5c369-c29e-486f-9068-e61021aeb462',92,'d36f1681b7b349a5bf71bdac8eae5902','gigabytes',-1,'2025-10-02 17:02:34',NULL),('2025-10-01 17:02:34.496326',NULL,'2025-10-01 17:02:34.509825',291,291,NULL,'2e52c09c-1ca4-4a07-9987-96468380f71b',93,'d36f1681b7b349a5bf71bdac8eae5902','shares',-1,'2025-10-02 17:02:34','07c916e4-5e73-4eaa-9e77-984c3d94747e'),('2025-10-01 17:02:34.497177',NULL,'2025-10-01 17:02:34.509825',292,292,NULL,'6136f476-744a-4438-b0f4-6084533d1019',94,'d36f1681b7b349a5bf71bdac8eae5902','gigabytes',-1,'2025-10-02 17:02:34','07c916e4-5e73-4eaa-9e77-984c3d94747e'),('2025-10-01 17:02:35.156938',NULL,'2025-10-01 17:02:35.197961',293,293,'7b7b6f82426848dc984e282a4a4ae2bb','5262fbf5-fbb1-4d6f-820c-5cfea9b441cf',87,'f15311ab27ef411d82024fc6390e3f6d','shares',-1,'2025-10-02 17:02:35',NULL),('2025-10-01 17:02:35.157733',NULL,'2025-10-01 17:02:35.197961',294,294,'7b7b6f82426848dc984e282a4a4ae2bb','96e8edad-1c75-42b1-a107-178dc69d113d',88,'f15311ab27ef411d82024fc6390e3f6d','gigabytes',-1,'2025-10-02 17:02:35',NULL),('2025-10-01 17:02:35.188110',NULL,'2025-10-01 17:02:35.197961',295,295,NULL,'6be04a09-e7a3-49c8-92f2-0fc0c1bb5cca',96,'f15311ab27ef411d82024fc6390e3f6d','shares',-1,'2025-10-02 17:02:35','bb28b531-7011-4456-8d2d-6fe0cb38ac18'),('2025-10-01 17:02:35.189525',NULL,'2025-10-01 17:02:35.197961',296,296,NULL,'8964a936-d72e-461e-b3b8-51d58b03e88c',95,'f15311ab27ef411d82024fc6390e3f6d','gigabytes',-1,'2025-10-02 17:02:35','bb28b531-7011-4456-8d2d-6fe0cb38ac18'),('2025-10-01 17:02:35.608887',NULL,'2025-10-01 17:02:35.668209',297,297,'7b7b6f82426848dc984e282a4a4ae2bb','bbc29982-24e4-414f-a919-d94c16ae61be',87,'f15311ab27ef411d82024fc6390e3f6d','shares',1,'2025-10-02 17:02:35',NULL),('2025-10-01 17:02:35.610299',NULL,'2025-10-01 17:02:35.668209',298,298,'7b7b6f82426848dc984e282a4a4ae2bb','46588a93-5cf6-45d6-a3be-ec580d4de665',88,'f15311ab27ef411d82024fc6390e3f6d','gigabytes',1,'2025-10-02 17:02:35',NULL),('2025-10-01 17:02:35.634852',NULL,'2025-10-01 17:02:35.668209',299,299,NULL,'465e0975-1e73-470d-a57f-1c817864cc63',98,'f15311ab27ef411d82024fc6390e3f6d','shares',1,'2025-10-02 17:02:35','584a5070-565d-40c4-835e-9ead21030114'),('2025-10-01 17:02:35.636419',NULL,'2025-10-01 17:02:35.668209',300,300,NULL,'12ecae5b-8b54-49fb-8618-fef48649b2c4',97,'f15311ab27ef411d82024fc6390e3f6d','gigabytes',1,'2025-10-02 17:02:35','584a5070-565d-40c4-835e-9ead21030114'),('2025-10-01 17:02:37.596494',NULL,'2025-10-01 17:02:37.657504',301,301,'3dce165987c44fe28fc0096cce9ddb2b','a66c190b-0376-4d13-9a88-77b7827da6a0',75,'06efa1ba477e45208d5ba21e3e7c2703','shares',1,'2025-10-02 17:02:37',NULL),('2025-10-01 17:02:37.598131',NULL,'2025-10-01 17:02:37.657504',302,302,'3dce165987c44fe28fc0096cce9ddb2b','24492008-700b-43e7-9fb4-74c02d6b9dee',76,'06efa1ba477e45208d5ba21e3e7c2703','gigabytes',1,'2025-10-02 17:02:37',NULL),('2025-10-01 17:02:37.613578',NULL,'2025-10-01 17:02:37.657504',303,303,NULL,'462f48b0-a276-4442-a364-924db1a341bb',77,'06efa1ba477e45208d5ba21e3e7c2703','shares',1,'2025-10-02 17:02:37','354dd354-8b0a-40a4-9641-b0e3560a975d'),('2025-10-01 17:02:37.614785',NULL,'2025-10-01 17:02:37.657504',304,304,NULL,'e3fc5c01-8c80-47b1-8df5-a07bdade478e',78,'06efa1ba477e45208d5ba21e3e7c2703','gigabytes',1,'2025-10-02 17:02:37','354dd354-8b0a-40a4-9641-b0e3560a975d'),('2025-10-01 17:02:39.352929',NULL,'2025-10-01 17:02:39.393181',305,305,'7b7b6f82426848dc984e282a4a4ae2bb','54b55f80-0b2a-430c-89bb-3d0215f3e5ee',87,'f15311ab27ef411d82024fc6390e3f6d','shares',-1,'2025-10-02 17:02:39',NULL),('2025-10-01 17:02:39.353609',NULL,'2025-10-01 17:02:39.393181',306,306,'7b7b6f82426848dc984e282a4a4ae2bb','d915c5f9-bf01-4d31-aca1-c74b63fa0f59',88,'f15311ab27ef411d82024fc6390e3f6d','gigabytes',-1,'2025-10-02 17:02:39',NULL),('2025-10-01 17:02:39.384874',NULL,'2025-10-01 17:02:39.393181',307,307,NULL,'0f356077-697f-44cb-9381-16aa69429b04',98,'f15311ab27ef411d82024fc6390e3f6d','shares',-1,'2025-10-02 17:02:39','584a5070-565d-40c4-835e-9ead21030114'),('2025-10-01 17:02:39.385616',NULL,'2025-10-01 17:02:39.393181',308,308,NULL,'ce59e3a6-3a7c-4d6b-9ea4-d94a91f4e5d7',97,'f15311ab27ef411d82024fc6390e3f6d','gigabytes',-1,'2025-10-02 17:02:39','584a5070-565d-40c4-835e-9ead21030114'),('2025-10-01 17:02:39.787385',NULL,'2025-10-01 17:02:39.857225',309,309,'7b7b6f82426848dc984e282a4a4ae2bb','4f376e38-2eb9-4eb4-b974-162178d50cca',87,'f15311ab27ef411d82024fc6390e3f6d','shares',1,'2025-10-02 17:02:39',NULL),('2025-10-01 17:02:39.789629',NULL,'2025-10-01 17:02:39.857225',310,310,'7b7b6f82426848dc984e282a4a4ae2bb','6ac6df20-fcb9-4fff-b38f-dc08e99389f4',88,'f15311ab27ef411d82024fc6390e3f6d','gigabytes',1,'2025-10-02 17:02:39',NULL),('2025-10-01 17:02:39.818399',NULL,'2025-10-01 17:02:39.857225',311,311,NULL,'32ed60f3-5c94-4e51-9ceb-1529cad53ff4',100,'f15311ab27ef411d82024fc6390e3f6d','shares',1,'2025-10-02 17:02:39','4211893b-b8e2-4a67-bb8a-d9c7ef2f16a2'),('2025-10-01 17:02:39.824777',NULL,'2025-10-01 17:02:39.857225',312,312,NULL,'12192a01-4099-4e5a-bd33-22d00e15c3d7',99,'f15311ab27ef411d82024fc6390e3f6d','gigabytes',1,'2025-10-02 17:02:39','4211893b-b8e2-4a67-bb8a-d9c7ef2f16a2'),('2025-10-01 17:02:43.468245',NULL,'2025-10-01 17:02:43.589935',313,313,'7b7b6f82426848dc984e282a4a4ae2bb','abd022c3-234f-41c8-9b0c-54f488426c82',87,'f15311ab27ef411d82024fc6390e3f6d','shares',-1,'2025-10-02 17:02:43',NULL),('2025-10-01 17:02:43.469218',NULL,'2025-10-01 17:02:43.589935',314,314,'7b7b6f82426848dc984e282a4a4ae2bb','8c0a3c53-e015-4fa9-be0c-20423543908b',88,'f15311ab27ef411d82024fc6390e3f6d','gigabytes',-1,'2025-10-02 17:02:43',NULL),('2025-10-01 17:02:43.559115',NULL,'2025-10-01 17:02:43.589935',315,315,NULL,'3282b055-e0a1-4d31-bb33-717182964e7f',100,'f15311ab27ef411d82024fc6390e3f6d','shares',-1,'2025-10-02 17:02:43','4211893b-b8e2-4a67-bb8a-d9c7ef2f16a2'),('2025-10-01 17:02:43.560373',NULL,'2025-10-01 17:02:43.589935',316,316,NULL,'3e57154e-878e-4ad2-b432-2c51f1226a07',99,'f15311ab27ef411d82024fc6390e3f6d','gigabytes',-1,'2025-10-02 17:02:43','4211893b-b8e2-4a67-bb8a-d9c7ef2f16a2'),('2025-10-01 17:02:43.991738',NULL,'2025-10-01 17:02:44.021361',317,317,'7b7b6f82426848dc984e282a4a4ae2bb','ec53e5cf-bcd2-4822-9191-6f132f5163cc',87,'f15311ab27ef411d82024fc6390e3f6d','shares',1,'2025-10-02 17:02:43',NULL),('2025-10-01 17:02:43.994408',NULL,'2025-10-01 17:02:44.021361',318,318,'7b7b6f82426848dc984e282a4a4ae2bb','0592b70d-162a-4dd6-ad49-d23f7df25550',88,'f15311ab27ef411d82024fc6390e3f6d','gigabytes',1,'2025-10-02 17:02:43',NULL),('2025-10-01 17:02:44.003506',NULL,'2025-10-01 17:02:44.021361',319,319,NULL,'5b18887c-860a-46be-bdcb-c871255119f4',101,'f15311ab27ef411d82024fc6390e3f6d','shares',1,'2025-10-02 17:02:43','4fc47fc1-7587-4c59-80e9-5db74e7ecbe3'),('2025-10-01 17:02:44.004577',NULL,'2025-10-01 17:02:44.021361',320,320,NULL,'567e7b55-aaef-4f64-a6fb-2a4986d6156d',102,'f15311ab27ef411d82024fc6390e3f6d','gigabytes',1,'2025-10-02 17:02:43','4fc47fc1-7587-4c59-80e9-5db74e7ecbe3'),('2025-10-01 17:02:44.479682',NULL,'2025-10-01 17:02:44.494904',321,321,'3dce165987c44fe28fc0096cce9ddb2b','e5563ee9-6ff9-4b82-b708-4c39dff126d5',75,'06efa1ba477e45208d5ba21e3e7c2703','shares',-1,'2025-10-02 17:02:44',NULL),('2025-10-01 17:02:44.480737',NULL,'2025-10-01 17:02:44.494904',322,322,'3dce165987c44fe28fc0096cce9ddb2b','d757f7cc-4b48-4933-9416-350b914229b4',76,'06efa1ba477e45208d5ba21e3e7c2703','gigabytes',-1,'2025-10-02 17:02:44',NULL),('2025-10-01 17:02:44.486268',NULL,'2025-10-01 17:02:44.494904',323,323,NULL,'c25d3bf1-0b20-4151-8036-668d89ba5b59',77,'06efa1ba477e45208d5ba21e3e7c2703','shares',-1,'2025-10-02 17:02:44','354dd354-8b0a-40a4-9641-b0e3560a975d'),('2025-10-01 17:02:44.486888',NULL,'2025-10-01 17:02:44.494904',324,324,NULL,'26285c80-e76c-4eed-b1a0-e27ee6c7f9c0',78,'06efa1ba477e45208d5ba21e3e7c2703','gigabytes',-1,'2025-10-02 17:02:44','354dd354-8b0a-40a4-9641-b0e3560a975d'),('2025-10-01 17:02:48.168452',NULL,'2025-10-01 17:02:48.217844',325,325,'7b7b6f82426848dc984e282a4a4ae2bb','f3f6dbb0-98f7-4ff0-ad9c-33306d4c345f',87,'f15311ab27ef411d82024fc6390e3f6d','shares',-1,'2025-10-02 17:02:48',NULL),('2025-10-01 17:02:48.169189',NULL,'2025-10-01 17:02:48.217844',326,326,'7b7b6f82426848dc984e282a4a4ae2bb','56f93899-c015-4cf8-8a8d-ae66e4056db8',88,'f15311ab27ef411d82024fc6390e3f6d','gigabytes',-1,'2025-10-02 17:02:48',NULL),('2025-10-01 17:02:48.206531',NULL,'2025-10-01 17:02:48.217844',327,327,NULL,'c142be2e-6333-4bc0-b81f-97e958d36c06',101,'f15311ab27ef411d82024fc6390e3f6d','shares',-1,'2025-10-02 17:02:48','4fc47fc1-7587-4c59-80e9-5db74e7ecbe3'),('2025-10-01 17:02:48.207862',NULL,'2025-10-01 17:02:48.217844',328,328,NULL,'19c4e1c2-bc28-4136-8e1e-d60ccf9b215f',102,'f15311ab27ef411d82024fc6390e3f6d','gigabytes',-1,'2025-10-02 17:02:48','4fc47fc1-7587-4c59-80e9-5db74e7ecbe3'),('2025-10-01 17:02:49.481631',NULL,'2025-10-01 17:02:49.545419',329,329,'6ae885d77a5748a299ec5daaece928c1','0be6383a-3738-4be4-b14b-7549d213c907',104,'1841221f332340a299707d253063659f','shares',1,'2025-10-02 17:02:49',NULL),('2025-10-01 17:02:49.482900',NULL,'2025-10-01 17:02:49.545419',330,330,'6ae885d77a5748a299ec5daaece928c1','e89f9557-c48a-452e-80f3-1b4c8b075887',103,'1841221f332340a299707d253063659f','gigabytes',1,'2025-10-02 17:02:49',NULL),('2025-10-01 17:02:49.501676',NULL,'2025-10-01 17:02:49.545419',331,331,NULL,'f18c809e-b688-444d-a2fa-9ae409c4f487',106,'1841221f332340a299707d253063659f','shares',1,'2025-10-02 17:02:49','3454de97-e8db-4b3e-a708-5ac562e85e73'),('2025-10-01 17:02:49.503872',NULL,'2025-10-01 17:02:49.545419',332,332,NULL,'544e55bd-c92f-4902-bbf3-343d33fee2c1',105,'1841221f332340a299707d253063659f','gigabytes',1,'2025-10-02 17:02:49','3454de97-e8db-4b3e-a708-5ac562e85e73'),('2025-10-01 17:02:50.932533',NULL,'2025-10-01 17:02:50.990005',333,333,'3dce165987c44fe28fc0096cce9ddb2b','0350290c-14fa-47a0-ba53-ddaf5e15553f',75,'06efa1ba477e45208d5ba21e3e7c2703','shares',-1,'2025-10-02 17:02:50',NULL),('2025-10-01 17:02:50.933833',NULL,'2025-10-01 17:02:50.990005',334,334,'3dce165987c44fe28fc0096cce9ddb2b','ffcae967-c3e6-42bd-9662-3602d0b2a46f',76,'06efa1ba477e45208d5ba21e3e7c2703','gigabytes',-1,'2025-10-02 17:02:50',NULL),('2025-10-01 17:02:50.960247',NULL,'2025-10-01 17:02:50.990005',335,335,NULL,'e7e0be3c-2d69-4782-a3ad-77f683d16fd8',77,'06efa1ba477e45208d5ba21e3e7c2703','shares',-1,'2025-10-02 17:02:50','354dd354-8b0a-40a4-9641-b0e3560a975d'),('2025-10-01 17:02:50.960966',NULL,'2025-10-01 17:02:50.990005',336,336,NULL,'63f47afe-a8c7-4db5-b9b3-e8157bfb732b',78,'06efa1ba477e45208d5ba21e3e7c2703','gigabytes',-1,'2025-10-02 17:02:50','354dd354-8b0a-40a4-9641-b0e3560a975d'),('2025-10-01 17:02:51.524809',NULL,'2025-10-01 17:02:51.611378',337,337,'9067353b927842dbadd16dcb12f93b3d','e8cebef8-4dec-42c6-a0ab-f0c9800c706a',107,'a307fd4b882d45898ca085500fbf65b4','shares',1,'2025-10-02 17:02:51',NULL),('2025-10-01 17:02:51.525934',NULL,'2025-10-01 17:02:51.611378',338,338,'9067353b927842dbadd16dcb12f93b3d','ce32d6ae-d47f-44ff-8c3a-4a8e6bf70520',108,'a307fd4b882d45898ca085500fbf65b4','gigabytes',4,'2025-10-02 17:02:51',NULL),('2025-10-01 17:02:51.560186',NULL,'2025-10-01 17:02:51.611378',339,339,NULL,'93ba9ff1-890d-43db-a87c-4e671e02c9b1',109,'a307fd4b882d45898ca085500fbf65b4','shares',1,'2025-10-02 17:02:51','f75be615-3c48-49cc-844c-502b209bf197'),('2025-10-01 17:02:51.562803',NULL,'2025-10-01 17:02:51.611378',340,340,NULL,'a8a11cae-76b7-442a-b11a-092134deabe2',110,'a307fd4b882d45898ca085500fbf65b4','gigabytes',4,'2025-10-02 17:02:51','f75be615-3c48-49cc-844c-502b209bf197'),('2025-10-01 17:02:55.220737',NULL,'2025-10-01 17:02:55.754458',341,341,'9067353b927842dbadd16dcb12f93b3d','47c45bcb-959b-4fc2-8730-5e190230a9ab',107,'a307fd4b882d45898ca085500fbf65b4','shares',1,'2025-10-02 17:02:55',NULL),('2025-10-01 17:02:55.222101',NULL,'2025-10-01 17:02:55.754458',342,342,'9067353b927842dbadd16dcb12f93b3d','3a813229-442f-41bd-b8b1-cd2d4796f4d3',108,'a307fd4b882d45898ca085500fbf65b4','gigabytes',3,'2025-10-02 17:02:55',NULL),('2025-10-01 17:02:56.629135',NULL,'2025-10-01 17:02:56.746372',343,343,'9067353b927842dbadd16dcb12f93b3d','b6be778a-a23d-46db-b5f5-afed3627fb3f',107,'a307fd4b882d45898ca085500fbf65b4','shares',1,'2025-10-02 17:02:56',NULL),('2025-10-01 17:02:56.630475',NULL,'2025-10-01 17:02:56.746372',344,344,'9067353b927842dbadd16dcb12f93b3d','32fa9da0-b577-43a4-8016-9ae4475b5556',108,'a307fd4b882d45898ca085500fbf65b4','gigabytes',3,'2025-10-02 17:02:56',NULL),('2025-10-01 17:02:56.675927',NULL,'2025-10-01 17:02:56.746372',345,345,NULL,'302194d4-4578-4332-97d0-75ae3dca8153',112,'a307fd4b882d45898ca085500fbf65b4','shares',1,'2025-10-02 17:02:56','2324d49d-b8b2-4a6a-82f9-af40a075e8cc'),('2025-10-01 17:02:56.677276',NULL,'2025-10-01 17:02:56.746372',346,346,NULL,'9ed762f6-3b47-4ee8-934a-4f6e68818fcc',111,'a307fd4b882d45898ca085500fbf65b4','gigabytes',3,'2025-10-02 17:02:56','2324d49d-b8b2-4a6a-82f9-af40a075e8cc'),('2025-10-01 17:03:00.980969',NULL,'2025-10-01 17:03:01.183943',347,347,'9067353b927842dbadd16dcb12f93b3d','12237d18-0c96-442d-b060-1212ee6221b4',107,'a307fd4b882d45898ca085500fbf65b4','shares',-1,'2025-10-02 17:03:00',NULL),('2025-10-01 17:03:00.983558',NULL,'2025-10-01 17:03:01.183943',348,348,'9067353b927842dbadd16dcb12f93b3d','ce642849-ce9e-4947-8c84-522bd6664b2d',108,'a307fd4b882d45898ca085500fbf65b4','gigabytes',-4,'2025-10-02 17:03:00',NULL),('2025-10-01 17:03:01.151829',NULL,'2025-10-01 17:03:01.183943',349,349,NULL,'ba72148e-8e72-462c-ba3f-6b0f6f10292d',109,'a307fd4b882d45898ca085500fbf65b4','shares',-1,'2025-10-02 17:03:00','f75be615-3c48-49cc-844c-502b209bf197'),('2025-10-01 17:03:01.154663',NULL,'2025-10-01 17:03:01.183943',350,350,NULL,'2f29a242-9a57-40f3-b2b2-c91cc4ee5cf8',110,'a307fd4b882d45898ca085500fbf65b4','gigabytes',-4,'2025-10-02 17:03:00','f75be615-3c48-49cc-844c-502b209bf197'),('2025-10-01 17:03:04.444424',NULL,'2025-10-01 17:03:04.471949',351,351,'9067353b927842dbadd16dcb12f93b3d','56cefa78-1c4f-419a-b0bf-2c3aff9fb8ec',107,'a307fd4b882d45898ca085500fbf65b4','shares',-1,'2025-10-02 17:03:04',NULL),('2025-10-01 17:03:04.445228',NULL,'2025-10-01 17:03:04.471949',352,352,'9067353b927842dbadd16dcb12f93b3d','3e541c17-23c7-46ff-a202-63d1478be937',108,'a307fd4b882d45898ca085500fbf65b4','gigabytes',-3,'2025-10-02 17:03:04',NULL),('2025-10-01 17:03:04.451239',NULL,'2025-10-01 17:03:04.471949',353,353,NULL,'a09d2f50-742b-4ede-ab71-57a4a2c2afab',112,'a307fd4b882d45898ca085500fbf65b4','shares',-1,'2025-10-02 17:03:04','2324d49d-b8b2-4a6a-82f9-af40a075e8cc'),('2025-10-01 17:03:04.452040',NULL,'2025-10-01 17:03:04.471949',354,354,NULL,'033848ff-4a2c-4a6a-ba5e-4a36353c5fa5',111,'a307fd4b882d45898ca085500fbf65b4','gigabytes',-3,'2025-10-02 17:03:04','2324d49d-b8b2-4a6a-82f9-af40a075e8cc'),('2025-10-01 17:03:08.428998',NULL,'2025-10-01 17:03:08.476924',355,355,'0e5069509e1b4a3fba307dac6547b514','0a6913c7-cddf-409c-a555-9efb1df58f78',114,'a0ac8ec815504b8dae62c40a55008f52','shares',1,'2025-10-02 17:03:08',NULL),('2025-10-01 17:03:08.432312',NULL,'2025-10-01 17:03:08.476924',356,356,'0e5069509e1b4a3fba307dac6547b514','3c78c8a0-3b0d-45c7-ad53-18ac981e1309',113,'a0ac8ec815504b8dae62c40a55008f52','gigabytes',1,'2025-10-02 17:03:08',NULL),('2025-10-01 17:03:08.452097',NULL,'2025-10-01 17:03:08.476924',357,357,NULL,'f23f0325-2510-4894-a009-2c2fbfbf2b94',116,'a0ac8ec815504b8dae62c40a55008f52','shares',1,'2025-10-02 17:03:08','3c11362f-fb50-4637-8fe6-18550ac367e4'),('2025-10-01 17:03:08.453483',NULL,'2025-10-01 17:03:08.476924',358,358,NULL,'e38fd179-c13a-4d33-81f3-26caacc4dbc2',115,'a0ac8ec815504b8dae62c40a55008f52','gigabytes',1,'2025-10-02 17:03:08','3c11362f-fb50-4637-8fe6-18550ac367e4'),('2025-10-01 17:03:12.651449',NULL,'2025-10-01 17:03:12.684512',359,359,'0e5069509e1b4a3fba307dac6547b514','6ec66fdf-6ff8-4251-b9d9-5d8389011ab8',114,'a0ac8ec815504b8dae62c40a55008f52','shares',1,'2025-10-02 17:03:12',NULL),('2025-10-01 17:03:12.652733',NULL,'2025-10-01 17:03:12.684512',360,360,'0e5069509e1b4a3fba307dac6547b514','3af20805-ff74-422f-a7b2-c76b820efdea',113,'a0ac8ec815504b8dae62c40a55008f52','gigabytes',1,'2025-10-02 17:03:12',NULL),('2025-10-01 17:03:12.657983',NULL,'2025-10-01 17:03:12.684512',361,361,NULL,'f1116057-6f7d-4f01-a5ff-c4206f40ee53',116,'a0ac8ec815504b8dae62c40a55008f52','shares',1,'2025-10-02 17:03:12','3c11362f-fb50-4637-8fe6-18550ac367e4'),('2025-10-01 17:03:12.659086',NULL,'2025-10-01 17:03:12.684512',362,362,NULL,'376ada50-bf29-4606-a880-6b37b3e66ff5',115,'a0ac8ec815504b8dae62c40a55008f52','gigabytes',1,'2025-10-02 17:03:12','3c11362f-fb50-4637-8fe6-18550ac367e4'),('2025-10-01 17:03:20.496188',NULL,'2025-10-01 17:03:20.508501',363,363,'0e5069509e1b4a3fba307dac6547b514','64fa5f19-d6d1-4e84-922b-650ba70e80f3',114,'a0ac8ec815504b8dae62c40a55008f52','shares',-1,'2025-10-02 17:03:20',NULL),('2025-10-01 17:03:20.496859',NULL,'2025-10-01 17:03:20.508501',364,364,'0e5069509e1b4a3fba307dac6547b514','f2c380c4-d79c-4441-a278-bb10fb12febb',113,'a0ac8ec815504b8dae62c40a55008f52','gigabytes',-1,'2025-10-02 17:03:20',NULL),('2025-10-01 17:03:20.501460',NULL,'2025-10-01 17:03:20.508501',365,365,NULL,'fa2f30c4-d3fc-4d6e-8e3a-fb119b774c0d',116,'a0ac8ec815504b8dae62c40a55008f52','shares',-1,'2025-10-02 17:03:20','3c11362f-fb50-4637-8fe6-18550ac367e4'),('2025-10-01 17:03:20.502170',NULL,'2025-10-01 17:03:20.508501',366,366,NULL,'3c6f0e2a-37d5-4a81-a496-99f3882f7d5f',115,'a0ac8ec815504b8dae62c40a55008f52','gigabytes',-1,'2025-10-02 17:03:20','3c11362f-fb50-4637-8fe6-18550ac367e4'),('2025-10-01 17:03:23.189606',NULL,'2025-10-01 17:03:23.248570',367,367,'0e5069509e1b4a3fba307dac6547b514','1c21eb29-0cb7-4c91-882c-0c189cdd9a23',114,'a0ac8ec815504b8dae62c40a55008f52','shares',1,'2025-10-02 17:03:23',NULL),('2025-10-01 17:03:23.191463',NULL,'2025-10-01 17:03:23.248570',368,368,'0e5069509e1b4a3fba307dac6547b514','681f4e51-677f-41d4-873b-38551f474b6c',113,'a0ac8ec815504b8dae62c40a55008f52','gigabytes',1,'2025-10-02 17:03:23',NULL),('2025-10-01 17:03:23.199579',NULL,'2025-10-01 17:03:23.248570',369,369,NULL,'3fca5ba5-9ea4-43f5-84d5-9ecd0134eb2a',116,'a0ac8ec815504b8dae62c40a55008f52','shares',1,'2025-10-02 17:03:23','3c11362f-fb50-4637-8fe6-18550ac367e4'),('2025-10-01 17:03:23.200868',NULL,'2025-10-01 17:03:23.248570',370,370,NULL,'73cfdbb1-bf2f-4861-b53c-435a7eb9e750',115,'a0ac8ec815504b8dae62c40a55008f52','gigabytes',1,'2025-10-02 17:03:23','3c11362f-fb50-4637-8fe6-18550ac367e4'),('2025-10-01 17:03:32.874121',NULL,'2025-10-01 17:03:33.010363',371,371,'0e5069509e1b4a3fba307dac6547b514','91d2f90e-5d16-431c-9b53-b0f1657487f2',114,'a0ac8ec815504b8dae62c40a55008f52','shares',-1,'2025-10-02 17:03:32',NULL),('2025-10-01 17:03:32.874811',NULL,'2025-10-01 17:03:33.010363',372,372,'0e5069509e1b4a3fba307dac6547b514','f2845186-36ea-4561-9c12-2852f14e088e',113,'a0ac8ec815504b8dae62c40a55008f52','gigabytes',-1,'2025-10-02 17:03:32',NULL),('2025-10-01 17:03:32.932536',NULL,'2025-10-01 17:03:33.010363',373,373,NULL,'badd2b1b-6ccd-46c3-b31d-bba10f460dac',116,'a0ac8ec815504b8dae62c40a55008f52','shares',-1,'2025-10-02 17:03:32','3c11362f-fb50-4637-8fe6-18550ac367e4'),('2025-10-01 17:03:32.933400',NULL,'2025-10-01 17:03:33.010363',374,374,NULL,'35a15fd2-f993-4f05-a1d5-f9241990ea52',115,'a0ac8ec815504b8dae62c40a55008f52','gigabytes',-1,'2025-10-02 17:03:32','3c11362f-fb50-4637-8fe6-18550ac367e4'),('2025-10-01 17:03:34.457081',NULL,'2025-10-01 17:03:34.673330',375,375,'76eea8115d324be1a5ea0e97a79df9d8','6c35922f-6646-4bcc-863b-bdb642d1b898',117,'01bc5d037e3c4524ae56d7d17d262d0d','share_networks',1,'2025-10-02 17:03:34',NULL),('2025-10-01 17:03:35.046526',NULL,'2025-10-01 17:03:35.240251',376,376,'d68a134fb2894956b0088cb7a9513af9','5a58d8c5-b2f8-4800-81a6-3190e9eeee89',118,'9bd13d2e911f47bd8088546be105109c','share_networks',1,'2025-10-02 17:03:35',NULL),('2025-10-01 17:03:35.268890',NULL,'2025-10-01 17:03:35.568362',377,377,'0e5069509e1b4a3fba307dac6547b514','53fd5c13-f8d8-4e71-868e-ac514b512920',114,'a0ac8ec815504b8dae62c40a55008f52','shares',1,'2025-10-02 17:03:35',NULL),('2025-10-01 17:03:35.271963',NULL,'2025-10-01 17:03:35.568362',378,378,'0e5069509e1b4a3fba307dac6547b514','18d632fa-1192-444f-9449-328b56d00687',113,'a0ac8ec815504b8dae62c40a55008f52','gigabytes',1,'2025-10-02 17:03:35',NULL),('2025-10-01 17:03:35.289082',NULL,'2025-10-01 17:03:35.568362',379,379,NULL,'44e79fb5-1397-493e-8bce-6d4043b6aecb',116,'a0ac8ec815504b8dae62c40a55008f52','shares',1,'2025-10-02 17:03:35','3c11362f-fb50-4637-8fe6-18550ac367e4'),('2025-10-01 17:03:35.290534',NULL,'2025-10-01 17:03:35.568362',380,380,NULL,'fe9843f1-0902-44d2-878e-4e8887227789',115,'a0ac8ec815504b8dae62c40a55008f52','gigabytes',1,'2025-10-02 17:03:35','3c11362f-fb50-4637-8fe6-18550ac367e4'),('2025-10-01 17:03:37.318566',NULL,'2025-10-01 17:03:37.332140',381,381,'76eea8115d324be1a5ea0e97a79df9d8','4b6c946a-10aa-4ee6-ade9-b6bb39d0ada1',117,'01bc5d037e3c4524ae56d7d17d262d0d','share_networks',-1,'2025-10-02 17:03:37',NULL),('2025-10-01 17:03:43.841539',NULL,'2025-10-01 17:03:43.878851',382,382,'0e5069509e1b4a3fba307dac6547b514','13637105-ad4b-4bbe-925b-3503839e29b6',114,'a0ac8ec815504b8dae62c40a55008f52','shares',-1,'2025-10-02 17:03:43',NULL),('2025-10-01 17:03:43.843108',NULL,'2025-10-01 17:03:43.878851',383,383,'0e5069509e1b4a3fba307dac6547b514','1c6b0a25-0089-4030-923e-875343980e46',113,'a0ac8ec815504b8dae62c40a55008f52','gigabytes',-1,'2025-10-02 17:03:43',NULL),('2025-10-01 17:03:43.857354',NULL,'2025-10-01 17:03:43.878851',384,384,NULL,'7ea9453e-6c96-4a8e-a52a-782ba7e7fb52',116,'a0ac8ec815504b8dae62c40a55008f52','shares',-1,'2025-10-02 17:03:43','3c11362f-fb50-4637-8fe6-18550ac367e4'),('2025-10-01 17:03:43.859183',NULL,'2025-10-01 17:03:43.878851',385,385,NULL,'2cfd3e0a-6f3a-410f-96e0-142482c80e60',115,'a0ac8ec815504b8dae62c40a55008f52','gigabytes',-1,'2025-10-02 17:03:43','3c11362f-fb50-4637-8fe6-18550ac367e4'),('2025-10-01 17:03:47.414972',NULL,'2025-10-01 17:03:47.455613',386,386,'c09dbb0e26b54de6b5ba772109c45853','218fe707-a55f-4f28-bb2f-b93f9d48e3cf',119,'ba644d06236b4f928b914648a014fefa','share_networks',1,'2025-10-02 17:03:47',NULL),('2025-10-01 17:03:47.555628',NULL,'2025-10-01 17:03:47.587584',387,387,'c09dbb0e26b54de6b5ba772109c45853','448efb56-3d6d-4338-84d5-5bdb28580cdf',119,'ba644d06236b4f928b914648a014fefa','share_networks',1,'2025-10-02 17:03:47',NULL),('2025-10-01 17:03:48.625716',NULL,'2025-10-01 17:03:48.632446',388,388,'c09dbb0e26b54de6b5ba772109c45853','d5ad7b95-1d5e-43ec-a059-69b5f2e06399',119,'ba644d06236b4f928b914648a014fefa','share_networks',-1,'2025-10-02 17:03:48',NULL),('2025-10-01 17:03:48.794633',NULL,'2025-10-01 17:03:48.857442',389,389,'c09dbb0e26b54de6b5ba772109c45853','280dc682-0153-4a30-87b2-37c771a1be9c',119,'ba644d06236b4f928b914648a014fefa','share_networks',1,'2025-10-02 17:03:48',NULL),('2025-10-01 17:03:49.593870',NULL,'2025-10-01 17:03:49.601927',390,390,'c09dbb0e26b54de6b5ba772109c45853','e52b5154-af6c-443b-96e5-107be2dbb0a0',119,'ba644d06236b4f928b914648a014fefa','share_networks',-1,'2025-10-02 17:03:49',NULL),('2025-10-01 17:03:53.441312',NULL,'2025-10-01 17:03:53.486477',391,391,'b2685616371841959873dec890fa5385','d1cf5d5c-a6ea-4dd0-a998-c7ae91076d11',120,'5473075ec2e4439eadc201afc270390c','shares',1,'2025-10-02 17:03:53',NULL),('2025-10-01 17:03:53.442456',NULL,'2025-10-01 17:03:53.486477',392,392,'b2685616371841959873dec890fa5385','5fa70f83-6bd3-4c4d-b3dc-c65e0badff0c',121,'5473075ec2e4439eadc201afc270390c','gigabytes',1,'2025-10-02 17:03:53',NULL),('2025-10-01 17:03:53.457968',NULL,'2025-10-01 17:03:53.486477',393,393,NULL,'3bd24239-eb14-48a3-a29c-fd86db0abf9f',122,'5473075ec2e4439eadc201afc270390c','shares',1,'2025-10-02 17:03:53','7c91cae8-1d42-4bfe-95c0-52e8e38ffe43'),('2025-10-01 17:03:53.458928',NULL,'2025-10-01 17:03:53.486477',394,394,NULL,'db1367a2-ee47-4bcf-b6a1-740040f39a8b',123,'5473075ec2e4439eadc201afc270390c','gigabytes',1,'2025-10-02 17:03:53','7c91cae8-1d42-4bfe-95c0-52e8e38ffe43'),('2025-10-01 17:03:56.938498',NULL,'2025-10-01 17:03:57.002213',395,395,'b2685616371841959873dec890fa5385','6509da01-bf0c-460b-9b63-e8b2238f2320',124,'5473075ec2e4439eadc201afc270390c','snapshots',1,'2025-10-02 17:03:56',NULL),('2025-10-01 17:03:56.939514',NULL,'2025-10-01 17:03:57.002213',396,396,'b2685616371841959873dec890fa5385','8b665388-0822-4d52-ad34-74d003edadca',125,'5473075ec2e4439eadc201afc270390c','snapshot_gigabytes',1,'2025-10-02 17:03:56',NULL),('2025-10-01 17:03:56.948334',NULL,'2025-10-01 17:03:57.002213',397,397,NULL,'702c6a22-d340-478d-86d7-5ad09b2420b7',126,'5473075ec2e4439eadc201afc270390c','snapshots',1,'2025-10-02 17:03:56','7c91cae8-1d42-4bfe-95c0-52e8e38ffe43'),('2025-10-01 17:03:56.949335',NULL,'2025-10-01 17:03:57.002213',398,398,NULL,'06293164-85e8-4738-8670-5ae5c457de75',127,'5473075ec2e4439eadc201afc270390c','snapshot_gigabytes',1,'2025-10-02 17:03:56','7c91cae8-1d42-4bfe-95c0-52e8e38ffe43'),('2025-10-01 17:03:57.919739',NULL,'2025-10-01 17:03:57.992372',399,399,'b2685616371841959873dec890fa5385','cfdebc5d-c7a1-4cb2-b799-c16e59183b59',124,'5473075ec2e4439eadc201afc270390c','snapshots',1,'2025-10-02 17:03:57',NULL),('2025-10-01 17:03:57.921100',NULL,'2025-10-01 17:03:57.992372',400,400,'b2685616371841959873dec890fa5385','bd46e3d3-3c6d-402f-a2b0-c67d915390e8',125,'5473075ec2e4439eadc201afc270390c','snapshot_gigabytes',1,'2025-10-02 17:03:57',NULL),('2025-10-01 17:03:57.927262',NULL,'2025-10-01 17:03:57.992372',401,401,NULL,'e3b9d8da-d755-4ce7-ab89-dadde204ea05',126,'5473075ec2e4439eadc201afc270390c','snapshots',1,'2025-10-02 17:03:57','7c91cae8-1d42-4bfe-95c0-52e8e38ffe43'),('2025-10-01 17:03:57.928473',NULL,'2025-10-01 17:03:57.992372',402,402,NULL,'1edb4ae0-3d0d-4d7b-881e-10f54c9c6470',127,'5473075ec2e4439eadc201afc270390c','snapshot_gigabytes',1,'2025-10-02 17:03:57','7c91cae8-1d42-4bfe-95c0-52e8e38ffe43'),('2025-10-01 17:03:58.846213',NULL,'2025-10-01 17:03:58.873780',403,403,'ed9c7605c9ba47fa826456bdb7485f23','2e318c9d-decc-497f-8d9e-9cffa33ba2c5',128,'76020c94a59c417e8bed7e7ea0fbb3bf','share_networks',1,'2025-10-02 17:03:58',NULL),('2025-10-01 17:03:59.196218',NULL,'2025-10-01 17:03:59.200677',404,404,'ed9c7605c9ba47fa826456bdb7485f23','9481bb49-d3b2-4fa2-bf35-191b03758e89',128,'76020c94a59c417e8bed7e7ea0fbb3bf','share_networks',-1,'2025-10-02 17:03:59',NULL),('2025-10-01 17:03:59.489895',NULL,'2025-10-01 17:03:59.629492',405,405,'ed9c7605c9ba47fa826456bdb7485f23','94bcc097-4f82-4a99-90d3-8dd6df05c73d',128,'76020c94a59c417e8bed7e7ea0fbb3bf','share_networks',1,'2025-10-02 17:03:59',NULL),('2025-10-01 17:04:00.267632',NULL,'2025-10-01 17:04:00.293036',406,406,'ed9c7605c9ba47fa826456bdb7485f23','0d9514e4-2c06-4a5e-9c43-9a5961346187',128,'76020c94a59c417e8bed7e7ea0fbb3bf','share_networks',-1,'2025-10-02 17:04:00',NULL),('2025-10-01 17:04:00.602332',NULL,'2025-10-01 17:04:00.630439',407,407,'ed9c7605c9ba47fa826456bdb7485f23','6af362af-aaf8-4678-8318-115f10b304e4',128,'76020c94a59c417e8bed7e7ea0fbb3bf','share_networks',1,'2025-10-02 17:04:00',NULL),('2025-10-01 17:04:00.791740',NULL,'2025-10-01 17:04:00.801690',408,408,'ed9c7605c9ba47fa826456bdb7485f23','03f4f62a-e44b-4639-adfa-5d810cdec2f7',128,'76020c94a59c417e8bed7e7ea0fbb3bf','share_networks',-1,'2025-10-02 17:04:00',NULL),('2025-10-01 17:04:02.190708',NULL,'2025-10-01 17:04:02.277338',409,409,'b2685616371841959873dec890fa5385','9889c83e-5603-4526-a4cc-b15b46bc20f4',124,'5473075ec2e4439eadc201afc270390c','snapshots',-1,'2025-10-02 17:04:02',NULL),('2025-10-01 17:04:02.216462',NULL,'2025-10-01 17:04:02.277338',410,410,'b2685616371841959873dec890fa5385','c08ad27a-8ed7-4798-8a1f-07fa774c8792',125,'5473075ec2e4439eadc201afc270390c','snapshot_gigabytes',-1,'2025-10-02 17:04:02',NULL),('2025-10-01 17:04:02.236688',NULL,'2025-10-01 17:04:02.277338',411,411,NULL,'e81c7117-066d-4cb3-b750-993a780520e2',126,'5473075ec2e4439eadc201afc270390c','snapshots',-1,'2025-10-02 17:04:02','7c91cae8-1d42-4bfe-95c0-52e8e38ffe43'),('2025-10-01 17:04:02.238369',NULL,'2025-10-01 17:04:02.277338',412,412,NULL,'bd26cc1b-3b72-4ae4-8995-b7d19d509ef5',127,'5473075ec2e4439eadc201afc270390c','snapshot_gigabytes',-1,'2025-10-02 17:04:02','7c91cae8-1d42-4bfe-95c0-52e8e38ffe43'),('2025-10-01 17:04:05.689866',NULL,'2025-10-01 17:04:05.898573',413,413,'b2685616371841959873dec890fa5385','f7fe5b79-9d5a-4fd5-806f-0a05ab462712',124,'5473075ec2e4439eadc201afc270390c','snapshots',-1,'2025-10-02 17:04:05',NULL),('2025-10-01 17:04:05.691037',NULL,'2025-10-01 17:04:05.898573',414,414,'b2685616371841959873dec890fa5385','b79295a9-04cf-4da1-b0de-fdd120310f82',125,'5473075ec2e4439eadc201afc270390c','snapshot_gigabytes',-1,'2025-10-02 17:04:05',NULL),('2025-10-01 17:04:05.729776',NULL,'2025-10-01 17:04:05.898573',415,415,NULL,'6ebe9dc5-1010-480b-a17e-3c5b781e80bf',126,'5473075ec2e4439eadc201afc270390c','snapshots',-1,'2025-10-02 17:04:05','7c91cae8-1d42-4bfe-95c0-52e8e38ffe43'),('2025-10-01 17:04:05.730888',NULL,'2025-10-01 17:04:05.898573',416,416,NULL,'cbc3523f-a977-450f-803c-729e0abad676',127,'5473075ec2e4439eadc201afc270390c','snapshot_gigabytes',-1,'2025-10-02 17:04:05','7c91cae8-1d42-4bfe-95c0-52e8e38ffe43'),('2025-10-01 17:04:10.377426',NULL,'2025-10-01 17:04:10.402214',417,417,'b2685616371841959873dec890fa5385','914f0b73-358d-47cc-a8a7-efa51cca52f2',120,'5473075ec2e4439eadc201afc270390c','shares',-1,'2025-10-02 17:04:09',NULL),('2025-10-01 17:04:10.378975',NULL,'2025-10-01 17:04:10.402214',418,418,'b2685616371841959873dec890fa5385','2ec61799-ffe5-4fb8-8902-971afa751e58',121,'5473075ec2e4439eadc201afc270390c','gigabytes',-1,'2025-10-02 17:04:09',NULL),('2025-10-01 17:04:10.391986',NULL,'2025-10-01 17:04:10.402214',419,419,NULL,'041d47ce-e753-419a-9855-6d72d776c060',122,'5473075ec2e4439eadc201afc270390c','shares',-1,'2025-10-02 17:04:09','7c91cae8-1d42-4bfe-95c0-52e8e38ffe43'),('2025-10-01 17:04:10.393091',NULL,'2025-10-01 17:04:10.402214',420,420,NULL,'183f0abd-68af-4af3-aab5-453367497888',123,'5473075ec2e4439eadc201afc270390c','gigabytes',-1,'2025-10-02 17:04:09','7c91cae8-1d42-4bfe-95c0-52e8e38ffe43'),('2025-10-01 17:04:11.642425',NULL,'2025-10-01 17:04:11.682111',421,421,'af8da6febaae4dfe9de0fa747a5ef119','49f2848b-48f8-4529-9c0b-36bfd44e4d7e',130,'220545ce6f424d4187770842929567dc','shares',1,'2025-10-02 17:04:11',NULL),('2025-10-01 17:04:11.643659',NULL,'2025-10-01 17:04:11.682111',422,422,'af8da6febaae4dfe9de0fa747a5ef119','41eab696-b5f8-488b-bb48-7b8876608a81',129,'220545ce6f424d4187770842929567dc','gigabytes',1,'2025-10-02 17:04:11',NULL),('2025-10-01 17:04:11.659716',NULL,'2025-10-01 17:04:11.682111',423,423,NULL,'7db26b0f-197c-42d0-a545-5ecc917903a6',132,'220545ce6f424d4187770842929567dc','shares',1,'2025-10-02 17:04:11','b7c65449-bea8-4815-b156-f9df3fa11183'),('2025-10-01 17:04:11.661544',NULL,'2025-10-01 17:04:11.682111',424,424,NULL,'0074f973-197a-4449-8dc3-ebc9ebb126be',131,'220545ce6f424d4187770842929567dc','gigabytes',1,'2025-10-02 17:04:11','b7c65449-bea8-4815-b156-f9df3fa11183'),('2025-10-01 17:04:15.693741',NULL,'2025-10-01 17:04:18.610493',425,425,'215059d06b1f437a84c98c525318fc71','d0a664a2-db53-4f50-9695-395c993ea340',134,'d7270bd14938443caacbacdbd21d7c3b','shares',1,'2025-10-02 17:04:15',NULL),('2025-10-01 17:04:15.694770',NULL,'2025-10-01 17:04:18.610493',426,426,'215059d06b1f437a84c98c525318fc71','a293731a-2d2d-4b42-b418-e0f4239b2872',133,'d7270bd14938443caacbacdbd21d7c3b','gigabytes',1,'2025-10-02 17:04:15',NULL),('2025-10-01 17:04:15.715631',NULL,'2025-10-01 17:04:18.671647',427,427,'215059d06b1f437a84c98c525318fc71','818fec95-efd4-4bc7-b50e-bb5fcf6e847d',136,'220545ce6f424d4187770842929567dc','shares',-1,'2025-10-02 17:04:15',NULL),('2025-10-01 17:04:15.716291',NULL,'2025-10-01 17:04:18.671647',428,428,'215059d06b1f437a84c98c525318fc71','9b7ebe4d-990f-4cf3-aeb1-e70e16848254',135,'220545ce6f424d4187770842929567dc','gigabytes',-1,'2025-10-02 17:04:15',NULL),('2025-10-01 17:04:19.512144',NULL,'2025-10-01 17:04:19.554971',429,429,'215059d06b1f437a84c98c525318fc71','0631ab4c-c3dd-447a-a505-b762e1a6b523',134,'d7270bd14938443caacbacdbd21d7c3b','shares',-1,'2025-10-02 17:04:19',NULL),('2025-10-01 17:04:19.512973',NULL,'2025-10-01 17:04:19.554971',430,430,'215059d06b1f437a84c98c525318fc71','602fe9ea-39f0-40f1-84aa-7239b7cdb711',133,'d7270bd14938443caacbacdbd21d7c3b','gigabytes',-1,'2025-10-02 17:04:19',NULL),('2025-10-01 17:04:19.535316',NULL,'2025-10-01 17:04:19.554971',431,431,NULL,'a541e06d-30fa-4579-9729-540c8e971f3e',138,'d7270bd14938443caacbacdbd21d7c3b','shares',-1,'2025-10-02 17:04:19','b7c65449-bea8-4815-b156-f9df3fa11183'),('2025-10-01 17:04:19.535935',NULL,'2025-10-01 17:04:19.554971',432,432,NULL,'cedee044-9e7c-4522-b74e-4c46d8b28f87',137,'d7270bd14938443caacbacdbd21d7c3b','gigabytes',-1,'2025-10-02 17:04:19','b7c65449-bea8-4815-b156-f9df3fa11183'),('2025-10-01 17:04:22.737603',NULL,'2025-10-01 17:04:23.044095',433,433,'af8da6febaae4dfe9de0fa747a5ef119','ef0011de-8a93-42eb-ac58-e525a68c8c8d',130,'220545ce6f424d4187770842929567dc','shares',1,'2025-10-02 17:04:22',NULL),('2025-10-01 17:04:22.739411',NULL,'2025-10-01 17:04:23.044095',434,434,'af8da6febaae4dfe9de0fa747a5ef119','5cd4e8b1-0871-4625-bbd9-00a05f130232',129,'220545ce6f424d4187770842929567dc','gigabytes',1,'2025-10-02 17:04:22',NULL),('2025-10-01 17:04:22.878985',NULL,'2025-10-01 17:04:23.044095',435,435,NULL,'c22e8884-8bc3-4db6-9a33-aeda15570960',132,'220545ce6f424d4187770842929567dc','shares',1,'2025-10-02 17:04:22','b7c65449-bea8-4815-b156-f9df3fa11183'),('2025-10-01 17:04:22.880199',NULL,'2025-10-01 17:04:23.044095',436,436,NULL,'2ced0c44-5093-4880-aca9-5900b28129ca',131,'220545ce6f424d4187770842929567dc','gigabytes',1,'2025-10-02 17:04:22','b7c65449-bea8-4815-b156-f9df3fa11183'),('2025-10-01 17:04:24.873715',NULL,'2025-10-01 17:04:25.094307',437,437,'0e5069509e1b4a3fba307dac6547b514','fdc4ea1b-2087-4d02-a9ba-99abadf2e5be',114,'a0ac8ec815504b8dae62c40a55008f52','shares',-1,'2025-10-02 17:04:23',NULL),('2025-10-01 17:04:24.876324',NULL,'2025-10-01 17:04:25.094307',438,438,'0e5069509e1b4a3fba307dac6547b514','951209c3-ec15-4bfa-aee4-47c27b3f8a3a',113,'a0ac8ec815504b8dae62c40a55008f52','gigabytes',-1,'2025-10-02 17:04:23',NULL),('2025-10-01 17:04:25.043895',NULL,'2025-10-01 17:04:25.094307',439,439,NULL,'088df1c9-d68e-4137-9b14-cd1689a1d8cb',116,'a0ac8ec815504b8dae62c40a55008f52','shares',-1,'2025-10-02 17:04:23','3c11362f-fb50-4637-8fe6-18550ac367e4'),('2025-10-01 17:04:25.045188',NULL,'2025-10-01 17:04:25.094307',440,440,NULL,'05eff5eb-128a-425e-8d51-870c9fef07dc',115,'a0ac8ec815504b8dae62c40a55008f52','gigabytes',-1,'2025-10-02 17:04:23','3c11362f-fb50-4637-8fe6-18550ac367e4'),('2025-10-01 17:04:35.668626',NULL,'2025-10-01 17:04:36.040551',441,441,'af8da6febaae4dfe9de0fa747a5ef119','6f8c24dc-8b2b-48ef-a7a0-73871cc466b3',130,'220545ce6f424d4187770842929567dc','shares',-1,'2025-10-02 17:04:35',NULL),('2025-10-01 17:04:35.669400',NULL,'2025-10-01 17:04:36.040551',442,442,'af8da6febaae4dfe9de0fa747a5ef119','c6a55f05-e642-4db6-8a18-041730888535',129,'220545ce6f424d4187770842929567dc','gigabytes',-1,'2025-10-02 17:04:35',NULL),('2025-10-01 17:04:35.847880',NULL,'2025-10-01 17:04:36.040551',443,443,NULL,'ee77037a-8b24-42cc-871b-2d41e24c44e8',132,'220545ce6f424d4187770842929567dc','shares',-1,'2025-10-02 17:04:35','b7c65449-bea8-4815-b156-f9df3fa11183'),('2025-10-01 17:04:35.853322',NULL,'2025-10-01 17:04:36.040551',444,444,NULL,'355f50cf-bf5e-4f72-8dd0-92ec43d24abe',131,'220545ce6f424d4187770842929567dc','gigabytes',-1,'2025-10-02 17:04:35','b7c65449-bea8-4815-b156-f9df3fa11183'),('2025-10-01 17:04:43.122931',NULL,'2025-10-01 17:04:43.382864',445,445,'d6dae67f198f483d86a85008b5959866','1c464793-a9d5-411b-8655-b1aca9f3b89e',140,'a1cd9e94225644748568dfbc4af1058a','shares',1,'2025-10-02 17:04:43',NULL),('2025-10-01 17:04:43.123910',NULL,'2025-10-01 17:04:43.382864',446,446,'d6dae67f198f483d86a85008b5959866','aab962d3-0902-40b9-94b1-0776a16f52fc',139,'a1cd9e94225644748568dfbc4af1058a','gigabytes',1,'2025-10-02 17:04:43',NULL),('2025-10-01 17:04:43.147607',NULL,'2025-10-01 17:04:43.382864',447,447,NULL,'0f673ad8-a006-4ee6-a881-4eac4594c52c',142,'a1cd9e94225644748568dfbc4af1058a','shares',1,'2025-10-02 17:04:43','37485c41-bf1c-4f76-96dd-017b9efb3945'),('2025-10-01 17:04:43.148846',NULL,'2025-10-01 17:04:43.382864',448,448,NULL,'d7addbe6-87bf-4ce0-ab1b-420ac58ac52d',141,'a1cd9e94225644748568dfbc4af1058a','gigabytes',1,'2025-10-02 17:04:43','37485c41-bf1c-4f76-96dd-017b9efb3945'),('2025-10-01 17:04:47.196627',NULL,'2025-10-01 17:04:47.273215',449,449,'d6dae67f198f483d86a85008b5959866','b992024f-3f1c-4c55-a81a-050f8eca7fa6',140,'a1cd9e94225644748568dfbc4af1058a','shares',-1,'2025-10-02 17:04:47',NULL),('2025-10-01 17:04:47.197646',NULL,'2025-10-01 17:04:47.273215',450,450,'d6dae67f198f483d86a85008b5959866','5d2ece32-46fd-4f07-a028-b33212b77708',139,'a1cd9e94225644748568dfbc4af1058a','gigabytes',-1,'2025-10-02 17:04:47',NULL),('2025-10-01 17:04:47.215955',NULL,'2025-10-01 17:04:47.273215',451,451,NULL,'d5bffbab-bb15-4eb5-a290-2fbb6b9c6712',142,'a1cd9e94225644748568dfbc4af1058a','shares',-1,'2025-10-02 17:04:47','37485c41-bf1c-4f76-96dd-017b9efb3945'),('2025-10-01 17:04:47.218108',NULL,'2025-10-01 17:04:47.273215',452,452,NULL,'be5145d5-0c43-4240-b087-397408123255',141,'a1cd9e94225644748568dfbc4af1058a','gigabytes',-1,'2025-10-02 17:04:47','37485c41-bf1c-4f76-96dd-017b9efb3945'),('2025-10-01 17:04:47.595676',NULL,'2025-10-01 17:04:47.733357',453,453,'d6dae67f198f483d86a85008b5959866','d950e5fa-51da-46d3-84f7-30004e87178d',140,'a1cd9e94225644748568dfbc4af1058a','shares',1,'2025-10-02 17:04:47',NULL),('2025-10-01 17:04:47.597222',NULL,'2025-10-01 17:04:47.733357',454,454,'d6dae67f198f483d86a85008b5959866','93dea2da-efa8-4f56-a107-241f0a86e8b5',139,'a1cd9e94225644748568dfbc4af1058a','gigabytes',1,'2025-10-02 17:04:47',NULL),('2025-10-01 17:04:47.616724',NULL,'2025-10-01 17:04:47.733357',455,455,NULL,'8bdfe5bb-962a-448b-942d-2d65675b7e26',143,'a1cd9e94225644748568dfbc4af1058a','shares',1,'2025-10-02 17:04:47','f9da0eae-4f7c-4b85-af50-4858ad082260'),('2025-10-01 17:04:47.617862',NULL,'2025-10-01 17:04:47.733357',456,456,NULL,'1107ee82-86db-4902-80b1-766ac6a9afa7',144,'a1cd9e94225644748568dfbc4af1058a','gigabytes',1,'2025-10-02 17:04:47','f9da0eae-4f7c-4b85-af50-4858ad082260'),('2025-10-01 17:04:51.907125',NULL,'2025-10-01 17:04:51.928454',457,457,'d6dae67f198f483d86a85008b5959866','16c96ba0-ec1e-4705-a349-467ef9eed7e5',140,'a1cd9e94225644748568dfbc4af1058a','shares',-1,'2025-10-02 17:04:51',NULL),('2025-10-01 17:04:51.907923',NULL,'2025-10-01 17:04:51.928454',458,458,'d6dae67f198f483d86a85008b5959866','d0c995d3-09b9-41b7-b649-672867b7a591',139,'a1cd9e94225644748568dfbc4af1058a','gigabytes',-1,'2025-10-02 17:04:51',NULL),('2025-10-01 17:04:51.919082',NULL,'2025-10-01 17:04:51.928454',459,459,NULL,'f2c10931-88f2-4053-a623-6dad3c8480c8',143,'a1cd9e94225644748568dfbc4af1058a','shares',-1,'2025-10-02 17:04:51','f9da0eae-4f7c-4b85-af50-4858ad082260'),('2025-10-01 17:04:51.920033',NULL,'2025-10-01 17:04:51.928454',460,460,NULL,'96ccf5ef-95bd-4662-89ac-958f685570f3',144,'a1cd9e94225644748568dfbc4af1058a','gigabytes',-1,'2025-10-02 17:04:51','f9da0eae-4f7c-4b85-af50-4858ad082260'),('2025-10-01 17:04:52.100106',NULL,'2025-10-01 17:04:52.157517',461,461,'bdbab5c8cbd84614a605693d09049109','00559e5a-2dfd-463a-8580-8939d015e0f8',146,'86a0062edb9a4a3293bf2e93012e4f13','shares',1,'2025-10-02 17:04:52',NULL),('2025-10-01 17:04:52.101311',NULL,'2025-10-01 17:04:52.157517',462,462,'bdbab5c8cbd84614a605693d09049109','df04b47d-1d31-483f-af2e-2e2559e3dd6d',145,'86a0062edb9a4a3293bf2e93012e4f13','gigabytes',1,'2025-10-02 17:04:52',NULL),('2025-10-01 17:04:52.119508',NULL,'2025-10-01 17:04:52.157517',463,463,NULL,'abed0b68-b441-4138-8943-2cc08808d2ac',148,'86a0062edb9a4a3293bf2e93012e4f13','shares',1,'2025-10-02 17:04:52','b09f42fb-ab61-4f61-a72d-bb65a506d3d5'),('2025-10-01 17:04:52.120579',NULL,'2025-10-01 17:04:52.157517',464,464,NULL,'547a135b-863b-4e13-8c35-40dc73cd06e7',147,'86a0062edb9a4a3293bf2e93012e4f13','gigabytes',1,'2025-10-02 17:04:52','b09f42fb-ab61-4f61-a72d-bb65a506d3d5'),('2025-10-01 17:04:52.242548',NULL,'2025-10-01 17:04:52.331313',465,465,'d6dae67f198f483d86a85008b5959866','7dc6dead-29c2-4613-92cd-f6ca9c1ef60e',140,'a1cd9e94225644748568dfbc4af1058a','shares',1,'2025-10-02 17:04:52',NULL),('2025-10-01 17:04:52.243948',NULL,'2025-10-01 17:04:52.331313',466,466,'d6dae67f198f483d86a85008b5959866','0cca2fd4-138b-42f8-8666-8b76b33a951d',139,'a1cd9e94225644748568dfbc4af1058a','gigabytes',1,'2025-10-02 17:04:52',NULL),('2025-10-01 17:04:52.277746',NULL,'2025-10-01 17:04:52.331313',467,467,NULL,'1c2fdd61-d768-4115-8533-a9a2b0c3cebb',149,'a1cd9e94225644748568dfbc4af1058a','shares',1,'2025-10-02 17:04:52','7913e282-46b6-4065-b63e-e5013b78d303'),('2025-10-01 17:04:52.281415',NULL,'2025-10-01 17:04:52.331313',468,468,NULL,'b30ca160-3f2d-4de3-8620-94b870b72cb1',150,'a1cd9e94225644748568dfbc4af1058a','gigabytes',1,'2025-10-02 17:04:52','7913e282-46b6-4065-b63e-e5013b78d303'),('2025-10-01 17:04:54.113994',NULL,'2025-10-01 17:04:54.257291',469,469,'d0c0ffc90809482c8626b2e61d341f16','d0b06a79-57ae-4113-91e9-ec4171fa50e5',152,'23b43441437342609cce9f7f9d4d5521','shares',1,'2025-10-02 17:04:54',NULL),('2025-10-01 17:04:54.115184',NULL,'2025-10-01 17:04:54.257291',470,470,'d0c0ffc90809482c8626b2e61d341f16','202d2ee7-99c8-490a-9bad-842f23eb7dc9',151,'23b43441437342609cce9f7f9d4d5521','gigabytes',1,'2025-10-02 17:04:54',NULL),('2025-10-01 17:04:54.167709',NULL,'2025-10-01 17:04:54.257291',471,471,NULL,'49447157-1cac-4014-b142-73c0073b8277',154,'23b43441437342609cce9f7f9d4d5521','shares',1,'2025-10-02 17:04:54','e67af6d6-3813-468e-96d3-f52430ec7993'),('2025-10-01 17:04:54.168749',NULL,'2025-10-01 17:04:54.257291',472,472,NULL,'a395012d-f4b6-4d19-b850-d6655f7b3a43',153,'23b43441437342609cce9f7f9d4d5521','gigabytes',1,'2025-10-02 17:04:54','e67af6d6-3813-468e-96d3-f52430ec7993'),('2025-10-01 17:04:55.756654',NULL,'2025-10-01 17:04:55.947493',473,473,'bdbab5c8cbd84614a605693d09049109','30426bcf-58dc-447d-9dbb-0e2c0bb858c3',146,'86a0062edb9a4a3293bf2e93012e4f13','shares',1,'2025-10-02 17:04:55',NULL),('2025-10-01 17:04:55.757974',NULL,'2025-10-01 17:04:55.947493',474,474,'bdbab5c8cbd84614a605693d09049109','52fcb23d-2188-4982-a993-ff1b41acf21b',145,'86a0062edb9a4a3293bf2e93012e4f13','gigabytes',1,'2025-10-02 17:04:55',NULL),('2025-10-01 17:04:55.901101',NULL,'2025-10-01 17:04:55.947493',475,475,NULL,'27e7f5c0-7ccf-4420-8ace-4406bb7200e6',156,'86a0062edb9a4a3293bf2e93012e4f13','shares',1,'2025-10-02 17:04:55','a8a00136-83b3-4010-b21e-0ef332301b8d'),('2025-10-01 17:04:55.902408',NULL,'2025-10-01 17:04:55.947493',476,476,NULL,'544ca151-a0b4-4f17-ab0f-440e2c4f5509',155,'86a0062edb9a4a3293bf2e93012e4f13','gigabytes',1,'2025-10-02 17:04:55','a8a00136-83b3-4010-b21e-0ef332301b8d'),('2025-10-01 17:04:56.029173',NULL,'2025-10-01 17:04:56.148343',477,477,'d6dae67f198f483d86a85008b5959866','dbbc627b-0590-44d9-934e-3833d96ed243',140,'a1cd9e94225644748568dfbc4af1058a','shares',1,'2025-10-02 17:04:56',NULL),('2025-10-01 17:04:56.030545',NULL,'2025-10-01 17:04:56.148343',478,478,'d6dae67f198f483d86a85008b5959866','9222fc52-3154-4a76-b691-86ddc40c4e81',139,'a1cd9e94225644748568dfbc4af1058a','gigabytes',1,'2025-10-02 17:04:56',NULL),('2025-10-01 17:04:56.094370',NULL,'2025-10-01 17:04:56.148343',479,479,NULL,'9535f72c-9716-498a-93c2-06b90fef56e8',158,'a1cd9e94225644748568dfbc4af1058a','shares',1,'2025-10-02 17:04:56','f6d05e71-de10-42a2-8555-e5899975f59e'),('2025-10-01 17:04:56.095472',NULL,'2025-10-01 17:04:56.148343',480,480,NULL,'48d201bd-1d3e-4386-9922-b23e81f28029',157,'a1cd9e94225644748568dfbc4af1058a','gigabytes',1,'2025-10-02 17:04:56','f6d05e71-de10-42a2-8555-e5899975f59e'),('2025-10-01 17:04:58.428318',NULL,'2025-10-01 17:04:58.529612',481,481,'d0c0ffc90809482c8626b2e61d341f16','cc278561-b659-45a1-aba4-e13119a7b86d',152,'23b43441437342609cce9f7f9d4d5521','shares',1,'2025-10-02 17:04:58',NULL),('2025-10-01 17:04:58.430086',NULL,'2025-10-01 17:04:58.529612',482,482,'d0c0ffc90809482c8626b2e61d341f16','7c392e2d-d7a0-4769-984f-e953128d8a5f',151,'23b43441437342609cce9f7f9d4d5521','gigabytes',1,'2025-10-02 17:04:58',NULL),('2025-10-01 17:04:58.443626',NULL,'2025-10-01 17:04:58.529612',483,483,NULL,'fa23f204-e969-4e2a-99b2-2658988f094b',154,'23b43441437342609cce9f7f9d4d5521','shares',1,'2025-10-02 17:04:58','e67af6d6-3813-468e-96d3-f52430ec7993'),('2025-10-01 17:04:58.444787',NULL,'2025-10-01 17:04:58.529612',484,484,NULL,'5a35469b-904e-48df-bb72-4eb3c979c93e',153,'23b43441437342609cce9f7f9d4d5521','gigabytes',1,'2025-10-02 17:04:58','e67af6d6-3813-468e-96d3-f52430ec7993'),('2025-10-01 17:04:59.696160',NULL,'2025-10-01 17:04:59.767732',485,485,'d6dae67f198f483d86a85008b5959866','e25b4a11-d3a7-4bc7-af71-b6ce308a4925',140,'a1cd9e94225644748568dfbc4af1058a','shares',-1,'2025-10-02 17:04:59',NULL),('2025-10-01 17:04:59.696831',NULL,'2025-10-01 17:04:59.767732',486,486,'d6dae67f198f483d86a85008b5959866','28c1e0bf-eb89-497b-a426-a980a03b0568',139,'a1cd9e94225644748568dfbc4af1058a','gigabytes',-1,'2025-10-02 17:04:59',NULL),('2025-10-01 17:04:59.730213',NULL,'2025-10-01 17:04:59.767732',487,487,NULL,'53bf9cba-4321-4fc9-8694-cc25fd08411e',158,'a1cd9e94225644748568dfbc4af1058a','shares',-1,'2025-10-02 17:04:59','f6d05e71-de10-42a2-8555-e5899975f59e'),('2025-10-01 17:04:59.731017',NULL,'2025-10-01 17:04:59.767732',488,488,NULL,'6b2e44d2-314b-435e-b546-d4033ffd80e7',157,'a1cd9e94225644748568dfbc4af1058a','gigabytes',-1,'2025-10-02 17:04:59','f6d05e71-de10-42a2-8555-e5899975f59e'),('2025-10-01 17:05:00.026534',NULL,'2025-10-01 17:05:00.112791',489,489,'d6dae67f198f483d86a85008b5959866','ce5717f6-3367-46f6-b6b2-b20e9ea1b17d',140,'a1cd9e94225644748568dfbc4af1058a','shares',-1,'2025-10-02 17:04:59',NULL),('2025-10-01 17:05:00.027236',NULL,'2025-10-01 17:05:00.112791',490,490,'d6dae67f198f483d86a85008b5959866','f2a529e7-7617-421f-8071-5af7fcaed2f3',139,'a1cd9e94225644748568dfbc4af1058a','gigabytes',-1,'2025-10-02 17:04:59',NULL),('2025-10-01 17:05:00.080275',NULL,'2025-10-01 17:05:00.112791',491,491,NULL,'edb0a18f-00d7-420f-a9fb-30fe86f3e4a1',149,'a1cd9e94225644748568dfbc4af1058a','shares',-1,'2025-10-02 17:04:59','7913e282-46b6-4065-b63e-e5013b78d303'),('2025-10-01 17:05:00.081115',NULL,'2025-10-01 17:05:00.112791',492,492,NULL,'3313f9a1-a4fd-40dd-b572-89d9b1f96630',150,'a1cd9e94225644748568dfbc4af1058a','gigabytes',-1,'2025-10-02 17:04:59','7913e282-46b6-4065-b63e-e5013b78d303'),('2025-10-01 17:05:00.366293',NULL,'2025-10-01 17:05:00.568957',493,493,'d6dae67f198f483d86a85008b5959866','3d7433ac-7bab-4f7c-a8ef-6662c7da2131',140,'a1cd9e94225644748568dfbc4af1058a','shares',1,'2025-10-02 17:05:00',NULL),('2025-10-01 17:05:00.367465',NULL,'2025-10-01 17:05:00.568957',494,494,'d6dae67f198f483d86a85008b5959866','3c8f3787-db0c-4cd0-8f2d-0df0178843c1',139,'a1cd9e94225644748568dfbc4af1058a','gigabytes',1,'2025-10-02 17:05:00',NULL),('2025-10-01 17:05:00.393989',NULL,'2025-10-01 17:05:00.568957',495,495,NULL,'78ba7c79-151d-430f-bf1b-de2608d3f167',160,'a1cd9e94225644748568dfbc4af1058a','shares',1,'2025-10-02 17:05:00','039a05c1-a5d1-442b-b2f7-1c7883683b48'),('2025-10-01 17:05:00.395167',NULL,'2025-10-01 17:05:00.568957',496,496,NULL,'3af9b5c7-8f99-42da-9e59-7545fba34714',159,'a1cd9e94225644748568dfbc4af1058a','gigabytes',1,'2025-10-02 17:05:00','039a05c1-a5d1-442b-b2f7-1c7883683b48'),('2025-10-01 17:05:02.616675',NULL,'2025-10-01 17:05:02.760868',497,497,'d0c0ffc90809482c8626b2e61d341f16','56b8acfd-9509-459a-929c-35ffc8930d36',152,'23b43441437342609cce9f7f9d4d5521','shares',1,'2025-10-02 17:05:02',NULL),('2025-10-01 17:05:02.617842',NULL,'2025-10-01 17:05:02.760868',498,498,'d0c0ffc90809482c8626b2e61d341f16','7831177b-f061-4b42-9f86-0cd45332994d',151,'23b43441437342609cce9f7f9d4d5521','gigabytes',1,'2025-10-02 17:05:02',NULL),('2025-10-01 17:05:02.645366',NULL,'2025-10-01 17:05:02.760868',499,499,NULL,'b5405b17-a361-4805-a3e1-67f4c692b27b',154,'23b43441437342609cce9f7f9d4d5521','shares',1,'2025-10-02 17:05:02','e67af6d6-3813-468e-96d3-f52430ec7993'),('2025-10-01 17:05:02.646486',NULL,'2025-10-01 17:05:02.760868',500,500,NULL,'8ddaa7d9-c4f5-467b-9bad-66285046971b',153,'23b43441437342609cce9f7f9d4d5521','gigabytes',1,'2025-10-02 17:05:02','e67af6d6-3813-468e-96d3-f52430ec7993'),('2025-10-01 17:05:02.982152',NULL,'2025-10-01 17:05:03.193192',501,501,'5acd4d62fc8e4eeabaae2462d3c7a8fa','a2ea5848-7d48-416c-9946-92b426eba4a9',162,'fb3120e923574f759bb16e2e2d603473','shares',1,'2025-10-02 17:05:02',NULL),('2025-10-01 17:05:02.983327',NULL,'2025-10-01 17:05:03.193192',502,502,'5acd4d62fc8e4eeabaae2462d3c7a8fa','b05edd7a-f391-4a9c-9ade-677ba422f92b',161,'fb3120e923574f759bb16e2e2d603473','gigabytes',1,'2025-10-02 17:05:02',NULL),('2025-10-01 17:05:03.039334',NULL,'2025-10-01 17:05:03.193192',503,503,NULL,'d62ca5a1-4dca-429a-83c4-e5755bf1e8b0',164,'fb3120e923574f759bb16e2e2d603473','shares',1,'2025-10-02 17:05:02','a8a00136-83b3-4010-b21e-0ef332301b8d'),('2025-10-01 17:05:03.040445',NULL,'2025-10-01 17:05:03.193192',504,504,NULL,'975b9426-db10-4673-ba5d-94e36449374c',163,'fb3120e923574f759bb16e2e2d603473','gigabytes',1,'2025-10-02 17:05:02','a8a00136-83b3-4010-b21e-0ef332301b8d'),('2025-10-01 17:05:05.193289',NULL,'2025-10-01 17:05:05.465377',505,505,'d6dae67f198f483d86a85008b5959866','f80c7441-20b2-4b4a-801e-a1d01c3b35a6',140,'a1cd9e94225644748568dfbc4af1058a','shares',1,'2025-10-02 17:05:05',NULL),('2025-10-01 17:05:05.203288',NULL,'2025-10-01 17:05:05.465377',506,506,'d6dae67f198f483d86a85008b5959866','d9229f9f-8905-4897-85e9-145368e720d3',139,'a1cd9e94225644748568dfbc4af1058a','gigabytes',1,'2025-10-02 17:05:05',NULL),('2025-10-01 17:05:05.347313',NULL,'2025-10-01 17:05:05.465377',507,507,NULL,'7bb9456f-f20c-4ca1-a841-ff9b38d7b096',165,'a1cd9e94225644748568dfbc4af1058a','shares',1,'2025-10-02 17:05:05','ff31a3ee-a999-42cd-b0e7-6b0804664d3d'),('2025-10-01 17:05:05.349013',NULL,'2025-10-01 17:05:05.465377',508,508,NULL,'ae49116c-5713-4ed9-a7c8-b59411b0c49d',166,'a1cd9e94225644748568dfbc4af1058a','gigabytes',1,'2025-10-02 17:05:05','ff31a3ee-a999-42cd-b0e7-6b0804664d3d'),('2025-10-01 17:05:09.294580',NULL,'2025-10-01 17:05:09.345998',509,509,'d6dae67f198f483d86a85008b5959866','64bf7b0d-cfbd-4a23-bf11-6bb5a759b34c',140,'a1cd9e94225644748568dfbc4af1058a','shares',1,'2025-10-02 17:05:09',NULL),('2025-10-01 17:05:09.295885',NULL,'2025-10-01 17:05:09.345998',510,510,'d6dae67f198f483d86a85008b5959866','67b9234c-9eda-4265-8a44-887e6430cc37',139,'a1cd9e94225644748568dfbc4af1058a','gigabytes',1,'2025-10-02 17:05:09',NULL),('2025-10-01 17:05:09.317370',NULL,'2025-10-01 17:05:09.345998',511,511,NULL,'602c5a47-c776-405b-9c5d-f8eb1c943391',168,'a1cd9e94225644748568dfbc4af1058a','shares',1,'2025-10-02 17:05:09','00ca740c-3b33-4184-8684-9c836e09c2c9'),('2025-10-01 17:05:09.318424',NULL,'2025-10-01 17:05:09.345998',512,512,NULL,'715d240e-0af5-447f-98b0-b1de51332c7d',167,'a1cd9e94225644748568dfbc4af1058a','gigabytes',1,'2025-10-02 17:05:09','00ca740c-3b33-4184-8684-9c836e09c2c9'),('2025-10-01 17:05:10.065266',NULL,'2025-10-01 17:05:10.109161',513,513,'d0c0ffc90809482c8626b2e61d341f16','7b0de1ea-1e9f-4b81-b76e-2431eb117818',152,'23b43441437342609cce9f7f9d4d5521','shares',1,'2025-10-02 17:05:10',NULL),('2025-10-01 17:05:10.067139',NULL,'2025-10-01 17:05:10.109161',514,514,'d0c0ffc90809482c8626b2e61d341f16','44dd6ed5-4597-47eb-b047-9352993d566a',151,'23b43441437342609cce9f7f9d4d5521','gigabytes',1,'2025-10-02 17:05:10',NULL),('2025-10-01 17:05:10.079237',NULL,'2025-10-01 17:05:10.109161',515,515,NULL,'bfe6c9cd-bad7-4a4d-b7de-5dde9c3afce5',154,'23b43441437342609cce9f7f9d4d5521','shares',1,'2025-10-02 17:05:10','e67af6d6-3813-468e-96d3-f52430ec7993'),('2025-10-01 17:05:10.082160',NULL,'2025-10-01 17:05:10.109161',516,516,NULL,'c6af0971-a8c8-47b8-8720-211a4c41e0b0',153,'23b43441437342609cce9f7f9d4d5521','gigabytes',1,'2025-10-02 17:05:10','e67af6d6-3813-468e-96d3-f52430ec7993'),('2025-10-01 17:05:12.929106',NULL,'2025-10-01 17:05:13.055578',517,517,'d6dae67f198f483d86a85008b5959866','e116f60d-46bc-4530-86d1-8eeea3b466d5',140,'a1cd9e94225644748568dfbc4af1058a','shares',-1,'2025-10-02 17:05:12',NULL),('2025-10-01 17:05:12.929866',NULL,'2025-10-01 17:05:13.055578',518,518,'d6dae67f198f483d86a85008b5959866','adeee87f-1183-4daa-a2c9-280154a68e9e',139,'a1cd9e94225644748568dfbc4af1058a','gigabytes',-1,'2025-10-02 17:05:12',NULL),('2025-10-01 17:05:13.018489',NULL,'2025-10-01 17:05:13.055578',519,519,NULL,'a6a0553b-67c8-4921-bc79-e7de4837b888',168,'a1cd9e94225644748568dfbc4af1058a','shares',-1,'2025-10-02 17:05:12','00ca740c-3b33-4184-8684-9c836e09c2c9'),('2025-10-01 17:05:13.019331',NULL,'2025-10-01 17:05:13.055578',520,520,NULL,'bf1d05af-6b71-4f22-918c-2a1b13badfdc',167,'a1cd9e94225644748568dfbc4af1058a','gigabytes',-1,'2025-10-02 17:05:12','00ca740c-3b33-4184-8684-9c836e09c2c9'),('2025-10-01 17:05:13.279922',NULL,'2025-10-01 17:05:13.294453',521,521,'d6dae67f198f483d86a85008b5959866','94d92242-fd78-4b43-96df-29d666779a2c',140,'a1cd9e94225644748568dfbc4af1058a','shares',-1,'2025-10-02 17:05:13',NULL),('2025-10-01 17:05:13.280663',NULL,'2025-10-01 17:05:13.294453',522,522,'d6dae67f198f483d86a85008b5959866','57a8c8ca-75c7-46b1-9f13-5392cf2e672d',139,'a1cd9e94225644748568dfbc4af1058a','gigabytes',-1,'2025-10-02 17:05:13',NULL),('2025-10-01 17:05:13.286303',NULL,'2025-10-01 17:05:13.294453',523,523,NULL,'05b02197-a774-487a-9f66-7feb16b580e8',165,'a1cd9e94225644748568dfbc4af1058a','shares',-1,'2025-10-02 17:05:13','ff31a3ee-a999-42cd-b0e7-6b0804664d3d'),('2025-10-01 17:05:13.287101',NULL,'2025-10-01 17:05:13.294453',524,524,NULL,'7687feab-f445-4d31-bfeb-c2e5f9080e63',166,'a1cd9e94225644748568dfbc4af1058a','gigabytes',-1,'2025-10-02 17:05:13','ff31a3ee-a999-42cd-b0e7-6b0804664d3d'),('2025-10-01 17:05:13.557121',NULL,'2025-10-01 17:05:13.620716',525,525,'d6dae67f198f483d86a85008b5959866','a7f35211-a0f5-42a2-839f-38b356edd48f',140,'a1cd9e94225644748568dfbc4af1058a','shares',-1,'2025-10-02 17:05:13',NULL),('2025-10-01 17:05:13.558024',NULL,'2025-10-01 17:05:13.620716',526,526,'d6dae67f198f483d86a85008b5959866','0300f050-cfeb-4400-a996-dfac1a1672b4',139,'a1cd9e94225644748568dfbc4af1058a','gigabytes',-1,'2025-10-02 17:05:13',NULL),('2025-10-01 17:05:13.603966',NULL,'2025-10-01 17:05:13.620716',527,527,NULL,'65ae34ab-6360-4990-9e1c-ce5ae696010b',160,'a1cd9e94225644748568dfbc4af1058a','shares',-1,'2025-10-02 17:05:13','039a05c1-a5d1-442b-b2f7-1c7883683b48'),('2025-10-01 17:05:13.604888',NULL,'2025-10-01 17:05:13.620716',528,528,NULL,'e7137533-68f8-45ba-914e-51a55306bb1f',159,'a1cd9e94225644748568dfbc4af1058a','gigabytes',-1,'2025-10-02 17:05:13','039a05c1-a5d1-442b-b2f7-1c7883683b48'),('2025-10-01 17:05:13.839458',NULL,'2025-10-01 17:05:13.902365',529,529,'d6dae67f198f483d86a85008b5959866','2411d66e-fe83-49f2-8f6a-50d6c290b41a',140,'a1cd9e94225644748568dfbc4af1058a','shares',1,'2025-10-02 17:05:13',NULL),('2025-10-01 17:05:13.840769',NULL,'2025-10-01 17:05:13.902365',530,530,'d6dae67f198f483d86a85008b5959866','9d046f23-6719-489e-bb37-ed3088c80290',139,'a1cd9e94225644748568dfbc4af1058a','gigabytes',1,'2025-10-02 17:05:13',NULL),('2025-10-01 17:05:13.851100',NULL,'2025-10-01 17:05:13.902365',531,531,NULL,'bbc977b9-79db-479f-a855-dca1fb90cf6a',169,'a1cd9e94225644748568dfbc4af1058a','shares',1,'2025-10-02 17:05:13','bf0700f6-e269-4e6e-8ad2-2c76437dcb49'),('2025-10-01 17:05:13.852350',NULL,'2025-10-01 17:05:13.902365',532,532,NULL,'981d826d-243f-4bb5-8fe2-00d3315345a2',170,'a1cd9e94225644748568dfbc4af1058a','gigabytes',1,'2025-10-02 17:05:13','bf0700f6-e269-4e6e-8ad2-2c76437dcb49'),('2025-10-01 17:05:17.335954',NULL,'2025-10-01 17:05:17.396729',533,533,'d6dae67f198f483d86a85008b5959866','a4a697ba-8aff-4cec-a0fe-7d0f48cfd246',140,'a1cd9e94225644748568dfbc4af1058a','shares',1,'2025-10-02 17:05:17',NULL),('2025-10-01 17:05:17.337231',NULL,'2025-10-01 17:05:17.396729',534,534,'d6dae67f198f483d86a85008b5959866','46f51895-192a-4877-9344-c93b29a4bc01',139,'a1cd9e94225644748568dfbc4af1058a','gigabytes',1,'2025-10-02 17:05:17',NULL),('2025-10-01 17:05:17.355410',NULL,'2025-10-01 17:05:17.396729',535,535,NULL,'7a46a0a6-2121-4d20-88d6-293991d4523e',172,'a1cd9e94225644748568dfbc4af1058a','shares',1,'2025-10-02 17:05:17','5c4f6639-cfc2-4866-9875-6cc9e6501c89'),('2025-10-01 17:05:17.356869',NULL,'2025-10-01 17:05:17.396729',536,536,NULL,'9bf59293-34c7-4a4c-b621-abc284aa6745',171,'a1cd9e94225644748568dfbc4af1058a','gigabytes',1,'2025-10-02 17:05:17','5c4f6639-cfc2-4866-9875-6cc9e6501c89'),('2025-10-01 17:05:18.281806',NULL,'2025-10-01 17:05:18.411354',537,537,'d0c0ffc90809482c8626b2e61d341f16','8e6f504e-98d5-4d13-b37c-ec67f84f5809',152,'23b43441437342609cce9f7f9d4d5521','shares',-1,'2025-10-02 17:05:18',NULL),('2025-10-01 17:05:18.282667',NULL,'2025-10-01 17:05:18.411354',538,538,'d0c0ffc90809482c8626b2e61d341f16','5d0ed94e-6fdd-400a-8e53-28f090143011',151,'23b43441437342609cce9f7f9d4d5521','gigabytes',-1,'2025-10-02 17:05:18',NULL),('2025-10-01 17:05:18.329464',NULL,'2025-10-01 17:05:18.411354',539,539,NULL,'112ce7a3-66b4-4d53-9986-5f9e5c6940ee',154,'23b43441437342609cce9f7f9d4d5521','shares',-1,'2025-10-02 17:05:18','e67af6d6-3813-468e-96d3-f52430ec7993'),('2025-10-01 17:05:18.330217',NULL,'2025-10-01 17:05:18.411354',540,540,NULL,'ed91428d-7696-4016-83a1-fc978f254e83',153,'23b43441437342609cce9f7f9d4d5521','gigabytes',-1,'2025-10-02 17:05:18','e67af6d6-3813-468e-96d3-f52430ec7993'),('2025-10-01 17:05:21.280326',NULL,'2025-10-01 17:05:21.328766',541,541,'d6dae67f198f483d86a85008b5959866','0ddbd716-3927-40ee-90f5-7a4dc44fc88a',140,'a1cd9e94225644748568dfbc4af1058a','shares',-1,'2025-10-02 17:05:21',NULL),('2025-10-01 17:05:21.280981',NULL,'2025-10-01 17:05:21.328766',542,542,'d6dae67f198f483d86a85008b5959866','c566714a-c084-447d-8d16-d5a4331fa446',139,'a1cd9e94225644748568dfbc4af1058a','gigabytes',-1,'2025-10-02 17:05:21',NULL),('2025-10-01 17:05:21.304119',NULL,'2025-10-01 17:05:21.328766',543,543,NULL,'11b69cb6-0e2f-432b-a35a-fbd2d8ecbd68',172,'a1cd9e94225644748568dfbc4af1058a','shares',-1,'2025-10-02 17:05:21','5c4f6639-cfc2-4866-9875-6cc9e6501c89'),('2025-10-01 17:05:21.305265',NULL,'2025-10-01 17:05:21.328766',544,544,NULL,'644115e1-0b2c-4303-bf19-58856df9a7ee',171,'a1cd9e94225644748568dfbc4af1058a','gigabytes',-1,'2025-10-02 17:05:21','5c4f6639-cfc2-4866-9875-6cc9e6501c89'),('2025-10-01 17:05:21.563146',NULL,'2025-10-01 17:05:21.707276',545,545,'d6dae67f198f483d86a85008b5959866','01a61e04-7f5b-469b-964d-bee9a58f2802',140,'a1cd9e94225644748568dfbc4af1058a','shares',-1,'2025-10-02 17:05:21',NULL),('2025-10-01 17:05:21.564194',NULL,'2025-10-01 17:05:21.707276',546,546,'d6dae67f198f483d86a85008b5959866','c127bf26-7be6-4b99-9d17-2b78b92bafe3',139,'a1cd9e94225644748568dfbc4af1058a','gigabytes',-1,'2025-10-02 17:05:21',NULL),('2025-10-01 17:05:21.592033',NULL,'2025-10-01 17:05:21.707276',547,547,NULL,'a4b6b7bb-20eb-4ef2-90e7-46f1ae282684',169,'a1cd9e94225644748568dfbc4af1058a','shares',-1,'2025-10-02 17:05:21','bf0700f6-e269-4e6e-8ad2-2c76437dcb49'),('2025-10-01 17:05:21.592770',NULL,'2025-10-01 17:05:21.707276',548,548,NULL,'1fd5e2b3-216f-4676-b0e1-38d1350bb47f',170,'a1cd9e94225644748568dfbc4af1058a','gigabytes',-1,'2025-10-02 17:05:21','bf0700f6-e269-4e6e-8ad2-2c76437dcb49'),('2025-10-01 17:05:21.657812',NULL,'2025-10-01 17:05:21.852119',549,549,'d0c0ffc90809482c8626b2e61d341f16','ac5e33b4-584d-4aff-8e5e-f7ead9642334',152,'23b43441437342609cce9f7f9d4d5521','shares',-1,'2025-10-02 17:05:21',NULL),('2025-10-01 17:05:21.658772',NULL,'2025-10-01 17:05:21.852119',550,550,'d0c0ffc90809482c8626b2e61d341f16','d33177a3-6da6-4a48-8a4e-ae5dbc094b6d',151,'23b43441437342609cce9f7f9d4d5521','gigabytes',-1,'2025-10-02 17:05:21',NULL),('2025-10-01 17:05:21.787719',NULL,'2025-10-01 17:05:21.852119',551,551,NULL,'5a03dd87-5a18-4814-b8a1-a911192a5d62',154,'23b43441437342609cce9f7f9d4d5521','shares',-1,'2025-10-02 17:05:21','e67af6d6-3813-468e-96d3-f52430ec7993'),('2025-10-01 17:05:21.788631',NULL,'2025-10-01 17:05:21.852119',552,552,NULL,'cfb8ffa9-a9ce-49dc-b0ee-a58f568cbbf2',153,'23b43441437342609cce9f7f9d4d5521','gigabytes',-1,'2025-10-02 17:05:21','e67af6d6-3813-468e-96d3-f52430ec7993'),('2025-10-01 17:05:22.320551',NULL,'2025-10-01 17:05:22.393302',553,553,'d6dae67f198f483d86a85008b5959866','8b6b16f8-4fea-40b8-a09b-52970d469178',140,'a1cd9e94225644748568dfbc4af1058a','shares',1,'2025-10-02 17:05:22',NULL),('2025-10-01 17:05:22.322227',NULL,'2025-10-01 17:05:22.393302',554,554,'d6dae67f198f483d86a85008b5959866','42388f94-07d7-4daf-bae7-54125199b311',139,'a1cd9e94225644748568dfbc4af1058a','gigabytes',1,'2025-10-02 17:05:22',NULL),('2025-10-01 17:05:22.348511',NULL,'2025-10-01 17:05:22.393302',555,555,NULL,'d01e15d2-14be-4c70-b825-153134e46ce8',173,'a1cd9e94225644748568dfbc4af1058a','shares',1,'2025-10-02 17:05:22','0e7badfe-7b64-4ef5-9cae-3e2a73bd3271'),('2025-10-01 17:05:22.349924',NULL,'2025-10-01 17:05:22.393302',556,556,NULL,'b0b222ed-dbe0-43b9-b313-a321ccb2582c',174,'a1cd9e94225644748568dfbc4af1058a','gigabytes',1,'2025-10-02 17:05:22','0e7badfe-7b64-4ef5-9cae-3e2a73bd3271'),('2025-10-01 17:05:25.353308',NULL,'2025-10-01 17:05:25.512569',557,557,'d0c0ffc90809482c8626b2e61d341f16','0b87f409-4203-460b-90ff-99f3ac6cd0ce',152,'23b43441437342609cce9f7f9d4d5521','shares',-1,'2025-10-02 17:05:25',NULL),('2025-10-01 17:05:25.354010',NULL,'2025-10-01 17:05:25.512569',558,558,'d0c0ffc90809482c8626b2e61d341f16','424db089-917a-481f-8592-a7e4e4544990',151,'23b43441437342609cce9f7f9d4d5521','gigabytes',-1,'2025-10-02 17:05:25',NULL),('2025-10-01 17:05:25.459814',NULL,'2025-10-01 17:05:25.512569',559,559,NULL,'274bad0e-1296-4b6a-8159-bff8dc3a7cdd',154,'23b43441437342609cce9f7f9d4d5521','shares',-1,'2025-10-02 17:05:25','e67af6d6-3813-468e-96d3-f52430ec7993'),('2025-10-01 17:05:25.460785',NULL,'2025-10-01 17:05:25.512569',560,560,NULL,'069669d5-1aeb-44ca-8d2c-97003c79d597',153,'23b43441437342609cce9f7f9d4d5521','gigabytes',-1,'2025-10-02 17:05:25','e67af6d6-3813-468e-96d3-f52430ec7993'),('2025-10-01 17:05:26.306825',NULL,'2025-10-01 17:05:26.480013',561,561,'d6dae67f198f483d86a85008b5959866','2d39016e-ab2b-45b3-803d-b4d26d3f2f3b',140,'a1cd9e94225644748568dfbc4af1058a','shares',-1,'2025-10-02 17:05:26',NULL),('2025-10-01 17:05:26.307616',NULL,'2025-10-01 17:05:26.480013',562,562,'d6dae67f198f483d86a85008b5959866','766bdc92-9479-4b35-b1bb-4cfaf7974851',139,'a1cd9e94225644748568dfbc4af1058a','gigabytes',-1,'2025-10-02 17:05:26',NULL),('2025-10-01 17:05:26.456415',NULL,'2025-10-01 17:05:26.480013',563,563,NULL,'e892806e-5682-42ef-841d-c3e529281d15',173,'a1cd9e94225644748568dfbc4af1058a','shares',-1,'2025-10-02 17:05:26','0e7badfe-7b64-4ef5-9cae-3e2a73bd3271'),('2025-10-01 17:05:26.457242',NULL,'2025-10-01 17:05:26.480013',564,564,NULL,'e85ef31c-8816-43b2-bcf9-73022459268c',174,'a1cd9e94225644748568dfbc4af1058a','gigabytes',-1,'2025-10-02 17:05:26','0e7badfe-7b64-4ef5-9cae-3e2a73bd3271'),('2025-10-01 17:05:29.559721',NULL,'2025-10-01 17:05:29.629228',565,565,'d0c0ffc90809482c8626b2e61d341f16','fb580e89-5f54-4316-98a8-8775367dc430',152,'23b43441437342609cce9f7f9d4d5521','shares',-1,'2025-10-02 17:05:29',NULL),('2025-10-01 17:05:29.560410',NULL,'2025-10-01 17:05:29.629228',566,566,'d0c0ffc90809482c8626b2e61d341f16','d4b1544c-34a7-4ed1-9aac-b60f37125a49',151,'23b43441437342609cce9f7f9d4d5521','gigabytes',-1,'2025-10-02 17:05:29',NULL),('2025-10-01 17:05:29.599366',NULL,'2025-10-01 17:05:29.629228',567,567,NULL,'2af66c0f-7e01-491d-9363-427231a12517',154,'23b43441437342609cce9f7f9d4d5521','shares',-1,'2025-10-02 17:05:29','e67af6d6-3813-468e-96d3-f52430ec7993'),('2025-10-01 17:05:29.601664',NULL,'2025-10-01 17:05:29.629228',568,568,NULL,'8803b58d-51ba-4aa9-8dd7-099bff620d40',153,'23b43441437342609cce9f7f9d4d5521','gigabytes',-1,'2025-10-02 17:05:29','e67af6d6-3813-468e-96d3-f52430ec7993'),('2025-10-01 17:05:38.416308',NULL,'2025-10-01 17:05:38.453013',569,569,'09f29295317a46d6b8c0b29e6210e6f7','4be7b72c-d96d-43ec-bc64-da1614ba8fac',176,'ad666ccc4f754e07a5041ffb5aaf32ae','shares',1,'2025-10-02 17:05:38',NULL),('2025-10-01 17:05:38.417373',NULL,'2025-10-01 17:05:38.453013',570,570,'09f29295317a46d6b8c0b29e6210e6f7','2d71a650-5a00-4b8c-b9a7-cffca5489121',175,'ad666ccc4f754e07a5041ffb5aaf32ae','gigabytes',1,'2025-10-02 17:05:38',NULL),('2025-10-01 17:05:38.428355',NULL,'2025-10-01 17:05:38.453013',571,571,NULL,'eeac00ac-4333-4f83-8d22-f1b452e3540d',178,'ad666ccc4f754e07a5041ffb5aaf32ae','shares',1,'2025-10-02 17:05:38','80224da1-67c8-4766-8a84-e16e713a12a0'),('2025-10-01 17:05:38.429637',NULL,'2025-10-01 17:05:38.453013',572,572,NULL,'582b343b-9f28-4ce2-b30c-54e7205da5f0',177,'ad666ccc4f754e07a5041ffb5aaf32ae','gigabytes',1,'2025-10-02 17:05:38','80224da1-67c8-4766-8a84-e16e713a12a0'),('2025-10-01 17:05:38.439712',NULL,'2025-10-01 17:05:38.491344',573,573,'5acd4d62fc8e4eeabaae2462d3c7a8fa','5429f797-5f82-4dcb-8680-c9951fdb255d',162,'fb3120e923574f759bb16e2e2d603473','shares',1,'2025-10-02 17:05:38',NULL),('2025-10-01 17:05:38.440824',NULL,'2025-10-01 17:05:38.491344',574,574,'5acd4d62fc8e4eeabaae2462d3c7a8fa','cd7f6362-6563-4a17-b034-345fb42b757b',161,'fb3120e923574f759bb16e2e2d603473','gigabytes',1,'2025-10-02 17:05:38',NULL),('2025-10-01 17:05:38.455553',NULL,'2025-10-01 17:05:38.491344',575,575,NULL,'6e92320f-8b0b-47c6-a813-0abbbdb78a67',180,'fb3120e923574f759bb16e2e2d603473','shares',1,'2025-10-02 17:05:38','b09f42fb-ab61-4f61-a72d-bb65a506d3d5'),('2025-10-01 17:05:38.459587',NULL,'2025-10-01 17:05:38.491344',576,576,NULL,'14f789d1-07a9-485a-ac8b-1fd79e817eec',179,'fb3120e923574f759bb16e2e2d603473','gigabytes',1,'2025-10-02 17:05:38','b09f42fb-ab61-4f61-a72d-bb65a506d3d5'),('2025-10-01 17:05:41.540785',NULL,'2025-10-01 17:05:41.580464',577,577,'c0d8712c5da945d1ba492d2950f68d35','6185745d-4475-417b-bf88-1c6f39962ed4',182,'40c3564ff57e4cfca7dd255e456bdcb2','shares',1,'2025-10-02 17:05:41',NULL),('2025-10-01 17:05:41.542075',NULL,'2025-10-01 17:05:41.580464',578,578,'c0d8712c5da945d1ba492d2950f68d35','e224feb4-3573-485a-bd45-1dce22d6c79b',181,'40c3564ff57e4cfca7dd255e456bdcb2','gigabytes',1,'2025-10-02 17:05:41',NULL),('2025-10-01 17:05:41.554836',NULL,'2025-10-01 17:05:41.580464',579,579,NULL,'b83814ae-6b2f-4e76-82c7-8b4c9a0a180d',184,'40c3564ff57e4cfca7dd255e456bdcb2','shares',1,'2025-10-02 17:05:41','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:05:41.556141',NULL,'2025-10-01 17:05:41.580464',580,580,NULL,'020a4ed9-7322-4afe-b6e4-d9a86c4acd3f',183,'40c3564ff57e4cfca7dd255e456bdcb2','gigabytes',1,'2025-10-02 17:05:41','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:05:44.939644',NULL,'2025-10-01 17:05:45.033015',581,581,'c0d8712c5da945d1ba492d2950f68d35','49029b52-0102-4832-ae13-a94bbb0d3554',185,'40c3564ff57e4cfca7dd255e456bdcb2','snapshots',1,'2025-10-02 17:05:44',NULL),('2025-10-01 17:05:44.940762',NULL,'2025-10-01 17:05:45.033015',582,582,'c0d8712c5da945d1ba492d2950f68d35','046cb4f1-0234-4129-a70c-f158474b356e',186,'40c3564ff57e4cfca7dd255e456bdcb2','snapshot_gigabytes',1,'2025-10-02 17:05:44',NULL),('2025-10-01 17:05:44.953698',NULL,'2025-10-01 17:05:45.033015',583,583,NULL,'fd7d8039-299b-48fc-b7d4-2641124f5d8a',187,'40c3564ff57e4cfca7dd255e456bdcb2','snapshots',1,'2025-10-02 17:05:44','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:05:44.955371',NULL,'2025-10-01 17:05:45.033015',584,584,NULL,'e548534b-9527-4894-9a31-f065fd0870b6',188,'40c3564ff57e4cfca7dd255e456bdcb2','snapshot_gigabytes',1,'2025-10-02 17:05:44','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:05:48.377725',NULL,'2025-10-01 17:05:48.452592',585,585,'c0d8712c5da945d1ba492d2950f68d35','d9fd3f37-ed63-415b-a38d-8073e5c94eeb',185,'40c3564ff57e4cfca7dd255e456bdcb2','snapshots',1,'2025-10-02 17:05:48',NULL),('2025-10-01 17:05:48.379020',NULL,'2025-10-01 17:05:48.452592',586,586,'c0d8712c5da945d1ba492d2950f68d35','3f664cb5-5547-4ffa-9c2c-5c5b88b289fd',186,'40c3564ff57e4cfca7dd255e456bdcb2','snapshot_gigabytes',1,'2025-10-02 17:05:48',NULL),('2025-10-01 17:05:48.387734',NULL,'2025-10-01 17:05:48.452592',587,587,NULL,'f2f75a61-f7f6-4010-b09a-d8ded1bfccc0',187,'40c3564ff57e4cfca7dd255e456bdcb2','snapshots',1,'2025-10-02 17:05:48','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:05:48.388880',NULL,'2025-10-01 17:05:48.452592',588,588,NULL,'1ee31c67-90fc-4719-a5e1-246d5e4ebf5a',188,'40c3564ff57e4cfca7dd255e456bdcb2','snapshot_gigabytes',1,'2025-10-02 17:05:48','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:05:53.176144',NULL,'2025-10-01 17:05:53.228963',589,589,'c0d8712c5da945d1ba492d2950f68d35','fe497c7d-a3c2-4251-b222-7811b40c3033',185,'40c3564ff57e4cfca7dd255e456bdcb2','snapshots',-1,'2025-10-02 17:05:53',NULL),('2025-10-01 17:05:53.177414',NULL,'2025-10-01 17:05:53.228963',590,590,'c0d8712c5da945d1ba492d2950f68d35','113b5669-2614-4b7d-b993-4756864943c8',186,'40c3564ff57e4cfca7dd255e456bdcb2','snapshot_gigabytes',-1,'2025-10-02 17:05:53',NULL),('2025-10-01 17:05:53.200016',NULL,'2025-10-01 17:05:53.228963',591,591,NULL,'9d84a989-ce9b-4299-8d0c-808156adc8a7',187,'40c3564ff57e4cfca7dd255e456bdcb2','snapshots',-1,'2025-10-02 17:05:53','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:05:53.204417',NULL,'2025-10-01 17:05:53.228963',592,592,NULL,'4188a526-3534-4602-ac2a-65650ba03182',188,'40c3564ff57e4cfca7dd255e456bdcb2','snapshot_gigabytes',-1,'2025-10-02 17:05:53','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:05:53.371360',NULL,'2025-10-01 17:05:53.388312',593,593,'5acd4d62fc8e4eeabaae2462d3c7a8fa','b5e7bc36-45ee-40d9-95ec-2e50c716cc90',162,'fb3120e923574f759bb16e2e2d603473','shares',-1,'2025-10-02 17:05:53',NULL),('2025-10-01 17:05:53.373542',NULL,'2025-10-01 17:05:53.388312',594,594,'5acd4d62fc8e4eeabaae2462d3c7a8fa','b82cb587-703d-45aa-a1a4-c536332016cf',161,'fb3120e923574f759bb16e2e2d603473','gigabytes',-1,'2025-10-02 17:05:53',NULL),('2025-10-01 17:05:53.378581',NULL,'2025-10-01 17:05:53.388312',595,595,NULL,'7062f367-8e56-46b5-b8b5-d7d8c3ecf4e6',180,'fb3120e923574f759bb16e2e2d603473','shares',-1,'2025-10-02 17:05:53','b09f42fb-ab61-4f61-a72d-bb65a506d3d5'),('2025-10-01 17:05:53.379444',NULL,'2025-10-01 17:05:53.388312',596,596,NULL,'1010fd1f-e99c-4bff-b55d-01cb66647227',179,'fb3120e923574f759bb16e2e2d603473','gigabytes',-1,'2025-10-02 17:05:53','b09f42fb-ab61-4f61-a72d-bb65a506d3d5'),('2025-10-01 17:05:56.012298',NULL,'2025-10-01 17:05:56.098567',597,597,'c0d8712c5da945d1ba492d2950f68d35','8751e2df-4b8e-4864-b989-7df3e5187aa5',185,'40c3564ff57e4cfca7dd255e456bdcb2','snapshots',1,'2025-10-02 17:05:55',NULL),('2025-10-01 17:05:56.013850',NULL,'2025-10-01 17:05:56.098567',598,598,'c0d8712c5da945d1ba492d2950f68d35','b72e7131-2a0c-4e0c-9871-bd33e2a2349b',186,'40c3564ff57e4cfca7dd255e456bdcb2','snapshot_gigabytes',1,'2025-10-02 17:05:55',NULL),('2025-10-01 17:05:56.020746',NULL,'2025-10-01 17:05:56.098567',599,599,NULL,'f606390f-aa07-4e99-98ca-0cff9375b046',187,'40c3564ff57e4cfca7dd255e456bdcb2','snapshots',1,'2025-10-02 17:05:55','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:05:56.022383',NULL,'2025-10-01 17:05:56.098567',600,600,NULL,'f3e02753-3fe3-4f88-991c-f2aa60367b8b',188,'40c3564ff57e4cfca7dd255e456bdcb2','snapshot_gigabytes',1,'2025-10-02 17:05:55','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:05:56.835328',NULL,'2025-10-01 17:05:56.861524',601,601,'5acd4d62fc8e4eeabaae2462d3c7a8fa','54bc40ff-4deb-4f23-ab66-0f2d5f205048',162,'fb3120e923574f759bb16e2e2d603473','shares',-1,'2025-10-02 17:05:56',NULL),('2025-10-01 17:05:56.836551',NULL,'2025-10-01 17:05:56.861524',602,602,'5acd4d62fc8e4eeabaae2462d3c7a8fa','67c3f1cb-a2ec-4486-9a72-3a61fee8c61e',161,'fb3120e923574f759bb16e2e2d603473','gigabytes',-1,'2025-10-02 17:05:56',NULL),('2025-10-01 17:05:56.850238',NULL,'2025-10-01 17:05:56.861524',603,603,NULL,'340e4111-01c4-4476-9dc4-ca6b88cb2682',164,'fb3120e923574f759bb16e2e2d603473','shares',-1,'2025-10-02 17:05:56','a8a00136-83b3-4010-b21e-0ef332301b8d'),('2025-10-01 17:05:56.851261',NULL,'2025-10-01 17:05:56.861524',604,604,NULL,'b965d458-0a65-404c-973d-207231ea3be6',163,'fb3120e923574f759bb16e2e2d603473','gigabytes',-1,'2025-10-02 17:05:56','a8a00136-83b3-4010-b21e-0ef332301b8d'),('2025-10-01 17:06:00.152972',NULL,'2025-10-01 17:06:00.175608',605,605,'bdbab5c8cbd84614a605693d09049109','66b10d48-1120-4cbd-a2b4-8dc069b9dba9',146,'86a0062edb9a4a3293bf2e93012e4f13','shares',-1,'2025-10-02 17:06:00',NULL),('2025-10-01 17:06:00.154573',NULL,'2025-10-01 17:06:00.175608',606,606,'bdbab5c8cbd84614a605693d09049109','bf5fdf00-9672-45f6-b637-4e843698efaf',145,'86a0062edb9a4a3293bf2e93012e4f13','gigabytes',-1,'2025-10-02 17:06:00',NULL),('2025-10-01 17:06:00.165633',NULL,'2025-10-01 17:06:00.175608',607,607,NULL,'c63d2552-1194-47d9-9a3b-3d743c97adcf',156,'86a0062edb9a4a3293bf2e93012e4f13','shares',-1,'2025-10-02 17:06:00','a8a00136-83b3-4010-b21e-0ef332301b8d'),('2025-10-01 17:06:00.166833',NULL,'2025-10-01 17:06:00.175608',608,608,NULL,'0b5c09ce-6045-4a68-a44a-257f07ce3ace',155,'86a0062edb9a4a3293bf2e93012e4f13','gigabytes',-1,'2025-10-02 17:06:00','a8a00136-83b3-4010-b21e-0ef332301b8d'),('2025-10-01 17:06:01.090337',NULL,'2025-10-01 17:06:01.123182',609,609,'c0d8712c5da945d1ba492d2950f68d35','803b3a68-36d7-42a8-8dbf-51462614b301',185,'40c3564ff57e4cfca7dd255e456bdcb2','snapshots',-1,'2025-10-02 17:06:01',NULL),('2025-10-01 17:06:01.091316',NULL,'2025-10-01 17:06:01.123182',610,610,'c0d8712c5da945d1ba492d2950f68d35','4beb0d45-23d2-4c6f-adee-72c2c2f8d76d',186,'40c3564ff57e4cfca7dd255e456bdcb2','snapshot_gigabytes',-1,'2025-10-02 17:06:01',NULL),('2025-10-01 17:06:01.101356',NULL,'2025-10-01 17:06:01.123182',611,611,NULL,'5cbfb12a-7ed9-4061-b2cb-b9476a08cf73',187,'40c3564ff57e4cfca7dd255e456bdcb2','snapshots',-1,'2025-10-02 17:06:01','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:06:01.103582',NULL,'2025-10-01 17:06:01.123182',612,612,NULL,'0da1a1ee-c573-46a3-b84c-f8ab93e22964',188,'40c3564ff57e4cfca7dd255e456bdcb2','snapshot_gigabytes',-1,'2025-10-02 17:06:01','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:06:01.540942',NULL,'2025-10-01 17:06:01.556400',613,613,'09f29295317a46d6b8c0b29e6210e6f7','6983e501-8905-4e38-886d-a9500b43bfc5',176,'ad666ccc4f754e07a5041ffb5aaf32ae','shares',-1,'2025-10-02 17:06:01',NULL),('2025-10-01 17:06:01.541810',NULL,'2025-10-01 17:06:01.556400',614,614,'09f29295317a46d6b8c0b29e6210e6f7','191c0d06-41d3-428c-a132-e4c67c5f3dc3',175,'ad666ccc4f754e07a5041ffb5aaf32ae','gigabytes',-1,'2025-10-02 17:06:01',NULL),('2025-10-01 17:06:01.547579',NULL,'2025-10-01 17:06:01.556400',615,615,NULL,'c1ca8805-8985-485c-897f-e340c96c33fe',178,'ad666ccc4f754e07a5041ffb5aaf32ae','shares',-1,'2025-10-02 17:06:01','80224da1-67c8-4766-8a84-e16e713a12a0'),('2025-10-01 17:06:01.548299',NULL,'2025-10-01 17:06:01.556400',616,616,NULL,'ecff253e-1a92-41ec-bc24-ea964cb7c28c',177,'ad666ccc4f754e07a5041ffb5aaf32ae','gigabytes',-1,'2025-10-02 17:06:01','80224da1-67c8-4766-8a84-e16e713a12a0'),('2025-10-01 17:06:03.745709',NULL,'2025-10-01 17:06:03.760248',617,617,'bdbab5c8cbd84614a605693d09049109','4f4b8473-dade-4106-902e-2c659a3ecd89',146,'86a0062edb9a4a3293bf2e93012e4f13','shares',-1,'2025-10-02 17:06:03',NULL),('2025-10-01 17:06:03.746427',NULL,'2025-10-01 17:06:03.760248',618,618,'bdbab5c8cbd84614a605693d09049109','89e40579-5bc3-4195-b099-d44bf6fc35c6',145,'86a0062edb9a4a3293bf2e93012e4f13','gigabytes',-1,'2025-10-02 17:06:03',NULL),('2025-10-01 17:06:03.752536',NULL,'2025-10-01 17:06:03.760248',619,619,NULL,'eb3323b4-8780-44db-8f65-3bfc4b97e152',148,'86a0062edb9a4a3293bf2e93012e4f13','shares',-1,'2025-10-02 17:06:03','b09f42fb-ab61-4f61-a72d-bb65a506d3d5'),('2025-10-01 17:06:03.753275',NULL,'2025-10-01 17:06:03.760248',620,620,NULL,'aaca3343-cb57-49c9-927b-4eeee73f9aaf',147,'86a0062edb9a4a3293bf2e93012e4f13','gigabytes',-1,'2025-10-02 17:06:03','b09f42fb-ab61-4f61-a72d-bb65a506d3d5'),('2025-10-01 17:06:04.041784',NULL,'2025-10-01 17:06:04.106421',621,621,'c0d8712c5da945d1ba492d2950f68d35','8242fe46-8bf9-4733-8aad-0534f1b8efb3',185,'40c3564ff57e4cfca7dd255e456bdcb2','snapshots',1,'2025-10-02 17:06:04',NULL),('2025-10-01 17:06:04.043449',NULL,'2025-10-01 17:06:04.106421',622,622,'c0d8712c5da945d1ba492d2950f68d35','f23360db-c6e4-4bcc-925b-9c528205f078',186,'40c3564ff57e4cfca7dd255e456bdcb2','snapshot_gigabytes',1,'2025-10-02 17:06:04',NULL),('2025-10-01 17:06:04.051061',NULL,'2025-10-01 17:06:04.106421',623,623,NULL,'a0a5d8be-a108-48b9-a055-ad3fea8f189a',187,'40c3564ff57e4cfca7dd255e456bdcb2','snapshots',1,'2025-10-02 17:06:04','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:06:04.052201',NULL,'2025-10-01 17:06:04.106421',624,624,NULL,'464bd96c-d690-4fdc-b8c2-46e0ca3755c3',188,'40c3564ff57e4cfca7dd255e456bdcb2','snapshot_gigabytes',1,'2025-10-02 17:06:04','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:06:06.067111',NULL,'2025-10-01 17:06:06.097536',625,625,'173ca489ed484f4d9628dc0a289d1dba','65b56767-85d4-4bf2-b9c9-d9c876258211',190,'1841221f332340a299707d253063659f','shares',1,'2025-10-02 17:06:06',NULL),('2025-10-01 17:06:06.068349',NULL,'2025-10-01 17:06:06.097536',626,626,'173ca489ed484f4d9628dc0a289d1dba','9895fff0-0ab3-4bee-8aa7-81e8c4e6b5a1',189,'1841221f332340a299707d253063659f','gigabytes',1,'2025-10-02 17:06:06',NULL),('2025-10-01 17:06:06.074837',NULL,'2025-10-01 17:06:06.097536',627,627,NULL,'6897fa74-fdb2-494e-ab5d-829b319dd3fc',106,'1841221f332340a299707d253063659f','shares',1,'2025-10-02 17:06:06','3454de97-e8db-4b3e-a708-5ac562e85e73'),('2025-10-01 17:06:06.075993',NULL,'2025-10-01 17:06:06.097536',628,628,NULL,'41f521d3-ece9-4eae-8355-b7c3e40d8865',105,'1841221f332340a299707d253063659f','gigabytes',1,'2025-10-02 17:06:06','3454de97-e8db-4b3e-a708-5ac562e85e73'),('2025-10-01 17:06:08.211637',NULL,'2025-10-01 17:06:08.237398',629,629,'c0d8712c5da945d1ba492d2950f68d35','fbe72977-07f9-4ec4-8ad8-ef453a3eaf06',185,'40c3564ff57e4cfca7dd255e456bdcb2','snapshots',-1,'2025-10-02 17:06:08',NULL),('2025-10-01 17:06:08.214078',NULL,'2025-10-01 17:06:08.237398',630,630,'c0d8712c5da945d1ba492d2950f68d35','3f5a83dc-c1a0-43bd-b6b7-a61440944fda',186,'40c3564ff57e4cfca7dd255e456bdcb2','snapshot_gigabytes',-1,'2025-10-02 17:06:08',NULL),('2025-10-01 17:06:08.226101',NULL,'2025-10-01 17:06:08.237398',631,631,NULL,'29b624f2-f0e4-425d-8953-881f800c9cb7',187,'40c3564ff57e4cfca7dd255e456bdcb2','snapshots',-1,'2025-10-02 17:06:08','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:06:08.227002',NULL,'2025-10-01 17:06:08.237398',632,632,NULL,'c7d87ebd-2b50-4bab-a310-bf3b9b7e1f8f',188,'40c3564ff57e4cfca7dd255e456bdcb2','snapshot_gigabytes',-1,'2025-10-02 17:06:08','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:06:11.321182',NULL,'2025-10-01 17:06:11.390710',633,633,'c0d8712c5da945d1ba492d2950f68d35','8d2f90c0-094f-440b-abcc-4a2f314f8072',185,'40c3564ff57e4cfca7dd255e456bdcb2','snapshots',1,'2025-10-02 17:06:11',NULL),('2025-10-01 17:06:11.324450',NULL,'2025-10-01 17:06:11.390710',634,634,'c0d8712c5da945d1ba492d2950f68d35','7fe1f71c-32c7-4340-ac74-1cc281c9b24a',186,'40c3564ff57e4cfca7dd255e456bdcb2','snapshot_gigabytes',1,'2025-10-02 17:06:11',NULL),('2025-10-01 17:06:11.332883',NULL,'2025-10-01 17:06:11.390710',635,635,NULL,'11683b2b-c8bf-411d-829a-4c5b31ae88bf',187,'40c3564ff57e4cfca7dd255e456bdcb2','snapshots',1,'2025-10-02 17:06:11','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:06:11.334159',NULL,'2025-10-01 17:06:11.390710',636,636,NULL,'5dbacb07-5144-4ec6-adf9-ee3ebe6cf68f',188,'40c3564ff57e4cfca7dd255e456bdcb2','snapshot_gigabytes',1,'2025-10-02 17:06:11','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:06:11.748645',NULL,'2025-10-01 17:06:11.791492',637,637,'04f5ceff16e74a1bb67c0b5ed79dce63','49c44d43-3c2a-48b8-a755-508028ed977d',191,'8c95d7d4c61e4a5bbe4dc2e0f6e03fd9','shares',1,'2025-10-02 17:06:11',NULL),('2025-10-01 17:06:11.749901',NULL,'2025-10-01 17:06:11.791492',638,638,'04f5ceff16e74a1bb67c0b5ed79dce63','a336337e-8bd9-4eae-9c17-d9a39c077a36',192,'8c95d7d4c61e4a5bbe4dc2e0f6e03fd9','gigabytes',1,'2025-10-02 17:06:11',NULL),('2025-10-01 17:06:11.761864',NULL,'2025-10-01 17:06:11.791492',639,639,NULL,'ad91dab4-9711-4497-935c-eca1b93ae012',193,'8c95d7d4c61e4a5bbe4dc2e0f6e03fd9','shares',1,'2025-10-02 17:06:11','55334669-db93-4cfa-8367-2b8ce2d4cd8b'),('2025-10-01 17:06:11.762937',NULL,'2025-10-01 17:06:11.791492',640,640,NULL,'67966438-839c-4078-b36d-bfc37f15fc09',194,'8c95d7d4c61e4a5bbe4dc2e0f6e03fd9','gigabytes',1,'2025-10-02 17:06:11','55334669-db93-4cfa-8367-2b8ce2d4cd8b'),('2025-10-01 17:06:14.916751',NULL,'2025-10-01 17:06:14.966624',641,641,'bbe9b26c815c44cb9bf87c8ab647d6f0','f730622a-5337-4c84-8dfc-b00d02200572',195,'8b2c53e72b304ed58c7323214b5da098','share_networks',1,'2025-10-02 17:06:14',NULL),('2025-10-01 17:06:17.494632',NULL,'2025-10-01 17:06:17.570413',642,642,'04f5ceff16e74a1bb67c0b5ed79dce63','2477f153-a223-474e-8152-66dda431f26c',191,'8c95d7d4c61e4a5bbe4dc2e0f6e03fd9','shares',-1,'2025-10-02 17:06:17',NULL),('2025-10-01 17:06:17.496630',NULL,'2025-10-01 17:06:17.570413',643,643,'04f5ceff16e74a1bb67c0b5ed79dce63','25a74345-b7a3-4b4c-906a-b9ee05a36877',192,'8c95d7d4c61e4a5bbe4dc2e0f6e03fd9','gigabytes',-1,'2025-10-02 17:06:17',NULL),('2025-10-01 17:06:17.544604',NULL,'2025-10-01 17:06:17.570413',644,644,NULL,'b81ae4a5-fa04-4a24-8e74-b72f94e87243',193,'8c95d7d4c61e4a5bbe4dc2e0f6e03fd9','shares',-1,'2025-10-02 17:06:17','55334669-db93-4cfa-8367-2b8ce2d4cd8b'),('2025-10-01 17:06:17.545596',NULL,'2025-10-01 17:06:17.570413',645,645,NULL,'f6a2079b-1cd7-44bd-9712-e9e22c6707c8',194,'8c95d7d4c61e4a5bbe4dc2e0f6e03fd9','gigabytes',-1,'2025-10-02 17:06:17','55334669-db93-4cfa-8367-2b8ce2d4cd8b'),('2025-10-01 17:06:17.620274',NULL,'2025-10-01 17:06:17.643824',646,646,'c0d8712c5da945d1ba492d2950f68d35','ce665638-f33c-42a0-a0f0-d484b71f20c7',185,'40c3564ff57e4cfca7dd255e456bdcb2','snapshots',-1,'2025-10-02 17:06:17',NULL),('2025-10-01 17:06:17.621327',NULL,'2025-10-01 17:06:17.643824',647,647,'c0d8712c5da945d1ba492d2950f68d35','c51ed9bc-41a1-4164-bb27-49e71e9ce503',186,'40c3564ff57e4cfca7dd255e456bdcb2','snapshot_gigabytes',-1,'2025-10-02 17:06:17',NULL),('2025-10-01 17:06:17.629307',NULL,'2025-10-01 17:06:17.643824',648,648,NULL,'58ec953c-875e-456b-80bf-7a32689c9fbe',187,'40c3564ff57e4cfca7dd255e456bdcb2','snapshots',-1,'2025-10-02 17:06:17','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:06:17.630000',NULL,'2025-10-01 17:06:17.643824',649,649,NULL,'0f948bf7-845a-4d30-87fb-40922aa4fe0d',188,'40c3564ff57e4cfca7dd255e456bdcb2','snapshot_gigabytes',-1,'2025-10-02 17:06:17','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:06:21.831945',NULL,'2025-10-01 17:06:21.880242',650,650,'6ae885d77a5748a299ec5daaece928c1','84dc155c-167d-46d4-a531-c9c7643c1d0a',104,'1841221f332340a299707d253063659f','shares',-1,'2025-10-02 17:06:21',NULL),('2025-10-01 17:06:21.832710',NULL,'2025-10-01 17:06:21.880242',651,651,'6ae885d77a5748a299ec5daaece928c1','7227214e-fe83-4890-87b1-5e52fcd5762a',103,'1841221f332340a299707d253063659f','gigabytes',-1,'2025-10-02 17:06:21',NULL),('2025-10-01 17:06:21.852400',NULL,'2025-10-01 17:06:21.880242',652,652,NULL,'456a8c5f-3986-4ca1-b719-fdbf4825366d',106,'1841221f332340a299707d253063659f','shares',-1,'2025-10-02 17:06:21','3454de97-e8db-4b3e-a708-5ac562e85e73'),('2025-10-01 17:06:21.863076',NULL,'2025-10-01 17:06:21.880242',653,653,NULL,'4f1d5882-76cc-4d2d-9d1b-bbb1be9441c1',105,'1841221f332340a299707d253063659f','gigabytes',-1,'2025-10-02 17:06:21','3454de97-e8db-4b3e-a708-5ac562e85e73'),('2025-10-01 17:06:21.977323',NULL,'2025-10-01 17:06:22.215782',654,654,'c0d8712c5da945d1ba492d2950f68d35','36de36ea-648b-4d51-a920-2ed439f2df02',185,'40c3564ff57e4cfca7dd255e456bdcb2','snapshots',1,'2025-10-02 17:06:21',NULL),('2025-10-01 17:06:21.979456',NULL,'2025-10-01 17:06:22.215782',655,655,'c0d8712c5da945d1ba492d2950f68d35','f2b76197-17ce-4eb4-87a0-d3eaaed3f93f',186,'40c3564ff57e4cfca7dd255e456bdcb2','snapshot_gigabytes',1,'2025-10-02 17:06:21',NULL),('2025-10-01 17:06:21.992379',NULL,'2025-10-01 17:06:22.215782',656,656,NULL,'d274e98a-ba1d-4fdd-ac79-ad34f037f828',187,'40c3564ff57e4cfca7dd255e456bdcb2','snapshots',1,'2025-10-02 17:06:21','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:06:21.993837',NULL,'2025-10-01 17:06:22.215782',657,657,NULL,'47bf7828-af19-4422-bd29-cb593047860a',188,'40c3564ff57e4cfca7dd255e456bdcb2','snapshot_gigabytes',1,'2025-10-02 17:06:21','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:06:22.683125',NULL,'2025-10-01 17:06:22.719230',658,658,'8945292d68314360add2298ae9496343','99a00ceb-fc6b-485c-bcae-6ca5d06d3fd5',196,'89da7f149c6d414e94627e6e6c634ced','share_networks',1,'2025-10-02 17:06:22',NULL),('2025-10-01 17:06:23.068470',NULL,'2025-10-01 17:06:23.104811',659,659,'8945292d68314360add2298ae9496343','886bf0bb-fb76-4dad-9e5c-3060f22aa36b',196,'89da7f149c6d414e94627e6e6c634ced','share_networks',1,'2025-10-02 17:06:23',NULL),('2025-10-01 17:06:23.287376',NULL,'2025-10-01 17:06:23.324875',660,660,'8945292d68314360add2298ae9496343','43439617-d297-46f8-a667-a26cd9a6fa07',196,'89da7f149c6d414e94627e6e6c634ced','share_networks',1,'2025-10-02 17:06:23',NULL),('2025-10-01 17:06:23.468592',NULL,'2025-10-01 17:06:23.478809',661,661,'8945292d68314360add2298ae9496343','2ad227bd-2a9a-40a4-8488-b3a1c4942229',196,'89da7f149c6d414e94627e6e6c634ced','share_networks',-1,'2025-10-02 17:06:23',NULL),('2025-10-01 17:06:23.828795',NULL,'2025-10-01 17:06:23.883589',662,662,'8945292d68314360add2298ae9496343','fb1f2bba-2809-4fcf-bdc0-21b55415032b',196,'89da7f149c6d414e94627e6e6c634ced','share_networks',1,'2025-10-02 17:06:23',NULL),('2025-10-01 17:06:23.975903',NULL,'2025-10-01 17:06:24.003922',663,663,'8945292d68314360add2298ae9496343','b76ed429-e71f-420d-95be-f421337534c0',196,'89da7f149c6d414e94627e6e6c634ced','share_networks',1,'2025-10-02 17:06:23',NULL),('2025-10-01 17:06:24.120347',NULL,'2025-10-01 17:06:24.129919',664,664,'8945292d68314360add2298ae9496343','e26fa07b-7306-48cb-b067-0015c0d9224d',196,'89da7f149c6d414e94627e6e6c634ced','share_networks',-1,'2025-10-02 17:06:24',NULL),('2025-10-01 17:06:24.304662',NULL,'2025-10-01 17:06:24.320159',665,665,'8945292d68314360add2298ae9496343','02dc97f3-d583-4fff-81b6-118b86c4bc9e',196,'89da7f149c6d414e94627e6e6c634ced','share_networks',-1,'2025-10-02 17:06:24',NULL),('2025-10-01 17:06:25.661278',NULL,'2025-10-01 17:06:25.712098',666,666,'8945292d68314360add2298ae9496343','065ea02f-c323-428b-be3e-2e96271699d3',196,'89da7f149c6d414e94627e6e6c634ced','share_networks',1,'2025-10-02 17:06:25',NULL),('2025-10-01 17:06:25.850057',NULL,'2025-10-01 17:06:25.858186',667,667,'8945292d68314360add2298ae9496343','45ceb271-d0c3-40ac-abea-f9b3968e11e0',196,'89da7f149c6d414e94627e6e6c634ced','share_networks',-1,'2025-10-02 17:06:25',NULL),('2025-10-01 17:06:25.927206',NULL,'2025-10-01 17:06:25.976403',668,668,'8945292d68314360add2298ae9496343','f772839c-97bf-4bf4-b45f-2b91fefca15b',196,'89da7f149c6d414e94627e6e6c634ced','share_networks',1,'2025-10-02 17:06:25',NULL),('2025-10-01 17:06:26.103495',NULL,'2025-10-01 17:06:26.107928',669,669,'8945292d68314360add2298ae9496343','427ff90e-29fc-4f3b-be8e-6352dd86dba9',196,'89da7f149c6d414e94627e6e6c634ced','share_networks',-1,'2025-10-02 17:06:26',NULL),('2025-10-01 17:06:27.438466',NULL,'2025-10-01 17:06:27.471814',670,670,'8945292d68314360add2298ae9496343','bf382d64-3e6c-4bbb-a8cb-d7db1abcdd3f',196,'89da7f149c6d414e94627e6e6c634ced','share_networks',-1,'2025-10-02 17:06:27',NULL),('2025-10-01 17:06:27.760612',NULL,'2025-10-01 17:06:27.769924',671,671,'8945292d68314360add2298ae9496343','2bdac136-27df-48dd-9523-ba658560ef37',196,'89da7f149c6d414e94627e6e6c634ced','share_networks',-1,'2025-10-02 17:06:27',NULL),('2025-10-01 17:06:28.568939',NULL,'2025-10-01 17:06:28.631679',672,672,'c0d8712c5da945d1ba492d2950f68d35','f5f56c60-2a52-455b-8f6a-e5dc43154526',185,'40c3564ff57e4cfca7dd255e456bdcb2','snapshots',-1,'2025-10-02 17:06:28',NULL),('2025-10-01 17:06:28.569862',NULL,'2025-10-01 17:06:28.631679',673,673,'c0d8712c5da945d1ba492d2950f68d35','f9ff16a9-bb00-4376-bc2c-6e26cfe414bc',186,'40c3564ff57e4cfca7dd255e456bdcb2','snapshot_gigabytes',-1,'2025-10-02 17:06:28',NULL),('2025-10-01 17:06:28.613331',NULL,'2025-10-01 17:06:28.631679',674,674,NULL,'181741a1-d62b-4df7-8c78-bd7acff1bd50',187,'40c3564ff57e4cfca7dd255e456bdcb2','snapshots',-1,'2025-10-02 17:06:28','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:06:28.614904',NULL,'2025-10-01 17:06:28.631679',675,675,NULL,'33312c16-0e3a-41c3-a7e3-962978a31d2f',188,'40c3564ff57e4cfca7dd255e456bdcb2','snapshot_gigabytes',-1,'2025-10-02 17:06:28','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:06:32.655534',NULL,'2025-10-01 17:06:32.670341',676,676,'c0d8712c5da945d1ba492d2950f68d35','2feb4836-7c01-4adc-ac16-ab9d4c2287b0',185,'40c3564ff57e4cfca7dd255e456bdcb2','snapshots',-1,'2025-10-02 17:06:32',NULL),('2025-10-01 17:06:32.656211',NULL,'2025-10-01 17:06:32.670341',677,677,'c0d8712c5da945d1ba492d2950f68d35','3738b8a3-2d68-400f-a20a-c5a9705bdf2c',186,'40c3564ff57e4cfca7dd255e456bdcb2','snapshot_gigabytes',-1,'2025-10-02 17:06:32',NULL),('2025-10-01 17:06:32.663504',NULL,'2025-10-01 17:06:32.670341',678,678,NULL,'d28215d8-150b-4adc-a486-559759c62a05',187,'40c3564ff57e4cfca7dd255e456bdcb2','snapshots',-1,'2025-10-02 17:06:32','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:06:32.664183',NULL,'2025-10-01 17:06:32.670341',679,679,NULL,'70b4a0ae-a893-469e-8694-ef6456ec0050',188,'40c3564ff57e4cfca7dd255e456bdcb2','snapshot_gigabytes',-1,'2025-10-02 17:06:32','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:06:36.414651',NULL,'2025-10-01 17:06:36.467509',680,680,'13c52b1d5b7048f4bf4952658e63fbac','6d235329-4ebe-4dee-8eba-6d2cd85b2fe3',198,'1dd38e8e995543ea9f3667b44746e174','shares',1,'2025-10-02 17:06:36',NULL),('2025-10-01 17:06:36.415766',NULL,'2025-10-01 17:06:36.467509',681,681,'13c52b1d5b7048f4bf4952658e63fbac','3ae92954-20fa-4d5d-92ef-485772847d75',197,'1dd38e8e995543ea9f3667b44746e174','gigabytes',1,'2025-10-02 17:06:36',NULL),('2025-10-01 17:06:36.435984',NULL,'2025-10-01 17:06:36.467509',682,682,NULL,'639a2e35-90d6-4a6b-9a14-c891cc0b8c35',200,'1dd38e8e995543ea9f3667b44746e174','shares',1,'2025-10-02 17:06:36','1db0c391-0940-40b9-8519-f4e0c69684f3'),('2025-10-01 17:06:36.437131',NULL,'2025-10-01 17:06:36.467509',683,683,NULL,'4a674eb9-cadd-4201-b206-11f0851c4535',199,'1dd38e8e995543ea9f3667b44746e174','gigabytes',1,'2025-10-02 17:06:36','1db0c391-0940-40b9-8519-f4e0c69684f3'),('2025-10-01 17:06:36.457366',NULL,'2025-10-01 17:06:36.512428',684,684,'c0d8712c5da945d1ba492d2950f68d35','1fde24f6-3899-46d1-b79c-43733b5c4d4c',182,'40c3564ff57e4cfca7dd255e456bdcb2','shares',-1,'2025-10-02 17:06:36',NULL),('2025-10-01 17:06:36.465849',NULL,'2025-10-01 17:06:36.512428',685,685,'c0d8712c5da945d1ba492d2950f68d35','c3bd6b94-51af-4306-b00b-b78a22b68481',181,'40c3564ff57e4cfca7dd255e456bdcb2','gigabytes',-1,'2025-10-02 17:06:36',NULL),('2025-10-01 17:06:36.475691',NULL,'2025-10-01 17:06:36.512428',686,686,NULL,'a6caa466-89b6-4d4f-98fc-bbab64201021',184,'40c3564ff57e4cfca7dd255e456bdcb2','shares',-1,'2025-10-02 17:06:36','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:06:36.476429',NULL,'2025-10-01 17:06:36.512428',687,687,NULL,'ef537408-c08d-4325-9f3b-b1dfe51f09e7',183,'40c3564ff57e4cfca7dd255e456bdcb2','gigabytes',-1,'2025-10-02 17:06:36','af3d117f-22fe-4775-ba1f-16e7503d27f3'),('2025-10-01 17:06:38.002817',NULL,'2025-10-01 17:06:38.097306',688,688,'fcbf8552ba484efaa8cae2712992af80','6a7974dd-6e0f-4ed1-ab4f-c77a5396f0d8',202,'384850ddb88c4d3798b3a3d365973ad0','shares',1,'2025-10-02 17:06:37',NULL),('2025-10-01 17:06:38.005232',NULL,'2025-10-01 17:06:38.097306',689,689,'fcbf8552ba484efaa8cae2712992af80','03bcf44a-0206-44df-a9aa-d0b5faa492e9',201,'384850ddb88c4d3798b3a3d365973ad0','gigabytes',1,'2025-10-02 17:06:37',NULL),('2025-10-01 17:06:38.037298',NULL,'2025-10-01 17:06:38.097306',690,690,NULL,'9e3edb36-b908-4678-ac6a-eb615d26bd09',204,'384850ddb88c4d3798b3a3d365973ad0','shares',1,'2025-10-02 17:06:37','c5837613-7660-4253-b4d4-3a77d14c481c'),('2025-10-01 17:06:38.040570',NULL,'2025-10-01 17:06:38.097306',691,691,NULL,'d73378c6-92c9-4c9d-82b1-ee8b8b9fd234',203,'384850ddb88c4d3798b3a3d365973ad0','gigabytes',1,'2025-10-02 17:06:37','c5837613-7660-4253-b4d4-3a77d14c481c'),('2025-10-01 17:06:41.704524',NULL,'2025-10-01 17:06:41.847188',692,692,'fcbf8552ba484efaa8cae2712992af80','f391c4d6-b135-4058-a256-7d1b8a46f2b4',205,'384850ddb88c4d3798b3a3d365973ad0','snapshots',1,'2025-10-02 17:06:41',NULL),('2025-10-01 17:06:41.705495',NULL,'2025-10-01 17:06:41.847188',693,693,'fcbf8552ba484efaa8cae2712992af80','8dee641f-9183-4307-91ac-866b4aa4cd52',206,'384850ddb88c4d3798b3a3d365973ad0','snapshot_gigabytes',1,'2025-10-02 17:06:41',NULL),('2025-10-01 17:06:41.751328',NULL,'2025-10-01 17:06:41.847188',694,694,NULL,'6c8cc5a1-f926-48b8-bf99-4e1c5edc4381',207,'384850ddb88c4d3798b3a3d365973ad0','snapshots',1,'2025-10-02 17:06:41','c5837613-7660-4253-b4d4-3a77d14c481c'),('2025-10-01 17:06:41.752479',NULL,'2025-10-01 17:06:41.847188',695,695,NULL,'a876b4af-a1a2-4f79-84c0-b0dcf77e92fc',208,'384850ddb88c4d3798b3a3d365973ad0','snapshot_gigabytes',1,'2025-10-02 17:06:41','c5837613-7660-4253-b4d4-3a77d14c481c'),('2025-10-01 17:06:42.483996',NULL,'2025-10-01 17:06:42.553924',696,696,'13c52b1d5b7048f4bf4952658e63fbac','c8337b03-65b2-42d0-acb7-40d62016b372',198,'1dd38e8e995543ea9f3667b44746e174','shares',-1,'2025-10-02 17:06:42',NULL),('2025-10-01 17:06:42.484763',NULL,'2025-10-01 17:06:42.553924',697,697,'13c52b1d5b7048f4bf4952658e63fbac','051229dc-bad9-45d0-a8e7-e602441d8b33',197,'1dd38e8e995543ea9f3667b44746e174','gigabytes',-1,'2025-10-02 17:06:42',NULL),('2025-10-01 17:06:42.516493',NULL,'2025-10-01 17:06:42.553924',698,698,NULL,'86ace571-d8de-4cbb-b41f-2a930662a5c8',200,'1dd38e8e995543ea9f3667b44746e174','shares',-1,'2025-10-02 17:06:42','1db0c391-0940-40b9-8519-f4e0c69684f3'),('2025-10-01 17:06:42.517560',NULL,'2025-10-01 17:06:42.553924',699,699,NULL,'9a00237e-2f25-4cb7-b342-11ea2e1afc4d',199,'1dd38e8e995543ea9f3667b44746e174','gigabytes',-1,'2025-10-02 17:06:42','1db0c391-0940-40b9-8519-f4e0c69684f3'),('2025-10-01 17:06:44.987894',NULL,'2025-10-01 17:06:45.107027',700,700,'7f64c97f01d745219a4bd763f763f698','dd19fee5-ea31-4d7e-ad99-0452981007ae',209,'7b8bec1247f54479b803a9ec7e7655de','share_networks',1,'2025-10-02 17:06:44',NULL),('2025-10-01 17:06:45.819641',NULL,'2025-10-01 17:06:45.844288',701,701,'fcbf8552ba484efaa8cae2712992af80','a1347f43-39a4-4f11-a806-c81ad066a13b',205,'384850ddb88c4d3798b3a3d365973ad0','snapshots',-1,'2025-10-02 17:06:45',NULL),('2025-10-01 17:06:45.820510',NULL,'2025-10-01 17:06:45.844288',702,702,'fcbf8552ba484efaa8cae2712992af80','4b5c1ce6-5813-4366-8362-060d73402e02',206,'384850ddb88c4d3798b3a3d365973ad0','snapshot_gigabytes',-1,'2025-10-02 17:06:45',NULL),('2025-10-01 17:06:45.831359',NULL,'2025-10-01 17:06:45.844288',703,703,NULL,'37cabea1-d636-4498-a070-166d046af537',207,'384850ddb88c4d3798b3a3d365973ad0','snapshots',-1,'2025-10-02 17:06:45','c5837613-7660-4253-b4d4-3a77d14c481c'),('2025-10-01 17:06:45.832371',NULL,'2025-10-01 17:06:45.844288',704,704,NULL,'feb4be29-8f40-4c0c-ba63-4635fabdf7ed',208,'384850ddb88c4d3798b3a3d365973ad0','snapshot_gigabytes',-1,'2025-10-02 17:06:45','c5837613-7660-4253-b4d4-3a77d14c481c'),('2025-10-01 17:06:45.895249',NULL,'2025-10-01 17:06:45.914650',705,705,'7f64c97f01d745219a4bd763f763f698','48b8a806-bf3a-42df-87ed-6684823cdb48',209,'7b8bec1247f54479b803a9ec7e7655de','share_networks',-1,'2025-10-02 17:06:45',NULL),('2025-10-01 17:06:46.218820',NULL,'2025-10-01 17:06:46.417638',706,706,'7f64c97f01d745219a4bd763f763f698','11e4982a-1e89-4e6c-8cae-c0bccf90da23',209,'7b8bec1247f54479b803a9ec7e7655de','share_networks',1,'2025-10-02 17:06:46',NULL),('2025-10-01 17:06:47.149830',NULL,'2025-10-01 17:06:47.201561',707,707,'7f64c97f01d745219a4bd763f763f698','b1139603-102e-41e2-9330-bab515f3fd2b',209,'7b8bec1247f54479b803a9ec7e7655de','share_networks',-1,'2025-10-02 17:06:47',NULL),('2025-10-01 17:06:47.433664',NULL,'2025-10-01 17:06:47.573400',708,708,'7f64c97f01d745219a4bd763f763f698','02056b48-8d67-48f2-8086-16ee60e54fdf',209,'7b8bec1247f54479b803a9ec7e7655de','share_networks',1,'2025-10-02 17:06:47',NULL),('2025-10-01 17:06:48.417549',NULL,'2025-10-01 17:06:48.436147',709,709,'7f64c97f01d745219a4bd763f763f698','be3d1713-a8a8-4d3f-9ce1-d40c6a7bf3cb',209,'7b8bec1247f54479b803a9ec7e7655de','share_networks',-1,'2025-10-02 17:06:48',NULL),('2025-10-01 17:06:49.597801',NULL,'2025-10-01 17:06:49.688264',710,710,'fcbf8552ba484efaa8cae2712992af80','8e0ce446-143c-4230-b07b-b82cffa70ea7',202,'384850ddb88c4d3798b3a3d365973ad0','shares',-1,'2025-10-02 17:06:49',NULL),('2025-10-01 17:06:49.598928',NULL,'2025-10-01 17:06:49.688264',711,711,'fcbf8552ba484efaa8cae2712992af80','0ed7eb02-fa3e-4684-9f76-62f7341edf24',201,'384850ddb88c4d3798b3a3d365973ad0','gigabytes',-1,'2025-10-02 17:06:49',NULL),('2025-10-01 17:06:49.624787',NULL,'2025-10-01 17:06:49.688264',712,712,NULL,'66d9fa2a-8a10-48ee-9c04-45430bb37962',204,'384850ddb88c4d3798b3a3d365973ad0','shares',-1,'2025-10-02 17:06:49','c5837613-7660-4253-b4d4-3a77d14c481c'),('2025-10-01 17:06:49.625883',NULL,'2025-10-01 17:06:49.688264',713,713,NULL,'20ef4e61-84f8-4601-a8aa-450e17d9f7b6',203,'384850ddb88c4d3798b3a3d365973ad0','gigabytes',-1,'2025-10-02 17:06:49','c5837613-7660-4253-b4d4-3a77d14c481c'),('2025-10-01 17:06:53.381701',NULL,'2025-10-01 17:06:53.439694',714,714,'fcbf8552ba484efaa8cae2712992af80','946a128d-e850-4be8-9084-df30663c7d75',202,'384850ddb88c4d3798b3a3d365973ad0','shares',1,'2025-10-02 17:06:53',NULL),('2025-10-01 17:06:53.382871',NULL,'2025-10-01 17:06:53.439694',715,715,'fcbf8552ba484efaa8cae2712992af80','f3ee4765-70c7-4997-9532-d59226a769b6',201,'384850ddb88c4d3798b3a3d365973ad0','gigabytes',1,'2025-10-02 17:06:53',NULL),('2025-10-01 17:06:53.404761',NULL,'2025-10-01 17:06:53.439694',716,716,NULL,'1276329a-2f68-419b-87a0-8b0db2afcfbe',210,'384850ddb88c4d3798b3a3d365973ad0','shares',1,'2025-10-02 17:06:53','8478d453-a6b0-4b46-9199-1966caf8d4cf'),('2025-10-01 17:06:53.405789',NULL,'2025-10-01 17:06:53.439694',717,717,NULL,'0a816e63-9cc6-4af1-8ec5-ec7496b31d88',211,'384850ddb88c4d3798b3a3d365973ad0','gigabytes',1,'2025-10-02 17:06:53','8478d453-a6b0-4b46-9199-1966caf8d4cf'),('2025-10-01 17:06:56.434174',NULL,'2025-10-01 17:06:56.506993',718,718,'38ae86a37a0b4939a6f90ce219165e47','97adf327-b5af-448b-b612-29f82d7182ce',212,'30cd3ce4e43d4122b839b6e5f4bf6511','share_networks',1,'2025-10-02 17:06:56',NULL),('2025-10-01 17:06:57.182013',NULL,'2025-10-01 17:06:57.236913',719,719,'fdec41847e24465299bb1f75d3e480d2','2ca512f5-940e-4563-af21-8cd27bf276b0',213,'7697ecff3b5f413c99a5ace837dd6970','shares',1,'2025-10-02 17:06:57',NULL),('2025-10-01 17:06:57.183290',NULL,'2025-10-01 17:06:57.236913',720,720,'fdec41847e24465299bb1f75d3e480d2','c4a2b46b-4e13-4de2-83cd-3a8be4cfd1ee',214,'7697ecff3b5f413c99a5ace837dd6970','gigabytes',1,'2025-10-02 17:06:57',NULL),('2025-10-01 17:06:57.202774',NULL,'2025-10-01 17:06:57.236913',721,721,NULL,'98455828-51e3-4c54-a48e-f217d5b03a19',215,'7697ecff3b5f413c99a5ace837dd6970','shares',1,'2025-10-02 17:06:57','5efa3b2a-601c-4ea8-9cf6-c5c76a3276c5'),('2025-10-01 17:06:57.203928',NULL,'2025-10-01 17:06:57.236913',722,722,NULL,'5bda689f-53c6-4e83-8781-af72593957b1',216,'7697ecff3b5f413c99a5ace837dd6970','gigabytes',1,'2025-10-02 17:06:57','5efa3b2a-601c-4ea8-9cf6-c5c76a3276c5'),('2025-10-01 17:06:57.878828',NULL,'2025-10-01 17:06:57.945261',723,723,'38ae86a37a0b4939a6f90ce219165e47','c806f597-b340-450a-b6b9-69afbe4b330e',212,'30cd3ce4e43d4122b839b6e5f4bf6511','share_networks',1,'2025-10-02 17:06:57',NULL),('2025-10-01 17:06:58.709304',NULL,'2025-10-01 17:06:58.727536',724,724,'38ae86a37a0b4939a6f90ce219165e47','4dd9122f-1eb2-4f0a-9171-44f489943446',212,'30cd3ce4e43d4122b839b6e5f4bf6511','share_networks',-1,'2025-10-02 17:06:58',NULL),('2025-10-01 17:06:58.899890',NULL,'2025-10-01 17:06:59.021938',725,725,'38ae86a37a0b4939a6f90ce219165e47','28d496c0-d6d5-4c07-aaad-590a2a07b66a',212,'30cd3ce4e43d4122b839b6e5f4bf6511','share_networks',1,'2025-10-02 17:06:58',NULL),('2025-10-01 17:06:59.018935',NULL,'2025-10-01 17:06:59.092014',726,726,'fcbf8552ba484efaa8cae2712992af80','826a11c9-56f8-4eab-8023-602ea74a4c6e',202,'384850ddb88c4d3798b3a3d365973ad0','shares',-1,'2025-10-02 17:06:58',NULL),('2025-10-01 17:06:59.019887',NULL,'2025-10-01 17:06:59.092014',727,727,'fcbf8552ba484efaa8cae2712992af80','b0fe62bf-1df4-44a7-8c4f-a0b8ea095cbd',201,'384850ddb88c4d3798b3a3d365973ad0','gigabytes',-1,'2025-10-02 17:06:58',NULL),('2025-10-01 17:06:59.058124',NULL,'2025-10-01 17:06:59.092014',728,728,NULL,'f49a1ccd-9540-4768-8c58-8d067f080cf8',210,'384850ddb88c4d3798b3a3d365973ad0','shares',-1,'2025-10-02 17:06:58','8478d453-a6b0-4b46-9199-1966caf8d4cf'),('2025-10-01 17:06:59.059213',NULL,'2025-10-01 17:06:59.092014',729,729,NULL,'60bc93a2-0f37-4105-a926-89581dffb94a',211,'384850ddb88c4d3798b3a3d365973ad0','gigabytes',-1,'2025-10-02 17:06:58','8478d453-a6b0-4b46-9199-1966caf8d4cf'),('2025-10-01 17:06:59.816939',NULL,'2025-10-01 17:06:59.845420',730,730,'38ae86a37a0b4939a6f90ce219165e47','66c86409-7bcf-4814-b5e8-ef4305a66bc9',212,'30cd3ce4e43d4122b839b6e5f4bf6511','share_networks',-1,'2025-10-02 17:06:59',NULL),('2025-10-01 17:07:00.797300',NULL,'2025-10-01 17:07:00.965804',731,731,'fdec41847e24465299bb1f75d3e480d2','d956dec4-ed86-43e1-ab0a-792e0a5c8c39',217,'7697ecff3b5f413c99a5ace837dd6970','snapshots',1,'2025-10-02 17:07:00',NULL),('2025-10-01 17:07:00.803262',NULL,'2025-10-01 17:07:00.965804',732,732,'fdec41847e24465299bb1f75d3e480d2','1765247e-c9ab-46e6-9594-1bdabd2ca605',218,'7697ecff3b5f413c99a5ace837dd6970','snapshot_gigabytes',1,'2025-10-02 17:07:00',NULL),('2025-10-01 17:07:00.866458',NULL,'2025-10-01 17:07:00.965804',733,733,NULL,'8fdabf41-c547-4c92-bf0c-6d96c9cfd9b9',219,'7697ecff3b5f413c99a5ace837dd6970','snapshots',1,'2025-10-02 17:07:00','5efa3b2a-601c-4ea8-9cf6-c5c76a3276c5'),('2025-10-01 17:07:00.868741',NULL,'2025-10-01 17:07:00.965804',734,734,NULL,'75ccb119-3006-4af7-9a75-10f94bdcbd9c',220,'7697ecff3b5f413c99a5ace837dd6970','snapshot_gigabytes',1,'2025-10-02 17:07:00','5efa3b2a-601c-4ea8-9cf6-c5c76a3276c5'),('2025-10-01 17:07:01.187709',NULL,'2025-10-01 17:07:01.278178',735,735,'fcbf8552ba484efaa8cae2712992af80','0a81a10c-665b-4da8-8714-be7cc1a2d15a',202,'384850ddb88c4d3798b3a3d365973ad0','shares',1,'2025-10-02 17:07:01',NULL),('2025-10-01 17:07:01.189010',NULL,'2025-10-01 17:07:01.278178',736,736,'fcbf8552ba484efaa8cae2712992af80','ed183781-45dc-4431-be59-361d04a54f52',201,'384850ddb88c4d3798b3a3d365973ad0','gigabytes',1,'2025-10-02 17:07:01',NULL),('2025-10-01 17:07:01.220193',NULL,'2025-10-01 17:07:01.278178',737,737,NULL,'c63521e2-0a87-4db3-b0b5-1e27124deb22',221,'384850ddb88c4d3798b3a3d365973ad0','shares',1,'2025-10-02 17:07:01','2e37e456-1985-407a-9e7d-7cfaa41f9bf5'),('2025-10-01 17:07:01.221175',NULL,'2025-10-01 17:07:01.278178',738,738,NULL,'523394e8-e928-4462-9bf6-d3ba21144c3d',222,'384850ddb88c4d3798b3a3d365973ad0','gigabytes',1,'2025-10-02 17:07:01','2e37e456-1985-407a-9e7d-7cfaa41f9bf5'),('2025-10-01 17:07:01.304339',NULL,'2025-10-01 17:07:01.317368',739,739,'38ae86a37a0b4939a6f90ce219165e47','d3d89908-416c-496f-8305-86e2bca24635',212,'30cd3ce4e43d4122b839b6e5f4bf6511','share_networks',-1,'2025-10-02 17:07:01',NULL),('2025-10-01 17:07:04.782628',NULL,'2025-10-01 17:07:05.225424',740,740,'fcbf8552ba484efaa8cae2712992af80','9d09111a-99f4-48ec-ae21-aa748d1904a1',205,'384850ddb88c4d3798b3a3d365973ad0','snapshots',1,'2025-10-02 17:07:04',NULL),('2025-10-01 17:07:04.783789',NULL,'2025-10-01 17:07:05.225424',741,741,'fcbf8552ba484efaa8cae2712992af80','f6657a9f-990d-4332-85cb-a50ba4fd01b5',206,'384850ddb88c4d3798b3a3d365973ad0','snapshot_gigabytes',1,'2025-10-02 17:07:04',NULL),('2025-10-01 17:07:04.936592',NULL,'2025-10-01 17:07:05.225424',742,742,NULL,'1c002609-1728-4e44-966e-2bd04febc753',223,'384850ddb88c4d3798b3a3d365973ad0','snapshots',1,'2025-10-02 17:07:04','2e37e456-1985-407a-9e7d-7cfaa41f9bf5'),('2025-10-01 17:07:04.937646',NULL,'2025-10-01 17:07:05.225424',743,743,NULL,'abd0f77b-1d8c-4472-b752-437df6f2ccc4',224,'384850ddb88c4d3798b3a3d365973ad0','snapshot_gigabytes',1,'2025-10-02 17:07:04','2e37e456-1985-407a-9e7d-7cfaa41f9bf5'),('2025-10-01 17:07:08.821391',NULL,'2025-10-01 17:07:08.844276',744,744,'fdec41847e24465299bb1f75d3e480d2','3b0e906c-d21e-4c4e-a520-82d0d36a297f',217,'7697ecff3b5f413c99a5ace837dd6970','snapshots',-1,'2025-10-02 17:07:08',NULL),('2025-10-01 17:07:08.822984',NULL,'2025-10-01 17:07:08.844276',745,745,'fdec41847e24465299bb1f75d3e480d2','d826d24f-af47-492e-8661-48bbf90d26d7',218,'7697ecff3b5f413c99a5ace837dd6970','snapshot_gigabytes',-1,'2025-10-02 17:07:08',NULL),('2025-10-01 17:07:08.829177',NULL,'2025-10-01 17:07:08.844276',746,746,NULL,'94b30c90-a313-42a6-8af8-ff5f01931ace',219,'7697ecff3b5f413c99a5ace837dd6970','snapshots',-1,'2025-10-02 17:07:08','5efa3b2a-601c-4ea8-9cf6-c5c76a3276c5'),('2025-10-01 17:07:08.829867',NULL,'2025-10-01 17:07:08.844276',747,747,NULL,'2e688242-a2e7-4885-bc08-3b762363807f',220,'7697ecff3b5f413c99a5ace837dd6970','snapshot_gigabytes',-1,'2025-10-02 17:07:08','5efa3b2a-601c-4ea8-9cf6-c5c76a3276c5'),('2025-10-01 17:07:08.925706',NULL,'2025-10-01 17:07:08.956437',748,748,'fcbf8552ba484efaa8cae2712992af80','4569aadb-acc0-4bbf-b2c9-e87601a588a8',202,'384850ddb88c4d3798b3a3d365973ad0','shares',1,'2025-10-02 17:07:08',NULL),('2025-10-01 17:07:08.926908',NULL,'2025-10-01 17:07:08.956437',749,749,'fcbf8552ba484efaa8cae2712992af80','663506e6-1e77-4569-bb4e-ce33ec2c2ee3',201,'384850ddb88c4d3798b3a3d365973ad0','gigabytes',1,'2025-10-02 17:07:08',NULL),('2025-10-01 17:07:08.932711',NULL,'2025-10-01 17:07:08.956437',750,750,NULL,'849b9b17-82fa-4917-97fa-f54af61daab1',221,'384850ddb88c4d3798b3a3d365973ad0','shares',1,'2025-10-02 17:07:08','2e37e456-1985-407a-9e7d-7cfaa41f9bf5'),('2025-10-01 17:07:08.933835',NULL,'2025-10-01 17:07:08.956437',751,751,NULL,'3d0ac481-e11b-4421-afdb-a7c7d2fa2ef8',222,'384850ddb88c4d3798b3a3d365973ad0','gigabytes',1,'2025-10-02 17:07:08','2e37e456-1985-407a-9e7d-7cfaa41f9bf5'),('2025-10-01 17:07:12.472947',NULL,'2025-10-01 17:07:12.501108',752,752,'fdec41847e24465299bb1f75d3e480d2','dc9f1d98-d772-423c-ad4f-260bc94af87c',213,'7697ecff3b5f413c99a5ace837dd6970','shares',-1,'2025-10-02 17:07:12',NULL),('2025-10-01 17:07:12.473783',NULL,'2025-10-01 17:07:12.501108',753,753,'fdec41847e24465299bb1f75d3e480d2','c1c2c920-4cc2-4f12-9c7f-bc3f6e4dbe1f',214,'7697ecff3b5f413c99a5ace837dd6970','gigabytes',-1,'2025-10-02 17:07:12',NULL),('2025-10-01 17:07:12.485950',NULL,'2025-10-01 17:07:12.501108',754,754,NULL,'99258148-433c-42c4-9fb4-65dc1e55534f',215,'7697ecff3b5f413c99a5ace837dd6970','shares',-1,'2025-10-02 17:07:12','5efa3b2a-601c-4ea8-9cf6-c5c76a3276c5'),('2025-10-01 17:07:12.486766',NULL,'2025-10-01 17:07:12.501108',755,755,NULL,'cfd5945c-39dc-4502-a122-e1f4ef06b1d4',216,'7697ecff3b5f413c99a5ace837dd6970','gigabytes',-1,'2025-10-02 17:07:12','5efa3b2a-601c-4ea8-9cf6-c5c76a3276c5'),('2025-10-01 17:07:26.744267',NULL,'2025-10-01 17:07:26.786215',756,756,'8395fbe4aa1a4d9bb181f7e321703f61','25a61fb8-7139-48d3-8294-37b4f9c22963',226,'f63de858e3a74f88a78eaacea59850c5','shares',1,'2025-10-02 17:07:26',NULL),('2025-10-01 17:07:26.745353',NULL,'2025-10-01 17:07:26.786215',757,757,'8395fbe4aa1a4d9bb181f7e321703f61','593eab9d-2c9a-4fe2-9de1-be5fc6da3c18',225,'f63de858e3a74f88a78eaacea59850c5','gigabytes',1,'2025-10-02 17:07:26',NULL),('2025-10-01 17:07:26.757475',NULL,'2025-10-01 17:07:26.786215',758,758,NULL,'4435da24-6ce0-4a16-9afc-327a515ae5f3',228,'f63de858e3a74f88a78eaacea59850c5','shares',1,'2025-10-02 17:07:26','955aef9f-9d20-4cc2-94d6-c8222f9248a9'),('2025-10-01 17:07:26.758747',NULL,'2025-10-01 17:07:26.786215',759,759,NULL,'90d79881-8fe5-47c8-8380-403eb7ad5a52',227,'f63de858e3a74f88a78eaacea59850c5','gigabytes',1,'2025-10-02 17:07:26','955aef9f-9d20-4cc2-94d6-c8222f9248a9'),('2025-10-01 17:07:30.520806',NULL,'2025-10-01 17:07:30.752169',760,760,'8395fbe4aa1a4d9bb181f7e321703f61','a42c3cf2-9ac5-4c7d-85d1-eacf8100458d',226,'f63de858e3a74f88a78eaacea59850c5','shares',1,'2025-10-02 17:07:30',NULL),('2025-10-01 17:07:30.521935',NULL,'2025-10-01 17:07:30.752169',761,761,'8395fbe4aa1a4d9bb181f7e321703f61','0c0653bc-7548-4814-bcd3-a8f1e247c09a',225,'f63de858e3a74f88a78eaacea59850c5','gigabytes',1,'2025-10-02 17:07:30',NULL),('2025-10-01 17:07:30.559860',NULL,'2025-10-01 17:07:30.752169',762,762,NULL,'f38b7302-aa24-4354-a143-47f314718fe4',228,'f63de858e3a74f88a78eaacea59850c5','shares',1,'2025-10-02 17:07:30','955aef9f-9d20-4cc2-94d6-c8222f9248a9'),('2025-10-01 17:07:30.561568',NULL,'2025-10-01 17:07:30.752169',763,763,NULL,'931af0b5-9747-458f-b6a1-4fe72a048433',227,'f63de858e3a74f88a78eaacea59850c5','gigabytes',1,'2025-10-02 17:07:30','955aef9f-9d20-4cc2-94d6-c8222f9248a9'),('2025-10-01 17:07:32.391559',NULL,'2025-10-01 17:07:32.694311',764,764,'e660ba5c7b304e2abc80f9b99bdd51af','befd21f8-6920-4e4e-8b53-759f214dca09',230,'29266081bf264ee18aad20d4882a428c','shares',1,'2025-10-02 17:07:32',NULL),('2025-10-01 17:07:32.392957',NULL,'2025-10-01 17:07:32.694311',765,765,'e660ba5c7b304e2abc80f9b99bdd51af','fb169c3c-e69e-4816-9e5f-6f5a30452314',229,'29266081bf264ee18aad20d4882a428c','gigabytes',1,'2025-10-02 17:07:32',NULL),('2025-10-01 17:07:32.419955',NULL,'2025-10-01 17:07:32.694311',766,766,NULL,'00d1642d-2b62-412b-b062-88af12b7aacb',232,'29266081bf264ee18aad20d4882a428c','shares',1,'2025-10-02 17:07:32','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:07:32.421196',NULL,'2025-10-01 17:07:32.694311',767,767,NULL,'5aac8ee2-660b-4f3f-bccb-91293b288f3a',231,'29266081bf264ee18aad20d4882a428c','gigabytes',1,'2025-10-02 17:07:32','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:07:34.833329',NULL,'2025-10-01 17:07:34.888887',768,768,'8395fbe4aa1a4d9bb181f7e321703f61','573451bd-6f30-4c7c-9407-d45ba457b46e',226,'f63de858e3a74f88a78eaacea59850c5','shares',-1,'2025-10-02 17:07:34',NULL),('2025-10-01 17:07:34.834146',NULL,'2025-10-01 17:07:34.888887',769,769,'8395fbe4aa1a4d9bb181f7e321703f61','f1e61a72-cffb-4b68-9bfa-e5a288f5912b',225,'f63de858e3a74f88a78eaacea59850c5','gigabytes',-1,'2025-10-02 17:07:34',NULL),('2025-10-01 17:07:34.872596',NULL,'2025-10-01 17:07:34.888887',770,770,NULL,'e68b8deb-4409-4fe7-83fb-b109d0e75a07',228,'f63de858e3a74f88a78eaacea59850c5','shares',-1,'2025-10-02 17:07:34','955aef9f-9d20-4cc2-94d6-c8222f9248a9'),('2025-10-01 17:07:34.873720',NULL,'2025-10-01 17:07:34.888887',771,771,NULL,'b5a652fa-114e-4db3-a183-d28c832c7b7a',227,'f63de858e3a74f88a78eaacea59850c5','gigabytes',-1,'2025-10-02 17:07:34','955aef9f-9d20-4cc2-94d6-c8222f9248a9'),('2025-10-01 17:07:36.222119',NULL,'2025-10-01 17:07:36.707661',772,772,'e660ba5c7b304e2abc80f9b99bdd51af','01d52e7f-9859-4222-b463-61017019e206',233,'29266081bf264ee18aad20d4882a428c','snapshots',1,'2025-10-02 17:07:36',NULL),('2025-10-01 17:07:36.223507',NULL,'2025-10-01 17:07:36.707661',773,773,'e660ba5c7b304e2abc80f9b99bdd51af','cb0833ba-7055-4180-b222-d7b541d28de7',234,'29266081bf264ee18aad20d4882a428c','snapshot_gigabytes',1,'2025-10-02 17:07:36',NULL),('2025-10-01 17:07:36.269196',NULL,'2025-10-01 17:07:36.707661',774,774,NULL,'8b5202ea-adbd-4576-848b-1384dc0b0340',235,'29266081bf264ee18aad20d4882a428c','snapshots',1,'2025-10-02 17:07:36','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:07:36.270624',NULL,'2025-10-01 17:07:36.707661',775,775,NULL,'90cb28a3-b8ac-4b07-ba71-6450b136e580',236,'29266081bf264ee18aad20d4882a428c','snapshot_gigabytes',1,'2025-10-02 17:07:36','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:07:38.111589',NULL,'2025-10-01 17:07:38.257927',776,776,'8395fbe4aa1a4d9bb181f7e321703f61','11b50c7c-08e2-4cad-b2c3-e7eaa6ad63a4',226,'f63de858e3a74f88a78eaacea59850c5','shares',-1,'2025-10-02 17:07:38',NULL),('2025-10-01 17:07:38.198283',NULL,'2025-10-01 17:07:38.257927',777,777,'8395fbe4aa1a4d9bb181f7e321703f61','ca9536f6-5da9-4840-add8-da4bcc9cd10f',225,'f63de858e3a74f88a78eaacea59850c5','gigabytes',-1,'2025-10-02 17:07:38',NULL),('2025-10-01 17:07:38.214801',NULL,'2025-10-01 17:07:38.257927',778,778,NULL,'54a27329-a778-4845-b85a-208f31d9fb62',228,'f63de858e3a74f88a78eaacea59850c5','shares',-1,'2025-10-02 17:07:38','955aef9f-9d20-4cc2-94d6-c8222f9248a9'),('2025-10-01 17:07:38.215642',NULL,'2025-10-01 17:07:38.257927',779,779,NULL,'c5c5e4c2-7038-43d7-9274-47eace458af5',227,'f63de858e3a74f88a78eaacea59850c5','gigabytes',-1,'2025-10-02 17:07:38','955aef9f-9d20-4cc2-94d6-c8222f9248a9'),('2025-10-01 17:07:41.223371',NULL,'2025-10-01 17:07:41.247581',780,780,'8395fbe4aa1a4d9bb181f7e321703f61','ee6ce6df-bb60-4472-b719-079fc2ebca15',237,'f63de858e3a74f88a78eaacea59850c5','share_groups',1,'2025-10-02 17:07:41',NULL),('2025-10-01 17:07:41.391767',NULL,'2025-10-01 17:07:41.418739',781,781,'e660ba5c7b304e2abc80f9b99bdd51af','dc312fa0-0a1b-4186-83dc-825de378c6b9',230,'29266081bf264ee18aad20d4882a428c','shares',1,'2025-10-02 17:07:41',NULL),('2025-10-01 17:07:41.392964',NULL,'2025-10-01 17:07:41.418739',782,782,'e660ba5c7b304e2abc80f9b99bdd51af','a20e6ed0-63fe-4a39-87f5-f24a5ee19cb8',229,'29266081bf264ee18aad20d4882a428c','gigabytes',1,'2025-10-02 17:07:41',NULL),('2025-10-01 17:07:41.400850',NULL,'2025-10-01 17:07:41.418739',783,783,NULL,'e081502e-8dfd-4faf-a98a-9f1113647144',232,'29266081bf264ee18aad20d4882a428c','shares',1,'2025-10-02 17:07:41','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:07:41.401914',NULL,'2025-10-01 17:07:41.418739',784,784,NULL,'532251ac-4d31-4d0b-b610-fd972dfe3e67',231,'29266081bf264ee18aad20d4882a428c','gigabytes',1,'2025-10-02 17:07:41','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:07:44.592197',NULL,'2025-10-01 17:07:44.606247',785,785,'8395fbe4aa1a4d9bb181f7e321703f61','f118991e-16db-4f1a-beda-fd01caea524c',237,'f63de858e3a74f88a78eaacea59850c5','share_groups',-1,'2025-10-02 17:07:44',NULL),('2025-10-01 17:07:44.871175',NULL,'2025-10-01 17:07:44.902523',786,786,'8395fbe4aa1a4d9bb181f7e321703f61','fa34af21-1b01-4494-8b5d-2d44314fc440',237,'f63de858e3a74f88a78eaacea59850c5','share_groups',1,'2025-10-02 17:07:44',NULL),('2025-10-01 17:07:45.583445',NULL,'2025-10-01 17:07:45.604809',787,787,'e660ba5c7b304e2abc80f9b99bdd51af','6de1bcaf-2507-4a41-86a9-5e182f030fc6',230,'29266081bf264ee18aad20d4882a428c','shares',-1,'2025-10-02 17:07:45',NULL),('2025-10-01 17:07:45.584296',NULL,'2025-10-01 17:07:45.604809',788,788,'e660ba5c7b304e2abc80f9b99bdd51af','f27d67d2-c415-4317-87e9-e7dfd0abdbac',229,'29266081bf264ee18aad20d4882a428c','gigabytes',-1,'2025-10-02 17:07:45',NULL),('2025-10-01 17:07:45.590720',NULL,'2025-10-01 17:07:45.604809',789,789,NULL,'51d42086-ea87-47ea-9f7b-db1430971baf',232,'29266081bf264ee18aad20d4882a428c','shares',-1,'2025-10-02 17:07:45','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:07:45.591644',NULL,'2025-10-01 17:07:45.604809',790,790,NULL,'cdaa9a96-d71f-4c67-8da4-435220679692',231,'29266081bf264ee18aad20d4882a428c','gigabytes',-1,'2025-10-02 17:07:45','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:07:48.239527',NULL,'2025-10-01 17:07:48.252470',791,791,'8395fbe4aa1a4d9bb181f7e321703f61','7633688a-5e3b-4271-982b-316f4fe97a34',237,'f63de858e3a74f88a78eaacea59850c5','share_groups',-1,'2025-10-02 17:07:48',NULL),('2025-10-01 17:07:48.532288',NULL,'2025-10-01 17:07:48.564996',792,792,'8395fbe4aa1a4d9bb181f7e321703f61','bd8bff37-0006-4801-b042-a46caf375b72',226,'f63de858e3a74f88a78eaacea59850c5','shares',1,'2025-10-02 17:07:48',NULL),('2025-10-01 17:07:48.533476',NULL,'2025-10-01 17:07:48.564996',793,793,'8395fbe4aa1a4d9bb181f7e321703f61','80533748-2695-4c2f-b90e-1ce462c22af8',225,'f63de858e3a74f88a78eaacea59850c5','gigabytes',1,'2025-10-02 17:07:48',NULL),('2025-10-01 17:07:48.540361',NULL,'2025-10-01 17:07:48.564996',794,794,NULL,'e4d4fd1c-9c62-4760-b16c-51e6dfdd9cb9',228,'f63de858e3a74f88a78eaacea59850c5','shares',1,'2025-10-02 17:07:48','955aef9f-9d20-4cc2-94d6-c8222f9248a9'),('2025-10-01 17:07:48.542008',NULL,'2025-10-01 17:07:48.564996',795,795,NULL,'8a917699-4bd4-43c5-a6b5-128d29a5b876',227,'f63de858e3a74f88a78eaacea59850c5','gigabytes',1,'2025-10-02 17:07:48','955aef9f-9d20-4cc2-94d6-c8222f9248a9'),('2025-10-01 17:07:49.006093',NULL,'2025-10-01 17:07:49.048437',796,796,'e660ba5c7b304e2abc80f9b99bdd51af','9ed057e8-8841-4c90-bbd6-4e22f71dfe2a',230,'29266081bf264ee18aad20d4882a428c','shares',1,'2025-10-02 17:07:48',NULL),('2025-10-01 17:07:49.016234',NULL,'2025-10-01 17:07:49.048437',797,797,'e660ba5c7b304e2abc80f9b99bdd51af','7336b82c-56d3-44ab-8f74-770275ae478a',229,'29266081bf264ee18aad20d4882a428c','gigabytes',2,'2025-10-02 17:07:48',NULL),('2025-10-01 17:07:49.024169',NULL,'2025-10-01 17:07:49.048437',798,798,NULL,'65aeb92a-e169-4dfe-ac43-4a50eaa6cf58',232,'29266081bf264ee18aad20d4882a428c','shares',1,'2025-10-02 17:07:48','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:07:49.025583',NULL,'2025-10-01 17:07:49.048437',799,799,NULL,'887af291-b612-41e8-aafa-87f614dfcbfd',231,'29266081bf264ee18aad20d4882a428c','gigabytes',2,'2025-10-02 17:07:48','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:07:52.686744',NULL,'2025-10-01 17:07:52.714533',800,800,'8395fbe4aa1a4d9bb181f7e321703f61','dfab7457-646e-4300-b44b-398b1c35b3ee',226,'f63de858e3a74f88a78eaacea59850c5','shares',-1,'2025-10-02 17:07:52',NULL),('2025-10-01 17:07:52.687635',NULL,'2025-10-01 17:07:52.714533',801,801,'8395fbe4aa1a4d9bb181f7e321703f61','bd29e990-d6f8-404b-94a2-bdbeac8a474a',225,'f63de858e3a74f88a78eaacea59850c5','gigabytes',-1,'2025-10-02 17:07:52',NULL),('2025-10-01 17:07:52.697026',NULL,'2025-10-01 17:07:52.714533',802,802,NULL,'f8ad7a50-d1d7-4030-9806-9d7a42481740',228,'f63de858e3a74f88a78eaacea59850c5','shares',-1,'2025-10-02 17:07:52','955aef9f-9d20-4cc2-94d6-c8222f9248a9'),('2025-10-01 17:07:52.698198',NULL,'2025-10-01 17:07:52.714533',803,803,NULL,'a5d8767f-be19-4a17-857c-94c45587e005',227,'f63de858e3a74f88a78eaacea59850c5','gigabytes',-1,'2025-10-02 17:07:52','955aef9f-9d20-4cc2-94d6-c8222f9248a9'),('2025-10-01 17:07:53.029293',NULL,'2025-10-01 17:07:53.052167',804,804,'e660ba5c7b304e2abc80f9b99bdd51af','59b01240-203b-4f4c-930e-ee4f1f2bf48d',230,'29266081bf264ee18aad20d4882a428c','shares',-1,'2025-10-02 17:07:53',NULL),('2025-10-01 17:07:53.030219',NULL,'2025-10-01 17:07:53.052167',805,805,'e660ba5c7b304e2abc80f9b99bdd51af','d54e9d42-3f02-4ff9-ac52-ae109d6db73e',229,'29266081bf264ee18aad20d4882a428c','gigabytes',-2,'2025-10-02 17:07:53',NULL),('2025-10-01 17:07:53.044347',NULL,'2025-10-01 17:07:53.052167',806,806,NULL,'644ee2d4-7540-4a8f-96e8-8a4c255f3ebc',232,'29266081bf264ee18aad20d4882a428c','shares',-1,'2025-10-02 17:07:53','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:07:53.045035',NULL,'2025-10-01 17:07:53.052167',807,807,NULL,'11f2460c-4b25-4133-8b2d-3f2475c9b9d4',231,'29266081bf264ee18aad20d4882a428c','gigabytes',-2,'2025-10-02 17:07:53','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:07:55.758140',NULL,'2025-10-01 17:07:55.819412',808,808,'8395fbe4aa1a4d9bb181f7e321703f61','6f86b705-c98b-48ed-93a1-55dd339360f6',226,'f63de858e3a74f88a78eaacea59850c5','shares',1,'2025-10-02 17:07:55',NULL),('2025-10-01 17:07:55.760153',NULL,'2025-10-01 17:07:55.819412',809,809,'8395fbe4aa1a4d9bb181f7e321703f61','5702d01a-28af-4976-b87a-c6e035bbdc8e',225,'f63de858e3a74f88a78eaacea59850c5','gigabytes',1,'2025-10-02 17:07:55',NULL),('2025-10-01 17:07:55.785201',NULL,'2025-10-01 17:07:55.819412',810,810,NULL,'ab1a16c3-f859-484d-a669-f3f958b75ae8',228,'f63de858e3a74f88a78eaacea59850c5','shares',1,'2025-10-02 17:07:55','955aef9f-9d20-4cc2-94d6-c8222f9248a9'),('2025-10-01 17:07:55.787801',NULL,'2025-10-01 17:07:55.819412',811,811,NULL,'5196d4e4-4ba6-4a16-be3f-0f155fafc07f',227,'f63de858e3a74f88a78eaacea59850c5','gigabytes',1,'2025-10-02 17:07:55','955aef9f-9d20-4cc2-94d6-c8222f9248a9'),('2025-10-01 17:07:56.218968',NULL,'2025-10-01 17:07:56.261540',812,812,'e660ba5c7b304e2abc80f9b99bdd51af','8d482636-9270-426f-9efb-4425d9d79f2e',230,'29266081bf264ee18aad20d4882a428c','shares',1,'2025-10-02 17:07:56',NULL),('2025-10-01 17:07:56.220295',NULL,'2025-10-01 17:07:56.261540',813,813,'e660ba5c7b304e2abc80f9b99bdd51af','77f309bb-bbe9-4492-b146-292844a03328',229,'29266081bf264ee18aad20d4882a428c','gigabytes',1,'2025-10-02 17:07:56',NULL),('2025-10-01 17:07:56.228369',NULL,'2025-10-01 17:07:56.261540',814,814,NULL,'522a47ac-b0e8-43b3-9169-69aa79b655db',232,'29266081bf264ee18aad20d4882a428c','shares',1,'2025-10-02 17:07:56','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:07:56.229719',NULL,'2025-10-01 17:07:56.261540',815,815,NULL,'853c7f41-ade6-4bcc-b2a4-d8b490750333',231,'29266081bf264ee18aad20d4882a428c','gigabytes',1,'2025-10-02 17:07:56','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:08:02.761772',NULL,'2025-10-01 17:08:02.890142',816,816,'8395fbe4aa1a4d9bb181f7e321703f61','cf640c0d-8930-4672-95dc-7f864fc0f6e4',226,'f63de858e3a74f88a78eaacea59850c5','shares',-1,'2025-10-02 17:08:02',NULL),('2025-10-01 17:08:02.762669',NULL,'2025-10-01 17:08:02.890142',817,817,'8395fbe4aa1a4d9bb181f7e321703f61','62edad5e-18ff-45f7-b632-6b8eb8135b04',225,'f63de858e3a74f88a78eaacea59850c5','gigabytes',-1,'2025-10-02 17:08:02',NULL),('2025-10-01 17:08:02.791040',NULL,'2025-10-01 17:08:02.890142',818,818,NULL,'5dd587fd-9413-49c5-b4e0-9093c472b67b',228,'f63de858e3a74f88a78eaacea59850c5','shares',-1,'2025-10-02 17:08:02','955aef9f-9d20-4cc2-94d6-c8222f9248a9'),('2025-10-01 17:08:02.792040',NULL,'2025-10-01 17:08:02.890142',819,819,NULL,'c5eeb70c-db4d-467a-a8ae-01aff838f023',227,'f63de858e3a74f88a78eaacea59850c5','gigabytes',-1,'2025-10-02 17:08:02','955aef9f-9d20-4cc2-94d6-c8222f9248a9'),('2025-10-01 17:08:03.349108',NULL,'2025-10-01 17:08:03.413712',820,820,'e660ba5c7b304e2abc80f9b99bdd51af','5d5595a8-f5ea-498b-bbf9-990b242cf598',230,'29266081bf264ee18aad20d4882a428c','shares',-1,'2025-10-02 17:08:03',NULL),('2025-10-01 17:08:03.349907',NULL,'2025-10-01 17:08:03.413712',821,821,'e660ba5c7b304e2abc80f9b99bdd51af','a448c25b-3d50-4497-8365-61e7b511f42d',229,'29266081bf264ee18aad20d4882a428c','gigabytes',-1,'2025-10-02 17:08:03',NULL),('2025-10-01 17:08:03.368139',NULL,'2025-10-01 17:08:03.413712',822,822,NULL,'cdff8fb6-43d8-406e-9c11-6b3168601319',232,'29266081bf264ee18aad20d4882a428c','shares',-1,'2025-10-02 17:08:03','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:08:03.369338',NULL,'2025-10-01 17:08:03.413712',823,823,NULL,'6557fb92-eb82-4e51-a0f8-fe2a03d19722',231,'29266081bf264ee18aad20d4882a428c','gigabytes',-1,'2025-10-02 17:08:03','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:08:03.484396',NULL,'2025-10-01 17:08:03.502528',824,824,'fcbf8552ba484efaa8cae2712992af80','9aefe030-a504-4a46-b6c6-69890d834f12',202,'384850ddb88c4d3798b3a3d365973ad0','shares',-1,'2025-10-02 17:08:03',NULL),('2025-10-01 17:08:03.485304',NULL,'2025-10-01 17:08:03.502528',825,825,'fcbf8552ba484efaa8cae2712992af80','bd88261d-ee83-4a09-bbd2-ffa7c975fe26',201,'384850ddb88c4d3798b3a3d365973ad0','gigabytes',-1,'2025-10-02 17:08:03',NULL),('2025-10-01 17:08:03.491193',NULL,'2025-10-01 17:08:03.502528',826,826,NULL,'23cb2574-b951-4927-b595-0332491acbbf',221,'384850ddb88c4d3798b3a3d365973ad0','shares',-1,'2025-10-02 17:08:03','2e37e456-1985-407a-9e7d-7cfaa41f9bf5'),('2025-10-01 17:08:03.492146',NULL,'2025-10-01 17:08:03.502528',827,827,NULL,'bdc00f8d-fd79-4655-a964-d69582bf5b3f',222,'384850ddb88c4d3798b3a3d365973ad0','gigabytes',-1,'2025-10-02 17:08:03','2e37e456-1985-407a-9e7d-7cfaa41f9bf5'),('2025-10-01 17:08:06.424721',NULL,'2025-10-01 17:08:06.462860',828,828,'e660ba5c7b304e2abc80f9b99bdd51af','2fc1f5c3-ecf3-4d01-a8d1-4a5996c45e91',230,'29266081bf264ee18aad20d4882a428c','shares',1,'2025-10-02 17:08:06',NULL),('2025-10-01 17:08:06.425803',NULL,'2025-10-01 17:08:06.462860',829,829,'e660ba5c7b304e2abc80f9b99bdd51af','b16c4d98-5209-4e00-8daa-8361c60a0fd5',229,'29266081bf264ee18aad20d4882a428c','gigabytes',1,'2025-10-02 17:08:06',NULL),('2025-10-01 17:08:06.432800',NULL,'2025-10-01 17:08:06.462860',830,830,NULL,'5d69e1a5-e3d7-4252-8fb8-9fd0180f3639',232,'29266081bf264ee18aad20d4882a428c','shares',1,'2025-10-02 17:08:06','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:08:06.434413',NULL,'2025-10-01 17:08:06.462860',831,831,NULL,'eed85f84-8779-4629-a4b6-3aa7fcd246aa',231,'29266081bf264ee18aad20d4882a428c','gigabytes',1,'2025-10-02 17:08:06','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:08:11.457317',NULL,'2025-10-01 17:08:11.472372',832,832,'fcbf8552ba484efaa8cae2712992af80','d0c54325-78f2-4b72-ac5e-639ba2c2278b',205,'384850ddb88c4d3798b3a3d365973ad0','snapshots',-1,'2025-10-02 17:08:11',NULL),('2025-10-01 17:08:11.458312',NULL,'2025-10-01 17:08:11.472372',833,833,'fcbf8552ba484efaa8cae2712992af80','d90c22d7-9b02-4ead-8554-606ea5307d39',206,'384850ddb88c4d3798b3a3d365973ad0','snapshot_gigabytes',-1,'2025-10-02 17:08:11',NULL),('2025-10-01 17:08:11.463436',NULL,'2025-10-01 17:08:11.472372',834,834,NULL,'74139515-3a38-41c5-b497-dce083350a38',223,'384850ddb88c4d3798b3a3d365973ad0','snapshots',-1,'2025-10-02 17:08:11','2e37e456-1985-407a-9e7d-7cfaa41f9bf5'),('2025-10-01 17:08:11.464309',NULL,'2025-10-01 17:08:11.472372',835,835,NULL,'891b9afd-9c0f-4b19-a041-c904a3d5783a',224,'384850ddb88c4d3798b3a3d365973ad0','snapshot_gigabytes',-1,'2025-10-02 17:08:11','2e37e456-1985-407a-9e7d-7cfaa41f9bf5'),('2025-10-01 17:08:13.700551',NULL,'2025-10-01 17:08:13.716288',836,836,'fcbf8552ba484efaa8cae2712992af80','b3bc97c0-8876-4d7d-9baa-584ea57da3be',202,'384850ddb88c4d3798b3a3d365973ad0','shares',-1,'2025-10-02 17:08:13',NULL),('2025-10-01 17:08:13.701380',NULL,'2025-10-01 17:08:13.716288',837,837,'fcbf8552ba484efaa8cae2712992af80','4b7b17a7-bbf2-4528-9257-e48864fed9e7',201,'384850ddb88c4d3798b3a3d365973ad0','gigabytes',-1,'2025-10-02 17:08:13',NULL),('2025-10-01 17:08:13.707548',NULL,'2025-10-01 17:08:13.716288',838,838,NULL,'96b9b919-1eec-4d10-924d-9f4fb4550af1',221,'384850ddb88c4d3798b3a3d365973ad0','shares',-1,'2025-10-02 17:08:13','2e37e456-1985-407a-9e7d-7cfaa41f9bf5'),('2025-10-01 17:08:13.708611',NULL,'2025-10-01 17:08:13.716288',839,839,NULL,'efe07de5-fee9-4587-a8bb-907e3b48664d',222,'384850ddb88c4d3798b3a3d365973ad0','gigabytes',-1,'2025-10-02 17:08:13','2e37e456-1985-407a-9e7d-7cfaa41f9bf5'),('2025-10-01 17:08:14.081174',NULL,'2025-10-01 17:08:14.095178',840,840,'e660ba5c7b304e2abc80f9b99bdd51af','c011ff38-5bed-4fe2-a32e-f1a08f9af426',230,'29266081bf264ee18aad20d4882a428c','shares',-1,'2025-10-02 17:08:14',NULL),('2025-10-01 17:08:14.082166',NULL,'2025-10-01 17:08:14.095178',841,841,'e660ba5c7b304e2abc80f9b99bdd51af','66f55b7d-b82b-4083-bfe2-7661ef5791cb',229,'29266081bf264ee18aad20d4882a428c','gigabytes',-1,'2025-10-02 17:08:14',NULL),('2025-10-01 17:08:14.087784',NULL,'2025-10-01 17:08:14.095178',842,842,NULL,'26d8fa55-64bc-4a8b-8b64-8117eb8290f1',232,'29266081bf264ee18aad20d4882a428c','shares',-1,'2025-10-02 17:08:14','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:08:14.088515',NULL,'2025-10-01 17:08:14.095178',843,843,NULL,'66c9e15e-2af9-4ac1-a212-8ac7b0a9325c',231,'29266081bf264ee18aad20d4882a428c','gigabytes',-1,'2025-10-02 17:08:14','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:08:17.151614',NULL,'2025-10-01 17:08:17.203130',844,844,'e660ba5c7b304e2abc80f9b99bdd51af','b3179225-95dd-4353-9449-8d0c67aeb8cc',230,'29266081bf264ee18aad20d4882a428c','shares',1,'2025-10-02 17:08:17',NULL),('2025-10-01 17:08:17.153183',NULL,'2025-10-01 17:08:17.203130',845,845,'e660ba5c7b304e2abc80f9b99bdd51af','32512b8f-10f1-42e6-8d6a-a2b2505d024d',229,'29266081bf264ee18aad20d4882a428c','gigabytes',1,'2025-10-02 17:08:17',NULL),('2025-10-01 17:08:17.162840',NULL,'2025-10-01 17:08:17.203130',846,846,NULL,'df37517f-24d9-4408-bfed-caaaea5f0720',232,'29266081bf264ee18aad20d4882a428c','shares',1,'2025-10-02 17:08:17','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:08:17.163889',NULL,'2025-10-01 17:08:17.203130',847,847,NULL,'ef3c5d22-1463-4767-b732-455e379304d1',231,'29266081bf264ee18aad20d4882a428c','gigabytes',1,'2025-10-02 17:08:17','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:08:21.495989',NULL,'2025-10-01 17:08:21.513684',848,848,'e660ba5c7b304e2abc80f9b99bdd51af','1e096f9a-9017-4206-a1bf-19fcbe37bfd0',230,'29266081bf264ee18aad20d4882a428c','shares',-1,'2025-10-02 17:08:21',NULL),('2025-10-01 17:08:21.496692',NULL,'2025-10-01 17:08:21.513684',849,849,'e660ba5c7b304e2abc80f9b99bdd51af','69646a6a-a6f8-40c1-9c2b-79a6a53915ac',229,'29266081bf264ee18aad20d4882a428c','gigabytes',-1,'2025-10-02 17:08:21',NULL),('2025-10-01 17:08:21.505036',NULL,'2025-10-01 17:08:21.513684',850,850,NULL,'0709acae-3b04-4b82-a27a-ce984621ab92',232,'29266081bf264ee18aad20d4882a428c','shares',-1,'2025-10-02 17:08:21','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:08:21.505876',NULL,'2025-10-01 17:08:21.513684',851,851,NULL,'2b76a63f-0b8a-412f-9dab-02065c44b59b',231,'29266081bf264ee18aad20d4882a428c','gigabytes',-1,'2025-10-02 17:08:21','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:08:26.310525',NULL,'2025-10-01 17:08:26.342412',852,852,'e660ba5c7b304e2abc80f9b99bdd51af','b20f4a6a-a26c-4af3-9125-49cca6f9df27',233,'29266081bf264ee18aad20d4882a428c','snapshots',-1,'2025-10-02 17:08:26',NULL),('2025-10-01 17:08:26.312142',NULL,'2025-10-01 17:08:26.342412',853,853,'e660ba5c7b304e2abc80f9b99bdd51af','531edcd7-dfab-4fb4-88ab-b14aa293afce',234,'29266081bf264ee18aad20d4882a428c','snapshot_gigabytes',-1,'2025-10-02 17:08:26',NULL),('2025-10-01 17:08:26.329816',NULL,'2025-10-01 17:08:26.342412',854,854,NULL,'9b984b85-0145-4d49-9b8a-9d57510f1d76',235,'29266081bf264ee18aad20d4882a428c','snapshots',-1,'2025-10-02 17:08:26','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:08:26.330798',NULL,'2025-10-01 17:08:26.342412',855,855,NULL,'8038936b-f54b-4b69-86dd-0dd696acf0b4',236,'29266081bf264ee18aad20d4882a428c','snapshot_gigabytes',-1,'2025-10-02 17:08:26','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:08:26.372025',NULL,'2025-10-01 17:08:26.403138',856,856,'c6801335b5594dc38e737626407c353c','cbae6b28-27d7-4870-b0b0-141bff862acb',238,'2d1156e4dd1a4bcf99d7af9680c3c563','shares',1,'2025-10-02 17:08:26',NULL),('2025-10-01 17:08:26.373241',NULL,'2025-10-01 17:08:26.403138',857,857,'c6801335b5594dc38e737626407c353c','4160c3c7-89c3-4d78-a9e9-c19b62e72af8',239,'2d1156e4dd1a4bcf99d7af9680c3c563','gigabytes',1,'2025-10-02 17:08:26',NULL),('2025-10-01 17:08:26.382978',NULL,'2025-10-01 17:08:26.403138',858,858,NULL,'5078b24b-bbba-4a88-aff7-cac34c1f18c5',240,'2d1156e4dd1a4bcf99d7af9680c3c563','shares',1,'2025-10-02 17:08:26','48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:08:26.383957',NULL,'2025-10-01 17:08:26.403138',859,859,NULL,'3013b26a-53c6-47e5-9f6c-14d02ed93e76',241,'2d1156e4dd1a4bcf99d7af9680c3c563','gigabytes',1,'2025-10-02 17:08:26','48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:08:30.137514',NULL,'2025-10-01 17:08:30.154012',860,860,'e660ba5c7b304e2abc80f9b99bdd51af','ad79d69d-fbda-4c7a-97ea-fce52f01a9d4',230,'29266081bf264ee18aad20d4882a428c','shares',-1,'2025-10-02 17:08:30',NULL),('2025-10-01 17:08:30.138325',NULL,'2025-10-01 17:08:30.154012',861,861,'e660ba5c7b304e2abc80f9b99bdd51af','7340e851-3759-4ea6-bb1f-cdb2d45adac0',229,'29266081bf264ee18aad20d4882a428c','gigabytes',-1,'2025-10-02 17:08:30',NULL),('2025-10-01 17:08:30.144989',NULL,'2025-10-01 17:08:30.154012',862,862,NULL,'e5c58c62-89e8-4de2-8186-add016b752eb',232,'29266081bf264ee18aad20d4882a428c','shares',-1,'2025-10-02 17:08:30','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:08:30.145714',NULL,'2025-10-01 17:08:30.154012',863,863,NULL,'c521c245-6dd1-48fc-9409-ce02ab93e489',231,'29266081bf264ee18aad20d4882a428c','gigabytes',-1,'2025-10-02 17:08:30','97f57594-d2cd-4ad0-b515-663008088086'),('2025-10-01 17:08:30.271339',NULL,'2025-10-01 17:08:30.365772',864,864,'c6801335b5594dc38e737626407c353c','800361ed-0778-437b-8284-223301fe7531',242,'2d1156e4dd1a4bcf99d7af9680c3c563','snapshots',1,'2025-10-02 17:08:30',NULL),('2025-10-01 17:08:30.272811',NULL,'2025-10-01 17:08:30.365772',865,865,'c6801335b5594dc38e737626407c353c','784a5498-7998-4048-b174-2c5a212afa55',243,'2d1156e4dd1a4bcf99d7af9680c3c563','snapshot_gigabytes',1,'2025-10-02 17:08:30',NULL),('2025-10-01 17:08:30.288884',NULL,'2025-10-01 17:08:30.365772',866,866,NULL,'4369bf39-0db3-48af-a4b4-d2eab3b4d2b1',244,'2d1156e4dd1a4bcf99d7af9680c3c563','snapshots',1,'2025-10-02 17:08:30','48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:08:30.290545',NULL,'2025-10-01 17:08:30.365772',867,867,NULL,'3aa3d0b4-57ed-48e0-8624-9110f085f27a',245,'2d1156e4dd1a4bcf99d7af9680c3c563','snapshot_gigabytes',1,'2025-10-02 17:08:30','48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:08:33.921580',NULL,'2025-10-01 17:08:34.913415',868,868,'c6801335b5594dc38e737626407c353c','af39631d-3511-4c86-b8dc-a9306b100724',238,'2d1156e4dd1a4bcf99d7af9680c3c563','shares',1,'2025-10-02 17:08:33',NULL),('2025-10-01 17:08:33.922716',NULL,'2025-10-01 17:08:34.913415',869,869,'c6801335b5594dc38e737626407c353c','6dccef21-1d0f-4a63-8d98-1cd94ed24bce',239,'2d1156e4dd1a4bcf99d7af9680c3c563','gigabytes',1,'2025-10-02 17:08:33',NULL),('2025-10-01 17:08:34.142607',NULL,'2025-10-01 17:08:34.913415',870,870,NULL,'c2d21700-1e53-4372-924b-b523dd976366',240,'2d1156e4dd1a4bcf99d7af9680c3c563','shares',1,'2025-10-02 17:08:33','48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:08:34.144193',NULL,'2025-10-01 17:08:34.913415',871,871,NULL,'08ebb28a-0174-4c58-b7e7-8571cf29ec7e',241,'2d1156e4dd1a4bcf99d7af9680c3c563','gigabytes',1,'2025-10-02 17:08:33','48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:08:43.098114',NULL,'2025-10-01 17:08:43.138254',872,872,'1bcf3990c34341488ff134d67569a00c','c8fcc53d-38d0-4053-97af-a43c873efc6b',246,'a942627ec05749c09a975132ee6031d6','shares',1,'2025-10-02 17:08:43',NULL),('2025-10-01 17:08:43.099229',NULL,'2025-10-01 17:08:43.138254',873,873,'1bcf3990c34341488ff134d67569a00c','62115566-a817-4949-a077-927f0c68b08c',247,'a942627ec05749c09a975132ee6031d6','gigabytes',2,'2025-10-02 17:08:43',NULL),('2025-10-01 17:08:43.109868',NULL,'2025-10-01 17:08:43.138254',874,874,NULL,'cc1ac2e6-c20b-40fc-8567-7a7b65f0c817',248,'a942627ec05749c09a975132ee6031d6','shares',1,'2025-10-02 17:08:43','5207f340-b3fd-4fd8-95e5-1228cababcc3'),('2025-10-01 17:08:43.111911',NULL,'2025-10-01 17:08:43.138254',875,875,NULL,'f03b3e26-c732-4961-94ca-d4d1536c5acf',249,'a942627ec05749c09a975132ee6031d6','gigabytes',2,'2025-10-02 17:08:43','5207f340-b3fd-4fd8-95e5-1228cababcc3'),('2025-10-01 17:08:55.808987',NULL,'2025-10-01 17:08:55.991523',876,876,'1bcf3990c34341488ff134d67569a00c','d6d9f9ab-a1f8-460e-b92a-bd3dec1174f9',251,'a942627ec05749c09a975132ee6031d6','snapshots',1,'2025-10-02 17:08:55',NULL),('2025-10-01 17:08:55.810070',NULL,'2025-10-01 17:08:55.991523',877,877,'1bcf3990c34341488ff134d67569a00c','0db0450c-aa78-4ed6-9253-90791c8ab3cf',250,'a942627ec05749c09a975132ee6031d6','snapshot_gigabytes',2,'2025-10-02 17:08:55',NULL),('2025-10-01 17:08:55.863599',NULL,'2025-10-01 17:08:55.991523',878,878,NULL,'dba40173-0519-43ba-9cde-d493b6bc94a7',253,'a942627ec05749c09a975132ee6031d6','snapshots',1,'2025-10-02 17:08:55','5207f340-b3fd-4fd8-95e5-1228cababcc3'),('2025-10-01 17:08:55.864612',NULL,'2025-10-01 17:08:55.991523',879,879,NULL,'63eaf671-bf82-4914-8bf8-a62b6d3cbc8e',252,'a942627ec05749c09a975132ee6031d6','snapshot_gigabytes',2,'2025-10-02 17:08:55','5207f340-b3fd-4fd8-95e5-1228cababcc3'),('2025-10-01 17:08:57.178636',NULL,'2025-10-01 17:08:57.256477',880,880,'c6801335b5594dc38e737626407c353c','9718d714-8d9d-4212-921e-67dff958b5eb',238,'2d1156e4dd1a4bcf99d7af9680c3c563','shares',1,'2025-10-02 17:08:57',NULL),('2025-10-01 17:08:57.180333',NULL,'2025-10-01 17:08:57.256477',881,881,'c6801335b5594dc38e737626407c353c','e0a50c03-2913-4f14-bea7-8a10515427d0',239,'2d1156e4dd1a4bcf99d7af9680c3c563','gigabytes',1,'2025-10-02 17:08:57',NULL),('2025-10-01 17:08:57.207864',NULL,'2025-10-01 17:08:57.256477',882,882,NULL,'20a36009-254c-4a9b-874d-e751f822ad6f',240,'2d1156e4dd1a4bcf99d7af9680c3c563','shares',1,'2025-10-02 17:08:57','48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:08:57.209456',NULL,'2025-10-01 17:08:57.256477',883,883,NULL,'aee574e4-51b7-480b-9d80-bf3963c51e33',241,'2d1156e4dd1a4bcf99d7af9680c3c563','gigabytes',1,'2025-10-02 17:08:57','48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:09:00.551775',NULL,'2025-10-01 17:09:04.147748',884,884,'c6801335b5594dc38e737626407c353c','d5642413-f217-42da-9163-1f97145fb719',239,'2d1156e4dd1a4bcf99d7af9680c3c563','gigabytes',1,'2025-10-02 17:09:00',NULL),('2025-10-01 17:09:00.560682',NULL,'2025-10-01 17:09:04.147748',885,885,NULL,'c10d7109-ec2b-4b3a-af94-50620de69195',241,'2d1156e4dd1a4bcf99d7af9680c3c563','gigabytes',1,'2025-10-02 17:09:00','48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:09:04.175358',NULL,'2025-10-01 17:09:04.191528',886,886,'1bcf3990c34341488ff134d67569a00c','43fb9eee-cfdf-4563-8b9c-f29ab1b0d4bc',251,'a942627ec05749c09a975132ee6031d6','snapshots',-1,'2025-10-02 17:09:03',NULL),('2025-10-01 17:09:04.176616',NULL,'2025-10-01 17:09:04.191528',887,887,'1bcf3990c34341488ff134d67569a00c','7bab8302-edce-4277-8ddc-ed87602f89cf',250,'a942627ec05749c09a975132ee6031d6','snapshot_gigabytes',-2,'2025-10-02 17:09:03',NULL),('2025-10-01 17:09:04.181331',NULL,'2025-10-01 17:09:04.191528',888,888,NULL,'c476d89d-37a2-4d29-b295-bea3376807db',253,'a942627ec05749c09a975132ee6031d6','snapshots',-1,'2025-10-02 17:09:03','5207f340-b3fd-4fd8-95e5-1228cababcc3'),('2025-10-01 17:09:04.181976',NULL,'2025-10-01 17:09:04.191528',889,889,NULL,'590a5ae8-4072-4a41-ba5e-43ada13b06e1',252,'a942627ec05749c09a975132ee6031d6','snapshot_gigabytes',-2,'2025-10-02 17:09:03','5207f340-b3fd-4fd8-95e5-1228cababcc3'),('2025-10-01 17:09:06.214102',NULL,'2025-10-01 17:09:06.232446',890,890,'1bcf3990c34341488ff134d67569a00c','3bdfff4a-ddf6-4051-a3b9-f65bc355b1fd',246,'a942627ec05749c09a975132ee6031d6','shares',-1,'2025-10-02 17:09:06',NULL),('2025-10-01 17:09:06.214835',NULL,'2025-10-01 17:09:06.232446',891,891,'1bcf3990c34341488ff134d67569a00c','f4b8ad4f-5bfd-426b-a072-b12fccdba38a',247,'a942627ec05749c09a975132ee6031d6','gigabytes',-2,'2025-10-02 17:09:06',NULL),('2025-10-01 17:09:06.220053',NULL,'2025-10-01 17:09:06.232446',892,892,NULL,'15561bc6-20fb-45d0-b71d-ddf7bbfdfa7c',248,'a942627ec05749c09a975132ee6031d6','shares',-1,'2025-10-02 17:09:06','5207f340-b3fd-4fd8-95e5-1228cababcc3'),('2025-10-01 17:09:06.220761',NULL,'2025-10-01 17:09:06.232446',893,893,NULL,'714ba169-3f70-4e07-af53-5d631bc2e2e5',249,'a942627ec05749c09a975132ee6031d6','gigabytes',-2,'2025-10-02 17:09:06','5207f340-b3fd-4fd8-95e5-1228cababcc3'),('2025-10-01 17:09:07.541814',NULL,'2025-10-01 17:09:07.568592',894,894,'c6801335b5594dc38e737626407c353c','ce87ef6f-82a7-4257-8f0b-b28dc8699ffb',238,'2d1156e4dd1a4bcf99d7af9680c3c563','shares',-1,'2025-10-02 17:09:07',NULL),('2025-10-01 17:09:07.544385',NULL,'2025-10-01 17:09:07.568592',895,895,'c6801335b5594dc38e737626407c353c','f99e8639-bfd0-43d6-bb26-77118ab404ea',239,'2d1156e4dd1a4bcf99d7af9680c3c563','gigabytes',-2,'2025-10-02 17:09:07',NULL),('2025-10-01 17:09:07.556211',NULL,'2025-10-01 17:09:07.568592',896,896,NULL,'4c593f4b-ecff-4fa9-9fd1-5f1acbc2168b',240,'2d1156e4dd1a4bcf99d7af9680c3c563','shares',-1,'2025-10-02 17:09:07','48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:09:07.557216',NULL,'2025-10-01 17:09:07.568592',897,897,NULL,'a2fe8176-e48c-4bd1-bcf6-a599322d9224',241,'2d1156e4dd1a4bcf99d7af9680c3c563','gigabytes',-2,'2025-10-02 17:09:07','48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:09:09.318937',NULL,'2025-10-01 17:09:09.369625',898,898,'1bcf3990c34341488ff134d67569a00c','6f26790f-4331-4d5b-988c-d5f5efdfa581',246,'a942627ec05749c09a975132ee6031d6','shares',1,'2025-10-02 17:09:09',NULL),('2025-10-01 17:09:09.320526',NULL,'2025-10-01 17:09:09.369625',899,899,'1bcf3990c34341488ff134d67569a00c','2cadbdc2-b128-40cd-829a-c994cf07f24e',247,'a942627ec05749c09a975132ee6031d6','gigabytes',1,'2025-10-02 17:09:09',NULL),('2025-10-01 17:09:09.329466',NULL,'2025-10-01 17:09:09.369625',900,900,NULL,'92727ae5-cf5c-4c43-ae60-60695beaed65',248,'a942627ec05749c09a975132ee6031d6','shares',1,'2025-10-02 17:09:09','5207f340-b3fd-4fd8-95e5-1228cababcc3'),('2025-10-01 17:09:09.331081',NULL,'2025-10-01 17:09:09.369625',901,901,NULL,'cae000e6-355e-422b-a9bc-8914c7b77972',249,'a942627ec05749c09a975132ee6031d6','gigabytes',1,'2025-10-02 17:09:09','5207f340-b3fd-4fd8-95e5-1228cababcc3'),('2025-10-01 17:09:12.777309',NULL,'2025-10-01 17:09:12.878446',902,902,'1bcf3990c34341488ff134d67569a00c','ba544731-8be7-44d1-ae65-5b013b948580',251,'a942627ec05749c09a975132ee6031d6','snapshots',1,'2025-10-02 17:09:12',NULL),('2025-10-01 17:09:12.780369',NULL,'2025-10-01 17:09:12.878446',903,903,'1bcf3990c34341488ff134d67569a00c','72ab2e24-7fac-462d-820d-dfb6f7696650',250,'a942627ec05749c09a975132ee6031d6','snapshot_gigabytes',1,'2025-10-02 17:09:12',NULL),('2025-10-01 17:09:12.792977',NULL,'2025-10-01 17:09:12.878446',904,904,NULL,'8330a498-e480-40db-9ff6-8e3dc7aafd9a',253,'a942627ec05749c09a975132ee6031d6','snapshots',1,'2025-10-02 17:09:12','5207f340-b3fd-4fd8-95e5-1228cababcc3'),('2025-10-01 17:09:12.794753',NULL,'2025-10-01 17:09:12.878446',905,905,NULL,'25dca7f1-23c5-49cf-a6db-f30e3715a37b',252,'a942627ec05749c09a975132ee6031d6','snapshot_gigabytes',1,'2025-10-02 17:09:12','5207f340-b3fd-4fd8-95e5-1228cababcc3'),('2025-10-01 17:09:14.381887',NULL,'2025-10-01 17:09:14.426666',906,906,'c6801335b5594dc38e737626407c353c','8923a74a-4d1b-454c-9500-7911d1c83d97',238,'2d1156e4dd1a4bcf99d7af9680c3c563','shares',1,'2025-10-02 17:09:14',NULL),('2025-10-01 17:09:14.383858',NULL,'2025-10-01 17:09:14.426666',907,907,'c6801335b5594dc38e737626407c353c','6f7c33f7-9412-4eb1-99ad-7287f3ae9fa2',239,'2d1156e4dd1a4bcf99d7af9680c3c563','gigabytes',2,'2025-10-02 17:09:14',NULL),('2025-10-01 17:09:14.394669',NULL,'2025-10-01 17:09:14.426666',908,908,NULL,'c638e3ed-07d8-4167-bec1-edd14e01a21f',240,'2d1156e4dd1a4bcf99d7af9680c3c563','shares',1,'2025-10-02 17:09:14','48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:09:14.396191',NULL,'2025-10-01 17:09:14.426666',909,909,NULL,'af47e3fe-963f-43cb-a323-6c9d72bdd188',241,'2d1156e4dd1a4bcf99d7af9680c3c563','gigabytes',2,'2025-10-02 17:09:14','48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:09:21.459102',NULL,'2025-10-01 17:09:21.478474',910,910,'1bcf3990c34341488ff134d67569a00c','4f5fb6c7-e25a-4133-92ff-b5c441665f93',251,'a942627ec05749c09a975132ee6031d6','snapshots',-1,'2025-10-02 17:09:21',NULL),('2025-10-01 17:09:21.460107',NULL,'2025-10-01 17:09:21.478474',911,911,'1bcf3990c34341488ff134d67569a00c','87061cda-69ee-44a4-adb0-2f72b6d02108',250,'a942627ec05749c09a975132ee6031d6','snapshot_gigabytes',-1,'2025-10-02 17:09:21',NULL),('2025-10-01 17:09:21.466859',NULL,'2025-10-01 17:09:21.478474',912,912,NULL,'a0822abf-011c-4b64-bcc9-aaabba444dab',253,'a942627ec05749c09a975132ee6031d6','snapshots',-1,'2025-10-02 17:09:21','5207f340-b3fd-4fd8-95e5-1228cababcc3'),('2025-10-01 17:09:21.468223',NULL,'2025-10-01 17:09:21.478474',913,913,NULL,'a19ce917-12dd-49ec-b88d-3abe794ac11c',252,'a942627ec05749c09a975132ee6031d6','snapshot_gigabytes',-1,'2025-10-02 17:09:21','5207f340-b3fd-4fd8-95e5-1228cababcc3'),('2025-10-01 17:09:24.191375',NULL,'2025-10-01 17:09:25.449692',914,914,'c6801335b5594dc38e737626407c353c','25bd094a-383c-45b2-921f-9c7558917520',239,'2d1156e4dd1a4bcf99d7af9680c3c563','gigabytes',-1,'2025-10-02 17:09:24',NULL),('2025-10-01 17:09:24.206889',NULL,'2025-10-01 17:09:25.449692',915,915,NULL,'d6dd766c-e734-48c6-82b1-a94da3145b74',241,'2d1156e4dd1a4bcf99d7af9680c3c563','gigabytes',-1,'2025-10-02 17:09:24','48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:09:25.499447',NULL,'2025-10-01 17:09:25.527979',916,916,'1bcf3990c34341488ff134d67569a00c','67fa802f-9b10-4d24-9a10-301aa363596b',246,'a942627ec05749c09a975132ee6031d6','shares',-1,'2025-10-02 17:09:24',NULL),('2025-10-01 17:09:25.501907',NULL,'2025-10-01 17:09:25.527979',917,917,'1bcf3990c34341488ff134d67569a00c','7519931b-d38c-4e85-81f7-5b54ec8676af',247,'a942627ec05749c09a975132ee6031d6','gigabytes',-1,'2025-10-02 17:09:24',NULL),('2025-10-01 17:09:25.511836',NULL,'2025-10-01 17:09:25.527979',918,918,NULL,'b6193b8d-abb3-4d89-9e0f-5d8d5110767b',248,'a942627ec05749c09a975132ee6031d6','shares',-1,'2025-10-02 17:09:24','5207f340-b3fd-4fd8-95e5-1228cababcc3'),('2025-10-01 17:09:25.513146',NULL,'2025-10-01 17:09:25.527979',919,919,NULL,'51d4cf3a-997a-400b-be75-b8192772129c',249,'a942627ec05749c09a975132ee6031d6','gigabytes',-1,'2025-10-02 17:09:24','5207f340-b3fd-4fd8-95e5-1228cababcc3'),('2025-10-01 17:09:27.789857',NULL,'2025-10-01 17:09:27.805955',920,920,'c6801335b5594dc38e737626407c353c','67b09151-d895-4721-ae3f-b8ecc9847012',238,'2d1156e4dd1a4bcf99d7af9680c3c563','shares',-1,'2025-10-02 17:09:27',NULL),('2025-10-01 17:09:27.790768',NULL,'2025-10-01 17:09:27.805955',921,921,'c6801335b5594dc38e737626407c353c','f001ff9f-55f2-4be7-a86f-1cd25be4ba49',239,'2d1156e4dd1a4bcf99d7af9680c3c563','gigabytes',-1,'2025-10-02 17:09:27',NULL),('2025-10-01 17:09:27.797058',NULL,'2025-10-01 17:09:27.805955',922,922,NULL,'ae2f46b1-9b2d-4bfd-9d3d-1587ecbb0b19',240,'2d1156e4dd1a4bcf99d7af9680c3c563','shares',-1,'2025-10-02 17:09:27','48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:09:27.797878',NULL,'2025-10-01 17:09:27.805955',923,923,NULL,'b9297db6-83d2-4704-87b5-8acb9277d28f',241,'2d1156e4dd1a4bcf99d7af9680c3c563','gigabytes',-1,'2025-10-02 17:09:27','48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:09:31.061130',NULL,'2025-10-01 17:09:31.157463',924,924,'c6801335b5594dc38e737626407c353c','7d0cd62b-7257-432e-9c57-e33dc6964b9f',238,'2d1156e4dd1a4bcf99d7af9680c3c563','shares',1,'2025-10-02 17:09:31',NULL),('2025-10-01 17:09:31.062229',NULL,'2025-10-01 17:09:31.157463',925,925,'c6801335b5594dc38e737626407c353c','eb63e007-37a1-40ce-acfc-ab239446ba40',239,'2d1156e4dd1a4bcf99d7af9680c3c563','gigabytes',1,'2025-10-02 17:09:31',NULL),('2025-10-01 17:09:31.082451',NULL,'2025-10-01 17:09:31.157463',926,926,NULL,'28bda81a-bb26-4675-b959-8ed351c2b913',240,'2d1156e4dd1a4bcf99d7af9680c3c563','shares',1,'2025-10-02 17:09:31','48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:09:31.083978',NULL,'2025-10-01 17:09:31.157463',927,927,NULL,'7d778028-7d20-4724-a319-c4ae7283d528',241,'2d1156e4dd1a4bcf99d7af9680c3c563','gigabytes',1,'2025-10-02 17:09:31','48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:09:36.356992',NULL,'2025-10-01 17:09:36.387934',928,928,'8535d97e92664479824a211407aa1fdc','5930441d-a372-4588-a585-77e828c16039',255,'0103e60cf08a41ecb4737770562548a5','shares',1,'2025-10-02 17:09:36',NULL),('2025-10-01 17:09:36.358007',NULL,'2025-10-01 17:09:36.387934',929,929,'8535d97e92664479824a211407aa1fdc','35dab902-318d-4a26-a463-2a9cf30f4576',254,'0103e60cf08a41ecb4737770562548a5','gigabytes',1,'2025-10-02 17:09:36',NULL),('2025-10-01 17:09:36.365938',NULL,'2025-10-01 17:09:36.387934',930,930,NULL,'6c5b71e8-deb2-43dc-b8d4-6eb1e2e3cf8d',257,'0103e60cf08a41ecb4737770562548a5','shares',1,'2025-10-02 17:09:36','b2b70e19-2ae4-4aea-be0a-96f3e01586b6'),('2025-10-01 17:09:36.367172',NULL,'2025-10-01 17:09:36.387934',931,931,NULL,'985b1904-74f1-4580-a0e0-08707df5d6ee',256,'0103e60cf08a41ecb4737770562548a5','gigabytes',1,'2025-10-02 17:09:36','b2b70e19-2ae4-4aea-be0a-96f3e01586b6'),('2025-10-01 17:09:36.924084',NULL,'2025-10-01 17:09:36.940382',932,932,'c6801335b5594dc38e737626407c353c','0c8f692e-5cfa-464f-b4a8-18f4711f9bee',238,'2d1156e4dd1a4bcf99d7af9680c3c563','shares',-1,'2025-10-02 17:09:36',NULL),('2025-10-01 17:09:36.924814',NULL,'2025-10-01 17:09:36.940382',933,933,'c6801335b5594dc38e737626407c353c','0709d6dd-3640-47e8-8d47-14aab04ec530',239,'2d1156e4dd1a4bcf99d7af9680c3c563','gigabytes',-1,'2025-10-02 17:09:36',NULL),('2025-10-01 17:09:36.930810',NULL,'2025-10-01 17:09:36.940382',934,934,NULL,'82962906-557b-4792-9938-fd740b705f60',240,'2d1156e4dd1a4bcf99d7af9680c3c563','shares',-1,'2025-10-02 17:09:36','48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:09:36.931600',NULL,'2025-10-01 17:09:36.940382',935,935,NULL,'9ae2e5db-3509-4423-a984-d93d159b1b16',241,'2d1156e4dd1a4bcf99d7af9680c3c563','gigabytes',-1,'2025-10-02 17:09:36','48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:09:39.821334',NULL,'2025-10-01 17:09:39.915174',936,936,'8535d97e92664479824a211407aa1fdc','668e6e11-0b18-4458-b242-3e9f4384d855',258,'0103e60cf08a41ecb4737770562548a5','snapshots',1,'2025-10-02 17:09:39',NULL),('2025-10-01 17:09:39.824012',NULL,'2025-10-01 17:09:39.915174',937,937,'8535d97e92664479824a211407aa1fdc','8a9adf64-a473-43c4-b304-b86fbba70ee2',259,'0103e60cf08a41ecb4737770562548a5','snapshot_gigabytes',1,'2025-10-02 17:09:39',NULL),('2025-10-01 17:09:39.840834',NULL,'2025-10-01 17:09:39.915174',938,938,NULL,'61269256-e27d-47bf-b006-4e3c4fb96f46',260,'0103e60cf08a41ecb4737770562548a5','snapshots',1,'2025-10-02 17:09:39','b2b70e19-2ae4-4aea-be0a-96f3e01586b6'),('2025-10-01 17:09:39.841906',NULL,'2025-10-01 17:09:39.915174',939,939,NULL,'bf3d1dfe-82c8-462d-9bc3-e48022731a65',261,'0103e60cf08a41ecb4737770562548a5','snapshot_gigabytes',1,'2025-10-02 17:09:39','b2b70e19-2ae4-4aea-be0a-96f3e01586b6'),('2025-10-01 17:09:40.428390',NULL,'2025-10-01 17:09:40.444477',940,940,'c6801335b5594dc38e737626407c353c','a23876b9-b547-4489-8474-8aff182490a5',238,'2d1156e4dd1a4bcf99d7af9680c3c563','shares',-1,'2025-10-02 17:09:40',NULL),('2025-10-01 17:09:40.429072',NULL,'2025-10-01 17:09:40.444477',941,941,'c6801335b5594dc38e737626407c353c','b9314c09-aa9f-481d-b3d2-f8c3fc2204e1',239,'2d1156e4dd1a4bcf99d7af9680c3c563','gigabytes',-1,'2025-10-02 17:09:40',NULL),('2025-10-01 17:09:40.435303',NULL,'2025-10-01 17:09:40.444477',942,942,NULL,'b2c1bd0e-2ef3-4eee-ada2-eac266d41730',240,'2d1156e4dd1a4bcf99d7af9680c3c563','shares',-1,'2025-10-02 17:09:40','48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:09:40.436242',NULL,'2025-10-01 17:09:40.444477',943,943,NULL,'51d7bcc6-b4f0-4233-b0e4-f6f832e9fa38',241,'2d1156e4dd1a4bcf99d7af9680c3c563','gigabytes',-1,'2025-10-02 17:09:40','48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:09:43.800696',NULL,'2025-10-01 17:09:43.834102',944,944,'c6801335b5594dc38e737626407c353c','479dc8ae-3e28-4590-94e7-a3009527fb4e',242,'2d1156e4dd1a4bcf99d7af9680c3c563','snapshots',-1,'2025-10-02 17:09:43',NULL),('2025-10-01 17:09:43.801665',NULL,'2025-10-01 17:09:43.834102',945,945,'c6801335b5594dc38e737626407c353c','e15590d0-84ac-4e96-86b0-96a5a6d5daf3',243,'2d1156e4dd1a4bcf99d7af9680c3c563','snapshot_gigabytes',-1,'2025-10-02 17:09:43',NULL),('2025-10-01 17:09:43.815231',NULL,'2025-10-01 17:09:43.834102',946,946,NULL,'4e713ab0-1757-4fa8-9106-27afdbef059f',244,'2d1156e4dd1a4bcf99d7af9680c3c563','snapshots',-1,'2025-10-02 17:09:43','48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:09:43.816422',NULL,'2025-10-01 17:09:43.834102',947,947,NULL,'6306b7a2-22ed-4936-aee0-43a57638e736',245,'2d1156e4dd1a4bcf99d7af9680c3c563','snapshot_gigabytes',-1,'2025-10-02 17:09:43','48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:09:45.390520',NULL,'2025-10-01 17:09:45.410865',948,948,'8535d97e92664479824a211407aa1fdc','1bbbc699-2cd2-4c97-8672-140698cb102e',258,'0103e60cf08a41ecb4737770562548a5','snapshots',-1,'2025-10-02 17:09:45',NULL),('2025-10-01 17:09:45.392519',NULL,'2025-10-01 17:09:45.410865',949,949,'8535d97e92664479824a211407aa1fdc','997f7c5e-5e68-4777-9bb5-29eed10e8219',259,'0103e60cf08a41ecb4737770562548a5','snapshot_gigabytes',-1,'2025-10-02 17:09:45',NULL),('2025-10-01 17:09:45.400392',NULL,'2025-10-01 17:09:45.410865',950,950,NULL,'4bb1ddc6-ff73-43bc-ab68-4f89b95a557d',260,'0103e60cf08a41ecb4737770562548a5','snapshots',-1,'2025-10-02 17:09:45','b2b70e19-2ae4-4aea-be0a-96f3e01586b6'),('2025-10-01 17:09:45.401503',NULL,'2025-10-01 17:09:45.410865',951,951,NULL,'5d7299bb-2e9b-4c83-a406-44910ffe850c',261,'0103e60cf08a41ecb4737770562548a5','snapshot_gigabytes',-1,'2025-10-02 17:09:45','b2b70e19-2ae4-4aea-be0a-96f3e01586b6'),('2025-10-01 17:09:46.976987',NULL,'2025-10-01 17:09:46.990345',952,952,'c6801335b5594dc38e737626407c353c','8cb283e3-7bbe-4e8d-a3a0-4f5e57d239f4',238,'2d1156e4dd1a4bcf99d7af9680c3c563','shares',-1,'2025-10-02 17:09:46',NULL),('2025-10-01 17:09:46.977686',NULL,'2025-10-01 17:09:46.990345',953,953,'c6801335b5594dc38e737626407c353c','a8696393-cdeb-462d-860f-08968023765c',239,'2d1156e4dd1a4bcf99d7af9680c3c563','gigabytes',-1,'2025-10-02 17:09:46',NULL),('2025-10-01 17:09:46.982727',NULL,'2025-10-01 17:09:46.990345',954,954,NULL,'127f4f28-0939-471c-9015-82e72b718534',240,'2d1156e4dd1a4bcf99d7af9680c3c563','shares',-1,'2025-10-02 17:09:46','48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:09:46.983462',NULL,'2025-10-01 17:09:46.990345',955,955,NULL,'aece395f-2251-4861-a417-4a8360034aba',241,'2d1156e4dd1a4bcf99d7af9680c3c563','gigabytes',-1,'2025-10-02 17:09:46','48f33a6c-07f4-40ed-8292-0a40c1a95498'),('2025-10-01 17:09:48.293645',NULL,'2025-10-01 17:09:48.311292',956,956,'8535d97e92664479824a211407aa1fdc','da7aea19-078f-4863-b3e2-1429c3d69f89',255,'0103e60cf08a41ecb4737770562548a5','shares',-1,'2025-10-02 17:09:48',NULL),('2025-10-01 17:09:48.294477',NULL,'2025-10-01 17:09:48.311292',957,957,'8535d97e92664479824a211407aa1fdc','b4c365ac-387a-44d8-8ee7-dc86b1f1114a',254,'0103e60cf08a41ecb4737770562548a5','gigabytes',-1,'2025-10-02 17:09:48',NULL),('2025-10-01 17:09:48.302441',NULL,'2025-10-01 17:09:48.311292',958,958,NULL,'24023ab7-9d6e-425d-a4d5-5c6ddd56eba5',257,'0103e60cf08a41ecb4737770562548a5','shares',-1,'2025-10-02 17:09:48','b2b70e19-2ae4-4aea-be0a-96f3e01586b6'),('2025-10-01 17:09:48.303386',NULL,'2025-10-01 17:09:48.311292',959,959,NULL,'04f2ce1a-73b2-4e30-b8f9-58d1331fec5b',256,'0103e60cf08a41ecb4737770562548a5','gigabytes',-1,'2025-10-02 17:09:48','b2b70e19-2ae4-4aea-be0a-96f3e01586b6'),('2025-10-01 17:09:58.998034',NULL,'2025-10-01 17:09:59.030666',960,960,'7b4f3ac1db9d4257ad4205e53cd20033','b52ca994-4ad5-49fb-8bd0-5f6e70e65a46',263,'e168bce9fe04489288d3480d858b4158','shares',1,'2025-10-02 17:09:58',NULL),('2025-10-01 17:09:58.999548',NULL,'2025-10-01 17:09:59.030666',961,961,'7b4f3ac1db9d4257ad4205e53cd20033','2858eea2-1a1b-4269-b73b-493f998a883a',262,'e168bce9fe04489288d3480d858b4158','gigabytes',1,'2025-10-02 17:09:58',NULL),('2025-10-01 17:09:59.011915',NULL,'2025-10-01 17:09:59.030666',962,962,NULL,'b0c5de0a-cc58-48af-ab15-79930ac651ee',265,'e168bce9fe04489288d3480d858b4158','shares',1,'2025-10-02 17:09:58','4f903460-2d3d-42ea-bed9-eacdc72380eb'),('2025-10-01 17:09:59.012873',NULL,'2025-10-01 17:09:59.030666',963,963,NULL,'37d71aa2-0c18-4f11-bc72-2781fc5a46b2',264,'e168bce9fe04489288d3480d858b4158','gigabytes',1,'2025-10-02 17:09:58','4f903460-2d3d-42ea-bed9-eacdc72380eb'),('2025-10-01 17:10:02.406535',NULL,'2025-10-01 17:10:02.498993',964,964,'7b4f3ac1db9d4257ad4205e53cd20033','e13f1662-2e84-45f3-9a96-194c7875edaf',267,'e168bce9fe04489288d3480d858b4158','snapshots',1,'2025-10-02 17:10:02',NULL),('2025-10-01 17:10:02.408022',NULL,'2025-10-01 17:10:02.498993',965,965,'7b4f3ac1db9d4257ad4205e53cd20033','7f6a1f8b-758f-4a52-ab6e-2204aaf90bbe',266,'e168bce9fe04489288d3480d858b4158','snapshot_gigabytes',1,'2025-10-02 17:10:02',NULL),('2025-10-01 17:10:02.422281',NULL,'2025-10-01 17:10:02.498993',966,966,NULL,'f75949c4-c401-4f1a-a7ed-7e24719fc1fc',269,'e168bce9fe04489288d3480d858b4158','snapshots',1,'2025-10-02 17:10:02','4f903460-2d3d-42ea-bed9-eacdc72380eb'),('2025-10-01 17:10:02.423575',NULL,'2025-10-01 17:10:02.498993',967,967,NULL,'3453710d-6533-4bc1-b112-68c9e80f05fe',268,'e168bce9fe04489288d3480d858b4158','snapshot_gigabytes',1,'2025-10-02 17:10:02','4f903460-2d3d-42ea-bed9-eacdc72380eb'),('2025-10-01 17:10:07.687362',NULL,'2025-10-01 17:10:07.713292',968,968,'7b4f3ac1db9d4257ad4205e53cd20033','4ecfdb56-9dea-4e3f-a10e-3103c345f97c',267,'e168bce9fe04489288d3480d858b4158','snapshots',-1,'2025-10-02 17:10:07',NULL),('2025-10-01 17:10:07.688168',NULL,'2025-10-01 17:10:07.713292',969,969,'7b4f3ac1db9d4257ad4205e53cd20033','19db1317-e634-414b-af86-e008e45568d1',266,'e168bce9fe04489288d3480d858b4158','snapshot_gigabytes',-1,'2025-10-02 17:10:07',NULL),('2025-10-01 17:10:07.696615',NULL,'2025-10-01 17:10:07.713292',970,970,NULL,'3baa755e-1942-4a98-adf2-573a59b29534',269,'e168bce9fe04489288d3480d858b4158','snapshots',-1,'2025-10-02 17:10:07','4f903460-2d3d-42ea-bed9-eacdc72380eb'),('2025-10-01 17:10:07.697323',NULL,'2025-10-01 17:10:07.713292',971,971,NULL,'6aa632ba-670c-42de-a4aa-519e956a1e87',268,'e168bce9fe04489288d3480d858b4158','snapshot_gigabytes',-1,'2025-10-02 17:10:07','4f903460-2d3d-42ea-bed9-eacdc72380eb'),('2025-10-01 17:10:11.064189',NULL,'2025-10-01 17:10:11.092884',972,972,'7b4f3ac1db9d4257ad4205e53cd20033','b4cbadb5-b6f3-4b2e-8eaf-ce6472b2f871',263,'e168bce9fe04489288d3480d858b4158','shares',-1,'2025-10-02 17:10:11',NULL),('2025-10-01 17:10:11.064930',NULL,'2025-10-01 17:10:11.092884',973,973,'7b4f3ac1db9d4257ad4205e53cd20033','281ccd39-3527-4c9d-a077-8bf9de91c5d9',262,'e168bce9fe04489288d3480d858b4158','gigabytes',-1,'2025-10-02 17:10:11',NULL),('2025-10-01 17:10:11.072128',NULL,'2025-10-01 17:10:11.092884',974,974,NULL,'6bbdbe01-7a41-4e1f-af44-8a4122ce30ef',265,'e168bce9fe04489288d3480d858b4158','shares',-1,'2025-10-02 17:10:11','4f903460-2d3d-42ea-bed9-eacdc72380eb'),('2025-10-01 17:10:11.073015',NULL,'2025-10-01 17:10:11.092884',975,975,NULL,'b9af6ec9-74b8-464b-a363-467c4a1539f6',264,'e168bce9fe04489288d3480d858b4158','gigabytes',-1,'2025-10-02 17:10:11','4f903460-2d3d-42ea-bed9-eacdc72380eb');
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `security_services`
--

DROP TABLE IF EXISTS `security_services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `security_services` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `type` varchar(32) NOT NULL,
  `dns_ip` varchar(64) DEFAULT NULL,
  `server` varchar(255) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `user` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `ou` varchar(255) DEFAULT NULL,
  `default_ad_site` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `security_services`
--

LOCK TABLES `security_services` WRITE;
/*!40000 ALTER TABLE `security_services` DISABLE KEYS */;
INSERT INTO `security_services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `type`, `dns_ip`, `server`, `domain`, `user`, `password`, `name`, `description`, `ou`, `default_ad_site`) VALUES ('2002-02-02 00:00:00.000000',NULL,NULL,'False','00a49b98-4858-4678-8978-c19b2b8539ef','9bd13d2e911f47bd8088546be105109c','kerberos',NULL,NULL,NULL,NULL,NULL,'sn_with_ldap_ss','fake description',NULL,NULL),('2025-10-01 17:00:54.078406','2025-10-01 17:00:54.255359','2025-10-01 17:00:54.255008','04b240ff-9c35-408b-8c26-4826146d7a01','04b240ff-9c35-408b-8c26-4826146d7a01','145646611246417d828b11de09ec4aa6','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-10-01 17:06:22.605792',NULL,NULL,'False','071a9b46-f71d-400b-8e9a-5f8ea7cc3b60','89da7f149c6d414e94627e6e6c634ced','ldap','203.0.113.162','203.0.113.94','tempest-ss-domain-748178508','tempest-ss-user-703238720','tempest-ss-password-918356266','tempest-ss-name-1861952295','tempest-ss-desc-1790998576',NULL,NULL),('2025-10-01 17:03:29.422573','2025-10-01 17:03:31.880413','2025-10-01 17:03:31.879917','07ce6da7-3b31-459e-a02a-1d9cc63c613c','07ce6da7-3b31-459e-a02a-1d9cc63c613c','ea69928a550948da8bc33622ba2d80e2','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-10-01 17:03:33.802342','2025-10-01 17:03:34.375691','2025-10-01 17:03:34.375255','0fb8a9e5-cd2d-49d3-95ee-038710ace6f5','0fb8a9e5-cd2d-49d3-95ee-038710ace6f5','ea69928a550948da8bc33622ba2d80e2','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-10-01 17:00:50.833433','2025-10-01 17:00:51.057623','2025-10-01 17:00:51.057042','10c32ab5-1cf4-42b4-85b7-1b27cf06b1ba','10c32ab5-1cf4-42b4-85b7-1b27cf06b1ba','145646611246417d828b11de09ec4aa6','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-10-01 17:07:10.623498','2025-10-01 17:07:10.697353','2025-10-01 17:07:10.697013','111f7406-8c92-4cf0-989b-2533dfbbc2dc','111f7406-8c92-4cf0-989b-2533dfbbc2dc','c876e4d730b546ddbbdcac41c0b7d6ee','ldap','203.0.113.111','203.0.113.183','tempest-ss-domain-507601865','tempest-ss-user-1567034327','tempest-ss-password-163419691','tempest-ss-name-1752035086','tempest-ss-desc-109599632',NULL,NULL),('2025-10-01 17:03:26.325196','2025-10-01 17:03:26.688865','2025-10-01 17:03:26.688560','17c21c55-bbff-48ce-8bdc-1ece74915c92','17c21c55-bbff-48ce-8bdc-1ece74915c92','ea69928a550948da8bc33622ba2d80e2','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-10-01 17:03:28.068898','2025-10-01 17:03:28.590837','2025-10-01 17:03:28.590555','1b7927de-4476-4f6c-8f8e-63ffbb1555b5','1b7927de-4476-4f6c-8f8e-63ffbb1555b5','ea69928a550948da8bc33622ba2d80e2','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-10-01 17:03:28.171744','2025-10-01 17:03:28.344103','2025-10-01 17:03:28.343801','1f2b9028-8b70-449e-91e7-08af866bcf68','1f2b9028-8b70-449e-91e7-08af866bcf68','ea69928a550948da8bc33622ba2d80e2','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-10-01 17:03:28.771803','2025-10-01 17:03:29.215345','2025-10-01 17:03:29.215071','209d2e01-def9-4eb8-90f1-07f105fc945a','209d2e01-def9-4eb8-90f1-07f105fc945a','ea69928a550948da8bc33622ba2d80e2','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-10-01 17:03:24.722869','2025-10-01 17:03:24.845578','2025-10-01 17:03:24.845177','218abe38-0eab-4d29-8b44-a7f354dada9c','218abe38-0eab-4d29-8b44-a7f354dada9c','ea69928a550948da8bc33622ba2d80e2','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-10-01 17:06:46.569334',NULL,NULL,'False','221daa1f-21d5-4154-a0fe-48dd4b9df842','7b8bec1247f54479b803a9ec7e7655de','ldap','203.0.113.44','203.0.113.74','tempest-ss-domain-1049696974','tempest-ss-user-836837941','tempest-ss-password-571851528','tempest-ss-name-1393891131','tempest-ss-desc-577258510',NULL,NULL),('2025-10-01 17:03:25.494008','2025-10-01 17:03:25.701364','2025-10-01 17:03:25.700966','26b310b2-06b3-43dc-9085-6797aaa13a0f','26b310b2-06b3-43dc-9085-6797aaa13a0f','ea69928a550948da8bc33622ba2d80e2','ldap','203.0.113.244','203.0.113.135','tempest-ss-domain-547554461','tempest-ss-user-301210707','tempest-ss-password-61479515','tempest-ss-name-875864564','tempest-ss-desc-196669299',NULL,NULL),('2025-10-01 17:03:27.265316','2025-10-01 17:03:27.440182','2025-10-01 17:03:27.439804','273b04c1-db09-46ab-96dc-ffd5742fafdc','273b04c1-db09-46ab-96dc-ffd5742fafdc','ea69928a550948da8bc33622ba2d80e2','ldap','203.0.113.139','203.0.113.167','tempest-ss-domain-1841762009','tempest-ss-user-573140648','tempest-ss-password-753734204','tempest-ss-name-399388721','tempest-ss-desc-425851617','tempest-ss-ou-1229585548',NULL),('2025-10-01 17:00:52.933999','2025-10-01 17:00:53.006374','2025-10-01 17:00:53.005925','2e2faa26-06ef-4661-b210-e561c5912386','2e2faa26-06ef-4661-b210-e561c5912386','145646611246417d828b11de09ec4aa6','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-10-01 17:03:25.302585','2025-10-01 17:03:26.149888','2025-10-01 17:03:26.149601','31da503c-9411-4b43-9f74-dde49efbc4dd','31da503c-9411-4b43-9f74-dde49efbc4dd','ea69928a550948da8bc33622ba2d80e2','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-10-01 17:03:23.488109','2025-10-01 17:03:24.444253','2025-10-01 17:03:24.443872','3828ee1b-e7d2-48aa-b85a-cadf719636fa','3828ee1b-e7d2-48aa-b85a-cadf719636fa','ea69928a550948da8bc33622ba2d80e2','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-10-01 17:00:52.091334','2025-10-01 17:00:52.617444','2025-10-01 17:00:52.617171','3960e479-e66d-4141-aebf-22e1b791deac','3960e479-e66d-4141-aebf-22e1b791deac','145646611246417d828b11de09ec4aa6','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-10-01 17:03:34.324329',NULL,NULL,'False','3b83d150-7abb-4af0-bfe4-3978b23b6812','01bc5d037e3c4524ae56d7d17d262d0d','ldap','203.0.113.123','203.0.113.165','tempest-ss-domain-2084904853','tempest-ss-user-755873657','tempest-ss-password-1932934415','tempest-ss-name-1281110293','tempest-ss-desc-2062419534',NULL,NULL),('2025-10-01 17:03:26.272109','2025-10-01 17:03:26.834317','2025-10-01 17:03:26.833958','400fab85-e386-4be3-acee-513b02b497f4','400fab85-e386-4be3-acee-513b02b497f4','ea69928a550948da8bc33622ba2d80e2','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-10-01 17:00:54.539262','2025-10-01 17:00:55.058374','2025-10-01 17:00:55.058085','40a47aa9-521a-4166-b71f-19fd2f1f991c','40a47aa9-521a-4166-b71f-19fd2f1f991c','145646611246417d828b11de09ec4aa6','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-10-01 17:03:26.392449','2025-10-01 17:03:26.546946','2025-10-01 17:03:26.546589','440f0044-fc48-4c17-a175-0dfba7421fe1','440f0044-fc48-4c17-a175-0dfba7421fe1','ea69928a550948da8bc33622ba2d80e2','ldap','203.0.113.131','203.0.113.48','tempest-ss-domain-619650486','tempest-ss-user-2132498756','tempest-ss-password-774215726','tempest-ss-name-1736096351','tempest-ss-desc-1279941740','tempest-ss-ou-53520435',NULL),('2025-10-01 17:03:34.040831','2025-10-01 17:03:34.178601','2025-10-01 17:03:34.178325','4699b33d-891f-4f99-a548-56c770c775b2','4699b33d-891f-4f99-a548-56c770c775b2','ea69928a550948da8bc33622ba2d80e2','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-10-01 17:03:36.717155','2025-10-01 17:03:37.334115','2025-10-01 17:03:37.332747','4913c4ae-6ac2-4b0c-ae79-7ea3bfe35447','4913c4ae-6ac2-4b0c-ae79-7ea3bfe35447','ea69928a550948da8bc33622ba2d80e2','ldap','203.0.113.168','203.0.113.32','tempest-ss-domain-981402066','tempest-ss-user-419480319','tempest-ss-password-1330885543','tempest-ss-name-439840393','tempest-ss-desc-60941964','tempest-ss-ou-1590216143',NULL),('2025-10-01 17:03:32.792233','2025-10-01 17:03:33.636877','2025-10-01 17:03:33.636590','4c1b26ab-ea4b-4969-ba40-a0b4845f739e','4c1b26ab-ea4b-4969-ba40-a0b4845f739e','ea69928a550948da8bc33622ba2d80e2','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-10-01 17:00:53.356843','2025-10-01 17:00:53.901486','2025-10-01 17:00:53.901203','4d8d6d95-6d3e-445e-ad5c-a52ae0355f5b','4d8d6d95-6d3e-445e-ad5c-a52ae0355f5b','145646611246417d828b11de09ec4aa6','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-10-01 17:03:27.148138','2025-10-01 17:03:27.719903','2025-10-01 17:03:27.719367','51391525-cb55-4f56-bf5a-b695abdeb6ec','51391525-cb55-4f56-bf5a-b695abdeb6ec','ea69928a550948da8bc33622ba2d80e2','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-10-01 17:00:54.012604','2025-10-01 17:00:54.397514','2025-10-01 17:00:54.397110','53915ebf-e74f-43ee-84d5-5ba8a59b6f4b','53915ebf-e74f-43ee-84d5-5ba8a59b6f4b','145646611246417d828b11de09ec4aa6','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-10-01 17:06:59.166382',NULL,NULL,'False','572bea26-3742-493d-b718-a510eb20fe7b','30cd3ce4e43d4122b839b6e5f4bf6511','ldap','203.0.113.77','203.0.113.37','tempest-ss-domain-183622985','tempest-ss-user-604534320','tempest-ss-password-1346012842','tempest-ss-name-1105850320','tempest-ss-desc-805623001',NULL,NULL),('2025-10-01 17:00:51.508454','2025-10-01 17:00:51.651160','2025-10-01 17:00:51.650795','597b4cb5-3ef8-437d-ae81-8360c60f18d8','597b4cb5-3ef8-437d-ae81-8360c60f18d8','145646611246417d828b11de09ec4aa6','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-10-01 17:00:49.575324','2025-10-01 17:00:50.372944','2025-10-01 17:00:50.372235','5a82dff9-a4f7-46fa-8b78-d3b0af2ecceb','5a82dff9-a4f7-46fa-8b78-d3b0af2ecceb','145646611246417d828b11de09ec4aa6','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-10-01 17:03:33.009616','2025-10-01 17:03:33.374494','2025-10-01 17:03:33.374201','5c0cb652-2bce-434e-a512-8998fe1b1846','5c0cb652-2bce-434e-a512-8998fe1b1846','ea69928a550948da8bc33622ba2d80e2','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-10-01 17:06:56.632527',NULL,NULL,'False','613f6a19-72ac-4c29-afdd-6e30d1e1e219','30cd3ce4e43d4122b839b6e5f4bf6511','ldap',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('2025-10-01 17:03:34.635079','2025-10-01 17:03:35.027427','2025-10-01 17:03:35.027063','6d9bf092-6ddc-474b-a0ab-bad86c0d0823','6d9bf092-6ddc-474b-a0ab-bad86c0d0823','ea69928a550948da8bc33622ba2d80e2','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-10-01 17:03:36.615310','2025-10-01 17:03:37.460234','2025-10-01 17:03:37.459815','71bcd4ef-00a4-4819-bfb0-f0871f6488b7','71bcd4ef-00a4-4819-bfb0-f0871f6488b7','ea69928a550948da8bc33622ba2d80e2','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-10-01 17:00:52.176029','2025-10-01 17:00:52.390458','2025-10-01 17:00:52.389722','72f1b9d4-c66d-4a44-b338-3580a7ad0fd8','72f1b9d4-c66d-4a44-b338-3580a7ad0fd8','145646611246417d828b11de09ec4aa6','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-10-01 17:03:27.061327','2025-10-01 17:03:27.930514','2025-10-01 17:03:27.930240','7315a2f6-e156-4930-8919-67b75580a679','7315a2f6-e156-4930-8919-67b75580a679','ea69928a550948da8bc33622ba2d80e2','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2002-02-02 00:00:00.000000',NULL,NULL,'False','794763b5-a145-481e-b94b-2de3ef05c532','89da7f149c6d414e94627e6e6c634ced','kerberos',NULL,NULL,NULL,NULL,NULL,'sn_with_ldap_ss','fake description',NULL,NULL),('2025-10-01 17:03:35.618217','2025-10-01 17:03:35.894676','2025-10-01 17:03:35.894379','7be2eaa9-c97b-4ba4-bc74-3b4b5f85f0ed','7be2eaa9-c97b-4ba4-bc74-3b4b5f85f0ed','7b1e00c53169454580f740e6e2aa7938','ldap','203.0.113.92','203.0.113.230','tempest-ss-domain-142415926','tempest-ss-user-1589654382','tempest-ss-password-998174697','tempest-ss-name-846261990','tempest-ss-desc-1919156820',NULL,NULL),('2025-10-01 17:00:50.759793','2025-10-01 17:00:51.341106','2025-10-01 17:00:51.340578','7ca16791-34a4-4a37-bb64-74e37cde011c','7ca16791-34a4-4a37-bb64-74e37cde011c','145646611246417d828b11de09ec4aa6','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-10-01 17:06:59.221511','2025-10-01 17:06:59.506721','2025-10-01 17:06:59.506365','89028815-91ac-4deb-9f14-45259eac223f','89028815-91ac-4deb-9f14-45259eac223f','30cd3ce4e43d4122b839b6e5f4bf6511','ldap','203.0.113.194','203.0.113.180','tempest-ss-domain-2057699487','tempest-ss-user-2125467442','tempest-ss-password-591150772','tempest-ss-name-1037887651','tempest-ss-desc-591873495',NULL,NULL),('2025-10-01 17:03:35.309610','2025-10-01 17:03:36.115375','2025-10-01 17:03:36.114955','892021b0-0adf-4f90-bf34-0f89aee61a42','892021b0-0adf-4f90-bf34-0f89aee61a42','ea69928a550948da8bc33622ba2d80e2','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-10-01 17:00:53.485695','2025-10-01 17:00:53.712008','2025-10-01 17:00:53.711572','8ee98d77-9789-436e-837e-abdb8929dc0a','8ee98d77-9789-436e-837e-abdb8929dc0a','145646611246417d828b11de09ec4aa6','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-10-01 17:06:58.060479','2025-10-01 17:06:58.518187','2025-10-01 17:06:58.517865','8ff9d8bd-d515-475d-9a13-c6277b92a22a','8ff9d8bd-d515-475d-9a13-c6277b92a22a','30cd3ce4e43d4122b839b6e5f4bf6511','ldap','203.0.113.7','203.0.113.187','tempest-ss-domain-1984791124','tempest-ss-user-157906252','tempest-ss-password-1003989779','tempest-ss-name-1302225384','tempest-ss-desc-1813295838',NULL,NULL),('2025-10-01 17:03:32.146746','2025-10-01 17:03:32.388126','2025-10-01 17:03:32.387591','95af64d6-90d4-4c95-8600-37e0138f2646','95af64d6-90d4-4c95-8600-37e0138f2646','ea69928a550948da8bc33622ba2d80e2','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-10-01 17:06:47.731193',NULL,NULL,'False','97a33479-fdb0-4b59-b8ec-36159472c12b','7b8bec1247f54479b803a9ec7e7655de','ldap','203.0.113.93','203.0.113.12','tempest-ss-domain-1864480623','tempest-ss-user-932239428','tempest-ss-password-1641753487','tempest-ss-name-1973411849','tempest-ss-desc-1340190147',NULL,NULL),('2025-10-01 17:03:23.575988','2025-10-01 17:03:24.324362','2025-10-01 17:03:24.323974','9946d7f5-5917-496e-a921-6eb8f3488d67','9946d7f5-5917-496e-a921-6eb8f3488d67','ea69928a550948da8bc33622ba2d80e2','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-10-01 17:03:35.199454','2025-10-01 17:03:36.317293','2025-10-01 17:03:36.316860','9a951aee-d7cf-4cf5-b261-961ed821a6d4','9a951aee-d7cf-4cf5-b261-961ed821a6d4','ea69928a550948da8bc33622ba2d80e2','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-10-01 17:03:32.045486','2025-10-01 17:03:32.566323','2025-10-01 17:03:32.566009','ab772e52-9395-4c88-ba0f-7ad4a83485b4','ab772e52-9395-4c88-ba0f-7ad4a83485b4','ea69928a550948da8bc33622ba2d80e2','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-10-01 17:00:51.456396','2025-10-01 17:00:51.759790','2025-10-01 17:00:51.759247','aca16f29-a6d8-414f-9175-1e9cef588a12','aca16f29-a6d8-414f-9175-1e9cef588a12','145646611246417d828b11de09ec4aa6','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-10-01 17:03:23.948789','2025-10-01 17:03:24.037331','2025-10-01 17:03:24.036908','ae877646-7e85-48fd-8257-6ce2d21758e0','ae877646-7e85-48fd-8257-6ce2d21758e0','ea69928a550948da8bc33622ba2d80e2','active_directory','203.0.113.24','203.0.113.23','tempest-ss-domain-1520325251','tempest-ss-user-633042934','tempest-ss-password-489624966','tempest-ss-name-697877321','tempest-ss-desc-1321435983',NULL,NULL),('2025-10-01 17:03:25.420191','2025-10-01 17:03:25.889556','2025-10-01 17:03:25.889179','b4205242-5284-4cf3-b340-718f13a69598','b4205242-5284-4cf3-b340-718f13a69598','ea69928a550948da8bc33622ba2d80e2','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-10-01 17:00:52.765563','2025-10-01 17:00:53.149873','2025-10-01 17:00:53.149389','c038ef44-88bd-465b-8abf-cbc0029a756f','c038ef44-88bd-465b-8abf-cbc0029a756f','145646611246417d828b11de09ec4aa6','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-10-01 17:03:23.786084','2025-10-01 17:03:23.851608','2025-10-01 17:03:23.851221','c5689a38-778d-4a2f-a612-4ec2d81ece61','c5689a38-778d-4a2f-a612-4ec2d81ece61','ea69928a550948da8bc33622ba2d80e2','kerberos','203.0.113.24','203.0.113.23','tempest-ss-domain-1520325251','tempest-ss-user-633042934','tempest-ss-password-489624966','tempest-ss-name-697877321','tempest-ss-desc-1321435983',NULL,NULL),('2025-10-01 17:03:23.650852','2025-10-01 17:03:23.720806','2025-10-01 17:03:23.720475','c8946b15-f01b-4b16-b3d1-607ffb3ee2e6','c8946b15-f01b-4b16-b3d1-607ffb3ee2e6','ea69928a550948da8bc33622ba2d80e2','ldap','203.0.113.24','203.0.113.23','tempest-ss-domain-1520325251','tempest-ss-user-633042934','tempest-ss-password-489624966','tempest-ss-name-697877321','tempest-ss-desc-1321435983',NULL,NULL),('2025-10-01 17:03:24.652105','2025-10-01 17:03:25.003228','2025-10-01 17:03:25.002865','d04712fe-94ee-4014-83d2-8314404478e8','d04712fe-94ee-4014-83d2-8314404478e8','ea69928a550948da8bc33622ba2d80e2','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-10-01 17:06:45.218990','2025-10-01 17:06:45.685972','2025-10-01 17:06:45.685440','dc3c8379-a4b5-4966-847c-31876d1cb0d2','dc3c8379-a4b5-4966-847c-31876d1cb0d2','7b8bec1247f54479b803a9ec7e7655de','ldap','203.0.113.188','203.0.113.81','tempest-ss-domain-316830709','tempest-ss-user-1837615832','tempest-ss-password-925238342','tempest-ss-name-1724611856','tempest-ss-desc-153613354',NULL,NULL),('2025-10-01 17:00:54.742985','2025-10-01 17:00:54.905236','2025-10-01 17:00:54.904804','e4743f37-2309-4474-b251-766ef96f654c','e4743f37-2309-4474-b251-766ef96f654c','145646611246417d828b11de09ec4aa6','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-10-01 17:03:28.851613','2025-10-01 17:03:28.969655','2025-10-01 17:03:28.969303','e58ed02e-1600-49f5-a8e4-8fd5c2940a54','e58ed02e-1600-49f5-a8e4-8fd5c2940a54','ea69928a550948da8bc33622ba2d80e2','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-10-01 17:03:34.764593','2025-10-01 17:03:34.917427','2025-10-01 17:03:34.917120','e6f7cbac-5ccd-49a3-8771-b75ecf40c3de','e6f7cbac-5ccd-49a3-8771-b75ecf40c3de','ea69928a550948da8bc33622ba2d80e2','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-10-01 17:03:29.748489','2025-10-01 17:03:31.687891','2025-10-01 17:03:31.687593','e9563e9f-9803-481e-8ee0-042c2a2e4bde','e9563e9f-9803-481e-8ee0-042c2a2e4bde','ea69928a550948da8bc33622ba2d80e2','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-10-01 17:03:36.480443','2025-10-01 17:03:37.670211','2025-10-01 17:03:37.669779','ea7091ac-ff7c-4bc4-85d5-275bbaeda769','ea7091ac-ff7c-4bc4-85d5-275bbaeda769','ea69928a550948da8bc33622ba2d80e2','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-10-01 17:00:49.132911','2025-10-01 17:00:50.617389','2025-10-01 17:00:50.616550','f56102e2-b266-434d-b499-7abbbc233fb0','f56102e2-b266-434d-b499-7abbbc233fb0','145646611246417d828b11de09ec4aa6','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL);
/*!40000 ALTER TABLE `security_services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  `state` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `service_az_id_fk` (`availability_zone_id`),
  CONSTRAINT `service_az_id_fk` FOREIGN KEY (`availability_zone_id`) REFERENCES `availability_zones` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone_id`, `state`) VALUES ('2025-10-01 16:55:31.521080','2025-10-01 17:23:18.321794',NULL,0,1,'hostgroup','manila-scheduler','manila-scheduler',166,0,'2495df03-e710-42a7-9e3a-64fa89e58a2e','up'),('2025-10-01 16:55:39.285821','2025-10-01 17:23:24.480928',NULL,0,2,'hostgroup@cephfs','manila-share','manila-share',164,0,'2495df03-e710-42a7-9e3a-64fa89e58a2e','up');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_access_map`
--

DROP TABLE IF EXISTS `share_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_access_map` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `share_id` varchar(36) NOT NULL,
  `access_type` varchar(255) DEFAULT NULL,
  `access_to` varchar(255) DEFAULT NULL,
  `access_level` varchar(2) DEFAULT NULL,
  `access_key` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_id` (`share_id`),
  CONSTRAINT `share_access_map_ibfk_1` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_access_map`
--

LOCK TABLES `share_access_map` WRITE;
/*!40000 ALTER TABLE `share_access_map` DISABLE KEYS */;
INSERT INTO `share_access_map` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_id`, `access_type`, `access_to`, `access_level`, `access_key`) VALUES ('2025-10-01 17:05:41.176588','2025-10-01 17:05:44.899271','2025-10-01 17:06:21.775806','00aae4e8-079c-4524-b9f2-be70307792e1','00aae4e8-079c-4524-b9f2-be70307792e1','e17d9201-dace-4c98-9dab-80fdfbfad649','cephx','alice_bob','ro','AQBlX91okvDzLxAAioFaRHqVDMvVpFgnQDIInA=='),('2025-10-01 17:05:09.660480','2025-10-01 17:05:21.256526','2025-10-01 17:05:56.790034','06c6b379-0a5b-4cc9-9942-bfa978696a35','06c6b379-0a5b-4cc9-9942-bfa978696a35','b87e1026-6ce3-48d5-a1fd-8dc67c00f4d5','cephx','Joe','rw',NULL),('2025-10-01 17:03:39.305883','2025-10-01 17:03:43.319979','2025-10-01 17:03:43.770038','0bbc872f-15ae-4142-be84-fbb154655f77','0bbc872f-15ae-4142-be84-fbb154655f77','4f309c99-0839-4c72-b180-b88ea761ebd4','cephx','tempest-cephx-id-26224483','rw','AQDrXt1oJ1LpLxAAKIxyRVxFoRG7j5vgNARGQQ=='),('2025-10-01 17:05:25.639385','2025-10-01 17:05:30.151231','2025-10-01 17:06:21.775806','12c26cbc-7c50-43f6-b7e1-6e9a114eb7c7','12c26cbc-7c50-43f6-b7e1-6e9a114eb7c7','e17d9201-dace-4c98-9dab-80fdfbfad649','cephx','alice','ro','AQBXX91ojDD2FRAAYy68zDfmlCKVxkDl2qfI8g=='),('2025-10-01 17:03:51.367724','2025-10-01 17:03:55.074194','2025-10-01 17:06:21.775806','131d98e6-f394-4a2b-9b99-2bd5adcf5c91','131d98e6-f394-4a2b-9b99-2bd5adcf5c91','e17d9201-dace-4c98-9dab-80fdfbfad649','cephx','alice_bob','rw','AQD3Xt1ohQmHKhAAt2QY84/Dr3xQ+XBJOf47Lw=='),('2025-10-01 17:03:21.857250','2025-10-01 17:03:25.640619','2025-10-01 17:06:21.775806','18fd645c-18cf-43e9-b072-647d69cb6d4a','18fd645c-18cf-43e9-b072-647d69cb6d4a','e17d9201-dace-4c98-9dab-80fdfbfad649','cephx','alice bob','rw','AQDaXt1o1NvCCRAAMZOx8k5KU+TqJNHCHl2A0w=='),('2025-10-01 17:05:48.068244','2025-10-01 17:05:51.654600','2025-10-01 17:06:21.775806','2334f636-37b0-42a0-a11b-f78e63760cf2','2334f636-37b0-42a0-a11b-f78e63760cf2','e17d9201-dace-4c98-9dab-80fdfbfad649','cephx','alice bob','rw','AQBsX91oBjO3GRAAUYL5DjQH1NVa2yYrvIcrfA=='),('2025-10-01 17:02:53.045734','2025-10-01 17:02:57.404493','2025-10-01 17:06:21.775806','295aa06b-eadc-4962-8042-dc13913a026f','295aa06b-eadc-4962-8042-dc13913a026f','e17d9201-dace-4c98-9dab-80fdfbfad649','cephx','alice','rw','AQC9Xt1oBPaKHRAAeNZaPCtfO9/iy/Zbm3kmxQ=='),('2025-10-01 17:03:00.614688','2025-10-01 17:03:04.595762','2025-10-01 17:06:21.775806','29f5aa20-c229-4e41-be93-463c13287000','29f5aa20-c229-4e41-be93-463c13287000','e17d9201-dace-4c98-9dab-80fdfbfad649','cephx','alice','ro','AQDFXt1oHqeTBBAAAKW9zoaWD3tqD9fLsCzAcg=='),('2025-10-01 17:04:59.477325','2025-10-01 17:05:27.890135','2025-10-01 17:06:00.110272','2c60d281-0498-4ba3-b905-78f798577336','2c60d281-0498-4ba3-b905-78f798577336','69e9a113-75fb-4dff-9fd9-886dc6af9628','cephx','Joe','rw','AQA7X91oNdo+ORAAMt6MGxtJMfssgFQirfNZlQ=='),('2025-10-01 17:05:52.374380','2025-10-01 17:05:56.750347','2025-10-01 17:06:01.516784','32687a93-f499-4c71-bbb0-34831ec685f6','32687a93-f499-4c71-bbb0-34831ec685f6','f5f63f5f-60e6-41b5-8df8-2523cbbf72e9','cephx','eve47','rw','AQBwX91ob82bKhAAEv2R+WM+5iFn6p9UqATaFA=='),('2025-10-01 17:03:26.904970','2025-10-01 17:03:32.090748','2025-10-01 17:03:32.798722','33ae812d-f55f-440e-851d-96e6ba9d75cc','33ae812d-f55f-440e-851d-96e6ba9d75cc','7622bcd9-86ac-47c9-b04e-06cfef0a59aa','cephx','tempest-cephx-id-26224483','rw','AQDfXt1oWMCMDRAA49Z4EjB/Hc/8ulTzS82A/A=='),('2025-10-01 17:05:08.089842','2025-10-01 17:05:15.140476','2025-10-01 17:06:21.775806','37b09400-f840-4efa-a86e-62a3758caa34','37b09400-f840-4efa-a86e-62a3758caa34','e17d9201-dace-4c98-9dab-80fdfbfad649','cephx','alice bob','ro','AQBGX91o4VPMJhAAOhbbo3+UHWDYQcDZ74gmVw=='),('2025-10-01 17:06:09.650273','2025-10-01 17:06:13.447106','2025-10-01 17:06:13.805601','3991e0c0-0453-4fec-9452-90b0743175fd','3991e0c0-0453-4fec-9452-90b0743175fd','480a39b7-c9bc-46e1-9446-76acd2c26d4a','cephx','bob','rw','AQB6X91oSwZKAhAAAYQZexQGEVZKDkYhDn7LIg=='),('2025-10-01 17:06:15.207537','2025-10-01 17:06:16.656287','2025-10-01 17:06:17.172076','501bf474-aafc-4fba-b910-7152afacff22','501bf474-aafc-4fba-b910-7152afacff22','7c9b06f4-d594-496a-9f97-ece8a04d7e6f','cephx','tempest-cephx-id-2026451665','rw','AQCHX91otxIEIBAANS62s41EHtZthVV3+dx/SQ=='),('2025-10-01 17:03:14.911221','2025-10-01 17:03:18.637890','2025-10-01 17:06:21.775806','576f1280-37ae-4005-a7b2-58916a2844be','576f1280-37ae-4005-a7b2-58916a2844be','e17d9201-dace-4c98-9dab-80fdfbfad649','cephx','alice_bob','ro','AQDTXt1oESswChAAoRVqKggKTw3bEFRlb5NfAw=='),('2025-10-01 17:03:36.693180','2025-10-01 17:03:40.648576','2025-10-01 17:06:21.775806','5836810c-bea9-4b9f-b810-72c525c48d1c','5836810c-bea9-4b9f-b810-72c525c48d1c','e17d9201-dace-4c98-9dab-80fdfbfad649','cephx','alice','rw','AQDpXt1oZhFlCBAAue+FOgOGnQjnGVtl/hVElw=='),('2025-10-01 17:04:08.472264','2025-10-01 17:04:13.250629','2025-10-01 17:04:23.458816','5ce4e6f1-b28d-4280-bfe8-fc5276d7794e','5ce4e6f1-b28d-4280-bfe8-fc5276d7794e','6e112f49-7379-4e48-b00d-b9ada34f0c5d','cephx','tempest-cephx-id-26224483','rw','AQAJX91ode9bABAAaQ717VzIv4jqMz05M6R+lw=='),('2025-10-01 17:05:54.958393','2025-10-01 17:05:58.582999','2025-10-01 17:06:21.775806','5f7c543f-5d73-4f4b-a764-989a6828edfb','5f7c543f-5d73-4f4b-a764-989a6828edfb','e17d9201-dace-4c98-9dab-80fdfbfad649','cephx','alice bob','ro','AQBzX91oa9sIDxAAXo/7f/BM6RNjlmXn28Eqag=='),('2025-10-01 17:04:57.626037','2025-10-01 17:05:01.346020','2025-10-01 17:06:21.775806','65290de4-cc3e-4851-a63b-ebf277134b30','65290de4-cc3e-4851-a63b-ebf277134b30','e17d9201-dace-4c98-9dab-80fdfbfad649','cephx','alice bob','rw','AQA6X91oe0J1AhAARsUKVuwQ9c30A7o0MsT5uA=='),('2025-10-01 17:04:23.015970','2025-10-01 17:04:27.062525','2025-10-01 17:06:21.775806','682e282e-e49f-4a6e-bb1b-d7233373ff3f','682e282e-e49f-4a6e-bb1b-d7233373ff3f','e17d9201-dace-4c98-9dab-80fdfbfad649','cephx','alice','rw','AQAYX91on9k0JhAAPrVsyR0KOrzeNB9WQ1SirQ=='),('2025-10-01 17:05:45.334164','2025-10-01 17:05:49.163923','2025-10-01 17:06:01.516784','69c3b21f-2848-42a0-928b-56f3b8b90b12','69c3b21f-2848-42a0-928b-56f3b8b90b12','f5f63f5f-60e6-41b5-8df8-2523cbbf72e9','cephx','eve48','rw','AQBpX91oFdm3LBAA2qClhgDndM8l7T4STmQuKQ=='),('2025-10-01 17:05:41.914939','2025-10-01 17:05:45.653776','2025-10-01 17:05:53.333485','69f69294-faef-4f4c-97aa-d8604b6d15e6','69f69294-faef-4f4c-97aa-d8604b6d15e6','7a670548-55c7-4b1d-8c53-f1a735354eef','cephx','david','rw',NULL),('2025-10-01 17:03:44.014333','2025-10-01 17:03:47.792592','2025-10-01 17:06:21.775806','6c31e9e8-2bcd-486a-b7b3-5a88a66d196e','6c31e9e8-2bcd-486a-b7b3-5a88a66d196e','e17d9201-dace-4c98-9dab-80fdfbfad649','cephx','alice','ro','AQDwXt1oSgs3FBAAvMc9D88yxFXXgKcwnl501g=='),('2025-10-01 17:05:18.350288','2025-10-01 17:05:22.424782','2025-10-01 17:06:21.775806','70035999-0d15-4793-9756-a12c0a89b7be','70035999-0d15-4793-9756-a12c0a89b7be','e17d9201-dace-4c98-9dab-80fdfbfad649','cephx','alice','rw','AQBQX91ouXLMBBAAKZDDET3bkgmyLUh+v08YaA=='),('2025-10-01 17:03:16.169072','2025-10-01 17:03:20.010315','2025-10-01 17:03:20.470325','745d9f0c-3b56-4455-9d06-30765803ee0d','745d9f0c-3b56-4455-9d06-30765803ee0d','7401d0d1-b73f-415c-9142-bd25f09b8209','cephx','tempest-cephx-id-26224483','rw','AQDUXt1o43nXFxAAzEpywAcnHVCBPQ80ckMkPw=='),('2025-10-01 17:06:01.760802','2025-10-01 17:06:16.980376','2025-10-01 17:06:21.775806','7931ccdd-dadf-47d1-984b-e10d694c231c','7931ccdd-dadf-47d1-984b-e10d694c231c','e17d9201-dace-4c98-9dab-80fdfbfad649','cephx','bob','rw','AQB6X91oSwZKAhAAAYQZexQGEVZKDkYhDn7LIg=='),('2025-10-01 17:03:07.900226','2025-10-01 17:03:11.711113','2025-10-01 17:06:21.775806','7ed02563-8e25-4ac2-b26f-42a39a18b339','7ed02563-8e25-4ac2-b26f-42a39a18b339','e17d9201-dace-4c98-9dab-80fdfbfad649','cephx','alice_bob','rw','AQDMXt1ognT/CxAASVxP7Bvys83LZzsnZ+hntw=='),('2025-10-01 17:03:54.073944','2025-10-01 17:03:57.953668','2025-10-01 17:04:23.458816','8319b4fa-b378-464e-b9e9-554fbc062d24','8319b4fa-b378-464e-b9e9-554fbc062d24','6e112f49-7379-4e48-b00d-b9ada34f0c5d','cephx','tempest-cephx-id-26224483','rw','AQD6Xt1oWjM7GhAAOj0qLWe6qP0RBjSeKzL6iA=='),('2025-10-01 17:05:31.111452','2025-10-01 17:06:03.454103','2025-10-01 17:06:03.714156','8508e1fa-8ffb-4a9e-a555-24010a3620dd','8508e1fa-8ffb-4a9e-a555-24010a3620dd','7b1893fd-a87d-4134-86a0-88945c063bc6','cephx','admin','rw',NULL),('2025-10-01 17:04:50.309111','2025-10-01 17:04:54.399312','2025-10-01 17:06:21.775806','86d130fb-d19b-4f1b-adf2-5fb260b37616','86d130fb-d19b-4f1b-adf2-5fb260b37616','e17d9201-dace-4c98-9dab-80fdfbfad649','cephx','alice_bob','ro','AQAzX91ovgY0AxAAbbGUfyjsaXH1A4vVWpUARw=='),('2025-10-01 17:04:12.834000','2025-10-01 17:04:19.806521','2025-10-01 17:06:21.775806','8e1d645c-d310-47e4-8996-9cb9ff9ca8fe','8e1d645c-d310-47e4-8996-9cb9ff9ca8fe','e17d9201-dace-4c98-9dab-80fdfbfad649','cephx','alice bob','ro','AQAOX91oIrEGFxAAI7topIqomngsfraBznBJsA=='),('2025-10-01 17:04:05.572965','2025-10-01 17:04:09.462845','2025-10-01 17:06:21.775806','8e6157f8-58a6-44bc-8b3f-e58d1745da45','8e6157f8-58a6-44bc-8b3f-e58d1745da45','e17d9201-dace-4c98-9dab-80fdfbfad649','cephx','alice bob','rw','AQAGX91onfKlIBAAt58vqZpRzp8vp46TRAnBhQ=='),('2025-10-01 17:03:58.309346','2025-10-01 17:04:02.296688','2025-10-01 17:06:21.775806','9ec7bc76-9228-406d-a432-60b3409854a1','9ec7bc76-9228-406d-a432-60b3409854a1','e17d9201-dace-4c98-9dab-80fdfbfad649','cephx','alice_bob','ro','AQD+Xt1opNcwKRAAhqCM4uDyUvromilI0L4ZIA=='),('2025-10-01 17:03:28.972464','2025-10-01 17:03:33.374040','2025-10-01 17:06:21.775806','bd480a98-576f-45fb-8ac0-99b69f5787e0','bd480a98-576f-45fb-8ac0-99b69f5787e0','e17d9201-dace-4c98-9dab-80fdfbfad649','cephx','alice bob','ro','AQDhXt1ojlsXLBAAgD6/4JsqqMbqA9m55GCaiw=='),('2025-10-01 17:05:16.216631','2025-10-01 17:05:23.476729','2025-10-01 17:05:56.790034','c237f7d2-fbd9-44ee-8259-69c6d19dcaeb','c237f7d2-fbd9-44ee-8259-69c6d19dcaeb','b87e1026-6ce3-48d5-a1fd-8dc67c00f4d5','cephx','tempest-cephx-id-1818181793','rw','AQBNX91o32hMCxAA2T+yW+XZ3WwK5m3jjC02TA=='),('2025-10-01 17:05:34.935924','2025-10-01 17:05:49.059138','2025-10-01 17:06:03.714156','c5df958a-3e4c-4ad3-9ca5-e1ff9b364d16','c5df958a-3e4c-4ad3-9ca5-e1ff9b364d16','7b1893fd-a87d-4134-86a0-88945c063bc6','cephx','david','rw','AQBfX91o+pdTLRAAYOCwmr8SpmZ15EIzGxB9Mg=='),('2025-10-01 17:04:34.950518','2025-10-01 17:04:39.558145','2025-10-01 17:06:21.775806','e0a29d10-faa9-471c-950c-947a4a0709b7','e0a29d10-faa9-471c-950c-947a4a0709b7','e17d9201-dace-4c98-9dab-80fdfbfad649','cephx','alice','ro','AQAjX91oZue4OhAAzNKUreGkf8nE9Vd0NLeUhw=='),('2025-10-01 17:05:34.015129','2025-10-01 17:05:37.877794','2025-10-01 17:06:21.775806','e6c1b1f8-7d30-4807-a212-1147953bcfae','e6c1b1f8-7d30-4807-a212-1147953bcfae','e17d9201-dace-4c98-9dab-80fdfbfad649','cephx','alice_bob','rw','AQBfX91omFT4BhAAWBZLF8E/qcBpoO9UhJOP/Q=='),('2025-10-01 17:03:46.651071','2025-10-01 17:03:50.751714','2025-10-01 17:04:23.458816','e8eca402-2a31-4574-a43b-3cfe0a534266','e8eca402-2a31-4574-a43b-3cfe0a534266','6e112f49-7379-4e48-b00d-b9ada34f0c5d','cephx','tempest-cephx-id-26224483','rw','AQDzXt1o7ACOARAAzNUETWAsTolJpySagtLw0g=='),('2025-10-01 17:04:01.205259','2025-10-01 17:04:05.058433','2025-10-01 17:04:23.458816','f2d0a811-ee35-4de5-8793-442108474a46','f2d0a811-ee35-4de5-8793-442108474a46','6e112f49-7379-4e48-b00d-b9ada34f0c5d','cephx','tempest-cephx-id-26224483','rw','AQABX91o6jUZHxAAqJbbsk44pWDZIrwGwwMpnQ=='),('2025-10-01 17:05:41.947487','2025-10-01 17:06:01.094216','2025-10-01 17:06:01.516784','f82d2642-56e2-4844-9a3b-c9da9f758cea','f82d2642-56e2-4844-9a3b-c9da9f758cea','f5f63f5f-60e6-41b5-8df8-2523cbbf72e9','cephx','eve49','rw','AQBnX91ozuRsAxAAn85G3VSSTGJSb/lhR9QaUg=='),('2025-10-01 17:04:43.030932','2025-10-01 17:04:46.991744','2025-10-01 17:06:21.775806','fe5917ea-a34e-4896-908e-dc0e602f1816','fe5917ea-a34e-4896-908e-dc0e602f1816','e17d9201-dace-4c98-9dab-80fdfbfad649','cephx','alice_bob','rw','AQArX91o0QBkHRAA9XxAnwUiwHgrfOwyViBwbA==');
/*!40000 ALTER TABLE `share_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_access_rules_metadata`
--

DROP TABLE IF EXISTS `share_access_rules_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_access_rules_metadata` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `access_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `access_id` (`access_id`),
  CONSTRAINT `share_access_rules_metadata_ibfk_1` FOREIGN KEY (`access_id`) REFERENCES `share_access_map` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_access_rules_metadata`
--

LOCK TABLES `share_access_rules_metadata` WRITE;
/*!40000 ALTER TABLE `share_access_rules_metadata` DISABLE KEYS */;
INSERT INTO `share_access_rules_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `access_id`, `key`, `value`, `id`) VALUES ('2025-10-01 17:04:01.207378',NULL,'2025-10-01 17:04:05.350240','1','f2d0a811-ee35-4de5-8793-442108474a46','key1','v1',1),('2025-10-01 17:04:01.208183',NULL,'2025-10-01 17:04:05.350240','2','f2d0a811-ee35-4de5-8793-442108474a46','key2','v2',2),('2025-10-01 17:04:08.473273',NULL,'2025-10-01 17:04:18.624413','3','5ce4e6f1-b28d-4280-bfe8-fc5276d7794e','key1','v1',3),('2025-10-01 17:04:08.473665',NULL,'2025-10-01 17:04:18.624413','4','5ce4e6f1-b28d-4280-bfe8-fc5276d7794e','key2','v2',4),('2025-10-01 17:05:41.949275',NULL,'2025-10-01 17:06:01.392208','5','f82d2642-56e2-4844-9a3b-c9da9f758cea','key1','value1',5),('2025-10-01 17:05:41.949752','2025-10-01 17:05:59.923455','2025-10-01 17:06:01.392208','6','f82d2642-56e2-4844-9a3b-c9da9f758cea','key2','value6_new',6),('2025-10-01 17:05:45.335094',NULL,'2025-10-01 17:05:49.625511','7','69c3b21f-2848-42a0-928b-56f3b8b90b12','key3','v3',7),('2025-10-01 17:05:45.335543',NULL,'2025-10-01 17:05:49.625511','8','69c3b21f-2848-42a0-928b-56f3b8b90b12','key4','value4',8),('2025-10-01 17:05:52.375854','2025-10-01 17:05:55.919949','2025-10-01 17:05:57.190835','9','32687a93-f499-4c71-bbb0-34831ec685f6','key1','vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv',9),('2025-10-01 17:05:52.376483','2025-10-01 17:05:56.149020','2025-10-01 17:05:57.190835','10','32687a93-f499-4c71-bbb0-34831ec685f6','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value2',10),('2025-10-01 17:05:59.915907',NULL,'2025-10-01 17:06:01.392208','11','f82d2642-56e2-4844-9a3b-c9da9f758cea','key7','value7',11),('2025-10-01 17:06:15.208146',NULL,'2025-10-01 17:06:16.978277','12','501bf474-aafc-4fba-b910-7152afacff22','key1','value1',12);
/*!40000 ALTER TABLE `share_access_rules_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_share_type_mappings`
--

DROP TABLE IF EXISTS `share_group_share_type_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_share_type_mappings` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_group_id` varchar(36) DEFAULT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_sgstm_share_group_id` (`share_group_id`),
  KEY `fk_sgstm_share_type_id` (`share_type_id`),
  CONSTRAINT `fk_sgstm_share_group_id` FOREIGN KEY (`share_group_id`) REFERENCES `share_groups` (`id`),
  CONSTRAINT `fk_sgstm_share_type_id` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_share_type_mappings`
--

LOCK TABLES `share_group_share_type_mappings` WRITE;
/*!40000 ALTER TABLE `share_group_share_type_mappings` DISABLE KEYS */;
INSERT INTO `share_group_share_type_mappings` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `share_group_id`, `share_type_id`) VALUES ('1b98d217-0a00-40e9-a962-6f21000ed654','2025-10-01 17:07:41.230547',NULL,'2025-10-01 17:07:44.649526','1b98d217-0a00-40e9-a962-6f21000ed654','1a287eed-b2b2-4a6a-a484-5e9b49075f78','955aef9f-9d20-4cc2-94d6-c8222f9248a9'),('72063690-83cc-42e0-a369-ff5410654d87','2025-10-01 17:07:44.879011',NULL,'2025-10-01 17:07:48.274152','72063690-83cc-42e0-a369-ff5410654d87','897be154-b47e-498f-a0a1-97bcf60e50f1','955aef9f-9d20-4cc2-94d6-c8222f9248a9');
/*!40000 ALTER TABLE `share_group_share_type_mappings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_snapshots`
--

DROP TABLE IF EXISTS `share_group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_snapshots` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `share_group_id` varchar(36) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_share_group_snapshots_share_group_id` (`share_group_id`),
  CONSTRAINT `fk_share_group_snapshots_share_group_id` FOREIGN KEY (`share_group_id`) REFERENCES `share_groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_snapshots`
--

LOCK TABLES `share_group_snapshots` WRITE;
/*!40000 ALTER TABLE `share_group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_type_projects`
--

DROP TABLE IF EXISTS `share_group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sgtp_project_id_uc` (`share_group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `sgtp_id_fk` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_type_projects`
--

LOCK TABLES `share_group_type_projects` WRITE;
/*!40000 ALTER TABLE `share_group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_type_share_type_mappings`
--

DROP TABLE IF EXISTS `share_group_type_share_type_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_type_share_type_mappings` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_group_type_id` varchar(36) NOT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sgtp_id_sgt_id_uc` (`share_group_type_id`),
  KEY `sgtp_id_st_id_uc` (`share_type_id`),
  CONSTRAINT `sgtp_id_sgt_id_uc` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`),
  CONSTRAINT `sgtp_id_st_id_uc` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_type_share_type_mappings`
--

LOCK TABLES `share_group_type_share_type_mappings` WRITE;
/*!40000 ALTER TABLE `share_group_type_share_type_mappings` DISABLE KEYS */;
INSERT INTO `share_group_type_share_type_mappings` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `share_group_type_id`, `share_type_id`) VALUES ('7a74bd5d-71c5-4474-8de6-81a1e88b8713','2025-10-01 17:00:13.629347',NULL,'2025-10-01 17:00:45.190276','7a74bd5d-71c5-4474-8de6-81a1e88b8713','a173a83c-afb0-4815-9ad2-3308c6820e72','eeda9f95-f5c3-4f07-b12e-0b18f7c8da37'),('8ccd1cc7-03ed-4e54-868a-55eb0400b69f','2025-10-01 17:07:21.648788',NULL,'2025-10-01 17:08:06.310164','8ccd1cc7-03ed-4e54-868a-55eb0400b69f','4b060892-9ec2-4e0f-aece-605a21013a2d','955aef9f-9d20-4cc2-94d6-c8222f9248a9'),('8ed9340b-cc60-4400-b1a7-21a0606862a1','2025-10-01 17:07:22.208853',NULL,'2025-10-01 17:07:23.929352','8ed9340b-cc60-4400-b1a7-21a0606862a1','157b3287-57be-4881-8647-508eab5d09fd','c5f1a757-c5dd-4550-8037-f937f8c1f656'),('be25b3ba-e762-473e-b8ba-f71f10122486','2025-10-01 17:02:49.968564',NULL,'2025-10-01 17:03:24.920178','be25b3ba-e762-473e-b8ba-f71f10122486','84b5e6b1-f745-4b9f-be31-da41d0820aa0','d8069c93-ae97-4830-b977-fb7adaaba2b1');
/*!40000 ALTER TABLE `share_group_type_share_type_mappings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_type_specs`
--

DROP TABLE IF EXISTS `share_group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `spec_key` varchar(255) DEFAULT NULL,
  `spec_value` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sgtp_id_extra_specs_fk` (`share_group_type_id`),
  CONSTRAINT `sgtp_id_extra_specs_fk` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_type_specs`
--

LOCK TABLES `share_group_type_specs` WRITE;
/*!40000 ALTER TABLE `share_group_type_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_types`
--

DROP TABLE IF EXISTS `share_group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_types` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_share_group_type_name` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_types`
--

LOCK TABLES `share_group_types` WRITE;
/*!40000 ALTER TABLE `share_group_types` DISABLE KEYS */;
INSERT INTO `share_group_types` (`id`, `created_at`, `updated_at`, `deleted_at`, `is_public`, `name`, `deleted`) VALUES ('157b3287-57be-4881-8647-508eab5d09fd','2025-10-01 17:07:22.207760',NULL,'2025-10-01 17:07:23.932225',1,'tempest-unique_sgtype_name-1715452805','157b3287-57be-4881-8647-508eab5d09fd'),('4b060892-9ec2-4e0f-aece-605a21013a2d','2025-10-01 17:07:21.648210',NULL,'2025-10-01 17:08:06.313176',1,'tempest-unique_sgtype_name-172512270','4b060892-9ec2-4e0f-aece-605a21013a2d'),('84b5e6b1-f745-4b9f-be31-da41d0820aa0','2025-10-01 17:02:49.967504',NULL,'2025-10-01 17:03:24.923284',1,'tempest-unique_sgtype_name-933578829','84b5e6b1-f745-4b9f-be31-da41d0820aa0'),('a173a83c-afb0-4815-9ad2-3308c6820e72','2025-10-01 17:00:13.627949',NULL,'2025-10-01 17:00:45.197316',1,'tempest-unique_sgtype_name-501177772','a173a83c-afb0-4815-9ad2-3308c6820e72');
/*!40000 ALTER TABLE `share_group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_groups`
--

DROP TABLE IF EXISTS `share_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_groups` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `host` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `source_share_group_snapshot_id` varchar(36) DEFAULT NULL,
  `share_network_id` varchar(36) DEFAULT NULL,
  `share_server_id` varchar(36) DEFAULT NULL,
  `share_group_type_id` varchar(36) DEFAULT NULL,
  `consistent_snapshot_support` enum('pool','host') DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_share_group_share_network_id` (`share_network_id`),
  KEY `fk_share_group_share_server_id` (`share_server_id`),
  KEY `sgt_id_sg_id_uc` (`share_group_type_id`),
  CONSTRAINT `fk_share_group_share_network_id` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`),
  CONSTRAINT `fk_share_group_share_server_id` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`),
  CONSTRAINT `sgt_id_sg_id_uc` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_groups`
--

LOCK TABLES `share_groups` WRITE;
/*!40000 ALTER TABLE `share_groups` DISABLE KEYS */;
INSERT INTO `share_groups` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `user_id`, `project_id`, `host`, `name`, `description`, `status`, `source_share_group_snapshot_id`, `share_network_id`, `share_server_id`, `share_group_type_id`, `consistent_snapshot_support`, `availability_zone_id`) VALUES ('1a287eed-b2b2-4a6a-a484-5e9b49075f78','2025-10-01 17:07:41.338459','2025-10-01 17:07:44.647589','2025-10-01 17:07:44.646398','1a287eed-b2b2-4a6a-a484-5e9b49075f78','8395fbe4aa1a4d9bb181f7e321703f61','f63de858e3a74f88a78eaacea59850c5','hostgroup@cephfs#cephfs',NULL,NULL,'deleting',NULL,NULL,NULL,'4b060892-9ec2-4e0f-aece-605a21013a2d',NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e'),('897be154-b47e-498f-a0a1-97bcf60e50f1','2025-10-01 17:07:45.240707','2025-10-01 17:07:48.273279','2025-10-01 17:07:48.272706','897be154-b47e-498f-a0a1-97bcf60e50f1','8395fbe4aa1a4d9bb181f7e321703f61','f63de858e3a74f88a78eaacea59850c5','hostgroup@cephfs#cephfs',NULL,NULL,'deleting',NULL,NULL,NULL,'4b060892-9ec2-4e0f-aece-605a21013a2d',NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e');
/*!40000 ALTER TABLE `share_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instance_access_map`
--

DROP TABLE IF EXISTS `share_instance_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instance_access_map` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `share_instance_id` varchar(36) DEFAULT NULL,
  `access_id` varchar(36) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `siam_instance_fk` (`share_instance_id`),
  KEY `siam_access_fk` (`access_id`),
  CONSTRAINT `siam_access_fk` FOREIGN KEY (`access_id`) REFERENCES `share_access_map` (`id`),
  CONSTRAINT `siam_instance_fk` FOREIGN KEY (`share_instance_id`) REFERENCES `share_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instance_access_map`
--

LOCK TABLES `share_instance_access_map` WRITE;
/*!40000 ALTER TABLE `share_instance_access_map` DISABLE KEYS */;
INSERT INTO `share_instance_access_map` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_instance_id`, `access_id`, `state`) VALUES ('2025-10-01 17:04:34.970965','2025-10-01 17:04:39.883751','2025-10-01 17:04:39.882480','02048f78-e9f9-4d04-990f-58b35417ac5a','02048f78-e9f9-4d04-990f-58b35417ac5a','0fbcb4a0-2676-4b12-98ef-811f1d5718a9','e0a29d10-faa9-471c-950c-947a4a0709b7','deleted'),('2025-10-01 17:02:53.059142','2025-10-01 17:02:57.685929','2025-10-01 17:02:57.685186','025fdaa4-c50a-4220-9af2-8abc47058096','025fdaa4-c50a-4220-9af2-8abc47058096','0fbcb4a0-2676-4b12-98ef-811f1d5718a9','295aa06b-eadc-4962-8042-dc13913a026f','deleted'),('2025-10-01 17:04:05.584014','2025-10-01 17:04:10.427276','2025-10-01 17:04:10.426926','029535fa-9520-47dd-b87e-6cd85e79d2c4','029535fa-9520-47dd-b87e-6cd85e79d2c4','0fbcb4a0-2676-4b12-98ef-811f1d5718a9','8e6157f8-58a6-44bc-8b3f-e58d1745da45','deleted'),('2025-10-01 17:03:00.627611','2025-10-01 17:03:04.866454','2025-10-01 17:03:04.866115','03b43058-8d72-4997-a842-56f4ca52a286','03b43058-8d72-4997-a842-56f4ca52a286','0fbcb4a0-2676-4b12-98ef-811f1d5718a9','29f5aa20-c229-4e41-be93-463c13287000','deleted'),('2025-10-01 17:03:26.917896','2025-10-01 17:03:32.487963','2025-10-01 17:03:32.487451','04a566fd-661d-469e-8978-b972a50c41ff','04a566fd-661d-469e-8978-b972a50c41ff','0919941a-1ddb-4e3c-91a1-6d4450c6b2dd','33ae812d-f55f-440e-851d-96e6ba9d75cc','deleted'),('2025-10-01 17:05:34.948208','2025-10-01 17:05:49.395590','2025-10-01 17:05:49.395239','1aec5a11-ce67-4c4c-a8ed-6e26dc152d65','1aec5a11-ce67-4c4c-a8ed-6e26dc152d65','47b2be1b-8457-4141-a779-0c9e30960e86','c5df958a-3e4c-4ad3-9ca5-e1ff9b364d16','deleted'),('2025-10-01 17:04:08.482760','2025-10-01 17:04:18.618203','2025-10-01 17:04:18.617588','2133ce27-3ab0-4b44-b6d5-62447647c92b','2133ce27-3ab0-4b44-b6d5-62447647c92b','4554af13-83dd-4199-b167-2a7f1fff2e32','5ce4e6f1-b28d-4280-bfe8-fc5276d7794e','deleted'),('2025-10-01 17:04:57.641620','2025-10-01 17:05:05.537328','2025-10-01 17:05:05.537071','33e969ba-4aed-4044-8dbc-2b704e35c79e','33e969ba-4aed-4044-8dbc-2b704e35c79e','0fbcb4a0-2676-4b12-98ef-811f1d5718a9','65290de4-cc3e-4851-a63b-ebf277134b30','deleted'),('2025-10-01 17:05:25.649900','2025-10-01 17:05:32.387438','2025-10-01 17:05:32.386927','343605e6-d28c-49f0-8fcb-39c15136a57e','343605e6-d28c-49f0-8fcb-39c15136a57e','0fbcb4a0-2676-4b12-98ef-811f1d5718a9','12c26cbc-7c50-43f6-b7e1-6e9a114eb7c7','deleted'),('2025-10-01 17:05:54.971929','2025-10-01 17:05:59.516606','2025-10-01 17:05:59.516144','34a19c29-04a6-42e0-97fd-28da7c63d7ab','34a19c29-04a6-42e0-97fd-28da7c63d7ab','0fbcb4a0-2676-4b12-98ef-811f1d5718a9','5f7c543f-5d73-4f4b-a764-989a6828edfb','deleted'),('2025-10-01 17:05:52.391327','2025-10-01 17:05:57.188152','2025-10-01 17:05:57.187747','368df44e-4cd9-42b2-9e59-6d41dc78bf86','368df44e-4cd9-42b2-9e59-6d41dc78bf86','1c897d2a-1173-4d28-affc-8c999f770456','32687a93-f499-4c71-bbb0-34831ec685f6','deleted'),('2025-10-01 17:05:09.672931','2025-10-01 17:05:21.527881','2025-10-01 17:05:21.527528','426b212c-41ec-4354-bdcd-75ace73cf3a1','426b212c-41ec-4354-bdcd-75ace73cf3a1','f4359a50-b671-43df-8a71-afb168cd35b0','06c6b379-0a5b-4cc9-9942-bfa978696a35','deleted'),('2025-10-01 17:04:23.026204','2025-10-01 17:04:27.747886','2025-10-01 17:04:27.746997','4cb1d346-5f00-4354-b022-859188215b24','4cb1d346-5f00-4354-b022-859188215b24','0fbcb4a0-2676-4b12-98ef-811f1d5718a9','682e282e-e49f-4a6e-bb1b-d7233373ff3f','deleted'),('2025-10-01 17:03:58.321562','2025-10-01 17:04:02.554094','2025-10-01 17:04:02.553213','526d34b2-04c5-4d7a-ba93-8abc62be22c3','526d34b2-04c5-4d7a-ba93-8abc62be22c3','0fbcb4a0-2676-4b12-98ef-811f1d5718a9','9ec7bc76-9228-406d-a432-60b3409854a1','deleted'),('2025-10-01 17:04:59.487007','2025-10-01 17:05:29.275066','2025-10-01 17:05:29.274619','55afe311-c8db-44a1-8438-6fde7dbf8cc2','55afe311-c8db-44a1-8438-6fde7dbf8cc2','5c1c29e1-3838-4336-89e4-29126b32e8a3','2c60d281-0498-4ba3-b905-78f798577336','deleted'),('2025-10-01 17:05:41.965534','2025-10-01 17:06:01.389534','2025-10-01 17:06:01.388976','5679cf16-760d-4f91-a20b-d4adcb6a3650','5679cf16-760d-4f91-a20b-d4adcb6a3650','1c897d2a-1173-4d28-affc-8c999f770456','f82d2642-56e2-4844-9a3b-c9da9f758cea','deleted'),('2025-10-01 17:05:45.349252','2025-10-01 17:05:49.623789','2025-10-01 17:05:49.623348','572500df-c4e3-4217-b330-026349b785ab','572500df-c4e3-4217-b330-026349b785ab','1c897d2a-1173-4d28-affc-8c999f770456','69c3b21f-2848-42a0-928b-56f3b8b90b12','deleted'),('2025-10-01 17:03:51.402849','2025-10-01 17:03:55.455831','2025-10-01 17:03:55.455508','5e575f9f-2859-4e33-8c6f-31dbf7b3a110','5e575f9f-2859-4e33-8c6f-31dbf7b3a110','0fbcb4a0-2676-4b12-98ef-811f1d5718a9','131d98e6-f394-4a2b-9b99-2bd5adcf5c91','deleted'),('2025-10-01 17:05:08.110665','2025-10-01 17:05:16.733766','2025-10-01 17:05:16.733296','686a9bfd-14d8-453c-9546-2e96c376cdfb','686a9bfd-14d8-453c-9546-2e96c376cdfb','0fbcb4a0-2676-4b12-98ef-811f1d5718a9','37b09400-f840-4efa-a86e-62a3758caa34','deleted'),('2025-10-01 17:03:28.981860','2025-10-01 17:03:33.783705','2025-10-01 17:03:33.783233','7d5e92cd-c207-4a8c-956b-f38d4d225626','7d5e92cd-c207-4a8c-956b-f38d4d225626','0fbcb4a0-2676-4b12-98ef-811f1d5718a9','bd480a98-576f-45fb-8ac0-99b69f5787e0','deleted'),('2025-10-01 17:03:44.037277','2025-10-01 17:03:48.023959','2025-10-01 17:03:48.023619','890dc1dc-0859-48ef-8944-d42843dbb4b4','890dc1dc-0859-48ef-8944-d42843dbb4b4','0fbcb4a0-2676-4b12-98ef-811f1d5718a9','6c31e9e8-2bcd-486a-b7b3-5a88a66d196e','deleted'),('2025-10-01 17:05:48.079247','2025-10-01 17:05:51.892216','2025-10-01 17:05:51.891769','8c5b7e2b-25dd-414f-b919-59b7fc640f96','8c5b7e2b-25dd-414f-b919-59b7fc640f96','0fbcb4a0-2676-4b12-98ef-811f1d5718a9','2334f636-37b0-42a0-a11b-f78e63760cf2','deleted'),('2025-10-01 17:03:21.871450','2025-10-01 17:03:25.881160','2025-10-01 17:03:25.880707','8f51cc9b-79e4-42ed-9154-9c52c5707516','8f51cc9b-79e4-42ed-9154-9c52c5707516','0fbcb4a0-2676-4b12-98ef-811f1d5718a9','18fd645c-18cf-43e9-b072-647d69cb6d4a','deleted'),('2025-10-01 17:05:41.942837','2025-10-01 17:05:46.017697','2025-10-01 17:05:46.017344','932816c1-345c-4ec0-b2f9-e900f1f2fcdd','932816c1-345c-4ec0-b2f9-e900f1f2fcdd','90543113-872c-4287-b768-45f56fc8f849','69f69294-faef-4f4c-97aa-d8604b6d15e6','deleted'),('2025-10-01 17:03:14.922450','2025-10-01 17:03:18.882573','2025-10-01 17:03:18.882231','9c4e3c6b-9ef0-456c-a72d-6b8c7156aea2','9c4e3c6b-9ef0-456c-a72d-6b8c7156aea2','0fbcb4a0-2676-4b12-98ef-811f1d5718a9','576f1280-37ae-4005-a7b2-58916a2844be','deleted'),('2025-10-01 17:04:43.047847','2025-10-01 17:04:47.204775','2025-10-01 17:04:47.204299','9f7c364c-64bf-4688-ba18-e1613088982c','9f7c364c-64bf-4688-ba18-e1613088982c','0fbcb4a0-2676-4b12-98ef-811f1d5718a9','fe5917ea-a34e-4896-908e-dc0e602f1816','deleted'),('2025-10-01 17:06:09.663821','2025-10-01 17:06:13.796804','2025-10-01 17:06:13.796317','a07aed5b-931a-445e-a692-437aae910ff0','a07aed5b-931a-445e-a692-437aae910ff0','59fb41a6-024e-4d1c-873e-759037caf2c4','3991e0c0-0453-4fec-9452-90b0743175fd','deleted'),('2025-10-01 17:06:01.769762','2025-10-01 17:06:17.525335','2025-10-01 17:06:17.524951','a1533ced-2f36-4a18-ae07-6509453e8f5b','a1533ced-2f36-4a18-ae07-6509453e8f5b','0fbcb4a0-2676-4b12-98ef-811f1d5718a9','7931ccdd-dadf-47d1-984b-e10d694c231c','deleted'),('2025-10-01 17:03:46.668924','2025-10-01 17:03:50.988921','2025-10-01 17:03:50.988573','ab59ce73-e447-4a4f-b842-516bed83153b','ab59ce73-e447-4a4f-b842-516bed83153b','4554af13-83dd-4199-b167-2a7f1fff2e32','e8eca402-2a31-4574-a43b-3cfe0a534266','deleted'),('2025-10-01 17:05:16.230984','2025-10-01 17:05:24.105109','2025-10-01 17:05:24.104738','aea4d0df-d0aa-4857-b0a7-20c6bd8d0f63','aea4d0df-d0aa-4857-b0a7-20c6bd8d0f63','f4359a50-b671-43df-8a71-afb168cd35b0','c237f7d2-fbd9-44ee-8259-69c6d19dcaeb','deleted'),('2025-10-01 17:03:39.319761','2025-10-01 17:03:43.623464','2025-10-01 17:03:43.622946','b3fcaf79-100a-47b0-977c-201131e75405','b3fcaf79-100a-47b0-977c-201131e75405','e14aa593-425a-47dd-b300-8569859e6275','0bbc872f-15ae-4142-be84-fbb154655f77','deleted'),('2025-10-01 17:03:07.917734','2025-10-01 17:03:11.937383','2025-10-01 17:03:11.936731','bb0ee567-74ac-42fa-975c-85f0b3148388','bb0ee567-74ac-42fa-975c-85f0b3148388','0fbcb4a0-2676-4b12-98ef-811f1d5718a9','7ed02563-8e25-4ac2-b26f-42a39a18b339','deleted'),('2025-10-01 17:05:18.360754','2025-10-01 17:05:23.364485','2025-10-01 17:05:23.363344','c841c69c-89bd-4f40-a6e0-c412d77d842b','c841c69c-89bd-4f40-a6e0-c412d77d842b','0fbcb4a0-2676-4b12-98ef-811f1d5718a9','70035999-0d15-4793-9756-a12c0a89b7be','deleted'),('2025-10-01 17:04:50.325890','2025-10-01 17:04:54.738132','2025-10-01 17:04:54.737728','c8923ac7-146b-4c59-b6ad-bc14e2750213','c8923ac7-146b-4c59-b6ad-bc14e2750213','0fbcb4a0-2676-4b12-98ef-811f1d5718a9','86d130fb-d19b-4f1b-adf2-5fb260b37616','deleted'),('2025-10-01 17:03:54.085661','2025-10-01 17:03:58.260186','2025-10-01 17:03:58.259671','d9663269-afdf-4c06-846f-f002805667b3','d9663269-afdf-4c06-846f-f002805667b3','4554af13-83dd-4199-b167-2a7f1fff2e32','8319b4fa-b378-464e-b9e9-554fbc062d24','deleted'),('2025-10-01 17:04:01.227772','2025-10-01 17:04:05.348737','2025-10-01 17:04:05.348328','d989c79c-6234-4295-ae3c-471553e4a137','d989c79c-6234-4295-ae3c-471553e4a137','4554af13-83dd-4199-b167-2a7f1fff2e32','f2d0a811-ee35-4de5-8793-442108474a46','deleted'),('2025-10-01 17:05:31.122938','2025-10-01 17:06:03.611915','2025-10-01 17:06:03.611466','ddb29589-e4d5-43f3-b76d-2e3de9d0b61d','ddb29589-e4d5-43f3-b76d-2e3de9d0b61d','47b2be1b-8457-4141-a779-0c9e30960e86','8508e1fa-8ffb-4a9e-a555-24010a3620dd','deleted'),('2025-10-01 17:03:36.711697','2025-10-01 17:03:40.949832','2025-10-01 17:03:40.949500','e3d7a10d-e346-4fc4-ad45-a23c0d3fedff','e3d7a10d-e346-4fc4-ad45-a23c0d3fedff','0fbcb4a0-2676-4b12-98ef-811f1d5718a9','5836810c-bea9-4b9f-b810-72c525c48d1c','deleted'),('2025-10-01 17:05:41.190708','2025-10-01 17:05:45.270320','2025-10-01 17:05:45.269231','ea5d3aa4-4f85-4f53-8c2f-12a21a1a9227','ea5d3aa4-4f85-4f53-8c2f-12a21a1a9227','0fbcb4a0-2676-4b12-98ef-811f1d5718a9','00aae4e8-079c-4524-b9f2-be70307792e1','deleted'),('2025-10-01 17:05:34.027966','2025-10-01 17:05:38.197822','2025-10-01 17:05:38.197412','ea8b8ca8-74ce-4fce-a958-f706984d34bc','ea8b8ca8-74ce-4fce-a958-f706984d34bc','0fbcb4a0-2676-4b12-98ef-811f1d5718a9','e6c1b1f8-7d30-4807-a212-1147953bcfae','deleted'),('2025-10-01 17:04:12.853137','2025-10-01 17:04:22.703652','2025-10-01 17:04:22.703267','ec9ab394-3dac-4b71-972b-c60faf202ff2','ec9ab394-3dac-4b71-972b-c60faf202ff2','0fbcb4a0-2676-4b12-98ef-811f1d5718a9','8e1d645c-d310-47e4-8996-9cb9ff9ca8fe','deleted'),('2025-10-01 17:03:16.181196','2025-10-01 17:03:20.324892','2025-10-01 17:03:20.324486','ed29c37b-ad1b-4445-8174-006266696f1a','ed29c37b-ad1b-4445-8174-006266696f1a','b596d505-7972-465b-8b8f-82b926477693','745d9f0c-3b56-4455-9d06-30765803ee0d','deleted'),('2025-10-01 17:06:15.218086','2025-10-01 17:06:16.975962','2025-10-01 17:06:16.975549','f7d309b3-49cd-49c0-8842-2cdf3d462255','f7d309b3-49cd-49c0-8842-2cdf3d462255','73871f97-0e9f-4424-8c8d-1fc5d34e1441','501bf474-aafc-4fba-b910-7152afacff22','deleted');
/*!40000 ALTER TABLE `share_instance_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instance_export_locations`
--

DROP TABLE IF EXISTS `share_instance_export_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instance_export_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `path` varchar(2000) DEFAULT NULL,
  `share_instance_id` varchar(36) DEFAULT NULL,
  `is_admin_only` tinyint(1) DEFAULT NULL,
  `uuid` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `sel_instance_id_fk` (`share_instance_id`),
  CONSTRAINT `sel_instance_id_fk` FOREIGN KEY (`share_instance_id`) REFERENCES `share_instances` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instance_export_locations`
--

LOCK TABLES `share_instance_export_locations` WRITE;
/*!40000 ALTER TABLE `share_instance_export_locations` DISABLE KEYS */;
INSERT INTO `share_instance_export_locations` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `path`, `share_instance_id`, `is_admin_only`, `uuid`) VALUES (1,'2025-10-01 17:00:14.495550','2025-10-01 17:01:50.774069','2025-10-01 17:01:50.772653',1,'192.168.122.100:6789:/volumes/_nogroup/c469f818-07e0-4818-86b2-37da251687bb/7848796c-de25-4955-bc28-bf8744b5a870','c469f818-07e0-4818-86b2-37da251687bb',0,'f5ffd711-f27f-4d11-bed6-b591c4af092a'),(2,'2025-10-01 17:00:14.736889','2025-10-01 17:00:42.173973','2025-10-01 17:00:42.170698',2,'192.168.122.100:6789:/volumes/_nogroup/5954ec06-59c3-4fff-a9f8-48042027054b/cfb5a7ab-35d8-401c-b526-9ac5e5ab20e2','5954ec06-59c3-4fff-a9f8-48042027054b',0,'0dbb542f-3cb7-4403-acec-23ac715e67ad'),(3,'2025-10-01 17:00:16.601247','2025-10-01 17:00:38.414619','2025-10-01 17:00:38.413575',3,'192.168.122.100:6789:/volumes/_nogroup/8d007d9c-80e4-4e40-ac68-5fe06e924d50/e864fca7-f0a0-4662-a459-5ff0605d328c','8d007d9c-80e4-4e40-ac68-5fe06e924d50',0,'a8e7ec62-108f-4a5c-9a4f-506336851758'),(4,'2025-10-01 17:00:18.551131','2025-10-01 17:00:24.889865','2025-10-01 17:00:24.888777',4,'192.168.122.100:6789:/volumes/_nogroup/ad3738e8-3ae5-4ca0-bfa2-ec80b0780d33/b59a840b-9bd2-4374-8e26-08d2c78b7095','ad3738e8-3ae5-4ca0-bfa2-ec80b0780d33',0,'82bf963e-3d06-4ea9-9a76-3d7d9ecbe35f'),(5,'2025-10-01 17:00:18.699785','2025-10-01 17:00:23.014508','2025-10-01 17:00:23.013259',5,'192.168.122.100:6789:/volumes/_nogroup/b6442d06-c01f-49a2-aa90-70b48363f5f9/48a3c71b-dfaf-4779-b61c-42eb24e59a38','b6442d06-c01f-49a2-aa90-70b48363f5f9',0,'692166fc-c058-449b-9217-ab3b8a116e98'),(6,'2025-10-01 17:00:26.453787','2025-10-01 17:00:33.543841','2025-10-01 17:00:33.542832',6,'192.168.122.100:6789:/volumes/_nogroup/8803df6e-514e-40bf-8107-3891be3d00b0/005c38b0-6863-40cf-98f5-2e4233e6897d','8803df6e-514e-40bf-8107-3891be3d00b0',0,'df9e8a3a-d23c-4413-a83e-d51e35ecbba5'),(7,'2025-10-01 17:00:36.455611','2025-10-01 17:00:42.000589','2025-10-01 17:00:41.999459',7,'192.168.122.100:6789:/volumes/_nogroup/78560bf7-3bfe-43b8-a6d9-8fc4f7716ce5/5f9ea575-e1f2-48ab-8b78-df27af9cf85f','78560bf7-3bfe-43b8-a6d9-8fc4f7716ce5',0,'76178ec9-1791-49c8-a12c-ea79c3cceb3e'),(8,'2025-10-01 17:00:37.410834','2025-10-01 17:00:40.626317','2025-10-01 17:00:40.625514',8,'192.168.122.100:6789:/volumes/_nogroup/ae3b1acf-5bd9-4e7d-9dda-2786b242cb55/a2601120-1fea-402a-ae53-3c204f93794b','ae3b1acf-5bd9-4e7d-9dda-2786b242cb55',0,'804326ba-8c41-4a3f-8f13-f759e7e53d9b'),(9,'2025-10-01 17:00:41.084788','2025-10-01 17:00:46.378778','2025-10-01 17:00:46.377200',9,'192.168.122.100:6789:/volumes/_nogroup/fef691f7-09c0-4a8b-8ca5-0edd6d3edf1f/277d3d12-3acb-40c9-b070-96657cd52cc8','fef691f7-09c0-4a8b-8ca5-0edd6d3edf1f',0,'949f4fe9-dfb0-41fb-86ef-1487c8935335'),(10,'2025-10-01 17:00:44.979816','2025-10-01 17:00:47.809099','2025-10-01 17:00:47.807767',10,'192.168.122.100:6789:/volumes/_nogroup/3394bfe3-ff37-4de3-a0d3-c419f1e9c40a/14419a13-23ba-400d-adbd-b40d3bc11aaf','3394bfe3-ff37-4de3-a0d3-c419f1e9c40a',0,'68d6b24a-1986-4fc1-961a-a14295fc3d8f'),(11,'2025-10-01 17:01:02.490914','2025-10-01 17:01:18.171886','2025-10-01 17:01:18.170495',11,'192.168.122.100:6789:/volumes/_nogroup/76e4be4c-744e-45f7-a850-fa855b7c5552/4f6fb2f3-df1d-4056-b267-fbdddd7db2e9','76e4be4c-744e-45f7-a850-fa855b7c5552',0,'b5031615-f46d-401d-b62b-ea9bdf8f7e4f'),(12,'2025-10-01 17:01:13.336841','2025-10-01 17:01:17.112563','2025-10-01 17:01:17.111553',12,'192.168.122.100:6789:/volumes/_nogroup/d0586e81-22a4-46d7-91b6-618299744cd8/f1b8fa86-163b-4ff4-a749-b9b3275345c7','d0586e81-22a4-46d7-91b6-618299744cd8',0,'911a14d0-a81e-427d-8809-e9d52e96c720'),(13,'2025-10-01 17:01:25.805705','2025-10-01 17:02:12.573998','2025-10-01 17:02:12.573093',13,'192.168.122.100:6789:/volumes/_nogroup/93b513ed-8592-46d2-ae45-b578c4708055/49bc7a7c-014e-4e9c-8b9f-a9c00a0f0993','93b513ed-8592-46d2-ae45-b578c4708055',0,'0a90275c-aa39-447f-a21d-1fd5afde1428'),(14,'2025-10-01 17:01:27.223411','2025-10-01 17:01:43.296500','2025-10-01 17:01:43.295579',14,'192.168.122.100:6789:/volumes/_nogroup/c5ae6d5e-ebae-47c0-867d-5722bbee2320/8aabb7c2-60ce-4c7d-ac38-4e5466451baa','c5ae6d5e-ebae-47c0-867d-5722bbee2320',0,'db474556-a4ab-4203-8f2c-adc671b3c7f1'),(15,'2025-10-01 17:01:55.263273','2025-10-01 17:02:06.324848','2025-10-01 17:02:06.323820',15,'192.168.122.100:6789:/volumes/_nogroup/9cd665eb-c288-4c00-89a5-5693af445149/092f8be5-0c9d-47b1-b19e-98acc21acd6d','9cd665eb-c288-4c00-89a5-5693af445149',0,'30ed1086-a7b7-49c5-8733-0aaa5b28753b'),(16,'2025-10-01 17:02:00.319541','2025-10-01 17:02:05.480278','2025-10-01 17:02:05.478976',16,'192.168.122.100:6789:/volumes/_nogroup/a5f570e8-f76e-482d-b0fa-146c6f6d8dd3/94ce63e3-c262-4e88-805f-e02ee4fbcabe','a5f570e8-f76e-482d-b0fa-146c6f6d8dd3',0,'3544ca4d-1f28-4877-888e-0117b96c5903'),(17,'2025-10-01 17:02:00.633219','2025-10-01 17:02:50.874094','2025-10-01 17:02:50.872953',17,'192.168.122.100:6789:/volumes/_nogroup/29bcbd73-54c4-429e-b29a-68e1af0b3512/9d1bbfa0-2880-4315-a414-5b33d3e965d3','29bcbd73-54c4-429e-b29a-68e1af0b3512',0,'28a0fcad-a9af-43f8-b866-6b4ce101f68d'),(18,'2025-10-01 17:02:00.634939','2025-10-01 17:02:02.690457','2025-10-01 17:02:02.689273',18,'192.168.122.100:6789:/volumes/_nogroup/52ee1ac4-a3b4-464a-84cf-883d69e24a62/2a8b15b7-e0a5-4dfc-9733-dee20102f986','52ee1ac4-a3b4-464a-84cf-883d69e24a62',0,'aaf8255a-9361-4446-a9ef-325b0228d435'),(19,'2025-10-01 17:02:02.898487','2025-10-01 17:02:07.282657','2025-10-01 17:02:07.281001',19,'192.168.122.100:6789:/volumes/_nogroup/cd48652d-071f-468a-8c02-77f78f7bd8e7/83a662fd-919b-44c3-a25e-d73dd80b127a','cd48652d-071f-468a-8c02-77f78f7bd8e7',0,'f64bc91c-2edf-4152-a124-057596891aa1'),(20,'2025-10-01 17:02:10.131785','2025-10-01 17:02:14.307021','2025-10-01 17:02:14.305856',20,'192.168.122.100:6789:/volumes/_nogroup/3096acfb-193c-4e04-82fb-a593edc05063/5b9589c8-b123-489f-9571-0135ea60d053','3096acfb-193c-4e04-82fb-a593edc05063',0,'0373fc8f-f33a-48a9-9fe6-cfc3f3d6ac30'),(21,'2025-10-01 17:02:10.947511','2025-10-01 17:02:15.641394','2025-10-01 17:02:15.639575',21,'192.168.122.100:6789:/volumes/_nogroup/127b3cca-8ccf-4e68-a7e5-ce47f71b0e6b/bdac944f-8d22-4d5d-a483-7eb61af3c04f','127b3cca-8ccf-4e68-a7e5-ce47f71b0e6b',0,'5a5e2db9-5ce5-414e-a768-2bd55e4f5deb'),(22,'2025-10-01 17:02:12.471022','2025-10-01 17:02:24.628609','2025-10-01 17:02:24.627380',22,'192.168.122.100:6789:/volumes/_nogroup/aef1d813-6fa0-431e-85ff-6739a4057903/2f2b346c-8e64-42da-bcc3-4d077546d978','aef1d813-6fa0-431e-85ff-6739a4057903',0,'618f635a-d1c0-472d-add0-f8ba3ff034ef'),(23,'2025-10-01 17:02:19.618309','2025-10-01 17:02:23.133359','2025-10-01 17:02:23.132279',23,'192.168.122.100:6789:/volumes/_nogroup/46dae3a3-bd69-43bd-9813-cd1117c66c7c/02af0052-5ebf-4088-aa25-a69c7a4ccac1','46dae3a3-bd69-43bd-9813-cd1117c66c7c',0,'f4386a59-9088-4c53-9b74-895754c4c3c6'),(24,'2025-10-01 17:02:27.013379','2025-10-01 17:02:32.289041','2025-10-01 17:02:32.286523',24,'192.168.122.100:6789:/volumes/_nogroup/ecd5683e-7c6f-403f-a027-c9731cd1c5fb/65e70db1-6ebb-4f09-9202-8d668fda666e','ecd5683e-7c6f-403f-a027-c9731cd1c5fb',0,'a2e51ba3-d1ca-4a96-8377-a6c5294c6e2d'),(25,'2025-10-01 17:02:29.724915','2025-10-01 17:02:34.412449','2025-10-01 17:02:34.411586',25,'192.168.122.100:6789:/volumes/_nogroup/b8ad6a25-2c76-4709-bb24-c02c6f27169d/6ffd18d6-c021-4445-87ad-21cf76ca9007','b8ad6a25-2c76-4709-bb24-c02c6f27169d',0,'55817ae1-e7af-496b-908b-0bcb7cbeacb7'),(26,'2025-10-01 17:02:38.296898','2025-10-01 17:02:44.422381','2025-10-01 17:02:44.421450',26,'192.168.122.100:6789:/volumes/_nogroup/dbc2114d-a89a-4156-8432-271ef7164acc/a9d64e73-6d99-4e8c-843e-d1a57cc50a8d','dbc2114d-a89a-4156-8432-271ef7164acc',0,'a899078c-770f-4b22-b9d7-3aab4abc86d9'),(27,'2025-10-01 17:02:49.886162','2025-10-01 17:06:21.744598','2025-10-01 17:06:21.743165',27,'192.168.122.100:6789:/volumes/_nogroup/0fbcb4a0-2676-4b12-98ef-811f1d5718a9/6bc94b15-f41b-47df-bdd9-fc9b59ccd4a1','0fbcb4a0-2676-4b12-98ef-811f1d5718a9',0,'2d512471-8256-427a-a3e1-5ec3f6cf125a'),(28,'2025-10-01 17:02:52.007703','2025-10-01 17:03:00.907928','2025-10-01 17:03:00.906679',28,'192.168.122.100:6789:/volumes/_nogroup/d82a03d3-ac0e-4c77-9123-db50d46e8e91/48502615-e44c-4693-99db-d0a51d1a6004','d82a03d3-ac0e-4c77-9123-db50d46e8e91',0,'2576269a-dd8b-42fe-a9d5-645c66db1a12'),(29,'2025-10-01 17:02:57.175464','2025-10-01 17:03:04.397113','2025-10-01 17:03:04.396135',29,'192.168.122.100:6789:/volumes/_nogroup/cfcadb50-45a4-4b1d-8651-7ec7bda466b1/e034139b-15f5-4811-8ae4-2f54144b1ef8','cfcadb50-45a4-4b1d-8651-7ec7bda466b1',0,'5bf21036-602f-4690-a336-0194b8d0aeb5'),(30,'2025-10-01 17:03:08.720504','2025-10-01 17:04:23.367732','2025-10-01 17:04:23.366673',30,'192.168.122.100:6789:/volumes/_nogroup/4554af13-83dd-4199-b167-2a7f1fff2e32/de9708af-1bcd-4a03-baf2-2fa9bfaca9fe','4554af13-83dd-4199-b167-2a7f1fff2e32',0,'6128c09d-1070-4027-a53e-9e14d93f9609'),(31,'2025-10-01 17:03:12.975742','2025-10-01 17:03:20.438007','2025-10-01 17:03:20.436927',31,'192.168.122.100:6789:/volumes/_nogroup/b596d505-7972-465b-8b8f-82b926477693/dec8c348-a88e-4722-a1a2-25b1f0501b74','b596d505-7972-465b-8b8f-82b926477693',0,'b99fd938-2dc4-48d3-9660-a4436704b9ec'),(32,'2025-10-01 17:03:23.664684','2025-10-01 17:03:32.694590','2025-10-01 17:03:32.693481',32,'192.168.122.100:6789:/volumes/_nogroup/0919941a-1ddb-4e3c-91a1-6d4450c6b2dd/b02fbf2a-0398-4e24-a337-d8cbc1e3781f','0919941a-1ddb-4e3c-91a1-6d4450c6b2dd',0,'4d509967-1e02-40fc-9507-7727cdea9164'),(33,'2025-10-01 17:03:36.251549','2025-10-01 17:03:43.738298','2025-10-01 17:03:43.736931',33,'192.168.122.100:6789:/volumes/_nogroup/e14aa593-425a-47dd-b300-8569859e6275/4e937636-ec4f-4e12-8ac3-3c57313b7bf8','e14aa593-425a-47dd-b300-8569859e6275',0,'0a254511-dfe0-4c1b-a7ed-f94b2fc31d69'),(34,'2025-10-01 17:03:53.752127','2025-10-01 17:04:09.567335','2025-10-01 17:04:09.565917',34,'192.168.122.100:6789:/volumes/_nogroup/05ea150c-46e1-4db5-bef4-041e811a35f2/979f4059-f7e6-4542-8495-21fdccf08557','05ea150c-46e1-4db5-bef4-041e811a35f2',0,'39abc517-3bff-4649-a0f7-7bb49a32d231'),(35,'2025-10-01 17:04:13.147164','2025-10-01 17:04:19.453889','2025-10-01 17:04:19.452698',35,'192.168.122.100:6789:/volumes/_nogroup/6a6b0432-ea25-4083-8cff-afe449e66429/185d7d87-1c33-4633-82d4-c1c2b59c4088','6a6b0432-ea25-4083-8cff-afe449e66429',0,'0ef73fd5-abcc-440d-ab95-5fd272a23837'),(36,'2025-10-01 17:04:25.104955','2025-10-01 17:04:35.463241','2025-10-01 17:04:35.462355',36,'192.168.122.100:6789:/volumes/_nogroup/4850b31b-d69e-4e1f-a8c0-08812bc9688d/9578abb4-f455-47f2-b472-5fa3e4df038e','4850b31b-d69e-4e1f-a8c0-08812bc9688d',0,'25af5c62-1d4e-455d-a858-619fa80cd02d'),(37,'2025-10-01 17:04:53.192912','2025-10-01 17:06:03.696075','2025-10-01 17:06:03.695127',37,'192.168.122.100:6789:/volumes/_nogroup/47b2be1b-8457-4141-a779-0c9e30960e86/103fa946-2c7f-48e4-9385-b7cf2236d2f2','47b2be1b-8457-4141-a779-0c9e30960e86',0,'61231b7e-64c1-4312-bbf9-fbe71e01bf66'),(38,'2025-10-01 17:04:54.983874','2025-10-01 17:05:29.341592','2025-10-01 17:05:29.340696',38,'192.168.122.100:6789:/volumes/_nogroup/72e3096d-d9f8-4227-b53d-59ed09f4fa07/c833704b-ee21-4c40-8598-03461f2f7261','72e3096d-d9f8-4227-b53d-59ed09f4fa07',0,'7d9a0160-72e8-4856-8bd4-3404ad3c2cdd'),(39,'2025-10-01 17:04:56.514297','2025-10-01 17:06:00.083802','2025-10-01 17:06:00.082652',39,'192.168.122.100:6789:/volumes/_nogroup/5c1c29e1-3838-4336-89e4-29126b32e8a3/6880fe2f-c522-4c39-a5e0-71e5bd9f0ff3','5c1c29e1-3838-4336-89e4-29126b32e8a3',0,'662c9fa4-e719-4191-ada0-be41faa0f824'),(40,'2025-10-01 17:04:59.026346','2025-10-01 17:05:25.083747','2025-10-01 17:05:25.082624',40,'192.168.122.100:6789:/volumes/_nogroup/5215a169-5994-425c-a184-e62fdc22c149/3ac93a20-57ca-43b2-b8c4-3207e43edaa8','5215a169-5994-425c-a184-e62fdc22c149',0,'8d912887-46b0-45dd-b656-29402f1f9b4f'),(41,'2025-10-01 17:05:08.542317','2025-10-01 17:05:56.759575','2025-10-01 17:05:56.757996',41,'192.168.122.100:6789:/volumes/_nogroup/f4359a50-b671-43df-8a71-afb168cd35b0/b045be5c-ec65-49ca-b68d-4dfa56f47772','f4359a50-b671-43df-8a71-afb168cd35b0',0,'0c0da93e-2d6c-4e95-b174-0f5ebfcd83dc'),(42,'2025-10-01 17:05:08.584667','2025-10-01 17:05:21.585884','2025-10-01 17:05:21.584563',42,'192.168.122.100:6789:/volumes/_nogroup/ff4382dd-2fca-4301-a194-9666d40ecd5f/7fa874aa-6437-47e0-8543-223a3fd71849','ff4382dd-2fca-4301-a194-9666d40ecd5f',0,'a865bcba-2465-40c4-b725-e388799a988e'),(43,'2025-10-01 17:05:14.176263','2025-10-01 17:05:18.149575','2025-10-01 17:05:18.148561',43,'192.168.122.100:6789:/volumes/_nogroup/885343a2-ae40-4dfa-a601-01b84b6596ee/8ebb0ed9-a1f9-4c4f-9677-0b2717aaf517','885343a2-ae40-4dfa-a601-01b84b6596ee',0,'8590a09f-de4d-40b9-8ef3-77ba9378a836'),(44,'2025-10-01 17:05:38.819281','2025-10-01 17:06:01.497389','2025-10-01 17:06:01.496307',44,'192.168.122.100:6789:/volumes/_nogroup/1c897d2a-1173-4d28-affc-8c999f770456/6a685f3e-18b7-4295-a517-5103fbf2a8f4','1c897d2a-1173-4d28-affc-8c999f770456',0,'5d61f0d6-b13e-43cc-8507-e2ea21e3ae0c'),(45,'2025-10-01 17:05:38.860857','2025-10-01 17:05:53.302807','2025-10-01 17:05:53.294753',45,'192.168.122.100:6789:/volumes/_nogroup/90543113-872c-4287-b768-45f56fc8f849/d840e995-dc57-43c1-a20c-f46f70fbb2fc','90543113-872c-4287-b768-45f56fc8f849',0,'bad98748-fd88-470e-84ba-70b16584186a'),(46,'2025-10-01 17:05:42.143989','2025-10-01 17:06:36.395338','2025-10-01 17:06:36.393647',46,'192.168.122.100:6789:/volumes/_nogroup/ea26f47e-6032-4f84-85c8-3aa43d68e5c0/65153669-9d75-49d3-8d7f-88b1558a171f','ea26f47e-6032-4f84-85c8-3aa43d68e5c0',0,'fc9294de-bf85-4438-a6fe-3dd99f45826e'),(47,'2025-10-01 17:06:06.676574','2025-10-01 17:06:06.675291',NULL,0,'192.168.122.100:6789:/volumes/_nogroup/59fb41a6-024e-4d1c-873e-759037caf2c4/651f80d7-2152-4119-82f1-a3dc272356ed','59fb41a6-024e-4d1c-873e-759037caf2c4',0,'4032e419-ffdd-4f01-b475-947cccefd152'),(48,'2025-10-01 17:06:12.058512','2025-10-01 17:06:17.134681','2025-10-01 17:06:17.132371',48,'192.168.122.100:6789:/volumes/_nogroup/73871f97-0e9f-4424-8c8d-1fc5d34e1441/7881a37b-f5b6-44e9-9c84-a8bd52bfbee7','73871f97-0e9f-4424-8c8d-1fc5d34e1441',0,'913a6e3a-d435-42e1-bc77-c3bb34c76b68'),(49,'2025-10-01 17:06:36.912359','2025-10-01 17:06:42.430656','2025-10-01 17:06:42.429620',49,'192.168.122.100:6789:/volumes/_nogroup/b17b9bf4-9e5c-492b-a894-4f295f7cb7dd/7538063e-057e-4780-bbe2-782a2e5f1e77','b17b9bf4-9e5c-492b-a894-4f295f7cb7dd',0,'f1009bbe-025f-42c0-acba-59477cbc16d7'),(50,'2025-10-01 17:06:38.464902','2025-10-01 17:06:49.526220','2025-10-01 17:06:49.525293',50,'192.168.122.100:6789:/volumes/_nogroup/297fd041-f36f-460b-b2b8-961d2f4e4832/ebea2176-a491-45a8-984d-5070f403197a','297fd041-f36f-460b-b2b8-961d2f4e4832',0,'19fc5577-1aae-4b60-bb70-2b228e847c7f'),(51,'2025-10-01 17:06:53.874262','2025-10-01 17:06:58.946751','2025-10-01 17:06:58.945900',51,'192.168.122.100:6789:/volumes/_nogroup/2f222ba4-6cc6-4b5d-9beb-b4ad27457477/d0c16511-d282-41ee-bc41-9d0247ee2433','2f222ba4-6cc6-4b5d-9beb-b4ad27457477',0,'c42f2829-6e16-41a8-b26e-f917c1a71797'),(52,'2025-10-01 17:06:58.851408','2025-10-01 17:07:12.395246','2025-10-01 17:07:12.393346',52,'192.168.122.100:6789:/volumes/_nogroup/efdb0876-5085-415d-ba20-1a51461b6ac1/f37fbf2d-1f8c-4493-9c7d-249256af4c53','efdb0876-5085-415d-ba20-1a51461b6ac1',0,'27545318-6682-422d-ae22-044841ae4814'),(53,'2025-10-01 17:07:02.177727','2025-10-01 17:08:13.641959','2025-10-01 17:08:13.640346',53,'192.168.122.100:6789:/volumes/_nogroup/7eafcb7a-4d98-4306-a178-8f37dd36887c/54f21604-7216-436f-9083-3ff149648db9','7eafcb7a-4d98-4306-a178-8f37dd36887c',0,'d3eb38eb-dc9d-4908-b1f7-00ad48218837'),(54,'2025-10-01 17:07:27.068189','2025-10-01 17:07:38.029177','2025-10-01 17:07:38.028024',54,'192.168.122.100:6789:/volumes/_nogroup/a69f0a4d-9f3f-4666-81e2-d1b6803ae7a8/1437c8ea-0e27-486b-ba50-1ec3efb0aca8','a69f0a4d-9f3f-4666-81e2-d1b6803ae7a8',0,'b31d593a-5780-4954-bda6-df9adfa688be'),(55,'2025-10-01 17:07:31.132439','2025-10-01 17:07:34.765068','2025-10-01 17:07:34.763681',55,'192.168.122.100:6789:/volumes/_nogroup/a4bff048-9ed8-4cdd-9086-a185cea04d3c/5f87b1d6-57e0-427f-8455-262a3f7272ef','a4bff048-9ed8-4cdd-9086-a185cea04d3c',0,'550232f7-6c6a-43c4-8062-278fdac4ce87'),(56,'2025-10-01 17:07:33.565523','2025-10-01 17:08:30.081098','2025-10-01 17:08:30.079722',56,'192.168.122.100:6789:/volumes/_nogroup/afbc5b28-4a3d-4f5a-9775-80288db0083b/f2e1b76b-dec4-48f7-ab50-650fa9ac6e68','afbc5b28-4a3d-4f5a-9775-80288db0083b',0,'91f2e7ef-170f-4894-9320-533d95f2008a'),(57,'2025-10-01 17:07:41.625440','2025-10-01 17:07:45.520731','2025-10-01 17:07:45.519529',57,'192.168.122.100:6789:/volumes/_nogroup/b8cb71a4-9f4b-4317-bdd2-cb9e0a520e09/a9e5d79d-e027-4866-8e26-e803d8da9bab','b8cb71a4-9f4b-4317-bdd2-cb9e0a520e09',0,'7b04bcda-b35d-4da8-9ace-43716a4b8bf6'),(58,'2025-10-01 17:07:49.000631','2025-10-01 17:07:52.560781','2025-10-01 17:07:52.556739',58,'192.168.122.100:6789:/volumes/_nogroup/ebb81bb7-5ad0-430e-bce8-857817637159/2d450d70-e6be-4e54-bc55-98a697765d82','ebb81bb7-5ad0-430e-bce8-857817637159',0,'2f0e9e07-b043-4959-b0fa-f19d1094e75b'),(59,'2025-10-01 17:07:49.337597','2025-10-01 17:07:52.981519','2025-10-01 17:07:52.980069',59,'192.168.122.100:6789:/volumes/_nogroup/dda50ff1-4d8c-4915-a4cd-5da1c827bac3/00c7b142-8976-44b8-b55f-64523acb7621','dda50ff1-4d8c-4915-a4cd-5da1c827bac3',0,'b3ebc103-077a-4609-ac33-314e873ecc76'),(60,'2025-10-01 17:08:00.240623','2025-10-01 17:08:03.431887','2025-10-01 17:08:03.430967',60,'192.168.122.100:6789:/volumes/_nogroup/b3a00dd2-1018-47de-9729-c563b1ade8d1/006cbd5a-fd22-4b11-967f-3c1a5049e2ed','b3a00dd2-1018-47de-9729-c563b1ade8d1',0,'649954db-8b22-4e23-8045-24ddef1d11ee'),(61,'2025-10-01 17:08:00.506353','2025-10-01 17:08:03.275486','2025-10-01 17:08:03.274207',61,'192.168.122.100:6789:/volumes/_nogroup/df8b44c3-6adf-44f9-88cd-1ac785cf76d5/158163d4-3fe0-413f-a55b-2745557b9901','df8b44c3-6adf-44f9-88cd-1ac785cf76d5',0,'724c0130-eda8-4c79-a565-c576fdd528cb'),(62,'2025-10-01 17:08:00.508129','2025-10-01 17:08:02.634330','2025-10-01 17:08:02.633493',62,'192.168.122.100:6789:/volumes/_nogroup/697d2422-31c0-4917-8660-133fa4e39c6e/564cd217-12ec-48ac-a000-eaa8c6e7b0ef','697d2422-31c0-4917-8660-133fa4e39c6e',0,'1bd069ce-7b22-45bb-8d1d-91b70d1f7002'),(63,'2025-10-01 17:08:11.358277','2025-10-01 17:08:14.027674','2025-10-01 17:08:14.026784',63,'192.168.122.100:6789:/volumes/_nogroup/267a009d-a8d2-496f-8ea4-b7694aa0a844/092f2b00-dbde-4490-88db-37cb462bfce5','267a009d-a8d2-496f-8ea4-b7694aa0a844',0,'bf6a3db0-5190-452b-b1c0-a4c4d27bfe58'),(64,'2025-10-01 17:08:17.665975','2025-10-01 17:08:21.439603','2025-10-01 17:08:21.438484',64,'192.168.122.100:6789:/volumes/_nogroup/09ee21e6-5d89-4173-b2b4-f6be5a3351ee/5da16ed5-a406-4749-bece-e967338d32e3','09ee21e6-5d89-4173-b2b4-f6be5a3351ee',0,'fc3c9c0e-77b7-426d-8959-a39216536e30'),(65,'2025-10-01 17:08:27.258038','2025-10-01 17:09:46.932771','2025-10-01 17:09:46.931886',65,'192.168.122.100:6789:/volumes/_nogroup/8bab47f1-016a-4c5f-8b58-46e57c02ad64/a3f4a43a-ff4d-4720-991f-35deb0990245','8bab47f1-016a-4c5f-8b58-46e57c02ad64',0,'f7a79d3d-4efe-4498-b918-b41bca367cc2'),(66,'2025-10-01 17:08:53.751464','2025-10-01 17:09:06.164751','2025-10-01 17:09:06.163254',66,'192.168.122.100:6789:/volumes/_nogroup/f1653434-fb19-4bc0-85ed-a5473c6d290d/5ede0277-0295-494c-8534-1d48f6494b3f','f1653434-fb19-4bc0-85ed-a5473c6d290d',0,'69837981-f084-4572-8c4f-21374feb59d1'),(67,'2025-10-01 17:08:56.423532','2025-10-01 17:09:40.386676','2025-10-01 17:09:40.385512',67,'192.168.122.100:6789:/volumes/_nogroup/8814b9a0-ee27-4d85-bc47-1d08537fe868/636cf65b-e4ac-4299-bc82-8f8b9c2d6caa','8814b9a0-ee27-4d85-bc47-1d08537fe868',0,'0b48d3a1-9fec-4680-ab56-d576f920adf5'),(68,'2025-10-01 17:08:59.351684','2025-10-01 17:09:07.466899','2025-10-01 17:09:07.465711',68,'192.168.122.100:6789:/volumes/_nogroup/60e01a62-d5ac-404d-b890-d73b6e36f5cd/f708a815-791e-4c67-8748-fbe083525910','60e01a62-d5ac-404d-b890-d73b6e36f5cd',0,'495094fa-1523-488c-bcb1-4d8d4ad9c773'),(69,'2025-10-01 17:09:11.246547','2025-10-01 17:09:24.163570','2025-10-01 17:09:24.158608',69,'192.168.122.100:6789:/volumes/_nogroup/b4fd18da-d185-4d9e-9718-4a7a16198c6c/e96d1dbd-069e-4094-a468-ff0861764e9e','b4fd18da-d185-4d9e-9718-4a7a16198c6c',0,'fb301948-6d2c-42a1-8838-c86f15279e43'),(70,'2025-10-01 17:09:18.128959','2025-10-01 17:09:27.690944','2025-10-01 17:09:27.689624',70,'192.168.122.100:6789:/volumes/_nogroup/7262037d-5a43-4a8e-99a6-10daf7eb5d63/3c14a114-f821-4fa9-9f7e-cf083af00518','7262037d-5a43-4a8e-99a6-10daf7eb5d63',0,'3eec0233-096a-4478-b567-fb7c5616d799'),(71,'2025-10-01 17:09:31.842530','2025-10-01 17:09:36.870847','2025-10-01 17:09:36.869567',71,'192.168.122.100:6789:/volumes/_nogroup/bdd25bd8-509d-48a7-9a62-5485c6f3d21a/3a924d88-bfd0-4726-bb32-a77f17894b9a','bdd25bd8-509d-48a7-9a62-5485c6f3d21a',0,'745c8347-5705-4e8b-867d-ff77848cdba9'),(72,'2025-10-01 17:09:36.688438','2025-10-01 17:09:48.229096','2025-10-01 17:09:48.227507',72,'192.168.122.100:6789:/volumes/_nogroup/0f3443b9-e9d9-4a47-839c-8c53679a0f3e/b01760f7-180f-4a69-9893-0812fc9afee7','0f3443b9-e9d9-4a47-839c-8c53679a0f3e',0,'d7409300-fd3b-47ab-ae7d-a239b777390a'),(73,'2025-10-01 17:10:00.100823','2025-10-01 17:10:11.014747','2025-10-01 17:10:11.013720',73,'192.168.122.100:6789:/volumes/_nogroup/d5107ec8-a115-44fa-8f38-14e43f7ac582/b957358f-df1f-4e3f-a923-47597d668d97','d5107ec8-a115-44fa-8f38-14e43f7ac582',0,'b40ac914-07db-4316-976c-fc7704c9f5ad');
/*!40000 ALTER TABLE `share_instance_export_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instance_export_locations_metadata`
--

DROP TABLE IF EXISTS `share_instance_export_locations_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instance_export_locations_metadata` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `export_location_id` int(11) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `elm_el_id_uc` (`export_location_id`,`key`,`deleted`),
  CONSTRAINT `elm_id_fk` FOREIGN KEY (`export_location_id`) REFERENCES `share_instance_export_locations` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instance_export_locations_metadata`
--

LOCK TABLES `share_instance_export_locations_metadata` WRITE;
/*!40000 ALTER TABLE `share_instance_export_locations_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_instance_export_locations_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instances`
--

DROP TABLE IF EXISTS `share_instances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instances` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `share_id` varchar(36) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `share_network_id` varchar(36) DEFAULT NULL,
  `share_server_id` varchar(36) DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  `access_rules_status` varchar(255) DEFAULT NULL,
  `replica_state` varchar(255) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  `cast_rules_to_readonly` tinyint(1) NOT NULL,
  `progress` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `si_share_network_fk` (`share_network_id`),
  KEY `si_share_server_fk` (`share_server_id`),
  KEY `si_az_id_fk` (`availability_zone_id`),
  KEY `si_st_id_fk` (`share_type_id`),
  KEY `share_instances_share_id_idx` (`share_id`),
  CONSTRAINT `si_az_id_fk` FOREIGN KEY (`availability_zone_id`) REFERENCES `availability_zones` (`id`),
  CONSTRAINT `si_share_fk` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`),
  CONSTRAINT `si_share_network_fk` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`),
  CONSTRAINT `si_share_server_fk` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`),
  CONSTRAINT `si_st_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instances`
--

LOCK TABLES `share_instances` WRITE;
/*!40000 ALTER TABLE `share_instances` DISABLE KEYS */;
INSERT INTO `share_instances` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_id`, `host`, `status`, `scheduled_at`, `launched_at`, `terminated_at`, `share_network_id`, `share_server_id`, `availability_zone_id`, `access_rules_status`, `replica_state`, `share_type_id`, `cast_rules_to_readonly`, `progress`) VALUES ('2025-10-01 17:03:53.493398','2025-10-01 17:04:09.626319','2025-10-01 17:04:09.625034','05ea150c-46e1-4db5-bef4-041e811a35f2','05ea150c-46e1-4db5-bef4-041e811a35f2','bb669f14-71a4-4987-aaff-00e14218a038','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:03:53','2025-10-01 17:03:53','2025-10-01 17:04:08',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'7c91cae8-1d42-4bfe-95c0-52e8e38ffe43',0,'100%'),('2025-10-01 17:03:23.328967','2025-10-01 17:03:32.782859','2025-10-01 17:03:32.781512','0919941a-1ddb-4e3c-91a1-6d4450c6b2dd','0919941a-1ddb-4e3c-91a1-6d4450c6b2dd','7622bcd9-86ac-47c9-b04e-06cfef0a59aa','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:03:23','2025-10-01 17:03:23','2025-10-01 17:03:31',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'3c11362f-fb50-4637-8fe6-18550ac367e4',0,'100%'),('2025-10-01 17:08:17.219978','2025-10-01 17:08:21.455292','2025-10-01 17:08:21.454645','09ee21e6-5d89-4173-b2b4-f6be5a3351ee','09ee21e6-5d89-4173-b2b4-f6be5a3351ee','5c6f08b2-a238-4b91-9928-d6280590b74e','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:08:17','2025-10-01 17:08:17','2025-10-01 17:08:21',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'97f57594-d2cd-4ad0-b515-663008088086',0,'100%'),('2025-10-01 17:09:36.394778','2025-10-01 17:09:48.249626','2025-10-01 17:09:48.248736','0f3443b9-e9d9-4a47-839c-8c53679a0f3e','0f3443b9-e9d9-4a47-839c-8c53679a0f3e','7abf0d63-e158-4ef2-9c76-e1cc6d2d2628','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:09:36','2025-10-01 17:09:36','2025-10-01 17:09:48',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'b2b70e19-2ae4-4aea-be0a-96f3e01586b6',0,'100%'),('2025-10-01 17:02:49.557689','2025-10-01 17:06:21.768412','2025-10-01 17:06:21.767823','0fbcb4a0-2676-4b12-98ef-811f1d5718a9','0fbcb4a0-2676-4b12-98ef-811f1d5718a9','e17d9201-dace-4c98-9dab-80fdfbfad649','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:02:49','2025-10-01 17:02:49','2025-10-01 17:06:21',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'3454de97-e8db-4b3e-a708-5ac562e85e73',0,'100%'),('2025-10-01 17:02:10.543261','2025-10-01 17:02:15.658350','2025-10-01 17:02:15.657670','127b3cca-8ccf-4e68-a7e5-ce47f71b0e6b','127b3cca-8ccf-4e68-a7e5-ce47f71b0e6b','d0d164e3-b2a9-4656-9db9-e6fab398836c','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:02:10','2025-10-01 17:02:10','2025-10-01 17:02:15',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'354dd354-8b0a-40a4-9641-b0e3560a975d',0,'100%'),('2025-10-01 17:05:38.464535','2025-10-01 17:06:01.510685','2025-10-01 17:06:01.510189','1c897d2a-1173-4d28-affc-8c999f770456','1c897d2a-1173-4d28-affc-8c999f770456','f5f63f5f-60e6-41b5-8df8-2523cbbf72e9','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:05:38','2025-10-01 17:05:38','2025-10-01 17:06:00',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'80224da1-67c8-4766-8a84-e16e713a12a0',0,'100%'),('2025-10-01 17:08:06.502776','2025-10-01 17:08:14.042501','2025-10-01 17:08:14.041886','267a009d-a8d2-496f-8ea4-b7694aa0a844','267a009d-a8d2-496f-8ea4-b7694aa0a844','4c348280-32d6-4b4f-850a-a415d2397899','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:08:06','2025-10-01 17:08:11','2025-10-01 17:08:13',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'97f57594-d2cd-4ad0-b515-663008088086',0,'100%'),('2025-10-01 17:06:38.148909','2025-10-01 17:06:49.564588','2025-10-01 17:06:49.563654','297fd041-f36f-460b-b2b8-961d2f4e4832','297fd041-f36f-460b-b2b8-961d2f4e4832','69635b4c-8f40-4a57-90cc-d550c183c871','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:06:38','2025-10-01 17:06:38','2025-10-01 17:06:49',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'c5837613-7660-4253-b4d4-3a77d14c481c',0,'100%'),('2025-10-01 17:01:59.016974','2025-10-01 17:02:50.895698','2025-10-01 17:02:50.894993','29bcbd73-54c4-429e-b29a-68e1af0b3512','29bcbd73-54c4-429e-b29a-68e1af0b3512','92376f2a-17bc-4779-84ff-af7b6e540494','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:01:59','2025-10-01 17:02:00','2025-10-01 17:02:50',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'354dd354-8b0a-40a4-9641-b0e3560a975d',0,'100%'),('2025-10-01 17:06:53.469912','2025-10-01 17:06:58.983409','2025-10-01 17:06:58.982841','2f222ba4-6cc6-4b5d-9beb-b4ad27457477','2f222ba4-6cc6-4b5d-9beb-b4ad27457477','f7529e23-0f0c-49da-88eb-67f6e20776a4','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:06:53','2025-10-01 17:06:53','2025-10-01 17:06:57',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'8478d453-a6b0-4b46-9199-1966caf8d4cf',0,'100%'),('2025-10-01 17:02:09.833069','2025-10-01 17:02:14.324255','2025-10-01 17:02:14.323573','3096acfb-193c-4e04-82fb-a593edc05063','3096acfb-193c-4e04-82fb-a593edc05063','f4d49779-a20c-4108-90e2-028ca74c20f3','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:02:09','2025-10-01 17:02:10','2025-10-01 17:02:14',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'dd944c2a-e556-4a92-a900-c197e5952e3a',0,'100%'),('2025-10-01 17:05:00.669353','2025-10-01 17:05:13.520298','2025-10-01 17:05:13.519698','336d7839-99df-404b-a103-d09bfa3e308f','336d7839-99df-404b-a103-d09bfa3e308f','bca3e7d0-34c7-4c18-ab69-45a419864f77','','deleted','2025-10-01 17:05:00',NULL,NULL,NULL,NULL,NULL,'active',NULL,'039a05c1-a5d1-442b-b2f7-1c7883683b48',0,NULL),('2025-10-01 17:00:43.919834','2025-10-01 17:00:47.832420','2025-10-01 17:00:47.831815','3394bfe3-ff37-4de3-a0d3-c419f1e9c40a','3394bfe3-ff37-4de3-a0d3-c419f1e9c40a','36ec95f5-2e76-4070-8cf3-045a4ad4dbd0','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:00:43','2025-10-01 17:00:44','2025-10-01 17:00:47',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'8844ab0c-8acf-432e-bb69-abd01348cc0a',0,'100%'),('2025-10-01 17:03:08.486828','2025-10-01 17:04:23.451755','2025-10-01 17:04:23.451240','4554af13-83dd-4199-b167-2a7f1fff2e32','4554af13-83dd-4199-b167-2a7f1fff2e32','6e112f49-7379-4e48-b00d-b9ada34f0c5d','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:03:08','2025-10-01 17:03:08','2025-10-01 17:04:23',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'3c11362f-fb50-4637-8fe6-18550ac367e4',0,'100%'),('2025-10-01 17:02:18.896185','2025-10-01 17:02:23.148371','2025-10-01 17:02:23.147696','46dae3a3-bd69-43bd-9813-cd1117c66c7c','46dae3a3-bd69-43bd-9813-cd1117c66c7c','a528f132-e661-4551-bdf2-6aba8bc188e3','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:02:18','2025-10-01 17:02:19','2025-10-01 17:02:22',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'354dd354-8b0a-40a4-9641-b0e3560a975d',0,'100%'),('2025-10-01 17:04:52.181006','2025-10-01 17:06:03.708270','2025-10-01 17:06:03.707763','47b2be1b-8457-4141-a779-0c9e30960e86','47b2be1b-8457-4141-a779-0c9e30960e86','7b1893fd-a87d-4134-86a0-88945c063bc6','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:04:52','2025-10-01 17:04:53','2025-10-01 17:06:03',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'b09f42fb-ab61-4f61-a72d-bb65a506d3d5',0,'100%'),('2025-10-01 17:04:23.075622','2025-10-01 17:04:35.599393','2025-10-01 17:04:35.598643','4850b31b-d69e-4e1f-a8c0-08812bc9688d','4850b31b-d69e-4e1f-a8c0-08812bc9688d','dfcc8c75-53ab-4ce9-b358-4ac7e2a58279','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:04:23','2025-10-01 17:04:25','2025-10-01 17:04:35',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'b7c65449-bea8-4815-b156-f9df3fa11183',0,'100%'),('2025-10-01 17:02:44.026191','2025-10-01 17:02:48.132348','2025-10-01 17:02:48.131735','4bf36e8c-b764-44fa-801e-afcb39550cd4','4bf36e8c-b764-44fa-801e-afcb39550cd4','9ec5bfe3-1c19-49c4-95ce-fa6b337dda04','','deleted','2025-10-01 17:02:44',NULL,NULL,NULL,NULL,NULL,'active',NULL,'4fc47fc1-7587-4c59-80e9-5db74e7ecbe3',0,NULL),('2025-10-01 17:04:58.625854','2025-10-01 17:05:25.145612','2025-10-01 17:05:25.145012','5215a169-5994-425c-a184-e62fdc22c149','5215a169-5994-425c-a184-e62fdc22c149','1acdbdc9-61a5-46ac-b58b-9424aac4ae8f','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:04:58','2025-10-01 17:04:59','2025-10-01 17:05:24',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'e67af6d6-3813-468e-96d3-f52430ec7993',0,'100%'),('2025-10-01 17:01:58.780665','2025-10-01 17:02:02.708370','2025-10-01 17:02:02.707438','52ee1ac4-a3b4-464a-84cf-883d69e24a62','52ee1ac4-a3b4-464a-84cf-883d69e24a62','1f120235-e93c-4f9a-b125-9ea250d5f133','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:01:58','2025-10-01 17:02:00','2025-10-01 17:02:02',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'dd944c2a-e556-4a92-a900-c197e5952e3a',0,'100%'),('2025-10-01 17:00:14.203771','2025-10-01 17:00:42.204909','2025-10-01 17:00:42.204140','5954ec06-59c3-4fff-a9f8-48042027054b','5954ec06-59c3-4fff-a9f8-48042027054b','e51a95d3-50b0-4888-ba72-07dbe0b65690','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:00:14','2025-10-01 17:00:14','2025-10-01 17:00:41',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'eeda9f95-f5c3-4f07-b12e-0b18f7c8da37',0,'100%'),('2025-10-01 17:06:06.103823','2025-10-01 17:06:13.838689',NULL,'False','59fb41a6-024e-4d1c-873e-759037caf2c4','480a39b7-c9bc-46e1-9446-76acd2c26d4a','hostgroup@cephfs#cephfs','available','2025-10-01 17:06:06','2025-10-01 17:06:06',NULL,NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'3454de97-e8db-4b3e-a708-5ac562e85e73',0,'100%'),('2025-10-01 17:04:56.004138','2025-10-01 17:06:00.098378','2025-10-01 17:06:00.097712','5c1c29e1-3838-4336-89e4-29126b32e8a3','5c1c29e1-3838-4336-89e4-29126b32e8a3','69e9a113-75fb-4dff-9fd9-886dc6af9628','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:04:56','2025-10-01 17:04:57','2025-10-01 17:05:59',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'a8a00136-83b3-4010-b21e-0ef332301b8d',0,'100%'),('2025-10-01 17:08:57.262989','2025-10-01 17:09:07.499440','2025-10-01 17:09:07.498476','60e01a62-d5ac-404d-b890-d73b6e36f5cd','60e01a62-d5ac-404d-b890-d73b6e36f5cd','f6c69445-335c-4e53-abc0-d66b7aa436d5','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:08:57','2025-10-01 17:08:59','2025-10-01 17:09:07',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'48f33a6c-07f4-40ed-8292-0a40c1a95498',0,'100%'),('2025-10-01 17:02:27.398295','2025-10-01 17:02:31.136302','2025-10-01 17:02:31.135238','67744f84-a651-45a8-b2eb-586455b4abea','67744f84-a651-45a8-b2eb-586455b4abea','dc6e4ceb-a1a6-4e65-a0ea-9ff537eaa173','','deleted','2025-10-01 17:02:27',NULL,NULL,NULL,NULL,NULL,'active',NULL,'3f2b10b6-f512-41f8-802d-43b4c478360e',0,NULL),('2025-10-01 17:07:55.832643','2025-10-01 17:08:02.665467','2025-10-01 17:08:02.664789','697d2422-31c0-4917-8660-133fa4e39c6e','697d2422-31c0-4917-8660-133fa4e39c6e','99044efa-e30e-406b-bd75-e0521344fb17','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:07:55','2025-10-01 17:08:00','2025-10-01 17:08:02',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'955aef9f-9d20-4cc2-94d6-c8222f9248a9',0,'100%'),('2025-10-01 17:04:11.687965','2025-10-01 17:04:19.475080','2025-10-01 17:04:19.474366','6a6b0432-ea25-4083-8cff-afe449e66429','6a6b0432-ea25-4083-8cff-afe449e66429','fc846882-1107-4676-be65-b94d6f4b1d3c','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:04:11','2025-10-01 17:04:13','2025-10-01 17:04:19',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'b7c65449-bea8-4815-b156-f9df3fa11183',0,'100%'),('2025-10-01 17:09:14.433717','2025-10-01 17:09:27.708561','2025-10-01 17:09:27.707920','7262037d-5a43-4a8e-99a6-10daf7eb5d63','7262037d-5a43-4a8e-99a6-10daf7eb5d63','a0474f3d-dbe0-4366-bff6-13d06a99cfbd','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:09:14','2025-10-01 17:09:21','2025-10-01 17:09:27',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'48f33a6c-07f4-40ed-8292-0a40c1a95498',0,'100%'),('2025-10-01 17:04:54.274150','2025-10-01 17:05:29.476758','2025-10-01 17:05:29.475750','72e3096d-d9f8-4227-b53d-59ed09f4fa07','72e3096d-d9f8-4227-b53d-59ed09f4fa07','05cc2137-ef64-49b8-991a-bfecfb50f6d0','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:04:54','2025-10-01 17:04:55','2025-10-01 17:05:28',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'e67af6d6-3813-468e-96d3-f52430ec7993',0,'100%'),('2025-10-01 17:06:11.803641','2025-10-01 17:06:17.163771','2025-10-01 17:06:17.163106','73871f97-0e9f-4424-8c8d-1fc5d34e1441','73871f97-0e9f-4424-8c8d-1fc5d34e1441','7c9b06f4-d594-496a-9f97-ece8a04d7e6f','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:06:11','2025-10-01 17:06:12','2025-10-01 17:06:16',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'55334669-db93-4cfa-8367-2b8ce2d4cd8b',0,'100%'),('2025-10-01 17:01:02.090228','2025-10-01 17:01:18.190640','2025-10-01 17:01:18.189600','76e4be4c-744e-45f7-a850-fa855b7c5552','76e4be4c-744e-45f7-a850-fa855b7c5552','502deaa1-a93e-4c04-8091-3598765fe522','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:01:02','2025-10-01 17:01:02','2025-10-01 17:01:18',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'0b6fb7a2-3c89-4ce6-afa0-08dffd4c10d5',0,'100%'),('2025-10-01 17:00:36.169063','2025-10-01 17:00:42.022459','2025-10-01 17:00:42.021913','78560bf7-3bfe-43b8-a6d9-8fc4f7716ce5','78560bf7-3bfe-43b8-a6d9-8fc4f7716ce5','c6d4dccb-aacc-4dbc-9596-716921556f10','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:00:36','2025-10-01 17:00:36','2025-10-01 17:00:41',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'e8d8a1fc-ec5d-43c2-aabc-ffea9e499c55',0,'100%'),('2025-10-01 17:07:01.332357','2025-10-01 17:08:13.663590','2025-10-01 17:08:13.662929','7eafcb7a-4d98-4306-a178-8f37dd36887c','7eafcb7a-4d98-4306-a178-8f37dd36887c','aa416fc6-23c7-4223-ab29-52b404b91845','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:07:01','2025-10-01 17:07:02','2025-10-01 17:08:13',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'2e37e456-1985-407a-9e7d-7cfaa41f9bf5',0,'100%'),('2025-10-01 17:05:17.420831','2025-10-01 17:05:21.239848','2025-10-01 17:05:21.239150','80878aeb-d171-4b6b-a81e-ab8bdc3b4fb7','80878aeb-d171-4b6b-a81e-ab8bdc3b4fb7','3dcbb834-7746-46f2-a0a5-c2863b1199a5','','deleted','2025-10-01 17:05:17',NULL,NULL,NULL,NULL,NULL,'active',NULL,'5c4f6639-cfc2-4866-9875-6cc9e6501c89',0,NULL),('2025-10-01 17:00:26.224166','2025-10-01 17:00:33.564083','2025-10-01 17:00:33.563425','8803df6e-514e-40bf-8107-3891be3d00b0','8803df6e-514e-40bf-8107-3891be3d00b0','83ae248c-9fad-4f85-84c6-92e2d645fcc5','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:00:26','2025-10-01 17:00:26','2025-10-01 17:00:33',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'8844ab0c-8acf-432e-bb69-abd01348cc0a',0,'100%'),('2025-10-01 17:08:34.927988','2025-10-01 17:09:40.401019','2025-10-01 17:09:40.400475','8814b9a0-ee27-4d85-bc47-1d08537fe868','8814b9a0-ee27-4d85-bc47-1d08537fe868','6fcb0b46-4ab9-4125-aa81-25240782d372','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:08:34','2025-10-01 17:08:42','2025-10-01 17:09:40',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'48f33a6c-07f4-40ed-8292-0a40c1a95498',0,'100%'),('2025-10-01 17:05:10.126475','2025-10-01 17:05:18.244944','2025-10-01 17:05:18.244371','885343a2-ae40-4dfa-a601-01b84b6596ee','885343a2-ae40-4dfa-a601-01b84b6596ee','adc0f55f-5d3c-4033-b10d-5429864a3bdf','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:05:10','2025-10-01 17:05:14','2025-10-01 17:05:17',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'e67af6d6-3813-468e-96d3-f52430ec7993',0,'100%'),('2025-10-01 17:08:26.420362','2025-10-01 17:09:46.948608','2025-10-01 17:09:46.948013','8bab47f1-016a-4c5f-8b58-46e57c02ad64','8bab47f1-016a-4c5f-8b58-46e57c02ad64','dff79459-719a-48f9-bc64-a4172051df45','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:08:26','2025-10-01 17:08:27','2025-10-01 17:09:46',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'48f33a6c-07f4-40ed-8292-0a40c1a95498',0,'100%'),('2025-10-01 17:00:16.213802','2025-10-01 17:00:38.431582','2025-10-01 17:00:38.431063','8d007d9c-80e4-4e40-ac68-5fe06e924d50','8d007d9c-80e4-4e40-ac68-5fe06e924d50','99b03a60-1080-43f4-9d57-6a2ffd473ac6','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:00:16','2025-10-01 17:00:16','2025-10-01 17:00:38',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'9a2a36a8-eb90-44b3-beb1-6fa464aeb5a0',0,'100%'),('2025-10-01 17:05:38.497855','2025-10-01 17:05:53.323315','2025-10-01 17:05:53.322448','90543113-872c-4287-b768-45f56fc8f849','90543113-872c-4287-b768-45f56fc8f849','7a670548-55c7-4b1d-8c53-f1a735354eef','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:05:38','2025-10-01 17:05:38','2025-10-01 17:05:53',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'b09f42fb-ab61-4f61-a72d-bb65a506d3d5',0,'100%'),('2025-10-01 17:01:25.296297','2025-10-01 17:02:12.636133','2025-10-01 17:02:12.635369','93b513ed-8592-46d2-ae45-b578c4708055','93b513ed-8592-46d2-ae45-b578c4708055','db0e695b-e59d-484f-ba2e-6e5ec878cc21','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:01:25','2025-10-01 17:01:25','2025-10-01 17:02:12',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'f0348654-6331-4c8a-89cf-95b9f1fa588d',0,'100%'),('2025-10-01 17:01:54.859260','2025-10-01 17:02:06.341666','2025-10-01 17:02:06.341137','9cd665eb-c288-4c00-89a5-5693af445149','9cd665eb-c288-4c00-89a5-5693af445149','143b859e-5f32-4381-b1d7-d35ba0c576cf','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:01:54','2025-10-01 17:01:55','2025-10-01 17:02:06',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'dd944c2a-e556-4a92-a900-c197e5952e3a',0,'100%'),('2025-10-01 17:07:30.769476','2025-10-01 17:07:34.791820','2025-10-01 17:07:34.790741','a4bff048-9ed8-4cdd-9086-a185cea04d3c','a4bff048-9ed8-4cdd-9086-a185cea04d3c','2f85cc8b-1048-424c-a3a3-0b522357dfb2','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:07:30','2025-10-01 17:07:31','2025-10-01 17:07:34',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'955aef9f-9d20-4cc2-94d6-c8222f9248a9',0,'100%'),('2025-10-01 17:01:32.640801','2025-10-01 17:02:05.499792','2025-10-01 17:02:05.499077','a5f570e8-f76e-482d-b0fa-146c6f6d8dd3','a5f570e8-f76e-482d-b0fa-146c6f6d8dd3','d539111d-51b0-4419-98c4-939556ffe18d','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:01:32','2025-10-01 17:01:36','2025-10-01 17:02:05',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'f0348654-6331-4c8a-89cf-95b9f1fa588d',0,'100%'),('2025-10-01 17:07:26.801851','2025-10-01 17:07:38.074619','2025-10-01 17:07:38.074092','a69f0a4d-9f3f-4666-81e2-d1b6803ae7a8','a69f0a4d-9f3f-4666-81e2-d1b6803ae7a8','7df9004c-df10-46e2-8a1d-a5b53da1c228','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:07:26','2025-10-01 17:07:27','2025-10-01 17:07:37',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'955aef9f-9d20-4cc2-94d6-c8222f9248a9',0,'100%'),('2025-10-01 17:00:17.938961','2025-10-01 17:00:24.909659','2025-10-01 17:00:24.908990','ad3738e8-3ae5-4ca0-bfa2-ec80b0780d33','ad3738e8-3ae5-4ca0-bfa2-ec80b0780d33','704e6c7e-e6cf-452b-97b4-777e2c8ab556','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:00:18','2025-10-01 17:00:18','2025-10-01 17:00:24',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'fc0b7d99-26ca-4334-8407-02cec26a8f38',0,'100%'),('2025-10-01 17:00:36.778611','2025-10-01 17:00:40.643572','2025-10-01 17:00:40.642959','ae3b1acf-5bd9-4e7d-9dda-2786b242cb55','ae3b1acf-5bd9-4e7d-9dda-2786b242cb55','e2fa38e2-7a0c-42c1-a5bc-67dbe164c008','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:00:36','2025-10-01 17:00:37','2025-10-01 17:00:40',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'8844ab0c-8acf-432e-bb69-abd01348cc0a',0,'100%'),('2025-10-01 17:02:11.938923','2025-10-01 17:02:25.291508','2025-10-01 17:02:25.290720','aef1d813-6fa0-431e-85ff-6739a4057903','aef1d813-6fa0-431e-85ff-6739a4057903','f85090ff-591b-405d-88b6-36d427ce5b6a','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:02:12','2025-10-01 17:02:12','2025-10-01 17:02:24',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'cd7fa723-e40d-401a-9a30-e34fb52e7764',0,'100%'),('2025-10-01 17:07:32.765883','2025-10-01 17:08:30.103800','2025-10-01 17:08:30.103107','afbc5b28-4a3d-4f5a-9775-80288db0083b','afbc5b28-4a3d-4f5a-9775-80288db0083b','475eaf7b-7be8-4075-99c6-46b38f1b33fb','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:07:32','2025-10-01 17:07:33','2025-10-01 17:08:29',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'97f57594-d2cd-4ad0-b515-663008088086',0,'100%'),('2025-10-01 17:06:36.488219','2025-10-01 17:06:42.449175','2025-10-01 17:06:42.448622','b17b9bf4-9e5c-492b-a894-4f295f7cb7dd','b17b9bf4-9e5c-492b-a894-4f295f7cb7dd','0247ce18-ff4b-465c-ac46-a70fcaae9d45','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:06:36','2025-10-01 17:06:36','2025-10-01 17:06:42',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'1db0c391-0940-40b9-8519-f4e0c69684f3',0,'100%'),('2025-10-01 17:07:08.969267','2025-10-01 17:08:03.446952','2025-10-01 17:08:03.446400','b3a00dd2-1018-47de-9729-c563b1ade8d1','b3a00dd2-1018-47de-9729-c563b1ade8d1','8829ada2-2a2b-4b03-950c-0cffc3adb0ff','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:07:08','2025-10-01 17:07:12','2025-10-01 17:08:03',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'2e37e456-1985-407a-9e7d-7cfaa41f9bf5',0,'100%'),('2025-10-01 17:09:09.378825','2025-10-01 17:09:24.190641','2025-10-01 17:09:24.190009','b4fd18da-d185-4d9e-9718-4a7a16198c6c','b4fd18da-d185-4d9e-9718-4a7a16198c6c','3be0a77c-9477-462e-8eb4-10c3ba44b638','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:09:09','2025-10-01 17:09:11','2025-10-01 17:09:23',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'5207f340-b3fd-4fd8-95e5-1228cababcc3',0,'100%'),('2025-10-01 17:03:12.692916','2025-10-01 17:03:20.455267','2025-10-01 17:03:20.454757','b596d505-7972-465b-8b8f-82b926477693','b596d505-7972-465b-8b8f-82b926477693','7401d0d1-b73f-415c-9142-bd25f09b8209','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:03:12','2025-10-01 17:03:12','2025-10-01 17:03:19',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'3c11362f-fb50-4637-8fe6-18550ac367e4',0,'100%'),('2025-10-01 17:00:17.969546','2025-10-01 17:00:23.030683','2025-10-01 17:00:23.029895','b6442d06-c01f-49a2-aa90-70b48363f5f9','b6442d06-c01f-49a2-aa90-70b48363f5f9','604a4627-b4dc-4eaa-97db-9140ae61556e','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:00:18','2025-10-01 17:00:18','2025-10-01 17:00:22',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'8844ab0c-8acf-432e-bb69-abd01348cc0a',0,'100%'),('2025-10-01 17:02:29.172135','2025-10-01 17:02:34.438720','2025-10-01 17:02:34.438200','b8ad6a25-2c76-4709-bb24-c02c6f27169d','b8ad6a25-2c76-4709-bb24-c02c6f27169d','e893a892-0405-4677-a235-d77856bfef2b','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:02:29','2025-10-01 17:02:29','2025-10-01 17:02:34',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'07c916e4-5e73-4eaa-9e77-984c3d94747e',0,'100%'),('2025-10-01 17:07:41.423657','2025-10-01 17:07:45.542452','2025-10-01 17:07:45.541701','b8cb71a4-9f4b-4317-bdd2-cb9e0a520e09','b8cb71a4-9f4b-4317-bdd2-cb9e0a520e09','eb733b75-96a3-41ff-81eb-fb242a8cf1b6','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:07:41','2025-10-01 17:07:41','2025-10-01 17:07:45',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'97f57594-d2cd-4ad0-b515-663008088086',0,'100%'),('2025-10-01 17:04:43.396612','2025-10-01 17:04:47.147414','2025-10-01 17:04:47.146668','bc308e4f-d1ba-4ec7-abb7-371eb6acb86b','bc308e4f-d1ba-4ec7-abb7-371eb6acb86b','2686dbe8-432c-4e15-94fc-e2c57311eadb','','deleted','2025-10-01 17:04:43',NULL,NULL,NULL,NULL,NULL,'active',NULL,'37485c41-bf1c-4f76-96dd-017b9efb3945',0,NULL),('2025-10-01 17:09:31.201309','2025-10-01 17:09:36.889393','2025-10-01 17:09:36.888824','bdd25bd8-509d-48a7-9a62-5485c6f3d21a','bdd25bd8-509d-48a7-9a62-5485c6f3d21a','f699304c-bc56-43fe-ae97-bee754cc0413','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:09:31','2025-10-01 17:09:31','2025-10-01 17:09:36',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'48f33a6c-07f4-40ed-8292-0a40c1a95498',0,'100%'),('2025-10-01 17:02:35.676109','2025-10-01 17:02:39.306692','2025-10-01 17:02:39.305388','bddc056d-c4f1-49e7-ba0a-06a29d4648c5','bddc056d-c4f1-49e7-ba0a-06a29d4648c5','44260837-c979-44ee-a03a-ac05c7b8646a','','deleted','2025-10-01 17:02:35',NULL,NULL,NULL,NULL,NULL,'active',NULL,'584a5070-565d-40c4-835e-9ead21030114',0,NULL),('2025-10-01 17:04:56.155665','2025-10-01 17:04:59.670784','2025-10-01 17:04:59.670262','c01fb8fe-b330-42c2-af74-e781c04bb59d','c01fb8fe-b330-42c2-af74-e781c04bb59d','bcea9c48-c6b9-4586-b3e5-bae5a301e1f0','','deleted','2025-10-01 17:04:56',NULL,NULL,NULL,NULL,NULL,'active',NULL,'f6d05e71-de10-42a2-8555-e5899975f59e',0,NULL),('2025-10-01 17:00:13.709916','2025-10-01 17:01:50.805883','2025-10-01 17:01:50.805340','c469f818-07e0-4818-86b2-37da251687bb','c469f818-07e0-4818-86b2-37da251687bb','95bc68e4-4409-4a9b-83c9-5b9c7854b687','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:00:13','2025-10-01 17:00:14','2025-10-01 17:01:50',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'8844ab0c-8acf-432e-bb69-abd01348cc0a',0,'100%'),('2025-10-01 17:01:26.765998','2025-10-01 17:01:43.309968','2025-10-01 17:01:43.309443','c5ae6d5e-ebae-47c0-867d-5722bbee2320','c5ae6d5e-ebae-47c0-867d-5722bbee2320','e3193d43-5ad0-4a4b-b5ad-b33441f5b578','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:01:26','2025-10-01 17:01:27','2025-10-01 17:01:41',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'89fda32e-eb53-4bb7-8ebe-24317a4a69c0',0,'100%'),('2025-10-01 17:02:02.642481','2025-10-01 17:02:07.304578','2025-10-01 17:02:07.304006','cd48652d-071f-468a-8c02-77f78f7bd8e7','cd48652d-071f-468a-8c02-77f78f7bd8e7','004da363-46ac-471c-861f-c2e23fda6dec','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:02:02','2025-10-01 17:02:02','2025-10-01 17:02:07',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'354dd354-8b0a-40a4-9641-b0e3560a975d',0,'100%'),('2025-10-01 17:05:22.416747','2025-10-01 17:05:26.268489','2025-10-01 17:05:26.267709','cf2bba52-4976-448d-a07f-8b733f911864','cf2bba52-4976-448d-a07f-8b733f911864','4fec8b23-dcb5-4ef4-9f12-9e9ccd47d8d5','','deleted','2025-10-01 17:05:22',NULL,NULL,NULL,NULL,NULL,'active',NULL,'0e7badfe-7b64-4ef5-9cae-3e2a73bd3271',0,NULL),('2025-10-01 17:02:56.752156','2025-10-01 17:03:04.410864','2025-10-01 17:03:04.410356','cfcadb50-45a4-4b1d-8651-7ec7bda466b1','cfcadb50-45a4-4b1d-8651-7ec7bda466b1','c058b0b6-2667-4b81-9f75-254ad567bf46','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:02:56','2025-10-01 17:02:57','2025-10-01 17:03:04',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'2324d49d-b8b2-4a6a-82f9-af40a075e8cc',0,'100%'),('2025-10-01 17:01:13.035563','2025-10-01 17:01:17.129073','2025-10-01 17:01:17.128387','d0586e81-22a4-46d7-91b6-618299744cd8','d0586e81-22a4-46d7-91b6-618299744cd8','ad5e40a1-7b65-4a0d-a7be-711e07e0447b','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:01:13','2025-10-01 17:01:13','2025-10-01 17:01:16',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'b4e112a6-2cd3-4161-a1d9-6a2b26c3ae12',0,'100%'),('2025-10-01 17:02:39.863940','2025-10-01 17:02:43.421248','2025-10-01 17:02:43.420669','d494d623-bff8-4e3d-bcb5-e6db958bf621','d494d623-bff8-4e3d-bcb5-e6db958bf621','dab13563-4d57-413d-bd06-6648b3c43113','','deleted','2025-10-01 17:02:39',NULL,NULL,NULL,NULL,NULL,'active',NULL,'4211893b-b8e2-4a67-bb8a-d9c7ef2f16a2',0,NULL),('2025-10-01 17:09:59.036902','2025-10-01 17:10:11.034460','2025-10-01 17:10:11.033932','d5107ec8-a115-44fa-8f38-14e43f7ac582','d5107ec8-a115-44fa-8f38-14e43f7ac582','4fbc718e-e5a9-4005-93e5-22e43f8cccc0','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:09:59','2025-10-01 17:10:00','2025-10-01 17:10:10',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'4f903460-2d3d-42ea-bed9-eacdc72380eb',0,'100%'),('2025-10-01 17:02:51.628164','2025-10-01 17:03:00.943360','2025-10-01 17:03:00.942914','d82a03d3-ac0e-4c77-9123-db50d46e8e91','d82a03d3-ac0e-4c77-9123-db50d46e8e91','aad7151d-59fc-49a6-ae46-ee933dbfddb8','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:02:51','2025-10-01 17:02:52','2025-10-01 17:03:00',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'f75be615-3c48-49cc-844c-502b209bf197',0,'100%'),('2025-10-01 17:05:13.913018','2025-10-01 17:05:21.532496','2025-10-01 17:05:21.531911','db1bd50d-b1bc-4564-a654-f3fc3ec269c8','db1bd50d-b1bc-4564-a654-f3fc3ec269c8','5fd34ab3-1557-4811-b421-fd2bdc80fe5c','','deleted','2025-10-01 17:05:13',NULL,NULL,NULL,NULL,NULL,'active',NULL,'bf0700f6-e269-4e6e-8ad2-2c76437dcb49',0,NULL),('2025-10-01 17:02:37.721943','2025-10-01 17:02:44.434394','2025-10-01 17:02:44.433744','dbc2114d-a89a-4156-8432-271ef7164acc','dbc2114d-a89a-4156-8432-271ef7164acc','5239d943-cda9-4d21-a0d4-31879c0800e0','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:02:37','2025-10-01 17:02:38','2025-10-01 17:02:44',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'354dd354-8b0a-40a4-9641-b0e3560a975d',0,'100%'),('2025-10-01 17:07:49.055257','2025-10-01 17:07:52.997997','2025-10-01 17:07:52.997307','dda50ff1-4d8c-4915-a4cd-5da1c827bac3','dda50ff1-4d8c-4915-a4cd-5da1c827bac3','1a4303ab-fd5b-496c-ba7f-a6e9a95ee38c','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:07:49','2025-10-01 17:07:49','2025-10-01 17:07:52',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'97f57594-d2cd-4ad0-b515-663008088086',0,'100%'),('2025-10-01 17:07:56.269635','2025-10-01 17:08:03.298859','2025-10-01 17:08:03.298326','df8b44c3-6adf-44f9-88cd-1ac785cf76d5','df8b44c3-6adf-44f9-88cd-1ac785cf76d5','8f916214-aa8c-4550-b818-ce6a422041bc','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:07:56','2025-10-01 17:08:00','2025-10-01 17:08:03',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'97f57594-d2cd-4ad0-b515-663008088086',0,'100%'),('2025-10-01 17:03:35.644561','2025-10-01 17:03:43.759661','2025-10-01 17:03:43.759025','e14aa593-425a-47dd-b300-8569859e6275','e14aa593-425a-47dd-b300-8569859e6275','4f309c99-0839-4c72-b180-b88ea761ebd4','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:03:35','2025-10-01 17:03:36','2025-10-01 17:03:43',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'3c11362f-fb50-4637-8fe6-18550ac367e4',0,'100%'),('2025-10-01 17:05:05.498639','2025-10-01 17:05:13.247400','2025-10-01 17:05:13.246399','e1e32358-c1e9-4c52-a67e-fb64823561e8','e1e32358-c1e9-4c52-a67e-fb64823561e8','a7ee0331-e686-4283-9719-930d79c77201','','deleted','2025-10-01 17:05:05',NULL,NULL,NULL,NULL,NULL,'active',NULL,'ff31a3ee-a999-42cd-b0e7-6b0804664d3d',0,NULL),('2025-10-01 17:05:09.352217','2025-10-01 17:05:12.891863','2025-10-01 17:05:12.890609','e688feca-68f3-406e-a865-f2faac86900e','e688feca-68f3-406e-a865-f2faac86900e','ec007ccb-27a7-4458-b286-526d906c9733','','deleted','2025-10-01 17:05:09',NULL,NULL,NULL,NULL,NULL,'active',NULL,'00ca740c-3b33-4184-8684-9c836e09c2c9',0,NULL),('2025-10-01 17:05:41.589597','2025-10-01 17:06:36.428489','2025-10-01 17:06:36.427321','ea26f47e-6032-4f84-85c8-3aa43d68e5c0','ea26f47e-6032-4f84-85c8-3aa43d68e5c0','f8eb063b-f94f-4394-a2be-7bbf2414c84c','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:05:41','2025-10-01 17:05:42','2025-10-01 17:06:36',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'af3d117f-22fe-4775-ba1f-16e7503d27f3',0,'100%'),('2025-10-01 17:07:48.581756','2025-10-01 17:07:52.599535','2025-10-01 17:07:52.598966','ebb81bb7-5ad0-430e-bce8-857817637159','ebb81bb7-5ad0-430e-bce8-857817637159','510a1869-e04c-4711-b4ce-1bb86392d728','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:07:48','2025-10-01 17:07:49','2025-10-01 17:07:52',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'955aef9f-9d20-4cc2-94d6-c8222f9248a9',0,'100%'),('2025-10-01 17:02:26.548170','2025-10-01 17:02:32.361129','2025-10-01 17:02:32.360315','ecd5683e-7c6f-403f-a027-c9731cd1c5fb','ecd5683e-7c6f-403f-a027-c9731cd1c5fb','d664cfa8-7e79-4c95-82dc-013d6f58dbd5','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:02:26','2025-10-01 17:02:27','2025-10-01 17:02:31',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'354dd354-8b0a-40a4-9641-b0e3560a975d',0,'100%'),('2025-10-01 17:06:57.256174','2025-10-01 17:07:12.425957','2025-10-01 17:07:12.425397','efdb0876-5085-415d-ba20-1a51461b6ac1','efdb0876-5085-415d-ba20-1a51461b6ac1','e160f19c-fd45-4300-abd5-b3a4764aea08','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:06:57','2025-10-01 17:06:58','2025-10-01 17:07:09',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'5efa3b2a-601c-4ea8-9cf6-c5c76a3276c5',0,'100%'),('2025-10-01 17:08:43.143902','2025-10-01 17:09:06.182143','2025-10-01 17:09:06.181184','f1653434-fb19-4bc0-85ed-a5473c6d290d','f1653434-fb19-4bc0-85ed-a5473c6d290d','fc6726f2-aad1-42b6-a319-9c17d82817a5','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:08:43','2025-10-01 17:08:53','2025-10-01 17:09:06',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'5207f340-b3fd-4fd8-95e5-1228cababcc3',0,'100%'),('2025-10-01 17:02:31.525694','2025-10-01 17:02:35.126224','2025-10-01 17:02:35.125628','f27e15f0-7ea6-4f8f-aa46-708f5bbef592','f27e15f0-7ea6-4f8f-aa46-708f5bbef592','cf0992a6-7788-4ae9-911d-8b443f293993','','deleted','2025-10-01 17:02:31',NULL,NULL,NULL,NULL,NULL,'active',NULL,'bb28b531-7011-4456-8d2d-6fe0cb38ac18',0,NULL),('2025-10-01 17:05:03.211866','2025-10-01 17:05:56.778288','2025-10-01 17:05:56.777729','f4359a50-b671-43df-8a71-afb168cd35b0','f4359a50-b671-43df-8a71-afb168cd35b0','b87e1026-6ce3-48d5-a1fd-8dc67c00f4d5','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:05:03','2025-10-01 17:05:08','2025-10-01 17:05:56',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'a8a00136-83b3-4010-b21e-0ef332301b8d',0,'100%'),('2025-10-01 17:04:52.343785','2025-10-01 17:04:59.985706','2025-10-01 17:04:59.985031','f7239a55-2243-418e-b18d-61f710820abd','f7239a55-2243-418e-b18d-61f710820abd','82afcb55-ab13-400e-b95c-60fdd65c2ff7','','deleted','2025-10-01 17:04:52',NULL,NULL,NULL,NULL,NULL,'active',NULL,'7913e282-46b6-4065-b63e-e5013b78d303',0,NULL),('2025-10-01 17:04:47.802825','2025-10-01 17:04:51.864522','2025-10-01 17:04:51.863212','fe6bc62a-242c-48eb-97be-33d3667e41cf','fe6bc62a-242c-48eb-97be-33d3667e41cf','47b52b31-2fc8-48a3-aa03-8f7b058143a9','','deleted','2025-10-01 17:04:47',NULL,NULL,NULL,NULL,NULL,'active',NULL,'f9da0eae-4f7c-4b85-af50-4858ad082260',0,NULL),('2025-10-01 17:00:40.823655','2025-10-01 17:00:46.400975','2025-10-01 17:00:46.400168','fef691f7-09c0-4a8b-8ca5-0edd6d3edf1f','fef691f7-09c0-4a8b-8ca5-0edd6d3edf1f','a915638e-896a-4b63-919d-f2e57965807a','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:00:40','2025-10-01 17:00:41','2025-10-01 17:00:46',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'3ec8827a-3829-4912-bb29-3f95aeb0ed67',0,'100%'),('2025-10-01 17:05:02.780623','2025-10-01 17:05:21.611270','2025-10-01 17:05:21.610619','ff4382dd-2fca-4301-a194-9666d40ecd5f','ff4382dd-2fca-4301-a194-9666d40ecd5f','f5032ae4-40d3-4416-b119-b7df6be88a0b','hostgroup@cephfs#cephfs','deleted','2025-10-01 17:05:02','2025-10-01 17:05:08','2025-10-01 17:05:21',NULL,NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','active',NULL,'e67af6d6-3813-468e-96d3-f52430ec7993',0,'100%');
/*!40000 ALTER TABLE `share_instances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_metadata`
--

DROP TABLE IF EXISTS `share_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_metadata` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `share_id` (`share_id`),
  CONSTRAINT `share_metadata_ibfk_1` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=108 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_metadata`
--

LOCK TABLES `share_metadata` WRITE;
/*!40000 ALTER TABLE `share_metadata` DISABLE KEYS */;
INSERT INTO `share_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_id`, `key`, `value`) VALUES ('2025-10-01 17:00:14.345821',NULL,'2025-10-01 17:01:50.814889',1,1,'95bc68e4-4409-4a9b-83c9-5b9c7854b687','__mount_options','fs=cephfs'),('2025-10-01 17:00:14.719669',NULL,'2025-10-01 17:00:42.247304',2,2,'e51a95d3-50b0-4888-ba72-07dbe0b65690','__mount_options','fs=cephfs'),('2025-10-01 17:00:16.551735',NULL,'2025-10-01 17:00:38.443214',3,3,'99b03a60-1080-43f4-9d57-6a2ffd473ac6','__mount_options','fs=cephfs'),('2025-10-01 17:00:18.508274',NULL,'2025-10-01 17:00:24.917868',4,4,'704e6c7e-e6cf-452b-97b4-777e2c8ab556','__mount_options','fs=cephfs'),('2025-10-01 17:00:18.630444',NULL,'2025-10-01 17:00:23.043151',5,5,'604a4627-b4dc-4eaa-97db-9140ae61556e','__mount_options','fs=cephfs'),('2025-10-01 17:00:26.442166',NULL,'2025-10-01 17:00:33.575848',6,6,'83ae248c-9fad-4f85-84c6-92e2d645fcc5','__mount_options','fs=cephfs'),('2025-10-01 17:00:36.445208',NULL,'2025-10-01 17:00:42.064584',7,7,'c6d4dccb-aacc-4dbc-9596-716921556f10','__mount_options','fs=cephfs'),('2025-10-01 17:00:37.400915',NULL,'2025-10-01 17:00:40.653140',8,8,'e2fa38e2-7a0c-42c1-a5bc-67dbe164c008','__mount_options','fs=cephfs'),('2025-10-01 17:00:41.074961',NULL,'2025-10-01 17:00:46.411399',9,9,'a915638e-896a-4b63-919d-f2e57965807a','__mount_options','fs=cephfs'),('2025-10-01 17:00:44.968092',NULL,'2025-10-01 17:00:47.845387',10,10,'36ec95f5-2e76-4070-8cf3-045a4ad4dbd0','__mount_options','fs=cephfs'),('2025-10-01 17:01:02.474713',NULL,'2025-10-01 17:01:18.204219',11,11,'502deaa1-a93e-4c04-8091-3598765fe522','__mount_options','fs=cephfs'),('2025-10-01 17:01:13.322543',NULL,'2025-10-01 17:01:17.139842',12,12,'ad5e40a1-7b65-4a0d-a7be-711e07e0447b','__mount_options','fs=cephfs'),('2025-10-01 17:01:25.263343',NULL,'2025-10-01 17:02:12.648271',13,13,'db0e695b-e59d-484f-ba2e-6e5ec878cc21','foo_key_share_1','foo_value_share_1'),('2025-10-01 17:01:25.264300',NULL,'2025-10-01 17:02:12.648271',14,14,'db0e695b-e59d-484f-ba2e-6e5ec878cc21','bar_key_share_1','foo_value_share_1'),('2025-10-01 17:01:25.787877',NULL,'2025-10-01 17:02:12.648271',15,15,'db0e695b-e59d-484f-ba2e-6e5ec878cc21','__mount_options','fs=cephfs'),('2025-10-01 17:01:27.205826',NULL,'2025-10-01 17:01:43.326523',16,16,'e3193d43-5ad0-4a4b-b5ad-b33441f5b578','__mount_options','fs=cephfs'),('2025-10-01 17:01:32.594833',NULL,'2025-10-01 17:02:05.517419',17,17,'d539111d-51b0-4419-98c4-939556ffe18d','foo_key_share_2','foo_value_share_2'),('2025-10-01 17:01:32.595245',NULL,'2025-10-01 17:02:05.517419',18,18,'d539111d-51b0-4419-98c4-939556ffe18d','bar_key_share_2','foo_value_share_2'),('2025-10-01 17:01:36.400454',NULL,'2025-10-01 17:02:05.517419',19,19,'d539111d-51b0-4419-98c4-939556ffe18d','__mount_options','fs=cephfs'),('2025-10-01 17:01:55.228488',NULL,'2025-10-01 17:02:06.351508',20,20,'143b859e-5f32-4381-b1d7-d35ba0c576cf','__mount_options','fs=cephfs'),('2025-10-01 17:02:00.612450',NULL,'2025-10-01 17:02:50.908761',21,21,'92376f2a-17bc-4779-84ff-af7b6e540494','__mount_options','fs=cephfs'),('2025-10-01 17:02:00.618613',NULL,'2025-10-01 17:02:02.723694',22,22,'1f120235-e93c-4f9a-b125-9ea250d5f133','__mount_options','fs=cephfs'),('2025-10-01 17:02:02.888499',NULL,'2025-10-01 17:02:07.318463',23,23,'004da363-46ac-471c-861f-c2e23fda6dec','__mount_options','fs=cephfs'),('2025-10-01 17:02:06.395781',NULL,'2025-10-01 17:02:07.318463',24,24,'004da363-46ac-471c-861f-c2e23fda6dec','key5','value5'),('2025-10-01 17:02:06.404180',NULL,'2025-10-01 17:02:07.318463',25,25,'004da363-46ac-471c-861f-c2e23fda6dec','key6','value6'),('2025-10-01 17:02:06.610145',NULL,'2025-10-01 17:02:07.318463',26,26,'004da363-46ac-471c-861f-c2e23fda6dec','key7','value7'),('2025-10-01 17:02:06.614296',NULL,'2025-10-01 17:02:07.318463',27,27,'004da363-46ac-471c-861f-c2e23fda6dec','key8','value8'),('2025-10-01 17:02:10.120613',NULL,'2025-10-01 17:02:14.333646',28,28,'f4d49779-a20c-4108-90e2-028ca74c20f3','__mount_options','fs=cephfs'),('2025-10-01 17:02:10.934914',NULL,'2025-10-01 17:02:15.673076',29,29,'d0d164e3-b2a9-4656-9db9-e6fab398836c','__mount_options','fs=cephfs'),('2025-10-01 17:02:12.444167',NULL,'2025-10-01 17:02:25.303511',30,30,'f85090ff-591b-405d-88b6-36d427ce5b6a','__mount_options','fs=cephfs'),('2025-10-01 17:02:14.068139',NULL,'2025-10-01 17:02:15.673076',31,31,'d0d164e3-b2a9-4656-9db9-e6fab398836c','key3','value3'),('2025-10-01 17:02:14.073266',NULL,'2025-10-01 17:02:15.673076',32,32,'d0d164e3-b2a9-4656-9db9-e6fab398836c','key4','value4'),('2025-10-01 17:02:14.078248',NULL,'2025-10-01 17:02:15.673076',33,33,'d0d164e3-b2a9-4656-9db9-e6fab398836c','key.5.1','value.5'),('2025-10-01 17:02:18.876317',NULL,'2025-10-01 17:02:23.158092',34,34,'a528f132-e661-4551-bdf2-6aba8bc188e3','key1','value1'),('2025-10-01 17:02:18.876642',NULL,'2025-10-01 17:02:23.158092',35,35,'a528f132-e661-4551-bdf2-6aba8bc188e3','key2','value2'),('2025-10-01 17:02:19.608399',NULL,'2025-10-01 17:02:23.158092',36,36,'a528f132-e661-4551-bdf2-6aba8bc188e3','__mount_options','fs=cephfs'),('2025-10-01 17:02:26.994643',NULL,'2025-10-01 17:02:32.373577',37,37,'d664cfa8-7e79-4c95-82dc-013d6f58dbd5','__mount_options','fs=cephfs'),('2025-10-01 17:02:29.119885',NULL,'2025-10-01 17:02:34.446735',38,38,'e893a892-0405-4677-a235-d77856bfef2b','key','value'),('2025-10-01 17:02:29.490491',NULL,'2025-10-01 17:02:34.446735',39,39,'e893a892-0405-4677-a235-d77856bfef2b','__mount_options','fs=cephfs'),('2025-10-01 17:02:30.229836','2025-10-01 17:02:30.632030','2025-10-01 17:02:32.373577',40,40,'d664cfa8-7e79-4c95-82dc-013d6f58dbd5','key9','value13'),('2025-10-01 17:02:30.235311',NULL,'2025-10-01 17:02:32.373577',41,41,'d664cfa8-7e79-4c95-82dc-013d6f58dbd5','key10','value10'),('2025-10-01 17:02:30.647936',NULL,'2025-10-01 17:02:32.373577',42,42,'d664cfa8-7e79-4c95-82dc-013d6f58dbd5','key11','value11'),('2025-10-01 17:02:35.575753',NULL,'2025-10-01 17:02:50.908761',43,43,'92376f2a-17bc-4779-84ff-af7b6e540494','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value'),('2025-10-01 17:02:35.971258','2025-10-01 17:02:37.290579','2025-10-01 17:02:50.908761',44,44,'92376f2a-17bc-4779-84ff-af7b6e540494','key','v'),('2025-10-01 17:02:36.380237',NULL,'2025-10-01 17:02:50.908761',45,45,'92376f2a-17bc-4779-84ff-af7b6e540494','k','value'),('2025-10-01 17:02:38.260349',NULL,'2025-10-01 17:02:44.443192',46,46,'5239d943-cda9-4d21-a0d4-31879c0800e0','__mount_options','fs=cephfs'),('2025-10-01 17:02:41.387510',NULL,'2025-10-01 17:02:44.443192',47,47,'5239d943-cda9-4d21-a0d4-31879c0800e0','key9','value9'),('2025-10-01 17:02:41.392710',NULL,'2025-10-01 17:02:44.443192',48,48,'5239d943-cda9-4d21-a0d4-31879c0800e0','key10','value10'),('2025-10-01 17:02:42.087134',NULL,'2025-10-01 17:02:44.443192',49,49,'5239d943-cda9-4d21-a0d4-31879c0800e0','key11','value11'),('2025-10-01 17:02:42.094448',NULL,'2025-10-01 17:02:44.443192',50,50,'5239d943-cda9-4d21-a0d4-31879c0800e0','key12','value12'),('2025-10-01 17:02:48.318868',NULL,'2025-10-01 17:02:50.908761',51,51,'92376f2a-17bc-4779-84ff-af7b6e540494','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value'),('2025-10-01 17:02:48.909644',NULL,'2025-10-01 17:02:50.908761',52,52,'92376f2a-17bc-4779-84ff-af7b6e540494','key','vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv'),('2025-10-01 17:02:49.412357',NULL,'2025-10-01 17:02:50.908761',53,53,'92376f2a-17bc-4779-84ff-af7b6e540494','k','value'),('2025-10-01 17:02:49.834879',NULL,'2025-10-01 17:02:50.908761',54,54,'92376f2a-17bc-4779-84ff-af7b6e540494','key','v'),('2025-10-01 17:02:49.867163',NULL,'2025-10-01 17:06:21.802204',55,55,'e17d9201-dace-4c98-9dab-80fdfbfad649','__mount_options','fs=cephfs'),('2025-10-01 17:02:51.975955',NULL,'2025-10-01 17:03:00.957733',56,56,'aad7151d-59fc-49a6-ae46-ee933dbfddb8','__mount_options','fs=cephfs'),('2025-10-01 17:02:57.113767',NULL,'2025-10-01 17:03:04.422016',57,57,'c058b0b6-2667-4b81-9f75-254ad567bf46','__mount_options','fs=cephfs'),('2025-10-01 17:03:08.711258',NULL,'2025-10-01 17:04:23.498494',58,58,'6e112f49-7379-4e48-b00d-b9ada34f0c5d','__mount_options','fs=cephfs'),('2025-10-01 17:03:12.965823',NULL,'2025-10-01 17:03:20.474759',59,59,'7401d0d1-b73f-415c-9142-bd25f09b8209','__mount_options','fs=cephfs'),('2025-10-01 17:03:23.652991',NULL,'2025-10-01 17:03:32.847510',60,60,'7622bcd9-86ac-47c9-b04e-06cfef0a59aa','__mount_options','fs=cephfs'),('2025-10-01 17:03:36.231760',NULL,'2025-10-01 17:03:43.776011',61,61,'4f309c99-0839-4c72-b180-b88ea761ebd4','__mount_options','fs=cephfs'),('2025-10-01 17:03:53.740923',NULL,'2025-10-01 17:04:09.652631',62,62,'bb669f14-71a4-4987-aaff-00e14218a038','__mount_options','fs=cephfs'),('2025-10-01 17:04:13.125637',NULL,'2025-10-01 17:04:19.487895',63,63,'fc846882-1107-4676-be65-b94d6f4b1d3c','__mount_options','fs=cephfs'),('2025-10-01 17:04:25.068449',NULL,'2025-10-01 17:04:35.619028',64,64,'dfcc8c75-53ab-4ce9-b358-4ac7e2a58279','__mount_options','fs=cephfs'),('2025-10-01 17:04:53.129445',NULL,'2025-10-01 17:06:03.720559',65,65,'7b1893fd-a87d-4134-86a0-88945c063bc6','__mount_options','fs=cephfs'),('2025-10-01 17:04:54.858698',NULL,'2025-10-01 17:05:29.509337',66,66,'05cc2137-ef64-49b8-991a-bfecfb50f6d0','__mount_options','fs=cephfs'),('2025-10-01 17:04:56.447330',NULL,'2025-10-01 17:06:00.116702',67,67,'69e9a113-75fb-4dff-9fd9-886dc6af9628','__mount_options','fs=cephfs'),('2025-10-01 17:04:59.010214',NULL,'2025-10-01 17:05:25.155635',68,68,'1acdbdc9-61a5-46ac-b58b-9424aac4ae8f','__mount_options','fs=cephfs'),('2025-10-01 17:05:08.488600',NULL,'2025-10-01 17:05:56.794158',69,69,'b87e1026-6ce3-48d5-a1fd-8dc67c00f4d5','__mount_options','fs=cephfs'),('2025-10-01 17:05:08.548483',NULL,'2025-10-01 17:05:21.627391',70,70,'f5032ae4-40d3-4416-b119-b7df6be88a0b','__mount_options','fs=cephfs'),('2025-10-01 17:05:14.149770',NULL,'2025-10-01 17:05:18.255559',71,71,'adc0f55f-5d3c-4033-b10d-5429864a3bdf','__mount_options','fs=cephfs'),('2025-10-01 17:05:38.744857',NULL,'2025-10-01 17:06:01.521177',72,72,'f5f63f5f-60e6-41b5-8df8-2523cbbf72e9','__mount_options','fs=cephfs'),('2025-10-01 17:05:38.850655',NULL,'2025-10-01 17:05:53.345013',73,73,'7a670548-55c7-4b1d-8c53-f1a735354eef','__mount_options','fs=cephfs'),('2025-10-01 17:05:42.118316',NULL,'2025-10-01 17:06:36.438845',74,74,'f8eb063b-f94f-4394-a2be-7bbf2414c84c','__mount_options','fs=cephfs'),('2025-10-01 17:06:06.663351',NULL,NULL,0,75,'480a39b7-c9bc-46e1-9446-76acd2c26d4a','__mount_options','fs=cephfs'),('2025-10-01 17:06:12.047976',NULL,'2025-10-01 17:06:17.365301',76,76,'7c9b06f4-d594-496a-9f97-ece8a04d7e6f','__mount_options','fs=cephfs'),('2025-10-01 17:06:36.899268',NULL,'2025-10-01 17:06:42.459008',77,77,'0247ce18-ff4b-465c-ac46-a70fcaae9d45','__mount_options','fs=cephfs'),('2025-10-01 17:06:38.449009',NULL,'2025-10-01 17:06:49.575409',78,78,'69635b4c-8f40-4a57-90cc-d550c183c871','__mount_options','fs=cephfs'),('2025-10-01 17:06:53.852638',NULL,'2025-10-01 17:06:58.993443',79,79,'f7529e23-0f0c-49da-88eb-67f6e20776a4','__mount_options','fs=cephfs'),('2025-10-01 17:06:58.820310',NULL,'2025-10-01 17:07:12.435895',80,80,'e160f19c-fd45-4300-abd5-b3a4764aea08','__mount_options','fs=cephfs'),('2025-10-01 17:07:02.142837',NULL,'2025-10-01 17:08:13.673549',81,81,'aa416fc6-23c7-4223-ab29-52b404b91845','__mount_options','fs=cephfs'),('2025-10-01 17:07:12.291836',NULL,'2025-10-01 17:08:03.457799',82,82,'8829ada2-2a2b-4b03-950c-0cffc3adb0ff','__mount_options','fs=cephfs'),('2025-10-01 17:07:27.058163',NULL,'2025-10-01 17:07:38.086419',83,83,'7df9004c-df10-46e2-8a1d-a5b53da1c228','__mount_options','fs=cephfs'),('2025-10-01 17:07:31.118986',NULL,'2025-10-01 17:07:34.804748',84,84,'2f85cc8b-1048-424c-a3a3-0b522357dfb2','__mount_options','fs=cephfs'),('2025-10-01 17:07:33.541226',NULL,'2025-10-01 17:08:30.113605',85,85,'475eaf7b-7be8-4075-99c6-46b38f1b33fb','__mount_options','fs=cephfs'),('2025-10-01 17:07:41.616732',NULL,'2025-10-01 17:07:45.554863',86,86,'eb733b75-96a3-41ff-81eb-fb242a8cf1b6','__mount_options','fs=cephfs'),('2025-10-01 17:07:48.991708',NULL,'2025-10-01 17:07:52.613145',87,87,'510a1869-e04c-4711-b4ce-1bb86392d728','__mount_options','fs=cephfs'),('2025-10-01 17:07:49.314410',NULL,'2025-10-01 17:07:53.007792',88,88,'1a4303ab-fd5b-496c-ba7f-a6e9a95ee38c','__mount_options','fs=cephfs'),('2025-10-01 17:08:00.481430',NULL,'2025-10-01 17:08:03.314429',89,89,'8f916214-aa8c-4550-b818-ce6a422041bc','__mount_options','fs=cephfs'),('2025-10-01 17:08:00.488212',NULL,'2025-10-01 17:08:02.720914',90,90,'99044efa-e30e-406b-bd75-e0521344fb17','__mount_options','fs=cephfs'),('2025-10-01 17:08:06.800995',NULL,'2025-10-01 17:08:14.051201',91,91,'4c348280-32d6-4b4f-850a-a415d2397899','__mount_options','fs=cephfs'),('2025-10-01 17:08:17.623374',NULL,'2025-10-01 17:08:21.464784',92,92,'5c6f08b2-a238-4b91-9928-d6280590b74e','__mount_options','fs=cephfs'),('2025-10-01 17:08:26.389577',NULL,'2025-10-01 17:09:46.957280',93,93,'dff79459-719a-48f9-bc64-a4172051df45','foo_key_share_1','foo_value_share_1'),('2025-10-01 17:08:26.389870',NULL,'2025-10-01 17:09:46.957280',94,94,'dff79459-719a-48f9-bc64-a4172051df45','bar_key_share_1','foo_value_share_1'),('2025-10-01 17:08:27.217541',NULL,'2025-10-01 17:09:46.957280',95,95,'dff79459-719a-48f9-bc64-a4172051df45','__mount_options','fs=cephfs'),('2025-10-01 17:08:34.874484',NULL,'2025-10-01 17:09:40.410245',96,96,'6fcb0b46-4ab9-4125-aa81-25240782d372','foo_key_share_2','foo_value_share_2'),('2025-10-01 17:08:34.876186',NULL,'2025-10-01 17:09:40.410245',97,97,'6fcb0b46-4ab9-4125-aa81-25240782d372','bar_key_share_2','foo_value_share_2'),('2025-10-01 17:08:42.045140',NULL,'2025-10-01 17:09:40.410245',98,98,'6fcb0b46-4ab9-4125-aa81-25240782d372','__mount_options','fs=cephfs'),('2025-10-01 17:08:53.741444',NULL,'2025-10-01 17:09:06.192618',99,99,'fc6726f2-aad1-42b6-a319-9c17d82817a5','__mount_options','fs=cephfs'),('2025-10-01 17:08:59.338902',NULL,'2025-10-01 17:09:07.513341',100,100,'f6c69445-335c-4e53-abc0-d66b7aa436d5','__mount_options','fs=cephfs'),('2025-10-01 17:09:11.236205',NULL,'2025-10-01 17:09:24.203670',101,101,'3be0a77c-9477-462e-8eb4-10c3ba44b638','__mount_options','fs=cephfs'),('2025-10-01 17:09:18.071337',NULL,'2025-10-01 17:09:27.765549',102,102,'a0474f3d-dbe0-4366-bff6-13d06a99cfbd','__mount_options','fs=cephfs'),('2025-10-01 17:09:31.829620',NULL,'2025-10-01 17:09:36.898036',103,103,'f699304c-bc56-43fe-ae97-bee754cc0413','__mount_options','fs=cephfs'),('2025-10-01 17:09:36.374431',NULL,'2025-10-01 17:09:48.262986',104,104,'7abf0d63-e158-4ef2-9c76-e1cc6d2d2628','foo_key_share_1','foo_value_share_1'),('2025-10-01 17:09:36.374776',NULL,'2025-10-01 17:09:48.262986',105,105,'7abf0d63-e158-4ef2-9c76-e1cc6d2d2628','bar_key_share_1','foo_value_share_1'),('2025-10-01 17:09:36.678526',NULL,'2025-10-01 17:09:48.262986',106,106,'7abf0d63-e158-4ef2-9c76-e1cc6d2d2628','__mount_options','fs=cephfs'),('2025-10-01 17:10:00.089303',NULL,'2025-10-01 17:10:11.043909',107,107,'4fbc718e-e5a9-4005-93e5-22e43f8cccc0','__mount_options','fs=cephfs');
/*!40000 ALTER TABLE `share_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_network_security_service_association`
--

DROP TABLE IF EXISTS `share_network_security_service_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_network_security_service_association` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_network_id` varchar(36) NOT NULL,
  `security_service_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `share_network_id` (`share_network_id`),
  KEY `security_service_id` (`security_service_id`),
  CONSTRAINT `share_network_security_service_association_ibfk_1` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`),
  CONSTRAINT `share_network_security_service_association_ibfk_2` FOREIGN KEY (`security_service_id`) REFERENCES `security_services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_network_security_service_association`
--

LOCK TABLES `share_network_security_service_association` WRITE;
/*!40000 ALTER TABLE `share_network_security_service_association` DISABLE KEYS */;
INSERT INTO `share_network_security_service_association` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_network_id`, `security_service_id`) VALUES ('2025-10-01 17:03:34.871607','2025-10-01 17:03:37.267368','2025-10-01 17:03:37.265934',1,1,'6247910b-c15c-4d99-8cdb-aaa17d99bbf6','3b83d150-7abb-4af0-bfe4-3978b23b6812'),('2025-10-01 17:03:35.370945',NULL,NULL,0,2,'2eca4cd9-5d0b-457a-804f-53030c5bb840','00a49b98-4858-4678-8978-c19b2b8539ef'),('2025-10-01 17:06:22.867540','2025-10-01 17:06:27.692833','2025-10-01 17:06:27.691872',3,3,'581c283a-82a6-4062-b6e1-8e7e812414a5','071a9b46-f71d-400b-8e9a-5f8ea7cc3b60'),('2025-10-01 17:06:23.216565','2025-10-01 17:06:27.384038','2025-10-01 17:06:27.383380',4,4,'43a93d47-c9a7-4639-89c9-1288a0283e8e','794763b5-a145-481e-b94b-2de3ef05c532'),('2025-10-01 17:06:45.329069','2025-10-01 17:06:45.466790','2025-10-01 17:06:45.465726',5,5,'146b9f0d-41f2-433c-b831-a89f3046c46e','dc3c8379-a4b5-4966-847c-31876d1cb0d2'),('2025-10-01 17:06:46.744167','2025-10-01 17:06:47.046892','2025-10-01 17:06:47.046542',6,6,'90cb830f-f78d-449a-9ff3-b35bb2f1c0f9','221daa1f-21d5-4154-a0fe-48dd4b9df842'),('2025-10-01 17:06:47.853874','2025-10-01 17:06:47.970597','2025-10-01 17:06:47.970311',7,7,'a57ad7a8-5a22-465c-877a-69788cdad24d','97a33479-fdb0-4b59-b8ec-36159472c12b'),('2025-10-01 17:06:48.081200','2025-10-01 17:06:48.344134','2025-10-01 17:06:48.343834',8,8,'a57ad7a8-5a22-465c-877a-69788cdad24d','97a33479-fdb0-4b59-b8ec-36159472c12b'),('2025-10-01 17:06:57.333515','2025-10-01 17:07:01.249085','2025-10-01 17:07:01.248822',9,9,'c3f860cd-c039-4220-907a-d80130933cfc','613f6a19-72ac-4c29-afdd-6e30d1e1e219'),('2025-10-01 17:06:58.247254','2025-10-01 17:06:58.437886','2025-10-01 17:06:58.437648',10,10,'18cd16bf-6f41-40cd-b6e3-9718d5f58063','8ff9d8bd-d515-475d-9a13-c6277b92a22a'),('2025-10-01 17:06:59.341403','2025-10-01 17:06:59.762221','2025-10-01 17:06:59.761877',11,11,'de63ab48-5626-4e2e-86db-6342e1ccc408','572bea26-3742-493d-b718-a510eb20fe7b');
/*!40000 ALTER TABLE `share_network_security_service_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_network_subnet_metadata`
--

DROP TABLE IF EXISTS `share_network_subnet_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_network_subnet_metadata` (
  `deleted` varchar(36) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_network_subnet_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `share_network_subnet_id` (`share_network_subnet_id`),
  CONSTRAINT `share_network_subnet_metadata_ibfk_1` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_network_subnet_metadata`
--

LOCK TABLES `share_network_subnet_metadata` WRITE;
/*!40000 ALTER TABLE `share_network_subnet_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_network_subnet_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_network_subnets`
--

DROP TABLE IF EXISTS `share_network_subnets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_network_subnets` (
  `id` varchar(36) NOT NULL,
  `neutron_net_id` varchar(36) DEFAULT NULL,
  `neutron_subnet_id` varchar(36) DEFAULT NULL,
  `network_type` varchar(32) DEFAULT NULL,
  `cidr` varchar(64) DEFAULT NULL,
  `segmentation_id` int(11) DEFAULT NULL,
  `gateway` varchar(64) DEFAULT NULL,
  `mtu` int(11) DEFAULT NULL,
  `share_network_id` varchar(36) DEFAULT NULL,
  `ip_version` int(11) DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_share_network_subnets_share_network_id_share_networks` (`share_network_id`),
  KEY `fk_share_network_subnets_availaility_zone_id_availability_zones` (`availability_zone_id`),
  CONSTRAINT `fk_share_network_subnets_availaility_zone_id_availability_zones` FOREIGN KEY (`availability_zone_id`) REFERENCES `availability_zones` (`id`),
  CONSTRAINT `fk_share_network_subnets_share_network_id_share_networks` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_network_subnets`
--

LOCK TABLES `share_network_subnets` WRITE;
/*!40000 ALTER TABLE `share_network_subnets` DISABLE KEYS */;
INSERT INTO `share_network_subnets` (`id`, `neutron_net_id`, `neutron_subnet_id`, `network_type`, `cidr`, `segmentation_id`, `gateway`, `mtu`, `share_network_id`, `ip_version`, `availability_zone_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES ('00ee8436-1562-48c6-9510-b85596f1bb38','tempest-net-id-477604794','tempest-subnet-id-1513883759',NULL,NULL,NULL,NULL,NULL,'de63ab48-5626-4e2e-86db-6342e1ccc408',NULL,NULL,'2025-10-01 17:06:58.981569',NULL,NULL,'False'),('0646b5b4-fbaf-4026-8281-56ecdcb4459e','tempest-net-id-1560783579','tempest-subnet-id-1230946712',NULL,NULL,NULL,NULL,NULL,'b5f54dfd-6b1d-4686-895e-0ee0402ac820',NULL,NULL,'2025-10-01 17:06:23.311747',NULL,NULL,'False'),('08d50b51-32b9-4407-aa7a-e8ec7a0a1214','tempest-net-id-119275387','tempest-subnet-id-377350866',NULL,NULL,NULL,NULL,NULL,'624c854e-80e3-4205-9d59-78d647e93b05',NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','2025-10-01 17:03:59.817334','2025-10-01 17:03:59.989592','2025-10-01 17:03:59.989023','08d50b51-32b9-4407-aa7a-e8ec7a0a1214'),('0ec19270-f820-4797-bf3d-32247d84ec8a',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'624c854e-80e3-4205-9d59-78d647e93b05',NULL,NULL,'2025-10-01 17:03:59.590227',NULL,NULL,'False'),('156c0117-77ff-46e3-92e9-e38fab33bec1','test net id','test subnet id','local','10.0.0.0/13',2000,NULL,NULL,'2eca4cd9-5d0b-457a-804f-53030c5bb840',6,NULL,'2003-03-03 00:00:00.000000',NULL,NULL,'False'),('2b0eea4a-6a41-4739-9dd2-9c43f1e75ea4','tempest-net-id-762331','tempest-subnet-id-757077009',NULL,NULL,NULL,NULL,NULL,'c3824e8b-2626-4ca2-b2ed-bd5acd96ceb7',NULL,NULL,'2025-10-01 17:06:23.995384',NULL,NULL,'False'),('367a89fd-6345-455e-8315-00f0b429a2d1','tempest-net-id-492292300','tempest-subnet-id-1804677801',NULL,NULL,NULL,NULL,NULL,'6a2a4bcc-7ce1-419b-a29e-4d64253bfb7f',NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','2025-10-01 17:03:48.055953','2025-10-01 17:03:48.268152','2025-10-01 17:03:48.266545','367a89fd-6345-455e-8315-00f0b429a2d1'),('5473f36f-599d-483f-9a6a-d3e1a4b8be20',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'114ff03a-2baf-402c-af7e-4eba7f28a692',NULL,NULL,'2025-10-01 17:03:48.827801',NULL,NULL,'False'),('558ada6f-7f4a-46b2-a212-0336e18af26e','1111','2222','vlan','10.0.0.0/24',1000,NULL,NULL,'6247910b-c15c-4d99-8cdb-aaa17d99bbf6',4,NULL,'2002-02-02 00:00:00.000000',NULL,NULL,'False'),('5f3036f7-ba0f-4de4-ab15-a294dd16afdd','tempest-net-id-451085718','tempest-subnet-id-863090748',NULL,NULL,NULL,NULL,NULL,'146b9f0d-41f2-433c-b831-a89f3046c46e',NULL,NULL,'2025-10-01 17:06:45.072391',NULL,NULL,'False'),('6287e625-1ae9-4dc9-a489-42afc1b026e6','tempest-net-id-2030757766','tempest-subnet-id-1140777440',NULL,NULL,NULL,NULL,NULL,'cbd64481-bb1f-46b3-832f-12e49bc6a9f0',NULL,NULL,'2025-10-01 17:06:25.699272',NULL,NULL,'False'),('6b34225a-73e3-4082-922f-3c03c5b4527f',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'309222cc-181f-4d59-9691-1aff7d54d807',NULL,NULL,'2025-10-01 17:06:14.957005',NULL,NULL,'False'),('7025e984-c790-4050-bd92-835be9fbcc50',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'c3f860cd-c039-4220-907a-d80130933cfc',NULL,NULL,'2025-10-01 17:06:56.491239',NULL,NULL,'False'),('8a67519e-c8c5-4f51-a7ea-45f4658c8a3b',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'d506ec0c-49fd-4858-87b8-da7e0585286f',NULL,NULL,'2025-10-01 17:03:47.439758',NULL,NULL,'False'),('8f8f85eb-3a09-4821-91b8-335658ef86df','test net id','test subnet id','local','10.0.0.0/13',2000,NULL,NULL,'43a93d47-c9a7-4639-89c9-1288a0283e8e',6,NULL,'2003-03-03 00:00:00.000000',NULL,NULL,'False'),('95ef2eac-76a4-4d1f-bc83-abdf6e0cc400',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'6a2a4bcc-7ce1-419b-a29e-4d64253bfb7f',NULL,NULL,'2025-10-01 17:03:47.576790',NULL,NULL,'False'),('991682b2-4bb1-40a3-92e2-73a65ea0af84','tempest-net-id-1728917689','tempest-subnet-id-1689840724',NULL,NULL,NULL,NULL,NULL,'18cd16bf-6f41-40cd-b6e3-9718d5f58063',NULL,NULL,'2025-10-01 17:06:57.922939',NULL,NULL,'False'),('afa6bd43-74f6-4fa5-8207-d801940c6cd7','tempest-net-id-762331','tempest-subnet-id-757077009',NULL,NULL,NULL,NULL,NULL,'79c559da-df5d-491d-9c65-c9ae910fd919',NULL,NULL,'2025-10-01 17:06:23.847810',NULL,NULL,'False'),('b59003b0-4153-4daf-b6e9-fb63357afdf1','tempest-net-id-612603448','tempest-subnet-id-744380863',NULL,NULL,NULL,NULL,NULL,'90cb830f-f78d-449a-9ff3-b35bb2f1c0f9',NULL,NULL,'2025-10-01 17:06:46.360843',NULL,NULL,'False'),('c8b995c7-709a-45a1-b79f-b27d26323966','tempest-net-id-465325816','tempest-subnet-id-1596914197',NULL,NULL,NULL,NULL,NULL,'a57ad7a8-5a22-465c-877a-69788cdad24d',NULL,NULL,'2025-10-01 17:06:47.535793',NULL,NULL,'False'),('cf7ebd60-e149-443c-ba76-58b5ac354523','tempest-net-id-2030757766','tempest-subnet-id-1140777440',NULL,NULL,NULL,NULL,NULL,'08c5df96-b3cf-4a1d-98bf-d9daacf5d280',NULL,NULL,'2025-10-01 17:06:25.960597',NULL,NULL,'False'),('d6f213c8-fcfc-4f91-8b5d-0443b4cf67ba',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0fe27b89-8453-4f82-8af8-f350fec6a277',NULL,NULL,'2025-10-01 17:03:58.865133',NULL,NULL,'False'),('df2e1712-19cf-4d15-88c5-ebc268328ecd','tempest-net-id-1119758981','tempest-subnet-id-1715101761',NULL,NULL,NULL,NULL,NULL,'309222cc-181f-4d59-9691-1aff7d54d807',NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','2025-10-01 17:06:15.740952','2025-10-01 17:06:15.860470','2025-10-01 17:06:15.859160','df2e1712-19cf-4d15-88c5-ebc268328ecd'),('e1feebc9-e105-4195-ae30-5016215b7590','tempest-net-id-967199447','tempest-subnet-id-1670006287',NULL,NULL,NULL,NULL,NULL,'2ee1b252-675e-49d5-9492-9ff436a8ad88',NULL,NULL,'2025-10-01 17:04:00.619163',NULL,NULL,'False'),('e3a34658-dd5e-440e-947b-04c66013a93c','tempest-net-id-1350286488','tempest-subnet-id-22152792',NULL,NULL,NULL,NULL,NULL,'114ff03a-2baf-402c-af7e-4eba7f28a692',NULL,'2495df03-e710-42a7-9e3a-64fa89e58a2e','2025-10-01 17:03:49.063468','2025-10-01 17:03:49.310957','2025-10-01 17:03:49.310456','e3a34658-dd5e-440e-947b-04c66013a93c'),('f1193111-6957-40d2-87f6-1a40ef48eefb','tempest-net-id-513787513','tempest-subnet-id-1176887647','vlan','10.0.0.0/24',1000,NULL,NULL,'581c283a-82a6-4062-b6e1-8e7e812414a5',4,NULL,'2002-02-02 00:00:00.000000','2025-10-01 17:06:26.366607',NULL,'False');
/*!40000 ALTER TABLE `share_network_subnets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_networks`
--

DROP TABLE IF EXISTS `share_networks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_networks` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(36) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_networks`
--

LOCK TABLES `share_networks` WRITE;
/*!40000 ALTER TABLE `share_networks` DISABLE KEYS */;
INSERT INTO `share_networks` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `user_id`, `name`, `description`, `status`) VALUES ('2025-10-01 17:06:25.940722','2025-10-01 17:06:26.089507','2025-10-01 17:06:26.088897','08c5df96-b3cf-4a1d-98bf-d9daacf5d280','08c5df96-b3cf-4a1d-98bf-d9daacf5d280','89da7f149c6d414e94627e6e6c634ced','8945292d68314360add2298ae9496343','tempest-sn-name-1377981620','tempest-sn-desc-1923754220','active'),('2025-10-01 17:03:58.851692','2025-10-01 17:03:59.160510','2025-10-01 17:03:59.159709','0fe27b89-8453-4f82-8af8-f350fec6a277','0fe27b89-8453-4f82-8af8-f350fec6a277','76020c94a59c417e8bed7e7ea0fbb3bf','ed9c7605c9ba47fa826456bdb7485f23',NULL,NULL,'active'),('2025-10-01 17:03:48.806698','2025-10-01 17:03:49.567940','2025-10-01 17:03:49.567221','114ff03a-2baf-402c-af7e-4eba7f28a692','114ff03a-2baf-402c-af7e-4eba7f28a692','ba644d06236b4f928b914648a014fefa','c09dbb0e26b54de6b5ba772109c45853',NULL,NULL,'active'),('2025-10-01 17:06:45.009820','2025-10-01 17:06:45.857363','2025-10-01 17:06:45.856748','146b9f0d-41f2-433c-b831-a89f3046c46e','146b9f0d-41f2-433c-b831-a89f3046c46e','7b8bec1247f54479b803a9ec7e7655de','7f64c97f01d745219a4bd763f763f698','tempest-sn-name-1616106165','tempest-sn-desc-64229865','active'),('2025-10-01 17:06:57.900394','2025-10-01 17:06:58.690642','2025-10-01 17:06:58.690263','18cd16bf-6f41-40cd-b6e3-9718d5f58063','18cd16bf-6f41-40cd-b6e3-9718d5f58063','30cd3ce4e43d4122b839b6e5f4bf6511','38ae86a37a0b4939a6f90ce219165e47','tempest-sn-name-1397183326','tempest-sn-desc-946300144','active'),('2003-03-03 00:00:00.000000',NULL,NULL,'False','2eca4cd9-5d0b-457a-804f-53030c5bb840','9bd13d2e911f47bd8088546be105109c','d68a134fb2894956b0088cb7a9513af9','sn_with_kerberos_ss','fake description','active'),('2025-10-01 17:04:00.606279','2025-10-01 17:04:00.760685','2025-10-01 17:04:00.759919','2ee1b252-675e-49d5-9492-9ff436a8ad88','2ee1b252-675e-49d5-9492-9ff436a8ad88','76020c94a59c417e8bed7e7ea0fbb3bf','ed9c7605c9ba47fa826456bdb7485f23','tempest-sn-name-566848331','tempest-sn-desc-1495884528','active'),('2025-10-01 17:06:14.924316',NULL,NULL,'False','309222cc-181f-4d59-9691-1aff7d54d807','8b2c53e72b304ed58c7323214b5da098','bbe9b26c815c44cb9bf87c8ab647d6f0',NULL,NULL,'active'),('2003-03-03 00:00:00.000000','2025-10-01 17:06:27.416806','2025-10-01 17:06:27.416425','43a93d47-c9a7-4639-89c9-1288a0283e8e','43a93d47-c9a7-4639-89c9-1288a0283e8e','89da7f149c6d414e94627e6e6c634ced','8945292d68314360add2298ae9496343','sn_with_kerberos_ss','fake description','active'),('2002-02-02 00:00:00.000000','2025-10-01 17:06:27.721984','2025-10-01 17:06:27.721494','581c283a-82a6-4062-b6e1-8e7e812414a5','581c283a-82a6-4062-b6e1-8e7e812414a5','89da7f149c6d414e94627e6e6c634ced','8945292d68314360add2298ae9496343','tempest-sn-name-1984250750','tempest-sn-desc-423683240','active'),('2002-02-02 00:00:00.000000','2025-10-01 17:03:37.299960','2025-10-01 17:03:37.299014','6247910b-c15c-4d99-8cdb-aaa17d99bbf6','6247910b-c15c-4d99-8cdb-aaa17d99bbf6','01bc5d037e3c4524ae56d7d17d262d0d','76eea8115d324be1a5ea0e97a79df9d8','sn_with_ldap_ss','fake description','active'),('2025-10-01 17:03:59.540866','2025-10-01 17:04:00.245426','2025-10-01 17:04:00.245019','624c854e-80e3-4205-9d59-78d647e93b05','624c854e-80e3-4205-9d59-78d647e93b05','76020c94a59c417e8bed7e7ea0fbb3bf','ed9c7605c9ba47fa826456bdb7485f23',NULL,NULL,'active'),('2025-10-01 17:03:47.559933',NULL,NULL,'False','6a2a4bcc-7ce1-419b-a29e-4d64253bfb7f','ba644d06236b4f928b914648a014fefa','c09dbb0e26b54de6b5ba772109c45853',NULL,NULL,'active'),('2025-10-01 17:06:23.832739','2025-10-01 17:06:24.282929','2025-10-01 17:06:24.282374','79c559da-df5d-491d-9c65-c9ae910fd919','79c559da-df5d-491d-9c65-c9ae910fd919','89da7f149c6d414e94627e6e6c634ced','8945292d68314360add2298ae9496343','tempest-sn-name-598831933','tempest-sn-desc-733190779','active'),('2025-10-01 17:06:46.276562','2025-10-01 17:06:47.073510','2025-10-01 17:06:47.073095','90cb830f-f78d-449a-9ff3-b35bb2f1c0f9','90cb830f-f78d-449a-9ff3-b35bb2f1c0f9','7b8bec1247f54479b803a9ec7e7655de','7f64c97f01d745219a4bd763f763f698','tempest-sn-name-1892374270','tempest-sn-desc-486346481','active'),('2025-10-01 17:06:47.505765','2025-10-01 17:06:48.373939','2025-10-01 17:06:48.373409','a57ad7a8-5a22-465c-877a-69788cdad24d','a57ad7a8-5a22-465c-877a-69788cdad24d','7b8bec1247f54479b803a9ec7e7655de','7f64c97f01d745219a4bd763f763f698','tempest-sn-name-1476806678','tempest-sn-desc-1666571295','active'),('2025-10-01 17:06:23.292551','2025-10-01 17:06:23.449672','2025-10-01 17:06:23.449204','b5f54dfd-6b1d-4686-895e-0ee0402ac820','b5f54dfd-6b1d-4686-895e-0ee0402ac820','89da7f149c6d414e94627e6e6c634ced','8945292d68314360add2298ae9496343','tempest-sn-name-1967836266','tempest-sn-desc-1700268325','active'),('2025-10-01 17:06:23.982519','2025-10-01 17:06:24.101674','2025-10-01 17:06:24.101252','c3824e8b-2626-4ca2-b2ed-bd5acd96ceb7','c3824e8b-2626-4ca2-b2ed-bd5acd96ceb7','89da7f149c6d414e94627e6e6c634ced','8945292d68314360add2298ae9496343','tempest-sn-name-598831933','tempest-sn-desc-733190779','active'),('2025-10-01 17:06:56.454379','2025-10-01 17:07:01.269188','2025-10-01 17:07:01.268621','c3f860cd-c039-4220-907a-d80130933cfc','c3f860cd-c039-4220-907a-d80130933cfc','30cd3ce4e43d4122b839b6e5f4bf6511','38ae86a37a0b4939a6f90ce219165e47',NULL,NULL,'active'),('2025-10-01 17:06:25.680567','2025-10-01 17:06:25.831246','2025-10-01 17:06:25.830639','cbd64481-bb1f-46b3-832f-12e49bc6a9f0','cbd64481-bb1f-46b3-832f-12e49bc6a9f0','89da7f149c6d414e94627e6e6c634ced','8945292d68314360add2298ae9496343','tempest-sn-name-1377981620','tempest-sn-desc-1923754220','active'),('2025-10-01 17:03:47.419860','2025-10-01 17:03:48.601425','2025-10-01 17:03:48.600476','d506ec0c-49fd-4858-87b8-da7e0585286f','d506ec0c-49fd-4858-87b8-da7e0585286f','ba644d06236b4f928b914648a014fefa','c09dbb0e26b54de6b5ba772109c45853',NULL,NULL,'active'),('2025-10-01 17:06:58.916729','2025-10-01 17:06:59.783433','2025-10-01 17:06:59.782971','de63ab48-5626-4e2e-86db-6342e1ccc408','de63ab48-5626-4e2e-86db-6342e1ccc408','30cd3ce4e43d4122b839b6e5f4bf6511','38ae86a37a0b4939a6f90ce219165e47','tempest-sn-name-1421442407','tempest-sn-desc-1727786116','active');
/*!40000 ALTER TABLE `share_networks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_server_backend_details`
--

DROP TABLE IF EXISTS `share_server_backend_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_server_backend_details` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_server_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `share_server_id` (`share_server_id`),
  CONSTRAINT `share_server_backend_details_ibfk_1` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_server_backend_details`
--

LOCK TABLES `share_server_backend_details` WRITE;
/*!40000 ALTER TABLE `share_server_backend_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_server_backend_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_server_share_network_subnet_mappings`
--

DROP TABLE IF EXISTS `share_server_share_network_subnet_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_server_share_network_subnet_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_server_id` varchar(36) NOT NULL,
  `share_network_subnet_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_ss_sns_m_share_server_id_share_servers` (`share_server_id`),
  KEY `fk_ss_sns_m_share_network_subnet_id_share_network_subnets` (`share_network_subnet_id`),
  CONSTRAINT `fk_ss_sns_m_share_network_subnet_id_share_network_subnets` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`),
  CONSTRAINT `fk_ss_sns_m_share_server_id_share_servers` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_server_share_network_subnet_mappings`
--

LOCK TABLES `share_server_share_network_subnet_mappings` WRITE;
/*!40000 ALTER TABLE `share_server_share_network_subnet_mappings` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_server_share_network_subnet_mappings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_servers`
--

DROP TABLE IF EXISTS `share_servers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_servers` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `host` varchar(255) DEFAULT NULL,
  `status` varchar(32) DEFAULT NULL,
  `is_auto_deletable` tinyint(1) DEFAULT NULL,
  `identifier` varchar(255) DEFAULT NULL,
  `task_state` varchar(255) DEFAULT NULL,
  `source_share_server_id` varchar(36) DEFAULT NULL,
  `security_service_update_support` tinyint(1) NOT NULL DEFAULT 0,
  `network_allocation_update_support` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `fk_share_servers_source_share_server_id` (`source_share_server_id`),
  CONSTRAINT `fk_share_servers_source_share_server_id` FOREIGN KEY (`source_share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_servers`
--

LOCK TABLES `share_servers` WRITE;
/*!40000 ALTER TABLE `share_servers` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_servers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_access_map`
--

DROP TABLE IF EXISTS `share_snapshot_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_access_map` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_snapshot_id` varchar(36) DEFAULT NULL,
  `access_type` varchar(255) DEFAULT NULL,
  `access_to` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ssam_snapshot_fk` (`share_snapshot_id`),
  CONSTRAINT `ssam_snapshot_fk` FOREIGN KEY (`share_snapshot_id`) REFERENCES `share_snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_access_map`
--

LOCK TABLES `share_snapshot_access_map` WRITE;
/*!40000 ALTER TABLE `share_snapshot_access_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_snapshot_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_instance_access_map`
--

DROP TABLE IF EXISTS `share_snapshot_instance_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_instance_access_map` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_snapshot_instance_id` varchar(36) DEFAULT NULL,
  `access_id` varchar(36) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ssiam_snapshot_instance_fk` (`share_snapshot_instance_id`),
  KEY `ssam_access_fk` (`access_id`),
  CONSTRAINT `ssam_access_fk` FOREIGN KEY (`access_id`) REFERENCES `share_snapshot_access_map` (`id`),
  CONSTRAINT `ssiam_snapshot_instance_fk` FOREIGN KEY (`share_snapshot_instance_id`) REFERENCES `share_snapshot_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_instance_access_map`
--

LOCK TABLES `share_snapshot_instance_access_map` WRITE;
/*!40000 ALTER TABLE `share_snapshot_instance_access_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_snapshot_instance_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_instance_export_locations`
--

DROP TABLE IF EXISTS `share_snapshot_instance_export_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_instance_export_locations` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_snapshot_instance_id` varchar(36) DEFAULT NULL,
  `path` varchar(2000) DEFAULT NULL,
  `is_admin_only` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ssiel_snapshot_instance_fk` (`share_snapshot_instance_id`),
  CONSTRAINT `ssiel_snapshot_instance_fk` FOREIGN KEY (`share_snapshot_instance_id`) REFERENCES `share_snapshot_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_instance_export_locations`
--

LOCK TABLES `share_snapshot_instance_export_locations` WRITE;
/*!40000 ALTER TABLE `share_snapshot_instance_export_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_snapshot_instance_export_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_instances`
--

DROP TABLE IF EXISTS `share_snapshot_instances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_instances` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `share_instance_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `share_proto` varchar(255) DEFAULT NULL,
  `share_group_snapshot_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ssi_snapshot_fk` (`snapshot_id`),
  KEY `ssi_share_instance_fk` (`share_instance_id`),
  CONSTRAINT `ssi_share_instance_fk` FOREIGN KEY (`share_instance_id`) REFERENCES `share_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_instances`
--

LOCK TABLES `share_snapshot_instances` WRITE;
/*!40000 ALTER TABLE `share_snapshot_instances` DISABLE KEYS */;
INSERT INTO `share_snapshot_instances` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `snapshot_id`, `share_instance_id`, `status`, `progress`, `provider_location`, `user_id`, `project_id`, `size`, `share_proto`, `share_group_snapshot_id`) VALUES ('2025-10-01 17:01:05.041846','2025-10-01 17:01:46.698698','2025-10-01 17:01:46.697935','04def128-3433-4b04-912c-de5945031a2a','04def128-3433-4b04-912c-de5945031a2a','65fe10ee-973e-4685-94ee-6c8649be79ad','c469f818-07e0-4818-86b2-37da251687bb','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-10-01 17:09:12.825757','2025-10-01 17:09:21.405417','2025-10-01 17:09:21.404923','09e42390-3062-4d04-b349-f2f366d945b9','09e42390-3062-4d04-b349-f2f366d945b9','f6cc2e23-37ce-4b1d-a221-64aa3ffccc62','b4fd18da-d185-4d9e-9718-4a7a16198c6c','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-10-01 17:07:36.466383','2025-10-01 17:08:26.215269','2025-10-01 17:08:26.214616','0ae42b28-a7d0-4b1b-8156-5bc992766afc','0ae42b28-a7d0-4b1b-8156-5bc992766afc','b235c18d-212f-4b02-bc6d-e45b017ebaf4','afbc5b28-4a3d-4f5a-9775-80288db0083b','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-10-01 17:08:30.313405','2025-10-01 17:09:43.745744','2025-10-01 17:09:43.745299','0c523dfb-ea8e-423a-89c4-13a61256651c','0c523dfb-ea8e-423a-89c4-13a61256651c','f40cff96-8848-426c-90c1-e99c5be0398c','8bab47f1-016a-4c5f-8b58-46e57c02ad64','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-10-01 17:01:17.418227','2025-10-01 17:01:32.624828','2025-10-01 17:01:32.624417','14f6007c-8bd2-4e39-815d-0aa48f9a3796','14f6007c-8bd2-4e39-815d-0aa48f9a3796','82d8c993-67bf-46d4-81da-17b2c2b9d616','c469f818-07e0-4818-86b2-37da251687bb','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-10-01 17:07:05.013175','2025-10-01 17:08:11.412559','2025-10-01 17:08:11.412139','15352bd5-cb03-495a-99ef-36274a4b1dde','15352bd5-cb03-495a-99ef-36274a4b1dde','ef793e02-9980-4db2-8e9a-aaf0250b4696','7eafcb7a-4d98-4306-a178-8f37dd36887c','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-10-01 17:01:13.229012','2025-10-01 17:01:38.578162','2025-10-01 17:01:38.577577','372b8162-783c-4a60-a7f6-da25b169c7da','372b8162-783c-4a60-a7f6-da25b169c7da','99077526-b8d6-449c-8b0b-3d920742c77d','c469f818-07e0-4818-86b2-37da251687bb','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-10-01 17:06:11.357106','2025-10-01 17:06:17.509612','2025-10-01 17:06:17.509113','382469b8-5c61-468d-9898-1ac64a07b5fe','382469b8-5c61-468d-9898-1ac64a07b5fe','232f838a-1ec0-42c0-a4cb-74dcdee9927e','ea26f47e-6032-4f84-85c8-3aa43d68e5c0','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-10-01 17:03:56.965283','2025-10-01 17:04:05.592843','2025-10-01 17:04:05.592437','3e295899-8577-429c-89d2-8b88c17eefc7','3e295899-8577-429c-89d2-8b88c17eefc7','d7ed2ab1-74ac-4e22-96ae-0d4b6ae249f8','05ea150c-46e1-4db5-bef4-041e811a35f2','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-10-01 17:01:30.259527','2025-10-01 17:01:39.646082','2025-10-01 17:01:39.645566','4f34b0d7-ac8c-42b9-84bc-4ce41ca1bd2a','4f34b0d7-ac8c-42b9-84bc-4ce41ca1bd2a','95f0d76c-a17b-4697-b50f-2bff25aa56cd','c5ae6d5e-ebae-47c0-867d-5722bbee2320','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-10-01 17:02:15.507518','2025-10-01 17:02:20.993833','2025-10-01 17:02:20.993220','573d6d11-e29f-4de8-902a-26c52c887e40','573d6d11-e29f-4de8-902a-26c52c887e40','586d43f1-a8b2-44e0-b7f4-42b2e4ab8edf','aef1d813-6fa0-431e-85ff-6739a4057903','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-10-01 17:00:19.936689','2025-10-01 17:00:35.026902','2025-10-01 17:00:35.025848','5863d869-5948-4ff6-8691-98e4329485df','5863d869-5948-4ff6-8691-98e4329485df','eaae8952-6b44-417e-bb88-4247cfccb824','8d007d9c-80e4-4e40-ac68-5fe06e924d50','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-10-01 17:05:48.419390','2025-10-01 17:05:53.062350','2025-10-01 17:05:53.061027','64ac2cdb-3026-47ea-a540-30145adcb229','64ac2cdb-3026-47ea-a540-30145adcb229','e018909b-45d5-4fb2-882d-c4b0c2c5f1b4','ea26f47e-6032-4f84-85c8-3aa43d68e5c0','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-10-01 17:00:51.437912','2025-10-01 17:00:55.609995','2025-10-01 17:00:55.608711','64fa0867-43fa-4f45-819a-9b61bcc0a47e','64fa0867-43fa-4f45-819a-9b61bcc0a47e','56cc5791-7061-44c0-b106-1963f41e0a83','c469f818-07e0-4818-86b2-37da251687bb','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-10-01 17:06:41.795951','2025-10-01 17:06:45.772732','2025-10-01 17:06:45.771886','6f05dd35-7704-4276-8a47-d1965598e3c4','6f05dd35-7704-4276-8a47-d1965598e3c4','148c2cf7-d72f-4fa6-b40a-74fc8c8c25b7','297fd041-f36f-460b-b2b8-961d2f4e4832','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-10-01 17:01:21.683728','2025-10-01 17:01:26.385238','2025-10-01 17:01:26.384741','8d43c405-9c5d-44c9-8d91-7d233d10bd92','8d43c405-9c5d-44c9-8d91-7d233d10bd92','ce72fa9d-6cfa-4bc1-9bbe-b500ad65a9aa','c469f818-07e0-4818-86b2-37da251687bb','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-10-01 17:08:55.895825','2025-10-01 17:09:03.538725','2025-10-01 17:09:03.538307','a0cf2fa8-f1f6-4269-a744-da5e4a160b4f','a0cf2fa8-f1f6-4269-a744-da5e4a160b4f','b0203c1e-2e73-4e30-956c-1b8e7eb6fbb1','f1653434-fb19-4bc0-85ed-a5473c6d290d','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-10-01 17:01:28.871368','2025-10-01 17:02:08.833862','2025-10-01 17:02:08.833455','a1863850-c70c-4354-b0f9-49d9f8e0d5cf','a1863850-c70c-4354-b0f9-49d9f8e0d5cf','0836034c-448e-4a12-a3fa-b569fb708078','93b513ed-8592-46d2-ae45-b578c4708055','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-10-01 17:03:57.956922','2025-10-01 17:04:02.116256','2025-10-01 17:04:02.115293','af799ca1-a7f4-4812-94f2-d79db8e45f3d','af799ca1-a7f4-4812-94f2-d79db8e45f3d','2c3c3790-b86d-42b8-9d53-c0c1697de805','05ea150c-46e1-4db5-bef4-041e811a35f2','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-10-01 17:01:09.219546','2025-10-01 17:01:43.121213','2025-10-01 17:01:43.120789','b975d937-f96d-40aa-9e6e-dd7325454ef0','b975d937-f96d-40aa-9e6e-dd7325454ef0','0efe5646-e561-4cdf-9c56-ad36284bde88','c469f818-07e0-4818-86b2-37da251687bb','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-10-01 17:10:02.448511','2025-10-01 17:10:07.650265','2025-10-01 17:10:07.649837','c98a7624-3617-42e0-a937-3a16d4696ffc','c98a7624-3617-42e0-a937-3a16d4696ffc','345ab768-d585-48ee-ab8b-ca5dc8b6d2f3','d5107ec8-a115-44fa-8f38-14e43f7ac582','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-10-01 17:07:00.905392','2025-10-01 17:07:08.751450','2025-10-01 17:07:08.750921','ca7f273a-3f2e-41e5-9026-1064e83c48b4','ca7f273a-3f2e-41e5-9026-1064e83c48b4','75cadf3c-64ac-47cc-8482-523c4f46622a','efdb0876-5085-415d-ba20-1a51461b6ac1','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-10-01 17:06:04.071989','2025-10-01 17:06:08.147693','2025-10-01 17:06:08.147138','d2c9ceb9-9055-45e2-8c01-789f174f4dee','d2c9ceb9-9055-45e2-8c01-789f174f4dee','508b7f89-fa92-48b9-b840-d766077bff91','ea26f47e-6032-4f84-85c8-3aa43d68e5c0','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-10-01 17:05:44.980737','2025-10-01 17:06:32.574660','2025-10-01 17:06:32.574035','e46ea2a4-d9e1-42b5-87f3-7f48e3b76778','e46ea2a4-d9e1-42b5-87f3-7f48e3b76778','994e3294-4a8a-410f-bff7-df7bb18891d7','ea26f47e-6032-4f84-85c8-3aa43d68e5c0','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-10-01 17:05:56.056623','2025-10-01 17:06:01.016533','2025-10-01 17:06:01.015982','ef8e3ff4-43a7-4d58-be3c-7a40a4de32c8','ef8e3ff4-43a7-4d58-be3c-7a40a4de32c8','02b52745-7744-41a8-9356-5182381bc1a5','ea26f47e-6032-4f84-85c8-3aa43d68e5c0','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-10-01 17:06:22.115884','2025-10-01 17:06:28.482326','2025-10-01 17:06:28.481761','f50acf3d-60cf-43a2-976c-bfe81b0a66da','f50acf3d-60cf-43a2-976c-bfe81b0a66da','dbbe1979-4322-4f6e-adb1-00435680f5b2','ea26f47e-6032-4f84-85c8-3aa43d68e5c0','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-10-01 17:09:39.863746','2025-10-01 17:09:45.346119','2025-10-01 17:09:45.345498','fbc8b7cc-a3c5-4938-a7e9-5dd26846f601','fbc8b7cc-a3c5-4938-a7e9-5dd26846f601','9df0b9f8-e591-4a39-b66c-e88c6cec14cd','0f3443b9-e9d9-4a47-839c-8c53679a0f3e','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `share_snapshot_instances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_metadata`
--

DROP TABLE IF EXISTS `share_snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_metadata` (
  `deleted` varchar(36) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `share_snapshot_id` (`share_snapshot_id`),
  CONSTRAINT `share_snapshot_metadata_ibfk_1` FOREIGN KEY (`share_snapshot_id`) REFERENCES `share_snapshots` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_metadata`
--

LOCK TABLES `share_snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `share_snapshot_metadata` DISABLE KEYS */;
INSERT INTO `share_snapshot_metadata` (`deleted`, `created_at`, `updated_at`, `deleted_at`, `share_snapshot_id`, `key`, `value`, `id`) VALUES ('1','2025-10-01 17:05:51.790925','2025-10-01 17:05:52.028736','2025-10-01 17:05:53.099530','e018909b-45d5-4fb2-882d-c4b0c2c5f1b4','key5','value5',1),('2','2025-10-01 17:05:51.793217','2025-10-01 17:05:52.065840','2025-10-01 17:05:53.099530','e018909b-45d5-4fb2-882d-c4b0c2c5f1b4','key6','value6',2),('3','2025-10-01 17:05:52.095160',NULL,'2025-10-01 17:05:53.099530','e018909b-45d5-4fb2-882d-c4b0c2c5f1b4','key7','value7',3),('4','2025-10-01 17:05:52.097328',NULL,'2025-10-01 17:05:53.099530','e018909b-45d5-4fb2-882d-c4b0c2c5f1b4','key8','value8',4),('5','2025-10-01 17:05:59.476922','2025-10-01 17:06:00.047519','2025-10-01 17:06:01.032857','02b52745-7744-41a8-9356-5182381bc1a5','key3','value3',5),('6','2025-10-01 17:05:59.480164','2025-10-01 17:06:00.176434','2025-10-01 17:06:01.032857','02b52745-7744-41a8-9356-5182381bc1a5','key4','value4',6),('7','2025-10-01 17:05:59.482779','2025-10-01 17:06:00.339613','2025-10-01 17:06:01.032857','02b52745-7744-41a8-9356-5182381bc1a5','key.5.1','value.5',7),('8','2025-10-01 17:06:04.070819',NULL,'2025-10-01 17:06:08.165984','508b7f89-fa92-48b9-b840-d766077bff91','key1','value1',8),('9','2025-10-01 17:06:04.071191',NULL,'2025-10-01 17:06:08.165984','508b7f89-fa92-48b9-b840-d766077bff91','key2','value2',9),('10','2025-10-01 17:06:15.038321','2025-10-01 17:06:16.260485','2025-10-01 17:06:17.526112','232f838a-1ec0-42c0-a4cb-74dcdee9927e','key9','value13',10),('11','2025-10-01 17:06:15.040992','2025-10-01 17:06:16.519862','2025-10-01 17:06:17.526112','232f838a-1ec0-42c0-a4cb-74dcdee9927e','key10','value10',11),('12','2025-10-01 17:06:15.558545','2025-10-01 17:06:16.671613','2025-10-01 17:06:17.526112','232f838a-1ec0-42c0-a4cb-74dcdee9927e','key11','value11',12),('13','2025-10-01 17:06:20.403962','2025-10-01 17:06:28.820854','2025-10-01 17:06:32.631454','994e3294-4a8a-410f-bff7-df7bb18891d7','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value',13),('14','2025-10-01 17:06:20.868168','2025-10-01 17:06:28.867893','2025-10-01 17:06:32.631454','994e3294-4a8a-410f-bff7-df7bb18891d7','key','v',14),('15','2025-10-01 17:06:21.362406','2025-10-01 17:06:28.946973','2025-10-01 17:06:32.631454','994e3294-4a8a-410f-bff7-df7bb18891d7','k','value',15),('16','2025-10-01 17:06:25.776452','2025-10-01 17:06:27.324187','2025-10-01 17:06:28.498359','dbbe1979-4322-4f6e-adb1-00435680f5b2','key9','value9',16),('17','2025-10-01 17:06:25.778894','2025-10-01 17:06:27.468361','2025-10-01 17:06:28.498359','dbbe1979-4322-4f6e-adb1-00435680f5b2','key10','value10',17),('18','2025-10-01 17:06:26.280269','2025-10-01 17:06:27.667647','2025-10-01 17:06:28.498359','dbbe1979-4322-4f6e-adb1-00435680f5b2','key11','value11',18),('19','2025-10-01 17:06:26.282324','2025-10-01 17:06:27.821486','2025-10-01 17:06:28.498359','dbbe1979-4322-4f6e-adb1-00435680f5b2','key12','value12',19),('20','2025-10-01 17:06:29.006809','2025-10-01 17:06:29.401892','2025-10-01 17:06:32.631454','994e3294-4a8a-410f-bff7-df7bb18891d7','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value',20),('21','2025-10-01 17:06:29.456584','2025-10-01 17:06:30.058081','2025-10-01 17:06:32.631454','994e3294-4a8a-410f-bff7-df7bb18891d7','key','vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv',21),('22','2025-10-01 17:06:30.125099','2025-10-01 17:06:30.826873','2025-10-01 17:06:32.631454','994e3294-4a8a-410f-bff7-df7bb18891d7','k','value',22),('23','2025-10-01 17:06:30.865639',NULL,'2025-10-01 17:06:32.631454','994e3294-4a8a-410f-bff7-df7bb18891d7','key','v',23);
/*!40000 ALTER TABLE `share_snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshots`
--

DROP TABLE IF EXISTS `share_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshots` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `share_id` varchar(36) NOT NULL,
  `size` int(11) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `share_size` int(11) DEFAULT NULL,
  `share_proto` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_id` (`share_id`),
  CONSTRAINT `share_snapshots_ibfk_1` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshots`
--

LOCK TABLES `share_snapshots` WRITE;
/*!40000 ALTER TABLE `share_snapshots` DISABLE KEYS */;
INSERT INTO `share_snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `share_id`, `size`, `display_name`, `display_description`, `share_size`, `share_proto`) VALUES ('2025-10-01 17:05:56.055221','2025-10-01 17:06:01.035568','2025-10-01 17:06:01.034355','02b52745-7744-41a8-9356-5182381bc1a5','02b52745-7744-41a8-9356-5182381bc1a5','c0d8712c5da945d1ba492d2950f68d35','40c3564ff57e4cfca7dd255e456bdcb2','f8eb063b-f94f-4394-a2be-7bbf2414c84c',1,'tempest-tempest-created-share-snap-2023080619','Tempest\'s snapshot',1,'CEPHFS'),('2025-10-01 17:01:28.870442','2025-10-01 17:02:08.851293','2025-10-01 17:02:08.850706','0836034c-448e-4a12-a3fa-b569fb708078','0836034c-448e-4a12-a3fa-b569fb708078','0330a1c6d11e45b8a6e21e8e46c29677','0e7ac90f0c9f41cbb8e463ae95d18d81','db0e695b-e59d-484f-ba2e-6e5ec878cc21',1,'tempest-tempest-snapshot-name-500526916','tempest-tempest-snapshot-description-1180102687',1,'CEPHFS'),('2025-10-01 17:01:09.218271','2025-10-01 17:01:43.138485','2025-10-01 17:01:43.138068','0efe5646-e561-4cdf-9c56-ad36284bde88','0efe5646-e561-4cdf-9c56-ad36284bde88','f01d6292274540ac84c2c1da0ccbaedb','2204ae41373c4a57a26d8e752f9c9721','95bc68e4-4409-4a9b-83c9-5b9c7854b687',1,'tempest-tempest-created-share-snap-1118158628','Tempest\'s snapshot',1,'CEPHFS'),('2025-10-01 17:06:41.794883','2025-10-01 17:06:45.788951','2025-10-01 17:06:45.788432','148c2cf7-d72f-4fa6-b40a-74fc8c8c25b7','148c2cf7-d72f-4fa6-b40a-74fc8c8c25b7','fcbf8552ba484efaa8cae2712992af80','384850ddb88c4d3798b3a3d365973ad0','69635b4c-8f40-4a57-90cc-d550c183c871',1,'tempest-tempest-created-share-snap-1787745676','Tempest\'s snapshot',1,'CEPHFS'),('2025-10-01 17:06:11.354841','2025-10-01 17:06:17.527841','2025-10-01 17:06:17.527542','232f838a-1ec0-42c0-a4cb-74dcdee9927e','232f838a-1ec0-42c0-a4cb-74dcdee9927e','c0d8712c5da945d1ba492d2950f68d35','40c3564ff57e4cfca7dd255e456bdcb2','f8eb063b-f94f-4394-a2be-7bbf2414c84c',1,'tempest-tempest-created-share-snap-2144171143','Tempest\'s snapshot',1,'CEPHFS'),('2025-10-01 17:03:57.955343','2025-10-01 17:04:02.133929','2025-10-01 17:04:02.133367','2c3c3790-b86d-42b8-9d53-c0c1697de805','2c3c3790-b86d-42b8-9d53-c0c1697de805','b2685616371841959873dec890fa5385','5473075ec2e4439eadc201afc270390c','bb669f14-71a4-4987-aaff-00e14218a038',1,'tempest-tempest-created-share-snap-663611066','Tempest\'s snapshot',1,'CEPHFS'),('2025-10-01 17:10:02.447407','2025-10-01 17:10:07.661652','2025-10-01 17:10:07.661292','345ab768-d585-48ee-ab8b-ca5dc8b6d2f3','345ab768-d585-48ee-ab8b-ca5dc8b6d2f3','7b4f3ac1db9d4257ad4205e53cd20033','e168bce9fe04489288d3480d858b4158','4fbc718e-e5a9-4005-93e5-22e43f8cccc0',1,'tempest-tempest-new-name-for-snapshot-285117930','tempest-tempest-new-description-for-snapshot-1996299096',1,'CEPHFS'),('2025-10-01 17:06:04.069812','2025-10-01 17:06:08.169330','2025-10-01 17:06:08.168749','508b7f89-fa92-48b9-b840-d766077bff91','508b7f89-fa92-48b9-b840-d766077bff91','c0d8712c5da945d1ba492d2950f68d35','40c3564ff57e4cfca7dd255e456bdcb2','f8eb063b-f94f-4394-a2be-7bbf2414c84c',1,'tempest-tempest-created-share-snap-821829554','Tempest\'s snapshot',1,'CEPHFS'),('2025-10-01 17:00:51.436546','2025-10-01 17:00:55.633029','2025-10-01 17:00:55.632489','56cc5791-7061-44c0-b106-1963f41e0a83','56cc5791-7061-44c0-b106-1963f41e0a83','f01d6292274540ac84c2c1da0ccbaedb','2204ae41373c4a57a26d8e752f9c9721','95bc68e4-4409-4a9b-83c9-5b9c7854b687',1,'tempest-tempest-created-share-snap-1704139252','Tempest\'s snapshot',1,'CEPHFS'),('2025-10-01 17:02:15.505987','2025-10-01 17:02:21.007380','2025-10-01 17:02:21.006852','586d43f1-a8b2-44e0-b7f4-42b2e4ab8edf','586d43f1-a8b2-44e0-b7f4-42b2e4ab8edf','ea1821978b91472190eb48dbc2127e63','0146329fc8d749b394ed822844000f6d','f85090ff-591b-405d-88b6-36d427ce5b6a',1,'tempest-tempest-created-share-snap-743845648','Tempest\'s snapshot',1,'CEPHFS'),('2025-10-01 17:01:05.040699','2025-10-01 17:01:46.719636','2025-10-01 17:01:46.719147','65fe10ee-973e-4685-94ee-6c8649be79ad','65fe10ee-973e-4685-94ee-6c8649be79ad','f01d6292274540ac84c2c1da0ccbaedb','2204ae41373c4a57a26d8e752f9c9721','95bc68e4-4409-4a9b-83c9-5b9c7854b687',1,'tempest-tempest-created-share-snap-536916639','Tempest\'s snapshot',1,'CEPHFS'),('2025-10-01 17:07:00.904087','2025-10-01 17:07:08.765766','2025-10-01 17:07:08.765225','75cadf3c-64ac-47cc-8482-523c4f46622a','75cadf3c-64ac-47cc-8482-523c4f46622a','fdec41847e24465299bb1f75d3e480d2','7697ecff3b5f413c99a5ace837dd6970','e160f19c-fd45-4300-abd5-b3a4764aea08',1,'tempest-tempest-created-share-snap-1372008737','Tempest\'s snapshot',1,'CEPHFS'),('2025-10-01 17:01:17.417356','2025-10-01 17:01:32.653373','2025-10-01 17:01:32.652920','82d8c993-67bf-46d4-81da-17b2c2b9d616','82d8c993-67bf-46d4-81da-17b2c2b9d616','f01d6292274540ac84c2c1da0ccbaedb','2204ae41373c4a57a26d8e752f9c9721','95bc68e4-4409-4a9b-83c9-5b9c7854b687',1,'tempest-tempest-created-share-snap-779314523','Tempest\'s snapshot',1,'CEPHFS'),('2025-10-01 17:01:30.258530','2025-10-01 17:01:39.665200','2025-10-01 17:01:39.664741','95f0d76c-a17b-4697-b50f-2bff25aa56cd','95f0d76c-a17b-4697-b50f-2bff25aa56cd','c7bd5ab094534136b1906389e4264c0b','756b231c8c724081bed78676d19a02ec','e3193d43-5ad0-4a4b-b5ad-b33441f5b578',1,'tempest-tempest-created-share-snap-1989151291','Tempest\'s snapshot',1,'CEPHFS'),('2025-10-01 17:01:13.227391','2025-10-01 17:01:38.600497','2025-10-01 17:01:38.599955','99077526-b8d6-449c-8b0b-3d920742c77d','99077526-b8d6-449c-8b0b-3d920742c77d','f01d6292274540ac84c2c1da0ccbaedb','2204ae41373c4a57a26d8e752f9c9721','95bc68e4-4409-4a9b-83c9-5b9c7854b687',1,'tempest-tempest-created-share-snap-1037141820','Tempest\'s snapshot',1,'CEPHFS'),('2025-10-01 17:05:44.979698','2025-10-01 17:06:32.633024','2025-10-01 17:06:32.632570','994e3294-4a8a-410f-bff7-df7bb18891d7','994e3294-4a8a-410f-bff7-df7bb18891d7','c0d8712c5da945d1ba492d2950f68d35','40c3564ff57e4cfca7dd255e456bdcb2','f8eb063b-f94f-4394-a2be-7bbf2414c84c',1,'tempest-tempest-snapshot-name-1404740530','tempest-tempest-snapshot-description-1142928780',1,'CEPHFS'),('2025-10-01 17:09:39.862857','2025-10-01 17:09:45.362249','2025-10-01 17:09:45.361743','9df0b9f8-e591-4a39-b66c-e88c6cec14cd','9df0b9f8-e591-4a39-b66c-e88c6cec14cd','8535d97e92664479824a211407aa1fdc','0103e60cf08a41ecb4737770562548a5','7abf0d63-e158-4ef2-9c76-e1cc6d2d2628',1,'tempest-tempest-snapshot-name-478248387','tempest-tempest-snapshot-description-1660478991',1,'CEPHFS'),('2025-10-01 17:08:55.894643','2025-10-01 17:09:03.558680','2025-10-01 17:09:03.558263','b0203c1e-2e73-4e30-956c-1b8e7eb6fbb1','b0203c1e-2e73-4e30-956c-1b8e7eb6fbb1','1bcf3990c34341488ff134d67569a00c','a942627ec05749c09a975132ee6031d6','fc6726f2-aad1-42b6-a319-9c17d82817a5',2,'tempest-tempest-created-share-snap-2061860686','Tempest\'s snapshot',2,'CEPHFS'),('2025-10-01 17:07:36.465155','2025-10-01 17:08:26.237525','2025-10-01 17:08:26.237074','b235c18d-212f-4b02-bc6d-e45b017ebaf4','b235c18d-212f-4b02-bc6d-e45b017ebaf4','e660ba5c7b304e2abc80f9b99bdd51af','29266081bf264ee18aad20d4882a428c','475eaf7b-7be8-4075-99c6-46b38f1b33fb',1,'tempest-tempest-snapshot-name-864408190','tempest-tempest-snapshot-description-98813884',1,'CEPHFS'),('2025-10-01 17:01:21.682675','2025-10-01 17:01:26.406176','2025-10-01 17:01:26.405763','ce72fa9d-6cfa-4bc1-9bbe-b500ad65a9aa','ce72fa9d-6cfa-4bc1-9bbe-b500ad65a9aa','f01d6292274540ac84c2c1da0ccbaedb','2204ae41373c4a57a26d8e752f9c9721','95bc68e4-4409-4a9b-83c9-5b9c7854b687',1,'tempest-tempest-created-share-snap-1520613924','Tempest\'s snapshot',1,'CEPHFS'),('2025-10-01 17:03:56.964302','2025-10-01 17:04:05.604610','2025-10-01 17:04:05.604240','d7ed2ab1-74ac-4e22-96ae-0d4b6ae249f8','d7ed2ab1-74ac-4e22-96ae-0d4b6ae249f8','b2685616371841959873dec890fa5385','5473075ec2e4439eadc201afc270390c','bb669f14-71a4-4987-aaff-00e14218a038',1,'tempest-tempest-created-share-snap-106526487','Tempest\'s snapshot',1,'CEPHFS'),('2025-10-01 17:06:22.114994','2025-10-01 17:06:28.500276','2025-10-01 17:06:28.499725','dbbe1979-4322-4f6e-adb1-00435680f5b2','dbbe1979-4322-4f6e-adb1-00435680f5b2','c0d8712c5da945d1ba492d2950f68d35','40c3564ff57e4cfca7dd255e456bdcb2','f8eb063b-f94f-4394-a2be-7bbf2414c84c',1,'tempest-tempest-created-share-snap-1067801495','Tempest\'s snapshot',1,'CEPHFS'),('2025-10-01 17:05:48.418365','2025-10-01 17:05:53.102389','2025-10-01 17:05:53.101757','e018909b-45d5-4fb2-882d-c4b0c2c5f1b4','e018909b-45d5-4fb2-882d-c4b0c2c5f1b4','c0d8712c5da945d1ba492d2950f68d35','40c3564ff57e4cfca7dd255e456bdcb2','f8eb063b-f94f-4394-a2be-7bbf2414c84c',1,'tempest-tempest-created-share-snap-1601372635','Tempest\'s snapshot',1,'CEPHFS'),('2025-10-01 17:00:19.934795','2025-10-01 17:00:35.053767','2025-10-01 17:00:35.052582','eaae8952-6b44-417e-bb88-4247cfccb824','eaae8952-6b44-417e-bb88-4247cfccb824','0c2a887dd4a845859f0669eb83fe675c','1f4a5d54519f4f46897a6eba8668a5c4','99b03a60-1080-43f4-9d57-6a2ffd473ac6',1,'tempest-tempest-created-share-snap-1089425938','Tempest\'s snapshot',1,'CEPHFS'),('2025-10-01 17:07:05.012255','2025-10-01 17:08:11.429029','2025-10-01 17:08:11.428581','ef793e02-9980-4db2-8e9a-aaf0250b4696','ef793e02-9980-4db2-8e9a-aaf0250b4696','fcbf8552ba484efaa8cae2712992af80','384850ddb88c4d3798b3a3d365973ad0','aa416fc6-23c7-4223-ab29-52b404b91845',1,'tempest-tempest-created-share-snap-1975758902','Tempest\'s snapshot',1,'CEPHFS'),('2025-10-01 17:08:30.312284','2025-10-01 17:09:43.757774','2025-10-01 17:09:43.757365','f40cff96-8848-426c-90c1-e99c5be0398c','f40cff96-8848-426c-90c1-e99c5be0398c','c6801335b5594dc38e737626407c353c','2d1156e4dd1a4bcf99d7af9680c3c563','dff79459-719a-48f9-bc64-a4172051df45',1,'tempest-tempest-snapshot-name-2004792664','tempest-tempest-snapshot-description-1038301456',1,'CEPHFS'),('2025-10-01 17:09:12.823957','2025-10-01 17:09:21.421942','2025-10-01 17:09:21.421626','f6cc2e23-37ce-4b1d-a221-64aa3ffccc62','f6cc2e23-37ce-4b1d-a221-64aa3ffccc62','1bcf3990c34341488ff134d67569a00c','a942627ec05749c09a975132ee6031d6','3be0a77c-9477-462e-8eb4-10c3ba44b638',1,'tempest-tempest-created-share-snap-1653334080','Tempest\'s snapshot',1,'CEPHFS');
/*!40000 ALTER TABLE `share_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_type_extra_specs`
--

DROP TABLE IF EXISTS `share_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_type_extra_specs` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_type_id` varchar(36) NOT NULL,
  `spec_key` varchar(255) DEFAULT NULL,
  `spec_value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `st_id_fk` (`share_type_id`),
  CONSTRAINT `st_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=293 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_type_extra_specs`
--

LOCK TABLES `share_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `share_type_extra_specs` DISABLE KEYS */;
INSERT INTO `share_type_extra_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_type_id`, `spec_key`, `spec_value`) VALUES ('2025-10-01 16:57:02.366935',NULL,NULL,0,1,'a8a00136-83b3-4010-b21e-0ef332301b8d','driver_handles_share_servers','False'),('2025-10-01 16:57:06.824551',NULL,NULL,0,2,'a8a00136-83b3-4010-b21e-0ef332301b8d','snapshot_support','True'),('2025-10-01 16:57:06.908109',NULL,NULL,0,3,'a8a00136-83b3-4010-b21e-0ef332301b8d','create_share_from_snapshot_support','True'),('2025-10-01 17:00:13.218702',NULL,'2025-10-01 17:00:45.489164',4,4,'eeda9f95-f5c3-4f07-b12e-0b18f7c8da37','driver_handles_share_servers','False'),('2025-10-01 17:00:13.276724',NULL,'2025-10-01 17:01:54.444421',5,5,'8844ab0c-8acf-432e-bb69-abd01348cc0a','driver_handles_share_servers','False'),('2025-10-01 17:00:13.277878',NULL,'2025-10-01 17:01:54.444421',6,6,'8844ab0c-8acf-432e-bb69-abd01348cc0a','snapshot_support','True'),('2025-10-01 17:00:15.669029',NULL,'2025-10-01 17:00:41.559879',7,7,'9a2a36a8-eb90-44b3-beb1-6fa464aeb5a0','driver_handles_share_servers','False'),('2025-10-01 17:00:15.669421',NULL,'2025-10-01 17:00:41.559879',8,8,'9a2a36a8-eb90-44b3-beb1-6fa464aeb5a0','snapshot_support','True'),('2025-10-01 17:00:17.371984',NULL,'2025-10-01 17:00:28.146352',9,9,'fc0b7d99-26ca-4334-8407-02cec26a8f38','driver_handles_share_servers','False'),('2025-10-01 17:00:23.938700',NULL,'2025-10-01 17:00:33.918219',10,10,'a5f21ade-ee10-4428-9797-73f01ecba1e1','driver_handles_share_servers','False'),('2025-10-01 17:00:24.076294',NULL,'2025-10-01 17:00:33.757573',11,11,'1c9a4a43-4754-4260-8467-f6a0fb84b228','driver_handles_share_servers','False'),('2025-10-01 17:00:24.218793',NULL,'2025-10-01 17:00:33.570458',12,12,'2b311965-978b-4e21-8e6d-dc07a8b8fa29','driver_handles_share_servers','False'),('2025-10-01 17:00:25.731104',NULL,'2025-10-01 17:00:33.422331',13,13,'831f09b5-c2ff-4676-b095-49f40712f6c2','driver_handles_share_servers','False'),('2025-10-01 17:00:25.839325',NULL,'2025-10-01 17:00:33.034913',14,14,'a8689b71-3132-4044-8cd3-2db6227c1239','driver_handles_share_servers','False'),('2025-10-01 17:00:25.957022',NULL,'2025-10-01 17:00:32.837035',15,15,'10fc409b-8dba-4277-9100-af73717fb989','driver_handles_share_servers','False'),('2025-10-01 17:00:28.379204',NULL,'2025-10-01 17:00:32.684333',16,16,'b08160ee-a1b6-438e-87be-76b8acd3a0ae','driver_handles_share_servers','False'),('2025-10-01 17:00:28.900320',NULL,'2025-10-01 17:00:32.468470',17,17,'1708c008-1127-4fb6-a3d8-a9a2dc01c70e','driver_handles_share_servers','False'),('2025-10-01 17:00:29.367270',NULL,'2025-10-01 17:00:32.337880',18,18,'d4f074e1-6ea4-42dc-8e92-5e6796f377c5','driver_handles_share_servers','False'),('2025-10-01 17:00:29.626482',NULL,'2025-10-01 17:00:32.019995',19,19,'b3409aaa-61e2-4fea-885e-c35e67cc2cc6','driver_handles_share_servers','False'),('2025-10-01 17:00:30.549354',NULL,'2025-10-01 17:00:31.570685',20,20,'49630013-721a-4007-9b5c-2072c4d37883','driver_handles_share_servers','False'),('2025-10-01 17:00:30.859217',NULL,'2025-10-01 17:00:31.341597',21,21,'74fb446d-3c2c-4141-83e6-b5517ccb46cf','driver_handles_share_servers','False'),('2025-10-01 17:00:35.405211',NULL,'2025-10-01 17:00:36.952115',22,22,'0ba61c30-e98e-4d9b-a0fd-baa1003f2894','driver_handles_share_servers','False'),('2025-10-01 17:00:36.007916',NULL,'2025-10-01 17:00:45.020450',23,23,'e8d8a1fc-ec5d-43c2-aabc-ffea9e499c55','driver_handles_share_servers','False'),('2025-10-01 17:00:36.131238',NULL,'2025-10-01 17:00:36.412996',24,24,'771760e5-2a41-47e9-9f05-5efee16fed37','driver_handles_share_servers','False'),('2025-10-01 17:00:36.601476',NULL,'2025-10-01 17:00:36.809300',25,25,'0043a26a-36b3-4bd0-a3db-e649a2133771','driver_handles_share_servers','False'),('2025-10-01 17:00:40.674438',NULL,'2025-10-01 17:00:49.542008',26,26,'3ec8827a-3829-4912-bb29-3f95aeb0ed67','driver_handles_share_servers','False'),('2025-10-01 17:00:52.938042',NULL,'2025-10-01 17:00:53.253981',27,27,'62f5f232-d3bd-4410-82b1-166f52f599bf','driver_handles_share_servers','False'),('2025-10-01 17:00:53.023366',NULL,'2025-10-01 17:00:53.253981',28,28,'62f5f232-d3bd-4410-82b1-166f52f599bf','key1','value1'),('2025-10-01 17:00:53.025857',NULL,'2025-10-01 17:00:53.253981',29,29,'62f5f232-d3bd-4410-82b1-166f52f599bf','key2','value2'),('2025-10-01 17:00:54.513471',NULL,'2025-10-01 17:00:58.008659',30,30,'d9990191-b12d-45ed-85f1-c3d13a9deab5','driver_handles_share_servers','False'),('2025-10-01 17:00:54.801374',NULL,'2025-10-01 17:00:57.772351',31,31,'5ae6b62e-1196-496f-8768-0fbaba8ab1f4','driver_handles_share_servers','False'),('2025-10-01 17:00:54.942789',NULL,'2025-10-01 17:00:57.545577',32,32,'bbf3d39a-0569-4a5e-8e9a-7d20429ddcab','driver_handles_share_servers','False'),('2025-10-01 17:00:55.087464',NULL,'2025-10-01 17:00:57.346391',33,33,'e465a999-324b-4be5-858a-e580842970ef','driver_handles_share_servers','False'),('2025-10-01 17:00:55.420423',NULL,'2025-10-01 17:00:57.085489',34,34,'d8e1f9f7-a968-4fa6-8fdb-d9e836031c03','driver_handles_share_servers','False'),('2025-10-01 17:00:55.421607',NULL,'2025-10-01 17:00:57.085489',35,35,'d8e1f9f7-a968-4fa6-8fdb-d9e836031c03','share_backend_name','tempest-fake_name-290569310'),('2025-10-01 17:00:55.775997',NULL,'2025-10-01 17:00:56.921194',36,36,'3f2673dd-ad43-41f5-83cb-c52ae288c999','driver_handles_share_servers','False'),('2025-10-01 17:00:55.776503',NULL,'2025-10-01 17:00:56.921194',37,37,'3f2673dd-ad43-41f5-83cb-c52ae288c999','share_backend_name','tempest-fake_name-1113293532'),('2025-10-01 17:00:55.919234',NULL,'2025-10-01 17:00:56.658594',38,38,'42eab52c-4902-4ad0-84f3-b461d99e34ec','driver_handles_share_servers','False'),('2025-10-01 17:00:55.919691',NULL,'2025-10-01 17:00:56.658594',39,39,'42eab52c-4902-4ad0-84f3-b461d99e34ec','share_backend_name','tempest-fake_name-1795794369'),('2025-10-01 17:00:56.111630',NULL,'2025-10-01 17:00:56.377980',40,40,'c90837bc-80c1-4c31-a48f-059acd364abb','driver_handles_share_servers','False'),('2025-10-01 17:00:56.112145',NULL,'2025-10-01 17:00:56.377980',41,41,'c90837bc-80c1-4c31-a48f-059acd364abb','share_backend_name','tempest-fake_name-1562241894'),('2025-10-01 17:00:59.268096',NULL,'2025-10-01 17:01:09.197684',42,42,'df6253ff-a6f8-4290-a233-f869309ebcaf','driver_handles_share_servers','False'),('2025-10-01 17:00:59.269163',NULL,'2025-10-01 17:01:09.197684',43,43,'df6253ff-a6f8-4290-a233-f869309ebcaf','key','value'),('2025-10-01 17:00:59.433541',NULL,'2025-10-01 17:01:09.028842',44,44,'2bea631f-449b-4272-a57b-a7aad6d1887c','driver_handles_share_servers','False'),('2025-10-01 17:00:59.434323',NULL,'2025-10-01 17:01:09.028842',45,45,'2bea631f-449b-4272-a57b-a7aad6d1887c','key','value'),('2025-10-01 17:00:59.602032',NULL,'2025-10-01 17:01:08.767738',46,46,'ffa859b3-020a-4967-8608-93579f69e3a4','driver_handles_share_servers','False'),('2025-10-01 17:00:59.602634',NULL,'2025-10-01 17:01:08.767738',47,47,'ffa859b3-020a-4967-8608-93579f69e3a4','key','value'),('2025-10-01 17:00:59.991961',NULL,'2025-10-01 17:01:08.643720',48,48,'45e94787-b6ab-4520-aafe-d720a68e83ce','driver_handles_share_servers','False'),('2025-10-01 17:00:59.992661',NULL,'2025-10-01 17:01:08.643720',49,49,'45e94787-b6ab-4520-aafe-d720a68e83ce','key','value'),('2025-10-01 17:01:00.156770',NULL,'2025-10-01 17:01:08.528762',50,50,'c450467a-337a-45f5-86c0-09ca92880d39','driver_handles_share_servers','False'),('2025-10-01 17:01:00.157566',NULL,'2025-10-01 17:01:08.528762',51,51,'c450467a-337a-45f5-86c0-09ca92880d39','key','value'),('2025-10-01 17:01:00.336476',NULL,'2025-10-01 17:01:08.212410',52,52,'594c7d78-b162-4388-9a2b-199852e7626f','driver_handles_share_servers','False'),('2025-10-01 17:01:00.336828',NULL,'2025-10-01 17:01:08.212410',53,53,'594c7d78-b162-4388-9a2b-199852e7626f','key','value'),('2025-10-01 17:01:00.483626',NULL,'2025-10-01 17:01:07.920398',54,54,'4bc4fa2d-c39e-4949-b07f-a4e503a2c2c7','driver_handles_share_servers','False'),('2025-10-01 17:01:00.484471',NULL,'2025-10-01 17:01:07.920398',55,55,'4bc4fa2d-c39e-4949-b07f-a4e503a2c2c7','key','value'),('2025-10-01 17:01:00.712594',NULL,'2025-10-01 17:01:07.699653',56,56,'096a1428-0488-4ced-bfad-5497071f3151','driver_handles_share_servers','False'),('2025-10-01 17:01:00.713139',NULL,'2025-10-01 17:01:07.699653',57,57,'096a1428-0488-4ced-bfad-5497071f3151','key','value'),('2025-10-01 17:01:01.139161',NULL,'2025-10-01 17:01:07.559938',58,58,'d6d36ecc-1946-462d-a79b-ba2acd112483','driver_handles_share_servers','False'),('2025-10-01 17:01:01.139647',NULL,'2025-10-01 17:01:07.559938',59,59,'d6d36ecc-1946-462d-a79b-ba2acd112483','key','value'),('2025-10-01 17:01:01.363779',NULL,'2025-10-01 17:01:07.424994',60,60,'482ba853-f47b-45c0-8620-4ab6d6d68b51','driver_handles_share_servers','False'),('2025-10-01 17:01:01.364403',NULL,'2025-10-01 17:01:07.424994',61,61,'482ba853-f47b-45c0-8620-4ab6d6d68b51','key','value'),('2025-10-01 17:01:01.592024',NULL,'2025-10-01 17:01:07.305216',62,62,'66af5484-9ea6-41b8-95f7-c57332e27588','driver_handles_share_servers','False'),('2025-10-01 17:01:01.593030',NULL,'2025-10-01 17:01:07.305216',63,63,'66af5484-9ea6-41b8-95f7-c57332e27588','key','value'),('2025-10-01 17:01:01.840187',NULL,'2025-10-01 17:01:21.316964',64,64,'0b6fb7a2-3c89-4ce6-afa0-08dffd4c10d5','driver_handles_share_servers','False'),('2025-10-01 17:01:01.840971',NULL,'2025-10-01 17:01:21.316964',65,65,'0b6fb7a2-3c89-4ce6-afa0-08dffd4c10d5','storage_protocol','cephfs'),('2025-10-01 17:01:01.954533',NULL,'2025-10-01 17:01:07.121639',66,66,'d07090cf-11c6-408b-bb14-adcbefae497b','driver_handles_share_servers','False'),('2025-10-01 17:01:01.955020',NULL,'2025-10-01 17:01:07.121639',67,67,'d07090cf-11c6-408b-bb14-adcbefae497b','key','value'),('2025-10-01 17:01:02.383318',NULL,'2025-10-01 17:01:06.899091',68,68,'65cbe5bc-bf5d-4799-adc7-d5641a47bd06','driver_handles_share_servers','False'),('2025-10-01 17:01:02.383677',NULL,'2025-10-01 17:01:06.899091',69,69,'65cbe5bc-bf5d-4799-adc7-d5641a47bd06','key','value'),('2025-10-01 17:01:02.558889',NULL,'2025-10-01 17:01:06.761753',70,70,'518333b3-a797-4ed6-aae2-c1ff315fa396','driver_handles_share_servers','False'),('2025-10-01 17:01:02.559257',NULL,'2025-10-01 17:01:06.761753',71,71,'518333b3-a797-4ed6-aae2-c1ff315fa396','key','value'),('2025-10-01 17:01:02.873661',NULL,'2025-10-01 17:01:06.608241',72,72,'ebc38e18-2201-4825-b82e-c054d998d6db','driver_handles_share_servers','False'),('2025-10-01 17:01:02.874127',NULL,'2025-10-01 17:01:06.608241',73,73,'ebc38e18-2201-4825-b82e-c054d998d6db','key','value'),('2025-10-01 17:01:03.114863',NULL,'2025-10-01 17:01:06.426972',74,74,'05e4b0dd-ac41-460d-a6a0-bed108fbfc98','driver_handles_share_servers','False'),('2025-10-01 17:01:03.115556',NULL,'2025-10-01 17:01:06.426972',75,75,'05e4b0dd-ac41-460d-a6a0-bed108fbfc98','key','value'),('2025-10-01 17:01:03.402782',NULL,'2025-10-01 17:01:06.252260',76,76,'954ef1be-cc90-4bdf-97a4-f7ae7d961328','driver_handles_share_servers','False'),('2025-10-01 17:01:03.403345',NULL,'2025-10-01 17:01:06.252260',77,77,'954ef1be-cc90-4bdf-97a4-f7ae7d961328','key','value'),('2025-10-01 17:01:03.640558',NULL,'2025-10-01 17:01:06.005614',78,78,'ac26a0b3-5b55-4ad5-9300-4b33ccbc9f6e','driver_handles_share_servers','False'),('2025-10-01 17:01:03.641170',NULL,'2025-10-01 17:01:06.005614',79,79,'ac26a0b3-5b55-4ad5-9300-4b33ccbc9f6e','key','value'),('2025-10-01 17:01:03.943532',NULL,'2025-10-01 17:01:05.734672',80,80,'5b86dbf1-b5e0-40df-960e-784ff96ecc19','driver_handles_share_servers','False'),('2025-10-01 17:01:03.943942',NULL,'2025-10-01 17:01:05.734672',81,81,'5b86dbf1-b5e0-40df-960e-784ff96ecc19','key','value'),('2025-10-01 17:01:04.088436',NULL,'2025-10-01 17:01:05.533268',82,82,'5d012fbc-9e95-42c8-8212-608c89661719','driver_handles_share_servers','False'),('2025-10-01 17:01:04.088958',NULL,'2025-10-01 17:01:05.533268',83,83,'5d012fbc-9e95-42c8-8212-608c89661719','key','value'),('2025-10-01 17:01:04.228826',NULL,'2025-10-01 17:01:05.247850',84,84,'9e7edbe6-e094-4dad-b76c-7f49cb8bea7c','driver_handles_share_servers','False'),('2025-10-01 17:01:04.229149',NULL,'2025-10-01 17:01:05.247850',85,85,'9e7edbe6-e094-4dad-b76c-7f49cb8bea7c','key','value'),('2025-10-01 17:01:04.674707',NULL,'2025-10-01 17:01:05.037033',86,86,'5137e6de-1f30-4f89-87dd-a1743a5e399e','driver_handles_share_servers','False'),('2025-10-01 17:01:04.675165',NULL,'2025-10-01 17:01:05.037033',87,87,'5137e6de-1f30-4f89-87dd-a1743a5e399e','key','value'),('2025-10-01 17:01:06.231585',NULL,'2025-10-01 17:01:17.627160',88,88,'10d60298-7f35-432d-9c58-19ab4bc81da4','driver_handles_share_servers','False'),('2025-10-01 17:01:06.231969',NULL,'2025-10-01 17:01:17.627160',89,89,'10d60298-7f35-432d-9c58-19ab4bc81da4','key','value'),('2025-10-01 17:01:07.048857',NULL,'2025-10-01 17:01:07.128502',90,90,'e7b903a1-0a3c-472d-aa4b-397fb5edbbfe','driver_handles_share_servers','False'),('2025-10-01 17:01:07.369355',NULL,'2025-10-01 17:01:17.432807',91,91,'8ad8e70b-54fc-4c25-a912-8fecf428a3af','driver_handles_share_servers','False'),('2025-10-01 17:01:07.369716',NULL,'2025-10-01 17:01:17.432807',92,92,'8ad8e70b-54fc-4c25-a912-8fecf428a3af','key','value'),('2025-10-01 17:01:07.370087',NULL,'2025-10-01 17:01:17.432807',93,93,'8ad8e70b-54fc-4c25-a912-8fecf428a3af','snapshot_support','True'),('2025-10-01 17:01:07.499395',NULL,'2025-10-01 17:01:17.278800',94,94,'fe7694b8-bd4d-423c-b9fc-8b41e35f8112','driver_handles_share_servers','False'),('2025-10-01 17:01:07.500881',NULL,'2025-10-01 17:01:17.278800',95,95,'fe7694b8-bd4d-423c-b9fc-8b41e35f8112','key','value'),('2025-10-01 17:01:07.502291',NULL,'2025-10-01 17:01:17.278800',96,96,'fe7694b8-bd4d-423c-b9fc-8b41e35f8112','snapshot_support','True'),('2025-10-01 17:01:07.632989',NULL,'2025-10-01 17:01:17.130649',97,97,'51e614bc-9a89-4855-b1c9-dd22a603b8e7','driver_handles_share_servers','False'),('2025-10-01 17:01:07.633964',NULL,'2025-10-01 17:01:17.130649',98,98,'51e614bc-9a89-4855-b1c9-dd22a603b8e7','key','value'),('2025-10-01 17:01:07.634651',NULL,'2025-10-01 17:01:17.130649',99,99,'51e614bc-9a89-4855-b1c9-dd22a603b8e7','snapshot_support','True'),('2025-10-01 17:01:07.760503',NULL,'2025-10-01 17:01:16.850871',100,100,'36ca103f-cb79-4765-aa87-b46af83e855c','driver_handles_share_servers','False'),('2025-10-01 17:01:07.761189',NULL,'2025-10-01 17:01:16.850871',101,101,'36ca103f-cb79-4765-aa87-b46af83e855c','key','value'),('2025-10-01 17:01:08.085970',NULL,'2025-10-01 17:01:16.684254',102,102,'191b7fae-da32-47c2-a769-0c24b234e46c','driver_handles_share_servers','False'),('2025-10-01 17:01:08.086499',NULL,'2025-10-01 17:01:16.684254',103,103,'191b7fae-da32-47c2-a769-0c24b234e46c','key','value'),('2025-10-01 17:01:08.332308',NULL,'2025-10-01 17:01:16.493664',104,104,'aca48d91-398b-4f77-adce-0abdc755540b','driver_handles_share_servers','False'),('2025-10-01 17:01:08.332700',NULL,'2025-10-01 17:01:16.493664',105,105,'aca48d91-398b-4f77-adce-0abdc755540b','snapshot_support','True'),('2025-10-01 17:01:08.568925',NULL,'2025-10-01 17:01:16.257798',106,106,'2f81400d-f30d-4f75-a63a-8ed17c83d50b','driver_handles_share_servers','False'),('2025-10-01 17:01:08.569321',NULL,'2025-10-01 17:01:16.257798',107,107,'2f81400d-f30d-4f75-a63a-8ed17c83d50b','snapshot_support','True'),('2025-10-01 17:01:08.675361',NULL,'2025-10-01 17:01:16.076467',108,108,'42044e89-2c69-4ea2-ba75-6782cace0348','driver_handles_share_servers','False'),('2025-10-01 17:01:08.676159',NULL,'2025-10-01 17:01:16.076467',109,109,'42044e89-2c69-4ea2-ba75-6782cace0348','snapshot_support','True'),('2025-10-01 17:01:09.005767',NULL,'2025-10-01 17:01:15.781931',110,110,'284b9164-625d-42bb-beba-0d2687598a4e','driver_handles_share_servers','False'),('2025-10-01 17:01:09.214232',NULL,'2025-10-01 17:01:15.615242',111,111,'f037cf9b-6053-49fc-bc07-2a6aef4091b0','driver_handles_share_servers','False'),('2025-10-01 17:01:09.354937',NULL,'2025-10-01 17:01:15.386183',112,112,'aa52cdf0-323e-4098-b44f-a770ed855b3f','driver_handles_share_servers','False'),('2025-10-01 17:01:09.846097',NULL,'2025-10-01 17:01:15.223441',113,113,'866524cc-4c79-4d69-998b-7a6d89b75a8c','driver_handles_share_servers','False'),('2025-10-01 17:01:10.096823',NULL,'2025-10-01 17:01:15.046177',114,114,'d319c910-ed16-4633-906d-e911c63b8745','driver_handles_share_servers','False'),('2025-10-01 17:01:10.328457',NULL,'2025-10-01 17:01:14.848716',115,115,'013998ed-e25d-4df6-805b-2a89f4c853fc','driver_handles_share_servers','False'),('2025-10-01 17:01:10.328867',NULL,'2025-10-01 17:01:14.848716',116,116,'013998ed-e25d-4df6-805b-2a89f4c853fc','key','value'),('2025-10-01 17:01:10.574187',NULL,'2025-10-01 17:01:14.691709',117,117,'6302c5fa-23b7-48ce-b6f7-af1cc21e4dba','driver_handles_share_servers','False'),('2025-10-01 17:01:10.575075',NULL,'2025-10-01 17:01:14.691709',118,118,'6302c5fa-23b7-48ce-b6f7-af1cc21e4dba','key','value'),('2025-10-01 17:01:10.747471',NULL,'2025-10-01 17:01:14.381543',119,119,'2a533e85-c4f2-43f6-99a3-297926e7cd24','driver_handles_share_servers','False'),('2025-10-01 17:01:10.748029',NULL,'2025-10-01 17:01:14.381543',120,120,'2a533e85-c4f2-43f6-99a3-297926e7cd24','key','value'),('2025-10-01 17:01:10.938143',NULL,'2025-10-01 17:01:14.191841',121,121,'05f2fea9-009a-4149-a99a-53635a8aa6ca','driver_handles_share_servers','False'),('2025-10-01 17:01:10.938446',NULL,'2025-10-01 17:01:14.191841',122,122,'05f2fea9-009a-4149-a99a-53635a8aa6ca','key','value'),('2025-10-01 17:01:11.149819',NULL,'2025-10-01 17:01:14.020284',123,123,'3bece7fd-28d6-4f5b-8070-80254dd06c0a','driver_handles_share_servers','False'),('2025-10-01 17:01:11.150276',NULL,'2025-10-01 17:01:14.020284',124,124,'3bece7fd-28d6-4f5b-8070-80254dd06c0a','key','value'),('2025-10-01 17:01:11.296436',NULL,'2025-10-01 17:01:13.818389',125,125,'87d404b5-fa3f-4d25-b427-d127ee29a66b','driver_handles_share_servers','False'),('2025-10-01 17:01:11.296788',NULL,'2025-10-01 17:01:13.818389',126,126,'87d404b5-fa3f-4d25-b427-d127ee29a66b','key','value'),('2025-10-01 17:01:11.459319',NULL,'2025-10-01 17:01:13.643987',127,127,'53cc47f2-39ad-4fcd-a187-48f561656b63','driver_handles_share_servers','False'),('2025-10-01 17:01:11.459668',NULL,'2025-10-01 17:01:13.643987',128,128,'53cc47f2-39ad-4fcd-a187-48f561656b63','key','value'),('2025-10-01 17:01:11.610080',NULL,'2025-10-01 17:01:13.482218',129,129,'bd155d9e-1a0b-4cd2-b9d5-60da729389e5','driver_handles_share_servers','False'),('2025-10-01 17:01:11.610535',NULL,'2025-10-01 17:01:13.482218',130,130,'bd155d9e-1a0b-4cd2-b9d5-60da729389e5','key','value'),('2025-10-01 17:01:11.798847',NULL,'2025-10-01 17:01:13.219539',131,131,'8873cf62-b065-4fde-ac35-9fee92f8a92c','driver_handles_share_servers','False'),('2025-10-01 17:01:11.799242',NULL,'2025-10-01 17:01:13.219539',132,132,'8873cf62-b065-4fde-ac35-9fee92f8a92c','key','value'),('2025-10-01 17:01:12.004017',NULL,'2025-10-01 17:01:13.042823',133,133,'58c1a408-738f-4ea4-a624-a648e8258010','driver_handles_share_servers','False'),('2025-10-01 17:01:12.005292',NULL,'2025-10-01 17:01:13.042823',134,134,'58c1a408-738f-4ea4-a624-a648e8258010','key','value'),('2025-10-01 17:01:12.166464',NULL,'2025-10-01 17:01:12.901610',135,135,'4284104a-a3c4-4cb8-b81b-d1d0e477aa4d','driver_handles_share_servers','False'),('2025-10-01 17:01:12.167790',NULL,'2025-10-01 17:01:12.901610',136,136,'4284104a-a3c4-4cb8-b81b-d1d0e477aa4d','key','value'),('2025-10-01 17:01:12.393020',NULL,'2025-10-01 17:01:12.736348',137,137,'1450f69f-bfbc-48a0-ab31-a8acb08ad8ad','driver_handles_share_servers','False'),('2025-10-01 17:01:12.393470',NULL,'2025-10-01 17:01:12.736348',138,138,'1450f69f-bfbc-48a0-ab31-a8acb08ad8ad','key','value'),('2025-10-01 17:01:12.869445',NULL,'2025-10-01 17:01:20.435241',139,139,'b4e112a6-2cd3-4161-a1d9-6a2b26c3ae12','driver_handles_share_servers','False'),('2025-10-01 17:01:17.114063',NULL,'2025-10-01 17:01:19.306514',140,140,'f5280e75-7ae9-4ec9-8298-de1f299ac7c5','driver_handles_share_servers','False'),('2025-10-01 17:01:17.114429',NULL,'2025-10-01 17:01:19.306514',141,141,'f5280e75-7ae9-4ec9-8298-de1f299ac7c5','key','value'),('2025-10-01 17:01:17.654468',NULL,'2025-10-01 17:01:19.130614',142,142,'347aecdc-579b-4e3e-807f-66ecac0c7825','driver_handles_share_servers','False'),('2025-10-01 17:01:18.230363',NULL,'2025-10-01 17:01:18.988699',143,143,'87f8216a-f6fd-4671-bde9-4b3c301eaa80','driver_handles_share_servers','False'),('2025-10-01 17:01:18.232729',NULL,'2025-10-01 17:01:18.988699',144,144,'87f8216a-f6fd-4671-bde9-4b3c301eaa80','key','value'),('2025-10-01 17:01:18.420311',NULL,'2025-10-01 17:01:18.866132',145,145,'ae2c31e2-af18-4e1f-ac1c-4ffb2127319d','driver_handles_share_servers','False'),('2025-10-01 17:01:18.420722',NULL,'2025-10-01 17:01:18.866132',146,146,'ae2c31e2-af18-4e1f-ac1c-4ffb2127319d','key','value'),('2025-10-01 17:01:24.985134',NULL,'2025-10-01 17:01:28.006772',147,147,'43ec2586-2aa0-49df-9419-56fe815fc642','driver_handles_share_servers','False'),('2025-10-01 17:01:25.052670',NULL,'2025-10-01 17:02:15.578255',148,148,'f0348654-6331-4c8a-89cf-95b9f1fa588d','driver_handles_share_servers','False'),('2025-10-01 17:01:25.058142',NULL,'2025-10-01 17:02:15.578255',149,149,'f0348654-6331-4c8a-89cf-95b9f1fa588d','storage_protocol','cephfs'),('2025-10-01 17:01:25.058903',NULL,'2025-10-01 17:02:15.578255',150,150,'f0348654-6331-4c8a-89cf-95b9f1fa588d','snapshot_support','True'),('2025-10-01 17:01:25.059677',NULL,'2025-10-01 17:02:15.578255',151,151,'f0348654-6331-4c8a-89cf-95b9f1fa588d','create_share_from_snapshot_support','True'),('2025-10-01 17:01:25.108594',NULL,'2025-10-01 17:01:25.193306',152,152,'43ec2586-2aa0-49df-9419-56fe815fc642','key1','value1'),('2025-10-01 17:01:25.112064',NULL,'2025-10-01 17:01:28.006772',153,153,'43ec2586-2aa0-49df-9419-56fe815fc642','key2','value2'),('2025-10-01 17:01:25.362192',NULL,'2025-10-01 17:01:27.886591',154,154,'1369b732-02a1-4971-afe5-831174b94a07','driver_handles_share_servers','False'),('2025-10-01 17:01:25.513265',NULL,'2025-10-01 17:01:27.886591',155,155,'1369b732-02a1-4971-afe5-831174b94a07','key1','value1'),('2025-10-01 17:01:25.515610',NULL,'2025-10-01 17:01:27.886591',156,156,'1369b732-02a1-4971-afe5-831174b94a07','key2','value2'),('2025-10-01 17:01:25.650034',NULL,'2025-10-01 17:01:25.799492',157,157,'1369b732-02a1-4971-afe5-831174b94a07','snapshot_support','True'),('2025-10-01 17:01:25.947956',NULL,'2025-10-01 17:01:27.754365',158,158,'7550dbc7-159b-4636-b18a-295fdb865447','driver_handles_share_servers','False'),('2025-10-01 17:01:26.044305',NULL,'2025-10-01 17:01:27.754365',159,159,'7550dbc7-159b-4636-b18a-295fdb865447','key1','value1'),('2025-10-01 17:01:26.049138',NULL,'2025-10-01 17:01:27.754365',160,160,'7550dbc7-159b-4636-b18a-295fdb865447','key2','value2'),('2025-10-01 17:01:26.136296',NULL,'2025-10-01 17:01:26.322496',161,161,'7550dbc7-159b-4636-b18a-295fdb865447','snapshot_support','True'),('2025-10-01 17:01:26.559317',NULL,'2025-10-01 17:01:44.745782',162,162,'89fda32e-eb53-4bb7-8ebe-24317a4a69c0','driver_handles_share_servers','False'),('2025-10-01 17:01:26.559734',NULL,'2025-10-01 17:01:44.745782',163,163,'89fda32e-eb53-4bb7-8ebe-24317a4a69c0','snapshot_support','True'),('2025-10-01 17:01:26.570538',NULL,'2025-10-01 17:01:27.590200',164,164,'5a8d3e89-3a47-49eb-a503-9e2935c7df13','driver_handles_share_servers','False'),('2025-10-01 17:01:26.644500',NULL,'2025-10-01 17:01:27.590200',165,165,'5a8d3e89-3a47-49eb-a503-9e2935c7df13','key1','value1'),('2025-10-01 17:01:26.646856','2025-10-01 17:01:26.715022','2025-10-01 17:01:27.590200',166,166,'5a8d3e89-3a47-49eb-a503-9e2935c7df13','key2','value2_updated'),('2025-10-01 17:01:26.941073',NULL,'2025-10-01 17:01:27.315888',167,167,'2e6cdbd9-43f3-471e-9128-e45e6f9d52e2','driver_handles_share_servers','False'),('2025-10-01 17:01:27.042697','2025-10-01 17:01:27.119018','2025-10-01 17:01:27.315888',168,168,'2e6cdbd9-43f3-471e-9128-e45e6f9d52e2','key1','fake_value1_updated'),('2025-10-01 17:01:27.045227',NULL,'2025-10-01 17:01:27.315888',169,169,'2e6cdbd9-43f3-471e-9128-e45e6f9d52e2','key2','value2'),('2025-10-01 17:01:54.440412',NULL,'2025-10-01 17:02:17.837915',170,170,'dd944c2a-e556-4a92-a900-c197e5952e3a','driver_handles_share_servers','False'),('2025-10-01 17:01:58.674715',NULL,'2025-10-01 17:02:54.147143',171,171,'354dd354-8b0a-40a4-9641-b0e3560a975d','driver_handles_share_servers','False'),('2025-10-01 17:02:11.672976',NULL,'2025-10-01 17:02:27.829496',172,172,'cd7fa723-e40d-401a-9a30-e34fb52e7764','driver_handles_share_servers','False'),('2025-10-01 17:02:11.673320',NULL,'2025-10-01 17:02:27.829496',173,173,'cd7fa723-e40d-401a-9a30-e34fb52e7764','snapshot_support','True'),('2025-10-01 17:02:27.035424',NULL,'2025-10-01 17:02:49.729643',174,174,'3f2b10b6-f512-41f8-802d-43b4c478360e','driver_handles_share_servers','False'),('2025-10-01 17:02:27.036542',NULL,'2025-10-01 17:02:49.729643',175,175,'3f2b10b6-f512-41f8-802d-43b4c478360e','vendor_name','foobar'),('2025-10-01 17:02:28.847752',NULL,'2025-10-01 17:02:37.607746',176,176,'07c916e4-5e73-4eaa-9e77-984c3d94747e','driver_handles_share_servers','False'),('2025-10-01 17:02:31.387981',NULL,'2025-10-01 17:02:49.549801',177,177,'bb28b531-7011-4456-8d2d-6fe0cb38ac18','driver_handles_share_servers','False'),('2025-10-01 17:02:31.388369',NULL,'2025-10-01 17:02:49.549801',178,178,'bb28b531-7011-4456-8d2d-6fe0cb38ac18','vendor_name','foobar'),('2025-10-01 17:02:35.412961',NULL,'2025-10-01 17:02:49.418900',179,179,'584a5070-565d-40c4-835e-9ead21030114','driver_handles_share_servers','False'),('2025-10-01 17:02:35.413443',NULL,'2025-10-01 17:02:49.418900',180,180,'584a5070-565d-40c4-835e-9ead21030114','vendor_name','foobar'),('2025-10-01 17:02:39.611645',NULL,'2025-10-01 17:02:49.076764',181,181,'4211893b-b8e2-4a67-bb8a-d9c7ef2f16a2','driver_handles_share_servers','False'),('2025-10-01 17:02:39.612919',NULL,'2025-10-01 17:02:49.076764',182,182,'4211893b-b8e2-4a67-bb8a-d9c7ef2f16a2','vendor_name','foobar'),('2025-10-01 17:02:43.755206',NULL,'2025-10-01 17:02:48.853278',183,183,'4fc47fc1-7587-4c59-80e9-5db74e7ecbe3','driver_handles_share_servers','False'),('2025-10-01 17:02:43.755634',NULL,'2025-10-01 17:02:48.853278',184,184,'4fc47fc1-7587-4c59-80e9-5db74e7ecbe3','vendor_name','foobar'),('2025-10-01 17:02:49.287161',NULL,NULL,0,185,'3454de97-e8db-4b3e-a708-5ac562e85e73','driver_handles_share_servers','False'),('2025-10-01 17:02:49.896590',NULL,'2025-10-01 17:03:25.310550',186,186,'d8069c93-ae97-4830-b977-fb7adaaba2b1','driver_handles_share_servers','False'),('2025-10-01 17:02:49.896998',NULL,'2025-10-01 17:03:25.310550',187,187,'d8069c93-ae97-4830-b977-fb7adaaba2b1','snapshot_support','True'),('2025-10-01 17:02:49.897356',NULL,'2025-10-01 17:03:25.310550',188,188,'d8069c93-ae97-4830-b977-fb7adaaba2b1','create_share_from_snapshot_support','True'),('2025-10-01 17:02:50.111040',NULL,'2025-10-01 17:03:24.712124',189,189,'f75be615-3c48-49cc-844c-502b209bf197','driver_handles_share_servers','False'),('2025-10-01 17:02:50.312640',NULL,'2025-10-01 17:03:24.444632',190,190,'2324d49d-b8b2-4a6a-82f9-af40a075e8cc','driver_handles_share_servers','False'),('2025-10-01 17:03:08.228686',NULL,'2025-10-01 17:04:26.579742',191,191,'3c11362f-fb50-4637-8fe6-18550ac367e4','driver_handles_share_servers','False'),('2025-10-01 17:03:08.724946',NULL,'2025-10-01 17:03:24.316140',192,192,'10518bc6-daa5-426d-8b9b-bea60fd26e94','driver_handles_share_servers','False'),('2025-10-01 17:03:09.544772',NULL,'2025-10-01 17:03:24.165911',193,193,'f5ad5227-c6e8-40fa-bc1a-78dc60435009','driver_handles_share_servers','False'),('2025-10-01 17:03:10.712643',NULL,'2025-10-01 17:03:24.020410',194,194,'1e8b23c3-fec4-481f-bca8-785b91ecd471','driver_handles_share_servers','False'),('2025-10-01 17:03:15.452150',NULL,'2025-10-01 17:03:23.829282',195,195,'adb48059-bd3b-4a73-9615-acd31e4e1de5','driver_handles_share_servers','False'),('2025-10-01 17:03:16.751826',NULL,'2025-10-01 17:03:23.675495',196,196,'69275896-415f-46f0-96b3-9e732a8063e5','driver_handles_share_servers','False'),('2025-10-01 17:03:17.914886',NULL,'2025-10-01 17:03:23.527195',197,197,'6e216c3a-8c2a-4f53-b63e-836538e9b658','driver_handles_share_servers','False'),('2025-10-01 17:03:18.360539',NULL,'2025-10-01 17:03:23.280694',198,198,'ab8dfc02-86b2-47ba-a5c9-2f5c2387b26e','driver_handles_share_servers','False'),('2025-10-01 17:03:23.338286',NULL,'2025-10-01 17:03:38.547653',199,199,'d99548ce-0987-4a62-9022-4080283ca9ec','driver_handles_share_servers','False'),('2025-10-01 17:03:47.268525',NULL,'2025-10-01 17:03:50.361756',200,200,'8aca1a44-ca2f-47d9-a973-0a6941359d72','driver_handles_share_servers','False'),('2025-10-01 17:03:53.232220',NULL,'2025-10-01 17:04:12.159812',201,201,'7c91cae8-1d42-4bfe-95c0-52e8e38ffe43','driver_handles_share_servers','False'),('2025-10-01 17:03:53.233295',NULL,'2025-10-01 17:04:12.159812',202,202,'7c91cae8-1d42-4bfe-95c0-52e8e38ffe43','snapshot_support','True'),('2025-10-01 17:03:58.642740',NULL,'2025-10-01 17:04:01.985963',203,203,'8edbabbb-872e-47ff-9400-f8afa4569417','driver_handles_share_servers','False'),('2025-10-01 17:04:11.505800',NULL,'2025-10-01 17:04:40.096220',204,204,'b7c65449-bea8-4815-b156-f9df3fa11183','driver_handles_share_servers','False'),('2025-10-01 17:04:42.900940',NULL,'2025-10-01 17:05:30.249602',205,205,'37485c41-bf1c-4f76-96dd-017b9efb3945','driver_handles_share_servers','False'),('2025-10-01 17:04:42.901334',NULL,'2025-10-01 17:05:30.249602',206,206,'37485c41-bf1c-4f76-96dd-017b9efb3945','vendor_name','foobar'),('2025-10-01 17:04:47.461532',NULL,'2025-10-01 17:05:29.913289',207,207,'f9da0eae-4f7c-4b85-af50-4858ad082260','driver_handles_share_servers','False'),('2025-10-01 17:04:47.461897',NULL,'2025-10-01 17:05:29.913289',208,208,'f9da0eae-4f7c-4b85-af50-4858ad082260','vendor_name','foobar'),('2025-10-01 17:04:51.902788',NULL,'2025-10-01 17:06:06.636062',209,209,'b09f42fb-ab61-4f61-a72d-bb65a506d3d5','driver_handles_share_servers','False'),('2025-10-01 17:04:52.102915',NULL,'2025-10-01 17:05:29.566998',210,210,'7913e282-46b6-4065-b63e-e5013b78d303','driver_handles_share_servers','False'),('2025-10-01 17:04:52.103358',NULL,'2025-10-01 17:05:29.566998',211,211,'7913e282-46b6-4065-b63e-e5013b78d303','vendor_name','foobar'),('2025-10-01 17:04:53.889290',NULL,'2025-10-01 17:05:31.935622',212,212,'e67af6d6-3813-468e-96d3-f52430ec7993','driver_handles_share_servers','False'),('2025-10-01 17:04:55.814001',NULL,'2025-10-01 17:05:29.236094',213,213,'f6d05e71-de10-42a2-8555-e5899975f59e','driver_handles_share_servers','False'),('2025-10-01 17:04:55.814854',NULL,'2025-10-01 17:05:29.236094',214,214,'f6d05e71-de10-42a2-8555-e5899975f59e','vendor_name','foobar'),('2025-10-01 17:05:00.240429',NULL,'2025-10-01 17:05:28.723182',215,215,'039a05c1-a5d1-442b-b2f7-1c7883683b48','driver_handles_share_servers','False'),('2025-10-01 17:05:00.240884',NULL,'2025-10-01 17:05:28.723182',216,216,'039a05c1-a5d1-442b-b2f7-1c7883683b48','vendor_name','foobar'),('2025-10-01 17:05:04.654616',NULL,'2025-10-01 17:05:28.163239',217,217,'ff31a3ee-a999-42cd-b0e7-6b0804664d3d','driver_handles_share_servers','False'),('2025-10-01 17:05:04.659003',NULL,'2025-10-01 17:05:28.163239',218,218,'ff31a3ee-a999-42cd-b0e7-6b0804664d3d','vendor_name','foobar'),('2025-10-01 17:05:09.189736',NULL,'2025-10-01 17:05:27.882583',219,219,'00ca740c-3b33-4184-8684-9c836e09c2c9','driver_handles_share_servers','False'),('2025-10-01 17:05:09.190192',NULL,'2025-10-01 17:05:27.882583',220,220,'00ca740c-3b33-4184-8684-9c836e09c2c9','vendor_name','foobar'),('2025-10-01 17:05:13.706767',NULL,'2025-10-01 17:05:27.137760',221,221,'bf0700f6-e269-4e6e-8ad2-2c76437dcb49','driver_handles_share_servers','False'),('2025-10-01 17:05:13.707165',NULL,'2025-10-01 17:05:27.137760',222,222,'bf0700f6-e269-4e6e-8ad2-2c76437dcb49','vendor_name','foobar'),('2025-10-01 17:05:17.209329',NULL,'2025-10-01 17:05:26.976400',223,223,'5c4f6639-cfc2-4866-9875-6cc9e6501c89','driver_handles_share_servers','False'),('2025-10-01 17:05:17.209725',NULL,'2025-10-01 17:05:26.976400',224,224,'5c4f6639-cfc2-4866-9875-6cc9e6501c89','vendor_name','foobar'),('2025-10-01 17:05:21.948394',NULL,'2025-10-01 17:05:26.799734',225,225,'0e7badfe-7b64-4ef5-9cae-3e2a73bd3271','driver_handles_share_servers','False'),('2025-10-01 17:05:21.948960',NULL,'2025-10-01 17:05:26.799734',226,226,'0e7badfe-7b64-4ef5-9cae-3e2a73bd3271','vendor_name','foobar'),('2025-10-01 17:05:38.242778',NULL,'2025-10-01 17:06:04.027504',227,227,'80224da1-67c8-4766-8a84-e16e713a12a0','driver_handles_share_servers','False'),('2025-10-01 17:05:41.384572',NULL,'2025-10-01 17:06:39.645491',228,228,'af3d117f-22fe-4775-ba1f-16e7503d27f3','driver_handles_share_servers','False'),('2025-10-01 17:05:41.384944',NULL,'2025-10-01 17:06:39.645491',229,229,'af3d117f-22fe-4775-ba1f-16e7503d27f3','snapshot_support','True'),('2025-10-01 17:05:41.385286',NULL,'2025-10-01 17:06:39.645491',230,230,'af3d117f-22fe-4775-ba1f-16e7503d27f3','create_share_from_snapshot_support','True'),('2025-10-01 17:06:11.600226',NULL,'2025-10-01 17:06:20.058207',231,231,'55334669-db93-4cfa-8367-2b8ce2d4cd8b','driver_handles_share_servers','False'),('2025-10-01 17:06:15.052244',NULL,'2025-10-01 17:06:16.456323',232,232,'5b3c4a61-cc29-4dd2-b5de-b04bd052f6db','driver_handles_share_servers','False'),('2025-10-01 17:06:22.489404',NULL,'2025-10-01 17:06:27.987555',233,233,'9b2b82ba-3cf7-4717-acdc-139c41e09475','driver_handles_share_servers','False'),('2025-10-01 17:06:35.976761',NULL,'2025-10-01 17:06:45.581196',234,234,'1db0c391-0940-40b9-8519-f4e0c69684f3','driver_handles_share_servers','False'),('2025-10-01 17:06:37.716540',NULL,'2025-10-01 17:08:18.486692',235,235,'8478d453-a6b0-4b46-9199-1966caf8d4cf','driver_handles_share_servers','False'),('2025-10-01 17:06:37.793427',NULL,'2025-10-01 17:06:53.044863',236,236,'c5837613-7660-4253-b4d4-3a77d14c481c','driver_handles_share_servers','False'),('2025-10-01 17:06:37.794095',NULL,'2025-10-01 17:06:53.044863',237,237,'c5837613-7660-4253-b4d4-3a77d14c481c','snapshot_support','True'),('2025-10-01 17:06:56.759916',NULL,'2025-10-01 17:07:00.896561',238,238,'b5464abf-03cd-45b2-9fa5-a708ce1cdb13','driver_handles_share_servers','False'),('2025-10-01 17:06:56.986704',NULL,'2025-10-01 17:07:12.833567',239,239,'5efa3b2a-601c-4ea8-9cf6-c5c76a3276c5','driver_handles_share_servers','False'),('2025-10-01 17:06:56.987487',NULL,'2025-10-01 17:07:12.833567',240,240,'5efa3b2a-601c-4ea8-9cf6-c5c76a3276c5','snapshot_support','True'),('2025-10-01 17:07:01.045143',NULL,'2025-10-01 17:08:16.956071',241,241,'2e37e456-1985-407a-9e7d-7cfaa41f9bf5','driver_handles_share_servers','False'),('2025-10-01 17:07:01.045523',NULL,'2025-10-01 17:08:16.956071',242,242,'2e37e456-1985-407a-9e7d-7cfaa41f9bf5','snapshot_support','True'),('2025-10-01 17:07:01.045845',NULL,'2025-10-01 17:08:16.956071',243,243,'2e37e456-1985-407a-9e7d-7cfaa41f9bf5','create_share_from_snapshot_support','True'),('2025-10-01 17:07:10.504039',NULL,'2025-10-01 17:07:11.828685',244,244,'787bbcdc-20c4-4032-aa57-f9db5ea7c198','driver_handles_share_servers','False'),('2025-10-01 17:07:21.570514',NULL,'2025-10-01 17:08:06.439634',245,245,'955aef9f-9d20-4cc2-94d6-c8222f9248a9','driver_handles_share_servers','False'),('2025-10-01 17:07:21.959297',NULL,'2025-10-01 17:07:22.157002',246,246,'9c87b902-43e3-4a71-a865-a8647eb2821a','driver_handles_share_servers','False'),('2025-10-01 17:07:21.959634',NULL,'2025-10-01 17:07:22.157002',247,247,'9c87b902-43e3-4a71-a865-a8647eb2821a','availability_zones','az1,az2,az 3'),('2025-10-01 17:07:22.147012',NULL,'2025-10-01 17:07:24.062723',248,248,'c5f1a757-c5dd-4550-8037-f937f8c1f656','driver_handles_share_servers','False'),('2025-10-01 17:07:22.261207',NULL,'2025-10-01 17:07:22.412791',249,249,'2bd8c9b7-b2ce-4169-ac2c-88a09f217f06','driver_handles_share_servers','False'),('2025-10-01 17:07:22.261910',NULL,'2025-10-01 17:07:22.412791',250,250,'2bd8c9b7-b2ce-4169-ac2c-88a09f217f06','availability_zones','az1,az2,az 3'),('2025-10-01 17:07:22.575866',NULL,'2025-10-01 17:07:22.698629',251,251,'d76fb610-123c-4f4f-91cd-4ce36d9ac93f','driver_handles_share_servers','False'),('2025-10-01 17:07:22.576271',NULL,'2025-10-01 17:07:22.698629',252,252,'d76fb610-123c-4f4f-91cd-4ce36d9ac93f','availability_zones','az1,az2,az 3'),('2025-10-01 17:07:22.652826','2025-10-01 17:07:23.052877','2025-10-01 17:07:24.062723',253,253,'c5f1a757-c5dd-4550-8037-f937f8c1f656','availability_zones','az_that_doesnt_exist'),('2025-10-01 17:07:22.718801',NULL,'2025-10-01 17:07:22.886132',254,254,'a1298658-0089-479d-b720-0d0e13637d14','driver_handles_share_servers','False'),('2025-10-01 17:07:22.842187',NULL,'2025-10-01 17:07:23.198937',255,255,'d3f22a47-70c8-4aec-a6f6-a62eaa8e169c','driver_handles_share_servers','False'),('2025-10-01 17:07:22.842644',NULL,'2025-10-01 17:07:23.198937',256,256,'d3f22a47-70c8-4aec-a6f6-a62eaa8e169c','availability_zones','az1,az2,az 3'),('2025-10-01 17:07:22.926153',NULL,'2025-10-01 17:07:23.075353',257,257,'756043ce-10aa-44b0-b5d8-dee7426e13f1','driver_handles_share_servers','False'),('2025-10-01 17:07:23.331718',NULL,'2025-10-01 17:07:23.740754',258,258,'89b1afe1-c81a-409e-9adb-88a3e663c949','driver_handles_share_servers','False'),('2025-10-01 17:07:23.332078',NULL,'2025-10-01 17:07:23.740754',259,259,'89b1afe1-c81a-409e-9adb-88a3e663c949','availability_zones','az1,az2,az 3'),('2025-10-01 17:07:23.404666',NULL,'2025-10-01 17:07:23.596744',260,260,'6eb04e53-cbfa-4232-b509-6ece9de9691e','driver_handles_share_servers','False'),('2025-10-01 17:07:23.990494',NULL,'2025-10-01 17:07:24.558629',261,261,'614cfdb4-d9aa-42a5-a321-b10c002014eb','driver_handles_share_servers','False'),('2025-10-01 17:07:23.990895',NULL,'2025-10-01 17:07:24.558629',262,262,'614cfdb4-d9aa-42a5-a321-b10c002014eb','availability_zones','az1,az2,az 3'),('2025-10-01 17:07:24.081171',NULL,'2025-10-01 17:07:24.250559',263,263,'53b9663f-2d66-4538-bf0c-76e26ca62929','driver_handles_share_servers','False'),('2025-10-01 17:07:24.832004',NULL,'2025-10-01 17:07:25.311922',264,264,'5af1bb8e-9760-492d-9790-ceff5fe3de3c','driver_handles_share_servers','False'),('2025-10-01 17:07:24.832419',NULL,'2025-10-01 17:07:25.311922',265,265,'5af1bb8e-9760-492d-9790-ceff5fe3de3c','availability_zones','az1,az2,az 3'),('2025-10-01 17:07:25.052042',NULL,'2025-10-01 17:07:25.179597',266,266,'1f7613bf-88fb-4cdc-a637-1d234ee581fd','driver_handles_share_servers','False'),('2025-10-01 17:07:25.436269',NULL,'2025-10-01 17:07:25.860407',267,267,'fb108ba7-192f-4564-995c-ac2e7188a745','driver_handles_share_servers','False'),('2025-10-01 17:07:25.436701',NULL,'2025-10-01 17:07:25.860407',268,268,'fb108ba7-192f-4564-995c-ac2e7188a745','availability_zones','az1,az2,az 3'),('2025-10-01 17:07:25.506783',NULL,'2025-10-01 17:07:25.718737',269,269,'8fe35872-8e48-49a2-84f6-89ea5608965d','driver_handles_share_servers','False'),('2025-10-01 17:07:25.993476',NULL,'2025-10-01 17:07:26.393599',270,270,'33ef9aec-83a3-45e7-9a02-bff493e1f8cb','driver_handles_share_servers','False'),('2025-10-01 17:07:25.993866',NULL,'2025-10-01 17:07:26.393599',271,271,'33ef9aec-83a3-45e7-9a02-bff493e1f8cb','availability_zones','az1,az2,az 3'),('2025-10-01 17:07:26.055891',NULL,'2025-10-01 17:07:26.188565',272,272,'95c7dd6d-4f4e-4667-97eb-e0d6333d7e91','driver_handles_share_servers','False'),('2025-10-01 17:07:26.541294','2025-10-01 17:07:41.123543','2025-10-01 17:08:06.439634',273,273,'955aef9f-9d20-4cc2-94d6-c8222f9248a9','availability_zones','nova'),('2025-10-01 17:07:32.161097',NULL,'2025-10-01 17:08:33.317394',274,274,'97f57594-d2cd-4ad0-b515-663008088086','driver_handles_share_servers','False'),('2025-10-01 17:07:32.161704',NULL,'2025-10-01 17:08:33.317394',275,275,'97f57594-d2cd-4ad0-b515-663008088086','snapshot_support','True'),('2025-10-01 17:08:18.449222',NULL,'2025-10-01 17:08:20.527720',276,276,'a2eada0f-bfd5-4f28-95d0-ea6c0e2684d1','driver_handles_share_servers','False'),('2025-10-01 17:08:18.545394',NULL,'2025-10-01 17:08:20.334792',277,277,'059dea28-8b9d-470b-b992-20c186b6f219','driver_handles_share_servers','False'),('2025-10-01 17:08:26.178061',NULL,'2025-10-01 17:09:50.088187',278,278,'48f33a6c-07f4-40ed-8292-0a40c1a95498','driver_handles_share_servers','False'),('2025-10-01 17:08:26.178472',NULL,'2025-10-01 17:09:50.088187',279,279,'48f33a6c-07f4-40ed-8292-0a40c1a95498','snapshot_support','True'),('2025-10-01 17:08:26.178812',NULL,'2025-10-01 17:09:50.088187',280,280,'48f33a6c-07f4-40ed-8292-0a40c1a95498','create_share_from_snapshot_support','True'),('2025-10-01 17:08:30.202904',NULL,'2025-10-01 17:08:32.672175',281,281,'5842f5d9-9c4b-4669-a876-9ea2429c6327','driver_handles_share_servers','False'),('2025-10-01 17:08:30.283788',NULL,'2025-10-01 17:08:32.522542',282,282,'acebee5d-ddc2-4d24-9bff-dbaab808c49d','driver_handles_share_servers','False'),('2025-10-01 17:08:30.284284',NULL,'2025-10-01 17:08:32.522542',283,283,'acebee5d-ddc2-4d24-9bff-dbaab808c49d','provisioning:max_share_size','5'),('2025-10-01 17:08:30.284694',NULL,'2025-10-01 17:08:32.522542',284,284,'acebee5d-ddc2-4d24-9bff-dbaab808c49d','provisioning:min_share_size','2'),('2025-10-01 17:08:42.948456',NULL,'2025-10-01 17:09:27.292670',285,285,'5207f340-b3fd-4fd8-95e5-1228cababcc3','driver_handles_share_servers','False'),('2025-10-01 17:08:42.953429',NULL,'2025-10-01 17:09:27.292670',286,286,'5207f340-b3fd-4fd8-95e5-1228cababcc3','snapshot_support','True'),('2025-10-01 17:08:42.957538',NULL,'2025-10-01 17:09:27.292670',287,287,'5207f340-b3fd-4fd8-95e5-1228cababcc3','create_share_from_snapshot_support','True'),('2025-10-01 17:09:36.143860',NULL,'2025-10-01 17:09:51.451843',288,288,'b2b70e19-2ae4-4aea-be0a-96f3e01586b6','driver_handles_share_servers','False'),('2025-10-01 17:09:36.146202',NULL,'2025-10-01 17:09:51.451843',289,289,'b2b70e19-2ae4-4aea-be0a-96f3e01586b6','snapshot_support','True'),('2025-10-01 17:09:36.146544',NULL,'2025-10-01 17:09:51.451843',290,290,'b2b70e19-2ae4-4aea-be0a-96f3e01586b6','create_share_from_snapshot_support','True'),('2025-10-01 17:09:58.855699',NULL,'2025-10-01 17:10:14.178621',291,291,'4f903460-2d3d-42ea-bed9-eacdc72380eb','driver_handles_share_servers','False'),('2025-10-01 17:09:58.856207',NULL,'2025-10-01 17:10:14.178621',292,292,'4f903460-2d3d-42ea-bed9-eacdc72380eb','snapshot_support','True');
/*!40000 ALTER TABLE `share_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_type_projects`
--

DROP TABLE IF EXISTS `share_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `stp_project_id_uc` (`share_type_id`,`project_id`,`deleted`),
  CONSTRAINT `stp_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_type_projects`
--

LOCK TABLES `share_type_projects` WRITE;
/*!40000 ALTER TABLE `share_type_projects` DISABLE KEYS */;
INSERT INTO `share_type_projects` (`id`, `created_at`, `updated_at`, `deleted_at`, `share_type_id`, `project_id`, `deleted`) VALUES (1,'2025-10-01 17:01:06.449226',NULL,'2025-10-01 17:01:06.718196','10d60298-7f35-432d-9c58-19ab4bc81da4','c4ae009f89aa49ccadaaeed54f17efe5',1);
/*!40000 ALTER TABLE `share_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_types`
--

DROP TABLE IF EXISTS `share_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_types` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `st_name_uc` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_types`
--

LOCK TABLES `share_types` WRITE;
/*!40000 ALTER TABLE `share_types` DISABLE KEYS */;
INSERT INTO `share_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `is_public`, `description`) VALUES ('2025-10-01 17:00:36.600824',NULL,'2025-10-01 17:00:36.811293','0043a26a-36b3-4bd0-a3db-e649a2133771','0043a26a-36b3-4bd0-a3db-e649a2133771','tempest-tempest-manila-2100349481',0,NULL),('2025-10-01 17:05:09.188939',NULL,'2025-10-01 17:05:27.886795','00ca740c-3b33-4184-8684-9c836e09c2c9','00ca740c-3b33-4184-8684-9c836e09c2c9','tempest-share-type-1052889161',1,NULL),('2025-10-01 17:01:10.327804','2025-10-01 17:01:10.499801','2025-10-01 17:01:14.851023','013998ed-e25d-4df6-805b-2a89f4c853fc','013998ed-e25d-4df6-805b-2a89f4c853fc','tempest-type_updated-1274270757',1,'description_updated'),('2025-10-01 17:05:00.239561',NULL,'2025-10-01 17:05:28.725256','039a05c1-a5d1-442b-b2f7-1c7883683b48','039a05c1-a5d1-442b-b2f7-1c7883683b48','tempest-share-type-1623183723',1,NULL),('2025-10-01 17:08:18.544596',NULL,'2025-10-01 17:08:20.337952','059dea28-8b9d-470b-b992-20c186b6f219','059dea28-8b9d-470b-b992-20c186b6f219','tempest-typeshare-type-857428128',1,NULL),('2025-10-01 17:01:03.113695',NULL,'2025-10-01 17:01:06.429802','05e4b0dd-ac41-460d-a6a0-bed108fbfc98','05e4b0dd-ac41-460d-a6a0-bed108fbfc98','tempest-typeshare-type-481838763',1,NULL),('2025-10-01 17:01:10.937578','2025-10-01 17:01:10.998201','2025-10-01 17:01:14.195888','05f2fea9-009a-4149-a99a-53635a8aa6ca','05f2fea9-009a-4149-a99a-53635a8aa6ca','tempest-tempest-manila-424393593',1,'Description for share type'),('2025-10-01 17:02:28.847124',NULL,'2025-10-01 17:02:37.611587','07c916e4-5e73-4eaa-9e77-984c3d94747e','07c916e4-5e73-4eaa-9e77-984c3d94747e','tempest-typeshare-type-1129560296',1,NULL),('2025-10-01 17:01:00.711732',NULL,'2025-10-01 17:01:07.704377','096a1428-0488-4ced-bfad-5497071f3151','096a1428-0488-4ced-bfad-5497071f3151','tempest-typeshare-type-919662032',1,NULL),('2025-10-01 17:01:01.838829',NULL,'2025-10-01 17:01:21.319655','0b6fb7a2-3c89-4ce6-afa0-08dffd4c10d5','0b6fb7a2-3c89-4ce6-afa0-08dffd4c10d5','tempest-share-type-994284979',1,NULL),('2025-10-01 17:00:35.404337',NULL,'2025-10-01 17:00:36.955748','0ba61c30-e98e-4d9b-a0fd-baa1003f2894','0ba61c30-e98e-4d9b-a0fd-baa1003f2894','tempest-typeshare-type-1080546804',1,NULL),('2025-10-01 17:05:21.947357',NULL,'2025-10-01 17:05:26.806937','0e7badfe-7b64-4ef5-9cae-3e2a73bd3271','0e7badfe-7b64-4ef5-9cae-3e2a73bd3271','tempest-share-type-440054365',1,NULL),('2025-10-01 17:03:08.724425',NULL,'2025-10-01 17:03:24.318446','10518bc6-daa5-426d-8b9b-bea60fd26e94','10518bc6-daa5-426d-8b9b-bea60fd26e94','tempest-typeshare-type-1732681244',1,NULL),('2025-10-01 17:01:06.228660',NULL,'2025-10-01 17:01:17.630533','10d60298-7f35-432d-9c58-19ab4bc81da4','10d60298-7f35-432d-9c58-19ab4bc81da4','tempest-tempest-manila-669964207',0,NULL),('2025-10-01 17:00:25.955973',NULL,'2025-10-01 17:00:32.840244','10fc409b-8dba-4277-9100-af73717fb989','10fc409b-8dba-4277-9100-af73717fb989','tempest-typeshare-type-942424841',1,NULL),('2025-10-01 17:01:25.361336',NULL,'2025-10-01 17:01:27.888788','1369b732-02a1-4971-afe5-831174b94a07','1369b732-02a1-4971-afe5-831174b94a07','tempest-share-type-774437515',1,NULL),('2025-10-01 17:01:12.392367','2025-10-01 17:01:12.612775','2025-10-01 17:01:12.741187','1450f69f-bfbc-48a0-ab31-a8acb08ad8ad','1450f69f-bfbc-48a0-ab31-a8acb08ad8ad','tempest-tempest-manila-1177464905',1,NULL),('2025-10-01 17:00:28.898799',NULL,'2025-10-01 17:00:32.471341','1708c008-1127-4fb6-a3d8-a9a2dc01c70e','1708c008-1127-4fb6-a3d8-a9a2dc01c70e','tempest-typeshare-type-1682722574',1,NULL),('2025-10-01 17:01:08.084711',NULL,'2025-10-01 17:01:16.686940','191b7fae-da32-47c2-a769-0c24b234e46c','191b7fae-da32-47c2-a769-0c24b234e46c','tempest-tempest-manila-936235730',1,'Description for share type'),('2025-10-01 17:00:24.075596',NULL,'2025-10-01 17:00:33.761794','1c9a4a43-4754-4260-8467-f6a0fb84b228','1c9a4a43-4754-4260-8467-f6a0fb84b228','tempest-typeshare-type-45163720',1,NULL),('2025-10-01 17:06:35.976114',NULL,'2025-10-01 17:06:45.589104','1db0c391-0940-40b9-8519-f4e0c69684f3','1db0c391-0940-40b9-8519-f4e0c69684f3','tempest-typeshare-type-327994007',1,NULL),('2025-10-01 17:03:10.711815',NULL,'2025-10-01 17:03:24.024332','1e8b23c3-fec4-481f-bca8-785b91ecd471','1e8b23c3-fec4-481f-bca8-785b91ecd471','tempest-typeshare-type-1361712938',1,NULL),('2025-10-01 17:07:25.051425',NULL,'2025-10-01 17:07:25.181609','1f7613bf-88fb-4cdc-a637-1d234ee581fd','1f7613bf-88fb-4cdc-a637-1d234ee581fd','tempest-support_any_az_share_type-1835933336',1,NULL),('2025-10-01 17:02:50.311831',NULL,'2025-10-01 17:03:24.447150','2324d49d-b8b2-4a6a-82f9-af40a075e8cc','2324d49d-b8b2-4a6a-82f9-af40a075e8cc','tempest-typeshare-type-784140855',1,NULL),('2025-10-01 17:01:09.005160',NULL,'2025-10-01 17:01:15.785279','284b9164-625d-42bb-beba-0d2687598a4e','284b9164-625d-42bb-beba-0d2687598a4e','tempest-tempest-manila-318577854',1,NULL),('2025-10-01 17:01:10.744024','2025-10-01 17:01:10.809574','2025-10-01 17:01:14.386345','2a533e85-c4f2-43f6-99a3-297926e7cd24','2a533e85-c4f2-43f6-99a3-297926e7cd24','tempest-tempest-manila-43352684',1,'description_updated'),('2025-10-01 17:00:24.217502',NULL,'2025-10-01 17:00:33.572493','2b311965-978b-4e21-8e6d-dc07a8b8fa29','2b311965-978b-4e21-8e6d-dc07a8b8fa29','tempest-typeshare-type-2058755035',1,NULL),('2025-10-01 17:07:22.260392',NULL,'2025-10-01 17:07:22.414933','2bd8c9b7-b2ce-4169-ac2c-88a09f217f06','2bd8c9b7-b2ce-4169-ac2c-88a09f217f06','tempest-az_share_type-1229597813',1,NULL),('2025-10-01 17:00:59.432692',NULL,'2025-10-01 17:01:09.032747','2bea631f-449b-4272-a57b-a7aad6d1887c','2bea631f-449b-4272-a57b-a7aad6d1887c','tempest-typeshare-type-615210478',1,NULL),('2025-10-01 17:07:01.044414',NULL,'2025-10-01 17:08:16.958233','2e37e456-1985-407a-9e7d-7cfaa41f9bf5','2e37e456-1985-407a-9e7d-7cfaa41f9bf5','tempest-typeshare-type-23421714',1,NULL),('2025-10-01 17:01:26.940479',NULL,'2025-10-01 17:01:27.318625','2e6cdbd9-43f3-471e-9128-e45e6f9d52e2','2e6cdbd9-43f3-471e-9128-e45e6f9d52e2','tempest-share-type-1322611648',1,NULL),('2025-10-01 17:01:08.568028',NULL,'2025-10-01 17:01:16.262765','2f81400d-f30d-4f75-a63a-8ed17c83d50b','2f81400d-f30d-4f75-a63a-8ed17c83d50b','tempest-tempest-manila-1458866315',1,NULL),('2025-10-01 17:07:25.992639',NULL,'2025-10-01 17:07:26.397671','33ef9aec-83a3-45e7-9a02-bff493e1f8cb','33ef9aec-83a3-45e7-9a02-bff493e1f8cb','tempest-support_some_azs_share_type-1506676122',1,NULL),('2025-10-01 17:02:49.286382',NULL,NULL,'False','3454de97-e8db-4b3e-a708-5ac562e85e73','tempest-typeshare-type-1174656527',1,NULL),('2025-10-01 17:01:17.653753',NULL,'2025-10-01 17:01:19.133820','347aecdc-579b-4e3e-807f-66ecac0c7825','347aecdc-579b-4e3e-807f-66ecac0c7825','tempest-share-type-1135227375',0,NULL),('2025-10-01 17:01:58.673902',NULL,'2025-10-01 17:02:54.151202','354dd354-8b0a-40a4-9641-b0e3560a975d','354dd354-8b0a-40a4-9641-b0e3560a975d','tempest-typeshare-type-1877155596',1,NULL),('2025-10-01 17:01:07.759872',NULL,'2025-10-01 17:01:16.853591','36ca103f-cb79-4765-aa87-b46af83e855c','36ca103f-cb79-4765-aa87-b46af83e855c','tempest-tempest-manila-1190481954',1,NULL),('2025-10-01 17:04:42.900326',NULL,'2025-10-01 17:05:30.251460','37485c41-bf1c-4f76-96dd-017b9efb3945','37485c41-bf1c-4f76-96dd-017b9efb3945','tempest-share-type-199583968',1,NULL),('2025-10-01 17:01:11.149218','2025-10-01 17:01:11.219337','2025-10-01 17:01:14.023275','3bece7fd-28d6-4f5b-8070-80254dd06c0a','3bece7fd-28d6-4f5b-8070-80254dd06c0a','tempest-tempest-manila-948813182',0,'Description for share type'),('2025-10-01 17:03:08.227913',NULL,'2025-10-01 17:04:26.582804','3c11362f-fb50-4637-8fe6-18550ac367e4','3c11362f-fb50-4637-8fe6-18550ac367e4','tempest-typeshare-type-1930082183',1,NULL),('2025-10-01 17:00:40.673652',NULL,'2025-10-01 17:00:49.546261','3ec8827a-3829-4912-bb29-3f95aeb0ed67','3ec8827a-3829-4912-bb29-3f95aeb0ed67','tempest-typeshare-type-659582236',1,NULL),('2025-10-01 17:00:55.775171',NULL,'2025-10-01 17:00:56.925442','3f2673dd-ad43-41f5-83cb-c52ae288c999','3f2673dd-ad43-41f5-83cb-c52ae288c999','tempest-unique_st_name-1889291277',1,NULL),('2025-10-01 17:02:27.033180',NULL,'2025-10-01 17:02:49.734584','3f2b10b6-f512-41f8-802d-43b4c478360e','3f2b10b6-f512-41f8-802d-43b4c478360e','tempest-share-type-994861455',1,NULL),('2025-10-01 17:01:08.674628',NULL,'2025-10-01 17:01:16.079325','42044e89-2c69-4ea2-ba75-6782cace0348','42044e89-2c69-4ea2-ba75-6782cace0348','tempest-tempest-manila-53792924',1,NULL),('2025-10-01 17:02:39.610806',NULL,'2025-10-01 17:02:49.079153','4211893b-b8e2-4a67-bb8a-d9c7ef2f16a2','4211893b-b8e2-4a67-bb8a-d9c7ef2f16a2','tempest-share-type-139400139',1,NULL),('2025-10-01 17:01:12.165820','2025-10-01 17:01:12.258022','2025-10-01 17:01:12.903735','4284104a-a3c4-4cb8-b81b-d1d0e477aa4d','4284104a-a3c4-4cb8-b81b-d1d0e477aa4d','tempest-tempest-manila-10201065',1,NULL),('2025-10-01 17:00:55.918166',NULL,'2025-10-01 17:00:56.660820','42eab52c-4902-4ad0-84f3-b461d99e34ec','42eab52c-4902-4ad0-84f3-b461d99e34ec','tempest-unique_st_name-1222635929',1,NULL),('2025-10-01 17:01:24.983679',NULL,'2025-10-01 17:01:28.008757','43ec2586-2aa0-49df-9419-56fe815fc642','43ec2586-2aa0-49df-9419-56fe815fc642','tempest-share-type-1234424545',1,NULL),('2025-10-01 17:00:59.990101',NULL,'2025-10-01 17:01:08.645695','45e94787-b6ab-4520-aafe-d720a68e83ce','45e94787-b6ab-4520-aafe-d720a68e83ce','tempest-typeshare-type-755673696',1,NULL),('2025-10-01 17:01:01.362810',NULL,'2025-10-01 17:01:07.427092','482ba853-f47b-45c0-8620-4ab6d6d68b51','482ba853-f47b-45c0-8620-4ab6d6d68b51','tempest-typeshare-type-2013639159',1,NULL),('2025-10-01 17:08:26.177343',NULL,'2025-10-01 17:09:50.090271','48f33a6c-07f4-40ed-8292-0a40c1a95498','48f33a6c-07f4-40ed-8292-0a40c1a95498','tempest-typeshare-type-162315305',1,NULL),('2025-10-01 17:00:30.547684',NULL,'2025-10-01 17:00:31.574906','49630013-721a-4007-9b5c-2072c4d37883','49630013-721a-4007-9b5c-2072c4d37883','tempest-typeshare-type-2097014484',1,NULL),('2025-10-01 17:01:00.482838',NULL,'2025-10-01 17:01:07.922820','4bc4fa2d-c39e-4949-b07f-a4e503a2c2c7','4bc4fa2d-c39e-4949-b07f-a4e503a2c2c7','tempest-typeshare-type-332725167',1,NULL),('2025-10-01 17:09:58.854639',NULL,'2025-10-01 17:10:14.181003','4f903460-2d3d-42ea-bed9-eacdc72380eb','4f903460-2d3d-42ea-bed9-eacdc72380eb','tempest-typeshare-type-157905325',1,NULL),('2025-10-01 17:02:43.754425',NULL,'2025-10-01 17:02:48.855875','4fc47fc1-7587-4c59-80e9-5db74e7ecbe3','4fc47fc1-7587-4c59-80e9-5db74e7ecbe3','tempest-share-type-223207514',1,NULL),('2025-10-01 17:01:04.674085',NULL,'2025-10-01 17:01:05.041668','5137e6de-1f30-4f89-87dd-a1743a5e399e','5137e6de-1f30-4f89-87dd-a1743a5e399e','tempest-typeshare-type-188205476',1,NULL),('2025-10-01 17:01:02.558291',NULL,'2025-10-01 17:01:06.764541','518333b3-a797-4ed6-aae2-c1ff315fa396','518333b3-a797-4ed6-aae2-c1ff315fa396','tempest-typeshare-type-694157436',1,NULL),('2025-10-01 17:01:07.631721',NULL,'2025-10-01 17:01:17.133282','51e614bc-9a89-4855-b1c9-dd22a603b8e7','51e614bc-9a89-4855-b1c9-dd22a603b8e7','tempest-tempest-manila-1551810320',1,NULL),('2025-10-01 17:08:42.946535',NULL,'2025-10-01 17:09:27.295853','5207f340-b3fd-4fd8-95e5-1228cababcc3','5207f340-b3fd-4fd8-95e5-1228cababcc3','tempest-typeshare-type-249008442',1,NULL),('2025-10-01 17:07:24.079901',NULL,'2025-10-01 17:07:24.252570','53b9663f-2d66-4538-bf0c-76e26ca62929','53b9663f-2d66-4538-bf0c-76e26ca62929','tempest-support_any_az_share_type-1157850903',1,NULL),('2025-10-01 17:01:11.458444','2025-10-01 17:01:11.529511','2025-10-01 17:01:13.650858','53cc47f2-39ad-4fcd-a187-48f561656b63','53cc47f2-39ad-4fcd-a187-48f561656b63','tempest-type_updated-668703458',1,'Description for share type'),('2025-10-01 17:06:11.598947',NULL,'2025-10-01 17:06:20.063465','55334669-db93-4cfa-8367-2b8ce2d4cd8b','55334669-db93-4cfa-8367-2b8ce2d4cd8b','tempest-typeshare-type-1385071770',1,NULL),('2025-10-01 17:08:30.202285',NULL,'2025-10-01 17:08:32.674370','5842f5d9-9c4b-4669-a876-9ea2429c6327','5842f5d9-9c4b-4669-a876-9ea2429c6327','tempest-typeshare-type-1182922947',1,NULL),('2025-10-01 17:02:35.411913',NULL,'2025-10-01 17:02:49.420847','584a5070-565d-40c4-835e-9ead21030114','584a5070-565d-40c4-835e-9ead21030114','tempest-share-type-233552486',1,NULL),('2025-10-01 17:01:12.003360','2025-10-01 17:01:12.083848','2025-10-01 17:01:13.047540','58c1a408-738f-4ea4-a624-a648e8258010','58c1a408-738f-4ea4-a624-a648e8258010','tempest-tempest-manila-561815427',0,'Description for share type'),('2025-10-01 17:01:00.335853',NULL,'2025-10-01 17:01:08.214656','594c7d78-b162-4388-9a2b-199852e7626f','594c7d78-b162-4388-9a2b-199852e7626f','tempest-typeshare-type-629577137',1,NULL),('2025-10-01 17:01:26.569688',NULL,'2025-10-01 17:01:27.592423','5a8d3e89-3a47-49eb-a503-9e2935c7df13','5a8d3e89-3a47-49eb-a503-9e2935c7df13','tempest-share-type-384494543',1,NULL),('2025-10-01 17:00:54.798462',NULL,'2025-10-01 17:00:57.774474','5ae6b62e-1196-496f-8768-0fbaba8ab1f4','5ae6b62e-1196-496f-8768-0fbaba8ab1f4','tempest-typeshare-type-913007854',1,NULL),('2025-10-01 17:07:24.831308',NULL,'2025-10-01 17:07:25.315893','5af1bb8e-9760-492d-9790-ceff5fe3de3c','5af1bb8e-9760-492d-9790-ceff5fe3de3c','tempest-support_some_azs_share_type-1460912919',1,NULL),('2025-10-01 17:06:15.051555',NULL,'2025-10-01 17:06:16.459191','5b3c4a61-cc29-4dd2-b5de-b04bd052f6db','5b3c4a61-cc29-4dd2-b5de-b04bd052f6db','tempest-typeshare-type-1507484163',1,NULL),('2025-10-01 17:01:03.942716',NULL,'2025-10-01 17:01:05.737406','5b86dbf1-b5e0-40df-960e-784ff96ecc19','5b86dbf1-b5e0-40df-960e-784ff96ecc19','tempest-typeshare-type-553539326',1,NULL),('2025-10-01 17:05:17.208507',NULL,'2025-10-01 17:05:26.978845','5c4f6639-cfc2-4866-9875-6cc9e6501c89','5c4f6639-cfc2-4866-9875-6cc9e6501c89','tempest-share-type-1470369508',1,NULL),('2025-10-01 17:01:04.087433',NULL,'2025-10-01 17:01:05.536136','5d012fbc-9e95-42c8-8212-608c89661719','5d012fbc-9e95-42c8-8212-608c89661719','tempest-typeshare-type-519281132',1,NULL),('2025-10-01 17:06:56.982303',NULL,'2025-10-01 17:07:12.840118','5efa3b2a-601c-4ea8-9cf6-c5c76a3276c5','5efa3b2a-601c-4ea8-9cf6-c5c76a3276c5','tempest-typeshare-type-592830699',1,NULL),('2025-10-01 17:07:23.989796',NULL,'2025-10-01 17:07:24.560746','614cfdb4-d9aa-42a5-a321-b10c002014eb','614cfdb4-d9aa-42a5-a321-b10c002014eb','tempest-support_some_azs_share_type-1596018651',1,NULL),('2025-10-01 17:00:52.936979',NULL,'2025-10-01 17:00:53.256097','62f5f232-d3bd-4410-82b1-166f52f599bf','62f5f232-d3bd-4410-82b1-166f52f599bf','tempest-share-type-1341580820',1,NULL),('2025-10-01 17:01:10.572494','2025-10-01 17:01:10.654972','2025-10-01 17:01:14.695768','6302c5fa-23b7-48ce-b6f7-af1cc21e4dba','6302c5fa-23b7-48ce-b6f7-af1cc21e4dba','tempest-type_updated-621127300',1,'Description for share type'),('2025-10-01 17:01:02.382669',NULL,'2025-10-01 17:01:06.902788','65cbe5bc-bf5d-4799-adc7-d5641a47bd06','65cbe5bc-bf5d-4799-adc7-d5641a47bd06','tempest-typeshare-type-1245345227',1,NULL),('2025-10-01 17:01:01.590897',NULL,'2025-10-01 17:01:07.307638','66af5484-9ea6-41b8-95f7-c57332e27588','66af5484-9ea6-41b8-95f7-c57332e27588','tempest-typeshare-type-2123239779',1,NULL),('2025-10-01 17:03:16.751229',NULL,'2025-10-01 17:03:23.677539','69275896-415f-46f0-96b3-9e732a8063e5','69275896-415f-46f0-96b3-9e732a8063e5','tempest-typeshare-type-282485820',0,NULL),('2025-10-01 17:03:17.912163',NULL,'2025-10-01 17:03:23.530001','6e216c3a-8c2a-4f53-b63e-836538e9b658','6e216c3a-8c2a-4f53-b63e-836538e9b658','tempest-typeshare-type-1896578354',1,NULL),('2025-10-01 17:07:23.403895',NULL,'2025-10-01 17:07:23.599013','6eb04e53-cbfa-4232-b509-6ece9de9691e','6eb04e53-cbfa-4232-b509-6ece9de9691e','tempest-support_any_az_share_type-952875036',1,NULL),('2025-10-01 17:00:30.858516',NULL,'2025-10-01 17:00:31.355489','74fb446d-3c2c-4141-83e6-b5517ccb46cf','74fb446d-3c2c-4141-83e6-b5517ccb46cf','tempest-typeshare-type-184433482',1,NULL),('2025-10-01 17:01:25.947187',NULL,'2025-10-01 17:01:27.757184','7550dbc7-159b-4636-b18a-295fdb865447','7550dbc7-159b-4636-b18a-295fdb865447','tempest-share-type-1245605563',1,NULL),('2025-10-01 17:07:22.924926',NULL,'2025-10-01 17:07:23.077922','756043ce-10aa-44b0-b5d8-dee7426e13f1','756043ce-10aa-44b0-b5d8-dee7426e13f1','tempest-support_any_az_share_type-1881864177',1,NULL),('2025-10-01 17:00:36.129963',NULL,'2025-10-01 17:00:36.415468','771760e5-2a41-47e9-9f05-5efee16fed37','771760e5-2a41-47e9-9f05-5efee16fed37','tempest-tempest-manila-1140667764',1,NULL),('2025-10-01 17:07:10.503402',NULL,'2025-10-01 17:07:11.830909','787bbcdc-20c4-4032-aa57-f9db5ea7c198','787bbcdc-20c4-4032-aa57-f9db5ea7c198','tempest-typeshare-type-706546971',1,NULL),('2025-10-01 17:04:52.102219',NULL,'2025-10-01 17:05:29.569364','7913e282-46b6-4065-b63e-e5013b78d303','7913e282-46b6-4065-b63e-e5013b78d303','tempest-share-type-260238399',1,NULL),('2025-10-01 17:03:53.231503',NULL,'2025-10-01 17:04:12.163111','7c91cae8-1d42-4bfe-95c0-52e8e38ffe43','7c91cae8-1d42-4bfe-95c0-52e8e38ffe43','tempest-typeshare-type-1045351645',1,NULL),('2025-10-01 17:05:38.240116',NULL,'2025-10-01 17:06:04.030081','80224da1-67c8-4766-8a84-e16e713a12a0','80224da1-67c8-4766-8a84-e16e713a12a0','tempest-typeshare-type-117734433',1,NULL),('2025-10-01 17:00:25.730414',NULL,'2025-10-01 17:00:33.424270','831f09b5-c2ff-4676-b095-49f40712f6c2','831f09b5-c2ff-4676-b095-49f40712f6c2','tempest-typeshare-type-1927591949',1,NULL),('2025-10-01 17:06:37.715430',NULL,'2025-10-01 17:08:18.488984','8478d453-a6b0-4b46-9199-1966caf8d4cf','8478d453-a6b0-4b46-9199-1966caf8d4cf','tempest-typeshare-type-1822517000',1,NULL),('2025-10-01 17:01:09.844897',NULL,'2025-10-01 17:01:15.225940','866524cc-4c79-4d69-998b-7a6d89b75a8c','866524cc-4c79-4d69-998b-7a6d89b75a8c','tempest-tempest-manila-1323653220',1,NULL),('2025-10-01 17:01:11.295808','2025-10-01 17:01:11.377144','2025-10-01 17:01:13.820557','87d404b5-fa3f-4d25-b427-d127ee29a66b','87d404b5-fa3f-4d25-b427-d127ee29a66b','tempest-type_updated-1893272618',1,'description_updated'),('2025-10-01 17:01:18.228981',NULL,'2025-10-01 17:01:18.990729','87f8216a-f6fd-4671-bde9-4b3c301eaa80','87f8216a-f6fd-4671-bde9-4b3c301eaa80','tempest-typeshare-type-658898814',1,NULL),('2025-10-01 17:00:13.274809',NULL,'2025-10-01 17:01:54.447767','8844ab0c-8acf-432e-bb69-abd01348cc0a','8844ab0c-8acf-432e-bb69-abd01348cc0a','tempest-typeshare-type-6530328',1,NULL),('2025-10-01 17:01:11.797708','2025-10-01 17:01:11.854595','2025-10-01 17:01:13.222037','8873cf62-b065-4fde-ac35-9fee92f8a92c','8873cf62-b065-4fde-ac35-9fee92f8a92c','tempest-tempest-manila-46255431',1,'Description for share type'),('2025-10-01 17:07:23.331012',NULL,'2025-10-01 17:07:23.743217','89b1afe1-c81a-409e-9adb-88a3e663c949','89b1afe1-c81a-409e-9adb-88a3e663c949','tempest-support_some_azs_share_type-1257110591',1,NULL),('2025-10-01 17:01:26.558088',NULL,'2025-10-01 17:01:44.748140','89fda32e-eb53-4bb7-8ebe-24317a4a69c0','89fda32e-eb53-4bb7-8ebe-24317a4a69c0','tempest-typeshare-type-1630054171',1,NULL),('2025-10-01 17:03:47.267922',NULL,'2025-10-01 17:03:50.365102','8aca1a44-ca2f-47d9-a973-0a6941359d72','8aca1a44-ca2f-47d9-a973-0a6941359d72','tempest-typeshare-type-1657610783',1,NULL),('2025-10-01 17:01:07.368635',NULL,'2025-10-01 17:01:17.437328','8ad8e70b-54fc-4c25-a912-8fecf428a3af','8ad8e70b-54fc-4c25-a912-8fecf428a3af','tempest-tempest-manila-150880747',1,NULL),('2025-10-01 17:03:58.641933',NULL,'2025-10-01 17:04:01.988163','8edbabbb-872e-47ff-9400-f8afa4569417','8edbabbb-872e-47ff-9400-f8afa4569417','tempest-typeshare-type-1498345815',1,NULL),('2025-10-01 17:07:25.505936',NULL,'2025-10-01 17:07:25.723992','8fe35872-8e48-49a2-84f6-89ea5608965d','8fe35872-8e48-49a2-84f6-89ea5608965d','tempest-support_any_az_share_type-173129963',1,NULL),('2025-10-01 17:01:03.401829',NULL,'2025-10-01 17:01:06.257487','954ef1be-cc90-4bdf-97a4-f7ae7d961328','954ef1be-cc90-4bdf-97a4-f7ae7d961328','tempest-typeshare-type-1299539090',1,NULL),('2025-10-01 17:07:21.569305',NULL,'2025-10-01 17:08:06.442470','955aef9f-9d20-4cc2-94d6-c8222f9248a9','955aef9f-9d20-4cc2-94d6-c8222f9248a9','tempest-typeshare-type-1007797562',1,NULL),('2025-10-01 17:07:26.055212',NULL,'2025-10-01 17:07:26.190763','95c7dd6d-4f4e-4667-97eb-e0d6333d7e91','95c7dd6d-4f4e-4667-97eb-e0d6333d7e91','tempest-support_any_az_share_type-836416450',1,NULL),('2025-10-01 17:07:32.156333',NULL,'2025-10-01 17:08:33.320237','97f57594-d2cd-4ad0-b515-663008088086','97f57594-d2cd-4ad0-b515-663008088086','tempest-typeshare-type-1894328201',1,NULL),('2025-10-01 17:00:15.668349',NULL,'2025-10-01 17:00:41.563846','9a2a36a8-eb90-44b3-beb1-6fa464aeb5a0','9a2a36a8-eb90-44b3-beb1-6fa464aeb5a0','tempest-typeshare-type-284105924',1,NULL),('2025-10-01 17:06:22.488379',NULL,'2025-10-01 17:06:27.991825','9b2b82ba-3cf7-4717-acdc-139c41e09475','9b2b82ba-3cf7-4717-acdc-139c41e09475','tempest-typeshare-type-1043322713',1,NULL),('2025-10-01 17:07:21.958705',NULL,'2025-10-01 17:07:22.159363','9c87b902-43e3-4a71-a865-a8647eb2821a','9c87b902-43e3-4a71-a865-a8647eb2821a','tempest-az_share_type-876056230',1,NULL),('2025-10-01 17:01:04.228275',NULL,'2025-10-01 17:01:05.252132','9e7edbe6-e094-4dad-b76c-7f49cb8bea7c','9e7edbe6-e094-4dad-b76c-7f49cb8bea7c','tempest-typeshare-type-423317308',1,NULL),('2025-10-01 17:07:22.717823',NULL,'2025-10-01 17:07:22.889126','a1298658-0089-479d-b720-0d0e13637d14','a1298658-0089-479d-b720-0d0e13637d14','tempest-support_any_az_share_type-184892800',1,NULL),('2025-10-01 17:08:18.448378',NULL,'2025-10-01 17:08:20.530338','a2eada0f-bfd5-4f28-95d0-ea6c0e2684d1','a2eada0f-bfd5-4f28-95d0-ea6c0e2684d1','tempest-typeshare-type-1684601480',1,NULL),('2025-10-01 17:00:23.937610',NULL,'2025-10-01 17:00:33.923294','a5f21ade-ee10-4428-9797-73f01ecba1e1','a5f21ade-ee10-4428-9797-73f01ecba1e1','tempest-typeshare-type-1184752965',1,NULL),('2025-10-01 17:00:25.838697',NULL,'2025-10-01 17:00:33.040470','a8689b71-3132-4044-8cd3-2db6227c1239','a8689b71-3132-4044-8cd3-2db6227c1239','tempest-typeshare-type-1054345583',1,NULL),('2025-10-01 16:57:02.364881',NULL,NULL,'False','a8a00136-83b3-4010-b21e-0ef332301b8d','default',1,NULL),('2025-10-01 17:01:09.353920',NULL,'2025-10-01 17:01:15.392639','aa52cdf0-323e-4098-b44f-a770ed855b3f','aa52cdf0-323e-4098-b44f-a770ed855b3f','tempest-tempest-manila-881838489',1,NULL),('2025-10-01 17:03:18.359829',NULL,'2025-10-01 17:03:23.283036','ab8dfc02-86b2-47ba-a5c9-2f5c2387b26e','ab8dfc02-86b2-47ba-a5c9-2f5c2387b26e','tempest-typeshare-type-336708371',1,NULL),('2025-10-01 17:01:03.639036',NULL,'2025-10-01 17:01:06.009386','ac26a0b3-5b55-4ad5-9300-4b33ccbc9f6e','ac26a0b3-5b55-4ad5-9300-4b33ccbc9f6e','tempest-typeshare-type-2048197092',1,NULL),('2025-10-01 17:01:08.331487',NULL,'2025-10-01 17:01:16.496759','aca48d91-398b-4f77-adce-0abdc755540b','aca48d91-398b-4f77-adce-0abdc755540b','tempest-tempest-manila-1247448530',1,NULL),('2025-10-01 17:08:30.282177',NULL,'2025-10-01 17:08:32.526247','acebee5d-ddc2-4d24-9bff-dbaab808c49d','acebee5d-ddc2-4d24-9bff-dbaab808c49d','tempest-typeshare-type-367115726',1,NULL),('2025-10-01 17:03:15.451479',NULL,'2025-10-01 17:03:23.831721','adb48059-bd3b-4a73-9615-acd31e4e1de5','adb48059-bd3b-4a73-9615-acd31e4e1de5','tempest-typeshare-type-1105545621',1,NULL),('2025-10-01 17:01:18.419528',NULL,'2025-10-01 17:01:18.869101','ae2c31e2-af18-4e1f-ac1c-4ffb2127319d','ae2c31e2-af18-4e1f-ac1c-4ffb2127319d','tempest-typeshare-type-1652867043',1,NULL),('2025-10-01 17:05:41.383887',NULL,'2025-10-01 17:06:39.647973','af3d117f-22fe-4775-ba1f-16e7503d27f3','af3d117f-22fe-4775-ba1f-16e7503d27f3','tempest-typeshare-type-1283610370',1,NULL),('2025-10-01 17:00:28.378232',NULL,'2025-10-01 17:00:32.687797','b08160ee-a1b6-438e-87be-76b8acd3a0ae','b08160ee-a1b6-438e-87be-76b8acd3a0ae','tempest-typeshare-type-649681345',1,NULL),('2025-10-01 17:04:51.901860',NULL,'2025-10-01 17:06:06.638263','b09f42fb-ab61-4f61-a72d-bb65a506d3d5','b09f42fb-ab61-4f61-a72d-bb65a506d3d5','tempest-typeshare-type-1919797044',1,NULL),('2025-10-01 17:09:36.143101',NULL,'2025-10-01 17:09:51.454767','b2b70e19-2ae4-4aea-be0a-96f3e01586b6','b2b70e19-2ae4-4aea-be0a-96f3e01586b6','tempest-typeshare-type-208515327',1,NULL),('2025-10-01 17:00:29.624607',NULL,'2025-10-01 17:00:32.027725','b3409aaa-61e2-4fea-885e-c35e67cc2cc6','b3409aaa-61e2-4fea-885e-c35e67cc2cc6','tempest-typeshare-type-1719081533',1,NULL),('2025-10-01 17:01:12.868824',NULL,'2025-10-01 17:01:20.441782','b4e112a6-2cd3-4161-a1d9-6a2b26c3ae12','b4e112a6-2cd3-4161-a1d9-6a2b26c3ae12','tempest-typeshare-type-145719079',1,NULL),('2025-10-01 17:06:56.759192',NULL,'2025-10-01 17:07:00.898811','b5464abf-03cd-45b2-9fa5-a708ce1cdb13','b5464abf-03cd-45b2-9fa5-a708ce1cdb13','tempest-typeshare-type-1903324284',1,NULL),('2025-10-01 17:04:11.505173',NULL,'2025-10-01 17:04:40.099434','b7c65449-bea8-4815-b156-f9df3fa11183','b7c65449-bea8-4815-b156-f9df3fa11183','tempest-typeshare-type-1099324001',1,NULL),('2025-10-01 17:02:31.385176',NULL,'2025-10-01 17:02:49.553101','bb28b531-7011-4456-8d2d-6fe0cb38ac18','bb28b531-7011-4456-8d2d-6fe0cb38ac18','tempest-share-type-1665070139',1,NULL),('2025-10-01 17:00:54.941825',NULL,'2025-10-01 17:00:57.548302','bbf3d39a-0569-4a5e-8e9a-7d20429ddcab','bbf3d39a-0569-4a5e-8e9a-7d20429ddcab','tempest-typeshare-type-617906338',1,NULL),('2025-10-01 17:01:11.609058','2025-10-01 17:01:11.675975','2025-10-01 17:01:13.486278','bd155d9e-1a0b-4cd2-b9d5-60da729389e5','bd155d9e-1a0b-4cd2-b9d5-60da729389e5','tempest-tempest-manila-763239671',1,'description_updated'),('2025-10-01 17:05:13.705985',NULL,'2025-10-01 17:05:27.139908','bf0700f6-e269-4e6e-8ad2-2c76437dcb49','bf0700f6-e269-4e6e-8ad2-2c76437dcb49','tempest-share-type-128539744',1,NULL),('2025-10-01 17:01:00.155574',NULL,'2025-10-01 17:01:08.531186','c450467a-337a-45f5-86c0-09ca92880d39','c450467a-337a-45f5-86c0-09ca92880d39','tempest-typeshare-type-1732345556',1,NULL),('2025-10-01 17:06:37.792420',NULL,'2025-10-01 17:06:53.048120','c5837613-7660-4253-b4d4-3a77d14c481c','c5837613-7660-4253-b4d4-3a77d14c481c','tempest-typeshare-type-399255186',1,NULL),('2025-10-01 17:07:22.146246',NULL,'2025-10-01 17:07:24.067174','c5f1a757-c5dd-4550-8037-f937f8c1f656','c5f1a757-c5dd-4550-8037-f937f8c1f656','tempest-typeshare-type-280989144',1,NULL),('2025-10-01 17:00:56.110757',NULL,'2025-10-01 17:00:56.382644','c90837bc-80c1-4c31-a48f-059acd364abb','c90837bc-80c1-4c31-a48f-059acd364abb','tempest-unique_st_name-746942864',1,NULL),('2025-10-01 17:02:11.672332',NULL,'2025-10-01 17:02:27.832749','cd7fa723-e40d-401a-9a30-e34fb52e7764','cd7fa723-e40d-401a-9a30-e34fb52e7764','tempest-typeshare-type-748270825',1,NULL),('2025-10-01 17:01:01.953595',NULL,'2025-10-01 17:01:07.125861','d07090cf-11c6-408b-bb14-adcbefae497b','d07090cf-11c6-408b-bb14-adcbefae497b','tempest-typeshare-type-1527974752',1,NULL),('2025-10-01 17:01:10.094948',NULL,'2025-10-01 17:01:15.048853','d319c910-ed16-4633-906d-e911c63b8745','d319c910-ed16-4633-906d-e911c63b8745','tempest-tempest-manila-1794843027',1,NULL),('2025-10-01 17:07:22.841470',NULL,'2025-10-01 17:07:23.201704','d3f22a47-70c8-4aec-a6f6-a62eaa8e169c','d3f22a47-70c8-4aec-a6f6-a62eaa8e169c','tempest-support_some_azs_share_type-381681360',1,NULL),('2025-10-01 17:00:29.366117',NULL,'2025-10-01 17:00:32.340577','d4f074e1-6ea4-42dc-8e92-5e6796f377c5','d4f074e1-6ea4-42dc-8e92-5e6796f377c5','tempest-typeshare-type-589322716',1,NULL),('2025-10-01 17:01:01.138248',NULL,'2025-10-01 17:01:07.562541','d6d36ecc-1946-462d-a79b-ba2acd112483','d6d36ecc-1946-462d-a79b-ba2acd112483','tempest-typeshare-type-811373856',1,NULL),('2025-10-01 17:07:22.575238',NULL,'2025-10-01 17:07:22.702884','d76fb610-123c-4f4f-91cd-4ce36d9ac93f','d76fb610-123c-4f4f-91cd-4ce36d9ac93f','tempest-az_share_type-151416118',1,NULL),('2025-10-01 17:02:49.895893',NULL,'2025-10-01 17:03:25.312947','d8069c93-ae97-4830-b977-fb7adaaba2b1','d8069c93-ae97-4830-b977-fb7adaaba2b1','tempest-typeshare-type-1914653263',1,NULL),('2025-10-01 17:00:55.416306',NULL,'2025-10-01 17:00:57.088075','d8e1f9f7-a968-4fa6-8fdb-d9e836031c03','d8e1f9f7-a968-4fa6-8fdb-d9e836031c03','tempest-unique_st_name-1116520010',1,NULL),('2025-10-01 17:03:23.293803',NULL,'2025-10-01 17:03:38.549912','d99548ce-0987-4a62-9022-4080283ca9ec','d99548ce-0987-4a62-9022-4080283ca9ec','tempest-typeshare-type-266405477',1,NULL),('2025-10-01 17:00:54.512318',NULL,'2025-10-01 17:00:58.010621','d9990191-b12d-45ed-85f1-c3d13a9deab5','d9990191-b12d-45ed-85f1-c3d13a9deab5','tempest-typeshare-type-149813987',1,NULL),('2025-10-01 17:01:54.439435',NULL,'2025-10-01 17:02:17.841126','dd944c2a-e556-4a92-a900-c197e5952e3a','dd944c2a-e556-4a92-a900-c197e5952e3a','tempest-typeshare-type-228582350',1,NULL),('2025-10-01 17:00:59.267320',NULL,'2025-10-01 17:01:09.200017','df6253ff-a6f8-4290-a233-f869309ebcaf','df6253ff-a6f8-4290-a233-f869309ebcaf','tempest-typeshare-type-790975019',1,NULL),('2025-10-01 17:00:55.086381',NULL,'2025-10-01 17:00:57.348880','e465a999-324b-4be5-858a-e580842970ef','e465a999-324b-4be5-858a-e580842970ef','tempest-typeshare-type-1916666121',1,NULL),('2025-10-01 17:04:53.888638',NULL,'2025-10-01 17:05:31.941371','e67af6d6-3813-468e-96d3-f52430ec7993','e67af6d6-3813-468e-96d3-f52430ec7993','tempest-typeshare-type-1713137642',1,NULL),('2025-10-01 17:01:07.047907',NULL,'2025-10-01 17:01:07.132853','e7b903a1-0a3c-472d-aa4b-397fb5edbbfe','e7b903a1-0a3c-472d-aa4b-397fb5edbbfe','tempest-tempest-manila-83649979',1,NULL),('2025-10-01 17:00:36.006599',NULL,'2025-10-01 17:00:45.028500','e8d8a1fc-ec5d-43c2-aabc-ffea9e499c55','e8d8a1fc-ec5d-43c2-aabc-ffea9e499c55','tempest-typeshare-type-692012771',1,NULL),('2025-10-01 17:01:02.872834',NULL,'2025-10-01 17:01:06.610870','ebc38e18-2201-4825-b82e-c054d998d6db','ebc38e18-2201-4825-b82e-c054d998d6db','tempest-typeshare-type-212739558',1,NULL),('2025-10-01 17:00:13.217009',NULL,'2025-10-01 17:00:45.491109','eeda9f95-f5c3-4f07-b12e-0b18f7c8da37','eeda9f95-f5c3-4f07-b12e-0b18f7c8da37','tempest-typeshare-type-765112347',1,NULL),('2025-10-01 17:01:25.050343',NULL,'2025-10-01 17:02:15.580592','f0348654-6331-4c8a-89cf-95b9f1fa588d','f0348654-6331-4c8a-89cf-95b9f1fa588d','tempest-typeshare-type-372570477',1,NULL),('2025-10-01 17:01:09.213536',NULL,'2025-10-01 17:01:15.617757','f037cf9b-6053-49fc-bc07-2a6aef4091b0','f037cf9b-6053-49fc-bc07-2a6aef4091b0','tempest-tempest-manila-916248293',1,'Description for share type'),('2025-10-01 17:01:17.113452',NULL,'2025-10-01 17:01:19.311617','f5280e75-7ae9-4ec9-8298-de1f299ac7c5','f5280e75-7ae9-4ec9-8298-de1f299ac7c5','tempest-typeshare-type-2918902',1,NULL),('2025-10-01 17:03:09.543897',NULL,'2025-10-01 17:03:24.168748','f5ad5227-c6e8-40fa-bc1a-78dc60435009','f5ad5227-c6e8-40fa-bc1a-78dc60435009','tempest-typeshare-type-1169107582',0,NULL),('2025-10-01 17:04:55.813166',NULL,'2025-10-01 17:05:29.240638','f6d05e71-de10-42a2-8555-e5899975f59e','f6d05e71-de10-42a2-8555-e5899975f59e','tempest-share-type-75864940',1,NULL),('2025-10-01 17:02:50.110275',NULL,'2025-10-01 17:03:24.715077','f75be615-3c48-49cc-844c-502b209bf197','f75be615-3c48-49cc-844c-502b209bf197','tempest-typeshare-type-2030321345',1,NULL),('2025-10-01 17:04:47.460914',NULL,'2025-10-01 17:05:29.916179','f9da0eae-4f7c-4b85-af50-4858ad082260','f9da0eae-4f7c-4b85-af50-4858ad082260','tempest-share-type-623742573',1,NULL),('2025-10-01 17:07:25.435514',NULL,'2025-10-01 17:07:25.863239','fb108ba7-192f-4564-995c-ac2e7188a745','fb108ba7-192f-4564-995c-ac2e7188a745','tempest-support_some_azs_share_type-1321570560',1,NULL),('2025-10-01 17:00:17.370860',NULL,'2025-10-01 17:00:28.150215','fc0b7d99-26ca-4334-8407-02cec26a8f38','fc0b7d99-26ca-4334-8407-02cec26a8f38','tempest-typeshare-type-916215994',1,NULL),('2025-10-01 17:01:07.498028',NULL,'2025-10-01 17:01:17.281428','fe7694b8-bd4d-423c-b9fc-8b41e35f8112','fe7694b8-bd4d-423c-b9fc-8b41e35f8112','tempest-tempest-manila-247764507',1,NULL),('2025-10-01 17:05:04.652784',NULL,'2025-10-01 17:05:28.165877','ff31a3ee-a999-42cd-b0e7-6b0804664d3d','ff31a3ee-a999-42cd-b0e7-6b0804664d3d','tempest-share-type-1647570767',1,NULL),('2025-10-01 17:00:59.600988',NULL,'2025-10-01 17:01:08.772282','ffa859b3-020a-4967-8608-93579f69e3a4','ffa859b3-020a-4967-8608-93579f69e3a4','tempest-typeshare-type-1726207948',1,NULL);
/*!40000 ALTER TABLE `share_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shares`
--

DROP TABLE IF EXISTS `shares`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `shares` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `share_proto` varchar(255) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `snapshot_support` tinyint(1) DEFAULT NULL,
  `share_group_id` varchar(36) DEFAULT NULL,
  `source_share_group_snapshot_member_id` varchar(36) DEFAULT NULL,
  `task_state` varchar(255) DEFAULT NULL,
  `replication_type` varchar(255) DEFAULT NULL,
  `create_share_from_snapshot_support` tinyint(1) DEFAULT NULL,
  `revert_to_snapshot_support` tinyint(1) DEFAULT NULL,
  `mount_snapshot_support` tinyint(1) DEFAULT NULL,
  `is_soft_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `scheduled_to_be_deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_shares_share_group_id` (`share_group_id`),
  CONSTRAINT `fk_shares_share_group_id` FOREIGN KEY (`share_group_id`) REFERENCES `share_groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shares`
--

LOCK TABLES `shares` WRITE;
/*!40000 ALTER TABLE `shares` DISABLE KEYS */;
INSERT INTO `shares` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `size`, `display_name`, `display_description`, `snapshot_id`, `share_proto`, `is_public`, `snapshot_support`, `share_group_id`, `source_share_group_snapshot_member_id`, `task_state`, `replication_type`, `create_share_from_snapshot_support`, `revert_to_snapshot_support`, `mount_snapshot_support`, `is_soft_deleted`, `scheduled_to_be_deleted_at`) VALUES ('2025-10-01 17:02:02.620725','2025-10-01 17:02:07.320038','2025-10-01 17:02:07.319614','004da363-46ac-471c-861f-c2e23fda6dec','004da363-46ac-471c-861f-c2e23fda6dec','3dce165987c44fe28fc0096cce9ddb2b','06efa1ba477e45208d5ba21e3e7c2703',1,'tempest-tempest-created-share-1092857360','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:06:36.446037','2025-10-01 17:06:42.460721','2025-10-01 17:06:42.460259','0247ce18-ff4b-465c-ac46-a70fcaae9d45','0247ce18-ff4b-465c-ac46-a70fcaae9d45','13c52b1d5b7048f4bf4952658e63fbac','1dd38e8e995543ea9f3667b44746e174',1,'tempest-tempest-created-share-1650516304','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:04:54.216784','2025-10-01 17:05:29.513300','2025-10-01 17:05:29.512676','05cc2137-ef64-49b8-991a-bfecfb50f6d0','05cc2137-ef64-49b8-991a-bfecfb50f6d0','d0c0ffc90809482c8626b2e61d341f16','23b43441437342609cce9f7f9d4d5521',1,'tempest-tempest-share-name-140592831','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:01:54.811416','2025-10-01 17:02:06.352913','2025-10-01 17:02:06.352558','143b859e-5f32-4381-b1d7-d35ba0c576cf','143b859e-5f32-4381-b1d7-d35ba0c576cf','559501bf42ce4daab8b14ced6e0516c4','4743342a50a447f89df320c01c1cbcc9',1,'public_share - must be visible to all projects in the cloud','public_share_desc',NULL,'CEPHFS',1,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:07:49.033064','2025-10-01 17:07:53.009213','2025-10-01 17:07:53.008856','1a4303ab-fd5b-496c-ba7f-a6e9a95ee38c','1a4303ab-fd5b-496c-ba7f-a6e9a95ee38c','e660ba5c7b304e2abc80f9b99bdd51af','29266081bf264ee18aad20d4882a428c',2,'tempest-tempest-created-share-1119257062','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:04:58.470159','2025-10-01 17:05:25.157320','2025-10-01 17:05:25.156905','1acdbdc9-61a5-46ac-b58b-9424aac4ae8f','1acdbdc9-61a5-46ac-b58b-9424aac4ae8f','d0c0ffc90809482c8626b2e61d341f16','23b43441437342609cce9f7f9d4d5521',1,'tempest-tempest-share-name-292233650','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:01:58.748693','2025-10-01 17:02:02.727788','2025-10-01 17:02:02.727311','1f120235-e93c-4f9a-b125-9ea250d5f133','1f120235-e93c-4f9a-b125-9ea250d5f133','b92b509d372144dd8cbe29e18bab1676','e7862d18aeb143d49259310c073583be',1,'private_share','private share in the primary user project',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:04:43.176229','2025-10-01 17:04:47.163250','2025-10-01 17:04:47.162798','2686dbe8-432c-4e15-94fc-e2c57311eadb','2686dbe8-432c-4e15-94fc-e2c57311eadb','d6dae67f198f483d86a85008b5959866','a1cd9e94225644748568dfbc4af1058a',1,'tempest-tempest-created-share-1183258487','tempest-tempest-created-share-desc-1600384353',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:07:30.683263','2025-10-01 17:07:34.806731','2025-10-01 17:07:34.806167','2f85cc8b-1048-424c-a3a3-0b522357dfb2','2f85cc8b-1048-424c-a3a3-0b522357dfb2','8395fbe4aa1a4d9bb181f7e321703f61','f63de858e3a74f88a78eaacea59850c5',1,'tempest-tempest-created-share-486497519','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:00:43.899411','2025-10-01 17:00:47.847248','2025-10-01 17:00:47.846758','36ec95f5-2e76-4070-8cf3-045a4ad4dbd0','36ec95f5-2e76-4070-8cf3-045a4ad4dbd0','f01d6292274540ac84c2c1da0ccbaedb','2204ae41373c4a57a26d8e752f9c9721',1,'tempest-tempest-created-share-1686936099','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:09:09.338986','2025-10-01 17:09:24.206247','2025-10-01 17:09:24.205847','3be0a77c-9477-462e-8eb4-10c3ba44b638','3be0a77c-9477-462e-8eb4-10c3ba44b638','1bcf3990c34341488ff134d67569a00c','a942627ec05749c09a975132ee6031d6',1,'tempest-tempest-created-share-411138092','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-10-01 17:05:17.372798','2025-10-01 17:05:21.254538','2025-10-01 17:05:21.253979','3dcbb834-7746-46f2-a0a5-c2863b1199a5','3dcbb834-7746-46f2-a0a5-c2863b1199a5','d6dae67f198f483d86a85008b5959866','a1cd9e94225644748568dfbc4af1058a',1,'tempest-tempest-created-share-217866653','tempest-tempest-created-share-desc-1394216841',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:02:35.641766','2025-10-01 17:02:39.333765','2025-10-01 17:02:39.333167','44260837-c979-44ee-a03a-ac05c7b8646a','44260837-c979-44ee-a03a-ac05c7b8646a','7b7b6f82426848dc984e282a4a4ae2bb','f15311ab27ef411d82024fc6390e3f6d',1,'tempest-tempest-created-share-859393396','tempest-tempest-created-share-desc-2126117712',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:07:32.468421','2025-10-01 17:08:30.114982','2025-10-01 17:08:30.114657','475eaf7b-7be8-4075-99c6-46b38f1b33fb','475eaf7b-7be8-4075-99c6-46b38f1b33fb','e660ba5c7b304e2abc80f9b99bdd51af','29266081bf264ee18aad20d4882a428c',1,'tempest-tempest-share-name-987376766','tempest-tempest-share-description-1172607509',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:04:47.636329','2025-10-01 17:04:51.881326','2025-10-01 17:04:51.880591','47b52b31-2fc8-48a3-aa03-8f7b058143a9','47b52b31-2fc8-48a3-aa03-8f7b058143a9','d6dae67f198f483d86a85008b5959866','a1cd9e94225644748568dfbc4af1058a',1,'tempest-tempest-created-share-1672305820','tempest-tempest-created-share-desc-828731341',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:06:06.080436',NULL,NULL,'False','480a39b7-c9bc-46e1-9446-76acd2c26d4a','173ca489ed484f4d9628dc0a289d1dba','1841221f332340a299707d253063659f',1,'tempest-tempest-created-share-1484682366','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:08:06.444425','2025-10-01 17:08:14.052521','2025-10-01 17:08:14.052229','4c348280-32d6-4b4f-850a-a415d2397899','4c348280-32d6-4b4f-850a-a415d2397899','e660ba5c7b304e2abc80f9b99bdd51af','29266081bf264ee18aad20d4882a428c',1,'tempest-tempest-created-share-1108764','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:03:35.346535','2025-10-01 17:03:43.779902','2025-10-01 17:03:43.778951','4f309c99-0839-4c72-b180-b88ea761ebd4','4f309c99-0839-4c72-b180-b88ea761ebd4','0e5069509e1b4a3fba307dac6547b514','a0ac8ec815504b8dae62c40a55008f52',1,'tempest-tempest-created-share-429436289','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:09:59.017216','2025-10-01 17:10:11.045293','2025-10-01 17:10:11.044918','4fbc718e-e5a9-4005-93e5-22e43f8cccc0','4fbc718e-e5a9-4005-93e5-22e43f8cccc0','7b4f3ac1db9d4257ad4205e53cd20033','e168bce9fe04489288d3480d858b4158',1,'tempest-tempest-new-name-1322064836','tempest-tempest-new-description-1228878018',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:05:22.366751','2025-10-01 17:05:26.283348','2025-10-01 17:05:26.282888','4fec8b23-dcb5-4ef4-9f12-9e9ccd47d8d5','4fec8b23-dcb5-4ef4-9f12-9e9ccd47d8d5','d6dae67f198f483d86a85008b5959866','a1cd9e94225644748568dfbc4af1058a',1,'tempest-tempest-created-share-1019176403','tempest-tempest-created-share-desc-1323498813',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:01:02.037317','2025-10-01 17:01:18.206309','2025-10-01 17:01:18.205668','502deaa1-a93e-4c04-8091-3598765fe522','502deaa1-a93e-4c04-8091-3598765fe522','afbf15b176594b999a50ea15bf84d237','c4ae009f89aa49ccadaaeed54f17efe5',1,'tempest-share-1315756496','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:07:48.547301','2025-10-01 17:07:52.648451','2025-10-01 17:07:52.647903','510a1869-e04c-4711-b4ce-1bb86392d728','510a1869-e04c-4711-b4ce-1bb86392d728','8395fbe4aa1a4d9bb181f7e321703f61','f63de858e3a74f88a78eaacea59850c5',1,'tempest-tempest-created-share-698105703','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:02:37.627532','2025-10-01 17:02:44.444772','2025-10-01 17:02:44.444291','5239d943-cda9-4d21-a0d4-31879c0800e0','5239d943-cda9-4d21-a0d4-31879c0800e0','3dce165987c44fe28fc0096cce9ddb2b','06efa1ba477e45208d5ba21e3e7c2703',1,'tempest-tempest-created-share-998444710','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:08:17.182553','2025-10-01 17:08:21.467588','2025-10-01 17:08:21.466938','5c6f08b2-a238-4b91-9928-d6280590b74e','5c6f08b2-a238-4b91-9928-d6280590b74e','e660ba5c7b304e2abc80f9b99bdd51af','29266081bf264ee18aad20d4882a428c',1,'tempest-tempest-created-share-775913902','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:05:13.885992','2025-10-01 17:05:21.545322','2025-10-01 17:05:21.544966','5fd34ab3-1557-4811-b421-fd2bdc80fe5c','5fd34ab3-1557-4811-b421-fd2bdc80fe5c','d6dae67f198f483d86a85008b5959866','a1cd9e94225644748568dfbc4af1058a',1,'tempest-tempest-created-share-1515127905','tempest-tempest-created-share-desc-1184675680',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:00:17.667677','2025-10-01 17:00:23.046692','2025-10-01 17:00:23.045886','604a4627-b4dc-4eaa-97db-9140ae61556e','604a4627-b4dc-4eaa-97db-9140ae61556e','f01d6292274540ac84c2c1da0ccbaedb','2204ae41373c4a57a26d8e752f9c9721',2,'tempest-tempest-created-share-1885543039','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:06:38.049869','2025-10-01 17:06:49.576832','2025-10-01 17:06:49.576425','69635b4c-8f40-4a57-90cc-d550c183c871','69635b4c-8f40-4a57-90cc-d550c183c871','fcbf8552ba484efaa8cae2712992af80','384850ddb88c4d3798b3a3d365973ad0',1,'tempest-tempest-created-share-1967996523','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:04:55.928378','2025-10-01 17:06:00.118928','2025-10-01 17:06:00.118436','69e9a113-75fb-4dff-9fd9-886dc6af9628','69e9a113-75fb-4dff-9fd9-886dc6af9628','bdbab5c8cbd84614a605693d09049109','86a0062edb9a4a3293bf2e93012e4f13',1,'tempest-tempest-created-share-2102295180','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-10-01 17:03:08.457485','2025-10-01 17:04:23.503259','2025-10-01 17:04:23.502831','6e112f49-7379-4e48-b00d-b9ada34f0c5d','6e112f49-7379-4e48-b00d-b9ada34f0c5d','0e5069509e1b4a3fba307dac6547b514','a0ac8ec815504b8dae62c40a55008f52',1,'tempest-tempest-created-share-363640599','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:08:34.872569','2025-10-01 17:09:40.411695','2025-10-01 17:09:40.411343','6fcb0b46-4ab9-4125-aa81-25240782d372','6fcb0b46-4ab9-4125-aa81-25240782d372','c6801335b5594dc38e737626407c353c','2d1156e4dd1a4bcf99d7af9680c3c563',1,'tempest-tempest-share-name-1068189002','tempest-tempest-share-description-384022112','f40cff96-8848-426c-90c1-e99c5be0398c','CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-10-01 17:00:17.586803','2025-10-01 17:00:24.919129','2025-10-01 17:00:24.918810','704e6c7e-e6cf-452b-97b4-777e2c8ab556','704e6c7e-e6cf-452b-97b4-777e2c8ab556','795436ca4abe4e0e8da2ee3bc5b1dbda','85a428afb52742d3b601161e8821da9f',1,'tempest-tempest-created-share-1636301921','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:03:12.663602','2025-10-01 17:03:20.476546','2025-10-01 17:03:20.476196','7401d0d1-b73f-415c-9142-bd25f09b8209','7401d0d1-b73f-415c-9142-bd25f09b8209','0e5069509e1b4a3fba307dac6547b514','a0ac8ec815504b8dae62c40a55008f52',1,'tempest-tempest-created-share-1089895909','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:03:23.205646','2025-10-01 17:03:32.849379','2025-10-01 17:03:32.848972','7622bcd9-86ac-47c9-b04e-06cfef0a59aa','7622bcd9-86ac-47c9-b04e-06cfef0a59aa','0e5069509e1b4a3fba307dac6547b514','a0ac8ec815504b8dae62c40a55008f52',1,'tempest-tempest-created-share-1918736419','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:05:38.467627','2025-10-01 17:05:53.347244','2025-10-01 17:05:53.346853','7a670548-55c7-4b1d-8c53-f1a735354eef','7a670548-55c7-4b1d-8c53-f1a735354eef','5acd4d62fc8e4eeabaae2462d3c7a8fa','fb3120e923574f759bb16e2e2d603473',1,'tempest-tempest-created-share-1335014448','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:09:36.373524','2025-10-01 17:09:48.265037','2025-10-01 17:09:48.264500','7abf0d63-e158-4ef2-9c76-e1cc6d2d2628','7abf0d63-e158-4ef2-9c76-e1cc6d2d2628','8535d97e92664479824a211407aa1fdc','0103e60cf08a41ecb4737770562548a5',1,'tempest-tempest-share-name-1321662821','tempest-tempest-share-description-688660802',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-10-01 17:04:52.134637','2025-10-01 17:06:03.722282','2025-10-01 17:06:03.721899','7b1893fd-a87d-4134-86a0-88945c063bc6','7b1893fd-a87d-4134-86a0-88945c063bc6','bdbab5c8cbd84614a605693d09049109','86a0062edb9a4a3293bf2e93012e4f13',1,'tempest-tempest-created-share-1102996502','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:06:11.767272','2025-10-01 17:06:17.368313','2025-10-01 17:06:17.367801','7c9b06f4-d594-496a-9f97-ece8a04d7e6f','7c9b06f4-d594-496a-9f97-ece8a04d7e6f','04f5ceff16e74a1bb67c0b5ed79dce63','8c95d7d4c61e4a5bbe4dc2e0f6e03fd9',1,'tempest-tempest-created-share-1231370495','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:07:26.765798','2025-10-01 17:07:38.088075','2025-10-01 17:07:38.087678','7df9004c-df10-46e2-8a1d-a5b53da1c228','7df9004c-df10-46e2-8a1d-a5b53da1c228','8395fbe4aa1a4d9bb181f7e321703f61','f63de858e3a74f88a78eaacea59850c5',1,'tempest-tempest-created-share-1736273845','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:04:52.308602','2025-10-01 17:04:59.996640','2025-10-01 17:04:59.996297','82afcb55-ab13-400e-b95c-60fdd65c2ff7','82afcb55-ab13-400e-b95c-60fdd65c2ff7','d6dae67f198f483d86a85008b5959866','a1cd9e94225644748568dfbc4af1058a',1,'tempest-tempest-created-share-405815084','tempest-tempest-created-share-desc-1967843367',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:00:26.184845','2025-10-01 17:00:33.577551','2025-10-01 17:00:33.576980','83ae248c-9fad-4f85-84c6-92e2d645fcc5','83ae248c-9fad-4f85-84c6-92e2d645fcc5','f01d6292274540ac84c2c1da0ccbaedb','2204ae41373c4a57a26d8e752f9c9721',2,'tempest-tempest-created-share-1526484847','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:07:08.939539','2025-10-01 17:08:03.459337','2025-10-01 17:08:03.458894','8829ada2-2a2b-4b03-950c-0cffc3adb0ff','8829ada2-2a2b-4b03-950c-0cffc3adb0ff','fcbf8552ba484efaa8cae2712992af80','384850ddb88c4d3798b3a3d365973ad0',1,'tempest-tempest-created-share-1869918011','Tempest\'s share','ef793e02-9980-4db2-8e9a-aaf0250b4696','CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-10-01 17:07:56.244781','2025-10-01 17:08:03.316267','2025-10-01 17:08:03.315779','8f916214-aa8c-4550-b818-ce6a422041bc','8f916214-aa8c-4550-b818-ce6a422041bc','e660ba5c7b304e2abc80f9b99bdd51af','29266081bf264ee18aad20d4882a428c',1,'tempest-tempest-created-share-1950607698','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:01:58.990796','2025-10-01 17:02:50.910326','2025-10-01 17:02:50.909793','92376f2a-17bc-4779-84ff-af7b6e540494','92376f2a-17bc-4779-84ff-af7b6e540494','3dce165987c44fe28fc0096cce9ddb2b','06efa1ba477e45208d5ba21e3e7c2703',1,'tempest-tempest-created-share-1896380791','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:00:13.613358','2025-10-01 17:01:50.816336','2025-10-01 17:01:50.815988','95bc68e4-4409-4a9b-83c9-5b9c7854b687','95bc68e4-4409-4a9b-83c9-5b9c7854b687','f01d6292274540ac84c2c1da0ccbaedb','2204ae41373c4a57a26d8e752f9c9721',1,'tempest-tempest-created-share-2040182362','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:07:55.794271','2025-10-01 17:08:02.724697','2025-10-01 17:08:02.724018','99044efa-e30e-406b-bd75-e0521344fb17','99044efa-e30e-406b-bd75-e0521344fb17','8395fbe4aa1a4d9bb181f7e321703f61','f63de858e3a74f88a78eaacea59850c5',1,'tempest-tempest-created-share-1088311863','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:00:16.021483','2025-10-01 17:00:38.445496','2025-10-01 17:00:38.445151','99b03a60-1080-43f4-9d57-6a2ffd473ac6','99b03a60-1080-43f4-9d57-6a2ffd473ac6','0c2a887dd4a845859f0669eb83fe675c','1f4a5d54519f4f46897a6eba8668a5c4',1,'tempest-tempest-created-share-475735240','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:02:44.008932','2025-10-01 17:02:48.146741','2025-10-01 17:02:48.146397','9ec5bfe3-1c19-49c4-95ce-fa6b337dda04','9ec5bfe3-1c19-49c4-95ce-fa6b337dda04','7b7b6f82426848dc984e282a4a4ae2bb','f15311ab27ef411d82024fc6390e3f6d',1,'tempest-tempest-created-share-1584400674','tempest-tempest-created-share-desc-595663802',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:09:14.401974','2025-10-01 17:09:27.767098','2025-10-01 17:09:27.766675','a0474f3d-dbe0-4366-bff6-13d06a99cfbd','a0474f3d-dbe0-4366-bff6-13d06a99cfbd','c6801335b5594dc38e737626407c353c','2d1156e4dd1a4bcf99d7af9680c3c563',1,'tempest-tempest-created-share-1860216397','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-10-01 17:02:18.875580','2025-10-01 17:02:23.159698','2025-10-01 17:02:23.159277','a528f132-e661-4551-bdf2-6aba8bc188e3','a528f132-e661-4551-bdf2-6aba8bc188e3','3dce165987c44fe28fc0096cce9ddb2b','06efa1ba477e45208d5ba21e3e7c2703',1,'tempest-tempest-created-share-2084419400','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:05:05.402267','2025-10-01 17:05:13.260345','2025-10-01 17:05:13.259672','a7ee0331-e686-4283-9719-930d79c77201','a7ee0331-e686-4283-9719-930d79c77201','d6dae67f198f483d86a85008b5959866','a1cd9e94225644748568dfbc4af1058a',1,'tempest-tempest-created-share-266757641','tempest-tempest-created-share-desc-1586572802',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:00:40.800019','2025-10-01 17:00:46.412886','2025-10-01 17:00:46.412497','a915638e-896a-4b63-919d-f2e57965807a','a915638e-896a-4b63-919d-f2e57965807a','aff16e38eefd4e66b0b620d67bc65d6e','efef7d21275549538c8a121a0599e3f4',1,'tempest-tempest-created-share-440005888','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:07:01.246149','2025-10-01 17:08:13.675027','2025-10-01 17:08:13.674579','aa416fc6-23c7-4223-ab29-52b404b91845','aa416fc6-23c7-4223-ab29-52b404b91845','fcbf8552ba484efaa8cae2712992af80','384850ddb88c4d3798b3a3d365973ad0',1,'tempest-tempest-created-share-743254852','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-10-01 17:02:51.577786','2025-10-01 17:03:00.959267','2025-10-01 17:03:00.958886','aad7151d-59fc-49a6-ae46-ee933dbfddb8','aad7151d-59fc-49a6-ae46-ee933dbfddb8','9067353b927842dbadd16dcb12f93b3d','a307fd4b882d45898ca085500fbf65b4',4,'tempest-tempest-created-share-1999901142','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:01:13.011394','2025-10-01 17:01:17.141253','2025-10-01 17:01:17.140850','ad5e40a1-7b65-4a0d-a7be-711e07e0447b','ad5e40a1-7b65-4a0d-a7be-711e07e0447b','675dc5e53691498a85efcdb811e5a848','fddf2e8f31614cd6afbfcdeff763553b',1,'tempest-tempest-created-share-2124209979','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:05:10.088082','2025-10-01 17:05:18.258489','2025-10-01 17:05:18.258071','adc0f55f-5d3c-4033-b10d-5429864a3bdf','adc0f55f-5d3c-4033-b10d-5429864a3bdf','d0c0ffc90809482c8626b2e61d341f16','23b43441437342609cce9f7f9d4d5521',1,'tempest-tempest-share-name-1650212109','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:05:03.156992','2025-10-01 17:05:56.796256','2025-10-01 17:05:56.795852','b87e1026-6ce3-48d5-a1fd-8dc67c00f4d5','b87e1026-6ce3-48d5-a1fd-8dc67c00f4d5','5acd4d62fc8e4eeabaae2462d3c7a8fa','fb3120e923574f759bb16e2e2d603473',1,'tempest-tempest-created-share-874568480','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-10-01 17:03:53.466734','2025-10-01 17:04:09.655339','2025-10-01 17:04:09.654797','bb669f14-71a4-4987-aaff-00e14218a038','bb669f14-71a4-4987-aaff-00e14218a038','b2685616371841959873dec890fa5385','5473075ec2e4439eadc201afc270390c',1,'tempest-tempest-created-share-382429086','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:05:00.402040','2025-10-01 17:05:13.531896','2025-10-01 17:05:13.531467','bca3e7d0-34c7-4c18-ab69-45a419864f77','bca3e7d0-34c7-4c18-ab69-45a419864f77','d6dae67f198f483d86a85008b5959866','a1cd9e94225644748568dfbc4af1058a',1,'tempest-tempest-created-share-1310640139','tempest-tempest-created-share-desc-898819316',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:04:56.122538','2025-10-01 17:04:59.679253','2025-10-01 17:04:59.678961','bcea9c48-c6b9-4586-b3e5-bae5a301e1f0','bcea9c48-c6b9-4586-b3e5-bae5a301e1f0','d6dae67f198f483d86a85008b5959866','a1cd9e94225644748568dfbc4af1058a',1,'tempest-tempest-created-share-1686955975','tempest-tempest-created-share-desc-2074440879',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:02:56.718675','2025-10-01 17:03:04.423487','2025-10-01 17:03:04.423113','c058b0b6-2667-4b81-9f75-254ad567bf46','c058b0b6-2667-4b81-9f75-254ad567bf46','9067353b927842dbadd16dcb12f93b3d','a307fd4b882d45898ca085500fbf65b4',3,'tempest-tempest-created-share-1262975998','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:00:36.141780','2025-10-01 17:00:42.066205','2025-10-01 17:00:42.065786','c6d4dccb-aacc-4dbc-9596-716921556f10','c6d4dccb-aacc-4dbc-9596-716921556f10','df0b2d6216a142dc92cd2a29e14daf63','3b070cbc3e9f4af28b0758b866474914',1,'tempest-tempest-created-share-581551221','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:02:31.498859','2025-10-01 17:02:35.135992','2025-10-01 17:02:35.135754','cf0992a6-7788-4ae9-911d-8b443f293993','cf0992a6-7788-4ae9-911d-8b443f293993','7b7b6f82426848dc984e282a4a4ae2bb','f15311ab27ef411d82024fc6390e3f6d',1,'tempest-tempest-created-share-1773357598','tempest-tempest-created-share-desc-1313325002',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:02:10.515837','2025-10-01 17:02:15.678988','2025-10-01 17:02:15.678603','d0d164e3-b2a9-4656-9db9-e6fab398836c','d0d164e3-b2a9-4656-9db9-e6fab398836c','3dce165987c44fe28fc0096cce9ddb2b','06efa1ba477e45208d5ba21e3e7c2703',1,'tempest-tempest-created-share-1598752118','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:01:32.593664','2025-10-01 17:02:05.520461','2025-10-01 17:02:05.519753','d539111d-51b0-4419-98c4-939556ffe18d','d539111d-51b0-4419-98c4-939556ffe18d','0330a1c6d11e45b8a6e21e8e46c29677','0e7ac90f0c9f41cbb8e463ae95d18d81',1,'tempest-tempest-share-name-926062493','tempest-tempest-share-description-1592640813','0836034c-448e-4a12-a3fa-b569fb708078','CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-10-01 17:02:26.461424','2025-10-01 17:02:32.375328','2025-10-01 17:02:32.374796','d664cfa8-7e79-4c95-82dc-013d6f58dbd5','d664cfa8-7e79-4c95-82dc-013d6f58dbd5','3dce165987c44fe28fc0096cce9ddb2b','06efa1ba477e45208d5ba21e3e7c2703',1,'tempest-tempest-created-share-1287039713','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:02:39.832810','2025-10-01 17:02:43.438369','2025-10-01 17:02:43.437924','dab13563-4d57-413d-bd06-6648b3c43113','dab13563-4d57-413d-bd06-6648b3c43113','7b7b6f82426848dc984e282a4a4ae2bb','f15311ab27ef411d82024fc6390e3f6d',1,'tempest-tempest-created-share-61627311','tempest-tempest-created-share-desc-594635930',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:01:25.258419','2025-10-01 17:02:12.649937','2025-10-01 17:02:12.649473','db0e695b-e59d-484f-ba2e-6e5ec878cc21','db0e695b-e59d-484f-ba2e-6e5ec878cc21','0330a1c6d11e45b8a6e21e8e46c29677','0e7ac90f0c9f41cbb8e463ae95d18d81',1,'tempest-tempest-share-name-360231688','tempest-tempest-share-description-1254046461',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-10-01 17:02:27.362959','2025-10-01 17:02:31.167486','2025-10-01 17:02:31.166707','dc6e4ceb-a1a6-4e65-a0ea-9ff537eaa173','dc6e4ceb-a1a6-4e65-a0ea-9ff537eaa173','7b7b6f82426848dc984e282a4a4ae2bb','f15311ab27ef411d82024fc6390e3f6d',1,'tempest-tempest-created-share-393608657','tempest-tempest-created-share-desc-135079147',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:04:23.012168','2025-10-01 17:04:35.621084','2025-10-01 17:04:35.620714','dfcc8c75-53ab-4ce9-b358-4ac7e2a58279','dfcc8c75-53ab-4ce9-b358-4ac7e2a58279','af8da6febaae4dfe9de0fa747a5ef119','220545ce6f424d4187770842929567dc',1,'tempest-tempest-share-name-592155510','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:08:26.388813','2025-10-01 17:09:46.958706','2025-10-01 17:09:46.958362','dff79459-719a-48f9-bc64-a4172051df45','dff79459-719a-48f9-bc64-a4172051df45','c6801335b5594dc38e737626407c353c','2d1156e4dd1a4bcf99d7af9680c3c563',1,'tempest-tempest-share-name-1645779870','tempest-tempest-share-description-31840317',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-10-01 17:06:57.215694','2025-10-01 17:07:12.438228','2025-10-01 17:07:12.437813','e160f19c-fd45-4300-abd5-b3a4764aea08','e160f19c-fd45-4300-abd5-b3a4764aea08','fdec41847e24465299bb1f75d3e480d2','7697ecff3b5f413c99a5ace837dd6970',1,'tempest-tempest-created-share-1409928588','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:02:49.516166','2025-10-01 17:06:21.804717','2025-10-01 17:06:21.804231','e17d9201-dace-4c98-9dab-80fdfbfad649','e17d9201-dace-4c98-9dab-80fdfbfad649','6ae885d77a5748a299ec5daaece928c1','1841221f332340a299707d253063659f',1,'tempest-tempest-created-share-823921526','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:00:36.756681','2025-10-01 17:00:40.654379','2025-10-01 17:00:40.654035','e2fa38e2-7a0c-42c1-a5bc-67dbe164c008','e2fa38e2-7a0c-42c1-a5bc-67dbe164c008','f01d6292274540ac84c2c1da0ccbaedb','2204ae41373c4a57a26d8e752f9c9721',1,'tempest-tempest-created-share-1072504657','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:01:26.695992','2025-10-01 17:01:43.328185','2025-10-01 17:01:43.327773','e3193d43-5ad0-4a4b-b5ad-b33441f5b578','e3193d43-5ad0-4a4b-b5ad-b33441f5b578','c7bd5ab094534136b1906389e4264c0b','756b231c8c724081bed78676d19a02ec',1,'tempest-tempest-created-share-460082482','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:00:13.983203','2025-10-01 17:00:42.248530','2025-10-01 17:00:42.248211','e51a95d3-50b0-4888-ba72-07dbe0b65690','e51a95d3-50b0-4888-ba72-07dbe0b65690','0c2a887dd4a845859f0669eb83fe675c','1f4a5d54519f4f46897a6eba8668a5c4',1,'tempest-tempest-created-share-1715209272','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:02:29.116819','2025-10-01 17:02:34.447984','2025-10-01 17:02:34.447676','e893a892-0405-4677-a235-d77856bfef2b','e893a892-0405-4677-a235-d77856bfef2b','0fc8d89ad29f495783c39738774ff7cd','d36f1681b7b349a5bf71bdac8eae5902',1,'public_share','public_share_desc',NULL,'CEPHFS',1,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:07:41.405509','2025-10-01 17:07:45.556951','2025-10-01 17:07:45.556467','eb733b75-96a3-41ff-81eb-fb242a8cf1b6','eb733b75-96a3-41ff-81eb-fb242a8cf1b6','e660ba5c7b304e2abc80f9b99bdd51af','29266081bf264ee18aad20d4882a428c',1,'tempest-tempest-created-share-604918722','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:05:09.324924','2025-10-01 17:05:12.907789','2025-10-01 17:05:12.907427','ec007ccb-27a7-4458-b286-526d906c9733','ec007ccb-27a7-4458-b286-526d906c9733','d6dae67f198f483d86a85008b5959866','a1cd9e94225644748568dfbc4af1058a',1,'tempest-tempest-created-share-471385652','tempest-tempest-created-share-desc-756518608',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:02:09.801964','2025-10-01 17:02:14.335330','2025-10-01 17:02:14.334866','f4d49779-a20c-4108-90e2-028ca74c20f3','f4d49779-a20c-4108-90e2-028ca74c20f3','b92b509d372144dd8cbe29e18bab1676','e7862d18aeb143d49259310c073583be',1,'tempest-tempest-new-share-name-2042143718','share is now updated',NULL,'CEPHFS',1,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:05:02.737473','2025-10-01 17:05:21.633389','2025-10-01 17:05:21.632908','f5032ae4-40d3-4416-b119-b7df6be88a0b','f5032ae4-40d3-4416-b119-b7df6be88a0b','d0c0ffc90809482c8626b2e61d341f16','23b43441437342609cce9f7f9d4d5521',1,'tempest-tempest-share-name-378594148','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:05:38.437239','2025-10-01 17:06:01.522720','2025-10-01 17:06:01.522335','f5f63f5f-60e6-41b5-8df8-2523cbbf72e9','f5f63f5f-60e6-41b5-8df8-2523cbbf72e9','09f29295317a46d6b8c0b29e6210e6f7','ad666ccc4f754e07a5041ffb5aaf32ae',1,'tempest-tempest-created-share-266405866','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:09:31.096278','2025-10-01 17:09:36.899412','2025-10-01 17:09:36.899027','f699304c-bc56-43fe-ae97-bee754cc0413','f699304c-bc56-43fe-ae97-bee754cc0413','c6801335b5594dc38e737626407c353c','2d1156e4dd1a4bcf99d7af9680c3c563',1,'tempest-tempest-created-share-1192739291','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-10-01 17:08:57.234736','2025-10-01 17:09:07.515298','2025-10-01 17:09:07.514779','f6c69445-335c-4e53-abc0-d66b7aa436d5','f6c69445-335c-4e53-abc0-d66b7aa436d5','c6801335b5594dc38e737626407c353c','2d1156e4dd1a4bcf99d7af9680c3c563',2,'tempest-tempest-created-share-2055645689','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-10-01 17:06:53.416791','2025-10-01 17:06:58.995168','2025-10-01 17:06:58.994630','f7529e23-0f0c-49da-88eb-67f6e20776a4','f7529e23-0f0c-49da-88eb-67f6e20776a4','fcbf8552ba484efaa8cae2712992af80','384850ddb88c4d3798b3a3d365973ad0',1,'tempest-tempest-created-share-2122687343','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:02:11.876643','2025-10-01 17:02:25.305355','2025-10-01 17:02:25.304840','f85090ff-591b-405d-88b6-36d427ce5b6a','f85090ff-591b-405d-88b6-36d427ce5b6a','ea1821978b91472190eb48dbc2127e63','0146329fc8d749b394ed822844000f6d',1,'tempest-tempest-created-share-627047296','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-10-01 17:05:41.561459','2025-10-01 17:06:36.440092','2025-10-01 17:06:36.439740','f8eb063b-f94f-4394-a2be-7bbf2414c84c','f8eb063b-f94f-4394-a2be-7bbf2414c84c','c0d8712c5da945d1ba492d2950f68d35','40c3564ff57e4cfca7dd255e456bdcb2',1,'tempest-tempest-share-name-1739173093','tempest-tempest-share-description-1959824968',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-10-01 17:08:43.117752','2025-10-01 17:09:06.193845','2025-10-01 17:09:06.193548','fc6726f2-aad1-42b6-a319-9c17d82817a5','fc6726f2-aad1-42b6-a319-9c17d82817a5','1bcf3990c34341488ff134d67569a00c','a942627ec05749c09a975132ee6031d6',2,'tempest-tempest-created-share-851576944','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-10-01 17:04:11.669277','2025-10-01 17:04:19.489789','2025-10-01 17:04:19.489225','fc846882-1107-4676-be65-b94d6f4b1d3c','fc846882-1107-4676-be65-b94d6f4b1d3c','215059d06b1f437a84c98c525318fc71','d7270bd14938443caacbacdbd21d7c3b',1,'tempest-tempest-share-name-1338844091','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL);
/*!40000 ALTER TABLE `shares` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `resource_id` varchar(36) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime(6) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
INSERT INTO `transfers` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `resource_id`, `resource_type`, `display_name`, `salt`, `crypt_hash`, `expires_at`, `source_project_id`, `destination_project_id`, `accepted`) VALUES ('0f39c667-c6e6-414c-9bcf-4d3d45c86b0e','2025-10-01 17:05:02.020025',NULL,'2025-10-01 17:05:02.339757','0f39c667-c6e6-414c-9bcf-4d3d45c86b0e','1acdbdc9-61a5-46ac-b58b-9424aac4ae8f','share','tempest-tempest-created-share-transfer-776899982','4ed867c8','5ab86962b6162cd886994dd4a8b111aa322c2f26e5a4b1f7d7b4f896282b916a','2025-10-01 17:10:02.019100','23b43441437342609cce9f7f9d4d5521',NULL,0),('55ae65a1-966d-42b6-9b2c-f1bacc23a7c0','2025-10-01 17:05:16.571870',NULL,'2025-10-01 17:05:16.875110','55ae65a1-966d-42b6-9b2c-f1bacc23a7c0','adc0f55f-5d3c-4033-b10d-5429864a3bdf','share','tempest-tempest-created-share-transfer-2067788342','7ddd100e','88287d14a30c8f6e1f4a51510ae8363621ec815fe5f0a26c30356c8cce532d85','2025-10-01 17:10:16.569400','23b43441437342609cce9f7f9d4d5521',NULL,0),('8eba3163-b13e-4530-b143-d036c714c0cd','2025-10-01 17:04:57.665595',NULL,'2025-10-01 17:04:58.174224','8eba3163-b13e-4530-b143-d036c714c0cd','05cc2137-ef64-49b8-991a-bfecfb50f6d0','share','tempest-tempest-created-share-transfer-1758233065','e9bf306f','1998b088dadaf2b6797ac53d8b6cb0087504d77c01a4772132fc01c03a172fb5','2025-10-01 17:09:57.664248','23b43441437342609cce9f7f9d4d5521',NULL,0),('a4e045e0-e592-4eb6-bf8c-5a4953ccc8ff','2025-10-01 17:04:26.611034',NULL,'2025-10-01 17:04:31.503533','a4e045e0-e592-4eb6-bf8c-5a4953ccc8ff','dfcc8c75-53ab-4ce9-b358-4ac7e2a58279','share','tempest_share_transfer','1d2c8735','e64f3cb76c71ffc26daa8d22a9ddefdb16ed519f7634b6ec0984e19d672374f3','2025-10-01 17:09:26.607372','220545ce6f424d4187770842929567dc',NULL,0),('bf0e7798-54de-4443-8eb5-01ff87705201','2025-10-01 17:04:15.294702','2025-10-01 17:04:18.596502','2025-10-01 17:04:18.596500','1','fc846882-1107-4676-be65-b94d6f4b1d3c','share','tempest-tempest-created-share-transfer-1797041487','bfc95b00','94433f15b2eb27f385f204199198580be0ead4d741a392f564b01007543038df','2025-10-01 17:09:15.292991','220545ce6f424d4187770842929567dc','d7270bd14938443caacbacdbd21d7c3b',1),('e7d22752-2702-4fee-b841-0a5ca0597b4b','2025-10-01 17:05:09.459206',NULL,'2025-10-01 17:05:09.834567','e7d22752-2702-4fee-b841-0a5ca0597b4b','f5032ae4-40d3-4416-b119-b7df6be88a0b','share','tempest-tempest-created-share-transfer-1854610153','bafadcf4','de7bb8e31c5201fadba93138f55cfb0170387244ac83403c8b6171028d1ca0ec','2025-10-01 17:10:09.454000','23b43441437342609cce9f7f9d4d5521',NULL,0);
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `mysql`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `mysql` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;

USE `mysql`;

--
-- Table structure for table `general_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `general_log` (
  `event_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `command_type` varchar(64) NOT NULL,
  `argument` mediumtext NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='General log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slow_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `slow_log` (
  `start_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `query_time` time(6) NOT NULL,
  `lock_time` time(6) NOT NULL,
  `rows_sent` bigint(20) unsigned NOT NULL,
  `rows_examined` bigint(20) unsigned NOT NULL,
  `db` varchar(512) NOT NULL,
  `last_insert_id` int(11) NOT NULL,
  `insert_id` int(11) NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `sql_text` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `rows_affected` bigint(20) unsigned NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Slow log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `column_stats`
--

DROP TABLE IF EXISTS `column_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `column_stats` (
  `db_name` varchar(64) NOT NULL,
  `table_name` varchar(64) NOT NULL,
  `column_name` varchar(64) NOT NULL,
  `min_value` varbinary(255) DEFAULT NULL,
  `max_value` varbinary(255) DEFAULT NULL,
  `nulls_ratio` decimal(12,4) DEFAULT NULL,
  `avg_length` decimal(12,4) DEFAULT NULL,
  `avg_frequency` decimal(12,4) DEFAULT NULL,
  `hist_size` tinyint(3) unsigned DEFAULT NULL,
  `hist_type` enum('SINGLE_PREC_HB','DOUBLE_PREC_HB') DEFAULT NULL,
  `histogram` varbinary(255) DEFAULT NULL,
  PRIMARY KEY (`db_name`,`table_name`,`column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='Statistics on Columns';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `column_stats`
--

LOCK TABLES `column_stats` WRITE;
/*!40000 ALTER TABLE `column_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `column_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `columns_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Table_name` char(64) NOT NULL DEFAULT '',
  `Column_name` char(64) NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `db` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_history_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT INTO `db` (`Host`, `Db`, `User`, `Select_priv`, `Insert_priv`, `Update_priv`, `Delete_priv`, `Create_priv`, `Drop_priv`, `Grant_priv`, `References_priv`, `Index_priv`, `Alter_priv`, `Create_tmp_table_priv`, `Lock_tables_priv`, `Create_view_priv`, `Show_view_priv`, `Create_routine_priv`, `Alter_routine_priv`, `Execute_priv`, `Event_priv`, `Trigger_priv`, `Delete_history_priv`) VALUES ('localhost','glance','glance_8220','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','glance','glance_8220','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','keystone','keystone_9a9c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','keystone','keystone_9a9c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','placement','placement_3be7','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','placement','placement_3be7','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','cinder','cinder_a401','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','cinder','cinder_a401','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','barbican','barbican_aee5','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','barbican','barbican_aee5','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','neutron','neutron_1d44','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','neutron','neutron_1d44','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_cell0','nova_cell0_9ed4','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_cell0','nova_cell0_9ed4','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_api','nova_api_af0f','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_api','nova_api_af0f','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','manila','manila_5680','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','manila','manila_5680','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` char(141) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','IGNORE_BAD_TABLE_OPTIONS','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH','EMPTY_STRING_IS_NULL','SIMULTANEOUS_ASSIGNMENT','TIME_ROUND_FRACTIONAL') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob DEFAULT NULL,
  PRIMARY KEY (`db`,`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `func` (
  `name` char(64) NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT 0,
  `dl` char(128) NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `global_priv`
--

DROP TABLE IF EXISTS `global_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Priv` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '{}' CHECK (json_valid(`Priv`)),
  PRIMARY KEY (`Host`,`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_priv`
--

LOCK TABLES `global_priv` WRITE;
/*!40000 ALTER TABLE `global_priv` DISABLE KEYS */;
INSERT INTO `global_priv` (`Host`, `User`, `Priv`) VALUES ('localhost','mariadb.sys','{\"access\":0,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"\",\"account_locked\":true,\"password_last_changed\":0}'),('localhost','root','{\"access\": 549755813887, \"plugin\": \"mysql_native_password\", \"authentication_string\": \"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\", \"auth_or\": [{}],\"version_id\":100529,\"password_last_changed\":1759335453}'),('%','root','{\"access\":549755813887,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\",\"password_last_changed\":1759335453}'),('localhost','glance_8220','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*C72D651D97A3D36C1010EE02F9592BBF0EA9EF0A\",\"password_last_changed\":1759335488}'),('%','glance_8220','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*C72D651D97A3D36C1010EE02F9592BBF0EA9EF0A\",\"password_last_changed\":1759335488}'),('localhost','keystone_9a9c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*EA67143001617046A3AD8BF920DE1D843E7E24AF\",\"password_last_changed\":1759335493}'),('%','keystone_9a9c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*EA67143001617046A3AD8BF920DE1D843E7E24AF\",\"password_last_changed\":1759335493}'),('localhost','placement_3be7','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*4F5BC6238F0CA40D04A8A3CA0457D415D1432600\",\"password_last_changed\":1759335493}'),('%','placement_3be7','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*4F5BC6238F0CA40D04A8A3CA0457D415D1432600\",\"password_last_changed\":1759335493}'),('localhost','cinder_a401','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*44DADB3ED8A7260141434CE83536AC20E4EC176C\",\"password_last_changed\":1759335541}'),('%','cinder_a401','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*44DADB3ED8A7260141434CE83536AC20E4EC176C\",\"password_last_changed\":1759335541}'),('localhost','barbican_aee5','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*730192C532CA49C43756D7534E99DDF373EF767B\",\"password_last_changed\":1759335542}'),('%','barbican_aee5','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*730192C532CA49C43756D7534E99DDF373EF767B\",\"password_last_changed\":1759335542}'),('localhost','neutron_1d44','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*28BBE778FA398A07773D3EA50A2C4C9468BAF434\",\"password_last_changed\":1759335542}'),('%','neutron_1d44','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*28BBE778FA398A07773D3EA50A2C4C9468BAF434\",\"password_last_changed\":1759335542}'),('localhost','nova_cell0_9ed4','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*0A028DF1BF7608E5302E0D0C5240F33CB5529BEB\",\"password_last_changed\":1759335634}'),('%','nova_cell0_9ed4','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*0A028DF1BF7608E5302E0D0C5240F33CB5529BEB\",\"password_last_changed\":1759335634}'),('localhost','nova_api_af0f','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*356B18C510D883E6306F85A42C6048B38D20A405\",\"password_last_changed\":1759335650}'),('%','nova_api_af0f','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*356B18C510D883E6306F85A42C6048B38D20A405\",\"password_last_changed\":1759335650}'),('localhost','manila_5680','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*6AD57129DC2407D724292D9A9FE7B95F252CF133\",\"password_last_changed\":1759337694}'),('%','manila_5680','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*6AD57129DC2407D724292D9A9FE7B95F252CF133\",\"password_last_changed\":1759337694}');
/*!40000 ALTER TABLE `global_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gtid_slave_pos`
--

DROP TABLE IF EXISTS `gtid_slave_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gtid_slave_pos` (
  `domain_id` int(10) unsigned NOT NULL,
  `sub_id` bigint(20) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `seq_no` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`domain_id`,`sub_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Replication slave GTID position';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gtid_slave_pos`
--

LOCK TABLES `gtid_slave_pos` WRITE;
/*!40000 ALTER TABLE `gtid_slave_pos` DISABLE KEYS */;
/*!40000 ALTER TABLE `gtid_slave_pos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT INTO `help_category` (`help_category_id`, `name`, `parent_category_id`, `url`) VALUES (1,'Contents',0,''),(2,'Polygon Properties',34,''),(3,'WKT',34,''),(4,'Numeric Functions',37,''),(5,'Plugins',1,''),(6,'MBR',34,''),(7,'Control Flow Functions',37,''),(8,'Transactions',1,''),(9,'Help Metadata',1,''),(10,'Account Management',1,''),(11,'Point Properties',34,''),(12,'Encryption Functions',37,''),(13,'LineString Properties',34,''),(14,'Miscellaneous Functions',37,''),(15,'Logical Operators',47,''),(16,'Functions and Modifiers for Use with GROUP BY',1,''),(17,'Information Functions',37,''),(18,'Assignment Operators',47,''),(19,'Comparison Operators',47,''),(20,'Bit Functions',37,''),(21,'Table Maintenance',1,''),(22,'User-Defined Functions',1,''),(23,'Data Types',1,''),(24,'Compound Statements',1,''),(25,'Geometry Constructors',34,''),(26,'Administration',1,''),(27,'Data Manipulation',1,''),(28,'Utility',1,''),(29,'Language Structure',1,''),(30,'Geometry Relations',34,''),(31,'Date and Time Functions',37,''),(32,'WKB',34,''),(33,'Procedures',1,''),(34,'Geographic Features',1,''),(35,'Geometry Properties',34,''),(36,'String Functions',37,''),(37,'Functions',1,''),(38,'Data Definition',1,''),(39,'Sequences',1,''),(40,'JSON Functions',37,''),(41,'Window Functions',37,''),(42,'Spider Functions',37,''),(43,'Dynamic Column Functions',37,''),(44,'Galera Functions',37,''),(45,'Temporal Tables',1,''),(46,'GeoJSON',34,''),(47,'Operators',1,''),(48,'Arithmetic Operators',47,''),(49,'Replication',1,''),(50,'Prepared Statements',1,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT INTO `help_keyword` (`help_keyword_id`, `name`) VALUES (1,'work'),(2,'locks'),(3,'locking'),(4,'drop'),(5,'super'),(6,'usage'),(7,'binlog admin'),(8,'binlog monitor'),(9,'binlog replay'),(10,'connection admin'),(11,'federated admin'),(12,'grant option'),(13,'read_only admin'),(14,'replica monitor'),(15,'replication replica'),(16,'roles'),(17,'values'),(18,'value'),(19,'not'),(20,'and'),(21,'or'),(22,':='),(23,'assignment operator'),(24,'='),(25,'!='),(26,'<>'),(27,'not equal'),(28,'less than'),(29,'less than or equal'),(30,'NULL-safe equal'),(31,'equal'),(32,'greater than'),(33,'greater than or equal'),(34,'bitwise and'),(35,'shift left'),(36,'shift right'),(37,'bitwise xor'),(38,'bitwise or'),(39,'bitwise not'),(40,'returns'),(41,'udfs'),(42,'udf calling sequences'),(43,'udf security'),(44,'int1'),(45,'int2'),(46,'int3'),(47,'integer'),(48,'int4'),(49,'int8'),(50,'dec'),(51,'numeric'),(52,'fixed'),(53,'number'),(54,'real'),(55,'double precision'),(56,'nchar'),(57,'long'),(58,'long varchar'),(59,'repeat'),(60,'declare'),(61,'cursor'),(62,'show'),(63,'columns'),(64,'kill connection'),(65,'kill query'),(66,'delete returning'),(67,'sql_big_result'),(68,'minus'),(69,'cte'),(70,'insert returning'),(71,'queries'),(72,'query'),(73,'explain format'),(74,'explain format json'),(75,'rlike'),(76,'character_length'),(77,'escape'),(78,'mode'),(79,'trim_oracle'),(80,'schedule'),(81,'row_format'),(82,'starts'),(83,'host'),(84,'generated columns'),(85,'virtual columns'),(86,'computed columns'),(87,'hidden columns'),(88,'nextval'),(89,'lastval'),(90,'+'),(91,'addition operator'),(92,'/'),(93,'division operator'),(94,'%'),(95,'modulo operator'),(96,'*'),(97,'multiplication operator'),(98,'-'),(99,'subtraction operator'),(100,'master_ssl_verify_cert'),(101,'start replica'),(102,'stop replica'),(103,'reset slave'),(104,'reset replica'),(105,'drop prepare'),(106,'deallocate prepare');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`),
  KEY `help_topic_id` (`help_topic_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT INTO `help_relation` (`help_topic_id`, `help_keyword_id`) VALUES (94,1),(97,2),(99,2),(101,2),(116,2),(147,2),(152,2),(157,2),(161,2),(162,2),(338,2),(438,2),(97,3),(99,3),(101,3),(116,3),(147,3),(152,3),(157,3),(161,3),(162,3),(338,3),(438,3),(106,4),(112,4),(250,4),(687,4),(697,4),(713,4),(714,4),(715,4),(716,4),(717,4),(718,4),(719,4),(720,4),(722,4),(723,4),(731,4),(107,5),(107,6),(107,7),(107,8),(107,9),(107,10),(107,11),(107,12),(107,13),(107,14),(107,15),(115,16),(166,17),(166,18),(167,19),(168,20),(170,21),(210,22),(210,23),(211,23),(211,24),(212,25),(212,26),(212,27),(213,28),(214,29),(215,30),(216,31),(217,32),(218,33),(232,34),(233,35),(234,36),(236,37),(237,38),(238,39),(249,40),(251,41),(252,42),(253,43),(255,44),(257,45),(258,46),(259,47),(259,48),(260,49),(261,50),(261,51),(261,52),(261,53),(263,54),(263,55),(269,56),(275,57),(275,58),(304,59),(664,59),(311,60),(311,61),(331,62),(332,62),(333,62),(334,62),(335,62),(342,62),(343,62),(344,62),(345,62),(346,62),(347,62),(354,62),(356,62),(357,62),(358,62),(359,62),(360,62),(361,62),(362,62),(363,62),(364,62),(365,62),(366,62),(367,62),(368,62),(369,62),(370,62),(371,62),(372,62),(373,62),(374,62),(375,62),(376,62),(377,62),(378,62),(379,62),(380,62),(381,62),(382,62),(383,62),(384,62),(385,62),(386,62),(387,62),(388,62),(389,62),(390,62),(391,62),(392,62),(393,62),(394,62),(395,62),(396,62),(397,62),(398,62),(408,62),(409,62),(333,63),(403,64),(403,65),(410,66),(414,67),(425,68),(431,69),(432,69),(433,69),(453,70),(460,71),(460,72),(466,73),(466,74),(622,75),(632,76),(651,77),(657,78),(678,79),(689,80),(696,81),(701,82),(707,83),(711,84),(711,85),(711,86),(712,87),(732,88),(733,89),(804,90),(804,91),(805,92),(805,93),(806,94),(806,95),(807,96),(807,97),(808,98),(808,99),(809,100),(810,101),(811,102),(812,103),(812,104),(816,105),(816,106);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
INSERT INTO `help_topic` (`help_topic_id`, `name`, `help_category_id`, `description`, `example`, `url`) VALUES (1,'HELP_DATE',9,'Help Contents generated from the MariaDB Knowledge Base on 23 January 2023.','',''),(2,'HELP_VERSION',9,'Help Contents generated for MariaDB 10.5 from the MariaDB Knowledge Base on 23 January 2023.','',''),(3,'AREA',2,'A synonym for ST_AREA.\n\nURL: https://mariadb.com/kb/en/polygon-properties-area/','','https://mariadb.com/kb/en/polygon-properties-area/'),(4,'CENTROID',2,'A synonym for ST_CENTROID.\n\nURL: https://mariadb.com/kb/en/centroid/','','https://mariadb.com/kb/en/centroid/'),(5,'ExteriorRing',2,'A synonym for ST_ExteriorRing.\n\nURL: https://mariadb.com/kb/en/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/polygon-properties-exteriorring/'),(6,'InteriorRingN',2,'A synonym for ST_InteriorRingN.\n\nURL: https://mariadb.com/kb/en/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/polygon-properties-interiorringn/'),(7,'NumInteriorRings',2,'A synonym for ST_NumInteriorRings.\n\nURL: https://mariadb.com/kb/en/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/polygon-properties-numinteriorrings/'),(8,'ST_AREA',2,'Syntax\n------\n\nST_Area(poly)\nArea(poly)\n\nDescription\n-----------\n\nReturns as a double-precision number the area of the Polygon value poly, as\nmeasured in its spatial reference system.\n\nST_Area() and Area() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\n\nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/st_area/','','https://mariadb.com/kb/en/st_area/'),(9,'ST_CENTROID',2,'Syntax\n------\n\nST_Centroid(mpoly)\nCentroid(mpoly)\n\nDescription\n-----------\n\nReturns a point reflecting the mathematical centroid (geometric center) for\nthe MultiPolygon mpoly. The resulting point will not necessarily be on the\nMultiPolygon.\n\nST_Centroid() and Centroid() are synonyms.\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0 0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n+--------------+\n| center       |\n+--------------+\n| POINT(10 10) |\n+--------------+\n\nURL: https://mariadb.com/kb/en/st_centroid/','','https://mariadb.com/kb/en/st_centroid/'),(10,'ST_ExteriorRing',2,'Syntax\n------\n\nST_ExteriorRing(poly)\nExteriorRing(poly)\n\nDescription\n-----------\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() and ExteriorRing() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_exteriorring/','','https://mariadb.com/kb/en/st_exteriorring/'),(11,'ST_InteriorRingN',2,'Syntax\n------\n\nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n\nDescription\n-----------\n\nReturns the N-th interior ring for the Polygon value poly as a LineString.\nRings are numbered beginning with 1.\n\nST_InteriorRingN() and InteriorRingN() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_interiorringn/','','https://mariadb.com/kb/en/st_interiorringn/'),(12,'ST_NumInteriorRings',2,'Syntax\n------\n\nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n\nDescription\n-----------\n\nReturns an integer containing the number of interior rings in the Polygon\nvalue poly.\n\nNote that according the the OpenGIS standard, a POLYGON should have exactly\none ExteriorRing and all other rings should lie within that ExteriorRing and\nthus be the InteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several \'ExteriorRings\'. In the case of\nthere being multiple, non-overlapping exterior rings ST_NumInteriorRings()\nwill return 1.\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/st_numinteriorrings/','','https://mariadb.com/kb/en/st_numinteriorrings/'),(14,'AsText',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-astext/','','https://mariadb.com/kb/en/wkt-astext/'),(15,'AsWKT',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-aswkt/','','https://mariadb.com/kb/en/wkt-aswkt/'),(16,'GeomCollFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/wkt-geomcollfromtext/'),(17,'GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromtext/','','https://mariadb.com/kb/en/geometrycollectionfromtext/'),(18,'GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/geometryfromtext/','','https://mariadb.com/kb/en/geometryfromtext/'),(19,'GeomFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomfromtext/','','https://mariadb.com/kb/en/wkt-geomfromtext/'),(20,'LineFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/wkt-linefromtext/','','https://mariadb.com/kb/en/wkt-linefromtext/'),(21,'LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/linestringfromtext/','','https://mariadb.com/kb/en/linestringfromtext/'),(22,'MLineFromText',3,'Syntax\n------\n\nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n\nMLineFromText() and MultiLineStringFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\nINSERT INTO gis_multi_line VALUES\n  (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16\n23,16 48))\')),\n  (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n  (MLineFromWKB(AsWKB(MultiLineString(\n   LineString(Point(1, 2), Point(3, 5)),\n   LineString(Point(2, 5), Point(5, 8), Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/mlinefromtext/','','https://mariadb.com/kb/en/mlinefromtext/'),(23,'MPointFromText',3,'Syntax\n------\n\nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nMPointFromText() and MultiPointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/mpointfromtext/','','https://mariadb.com/kb/en/mpointfromtext/'),(13,'WKT Definition',3,'Description\n-----------\n\nThe Well-Known Text (WKT) representation of Geometry is designed to exchange\ngeometry data in ASCII form. Examples of the basic geometry types include:\n\n+-----------------------------------------------------------------------------+\n| Geometry Types                                                              |\n+-----------------------------------------------------------------------------+\n| POINT                                                                       |\n+-----------------------------------------------------------------------------+\n| LINESTRING                                                                  |\n+-----------------------------------------------------------------------------+\n| POLYGON                                                                     |\n+-----------------------------------------------------------------------------+\n| MULTIPOINT                                                                  |\n+-----------------------------------------------------------------------------+\n| MULTILINESTRING                                                             |\n+-----------------------------------------------------------------------------+\n| MULTIPOLYGON                                                                |\n+-----------------------------------------------------------------------------+\n| GEOMETRYCOLLECTION                                                          |\n+-----------------------------------------------------------------------------+\n| GEOMETRY                                                                    |\n+-----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/wkt-definition/','','https://mariadb.com/kb/en/wkt-definition/'),(24,'MPolyFromText',3,'Syntax\n------\n\nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nMPolyFromText() and MultiPolygonFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(\n   LineString(Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/mpolyfromtext/','','https://mariadb.com/kb/en/mpolyfromtext/'),(25,'MultiLineStringFromText',3,'A synonym for MLineFromText.\n\nURL: https://mariadb.com/kb/en/multilinestringfromtext/','','https://mariadb.com/kb/en/multilinestringfromtext/'),(26,'MultiPointFromText',3,'A synonym for MPointFromText.\n\nURL: https://mariadb.com/kb/en/multipointfromtext/','','https://mariadb.com/kb/en/multipointfromtext/'),(27,'MultiPolygonFromText',3,'A synonym for MPolyFromText.\n\nURL: https://mariadb.com/kb/en/multipolygonfromtext/','','https://mariadb.com/kb/en/multipolygonfromtext/'),(28,'PointFromText',3,'A synonym for ST_PointFromText.\n\nURL: https://mariadb.com/kb/en/wkt-pointfromtext/','','https://mariadb.com/kb/en/wkt-pointfromtext/'),(29,'PolyFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/wkt-polyfromtext/','','https://mariadb.com/kb/en/wkt-polyfromtext/'),(30,'PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/polygonfromtext/','','https://mariadb.com/kb/en/polygonfromtext/'),(31,'ST_AsText',3,'Syntax\n------\n\nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKT representation and\nreturns the string result.\n\nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all synonyms.\n\nExamples\n--------\n\nSET @g = \'LineString(1 1,4 4,6 6)\';\n\nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6)        |\n+--------------------------------+\n\nURL: https://mariadb.com/kb/en/st_astext/','','https://mariadb.com/kb/en/st_astext/'),(32,'ST_ASWKT',3,'A synonym for ST_ASTEXT().\n\nURL: https://mariadb.com/kb/en/st_aswkt/','','https://mariadb.com/kb/en/st_aswkt/'),(33,'ST_GeomCollFromText',3,'Syntax\n------\n\nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(), GeomCollFromText() and\nGeometryCollectionFromText() are all synonyms.\n\nExample\n-------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/st_geomcollfromtext/','','https://mariadb.com/kb/en/st_geomcollfromtext/'),(34,'ST_GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/st_geometrycollectionfromtext/'),(35,'ST_GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/st_geometryfromtext/','','https://mariadb.com/kb/en/st_geometryfromtext/'),(36,'ST_GeomFromText',3,'Syntax\n------\n\nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKT representation and SRID.\n\nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n\nExample\n-------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nURL: https://mariadb.com/kb/en/st_geomfromtext/','','https://mariadb.com/kb/en/st_geomfromtext/'),(37,'ST_LineFromText',3,'Syntax\n------\n\nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nST_LineFromText(), ST_LineStringFromText(), ST_LineFromText() and\nST_LineStringFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_line  (g LINESTRING);\nSHOW FIELDS FROM gis_line;\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/st_linefromtext/','','https://mariadb.com/kb/en/st_linefromtext/'),(38,'ST_LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/st_linestringfromtext/','','https://mariadb.com/kb/en/st_linestringfromtext/'),(39,'ST_PointFromText',3,'Syntax\n------\n\nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKT representation and SRID.\n\nST_PointFromText() and PointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_point  (g POINT);\nSHOW FIELDS FROM gis_point;\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/st_pointfromtext/','','https://mariadb.com/kb/en/st_pointfromtext/'),(40,'ST_PolyFromText',3,'Syntax\n------\n\nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\'));\n\nURL: https://mariadb.com/kb/en/st_polyfromtext/','','https://mariadb.com/kb/en/st_polyfromtext/'),(41,'ST_PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/st_polygonfromtext/','','https://mariadb.com/kb/en/st_polygonfromtext/'),(42,'DIV',4,'Syntax\n------\n\nDIV\n\nDescription\n-----------\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for non-integer operands that exceed BIGINT range.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a division by zero produces\nan error. Otherwise, it returns NULL.\n\nThe remainder of a division can be obtained using the MOD operator.\n\nExamples\n--------\n\nSELECT 300 DIV 7;\n+-----------+\n| 300 DIV 7 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT 300 DIV 0;\n+-----------+\n| 300 DIV 0 |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/div/','','https://mariadb.com/kb/en/div/'),(43,'ABS',4,'Syntax\n------\n\nABS(X)\n\nDescription\n-----------\n\nReturns the absolute (non-negative) value of X. If X is not a number, it is\nconverted to a numeric type.\n\nExamples\n--------\n\nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n|      42 |\n+---------+\n\nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n|       42 |\n+----------+\n\nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n|               19940101 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/abs/','','https://mariadb.com/kb/en/abs/'),(44,'ACOS',4,'Syntax\n------\n\nACOS(X)\n\nDescription\n-----------\n\nReturns the arc cosine of X, that is, the value whose cosine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n|         NULL |\n+--------------+\n\nSELECT ACOS(0);\n+-----------------+\n| ACOS(0)         |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234)      |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/acos/','','https://mariadb.com/kb/en/acos/'),(45,'ASIN',4,'Syntax\n------\n\nASIN(X)\n\nDescription\n-----------\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns NULL if\nX is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2)          |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n\nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n\nSHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n\nURL: https://mariadb.com/kb/en/asin/','','https://mariadb.com/kb/en/asin/'),(46,'ATAN',4,'Syntax\n------\n\nATAN(X)\n\nDescription\n-----------\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nExamples\n--------\n\nSELECT ATAN(2);\n+--------------------+\n| ATAN(2)            |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n\nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2)            |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/atan/','','https://mariadb.com/kb/en/atan/'),(47,'ATAN2',4,'Syntax\n------\n\nATAN(Y,X), ATAN2(Y,X)\n\nDescription\n-----------\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both arguments\nare used to determine the quadrant of the result.\n\nExamples\n--------\n\nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2)          |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n\nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0)      |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/atan2/','','https://mariadb.com/kb/en/atan2/'),(48,'CEIL',4,'Syntax\n------\n\nCEIL(X)\n\nDescription\n-----------\n\nCEIL() is a synonym for CEILING().\n\nURL: https://mariadb.com/kb/en/ceil/','','https://mariadb.com/kb/en/ceil/'),(49,'CEILING',4,'Syntax\n------\n\nCEILING(X)\n\nDescription\n-----------\n\nReturns the smallest integer value not less than X.\n\nExamples\n--------\n\nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n|             -1 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/ceiling/','','https://mariadb.com/kb/en/ceiling/'),(51,'COS',4,'Syntax\n------\n\nCOS(X)\n\nDescription\n-----------\n\nReturns the cosine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n|        -1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/cos/','','https://mariadb.com/kb/en/cos/'),(52,'COT',4,'Syntax\n------\n\nCOT(X)\n\nDescription\n-----------\n\nReturns the cotangent of X.\n\nExamples\n--------\n\nSELECT COT(42);\n+--------------------+\n| COT(42)            |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n\nSELECT COT(12);\n+---------------------+\n| COT(12)             |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n\nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in \'cot(0)\'\n\nURL: https://mariadb.com/kb/en/cot/','','https://mariadb.com/kb/en/cot/'),(54,'DEGREES',4,'Syntax\n------\n\nDEGREES(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from radians to degrees.\n\nThis is the converse of the RADIANS() function.\n\nExamples\n--------\n\nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n|           180 |\n+---------------+\n\nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n|                90 |\n+-------------------+\n\nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45)     |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/degrees/','','https://mariadb.com/kb/en/degrees/'),(55,'EXP',4,'Syntax\n------\n\nEXP(X)\n\nDescription\n-----------\n\nReturns the value of e (the base of natural logarithms) raised to the power of\nX. The inverse of this function is LOG() (using a single argument only) or\nLN().\n\nIf X is NULL, this function returns NULL.\n\nExamples\n--------\n\nSELECT EXP(2);\n+------------------+\n| EXP(2)           |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n\nSELECT EXP(-2);\n+--------------------+\n| EXP(-2)            |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n\nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n|      1 |\n+--------+\n\nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/exp/','','https://mariadb.com/kb/en/exp/'),(50,'CONV',4,'Syntax\n------\n\nCONV(N,from_base,to_base)\n\nDescription\n-----------\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base to_base.\n\nReturns NULL if any argument is NULL, or if the second or third argument are\nnot in the allowed range.\n\nThe argument N is interpreted as an integer, but may be specified as an\ninteger or a string. The minimum base is 2 and the maximum base is 36. If\nto_base is a negative number, N is regarded as a signed number. Otherwise, N\nis treated as unsigned. CONV() works with 64-bit precision.\n\nSome shortcuts for this function are also available: BIN(), OCT(), HEX(),\nUNHEX(). Also, MariaDB allows binary literal values and hexadecimal literal\nvalues.\n\nExamples\n--------\n\nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010           |\n+----------------+\n\nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172             |\n+-----------------+\n\nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H               |\n+------------------+\n\nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42                           |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/conv/','','https://mariadb.com/kb/en/conv/'),(53,'CRC32',4,'Syntax\n------\n\n<= MariaDB 10.7\n\nCRC32(expr)\n\nFrom MariaDB 10.8\n\nCRC32([par,]expr)\n\nDescription\n-----------\n\nComputes a cyclic redundancy check (CRC) value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is expected to\nbe a string and (if possible) is treated as one if it is not.\n\nUses the ISO 3309 polynomial that used by zlib and many others. MariaDB 10.8\nintroduced the CRC32C() function, which uses the alternate Castagnoli\npolynomia.\n\nMariaDB starting with 10.8\n--------------------------\nOften, CRC is computed in pieces. To facilitate this, MariaDB 10.8.0\nintroduced an optional parameter: CRC32(\'MariaDB\')=CRC32(CRC32(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n|       4227209140 |\n+------------------+\n\nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n|       2594253378 |\n+------------------+\n\nFrom MariaDB 10.8.0\n\nSELECT CRC32(CRC32(\'Maria\'),\'DB\');\n+----------------------------+\n| CRC32(CRC32(\'Maria\'),\'DB\') |\n+----------------------------+\n|                 4227209140 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/crc32/','','https://mariadb.com/kb/en/crc32/'),(56,'FLOOR',4,'Syntax\n------\n\nFLOOR(X)\n\nDescription\n-----------\n\nReturns the largest integer value not greater than X.\n\nExamples\n--------\n\nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n|           -2 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/floor/','','https://mariadb.com/kb/en/floor/'),(57,'LN',4,'Syntax\n------\n\nLN(X)\n\nDescription\n-----------\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X. If X\nis less than or equal to 0, or NULL, then NULL is returned.\n\nThe inverse of this function is EXP().\n\nExamples\n--------\n\nSELECT LN(2);\n+-------------------+\n| LN(2)             |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n|   NULL |\n+--------+\n\nURL: https://mariadb.com/kb/en/ln/','','https://mariadb.com/kb/en/ln/'),(58,'LOG',4,'Syntax\n------\n\nLOG(X), LOG(B,X)\n\nDescription\n-----------\n\nIf called with one parameter, this function returns the natural logarithm of\nX. If X is less than or equal to 0, then NULL is returned.\n\nIf called with two parameters, it returns the logarithm of X to the base B. If\nB is <= 1 or X <= 0, the function returns NULL.\n\nIf any argument is NULL, the function returns NULL.\n\nThe inverse of this function (when called with a single argument) is the EXP()\nfunction.\n\nExamples\n--------\n\nLOG(X):\n\nSELECT LOG(2);\n+-------------------+\n| LOG(2)            |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LOG(-2);\n+---------+\n| LOG(-2) |\n+---------+\n|    NULL |\n+---------+\n\nLOG(B,X)\n\nSELECT LOG(2,16);\n+-----------+\n| LOG(2,16) |\n+-----------+\n|         4 |\n+-----------+\n\nSELECT LOG(3,27);\n+-----------+\n| LOG(3,27) |\n+-----------+\n|         3 |\n+-----------+\n\nSELECT LOG(3,1);\n+----------+\n| LOG(3,1) |\n+----------+\n|        0 |\n+----------+\n\nSELECT LOG(3,0);\n+----------+\n| LOG(3,0) |\n+----------+\n|     NULL |\n+----------+\n\nURL: https://mariadb.com/kb/en/log/','','https://mariadb.com/kb/en/log/'),(59,'LOG10',4,'Syntax\n------\n\nLOG10(X)\n\nDescription\n-----------\n\nReturns the base-10 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG10(2);\n+-------------------+\n| LOG10(2)          |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n\nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n|          2 |\n+------------+\n\nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/log10/','','https://mariadb.com/kb/en/log10/'),(60,'LOG2',4,'Syntax\n------\n\nLOG2(X)\n\nDescription\n-----------\n\nReturns the base-2 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n|                  42 |\n+---------------------+\n\nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n|          16 |\n+-------------+\n\nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n|       NULL |\n+------------+\n\nURL: https://mariadb.com/kb/en/log2/','','https://mariadb.com/kb/en/log2/'),(62,'OCT',4,'Syntax\n------\n\nOCT(N)\n\nDescription\n-----------\n\nReturns a string representation of the octal value of N, where N is a longlong\n(BIGINT) number. This is equivalent to CONV(N,10,8). Returns NULL if N is NULL.\n\nExamples\n--------\n\nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42      |\n+---------+\n\nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14      |\n+---------+\n\nURL: https://mariadb.com/kb/en/oct/','','https://mariadb.com/kb/en/oct/'),(63,'PI',4,'Syntax\n------\n\nPI()\n\nDescription\n-----------\n\nReturns the value of π (pi). The default number of decimal places displayed is\nsix, but MariaDB uses the full double-precision value internally.\n\nExamples\n--------\n\nSELECT PI();\n+----------+\n| PI()     |\n+----------+\n| 3.141593 |\n+----------+\n\nSELECT PI()+0.0000000000000000000000;\n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n|      3.1415926535897931159980 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/pi/','','https://mariadb.com/kb/en/pi/'),(64,'POW',4,'Syntax\n------\n\nPOW(X,Y)\n\nDescription\n-----------\n\nReturns the value of X raised to the power of Y.\n\nPOWER() is a synonym.\n\nExamples\n--------\n\nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n|        8 |\n+----------+\n\nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n|      0.25 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/pow/','','https://mariadb.com/kb/en/pow/'),(65,'POWER',4,'Syntax\n------\n\nPOWER(X,Y)\n\nDescription\n-----------\n\nThis is a synonym for POW(), which returns the value of X raised to the power\nof Y.\n\nURL: https://mariadb.com/kb/en/power/','','https://mariadb.com/kb/en/power/'),(61,'MOD',4,'Syntax\n------\n\nMOD(N,M), N % M, N MOD M\n\nDescription\n-----------\n\nModulo operation. Returns the remainder of N divided by M. See also Modulo\nOperator.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any number modulus zero\nproduces an error. Otherwise, it returns NULL.\n\nThe integer part of a division can be obtained using DIV.\n\nExamples\n--------\n\nSELECT 1042 % 50;\n+-----------+\n| 1042 % 50 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n|            4 |\n+--------------+\n\nSELECT 253 % 7;\n+---------+\n| 253 % 7 |\n+---------+\n|       1 |\n+---------+\n\nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n|         2 |\n+-----------+\n\nSELECT 29 MOD 9;\n+----------+\n| 29 MOD 9 |\n+----------+\n|        2 |\n+----------+\n\nURL: https://mariadb.com/kb/en/mod/','','https://mariadb.com/kb/en/mod/'),(66,'RADIANS',4,'Syntax\n------\n\nRADIANS(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from degrees to radians. Note that π radians\nequals 180 degrees.\n\nThis is the converse of the DEGREES() function.\n\nExamples\n--------\n\nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45)       |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n\nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90)     |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI())      |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n\nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180)     |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/radians/','','https://mariadb.com/kb/en/radians/'),(67,'RAND',4,'Syntax\n------\n\nRAND(), RAND(N)\n\nDescription\n-----------\n\nReturns a random DOUBLE precision floating point value v in the range 0 <= v <\n1.0. If a constant integer argument N is specified, it is used as the seed\nvalue, which produces a repeatable sequence of column values. In the example\nbelow, note that the sequences of values produced by RAND(3) is the same both\nplaces where it occurs.\n\nIn a WHERE clause, RAND() is evaluated each time the WHERE is executed.\n\nStatements using the RAND() function are not safe for statement-based\nreplication.\n\nPractical uses\n--------------\n\nThe expression to get a random integer from a given range is the following:\n\nFLOOR(min_value + RAND() * (max_value - min_value +1))\n\nRAND() is often used to read random rows from a table, as follows:\n\nSELECT * FROM my_table ORDER BY RAND() LIMIT 10;\n\nNote, however, that this technique should never be used on a large table as it\nwill be extremely slow. MariaDB will read all rows in the table, generate a\nrandom value for each of them, order them, and finally will apply the LIMIT\nclause.\n\nExamples\n--------\n\nCREATE TABLE t (i INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.255651095188829 |\n|    2 | 0.833920199269355 |\n|    3 |  0.40264774151393 |\n+------+-------------------+\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.511478140495232 |\n|    2 | 0.349447508668012 |\n|    3 | 0.212803152588013 |\n+------+-------------------+\n\nUsing the same seed, the same sequence will be returned:\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nGenerating a random number from 5 to 15:\n\nSELECT FLOOR(5 + (RAND() * 11));\n\nURL: https://mariadb.com/kb/en/rand/','','https://mariadb.com/kb/en/rand/'),(68,'ROUND',4,'Syntax\n------\n\nROUND(X), ROUND(X,D)\n\nDescription\n-----------\n\nRounds the argument X to D decimal places. D defaults to 0 if not specified. D\ncan be negative to cause D digits left of the decimal point of the value X to\nbecome zero.\n\nThe rounding algorithm depends on the data type of X:\n\n* for floating point types (FLOAT, DOUBLE) the C libraries rounding function\nis used, so the behavior *may* differ between operating systems\n* for fixed point types (DECIMAL, DEC/NUMBER/FIXED) the \"round half up\" rule\nis used, meaning that e.g. a value ending in exactly .5 is always rounded up.\n\nExamples\n--------\n\nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n|           -1 |\n+--------------+\n\nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n|           -2 |\n+--------------+\n\nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n|           2 |\n+-------------+\n\nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n|             1.3 |\n+-----------------+\n\nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n|                20 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/round/','','https://mariadb.com/kb/en/round/'),(69,'SIGN',4,'Syntax\n------\n\nSIGN(X)\n\nDescription\n-----------\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X is\nnegative, zero, or positive.\n\nExamples\n--------\n\nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n|        -1 |\n+-----------+\n\nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n|       0 |\n+---------+\n\nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/sign/','','https://mariadb.com/kb/en/sign/'),(70,'SIN',4,'Syntax\n------\n\nSIN(X)\n\nDescription\n-----------\n\nReturns the sine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT SIN(PI());\n+----------------------+\n| SIN(PI())            |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n\nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n|                0 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/sin/','','https://mariadb.com/kb/en/sin/'),(71,'SQRT',4,'Syntax\n------\n\nSQRT(X)\n\nDescription\n-----------\n\nReturns the square root of X. If X is negative, NULL is returned.\n\nExamples\n--------\n\nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n|       2 |\n+---------+\n\nSELECT SQRT(20);\n+------------------+\n| SQRT(20)         |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n\nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n|         42 |\n+------------+\n\nURL: https://mariadb.com/kb/en/sqrt/','','https://mariadb.com/kb/en/sqrt/'),(72,'TAN',4,'Syntax\n------\n\nTAN(X)\n\nDescription\n-----------\n\nReturns the tangent of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n|      0.9999999999999999 |\n+-------------------------+\n\nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI())             |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n\nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1)     |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n\nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/tan/','','https://mariadb.com/kb/en/tan/'),(73,'TRUNCATE',4,'This page documents the TRUNCATE function. See TRUNCATE TABLE for the DDL\nstatement.\n\nSyntax\n------\n\nTRUNCATE(X,D)\n\nDescription\n-----------\n\nReturns the number X, truncated to D decimal places. If D is 0, the result has\nno decimal point or fractional part. D can be negative to cause D digits left\nof the decimal point of the value X to become zero.\n\nExamples\n--------\n\nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n|               1.2 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n|               1.9 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n|               -1.9 |\n+--------------------+\n\nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n|              100 |\n+------------------+\n\nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n|                  1028 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/truncate/','','https://mariadb.com/kb/en/truncate/'),(74,'INSTALL PLUGIN',5,'Syntax\n------\n\nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement installs an individual plugin from the specified library. To\ninstall the whole library (which could be required), use INSTALL SONAME. See\nalso Installing a Plugin.\n\nplugin_name is the name of the plugin as defined in the plugin declaration\nstructure contained in the library file. Plugin names are not case sensitive.\nFor maximal compatibility, plugin names should be limited to ASCII letters,\ndigits, and underscore, because they are used in C source files, shell command\nlines, M4 and Bourne shell scripts, and SQL environments.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension can be omitted (which makes the statement look\nthe same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nINSTALL PLUGIN causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nPLUGIN only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a note instead of\nan error if the specified plugin already exists. See SHOW WARNINGS.\n\nExamples\n--------\n\nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n\nThe extension can also be omitted:\n\nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected (0.104 sec)\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------+\n| Level | Code | Message                            |\n+-------+------+------------------------------------+\n| Note  | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n\nURL: https://mariadb.com/kb/en/install-plugin/','','https://mariadb.com/kb/en/install-plugin/'),(78,'Plugin Overview',5,'Plugins are server components that enhance MariaDB in some way. These can be\nanything from new storage engines, plugins for enhancing full-text parsing, or\neven small enhancements, such as a plugin to get a timestamp as an integer.\n\nQuerying Plugin Information\n---------------------------\n\nThere are a number of ways to see which plugins are currently active.\n\nA server almost always has a large number of active plugins, because the\nserver contains a large number of built-in plugins, which are active by\ndefault and cannot be uninstalled.\n\nQuerying Plugin Information with SHOW PLUGINS\n---------------------------------------------\n\nThe SHOW PLUGINS statement can be used to query information about all active\nplugins.\n\nFor example:\n\nSHOW PLUGINS\\G;\n********************** 1. row **********************\n Name: binlog\n Status: ACTIVE\n Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n********************** 2. row **********************\n Name: mysql_native_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n********************** 3. row **********************\n Name: mysql_old_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n...\n\nIf a plugin\'s Library column has a NULL value, then the plugin is built-in,\nand it cannot be uninstalled.\n\nQuerying Plugin Information with information_schema.PLUGINS\n-----------------------------------------------------------\n\nThe information_schema.PLUGINS table can be queried to get more detailed\ninformation about plugins.\n\nFor example:\n\nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row ***************************\n     PLUGIN_NAME: CSV\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: Brian Aker, MySQL AB\n  PLUGIN_DESCRIPTION: CSV storage engine\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row ***************************\n     PLUGIN_NAME: MEMORY\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: MySQL AB\n  PLUGIN_DESCRIPTION: Hash based, stored in memory, useful for temporary\ntables\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n\nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value, then the plugin is\nbuilt-in, and it cannot be uninstalled.\n\nQuerying Plugin Information with mysql.plugin\n---------------------------------------------\n\nThe mysql.plugin table can be queried to get information about installed\nplugins.\n\nThis table only contains information about plugins that have been installed\nvia the following methods:\n\n* The INSTALL SONAME statement.\n* The INSTALL PLUGIN statement.\n* The mysql_plugin utility.\n\nThis table does not contain information about:\n\n* Built-in plugins.\n* Plugins loaded with the --plugin-load-add option.\n* Plugins loaded with the --plugin-load option.\n\nThis table only contains enough information to reload the plugin when the\nserver is restarted, which means it only contains the plugin name and the\nplugin library.\n\nFor example:\n\nSELECT * FROM mysql.plugin;\n\n+------+------------+\n| name | dl         |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n\nInstalling a Plugin\n-------------------\n\nThere are three primary ways to install a plugin:\n\n* A plugin can be installed dynamically with an SQL statement.\n* A plugin can be installed with a mysqld option, but it requires a server\nrestart.\n* A plugin can be installed with the mysql_plugin utility, while the server is\ncompletely offline.\n\nWhen you are installing a plugin, you also have to ensure that:\n\n* The server\'s plugin directory is properly configured, and the plugin\'s\nlibrary is in the plugin directory.\n* The server\'s minimum plugin maturity is properly configured, and the plugin\nis mature enough to be installed.\n\nInstalling a Plugin Dynamically\n-------------------------------\n\nA plugin can be installed dynamically by executing either the INSTALL SONAME\nor the INSTALL PLUGIN statement.\n\nIf a plugin is installed with one of these statements, then a record will be\nadded to the mysql.plugins table for the plugin. This means that the plugin\nwill automatically be loaded every time the server restarts, unless\nspecifically uninstalled or deactivated.\n\nInstalling a Plugin with INSTALL SONAME\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL SONAME\nstatement. INSTALL SONAME installs all plugins from the given plugin library.\nThis could be required for some plugin libraries.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin), you could execute the\nfollowing:\n\nINSTALL SONAME \'server_audit\';\n\nInstalling a Plugin with INSTALL PLUGIN\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL PLUGIN\nstatement. INSTALL PLUGIN installs a single plugin from the given plugin\nlibrary.\n\nFor example, to install the server_audit audit plugin from the server_audit\nplugin library, you could execute the following:\n\nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n\nInstalling a Plugin with Plugin Load Options\n--------------------------------------------\n\nA plugin can be installed with a mysqld option by providing either the\n--plugin-load-add or the --plugin-load option.\n\nIf a plugin is installed with one of these options, then a record will not be\nadded to the mysql.plugins table for the plugin. This means that if the server\nis restarted without the same option set, then the plugin will not\nautomatically be loaded.\n\nInstalling a Plugin with --plugin-load-add\n------------------------------------------\n\nYou can install a plugin with the --plugin-load-add option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load-add option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nSpecial care must be taken when specifying both the --plugin-load option and\nthe --plugin-load-add option together. The --plugin-load option resets the\nplugin load list, and this can cause unexpected problems if you are not aware.\nThe --plugin-load-add option does not reset the plugin load list, so it is\nmuch safer to use. See Specifying Multiple Plugin Load Options for more\ninformation.\n\nInstalling a Plugin with --plugin-load\n--------------------------------------\n\nYou can install a plugin with the --plugin-load option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load=\'server_audit;ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option together. The --plugin-load option resets the plugin\nload list, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use. See Specifying Multiple Plugin Load Options for more information.\n\nSpecifying Multiple Plugin Load Options\n---------------------------------------\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use.\n\nThis can have the following consequences:\n\n* If the --plugin-load option is specified multiple times, then only the last\ninstance will have any effect. For example, in the following case, the first\ninstance of the option is reset:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* If the --plugin-load option is specified after the --plugin-load-add option,\nthen it will also reset the changes made by that option. For example, in the\nfollowing case, the --plugin-load-add option does not do anything, because the\nsubsequent --plugin-load option resets the plugin load list:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* In contrast, if the --plugin-load option is specified before the\n--plugin-load-add option, then it will work fine, because the\n--plugin-load-add option does not reset the plugin load list. For example, in\nthe following case, both plugins are properly loaded:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nInstalling a Plugin with mysql_plugin\n---------------------------------