/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `aodh`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `aodh` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `aodh`;

--
-- Table structure for table `alarm`
--

DROP TABLE IF EXISTS `alarm`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alarm` (
  `alarm_id` varchar(128) NOT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `name` text DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `severity` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `timestamp` datetime(6) DEFAULT NULL,
  `user_id` varchar(128) DEFAULT NULL,
  `project_id` varchar(128) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `state_reason` text DEFAULT NULL,
  `state_timestamp` datetime(6) DEFAULT NULL,
  `ok_actions` text DEFAULT NULL,
  `alarm_actions` text DEFAULT NULL,
  `insufficient_data_actions` text DEFAULT NULL,
  `repeat_actions` tinyint(1) DEFAULT NULL,
  `rule` text DEFAULT NULL,
  `time_constraints` text DEFAULT NULL,
  `evaluate_timestamp` datetime DEFAULT NULL,
  PRIMARY KEY (`alarm_id`),
  KEY `ix_alarm_type` (`type`),
  KEY `ix_alarm_user_id` (`user_id`),
  KEY `ix_alarm_project_id` (`project_id`),
  KEY `ix_alarm_enabled` (`enabled`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alarm`
--

LOCK TABLES `alarm` WRITE;
/*!40000 ALTER TABLE `alarm` DISABLE KEYS */;
/*!40000 ALTER TABLE `alarm` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alarm_history`
--

DROP TABLE IF EXISTS `alarm_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alarm_history` (
  `event_id` varchar(128) NOT NULL,
  `alarm_id` varchar(128) DEFAULT NULL,
  `on_behalf_of` varchar(128) DEFAULT NULL,
  `project_id` varchar(128) DEFAULT NULL,
  `user_id` varchar(128) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `detail` text DEFAULT NULL,
  `timestamp` datetime(6) DEFAULT NULL,
  `severity` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`event_id`),
  KEY `ix_alarm_history_alarm_id` (`alarm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alarm_history`
--

LOCK TABLES `alarm_history` WRITE;
/*!40000 ALTER TABLE `alarm_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `alarm_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('007');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota`
--

DROP TABLE IF EXISTS `quota`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(128) DEFAULT NULL,
  `resource` varchar(50) DEFAULT NULL,
  `limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`),
  KEY `ix_quota_project_id_resource` (`project_id`,`resource`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota`
--

LOCK TABLES `quota` WRITE;
/*!40000 ALTER TABLE `quota` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('0f8a49bf-9e10-48ee-af03-4971a9a33207','2025-11-23 08:43:18','2025-11-23 08:43:18',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
INSERT INTO `backups` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `host`, `availability_zone`, `display_name`, `display_description`, `container`, `status`, `fail_reason`, `service_metadata`, `service`, `size`, `object_count`, `parent_id`, `temp_volume_id`, `temp_snapshot_id`, `num_dependent_backups`, `snapshot_id`, `data_timestamp`, `restore_volume_id`, `encryption_key_id`) VALUES ('2025-11-23 10:04:24','2025-11-23 10:04:27','2025-11-23 10:04:29',1,'05eb5bc2-7f88-419d-8aa4-2ad9848f3026','e6dcaf3a-9826-4f4a-99ce-65fb52624d71','5f7e9736cbc74ce4ac3de51c4ac84504','49ebd7a691dd4ea59ffbe9f5703e77e4','cinder-backup-0',NULL,NULL,NULL,'backups','deleted',NULL,'{\"base\": \"volume-e6dcaf3a-9826-4f4a-99ce-65fb52624d71.backup.b9012ecc-e14e-4640-b68e-196d3e7445e3\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,'b9012ecc-e14e-4640-b68e-196d3e7445e3',NULL,NULL,NULL,NULL,'2025-11-23 10:04:24',NULL,NULL),('2025-11-23 10:02:30','2025-11-23 10:02:50','2025-11-23 10:02:51',1,'1833bdd9-4465-48cc-ac08-7937107b35f7','d4b480ff-242c-4b3a-8ca6-2cc05a8f533e','d4c36ce85e40425fa6aaf111d1fdfcc4','10f8dd7c838246c58f1d2c4efc771237','cinder-backup-0',NULL,'tempest-VolumesSnapshotTestJSON-Backup-708500389',NULL,'backups','deleted',NULL,NULL,'cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,'8efa68c6-fa13-4da0-9442-3d54ff185603','2025-11-23 10:02:28',NULL,NULL),('2025-11-23 10:04:30','2025-11-23 10:04:33','2025-11-23 10:04:34',1,'3c47086d-20d4-4a35-a7a2-6f66ee4e325b','e6dcaf3a-9826-4f4a-99ce-65fb52624d71','5f7e9736cbc74ce4ac3de51c4ac84504','49ebd7a691dd4ea59ffbe9f5703e77e4','cinder-backup-0',NULL,'tempest-VolumesBackupsTest-Backup-935214184',NULL,'backups','deleted',NULL,'{\"base\": \"volume-e6dcaf3a-9826-4f4a-99ce-65fb52624d71.backup.b9012ecc-e14e-4640-b68e-196d3e7445e3\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,'b9012ecc-e14e-4640-b68e-196d3e7445e3',NULL,NULL,NULL,NULL,'2025-11-23 10:04:30',NULL,NULL),('2025-11-23 10:06:48','2025-11-23 10:06:52','2025-11-23 10:06:54',1,'84244c24-7f9f-4194-81bf-1f752094d7df','8a35afd9-e2cc-479b-82ec-ab9be2de5687','d919be80e59845fbb2790f6ff25ebd96','44a6cb5f8b014bad84cfff33db7a4de0','cinder-backup-0',NULL,'tempest-VolumesBackupsV39Test-Backup-634303405','tempest-volume-backup-description-2094039716','backups','deleted',NULL,'{\"base\": \"volume-8a35afd9-e2cc-479b-82ec-ab9be2de5687.backup.84244c24-7f9f-4194-81bf-1f752094d7df\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:48',NULL,NULL),('2025-11-23 10:04:20','2025-11-23 10:04:34','2025-11-23 10:04:35',1,'b9012ecc-e14e-4640-b68e-196d3e7445e3','e6dcaf3a-9826-4f4a-99ce-65fb52624d71','5f7e9736cbc74ce4ac3de51c4ac84504','49ebd7a691dd4ea59ffbe9f5703e77e4','cinder-backup-0',NULL,'tempest-VolumesBackupsTest-Backup-536725942',NULL,'backups','deleted',NULL,'{\"base\": \"volume-e6dcaf3a-9826-4f4a-99ce-65fb52624d71.backup.b9012ecc-e14e-4640-b68e-196d3e7445e3\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,0,NULL,'2025-11-23 10:04:20',NULL,NULL),('2025-11-23 10:03:25','2025-11-23 10:03:36','2025-11-23 10:03:37',1,'bf5bed0f-d12a-4564-a4c8-bc89fe0ec866','5f882947-d542-4b3a-8f9a-d78d3d24e31e','5f7e9736cbc74ce4ac3de51c4ac84504','49ebd7a691dd4ea59ffbe9f5703e77e4','cinder-backup-0',NULL,'tempest-VolumesBackupsTest-Backup-1599183983',NULL,'backups','deleted',NULL,'{\"base\": \"volume-5f882947-d542-4b3a-8f9a-d78d3d24e31e.backup.bf5bed0f-d12a-4564-a4c8-bc89fe0ec866\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:03:25','a01af78e-65b1-4be5-93ac-056bedd54cb6',NULL),('2025-11-23 10:06:17','2025-11-23 10:06:28','2025-11-23 10:06:29',1,'cc439e4f-3862-4cbe-80f3-b219d32ede61','04bb848a-9b13-4ca5-884f-90a1f2277533','64e7d06fed5b4041b603f81a8b352e85','141ccb7a18aa4552b64b95f2b6f47c17','cinder-backup-0',NULL,'tempest-VolumesBackupsAdminTest-Backup-1171663532',NULL,'backups','deleted',NULL,'{\"base\": \"volume-04bb848a-9b13-4ca5-884f-90a1f2277533.backup.cc439e4f-3862-4cbe-80f3-b219d32ede61\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:17','127eaf85-61a7-4a0c-b7e3-6d748c351ac2',NULL),('2025-11-23 10:06:32','2025-11-23 10:06:36','2025-11-23 10:06:37',1,'e0ef9630-8f19-4a17-b553-628b63dcfac7','204d655f-515d-4e87-acb6-27a562b76d94','64e7d06fed5b4041b603f81a8b352e85','141ccb7a18aa4552b64b95f2b6f47c17','cinder-backup-0',NULL,'tempest-VolumesBackupsAdminTest-Backup-942761639',NULL,'backups','deleted',NULL,'{\"base\": \"volume-204d655f-515d-4e87-acb6-27a562b76d94.backup.e0ef9630-8f19-4a17-b553-628b63dcfac7\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:32',NULL,NULL),('2025-11-23 10:06:17','2025-11-23 10:06:27','2025-11-23 10:06:27',1,'f1556bae-cf58-485e-b805-a93af459a10e','04bb848a-9b13-4ca5-884f-90a1f2277533','022f10e09b1a4f6399df64ab44f0714e','bd1b52601ecc405a9de9756861ac3a17','cinder-backup-0','nova','tempest-VolumesBackupsAdminTest-Backup-1171663532',NULL,'backups','deleted',NULL,'{\"base\": \"volume-04bb848a-9b13-4ca5-884f-90a1f2277533.backup.cc439e4f-3862-4cbe-80f3-b219d32ede61\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,0,NULL,NULL,NULL,0,NULL,'2025-11-23 10:06:17',NULL,NULL);
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`disabled` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`frozen` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
INSERT INTO `encryption` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `cipher`, `control_location`, `key_size`, `provider`, `volume_type_id`, `encryption_id`) VALUES ('2025-11-23 10:03:56','2025-11-23 10:03:57','2025-11-23 10:03:57',1,'aes-xts-plain64','back-end',128,'SomeProvider','92c65fbb-350f-45b0-895e-1d3a6376fa47','8af2ae52-b387-4183-b8cb-4b7b60545880');
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
INSERT INTO `group_snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `group_id`, `user_id`, `project_id`, `name`, `description`, `status`, `group_type_id`) VALUES ('2025-11-23 10:03:29','2025-11-23 10:03:32','2025-11-23 10:03:34',1,'04cb100a-b405-4429-bc77-e0139683d5cb','e1bff02b-6264-4203-baf2-3735364b24fc','42ad1c0f7faa440e8fdf09af1b39a0b5','9d635cb23eed4c8795c7c085f175d605','tempest-GroupSnapshotsTest-Group_Snapshot-238832',NULL,'deleted','3f79a0cb-8f09-48ae-ad2d-40a1623e0d3e'),('2025-11-23 10:03:12','2025-11-23 10:03:16','2025-11-23 10:03:17',1,'85df50cf-789a-4082-9092-9ee541ab13ea','7dfddc1c-7ecc-43de-8b36-365b10328d0c','42ad1c0f7faa440e8fdf09af1b39a0b5','9d635cb23eed4c8795c7c085f175d605','tempest-group_snapshot-1498918458',NULL,'deleted','7730a2f9-0c2e-4792-b75d-8273e84b656a'),('2025-11-23 10:03:40','2025-11-23 10:03:42','2025-11-23 10:03:43',1,'88574e1d-a40d-4d3e-8301-18385cff4105','fefefca2-079b-4555-b8b1-5983dcf5d9d6','42ad1c0f7faa440e8fdf09af1b39a0b5','9d635cb23eed4c8795c7c085f175d605','tempest-group_snapshot-250757580',NULL,'deleted','fda99d0f-c64c-4319-a3a8-664e55eb941b'),('2025-11-23 10:04:24','2025-11-23 10:04:27','2025-11-23 10:04:28',1,'c01cd497-71ec-4cfa-9c89-5161fc2623e8','d97cbdb7-bfb3-4e91-a3ae-4f19cae23892','b5f7228b2a13453f852ea24f00659c17','0e9ab70f23134afd92115add42e46bf7','tempest-GroupSnapshotsV319Test-Group_Snapshot-1363132577',NULL,'deleted','b54b394c-7099-411c-aa7a-03138258d03c');
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (2,'consistent_group_snapshot_enabled','<is> True','d0dc99d7-58ba-497e-b21c-101901456762','2025-11-23 08:07:40','2025-11-23 08:07:40',NULL,0),(5,'key1','value1','ec5b336f-effc-4610-9bc4-f72bfad38b15','2025-11-23 10:05:20',NULL,'2025-11-23 10:05:20',1),(6,'key2','value2-updated','ec5b336f-effc-4610-9bc4-f72bfad38b15','2025-11-23 10:05:20','2025-11-23 10:05:20','2025-11-23 10:05:20',1),(7,'key3','value3-updated','ec5b336f-effc-4610-9bc4-f72bfad38b15','2025-11-23 10:05:20','2025-11-23 10:05:20','2025-11-23 10:05:21',1),(8,'consistent_group_snapshot_enabled','<is> False','566cd9a8-f10f-4d80-8791-899fe3e75e04','2025-11-23 10:05:37',NULL,'2025-11-23 10:05:37',1);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`is_public` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('1a69c1d2-2c6f-48b1-8d84-aed6ed9a4368','tempest-GroupsTest-group-type-1594786362',NULL,'2025-11-23 10:05:34',NULL,'2025-11-23 10:05:44',1,1),('265695a3-1582-41de-80d9-e28c58d79119','tempest-GroupsTest-group-type-1419099542',NULL,'2025-11-23 10:05:27',NULL,'2025-11-23 10:05:34',1,1),('3f79a0cb-8f09-48ae-ad2d-40a1623e0d3e','tempest-GroupSnapshotsTest-group-type-1172489038',NULL,'2025-11-23 10:03:20',NULL,'2025-11-23 10:03:38',1,1),('566cd9a8-f10f-4d80-8791-899fe3e75e04','tempest-GroupTypesTest-updated-group-type-199761339','updated-group-type-desc','2025-11-23 10:05:37','2025-11-23 10:05:37','2025-11-23 10:05:37',1,1),('7730a2f9-0c2e-4792-b75d-8273e84b656a','tempest-GroupSnapshotsTest-group-type-1961300989',NULL,'2025-11-23 10:03:09',NULL,'2025-11-23 10:03:20',1,1),('77cf0ae4-ddfc-470c-8682-8e4ea7fb12e4','tempest-GroupsV314Test-group-type-566838962',NULL,'2025-11-23 10:05:42',NULL,'2025-11-23 10:05:50',1,1),('adb75753-3ba0-422d-817e-28d107817e42','a_tempest-group-type-272431420',NULL,'2025-11-23 10:05:37',NULL,'2025-11-23 10:05:37',1,1),('b54b394c-7099-411c-aa7a-03138258d03c','tempest-GroupSnapshotsV319Test-group-type-1265497497',NULL,'2025-11-23 10:04:21',NULL,'2025-11-23 10:04:29',1,1),('d0dc99d7-58ba-497e-b21c-101901456762','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2025-11-23 08:07:40','2025-11-23 08:07:40',NULL,0,1),('de7ade8f-edb3-4ce0-9e55-cb23371c0fb9','tempest-GroupsV320Test-group-type-513455868',NULL,'2025-11-23 10:05:49',NULL,'2025-11-23 10:05:52',1,1),('ec5b336f-effc-4610-9bc4-f72bfad38b15','tempest-GroupTypeSpecsTest-group-type-1209274248',NULL,'2025-11-23 10:05:20',NULL,'2025-11-23 10:05:21',1,1),('fa2e159f-b0cb-467f-acc1-48a181afdde3','b_tempest-group-type-1886929825',NULL,'2025-11-23 10:05:37',NULL,'2025-11-23 10:05:37',1,0),('fda99d0f-c64c-4319-a3a8-664e55eb941b','tempest-GroupSnapshotsTest-group-type-982788363',NULL,'2025-11-23 10:03:38',NULL,'2025-11-23 10:03:44',1,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
INSERT INTO `group_volume_type_mapping` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_type_id`, `group_id`) VALUES ('2025-11-23 10:03:09',NULL,'2025-11-23 10:03:19',1,1,'b6d595ea-8206-457d-b78d-b17b350cbea3','7dfddc1c-7ecc-43de-8b36-365b10328d0c'),('2025-11-23 10:03:13',NULL,'2025-11-23 10:03:15',1,2,'b6d595ea-8206-457d-b78d-b17b350cbea3','d0291243-67e3-4765-879b-1c344607e740'),('2025-11-23 10:03:20',NULL,'2025-11-23 10:03:37',1,3,'e5331b89-b9ff-471f-8259-23626242497b','e1bff02b-6264-4203-baf2-3735364b24fc'),('2025-11-23 10:03:38',NULL,'2025-11-23 10:03:44',1,4,'64fcaaaa-fa47-4bdc-a13a-bebe79570770','fefefca2-079b-4555-b8b1-5983dcf5d9d6'),('2025-11-23 10:04:22',NULL,'2025-11-23 10:04:29',1,5,'3bb61f6b-350b-4406-9d79-133424e040aa','d97cbdb7-bfb3-4e91-a3ae-4f19cae23892'),('2025-11-23 10:05:27',NULL,'2025-11-23 10:05:32',1,6,'56da7e66-b2db-4f63-a5a8-67002badaafc','6bca1704-36a3-4e7d-b1d9-9310bf468c41'),('2025-11-23 10:05:28',NULL,'2025-11-23 10:05:33',1,7,'56da7e66-b2db-4f63-a5a8-67002badaafc','fcd31395-7e68-4818-a2d0-0a663263fa41'),('2025-11-23 10:05:34',NULL,'2025-11-23 10:05:43',1,8,'857a0579-6ba7-4353-8484-fb744288604e','d0356f68-2797-4515-9e7d-5750badc3e61'),('2025-11-23 10:05:43',NULL,'2025-11-23 10:05:49',1,9,'ef286d9e-549a-4844-9f5d-93ebf87512fc','3c1d862f-3d18-4823-b86a-5734360d6542'),('2025-11-23 10:05:45',NULL,'2025-11-23 10:05:48',1,10,'ef286d9e-549a-4844-9f5d-93ebf87512fc','a28d6779-89c6-402b-8c4e-0372b634153f'),('2025-11-23 10:05:50',NULL,'2025-11-23 10:05:51',1,11,'a0a52c33-ec19-41e6-bcc0-1611745a9b22','d40b46d0-eb2b-4cd6-8882-d3fd62f82e9d');
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
INSERT INTO `groups` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `cluster_name`, `host`, `availability_zone`, `name`, `description`, `group_type_id`, `status`, `group_snapshot_id`, `source_group_id`, `replication_status`) VALUES ('2025-11-23 10:05:43','2025-11-23 10:05:49','2025-11-23 10:05:49',1,'3c1d862f-3d18-4823-b86a-5734360d6542','df30e9d95de942da9333c6d01dd52576','b26c9bed083447548be26f4feb5dd112',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupsV314Test-Group-1811708064',NULL,'77cf0ae4-ddfc-470c-8682-8e4ea7fb12e4','deleted',NULL,NULL,'disabled'),('2025-11-23 10:05:27','2025-11-23 10:05:32','2025-11-23 10:05:32',1,'6bca1704-36a3-4e7d-b1d9-9310bf468c41','62451c91e4c24f0fb36b26f84bd3bfc4','fb2fe4c3f84642bbad40631e42e594dd',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-Group1-1884991225',NULL,'265695a3-1582-41de-80d9-e28c58d79119','deleted',NULL,NULL,'disabled'),('2025-11-23 10:03:09','2025-11-23 10:03:19','2025-11-23 10:03:19',1,'7dfddc1c-7ecc-43de-8b36-365b10328d0c','42ad1c0f7faa440e8fdf09af1b39a0b5','9d635cb23eed4c8795c7c085f175d605',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupSnapshotsTest-Group-139892905',NULL,'7730a2f9-0c2e-4792-b75d-8273e84b656a','deleted',NULL,NULL,'disabled'),('2025-11-23 10:05:46','2025-11-23 10:05:48','2025-11-23 10:05:48',1,'a28d6779-89c6-402b-8c4e-0372b634153f','df30e9d95de942da9333c6d01dd52576','b26c9bed083447548be26f4feb5dd112',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-Group_from_grp-138529440',NULL,'77cf0ae4-ddfc-470c-8682-8e4ea7fb12e4','deleted',NULL,'3c1d862f-3d18-4823-b86a-5734360d6542','disabled'),('2025-11-23 10:03:14','2025-11-23 10:03:15','2025-11-23 10:03:15',1,'d0291243-67e3-4765-879b-1c344607e740','42ad1c0f7faa440e8fdf09af1b39a0b5','9d635cb23eed4c8795c7c085f175d605',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-Group_from_snap-1903340648',NULL,'7730a2f9-0c2e-4792-b75d-8273e84b656a','deleted','85df50cf-789a-4082-9092-9ee541ab13ea',NULL,'disabled'),('2025-11-23 10:05:34','2025-11-23 10:05:43','2025-11-23 10:05:43',1,'d0356f68-2797-4515-9e7d-5750badc3e61','62451c91e4c24f0fb36b26f84bd3bfc4','fb2fe4c3f84642bbad40631e42e594dd',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','new_group','This is a new group','1a69c1d2-2c6f-48b1-8d84-aed6ed9a4368','deleted',NULL,NULL,'disabled'),('2025-11-23 10:05:50','2025-11-23 10:05:51','2025-11-23 10:05:51',1,'d40b46d0-eb2b-4cd6-8882-d3fd62f82e9d','495b816e71724a42ba73f5d9750eacb5','ad260941b31148988b7356700a79268b',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupsV320Test-Group-1691299634',NULL,'de7ade8f-edb3-4ce0-9e55-cb23371c0fb9','deleted',NULL,NULL,'disabled'),('2025-11-23 10:04:22','2025-11-23 10:04:29','2025-11-23 10:04:29',1,'d97cbdb7-bfb3-4e91-a3ae-4f19cae23892','b5f7228b2a13453f852ea24f00659c17','0e9ab70f23134afd92115add42e46bf7',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupSnapshotsV319Test-Group-1653792722',NULL,'b54b394c-7099-411c-aa7a-03138258d03c','deleted',NULL,NULL,'disabled'),('2025-11-23 10:03:21','2025-11-23 10:03:36','2025-11-23 10:03:37',1,'e1bff02b-6264-4203-baf2-3735364b24fc','42ad1c0f7faa440e8fdf09af1b39a0b5','9d635cb23eed4c8795c7c085f175d605',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupSnapshotsTest-Group-2006874384',NULL,'3f79a0cb-8f09-48ae-ad2d-40a1623e0d3e','deleted',NULL,NULL,'disabled'),('2025-11-23 10:05:29','2025-11-23 10:05:33','2025-11-23 10:05:33',1,'fcd31395-7e68-4818-a2d0-0a663263fa41','62451c91e4c24f0fb36b26f84bd3bfc4','fb2fe4c3f84642bbad40631e42e594dd',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-Group2-2076322026',NULL,'265695a3-1582-41de-80d9-e28c58d79119','deleted',NULL,NULL,'disabled'),('2025-11-23 10:03:38','2025-11-23 10:03:44','2025-11-23 10:03:44',1,'fefefca2-079b-4555-b8b1-5983dcf5d9d6','42ad1c0f7faa440e8fdf09af1b39a0b5','9d635cb23eed4c8795c7c085f175d605',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupSnapshotsTest-Group-528957778',NULL,'fda99d0f-c64c-4319-a3a8-664e55eb941b','deleted',NULL,NULL,'disabled');
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`),
  KEY `ix_image_volume_cache_entries_host` (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
INSERT INTO `messages` (`id`, `project_id`, `request_id`, `resource_type`, `resource_uuid`, `event_id`, `message_level`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `expires_at`, `detail_id`, `action_id`) VALUES ('45398469-b7d4-467a-ad37-2fcf5acc5f16','31ac2e693dd64b72aedd3d1555ed3e03','req-055853a7-9623-412e-8bb6-ec30f374167a','VOLUME','a14ff63e-4d59-4228-ace7-cc262cb9b821','VOLUME_VOLUME_001_003','ERROR','2025-11-23 10:05:51',NULL,'2025-11-23 10:05:52',1,'2025-12-23 10:05:51','003','001'),('9f74bb21-ead3-4d1f-853f-7fa50dab5176','31ac2e693dd64b72aedd3d1555ed3e03','req-5529e687-b950-4142-b634-c1d2c29e47c0','VOLUME','633dd0f7-5f6f-44ee-8969-feaa324b7808','VOLUME_VOLUME_001_003','ERROR','2025-11-23 10:05:50',NULL,'2025-11-23 10:05:51',1,'2025-12-23 10:05:50','003','001');
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('cinder','/usr/lib/python3.9/site-packages/cinder/db/sqlalchemy/migrate_repo',145);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
INSERT INTO `quality_of_service_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `specs_id`, `key`, `value`) VALUES ('2025-11-23 10:05:14',NULL,'2025-11-23 10:05:16',1,'16c8e4b0-d6c1-431f-87df-bad5fe17528c','f50cb2d9-b68a-4b10-9446-c02405dced70','read_iops_sec','2000'),('2025-11-23 10:05:14',NULL,'2025-11-23 10:05:16',1,'1c9d2512-18b9-4827-9cf1-5bbd4058ed86','f50cb2d9-b68a-4b10-9446-c02405dced70','consumer','front-end'),('2025-11-23 10:05:16',NULL,'2025-11-23 10:05:16',1,'289d33f5-f1a0-49cb-9129-6c0418b205ce','f50cb2d9-b68a-4b10-9446-c02405dced70','iops_bytes','500'),('2025-11-23 10:05:15',NULL,'2025-11-23 10:05:15',1,'30b27a74-1b70-4fac-a050-9e71d97f6e3d',NULL,'QoS_Specs_Name','tempest-QosSpecsTestJSON-qos-1987697137'),('2025-11-23 10:05:15',NULL,'2025-11-23 10:05:15',1,'57115623-06c3-4449-a8f2-3096728104a2','f8a65dda-63a5-409f-9e7d-e4eb2f3c3514','consumer','front-end'),('2025-11-23 10:05:15',NULL,'2025-11-23 10:05:15',1,'796271d0-6d80-4a43-8e30-d4cc7f7209cf',NULL,'QoS_Specs_Name','tempest-QosSpecsTestJSON-qos-1083796606'),('2025-11-23 10:05:15',NULL,'2025-11-23 10:05:15',1,'8532c867-8d5a-4932-b166-50498bf68bf5','796271d0-6d80-4a43-8e30-d4cc7f7209cf','consumer','back-end'),('2025-11-23 10:05:15',NULL,'2025-11-23 10:05:15',1,'b977867f-9819-41b8-a82f-adc12073122f','30b27a74-1b70-4fac-a050-9e71d97f6e3d','consumer','both'),('2025-11-23 10:05:14',NULL,'2025-11-23 10:05:16',1,'f50cb2d9-b68a-4b10-9446-c02405dced70',NULL,'QoS_Specs_Name','tempest-QosSpecsTestJSON-QoS-1557508885'),('2025-11-23 10:05:15',NULL,'2025-11-23 10:05:15',1,'f8a65dda-63a5-409f-9e7d-e4eb2f3c3514',NULL,'QoS_Specs_Name','tempest-QosSpecsTestJSON-qos-1442734025');
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2025-11-23 08:07:35','2025-11-23 10:02:26',NULL,0,2,'default','volumes',10),('2025-11-23 08:07:35','2025-11-23 10:02:26',NULL,0,5,'default','snapshots',10),('2025-11-23 08:07:35','2025-11-23 10:02:26',NULL,0,8,'default','gigabytes',1000),('2025-11-23 08:07:35',NULL,NULL,0,11,'default','consistencygroups',10),('2025-11-23 08:07:35',NULL,NULL,0,14,'default','per_volume_gigabytes',-1),('2025-11-23 08:07:35',NULL,NULL,0,17,'default','groups',10),('2025-11-23 10:02:26','2025-11-23 10:02:26',NULL,0,20,'default','backups',10),('2025-11-23 10:02:26','2025-11-23 10:02:26',NULL,0,21,'default','backup_gigabytes',1000),('2025-11-23 10:02:26',NULL,NULL,0,22,'default','volumes_tempest-VolumeQuotaClassesTest-volume-type-1678906391',3),('2025-11-23 10:02:26',NULL,NULL,0,23,'default','snapshots_tempest-VolumeQuotaClassesTest-volume-type-1678906391',9),('2025-11-23 10:02:26',NULL,NULL,0,24,'default','gigabytes_tempest-VolumeQuotaClassesTest-volume-type-1678906391',1);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `quota_usages_project_id_key` (`project_id`,`resource`,`race_preventer`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=224 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `race_preventer`) VALUES ('2025-11-23 10:01:06','2025-11-23 10:01:11',NULL,0,1,'22b5d1ffb22c47428f71809e862e842f','volumes',0,0,NULL,1),('2025-11-23 10:01:06','2025-11-23 10:01:11',NULL,0,2,'22b5d1ffb22c47428f71809e862e842f','gigabytes',0,0,NULL,1),('2025-11-23 10:01:06','2025-11-23 10:01:09',NULL,0,3,'22b5d1ffb22c47428f71809e862e842f','volumes_volume-type-1',0,0,NULL,1),('2025-11-23 10:01:06','2025-11-23 10:01:09',NULL,0,4,'22b5d1ffb22c47428f71809e862e842f','gigabytes_volume-type-1',0,0,NULL,1),('2025-11-23 10:01:08','2025-11-23 10:01:11',NULL,0,5,'22b5d1ffb22c47428f71809e862e842f','volumes_volume-type-2',0,0,NULL,1),('2025-11-23 10:01:08','2025-11-23 10:01:11',NULL,0,6,'22b5d1ffb22c47428f71809e862e842f','gigabytes_volume-type-2',0,0,NULL,1),('2025-11-23 10:01:20','2025-11-23 10:01:30',NULL,0,7,'b89f120d906e4409a0177b37c378adeb','volumes',0,0,NULL,1),('2025-11-23 10:01:20','2025-11-23 10:01:30',NULL,0,8,'b89f120d906e4409a0177b37c378adeb','gigabytes',0,0,NULL,1),('2025-11-23 10:01:20','2025-11-23 10:01:30',NULL,0,9,'b89f120d906e4409a0177b37c378adeb','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:01:20','2025-11-23 10:01:30',NULL,0,10,'b89f120d906e4409a0177b37c378adeb','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:01:41','2025-11-23 10:01:47',NULL,0,11,'9b4ff14ad14b470a96ecd244e7453fa2','volumes',0,0,NULL,1),('2025-11-23 10:01:41','2025-11-23 10:01:47',NULL,0,12,'9b4ff14ad14b470a96ecd244e7453fa2','gigabytes',0,0,NULL,1),('2025-11-23 10:01:41','2025-11-23 10:01:47',NULL,0,13,'9b4ff14ad14b470a96ecd244e7453fa2','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:01:41','2025-11-23 10:01:47',NULL,0,14,'9b4ff14ad14b470a96ecd244e7453fa2','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:01:42','2025-11-23 10:01:44',NULL,0,15,'2f5ceb3dcba34969a782c4e8c5c3fe76','volumes',0,0,NULL,1),('2025-11-23 10:01:42','2025-11-23 10:01:44',NULL,0,16,'2f5ceb3dcba34969a782c4e8c5c3fe76','gigabytes',0,0,NULL,1),('2025-11-23 10:01:42','2025-11-23 10:01:44',NULL,0,17,'2f5ceb3dcba34969a782c4e8c5c3fe76','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:01:42','2025-11-23 10:01:44',NULL,0,18,'2f5ceb3dcba34969a782c4e8c5c3fe76','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:01:43',NULL,NULL,0,19,'2f5ceb3dcba34969a782c4e8c5c3fe76','snapshots',0,0,NULL,1),('2025-11-23 10:01:43',NULL,NULL,0,20,'2f5ceb3dcba34969a782c4e8c5c3fe76','snapshots_tripleo',0,0,NULL,1),('2025-11-23 10:01:43',NULL,NULL,0,21,'9b4ff14ad14b470a96ecd244e7453fa2','snapshots',0,0,NULL,1),('2025-11-23 10:01:43',NULL,NULL,0,22,'9b4ff14ad14b470a96ecd244e7453fa2','snapshots_tripleo',0,0,NULL,1),('2025-11-23 10:01:59','2025-11-23 10:02:05',NULL,0,23,'b8fa70a700964960a82c255d7f038c3d','volumes',0,0,NULL,1),('2025-11-23 10:01:59','2025-11-23 10:02:05',NULL,0,24,'b8fa70a700964960a82c255d7f038c3d','gigabytes',0,0,NULL,1),('2025-11-23 10:01:59','2025-11-23 10:02:05',NULL,0,25,'b8fa70a700964960a82c255d7f038c3d','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:01:59','2025-11-23 10:02:05',NULL,0,26,'b8fa70a700964960a82c255d7f038c3d','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:02:01','2025-11-23 10:02:02',NULL,0,27,'4b84b07fc6534e88860c454382c4f9f4','volumes',0,0,NULL,1),('2025-11-23 10:02:01','2025-11-23 10:02:02',NULL,0,28,'4b84b07fc6534e88860c454382c4f9f4','gigabytes',0,0,NULL,1),('2025-11-23 10:02:01','2025-11-23 10:02:02',NULL,0,29,'4b84b07fc6534e88860c454382c4f9f4','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:02:01','2025-11-23 10:02:02',NULL,0,30,'4b84b07fc6534e88860c454382c4f9f4','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:02:01',NULL,NULL,0,31,'4b84b07fc6534e88860c454382c4f9f4','snapshots',0,0,NULL,1),('2025-11-23 10:02:01',NULL,NULL,0,32,'4b84b07fc6534e88860c454382c4f9f4','snapshots_tripleo',0,0,NULL,1),('2025-11-23 10:02:01',NULL,NULL,0,33,'b8fa70a700964960a82c255d7f038c3d','snapshots',0,0,NULL,1),('2025-11-23 10:02:01',NULL,NULL,0,34,'b8fa70a700964960a82c255d7f038c3d','snapshots_tripleo',0,0,NULL,1),('2025-11-23 10:02:26','2025-11-23 10:03:14',NULL,0,35,'10f8dd7c838246c58f1d2c4efc771237','volumes',0,0,NULL,1),('2025-11-23 10:02:26','2025-11-23 10:03:14',NULL,0,36,'10f8dd7c838246c58f1d2c4efc771237','gigabytes',0,0,NULL,1),('2025-11-23 10:02:26','2025-11-23 10:03:14',NULL,0,37,'10f8dd7c838246c58f1d2c4efc771237','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:02:26','2025-11-23 10:03:14',NULL,0,38,'10f8dd7c838246c58f1d2c4efc771237','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:02:28','2025-11-23 10:03:12',NULL,0,39,'10f8dd7c838246c58f1d2c4efc771237','snapshots',0,0,NULL,1),('2025-11-23 10:02:28','2025-11-23 10:03:12',NULL,0,40,'10f8dd7c838246c58f1d2c4efc771237','snapshots_tripleo',0,0,NULL,1),('2025-11-23 10:02:30','2025-11-23 10:02:51',NULL,0,41,'10f8dd7c838246c58f1d2c4efc771237','backups',0,0,NULL,1),('2025-11-23 10:02:30','2025-11-23 10:02:51',NULL,0,42,'10f8dd7c838246c58f1d2c4efc771237','backup_gigabytes',0,0,NULL,1),('2025-11-23 10:02:33','2025-11-23 10:02:37',NULL,0,43,'6af2e3709ace42c9b1e8c60ef058acf5','volumes',0,0,NULL,1),('2025-11-23 10:02:33','2025-11-23 10:02:37',NULL,0,44,'6af2e3709ace42c9b1e8c60ef058acf5','gigabytes',0,0,NULL,1),('2025-11-23 10:02:33','2025-11-23 10:02:37',NULL,0,45,'6af2e3709ace42c9b1e8c60ef058acf5','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:02:33','2025-11-23 10:02:37',NULL,0,46,'6af2e3709ace42c9b1e8c60ef058acf5','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:02:46','2025-11-23 10:02:55',NULL,0,47,'6d43b7d88e884e6d87abed93a63f5ca0','volumes',0,0,NULL,1),('2025-11-23 10:02:46','2025-11-23 10:02:55',NULL,0,48,'6d43b7d88e884e6d87abed93a63f5ca0','gigabytes',0,0,NULL,1),('2025-11-23 10:02:46','2025-11-23 10:02:55',NULL,0,49,'6d43b7d88e884e6d87abed93a63f5ca0','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:02:46','2025-11-23 10:02:55',NULL,0,50,'6d43b7d88e884e6d87abed93a63f5ca0','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:02:50','2025-11-23 10:02:53',NULL,0,51,'975c2485ae874077a08f31a00a36b8e9','volumes',0,0,NULL,1),('2025-11-23 10:02:50','2025-11-23 10:02:53',NULL,0,52,'975c2485ae874077a08f31a00a36b8e9','gigabytes',0,0,NULL,1),('2025-11-23 10:02:50','2025-11-23 10:02:53',NULL,0,53,'975c2485ae874077a08f31a00a36b8e9','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:02:50','2025-11-23 10:02:53',NULL,0,54,'975c2485ae874077a08f31a00a36b8e9','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:03:09','2025-11-23 10:03:44',NULL,0,55,'9d635cb23eed4c8795c7c085f175d605','groups',0,0,NULL,1),('2025-11-23 10:03:10','2025-11-23 10:03:44',NULL,0,56,'9d635cb23eed4c8795c7c085f175d605','volumes',0,0,NULL,1),('2025-11-23 10:03:10','2025-11-23 10:03:44',NULL,0,57,'9d635cb23eed4c8795c7c085f175d605','gigabytes',0,0,NULL,1),('2025-11-23 10:03:10','2025-11-23 10:03:19',NULL,0,58,'9d635cb23eed4c8795c7c085f175d605','volumes_tempest-GroupSnapshotsTest-volume-type-1819188790',0,0,NULL,1),('2025-11-23 10:03:10','2025-11-23 10:03:17',NULL,0,59,'9d635cb23eed4c8795c7c085f175d605','gigabytes_tempest-GroupSnapshotsTest-volume-type-1819188790',0,0,NULL,1),('2025-11-23 10:03:12','2025-11-23 10:03:43',NULL,0,60,'9d635cb23eed4c8795c7c085f175d605','snapshots',0,0,NULL,1),('2025-11-23 10:03:12','2025-11-23 10:03:17',NULL,0,61,'9d635cb23eed4c8795c7c085f175d605','snapshots_tempest-GroupSnapshotsTest-volume-type-1819188790',0,0,NULL,1),('2025-11-23 10:03:19','2025-11-23 10:04:47',NULL,0,62,'49ebd7a691dd4ea59ffbe9f5703e77e4','volumes',0,0,NULL,1),('2025-11-23 10:03:19','2025-11-23 10:04:47',NULL,0,63,'49ebd7a691dd4ea59ffbe9f5703e77e4','gigabytes',0,0,NULL,1),('2025-11-23 10:03:19','2025-11-23 10:04:47',NULL,0,64,'49ebd7a691dd4ea59ffbe9f5703e77e4','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:03:19','2025-11-23 10:04:47',NULL,0,65,'49ebd7a691dd4ea59ffbe9f5703e77e4','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:03:22','2025-11-23 10:03:37',NULL,0,66,'9d635cb23eed4c8795c7c085f175d605','volumes_tempest-GroupSnapshotsTest-volume-type-175069716',0,0,NULL,1),('2025-11-23 10:03:22','2025-11-23 10:03:37',NULL,0,67,'9d635cb23eed4c8795c7c085f175d605','gigabytes_tempest-GroupSnapshotsTest-volume-type-175069716',0,0,NULL,1),('2025-11-23 10:03:25','2025-11-23 10:04:35',NULL,0,68,'49ebd7a691dd4ea59ffbe9f5703e77e4','backups',0,0,NULL,1),('2025-11-23 10:03:25','2025-11-23 10:04:35',NULL,0,69,'49ebd7a691dd4ea59ffbe9f5703e77e4','backup_gigabytes',0,0,NULL,1),('2025-11-23 10:03:29','2025-11-23 10:03:34',NULL,0,70,'9d635cb23eed4c8795c7c085f175d605','snapshots_tempest-GroupSnapshotsTest-volume-type-175069716',0,0,NULL,1),('2025-11-23 10:03:39','2025-11-23 10:03:44',NULL,0,71,'9d635cb23eed4c8795c7c085f175d605','volumes_tempest-GroupSnapshotsTest-volume-type-1243502470',0,0,NULL,1),('2025-11-23 10:03:39','2025-11-23 10:03:44',NULL,0,72,'9d635cb23eed4c8795c7c085f175d605','gigabytes_tempest-GroupSnapshotsTest-volume-type-1243502470',0,0,NULL,1),('2025-11-23 10:03:40','2025-11-23 10:03:43',NULL,0,73,'9d635cb23eed4c8795c7c085f175d605','snapshots_tempest-GroupSnapshotsTest-volume-type-1243502470',0,0,NULL,1),('2025-11-23 10:03:52','2025-11-23 10:03:57',NULL,0,74,'63f36986a4504be59f5bb7dd85b81e14','volumes',0,0,NULL,1),('2025-11-23 10:03:52','2025-11-23 10:03:57',NULL,0,75,'63f36986a4504be59f5bb7dd85b81e14','gigabytes',0,0,NULL,1),('2025-11-23 10:03:52','2025-11-23 10:03:57',NULL,0,76,'63f36986a4504be59f5bb7dd85b81e14','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:03:52','2025-11-23 10:03:57',NULL,0,77,'63f36986a4504be59f5bb7dd85b81e14','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:03:53','2025-11-23 10:03:56',NULL,0,78,'63f36986a4504be59f5bb7dd85b81e14','snapshots',0,0,NULL,1),('2025-11-23 10:03:53','2025-11-23 10:03:56',NULL,0,79,'63f36986a4504be59f5bb7dd85b81e14','snapshots_tripleo',0,0,NULL,1),('2025-11-23 10:04:15','2025-11-23 10:04:26',NULL,0,80,'357e082a3fb74c17977fb3ffe7ad4261','volumes',0,0,NULL,1),('2025-11-23 10:04:15','2025-11-23 10:04:26',NULL,0,81,'357e082a3fb74c17977fb3ffe7ad4261','gigabytes',0,0,NULL,1),('2025-11-23 10:04:15','2025-11-23 10:04:26',NULL,0,82,'357e082a3fb74c17977fb3ffe7ad4261','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:04:15','2025-11-23 10:04:26',NULL,0,83,'357e082a3fb74c17977fb3ffe7ad4261','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:04:17','2025-11-23 10:04:32',NULL,0,84,'bd97d43422d1434dbd778fc0c37a5566','volumes',0,0,NULL,1),('2025-11-23 10:04:17','2025-11-23 10:04:32',NULL,0,85,'bd97d43422d1434dbd778fc0c37a5566','gigabytes',0,0,NULL,1),('2025-11-23 10:04:17','2025-11-23 10:04:32',NULL,0,86,'bd97d43422d1434dbd778fc0c37a5566','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:04:17','2025-11-23 10:04:32',NULL,0,87,'bd97d43422d1434dbd778fc0c37a5566','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:04:22','2025-11-23 10:04:29',NULL,0,88,'0e9ab70f23134afd92115add42e46bf7','groups',0,0,NULL,1),('2025-11-23 10:04:23','2025-11-23 10:04:29',NULL,0,89,'0e9ab70f23134afd92115add42e46bf7','volumes',0,0,NULL,1),('2025-11-23 10:04:23','2025-11-23 10:04:29',NULL,0,90,'0e9ab70f23134afd92115add42e46bf7','gigabytes',0,0,NULL,1),('2025-11-23 10:04:23','2025-11-23 10:04:29',NULL,0,91,'0e9ab70f23134afd92115add42e46bf7','volumes_tempest-GroupSnapshotsV319Test-volume-type-1099039626',0,0,NULL,1),('2025-11-23 10:04:23','2025-11-23 10:04:29',NULL,0,92,'0e9ab70f23134afd92115add42e46bf7','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-1099039626',0,0,NULL,1),('2025-11-23 10:04:24','2025-11-23 10:04:28',NULL,0,93,'0e9ab70f23134afd92115add42e46bf7','snapshots',0,0,NULL,1),('2025-11-23 10:04:24','2025-11-23 10:04:28',NULL,0,94,'0e9ab70f23134afd92115add42e46bf7','snapshots_tempest-GroupSnapshotsV319Test-volume-type-1099039626',0,0,NULL,1),('2025-11-23 10:04:27','2025-11-23 10:04:31',NULL,0,95,'bd97d43422d1434dbd778fc0c37a5566','snapshots',0,0,NULL,1),('2025-11-23 10:04:27','2025-11-23 10:04:31',NULL,0,96,'bd97d43422d1434dbd778fc0c37a5566','snapshots_tripleo',0,0,NULL,1),('2025-11-23 10:04:30','2025-11-23 10:04:44',NULL,0,97,'307e3d5fcbc742a6b6aa246e7c8c9946','volumes',0,0,NULL,1),('2025-11-23 10:04:30','2025-11-23 10:04:44',NULL,0,98,'307e3d5fcbc742a6b6aa246e7c8c9946','gigabytes',0,0,NULL,1),('2025-11-23 10:04:30','2025-11-23 10:04:44',NULL,0,99,'307e3d5fcbc742a6b6aa246e7c8c9946','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:04:30','2025-11-23 10:04:44',NULL,0,100,'307e3d5fcbc742a6b6aa246e7c8c9946','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:04:31','2025-11-23 10:04:43',NULL,0,101,'307e3d5fcbc742a6b6aa246e7c8c9946','snapshots',0,0,NULL,1),('2025-11-23 10:04:31','2025-11-23 10:04:43',NULL,0,102,'307e3d5fcbc742a6b6aa246e7c8c9946','snapshots_tripleo',0,0,NULL,1),('2025-11-23 10:04:58','2025-11-23 10:05:15',NULL,0,103,'e456b00c470e4f58a0cb2eb0ed097106','volumes',0,0,NULL,1),('2025-11-23 10:04:58','2025-11-23 10:05:15',NULL,0,104,'e456b00c470e4f58a0cb2eb0ed097106','gigabytes',0,0,NULL,1),('2025-11-23 10:04:58','2025-11-23 10:05:15',NULL,0,105,'e456b00c470e4f58a0cb2eb0ed097106','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:04:58','2025-11-23 10:05:15',NULL,0,106,'e456b00c470e4f58a0cb2eb0ed097106','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:05:14','2025-11-23 10:05:27',NULL,0,107,'ba426e81cfe149da986575955289d04b','volumes',0,0,NULL,1),('2025-11-23 10:05:14','2025-11-23 10:05:27',NULL,0,108,'ba426e81cfe149da986575955289d04b','gigabytes',0,0,NULL,1),('2025-11-23 10:05:14','2025-11-23 10:05:27',NULL,0,109,'ba426e81cfe149da986575955289d04b','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:05:14','2025-11-23 10:05:27',NULL,0,110,'ba426e81cfe149da986575955289d04b','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:05:22','2025-11-23 10:05:43',NULL,0,111,'e26ac473e8284e80b775ad7fd47ae6ec','volumes',0,0,NULL,1),('2025-11-23 10:05:22','2025-11-23 10:05:43',NULL,0,112,'e26ac473e8284e80b775ad7fd47ae6ec','gigabytes',0,0,NULL,1),('2025-11-23 10:05:22','2025-11-23 10:05:43',NULL,0,113,'e26ac473e8284e80b775ad7fd47ae6ec','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:05:22','2025-11-23 10:05:43',NULL,0,114,'e26ac473e8284e80b775ad7fd47ae6ec','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:05:23','2025-11-23 10:05:41',NULL,0,115,'e26ac473e8284e80b775ad7fd47ae6ec','snapshots',0,0,NULL,1),('2025-11-23 10:05:23','2025-11-23 10:05:41',NULL,0,116,'e26ac473e8284e80b775ad7fd47ae6ec','snapshots_tripleo',0,0,NULL,1),('2025-11-23 10:05:27','2025-11-23 10:05:43',NULL,0,117,'fb2fe4c3f84642bbad40631e42e594dd','groups',0,0,NULL,1),('2025-11-23 10:05:30','2025-11-23 10:05:43',NULL,0,118,'fb2fe4c3f84642bbad40631e42e594dd','volumes',0,0,NULL,1),('2025-11-23 10:05:30','2025-11-23 10:05:43',NULL,0,119,'fb2fe4c3f84642bbad40631e42e594dd','gigabytes',0,0,NULL,1),('2025-11-23 10:05:30','2025-11-23 10:05:32',NULL,0,120,'fb2fe4c3f84642bbad40631e42e594dd','volumes_tempest-GroupsTest-volume-type-1960407744',0,0,NULL,1),('2025-11-23 10:05:30','2025-11-23 10:05:32',NULL,0,121,'fb2fe4c3f84642bbad40631e42e594dd','gigabytes_tempest-GroupsTest-volume-type-1960407744',0,0,NULL,1),('2025-11-23 10:05:36','2025-11-23 10:05:43',NULL,0,122,'fb2fe4c3f84642bbad40631e42e594dd','volumes_tempest-GroupsTest-volume-type-1184049508',0,0,NULL,1),('2025-11-23 10:05:36','2025-11-23 10:05:43',NULL,0,123,'fb2fe4c3f84642bbad40631e42e594dd','gigabytes_tempest-GroupsTest-volume-type-1184049508',0,0,NULL,1),('2025-11-23 10:05:40','2025-11-23 10:05:42',NULL,0,124,'737e70c24c3a4eac85267456be6774fa','volumes',0,0,NULL,1),('2025-11-23 10:05:40','2025-11-23 10:05:42',NULL,0,125,'737e70c24c3a4eac85267456be6774fa','gigabytes',0,0,NULL,1),('2025-11-23 10:05:40','2025-11-23 10:05:42',NULL,0,126,'737e70c24c3a4eac85267456be6774fa','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:05:40','2025-11-23 10:05:42',NULL,0,127,'737e70c24c3a4eac85267456be6774fa','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:05:43','2025-11-23 10:05:49',NULL,0,128,'b26c9bed083447548be26f4feb5dd112','groups',0,0,NULL,1),('2025-11-23 10:05:44','2025-11-23 10:05:49',NULL,0,129,'b26c9bed083447548be26f4feb5dd112','volumes',0,0,NULL,1),('2025-11-23 10:05:44','2025-11-23 10:05:49',NULL,0,130,'b26c9bed083447548be26f4feb5dd112','gigabytes',0,0,NULL,1),('2025-11-23 10:05:44','2025-11-23 10:05:49',NULL,0,131,'b26c9bed083447548be26f4feb5dd112','volumes_tempest-GroupsV314Test-volume-type-1357687760',0,0,NULL,1),('2025-11-23 10:05:44','2025-11-23 10:05:49',NULL,0,132,'b26c9bed083447548be26f4feb5dd112','gigabytes_tempest-GroupsV314Test-volume-type-1357687760',0,0,NULL,1),('2025-11-23 10:05:49','2025-11-23 10:05:53',NULL,0,133,'31ac2e693dd64b72aedd3d1555ed3e03','volumes',0,0,NULL,1),('2025-11-23 10:05:49','2025-11-23 10:05:53',NULL,0,134,'31ac2e693dd64b72aedd3d1555ed3e03','gigabytes',0,0,NULL,1),('2025-11-23 10:05:49','2025-11-23 10:05:51',NULL,0,135,'31ac2e693dd64b72aedd3d1555ed3e03','volumes_tempest-UserMessagesTest-volume-type-1721981474',0,0,NULL,1),('2025-11-23 10:05:49','2025-11-23 10:05:51',NULL,0,136,'31ac2e693dd64b72aedd3d1555ed3e03','gigabytes_tempest-UserMessagesTest-volume-type-1721981474',0,0,NULL,1),('2025-11-23 10:05:50','2025-11-23 10:05:51',NULL,0,137,'ad260941b31148988b7356700a79268b','groups',0,0,NULL,1),('2025-11-23 10:05:51','2025-11-23 10:05:53',NULL,0,138,'31ac2e693dd64b72aedd3d1555ed3e03','volumes_tempest-UserMessagesTest-volume-type-2124842120',0,0,NULL,1),('2025-11-23 10:05:51','2025-11-23 10:05:53',NULL,0,139,'31ac2e693dd64b72aedd3d1555ed3e03','gigabytes_tempest-UserMessagesTest-volume-type-2124842120',0,0,NULL,1),('2025-11-23 10:05:55','2025-11-23 10:05:57',NULL,0,140,'14ef278019ca433e853baef5651087a9','volumes',0,0,NULL,1),('2025-11-23 10:05:55','2025-11-23 10:05:57',NULL,0,141,'14ef278019ca433e853baef5651087a9','gigabytes',0,0,NULL,1),('2025-11-23 10:05:55','2025-11-23 10:05:57',NULL,0,142,'14ef278019ca433e853baef5651087a9','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:05:55','2025-11-23 10:05:57',NULL,0,143,'14ef278019ca433e853baef5651087a9','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:06:00','2025-11-23 10:06:05',NULL,0,144,'4e886bd382154b9ba842be63cef3b094','volumes',0,0,NULL,1),('2025-11-23 10:06:00','2025-11-23 10:06:05',NULL,0,145,'4e886bd382154b9ba842be63cef3b094','gigabytes',0,0,NULL,1),('2025-11-23 10:06:00','2025-11-23 10:06:05',NULL,0,146,'4e886bd382154b9ba842be63cef3b094','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:06:00','2025-11-23 10:06:05',NULL,0,147,'4e886bd382154b9ba842be63cef3b094','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:06:05','2025-11-23 10:06:06',NULL,0,148,'250d505f169f42eaa1d45ef735f6b254','volumes',0,0,NULL,1),('2025-11-23 10:06:05','2025-11-23 10:06:06',NULL,0,149,'250d505f169f42eaa1d45ef735f6b254','gigabytes',0,0,NULL,1),('2025-11-23 10:06:05','2025-11-23 10:06:06',NULL,0,150,'250d505f169f42eaa1d45ef735f6b254','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:06:05','2025-11-23 10:06:06',NULL,0,151,'250d505f169f42eaa1d45ef735f6b254','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:06:05',NULL,NULL,0,152,'250d505f169f42eaa1d45ef735f6b254','snapshots',0,0,NULL,1),('2025-11-23 10:06:05',NULL,NULL,0,153,'250d505f169f42eaa1d45ef735f6b254','snapshots_tripleo',0,0,NULL,1),('2025-11-23 10:06:05',NULL,NULL,0,154,'4e886bd382154b9ba842be63cef3b094','snapshots',0,0,NULL,1),('2025-11-23 10:06:05',NULL,NULL,0,155,'4e886bd382154b9ba842be63cef3b094','snapshots_tripleo',0,0,NULL,1),('2025-11-23 10:06:05','2025-11-23 10:06:08',NULL,0,156,'10f6dfd6b1684628bd2dfc266a69e68a','volumes',0,0,NULL,1),('2025-11-23 10:06:05','2025-11-23 10:06:08',NULL,0,157,'10f6dfd6b1684628bd2dfc266a69e68a','gigabytes',0,0,NULL,1),('2025-11-23 10:06:05','2025-11-23 10:06:08',NULL,0,158,'10f6dfd6b1684628bd2dfc266a69e68a','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:06:05','2025-11-23 10:06:08',NULL,0,159,'10f6dfd6b1684628bd2dfc266a69e68a','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:06:06','2025-11-23 10:06:08',NULL,0,160,'eefb55b5a7ba44a99cf8b53d39954004','volumes',0,0,NULL,1),('2025-11-23 10:06:06','2025-11-23 10:06:08',NULL,0,161,'eefb55b5a7ba44a99cf8b53d39954004','gigabytes',0,0,NULL,1),('2025-11-23 10:06:06','2025-11-23 10:06:08',NULL,0,162,'eefb55b5a7ba44a99cf8b53d39954004','volumes_tempest-VolumeTypesAccessTest-volume-type-749306444',0,0,NULL,1),('2025-11-23 10:06:06','2025-11-23 10:06:08',NULL,0,163,'eefb55b5a7ba44a99cf8b53d39954004','gigabytes_tempest-VolumeTypesAccessTest-volume-type-749306444',0,0,NULL,1),('2025-11-23 10:06:14','2025-11-23 10:06:16',NULL,0,164,'e404e742ed2d4e9d83bf3d49a6278dc7','volumes',0,0,NULL,1),('2025-11-23 10:06:14','2025-11-23 10:06:16',NULL,0,165,'e404e742ed2d4e9d83bf3d49a6278dc7','gigabytes',0,0,NULL,1),('2025-11-23 10:06:14','2025-11-23 10:06:16',NULL,0,166,'e404e742ed2d4e9d83bf3d49a6278dc7','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:06:14','2025-11-23 10:06:16',NULL,0,167,'e404e742ed2d4e9d83bf3d49a6278dc7','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:06:16','2025-11-23 10:06:21',NULL,0,168,'34d74c1246bf4aba9b9e49e89e82cacb','volumes',0,0,NULL,1),('2025-11-23 10:06:16','2025-11-23 10:06:21',NULL,0,169,'34d74c1246bf4aba9b9e49e89e82cacb','gigabytes',0,0,NULL,1),('2025-11-23 10:06:16','2025-11-23 10:06:21',NULL,0,170,'34d74c1246bf4aba9b9e49e89e82cacb','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:06:16','2025-11-23 10:06:21',NULL,0,171,'34d74c1246bf4aba9b9e49e89e82cacb','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:06:16','2025-11-23 10:06:40',NULL,0,172,'141ccb7a18aa4552b64b95f2b6f47c17','volumes',0,0,NULL,1),('2025-11-23 10:06:16','2025-11-23 10:06:40',NULL,0,173,'141ccb7a18aa4552b64b95f2b6f47c17','gigabytes',0,0,NULL,1),('2025-11-23 10:06:16','2025-11-23 10:06:40',NULL,0,174,'141ccb7a18aa4552b64b95f2b6f47c17','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:06:16','2025-11-23 10:06:40',NULL,0,175,'141ccb7a18aa4552b64b95f2b6f47c17','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:06:17','2025-11-23 10:06:18',NULL,0,176,'8cc99762c1da46248e6ae87d4c3b549f','volumes',0,0,NULL,1),('2025-11-23 10:06:17','2025-11-23 10:06:18',NULL,0,177,'8cc99762c1da46248e6ae87d4c3b549f','gigabytes',0,0,NULL,1),('2025-11-23 10:06:17','2025-11-23 10:06:18',NULL,0,178,'8cc99762c1da46248e6ae87d4c3b549f','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:06:17','2025-11-23 10:06:18',NULL,0,179,'8cc99762c1da46248e6ae87d4c3b549f','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:06:17',NULL,NULL,0,180,'8cc99762c1da46248e6ae87d4c3b549f','snapshots',0,0,NULL,1),('2025-11-23 10:06:17',NULL,NULL,0,181,'8cc99762c1da46248e6ae87d4c3b549f','snapshots_tripleo',0,0,NULL,1),('2025-11-23 10:06:17',NULL,NULL,0,182,'34d74c1246bf4aba9b9e49e89e82cacb','snapshots',0,0,NULL,1),('2025-11-23 10:06:17',NULL,NULL,0,183,'34d74c1246bf4aba9b9e49e89e82cacb','snapshots_tripleo',0,0,NULL,1),('2025-11-23 10:06:17','2025-11-23 10:06:37',NULL,0,184,'141ccb7a18aa4552b64b95f2b6f47c17','backups',0,0,NULL,1),('2025-11-23 10:06:17','2025-11-23 10:06:37',NULL,0,185,'141ccb7a18aa4552b64b95f2b6f47c17','backup_gigabytes',0,0,NULL,1),('2025-11-23 10:06:21','2025-11-23 10:06:43',NULL,0,186,'1be7eab758d64df6bb38d4ddeefb99dd','volumes',0,0,NULL,1),('2025-11-23 10:06:21','2025-11-23 10:06:43',NULL,0,187,'1be7eab758d64df6bb38d4ddeefb99dd','gigabytes',0,0,NULL,1),('2025-11-23 10:06:21','2025-11-23 10:06:43',NULL,0,188,'1be7eab758d64df6bb38d4ddeefb99dd','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:06:21','2025-11-23 10:06:43',NULL,0,189,'1be7eab758d64df6bb38d4ddeefb99dd','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:06:21','2025-11-23 10:06:27',NULL,0,190,'bd1b52601ecc405a9de9756861ac3a17','backups',0,0,NULL,1),('2025-11-23 10:06:21','2025-11-23 10:06:27',NULL,0,191,'bd1b52601ecc405a9de9756861ac3a17','backup_gigabytes',0,0,NULL,1),('2025-11-23 10:06:22','2025-11-23 10:06:40',NULL,0,192,'1be7eab758d64df6bb38d4ddeefb99dd','snapshots',0,0,NULL,1),('2025-11-23 10:06:22','2025-11-23 10:06:40',NULL,0,193,'1be7eab758d64df6bb38d4ddeefb99dd','snapshots_tripleo',0,0,NULL,1),('2025-11-23 10:06:34','2025-11-23 10:07:24',NULL,0,194,'33c4eecf43aa413a9f282206f9e9a55b','volumes',0,0,NULL,1),('2025-11-23 10:06:34','2025-11-23 10:07:24',NULL,0,195,'33c4eecf43aa413a9f282206f9e9a55b','gigabytes',0,0,NULL,1),('2025-11-23 10:06:34','2025-11-23 10:07:24',NULL,0,196,'33c4eecf43aa413a9f282206f9e9a55b','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:06:34','2025-11-23 10:07:24',NULL,0,197,'33c4eecf43aa413a9f282206f9e9a55b','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:06:47','2025-11-23 10:06:56',NULL,0,198,'44a6cb5f8b014bad84cfff33db7a4de0','volumes',0,0,NULL,1),('2025-11-23 10:06:47','2025-11-23 10:06:56',NULL,0,199,'44a6cb5f8b014bad84cfff33db7a4de0','gigabytes',0,0,NULL,1),('2025-11-23 10:06:47','2025-11-23 10:06:56',NULL,0,200,'44a6cb5f8b014bad84cfff33db7a4de0','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:06:47','2025-11-23 10:06:56',NULL,0,201,'44a6cb5f8b014bad84cfff33db7a4de0','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:06:48','2025-11-23 10:06:54',NULL,0,202,'44a6cb5f8b014bad84cfff33db7a4de0','backups',0,0,NULL,1),('2025-11-23 10:06:48','2025-11-23 10:06:54',NULL,0,203,'44a6cb5f8b014bad84cfff33db7a4de0','backup_gigabytes',0,0,NULL,1),('2025-11-23 10:06:49','2025-11-23 10:06:56',NULL,0,204,'dd925bc8c28148ba8527b8de09a93c3c','volumes',0,0,NULL,1),('2025-11-23 10:06:49','2025-11-23 10:06:56',NULL,0,205,'dd925bc8c28148ba8527b8de09a93c3c','gigabytes',0,0,NULL,1),('2025-11-23 10:06:49','2025-11-23 10:06:56',NULL,0,206,'dd925bc8c28148ba8527b8de09a93c3c','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:06:49','2025-11-23 10:06:56',NULL,0,207,'dd925bc8c28148ba8527b8de09a93c3c','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:06:50','2025-11-23 10:06:54',NULL,0,208,'dd925bc8c28148ba8527b8de09a93c3c','snapshots',0,0,NULL,1),('2025-11-23 10:06:50','2025-11-23 10:06:54',NULL,0,209,'dd925bc8c28148ba8527b8de09a93c3c','snapshots_tripleo',0,0,NULL,1),('2025-11-23 10:06:58','2025-11-23 10:07:24',NULL,0,210,'acf2d5195bde4e69ba34cd2a2c03e717','volumes',0,0,NULL,1),('2025-11-23 10:06:58','2025-11-23 10:07:24',NULL,0,211,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes',0,0,NULL,1),('2025-11-23 10:06:58','2025-11-23 10:07:24',NULL,0,212,'acf2d5195bde4e69ba34cd2a2c03e717','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:06:58','2025-11-23 10:07:24',NULL,0,213,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:07:28','2025-11-23 10:07:37',NULL,0,214,'b636df0d8cb546cbb04ef3840b8bf85d','volumes',0,0,NULL,1),('2025-11-23 10:07:28','2025-11-23 10:07:37',NULL,0,215,'b636df0d8cb546cbb04ef3840b8bf85d','gigabytes',0,0,NULL,1),('2025-11-23 10:07:28','2025-11-23 10:07:37',NULL,0,216,'b636df0d8cb546cbb04ef3840b8bf85d','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:07:28','2025-11-23 10:07:37',NULL,0,217,'b636df0d8cb546cbb04ef3840b8bf85d','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:07:41','2025-11-23 10:07:48',NULL,0,218,'58bf8ae7240d4a5597bb2d7ae200e54b','volumes',0,0,NULL,1),('2025-11-23 10:07:41','2025-11-23 10:07:48',NULL,0,219,'58bf8ae7240d4a5597bb2d7ae200e54b','gigabytes',0,0,NULL,1),('2025-11-23 10:07:41','2025-11-23 10:07:48',NULL,0,220,'58bf8ae7240d4a5597bb2d7ae200e54b','volumes_tripleo',0,0,NULL,1),('2025-11-23 10:07:41','2025-11-23 10:07:48',NULL,0,221,'58bf8ae7240d4a5597bb2d7ae200e54b','gigabytes_tripleo',0,0,NULL,1),('2025-11-23 10:07:43','2025-11-23 10:07:46',NULL,0,222,'58bf8ae7240d4a5597bb2d7ae200e54b','snapshots',0,0,NULL,1),('2025-11-23 10:07:43','2025-11-23 10:07:46',NULL,0,223,'58bf8ae7240d4a5597bb2d7ae200e54b','snapshots_tripleo',0,0,NULL,1);
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
INSERT INTO `quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `project_id`, `resource`, `hard_limit`, `allocated`) VALUES (1,'2025-11-23 10:02:34','2025-11-23 10:02:38',NULL,0,'6af2e3709ace42c9b1e8c60ef058acf5','gigabytes',1000,0),(2,'2025-11-23 10:02:35','2025-11-23 10:02:38',NULL,0,'6af2e3709ace42c9b1e8c60ef058acf5','volumes',10,0),(3,'2025-11-23 10:02:38',NULL,NULL,0,'6af2e3709ace42c9b1e8c60ef058acf5','per_volume_gigabytes',-1,0),(4,'2025-11-23 10:02:38',NULL,NULL,0,'6af2e3709ace42c9b1e8c60ef058acf5','snapshots',10,0),(5,'2025-11-23 10:02:38',NULL,NULL,0,'6af2e3709ace42c9b1e8c60ef058acf5','backups',10,0),(6,'2025-11-23 10:02:38',NULL,NULL,0,'6af2e3709ace42c9b1e8c60ef058acf5','backup_gigabytes',1000,0),(7,'2025-11-23 10:03:51','2025-11-23 10:03:57',NULL,0,'63f36986a4504be59f5bb7dd85b81e14','gigabytes',1000,0),(8,'2025-11-23 10:03:51','2025-11-23 10:03:57',NULL,0,'63f36986a4504be59f5bb7dd85b81e14','volumes',10,0),(9,'2025-11-23 10:03:51','2025-11-23 10:03:57',NULL,0,'63f36986a4504be59f5bb7dd85b81e14','snapshots',10,0),(10,'2025-11-23 10:03:57',NULL,NULL,0,'63f36986a4504be59f5bb7dd85b81e14','per_volume_gigabytes',-1,0),(11,'2025-11-23 10:03:57',NULL,NULL,0,'63f36986a4504be59f5bb7dd85b81e14','backups',10,0),(12,'2025-11-23 10:03:57',NULL,NULL,0,'63f36986a4504be59f5bb7dd85b81e14','backup_gigabytes',1000,0),(13,'2025-11-23 10:06:00','2025-11-23 10:06:00','2025-11-23 10:06:00',1,'4e886bd382154b9ba842be63cef3b094','volumes',15,0),(14,'2025-11-23 10:06:00','2025-11-23 10:06:06',NULL,0,'4e886bd382154b9ba842be63cef3b094','volumes',10,0),(15,'2025-11-23 10:06:00','2025-11-23 10:06:06',NULL,0,'4e886bd382154b9ba842be63cef3b094','per_volume_gigabytes',-1,0),(16,'2025-11-23 10:06:00','2025-11-23 10:06:06',NULL,0,'4e886bd382154b9ba842be63cef3b094','snapshots',10,0),(17,'2025-11-23 10:06:00','2025-11-23 10:06:06',NULL,0,'4e886bd382154b9ba842be63cef3b094','gigabytes',1000,0),(18,'2025-11-23 10:06:00','2025-11-23 10:06:06',NULL,0,'4e886bd382154b9ba842be63cef3b094','backups',10,0),(19,'2025-11-23 10:06:00','2025-11-23 10:06:06',NULL,0,'4e886bd382154b9ba842be63cef3b094','backup_gigabytes',1000,0);
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=925 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `allocated_id`) VALUES ('2025-11-23 10:01:06','2025-11-23 10:01:06','2025-11-23 10:01:06',1,1,'358ba173-d7ed-4474-a2ce-832247314f74',1,'22b5d1ffb22c47428f71809e862e842f','volumes',1,'2025-11-24 10:01:06',NULL),('2025-11-23 10:01:06','2025-11-23 10:01:06','2025-11-23 10:01:06',1,2,'b7bb2cb6-2774-425c-bdfc-6a9c96afbb28',2,'22b5d1ffb22c47428f71809e862e842f','gigabytes',1,'2025-11-24 10:01:06',NULL),('2025-11-23 10:01:06','2025-11-23 10:01:06','2025-11-23 10:01:06',1,3,'a976e977-fedd-4cec-bb48-39d0ad265e02',3,'22b5d1ffb22c47428f71809e862e842f','volumes_volume-type-1',1,'2025-11-24 10:01:06',NULL),('2025-11-23 10:01:06','2025-11-23 10:01:06','2025-11-23 10:01:06',1,4,'6e415d0f-8149-4da6-9edd-d74ea5dc2805',4,'22b5d1ffb22c47428f71809e862e842f','gigabytes_volume-type-1',1,'2025-11-24 10:01:06',NULL),('2025-11-23 10:01:08','2025-11-23 10:01:09','2025-11-23 10:01:09',1,5,'11ce3cc8-73ce-4681-9bf2-71661f2f9956',5,'22b5d1ffb22c47428f71809e862e842f','volumes_volume-type-2',1,'2025-11-24 10:01:08',NULL),('2025-11-23 10:01:08','2025-11-23 10:01:09','2025-11-23 10:01:09',1,6,'64a9d8e9-5041-48c4-b08f-07d6846b7fe1',6,'22b5d1ffb22c47428f71809e862e842f','gigabytes_volume-type-2',1,'2025-11-24 10:01:08',NULL),('2025-11-23 10:01:08','2025-11-23 10:01:09','2025-11-23 10:01:09',1,7,'3aefd0d4-77f0-4cd8-b8e4-222897a1ffda',3,'22b5d1ffb22c47428f71809e862e842f','volumes_volume-type-1',-1,'2025-11-24 10:01:08',NULL),('2025-11-23 10:01:08','2025-11-23 10:01:09','2025-11-23 10:01:09',1,8,'77e4b090-8381-438a-b677-5e0e775a045c',4,'22b5d1ffb22c47428f71809e862e842f','gigabytes_volume-type-1',-1,'2025-11-24 10:01:08',NULL),('2025-11-23 10:01:11','2025-11-23 10:01:11','2025-11-23 10:01:11',1,9,'826af397-6fa4-4d75-9e99-2df57937cac1',1,'22b5d1ffb22c47428f71809e862e842f','volumes',-1,'2025-11-24 10:01:11',NULL),('2025-11-23 10:01:11','2025-11-23 10:01:11','2025-11-23 10:01:11',1,10,'d2113f64-b603-4521-b4a1-d98b03afb939',2,'22b5d1ffb22c47428f71809e862e842f','gigabytes',-1,'2025-11-24 10:01:11',NULL),('2025-11-23 10:01:11','2025-11-23 10:01:11','2025-11-23 10:01:11',1,11,'b49459b8-7dfe-49f0-ba78-17ebed1e6e37',5,'22b5d1ffb22c47428f71809e862e842f','volumes_volume-type-2',-1,'2025-11-24 10:01:11',NULL),('2025-11-23 10:01:11','2025-11-23 10:01:11','2025-11-23 10:01:11',1,12,'d9fd0146-4f7a-42f4-90e3-5f766e8e1928',6,'22b5d1ffb22c47428f71809e862e842f','gigabytes_volume-type-2',-1,'2025-11-24 10:01:11',NULL),('2025-11-23 10:01:20','2025-11-23 10:01:20','2025-11-23 10:01:20',1,13,'eddd7a00-ea07-4dc8-930a-699818ff92ae',7,'b89f120d906e4409a0177b37c378adeb','volumes',1,'2025-11-24 10:01:20',NULL),('2025-11-23 10:01:20','2025-11-23 10:01:20','2025-11-23 10:01:20',1,14,'e8c00661-e67e-4974-adc2-0413f113633d',8,'b89f120d906e4409a0177b37c378adeb','gigabytes',1,'2025-11-24 10:01:20',NULL),('2025-11-23 10:01:20','2025-11-23 10:01:20','2025-11-23 10:01:20',1,15,'03d8f9b5-900f-440d-8c59-88b9250d19c8',9,'b89f120d906e4409a0177b37c378adeb','volumes_tripleo',1,'2025-11-24 10:01:20',NULL),('2025-11-23 10:01:20','2025-11-23 10:01:20','2025-11-23 10:01:20',1,16,'d71044ee-a148-4ee8-b1ad-8f0ea6ee63b6',10,'b89f120d906e4409a0177b37c378adeb','gigabytes_tripleo',1,'2025-11-24 10:01:20',NULL),('2025-11-23 10:01:30','2025-11-23 10:01:30','2025-11-23 10:01:30',1,17,'8e57f478-7f33-4f1b-83fb-cf6768827f12',7,'b89f120d906e4409a0177b37c378adeb','volumes',-1,'2025-11-24 10:01:30',NULL),('2025-11-23 10:01:30','2025-11-23 10:01:30','2025-11-23 10:01:30',1,18,'73c326cd-0d9a-40f9-8599-9105aa13d7eb',8,'b89f120d906e4409a0177b37c378adeb','gigabytes',-1,'2025-11-24 10:01:30',NULL),('2025-11-23 10:01:30','2025-11-23 10:01:30','2025-11-23 10:01:30',1,19,'7e6e321c-8174-49f9-a6b4-32160bc3edaa',9,'b89f120d906e4409a0177b37c378adeb','volumes_tripleo',-1,'2025-11-24 10:01:30',NULL),('2025-11-23 10:01:30','2025-11-23 10:01:30','2025-11-23 10:01:30',1,20,'60f20ac5-4089-4eec-b91e-0c7f3bf8d771',10,'b89f120d906e4409a0177b37c378adeb','gigabytes_tripleo',-1,'2025-11-24 10:01:30',NULL),('2025-11-23 10:01:41','2025-11-23 10:01:41','2025-11-23 10:01:41',1,21,'ed558d3e-57e3-48fd-b515-b715928f4540',11,'9b4ff14ad14b470a96ecd244e7453fa2','volumes',1,'2025-11-24 10:01:41',NULL),('2025-11-23 10:01:41','2025-11-23 10:01:41','2025-11-23 10:01:41',1,22,'205e6c68-c3e5-4f52-b72b-1298c7e9c0cf',12,'9b4ff14ad14b470a96ecd244e7453fa2','gigabytes',1,'2025-11-24 10:01:41',NULL),('2025-11-23 10:01:41','2025-11-23 10:01:41','2025-11-23 10:01:41',1,23,'aba1908c-c088-4444-8534-2ed07e0c8eca',13,'9b4ff14ad14b470a96ecd244e7453fa2','volumes_tripleo',1,'2025-11-24 10:01:41',NULL),('2025-11-23 10:01:41','2025-11-23 10:01:41','2025-11-23 10:01:41',1,24,'a4db806d-9c7c-48d7-a6aa-168b0f4707df',14,'9b4ff14ad14b470a96ecd244e7453fa2','gigabytes_tripleo',1,'2025-11-24 10:01:41',NULL),('2025-11-23 10:01:42','2025-11-23 10:01:43','2025-11-23 10:01:43',1,25,'0570860b-9d1e-4fed-819d-030e59b78b36',15,'2f5ceb3dcba34969a782c4e8c5c3fe76','volumes',1,'2025-11-24 10:01:42',NULL),('2025-11-23 10:01:42','2025-11-23 10:01:43','2025-11-23 10:01:43',1,26,'0bd4ce16-bd0c-4da3-97ec-e60971b68bf3',16,'2f5ceb3dcba34969a782c4e8c5c3fe76','gigabytes',1,'2025-11-24 10:01:42',NULL),('2025-11-23 10:01:42','2025-11-23 10:01:43','2025-11-23 10:01:43',1,27,'fed20f68-5059-4d20-917f-8eb4cc090d35',17,'2f5ceb3dcba34969a782c4e8c5c3fe76','volumes_tripleo',1,'2025-11-24 10:01:42',NULL),('2025-11-23 10:01:42','2025-11-23 10:01:43','2025-11-23 10:01:43',1,28,'de427009-5dc2-4909-b85a-96bcaa05bf86',18,'2f5ceb3dcba34969a782c4e8c5c3fe76','gigabytes_tripleo',1,'2025-11-24 10:01:42',NULL),('2025-11-23 10:01:42','2025-11-23 10:01:43','2025-11-23 10:01:43',1,29,'008af729-b771-4324-98a8-442f97c0810b',11,'9b4ff14ad14b470a96ecd244e7453fa2','volumes',-1,'2025-11-24 10:01:42',NULL),('2025-11-23 10:01:42','2025-11-23 10:01:43','2025-11-23 10:01:43',1,30,'ca6ddc1c-6989-48b6-ad2f-1420d5476037',12,'9b4ff14ad14b470a96ecd244e7453fa2','gigabytes',-1,'2025-11-24 10:01:42',NULL),('2025-11-23 10:01:42','2025-11-23 10:01:43','2025-11-23 10:01:43',1,31,'bb903289-1a06-42cc-957c-0466271dfb24',13,'9b4ff14ad14b470a96ecd244e7453fa2','volumes_tripleo',-1,'2025-11-24 10:01:42',NULL),('2025-11-23 10:01:42','2025-11-23 10:01:43','2025-11-23 10:01:43',1,32,'f40e8782-eaa2-4e4a-9c87-a3974224d983',14,'9b4ff14ad14b470a96ecd244e7453fa2','gigabytes_tripleo',-1,'2025-11-24 10:01:42',NULL),('2025-11-23 10:01:43','2025-11-23 10:01:43','2025-11-23 10:01:43',1,33,'fbeb0b8b-4a56-42c9-8661-db6047e75da5',19,'2f5ceb3dcba34969a782c4e8c5c3fe76','snapshots',0,'2025-11-24 10:01:43',NULL),('2025-11-23 10:01:43','2025-11-23 10:01:43','2025-11-23 10:01:43',1,34,'dbc2b265-01cc-441b-b832-539869921201',16,'2f5ceb3dcba34969a782c4e8c5c3fe76','gigabytes',0,'2025-11-24 10:01:43',NULL),('2025-11-23 10:01:43','2025-11-23 10:01:43','2025-11-23 10:01:43',1,35,'a86039c7-b1bc-47bc-b1e9-237db00d2ab6',18,'2f5ceb3dcba34969a782c4e8c5c3fe76','gigabytes_tripleo',0,'2025-11-24 10:01:43',NULL),('2025-11-23 10:01:43','2025-11-23 10:01:43','2025-11-23 10:01:43',1,36,'12636a40-add4-43b6-9fe2-09c8285c065a',20,'2f5ceb3dcba34969a782c4e8c5c3fe76','snapshots_tripleo',0,'2025-11-24 10:01:43',NULL),('2025-11-23 10:01:43','2025-11-23 10:01:43','2025-11-23 10:01:43',1,37,'b5c81223-ea39-4eab-98c1-fdf634c964b6',21,'9b4ff14ad14b470a96ecd244e7453fa2','snapshots',0,'2025-11-24 10:01:43',NULL),('2025-11-23 10:01:43','2025-11-23 10:01:43','2025-11-23 10:01:43',1,38,'6f6898f2-e88e-47d1-88c8-64bdea1bee6a',12,'9b4ff14ad14b470a96ecd244e7453fa2','gigabytes',0,'2025-11-24 10:01:43',NULL),('2025-11-23 10:01:43','2025-11-23 10:01:43','2025-11-23 10:01:43',1,39,'e526311b-561f-4da9-9a77-b209ffb40c5e',14,'9b4ff14ad14b470a96ecd244e7453fa2','gigabytes_tripleo',0,'2025-11-24 10:01:43',NULL),('2025-11-23 10:01:43','2025-11-23 10:01:43','2025-11-23 10:01:43',1,40,'cc1076e7-a614-41c2-a2bd-16f7c6ed837a',22,'9b4ff14ad14b470a96ecd244e7453fa2','snapshots_tripleo',0,'2025-11-24 10:01:43',NULL),('2025-11-23 10:01:44','2025-11-23 10:01:44','2025-11-23 10:01:44',1,41,'9e5f7027-7058-421f-ab81-f9fe8cc6d226',15,'2f5ceb3dcba34969a782c4e8c5c3fe76','volumes',-1,'2025-11-24 10:01:44',NULL),('2025-11-23 10:01:44','2025-11-23 10:01:44','2025-11-23 10:01:44',1,42,'02abd5e4-8a45-4975-92d6-f8c361145e3b',16,'2f5ceb3dcba34969a782c4e8c5c3fe76','gigabytes',-1,'2025-11-24 10:01:44',NULL),('2025-11-23 10:01:44','2025-11-23 10:01:44','2025-11-23 10:01:44',1,43,'6cdaf6dd-2de0-41a9-be8d-0830abae893b',17,'2f5ceb3dcba34969a782c4e8c5c3fe76','volumes_tripleo',-1,'2025-11-24 10:01:44',NULL),('2025-11-23 10:01:44','2025-11-23 10:01:44','2025-11-23 10:01:44',1,44,'132d7e18-897b-4f82-abac-f545ffe52de9',18,'2f5ceb3dcba34969a782c4e8c5c3fe76','gigabytes_tripleo',-1,'2025-11-24 10:01:44',NULL),('2025-11-23 10:01:44','2025-11-23 10:01:44','2025-11-23 10:01:44',1,45,'d9fefb82-8cf6-4215-badd-1f71cfdf7cc4',11,'9b4ff14ad14b470a96ecd244e7453fa2','volumes',1,'2025-11-24 10:01:44',NULL),('2025-11-23 10:01:44','2025-11-23 10:01:44','2025-11-23 10:01:44',1,46,'7fb79be9-ccb1-4e53-a531-b9e447b6a3f0',12,'9b4ff14ad14b470a96ecd244e7453fa2','gigabytes',1,'2025-11-24 10:01:44',NULL),('2025-11-23 10:01:44','2025-11-23 10:01:44','2025-11-23 10:01:44',1,47,'33edcaf5-083b-4d80-a79b-28f00dd055f8',13,'9b4ff14ad14b470a96ecd244e7453fa2','volumes_tripleo',1,'2025-11-24 10:01:44',NULL),('2025-11-23 10:01:44','2025-11-23 10:01:44','2025-11-23 10:01:44',1,48,'ff03b88c-50a9-4c0e-953a-2aa3c2dee770',14,'9b4ff14ad14b470a96ecd244e7453fa2','gigabytes_tripleo',1,'2025-11-24 10:01:44',NULL),('2025-11-23 10:01:46','2025-11-23 10:01:47','2025-11-23 10:01:47',1,49,'898abc7a-06ea-4f4d-9a62-f9313980df89',11,'9b4ff14ad14b470a96ecd244e7453fa2','volumes',-1,'2025-11-24 10:01:46',NULL),('2025-11-23 10:01:46','2025-11-23 10:01:47','2025-11-23 10:01:47',1,50,'aea23960-798d-43d3-8d56-00ea8c3ab0a5',12,'9b4ff14ad14b470a96ecd244e7453fa2','gigabytes',-1,'2025-11-24 10:01:46',NULL),('2025-11-23 10:01:46','2025-11-23 10:01:47','2025-11-23 10:01:47',1,51,'3c39b101-3331-4f06-8a06-3c0dd318a6fa',13,'9b4ff14ad14b470a96ecd244e7453fa2','volumes_tripleo',-1,'2025-11-24 10:01:46',NULL),('2025-11-23 10:01:46','2025-11-23 10:01:47','2025-11-23 10:01:47',1,52,'dd969834-5405-4b3d-be96-7521aaaf68f4',14,'9b4ff14ad14b470a96ecd244e7453fa2','gigabytes_tripleo',-1,'2025-11-24 10:01:46',NULL),('2025-11-23 10:01:59','2025-11-23 10:02:00','2025-11-23 10:01:59',1,53,'e026b33a-512e-4c3d-90dd-fe65d2541f75',23,'b8fa70a700964960a82c255d7f038c3d','volumes',1,'2025-11-24 10:01:59',NULL),('2025-11-23 10:01:59','2025-11-23 10:01:59','2025-11-23 10:01:59',1,54,'7b2c154c-433d-4703-992c-c46cced05d1a',24,'b8fa70a700964960a82c255d7f038c3d','gigabytes',1,'2025-11-24 10:01:59',NULL),('2025-11-23 10:01:59','2025-11-23 10:01:59','2025-11-23 10:01:59',1,55,'5b131d69-c0c0-4ee4-a902-0eaad4571577',25,'b8fa70a700964960a82c255d7f038c3d','volumes_tripleo',1,'2025-11-24 10:01:59',NULL),('2025-11-23 10:01:59','2025-11-23 10:01:59','2025-11-23 10:01:59',1,56,'90437106-1a79-40f7-908d-4545f3c1be7e',26,'b8fa70a700964960a82c255d7f038c3d','gigabytes_tripleo',1,'2025-11-24 10:01:59',NULL),('2025-11-23 10:02:01','2025-11-23 10:02:01','2025-11-23 10:02:01',1,57,'c7de3415-1ac5-4fcc-840a-ebd675afbae6',27,'4b84b07fc6534e88860c454382c4f9f4','volumes',1,'2025-11-24 10:02:01',NULL),('2025-11-23 10:02:01','2025-11-23 10:02:01','2025-11-23 10:02:01',1,58,'9f1ec3e3-e47a-4e27-8bd4-766cdf3e972e',28,'4b84b07fc6534e88860c454382c4f9f4','gigabytes',1,'2025-11-24 10:02:01',NULL),('2025-11-23 10:02:01','2025-11-23 10:02:01','2025-11-23 10:02:01',1,59,'34ed39be-c37f-48e8-96a6-6c9a1d302642',29,'4b84b07fc6534e88860c454382c4f9f4','volumes_tripleo',1,'2025-11-24 10:02:01',NULL),('2025-11-23 10:02:01','2025-11-23 10:02:01','2025-11-23 10:02:01',1,60,'59bd3115-8a4e-4330-a40e-1c22e52cf7a4',30,'4b84b07fc6534e88860c454382c4f9f4','gigabytes_tripleo',1,'2025-11-24 10:02:01',NULL),('2025-11-23 10:02:01','2025-11-23 10:02:01','2025-11-23 10:02:01',1,61,'2f862cfd-2af3-405f-ada2-34363ea45189',23,'b8fa70a700964960a82c255d7f038c3d','volumes',-1,'2025-11-24 10:02:01',NULL),('2025-11-23 10:02:01','2025-11-23 10:02:01','2025-11-23 10:02:01',1,62,'220e791c-1bd2-4e7a-bb05-fa7d119368f6',24,'b8fa70a700964960a82c255d7f038c3d','gigabytes',-1,'2025-11-24 10:02:01',NULL),('2025-11-23 10:02:01','2025-11-23 10:02:01','2025-11-23 10:02:01',1,63,'9d4824c2-9428-497e-8649-bce08deb4781',25,'b8fa70a700964960a82c255d7f038c3d','volumes_tripleo',-1,'2025-11-24 10:02:01',NULL),('2025-11-23 10:02:01','2025-11-23 10:02:01','2025-11-23 10:02:01',1,64,'b6758b93-0b2b-4669-9036-3f514abfa2af',26,'b8fa70a700964960a82c255d7f038c3d','gigabytes_tripleo',-1,'2025-11-24 10:02:01',NULL),('2025-11-23 10:02:01','2025-11-23 10:02:01','2025-11-23 10:02:01',1,65,'637afb23-ad29-4ca5-8504-b6ec0453fda1',31,'4b84b07fc6534e88860c454382c4f9f4','snapshots',0,'2025-11-24 10:02:01',NULL),('2025-11-23 10:02:01','2025-11-23 10:02:01','2025-11-23 10:02:01',1,66,'72e05ce1-cef9-4f20-931c-8a5dd43e0d74',28,'4b84b07fc6534e88860c454382c4f9f4','gigabytes',0,'2025-11-24 10:02:01',NULL),('2025-11-23 10:02:01','2025-11-23 10:02:01','2025-11-23 10:02:01',1,67,'8c154f01-28c6-450e-bb39-5a5b724d099b',30,'4b84b07fc6534e88860c454382c4f9f4','gigabytes_tripleo',0,'2025-11-24 10:02:01',NULL),('2025-11-23 10:02:01','2025-11-23 10:02:01','2025-11-23 10:02:01',1,68,'cef94427-6a23-4178-a6be-9238b06bd649',32,'4b84b07fc6534e88860c454382c4f9f4','snapshots_tripleo',0,'2025-11-24 10:02:01',NULL),('2025-11-23 10:02:01','2025-11-23 10:02:01','2025-11-23 10:02:01',1,69,'b79d881d-e108-47f4-8e57-ed76526c3bbf',33,'b8fa70a700964960a82c255d7f038c3d','snapshots',0,'2025-11-24 10:02:01',NULL),('2025-11-23 10:02:01','2025-11-23 10:02:01','2025-11-23 10:02:01',1,70,'ad3a3543-d613-4059-bcad-ea2ad17df80b',24,'b8fa70a700964960a82c255d7f038c3d','gigabytes',0,'2025-11-24 10:02:01',NULL),('2025-11-23 10:02:01','2025-11-23 10:02:01','2025-11-23 10:02:01',1,71,'8c4317e2-b778-4e61-afbd-8358efb0fa58',26,'b8fa70a700964960a82c255d7f038c3d','gigabytes_tripleo',0,'2025-11-24 10:02:01',NULL),('2025-11-23 10:02:01','2025-11-23 10:02:01','2025-11-23 10:02:01',1,72,'468a14aa-51ec-44ba-b457-58c3a76776cc',34,'b8fa70a700964960a82c255d7f038c3d','snapshots_tripleo',0,'2025-11-24 10:02:01',NULL),('2025-11-23 10:02:02','2025-11-23 10:02:02','2025-11-23 10:02:02',1,73,'87935ef6-15ab-48ed-83ed-cccc099d9b0e',27,'4b84b07fc6534e88860c454382c4f9f4','volumes',-1,'2025-11-24 10:02:02',NULL),('2025-11-23 10:02:02','2025-11-23 10:02:02','2025-11-23 10:02:02',1,74,'bc9c778b-5961-411e-a3c8-882c91e7ac67',28,'4b84b07fc6534e88860c454382c4f9f4','gigabytes',-1,'2025-11-24 10:02:02',NULL),('2025-11-23 10:02:02','2025-11-23 10:02:02','2025-11-23 10:02:02',1,75,'38edf8f8-04a6-49b3-b577-d0c5589741b0',29,'4b84b07fc6534e88860c454382c4f9f4','volumes_tripleo',-1,'2025-11-24 10:02:02',NULL),('2025-11-23 10:02:02','2025-11-23 10:02:02','2025-11-23 10:02:02',1,76,'c541dd0f-2365-45ca-98a6-bfe3a50c3d83',30,'4b84b07fc6534e88860c454382c4f9f4','gigabytes_tripleo',-1,'2025-11-24 10:02:02',NULL),('2025-11-23 10:02:03','2025-11-23 10:02:03','2025-11-23 10:02:03',1,77,'03c92335-3caf-445c-a097-85e92272a886',23,'b8fa70a700964960a82c255d7f038c3d','volumes',1,'2025-11-24 10:02:03',NULL),('2025-11-23 10:02:03','2025-11-23 10:02:03','2025-11-23 10:02:03',1,78,'baab1507-970f-4906-9ebf-13122b94f915',24,'b8fa70a700964960a82c255d7f038c3d','gigabytes',1,'2025-11-24 10:02:03',NULL),('2025-11-23 10:02:03','2025-11-23 10:02:03','2025-11-23 10:02:03',1,79,'0af75a11-293b-4e20-91b1-a9472c9e149b',25,'b8fa70a700964960a82c255d7f038c3d','volumes_tripleo',1,'2025-11-24 10:02:03',NULL),('2025-11-23 10:02:03','2025-11-23 10:02:03','2025-11-23 10:02:03',1,80,'8c565cfd-b601-48ab-845e-c5ac8e584f7a',26,'b8fa70a700964960a82c255d7f038c3d','gigabytes_tripleo',1,'2025-11-24 10:02:03',NULL),('2025-11-23 10:02:05','2025-11-23 10:02:05','2025-11-23 10:02:05',1,81,'785b04bb-b65e-4c3b-b387-9ba56d363a25',23,'b8fa70a700964960a82c255d7f038c3d','volumes',-1,'2025-11-24 10:02:05',NULL),('2025-11-23 10:02:05','2025-11-23 10:02:05','2025-11-23 10:02:05',1,82,'12760315-6f90-4cdc-8262-7a501211c949',24,'b8fa70a700964960a82c255d7f038c3d','gigabytes',-1,'2025-11-24 10:02:05',NULL),('2025-11-23 10:02:05','2025-11-23 10:02:05','2025-11-23 10:02:05',1,83,'133b3865-3111-4fca-896e-8649a69fd579',25,'b8fa70a700964960a82c255d7f038c3d','volumes_tripleo',-1,'2025-11-24 10:02:05',NULL),('2025-11-23 10:02:05','2025-11-23 10:02:05','2025-11-23 10:02:05',1,84,'affae802-3a66-4a17-a7d3-4df624b1ec6f',26,'b8fa70a700964960a82c255d7f038c3d','gigabytes_tripleo',-1,'2025-11-24 10:02:05',NULL),('2025-11-23 10:02:26','2025-11-23 10:02:26','2025-11-23 10:02:26',1,85,'04d017c0-6f63-4f03-8f5e-e6e7faa29b18',35,'10f8dd7c838246c58f1d2c4efc771237','volumes',1,'2025-11-24 10:02:26',NULL),('2025-11-23 10:02:26','2025-11-23 10:02:26','2025-11-23 10:02:26',1,86,'18b85e2f-d954-4a18-8dab-0ddcedf533f5',36,'10f8dd7c838246c58f1d2c4efc771237','gigabytes',1,'2025-11-24 10:02:26',NULL),('2025-11-23 10:02:26','2025-11-23 10:02:26','2025-11-23 10:02:26',1,87,'cb226642-199d-4d2f-82b3-4aa6a0b21e58',37,'10f8dd7c838246c58f1d2c4efc771237','volumes_tripleo',1,'2025-11-24 10:02:26',NULL),('2025-11-23 10:02:26','2025-11-23 10:02:26','2025-11-23 10:02:26',1,88,'0e14f71a-5318-4783-84ff-0e17d0800ebb',38,'10f8dd7c838246c58f1d2c4efc771237','gigabytes_tripleo',1,'2025-11-24 10:02:26',NULL),('2025-11-23 10:02:28','2025-11-23 10:02:28','2025-11-23 10:02:28',1,89,'417c940a-f575-4895-b318-6d9105ef65cc',39,'10f8dd7c838246c58f1d2c4efc771237','snapshots',1,'2025-11-24 10:02:28',NULL),('2025-11-23 10:02:28','2025-11-23 10:02:28','2025-11-23 10:02:28',1,90,'15a4b269-8aa2-4809-b4c9-2af9479fdc9c',36,'10f8dd7c838246c58f1d2c4efc771237','gigabytes',1,'2025-11-24 10:02:28',NULL),('2025-11-23 10:02:28','2025-11-23 10:02:28','2025-11-23 10:02:28',1,91,'d0097f04-fcb9-4e01-bde6-6b54c8c9dfb3',38,'10f8dd7c838246c58f1d2c4efc771237','gigabytes_tripleo',1,'2025-11-24 10:02:28',NULL),('2025-11-23 10:02:28','2025-11-23 10:02:28','2025-11-23 10:02:28',1,92,'03b3572e-4f6a-4710-bf36-07692d7244f1',40,'10f8dd7c838246c58f1d2c4efc771237','snapshots_tripleo',1,'2025-11-24 10:02:28',NULL),('2025-11-23 10:02:30','2025-11-23 10:02:30','2025-11-23 10:02:30',1,93,'68bcdfd4-b4b2-4ea8-9aeb-d49207a53f4b',41,'10f8dd7c838246c58f1d2c4efc771237','backups',1,'2025-11-24 10:02:30',NULL),('2025-11-23 10:02:30','2025-11-23 10:02:30','2025-11-23 10:02:30',1,94,'8bc7757c-8d41-43f2-9f3e-f1327c4ddfe9',42,'10f8dd7c838246c58f1d2c4efc771237','backup_gigabytes',1,'2025-11-24 10:02:30',NULL),('2025-11-23 10:02:33','2025-11-23 10:02:33','2025-11-23 10:02:33',1,95,'3b0fd4ec-655a-4026-83ef-cfdaf02746ce',43,'6af2e3709ace42c9b1e8c60ef058acf5','volumes',1,'2025-11-24 10:02:33',NULL),('2025-11-23 10:02:33','2025-11-23 10:02:33','2025-11-23 10:02:33',1,96,'2208a38f-92f8-4669-93e9-27d611eb3b5c',44,'6af2e3709ace42c9b1e8c60ef058acf5','gigabytes',1,'2025-11-24 10:02:33',NULL),('2025-11-23 10:02:33','2025-11-23 10:02:33','2025-11-23 10:02:33',1,97,'b9904570-5091-4adf-8672-0962cab729e6',45,'6af2e3709ace42c9b1e8c60ef058acf5','volumes_tripleo',1,'2025-11-24 10:02:33',NULL),('2025-11-23 10:02:33','2025-11-23 10:02:33','2025-11-23 10:02:33',1,98,'b444b9d1-d283-4d82-b0fb-f45ca9ebf5af',46,'6af2e3709ace42c9b1e8c60ef058acf5','gigabytes_tripleo',1,'2025-11-24 10:02:33',NULL),('2025-11-23 10:02:37','2025-11-23 10:02:37','2025-11-23 10:02:37',1,99,'0b6ecf8d-8628-40ac-b355-c28f48f75b14',43,'6af2e3709ace42c9b1e8c60ef058acf5','volumes',-1,'2025-11-24 10:02:37',NULL),('2025-11-23 10:02:37','2025-11-23 10:02:37','2025-11-23 10:02:37',1,100,'40f0579b-1312-4cd2-8066-8dcdb287c67a',44,'6af2e3709ace42c9b1e8c60ef058acf5','gigabytes',-1,'2025-11-24 10:02:37',NULL),('2025-11-23 10:02:37','2025-11-23 10:02:37','2025-11-23 10:02:37',1,101,'1a1de8c6-cfc6-41c8-a095-e9b9a6a8fc95',45,'6af2e3709ace42c9b1e8c60ef058acf5','volumes_tripleo',-1,'2025-11-24 10:02:37',NULL),('2025-11-23 10:02:37','2025-11-23 10:02:37','2025-11-23 10:02:37',1,102,'07b82aa0-1b93-4ec2-9904-1b08e33786f7',46,'6af2e3709ace42c9b1e8c60ef058acf5','gigabytes_tripleo',-1,'2025-11-24 10:02:37',NULL),('2025-11-23 10:02:46','2025-11-23 10:02:46','2025-11-23 10:02:46',1,103,'24cb9a29-75f7-4970-b230-c4ed815232f5',47,'6d43b7d88e884e6d87abed93a63f5ca0','volumes',1,'2025-11-24 10:02:46',NULL),('2025-11-23 10:02:46','2025-11-23 10:02:46','2025-11-23 10:02:46',1,104,'df8c0201-9bbf-4f77-a880-e40a3e7be648',48,'6d43b7d88e884e6d87abed93a63f5ca0','gigabytes',1,'2025-11-24 10:02:46',NULL),('2025-11-23 10:02:46','2025-11-23 10:02:46','2025-11-23 10:02:46',1,105,'6eb1dd69-c6b5-4268-a5c4-ed512ec1ef24',49,'6d43b7d88e884e6d87abed93a63f5ca0','volumes_tripleo',1,'2025-11-24 10:02:46',NULL),('2025-11-23 10:02:46','2025-11-23 10:02:46','2025-11-23 10:02:46',1,106,'809d3a09-7ed8-4814-81d0-11ae0da089e9',50,'6d43b7d88e884e6d87abed93a63f5ca0','gigabytes_tripleo',1,'2025-11-24 10:02:46',NULL),('2025-11-23 10:02:47','2025-11-23 10:02:48','2025-11-23 10:02:48',1,107,'e2f86551-2d54-4e40-a4cb-41cf97eb758a',47,'6d43b7d88e884e6d87abed93a63f5ca0','volumes',1,'2025-11-24 10:02:47',NULL),('2025-11-23 10:02:47','2025-11-23 10:02:48','2025-11-23 10:02:48',1,108,'3687a5b6-fb44-4c46-b4ff-e764a5344072',48,'6d43b7d88e884e6d87abed93a63f5ca0','gigabytes',1,'2025-11-24 10:02:47',NULL),('2025-11-23 10:02:47','2025-11-23 10:02:48','2025-11-23 10:02:48',1,109,'800582f4-04f2-4703-9018-30ca3b4d18d3',49,'6d43b7d88e884e6d87abed93a63f5ca0','volumes_tripleo',1,'2025-11-24 10:02:47',NULL),('2025-11-23 10:02:47','2025-11-23 10:02:48','2025-11-23 10:02:48',1,110,'c740e86c-f45c-486d-a25f-4cb178506a7e',50,'6d43b7d88e884e6d87abed93a63f5ca0','gigabytes_tripleo',1,'2025-11-24 10:02:47',NULL),('2025-11-23 10:02:49','2025-11-23 10:02:49','2025-11-23 10:02:49',1,111,'d8f2d716-e4cb-44d8-ad5a-6170efd801e4',47,'6d43b7d88e884e6d87abed93a63f5ca0','volumes',1,'2025-11-24 10:02:49',NULL),('2025-11-23 10:02:49','2025-11-23 10:02:49','2025-11-23 10:02:49',1,112,'a4388fda-87e1-44dc-a63f-fd0736616267',48,'6d43b7d88e884e6d87abed93a63f5ca0','gigabytes',1,'2025-11-24 10:02:49',NULL),('2025-11-23 10:02:49','2025-11-23 10:02:49','2025-11-23 10:02:49',1,113,'ce456914-285e-4718-94c2-3190a48a2ec9',49,'6d43b7d88e884e6d87abed93a63f5ca0','volumes_tripleo',1,'2025-11-24 10:02:49',NULL),('2025-11-23 10:02:49','2025-11-23 10:02:49','2025-11-23 10:02:49',1,114,'e928e893-70ea-4fe4-99cb-7f0cb520885f',50,'6d43b7d88e884e6d87abed93a63f5ca0','gigabytes_tripleo',1,'2025-11-24 10:02:49',NULL),('2025-11-23 10:02:50','2025-11-23 10:02:50','2025-11-23 10:02:50',1,115,'85789168-c647-42b8-918b-c8639b1fac7c',51,'975c2485ae874077a08f31a00a36b8e9','volumes',1,'2025-11-24 10:02:50',NULL),('2025-11-23 10:02:50','2025-11-23 10:02:50','2025-11-23 10:02:50',1,116,'0ff25057-4ab1-4b22-8982-d1c92b244974',52,'975c2485ae874077a08f31a00a36b8e9','gigabytes',1,'2025-11-24 10:02:50',NULL),('2025-11-23 10:02:50','2025-11-23 10:02:50','2025-11-23 10:02:50',1,117,'f673ed54-65b7-4d2e-b679-001a8aaf1323',53,'975c2485ae874077a08f31a00a36b8e9','volumes_tripleo',1,'2025-11-24 10:02:50',NULL),('2025-11-23 10:02:50','2025-11-23 10:02:50','2025-11-23 10:02:50',1,118,'5d7bcb95-65a6-4016-b13d-250d1801303c',54,'975c2485ae874077a08f31a00a36b8e9','gigabytes_tripleo',1,'2025-11-24 10:02:50',NULL),('2025-11-23 10:02:51','2025-11-23 10:02:51','2025-11-23 10:02:51',1,119,'ec0a5118-1e38-4beb-b90b-da92155decbc',41,'10f8dd7c838246c58f1d2c4efc771237','backups',-1,'2025-11-24 10:02:51',NULL),('2025-11-23 10:02:51','2025-11-23 10:02:51','2025-11-23 10:02:51',1,120,'689f5afe-a357-4c8a-93d1-b3dcbc6ec806',42,'10f8dd7c838246c58f1d2c4efc771237','backup_gigabytes',-1,'2025-11-24 10:02:51',NULL),('2025-11-23 10:02:53','2025-11-23 10:02:53','2025-11-23 10:02:53',1,121,'1abe3c43-4626-4acd-943d-8ba4f6eb5dda',47,'6d43b7d88e884e6d87abed93a63f5ca0','volumes',-1,'2025-11-24 10:02:53',NULL),('2025-11-23 10:02:53','2025-11-23 10:02:53','2025-11-23 10:02:53',1,122,'94f1d43f-cb44-4543-b855-3cd52cff6399',48,'6d43b7d88e884e6d87abed93a63f5ca0','gigabytes',-1,'2025-11-24 10:02:53',NULL),('2025-11-23 10:02:53','2025-11-23 10:02:53','2025-11-23 10:02:53',1,123,'95a717bf-bdbf-402f-b724-3763d4a6e20e',49,'6d43b7d88e884e6d87abed93a63f5ca0','volumes_tripleo',-1,'2025-11-24 10:02:53',NULL),('2025-11-23 10:02:53','2025-11-23 10:02:53','2025-11-23 10:02:53',1,124,'842c2958-d2e8-46a5-a19f-8a8c3a8fd44b',50,'6d43b7d88e884e6d87abed93a63f5ca0','gigabytes_tripleo',-1,'2025-11-24 10:02:53',NULL),('2025-11-23 10:02:53','2025-11-23 10:02:53','2025-11-23 10:02:53',1,125,'ba711e00-2c9c-46d4-b075-4d70c3cf16b8',51,'975c2485ae874077a08f31a00a36b8e9','volumes',-1,'2025-11-24 10:02:53',NULL),('2025-11-23 10:02:53','2025-11-23 10:02:53','2025-11-23 10:02:53',1,126,'d4a76304-23ff-4b3e-991d-6c5b28eca90d',52,'975c2485ae874077a08f31a00a36b8e9','gigabytes',-1,'2025-11-24 10:02:53',NULL),('2025-11-23 10:02:53','2025-11-23 10:02:53','2025-11-23 10:02:53',1,127,'47bd7cfc-bc47-4c36-b23f-c1190a4907a2',53,'975c2485ae874077a08f31a00a36b8e9','volumes_tripleo',-1,'2025-11-24 10:02:53',NULL),('2025-11-23 10:02:53','2025-11-23 10:02:53','2025-11-23 10:02:53',1,128,'cd1b5fe4-7c24-4483-b27e-bd0c93003254',54,'975c2485ae874077a08f31a00a36b8e9','gigabytes_tripleo',-1,'2025-11-24 10:02:53',NULL),('2025-11-23 10:02:54','2025-11-23 10:02:54','2025-11-23 10:02:54',1,129,'e2c40a17-c54c-4785-bb4d-a2a5dd244f4d',39,'10f8dd7c838246c58f1d2c4efc771237','snapshots',-1,'2025-11-24 10:02:54',NULL),('2025-11-23 10:02:54','2025-11-23 10:02:54','2025-11-23 10:02:54',1,130,'3b2d714e-8861-4584-a050-e75f8a6f5fe3',36,'10f8dd7c838246c58f1d2c4efc771237','gigabytes',-1,'2025-11-24 10:02:54',NULL),('2025-11-23 10:02:54','2025-11-23 10:02:54','2025-11-23 10:02:54',1,131,'dba506b2-4daf-4641-bf85-472df3bc1475',38,'10f8dd7c838246c58f1d2c4efc771237','gigabytes_tripleo',-1,'2025-11-24 10:02:54',NULL),('2025-11-23 10:02:54','2025-11-23 10:02:54','2025-11-23 10:02:54',1,132,'b77c5ce9-7bf3-4807-89c1-137fb9b6a1b6',40,'10f8dd7c838246c58f1d2c4efc771237','snapshots_tripleo',-1,'2025-11-24 10:02:54',NULL),('2025-11-23 10:02:54','2025-11-23 10:02:54','2025-11-23 10:02:54',1,133,'94729322-05fe-4c29-841e-311726080add',47,'6d43b7d88e884e6d87abed93a63f5ca0','volumes',-1,'2025-11-24 10:02:54',NULL),('2025-11-23 10:02:54','2025-11-23 10:02:54','2025-11-23 10:02:54',1,134,'5b0f4e62-aafc-4997-b9fc-bd3d87a3c3be',48,'6d43b7d88e884e6d87abed93a63f5ca0','gigabytes',-1,'2025-11-24 10:02:54',NULL),('2025-11-23 10:02:54','2025-11-23 10:02:54','2025-11-23 10:02:54',1,135,'65a9e93a-6587-46a4-9f99-7df20f06cd0d',49,'6d43b7d88e884e6d87abed93a63f5ca0','volumes_tripleo',-1,'2025-11-24 10:02:54',NULL),('2025-11-23 10:02:54','2025-11-23 10:02:54','2025-11-23 10:02:54',1,136,'68fbb395-23a9-4964-927a-03a53ca3ceda',50,'6d43b7d88e884e6d87abed93a63f5ca0','gigabytes_tripleo',-1,'2025-11-24 10:02:54',NULL),('2025-11-23 10:02:54','2025-11-23 10:02:55','2025-11-23 10:02:55',1,137,'7a0c74d4-4e37-4d86-a942-73e4697c11cd',39,'10f8dd7c838246c58f1d2c4efc771237','snapshots',1,'2025-11-24 10:02:54',NULL),('2025-11-23 10:02:54','2025-11-23 10:02:55','2025-11-23 10:02:55',1,138,'b5961af4-5559-4c98-88b3-66ab969e0e8e',36,'10f8dd7c838246c58f1d2c4efc771237','gigabytes',1,'2025-11-24 10:02:54',NULL),('2025-11-23 10:02:54','2025-11-23 10:02:55','2025-11-23 10:02:55',1,139,'eaee3eb5-9a03-49ad-a03e-dc9655726c83',38,'10f8dd7c838246c58f1d2c4efc771237','gigabytes_tripleo',1,'2025-11-24 10:02:54',NULL),('2025-11-23 10:02:54','2025-11-23 10:02:55','2025-11-23 10:02:55',1,140,'6db26583-2c23-4f7d-8df7-cdc3d03a9be3',40,'10f8dd7c838246c58f1d2c4efc771237','snapshots_tripleo',1,'2025-11-24 10:02:54',NULL),('2025-11-23 10:02:55','2025-11-23 10:02:55','2025-11-23 10:02:55',1,141,'9a45dd45-dfd5-48cd-a304-2a6c646ff488',47,'6d43b7d88e884e6d87abed93a63f5ca0','volumes',-1,'2025-11-24 10:02:55',NULL),('2025-11-23 10:02:55','2025-11-23 10:02:55','2025-11-23 10:02:55',1,142,'7e35d702-6d1f-4a21-a923-dd72784f8880',48,'6d43b7d88e884e6d87abed93a63f5ca0','gigabytes',-1,'2025-11-24 10:02:55',NULL),('2025-11-23 10:02:55','2025-11-23 10:02:55','2025-11-23 10:02:55',1,143,'76e8e11e-f495-4b68-b37d-8496b3adc2fd',49,'6d43b7d88e884e6d87abed93a63f5ca0','volumes_tripleo',-1,'2025-11-24 10:02:55',NULL),('2025-11-23 10:02:55','2025-11-23 10:02:55','2025-11-23 10:02:55',1,144,'f55d43ab-3af2-4008-a124-9da17cb50ab6',50,'6d43b7d88e884e6d87abed93a63f5ca0','gigabytes_tripleo',-1,'2025-11-24 10:02:55',NULL),('2025-11-23 10:02:58','2025-11-23 10:02:58','2025-11-23 10:02:58',1,145,'5ecad6af-696f-4738-bdeb-024d7eadec30',39,'10f8dd7c838246c58f1d2c4efc771237','snapshots',-1,'2025-11-24 10:02:58',NULL),('2025-11-23 10:02:58','2025-11-23 10:02:58','2025-11-23 10:02:58',1,146,'45d954ff-7d42-44b2-b4e3-1bc55d90dd79',36,'10f8dd7c838246c58f1d2c4efc771237','gigabytes',-1,'2025-11-24 10:02:58',NULL),('2025-11-23 10:02:58','2025-11-23 10:02:58','2025-11-23 10:02:58',1,147,'53981a5e-e125-40a5-bb57-4db548599df5',38,'10f8dd7c838246c58f1d2c4efc771237','gigabytes_tripleo',-1,'2025-11-24 10:02:58',NULL),('2025-11-23 10:02:58','2025-11-23 10:02:58','2025-11-23 10:02:58',1,148,'48d72d7a-3e8c-4b18-893d-fbdfb06f3de7',40,'10f8dd7c838246c58f1d2c4efc771237','snapshots_tripleo',-1,'2025-11-24 10:02:58',NULL),('2025-11-23 10:02:58','2025-11-23 10:02:58','2025-11-23 10:02:58',1,149,'4babef96-2c80-4a88-813f-d2d07f154e90',35,'10f8dd7c838246c58f1d2c4efc771237','volumes',1,'2025-11-24 10:02:58',NULL),('2025-11-23 10:02:58','2025-11-23 10:02:58','2025-11-23 10:02:58',1,150,'8da85c6e-d290-4ebd-8fee-e070ae72d092',36,'10f8dd7c838246c58f1d2c4efc771237','gigabytes',1,'2025-11-24 10:02:58',NULL),('2025-11-23 10:02:58','2025-11-23 10:02:58','2025-11-23 10:02:58',1,151,'af77b1a0-eb0a-4365-b596-3b273d0199fd',37,'10f8dd7c838246c58f1d2c4efc771237','volumes_tripleo',1,'2025-11-24 10:02:58',NULL),('2025-11-23 10:02:58','2025-11-23 10:02:58','2025-11-23 10:02:58',1,152,'8d14f7af-c972-4e4b-b8ff-ecbca5501bbe',38,'10f8dd7c838246c58f1d2c4efc771237','gigabytes_tripleo',1,'2025-11-24 10:02:58',NULL),('2025-11-23 10:02:59','2025-11-23 10:02:59','2025-11-23 10:02:59',1,153,'26e1266a-e242-492d-ac7d-bbd77d50735c',39,'10f8dd7c838246c58f1d2c4efc771237','snapshots',1,'2025-11-24 10:02:59',NULL),('2025-11-23 10:02:59','2025-11-23 10:02:59','2025-11-23 10:02:59',1,154,'03df2264-3509-4764-a58f-46e1e17d9f24',36,'10f8dd7c838246c58f1d2c4efc771237','gigabytes',1,'2025-11-24 10:02:59',NULL),('2025-11-23 10:02:59','2025-11-23 10:02:59','2025-11-23 10:02:59',1,155,'0fddf873-7746-4ade-be5d-8f1cb191f036',38,'10f8dd7c838246c58f1d2c4efc771237','gigabytes_tripleo',1,'2025-11-24 10:02:59',NULL),('2025-11-23 10:02:59','2025-11-23 10:02:59','2025-11-23 10:02:59',1,156,'61bc21cb-8d2d-4b3d-9b75-a5eb64c94f1b',40,'10f8dd7c838246c58f1d2c4efc771237','snapshots_tripleo',1,'2025-11-24 10:02:59',NULL),('2025-11-23 10:03:00','2025-11-23 10:03:00','2025-11-23 10:03:00',1,157,'db4a7c83-c3e8-4b7f-a648-00373aad7c87',35,'10f8dd7c838246c58f1d2c4efc771237','volumes',1,'2025-11-24 10:03:00',NULL),('2025-11-23 10:03:00','2025-11-23 10:03:00','2025-11-23 10:03:00',1,158,'582d0506-3c52-4373-8cb3-df300c134eb8',36,'10f8dd7c838246c58f1d2c4efc771237','gigabytes',2,'2025-11-24 10:03:00',NULL),('2025-11-23 10:03:00','2025-11-23 10:03:00','2025-11-23 10:03:00',1,159,'66d10e3a-f49d-40bc-8d77-973f8683be30',37,'10f8dd7c838246c58f1d2c4efc771237','volumes_tripleo',1,'2025-11-24 10:03:00',NULL),('2025-11-23 10:03:00','2025-11-23 10:03:00','2025-11-23 10:03:00',1,160,'efc08b77-fc55-465a-9c5d-a87b1f525305',38,'10f8dd7c838246c58f1d2c4efc771237','gigabytes_tripleo',2,'2025-11-24 10:03:00',NULL),('2025-11-23 10:03:02','2025-11-23 10:03:03','2025-11-23 10:03:03',1,161,'e18cb0e7-1f51-4551-afb7-74fe466260c5',35,'10f8dd7c838246c58f1d2c4efc771237','volumes',-1,'2025-11-24 10:03:02',NULL),('2025-11-23 10:03:02','2025-11-23 10:03:03','2025-11-23 10:03:03',1,162,'0cc3b690-28ca-4dd6-831c-5ae22bef1d87',36,'10f8dd7c838246c58f1d2c4efc771237','gigabytes',-2,'2025-11-24 10:03:02',NULL),('2025-11-23 10:03:02','2025-11-23 10:03:03','2025-11-23 10:03:03',1,163,'bcdbe75b-6154-431d-aea9-4557d1eaa4b8',37,'10f8dd7c838246c58f1d2c4efc771237','volumes_tripleo',-1,'2025-11-24 10:03:02',NULL),('2025-11-23 10:03:02','2025-11-23 10:03:03','2025-11-23 10:03:03',1,164,'17f0fa7a-1cd6-47ee-89e5-babeda2f5505',38,'10f8dd7c838246c58f1d2c4efc771237','gigabytes_tripleo',-2,'2025-11-24 10:03:02',NULL),('2025-11-23 10:03:04','2025-11-23 10:03:04','2025-11-23 10:03:04',1,165,'0bae3d60-714b-47f7-b678-f9495c3422fd',39,'10f8dd7c838246c58f1d2c4efc771237','snapshots',-1,'2025-11-24 10:03:04',NULL),('2025-11-23 10:03:04','2025-11-23 10:03:04','2025-11-23 10:03:04',1,166,'e38f7afc-188a-432e-9c5d-8d3af21a76a9',36,'10f8dd7c838246c58f1d2c4efc771237','gigabytes',-1,'2025-11-24 10:03:04',NULL),('2025-11-23 10:03:04','2025-11-23 10:03:04','2025-11-23 10:03:04',1,167,'744531a1-6a61-436a-b6b3-3eeee2c129aa',38,'10f8dd7c838246c58f1d2c4efc771237','gigabytes_tripleo',-1,'2025-11-24 10:03:04',NULL),('2025-11-23 10:03:04','2025-11-23 10:03:04','2025-11-23 10:03:04',1,168,'a46d0e95-1cd7-4c42-8cdc-b991ff9fa824',40,'10f8dd7c838246c58f1d2c4efc771237','snapshots_tripleo',-1,'2025-11-24 10:03:04',NULL),('2025-11-23 10:03:05','2025-11-23 10:03:05','2025-11-23 10:03:05',1,169,'42ec888e-64b9-4f81-8540-1cf63c85c8cc',35,'10f8dd7c838246c58f1d2c4efc771237','volumes',-1,'2025-11-24 10:03:05',NULL),('2025-11-23 10:03:05','2025-11-23 10:03:05','2025-11-23 10:03:05',1,170,'8d3872d7-3f4b-4b8d-8fc4-b0d5b9f16d6b',36,'10f8dd7c838246c58f1d2c4efc771237','gigabytes',-1,'2025-11-24 10:03:05',NULL),('2025-11-23 10:03:05','2025-11-23 10:03:05','2025-11-23 10:03:05',1,171,'76112b23-a7e7-4fd1-9386-133ec07605d0',37,'10f8dd7c838246c58f1d2c4efc771237','volumes_tripleo',-1,'2025-11-24 10:03:05',NULL),('2025-11-23 10:03:05','2025-11-23 10:03:05','2025-11-23 10:03:05',1,172,'8be1d7fd-df76-4000-80aa-e903e926549c',38,'10f8dd7c838246c58f1d2c4efc771237','gigabytes_tripleo',-1,'2025-11-24 10:03:05',NULL),('2025-11-23 10:03:05','2025-11-23 10:03:05','2025-11-23 10:03:05',1,173,'c765840d-688e-45a7-8fdd-73cf1ee3ec48',35,'10f8dd7c838246c58f1d2c4efc771237','volumes',1,'2025-11-24 10:03:05',NULL),('2025-11-23 10:03:05','2025-11-23 10:03:05','2025-11-23 10:03:05',1,174,'c5372511-c965-4c94-859e-b9ee1bfeea8c',36,'10f8dd7c838246c58f1d2c4efc771237','gigabytes',1,'2025-11-24 10:03:05',NULL),('2025-11-23 10:03:05','2025-11-23 10:03:05','2025-11-23 10:03:05',1,175,'8bacafd6-0bd7-4825-90ba-235bdb8f2438',37,'10f8dd7c838246c58f1d2c4efc771237','volumes_tripleo',1,'2025-11-24 10:03:05',NULL),('2025-11-23 10:03:05','2025-11-23 10:03:05','2025-11-23 10:03:05',1,176,'0b1e0df0-6a0a-4583-ab96-57c3b507abff',38,'10f8dd7c838246c58f1d2c4efc771237','gigabytes_tripleo',1,'2025-11-24 10:03:05',NULL),('2025-11-23 10:03:07','2025-11-23 10:03:07','2025-11-23 10:03:07',1,177,'db188ea2-27b8-4d2e-a44c-b1a4bfcfe7e9',39,'10f8dd7c838246c58f1d2c4efc771237','snapshots',1,'2025-11-24 10:03:07',NULL),('2025-11-23 10:03:07','2025-11-23 10:03:07','2025-11-23 10:03:07',1,178,'03b53fa0-730a-4093-95d6-718972f03ff1',36,'10f8dd7c838246c58f1d2c4efc771237','gigabytes',1,'2025-11-24 10:03:07',NULL),('2025-11-23 10:03:07','2025-11-23 10:03:07','2025-11-23 10:03:07',1,179,'af8a0ca8-f4a8-4b5f-808a-df2a949f85d6',38,'10f8dd7c838246c58f1d2c4efc771237','gigabytes_tripleo',1,'2025-11-24 10:03:07',NULL),('2025-11-23 10:03:07','2025-11-23 10:03:07','2025-11-23 10:03:07',1,180,'381f7b72-9fd3-4f42-930b-7e3b7b63b2b2',40,'10f8dd7c838246c58f1d2c4efc771237','snapshots_tripleo',1,'2025-11-24 10:03:07',NULL),('2025-11-23 10:03:08','2025-11-23 10:03:08','2025-11-23 10:03:08',1,181,'5d1d9188-0e97-4240-bc6f-c07eb8034ca1',35,'10f8dd7c838246c58f1d2c4efc771237','volumes',1,'2025-11-24 10:03:08',NULL),('2025-11-23 10:03:08','2025-11-23 10:03:08','2025-11-23 10:03:08',1,182,'6053e52a-3376-407d-90d0-07b324150a64',36,'10f8dd7c838246c58f1d2c4efc771237','gigabytes',1,'2025-11-24 10:03:08',NULL),('2025-11-23 10:03:08','2025-11-23 10:03:08','2025-11-23 10:03:08',1,183,'1cbaa13e-05a1-4f4f-a0ee-5a3377e20688',37,'10f8dd7c838246c58f1d2c4efc771237','volumes_tripleo',1,'2025-11-24 10:03:08',NULL),('2025-11-23 10:03:08','2025-11-23 10:03:08','2025-11-23 10:03:08',1,184,'1cd75492-6972-43ae-8101-c0bf615972b2',38,'10f8dd7c838246c58f1d2c4efc771237','gigabytes_tripleo',1,'2025-11-24 10:03:08',NULL),('2025-11-23 10:03:09','2025-11-23 10:03:09','2025-11-23 10:03:09',1,185,'c5bf5ab9-d4ce-4172-8893-cf8cf4dff938',55,'9d635cb23eed4c8795c7c085f175d605','groups',1,'2025-11-24 10:03:09',NULL),('2025-11-23 10:03:10','2025-11-23 10:03:10','2025-11-23 10:03:10',1,186,'4e287580-9559-4831-88c6-92011462e98d',35,'10f8dd7c838246c58f1d2c4efc771237','volumes',-1,'2025-11-24 10:03:10',NULL),('2025-11-23 10:03:10','2025-11-23 10:03:10','2025-11-23 10:03:10',1,187,'7ab4fd8a-5cb9-42a2-b979-d08847dde8c4',36,'10f8dd7c838246c58f1d2c4efc771237','gigabytes',-1,'2025-11-24 10:03:10',NULL),('2025-11-23 10:03:10','2025-11-23 10:03:10','2025-11-23 10:03:10',1,188,'fb67a2d9-188d-4942-8305-9d48002cbbc5',37,'10f8dd7c838246c58f1d2c4efc771237','volumes_tripleo',-1,'2025-11-24 10:03:10',NULL),('2025-11-23 10:03:10','2025-11-23 10:03:10','2025-11-23 10:03:10',1,189,'343ea6ab-a347-499e-a3bc-b1d6d5d97d33',38,'10f8dd7c838246c58f1d2c4efc771237','gigabytes_tripleo',-1,'2025-11-24 10:03:10',NULL),('2025-11-23 10:03:10','2025-11-23 10:03:10','2025-11-23 10:03:10',1,190,'78a777a6-ae0f-4b1e-86b8-d67f7e077c28',56,'9d635cb23eed4c8795c7c085f175d605','volumes',1,'2025-11-24 10:03:10',NULL),('2025-11-23 10:03:10','2025-11-23 10:03:10','2025-11-23 10:03:10',1,191,'80f2b661-8c9d-4e59-b63a-74d8de6f4e2d',57,'9d635cb23eed4c8795c7c085f175d605','gigabytes',1,'2025-11-24 10:03:10',NULL),('2025-11-23 10:03:10','2025-11-23 10:03:10','2025-11-23 10:03:10',1,192,'32386e03-5891-40ad-9652-948abadef2da',58,'9d635cb23eed4c8795c7c085f175d605','volumes_tempest-GroupSnapshotsTest-volume-type-1819188790',1,'2025-11-24 10:03:10',NULL),('2025-11-23 10:03:10','2025-11-23 10:03:10','2025-11-23 10:03:10',1,193,'a09fead7-830c-4909-b8da-051c62a57aa9',59,'9d635cb23eed4c8795c7c085f175d605','gigabytes_tempest-GroupSnapshotsTest-volume-type-1819188790',1,'2025-11-24 10:03:10',NULL),('2025-11-23 10:03:12','2025-11-23 10:03:12','2025-11-23 10:03:12',1,194,'aaa18c4a-ec2a-4687-84a7-06e7078425f9',39,'10f8dd7c838246c58f1d2c4efc771237','snapshots',-1,'2025-11-24 10:03:12',NULL),('2025-11-23 10:03:12','2025-11-23 10:03:12','2025-11-23 10:03:12',1,195,'95d0391d-7b25-4da4-b101-d19b6c479274',36,'10f8dd7c838246c58f1d2c4efc771237','gigabytes',-1,'2025-11-24 10:03:12',NULL),('2025-11-23 10:03:12','2025-11-23 10:03:12','2025-11-23 10:03:12',1,196,'d2e46324-cb9f-46b8-a493-1264cd31373b',38,'10f8dd7c838246c58f1d2c4efc771237','gigabytes_tripleo',-1,'2025-11-24 10:03:12',NULL),('2025-11-23 10:03:12','2025-11-23 10:03:12','2025-11-23 10:03:12',1,197,'697370cb-7371-4c33-8b22-a102268037c9',40,'10f8dd7c838246c58f1d2c4efc771237','snapshots_tripleo',-1,'2025-11-24 10:03:12',NULL),('2025-11-23 10:03:12','2025-11-23 10:03:12','2025-11-23 10:03:12',1,198,'22f8b77d-0e25-4cb9-a3a3-32f1a5ff229b',60,'9d635cb23eed4c8795c7c085f175d605','snapshots',1,'2025-11-24 10:03:12',NULL),('2025-11-23 10:03:12','2025-11-23 10:03:12','2025-11-23 10:03:12',1,199,'cc8726a8-6fea-4df9-9a44-ac5b4a8f66a9',57,'9d635cb23eed4c8795c7c085f175d605','gigabytes',1,'2025-11-24 10:03:12',NULL),('2025-11-23 10:03:12','2025-11-23 10:03:12','2025-11-23 10:03:12',1,200,'652494ea-a51c-4b5c-bae9-c273e067e803',59,'9d635cb23eed4c8795c7c085f175d605','gigabytes_tempest-GroupSnapshotsTest-volume-type-1819188790',1,'2025-11-24 10:03:12',NULL),('2025-11-23 10:03:12','2025-11-23 10:03:12','2025-11-23 10:03:12',1,201,'ccc53c24-8b4b-4c68-8bbc-e5408596b5b0',61,'9d635cb23eed4c8795c7c085f175d605','snapshots_tempest-GroupSnapshotsTest-volume-type-1819188790',1,'2025-11-24 10:03:12',NULL),('2025-11-23 10:03:13','2025-11-23 10:03:13','2025-11-23 10:03:13',1,202,'21bef08c-8410-4b2d-b6f5-73dcecaff0fa',55,'9d635cb23eed4c8795c7c085f175d605','groups',1,'2025-11-24 10:03:13',NULL),('2025-11-23 10:03:13','2025-11-23 10:03:13','2025-11-23 10:03:13',1,203,'2b917a2b-cf04-4a08-b36c-09d393ce029e',56,'9d635cb23eed4c8795c7c085f175d605','volumes',1,'2025-11-24 10:03:13',NULL),('2025-11-23 10:03:13','2025-11-23 10:03:13','2025-11-23 10:03:13',1,204,'cb6e4d74-636a-4ba2-867d-ea2417a0370a',58,'9d635cb23eed4c8795c7c085f175d605','volumes_tempest-GroupSnapshotsTest-volume-type-1819188790',1,'2025-11-24 10:03:13',NULL),('2025-11-23 10:03:13','2025-11-23 10:03:13','2025-11-23 10:03:13',1,205,'f476594c-3e36-4ea0-8e3f-5154a6826d11',35,'10f8dd7c838246c58f1d2c4efc771237','volumes',-1,'2025-11-24 10:03:13',NULL),('2025-11-23 10:03:13','2025-11-23 10:03:13','2025-11-23 10:03:13',1,206,'01764960-ff0a-4219-87da-d8714b7197ee',36,'10f8dd7c838246c58f1d2c4efc771237','gigabytes',-1,'2025-11-24 10:03:13',NULL),('2025-11-23 10:03:13','2025-11-23 10:03:13','2025-11-23 10:03:13',1,207,'3713cfe7-8abb-4ef4-b279-d31919f1a5cd',37,'10f8dd7c838246c58f1d2c4efc771237','volumes_tripleo',-1,'2025-11-24 10:03:13',NULL),('2025-11-23 10:03:13','2025-11-23 10:03:13','2025-11-23 10:03:13',1,208,'314d2008-d5e7-42a9-a1a2-7b78529c33bf',38,'10f8dd7c838246c58f1d2c4efc771237','gigabytes_tripleo',-1,'2025-11-24 10:03:13',NULL),('2025-11-23 10:03:14','2025-11-23 10:03:14','2025-11-23 10:03:14',1,209,'447e0902-7222-4018-8c05-edabf5fb9455',35,'10f8dd7c838246c58f1d2c4efc771237','volumes',-1,'2025-11-24 10:03:14',NULL),('2025-11-23 10:03:14','2025-11-23 10:03:14','2025-11-23 10:03:14',1,210,'b91b178b-43a0-4d88-bebf-9ecc778f0553',36,'10f8dd7c838246c58f1d2c4efc771237','gigabytes',-1,'2025-11-24 10:03:14',NULL),('2025-11-23 10:03:14','2025-11-23 10:03:14','2025-11-23 10:03:14',1,211,'2f6d7573-6f7d-4514-bf47-f6272f5a22ae',37,'10f8dd7c838246c58f1d2c4efc771237','volumes_tripleo',-1,'2025-11-24 10:03:14',NULL),('2025-11-23 10:03:14','2025-11-23 10:03:14','2025-11-23 10:03:14',1,212,'370cf9cc-26e3-4b80-a20f-eeb3dcfed8f5',38,'10f8dd7c838246c58f1d2c4efc771237','gigabytes_tripleo',-1,'2025-11-24 10:03:14',NULL),('2025-11-23 10:03:15','2025-11-23 10:03:15','2025-11-23 10:03:15',1,213,'b301e5ca-153e-4d90-bd54-d6b42a5aff77',55,'9d635cb23eed4c8795c7c085f175d605','groups',-1,'2025-11-24 10:03:15',NULL),('2025-11-23 10:03:15','2025-11-23 10:03:15','2025-11-23 10:03:15',1,214,'2448666d-7d9c-4829-8e96-905eb332a75b',56,'9d635cb23eed4c8795c7c085f175d605','volumes',-1,'2025-11-24 10:03:15',NULL),('2025-11-23 10:03:15','2025-11-23 10:03:15','2025-11-23 10:03:15',1,215,'e0eea195-d3be-4454-81b2-2294c356dbe5',57,'9d635cb23eed4c8795c7c085f175d605','gigabytes',-1,'2025-11-24 10:03:15',NULL),('2025-11-23 10:03:15','2025-11-23 10:03:15','2025-11-23 10:03:15',1,216,'45c90627-d19a-4245-8d79-1e55bd2dbd81',58,'9d635cb23eed4c8795c7c085f175d605','volumes_tempest-GroupSnapshotsTest-volume-type-1819188790',-1,'2025-11-24 10:03:15',NULL),('2025-11-23 10:03:15','2025-11-23 10:03:15','2025-11-23 10:03:15',1,217,'d29972b1-57cb-4df4-b2d6-4febdd068c55',59,'9d635cb23eed4c8795c7c085f175d605','gigabytes_tempest-GroupSnapshotsTest-volume-type-1819188790',-1,'2025-11-24 10:03:15',NULL),('2025-11-23 10:03:17','2025-11-23 10:03:17','2025-11-23 10:03:17',1,218,'5d86d3a0-aaf3-48ed-862e-1d319c111814',60,'9d635cb23eed4c8795c7c085f175d605','snapshots',-1,'2025-11-24 10:03:17',NULL),('2025-11-23 10:03:17','2025-11-23 10:03:17','2025-11-23 10:03:17',1,219,'575839aa-27cd-433b-b289-acffecf4e8fb',57,'9d635cb23eed4c8795c7c085f175d605','gigabytes',-1,'2025-11-24 10:03:17',NULL),('2025-11-23 10:03:17','2025-11-23 10:03:17','2025-11-23 10:03:17',1,220,'d11e09c6-2c8c-4f94-8841-2eed7abe6091',59,'9d635cb23eed4c8795c7c085f175d605','gigabytes_tempest-GroupSnapshotsTest-volume-type-1819188790',-1,'2025-11-24 10:03:17',NULL),('2025-11-23 10:03:17','2025-11-23 10:03:17','2025-11-23 10:03:17',1,221,'cb52c8b3-3bfa-4b74-910f-3d910eb1a2d8',61,'9d635cb23eed4c8795c7c085f175d605','snapshots_tempest-GroupSnapshotsTest-volume-type-1819188790',-1,'2025-11-24 10:03:17',NULL),('2025-11-23 10:03:19','2025-11-23 10:03:19','2025-11-23 10:03:19',1,222,'7aa24f2a-d3ca-4b25-bdb4-14ecfc60db13',62,'49ebd7a691dd4ea59ffbe9f5703e77e4','volumes',1,'2025-11-24 10:03:19',NULL),('2025-11-23 10:03:19','2025-11-23 10:03:19','2025-11-23 10:03:19',1,223,'3e53037c-8a37-40bc-a545-e268c4216be5',63,'49ebd7a691dd4ea59ffbe9f5703e77e4','gigabytes',1,'2025-11-24 10:03:19',NULL),('2025-11-23 10:03:19','2025-11-23 10:03:19','2025-11-23 10:03:19',1,224,'57e89f31-e6ca-4a54-918e-c04f83a7d4ce',64,'49ebd7a691dd4ea59ffbe9f5703e77e4','volumes_tripleo',1,'2025-11-24 10:03:19',NULL),('2025-11-23 10:03:19','2025-11-23 10:03:19','2025-11-23 10:03:19',1,225,'8b5f6a19-6e72-40be-a804-7aec09034f48',65,'49ebd7a691dd4ea59ffbe9f5703e77e4','gigabytes_tripleo',1,'2025-11-24 10:03:19',NULL),('2025-11-23 10:03:19','2025-11-23 10:03:19','2025-11-23 10:03:19',1,226,'b3bad6d0-2046-4167-b7fd-4f587725f9aa',55,'9d635cb23eed4c8795c7c085f175d605','groups',-1,'2025-11-24 10:03:19',NULL),('2025-11-23 10:03:19','2025-11-23 10:03:19','2025-11-23 10:03:19',1,227,'3c384960-ea45-4462-81bc-f18706782f2e',56,'9d635cb23eed4c8795c7c085f175d605','volumes',-1,'2025-11-24 10:03:19',NULL),('2025-11-23 10:03:19','2025-11-23 10:03:19','2025-11-23 10:03:19',1,228,'7ba7a106-ec6e-49c7-94dd-6c3fd222a87d',57,'9d635cb23eed4c8795c7c085f175d605','gigabytes',-1,'2025-11-24 10:03:19',NULL),('2025-11-23 10:03:19','2025-11-23 10:03:19','2025-11-23 10:03:19',1,229,'27083235-e805-4fb2-a7bb-e0bc52d07525',58,'9d635cb23eed4c8795c7c085f175d605','volumes_tempest-GroupSnapshotsTest-volume-type-1819188790',-1,'2025-11-24 10:03:19',NULL),('2025-11-23 10:03:19','2025-11-23 10:03:19','2025-11-23 10:03:19',1,230,'eed8ba3b-a898-4ccd-855c-626ed73d2c2b',59,'9d635cb23eed4c8795c7c085f175d605','gigabytes_tempest-GroupSnapshotsTest-volume-type-1819188790',-1,'2025-11-24 10:03:19',NULL),('2025-11-23 10:03:20','2025-11-23 10:03:20','2025-11-23 10:03:20',1,231,'136dab3a-a02d-4793-b59b-c1146ec7afdf',55,'9d635cb23eed4c8795c7c085f175d605','groups',1,'2025-11-24 10:03:20',NULL),('2025-11-23 10:03:22','2025-11-23 10:03:22','2025-11-23 10:03:22',1,232,'529e440a-3930-4ccb-a5e2-5f2f6d67128f',56,'9d635cb23eed4c8795c7c085f175d605','volumes',1,'2025-11-24 10:03:22',NULL),('2025-11-23 10:03:22','2025-11-23 10:03:22','2025-11-23 10:03:22',1,233,'28131674-28ff-4a13-8a08-f1d5dae65540',57,'9d635cb23eed4c8795c7c085f175d605','gigabytes',1,'2025-11-24 10:03:22',NULL),('2025-11-23 10:03:22','2025-11-23 10:03:22','2025-11-23 10:03:22',1,234,'3433be02-cde0-4210-88f4-8b74dbeffbb0',66,'9d635cb23eed4c8795c7c085f175d605','volumes_tempest-GroupSnapshotsTest-volume-type-175069716',1,'2025-11-24 10:03:22',NULL),('2025-11-23 10:03:22','2025-11-23 10:03:22','2025-11-23 10:03:22',1,235,'693a1971-6cfe-433a-9395-0e51a413daf2',67,'9d635cb23eed4c8795c7c085f175d605','gigabytes_tempest-GroupSnapshotsTest-volume-type-175069716',1,'2025-11-24 10:03:22',NULL),('2025-11-23 10:03:23','2025-11-23 10:03:23','2025-11-23 10:03:23',1,236,'9cda8767-f751-422e-8a64-85e376abcf9b',56,'9d635cb23eed4c8795c7c085f175d605','volumes',1,'2025-11-24 10:03:23',NULL),('2025-11-23 10:03:23','2025-11-23 10:03:23','2025-11-23 10:03:23',1,237,'e737397e-f27a-4da8-9f1f-0840392d0020',57,'9d635cb23eed4c8795c7c085f175d605','gigabytes',1,'2025-11-24 10:03:23',NULL),('2025-11-23 10:03:23','2025-11-23 10:03:23','2025-11-23 10:03:23',1,238,'ab3923cd-886a-469f-8899-569eb849001c',66,'9d635cb23eed4c8795c7c085f175d605','volumes_tempest-GroupSnapshotsTest-volume-type-175069716',1,'2025-11-24 10:03:23',NULL),('2025-11-23 10:03:23','2025-11-23 10:03:23','2025-11-23 10:03:23',1,239,'ac5be13e-b3fb-4b73-b212-7e8abe699841',67,'9d635cb23eed4c8795c7c085f175d605','gigabytes_tempest-GroupSnapshotsTest-volume-type-175069716',1,'2025-11-24 10:03:23',NULL),('2025-11-23 10:03:25','2025-11-23 10:03:25','2025-11-23 10:03:25',1,240,'4ea5d95b-8abf-44c0-8bdc-4509f5fff142',68,'49ebd7a691dd4ea59ffbe9f5703e77e4','backups',1,'2025-11-24 10:03:25',NULL),('2025-11-23 10:03:25','2025-11-23 10:03:25','2025-11-23 10:03:25',1,241,'ee9b1b0a-9774-4975-84d2-b5af644148c8',69,'49ebd7a691dd4ea59ffbe9f5703e77e4','backup_gigabytes',1,'2025-11-24 10:03:25',NULL),('2025-11-23 10:03:29','2025-11-23 10:03:29','2025-11-23 10:03:29',1,242,'14053d5b-4432-428d-9439-898fde917e94',60,'9d635cb23eed4c8795c7c085f175d605','snapshots',2,'2025-11-24 10:03:29',NULL),('2025-11-23 10:03:29','2025-11-23 10:03:29','2025-11-23 10:03:29',1,243,'bda6bc07-052e-4402-9cc5-ad92568c6f8a',57,'9d635cb23eed4c8795c7c085f175d605','gigabytes',2,'2025-11-24 10:03:29',NULL),('2025-11-23 10:03:29','2025-11-23 10:03:29','2025-11-23 10:03:29',1,244,'3d1e70c8-450f-4b22-ae76-5e5f39223a75',67,'9d635cb23eed4c8795c7c085f175d605','gigabytes_tempest-GroupSnapshotsTest-volume-type-175069716',2,'2025-11-24 10:03:29',NULL),('2025-11-23 10:03:29','2025-11-23 10:03:29','2025-11-23 10:03:29',1,245,'ddb79df7-49bc-4c41-8bb6-344c87b551c2',70,'9d635cb23eed4c8795c7c085f175d605','snapshots_tempest-GroupSnapshotsTest-volume-type-175069716',2,'2025-11-24 10:03:29',NULL),('2025-11-23 10:03:30','2025-11-23 10:03:30','2025-11-23 10:03:30',1,246,'21b14420-7999-4fa5-ba36-d02a34122299',62,'49ebd7a691dd4ea59ffbe9f5703e77e4','volumes',1,'2025-11-24 10:03:30',NULL),('2025-11-23 10:03:30','2025-11-23 10:03:30','2025-11-23 10:03:30',1,247,'0bce45d5-3127-470a-a53f-5f3aba8fdf98',63,'49ebd7a691dd4ea59ffbe9f5703e77e4','gigabytes',1,'2025-11-24 10:03:30',NULL),('2025-11-23 10:03:30','2025-11-23 10:03:30','2025-11-23 10:03:30',1,248,'a5b8487a-efb3-4028-abae-afe986e7746d',64,'49ebd7a691dd4ea59ffbe9f5703e77e4','volumes_tripleo',1,'2025-11-24 10:03:30',NULL),('2025-11-23 10:03:30','2025-11-23 10:03:30','2025-11-23 10:03:30',1,249,'f1bba219-f0b0-4967-9ebe-1967eafa04bc',65,'49ebd7a691dd4ea59ffbe9f5703e77e4','gigabytes_tripleo',1,'2025-11-24 10:03:30',NULL),('2025-11-23 10:03:34','2025-11-23 10:03:34','2025-11-23 10:03:34',1,250,'26dbcd0e-61a1-4ad6-972b-d0cc51edb977',60,'9d635cb23eed4c8795c7c085f175d605','snapshots',-1,'2025-11-24 10:03:34',NULL),('2025-11-23 10:03:34','2025-11-23 10:03:34','2025-11-23 10:03:34',1,251,'523ffab0-84b2-4150-8f17-c9fa5c3323e6',57,'9d635cb23eed4c8795c7c085f175d605','gigabytes',-1,'2025-11-24 10:03:34',NULL),('2025-11-23 10:03:34','2025-11-23 10:03:34','2025-11-23 10:03:34',1,252,'32ee7547-b655-406f-aa35-20b88191c8da',67,'9d635cb23eed4c8795c7c085f175d605','gigabytes_tempest-GroupSnapshotsTest-volume-type-175069716',-1,'2025-11-24 10:03:34',NULL),('2025-11-23 10:03:34','2025-11-23 10:03:34','2025-11-23 10:03:34',1,253,'932b2673-7fad-48e8-b177-e610e20b9c92',70,'9d635cb23eed4c8795c7c085f175d605','snapshots_tempest-GroupSnapshotsTest-volume-type-175069716',-1,'2025-11-24 10:03:34',NULL),('2025-11-23 10:03:34','2025-11-23 10:03:34','2025-11-23 10:03:34',1,254,'10fd146d-675e-4ab7-853e-f4f9c7003208',60,'9d635cb23eed4c8795c7c085f175d605','snapshots',-1,'2025-11-24 10:03:34',NULL),('2025-11-23 10:03:34','2025-11-23 10:03:34','2025-11-23 10:03:34',1,255,'93e5f089-053f-4823-b68e-9d5a0f732730',57,'9d635cb23eed4c8795c7c085f175d605','gigabytes',-1,'2025-11-24 10:03:34',NULL),('2025-11-23 10:03:34','2025-11-23 10:03:34','2025-11-23 10:03:34',1,256,'d46fc862-ef6a-41b7-b6b0-7b15b8b59a17',67,'9d635cb23eed4c8795c7c085f175d605','gigabytes_tempest-GroupSnapshotsTest-volume-type-175069716',-1,'2025-11-24 10:03:34',NULL),('2025-11-23 10:03:34','2025-11-23 10:03:34','2025-11-23 10:03:34',1,257,'ff283e6b-bb90-4b31-b3d3-38766ae4fcaf',70,'9d635cb23eed4c8795c7c085f175d605','snapshots_tempest-GroupSnapshotsTest-volume-type-175069716',-1,'2025-11-24 10:03:34',NULL),('2025-11-23 10:03:35','2025-11-23 10:03:35','2025-11-23 10:03:35',1,258,'8917f493-50fa-49a6-99c6-98fd2128216d',62,'49ebd7a691dd4ea59ffbe9f5703e77e4','volumes',-1,'2025-11-24 10:03:35',NULL),('2025-11-23 10:03:35','2025-11-23 10:03:35','2025-11-23 10:03:35',1,259,'017dcf23-fa02-48d5-87ea-defd9e72944d',63,'49ebd7a691dd4ea59ffbe9f5703e77e4','gigabytes',-1,'2025-11-24 10:03:35',NULL),('2025-11-23 10:03:35','2025-11-23 10:03:35','2025-11-23 10:03:35',1,260,'c1808394-e2bf-4e90-8635-62125c096a92',64,'49ebd7a691dd4ea59ffbe9f5703e77e4','volumes_tripleo',-1,'2025-11-24 10:03:35',NULL),('2025-11-23 10:03:35','2025-11-23 10:03:35','2025-11-23 10:03:35',1,261,'09d16e84-623b-4fea-9972-83e2384f1968',65,'49ebd7a691dd4ea59ffbe9f5703e77e4','gigabytes_tripleo',-1,'2025-11-24 10:03:35',NULL),('2025-11-23 10:03:36','2025-11-23 10:03:37','2025-11-23 10:03:37',1,262,'450c49a1-5bcf-459f-ab91-8b73433e0264',55,'9d635cb23eed4c8795c7c085f175d605','groups',-1,'2025-11-24 10:03:36',NULL),('2025-11-23 10:03:37','2025-11-23 10:03:37','2025-11-23 10:03:37',1,263,'3365581d-ef5f-4454-a943-db1efe972e52',56,'9d635cb23eed4c8795c7c085f175d605','volumes',-1,'2025-11-24 10:03:36',NULL),('2025-11-23 10:03:37','2025-11-23 10:03:37','2025-11-23 10:03:37',1,264,'14d625b8-7971-4e4f-bdf2-fc217ee37e35',57,'9d635cb23eed4c8795c7c085f175d605','gigabytes',-1,'2025-11-24 10:03:36',NULL),('2025-11-23 10:03:37','2025-11-23 10:03:37','2025-11-23 10:03:37',1,265,'16e520d6-8165-497c-96c0-f9342240ba4c',66,'9d635cb23eed4c8795c7c085f175d605','volumes_tempest-GroupSnapshotsTest-volume-type-175069716',-1,'2025-11-24 10:03:36',NULL),('2025-11-23 10:03:37','2025-11-23 10:03:37','2025-11-23 10:03:37',1,266,'37c11abd-1e04-4ffb-98b1-3b8b0ff10354',67,'9d635cb23eed4c8795c7c085f175d605','gigabytes_tempest-GroupSnapshotsTest-volume-type-175069716',-1,'2025-11-24 10:03:36',NULL),('2025-11-23 10:03:37','2025-11-23 10:03:37','2025-11-23 10:03:37',1,267,'f0db9502-010f-4950-ab80-c8165ac98b8f',56,'9d635cb23eed4c8795c7c085f175d605','volumes',-1,'2025-11-24 10:03:37',NULL),('2025-11-23 10:03:37','2025-11-23 10:03:37','2025-11-23 10:03:37',1,268,'5d60efbe-ebbc-4825-93c7-d9adb28ab135',57,'9d635cb23eed4c8795c7c085f175d605','gigabytes',-1,'2025-11-24 10:03:37',NULL),('2025-11-23 10:03:37','2025-11-23 10:03:37','2025-11-23 10:03:37',1,269,'8f305f9a-5fce-4b90-b070-942fabfb60cf',66,'9d635cb23eed4c8795c7c085f175d605','volumes_tempest-GroupSnapshotsTest-volume-type-175069716',-1,'2025-11-24 10:03:37',NULL),('2025-11-23 10:03:37','2025-11-23 10:03:37','2025-11-23 10:03:37',1,270,'cb252f6e-560a-402e-8871-dcce68b356ed',67,'9d635cb23eed4c8795c7c085f175d605','gigabytes_tempest-GroupSnapshotsTest-volume-type-175069716',-1,'2025-11-24 10:03:37',NULL),('2025-11-23 10:03:37','2025-11-23 10:03:37','2025-11-23 10:03:37',1,271,'d5855801-4335-43aa-a83d-42c836757e16',68,'49ebd7a691dd4ea59ffbe9f5703e77e4','backups',-1,'2025-11-24 10:03:37',NULL),('2025-11-23 10:03:37','2025-11-23 10:03:37','2025-11-23 10:03:37',1,272,'1b1b56fb-1aa8-49d0-8113-0f997815a08a',69,'49ebd7a691dd4ea59ffbe9f5703e77e4','backup_gigabytes',-1,'2025-11-24 10:03:37',NULL),('2025-11-23 10:03:38','2025-11-23 10:03:38','2025-11-23 10:03:38',1,273,'82423fcf-8b89-4ea0-9b2c-9d6bcc25647a',55,'9d635cb23eed4c8795c7c085f175d605','groups',1,'2025-11-24 10:03:38',NULL),('2025-11-23 10:03:39','2025-11-23 10:03:39','2025-11-23 10:03:39',1,274,'a802b486-53d8-444e-9723-b1b551e15175',56,'9d635cb23eed4c8795c7c085f175d605','volumes',1,'2025-11-24 10:03:39',NULL),('2025-11-23 10:03:39','2025-11-23 10:03:39','2025-11-23 10:03:39',1,275,'6dd05083-1ec4-4bad-8703-7bcf7ce23f40',57,'9d635cb23eed4c8795c7c085f175d605','gigabytes',1,'2025-11-24 10:03:39',NULL),('2025-11-23 10:03:39','2025-11-23 10:03:39','2025-11-23 10:03:39',1,276,'7a536b28-9cc6-4c9e-b26f-6dad20be97ec',71,'9d635cb23eed4c8795c7c085f175d605','volumes_tempest-GroupSnapshotsTest-volume-type-1243502470',1,'2025-11-24 10:03:39',NULL),('2025-11-23 10:03:39','2025-11-23 10:03:39','2025-11-23 10:03:39',1,277,'4d043d28-f216-4346-b2a4-3e1b18770c64',72,'9d635cb23eed4c8795c7c085f175d605','gigabytes_tempest-GroupSnapshotsTest-volume-type-1243502470',1,'2025-11-24 10:03:39',NULL),('2025-11-23 10:03:39','2025-11-23 10:03:39','2025-11-23 10:03:39',1,278,'36e8ef67-cce5-4e0e-8511-dfb464f91720',62,'49ebd7a691dd4ea59ffbe9f5703e77e4','volumes',-1,'2025-11-24 10:03:39',NULL),('2025-11-23 10:03:39','2025-11-23 10:03:39','2025-11-23 10:03:39',1,279,'8c03310d-8e5d-4ca9-937a-cf10c2a42e3b',63,'49ebd7a691dd4ea59ffbe9f5703e77e4','gigabytes',-1,'2025-11-24 10:03:39',NULL),('2025-11-23 10:03:39','2025-11-23 10:03:39','2025-11-23 10:03:39',1,280,'b30b6f3a-60b0-4b9d-b6fe-6cc68528ce82',64,'49ebd7a691dd4ea59ffbe9f5703e77e4','volumes_tripleo',-1,'2025-11-24 10:03:39',NULL),('2025-11-23 10:03:39','2025-11-23 10:03:39','2025-11-23 10:03:39',1,281,'7b0b792e-ff4c-4554-b0ed-4aec2ad2577f',65,'49ebd7a691dd4ea59ffbe9f5703e77e4','gigabytes_tripleo',-1,'2025-11-24 10:03:39',NULL),('2025-11-23 10:03:40','2025-11-23 10:03:40','2025-11-23 10:03:40',1,282,'5368aa83-ba14-472e-adc4-236bb0497c63',62,'49ebd7a691dd4ea59ffbe9f5703e77e4','volumes',1,'2025-11-24 10:03:40',NULL),('2025-11-23 10:03:40','2025-11-23 10:03:40','2025-11-23 10:03:40',1,283,'f89cfb24-e248-48a0-8db0-33e514b6e981',63,'49ebd7a691dd4ea59ffbe9f5703e77e4','gigabytes',1,'2025-11-24 10:03:40',NULL),('2025-11-23 10:03:40','2025-11-23 10:03:40','2025-11-23 10:03:40',1,284,'3cd3cd83-5647-40c9-9432-a76e0084fbd0',64,'49ebd7a691dd4ea59ffbe9f5703e77e4','volumes_tripleo',1,'2025-11-24 10:03:40',NULL),('2025-11-23 10:03:40','2025-11-23 10:03:40','2025-11-23 10:03:40',1,285,'76497e05-8b49-4b20-8b39-ac86cb498b1e',65,'49ebd7a691dd4ea59ffbe9f5703e77e4','gigabytes_tripleo',1,'2025-11-24 10:03:40',NULL),('2025-11-23 10:03:40','2025-11-23 10:03:40','2025-11-23 10:03:40',1,286,'7787a3ca-320e-4ffe-b357-82ce7c528589',60,'9d635cb23eed4c8795c7c085f175d605','snapshots',1,'2025-11-24 10:03:40',NULL),('2025-11-23 10:03:40','2025-11-23 10:03:40','2025-11-23 10:03:40',1,287,'08e01c12-520e-4a69-a847-635ef111cc0b',57,'9d635cb23eed4c8795c7c085f175d605','gigabytes',1,'2025-11-24 10:03:40',NULL),('2025-11-23 10:03:40','2025-11-23 10:03:40','2025-11-23 10:03:40',1,288,'8f4faee8-2174-4132-92a2-f7f6c5467338',72,'9d635cb23eed4c8795c7c085f175d605','gigabytes_tempest-GroupSnapshotsTest-volume-type-1243502470',1,'2025-11-24 10:03:40',NULL),('2025-11-23 10:03:40','2025-11-23 10:03:40','2025-11-23 10:03:40',1,289,'8773fe54-16fa-4d3b-84a9-f1e158101bac',73,'9d635cb23eed4c8795c7c085f175d605','snapshots_tempest-GroupSnapshotsTest-volume-type-1243502470',1,'2025-11-24 10:03:40',NULL),('2025-11-23 10:03:43','2025-11-23 10:03:43','2025-11-23 10:03:43',1,290,'0c830b4f-8b4e-4c82-a68d-014edab2b53f',60,'9d635cb23eed4c8795c7c085f175d605','snapshots',-1,'2025-11-24 10:03:43',NULL),('2025-11-23 10:03:43','2025-11-23 10:03:43','2025-11-23 10:03:43',1,291,'22888dfe-dfa4-4304-9997-7c28b6b5eb95',57,'9d635cb23eed4c8795c7c085f175d605','gigabytes',-1,'2025-11-24 10:03:43',NULL),('2025-11-23 10:03:43','2025-11-23 10:03:43','2025-11-23 10:03:43',1,292,'16abd9ac-26d4-4fb0-bfa8-7255298cee78',72,'9d635cb23eed4c8795c7c085f175d605','gigabytes_tempest-GroupSnapshotsTest-volume-type-1243502470',-1,'2025-11-24 10:03:43',NULL),('2025-11-23 10:03:43','2025-11-23 10:03:43','2025-11-23 10:03:43',1,293,'b0efffd0-1f1d-4d05-87a1-f7075aa0e471',73,'9d635cb23eed4c8795c7c085f175d605','snapshots_tempest-GroupSnapshotsTest-volume-type-1243502470',-1,'2025-11-24 10:03:43',NULL),('2025-11-23 10:03:44','2025-11-23 10:03:44','2025-11-23 10:03:44',1,294,'16e51dab-41e9-4fc2-9589-3494dbc50b63',55,'9d635cb23eed4c8795c7c085f175d605','groups',-1,'2025-11-24 10:03:44',NULL),('2025-11-23 10:03:44','2025-11-23 10:03:44','2025-11-23 10:03:44',1,295,'7e5e832d-8ce1-495c-99ae-04f20e960f03',56,'9d635cb23eed4c8795c7c085f175d605','volumes',-1,'2025-11-24 10:03:44',NULL),('2025-11-23 10:03:44','2025-11-23 10:03:44','2025-11-23 10:03:44',1,296,'812b6753-3b53-4349-9b66-3efbafcd8c65',57,'9d635cb23eed4c8795c7c085f175d605','gigabytes',-1,'2025-11-24 10:03:44',NULL),('2025-11-23 10:03:44','2025-11-23 10:03:44','2025-11-23 10:03:44',1,297,'1a09c5fb-6c52-46fa-9035-ba257ab8c4da',71,'9d635cb23eed4c8795c7c085f175d605','volumes_tempest-GroupSnapshotsTest-volume-type-1243502470',-1,'2025-11-24 10:03:44',NULL),('2025-11-23 10:03:44','2025-11-23 10:03:44','2025-11-23 10:03:44',1,298,'6b9ae48c-9794-42d0-9125-cbbbc35b355e',72,'9d635cb23eed4c8795c7c085f175d605','gigabytes_tempest-GroupSnapshotsTest-volume-type-1243502470',-1,'2025-11-24 10:03:44',NULL),('2025-11-23 10:03:52','2025-11-23 10:03:52','2025-11-23 10:03:52',1,299,'cfe47aa8-7613-4200-9d9b-5ac64e659f65',74,'63f36986a4504be59f5bb7dd85b81e14','volumes',1,'2025-11-24 10:03:52',NULL),('2025-11-23 10:03:52','2025-11-23 10:03:52','2025-11-23 10:03:52',1,300,'e80975e4-1ac3-4a02-a774-503020a6391d',75,'63f36986a4504be59f5bb7dd85b81e14','gigabytes',1,'2025-11-24 10:03:52',NULL),('2025-11-23 10:03:52','2025-11-23 10:03:52','2025-11-23 10:03:52',1,301,'475ff1fe-77c0-4b31-85ca-f3ba58f786c1',76,'63f36986a4504be59f5bb7dd85b81e14','volumes_tripleo',1,'2025-11-24 10:03:52',NULL),('2025-11-23 10:03:52','2025-11-23 10:03:52','2025-11-23 10:03:52',1,302,'732642ef-c8f3-461c-bf6d-f8e16eb089fe',77,'63f36986a4504be59f5bb7dd85b81e14','gigabytes_tripleo',1,'2025-11-24 10:03:52',NULL),('2025-11-23 10:03:53','2025-11-23 10:03:53','2025-11-23 10:03:53',1,303,'7289b4f2-2cea-411f-badb-b596a8f4f2a2',78,'63f36986a4504be59f5bb7dd85b81e14','snapshots',1,'2025-11-24 10:03:53',NULL),('2025-11-23 10:03:53','2025-11-23 10:03:53','2025-11-23 10:03:53',1,304,'5791259f-ccd0-448a-9929-451224cc422a',75,'63f36986a4504be59f5bb7dd85b81e14','gigabytes',1,'2025-11-24 10:03:53',NULL),('2025-11-23 10:03:53','2025-11-23 10:03:53','2025-11-23 10:03:53',1,305,'2f169dd7-21c9-443f-9b40-bc1aab244d04',77,'63f36986a4504be59f5bb7dd85b81e14','gigabytes_tripleo',1,'2025-11-24 10:03:53',NULL),('2025-11-23 10:03:53','2025-11-23 10:03:53','2025-11-23 10:03:53',1,306,'4f0df749-5c5a-45f4-abea-62709229bea5',79,'63f36986a4504be59f5bb7dd85b81e14','snapshots_tripleo',1,'2025-11-24 10:03:53',NULL),('2025-11-23 10:03:56','2025-11-23 10:03:56','2025-11-23 10:03:56',1,307,'0bc95e71-39ee-4a84-bfaa-4f9153a9ba4d',78,'63f36986a4504be59f5bb7dd85b81e14','snapshots',-1,'2025-11-24 10:03:56',NULL),('2025-11-23 10:03:56','2025-11-23 10:03:56','2025-11-23 10:03:56',1,308,'607f1bb1-2a85-47dd-8987-faaf51df8d61',75,'63f36986a4504be59f5bb7dd85b81e14','gigabytes',-1,'2025-11-24 10:03:56',NULL),('2025-11-23 10:03:56','2025-11-23 10:03:56','2025-11-23 10:03:56',1,309,'953fc5ad-3aea-41e4-bed2-661576a68156',77,'63f36986a4504be59f5bb7dd85b81e14','gigabytes_tripleo',-1,'2025-11-24 10:03:56',NULL),('2025-11-23 10:03:56','2025-11-23 10:03:56','2025-11-23 10:03:56',1,310,'5b75997e-dd69-4821-9334-6a8aeb89969d',79,'63f36986a4504be59f5bb7dd85b81e14','snapshots_tripleo',-1,'2025-11-24 10:03:56',NULL),('2025-11-23 10:03:57','2025-11-23 10:03:57','2025-11-23 10:03:57',1,311,'51301ceb-cbe4-4555-aab6-8199aa12d1d3',74,'63f36986a4504be59f5bb7dd85b81e14','volumes',-1,'2025-11-24 10:03:57',NULL),('2025-11-23 10:03:57','2025-11-23 10:03:57','2025-11-23 10:03:57',1,312,'7b52b634-fc51-4d1f-bc11-537e03dd6846',75,'63f36986a4504be59f5bb7dd85b81e14','gigabytes',-1,'2025-11-24 10:03:57',NULL),('2025-11-23 10:03:57','2025-11-23 10:03:57','2025-11-23 10:03:57',1,313,'1e0cf091-8a55-45d3-8c12-80142456fded',76,'63f36986a4504be59f5bb7dd85b81e14','volumes_tripleo',-1,'2025-11-24 10:03:57',NULL),('2025-11-23 10:03:57','2025-11-23 10:03:57','2025-11-23 10:03:57',1,314,'6fa80b71-3637-4e93-bb44-b8517410f3b1',77,'63f36986a4504be59f5bb7dd85b81e14','gigabytes_tripleo',-1,'2025-11-24 10:03:57',NULL),('2025-11-23 10:04:15','2025-11-23 10:04:15','2025-11-23 10:04:15',1,315,'b2eb508f-996e-49c0-90d6-867de509c86e',80,'357e082a3fb74c17977fb3ffe7ad4261','volumes',1,'2025-11-24 10:04:15',NULL),('2025-11-23 10:04:15','2025-11-23 10:04:15','2025-11-23 10:04:15',1,316,'e6e0beab-0cc2-4f1d-9017-5333e15e8828',81,'357e082a3fb74c17977fb3ffe7ad4261','gigabytes',1,'2025-11-24 10:04:15',NULL),('2025-11-23 10:04:15','2025-11-23 10:04:15','2025-11-23 10:04:15',1,317,'277723a8-3d6a-49e8-9a3a-b591c12084cc',82,'357e082a3fb74c17977fb3ffe7ad4261','volumes_tripleo',1,'2025-11-24 10:04:15',NULL),('2025-11-23 10:04:15','2025-11-23 10:04:15','2025-11-23 10:04:15',1,318,'88b1409b-25b1-44c7-a2f7-77d0d5b477cb',83,'357e082a3fb74c17977fb3ffe7ad4261','gigabytes_tripleo',1,'2025-11-24 10:04:15',NULL),('2025-11-23 10:04:17','2025-11-23 10:04:17','2025-11-23 10:04:17',1,319,'a3e05a0d-1cbd-4f1b-8f1d-3e0297782bcf',84,'bd97d43422d1434dbd778fc0c37a5566','volumes',1,'2025-11-24 10:04:17',NULL),('2025-11-23 10:04:17','2025-11-23 10:04:17','2025-11-23 10:04:17',1,320,'b88db388-0255-46e5-9d7b-a518141eb6b3',85,'bd97d43422d1434dbd778fc0c37a5566','gigabytes',1,'2025-11-24 10:04:17',NULL),('2025-11-23 10:04:17','2025-11-23 10:04:17','2025-11-23 10:04:17',1,321,'b5526dc4-64ff-4334-9bc5-c5e3d9c6d769',86,'bd97d43422d1434dbd778fc0c37a5566','volumes_tripleo',1,'2025-11-24 10:04:17',NULL),('2025-11-23 10:04:17','2025-11-23 10:04:17','2025-11-23 10:04:17',1,322,'25cb4073-df3a-41a9-a263-3a4192ede206',87,'bd97d43422d1434dbd778fc0c37a5566','gigabytes_tripleo',1,'2025-11-24 10:04:17',NULL),('2025-11-23 10:04:20','2025-11-23 10:04:20','2025-11-23 10:04:20',1,323,'b3d87130-b3bd-4897-ac75-c2e3c1585552',68,'49ebd7a691dd4ea59ffbe9f5703e77e4','backups',1,'2025-11-24 10:04:20',NULL),('2025-11-23 10:04:20','2025-11-23 10:04:20','2025-11-23 10:04:20',1,324,'48ea24c5-f069-451d-9b55-2f5e02a5b4af',69,'49ebd7a691dd4ea59ffbe9f5703e77e4','backup_gigabytes',1,'2025-11-24 10:04:20',NULL),('2025-11-23 10:04:22','2025-11-23 10:04:22','2025-11-23 10:04:22',1,325,'efb6b403-203a-4977-8116-c0cc690a6e25',88,'0e9ab70f23134afd92115add42e46bf7','groups',1,'2025-11-24 10:04:22',NULL),('2025-11-23 10:04:23','2025-11-23 10:04:23','2025-11-23 10:04:23',1,326,'6de4382d-c968-4c96-a531-c2a04a4f1a15',89,'0e9ab70f23134afd92115add42e46bf7','volumes',1,'2025-11-24 10:04:23',NULL),('2025-11-23 10:04:23','2025-11-23 10:04:23','2025-11-23 10:04:23',1,327,'e4ab809d-dbb7-4bab-95aa-df6f0c2632e8',90,'0e9ab70f23134afd92115add42e46bf7','gigabytes',1,'2025-11-24 10:04:23',NULL),('2025-11-23 10:04:23','2025-11-23 10:04:23','2025-11-23 10:04:23',1,328,'e28d13e8-836b-4605-97a2-6408c59008ee',91,'0e9ab70f23134afd92115add42e46bf7','volumes_tempest-GroupSnapshotsV319Test-volume-type-1099039626',1,'2025-11-24 10:04:23',NULL),('2025-11-23 10:04:23','2025-11-23 10:04:23','2025-11-23 10:04:23',1,329,'e126cbc5-7faa-425c-8092-1b4c55965059',92,'0e9ab70f23134afd92115add42e46bf7','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-1099039626',1,'2025-11-24 10:04:23',NULL),('2025-11-23 10:04:23','2025-11-23 10:04:23','2025-11-23 10:04:23',1,330,'77013a37-7b00-4439-acd0-0283ac4ca40c',85,'bd97d43422d1434dbd778fc0c37a5566','gigabytes',1,'2025-11-24 10:04:23',NULL),('2025-11-23 10:04:23','2025-11-23 10:04:23','2025-11-23 10:04:23',1,331,'0da2750d-bdbb-436b-bfef-a706aae017c8',87,'bd97d43422d1434dbd778fc0c37a5566','gigabytes_tripleo',1,'2025-11-24 10:04:23',NULL),('2025-11-23 10:04:24','2025-11-23 10:04:24','2025-11-23 10:04:24',1,332,'f51b3428-8b5b-43e7-ad48-1693ff00bd00',68,'49ebd7a691dd4ea59ffbe9f5703e77e4','backups',1,'2025-11-24 10:04:24',NULL),('2025-11-23 10:04:24','2025-11-23 10:04:24','2025-11-23 10:04:24',1,333,'a56b37c8-964c-4c51-9dc5-c7a78eea0245',69,'49ebd7a691dd4ea59ffbe9f5703e77e4','backup_gigabytes',1,'2025-11-24 10:04:24',NULL),('2025-11-23 10:04:24','2025-11-23 10:04:24','2025-11-23 10:04:24',1,334,'9fc6b7a9-469e-4304-a28a-9ca6aa424317',93,'0e9ab70f23134afd92115add42e46bf7','snapshots',1,'2025-11-24 10:04:24',NULL),('2025-11-23 10:04:24','2025-11-23 10:04:24','2025-11-23 10:04:24',1,335,'4a516ae0-e6fb-4639-883f-99a69393bef7',90,'0e9ab70f23134afd92115add42e46bf7','gigabytes',1,'2025-11-24 10:04:24',NULL),('2025-11-23 10:04:24','2025-11-23 10:04:24','2025-11-23 10:04:24',1,336,'a01e4e10-01e8-4758-83ad-284ef31dbb12',92,'0e9ab70f23134afd92115add42e46bf7','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-1099039626',1,'2025-11-24 10:04:24',NULL),('2025-11-23 10:04:24','2025-11-23 10:04:24','2025-11-23 10:04:24',1,337,'b1cd92e7-a6f0-4f04-b6ea-18e19c4f5462',94,'0e9ab70f23134afd92115add42e46bf7','snapshots_tempest-GroupSnapshotsV319Test-volume-type-1099039626',1,'2025-11-24 10:04:24',NULL),('2025-11-23 10:04:25','2025-11-23 10:04:25','2025-11-23 10:04:25',1,338,'e595f35d-4be2-4258-882d-a40afec3c29c',84,'bd97d43422d1434dbd778fc0c37a5566','volumes',-1,'2025-11-24 10:04:25',NULL),('2025-11-23 10:04:25','2025-11-23 10:04:25','2025-11-23 10:04:25',1,339,'b566bfe8-8d81-4256-879f-4ef04868f0d8',85,'bd97d43422d1434dbd778fc0c37a5566','gigabytes',-2,'2025-11-24 10:04:25',NULL),('2025-11-23 10:04:25','2025-11-23 10:04:25','2025-11-23 10:04:25',1,340,'b0f9340e-3b59-4c3f-9391-3ac1ceac4ff0',86,'bd97d43422d1434dbd778fc0c37a5566','volumes_tripleo',-1,'2025-11-24 10:04:25',NULL),('2025-11-23 10:04:25','2025-11-23 10:04:25','2025-11-23 10:04:25',1,341,'2074c42b-53ff-41e0-8840-7ecd7d6e1f79',87,'bd97d43422d1434dbd778fc0c37a5566','gigabytes_tripleo',-2,'2025-11-24 10:04:25',NULL),('2025-11-23 10:04:26','2025-11-23 10:04:26','2025-11-23 10:04:26',1,342,'faca7d61-b661-4995-b5c0-3681c83e9335',80,'357e082a3fb74c17977fb3ffe7ad4261','volumes',-1,'2025-11-24 10:04:26',NULL),('2025-11-23 10:04:26','2025-11-23 10:04:26','2025-11-23 10:04:26',1,343,'7dcad902-8452-4818-8788-9c78316e02b9',81,'357e082a3fb74c17977fb3ffe7ad4261','gigabytes',-1,'2025-11-24 10:04:26',NULL),('2025-11-23 10:04:26','2025-11-23 10:04:26','2025-11-23 10:04:26',1,344,'3f7bb164-9d80-48d5-aca8-27a50e5ed8c8',82,'357e082a3fb74c17977fb3ffe7ad4261','volumes_tripleo',-1,'2025-11-24 10:04:26',NULL),('2025-11-23 10:04:26','2025-11-23 10:04:26','2025-11-23 10:04:26',1,345,'f9ca0088-4c7d-4c24-b568-c902ed2c5662',83,'357e082a3fb74c17977fb3ffe7ad4261','gigabytes_tripleo',-1,'2025-11-24 10:04:26',NULL),('2025-11-23 10:04:26','2025-11-23 10:04:26','2025-11-23 10:04:26',1,346,'6f348dde-d882-4e8a-a24a-7311c35d9934',84,'bd97d43422d1434dbd778fc0c37a5566','volumes',1,'2025-11-24 10:04:26',NULL),('2025-11-23 10:04:26','2025-11-23 10:04:26','2025-11-23 10:04:26',1,347,'6718e9c6-d8ce-4ee2-8095-0827d889ff0a',85,'bd97d43422d1434dbd778fc0c37a5566','gigabytes',1,'2025-11-24 10:04:26',NULL),('2025-11-23 10:04:26','2025-11-23 10:04:26','2025-11-23 10:04:26',1,348,'761fdd54-8cd9-4848-a253-87d4285c9366',86,'bd97d43422d1434dbd778fc0c37a5566','volumes_tripleo',1,'2025-11-24 10:04:26',NULL),('2025-11-23 10:04:26','2025-11-23 10:04:26','2025-11-23 10:04:26',1,349,'0323427a-7f05-4635-8825-25f2e8be635b',87,'bd97d43422d1434dbd778fc0c37a5566','gigabytes_tripleo',1,'2025-11-24 10:04:26',NULL),('2025-11-23 10:04:27','2025-11-23 10:04:27','2025-11-23 10:04:27',1,350,'3039c0ac-0cc4-43b1-8a25-6da61b2e6f43',95,'bd97d43422d1434dbd778fc0c37a5566','snapshots',1,'2025-11-24 10:04:27',NULL),('2025-11-23 10:04:27','2025-11-23 10:04:27','2025-11-23 10:04:27',1,351,'741c9ed1-b7ec-43c3-b8f8-482b0282ca1f',85,'bd97d43422d1434dbd778fc0c37a5566','gigabytes',1,'2025-11-24 10:04:27',NULL),('2025-11-23 10:04:27','2025-11-23 10:04:27','2025-11-23 10:04:27',1,352,'776c4314-b5ef-497f-bd1e-c48cd8bbeb5a',87,'bd97d43422d1434dbd778fc0c37a5566','gigabytes_tripleo',1,'2025-11-24 10:04:27',NULL),('2025-11-23 10:04:27','2025-11-23 10:04:27','2025-11-23 10:04:27',1,353,'dd2362a2-7058-416d-94dd-c7d83eaaa404',96,'bd97d43422d1434dbd778fc0c37a5566','snapshots_tripleo',1,'2025-11-24 10:04:27',NULL),('2025-11-23 10:04:28','2025-11-23 10:04:28','2025-11-23 10:04:28',1,354,'cb41ffa1-1057-45f5-a9f9-b6bdb3ac110a',93,'0e9ab70f23134afd92115add42e46bf7','snapshots',-1,'2025-11-24 10:04:28',NULL),('2025-11-23 10:04:28','2025-11-23 10:04:28','2025-11-23 10:04:28',1,355,'f076ab4e-8591-491a-a543-1580cc33c41e',90,'0e9ab70f23134afd92115add42e46bf7','gigabytes',-1,'2025-11-24 10:04:28',NULL),('2025-11-23 10:04:28','2025-11-23 10:04:28','2025-11-23 10:04:28',1,356,'4b29dcc3-30d0-42ab-a501-fd9b60d6398c',92,'0e9ab70f23134afd92115add42e46bf7','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-1099039626',-1,'2025-11-24 10:04:28',NULL),('2025-11-23 10:04:28','2025-11-23 10:04:28','2025-11-23 10:04:28',1,357,'6726d2ba-85c2-4af7-a884-72e366ff5d75',94,'0e9ab70f23134afd92115add42e46bf7','snapshots_tempest-GroupSnapshotsV319Test-volume-type-1099039626',-1,'2025-11-24 10:04:28',NULL),('2025-11-23 10:04:28','2025-11-23 10:04:28','2025-11-23 10:04:28',1,358,'e3680d35-961e-4f17-b554-0687908e8e8e',85,'bd97d43422d1434dbd778fc0c37a5566','gigabytes',1,'2025-11-24 10:04:28',NULL),('2025-11-23 10:04:28','2025-11-23 10:04:28','2025-11-23 10:04:28',1,359,'1dfd7fbb-14fc-4d4b-865d-b9fb7bb2f81f',87,'bd97d43422d1434dbd778fc0c37a5566','gigabytes_tripleo',1,'2025-11-24 10:04:28',NULL),('2025-11-23 10:04:29','2025-11-23 10:04:29','2025-11-23 10:04:29',1,360,'23239859-ae25-4e8a-90d5-3b3cdecd8d02',88,'0e9ab70f23134afd92115add42e46bf7','groups',-1,'2025-11-24 10:04:29',NULL),('2025-11-23 10:04:29','2025-11-23 10:04:29','2025-11-23 10:04:29',1,361,'3f62f930-3a6b-4fef-a540-8d1a73fcd59b',68,'49ebd7a691dd4ea59ffbe9f5703e77e4','backups',-1,'2025-11-24 10:04:29',NULL),('2025-11-23 10:04:29','2025-11-23 10:04:29','2025-11-23 10:04:29',1,362,'dce30aff-caf8-44a9-a229-4b92526a4e07',69,'49ebd7a691dd4ea59ffbe9f5703e77e4','backup_gigabytes',-1,'2025-11-24 10:04:29',NULL),('2025-11-23 10:04:29','2025-11-23 10:04:29','2025-11-23 10:04:29',1,363,'31251c1f-6cad-4893-8c00-c0f9ff28d238',89,'0e9ab70f23134afd92115add42e46bf7','volumes',-1,'2025-11-24 10:04:29',NULL),('2025-11-23 10:04:29','2025-11-23 10:04:29','2025-11-23 10:04:29',1,364,'44d7bd0b-e648-4d62-beee-3f852530197b',90,'0e9ab70f23134afd92115add42e46bf7','gigabytes',-1,'2025-11-24 10:04:29',NULL),('2025-11-23 10:04:29','2025-11-23 10:04:29','2025-11-23 10:04:29',1,365,'52d894fc-ff63-44c4-922d-bb8bd5447c12',91,'0e9ab70f23134afd92115add42e46bf7','volumes_tempest-GroupSnapshotsV319Test-volume-type-1099039626',-1,'2025-11-24 10:04:29',NULL),('2025-11-23 10:04:29','2025-11-23 10:04:29','2025-11-23 10:04:29',1,366,'57e5cedf-6f31-4878-a0d5-3012ea9ae620',92,'0e9ab70f23134afd92115add42e46bf7','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-1099039626',-1,'2025-11-24 10:04:29',NULL),('2025-11-23 10:04:30','2025-11-23 10:04:30','2025-11-23 10:04:30',1,367,'fb77b60f-bba8-4595-974c-71fdd9e66fab',68,'49ebd7a691dd4ea59ffbe9f5703e77e4','backups',1,'2025-11-24 10:04:30',NULL),('2025-11-23 10:04:30','2025-11-23 10:04:30','2025-11-23 10:04:30',1,368,'655fcbb7-b27c-4985-92e4-70726f8cb7e2',69,'49ebd7a691dd4ea59ffbe9f5703e77e4','backup_gigabytes',1,'2025-11-24 10:04:30',NULL),('2025-11-23 10:04:30','2025-11-23 10:04:30','2025-11-23 10:04:30',1,369,'8fb8591b-f949-484e-bd50-35d6dd840e07',97,'307e3d5fcbc742a6b6aa246e7c8c9946','volumes',1,'2025-11-24 10:04:30',NULL),('2025-11-23 10:04:30','2025-11-23 10:04:30','2025-11-23 10:04:30',1,370,'1b331d48-ee18-4021-99a4-ad6b4a02546c',98,'307e3d5fcbc742a6b6aa246e7c8c9946','gigabytes',1,'2025-11-24 10:04:30',NULL),('2025-11-23 10:04:30','2025-11-23 10:04:30','2025-11-23 10:04:30',1,371,'fea282a1-a112-4398-9d7a-aed994bfa2ac',99,'307e3d5fcbc742a6b6aa246e7c8c9946','volumes_tripleo',1,'2025-11-24 10:04:30',NULL),('2025-11-23 10:04:30','2025-11-23 10:04:30','2025-11-23 10:04:30',1,372,'37c3b5aa-cf23-40e4-bcb5-831ab2079cb6',100,'307e3d5fcbc742a6b6aa246e7c8c9946','gigabytes_tripleo',1,'2025-11-24 10:04:30',NULL),('2025-11-23 10:04:31','2025-11-23 10:04:31','2025-11-23 10:04:31',1,373,'3f21b151-bf53-4446-9cbf-8ae108c1fbb5',95,'bd97d43422d1434dbd778fc0c37a5566','snapshots',-1,'2025-11-24 10:04:31',NULL),('2025-11-23 10:04:31','2025-11-23 10:04:31','2025-11-23 10:04:31',1,374,'9c426924-5e04-43ea-9b03-b97dbf04a8ca',85,'bd97d43422d1434dbd778fc0c37a5566','gigabytes',-1,'2025-11-24 10:04:31',NULL),('2025-11-23 10:04:31','2025-11-23 10:04:31','2025-11-23 10:04:31',1,375,'7c96fe08-a9e7-4622-869c-dde75188a3e8',87,'bd97d43422d1434dbd778fc0c37a5566','gigabytes_tripleo',-1,'2025-11-24 10:04:31',NULL),('2025-11-23 10:04:31','2025-11-23 10:04:31','2025-11-23 10:04:31',1,376,'d49fa72a-3993-4324-9edd-aa88d7144661',96,'bd97d43422d1434dbd778fc0c37a5566','snapshots_tripleo',-1,'2025-11-24 10:04:31',NULL),('2025-11-23 10:04:31','2025-11-23 10:04:31','2025-11-23 10:04:31',1,377,'09277f78-be50-4c91-b24d-d172ecf6e0f7',101,'307e3d5fcbc742a6b6aa246e7c8c9946','snapshots',1,'2025-11-24 10:04:31',NULL),('2025-11-23 10:04:31','2025-11-23 10:04:31','2025-11-23 10:04:31',1,378,'8f492e2d-b06b-42ec-a465-75327887ffb7',98,'307e3d5fcbc742a6b6aa246e7c8c9946','gigabytes',1,'2025-11-24 10:04:31',NULL),('2025-11-23 10:04:31','2025-11-23 10:04:31','2025-11-23 10:04:31',1,379,'3eb44937-402b-4125-8fba-75bd0fc61ee4',100,'307e3d5fcbc742a6b6aa246e7c8c9946','gigabytes_tripleo',1,'2025-11-24 10:04:31',NULL),('2025-11-23 10:04:31','2025-11-23 10:04:31','2025-11-23 10:04:31',1,380,'316f0b67-9dc1-47f3-b101-fbc654e883dd',102,'307e3d5fcbc742a6b6aa246e7c8c9946','snapshots_tripleo',1,'2025-11-24 10:04:31',NULL),('2025-11-23 10:04:32','2025-11-23 10:04:32','2025-11-23 10:04:32',1,381,'1e5717dd-07ba-4ba0-819f-8e9d22acc842',84,'bd97d43422d1434dbd778fc0c37a5566','volumes',-1,'2025-11-24 10:04:32',NULL),('2025-11-23 10:04:32','2025-11-23 10:04:32','2025-11-23 10:04:32',1,382,'f0b08750-fc50-4c19-a81e-72a5cde70dee',85,'bd97d43422d1434dbd778fc0c37a5566','gigabytes',-2,'2025-11-24 10:04:32',NULL),('2025-11-23 10:04:32','2025-11-23 10:04:32','2025-11-23 10:04:32',1,383,'3160be85-033b-434d-a577-ee129c951258',86,'bd97d43422d1434dbd778fc0c37a5566','volumes_tripleo',-1,'2025-11-24 10:04:32',NULL),('2025-11-23 10:04:32','2025-11-23 10:04:32','2025-11-23 10:04:32',1,384,'6218d443-5288-4b09-b5ed-9ade30f702fa',87,'bd97d43422d1434dbd778fc0c37a5566','gigabytes_tripleo',-2,'2025-11-24 10:04:32',NULL),('2025-11-23 10:04:32','2025-11-23 10:04:33','2025-11-23 10:04:33',1,385,'f37723e8-3833-4b42-9780-2027b0a6eca6',101,'307e3d5fcbc742a6b6aa246e7c8c9946','snapshots',1,'2025-11-24 10:04:32',NULL),('2025-11-23 10:04:32','2025-11-23 10:04:33','2025-11-23 10:04:33',1,386,'9b3e930e-3502-4225-8683-b4b44ed17514',98,'307e3d5fcbc742a6b6aa246e7c8c9946','gigabytes',1,'2025-11-24 10:04:32',NULL),('2025-11-23 10:04:32','2025-11-23 10:04:33','2025-11-23 10:04:33',1,387,'7acf7751-9e81-4764-802e-221cb08b4158',100,'307e3d5fcbc742a6b6aa246e7c8c9946','gigabytes_tripleo',1,'2025-11-24 10:04:32',NULL),('2025-11-23 10:04:32','2025-11-23 10:04:33','2025-11-23 10:04:33',1,388,'403bf2fc-5ef9-4493-958c-db29f3b22a52',102,'307e3d5fcbc742a6b6aa246e7c8c9946','snapshots_tripleo',1,'2025-11-24 10:04:32',NULL),('2025-11-23 10:04:34','2025-11-23 10:04:34','2025-11-23 10:04:34',1,389,'2c00cc12-f57e-44e4-ad4b-f269c127bd87',68,'49ebd7a691dd4ea59ffbe9f5703e77e4','backups',-1,'2025-11-24 10:04:34',NULL),('2025-11-23 10:04:34','2025-11-23 10:04:34','2025-11-23 10:04:34',1,390,'a9cc933d-c701-40b6-baad-471e3433387f',69,'49ebd7a691dd4ea59ffbe9f5703e77e4','backup_gigabytes',-1,'2025-11-24 10:04:34',NULL),('2025-11-23 10:04:35','2025-11-23 10:04:35','2025-11-23 10:04:35',1,391,'2e4a0879-31ff-408e-8122-e39813380605',101,'307e3d5fcbc742a6b6aa246e7c8c9946','snapshots',1,'2025-11-24 10:04:35',NULL),('2025-11-23 10:04:35','2025-11-23 10:04:35','2025-11-23 10:04:35',1,392,'239744b5-55f8-4c9e-8bb9-cddca7d69e29',98,'307e3d5fcbc742a6b6aa246e7c8c9946','gigabytes',1,'2025-11-24 10:04:35',NULL),('2025-11-23 10:04:35','2025-11-23 10:04:35','2025-11-23 10:04:35',1,393,'9513eef2-caf3-4cc5-bd1c-5b0a7d433553',100,'307e3d5fcbc742a6b6aa246e7c8c9946','gigabytes_tripleo',1,'2025-11-24 10:04:35',NULL),('2025-11-23 10:04:35','2025-11-23 10:04:35','2025-11-23 10:04:35',1,394,'65fbdd47-248d-4a3a-8f6e-0865397219b9',102,'307e3d5fcbc742a6b6aa246e7c8c9946','snapshots_tripleo',1,'2025-11-24 10:04:35',NULL),('2025-11-23 10:04:35','2025-11-23 10:04:35','2025-11-23 10:04:35',1,395,'96780061-24a2-440c-8c72-0b83f5e075f6',68,'49ebd7a691dd4ea59ffbe9f5703e77e4','backups',-1,'2025-11-24 10:04:35',NULL),('2025-11-23 10:04:35','2025-11-23 10:04:35','2025-11-23 10:04:35',1,396,'571a9cfe-d03f-4cad-a889-5dec53202c42',69,'49ebd7a691dd4ea59ffbe9f5703e77e4','backup_gigabytes',-1,'2025-11-24 10:04:35',NULL),('2025-11-23 10:04:39','2025-11-23 10:04:39','2025-11-23 10:04:39',1,397,'bf917be2-c13b-4f46-accf-7139690b6951',101,'307e3d5fcbc742a6b6aa246e7c8c9946','snapshots',-1,'2025-11-24 10:04:39',NULL),('2025-11-23 10:04:39','2025-11-23 10:04:39','2025-11-23 10:04:39',1,398,'842293aa-14e0-4362-bf20-289cccfc0134',98,'307e3d5fcbc742a6b6aa246e7c8c9946','gigabytes',-1,'2025-11-24 10:04:39',NULL),('2025-11-23 10:04:39','2025-11-23 10:04:39','2025-11-23 10:04:39',1,399,'44aacad9-3fe2-49c7-aa96-8da61938af97',100,'307e3d5fcbc742a6b6aa246e7c8c9946','gigabytes_tripleo',-1,'2025-11-24 10:04:39',NULL),('2025-11-23 10:04:39','2025-11-23 10:04:39','2025-11-23 10:04:39',1,400,'9a5c256f-b1c3-4e2a-826e-5804ceb5f9df',102,'307e3d5fcbc742a6b6aa246e7c8c9946','snapshots_tripleo',-1,'2025-11-24 10:04:39',NULL),('2025-11-23 10:04:41','2025-11-23 10:04:41','2025-11-23 10:04:41',1,401,'743bc4cc-c33c-469d-ad7a-e7cdd21cf94b',101,'307e3d5fcbc742a6b6aa246e7c8c9946','snapshots',-1,'2025-11-24 10:04:41',NULL),('2025-11-23 10:04:41','2025-11-23 10:04:41','2025-11-23 10:04:41',1,402,'5d96e2cf-181d-460e-b17a-e9feea76e1b4',98,'307e3d5fcbc742a6b6aa246e7c8c9946','gigabytes',-1,'2025-11-24 10:04:41',NULL),('2025-11-23 10:04:41','2025-11-23 10:04:41','2025-11-23 10:04:41',1,403,'45abf2cc-b983-466a-b5a5-c4237dd51039',100,'307e3d5fcbc742a6b6aa246e7c8c9946','gigabytes_tripleo',-1,'2025-11-24 10:04:41',NULL),('2025-11-23 10:04:41','2025-11-23 10:04:41','2025-11-23 10:04:41',1,404,'616eb96d-9974-4efc-853d-364e818aa2eb',102,'307e3d5fcbc742a6b6aa246e7c8c9946','snapshots_tripleo',-1,'2025-11-24 10:04:41',NULL),('2025-11-23 10:04:43','2025-11-23 10:04:43','2025-11-23 10:04:43',1,405,'b17fdb47-5e26-4f14-aa2d-6d660e272d13',101,'307e3d5fcbc742a6b6aa246e7c8c9946','snapshots',-1,'2025-11-24 10:04:43',NULL),('2025-11-23 10:04:43','2025-11-23 10:04:43','2025-11-23 10:04:43',1,406,'55b11578-b4a2-42c6-811d-554dee86a7fb',98,'307e3d5fcbc742a6b6aa246e7c8c9946','gigabytes',-1,'2025-11-24 10:04:43',NULL),('2025-11-23 10:04:43','2025-11-23 10:04:43','2025-11-23 10:04:43',1,407,'5f284b43-cf9b-428e-9f9a-7578fbc0738b',100,'307e3d5fcbc742a6b6aa246e7c8c9946','gigabytes_tripleo',-1,'2025-11-24 10:04:43',NULL),('2025-11-23 10:04:43','2025-11-23 10:04:43','2025-11-23 10:04:43',1,408,'ae91b052-f797-40d5-8dee-fc9a0efb1d10',102,'307e3d5fcbc742a6b6aa246e7c8c9946','snapshots_tripleo',-1,'2025-11-24 10:04:43',NULL),('2025-11-23 10:04:44','2025-11-23 10:04:44','2025-11-23 10:04:44',1,409,'88cdadaa-4e9e-431b-a95a-ced4a7b500c7',97,'307e3d5fcbc742a6b6aa246e7c8c9946','volumes',-1,'2025-11-24 10:04:44',NULL),('2025-11-23 10:04:44','2025-11-23 10:04:44','2025-11-23 10:04:44',1,410,'cdf95566-171d-4980-bddd-3c50eb1d38e9',98,'307e3d5fcbc742a6b6aa246e7c8c9946','gigabytes',-1,'2025-11-24 10:04:44',NULL),('2025-11-23 10:04:44','2025-11-23 10:04:44','2025-11-23 10:04:44',1,411,'dd39d8e5-b1a7-4817-a42e-08a9c4632d6e',99,'307e3d5fcbc742a6b6aa246e7c8c9946','volumes_tripleo',-1,'2025-11-24 10:04:44',NULL),('2025-11-23 10:04:44','2025-11-23 10:04:44','2025-11-23 10:04:44',1,412,'306cc089-8d76-4f32-a9d4-815ed535fe60',100,'307e3d5fcbc742a6b6aa246e7c8c9946','gigabytes_tripleo',-1,'2025-11-24 10:04:44',NULL),('2025-11-23 10:04:47','2025-11-23 10:04:47','2025-11-23 10:04:47',1,413,'4e705a69-9e1d-4df4-bbf6-19f2ab9c9fb1',62,'49ebd7a691dd4ea59ffbe9f5703e77e4','volumes',-1,'2025-11-24 10:04:47',NULL),('2025-11-23 10:04:47','2025-11-23 10:04:47','2025-11-23 10:04:47',1,414,'712114db-18fc-491c-b84f-38d5148c916c',63,'49ebd7a691dd4ea59ffbe9f5703e77e4','gigabytes',-1,'2025-11-24 10:04:47',NULL),('2025-11-23 10:04:47','2025-11-23 10:04:47','2025-11-23 10:04:47',1,415,'31d3448e-9acb-4cca-825b-41136dad2b8c',64,'49ebd7a691dd4ea59ffbe9f5703e77e4','volumes_tripleo',-1,'2025-11-24 10:04:47',NULL),('2025-11-23 10:04:47','2025-11-23 10:04:47','2025-11-23 10:04:47',1,416,'a4b670c9-817d-495b-a859-42109e101c81',65,'49ebd7a691dd4ea59ffbe9f5703e77e4','gigabytes_tripleo',-1,'2025-11-24 10:04:47',NULL),('2025-11-23 10:04:58','2025-11-23 10:04:58','2025-11-23 10:04:58',1,417,'3ac6141f-7d00-4920-8dda-dcaa76645960',103,'e456b00c470e4f58a0cb2eb0ed097106','volumes',1,'2025-11-24 10:04:58',NULL),('2025-11-23 10:04:58','2025-11-23 10:04:58','2025-11-23 10:04:58',1,418,'c763d3a1-dc3e-4af8-8619-24ba7de3a763',104,'e456b00c470e4f58a0cb2eb0ed097106','gigabytes',1,'2025-11-24 10:04:58',NULL),('2025-11-23 10:04:58','2025-11-23 10:04:58','2025-11-23 10:04:58',1,419,'ad2b75d5-ae5c-4088-8f68-25d3fc1255ec',105,'e456b00c470e4f58a0cb2eb0ed097106','volumes_tripleo',1,'2025-11-24 10:04:58',NULL),('2025-11-23 10:04:58','2025-11-23 10:04:58','2025-11-23 10:04:58',1,420,'721d7c9b-a0f9-4a7a-9774-0cd28d7649bd',106,'e456b00c470e4f58a0cb2eb0ed097106','gigabytes_tripleo',1,'2025-11-24 10:04:58',NULL),('2025-11-23 10:05:05','2025-11-23 10:05:05','2025-11-23 10:05:05',1,421,'90b4e36a-3928-481d-9617-e8e623e63d9e',103,'e456b00c470e4f58a0cb2eb0ed097106','volumes',1,'2025-11-24 10:05:05',NULL),('2025-11-23 10:05:05','2025-11-23 10:05:05','2025-11-23 10:05:05',1,422,'5499b376-668a-4313-b13b-d291ec688baa',104,'e456b00c470e4f58a0cb2eb0ed097106','gigabytes',1,'2025-11-24 10:05:05',NULL),('2025-11-23 10:05:05','2025-11-23 10:05:05','2025-11-23 10:05:05',1,423,'ad25f1b1-3105-47e7-8d10-a2bea97b9d33',105,'e456b00c470e4f58a0cb2eb0ed097106','volumes_tripleo',1,'2025-11-24 10:05:05',NULL),('2025-11-23 10:05:05','2025-11-23 10:05:05','2025-11-23 10:05:05',1,424,'9113c095-7609-4f5a-b5ed-4b6e646eb886',106,'e456b00c470e4f58a0cb2eb0ed097106','gigabytes_tripleo',1,'2025-11-24 10:05:05',NULL),('2025-11-23 10:05:08','2025-11-23 10:05:08','2025-11-23 10:05:08',1,425,'5cc8e6fb-c866-4098-8363-590259c63e8a',103,'e456b00c470e4f58a0cb2eb0ed097106','volumes',-1,'2025-11-24 10:05:08',NULL),('2025-11-23 10:05:08','2025-11-23 10:05:08','2025-11-23 10:05:08',1,426,'0214e424-e0d4-49da-84d5-7ec83d847883',104,'e456b00c470e4f58a0cb2eb0ed097106','gigabytes',-1,'2025-11-24 10:05:08',NULL),('2025-11-23 10:05:08','2025-11-23 10:05:08','2025-11-23 10:05:08',1,427,'b19b7551-7323-4909-bca3-c0ad7a127446',105,'e456b00c470e4f58a0cb2eb0ed097106','volumes_tripleo',-1,'2025-11-24 10:05:08',NULL),('2025-11-23 10:05:08','2025-11-23 10:05:08','2025-11-23 10:05:08',1,428,'de28c112-aaeb-470d-a240-aa37ef1c63ad',106,'e456b00c470e4f58a0cb2eb0ed097106','gigabytes_tripleo',-1,'2025-11-24 10:05:08',NULL),('2025-11-23 10:05:09','2025-11-23 10:05:09','2025-11-23 10:05:09',1,429,'c5b3a746-46eb-401b-9023-03708dce92f1',103,'e456b00c470e4f58a0cb2eb0ed097106','volumes',-1,'2025-11-24 10:05:09',NULL),('2025-11-23 10:05:09','2025-11-23 10:05:09','2025-11-23 10:05:09',1,430,'79d0122a-e05a-4a3f-84ea-09dd81d37685',104,'e456b00c470e4f58a0cb2eb0ed097106','gigabytes',-1,'2025-11-24 10:05:09',NULL),('2025-11-23 10:05:09','2025-11-23 10:05:09','2025-11-23 10:05:09',1,431,'4f675130-a3ea-4575-a714-6a1a4d171069',105,'e456b00c470e4f58a0cb2eb0ed097106','volumes_tripleo',-1,'2025-11-24 10:05:09',NULL),('2025-11-23 10:05:09','2025-11-23 10:05:09','2025-11-23 10:05:09',1,432,'0bcf7f8c-2c66-4af9-ae04-10671706b9c1',106,'e456b00c470e4f58a0cb2eb0ed097106','gigabytes_tripleo',-1,'2025-11-24 10:05:09',NULL),('2025-11-23 10:05:10','2025-11-23 10:05:10','2025-11-23 10:05:10',1,433,'43d8eff3-65b7-48a3-b08d-f56c35db5398',103,'e456b00c470e4f58a0cb2eb0ed097106','volumes',1,'2025-11-24 10:05:10',NULL),('2025-11-23 10:05:10','2025-11-23 10:05:10','2025-11-23 10:05:10',1,434,'79b83984-c8e0-488c-a62e-b421dfba4741',104,'e456b00c470e4f58a0cb2eb0ed097106','gigabytes',1,'2025-11-24 10:05:10',NULL),('2025-11-23 10:05:10','2025-11-23 10:05:10','2025-11-23 10:05:10',1,435,'e609c649-832e-4ade-905f-1b2735ba1d62',105,'e456b00c470e4f58a0cb2eb0ed097106','volumes_tripleo',1,'2025-11-24 10:05:10',NULL),('2025-11-23 10:05:10','2025-11-23 10:05:10','2025-11-23 10:05:10',1,436,'bded4983-1cff-44a2-a107-b414a52b8cd4',106,'e456b00c470e4f58a0cb2eb0ed097106','gigabytes_tripleo',1,'2025-11-24 10:05:10',NULL),('2025-11-23 10:05:11','2025-11-23 10:05:11','2025-11-23 10:05:11',1,437,'16562028-6864-47b0-86bd-0c3cdf7775ee',103,'e456b00c470e4f58a0cb2eb0ed097106','volumes',1,'2025-11-24 10:05:11',NULL),('2025-11-23 10:05:11','2025-11-23 10:05:11','2025-11-23 10:05:11',1,438,'8401c0f9-6aa6-4f7a-ad27-793a327290f7',104,'e456b00c470e4f58a0cb2eb0ed097106','gigabytes',2,'2025-11-24 10:05:11',NULL),('2025-11-23 10:05:11','2025-11-23 10:05:11','2025-11-23 10:05:11',1,439,'90005d6c-ebed-4d83-b23e-d511be204c1e',105,'e456b00c470e4f58a0cb2eb0ed097106','volumes_tripleo',1,'2025-11-24 10:05:11',NULL),('2025-11-23 10:05:11','2025-11-23 10:05:11','2025-11-23 10:05:11',1,440,'109ebbbf-28d8-44b7-a703-7c53166d82cd',106,'e456b00c470e4f58a0cb2eb0ed097106','gigabytes_tripleo',2,'2025-11-24 10:05:11',NULL),('2025-11-23 10:05:14','2025-11-23 10:05:14','2025-11-23 10:05:14',1,441,'6b6f677d-86c5-4b49-8e51-8c61b9972291',103,'e456b00c470e4f58a0cb2eb0ed097106','volumes',-1,'2025-11-24 10:05:14',NULL),('2025-11-23 10:05:14','2025-11-23 10:05:14','2025-11-23 10:05:14',1,442,'6d414eb3-412d-49b4-8a1a-77fc89791e28',104,'e456b00c470e4f58a0cb2eb0ed097106','gigabytes',-2,'2025-11-24 10:05:14',NULL),('2025-11-23 10:05:14','2025-11-23 10:05:14','2025-11-23 10:05:14',1,443,'789c8d35-0af0-4536-aec7-0622ab6bcf57',105,'e456b00c470e4f58a0cb2eb0ed097106','volumes_tripleo',-1,'2025-11-24 10:05:14',NULL),('2025-11-23 10:05:14','2025-11-23 10:05:14','2025-11-23 10:05:14',1,444,'c75ff6c0-441e-48f4-b9d9-ea5b67b4f938',106,'e456b00c470e4f58a0cb2eb0ed097106','gigabytes_tripleo',-2,'2025-11-24 10:05:14',NULL),('2025-11-23 10:05:14','2025-11-23 10:05:14','2025-11-23 10:05:14',1,445,'d762c077-cb95-4a3f-b633-bec5cb106dc7',107,'ba426e81cfe149da986575955289d04b','volumes',1,'2025-11-24 10:05:14',NULL),('2025-11-23 10:05:14','2025-11-23 10:05:14','2025-11-23 10:05:14',1,446,'35c5bc7b-9ace-4fd0-a078-fa453cc24318',108,'ba426e81cfe149da986575955289d04b','gigabytes',1,'2025-11-24 10:05:14',NULL),('2025-11-23 10:05:14','2025-11-23 10:05:14','2025-11-23 10:05:14',1,447,'4aafc85d-2295-44bc-8f30-75a2af53de25',109,'ba426e81cfe149da986575955289d04b','volumes_tripleo',1,'2025-11-24 10:05:14',NULL),('2025-11-23 10:05:14','2025-11-23 10:05:14','2025-11-23 10:05:14',1,448,'00bb672f-889e-4511-8ddb-f4cf0eb92a07',110,'ba426e81cfe149da986575955289d04b','gigabytes_tripleo',1,'2025-11-24 10:05:14',NULL),('2025-11-23 10:05:15','2025-11-23 10:05:15','2025-11-23 10:05:15',1,449,'8f24c2ce-e2ad-4ced-b56d-af8613b58fff',103,'e456b00c470e4f58a0cb2eb0ed097106','volumes',-1,'2025-11-24 10:05:15',NULL),('2025-11-23 10:05:15','2025-11-23 10:05:15','2025-11-23 10:05:15',1,450,'c8471ac5-51ad-45b1-8968-d07b71c4f10b',104,'e456b00c470e4f58a0cb2eb0ed097106','gigabytes',-1,'2025-11-24 10:05:15',NULL),('2025-11-23 10:05:15','2025-11-23 10:05:15','2025-11-23 10:05:15',1,451,'0f88a88c-9788-4817-828b-83eb7a2bc46a',105,'e456b00c470e4f58a0cb2eb0ed097106','volumes_tripleo',-1,'2025-11-24 10:05:15',NULL),('2025-11-23 10:05:15','2025-11-23 10:05:15','2025-11-23 10:05:15',1,452,'198d5da2-0636-4b97-a575-ee80de5ba154',106,'e456b00c470e4f58a0cb2eb0ed097106','gigabytes_tripleo',-1,'2025-11-24 10:05:15',NULL),('2025-11-23 10:05:16','2025-11-23 10:05:17','2025-11-23 10:05:17',1,453,'ebcc4871-b789-4e5b-80c4-e957f62a4916',107,'ba426e81cfe149da986575955289d04b','volumes',-1,'2025-11-24 10:05:16',NULL),('2025-11-23 10:05:16','2025-11-23 10:05:17','2025-11-23 10:05:17',1,454,'18dedaf2-c81c-4e84-b63e-4cee88626438',108,'ba426e81cfe149da986575955289d04b','gigabytes',-1,'2025-11-24 10:05:16',NULL),('2025-11-23 10:05:16','2025-11-23 10:05:17','2025-11-23 10:05:17',1,455,'1ee1fb27-5682-4c6a-a591-9c6007affb14',109,'ba426e81cfe149da986575955289d04b','volumes_tripleo',-1,'2025-11-24 10:05:16',NULL),('2025-11-23 10:05:16','2025-11-23 10:05:17','2025-11-23 10:05:17',1,456,'790b86a9-c650-4a20-9c78-be13875b4335',110,'ba426e81cfe149da986575955289d04b','gigabytes_tripleo',-1,'2025-11-24 10:05:16',NULL),('2025-11-23 10:05:17','2025-11-23 10:05:17','2025-11-23 10:05:17',1,457,'1b051027-3a20-41c8-8508-3b8a41f2cb39',107,'ba426e81cfe149da986575955289d04b','volumes',1,'2025-11-24 10:05:17',NULL),('2025-11-23 10:05:17','2025-11-23 10:05:17','2025-11-23 10:05:17',1,458,'83ce49c9-101a-4b36-a818-7b1492f047ae',108,'ba426e81cfe149da986575955289d04b','gigabytes',1,'2025-11-24 10:05:17',NULL),('2025-11-23 10:05:17','2025-11-23 10:05:17','2025-11-23 10:05:17',1,459,'289a2c81-3be4-4fff-8505-96604ea359d8',109,'ba426e81cfe149da986575955289d04b','volumes_tripleo',1,'2025-11-24 10:05:17',NULL),('2025-11-23 10:05:17','2025-11-23 10:05:17','2025-11-23 10:05:17',1,460,'97b80ecf-6678-4c8f-bb65-bb3def3307cd',110,'ba426e81cfe149da986575955289d04b','gigabytes_tripleo',1,'2025-11-24 10:05:17',NULL),('2025-11-23 10:05:19','2025-11-23 10:05:19','2025-11-23 10:05:19',1,461,'73e2071b-d6f2-4aa1-bb29-e06fac899c6f',107,'ba426e81cfe149da986575955289d04b','volumes',-1,'2025-11-24 10:05:19',NULL),('2025-11-23 10:05:19','2025-11-23 10:05:19','2025-11-23 10:05:19',1,462,'05013c7f-8217-487c-b493-6c6924ac6ad9',108,'ba426e81cfe149da986575955289d04b','gigabytes',-1,'2025-11-24 10:05:19',NULL),('2025-11-23 10:05:19','2025-11-23 10:05:19','2025-11-23 10:05:19',1,463,'a321c9ff-f685-409a-ae47-09835f9747a7',109,'ba426e81cfe149da986575955289d04b','volumes_tripleo',-1,'2025-11-24 10:05:19',NULL),('2025-11-23 10:05:19','2025-11-23 10:05:19','2025-11-23 10:05:19',1,464,'7d5c34a5-c8ef-4ea3-b2c0-b93702687841',110,'ba426e81cfe149da986575955289d04b','gigabytes_tripleo',-1,'2025-11-24 10:05:19',NULL),('2025-11-23 10:05:20','2025-11-23 10:05:20','2025-11-23 10:05:20',1,465,'9b8dd0c7-d507-4e75-8112-3d8d295a11a1',107,'ba426e81cfe149da986575955289d04b','volumes',1,'2025-11-24 10:05:20',NULL),('2025-11-23 10:05:20','2025-11-23 10:05:20','2025-11-23 10:05:20',1,466,'4685214e-8ffc-4e23-9aba-3a777d68fdf9',108,'ba426e81cfe149da986575955289d04b','gigabytes',1,'2025-11-24 10:05:20',NULL),('2025-11-23 10:05:20','2025-11-23 10:05:20','2025-11-23 10:05:20',1,467,'95cc8e8d-b1ae-4676-af2d-698be2e622c2',109,'ba426e81cfe149da986575955289d04b','volumes_tripleo',1,'2025-11-24 10:05:20',NULL),('2025-11-23 10:05:20','2025-11-23 10:05:20','2025-11-23 10:05:20',1,468,'e034d182-c9a0-44c5-9876-14ae6862763f',110,'ba426e81cfe149da986575955289d04b','gigabytes_tripleo',1,'2025-11-24 10:05:20',NULL),('2025-11-23 10:05:22','2025-11-23 10:05:22','2025-11-23 10:05:22',1,469,'58d27e80-a226-40fc-a1b5-f84acbf56ff8',107,'ba426e81cfe149da986575955289d04b','volumes',-1,'2025-11-24 10:05:22',NULL),('2025-11-23 10:05:22','2025-11-23 10:05:22','2025-11-23 10:05:22',1,470,'90bc6e60-8013-4532-aceb-ee494e87f12b',108,'ba426e81cfe149da986575955289d04b','gigabytes',-1,'2025-11-24 10:05:22',NULL),('2025-11-23 10:05:22','2025-11-23 10:05:22','2025-11-23 10:05:22',1,471,'9852b390-0d27-497a-b969-aa9ddc99d773',109,'ba426e81cfe149da986575955289d04b','volumes_tripleo',-1,'2025-11-24 10:05:22',NULL),('2025-11-23 10:05:22','2025-11-23 10:05:22','2025-11-23 10:05:22',1,472,'aa0eb65e-a94b-4aee-b0bb-71f7b284632f',110,'ba426e81cfe149da986575955289d04b','gigabytes_tripleo',-1,'2025-11-24 10:05:22',NULL),('2025-11-23 10:05:22','2025-11-23 10:05:22','2025-11-23 10:05:22',1,473,'bfdd3c74-2121-4498-9e4b-29b227e395c7',111,'e26ac473e8284e80b775ad7fd47ae6ec','volumes',1,'2025-11-24 10:05:22',NULL),('2025-11-23 10:05:22','2025-11-23 10:05:22','2025-11-23 10:05:22',1,474,'9f0f1b06-0515-4d8d-8969-81cfa254b898',112,'e26ac473e8284e80b775ad7fd47ae6ec','gigabytes',1,'2025-11-24 10:05:22',NULL),('2025-11-23 10:05:22','2025-11-23 10:05:22','2025-11-23 10:05:22',1,475,'a87c719b-f9a7-4d83-882c-c0aecc88b7b8',113,'e26ac473e8284e80b775ad7fd47ae6ec','volumes_tripleo',1,'2025-11-24 10:05:22',NULL),('2025-11-23 10:05:22','2025-11-23 10:05:22','2025-11-23 10:05:22',1,476,'83860047-3cd3-42f2-b817-ce680fba0909',114,'e26ac473e8284e80b775ad7fd47ae6ec','gigabytes_tripleo',1,'2025-11-24 10:05:22',NULL),('2025-11-23 10:05:22','2025-11-23 10:05:22','2025-11-23 10:05:22',1,477,'4bcc79f9-edfc-496b-a45e-cd9695674872',107,'ba426e81cfe149da986575955289d04b','volumes',1,'2025-11-24 10:05:22',NULL),('2025-11-23 10:05:22','2025-11-23 10:05:22','2025-11-23 10:05:22',1,478,'5043570e-2108-4413-8ad1-7719a3a23e36',108,'ba426e81cfe149da986575955289d04b','gigabytes',1,'2025-11-24 10:05:22',NULL),('2025-11-23 10:05:22','2025-11-23 10:05:22','2025-11-23 10:05:22',1,479,'a8ef96ec-e091-4439-be0e-195db6e414dc',109,'ba426e81cfe149da986575955289d04b','volumes_tripleo',1,'2025-11-24 10:05:22',NULL),('2025-11-23 10:05:22','2025-11-23 10:05:22','2025-11-23 10:05:22',1,480,'4eb4d5de-2e28-49b0-887c-d6d7706db968',110,'ba426e81cfe149da986575955289d04b','gigabytes_tripleo',1,'2025-11-24 10:05:22',NULL),('2025-11-23 10:05:23','2025-11-23 10:05:23','2025-11-23 10:05:23',1,481,'5289dd60-9c4f-4436-b163-7342c34c5884',115,'e26ac473e8284e80b775ad7fd47ae6ec','snapshots',1,'2025-11-24 10:05:23',NULL),('2025-11-23 10:05:23','2025-11-23 10:05:23','2025-11-23 10:05:23',1,482,'ddd3fd9c-c512-42a8-89d3-7dfdc88fe220',112,'e26ac473e8284e80b775ad7fd47ae6ec','gigabytes',1,'2025-11-24 10:05:23',NULL),('2025-11-23 10:05:23','2025-11-23 10:05:23','2025-11-23 10:05:23',1,483,'8921a022-03b8-469d-8793-7df96e51e7af',114,'e26ac473e8284e80b775ad7fd47ae6ec','gigabytes_tripleo',1,'2025-11-24 10:05:23',NULL),('2025-11-23 10:05:23','2025-11-23 10:05:23','2025-11-23 10:05:23',1,484,'34f7d4ca-d537-47cc-a424-d98597076205',116,'e26ac473e8284e80b775ad7fd47ae6ec','snapshots_tripleo',1,'2025-11-24 10:05:23',NULL),('2025-11-23 10:05:24','2025-11-23 10:05:24','2025-11-23 10:05:24',1,485,'987749e1-5f2a-46fa-b9e0-407227fb5489',107,'ba426e81cfe149da986575955289d04b','volumes',-1,'2025-11-24 10:05:24',NULL),('2025-11-23 10:05:24','2025-11-23 10:05:24','2025-11-23 10:05:24',1,486,'22e6bfa2-8b32-4acc-a779-675d4c0c1979',108,'ba426e81cfe149da986575955289d04b','gigabytes',-1,'2025-11-24 10:05:24',NULL),('2025-11-23 10:05:24','2025-11-23 10:05:24','2025-11-23 10:05:24',1,487,'7873acea-ec07-4548-9c71-c7855ad62f0e',109,'ba426e81cfe149da986575955289d04b','volumes_tripleo',-1,'2025-11-24 10:05:24',NULL),('2025-11-23 10:05:24','2025-11-23 10:05:24','2025-11-23 10:05:24',1,488,'4e9d31a6-8832-4d0b-b413-8ca851eac0cc',110,'ba426e81cfe149da986575955289d04b','gigabytes_tripleo',-1,'2025-11-24 10:05:24',NULL),('2025-11-23 10:05:25','2025-11-23 10:05:25','2025-11-23 10:05:25',1,489,'63d0c375-b5e1-4364-b038-156e8cf13534',115,'e26ac473e8284e80b775ad7fd47ae6ec','snapshots',1,'2025-11-24 10:05:25',NULL),('2025-11-23 10:05:25','2025-11-23 10:05:25','2025-11-23 10:05:25',1,490,'27cf7a6c-5e29-452e-83ca-1d5756f6d132',112,'e26ac473e8284e80b775ad7fd47ae6ec','gigabytes',1,'2025-11-24 10:05:25',NULL),('2025-11-23 10:05:25','2025-11-23 10:05:25','2025-11-23 10:05:25',1,491,'302c9003-55a5-4da0-bcf9-357c2e03e248',114,'e26ac473e8284e80b775ad7fd47ae6ec','gigabytes_tripleo',1,'2025-11-24 10:05:25',NULL),('2025-11-23 10:05:25','2025-11-23 10:05:25','2025-11-23 10:05:25',1,492,'d92b2ffe-f0a0-4086-84c1-a6f4369b474b',116,'e26ac473e8284e80b775ad7fd47ae6ec','snapshots_tripleo',1,'2025-11-24 10:05:25',NULL),('2025-11-23 10:05:25','2025-11-23 10:05:25','2025-11-23 10:05:25',1,493,'e439649a-c898-4b68-aa4c-fbd1cc59ae0c',107,'ba426e81cfe149da986575955289d04b','volumes',1,'2025-11-24 10:05:25',NULL),('2025-11-23 10:05:25','2025-11-23 10:05:25','2025-11-23 10:05:25',1,494,'0cb45d50-8e9d-42fc-a227-9bf929f605c4',108,'ba426e81cfe149da986575955289d04b','gigabytes',1,'2025-11-24 10:05:25',NULL),('2025-11-23 10:05:25','2025-11-23 10:05:25','2025-11-23 10:05:25',1,495,'6e37a4f1-c6ef-4646-8a19-ffd6f73d4447',109,'ba426e81cfe149da986575955289d04b','volumes_tripleo',1,'2025-11-24 10:05:25',NULL),('2025-11-23 10:05:25','2025-11-23 10:05:25','2025-11-23 10:05:25',1,496,'99d57ebe-f5f1-4a86-8e64-8987f4cc6a81',110,'ba426e81cfe149da986575955289d04b','gigabytes_tripleo',1,'2025-11-24 10:05:25',NULL),('2025-11-23 10:05:27','2025-11-23 10:05:27','2025-11-23 10:05:27',1,497,'bf2de5af-5e4e-4004-8e79-75c1eb0272d8',107,'ba426e81cfe149da986575955289d04b','volumes',-1,'2025-11-24 10:05:27',NULL),('2025-11-23 10:05:27','2025-11-23 10:05:27','2025-11-23 10:05:27',1,498,'aef61263-ebb5-40ac-8f3c-5b6852cf091e',108,'ba426e81cfe149da986575955289d04b','gigabytes',-1,'2025-11-24 10:05:27',NULL),('2025-11-23 10:05:27','2025-11-23 10:05:27','2025-11-23 10:05:27',1,499,'63c3cb69-3202-4c94-b6dc-3190469c013d',109,'ba426e81cfe149da986575955289d04b','volumes_tripleo',-1,'2025-11-24 10:05:27',NULL),('2025-11-23 10:05:27','2025-11-23 10:05:27','2025-11-23 10:05:27',1,500,'4f92a477-f4da-4000-bc01-36191281bed1',110,'ba426e81cfe149da986575955289d04b','gigabytes_tripleo',-1,'2025-11-24 10:05:27',NULL),('2025-11-23 10:05:27','2025-11-23 10:05:27','2025-11-23 10:05:27',1,501,'63065e13-cf08-4836-980e-1b5c525a8fa9',117,'fb2fe4c3f84642bbad40631e42e594dd','groups',1,'2025-11-24 10:05:27',NULL),('2025-11-23 10:05:28','2025-11-23 10:05:28','2025-11-23 10:05:28',1,502,'c9570eb2-0cdb-4489-8cce-ce4bade94968',115,'e26ac473e8284e80b775ad7fd47ae6ec','snapshots',-1,'2025-11-24 10:05:28',NULL),('2025-11-23 10:05:28','2025-11-23 10:05:28','2025-11-23 10:05:28',1,503,'9e0254b6-9752-4798-86b4-82f18d984622',112,'e26ac473e8284e80b775ad7fd47ae6ec','gigabytes',-1,'2025-11-24 10:05:28',NULL),('2025-11-23 10:05:28','2025-11-23 10:05:28','2025-11-23 10:05:28',1,504,'41392d18-2df2-4f06-9cd0-2cf512902cd5',114,'e26ac473e8284e80b775ad7fd47ae6ec','gigabytes_tripleo',-1,'2025-11-24 10:05:28',NULL),('2025-11-23 10:05:28','2025-11-23 10:05:28','2025-11-23 10:05:28',1,505,'d2476f61-f82e-4f36-a671-cc4641771a13',116,'e26ac473e8284e80b775ad7fd47ae6ec','snapshots_tripleo',-1,'2025-11-24 10:05:28',NULL),('2025-11-23 10:05:28','2025-11-23 10:05:28','2025-11-23 10:05:28',1,506,'353eb5bb-9848-4ae8-bd9a-7f28ac4fac93',115,'e26ac473e8284e80b775ad7fd47ae6ec','snapshots',1,'2025-11-24 10:05:28',NULL),('2025-11-23 10:05:28','2025-11-23 10:05:28','2025-11-23 10:05:28',1,507,'1d79f263-b0e7-465c-a215-6d87b6b88cce',112,'e26ac473e8284e80b775ad7fd47ae6ec','gigabytes',1,'2025-11-24 10:05:28',NULL),('2025-11-23 10:05:28','2025-11-23 10:05:28','2025-11-23 10:05:28',1,508,'6c4a03ae-7fc4-49d5-ade7-46fb67f19be6',114,'e26ac473e8284e80b775ad7fd47ae6ec','gigabytes_tripleo',1,'2025-11-24 10:05:28',NULL),('2025-11-23 10:05:28','2025-11-23 10:05:28','2025-11-23 10:05:28',1,509,'3b6230de-620a-4243-a342-346e12f7b80e',116,'e26ac473e8284e80b775ad7fd47ae6ec','snapshots_tripleo',1,'2025-11-24 10:05:28',NULL),('2025-11-23 10:05:28','2025-11-23 10:05:28','2025-11-23 10:05:28',1,510,'126e0a68-8b20-441e-8686-f3e3995ed495',117,'fb2fe4c3f84642bbad40631e42e594dd','groups',1,'2025-11-24 10:05:28',NULL),('2025-11-23 10:05:30','2025-11-23 10:05:30','2025-11-23 10:05:30',1,511,'933e59fa-0ba1-4741-ae39-64b15df04063',118,'fb2fe4c3f84642bbad40631e42e594dd','volumes',1,'2025-11-24 10:05:30',NULL),('2025-11-23 10:05:30','2025-11-23 10:05:30','2025-11-23 10:05:30',1,512,'c1cf590f-3f66-4cd6-a3b7-fed02246e1c8',119,'fb2fe4c3f84642bbad40631e42e594dd','gigabytes',1,'2025-11-24 10:05:30',NULL),('2025-11-23 10:05:30','2025-11-23 10:05:30','2025-11-23 10:05:30',1,513,'e5c60e45-17b6-4a8c-b715-c014a3c8b0dc',120,'fb2fe4c3f84642bbad40631e42e594dd','volumes_tempest-GroupsTest-volume-type-1960407744',1,'2025-11-24 10:05:30',NULL),('2025-11-23 10:05:30','2025-11-23 10:05:30','2025-11-23 10:05:30',1,514,'de3d1bf1-b4a5-4684-956c-8c675c384e44',121,'fb2fe4c3f84642bbad40631e42e594dd','gigabytes_tempest-GroupsTest-volume-type-1960407744',1,'2025-11-24 10:05:30',NULL),('2025-11-23 10:05:32','2025-11-23 10:05:32','2025-11-23 10:05:32',1,515,'57f46547-5cd8-49df-908b-9d11d9439e4a',115,'e26ac473e8284e80b775ad7fd47ae6ec','snapshots',-1,'2025-11-24 10:05:32',NULL),('2025-11-23 10:05:32','2025-11-23 10:05:32','2025-11-23 10:05:32',1,516,'84c0b33c-933f-4246-b086-56446b898a4b',112,'e26ac473e8284e80b775ad7fd47ae6ec','gigabytes',-1,'2025-11-24 10:05:32',NULL),('2025-11-23 10:05:32','2025-11-23 10:05:32','2025-11-23 10:05:32',1,517,'441c3ce7-d8ab-43c1-80b3-cc6ad6a2822a',114,'e26ac473e8284e80b775ad7fd47ae6ec','gigabytes_tripleo',-1,'2025-11-24 10:05:32',NULL),('2025-11-23 10:05:32','2025-11-23 10:05:32','2025-11-23 10:05:32',1,518,'1e103dd8-351e-4cdf-ae50-8bccf3435513',116,'e26ac473e8284e80b775ad7fd47ae6ec','snapshots_tripleo',-1,'2025-11-24 10:05:32',NULL),('2025-11-23 10:05:32','2025-11-23 10:05:32','2025-11-23 10:05:32',1,519,'e34f35c5-77cf-432e-afcc-280d7eef8a22',117,'fb2fe4c3f84642bbad40631e42e594dd','groups',-1,'2025-11-24 10:05:32',NULL),('2025-11-23 10:05:32','2025-11-23 10:05:32','2025-11-23 10:05:32',1,520,'815ded1a-2166-4312-b7cf-83539f2f31c9',118,'fb2fe4c3f84642bbad40631e42e594dd','volumes',-1,'2025-11-24 10:05:32',NULL),('2025-11-23 10:05:32','2025-11-23 10:05:32','2025-11-23 10:05:32',1,521,'f4f64ea5-f6e5-44a6-8244-cce1d1b8185e',119,'fb2fe4c3f84642bbad40631e42e594dd','gigabytes',-1,'2025-11-24 10:05:32',NULL),('2025-11-23 10:05:32','2025-11-23 10:05:32','2025-11-23 10:05:32',1,522,'602e3ad9-4f54-4ff8-976a-8727147724f5',120,'fb2fe4c3f84642bbad40631e42e594dd','volumes_tempest-GroupsTest-volume-type-1960407744',-1,'2025-11-24 10:05:32',NULL),('2025-11-23 10:05:32','2025-11-23 10:05:32','2025-11-23 10:05:32',1,523,'349b9461-c45a-4cbf-a19e-b380ff744342',121,'fb2fe4c3f84642bbad40631e42e594dd','gigabytes_tempest-GroupsTest-volume-type-1960407744',-1,'2025-11-24 10:05:32',NULL),('2025-11-23 10:05:33','2025-11-23 10:05:33','2025-11-23 10:05:33',1,524,'a22fc6c1-3c4f-451e-91f6-c2af4dd84202',117,'fb2fe4c3f84642bbad40631e42e594dd','groups',-1,'2025-11-24 10:05:33',NULL),('2025-11-23 10:05:33','2025-11-23 10:05:33','2025-11-23 10:05:33',1,525,'e68aabcf-2c42-4a0b-bf20-7da01e33334b',115,'e26ac473e8284e80b775ad7fd47ae6ec','snapshots',1,'2025-11-24 10:05:33',NULL),('2025-11-23 10:05:33','2025-11-23 10:05:33','2025-11-23 10:05:33',1,526,'248307a5-b60e-44d0-9434-06c75f15bfd0',112,'e26ac473e8284e80b775ad7fd47ae6ec','gigabytes',1,'2025-11-24 10:05:33',NULL),('2025-11-23 10:05:33','2025-11-23 10:05:33','2025-11-23 10:05:33',1,527,'a6c9ed90-b7d1-4652-ae78-3215152ed1b6',114,'e26ac473e8284e80b775ad7fd47ae6ec','gigabytes_tripleo',1,'2025-11-24 10:05:33',NULL),('2025-11-23 10:05:33','2025-11-23 10:05:33','2025-11-23 10:05:33',1,528,'5362faf5-bd68-4335-8052-f479b7f08c2b',116,'e26ac473e8284e80b775ad7fd47ae6ec','snapshots_tripleo',1,'2025-11-24 10:05:33',NULL),('2025-11-23 10:05:34','2025-11-23 10:05:34','2025-11-23 10:05:34',1,529,'f251301b-9410-4533-af54-f617ca5d4837',117,'fb2fe4c3f84642bbad40631e42e594dd','groups',1,'2025-11-24 10:05:34',NULL),('2025-11-23 10:05:35','2025-11-23 10:05:35','2025-11-23 10:05:35',1,530,'404d6116-a33b-4162-b71e-ce3f7b546d35',115,'e26ac473e8284e80b775ad7fd47ae6ec','snapshots',-1,'2025-11-24 10:05:35',NULL),('2025-11-23 10:05:35','2025-11-23 10:05:35','2025-11-23 10:05:35',1,531,'a213fe76-b7cd-4819-9ed2-215ccd530f16',112,'e26ac473e8284e80b775ad7fd47ae6ec','gigabytes',-1,'2025-11-24 10:05:35',NULL),('2025-11-23 10:05:35','2025-11-23 10:05:35','2025-11-23 10:05:35',1,532,'52ed0276-5bd9-4991-8077-4fe63905bb6f',114,'e26ac473e8284e80b775ad7fd47ae6ec','gigabytes_tripleo',-1,'2025-11-24 10:05:35',NULL),('2025-11-23 10:05:35','2025-11-23 10:05:35','2025-11-23 10:05:35',1,533,'f3338ee7-e5b7-4088-852e-60f55deaa6d7',116,'e26ac473e8284e80b775ad7fd47ae6ec','snapshots_tripleo',-1,'2025-11-24 10:05:35',NULL),('2025-11-23 10:05:36','2025-11-23 10:05:36','2025-11-23 10:05:36',1,534,'0a3291cd-f03a-431e-96ba-6314e4530cff',115,'e26ac473e8284e80b775ad7fd47ae6ec','snapshots',1,'2025-11-24 10:05:36',NULL),('2025-11-23 10:05:36','2025-11-23 10:05:36','2025-11-23 10:05:36',1,535,'6eb8c21d-c88d-45ff-befd-f5850f2a919c',112,'e26ac473e8284e80b775ad7fd47ae6ec','gigabytes',1,'2025-11-24 10:05:36',NULL),('2025-11-23 10:05:36','2025-11-23 10:05:36','2025-11-23 10:05:36',1,536,'fe006c48-9d40-489d-a642-9e48b1eca471',114,'e26ac473e8284e80b775ad7fd47ae6ec','gigabytes_tripleo',1,'2025-11-24 10:05:36',NULL),('2025-11-23 10:05:36','2025-11-23 10:05:36','2025-11-23 10:05:36',1,537,'226288e8-4813-46e6-8072-5363e59d4566',116,'e26ac473e8284e80b775ad7fd47ae6ec','snapshots_tripleo',1,'2025-11-24 10:05:36',NULL),('2025-11-23 10:05:36','2025-11-23 10:05:36','2025-11-23 10:05:36',1,538,'32569062-8226-4a2a-ac79-70474ee4f5a8',118,'fb2fe4c3f84642bbad40631e42e594dd','volumes',1,'2025-11-24 10:05:36',NULL),('2025-11-23 10:05:36','2025-11-23 10:05:36','2025-11-23 10:05:36',1,539,'fcf454f8-27b9-44a0-8044-8cfd4f32cf22',119,'fb2fe4c3f84642bbad40631e42e594dd','gigabytes',1,'2025-11-24 10:05:36',NULL),('2025-11-23 10:05:36','2025-11-23 10:05:36','2025-11-23 10:05:36',1,540,'b94312e0-e2e8-41c6-b5c6-b41ba5bfa835',122,'fb2fe4c3f84642bbad40631e42e594dd','volumes_tempest-GroupsTest-volume-type-1184049508',1,'2025-11-24 10:05:36',NULL),('2025-11-23 10:05:36','2025-11-23 10:05:36','2025-11-23 10:05:36',1,541,'3b589e1d-46f6-4abc-9933-75412c15baa2',123,'fb2fe4c3f84642bbad40631e42e594dd','gigabytes_tempest-GroupsTest-volume-type-1184049508',1,'2025-11-24 10:05:36',NULL),('2025-11-23 10:05:37','2025-11-23 10:05:37','2025-11-23 10:05:37',1,542,'07879bf3-fbae-498c-8d34-1279921abbce',118,'fb2fe4c3f84642bbad40631e42e594dd','volumes',1,'2025-11-24 10:05:37',NULL),('2025-11-23 10:05:37','2025-11-23 10:05:37','2025-11-23 10:05:37',1,543,'fdfc88fa-a453-42cf-b2c0-3afd853aa624',119,'fb2fe4c3f84642bbad40631e42e594dd','gigabytes',1,'2025-11-24 10:05:37',NULL),('2025-11-23 10:05:37','2025-11-23 10:05:37','2025-11-23 10:05:37',1,544,'23439485-2673-41d7-bd4d-cedb2ec01628',122,'fb2fe4c3f84642bbad40631e42e594dd','volumes_tempest-GroupsTest-volume-type-1184049508',1,'2025-11-24 10:05:37',NULL),('2025-11-23 10:05:37','2025-11-23 10:05:37','2025-11-23 10:05:37',1,545,'702823e2-e4f9-4969-b215-dfe219f31e22',123,'fb2fe4c3f84642bbad40631e42e594dd','gigabytes_tempest-GroupsTest-volume-type-1184049508',1,'2025-11-24 10:05:37',NULL),('2025-11-23 10:05:39','2025-11-23 10:05:39','2025-11-23 10:05:39',1,546,'26b855d5-289d-45df-8f71-f56801e4b94f',115,'e26ac473e8284e80b775ad7fd47ae6ec','snapshots',-1,'2025-11-24 10:05:39',NULL),('2025-11-23 10:05:39','2025-11-23 10:05:39','2025-11-23 10:05:39',1,547,'5bff4e80-804d-4ff2-ba47-cda496299827',112,'e26ac473e8284e80b775ad7fd47ae6ec','gigabytes',-1,'2025-11-24 10:05:39',NULL),('2025-11-23 10:05:39','2025-11-23 10:05:39','2025-11-23 10:05:39',1,548,'c3c46bea-ccb3-4b4f-9342-8eb47475d92e',114,'e26ac473e8284e80b775ad7fd47ae6ec','gigabytes_tripleo',-1,'2025-11-24 10:05:39',NULL),('2025-11-23 10:05:39','2025-11-23 10:05:39','2025-11-23 10:05:39',1,549,'bd39ed21-4073-4368-86bc-b5c051335eec',116,'e26ac473e8284e80b775ad7fd47ae6ec','snapshots_tripleo',-1,'2025-11-24 10:05:39',NULL),('2025-11-23 10:05:40','2025-11-23 10:05:40','2025-11-23 10:05:40',1,550,'673b560f-25f1-4413-b039-f4227bc1b1ed',124,'737e70c24c3a4eac85267456be6774fa','volumes',1,'2025-11-24 10:05:40',NULL),('2025-11-23 10:05:40','2025-11-23 10:05:40','2025-11-23 10:05:40',1,551,'b830f6b2-e5bd-4f46-9611-c1e6f282d93a',125,'737e70c24c3a4eac85267456be6774fa','gigabytes',2,'2025-11-24 10:05:40',NULL),('2025-11-23 10:05:40','2025-11-23 10:05:40','2025-11-23 10:05:40',1,552,'f8e4fc8e-3ddf-4d42-968e-5031402ef894',126,'737e70c24c3a4eac85267456be6774fa','volumes_tripleo',1,'2025-11-24 10:05:40',NULL),('2025-11-23 10:05:40','2025-11-23 10:05:40','2025-11-23 10:05:40',1,553,'b4f35435-fff1-4224-b5af-2fa48dbc4b47',127,'737e70c24c3a4eac85267456be6774fa','gigabytes_tripleo',2,'2025-11-24 10:05:40',NULL),('2025-11-23 10:05:41','2025-11-23 10:05:41','2025-11-23 10:05:41',1,554,'bb350081-cb2e-4a92-a99d-7342c48c2cea',115,'e26ac473e8284e80b775ad7fd47ae6ec','snapshots',-1,'2025-11-24 10:05:41',NULL),('2025-11-23 10:05:41','2025-11-23 10:05:41','2025-11-23 10:05:41',1,555,'09edd3ea-f9c5-4373-9e48-43d06865a5d0',112,'e26ac473e8284e80b775ad7fd47ae6ec','gigabytes',-1,'2025-11-24 10:05:41',NULL),('2025-11-23 10:05:41','2025-11-23 10:05:41','2025-11-23 10:05:41',1,556,'eb54b351-5611-4949-abc6-ea3e268968ec',114,'e26ac473e8284e80b775ad7fd47ae6ec','gigabytes_tripleo',-1,'2025-11-24 10:05:41',NULL),('2025-11-23 10:05:41','2025-11-23 10:05:41','2025-11-23 10:05:41',1,557,'0ef29f65-2ddf-457f-a60d-2b3f1f8fdda3',116,'e26ac473e8284e80b775ad7fd47ae6ec','snapshots_tripleo',-1,'2025-11-24 10:05:41',NULL),('2025-11-23 10:05:42','2025-11-23 10:05:42','2025-11-23 10:05:42',1,558,'70d3af15-c6e5-45e6-b483-3c736cc5b93b',124,'737e70c24c3a4eac85267456be6774fa','volumes',-1,'2025-11-24 10:05:42',NULL),('2025-11-23 10:05:42','2025-11-23 10:05:42','2025-11-23 10:05:42',1,559,'4ec7edd8-6a32-4e11-989a-396db08b1817',125,'737e70c24c3a4eac85267456be6774fa','gigabytes',-2,'2025-11-24 10:05:42',NULL),('2025-11-23 10:05:42','2025-11-23 10:05:42','2025-11-23 10:05:42',1,560,'e84c58c8-935a-43e3-bf28-a3f74033a46c',126,'737e70c24c3a4eac85267456be6774fa','volumes_tripleo',-1,'2025-11-24 10:05:42',NULL),('2025-11-23 10:05:42','2025-11-23 10:05:42','2025-11-23 10:05:42',1,561,'0fafaa81-e1dc-474d-b763-b535b4058156',127,'737e70c24c3a4eac85267456be6774fa','gigabytes_tripleo',-2,'2025-11-24 10:05:42',NULL),('2025-11-23 10:05:43','2025-11-23 10:05:43','2025-11-23 10:05:43',1,562,'24bd7548-247e-479a-ad34-278fdebbda8f',128,'b26c9bed083447548be26f4feb5dd112','groups',1,'2025-11-24 10:05:43',NULL),('2025-11-23 10:05:43','2025-11-23 10:05:43','2025-11-23 10:05:43',1,563,'46313109-9933-4a64-9008-937ea12fc560',117,'fb2fe4c3f84642bbad40631e42e594dd','groups',-1,'2025-11-24 10:05:43',NULL),('2025-11-23 10:05:43','2025-11-23 10:05:43','2025-11-23 10:05:43',1,564,'69d480ce-b372-40b5-b704-2816c523189d',118,'fb2fe4c3f84642bbad40631e42e594dd','volumes',-1,'2025-11-24 10:05:43',NULL),('2025-11-23 10:05:43','2025-11-23 10:05:43','2025-11-23 10:05:43',1,565,'078fb8a1-4e29-43a2-b5bd-7c91475e1465',119,'fb2fe4c3f84642bbad40631e42e594dd','gigabytes',-1,'2025-11-24 10:05:43',NULL),('2025-11-23 10:05:43','2025-11-23 10:05:43','2025-11-23 10:05:43',1,566,'74ba0366-5005-46bc-bdc4-9771f0389e6b',122,'fb2fe4c3f84642bbad40631e42e594dd','volumes_tempest-GroupsTest-volume-type-1184049508',-1,'2025-11-24 10:05:43',NULL),('2025-11-23 10:05:43','2025-11-23 10:05:43','2025-11-23 10:05:43',1,567,'3daa0652-7087-420a-8dd8-f8a7aed0e801',123,'fb2fe4c3f84642bbad40631e42e594dd','gigabytes_tempest-GroupsTest-volume-type-1184049508',-1,'2025-11-24 10:05:43',NULL),('2025-11-23 10:05:43','2025-11-23 10:05:43','2025-11-23 10:05:43',1,568,'026c63d6-d5f9-43a4-a0db-5c9393f84b53',118,'fb2fe4c3f84642bbad40631e42e594dd','volumes',-1,'2025-11-24 10:05:43',NULL),('2025-11-23 10:05:43','2025-11-23 10:05:43','2025-11-23 10:05:43',1,569,'a92d4821-c84b-4fa1-b8f0-a4029fbf2016',119,'fb2fe4c3f84642bbad40631e42e594dd','gigabytes',-1,'2025-11-24 10:05:43',NULL),('2025-11-23 10:05:43','2025-11-23 10:05:43','2025-11-23 10:05:43',1,570,'e40c98dd-a3cf-4c46-b474-96f026817693',122,'fb2fe4c3f84642bbad40631e42e594dd','volumes_tempest-GroupsTest-volume-type-1184049508',-1,'2025-11-24 10:05:43',NULL),('2025-11-23 10:05:43','2025-11-23 10:05:43','2025-11-23 10:05:43',1,571,'01c8e20b-2db8-4933-a3e0-1c9b9942046a',123,'fb2fe4c3f84642bbad40631e42e594dd','gigabytes_tempest-GroupsTest-volume-type-1184049508',-1,'2025-11-24 10:05:43',NULL),('2025-11-23 10:05:43','2025-11-23 10:05:43','2025-11-23 10:05:43',1,572,'eaae6c72-4cdb-4a84-bbad-72bf4f775a5b',111,'e26ac473e8284e80b775ad7fd47ae6ec','volumes',-1,'2025-11-24 10:05:43',NULL),('2025-11-23 10:05:43','2025-11-23 10:05:43','2025-11-23 10:05:43',1,573,'2824ba65-124d-4b5b-9d67-789cea3ca857',112,'e26ac473e8284e80b775ad7fd47ae6ec','gigabytes',-1,'2025-11-24 10:05:43',NULL),('2025-11-23 10:05:43','2025-11-23 10:05:43','2025-11-23 10:05:43',1,574,'e9e93c26-739d-4364-bb9b-c6d3e587c81b',113,'e26ac473e8284e80b775ad7fd47ae6ec','volumes_tripleo',-1,'2025-11-24 10:05:43',NULL),('2025-11-23 10:05:43','2025-11-23 10:05:43','2025-11-23 10:05:43',1,575,'b09a2150-19bd-4adc-9859-2633f9b10636',114,'e26ac473e8284e80b775ad7fd47ae6ec','gigabytes_tripleo',-1,'2025-11-24 10:05:43',NULL),('2025-11-23 10:05:44','2025-11-23 10:05:44','2025-11-23 10:05:44',1,576,'7ce39479-8992-4412-9cd8-12da4858bc87',129,'b26c9bed083447548be26f4feb5dd112','volumes',1,'2025-11-24 10:05:44',NULL),('2025-11-23 10:05:44','2025-11-23 10:05:44','2025-11-23 10:05:44',1,577,'38c3080d-83d6-4a62-9c5b-c021921391ea',130,'b26c9bed083447548be26f4feb5dd112','gigabytes',1,'2025-11-24 10:05:44',NULL),('2025-11-23 10:05:44','2025-11-23 10:05:44','2025-11-23 10:05:44',1,578,'8454f687-cf72-4a6e-b382-2912d676f7dd',131,'b26c9bed083447548be26f4feb5dd112','volumes_tempest-GroupsV314Test-volume-type-1357687760',1,'2025-11-24 10:05:44',NULL),('2025-11-23 10:05:44','2025-11-23 10:05:44','2025-11-23 10:05:44',1,579,'e06c2acf-e438-4666-b7fa-5354b84931b4',132,'b26c9bed083447548be26f4feb5dd112','gigabytes_tempest-GroupsV314Test-volume-type-1357687760',1,'2025-11-24 10:05:44',NULL),('2025-11-23 10:05:45','2025-11-23 10:05:45','2025-11-23 10:05:45',1,580,'73e34fee-6399-489f-9187-e2c008eebf50',128,'b26c9bed083447548be26f4feb5dd112','groups',1,'2025-11-24 10:05:45',NULL),('2025-11-23 10:05:45','2025-11-23 10:05:45','2025-11-23 10:05:45',1,581,'0daf5647-e72f-4294-990e-d4cbbc6d02cd',129,'b26c9bed083447548be26f4feb5dd112','volumes',1,'2025-11-24 10:05:45',NULL),('2025-11-23 10:05:45','2025-11-23 10:05:45','2025-11-23 10:05:45',1,582,'44594b68-d2b1-4f54-9904-a73589f460bc',130,'b26c9bed083447548be26f4feb5dd112','gigabytes',1,'2025-11-24 10:05:45',NULL),('2025-11-23 10:05:45','2025-11-23 10:05:45','2025-11-23 10:05:45',1,583,'1d1c35a6-3d87-418d-91a0-3d9152b2fbda',131,'b26c9bed083447548be26f4feb5dd112','volumes_tempest-GroupsV314Test-volume-type-1357687760',1,'2025-11-24 10:05:45',NULL),('2025-11-23 10:05:45','2025-11-23 10:05:45','2025-11-23 10:05:45',1,584,'2d9605c0-7c66-4e11-b570-d9a0e91d5418',132,'b26c9bed083447548be26f4feb5dd112','gigabytes_tempest-GroupsV314Test-volume-type-1357687760',1,'2025-11-24 10:05:45',NULL),('2025-11-23 10:05:48','2025-11-23 10:05:48','2025-11-23 10:05:48',1,585,'e4ea7a2e-caa4-4fc5-8a73-8ebde17c26d7',128,'b26c9bed083447548be26f4feb5dd112','groups',-1,'2025-11-24 10:05:48',NULL),('2025-11-23 10:05:48','2025-11-23 10:05:48','2025-11-23 10:05:48',1,586,'39b05e08-d56c-48fc-8625-52fbb5dd8b16',129,'b26c9bed083447548be26f4feb5dd112','volumes',-1,'2025-11-24 10:05:48',NULL),('2025-11-23 10:05:48','2025-11-23 10:05:48','2025-11-23 10:05:48',1,587,'f9412dc7-5a8e-454e-aee4-2b2f7774e4ef',130,'b26c9bed083447548be26f4feb5dd112','gigabytes',-1,'2025-11-24 10:05:48',NULL),('2025-11-23 10:05:48','2025-11-23 10:05:48','2025-11-23 10:05:48',1,588,'12f52220-f800-454a-a091-2218a811ca19',131,'b26c9bed083447548be26f4feb5dd112','volumes_tempest-GroupsV314Test-volume-type-1357687760',-1,'2025-11-24 10:05:48',NULL),('2025-11-23 10:05:48','2025-11-23 10:05:48','2025-11-23 10:05:48',1,589,'1d6ef6a4-5df7-4a08-b683-a177e785ced3',132,'b26c9bed083447548be26f4feb5dd112','gigabytes_tempest-GroupsV314Test-volume-type-1357687760',-1,'2025-11-24 10:05:48',NULL),('2025-11-23 10:05:49','2025-11-23 10:05:49','2025-11-23 10:05:49',1,590,'e4aac199-2a31-4d9e-a68d-99a6a4224103',128,'b26c9bed083447548be26f4feb5dd112','groups',-1,'2025-11-24 10:05:49',NULL),('2025-11-23 10:05:49','2025-11-23 10:05:49','2025-11-23 10:05:49',1,591,'56e5abd2-a0fb-4f44-b2c7-17c5b2589b1b',129,'b26c9bed083447548be26f4feb5dd112','volumes',-1,'2025-11-24 10:05:49',NULL),('2025-11-23 10:05:49','2025-11-23 10:05:49','2025-11-23 10:05:49',1,592,'fcbbf531-877d-4982-943e-6174c51fc9ef',130,'b26c9bed083447548be26f4feb5dd112','gigabytes',-1,'2025-11-24 10:05:49',NULL),('2025-11-23 10:05:49','2025-11-23 10:05:49','2025-11-23 10:05:49',1,593,'e8a62512-8fb2-4af1-bdc7-2498aeea104f',131,'b26c9bed083447548be26f4feb5dd112','volumes_tempest-GroupsV314Test-volume-type-1357687760',-1,'2025-11-24 10:05:49',NULL),('2025-11-23 10:05:49','2025-11-23 10:05:49','2025-11-23 10:05:49',1,594,'62fb3f94-9754-471f-8f6d-5c327ab2b26c',132,'b26c9bed083447548be26f4feb5dd112','gigabytes_tempest-GroupsV314Test-volume-type-1357687760',-1,'2025-11-24 10:05:49',NULL),('2025-11-23 10:05:49','2025-11-23 10:05:49','2025-11-23 10:05:49',1,595,'017f2650-4f4b-4dad-94a3-13226afea733',133,'31ac2e693dd64b72aedd3d1555ed3e03','volumes',1,'2025-11-24 10:05:49',NULL),('2025-11-23 10:05:49','2025-11-23 10:05:49','2025-11-23 10:05:49',1,596,'2d487c50-c278-43e4-b1ac-499dcb4ee95e',134,'31ac2e693dd64b72aedd3d1555ed3e03','gigabytes',1,'2025-11-24 10:05:49',NULL),('2025-11-23 10:05:49','2025-11-23 10:05:49','2025-11-23 10:05:49',1,597,'9c9c5959-060a-4206-a694-6ecbf4661191',135,'31ac2e693dd64b72aedd3d1555ed3e03','volumes_tempest-UserMessagesTest-volume-type-1721981474',1,'2025-11-24 10:05:49',NULL),('2025-11-23 10:05:49','2025-11-23 10:05:49','2025-11-23 10:05:49',1,598,'1a1665d2-d940-4f84-913e-77ab88eaff81',136,'31ac2e693dd64b72aedd3d1555ed3e03','gigabytes_tempest-UserMessagesTest-volume-type-1721981474',1,'2025-11-24 10:05:49',NULL),('2025-11-23 10:05:50','2025-11-23 10:05:50','2025-11-23 10:05:50',1,599,'d87a5556-7483-422b-b16e-d3b2f2b6b2b5',137,'ad260941b31148988b7356700a79268b','groups',1,'2025-11-24 10:05:50',NULL),('2025-11-23 10:05:51','2025-11-23 10:05:51','2025-11-23 10:05:51',1,600,'486a6828-267f-4425-b509-ff755d2804e1',133,'31ac2e693dd64b72aedd3d1555ed3e03','volumes',-1,'2025-11-24 10:05:51',NULL),('2025-11-23 10:05:51','2025-11-23 10:05:51','2025-11-23 10:05:51',1,601,'c3f6dff3-4ef2-4bf1-ad70-2697342579f3',134,'31ac2e693dd64b72aedd3d1555ed3e03','gigabytes',-1,'2025-11-24 10:05:51',NULL),('2025-11-23 10:05:51','2025-11-23 10:05:51','2025-11-23 10:05:51',1,602,'80ec052e-1999-498b-9f3e-d5dfd2146275',135,'31ac2e693dd64b72aedd3d1555ed3e03','volumes_tempest-UserMessagesTest-volume-type-1721981474',-1,'2025-11-24 10:05:51',NULL),('2025-11-23 10:05:51','2025-11-23 10:05:51','2025-11-23 10:05:51',1,603,'dc28caa8-9b4e-457f-9b5e-b86b04efda94',136,'31ac2e693dd64b72aedd3d1555ed3e03','gigabytes_tempest-UserMessagesTest-volume-type-1721981474',-1,'2025-11-24 10:05:51',NULL),('2025-11-23 10:05:51','2025-11-23 10:05:51','2025-11-23 10:05:51',1,604,'aaff9d83-ea16-4b53-95e7-5f61fe356c14',133,'31ac2e693dd64b72aedd3d1555ed3e03','volumes',1,'2025-11-24 10:05:51',NULL),('2025-11-23 10:05:51','2025-11-23 10:05:51','2025-11-23 10:05:51',1,605,'9789814a-1710-4a67-b398-b6d5d6b160e6',134,'31ac2e693dd64b72aedd3d1555ed3e03','gigabytes',1,'2025-11-24 10:05:51',NULL),('2025-11-23 10:05:51','2025-11-23 10:05:51','2025-11-23 10:05:51',1,606,'9ce538fd-e274-4b9e-8948-88d15138a0eb',138,'31ac2e693dd64b72aedd3d1555ed3e03','volumes_tempest-UserMessagesTest-volume-type-2124842120',1,'2025-11-24 10:05:51',NULL),('2025-11-23 10:05:51','2025-11-23 10:05:51','2025-11-23 10:05:51',1,607,'0ed51cc9-b418-4fe0-81e7-e01b49414a9c',139,'31ac2e693dd64b72aedd3d1555ed3e03','gigabytes_tempest-UserMessagesTest-volume-type-2124842120',1,'2025-11-24 10:05:51',NULL),('2025-11-23 10:05:51','2025-11-23 10:05:51','2025-11-23 10:05:51',1,608,'40fd0dbc-6519-4944-b4fb-732e69bded02',137,'ad260941b31148988b7356700a79268b','groups',-1,'2025-11-24 10:05:51',NULL),('2025-11-23 10:05:53','2025-11-23 10:05:53','2025-11-23 10:05:53',1,609,'c380668e-1c75-4e11-851a-862747051190',133,'31ac2e693dd64b72aedd3d1555ed3e03','volumes',-1,'2025-11-24 10:05:52',NULL),('2025-11-23 10:05:53','2025-11-23 10:05:53','2025-11-23 10:05:53',1,610,'2f23bb83-b9fb-479d-8346-ea0f96dbd9a4',134,'31ac2e693dd64b72aedd3d1555ed3e03','gigabytes',-1,'2025-11-24 10:05:52',NULL),('2025-11-23 10:05:53','2025-11-23 10:05:53','2025-11-23 10:05:53',1,611,'3ad1abd6-7ea6-4726-92e1-51b775138015',138,'31ac2e693dd64b72aedd3d1555ed3e03','volumes_tempest-UserMessagesTest-volume-type-2124842120',-1,'2025-11-24 10:05:52',NULL),('2025-11-23 10:05:53','2025-11-23 10:05:53','2025-11-23 10:05:53',1,612,'e55b6e4e-7bd3-4d91-9607-62a6233fed39',139,'31ac2e693dd64b72aedd3d1555ed3e03','gigabytes_tempest-UserMessagesTest-volume-type-2124842120',-1,'2025-11-24 10:05:52',NULL),('2025-11-23 10:05:55','2025-11-23 10:05:55','2025-11-23 10:05:55',1,613,'35447323-977b-4f1e-a043-c0f2db7bdda3',140,'14ef278019ca433e853baef5651087a9','volumes',1,'2025-11-24 10:05:55',NULL),('2025-11-23 10:05:55','2025-11-23 10:05:55','2025-11-23 10:05:55',1,614,'9123e59b-e56d-40d7-b26f-2d0f705c2f6b',141,'14ef278019ca433e853baef5651087a9','gigabytes',1,'2025-11-24 10:05:55',NULL),('2025-11-23 10:05:55','2025-11-23 10:05:55','2025-11-23 10:05:55',1,615,'6e8d61e2-31c3-456f-b24e-6b7e105051f4',142,'14ef278019ca433e853baef5651087a9','volumes_tripleo',1,'2025-11-24 10:05:55',NULL),('2025-11-23 10:05:55','2025-11-23 10:05:55','2025-11-23 10:05:55',1,616,'93092e9a-95d7-48b3-8e17-5b69e770d7b4',143,'14ef278019ca433e853baef5651087a9','gigabytes_tripleo',1,'2025-11-24 10:05:55',NULL),('2025-11-23 10:05:57','2025-11-23 10:05:57','2025-11-23 10:05:57',1,617,'e65f6251-4dfe-4bbd-b087-dbd64e16f04b',140,'14ef278019ca433e853baef5651087a9','volumes',-1,'2025-11-24 10:05:57',NULL),('2025-11-23 10:05:57','2025-11-23 10:05:57','2025-11-23 10:05:57',1,618,'f8de1f78-4db8-4829-800e-8aeda0f4a56e',141,'14ef278019ca433e853baef5651087a9','gigabytes',-1,'2025-11-24 10:05:57',NULL),('2025-11-23 10:05:57','2025-11-23 10:05:57','2025-11-23 10:05:57',1,619,'dcedb308-7e9e-4880-b3bd-61d3b95d7588',142,'14ef278019ca433e853baef5651087a9','volumes_tripleo',-1,'2025-11-24 10:05:57',NULL),('2025-11-23 10:05:57','2025-11-23 10:05:57','2025-11-23 10:05:57',1,620,'32ae5d06-e260-4c98-a2a7-e3fef034ca6c',143,'14ef278019ca433e853baef5651087a9','gigabytes_tripleo',-1,'2025-11-24 10:05:57',NULL),('2025-11-23 10:06:00','2025-11-23 10:06:00','2025-11-23 10:06:00',1,621,'b1ad3150-5390-46b8-bb83-678270ae49d0',144,'4e886bd382154b9ba842be63cef3b094','volumes',1,'2025-11-24 10:06:00',NULL),('2025-11-23 10:06:00','2025-11-23 10:06:00','2025-11-23 10:06:00',1,622,'031d42ab-2544-446d-af61-233d2a3689e5',145,'4e886bd382154b9ba842be63cef3b094','gigabytes',1,'2025-11-24 10:06:00',NULL),('2025-11-23 10:06:00','2025-11-23 10:06:00','2025-11-23 10:06:00',1,623,'73e4d2cb-b74b-45a4-be6e-46fe8d76c80c',146,'4e886bd382154b9ba842be63cef3b094','volumes_tripleo',1,'2025-11-24 10:06:00',NULL),('2025-11-23 10:06:00','2025-11-23 10:06:00','2025-11-23 10:06:00',1,624,'a5d22570-3614-461f-96e7-b2d57b94f7f9',147,'4e886bd382154b9ba842be63cef3b094','gigabytes_tripleo',1,'2025-11-24 10:06:00',NULL),('2025-11-23 10:06:02','2025-11-23 10:06:02','2025-11-23 10:06:02',1,625,'fe78658d-92bd-4b7a-9c7b-d87ac1f810ee',144,'4e886bd382154b9ba842be63cef3b094','volumes',-1,'2025-11-24 10:06:02',NULL),('2025-11-23 10:06:02','2025-11-23 10:06:02','2025-11-23 10:06:02',1,626,'1fd67517-7468-4bdc-b39f-e56bad8e2f6a',145,'4e886bd382154b9ba842be63cef3b094','gigabytes',-1,'2025-11-24 10:06:02',NULL),('2025-11-23 10:06:02','2025-11-23 10:06:02','2025-11-23 10:06:02',1,627,'568d4d1d-9e25-4742-af23-bd5a0d1f25d6',146,'4e886bd382154b9ba842be63cef3b094','volumes_tripleo',-1,'2025-11-24 10:06:02',NULL),('2025-11-23 10:06:02','2025-11-23 10:06:02','2025-11-23 10:06:02',1,628,'2ce58df7-aa8c-40c1-a8b9-70f58a09d471',147,'4e886bd382154b9ba842be63cef3b094','gigabytes_tripleo',-1,'2025-11-24 10:06:02',NULL),('2025-11-23 10:06:03','2025-11-23 10:06:03','2025-11-23 10:06:03',1,629,'1369378e-32a3-4a31-9832-b438d0ef099a',144,'4e886bd382154b9ba842be63cef3b094','volumes',1,'2025-11-24 10:06:03',NULL),('2025-11-23 10:06:03','2025-11-23 10:06:03','2025-11-23 10:06:03',1,630,'554b6d0c-e49d-4c45-bde8-3fa96e495ba3',145,'4e886bd382154b9ba842be63cef3b094','gigabytes',1,'2025-11-24 10:06:03',NULL),('2025-11-23 10:06:03','2025-11-23 10:06:03','2025-11-23 10:06:03',1,631,'ac8c0a33-82c0-4a39-8e72-4b8e83a5a8f8',146,'4e886bd382154b9ba842be63cef3b094','volumes_tripleo',1,'2025-11-24 10:06:03',NULL),('2025-11-23 10:06:03','2025-11-23 10:06:03','2025-11-23 10:06:03',1,632,'1b34a7ec-873b-4e0b-90c2-5c47831d9e52',147,'4e886bd382154b9ba842be63cef3b094','gigabytes_tripleo',1,'2025-11-24 10:06:03',NULL),('2025-11-23 10:06:05','2025-11-23 10:06:05','2025-11-23 10:06:05',1,633,'e1b9e61c-3475-4cbd-8fc8-580c7f3295b3',148,'250d505f169f42eaa1d45ef735f6b254','volumes',1,'2025-11-24 10:06:04',NULL),('2025-11-23 10:06:05','2025-11-23 10:06:05','2025-11-23 10:06:05',1,634,'56ca771a-8b92-45cc-bc0a-8d4248c2dd3d',149,'250d505f169f42eaa1d45ef735f6b254','gigabytes',1,'2025-11-24 10:06:04',NULL),('2025-11-23 10:06:05','2025-11-23 10:06:05','2025-11-23 10:06:05',1,635,'d17e0e99-1f70-4327-ae20-4022d661c65c',150,'250d505f169f42eaa1d45ef735f6b254','volumes_tripleo',1,'2025-11-24 10:06:04',NULL),('2025-11-23 10:06:05','2025-11-23 10:06:05','2025-11-23 10:06:05',1,636,'372494be-334b-454f-b090-18021f75b1dd',151,'250d505f169f42eaa1d45ef735f6b254','gigabytes_tripleo',1,'2025-11-24 10:06:04',NULL),('2025-11-23 10:06:05','2025-11-23 10:06:05','2025-11-23 10:06:05',1,637,'9107416f-bdde-494c-9c50-4a9577298136',144,'4e886bd382154b9ba842be63cef3b094','volumes',-1,'2025-11-24 10:06:05',NULL),('2025-11-23 10:06:05','2025-11-23 10:06:05','2025-11-23 10:06:05',1,638,'263e0b58-22e2-4d76-b62e-6b18c59ac54d',145,'4e886bd382154b9ba842be63cef3b094','gigabytes',-1,'2025-11-24 10:06:05',NULL),('2025-11-23 10:06:05','2025-11-23 10:06:05','2025-11-23 10:06:05',1,639,'3adeb7fa-ecf3-421f-a6d1-77e31b3779ad',146,'4e886bd382154b9ba842be63cef3b094','volumes_tripleo',-1,'2025-11-24 10:06:05',NULL),('2025-11-23 10:06:05','2025-11-23 10:06:05','2025-11-23 10:06:05',1,640,'6941613c-3a13-470d-a32b-0141cb15859a',147,'4e886bd382154b9ba842be63cef3b094','gigabytes_tripleo',-1,'2025-11-24 10:06:05',NULL),('2025-11-23 10:06:05','2025-11-23 10:06:05','2025-11-23 10:06:05',1,641,'b750e193-1568-4e51-ba2a-18c400935573',152,'250d505f169f42eaa1d45ef735f6b254','snapshots',0,'2025-11-24 10:06:05',NULL),('2025-11-23 10:06:05','2025-11-23 10:06:05','2025-11-23 10:06:05',1,642,'5e2206a4-97db-4b75-b825-9953f80b3a18',149,'250d505f169f42eaa1d45ef735f6b254','gigabytes',0,'2025-11-24 10:06:05',NULL),('2025-11-23 10:06:05','2025-11-23 10:06:05','2025-11-23 10:06:05',1,643,'d68153c5-2cc7-4452-bed3-7063e993cb12',151,'250d505f169f42eaa1d45ef735f6b254','gigabytes_tripleo',0,'2025-11-24 10:06:05',NULL),('2025-11-23 10:06:05','2025-11-23 10:06:05','2025-11-23 10:06:05',1,644,'c64ed3e6-d8ba-4e16-8c08-fa9e32740f90',153,'250d505f169f42eaa1d45ef735f6b254','snapshots_tripleo',0,'2025-11-24 10:06:05',NULL),('2025-11-23 10:06:05','2025-11-23 10:06:05','2025-11-23 10:06:05',1,645,'ba085c04-8b8e-4b8e-ab7b-447194c67a71',154,'4e886bd382154b9ba842be63cef3b094','snapshots',0,'2025-11-24 10:06:05',NULL),('2025-11-23 10:06:05','2025-11-23 10:06:05','2025-11-23 10:06:05',1,646,'4a37dc71-bdca-435d-aa0e-10a562b210ac',145,'4e886bd382154b9ba842be63cef3b094','gigabytes',0,'2025-11-24 10:06:05',NULL),('2025-11-23 10:06:05','2025-11-23 10:06:05','2025-11-23 10:06:05',1,647,'06161876-e6c4-416d-ab6b-b2b5677c640b',147,'4e886bd382154b9ba842be63cef3b094','gigabytes_tripleo',0,'2025-11-24 10:06:05',NULL),('2025-11-23 10:06:05','2025-11-23 10:06:05','2025-11-23 10:06:05',1,648,'103d1f20-372e-4ae0-9317-359b0503871a',155,'4e886bd382154b9ba842be63cef3b094','snapshots_tripleo',0,'2025-11-24 10:06:05',NULL),('2025-11-23 10:06:05','2025-11-23 10:06:05','2025-11-23 10:06:05',1,649,'b148c95f-f446-4ed5-b317-04e5639c4c75',156,'10f6dfd6b1684628bd2dfc266a69e68a','volumes',1,'2025-11-24 10:06:05',NULL),('2025-11-23 10:06:05','2025-11-23 10:06:05','2025-11-23 10:06:05',1,650,'4f390ac6-eeb3-462f-b8a4-d7895316d687',157,'10f6dfd6b1684628bd2dfc266a69e68a','gigabytes',1,'2025-11-24 10:06:05',NULL),('2025-11-23 10:06:05','2025-11-23 10:06:05','2025-11-23 10:06:05',1,651,'a72206ad-08d1-4235-8dbd-f851a68be53b',158,'10f6dfd6b1684628bd2dfc266a69e68a','volumes_tripleo',1,'2025-11-24 10:06:05',NULL),('2025-11-23 10:06:05','2025-11-23 10:06:05','2025-11-23 10:06:05',1,652,'c240f44e-0354-49e2-8d75-b164e2613f91',159,'10f6dfd6b1684628bd2dfc266a69e68a','gigabytes_tripleo',1,'2025-11-24 10:06:05',NULL),('2025-11-23 10:06:06','2025-11-23 10:06:06','2025-11-23 10:06:06',1,653,'4aa2b14c-68a1-4761-9944-35231830c221',148,'250d505f169f42eaa1d45ef735f6b254','volumes',-1,'2025-11-24 10:06:06',NULL),('2025-11-23 10:06:06','2025-11-23 10:06:06','2025-11-23 10:06:06',1,654,'4188ee72-d289-4b4f-abe8-960cd3d3949b',149,'250d505f169f42eaa1d45ef735f6b254','gigabytes',-1,'2025-11-24 10:06:06',NULL),('2025-11-23 10:06:06','2025-11-23 10:06:06','2025-11-23 10:06:06',1,655,'b86a0814-7046-4fda-b55b-d81fc90e44e7',150,'250d505f169f42eaa1d45ef735f6b254','volumes_tripleo',-1,'2025-11-24 10:06:06',NULL),('2025-11-23 10:06:06','2025-11-23 10:06:06','2025-11-23 10:06:06',1,656,'be442d9e-e91c-45e7-acb9-bdc00c1b04c7',151,'250d505f169f42eaa1d45ef735f6b254','gigabytes_tripleo',-1,'2025-11-24 10:06:06',NULL),('2025-11-23 10:06:06','2025-11-23 10:06:06','2025-11-23 10:06:06',1,657,'02e5b659-3b0f-47ad-97c1-2088d15b131a',160,'eefb55b5a7ba44a99cf8b53d39954004','volumes',1,'2025-11-24 10:06:06',NULL),('2025-11-23 10:06:06','2025-11-23 10:06:06','2025-11-23 10:06:06',1,658,'1d4d1042-01ca-41a5-9610-21d37b9f2353',161,'eefb55b5a7ba44a99cf8b53d39954004','gigabytes',1,'2025-11-24 10:06:06',NULL),('2025-11-23 10:06:06','2025-11-23 10:06:06','2025-11-23 10:06:06',1,659,'fa7b7ead-09b1-41a9-9d52-a31a51f1ce52',162,'eefb55b5a7ba44a99cf8b53d39954004','volumes_tempest-VolumeTypesAccessTest-volume-type-749306444',1,'2025-11-24 10:06:06',NULL),('2025-11-23 10:06:06','2025-11-23 10:06:06','2025-11-23 10:06:06',1,660,'ed17c228-f85d-4bb5-8a6d-bed8ac4d67b9',163,'eefb55b5a7ba44a99cf8b53d39954004','gigabytes_tempest-VolumeTypesAccessTest-volume-type-749306444',1,'2025-11-24 10:06:06',NULL),('2025-11-23 10:06:08','2025-11-23 10:06:08','2025-11-23 10:06:08',1,661,'1c9b073a-a1f6-4c6d-974a-05cece02bdb6',156,'10f6dfd6b1684628bd2dfc266a69e68a','volumes',-1,'2025-11-24 10:06:08',NULL),('2025-11-23 10:06:08','2025-11-23 10:06:08','2025-11-23 10:06:08',1,662,'f0cecb77-f702-461f-82ba-2f7bb01c52e6',157,'10f6dfd6b1684628bd2dfc266a69e68a','gigabytes',-1,'2025-11-24 10:06:08',NULL),('2025-11-23 10:06:08','2025-11-23 10:06:08','2025-11-23 10:06:08',1,663,'018b457b-44d8-4db6-a94c-d5284fd23a7e',158,'10f6dfd6b1684628bd2dfc266a69e68a','volumes_tripleo',-1,'2025-11-24 10:06:08',NULL),('2025-11-23 10:06:08','2025-11-23 10:06:08','2025-11-23 10:06:08',1,664,'58f004ad-bf9a-4571-9f0e-9badc4e4dec0',159,'10f6dfd6b1684628bd2dfc266a69e68a','gigabytes_tripleo',-1,'2025-11-24 10:06:08',NULL),('2025-11-23 10:06:08','2025-11-23 10:06:08','2025-11-23 10:06:08',1,665,'29a9cd4b-c9f1-4d1b-b7c5-8834a7c25ece',160,'eefb55b5a7ba44a99cf8b53d39954004','volumes',-1,'2025-11-24 10:06:08',NULL),('2025-11-23 10:06:08','2025-11-23 10:06:08','2025-11-23 10:06:08',1,666,'a2237159-4725-4834-9587-fa6c95da7d90',161,'eefb55b5a7ba44a99cf8b53d39954004','gigabytes',-1,'2025-11-24 10:06:08',NULL),('2025-11-23 10:06:08','2025-11-23 10:06:08','2025-11-23 10:06:08',1,667,'1d369aba-5bca-4b65-9a66-6ae6ede2910f',162,'eefb55b5a7ba44a99cf8b53d39954004','volumes_tempest-VolumeTypesAccessTest-volume-type-749306444',-1,'2025-11-24 10:06:08',NULL),('2025-11-23 10:06:08','2025-11-23 10:06:08','2025-11-23 10:06:08',1,668,'4dc1256c-f65e-4864-bef8-1c89510819bf',163,'eefb55b5a7ba44a99cf8b53d39954004','gigabytes_tempest-VolumeTypesAccessTest-volume-type-749306444',-1,'2025-11-24 10:06:08',NULL),('2025-11-23 10:06:14','2025-11-23 10:06:14','2025-11-23 10:06:14',1,669,'81cee7e3-7da1-4dd8-8c26-52ce526c8f05',164,'e404e742ed2d4e9d83bf3d49a6278dc7','volumes',1,'2025-11-24 10:06:14',NULL),('2025-11-23 10:06:14','2025-11-23 10:06:14','2025-11-23 10:06:14',1,670,'3865ccc8-a37b-493b-8e75-9e96a7efc275',165,'e404e742ed2d4e9d83bf3d49a6278dc7','gigabytes',1,'2025-11-24 10:06:14',NULL),('2025-11-23 10:06:14','2025-11-23 10:06:14','2025-11-23 10:06:14',1,671,'e2b4831c-5668-4112-aa54-c30330939872',166,'e404e742ed2d4e9d83bf3d49a6278dc7','volumes_tripleo',1,'2025-11-24 10:06:14',NULL),('2025-11-23 10:06:14','2025-11-23 10:06:14','2025-11-23 10:06:14',1,672,'a6c16943-269d-49d3-8c1a-5bed45bfc7c1',167,'e404e742ed2d4e9d83bf3d49a6278dc7','gigabytes_tripleo',1,'2025-11-24 10:06:14',NULL),('2025-11-23 10:06:16','2025-11-23 10:06:16','2025-11-23 10:06:16',1,673,'c0eac06a-6550-444b-91b9-cfe14a3dd404',168,'34d74c1246bf4aba9b9e49e89e82cacb','volumes',1,'2025-11-24 10:06:15',NULL),('2025-11-23 10:06:16','2025-11-23 10:06:16','2025-11-23 10:06:16',1,674,'5d558d59-6700-4559-900d-ac9ca5be672d',169,'34d74c1246bf4aba9b9e49e89e82cacb','gigabytes',1,'2025-11-24 10:06:15',NULL),('2025-11-23 10:06:16','2025-11-23 10:06:16','2025-11-23 10:06:16',1,675,'291c1342-e615-4aa0-97b5-1bcfaefad6fe',170,'34d74c1246bf4aba9b9e49e89e82cacb','volumes_tripleo',1,'2025-11-24 10:06:15',NULL),('2025-11-23 10:06:16','2025-11-23 10:06:16','2025-11-23 10:06:16',1,676,'7fe8fe4f-56b4-4cd1-898f-060b1b1914ff',171,'34d74c1246bf4aba9b9e49e89e82cacb','gigabytes_tripleo',1,'2025-11-24 10:06:15',NULL),('2025-11-23 10:06:16','2025-11-23 10:06:16','2025-11-23 10:06:16',1,677,'4809ce8a-5001-4668-b0fb-b685e8ba2a18',172,'141ccb7a18aa4552b64b95f2b6f47c17','volumes',1,'2025-11-24 10:06:16',NULL),('2025-11-23 10:06:16','2025-11-23 10:06:16','2025-11-23 10:06:16',1,678,'c5b89d8a-7e4e-4179-877c-2e20e6e4da6b',173,'141ccb7a18aa4552b64b95f2b6f47c17','gigabytes',1,'2025-11-24 10:06:16',NULL),('2025-11-23 10:06:16','2025-11-23 10:06:16','2025-11-23 10:06:16',1,679,'a314ecaa-745f-42b7-9b7f-237a34773ad0',174,'141ccb7a18aa4552b64b95f2b6f47c17','volumes_tripleo',1,'2025-11-24 10:06:16',NULL),('2025-11-23 10:06:16','2025-11-23 10:06:16','2025-11-23 10:06:16',1,680,'5ee2c225-39db-4015-a864-a7c472c687c9',175,'141ccb7a18aa4552b64b95f2b6f47c17','gigabytes_tripleo',1,'2025-11-24 10:06:16',NULL),('2025-11-23 10:06:16','2025-11-23 10:06:16','2025-11-23 10:06:16',1,681,'41a6d83b-4a86-4fc4-9b8c-ccb704fec8ba',164,'e404e742ed2d4e9d83bf3d49a6278dc7','volumes',-1,'2025-11-24 10:06:16',NULL),('2025-11-23 10:06:16','2025-11-23 10:06:16','2025-11-23 10:06:16',1,682,'350ae87b-2cee-4a35-a8b9-c592dff3aa18',165,'e404e742ed2d4e9d83bf3d49a6278dc7','gigabytes',-1,'2025-11-24 10:06:16',NULL),('2025-11-23 10:06:16','2025-11-23 10:06:16','2025-11-23 10:06:16',1,683,'4cb73bb6-9d04-4a71-98ce-2e0ccd7f56ee',166,'e404e742ed2d4e9d83bf3d49a6278dc7','volumes_tripleo',-1,'2025-11-24 10:06:16',NULL),('2025-11-23 10:06:16','2025-11-23 10:06:16','2025-11-23 10:06:16',1,684,'85e125df-e2b4-4205-afba-91aaf8d2b003',167,'e404e742ed2d4e9d83bf3d49a6278dc7','gigabytes_tripleo',-1,'2025-11-24 10:06:16',NULL),('2025-11-23 10:06:17','2025-11-23 10:06:17','2025-11-23 10:06:17',1,685,'6fb2eb43-a3bf-4827-a9fe-38b2f84346db',176,'8cc99762c1da46248e6ae87d4c3b549f','volumes',1,'2025-11-24 10:06:17',NULL),('2025-11-23 10:06:17','2025-11-23 10:06:17','2025-11-23 10:06:17',1,686,'c1b0d9f8-27c6-4a07-8af0-8d73c9104283',177,'8cc99762c1da46248e6ae87d4c3b549f','gigabytes',1,'2025-11-24 10:06:17',NULL),('2025-11-23 10:06:17','2025-11-23 10:06:17','2025-11-23 10:06:17',1,687,'067afc4e-8525-4e71-b9e1-e34c87028656',178,'8cc99762c1da46248e6ae87d4c3b549f','volumes_tripleo',1,'2025-11-24 10:06:17',NULL),('2025-11-23 10:06:17','2025-11-23 10:06:17','2025-11-23 10:06:17',1,688,'75bb1b4b-f95b-4024-aa65-df58ef2bfa22',179,'8cc99762c1da46248e6ae87d4c3b549f','gigabytes_tripleo',1,'2025-11-24 10:06:17',NULL),('2025-11-23 10:06:17','2025-11-23 10:06:17','2025-11-23 10:06:17',1,689,'8927b977-7801-45a6-b620-40ea8b46b102',168,'34d74c1246bf4aba9b9e49e89e82cacb','volumes',-1,'2025-11-24 10:06:17',NULL),('2025-11-23 10:06:17','2025-11-23 10:06:17','2025-11-23 10:06:17',1,690,'5a9b2147-8a8a-43ab-83aa-735bc2c5d87d',169,'34d74c1246bf4aba9b9e49e89e82cacb','gigabytes',-1,'2025-11-24 10:06:17',NULL),('2025-11-23 10:06:17','2025-11-23 10:06:17','2025-11-23 10:06:17',1,691,'e4e75df5-b0f2-4d59-a6f0-91d04b4736f4',170,'34d74c1246bf4aba9b9e49e89e82cacb','volumes_tripleo',-1,'2025-11-24 10:06:17',NULL),('2025-11-23 10:06:17','2025-11-23 10:06:17','2025-11-23 10:06:17',1,692,'8aae5bb5-0fdd-4180-96f5-60cc1b3281b7',171,'34d74c1246bf4aba9b9e49e89e82cacb','gigabytes_tripleo',-1,'2025-11-24 10:06:17',NULL),('2025-11-23 10:06:17','2025-11-23 10:06:17','2025-11-23 10:06:17',1,693,'abd37b43-04c8-47cc-985d-ed37675916e9',180,'8cc99762c1da46248e6ae87d4c3b549f','snapshots',0,'2025-11-24 10:06:17',NULL),('2025-11-23 10:06:17','2025-11-23 10:06:17','2025-11-23 10:06:17',1,694,'220c25a0-8535-48dc-a978-602a4ef5480e',177,'8cc99762c1da46248e6ae87d4c3b549f','gigabytes',0,'2025-11-24 10:06:17',NULL),('2025-11-23 10:06:17','2025-11-23 10:06:17','2025-11-23 10:06:17',1,695,'b52e3e6d-ff7f-442b-bb2d-b01c32ca4bd0',179,'8cc99762c1da46248e6ae87d4c3b549f','gigabytes_tripleo',0,'2025-11-24 10:06:17',NULL),('2025-11-23 10:06:17','2025-11-23 10:06:17','2025-11-23 10:06:17',1,696,'bc8d7bc0-2703-4b58-88ef-85d2c870cacc',181,'8cc99762c1da46248e6ae87d4c3b549f','snapshots_tripleo',0,'2025-11-24 10:06:17',NULL),('2025-11-23 10:06:17','2025-11-23 10:06:17','2025-11-23 10:06:17',1,697,'a2559bc9-98be-45b0-906e-317ff4e29f8d',182,'34d74c1246bf4aba9b9e49e89e82cacb','snapshots',0,'2025-11-24 10:06:17',NULL),('2025-11-23 10:06:17','2025-11-23 10:06:17','2025-11-23 10:06:17',1,698,'09ee990e-f5fc-49eb-a86a-80dd2f4bf59b',169,'34d74c1246bf4aba9b9e49e89e82cacb','gigabytes',0,'2025-11-24 10:06:17',NULL),('2025-11-23 10:06:17','2025-11-23 10:06:17','2025-11-23 10:06:17',1,699,'3696be5a-55e8-4f5b-a86f-e4d297e082e5',171,'34d74c1246bf4aba9b9e49e89e82cacb','gigabytes_tripleo',0,'2025-11-24 10:06:17',NULL),('2025-11-23 10:06:17','2025-11-23 10:06:17','2025-11-23 10:06:17',1,700,'e320bd99-437c-4b1c-81a7-edc31d2ffee6',183,'34d74c1246bf4aba9b9e49e89e82cacb','snapshots_tripleo',0,'2025-11-24 10:06:17',NULL),('2025-11-23 10:06:17','2025-11-23 10:06:17','2025-11-23 10:06:17',1,701,'f9f6b465-7dc4-447f-b2d8-04cfa0587fd3',184,'141ccb7a18aa4552b64b95f2b6f47c17','backups',1,'2025-11-24 10:06:17',NULL),('2025-11-23 10:06:17','2025-11-23 10:06:17','2025-11-23 10:06:17',1,702,'bbaa9636-2e78-48cf-b42d-a82b4ff98fda',185,'141ccb7a18aa4552b64b95f2b6f47c17','backup_gigabytes',1,'2025-11-24 10:06:17',NULL),('2025-11-23 10:06:18','2025-11-23 10:06:18','2025-11-23 10:06:18',1,703,'55a205d0-ccec-417e-be6e-971f5d369421',176,'8cc99762c1da46248e6ae87d4c3b549f','volumes',-1,'2025-11-24 10:06:18',NULL),('2025-11-23 10:06:18','2025-11-23 10:06:18','2025-11-23 10:06:18',1,704,'51d3f139-631f-4361-bc40-37dabe81f316',177,'8cc99762c1da46248e6ae87d4c3b549f','gigabytes',-1,'2025-11-24 10:06:18',NULL),('2025-11-23 10:06:18','2025-11-23 10:06:18','2025-11-23 10:06:18',1,705,'28d917af-3f37-42ab-958c-4531172a7a4e',178,'8cc99762c1da46248e6ae87d4c3b549f','volumes_tripleo',-1,'2025-11-24 10:06:18',NULL),('2025-11-23 10:06:18','2025-11-23 10:06:18','2025-11-23 10:06:18',1,706,'7e532719-ade5-4b22-b557-ad78dfbccb64',179,'8cc99762c1da46248e6ae87d4c3b549f','gigabytes_tripleo',-1,'2025-11-24 10:06:18',NULL),('2025-11-23 10:06:19','2025-11-23 10:06:19','2025-11-23 10:06:19',1,707,'47e32a09-6b50-481e-a582-faf925b2b431',168,'34d74c1246bf4aba9b9e49e89e82cacb','volumes',1,'2025-11-24 10:06:19',NULL),('2025-11-23 10:06:19','2025-11-23 10:06:19','2025-11-23 10:06:19',1,708,'de6a245d-6199-4960-a8ff-4cf7a3bd2226',169,'34d74c1246bf4aba9b9e49e89e82cacb','gigabytes',1,'2025-11-24 10:06:19',NULL),('2025-11-23 10:06:19','2025-11-23 10:06:19','2025-11-23 10:06:19',1,709,'742db047-ddc1-46c4-a57a-c50c819c9121',170,'34d74c1246bf4aba9b9e49e89e82cacb','volumes_tripleo',1,'2025-11-24 10:06:19',NULL),('2025-11-23 10:06:19','2025-11-23 10:06:19','2025-11-23 10:06:19',1,710,'cd17fff3-d90e-47e8-9f22-13e17f94fa76',171,'34d74c1246bf4aba9b9e49e89e82cacb','gigabytes_tripleo',1,'2025-11-24 10:06:19',NULL),('2025-11-23 10:06:21','2025-11-23 10:06:21','2025-11-23 10:06:21',1,711,'2336ab6c-15af-4252-a19a-a3c71d0ebbe0',186,'1be7eab758d64df6bb38d4ddeefb99dd','volumes',1,'2025-11-24 10:06:21',NULL),('2025-11-23 10:06:21','2025-11-23 10:06:21','2025-11-23 10:06:21',1,712,'7dd2c80d-6abf-4270-9a34-95db1d129352',187,'1be7eab758d64df6bb38d4ddeefb99dd','gigabytes',1,'2025-11-24 10:06:21',NULL),('2025-11-23 10:06:21','2025-11-23 10:06:21','2025-11-23 10:06:21',1,713,'31894e54-238e-4d14-a1b5-d954bee1ad61',188,'1be7eab758d64df6bb38d4ddeefb99dd','volumes_tripleo',1,'2025-11-24 10:06:21',NULL),('2025-11-23 10:06:21','2025-11-23 10:06:21','2025-11-23 10:06:21',1,714,'134361b5-40ad-41a3-bb9a-206edf3c6126',189,'1be7eab758d64df6bb38d4ddeefb99dd','gigabytes_tripleo',1,'2025-11-24 10:06:21',NULL),('2025-11-23 10:06:21','2025-11-23 10:06:21','2025-11-23 10:06:21',1,715,'bb256610-2bd4-4a4e-b700-33253225eff9',190,'bd1b52601ecc405a9de9756861ac3a17','backups',1,'2025-11-24 10:06:21',NULL),('2025-11-23 10:06:21','2025-11-23 10:06:21','2025-11-23 10:06:21',1,716,'5dfb0548-1ec6-4ba3-8b7d-41352f85d172',191,'bd1b52601ecc405a9de9756861ac3a17','backup_gigabytes',1,'2025-11-24 10:06:21',NULL),('2025-11-23 10:06:21','2025-11-23 10:06:21','2025-11-23 10:06:21',1,717,'96234a36-91a4-432f-932d-7d3efba7fe6e',168,'34d74c1246bf4aba9b9e49e89e82cacb','volumes',-1,'2025-11-24 10:06:21',NULL),('2025-11-23 10:06:21','2025-11-23 10:06:21','2025-11-23 10:06:21',1,718,'a2e3cee0-2705-4787-b351-70f410d5be4a',169,'34d74c1246bf4aba9b9e49e89e82cacb','gigabytes',-1,'2025-11-24 10:06:21',NULL),('2025-11-23 10:06:21','2025-11-23 10:06:21','2025-11-23 10:06:21',1,719,'e353702e-cf7d-4cc6-9b2a-c9fb64209383',170,'34d74c1246bf4aba9b9e49e89e82cacb','volumes_tripleo',-1,'2025-11-24 10:06:21',NULL),('2025-11-23 10:06:21','2025-11-23 10:06:21','2025-11-23 10:06:21',1,720,'0a6f5ce7-5be4-4d12-bad4-a59b59af8ed2',171,'34d74c1246bf4aba9b9e49e89e82cacb','gigabytes_tripleo',-1,'2025-11-24 10:06:21',NULL),('2025-11-23 10:06:22','2025-11-23 10:06:22','2025-11-23 10:06:22',1,721,'21f6b46a-2224-47a7-b7be-f9096da1a3c4',192,'1be7eab758d64df6bb38d4ddeefb99dd','snapshots',1,'2025-11-24 10:06:22',NULL),('2025-11-23 10:06:22','2025-11-23 10:06:22','2025-11-23 10:06:22',1,722,'31d9e815-6e07-4d93-9d0d-0d812029a4ee',187,'1be7eab758d64df6bb38d4ddeefb99dd','gigabytes',1,'2025-11-24 10:06:22',NULL),('2025-11-23 10:06:22','2025-11-23 10:06:22','2025-11-23 10:06:22',1,723,'423b6fa6-c949-4fb7-a866-1ce9c7d31efb',189,'1be7eab758d64df6bb38d4ddeefb99dd','gigabytes_tripleo',1,'2025-11-24 10:06:22',NULL),('2025-11-23 10:06:22','2025-11-23 10:06:22','2025-11-23 10:06:22',1,724,'853cef79-1a3e-4dac-a1c5-84d94fa5eb6a',193,'1be7eab758d64df6bb38d4ddeefb99dd','snapshots_tripleo',1,'2025-11-24 10:06:22',NULL),('2025-11-23 10:06:22','2025-11-23 10:06:22','2025-11-23 10:06:22',1,725,'d255b1a2-c853-4f9b-98b4-c9192358d622',172,'141ccb7a18aa4552b64b95f2b6f47c17','volumes',1,'2025-11-24 10:06:22',NULL),('2025-11-23 10:06:22','2025-11-23 10:06:22','2025-11-23 10:06:22',1,726,'4759a8b0-fcd5-42cc-a2d9-c7188cc23269',173,'141ccb7a18aa4552b64b95f2b6f47c17','gigabytes',1,'2025-11-24 10:06:22',NULL),('2025-11-23 10:06:22','2025-11-23 10:06:22','2025-11-23 10:06:22',1,727,'161a9c7c-a37f-4eb7-9018-b0a09d7ecedc',174,'141ccb7a18aa4552b64b95f2b6f47c17','volumes_tripleo',1,'2025-11-24 10:06:22',NULL),('2025-11-23 10:06:22','2025-11-23 10:06:22','2025-11-23 10:06:22',1,728,'e0564727-7550-41a1-aa8a-92aade4fec16',175,'141ccb7a18aa4552b64b95f2b6f47c17','gigabytes_tripleo',1,'2025-11-24 10:06:22',NULL),('2025-11-23 10:06:24','2025-11-23 10:06:24','2025-11-23 10:06:24',1,729,'519088a9-29ab-45c5-ac63-5a6d41bd0e71',192,'1be7eab758d64df6bb38d4ddeefb99dd','snapshots',1,'2025-11-24 10:06:24',NULL),('2025-11-23 10:06:24','2025-11-23 10:06:24','2025-11-23 10:06:24',1,730,'c79b1ba0-88b4-43ef-8e52-739f1ce8918e',187,'1be7eab758d64df6bb38d4ddeefb99dd','gigabytes',1,'2025-11-24 10:06:24',NULL),('2025-11-23 10:06:24','2025-11-23 10:06:24','2025-11-23 10:06:24',1,731,'43564a60-0bd5-4fb1-80f9-d60724740ebf',189,'1be7eab758d64df6bb38d4ddeefb99dd','gigabytes_tripleo',1,'2025-11-24 10:06:24',NULL),('2025-11-23 10:06:24','2025-11-23 10:06:24','2025-11-23 10:06:24',1,732,'5f3de747-56fb-4f3a-b426-fc7fb60eedf5',193,'1be7eab758d64df6bb38d4ddeefb99dd','snapshots_tripleo',1,'2025-11-24 10:06:24',NULL),('2025-11-23 10:06:27','2025-11-23 10:06:27','2025-11-23 10:06:27',1,733,'ec9cab67-8a4a-45eb-8ce5-1156c6a7db50',190,'bd1b52601ecc405a9de9756861ac3a17','backups',-1,'2025-11-24 10:06:27',NULL),('2025-11-23 10:06:27','2025-11-23 10:06:27','2025-11-23 10:06:27',1,734,'1fb424de-23b1-42fd-a60f-cd0907b5438f',191,'bd1b52601ecc405a9de9756861ac3a17','backup_gigabytes',-1,'2025-11-24 10:06:27',NULL),('2025-11-23 10:06:27','2025-11-23 10:06:27','2025-11-23 10:06:27',1,735,'f4f26228-e472-48c2-915c-7490675ceac1',192,'1be7eab758d64df6bb38d4ddeefb99dd','snapshots',-1,'2025-11-24 10:06:27',NULL),('2025-11-23 10:06:27','2025-11-23 10:06:27','2025-11-23 10:06:27',1,736,'67fb71ce-a256-4644-a0d3-1601defcf303',187,'1be7eab758d64df6bb38d4ddeefb99dd','gigabytes',-1,'2025-11-24 10:06:27',NULL),('2025-11-23 10:06:27','2025-11-23 10:06:27','2025-11-23 10:06:27',1,737,'576bcd80-84f1-41ca-9040-9f8097d34ea8',189,'1be7eab758d64df6bb38d4ddeefb99dd','gigabytes_tripleo',-1,'2025-11-24 10:06:27',NULL),('2025-11-23 10:06:27','2025-11-23 10:06:27','2025-11-23 10:06:27',1,738,'e8aa85bc-dd90-465d-bd97-e20707e0ec80',193,'1be7eab758d64df6bb38d4ddeefb99dd','snapshots_tripleo',-1,'2025-11-24 10:06:27',NULL),('2025-11-23 10:06:28','2025-11-23 10:06:28','2025-11-23 10:06:28',1,739,'2963bcd3-ff01-4b91-b6d1-a20dedc72486',172,'141ccb7a18aa4552b64b95f2b6f47c17','volumes',-1,'2025-11-24 10:06:28',NULL),('2025-11-23 10:06:28','2025-11-23 10:06:28','2025-11-23 10:06:28',1,740,'3edda1b3-7e28-4d42-9c57-6b973cbb0861',173,'141ccb7a18aa4552b64b95f2b6f47c17','gigabytes',-1,'2025-11-24 10:06:28',NULL),('2025-11-23 10:06:28','2025-11-23 10:06:28','2025-11-23 10:06:28',1,741,'262e70b5-26e6-4c70-b533-3030a282b4cc',174,'141ccb7a18aa4552b64b95f2b6f47c17','volumes_tripleo',-1,'2025-11-24 10:06:28',NULL),('2025-11-23 10:06:28','2025-11-23 10:06:28','2025-11-23 10:06:28',1,742,'6a75abc7-a50b-4d48-b256-6998c361cd89',175,'141ccb7a18aa4552b64b95f2b6f47c17','gigabytes_tripleo',-1,'2025-11-24 10:06:28',NULL),('2025-11-23 10:06:28','2025-11-23 10:06:28','2025-11-23 10:06:28',1,743,'407d3a9d-9b7a-4543-bb1e-957c0657cc55',192,'1be7eab758d64df6bb38d4ddeefb99dd','snapshots',-1,'2025-11-24 10:06:28',NULL),('2025-11-23 10:06:28','2025-11-23 10:06:28','2025-11-23 10:06:28',1,744,'3bd34b47-1c42-46b1-89f0-03650e0388d9',187,'1be7eab758d64df6bb38d4ddeefb99dd','gigabytes',-1,'2025-11-24 10:06:28',NULL),('2025-11-23 10:06:28','2025-11-23 10:06:28','2025-11-23 10:06:28',1,745,'0bbda67e-1a45-42ad-a3d7-4bb65bc20b88',189,'1be7eab758d64df6bb38d4ddeefb99dd','gigabytes_tripleo',-1,'2025-11-24 10:06:28',NULL),('2025-11-23 10:06:28','2025-11-23 10:06:28','2025-11-23 10:06:28',1,746,'b355ceba-1ac6-4a2b-892d-dc3267be4732',193,'1be7eab758d64df6bb38d4ddeefb99dd','snapshots_tripleo',-1,'2025-11-24 10:06:28',NULL),('2025-11-23 10:06:29','2025-11-23 10:06:29','2025-11-23 10:06:29',1,747,'3d7c5f07-0d68-4c11-98d1-3520e967e687',184,'141ccb7a18aa4552b64b95f2b6f47c17','backups',-1,'2025-11-24 10:06:29',NULL),('2025-11-23 10:06:29','2025-11-23 10:06:29','2025-11-23 10:06:29',1,748,'d4559a1e-b6f5-46e8-a1bc-b64cb8cd2050',185,'141ccb7a18aa4552b64b95f2b6f47c17','backup_gigabytes',-1,'2025-11-24 10:06:29',NULL),('2025-11-23 10:06:29','2025-11-23 10:06:29','2025-11-23 10:06:29',1,749,'68c542fc-5df7-40be-a8b7-6693526a4b6b',186,'1be7eab758d64df6bb38d4ddeefb99dd','volumes',-1,'2025-11-24 10:06:29',NULL),('2025-11-23 10:06:29','2025-11-23 10:06:29','2025-11-23 10:06:29',1,750,'cb03b4ca-cf54-4ea5-8134-b8aa7e768291',187,'1be7eab758d64df6bb38d4ddeefb99dd','gigabytes',-1,'2025-11-24 10:06:29',NULL),('2025-11-23 10:06:29','2025-11-23 10:06:29','2025-11-23 10:06:29',1,751,'1d806055-7a20-44d1-bb75-72ae095faf4c',188,'1be7eab758d64df6bb38d4ddeefb99dd','volumes_tripleo',-1,'2025-11-24 10:06:29',NULL),('2025-11-23 10:06:29','2025-11-23 10:06:29','2025-11-23 10:06:29',1,752,'59d9475b-046e-49c5-9579-84bff0d1e315',189,'1be7eab758d64df6bb38d4ddeefb99dd','gigabytes_tripleo',-1,'2025-11-24 10:06:29',NULL),('2025-11-23 10:06:30','2025-11-23 10:06:30','2025-11-23 10:06:30',1,753,'7e6683db-9ba1-4b9e-a813-5714a6c722ba',186,'1be7eab758d64df6bb38d4ddeefb99dd','volumes',1,'2025-11-24 10:06:30',NULL),('2025-11-23 10:06:30','2025-11-23 10:06:30','2025-11-23 10:06:30',1,754,'839d46c4-de24-4740-8d66-53742770429b',187,'1be7eab758d64df6bb38d4ddeefb99dd','gigabytes',1,'2025-11-24 10:06:30',NULL),('2025-11-23 10:06:30','2025-11-23 10:06:30','2025-11-23 10:06:30',1,755,'fe554042-6d09-4c3d-9d33-7bc29ea15572',188,'1be7eab758d64df6bb38d4ddeefb99dd','volumes_tripleo',1,'2025-11-24 10:06:30',NULL),('2025-11-23 10:06:30','2025-11-23 10:06:30','2025-11-23 10:06:30',1,756,'bc39c9f7-3cad-467d-a451-a2b151dbce56',189,'1be7eab758d64df6bb38d4ddeefb99dd','gigabytes_tripleo',1,'2025-11-24 10:06:30',NULL),('2025-11-23 10:06:31','2025-11-23 10:06:31','2025-11-23 10:06:31',1,757,'aee4bdca-1447-4878-b37b-4b95d3d902c4',172,'141ccb7a18aa4552b64b95f2b6f47c17','volumes',-1,'2025-11-24 10:06:31',NULL),('2025-11-23 10:06:31','2025-11-23 10:06:31','2025-11-23 10:06:31',1,758,'7c7bd0e1-a5f8-4430-8659-ac57d65a0796',173,'141ccb7a18aa4552b64b95f2b6f47c17','gigabytes',-1,'2025-11-24 10:06:31',NULL),('2025-11-23 10:06:31','2025-11-23 10:06:31','2025-11-23 10:06:31',1,759,'e68a52a4-30f4-49ae-b121-2122b19bc889',174,'141ccb7a18aa4552b64b95f2b6f47c17','volumes_tripleo',-1,'2025-11-24 10:06:31',NULL),('2025-11-23 10:06:31','2025-11-23 10:06:31','2025-11-23 10:06:31',1,760,'327957ff-d818-47f9-b0af-a08dc31e50d5',175,'141ccb7a18aa4552b64b95f2b6f47c17','gigabytes_tripleo',-1,'2025-11-24 10:06:31',NULL),('2025-11-23 10:06:31','2025-11-23 10:06:31','2025-11-23 10:06:31',1,761,'77dcfc11-2671-4a2c-904b-682facb16326',192,'1be7eab758d64df6bb38d4ddeefb99dd','snapshots',1,'2025-11-24 10:06:31',NULL),('2025-11-23 10:06:31','2025-11-23 10:06:31','2025-11-23 10:06:31',1,762,'822e0337-2430-437b-97a2-5bd1fd60ee0f',187,'1be7eab758d64df6bb38d4ddeefb99dd','gigabytes',1,'2025-11-24 10:06:31',NULL),('2025-11-23 10:06:31','2025-11-23 10:06:31','2025-11-23 10:06:31',1,763,'c0af4c4e-4fe9-4fac-b982-d6872229c7bc',189,'1be7eab758d64df6bb38d4ddeefb99dd','gigabytes_tripleo',1,'2025-11-24 10:06:31',NULL),('2025-11-23 10:06:31','2025-11-23 10:06:31','2025-11-23 10:06:31',1,764,'e806bf63-1078-43dd-8aa0-af010a3a5ebe',193,'1be7eab758d64df6bb38d4ddeefb99dd','snapshots_tripleo',1,'2025-11-24 10:06:31',NULL),('2025-11-23 10:06:31','2025-11-23 10:06:31','2025-11-23 10:06:31',1,765,'257837e2-31ab-4e37-b2bb-dcb3985a94ed',172,'141ccb7a18aa4552b64b95f2b6f47c17','volumes',1,'2025-11-24 10:06:31',NULL),('2025-11-23 10:06:31','2025-11-23 10:06:31','2025-11-23 10:06:31',1,766,'28d30251-2104-4e5b-8ac4-e5d5b07b2090',173,'141ccb7a18aa4552b64b95f2b6f47c17','gigabytes',1,'2025-11-24 10:06:31',NULL),('2025-11-23 10:06:31','2025-11-23 10:06:31','2025-11-23 10:06:31',1,767,'435ed65e-4dae-4686-b6fc-763f356e295b',174,'141ccb7a18aa4552b64b95f2b6f47c17','volumes_tripleo',1,'2025-11-24 10:06:31',NULL),('2025-11-23 10:06:31','2025-11-23 10:06:31','2025-11-23 10:06:31',1,768,'b6b7a6b8-a41b-4123-9497-3b5a839deb29',175,'141ccb7a18aa4552b64b95f2b6f47c17','gigabytes_tripleo',1,'2025-11-24 10:06:31',NULL),('2025-11-23 10:06:32','2025-11-23 10:06:32','2025-11-23 10:06:32',1,769,'a057b621-2748-4798-b831-2294fdd0806b',186,'1be7eab758d64df6bb38d4ddeefb99dd','volumes',1,'2025-11-24 10:06:32',NULL),('2025-11-23 10:06:32','2025-11-23 10:06:32','2025-11-23 10:06:32',1,770,'557565ef-489c-444b-b530-74c0cb0b6519',187,'1be7eab758d64df6bb38d4ddeefb99dd','gigabytes',1,'2025-11-24 10:06:32',NULL),('2025-11-23 10:06:32','2025-11-23 10:06:32','2025-11-23 10:06:32',1,771,'4dcfa2b7-1caf-43cb-8053-fb45e8679f09',188,'1be7eab758d64df6bb38d4ddeefb99dd','volumes_tripleo',1,'2025-11-24 10:06:32',NULL),('2025-11-23 10:06:32','2025-11-23 10:06:32','2025-11-23 10:06:32',1,772,'30899ed3-3297-4258-903a-9c462f2a58f7',189,'1be7eab758d64df6bb38d4ddeefb99dd','gigabytes_tripleo',1,'2025-11-24 10:06:32',NULL),('2025-11-23 10:06:32','2025-11-23 10:06:32','2025-11-23 10:06:32',1,773,'d68c941c-dbd3-422d-92d1-ee1d689912ae',184,'141ccb7a18aa4552b64b95f2b6f47c17','backups',1,'2025-11-24 10:06:32',NULL),('2025-11-23 10:06:32','2025-11-23 10:06:32','2025-11-23 10:06:32',1,774,'7c3eedd2-978a-41fa-9bef-a70908892bbc',185,'141ccb7a18aa4552b64b95f2b6f47c17','backup_gigabytes',1,'2025-11-24 10:06:32',NULL),('2025-11-23 10:06:34','2025-11-23 10:06:34','2025-11-23 10:06:34',1,775,'4474964b-f8bb-4222-a279-ad88200d4a0c',194,'33c4eecf43aa413a9f282206f9e9a55b','volumes',1,'2025-11-24 10:06:34',NULL),('2025-11-23 10:06:34','2025-11-23 10:06:34','2025-11-23 10:06:34',1,776,'30bf6baf-42a9-4427-8a2e-54d033a6ec14',195,'33c4eecf43aa413a9f282206f9e9a55b','gigabytes',1,'2025-11-24 10:06:34',NULL),('2025-11-23 10:06:34','2025-11-23 10:06:34','2025-11-23 10:06:34',1,777,'2e076261-3145-49c8-881b-ca39c0eaf565',196,'33c4eecf43aa413a9f282206f9e9a55b','volumes_tripleo',1,'2025-11-24 10:06:34',NULL),('2025-11-23 10:06:34','2025-11-23 10:06:34','2025-11-23 10:06:34',1,778,'b30ea00e-626d-4b8c-b973-827bfa06828a',197,'33c4eecf43aa413a9f282206f9e9a55b','gigabytes_tripleo',1,'2025-11-24 10:06:34',NULL),('2025-11-23 10:06:37','2025-11-23 10:06:37','2025-11-23 10:06:37',1,779,'e0c9f87d-2129-43b0-8719-4bdafd9fe2ad',184,'141ccb7a18aa4552b64b95f2b6f47c17','backups',-1,'2025-11-24 10:06:37',NULL),('2025-11-23 10:06:37','2025-11-23 10:06:37','2025-11-23 10:06:37',1,780,'13a745bc-4d46-4cfe-bc12-8476ac7f2960',185,'141ccb7a18aa4552b64b95f2b6f47c17','backup_gigabytes',-1,'2025-11-24 10:06:37',NULL),('2025-11-23 10:06:40','2025-11-23 10:06:40','2025-11-23 10:06:40',1,781,'f38e63eb-8c9a-4df3-bb8f-21540ff39683',172,'141ccb7a18aa4552b64b95f2b6f47c17','volumes',-1,'2025-11-24 10:06:40',NULL),('2025-11-23 10:06:40','2025-11-23 10:06:40','2025-11-23 10:06:40',1,782,'c48c7351-9c97-4054-b8ed-15c8e58db1b0',173,'141ccb7a18aa4552b64b95f2b6f47c17','gigabytes',-1,'2025-11-24 10:06:40',NULL),('2025-11-23 10:06:40','2025-11-23 10:06:40','2025-11-23 10:06:40',1,783,'70f18532-b493-4bdc-bc62-09e70abd8ec9',174,'141ccb7a18aa4552b64b95f2b6f47c17','volumes_tripleo',-1,'2025-11-24 10:06:40',NULL),('2025-11-23 10:06:40','2025-11-23 10:06:40','2025-11-23 10:06:40',1,784,'4e6cf792-c943-4cee-81b0-d983924306d7',175,'141ccb7a18aa4552b64b95f2b6f47c17','gigabytes_tripleo',-1,'2025-11-24 10:06:40',NULL),('2025-11-23 10:06:40','2025-11-23 10:06:40','2025-11-23 10:06:40',1,785,'3c541a7a-5fb1-49e4-acd0-0752fa490caf',192,'1be7eab758d64df6bb38d4ddeefb99dd','snapshots',-1,'2025-11-24 10:06:40',NULL),('2025-11-23 10:06:40','2025-11-23 10:06:40','2025-11-23 10:06:40',1,786,'0234d951-2703-4c7f-823f-73840723dc87',187,'1be7eab758d64df6bb38d4ddeefb99dd','gigabytes',-1,'2025-11-24 10:06:40',NULL),('2025-11-23 10:06:40','2025-11-23 10:06:40','2025-11-23 10:06:40',1,787,'0cb95301-990a-41fc-af08-b05b5ef1c684',189,'1be7eab758d64df6bb38d4ddeefb99dd','gigabytes_tripleo',-1,'2025-11-24 10:06:40',NULL),('2025-11-23 10:06:40','2025-11-23 10:06:40','2025-11-23 10:06:40',1,788,'c5a01c47-fdd2-4378-9db7-7c7b06f96ce6',193,'1be7eab758d64df6bb38d4ddeefb99dd','snapshots_tripleo',-1,'2025-11-24 10:06:40',NULL),('2025-11-23 10:06:41','2025-11-23 10:06:41','2025-11-23 10:06:41',1,789,'d6e442c1-be6d-4442-a09d-ff0c29923f34',186,'1be7eab758d64df6bb38d4ddeefb99dd','volumes',-1,'2025-11-24 10:06:41',NULL),('2025-11-23 10:06:41','2025-11-23 10:06:41','2025-11-23 10:06:41',1,790,'ac5b144a-554a-4f81-ba4c-03980cd3c758',187,'1be7eab758d64df6bb38d4ddeefb99dd','gigabytes',-1,'2025-11-24 10:06:41',NULL),('2025-11-23 10:06:41','2025-11-23 10:06:41','2025-11-23 10:06:41',1,791,'0a1de022-7d70-450d-afa1-c828581f16b7',188,'1be7eab758d64df6bb38d4ddeefb99dd','volumes_tripleo',-1,'2025-11-24 10:06:41',NULL),('2025-11-23 10:06:41','2025-11-23 10:06:41','2025-11-23 10:06:41',1,792,'049eb435-92bf-44ad-a402-a693948b4808',189,'1be7eab758d64df6bb38d4ddeefb99dd','gigabytes_tripleo',-1,'2025-11-24 10:06:41',NULL),('2025-11-23 10:06:43','2025-11-23 10:06:43','2025-11-23 10:06:43',1,793,'7288eccf-2f98-41fc-9949-35f3726b0e87',186,'1be7eab758d64df6bb38d4ddeefb99dd','volumes',-1,'2025-11-24 10:06:43',NULL),('2025-11-23 10:06:43','2025-11-23 10:06:43','2025-11-23 10:06:43',1,794,'58edf469-4376-4d6b-961f-19b6ffb53fef',187,'1be7eab758d64df6bb38d4ddeefb99dd','gigabytes',-1,'2025-11-24 10:06:43',NULL),('2025-11-23 10:06:43','2025-11-23 10:06:43','2025-11-23 10:06:43',1,795,'89090759-8a17-4201-9172-d69e95d86c86',188,'1be7eab758d64df6bb38d4ddeefb99dd','volumes_tripleo',-1,'2025-11-24 10:06:43',NULL),('2025-11-23 10:06:43','2025-11-23 10:06:43','2025-11-23 10:06:43',1,796,'ce29f74f-d3de-4973-be3a-0f678ee4119c',189,'1be7eab758d64df6bb38d4ddeefb99dd','gigabytes_tripleo',-1,'2025-11-24 10:06:43',NULL),('2025-11-23 10:06:47','2025-11-23 10:06:47','2025-11-23 10:06:47',1,797,'bf0d26f5-e0b7-44d1-80d7-31e4122f26e0',198,'44a6cb5f8b014bad84cfff33db7a4de0','volumes',1,'2025-11-24 10:06:47',NULL),('2025-11-23 10:06:47','2025-11-23 10:06:47','2025-11-23 10:06:47',1,798,'0483b680-6528-4fc4-bc3a-9591dad6e406',199,'44a6cb5f8b014bad84cfff33db7a4de0','gigabytes',1,'2025-11-24 10:06:47',NULL),('2025-11-23 10:06:47','2025-11-23 10:06:47','2025-11-23 10:06:47',1,799,'e13acbd5-8c68-4987-b235-8aa1d261a879',200,'44a6cb5f8b014bad84cfff33db7a4de0','volumes_tripleo',1,'2025-11-24 10:06:47',NULL),('2025-11-23 10:06:47','2025-11-23 10:06:47','2025-11-23 10:06:47',1,800,'d27fd1ed-bf37-424b-aac9-f994787008af',201,'44a6cb5f8b014bad84cfff33db7a4de0','gigabytes_tripleo',1,'2025-11-24 10:06:47',NULL),('2025-11-23 10:06:48','2025-11-23 10:06:48','2025-11-23 10:06:48',1,801,'1ba8457e-6c2e-4a91-9772-062261a6a9aa',202,'44a6cb5f8b014bad84cfff33db7a4de0','backups',1,'2025-11-24 10:06:48',NULL),('2025-11-23 10:06:48','2025-11-23 10:06:48','2025-11-23 10:06:48',1,802,'4d97821e-22f7-468b-985e-a9be6ce5f212',203,'44a6cb5f8b014bad84cfff33db7a4de0','backup_gigabytes',1,'2025-11-24 10:06:48',NULL),('2025-11-23 10:06:49','2025-11-23 10:06:49','2025-11-23 10:06:49',1,803,'0f953edc-0942-45b5-af8d-cc5038be7602',204,'dd925bc8c28148ba8527b8de09a93c3c','volumes',1,'2025-11-24 10:06:49',NULL),('2025-11-23 10:06:49','2025-11-23 10:06:49','2025-11-23 10:06:49',1,804,'460b8de3-5c5c-4a9a-a8ad-dfdfb338f3f3',205,'dd925bc8c28148ba8527b8de09a93c3c','gigabytes',1,'2025-11-24 10:06:49',NULL),('2025-11-23 10:06:49','2025-11-23 10:06:49','2025-11-23 10:06:49',1,805,'a214a291-2a58-429b-87fe-78c6e4ef8227',206,'dd925bc8c28148ba8527b8de09a93c3c','volumes_tripleo',1,'2025-11-24 10:06:49',NULL),('2025-11-23 10:06:49','2025-11-23 10:06:49','2025-11-23 10:06:49',1,806,'93d79ec9-3cc4-4872-b5dd-e510353cb173',207,'dd925bc8c28148ba8527b8de09a93c3c','gigabytes_tripleo',1,'2025-11-24 10:06:49',NULL),('2025-11-23 10:06:50','2025-11-23 10:06:50','2025-11-23 10:06:50',1,807,'d7fbaf39-09ad-456e-97f4-04ae033a8dcc',208,'dd925bc8c28148ba8527b8de09a93c3c','snapshots',1,'2025-11-24 10:06:50',NULL),('2025-11-23 10:06:50','2025-11-23 10:06:50','2025-11-23 10:06:50',1,808,'c780660e-ca4c-4743-87b0-7e8d6d2554e6',205,'dd925bc8c28148ba8527b8de09a93c3c','gigabytes',1,'2025-11-24 10:06:50',NULL),('2025-11-23 10:06:50','2025-11-23 10:06:50','2025-11-23 10:06:50',1,809,'e0631d81-f7f4-4776-91f8-25d1c2bda947',207,'dd925bc8c28148ba8527b8de09a93c3c','gigabytes_tripleo',1,'2025-11-24 10:06:50',NULL),('2025-11-23 10:06:50','2025-11-23 10:06:50','2025-11-23 10:06:50',1,810,'9d2457a0-8b3f-4d39-a866-b17289e9e0a7',209,'dd925bc8c28148ba8527b8de09a93c3c','snapshots_tripleo',1,'2025-11-24 10:06:50',NULL),('2025-11-23 10:06:54','2025-11-23 10:06:54','2025-11-23 10:06:54',1,811,'b0f53ac2-b111-496e-b013-a75f0f8e1b06',202,'44a6cb5f8b014bad84cfff33db7a4de0','backups',-1,'2025-11-24 10:06:54',NULL),('2025-11-23 10:06:54','2025-11-23 10:06:54','2025-11-23 10:06:54',1,812,'9e1fedfd-6922-4b7c-9d7c-8957d37f6a90',203,'44a6cb5f8b014bad84cfff33db7a4de0','backup_gigabytes',-1,'2025-11-24 10:06:54',NULL),('2025-11-23 10:06:54','2025-11-23 10:06:54','2025-11-23 10:06:54',1,813,'304c9cfc-990a-4cf6-9da2-70de08ec6350',208,'dd925bc8c28148ba8527b8de09a93c3c','snapshots',-1,'2025-11-24 10:06:54',NULL),('2025-11-23 10:06:54','2025-11-23 10:06:54','2025-11-23 10:06:54',1,814,'e393ec7a-6706-4637-8651-480705c44759',205,'dd925bc8c28148ba8527b8de09a93c3c','gigabytes',-1,'2025-11-24 10:06:54',NULL),('2025-11-23 10:06:54','2025-11-23 10:06:54','2025-11-23 10:06:54',1,815,'e5e50778-f0da-4346-81ed-009aa02b3636',207,'dd925bc8c28148ba8527b8de09a93c3c','gigabytes_tripleo',-1,'2025-11-24 10:06:54',NULL),('2025-11-23 10:06:54','2025-11-23 10:06:54','2025-11-23 10:06:54',1,816,'79d37310-1624-4f7a-8ff2-d4d94053aa9d',209,'dd925bc8c28148ba8527b8de09a93c3c','snapshots_tripleo',-1,'2025-11-24 10:06:54',NULL),('2025-11-23 10:06:55','2025-11-23 10:06:56','2025-11-23 10:06:56',1,817,'9fb7b733-3c69-4ad1-85d4-6e7feed440ff',204,'dd925bc8c28148ba8527b8de09a93c3c','volumes',-1,'2025-11-24 10:06:55',NULL),('2025-11-23 10:06:55','2025-11-23 10:06:56','2025-11-23 10:06:56',1,818,'caa4b5e3-fb02-4298-979c-7f59e1f75093',205,'dd925bc8c28148ba8527b8de09a93c3c','gigabytes',-1,'2025-11-24 10:06:55',NULL),('2025-11-23 10:06:55','2025-11-23 10:06:56','2025-11-23 10:06:56',1,819,'80a16d13-9276-4040-8a21-c381efcc80f1',206,'dd925bc8c28148ba8527b8de09a93c3c','volumes_tripleo',-1,'2025-11-24 10:06:55',NULL),('2025-11-23 10:06:55','2025-11-23 10:06:56','2025-11-23 10:06:56',1,820,'fd7267fc-98ff-483e-b90c-a532ce08b89e',207,'dd925bc8c28148ba8527b8de09a93c3c','gigabytes_tripleo',-1,'2025-11-24 10:06:55',NULL),('2025-11-23 10:06:56','2025-11-23 10:06:56','2025-11-23 10:06:56',1,821,'ae52501c-a815-4dc5-b639-e768e11f9f7e',198,'44a6cb5f8b014bad84cfff33db7a4de0','volumes',-1,'2025-11-24 10:06:56',NULL),('2025-11-23 10:06:56','2025-11-23 10:06:56','2025-11-23 10:06:56',1,822,'e148d4d8-b51f-4913-995b-d39a6f0645f0',199,'44a6cb5f8b014bad84cfff33db7a4de0','gigabytes',-1,'2025-11-24 10:06:56',NULL),('2025-11-23 10:06:56','2025-11-23 10:06:56','2025-11-23 10:06:56',1,823,'fda6b01a-5e70-425b-b399-6962e4f4dcb6',200,'44a6cb5f8b014bad84cfff33db7a4de0','volumes_tripleo',-1,'2025-11-24 10:06:56',NULL),('2025-11-23 10:06:56','2025-11-23 10:06:56','2025-11-23 10:06:56',1,824,'239ea817-f90a-4546-9b08-2ee0fc48cb90',201,'44a6cb5f8b014bad84cfff33db7a4de0','gigabytes_tripleo',-1,'2025-11-24 10:06:56',NULL),('2025-11-23 10:06:58','2025-11-23 10:06:59','2025-11-23 10:06:59',1,825,'63fbc170-6f0e-4959-8316-c5d6e193c445',210,'acf2d5195bde4e69ba34cd2a2c03e717','volumes',1,'2025-11-24 10:06:58',NULL),('2025-11-23 10:06:58','2025-11-23 10:06:59','2025-11-23 10:06:59',1,826,'336d035c-8183-4785-8c9b-dc6980b69651',211,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes',1,'2025-11-24 10:06:58',NULL),('2025-11-23 10:06:58','2025-11-23 10:06:59','2025-11-23 10:06:59',1,827,'0763c617-2dc2-4da5-ba6b-fee7a7caa911',212,'acf2d5195bde4e69ba34cd2a2c03e717','volumes_tripleo',1,'2025-11-24 10:06:58',NULL),('2025-11-23 10:06:58','2025-11-23 10:06:59','2025-11-23 10:06:59',1,828,'7c78dbbc-0df5-4a20-a8e2-b2300afab35a',213,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes_tripleo',1,'2025-11-24 10:06:58',NULL),('2025-11-23 10:07:00','2025-11-23 10:07:00','2025-11-23 10:07:00',1,829,'09d94b1f-7c46-4ced-bd53-f0807de6817b',210,'acf2d5195bde4e69ba34cd2a2c03e717','volumes',1,'2025-11-24 10:07:00',NULL),('2025-11-23 10:07:00','2025-11-23 10:07:00','2025-11-23 10:07:00',1,830,'aa8354fa-4eac-4a89-b00b-57ffd5139123',211,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes',1,'2025-11-24 10:07:00',NULL),('2025-11-23 10:07:00','2025-11-23 10:07:00','2025-11-23 10:07:00',1,831,'881c2e62-c728-481f-8fd6-b78e4d17b382',212,'acf2d5195bde4e69ba34cd2a2c03e717','volumes_tripleo',1,'2025-11-24 10:07:00',NULL),('2025-11-23 10:07:00','2025-11-23 10:07:00','2025-11-23 10:07:00',1,832,'cf63f962-a092-4819-b852-b707492619a7',213,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes_tripleo',1,'2025-11-24 10:07:00',NULL),('2025-11-23 10:07:02','2025-11-23 10:07:02','2025-11-23 10:07:02',1,833,'73ac737a-1a61-42f0-836e-929ed6435c37',210,'acf2d5195bde4e69ba34cd2a2c03e717','volumes',-1,'2025-11-24 10:07:02',NULL),('2025-11-23 10:07:02','2025-11-23 10:07:02','2025-11-23 10:07:02',1,834,'c22e21af-8002-4a03-85db-7c9690a6afd5',211,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes',-1,'2025-11-24 10:07:02',NULL),('2025-11-23 10:07:02','2025-11-23 10:07:02','2025-11-23 10:07:02',1,835,'ec165528-81e6-45db-8fc7-990c00b5efd1',212,'acf2d5195bde4e69ba34cd2a2c03e717','volumes_tripleo',-1,'2025-11-24 10:07:02',NULL),('2025-11-23 10:07:02','2025-11-23 10:07:02','2025-11-23 10:07:02',1,836,'56474990-79a3-43b9-a1ec-070315eeab39',213,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes_tripleo',-1,'2025-11-24 10:07:02',NULL),('2025-11-23 10:07:03','2025-11-23 10:07:03','2025-11-23 10:07:03',1,837,'cd0ad8f4-0a81-4ca5-a25e-def9fd4cc007',210,'acf2d5195bde4e69ba34cd2a2c03e717','volumes',-1,'2025-11-24 10:07:03',NULL),('2025-11-23 10:07:03','2025-11-23 10:07:03','2025-11-23 10:07:03',1,838,'3e9c2349-c42f-45f5-a8ab-1733263979d9',211,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes',-1,'2025-11-24 10:07:03',NULL),('2025-11-23 10:07:03','2025-11-23 10:07:03','2025-11-23 10:07:03',1,839,'35408f12-add3-4287-b549-f91248c9810c',212,'acf2d5195bde4e69ba34cd2a2c03e717','volumes_tripleo',-1,'2025-11-24 10:07:03',NULL),('2025-11-23 10:07:03','2025-11-23 10:07:03','2025-11-23 10:07:03',1,840,'287d937c-aa13-4f13-a822-ce1bd79f2901',213,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes_tripleo',-1,'2025-11-24 10:07:03',NULL),('2025-11-23 10:07:04','2025-11-23 10:07:04','2025-11-23 10:07:04',1,841,'134cbb51-3afb-49ab-b1f3-44a61e765010',210,'acf2d5195bde4e69ba34cd2a2c03e717','volumes',1,'2025-11-24 10:07:04',NULL),('2025-11-23 10:07:04','2025-11-23 10:07:04','2025-11-23 10:07:04',1,842,'7b71ae1c-e2c8-45ff-9c8e-0cde48385c10',211,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes',1,'2025-11-24 10:07:04',NULL),('2025-11-23 10:07:04','2025-11-23 10:07:04','2025-11-23 10:07:04',1,843,'747ec4d4-0693-40a2-9081-ba611be6eb23',212,'acf2d5195bde4e69ba34cd2a2c03e717','volumes_tripleo',1,'2025-11-24 10:07:04',NULL),('2025-11-23 10:07:04','2025-11-23 10:07:04','2025-11-23 10:07:04',1,844,'7310e215-d504-44c6-988a-439804ce5067',213,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes_tripleo',1,'2025-11-24 10:07:04',NULL),('2025-11-23 10:07:05','2025-11-23 10:07:05','2025-11-23 10:07:05',1,845,'934dd96d-d898-43ca-8956-b134fad728be',210,'acf2d5195bde4e69ba34cd2a2c03e717','volumes',1,'2025-11-24 10:07:05',NULL),('2025-11-23 10:07:05','2025-11-23 10:07:05','2025-11-23 10:07:05',1,846,'c120608e-8fd1-495d-a3de-116cd5a0665f',211,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes',1,'2025-11-24 10:07:05',NULL),('2025-11-23 10:07:05','2025-11-23 10:07:05','2025-11-23 10:07:05',1,847,'d3eb0e46-5786-425a-af0d-36e7b40de59b',212,'acf2d5195bde4e69ba34cd2a2c03e717','volumes_tripleo',1,'2025-11-24 10:07:05',NULL),('2025-11-23 10:07:05','2025-11-23 10:07:05','2025-11-23 10:07:05',1,848,'10a48c76-0ef5-48d3-8938-1a14b1a9bdda',213,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes_tripleo',1,'2025-11-24 10:07:05',NULL),('2025-11-23 10:07:08','2025-11-23 10:07:08','2025-11-23 10:07:08',1,849,'b6df12ef-36ca-4aed-854a-4603bdaa7cba',210,'acf2d5195bde4e69ba34cd2a2c03e717','volumes',1,'2025-11-24 10:07:07',NULL),('2025-11-23 10:07:08','2025-11-23 10:07:08','2025-11-23 10:07:08',1,850,'e58e7d9c-3341-4279-98d2-3e5ace465d8f',211,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes',1,'2025-11-24 10:07:07',NULL),('2025-11-23 10:07:08','2025-11-23 10:07:08','2025-11-23 10:07:08',1,851,'90e257fb-effe-44c8-ac74-79c6f2b3a4a3',212,'acf2d5195bde4e69ba34cd2a2c03e717','volumes_tripleo',1,'2025-11-24 10:07:07',NULL),('2025-11-23 10:07:08','2025-11-23 10:07:08','2025-11-23 10:07:08',1,852,'a4b908a5-ccb4-4a7f-9016-aaab86497d66',213,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes_tripleo',1,'2025-11-24 10:07:07',NULL),('2025-11-23 10:07:10','2025-11-23 10:07:10','2025-11-23 10:07:10',1,853,'e756fa10-37d7-4426-857b-5e78365247b5',210,'acf2d5195bde4e69ba34cd2a2c03e717','volumes',-1,'2025-11-24 10:07:10',NULL),('2025-11-23 10:07:10','2025-11-23 10:07:10','2025-11-23 10:07:10',1,854,'f0bb6355-4b21-49d0-95c3-73605d352ef6',211,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes',-1,'2025-11-24 10:07:10',NULL),('2025-11-23 10:07:10','2025-11-23 10:07:10','2025-11-23 10:07:10',1,855,'71bfea4a-74d1-4bc0-a3f2-8d253dc408b5',212,'acf2d5195bde4e69ba34cd2a2c03e717','volumes_tripleo',-1,'2025-11-24 10:07:10',NULL),('2025-11-23 10:07:10','2025-11-23 10:07:10','2025-11-23 10:07:10',1,856,'a818a855-eb48-4061-b1a7-3d5bae185dde',213,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes_tripleo',-1,'2025-11-24 10:07:10',NULL),('2025-11-23 10:07:11','2025-11-23 10:07:11','2025-11-23 10:07:11',1,857,'af08bb8d-61a8-445e-8843-58a3da80e832',210,'acf2d5195bde4e69ba34cd2a2c03e717','volumes',-1,'2025-11-24 10:07:11',NULL),('2025-11-23 10:07:11','2025-11-23 10:07:11','2025-11-23 10:07:11',1,858,'a836611c-cce2-4981-a42b-24badf96686f',211,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes',-1,'2025-11-24 10:07:11',NULL),('2025-11-23 10:07:11','2025-11-23 10:07:11','2025-11-23 10:07:11',1,859,'3fb592bb-3d8d-494a-9579-dd29db29c19a',212,'acf2d5195bde4e69ba34cd2a2c03e717','volumes_tripleo',-1,'2025-11-24 10:07:11',NULL),('2025-11-23 10:07:11','2025-11-23 10:07:11','2025-11-23 10:07:11',1,860,'37e29443-d430-4f8c-88a3-d76275bd87a2',213,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes_tripleo',-1,'2025-11-24 10:07:11',NULL),('2025-11-23 10:07:13','2025-11-23 10:07:13','2025-11-23 10:07:13',1,861,'2b0c7b60-7669-4486-8126-9d9c2db38850',210,'acf2d5195bde4e69ba34cd2a2c03e717','volumes',-1,'2025-11-24 10:07:13',NULL),('2025-11-23 10:07:13','2025-11-23 10:07:13','2025-11-23 10:07:13',1,862,'9b662f01-0fb1-46d4-ac7b-85dee34cde13',211,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes',-1,'2025-11-24 10:07:13',NULL),('2025-11-23 10:07:13','2025-11-23 10:07:13','2025-11-23 10:07:13',1,863,'63fb4f3b-f543-45ee-8f42-47aa4e49bbed',212,'acf2d5195bde4e69ba34cd2a2c03e717','volumes_tripleo',-1,'2025-11-24 10:07:13',NULL),('2025-11-23 10:07:13','2025-11-23 10:07:13','2025-11-23 10:07:13',1,864,'ed110666-bafb-433a-b638-254cfda910de',213,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes_tripleo',-1,'2025-11-24 10:07:13',NULL),('2025-11-23 10:07:14','2025-11-23 10:07:14','2025-11-23 10:07:14',1,865,'a02a3005-2f32-4b7c-a5b1-44f38022d217',210,'acf2d5195bde4e69ba34cd2a2c03e717','volumes',1,'2025-11-24 10:07:14',NULL),('2025-11-23 10:07:14','2025-11-23 10:07:14','2025-11-23 10:07:14',1,866,'91a3b31b-1777-4510-ad63-70e4e6ec7a02',211,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes',1,'2025-11-24 10:07:14',NULL),('2025-11-23 10:07:14','2025-11-23 10:07:14','2025-11-23 10:07:14',1,867,'d8c713cf-9620-427b-96d1-2badac13c9eb',212,'acf2d5195bde4e69ba34cd2a2c03e717','volumes_tripleo',1,'2025-11-24 10:07:14',NULL),('2025-11-23 10:07:14','2025-11-23 10:07:14','2025-11-23 10:07:14',1,868,'d4e6ae3b-4c7d-48da-9d58-569d9d8526f1',213,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes_tripleo',1,'2025-11-24 10:07:14',NULL),('2025-11-23 10:07:21','2025-11-23 10:07:21','2025-11-23 10:07:21',1,869,'223b3c0c-6e03-4c47-b2fa-c674c9d10d5f',210,'acf2d5195bde4e69ba34cd2a2c03e717','volumes',1,'2025-11-24 10:07:21',NULL),('2025-11-23 10:07:21','2025-11-23 10:07:21','2025-11-23 10:07:21',1,870,'b1fdec25-03ee-4974-901b-1384f46602bb',211,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes',1,'2025-11-24 10:07:21',NULL),('2025-11-23 10:07:21','2025-11-23 10:07:21','2025-11-23 10:07:21',1,871,'0727d949-60e6-4b2e-a4ee-544bf1d7a6ac',212,'acf2d5195bde4e69ba34cd2a2c03e717','volumes_tripleo',1,'2025-11-24 10:07:21',NULL),('2025-11-23 10:07:21','2025-11-23 10:07:21','2025-11-23 10:07:21',1,872,'e1772dc0-4c76-4413-ae11-6b2373a7f551',213,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes_tripleo',1,'2025-11-24 10:07:21',NULL),('2025-11-23 10:07:23','2025-11-23 10:07:23','2025-11-23 10:07:23',1,873,'ad876b60-4060-423d-b5a2-a7c3f5c53bcc',210,'acf2d5195bde4e69ba34cd2a2c03e717','volumes',-1,'2025-11-24 10:07:23',NULL),('2025-11-23 10:07:23','2025-11-23 10:07:23','2025-11-23 10:07:23',1,874,'997d4f04-5089-422e-83d9-6ac25ce45d8f',211,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes',-1,'2025-11-24 10:07:23',NULL),('2025-11-23 10:07:23','2025-11-23 10:07:23','2025-11-23 10:07:23',1,875,'d5b378bd-a580-4bb2-9863-2f38b51bac05',212,'acf2d5195bde4e69ba34cd2a2c03e717','volumes_tripleo',-1,'2025-11-24 10:07:23',NULL),('2025-11-23 10:07:23','2025-11-23 10:07:23','2025-11-23 10:07:23',1,876,'aef94295-9b49-4b5b-8511-53d09af4cd47',213,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes_tripleo',-1,'2025-11-24 10:07:23',NULL),('2025-11-23 10:07:24','2025-11-23 10:07:24','2025-11-23 10:07:24',1,877,'d7c93be4-6f67-4daf-b3b5-ca91475c0e3c',194,'33c4eecf43aa413a9f282206f9e9a55b','volumes',-1,'2025-11-24 10:07:24',NULL),('2025-11-23 10:07:24','2025-11-23 10:07:24','2025-11-23 10:07:24',1,878,'f0be4b48-eb50-4485-ae10-f5bb8c679537',195,'33c4eecf43aa413a9f282206f9e9a55b','gigabytes',-1,'2025-11-24 10:07:24',NULL),('2025-11-23 10:07:24','2025-11-23 10:07:24','2025-11-23 10:07:24',1,879,'3a404760-d6f8-4ef1-a9b6-92f463ec8de6',196,'33c4eecf43aa413a9f282206f9e9a55b','volumes_tripleo',-1,'2025-11-24 10:07:24',NULL),('2025-11-23 10:07:24','2025-11-23 10:07:24','2025-11-23 10:07:24',1,880,'1a5a4350-1e6d-4224-82b9-39b2b9d584bc',197,'33c4eecf43aa413a9f282206f9e9a55b','gigabytes_tripleo',-1,'2025-11-24 10:07:24',NULL),('2025-11-23 10:07:24','2025-11-23 10:07:24','2025-11-23 10:07:24',1,881,'3657c0ce-a4b1-4f58-b700-747745c2f4ad',210,'acf2d5195bde4e69ba34cd2a2c03e717','volumes',-1,'2025-11-24 10:07:24',NULL),('2025-11-23 10:07:24','2025-11-23 10:07:24','2025-11-23 10:07:24',1,882,'7ffebb89-5f15-4804-b480-69438529b945',211,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes',-1,'2025-11-24 10:07:24',NULL),('2025-11-23 10:07:24','2025-11-23 10:07:24','2025-11-23 10:07:24',1,883,'d01e210c-3aea-4c69-b5ee-02c60d16a63a',212,'acf2d5195bde4e69ba34cd2a2c03e717','volumes_tripleo',-1,'2025-11-24 10:07:24',NULL),('2025-11-23 10:07:24','2025-11-23 10:07:24','2025-11-23 10:07:24',1,884,'42e1dd6a-6286-48aa-8e9e-cf7c39cb757f',213,'acf2d5195bde4e69ba34cd2a2c03e717','gigabytes_tripleo',-1,'2025-11-24 10:07:24',NULL),('2025-11-23 10:07:28','2025-11-23 10:07:28','2025-11-23 10:07:28',1,885,'71aefa73-be97-4916-acca-0be628c892cf',214,'b636df0d8cb546cbb04ef3840b8bf85d','volumes',1,'2025-11-24 10:07:28',NULL),('2025-11-23 10:07:28','2025-11-23 10:07:28','2025-11-23 10:07:28',1,886,'af3b6a16-bda3-44b8-acc2-376ac95f0c51',215,'b636df0d8cb546cbb04ef3840b8bf85d','gigabytes',1,'2025-11-24 10:07:28',NULL),('2025-11-23 10:07:28','2025-11-23 10:07:28','2025-11-23 10:07:28',1,887,'28829818-c78d-4987-b739-e746ce084e3a',216,'b636df0d8cb546cbb04ef3840b8bf85d','volumes_tripleo',1,'2025-11-24 10:07:28',NULL),('2025-11-23 10:07:28','2025-11-23 10:07:28','2025-11-23 10:07:28',1,888,'4856f1e0-2a69-43e7-a46b-96428ee956b7',217,'b636df0d8cb546cbb04ef3840b8bf85d','gigabytes_tripleo',1,'2025-11-24 10:07:28',NULL),('2025-11-23 10:07:29','2025-11-23 10:07:29','2025-11-23 10:07:29',1,889,'058fb582-7671-4436-9e3d-2d4ae43ee39c',214,'b636df0d8cb546cbb04ef3840b8bf85d','volumes',1,'2025-11-24 10:07:29',NULL),('2025-11-23 10:07:29','2025-11-23 10:07:29','2025-11-23 10:07:29',1,890,'b89c982a-10ff-407d-a7aa-2773fc884bd6',215,'b636df0d8cb546cbb04ef3840b8bf85d','gigabytes',1,'2025-11-24 10:07:29',NULL),('2025-11-23 10:07:29','2025-11-23 10:07:29','2025-11-23 10:07:29',1,891,'1486e223-c2f0-4bc1-aaf7-c7be6e776d6a',216,'b636df0d8cb546cbb04ef3840b8bf85d','volumes_tripleo',1,'2025-11-24 10:07:29',NULL),('2025-11-23 10:07:29','2025-11-23 10:07:29','2025-11-23 10:07:29',1,892,'457ae945-3642-420d-bd03-c40a7b5fc4dd',217,'b636df0d8cb546cbb04ef3840b8bf85d','gigabytes_tripleo',1,'2025-11-24 10:07:29',NULL),('2025-11-23 10:07:31','2025-11-23 10:07:31','2025-11-23 10:07:31',1,893,'1ff93558-b40d-4ba8-a800-128674d428bf',214,'b636df0d8cb546cbb04ef3840b8bf85d','volumes',1,'2025-11-24 10:07:31',NULL),('2025-11-23 10:07:31','2025-11-23 10:07:31','2025-11-23 10:07:31',1,894,'c869564c-d093-4932-aa2f-111f5ff0736e',215,'b636df0d8cb546cbb04ef3840b8bf85d','gigabytes',1,'2025-11-24 10:07:31',NULL),('2025-11-23 10:07:31','2025-11-23 10:07:31','2025-11-23 10:07:31',1,895,'a8806d23-cda7-4cd8-9db9-645d24e95fd2',216,'b636df0d8cb546cbb04ef3840b8bf85d','volumes_tripleo',1,'2025-11-24 10:07:31',NULL),('2025-11-23 10:07:31','2025-11-23 10:07:31','2025-11-23 10:07:31',1,896,'48ea9100-b867-4dd8-b180-5a33148b6f45',217,'b636df0d8cb546cbb04ef3840b8bf85d','gigabytes_tripleo',1,'2025-11-24 10:07:31',NULL),('2025-11-23 10:07:34','2025-11-23 10:07:34','2025-11-23 10:07:34',1,897,'83a78876-4137-485b-92a8-6ae025157571',214,'b636df0d8cb546cbb04ef3840b8bf85d','volumes',-1,'2025-11-24 10:07:34',NULL),('2025-11-23 10:07:34','2025-11-23 10:07:34','2025-11-23 10:07:34',1,898,'b370b0c7-eca0-44af-b21f-38ab19de3371',215,'b636df0d8cb546cbb04ef3840b8bf85d','gigabytes',-1,'2025-11-24 10:07:34',NULL),('2025-11-23 10:07:34','2025-11-23 10:07:34','2025-11-23 10:07:34',1,899,'b22b37f8-d997-4992-8a14-465339cce70d',216,'b636df0d8cb546cbb04ef3840b8bf85d','volumes_tripleo',-1,'2025-11-24 10:07:34',NULL),('2025-11-23 10:07:34','2025-11-23 10:07:34','2025-11-23 10:07:34',1,900,'affb6109-6571-498c-adde-4d6a802790a5',217,'b636df0d8cb546cbb04ef3840b8bf85d','gigabytes_tripleo',-1,'2025-11-24 10:07:34',NULL),('2025-11-23 10:07:35','2025-11-23 10:07:35','2025-11-23 10:07:35',1,901,'8e56df53-186b-4a90-84f7-9fc89f63e7a7',214,'b636df0d8cb546cbb04ef3840b8bf85d','volumes',-1,'2025-11-24 10:07:35',NULL),('2025-11-23 10:07:35','2025-11-23 10:07:35','2025-11-23 10:07:35',1,902,'f493f68e-0290-4f7a-99da-81e5022cbebc',215,'b636df0d8cb546cbb04ef3840b8bf85d','gigabytes',-1,'2025-11-24 10:07:35',NULL),('2025-11-23 10:07:35','2025-11-23 10:07:35','2025-11-23 10:07:35',1,903,'a025eb88-7617-4fe7-9dee-73ff0ede67f7',216,'b636df0d8cb546cbb04ef3840b8bf85d','volumes_tripleo',-1,'2025-11-24 10:07:35',NULL),('2025-11-23 10:07:35','2025-11-23 10:07:35','2025-11-23 10:07:35',1,904,'9d537474-0340-4c81-8d86-8453d07fe6ac',217,'b636df0d8cb546cbb04ef3840b8bf85d','gigabytes_tripleo',-1,'2025-11-24 10:07:35',NULL),('2025-11-23 10:07:37','2025-11-23 10:07:37','2025-11-23 10:07:37',1,905,'dbadee54-50ca-4131-a40a-5e7902ee81d4',214,'b636df0d8cb546cbb04ef3840b8bf85d','volumes',-1,'2025-11-24 10:07:36',NULL),('2025-11-23 10:07:37','2025-11-23 10:07:37','2025-11-23 10:07:37',1,906,'26b658f1-6129-47d9-83a1-501a0b0a7f27',215,'b636df0d8cb546cbb04ef3840b8bf85d','gigabytes',-1,'2025-11-24 10:07:36',NULL),('2025-11-23 10:07:37','2025-11-23 10:07:37','2025-11-23 10:07:37',1,907,'53a9bfb8-39ee-4e69-baf3-6afe61d9c9c9',216,'b636df0d8cb546cbb04ef3840b8bf85d','volumes_tripleo',-1,'2025-11-24 10:07:36',NULL),('2025-11-23 10:07:37','2025-11-23 10:07:37','2025-11-23 10:07:37',1,908,'186c4195-38a7-4665-a8d3-78b21269c9d9',217,'b636df0d8cb546cbb04ef3840b8bf85d','gigabytes_tripleo',-1,'2025-11-24 10:07:36',NULL),('2025-11-23 10:07:41','2025-11-23 10:07:41','2025-11-23 10:07:41',1,909,'780aa141-9703-41a8-82f1-359d736357ef',218,'58bf8ae7240d4a5597bb2d7ae200e54b','volumes',1,'2025-11-24 10:07:41',NULL),('2025-11-23 10:07:41','2025-11-23 10:07:41','2025-11-23 10:07:41',1,910,'434d033b-78ce-4e90-998f-be0369e50f47',219,'58bf8ae7240d4a5597bb2d7ae200e54b','gigabytes',2,'2025-11-24 10:07:41',NULL),('2025-11-23 10:07:41','2025-11-23 10:07:41','2025-11-23 10:07:41',1,911,'ce63ce6a-8fc0-497b-a822-6c7e34cf0492',220,'58bf8ae7240d4a5597bb2d7ae200e54b','volumes_tripleo',1,'2025-11-24 10:07:41',NULL),('2025-11-23 10:07:41','2025-11-23 10:07:41','2025-11-23 10:07:41',1,912,'f560d449-6750-422a-a2d2-84feb69479c5',221,'58bf8ae7240d4a5597bb2d7ae200e54b','gigabytes_tripleo',2,'2025-11-24 10:07:41',NULL),('2025-11-23 10:07:43','2025-11-23 10:07:43','2025-11-23 10:07:43',1,913,'5229097f-464e-4d3e-a8d7-e7c6233630d1',222,'58bf8ae7240d4a5597bb2d7ae200e54b','snapshots',1,'2025-11-24 10:07:43',NULL),('2025-11-23 10:07:43','2025-11-23 10:07:43','2025-11-23 10:07:43',1,914,'bcb823ad-f3a6-41a6-b9e0-f4411b85e4ce',219,'58bf8ae7240d4a5597bb2d7ae200e54b','gigabytes',2,'2025-11-24 10:07:43',NULL),('2025-11-23 10:07:43','2025-11-23 10:07:43','2025-11-23 10:07:43',1,915,'741e2b6c-c81c-4937-afaf-d0a1e6c407d5',221,'58bf8ae7240d4a5597bb2d7ae200e54b','gigabytes_tripleo',2,'2025-11-24 10:07:43',NULL),('2025-11-23 10:07:43','2025-11-23 10:07:43','2025-11-23 10:07:43',1,916,'9ce676ab-8ba4-42b5-bc91-51c702c5ed00',223,'58bf8ae7240d4a5597bb2d7ae200e54b','snapshots_tripleo',1,'2025-11-24 10:07:43',NULL),('2025-11-23 10:07:46','2025-11-23 10:07:46','2025-11-23 10:07:46',1,917,'0bd13c6b-1542-49fe-855a-53e575b1473a',222,'58bf8ae7240d4a5597bb2d7ae200e54b','snapshots',-1,'2025-11-24 10:07:46',NULL),('2025-11-23 10:07:46','2025-11-23 10:07:46','2025-11-23 10:07:46',1,918,'f71c8f3d-f4c5-40ae-b702-40586aef24ac',219,'58bf8ae7240d4a5597bb2d7ae200e54b','gigabytes',-2,'2025-11-24 10:07:46',NULL),('2025-11-23 10:07:46','2025-11-23 10:07:46','2025-11-23 10:07:46',1,919,'e2d5ae74-aaf4-42c3-a06f-a4c2103cce1c',221,'58bf8ae7240d4a5597bb2d7ae200e54b','gigabytes_tripleo',-2,'2025-11-24 10:07:46',NULL),('2025-11-23 10:07:46','2025-11-23 10:07:46','2025-11-23 10:07:46',1,920,'9ce53986-0a6c-4d17-bd86-1b20eb73abe9',223,'58bf8ae7240d4a5597bb2d7ae200e54b','snapshots_tripleo',-1,'2025-11-24 10:07:46',NULL),('2025-11-23 10:07:48','2025-11-23 10:07:48','2025-11-23 10:07:48',1,921,'a17ae268-4103-4c16-b0e7-37939f38b5fe',218,'58bf8ae7240d4a5597bb2d7ae200e54b','volumes',-1,'2025-11-24 10:07:48',NULL),('2025-11-23 10:07:48','2025-11-23 10:07:48','2025-11-23 10:07:48',1,922,'315f9c9d-9b00-4990-b7f8-78b1fc636757',219,'58bf8ae7240d4a5597bb2d7ae200e54b','gigabytes',-2,'2025-11-24 10:07:48',NULL),('2025-11-23 10:07:48','2025-11-23 10:07:48','2025-11-23 10:07:48',1,923,'cdad9ac7-2227-455d-be2c-963f5398230c',220,'58bf8ae7240d4a5597bb2d7ae200e54b','volumes_tripleo',-1,'2025-11-24 10:07:48',NULL),('2025-11-23 10:07:48','2025-11-23 10:07:48','2025-11-23 10:07:48',1,924,'465f4184-0a33-43bb-9b6f-85073e7fae4c',221,'58bf8ae7240d4a5597bb2d7ae200e54b','gigabytes_tripleo',-2,'2025-11-24 10:07:48',NULL);
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`disabled` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`frozen` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2025-11-23 08:12:18','2025-11-23 08:49:26','2025-11-23 08:49:26',1,2,'np0005532581.localdomain','cinder-scheduler','cinder-scheduler',119,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'a628869e-77d2-4f01-84cf-a33b6eb888b1'),('2025-11-23 08:12:33','2025-11-23 08:49:29','2025-11-23 08:49:29',1,5,'np0005532583.localdomain','cinder-scheduler','cinder-scheduler',118,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'b7bec222-b8af-4286-86d4-353a1ad30fe9'),('2025-11-23 08:12:34','2025-11-23 08:49:31','2025-11-23 08:49:31',1,8,'np0005532582.localdomain','cinder-scheduler','cinder-scheduler',118,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'1a55ae34-54d8-41fc-8be8-05191d7622e9'),('2025-11-23 08:15:51','2025-11-23 08:49:20','2025-11-23 08:49:20',1,11,'np0005532581.localdomain','cinder-backup','cinder-backup',138,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'37ab612f-5155-4a24-8d36-35d0e7c6ce5b'),('2025-11-23 08:16:27','2025-11-23 10:22:04',NULL,0,14,'hostgroup@tripleo_ceph','cinder-volume','cinder-volume',687,0,'nova',NULL,NULL,'3.18','1.39','disabled',0,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d'),('2025-11-23 08:49:36','2025-11-23 10:22:02',NULL,0,17,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',553,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'e0a6884c-5db9-45ed-b26a-d26774c2a585'),('2025-11-23 08:49:42','2025-11-23 10:22:03',NULL,0,18,'cinder-backup-0','cinder-backup','cinder-backup',554,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'b492f595-0e84-4996-9b26-d1b23a47e846');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
INSERT INTO `snapshot_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `snapshot_id`, `key`, `value`) VALUES ('2025-11-23 10:02:54',NULL,'2025-11-23 10:02:58',1,1,'7fc84513-4da7-4435-ac3c-0571084c3765','snap-meta1','value1'),('2025-11-23 10:02:54',NULL,'2025-11-23 10:02:58',1,2,'7fc84513-4da7-4435-ac3c-0571084c3765','snap-meta2','value2'),('2025-11-23 10:02:54',NULL,'2025-11-23 10:02:58',1,3,'7fc84513-4da7-4435-ac3c-0571084c3765','snap-meta3','value3'),('2025-11-23 10:06:52','2025-11-23 10:06:52','2025-11-23 10:06:52',1,4,'d21cf0d3-4913-43f8-b8d6-9dc49522dd17','key1','value1'),('2025-11-23 10:06:52','2025-11-23 10:06:52','2025-11-23 10:06:52',1,5,'d21cf0d3-4913-43f8-b8d6-9dc49522dd17','key2','value2'),('2025-11-23 10:06:52','2025-11-23 10:06:52','2025-11-23 10:06:52',1,6,'d21cf0d3-4913-43f8-b8d6-9dc49522dd17','key3','value3_update'),('2025-11-23 10:06:52','2025-11-23 10:06:52','2025-11-23 10:06:52',1,7,'d21cf0d3-4913-43f8-b8d6-9dc49522dd17','key4','value4'),('2025-11-23 10:06:52','2025-11-23 10:06:52','2025-11-23 10:06:52',1,8,'d21cf0d3-4913-43f8-b8d6-9dc49522dd17','key1','value1'),('2025-11-23 10:06:52','2025-11-23 10:06:52','2025-11-23 10:06:52',1,9,'d21cf0d3-4913-43f8-b8d6-9dc49522dd17','key2','value2'),('2025-11-23 10:06:52','2025-11-23 10:06:52','2025-11-23 10:06:52',1,10,'d21cf0d3-4913-43f8-b8d6-9dc49522dd17','key3','value3_update');
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
INSERT INTO `snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `status`, `progress`, `volume_size`, `scheduled_at`, `display_name`, `display_description`, `provider_location`, `encryption_key_id`, `volume_type_id`, `cgsnapshot_id`, `provider_id`, `provider_auth`, `group_snapshot_id`, `use_quota`) VALUES ('2025-11-23 10:03:12','2025-11-23 10:03:17','2025-11-23 10:03:17',1,'2453840a-69a7-40b6-9423-3267daf42577','ed76e3db-86dc-4273-80d4-9338ac06e1f8','42ad1c0f7faa440e8fdf09af1b39a0b5','9d635cb23eed4c8795c7c085f175d605','deleted','100%',1,NULL,'tempest-group_snapshot-1498918458',NULL,NULL,NULL,'b6d595ea-8206-457d-b78d-b17b350cbea3',NULL,NULL,NULL,'85df50cf-789a-4082-9092-9ee541ab13ea',1),('2025-11-23 10:05:28','2025-11-23 10:05:31','2025-11-23 10:05:32',1,'32e669ab-4955-45d5-8ef0-f0a4087fa286','2f870218-fb0c-42a2-a6d0-df09838cfb1a','276a074587054ffaacc5b214d9c84a14','e26ac473e8284e80b775ad7fd47ae6ec','deleted','100%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-2062531464',NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,NULL,NULL,NULL,1),('2025-11-23 10:05:23','2025-11-23 10:05:40','2025-11-23 10:05:41',1,'44c773ef-d8b8-463b-a2d7-95cbf60258bd','2f870218-fb0c-42a2-a6d0-df09838cfb1a','276a074587054ffaacc5b214d9c84a14','e26ac473e8284e80b775ad7fd47ae6ec','deleted','80%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-1952120280',NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,NULL,NULL,NULL,1),('2025-11-23 10:03:07','2025-11-23 10:03:10','2025-11-23 10:03:12',1,'48b3da97-d1ac-477a-975b-c4fdce7fc248','a05cb439-a27c-4c7f-9523-e12511f3d438','d4c36ce85e40425fa6aaf111d1fdfcc4','10f8dd7c838246c58f1d2c4efc771237','deleted','100%',1,NULL,'tempest-VolumesSnapshotTestJSON-Snapshot-365315132',NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,NULL,NULL,NULL,1),('2025-11-23 10:04:31','2025-11-23 10:04:42','2025-11-23 10:04:43',1,'5a236d1c-46de-49cf-b612-9506ba1787c2','2dbad71d-292a-44bf-ad02-16767165c0d2','ba47196c60f34e139b6a0f16690cc642','307e3d5fcbc742a6b6aa246e7c8c9946','deleted','100%',1,NULL,'tempest-VolumesSnapshotListTestJSON-Snapshot-510747265',NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,NULL,NULL,NULL,1),('2025-11-23 10:03:40','2025-11-23 10:03:43','2025-11-23 10:03:43',1,'68ec89f4-ab56-445a-9872-71b8b39bfd37','f1fa255c-83a7-468f-aa9c-1f625546209b','42ad1c0f7faa440e8fdf09af1b39a0b5','9d635cb23eed4c8795c7c085f175d605','deleted','100%',1,NULL,'tempest-group_snapshot-250757580',NULL,NULL,NULL,'64fcaaaa-fa47-4bdc-a13a-bebe79570770',NULL,NULL,NULL,'88574e1d-a40d-4d3e-8301-18385cff4105',1),('2025-11-23 10:04:27','2025-11-23 10:04:29','2025-11-23 10:04:31',1,'6fa62893-9da6-49ec-bbc6-a3a5a15d37f6','b111242b-f610-497c-892c-37fd21aac679','17dbff441f8f4a61afa721f91b9c971d','bd97d43422d1434dbd778fc0c37a5566','deleted','100%',1,NULL,'tempest-VolumesExtendTest-Snapshot-1481474223',NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,NULL,NULL,NULL,1),('2025-11-23 10:04:24','2025-11-23 10:04:27','2025-11-23 10:04:28',1,'71e6b606-77d0-4a37-9ada-21ff07446727','5bf41466-bc3c-4729-b9e8-a3f6e477e95b','b5f7228b2a13453f852ea24f00659c17','0e9ab70f23134afd92115add42e46bf7','deleted','100%',1,NULL,'tempest-GroupSnapshotsV319Test-Group_Snapshot-1363132577',NULL,NULL,NULL,'3bb61f6b-350b-4406-9d79-133424e040aa',NULL,NULL,NULL,'c01cd497-71ec-4cfa-9c89-5161fc2623e8',1),('2025-11-23 10:05:33','2025-11-23 10:05:34','2025-11-23 10:05:35',1,'726f8dd4-f1b9-4bd2-8588-582b492bde1b','2f870218-fb0c-42a2-a6d0-df09838cfb1a','276a074587054ffaacc5b214d9c84a14','e26ac473e8284e80b775ad7fd47ae6ec','deleted','100%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-345000858',NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,NULL,NULL,NULL,1),('2025-11-23 10:02:54','2025-11-23 10:02:57','2025-11-23 10:02:58',1,'7fc84513-4da7-4435-ac3c-0571084c3765','d4b480ff-242c-4b3a-8ca6-2cc05a8f533e','d4c36ce85e40425fa6aaf111d1fdfcc4','10f8dd7c838246c58f1d2c4efc771237','deleted','100%',1,NULL,'tempest-VolumesSnapshotTestJSON-new-snap-1102683968','This is the new description of snapshot.',NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,NULL,NULL,NULL,1),('2025-11-23 10:06:31','2025-11-23 10:06:33','2025-11-23 10:06:40',1,'8e8c397b-6fe7-44e2-a2b4-04252df0c563','0d47d061-321c-4080-89c6-6217074c0697','1165185c7fd04092b5c02f4591a1386d','1be7eab758d64df6bb38d4ddeefb99dd','deleted','100%',1,NULL,'tempest-VolumesDeleteCascade-Snapshot-665987064',NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,NULL,NULL,NULL,1),('2025-11-23 10:02:28','2025-11-23 10:02:52','2025-11-23 10:02:54',1,'8efa68c6-fa13-4da0-9442-3d54ff185603','d4b480ff-242c-4b3a-8ca6-2cc05a8f533e','d4c36ce85e40425fa6aaf111d1fdfcc4','10f8dd7c838246c58f1d2c4efc771237','deleted','100%',1,NULL,'tempest-VolumesSnapshotTestJSON-Snapshot-1918728231',NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,NULL,NULL,NULL,1),('2025-11-23 10:03:29','2025-11-23 10:03:34','2025-11-23 10:03:34',1,'93dd3ede-1e6f-433a-9522-99882390f767','8ef120f8-d737-417b-9805-c4face11ceb4','42ad1c0f7faa440e8fdf09af1b39a0b5','9d635cb23eed4c8795c7c085f175d605','deleted','100%',1,NULL,'tempest-GroupSnapshotsTest-Group_Snapshot-238832',NULL,NULL,NULL,'e5331b89-b9ff-471f-8259-23626242497b',NULL,NULL,NULL,'04cb100a-b405-4429-bc77-e0139683d5cb',1),('2025-11-23 10:03:53','2025-11-23 10:03:55','2025-11-23 10:03:56',1,'aa572219-7b1a-4530-8656-ba18eeb1c91d','172480f8-e97d-4892-a6dc-dd8fcd94503b','1df697f169dd404786359feb1db21ebe','63f36986a4504be59f5bb7dd85b81e14','deleted','100%',1,NULL,'tempest-VolumeSnapshotQuotasNegativeTestJSON-Snapshot-1555589384',NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,NULL,NULL,NULL,1),('2025-11-23 10:04:33','2025-11-23 10:04:40','2025-11-23 10:04:41',1,'b0ce30eb-81b4-497b-ba82-6803571cd25a','2dbad71d-292a-44bf-ad02-16767165c0d2','ba47196c60f34e139b6a0f16690cc642','307e3d5fcbc742a6b6aa246e7c8c9946','deleted','100%',1,NULL,'tempest-VolumesSnapshotListTestJSON-Snapshot-1985203845',NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,NULL,NULL,NULL,1),('2025-11-23 10:02:59','2025-11-23 10:03:03','2025-11-23 10:03:04',1,'b5d49b42-0508-42cd-8cc1-7f7c3fa204c0','63f98e4b-f976-404f-a673-908d942dd644','d4c36ce85e40425fa6aaf111d1fdfcc4','10f8dd7c838246c58f1d2c4efc771237','deleted','100%',1,NULL,'tempest-VolumesSnapshotTestJSON-Snapshot-702387573',NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,NULL,NULL,NULL,1),('2025-11-23 10:05:36','2025-11-23 10:05:38','2025-11-23 10:05:39',1,'ccc29759-dd0d-41f1-b5f5-dff1423d7a26','2f870218-fb0c-42a2-a6d0-df09838cfb1a','276a074587054ffaacc5b214d9c84a14','e26ac473e8284e80b775ad7fd47ae6ec','deleted','100%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-357355216',NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,NULL,NULL,NULL,1),('2025-11-23 10:06:50','2025-11-23 10:06:52','2025-11-23 10:06:54',1,'d21cf0d3-4913-43f8-b8d6-9dc49522dd17','690aee83-f53d-46d1-b9a0-c8b5cb779e4f','1b77847c407f4e208881434bec8e637c','dd925bc8c28148ba8527b8de09a93c3c','deleted','100%',1,NULL,'tempest-SnapshotMetadataTestJSON-Snapshot-680499268',NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,NULL,NULL,NULL,1),('2025-11-23 10:03:29','2025-11-23 10:03:34','2025-11-23 10:03:34',1,'dad2c174-9ee2-40bf-97d0-78dc634792c2','d19fb26f-5b16-45b4-8d09-ceca07700fd2','42ad1c0f7faa440e8fdf09af1b39a0b5','9d635cb23eed4c8795c7c085f175d605','deleted','100%',1,NULL,'tempest-GroupSnapshotsTest-Group_Snapshot-238832',NULL,NULL,NULL,'e5331b89-b9ff-471f-8259-23626242497b',NULL,NULL,NULL,'04cb100a-b405-4429-bc77-e0139683d5cb',1),('2025-11-23 10:06:22','2025-11-23 10:06:26','2025-11-23 10:06:27',1,'e0c80c98-026b-4993-9f86-f3a4f60a70f5','9edaf508-4449-4f6d-b4b4-a187f8b1d8bd','1165185c7fd04092b5c02f4591a1386d','1be7eab758d64df6bb38d4ddeefb99dd','deleted','100%',1,NULL,'tempest-VolumesDeleteCascade-Snapshot-849407248',NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,NULL,NULL,NULL,1),('2025-11-23 10:04:35','2025-11-23 10:04:39','2025-11-23 10:04:39',1,'e7c887fd-8634-4e07-8da4-3c831a57601f','2dbad71d-292a-44bf-ad02-16767165c0d2','ba47196c60f34e139b6a0f16690cc642','307e3d5fcbc742a6b6aa246e7c8c9946','deleted','100%',1,NULL,'tempest-VolumesSnapshotListTestJSON-Snapshot-1675069511',NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,NULL,NULL,NULL,1),('2025-11-23 10:05:25','2025-11-23 10:05:27','2025-11-23 10:05:28',1,'f3b14048-516f-486d-991c-da9e7a21bc03','2f870218-fb0c-42a2-a6d0-df09838cfb1a','276a074587054ffaacc5b214d9c84a14','e26ac473e8284e80b775ad7fd47ae6ec','deleted','100%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-673535491',NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,NULL,NULL,NULL,1),('2025-11-23 10:06:24','2025-11-23 10:06:26','2025-11-23 10:06:28',1,'f4c612fa-d9ef-486d-b4eb-a1d0f53f764e','9edaf508-4449-4f6d-b4b4-a187f8b1d8bd','1165185c7fd04092b5c02f4591a1386d','1be7eab758d64df6bb38d4ddeefb99dd','deleted','100%',1,NULL,'tempest-VolumesDeleteCascade-Snapshot-1563980909',NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,NULL,NULL,NULL,1),('2025-11-23 10:07:43','2025-11-23 10:07:45','2025-11-23 10:07:46',1,'f79a1716-e799-4277-9657-a8af6a89c62e','29913788-26b0-49ee-b84f-25f6f98f7056','b97d9730069a4891aaf77ccce8c0ffa5','58bf8ae7240d4a5597bb2d7ae200e54b','deleted','100%',2,NULL,'tempest-VolumesSnapshotNegativeTestJSON-Snapshot-1684768631',NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,NULL,NULL,NULL,1);
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`no_snapshots` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
INSERT INTO `transfers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `display_name`, `salt`, `crypt_hash`, `expires_at`, `no_snapshots`, `source_project_id`, `destination_project_id`, `accepted`) VALUES ('2025-11-23 10:02:04',NULL,'2025-11-23 10:02:04',1,'2c58db36-e88a-4ffd-a9ef-695785481ec4','27fdec41-d5ec-4fd0-9621-7e8f597ab09a',NULL,'f6ef5784','ae22124fed78638e0d8aae959731562f80e99ac3',NULL,0,'b8fa70a700964960a82c255d7f038c3d',NULL,0),('2025-11-23 10:01:46',NULL,'2025-11-23 10:01:46',1,'30dbf58e-fc00-460c-952a-dedc209a3e44','7fdaf792-e977-4466-801a-c7f265d62ae1',NULL,'608edfe0','9e8decea4d4ac1dd5838fbd1137c11a27952be33',NULL,0,'9b4ff14ad14b470a96ecd244e7453fa2',NULL,0),('2025-11-23 10:06:17',NULL,'2025-11-23 10:06:17',1,'3dfa6f1e-7292-415e-8159-5ad9c3edb4df','efa9a0b5-e9e1-4fd0-8cc4-8840d9145143',NULL,'ce007229','c03af64510342a8be65638ff253f44dca79b7598',NULL,0,'34d74c1246bf4aba9b9e49e89e82cacb','8cc99762c1da46248e6ae87d4c3b549f',1),('2025-11-23 10:01:42',NULL,'2025-11-23 10:01:43',1,'631a9464-a0d0-42bb-a098-e6d88acf13dc','8ca29446-4a3c-44cc-9f01-c8cc95966815',NULL,'99e7f47b','c6d4393f34f32ec95cbe7fd9d9ec7fef547f80dd',NULL,0,'9b4ff14ad14b470a96ecd244e7453fa2','2f5ceb3dcba34969a782c4e8c5c3fe76',1),('2025-11-23 10:06:04',NULL,'2025-11-23 10:06:05',1,'a8e27f24-de1c-46c5-9b4e-efeb8ee72144','4da885cf-2c34-44bd-8222-8bb3aee7ff39',NULL,'0155b2c6','12b9271eec996a4de86cf17c2ff6413f896b6e13',NULL,0,'4e886bd382154b9ba842be63cef3b094','250d505f169f42eaa1d45ef735f6b254',1),('2025-11-23 10:06:20',NULL,'2025-11-23 10:06:20',1,'e1a4e791-14d7-4ae0-abe2-9ecdc3f5030b','218ab436-b58f-4c97-b920-73378860994a',NULL,'a69b91b0','4a78bb9c5dd7caedd59fa16abc897404a6451b64',NULL,0,'34d74c1246bf4aba9b9e49e89e82cacb',NULL,0),('2025-11-23 10:02:01',NULL,'2025-11-23 10:02:01',1,'f8ab76f5-f263-4bf4-a08e-9eff33bfbd42','61a874c3-00cf-47cd-9001-27eca1150703',NULL,'e71e8df6','cd68054b6e60b25ed397ce21ea8228f35a6bdfde',NULL,0,'b8fa70a700964960a82c255d7f038c3d','4b84b07fc6534e88860c454382c4f9f4',1);
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
INSERT INTO `volume_admin_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `key`, `value`) VALUES ('2025-11-23 10:02:30',NULL,'2025-11-23 10:02:50',1,1,'400ddc91-ec44-420d-8c35-8b7027101fa7','temporary','True'),('2025-11-23 10:06:35','2025-11-23 10:06:35','2025-11-23 10:07:24',1,2,'4ca38ec4-1d0d-4276-a35b-91f6052b806a','readonly','False');
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
INSERT INTO `volume_attachment` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `attached_host`, `instance_uuid`, `mountpoint`, `attach_time`, `detach_time`, `attach_mode`, `attach_status`, `connection_info`, `connector`) VALUES ('2025-11-23 10:04:16','2025-11-23 10:04:36','2025-11-23 10:04:36',1,'ab06789a-87b2-4134-b3fc-2d8944f18c88','e6dcaf3a-9826-4f4a-99ce-65fb52624d71','np0005532586.localdomain','0878698a-ffc9-486f-96bf-d5a905dca1b1','/dev/vdb','2025-11-23 10:04:18','2025-11-23 10:04:36','rw','detached','{\"name\": \"volumes/volume-e6dcaf3a-9826-4f4a-99ce-65fb52624d71\", \"hosts\": [\"172.18.0.103\", \"172.18.0.104\", \"172.18.0.105\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"46550e70-79cb-5f55-bf6d-1204b97e083b\", \"volume_id\": \"e6dcaf3a-9826-4f4a-99ce-65fb52624d71\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"ab06789a-87b2-4134-b3fc-2d8944f18c88\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.108\", \"host\": \"np0005532586.localdomain\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:2e1a82caa\", \"do_local_attach\": false, \"nvme_hostid\": \"94eff25b-7070-4dc8-8cfe-491426a98db3\", \"system uuid\": \"94eff25b-7070-4dc8-8cfe-491426a98db3\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:94eff25b-7070-4dc8-8cfe-491426a98db3\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}');
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
INSERT INTO `volume_glance_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `snapshot_id`, `key`, `value`) VALUES ('2025-11-23 10:01:25',NULL,'2025-11-23 10:01:30',1,1,'2dcd814a-05df-4c5c-a250-0ae9dc18c81d',NULL,'signature_verified','False'),('2025-11-23 10:01:29',NULL,'2025-11-23 10:01:30',1,2,'2dcd814a-05df-4c5c-a250-0ae9dc18c81d',NULL,'hw_rng_model','virtio'),('2025-11-23 10:01:29','2025-11-23 10:01:29','2025-11-23 10:01:30',1,3,'2dcd814a-05df-4c5c-a250-0ae9dc18c81d',NULL,'image_id','5137a025-3c5f-43c1-bc64-5f41270040a5'),('2025-11-23 10:01:29','2025-11-23 10:01:29','2025-11-23 10:01:30',1,4,'2dcd814a-05df-4c5c-a250-0ae9dc18c81d',NULL,'image_name','image'),('2025-11-23 10:01:29',NULL,'2025-11-23 10:01:30',1,5,'2dcd814a-05df-4c5c-a250-0ae9dc18c81d',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-23 10:01:29',NULL,'2025-11-23 10:01:30',1,6,'2dcd814a-05df-4c5c-a250-0ae9dc18c81d',NULL,'container_format','bare'),('2025-11-23 10:01:29',NULL,'2025-11-23 10:01:30',1,7,'2dcd814a-05df-4c5c-a250-0ae9dc18c81d',NULL,'disk_format','qcow2'),('2025-11-23 10:01:29',NULL,'2025-11-23 10:01:30',1,8,'2dcd814a-05df-4c5c-a250-0ae9dc18c81d',NULL,'min_disk','0'),('2025-11-23 10:01:29',NULL,'2025-11-23 10:01:30',1,9,'2dcd814a-05df-4c5c-a250-0ae9dc18c81d',NULL,'min_ram','0'),('2025-11-23 10:01:29',NULL,'2025-11-23 10:01:30',1,10,'2dcd814a-05df-4c5c-a250-0ae9dc18c81d',NULL,'size','21430272'),('2025-11-23 10:01:29',NULL,'2025-11-23 10:01:30',1,11,'2dcd814a-05df-4c5c-a250-0ae9dc18c81d',NULL,'kernel_id','6ff710d2-942b-4d6b-9168-8c9cc2404ab1'),('2025-11-23 10:01:29',NULL,'2025-11-23 10:01:30',1,12,'2dcd814a-05df-4c5c-a250-0ae9dc18c81d',NULL,'ramdisk_id','somedisk'),('2025-11-23 10:03:20',NULL,'2025-11-23 10:03:39',1,13,'5f882947-d542-4b3a-8f9a-d78d3d24e31e',NULL,'signature_verified','False'),('2025-11-23 10:03:24',NULL,'2025-11-23 10:03:39',1,14,'5f882947-d542-4b3a-8f9a-d78d3d24e31e',NULL,'hw_rng_model','virtio'),('2025-11-23 10:03:24',NULL,'2025-11-23 10:03:39',1,15,'5f882947-d542-4b3a-8f9a-d78d3d24e31e',NULL,'image_id','c5806483-57a8-4254-b41b-254b888c8606'),('2025-11-23 10:03:24',NULL,'2025-11-23 10:03:39',1,16,'5f882947-d542-4b3a-8f9a-d78d3d24e31e',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-23 10:03:24',NULL,'2025-11-23 10:03:39',1,17,'5f882947-d542-4b3a-8f9a-d78d3d24e31e',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-23 10:03:24',NULL,'2025-11-23 10:03:39',1,18,'5f882947-d542-4b3a-8f9a-d78d3d24e31e',NULL,'container_format','bare'),('2025-11-23 10:03:24',NULL,'2025-11-23 10:03:39',1,19,'5f882947-d542-4b3a-8f9a-d78d3d24e31e',NULL,'disk_format','qcow2'),('2025-11-23 10:03:24',NULL,'2025-11-23 10:03:39',1,20,'5f882947-d542-4b3a-8f9a-d78d3d24e31e',NULL,'min_disk','0'),('2025-11-23 10:03:24',NULL,'2025-11-23 10:03:39',1,21,'5f882947-d542-4b3a-8f9a-d78d3d24e31e',NULL,'min_ram','0'),('2025-11-23 10:03:24',NULL,'2025-11-23 10:03:39',1,22,'5f882947-d542-4b3a-8f9a-d78d3d24e31e',NULL,'size','21430272'),('2025-11-23 10:03:33',NULL,'2025-11-23 10:03:35',1,23,'a01af78e-65b1-4be5-93ac-056bedd54cb6',NULL,'signature_verified','False'),('2025-11-23 10:03:33',NULL,'2025-11-23 10:03:35',1,24,'a01af78e-65b1-4be5-93ac-056bedd54cb6',NULL,'hw_rng_model','virtio'),('2025-11-23 10:03:33',NULL,'2025-11-23 10:03:35',1,25,'a01af78e-65b1-4be5-93ac-056bedd54cb6',NULL,'image_id','c5806483-57a8-4254-b41b-254b888c8606'),('2025-11-23 10:03:33',NULL,'2025-11-23 10:03:35',1,26,'a01af78e-65b1-4be5-93ac-056bedd54cb6',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-23 10:03:33',NULL,'2025-11-23 10:03:35',1,27,'a01af78e-65b1-4be5-93ac-056bedd54cb6',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-23 10:03:33',NULL,'2025-11-23 10:03:35',1,28,'a01af78e-65b1-4be5-93ac-056bedd54cb6',NULL,'container_format','bare'),('2025-11-23 10:03:33',NULL,'2025-11-23 10:03:35',1,29,'a01af78e-65b1-4be5-93ac-056bedd54cb6',NULL,'disk_format','qcow2'),('2025-11-23 10:03:33',NULL,'2025-11-23 10:03:35',1,30,'a01af78e-65b1-4be5-93ac-056bedd54cb6',NULL,'min_disk','0'),('2025-11-23 10:03:33',NULL,'2025-11-23 10:03:35',1,31,'a01af78e-65b1-4be5-93ac-056bedd54cb6',NULL,'min_ram','0'),('2025-11-23 10:03:33',NULL,'2025-11-23 10:03:35',1,32,'a01af78e-65b1-4be5-93ac-056bedd54cb6',NULL,'size','21430272'),('2025-11-23 10:04:19',NULL,'2025-11-23 10:04:25',1,33,'ddbbb316-3050-469f-87c1-0a1a03b6daee',NULL,'signature_verified','False'),('2025-11-23 10:04:23',NULL,'2025-11-23 10:04:25',1,34,'ddbbb316-3050-469f-87c1-0a1a03b6daee',NULL,'hw_rng_model','virtio'),('2025-11-23 10:04:23',NULL,'2025-11-23 10:04:25',1,35,'ddbbb316-3050-469f-87c1-0a1a03b6daee',NULL,'image_id','c5806483-57a8-4254-b41b-254b888c8606'),('2025-11-23 10:04:23',NULL,'2025-11-23 10:04:25',1,36,'ddbbb316-3050-469f-87c1-0a1a03b6daee',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-23 10:04:23',NULL,'2025-11-23 10:04:25',1,37,'ddbbb316-3050-469f-87c1-0a1a03b6daee',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-23 10:04:23',NULL,'2025-11-23 10:04:25',1,38,'ddbbb316-3050-469f-87c1-0a1a03b6daee',NULL,'container_format','bare'),('2025-11-23 10:04:23',NULL,'2025-11-23 10:04:25',1,39,'ddbbb316-3050-469f-87c1-0a1a03b6daee',NULL,'disk_format','qcow2'),('2025-11-23 10:04:23',NULL,'2025-11-23 10:04:25',1,40,'ddbbb316-3050-469f-87c1-0a1a03b6daee',NULL,'min_disk','0'),('2025-11-23 10:04:23',NULL,'2025-11-23 10:04:25',1,41,'ddbbb316-3050-469f-87c1-0a1a03b6daee',NULL,'min_ram','0'),('2025-11-23 10:04:23',NULL,'2025-11-23 10:04:25',1,42,'ddbbb316-3050-469f-87c1-0a1a03b6daee',NULL,'size','21430272'),('2025-11-23 10:05:00',NULL,'2025-11-23 10:05:09',1,43,'bb2e788c-6184-48c6-b0a2-9093e6fd3a19',NULL,'signature_verified','False'),('2025-11-23 10:05:03',NULL,'2025-11-23 10:05:09',1,44,'bb2e788c-6184-48c6-b0a2-9093e6fd3a19',NULL,'hw_rng_model','virtio'),('2025-11-23 10:05:03',NULL,'2025-11-23 10:05:09',1,45,'bb2e788c-6184-48c6-b0a2-9093e6fd3a19',NULL,'image_id','c5806483-57a8-4254-b41b-254b888c8606'),('2025-11-23 10:05:03',NULL,'2025-11-23 10:05:09',1,46,'bb2e788c-6184-48c6-b0a2-9093e6fd3a19',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-23 10:05:03',NULL,'2025-11-23 10:05:09',1,47,'bb2e788c-6184-48c6-b0a2-9093e6fd3a19',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-23 10:05:03',NULL,'2025-11-23 10:05:09',1,48,'bb2e788c-6184-48c6-b0a2-9093e6fd3a19',NULL,'container_format','bare'),('2025-11-23 10:05:03',NULL,'2025-11-23 10:05:09',1,49,'bb2e788c-6184-48c6-b0a2-9093e6fd3a19',NULL,'disk_format','qcow2'),('2025-11-23 10:05:03',NULL,'2025-11-23 10:05:09',1,50,'bb2e788c-6184-48c6-b0a2-9093e6fd3a19',NULL,'min_disk','0'),('2025-11-23 10:05:03',NULL,'2025-11-23 10:05:09',1,51,'bb2e788c-6184-48c6-b0a2-9093e6fd3a19',NULL,'min_ram','0'),('2025-11-23 10:05:03',NULL,'2025-11-23 10:05:09',1,52,'bb2e788c-6184-48c6-b0a2-9093e6fd3a19',NULL,'size','21430272'),('2025-11-23 10:05:06',NULL,'2025-11-23 10:05:08',1,53,'bac0139f-864e-457c-ae6d-50523f07308f',NULL,'signature_verified','False'),('2025-11-23 10:05:06',NULL,'2025-11-23 10:05:08',1,54,'bac0139f-864e-457c-ae6d-50523f07308f',NULL,'hw_rng_model','virtio'),('2025-11-23 10:05:06',NULL,'2025-11-23 10:05:08',1,55,'bac0139f-864e-457c-ae6d-50523f07308f',NULL,'image_id','c5806483-57a8-4254-b41b-254b888c8606'),('2025-11-23 10:05:06',NULL,'2025-11-23 10:05:08',1,56,'bac0139f-864e-457c-ae6d-50523f07308f',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-23 10:05:06',NULL,'2025-11-23 10:05:08',1,57,'bac0139f-864e-457c-ae6d-50523f07308f',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-23 10:05:06',NULL,'2025-11-23 10:05:08',1,58,'bac0139f-864e-457c-ae6d-50523f07308f',NULL,'container_format','bare'),('2025-11-23 10:05:06',NULL,'2025-11-23 10:05:08',1,59,'bac0139f-864e-457c-ae6d-50523f07308f',NULL,'disk_format','qcow2'),('2025-11-23 10:05:06',NULL,'2025-11-23 10:05:08',1,60,'bac0139f-864e-457c-ae6d-50523f07308f',NULL,'min_disk','0'),('2025-11-23 10:05:06',NULL,'2025-11-23 10:05:08',1,61,'bac0139f-864e-457c-ae6d-50523f07308f',NULL,'min_ram','0'),('2025-11-23 10:05:06',NULL,'2025-11-23 10:05:08',1,62,'bac0139f-864e-457c-ae6d-50523f07308f',NULL,'size','21430272'),('2025-11-23 10:07:15',NULL,'2025-11-23 10:07:24',1,63,'01d55290-bd74-46de-bb1c-70ab42341593',NULL,'signature_verified','False'),('2025-11-23 10:07:21',NULL,'2025-11-23 10:07:24',1,64,'01d55290-bd74-46de-bb1c-70ab42341593',NULL,'hw_rng_model','virtio'),('2025-11-23 10:07:21',NULL,'2025-11-23 10:07:24',1,65,'01d55290-bd74-46de-bb1c-70ab42341593',NULL,'image_id','c5806483-57a8-4254-b41b-254b888c8606'),('2025-11-23 10:07:21',NULL,'2025-11-23 10:07:24',1,66,'01d55290-bd74-46de-bb1c-70ab42341593',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-23 10:07:21',NULL,'2025-11-23 10:07:24',1,67,'01d55290-bd74-46de-bb1c-70ab42341593',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-23 10:07:21',NULL,'2025-11-23 10:07:24',1,68,'01d55290-bd74-46de-bb1c-70ab42341593',NULL,'container_format','bare'),('2025-11-23 10:07:21',NULL,'2025-11-23 10:07:24',1,69,'01d55290-bd74-46de-bb1c-70ab42341593',NULL,'disk_format','qcow2'),('2025-11-23 10:07:21',NULL,'2025-11-23 10:07:24',1,70,'01d55290-bd74-46de-bb1c-70ab42341593',NULL,'min_disk','0'),('2025-11-23 10:07:21',NULL,'2025-11-23 10:07:24',1,71,'01d55290-bd74-46de-bb1c-70ab42341593',NULL,'min_ram','0'),('2025-11-23 10:07:21',NULL,'2025-11-23 10:07:24',1,72,'01d55290-bd74-46de-bb1c-70ab42341593',NULL,'size','21430272');
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
INSERT INTO `volume_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `key`, `value`) VALUES ('2025-11-23 10:03:33',NULL,'2025-11-23 10:03:35',1,1,'a01af78e-65b1-4be5-93ac-056bedd54cb6','src_backup_id','bf5bed0f-d12a-4564-a4c8-bc89fe0ec866'),('2025-11-23 10:06:07','2025-11-23 10:06:07','2025-11-23 10:06:07',1,2,'07f1b449-7a1d-48b0-9204-5197f99c643c','key1','value1_update'),('2025-11-23 10:06:07','2025-11-23 10:06:07','2025-11-23 10:06:07',1,3,'07f1b449-7a1d-48b0-9204-5197f99c643c','key2','value2'),('2025-11-23 10:06:07','2025-11-23 10:06:07','2025-11-23 10:06:07',1,4,'07f1b449-7a1d-48b0-9204-5197f99c643c','key3','value3'),('2025-11-23 10:06:07','2025-11-23 10:06:07','2025-11-23 10:06:07',1,5,'07f1b449-7a1d-48b0-9204-5197f99c643c','key4','value4'),('2025-11-23 10:06:07','2025-11-23 10:06:07','2025-11-23 10:06:07',1,6,'07f1b449-7a1d-48b0-9204-5197f99c643c','key1','value1'),('2025-11-23 10:06:07','2025-11-23 10:06:07','2025-11-23 10:06:07',1,7,'07f1b449-7a1d-48b0-9204-5197f99c643c','key2','value2'),('2025-11-23 10:06:07','2025-11-23 10:06:07','2025-11-23 10:06:07',1,8,'07f1b449-7a1d-48b0-9204-5197f99c643c','key3','value3_update'),('2025-11-23 10:06:25',NULL,'2025-11-23 10:06:28',1,9,'127eaf85-61a7-4a0c-b7e3-6d748c351ac2','src_backup_id','cc439e4f-3862-4cbe-80f3-b219d32ede61'),('2025-11-23 10:06:58',NULL,'2025-11-23 10:07:03',1,10,'4e71ed6a-bfb6-45c8-bdf7-539c2c95847e','Type','Test'),('2025-11-23 10:07:05',NULL,'2025-11-23 10:07:11',1,11,'6e436092-75a0-405a-88eb-66606701b85c','Type','Test'),('2025-11-23 10:07:14',NULL,'2025-11-23 10:07:24',1,12,'01d55290-bd74-46de-bb1c-70ab42341593','Type','Test'),('2025-11-23 10:07:28',NULL,'2025-11-23 10:07:37',1,13,'25a12535-0492-498a-8674-220aef0c3cde','Type','work'),('2025-11-23 10:07:29',NULL,'2025-11-23 10:07:35',1,14,'8c8b8bd8-5768-4f7e-9705-066f719d7593','Type','work'),('2025-11-23 10:07:31',NULL,'2025-11-23 10:07:34',1,15,'9f0dde51-b281-44b1-8bbb-adcd4a7f1833','Type','work');
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
INSERT INTO `volume_type_extra_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_type_id`, `key`, `value`) VALUES ('2025-11-23 10:03:56',NULL,'2025-11-23 10:03:56',1,1,'dc177af0-0263-407b-941c-e0ee12bcaa9c','storage_protocol','iSCSI'),('2025-11-23 10:03:56',NULL,'2025-11-23 10:03:56',1,2,'dc177af0-0263-407b-941c-e0ee12bcaa9c','vendor_name','Open Source'),('2025-11-23 10:04:05',NULL,'2025-11-23 10:04:05',1,3,'f48409b3-d644-4819-84ad-cf34ae90d5f6','spec1','val1'),('2025-11-23 10:04:45',NULL,'2025-11-23 10:04:45',1,4,'1faa792c-9530-4c54-8764-496d57679aa8','spec3','val1'),('2025-11-23 10:04:46',NULL,'2025-11-23 10:04:46',1,5,'1faa792c-9530-4c54-8764-496d57679aa8','spec1','val1'),('2025-11-23 10:04:46','2025-11-23 10:04:46','2025-11-23 10:04:46',1,6,'1faa792c-9530-4c54-8764-496d57679aa8','spec2','val3'),('2025-11-23 10:04:46',NULL,'2025-11-23 10:04:46',1,7,'1faa792c-9530-4c54-8764-496d57679aa8','spec4','val4'),('2025-11-23 10:05:49',NULL,'2025-11-23 10:05:51',1,8,'802fec99-acaa-4a55-b858-406ee4d970f3','storage_protocol','tempest-storage_protocol-582765851'),('2025-11-23 10:05:49',NULL,'2025-11-23 10:05:51',1,9,'802fec99-acaa-4a55-b858-406ee4d970f3','vendor_name','tempest-vendor_name-279145220'),('2025-11-23 10:05:51',NULL,'2025-11-23 10:05:53',1,10,'a250c9b2-d39f-40cc-83b9-c0d31f2e57f3','storage_protocol','tempest-storage_protocol-1166719465'),('2025-11-23 10:05:51',NULL,'2025-11-23 10:05:53',1,11,'a250c9b2-d39f-40cc-83b9-c0d31f2e57f3','vendor_name','tempest-vendor_name-1659943901');
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
INSERT INTO `volume_type_projects` (`id`, `created_at`, `updated_at`, `deleted_at`, `volume_type_id`, `project_id`, `deleted`) VALUES (1,'2025-11-23 10:06:06',NULL,'2025-11-23 10:06:09','26319d65-0a56-4773-a14b-9a1b3d98a716','eefb55b5a7ba44a99cf8b53d39954004',1),(2,'2025-11-23 10:06:09',NULL,'2025-11-23 10:06:09','87440a78-0d09-42c9-a47e-3b238fd94f79','eefb55b5a7ba44a99cf8b53d39954004',2),(3,'2025-11-23 10:06:09',NULL,'2025-11-23 10:06:09','87440a78-0d09-42c9-a47e-3b238fd94f79','e57188b9d4f148949cc2ff15784816fd',3);
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`is_public` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2025-11-23 10:04:06',NULL,'2025-11-23 10:04:06',1,'107d1704-3539-47aa-86bc-b2af8c9a6adc','tempest-VolumeTypesNegativeTest-volume-type-1868382965',NULL,0,NULL),('2025-11-23 10:04:45',NULL,'2025-11-23 10:04:46',1,'1faa792c-9530-4c54-8764-496d57679aa8','tempest-VolumeTypesExtraSpecsTest-volume-type-2064019276',NULL,1,NULL),('2025-11-23 10:06:06',NULL,'2025-11-23 10:06:09',1,'26319d65-0a56-4773-a14b-9a1b3d98a716','tempest-VolumeTypesAccessTest-volume-type-749306444',NULL,0,NULL),('2025-11-23 10:04:21',NULL,'2025-11-23 10:04:29',1,'3bb61f6b-350b-4406-9d79-133424e040aa','tempest-GroupSnapshotsV319Test-volume-type-1099039626',NULL,1,NULL),('2025-11-23 10:05:27',NULL,'2025-11-23 10:05:34',1,'56da7e66-b2db-4f63-a5a8-67002badaafc','tempest-GroupsTest-volume-type-1960407744',NULL,1,NULL),('2025-11-23 10:01:05',NULL,'2025-11-23 10:01:11',1,'6084b0c9-5419-4c06-8f18-577359b260be','volume-type-2',NULL,1,NULL),('2025-11-23 10:03:38',NULL,'2025-11-23 10:03:44',1,'64fcaaaa-fa47-4bdc-a13a-bebe79570770','tempest-GroupSnapshotsTest-volume-type-1243502470',NULL,1,NULL),('2025-11-23 10:02:26',NULL,'2025-11-23 10:02:26',1,'6d020c22-00ad-40b7-b147-2403da390ea3','tempest-VolumeQuotaClassesTest-volume-type-1678906391',NULL,1,NULL),('2025-11-23 10:03:57','2025-11-23 10:03:57','2025-11-23 10:03:57',1,'72ed2a14-e8d3-4151-b80f-7d02e24b7309','tempest-volume-type-751518218',NULL,0,'tempest-volume-type-description-2064533987'),('2025-11-23 08:15:09',NULL,NULL,0,'771bddfa-6ad8-421a-8097-6c694bc403f1','tripleo',NULL,1,NULL),('2025-11-23 10:05:49',NULL,'2025-11-23 10:05:51',1,'802fec99-acaa-4a55-b858-406ee4d970f3','tempest-UserMessagesTest-volume-type-1721981474',NULL,1,NULL),('2025-11-23 10:05:34',NULL,'2025-11-23 10:05:44',1,'857a0579-6ba7-4353-8484-fb744288604e','tempest-GroupsTest-volume-type-1184049508',NULL,1,NULL),('2025-11-23 10:06:09',NULL,'2025-11-23 10:06:09',1,'87440a78-0d09-42c9-a47e-3b238fd94f79','tempest-VolumeTypesAccessTest-volume-type-614241707',NULL,0,NULL),('2025-11-23 10:03:56',NULL,'2025-11-23 10:03:57',1,'92c65fbb-350f-45b0-895e-1d3a6376fa47','tempest-VolumeTypesTest-volume-type-1679555371',NULL,1,NULL),('2025-11-23 10:01:05',NULL,'2025-11-23 10:01:11',1,'95b6ed44-f160-4951-bc28-74e9afa89c0b','volume-type-1',NULL,1,NULL),('2025-11-23 10:05:49',NULL,'2025-11-23 10:05:52',1,'a0a52c33-ec19-41e6-bcc0-1611745a9b22','tempest-GroupsV320Test-volume-type-1392468880',NULL,1,NULL),('2025-11-23 10:05:51',NULL,'2025-11-23 10:05:53',1,'a250c9b2-d39f-40cc-83b9-c0d31f2e57f3','tempest-UserMessagesTest-volume-type-2124842120',NULL,1,NULL),('2025-11-23 10:05:14','2025-11-23 10:05:15','2025-11-23 10:05:15',1,'a561f7ea-b9bb-4110-8eed-41c1daac34e8','tempest-QosSpecsTestJSON-volume-type-1537658745',NULL,1,NULL),('2025-11-23 10:04:06',NULL,'2025-11-23 10:04:06',1,'a8bfe451-086b-4d30-8eb0-386c8ae36e38','tempest-VolumeTypesNegativeTest-volume-type-1967946621',NULL,1,NULL),('2025-11-23 10:03:09',NULL,'2025-11-23 10:03:20',1,'b6d595ea-8206-457d-b78d-b17b350cbea3','tempest-GroupSnapshotsTest-volume-type-1819188790',NULL,1,NULL),('2025-11-23 10:05:14','2025-11-23 10:05:15','2025-11-23 10:05:15',1,'d4eefaed-09d1-48c1-9f13-4bd42a378f85','tempest-QosSpecsTestJSON-volume-type-986217054',NULL,1,NULL),('2025-11-23 08:07:41','2025-11-23 08:07:41','2025-11-23 08:15:14',1,'d5fc34a2-fff5-497e-bde9-ce0660914f62','__DEFAULT__',NULL,1,'Default Volume Type'),('2025-11-23 10:05:14','2025-11-23 10:05:15','2025-11-23 10:05:15',1,'d6350781-8181-430f-ad74-e18fb80bc4c8','tempest-QosSpecsTestJSON-volume-type-748840005',NULL,1,NULL),('2025-11-23 10:03:56',NULL,'2025-11-23 10:03:56',1,'dc177af0-0263-407b-941c-e0ee12bcaa9c','tempest-VolumeTypesTest-volume-type-143607131',NULL,1,'tempest-volume-type-description-1713745919'),('2025-11-23 10:03:20',NULL,'2025-11-23 10:03:38',1,'e5331b89-b9ff-471f-8259-23626242497b','tempest-GroupSnapshotsTest-volume-type-175069716',NULL,1,NULL),('2025-11-23 10:05:42',NULL,'2025-11-23 10:05:50',1,'ef286d9e-549a-4844-9f5d-93ebf87512fc','tempest-GroupsV314Test-volume-type-1357687760',NULL,1,NULL),('2025-11-23 10:04:05',NULL,'2025-11-23 10:04:05',1,'f48409b3-d644-4819-84ad-cf34ae90d5f6','tempest-ExtraSpecsNegativeTest-volume-type-70224587',NULL,1,NULL);
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`bootable` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`multiattach` in (0,1)),
  CONSTRAINT `CONSTRAINT_4` CHECK (`shared_targets` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
INSERT INTO `volumes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `ec2_id`, `user_id`, `project_id`, `host`, `size`, `availability_zone`, `status`, `attach_status`, `scheduled_at`, `launched_at`, `terminated_at`, `display_name`, `display_description`, `provider_location`, `provider_auth`, `snapshot_id`, `volume_type_id`, `source_volid`, `bootable`, `provider_geometry`, `_name_id`, `encryption_key_id`, `migration_status`, `replication_status`, `replication_extended_status`, `replication_driver_data`, `consistencygroup_id`, `provider_id`, `multiattach`, `previous_status`, `cluster_name`, `group_id`, `service_uuid`, `shared_targets`, `use_quota`) VALUES ('2025-11-23 10:01:06','2025-11-23 10:01:10','2025-11-23 10:01:11',1,'01283db7-4627-4cdc-a85a-4b42ad460de6',NULL,'6adf6361155e40c09d8d1bc2578544ca','22b5d1ffb22c47428f71809e862e842f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:01:06','2025-11-23 10:01:07','2025-11-23 10:01:10','tempest-VolumeRetypeWithoutMigrationTest-Volume-1074590432',NULL,NULL,NULL,NULL,'6084b0c9-5419-4c06-8f18-577359b260be',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:07:14','2025-11-23 10:07:24','2025-11-23 10:07:24',1,'01d55290-bd74-46de-bb1c-70ab42341593',NULL,'aa226a7988cb445f88f27b4371eb193a','acf2d5195bde4e69ba34cd2a2c03e717','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:07:14','2025-11-23 10:07:21','2025-11-23 10:07:24','tempest-VolumesGetTest-new-Volume-1832721324','This is the new description of volume',NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:06:16','2025-11-23 10:06:29','2025-11-23 10:06:31',1,'04bb848a-9b13-4ca5-884f-90a1f2277533',NULL,'64e7d06fed5b4041b603f81a8b352e85','141ccb7a18aa4552b64b95f2b6f47c17','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:06:16','2025-11-23 10:06:16','2025-11-23 10:06:29','tempest-VolumesBackupsAdminTest-Volume-1535576639',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:05:14','2025-11-23 10:05:16','2025-11-23 10:05:16',1,'06bd5a82-6f4a-4c76-a12f-4f33eb8094f0',NULL,'1b96f945d5154f44ac4029db9b2f0807','ba426e81cfe149da986575955289d04b','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:05:14','2025-11-23 10:05:15','2025-11-23 10:05:16','tempest-VolumesActionsTest-Volume-2097272067',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:06:05','2025-11-23 10:06:07','2025-11-23 10:06:08',1,'07f1b449-7a1d-48b0-9204-5197f99c643c',NULL,'3b95ab8759f44a2fb1ab5b0802b4ea90','10f6dfd6b1684628bd2dfc266a69e68a','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:06:05','2025-11-23 10:06:06','2025-11-23 10:06:07','tempest-VolumesMetadataTest-Volume-1850547865',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:05:36','2025-11-23 10:05:43','2025-11-23 10:05:43',1,'0abc435c-d6a8-4896-b9b9-70647d814c81',NULL,'62451c91e4c24f0fb36b26f84bd3bfc4','fb2fe4c3f84642bbad40631e42e594dd','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:05:36','2025-11-23 10:05:36',NULL,'tempest-volume-580973245',NULL,NULL,NULL,NULL,'857a0579-6ba7-4353-8484-fb744288604e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'d0356f68-2797-4515-9e7d-5750badc3e61','8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:05:46','2025-11-23 10:05:48','2025-11-23 10:05:48',1,'0bf9535d-2ee7-499c-abd2-bc1738b55657',NULL,'df30e9d95de942da9333c6d01dd52576','b26c9bed083447548be26f4feb5dd112','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'ef286d9e-549a-4844-9f5d-93ebf87512fc','f0af0bd4-1cf6-4601-8951-98a0a69040f8',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'a28d6779-89c6-402b-8c4e-0372b634153f',NULL,1,1),('2025-11-23 10:06:30','2025-11-23 10:06:33','2025-11-23 10:06:41',1,'0d47d061-321c-4080-89c6-6217074c0697',NULL,'1165185c7fd04092b5c02f4591a1386d','1be7eab758d64df6bb38d4ddeefb99dd','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:06:30','2025-11-23 10:06:30','2025-11-23 10:06:33','tempest-VolumesDeleteCascade-Volume-135714264',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:05:11','2025-11-23 10:05:13','2025-11-23 10:05:14',1,'0d8bc1cd-64da-47e4-a212-7c9e11b13040',NULL,'a626db0453f04b28a39df197c856d926','e456b00c470e4f58a0cb2eb0ed097106','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-11-23 10:05:11','2025-11-23 10:05:13','2025-11-23 10:05:13','tempest-VolumesCloneTest-Volume-97887327',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1','4cf88075-db76-4047-a834-4f76fb2b4f84',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:06:22','2025-11-23 10:06:27','2025-11-23 10:06:28',1,'127eaf85-61a7-4a0c-b7e3-6d748c351ac2',NULL,'64e7d06fed5b4041b603f81a8b352e85','141ccb7a18aa4552b64b95f2b6f47c17','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:06:22','2025-11-23 10:06:23','2025-11-23 10:06:27','tempest-VolumesBackupsAdminTest-Volume-1535576639',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:05:20','2025-11-23 10:05:21','2025-11-23 10:05:22',1,'169cc19b-d617-4439-a9dc-ccb5c7568472',NULL,'1b96f945d5154f44ac4029db9b2f0807','ba426e81cfe149da986575955289d04b','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:05:20','2025-11-23 10:05:20','2025-11-23 10:05:21','tempest-VolumesActionsTest-Volume-1214286173',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:03:52','2025-11-23 10:03:56','2025-11-23 10:03:57',1,'172480f8-e97d-4892-a6dc-dd8fcd94503b',NULL,'1df697f169dd404786359feb1db21ebe','63f36986a4504be59f5bb7dd85b81e14','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:03:52','2025-11-23 10:03:52','2025-11-23 10:03:56','tempest-VolumeSnapshotQuotasNegativeTestJSON-Volume-986005364',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:02:49','2025-11-23 10:02:52','2025-11-23 10:02:53',1,'1c128d57-1fc5-4a88-8fbb-c36c96f6d8ae',NULL,'6824f1a2f1204c02a41cb29fe915f850','6d43b7d88e884e6d87abed93a63f5ca0','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:02:49','2025-11-23 10:02:49','2025-11-23 10:02:52','tempest-VolumesListAdminTestJSON-Volume-821639979',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:06:31','2025-11-23 10:06:38','2025-11-23 10:06:40',1,'204d655f-515d-4e87-acb6-27a562b76d94',NULL,'64e7d06fed5b4041b603f81a8b352e85','141ccb7a18aa4552b64b95f2b6f47c17','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:06:31','2025-11-23 10:06:32','2025-11-23 10:06:38','tempest-VolumesBackupsAdminTest-Volume-1131404352',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:06:19','2025-11-23 10:06:21','2025-11-23 10:06:21',1,'218ab436-b58f-4c97-b920-73378860994a',NULL,'20124ae5f4ed4a96b55dc4f1ca24a945','34d74c1246bf4aba9b9e49e89e82cacb','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:06:19','2025-11-23 10:06:19','2025-11-23 10:06:21','tempest-VolumesTransfersTest-Volume-1783254945',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:03:08','2025-11-23 10:03:09','2025-11-23 10:03:10',1,'21e432c1-2348-4907-a78f-6fea726cf1ea',NULL,'d4c36ce85e40425fa6aaf111d1fdfcc4','10f8dd7c838246c58f1d2c4efc771237','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:03:08','2025-11-23 10:03:08','2025-11-23 10:03:09','tempest-VolumesSnapshotTestJSON-Volume-1778848145',NULL,NULL,NULL,'48b3da97-d1ac-477a-975b-c4fdce7fc248','771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:05:37','2025-11-23 10:05:43','2025-11-23 10:05:43',1,'2436d2b4-d2d4-4a73-a40c-3f3a85d3b6dd',NULL,'62451c91e4c24f0fb36b26f84bd3bfc4','fb2fe4c3f84642bbad40631e42e594dd','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:05:37','2025-11-23 10:05:37',NULL,'tempest-volume-177191682',NULL,NULL,NULL,NULL,'857a0579-6ba7-4353-8484-fb744288604e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'d0356f68-2797-4515-9e7d-5750badc3e61','8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:06:14','2025-11-23 10:06:16','2025-11-23 10:06:16',1,'24a30db8-fb33-4b39-b723-095e69bc27ef',NULL,'93b48990367148d7947288c61fb37fdc','e404e742ed2d4e9d83bf3d49a6278dc7','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:06:15','2025-11-23 10:06:15','2025-11-23 10:06:16','tempest-AbsoluteLimitsTests-Volume-1577348104',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:05:22','2025-11-23 10:05:24','2025-11-23 10:05:24',1,'24e922bc-a494-4860-b4ac-f3cd24d891ec',NULL,'1b96f945d5154f44ac4029db9b2f0807','ba426e81cfe149da986575955289d04b','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:05:23','2025-11-23 10:05:23','2025-11-23 10:05:24','tempest-VolumesActionsTest-Volume-1327139454',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:07:28','2025-11-23 10:07:36','2025-11-23 10:07:37',1,'25a12535-0492-498a-8674-220aef0c3cde',NULL,'84b8a6a5dcc74a3e9eb9a0e8934261e5','b636df0d8cb546cbb04ef3840b8bf85d','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:07:28','2025-11-23 10:07:28','2025-11-23 10:07:36','tempest-VolumesListTestJSON-Volume-583442508',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:03:14','2025-11-23 10:03:15','2025-11-23 10:03:15',1,'2744f55a-118e-4bdb-a584-61c06b6afd52',NULL,'42ad1c0f7faa440e8fdf09af1b39a0b5','9d635cb23eed4c8795c7c085f175d605','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2453840a-69a7-40b6-9423-3267daf42577','b6d595ea-8206-457d-b78d-b17b350cbea3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'d0291243-67e3-4765-879b-1c344607e740',NULL,1,1),('2025-11-23 10:02:03','2025-11-23 10:02:05','2025-11-23 10:02:05',1,'27fdec41-d5ec-4fd0-9621-7e8f597ab09a',NULL,'f0c329c16706474faf6a45b770d81b59','b8fa70a700964960a82c255d7f038c3d','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:02:03','2025-11-23 10:02:03','2025-11-23 10:02:05','tempest-VolumesTransfersV357Test-Volume-878465453',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:07:41','2025-11-23 10:07:47','2025-11-23 10:07:48',1,'29913788-26b0-49ee-b84f-25f6f98f7056',NULL,'b97d9730069a4891aaf77ccce8c0ffa5','58bf8ae7240d4a5597bb2d7ae200e54b','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-11-23 10:07:41','2025-11-23 10:07:42','2025-11-23 10:07:47','tempest-VolumesSnapshotNegativeTestJSON-Volume-1800981096',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:03:00','2025-11-23 10:03:02','2025-11-23 10:03:02',1,'2d575a8c-a72b-40e2-8ff8-1d057dc9605c',NULL,'d4c36ce85e40425fa6aaf111d1fdfcc4','10f8dd7c838246c58f1d2c4efc771237','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-11-23 10:03:01','2025-11-23 10:03:01','2025-11-23 10:03:02','tempest-VolumesSnapshotTestJSON-Volume-1466347914',NULL,NULL,NULL,'b5d49b42-0508-42cd-8cc1-7f7c3fa204c0','771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:04:30','2025-11-23 10:04:43','2025-11-23 10:04:44',1,'2dbad71d-292a-44bf-ad02-16767165c0d2',NULL,'ba47196c60f34e139b6a0f16690cc642','307e3d5fcbc742a6b6aa246e7c8c9946','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:04:30','2025-11-23 10:04:30','2025-11-23 10:04:43','tempest-VolumesSnapshotListTestJSON-Volume-246521045',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:01:20','2025-11-23 10:01:30','2025-11-23 10:01:30',1,'2dcd814a-05df-4c5c-a250-0ae9dc18c81d',NULL,'cec0d39dc73b48458e0a0f8c462a1cba','b89f120d906e4409a0177b37c378adeb','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:01:20','2025-11-23 10:01:29','2025-11-23 10:01:30','tempest-VolumesImageMetadata-Volume-114459476',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:05:22','2025-11-23 10:05:42','2025-11-23 10:05:43',1,'2f870218-fb0c-42a2-a6d0-df09838cfb1a',NULL,'276a074587054ffaacc5b214d9c84a14','e26ac473e8284e80b775ad7fd47ae6ec','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:05:22','2025-11-23 10:05:22','2025-11-23 10:05:42','tempest-SnapshotsActionsTest-Volume-417170873',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:05:30','2025-11-23 10:05:32','2025-11-23 10:05:32',1,'39f227ff-c224-41f1-8950-8728e967c082',NULL,'62451c91e4c24f0fb36b26f84bd3bfc4','fb2fe4c3f84642bbad40631e42e594dd','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:05:30','2025-11-23 10:05:30',NULL,'tempest-volume-1193843156',NULL,NULL,NULL,NULL,'56da7e66-b2db-4f63-a5a8-67002badaafc',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'6bca1704-36a3-4e7d-b1d9-9310bf468c41','8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:07:00','2025-11-23 10:07:01','2025-11-23 10:07:02',1,'3d44f43c-8bd5-48a7-89bf-5728702c55e4',NULL,'aa226a7988cb445f88f27b4371eb193a','acf2d5195bde4e69ba34cd2a2c03e717','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:07:00','2025-11-23 10:07:00','2025-11-23 10:07:01','tempest-VolumesGetTest-Volume-860415018',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:02:30','2025-11-23 10:02:31','2025-11-23 10:02:50',1,'400ddc91-ec44-420d-8c35-8b7027101fa7',NULL,'d4c36ce85e40425fa6aaf111d1fdfcc4','10f8dd7c838246c58f1d2c4efc771237','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached',NULL,NULL,NULL,'backup-vol-d4b480ff-242c-4b3a-8ca6-2cc05a8f533e',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,1,0),('2025-11-23 10:07:04','2025-11-23 10:07:12','2025-11-23 10:07:13',1,'408a708b-5961-44ad-ae9e-9e2ba941ffa8',NULL,'aa226a7988cb445f88f27b4371eb193a','acf2d5195bde4e69ba34cd2a2c03e717','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:07:04','2025-11-23 10:07:04','2025-11-23 10:07:12','tempest-VolumesGetTest-Volume-2084394499',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:05:55','2025-11-23 10:05:57','2025-11-23 10:05:57',1,'442370c6-ee86-4322-af83-14b702579d1e',NULL,'1556c5016e464004b415305f8f5f8f35','14ef278019ca433e853baef5651087a9','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:05:56','2025-11-23 10:05:56','2025-11-23 10:05:57','tempest-VolumesServicesTestJSON-Volume-2109755821',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:02:46','2025-11-23 10:02:54','2025-11-23 10:02:55',1,'451a957d-e8a9-466c-adf1-febc3aa34163',NULL,'6824f1a2f1204c02a41cb29fe915f850','6d43b7d88e884e6d87abed93a63f5ca0','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:02:46','2025-11-23 10:02:47','2025-11-23 10:02:54','tempest-VolumesListAdminTestJSON-Volume-940469961',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:06:34','2025-11-23 10:07:23','2025-11-23 10:07:24',1,'4ca38ec4-1d0d-4276-a35b-91f6052b806a',NULL,'470f8273d9664aea8f6b91928e9f6f6c','33c4eecf43aa413a9f282206f9e9a55b','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:06:34','2025-11-23 10:06:34','2025-11-23 10:07:23','tempest-VolumesActionsTest-Volume-164185685',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:05:10','2025-11-23 10:05:15','2025-11-23 10:05:15',1,'4cf88075-db76-4047-a834-4f76fb2b4f84',NULL,'a626db0453f04b28a39df197c856d926','e456b00c470e4f58a0cb2eb0ed097106','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:05:10','2025-11-23 10:05:10','2025-11-23 10:05:15','tempest-VolumesCloneTest-Volume-1294448858',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:06:03','2025-11-23 10:06:05','2025-11-23 10:06:06',1,'4da885cf-2c34-44bd-8222-8bb3aee7ff39',NULL,'92a3f6a5f3804d4e847471749531397c','250d505f169f42eaa1d45ef735f6b254','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:06:03','2025-11-23 10:06:03','2025-11-23 10:06:05','tempest-VolumeQuotasAdminTestJSON-Volume-1492769065',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:06:58','2025-11-23 10:07:02','2025-11-23 10:07:03',1,'4e71ed6a-bfb6-45c8-bdf7-539c2c95847e',NULL,'aa226a7988cb445f88f27b4371eb193a','acf2d5195bde4e69ba34cd2a2c03e717','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:06:59','2025-11-23 10:06:59','2025-11-23 10:07:02','tempest-VolumesGetTest-new-Volume-1690161697','This is the new description of volume',NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:04:23','2025-11-23 10:04:29','2025-11-23 10:04:29',1,'5bf41466-bc3c-4729-b9e8-a3f6e477e95b',NULL,'b5f7228b2a13453f852ea24f00659c17','0e9ab70f23134afd92115add42e46bf7','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:04:23','2025-11-23 10:04:23',NULL,'tempest-volume-758562493',NULL,NULL,NULL,NULL,'3bb61f6b-350b-4406-9d79-133424e040aa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'d97cbdb7-bfb3-4e91-a3ae-4f19cae23892','8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:03:19','2025-11-23 10:03:37','2025-11-23 10:03:39',1,'5f882947-d542-4b3a-8f9a-d78d3d24e31e',NULL,'5f7e9736cbc74ce4ac3de51c4ac84504','49ebd7a691dd4ea59ffbe9f5703e77e4','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:03:19','2025-11-23 10:03:24','2025-11-23 10:03:37','tempest-VolumesBackupsTest-Volume-1894790069',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:01:59','2025-11-23 10:02:02','2025-11-23 10:02:02',1,'61a874c3-00cf-47cd-9001-27eca1150703',NULL,'5f59a31a4e22400e8f8a68f905989d9a','4b84b07fc6534e88860c454382c4f9f4','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:02:00','2025-11-23 10:02:00','2025-11-23 10:02:02','tempest-VolumesTransfersV357Test-Volume-256461988',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:05:49','2025-11-23 10:05:50','2025-11-23 10:05:51',1,'633dd0f7-5f6f-44ee-8969-feaa324b7808',NULL,'2456c1effe774a86b732ddbcf1679e10','31ac2e693dd64b72aedd3d1555ed3e03',NULL,1,'nova','deleted','detached',NULL,NULL,NULL,'tempest-UserMessagesTest-Volume-250233182',NULL,NULL,NULL,NULL,'802fec99-acaa-4a55-b858-406ee4d970f3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,1,1),('2025-11-23 10:02:58','2025-11-23 10:03:04','2025-11-23 10:03:05',1,'63f98e4b-f976-404f-a673-908d942dd644',NULL,'d4c36ce85e40425fa6aaf111d1fdfcc4','10f8dd7c838246c58f1d2c4efc771237','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:02:58','2025-11-23 10:02:58','2025-11-23 10:03:04','tempest-VolumesSnapshotTestJSON-Volume-828820458',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:02:48','2025-11-23 10:02:53','2025-11-23 10:02:54',1,'642190dc-2d16-4176-802e-5f13ca594e60',NULL,'6824f1a2f1204c02a41cb29fe915f850','6d43b7d88e884e6d87abed93a63f5ca0','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:02:48','2025-11-23 10:02:48','2025-11-23 10:02:53','tempest-VolumesListAdminTestJSON-Volume-2003151221',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:06:49','2025-11-23 10:06:55','2025-11-23 10:06:55',1,'690aee83-f53d-46d1-b9a0-c8b5cb779e4f',NULL,'1b77847c407f4e208881434bec8e637c','dd925bc8c28148ba8527b8de09a93c3c','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:06:49','2025-11-23 10:06:50','2025-11-23 10:06:55','tempest-SnapshotMetadataTestJSON-Volume-228831790',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:04:15','2025-11-23 10:04:25','2025-11-23 10:04:26',1,'69869a4e-5034-41d1-b8a7-4a9cfc9a2783',NULL,'682d17359450411582e76a93139b6948','357e082a3fb74c17977fb3ffe7ad4261','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:04:15','2025-11-23 10:04:15','2025-11-23 10:04:25','tempest-VolumesNegativeTest-Volume-743317906',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:07:05','2025-11-23 10:07:10','2025-11-23 10:07:11',1,'6e436092-75a0-405a-88eb-66606701b85c',NULL,'aa226a7988cb445f88f27b4371eb193a','acf2d5195bde4e69ba34cd2a2c03e717','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:07:05','2025-11-23 10:07:07','2025-11-23 10:07:10','tempest-VolumesGetTest-new-Volume-1167156681','This is the new description of volume',NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1','408a708b-5961-44ad-ae9e-9e2ba941ffa8',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:06:06','2025-11-23 10:06:08','2025-11-23 10:06:08',1,'7d092a41-3d37-4633-a036-cf0950922803',NULL,'2acff95f4f544f19a36a86da6d142ed5','eefb55b5a7ba44a99cf8b53d39954004','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:06:07','2025-11-23 10:06:07','2025-11-23 10:06:08','tempest-VolumeTypesAccessTest-Volume-405385016',NULL,NULL,NULL,NULL,'26319d65-0a56-4773-a14b-9a1b3d98a716',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:01:44','2025-11-23 10:01:46','2025-11-23 10:01:46',1,'7fdaf792-e977-4466-801a-c7f265d62ae1',NULL,'99e0886b0922425dadd1e21f7129faa8','9b4ff14ad14b470a96ecd244e7453fa2','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:01:45','2025-11-23 10:01:45','2025-11-23 10:01:46','tempest-VolumesTransfersV355Test-Volume-1186280311',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:07:08','2025-11-23 10:07:09','2025-11-23 10:07:10',1,'7ff6a9d7-a404-462c-9a6b-e03e42e3ff8a',NULL,'aa226a7988cb445f88f27b4371eb193a','acf2d5195bde4e69ba34cd2a2c03e717','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:07:08','2025-11-23 10:07:08','2025-11-23 10:07:09','tempest-VolumesGetTest-Volume-41785030',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:06:47','2025-11-23 10:06:54','2025-11-23 10:06:56',1,'8a35afd9-e2cc-479b-82ec-ab9be2de5687',NULL,'d919be80e59845fbb2790f6ff25ebd96','44a6cb5f8b014bad84cfff33db7a4de0','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:06:47','2025-11-23 10:06:47','2025-11-23 10:06:54','tempest-VolumesBackupsV39Test-Volume-786232909',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:07:29','2025-11-23 10:07:35','2025-11-23 10:07:35',1,'8c8b8bd8-5768-4f7e-9705-066f719d7593',NULL,'84b8a6a5dcc74a3e9eb9a0e8934261e5','b636df0d8cb546cbb04ef3840b8bf85d','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:07:29','2025-11-23 10:07:30','2025-11-23 10:07:35','tempest-VolumesListTestJSON-Volume-566350524',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:01:41','2025-11-23 10:01:43','2025-11-23 10:01:44',1,'8ca29446-4a3c-44cc-9f01-c8cc95966815',NULL,'5ba883b9333d44c9a9c4093d565623d6','2f5ceb3dcba34969a782c4e8c5c3fe76','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:01:41','2025-11-23 10:01:41','2025-11-23 10:01:43','tempest-VolumesTransfersV355Test-Volume-1610495177',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:03:22','2025-11-23 10:03:36','2025-11-23 10:03:37',1,'8ef120f8-d737-417b-9805-c4face11ceb4',NULL,'42ad1c0f7faa440e8fdf09af1b39a0b5','9d635cb23eed4c8795c7c085f175d605','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:03:22','2025-11-23 10:03:22',NULL,'tempest-volume-1942910388',NULL,NULL,NULL,NULL,'e5331b89-b9ff-471f-8259-23626242497b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'e1bff02b-6264-4203-baf2-3735364b24fc','8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:06:21','2025-11-23 10:06:26','2025-11-23 10:06:29',1,'9edaf508-4449-4f6d-b4b4-a187f8b1d8bd',NULL,'1165185c7fd04092b5c02f4591a1386d','1be7eab758d64df6bb38d4ddeefb99dd','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:06:21','2025-11-23 10:06:21','2025-11-23 10:06:26','tempest-VolumesDeleteCascade-Volume-393082094',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:07:31','2025-11-23 10:07:34','2025-11-23 10:07:34',1,'9f0dde51-b281-44b1-8bbb-adcd4a7f1833',NULL,'84b8a6a5dcc74a3e9eb9a0e8934261e5','b636df0d8cb546cbb04ef3840b8bf85d','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:07:31','2025-11-23 10:07:31','2025-11-23 10:07:34','tempest-VolumesListTestJSON-Volume-998727170',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:03:30','2025-11-23 10:03:34','2025-11-23 10:03:35',1,'a01af78e-65b1-4be5-93ac-056bedd54cb6',NULL,'5f7e9736cbc74ce4ac3de51c4ac84504','49ebd7a691dd4ea59ffbe9f5703e77e4','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:03:30','2025-11-23 10:03:30','2025-11-23 10:03:34','tempest-VolumesBackupsTest-Volume-1894790069',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:03:05','2025-11-23 10:03:13','2025-11-23 10:03:13',1,'a05cb439-a27c-4c7f-9523-e12511f3d438',NULL,'d4c36ce85e40425fa6aaf111d1fdfcc4','10f8dd7c838246c58f1d2c4efc771237','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:03:06','2025-11-23 10:03:06','2025-11-23 10:03:13','tempest-VolumesSnapshotTestJSON-Volume-1302229238',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:05:51','2025-11-23 10:05:51','2025-11-23 10:05:53',1,'a14ff63e-4d59-4228-ace7-cc262cb9b821',NULL,'2456c1effe774a86b732ddbcf1679e10','31ac2e693dd64b72aedd3d1555ed3e03',NULL,1,'nova','deleted','detached',NULL,NULL,NULL,'tempest-UserMessagesTest-Volume-1657043600',NULL,NULL,NULL,NULL,'a250c9b2-d39f-40cc-83b9-c0d31f2e57f3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,1,1),('2025-11-23 10:05:40','2025-11-23 10:05:41','2025-11-23 10:05:42',1,'a67d45d9-9a83-4c6b-b61d-461aaeac46b4',NULL,'9d6cf003ec9b4ab9b3c8117a9e28aa56','737e70c24c3a4eac85267456be6774fa','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-11-23 10:05:40','2025-11-23 10:05:40','2025-11-23 10:05:41','tempest-VolumesCloneNegativeTest-Volume-485828826',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:04:26','2025-11-23 10:04:32','2025-11-23 10:04:32',1,'b111242b-f610-497c-892c-37fd21aac679',NULL,'17dbff441f8f4a61afa721f91b9c971d','bd97d43422d1434dbd778fc0c37a5566','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-11-23 10:04:26','2025-11-23 10:04:26','2025-11-23 10:04:32','tempest-VolumesExtendTest-Volume-898238562',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:05:05','2025-11-23 10:05:07','2025-11-23 10:05:08',1,'bac0139f-864e-457c-ae6d-50523f07308f',NULL,'a626db0453f04b28a39df197c856d926','e456b00c470e4f58a0cb2eb0ed097106','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:05:05','2025-11-23 10:05:06','2025-11-23 10:05:07','tempest-VolumesCloneTest-Volume-1773774987',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1','bb2e788c-6184-48c6-b0a2-9093e6fd3a19',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:04:58','2025-11-23 10:05:09','2025-11-23 10:05:09',1,'bb2e788c-6184-48c6-b0a2-9093e6fd3a19',NULL,'a626db0453f04b28a39df197c856d926','e456b00c470e4f58a0cb2eb0ed097106','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:04:58','2025-11-23 10:05:03','2025-11-23 10:05:09','tempest-VolumesCloneTest-Volume-1676638570',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:05:25','2025-11-23 10:05:27','2025-11-23 10:05:27',1,'c6eb8bf2-0041-45db-bb9a-ad47df8898a8',NULL,'1b96f945d5154f44ac4029db9b2f0807','ba426e81cfe149da986575955289d04b','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:05:25','2025-11-23 10:05:25','2025-11-23 10:05:27','tempest-VolumesActionsTest-Volume-1127220200',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:06:32','2025-11-23 10:06:42','2025-11-23 10:06:43',1,'ce38a04b-b9fa-4841-8b3e-dc88fd337880',NULL,'1165185c7fd04092b5c02f4591a1386d','1be7eab758d64df6bb38d4ddeefb99dd','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:06:32','2025-11-23 10:06:33','2025-11-23 10:06:42','tempest-VolumesDeleteCascade-Volume-234532690',NULL,NULL,NULL,'8e8c397b-6fe7-44e2-a2b4-04252df0c563','771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:03:23','2025-11-23 10:03:36','2025-11-23 10:03:37',1,'d19fb26f-5b16-45b4-8d09-ceca07700fd2',NULL,'42ad1c0f7faa440e8fdf09af1b39a0b5','9d635cb23eed4c8795c7c085f175d605','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:03:23','2025-11-23 10:03:23',NULL,'tempest-volume-149189729',NULL,NULL,NULL,NULL,'e5331b89-b9ff-471f-8259-23626242497b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'e1bff02b-6264-4203-baf2-3735364b24fc','8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:02:26','2025-11-23 10:03:14','2025-11-23 10:03:14',1,'d4b480ff-242c-4b3a-8ca6-2cc05a8f533e',NULL,'d4c36ce85e40425fa6aaf111d1fdfcc4','10f8dd7c838246c58f1d2c4efc771237','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:02:26','2025-11-23 10:02:27','2025-11-23 10:03:14','tempest-VolumesSnapshotTestJSON-Volume-711722079',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:07:21','2025-11-23 10:07:23','2025-11-23 10:07:23',1,'dc2846b4-bd70-45d6-b812-5f24b2148905',NULL,'aa226a7988cb445f88f27b4371eb193a','acf2d5195bde4e69ba34cd2a2c03e717','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:07:21','2025-11-23 10:07:22','2025-11-23 10:07:23','tempest-VolumesGetTest-Volume-1847260083',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:02:50','2025-11-23 10:02:52','2025-11-23 10:02:53',1,'dc2cdc59-032e-4d59-87eb-cfda55fe6c1e',NULL,'b36a09c5c13b4a3e9b854ddeb00649ee','975c2485ae874077a08f31a00a36b8e9','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:02:51','2025-11-23 10:02:51','2025-11-23 10:02:52',NULL,NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:06:00','2025-11-23 10:06:02','2025-11-23 10:06:02',1,'dd6b73e1-7846-494d-96c2-a057eb263e01',NULL,'e92d39b2b28b4209b49b1fc95dff6039','4e886bd382154b9ba842be63cef3b094','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:06:00','2025-11-23 10:06:01','2025-11-23 10:06:02','tempest-VolumeQuotasAdminTestJSON-Volume-609734815',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:04:17','2025-11-23 10:04:24','2025-11-23 10:04:25',1,'ddbbb316-3050-469f-87c1-0a1a03b6daee',NULL,'17dbff441f8f4a61afa721f91b9c971d','bd97d43422d1434dbd778fc0c37a5566','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-11-23 10:04:17','2025-11-23 10:04:23','2025-11-23 10:04:24','tempest-VolumesExtendTest-Volume-1912179095',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:03:40','2025-11-23 10:04:43','2025-11-23 10:04:47',1,'e6dcaf3a-9826-4f4a-99ce-65fb52624d71',NULL,'5f7e9736cbc74ce4ac3de51c4ac84504','49ebd7a691dd4ea59ffbe9f5703e77e4','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:03:40','2025-11-23 10:03:40','2025-11-23 10:04:43','tempest-VolumesBackupsTest-Volume-1018413297',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:03:10','2025-11-23 10:03:19','2025-11-23 10:03:19',1,'ed76e3db-86dc-4273-80d4-9338ac06e1f8',NULL,'42ad1c0f7faa440e8fdf09af1b39a0b5','9d635cb23eed4c8795c7c085f175d605','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:03:10','2025-11-23 10:03:11',NULL,'tempest-volume-509828097',NULL,NULL,NULL,NULL,'b6d595ea-8206-457d-b78d-b17b350cbea3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'7dfddc1c-7ecc-43de-8b36-365b10328d0c','8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:06:16','2025-11-23 10:06:18','2025-11-23 10:06:18',1,'efa9a0b5-e9e1-4fd0-8cc4-8840d9145143',NULL,'d2b38626eefd4b179f1b36b2de7959b5','8cc99762c1da46248e6ae87d4c3b549f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:06:16','2025-11-23 10:06:16','2025-11-23 10:06:18','tempest-VolumesTransfersTest-Volume-12485965',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:05:44','2025-11-23 10:05:49','2025-11-23 10:05:49',1,'f0af0bd4-1cf6-4601-8951-98a0a69040f8',NULL,'df30e9d95de942da9333c6d01dd52576','b26c9bed083447548be26f4feb5dd112','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:05:44','2025-11-23 10:05:44',NULL,'tempest-volume-1448782948',NULL,NULL,NULL,NULL,'ef286d9e-549a-4844-9f5d-93ebf87512fc',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'3c1d862f-3d18-4823-b86a-5734360d6542','8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:02:33','2025-11-23 10:02:35','2025-11-23 10:02:37',1,'f1f185c5-6331-45dc-80f2-c0ad2fcf574a',NULL,'d1d5d82a85bd4059b213a62ec331d39a','6af2e3709ace42c9b1e8c60ef058acf5','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:02:33','2025-11-23 10:02:33','2025-11-23 10:02:35','tempest-VolumeQuotasNegativeTestJSON-Volume-1543008296',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:03:39','2025-11-23 10:03:44','2025-11-23 10:03:44',1,'f1fa255c-83a7-468f-aa9c-1f625546209b',NULL,'42ad1c0f7faa440e8fdf09af1b39a0b5','9d635cb23eed4c8795c7c085f175d605','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:03:39','2025-11-23 10:03:39',NULL,'tempest-volume-676807116',NULL,NULL,NULL,NULL,'64fcaaaa-fa47-4bdc-a13a-bebe79570770',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'fefefca2-079b-4555-b8b1-5983dcf5d9d6','8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1),('2025-11-23 10:05:17','2025-11-23 10:05:18','2025-11-23 10:05:19',1,'fee48d86-b4b5-4006-9844-8f84bd7e7a44',NULL,'1b96f945d5154f44ac4029db9b2f0807','ba426e81cfe149da986575955289d04b','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-23 10:05:17','2025-11-23 10:05:17','2025-11-23 10:05:18','tempest-VolumesActionsTest-Volume-81982675',NULL,NULL,NULL,NULL,'771bddfa-6ad8-421a-8097-6c694bc403f1',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'8edb8745-a83f-4f13-a0af-401cfeca0a9d',0,1);
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=161 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2025-11-23 08:07:40','2025-11-23 08:07:40.000123',NULL,0,2,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (2,'be9a09b1-b916-4d06-9bcd-d8b8afdf9284','rbd://46550e70-79cb-5f55-bf6d-1204b97e083b/images/be9a09b1-b916-4d06-9bcd-d8b8afdf9284/snap','2025-11-23 08:24:31','2025-11-23 08:24:31',NULL,0,'{\"store\": \"default_backend\"}','active'),(5,'c5806483-57a8-4254-b41b-254b888c8606','rbd://46550e70-79cb-5f55-bf6d-1204b97e083b/images/c5806483-57a8-4254-b41b-254b888c8606/snap','2025-11-23 09:56:47','2025-11-23 09:56:47',NULL,0,'{\"store\": \"default_backend\"}','active'),(6,'db545b98-5d22-49b0-85fe-f8d3a871776f','rbd://46550e70-79cb-5f55-bf6d-1204b97e083b/images/db545b98-5d22-49b0-85fe-f8d3a871776f/snap','2025-11-23 09:56:49','2025-11-23 09:56:49',NULL,0,'{\"store\": \"default_backend\"}','active'),(7,'7b536e06-7fe2-4119-9fc2-da2a16cd53e7','rbd://46550e70-79cb-5f55-bf6d-1204b97e083b/images/7b536e06-7fe2-4119-9fc2-da2a16cd53e7/snap','2025-11-23 09:57:55','2025-11-23 09:58:00','2025-11-23 09:58:00',1,'{\"store\": \"default_backend\"}','deleted'),(8,'7ff19ec8-b33a-4365-b738-cfaa2a3c2aeb','rbd://46550e70-79cb-5f55-bf6d-1204b97e083b/images/7ff19ec8-b33a-4365-b738-cfaa2a3c2aeb/snap','2025-11-23 09:59:06','2025-11-23 09:59:15','2025-11-23 09:59:15',1,'{\"store\": \"default_backend\"}','deleted'),(9,'4cd3d802-f16b-41b2-8c63-95122732fe22','rbd://46550e70-79cb-5f55-bf6d-1204b97e083b/images/4cd3d802-f16b-41b2-8c63-95122732fe22/snap','2025-11-23 09:59:08','2025-11-23 09:59:12','2025-11-23 09:59:12',1,'{\"store\": \"default_backend\"}','deleted'),(10,'0fb03e46-583e-40ac-af1b-e9d1b012446b','rbd://46550e70-79cb-5f55-bf6d-1204b97e083b/images/0fb03e46-583e-40ac-af1b-e9d1b012446b/snap','2025-11-23 09:59:09','2025-11-23 09:59:11','2025-11-23 09:59:11',1,'{\"store\": \"default_backend\"}','deleted'),(11,'322f922f-ef29-42be-b2e7-4a48eba5eaa4','rbd://46550e70-79cb-5f55-bf6d-1204b97e083b/images/322f922f-ef29-42be-b2e7-4a48eba5eaa4/snap','2025-11-23 09:59:33','2025-11-23 09:59:36','2025-11-23 09:59:36',1,'{\"store\": \"default_backend\"}','deleted'),(12,'b6d724dc-26d8-4b53-bc02-990c8b280c9a','rbd://46550e70-79cb-5f55-bf6d-1204b97e083b/images/b6d724dc-26d8-4b53-bc02-990c8b280c9a/snap','2025-11-23 09:59:34','2025-11-23 09:59:44','2025-11-23 09:59:44',1,'{\"store\": \"default_backend\"}','deleted'),(13,'6af836e7-49e9-4253-9317-8d8e424b9245','rbd://46550e70-79cb-5f55-bf6d-1204b97e083b/images/6af836e7-49e9-4253-9317-8d8e424b9245/snap','2025-11-23 09:59:40','2025-11-23 09:59:42','2025-11-23 09:59:42',1,'{\"store\": \"default_backend\"}','deleted'),(14,'8e9a94f9-069b-4255-9245-e90c2ca157d0','rbd://46550e70-79cb-5f55-bf6d-1204b97e083b/images/8e9a94f9-069b-4255-9245-e90c2ca157d0/snap','2025-11-23 10:02:08','2025-11-23 10:02:20','2025-11-23 10:02:20',1,'{\"store\": \"default_backend\"}','deleted'),(15,'425faee4-c9bd-4a82-bf28-3c502e5e6ae1','rbd://46550e70-79cb-5f55-bf6d-1204b97e083b/images/425faee4-c9bd-4a82-bf28-3c502e5e6ae1/snap','2025-11-23 10:02:17','2025-11-23 10:02:19','2025-11-23 10:02:19',1,'{\"store\": \"default_backend\"}','deleted'),(16,'7d8d0aaa-9efa-492f-8f1e-5a64ec0cbf0d','rbd://46550e70-79cb-5f55-bf6d-1204b97e083b/images/7d8d0aaa-9efa-492f-8f1e-5a64ec0cbf0d/snap','2025-11-23 10:02:25','2025-11-23 10:02:42','2025-11-23 10:02:42',1,'{\"store\": \"default_backend\"}','deleted'),(17,'361271f8-fbd5-4f3b-b29e-858aa4b85bb2','rbd://46550e70-79cb-5f55-bf6d-1204b97e083b/images/361271f8-fbd5-4f3b-b29e-858aa4b85bb2/snap','2025-11-23 10:02:26','2025-11-23 10:02:40','2025-11-23 10:02:40',1,'{\"store\": \"default_backend\"}','deleted'),(18,'eb312786-be3b-45ea-94b5-0f9a228cf5d4','rbd://46550e70-79cb-5f55-bf6d-1204b97e083b/images/eb312786-be3b-45ea-94b5-0f9a228cf5d4/snap','2025-11-23 10:02:27','2025-11-23 10:02:38','2025-11-23 10:02:38',1,'{\"store\": \"default_backend\"}','deleted'),(19,'00239b46-6054-46d2-84ed-b2294c5fce4b','rbd://46550e70-79cb-5f55-bf6d-1204b97e083b/images/00239b46-6054-46d2-84ed-b2294c5fce4b/snap','2025-11-23 10:02:28','2025-11-23 10:02:35','2025-11-23 10:02:35',1,'{\"store\": \"default_backend\"}','deleted'),(20,'41af96d9-5ef7-4354-b0af-b42156a4865c','rbd://46550e70-79cb-5f55-bf6d-1204b97e083b/images/41af96d9-5ef7-4354-b0af-b42156a4865c/snap','2025-11-23 10:02:29','2025-11-23 10:02:34','2025-11-23 10:02:34',1,'{\"store\": \"default_backend\"}','deleted'),(21,'bad85794-35e9-451d-bdef-43be8a8bfa3f','rbd://46550e70-79cb-5f55-bf6d-1204b97e083b/images/bad85794-35e9-451d-bdef-43be8a8bfa3f/snap','2025-11-23 10:02:30','2025-11-23 10:02:32','2025-11-23 10:02:32',1,'{\"store\": \"default_backend\"}','deleted'),(22,'b0fd3242-4ce6-4536-8f08-d1932c0f3ccb','rbd://46550e70-79cb-5f55-bf6d-1204b97e083b/images/b0fd3242-4ce6-4536-8f08-d1932c0f3ccb/snap','2025-11-23 10:04:17','2025-11-23 10:04:20','2025-11-23 10:04:20',1,'{\"store\": \"default_backend\"}','deleted'),(23,'989d18a2-a219-493d-b08a-54238ff893dd','rbd://46550e70-79cb-5f55-bf6d-1204b97e083b/images/989d18a2-a219-493d-b08a-54238ff893dd/snap','2025-11-23 10:04:21','2025-11-23 10:04:24','2025-11-23 10:04:24',1,'{\"store\": \"default_backend\"}','deleted'),(24,'3d8b6e86-3603-44d7-b163-3e2f3e604009','rbd://46550e70-79cb-5f55-bf6d-1204b97e083b/images/3d8b6e86-3603-44d7-b163-3e2f3e604009/snap','2025-11-23 10:07:20','2025-11-23 10:07:23','2025-11-23 10:07:23',1,'{\"store\": \"default_backend\"}','deleted'),(25,'83f805d1-158b-4aff-9c58-5b27a31c2297','rbd://46550e70-79cb-5f55-bf6d-1204b97e083b/images/83f805d1-158b-4aff-9c58-5b27a31c2297/snap','2025-11-23 10:07:33','2025-11-23 10:07:35','2025-11-23 10:07:35',1,'{\"store\": \"default_backend\"}','deleted');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
INSERT INTO `image_members` (`id`, `image_id`, `member`, `can_share`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`) VALUES (1,'6af836e7-49e9-4253-9317-8d8e424b9245','64177ff73b0d4c5cb41b8b9c141cbb69',0,'2025-11-23 09:59:40','2025-11-23 09:59:42','2025-11-23 09:59:42',1,'pending'),(2,'1bb8d4e0-9910-4851-8ef4-21a76383aa02','7537c8677dc44d718f2543b4d11fe4ed',0,'2025-11-23 10:00:36','2025-11-23 10:00:36','2025-11-23 10:00:36',1,'pending'),(3,'0f5254c9-cebf-43d2-ae20-8c4276ec167d','7537c8677dc44d718f2543b4d11fe4ed',0,'2025-11-23 10:00:36','2025-11-23 10:00:36','2025-11-23 10:00:36',1,'pending'),(4,'ebb67f6d-50dd-4e76-9b6c-0af8014fd05a','ebbd9ff9506847c3a755175143ee9705',0,'2025-11-23 10:03:11','2025-11-23 10:03:12','2025-11-23 10:03:12',1,'accepted'),(5,'15ac1a3b-e12f-43e5-8f5b-29b480ee320a','ebbd9ff9506847c3a755175143ee9705',0,'2025-11-23 10:03:12','2025-11-23 10:03:12','2025-11-23 10:03:12',1,'accepted'),(6,'97add930-198b-47db-b6d3-3bcb8d6f1b87','ebbd9ff9506847c3a755175143ee9705',0,'2025-11-23 10:03:12','2025-11-23 10:03:12','2025-11-23 10:03:12',1,'rejected'),(7,'621c31e5-c2c6-4d56-83fb-f5ae5bbcd0e4','ebbd9ff9506847c3a755175143ee9705',0,'2025-11-23 10:03:12','2025-11-23 10:03:12','2025-11-23 10:03:12',1,'accepted');
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (2,'be9a09b1-b916-4d06-9bcd-d8b8afdf9284','owner_specified.openstack.md5','','2025-11-23 08:24:27','2025-11-23 08:24:27',NULL,0),(5,'be9a09b1-b916-4d06-9bcd-d8b8afdf9284','owner_specified.openstack.sha256','','2025-11-23 08:24:27','2025-11-23 08:24:27',NULL,0),(8,'be9a09b1-b916-4d06-9bcd-d8b8afdf9284','owner_specified.openstack.object','images/cirros','2025-11-23 08:24:27','2025-11-23 08:24:27',NULL,0),(11,'c5806483-57a8-4254-b41b-254b888c8606','hw_rng_model','virtio','2025-11-23 09:56:45','2025-11-23 09:56:45',NULL,0),(12,'db545b98-5d22-49b0-85fe-f8d3a871776f','hw_rng_model','virtio','2025-11-23 09:56:47','2025-11-23 09:56:47',NULL,0),(13,'7b536e06-7fe2-4119-9fc2-da2a16cd53e7','os_version','alt1','2025-11-23 09:57:55','2025-11-23 09:58:00','2025-11-23 09:58:00',1),(14,'7b536e06-7fe2-4119-9fc2-da2a16cd53e7','os_distro','value2','2025-11-23 09:57:55','2025-11-23 09:58:00','2025-11-23 09:58:00',1),(15,'7b536e06-7fe2-4119-9fc2-da2a16cd53e7','architecture','value3','2025-11-23 09:57:57','2025-11-23 09:58:00','2025-11-23 09:58:00',1),(16,'7ff19ec8-b33a-4365-b738-cfaa2a3c2aeb','hw_rng_model','virtio','2025-11-23 09:58:37','2025-11-23 09:59:15','2025-11-23 09:59:15',1),(17,'7ff19ec8-b33a-4365-b738-cfaa2a3c2aeb','base_image_ref','c5806483-57a8-4254-b41b-254b888c8606','2025-11-23 09:58:37','2025-11-23 09:59:15','2025-11-23 09:59:15',1),(18,'7ff19ec8-b33a-4365-b738-cfaa2a3c2aeb','owner_user_name','tempest-UnshelveToHostMultiNodesTest-612486733-project-member','2025-11-23 09:58:37','2025-11-23 09:59:15','2025-11-23 09:59:15',1),(19,'7ff19ec8-b33a-4365-b738-cfaa2a3c2aeb','owner_project_name','tempest-UnshelveToHostMultiNodesTest-612486733','2025-11-23 09:58:37','2025-11-23 09:59:15','2025-11-23 09:59:15',1),(20,'7ff19ec8-b33a-4365-b738-cfaa2a3c2aeb','boot_roles','reader,member','2025-11-23 09:58:37','2025-11-23 09:59:15','2025-11-23 09:59:15',1),(21,'7ff19ec8-b33a-4365-b738-cfaa2a3c2aeb','hw_machine_type','q35','2025-11-23 09:58:37','2025-11-23 09:59:15','2025-11-23 09:59:15',1),(22,'7ff19ec8-b33a-4365-b738-cfaa2a3c2aeb','hw_cdrom_bus','sata','2025-11-23 09:58:37','2025-11-23 09:59:15','2025-11-23 09:59:15',1),(23,'7ff19ec8-b33a-4365-b738-cfaa2a3c2aeb','hw_disk_bus','virtio','2025-11-23 09:58:37','2025-11-23 09:59:15','2025-11-23 09:59:15',1),(24,'7ff19ec8-b33a-4365-b738-cfaa2a3c2aeb','hw_input_bus','usb','2025-11-23 09:58:37','2025-11-23 09:59:15','2025-11-23 09:59:15',1),(25,'7ff19ec8-b33a-4365-b738-cfaa2a3c2aeb','hw_pointer_model','usbtablet','2025-11-23 09:58:37','2025-11-23 09:59:15','2025-11-23 09:59:15',1),(26,'7ff19ec8-b33a-4365-b738-cfaa2a3c2aeb','hw_video_model','virtio','2025-11-23 09:58:37','2025-11-23 09:59:15','2025-11-23 09:59:15',1),(27,'7ff19ec8-b33a-4365-b738-cfaa2a3c2aeb','hw_vif_model','virtio','2025-11-23 09:58:37','2025-11-23 09:59:15','2025-11-23 09:59:15',1),(28,'7ff19ec8-b33a-4365-b738-cfaa2a3c2aeb','instance_uuid','8a8ddd35-7dc7-40a2-9524-7a0b8fec8ef7','2025-11-23 09:58:37','2025-11-23 09:59:15','2025-11-23 09:59:15',1),(29,'7ff19ec8-b33a-4365-b738-cfaa2a3c2aeb','user_id','55581f20ed8d4bd8a61a81c525ca8141','2025-11-23 09:58:37','2025-11-23 09:59:15','2025-11-23 09:59:15',1),(30,'7ff19ec8-b33a-4365-b738-cfaa2a3c2aeb','image_type','snapshot','2025-11-23 09:58:37','2025-11-23 09:59:15','2025-11-23 09:59:15',1),(32,'18805c02-9f8c-41f8-8cb2-f5253d9a1692','os_glance_importing_to_stores','','2025-11-23 09:58:54','2025-11-23 09:58:54',NULL,0),(33,'18805c02-9f8c-41f8-8cb2-f5253d9a1692','os_glance_failed_import','default_backend','2025-11-23 09:58:54','2025-11-23 09:58:54',NULL,0),(34,'7ff19ec8-b33a-4365-b738-cfaa2a3c2aeb','owner_id','37a58b702f564a81ab5a59cf4201b4f0','2025-11-23 09:59:05','2025-11-23 09:59:15','2025-11-23 09:59:15',1),(35,'7ff19ec8-b33a-4365-b738-cfaa2a3c2aeb','image_location','snapshot','2025-11-23 09:59:05','2025-11-23 09:59:15','2025-11-23 09:59:15',1),(36,'7ff19ec8-b33a-4365-b738-cfaa2a3c2aeb','image_state','available','2025-11-23 09:59:05','2025-11-23 09:59:15','2025-11-23 09:59:15',1),(37,'0fb03e46-583e-40ac-af1b-e9d1b012446b','ramdisk_id','00000000-1111-2222-3333-444455556666','2025-11-23 09:59:09','2025-11-23 09:59:11','2025-11-23 09:59:11',1),(38,'b6d724dc-26d8-4b53-bc02-990c8b280c9a','hw_rng_model','virtio','2025-11-23 09:59:16','2025-11-23 09:59:44','2025-11-23 09:59:44',1),(39,'b6d724dc-26d8-4b53-bc02-990c8b280c9a','base_image_ref','c5806483-57a8-4254-b41b-254b888c8606','2025-11-23 09:59:16','2025-11-23 09:59:44','2025-11-23 09:59:44',1),(40,'b6d724dc-26d8-4b53-bc02-990c8b280c9a','owner_user_name','tempest-UnshelveToHostMultiNodesTest-612486733-project-member','2025-11-23 09:59:16','2025-11-23 09:59:44','2025-11-23 09:59:44',1),(41,'b6d724dc-26d8-4b53-bc02-990c8b280c9a','owner_project_name','tempest-UnshelveToHostMultiNodesTest-612486733','2025-11-23 09:59:16','2025-11-23 09:59:44','2025-11-23 09:59:44',1),(42,'b6d724dc-26d8-4b53-bc02-990c8b280c9a','boot_roles','reader,member','2025-11-23 09:59:16','2025-11-23 09:59:44','2025-11-23 09:59:44',1),(43,'b6d724dc-26d8-4b53-bc02-990c8b280c9a','hw_machine_type','q35','2025-11-23 09:59:16','2025-11-23 09:59:44','2025-11-23 09:59:44',1),(44,'b6d724dc-26d8-4b53-bc02-990c8b280c9a','hw_cdrom_bus','sata','2025-11-23 09:59:16','2025-11-23 09:59:44','2025-11-23 09:59:44',1),(45,'b6d724dc-26d8-4b53-bc02-990c8b280c9a','hw_disk_bus','virtio','2025-11-23 09:59:16','2025-11-23 09:59:44','2025-11-23 09:59:44',1),(46,'b6d724dc-26d8-4b53-bc02-990c8b280c9a','hw_input_bus','usb','2025-11-23 09:59:16','2025-11-23 09:59:44','2025-11-23 09:59:44',1),(47,'b6d724dc-26d8-4b53-bc02-990c8b280c9a','hw_pointer_model','usbtablet','2025-11-23 09:59:16','2025-11-23 09:59:44','2025-11-23 09:59:44',1),(48,'b6d724dc-26d8-4b53-bc02-990c8b280c9a','hw_video_model','virtio','2025-11-23 09:59:16','2025-11-23 09:59:44','2025-11-23 09:59:44',1),(49,'b6d724dc-26d8-4b53-bc02-990c8b280c9a','hw_vif_model','virtio','2025-11-23 09:59:16','2025-11-23 09:59:44','2025-11-23 09:59:44',1),(50,'b6d724dc-26d8-4b53-bc02-990c8b280c9a','clean_attempts','1','2025-11-23 09:59:16','2025-11-23 09:59:44','2025-11-23 09:59:44',1),(51,'b6d724dc-26d8-4b53-bc02-990c8b280c9a','instance_uuid','8a8ddd35-7dc7-40a2-9524-7a0b8fec8ef7','2025-11-23 09:59:16','2025-11-23 09:59:44','2025-11-23 09:59:44',1),(52,'b6d724dc-26d8-4b53-bc02-990c8b280c9a','user_id','55581f20ed8d4bd8a61a81c525ca8141','2025-11-23 09:59:16','2025-11-23 09:59:44','2025-11-23 09:59:44',1),(53,'b6d724dc-26d8-4b53-bc02-990c8b280c9a','image_type','snapshot','2025-11-23 09:59:16','2025-11-23 09:59:44','2025-11-23 09:59:44',1),(54,'b6d724dc-26d8-4b53-bc02-990c8b280c9a','owner_id','37a58b702f564a81ab5a59cf4201b4f0','2025-11-23 09:59:33','2025-11-23 09:59:44','2025-11-23 09:59:44',1),(55,'b6d724dc-26d8-4b53-bc02-990c8b280c9a','image_location','snapshot','2025-11-23 09:59:33','2025-11-23 09:59:44','2025-11-23 09:59:44',1),(56,'b6d724dc-26d8-4b53-bc02-990c8b280c9a','image_state','available','2025-11-23 09:59:33','2025-11-23 09:59:44','2025-11-23 09:59:44',1),(57,'8e9a94f9-069b-4255-9245-e90c2ca157d0','ramdisk_id','00000000-1111-2222-3333-444455556666','2025-11-23 10:02:07','2025-11-23 10:02:20','2025-11-23 10:02:20',1),(58,'8e9a94f9-069b-4255-9245-e90c2ca157d0','os_glance_stage_host','http://glance-default-external-api-0.glance-default-external-api.openstack.svc:9292','2025-11-23 10:02:07','2025-11-23 10:02:20','2025-11-23 10:02:20',1),(60,'8e9a94f9-069b-4255-9245-e90c2ca157d0','os_glance_importing_to_stores','','2025-11-23 10:02:07','2025-11-23 10:02:20','2025-11-23 10:02:20',1),(61,'8e9a94f9-069b-4255-9245-e90c2ca157d0','os_glance_failed_import','','2025-11-23 10:02:07','2025-11-23 10:02:20','2025-11-23 10:02:20',1),(62,'425faee4-c9bd-4a82-bf28-3c502e5e6ae1','ramdisk_id','00000000-1111-2222-3333-444455556666','2025-11-23 10:02:09','2025-11-23 10:02:19','2025-11-23 10:02:19',1),(64,'425faee4-c9bd-4a82-bf28-3c502e5e6ae1','os_glance_importing_to_stores','','2025-11-23 10:02:09','2025-11-23 10:02:19','2025-11-23 10:02:19',1),(65,'425faee4-c9bd-4a82-bf28-3c502e5e6ae1','os_glance_failed_import','','2025-11-23 10:02:09','2025-11-23 10:02:19','2025-11-23 10:02:19',1);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
INSERT INTO `image_tags` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'b89f9d0c-aa7b-4f1c-97b3-cfaa0a01ff99','tempest-tag-491919056','2025-11-23 10:00:22','2025-11-23 10:00:22','2025-11-23 10:00:22',1),(2,'7d8d0aaa-9efa-492f-8f1e-5a64ec0cbf0d','tempest-tag-1177770942','2025-11-23 10:02:24','2025-11-23 10:02:42','2025-11-23 10:02:42',1),(3,'7d8d0aaa-9efa-492f-8f1e-5a64ec0cbf0d','tempest-tag-987041034','2025-11-23 10:02:24','2025-11-23 10:02:42','2025-11-23 10:02:42',1),(4,'361271f8-fbd5-4f3b-b29e-858aa4b85bb2','tempest-tag-926476697','2025-11-23 10:02:25','2025-11-23 10:02:40','2025-11-23 10:02:40',1),(5,'361271f8-fbd5-4f3b-b29e-858aa4b85bb2','tempest-tag-1117918163','2025-11-23 10:02:25','2025-11-23 10:02:40','2025-11-23 10:02:40',1),(6,'eb312786-be3b-45ea-94b5-0f9a228cf5d4','tempest-tag-254477325','2025-11-23 10:02:26','2025-11-23 10:02:38','2025-11-23 10:02:38',1),(7,'eb312786-be3b-45ea-94b5-0f9a228cf5d4','tempest-tag-722503954','2025-11-23 10:02:26','2025-11-23 10:02:38','2025-11-23 10:02:38',1),(8,'00239b46-6054-46d2-84ed-b2294c5fce4b','tempest-tag-1209539292','2025-11-23 10:02:27','2025-11-23 10:02:35','2025-11-23 10:02:35',1),(9,'00239b46-6054-46d2-84ed-b2294c5fce4b','tempest-tag-2010008969','2025-11-23 10:02:27','2025-11-23 10:02:35','2025-11-23 10:02:35',1),(10,'41af96d9-5ef7-4354-b0af-b42156a4865c','tempest-tag-710044162','2025-11-23 10:02:28','2025-11-23 10:02:34','2025-11-23 10:02:34',1),(11,'41af96d9-5ef7-4354-b0af-b42156a4865c','tempest-tag-678054290','2025-11-23 10:02:28','2025-11-23 10:02:34','2025-11-23 10:02:34',1),(12,'bad85794-35e9-451d-bdef-43be8a8bfa3f','tempest-tag-1594035803','2025-11-23 10:02:29','2025-11-23 10:02:32','2025-11-23 10:02:32',1),(13,'bad85794-35e9-451d-bdef-43be8a8bfa3f','tempest-tag-1822479323','2025-11-23 10:02:29','2025-11-23 10:02:32','2025-11-23 10:02:32',1);
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1)),
  CONSTRAINT `CONSTRAINT_4` CHECK (`os_hidden` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('00239b46-6054-46d2-84ed-b2294c5fce4b','tempest-ListUserImagesTest-image-723228390',3320,'deleted','2025-11-23 10:02:27','2025-11-23 10:02:35','2025-11-23 10:02:35',1,'ari','bare','7299d458282a4db29f5731b4c10653a1','25f380ddbf5c49989fe156e2d6c59327',0,0,0,NULL,'private',0,'sha512','cad44a30d73b8940ec3c02b2f462c11dff9363088f236d6b4d24c88058cbb7e73ec13edce79d3113ac0c2e592399c31378960f8461bfbc623b4f31030ea7dc04'),('0f5254c9-cebf-43d2-ae20-8c4276ec167d','tempest-ImagesMemberNegativeTest-image-601911284',NULL,'deleted','2025-11-23 10:00:36','2025-11-23 10:00:36','2025-11-23 10:00:36',1,'raw','bare',NULL,'361bacca17df46b5abf7d594792a05ea',0,0,0,NULL,'shared',0,NULL,NULL),('0fb03e46-583e-40ac-af1b-e9d1b012446b','tempest-image-1416286697',1024,'deleted','2025-11-23 09:59:09','2025-11-23 09:59:11','2025-11-23 09:59:11',1,'qcow2','bare','ad1e7232100798d02af0e0a02d2b3cd8','3e21df5084b344fd9c4fc050a93e2dcc',0,0,0,NULL,'private',0,'sha512','b0bffd59b30fe2551d17de35c19a5e6825fce9b14e3ed9c02d64cc7579e30111204621936f930133b889d673355fc079b11c62936468e7951c1694f19c751e2a'),('15ac1a3b-e12f-43e5-8f5b-29b480ee320a','tempest-ImagesMemberTest-image-713904438',NULL,'deleted','2025-11-23 10:03:12','2025-11-23 10:03:12','2025-11-23 10:03:12',1,'raw','bare',NULL,'2cbb5cf1bf5d40d29c4bb584ea0110f0',0,0,0,NULL,'shared',0,NULL,NULL),('18805c02-9f8c-41f8-8cb2-f5253d9a1692','tempest-test-1475151278',NULL,'queued','2025-11-23 09:58:53','2025-11-23 09:58:54',NULL,0,'raw','bare',NULL,'eb8cffa83c1147c7baa506c6fbdf1234',0,0,0,NULL,'shared',0,NULL,NULL),('1ba6c606-f5f5-4d9a-9a08-48ec26e813d0','tempest-ImagesTagsNegativeTest-image-1164338501',NULL,'deleted','2025-11-23 09:59:48','2025-11-23 09:59:48','2025-11-23 09:59:48',1,'raw','bare',NULL,'48734328ac974be39fbe56aae790aa24',0,0,0,NULL,'private',0,NULL,NULL),('1bb8d4e0-9910-4851-8ef4-21a76383aa02','tempest-ImagesMemberNegativeTest-image-1733864760',NULL,'deleted','2025-11-23 10:00:35','2025-11-23 10:00:36','2025-11-23 10:00:36',1,'raw','bare',NULL,'361bacca17df46b5abf7d594792a05ea',0,0,0,NULL,'shared',0,NULL,NULL),('322f922f-ef29-42be-b2e7-4a48eba5eaa4','tempest-image-441374891',1755,'deleted','2025-11-23 09:59:32','2025-11-23 09:59:36','2025-11-23 09:59:36',1,'qcow2','bare','dcf0817d26f74f3f258e98f6eed860dc','b2bac91a08554ba7a6696587ae9017ca',0,129,0,NULL,'private',0,'sha512','7eb1fe1907e00b832488a0cc64b348b765a71c24f9071e67b4b69eaf6a3c01fce63e9044c5d286ee8fa8e1d60a20b8ed3b348d6f70cd1fff0a0863413106106e'),('361271f8-fbd5-4f3b-b29e-858aa4b85bb2','tempest-ListUserImagesTest-image-2008829653',3366,'deleted','2025-11-23 10:02:25','2025-11-23 10:02:40','2025-11-23 10:02:40',1,'raw','bare','a897f9e8e684a062ba9b189316163a55','25f380ddbf5c49989fe156e2d6c59327',0,0,0,3366,'private',0,'sha512','c6f469f4e0e97b2ed68575fadeeedd55c30169f2ffe4fabc4de30cad0a94baa405a739c3f1ccc7f4ffa4bdeec422da0243b3ce8b6009f6bf1a25ae77d04d6619'),('39d5a714-5239-4b0c-887d-fad7496b173e',NULL,NULL,'deleted','2025-11-23 09:59:16','2025-11-23 09:59:16','2025-11-23 09:59:16',1,'raw','bare',NULL,'369b69282415490bb68e64d1156d0f01',0,0,0,NULL,'shared',0,NULL,NULL),('3d8b6e86-3603-44d7-b163-3e2f3e604009','tempest-VolumesActionsTest-Image-840288026',1073741824,'deleted','2025-11-23 10:06:36','2025-11-23 10:07:23','2025-11-23 10:07:23',1,'raw','bare','cd573cfaace07e7949bc0c46028904ff','33c4eecf43aa413a9f282206f9e9a55b',0,0,0,1073741824,'shared',0,'sha512','c5041ae163cf0f65600acfe7f6a63f212101687d41a57a4e18ffd2a07a452cd8175b8f5a4868dd2330bfe5ae123f18216bdbc9e0f80d131e64b94913a7b40bb5'),('3f761950-3231-4c70-85ef-8433ed4da37b','tempest-BasicOperationsImagesAdminTest-Image-1241988790',NULL,'deleted','2025-11-23 09:59:16','2025-11-23 09:59:17','2025-11-23 09:59:17',1,'raw','bare',NULL,'9035412fa38e41eabeb631b45701ca46',0,0,0,NULL,'public',0,NULL,NULL),('413ff85a-3b62-4678-8098-792ff94c34b4',NULL,NULL,'deleted','2025-11-23 10:02:30','2025-11-23 10:02:30','2025-11-23 10:02:30',1,NULL,NULL,NULL,'25f380ddbf5c49989fe156e2d6c59327',0,0,0,NULL,'shared',1,NULL,NULL),('41af96d9-5ef7-4354-b0af-b42156a4865c','tempest-ListUserImagesTest-image-1237222396',1393,'deleted','2025-11-23 10:02:28','2025-11-23 10:02:34','2025-11-23 10:02:34',1,'aki','bare','7ac4eced3da1370f4330092befca4616','25f380ddbf5c49989fe156e2d6c59327',0,0,0,NULL,'private',0,'sha512','9501aafb2ab0960271d7ea84e56a4a90bdbd10e5fe1b15cbcea38449404a3b5542aa399969155c775e8f2d226264f709188ff7b48a86174de4aac3b7dbf55e79'),('425faee4-c9bd-4a82-bf28-3c502e5e6ae1','tempest-image-1807710774',117440512,'deleted','2025-11-23 10:02:09','2025-11-23 10:02:19','2025-11-23 10:02:19',1,'raw','bare','4245576e3df99ea1211871b8b9514d3b','0785fa8a58414d8e81fd45533196bc83',0,0,0,117440512,'private',0,'sha512','dbb480bdc4f13ead7e00b62766df2815ddc8d4775af8a82ec40f8afd433d4cb95a109a58fbe7e0a661be86e0a06321c00362bc881f58c61c40bd2d1486954594'),('432b4f93-3163-4ee0-8f7d-2f0f584caf72','tempest-test-1539590431',NULL,'deleted','2025-11-23 10:03:21','2025-11-23 10:03:21','2025-11-23 10:03:21',1,'raw','bare',NULL,'ba5b901fe0854e769979829951316736',0,0,0,NULL,'shared',0,NULL,NULL),('46a57ad3-3b53-41f1-92ad-988656b6cd0a','tempest-task_image-1209768605',NULL,'deleted','2025-11-23 09:58:56','2025-11-23 09:58:56','2025-11-23 09:58:56',1,'qcow2','bare',NULL,NULL,0,0,0,NULL,'public',0,NULL,NULL),('4cd3d802-f16b-41b2-8c63-95122732fe22','tempest-image-479678338',1024,'deleted','2025-11-23 09:59:07','2025-11-23 09:59:12','2025-11-23 09:59:12',1,'raw','bare','0fc7bd6bc0851e1c5785a96124b5842f','3e21df5084b344fd9c4fc050a93e2dcc',0,0,0,1024,'private',0,'sha512','8ca4f19ecac12cc42e2f1176db27c5c5b9c0f34025188b969ea87e082ad5713d43f9a20ac5fee2762ae5788f3bbba9d879ab558866d4e2e7457dffe94d986c23'),('534da7f1-dcfd-4b81-bcde-a92b5e35f65e','tempest-ListUserImagesTest-image-1374243694',NULL,'deleted','2025-11-23 10:02:31','2025-11-23 10:02:31','2025-11-23 10:02:31',1,NULL,NULL,NULL,'25f380ddbf5c49989fe156e2d6c59327',0,0,0,NULL,'shared',1,NULL,NULL),('621c31e5-c2c6-4d56-83fb-f5ae5bbcd0e4','tempest-ImagesMemberTest-image-610543328',NULL,'deleted','2025-11-23 10:03:12','2025-11-23 10:03:12','2025-11-23 10:03:12',1,'raw','bare',NULL,'2cbb5cf1bf5d40d29c4bb584ea0110f0',0,0,0,NULL,'shared',0,NULL,NULL),('6af836e7-49e9-4253-9317-8d8e424b9245','tempest-ListSharedImagesTest-image-199177549',2048,'deleted','2025-11-23 09:59:39','2025-11-23 09:59:42','2025-11-23 09:59:42',1,'qcow2','bare','c082fe84ea9caac6972b3154d5dd6c98','09bcdf0c2fec4bf5991d15e58003cf56',0,0,0,NULL,'shared',0,'sha512','4edde16304b25879bfae85628c122d1fd91482212db7392c524a412e4c06f93381b95a20bb31af008dd5bb056d30d17f5e18e477d2585a334f0600d9e40d3e8e'),('7b536e06-7fe2-4119-9fc2-da2a16cd53e7','tempest-image-1102168190',1024,'deleted','2025-11-23 09:57:54','2025-11-23 09:58:00','2025-11-23 09:58:00',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','33a17fcfa4c048639f42338510068d72',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('7d8d0aaa-9efa-492f-8f1e-5a64ec0cbf0d','tempest-ListUserImagesTest-image-898917646',2790,'deleted','2025-11-23 10:02:24','2025-11-23 10:02:42','2025-11-23 10:02:42',1,'qcow2','bare','c2ade0f0313b6c2c6f74b77b1af76cc3','25f380ddbf5c49989fe156e2d6c59327',0,0,0,NULL,'private',0,'sha512','db2d0bf77542658337a9e79f92f3fbce1c29b78268bc9d8597ae00022b93e9498004da0dbe70c6527bdea4662f5ea3dacb19fd70287bd52977846136a53b8069'),('7ff19ec8-b33a-4365-b738-cfaa2a3c2aeb','tempest-UnshelveToHostMultiNodesTest-server-2005076685-shelved',1073741824,'deleted','2025-11-23 09:58:37','2025-11-23 09:59:15','2025-11-23 09:59:15',1,'raw','bare',NULL,'37a58b702f564a81ab5a59cf4201b4f0',1,0,0,NULL,'private',0,NULL,NULL),('83f805d1-158b-4aff-9c58-5b27a31c2297','tempest-scenario-img--67436083',21430272,'deleted','2025-11-23 10:07:31','2025-11-23 10:07:35','2025-11-23 10:07:35',1,'qcow2','bare','c8fc807773e5354afe61636071771906','7f48fa865c4047a080902678e51be06e',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('84645e6e-2fd2-4eba-8eaf-2c9178459c11','tempest-test-551044737',NULL,'deleted','2025-11-23 10:03:21','2025-11-23 10:03:21','2025-11-23 10:03:21',1,'raw','bare',NULL,'ba5b901fe0854e769979829951316736',0,0,0,NULL,'shared',0,NULL,NULL),('85d9fbd7-cdc9-4ab6-8a5d-aa6dfdeecc3a',NULL,NULL,'deleted','2025-11-23 09:59:17','2025-11-23 09:59:17','2025-11-23 09:59:17',1,'raw','bare',NULL,'95a6036984f74627a073e66c8e25994f',0,0,0,NULL,'shared',0,NULL,NULL),('88a780a0-871c-4b0c-a443-908ecaccee14','tempest-test-747480362',NULL,'deleted','2025-11-23 10:03:20','2025-11-23 10:03:21','2025-11-23 10:03:21',1,NULL,NULL,NULL,'ba5b901fe0854e769979829951316736',0,0,0,NULL,'shared',0,NULL,NULL),('8e9a94f9-069b-4255-9245-e90c2ca157d0','tempest-image-1623887827',1024,'deleted','2025-11-23 10:02:07','2025-11-23 10:02:20','2025-11-23 10:02:20',1,'raw','bare','56c081c27b730a049841f59163117465','0785fa8a58414d8e81fd45533196bc83',0,0,0,1024,'private',0,'sha512','bda6778aa265a1d68d23c70473a188b3e644169c11950ab29d2a70278290c75c427a107f85b4d13c381b58fd6175ae08561a159be32c4207d350bb0ce538f69d'),('97add930-198b-47db-b6d3-3bcb8d6f1b87','tempest-ImagesMemberTest-image-1005506796',NULL,'deleted','2025-11-23 10:03:12','2025-11-23 10:03:12','2025-11-23 10:03:12',1,'raw','bare',NULL,'2cbb5cf1bf5d40d29c4bb584ea0110f0',0,0,0,NULL,'shared',0,NULL,NULL),('989d18a2-a219-493d-b08a-54238ff893dd','tempest-VolumesNegativeTest-image-824703483',1024,'deleted','2025-11-23 10:04:20','2025-11-23 10:04:24','2025-11-23 10:04:24',1,'qcow2','bare','4f055d316303a0041a2367b7d6a199d9','357e082a3fb74c17977fb3ffe7ad4261',2,0,0,NULL,'private',0,'sha512','7c2295aa0ad551d6b43f67655747c3c0a1c79f58ffcbf8a355828c2eee7d0d99d39f428b3ca3a196acf6daddc3aaa669426def83bbfea5cf754a61a2d27d48ce'),('afe8b5ec-cd2f-442c-8842-c740006a370c','tempest-new-image-1989073286',NULL,'deleted','2025-11-23 09:59:10','2025-11-23 09:59:10','2025-11-23 09:59:10',1,'qcow2','bare',NULL,'3e21df5084b344fd9c4fc050a93e2dcc',0,0,0,NULL,'private',0,NULL,NULL),('b0fd3242-4ce6-4536-8f08-d1932c0f3ccb','tempest-VolumesNegativeTest-image-1266544340',1024,'deleted','2025-11-23 10:04:16','2025-11-23 10:04:20','2025-11-23 10:04:20',1,'qcow2','bare','458641e540a26a135ad7cc38d1f014fe','357e082a3fb74c17977fb3ffe7ad4261',2,0,0,NULL,'private',0,'sha512','1855af243dffc65c349a6f4e8c6828237259328479e0f48a64cac2fb576963e3dd0d108ef8e5ee70c9bd56bcdab7d709b034791ddda998af36d445502a660e22'),('b6d724dc-26d8-4b53-bc02-990c8b280c9a','tempest-UnshelveToHostMultiNodesTest-server-2005076685-shelved',1073741824,'deleted','2025-11-23 09:59:16','2025-11-23 09:59:44','2025-11-23 09:59:44',1,'raw','bare',NULL,'37a58b702f564a81ab5a59cf4201b4f0',1,0,0,NULL,'private',0,NULL,NULL),('b89f9d0c-aa7b-4f1c-97b3-cfaa0a01ff99','tempest-ImagesTagsTest-image-960591026',NULL,'deleted','2025-11-23 10:00:21','2025-11-23 10:00:22','2025-11-23 10:00:22',1,'raw','bare',NULL,'a2a612a279c1457a95570949ffe454dd',0,0,0,NULL,'private',0,NULL,NULL),('bad85794-35e9-451d-bdef-43be8a8bfa3f','tempest-ListUserImagesTest-image-83183909',3625,'deleted','2025-11-23 10:02:29','2025-11-23 10:02:32','2025-11-23 10:02:32',1,'vhd','bare','97651ce3e522b3be0caef86719dd16c2','25f380ddbf5c49989fe156e2d6c59327',0,0,0,NULL,'private',0,'sha512','0ec809b122208f6c81132b6dbf048617c555e1a3524eca9e7429f78809e22fe20ad4cf50985be784527e4df142d636e7b0717b75ad7eeb6828f5c8cb42b62ecf'),('be9a09b1-b916-4d06-9bcd-d8b8afdf9284','cirros',21692416,'active','2025-11-23 08:24:27','2025-11-23 08:24:31',NULL,0,'qcow2','bare','87617e24a5e30cb3b87fda8c0764838f','1915d3e5d4254231a0517e2dcf35848f',0,0,0,117440512,'shared',0,'sha512','9a9bce0083a00939ec17c11febbfc767aa211aaa54f51e75c5a8b271a9b5637c77205a518b7a2007cb391d23cceb01e0e4e8d64832317151bc85b734b92a7be0'),('c5806483-57a8-4254-b41b-254b888c8606','cirros-0.6.2-x86_64-disk.img',21430272,'active','2025-11-23 09:56:45','2025-11-23 09:56:47',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','1915d3e5d4254231a0517e2dcf35848f',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('db545b98-5d22-49b0-85fe-f8d3a871776f','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2025-11-23 09:56:47','2025-11-23 09:56:49',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','1915d3e5d4254231a0517e2dcf35848f',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('de90ef18-f210-4e28-b93b-f2cc964f8edb','tempest-image-1562961058',NULL,'deleted','2025-11-23 09:59:09','2025-11-23 09:59:09','2025-11-23 09:59:09',1,'qcow2','bare',NULL,'3e21df5084b344fd9c4fc050a93e2dcc',0,0,0,NULL,'private',0,NULL,NULL),('eb312786-be3b-45ea-94b5-0f9a228cf5d4','tempest-ListUserImagesTest-image-1538807996',3658,'deleted','2025-11-23 10:02:26','2025-11-23 10:02:38','2025-11-23 10:02:38',1,'ami','bare','6a927f149302d498191d695db5915a50','25f380ddbf5c49989fe156e2d6c59327',0,0,0,NULL,'private',0,'sha512','c19edb705377d7ee921de3d50712495ed5bb58a2e4d56496d6c1d5454008ea119c1c9061773528daa0bafc5542dd9a385330571a100391d727e81c4c27b09c13'),('ebb67f6d-50dd-4e76-9b6c-0af8014fd05a','tempest-ImagesMemberTest-image-1129069631',NULL,'deleted','2025-11-23 10:03:11','2025-11-23 10:03:12','2025-11-23 10:03:12',1,'raw','bare',NULL,'2cbb5cf1bf5d40d29c4bb584ea0110f0',0,0,0,NULL,'shared',0,NULL,NULL);
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (2,2,'image','CIM_PASD_','2025-11-23 08:07:41',NULL),(2,5,'image','CIM_RASD_','2025-11-23 08:07:42',NULL),(2,8,NULL,'CIM_SASD_','2025-11-23 08:07:42',NULL),(2,23,'image','hw_','2025-11-23 08:07:44',NULL),(2,26,'image','hw_','2025-11-23 08:07:44',NULL),(2,38,'image',NULL,'2025-11-23 08:07:45',NULL),(2,53,'image','hw_','2025-11-23 08:07:47',NULL),(2,65,'image','hw_','2025-11-23 08:07:48',NULL),(2,77,'image',NULL,'2025-11-23 08:07:48',NULL),(2,80,'image',NULL,'2025-11-23 08:07:49',NULL),(2,83,'image',NULL,'2025-11-23 08:07:49',NULL),(2,86,'image',NULL,'2025-11-23 08:07:50',NULL),(5,2,NULL,'CIM_PASD_','2025-11-23 08:07:41',NULL),(5,23,NULL,'hw_','2025-11-23 08:07:43',NULL),(5,26,NULL,'hw_','2025-11-23 08:07:44',NULL),(5,29,NULL,NULL,'2025-11-23 08:07:44',NULL),(5,35,NULL,NULL,'2025-11-23 08:07:45',NULL),(5,38,NULL,NULL,'2025-11-23 08:07:45',NULL),(5,41,NULL,NULL,'2025-11-23 08:07:45',NULL),(5,44,NULL,'hw_','2025-11-23 08:07:46',NULL),(5,53,NULL,'hw_','2025-11-23 08:07:47',NULL),(5,62,NULL,NULL,'2025-11-23 08:07:47',NULL),(5,65,NULL,'hw_','2025-11-23 08:07:48',NULL),(5,68,NULL,NULL,'2025-11-23 08:07:48',NULL),(5,74,NULL,NULL,'2025-11-23 08:07:48',NULL),(5,77,NULL,NULL,'2025-11-23 08:07:48',NULL),(5,80,NULL,NULL,'2025-11-23 08:07:48',NULL),(5,83,NULL,NULL,'2025-11-23 08:07:49',NULL),(5,86,NULL,NULL,'2025-11-23 08:07:50',NULL),(5,89,NULL,'cinder_','2025-11-23 08:07:50',NULL),(5,92,NULL,'hw_','2025-11-23 08:44:48',NULL),(5,93,NULL,'hw_','2025-11-23 08:44:48',NULL),(5,94,NULL,'traits:','2025-11-23 08:44:48',NULL),(8,2,NULL,'CIM_PASD_','2025-11-23 08:07:41',NULL),(8,5,NULL,'CIM_RASD_','2025-11-23 08:07:42',NULL),(8,8,NULL,'CIM_SASD_','2025-11-23 08:07:42',NULL),(8,11,NULL,'CIM_VSSD_','2025-11-23 08:07:43',NULL),(8,14,NULL,NULL,'2025-11-23 08:07:43',NULL),(8,17,NULL,NULL,'2025-11-23 08:07:43',NULL),(8,20,NULL,NULL,'2025-11-23 08:07:43',NULL),(8,32,NULL,'aggregate_instance_extra_specs:','2025-11-23 08:07:44',NULL),(11,2,NULL,'CIM_PASD_','2025-11-23 08:07:41',NULL),(11,5,NULL,'CIM_RASD_','2025-11-23 08:07:42',NULL),(11,8,NULL,'CIM_SASD_','2025-11-23 08:07:42',NULL),(11,11,NULL,'CIM_VSSD_','2025-11-23 08:07:43',NULL),(11,23,NULL,'hw:','2025-11-23 08:07:44',NULL),(11,26,NULL,'hw:','2025-11-23 08:07:44',NULL),(11,32,NULL,'capabilities:','2025-11-23 08:07:44',NULL),(11,44,NULL,'hw:','2025-11-23 08:07:46',NULL),(11,47,NULL,NULL,'2025-11-23 08:07:46',NULL),(11,50,NULL,NULL,'2025-11-23 08:07:46',NULL),(11,53,NULL,'hw:','2025-11-23 08:07:47',NULL),(11,56,NULL,NULL,'2025-11-23 08:07:47',NULL),(11,59,NULL,NULL,'2025-11-23 08:07:47',NULL),(11,65,NULL,'hw:','2025-11-23 08:07:48',NULL),(11,92,NULL,'hw:','2025-11-23 08:44:48',NULL),(11,93,NULL,'hw:','2025-11-23 08:44:48',NULL),(11,94,NULL,'traits:','2025-11-23 08:44:48',NULL),(14,2,'scheduler_hints',NULL,'2025-11-23 08:07:41',NULL),(14,80,'metadata',NULL,'2025-11-23 08:07:49',NULL),(14,83,'metadata',NULL,'2025-11-23 08:07:49',NULL),(14,86,'metadata',NULL,'2025-11-23 08:07:50',NULL),(17,80,NULL,NULL,'2025-11-23 08:07:49',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=103 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (2,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2025-11-23 08:07:41',NULL),(5,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2025-11-23 08:07:42',NULL),(8,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2025-11-23 08:07:42',NULL),(11,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2025-11-23 08:07:43',NULL),(14,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-11-23 08:07:43',NULL),(17,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-11-23 08:07:43',NULL),(20,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2025-11-23 08:07:43',NULL),(23,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2025-11-23 08:07:43',NULL),(26,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2025-11-23 08:07:44',NULL),(29,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2025-11-23 08:07:44',NULL),(32,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2025-11-23 08:07:44',NULL),(35,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2025-11-23 08:07:44',NULL),(38,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2025-11-23 08:07:45',NULL),(41,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-23 08:07:45',NULL),(44,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-23 08:07:46',NULL),(47,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-23 08:07:46',NULL),(50,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2025-11-23 08:07:46',NULL),(53,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2025-11-23 08:07:47',NULL),(56,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-23 08:07:47',NULL),(59,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-23 08:07:47',NULL),(62,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-23 08:07:47',NULL),(65,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-23 08:07:48',NULL),(68,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-23 08:07:48',NULL),(71,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2025-11-23 08:07:48',NULL),(74,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2025-11-23 08:07:48',NULL),(77,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2025-11-23 08:07:48',NULL),(80,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2025-11-23 08:07:48',NULL),(83,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2025-11-23 08:07:49',NULL),(86,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2025-11-23 08:07:50',NULL),(89,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2025-11-23 08:07:50',NULL),(92,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2025-11-23 08:44:48',NULL),(93,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2025-11-23 08:44:48',NULL),(94,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2025-11-23 08:44:48',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (2,47,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2025-11-23 08:07:46',NULL),(5,47,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2025-11-23 08:07:46',NULL),(8,47,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2025-11-23 08:07:46',NULL),(11,80,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2025-11-23 08:07:49',NULL),(14,80,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2025-11-23 08:07:49',NULL),(17,80,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2025-11-23 08:07:49',NULL),(20,80,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2025-11-23 08:07:49',NULL),(23,80,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-11-23 08:07:49',NULL),(26,80,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-11-23 08:07:49',NULL),(29,80,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-11-23 08:07:49',NULL),(32,80,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-11-23 08:07:49',NULL),(35,80,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-11-23 08:07:49',NULL),(38,80,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2025-11-23 08:07:49',NULL),(41,80,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2025-11-23 08:07:49',NULL),(44,80,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2025-11-23 08:07:49',NULL),(47,83,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2025-11-23 08:07:49',NULL),(50,83,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2025-11-23 08:07:49',NULL),(53,83,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2025-11-23 08:07:49',NULL),(56,83,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2025-11-23 08:07:50',NULL),(59,83,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2025-11-23 08:07:50',NULL),(62,86,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-11-23 08:07:50',NULL),(65,86,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-11-23 08:07:50',NULL),(68,86,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-11-23 08:07:50',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=388 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (2,2,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2025-11-23 08:07:41',NULL),(5,2,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2025-11-23 08:07:41',NULL),(8,2,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2025-11-23 08:07:42',NULL),(11,5,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2025-11-23 08:07:42',NULL),(14,5,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2025-11-23 08:07:42',NULL),(17,5,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2025-11-23 08:07:42',NULL),(20,5,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2025-11-23 08:07:42',NULL),(23,5,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2025-11-23 08:07:42',NULL),(26,5,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-11-23 08:07:42',NULL),(29,5,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2025-11-23 08:07:42',NULL),(32,5,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2025-11-23 08:07:42',NULL),(35,5,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2025-11-23 08:07:42',NULL),(38,5,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2025-11-23 08:07:42',NULL),(41,5,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2025-11-23 08:07:42',NULL),(44,5,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2025-11-23 08:07:42',NULL),(47,5,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2025-11-23 08:07:42',NULL),(50,5,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-11-23 08:07:42',NULL),(53,5,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2025-11-23 08:07:42',NULL),(56,5,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-11-23 08:07:42',NULL),(59,5,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2025-11-23 08:07:42',NULL),(62,5,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2025-11-23 08:07:42',NULL),(65,5,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2025-11-23 08:07:42',NULL),(68,8,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2025-11-23 08:07:42',NULL),(71,8,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2025-11-23 08:07:42',NULL),(74,8,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2025-11-23 08:07:42',NULL),(77,8,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2025-11-23 08:07:42',NULL),(80,8,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2025-11-23 08:07:42',NULL),(83,8,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-11-23 08:07:42',NULL),(86,8,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-11-23 08:07:42',NULL),(89,8,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2025-11-23 08:07:42',NULL),(92,8,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2025-11-23 08:07:42',NULL),(95,8,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-11-23 08:07:42',NULL),(98,8,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2025-11-23 08:07:42',NULL),(101,8,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-11-23 08:07:43',NULL),(104,8,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-11-23 08:07:43',NULL),(107,11,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2025-11-23 08:07:43',NULL),(110,11,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2025-11-23 08:07:43',NULL),(113,11,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2025-11-23 08:07:43',NULL),(116,11,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2025-11-23 08:07:43',NULL),(119,11,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2025-11-23 08:07:43',NULL),(122,11,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-11-23 08:07:43',NULL),(125,11,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-11-23 08:07:43',NULL),(128,11,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2025-11-23 08:07:43',NULL),(131,11,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2025-11-23 08:07:43',NULL),(134,11,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2025-11-23 08:07:43',NULL),(137,11,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2025-11-23 08:07:43',NULL),(140,11,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2025-11-23 08:07:43',NULL),(143,11,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2025-11-23 08:07:43',NULL),(146,11,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2025-11-23 08:07:43',NULL),(149,11,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2025-11-23 08:07:43',NULL),(152,11,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2025-11-23 08:07:43',NULL),(155,11,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2025-11-23 08:07:43',NULL),(158,14,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2025-11-23 08:07:43',NULL),(161,17,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2025-11-23 08:07:43',NULL),(164,20,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2025-11-23 08:07:43',NULL),(167,23,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2025-11-23 08:07:44',NULL),(170,23,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2025-11-23 08:07:44',NULL),(173,26,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2025-11-23 08:07:44',NULL),(176,29,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-23 08:07:44',NULL),(179,32,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2025-11-23 08:07:44',NULL),(182,32,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2025-11-23 08:07:44',NULL),(185,32,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2025-11-23 08:07:44',NULL),(188,32,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-11-23 08:07:44',NULL),(191,32,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-11-23 08:07:44',NULL),(194,32,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-11-23 08:07:44',NULL),(197,32,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2025-11-23 08:07:44',NULL),(200,35,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2025-11-23 08:07:45',NULL),(203,35,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2025-11-23 08:07:45',NULL),(206,38,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2025-11-23 08:07:45',NULL),(209,38,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-11-23 08:07:45',NULL),(212,41,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-11-23 08:07:45',NULL),(215,41,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-11-23 08:07:45',NULL),(218,41,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2025-11-23 08:07:45',NULL),(221,41,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2025-11-23 08:07:45',NULL),(224,41,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2025-11-23 08:07:45',NULL),(227,41,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2025-11-23 08:07:45',NULL),(230,41,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\"]}','2025-11-23 08:07:45',NULL),(233,41,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-23 08:07:45',NULL),(236,41,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2025-11-23 08:07:45',NULL),(239,41,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2025-11-23 08:07:45',NULL),(242,41,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, and virtio. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\"]}','2025-11-23 08:07:46',NULL),(245,41,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-23 08:07:46',NULL),(248,41,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-23 08:07:46',NULL),(251,41,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-11-23 08:07:46',NULL),(254,41,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2025-11-23 08:07:46',NULL),(257,41,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-11-23 08:07:46',NULL),(260,44,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-23 08:07:46',NULL),(263,44,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-23 08:07:46',NULL),(266,44,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-23 08:07:46',NULL),(269,50,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2025-11-23 08:07:46',NULL),(272,50,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2025-11-23 08:07:46',NULL),(275,50,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2025-11-23 08:07:47',NULL),(278,53,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-11-23 08:07:47',NULL),(281,53,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-11-23 08:07:47',NULL),(284,53,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-11-23 08:07:47',NULL),(287,53,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-11-23 08:07:47',NULL),(290,53,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-11-23 08:07:47',NULL),(293,53,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-11-23 08:07:47',NULL),(296,56,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2025-11-23 08:07:47',NULL),(299,56,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2025-11-23 08:07:47',NULL),(302,59,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-23 08:07:47',NULL),(305,59,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-23 08:07:47',NULL),(308,62,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2025-11-23 08:07:47',NULL),(311,62,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2025-11-23 08:07:48',NULL),(314,62,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2025-11-23 08:07:48',NULL),(317,62,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2025-11-23 08:07:48',NULL),(320,62,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, VirtualSriovEthernetCard, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualSriovEthernetCard\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2025-11-23 08:07:48',NULL),(323,62,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-23 08:07:48',NULL),(326,65,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2025-11-23 08:07:48',NULL),(329,68,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2025-11-23 08:07:48',NULL),(332,71,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2025-11-23 08:07:48',NULL),(335,71,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2025-11-23 08:07:48',NULL),(338,71,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2025-11-23 08:07:48',NULL),(341,71,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2025-11-23 08:07:48',NULL),(344,71,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-11-23 08:07:48',NULL),(347,71,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-11-23 08:07:48',NULL),(350,71,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2025-11-23 08:07:48',NULL),(353,71,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2025-11-23 08:07:48',NULL),(356,71,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2025-11-23 08:07:48',NULL),(359,74,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2025-11-23 08:07:48',NULL),(362,74,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2025-11-23 08:07:48',NULL),(365,74,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2025-11-23 08:07:48',NULL),(368,74,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2025-11-23 08:07:48',NULL),(371,77,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-11-23 08:07:48',NULL),(374,77,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-11-23 08:07:48',NULL),(377,77,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2025-11-23 08:07:48',NULL),(380,89,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2025-11-23 08:07:50',NULL),(383,92,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2025-11-23 08:44:48',NULL),(384,93,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2025-11-23 08:44:48',NULL),(385,94,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-11-23 08:44:48',NULL),(386,94,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-11-23 08:44:48',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (2,'OS::Cinder::Volume',1,'2025-11-23 08:07:41',NULL),(5,'OS::Glance::Image',1,'2025-11-23 08:07:41',NULL),(8,'OS::Nova::Aggregate',1,'2025-11-23 08:07:41',NULL),(11,'OS::Nova::Flavor',1,'2025-11-23 08:07:41',NULL),(14,'OS::Nova::Server',1,'2025-11-23 08:07:41',NULL),(17,'OS::Trove::Instance',1,'2025-11-23 08:07:49',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('Glance Migrations','/usr/lib/python3.9/site-packages/glance/db/sqlalchemy/migrate_repo',0);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
INSERT INTO `task_info` (`task_id`, `input`, `result`, `message`) VALUES ('77bd8297-8665-461d-8324-0ed5d76fd745','{\"image_id\": \"8e9a94f9-069b-4255-9245-e90c2ca157d0\", \"import_req\": {\"method\": {\"name\": \"glance-direct\"}, \"all_stores\": true}, \"backend\": [\"default_backend\"]}','{\"image_id\": \"8e9a94f9-069b-4255-9245-e90c2ca157d0\"}','Copied 0 MiB'),('c2a31744-624d-4ee0-bf20-fb49cd732b48','{\"image_id\": \"425faee4-c9bd-4a82-bf28-3c502e5e6ae1\", \"import_req\": {\"method\": {\"name\": \"web-download\", \"uri\": \"https://download.cirros-cloud.net/0.6.2/cirros-0.6.2-x86_64-disk.img\"}, \"all_stores\": true}, \"backend\": [\"default_backend\"]}','{\"image_id\": \"425faee4-c9bd-4a82-bf28-3c502e5e6ae1\"}','Copied 112 MiB'),('c86c0d03-e4db-441a-bca0-594649c73c8b','{\"image_properties\": {\"container_format\": \"bare\", \"disk_format\": \"qcow2\", \"visibility\": \"public\", \"name\": \"tempest-task_image-1209768605\"}, \"import_from_format\": \"qcow2\", \"import_from\": \"http://tempest-dummy-img-file-378827466.qcow2\"}',NULL,'Task failed due to Internal Error'),('f1c3168a-2905-41a4-8c13-09c76c0d4e2c','{\"image_id\": \"18805c02-9f8c-41f8-8cb2-f5253d9a1692\", \"import_req\": {\"method\": {\"name\": \"web-download\", \"uri\": \"http://does-not.exist/no/possible/way\"}, \"stores\": [\"default_backend\"]}, \"backend\": [\"default_backend\"]}',NULL,'Task failed due to Internal Error');
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
INSERT INTO `tasks` (`id`, `type`, `status`, `owner`, `expires_at`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `image_id`, `request_id`, `user_id`) VALUES ('77bd8297-8665-461d-8324-0ed5d76fd745','api_image_import','success','0785fa8a58414d8e81fd45533196bc83','2025-11-25 10:02:08','2025-11-23 10:02:07','2025-11-23 10:02:08',NULL,0,'8e9a94f9-069b-4255-9245-e90c2ca157d0','req-7c129428-14ae-4129-8a53-a19c3890338d','a3fef60ff660433baf42faa891d28931'),('c2a31744-624d-4ee0-bf20-fb49cd732b48','api_image_import','success','0785fa8a58414d8e81fd45533196bc83','2025-11-25 10:02:17','2025-11-23 10:02:09','2025-11-23 10:02:17',NULL,0,'425faee4-c9bd-4a82-bf28-3c502e5e6ae1','req-e651cd0e-f988-4ac9-9770-90ae9f8fc98a','a3fef60ff660433baf42faa891d28931'),('c86c0d03-e4db-441a-bca0-594649c73c8b','import','failure','d657447df3bc4b1390e511e45d3a7995','2025-11-25 09:58:56','2025-11-23 09:58:56','2025-11-23 09:58:56',NULL,0,NULL,'req-6ed4e830-ebff-4fcb-a600-37e8fee69236','20769659b53b494d80184a58cada712f'),('f1c3168a-2905-41a4-8c13-09c76c0d4e2c','api_image_import','failure','eb8cffa83c1147c7baa506c6fbdf1234','2025-11-25 09:58:54','2025-11-23 09:58:53','2025-11-23 09:58:54',NULL,0,'18805c02-9f8c-41f8-8cb2-f5253d9a1692','req-0ba0fc14-09d2-4abe-935d-2c3c524bef29','ce327431ed50438a933df74f96ea5e7b');
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `heat`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `heat` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `heat`;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `resource_action` varchar(255) DEFAULT NULL,
  `resource_status` varchar(255) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `physical_resource_id` varchar(255) DEFAULT NULL,
  `resource_status_reason` varchar(255) DEFAULT NULL,
  `resource_type` varchar(255) DEFAULT NULL,
  `resource_properties` blob DEFAULT NULL,
  `rsrc_prop_data_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `stack_id` (`stack_id`),
  KEY `ev_rsrc_prop_data_ref` (`rsrc_prop_data_id`),
  CONSTRAINT `ev_rsrc_prop_data_ref` FOREIGN KEY (`rsrc_prop_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `event_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `event`
--

LOCK TABLES `event` WRITE;
/*!40000 ALTER TABLE `event` DISABLE KEYS */;
/*!40000 ALTER TABLE `event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('heat','/usr/lib/python3.9/site-packages/heat/db/sqlalchemy/migrate_repo',86);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raw_template`
--

DROP TABLE IF EXISTS `raw_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `raw_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `template` longtext DEFAULT NULL,
  `files` longtext DEFAULT NULL,
  `environment` longtext DEFAULT NULL,
  `files_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_tmpl_files_fkey_ref` (`files_id`),
  CONSTRAINT `raw_tmpl_files_fkey_ref` FOREIGN KEY (`files_id`) REFERENCES `raw_template_files` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raw_template`
--

LOCK TABLES `raw_template` WRITE;
/*!40000 ALTER TABLE `raw_template` DISABLE KEYS */;
/*!40000 ALTER TABLE `raw_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raw_template_files`
--

DROP TABLE IF EXISTS `raw_template_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `raw_template_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `files` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raw_template_files`
--

LOCK TABLES `raw_template_files` WRITE;
/*!40000 ALTER TABLE `raw_template_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `raw_template_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource`
--

DROP TABLE IF EXISTS `resource`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `nova_instance` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  `rsrc_metadata` longtext DEFAULT NULL,
  `properties_data` longtext DEFAULT NULL,
  `engine_id` varchar(36) DEFAULT NULL,
  `atomic_key` int(11) DEFAULT NULL,
  `needed_by` longtext DEFAULT NULL,
  `requires` longtext DEFAULT NULL,
  `replaces` int(11) DEFAULT NULL,
  `replaced_by` int(11) DEFAULT NULL,
  `current_template_id` int(11) DEFAULT NULL,
  `properties_data_encrypted` tinyint(1) DEFAULT NULL,
  `root_stack_id` varchar(36) DEFAULT NULL,
  `rsrc_prop_data_id` int(11) DEFAULT NULL,
  `attr_data_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `stack_id` (`stack_id`),
  KEY `current_template_id` (`current_template_id`),
  KEY `ix_resource_root_stack_id` (`root_stack_id`),
  KEY `rsrc_rsrc_prop_data_ref` (`rsrc_prop_data_id`),
  KEY `rsrc_attr_data_ref` (`attr_data_id`),
  CONSTRAINT `resource_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`),
  CONSTRAINT `resource_ibfk_2` FOREIGN KEY (`current_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `rsrc_attr_data_ref` FOREIGN KEY (`attr_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `rsrc_rsrc_prop_data_ref` FOREIGN KEY (`rsrc_prop_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`properties_data_encrypted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource`
--

LOCK TABLES `resource` WRITE;
/*!40000 ALTER TABLE `resource` DISABLE KEYS */;
/*!40000 ALTER TABLE `resource` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_data`
--

DROP TABLE IF EXISTS `resource_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  `redact` tinyint(1) DEFAULT NULL,
  `decrypt_method` varchar(64) DEFAULT NULL,
  `resource_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_resource_id` (`resource_id`),
  CONSTRAINT `fk_resource_id` FOREIGN KEY (`resource_id`) REFERENCES `resource` (`id`) ON DELETE CASCADE,
  CONSTRAINT `CONSTRAINT_1` CHECK (`redact` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_data`
--

LOCK TABLES `resource_data` WRITE;
/*!40000 ALTER TABLE `resource_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `resource_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_properties_data`
--

DROP TABLE IF EXISTS `resource_properties_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource_properties_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `data` longtext DEFAULT NULL,
  `encrypted` tinyint(1) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`encrypted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_properties_data`
--

LOCK TABLES `resource_properties_data` WRITE;
/*!40000 ALTER TABLE `resource_properties_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `resource_properties_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(36) NOT NULL,
  `engine_id` varchar(36) NOT NULL,
  `host` varchar(255) NOT NULL,
  `hostname` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `topic` varchar(255) NOT NULL,
  `report_interval` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `engine_id`, `host`, `hostname`, `binary`, `topic`, `report_interval`, `created_at`, `updated_at`, `deleted_at`) VALUES ('04c043cf-0246-478b-aebb-e2025b3a6ce6','63e75443-6b49-4c7b-ad78-8a0d918a42a6','np0005532583.localdomain','np0005532583.localdomain','heat-engine','engine',60,'2025-11-23 08:12:35','2025-11-23 08:38:35',NULL),('0de88206-69f5-490d-8b66-f4d67a76c15c','1fd6d0af-14a1-47fc-9da9-904bfd1992b9','heat-engine-799587747-2v7jz','heat-engine-799587747-2v7jz','heat-engine','engine',60,'2025-11-23 08:53:48','2025-11-23 10:21:49',NULL),('37888df2-7507-4931-8cc6-9129349247d7','540f7dc7-b5e1-45de-b626-9f7b46752d7f','heat-engine-799587747-2v7jz','heat-engine-799587747-2v7jz','heat-engine','engine',60,'2025-11-23 08:53:48','2025-11-23 10:21:49',NULL),('5cc19a69-40a6-4ff9-b63a-5ea93d2fa223','47bffce6-47f2-4745-ba58-473577b8290d','np0005532582.localdomain','np0005532582.localdomain','heat-engine','engine',60,'2025-11-23 08:12:36','2025-11-23 08:38:36',NULL),('87b7a567-4399-4bb2-a3b1-897f1b5394a9','7bdccf46-7840-4776-aa2a-cda4ac6a0f20','heat-engine-799587747-2v7jz','heat-engine-799587747-2v7jz','heat-engine','engine',60,'2025-11-23 08:53:48','2025-11-23 10:21:49',NULL),('9b63cd16-74e3-40a0-a15b-e8de79ea8abf','e9563d7d-e502-4607-aaac-8d591521284d','heat-engine-799587747-2v7jz','heat-engine-799587747-2v7jz','heat-engine','engine',60,'2025-11-23 08:53:48','2025-11-23 10:21:49',NULL),('d499c9d8-158b-47ff-b353-8b98e6484c93','3631b760-9057-4ac3-9d81-6360f377d118','np0005532581.localdomain','np0005532581.localdomain','heat-engine','engine',60,'2025-11-23 08:12:21','2025-11-23 08:38:21',NULL);
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot`
--

DROP TABLE IF EXISTS `snapshot`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot` (
  `id` varchar(36) NOT NULL,
  `stack_id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` varchar(255) DEFAULT NULL,
  `data` longtext DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stack_id` (`stack_id`),
  KEY `ix_snapshot_tenant` (`tenant`),
  CONSTRAINT `snapshot_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot`
--

LOCK TABLES `snapshot` WRITE;
/*!40000 ALTER TABLE `snapshot` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `software_config`
--

DROP TABLE IF EXISTS `software_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `software_config` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `group` varchar(255) DEFAULT NULL,
  `config` longtext DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_software_config_tenant` (`tenant`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `software_config`
--

LOCK TABLES `software_config` WRITE;
/*!40000 ALTER TABLE `software_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `software_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `software_deployment`
--

DROP TABLE IF EXISTS `software_deployment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `software_deployment` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `server_id` varchar(36) NOT NULL,
  `config_id` varchar(36) NOT NULL,
  `input_values` longtext DEFAULT NULL,
  `output_values` longtext DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  `stack_user_project_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `config_id` (`config_id`),
  KEY `ix_software_deployment_server_id` (`server_id`),
  KEY `ix_software_deployment_tenant` (`tenant`),
  KEY `ix_software_deployment_created_at` (`created_at`),
  CONSTRAINT `software_deployment_ibfk_1` FOREIGN KEY (`config_id`) REFERENCES `software_config` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `software_deployment`
--

LOCK TABLES `software_deployment` WRITE;
/*!40000 ALTER TABLE `software_deployment` DISABLE KEYS */;
/*!40000 ALTER TABLE `software_deployment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack`
--

DROP TABLE IF EXISTS `stack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `raw_template_id` int(11) NOT NULL,
  `prev_raw_template_id` int(11) DEFAULT NULL,
  `user_creds_id` int(11) DEFAULT NULL,
  `username` varchar(256) DEFAULT NULL,
  `owner_id` varchar(36) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `timeout` int(11) DEFAULT NULL,
  `tenant` varchar(256) DEFAULT NULL,
  `disable_rollback` tinyint(1) NOT NULL,
  `stack_user_project_id` varchar(64) DEFAULT NULL,
  `backup` tinyint(1) DEFAULT NULL,
  `nested_depth` int(11) DEFAULT NULL,
  `convergence` tinyint(1) DEFAULT NULL,
  `current_traversal` varchar(36) DEFAULT NULL,
  `current_deps` longtext DEFAULT NULL,
  `parent_resource_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_template_id` (`raw_template_id`),
  KEY `prev_raw_template_id` (`prev_raw_template_id`),
  KEY `user_creds_id` (`user_creds_id`),
  KEY `ix_stack_owner_id` (`owner_id`),
  KEY `ix_stack_tenant` (`tenant`(255)),
  KEY `ix_stack_name` (`name`),
  CONSTRAINT `stack_ibfk_1` FOREIGN KEY (`raw_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `stack_ibfk_2` FOREIGN KEY (`prev_raw_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `stack_ibfk_3` FOREIGN KEY (`user_creds_id`) REFERENCES `user_creds` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`disable_rollback` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`backup` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`convergence` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack`
--

LOCK TABLES `stack` WRITE;
/*!40000 ALTER TABLE `stack` DISABLE KEYS */;
/*!40000 ALTER TABLE `stack` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack_lock`
--

DROP TABLE IF EXISTS `stack_lock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack_lock` (
  `stack_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `engine_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`stack_id`),
  CONSTRAINT `stack_lock_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack_lock`
--

LOCK TABLES `stack_lock` WRITE;
/*!40000 ALTER TABLE `stack_lock` DISABLE KEYS */;
/*!40000 ALTER TABLE `stack_lock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack_tag`
--

DROP TABLE IF EXISTS `stack_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `tag` varchar(80) DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stack_id` (`stack_id`),
  CONSTRAINT `stack_tag_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack_tag`
--

LOCK TABLES `stack_tag` WRITE;
/*!40000 ALTER TABLE `stack_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `stack_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_point`
--

DROP TABLE IF EXISTS `sync_point`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sync_point` (
  `entity_id` varchar(36) NOT NULL,
  `traversal_id` varchar(36) NOT NULL,
  `is_update` tinyint(1) NOT NULL,
  `atomic_key` int(11) NOT NULL,
  `stack_id` varchar(36) NOT NULL,
  `input_data` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`traversal_id`,`is_update`),
  KEY `fk_stack_id` (`stack_id`),
  CONSTRAINT `fk_stack_id` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`is_update` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_point`
--

LOCK TABLES `sync_point` WRITE;
/*!40000 ALTER TABLE `sync_point` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_point` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_creds`
--

DROP TABLE IF EXISTS `user_creds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_creds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `username` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `region_name` varchar(255) DEFAULT NULL,
  `decrypt_method` varchar(64) DEFAULT NULL,
  `tenant` varchar(1024) DEFAULT NULL,
  `auth_url` text DEFAULT NULL,
  `tenant_id` varchar(256) DEFAULT NULL,
  `trust_id` varchar(255) DEFAULT NULL,
  `trustor_user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_creds`
--

LOCK TABLES `user_creds` WRITE;
/*!40000 ALTER TABLE `user_creds` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_creds` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `external_id` (`external_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`inherited` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','0d60ddb8acff47408057d9cda84b946d','758f3043280349e086a85b86f2668848','0a5ee1d55fc44d64b287d84618dfeea8',0),('UserProject','0d60ddb8acff47408057d9cda84b946d','758f3043280349e086a85b86f2668848','c4632e0261e342218ab47c3a83624fb1',0),('UserProject','0ec240bbf59c4223a12e795fc058daed','758f3043280349e086a85b86f2668848','0a5ee1d55fc44d64b287d84618dfeea8',0),('UserProject','0ec240bbf59c4223a12e795fc058daed','758f3043280349e086a85b86f2668848','c4632e0261e342218ab47c3a83624fb1',0),('UserProject','1f11ad52b1994292a95b5c1dafb43f21','758f3043280349e086a85b86f2668848','0a5ee1d55fc44d64b287d84618dfeea8',0),('UserProject','1f11ad52b1994292a95b5c1dafb43f21','758f3043280349e086a85b86f2668848','c4632e0261e342218ab47c3a83624fb1',0),('UserProject','41c3607e24e148b1837d367730edaa25','758f3043280349e086a85b86f2668848','0a5ee1d55fc44d64b287d84618dfeea8',0),('UserProject','41c3607e24e148b1837d367730edaa25','758f3043280349e086a85b86f2668848','c4632e0261e342218ab47c3a83624fb1',0),('UserProject','4ff26e787d5c4a55922ffe05358b6090','758f3043280349e086a85b86f2668848','08b151a83a734ce8ac9b25ced346df45',0),('UserProject','4ff26e787d5c4a55922ffe05358b6090','758f3043280349e086a85b86f2668848','0a5ee1d55fc44d64b287d84618dfeea8',0),('UserProject','4ff26e787d5c4a55922ffe05358b6090','758f3043280349e086a85b86f2668848','c4632e0261e342218ab47c3a83624fb1',0),('UserProject','68e9921ed93e4036af7fae0a549ad682','758f3043280349e086a85b86f2668848','0a5ee1d55fc44d64b287d84618dfeea8',0),('UserProject','68e9921ed93e4036af7fae0a549ad682','758f3043280349e086a85b86f2668848','c4632e0261e342218ab47c3a83624fb1',0),('UserProject','73d8249924dd406db12ad13a4ddb31a1','758f3043280349e086a85b86f2668848','0a5ee1d55fc44d64b287d84618dfeea8',0),('UserProject','73d8249924dd406db12ad13a4ddb31a1','758f3043280349e086a85b86f2668848','c4632e0261e342218ab47c3a83624fb1',0),('UserProject','77ba14987a21452fbe8e9b8c33f4244a','758f3043280349e086a85b86f2668848','0a5ee1d55fc44d64b287d84618dfeea8',0),('UserProject','7e40ee99e6034be7be796ae12095c154','1915d3e5d4254231a0517e2dcf35848f','0a5ee1d55fc44d64b287d84618dfeea8',0),('UserProject','7e40ee99e6034be7be796ae12095c154','d8fb5c988e2b4995853c12d0c4c7bb29','0a5ee1d55fc44d64b287d84618dfeea8',0),('UserProject','9b59eac9a22e4693b67cacd929ff2061','758f3043280349e086a85b86f2668848','0a5ee1d55fc44d64b287d84618dfeea8',0),('UserProject','9b59eac9a22e4693b67cacd929ff2061','758f3043280349e086a85b86f2668848','c4632e0261e342218ab47c3a83624fb1',0),('UserProject','ac261d4d10e24c3c8655cac22157cd98','d8fb5c988e2b4995853c12d0c4c7bb29','4f0ae7640a844a1fa98e2ff28b49c4fe',0),('UserProject','b7661bc5cba943dea266498398ed28cc','758f3043280349e086a85b86f2668848','0a5ee1d55fc44d64b287d84618dfeea8',0),('UserProject','b7661bc5cba943dea266498398ed28cc','758f3043280349e086a85b86f2668848','c4632e0261e342218ab47c3a83624fb1',0),('UserProject','ce6e02b8138e4cf0aa05613d9b037115','758f3043280349e086a85b86f2668848','0a5ee1d55fc44d64b287d84618dfeea8',0),('UserProject','de54b2540437480f94583eb1f478a08b','758f3043280349e086a85b86f2668848','0a5ee1d55fc44d64b287d84618dfeea8',0),('UserProject','de54b2540437480f94583eb1f478a08b','758f3043280349e086a85b86f2668848','c4632e0261e342218ab47c3a83624fb1',0),('UserProject','e3f1c3b3a89c4ec5ba810ca1b8af9459','758f3043280349e086a85b86f2668848','0a5ee1d55fc44d64b287d84618dfeea8',0),('UserProject','e5d8265c899d404aa41bb403c43d1d0c','758f3043280349e086a85b86f2668848','0a5ee1d55fc44d64b287d84618dfeea8',0),('UserProject','e5d8265c899d404aa41bb403c43d1d0c','758f3043280349e086a85b86f2668848','c4632e0261e342218ab47c3a83624fb1',0),('UserProject','ec2fb0ea977c4070b86cd79c46feb905','758f3043280349e086a85b86f2668848','0a5ee1d55fc44d64b287d84618dfeea8',0),('UserDomain','366adcc074604d758db5667d78dc728d','be69a35f7a5240a99c028aff507f555b','0a5ee1d55fc44d64b287d84618dfeea8',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
INSERT INTO `credential` (`id`, `user_id`, `project_id`, `type`, `extra`, `key_hash`, `encrypted_blob`) VALUES ('fcb2320310134318832af2434506b853','7e40ee99e6034be7be796ae12095c154',NULL,'cert','{}','a0cbd34c582c86208be4d6bab69f9de245aedafb','gAAAAABpIsUhoXevKs8E0BUrwK9QOxKn1So_BcbHIA0WEPwn_0bWtlnhKEWFlayph-ZC377zWJZMvWelAlbsAy6gCOz9YmN5sA==');
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `service_id` (`service_id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('029540a95aaa4ed682b8bb10c715cabc',NULL,'public','91b821be947c4015a95f5378afd7a56f','http://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('1b8bc44ce36a400bb592ee94da1857ab',NULL,'public','36ad51a092984a228ca865e257c531ec','http://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('1dcdf7fca4ef49e1b0f1c06e77f63fd9',NULL,'internal','9ba32db131824d4caab8b84437c445c0','http://manila-internal.openstack.svc:8786/v2','{\"name\": \"manilav2\"}',1,'regionOne'),('26b92a2595a84281bc3945edeb8e4b0b',NULL,'public','42dd1e3dc8c145058ca50d161f99839c','http://aodh-public-openstack.apps-crc.testing','{\"name\": \"aodh\"}',1,'regionOne'),('313d169b79fe4c30bdd8576137051f8c',NULL,'internal','7d5b4a9cf49144728c99f2b229b2f61f','http://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('4cc0a911ce6e45d5ae8e5a053f5ea9d0',NULL,'public','d8cf72cd305b4a7fbca25f48f9797d4f','http://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('4e92f0953a4048339e70d96ab8c4f3d2',NULL,'public','68767414120d4df7be50465e54178430','http://heat-api-public-openstack.apps-crc.testing/v1/%(tenant_id)s','{\"name\": \"heat\"}',1,'regionOne'),('53e89e2d3b864023822a506d0861674f',NULL,'public','d1b0af90338c4a079e9d5ae732e64d04','http://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('75c11eab40e446889e9e437c907a8e6d',NULL,'public','2479d751080446d3a0dad8aed1eb395c','http://heat-cfnapi-public-openstack.apps-crc.testing/v1','{\"name\": \"heat-cfn\"}',1,'regionOne'),('77563c05069942128554b4c463e67323',NULL,'internal','3157f872827342ff91709a13d4151802','http://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('791440d94a514be2ba78c37e53e67262',NULL,'internal','91b821be947c4015a95f5378afd7a56f','http://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('82f4adb9e7f045748842fd714068610d',NULL,'public','3157f872827342ff91709a13d4151802','http://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('8777473081024037a4707df1dc0d8685',NULL,'internal','d8cf72cd305b4a7fbca25f48f9797d4f','http://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('ab342031d4e74266b9e8cdcba16b4637',NULL,'internal','77a4af2bfcf84c109082174471eadb77','http://manila-internal.openstack.svc:8786/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne'),('be222272bf1f499bbba0307ba4793e4b',NULL,'internal','d1b0af90338c4a079e9d5ae732e64d04','http://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('c71caa5f886e4eef87c7e5a180143d59',NULL,'public','7d5b4a9cf49144728c99f2b229b2f61f','http://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('d33610d733964c748e9ef6827e3101e5',NULL,'internal','42dd1e3dc8c145058ca50d161f99839c','http://aodh-internal.openstack.svc:8042','{\"name\": \"aodh\"}',1,'regionOne'),('d87a776d0b964673b0ae11e891e0f0fc',NULL,'public','4f5e5a5a78e14b52ae0529d9ea30d5a8','http://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('e42a1c44d3e14d309526f0b891ba18d7',NULL,'internal','2479d751080446d3a0dad8aed1eb395c','http://heat-cfnapi-internal.openstack.svc:8000/v1','{\"name\": \"heat-cfn\"}',1,'regionOne'),('e4a58987d9524143b276f7f450ea8eca',NULL,'internal','36ad51a092984a228ca865e257c531ec','http://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('e4f291fe82aa4b07969dd7b1a1c2fef8',NULL,'internal','4f5e5a5a78e14b52ae0529d9ea30d5a8','http://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('e57d55ef6aa14ccab87d6da0f67b577c',NULL,'internal','68767414120d4df7be50465e54178430','http://heat-api-internal.openstack.svc:8004/v1/%(tenant_id)s','{\"name\": \"heat\"}',1,'regionOne'),('fae8e58f1cfb4ea4a307927b3cd6f5da',NULL,'public','77a4af2bfcf84c109082174471eadb77','http://manila-public-openstack.apps-crc.testing/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne'),('fcedc1967ac74765ac718705689fa14d',NULL,'public','9ba32db131824d4caab8b84437c445c0','http://manila-public-openstack.apps-crc.testing/v2','{\"name\": \"manilav2\"}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `user_id` (`user_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('0a5ee1d55fc44d64b287d84618dfeea8','4f0ae7640a844a1fa98e2ff28b49c4fe'),('4f0ae7640a844a1fa98e2ff28b49c4fe','dea827b09b6b4953a5071e44fd0fce3a');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=644 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (2,'7e40ee99e6034be7be796ae12095c154','default','admin',0,NULL),(5,'de54b2540437480f94583eb1f478a08b','default','aodh',0,NULL),(8,'4ff26e787d5c4a55922ffe05358b6090','default','ceilometer',0,NULL),(11,'9b59eac9a22e4693b67cacd929ff2061','default','cinder',0,NULL),(14,'e5d8265c899d404aa41bb403c43d1d0c','default','cinderv3',0,NULL),(17,'0ec240bbf59c4223a12e795fc058daed','default','glance',0,NULL),(20,'ce6e02b8138e4cf0aa05613d9b037115','default','gnocchi',0,NULL),(23,'41c3607e24e148b1837d367730edaa25','default','heat',0,NULL),(26,'366adcc074604d758db5667d78dc728d','be69a35f7a5240a99c028aff507f555b','heat_stack_domain_admin',0,NULL),(29,'ec2fb0ea977c4070b86cd79c46feb905','default','heat-cfn',0,NULL),(32,'1f11ad52b1994292a95b5c1dafb43f21','default','manila',0,NULL),(35,'e3f1c3b3a89c4ec5ba810ca1b8af9459','default','manilav2',0,NULL),(38,'b7661bc5cba943dea266498398ed28cc','default','neutron',0,NULL),(41,'73d8249924dd406db12ad13a4ddb31a1','default','nova',0,NULL),(44,'0d60ddb8acff47408057d9cda84b946d','default','placement',0,NULL),(47,'77ba14987a21452fbe8e9b8c33f4244a','default','swift',0,NULL),(50,'68e9921ed93e4036af7fae0a549ad682','default','barbican',0,NULL),(51,'ac261d4d10e24c3c8655cac22157cd98','default','demo_tempestconf',0,NULL),(52,'0eb934af82df4872bcb4ed19077c144e','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('keystone','/usr/lib/python3.9/site-packages/keystone/common/sql/migrate_repo',109),('keystone_contract','/usr/lib/python3.9/site-packages/keystone/common/sql/contract_repo',79),('keystone_data_migrate','/usr/lib/python3.9/site-packages/keystone/common/sql/data_migration_repo',79),('keystone_expand','/usr/lib/python3.9/site-packages/keystone/common/sql/expand_repo',79);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=646 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (2,2,'2025-11-23 08:40:28',0,'$2b$12$yToo/9sv.Yzeb7EGdHM3Ies6Rk8stekuV8.WFlFB3qe3pEhNC1oja',1763885289611568,1763887228302431,'2025-11-23 08:08:09'),(5,5,NULL,0,'$2b$12$0nbLfwUkmWUeNe19Gf4siuhPzwsSA0n0iv5nRUTyLn.cvs6G.fQIG',1763885434792897,NULL,'2025-11-23 08:10:34'),(8,8,NULL,0,'$2b$12$Pb14dlTCmLKE7NImdc94XuIzrnz3UCMF2Z4xy0QWzgsK/wd6ll3SW',1763885435181201,NULL,'2025-11-23 08:10:35'),(11,11,NULL,0,'$2b$12$BB8AOafVbeAO08fkyVNj3.5hOSplhvrNtF1IT8nnFFaXZXCHqgpZS',1763885435649700,NULL,'2025-11-23 08:10:35'),(14,14,NULL,0,'$2b$12$n7kBjg/SlqkC4Hnh9.4NCew7xEoKcEwabT.TQoEcSMHd4hWOfPsQa',1763885435950313,NULL,'2025-11-23 08:10:35'),(17,17,NULL,0,'$2b$12$BVpXbDtDG4iwVyvRrme5fus0VsIouGw39/c3HMEdccdsqH1nMkccu',1763885436353233,NULL,'2025-11-23 08:10:36'),(20,20,NULL,0,'$2b$12$c7y/Z4ASLDP270B/evNl4OulbiFOBa2zOm8sqHabva7DrsEmYJrDC',1763885436699071,NULL,'2025-11-23 08:10:36'),(23,23,NULL,0,'$2b$12$ztlCGnMobqQ/uCAbr.YXb.2dSpjLYHzI4qa67jU8IXpKx3mkwAgZ6',1763885437046247,NULL,'2025-11-23 08:10:37'),(26,26,NULL,0,'$2b$12$N9RpYEPMZ/uP4HwclHhu3eqV5TwXM.FCV6jBKLOFQoeDJqcWKAWCC',1763885437715361,NULL,'2025-11-23 08:10:37'),(29,29,NULL,0,'$2b$12$fGmHj1NlBcgPlmGKRDpaKecn7CQE1Lc8ExC0vZeUIEyr/xRCwIN1i',1763885437982213,NULL,'2025-11-23 08:10:37'),(32,32,NULL,0,'$2b$12$RGjjSI2TYYCVZF40Mm2vBerblB9.xRSsCoXp8H5dbRI1tlVwWEWKm',1763885438243952,NULL,'2025-11-23 08:10:38'),(35,35,NULL,0,'$2b$12$9DIvmqVTJqvZFELhYjv0TO24DOguDF4gM42FX9J8dY.Qj.0rwdrCC',1763885446892559,NULL,'2025-11-23 08:10:46'),(38,38,NULL,0,'$2b$12$kBfy3G18xaufxvTHFioVSupeGCXbjU2KoioIto2V5h75V9mZ1Q8Cm',1763885447216550,NULL,'2025-11-23 08:10:47'),(41,41,NULL,0,'$2b$12$E83.mGCbLgjgYrtpse46zuHIIbobmqA9VL21WHOH4E2RnYrEGDAQy',1763885447608422,NULL,'2025-11-23 08:10:47'),(44,44,NULL,0,'$2b$12$RBE2dWcMkzkFi0eyXi4Vveoiorb7mQIXQi03GfDz9KjKq1SD6xUk6',1763885447972909,NULL,'2025-11-23 08:10:47'),(47,47,NULL,0,'$2b$12$tmOt4GwSc.cCFlUD74L7uee1G36dbtcRFIrCxsZ2WO8rzUOwH9ugG',1763885448498918,NULL,'2025-11-23 08:10:48'),(50,2,NULL,0,'$2b$12$aHuq8ck/TPnx5JBbBV7sAOxFFBzCRl8wrxPzAKjh3XHZf8hgPzswa',1763887228302431,NULL,'2025-11-23 08:40:28'),(51,50,NULL,0,'$2b$12$E27QzatoAUnvjjDT2ySLQuut7LSULHfM0ZNIByeLac/5ArRFkbCqC',1763887380807543,NULL,'2025-11-23 08:43:00'),(52,51,NULL,0,'$2b$12$pY2K9FpawJHSa.kYn.BzUeBNKt1olsQtmwOIxvrEjJfAQfQq8Fp7.',1763891799086495,NULL,'2025-11-23 09:56:39'),(53,52,NULL,0,'$2b$12$yv45vHyhWgb46kGHvKmcVu5j5Txd4mzy1LkP7OQE8pICZU3DYlL.a',1763891799641346,NULL,'2025-11-23 09:56:39');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('1915d3e5d4254231a0517e2dcf35848f','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0),('6273d493b1a74c728d21d1e1565370ed','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0),('758f3043280349e086a85b86f2668848','service','{}',NULL,1,'default','default',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('be69a35f7a5240a99c028aff507f555b','heat_stack','{}','',1,'<<keystone.domain.root>>',NULL,1),('d8fb5c988e2b4995853c12d0c4c7bb29','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=1201 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (1,NULL,NULL,'7e40ee99e6034be7be796ae12095c154',NULL,NULL,NULL,NULL,'2025-11-23 08:40:28',NULL,'2025-11-23 08:40:28',NULL,NULL),(2,NULL,NULL,'8510fb12e97c44a0ad5c8344634a51ef',NULL,NULL,NULL,NULL,'2025-11-23 09:57:14',NULL,'2025-11-23 09:57:14',NULL,NULL),(3,NULL,NULL,'9a1333c0251f4cb08415d8747692864b',NULL,NULL,NULL,NULL,'2025-11-23 09:57:16',NULL,'2025-11-23 09:57:16',NULL,NULL),(4,NULL,'b63e459088f54b0b9f8eccdc913c36ed',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:16',NULL,'2025-11-23 09:57:16',NULL,NULL),(5,NULL,NULL,'472d3d820207444ab349b892f7b3ca99',NULL,NULL,NULL,NULL,'2025-11-23 09:57:16',NULL,'2025-11-23 09:57:16',NULL,NULL),(6,NULL,NULL,'bb49ae7fb55a48be96ec056b9dcce5a4',NULL,NULL,NULL,NULL,'2025-11-23 09:57:16',NULL,'2025-11-23 09:57:16',NULL,NULL),(7,NULL,NULL,'2134186b294a45f29e1efc7e5559943e',NULL,NULL,NULL,NULL,'2025-11-23 09:57:16',NULL,'2025-11-23 09:57:16',NULL,NULL),(8,NULL,NULL,'a3a2004b39dd46f89c6ecccd828116ad',NULL,NULL,NULL,NULL,'2025-11-23 09:57:16',NULL,'2025-11-23 09:57:16',NULL,NULL),(9,NULL,NULL,'16fe2a19d9fc4f77b323c62267690e12',NULL,NULL,NULL,NULL,'2025-11-23 09:57:17',NULL,'2025-11-23 09:57:17',NULL,NULL),(10,NULL,NULL,'a69ad383098a4f4e9c491e6d100a6edd',NULL,NULL,NULL,NULL,'2025-11-23 09:57:17',NULL,'2025-11-23 09:57:17',NULL,NULL),(11,NULL,NULL,'aa3b70dd377c4ec0845b0083e584af19',NULL,NULL,NULL,NULL,'2025-11-23 09:57:17',NULL,'2025-11-23 09:57:17',NULL,NULL),(12,NULL,'78b8328169d943988bc199e4098d9f6a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:18',NULL,'2025-11-23 09:57:18',NULL,NULL),(13,NULL,NULL,'89aa52c53a98423b857e29956fc135e6',NULL,NULL,NULL,NULL,'2025-11-23 09:57:18',NULL,'2025-11-23 09:57:18',NULL,NULL),(14,NULL,NULL,'437d828bb72043c2baa60d3428c248da',NULL,NULL,NULL,NULL,'2025-11-23 09:57:18',NULL,'2025-11-23 09:57:18',NULL,NULL),(15,NULL,NULL,'060e0bffc7a344de8e8eaf32ef36226a',NULL,NULL,NULL,NULL,'2025-11-23 09:57:18',NULL,'2025-11-23 09:57:18',NULL,NULL),(16,NULL,NULL,'8b09752336794213a7a7f285ffe38d8d',NULL,NULL,NULL,NULL,'2025-11-23 09:57:18',NULL,'2025-11-23 09:57:18',NULL,NULL),(17,NULL,'946270923974482b998c7024e5c17f2f',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:18',NULL,'2025-11-23 09:57:18',NULL,NULL),(18,NULL,'b2f5fbaeba0c43d09e9ccafe35bb9638',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:18',NULL,'2025-11-23 09:57:18',NULL,NULL),(19,NULL,'3ea2e7c182ae47f6964737a8d585a4e8',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:18',NULL,'2025-11-23 09:57:18',NULL,NULL),(20,NULL,NULL,'80b3452c301a41738bd06402ba544990',NULL,NULL,NULL,NULL,'2025-11-23 09:57:18',NULL,'2025-11-23 09:57:18',NULL,NULL),(21,NULL,'ea974d1d52094dddb577ce2373f46df9',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:18',NULL,'2025-11-23 09:57:18',NULL,NULL),(22,NULL,NULL,'a72bbef2820d4ea4a11362cbb546a6c8',NULL,NULL,NULL,NULL,'2025-11-23 09:57:19',NULL,'2025-11-23 09:57:19',NULL,NULL),(23,NULL,'4d4464ffef3741dbbe79c0e8d1db14ca',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:19',NULL,'2025-11-23 09:57:19',NULL,NULL),(24,NULL,'412709144374493f933ee4c1528ca560',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:19',NULL,'2025-11-23 09:57:19',NULL,NULL),(25,NULL,'792ec3f8cc2e4e6da860afb1e1ee1161',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:19',NULL,'2025-11-23 09:57:19',NULL,NULL),(26,NULL,'324b9fbf63f24efa8e7b3502aeb09ff1',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:19',NULL,'2025-11-23 09:57:19',NULL,NULL),(27,NULL,'255141467dab45dcb9f6d6d9c585be7a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:20',NULL,'2025-11-23 09:57:20',NULL,NULL),(28,NULL,'877bb7988b3c471a832a13f1c846dc0c',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:20',NULL,'2025-11-23 09:57:20',NULL,NULL),(29,NULL,'c44cfd9deea64446bd99879b43aa7fb3',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:20',NULL,'2025-11-23 09:57:20',NULL,NULL),(30,NULL,'2c5109a5a65a44ea884d47f15ffe5071',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:21',NULL,'2025-11-23 09:57:21',NULL,NULL),(31,NULL,NULL,'cd14613532044da7955b096cb9426b68',NULL,NULL,NULL,NULL,'2025-11-23 09:57:21',NULL,'2025-11-23 09:57:21',NULL,NULL),(32,NULL,'6a669da7c8a1442a9df80336886c2cc0',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:21',NULL,'2025-11-23 09:57:21',NULL,NULL),(33,NULL,NULL,'6b69fc1536504121adff3d0e12ba354e',NULL,NULL,NULL,NULL,'2025-11-23 09:57:22',NULL,'2025-11-23 09:57:22',NULL,NULL),(34,NULL,'2f00025ff9c2477eab4a9615400516b6',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:24',NULL,'2025-11-23 09:57:24',NULL,NULL),(35,NULL,NULL,'b37a9db54ee24f89a5b4903305b9ddbd',NULL,NULL,NULL,NULL,'2025-11-23 09:57:24',NULL,'2025-11-23 09:57:24',NULL,NULL),(36,NULL,NULL,'a50237403a5943888117515b72e4f61c',NULL,NULL,NULL,NULL,'2025-11-23 09:57:24',NULL,'2025-11-23 09:57:24',NULL,NULL),(37,NULL,'c3f3582983544eaea5257eaf9dae3e5e',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:25',NULL,'2025-11-23 09:57:25',NULL,NULL),(38,NULL,NULL,'3bf3cdbc08064dc980297272076c2bd2',NULL,NULL,NULL,NULL,'2025-11-23 09:57:25',NULL,'2025-11-23 09:57:25',NULL,NULL),(39,NULL,'947bc2ee73584516a913825528d2557f',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:26',NULL,'2025-11-23 09:57:26',NULL,NULL),(40,NULL,NULL,'e559dcf534fa40b59de4c20a5bf6df75',NULL,NULL,NULL,NULL,'2025-11-23 09:57:26',NULL,'2025-11-23 09:57:26',NULL,NULL),(41,NULL,NULL,'e5840695e48448368d5da37636c3c9f7',NULL,NULL,NULL,NULL,'2025-11-23 09:57:26',NULL,'2025-11-23 09:57:26',NULL,NULL),(42,NULL,NULL,'a84a6fbda8ce4471a1ff7a2945ab9101',NULL,NULL,NULL,NULL,'2025-11-23 09:57:27',NULL,'2025-11-23 09:57:27',NULL,NULL),(43,NULL,'9b3dd7a96ed747c3802aea6c510b8512',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:27',NULL,'2025-11-23 09:57:27',NULL,NULL),(44,NULL,NULL,'c05c24137184420d89a86b1c7f74c3c3',NULL,NULL,NULL,NULL,'2025-11-23 09:57:27',NULL,'2025-11-23 09:57:27',NULL,NULL),(45,NULL,'a7182842952446a0bcea6ba1bec7a2bd',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:27',NULL,'2025-11-23 09:57:27',NULL,NULL),(46,NULL,NULL,'71ef6206c78e49a397c88f81193bdfd3',NULL,NULL,NULL,NULL,'2025-11-23 09:57:28',NULL,'2025-11-23 09:57:28',NULL,NULL),(47,NULL,NULL,'913d684df519492aaa59a241ae5133ce',NULL,NULL,NULL,NULL,'2025-11-23 09:57:28',NULL,'2025-11-23 09:57:28',NULL,NULL),(48,NULL,'ca123dab2abc4381bddd118c76fbb3bb',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:28',NULL,'2025-11-23 09:57:28',NULL,NULL),(49,NULL,NULL,'5fba796fb11f473a92f7a5ff67538fd4',NULL,NULL,NULL,NULL,'2025-11-23 09:57:28',NULL,'2025-11-23 09:57:28',NULL,NULL),(50,NULL,NULL,'031fbb15f41f4cbe8811b334a3fca8e4',NULL,NULL,NULL,NULL,'2025-11-23 09:57:28',NULL,'2025-11-23 09:57:28',NULL,NULL),(51,NULL,'70ea84b591f0421a9964e160a8832d72',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:29',NULL,'2025-11-23 09:57:29',NULL,NULL),(52,NULL,'9452199b7cd84e588bd0809f03e630ed',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:29',NULL,'2025-11-23 09:57:29',NULL,NULL),(53,NULL,'f2ac08210c8b434a918e1dfc8e50ab8b',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:30',NULL,'2025-11-23 09:57:30',NULL,NULL),(54,NULL,'88c95b0e36514877b6f6925a99ad1b8d',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:30',NULL,'2025-11-23 09:57:30',NULL,NULL),(55,NULL,'6d9ab7a647ed4eb788192845991b91d5',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:30',NULL,'2025-11-23 09:57:30',NULL,NULL),(56,NULL,'5ef5e3300e8c4cb29cedd3c36b0b2b63',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:30',NULL,'2025-11-23 09:57:30',NULL,NULL),(57,NULL,'59536e1856bc499d971bcb643800e5d2',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:31',NULL,'2025-11-23 09:57:31',NULL,NULL),(58,NULL,NULL,'43f3a3a7579f4a6d945ab8301c37d208',NULL,NULL,NULL,NULL,'2025-11-23 09:57:32',NULL,'2025-11-23 09:57:32',NULL,NULL),(59,NULL,NULL,'6befcae8efaf45b99476cab156aaa407',NULL,NULL,NULL,NULL,'2025-11-23 09:57:32',NULL,'2025-11-23 09:57:32',NULL,NULL),(60,NULL,NULL,'bb30c6ce3cdb45a1be0a7901a2611757',NULL,NULL,NULL,NULL,'2025-11-23 09:57:32',NULL,'2025-11-23 09:57:32',NULL,NULL),(61,NULL,NULL,'8adb95073808493285613426ba1a2932',NULL,NULL,NULL,NULL,'2025-11-23 09:57:33',NULL,'2025-11-23 09:57:33',NULL,NULL),(62,NULL,'833c8454c7b649528b8023fc99565af9',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:33',NULL,'2025-11-23 09:57:33',NULL,NULL),(63,NULL,NULL,'bb934380049b4c86bb72b4d0d77007be',NULL,NULL,NULL,NULL,'2025-11-23 09:57:34',NULL,'2025-11-23 09:57:34',NULL,NULL),(64,NULL,NULL,'e7f552510b264b4faf0224149825890b',NULL,NULL,NULL,NULL,'2025-11-23 09:57:34',NULL,'2025-11-23 09:57:34',NULL,NULL),(65,NULL,'c0b0c601061b406d8386b9c0708f0fb6',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:35',NULL,'2025-11-23 09:57:35',NULL,NULL),(66,NULL,NULL,'77c327b36e7f472bb5b19edea306074f',NULL,NULL,NULL,NULL,'2025-11-23 09:57:36',NULL,'2025-11-23 09:57:36',NULL,NULL),(67,NULL,NULL,'9f21990a02064b9ea9af7712c1cf173e',NULL,NULL,NULL,NULL,'2025-11-23 09:57:36',NULL,'2025-11-23 09:57:36',NULL,NULL),(68,NULL,NULL,'77613928a5314df0b936514679b9aa61',NULL,NULL,NULL,NULL,'2025-11-23 09:57:36',NULL,'2025-11-23 09:57:36',NULL,NULL),(69,NULL,NULL,'2b1b85f8808143c785453085f665a0d0',NULL,NULL,NULL,NULL,'2025-11-23 09:57:36',NULL,'2025-11-23 09:57:36',NULL,NULL),(70,NULL,NULL,'b4cdcae5c57e49b6bc46650617d0a608',NULL,NULL,NULL,NULL,'2025-11-23 09:57:36',NULL,'2025-11-23 09:57:36',NULL,NULL),(71,NULL,NULL,'1c10dbf03e12465c9e758d89b7800049',NULL,NULL,NULL,NULL,'2025-11-23 09:57:36',NULL,'2025-11-23 09:57:36',NULL,NULL),(72,NULL,'e17b7db6fcb5415d8d071c3e36370e04',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:37',NULL,'2025-11-23 09:57:37',NULL,NULL),(73,NULL,'995d71f53fcc4a328f9972bab7d8b3e1',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:38',NULL,'2025-11-23 09:57:38',NULL,NULL),(74,NULL,'09f4f6cb07014b10a42dd2382fdbe411',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:39',NULL,'2025-11-23 09:57:39',NULL,NULL),(75,NULL,'7abf006448874467a5a95d3867cb9554',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:39',NULL,'2025-11-23 09:57:39',NULL,NULL),(76,NULL,'c097951ed10b417a8f207692bc06ca93',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:39',NULL,'2025-11-23 09:57:39',NULL,NULL),(77,NULL,'2c566691918c42f09ea949a36ed8459b',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:39',NULL,'2025-11-23 09:57:39',NULL,NULL),(78,NULL,'ad2983f87d4d492bb7f3a6e68f238df0',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:39',NULL,'2025-11-23 09:57:39',NULL,NULL),(79,NULL,'abec135034ad4e36bbabdccb79ba05f6',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:40',NULL,'2025-11-23 09:57:40',NULL,NULL),(80,NULL,'1bb66875987945df8f08547b3e2cab9d',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:40',NULL,'2025-11-23 09:57:40',NULL,NULL),(81,NULL,'dd290a1af5fc4a2cad5e43438e7b1ef6',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:40',NULL,'2025-11-23 09:57:40',NULL,NULL),(82,NULL,NULL,'0d91782a307c4c99ac23172472ced1b8',NULL,NULL,NULL,NULL,'2025-11-23 09:57:45',NULL,'2025-11-23 09:57:45',NULL,NULL),(83,NULL,NULL,'10fc19433fde45d994612a7c7e705934',NULL,NULL,NULL,NULL,'2025-11-23 09:57:45',NULL,'2025-11-23 09:57:45',NULL,NULL),(84,NULL,NULL,'acd0c08220084d0ab55d7495db82623f',NULL,NULL,NULL,NULL,'2025-11-23 09:57:45',NULL,'2025-11-23 09:57:45',NULL,NULL),(85,NULL,NULL,'3e16244783434b3eb3dae1b8eae35fef',NULL,NULL,NULL,NULL,'2025-11-23 09:57:45',NULL,'2025-11-23 09:57:45',NULL,NULL),(86,NULL,NULL,'d4406602baa24ac29cdc6900c8a2480c',NULL,NULL,NULL,NULL,'2025-11-23 09:57:46',NULL,'2025-11-23 09:57:46',NULL,NULL),(87,NULL,NULL,'ec8ab883476b4dda84edf108464fde12',NULL,NULL,NULL,NULL,'2025-11-23 09:57:46',NULL,'2025-11-23 09:57:46',NULL,NULL),(88,NULL,NULL,'822bc9b07ca5403db0d5feee3e08da5e',NULL,NULL,NULL,NULL,'2025-11-23 09:57:46',NULL,'2025-11-23 09:57:46',NULL,NULL),(89,NULL,'ab89783c9d39468096f7d3a0c6bf4d3e',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:46',NULL,'2025-11-23 09:57:46',NULL,NULL),(90,NULL,'69e1bc64caf94c799dd4286a48944326',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:47',NULL,'2025-11-23 09:57:47',NULL,NULL),(91,NULL,NULL,'4338443bf02e4068b144e8bff1344b82',NULL,NULL,NULL,NULL,'2025-11-23 09:57:47',NULL,'2025-11-23 09:57:47',NULL,NULL),(92,NULL,NULL,'4be94aba8f1b4084a6046f620192dfd1',NULL,NULL,NULL,NULL,'2025-11-23 09:57:47',NULL,'2025-11-23 09:57:47',NULL,NULL),(93,NULL,'088006c8854d43a3a4aa5653a1f6632d',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:47',NULL,'2025-11-23 09:57:47',NULL,NULL),(94,NULL,'e11cc6be2c394904bcbfd9534b9cd44a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:49',NULL,'2025-11-23 09:57:49',NULL,NULL),(95,NULL,'97dcfb4d349743488b2ce52d53caca62',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:49',NULL,'2025-11-23 09:57:49',NULL,NULL),(96,NULL,NULL,'97bf687af11e4a28b068e1bf2e46f329',NULL,NULL,NULL,NULL,'2025-11-23 09:57:49',NULL,'2025-11-23 09:57:49',NULL,NULL),(97,NULL,NULL,'94a85ed8dc9b426188138a02dc8784c6',NULL,NULL,NULL,NULL,'2025-11-23 09:57:49',NULL,'2025-11-23 09:57:49',NULL,NULL),(98,NULL,'4aa3eeb4fe1d40e98ebeb717367cbc51',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:49',NULL,'2025-11-23 09:57:49',NULL,NULL),(99,NULL,'caca061b0ca3474c8546d280bfe89a3b',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:50',NULL,'2025-11-23 09:57:50',NULL,NULL),(100,NULL,'35e92af8b4894e40a999b06af821482c',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:50',NULL,'2025-11-23 09:57:50',NULL,NULL),(101,NULL,'50dc0b2de6eb4b14ab9ee7edac3ddfb0',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:50',NULL,'2025-11-23 09:57:50',NULL,NULL),(102,NULL,'17fb26a176004e07a080492768c35806',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:50',NULL,'2025-11-23 09:57:50',NULL,NULL),(103,NULL,'9465e291a2ee4fa7babd5286c6274729',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:50',NULL,'2025-11-23 09:57:50',NULL,NULL),(104,NULL,'84c5b7dad3904c17a46a4c0f8c44cb5d',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:51',NULL,'2025-11-23 09:57:51',NULL,NULL),(105,NULL,NULL,'1f3ee0820911449283ee3090011a0aa9',NULL,NULL,NULL,NULL,'2025-11-23 09:57:51',NULL,'2025-11-23 09:57:51',NULL,NULL),(106,NULL,NULL,'16b87a34450642c3a278a387702bcc6f',NULL,NULL,NULL,NULL,'2025-11-23 09:57:51',NULL,'2025-11-23 09:57:51',NULL,NULL),(107,NULL,'8009bacae9574792ba056a3b3bb9d848',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:54',NULL,'2025-11-23 09:57:54',NULL,NULL),(108,NULL,NULL,'1c9299c54b744204a1277883eb79bd19',NULL,NULL,NULL,NULL,'2025-11-23 09:57:54',NULL,'2025-11-23 09:57:54',NULL,NULL),(109,NULL,'2290c520e71a4ce08b7a8dfd55ede81b',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:55',NULL,'2025-11-23 09:57:55',NULL,NULL),(110,NULL,'b0e52e65d4364c41876380c9d4dc6b50',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:56',NULL,'2025-11-23 09:57:56',NULL,NULL),(111,NULL,NULL,'1afe22640f7c42f0b218ef32d68d330a',NULL,NULL,NULL,NULL,'2025-11-23 09:57:56',NULL,'2025-11-23 09:57:56',NULL,NULL),(112,NULL,NULL,'e7cdd57691044f0e9db4af879308cf0e',NULL,NULL,NULL,NULL,'2025-11-23 09:57:56',NULL,'2025-11-23 09:57:56',NULL,NULL),(113,NULL,NULL,'0e690dea7d1b4e269c6decf08d9bfa0b',NULL,NULL,NULL,NULL,'2025-11-23 09:57:56',NULL,'2025-11-23 09:57:56',NULL,NULL),(114,NULL,NULL,'dd0e09d4feb54cc6a6f60d297342da2c',NULL,NULL,NULL,NULL,'2025-11-23 09:57:56',NULL,'2025-11-23 09:57:56',NULL,NULL),(115,NULL,NULL,'023239d1b45c4f99862472653c4749a4',NULL,NULL,NULL,NULL,'2025-11-23 09:57:56',NULL,'2025-11-23 09:57:56',NULL,NULL),(116,NULL,'a6dad5f4ea934cb2b33cba44987053be',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:57',NULL,'2025-11-23 09:57:57',NULL,NULL),(117,NULL,NULL,'0fcf008ca60d444182242b85d2a0c72d',NULL,NULL,NULL,NULL,'2025-11-23 09:57:58',NULL,'2025-11-23 09:57:58',NULL,NULL),(118,NULL,'18c3caf25f3a42918d484f3533bb37f1',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:58',NULL,'2025-11-23 09:57:58',NULL,NULL),(119,NULL,'d6266cb702ec4d04811ff19bc5afe222',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:59',NULL,'2025-11-23 09:57:59',NULL,NULL),(120,NULL,'7c8dcb9f799541ed8a9c05e25b33c27c',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:57:59',NULL,'2025-11-23 09:57:59',NULL,NULL),(121,NULL,NULL,'2c749c7807ed49c8a94803a5234409a8',NULL,NULL,NULL,NULL,'2025-11-23 09:57:59',NULL,'2025-11-23 09:57:59',NULL,NULL),(122,NULL,NULL,'146161752e124649993031f55d8b488f',NULL,NULL,NULL,NULL,'2025-11-23 09:57:59',NULL,'2025-11-23 09:57:59',NULL,NULL),(123,NULL,'62f8750114d2400183a8f623826205cf',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:00',NULL,'2025-11-23 09:58:00',NULL,NULL),(124,NULL,'6434266d413e46d28782868ecc111219',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:00',NULL,'2025-11-23 09:58:00',NULL,NULL),(125,NULL,'27899b33b5ae438b96490955a32ec48c',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:00',NULL,'2025-11-23 09:58:00',NULL,NULL),(126,NULL,NULL,'988603b6fc7545209013cd636ec73b35',NULL,NULL,NULL,NULL,'2025-11-23 09:58:01',NULL,'2025-11-23 09:58:01',NULL,NULL),(127,NULL,'9b5bdce6098f4a4c8da466fe071cee95',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:02',NULL,'2025-11-23 09:58:02',NULL,NULL),(128,NULL,NULL,'c3194481604c45ecb2d87b26f4f7a6f5',NULL,NULL,NULL,NULL,'2025-11-23 09:58:02',NULL,'2025-11-23 09:58:02',NULL,NULL),(129,NULL,'33a17fcfa4c048639f42338510068d72',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:03',NULL,'2025-11-23 09:58:03',NULL,NULL),(130,NULL,'f66c527b4a3647aaa90b0eb3079addc2',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:05',NULL,'2025-11-23 09:58:05',NULL,NULL),(131,NULL,NULL,'0ae3917e59334a0f826c92c8fd1a82eb',NULL,NULL,NULL,NULL,'2025-11-23 09:58:05',NULL,'2025-11-23 09:58:05',NULL,NULL),(132,NULL,'c8f77a53f1b2492fb7d1853e511c34ae',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:06',NULL,'2025-11-23 09:58:06',NULL,NULL),(133,NULL,NULL,'6a87bbf1ca4e42f9be2792f63929e7d9',NULL,NULL,NULL,NULL,'2025-11-23 09:58:07',NULL,'2025-11-23 09:58:07',NULL,NULL),(134,NULL,NULL,'51ca708165a64b09a90f1d6ae71b88cd',NULL,NULL,NULL,NULL,'2025-11-23 09:58:07',NULL,'2025-11-23 09:58:07',NULL,NULL),(135,NULL,NULL,'419b4adfd28b47f982ace521d391230d',NULL,NULL,NULL,NULL,'2025-11-23 09:58:07',NULL,'2025-11-23 09:58:07',NULL,NULL),(136,NULL,NULL,'9736dc708a0e40cbb29500e71ffbe120',NULL,NULL,NULL,NULL,'2025-11-23 09:58:07',NULL,'2025-11-23 09:58:07',NULL,NULL),(137,NULL,NULL,'db74a58d763c4e658e99fb3eb28a6c50',NULL,NULL,NULL,NULL,'2025-11-23 09:58:08',NULL,'2025-11-23 09:58:08',NULL,NULL),(138,NULL,NULL,'f8f7f071d69b47eea777e2f30914b283',NULL,NULL,NULL,NULL,'2025-11-23 09:58:08',NULL,'2025-11-23 09:58:08',NULL,NULL),(139,NULL,'c237071db5404942b6c2085095bf127f',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:08',NULL,'2025-11-23 09:58:08',NULL,NULL),(140,NULL,'f1d1a40a03554f69af0b1945227d2af2',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:10',NULL,'2025-11-23 09:58:10',NULL,NULL),(141,NULL,'321cdc96fc954dba909243f728868319',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:10',NULL,'2025-11-23 09:58:10',NULL,NULL),(142,NULL,'e57550e73e2e4ac59b2301419b4440d5',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:10',NULL,'2025-11-23 09:58:10',NULL,NULL),(143,NULL,'1c66a256cb1647e8b924b7006e4b979f',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:11',NULL,'2025-11-23 09:58:11',NULL,NULL),(144,NULL,NULL,'d086d15b7e4b48049a5599026f872153',NULL,NULL,NULL,NULL,'2025-11-23 09:58:11',NULL,'2025-11-23 09:58:11',NULL,NULL),(145,NULL,NULL,'5c49a2a2001b4b799ec0abfde078acc5',NULL,NULL,NULL,NULL,'2025-11-23 09:58:11',NULL,'2025-11-23 09:58:11',NULL,NULL),(146,NULL,'1a1259fda096405a89a70a4e71d21044',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:13',NULL,'2025-11-23 09:58:13',NULL,NULL),(147,NULL,NULL,'ab7aaf72a2a045d9b3465a0d2763f405',NULL,NULL,NULL,NULL,'2025-11-23 09:58:13',NULL,'2025-11-23 09:58:13',NULL,NULL),(148,NULL,NULL,'64968f22ea6b4904acdd3360ae67cae3',NULL,NULL,NULL,NULL,'2025-11-23 09:58:13',NULL,'2025-11-23 09:58:13',NULL,NULL),(149,NULL,NULL,'d309dcbcdee940aea3879f0cba7f35b2',NULL,NULL,NULL,NULL,'2025-11-23 09:58:14',NULL,'2025-11-23 09:58:14',NULL,NULL),(150,NULL,'42f6eac3ec254c41a0ebe710629aacdd',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:14',NULL,'2025-11-23 09:58:14',NULL,NULL),(151,NULL,'87bd2c40466b42cd852351a8d3a0e88b',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:15',NULL,'2025-11-23 09:58:15',NULL,NULL),(152,NULL,'3b2487d759af4b628e0f216a34c1dabb',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:16',NULL,'2025-11-23 09:58:16',NULL,NULL),(153,NULL,'d9f093c4e0344eac9565d145864d113a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:18',NULL,'2025-11-23 09:58:18',NULL,NULL),(154,NULL,'7dd2a35c00cd463d81ec4364b380dc2d',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:18',NULL,'2025-11-23 09:58:18',NULL,NULL),(155,NULL,NULL,'6377faaba16740a887e58230256a539f',NULL,NULL,NULL,NULL,'2025-11-23 09:58:18',NULL,'2025-11-23 09:58:18',NULL,NULL),(156,NULL,'af9cc9fea0ae44f288d513620e89ee2d',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:19',NULL,'2025-11-23 09:58:19',NULL,NULL),(157,NULL,'0637423cc7b3452ca2888598a3f65ec8',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:20',NULL,'2025-11-23 09:58:20',NULL,NULL),(158,NULL,'fd650299370f4630887e34457a1d2835',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:20',NULL,'2025-11-23 09:58:20',NULL,NULL),(159,NULL,NULL,'30e709b30d1a4d169918707e430c3abe',NULL,NULL,NULL,NULL,'2025-11-23 09:58:20',NULL,'2025-11-23 09:58:20',NULL,NULL),(160,NULL,NULL,'b79ba98acc3c4b3580a3847feb119c9b',NULL,NULL,NULL,NULL,'2025-11-23 09:58:20',NULL,'2025-11-23 09:58:20',NULL,NULL),(161,NULL,NULL,'c0834ecfbfcb4fd7b7c21cdca545e1b3',NULL,NULL,NULL,NULL,'2025-11-23 09:58:20',NULL,'2025-11-23 09:58:20',NULL,NULL),(162,NULL,'397af495cf184e34be6fcb84964bd531',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:21',NULL,'2025-11-23 09:58:21',NULL,NULL),(163,NULL,'103398a293414a3081333eb24455a6bd',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:21',NULL,'2025-11-23 09:58:21',NULL,NULL),(164,NULL,NULL,'9577c2fe573c4f8690737be2c33fe6ba',NULL,NULL,NULL,NULL,'2025-11-23 09:58:22',NULL,'2025-11-23 09:58:22',NULL,NULL),(165,NULL,NULL,'367315d5002b4ce09a4faa9aaab9b829',NULL,NULL,NULL,NULL,'2025-11-23 09:58:22',NULL,'2025-11-23 09:58:22',NULL,NULL),(166,NULL,NULL,'f2e1af5b84d54ae99f8dd1cec7536d2a',NULL,NULL,NULL,NULL,'2025-11-23 09:58:22',NULL,'2025-11-23 09:58:22',NULL,NULL),(167,NULL,NULL,'019c36aa3b4e4865a836bf417e5dff91',NULL,NULL,NULL,NULL,'2025-11-23 09:58:22',NULL,'2025-11-23 09:58:22',NULL,NULL),(168,NULL,'eea6661dd421459f83eb1bb003b17aea',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:23',NULL,'2025-11-23 09:58:23',NULL,NULL),(169,NULL,NULL,'10eda227b4e6466e9ad595581d65204e',NULL,NULL,NULL,NULL,'2025-11-23 09:58:23',NULL,'2025-11-23 09:58:23',NULL,NULL),(170,NULL,'202c6e9b82ea4481b7c8e2b89a7adcf2',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:24',NULL,'2025-11-23 09:58:24',NULL,NULL),(171,NULL,'2b91dbfcbeba4477a01b1c4bbb3cff34',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:24',NULL,'2025-11-23 09:58:24',NULL,NULL),(172,NULL,'69e7965a8e5f4d73855154168d25b03d',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:24',NULL,'2025-11-23 09:58:24',NULL,NULL),(173,NULL,'673d79e875494c82a775b6739d78ef67',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:24',NULL,'2025-11-23 09:58:24',NULL,NULL),(174,NULL,'929c819ab559454fbe0a9d4e128ddaa2',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:25',NULL,'2025-11-23 09:58:25',NULL,NULL),(175,NULL,'1ca9ec24f5884f0ab16d1d0f2da02249',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:25',NULL,'2025-11-23 09:58:25',NULL,NULL),(176,NULL,'67ef7c2df1c44f0d91c69664df3bd335',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:25',NULL,'2025-11-23 09:58:25',NULL,NULL),(177,NULL,'88b7793596b148b49c0103e5f48ca35a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:25',NULL,'2025-11-23 09:58:25',NULL,NULL),(178,NULL,'7d7b6c9fe9254fc19f57216b9e9a303d',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:26',NULL,'2025-11-23 09:58:26',NULL,NULL),(179,NULL,NULL,'f79619f9d37a41798e27dc9308a4b3bb',NULL,NULL,NULL,NULL,'2025-11-23 09:58:28',NULL,'2025-11-23 09:58:28',NULL,NULL),(180,NULL,'fc18e9dd4a034efa823317d7c7fcb865',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:28',NULL,'2025-11-23 09:58:28',NULL,NULL),(181,NULL,'008ba8ca259245aca12b59917bcb97cf',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:29',NULL,'2025-11-23 09:58:29',NULL,NULL),(182,NULL,'b3e3b54bac004b60bd9ae1c53e6007e0',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:29',NULL,'2025-11-23 09:58:29',NULL,NULL),(183,NULL,'7eda27a6fa984ccd994240cd1d43f2ff',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:30',NULL,'2025-11-23 09:58:30',NULL,NULL),(184,NULL,NULL,'eacef4dd539c421595c0d06eca3d2332',NULL,NULL,NULL,NULL,'2025-11-23 09:58:30',NULL,'2025-11-23 09:58:30',NULL,NULL),(185,NULL,NULL,'0460e3d143654365a726f2f935a6aee8',NULL,NULL,NULL,NULL,'2025-11-23 09:58:30',NULL,'2025-11-23 09:58:30',NULL,NULL),(186,NULL,'6f11105c924148bd92111966201ba8e9',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:30',NULL,'2025-11-23 09:58:30',NULL,NULL),(187,NULL,NULL,'0987edfb524447c785d026232e922eb6',NULL,NULL,NULL,NULL,'2025-11-23 09:58:31',NULL,'2025-11-23 09:58:31',NULL,NULL),(188,NULL,NULL,'e55cd948097b422fa30971ed60dc961e',NULL,NULL,NULL,NULL,'2025-11-23 09:58:31',NULL,'2025-11-23 09:58:31',NULL,NULL),(189,NULL,NULL,'5d55feb265574457ab0701811d82d183',NULL,NULL,NULL,NULL,'2025-11-23 09:58:31',NULL,'2025-11-23 09:58:31',NULL,NULL),(190,NULL,NULL,'c64df6152b8947818b4af7afa1e3f843',NULL,NULL,NULL,NULL,'2025-11-23 09:58:31',NULL,'2025-11-23 09:58:31',NULL,NULL),(191,NULL,NULL,'96c849b6fde64712a81b9f75a1b2d823',NULL,NULL,NULL,NULL,'2025-11-23 09:58:31',NULL,'2025-11-23 09:58:31',NULL,NULL),(192,NULL,NULL,'a4ab69e856964f38a64ace72a2fc71ba',NULL,NULL,NULL,NULL,'2025-11-23 09:58:32',NULL,'2025-11-23 09:58:32',NULL,NULL),(193,NULL,'5d3fcc68dc8f48d1a70351680d987a8e',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:32',NULL,'2025-11-23 09:58:32',NULL,NULL),(194,NULL,'019c2ca67a8843c5842fa799c6b22aaf',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:32',NULL,'2025-11-23 09:58:32',NULL,NULL),(195,NULL,'fc358425d1b84e00b902cc76f9e5a3f2',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:32',NULL,'2025-11-23 09:58:32',NULL,NULL),(196,NULL,'d72454088db342068a32cb0c11fa66a4',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:33',NULL,'2025-11-23 09:58:33',NULL,NULL),(197,NULL,'9c58ba7988a04302a6d04d7bc078a7de',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:33',NULL,'2025-11-23 09:58:33',NULL,NULL),(198,NULL,'229b4d8ccb9848e39b038138fd0bf53b',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:33',NULL,'2025-11-23 09:58:33',NULL,NULL),(199,NULL,'faa6c07fbf274d23a74fc8df3258514a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:33',NULL,'2025-11-23 09:58:33',NULL,NULL),(200,NULL,'7e88744d6f7041e39cf161fd82391652',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:34',NULL,'2025-11-23 09:58:34',NULL,NULL),(201,NULL,NULL,'1a506cb01e02444fa21f07fa6d8ea5b8',NULL,NULL,NULL,NULL,'2025-11-23 09:58:35',NULL,'2025-11-23 09:58:35',NULL,NULL),(202,NULL,'970b71e9962d48c297734544df65b973',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:37',NULL,'2025-11-23 09:58:37',NULL,NULL),(203,NULL,NULL,'0a2ec1c68645495e930794e66f2ceb88',NULL,NULL,NULL,NULL,'2025-11-23 09:58:39',NULL,'2025-11-23 09:58:39',NULL,NULL),(204,NULL,NULL,'044168e2e1e24bd5b99b3821ee0ed3fe',NULL,NULL,NULL,NULL,'2025-11-23 09:58:39',NULL,'2025-11-23 09:58:39',NULL,NULL),(205,NULL,'629aa4113aad4230b7268666e40e0cbb',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:40',NULL,'2025-11-23 09:58:40',NULL,NULL),(206,NULL,NULL,'9e1509aa7c8d4d0cb239806f3893daa8',NULL,NULL,NULL,NULL,'2025-11-23 09:58:40',NULL,'2025-11-23 09:58:40',NULL,NULL),(207,NULL,NULL,'5220754613304322bc47525d7b9ef59c',NULL,NULL,NULL,NULL,'2025-11-23 09:58:40',NULL,'2025-11-23 09:58:40',NULL,NULL),(208,NULL,NULL,'53b2929f6da048c181c39c64e75636b9',NULL,NULL,NULL,NULL,'2025-11-23 09:58:40',NULL,'2025-11-23 09:58:40',NULL,NULL),(209,NULL,NULL,'335ce4c5b69e467e8228e03531b56559',NULL,NULL,NULL,NULL,'2025-11-23 09:58:40',NULL,'2025-11-23 09:58:40',NULL,NULL),(210,NULL,NULL,'aed3335da1b944d6953b359f533e1d8d',NULL,NULL,NULL,NULL,'2025-11-23 09:58:40',NULL,'2025-11-23 09:58:40',NULL,NULL),(211,NULL,'ab211eba112249c1848bf46372e51795',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:42',NULL,'2025-11-23 09:58:42',NULL,NULL),(212,NULL,'c7047e95fc15472baff3b8d9f1f36088',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:42',NULL,'2025-11-23 09:58:42',NULL,NULL),(213,NULL,'bd2213585ade4feeb501d23c6e94d68d',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:42',NULL,'2025-11-23 09:58:42',NULL,NULL),(214,NULL,'30049f2c0d014a068f4d904feefb5fc2',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:42',NULL,'2025-11-23 09:58:42',NULL,NULL),(215,NULL,'5186274bd7f9413fb47cc4c0b2543b39',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:43',NULL,'2025-11-23 09:58:43',NULL,NULL),(216,NULL,'bb4dc72b058846cf83905caa622cf6d9',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:43',NULL,'2025-11-23 09:58:43',NULL,NULL),(217,NULL,'e74931d339764296994b598532d0ef76',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:44',NULL,'2025-11-23 09:58:44',NULL,NULL),(218,NULL,NULL,'cbf9404a1294406ea01034cebc3048a1',NULL,NULL,NULL,NULL,'2025-11-23 09:58:44',NULL,'2025-11-23 09:58:44',NULL,NULL),(219,NULL,'4980e4408d8f4ec8b1d2c050f71d9393',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:45',NULL,'2025-11-23 09:58:45',NULL,NULL),(220,NULL,'8ea9bf94656d40f2aca1040ef9fa7c71',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:45',NULL,'2025-11-23 09:58:45',NULL,NULL),(221,NULL,NULL,'cd12541d8c1548988d4a7cd63bbf4b6a',NULL,NULL,NULL,NULL,'2025-11-23 09:58:45',NULL,'2025-11-23 09:58:45',NULL,NULL),(222,NULL,NULL,'ed45f6a8f1ed47fb9c973288a36ab02f',NULL,NULL,NULL,NULL,'2025-11-23 09:58:46',NULL,'2025-11-23 09:58:46',NULL,NULL),(223,NULL,NULL,'83d379e011b54a07b03555df58c154b2',NULL,NULL,NULL,NULL,'2025-11-23 09:58:47',NULL,'2025-11-23 09:58:47',NULL,NULL),(224,NULL,NULL,NULL,NULL,NULL,'f1499dde9e3d480aa21780b7c9c98026',NULL,'2025-11-23 09:58:47',NULL,'2025-11-23 09:58:47',NULL,NULL),(225,NULL,NULL,NULL,NULL,NULL,'7d912c16c9444ba482339fcaed41dae6',NULL,'2025-11-23 09:58:47',NULL,'2025-11-23 09:58:47',NULL,NULL),(226,NULL,NULL,'b3367a2110ee4ef0b9014b3fe6efbf23',NULL,NULL,NULL,NULL,'2025-11-23 09:58:47',NULL,'2025-11-23 09:58:47',NULL,NULL),(227,NULL,NULL,'9c7f8af563b74ef2b90774a3ce4266e6',NULL,NULL,NULL,NULL,'2025-11-23 09:58:47',NULL,'2025-11-23 09:58:47',NULL,NULL),(228,NULL,NULL,NULL,NULL,NULL,'c91cc13877814ce49322d1119fb79586',NULL,'2025-11-23 09:58:47',NULL,'2025-11-23 09:58:47',NULL,NULL),(229,NULL,'7e3122f76e0a40ff94890f8e7854abf7',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:48',NULL,'2025-11-23 09:58:48',NULL,NULL),(230,NULL,NULL,NULL,NULL,NULL,'5274f35e55634d3faf873222014227c6',NULL,'2025-11-23 09:58:48',NULL,'2025-11-23 09:58:48',NULL,NULL),(231,NULL,NULL,NULL,NULL,NULL,'6d5f4b1b2591461cb406c8145c06792c',NULL,'2025-11-23 09:58:48',NULL,'2025-11-23 09:58:48',NULL,NULL),(232,NULL,'52673a9bbc3f4264912e26aa540f314e',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:48',NULL,'2025-11-23 09:58:48',NULL,NULL),(233,NULL,NULL,'e0807bb9e8d543e7ab78b750f7b9a276',NULL,NULL,NULL,NULL,'2025-11-23 09:58:48',NULL,'2025-11-23 09:58:48',NULL,NULL),(234,NULL,NULL,'fe2b908c38ab49a881bf359ca4df719e',NULL,NULL,NULL,NULL,'2025-11-23 09:58:48',NULL,'2025-11-23 09:58:48',NULL,NULL),(235,NULL,'8338d6dd941842a2ab0ec074ec00139a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:49',NULL,'2025-11-23 09:58:49',NULL,NULL),(236,NULL,'80bafb6f63b24b79bb3f55ed094c9541',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:49',NULL,'2025-11-23 09:58:49',NULL,NULL),(237,NULL,NULL,'d82291ffc1554c39bf5d467b6bf80086',NULL,NULL,NULL,NULL,'2025-11-23 09:58:50',NULL,'2025-11-23 09:58:50',NULL,NULL),(238,NULL,'e2b303fdfa014fd6b9c99bbabc38c328',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:51',NULL,'2025-11-23 09:58:51',NULL,NULL),(239,NULL,'2959e92a10844592a3d01b33dd743410',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:51',NULL,'2025-11-23 09:58:51',NULL,NULL),(240,NULL,'70507914f5774f12aec8e25bd9b52634',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:52',NULL,'2025-11-23 09:58:52',NULL,NULL),(241,NULL,'ba0ecfa5d03c45f886e034c538a77edd',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:52',NULL,'2025-11-23 09:58:52',NULL,NULL),(242,NULL,NULL,'0c3dfd6df95e4481895ec4c98abb5301',NULL,NULL,NULL,NULL,'2025-11-23 09:58:53',NULL,'2025-11-23 09:58:53',NULL,NULL),(243,NULL,NULL,'03c6a3ff96f84201b40371519c3e6c75',NULL,NULL,NULL,NULL,'2025-11-23 09:58:53',NULL,'2025-11-23 09:58:53',NULL,NULL),(244,NULL,'cc6216eb0a2d4647ab224c843a27df75',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:54',NULL,'2025-11-23 09:58:54',NULL,NULL),(245,NULL,NULL,'9a28cb0574d148bf982a2a1a0b495020',NULL,NULL,NULL,NULL,'2025-11-23 09:58:55',NULL,'2025-11-23 09:58:55',NULL,NULL),(246,NULL,NULL,'d490760b7f0f4361a67870276d80560d',NULL,NULL,NULL,NULL,'2025-11-23 09:58:55',NULL,'2025-11-23 09:58:55',NULL,NULL),(247,NULL,NULL,'ce327431ed50438a933df74f96ea5e7b',NULL,NULL,NULL,NULL,'2025-11-23 09:58:55',NULL,'2025-11-23 09:58:55',NULL,NULL),(248,NULL,'483dbf0692c64784bd659bf6d8dd69ea',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:55',NULL,'2025-11-23 09:58:55',NULL,NULL),(249,NULL,'9e0eb6249a0548c0ad772871741f0b5d',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:56',NULL,'2025-11-23 09:58:56',NULL,NULL),(250,NULL,'a2148c18d8f24a6db12dc22c787e8b2e',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:56',NULL,'2025-11-23 09:58:56',NULL,NULL),(251,NULL,'eb8cffa83c1147c7baa506c6fbdf1234',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:56',NULL,'2025-11-23 09:58:56',NULL,NULL),(252,NULL,NULL,'20769659b53b494d80184a58cada712f',NULL,NULL,NULL,NULL,'2025-11-23 09:58:57',NULL,'2025-11-23 09:58:57',NULL,NULL),(253,NULL,NULL,'5f5d3f13eeb042aea8f2ac1308ae1906',NULL,NULL,NULL,NULL,'2025-11-23 09:58:57',NULL,'2025-11-23 09:58:57',NULL,NULL),(254,NULL,NULL,'b57cc38a6a054499b9e6eb17be12fdf9',NULL,NULL,NULL,NULL,'2025-11-23 09:58:58',NULL,'2025-11-23 09:58:58',NULL,NULL),(255,NULL,NULL,'c34a51add2c3472ebb6a7c729dca1fd7',NULL,NULL,NULL,NULL,'2025-11-23 09:58:58',NULL,'2025-11-23 09:58:58',NULL,NULL),(256,NULL,'d0c5ba5ede094c14895ede799e94fb24',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:59',NULL,'2025-11-23 09:58:59',NULL,NULL),(257,NULL,'83a36fd209f14ea7aae5d4874562f8e2',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:59',NULL,'2025-11-23 09:58:59',NULL,NULL),(258,NULL,'d657447df3bc4b1390e511e45d3a7995',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:58:59',NULL,'2025-11-23 09:58:59',NULL,NULL),(259,NULL,NULL,'d7e8aee2559b42359a0288c79fdd8cc9',NULL,NULL,NULL,NULL,'2025-11-23 09:59:00',NULL,'2025-11-23 09:59:00',NULL,NULL),(260,NULL,'1f86ce3e6201419fb1f6c6315559f267',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:00',NULL,'2025-11-23 09:59:00',NULL,NULL),(261,NULL,NULL,'01ebfc0946b84a76ba85fe79d54935f3',NULL,NULL,NULL,NULL,'2025-11-23 09:59:00',NULL,'2025-11-23 09:59:00',NULL,NULL),(262,NULL,'85d3f51447604504a3be844d92a7c9b1',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:00',NULL,'2025-11-23 09:59:00',NULL,NULL),(263,NULL,NULL,'458608db20064131b38135793f38ea23',NULL,NULL,NULL,NULL,'2025-11-23 09:59:00',NULL,'2025-11-23 09:59:00',NULL,NULL),(264,NULL,NULL,'c598a1c415044b91b6bfeb841c22b2c5',NULL,NULL,NULL,NULL,'2025-11-23 09:59:00',NULL,'2025-11-23 09:59:00',NULL,NULL),(265,NULL,'732be6ab6e2f47ddaf95db08921fa750',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:01',NULL,'2025-11-23 09:59:01',NULL,NULL),(266,NULL,'430015014cc14728b0737ecef0de72a0',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:02',NULL,'2025-11-23 09:59:02',NULL,NULL),(267,NULL,'d187e9e6e80c4518821f51ef2c429478',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:02',NULL,'2025-11-23 09:59:02',NULL,NULL),(268,NULL,'9f64d5b5b7134ff99478d69ce9945e07',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:03',NULL,'2025-11-23 09:59:03',NULL,NULL),(269,NULL,NULL,'26ec2ef5085a4cc9af24daf79ca24af5',NULL,NULL,NULL,NULL,'2025-11-23 09:59:03',NULL,'2025-11-23 09:59:03',NULL,NULL),(270,NULL,NULL,'59a9df806e8e4ac9b0e79a27f80b88a2',NULL,NULL,NULL,NULL,'2025-11-23 09:59:03',NULL,'2025-11-23 09:59:03',NULL,NULL),(271,NULL,NULL,'b41e445579954caba283440fb92a5c26',NULL,NULL,NULL,NULL,'2025-11-23 09:59:03',NULL,'2025-11-23 09:59:03',NULL,NULL),(272,NULL,NULL,'5aac1f1cad1c49eea0d8176c0d62129e',NULL,NULL,NULL,NULL,'2025-11-23 09:59:03',NULL,'2025-11-23 09:59:03',NULL,NULL),(273,NULL,'db44a6296f4c4a8897dec3a50f51edc5',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:05',NULL,'2025-11-23 09:59:05',NULL,NULL),(274,NULL,'0973279be84143fd8201eaa67cbe85aa',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:05',NULL,'2025-11-23 09:59:05',NULL,NULL),(275,NULL,NULL,'45b388d2807e40c6a718a308cb7e0c3a',NULL,NULL,NULL,NULL,'2025-11-23 09:59:05',NULL,'2025-11-23 09:59:05',NULL,NULL),(276,NULL,'02fc34ff57974ba691d90dc17b6f75be',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:05',NULL,'2025-11-23 09:59:05',NULL,NULL),(277,NULL,'9099a7b8da8a44509fe9d61a3c69ee14',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:06',NULL,'2025-11-23 09:59:06',NULL,NULL),(278,NULL,'f7a4200211714c5d8bf40bf21dd55d09',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:07',NULL,'2025-11-23 09:59:07',NULL,NULL),(279,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:09',NULL,'2025-11-23 09:59:09','IQLCbWuMSH-fATXVpUZHIw',NULL),(280,NULL,NULL,'2eef4b4696b24612a27775e1a8c80e45',NULL,NULL,NULL,NULL,'2025-11-23 09:59:09',NULL,'2025-11-23 09:59:09',NULL,NULL),(281,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:09',NULL,'2025-11-23 09:59:09','ih0X3ZSwQV-GEO3OMXxASw',NULL),(282,NULL,NULL,'deff06f1954d4987b5fc7629f015c935',NULL,NULL,NULL,NULL,'2025-11-23 09:59:09',NULL,'2025-11-23 09:59:09',NULL,NULL),(283,NULL,'80975f29d6034bdebe88f7216bad08ee',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:11',NULL,'2025-11-23 09:59:11',NULL,NULL),(284,NULL,NULL,'7f7875c0084c46fdb2e7b37e4fc44faf',NULL,NULL,NULL,NULL,'2025-11-23 09:59:11',NULL,'2025-11-23 09:59:11',NULL,NULL),(285,NULL,NULL,'ad1995ebc8334aa1bc1f8753f5df7d6f',NULL,NULL,NULL,NULL,'2025-11-23 09:59:11',NULL,'2025-11-23 09:59:11',NULL,NULL),(286,NULL,'d143ea58bc354d44af7984802aa21457',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:12',NULL,'2025-11-23 09:59:12',NULL,NULL),(287,NULL,'57d9e088e75b4a3482d0e3a02bcce5be',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:12',NULL,'2025-11-23 09:59:12',NULL,NULL),(288,NULL,NULL,'4b677b000abe4b0687ff1afcd1016893',NULL,NULL,NULL,NULL,'2025-11-23 09:59:12',NULL,'2025-11-23 09:59:12',NULL,NULL),(289,NULL,NULL,'281fa775288f494a8e0fa1378bc178ef',NULL,NULL,NULL,NULL,'2025-11-23 09:59:13',NULL,'2025-11-23 09:59:13',NULL,NULL),(290,NULL,'253c88568a634476a6c1284eed6a9464',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:13',NULL,'2025-11-23 09:59:13',NULL,NULL),(291,NULL,'2a693c1f03094401b2a83bfa038e2d85',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:13',NULL,'2025-11-23 09:59:13',NULL,NULL),(292,NULL,'3e21df5084b344fd9c4fc050a93e2dcc',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:14',NULL,'2025-11-23 09:59:14',NULL,NULL),(293,NULL,NULL,'2eef4b4696b24612a27775e1a8c80e45',NULL,NULL,NULL,NULL,'2025-11-23 09:59:15',NULL,'2025-11-23 09:59:15',NULL,NULL),(294,NULL,'0e649d6a85de4f19918d4d1cd95bd9ed',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:15',NULL,'2025-11-23 09:59:15',NULL,NULL),(295,NULL,'6e69162d552a4c1cad234b7245749687',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:16',NULL,'2025-11-23 09:59:16',NULL,NULL),(296,NULL,NULL,'dc2e60b326bb43f6bda32892ba128631',NULL,NULL,NULL,NULL,'2025-11-23 09:59:16',NULL,'2025-11-23 09:59:16',NULL,NULL),(297,NULL,NULL,'33d60b2e0d464740b9d3ef23a606ba17',NULL,NULL,NULL,NULL,'2025-11-23 09:59:17',NULL,'2025-11-23 09:59:17',NULL,NULL),(298,NULL,NULL,'0606c0b5c3b1478c82421e2a1a9cf39a',NULL,NULL,NULL,NULL,'2025-11-23 09:59:17',NULL,'2025-11-23 09:59:17',NULL,NULL),(299,NULL,NULL,'5a805c5054954a7d97f2f746271d60ed',NULL,NULL,NULL,NULL,'2025-11-23 09:59:17',NULL,'2025-11-23 09:59:17',NULL,NULL),(300,NULL,NULL,'237cdfec51b7461894043b2c095b644d',NULL,NULL,NULL,NULL,'2025-11-23 09:59:17',NULL,'2025-11-23 09:59:17',NULL,NULL),(301,NULL,NULL,'492e2909a77a4032ab6c29a26d12fb14',NULL,NULL,NULL,NULL,'2025-11-23 09:59:18',NULL,'2025-11-23 09:59:18',NULL,NULL),(302,NULL,'c2674d6da7804fadaba13320d35edaf3',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:18',NULL,'2025-11-23 09:59:18',NULL,NULL),(303,NULL,NULL,'e44a6bd1d62941ba8198361f49771edd',NULL,NULL,NULL,NULL,'2025-11-23 09:59:18',NULL,'2025-11-23 09:59:18',NULL,NULL),(304,NULL,'4ed6603cba794c7cb1ea4e536c293d01',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:19',NULL,'2025-11-23 09:59:19',NULL,NULL),(305,NULL,NULL,'1e861805a7404f2c8132835f5c6675dd',NULL,NULL,NULL,NULL,'2025-11-23 09:59:19',NULL,'2025-11-23 09:59:19',NULL,NULL),(306,NULL,'107d8d708122493f8c19fc2b45c5fd97',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:19',NULL,'2025-11-23 09:59:19',NULL,NULL),(307,NULL,NULL,'20beda8ad5654affb444ea0717cb7269',NULL,NULL,NULL,NULL,'2025-11-23 09:59:19',NULL,'2025-11-23 09:59:19',NULL,NULL),(308,NULL,'0497de4959b2494e8036eb39226430d6',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:19',NULL,'2025-11-23 09:59:19',NULL,NULL),(309,NULL,'49a2f1439df84c4e8030e0c391d8e05c',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:19',NULL,'2025-11-23 09:59:19',NULL,NULL),(310,NULL,'710994b77b194080b1d547ca58cc5261',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:19',NULL,'2025-11-23 09:59:19',NULL,NULL),(311,NULL,'9035412fa38e41eabeb631b45701ca46',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:20',NULL,'2025-11-23 09:59:20',NULL,NULL),(312,NULL,'e7cffa0b79d54ab6ba18a457d6dfd174',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:20',NULL,'2025-11-23 09:59:20',NULL,NULL),(313,NULL,'834ab2641cba4539bcd3e4bbad3cd71a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:21',NULL,'2025-11-23 09:59:21',NULL,NULL),(314,NULL,NULL,'425e7dc09b6e49c29bdfef6ecd3ed499',NULL,NULL,NULL,NULL,'2025-11-23 09:59:23',NULL,'2025-11-23 09:59:23',NULL,NULL),(315,NULL,'81cc61f1e4f74bd4a23302d49d4bd1c9',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:23',NULL,'2025-11-23 09:59:23',NULL,NULL),(316,NULL,NULL,'778306461d6e451599df203145021737',NULL,NULL,NULL,NULL,'2025-11-23 09:59:23',NULL,'2025-11-23 09:59:23',NULL,NULL),(317,NULL,NULL,'a702b3b74ac94cd68b37e4d99833db98',NULL,NULL,NULL,NULL,'2025-11-23 09:59:23',NULL,'2025-11-23 09:59:23',NULL,NULL),(318,NULL,'171d9a6b1a784827889e6e9877dae3db',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:25',NULL,'2025-11-23 09:59:25',NULL,NULL),(319,NULL,'4f1c13dc245e4f82ba89c602243326aa',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:25',NULL,'2025-11-23 09:59:25',NULL,NULL),(320,NULL,NULL,'499cb10d27674320a425d8e15cd00566',NULL,NULL,NULL,NULL,'2025-11-23 09:59:25',NULL,'2025-11-23 09:59:25',NULL,NULL),(321,NULL,NULL,'c6bbc190cf8141ac894e1e8174c5b630',NULL,NULL,NULL,NULL,'2025-11-23 09:59:25',NULL,'2025-11-23 09:59:25',NULL,NULL),(322,NULL,'f002c9eea35641ed9cf1996e3c7c43cc',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:25',NULL,'2025-11-23 09:59:25',NULL,NULL),(323,NULL,NULL,'9acd44ab3ee84624a5ae4609c88c3c25',NULL,NULL,NULL,NULL,'2025-11-23 09:59:25',NULL,'2025-11-23 09:59:25',NULL,NULL),(324,NULL,'ffd5130f207b40bf8c46659997a668ca',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:25',NULL,'2025-11-23 09:59:25',NULL,NULL),(325,NULL,NULL,'41ccf184238d4961ac800ad49f223721',NULL,NULL,NULL,NULL,'2025-11-23 09:59:26',NULL,'2025-11-23 09:59:26',NULL,NULL),(326,NULL,'0059440401464a00b03d245bce820674',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:28',NULL,'2025-11-23 09:59:28',NULL,NULL),(327,NULL,NULL,'41ccf184238d4961ac800ad49f223721',NULL,NULL,NULL,NULL,'2025-11-23 09:59:28',NULL,'2025-11-23 09:59:28',NULL,NULL),(328,NULL,'c8bfa6aabfc84848b630b38eb2fd4360',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:28',NULL,'2025-11-23 09:59:28',NULL,NULL),(329,NULL,'b9fb8bbcd0c94e2fa852d3941962ebed',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:29',NULL,'2025-11-23 09:59:29',NULL,NULL),(330,NULL,NULL,'88b729f9df32424cbb65d261a5ae3670',NULL,NULL,NULL,NULL,'2025-11-23 09:59:30',NULL,'2025-11-23 09:59:30',NULL,NULL),(331,NULL,NULL,'b5fe9835561349329166a83dee5470f8',NULL,NULL,NULL,NULL,'2025-11-23 09:59:30',NULL,'2025-11-23 09:59:30',NULL,NULL),(332,NULL,'1530663da07244ffa126031eeddc2726',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:30',NULL,'2025-11-23 09:59:30',NULL,NULL),(333,NULL,NULL,'2b9fdc925bfe490f87a6812385eb7f01',NULL,NULL,NULL,NULL,'2025-11-23 09:59:30',NULL,'2025-11-23 09:59:30',NULL,NULL),(334,NULL,NULL,'eab0a4abdc7f421aaf7177d3672a8d9a',NULL,NULL,NULL,NULL,'2025-11-23 09:59:32',NULL,'2025-11-23 09:59:32',NULL,NULL),(335,NULL,NULL,'990530eea2bb40c0b3f0f471d88500e4',NULL,NULL,NULL,NULL,'2025-11-23 09:59:32',NULL,'2025-11-23 09:59:32',NULL,NULL),(336,NULL,'b20ba61f961540ca8918c742dd792f39',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:32',NULL,'2025-11-23 09:59:32',NULL,NULL),(337,NULL,'51243be9628f47e6a2ef16bb0430fea9',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:33',NULL,'2025-11-23 09:59:33',NULL,NULL),(338,NULL,'c203fad2678f4447b6d722a12d952e08',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:34',NULL,'2025-11-23 09:59:34',NULL,NULL),(339,NULL,'c21cadb38be14f6fb875660f5d979817',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:34',NULL,'2025-11-23 09:59:34',NULL,NULL),(340,NULL,'0b9baa96686540ef835968fb22f1ab9b',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:35',NULL,'2025-11-23 09:59:35',NULL,NULL),(341,NULL,NULL,'cc3c1b93e3014253bc0db0f4ef6f833f',NULL,NULL,NULL,NULL,'2025-11-23 09:59:36',NULL,'2025-11-23 09:59:36',NULL,NULL),(342,NULL,NULL,'924b04d509744aa59ab90825723761be',NULL,NULL,NULL,NULL,'2025-11-23 09:59:36',NULL,'2025-11-23 09:59:36',NULL,NULL),(343,NULL,'c1b218a298814f81811d06e4ddeeca2f',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:37',NULL,'2025-11-23 09:59:37',NULL,NULL),(344,NULL,'b2bac91a08554ba7a6696587ae9017ca',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:37',NULL,'2025-11-23 09:59:37',NULL,NULL),(345,NULL,NULL,'6ebb20a748ab4396867116924a69bebe',NULL,NULL,NULL,NULL,'2025-11-23 09:59:39',NULL,'2025-11-23 09:59:39',NULL,NULL),(346,NULL,NULL,'d6a48d1de73e4b22adfbfbf913ad4c28',NULL,NULL,NULL,NULL,'2025-11-23 09:59:39',NULL,'2025-11-23 09:59:39',NULL,NULL),(347,NULL,NULL,'51dae0e3701e4973b75bfc954b9dc68f',NULL,NULL,NULL,NULL,'2025-11-23 09:59:39',NULL,'2025-11-23 09:59:39',NULL,NULL),(348,NULL,NULL,'1b4d089ee9904bbda89306850769ab3e',NULL,NULL,NULL,NULL,'2025-11-23 09:59:40',NULL,'2025-11-23 09:59:40',NULL,NULL),(349,NULL,'249e3ad2b54244c0a15cd0a2ab31d9ab',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:40',NULL,'2025-11-23 09:59:40',NULL,NULL),(350,NULL,'e808b73daab34d0784f606443f936d8c',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:41',NULL,'2025-11-23 09:59:41',NULL,NULL),(351,NULL,'12365f2c95a448468cd94659898f5f4d',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:41',NULL,'2025-11-23 09:59:41',NULL,NULL),(352,NULL,NULL,'264a0e5e315143ba97a60d0343441405',NULL,NULL,NULL,NULL,'2025-11-23 09:59:42',NULL,'2025-11-23 09:59:42',NULL,NULL),(353,NULL,NULL,'02326c3711e3415dae799dbe040096ff',NULL,NULL,NULL,NULL,'2025-11-23 09:59:42',NULL,'2025-11-23 09:59:42',NULL,NULL),(354,NULL,NULL,'5692e89698ef4a7691d3215800814bea',NULL,NULL,NULL,NULL,'2025-11-23 09:59:42',NULL,'2025-11-23 09:59:42',NULL,NULL),(355,NULL,'4cd172f4a5a54422a486cfecc32591e5',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:42',NULL,'2025-11-23 09:59:42',NULL,NULL),(356,NULL,'d3230960dd6e4c8bb9d7d876d5f52a50',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:43',NULL,'2025-11-23 09:59:43',NULL,NULL),(357,NULL,NULL,'1df38cfca4e64f15a40297fb2b675901',NULL,NULL,NULL,NULL,'2025-11-23 09:59:44',NULL,'2025-11-23 09:59:44',NULL,NULL),(358,NULL,'09bcdf0c2fec4bf5991d15e58003cf56',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:45',NULL,'2025-11-23 09:59:45',NULL,NULL),(359,NULL,'64177ff73b0d4c5cb41b8b9c141cbb69',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:46',NULL,'2025-11-23 09:59:46',NULL,NULL),(360,NULL,'910f6b0db292481fb9892ec1a8b5deef',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:47',NULL,'2025-11-23 09:59:47',NULL,NULL),(361,NULL,NULL,'55581f20ed8d4bd8a61a81c525ca8141',NULL,NULL,NULL,NULL,'2025-11-23 09:59:48',NULL,'2025-11-23 09:59:48',NULL,NULL),(362,NULL,NULL,'25162d9a482a4cd38c99a8e94bc63cc3',NULL,NULL,NULL,NULL,'2025-11-23 09:59:48',NULL,'2025-11-23 09:59:48',NULL,NULL),(363,NULL,NULL,'5ec2d30855854e1b877f3c3c2e0ac13f',NULL,NULL,NULL,NULL,'2025-11-23 09:59:48',NULL,'2025-11-23 09:59:48',NULL,NULL),(364,NULL,NULL,'f0946ceefadd41d9b94211732d88e5de',NULL,NULL,NULL,NULL,'2025-11-23 09:59:49',NULL,'2025-11-23 09:59:49',NULL,NULL),(365,NULL,'1cdadb4c9b1844539a31e08d31ee307b',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:50',NULL,'2025-11-23 09:59:50',NULL,NULL),(366,NULL,'37a58b702f564a81ab5a59cf4201b4f0',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:50',NULL,'2025-11-23 09:59:50',NULL,NULL),(367,NULL,'2a41d8918b084b1c8f9ff361cb511995',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:51',NULL,'2025-11-23 09:59:51',NULL,NULL),(368,NULL,NULL,'f0946ceefadd41d9b94211732d88e5de',NULL,NULL,NULL,NULL,'2025-11-23 09:59:51',NULL,'2025-11-23 09:59:51',NULL,NULL),(369,NULL,'48734328ac974be39fbe56aae790aa24',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:52',NULL,'2025-11-23 09:59:52',NULL,NULL),(370,NULL,'ef5ba10065fe43e495a131613a0c5697',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:52',NULL,'2025-11-23 09:59:52',NULL,NULL),(371,NULL,'7c37e71882794cb3aaade676a7b76555',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:52',NULL,'2025-11-23 09:59:52',NULL,NULL),(372,NULL,'e5a4b2286a4a475887ed51bb4020d980',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:53',NULL,'2025-11-23 09:59:53',NULL,NULL),(373,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:54',NULL,'2025-11-23 09:59:54','nPcCMP2GRDSIlp4gNbxH3A',NULL),(374,NULL,'1219237ba63d47f095a5ffecee2e16dc',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:55',NULL,'2025-11-23 09:59:55',NULL,NULL),(375,NULL,'2f24a3732a13473b903611c736629db8',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:55',NULL,'2025-11-23 09:59:55',NULL,NULL),(376,NULL,NULL,'49a3bfe094c74481ae5615aa801a11a6',NULL,NULL,NULL,NULL,'2025-11-23 09:59:55',NULL,'2025-11-23 09:59:55',NULL,NULL),(377,NULL,NULL,'7768874795d7425dad8a9e58bf735a97',NULL,NULL,NULL,NULL,'2025-11-23 09:59:56',NULL,'2025-11-23 09:59:56',NULL,NULL),(378,NULL,NULL,'d12ae990dd344dc49f508a3dc1d0adc1',NULL,NULL,NULL,NULL,'2025-11-23 09:59:56',NULL,'2025-11-23 09:59:56',NULL,NULL),(379,NULL,NULL,'f0946ceefadd41d9b94211732d88e5de',NULL,NULL,NULL,NULL,'2025-11-23 09:59:56',NULL,'2025-11-23 09:59:56',NULL,NULL),(380,NULL,'24029d69ffea4b3dbdb4dbf3904bf514',NULL,NULL,NULL,NULL,NULL,'2025-11-23 09:59:59',NULL,'2025-11-23 09:59:59',NULL,NULL),(381,NULL,'3f1f4cc78c5e495b8a70db1d39e34697',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:02',NULL,'2025-11-23 10:00:02',NULL,NULL),(382,NULL,'9871df34e4444dd4b1ee50ef1d11b776',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:05',NULL,'2025-11-23 10:00:05',NULL,NULL),(383,NULL,NULL,'18b3f5805ff2419d91d36e315c79f361',NULL,NULL,NULL,NULL,'2025-11-23 10:00:05',NULL,'2025-11-23 10:00:05',NULL,NULL),(384,NULL,'f2e2f7f2c0054b9bb54cb70bfb2267e5',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:06',NULL,'2025-11-23 10:00:06',NULL,NULL),(385,NULL,NULL,'e417c335a8834b748d90667c46a1289a',NULL,NULL,NULL,NULL,'2025-11-23 10:00:08',NULL,'2025-11-23 10:00:08',NULL,NULL),(386,NULL,NULL,'e417c335a8834b748d90667c46a1289a',NULL,NULL,NULL,NULL,'2025-11-23 10:00:09',NULL,'2025-11-23 10:00:09',NULL,NULL),(387,NULL,'75366db104ac41b0b403c71040089528',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:09',NULL,'2025-11-23 10:00:09',NULL,NULL),(388,NULL,NULL,'307b847f0bf4479d935bcf0af0d1236a',NULL,NULL,NULL,NULL,'2025-11-23 10:00:09',NULL,'2025-11-23 10:00:09',NULL,NULL),(389,NULL,NULL,'363f885e51874ce7b0d212cd393f3c61',NULL,NULL,NULL,NULL,'2025-11-23 10:00:09',NULL,'2025-11-23 10:00:09',NULL,NULL),(390,NULL,NULL,'c3eafb7b5ce64aa4bd47d36688910786',NULL,NULL,NULL,NULL,'2025-11-23 10:00:09',NULL,'2025-11-23 10:00:09',NULL,NULL),(391,NULL,'7ed9e90024674d22809267aebd2facff',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:10',NULL,'2025-11-23 10:00:10',NULL,NULL),(392,NULL,'c8830f9fffd448c080056d9d99819bb9',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:10',NULL,'2025-11-23 10:00:10',NULL,NULL),(393,NULL,'7a618e1a82c34873b885a92b19ef20b6',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:10',NULL,'2025-11-23 10:00:10',NULL,NULL),(394,NULL,'9fc26cb188164c5086e8f6bf605f86e9',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:11',NULL,'2025-11-23 10:00:11',NULL,NULL),(395,NULL,'1e40a2e64358455cb668b513100a405d',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:11',NULL,'2025-11-23 10:00:11',NULL,NULL),(396,NULL,'68ce61d7abcb481080263e8d5274d0f8',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:12',NULL,'2025-11-23 10:00:12',NULL,NULL),(397,NULL,'8166869dbcea49adb848f3f5876e6894',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:12',NULL,'2025-11-23 10:00:12',NULL,NULL),(398,NULL,'72fea58445be4b86bf336cc4ddfd7065',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:12',NULL,'2025-11-23 10:00:12',NULL,NULL),(399,NULL,'33d3c13cde42445eb1bd10a2bd0ee644',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:12',NULL,'2025-11-23 10:00:12',NULL,NULL),(400,NULL,'6c05b7730c504824acdeb34b2ba927bf',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:13',NULL,'2025-11-23 10:00:13',NULL,NULL),(401,NULL,'a0953ee7083946c69bd145c3881a10aa',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:13',NULL,'2025-11-23 10:00:13',NULL,NULL),(402,NULL,'cde0a3f2b3d644d6adf94fc3f2a223c0',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:13',NULL,'2025-11-23 10:00:13',NULL,NULL),(403,NULL,'59292f34ff474724a898518d99f68f37',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:14',NULL,'2025-11-23 10:00:14',NULL,NULL),(404,NULL,'2b1900b7880741bdac7ffbcb4d72a438',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:14',NULL,'2025-11-23 10:00:14',NULL,NULL),(405,NULL,'54bf39804da24e4d9b51fa4e92f8b8f7',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:14',NULL,'2025-11-23 10:00:14',NULL,NULL),(406,NULL,'1839fc4524a6418fb1618029d8a9cd69',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:15',NULL,'2025-11-23 10:00:15',NULL,NULL),(407,NULL,'f610c6ec189647569b9545cd77c9a5c3',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:15',NULL,'2025-11-23 10:00:15',NULL,NULL),(408,NULL,NULL,'01cd7d51d8cd49d2b40ca42074b1152a',NULL,NULL,NULL,NULL,'2025-11-23 10:00:15',NULL,'2025-11-23 10:00:15',NULL,NULL),(409,NULL,NULL,'214c39b5c0624454991f75a5f464b07c',NULL,NULL,NULL,NULL,'2025-11-23 10:00:16',NULL,'2025-11-23 10:00:16',NULL,NULL),(410,NULL,NULL,'9232516fb3644355aba698ac66910d6b',NULL,NULL,NULL,NULL,'2025-11-23 10:00:16',NULL,'2025-11-23 10:00:16',NULL,NULL),(411,NULL,'d7b247e313fc4355ac955c341802a664',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:19',NULL,'2025-11-23 10:00:19',NULL,NULL),(412,NULL,NULL,'3457b85a4f5b4478b951b1bf378f742a',NULL,NULL,NULL,NULL,'2025-11-23 10:00:19',NULL,'2025-11-23 10:00:19',NULL,NULL),(413,NULL,NULL,'f30cb7ce3bac485ca16e284ef2514162',NULL,NULL,NULL,NULL,'2025-11-23 10:00:19',NULL,'2025-11-23 10:00:19',NULL,NULL),(414,NULL,'867111238be840bf97f11b844a1dd84f',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:20',NULL,'2025-11-23 10:00:20',NULL,NULL),(415,NULL,'0d6c514d783c4e2090e66498500366eb',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:20',NULL,'2025-11-23 10:00:20',NULL,NULL),(416,NULL,'d628dde62de84a2fadc154278d6ea611',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:22',NULL,'2025-11-23 10:00:22',NULL,NULL),(417,NULL,NULL,'ddbdf91d2df542708c82a06ea8173809',NULL,NULL,NULL,NULL,'2025-11-23 10:00:22',NULL,'2025-11-23 10:00:22',NULL,NULL),(418,NULL,'493833d8fb394637b29c3fb2052aca9c',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:23',NULL,'2025-11-23 10:00:23',NULL,NULL),(419,NULL,NULL,'9832a3ffaa5d45908515ecaf4f0e4d50',NULL,NULL,NULL,NULL,'2025-11-23 10:00:23',NULL,'2025-11-23 10:00:23',NULL,NULL),(420,NULL,NULL,'c28c9a45364c4e5aaeced66ca4f6095e',NULL,NULL,NULL,NULL,'2025-11-23 10:00:24',NULL,'2025-11-23 10:00:24',NULL,NULL),(421,NULL,'a2a612a279c1457a95570949ffe454dd',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:24',NULL,'2025-11-23 10:00:24',NULL,NULL),(422,NULL,'d38528c3feb64b31add54cee7508cb83',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:24',NULL,'2025-11-23 10:00:24',NULL,NULL),(423,NULL,'0ffd5730cfc54429a6af666c4ae63fe7',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:25',NULL,'2025-11-23 10:00:25',NULL,NULL),(424,NULL,NULL,'97f11e56d68c413d890801b6158a0e7f',NULL,NULL,NULL,NULL,'2025-11-23 10:00:25',NULL,'2025-11-23 10:00:25',NULL,NULL),(425,NULL,NULL,'82920fd030f94233a303bfc96cd59225',NULL,NULL,NULL,NULL,'2025-11-23 10:00:25',NULL,'2025-11-23 10:00:25',NULL,NULL),(426,NULL,'47290a1933ed446d9dc712015a5d6166',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:28',NULL,'2025-11-23 10:00:28',NULL,NULL),(427,NULL,'6a6ca451cdbb490dafde54a020dc9d8b',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:29',NULL,'2025-11-23 10:00:29',NULL,NULL),(428,NULL,NULL,'b2f2f39f6cb34a6b962f473477b29928',NULL,NULL,NULL,NULL,'2025-11-23 10:00:31',NULL,'2025-11-23 10:00:31',NULL,NULL),(429,NULL,'915cfc2718fe49adb44a05588a893ab2',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:33',NULL,'2025-11-23 10:00:33',NULL,NULL),(430,NULL,NULL,'eb280c354bc5482d8955139ff4128ceb',NULL,NULL,NULL,NULL,'2025-11-23 10:00:36',NULL,'2025-11-23 10:00:36',NULL,NULL),(431,NULL,NULL,'e02e3a6650d04cc49a5785719f724cce',NULL,NULL,NULL,NULL,'2025-11-23 10:00:36',NULL,'2025-11-23 10:00:36',NULL,NULL),(432,NULL,NULL,'edfcfece01784e08a192decfb5f28288',NULL,NULL,NULL,NULL,'2025-11-23 10:00:37',NULL,'2025-11-23 10:00:37',NULL,NULL),(433,NULL,'361bacca17df46b5abf7d594792a05ea',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:38',NULL,'2025-11-23 10:00:38',NULL,NULL),(434,NULL,'7537c8677dc44d718f2543b4d11fe4ed',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:40',NULL,'2025-11-23 10:00:40',NULL,NULL),(435,NULL,'cb02ad4f92a44de895fb1e96459d4a8d',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:40',NULL,'2025-11-23 10:00:40',NULL,NULL),(436,NULL,NULL,'ea32fed977904e33b7ca2736303992ec',NULL,NULL,NULL,NULL,'2025-11-23 10:00:42',NULL,'2025-11-23 10:00:42',NULL,NULL),(437,NULL,'7cf5e5b57622461588d7ce06cc485806',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:46',NULL,'2025-11-23 10:00:46',NULL,NULL),(438,NULL,NULL,'720cbee1272a404e80b2fcc59e9beea2',NULL,NULL,NULL,NULL,'2025-11-23 10:00:53',NULL,'2025-11-23 10:00:53',NULL,NULL),(439,NULL,NULL,'fab254a0947440e892fae17522582168',NULL,NULL,NULL,NULL,'2025-11-23 10:00:54',NULL,'2025-11-23 10:00:54',NULL,NULL),(440,NULL,NULL,'e59892284e454ae28c30542a06194f67',NULL,NULL,NULL,NULL,'2025-11-23 10:00:54',NULL,'2025-11-23 10:00:54',NULL,NULL),(441,NULL,'bdcbc1cb959a4f9bbeea8ec1d869ac05',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:54',NULL,'2025-11-23 10:00:54',NULL,NULL),(442,NULL,NULL,'ff56beb1f9e344d39401dfdfd89105cc',NULL,NULL,NULL,NULL,'2025-11-23 10:00:56',NULL,'2025-11-23 10:00:56',NULL,NULL),(443,NULL,'75e62683fb5942ed8b559267881a9ca8',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:56',NULL,'2025-11-23 10:00:56',NULL,NULL),(444,NULL,'7d06d32932c14944b00061256a49a5ca',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:58',NULL,'2025-11-23 10:00:58',NULL,NULL),(445,NULL,'69fbbb3a269149019eeb90b6b37f66c6',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:00:59',NULL,'2025-11-23 10:00:59',NULL,NULL),(446,NULL,NULL,'7d4f5bfedbe54af28d7d993bcd9b2d46',NULL,NULL,NULL,NULL,'2025-11-23 10:01:00',NULL,'2025-11-23 10:01:00',NULL,NULL),(447,NULL,'f79f040c4b56418586e59b73203db885',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:01:02',NULL,'2025-11-23 10:01:02',NULL,NULL),(448,NULL,NULL,'27760697fd2c45999f759a862129e5af',NULL,NULL,NULL,NULL,'2025-11-23 10:01:05',NULL,'2025-11-23 10:01:05',NULL,NULL),(449,NULL,'f5622ef76e6a4d328c523c81acbdbe75',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:01:07',NULL,'2025-11-23 10:01:07',NULL,NULL),(450,NULL,NULL,'979c59ebea4a41138e545e7a80355d4f',NULL,NULL,NULL,NULL,'2025-11-23 10:01:09',NULL,'2025-11-23 10:01:09',NULL,NULL),(451,NULL,NULL,'e78ebdfe612745638abad47217c77d70',NULL,NULL,NULL,NULL,'2025-11-23 10:01:09',NULL,'2025-11-23 10:01:09',NULL,NULL),(452,NULL,NULL,'6adf6361155e40c09d8d1bc2578544ca',NULL,NULL,NULL,NULL,'2025-11-23 10:01:11',NULL,'2025-11-23 10:01:11',NULL,NULL),(453,NULL,NULL,'2cfd21f178604be289d8bb16b3b9c18f',NULL,NULL,NULL,NULL,'2025-11-23 10:01:11',NULL,'2025-11-23 10:01:11',NULL,NULL),(454,NULL,NULL,'7c2185aad22449c7bb5896bc47c70f6a',NULL,NULL,NULL,NULL,'2025-11-23 10:01:11',NULL,'2025-11-23 10:01:11',NULL,NULL),(455,NULL,'a40d996843764f32a4281f01703f5aee',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:01:11',NULL,'2025-11-23 10:01:11',NULL,NULL),(456,NULL,NULL,'61c4c5ccdbb64c18b3bccb9c85c64196',NULL,NULL,NULL,NULL,'2025-11-23 10:01:12',NULL,'2025-11-23 10:01:12',NULL,NULL),(457,NULL,NULL,'a2416099260d4d9e877bc4304b663241',NULL,NULL,NULL,NULL,'2025-11-23 10:01:12',NULL,'2025-11-23 10:01:12',NULL,NULL),(458,NULL,'6f314e40fce04da4aeca3cbd5aaa2677',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:01:13',NULL,'2025-11-23 10:01:13',NULL,NULL),(459,NULL,'22b5d1ffb22c47428f71809e862e842f',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:01:14',NULL,'2025-11-23 10:01:14',NULL,NULL),(460,NULL,'55c4c7fc96924abf8aeac08f9557641f',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:01:14',NULL,'2025-11-23 10:01:14',NULL,NULL),(461,NULL,'7ec1ffc8b5a14820826131bfb7675e61',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:01:17',NULL,'2025-11-23 10:01:17',NULL,NULL),(462,NULL,'bc21bfb11e1a4065a65df68101ed3552',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:01:18',NULL,'2025-11-23 10:01:18',NULL,NULL),(463,NULL,'0f8848490fb54a5cb41f1607121a115c',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:01:20',NULL,'2025-11-23 10:01:20',NULL,NULL),(464,NULL,NULL,'cec0d39dc73b48458e0a0f8c462a1cba',NULL,NULL,NULL,NULL,'2025-11-23 10:01:32',NULL,'2025-11-23 10:01:32',NULL,NULL),(465,NULL,'b89f120d906e4409a0177b37c378adeb',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:01:36',NULL,'2025-11-23 10:01:36',NULL,NULL),(466,NULL,NULL,'28d525c464514c8fb6bb13dfb0d6d401',NULL,NULL,NULL,NULL,'2025-11-23 10:01:39',NULL,'2025-11-23 10:01:39',NULL,NULL),(467,NULL,NULL,'32512604c08f4fa48e6e985a3f6cd6d1',NULL,NULL,NULL,NULL,'2025-11-23 10:01:40',NULL,'2025-11-23 10:01:40',NULL,NULL),(468,NULL,'f552ffbc49734cd69f687383dc092a2b',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:01:41',NULL,'2025-11-23 10:01:41',NULL,NULL),(469,NULL,'79509bc833494f3598e01347dc55dea9',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:01:42',NULL,'2025-11-23 10:01:42',NULL,NULL),(470,NULL,NULL,'78905f23dfbe431489a2eeb66689a098',NULL,NULL,NULL,NULL,'2025-11-23 10:01:45',NULL,'2025-11-23 10:01:45',NULL,NULL),(471,NULL,'79d9e6ce688b4985966e07c85a4e1f78',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:01:45',NULL,'2025-11-23 10:01:45',NULL,NULL),(472,NULL,'b838e5eeb29c48ebb6bf77ea837363e2',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:01:46',NULL,'2025-11-23 10:01:46',NULL,NULL),(473,NULL,NULL,'fcc428367cfa48b088d781e43c36f195',NULL,NULL,NULL,NULL,'2025-11-23 10:01:46',NULL,'2025-11-23 10:01:46',NULL,NULL),(474,NULL,NULL,'b9d6079ff9ab4cb29d9e6c446d15d6e9',NULL,NULL,NULL,NULL,'2025-11-23 10:01:46',NULL,'2025-11-23 10:01:46',NULL,NULL),(475,NULL,NULL,'e50bf0ddfd1d414793fd4dc13715f989',NULL,NULL,NULL,NULL,'2025-11-23 10:01:46',NULL,'2025-11-23 10:01:46',NULL,NULL),(476,NULL,NULL,'99e0886b0922425dadd1e21f7129faa8',NULL,NULL,NULL,NULL,'2025-11-23 10:01:47',NULL,'2025-11-23 10:01:47',NULL,NULL),(477,NULL,NULL,'5ba883b9333d44c9a9c4093d565623d6',NULL,NULL,NULL,NULL,'2025-11-23 10:01:48',NULL,'2025-11-23 10:01:48',NULL,NULL),(478,NULL,NULL,'bf04572e66324af78c5d48fcfa5fc78b',NULL,NULL,NULL,NULL,'2025-11-23 10:01:48',NULL,'2025-11-23 10:01:48',NULL,NULL),(479,NULL,'4645e12519fc4ab5a2e35ba4f7149915',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:01:48',NULL,'2025-11-23 10:01:48',NULL,NULL),(480,NULL,'a180dbb035ce42ac9ec3178829ba27ed',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:01:48',NULL,'2025-11-23 10:01:48',NULL,NULL),(481,NULL,'487bbf319235451597b20df95abab4d5',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:01:50',NULL,'2025-11-23 10:01:50',NULL,NULL),(482,NULL,'9b4ff14ad14b470a96ecd244e7453fa2',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:01:51',NULL,'2025-11-23 10:01:51',NULL,NULL),(483,NULL,'2f5ceb3dcba34969a782c4e8c5c3fe76',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:01:53',NULL,'2025-11-23 10:01:53',NULL,NULL),(484,NULL,NULL,'3069f02f363f4494bd609ba232cd4efd',NULL,NULL,NULL,NULL,'2025-11-23 10:01:53',NULL,'2025-11-23 10:01:53',NULL,NULL),(485,NULL,NULL,'1da5a4e8e4f04f5887ca9091bf0c1ef6',NULL,NULL,NULL,NULL,'2025-11-23 10:01:54',NULL,'2025-11-23 10:01:54',NULL,NULL),(486,NULL,'c05c08b4d8794ff1b33e7233ec64d938',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:01:55',NULL,'2025-11-23 10:01:55',NULL,NULL),(487,NULL,NULL,'6dc9c87b102a44c3afc70c870245f9ec',NULL,NULL,NULL,NULL,'2025-11-23 10:01:55',NULL,'2025-11-23 10:01:55',NULL,NULL),(488,NULL,'9581edc6356e4bea98a814f4d886667d',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:01:55',NULL,'2025-11-23 10:01:55',NULL,NULL),(489,NULL,'90bde9c069b14cf0b371d3fa3b4aacff',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:01:57',NULL,'2025-11-23 10:01:57',NULL,NULL),(490,NULL,NULL,'a02463dab01b4a318fbc9bb3ebbc0c3f',NULL,NULL,NULL,NULL,'2025-11-23 10:01:58',NULL,'2025-11-23 10:01:58',NULL,NULL),(491,NULL,NULL,'8d3ccb2bccdf4a12bb3b492992930601',NULL,NULL,NULL,NULL,'2025-11-23 10:01:58',NULL,'2025-11-23 10:01:58',NULL,NULL),(492,NULL,'3a28a8b9a037403e974a94b765251b53',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:01:58',NULL,'2025-11-23 10:01:58',NULL,NULL),(493,NULL,'90277ee4af9c4e4f93d28a264e0ecffd',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:01:59',NULL,'2025-11-23 10:01:59',NULL,NULL),(494,NULL,NULL,'dd5aedaf26894a49bb4ee53bfbbec3ea',NULL,NULL,NULL,NULL,'2025-11-23 10:01:59',NULL,'2025-11-23 10:01:59',NULL,NULL),(495,NULL,NULL,'27224b46b9424661859e5810fee0946c',NULL,NULL,NULL,NULL,'2025-11-23 10:01:59',NULL,'2025-11-23 10:01:59',NULL,NULL),(496,NULL,NULL,'ca36e3c530cd4996add76add048683eb',NULL,NULL,NULL,NULL,'2025-11-23 10:01:59',NULL,'2025-11-23 10:01:59',NULL,NULL),(497,NULL,'6de614a4ddfd4f868264e9fc1dee856a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:01:59',NULL,'2025-11-23 10:01:59',NULL,NULL),(498,NULL,'a95d56ceca02400bb048e86377bec83f',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:00',NULL,'2025-11-23 10:02:00',NULL,NULL),(499,NULL,'6c4873515b404815a00c0d6c4dd94ae3',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:00',NULL,'2025-11-23 10:02:00',NULL,NULL),(500,NULL,'461e34582027490ebd34279a384a57b1',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:00',NULL,'2025-11-23 10:02:00',NULL,NULL),(501,NULL,NULL,'9f208521b10742b39d885be40979dce5',NULL,NULL,NULL,NULL,'2025-11-23 10:02:00',NULL,'2025-11-23 10:02:00',NULL,NULL),(502,NULL,NULL,'8fed8e65b1cb427d91c31098cfc16300',NULL,NULL,NULL,NULL,'2025-11-23 10:02:01',NULL,'2025-11-23 10:02:01',NULL,NULL),(503,NULL,NULL,'2a1728c536894f859fec3b140f01d4cc',NULL,NULL,NULL,NULL,'2025-11-23 10:02:01',NULL,'2025-11-23 10:02:01',NULL,NULL),(504,NULL,'9c272ef244c94da5abed01f830ce13ef',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:01',NULL,'2025-11-23 10:02:01',NULL,NULL),(505,NULL,'fb9791d358174b77957d83c427c41282',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:02',NULL,'2025-11-23 10:02:02',NULL,NULL),(506,NULL,'a9eafc72df634348812619e947a6e99a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:03',NULL,'2025-11-23 10:02:03',NULL,NULL),(507,NULL,NULL,'48600e9b066140a09192a05596db62d4',NULL,NULL,NULL,NULL,'2025-11-23 10:02:04',NULL,'2025-11-23 10:02:04',NULL,NULL),(508,NULL,'2901c5656bb345d791524cff197e12c6',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:04',NULL,'2025-11-23 10:02:04',NULL,NULL),(509,NULL,'237d7d6eaead4a3a8e336e8954062a9e',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:06',NULL,'2025-11-23 10:02:06',NULL,NULL),(510,NULL,NULL,'f0c329c16706474faf6a45b770d81b59',NULL,NULL,NULL,NULL,'2025-11-23 10:02:06',NULL,'2025-11-23 10:02:06',NULL,NULL),(511,NULL,NULL,'5f59a31a4e22400e8f8a68f905989d9a',NULL,NULL,NULL,NULL,'2025-11-23 10:02:06',NULL,'2025-11-23 10:02:06',NULL,NULL),(512,NULL,NULL,'2bc24484c79d47fc9f1664e34687bf45',NULL,NULL,NULL,NULL,'2025-11-23 10:02:06',NULL,'2025-11-23 10:02:06',NULL,NULL),(513,NULL,NULL,'c2746e989b6a4c88a94857abe4fc4ec8',NULL,NULL,NULL,NULL,'2025-11-23 10:02:07',NULL,'2025-11-23 10:02:07',NULL,NULL),(514,NULL,NULL,'81a969c2ff754931b42ef3b2180624bc',NULL,NULL,NULL,NULL,'2025-11-23 10:02:07',NULL,'2025-11-23 10:02:07',NULL,NULL),(515,NULL,NULL,'19b2e3959bc64938a03fb8a5801f5a66',NULL,NULL,NULL,NULL,'2025-11-23 10:02:07',NULL,'2025-11-23 10:02:07',NULL,NULL),(516,NULL,NULL,'19b2e3959bc64938a03fb8a5801f5a66',NULL,NULL,NULL,NULL,'2025-11-23 10:02:07',NULL,'2025-11-23 10:02:07',NULL,NULL),(517,NULL,NULL,'81a969c2ff754931b42ef3b2180624bc',NULL,NULL,NULL,NULL,'2025-11-23 10:02:08',NULL,'2025-11-23 10:02:08',NULL,NULL),(518,NULL,NULL,'c2746e989b6a4c88a94857abe4fc4ec8',NULL,NULL,NULL,NULL,'2025-11-23 10:02:08',NULL,'2025-11-23 10:02:08',NULL,NULL),(519,NULL,'4b84b07fc6534e88860c454382c4f9f4',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:08',NULL,'2025-11-23 10:02:08',NULL,NULL),(520,NULL,'b8fa70a700964960a82c255d7f038c3d',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:09',NULL,'2025-11-23 10:02:09',NULL,NULL),(521,NULL,NULL,'0bca2aa73c744deebf5bbbb05e66a992',NULL,NULL,NULL,NULL,'2025-11-23 10:02:10',NULL,'2025-11-23 10:02:10',NULL,NULL),(522,NULL,NULL,'6d99cf94434945f6b0f5dd1db3388251',NULL,NULL,NULL,NULL,'2025-11-23 10:02:10',NULL,'2025-11-23 10:02:10',NULL,NULL),(523,NULL,'ae4d38cd0e2447f487d1b2556d686f80',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:10',NULL,'2025-11-23 10:02:10',NULL,NULL),(524,NULL,NULL,'a4f3e75499a64855a2e9fb439943a12d',NULL,NULL,NULL,NULL,'2025-11-23 10:02:10',NULL,'2025-11-23 10:02:10',NULL,NULL),(525,NULL,NULL,'88658cbda1914e1bbb8ddacb8f4fe302',NULL,NULL,NULL,NULL,'2025-11-23 10:02:10',NULL,'2025-11-23 10:02:10',NULL,NULL),(526,NULL,NULL,'58372fd4fa5d43baa701870af639c80a',NULL,NULL,NULL,NULL,'2025-11-23 10:02:10',NULL,'2025-11-23 10:02:10',NULL,NULL),(527,NULL,'ce1b432e503249168bdd722780d135a8',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:12',NULL,'2025-11-23 10:02:12',NULL,NULL),(528,NULL,'747caa446f60440289f8647234ca5e67',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:12',NULL,'2025-11-23 10:02:12',NULL,NULL),(529,NULL,'b609e53eae9d475293564ad1c9f2d841',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:12',NULL,'2025-11-23 10:02:12',NULL,NULL),(530,NULL,'c8cea89fa427407d8e22a238257277d7',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:14',NULL,'2025-11-23 10:02:14',NULL,NULL),(531,NULL,'326238370673429a9e7314b33c802132',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:14',NULL,'2025-11-23 10:02:14',NULL,NULL),(532,NULL,'508c909a63c6498094f0d0fe27effb48',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:17',NULL,'2025-11-23 10:02:17',NULL,NULL),(533,NULL,NULL,'9c4be53c4ce740f8998a19bb978d8705',NULL,NULL,NULL,NULL,'2025-11-23 10:02:17',NULL,'2025-11-23 10:02:17',NULL,NULL),(534,NULL,'352daebfbf15406c8c26e89fb7ec46cc',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:17',NULL,'2025-11-23 10:02:17',NULL,NULL),(535,NULL,NULL,'44fff03bcf63485e8f7db42f925ac04a',NULL,NULL,NULL,NULL,'2025-11-23 10:02:17',NULL,'2025-11-23 10:02:17',NULL,NULL),(536,NULL,'4686468d8ce1494bb966dcd66c60ad44',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:18',NULL,'2025-11-23 10:02:18',NULL,NULL),(537,NULL,NULL,'323957f1cb3946d9a514e9da47abc4f9',NULL,NULL,NULL,NULL,'2025-11-23 10:02:18',NULL,'2025-11-23 10:02:18',NULL,NULL),(538,NULL,NULL,'fd8f6070b572488cba9e3cf15cd937ae',NULL,NULL,NULL,NULL,'2025-11-23 10:02:18',NULL,'2025-11-23 10:02:18',NULL,NULL),(539,NULL,'0bc9157ea9624ef585629dd43f65b4ee',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:19',NULL,'2025-11-23 10:02:19',NULL,NULL),(540,NULL,'f6d884a43d4d4f1a99eb5734a1f80613',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:20',NULL,'2025-11-23 10:02:20',NULL,NULL),(541,NULL,'031cbaa91c144862a5db4bd17c2f1621',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:20',NULL,'2025-11-23 10:02:20',NULL,NULL),(542,NULL,NULL,'a3fef60ff660433baf42faa891d28931',NULL,NULL,NULL,NULL,'2025-11-23 10:02:21',NULL,'2025-11-23 10:02:21',NULL,NULL),(543,NULL,'efde09b1fd6540dab654212b897a94ee',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:22',NULL,'2025-11-23 10:02:22',NULL,NULL),(544,NULL,'0785fa8a58414d8e81fd45533196bc83',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:22',NULL,'2025-11-23 10:02:22',NULL,NULL),(545,NULL,'ff1b70fb35424e2cb22cbe5af6bb1d4c',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:24',NULL,'2025-11-23 10:02:24',NULL,NULL),(546,NULL,NULL,'f1b8dc496bdf46ac828fd291e1f55637',NULL,NULL,NULL,NULL,'2025-11-23 10:02:24',NULL,'2025-11-23 10:02:24',NULL,NULL),(547,NULL,NULL,'6f235a697254470dbebd60c4f4952705',NULL,NULL,NULL,NULL,'2025-11-23 10:02:24',NULL,'2025-11-23 10:02:24',NULL,NULL),(548,NULL,'5a26713aad1b4afabafa0aae8f0b5b0a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:25',NULL,'2025-11-23 10:02:25',NULL,NULL),(549,NULL,'e6d8ef9931ce45a286f1f67077c70e48',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:26',NULL,'2025-11-23 10:02:26',NULL,NULL),(550,NULL,'8abc60c23c5947aa922bf4381ca725a9',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:26',NULL,'2025-11-23 10:02:26',NULL,NULL),(551,NULL,NULL,'7978240014fb42919a81657a041cd3be',NULL,NULL,NULL,NULL,'2025-11-23 10:02:27',NULL,'2025-11-23 10:02:27',NULL,NULL),(552,NULL,NULL,'4fb709cadbe24634a4ed2efaf94be1d1',NULL,NULL,NULL,NULL,'2025-11-23 10:02:27',NULL,'2025-11-23 10:02:27',NULL,NULL),(553,NULL,NULL,'404dc86aa2d547d1b035a15b21cd31a6',NULL,NULL,NULL,NULL,'2025-11-23 10:02:27',NULL,'2025-11-23 10:02:27',NULL,NULL),(554,NULL,'3bcc515473444ea195be635c77c65d0f',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:28',NULL,'2025-11-23 10:02:28',NULL,NULL),(555,NULL,'60f6fef29c534a2193030e83131ec64c',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:28',NULL,'2025-11-23 10:02:28',NULL,NULL),(556,NULL,'ffe9de97f33a4a7e89974b9619a68af7',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:30',NULL,'2025-11-23 10:02:30',NULL,NULL),(557,NULL,NULL,'69b905e5be4549f39656a9cda91bc594',NULL,NULL,NULL,NULL,'2025-11-23 10:02:30',NULL,'2025-11-23 10:02:30',NULL,NULL),(558,NULL,'fae4345beb254b56933335350de131d3',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:30',NULL,'2025-11-23 10:02:30',NULL,NULL),(559,NULL,NULL,'7f8ead45ff964ac6a10bf5dee12771bc',NULL,NULL,NULL,NULL,'2025-11-23 10:02:30',NULL,'2025-11-23 10:02:30',NULL,NULL),(560,NULL,'49533b2ea3c249cfa3cb958ca199c9c7',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:32',NULL,'2025-11-23 10:02:32',NULL,NULL),(561,NULL,'7be3f73983a9415584608e718768b25c',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:33',NULL,'2025-11-23 10:02:33',NULL,NULL),(562,NULL,NULL,'173936a8ad3f4f56a3e8a901d82c6886',NULL,NULL,NULL,NULL,'2025-11-23 10:02:34',NULL,'2025-11-23 10:02:34',NULL,NULL),(563,NULL,'2a12890982534f9f8dfb103ad294ca1f',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:36',NULL,'2025-11-23 10:02:36',NULL,NULL),(564,NULL,NULL,'268d02d4288b4ff3a9dab77419bcf96a',NULL,NULL,NULL,NULL,'2025-11-23 10:02:37',NULL,'2025-11-23 10:02:37',NULL,NULL),(565,NULL,'23ffb5a89d5d4d8a8900ea750309030f',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:38',NULL,'2025-11-23 10:02:38',NULL,NULL),(566,NULL,NULL,'d1d5d82a85bd4059b213a62ec331d39a',NULL,NULL,NULL,NULL,'2025-11-23 10:02:38',NULL,'2025-11-23 10:02:38',NULL,NULL),(567,NULL,NULL,'4df36be4c9da4bc2af9b2eeaddc0f5ac',NULL,NULL,NULL,NULL,'2025-11-23 10:02:38',NULL,'2025-11-23 10:02:38',NULL,NULL),(568,NULL,NULL,NULL,NULL,'7392fe455f914fa6af9408828dd16be4',NULL,NULL,'2025-11-23 10:02:39',NULL,'2025-11-23 10:02:39',NULL,NULL),(569,NULL,NULL,'fce30a8b66b146d4b7ddf759e2105546',NULL,NULL,NULL,NULL,'2025-11-23 10:02:39',NULL,'2025-11-23 10:02:39',NULL,NULL),(570,NULL,'2f266827f84b4f93a6e236d74b49c3a5',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:39',NULL,'2025-11-23 10:02:39',NULL,NULL),(571,NULL,'6af2e3709ace42c9b1e8c60ef058acf5',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:41',NULL,'2025-11-23 10:02:41',NULL,NULL),(572,NULL,NULL,NULL,NULL,'28732446d0f44685b1a58da26da51453',NULL,NULL,'2025-11-23 10:02:42',NULL,'2025-11-23 10:02:42',NULL,NULL),(573,NULL,NULL,'09395728e3e54411a2f9d6159d2a4052',NULL,NULL,NULL,NULL,'2025-11-23 10:02:42',NULL,'2025-11-23 10:02:42',NULL,NULL),(574,NULL,NULL,'db47291a558f4ee89d0b4d64b237d8d7',NULL,NULL,NULL,NULL,'2025-11-23 10:02:42',NULL,'2025-11-23 10:02:42',NULL,NULL),(575,NULL,'83f9b86c0eb94bb5a2da4fb5b3ed2a40',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:42',NULL,'2025-11-23 10:02:42',NULL,NULL),(576,NULL,'74f29bf8098c4aaa85661f02879b2f81',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:43',NULL,'2025-11-23 10:02:43',NULL,NULL),(577,NULL,'25f380ddbf5c49989fe156e2d6c59327',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:44',NULL,'2025-11-23 10:02:44',NULL,NULL),(578,NULL,NULL,NULL,NULL,'8ad3eb777fef488a93f2016dad73040c',NULL,NULL,'2025-11-23 10:02:45',NULL,'2025-11-23 10:02:45',NULL,NULL),(579,NULL,NULL,'61cf4329ed394ea4abaefea03e9b2e8c',NULL,NULL,NULL,NULL,'2025-11-23 10:02:45',NULL,'2025-11-23 10:02:45',NULL,NULL),(580,NULL,'19c23a78063e454493cbfbdcb39e66f2',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:45',NULL,'2025-11-23 10:02:45',NULL,NULL),(581,NULL,NULL,'37c5adaa026e442398477573da89b610',NULL,NULL,NULL,NULL,'2025-11-23 10:02:48',NULL,'2025-11-23 10:02:48',NULL,NULL),(582,NULL,'ba697a36b9eb488d8cf515f4319cf22c',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:48',NULL,'2025-11-23 10:02:48',NULL,NULL),(583,NULL,NULL,NULL,NULL,'63a794a5f9804c1e8a28f0e0df871103',NULL,NULL,'2025-11-23 10:02:50',NULL,'2025-11-23 10:02:50',NULL,NULL),(584,NULL,NULL,'ab927202fce9439db115cd61ef5c242d',NULL,NULL,NULL,NULL,'2025-11-23 10:02:51',NULL,'2025-11-23 10:02:51',NULL,NULL),(585,NULL,'b6e9263777754228893818e5cc94b6af',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:51',NULL,'2025-11-23 10:02:51',NULL,NULL),(586,NULL,NULL,NULL,NULL,'580453cfd60f4604b5cb25b532ea7b3d',NULL,NULL,'2025-11-23 10:02:53',NULL,'2025-11-23 10:02:53',NULL,NULL),(587,NULL,NULL,'bd482c36658242d19cd56ae42d340b9a',NULL,NULL,NULL,NULL,'2025-11-23 10:02:54',NULL,'2025-11-23 10:02:54',NULL,NULL),(588,NULL,'29e8f3e35c7e457593edd2b2126f8e71',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:54',NULL,'2025-11-23 10:02:54',NULL,NULL),(589,NULL,NULL,'b74d7e380cfb4d7a8949daa77897eac8',NULL,NULL,NULL,NULL,'2025-11-23 10:02:54',NULL,'2025-11-23 10:02:54',NULL,NULL),(590,NULL,NULL,'417bfea614ec4d92876597f5f0fed62a',NULL,NULL,NULL,NULL,'2025-11-23 10:02:54',NULL,'2025-11-23 10:02:54',NULL,NULL),(591,NULL,NULL,'6824f1a2f1204c02a41cb29fe915f850',NULL,NULL,NULL,NULL,'2025-11-23 10:02:55',NULL,'2025-11-23 10:02:55',NULL,NULL),(592,NULL,'e64064179d764df2892503313f6b7d01',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:56',NULL,'2025-11-23 10:02:56',NULL,NULL),(593,NULL,NULL,'b36a09c5c13b4a3e9b854ddeb00649ee',NULL,NULL,NULL,NULL,'2025-11-23 10:02:56',NULL,'2025-11-23 10:02:56',NULL,NULL),(594,NULL,'c33d2fceabdc4922979224b1df0c6499',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:57',NULL,'2025-11-23 10:02:57',NULL,NULL),(595,NULL,'975c2485ae874077a08f31a00a36b8e9',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:58',NULL,'2025-11-23 10:02:58',NULL,NULL),(596,NULL,'6d43b7d88e884e6d87abed93a63f5ca0',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:02:59',NULL,'2025-11-23 10:02:59',NULL,NULL),(597,NULL,NULL,'a11b836406834647953b167eb4e05066',NULL,NULL,NULL,NULL,'2025-11-23 10:03:01',NULL,'2025-11-23 10:03:01',NULL,NULL),(598,NULL,NULL,'275e9c21c8474a22907a4c77f0f743fb',NULL,NULL,NULL,NULL,'2025-11-23 10:03:01',NULL,'2025-11-23 10:03:01',NULL,NULL),(599,NULL,'367b3b4c6d2e41f9a47b8bae71695a80',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:03:03',NULL,'2025-11-23 10:03:03',NULL,NULL),(600,NULL,NULL,'fc7a3bc93bd3430296903212121be4cd',NULL,NULL,NULL,NULL,'2025-11-23 10:03:04',NULL,'2025-11-23 10:03:04',NULL,NULL),(601,NULL,'61e6a341add64691804ddabe3746d1b0',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:03:04',NULL,'2025-11-23 10:03:04',NULL,NULL),(602,NULL,'d68a0c4a9a444afd973c16a38020089b',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:03:06',NULL,'2025-11-23 10:03:06',NULL,NULL),(603,NULL,NULL,'826ac07a3e1e478a8442e49fe22d8828',NULL,NULL,NULL,NULL,'2025-11-23 10:03:06',NULL,'2025-11-23 10:03:06',NULL,NULL),(604,NULL,NULL,'961c590eb7164750944c1e91b2c03a1c',NULL,NULL,NULL,NULL,'2025-11-23 10:03:08',NULL,'2025-11-23 10:03:08',NULL,NULL),(605,NULL,'1dd3a565ccb04ac6a97e5ac282009865',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:03:08',NULL,'2025-11-23 10:03:08',NULL,NULL),(606,NULL,NULL,'a0864dae9e5c4d51a8eed4c9418336e3',NULL,NULL,NULL,NULL,'2025-11-23 10:03:08',NULL,'2025-11-23 10:03:08',NULL,NULL),(607,NULL,'ea2ea6d87b164959a2fed0279d1a6aec',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:03:10',NULL,'2025-11-23 10:03:10',NULL,NULL),(608,NULL,'01b84c68bc5f4568a360dfbffb4f6fc0',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:03:11',NULL,'2025-11-23 10:03:11',NULL,NULL),(609,NULL,NULL,'80c914b51bd84d48bc00092fc8abcee7',NULL,NULL,NULL,NULL,'2025-11-23 10:03:12',NULL,'2025-11-23 10:03:12',NULL,NULL),(610,NULL,NULL,'9067423244744fbf9942cd19b42a3472',NULL,NULL,NULL,NULL,'2025-11-23 10:03:13',NULL,'2025-11-23 10:03:13',NULL,NULL),(611,NULL,NULL,'af2ed071a4d04a5d9e5143d81679d948',NULL,NULL,NULL,NULL,'2025-11-23 10:03:13',NULL,'2025-11-23 10:03:13',NULL,NULL),(612,NULL,'1e3b93ef61044aafb71b30163a32d7ac',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:03:13',NULL,'2025-11-23 10:03:13',NULL,NULL),(613,NULL,'2cbb5cf1bf5d40d29c4bb584ea0110f0',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:03:16',NULL,'2025-11-23 10:03:16',NULL,NULL),(614,NULL,NULL,'b179559127db44b29e8dc2de3e0762a4',NULL,NULL,NULL,NULL,'2025-11-23 10:03:18',NULL,'2025-11-23 10:03:18',NULL,NULL),(615,NULL,NULL,'89bbee73ed2949918cf53e9e92346bbc',NULL,NULL,NULL,NULL,'2025-11-23 10:03:18',NULL,'2025-11-23 10:03:18',NULL,NULL),(616,NULL,'ebbd9ff9506847c3a755175143ee9705',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:03:18',NULL,'2025-11-23 10:03:18',NULL,NULL),(617,NULL,'65af519f4bc34539854fd1bf61e2073a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:03:19',NULL,'2025-11-23 10:03:19',NULL,NULL),(618,NULL,'6ae7c76fc1e9479b9e0e53db6fa78970',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:03:21',NULL,'2025-11-23 10:03:21',NULL,NULL),(619,NULL,NULL,'ec419d55041b47cbb22dbe6510a836fa',NULL,NULL,NULL,NULL,'2025-11-23 10:03:21',NULL,'2025-11-23 10:03:21',NULL,NULL),(620,NULL,'ba5b901fe0854e769979829951316736',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:03:23',NULL,'2025-11-23 10:03:23',NULL,NULL),(621,NULL,NULL,'d4c36ce85e40425fa6aaf111d1fdfcc4',NULL,NULL,NULL,NULL,'2025-11-23 10:03:24',NULL,'2025-11-23 10:03:24',NULL,NULL),(622,NULL,'10f8dd7c838246c58f1d2c4efc771237',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:03:24',NULL,'2025-11-23 10:03:24',NULL,NULL),(623,NULL,NULL,'5f8c3a6b322140a5bce14b9304a15c90',NULL,NULL,NULL,NULL,'2025-11-23 10:03:28',NULL,'2025-11-23 10:03:28',NULL,NULL),(624,NULL,NULL,'da47bb8e9ce044b7a6c60aeaa303445e',NULL,NULL,NULL,NULL,'2025-11-23 10:03:28',NULL,'2025-11-23 10:03:28',NULL,NULL),(625,NULL,'1ed74022d4944d5c8276b163cae1a73a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:03:30',NULL,'2025-11-23 10:03:30',NULL,NULL),(626,NULL,'a98436922a214c3fa24458302f511400',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:03:31',NULL,'2025-11-23 10:03:31',NULL,NULL),(627,NULL,NULL,'f305fd563221407fafa7eded4220c4a1',NULL,NULL,NULL,NULL,'2025-11-23 10:03:34',NULL,'2025-11-23 10:03:34',NULL,NULL),(628,NULL,'189b765ad602425f93917991c90b88a7',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:03:36',NULL,'2025-11-23 10:03:36',NULL,NULL),(629,NULL,NULL,'362f2df9a018412c82003dac966da79f',NULL,NULL,NULL,NULL,'2025-11-23 10:03:36',NULL,'2025-11-23 10:03:36',NULL,NULL),(630,NULL,NULL,'da256000890f4c24ba3672f83924cc1c',NULL,NULL,NULL,NULL,'2025-11-23 10:03:43',NULL,'2025-11-23 10:03:43',NULL,NULL),(631,NULL,NULL,'fc774868e4a34df385635aa03af3bb9d',NULL,NULL,NULL,NULL,'2025-11-23 10:03:43',NULL,'2025-11-23 10:03:43',NULL,NULL),(632,NULL,NULL,'fc4f58dd5944497da3bc37fa9db2fe67',NULL,NULL,NULL,NULL,'2025-11-23 10:03:43',NULL,'2025-11-23 10:03:43',NULL,NULL),(633,NULL,NULL,'92c363a19c824119a63f49b23b9d66e1',NULL,NULL,NULL,NULL,'2025-11-23 10:03:44',NULL,'2025-11-23 10:03:44',NULL,NULL),(634,NULL,NULL,'42ad1c0f7faa440e8fdf09af1b39a0b5',NULL,NULL,NULL,NULL,'2025-11-23 10:03:45',NULL,'2025-11-23 10:03:45',NULL,NULL),(635,NULL,NULL,'fed66be0d98f4a4f8faa289c77400b77',NULL,NULL,NULL,NULL,'2025-11-23 10:03:45',NULL,'2025-11-23 10:03:45',NULL,NULL),(636,NULL,'a7811370065740c5abbbccf576edad7c',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:03:45',NULL,'2025-11-23 10:03:45',NULL,NULL),(637,NULL,'6fc3fa728d6f4403acd9944d81eaeb18',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:03:46',NULL,'2025-11-23 10:03:46',NULL,NULL),(638,NULL,'9d635cb23eed4c8795c7c085f175d605',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:03:46',NULL,'2025-11-23 10:03:46',NULL,NULL),(639,NULL,'d685b728482f4b8591b06d62c90fc00f',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:03:47',NULL,'2025-11-23 10:03:47',NULL,NULL),(640,NULL,'c20a7a47eabe4c42b7026d9c1f9c3d90',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:03:48',NULL,'2025-11-23 10:03:48',NULL,NULL),(641,NULL,'98e10db1ed1d4b55bc80116e497f49b2',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:03:49',NULL,'2025-11-23 10:03:49',NULL,NULL),(642,NULL,NULL,'97343502afdd4f78b7f811ad24f29792',NULL,NULL,NULL,NULL,'2025-11-23 10:03:51',NULL,'2025-11-23 10:03:51',NULL,NULL),(643,NULL,NULL,'9971121b03d541c981499a36d9c1f1ce',NULL,NULL,NULL,NULL,'2025-11-23 10:03:51',NULL,'2025-11-23 10:03:51',NULL,NULL),(644,NULL,'6cc558ab5ea444ca89055d39fcd5b762',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:03:52',NULL,'2025-11-23 10:03:52',NULL,NULL),(645,NULL,NULL,'08242344786b4e2da4f1ded75872dd16',NULL,NULL,NULL,NULL,'2025-11-23 10:03:53',NULL,'2025-11-23 10:03:53',NULL,NULL),(646,NULL,'679c7ccb1699462f8482adb93e8c3e46',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:03:53',NULL,'2025-11-23 10:03:53',NULL,NULL),(647,NULL,'598221f69c1b403f9e0b908005a13caa',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:03:56',NULL,'2025-11-23 10:03:56',NULL,NULL),(648,NULL,NULL,'de4712cde9684bfda16d0bb42d4a512b',NULL,NULL,NULL,NULL,'2025-11-23 10:03:57',NULL,'2025-11-23 10:03:57',NULL,NULL),(649,NULL,NULL,'c130f6a3facc41029a646c511d6de306',NULL,NULL,NULL,NULL,'2025-11-23 10:03:57',NULL,'2025-11-23 10:03:57',NULL,NULL),(650,NULL,NULL,'1df697f169dd404786359feb1db21ebe',NULL,NULL,NULL,NULL,'2025-11-23 10:03:57',NULL,'2025-11-23 10:03:57',NULL,NULL),(651,NULL,NULL,'a1e23dbd5dfb42d1a6235014079da36b',NULL,NULL,NULL,NULL,'2025-11-23 10:03:58',NULL,'2025-11-23 10:03:58',NULL,NULL),(652,NULL,'4b369a31ba6d4f8fabf8a663687ff818',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:03:59',NULL,'2025-11-23 10:03:59',NULL,NULL),(653,NULL,NULL,'7f74649ab3e44c928e477bf2986f3e99',NULL,NULL,NULL,NULL,'2025-11-23 10:04:00',NULL,'2025-11-23 10:04:00',NULL,NULL),(654,NULL,'63f36986a4504be59f5bb7dd85b81e14',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:01',NULL,'2025-11-23 10:04:01',NULL,NULL),(655,NULL,'fab0cd2dd13e4a90a3da11175f4667e8',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:02',NULL,'2025-11-23 10:04:02',NULL,NULL),(656,NULL,'7e586608f9e94ff0936be2e9177fa8c3',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:02',NULL,'2025-11-23 10:04:02',NULL,NULL),(657,NULL,'10b5846cd15c4235be646905f632738c',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:02',NULL,'2025-11-23 10:04:02',NULL,NULL),(658,NULL,NULL,'b6f9d40762bb498285c403017e9281ec',NULL,NULL,NULL,NULL,'2025-11-23 10:04:05',NULL,'2025-11-23 10:04:05',NULL,NULL),(659,NULL,NULL,'b59c21edde0f4cd89168ec46d5c94a53',NULL,NULL,NULL,NULL,'2025-11-23 10:04:06',NULL,'2025-11-23 10:04:06',NULL,NULL),(660,NULL,NULL,'0146ddde00b8411795cedef6ceff880b',NULL,NULL,NULL,NULL,'2025-11-23 10:04:06',NULL,'2025-11-23 10:04:06',NULL,NULL),(661,NULL,NULL,'8b99d65cca294d28811bad4317640f2e',NULL,NULL,NULL,NULL,'2025-11-23 10:04:07',NULL,'2025-11-23 10:04:07',NULL,NULL),(662,NULL,NULL,'a53d3680ba4642a8897cbc77aed3aab2',NULL,NULL,NULL,NULL,'2025-11-23 10:04:07',NULL,'2025-11-23 10:04:07',NULL,NULL),(663,NULL,'c16527ed06514e958651530483cd7471',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:07',NULL,'2025-11-23 10:04:07',NULL,NULL),(664,NULL,'bd88ee112f3b463182fc11eadfb6af24',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:08',NULL,'2025-11-23 10:04:08',NULL,NULL),(665,NULL,'4d0aa997cf0e428b8c7e20c806754329',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:08',NULL,'2025-11-23 10:04:08',NULL,NULL),(666,NULL,'b0714383740e4dd8b3399c768a89e8e5',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:09',NULL,'2025-11-23 10:04:09',NULL,NULL),(667,NULL,'d66d298c1a66478f9fc23945c1c4210b',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:09',NULL,'2025-11-23 10:04:09',NULL,NULL),(668,NULL,NULL,'b3240ad87a1d43d8b7e1a1a1bbe55521',NULL,NULL,NULL,NULL,'2025-11-23 10:04:10',NULL,'2025-11-23 10:04:10',NULL,NULL),(669,NULL,NULL,'29f62a1058244e1d9863aa1bd8c22472',NULL,NULL,NULL,NULL,'2025-11-23 10:04:11',NULL,'2025-11-23 10:04:11',NULL,NULL),(670,NULL,NULL,'f436a64c9a134831a0f528309f399f1d',NULL,NULL,NULL,NULL,'2025-11-23 10:04:11',NULL,'2025-11-23 10:04:11',NULL,NULL),(671,NULL,NULL,'3e5de770737f4582ae1509e9c1610112',NULL,NULL,NULL,NULL,'2025-11-23 10:04:11',NULL,'2025-11-23 10:04:11',NULL,NULL),(672,NULL,NULL,'767dbd086f2d4bb78891d3a511c4b328',NULL,NULL,NULL,NULL,'2025-11-23 10:04:12',NULL,'2025-11-23 10:04:12',NULL,NULL),(673,NULL,NULL,'c88e6512cf884d91ac42335890ac96e8',NULL,NULL,NULL,NULL,'2025-11-23 10:04:12',NULL,'2025-11-23 10:04:12',NULL,NULL),(674,NULL,NULL,'d219c1f0c13a4856b9cba726c98fa631',NULL,NULL,NULL,NULL,'2025-11-23 10:04:12',NULL,'2025-11-23 10:04:12',NULL,NULL),(675,NULL,'807b835f4cc944269d2f71f8e519b08a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:12',NULL,'2025-11-23 10:04:12',NULL,NULL),(676,NULL,'f9dcb977d63445a8acea91bc1a5db2e8',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:13',NULL,'2025-11-23 10:04:13',NULL,NULL),(677,NULL,'9d1f46d0628e4927961154d0724b8cd8',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:14',NULL,'2025-11-23 10:04:14',NULL,NULL),(678,NULL,'675b9a9f812f423e9301b7be73d40099',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:14',NULL,'2025-11-23 10:04:14',NULL,NULL),(679,NULL,NULL,'8a5513ce86f147889a9ee54e475ddb90',NULL,NULL,NULL,NULL,'2025-11-23 10:04:14',NULL,'2025-11-23 10:04:14',NULL,NULL),(680,NULL,'e04cd29a0fc44eaba037a02e60a4836e',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:16',NULL,'2025-11-23 10:04:16',NULL,NULL),(681,NULL,'5aba7a5dbc4c4a8dbe3374ffdecd08e6',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:17',NULL,'2025-11-23 10:04:17',NULL,NULL),(682,NULL,'29c528f550344303b8d15aaaa41bc0e0',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:18',NULL,'2025-11-23 10:04:18',NULL,NULL),(683,NULL,NULL,'682d17359450411582e76a93139b6948',NULL,NULL,NULL,NULL,'2025-11-23 10:04:26',NULL,'2025-11-23 10:04:26',NULL,NULL),(684,NULL,'357e082a3fb74c17977fb3ffe7ad4261',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:28',NULL,'2025-11-23 10:04:28',NULL,NULL),(685,NULL,NULL,'b5f7228b2a13453f852ea24f00659c17',NULL,NULL,NULL,NULL,'2025-11-23 10:04:30',NULL,'2025-11-23 10:04:30',NULL,NULL),(686,NULL,NULL,'396b75d89cf6455685aa89b39e769625',NULL,NULL,NULL,NULL,'2025-11-23 10:04:30',NULL,'2025-11-23 10:04:30',NULL,NULL),(687,NULL,'ad8e41581fe747a09622874fecb14ae2',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:32',NULL,'2025-11-23 10:04:32',NULL,NULL),(688,NULL,NULL,'17dbff441f8f4a61afa721f91b9c971d',NULL,NULL,NULL,NULL,'2025-11-23 10:04:33',NULL,'2025-11-23 10:04:33',NULL,NULL),(689,NULL,'0e9ab70f23134afd92115add42e46bf7',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:33',NULL,'2025-11-23 10:04:33',NULL,NULL),(690,NULL,'bd97d43422d1434dbd778fc0c37a5566',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:34',NULL,'2025-11-23 10:04:34',NULL,NULL),(691,NULL,NULL,'08d2f6f4dbc8480f88433130bbd1a6b9',NULL,NULL,NULL,NULL,'2025-11-23 10:04:36',NULL,'2025-11-23 10:04:36',NULL,NULL),(692,NULL,NULL,'cadfad382c6a47ac93fe9082a1535afc',NULL,NULL,NULL,NULL,'2025-11-23 10:04:37',NULL,'2025-11-23 10:04:37',NULL,NULL),(693,NULL,'bf52c880e85a4eebb6ab1a3caf7cd6ee',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:40',NULL,'2025-11-23 10:04:40',NULL,NULL),(694,NULL,'ff99fa7f2c954129bc90c29cac5f85d3',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:42',NULL,'2025-11-23 10:04:42',NULL,NULL),(695,NULL,NULL,'ba47196c60f34e139b6a0f16690cc642',NULL,NULL,NULL,NULL,'2025-11-23 10:04:45',NULL,'2025-11-23 10:04:45',NULL,NULL),(696,NULL,NULL,'00cbda8bb00045269b7a3af620a1451d',NULL,NULL,NULL,NULL,'2025-11-23 10:04:46',NULL,'2025-11-23 10:04:46',NULL,NULL),(697,NULL,NULL,'f4971de8b62c4e0d9b66eef705fd059f',NULL,NULL,NULL,NULL,'2025-11-23 10:04:46',NULL,'2025-11-23 10:04:46',NULL,NULL),(698,NULL,'307e3d5fcbc742a6b6aa246e7c8c9946',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:47',NULL,'2025-11-23 10:04:47',NULL,NULL),(699,NULL,'c8b7462a34a14230b8e7baf56d589c9c',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:49',NULL,'2025-11-23 10:04:49',NULL,NULL),(700,NULL,'7d2ce376b00045c3a3d22a69befa2b62',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:51',NULL,'2025-11-23 10:04:51',NULL,NULL),(701,NULL,NULL,'d626884720444f18864c3eb69ffe8057',NULL,NULL,NULL,NULL,'2025-11-23 10:04:52',NULL,'2025-11-23 10:04:52',NULL,NULL),(702,NULL,'d8633d61c76748a7a900f3c8cea84ef3',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:54',NULL,'2025-11-23 10:04:54',NULL,NULL),(703,NULL,NULL,'5f7e9736cbc74ce4ac3de51c4ac84504',NULL,NULL,NULL,NULL,'2025-11-23 10:04:55',NULL,'2025-11-23 10:04:55',NULL,NULL),(704,NULL,NULL,'a8a12d646f734219a5736bd9a89106d3',NULL,NULL,NULL,NULL,'2025-11-23 10:04:55',NULL,'2025-11-23 10:04:55',NULL,NULL),(705,NULL,'49ebd7a691dd4ea59ffbe9f5703e77e4',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:56',NULL,'2025-11-23 10:04:56',NULL,NULL),(706,NULL,'cd27ceae55c44d478998092e7554fd8a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:04:57',NULL,'2025-11-23 10:04:57',NULL,NULL),(707,NULL,NULL,'5bf59fbad93c4e8b86218c6448536ea4',NULL,NULL,NULL,NULL,'2025-11-23 10:04:58',NULL,'2025-11-23 10:04:58',NULL,NULL),(708,NULL,NULL,'95d0b9ca719548809b3d774a4215915b',NULL,NULL,NULL,NULL,'2025-11-23 10:05:01',NULL,'2025-11-23 10:05:01',NULL,NULL),(709,NULL,NULL,'6efcd50c34654e73bd84ad869e23c264',NULL,NULL,NULL,NULL,'2025-11-23 10:05:01',NULL,'2025-11-23 10:05:01',NULL,NULL),(710,NULL,NULL,'99c9da5d2d9848b190ec8ece75c0a8aa',NULL,NULL,NULL,NULL,'2025-11-23 10:05:02',NULL,'2025-11-23 10:05:02',NULL,NULL),(711,NULL,'1be2483fd52a488b9ba1f871a3ed13aa',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:03',NULL,'2025-11-23 10:05:03',NULL,NULL),(712,NULL,'e23820ca39d746bca6b423168d5f9537',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:04',NULL,'2025-11-23 10:05:04',NULL,NULL),(713,NULL,'b1c3c7ef8b7b4b36a1cc157067623913',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:06',NULL,'2025-11-23 10:05:06',NULL,NULL),(714,NULL,NULL,'6f11688a49fb4deba83327b1cf6539b4',NULL,NULL,NULL,NULL,'2025-11-23 10:05:06',NULL,'2025-11-23 10:05:06',NULL,NULL),(715,NULL,'02d402d01a514bbd8ec5543d8bb9b97c',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:07',NULL,'2025-11-23 10:05:07',NULL,NULL),(716,NULL,NULL,'020add942aca492580a2fa092e8999df',NULL,NULL,NULL,NULL,'2025-11-23 10:05:09',NULL,'2025-11-23 10:05:09',NULL,NULL),(717,NULL,NULL,'c84061c9680346a9a669c22ad0457748',NULL,NULL,NULL,NULL,'2025-11-23 10:05:10',NULL,'2025-11-23 10:05:10',NULL,NULL),(718,NULL,'a8358b5f211d4d2cb817b8dbb1069194',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:11',NULL,'2025-11-23 10:05:11',NULL,NULL),(719,NULL,'43fdaf4b776349f7b27a97af06b894b2',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:12',NULL,'2025-11-23 10:05:12',NULL,NULL),(720,NULL,NULL,'9fd6b9c1c244436ba8d5c98a9fcfa9c5',NULL,NULL,NULL,NULL,'2025-11-23 10:05:13',NULL,'2025-11-23 10:05:13',NULL,NULL),(721,NULL,'6eb850a1541d4942b249428ef6092e5e',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:14',NULL,'2025-11-23 10:05:14',NULL,NULL),(722,NULL,NULL,'131430ad8ac646268fcbca6e470c2ccc',NULL,NULL,NULL,NULL,'2025-11-23 10:05:16',NULL,'2025-11-23 10:05:16',NULL,NULL),(723,NULL,NULL,'a626db0453f04b28a39df197c856d926',NULL,NULL,NULL,NULL,'2025-11-23 10:05:16',NULL,'2025-11-23 10:05:16',NULL,NULL),(724,NULL,NULL,'394272d5be8946af80bce6490486e959',NULL,NULL,NULL,NULL,'2025-11-23 10:05:16',NULL,'2025-11-23 10:05:16',NULL,NULL),(725,NULL,NULL,'2232a5518ff84ae6ae782975d00fda1c',NULL,NULL,NULL,NULL,'2025-11-23 10:05:16',NULL,'2025-11-23 10:05:16',NULL,NULL),(726,NULL,NULL,'7153c09f9f8b401d880aed7b642296e5',NULL,NULL,NULL,NULL,'2025-11-23 10:05:16',NULL,'2025-11-23 10:05:16',NULL,NULL),(727,NULL,'e604eae6a01f4975816ace0cec6e33f8',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:17',NULL,'2025-11-23 10:05:17',NULL,NULL),(728,NULL,'e456b00c470e4f58a0cb2eb0ed097106',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:17',NULL,'2025-11-23 10:05:17',NULL,NULL),(729,NULL,'754ffdaab5e943919a2f97255ab891a9',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:17',NULL,'2025-11-23 10:05:17',NULL,NULL),(730,NULL,'924c0ff259c84a6286e040f48d451262',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:17',NULL,'2025-11-23 10:05:17',NULL,NULL),(731,NULL,'3789860eccd04b5c806323f4ee0accc6',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:18',NULL,'2025-11-23 10:05:18',NULL,NULL),(732,NULL,NULL,'21c13310825c4e4b8d286e562194eb8b',NULL,NULL,NULL,NULL,'2025-11-23 10:05:19',NULL,'2025-11-23 10:05:19',NULL,NULL),(733,NULL,NULL,'2483cfdb06d34f7db01bca29d5a21d23',NULL,NULL,NULL,NULL,'2025-11-23 10:05:20',NULL,'2025-11-23 10:05:20',NULL,NULL),(734,NULL,'96714398a2a743d0be8daed8d2d3b1e8',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:21',NULL,'2025-11-23 10:05:21',NULL,NULL),(735,NULL,NULL,'0c995eb0f4c3480dba53307eca13792a',NULL,NULL,NULL,NULL,'2025-11-23 10:05:21',NULL,'2025-11-23 10:05:21',NULL,NULL),(736,NULL,NULL,'c9c2b33ce95a4bbfacea4707df19afb2',NULL,NULL,NULL,NULL,'2025-11-23 10:05:21',NULL,'2025-11-23 10:05:21',NULL,NULL),(737,NULL,'fb80cadc4a0a43c4aceba3b0c7eebae6',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:22',NULL,'2025-11-23 10:05:22',NULL,NULL),(738,NULL,NULL,'f802b196c2ae42ebb1a63c66719fb91e',NULL,NULL,NULL,NULL,'2025-11-23 10:05:23',NULL,'2025-11-23 10:05:23',NULL,NULL),(739,NULL,'29e781d27c104e25bbe0b3d44cf5b4a0',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:23',NULL,'2025-11-23 10:05:23',NULL,NULL),(740,NULL,'c682d59768ce49c49c462888545f4bbd',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:24',NULL,'2025-11-23 10:05:24',NULL,NULL),(741,NULL,'5b7a4fb576ea4277b51e8772fa34e1b9',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:24',NULL,'2025-11-23 10:05:24',NULL,NULL),(742,NULL,NULL,'3c75003597274dc4827eada967672238',NULL,NULL,NULL,NULL,'2025-11-23 10:05:26',NULL,'2025-11-23 10:05:26',NULL,NULL),(743,NULL,NULL,'9e1ce91c9edd4cbf99374262d726c803',NULL,NULL,NULL,NULL,'2025-11-23 10:05:26',NULL,'2025-11-23 10:05:26',NULL,NULL),(744,NULL,'7ffe6bcd62184dda84133a0cc0a4e224',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:27',NULL,'2025-11-23 10:05:27',NULL,NULL),(745,NULL,'3e6231a5e9aa4c259ebfe0fc2e6fbf23',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:27',NULL,'2025-11-23 10:05:27',NULL,NULL),(746,NULL,NULL,'b36ae6d82d8f4b45b13e50ed6a342070',NULL,NULL,NULL,NULL,'2025-11-23 10:05:29',NULL,'2025-11-23 10:05:29',NULL,NULL),(747,NULL,NULL,'90cea60d49c344f1a49f93c6695603ba',NULL,NULL,NULL,NULL,'2025-11-23 10:05:30',NULL,'2025-11-23 10:05:30',NULL,NULL),(748,NULL,'8989911258d5427baca1e143951c1727',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:31',NULL,'2025-11-23 10:05:31',NULL,NULL),(749,NULL,'51d0d3cbee924cf1ab4c449b1d345d19',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:32',NULL,'2025-11-23 10:05:32',NULL,NULL),(750,NULL,NULL,'f50f9cf809124624a52a80f172c7c5fa',NULL,NULL,NULL,NULL,'2025-11-23 10:05:32',NULL,'2025-11-23 10:05:32',NULL,NULL),(751,NULL,NULL,'0ae5b5001dba43a0b9e385a71a48ff3f',NULL,NULL,NULL,NULL,'2025-11-23 10:05:33',NULL,'2025-11-23 10:05:33',NULL,NULL),(752,NULL,NULL,'54940119ad144b9db46c6873d998efe9',NULL,NULL,NULL,NULL,'2025-11-23 10:05:34',NULL,'2025-11-23 10:05:34',NULL,NULL),(753,NULL,'a088503b43e94251822e3c0e9006a74e',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:34',NULL,'2025-11-23 10:05:34',NULL,NULL),(754,NULL,'c9efd03eeff74e9c97dd3ab3c6ab3907',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:34',NULL,'2025-11-23 10:05:34',NULL,NULL),(755,NULL,'374c0d0de7ce4cc5b5897b510696a1a3',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:35',NULL,'2025-11-23 10:05:35',NULL,NULL),(756,NULL,NULL,'1b96f945d5154f44ac4029db9b2f0807',NULL,NULL,NULL,NULL,'2025-11-23 10:05:36',NULL,'2025-11-23 10:05:36',NULL,NULL),(757,NULL,NULL,'bd7319523f0c402bbc693cef142575a0',NULL,NULL,NULL,NULL,'2025-11-23 10:05:36',NULL,'2025-11-23 10:05:36',NULL,NULL),(758,NULL,NULL,'9d81681fd43846c1b493ae0208eb4157',NULL,NULL,NULL,NULL,'2025-11-23 10:05:36',NULL,'2025-11-23 10:05:36',NULL,NULL),(759,NULL,'472899094c04472c806243e76f122a0f',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:37',NULL,'2025-11-23 10:05:37',NULL,NULL),(760,NULL,NULL,'8777f3cac58d4278bd4167267c84b500',NULL,NULL,NULL,NULL,'2025-11-23 10:05:37',NULL,'2025-11-23 10:05:37',NULL,NULL),(761,NULL,NULL,'8163ae5a773d4369801abde9f643c6f2',NULL,NULL,NULL,NULL,'2025-11-23 10:05:37',NULL,'2025-11-23 10:05:37',NULL,NULL),(762,NULL,'ba426e81cfe149da986575955289d04b',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:37',NULL,'2025-11-23 10:05:37',NULL,NULL),(763,NULL,'46698586f1b34c95ba6a10e0cb2e283f',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:38',NULL,'2025-11-23 10:05:38',NULL,NULL),(764,NULL,'cd6c76c63d984d2ea92aefd9ec3e7238',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:39',NULL,'2025-11-23 10:05:39',NULL,NULL),(765,NULL,'e4c3466dc73140c4a59aeff744af534f',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:40',NULL,'2025-11-23 10:05:40',NULL,NULL),(766,NULL,NULL,'cc3ea57ef96b41ba95249341fe4cf8eb',NULL,NULL,NULL,NULL,'2025-11-23 10:05:41',NULL,'2025-11-23 10:05:41',NULL,NULL),(767,NULL,'0715a14fda5a4de4b442b251b06184f6',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:42',NULL,'2025-11-23 10:05:42',NULL,NULL),(768,NULL,NULL,'9d6cf003ec9b4ab9b3c8117a9e28aa56',NULL,NULL,NULL,NULL,'2025-11-23 10:05:43',NULL,'2025-11-23 10:05:43',NULL,NULL),(769,NULL,NULL,'276a074587054ffaacc5b214d9c84a14',NULL,NULL,NULL,NULL,'2025-11-23 10:05:43',NULL,'2025-11-23 10:05:43',NULL,NULL),(770,NULL,'737e70c24c3a4eac85267456be6774fa',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:44',NULL,'2025-11-23 10:05:44',NULL,NULL),(771,NULL,NULL,'97f7a610f5ae415ab9c0d08692cda10a',NULL,NULL,NULL,NULL,'2025-11-23 10:05:44',NULL,'2025-11-23 10:05:44',NULL,NULL),(772,NULL,NULL,'62451c91e4c24f0fb36b26f84bd3bfc4',NULL,NULL,NULL,NULL,'2025-11-23 10:05:44',NULL,'2025-11-23 10:05:44',NULL,NULL),(773,NULL,NULL,'1b127a4ba3e343c0b74a786e58731880',NULL,NULL,NULL,NULL,'2025-11-23 10:05:44',NULL,'2025-11-23 10:05:44',NULL,NULL),(774,NULL,'e26ac473e8284e80b775ad7fd47ae6ec',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:45',NULL,'2025-11-23 10:05:45',NULL,NULL),(775,NULL,'0fd0c02763ed416f9900386f4c248a7e',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:45',NULL,'2025-11-23 10:05:45',NULL,NULL),(776,NULL,'12c02387e18f4abf98000ac784fb8261',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:46',NULL,'2025-11-23 10:05:46',NULL,NULL),(777,NULL,NULL,'a99c4754fbcb418aab87199e03b271f2',NULL,NULL,NULL,NULL,'2025-11-23 10:05:46',NULL,'2025-11-23 10:05:46',NULL,NULL),(778,NULL,'fb2fe4c3f84642bbad40631e42e594dd',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:46',NULL,'2025-11-23 10:05:46',NULL,NULL),(779,NULL,'99a8bcb117f944bb882116e1fb95c5da',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:47',NULL,'2025-11-23 10:05:47',NULL,NULL),(780,NULL,NULL,'c4d87bf99ec94f8cbf2d4bb5ce0e2e02',NULL,NULL,NULL,NULL,'2025-11-23 10:05:48',NULL,'2025-11-23 10:05:48',NULL,NULL),(781,NULL,NULL,'19352944d3d04e3fbe06c924354f5439',NULL,NULL,NULL,NULL,'2025-11-23 10:05:48',NULL,'2025-11-23 10:05:48',NULL,NULL),(782,NULL,NULL,'bcbbb5f36c0d44fc8cbbd6fbf64cff91',NULL,NULL,NULL,NULL,'2025-11-23 10:05:48',NULL,'2025-11-23 10:05:48',NULL,NULL),(783,NULL,NULL,'5389e95a323d4805b18bd78b3c398a38',NULL,NULL,NULL,NULL,'2025-11-23 10:05:48',NULL,'2025-11-23 10:05:48',NULL,NULL),(784,NULL,'2b518cc7dea7432c9f224126ca7feffd',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:49',NULL,'2025-11-23 10:05:49',NULL,NULL),(785,NULL,NULL,'df30e9d95de942da9333c6d01dd52576',NULL,NULL,NULL,NULL,'2025-11-23 10:05:50',NULL,'2025-11-23 10:05:50',NULL,NULL),(786,NULL,'6019f8765449409292a7ee8e6014e2c0',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:50',NULL,'2025-11-23 10:05:50',NULL,NULL),(787,NULL,NULL,'14b190f2621b4854a55a5020e13694f5',NULL,NULL,NULL,NULL,'2025-11-23 10:05:50',NULL,'2025-11-23 10:05:50',NULL,NULL),(788,NULL,'1dc9eeda0b5648b98f5141c45bf25926',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:50',NULL,'2025-11-23 10:05:50',NULL,NULL),(789,NULL,'15e4a2bb264445829985d9ebd74e825a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:51',NULL,'2025-11-23 10:05:51',NULL,NULL),(790,NULL,'b26c9bed083447548be26f4feb5dd112',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:52',NULL,'2025-11-23 10:05:52',NULL,NULL),(791,NULL,NULL,'495b816e71724a42ba73f5d9750eacb5',NULL,NULL,NULL,NULL,'2025-11-23 10:05:52',NULL,'2025-11-23 10:05:52',NULL,NULL),(792,NULL,NULL,'f67ff277cba8420cb7c1171780639eb4',NULL,NULL,NULL,NULL,'2025-11-23 10:05:53',NULL,'2025-11-23 10:05:53',NULL,NULL),(793,NULL,NULL,'2456c1effe774a86b732ddbcf1679e10',NULL,NULL,NULL,NULL,'2025-11-23 10:05:53',NULL,'2025-11-23 10:05:53',NULL,NULL),(794,NULL,NULL,'4a5801c70cb646a1bdfd141859f50e5d',NULL,NULL,NULL,NULL,'2025-11-23 10:05:53',NULL,'2025-11-23 10:05:53',NULL,NULL),(795,NULL,'ad260941b31148988b7356700a79268b',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:55',NULL,'2025-11-23 10:05:55',NULL,NULL),(796,NULL,'a9095592dc184c3b88f04d362644f773',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:55',NULL,'2025-11-23 10:05:55',NULL,NULL),(797,NULL,'630fd1c422ad40f19a3e00fc4a997eb2',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:56',NULL,'2025-11-23 10:05:56',NULL,NULL),(798,NULL,'31ac2e693dd64b72aedd3d1555ed3e03',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:56',NULL,'2025-11-23 10:05:56',NULL,NULL),(799,NULL,NULL,'64292cef72c64c738c8de17de8ab8881',NULL,NULL,NULL,NULL,'2025-11-23 10:05:56',NULL,'2025-11-23 10:05:56',NULL,NULL),(800,NULL,NULL,'0bac266e743a4d49b9bd572c2edfa4ba',NULL,NULL,NULL,NULL,'2025-11-23 10:05:56',NULL,'2025-11-23 10:05:56',NULL,NULL),(801,NULL,NULL,'afb5a2d3bbdc46798ee1e75c18e23dd4',NULL,NULL,NULL,NULL,'2025-11-23 10:05:56',NULL,'2025-11-23 10:05:56',NULL,NULL),(802,NULL,NULL,'f3e8f2d7965840f492ae69cfe6898c99',NULL,NULL,NULL,NULL,'2025-11-23 10:05:56',NULL,'2025-11-23 10:05:56',NULL,NULL),(803,NULL,'cde22753c19a40c591f5d9e0d5080109',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:57',NULL,'2025-11-23 10:05:57',NULL,NULL),(804,NULL,NULL,'1556c5016e464004b415305f8f5f8f35',NULL,NULL,NULL,NULL,'2025-11-23 10:05:58',NULL,'2025-11-23 10:05:58',NULL,NULL),(805,NULL,'400fa6fe2aca4451a771e2db5e7e7e01',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:58',NULL,'2025-11-23 10:05:58',NULL,NULL),(806,NULL,NULL,'a61b8a118cdc4f03a5a83427e00197fb',NULL,NULL,NULL,NULL,'2025-11-23 10:05:58',NULL,'2025-11-23 10:05:58',NULL,NULL),(807,NULL,'a2a6cf1bd5e74fabba7eb664675d2940',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:59',NULL,'2025-11-23 10:05:59',NULL,NULL),(808,NULL,'4309ec3a12e44562a3a869425c345c8b',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:05:59',NULL,'2025-11-23 10:05:59',NULL,NULL),(809,NULL,NULL,'982735a41bcd419fa47d145c970596e4',NULL,NULL,NULL,NULL,'2025-11-23 10:06:00',NULL,'2025-11-23 10:06:00',NULL,NULL),(810,NULL,NULL,'84be8fea956d4b8e8bf9bfe92e416463',NULL,NULL,NULL,NULL,'2025-11-23 10:06:00',NULL,'2025-11-23 10:06:00',NULL,NULL),(811,NULL,'14ef278019ca433e853baef5651087a9',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:00',NULL,'2025-11-23 10:06:00',NULL,NULL),(812,NULL,NULL,'ce14cbb11b644b8395c148a1da4b77c0',NULL,NULL,NULL,NULL,'2025-11-23 10:06:01',NULL,'2025-11-23 10:06:01',NULL,NULL),(813,NULL,NULL,'cd47d55f3345423888e76431c4ceb067',NULL,NULL,NULL,NULL,'2025-11-23 10:06:01',NULL,'2025-11-23 10:06:01',NULL,NULL),(814,NULL,'e61ede12316440ba9c8108f57bc8cf7b',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:01',NULL,'2025-11-23 10:06:01',NULL,NULL),(815,NULL,NULL,'928b6122c08742c192c6fa2e7944b94a',NULL,NULL,NULL,NULL,'2025-11-23 10:06:02',NULL,'2025-11-23 10:06:02',NULL,NULL),(816,NULL,'d4164e95225244deac1d2565fad36c94',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:02',NULL,'2025-11-23 10:06:02',NULL,NULL),(817,NULL,NULL,'25299bebde8f402b9b1544a7d7b91c39',NULL,NULL,NULL,NULL,'2025-11-23 10:06:02',NULL,'2025-11-23 10:06:02',NULL,NULL),(818,NULL,'2bcdf58bccb2414f9f7b0475bdc0edda',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:02',NULL,'2025-11-23 10:06:02',NULL,NULL),(819,NULL,'980c7c21c34748d78f83541fa493dd05',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:02',NULL,'2025-11-23 10:06:02',NULL,NULL),(820,NULL,'30f4d16a95454fab93c0ae80aada7b26',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:03',NULL,'2025-11-23 10:06:03',NULL,NULL),(821,NULL,NULL,'80c090f1461447339ca313bd8f2d8b43',NULL,NULL,NULL,NULL,'2025-11-23 10:06:04',NULL,'2025-11-23 10:06:04',NULL,NULL),(822,NULL,NULL,'b64722d296884fbab0bc4c7f3fe363c5',NULL,NULL,NULL,NULL,'2025-11-23 10:06:05',NULL,'2025-11-23 10:06:05',NULL,NULL),(823,NULL,NULL,'6b2d4ce74f314f569d20a814d7857aea',NULL,NULL,NULL,NULL,'2025-11-23 10:06:05',NULL,'2025-11-23 10:06:05',NULL,NULL),(824,NULL,'b5bd34d2b2254cea94f5a5ce11849bcf',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:05',NULL,'2025-11-23 10:06:05',NULL,NULL),(825,NULL,NULL,'df4347aff6b24b92ae54d6188ce2313f',NULL,NULL,NULL,NULL,'2025-11-23 10:06:05',NULL,'2025-11-23 10:06:05',NULL,NULL),(826,NULL,NULL,'fa4c0570104d4173a304dd723ff414f2',NULL,NULL,NULL,NULL,'2025-11-23 10:06:05',NULL,'2025-11-23 10:06:05',NULL,NULL),(827,NULL,'9ec79b3047e44cce8f8fec4af2f593be',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:06',NULL,'2025-11-23 10:06:06',NULL,NULL),(828,NULL,'8e3f94f4cb424d86afe0a21cdceca69c',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:06',NULL,'2025-11-23 10:06:06',NULL,NULL),(829,NULL,NULL,'e92d39b2b28b4209b49b1fc95dff6039',NULL,NULL,NULL,NULL,'2025-11-23 10:06:07',NULL,'2025-11-23 10:06:07',NULL,NULL),(830,NULL,NULL,'92a3f6a5f3804d4e847471749531397c',NULL,NULL,NULL,NULL,'2025-11-23 10:06:07',NULL,'2025-11-23 10:06:07',NULL,NULL),(831,NULL,'0dcc58766ad44287910595c5c8f14397',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:07',NULL,'2025-11-23 10:06:07',NULL,NULL),(832,NULL,NULL,'82cc0bdee41142f6b0a615548abcfb54',NULL,NULL,NULL,NULL,'2025-11-23 10:06:07',NULL,'2025-11-23 10:06:07',NULL,NULL),(833,NULL,'398c405432fd4e22b2328387f9db5439',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:08',NULL,'2025-11-23 10:06:08',NULL,NULL),(834,NULL,'4e886bd382154b9ba842be63cef3b094',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:08',NULL,'2025-11-23 10:06:08',NULL,NULL),(835,NULL,NULL,'3b95ab8759f44a2fb1ab5b0802b4ea90',NULL,NULL,NULL,NULL,'2025-11-23 10:06:08',NULL,'2025-11-23 10:06:08',NULL,NULL),(836,NULL,'ef5616b208004ff48f369e044162aeba',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:09',NULL,'2025-11-23 10:06:09',NULL,NULL),(837,NULL,NULL,'2acff95f4f544f19a36a86da6d142ed5',NULL,NULL,NULL,NULL,'2025-11-23 10:06:09',NULL,'2025-11-23 10:06:09',NULL,NULL),(838,NULL,NULL,'48df9667e02e4af4b9a2bbedcd56797b',NULL,NULL,NULL,NULL,'2025-11-23 10:06:10',NULL,'2025-11-23 10:06:10',NULL,NULL),(839,NULL,'250d505f169f42eaa1d45ef735f6b254',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:10',NULL,'2025-11-23 10:06:10',NULL,NULL),(840,NULL,NULL,'0fd576afe39c432a84e74adec0c6f837',NULL,NULL,NULL,NULL,'2025-11-23 10:06:10',NULL,'2025-11-23 10:06:10',NULL,NULL),(841,NULL,'10f6dfd6b1684628bd2dfc266a69e68a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:10',NULL,'2025-11-23 10:06:10',NULL,NULL),(842,NULL,NULL,'2ceb7f76160c41af8e02866717fd1afa',NULL,NULL,NULL,NULL,'2025-11-23 10:06:10',NULL,'2025-11-23 10:06:10',NULL,NULL),(843,NULL,NULL,'08be0723cf6640acbc579782e41dce36',NULL,NULL,NULL,NULL,'2025-11-23 10:06:10',NULL,'2025-11-23 10:06:10',NULL,NULL),(844,NULL,NULL,'28c58b98cd6a471683689e1a810b401a',NULL,NULL,NULL,NULL,'2025-11-23 10:06:11',NULL,'2025-11-23 10:06:11',NULL,NULL),(845,NULL,NULL,'569f9d5c2aed44a3969893ae90069230',NULL,NULL,NULL,NULL,'2025-11-23 10:06:11',NULL,'2025-11-23 10:06:11',NULL,NULL),(846,NULL,'e57188b9d4f148949cc2ff15784816fd',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:11',NULL,'2025-11-23 10:06:11',NULL,NULL),(847,NULL,NULL,'90c18b36e7c142a2ba912fda344bf32a',NULL,NULL,NULL,NULL,'2025-11-23 10:06:12',NULL,'2025-11-23 10:06:12',NULL,NULL),(848,NULL,'93dca6470d6b4604ab7bd10d78091e05',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:12',NULL,'2025-11-23 10:06:12',NULL,NULL),(849,NULL,'bdc494a0166b49bdad177fead8e09964',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:12',NULL,'2025-11-23 10:06:12',NULL,NULL),(850,NULL,'eefb55b5a7ba44a99cf8b53d39954004',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:12',NULL,'2025-11-23 10:06:12',NULL,NULL),(851,NULL,'5992c43b9fc34c048b9823bb781cbcc8',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:13',NULL,'2025-11-23 10:06:13',NULL,NULL),(852,NULL,'639b50f98a2a45ed93803ee22072bc7a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:13',NULL,'2025-11-23 10:06:13',NULL,NULL),(853,NULL,'8dd32e2978e04ac58b6b15350969f2c8',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:13',NULL,'2025-11-23 10:06:13',NULL,NULL),(854,NULL,NULL,'af5de096454d470598ed1cedeed5495a',NULL,NULL,NULL,NULL,'2025-11-23 10:06:17',NULL,'2025-11-23 10:06:17',NULL,NULL),(855,NULL,NULL,'93b48990367148d7947288c61fb37fdc',NULL,NULL,NULL,NULL,'2025-11-23 10:06:17',NULL,'2025-11-23 10:06:17',NULL,NULL),(856,NULL,NULL,'4c84817b636a448a87c030487d541527',NULL,NULL,NULL,NULL,'2025-11-23 10:06:17',NULL,'2025-11-23 10:06:17',NULL,NULL),(857,NULL,NULL,'a6724cb288984da6b8f60a92c900d423',NULL,NULL,NULL,NULL,'2025-11-23 10:06:18',NULL,'2025-11-23 10:06:18',NULL,NULL),(858,NULL,'24a8d397352640bea21b3503164c6be5',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:18',NULL,'2025-11-23 10:06:18',NULL,NULL),(859,NULL,'e404e742ed2d4e9d83bf3d49a6278dc7',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:18',NULL,'2025-11-23 10:06:18',NULL,NULL),(860,NULL,'9923efcf9d0844f4b3c9b9d15ab6851c',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:19',NULL,'2025-11-23 10:06:19',NULL,NULL),(861,NULL,NULL,'96c73065ddf84ec8bca44ab05204ece2',NULL,NULL,NULL,NULL,'2025-11-23 10:06:19',NULL,'2025-11-23 10:06:19',NULL,NULL),(862,NULL,NULL,'5ef9509c48f6402184f41c4f0a39cc19',NULL,NULL,NULL,NULL,'2025-11-23 10:06:19',NULL,'2025-11-23 10:06:19',NULL,NULL),(863,NULL,NULL,'e4b3504a6eda4695a8631a39b426c866',NULL,NULL,NULL,NULL,'2025-11-23 10:06:19',NULL,'2025-11-23 10:06:19',NULL,NULL),(864,NULL,NULL,'fbc51020e412499b82149f43a6216e13',NULL,NULL,NULL,NULL,'2025-11-23 10:06:19',NULL,'2025-11-23 10:06:19',NULL,NULL),(865,NULL,'9c091d5d6e6d41329ce890f6945ede0c',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:20',NULL,'2025-11-23 10:06:20',NULL,NULL),(866,NULL,'271f8ea138a4455ba79fbf669d239ee5',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:21',NULL,'2025-11-23 10:06:21',NULL,NULL),(867,NULL,'c623df6a56ca4c9dbc632d4d82478afb',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:21',NULL,'2025-11-23 10:06:21',NULL,NULL),(868,NULL,NULL,'1d5eba52d35642b9bb7f834d5bed165a',NULL,NULL,NULL,NULL,'2025-11-23 10:06:21',NULL,'2025-11-23 10:06:21',NULL,NULL),(869,NULL,NULL,'1a70b08fcff844c08d75c6ece5cea360',NULL,NULL,NULL,NULL,'2025-11-23 10:06:22',NULL,'2025-11-23 10:06:22',NULL,NULL),(870,NULL,NULL,'eff911b58a0a44059870c57c7b92683c',NULL,NULL,NULL,NULL,'2025-11-23 10:06:22',NULL,'2025-11-23 10:06:22',NULL,NULL),(871,NULL,NULL,'20124ae5f4ed4a96b55dc4f1ca24a945',NULL,NULL,NULL,NULL,'2025-11-23 10:06:22',NULL,'2025-11-23 10:06:22',NULL,NULL),(872,NULL,NULL,'d2b38626eefd4b179f1b36b2de7959b5',NULL,NULL,NULL,NULL,'2025-11-23 10:06:22',NULL,'2025-11-23 10:06:22',NULL,NULL),(873,NULL,NULL,'e09b37e1089c48e0bb63d96baad123eb',NULL,NULL,NULL,NULL,'2025-11-23 10:06:22',NULL,'2025-11-23 10:06:22',NULL,NULL),(874,NULL,'f9698c13a99e46548ff053f1eec8ed24',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:23',NULL,'2025-11-23 10:06:23',NULL,NULL),(875,NULL,'ac0f52e853194f9ea9d27590165c645d',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:24',NULL,'2025-11-23 10:06:24',NULL,NULL),(876,NULL,NULL,'42be30ae8e904b54bfa7ce1c4bdb3388',NULL,NULL,NULL,NULL,'2025-11-23 10:06:24',NULL,'2025-11-23 10:06:24',NULL,NULL),(877,NULL,'8cc99762c1da46248e6ae87d4c3b549f',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:24',NULL,'2025-11-23 10:06:24',NULL,NULL),(878,NULL,NULL,'c9560360616b4d50a75c1cbcd3f0b3cd',NULL,NULL,NULL,NULL,'2025-11-23 10:06:24',NULL,'2025-11-23 10:06:24',NULL,NULL),(879,NULL,NULL,'299621e8cbed40d2be2c11f8e82cf6c7',NULL,NULL,NULL,NULL,'2025-11-23 10:06:24',NULL,'2025-11-23 10:06:24',NULL,NULL),(880,NULL,'e731d615e8bb438099d8bc42a8777575',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:24',NULL,'2025-11-23 10:06:24',NULL,NULL),(881,NULL,'34d74c1246bf4aba9b9e49e89e82cacb',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:24',NULL,'2025-11-23 10:06:24',NULL,NULL),(882,NULL,NULL,'c73fbf08586c40c2bd9c176ab916352c',NULL,NULL,NULL,NULL,'2025-11-23 10:06:24',NULL,'2025-11-23 10:06:24',NULL,NULL),(883,NULL,'01c96048c1314d5a8d3a1a4b4f4124ec',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:25',NULL,'2025-11-23 10:06:25',NULL,NULL),(884,NULL,'18a0a751c9764b4a8794d2ed867c75fb',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:26',NULL,'2025-11-23 10:06:26',NULL,NULL),(885,NULL,'b386c4317a2c4aeaaa828c21062e485c',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:26',NULL,'2025-11-23 10:06:26',NULL,NULL),(886,NULL,NULL,'ebd8248daaec4b05b400758ee0cae930',NULL,NULL,NULL,NULL,'2025-11-23 10:06:27',NULL,'2025-11-23 10:06:27',NULL,NULL),(887,NULL,'b893241315df47ebab6327224a5170dd',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:27',NULL,'2025-11-23 10:06:27',NULL,NULL),(888,NULL,'1a691c8a58c54022bea4083c49b0c2e3',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:28',NULL,'2025-11-23 10:06:28',NULL,NULL),(889,NULL,NULL,'0b48598aa88f46cabacda9a56df3b27f',NULL,NULL,NULL,NULL,'2025-11-23 10:06:30',NULL,'2025-11-23 10:06:30',NULL,NULL),(890,NULL,NULL,'6e38e01975ef45b9a08d615712d2502d',NULL,NULL,NULL,NULL,'2025-11-23 10:06:31',NULL,'2025-11-23 10:06:31',NULL,NULL),(891,NULL,NULL,'8c440ef1e1a8457ba1df49a924e1ba5f',NULL,NULL,NULL,NULL,'2025-11-23 10:06:31',NULL,'2025-11-23 10:06:31',NULL,NULL),(892,NULL,NULL,'b0ef51fd6dbc4bd890a74e7dba8b099d',NULL,NULL,NULL,NULL,'2025-11-23 10:06:31',NULL,'2025-11-23 10:06:31',NULL,NULL),(893,NULL,NULL,'be7a7c78a8254565a7379706cb414424',NULL,NULL,NULL,NULL,'2025-11-23 10:06:31',NULL,'2025-11-23 10:06:31',NULL,NULL),(894,NULL,NULL,'4a2100041da8405497554d06faf75fa5',NULL,NULL,NULL,NULL,'2025-11-23 10:06:32',NULL,'2025-11-23 10:06:32',NULL,NULL),(895,NULL,'24fda36724344232b1ac63c5dee96aae',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:32',NULL,'2025-11-23 10:06:32',NULL,NULL),(896,NULL,NULL,'b52f5d7e2eea4f249832a9e7892a6435',NULL,NULL,NULL,NULL,'2025-11-23 10:06:32',NULL,'2025-11-23 10:06:32',NULL,NULL),(897,NULL,'3d9832e0712f41348ba1825f181d4086',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:34',NULL,'2025-11-23 10:06:34',NULL,NULL),(898,NULL,'5f1deb6103c549b5a5c0495e547b683b',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:34',NULL,'2025-11-23 10:06:34',NULL,NULL),(899,NULL,'1dcbf043a91e492e9142e84de0186253',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:34',NULL,'2025-11-23 10:06:34',NULL,NULL),(900,NULL,'3aaf8109aeae4e8a9d20b032d4f40021',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:35',NULL,'2025-11-23 10:06:35',NULL,NULL),(901,NULL,'93f6247fbbbb439eb6e90dd1c39fcf17',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:36',NULL,'2025-11-23 10:06:36',NULL,NULL),(902,NULL,NULL,'bfc8459fb1594cd2b0b0a71806a44b5a',NULL,NULL,NULL,NULL,'2025-11-23 10:06:40',NULL,'2025-11-23 10:06:40',NULL,NULL),(903,NULL,NULL,'f668e56007aa41cda6df54029adea6e9',NULL,NULL,NULL,NULL,'2025-11-23 10:06:40',NULL,'2025-11-23 10:06:40',NULL,NULL),(904,NULL,NULL,'64e7d06fed5b4041b603f81a8b352e85',NULL,NULL,NULL,NULL,'2025-11-23 10:06:40',NULL,'2025-11-23 10:06:40',NULL,NULL),(905,NULL,NULL,'1ce5aa3cdeb74392b464424acb0f8c06',NULL,NULL,NULL,NULL,'2025-11-23 10:06:40',NULL,'2025-11-23 10:06:40',NULL,NULL),(906,NULL,NULL,'022f10e09b1a4f6399df64ab44f0714e',NULL,NULL,NULL,NULL,'2025-11-23 10:06:40',NULL,'2025-11-23 10:06:40',NULL,NULL),(907,NULL,NULL,'92003d85d52c4607a330dc2677c2ea32',NULL,NULL,NULL,NULL,'2025-11-23 10:06:41',NULL,'2025-11-23 10:06:41',NULL,NULL),(908,NULL,NULL,'28dda54dca44480f82385bcdb57298dc',NULL,NULL,NULL,NULL,'2025-11-23 10:06:41',NULL,'2025-11-23 10:06:41',NULL,NULL),(909,NULL,'bd1b52601ecc405a9de9756861ac3a17',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:42',NULL,'2025-11-23 10:06:42',NULL,NULL),(910,NULL,'aa26a17719d84047ac58f13e4eabfd0c',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:42',NULL,'2025-11-23 10:06:42',NULL,NULL),(911,NULL,'141ccb7a18aa4552b64b95f2b6f47c17',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:43',NULL,'2025-11-23 10:06:43',NULL,NULL),(912,NULL,'e151a2616d204040a966e2f4e3ee04ff',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:43',NULL,'2025-11-23 10:06:43',NULL,NULL),(913,NULL,NULL,'1165185c7fd04092b5c02f4591a1386d',NULL,NULL,NULL,NULL,'2025-11-23 10:06:43',NULL,'2025-11-23 10:06:43',NULL,NULL),(914,NULL,'fea104cf3c3a44fbbc740b70a6f93f2e',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:44',NULL,'2025-11-23 10:06:44',NULL,NULL),(915,NULL,'1be7eab758d64df6bb38d4ddeefb99dd',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:44',NULL,'2025-11-23 10:06:44',NULL,NULL),(916,NULL,NULL,'13eadb38de804082a26094a402383205',NULL,NULL,NULL,NULL,'2025-11-23 10:06:45',NULL,'2025-11-23 10:06:45',NULL,NULL),(917,NULL,NULL,'a8367370a22741c3927610e934a28247',NULL,NULL,NULL,NULL,'2025-11-23 10:06:45',NULL,'2025-11-23 10:06:45',NULL,NULL),(918,NULL,NULL,'d2173109550543d6841388ae74ff7d8f',NULL,NULL,NULL,NULL,'2025-11-23 10:06:45',NULL,'2025-11-23 10:06:45',NULL,NULL),(919,NULL,NULL,'d55a8bba524247ddb1849f81b00d48bc',NULL,NULL,NULL,NULL,'2025-11-23 10:06:45',NULL,'2025-11-23 10:06:45',NULL,NULL),(920,NULL,'38a3c2b8630d466a8449f7edabac1951',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:47',NULL,'2025-11-23 10:06:47',NULL,NULL),(921,NULL,'13fe3c0992d749819d6b11bb32ee6c9a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:47',NULL,'2025-11-23 10:06:47',NULL,NULL),(922,NULL,'718aa93d02374c31a3680025fedd5e70',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:48',NULL,'2025-11-23 10:06:48',NULL,NULL),(923,NULL,'3915699ab6dc4d0eacfc4da73bdd0721',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:49',NULL,'2025-11-23 10:06:49',NULL,NULL),(924,NULL,NULL,'8e4802b19267489493a9b954bc28d09a',NULL,NULL,NULL,NULL,'2025-11-23 10:06:49',NULL,'2025-11-23 10:06:49',NULL,NULL),(925,NULL,'e23de8d423c34a75a0a458559bd01733',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:49',NULL,'2025-11-23 10:06:49',NULL,NULL),(926,NULL,NULL,'b36b56871c2c4dc1864d049b64c24b53',NULL,NULL,NULL,NULL,'2025-11-23 10:06:54',NULL,'2025-11-23 10:06:54',NULL,NULL),(927,NULL,NULL,'8483e09239ab4b5695e53a06581517fc',NULL,NULL,NULL,NULL,'2025-11-23 10:06:55',NULL,'2025-11-23 10:06:55',NULL,NULL),(928,NULL,NULL,'674f7c19d25b424a8b6c074a148cc0bd',NULL,NULL,NULL,NULL,'2025-11-23 10:06:55',NULL,'2025-11-23 10:06:55',NULL,NULL),(929,NULL,NULL,'350b256297024bf9a7002369a31b165c',NULL,NULL,NULL,NULL,'2025-11-23 10:06:55',NULL,'2025-11-23 10:06:55',NULL,NULL),(930,NULL,NULL,'1b77847c407f4e208881434bec8e637c',NULL,NULL,NULL,NULL,'2025-11-23 10:06:56',NULL,'2025-11-23 10:06:56',NULL,NULL),(931,NULL,'bfa0984bca614cf4b4c58d505df25055',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:57',NULL,'2025-11-23 10:06:57',NULL,NULL),(932,NULL,NULL,'d919be80e59845fbb2790f6ff25ebd96',NULL,NULL,NULL,NULL,'2025-11-23 10:06:57',NULL,'2025-11-23 10:06:57',NULL,NULL),(933,NULL,'dd925bc8c28148ba8527b8de09a93c3c',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:57',NULL,'2025-11-23 10:06:57',NULL,NULL),(934,NULL,'02ae9008b69a486ea872eaae08e1909a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:57',NULL,'2025-11-23 10:06:57',NULL,NULL),(935,NULL,'032366799aab483eb029bd736822e06d',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:58',NULL,'2025-11-23 10:06:58',NULL,NULL),(936,NULL,'44a6cb5f8b014bad84cfff33db7a4de0',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:06:58',NULL,'2025-11-23 10:06:58',NULL,NULL),(937,NULL,NULL,'e2ea168a6db743419c38fd46fa408841',NULL,NULL,NULL,NULL,'2025-11-23 10:07:01',NULL,'2025-11-23 10:07:01',NULL,NULL),(938,NULL,NULL,'7c973c3c4b4e455ca7b29f10f0565cec',NULL,NULL,NULL,NULL,'2025-11-23 10:07:03',NULL,'2025-11-23 10:07:03',NULL,NULL),(939,NULL,NULL,'bda25f10eab54069a6ca1eefb9ed3e65',NULL,NULL,NULL,NULL,'2025-11-23 10:07:03',NULL,'2025-11-23 10:07:03',NULL,NULL),(940,NULL,NULL,'64cc50e95a4348f8a1d9a0a97d78fd99',NULL,NULL,NULL,NULL,'2025-11-23 10:07:03',NULL,'2025-11-23 10:07:03',NULL,NULL),(941,NULL,NULL,'d5172a7c4876455aa80cf5de44081cd0',NULL,NULL,NULL,NULL,'2025-11-23 10:07:04',NULL,'2025-11-23 10:07:04',NULL,NULL),(942,NULL,'5b6bdb24389f446297627653bba8ce06',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:05',NULL,'2025-11-23 10:07:05',NULL,NULL),(943,NULL,'e93403bd474e4e9baa8b4c25a44b37ea',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:05',NULL,'2025-11-23 10:07:05',NULL,NULL),(944,NULL,'53f31b2a9f5a44f798c812a2b4ca005a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:06',NULL,'2025-11-23 10:07:06',NULL,NULL),(945,NULL,NULL,'7fae8bd255614f2a992630ddb3b5446a',NULL,NULL,NULL,NULL,'2025-11-23 10:07:08',NULL,'2025-11-23 10:07:08',NULL,NULL),(946,NULL,NULL,'89837a90242e4f1a97847ac5c68b9d7b',NULL,NULL,NULL,NULL,'2025-11-23 10:07:08',NULL,'2025-11-23 10:07:08',NULL,NULL),(947,NULL,NULL,'59f78c76c35544eeb4e88001574787ed',NULL,NULL,NULL,NULL,'2025-11-23 10:07:09',NULL,'2025-11-23 10:07:09',NULL,NULL),(948,NULL,'1fa50ded1536493ab576c7056980bef4',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:10',NULL,'2025-11-23 10:07:10',NULL,NULL),(949,NULL,'7df4b50a5baa4c018f54224d0330ce25',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:11',NULL,'2025-11-23 10:07:11',NULL,NULL),(950,NULL,'cdf61158700a41c1880752eab2d756d8',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:12',NULL,'2025-11-23 10:07:12',NULL,NULL),(951,NULL,NULL,'09922c53950b4177b0724692a205b6b7',NULL,NULL,NULL,NULL,'2025-11-23 10:07:15',NULL,'2025-11-23 10:07:15',NULL,NULL),(952,NULL,NULL,'7cd7af7cff6e4a37ad5ba7ad9073aff1',NULL,NULL,NULL,NULL,'2025-11-23 10:07:19',NULL,'2025-11-23 10:07:19',NULL,NULL),(953,NULL,NULL,'aa18a71f869f4cacab361d4a67f5f5e2',NULL,NULL,NULL,NULL,'2025-11-23 10:07:19',NULL,'2025-11-23 10:07:19',NULL,NULL),(954,NULL,NULL,'95abdc6959da45d4a2467b1c9ad5bc41',NULL,NULL,NULL,NULL,'2025-11-23 10:07:19',NULL,'2025-11-23 10:07:19',NULL,NULL),(955,NULL,'b2b643061e7e43609bfddf91b9cbec2e',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:21',NULL,'2025-11-23 10:07:21',NULL,NULL),(956,NULL,'d184c87ab22c47e0b6e47660f82f57fd',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:22',NULL,'2025-11-23 10:07:22',NULL,NULL),(957,NULL,'ba92c955d221402285494e36c675a53e',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:22',NULL,'2025-11-23 10:07:22',NULL,NULL),(958,NULL,NULL,'b98d6d6722e04ad3ab537ebdf8d57e1d',NULL,NULL,NULL,NULL,'2025-11-23 10:07:25',NULL,'2025-11-23 10:07:25',NULL,NULL),(959,NULL,NULL,'aa226a7988cb445f88f27b4371eb193a',NULL,NULL,NULL,NULL,'2025-11-23 10:07:25',NULL,'2025-11-23 10:07:25',NULL,NULL),(960,NULL,NULL,'501142af53ff4d5e88e9cfe4c08cc922',NULL,NULL,NULL,NULL,'2025-11-23 10:07:25',NULL,'2025-11-23 10:07:25',NULL,NULL),(961,NULL,'acf2d5195bde4e69ba34cd2a2c03e717',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:26',NULL,'2025-11-23 10:07:26',NULL,NULL),(962,NULL,'ddf600ac6a4a4ab6a2eb4d0f7acb5303',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:27',NULL,'2025-11-23 10:07:27',NULL,NULL),(963,NULL,'4e966c3cb7e340c1a76c532825794ed0',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:27',NULL,'2025-11-23 10:07:27',NULL,NULL),(964,NULL,NULL,'470f8273d9664aea8f6b91928e9f6f6c',NULL,NULL,NULL,NULL,'2025-11-23 10:07:30',NULL,'2025-11-23 10:07:30',NULL,NULL),(965,NULL,'33c4eecf43aa413a9f282206f9e9a55b',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:30',NULL,'2025-11-23 10:07:30',NULL,NULL),(966,NULL,NULL,'9ac4ba67fa514b22a12990939973a2a4',NULL,NULL,NULL,NULL,'2025-11-23 10:07:32',NULL,'2025-11-23 10:07:32',NULL,NULL),(967,NULL,NULL,'782bce61dc0f4eb98b2487e441e740fa',NULL,NULL,NULL,NULL,'2025-11-23 10:07:32',NULL,'2025-11-23 10:07:32',NULL,NULL),(968,NULL,NULL,'27954d537f194e3aa3fccb1d0995fa6d',NULL,NULL,NULL,NULL,'2025-11-23 10:07:32',NULL,'2025-11-23 10:07:32',NULL,NULL),(969,NULL,NULL,'9c056afc407a481f97cf7a528337e974',NULL,NULL,NULL,NULL,'2025-11-23 10:07:32',NULL,'2025-11-23 10:07:32',NULL,NULL),(970,NULL,'4eedbcbfd9a24f2aa9d785c82ad6ec27',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:33',NULL,'2025-11-23 10:07:33',NULL,NULL),(971,NULL,'ca32e969b5da4136a27ad2860925dd25',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:34',NULL,'2025-11-23 10:07:34',NULL,NULL),(972,NULL,'a49005a0367c4d40aa5159caf60f014a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:35',NULL,'2025-11-23 10:07:35',NULL,NULL),(973,NULL,NULL,'27912d66684f4f9bbe9184e1ff1aa9f7',NULL,NULL,NULL,NULL,'2025-11-23 10:07:37',NULL,'2025-11-23 10:07:37',NULL,NULL),(974,NULL,NULL,'84b8a6a5dcc74a3e9eb9a0e8934261e5',NULL,NULL,NULL,NULL,'2025-11-23 10:07:37',NULL,'2025-11-23 10:07:37',NULL,NULL),(975,NULL,'bbe1daae99594f21b95bd1d854d9fd48',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:38',NULL,'2025-11-23 10:07:38',NULL,NULL),(976,NULL,'b636df0d8cb546cbb04ef3840b8bf85d',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:39',NULL,'2025-11-23 10:07:39',NULL,NULL),(977,NULL,NULL,'fa83c71a11144a75ae7f6512b3c55e59',NULL,NULL,NULL,NULL,'2025-11-23 10:07:40',NULL,'2025-11-23 10:07:40',NULL,NULL),(978,NULL,'fb3243ddd12849b4ae87c500b5ea5cd3',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:41',NULL,'2025-11-23 10:07:41',NULL,NULL),(979,NULL,NULL,'10eca9a58ad343129b3ee33ea2e35778',NULL,NULL,NULL,NULL,'2025-11-23 10:07:44',NULL,'2025-11-23 10:07:44',NULL,NULL),(980,NULL,NULL,'7c20268b764b4fbea5c44b9f539a5227',NULL,NULL,NULL,NULL,'2025-11-23 10:07:44',NULL,'2025-11-23 10:07:44',NULL,NULL),(981,NULL,NULL,'639ec26612f443fea7cb26c0ea9edc53',NULL,NULL,NULL,NULL,'2025-11-23 10:07:45',NULL,'2025-11-23 10:07:45',NULL,NULL),(982,NULL,NULL,'91413c184f394807978c24e936e5c58f',NULL,NULL,NULL,NULL,'2025-11-23 10:07:45',NULL,'2025-11-23 10:07:45',NULL,NULL),(983,NULL,'7f48fa865c4047a080902678e51be06e',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:45',NULL,'2025-11-23 10:07:45',NULL,NULL),(984,NULL,NULL,'647eaf91744044e092ff779f60c6bf81',NULL,NULL,NULL,NULL,'2025-11-23 10:07:45',NULL,'2025-11-23 10:07:45',NULL,NULL),(985,NULL,NULL,'da08e7062d024dd192735c505c25e971',NULL,NULL,NULL,NULL,'2025-11-23 10:07:45',NULL,'2025-11-23 10:07:45',NULL,NULL),(986,NULL,'353e3a021df940c0838bf3dc0b3f265a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:46',NULL,'2025-11-23 10:07:46',NULL,NULL),(987,NULL,'812e12744eb745bcadf0dcbfeff51a92',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:47',NULL,'2025-11-23 10:07:47',NULL,NULL),(988,NULL,'b019d76a92874beebaf22fd6a1c86a7f',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:47',NULL,'2025-11-23 10:07:47',NULL,NULL),(989,NULL,'db67d55113d949c5acee42503faac567',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:48',NULL,'2025-11-23 10:07:48',NULL,NULL),(990,NULL,NULL,'b97d9730069a4891aaf77ccce8c0ffa5',NULL,NULL,NULL,NULL,'2025-11-23 10:07:48',NULL,'2025-11-23 10:07:48',NULL,NULL),(991,NULL,'58bf8ae7240d4a5597bb2d7ae200e54b',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:49',NULL,'2025-11-23 10:07:49',NULL,NULL),(992,NULL,NULL,'06d3a6658ff2400998628e5fc807ca13',NULL,NULL,NULL,NULL,'2025-11-23 10:07:50',NULL,'2025-11-23 10:07:50',NULL,NULL),(993,NULL,NULL,'43968440d7a14a1dbe1dc6d9d619d4cd',NULL,NULL,NULL,NULL,'2025-11-23 10:07:51',NULL,'2025-11-23 10:07:51',NULL,NULL),(994,NULL,'01901434b5334d37a3530d273178ac9d',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:53',NULL,'2025-11-23 10:07:53',NULL,NULL),(995,NULL,NULL,'c8bc8c2b51f24b8ba76ee263be4acc30',NULL,NULL,NULL,NULL,'2025-11-23 10:07:55',NULL,'2025-11-23 10:07:55',NULL,NULL),(996,NULL,'05d4bf14d0e543fd9bf3c38684d9cd9f',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:56',NULL,'2025-11-23 10:07:56',NULL,NULL),(997,NULL,NULL,'46bc233a14ac463584fc9a98352f3940',NULL,NULL,NULL,NULL,'2025-11-23 10:07:57',NULL,'2025-11-23 10:07:57',NULL,NULL),(998,NULL,NULL,'523641f787484f098d646b0e5069b1fc',NULL,NULL,NULL,NULL,'2025-11-23 10:07:57',NULL,'2025-11-23 10:07:57',NULL,NULL),(999,NULL,NULL,'3b9f0deef53b4da3b2c5b56b16a5994d',NULL,NULL,NULL,NULL,'2025-11-23 10:07:57',NULL,'2025-11-23 10:07:57',NULL,NULL),(1000,NULL,'24481696f9cd427d87b3573d3ae13f5e',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:58',NULL,'2025-11-23 10:07:58',NULL,NULL),(1001,NULL,NULL,'5c75df1073254530b9569f7e7769a0a9',NULL,NULL,NULL,NULL,'2025-11-23 10:07:58',NULL,'2025-11-23 10:07:58',NULL,NULL),(1002,NULL,'b874354dcdba428b915260626d5e254c',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:07:59',NULL,'2025-11-23 10:07:59',NULL,NULL),(1003,NULL,NULL,'6e12ff38ef5d4e41a8a0fc5b406b3ea1',NULL,NULL,NULL,NULL,'2025-11-23 10:08:00',NULL,'2025-11-23 10:08:00',NULL,NULL),(1004,NULL,'c4833c469f9b4254b420faba19b493d6',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:00',NULL,'2025-11-23 10:08:00',NULL,NULL),(1005,NULL,'fb52a68ccbdd4d98b7863935a567100d',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:00',NULL,'2025-11-23 10:08:00',NULL,NULL),(1006,NULL,NULL,'f15124f92efc44359ea2318339ae8c5f',NULL,NULL,NULL,NULL,'2025-11-23 10:08:00',NULL,'2025-11-23 10:08:00',NULL,NULL),(1007,NULL,NULL,'26b113fd6a244e3380048b6ef594764d',NULL,NULL,NULL,NULL,'2025-11-23 10:08:00',NULL,'2025-11-23 10:08:00',NULL,NULL),(1008,NULL,NULL,'3b428c5df59d47039f2e765a303f1292',NULL,NULL,NULL,NULL,'2025-11-23 10:08:00',NULL,'2025-11-23 10:08:00',NULL,NULL),(1009,NULL,NULL,'135806c8b727487fb136561b679ca7fe',NULL,NULL,NULL,NULL,'2025-11-23 10:08:01',NULL,'2025-11-23 10:08:01',NULL,NULL),(1010,NULL,'98fd640c82a843bea1e0247d953067ba',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:01',NULL,'2025-11-23 10:08:01',NULL,NULL),(1011,NULL,'eacae18cedc64027b1aed993d12bae03',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:02',NULL,'2025-11-23 10:08:02',NULL,NULL),(1012,NULL,NULL,'0e0d50c0524b465ca97ba7ac304b642f',NULL,NULL,NULL,NULL,'2025-11-23 10:08:02',NULL,'2025-11-23 10:08:02',NULL,NULL),(1013,NULL,'cec60e6d9de54cf29680f5ced5cf227d',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:03',NULL,'2025-11-23 10:08:03',NULL,NULL),(1014,NULL,'f251bcad6f5746ebaa506b48e45ae318',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:03',NULL,'2025-11-23 10:08:03',NULL,NULL),(1015,NULL,NULL,'d7518d96a3d24bcc8f6074244df9b08c',NULL,NULL,NULL,NULL,'2025-11-23 10:08:03',NULL,'2025-11-23 10:08:03',NULL,NULL),(1016,NULL,'7d5d0eedb7da49fa8ee42f6251191fd6',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:05',NULL,'2025-11-23 10:08:05',NULL,NULL),(1017,NULL,NULL,'dd9cc667df66458bbf2e146132ceee00',NULL,NULL,NULL,NULL,'2025-11-23 10:08:05',NULL,'2025-11-23 10:08:05',NULL,NULL),(1018,NULL,'f37faef8284e4ebf81b970eb1e913756',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:06',NULL,'2025-11-23 10:08:06',NULL,NULL),(1019,NULL,NULL,'1b55cd19f41a4b1bbd32b00aa53a6f17',NULL,NULL,NULL,NULL,'2025-11-23 10:08:07',NULL,'2025-11-23 10:08:07',NULL,NULL),(1020,NULL,NULL,'1fcabcd5e8ef4405bd339551808f018a',NULL,NULL,NULL,NULL,'2025-11-23 10:08:07',NULL,'2025-11-23 10:08:07',NULL,NULL),(1021,NULL,NULL,'d818c99e3b2c4043b8e62bb1cb243e3b',NULL,NULL,NULL,NULL,'2025-11-23 10:08:07',NULL,'2025-11-23 10:08:07',NULL,NULL),(1022,NULL,NULL,'636cb527a35f47969bd4b228072efb88',NULL,NULL,NULL,NULL,'2025-11-23 10:08:07',NULL,'2025-11-23 10:08:07',NULL,NULL),(1023,NULL,NULL,'6ddf5b73960b418b9ff8ae0cf037300b',NULL,NULL,NULL,NULL,'2025-11-23 10:08:08',NULL,'2025-11-23 10:08:08',NULL,NULL),(1024,NULL,NULL,'08a0404d789744e69025a3c0f5ea29c4',NULL,NULL,NULL,NULL,'2025-11-23 10:08:08',NULL,'2025-11-23 10:08:08',NULL,NULL),(1025,NULL,NULL,'d709aebb5873496e83e445342753f653',NULL,NULL,NULL,NULL,'2025-11-23 10:08:08',NULL,'2025-11-23 10:08:08',NULL,NULL),(1026,NULL,'6dc477fc6d35441ba8c7a38be5ebeed6',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:08',NULL,'2025-11-23 10:08:08',NULL,NULL),(1027,NULL,'dfc6681c099d46f0a904bf9eea736c22',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:09',NULL,'2025-11-23 10:08:09',NULL,NULL),(1028,NULL,'c6d71891a5ee4095a43231fc75294950',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:10',NULL,'2025-11-23 10:08:10',NULL,NULL),(1029,NULL,'293f6e3fc4744fbfa310b5fa28115a56',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:10',NULL,'2025-11-23 10:08:10',NULL,NULL),(1030,NULL,'e16872b51d7541b48411cbf0be50f6f2',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:11',NULL,'2025-11-23 10:08:11',NULL,NULL),(1031,NULL,'782aca32916c4acc8693c70ef88f33c2',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:11',NULL,'2025-11-23 10:08:11',NULL,NULL),(1032,NULL,NULL,'071303cb2e2e4ab4a570da3ba035612c',NULL,NULL,NULL,NULL,'2025-11-23 10:08:13',NULL,'2025-11-23 10:08:13',NULL,NULL),(1033,NULL,NULL,'fe06ed79308b41a986d55f732182b775',NULL,NULL,NULL,NULL,'2025-11-23 10:08:17',NULL,'2025-11-23 10:08:17',NULL,NULL),(1034,NULL,NULL,'8817f001f1ce481c80ca27e7c13a58e4',NULL,NULL,NULL,NULL,'2025-11-23 10:08:17',NULL,'2025-11-23 10:08:17',NULL,NULL),(1035,NULL,NULL,'5c100dc9ed5149cc9da53245194a2a3d',NULL,NULL,NULL,NULL,'2025-11-23 10:08:17',NULL,'2025-11-23 10:08:17',NULL,NULL),(1036,NULL,NULL,'2d3e494889b14951b8175b37f8c3f5e5',NULL,NULL,NULL,NULL,'2025-11-23 10:08:17',NULL,'2025-11-23 10:08:17',NULL,NULL),(1037,NULL,'5c1a54afbdd44632bf9df49f9ef058a6',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:18',NULL,'2025-11-23 10:08:18',NULL,NULL),(1038,NULL,'28400844d41c42298eb4ff485fb7ba83',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:19',NULL,'2025-11-23 10:08:19',NULL,NULL),(1039,NULL,'fca85941970a450aaec057ef036f1a27',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:20',NULL,'2025-11-23 10:08:20',NULL,NULL),(1040,NULL,NULL,'ea80323d302d40ffb908424078a626e7',NULL,NULL,NULL,NULL,'2025-11-23 10:08:23',NULL,'2025-11-23 10:08:23',NULL,NULL),(1041,NULL,NULL,'2b7cccb126ac41978fc5f78704afff71',NULL,NULL,NULL,NULL,'2025-11-23 10:08:23',NULL,'2025-11-23 10:08:23',NULL,NULL),(1042,NULL,NULL,'c26f0e94847c4498b641d36cd7f9e893',NULL,NULL,NULL,NULL,'2025-11-23 10:08:24',NULL,'2025-11-23 10:08:24',NULL,NULL),(1043,NULL,'311c467aabc6426d85f3fd8eac9aed71',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:25',NULL,'2025-11-23 10:08:25',NULL,NULL),(1044,NULL,'094bf34b438747b1908d23d0eb68135b',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:25',NULL,'2025-11-23 10:08:25',NULL,NULL),(1045,NULL,'09121c745ed044f4ac1be69b2e85b19c',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:26',NULL,'2025-11-23 10:08:26',NULL,NULL),(1046,NULL,NULL,'a2a20f7b3bdc488bb469de7081d6bdda',NULL,NULL,NULL,NULL,'2025-11-23 10:08:32',NULL,'2025-11-23 10:08:32',NULL,NULL),(1047,NULL,NULL,'9272cfd3fbad46a0858a8c3d2b7c69b9',NULL,NULL,NULL,NULL,'2025-11-23 10:08:32',NULL,'2025-11-23 10:08:32',NULL,NULL),(1048,NULL,NULL,'0d45e11ccc724e6c846127fc6b3ef191',NULL,NULL,NULL,NULL,'2025-11-23 10:08:32',NULL,'2025-11-23 10:08:32',NULL,NULL),(1049,NULL,NULL,'dce881a0acdf499699d2b927482308f5',NULL,NULL,NULL,NULL,'2025-11-23 10:08:32',NULL,'2025-11-23 10:08:32',NULL,NULL),(1050,NULL,'3893741994fb4b789f253fc559e364df',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:33',NULL,'2025-11-23 10:08:33',NULL,NULL),(1051,NULL,'eb5b74b9d7244a62a5c0b7f105ffc85a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:34',NULL,'2025-11-23 10:08:34',NULL,NULL),(1052,NULL,'fc2feead2ab54cbc9ed4bbb6b6f886cc',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:35',NULL,'2025-11-23 10:08:35',NULL,NULL),(1053,NULL,NULL,'26e6d20ae34448cfb4ab9e44b5c2b297',NULL,NULL,NULL,NULL,'2025-11-23 10:08:39',NULL,'2025-11-23 10:08:39',NULL,NULL),(1054,NULL,'bdbef8738c274e8dadf9e931f2c11f32',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:40',NULL,'2025-11-23 10:08:40',NULL,NULL),(1055,NULL,NULL,'9713e9c438c0438dbba1aa3b004d8412',NULL,NULL,NULL,NULL,'2025-11-23 10:08:42',NULL,'2025-11-23 10:08:42',NULL,NULL),(1056,NULL,'a2e04a006383460b8c9d25300d5e1fa7',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:44',NULL,'2025-11-23 10:08:44',NULL,NULL),(1057,NULL,NULL,'79ccf3896fea451f822734660f97bb4c',NULL,NULL,NULL,NULL,'2025-11-23 10:08:44',NULL,'2025-11-23 10:08:44',NULL,NULL),(1058,NULL,NULL,'e1fdf7bc1b98455892e91d15010841f7',NULL,NULL,NULL,NULL,'2025-11-23 10:08:44',NULL,'2025-11-23 10:08:44',NULL,NULL),(1059,NULL,NULL,'b2f6d5fbecbb4d59ad4af3671fe4f7f3',NULL,NULL,NULL,NULL,'2025-11-23 10:08:44',NULL,'2025-11-23 10:08:44',NULL,NULL),(1060,NULL,NULL,'20f6e7745af64e66a05dc27cee815b20',NULL,NULL,NULL,NULL,'2025-11-23 10:08:45',NULL,'2025-11-23 10:08:45',NULL,NULL),(1061,NULL,'c28b9a4681bf4016988bbe98cb78fd1e',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:46',NULL,'2025-11-23 10:08:46',NULL,NULL),(1062,NULL,NULL,'c1d7c2d41e984ca4af9b785220e65da9',NULL,NULL,NULL,NULL,'2025-11-23 10:08:46',NULL,'2025-11-23 10:08:46',NULL,NULL),(1063,NULL,'c416b73aa58e4c07addc62428be1321b',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:47',NULL,'2025-11-23 10:08:47',NULL,NULL),(1064,NULL,'f67bf87bfeb4465ba03c9c69d424e183',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:47',NULL,'2025-11-23 10:08:47',NULL,NULL),(1065,NULL,'52298ce19795428aa635db62bae9c715',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:48',NULL,'2025-11-23 10:08:48',NULL,NULL),(1066,NULL,NULL,'9092419a844546ff966e031ecfbe1f99',NULL,NULL,NULL,NULL,'2025-11-23 10:08:55',NULL,'2025-11-23 10:08:55',NULL,NULL),(1067,NULL,NULL,'5dffb09edaf54dda971a01e9b592ac29',NULL,NULL,NULL,NULL,'2025-11-23 10:08:55',NULL,'2025-11-23 10:08:55',NULL,NULL),(1068,NULL,NULL,'3816d18b464243fa9e1bb9cb8f5e1694',NULL,NULL,NULL,NULL,'2025-11-23 10:08:55',NULL,'2025-11-23 10:08:55',NULL,NULL),(1069,NULL,NULL,'2ee806dc6a534de1b03923120b7ecade',NULL,NULL,NULL,NULL,'2025-11-23 10:08:56',NULL,'2025-11-23 10:08:56',NULL,NULL),(1070,NULL,'365d81ba6a5e49628d54225e7556ee12',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:57',NULL,'2025-11-23 10:08:57',NULL,NULL),(1071,NULL,'cf848f0500a0449cba64e51601c95159',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:58',NULL,'2025-11-23 10:08:58',NULL,NULL),(1072,NULL,'186499b24a9547e5b86e9336bbce907b',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:08:58',NULL,'2025-11-23 10:08:58',NULL,NULL),(1073,NULL,NULL,'21cc3c46245244d09dbfe7cdb8d6e99e',NULL,NULL,NULL,NULL,'2025-11-23 10:09:17',NULL,'2025-11-23 10:09:17',NULL,NULL),(1074,NULL,NULL,'1a1a5a2be4e34fafb5b7111bbd83e869',NULL,NULL,NULL,NULL,'2025-11-23 10:09:18',NULL,'2025-11-23 10:09:18',NULL,NULL),(1075,NULL,NULL,'d2a5e06bc3ca450f81f13a06170954c7',NULL,NULL,NULL,NULL,'2025-11-23 10:09:18',NULL,'2025-11-23 10:09:18',NULL,NULL),(1076,NULL,NULL,'bbbfab518c7f4df1932874266c405db5',NULL,NULL,NULL,NULL,'2025-11-23 10:09:18',NULL,'2025-11-23 10:09:18',NULL,NULL),(1077,NULL,'5fcc37eb198d4310a10e589a37cde442',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:09:19',NULL,'2025-11-23 10:09:19',NULL,NULL),(1078,NULL,'fec6ab68986546eca4960f54d61bb053',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:09:20',NULL,'2025-11-23 10:09:20',NULL,NULL),(1079,NULL,'28541df1d04743b08d50d1beba4cfee1',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:09:20',NULL,'2025-11-23 10:09:20',NULL,NULL),(1080,NULL,NULL,'c91c98bfb3084bc9b16a97fda08fcb27',NULL,NULL,NULL,NULL,'2025-11-23 10:09:26',NULL,'2025-11-23 10:09:26',NULL,NULL),(1081,NULL,NULL,'6135240489d346c0a57f4b73b299d49d',NULL,NULL,NULL,NULL,'2025-11-23 10:09:26',NULL,'2025-11-23 10:09:26',NULL,NULL),(1082,NULL,NULL,'69b4c51ee386489baf45acb5638b95eb',NULL,NULL,NULL,NULL,'2025-11-23 10:09:30',NULL,'2025-11-23 10:09:30',NULL,NULL),(1083,NULL,NULL,'60015cff6ad9455ab1270c271976d612',NULL,NULL,NULL,NULL,'2025-11-23 10:09:30',NULL,'2025-11-23 10:09:30',NULL,NULL),(1084,NULL,NULL,'6bb1788c47ad4c24b5eb653d06e5972a',NULL,NULL,NULL,NULL,'2025-11-23 10:09:30',NULL,'2025-11-23 10:09:30',NULL,NULL),(1085,NULL,'4d4586d45fe545c4bf78ea7720359b10',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:09:31',NULL,'2025-11-23 10:09:31',NULL,NULL),(1086,NULL,'9d390c56c4ed4e17946071f23c99a816',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:09:32',NULL,'2025-11-23 10:09:32',NULL,NULL),(1087,NULL,'32bb0449ce3a4e67ad3295b59f1fe0fb',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:09:32',NULL,'2025-11-23 10:09:32',NULL,NULL),(1088,NULL,NULL,'9ca9409a6cc447e39987180bf07dadca',NULL,NULL,NULL,NULL,'2025-11-23 10:09:34',NULL,'2025-11-23 10:09:34',NULL,NULL),(1089,NULL,'65aa1963c7e0437396d5785d62f6c386',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:09:35',NULL,'2025-11-23 10:09:35',NULL,NULL),(1090,NULL,NULL,'e0c0789eaa7f4d4fabd1b308ddc470c7',NULL,NULL,NULL,NULL,'2025-11-23 10:09:36',NULL,'2025-11-23 10:09:36',NULL,NULL),(1091,NULL,NULL,'2e6273b692d04953b11e15874c09d728',NULL,NULL,NULL,NULL,'2025-11-23 10:09:40',NULL,'2025-11-23 10:09:40',NULL,NULL),(1092,NULL,NULL,'efc7973c4dc44c3a93742c23d6576be2',NULL,NULL,NULL,NULL,'2025-11-23 10:09:40',NULL,'2025-11-23 10:09:40',NULL,NULL),(1093,NULL,NULL,'7915500e97604d029b49e9bf39f90cba',NULL,NULL,NULL,NULL,'2025-11-23 10:09:40',NULL,'2025-11-23 10:09:40',NULL,NULL),(1094,NULL,NULL,'ad16077de445492c95391324e107055d',NULL,NULL,NULL,NULL,'2025-11-23 10:09:41',NULL,'2025-11-23 10:09:41',NULL,NULL),(1095,NULL,NULL,'98aa9eba63b94c66952c811458c23fd2',NULL,NULL,NULL,NULL,'2025-11-23 10:09:41',NULL,'2025-11-23 10:09:41',NULL,NULL),(1096,NULL,NULL,'586538d4ac8848bd8864b397f5dde9a5',NULL,NULL,NULL,NULL,'2025-11-23 10:09:41',NULL,'2025-11-23 10:09:41',NULL,NULL),(1097,NULL,'f170ad8dcaa4443d9a0cd7143382d7a3',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:09:41',NULL,'2025-11-23 10:09:41',NULL,NULL),(1098,NULL,NULL,'2d93dd8986274d23b2987e56bf7e9e70',NULL,NULL,NULL,NULL,'2025-11-23 10:09:41',NULL,'2025-11-23 10:09:41',NULL,NULL),(1099,NULL,'ae90becd2bc545f2a912cb9d303ea195',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:09:42',NULL,'2025-11-23 10:09:42',NULL,NULL),(1100,NULL,'c7c0988f68df4543bb12d72d02ba35d5',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:09:42',NULL,'2025-11-23 10:09:42',NULL,NULL),(1101,NULL,'8674e171c8664c3a9f0475cb9dde1a87',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:09:42',NULL,'2025-11-23 10:09:42',NULL,NULL),(1102,NULL,'d5bac6dd8a2a4ad7a79f5220ed3dd29a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:09:43',NULL,'2025-11-23 10:09:43',NULL,NULL),(1103,NULL,'b404ea23739c4c46bf94e2be282bfb92',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:09:44',NULL,'2025-11-23 10:09:44',NULL,NULL),(1104,NULL,NULL,'94ccb816590745bc984d200cd5a76279',NULL,NULL,NULL,NULL,'2025-11-23 10:09:45',NULL,'2025-11-23 10:09:45',NULL,NULL),(1105,NULL,'bf91ab9d27774dbdb1b5df5d9a5d99f1',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:09:46',NULL,'2025-11-23 10:09:46',NULL,NULL),(1106,NULL,NULL,'bc1ba9b716f9432a977cbaed66aa5245',NULL,NULL,NULL,NULL,'2025-11-23 10:09:51',NULL,'2025-11-23 10:09:51',NULL,NULL),(1107,NULL,NULL,'3a5155a3e3cd48a6b5bdb9b78efceef8',NULL,NULL,NULL,NULL,'2025-11-23 10:09:51',NULL,'2025-11-23 10:09:51',NULL,NULL),(1108,NULL,NULL,'bd23a864311943b3a81bceb57e17dac1',NULL,NULL,NULL,NULL,'2025-11-23 10:09:52',NULL,'2025-11-23 10:09:52',NULL,NULL),(1109,NULL,NULL,'44b192a546ef4e5f80ab9a76abc51c21',NULL,NULL,NULL,NULL,'2025-11-23 10:09:52',NULL,'2025-11-23 10:09:52',NULL,NULL),(1110,NULL,NULL,'abaaea6c9db54837a2d566c7220edfb7',NULL,NULL,NULL,NULL,'2025-11-23 10:09:52',NULL,'2025-11-23 10:09:52',NULL,NULL),(1111,NULL,NULL,'a8b24cf78c4a4202b0af8f836283eeb9',NULL,NULL,NULL,NULL,'2025-11-23 10:09:52',NULL,'2025-11-23 10:09:52',NULL,NULL),(1112,NULL,'cbf6ee7d8cbf4427b51fe00fa75fdc28',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:09:53',NULL,'2025-11-23 10:09:53',NULL,NULL),(1113,NULL,'1df66c434ea940698212653002587313',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:09:54',NULL,'2025-11-23 10:09:54',NULL,NULL),(1114,NULL,'77d8aa2731d440148b1232b2de947ad3',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:09:54',NULL,'2025-11-23 10:09:54',NULL,NULL),(1115,NULL,NULL,'a78c4c2848b64569858163ceb6bbf9cc',NULL,NULL,NULL,NULL,'2025-11-23 10:09:57',NULL,'2025-11-23 10:09:57',NULL,NULL),(1116,NULL,'8d18a687f59d4afd9a3ed01ff1fa514c',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:09:58',NULL,'2025-11-23 10:09:58',NULL,NULL),(1117,NULL,NULL,'53dd88525b764bb9a85c931576dd1d2a',NULL,NULL,NULL,NULL,'2025-11-23 10:09:59',NULL,'2025-11-23 10:09:59',NULL,NULL),(1118,NULL,NULL,'dbb864a440e447ce9cc97e1f68437921',NULL,NULL,NULL,NULL,'2025-11-23 10:09:59',NULL,'2025-11-23 10:09:59',NULL,NULL),(1119,NULL,NULL,'a6a051b200404b1da7d189bf06a2542c',NULL,NULL,NULL,NULL,'2025-11-23 10:10:00',NULL,'2025-11-23 10:10:00',NULL,NULL),(1120,NULL,'c3ca74a8574b42a58709835f57703a8a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:10:01',NULL,'2025-11-23 10:10:01',NULL,NULL),(1121,NULL,'e8c1970cea814711a83d81b0bf7c1d70',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:10:02',NULL,'2025-11-23 10:10:02',NULL,NULL),(1122,NULL,'836ae7fa48674096a03624b407ebbbc9',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:10:02',NULL,'2025-11-23 10:10:02',NULL,NULL),(1123,NULL,NULL,'b1a1e1af26ce4f0b87cd03f601062de2',NULL,NULL,NULL,NULL,'2025-11-23 10:10:04',NULL,'2025-11-23 10:10:04',NULL,NULL),(1124,NULL,NULL,'c885a5b6e816443da28ee6114cf7149e',NULL,NULL,NULL,NULL,'2025-11-23 10:10:04',NULL,'2025-11-23 10:10:04',NULL,NULL),(1125,NULL,NULL,'49b48ef1cb29416d8a20afc6e18a4fab',NULL,NULL,NULL,NULL,'2025-11-23 10:10:04',NULL,'2025-11-23 10:10:04',NULL,NULL),(1126,NULL,NULL,'fd3691a8ffd74197910de20a97cd948d',NULL,NULL,NULL,NULL,'2025-11-23 10:10:04',NULL,'2025-11-23 10:10:04',NULL,NULL),(1127,NULL,NULL,'cc53057ca4b14a44af9cb091f20ecc86',NULL,NULL,NULL,NULL,'2025-11-23 10:10:04',NULL,'2025-11-23 10:10:04',NULL,NULL),(1128,NULL,'03acd0a3e3b1420b9e6e7911fa3e837d',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:10:06',NULL,'2025-11-23 10:10:06',NULL,NULL),(1129,NULL,'ad27fffd8bc44b0fa2149605bd66a287',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:10:06',NULL,'2025-11-23 10:10:06',NULL,NULL),(1130,NULL,'fb641ed3fec34c90a8b524fc828901ff',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:10:07',NULL,'2025-11-23 10:10:07',NULL,NULL),(1131,NULL,NULL,'eb1418dec280476dbc8de1ae47fc57c5',NULL,NULL,NULL,NULL,'2025-11-23 10:10:13',NULL,'2025-11-23 10:10:13',NULL,NULL),(1132,NULL,NULL,'d39b24c8e698447ea4af48841e743886',NULL,NULL,NULL,NULL,'2025-11-23 10:10:18',NULL,'2025-11-23 10:10:18',NULL,NULL),(1133,NULL,NULL,'8cb6e4ac8dc34a54a4ae4ddd60ea1da4',NULL,NULL,NULL,NULL,'2025-11-23 10:10:18',NULL,'2025-11-23 10:10:18',NULL,NULL),(1134,NULL,NULL,'80150bf7874e4ea7a7af5830a8899cd7',NULL,NULL,NULL,NULL,'2025-11-23 10:10:18',NULL,'2025-11-23 10:10:18',NULL,NULL),(1135,NULL,'94c9a1c651404c62a735f3cd63e6dd40',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:10:19',NULL,'2025-11-23 10:10:19',NULL,NULL),(1136,NULL,NULL,'429426b0008449b8940f3a3e344e70e5',NULL,NULL,NULL,NULL,'2025-11-23 10:10:20',NULL,'2025-11-23 10:10:20',NULL,NULL),(1137,NULL,NULL,'fd1cbe19ff784e6d878ef355b6ce44e8',NULL,NULL,NULL,NULL,'2025-11-23 10:10:20',NULL,'2025-11-23 10:10:20',NULL,NULL),(1138,NULL,NULL,'601314364eaf4e72876cac682b181af9',NULL,NULL,NULL,NULL,'2025-11-23 10:10:20',NULL,'2025-11-23 10:10:20',NULL,NULL),(1139,NULL,'35890416db4d44e38dc2170008ed1576',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:10:20',NULL,'2025-11-23 10:10:20',NULL,NULL),(1140,NULL,'eadc6eda268f4643a1ab84175729ee17',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:10:20',NULL,'2025-11-23 10:10:20',NULL,NULL),(1141,NULL,'8cf5e489016d4390b614adb7373fe74a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:10:22',NULL,'2025-11-23 10:10:22',NULL,NULL),(1142,NULL,'293e9880077847c4b6f340b3b9f63520',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:10:23',NULL,'2025-11-23 10:10:23',NULL,NULL),(1143,NULL,'c63638f7e3aa482c8911f8406cf3be5b',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:10:23',NULL,'2025-11-23 10:10:23',NULL,NULL),(1144,NULL,NULL,'db79e9332b254e9dad3d962c0e696995',NULL,NULL,NULL,NULL,'2025-11-23 10:10:26',NULL,'2025-11-23 10:10:26',NULL,NULL),(1145,NULL,NULL,'431e85b9ac9243ad893e304a9b053e57',NULL,NULL,NULL,NULL,'2025-11-23 10:10:27',NULL,'2025-11-23 10:10:27',NULL,NULL),(1146,NULL,NULL,'9f87830295034cf7a6586178d34066fe',NULL,NULL,NULL,NULL,'2025-11-23 10:10:27',NULL,'2025-11-23 10:10:27',NULL,NULL),(1147,NULL,NULL,'80ec16c854dc46e1a39f20f06eb0d2b3',NULL,NULL,NULL,NULL,'2025-11-23 10:10:27',NULL,'2025-11-23 10:10:27',NULL,NULL),(1148,NULL,'456fff4954a74e50a72da9bb2ed1cd5b',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:10:28',NULL,'2025-11-23 10:10:28',NULL,NULL),(1149,NULL,'e6504200a8864ba4addb2c2b16bbdbdd',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:10:29',NULL,'2025-11-23 10:10:29',NULL,NULL),(1150,NULL,'6d76d5bcbec7492ebe08dde2755bfbdb',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:10:30',NULL,'2025-11-23 10:10:30',NULL,NULL),(1151,NULL,NULL,'034ec7eab157482cb0d2a7728a751bbd',NULL,NULL,NULL,NULL,'2025-11-23 10:10:59',NULL,'2025-11-23 10:10:59',NULL,NULL),(1152,NULL,NULL,'8839222900e94621afddf69f01c80f28',NULL,NULL,NULL,NULL,'2025-11-23 10:11:12',NULL,'2025-11-23 10:11:12',NULL,NULL),(1153,NULL,NULL,'a29a1d9ea34448db83552c3feff0658e',NULL,NULL,NULL,NULL,'2025-11-23 10:11:12',NULL,'2025-11-23 10:11:12',NULL,NULL),(1154,NULL,NULL,'12053174a82e45f59210713b40dddb54',NULL,NULL,NULL,NULL,'2025-11-23 10:11:13',NULL,'2025-11-23 10:11:13',NULL,NULL),(1155,NULL,'00b5d8dd3ef84698af3b5d7d8243bc4a',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:11:14',NULL,'2025-11-23 10:11:14',NULL,NULL),(1156,NULL,'ba9f8c7270b8487f899668da38829539',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:11:15',NULL,'2025-11-23 10:11:15',NULL,NULL),(1157,NULL,'7380a21b16c54c28b8907c4cc3ce9099',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:11:17',NULL,'2025-11-23 10:11:17',NULL,NULL),(1158,NULL,NULL,'5bdfcd8c9b8f40b68563405c88c4177f',NULL,NULL,NULL,NULL,'2025-11-23 10:11:17',NULL,'2025-11-23 10:11:17',NULL,NULL),(1159,NULL,NULL,'50f00eb5d5704e6887ad8fba5b45486e',NULL,NULL,NULL,NULL,'2025-11-23 10:11:24',NULL,'2025-11-23 10:11:24',NULL,NULL),(1160,NULL,NULL,'415d89a5efdd4bdcac6169d6f7deee0a',NULL,NULL,NULL,NULL,'2025-11-23 10:11:24',NULL,'2025-11-23 10:11:24',NULL,NULL),(1161,NULL,NULL,'ec75908640374972a937b6fd64c8460d',NULL,NULL,NULL,NULL,'2025-11-23 10:11:24',NULL,'2025-11-23 10:11:24',NULL,NULL),(1162,NULL,NULL,'9a11abd99fd1482fbbf93e757ba40d9c',NULL,NULL,NULL,NULL,'2025-11-23 10:11:25',NULL,'2025-11-23 10:11:25',NULL,NULL),(1163,NULL,NULL,'5480195b805745f69a026a542ca93086',NULL,NULL,NULL,NULL,'2025-11-23 10:11:25',NULL,'2025-11-23 10:11:25',NULL,NULL),(1164,NULL,NULL,'4caca4f9acee4b0f8ec196031b8588c3',NULL,NULL,NULL,NULL,'2025-11-23 10:11:25',NULL,'2025-11-23 10:11:25',NULL,NULL),(1165,NULL,'72ec7f7b28fb4c8b9d1beb5d8f63c293',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:11:25',NULL,'2025-11-23 10:11:25',NULL,NULL),(1166,NULL,NULL,'81f3e2adeb0049869e6cbdbdb4dfedb0',NULL,NULL,NULL,NULL,'2025-11-23 10:11:25',NULL,'2025-11-23 10:11:25',NULL,NULL),(1167,NULL,'8a0f4525173c4cf1a6c76282655e242b',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:11:26',NULL,'2025-11-23 10:11:26',NULL,NULL),(1168,NULL,'66dd6ad5bd7c4f3caa909cbb6a1a4efa',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:11:27',NULL,'2025-11-23 10:11:27',NULL,NULL),(1169,NULL,'98587d3749e24446bc5ce5373db58c56',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:11:29',NULL,'2025-11-23 10:11:29',NULL,NULL),(1170,NULL,'16751a9d58a249b8923de437ca8078f0',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:11:29',NULL,'2025-11-23 10:11:29',NULL,NULL),(1171,NULL,'ad7ad3acd05d4a95a6685c11a14f5ec3',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:11:30',NULL,'2025-11-23 10:11:30',NULL,NULL),(1172,NULL,NULL,'37646e743d014d75a46080701bee7906',NULL,NULL,NULL,NULL,'2025-11-23 10:11:35',NULL,'2025-11-23 10:11:35',NULL,NULL),(1173,NULL,NULL,'7f9bf011b3924301b6bae698d0b7adae',NULL,NULL,NULL,NULL,'2025-11-23 10:11:36',NULL,'2025-11-23 10:11:36',NULL,NULL),(1174,NULL,NULL,'0dcfb841a5ea4273937f578d3f3173f4',NULL,NULL,NULL,NULL,'2025-11-23 10:11:36',NULL,'2025-11-23 10:11:36',NULL,NULL),(1175,NULL,NULL,'36766dd605704e34b2101faec0a2280e',NULL,NULL,NULL,NULL,'2025-11-23 10:11:36',NULL,'2025-11-23 10:11:36',NULL,NULL),(1176,NULL,'34710847126348fbb16aaebbd9fd7614',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:11:37',NULL,'2025-11-23 10:11:37',NULL,NULL),(1177,NULL,'0f3880e03aae45a0b92af3c99233d888',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:11:39',NULL,'2025-11-23 10:11:39',NULL,NULL),(1178,NULL,'99082cc8f2b74c4e83b8e86a204d9387',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:11:39',NULL,'2025-11-23 10:11:39',NULL,NULL),(1179,NULL,NULL,'f2a391d0ea914563adf64d4491b4f24f',NULL,NULL,NULL,NULL,'2025-11-23 10:11:41',NULL,'2025-11-23 10:11:41',NULL,NULL),(1180,NULL,NULL,'50ab66eee3f1469ea079e6c043a50e7d',NULL,NULL,NULL,NULL,'2025-11-23 10:11:46',NULL,'2025-11-23 10:11:46',NULL,NULL),(1181,NULL,NULL,'4b86a7020e264033a101c66a4665dbd8',NULL,NULL,NULL,NULL,'2025-11-23 10:11:48',NULL,'2025-11-23 10:11:48',NULL,NULL),(1182,NULL,NULL,'68b77e4f14b949e6b89b84fdea9ebabf',NULL,NULL,NULL,NULL,'2025-11-23 10:11:48',NULL,'2025-11-23 10:11:48',NULL,NULL),(1183,NULL,NULL,'bc935d32037944cab93c89a98c7907a8',NULL,NULL,NULL,NULL,'2025-11-23 10:11:48',NULL,'2025-11-23 10:11:48',NULL,NULL),(1184,NULL,'9acba62408c641a29c31057224825d92',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:11:50',NULL,'2025-11-23 10:11:50',NULL,NULL),(1185,NULL,'efa45fd0607f431c9c969ad0eb9bf597',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:11:50',NULL,'2025-11-23 10:11:50',NULL,NULL),(1186,NULL,'667a3e9aeb05446bb507af299e05aff3',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:11:51',NULL,'2025-11-23 10:11:51',NULL,NULL),(1187,NULL,NULL,'fd2cfae9d13047ab857ba77c87adb2ed',NULL,NULL,NULL,NULL,'2025-11-23 10:11:55',NULL,'2025-11-23 10:11:55',NULL,NULL),(1188,NULL,'e35eacc49dfa4dcdab7bc1d511e6db78',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:11:56',NULL,'2025-11-23 10:11:56',NULL,NULL),(1189,NULL,NULL,'5fb7d2d67c934e2cbe59c6ad562ff4f3',NULL,NULL,NULL,NULL,'2025-11-23 10:11:59',NULL,'2025-11-23 10:11:59',NULL,NULL),(1190,NULL,NULL,'c38a54e9408c4905854d5e1523b32c37',NULL,NULL,NULL,NULL,'2025-11-23 10:11:59',NULL,'2025-11-23 10:11:59',NULL,NULL),(1191,NULL,NULL,'76ae6879357e4bfeb2d1535ad981a58e',NULL,NULL,NULL,NULL,'2025-11-23 10:12:00',NULL,'2025-11-23 10:12:00',NULL,NULL),(1192,NULL,'190320a05b2f45cf8e579932b75457fd',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:12:01',NULL,'2025-11-23 10:12:01',NULL,NULL),(1193,NULL,'6c9a8ed2a0144ad7bbaedfa8fb2776ca',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:12:01',NULL,'2025-11-23 10:12:01',NULL,NULL),(1194,NULL,'497715697da74b4b916eba903bb153b7',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:12:02',NULL,'2025-11-23 10:12:02',NULL,NULL),(1195,NULL,NULL,'748191418b324c3fb9766965e1ccf648',NULL,NULL,NULL,NULL,'2025-11-23 10:12:05',NULL,'2025-11-23 10:12:05',NULL,NULL),(1196,NULL,'4df21a31ac7e4292b0bbda8819ee47c0',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:12:05',NULL,'2025-11-23 10:12:05',NULL,NULL),(1197,NULL,NULL,'6f76d979417a4e43b33fe404b75500a8',NULL,NULL,NULL,NULL,'2025-11-23 10:12:44',NULL,'2025-11-23 10:12:44',NULL,NULL),(1198,NULL,NULL,'7fb3025f891543888120149b28dc1864',NULL,NULL,NULL,NULL,'2025-11-23 10:12:45',NULL,'2025-11-23 10:12:45',NULL,NULL),(1199,NULL,'89472f96637447cc97b8792018a15a8e',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:12:45',NULL,'2025-11-23 10:12:45',NULL,NULL),(1200,NULL,'1d411df0ca9e478984a523820800a77f',NULL,NULL,NULL,NULL,NULL,'2025-11-23 10:12:45',NULL,'2025-11-23 10:12:45',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('08b151a83a734ce8ac9b25ced346df45','ResellerAdmin','{}','<<null>>',NULL),('0a5ee1d55fc44d64b287d84618dfeea8','admin','{}','<<null>>',NULL),('0e10c21a28674f87ba075f18a025ae23','swiftoperator','{}','<<null>>',NULL),('4c894b8c5ad44f7eb18bf10a636c0f31','heat_stack_user','{}','<<null>>',NULL),('4f0ae7640a844a1fa98e2ff28b49c4fe','member','{}','<<null>>',NULL),('c4632e0261e342218ab47c3a83624fb1','service','{}','<<null>>',NULL),('dea827b09b6b4953a5071e44fd0fce3a','reader','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('0a5ee1d55fc44d64b287d84618dfeea8','IMMU','true'),('4f0ae7640a844a1fa98e2ff28b49c4fe','IMMU','true'),('dea827b09b6b4953a5071e44fd0fce3a','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('2479d751080446d3a0dad8aed1eb395c','cloudformation',1,'{\"description\": \"Heat Cloudformation API service\", \"name\": \"heat-cfn\"}'),('3157f872827342ff91709a13d4151802','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('36ad51a092984a228ca865e257c531ec','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}'),('42dd1e3dc8c145058ca50d161f99839c','alarming',1,'{\"description\": \"Aodh for autoscaling Service\", \"name\": \"aodh\"}'),('4f5e5a5a78e14b52ae0529d9ea30d5a8','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}'),('68767414120d4df7be50465e54178430','orchestration',1,'{\"description\": \"Heat API service\", \"name\": \"heat\"}'),('77a4af2bfcf84c109082174471eadb77','share',1,'{\"description\": \"Manila V1 Service\", \"name\": \"manila\"}'),('7d5b4a9cf49144728c99f2b229b2f61f','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('91b821be947c4015a95f5378afd7a56f','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}'),('9ba32db131824d4caab8b84437c445c0','sharev2',1,'{\"description\": \"Manila V2 Service\", \"name\": \"manilav2\"}'),('d1b0af90338c4a079e9d5ae732e64d04','identity',1,'{\"name\": \"keystone\"}'),('d3494096d3ab484c8e698d229b40aa10','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('d8cf72cd305b4a7fbca25f48f9797d4f','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`inherited` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','7e40ee99e6034be7be796ae12095c154','system','0a5ee1d55fc44d64b287d84618dfeea8',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_expires` (`expires`),
  KEY `ix_token_expires_valid` (`expires`,`valid`),
  KEY `ix_token_user_id` (`user_id`),
  KEY `ix_token_trust_id` (`trust_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`valid` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`impersonation` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
INSERT INTO `trust` (`id`, `trustor_user_id`, `trustee_user_id`, `project_id`, `impersonation`, `deleted_at`, `expires_at`, `remaining_uses`, `extra`, `expires_at_int`, `redelegated_trust_id`, `redelegation_count`) VALUES ('28732446d0f44685b1a58da26da51453','09395728e3e54411a2f9d6159d2a4052','b74d7e380cfb4d7a8949daa77897eac8','83f9b86c0eb94bb5a2da4fb5b3ed2a40',1,'2025-11-23 10:02:42',NULL,NULL,'{\"roles\": [{\"id\": \"3c32bbd4c6154027aee009d05fc29fdc\"}]}',NULL,NULL,0),('580453cfd60f4604b5cb25b532ea7b3d','bd482c36658242d19cd56ae42d340b9a','b74d7e380cfb4d7a8949daa77897eac8','29e8f3e35c7e457593edd2b2126f8e71',0,'2025-11-23 10:02:54',NULL,NULL,'{\"roles\": [{\"id\": \"894f9a958ff54eb9be40358128bc9bfd\"}]}',NULL,NULL,0),('63a794a5f9804c1e8a28f0e0df871103','ab927202fce9439db115cd61ef5c242d','b74d7e380cfb4d7a8949daa77897eac8','b6e9263777754228893818e5cc94b6af',1,'2025-11-23 10:02:51',NULL,NULL,'{\"roles\": [{\"id\": \"d8efa439916c4cf99731184e7d5d3264\"}]}',NULL,NULL,0),('7392fe455f914fa6af9408828dd16be4','fce30a8b66b146d4b7ddf759e2105546','b74d7e380cfb4d7a8949daa77897eac8','2f266827f84b4f93a6e236d74b49c3a5',1,'2025-11-23 10:02:39',NULL,NULL,'{\"roles\": [{\"id\": \"ab0d4671dbf741d78558402250b55fab\"}]}',NULL,NULL,0),('8ad3eb777fef488a93f2016dad73040c','61cf4329ed394ea4abaefea03e9b2e8c','b74d7e380cfb4d7a8949daa77897eac8','19c23a78063e454493cbfbdcb39e66f2',1,'2025-11-23 10:02:45','2025-11-23 11:02:44',NULL,'{\"roles\": [{\"id\": \"4552c0d3f42f4031a177146b2a29b3c7\"}]}',1763895764000000,NULL,0);
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
INSERT INTO `trust_role` (`trust_id`, `role_id`) VALUES ('28732446d0f44685b1a58da26da51453','3c32bbd4c6154027aee009d05fc29fdc'),('580453cfd60f4604b5cb25b532ea7b3d','894f9a958ff54eb9be40358128bc9bfd'),('63a794a5f9804c1e8a28f0e0df871103','d8efa439916c4cf99731184e7d5d3264'),('7392fe455f914fa6af9408828dd16be4','ab0d4671dbf741d78558402250b55fab'),('8ad3eb777fef488a93f2016dad73040c','4552c0d3f42f4031a177146b2a29b3c7');
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `domain_id` (`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('0d60ddb8acff47408057d9cda84b946d','{\"email\": \"placement@localhost\", \"description\": null}',1,NULL,'2025-11-23 08:10:48','2025-11-23','default'),('0eb934af82df4872bcb4ed19077c144e','{\"tenantId\": \"6273d493b1a74c728d21d1e1565370ed\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2025-11-23 09:56:39',NULL,'default'),('0ec240bbf59c4223a12e795fc058daed','{\"email\": \"glance@localhost\", \"description\": null}',1,NULL,'2025-11-23 08:10:36','2025-11-23','default'),('1f11ad52b1994292a95b5c1dafb43f21','{\"email\": \"manila@localhost\", \"description\": null}',1,NULL,'2025-11-23 08:10:38','2025-11-23','default'),('366adcc074604d758db5667d78dc728d','{\"email\": \"heat_stack_domain_admin@localhost\", \"description\": null}',1,NULL,'2025-11-23 08:10:37',NULL,'be69a35f7a5240a99c028aff507f555b'),('41c3607e24e148b1837d367730edaa25','{\"email\": \"heat@localhost\", \"description\": null}',1,NULL,'2025-11-23 08:10:37','2025-11-23','default'),('4ff26e787d5c4a55922ffe05358b6090','{\"email\": \"ceilometer@localhost\", \"description\": null}',1,NULL,'2025-11-23 08:10:35','2025-11-23','default'),('68e9921ed93e4036af7fae0a549ad682','{}',1,'758f3043280349e086a85b86f2668848','2025-11-23 08:43:01','2025-11-23','default'),('73d8249924dd406db12ad13a4ddb31a1','{\"email\": \"nova@localhost\", \"description\": null}',1,NULL,'2025-11-23 08:10:47','2025-11-23','default'),('77ba14987a21452fbe8e9b8c33f4244a','{\"email\": \"swift@localhost\", \"description\": null}',1,NULL,'2025-11-23 08:10:48','2025-11-23','default'),('7e40ee99e6034be7be796ae12095c154','{\"email\": \"admin@localhost\"}',1,NULL,'2025-11-23 08:08:09','2025-11-23','default'),('9b59eac9a22e4693b67cacd929ff2061','{\"email\": \"cinder@localhost\", \"description\": null}',1,NULL,'2025-11-23 08:10:35','2025-11-23','default'),('ac261d4d10e24c3c8655cac22157cd98','{\"tenantId\": \"d8fb5c988e2b4995853c12d0c4c7bb29\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2025-11-23 09:56:39','2025-11-23','default'),('b7661bc5cba943dea266498398ed28cc','{\"email\": \"neutron@localhost\", \"description\": null}',1,NULL,'2025-11-23 08:10:47','2025-11-23','default'),('ce6e02b8138e4cf0aa05613d9b037115','{\"email\": \"gnocchi@localhost\", \"description\": null}',1,NULL,'2025-11-23 08:10:36','2025-11-23','default'),('de54b2540437480f94583eb1f478a08b','{\"email\": \"aodh@localhost\", \"description\": null}',1,NULL,'2025-11-23 08:10:35','2025-11-23','default'),('e3f1c3b3a89c4ec5ba810ca1b8af9459','{\"email\": \"manilav2@localhost\", \"description\": null}',1,NULL,'2025-11-23 08:10:47',NULL,'default'),('e5d8265c899d404aa41bb403c43d1d0c','{\"email\": \"cinderv3@localhost\", \"description\": null}',1,NULL,'2025-11-23 08:10:36',NULL,'default'),('ec2fb0ea977c4070b86cd79c46feb905','{\"email\": \"heat-cfn@localhost\", \"description\": null}',1,NULL,'2025-11-23 08:10:38',NULL,'default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `manila`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `manila` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `manila`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('aebe2a413e13');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `async_operation_data`
--

DROP TABLE IF EXISTS `async_operation_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `async_operation_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `async_operation_data`
--

LOCK TABLES `async_operation_data` WRITE;
/*!40000 ALTER TABLE `async_operation_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `async_operation_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `availability_zones`
--

DROP TABLE IF EXISTS `availability_zones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `availability_zones` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `az_name_uc` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `availability_zones`
--

LOCK TABLES `availability_zones` WRITE;
/*!40000 ALTER TABLE `availability_zones` DISABLE KEYS */;
INSERT INTO `availability_zones` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`) VALUES ('2025-11-23 08:12:21.579279',NULL,NULL,'False','46efeabc-0839-466b-8407-9281a2df398f','nova');
/*!40000 ALTER TABLE `availability_zones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backend_info`
--

DROP TABLE IF EXISTS `backend_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backend_info` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `host` varchar(255) NOT NULL,
  `info_hash` varchar(255) NOT NULL,
  PRIMARY KEY (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backend_info`
--

LOCK TABLES `backend_info` WRITE;
/*!40000 ALTER TABLE `backend_info` DISABLE KEYS */;
INSERT INTO `backend_info` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `host`, `info_hash`) VALUES ('2025-11-23 08:57:02.366356',NULL,NULL,0,'hostgroup@cephfs','e66c0dfc0d422efa26af62f5a81dd60603e2d39a');
/*!40000 ALTER TABLE `backend_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `drivers_private_data`
--

DROP TABLE IF EXISTS `drivers_private_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `drivers_private_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `drivers_private_data`
--

LOCK TABLES `drivers_private_data` WRITE;
/*!40000 ALTER TABLE `drivers_private_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `drivers_private_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(255) DEFAULT NULL,
  `resource_id` varchar(36) DEFAULT NULL,
  `action_id` varchar(10) NOT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
INSERT INTO `messages` (`id`, `project_id`, `request_id`, `resource_type`, `resource_id`, `action_id`, `detail_id`, `message_level`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `expires_at`) VALUES ('302e6387-452b-446f-9d31-8e4d917c0e1e','4e966c3cb7e340c1a76c532825794ed0','req-15b85e48-0260-4653-8b8f-74d40db7d139','SHARE','f9b11a31-710a-444a-9288-0746216689b7','001','008','ERROR','2025-11-23 10:06:47.627488',NULL,NULL,'False','2025-12-23 10:06:47'),('41d28099-3b35-4294-970f-2024acbb05e6','4e966c3cb7e340c1a76c532825794ed0','req-d59982b5-86d3-4316-8db5-a10086f1c974','SHARE','18fa13ac-96b3-4f26-8f83-b174da3baf61','001','008','ERROR','2025-11-23 10:06:50.994346',NULL,NULL,'False','2025-12-23 10:06:50'),('4870bf2a-1dbc-45a8-9def-3fca526601ce','4e966c3cb7e340c1a76c532825794ed0','req-09394bfb-9609-4164-a67f-7da01b5fe1f9','SHARE','ff407db7-7655-48cf-b593-b04e79f4899e','001','008','ERROR','2025-11-23 10:07:18.753638',NULL,'2025-11-23 10:07:24.882933','4870bf2a-1dbc-45a8-9def-3fca526601ce','2025-12-23 10:07:18'),('4cb90033-7f88-4136-b54a-bdbb5d651143','4e966c3cb7e340c1a76c532825794ed0','req-9c8d9ec3-7fe3-4557-8d64-84d25f3d298c','SHARE','0adcf35f-de14-498e-9d75-9efd8f1bb4f3','001','008','ERROR','2025-11-23 10:06:44.068223',NULL,NULL,'False','2025-12-23 10:06:44'),('5968b091-3f4a-4c80-a175-5beead23288c','eacae18cedc64027b1aed993d12bae03','req-fe4b0b3b-22ff-4da5-88db-b45d208cb5f1','SHARE','e0f86e17-2c01-4b66-bf71-61b4c9eb61c8','001','008','ERROR','2025-11-23 10:07:40.100621',NULL,NULL,'False','2025-12-23 10:07:40'),('707ab51f-8613-4f8b-8ec4-4ba064a95bc4','eacae18cedc64027b1aed993d12bae03','req-1c435fd8-64b9-49fa-aed3-8948d6dded5e','SHARE','f85a51f4-451d-4c8d-97e0-744e2cf615e6','001','008','ERROR','2025-11-23 10:07:53.437095',NULL,NULL,'False','2025-12-23 10:07:53'),('7206de9e-1161-481e-9725-d0a37c7581f4','4e966c3cb7e340c1a76c532825794ed0','req-4a9c5f60-684f-4938-9b8e-f04cf652f261','SHARE','df5dd5b8-b2d6-44b4-b0cd-13c4e026c687','001','008','ERROR','2025-11-23 10:07:04.121320',NULL,NULL,'False','2025-12-23 10:07:04'),('75eff443-4b9c-41d3-8a26-e14bd3de4c10','eacae18cedc64027b1aed993d12bae03','req-041bfb9a-9383-49ae-87f0-b41af7712da3','SHARE','71e66ed7-01f8-46ad-acb4-79ceb0dbc4c4','001','008','ERROR','2025-11-23 10:07:36.346241',NULL,NULL,'False','2025-12-23 10:07:36'),('8f80b940-056c-47ab-aebd-1be7c8580bb3','4e966c3cb7e340c1a76c532825794ed0','req-1f8a627b-b95d-4d9e-981d-405b6f87550e','SHARE','b24502f3-e77e-4b5b-ab47-1b67ffa966a7','001','008','ERROR','2025-11-23 10:07:11.434938',NULL,NULL,'False','2025-12-23 10:07:11'),('9f1b53c4-57d1-4356-8e3d-f9c70cf394ac','eacae18cedc64027b1aed993d12bae03','req-3acc4c1a-dd89-407b-960c-9f639e4a22c9','SHARE','da4c83f9-d4da-4213-b2a1-5265ac8dcac6','001','008','ERROR','2025-11-23 10:07:32.390323',NULL,NULL,'False','2025-12-23 10:07:32'),('a548a3e6-962c-49a3-87ed-0f95eca0231c','4e966c3cb7e340c1a76c532825794ed0','req-b7eeb57d-fa66-42bd-9962-3228e70e087b','SHARE','2d849aca-a56f-460c-b18a-16798c5416fb','001','008','ERROR','2025-11-23 10:07:07.413215',NULL,NULL,'False','2025-12-23 10:07:07'),('aafb456a-0fc0-403a-a2e7-c62369476ab1','4e966c3cb7e340c1a76c532825794ed0','req-06aa6d12-3a39-4b4e-8903-2470464673ec','SHARE','206d3adb-9e1e-4640-9d2f-00728a9bf2bd','001','008','ERROR','2025-11-23 10:07:14.707462',NULL,NULL,'False','2025-12-23 10:07:14'),('abfde927-32f5-4470-a289-800b9d272016','00b5d8dd3ef84698af3b5d7d8243bc4a','req-31b57aaf-55ea-4242-87e2-7e055c1ef281','SHARE','bc262166-9a2e-4da0-8ff6-74c07c222e56','010','020','ERROR','2025-11-23 10:10:38.936891',NULL,NULL,'False','2025-12-23 10:10:38'),('af66c675-798b-4a3e-9ec3-ac5579ea05d5','eacae18cedc64027b1aed993d12bae03','req-1946ee8b-7327-4aed-8b36-b427a16d5d9c','SHARE','14ee146b-1856-42fb-8237-d4a35d0f5459','001','008','ERROR','2025-11-23 10:07:46.727539',NULL,NULL,'False','2025-12-23 10:07:46'),('b4e93667-5b77-4ae3-92a2-329d761adfc9','4e966c3cb7e340c1a76c532825794ed0','req-dc51c497-14c3-481f-98c9-f11ddcd01381','SHARE','fc69c747-b667-43c4-84f0-4c0ced5a944d','001','008','ERROR','2025-11-23 10:06:57.775229',NULL,NULL,'False','2025-12-23 10:06:57'),('e00a04b2-4300-40f5-9f82-509cfc284ba1','4e966c3cb7e340c1a76c532825794ed0','req-45cb7c35-0cc9-4edb-900a-9f9ef0aa1e3f','SHARE','111a9f8f-37fc-400f-a192-4e4a975b92e3','001','008','ERROR','2025-11-23 10:06:37.325248',NULL,'2025-11-23 10:06:43.464587','e00a04b2-4300-40f5-9f82-509cfc284ba1','2025-12-23 10:06:37');
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `network_allocations`
--

DROP TABLE IF EXISTS `network_allocations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `network_allocations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ip_address` varchar(64) DEFAULT NULL,
  `mac_address` varchar(32) DEFAULT NULL,
  `share_server_id` varchar(36) NOT NULL,
  `label` varchar(255) DEFAULT 'user',
  `network_type` varchar(32) DEFAULT NULL,
  `segmentation_id` int(11) DEFAULT NULL,
  `ip_version` int(11) DEFAULT NULL,
  `cidr` varchar(64) DEFAULT NULL,
  `gateway` varchar(64) DEFAULT NULL,
  `mtu` int(11) DEFAULT NULL,
  `share_network_subnet_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_server_id` (`share_server_id`),
  KEY `fk_network_allocation_subnet_id_share_network_subnets` (`share_network_subnet_id`),
  CONSTRAINT `fk_network_allocation_subnet_id_share_network_subnets` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`),
  CONSTRAINT `network_allocations_ibfk_1` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `network_allocations`
--

LOCK TABLES `network_allocations` WRITE;
/*!40000 ALTER TABLE `network_allocations` DISABLE KEYS */;
/*!40000 ALTER TABLE `network_allocations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_share_type_quotas`
--

DROP TABLE IF EXISTS `project_share_type_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_share_type_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uc_quotas_per_share_types` (`share_type_id`,`resource`,`deleted`,`project_id`),
  CONSTRAINT `share_type_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_share_type_quotas`
--

LOCK TABLES `project_share_type_quotas` WRITE;
/*!40000 ALTER TABLE `project_share_type_quotas` DISABLE KEYS */;
INSERT INTO `project_share_type_quotas` (`id`, `project_id`, `resource`, `hard_limit`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `share_type_id`) VALUES (1,'639b50f98a2a45ed93803ee22072bc7a','shares',2,'2025-11-23 10:05:50.184104',NULL,'2025-11-23 10:06:11.602846',1,'99151306-b5f7-456e-9654-b87f7fce3c14'),(2,'639b50f98a2a45ed93803ee22072bc7a','gigabytes',4,'2025-11-23 10:05:50.189433',NULL,'2025-11-23 10:06:11.602846',2,'99151306-b5f7-456e-9654-b87f7fce3c14'),(3,'639b50f98a2a45ed93803ee22072bc7a','shares',2,'2025-11-23 10:05:50.275781',NULL,'2025-11-23 10:06:11.555976',3,'d5d2e2e3-4017-48ae-844f-f8d420bd9060'),(4,'639b50f98a2a45ed93803ee22072bc7a','gigabytes',4,'2025-11-23 10:05:50.282313',NULL,'2025-11-23 10:06:11.555976',4,'d5d2e2e3-4017-48ae-844f-f8d420bd9060'),(5,'639b50f98a2a45ed93803ee22072bc7a','shares',53,'2025-11-23 10:06:04.263427',NULL,'2025-11-23 10:06:04.347031',5,'dfdfe696-9fba-4282-a912-3088c450774e'),(6,'639b50f98a2a45ed93803ee22072bc7a','snapshots',53,'2025-11-23 10:06:04.277280',NULL,'2025-11-23 10:06:04.347031',6,'dfdfe696-9fba-4282-a912-3088c450774e'),(7,'639b50f98a2a45ed93803ee22072bc7a','gigabytes',1003,'2025-11-23 10:06:04.284830',NULL,'2025-11-23 10:06:04.347031',7,'dfdfe696-9fba-4282-a912-3088c450774e'),(8,'639b50f98a2a45ed93803ee22072bc7a','snapshot_gigabytes',1003,'2025-11-23 10:06:04.294697',NULL,'2025-11-23 10:06:04.347031',8,'dfdfe696-9fba-4282-a912-3088c450774e'),(9,'639b50f98a2a45ed93803ee22072bc7a','share_replicas',103,'2025-11-23 10:06:04.302014',NULL,'2025-11-23 10:06:04.347031',9,'dfdfe696-9fba-4282-a912-3088c450774e'),(10,'639b50f98a2a45ed93803ee22072bc7a','replica_gigabytes',1003,'2025-11-23 10:06:04.310187',NULL,'2025-11-23 10:06:04.347031',10,'dfdfe696-9fba-4282-a912-3088c450774e'),(11,'639b50f98a2a45ed93803ee22072bc7a','shares',53,'2025-11-23 10:06:04.797339',NULL,'2025-11-23 10:06:04.906529',11,'87a2e753-5332-4cac-8feb-64c63dbcb2e3'),(12,'639b50f98a2a45ed93803ee22072bc7a','snapshots',53,'2025-11-23 10:06:04.834792',NULL,'2025-11-23 10:06:04.906529',12,'87a2e753-5332-4cac-8feb-64c63dbcb2e3'),(13,'639b50f98a2a45ed93803ee22072bc7a','gigabytes',1003,'2025-11-23 10:06:04.849106',NULL,'2025-11-23 10:06:04.906529',13,'87a2e753-5332-4cac-8feb-64c63dbcb2e3'),(14,'639b50f98a2a45ed93803ee22072bc7a','snapshot_gigabytes',1003,'2025-11-23 10:06:04.855301',NULL,'2025-11-23 10:06:04.906529',14,'87a2e753-5332-4cac-8feb-64c63dbcb2e3'),(15,'639b50f98a2a45ed93803ee22072bc7a','share_replicas',103,'2025-11-23 10:06:04.861744',NULL,'2025-11-23 10:06:04.906529',15,'87a2e753-5332-4cac-8feb-64c63dbcb2e3'),(16,'639b50f98a2a45ed93803ee22072bc7a','replica_gigabytes',1003,'2025-11-23 10:06:04.865872',NULL,'2025-11-23 10:06:04.906529',16,'87a2e753-5332-4cac-8feb-64c63dbcb2e3'),(17,'639b50f98a2a45ed93803ee22072bc7a','shares',12,'2025-11-23 10:06:05.472691',NULL,'2025-11-23 10:06:11.354190',17,'4c484f01-5684-42d9-a6e3-314e157222ce'),(18,'639b50f98a2a45ed93803ee22072bc7a','shares',49,'2025-11-23 10:06:07.440616',NULL,'2025-11-23 10:06:11.290567',18,'f5f02994-8424-40a7-8aed-7eba1f60489c'),(19,'639b50f98a2a45ed93803ee22072bc7a','gigabytes',999,'2025-11-23 10:06:07.505190',NULL,'2025-11-23 10:06:11.290567',19,'f5f02994-8424-40a7-8aed-7eba1f60489c'),(20,'639b50f98a2a45ed93803ee22072bc7a','snapshots',49,'2025-11-23 10:06:07.610709',NULL,'2025-11-23 10:06:11.290567',20,'f5f02994-8424-40a7-8aed-7eba1f60489c'),(21,'639b50f98a2a45ed93803ee22072bc7a','snapshot_gigabytes',999,'2025-11-23 10:06:07.705044',NULL,'2025-11-23 10:06:11.290567',21,'f5f02994-8424-40a7-8aed-7eba1f60489c'),(22,'639b50f98a2a45ed93803ee22072bc7a','share_replicas',99,'2025-11-23 10:06:07.854786',NULL,'2025-11-23 10:06:11.290567',22,'f5f02994-8424-40a7-8aed-7eba1f60489c'),(23,'639b50f98a2a45ed93803ee22072bc7a','replica_gigabytes',999,'2025-11-23 10:06:07.947288',NULL,'2025-11-23 10:06:11.290567',23,'f5f02994-8424-40a7-8aed-7eba1f60489c'),(24,'639b50f98a2a45ed93803ee22072bc7a','shares',49,'2025-11-23 10:06:08.106468',NULL,'2025-11-23 10:06:11.223598',24,'dd91537b-fdce-4da2-b5e3-22506682e501'),(25,'639b50f98a2a45ed93803ee22072bc7a','gigabytes',999,'2025-11-23 10:06:08.252432',NULL,'2025-11-23 10:06:11.223598',25,'dd91537b-fdce-4da2-b5e3-22506682e501'),(26,'639b50f98a2a45ed93803ee22072bc7a','snapshots',49,'2025-11-23 10:06:08.426188',NULL,'2025-11-23 10:06:11.223598',26,'dd91537b-fdce-4da2-b5e3-22506682e501'),(27,'639b50f98a2a45ed93803ee22072bc7a','snapshot_gigabytes',999,'2025-11-23 10:06:08.538696',NULL,'2025-11-23 10:06:11.223598',27,'dd91537b-fdce-4da2-b5e3-22506682e501'),(28,'639b50f98a2a45ed93803ee22072bc7a','share_replicas',99,'2025-11-23 10:06:08.614239',NULL,'2025-11-23 10:06:11.223598',28,'dd91537b-fdce-4da2-b5e3-22506682e501'),(29,'639b50f98a2a45ed93803ee22072bc7a','replica_gigabytes',999,'2025-11-23 10:06:08.699075',NULL,'2025-11-23 10:06:11.223598',29,'dd91537b-fdce-4da2-b5e3-22506682e501'),(30,'639b50f98a2a45ed93803ee22072bc7a','shares',11,'2025-11-23 10:06:08.857100',NULL,'2025-11-23 10:06:11.159228',30,'57ae65a4-24b8-49ad-bc23-4e5daf1179ba'),(31,'639b50f98a2a45ed93803ee22072bc7a','shares',-1,'2025-11-23 10:06:09.058443',NULL,'2025-11-23 10:06:11.095931',31,'159b9dc4-9236-461a-a3ee-cf234362ea53');
/*!40000 ALTER TABLE `project_share_type_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_user_quotas`
--

DROP TABLE IF EXISTS `project_user_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_user_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `resource` varchar(25) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_user_quotas`
--

LOCK TABLES `project_user_quotas` WRITE;
/*!40000 ALTER TABLE `project_user_quotas` DISABLE KEYS */;
INSERT INTO `project_user_quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `user_id`, `project_id`, `resource`, `hard_limit`) VALUES (1,'2025-11-23 10:05:50.111243',NULL,'2025-11-23 10:06:04.001123',1,'90c18b36e7c142a2ba912fda344bf32a','639b50f98a2a45ed93803ee22072bc7a','shares',2),(2,'2025-11-23 10:05:50.117710',NULL,'2025-11-23 10:06:04.001123',2,'90c18b36e7c142a2ba912fda344bf32a','639b50f98a2a45ed93803ee22072bc7a','gigabytes',7),(3,'2025-11-23 10:06:05.370805',NULL,'2025-11-23 10:06:05.499321',3,'90c18b36e7c142a2ba912fda344bf32a','639b50f98a2a45ed93803ee22072bc7a','shares',11),(4,'2025-11-23 10:06:06.359215',NULL,'2025-11-23 10:06:06.416437',4,'90c18b36e7c142a2ba912fda344bf32a','639b50f98a2a45ed93803ee22072bc7a','gigabytes',-1),(5,'2025-11-23 10:06:06.486317',NULL,'2025-11-23 10:06:06.541543',5,'90c18b36e7c142a2ba912fda344bf32a','639b50f98a2a45ed93803ee22072bc7a','share_replicas',-1),(6,'2025-11-23 10:06:06.597077',NULL,'2025-11-23 10:06:06.638912',6,'90c18b36e7c142a2ba912fda344bf32a','639b50f98a2a45ed93803ee22072bc7a','replica_gigabytes',-1),(7,'2025-11-23 10:06:06.719677',NULL,'2025-11-23 10:06:06.776728',7,'90c18b36e7c142a2ba912fda344bf32a','639b50f98a2a45ed93803ee22072bc7a','share_networks',-1),(8,'2025-11-23 10:06:06.896150',NULL,'2025-11-23 10:06:06.961521',8,'90c18b36e7c142a2ba912fda344bf32a','639b50f98a2a45ed93803ee22072bc7a','shares',-1),(9,'2025-11-23 10:06:07.048968',NULL,'2025-11-23 10:06:07.120395',9,'90c18b36e7c142a2ba912fda344bf32a','639b50f98a2a45ed93803ee22072bc7a','snapshot_gigabytes',-1),(10,'2025-11-23 10:06:07.187358',NULL,'2025-11-23 10:06:07.250226',10,'90c18b36e7c142a2ba912fda344bf32a','639b50f98a2a45ed93803ee22072bc7a','snapshots',-1),(11,'2025-11-23 10:06:09.743727',NULL,'2025-11-23 10:06:09.764351',11,'90c18b36e7c142a2ba912fda344bf32a','639b50f98a2a45ed93803ee22072bc7a','gigabytes',999),(12,'2025-11-23 10:06:09.976371',NULL,'2025-11-23 10:06:09.996301',12,'90c18b36e7c142a2ba912fda344bf32a','639b50f98a2a45ed93803ee22072bc7a','share_replicas',99),(13,'2025-11-23 10:06:10.187022',NULL,'2025-11-23 10:06:10.208398',13,'90c18b36e7c142a2ba912fda344bf32a','639b50f98a2a45ed93803ee22072bc7a','replica_gigabytes',999),(14,'2025-11-23 10:06:10.282647',NULL,'2025-11-23 10:06:10.307652',14,'90c18b36e7c142a2ba912fda344bf32a','639b50f98a2a45ed93803ee22072bc7a','share_networks',9),(15,'2025-11-23 10:06:10.439399',NULL,'2025-11-23 10:06:10.466070',15,'90c18b36e7c142a2ba912fda344bf32a','639b50f98a2a45ed93803ee22072bc7a','shares',49),(16,'2025-11-23 10:06:10.550124',NULL,'2025-11-23 10:06:10.576195',16,'90c18b36e7c142a2ba912fda344bf32a','639b50f98a2a45ed93803ee22072bc7a','snapshot_gigabytes',999),(17,'2025-11-23 10:06:10.666034',NULL,'2025-11-23 10:06:10.689989',17,'90c18b36e7c142a2ba912fda344bf32a','639b50f98a2a45ed93803ee22072bc7a','snapshots',49),(18,'2025-11-23 10:06:10.797829',NULL,'2025-11-23 10:06:10.825451',18,'90c18b36e7c142a2ba912fda344bf32a','639b50f98a2a45ed93803ee22072bc7a','shares',11),(19,'2025-11-23 10:06:10.979248',NULL,'2025-11-23 10:06:11.007849',19,'90c18b36e7c142a2ba912fda344bf32a','639b50f98a2a45ed93803ee22072bc7a','shares',-1);
/*!40000 ALTER TABLE `project_user_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_usages_project_id` (`project_id`)
) ENGINE=InnoDB AUTO_INCREMENT=270 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `share_type_id`) VALUES ('2025-11-23 10:03:30.730315','2025-11-23 10:03:40.644648',NULL,0,1,'fc4f58dd5944497da3bc37fa9db2fe67','a7811370065740c5abbbccf576edad7c','gigabytes',0,0,NULL,NULL),('2025-11-23 10:03:30.734331','2025-11-23 10:03:40.644651',NULL,0,2,'fc4f58dd5944497da3bc37fa9db2fe67','a7811370065740c5abbbccf576edad7c','shares',0,0,NULL,NULL),('2025-11-23 10:03:30.755011','2025-11-23 10:03:40.644652','2025-11-23 10:03:43.417993',3,3,NULL,'a7811370065740c5abbbccf576edad7c','gigabytes',0,0,NULL,'7b04a7f7-d28d-4e9a-a2c9-2f71d803e355'),('2025-11-23 10:03:30.757959','2025-11-23 10:03:40.644653','2025-11-23 10:03:43.417993',4,4,NULL,'a7811370065740c5abbbccf576edad7c','shares',0,0,NULL,'7b04a7f7-d28d-4e9a-a2c9-2f71d803e355'),('2025-11-23 10:03:32.236577','2025-11-23 10:03:37.221677',NULL,0,5,'fc4f58dd5944497da3bc37fa9db2fe67','a7811370065740c5abbbccf576edad7c','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-23 10:03:32.248875','2025-11-23 10:03:37.221680',NULL,0,6,'fc4f58dd5944497da3bc37fa9db2fe67','a7811370065740c5abbbccf576edad7c','snapshots',0,0,NULL,NULL),('2025-11-23 10:03:32.269795','2025-11-23 10:03:37.221681','2025-11-23 10:03:43.417993',7,7,NULL,'a7811370065740c5abbbccf576edad7c','snapshot_gigabytes',0,0,NULL,'7b04a7f7-d28d-4e9a-a2c9-2f71d803e355'),('2025-11-23 10:03:32.274550','2025-11-23 10:03:37.221683','2025-11-23 10:03:43.417993',8,8,NULL,'a7811370065740c5abbbccf576edad7c','snapshots',0,0,NULL,'7b04a7f7-d28d-4e9a-a2c9-2f71d803e355'),('2025-11-23 10:04:21.290181','2025-11-23 10:05:27.245468',NULL,0,9,'90cea60d49c344f1a49f93c6695603ba','51d0d3cbee924cf1ab4c449b1d345d19','gigabytes',0,0,NULL,NULL),('2025-11-23 10:04:21.294080','2025-11-23 10:05:27.245471',NULL,0,10,'90cea60d49c344f1a49f93c6695603ba','51d0d3cbee924cf1ab4c449b1d345d19','shares',0,0,NULL,NULL),('2025-11-23 10:04:21.311560','2025-11-23 10:05:27.245473','2025-11-23 10:05:29.963119',11,11,NULL,'51d0d3cbee924cf1ab4c449b1d345d19','gigabytes',0,0,NULL,'74d04172-2c32-4af1-97e0-85082bfd6aa2'),('2025-11-23 10:04:21.317204','2025-11-23 10:05:27.245474','2025-11-23 10:05:29.963119',12,12,NULL,'51d0d3cbee924cf1ab4c449b1d345d19','shares',0,0,NULL,'74d04172-2c32-4af1-97e0-85082bfd6aa2'),('2025-11-23 10:04:24.783896','2025-11-23 10:05:23.967398',NULL,0,13,'90cea60d49c344f1a49f93c6695603ba','51d0d3cbee924cf1ab4c449b1d345d19','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-23 10:04:24.789809','2025-11-23 10:05:23.967401',NULL,0,14,'90cea60d49c344f1a49f93c6695603ba','51d0d3cbee924cf1ab4c449b1d345d19','snapshots',0,0,NULL,NULL),('2025-11-23 10:04:24.820255','2025-11-23 10:05:23.967402','2025-11-23 10:05:29.963119',15,15,NULL,'51d0d3cbee924cf1ab4c449b1d345d19','snapshot_gigabytes',0,0,NULL,'74d04172-2c32-4af1-97e0-85082bfd6aa2'),('2025-11-23 10:04:24.823370','2025-11-23 10:05:23.967404','2025-11-23 10:05:29.963119',16,16,NULL,'51d0d3cbee924cf1ab4c449b1d345d19','snapshots',0,0,NULL,'74d04172-2c32-4af1-97e0-85082bfd6aa2'),('2025-11-23 10:04:36.850176','2025-11-23 10:05:58.411406',NULL,0,17,'cd47d55f3345423888e76431c4ceb067','980c7c21c34748d78f83541fa493dd05','gigabytes',0,0,NULL,NULL),('2025-11-23 10:04:36.853657','2025-11-23 10:05:58.411408',NULL,0,18,'cd47d55f3345423888e76431c4ceb067','980c7c21c34748d78f83541fa493dd05','shares',0,0,NULL,NULL),('2025-11-23 10:04:36.865095','2025-11-23 10:05:58.411410','2025-11-23 10:06:01.242202',19,19,NULL,'980c7c21c34748d78f83541fa493dd05','gigabytes',0,0,NULL,'43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:04:36.868027','2025-11-23 10:05:58.411411','2025-11-23 10:06:01.242202',20,20,NULL,'980c7c21c34748d78f83541fa493dd05','shares',0,0,NULL,'43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:04:52.392595','2025-11-23 10:04:58.814234',NULL,0,21,'99c9da5d2d9848b190ec8ece75c0a8aa','1be2483fd52a488b9ba1f871a3ed13aa','gigabytes',0,0,NULL,NULL),('2025-11-23 10:04:52.396231','2025-11-23 10:04:58.814237',NULL,0,22,'99c9da5d2d9848b190ec8ece75c0a8aa','1be2483fd52a488b9ba1f871a3ed13aa','shares',0,0,NULL,NULL),('2025-11-23 10:04:52.407096','2025-11-23 10:04:58.814239','2025-11-23 10:05:01.658109',23,23,NULL,'1be2483fd52a488b9ba1f871a3ed13aa','gigabytes',0,0,NULL,'bbea3883-863d-4202-99f2-f7cd0fa2f205'),('2025-11-23 10:04:52.409206','2025-11-23 10:04:58.814241','2025-11-23 10:05:01.658109',24,24,NULL,'1be2483fd52a488b9ba1f871a3ed13aa','shares',0,0,NULL,'bbea3883-863d-4202-99f2-f7cd0fa2f205'),('2025-11-23 10:05:13.903189','2025-11-23 10:05:55.227302',NULL,0,25,'cd47d55f3345423888e76431c4ceb067','980c7c21c34748d78f83541fa493dd05','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-23 10:05:13.909028','2025-11-23 10:05:55.227306',NULL,0,26,'cd47d55f3345423888e76431c4ceb067','980c7c21c34748d78f83541fa493dd05','snapshots',0,0,NULL,NULL),('2025-11-23 10:05:13.952102','2025-11-23 10:05:55.227308','2025-11-23 10:06:01.242202',27,27,NULL,'980c7c21c34748d78f83541fa493dd05','snapshot_gigabytes',0,0,NULL,'43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:13.955205','2025-11-23 10:05:55.227310','2025-11-23 10:06:01.242202',28,28,NULL,'980c7c21c34748d78f83541fa493dd05','snapshots',0,0,NULL,'43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:24.406221','2025-11-23 10:05:25.898515',NULL,0,29,'3c75003597274dc4827eada967672238','7ffe6bcd62184dda84133a0cc0a4e224','share_networks',0,0,NULL,NULL),('2025-11-23 10:05:32.703321','2025-11-23 10:06:28.378194',NULL,0,30,'b0ef51fd6dbc4bd890a74e7dba8b099d','3aaf8109aeae4e8a9d20b032d4f40021','gigabytes',0,0,NULL,NULL),('2025-11-23 10:05:32.706580','2025-11-23 10:06:28.378197',NULL,0,31,'b0ef51fd6dbc4bd890a74e7dba8b099d','3aaf8109aeae4e8a9d20b032d4f40021','shares',0,0,NULL,NULL),('2025-11-23 10:05:32.714888','2025-11-23 10:05:43.258001','2025-11-23 10:05:46.074180',32,32,NULL,'3aaf8109aeae4e8a9d20b032d4f40021','gigabytes',0,0,NULL,'2fc5dfcd-9e0c-4d96-b681-9b6f96aa16fe'),('2025-11-23 10:05:32.718044','2025-11-23 10:05:43.258002','2025-11-23 10:05:46.074180',33,33,NULL,'3aaf8109aeae4e8a9d20b032d4f40021','shares',0,0,NULL,'2fc5dfcd-9e0c-4d96-b681-9b6f96aa16fe'),('2025-11-23 10:05:36.009377','2025-11-23 10:06:25.081289',NULL,0,34,'b0ef51fd6dbc4bd890a74e7dba8b099d','3aaf8109aeae4e8a9d20b032d4f40021','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-23 10:05:36.013209','2025-11-23 10:06:25.081292',NULL,0,35,'b0ef51fd6dbc4bd890a74e7dba8b099d','3aaf8109aeae4e8a9d20b032d4f40021','snapshots',0,0,NULL,NULL),('2025-11-23 10:05:36.024080','2025-11-23 10:05:39.768811','2025-11-23 10:05:46.074180',36,36,NULL,'3aaf8109aeae4e8a9d20b032d4f40021','snapshot_gigabytes',0,0,NULL,'2fc5dfcd-9e0c-4d96-b681-9b6f96aa16fe'),('2025-11-23 10:05:36.027013','2025-11-23 10:05:39.768812','2025-11-23 10:05:46.074180',37,37,NULL,'3aaf8109aeae4e8a9d20b032d4f40021','snapshots',0,0,NULL,'2fc5dfcd-9e0c-4d96-b681-9b6f96aa16fe'),('2025-11-23 10:05:40.599540','2025-11-23 10:06:04.221202',NULL,0,38,'6b2d4ce74f314f569d20a814d7857aea','0dcc58766ad44287910595c5c8f14397','gigabytes',0,0,NULL,NULL),('2025-11-23 10:05:40.602306','2025-11-23 10:06:04.221205',NULL,0,39,'6b2d4ce74f314f569d20a814d7857aea','0dcc58766ad44287910595c5c8f14397','shares',0,0,NULL,NULL),('2025-11-23 10:05:40.610014','2025-11-23 10:06:04.221206','2025-11-23 10:06:05.414110',40,40,NULL,'0dcc58766ad44287910595c5c8f14397','gigabytes',0,0,NULL,'8ac24231-78d9-4538-8f95-8763239b9d36'),('2025-11-23 10:05:40.611763','2025-11-23 10:06:04.221208','2025-11-23 10:06:05.414110',41,41,NULL,'0dcc58766ad44287910595c5c8f14397','shares',0,0,NULL,'8ac24231-78d9-4538-8f95-8763239b9d36'),('2025-11-23 10:05:46.174224','2025-11-23 10:05:50.123270','2025-11-23 10:06:31.538437',42,42,NULL,'3aaf8109aeae4e8a9d20b032d4f40021','gigabytes',0,0,NULL,'b4fe0825-4171-413a-a33a-2032d7a30416'),('2025-11-23 10:05:46.176933','2025-11-23 10:05:50.123271','2025-11-23 10:06:31.538437',43,43,NULL,'3aaf8109aeae4e8a9d20b032d4f40021','shares',0,0,NULL,'b4fe0825-4171-413a-a33a-2032d7a30416'),('2025-11-23 10:05:50.361551','2025-11-23 10:06:03.582431','2025-11-23 10:06:04.004120',44,44,'90c18b36e7c142a2ba912fda344bf32a','639b50f98a2a45ed93803ee22072bc7a','gigabytes',0,0,NULL,NULL),('2025-11-23 10:05:50.363583','2025-11-23 10:06:03.582434','2025-11-23 10:06:04.004120',45,45,'90c18b36e7c142a2ba912fda344bf32a','639b50f98a2a45ed93803ee22072bc7a','shares',0,0,NULL,NULL),('2025-11-23 10:05:50.373746','2025-11-23 10:05:57.755397','2025-11-23 10:06:04.028524',46,46,NULL,'639b50f98a2a45ed93803ee22072bc7a','gigabytes',0,0,NULL,'99151306-b5f7-456e-9654-b87f7fce3c14'),('2025-11-23 10:05:50.376177','2025-11-23 10:05:57.755398','2025-11-23 10:06:04.028524',47,47,NULL,'639b50f98a2a45ed93803ee22072bc7a','shares',0,0,NULL,'99151306-b5f7-456e-9654-b87f7fce3c14'),('2025-11-23 10:05:52.997380','2025-11-23 10:06:28.378198','2025-11-23 10:06:31.188177',48,48,NULL,'3aaf8109aeae4e8a9d20b032d4f40021','gigabytes',0,0,NULL,'bdc5dc05-5cbf-414e-ad7e-a3fb7edf1118'),('2025-11-23 10:05:53.000357','2025-11-23 10:06:28.378199','2025-11-23 10:06:31.188177',49,49,NULL,'3aaf8109aeae4e8a9d20b032d4f40021','shares',0,0,NULL,'bdc5dc05-5cbf-414e-ad7e-a3fb7edf1118'),('2025-11-23 10:05:53.951834','2025-11-23 10:06:03.582435','2025-11-23 10:06:04.028524',50,50,NULL,'639b50f98a2a45ed93803ee22072bc7a','gigabytes',0,0,NULL,'d5d2e2e3-4017-48ae-844f-f8d420bd9060'),('2025-11-23 10:05:53.955207','2025-11-23 10:06:03.582436','2025-11-23 10:06:04.028524',51,51,NULL,'639b50f98a2a45ed93803ee22072bc7a','shares',0,0,NULL,'d5d2e2e3-4017-48ae-844f-f8d420bd9060'),('2025-11-23 10:05:56.323393','2025-11-23 10:06:25.081293','2025-11-23 10:06:31.188177',52,52,NULL,'3aaf8109aeae4e8a9d20b032d4f40021','snapshot_gigabytes',0,0,NULL,'bdc5dc05-5cbf-414e-ad7e-a3fb7edf1118'),('2025-11-23 10:05:56.326212','2025-11-23 10:06:25.081295','2025-11-23 10:06:31.188177',53,53,NULL,'3aaf8109aeae4e8a9d20b032d4f40021','snapshots',0,0,NULL,'bdc5dc05-5cbf-414e-ad7e-a3fb7edf1118'),('2025-11-23 10:06:08.833057','2025-11-23 10:06:08.912011','2025-11-23 10:06:12.287014',54,54,'b52f5d7e2eea4f249832a9e7892a6435','1dcbf043a91e492e9142e84de0186253','gigabytes',1,0,NULL,NULL),('2025-11-23 10:06:08.837819','2025-11-23 10:06:08.912015','2025-11-23 10:06:12.287014',55,55,'b52f5d7e2eea4f249832a9e7892a6435','1dcbf043a91e492e9142e84de0186253','shares',1,0,NULL,NULL),('2025-11-23 10:06:08.861172','2025-11-23 10:06:08.912017','2025-11-23 10:06:12.287014',56,56,NULL,'1dcbf043a91e492e9142e84de0186253','gigabytes',1,0,NULL,'c02e5473-a628-4496-98f6-ef85824dd58a'),('2025-11-23 10:06:08.863878','2025-11-23 10:06:08.912019','2025-11-23 10:06:12.287014',57,57,NULL,'1dcbf043a91e492e9142e84de0186253','shares',1,0,NULL,'c02e5473-a628-4496-98f6-ef85824dd58a'),('2025-11-23 10:06:12.412880','2025-11-23 10:06:12.576216','2025-11-23 10:06:19.190810',58,58,'b52f5d7e2eea4f249832a9e7892a6435','1dcbf043a91e492e9142e84de0186253','gigabytes',2,0,NULL,NULL),('2025-11-23 10:06:12.421053','2025-11-23 10:06:12.576220','2025-11-23 10:06:19.190810',59,59,'b52f5d7e2eea4f249832a9e7892a6435','1dcbf043a91e492e9142e84de0186253','shares',2,0,NULL,NULL),('2025-11-23 10:06:12.549079','2025-11-23 10:06:12.576223','2025-11-23 10:06:19.190810',60,60,NULL,'1dcbf043a91e492e9142e84de0186253','gigabytes',1,0,NULL,'6ec8be50-2b1f-40e8-98cb-a90fe5c90a25'),('2025-11-23 10:06:12.552130','2025-11-23 10:06:12.576225','2025-11-23 10:06:19.190810',61,61,NULL,'1dcbf043a91e492e9142e84de0186253','shares',1,0,NULL,'6ec8be50-2b1f-40e8-98cb-a90fe5c90a25'),('2025-11-23 10:06:14.475833','2025-11-23 10:06:19.755709',NULL,0,62,'1d5eba52d35642b9bb7f834d5bed165a','ac0f52e853194f9ea9d27590165c645d','gigabytes',0,0,NULL,NULL),('2025-11-23 10:06:14.477770','2025-11-23 10:06:19.755713',NULL,0,63,'1d5eba52d35642b9bb7f834d5bed165a','ac0f52e853194f9ea9d27590165c645d','shares',0,0,NULL,NULL),('2025-11-23 10:06:14.488155','2025-11-23 10:06:19.755715','2025-11-23 10:06:21.739247',64,64,NULL,'ac0f52e853194f9ea9d27590165c645d','gigabytes',0,0,NULL,'bffdc073-9324-4fb8-8e35-0d9c39e790db'),('2025-11-23 10:06:14.490403','2025-11-23 10:06:19.755717','2025-11-23 10:06:21.739247',65,65,NULL,'ac0f52e853194f9ea9d27590165c645d','shares',0,0,NULL,'bffdc073-9324-4fb8-8e35-0d9c39e790db'),('2025-11-23 10:06:15.843320','2025-11-23 10:06:15.941387','2025-11-23 10:06:19.190810',66,66,'b52f5d7e2eea4f249832a9e7892a6435','1dcbf043a91e492e9142e84de0186253','snapshot_gigabytes',1,0,NULL,NULL),('2025-11-23 10:06:15.845529','2025-11-23 10:06:15.941390','2025-11-23 10:06:19.190810',67,67,'b52f5d7e2eea4f249832a9e7892a6435','1dcbf043a91e492e9142e84de0186253','snapshots',1,0,NULL,NULL),('2025-11-23 10:06:15.855114','2025-11-23 10:06:15.941391','2025-11-23 10:06:19.190810',68,68,NULL,'1dcbf043a91e492e9142e84de0186253','snapshot_gigabytes',1,0,NULL,'6ec8be50-2b1f-40e8-98cb-a90fe5c90a25'),('2025-11-23 10:06:15.857675','2025-11-23 10:06:15.941392','2025-11-23 10:06:19.190810',69,69,NULL,'1dcbf043a91e492e9142e84de0186253','snapshots',1,0,NULL,'6ec8be50-2b1f-40e8-98cb-a90fe5c90a25'),('2025-11-23 10:06:16.317549','2025-11-23 10:06:16.383408',NULL,0,70,'af5de096454d470598ed1cedeed5495a','24a8d397352640bea21b3503164c6be5','share_networks',1,0,NULL,NULL),('2025-11-23 10:06:23.186251','2025-11-23 10:06:23.229884',NULL,0,71,'b52f5d7e2eea4f249832a9e7892a6435','1dcbf043a91e492e9142e84de0186253','snapshot_gigabytes',-1,0,NULL,NULL),('2025-11-23 10:06:23.192417','2025-11-23 10:06:23.229887',NULL,0,72,'b52f5d7e2eea4f249832a9e7892a6435','1dcbf043a91e492e9142e84de0186253','snapshots',-1,0,NULL,NULL),('2025-11-23 10:06:23.210102','2025-11-23 10:06:23.229889','2025-11-23 10:06:29.260525',73,73,NULL,'1dcbf043a91e492e9142e84de0186253','snapshot_gigabytes',-1,0,NULL,'6ec8be50-2b1f-40e8-98cb-a90fe5c90a25'),('2025-11-23 10:06:23.214729','2025-11-23 10:06:23.229890','2025-11-23 10:06:29.260525',74,74,NULL,'1dcbf043a91e492e9142e84de0186253','snapshots',-1,0,NULL,'6ec8be50-2b1f-40e8-98cb-a90fe5c90a25'),('2025-11-23 10:06:23.979694','2025-11-23 10:06:28.625725',NULL,0,75,'8c440ef1e1a8457ba1df49a924e1ba5f','3d9832e0712f41348ba1825f181d4086','gigabytes',0,0,NULL,NULL),('2025-11-23 10:06:23.982439','2025-11-23 10:06:28.625730',NULL,0,76,'8c440ef1e1a8457ba1df49a924e1ba5f','3d9832e0712f41348ba1825f181d4086','shares',0,0,NULL,NULL),('2025-11-23 10:06:23.996653','2025-11-23 10:06:28.625732','2025-11-23 10:06:31.483131',77,77,NULL,'3d9832e0712f41348ba1825f181d4086','gigabytes',0,0,NULL,'31833ee7-4016-4520-993e-f6c13317cc69'),('2025-11-23 10:06:23.999819','2025-11-23 10:06:28.625733','2025-11-23 10:06:31.483131',78,78,NULL,'3d9832e0712f41348ba1825f181d4086','shares',0,0,NULL,'31833ee7-4016-4520-993e-f6c13317cc69'),('2025-11-23 10:06:26.394107','2025-11-23 10:06:29.746582',NULL,0,79,'b52f5d7e2eea4f249832a9e7892a6435','1dcbf043a91e492e9142e84de0186253','shares',0,0,NULL,NULL),('2025-11-23 10:06:26.397645','2025-11-23 10:06:29.746585',NULL,0,80,'b52f5d7e2eea4f249832a9e7892a6435','1dcbf043a91e492e9142e84de0186253','gigabytes',0,0,NULL,NULL),('2025-11-23 10:06:26.406549','2025-11-23 10:06:26.419340','2025-11-23 10:06:29.260525',81,81,NULL,'1dcbf043a91e492e9142e84de0186253','shares',0,0,NULL,'6ec8be50-2b1f-40e8-98cb-a90fe5c90a25'),('2025-11-23 10:06:26.409466','2025-11-23 10:06:26.419342','2025-11-23 10:06:29.260525',82,82,NULL,'1dcbf043a91e492e9142e84de0186253','gigabytes',0,0,NULL,'6ec8be50-2b1f-40e8-98cb-a90fe5c90a25'),('2025-11-23 10:06:29.733071','2025-11-23 10:06:29.746586','2025-11-23 10:06:32.743078',83,83,NULL,'1dcbf043a91e492e9142e84de0186253','shares',0,0,NULL,'c02e5473-a628-4496-98f6-ef85824dd58a'),('2025-11-23 10:06:29.735869','2025-11-23 10:06:29.746587','2025-11-23 10:06:32.743078',84,84,NULL,'1dcbf043a91e492e9142e84de0186253','gigabytes',0,0,NULL,'c02e5473-a628-4496-98f6-ef85824dd58a'),('2025-11-23 10:06:37.158890','2025-11-23 10:07:25.108400',NULL,0,85,'501142af53ff4d5e88e9cfe4c08cc922','4e966c3cb7e340c1a76c532825794ed0','gigabytes',0,0,NULL,NULL),('2025-11-23 10:06:37.162016','2025-11-23 10:07:25.108407',NULL,0,86,'501142af53ff4d5e88e9cfe4c08cc922','4e966c3cb7e340c1a76c532825794ed0','shares',0,0,NULL,NULL),('2025-11-23 10:06:37.195186','2025-11-23 10:06:43.792772','2025-11-23 10:07:25.805028',87,87,NULL,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',0,0,NULL,'3ee67c27-736a-42ab-8228-b5d2b0b3585e'),('2025-11-23 10:06:37.200081','2025-11-23 10:06:43.792773','2025-11-23 10:07:25.805028',88,88,NULL,'4e966c3cb7e340c1a76c532825794ed0','shares',0,0,NULL,'3ee67c27-736a-42ab-8228-b5d2b0b3585e'),('2025-11-23 10:06:37.438213','2025-11-23 10:06:42.224272',NULL,0,89,'13eadb38de804082a26094a402383205','3915699ab6dc4d0eacfc4da73bdd0721','gigabytes',0,0,NULL,NULL),('2025-11-23 10:06:37.440191','2025-11-23 10:06:42.224275',NULL,0,90,'13eadb38de804082a26094a402383205','3915699ab6dc4d0eacfc4da73bdd0721','shares',0,0,NULL,NULL),('2025-11-23 10:06:37.448383','2025-11-23 10:06:42.224276','2025-11-23 10:06:45.088663',91,91,NULL,'3915699ab6dc4d0eacfc4da73bdd0721','gigabytes',0,0,NULL,'1e842ab0-d592-439b-87f5-1b0233177ebe'),('2025-11-23 10:06:37.450199','2025-11-23 10:06:42.224277','2025-11-23 10:06:45.088663',92,92,NULL,'3915699ab6dc4d0eacfc4da73bdd0721','shares',0,0,NULL,'1e842ab0-d592-439b-87f5-1b0233177ebe'),('2025-11-23 10:06:39.143773','2025-11-23 10:06:40.542325',NULL,0,93,'f668e56007aa41cda6df54029adea6e9','e151a2616d204040a966e2f4e3ee04ff','share_networks',0,0,NULL,NULL),('2025-11-23 10:06:39.468551','2025-11-23 10:06:39.515790',NULL,0,94,'1ce5aa3cdeb74392b464424acb0f8c06','fea104cf3c3a44fbbc740b70a6f93f2e','share_networks',1,0,NULL,NULL),('2025-11-23 10:06:41.577472','2025-11-23 10:07:05.885972',NULL,0,95,'7fae8bd255614f2a992630ddb3b5446a','1fa50ded1536493ab576c7056980bef4','gigabytes',0,0,NULL,NULL),('2025-11-23 10:06:41.581164','2025-11-23 10:07:05.885976',NULL,0,96,'7fae8bd255614f2a992630ddb3b5446a','1fa50ded1536493ab576c7056980bef4','shares',0,0,NULL,NULL),('2025-11-23 10:06:41.591867','2025-11-23 10:07:05.885977','2025-11-23 10:07:08.546631',97,97,NULL,'1fa50ded1536493ab576c7056980bef4','gigabytes',0,0,NULL,'016b1539-56c2-478f-9e3c-7604659e989b'),('2025-11-23 10:06:41.594186','2025-11-23 10:07:05.885979','2025-11-23 10:07:08.546631',98,98,NULL,'1fa50ded1536493ab576c7056980bef4','shares',0,0,NULL,'016b1539-56c2-478f-9e3c-7604659e989b'),('2025-11-23 10:06:43.938312','2025-11-23 10:06:47.425714','2025-11-23 10:07:25.733186',99,99,NULL,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',0,0,NULL,'e53a7596-ad58-453e-ac49-ffdf5caca343'),('2025-11-23 10:06:43.942597','2025-11-23 10:06:47.425715','2025-11-23 10:07:25.733186',100,100,NULL,'4e966c3cb7e340c1a76c532825794ed0','shares',0,0,NULL,'e53a7596-ad58-453e-ac49-ffdf5caca343'),('2025-11-23 10:06:44.884394','2025-11-23 10:07:02.445764',NULL,0,101,'7fae8bd255614f2a992630ddb3b5446a','1fa50ded1536493ab576c7056980bef4','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-23 10:06:44.887068','2025-11-23 10:07:02.445768',NULL,0,102,'7fae8bd255614f2a992630ddb3b5446a','1fa50ded1536493ab576c7056980bef4','snapshots',0,0,NULL,NULL),('2025-11-23 10:06:44.897824','2025-11-23 10:07:02.445769','2025-11-23 10:07:08.546631',103,103,NULL,'1fa50ded1536493ab576c7056980bef4','snapshot_gigabytes',0,0,NULL,'016b1539-56c2-478f-9e3c-7604659e989b'),('2025-11-23 10:06:44.899976','2025-11-23 10:07:02.445771','2025-11-23 10:07:08.546631',104,104,NULL,'1fa50ded1536493ab576c7056980bef4','snapshots',0,0,NULL,'016b1539-56c2-478f-9e3c-7604659e989b'),('2025-11-23 10:06:47.532501','2025-11-23 10:06:57.490456','2025-11-23 10:07:25.663300',105,105,NULL,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',0,0,NULL,'40247f48-f49a-472e-8fdc-5a44be63d748'),('2025-11-23 10:06:47.534285','2025-11-23 10:06:57.490457','2025-11-23 10:07:25.663300',106,106,NULL,'4e966c3cb7e340c1a76c532825794ed0','shares',0,0,NULL,'40247f48-f49a-472e-8fdc-5a44be63d748'),('2025-11-23 10:06:49.473769','2025-11-23 10:09:56.591177',NULL,0,107,'53dd88525b764bb9a85c931576dd1d2a','836ae7fa48674096a03624b407ebbbc9','gigabytes',0,0,NULL,NULL),('2025-11-23 10:06:49.477324','2025-11-23 10:09:56.591181',NULL,0,108,'53dd88525b764bb9a85c931576dd1d2a','836ae7fa48674096a03624b407ebbbc9','shares',0,0,NULL,NULL),('2025-11-23 10:06:49.495922','2025-11-23 10:09:56.591183','2025-11-23 10:09:59.474105',109,109,NULL,'836ae7fa48674096a03624b407ebbbc9','gigabytes',0,0,NULL,'1b02bd54-7d26-4a12-b1f3-8fac4d0061e9'),('2025-11-23 10:06:49.499325','2025-11-23 10:09:56.591185','2025-11-23 10:09:59.474105',110,110,NULL,'836ae7fa48674096a03624b407ebbbc9','shares',0,0,NULL,'1b02bd54-7d26-4a12-b1f3-8fac4d0061e9'),('2025-11-23 10:06:50.855279','2025-11-23 10:06:57.283764','2025-11-23 10:07:25.596339',111,111,NULL,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',0,0,NULL,'3367cba6-0c70-49c8-a8df-7303ff3454ea'),('2025-11-23 10:06:50.857447','2025-11-23 10:06:57.283765','2025-11-23 10:07:25.596339',112,112,NULL,'4e966c3cb7e340c1a76c532825794ed0','shares',0,0,NULL,'3367cba6-0c70-49c8-a8df-7303ff3454ea'),('2025-11-23 10:06:53.763038','2025-11-23 10:06:54.492238',NULL,0,113,'8483e09239ab4b5695e53a06581517fc','02ae9008b69a486ea872eaae08e1909a','share_networks',0,0,NULL,NULL),('2025-11-23 10:06:57.638200','2025-11-23 10:07:11.202373','2025-11-23 10:07:25.520647',114,114,NULL,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',0,0,NULL,'37591290-ccf8-48b4-b8e4-c0696751f3b3'),('2025-11-23 10:06:57.641255','2025-11-23 10:07:11.202376','2025-11-23 10:07:25.520647',115,115,NULL,'4e966c3cb7e340c1a76c532825794ed0','shares',0,0,NULL,'37591290-ccf8-48b4-b8e4-c0696751f3b3'),('2025-11-23 10:07:04.012727','2025-11-23 10:07:10.976199','2025-11-23 10:07:25.447872',116,116,NULL,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',0,0,NULL,'cde87ceb-1252-4f18-8d11-f7e2c8bb7e24'),('2025-11-23 10:07:04.014616','2025-11-23 10:07:10.976200','2025-11-23 10:07:25.447872',117,117,NULL,'4e966c3cb7e340c1a76c532825794ed0','shares',0,0,NULL,'cde87ceb-1252-4f18-8d11-f7e2c8bb7e24'),('2025-11-23 10:07:05.179619','2025-11-23 10:07:41.928188',NULL,0,118,'91413c184f394807978c24e936e5c58f','812e12744eb745bcadf0dcbfeff51a92','gigabytes',0,0,NULL,NULL),('2025-11-23 10:07:05.181630','2025-11-23 10:07:41.928191',NULL,0,119,'91413c184f394807978c24e936e5c58f','812e12744eb745bcadf0dcbfeff51a92','shares',0,0,NULL,NULL),('2025-11-23 10:07:05.192304','2025-11-23 10:07:41.928193','2025-11-23 10:07:45.473265',120,120,NULL,'812e12744eb745bcadf0dcbfeff51a92','gigabytes',0,0,NULL,'81f91fcf-5371-4d2d-b313-d95d4ff30ee0'),('2025-11-23 10:07:05.194879','2025-11-23 10:07:41.928194','2025-11-23 10:07:45.473265',121,121,NULL,'812e12744eb745bcadf0dcbfeff51a92','shares',0,0,NULL,'81f91fcf-5371-4d2d-b313-d95d4ff30ee0'),('2025-11-23 10:07:07.308160','2025-11-23 10:07:10.716305','2025-11-23 10:07:25.379357',122,122,NULL,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',0,0,NULL,'16cf707e-52a3-4975-89e5-b873c9ef92cc'),('2025-11-23 10:07:07.310560','2025-11-23 10:07:10.716306','2025-11-23 10:07:25.379357',123,123,NULL,'4e966c3cb7e340c1a76c532825794ed0','shares',0,0,NULL,'16cf707e-52a3-4975-89e5-b873c9ef92cc'),('2025-11-23 10:07:11.267973','2025-11-23 10:07:16.101928',NULL,0,124,'95abdc6959da45d4a2467b1c9ad5bc41','b2b643061e7e43609bfddf91b9cbec2e','gigabytes',0,0,NULL,NULL),('2025-11-23 10:07:11.271719','2025-11-23 10:07:16.101931',NULL,0,125,'95abdc6959da45d4a2467b1c9ad5bc41','b2b643061e7e43609bfddf91b9cbec2e','shares',0,0,NULL,NULL),('2025-11-23 10:07:11.281066','2025-11-23 10:07:16.101932','2025-11-23 10:07:18.990104',126,126,NULL,'b2b643061e7e43609bfddf91b9cbec2e','gigabytes',0,0,NULL,'8e8250f9-acee-45ef-949e-8442f6574cba'),('2025-11-23 10:07:11.283324','2025-11-23 10:07:16.101934','2025-11-23 10:07:18.990104',127,127,NULL,'b2b643061e7e43609bfddf91b9cbec2e','shares',0,0,NULL,'8e8250f9-acee-45ef-949e-8442f6574cba'),('2025-11-23 10:07:11.336535','2025-11-23 10:07:18.512155','2025-11-23 10:07:25.312881',128,128,NULL,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',0,0,NULL,'6c1d4104-0da4-4d52-9c0a-4df6b9946368'),('2025-11-23 10:07:11.339354','2025-11-23 10:07:18.512156','2025-11-23 10:07:25.312881',129,129,NULL,'4e966c3cb7e340c1a76c532825794ed0','shares',0,0,NULL,'6c1d4104-0da4-4d52-9c0a-4df6b9946368'),('2025-11-23 10:07:14.574926','2025-11-23 10:07:18.220741','2025-11-23 10:07:25.232902',130,130,NULL,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',0,0,NULL,'77558cf4-622b-4b30-ae9e-514c9ffd7961'),('2025-11-23 10:07:14.578216','2025-11-23 10:07:18.220742','2025-11-23 10:07:25.232902',131,131,NULL,'4e966c3cb7e340c1a76c532825794ed0','shares',0,0,NULL,'77558cf4-622b-4b30-ae9e-514c9ffd7961'),('2025-11-23 10:07:18.621694','2025-11-23 10:07:25.108410','2025-11-23 10:07:25.164067',132,132,NULL,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',0,0,NULL,'ed12ec80-e123-4266-85ac-12fb62903188'),('2025-11-23 10:07:18.623705','2025-11-23 10:07:25.108412','2025-11-23 10:07:25.164067',133,133,NULL,'4e966c3cb7e340c1a76c532825794ed0','shares',0,0,NULL,'ed12ec80-e123-4266-85ac-12fb62903188'),('2025-11-23 10:07:18.670607','2025-11-23 10:07:28.291554',NULL,0,134,'91413c184f394807978c24e936e5c58f','812e12744eb745bcadf0dcbfeff51a92','share_groups',0,0,NULL,NULL),('2025-11-23 10:07:32.267519','2025-11-23 10:07:59.821875',NULL,0,135,'f15124f92efc44359ea2318339ae8c5f','eacae18cedc64027b1aed993d12bae03','gigabytes',0,0,NULL,NULL),('2025-11-23 10:07:32.270905','2025-11-23 10:07:59.821882',NULL,0,136,'f15124f92efc44359ea2318339ae8c5f','eacae18cedc64027b1aed993d12bae03','shares',0,0,NULL,NULL),('2025-11-23 10:07:32.281317','2025-11-23 10:07:36.047087','2025-11-23 10:08:00.378072',137,137,NULL,'eacae18cedc64027b1aed993d12bae03','gigabytes',0,0,NULL,'bcb4f679-8ed1-45cb-b255-acaf2024be6d'),('2025-11-23 10:07:32.284165','2025-11-23 10:07:36.047088','2025-11-23 10:08:00.378072',138,138,NULL,'eacae18cedc64027b1aed993d12bae03','shares',0,0,NULL,'bcb4f679-8ed1-45cb-b255-acaf2024be6d'),('2025-11-23 10:07:33.088343','2025-11-23 10:07:36.934687',NULL,0,139,'fa83c71a11144a75ae7f6512b3c55e59','fb3243ddd12849b4ae87c500b5ea5cd3','gigabytes',0,0,NULL,NULL),('2025-11-23 10:07:33.090613','2025-11-23 10:07:36.934690',NULL,0,140,'fa83c71a11144a75ae7f6512b3c55e59','fb3243ddd12849b4ae87c500b5ea5cd3','shares',0,0,NULL,NULL),('2025-11-23 10:07:33.102557','2025-11-23 10:07:36.934691','2025-11-23 10:07:39.807335',141,141,NULL,'fb3243ddd12849b4ae87c500b5ea5cd3','gigabytes',0,0,NULL,'77f83cd8-f8c9-4a6a-aedc-a1d834cdd33d'),('2025-11-23 10:07:33.104680','2025-11-23 10:07:36.934692','2025-11-23 10:07:39.807335',142,142,NULL,'fb3243ddd12849b4ae87c500b5ea5cd3','shares',0,0,NULL,'77f83cd8-f8c9-4a6a-aedc-a1d834cdd33d'),('2025-11-23 10:07:36.206423','2025-11-23 10:07:39.636277','2025-11-23 10:08:00.315019',143,143,NULL,'eacae18cedc64027b1aed993d12bae03','gigabytes',0,0,NULL,'4769b174-fe24-419e-962f-4e00c0886b66'),('2025-11-23 10:07:36.209027','2025-11-23 10:07:39.636278','2025-11-23 10:08:00.315019',144,144,NULL,'eacae18cedc64027b1aed993d12bae03','shares',0,0,NULL,'4769b174-fe24-419e-962f-4e00c0886b66'),('2025-11-23 10:07:39.925332','2025-11-23 10:07:46.455872','2025-11-23 10:08:00.256417',145,145,NULL,'eacae18cedc64027b1aed993d12bae03','gigabytes',0,0,NULL,'d97a78d5-ab14-4738-b545-26638365ac91'),('2025-11-23 10:07:39.929074','2025-11-23 10:07:46.455873','2025-11-23 10:08:00.256417',146,146,NULL,'eacae18cedc64027b1aed993d12bae03','shares',0,0,NULL,'d97a78d5-ab14-4738-b545-26638365ac91'),('2025-11-23 10:07:43.469906','2025-11-23 10:08:00.945926',NULL,0,147,'d7518d96a3d24bcc8f6074244df9b08c','7d5d0eedb7da49fa8ee42f6251191fd6','gigabytes',0,0,NULL,NULL),('2025-11-23 10:07:43.471735','2025-11-23 10:08:00.945930',NULL,0,148,'d7518d96a3d24bcc8f6074244df9b08c','7d5d0eedb7da49fa8ee42f6251191fd6','shares',0,0,NULL,NULL),('2025-11-23 10:07:43.483737','2025-11-23 10:08:00.945932','2025-11-23 10:08:03.707378',149,149,NULL,'7d5d0eedb7da49fa8ee42f6251191fd6','gigabytes',0,0,NULL,'944835ee-926f-443d-91cc-ff72067886e2'),('2025-11-23 10:07:43.487331','2025-11-23 10:08:00.945934','2025-11-23 10:08:03.707378',150,150,NULL,'7d5d0eedb7da49fa8ee42f6251191fd6','shares',0,0,NULL,'944835ee-926f-443d-91cc-ff72067886e2'),('2025-11-23 10:07:43.590496','2025-11-23 10:07:54.643710',NULL,0,151,'46bc233a14ac463584fc9a98352f3940','c4833c469f9b4254b420faba19b493d6','gigabytes',0,0,NULL,NULL),('2025-11-23 10:07:43.592774','2025-11-23 10:07:54.643713',NULL,0,152,'46bc233a14ac463584fc9a98352f3940','c4833c469f9b4254b420faba19b493d6','shares',0,0,NULL,NULL),('2025-11-23 10:07:43.603878','2025-11-23 10:07:54.643714','2025-11-23 10:07:57.273789',153,153,NULL,'c4833c469f9b4254b420faba19b493d6','gigabytes',0,0,NULL,'230d231f-5b82-4f03-bab6-0574ee6b85ff'),('2025-11-23 10:07:43.606679','2025-11-23 10:07:54.643715','2025-11-23 10:07:57.273789',154,154,NULL,'c4833c469f9b4254b420faba19b493d6','shares',0,0,NULL,'230d231f-5b82-4f03-bab6-0574ee6b85ff'),('2025-11-23 10:07:46.573247','2025-11-23 10:07:53.104115','2025-11-23 10:08:00.189627',155,155,NULL,'eacae18cedc64027b1aed993d12bae03','gigabytes',0,0,NULL,'448cd856-b926-4d99-a121-6d8c610bbd9a'),('2025-11-23 10:07:46.575704','2025-11-23 10:07:53.104117','2025-11-23 10:08:00.189627',156,156,NULL,'eacae18cedc64027b1aed993d12bae03','shares',0,0,NULL,'448cd856-b926-4d99-a121-6d8c610bbd9a'),('2025-11-23 10:07:46.742923','2025-11-23 10:07:57.688587',NULL,0,157,'d7518d96a3d24bcc8f6074244df9b08c','7d5d0eedb7da49fa8ee42f6251191fd6','snapshots',0,0,NULL,NULL),('2025-11-23 10:07:46.746083','2025-11-23 10:07:57.688590',NULL,0,158,'d7518d96a3d24bcc8f6074244df9b08c','7d5d0eedb7da49fa8ee42f6251191fd6','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-23 10:07:46.756632','2025-11-23 10:07:57.688592','2025-11-23 10:08:03.707378',159,159,NULL,'7d5d0eedb7da49fa8ee42f6251191fd6','snapshots',0,0,NULL,'944835ee-926f-443d-91cc-ff72067886e2'),('2025-11-23 10:07:46.761513','2025-11-23 10:07:57.688593','2025-11-23 10:08:03.707378',160,160,NULL,'7d5d0eedb7da49fa8ee42f6251191fd6','snapshot_gigabytes',0,0,NULL,'944835ee-926f-443d-91cc-ff72067886e2'),('2025-11-23 10:07:46.851652','2025-11-23 10:07:51.276483',NULL,0,161,'46bc233a14ac463584fc9a98352f3940','c4833c469f9b4254b420faba19b493d6','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-23 10:07:46.854321','2025-11-23 10:07:51.276487',NULL,0,162,'46bc233a14ac463584fc9a98352f3940','c4833c469f9b4254b420faba19b493d6','snapshots',0,0,NULL,NULL),('2025-11-23 10:07:46.872796','2025-11-23 10:07:51.276489','2025-11-23 10:07:57.273789',163,163,NULL,'c4833c469f9b4254b420faba19b493d6','snapshot_gigabytes',0,0,NULL,'230d231f-5b82-4f03-bab6-0574ee6b85ff'),('2025-11-23 10:07:46.878840','2025-11-23 10:07:51.276490','2025-11-23 10:07:57.273789',164,164,NULL,'c4833c469f9b4254b420faba19b493d6','snapshots',0,0,NULL,'230d231f-5b82-4f03-bab6-0574ee6b85ff'),('2025-11-23 10:07:53.252012','2025-11-23 10:07:59.821887','2025-11-23 10:08:00.138475',165,165,NULL,'eacae18cedc64027b1aed993d12bae03','gigabytes',0,0,NULL,'9d19f6ac-d78a-4389-b16c-25393beb65ae'),('2025-11-23 10:07:53.259065','2025-11-23 10:07:59.821890','2025-11-23 10:08:00.138475',166,166,NULL,'eacae18cedc64027b1aed993d12bae03','shares',0,0,NULL,'9d19f6ac-d78a-4389-b16c-25393beb65ae'),('2025-11-23 10:07:53.982550','2025-11-23 10:08:05.232511',NULL,0,167,'6ddf5b73960b418b9ff8ae0cf037300b','e16872b51d7541b48411cbf0be50f6f2','gigabytes',0,0,NULL,NULL),('2025-11-23 10:07:53.985788','2025-11-23 10:08:05.232514',NULL,0,168,'6ddf5b73960b418b9ff8ae0cf037300b','e16872b51d7541b48411cbf0be50f6f2','shares',0,0,NULL,NULL),('2025-11-23 10:07:54.001832','2025-11-23 10:08:05.232515','2025-11-23 10:08:08.093235',169,169,NULL,'e16872b51d7541b48411cbf0be50f6f2','gigabytes',0,0,NULL,'cb051e0e-daf9-4f97-96e5-03bb0af63a58'),('2025-11-23 10:07:54.005011','2025-11-23 10:08:05.232516','2025-11-23 10:08:08.093235',170,170,NULL,'e16872b51d7541b48411cbf0be50f6f2','shares',0,0,NULL,'cb051e0e-daf9-4f97-96e5-03bb0af63a58'),('2025-11-23 10:07:57.281650','2025-11-23 10:08:02.060260',NULL,0,171,'6ddf5b73960b418b9ff8ae0cf037300b','e16872b51d7541b48411cbf0be50f6f2','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-23 10:07:57.284693','2025-11-23 10:08:02.060264',NULL,0,172,'6ddf5b73960b418b9ff8ae0cf037300b','e16872b51d7541b48411cbf0be50f6f2','snapshots',0,0,NULL,NULL),('2025-11-23 10:07:57.300027','2025-11-23 10:08:02.060266','2025-11-23 10:08:08.093235',173,173,NULL,'e16872b51d7541b48411cbf0be50f6f2','snapshot_gigabytes',0,0,NULL,'cb051e0e-daf9-4f97-96e5-03bb0af63a58'),('2025-11-23 10:07:57.302851','2025-11-23 10:08:02.060268','2025-11-23 10:08:08.093235',174,174,NULL,'e16872b51d7541b48411cbf0be50f6f2','snapshots',0,0,NULL,'cb051e0e-daf9-4f97-96e5-03bb0af63a58'),('2025-11-23 10:08:05.101920','2025-11-23 10:08:06.551394',NULL,0,175,'1fcabcd5e8ef4405bd339551808f018a','dfc6681c099d46f0a904bf9eea736c22','share_networks',0,0,NULL,NULL),('2025-11-23 10:08:09.477706','2025-11-23 10:08:14.322527',NULL,0,176,'2d3e494889b14951b8175b37f8c3f5e5','fca85941970a450aaec057ef036f1a27','gigabytes',0,0,NULL,NULL),('2025-11-23 10:08:09.481340','2025-11-23 10:08:14.322530',NULL,0,177,'2d3e494889b14951b8175b37f8c3f5e5','fca85941970a450aaec057ef036f1a27','shares',0,0,NULL,NULL),('2025-11-23 10:08:09.500970','2025-11-23 10:08:14.322531','2025-11-23 10:08:16.909763',178,178,NULL,'fca85941970a450aaec057ef036f1a27','gigabytes',0,0,NULL,'195b3608-b444-4e1d-a907-24363ddba087'),('2025-11-23 10:08:09.505619','2025-11-23 10:08:14.322532','2025-11-23 10:08:16.909763',179,179,NULL,'fca85941970a450aaec057ef036f1a27','shares',0,0,NULL,'195b3608-b444-4e1d-a907-24363ddba087'),('2025-11-23 10:08:10.104326','2025-11-23 10:08:20.944010',NULL,0,180,'c26f0e94847c4498b641d36cd7f9e893','09121c745ed044f4ac1be69b2e85b19c','gigabytes',0,0,NULL,NULL),('2025-11-23 10:08:10.108460','2025-11-23 10:08:20.944013',NULL,0,181,'c26f0e94847c4498b641d36cd7f9e893','09121c745ed044f4ac1be69b2e85b19c','shares',0,0,NULL,NULL),('2025-11-23 10:08:10.126343','2025-11-23 10:08:20.944014','2025-11-23 10:08:23.581748',182,182,NULL,'09121c745ed044f4ac1be69b2e85b19c','gigabytes',0,0,NULL,'6689aa2c-a3da-4ed8-ad2f-76109636c54e'),('2025-11-23 10:08:10.129127','2025-11-23 10:08:20.944016','2025-11-23 10:08:23.581748',183,183,NULL,'09121c745ed044f4ac1be69b2e85b19c','shares',0,0,NULL,'6689aa2c-a3da-4ed8-ad2f-76109636c54e'),('2025-11-23 10:08:11.689654','2025-11-23 10:08:22.350702',NULL,0,184,'dce881a0acdf499699d2b927482308f5','3893741994fb4b789f253fc559e364df','gigabytes',0,0,NULL,NULL),('2025-11-23 10:08:11.692722','2025-11-23 10:08:22.350708',NULL,0,185,'dce881a0acdf499699d2b927482308f5','3893741994fb4b789f253fc559e364df','shares',0,0,NULL,NULL),('2025-11-23 10:08:11.704450','2025-11-23 10:08:22.350711','2025-11-23 10:08:32.190786',186,186,NULL,'3893741994fb4b789f253fc559e364df','gigabytes',0,0,NULL,'73750294-0b00-436c-b3a6-b36cbb7b5ac3'),('2025-11-23 10:08:11.707090','2025-11-23 10:08:22.350714','2025-11-23 10:08:32.190786',187,187,NULL,'3893741994fb4b789f253fc559e364df','shares',0,0,NULL,'73750294-0b00-436c-b3a6-b36cbb7b5ac3'),('2025-11-23 10:08:13.444597','2025-11-23 10:08:17.604575',NULL,0,188,'c26f0e94847c4498b641d36cd7f9e893','09121c745ed044f4ac1be69b2e85b19c','snapshots',0,0,NULL,NULL),('2025-11-23 10:08:13.447250','2025-11-23 10:08:17.604579',NULL,0,189,'c26f0e94847c4498b641d36cd7f9e893','09121c745ed044f4ac1be69b2e85b19c','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-23 10:08:13.462379','2025-11-23 10:08:17.604581','2025-11-23 10:08:23.581748',190,190,NULL,'09121c745ed044f4ac1be69b2e85b19c','snapshots',0,0,NULL,'6689aa2c-a3da-4ed8-ad2f-76109636c54e'),('2025-11-23 10:08:13.464640','2025-11-23 10:08:17.604582','2025-11-23 10:08:23.581748',191,191,NULL,'09121c745ed044f4ac1be69b2e85b19c','snapshot_gigabytes',0,0,NULL,'6689aa2c-a3da-4ed8-ad2f-76109636c54e'),('2025-11-23 10:08:15.117157','2025-11-23 10:08:29.290350',NULL,0,192,'9272cfd3fbad46a0858a8c3d2b7c69b9','eb5b74b9d7244a62a5c0b7f105ffc85a','gigabytes',0,0,NULL,NULL),('2025-11-23 10:08:15.122123','2025-11-23 10:08:29.290353',NULL,0,193,'9272cfd3fbad46a0858a8c3d2b7c69b9','eb5b74b9d7244a62a5c0b7f105ffc85a','shares',0,0,NULL,NULL),('2025-11-23 10:08:15.144628','2025-11-23 10:08:29.290354','2025-11-23 10:08:32.190786',194,194,NULL,'eb5b74b9d7244a62a5c0b7f105ffc85a','gigabytes',0,0,NULL,'73750294-0b00-436c-b3a6-b36cbb7b5ac3'),('2025-11-23 10:08:15.148854','2025-11-23 10:08:29.290356','2025-11-23 10:08:32.190786',195,195,NULL,'eb5b74b9d7244a62a5c0b7f105ffc85a','shares',0,0,NULL,'73750294-0b00-436c-b3a6-b36cbb7b5ac3'),('2025-11-23 10:08:24.868206','2025-11-23 10:09:27.347755',NULL,0,196,'69b4c51ee386489baf45acb5638b95eb','4d4586d45fe545c4bf78ea7720359b10','gigabytes',0,0,NULL,NULL),('2025-11-23 10:08:24.872407','2025-11-23 10:09:27.347757',NULL,0,197,'69b4c51ee386489baf45acb5638b95eb','4d4586d45fe545c4bf78ea7720359b10','shares',0,0,NULL,NULL),('2025-11-23 10:08:24.886701','2025-11-23 10:09:27.347759','2025-11-23 10:09:30.174519',198,198,NULL,'4d4586d45fe545c4bf78ea7720359b10','gigabytes',0,0,NULL,'9b70dc84-5ca2-4c80-af25-3b09864bb639'),('2025-11-23 10:08:24.889408','2025-11-23 10:09:27.347760','2025-11-23 10:09:30.174519',199,199,NULL,'4d4586d45fe545c4bf78ea7720359b10','shares',0,0,NULL,'9b70dc84-5ca2-4c80-af25-3b09864bb639'),('2025-11-23 10:08:28.538490','2025-11-23 10:08:36.433455',NULL,0,200,'26e6d20ae34448cfb4ab9e44b5c2b297','bdbef8738c274e8dadf9e931f2c11f32','gigabytes',0,0,NULL,NULL),('2025-11-23 10:08:28.541532','2025-11-23 10:08:36.433458',NULL,0,201,'26e6d20ae34448cfb4ab9e44b5c2b297','bdbef8738c274e8dadf9e931f2c11f32','shares',0,0,NULL,NULL),('2025-11-23 10:08:28.553996','2025-11-23 10:08:36.433460','2025-11-23 10:08:39.249078',202,202,NULL,'bdbef8738c274e8dadf9e931f2c11f32','gigabytes',0,0,NULL,'1f6c6eb7-c250-4448-8f25-f015b009bdaf'),('2025-11-23 10:08:28.556457','2025-11-23 10:08:36.433461','2025-11-23 10:08:39.249078',203,203,NULL,'bdbef8738c274e8dadf9e931f2c11f32','shares',0,0,NULL,'1f6c6eb7-c250-4448-8f25-f015b009bdaf'),('2025-11-23 10:08:52.860307','2025-11-23 10:08:55.490081',NULL,0,204,'5dffb09edaf54dda971a01e9b592ac29','365d81ba6a5e49628d54225e7556ee12','share_networks',0,0,NULL,NULL),('2025-11-23 10:08:53.554772','2025-11-23 10:09:37.071811',NULL,0,205,'2e6273b692d04953b11e15874c09d728','ae90becd2bc545f2a912cb9d303ea195','gigabytes',0,0,NULL,NULL),('2025-11-23 10:08:53.557508','2025-11-23 10:09:37.071814',NULL,0,206,'2e6273b692d04953b11e15874c09d728','ae90becd2bc545f2a912cb9d303ea195','shares',0,0,NULL,NULL),('2025-11-23 10:08:53.599703','2025-11-23 10:09:37.071815','2025-11-23 10:09:39.942805',207,207,NULL,'ae90becd2bc545f2a912cb9d303ea195','gigabytes',0,0,NULL,'d55e48be-eb8d-4b68-93de-8d6fb5819bb8'),('2025-11-23 10:08:53.604410','2025-11-23 10:09:37.071816','2025-11-23 10:09:39.942805',208,208,NULL,'ae90becd2bc545f2a912cb9d303ea195','shares',0,0,NULL,'d55e48be-eb8d-4b68-93de-8d6fb5819bb8'),('2025-11-23 10:09:03.366815','2025-11-23 10:09:14.694714',NULL,0,209,'1a1a5a2be4e34fafb5b7111bbd83e869','28541df1d04743b08d50d1beba4cfee1','gigabytes',1,0,NULL,NULL),('2025-11-23 10:09:03.369523','2025-11-23 10:09:14.694717',NULL,0,210,'1a1a5a2be4e34fafb5b7111bbd83e869','28541df1d04743b08d50d1beba4cfee1','shares',1,0,NULL,NULL),('2025-11-23 10:09:03.384220','2025-11-23 10:09:14.694718','2025-11-23 10:09:17.864213',211,211,NULL,'28541df1d04743b08d50d1beba4cfee1','gigabytes',1,0,NULL,'3fcf11be-2122-4a46-975c-2976b239f7b0'),('2025-11-23 10:09:03.387565','2025-11-23 10:09:14.694719','2025-11-23 10:09:17.864213',212,212,NULL,'28541df1d04743b08d50d1beba4cfee1','shares',1,0,NULL,'3fcf11be-2122-4a46-975c-2976b239f7b0'),('2025-11-23 10:09:06.864599','2025-11-23 10:09:07.764296',NULL,0,213,'d2a5e06bc3ca450f81f13a06170954c7','fec6ab68986546eca4960f54d61bb053','gigabytes',0,0,NULL,NULL),('2025-11-23 10:09:06.866637','2025-11-23 10:09:07.764299',NULL,0,214,'d2a5e06bc3ca450f81f13a06170954c7','fec6ab68986546eca4960f54d61bb053','shares',0,0,NULL,NULL),('2025-11-23 10:09:06.887827','2025-11-23 10:09:07.107491',NULL,0,215,'d2a5e06bc3ca450f81f13a06170954c7','28541df1d04743b08d50d1beba4cfee1','gigabytes',-1,0,NULL,NULL),('2025-11-23 10:09:06.889742','2025-11-23 10:09:07.107493',NULL,0,216,'d2a5e06bc3ca450f81f13a06170954c7','28541df1d04743b08d50d1beba4cfee1','shares',-1,0,NULL,NULL),('2025-11-23 10:09:07.747120','2025-11-23 10:09:07.764300','2025-11-23 10:09:17.864213',217,217,NULL,'fec6ab68986546eca4960f54d61bb053','shares',0,0,NULL,'3fcf11be-2122-4a46-975c-2976b239f7b0'),('2025-11-23 10:09:07.751245','2025-11-23 10:09:07.764302','2025-11-23 10:09:17.864213',218,218,NULL,'fec6ab68986546eca4960f54d61bb053','gigabytes',0,0,NULL,'3fcf11be-2122-4a46-975c-2976b239f7b0'),('2025-11-23 10:09:25.368938','2025-11-23 10:10:17.068229',NULL,0,219,'429426b0008449b8940f3a3e344e70e5','c63638f7e3aa482c8911f8406cf3be5b','gigabytes',0,0,NULL,NULL),('2025-11-23 10:09:25.372962','2025-11-23 10:10:17.068237',NULL,0,220,'429426b0008449b8940f3a3e344e70e5','c63638f7e3aa482c8911f8406cf3be5b','shares',0,0,NULL,NULL),('2025-11-23 10:09:25.383794','2025-11-23 10:10:17.068242','2025-11-23 10:10:19.880733',221,221,NULL,'c63638f7e3aa482c8911f8406cf3be5b','gigabytes',0,0,NULL,'3c9448c7-133a-45ca-9cc8-77d27a9ee3d3'),('2025-11-23 10:09:25.386683','2025-11-23 10:10:17.068246','2025-11-23 10:10:19.880733',222,222,NULL,'c63638f7e3aa482c8911f8406cf3be5b','shares',0,0,NULL,'3c9448c7-133a-45ca-9cc8-77d27a9ee3d3'),('2025-11-23 10:09:28.666173','2025-11-23 10:10:13.817416',NULL,0,223,'429426b0008449b8940f3a3e344e70e5','c63638f7e3aa482c8911f8406cf3be5b','snapshots',0,0,NULL,NULL),('2025-11-23 10:09:28.671229','2025-11-23 10:10:13.817419',NULL,0,224,'429426b0008449b8940f3a3e344e70e5','c63638f7e3aa482c8911f8406cf3be5b','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-23 10:09:28.688469','2025-11-23 10:10:13.817420','2025-11-23 10:10:19.880733',225,225,NULL,'c63638f7e3aa482c8911f8406cf3be5b','snapshots',0,0,NULL,'3c9448c7-133a-45ca-9cc8-77d27a9ee3d3'),('2025-11-23 10:09:28.693501','2025-11-23 10:10:13.817421','2025-11-23 10:10:19.880733',226,226,NULL,'c63638f7e3aa482c8911f8406cf3be5b','snapshot_gigabytes',0,0,NULL,'3c9448c7-133a-45ca-9cc8-77d27a9ee3d3'),('2025-11-23 10:09:38.953446','2025-11-23 10:09:53.235196',NULL,0,227,'a8b24cf78c4a4202b0af8f836283eeb9','836ae7fa48674096a03624b407ebbbc9','gigabytes',0,0,NULL,NULL),('2025-11-23 10:09:38.957002','2025-11-23 10:09:53.235197',NULL,0,228,'a8b24cf78c4a4202b0af8f836283eeb9','836ae7fa48674096a03624b407ebbbc9','shares',0,0,NULL,NULL),('2025-11-23 10:09:49.448989','2025-11-23 10:10:15.370279',NULL,0,229,'d39b24c8e698447ea4af48841e743886','35890416db4d44e38dc2170008ed1576','gigabytes',0,0,NULL,NULL),('2025-11-23 10:09:49.451811','2025-11-23 10:10:15.370282',NULL,0,230,'d39b24c8e698447ea4af48841e743886','35890416db4d44e38dc2170008ed1576','shares',0,0,NULL,NULL),('2025-11-23 10:09:49.466007','2025-11-23 10:10:15.370283','2025-11-23 10:10:17.949090',231,231,NULL,'35890416db4d44e38dc2170008ed1576','gigabytes',0,0,NULL,'ce0a380c-e527-464f-a149-3d15ca56122e'),('2025-11-23 10:09:49.468551','2025-11-23 10:10:15.370284','2025-11-23 10:10:17.949090',232,232,NULL,'35890416db4d44e38dc2170008ed1576','shares',0,0,NULL,'ce0a380c-e527-464f-a149-3d15ca56122e'),('2025-11-23 10:10:07.951333','2025-11-23 10:11:09.811467',NULL,0,233,'8839222900e94621afddf69f01c80f28','00b5d8dd3ef84698af3b5d7d8243bc4a','gigabytes',0,0,NULL,NULL),('2025-11-23 10:10:07.954058','2025-11-23 10:11:09.811469',NULL,0,234,'8839222900e94621afddf69f01c80f28','00b5d8dd3ef84698af3b5d7d8243bc4a','shares',0,0,NULL,NULL),('2025-11-23 10:10:07.965612','2025-11-23 10:11:09.811471','2025-11-23 10:11:12.493362',235,235,NULL,'00b5d8dd3ef84698af3b5d7d8243bc4a','gigabytes',0,0,NULL,'18c5d609-bcf5-4aba-a5ae-2968660e97a3'),('2025-11-23 10:10:07.967933','2025-11-23 10:11:09.811472','2025-11-23 10:11:12.493362',236,236,NULL,'00b5d8dd3ef84698af3b5d7d8243bc4a','shares',0,0,NULL,'18c5d609-bcf5-4aba-a5ae-2968660e97a3'),('2025-11-23 10:10:11.278765','2025-11-23 10:11:06.374400',NULL,0,237,NULL,'00b5d8dd3ef84698af3b5d7d8243bc4a','gigabytes',0,0,NULL,'23b3c3f4-e886-47a1-84d4-43732f5db6cf'),('2025-11-23 10:10:11.283702','2025-11-23 10:11:06.374403',NULL,0,238,NULL,'00b5d8dd3ef84698af3b5d7d8243bc4a','shares',0,0,NULL,'23b3c3f4-e886-47a1-84d4-43732f5db6cf'),('2025-11-23 10:10:11.574086','2025-11-23 10:11:56.587824',NULL,0,239,'5fb7d2d67c934e2cbe59c6ad562ff4f3','190320a05b2f45cf8e579932b75457fd','gigabytes',0,0,NULL,NULL),('2025-11-23 10:10:11.576790','2025-11-23 10:11:56.587827',NULL,0,240,'5fb7d2d67c934e2cbe59c6ad562ff4f3','190320a05b2f45cf8e579932b75457fd','shares',0,0,NULL,NULL),('2025-11-23 10:10:11.587898','2025-11-23 10:11:56.587829','2025-11-23 10:11:59.458224',241,241,NULL,'190320a05b2f45cf8e579932b75457fd','gigabytes',0,0,NULL,'2a197abe-7921-43da-9432-620eb7ef80bc'),('2025-11-23 10:10:11.590297','2025-11-23 10:11:56.587831','2025-11-23 10:11:59.458224',242,242,NULL,'190320a05b2f45cf8e579932b75457fd','shares',0,0,NULL,'2a197abe-7921-43da-9432-620eb7ef80bc'),('2025-11-23 10:10:14.872407','2025-11-23 10:11:53.335567',NULL,0,243,'5fb7d2d67c934e2cbe59c6ad562ff4f3','190320a05b2f45cf8e579932b75457fd','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-23 10:10:14.874385','2025-11-23 10:11:53.335570',NULL,0,244,'5fb7d2d67c934e2cbe59c6ad562ff4f3','190320a05b2f45cf8e579932b75457fd','snapshots',0,0,NULL,NULL),('2025-11-23 10:10:14.887253','2025-11-23 10:11:53.335571','2025-11-23 10:11:59.458224',245,245,NULL,'190320a05b2f45cf8e579932b75457fd','snapshot_gigabytes',0,0,NULL,'2a197abe-7921-43da-9432-620eb7ef80bc'),('2025-11-23 10:10:14.890572','2025-11-23 10:11:53.335572','2025-11-23 10:11:59.458224',246,246,NULL,'190320a05b2f45cf8e579932b75457fd','snapshots',0,0,NULL,'2a197abe-7921-43da-9432-620eb7ef80bc'),('2025-11-23 10:10:18.140843','2025-11-23 10:11:03.067563',NULL,0,247,'a29a1d9ea34448db83552c3feff0658e','7380a21b16c54c28b8907c4cc3ce9099','gigabytes',0,0,NULL,NULL),('2025-11-23 10:10:18.147182','2025-11-23 10:11:03.067566',NULL,0,248,'a29a1d9ea34448db83552c3feff0658e','7380a21b16c54c28b8907c4cc3ce9099','shares',0,0,NULL,NULL),('2025-11-23 10:10:18.175279','2025-11-23 10:11:03.067568',NULL,0,249,NULL,'7380a21b16c54c28b8907c4cc3ce9099','gigabytes',0,0,NULL,'23b3c3f4-e886-47a1-84d4-43732f5db6cf'),('2025-11-23 10:10:18.182620','2025-11-23 10:11:03.067569',NULL,0,250,NULL,'7380a21b16c54c28b8907c4cc3ce9099','shares',0,0,NULL,'23b3c3f4-e886-47a1-84d4-43732f5db6cf'),('2025-11-23 10:10:35.711314','2025-11-23 10:11:21.273544',NULL,0,251,'50f00eb5d5704e6887ad8fba5b45486e','8a0f4525173c4cf1a6c76282655e242b','gigabytes',0,0,NULL,NULL),('2025-11-23 10:10:35.713550','2025-11-23 10:11:21.273547',NULL,0,252,'50f00eb5d5704e6887ad8fba5b45486e','8a0f4525173c4cf1a6c76282655e242b','shares',0,0,NULL,NULL),('2025-11-23 10:10:35.734012','2025-11-23 10:11:21.273548','2025-11-23 10:11:24.124630',253,253,NULL,'8a0f4525173c4cf1a6c76282655e242b','gigabytes',0,0,NULL,'34c26fa5-3efa-4648-b01c-4192b2862186'),('2025-11-23 10:10:35.737189','2025-11-23 10:11:21.273549','2025-11-23 10:11:24.124630',254,254,NULL,'8a0f4525173c4cf1a6c76282655e242b','shares',0,0,NULL,'34c26fa5-3efa-4648-b01c-4192b2862186'),('2025-11-23 10:10:39.070847','2025-11-23 10:11:19.446501',NULL,0,255,'50f00eb5d5704e6887ad8fba5b45486e','8a0f4525173c4cf1a6c76282655e242b','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-23 10:10:39.074763','2025-11-23 10:11:19.446509',NULL,0,256,'50f00eb5d5704e6887ad8fba5b45486e','8a0f4525173c4cf1a6c76282655e242b','snapshots',0,0,NULL,NULL),('2025-11-23 10:10:39.096982','2025-11-23 10:11:19.446513','2025-11-23 10:11:24.124630',257,257,NULL,'8a0f4525173c4cf1a6c76282655e242b','snapshot_gigabytes',0,0,NULL,'34c26fa5-3efa-4648-b01c-4192b2862186'),('2025-11-23 10:10:39.101666','2025-11-23 10:11:19.446517','2025-11-23 10:11:24.124630',258,258,NULL,'8a0f4525173c4cf1a6c76282655e242b','snapshots',0,0,NULL,'34c26fa5-3efa-4648-b01c-4192b2862186'),('2025-11-23 10:10:45.466745','2025-11-23 10:10:59.783367','2025-11-23 10:11:12.493362',259,259,NULL,'7380a21b16c54c28b8907c4cc3ce9099','gigabytes',0,0,NULL,'18c5d609-bcf5-4aba-a5ae-2968660e97a3'),('2025-11-23 10:10:45.472405','2025-11-23 10:10:59.783368','2025-11-23 10:11:12.493362',260,260,NULL,'7380a21b16c54c28b8907c4cc3ce9099','shares',0,0,NULL,'18c5d609-bcf5-4aba-a5ae-2968660e97a3'),('2025-11-23 10:11:22.130028','2025-11-23 10:11:25.465649',NULL,0,261,'5480195b805745f69a026a542ca93086','ad7ad3acd05d4a95a6685c11a14f5ec3','share_networks',0,0,NULL,NULL),('2025-11-23 10:11:34.408572','2025-11-23 10:11:45.521430',NULL,0,262,'4b86a7020e264033a101c66a4665dbd8','667a3e9aeb05446bb507af299e05aff3','gigabytes',0,0,NULL,NULL),('2025-11-23 10:11:34.411024','2025-11-23 10:11:45.521433',NULL,0,263,'4b86a7020e264033a101c66a4665dbd8','667a3e9aeb05446bb507af299e05aff3','shares',0,0,NULL,NULL),('2025-11-23 10:11:34.420038','2025-11-23 10:11:45.521434','2025-11-23 10:11:48.284017',264,264,NULL,'667a3e9aeb05446bb507af299e05aff3','gigabytes',0,0,NULL,'16a77bd1-dba6-471c-aa3a-ea4d41a1ec31'),('2025-11-23 10:11:34.422195','2025-11-23 10:11:45.521435','2025-11-23 10:11:48.284017',265,265,NULL,'667a3e9aeb05446bb507af299e05aff3','shares',0,0,NULL,'16a77bd1-dba6-471c-aa3a-ea4d41a1ec31'),('2025-11-23 10:11:37.745863','2025-11-23 10:11:42.227155',NULL,0,266,'4b86a7020e264033a101c66a4665dbd8','667a3e9aeb05446bb507af299e05aff3','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-23 10:11:37.749331','2025-11-23 10:11:42.227158',NULL,0,267,'4b86a7020e264033a101c66a4665dbd8','667a3e9aeb05446bb507af299e05aff3','snapshots',0,0,NULL,NULL),('2025-11-23 10:11:37.763447','2025-11-23 10:11:42.227159','2025-11-23 10:11:48.284017',268,268,NULL,'667a3e9aeb05446bb507af299e05aff3','snapshot_gigabytes',0,0,NULL,'16a77bd1-dba6-471c-aa3a-ea4d41a1ec31'),('2025-11-23 10:11:37.766632','2025-11-23 10:11:42.227160','2025-11-23 10:11:48.284017',269,269,NULL,'667a3e9aeb05446bb507af299e05aff3','snapshots',0,0,NULL,'16a77bd1-dba6-471c-aa3a-ea4d41a1ec31');
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
INSERT INTO `quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `project_id`, `resource`, `hard_limit`) VALUES (1,'2025-11-23 10:05:50.011540',NULL,'2025-11-23 10:06:04.020667',1,'639b50f98a2a45ed93803ee22072bc7a','shares',3),(2,'2025-11-23 10:05:50.018008',NULL,'2025-11-23 10:06:04.020667',2,'639b50f98a2a45ed93803ee22072bc7a','gigabytes',10),(3,'2025-11-23 10:06:04.102364',NULL,'2025-11-23 10:06:04.452929',3,'639b50f98a2a45ed93803ee22072bc7a','shares',55),(4,'2025-11-23 10:06:04.109148',NULL,'2025-11-23 10:06:04.452929',4,'639b50f98a2a45ed93803ee22072bc7a','snapshots',55),(5,'2025-11-23 10:06:04.113648',NULL,'2025-11-23 10:06:04.452929',5,'639b50f98a2a45ed93803ee22072bc7a','gigabytes',1005),(6,'2025-11-23 10:06:04.127287',NULL,'2025-11-23 10:06:04.452929',6,'639b50f98a2a45ed93803ee22072bc7a','snapshot_gigabytes',1005),(7,'2025-11-23 10:06:04.132778',NULL,'2025-11-23 10:06:04.452929',7,'639b50f98a2a45ed93803ee22072bc7a','share_replicas',105),(8,'2025-11-23 10:06:04.140363',NULL,'2025-11-23 10:06:04.452929',8,'639b50f98a2a45ed93803ee22072bc7a','replica_gigabytes',1005),(9,'2025-11-23 10:06:04.600146',NULL,'2025-11-23 10:06:04.993906',9,'639b50f98a2a45ed93803ee22072bc7a','shares',55),(10,'2025-11-23 10:06:04.605232',NULL,'2025-11-23 10:06:04.993906',10,'639b50f98a2a45ed93803ee22072bc7a','snapshots',55),(11,'2025-11-23 10:06:04.611776',NULL,'2025-11-23 10:06:04.993906',11,'639b50f98a2a45ed93803ee22072bc7a','gigabytes',1005),(12,'2025-11-23 10:06:04.618607',NULL,'2025-11-23 10:06:04.993906',12,'639b50f98a2a45ed93803ee22072bc7a','snapshot_gigabytes',1005),(13,'2025-11-23 10:06:04.624660',NULL,'2025-11-23 10:06:04.993906',13,'639b50f98a2a45ed93803ee22072bc7a','share_replicas',105),(14,'2025-11-23 10:06:04.671580',NULL,'2025-11-23 10:06:04.993906',14,'639b50f98a2a45ed93803ee22072bc7a','replica_gigabytes',1005),(15,'2025-11-23 10:06:05.116446',NULL,'2025-11-23 10:06:05.185112',15,'639b50f98a2a45ed93803ee22072bc7a','shares',52),(16,'2025-11-23 10:06:05.122134',NULL,'2025-11-23 10:06:05.185112',16,'639b50f98a2a45ed93803ee22072bc7a','snapshots',52),(17,'2025-11-23 10:06:05.126753',NULL,'2025-11-23 10:06:05.185112',17,'639b50f98a2a45ed93803ee22072bc7a','gigabytes',1002),(18,'2025-11-23 10:06:05.134154',NULL,'2025-11-23 10:06:05.185112',18,'639b50f98a2a45ed93803ee22072bc7a','snapshot_gigabytes',1002),(19,'2025-11-23 10:06:05.141587',NULL,'2025-11-23 10:06:05.185112',19,'639b50f98a2a45ed93803ee22072bc7a','share_networks',12),(20,'2025-11-23 10:06:05.150379',NULL,'2025-11-23 10:06:05.185112',20,'639b50f98a2a45ed93803ee22072bc7a','share_replicas',102),(21,'2025-11-23 10:06:05.156839',NULL,'2025-11-23 10:06:05.185112',21,'639b50f98a2a45ed93803ee22072bc7a','replica_gigabytes',1002),(22,'2025-11-23 10:06:05.310297',NULL,'2025-11-23 10:06:05.520048',22,'639b50f98a2a45ed93803ee22072bc7a','shares',13),(23,'2025-11-23 10:06:05.595387',NULL,'2025-11-23 10:06:05.639274',23,'639b50f98a2a45ed93803ee22072bc7a','gigabytes',-1),(24,'2025-11-23 10:06:05.686897',NULL,'2025-11-23 10:06:05.750387',24,'639b50f98a2a45ed93803ee22072bc7a','share_replicas',-1),(25,'2025-11-23 10:06:05.802185',NULL,'2025-11-23 10:06:05.846476',25,'639b50f98a2a45ed93803ee22072bc7a','replica_gigabytes',-1),(26,'2025-11-23 10:06:05.934779',NULL,'2025-11-23 10:06:05.981028',26,'639b50f98a2a45ed93803ee22072bc7a','share_networks',-1),(27,'2025-11-23 10:06:06.033230',NULL,'2025-11-23 10:06:06.078889',27,'639b50f98a2a45ed93803ee22072bc7a','shares',-1),(28,'2025-11-23 10:06:06.131134',NULL,'2025-11-23 10:06:06.178641',28,'639b50f98a2a45ed93803ee22072bc7a','snapshot_gigabytes',-1),(29,'2025-11-23 10:06:06.234873',NULL,'2025-11-23 10:06:06.285797',29,'639b50f98a2a45ed93803ee22072bc7a','snapshots',-1),(30,'2025-11-23 10:06:08.810729',NULL,'2025-11-23 10:06:08.883807',30,'639b50f98a2a45ed93803ee22072bc7a','shares',10),(31,'2025-11-23 10:06:08.988155',NULL,'2025-11-23 10:06:09.085317',31,'639b50f98a2a45ed93803ee22072bc7a','shares',10),(32,'2025-11-23 10:06:09.152634',NULL,'2025-11-23 10:06:09.175903',32,'639b50f98a2a45ed93803ee22072bc7a','gigabytes',1002),(33,'2025-11-23 10:06:09.247680',NULL,'2025-11-23 10:06:09.284653',33,'639b50f98a2a45ed93803ee22072bc7a','share_networks',12),(34,'2025-11-23 10:06:09.378345',NULL,'2025-11-23 10:06:09.410934',34,'639b50f98a2a45ed93803ee22072bc7a','shares',52),(35,'2025-11-23 10:06:09.505541',NULL,'2025-11-23 10:06:09.528767',35,'639b50f98a2a45ed93803ee22072bc7a','snapshot_gigabytes',1002),(36,'2025-11-23 10:06:09.621191',NULL,'2025-11-23 10:06:09.647033',36,'639b50f98a2a45ed93803ee22072bc7a','snapshots',52),(37,'2025-11-23 10:06:09.825234',NULL,'2025-11-23 10:06:09.846615',37,'639b50f98a2a45ed93803ee22072bc7a','share_replicas',99),(38,'2025-11-23 10:06:10.081850',NULL,'2025-11-23 10:06:10.107415',38,'639b50f98a2a45ed93803ee22072bc7a','replica_gigabytes',999),(39,'2025-11-23 10:06:10.730359',NULL,'2025-11-23 10:06:10.843547',39,'639b50f98a2a45ed93803ee22072bc7a','shares',10),(40,'2025-11-23 10:06:10.890180',NULL,'2025-11-23 10:06:11.035281',40,'639b50f98a2a45ed93803ee22072bc7a','shares',10),(41,'2025-11-23 10:06:12.142065',NULL,'2025-11-23 10:06:12.276802',41,'1dcbf043a91e492e9142e84de0186253','shares',1),(42,'2025-11-23 10:06:15.775045',NULL,'2025-11-23 10:06:19.182144',42,'1dcbf043a91e492e9142e84de0186253','snapshots',1),(43,'2025-11-23 10:06:21.574126',NULL,'2025-11-23 10:06:21.644538',43,'1dcbf043a91e492e9142e84de0186253','shares',10),(44,'2025-11-23 10:06:21.765002',NULL,'2025-11-23 10:06:21.878354',44,'1dcbf043a91e492e9142e84de0186253','shares',10);
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `usage_id` (`usage_id`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=979 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `share_type_id`) VALUES ('2025-11-23 10:03:30.739020',NULL,'2025-11-23 10:03:30.798455',1,1,'fc4f58dd5944497da3bc37fa9db2fe67','bfe5de13-12e0-45eb-9438-5a960fbf5010',2,'a7811370065740c5abbbccf576edad7c','shares',1,'2025-11-24 10:03:30',NULL),('2025-11-23 10:03:30.741338',NULL,'2025-11-23 10:03:30.798455',2,2,'fc4f58dd5944497da3bc37fa9db2fe67','f9ead81d-c903-4878-bb4e-d236a9cf485f',1,'a7811370065740c5abbbccf576edad7c','gigabytes',1,'2025-11-24 10:03:30',NULL),('2025-11-23 10:03:30.759597',NULL,'2025-11-23 10:03:30.798455',3,3,NULL,'0018064a-1e3d-467d-8299-98879010d9b8',4,'a7811370065740c5abbbccf576edad7c','shares',1,'2025-11-24 10:03:30','7b04a7f7-d28d-4e9a-a2c9-2f71d803e355'),('2025-11-23 10:03:30.761066',NULL,'2025-11-23 10:03:30.798455',4,4,NULL,'34efea49-de7d-4bf3-a184-748fdf169aa0',3,'a7811370065740c5abbbccf576edad7c','gigabytes',1,'2025-11-24 10:03:30','7b04a7f7-d28d-4e9a-a2c9-2f71d803e355'),('2025-11-23 10:03:32.253000',NULL,'2025-11-23 10:03:32.391784',5,5,'fc4f58dd5944497da3bc37fa9db2fe67','1e34e917-2dd7-44f3-ae22-df5abfd7c56c',6,'a7811370065740c5abbbccf576edad7c','snapshots',1,'2025-11-24 10:03:32',NULL),('2025-11-23 10:03:32.256078',NULL,'2025-11-23 10:03:32.391784',6,6,'fc4f58dd5944497da3bc37fa9db2fe67','96c7ead5-868b-4899-a937-4de2b8e2a93a',5,'a7811370065740c5abbbccf576edad7c','snapshot_gigabytes',1,'2025-11-24 10:03:32',NULL),('2025-11-23 10:03:32.277162',NULL,'2025-11-23 10:03:32.391784',7,7,NULL,'8da8b03f-57eb-45b9-870e-17c8e5ab9dd7',8,'a7811370065740c5abbbccf576edad7c','snapshots',1,'2025-11-24 10:03:32','7b04a7f7-d28d-4e9a-a2c9-2f71d803e355'),('2025-11-23 10:03:32.278897',NULL,'2025-11-23 10:03:32.391784',8,8,NULL,'d6ea0334-c8d9-409b-8714-2b6c0eecca2c',7,'a7811370065740c5abbbccf576edad7c','snapshot_gigabytes',1,'2025-11-24 10:03:32','7b04a7f7-d28d-4e9a-a2c9-2f71d803e355'),('2025-11-23 10:03:37.197517',NULL,'2025-11-23 10:03:37.220483',9,9,'fc4f58dd5944497da3bc37fa9db2fe67','2dddf324-364b-47a0-adb4-9b758c473c5e',6,'a7811370065740c5abbbccf576edad7c','snapshots',-1,'2025-11-24 10:03:37',NULL),('2025-11-23 10:03:37.198640',NULL,'2025-11-23 10:03:37.220483',10,10,'fc4f58dd5944497da3bc37fa9db2fe67','2c49e82c-4386-49fa-97f8-77a247f5a3e1',5,'a7811370065740c5abbbccf576edad7c','snapshot_gigabytes',-1,'2025-11-24 10:03:37',NULL),('2025-11-23 10:03:37.208836',NULL,'2025-11-23 10:03:37.220483',11,11,NULL,'c23968fd-86be-4779-abda-f2f5269b0975',8,'a7811370065740c5abbbccf576edad7c','snapshots',-1,'2025-11-24 10:03:37','7b04a7f7-d28d-4e9a-a2c9-2f71d803e355'),('2025-11-23 10:03:37.210013',NULL,'2025-11-23 10:03:37.220483',12,12,NULL,'87476899-89d4-415d-bfb4-a5c69597ade0',7,'a7811370065740c5abbbccf576edad7c','snapshot_gigabytes',-1,'2025-11-24 10:03:37','7b04a7f7-d28d-4e9a-a2c9-2f71d803e355'),('2025-11-23 10:03:40.632506',NULL,'2025-11-23 10:03:40.644252',13,13,'fc4f58dd5944497da3bc37fa9db2fe67','80dccae1-b184-42c3-adf5-02817abacb59',2,'a7811370065740c5abbbccf576edad7c','shares',-1,'2025-11-24 10:03:40',NULL),('2025-11-23 10:03:40.633287',NULL,'2025-11-23 10:03:40.644252',14,14,'fc4f58dd5944497da3bc37fa9db2fe67','aadd951a-f87a-48cb-899c-1069180db656',1,'a7811370065740c5abbbccf576edad7c','gigabytes',-1,'2025-11-24 10:03:40',NULL),('2025-11-23 10:03:40.638088',NULL,'2025-11-23 10:03:40.644252',15,15,NULL,'77eec159-50bf-448f-ad51-242db6769cac',4,'a7811370065740c5abbbccf576edad7c','shares',-1,'2025-11-24 10:03:40','7b04a7f7-d28d-4e9a-a2c9-2f71d803e355'),('2025-11-23 10:03:40.638702',NULL,'2025-11-23 10:03:40.644252',16,16,NULL,'e4a9ff6b-3180-429b-8aa4-5fd48c4b51f3',3,'a7811370065740c5abbbccf576edad7c','gigabytes',-1,'2025-11-24 10:03:40','7b04a7f7-d28d-4e9a-a2c9-2f71d803e355'),('2025-11-23 10:04:21.297176',NULL,'2025-11-23 10:04:21.377283',17,17,'90cea60d49c344f1a49f93c6695603ba','8b3a00c2-b676-4949-b230-9fb4cb4b3942',10,'51d0d3cbee924cf1ab4c449b1d345d19','shares',1,'2025-11-24 10:04:21',NULL),('2025-11-23 10:04:21.299480',NULL,'2025-11-23 10:04:21.377283',18,18,'90cea60d49c344f1a49f93c6695603ba','43f62663-5847-418c-b83d-3c1d6d23530c',9,'51d0d3cbee924cf1ab4c449b1d345d19','gigabytes',1,'2025-11-24 10:04:21',NULL),('2025-11-23 10:04:21.320000',NULL,'2025-11-23 10:04:21.377283',19,19,NULL,'641d5722-347f-427d-a168-bc72917e61ac',12,'51d0d3cbee924cf1ab4c449b1d345d19','shares',1,'2025-11-24 10:04:21','74d04172-2c32-4af1-97e0-85082bfd6aa2'),('2025-11-23 10:04:21.326072',NULL,'2025-11-23 10:04:21.377283',20,20,NULL,'dee6e3c8-3342-4ad2-87b6-0d66ee58ea38',11,'51d0d3cbee924cf1ab4c449b1d345d19','gigabytes',1,'2025-11-24 10:04:21','74d04172-2c32-4af1-97e0-85082bfd6aa2'),('2025-11-23 10:04:24.794446',NULL,'2025-11-23 10:04:24.931858',21,21,'90cea60d49c344f1a49f93c6695603ba','69723824-7177-4174-b341-e95f0ad5263c',14,'51d0d3cbee924cf1ab4c449b1d345d19','snapshots',1,'2025-11-24 10:04:24',NULL),('2025-11-23 10:04:24.802351',NULL,'2025-11-23 10:04:24.931858',22,22,'90cea60d49c344f1a49f93c6695603ba','c17d2ba7-4a48-41ba-a0ab-5105b9e3cd1f',13,'51d0d3cbee924cf1ab4c449b1d345d19','snapshot_gigabytes',1,'2025-11-24 10:04:24',NULL),('2025-11-23 10:04:24.826468',NULL,'2025-11-23 10:04:24.931858',23,23,NULL,'eebdaa3f-1d32-442b-9b84-9d1909c5de52',16,'51d0d3cbee924cf1ab4c449b1d345d19','snapshots',1,'2025-11-24 10:04:24','74d04172-2c32-4af1-97e0-85082bfd6aa2'),('2025-11-23 10:04:24.827677',NULL,'2025-11-23 10:04:24.931858',24,24,NULL,'61b1bd31-4347-4fbd-aec9-a2d758af8ed7',15,'51d0d3cbee924cf1ab4c449b1d345d19','snapshot_gigabytes',1,'2025-11-24 10:04:24','74d04172-2c32-4af1-97e0-85082bfd6aa2'),('2025-11-23 10:04:28.376092',NULL,'2025-11-23 10:04:28.404538',25,25,'90cea60d49c344f1a49f93c6695603ba','a79baeb5-6946-40cf-8b36-149b2900f7fb',10,'51d0d3cbee924cf1ab4c449b1d345d19','shares',1,'2025-11-24 10:04:28',NULL),('2025-11-23 10:04:28.377448',NULL,'2025-11-23 10:04:28.404538',26,26,'90cea60d49c344f1a49f93c6695603ba','6962c8cc-38ca-4050-a951-4834b2ecf9bc',9,'51d0d3cbee924cf1ab4c449b1d345d19','gigabytes',1,'2025-11-24 10:04:28',NULL),('2025-11-23 10:04:28.382944',NULL,'2025-11-23 10:04:28.404538',27,27,NULL,'62974380-2254-4e79-9d8a-094a2cd92bf9',12,'51d0d3cbee924cf1ab4c449b1d345d19','shares',1,'2025-11-24 10:04:28','74d04172-2c32-4af1-97e0-85082bfd6aa2'),('2025-11-23 10:04:28.383989',NULL,'2025-11-23 10:04:28.404538',28,28,NULL,'ecf1b927-a047-423c-bb94-44cfd3579737',11,'51d0d3cbee924cf1ab4c449b1d345d19','gigabytes',1,'2025-11-24 10:04:28','74d04172-2c32-4af1-97e0-85082bfd6aa2'),('2025-11-23 10:04:36.855836',NULL,'2025-11-23 10:04:36.902367',29,29,'cd47d55f3345423888e76431c4ceb067','3146747b-f3c9-45ba-aa11-8765cd26ce04',18,'980c7c21c34748d78f83541fa493dd05','shares',1,'2025-11-24 10:04:36',NULL),('2025-11-23 10:04:36.857341',NULL,'2025-11-23 10:04:36.902367',30,30,'cd47d55f3345423888e76431c4ceb067','527eb814-6c37-461b-8ef6-1d5a33d9ecfb',17,'980c7c21c34748d78f83541fa493dd05','gigabytes',1,'2025-11-24 10:04:36',NULL),('2025-11-23 10:04:36.870230',NULL,'2025-11-23 10:04:36.902367',31,31,NULL,'f1f50ff1-7f91-4005-be24-772d35e9f92a',20,'980c7c21c34748d78f83541fa493dd05','shares',1,'2025-11-24 10:04:36','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:04:36.871596',NULL,'2025-11-23 10:04:36.902367',32,32,NULL,'5c0e81d3-fc9c-4b6f-9857-e36daacfee7f',19,'980c7c21c34748d78f83541fa493dd05','gigabytes',1,'2025-11-24 10:04:36','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:04:40.210025',NULL,'2025-11-23 10:04:40.253463',33,33,'cd47d55f3345423888e76431c4ceb067','74f2c544-be19-445d-ac73-5623a4ae8c88',18,'980c7c21c34748d78f83541fa493dd05','shares',1,'2025-11-24 10:04:40',NULL),('2025-11-23 10:04:40.211702',NULL,'2025-11-23 10:04:40.253463',34,34,'cd47d55f3345423888e76431c4ceb067','c0f35c20-8ca2-4332-989b-139105240feb',17,'980c7c21c34748d78f83541fa493dd05','gigabytes',1,'2025-11-24 10:04:40',NULL),('2025-11-23 10:04:40.218051',NULL,'2025-11-23 10:04:40.253463',35,35,NULL,'9f0a4d59-d067-436b-806e-d7af70b9c02d',20,'980c7c21c34748d78f83541fa493dd05','shares',1,'2025-11-24 10:04:40','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:04:40.219277',NULL,'2025-11-23 10:04:40.253463',36,36,NULL,'e472ba4b-f0c3-4839-9fa0-7b23cdb171d7',19,'980c7c21c34748d78f83541fa493dd05','gigabytes',1,'2025-11-24 10:04:40','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:04:43.580496',NULL,'2025-11-23 10:04:43.846632',37,37,'cd47d55f3345423888e76431c4ceb067','caa219d9-f438-445e-9503-0b9f88c4f1cb',17,'980c7c21c34748d78f83541fa493dd05','gigabytes',1,'2025-11-24 10:04:43',NULL),('2025-11-23 10:04:43.590633',NULL,'2025-11-23 10:04:43.846632',38,38,NULL,'74ff1ee1-987d-4b6e-b021-f8623392bb52',19,'980c7c21c34748d78f83541fa493dd05','gigabytes',1,'2025-11-24 10:04:43','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:04:47.409352',NULL,'2025-11-23 10:04:47.432015',39,39,'cd47d55f3345423888e76431c4ceb067','20e032e2-464d-47a2-874b-f3273d50a3a5',18,'980c7c21c34748d78f83541fa493dd05','shares',-1,'2025-11-24 10:04:47',NULL),('2025-11-23 10:04:47.411000',NULL,'2025-11-23 10:04:47.432015',40,40,'cd47d55f3345423888e76431c4ceb067','c5745ad8-83c1-49c2-a3a2-87c84cc774f4',17,'980c7c21c34748d78f83541fa493dd05','gigabytes',-2,'2025-11-24 10:04:47',NULL),('2025-11-23 10:04:47.419353',NULL,'2025-11-23 10:04:47.432015',41,41,NULL,'2531834f-35b8-40f2-a1eb-b62ab92ea667',20,'980c7c21c34748d78f83541fa493dd05','shares',-1,'2025-11-24 10:04:47','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:04:47.420115',NULL,'2025-11-23 10:04:47.432015',42,42,NULL,'172c248e-a64c-43b3-8c17-543b0a4ef0e0',19,'980c7c21c34748d78f83541fa493dd05','gigabytes',-2,'2025-11-24 10:04:47','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:04:50.213042',NULL,'2025-11-23 10:04:50.255091',43,43,'cd47d55f3345423888e76431c4ceb067','d5604ea7-73cd-48cd-86fa-66226a7be3a9',18,'980c7c21c34748d78f83541fa493dd05','shares',1,'2025-11-24 10:04:50',NULL),('2025-11-23 10:04:50.216679',NULL,'2025-11-23 10:04:50.255091',44,44,'cd47d55f3345423888e76431c4ceb067','b3f440a9-900f-4378-91c3-a79a5ee3e98c',17,'980c7c21c34748d78f83541fa493dd05','gigabytes',1,'2025-11-24 10:04:50',NULL),('2025-11-23 10:04:50.227398',NULL,'2025-11-23 10:04:50.255091',45,45,NULL,'e1fae990-df94-4419-844d-5b23126951c6',20,'980c7c21c34748d78f83541fa493dd05','shares',1,'2025-11-24 10:04:50','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:04:50.228908',NULL,'2025-11-23 10:04:50.255091',46,46,NULL,'4a3a4771-e8af-4ce5-aa06-aa156d773a5f',19,'980c7c21c34748d78f83541fa493dd05','gigabytes',1,'2025-11-24 10:04:50','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:04:52.398061',NULL,'2025-11-23 10:04:52.440195',47,47,'99c9da5d2d9848b190ec8ece75c0a8aa','a26a7584-ab1b-47db-89b4-16c4b54cd1ab',22,'1be2483fd52a488b9ba1f871a3ed13aa','shares',1,'2025-11-24 10:04:52',NULL),('2025-11-23 10:04:52.401148',NULL,'2025-11-23 10:04:52.440195',48,48,'99c9da5d2d9848b190ec8ece75c0a8aa','b52e4a06-a6f1-4544-8f2d-35bb69bb4afa',21,'1be2483fd52a488b9ba1f871a3ed13aa','gigabytes',1,'2025-11-24 10:04:52',NULL),('2025-11-23 10:04:52.410766',NULL,'2025-11-23 10:04:52.440195',49,49,NULL,'ea15c037-8c26-442f-96a8-cad275aaf754',24,'1be2483fd52a488b9ba1f871a3ed13aa','shares',1,'2025-11-24 10:04:52','bbea3883-863d-4202-99f2-f7cd0fa2f205'),('2025-11-23 10:04:52.412088',NULL,'2025-11-23 10:04:52.440195',50,50,NULL,'888577c0-d7e3-44ef-9967-f35887a82418',23,'1be2483fd52a488b9ba1f871a3ed13aa','gigabytes',1,'2025-11-24 10:04:52','bbea3883-863d-4202-99f2-f7cd0fa2f205'),('2025-11-23 10:04:53.830381',NULL,'2025-11-23 10:04:54.106561',51,51,'cd47d55f3345423888e76431c4ceb067','40b36c1a-7d9a-49df-b07f-ba263a63084b',17,'980c7c21c34748d78f83541fa493dd05','gigabytes',1,'2025-11-24 10:04:53',NULL),('2025-11-23 10:04:53.877855',NULL,'2025-11-23 10:04:54.106561',52,52,NULL,'1ca63fdd-6ade-4e7c-8c94-dc28a99c6af0',19,'980c7c21c34748d78f83541fa493dd05','gigabytes',1,'2025-11-24 10:04:53','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:04:57.602362',NULL,'2025-11-23 10:04:57.630329',53,53,'cd47d55f3345423888e76431c4ceb067','eed57824-4193-4f85-9325-969edfcfbbbe',18,'980c7c21c34748d78f83541fa493dd05','shares',-1,'2025-11-24 10:04:57',NULL),('2025-11-23 10:04:57.604019',NULL,'2025-11-23 10:04:57.630329',54,54,'cd47d55f3345423888e76431c4ceb067','6a12fc53-5c45-4c3d-a251-cd25ddeff67f',17,'980c7c21c34748d78f83541fa493dd05','gigabytes',-2,'2025-11-24 10:04:57',NULL),('2025-11-23 10:04:57.611533',NULL,'2025-11-23 10:04:57.630329',55,55,NULL,'bb1d5ed0-1428-473d-9de3-680c2f503de8',20,'980c7c21c34748d78f83541fa493dd05','shares',-1,'2025-11-24 10:04:57','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:04:57.612319',NULL,'2025-11-23 10:04:57.630329',56,56,NULL,'b8f04090-23a2-4b73-b010-69bfe93eeb8a',19,'980c7c21c34748d78f83541fa493dd05','gigabytes',-2,'2025-11-24 10:04:57','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:04:58.786180',NULL,'2025-11-23 10:04:58.813611',57,57,'99c9da5d2d9848b190ec8ece75c0a8aa','2d27a147-7ce3-414d-94e0-a3766c51c45e',22,'1be2483fd52a488b9ba1f871a3ed13aa','shares',-1,'2025-11-24 10:04:58',NULL),('2025-11-23 10:04:58.787519',NULL,'2025-11-23 10:04:58.813611',58,58,'99c9da5d2d9848b190ec8ece75c0a8aa','38f27588-8690-44ee-a7d7-1272d7712a6c',21,'1be2483fd52a488b9ba1f871a3ed13aa','gigabytes',-1,'2025-11-24 10:04:58',NULL),('2025-11-23 10:04:58.799319',NULL,'2025-11-23 10:04:58.813611',59,59,NULL,'9477dcd4-562d-4650-b7bf-5f399025b446',24,'1be2483fd52a488b9ba1f871a3ed13aa','shares',-1,'2025-11-24 10:04:58','bbea3883-863d-4202-99f2-f7cd0fa2f205'),('2025-11-23 10:04:58.800445',NULL,'2025-11-23 10:04:58.813611',60,60,NULL,'fadeb767-18e7-423c-a885-13cb6b74b079',23,'1be2483fd52a488b9ba1f871a3ed13aa','gigabytes',-1,'2025-11-24 10:04:58','bbea3883-863d-4202-99f2-f7cd0fa2f205'),('2025-11-23 10:05:00.481383',NULL,'2025-11-23 10:05:00.513203',61,61,'cd47d55f3345423888e76431c4ceb067','f0206b21-665b-4009-b357-0dee921fc5a0',18,'980c7c21c34748d78f83541fa493dd05','shares',1,'2025-11-24 10:05:00',NULL),('2025-11-23 10:05:00.483588',NULL,'2025-11-23 10:05:00.513203',62,62,'cd47d55f3345423888e76431c4ceb067','7b3b939d-fc76-40ec-9bf4-41b040ae13fc',17,'980c7c21c34748d78f83541fa493dd05','gigabytes',1,'2025-11-24 10:05:00',NULL),('2025-11-23 10:05:00.490395',NULL,'2025-11-23 10:05:00.513203',63,63,NULL,'2b0aa5fd-aad3-47dc-9166-43261c7a5b80',20,'980c7c21c34748d78f83541fa493dd05','shares',1,'2025-11-24 10:05:00','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:00.491535',NULL,'2025-11-23 10:05:00.513203',64,64,NULL,'f2639f1c-01ec-40a3-a80a-0e3f1d22a5ba',19,'980c7c21c34748d78f83541fa493dd05','gigabytes',1,'2025-11-24 10:05:00','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:04.272786',NULL,'2025-11-23 10:05:04.302098',65,65,'cd47d55f3345423888e76431c4ceb067','0362c7f9-272e-467f-be2e-fb369c310bf4',18,'980c7c21c34748d78f83541fa493dd05','shares',-1,'2025-11-24 10:05:04',NULL),('2025-11-23 10:05:04.274078',NULL,'2025-11-23 10:05:04.302098',66,66,'cd47d55f3345423888e76431c4ceb067','f15cb922-bff5-4868-adbd-93716d581170',17,'980c7c21c34748d78f83541fa493dd05','gigabytes',-1,'2025-11-24 10:05:04',NULL),('2025-11-23 10:05:04.286290',NULL,'2025-11-23 10:05:04.302098',67,67,NULL,'2da42ba2-a10e-4eb5-96b9-9c88de87ff98',20,'980c7c21c34748d78f83541fa493dd05','shares',-1,'2025-11-24 10:05:04','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:04.287307',NULL,'2025-11-23 10:05:04.302098',68,68,NULL,'d4866289-a089-4336-b770-3cc6a13aa6ef',19,'980c7c21c34748d78f83541fa493dd05','gigabytes',-1,'2025-11-24 10:05:04','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:07.160213',NULL,'2025-11-23 10:05:07.186719',69,69,'cd47d55f3345423888e76431c4ceb067','8808748a-6ec1-4bd2-94a3-dc46884e29fc',18,'980c7c21c34748d78f83541fa493dd05','shares',1,'2025-11-24 10:05:07',NULL),('2025-11-23 10:05:07.161629',NULL,'2025-11-23 10:05:07.186719',70,70,'cd47d55f3345423888e76431c4ceb067','28500cc4-9afa-441c-8424-b28dd3b8836c',17,'980c7c21c34748d78f83541fa493dd05','gigabytes',1,'2025-11-24 10:05:07',NULL),('2025-11-23 10:05:07.168055',NULL,'2025-11-23 10:05:07.186719',71,71,NULL,'bb8f7dfc-fe1e-463d-8dbc-afb3b95da95d',20,'980c7c21c34748d78f83541fa493dd05','shares',1,'2025-11-24 10:05:07','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:07.169110',NULL,'2025-11-23 10:05:07.186719',72,72,NULL,'731c58a3-8de4-4926-83c7-0bde37a0cfec',19,'980c7c21c34748d78f83541fa493dd05','gigabytes',1,'2025-11-24 10:05:07','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:10.852637',NULL,'2025-11-23 10:05:10.875192',73,73,'cd47d55f3345423888e76431c4ceb067','f5720078-9647-49c6-b2f3-bfa2307df3ea',18,'980c7c21c34748d78f83541fa493dd05','shares',-1,'2025-11-24 10:05:10',NULL),('2025-11-23 10:05:10.854201',NULL,'2025-11-23 10:05:10.875192',74,74,'cd47d55f3345423888e76431c4ceb067','f3a668c7-4de3-47d9-a996-1bb0d09821f8',17,'980c7c21c34748d78f83541fa493dd05','gigabytes',-1,'2025-11-24 10:05:10',NULL),('2025-11-23 10:05:10.867065',NULL,'2025-11-23 10:05:10.875192',75,75,NULL,'587f1d3a-773b-4c02-9c70-efc7c65405d0',20,'980c7c21c34748d78f83541fa493dd05','shares',-1,'2025-11-24 10:05:10','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:10.867844',NULL,'2025-11-23 10:05:10.875192',76,76,NULL,'4fa8c34c-6bd1-404a-be62-5337e73b4aed',19,'980c7c21c34748d78f83541fa493dd05','gigabytes',-1,'2025-11-24 10:05:10','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:13.912474',NULL,'2025-11-23 10:05:14.025942',77,77,'cd47d55f3345423888e76431c4ceb067','39849101-197a-460b-9b4e-6bf6ae8095da',26,'980c7c21c34748d78f83541fa493dd05','snapshots',1,'2025-11-24 10:05:13',NULL),('2025-11-23 10:05:13.923442',NULL,'2025-11-23 10:05:14.025942',78,78,'cd47d55f3345423888e76431c4ceb067','66feb900-4150-4e2b-a2da-9ec18a9e360b',25,'980c7c21c34748d78f83541fa493dd05','snapshot_gigabytes',1,'2025-11-24 10:05:13',NULL),('2025-11-23 10:05:13.956853',NULL,'2025-11-23 10:05:14.025942',79,79,NULL,'c10ee90e-f24d-40fb-960a-836de699cac1',28,'980c7c21c34748d78f83541fa493dd05','snapshots',1,'2025-11-24 10:05:13','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:13.958049',NULL,'2025-11-23 10:05:14.025942',80,80,NULL,'78d1a4eb-8f24-497c-87d7-0194ddb14ba4',27,'980c7c21c34748d78f83541fa493dd05','snapshot_gigabytes',1,'2025-11-24 10:05:13','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:19.086577',NULL,'2025-11-23 10:05:19.126509',81,81,'cd47d55f3345423888e76431c4ceb067','21b692aa-6dee-4483-aad7-062b824823dc',26,'980c7c21c34748d78f83541fa493dd05','snapshots',-1,'2025-11-24 10:05:19',NULL),('2025-11-23 10:05:19.088037',NULL,'2025-11-23 10:05:19.126509',82,82,'cd47d55f3345423888e76431c4ceb067','1d523c98-f9ea-4d50-be66-ab592a0ab5ac',25,'980c7c21c34748d78f83541fa493dd05','snapshot_gigabytes',-1,'2025-11-24 10:05:19',NULL),('2025-11-23 10:05:19.105699',NULL,'2025-11-23 10:05:19.126509',83,83,NULL,'37ce2f1d-8152-4ff2-9737-6985a426864e',28,'980c7c21c34748d78f83541fa493dd05','snapshots',-1,'2025-11-24 10:05:19','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:19.108209',NULL,'2025-11-23 10:05:19.126509',84,84,NULL,'8ce222b9-4c25-4420-b36b-708bd442aeb1',27,'980c7c21c34748d78f83541fa493dd05','snapshot_gigabytes',-1,'2025-11-24 10:05:19','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:20.716666',NULL,'2025-11-23 10:05:20.742367',85,85,'90cea60d49c344f1a49f93c6695603ba','976c8b3d-87b7-4276-b50b-70924f46bbcf',10,'51d0d3cbee924cf1ab4c449b1d345d19','shares',-1,'2025-11-24 10:05:20',NULL),('2025-11-23 10:05:20.717625',NULL,'2025-11-23 10:05:20.742367',86,86,'90cea60d49c344f1a49f93c6695603ba','85e21c3f-2898-4f09-b448-66274baa529a',9,'51d0d3cbee924cf1ab4c449b1d345d19','gigabytes',-1,'2025-11-24 10:05:20',NULL),('2025-11-23 10:05:20.729423',NULL,'2025-11-23 10:05:20.742367',87,87,NULL,'c3beca1a-bf47-4a0c-9570-995700670737',12,'51d0d3cbee924cf1ab4c449b1d345d19','shares',-1,'2025-11-24 10:05:20','74d04172-2c32-4af1-97e0-85082bfd6aa2'),('2025-11-23 10:05:20.730592',NULL,'2025-11-23 10:05:20.742367',88,88,NULL,'11d87b07-99ad-4af8-9a2f-3931117f25c4',11,'51d0d3cbee924cf1ab4c449b1d345d19','gigabytes',-1,'2025-11-24 10:05:20','74d04172-2c32-4af1-97e0-85082bfd6aa2'),('2025-11-23 10:05:23.238592',NULL,'2025-11-23 10:05:23.434202',89,89,'cd47d55f3345423888e76431c4ceb067','6f835cb4-33e5-4cdb-acc1-a25701b4e24a',26,'980c7c21c34748d78f83541fa493dd05','snapshots',1,'2025-11-24 10:05:23',NULL),('2025-11-23 10:05:23.241416',NULL,'2025-11-23 10:05:23.434202',90,90,'cd47d55f3345423888e76431c4ceb067','f8f86829-312e-4db3-b859-4d4f255e248a',25,'980c7c21c34748d78f83541fa493dd05','snapshot_gigabytes',1,'2025-11-24 10:05:23',NULL),('2025-11-23 10:05:23.248209',NULL,'2025-11-23 10:05:23.434202',91,91,NULL,'ee460f7c-f328-45f6-89f2-a167f3f400e3',28,'980c7c21c34748d78f83541fa493dd05','snapshots',1,'2025-11-24 10:05:23','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:23.249303',NULL,'2025-11-23 10:05:23.434202',92,92,NULL,'a2dae43d-f041-4086-933b-5474b5130286',27,'980c7c21c34748d78f83541fa493dd05','snapshot_gigabytes',1,'2025-11-24 10:05:23','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:23.944113',NULL,'2025-11-23 10:05:23.966970',93,93,'90cea60d49c344f1a49f93c6695603ba','26a22fee-bdd7-45c6-8da5-61f2c3acf9c7',14,'51d0d3cbee924cf1ab4c449b1d345d19','snapshots',-1,'2025-11-24 10:05:23',NULL),('2025-11-23 10:05:23.944817',NULL,'2025-11-23 10:05:23.966970',94,94,'90cea60d49c344f1a49f93c6695603ba','7d7dce40-b01d-4977-afc4-e3a2cd182012',13,'51d0d3cbee924cf1ab4c449b1d345d19','snapshot_gigabytes',-1,'2025-11-24 10:05:23',NULL),('2025-11-23 10:05:23.950305',NULL,'2025-11-23 10:05:23.966970',95,95,NULL,'338af3ff-c476-4d86-be67-04243b52cd49',16,'51d0d3cbee924cf1ab4c449b1d345d19','snapshots',-1,'2025-11-24 10:05:23','74d04172-2c32-4af1-97e0-85082bfd6aa2'),('2025-11-23 10:05:23.951532',NULL,'2025-11-23 10:05:23.966970',96,96,NULL,'e8baec53-a528-4d0f-a301-b3858b8fc5b2',15,'51d0d3cbee924cf1ab4c449b1d345d19','snapshot_gigabytes',-1,'2025-11-24 10:05:23','74d04172-2c32-4af1-97e0-85082bfd6aa2'),('2025-11-23 10:05:24.411908',NULL,'2025-11-23 10:05:24.497315',97,97,'3c75003597274dc4827eada967672238','cf12b618-eb67-4393-bde1-eb3bc0ad26e8',29,'7ffe6bcd62184dda84133a0cc0a4e224','share_networks',1,'2025-11-24 10:05:24',NULL),('2025-11-23 10:05:24.870111',NULL,'2025-11-23 10:05:24.877213',98,98,'3c75003597274dc4827eada967672238','9dc92b15-9f5b-4371-ae39-6d68cb0b04a0',29,'7ffe6bcd62184dda84133a0cc0a4e224','share_networks',-1,'2025-11-24 10:05:24',NULL),('2025-11-23 10:05:24.940450',NULL,'2025-11-23 10:05:24.979669',99,99,'3c75003597274dc4827eada967672238','b67bf03c-413f-42f1-a061-2caa46081119',29,'7ffe6bcd62184dda84133a0cc0a4e224','share_networks',1,'2025-11-24 10:05:24',NULL),('2025-11-23 10:05:25.358248',NULL,'2025-11-23 10:05:25.363681',100,100,'3c75003597274dc4827eada967672238','8632047b-5b39-4def-8a5c-1a0bde085695',29,'7ffe6bcd62184dda84133a0cc0a4e224','share_networks',-1,'2025-11-24 10:05:25',NULL),('2025-11-23 10:05:25.457427',NULL,'2025-11-23 10:05:25.509347',101,101,'3c75003597274dc4827eada967672238','11cc3011-b866-4996-9bb3-b0838be324b5',29,'7ffe6bcd62184dda84133a0cc0a4e224','share_networks',1,'2025-11-24 10:05:25',NULL),('2025-11-23 10:05:25.892285',NULL,'2025-11-23 10:05:25.898093',102,102,'3c75003597274dc4827eada967672238','e05a6d4f-3a5c-4182-b4b8-87685dcbd4f7',29,'7ffe6bcd62184dda84133a0cc0a4e224','share_networks',-1,'2025-11-24 10:05:25',NULL),('2025-11-23 10:05:26.924453',NULL,'2025-11-23 10:05:27.027109',103,103,'cd47d55f3345423888e76431c4ceb067','067b8ca0-0899-4e37-95a1-4127f90972bf',26,'980c7c21c34748d78f83541fa493dd05','snapshots',1,'2025-11-24 10:05:26',NULL),('2025-11-23 10:05:26.926442',NULL,'2025-11-23 10:05:27.027109',104,104,'cd47d55f3345423888e76431c4ceb067','233ee957-8e3a-4dee-9474-b7fc2d51b830',25,'980c7c21c34748d78f83541fa493dd05','snapshot_gigabytes',1,'2025-11-24 10:05:26',NULL),('2025-11-23 10:05:26.940736',NULL,'2025-11-23 10:05:27.027109',105,105,NULL,'b5a69fcd-3685-440a-9d09-f01a4fe52446',28,'980c7c21c34748d78f83541fa493dd05','snapshots',1,'2025-11-24 10:05:26','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:26.943925',NULL,'2025-11-23 10:05:27.027109',106,106,NULL,'9601189f-b052-4193-b6dc-8da9acfb34ba',27,'980c7c21c34748d78f83541fa493dd05','snapshot_gigabytes',1,'2025-11-24 10:05:26','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:27.183681',NULL,'2025-11-23 10:05:27.244878',107,107,'90cea60d49c344f1a49f93c6695603ba','f5470f77-5d4f-4159-b33e-b79402762e13',10,'51d0d3cbee924cf1ab4c449b1d345d19','shares',-1,'2025-11-24 10:05:27',NULL),('2025-11-23 10:05:27.185543',NULL,'2025-11-23 10:05:27.244878',108,108,'90cea60d49c344f1a49f93c6695603ba','5e782bb7-eba8-455f-85c2-e4dc1b75cd24',9,'51d0d3cbee924cf1ab4c449b1d345d19','gigabytes',-1,'2025-11-24 10:05:27',NULL),('2025-11-23 10:05:27.231962',NULL,'2025-11-23 10:05:27.244878',109,109,NULL,'d0fd468e-13cf-4bef-85c7-3bbbabee4073',12,'51d0d3cbee924cf1ab4c449b1d345d19','shares',-1,'2025-11-24 10:05:27','74d04172-2c32-4af1-97e0-85082bfd6aa2'),('2025-11-23 10:05:27.233152',NULL,'2025-11-23 10:05:27.244878',110,110,NULL,'073836d0-62b6-4a5f-8ca6-4d9827676b4d',11,'51d0d3cbee924cf1ab4c449b1d345d19','gigabytes',-1,'2025-11-24 10:05:27','74d04172-2c32-4af1-97e0-85082bfd6aa2'),('2025-11-23 10:05:30.506578',NULL,'2025-11-23 10:05:30.595458',111,111,'cd47d55f3345423888e76431c4ceb067','b027d594-e483-41d4-b4eb-c342c0907b9b',26,'980c7c21c34748d78f83541fa493dd05','snapshots',1,'2025-11-24 10:05:30',NULL),('2025-11-23 10:05:30.507782',NULL,'2025-11-23 10:05:30.595458',112,112,'cd47d55f3345423888e76431c4ceb067','b80ef623-9c8b-46fd-b23b-24b6c8900cbf',25,'980c7c21c34748d78f83541fa493dd05','snapshot_gigabytes',1,'2025-11-24 10:05:30',NULL),('2025-11-23 10:05:30.521002',NULL,'2025-11-23 10:05:30.595458',113,113,NULL,'69ac95d0-db6d-4366-a15f-6ddbdf185599',28,'980c7c21c34748d78f83541fa493dd05','snapshots',1,'2025-11-24 10:05:30','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:30.522451',NULL,'2025-11-23 10:05:30.595458',114,114,NULL,'5c1a07c4-e1ed-4e7b-906b-9a485111dc34',27,'980c7c21c34748d78f83541fa493dd05','snapshot_gigabytes',1,'2025-11-24 10:05:30','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:32.708376',NULL,'2025-11-23 10:05:32.742469',115,115,'b0ef51fd6dbc4bd890a74e7dba8b099d','fb440ca0-a2ec-4b50-b0d1-6081a185c77a',31,'3aaf8109aeae4e8a9d20b032d4f40021','shares',1,'2025-11-24 10:05:32',NULL),('2025-11-23 10:05:32.709572',NULL,'2025-11-23 10:05:32.742469',116,116,'b0ef51fd6dbc4bd890a74e7dba8b099d','ff252c8f-931d-44d3-9668-9144d87cda6d',30,'3aaf8109aeae4e8a9d20b032d4f40021','gigabytes',1,'2025-11-24 10:05:32',NULL),('2025-11-23 10:05:32.719681',NULL,'2025-11-23 10:05:32.742469',117,117,NULL,'285cd10f-2133-4daf-9824-5c409de93eac',33,'3aaf8109aeae4e8a9d20b032d4f40021','shares',1,'2025-11-24 10:05:32','2fc5dfcd-9e0c-4d96-b681-9b6f96aa16fe'),('2025-11-23 10:05:32.720805',NULL,'2025-11-23 10:05:32.742469',118,118,NULL,'f530351a-9ad7-496f-bb56-4dc74c32cc69',32,'3aaf8109aeae4e8a9d20b032d4f40021','gigabytes',1,'2025-11-24 10:05:32','2fc5dfcd-9e0c-4d96-b681-9b6f96aa16fe'),('2025-11-23 10:05:34.284356',NULL,'2025-11-23 10:05:34.353014',119,119,'cd47d55f3345423888e76431c4ceb067','ee503454-72f1-48f6-99cb-97b0f003c2cb',26,'980c7c21c34748d78f83541fa493dd05','snapshots',1,'2025-11-24 10:05:34',NULL),('2025-11-23 10:05:34.286108',NULL,'2025-11-23 10:05:34.353014',120,120,'cd47d55f3345423888e76431c4ceb067','ac6a666b-73e0-478d-b74a-2a606946599c',25,'980c7c21c34748d78f83541fa493dd05','snapshot_gigabytes',1,'2025-11-24 10:05:34',NULL),('2025-11-23 10:05:34.292466',NULL,'2025-11-23 10:05:34.353014',121,121,NULL,'45625a98-164c-46d8-a7f6-e3d0b4d39789',28,'980c7c21c34748d78f83541fa493dd05','snapshots',1,'2025-11-24 10:05:34','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:34.293631',NULL,'2025-11-23 10:05:34.353014',122,122,NULL,'82bf2384-bc7e-45b0-bdc2-b0a66ce5b994',27,'980c7c21c34748d78f83541fa493dd05','snapshot_gigabytes',1,'2025-11-24 10:05:34','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:36.015128',NULL,'2025-11-23 10:05:36.141532',123,123,'b0ef51fd6dbc4bd890a74e7dba8b099d','325fb2d4-0cf8-4641-8917-2306bb6f89a4',35,'3aaf8109aeae4e8a9d20b032d4f40021','snapshots',1,'2025-11-24 10:05:35',NULL),('2025-11-23 10:05:36.017000',NULL,'2025-11-23 10:05:36.141532',124,124,'b0ef51fd6dbc4bd890a74e7dba8b099d','4d602199-8456-4e63-b0a5-244db8ad1619',34,'3aaf8109aeae4e8a9d20b032d4f40021','snapshot_gigabytes',1,'2025-11-24 10:05:35',NULL),('2025-11-23 10:05:36.028520',NULL,'2025-11-23 10:05:36.141532',125,125,NULL,'27152726-1f73-42fc-8c51-95c1f1bdfa06',37,'3aaf8109aeae4e8a9d20b032d4f40021','snapshots',1,'2025-11-24 10:05:35','2fc5dfcd-9e0c-4d96-b681-9b6f96aa16fe'),('2025-11-23 10:05:36.029607',NULL,'2025-11-23 10:05:36.141532',126,126,NULL,'5972fd38-630c-471b-9104-22f049befa18',36,'3aaf8109aeae4e8a9d20b032d4f40021','snapshot_gigabytes',1,'2025-11-24 10:05:35','2fc5dfcd-9e0c-4d96-b681-9b6f96aa16fe'),('2025-11-23 10:05:37.865258',NULL,'2025-11-23 10:05:37.954213',127,127,'cd47d55f3345423888e76431c4ceb067','30e1f620-df3a-46e4-9b36-dfb10d58d58e',26,'980c7c21c34748d78f83541fa493dd05','snapshots',1,'2025-11-24 10:05:37',NULL),('2025-11-23 10:05:37.867496',NULL,'2025-11-23 10:05:37.954213',128,128,'cd47d55f3345423888e76431c4ceb067','1e7df4e9-4a3c-47c5-b811-f7c8b85c09af',25,'980c7c21c34748d78f83541fa493dd05','snapshot_gigabytes',1,'2025-11-24 10:05:37',NULL),('2025-11-23 10:05:37.877732',NULL,'2025-11-23 10:05:37.954213',129,129,NULL,'0f63edc4-1220-4e46-8328-de014898af14',28,'980c7c21c34748d78f83541fa493dd05','snapshots',1,'2025-11-24 10:05:37','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:37.879844',NULL,'2025-11-23 10:05:37.954213',130,130,NULL,'9df7595b-6c99-42d8-8ca7-83ff760d4c17',27,'980c7c21c34748d78f83541fa493dd05','snapshot_gigabytes',1,'2025-11-24 10:05:37','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:39.754792',NULL,'2025-11-23 10:05:39.768340',131,131,'b0ef51fd6dbc4bd890a74e7dba8b099d','11ad9688-845e-4c48-a2d2-0ac9d166a339',35,'3aaf8109aeae4e8a9d20b032d4f40021','snapshots',-1,'2025-11-24 10:05:39',NULL),('2025-11-23 10:05:39.755571',NULL,'2025-11-23 10:05:39.768340',132,132,'b0ef51fd6dbc4bd890a74e7dba8b099d','d2cd7710-96a9-46c8-9786-b8ee929d1937',34,'3aaf8109aeae4e8a9d20b032d4f40021','snapshot_gigabytes',-1,'2025-11-24 10:05:39',NULL),('2025-11-23 10:05:39.761594',NULL,'2025-11-23 10:05:39.768340',133,133,NULL,'29ac00b2-9a6f-49a3-b604-2f7de16bf561',37,'3aaf8109aeae4e8a9d20b032d4f40021','snapshots',-1,'2025-11-24 10:05:39','2fc5dfcd-9e0c-4d96-b681-9b6f96aa16fe'),('2025-11-23 10:05:39.762270',NULL,'2025-11-23 10:05:39.768340',134,134,NULL,'3aafefa4-ae92-4e84-a840-14f5fe375ea8',36,'3aaf8109aeae4e8a9d20b032d4f40021','snapshot_gigabytes',-1,'2025-11-24 10:05:39','2fc5dfcd-9e0c-4d96-b681-9b6f96aa16fe'),('2025-11-23 10:05:40.603804',NULL,'2025-11-23 10:05:40.812496',135,135,'6b2d4ce74f314f569d20a814d7857aea','d903a42d-90ca-49c7-baf5-1a04eca12716',39,'0dcc58766ad44287910595c5c8f14397','shares',1,'2025-11-24 10:05:40',NULL),('2025-11-23 10:05:40.605004',NULL,'2025-11-23 10:05:40.812496',136,136,'6b2d4ce74f314f569d20a814d7857aea','6fa410dd-b6a5-4713-a8c6-0d1cdaae1f40',38,'0dcc58766ad44287910595c5c8f14397','gigabytes',1,'2025-11-24 10:05:40',NULL),('2025-11-23 10:05:40.613936',NULL,'2025-11-23 10:05:40.812496',137,137,NULL,'0910ffb1-0f36-4bb9-82ea-d29335922407',41,'0dcc58766ad44287910595c5c8f14397','shares',1,'2025-11-24 10:05:40','8ac24231-78d9-4538-8f95-8763239b9d36'),('2025-11-23 10:05:40.615083',NULL,'2025-11-23 10:05:40.812496',138,138,NULL,'84755a2f-e57f-4c32-9243-bc162650de1d',40,'0dcc58766ad44287910595c5c8f14397','gigabytes',1,'2025-11-24 10:05:40','8ac24231-78d9-4538-8f95-8763239b9d36'),('2025-11-23 10:05:41.909839',NULL,'2025-11-23 10:05:41.930402',139,139,'cd47d55f3345423888e76431c4ceb067','f2b46040-2f34-4d88-945f-d3085a4e1b1e',26,'980c7c21c34748d78f83541fa493dd05','snapshots',-1,'2025-11-24 10:05:41',NULL),('2025-11-23 10:05:41.910614',NULL,'2025-11-23 10:05:41.930402',140,140,'cd47d55f3345423888e76431c4ceb067','aa1da488-7676-441a-b513-1e38ad160338',25,'980c7c21c34748d78f83541fa493dd05','snapshot_gigabytes',-1,'2025-11-24 10:05:41',NULL),('2025-11-23 10:05:41.917792',NULL,'2025-11-23 10:05:41.930402',141,141,NULL,'4ffdffa3-7ad8-4f0a-a154-866be457fefa',28,'980c7c21c34748d78f83541fa493dd05','snapshots',-1,'2025-11-24 10:05:41','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:41.918676',NULL,'2025-11-23 10:05:41.930402',142,142,NULL,'468d42f1-3e07-412a-ba1b-eea31cd3c166',27,'980c7c21c34748d78f83541fa493dd05','snapshot_gigabytes',-1,'2025-11-24 10:05:41','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:43.240347',NULL,'2025-11-23 10:05:43.257499',143,143,'b0ef51fd6dbc4bd890a74e7dba8b099d','49061103-dc71-4847-8eff-7efab683242b',31,'3aaf8109aeae4e8a9d20b032d4f40021','shares',-1,'2025-11-24 10:05:43',NULL),('2025-11-23 10:05:43.241164',NULL,'2025-11-23 10:05:43.257499',144,144,'b0ef51fd6dbc4bd890a74e7dba8b099d','564fe647-2f0a-42b0-8f49-a61040b523f9',30,'3aaf8109aeae4e8a9d20b032d4f40021','gigabytes',-1,'2025-11-24 10:05:43',NULL),('2025-11-23 10:05:43.247034',NULL,'2025-11-23 10:05:43.257499',145,145,NULL,'91fddff2-34be-4ef3-a236-fb67f6c790a0',33,'3aaf8109aeae4e8a9d20b032d4f40021','shares',-1,'2025-11-24 10:05:43','2fc5dfcd-9e0c-4d96-b681-9b6f96aa16fe'),('2025-11-23 10:05:43.247783',NULL,'2025-11-23 10:05:43.257499',146,146,NULL,'2937183d-fb6e-4e22-bef5-985d3e09da0b',32,'3aaf8109aeae4e8a9d20b032d4f40021','gigabytes',-1,'2025-11-24 10:05:43','2fc5dfcd-9e0c-4d96-b681-9b6f96aa16fe'),('2025-11-23 10:05:45.145164',NULL,'2025-11-23 10:05:45.169397',147,147,'cd47d55f3345423888e76431c4ceb067','996393a7-f10f-4ab9-b783-daa90789025b',26,'980c7c21c34748d78f83541fa493dd05','snapshots',-1,'2025-11-24 10:05:45',NULL),('2025-11-23 10:05:45.147409',NULL,'2025-11-23 10:05:45.169397',148,148,'cd47d55f3345423888e76431c4ceb067','d7266c9c-e82b-4f24-87aa-3df99b7dd986',25,'980c7c21c34748d78f83541fa493dd05','snapshot_gigabytes',-1,'2025-11-24 10:05:45',NULL),('2025-11-23 10:05:45.157270',NULL,'2025-11-23 10:05:45.169397',149,149,NULL,'e3dbd490-645c-403d-acb3-8ef763aaabbe',28,'980c7c21c34748d78f83541fa493dd05','snapshots',-1,'2025-11-24 10:05:45','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:45.158334',NULL,'2025-11-23 10:05:45.169397',150,150,NULL,'c6346c9f-2005-4da9-bdd3-aea669e44795',27,'980c7c21c34748d78f83541fa493dd05','snapshot_gigabytes',-1,'2025-11-24 10:05:45','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:46.165455',NULL,'2025-11-23 10:05:46.214875',151,151,'b0ef51fd6dbc4bd890a74e7dba8b099d','634c6cc4-314e-44ec-95a8-1fb51e55e4d0',31,'3aaf8109aeae4e8a9d20b032d4f40021','shares',1,'2025-11-24 10:05:46',NULL),('2025-11-23 10:05:46.167174',NULL,'2025-11-23 10:05:46.214875',152,152,'b0ef51fd6dbc4bd890a74e7dba8b099d','7b86eb43-f6f2-4af2-858e-bc4822f12dba',30,'3aaf8109aeae4e8a9d20b032d4f40021','gigabytes',1,'2025-11-24 10:05:46',NULL),('2025-11-23 10:05:46.178406',NULL,'2025-11-23 10:05:46.214875',153,153,NULL,'8c1eb337-173b-482a-bc1a-9f7bbe38dd91',43,'3aaf8109aeae4e8a9d20b032d4f40021','shares',1,'2025-11-24 10:05:46','b4fe0825-4171-413a-a33a-2032d7a30416'),('2025-11-23 10:05:46.179985',NULL,'2025-11-23 10:05:46.214875',154,154,NULL,'2e89ad89-8fe2-464c-9c14-ec41d5fc721b',42,'3aaf8109aeae4e8a9d20b032d4f40021','gigabytes',1,'2025-11-24 10:05:46','b4fe0825-4171-413a-a33a-2032d7a30416'),('2025-11-23 10:05:48.454885',NULL,'2025-11-23 10:05:48.477162',155,155,'cd47d55f3345423888e76431c4ceb067','2935027a-0f24-42c1-b82d-28576066e44d',26,'980c7c21c34748d78f83541fa493dd05','snapshots',-1,'2025-11-24 10:05:48',NULL),('2025-11-23 10:05:48.455802',NULL,'2025-11-23 10:05:48.477162',156,156,'cd47d55f3345423888e76431c4ceb067','9b17958b-1cd0-43d8-bd24-1c8b22dad04f',25,'980c7c21c34748d78f83541fa493dd05','snapshot_gigabytes',-1,'2025-11-24 10:05:48',NULL),('2025-11-23 10:05:48.462691',NULL,'2025-11-23 10:05:48.477162',157,157,NULL,'371727d1-b319-46a4-bbf9-4bdfb9b0f78e',28,'980c7c21c34748d78f83541fa493dd05','snapshots',-1,'2025-11-24 10:05:48','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:48.463813',NULL,'2025-11-23 10:05:48.477162',158,158,NULL,'775fd541-ef79-4fed-bd4d-70668b1409d0',27,'980c7c21c34748d78f83541fa493dd05','snapshot_gigabytes',-1,'2025-11-24 10:05:48','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:50.090305',NULL,'2025-11-23 10:05:50.122803',159,159,'b0ef51fd6dbc4bd890a74e7dba8b099d','4dd7b777-c96c-4b6e-8283-d50615a85b24',31,'3aaf8109aeae4e8a9d20b032d4f40021','shares',-1,'2025-11-24 10:05:50',NULL),('2025-11-23 10:05:50.093827',NULL,'2025-11-23 10:05:50.122803',160,160,'b0ef51fd6dbc4bd890a74e7dba8b099d','12838958-b167-4d9f-8a9c-8a39d3bab390',30,'3aaf8109aeae4e8a9d20b032d4f40021','gigabytes',-1,'2025-11-24 10:05:50',NULL),('2025-11-23 10:05:50.104599',NULL,'2025-11-23 10:05:50.122803',161,161,NULL,'610bb3a8-cb39-45f0-af26-8f7b64385877',43,'3aaf8109aeae4e8a9d20b032d4f40021','shares',-1,'2025-11-24 10:05:50','b4fe0825-4171-413a-a33a-2032d7a30416'),('2025-11-23 10:05:50.106888',NULL,'2025-11-23 10:05:50.122803',162,162,NULL,'4dd1fded-742d-4bf0-a806-4d6b20ff57f2',42,'3aaf8109aeae4e8a9d20b032d4f40021','gigabytes',-1,'2025-11-24 10:05:50','b4fe0825-4171-413a-a33a-2032d7a30416'),('2025-11-23 10:05:50.365375',NULL,'2025-11-23 10:05:50.402285',163,163,'90c18b36e7c142a2ba912fda344bf32a','3914e444-1a66-46f6-9038-b9921afd1a66',45,'639b50f98a2a45ed93803ee22072bc7a','shares',1,'2025-11-24 10:05:50',NULL),('2025-11-23 10:05:50.366532',NULL,'2025-11-23 10:05:50.402285',164,164,'90c18b36e7c142a2ba912fda344bf32a','e8c02a88-e5da-413d-aca4-c64009b03848',44,'639b50f98a2a45ed93803ee22072bc7a','gigabytes',4,'2025-11-24 10:05:50',NULL),('2025-11-23 10:05:50.378535',NULL,'2025-11-23 10:05:50.402285',165,165,NULL,'14c999f2-513f-423c-9a9f-72504c11ff0d',47,'639b50f98a2a45ed93803ee22072bc7a','shares',1,'2025-11-24 10:05:50','99151306-b5f7-456e-9654-b87f7fce3c14'),('2025-11-23 10:05:50.379618',NULL,'2025-11-23 10:05:50.402285',166,166,NULL,'2ed8124b-fc3b-423d-b05b-99fac87d7fa3',46,'639b50f98a2a45ed93803ee22072bc7a','gigabytes',4,'2025-11-24 10:05:50','99151306-b5f7-456e-9654-b87f7fce3c14'),('2025-11-23 10:05:51.606611',NULL,'2025-11-23 10:05:51.629740',167,167,'cd47d55f3345423888e76431c4ceb067','3c44605f-f69f-42c0-ad34-20bc364e1b16',26,'980c7c21c34748d78f83541fa493dd05','snapshots',-1,'2025-11-24 10:05:51',NULL),('2025-11-23 10:05:51.607906',NULL,'2025-11-23 10:05:51.629740',168,168,'cd47d55f3345423888e76431c4ceb067','d39ab5eb-b513-4c1e-a657-5388d5573e67',25,'980c7c21c34748d78f83541fa493dd05','snapshot_gigabytes',-1,'2025-11-24 10:05:51',NULL),('2025-11-23 10:05:51.614718',NULL,'2025-11-23 10:05:51.629740',169,169,NULL,'45f3961d-9109-4306-b34d-b5e2b489bd2b',28,'980c7c21c34748d78f83541fa493dd05','snapshots',-1,'2025-11-24 10:05:51','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:51.615557',NULL,'2025-11-23 10:05:51.629740',170,170,NULL,'c6ec16ba-2e9c-4499-bbbb-aed998fd21a9',27,'980c7c21c34748d78f83541fa493dd05','snapshot_gigabytes',-1,'2025-11-24 10:05:51','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:52.986917',NULL,'2025-11-23 10:05:53.036933',171,171,'b0ef51fd6dbc4bd890a74e7dba8b099d','0396a5b0-139e-4c62-8545-dc292e620f01',31,'3aaf8109aeae4e8a9d20b032d4f40021','shares',1,'2025-11-24 10:05:52',NULL),('2025-11-23 10:05:52.989006',NULL,'2025-11-23 10:05:53.036933',172,172,'b0ef51fd6dbc4bd890a74e7dba8b099d','4e0e4fe7-5094-4372-980f-7e816e3d41ff',30,'3aaf8109aeae4e8a9d20b032d4f40021','gigabytes',1,'2025-11-24 10:05:52',NULL),('2025-11-23 10:05:53.002732',NULL,'2025-11-23 10:05:53.036933',173,173,NULL,'072408e8-f613-4eb0-b901-562e1e3478a0',49,'3aaf8109aeae4e8a9d20b032d4f40021','shares',1,'2025-11-24 10:05:52','bdc5dc05-5cbf-414e-ad7e-a3fb7edf1118'),('2025-11-23 10:05:53.005402',NULL,'2025-11-23 10:05:53.036933',174,174,NULL,'51a054d4-5fc3-4364-9e45-21dbacf30cdd',48,'3aaf8109aeae4e8a9d20b032d4f40021','gigabytes',1,'2025-11-24 10:05:52','bdc5dc05-5cbf-414e-ad7e-a3fb7edf1118'),('2025-11-23 10:05:53.639050',NULL,'2025-11-23 10:05:53.670892',175,175,'90c18b36e7c142a2ba912fda344bf32a','8303a838-9e2c-4666-bdac-e826d8bb8aee',45,'639b50f98a2a45ed93803ee22072bc7a','shares',1,'2025-11-24 10:05:53',NULL),('2025-11-23 10:05:53.641392',NULL,'2025-11-23 10:05:53.670892',176,176,'90c18b36e7c142a2ba912fda344bf32a','ba4e0409-558b-43fe-a21f-0fb3914136b1',44,'639b50f98a2a45ed93803ee22072bc7a','gigabytes',3,'2025-11-24 10:05:53',NULL),('2025-11-23 10:05:53.929237',NULL,'2025-11-23 10:05:54.029619',177,177,'90c18b36e7c142a2ba912fda344bf32a','9efff7ac-4d05-4a3c-babb-7cae603954e9',45,'639b50f98a2a45ed93803ee22072bc7a','shares',1,'2025-11-24 10:05:53',NULL),('2025-11-23 10:05:53.930481',NULL,'2025-11-23 10:05:54.029619',178,178,'90c18b36e7c142a2ba912fda344bf32a','a6ab1b15-a4ed-47fe-9b25-ba19485dcaf7',44,'639b50f98a2a45ed93803ee22072bc7a','gigabytes',3,'2025-11-24 10:05:53',NULL),('2025-11-23 10:05:53.957568',NULL,'2025-11-23 10:05:54.029619',179,179,NULL,'5552f965-dfc6-462d-af0b-699e79e64545',51,'639b50f98a2a45ed93803ee22072bc7a','shares',1,'2025-11-24 10:05:53','d5d2e2e3-4017-48ae-844f-f8d420bd9060'),('2025-11-23 10:05:53.959268',NULL,'2025-11-23 10:05:54.029619',180,180,NULL,'7956d2f7-da10-46a2-a0c2-120b82c19abb',50,'639b50f98a2a45ed93803ee22072bc7a','gigabytes',3,'2025-11-24 10:05:53','d5d2e2e3-4017-48ae-844f-f8d420bd9060'),('2025-11-23 10:05:55.150290',NULL,'2025-11-23 10:05:55.225838',181,181,'cd47d55f3345423888e76431c4ceb067','120a2092-9939-4a51-bbdf-2f7e09b77b5e',26,'980c7c21c34748d78f83541fa493dd05','snapshots',-1,'2025-11-24 10:05:55',NULL),('2025-11-23 10:05:55.151364',NULL,'2025-11-23 10:05:55.225838',182,182,'cd47d55f3345423888e76431c4ceb067','fa996568-5668-4a56-b257-0c7f6d054422',25,'980c7c21c34748d78f83541fa493dd05','snapshot_gigabytes',-1,'2025-11-24 10:05:55',NULL),('2025-11-23 10:05:55.210406',NULL,'2025-11-23 10:05:55.225838',183,183,NULL,'9a65281a-89c3-4eb7-86cf-bf074ce65168',28,'980c7c21c34748d78f83541fa493dd05','snapshots',-1,'2025-11-24 10:05:55','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:55.211457',NULL,'2025-11-23 10:05:55.225838',184,184,NULL,'25c17059-6264-467f-a088-eae8da6ec214',27,'980c7c21c34748d78f83541fa493dd05','snapshot_gigabytes',-1,'2025-11-24 10:05:55','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:56.313227',NULL,'2025-11-23 10:05:56.393515',185,185,'b0ef51fd6dbc4bd890a74e7dba8b099d','4a90fb9a-ba60-4b34-be57-876614c29076',35,'3aaf8109aeae4e8a9d20b032d4f40021','snapshots',1,'2025-11-24 10:05:56',NULL),('2025-11-23 10:05:56.314556',NULL,'2025-11-23 10:05:56.393515',186,186,'b0ef51fd6dbc4bd890a74e7dba8b099d','32ee8b9f-6f86-48ec-a3eb-4a64b4bb86ff',34,'3aaf8109aeae4e8a9d20b032d4f40021','snapshot_gigabytes',1,'2025-11-24 10:05:56',NULL),('2025-11-23 10:05:56.329383',NULL,'2025-11-23 10:05:56.393515',187,187,NULL,'5d1b35bc-33b9-4de7-bf83-b6d06d1f1b16',53,'3aaf8109aeae4e8a9d20b032d4f40021','snapshots',1,'2025-11-24 10:05:56','bdc5dc05-5cbf-414e-ad7e-a3fb7edf1118'),('2025-11-23 10:05:56.330613',NULL,'2025-11-23 10:05:56.393515',188,188,NULL,'ea7bca62-d5fc-45f6-b964-243c12bc6790',52,'3aaf8109aeae4e8a9d20b032d4f40021','snapshot_gigabytes',1,'2025-11-24 10:05:56','bdc5dc05-5cbf-414e-ad7e-a3fb7edf1118'),('2025-11-23 10:05:57.733981',NULL,'2025-11-23 10:05:57.754894',189,189,'90c18b36e7c142a2ba912fda344bf32a','b0d902da-ddb6-46a1-80e7-017f661b1e51',45,'639b50f98a2a45ed93803ee22072bc7a','shares',-1,'2025-11-24 10:05:57',NULL),('2025-11-23 10:05:57.735030',NULL,'2025-11-23 10:05:57.754894',190,190,'90c18b36e7c142a2ba912fda344bf32a','23a2a8dd-1f27-4d55-be11-e15de59099f5',44,'639b50f98a2a45ed93803ee22072bc7a','gigabytes',-4,'2025-11-24 10:05:57',NULL),('2025-11-23 10:05:57.745016',NULL,'2025-11-23 10:05:57.754894',191,191,NULL,'04e10b0a-c116-40e7-87dc-59fca9815727',47,'639b50f98a2a45ed93803ee22072bc7a','shares',-1,'2025-11-24 10:05:57','99151306-b5f7-456e-9654-b87f7fce3c14'),('2025-11-23 10:05:57.745868',NULL,'2025-11-23 10:05:57.754894',192,192,NULL,'684c0a13-c4ef-4c73-b7e2-dc4954e5ff4a',46,'639b50f98a2a45ed93803ee22072bc7a','gigabytes',-4,'2025-11-24 10:05:57','99151306-b5f7-456e-9654-b87f7fce3c14'),('2025-11-23 10:05:58.397233',NULL,'2025-11-23 10:05:58.411014',193,193,'cd47d55f3345423888e76431c4ceb067','75fd26e0-7554-47a4-bbdd-3dcf463f0ab5',18,'980c7c21c34748d78f83541fa493dd05','shares',-1,'2025-11-24 10:05:58',NULL),('2025-11-23 10:05:58.398429',NULL,'2025-11-23 10:05:58.411014',194,194,'cd47d55f3345423888e76431c4ceb067','c0340152-741f-4cc7-ae5b-794e8be2a3f3',17,'980c7c21c34748d78f83541fa493dd05','gigabytes',-1,'2025-11-24 10:05:58',NULL),('2025-11-23 10:05:58.404203',NULL,'2025-11-23 10:05:58.411014',195,195,NULL,'66e6a7d5-2c7a-41a6-a0ba-bd8a4ab7312b',20,'980c7c21c34748d78f83541fa493dd05','shares',-1,'2025-11-24 10:05:58','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:58.404841',NULL,'2025-11-23 10:05:58.411014',196,196,NULL,'ab79f1a5-f610-46df-b746-ab5addd5bf82',19,'980c7c21c34748d78f83541fa493dd05','gigabytes',-1,'2025-11-24 10:05:58','43c0da9c-000f-48ba-86bb-aaa7a47fc6dd'),('2025-11-23 10:05:59.697846',NULL,'2025-11-23 10:05:59.735518',197,197,'b0ef51fd6dbc4bd890a74e7dba8b099d','2b446f62-1179-48b1-b1a9-0846df0f4a18',31,'3aaf8109aeae4e8a9d20b032d4f40021','shares',1,'2025-11-24 10:05:59',NULL),('2025-11-23 10:05:59.699113',NULL,'2025-11-23 10:05:59.735518',198,198,'b0ef51fd6dbc4bd890a74e7dba8b099d','f03e2f1a-84d1-4a00-b3c6-c64705628f53',30,'3aaf8109aeae4e8a9d20b032d4f40021','gigabytes',1,'2025-11-24 10:05:59',NULL),('2025-11-23 10:05:59.704285',NULL,'2025-11-23 10:05:59.735518',199,199,NULL,'9fd3558b-ee1e-4dba-b6cb-36674fd8be6f',49,'3aaf8109aeae4e8a9d20b032d4f40021','shares',1,'2025-11-24 10:05:59','bdc5dc05-5cbf-414e-ad7e-a3fb7edf1118'),('2025-11-23 10:05:59.705359',NULL,'2025-11-23 10:05:59.735518',200,200,NULL,'7e817004-5cbe-4062-b8e9-797931539036',48,'3aaf8109aeae4e8a9d20b032d4f40021','gigabytes',1,'2025-11-24 10:05:59','bdc5dc05-5cbf-414e-ad7e-a3fb7edf1118'),('2025-11-23 10:06:03.560827',NULL,'2025-11-23 10:06:03.582073',201,201,'90c18b36e7c142a2ba912fda344bf32a','55e529ac-202f-4d48-aa90-1273e28607a3',45,'639b50f98a2a45ed93803ee22072bc7a','shares',-1,'2025-11-24 10:06:03',NULL),('2025-11-23 10:06:03.561898',NULL,'2025-11-23 10:06:03.582073',202,202,'90c18b36e7c142a2ba912fda344bf32a','85987ca2-592b-4f68-8bec-79882d46cde1',44,'639b50f98a2a45ed93803ee22072bc7a','gigabytes',-3,'2025-11-24 10:06:03',NULL),('2025-11-23 10:06:03.568507',NULL,'2025-11-23 10:06:03.582073',203,203,NULL,'13c7c28a-5e72-4405-9476-3c5e76d7b5dc',51,'639b50f98a2a45ed93803ee22072bc7a','shares',-1,'2025-11-24 10:06:03','d5d2e2e3-4017-48ae-844f-f8d420bd9060'),('2025-11-23 10:06:03.569769',NULL,'2025-11-23 10:06:03.582073',204,204,NULL,'41ffb9c9-07c9-4f06-991d-fe69e2665d1c',50,'639b50f98a2a45ed93803ee22072bc7a','gigabytes',-3,'2025-11-24 10:06:03','d5d2e2e3-4017-48ae-844f-f8d420bd9060'),('2025-11-23 10:06:04.167548',NULL,'2025-11-23 10:06:04.219984',205,205,'6b2d4ce74f314f569d20a814d7857aea','1d161d48-d730-4566-9e06-cf0f54536ce6',39,'0dcc58766ad44287910595c5c8f14397','shares',-1,'2025-11-24 10:06:04',NULL),('2025-11-23 10:06:04.200604',NULL,'2025-11-23 10:06:04.219984',206,206,'6b2d4ce74f314f569d20a814d7857aea','1e0af309-b15e-4c74-a71f-f6741233e368',38,'0dcc58766ad44287910595c5c8f14397','gigabytes',-1,'2025-11-24 10:06:04',NULL),('2025-11-23 10:06:04.210851',NULL,'2025-11-23 10:06:04.219984',207,207,NULL,'d5d11d07-33e3-495d-ada5-f1fcfa553769',41,'0dcc58766ad44287910595c5c8f14397','shares',-1,'2025-11-24 10:06:04','8ac24231-78d9-4538-8f95-8763239b9d36'),('2025-11-23 10:06:04.212617',NULL,'2025-11-23 10:06:04.219984',208,208,NULL,'f6849566-de0e-4c59-bfaf-5fa2a3efd05d',40,'0dcc58766ad44287910595c5c8f14397','gigabytes',-1,'2025-11-24 10:06:04','8ac24231-78d9-4538-8f95-8763239b9d36'),('2025-11-23 10:06:08.842274',NULL,'2025-11-23 10:06:08.911204',209,209,'b52f5d7e2eea4f249832a9e7892a6435','59334a09-a561-45aa-be95-89e4ac11229d',55,'1dcbf043a91e492e9142e84de0186253','shares',1,'2025-11-24 10:06:08',NULL),('2025-11-23 10:06:08.845513',NULL,'2025-11-23 10:06:08.911204',210,210,'b52f5d7e2eea4f249832a9e7892a6435','dbdd6a2f-638d-4a97-a59f-29d622a39dd9',54,'1dcbf043a91e492e9142e84de0186253','gigabytes',1,'2025-11-24 10:06:08',NULL),('2025-11-23 10:06:08.867093',NULL,'2025-11-23 10:06:08.911204',211,211,NULL,'0995a8fe-0932-4e64-89b4-ae7aeea71fe8',57,'1dcbf043a91e492e9142e84de0186253','shares',1,'2025-11-24 10:06:08','c02e5473-a628-4496-98f6-ef85824dd58a'),('2025-11-23 10:06:08.870235',NULL,'2025-11-23 10:06:08.911204',212,212,NULL,'a423b7c0-61f2-4842-8e23-db54b8a42549',56,'1dcbf043a91e492e9142e84de0186253','gigabytes',1,'2025-11-24 10:06:08','c02e5473-a628-4496-98f6-ef85824dd58a'),('2025-11-23 10:06:12.540737',NULL,'2025-11-23 10:06:12.575650',213,213,'b52f5d7e2eea4f249832a9e7892a6435','5cfbdd8f-f51d-4277-8aa1-ac1f8466f34a',59,'1dcbf043a91e492e9142e84de0186253','shares',1,'2025-11-24 10:06:12',NULL),('2025-11-23 10:06:12.542228',NULL,'2025-11-23 10:06:12.575650',214,214,'b52f5d7e2eea4f249832a9e7892a6435','ca46ed1d-5b0f-4c60-b702-791aca2a4167',58,'1dcbf043a91e492e9142e84de0186253','gigabytes',1,'2025-11-24 10:06:12',NULL),('2025-11-23 10:06:12.554266',NULL,'2025-11-23 10:06:12.575650',215,215,NULL,'779222ee-86a1-48bc-b982-5363bcb36c0a',61,'1dcbf043a91e492e9142e84de0186253','shares',1,'2025-11-24 10:06:12','6ec8be50-2b1f-40e8-98cb-a90fe5c90a25'),('2025-11-23 10:06:12.555678',NULL,'2025-11-23 10:06:12.575650',216,216,NULL,'72a22c7c-d9f4-4d13-9cc8-17b86884d2c2',60,'1dcbf043a91e492e9142e84de0186253','gigabytes',1,'2025-11-24 10:06:12','6ec8be50-2b1f-40e8-98cb-a90fe5c90a25'),('2025-11-23 10:06:14.479249',NULL,'2025-11-23 10:06:14.510209',217,217,'1d5eba52d35642b9bb7f834d5bed165a','6280a79c-0259-4b24-97e0-b489c15d4b25',63,'ac0f52e853194f9ea9d27590165c645d','shares',1,'2025-11-24 10:06:14',NULL),('2025-11-23 10:06:14.480575',NULL,'2025-11-23 10:06:14.510209',218,218,'1d5eba52d35642b9bb7f834d5bed165a','54f01ddb-7556-4a69-a25d-334623f3c076',62,'ac0f52e853194f9ea9d27590165c645d','gigabytes',1,'2025-11-24 10:06:14',NULL),('2025-11-23 10:06:14.492017',NULL,'2025-11-23 10:06:14.510209',219,219,NULL,'5bdd89d8-f76c-4365-aabc-144e7d4eceae',65,'ac0f52e853194f9ea9d27590165c645d','shares',1,'2025-11-24 10:06:14','bffdc073-9324-4fb8-8e35-0d9c39e790db'),('2025-11-23 10:06:14.493074',NULL,'2025-11-23 10:06:14.510209',220,220,NULL,'9bd0cdd0-dfe8-4012-a482-f421b72fc781',64,'ac0f52e853194f9ea9d27590165c645d','gigabytes',1,'2025-11-24 10:06:14','bffdc073-9324-4fb8-8e35-0d9c39e790db'),('2025-11-23 10:06:15.847116',NULL,'2025-11-23 10:06:15.940797',221,221,'b52f5d7e2eea4f249832a9e7892a6435','2962c9f6-e387-4b74-8105-4db7d69bc907',67,'1dcbf043a91e492e9142e84de0186253','snapshots',1,'2025-11-24 10:06:15',NULL),('2025-11-23 10:06:15.848490',NULL,'2025-11-23 10:06:15.940797',222,222,'b52f5d7e2eea4f249832a9e7892a6435','395840be-657e-4587-a9b4-b2c9ed156167',66,'1dcbf043a91e492e9142e84de0186253','snapshot_gigabytes',1,'2025-11-24 10:06:15',NULL),('2025-11-23 10:06:15.859521',NULL,'2025-11-23 10:06:15.940797',223,223,NULL,'5e99fb32-dea3-467c-a7f0-93209c3cc383',69,'1dcbf043a91e492e9142e84de0186253','snapshots',1,'2025-11-24 10:06:15','6ec8be50-2b1f-40e8-98cb-a90fe5c90a25'),('2025-11-23 10:06:15.862600',NULL,'2025-11-23 10:06:15.940797',224,224,NULL,'3837976a-2de9-465d-adab-506bcb2a6437',68,'1dcbf043a91e492e9142e84de0186253','snapshot_gigabytes',1,'2025-11-24 10:06:15','6ec8be50-2b1f-40e8-98cb-a90fe5c90a25'),('2025-11-23 10:06:16.322056',NULL,'2025-11-23 10:06:16.382892',225,225,'af5de096454d470598ed1cedeed5495a','828746cf-652b-4040-b2fe-08b50316cc6a',70,'24a8d397352640bea21b3503164c6be5','share_networks',1,'2025-11-24 10:06:16',NULL),('2025-11-23 10:06:19.736296',NULL,'2025-11-23 10:06:19.755210',226,226,'1d5eba52d35642b9bb7f834d5bed165a','653c8e76-643e-4612-8bb2-8d6bf2700ce5',63,'ac0f52e853194f9ea9d27590165c645d','shares',-1,'2025-11-24 10:06:19',NULL),('2025-11-23 10:06:19.738452',NULL,'2025-11-23 10:06:19.755210',227,227,'1d5eba52d35642b9bb7f834d5bed165a','73b113e4-c1f8-455e-a8a7-f37297433aa2',62,'ac0f52e853194f9ea9d27590165c645d','gigabytes',-1,'2025-11-24 10:06:19',NULL),('2025-11-23 10:06:19.746872',NULL,'2025-11-23 10:06:19.755210',228,228,NULL,'afe28b00-74c8-48a6-9076-3dbe6a20bf60',65,'ac0f52e853194f9ea9d27590165c645d','shares',-1,'2025-11-24 10:06:19','bffdc073-9324-4fb8-8e35-0d9c39e790db'),('2025-11-23 10:06:19.748146',NULL,'2025-11-23 10:06:19.755210',229,229,NULL,'72f7145f-cf85-4adb-bc1b-313799820fc3',64,'ac0f52e853194f9ea9d27590165c645d','gigabytes',-1,'2025-11-24 10:06:19','bffdc073-9324-4fb8-8e35-0d9c39e790db'),('2025-11-23 10:06:21.709976',NULL,'2025-11-23 10:06:21.749011',230,230,'b0ef51fd6dbc4bd890a74e7dba8b099d','157f00bb-63ab-400a-b79a-863480a2d8f5',31,'3aaf8109aeae4e8a9d20b032d4f40021','shares',-1,'2025-11-24 10:06:21',NULL),('2025-11-23 10:06:21.712024',NULL,'2025-11-23 10:06:21.749011',231,231,'b0ef51fd6dbc4bd890a74e7dba8b099d','2ce58a34-e5f5-4a12-b981-dc23b124035c',30,'3aaf8109aeae4e8a9d20b032d4f40021','gigabytes',-1,'2025-11-24 10:06:21',NULL),('2025-11-23 10:06:21.725417',NULL,'2025-11-23 10:06:21.749011',232,232,NULL,'2337a783-e858-403c-8aa4-df3ae744d868',49,'3aaf8109aeae4e8a9d20b032d4f40021','shares',-1,'2025-11-24 10:06:21','bdc5dc05-5cbf-414e-ad7e-a3fb7edf1118'),('2025-11-23 10:06:21.726254',NULL,'2025-11-23 10:06:21.749011',233,233,NULL,'c2123540-57ec-4aae-9a66-ea1be4149fa4',48,'3aaf8109aeae4e8a9d20b032d4f40021','gigabytes',-1,'2025-11-24 10:06:21','bdc5dc05-5cbf-414e-ad7e-a3fb7edf1118'),('2025-11-23 10:06:23.194805',NULL,'2025-11-23 10:06:23.229394',234,234,'b52f5d7e2eea4f249832a9e7892a6435','f5b63eeb-02f1-472f-b978-8ba1741bf718',72,'1dcbf043a91e492e9142e84de0186253','snapshots',-1,'2025-11-24 10:06:23',NULL),('2025-11-23 10:06:23.195742',NULL,'2025-11-23 10:06:23.229394',235,235,'b52f5d7e2eea4f249832a9e7892a6435','131f6b4e-1362-44c7-9d51-f91f25e464df',71,'1dcbf043a91e492e9142e84de0186253','snapshot_gigabytes',-1,'2025-11-24 10:06:23',NULL),('2025-11-23 10:06:23.216647',NULL,'2025-11-23 10:06:23.229394',236,236,NULL,'4afd7d2c-9e56-4221-96ce-04e5a743f2f2',74,'1dcbf043a91e492e9142e84de0186253','snapshots',-1,'2025-11-24 10:06:23','6ec8be50-2b1f-40e8-98cb-a90fe5c90a25'),('2025-11-23 10:06:23.217665',NULL,'2025-11-23 10:06:23.229394',237,237,NULL,'a0c3e780-d2ce-4834-a97d-f19726c938dc',73,'1dcbf043a91e492e9142e84de0186253','snapshot_gigabytes',-1,'2025-11-24 10:06:23','6ec8be50-2b1f-40e8-98cb-a90fe5c90a25'),('2025-11-23 10:06:23.984741',NULL,'2025-11-23 10:06:24.039326',238,238,'8c440ef1e1a8457ba1df49a924e1ba5f','6bc6f992-b8cc-49a7-9e2f-bb042604352c',76,'3d9832e0712f41348ba1825f181d4086','shares',1,'2025-11-24 10:06:23',NULL),('2025-11-23 10:06:23.986408',NULL,'2025-11-23 10:06:24.039326',239,239,'8c440ef1e1a8457ba1df49a924e1ba5f','ebd9ffc1-2a4e-4ed1-9a94-f652005c1430',75,'3d9832e0712f41348ba1825f181d4086','gigabytes',1,'2025-11-24 10:06:23',NULL),('2025-11-23 10:06:24.003054',NULL,'2025-11-23 10:06:24.039326',240,240,NULL,'f1a9f89e-4a29-44f8-a211-46ac43430fdf',78,'3d9832e0712f41348ba1825f181d4086','shares',1,'2025-11-24 10:06:23','31833ee7-4016-4520-993e-f6c13317cc69'),('2025-11-23 10:06:24.004751',NULL,'2025-11-23 10:06:24.039326',241,241,NULL,'58db4ba4-11c7-48da-a539-0b19657dc2fe',77,'3d9832e0712f41348ba1825f181d4086','gigabytes',1,'2025-11-24 10:06:23','31833ee7-4016-4520-993e-f6c13317cc69'),('2025-11-23 10:06:25.057037',NULL,'2025-11-23 10:06:25.080879',242,242,'b0ef51fd6dbc4bd890a74e7dba8b099d','85a07551-bad6-4bda-badb-7b284bd2e1c5',35,'3aaf8109aeae4e8a9d20b032d4f40021','snapshots',-1,'2025-11-24 10:06:25',NULL),('2025-11-23 10:06:25.057873',NULL,'2025-11-23 10:06:25.080879',243,243,'b0ef51fd6dbc4bd890a74e7dba8b099d','98a39446-f8d8-4d5c-b3e5-3d5b9312d9c5',34,'3aaf8109aeae4e8a9d20b032d4f40021','snapshot_gigabytes',-1,'2025-11-24 10:06:25',NULL),('2025-11-23 10:06:25.066672',NULL,'2025-11-23 10:06:25.080879',244,244,NULL,'c86be177-2476-4bb7-8684-4576c078de16',53,'3aaf8109aeae4e8a9d20b032d4f40021','snapshots',-1,'2025-11-24 10:06:25','bdc5dc05-5cbf-414e-ad7e-a3fb7edf1118'),('2025-11-23 10:06:25.073029',NULL,'2025-11-23 10:06:25.080879',245,245,NULL,'df734e08-c2c6-43f9-aed4-aece90596769',52,'3aaf8109aeae4e8a9d20b032d4f40021','snapshot_gigabytes',-1,'2025-11-24 10:06:25','bdc5dc05-5cbf-414e-ad7e-a3fb7edf1118'),('2025-11-23 10:06:26.400162',NULL,'2025-11-23 10:06:26.418919',246,246,'b52f5d7e2eea4f249832a9e7892a6435','fbd459c3-b773-4df6-bd1f-24cc64c6a8f4',79,'1dcbf043a91e492e9142e84de0186253','shares',-1,'2025-11-24 10:06:26',NULL),('2025-11-23 10:06:26.400815',NULL,'2025-11-23 10:06:26.418919',247,247,'b52f5d7e2eea4f249832a9e7892a6435','e9c821c5-9558-4e1d-9972-b54480c03b98',80,'1dcbf043a91e492e9142e84de0186253','gigabytes',-1,'2025-11-24 10:06:26',NULL),('2025-11-23 10:06:26.411405',NULL,'2025-11-23 10:06:26.418919',248,248,NULL,'f56820fe-20f9-47b8-8d2f-44c1ca439d59',81,'1dcbf043a91e492e9142e84de0186253','shares',-1,'2025-11-24 10:06:26','6ec8be50-2b1f-40e8-98cb-a90fe5c90a25'),('2025-11-23 10:06:26.411980',NULL,'2025-11-23 10:06:26.418919',249,249,NULL,'a13018f2-70da-4194-98e3-3860898a2af0',82,'1dcbf043a91e492e9142e84de0186253','gigabytes',-1,'2025-11-24 10:06:26','6ec8be50-2b1f-40e8-98cb-a90fe5c90a25'),('2025-11-23 10:06:28.352340',NULL,'2025-11-23 10:06:28.377732',250,250,'b0ef51fd6dbc4bd890a74e7dba8b099d','a3f5d7e9-215e-47b0-95b6-b996fc48cba8',31,'3aaf8109aeae4e8a9d20b032d4f40021','shares',-1,'2025-11-24 10:06:28',NULL),('2025-11-23 10:06:28.353258',NULL,'2025-11-23 10:06:28.377732',251,251,'b0ef51fd6dbc4bd890a74e7dba8b099d','4d505d97-8d61-4f4e-8243-59f29bcace84',30,'3aaf8109aeae4e8a9d20b032d4f40021','gigabytes',-1,'2025-11-24 10:06:28',NULL),('2025-11-23 10:06:28.359749',NULL,'2025-11-23 10:06:28.377732',252,252,NULL,'960eaeb7-beed-4fcc-833f-0caaa201fbac',49,'3aaf8109aeae4e8a9d20b032d4f40021','shares',-1,'2025-11-24 10:06:28','bdc5dc05-5cbf-414e-ad7e-a3fb7edf1118'),('2025-11-23 10:06:28.363783',NULL,'2025-11-23 10:06:28.377732',253,253,NULL,'9c2ff5f0-e0a5-482c-bc99-6991143823b4',48,'3aaf8109aeae4e8a9d20b032d4f40021','gigabytes',-1,'2025-11-24 10:06:28','bdc5dc05-5cbf-414e-ad7e-a3fb7edf1118'),('2025-11-23 10:06:28.603545',NULL,'2025-11-23 10:06:28.623835',254,254,'8c440ef1e1a8457ba1df49a924e1ba5f','11930020-44b6-41d4-8f6d-cc93d7fc673f',76,'3d9832e0712f41348ba1825f181d4086','shares',-1,'2025-11-24 10:06:28',NULL),('2025-11-23 10:06:28.605293',NULL,'2025-11-23 10:06:28.623835',255,255,'8c440ef1e1a8457ba1df49a924e1ba5f','67f19aba-bc33-445c-ad45-656939c9cb27',75,'3d9832e0712f41348ba1825f181d4086','gigabytes',-1,'2025-11-24 10:06:28',NULL),('2025-11-23 10:06:28.613060',NULL,'2025-11-23 10:06:28.623835',256,256,NULL,'322b602d-4d31-4402-b85e-65c3e7f07943',78,'3d9832e0712f41348ba1825f181d4086','shares',-1,'2025-11-24 10:06:28','31833ee7-4016-4520-993e-f6c13317cc69'),('2025-11-23 10:06:28.613899',NULL,'2025-11-23 10:06:28.623835',257,257,NULL,'1042c740-f44c-40fc-a451-cddd882cb8d4',77,'3d9832e0712f41348ba1825f181d4086','gigabytes',-1,'2025-11-24 10:06:28','31833ee7-4016-4520-993e-f6c13317cc69'),('2025-11-23 10:06:29.720171',NULL,'2025-11-23 10:06:29.746240',258,258,'b52f5d7e2eea4f249832a9e7892a6435','9ebd4deb-5fd7-4a81-a871-f0b06c795e7c',79,'1dcbf043a91e492e9142e84de0186253','shares',-1,'2025-11-24 10:06:29',NULL),('2025-11-23 10:06:29.721727',NULL,'2025-11-23 10:06:29.746240',259,259,'b52f5d7e2eea4f249832a9e7892a6435','8c33b876-ff82-4a3f-a5f7-d9ba1e10610d',80,'1dcbf043a91e492e9142e84de0186253','gigabytes',-1,'2025-11-24 10:06:29',NULL),('2025-11-23 10:06:29.738211',NULL,'2025-11-23 10:06:29.746240',260,260,NULL,'cdaa6aa7-2af9-47fd-b380-2a0efe60b1a5',83,'1dcbf043a91e492e9142e84de0186253','shares',-1,'2025-11-24 10:06:29','c02e5473-a628-4496-98f6-ef85824dd58a'),('2025-11-23 10:06:29.738991',NULL,'2025-11-23 10:06:29.746240',261,261,NULL,'4326a96c-bde6-46a5-ab0b-c3db06cff77b',84,'1dcbf043a91e492e9142e84de0186253','gigabytes',-1,'2025-11-24 10:06:29','c02e5473-a628-4496-98f6-ef85824dd58a'),('2025-11-23 10:06:37.164073',NULL,'2025-11-23 10:06:37.232321',262,262,'501142af53ff4d5e88e9cfe4c08cc922','db09553e-d5cd-4aab-bcca-8231af4527b5',86,'4e966c3cb7e340c1a76c532825794ed0','shares',1,'2025-11-24 10:06:37',NULL),('2025-11-23 10:06:37.170660',NULL,'2025-11-23 10:06:37.232321',263,263,'501142af53ff4d5e88e9cfe4c08cc922','c578519a-26b3-4aca-973d-3ba467bdbd24',85,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',1,'2025-11-24 10:06:37',NULL),('2025-11-23 10:06:37.207278',NULL,'2025-11-23 10:06:37.232321',264,264,NULL,'4995262e-5a01-4edd-ae20-bd82311720be',88,'4e966c3cb7e340c1a76c532825794ed0','shares',1,'2025-11-24 10:06:37','3ee67c27-736a-42ab-8228-b5d2b0b3585e'),('2025-11-23 10:06:37.209726',NULL,'2025-11-23 10:06:37.232321',265,265,NULL,'8ea3d8dd-4683-4b83-85a4-d7d2819004db',87,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',1,'2025-11-24 10:06:37','3ee67c27-736a-42ab-8228-b5d2b0b3585e'),('2025-11-23 10:06:37.441735',NULL,'2025-11-23 10:06:37.470231',266,266,'13eadb38de804082a26094a402383205','ffb7302c-a345-4e0e-ab5b-ded209198d7f',90,'3915699ab6dc4d0eacfc4da73bdd0721','shares',1,'2025-11-24 10:06:37',NULL),('2025-11-23 10:06:37.442745',NULL,'2025-11-23 10:06:37.470231',267,267,'13eadb38de804082a26094a402383205','f120f389-6406-4d23-90d2-2a619650e2c6',89,'3915699ab6dc4d0eacfc4da73bdd0721','gigabytes',1,'2025-11-24 10:06:37',NULL),('2025-11-23 10:06:37.451699',NULL,'2025-11-23 10:06:37.470231',268,268,NULL,'eabbb1a8-71e2-4da2-8cb9-7993efed4e07',92,'3915699ab6dc4d0eacfc4da73bdd0721','shares',1,'2025-11-24 10:06:37','1e842ab0-d592-439b-87f5-1b0233177ebe'),('2025-11-23 10:06:37.452687',NULL,'2025-11-23 10:06:37.470231',269,269,NULL,'aa9be759-9c63-41c6-a21c-f39b213a890a',91,'3915699ab6dc4d0eacfc4da73bdd0721','gigabytes',1,'2025-11-24 10:06:37','1e842ab0-d592-439b-87f5-1b0233177ebe'),('2025-11-23 10:06:39.150096',NULL,'2025-11-23 10:06:39.196031',270,270,'f668e56007aa41cda6df54029adea6e9','6fdeb637-1def-47fc-901f-f5b431455d17',93,'e151a2616d204040a966e2f4e3ee04ff','share_networks',1,'2025-11-24 10:06:39',NULL),('2025-11-23 10:06:39.471443',NULL,'2025-11-23 10:06:39.515309',271,271,'1ce5aa3cdeb74392b464424acb0f8c06','56279bba-dd99-4ec5-84b1-013717ba0c0b',94,'fea104cf3c3a44fbbc740b70a6f93f2e','share_networks',1,'2025-11-24 10:06:39',NULL),('2025-11-23 10:06:40.536923',NULL,'2025-11-23 10:06:40.541650',272,272,'f668e56007aa41cda6df54029adea6e9','e08fbfcf-1657-4a9b-a8ea-e382574254f4',93,'e151a2616d204040a966e2f4e3ee04ff','share_networks',-1,'2025-11-24 10:06:40',NULL),('2025-11-23 10:06:41.583159',NULL,'2025-11-23 10:06:41.618139',273,273,'7fae8bd255614f2a992630ddb3b5446a','20ea0829-c950-4bc6-bb05-c6f8ce389ae4',96,'1fa50ded1536493ab576c7056980bef4','shares',1,'2025-11-24 10:06:41',NULL),('2025-11-23 10:06:41.584570',NULL,'2025-11-23 10:06:41.618139',274,274,'7fae8bd255614f2a992630ddb3b5446a','e5d32973-85be-4c9f-a6d9-8e85bf6d0ebd',95,'1fa50ded1536493ab576c7056980bef4','gigabytes',2,'2025-11-24 10:06:41',NULL),('2025-11-23 10:06:41.596244',NULL,'2025-11-23 10:06:41.618139',275,275,NULL,'5c957e87-875b-4315-b49e-d0a5de1415b1',98,'1fa50ded1536493ab576c7056980bef4','shares',1,'2025-11-24 10:06:41','016b1539-56c2-478f-9e3c-7604659e989b'),('2025-11-23 10:06:41.597736',NULL,'2025-11-23 10:06:41.618139',276,276,NULL,'ee006fb6-2a71-43d4-8870-36017470efb0',97,'1fa50ded1536493ab576c7056980bef4','gigabytes',2,'2025-11-24 10:06:41','016b1539-56c2-478f-9e3c-7604659e989b'),('2025-11-23 10:06:42.207908',NULL,'2025-11-23 10:06:42.223797',277,277,'13eadb38de804082a26094a402383205','86004e8a-2537-4edf-a792-bbde9e5c195c',90,'3915699ab6dc4d0eacfc4da73bdd0721','shares',-1,'2025-11-24 10:06:42',NULL),('2025-11-23 10:06:42.208755',NULL,'2025-11-23 10:06:42.223797',278,278,'13eadb38de804082a26094a402383205','53ad60d6-4610-4978-945d-15a2f038f143',89,'3915699ab6dc4d0eacfc4da73bdd0721','gigabytes',-1,'2025-11-24 10:06:42',NULL),('2025-11-23 10:06:42.215149',NULL,'2025-11-23 10:06:42.223797',279,279,NULL,'57c3b150-80af-4ffc-a0d3-7c1b95b8e903',92,'3915699ab6dc4d0eacfc4da73bdd0721','shares',-1,'2025-11-24 10:06:42','1e842ab0-d592-439b-87f5-1b0233177ebe'),('2025-11-23 10:06:42.215971',NULL,'2025-11-23 10:06:42.223797',280,280,NULL,'5dd89ffd-ded9-41bf-b509-d1f48c74c69b',91,'3915699ab6dc4d0eacfc4da73bdd0721','gigabytes',-1,'2025-11-24 10:06:42','1e842ab0-d592-439b-87f5-1b0233177ebe'),('2025-11-23 10:06:43.773874',NULL,'2025-11-23 10:06:43.791923',281,281,'501142af53ff4d5e88e9cfe4c08cc922','3f77d53f-1c25-4129-955c-e83659f88e69',86,'4e966c3cb7e340c1a76c532825794ed0','shares',-1,'2025-11-24 10:06:43',NULL),('2025-11-23 10:06:43.774905',NULL,'2025-11-23 10:06:43.791923',282,282,'501142af53ff4d5e88e9cfe4c08cc922','aefd0782-5f8c-4522-99f0-4db8c5818377',85,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',-1,'2025-11-24 10:06:43',NULL),('2025-11-23 10:06:43.782473',NULL,'2025-11-23 10:06:43.791923',283,283,NULL,'1d0e437a-6090-4077-8d5d-c60fcea28e1c',88,'4e966c3cb7e340c1a76c532825794ed0','shares',-1,'2025-11-24 10:06:43','3ee67c27-736a-42ab-8228-b5d2b0b3585e'),('2025-11-23 10:06:43.783263',NULL,'2025-11-23 10:06:43.791923',284,284,NULL,'9f8ba4f3-b2c7-4cfa-9a62-62f81c7b9931',87,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',-1,'2025-11-24 10:06:43','3ee67c27-736a-42ab-8228-b5d2b0b3585e'),('2025-11-23 10:06:43.921419',NULL,'2025-11-23 10:06:43.983050',285,285,'501142af53ff4d5e88e9cfe4c08cc922','3516e4da-450e-4267-af5a-88de65671810',86,'4e966c3cb7e340c1a76c532825794ed0','shares',1,'2025-11-24 10:06:43',NULL),('2025-11-23 10:06:43.924190',NULL,'2025-11-23 10:06:43.983050',286,286,'501142af53ff4d5e88e9cfe4c08cc922','7be8cffc-3895-4a0e-b0c7-35a396d77af3',85,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',1,'2025-11-24 10:06:43',NULL),('2025-11-23 10:06:43.945442',NULL,'2025-11-23 10:06:43.983050',287,287,NULL,'150455ad-d2cc-4c77-b6ec-cecc11df8130',100,'4e966c3cb7e340c1a76c532825794ed0','shares',1,'2025-11-24 10:06:43','e53a7596-ad58-453e-ac49-ffdf5caca343'),('2025-11-23 10:06:43.947057',NULL,'2025-11-23 10:06:43.983050',288,288,NULL,'f9a03bb9-0ac3-46f6-b2ac-c32a512cfb08',99,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',1,'2025-11-24 10:06:43','e53a7596-ad58-453e-ac49-ffdf5caca343'),('2025-11-23 10:06:44.889081',NULL,'2025-11-23 10:06:44.978093',289,289,'7fae8bd255614f2a992630ddb3b5446a','19fa7b68-6659-4811-996c-9f5c701a67fa',102,'1fa50ded1536493ab576c7056980bef4','snapshots',1,'2025-11-24 10:06:44',NULL),('2025-11-23 10:06:44.890511',NULL,'2025-11-23 10:06:44.978093',290,290,'7fae8bd255614f2a992630ddb3b5446a','d8543eff-31b1-4274-8a95-b54df0e5a143',101,'1fa50ded1536493ab576c7056980bef4','snapshot_gigabytes',2,'2025-11-24 10:06:44',NULL),('2025-11-23 10:06:44.901902',NULL,'2025-11-23 10:06:44.978093',291,291,NULL,'f2db2bc0-9212-4812-a6c4-d5f3edc73fcb',104,'1fa50ded1536493ab576c7056980bef4','snapshots',1,'2025-11-24 10:06:44','016b1539-56c2-478f-9e3c-7604659e989b'),('2025-11-23 10:06:44.903646',NULL,'2025-11-23 10:06:44.978093',292,292,NULL,'0b1645dd-e645-4721-b06d-aef0e226800c',103,'1fa50ded1536493ab576c7056980bef4','snapshot_gigabytes',2,'2025-11-24 10:06:44','016b1539-56c2-478f-9e3c-7604659e989b'),('2025-11-23 10:06:47.392721',NULL,'2025-11-23 10:06:47.425082',293,293,'501142af53ff4d5e88e9cfe4c08cc922','5815d1d9-00e7-48cc-ab5e-b5bc8ab6dc46',86,'4e966c3cb7e340c1a76c532825794ed0','shares',-1,'2025-11-24 10:06:47',NULL),('2025-11-23 10:06:47.393752',NULL,'2025-11-23 10:06:47.425082',294,294,'501142af53ff4d5e88e9cfe4c08cc922','b57f7f3b-5ce0-479a-affc-07eb7051be5b',85,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',-1,'2025-11-24 10:06:47',NULL),('2025-11-23 10:06:47.412124',NULL,'2025-11-23 10:06:47.425082',295,295,NULL,'ae8e8d3a-3e3b-43f2-8427-2e8b10cec48a',100,'4e966c3cb7e340c1a76c532825794ed0','shares',-1,'2025-11-24 10:06:47','e53a7596-ad58-453e-ac49-ffdf5caca343'),('2025-11-23 10:06:47.413076',NULL,'2025-11-23 10:06:47.425082',296,296,NULL,'e8d3e874-e24c-4dca-b19e-b4350c6c2149',99,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',-1,'2025-11-24 10:06:47','e53a7596-ad58-453e-ac49-ffdf5caca343'),('2025-11-23 10:06:47.526559',NULL,'2025-11-23 10:06:47.552781',297,297,'501142af53ff4d5e88e9cfe4c08cc922','b2689f3e-7cf6-4280-9343-47a9719a849c',86,'4e966c3cb7e340c1a76c532825794ed0','shares',1,'2025-11-24 10:06:47',NULL),('2025-11-23 10:06:47.527796',NULL,'2025-11-23 10:06:47.552781',298,298,'501142af53ff4d5e88e9cfe4c08cc922','f26005a8-51ed-411e-9e45-7dddd61b8a22',85,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',1,'2025-11-24 10:06:47',NULL),('2025-11-23 10:06:47.535721',NULL,'2025-11-23 10:06:47.552781',299,299,NULL,'05ea82bc-48c1-406b-910f-8ca4c4b14ffc',106,'4e966c3cb7e340c1a76c532825794ed0','shares',1,'2025-11-24 10:06:47','40247f48-f49a-472e-8fdc-5a44be63d748'),('2025-11-23 10:06:47.536713',NULL,'2025-11-23 10:06:47.552781',300,300,NULL,'f5c5657c-5652-458c-a738-af726cc8d042',105,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',1,'2025-11-24 10:06:47','40247f48-f49a-472e-8fdc-5a44be63d748'),('2025-11-23 10:06:48.808039',NULL,'2025-11-23 10:06:48.827056',301,301,'7fae8bd255614f2a992630ddb3b5446a','e727e65f-0e1a-4772-b1ca-fd618a590864',102,'1fa50ded1536493ab576c7056980bef4','snapshots',-1,'2025-11-24 10:06:48',NULL),('2025-11-23 10:06:48.809086',NULL,'2025-11-23 10:06:48.827056',302,302,'7fae8bd255614f2a992630ddb3b5446a','da86ca17-93dc-440b-9236-8d30105bb704',101,'1fa50ded1536493ab576c7056980bef4','snapshot_gigabytes',-2,'2025-11-24 10:06:48',NULL),('2025-11-23 10:06:48.816137',NULL,'2025-11-23 10:06:48.827056',303,303,NULL,'1db8e0e4-ab43-49d6-951c-8639f0aaceed',104,'1fa50ded1536493ab576c7056980bef4','snapshots',-1,'2025-11-24 10:06:48','016b1539-56c2-478f-9e3c-7604659e989b'),('2025-11-23 10:06:48.817116',NULL,'2025-11-23 10:06:48.827056',304,304,NULL,'068a0c68-3611-4391-a6b0-2e7b99cf83a4',103,'1fa50ded1536493ab576c7056980bef4','snapshot_gigabytes',-2,'2025-11-24 10:06:48','016b1539-56c2-478f-9e3c-7604659e989b'),('2025-11-23 10:06:49.480452',NULL,'2025-11-23 10:06:49.534192',305,305,'53dd88525b764bb9a85c931576dd1d2a','42f41e42-a480-475d-b3f2-9ab37d791ba5',108,'836ae7fa48674096a03624b407ebbbc9','shares',1,'2025-11-24 10:06:49',NULL),('2025-11-23 10:06:49.482808',NULL,'2025-11-23 10:06:49.534192',306,306,'53dd88525b764bb9a85c931576dd1d2a','974f9d56-5f6c-48fc-9f55-1e11484bfe91',107,'836ae7fa48674096a03624b407ebbbc9','gigabytes',1,'2025-11-24 10:06:49',NULL),('2025-11-23 10:06:49.501476',NULL,'2025-11-23 10:06:49.534192',307,307,NULL,'81602f12-ee7e-45ae-994a-79e21e0ca903',110,'836ae7fa48674096a03624b407ebbbc9','shares',1,'2025-11-24 10:06:49','1b02bd54-7d26-4a12-b1f3-8fac4d0061e9'),('2025-11-23 10:06:49.502819',NULL,'2025-11-23 10:06:49.534192',308,308,NULL,'f34e8cbc-6a65-4553-a6c9-b5512d714b6d',109,'836ae7fa48674096a03624b407ebbbc9','gigabytes',1,'2025-11-24 10:06:49','1b02bd54-7d26-4a12-b1f3-8fac4d0061e9'),('2025-11-23 10:06:50.848046',NULL,'2025-11-23 10:06:50.906720',309,309,'501142af53ff4d5e88e9cfe4c08cc922','86b384f9-0a4d-4708-805b-877b6eacdbb2',86,'4e966c3cb7e340c1a76c532825794ed0','shares',1,'2025-11-24 10:06:50',NULL),('2025-11-23 10:06:50.849356',NULL,'2025-11-23 10:06:50.906720',310,310,'501142af53ff4d5e88e9cfe4c08cc922','b06c7da3-afad-4f66-be95-866bb2d92f47',85,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',1,'2025-11-24 10:06:50',NULL),('2025-11-23 10:06:50.859726',NULL,'2025-11-23 10:06:50.906720',311,311,NULL,'2b75e07b-f424-4c7f-a572-77bd7786add4',112,'4e966c3cb7e340c1a76c532825794ed0','shares',1,'2025-11-24 10:06:50','3367cba6-0c70-49c8-a8df-7303ff3454ea'),('2025-11-23 10:06:50.862791',NULL,'2025-11-23 10:06:50.906720',312,312,NULL,'627af150-bfb1-49e9-a4a4-9c26da779cf6',111,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',1,'2025-11-24 10:06:50','3367cba6-0c70-49c8-a8df-7303ff3454ea'),('2025-11-23 10:06:51.980139',NULL,'2025-11-23 10:06:52.042025',313,313,'7fae8bd255614f2a992630ddb3b5446a','f11bcdd1-5366-446f-a48d-ad6c73268a2e',96,'1fa50ded1536493ab576c7056980bef4','shares',-1,'2025-11-24 10:06:51',NULL),('2025-11-23 10:06:51.981004',NULL,'2025-11-23 10:06:52.042025',314,314,'7fae8bd255614f2a992630ddb3b5446a','27936a99-e627-4013-bbda-16303351c79f',95,'1fa50ded1536493ab576c7056980bef4','gigabytes',-2,'2025-11-24 10:06:51',NULL),('2025-11-23 10:06:52.021569',NULL,'2025-11-23 10:06:52.042025',315,315,NULL,'92067dbf-3496-4c8d-ac4b-ecdb5a708d3a',98,'1fa50ded1536493ab576c7056980bef4','shares',-1,'2025-11-24 10:06:51','016b1539-56c2-478f-9e3c-7604659e989b'),('2025-11-23 10:06:52.024233',NULL,'2025-11-23 10:06:52.042025',316,316,NULL,'2d530aeb-d21a-4ac4-9b5d-aa2b1350f65b',97,'1fa50ded1536493ab576c7056980bef4','gigabytes',-2,'2025-11-24 10:06:51','016b1539-56c2-478f-9e3c-7604659e989b'),('2025-11-23 10:06:53.767756',NULL,'2025-11-23 10:06:53.809833',317,317,'8483e09239ab4b5695e53a06581517fc','b4c0a1db-d0eb-42ab-9d38-a85ba4807546',113,'02ae9008b69a486ea872eaae08e1909a','share_networks',1,'2025-11-24 10:06:53',NULL),('2025-11-23 10:06:53.863785',NULL,'2025-11-23 10:06:53.945426',318,318,'8483e09239ab4b5695e53a06581517fc','82dadfe9-d13f-4d89-9067-00b3fe3c3995',113,'02ae9008b69a486ea872eaae08e1909a','share_networks',1,'2025-11-24 10:06:53',NULL),('2025-11-23 10:06:54.328718',NULL,'2025-11-23 10:06:54.333205',319,319,'8483e09239ab4b5695e53a06581517fc','87174f07-a808-4df8-b6fa-70eae3ec9461',113,'02ae9008b69a486ea872eaae08e1909a','share_networks',-1,'2025-11-24 10:06:54',NULL),('2025-11-23 10:06:54.475184',NULL,'2025-11-23 10:06:54.491448',320,320,'8483e09239ab4b5695e53a06581517fc','bc97025d-5fbd-459e-8738-2009dc29b8bd',113,'02ae9008b69a486ea872eaae08e1909a','share_networks',-1,'2025-11-24 10:06:54',NULL),('2025-11-23 10:06:54.874166',NULL,'2025-11-23 10:06:54.919151',321,321,'7fae8bd255614f2a992630ddb3b5446a','7feab71b-a6b9-4c92-8444-67c1e2a6fbf2',96,'1fa50ded1536493ab576c7056980bef4','shares',1,'2025-11-24 10:06:54',NULL),('2025-11-23 10:06:54.876545',NULL,'2025-11-23 10:06:54.919151',322,322,'7fae8bd255614f2a992630ddb3b5446a','39faf41c-0f34-4e95-ac59-bc6a7fa60425',95,'1fa50ded1536493ab576c7056980bef4','gigabytes',1,'2025-11-24 10:06:54',NULL),('2025-11-23 10:06:54.884247',NULL,'2025-11-23 10:06:54.919151',323,323,NULL,'6df5b06e-742c-4925-9499-b78bb72b8036',98,'1fa50ded1536493ab576c7056980bef4','shares',1,'2025-11-24 10:06:54','016b1539-56c2-478f-9e3c-7604659e989b'),('2025-11-23 10:06:54.886138',NULL,'2025-11-23 10:06:54.919151',324,324,NULL,'8aecc496-f189-4d69-b585-dee82043af29',97,'1fa50ded1536493ab576c7056980bef4','gigabytes',1,'2025-11-24 10:06:54','016b1539-56c2-478f-9e3c-7604659e989b'),('2025-11-23 10:06:57.265048',NULL,'2025-11-23 10:06:57.283238',325,325,'501142af53ff4d5e88e9cfe4c08cc922','6ecc2ddc-fa37-4cbf-a7c1-8f2af93d78b5',86,'4e966c3cb7e340c1a76c532825794ed0','shares',-1,'2025-11-24 10:06:57',NULL),('2025-11-23 10:06:57.265701',NULL,'2025-11-23 10:06:57.283238',326,326,'501142af53ff4d5e88e9cfe4c08cc922','cf18102b-a375-41bd-a4ba-f28a30914ce5',85,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',-1,'2025-11-24 10:06:57',NULL),('2025-11-23 10:06:57.272461',NULL,'2025-11-23 10:06:57.283238',327,327,NULL,'ad3e2c4b-b7f0-4921-99cd-22b5d4d93f95',112,'4e966c3cb7e340c1a76c532825794ed0','shares',-1,'2025-11-24 10:06:57','3367cba6-0c70-49c8-a8df-7303ff3454ea'),('2025-11-23 10:06:57.273061',NULL,'2025-11-23 10:06:57.283238',328,328,NULL,'d2056962-1dc1-4edc-81ac-98b5c92aa65f',111,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',-1,'2025-11-24 10:06:57','3367cba6-0c70-49c8-a8df-7303ff3454ea'),('2025-11-23 10:06:57.468928',NULL,'2025-11-23 10:06:57.489035',329,329,'501142af53ff4d5e88e9cfe4c08cc922','5fb41b74-c620-4e16-9832-4b2b2f9cacda',86,'4e966c3cb7e340c1a76c532825794ed0','shares',-1,'2025-11-24 10:06:57',NULL),('2025-11-23 10:06:57.469859',NULL,'2025-11-23 10:06:57.489035',330,330,'501142af53ff4d5e88e9cfe4c08cc922','1fcdcbb4-8fb7-462d-8203-919fb3c4a270',85,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',-1,'2025-11-24 10:06:57',NULL),('2025-11-23 10:06:57.477437',NULL,'2025-11-23 10:06:57.489035',331,331,NULL,'1cb4e543-dc89-4518-8f49-186be7a339c9',106,'4e966c3cb7e340c1a76c532825794ed0','shares',-1,'2025-11-24 10:06:57','40247f48-f49a-472e-8fdc-5a44be63d748'),('2025-11-23 10:06:57.478626',NULL,'2025-11-23 10:06:57.489035',332,332,NULL,'159697e2-99a8-4d30-920f-f426033a44ba',105,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',-1,'2025-11-24 10:06:57','40247f48-f49a-472e-8fdc-5a44be63d748'),('2025-11-23 10:06:57.626132',NULL,'2025-11-23 10:06:57.678372',333,333,'501142af53ff4d5e88e9cfe4c08cc922','6682cec8-e2b6-4b38-a260-f02f074db3b4',86,'4e966c3cb7e340c1a76c532825794ed0','shares',1,'2025-11-24 10:06:57',NULL),('2025-11-23 10:06:57.628620',NULL,'2025-11-23 10:06:57.678372',334,334,'501142af53ff4d5e88e9cfe4c08cc922','90cd111a-f552-4fa7-9aa3-56d182b5f9f1',85,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',1,'2025-11-24 10:06:57',NULL),('2025-11-23 10:06:57.643494',NULL,'2025-11-23 10:06:57.678372',335,335,NULL,'22ba1990-d9af-425b-8fa9-c6ceef426b99',115,'4e966c3cb7e340c1a76c532825794ed0','shares',1,'2025-11-24 10:06:57','37591290-ccf8-48b4-b8e4-c0696751f3b3'),('2025-11-23 10:06:57.645151',NULL,'2025-11-23 10:06:57.678372',336,336,NULL,'8304fc34-ba6c-4368-90ea-b56132db6eee',114,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',1,'2025-11-24 10:06:57','37591290-ccf8-48b4-b8e4-c0696751f3b3'),('2025-11-23 10:06:58.233050',NULL,'2025-11-23 10:06:58.329370',337,337,'7fae8bd255614f2a992630ddb3b5446a','b85741e5-b81c-497d-b18f-3a0e009864be',102,'1fa50ded1536493ab576c7056980bef4','snapshots',1,'2025-11-24 10:06:58',NULL),('2025-11-23 10:06:58.235630',NULL,'2025-11-23 10:06:58.329370',338,338,'7fae8bd255614f2a992630ddb3b5446a','8d215496-c28e-420f-ada8-f9a4d82ef05e',101,'1fa50ded1536493ab576c7056980bef4','snapshot_gigabytes',1,'2025-11-24 10:06:58',NULL),('2025-11-23 10:06:58.249155',NULL,'2025-11-23 10:06:58.329370',339,339,NULL,'f54a8d96-d9ca-4e3e-91c0-85d5f62a304b',104,'1fa50ded1536493ab576c7056980bef4','snapshots',1,'2025-11-24 10:06:58','016b1539-56c2-478f-9e3c-7604659e989b'),('2025-11-23 10:06:58.250355',NULL,'2025-11-23 10:06:58.329370',340,340,NULL,'9dd1db6d-b7bf-467a-aebd-bee5d2c5ec30',103,'1fa50ded1536493ab576c7056980bef4','snapshot_gigabytes',1,'2025-11-24 10:06:58','016b1539-56c2-478f-9e3c-7604659e989b'),('2025-11-23 10:07:02.429962',NULL,'2025-11-23 10:07:02.445335',341,341,'7fae8bd255614f2a992630ddb3b5446a','4d1cf398-a254-4c10-a0e2-2607ecce0904',102,'1fa50ded1536493ab576c7056980bef4','snapshots',-1,'2025-11-24 10:07:02',NULL),('2025-11-23 10:07:02.430784',NULL,'2025-11-23 10:07:02.445335',342,342,'7fae8bd255614f2a992630ddb3b5446a','dc9d3015-51fc-4cd9-890b-89ef99d8098e',101,'1fa50ded1536493ab576c7056980bef4','snapshot_gigabytes',-1,'2025-11-24 10:07:02',NULL),('2025-11-23 10:07:02.436165',NULL,'2025-11-23 10:07:02.445335',343,343,NULL,'e42f7dc5-aa0c-4f5c-bcd6-cda80c6e6653',104,'1fa50ded1536493ab576c7056980bef4','snapshots',-1,'2025-11-24 10:07:02','016b1539-56c2-478f-9e3c-7604659e989b'),('2025-11-23 10:07:02.436816',NULL,'2025-11-23 10:07:02.445335',344,344,NULL,'772d3202-0f25-4ff3-b7df-a7d75c00b192',103,'1fa50ded1536493ab576c7056980bef4','snapshot_gigabytes',-1,'2025-11-24 10:07:02','016b1539-56c2-478f-9e3c-7604659e989b'),('2025-11-23 10:07:04.005980',NULL,'2025-11-23 10:07:04.035965',345,345,'501142af53ff4d5e88e9cfe4c08cc922','4df94100-cece-4b96-ad0a-5a32869aca59',86,'4e966c3cb7e340c1a76c532825794ed0','shares',1,'2025-11-24 10:07:03',NULL),('2025-11-23 10:07:04.007286',NULL,'2025-11-23 10:07:04.035965',346,346,'501142af53ff4d5e88e9cfe4c08cc922','fc98368c-1aca-489a-be0e-7b6194957c4b',85,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',1,'2025-11-24 10:07:03',NULL),('2025-11-23 10:07:04.016058',NULL,'2025-11-23 10:07:04.035965',347,347,NULL,'45322b1d-e4fb-4c16-8636-0938a795c574',117,'4e966c3cb7e340c1a76c532825794ed0','shares',1,'2025-11-24 10:07:03','cde87ceb-1252-4f18-8d11-f7e2c8bb7e24'),('2025-11-23 10:07:04.017051',NULL,'2025-11-23 10:07:04.035965',348,348,NULL,'007f0d6c-4928-48d3-b007-79175b176f47',116,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',1,'2025-11-24 10:07:03','cde87ceb-1252-4f18-8d11-f7e2c8bb7e24'),('2025-11-23 10:07:05.183116',NULL,'2025-11-23 10:07:05.216842',349,349,'91413c184f394807978c24e936e5c58f','8a499bfb-6dfe-472c-9e05-9af4f2b77f5f',119,'812e12744eb745bcadf0dcbfeff51a92','shares',1,'2025-11-24 10:07:05',NULL),('2025-11-23 10:07:05.184222',NULL,'2025-11-23 10:07:05.216842',350,350,'91413c184f394807978c24e936e5c58f','afc037f1-c718-4ad7-8da7-275fed77db8a',118,'812e12744eb745bcadf0dcbfeff51a92','gigabytes',1,'2025-11-24 10:07:05',NULL),('2025-11-23 10:07:05.196504',NULL,'2025-11-23 10:07:05.216842',351,351,NULL,'24c8766b-9768-48ca-8d49-dc9566d49cb0',121,'812e12744eb745bcadf0dcbfeff51a92','shares',1,'2025-11-24 10:07:05','81f91fcf-5371-4d2d-b313-d95d4ff30ee0'),('2025-11-23 10:07:05.197739',NULL,'2025-11-23 10:07:05.216842',352,352,NULL,'5a926700-d03c-4528-ada3-464cc905c293',120,'812e12744eb745bcadf0dcbfeff51a92','gigabytes',1,'2025-11-24 10:07:05','81f91fcf-5371-4d2d-b313-d95d4ff30ee0'),('2025-11-23 10:07:05.868124',NULL,'2025-11-23 10:07:05.885553',353,353,'7fae8bd255614f2a992630ddb3b5446a','078bbfb7-a2c5-4404-a6cd-3558805ed17f',96,'1fa50ded1536493ab576c7056980bef4','shares',-1,'2025-11-24 10:07:05',NULL),('2025-11-23 10:07:05.869156',NULL,'2025-11-23 10:07:05.885553',354,354,'7fae8bd255614f2a992630ddb3b5446a','030e1c48-1ece-4c52-9d94-f9533ace0bb1',95,'1fa50ded1536493ab576c7056980bef4','gigabytes',-1,'2025-11-24 10:07:05',NULL),('2025-11-23 10:07:05.875654',NULL,'2025-11-23 10:07:05.885553',355,355,NULL,'5f5d18fd-9cc6-44a5-a559-7fed952f66e2',98,'1fa50ded1536493ab576c7056980bef4','shares',-1,'2025-11-24 10:07:05','016b1539-56c2-478f-9e3c-7604659e989b'),('2025-11-23 10:07:05.876738',NULL,'2025-11-23 10:07:05.885553',356,356,NULL,'5c715e11-372d-4aae-b83c-82c0f99d4735',97,'1fa50ded1536493ab576c7056980bef4','gigabytes',-1,'2025-11-24 10:07:05','016b1539-56c2-478f-9e3c-7604659e989b'),('2025-11-23 10:07:07.292527',NULL,'2025-11-23 10:07:07.343466',357,357,'501142af53ff4d5e88e9cfe4c08cc922','3c19b81b-7ad8-4778-a919-82384e48b43b',86,'4e966c3cb7e340c1a76c532825794ed0','shares',1,'2025-11-24 10:07:07',NULL),('2025-11-23 10:07:07.295194',NULL,'2025-11-23 10:07:07.343466',358,358,'501142af53ff4d5e88e9cfe4c08cc922','dfdda666-0f4a-40e4-904a-c37181a3aa8c',85,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',1,'2025-11-24 10:07:07',NULL),('2025-11-23 10:07:07.314554',NULL,'2025-11-23 10:07:07.343466',359,359,NULL,'854c2566-acfe-44da-9267-3606a69e393b',123,'4e966c3cb7e340c1a76c532825794ed0','shares',1,'2025-11-24 10:07:07','16cf707e-52a3-4975-89e5-b873c9ef92cc'),('2025-11-23 10:07:07.316408',NULL,'2025-11-23 10:07:07.343466',360,360,NULL,'affd2ccd-5306-4a84-a20e-20dc3c1b59f5',122,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',1,'2025-11-24 10:07:07','16cf707e-52a3-4975-89e5-b873c9ef92cc'),('2025-11-23 10:07:08.533241',NULL,'2025-11-23 10:07:08.804669',361,361,'91413c184f394807978c24e936e5c58f','b2e36e39-04e6-4712-b12e-a3a5c6ae66db',119,'812e12744eb745bcadf0dcbfeff51a92','shares',1,'2025-11-24 10:07:08',NULL),('2025-11-23 10:07:08.539326',NULL,'2025-11-23 10:07:08.804669',362,362,'91413c184f394807978c24e936e5c58f','d176db8d-0365-482f-996f-cef3328d0cc4',118,'812e12744eb745bcadf0dcbfeff51a92','gigabytes',1,'2025-11-24 10:07:08',NULL),('2025-11-23 10:07:08.553739',NULL,'2025-11-23 10:07:08.804669',363,363,NULL,'32e8d5d3-75bf-4a62-b3a4-fcf449aa6e14',121,'812e12744eb745bcadf0dcbfeff51a92','shares',1,'2025-11-24 10:07:08','81f91fcf-5371-4d2d-b313-d95d4ff30ee0'),('2025-11-23 10:07:08.556762',NULL,'2025-11-23 10:07:08.804669',364,364,NULL,'caf678b0-0e98-4476-8812-ca8a487edd3c',120,'812e12744eb745bcadf0dcbfeff51a92','gigabytes',1,'2025-11-24 10:07:08','81f91fcf-5371-4d2d-b313-d95d4ff30ee0'),('2025-11-23 10:07:10.702401',NULL,'2025-11-23 10:07:10.715549',365,365,'501142af53ff4d5e88e9cfe4c08cc922','8b5a8778-12a7-4649-9143-23008085c6d3',86,'4e966c3cb7e340c1a76c532825794ed0','shares',-1,'2025-11-24 10:07:10',NULL),('2025-11-23 10:07:10.703384',NULL,'2025-11-23 10:07:10.715549',366,366,'501142af53ff4d5e88e9cfe4c08cc922','e36d5abc-6167-422c-bc35-4a4283e1cc33',85,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',-1,'2025-11-24 10:07:10',NULL),('2025-11-23 10:07:10.708932',NULL,'2025-11-23 10:07:10.715549',367,367,NULL,'f48d8cbf-537e-4480-845d-d9beb2a6f42a',123,'4e966c3cb7e340c1a76c532825794ed0','shares',-1,'2025-11-24 10:07:10','16cf707e-52a3-4975-89e5-b873c9ef92cc'),('2025-11-23 10:07:10.709542',NULL,'2025-11-23 10:07:10.715549',368,368,NULL,'8eba94ea-ec71-4915-920f-ceb777d4595b',122,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',-1,'2025-11-24 10:07:10','16cf707e-52a3-4975-89e5-b873c9ef92cc'),('2025-11-23 10:07:10.964420',NULL,'2025-11-23 10:07:10.975760',369,369,'501142af53ff4d5e88e9cfe4c08cc922','d1a3ef4e-02c1-4c5f-b5ce-0f4afc73d485',86,'4e966c3cb7e340c1a76c532825794ed0','shares',-1,'2025-11-24 10:07:10',NULL),('2025-11-23 10:07:10.965204',NULL,'2025-11-23 10:07:10.975760',370,370,'501142af53ff4d5e88e9cfe4c08cc922','3992b73f-ab1b-4400-94b9-9d2a93720f64',85,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',-1,'2025-11-24 10:07:10',NULL),('2025-11-23 10:07:10.969637',NULL,'2025-11-23 10:07:10.975760',371,371,NULL,'473105e8-ab87-4507-8b3c-b944a8502566',117,'4e966c3cb7e340c1a76c532825794ed0','shares',-1,'2025-11-24 10:07:10','cde87ceb-1252-4f18-8d11-f7e2c8bb7e24'),('2025-11-23 10:07:10.970232',NULL,'2025-11-23 10:07:10.975760',372,372,NULL,'0db195b5-ab70-4afa-ac1c-e3fc48b9708c',116,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',-1,'2025-11-24 10:07:10','cde87ceb-1252-4f18-8d11-f7e2c8bb7e24'),('2025-11-23 10:07:11.169173',NULL,'2025-11-23 10:07:11.201640',373,373,'501142af53ff4d5e88e9cfe4c08cc922','3fbd7e5b-7561-4cd9-b5bc-5019f7e0ae4b',86,'4e966c3cb7e340c1a76c532825794ed0','shares',-1,'2025-11-24 10:07:11',NULL),('2025-11-23 10:07:11.170912',NULL,'2025-11-23 10:07:11.201640',374,374,'501142af53ff4d5e88e9cfe4c08cc922','193f1e36-e5e3-4131-9df3-dfe29c706585',85,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',-1,'2025-11-24 10:07:11',NULL),('2025-11-23 10:07:11.185377',NULL,'2025-11-23 10:07:11.201640',375,375,NULL,'246a8fc3-1b16-4343-a8da-0cc8cae2491b',115,'4e966c3cb7e340c1a76c532825794ed0','shares',-1,'2025-11-24 10:07:11','37591290-ccf8-48b4-b8e4-c0696751f3b3'),('2025-11-23 10:07:11.186791',NULL,'2025-11-23 10:07:11.201640',376,376,NULL,'96098ada-0cbe-4ce6-be22-9d3ef5462209',114,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',-1,'2025-11-24 10:07:11','37591290-ccf8-48b4-b8e4-c0696751f3b3'),('2025-11-23 10:07:11.273596',NULL,'2025-11-23 10:07:11.310451',377,377,'95abdc6959da45d4a2467b1c9ad5bc41','b051dce3-271c-4c48-8121-f3004c9d9913',125,'b2b643061e7e43609bfddf91b9cbec2e','shares',1,'2025-11-24 10:07:11',NULL),('2025-11-23 10:07:11.274657',NULL,'2025-11-23 10:07:11.310451',378,378,'95abdc6959da45d4a2467b1c9ad5bc41','30de35fa-d1bb-4df4-8295-22c5d28e8bd5',124,'b2b643061e7e43609bfddf91b9cbec2e','gigabytes',1,'2025-11-24 10:07:11',NULL),('2025-11-23 10:07:11.285126',NULL,'2025-11-23 10:07:11.310451',379,379,NULL,'c8605f36-eb78-4a30-984e-a6cb94907f78',127,'b2b643061e7e43609bfddf91b9cbec2e','shares',1,'2025-11-24 10:07:11','8e8250f9-acee-45ef-949e-8442f6574cba'),('2025-11-23 10:07:11.286163',NULL,'2025-11-23 10:07:11.310451',380,380,NULL,'bca1df44-7be3-4014-b705-153a49c7f155',126,'b2b643061e7e43609bfddf91b9cbec2e','gigabytes',1,'2025-11-24 10:07:11','8e8250f9-acee-45ef-949e-8442f6574cba'),('2025-11-23 10:07:11.328031',NULL,'2025-11-23 10:07:11.362751',381,381,'501142af53ff4d5e88e9cfe4c08cc922','958a1ca9-ac89-4ea2-bf2d-26081a86b3b9',86,'4e966c3cb7e340c1a76c532825794ed0','shares',1,'2025-11-24 10:07:11',NULL),('2025-11-23 10:07:11.329274',NULL,'2025-11-23 10:07:11.362751',382,382,'501142af53ff4d5e88e9cfe4c08cc922','ab13f31b-93b5-4431-b7c9-ad1077871324',85,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',1,'2025-11-24 10:07:11',NULL),('2025-11-23 10:07:11.341569',NULL,'2025-11-23 10:07:11.362751',383,383,NULL,'54939b17-a9b5-49b2-a015-cc3823a59578',129,'4e966c3cb7e340c1a76c532825794ed0','shares',1,'2025-11-24 10:07:11','6c1d4104-0da4-4d52-9c0a-4df6b9946368'),('2025-11-23 10:07:11.343022',NULL,'2025-11-23 10:07:11.362751',384,384,NULL,'63b63c23-2ec7-4847-bbf1-d0211025586a',128,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',1,'2025-11-24 10:07:11','6c1d4104-0da4-4d52-9c0a-4df6b9946368'),('2025-11-23 10:07:12.565408',NULL,'2025-11-23 10:07:12.584448',385,385,'91413c184f394807978c24e936e5c58f','6cb78bae-68cd-45c9-9fd6-93e5240428f4',119,'812e12744eb745bcadf0dcbfeff51a92','shares',-1,'2025-11-24 10:07:12',NULL),('2025-11-23 10:07:12.566940',NULL,'2025-11-23 10:07:12.584448',386,386,'91413c184f394807978c24e936e5c58f','80415ee8-d61a-40a5-bab4-329d620b2a9b',118,'812e12744eb745bcadf0dcbfeff51a92','gigabytes',-1,'2025-11-24 10:07:12',NULL),('2025-11-23 10:07:12.574391',NULL,'2025-11-23 10:07:12.584448',387,387,NULL,'23527541-998e-4f7b-b81f-21cc4d05631b',121,'812e12744eb745bcadf0dcbfeff51a92','shares',-1,'2025-11-24 10:07:12','81f91fcf-5371-4d2d-b313-d95d4ff30ee0'),('2025-11-23 10:07:12.575374',NULL,'2025-11-23 10:07:12.584448',388,388,NULL,'c23a084a-3cb0-4e02-8da9-b5af51186191',120,'812e12744eb745bcadf0dcbfeff51a92','gigabytes',-1,'2025-11-24 10:07:12','81f91fcf-5371-4d2d-b313-d95d4ff30ee0'),('2025-11-23 10:07:14.568246',NULL,'2025-11-23 10:07:14.608654',389,389,'501142af53ff4d5e88e9cfe4c08cc922','5f0b4226-aedf-4b62-a282-c4e4a9148a66',86,'4e966c3cb7e340c1a76c532825794ed0','shares',1,'2025-11-24 10:07:14',NULL),('2025-11-23 10:07:14.569514',NULL,'2025-11-23 10:07:14.608654',390,390,'501142af53ff4d5e88e9cfe4c08cc922','d698ac6f-1c60-42b3-bbdc-d0140d65a955',85,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',1,'2025-11-24 10:07:14',NULL),('2025-11-23 10:07:14.581021',NULL,'2025-11-23 10:07:14.608654',391,391,NULL,'912b596b-7db1-48b7-af0b-5fa16234a123',131,'4e966c3cb7e340c1a76c532825794ed0','shares',1,'2025-11-24 10:07:14','77558cf4-622b-4b30-ae9e-514c9ffd7961'),('2025-11-23 10:07:14.582236',NULL,'2025-11-23 10:07:14.608654',392,392,NULL,'77e66e7f-fe6d-41a8-80cb-5fbf1cdd6cae',130,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',1,'2025-11-24 10:07:14','77558cf4-622b-4b30-ae9e-514c9ffd7961'),('2025-11-23 10:07:15.809080',NULL,'2025-11-23 10:07:15.828701',393,393,'91413c184f394807978c24e936e5c58f','c7add94d-a903-40d0-88d8-5bba1aa101dc',119,'812e12744eb745bcadf0dcbfeff51a92','shares',-1,'2025-11-24 10:07:15',NULL),('2025-11-23 10:07:15.809899',NULL,'2025-11-23 10:07:15.828701',394,394,'91413c184f394807978c24e936e5c58f','5e64831a-4cb6-4188-95d6-a9153b6815ec',118,'812e12744eb745bcadf0dcbfeff51a92','gigabytes',-1,'2025-11-24 10:07:15',NULL),('2025-11-23 10:07:15.817823',NULL,'2025-11-23 10:07:15.828701',395,395,NULL,'47a20cac-7831-4951-869e-569d8d0a7549',121,'812e12744eb745bcadf0dcbfeff51a92','shares',-1,'2025-11-24 10:07:15','81f91fcf-5371-4d2d-b313-d95d4ff30ee0'),('2025-11-23 10:07:15.819007',NULL,'2025-11-23 10:07:15.828701',396,396,NULL,'c98570a2-9845-4c5b-906b-195f28f997e7',120,'812e12744eb745bcadf0dcbfeff51a92','gigabytes',-1,'2025-11-24 10:07:15','81f91fcf-5371-4d2d-b313-d95d4ff30ee0'),('2025-11-23 10:07:16.087921',NULL,'2025-11-23 10:07:16.101526',397,397,'95abdc6959da45d4a2467b1c9ad5bc41','57cd3f52-0d88-47db-a70f-b3d34c839b84',125,'b2b643061e7e43609bfddf91b9cbec2e','shares',-1,'2025-11-24 10:07:16',NULL),('2025-11-23 10:07:16.088885',NULL,'2025-11-23 10:07:16.101526',398,398,'95abdc6959da45d4a2467b1c9ad5bc41','e052b2b8-86e9-4359-9391-1225aa0dc481',124,'b2b643061e7e43609bfddf91b9cbec2e','gigabytes',-1,'2025-11-24 10:07:16',NULL),('2025-11-23 10:07:16.093854',NULL,'2025-11-23 10:07:16.101526',399,399,NULL,'5cace5eb-44ca-49e6-b7a7-68464dd766cb',127,'b2b643061e7e43609bfddf91b9cbec2e','shares',-1,'2025-11-24 10:07:16','8e8250f9-acee-45ef-949e-8442f6574cba'),('2025-11-23 10:07:16.094631',NULL,'2025-11-23 10:07:16.101526',400,400,NULL,'0400295a-b25d-4d92-afcb-4608eb9a79a7',126,'b2b643061e7e43609bfddf91b9cbec2e','gigabytes',-1,'2025-11-24 10:07:16','8e8250f9-acee-45ef-949e-8442f6574cba'),('2025-11-23 10:07:18.205245',NULL,'2025-11-23 10:07:18.220306',401,401,'501142af53ff4d5e88e9cfe4c08cc922','85f5041f-fecb-41c3-8a0f-711547b3557f',86,'4e966c3cb7e340c1a76c532825794ed0','shares',-1,'2025-11-24 10:07:18',NULL),('2025-11-23 10:07:18.206046',NULL,'2025-11-23 10:07:18.220306',402,402,'501142af53ff4d5e88e9cfe4c08cc922','cd214ed7-8350-4402-87fe-840aca24903c',85,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',-1,'2025-11-24 10:07:18',NULL),('2025-11-23 10:07:18.213215',NULL,'2025-11-23 10:07:18.220306',403,403,NULL,'cac5a747-e29f-40ed-a88c-b60cfef9159a',131,'4e966c3cb7e340c1a76c532825794ed0','shares',-1,'2025-11-24 10:07:18','77558cf4-622b-4b30-ae9e-514c9ffd7961'),('2025-11-23 10:07:18.213831',NULL,'2025-11-23 10:07:18.220306',404,404,NULL,'81253281-72cd-4eac-bcf0-a48b5f646cdd',130,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',-1,'2025-11-24 10:07:18','77558cf4-622b-4b30-ae9e-514c9ffd7961'),('2025-11-23 10:07:18.496139',NULL,'2025-11-23 10:07:18.511573',405,405,'501142af53ff4d5e88e9cfe4c08cc922','c85282e7-ae10-4435-a040-9a49006d8e70',86,'4e966c3cb7e340c1a76c532825794ed0','shares',-1,'2025-11-24 10:07:18',NULL),('2025-11-23 10:07:18.497080',NULL,'2025-11-23 10:07:18.511573',406,406,'501142af53ff4d5e88e9cfe4c08cc922','574d3652-d28d-42ab-9698-b65fcfce53d3',85,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',-1,'2025-11-24 10:07:18',NULL),('2025-11-23 10:07:18.503848',NULL,'2025-11-23 10:07:18.511573',407,407,NULL,'4dda8078-ae2b-4720-baac-adf2dea2d565',129,'4e966c3cb7e340c1a76c532825794ed0','shares',-1,'2025-11-24 10:07:18','6c1d4104-0da4-4d52-9c0a-4df6b9946368'),('2025-11-23 10:07:18.504475',NULL,'2025-11-23 10:07:18.511573',408,408,NULL,'e73687f5-53d2-4fd6-b6d2-1a8e1239dd40',128,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',-1,'2025-11-24 10:07:18','6c1d4104-0da4-4d52-9c0a-4df6b9946368'),('2025-11-23 10:07:18.607382',NULL,'2025-11-23 10:07:18.646077',409,409,'501142af53ff4d5e88e9cfe4c08cc922','402df866-ca63-4f67-92da-a467b0f3ca85',86,'4e966c3cb7e340c1a76c532825794ed0','shares',1,'2025-11-24 10:07:18',NULL),('2025-11-23 10:07:18.609426',NULL,'2025-11-23 10:07:18.646077',410,410,'501142af53ff4d5e88e9cfe4c08cc922','753b1905-e4d0-428a-ba38-0ec55a38d241',85,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',1,'2025-11-24 10:07:18',NULL),('2025-11-23 10:07:18.625330',NULL,'2025-11-23 10:07:18.646077',411,411,NULL,'1793a34f-fadb-4b73-a011-54d36cdf2bc5',133,'4e966c3cb7e340c1a76c532825794ed0','shares',1,'2025-11-24 10:07:18','ed12ec80-e123-4266-85ac-12fb62903188'),('2025-11-23 10:07:18.627098',NULL,'2025-11-23 10:07:18.646077',412,412,NULL,'e4dbfcff-004a-44f0-b824-7dab888f2926',132,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',1,'2025-11-24 10:07:18','ed12ec80-e123-4266-85ac-12fb62903188'),('2025-11-23 10:07:18.673271',NULL,'2025-11-23 10:07:18.697534',413,413,'91413c184f394807978c24e936e5c58f','86697447-5a9b-4222-b699-7bd1286d2d3f',134,'812e12744eb745bcadf0dcbfeff51a92','share_groups',1,'2025-11-24 10:07:18',NULL),('2025-11-23 10:07:21.908050',NULL,'2025-11-23 10:07:21.917481',414,414,'91413c184f394807978c24e936e5c58f','2e6e5abe-3b1d-40d4-a041-f5f00bcbff53',134,'812e12744eb745bcadf0dcbfeff51a92','share_groups',-1,'2025-11-24 10:07:21',NULL),('2025-11-23 10:07:25.069431',NULL,'2025-11-23 10:07:25.086850',415,415,'91413c184f394807978c24e936e5c58f','86e2f4c6-756e-4530-9bb8-e9c127951798',134,'812e12744eb745bcadf0dcbfeff51a92','share_groups',1,'2025-11-24 10:07:25',NULL),('2025-11-23 10:07:25.082331',NULL,'2025-11-23 10:07:25.107417',416,416,'501142af53ff4d5e88e9cfe4c08cc922','48fb8efb-04fb-464f-80ab-8ca2d81de1ca',86,'4e966c3cb7e340c1a76c532825794ed0','shares',-1,'2025-11-24 10:07:25',NULL),('2025-11-23 10:07:25.083372',NULL,'2025-11-23 10:07:25.107417',417,417,'501142af53ff4d5e88e9cfe4c08cc922','54ad440f-e216-4450-9b81-866912b54286',85,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',-1,'2025-11-24 10:07:25',NULL),('2025-11-23 10:07:25.091495',NULL,'2025-11-23 10:07:25.107417',418,418,NULL,'abdd890f-114e-4ad1-a203-8e38a41c6261',133,'4e966c3cb7e340c1a76c532825794ed0','shares',-1,'2025-11-24 10:07:25','ed12ec80-e123-4266-85ac-12fb62903188'),('2025-11-23 10:07:25.092900',NULL,'2025-11-23 10:07:25.107417',419,419,NULL,'5be2d839-25ef-497d-996c-bd0535511b03',132,'4e966c3cb7e340c1a76c532825794ed0','gigabytes',-1,'2025-11-24 10:07:25','ed12ec80-e123-4266-85ac-12fb62903188'),('2025-11-23 10:07:28.276981',NULL,'2025-11-23 10:07:28.290998',420,420,'91413c184f394807978c24e936e5c58f','02625968-4631-48fe-b493-3662f75967ff',134,'812e12744eb745bcadf0dcbfeff51a92','share_groups',-1,'2025-11-24 10:07:28',NULL),('2025-11-23 10:07:31.515042',NULL,'2025-11-23 10:07:31.547116',421,421,'91413c184f394807978c24e936e5c58f','2330bf72-a1b6-4db4-80d4-ebf108a40bdf',119,'812e12744eb745bcadf0dcbfeff51a92','shares',1,'2025-11-24 10:07:31',NULL),('2025-11-23 10:07:31.517731',NULL,'2025-11-23 10:07:31.547116',422,422,'91413c184f394807978c24e936e5c58f','e729e83f-0e89-4810-a919-764a62b2d7ea',118,'812e12744eb745bcadf0dcbfeff51a92','gigabytes',1,'2025-11-24 10:07:31',NULL),('2025-11-23 10:07:31.527478',NULL,'2025-11-23 10:07:31.547116',423,423,NULL,'ac3324ad-06c7-41ef-9211-0fbdcf8f7089',121,'812e12744eb745bcadf0dcbfeff51a92','shares',1,'2025-11-24 10:07:31','81f91fcf-5371-4d2d-b313-d95d4ff30ee0'),('2025-11-23 10:07:31.528629',NULL,'2025-11-23 10:07:31.547116',424,424,NULL,'b717b343-a7ce-4a2b-9ce5-bef437f2cd42',120,'812e12744eb745bcadf0dcbfeff51a92','gigabytes',1,'2025-11-24 10:07:31','81f91fcf-5371-4d2d-b313-d95d4ff30ee0'),('2025-11-23 10:07:32.273086',NULL,'2025-11-23 10:07:32.311326',425,425,'f15124f92efc44359ea2318339ae8c5f','bf5974eb-ce50-4d1e-9d3a-0e24c73f3f77',136,'eacae18cedc64027b1aed993d12bae03','shares',1,'2025-11-24 10:07:32',NULL),('2025-11-23 10:07:32.274522',NULL,'2025-11-23 10:07:32.311326',426,426,'f15124f92efc44359ea2318339ae8c5f','4089a77a-dbd0-4c56-b1c0-8527b6c9576d',135,'eacae18cedc64027b1aed993d12bae03','gigabytes',1,'2025-11-24 10:07:32',NULL),('2025-11-23 10:07:32.286666',NULL,'2025-11-23 10:07:32.311326',427,427,NULL,'ed20e295-d923-4867-b74b-44ac3a5718d0',138,'eacae18cedc64027b1aed993d12bae03','shares',1,'2025-11-24 10:07:32','bcb4f679-8ed1-45cb-b255-acaf2024be6d'),('2025-11-23 10:07:32.287867',NULL,'2025-11-23 10:07:32.311326',428,428,NULL,'a783177a-e121-4942-a05e-2955cb6a8d2b',137,'eacae18cedc64027b1aed993d12bae03','gigabytes',1,'2025-11-24 10:07:32','bcb4f679-8ed1-45cb-b255-acaf2024be6d'),('2025-11-23 10:07:33.093001',NULL,'2025-11-23 10:07:33.131208',429,429,'fa83c71a11144a75ae7f6512b3c55e59','1862906c-dca3-42a1-a713-5257774a8edd',140,'fb3243ddd12849b4ae87c500b5ea5cd3','shares',1,'2025-11-24 10:07:33',NULL),('2025-11-23 10:07:33.094330',NULL,'2025-11-23 10:07:33.131208',430,430,'fa83c71a11144a75ae7f6512b3c55e59','f2f5e280-5ced-4b9e-b5fc-048eaf8bad38',139,'fb3243ddd12849b4ae87c500b5ea5cd3','gigabytes',1,'2025-11-24 10:07:33',NULL),('2025-11-23 10:07:33.106587',NULL,'2025-11-23 10:07:33.131208',431,431,NULL,'03de8bde-594b-47b9-a66c-4435d2e4a6c0',142,'fb3243ddd12849b4ae87c500b5ea5cd3','shares',1,'2025-11-24 10:07:33','77f83cd8-f8c9-4a6a-aedc-a1d834cdd33d'),('2025-11-23 10:07:33.108100',NULL,'2025-11-23 10:07:33.131208',432,432,NULL,'9789b6d9-2914-46b0-bb3c-4d11b5cd0ab5',141,'fb3243ddd12849b4ae87c500b5ea5cd3','gigabytes',1,'2025-11-24 10:07:33','77f83cd8-f8c9-4a6a-aedc-a1d834cdd33d'),('2025-11-23 10:07:35.230792',NULL,'2025-11-23 10:07:35.253327',433,433,'91413c184f394807978c24e936e5c58f','79230faa-96f8-44d2-bc71-25e79d1983b3',119,'812e12744eb745bcadf0dcbfeff51a92','shares',-1,'2025-11-24 10:07:35',NULL),('2025-11-23 10:07:35.231732',NULL,'2025-11-23 10:07:35.253327',434,434,'91413c184f394807978c24e936e5c58f','26a41ee5-9168-46b1-991f-b6656f3c9bf4',118,'812e12744eb745bcadf0dcbfeff51a92','gigabytes',-1,'2025-11-24 10:07:35',NULL),('2025-11-23 10:07:35.243512',NULL,'2025-11-23 10:07:35.253327',435,435,NULL,'ce29504a-e655-499d-a82a-dab05c8a46fe',121,'812e12744eb745bcadf0dcbfeff51a92','shares',-1,'2025-11-24 10:07:35','81f91fcf-5371-4d2d-b313-d95d4ff30ee0'),('2025-11-23 10:07:35.244405',NULL,'2025-11-23 10:07:35.253327',436,436,NULL,'61d2c836-5dac-46f7-a042-797d97cd5185',120,'812e12744eb745bcadf0dcbfeff51a92','gigabytes',-1,'2025-11-24 10:07:35','81f91fcf-5371-4d2d-b313-d95d4ff30ee0'),('2025-11-23 10:07:36.034642',NULL,'2025-11-23 10:07:36.046383',437,437,'f15124f92efc44359ea2318339ae8c5f','225d406c-330d-4015-9b53-02896c2f1e2a',136,'eacae18cedc64027b1aed993d12bae03','shares',-1,'2025-11-24 10:07:36',NULL),('2025-11-23 10:07:36.035707',NULL,'2025-11-23 10:07:36.046383',438,438,'f15124f92efc44359ea2318339ae8c5f','5a6703cb-fa49-4165-a9af-49191b98b4ba',135,'eacae18cedc64027b1aed993d12bae03','gigabytes',-1,'2025-11-24 10:07:36',NULL),('2025-11-23 10:07:36.040346',NULL,'2025-11-23 10:07:36.046383',439,439,NULL,'9844950e-509d-4f12-a26e-ea907afbc92d',138,'eacae18cedc64027b1aed993d12bae03','shares',-1,'2025-11-24 10:07:36','bcb4f679-8ed1-45cb-b255-acaf2024be6d'),('2025-11-23 10:07:36.040913',NULL,'2025-11-23 10:07:36.046383',440,440,NULL,'7d9b7d0c-2cb5-4b1c-816b-0dd7eab7fddd',137,'eacae18cedc64027b1aed993d12bae03','gigabytes',-1,'2025-11-24 10:07:36','bcb4f679-8ed1-45cb-b255-acaf2024be6d'),('2025-11-23 10:07:36.197545',NULL,'2025-11-23 10:07:36.234936',441,441,'f15124f92efc44359ea2318339ae8c5f','2cbe8949-49bb-487a-8759-77a5f09af492',136,'eacae18cedc64027b1aed993d12bae03','shares',1,'2025-11-24 10:07:36',NULL),('2025-11-23 10:07:36.199825',NULL,'2025-11-23 10:07:36.234936',442,442,'f15124f92efc44359ea2318339ae8c5f','d11972e1-eb0f-49a6-8768-a08f90b2f0fb',135,'eacae18cedc64027b1aed993d12bae03','gigabytes',1,'2025-11-24 10:07:36',NULL),('2025-11-23 10:07:36.210563',NULL,'2025-11-23 10:07:36.234936',443,443,NULL,'9544e2e4-487c-4466-8291-3d78f4b4874e',144,'eacae18cedc64027b1aed993d12bae03','shares',1,'2025-11-24 10:07:36','4769b174-fe24-419e-962f-4e00c0886b66'),('2025-11-23 10:07:36.211778',NULL,'2025-11-23 10:07:36.234936',444,444,NULL,'7be94c82-d594-473e-a428-a5e2ea65067f',143,'eacae18cedc64027b1aed993d12bae03','gigabytes',1,'2025-11-24 10:07:36','4769b174-fe24-419e-962f-4e00c0886b66'),('2025-11-23 10:07:36.912261',NULL,'2025-11-23 10:07:36.934329',445,445,'fa83c71a11144a75ae7f6512b3c55e59','a5119d11-72b8-4af4-b6f7-c1f55b0e4b53',140,'fb3243ddd12849b4ae87c500b5ea5cd3','shares',-1,'2025-11-24 10:07:36',NULL),('2025-11-23 10:07:36.913276',NULL,'2025-11-23 10:07:36.934329',446,446,'fa83c71a11144a75ae7f6512b3c55e59','dbb00070-daa4-4dab-9d77-c5780697350e',139,'fb3243ddd12849b4ae87c500b5ea5cd3','gigabytes',-1,'2025-11-24 10:07:36',NULL),('2025-11-23 10:07:36.923881',NULL,'2025-11-23 10:07:36.934329',447,447,NULL,'0af4f1eb-65d3-4448-b508-dd159ab87be0',142,'fb3243ddd12849b4ae87c500b5ea5cd3','shares',-1,'2025-11-24 10:07:36','77f83cd8-f8c9-4a6a-aedc-a1d834cdd33d'),('2025-11-23 10:07:36.926927',NULL,'2025-11-23 10:07:36.934329',448,448,NULL,'aac66c33-014f-4fc2-a015-bfa683080136',141,'fb3243ddd12849b4ae87c500b5ea5cd3','gigabytes',-1,'2025-11-24 10:07:36','77f83cd8-f8c9-4a6a-aedc-a1d834cdd33d'),('2025-11-23 10:07:38.125677',NULL,'2025-11-23 10:07:38.174495',449,449,'91413c184f394807978c24e936e5c58f','859f61ce-877b-407c-8470-62562bc7efe7',119,'812e12744eb745bcadf0dcbfeff51a92','shares',1,'2025-11-24 10:07:38',NULL),('2025-11-23 10:07:38.127299',NULL,'2025-11-23 10:07:38.174495',450,450,'91413c184f394807978c24e936e5c58f','869adfe3-9966-4562-98c3-bbd015d7a190',118,'812e12744eb745bcadf0dcbfeff51a92','gigabytes',1,'2025-11-24 10:07:38',NULL),('2025-11-23 10:07:38.136115',NULL,'2025-11-23 10:07:38.174495',451,451,NULL,'d2f10de8-d102-4734-bc80-86593dea6932',121,'812e12744eb745bcadf0dcbfeff51a92','shares',1,'2025-11-24 10:07:38','81f91fcf-5371-4d2d-b313-d95d4ff30ee0'),('2025-11-23 10:07:38.137333',NULL,'2025-11-23 10:07:38.174495',452,452,NULL,'6065b578-6eed-4782-a00d-121e3c5b8889',120,'812e12744eb745bcadf0dcbfeff51a92','gigabytes',1,'2025-11-24 10:07:38','81f91fcf-5371-4d2d-b313-d95d4ff30ee0'),('2025-11-23 10:07:39.623971',NULL,'2025-11-23 10:07:39.635809',453,453,'f15124f92efc44359ea2318339ae8c5f','57af6e4c-e07f-4bc2-8a94-5950ea998fe7',136,'eacae18cedc64027b1aed993d12bae03','shares',-1,'2025-11-24 10:07:39',NULL),('2025-11-23 10:07:39.624655',NULL,'2025-11-23 10:07:39.635809',454,454,'f15124f92efc44359ea2318339ae8c5f','c355049e-4ec0-48a7-b5ed-f12cc029f0f8',135,'eacae18cedc64027b1aed993d12bae03','gigabytes',-1,'2025-11-24 10:07:39',NULL),('2025-11-23 10:07:39.629336',NULL,'2025-11-23 10:07:39.635809',455,455,NULL,'ee2066d0-4e9f-4f23-8b45-b0cdb9b9c003',144,'eacae18cedc64027b1aed993d12bae03','shares',-1,'2025-11-24 10:07:39','4769b174-fe24-419e-962f-4e00c0886b66'),('2025-11-23 10:07:39.629989',NULL,'2025-11-23 10:07:39.635809',456,456,NULL,'75694566-d99e-48d2-bcd5-eb040cc0845b',143,'eacae18cedc64027b1aed993d12bae03','gigabytes',-1,'2025-11-24 10:07:39','4769b174-fe24-419e-962f-4e00c0886b66'),('2025-11-23 10:07:39.910569',NULL,'2025-11-23 10:07:39.983010',457,457,'f15124f92efc44359ea2318339ae8c5f','7a397c9f-0239-4877-ba15-54a69fe8dc1d',136,'eacae18cedc64027b1aed993d12bae03','shares',1,'2025-11-24 10:07:39',NULL),('2025-11-23 10:07:39.916296',NULL,'2025-11-23 10:07:39.983010',458,458,'f15124f92efc44359ea2318339ae8c5f','f63d7233-c82a-4e47-bcf0-e87feabd6438',135,'eacae18cedc64027b1aed993d12bae03','gigabytes',1,'2025-11-24 10:07:39',NULL),('2025-11-23 10:07:39.931924',NULL,'2025-11-23 10:07:39.983010',459,459,NULL,'1caac24d-a6eb-4b1c-a9b3-17d7ce0f5605',146,'eacae18cedc64027b1aed993d12bae03','shares',1,'2025-11-24 10:07:39','d97a78d5-ab14-4738-b545-26638365ac91'),('2025-11-23 10:07:39.934255',NULL,'2025-11-23 10:07:39.983010',460,460,NULL,'3d7dafca-690a-41a8-b1b2-9974de62ab20',145,'eacae18cedc64027b1aed993d12bae03','gigabytes',1,'2025-11-24 10:07:39','d97a78d5-ab14-4738-b545-26638365ac91'),('2025-11-23 10:07:41.906243',NULL,'2025-11-23 10:07:41.927743',461,461,'91413c184f394807978c24e936e5c58f','56e3206f-60d3-42eb-8374-72fbae838581',119,'812e12744eb745bcadf0dcbfeff51a92','shares',-1,'2025-11-24 10:07:41',NULL),('2025-11-23 10:07:41.907238',NULL,'2025-11-23 10:07:41.927743',462,462,'91413c184f394807978c24e936e5c58f','110ec595-c3ba-43f4-bed7-f761dad87d25',118,'812e12744eb745bcadf0dcbfeff51a92','gigabytes',-1,'2025-11-24 10:07:41',NULL),('2025-11-23 10:07:41.919833',NULL,'2025-11-23 10:07:41.927743',463,463,NULL,'b19ba81a-1d46-40a8-8e11-55e5db7b0164',121,'812e12744eb745bcadf0dcbfeff51a92','shares',-1,'2025-11-24 10:07:41','81f91fcf-5371-4d2d-b313-d95d4ff30ee0'),('2025-11-23 10:07:41.920733',NULL,'2025-11-23 10:07:41.927743',464,464,NULL,'0c49378f-1ec4-4bd9-bafd-c6c720000eea',120,'812e12744eb745bcadf0dcbfeff51a92','gigabytes',-1,'2025-11-24 10:07:41','81f91fcf-5371-4d2d-b313-d95d4ff30ee0'),('2025-11-23 10:07:43.473252',NULL,'2025-11-23 10:07:43.509087',465,465,'d7518d96a3d24bcc8f6074244df9b08c','4be6d6dd-6128-4ba2-81bf-9a5555eddd66',148,'7d5d0eedb7da49fa8ee42f6251191fd6','shares',1,'2025-11-24 10:07:43',NULL),('2025-11-23 10:07:43.474270',NULL,'2025-11-23 10:07:43.509087',466,466,'d7518d96a3d24bcc8f6074244df9b08c','150d5d67-cde6-444c-bf20-c1f2e442bbb3',147,'7d5d0eedb7da49fa8ee42f6251191fd6','gigabytes',1,'2025-11-24 10:07:43',NULL),('2025-11-23 10:07:43.489316',NULL,'2025-11-23 10:07:43.509087',467,467,NULL,'490e7010-87c9-447e-ba77-3734ccd63f34',150,'7d5d0eedb7da49fa8ee42f6251191fd6','shares',1,'2025-11-24 10:07:43','944835ee-926f-443d-91cc-ff72067886e2'),('2025-11-23 10:07:43.490434',NULL,'2025-11-23 10:07:43.509087',468,468,NULL,'0eabe957-9930-497d-be63-d289971c66d7',149,'7d5d0eedb7da49fa8ee42f6251191fd6','gigabytes',1,'2025-11-24 10:07:43','944835ee-926f-443d-91cc-ff72067886e2'),('2025-11-23 10:07:43.594577',NULL,'2025-11-23 10:07:43.633998',469,469,'46bc233a14ac463584fc9a98352f3940','7985e33a-797c-46de-8260-880e4d80a928',152,'c4833c469f9b4254b420faba19b493d6','shares',1,'2025-11-24 10:07:43',NULL),('2025-11-23 10:07:43.595844',NULL,'2025-11-23 10:07:43.633998',470,470,'46bc233a14ac463584fc9a98352f3940','c879bb83-5402-4318-a32a-c6b33c725b54',151,'c4833c469f9b4254b420faba19b493d6','gigabytes',1,'2025-11-24 10:07:43',NULL),('2025-11-23 10:07:43.608702',NULL,'2025-11-23 10:07:43.633998',471,471,NULL,'42770b00-e51f-45aa-9b69-6b3dcf0c0ba9',154,'c4833c469f9b4254b420faba19b493d6','shares',1,'2025-11-24 10:07:43','230d231f-5b82-4f03-bab6-0574ee6b85ff'),('2025-11-23 10:07:43.610195',NULL,'2025-11-23 10:07:43.633998',472,472,NULL,'2cd174d7-421a-4cc3-8912-f30b88ed7a48',153,'c4833c469f9b4254b420faba19b493d6','gigabytes',1,'2025-11-24 10:07:43','230d231f-5b82-4f03-bab6-0574ee6b85ff'),('2025-11-23 10:07:46.436665',NULL,'2025-11-23 10:07:46.455306',473,473,'f15124f92efc44359ea2318339ae8c5f','f5348940-a130-4677-8fce-fabb44ff40d3',136,'eacae18cedc64027b1aed993d12bae03','shares',-1,'2025-11-24 10:07:46',NULL),('2025-11-23 10:07:46.437717',NULL,'2025-11-23 10:07:46.455306',474,474,'f15124f92efc44359ea2318339ae8c5f','f55533f8-ee59-4b83-94d4-3eb210ec7342',135,'eacae18cedc64027b1aed993d12bae03','gigabytes',-1,'2025-11-24 10:07:46',NULL),('2025-11-23 10:07:46.444886',NULL,'2025-11-23 10:07:46.455306',475,475,NULL,'deb640f1-db61-4725-86f4-4a710c0a753e',146,'eacae18cedc64027b1aed993d12bae03','shares',-1,'2025-11-24 10:07:46','d97a78d5-ab14-4738-b545-26638365ac91'),('2025-11-23 10:07:46.447059',NULL,'2025-11-23 10:07:46.455306',476,476,NULL,'b8317180-5f42-42e2-8bed-525765dbdea5',145,'eacae18cedc64027b1aed993d12bae03','gigabytes',-1,'2025-11-24 10:07:46','d97a78d5-ab14-4738-b545-26638365ac91'),('2025-11-23 10:07:46.560699',NULL,'2025-11-23 10:07:46.615821',477,477,'f15124f92efc44359ea2318339ae8c5f','cdff0f5d-63cf-4cf0-a4f1-2ab2bdb61402',136,'eacae18cedc64027b1aed993d12bae03','shares',1,'2025-11-24 10:07:46',NULL),('2025-11-23 10:07:46.563192',NULL,'2025-11-23 10:07:46.615821',478,478,'f15124f92efc44359ea2318339ae8c5f','4e7c2c30-e257-4fdd-9970-bc2e7b7485a6',135,'eacae18cedc64027b1aed993d12bae03','gigabytes',1,'2025-11-24 10:07:46',NULL),('2025-11-23 10:07:46.577758',NULL,'2025-11-23 10:07:46.615821',479,479,NULL,'eafac575-fbdd-452c-8ecb-b6362d2647fe',156,'eacae18cedc64027b1aed993d12bae03','shares',1,'2025-11-24 10:07:46','448cd856-b926-4d99-a121-6d8c610bbd9a'),('2025-11-23 10:07:46.579219',NULL,'2025-11-23 10:07:46.615821',480,480,NULL,'61ddbc77-a0e4-489d-8db9-d8fd8cecae34',155,'eacae18cedc64027b1aed993d12bae03','gigabytes',1,'2025-11-24 10:07:46','448cd856-b926-4d99-a121-6d8c610bbd9a'),('2025-11-23 10:07:46.748278',NULL,'2025-11-23 10:07:46.871410',481,481,'d7518d96a3d24bcc8f6074244df9b08c','a4c2c1b6-2d55-4db5-b4fd-c8cc5af41c1a',157,'7d5d0eedb7da49fa8ee42f6251191fd6','snapshots',1,'2025-11-24 10:07:46',NULL),('2025-11-23 10:07:46.749575',NULL,'2025-11-23 10:07:46.871410',482,482,'d7518d96a3d24bcc8f6074244df9b08c','315a060f-ab06-4ea7-9d69-65d702e00d30',158,'7d5d0eedb7da49fa8ee42f6251191fd6','snapshot_gigabytes',1,'2025-11-24 10:07:46',NULL),('2025-11-23 10:07:46.764261',NULL,'2025-11-23 10:07:46.871410',483,483,NULL,'f2ac5305-d553-4475-8c8e-b251cd7155d8',159,'7d5d0eedb7da49fa8ee42f6251191fd6','snapshots',1,'2025-11-24 10:07:46','944835ee-926f-443d-91cc-ff72067886e2'),('2025-11-23 10:07:46.765401',NULL,'2025-11-23 10:07:46.871410',484,484,NULL,'6541a0bb-6fc7-4aec-887b-7162c29662e2',160,'7d5d0eedb7da49fa8ee42f6251191fd6','snapshot_gigabytes',1,'2025-11-24 10:07:46','944835ee-926f-443d-91cc-ff72067886e2'),('2025-11-23 10:07:46.856861',NULL,'2025-11-23 10:07:46.943661',485,485,'46bc233a14ac463584fc9a98352f3940','52c29d39-7ca0-4524-9e48-da4036161510',162,'c4833c469f9b4254b420faba19b493d6','snapshots',1,'2025-11-24 10:07:46',NULL),('2025-11-23 10:07:46.858196',NULL,'2025-11-23 10:07:46.943661',486,486,'46bc233a14ac463584fc9a98352f3940','e72fee96-b0d3-4b6e-b068-82eb064ed35a',161,'c4833c469f9b4254b420faba19b493d6','snapshot_gigabytes',1,'2025-11-24 10:07:46',NULL),('2025-11-23 10:07:46.883459',NULL,'2025-11-23 10:07:46.943661',487,487,NULL,'efc7749d-2c1a-4bb7-867e-50c8504f47a7',164,'c4833c469f9b4254b420faba19b493d6','snapshots',1,'2025-11-24 10:07:46','230d231f-5b82-4f03-bab6-0574ee6b85ff'),('2025-11-23 10:07:46.885067',NULL,'2025-11-23 10:07:46.943661',488,488,NULL,'e0f24459-2c41-401d-b495-cb2dbf81a67a',163,'c4833c469f9b4254b420faba19b493d6','snapshot_gigabytes',1,'2025-11-24 10:07:46','230d231f-5b82-4f03-bab6-0574ee6b85ff'),('2025-11-23 10:07:50.361832',NULL,'2025-11-23 10:07:50.438129',489,489,'d7518d96a3d24bcc8f6074244df9b08c','c8bae923-b369-47c8-8fa8-0cadff80dd32',157,'7d5d0eedb7da49fa8ee42f6251191fd6','snapshots',1,'2025-11-24 10:07:50',NULL),('2025-11-23 10:07:50.363187',NULL,'2025-11-23 10:07:50.438129',490,490,'d7518d96a3d24bcc8f6074244df9b08c','6e605b56-ee47-4cfa-85ba-437cef22ca22',158,'7d5d0eedb7da49fa8ee42f6251191fd6','snapshot_gigabytes',1,'2025-11-24 10:07:50',NULL),('2025-11-23 10:07:50.370122',NULL,'2025-11-23 10:07:50.438129',491,491,NULL,'89e8458b-e553-491e-b939-955d4e653939',159,'7d5d0eedb7da49fa8ee42f6251191fd6','snapshots',1,'2025-11-24 10:07:50','944835ee-926f-443d-91cc-ff72067886e2'),('2025-11-23 10:07:50.371723',NULL,'2025-11-23 10:07:50.438129',492,492,NULL,'5250b8a3-680a-4897-a0ef-df9edc5239c7',160,'7d5d0eedb7da49fa8ee42f6251191fd6','snapshot_gigabytes',1,'2025-11-24 10:07:50','944835ee-926f-443d-91cc-ff72067886e2'),('2025-11-23 10:07:51.253894',NULL,'2025-11-23 10:07:51.275944',493,493,'46bc233a14ac463584fc9a98352f3940','40ee3c8d-890b-4056-a742-d61e74c70529',162,'c4833c469f9b4254b420faba19b493d6','snapshots',-1,'2025-11-24 10:07:51',NULL),('2025-11-23 10:07:51.255485',NULL,'2025-11-23 10:07:51.275944',494,494,'46bc233a14ac463584fc9a98352f3940','ecf8c067-1774-4790-ad51-b7836e990a8f',161,'c4833c469f9b4254b420faba19b493d6','snapshot_gigabytes',-1,'2025-11-24 10:07:51',NULL),('2025-11-23 10:07:51.266105',NULL,'2025-11-23 10:07:51.275944',495,495,NULL,'b9685d6a-1266-4aa5-aa92-809bbe41bf00',164,'c4833c469f9b4254b420faba19b493d6','snapshots',-1,'2025-11-24 10:07:51','230d231f-5b82-4f03-bab6-0574ee6b85ff'),('2025-11-23 10:07:51.266904',NULL,'2025-11-23 10:07:51.275944',496,496,NULL,'af3ca8b4-5d3f-48c6-95d6-a392db79a3a6',163,'c4833c469f9b4254b420faba19b493d6','snapshot_gigabytes',-1,'2025-11-24 10:07:51','230d231f-5b82-4f03-bab6-0574ee6b85ff'),('2025-11-23 10:07:53.079067',NULL,'2025-11-23 10:07:53.103174',497,497,'f15124f92efc44359ea2318339ae8c5f','c8789155-fc43-4e97-9b1c-10d2f59f3394',136,'eacae18cedc64027b1aed993d12bae03','shares',-1,'2025-11-24 10:07:53',NULL),('2025-11-23 10:07:53.080737',NULL,'2025-11-23 10:07:53.103174',498,498,'f15124f92efc44359ea2318339ae8c5f','fbab4dd2-6208-4e38-906c-138077a0f19b',135,'eacae18cedc64027b1aed993d12bae03','gigabytes',-1,'2025-11-24 10:07:53',NULL),('2025-11-23 10:07:53.089741',NULL,'2025-11-23 10:07:53.103174',499,499,NULL,'8f038899-7f96-44aa-9778-e932a700f4a3',156,'eacae18cedc64027b1aed993d12bae03','shares',-1,'2025-11-24 10:07:53','448cd856-b926-4d99-a121-6d8c610bbd9a'),('2025-11-23 10:07:53.090867',NULL,'2025-11-23 10:07:53.103174',500,500,NULL,'ae6c16fc-0251-4179-bf07-25a68ec51c8b',155,'eacae18cedc64027b1aed993d12bae03','gigabytes',-1,'2025-11-24 10:07:53','448cd856-b926-4d99-a121-6d8c610bbd9a'),('2025-11-23 10:07:53.238502',NULL,'2025-11-23 10:07:53.299104',501,501,'f15124f92efc44359ea2318339ae8c5f','f8abae03-c7ec-45c3-961a-b2183e65f9bd',136,'eacae18cedc64027b1aed993d12bae03','shares',1,'2025-11-24 10:07:53',NULL),('2025-11-23 10:07:53.240510',NULL,'2025-11-23 10:07:53.299104',502,502,'f15124f92efc44359ea2318339ae8c5f','f98c6baa-5bba-4db1-90ef-267576c0adfc',135,'eacae18cedc64027b1aed993d12bae03','gigabytes',1,'2025-11-24 10:07:53',NULL),('2025-11-23 10:07:53.262655',NULL,'2025-11-23 10:07:53.299104',503,503,NULL,'64f3cfaf-cdd2-4cf6-9247-3d58c56e89ae',166,'eacae18cedc64027b1aed993d12bae03','shares',1,'2025-11-24 10:07:53','9d19f6ac-d78a-4389-b16c-25393beb65ae'),('2025-11-23 10:07:53.265193',NULL,'2025-11-23 10:07:53.299104',504,504,NULL,'f43a1103-8cba-4788-bbd5-c63bc0cf1985',165,'eacae18cedc64027b1aed993d12bae03','gigabytes',1,'2025-11-24 10:07:53','9d19f6ac-d78a-4389-b16c-25393beb65ae'),('2025-11-23 10:07:53.988573',NULL,'2025-11-23 10:07:54.045432',505,505,'6ddf5b73960b418b9ff8ae0cf037300b','db9480dc-b6e5-4c39-906d-817df2ef86b6',168,'e16872b51d7541b48411cbf0be50f6f2','shares',1,'2025-11-24 10:07:53',NULL),('2025-11-23 10:07:53.990402',NULL,'2025-11-23 10:07:54.045432',506,506,'6ddf5b73960b418b9ff8ae0cf037300b','4782db09-97e7-4146-8cca-af82e8c808c8',167,'e16872b51d7541b48411cbf0be50f6f2','gigabytes',1,'2025-11-24 10:07:53',NULL),('2025-11-23 10:07:54.011081',NULL,'2025-11-23 10:07:54.045432',507,507,NULL,'8613a920-ff45-48d6-9039-1f021f0b6f80',170,'e16872b51d7541b48411cbf0be50f6f2','shares',1,'2025-11-24 10:07:53','cb051e0e-daf9-4f97-96e5-03bb0af63a58'),('2025-11-23 10:07:54.013048',NULL,'2025-11-23 10:07:54.045432',508,508,NULL,'2b6cb069-d105-4850-8090-32d9f66741f7',169,'e16872b51d7541b48411cbf0be50f6f2','gigabytes',1,'2025-11-24 10:07:53','cb051e0e-daf9-4f97-96e5-03bb0af63a58'),('2025-11-23 10:07:54.475877',NULL,'2025-11-23 10:07:54.541539',509,509,'d7518d96a3d24bcc8f6074244df9b08c','1a477ddb-d788-4832-917d-d46d62307396',157,'7d5d0eedb7da49fa8ee42f6251191fd6','snapshots',-1,'2025-11-24 10:07:54',NULL),('2025-11-23 10:07:54.477558',NULL,'2025-11-23 10:07:54.541539',510,510,'d7518d96a3d24bcc8f6074244df9b08c','7a1f537a-3149-4d3b-a382-e48229c9121c',158,'7d5d0eedb7da49fa8ee42f6251191fd6','snapshot_gigabytes',-1,'2025-11-24 10:07:54',NULL),('2025-11-23 10:07:54.496508',NULL,'2025-11-23 10:07:54.541539',511,511,NULL,'4a6f9971-42d9-4feb-a6a7-9674ef9c05b5',159,'7d5d0eedb7da49fa8ee42f6251191fd6','snapshots',-1,'2025-11-24 10:07:54','944835ee-926f-443d-91cc-ff72067886e2'),('2025-11-23 10:07:54.497472',NULL,'2025-11-23 10:07:54.541539',512,512,NULL,'78dd7607-9ee8-4e6e-92e2-7676ac715d1f',160,'7d5d0eedb7da49fa8ee42f6251191fd6','snapshot_gigabytes',-1,'2025-11-24 10:07:54','944835ee-926f-443d-91cc-ff72067886e2'),('2025-11-23 10:07:54.628086',NULL,'2025-11-23 10:07:54.643315',513,513,'46bc233a14ac463584fc9a98352f3940','5d277bd9-5486-4b55-897c-d24b153eb644',152,'c4833c469f9b4254b420faba19b493d6','shares',-1,'2025-11-24 10:07:54',NULL),('2025-11-23 10:07:54.628900',NULL,'2025-11-23 10:07:54.643315',514,514,'46bc233a14ac463584fc9a98352f3940','2d1b154e-d68e-4764-812a-93e6237e7d28',151,'c4833c469f9b4254b420faba19b493d6','gigabytes',-1,'2025-11-24 10:07:54',NULL),('2025-11-23 10:07:54.634785',NULL,'2025-11-23 10:07:54.643315',515,515,NULL,'52f5f16f-f0c0-4b05-b4d0-fda24ba05b08',154,'c4833c469f9b4254b420faba19b493d6','shares',-1,'2025-11-24 10:07:54','230d231f-5b82-4f03-bab6-0574ee6b85ff'),('2025-11-23 10:07:54.635544',NULL,'2025-11-23 10:07:54.643315',516,516,NULL,'5a61801d-5b4d-4c4b-89cd-57d0412b2b60',153,'c4833c469f9b4254b420faba19b493d6','gigabytes',-1,'2025-11-24 10:07:54','230d231f-5b82-4f03-bab6-0574ee6b85ff'),('2025-11-23 10:07:57.287603',NULL,'2025-11-23 10:07:57.365546',517,517,'6ddf5b73960b418b9ff8ae0cf037300b','b229604a-7cb4-4f41-b23d-baef85d5be15',172,'e16872b51d7541b48411cbf0be50f6f2','snapshots',1,'2025-11-24 10:07:57',NULL),('2025-11-23 10:07:57.289340',NULL,'2025-11-23 10:07:57.365546',518,518,'6ddf5b73960b418b9ff8ae0cf037300b','cd485f17-7bcd-4afa-9d1e-aa1d9a1dd564',171,'e16872b51d7541b48411cbf0be50f6f2','snapshot_gigabytes',1,'2025-11-24 10:07:57',NULL),('2025-11-23 10:07:57.305291',NULL,'2025-11-23 10:07:57.365546',519,519,NULL,'2ce8309c-c5e9-43ff-8cd1-fb91e118f96c',174,'e16872b51d7541b48411cbf0be50f6f2','snapshots',1,'2025-11-24 10:07:57','cb051e0e-daf9-4f97-96e5-03bb0af63a58'),('2025-11-23 10:07:57.306853',NULL,'2025-11-23 10:07:57.365546',520,520,NULL,'54d4fe0a-7195-412e-a81e-a77527684a9f',173,'e16872b51d7541b48411cbf0be50f6f2','snapshot_gigabytes',1,'2025-11-24 10:07:57','cb051e0e-daf9-4f97-96e5-03bb0af63a58'),('2025-11-23 10:07:57.670596',NULL,'2025-11-23 10:07:57.688126',521,521,'d7518d96a3d24bcc8f6074244df9b08c','01a6827d-b123-4419-948c-035b5204a52a',157,'7d5d0eedb7da49fa8ee42f6251191fd6','snapshots',-1,'2025-11-24 10:07:57',NULL),('2025-11-23 10:07:57.671496',NULL,'2025-11-23 10:07:57.688126',522,522,'d7518d96a3d24bcc8f6074244df9b08c','f443f9b8-555c-4be0-8b6b-de0c27ffce2e',158,'7d5d0eedb7da49fa8ee42f6251191fd6','snapshot_gigabytes',-1,'2025-11-24 10:07:57',NULL),('2025-11-23 10:07:57.677938',NULL,'2025-11-23 10:07:57.688126',523,523,NULL,'3b307c4e-9b78-409a-8392-8d6f7fe486fc',159,'7d5d0eedb7da49fa8ee42f6251191fd6','snapshots',-1,'2025-11-24 10:07:57','944835ee-926f-443d-91cc-ff72067886e2'),('2025-11-23 10:07:57.678838',NULL,'2025-11-23 10:07:57.688126',524,524,NULL,'dd102152-e87a-4718-b2f1-6f393f1a889b',160,'7d5d0eedb7da49fa8ee42f6251191fd6','snapshot_gigabytes',-1,'2025-11-24 10:07:57','944835ee-926f-443d-91cc-ff72067886e2'),('2025-11-23 10:07:59.792607',NULL,'2025-11-23 10:07:59.821069',525,525,'f15124f92efc44359ea2318339ae8c5f','cbdad0e7-8fb8-4eb0-9098-dc01464aeb43',136,'eacae18cedc64027b1aed993d12bae03','shares',-1,'2025-11-24 10:07:59',NULL),('2025-11-23 10:07:59.795462',NULL,'2025-11-23 10:07:59.821069',526,526,'f15124f92efc44359ea2318339ae8c5f','94d822ae-fb43-4450-b86c-35d09b190b54',135,'eacae18cedc64027b1aed993d12bae03','gigabytes',-1,'2025-11-24 10:07:59',NULL),('2025-11-23 10:07:59.805170',NULL,'2025-11-23 10:07:59.821069',527,527,NULL,'f40eabcf-d56d-4467-84fb-029df1ae1e40',166,'eacae18cedc64027b1aed993d12bae03','shares',-1,'2025-11-24 10:07:59','9d19f6ac-d78a-4389-b16c-25393beb65ae'),('2025-11-23 10:07:59.806877',NULL,'2025-11-23 10:07:59.821069',528,528,NULL,'6e9cc274-9f7a-4f90-923d-10c818c48e43',165,'eacae18cedc64027b1aed993d12bae03','gigabytes',-1,'2025-11-24 10:07:59','9d19f6ac-d78a-4389-b16c-25393beb65ae'),('2025-11-23 10:08:00.912234',NULL,'2025-11-23 10:08:00.945015',529,529,'d7518d96a3d24bcc8f6074244df9b08c','af7182c7-561e-4480-b557-4a6e07bfc1a4',148,'7d5d0eedb7da49fa8ee42f6251191fd6','shares',-1,'2025-11-24 10:08:00',NULL),('2025-11-23 10:08:00.913020',NULL,'2025-11-23 10:08:00.945015',530,530,'d7518d96a3d24bcc8f6074244df9b08c','1e553a04-bca7-47d5-9dec-1b69de80fd06',147,'7d5d0eedb7da49fa8ee42f6251191fd6','gigabytes',-1,'2025-11-24 10:08:00',NULL),('2025-11-23 10:08:00.927025',NULL,'2025-11-23 10:08:00.945015',531,531,NULL,'5b0dfe70-11e5-42a6-9a6c-428b55d54f57',150,'7d5d0eedb7da49fa8ee42f6251191fd6','shares',-1,'2025-11-24 10:08:00','944835ee-926f-443d-91cc-ff72067886e2'),('2025-11-23 10:08:00.928387',NULL,'2025-11-23 10:08:00.945015',532,532,NULL,'f09d4f4c-f1a2-42a3-901d-9e33b247d9b4',149,'7d5d0eedb7da49fa8ee42f6251191fd6','gigabytes',-1,'2025-11-24 10:08:00','944835ee-926f-443d-91cc-ff72067886e2'),('2025-11-23 10:08:02.038199',NULL,'2025-11-23 10:08:02.059672',533,533,'6ddf5b73960b418b9ff8ae0cf037300b','ad7b6569-bbb9-4e47-9473-71c251f50fe1',172,'e16872b51d7541b48411cbf0be50f6f2','snapshots',-1,'2025-11-24 10:08:01',NULL),('2025-11-23 10:08:02.039717',NULL,'2025-11-23 10:08:02.059672',534,534,'6ddf5b73960b418b9ff8ae0cf037300b','cc8f7142-65f0-4a6c-96a2-c03c9118312a',171,'e16872b51d7541b48411cbf0be50f6f2','snapshot_gigabytes',-1,'2025-11-24 10:08:01',NULL),('2025-11-23 10:08:02.050161',NULL,'2025-11-23 10:08:02.059672',535,535,NULL,'0910a318-7ea2-4568-bc08-1dfef9fa9062',174,'e16872b51d7541b48411cbf0be50f6f2','snapshots',-1,'2025-11-24 10:08:01','cb051e0e-daf9-4f97-96e5-03bb0af63a58'),('2025-11-23 10:08:02.051142',NULL,'2025-11-23 10:08:02.059672',536,536,NULL,'6591c489-589e-47e6-be4d-6b512eaa1da6',173,'e16872b51d7541b48411cbf0be50f6f2','snapshot_gigabytes',-1,'2025-11-24 10:08:01','cb051e0e-daf9-4f97-96e5-03bb0af63a58'),('2025-11-23 10:08:05.106077',NULL,'2025-11-23 10:08:05.142785',537,537,'1fcabcd5e8ef4405bd339551808f018a','b2a1f7d8-8dab-4565-9e39-5e15659b08c2',175,'dfc6681c099d46f0a904bf9eea736c22','share_networks',1,'2025-11-24 10:08:05',NULL),('2025-11-23 10:08:05.215981',NULL,'2025-11-23 10:08:05.232119',538,538,'6ddf5b73960b418b9ff8ae0cf037300b','fd06ac44-5fc7-40a4-8f53-c4c8e069d908',168,'e16872b51d7541b48411cbf0be50f6f2','shares',-1,'2025-11-24 10:08:05',NULL),('2025-11-23 10:08:05.216934',NULL,'2025-11-23 10:08:05.232119',539,539,'6ddf5b73960b418b9ff8ae0cf037300b','03463851-cd94-483b-a451-8a28db6ca72f',167,'e16872b51d7541b48411cbf0be50f6f2','gigabytes',-1,'2025-11-24 10:08:05',NULL),('2025-11-23 10:08:05.223660',NULL,'2025-11-23 10:08:05.232119',540,540,NULL,'0cf10565-eae7-4984-a45f-c1939e6c8a3b',170,'e16872b51d7541b48411cbf0be50f6f2','shares',-1,'2025-11-24 10:08:05','cb051e0e-daf9-4f97-96e5-03bb0af63a58'),('2025-11-23 10:08:05.224416',NULL,'2025-11-23 10:08:05.232119',541,541,NULL,'dda9ee00-0a0d-4007-a736-170d24348b69',169,'e16872b51d7541b48411cbf0be50f6f2','gigabytes',-1,'2025-11-24 10:08:05','cb051e0e-daf9-4f97-96e5-03bb0af63a58'),('2025-11-23 10:08:05.272539',NULL,'2025-11-23 10:08:05.279888',542,542,'1fcabcd5e8ef4405bd339551808f018a','7d4445a1-9ab6-4996-bd10-65f022188d70',175,'dfc6681c099d46f0a904bf9eea736c22','share_networks',-1,'2025-11-24 10:08:05',NULL),('2025-11-23 10:08:05.413260',NULL,'2025-11-23 10:08:05.449436',543,543,'1fcabcd5e8ef4405bd339551808f018a','61d262a4-a8e6-48da-a967-ec97a0c708d3',175,'dfc6681c099d46f0a904bf9eea736c22','share_networks',1,'2025-11-24 10:08:05',NULL),('2025-11-23 10:08:06.208357',NULL,'2025-11-23 10:08:06.227462',544,544,'1fcabcd5e8ef4405bd339551808f018a','9e65558a-c8f9-426c-8170-77c3bf0e3d4b',175,'dfc6681c099d46f0a904bf9eea736c22','share_networks',-1,'2025-11-24 10:08:06',NULL),('2025-11-23 10:08:06.402249',NULL,'2025-11-23 10:08:06.436939',545,545,'1fcabcd5e8ef4405bd339551808f018a','e15d83bf-4655-4e3c-b734-247ccb2872c8',175,'dfc6681c099d46f0a904bf9eea736c22','share_networks',1,'2025-11-24 10:08:06',NULL),('2025-11-23 10:08:06.542429',NULL,'2025-11-23 10:08:06.550885',546,546,'1fcabcd5e8ef4405bd339551808f018a','49d85e60-17ce-4bf8-b61e-0e35090b720e',175,'dfc6681c099d46f0a904bf9eea736c22','share_networks',-1,'2025-11-24 10:08:06',NULL),('2025-11-23 10:08:09.487047',NULL,'2025-11-23 10:08:09.542779',547,547,'2d3e494889b14951b8175b37f8c3f5e5','59180793-0df5-4a8e-a283-56e930eac744',177,'fca85941970a450aaec057ef036f1a27','shares',1,'2025-11-24 10:08:09',NULL),('2025-11-23 10:08:09.491755',NULL,'2025-11-23 10:08:09.542779',548,548,'2d3e494889b14951b8175b37f8c3f5e5','6eef8061-f807-40c2-b4a1-70dfbb55987a',176,'fca85941970a450aaec057ef036f1a27','gigabytes',1,'2025-11-24 10:08:09',NULL),('2025-11-23 10:08:09.508307',NULL,'2025-11-23 10:08:09.542779',549,549,NULL,'87e13e80-e1ad-49d1-8e37-2fff9eaa7faf',179,'fca85941970a450aaec057ef036f1a27','shares',1,'2025-11-24 10:08:09','195b3608-b444-4e1d-a907-24363ddba087'),('2025-11-23 10:08:09.509967',NULL,'2025-11-23 10:08:09.542779',550,550,NULL,'b39f567b-addd-49de-b74a-5ae3cb5881ce',178,'fca85941970a450aaec057ef036f1a27','gigabytes',1,'2025-11-24 10:08:09','195b3608-b444-4e1d-a907-24363ddba087'),('2025-11-23 10:08:10.112190',NULL,'2025-11-23 10:08:10.176762',551,551,'c26f0e94847c4498b641d36cd7f9e893','3d8b8ed5-24ed-4737-8811-718aac630b46',181,'09121c745ed044f4ac1be69b2e85b19c','shares',1,'2025-11-24 10:08:10',NULL),('2025-11-23 10:08:10.114017',NULL,'2025-11-23 10:08:10.176762',552,552,'c26f0e94847c4498b641d36cd7f9e893','e262c55f-8a01-46c2-b306-3b7373fcedce',180,'09121c745ed044f4ac1be69b2e85b19c','gigabytes',1,'2025-11-24 10:08:10',NULL),('2025-11-23 10:08:10.131994',NULL,'2025-11-23 10:08:10.176762',553,553,NULL,'fa7a8e3e-68a2-444d-9fc2-bac787a17883',183,'09121c745ed044f4ac1be69b2e85b19c','shares',1,'2025-11-24 10:08:10','6689aa2c-a3da-4ed8-ad2f-76109636c54e'),('2025-11-23 10:08:10.134735',NULL,'2025-11-23 10:08:10.176762',554,554,NULL,'f929a446-8f9a-4d9d-bc55-34995b855d1d',182,'09121c745ed044f4ac1be69b2e85b19c','gigabytes',1,'2025-11-24 10:08:10','6689aa2c-a3da-4ed8-ad2f-76109636c54e'),('2025-11-23 10:08:11.695099',NULL,'2025-11-23 10:08:11.745266',555,555,'dce881a0acdf499699d2b927482308f5','9f9a3032-7f46-435a-ba30-83bacd7b8d0e',185,'3893741994fb4b789f253fc559e364df','shares',1,'2025-11-24 10:08:11',NULL),('2025-11-23 10:08:11.696974',NULL,'2025-11-23 10:08:11.745266',556,556,'dce881a0acdf499699d2b927482308f5','b4dcabf9-7047-4638-9068-49770fb29dbb',184,'3893741994fb4b789f253fc559e364df','gigabytes',1,'2025-11-24 10:08:11',NULL),('2025-11-23 10:08:11.710108',NULL,'2025-11-23 10:08:11.745266',557,557,NULL,'b89ec4a4-7db1-47b9-b967-2ff8bcbf5f98',187,'3893741994fb4b789f253fc559e364df','shares',1,'2025-11-24 10:08:11','73750294-0b00-436c-b3a6-b36cbb7b5ac3'),('2025-11-23 10:08:11.713438',NULL,'2025-11-23 10:08:11.745266',558,558,NULL,'7c80111e-eed4-476a-b1fb-9ad350973930',186,'3893741994fb4b789f253fc559e364df','gigabytes',1,'2025-11-24 10:08:11','73750294-0b00-436c-b3a6-b36cbb7b5ac3'),('2025-11-23 10:08:13.449964',NULL,'2025-11-23 10:08:13.553476',559,559,'c26f0e94847c4498b641d36cd7f9e893','114d3684-253f-483d-b4d3-cf9704cb6451',188,'09121c745ed044f4ac1be69b2e85b19c','snapshots',1,'2025-11-24 10:08:13',NULL),('2025-11-23 10:08:13.452070',NULL,'2025-11-23 10:08:13.553476',560,560,'c26f0e94847c4498b641d36cd7f9e893','55d4bf7d-a8e7-4aa0-945d-9f8eab7fc401',189,'09121c745ed044f4ac1be69b2e85b19c','snapshot_gigabytes',1,'2025-11-24 10:08:13',NULL),('2025-11-23 10:08:13.466213',NULL,'2025-11-23 10:08:13.553476',561,561,NULL,'179eff63-41b8-43ce-b653-2d6ff9987f88',190,'09121c745ed044f4ac1be69b2e85b19c','snapshots',1,'2025-11-24 10:08:13','6689aa2c-a3da-4ed8-ad2f-76109636c54e'),('2025-11-23 10:08:13.467289',NULL,'2025-11-23 10:08:13.553476',562,562,NULL,'bab05f7b-7f21-46fa-b99d-b21b14e31494',191,'09121c745ed044f4ac1be69b2e85b19c','snapshot_gigabytes',1,'2025-11-24 10:08:13','6689aa2c-a3da-4ed8-ad2f-76109636c54e'),('2025-11-23 10:08:14.308123',NULL,'2025-11-23 10:08:14.322112',563,563,'2d3e494889b14951b8175b37f8c3f5e5','9edcccc5-a346-454c-b9a4-7dff7eabe853',177,'fca85941970a450aaec057ef036f1a27','shares',-1,'2025-11-24 10:08:14',NULL),('2025-11-23 10:08:14.308935',NULL,'2025-11-23 10:08:14.322112',564,564,'2d3e494889b14951b8175b37f8c3f5e5','5846a7dc-3cd5-4815-97dd-64fe2c9533d7',176,'fca85941970a450aaec057ef036f1a27','gigabytes',-1,'2025-11-24 10:08:14',NULL),('2025-11-23 10:08:14.314202',NULL,'2025-11-23 10:08:14.322112',565,565,NULL,'bb8e4553-136d-4a91-9be2-88b6cd04544b',179,'fca85941970a450aaec057ef036f1a27','shares',-1,'2025-11-24 10:08:14','195b3608-b444-4e1d-a907-24363ddba087'),('2025-11-23 10:08:14.315053',NULL,'2025-11-23 10:08:14.322112',566,566,NULL,'84138ca8-2043-42ac-9434-8c68bfb614a2',178,'fca85941970a450aaec057ef036f1a27','gigabytes',-1,'2025-11-24 10:08:14','195b3608-b444-4e1d-a907-24363ddba087'),('2025-11-23 10:08:15.130180',NULL,'2025-11-23 10:08:15.191013',567,567,'9272cfd3fbad46a0858a8c3d2b7c69b9','60afbc96-e4d4-4d9b-80d5-4e163df0fb5b',193,'eb5b74b9d7244a62a5c0b7f105ffc85a','shares',1,'2025-11-24 10:08:15',NULL),('2025-11-23 10:08:15.132809',NULL,'2025-11-23 10:08:15.191013',568,568,'9272cfd3fbad46a0858a8c3d2b7c69b9','995f28fb-bc42-4756-b628-be814c729dd1',192,'eb5b74b9d7244a62a5c0b7f105ffc85a','gigabytes',1,'2025-11-24 10:08:15',NULL),('2025-11-23 10:08:15.152535',NULL,'2025-11-23 10:08:15.191013',569,569,NULL,'ec50b78e-36ce-4acd-a61d-41366ba3e8aa',195,'eb5b74b9d7244a62a5c0b7f105ffc85a','shares',1,'2025-11-24 10:08:15','73750294-0b00-436c-b3a6-b36cbb7b5ac3'),('2025-11-23 10:08:15.154724',NULL,'2025-11-23 10:08:15.191013',570,570,NULL,'2933ed13-1d4b-4c05-a07d-a197a554babb',194,'eb5b74b9d7244a62a5c0b7f105ffc85a','gigabytes',1,'2025-11-24 10:08:15','73750294-0b00-436c-b3a6-b36cbb7b5ac3'),('2025-11-23 10:08:17.585342',NULL,'2025-11-23 10:08:17.604018',571,571,'c26f0e94847c4498b641d36cd7f9e893','82393622-c6eb-45b4-a19e-33b39485b3da',188,'09121c745ed044f4ac1be69b2e85b19c','snapshots',-1,'2025-11-24 10:08:17',NULL),('2025-11-23 10:08:17.586280',NULL,'2025-11-23 10:08:17.604018',572,572,'c26f0e94847c4498b641d36cd7f9e893','158d1992-106a-415d-8239-e44b88d6ba5b',189,'09121c745ed044f4ac1be69b2e85b19c','snapshot_gigabytes',-1,'2025-11-24 10:08:17',NULL),('2025-11-23 10:08:17.593129',NULL,'2025-11-23 10:08:17.604018',573,573,NULL,'a21c2bd2-8c8e-4db9-9139-ad3b8601e399',190,'09121c745ed044f4ac1be69b2e85b19c','snapshots',-1,'2025-11-24 10:08:17','6689aa2c-a3da-4ed8-ad2f-76109636c54e'),('2025-11-23 10:08:17.594179',NULL,'2025-11-23 10:08:17.604018',574,574,NULL,'5e209278-60ef-4914-8b98-3d9efebfd651',191,'09121c745ed044f4ac1be69b2e85b19c','snapshot_gigabytes',-1,'2025-11-24 10:08:17','6689aa2c-a3da-4ed8-ad2f-76109636c54e'),('2025-11-23 10:08:19.106676',NULL,'2025-11-23 10:08:19.128459',575,575,'9272cfd3fbad46a0858a8c3d2b7c69b9','e6953a71-4cd9-4df0-a550-830b1a8b2e34',193,'eb5b74b9d7244a62a5c0b7f105ffc85a','shares',-1,'2025-11-24 10:08:19',NULL),('2025-11-23 10:08:19.107666',NULL,'2025-11-23 10:08:19.128459',576,576,'9272cfd3fbad46a0858a8c3d2b7c69b9','96595c17-3073-4b8b-a0af-4234b4a1e963',192,'eb5b74b9d7244a62a5c0b7f105ffc85a','gigabytes',-1,'2025-11-24 10:08:19',NULL),('2025-11-23 10:08:19.116877',NULL,'2025-11-23 10:08:19.128459',577,577,NULL,'61479425-d155-4bdf-922a-d9962c90bea5',195,'eb5b74b9d7244a62a5c0b7f105ffc85a','shares',-1,'2025-11-24 10:08:19','73750294-0b00-436c-b3a6-b36cbb7b5ac3'),('2025-11-23 10:08:19.118015',NULL,'2025-11-23 10:08:19.128459',578,578,NULL,'58ea7121-87ac-4903-96f0-bf2cb89415eb',194,'eb5b74b9d7244a62a5c0b7f105ffc85a','gigabytes',-1,'2025-11-24 10:08:19','73750294-0b00-436c-b3a6-b36cbb7b5ac3'),('2025-11-23 10:08:20.924121',NULL,'2025-11-23 10:08:20.943470',579,579,'c26f0e94847c4498b641d36cd7f9e893','1d072e64-7bca-4fa8-b992-5af7085889d4',181,'09121c745ed044f4ac1be69b2e85b19c','shares',-1,'2025-11-24 10:08:20',NULL),('2025-11-23 10:08:20.925375',NULL,'2025-11-23 10:08:20.943470',580,580,'c26f0e94847c4498b641d36cd7f9e893','6218b52f-e9de-4b20-8ee1-432d0c76aebf',180,'09121c745ed044f4ac1be69b2e85b19c','gigabytes',-1,'2025-11-24 10:08:20',NULL),('2025-11-23 10:08:20.931867',NULL,'2025-11-23 10:08:20.943470',581,581,NULL,'16566a4c-3614-4cd6-91f5-973ed8534a93',183,'09121c745ed044f4ac1be69b2e85b19c','shares',-1,'2025-11-24 10:08:20','6689aa2c-a3da-4ed8-ad2f-76109636c54e'),('2025-11-23 10:08:20.932640',NULL,'2025-11-23 10:08:20.943470',582,582,NULL,'e993f398-ee01-471f-8259-fa36cff6a495',182,'09121c745ed044f4ac1be69b2e85b19c','gigabytes',-1,'2025-11-24 10:08:20','6689aa2c-a3da-4ed8-ad2f-76109636c54e'),('2025-11-23 10:08:22.314084',NULL,'2025-11-23 10:08:22.349623',583,583,'dce881a0acdf499699d2b927482308f5','1903d838-6a72-4157-963b-7f79504eb39b',185,'3893741994fb4b789f253fc559e364df','shares',-1,'2025-11-24 10:08:22',NULL),('2025-11-23 10:08:22.315611',NULL,'2025-11-23 10:08:22.349623',584,584,'dce881a0acdf499699d2b927482308f5','e826149e-34e1-48f8-ac79-e95735b9de46',184,'3893741994fb4b789f253fc559e364df','gigabytes',-1,'2025-11-24 10:08:22',NULL),('2025-11-23 10:08:22.325778',NULL,'2025-11-23 10:08:22.349623',585,585,NULL,'89ec293a-6cb4-40cf-9aec-3d88a4e84436',187,'3893741994fb4b789f253fc559e364df','shares',-1,'2025-11-24 10:08:22','73750294-0b00-436c-b3a6-b36cbb7b5ac3'),('2025-11-23 10:08:22.331115',NULL,'2025-11-23 10:08:22.349623',586,586,NULL,'21827343-f8d5-43c1-b4eb-093db048a522',186,'3893741994fb4b789f253fc559e364df','gigabytes',-1,'2025-11-24 10:08:22','73750294-0b00-436c-b3a6-b36cbb7b5ac3'),('2025-11-23 10:08:24.875830',NULL,'2025-11-23 10:08:24.918991',587,587,'69b4c51ee386489baf45acb5638b95eb','8c038b29-6f5e-4d2e-9566-7426ad9913a4',197,'4d4586d45fe545c4bf78ea7720359b10','shares',1,'2025-11-24 10:08:24',NULL),('2025-11-23 10:08:24.877582',NULL,'2025-11-23 10:08:24.918991',588,588,'69b4c51ee386489baf45acb5638b95eb','fe89497d-5131-474d-8831-884dbee29488',196,'4d4586d45fe545c4bf78ea7720359b10','gigabytes',1,'2025-11-24 10:08:24',NULL),('2025-11-23 10:08:24.891712',NULL,'2025-11-23 10:08:24.918991',589,589,NULL,'1661861f-ca17-4386-81c7-19f0c0f8ba80',199,'4d4586d45fe545c4bf78ea7720359b10','shares',1,'2025-11-24 10:08:24','9b70dc84-5ca2-4c80-af25-3b09864bb639'),('2025-11-23 10:08:24.893391',NULL,'2025-11-23 10:08:24.918991',590,590,NULL,'d4e52f88-2e17-4429-9191-bd3919f3dc0c',198,'4d4586d45fe545c4bf78ea7720359b10','gigabytes',1,'2025-11-24 10:08:24','9b70dc84-5ca2-4c80-af25-3b09864bb639'),('2025-11-23 10:08:25.200908',NULL,'2025-11-23 10:08:25.253635',591,591,'9272cfd3fbad46a0858a8c3d2b7c69b9','9394aa80-7859-4b30-82af-e90ef7a2121c',193,'eb5b74b9d7244a62a5c0b7f105ffc85a','shares',1,'2025-11-24 10:08:25',NULL),('2025-11-23 10:08:25.202516',NULL,'2025-11-23 10:08:25.253635',592,592,'9272cfd3fbad46a0858a8c3d2b7c69b9','67281bef-9aaf-4286-a3ef-dde3efde123b',192,'eb5b74b9d7244a62a5c0b7f105ffc85a','gigabytes',1,'2025-11-24 10:08:25',NULL),('2025-11-23 10:08:25.211525',NULL,'2025-11-23 10:08:25.253635',593,593,NULL,'0abea318-2ec1-46b2-bc8b-9c70a8218278',195,'eb5b74b9d7244a62a5c0b7f105ffc85a','shares',1,'2025-11-24 10:08:25','73750294-0b00-436c-b3a6-b36cbb7b5ac3'),('2025-11-23 10:08:25.217639',NULL,'2025-11-23 10:08:25.253635',594,594,NULL,'7c69d16f-e067-4ab6-a943-bf62ccda820c',194,'eb5b74b9d7244a62a5c0b7f105ffc85a','gigabytes',1,'2025-11-24 10:08:25','73750294-0b00-436c-b3a6-b36cbb7b5ac3'),('2025-11-23 10:08:28.543708',NULL,'2025-11-23 10:08:28.583494',595,595,'26e6d20ae34448cfb4ab9e44b5c2b297','b30fac3b-cc18-4934-9d46-a75cf9bc1286',201,'bdbef8738c274e8dadf9e931f2c11f32','shares',1,'2025-11-24 10:08:28',NULL),('2025-11-23 10:08:28.545385',NULL,'2025-11-23 10:08:28.583494',596,596,'26e6d20ae34448cfb4ab9e44b5c2b297','a0038d64-c846-408f-99cf-eeb9eb382b96',200,'bdbef8738c274e8dadf9e931f2c11f32','gigabytes',1,'2025-11-24 10:08:28',NULL),('2025-11-23 10:08:28.558527',NULL,'2025-11-23 10:08:28.583494',597,597,NULL,'02218ba1-be70-4243-a20b-bcf6b29fe73b',203,'bdbef8738c274e8dadf9e931f2c11f32','shares',1,'2025-11-24 10:08:28','1f6c6eb7-c250-4448-8f25-f015b009bdaf'),('2025-11-23 10:08:28.559892',NULL,'2025-11-23 10:08:28.583494',598,598,NULL,'0c8dc86d-a0e4-48d6-9613-efa717ce9d5c',202,'bdbef8738c274e8dadf9e931f2c11f32','gigabytes',1,'2025-11-24 10:08:28','1f6c6eb7-c250-4448-8f25-f015b009bdaf'),('2025-11-23 10:08:28.795801',NULL,'2025-11-23 10:08:28.824270',599,599,'69b4c51ee386489baf45acb5638b95eb','86d4c2eb-338b-4e12-82c2-79e0d380f734',197,'4d4586d45fe545c4bf78ea7720359b10','shares',1,'2025-11-24 10:08:28',NULL),('2025-11-23 10:08:28.797275',NULL,'2025-11-23 10:08:28.824270',600,600,'69b4c51ee386489baf45acb5638b95eb','8ae46d64-65a2-42ff-a26f-7f1050a06585',196,'4d4586d45fe545c4bf78ea7720359b10','gigabytes',1,'2025-11-24 10:08:28',NULL),('2025-11-23 10:08:28.802813',NULL,'2025-11-23 10:08:28.824270',601,601,NULL,'96870f3b-2575-41b6-909c-b76c346a3847',199,'4d4586d45fe545c4bf78ea7720359b10','shares',1,'2025-11-24 10:08:28','9b70dc84-5ca2-4c80-af25-3b09864bb639'),('2025-11-23 10:08:28.804459',NULL,'2025-11-23 10:08:28.824270',602,602,NULL,'be40ace7-7bf2-4f10-99c0-7a8c8fb414d0',198,'4d4586d45fe545c4bf78ea7720359b10','gigabytes',1,'2025-11-24 10:08:28','9b70dc84-5ca2-4c80-af25-3b09864bb639'),('2025-11-23 10:08:29.272925',NULL,'2025-11-23 10:08:29.289879',603,603,'9272cfd3fbad46a0858a8c3d2b7c69b9','0b6bb47b-d393-4371-b664-77d12b8b2e8e',193,'eb5b74b9d7244a62a5c0b7f105ffc85a','shares',-1,'2025-11-24 10:08:29',NULL),('2025-11-23 10:08:29.273771',NULL,'2025-11-23 10:08:29.289879',604,604,'9272cfd3fbad46a0858a8c3d2b7c69b9','e61f892a-60c6-480a-8476-ed07a0872b3e',192,'eb5b74b9d7244a62a5c0b7f105ffc85a','gigabytes',-1,'2025-11-24 10:08:29',NULL),('2025-11-23 10:08:29.281627',NULL,'2025-11-23 10:08:29.289879',605,605,NULL,'19968f44-f901-4a63-a6d4-633613e9f5b9',195,'eb5b74b9d7244a62a5c0b7f105ffc85a','shares',-1,'2025-11-24 10:08:29','73750294-0b00-436c-b3a6-b36cbb7b5ac3'),('2025-11-23 10:08:29.282692',NULL,'2025-11-23 10:08:29.289879',606,606,NULL,'6be37cdb-3898-4025-80e6-8e83a680e64d',194,'eb5b74b9d7244a62a5c0b7f105ffc85a','gigabytes',-1,'2025-11-24 10:08:29','73750294-0b00-436c-b3a6-b36cbb7b5ac3'),('2025-11-23 10:08:36.360003',NULL,'2025-11-23 10:08:36.400357',607,607,'69b4c51ee386489baf45acb5638b95eb','6443bf5b-5fd7-4404-8e37-6024f4ef8b58',197,'4d4586d45fe545c4bf78ea7720359b10','shares',-1,'2025-11-24 10:08:36',NULL),('2025-11-23 10:08:36.361988',NULL,'2025-11-23 10:08:36.400357',608,608,'69b4c51ee386489baf45acb5638b95eb','e024a1b3-f3af-4f57-8919-b872eeceab48',196,'4d4586d45fe545c4bf78ea7720359b10','gigabytes',-1,'2025-11-24 10:08:36',NULL),('2025-11-23 10:08:36.387191',NULL,'2025-11-23 10:08:36.400357',609,609,NULL,'6f5e879a-96d8-49a1-b90c-ce40fe118924',199,'4d4586d45fe545c4bf78ea7720359b10','shares',-1,'2025-11-24 10:08:36','9b70dc84-5ca2-4c80-af25-3b09864bb639'),('2025-11-23 10:08:36.388066',NULL,'2025-11-23 10:08:36.400357',610,610,NULL,'de80b8bd-d436-41d4-b418-ca49b2c2a7d1',198,'4d4586d45fe545c4bf78ea7720359b10','gigabytes',-1,'2025-11-24 10:08:36','9b70dc84-5ca2-4c80-af25-3b09864bb639'),('2025-11-23 10:08:36.419656',NULL,'2025-11-23 10:08:36.433063',611,611,'26e6d20ae34448cfb4ab9e44b5c2b297','0b712f04-7c36-4996-9976-771dcb2a1cad',201,'bdbef8738c274e8dadf9e931f2c11f32','shares',-1,'2025-11-24 10:08:36',NULL),('2025-11-23 10:08:36.420442',NULL,'2025-11-23 10:08:36.433063',612,612,'26e6d20ae34448cfb4ab9e44b5c2b297','6209f925-2d51-4383-a553-9726f8476ca7',200,'bdbef8738c274e8dadf9e931f2c11f32','gigabytes',-1,'2025-11-24 10:08:36',NULL),('2025-11-23 10:08:36.426046',NULL,'2025-11-23 10:08:36.433063',613,613,NULL,'24e25974-f65e-4797-aba1-36cc5d6424b4',203,'bdbef8738c274e8dadf9e931f2c11f32','shares',-1,'2025-11-24 10:08:36','1f6c6eb7-c250-4448-8f25-f015b009bdaf'),('2025-11-23 10:08:36.426768',NULL,'2025-11-23 10:08:36.433063',614,614,NULL,'c943a8e6-9a9a-4952-bde2-ff6c494a2a00',202,'bdbef8738c274e8dadf9e931f2c11f32','gigabytes',-1,'2025-11-24 10:08:36','1f6c6eb7-c250-4448-8f25-f015b009bdaf'),('2025-11-23 10:08:38.788767',NULL,'2025-11-23 10:08:38.838301',615,61