/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `aodh`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `aodh` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `aodh`;

--
-- Table structure for table `alarm`
--

DROP TABLE IF EXISTS `alarm`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alarm` (
  `alarm_id` varchar(128) NOT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `name` text DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `severity` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `timestamp` datetime(6) DEFAULT NULL,
  `user_id` varchar(128) DEFAULT NULL,
  `project_id` varchar(128) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `state_reason` text DEFAULT NULL,
  `state_timestamp` datetime(6) DEFAULT NULL,
  `ok_actions` text DEFAULT NULL,
  `alarm_actions` text DEFAULT NULL,
  `insufficient_data_actions` text DEFAULT NULL,
  `repeat_actions` tinyint(1) DEFAULT NULL,
  `rule` text DEFAULT NULL,
  `time_constraints` text DEFAULT NULL,
  `evaluate_timestamp` datetime DEFAULT NULL,
  PRIMARY KEY (`alarm_id`),
  KEY `ix_alarm_type` (`type`),
  KEY `ix_alarm_user_id` (`user_id`),
  KEY `ix_alarm_project_id` (`project_id`),
  KEY `ix_alarm_enabled` (`enabled`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alarm`
--

LOCK TABLES `alarm` WRITE;
/*!40000 ALTER TABLE `alarm` DISABLE KEYS */;
/*!40000 ALTER TABLE `alarm` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alarm_history`
--

DROP TABLE IF EXISTS `alarm_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alarm_history` (
  `event_id` varchar(128) NOT NULL,
  `alarm_id` varchar(128) DEFAULT NULL,
  `on_behalf_of` varchar(128) DEFAULT NULL,
  `project_id` varchar(128) DEFAULT NULL,
  `user_id` varchar(128) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `detail` text DEFAULT NULL,
  `timestamp` datetime(6) DEFAULT NULL,
  `severity` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`event_id`),
  KEY `ix_alarm_history_alarm_id` (`alarm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alarm_history`
--

LOCK TABLES `alarm_history` WRITE;
/*!40000 ALTER TABLE `alarm_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `alarm_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('007');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota`
--

DROP TABLE IF EXISTS `quota`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(128) DEFAULT NULL,
  `resource` varchar(50) DEFAULT NULL,
  `limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`),
  KEY `ix_quota_project_id_resource` (`project_id`,`resource`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota`
--

LOCK TABLES `quota` WRITE;
/*!40000 ALTER TABLE `quota` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('02d3480d-c6bd-4968-9df6-e026ece86dff','2025-11-28 08:49:15','2025-11-28 08:49:15',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
INSERT INTO `backups` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `host`, `availability_zone`, `display_name`, `display_description`, `container`, `status`, `fail_reason`, `service_metadata`, `service`, `size`, `object_count`, `parent_id`, `temp_volume_id`, `temp_snapshot_id`, `num_dependent_backups`, `snapshot_id`, `data_timestamp`, `restore_volume_id`, `encryption_key_id`) VALUES ('2025-11-28 10:07:48','2025-11-28 10:07:53','2025-11-28 10:07:54',1,'044b8066-a2fc-4c0d-ab60-4c592fe68306','bd027205-a608-4caf-a797-22f77fcdb9dd','87cf17c48bab44279b2e7eca9e0882a2','d3c0d1ce8d854a7b9ffc953e88cd2c44','cinder-backup-0',NULL,'tempest-VolumesBackupsTest-Backup-631316586',NULL,'backups','deleted',NULL,'{\"base\": \"volume-bd027205-a608-4caf-a797-22f77fcdb9dd.backup.9b519cf4-363a-4bba-9ce5-b9e3c0530625\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,'9b519cf4-363a-4bba-9ce5-b9e3c0530625',NULL,NULL,NULL,NULL,'2025-11-28 10:07:48',NULL,NULL),('2025-11-28 10:09:01','2025-11-28 10:09:04','2025-11-28 10:09:06',1,'353f1fb8-c71d-42a9-9f58-de2614164c08','a1e919fa-31eb-43c9-a2c1-f5491ff82934','e3c99f9fe4d541e6b1670e0d113fcd19','fc7fccbd32a74bc3b7becd3530d9005e','cinder-backup-0',NULL,'tempest-VolumesBackupsV39Test-Backup-571811030','tempest-volume-backup-description-779429721','backups','deleted',NULL,'{\"base\": \"volume-a1e919fa-31eb-43c9-a2c1-f5491ff82934.backup.353f1fb8-c71d-42a9-9f58-de2614164c08\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:01',NULL,NULL),('2025-11-28 10:05:57','2025-11-28 10:06:09','2025-11-28 10:06:10',1,'43cb514c-73ee-4cc1-96c2-85b4f424a7de','19ea2973-b5b1-456d-a6a8-e46bc69b156d','bd780e43b91a4421b44e70b1380a67a0','aff7b7030d9c4af69b909a2b53581468','cinder-backup-0','nova','tempest-VolumesBackupsAdminTest-Backup-169510114',NULL,'backups','deleted',NULL,'{\"base\": \"volume-19ea2973-b5b1-456d-a6a8-e46bc69b156d.backup.9f3517e9-25ac-4726-b091-74cec2691488\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,0,NULL,NULL,NULL,0,NULL,'2025-11-28 10:05:57',NULL,NULL),('2025-11-28 10:07:42','2025-11-28 10:07:46','2025-11-28 10:07:48',1,'647404ae-4fd7-4613-a9a9-89ff0dcdfa91','bd027205-a608-4caf-a797-22f77fcdb9dd','87cf17c48bab44279b2e7eca9e0882a2','d3c0d1ce8d854a7b9ffc953e88cd2c44','cinder-backup-0',NULL,NULL,NULL,'backups','deleted',NULL,'{\"base\": \"volume-bd027205-a608-4caf-a797-22f77fcdb9dd.backup.9b519cf4-363a-4bba-9ce5-b9e3c0530625\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,'9b519cf4-363a-4bba-9ce5-b9e3c0530625',NULL,NULL,NULL,NULL,'2025-11-28 10:07:42',NULL,NULL),('2025-11-28 10:09:24','2025-11-28 10:09:39','2025-11-28 10:09:40',1,'6ce4109c-198e-442e-929d-9a98a0fabf5e','e38d3f86-1fc2-412d-99d4-43c43990555a','3e0c0f1d7904439c976f777b4f3c59a9','3e2ec027cab64e90a22b087eafacf760','cinder-backup-0',NULL,'tempest-VolumesSnapshotTestJSON-Backup-603616619',NULL,'backups','deleted',NULL,NULL,'cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,'020542e3-299d-4c17-8a59-99558bed4ff1','2025-11-28 10:09:23',NULL,NULL),('2025-11-28 10:07:38','2025-11-28 10:07:54','2025-11-28 10:07:55',1,'9b519cf4-363a-4bba-9ce5-b9e3c0530625','bd027205-a608-4caf-a797-22f77fcdb9dd','87cf17c48bab44279b2e7eca9e0882a2','d3c0d1ce8d854a7b9ffc953e88cd2c44','cinder-backup-0',NULL,'tempest-VolumesBackupsTest-Backup-297220950',NULL,'backups','deleted',NULL,'{\"base\": \"volume-bd027205-a608-4caf-a797-22f77fcdb9dd.backup.9b519cf4-363a-4bba-9ce5-b9e3c0530625\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,0,NULL,'2025-11-28 10:07:38',NULL,NULL),('2025-11-28 10:05:57','2025-11-28 10:06:11','2025-11-28 10:06:12',1,'9f3517e9-25ac-4726-b091-74cec2691488','19ea2973-b5b1-456d-a6a8-e46bc69b156d','3149cb791b864349a3ef9639d9664574','d2d31a928b84446c97d35bb770c268e5','cinder-backup-0',NULL,'tempest-VolumesBackupsAdminTest-Backup-169510114',NULL,'backups','deleted',NULL,'{\"base\": \"volume-19ea2973-b5b1-456d-a6a8-e46bc69b156d.backup.9f3517e9-25ac-4726-b091-74cec2691488\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:57','d0de0b22-5f61-4344-a73e-704f542a8f23',NULL),('2025-11-28 10:06:27','2025-11-28 10:06:41','2025-11-28 10:06:42',1,'b90dfbda-b3d9-40c5-98ea-bad0a8f43d72','5a82eb95-1559-4a88-822e-951361a380e2','87cf17c48bab44279b2e7eca9e0882a2','d3c0d1ce8d854a7b9ffc953e88cd2c44','cinder-backup-0',NULL,'tempest-VolumesBackupsTest-Backup-364799866',NULL,'backups','deleted',NULL,'{\"base\": \"volume-5a82eb95-1559-4a88-822e-951361a380e2.backup.b90dfbda-b3d9-40c5-98ea-bad0a8f43d72\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:06:27','ba20f281-f8ef-460a-a916-8659cb86fe77',NULL),('2025-11-28 10:06:16','2025-11-28 10:06:20','2025-11-28 10:06:21',1,'e4f87534-7999-4190-969d-b3af6797094f','1b200e79-095d-4520-bba6-ede140fda7b2','3149cb791b864349a3ef9639d9664574','d2d31a928b84446c97d35bb770c268e5','cinder-backup-0',NULL,'tempest-VolumesBackupsAdminTest-Backup-774433605',NULL,'backups','deleted',NULL,'{\"base\": \"volume-1b200e79-095d-4520-bba6-ede140fda7b2.backup.e4f87534-7999-4190-969d-b3af6797094f\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:06:16',NULL,NULL);
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`disabled` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`frozen` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
INSERT INTO `encryption` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `cipher`, `control_location`, `key_size`, `provider`, `volume_type_id`, `encryption_id`) VALUES ('2025-11-28 10:08:39','2025-11-28 10:08:39','2025-11-28 10:08:39',1,'aes-xts-plain64','back-end',128,'SomeProvider','a982fd09-a91b-47e6-8418-b6472e830642','ba845573-df6c-445b-a505-1e1c68711f18');
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
INSERT INTO `group_snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `group_id`, `user_id`, `project_id`, `name`, `description`, `status`, `group_type_id`) VALUES ('2025-11-28 10:04:07','2025-11-28 10:04:08','2025-11-28 10:04:09',1,'15c3024a-1a77-4bf4-a9e6-33f2c820c2e3','ebd685df-6615-42cf-b71c-80d71cdc9535','fe65864ca994460c9f786e2a187aa538','115c143e37394d77b81665435ce51c10','tempest-group_snapshot-1716109261',NULL,'deleted','20925f1f-a333-4081-a944-08e8efffcb21'),('2025-11-28 10:07:44','2025-11-28 10:07:47','2025-11-28 10:07:49',1,'8fcbafc2-ee8c-4338-a54b-78e87d269c39','05a5fb3c-7e79-48b3-9bf5-ec7bd77e2596','60a0061fff1842b898c067834f6b0b0d','44e47888bf384f2290cbd80a83fd1322','tempest-GroupSnapshotsV319Test-Group_Snapshot-1873264378',NULL,'deleted','75abd592-dc86-4e3f-aabb-850b72e2175d'),('2025-11-28 10:03:56','2025-11-28 10:03:59','2025-11-28 10:04:01',1,'b7fd025d-8ab8-40ca-9a9c-2374b78fba0c','90a7920b-efc2-4c48-9c81-f901f0607aaf','fe65864ca994460c9f786e2a187aa538','115c143e37394d77b81665435ce51c10','tempest-GroupSnapshotsTest-Group_Snapshot-1409184827',NULL,'deleted','059849ec-b2f2-4270-85b8-335555837cfc'),('2025-11-28 10:03:37','2025-11-28 10:03:43','2025-11-28 10:03:45',1,'ea054be1-3b60-4483-8b22-4308ec08290b','39505b62-0741-4d93-9e2f-a0407f5bf3b3','fe65864ca994460c9f786e2a187aa538','115c143e37394d77b81665435ce51c10','tempest-group_snapshot-1329091637',NULL,'deleted','22dadf78-142e-4055-ab8a-fa1f0b2af2ff');
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (2,'consistent_group_snapshot_enabled','<is> True','66932bcf-8249-4221-9f9f-f542d05c2042','2025-11-28 08:14:44','2025-11-28 08:14:44',NULL,0),(5,'consistent_group_snapshot_enabled','<is> False','6cf326ee-7b59-430f-8d71-57af777a16e5','2025-11-28 10:04:18',NULL,'2025-11-28 10:04:18',1),(6,'key1','value1','647dd8a2-b053-48e7-bae8-ee285b7b96be','2025-11-28 10:05:14',NULL,'2025-11-28 10:05:14',1),(7,'key2','value2-updated','647dd8a2-b053-48e7-bae8-ee285b7b96be','2025-11-28 10:05:14','2025-11-28 10:05:14','2025-11-28 10:05:14',1),(8,'key3','value3-updated','647dd8a2-b053-48e7-bae8-ee285b7b96be','2025-11-28 10:05:14','2025-11-28 10:05:14','2025-11-28 10:05:14',1);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`is_public` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('059849ec-b2f2-4270-85b8-335555837cfc','tempest-GroupSnapshotsTest-group-type-549048485',NULL,'2025-11-28 10:03:47',NULL,'2025-11-28 10:04:04',1,1),('20925f1f-a333-4081-a944-08e8efffcb21','tempest-GroupSnapshotsTest-group-type-1132555998',NULL,'2025-11-28 10:04:04',NULL,'2025-11-28 10:04:10',1,1),('22dadf78-142e-4055-ab8a-fa1f0b2af2ff','tempest-GroupSnapshotsTest-group-type-1379451596',NULL,'2025-11-28 10:03:33',NULL,'2025-11-28 10:03:47',1,1),('25d65df1-7f3f-41a3-893d-e33cc67d5e6d','tempest-GroupsTest-group-type-423102464',NULL,'2025-11-28 10:08:30',NULL,'2025-11-28 10:08:38',1,1),('589d4528-e5c1-42b4-9877-0e13f6ca998a','tempest-GroupsV314Test-group-type-118179920',NULL,'2025-11-28 10:05:32',NULL,'2025-11-28 10:05:40',1,1),('6246570f-a9ae-46e5-9ccc-c586af575028','a_tempest-group-type-1126500532',NULL,'2025-11-28 10:04:18',NULL,'2025-11-28 10:04:18',1,1),('647dd8a2-b053-48e7-bae8-ee285b7b96be','tempest-GroupTypeSpecsTest-group-type-249101612',NULL,'2025-11-28 10:05:14',NULL,'2025-11-28 10:05:14',1,1),('66932bcf-8249-4221-9f9f-f542d05c2042','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2025-11-28 08:14:44','2025-11-28 08:14:44',NULL,0,1),('6cf326ee-7b59-430f-8d71-57af777a16e5','tempest-GroupTypesTest-updated-group-type-1089929566','updated-group-type-desc','2025-11-28 10:04:18','2025-11-28 10:04:18','2025-11-28 10:04:18',1,1),('6dd6eddb-f5b0-4ea5-8703-e2ce2434b0b8','tempest-GroupsV320Test-group-type-408932392',NULL,'2025-11-28 10:08:30',NULL,'2025-11-28 10:08:33',1,1),('75abd592-dc86-4e3f-aabb-850b72e2175d','tempest-GroupSnapshotsV319Test-group-type-1369722950',NULL,'2025-11-28 10:07:41',NULL,'2025-11-28 10:07:52',1,1),('bd739dd2-12ea-4e5b-8712-d4b1f0b67a33','b_tempest-group-type-1387387475',NULL,'2025-11-28 10:04:18',NULL,'2025-11-28 10:04:18',1,0),('db46197e-0d3b-4912-addf-7bec75634e92','tempest-GroupsTest-group-type-604603703',NULL,'2025-11-28 10:08:23',NULL,'2025-11-28 10:08:30',1,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
INSERT INTO `group_volume_type_mapping` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_type_id`, `group_id`) VALUES ('2025-11-28 10:03:33',NULL,'2025-11-28 10:03:46',1,1,'fb386a3c-f41c-4344-a8ff-4193ab81f512','39505b62-0741-4d93-9e2f-a0407f5bf3b3'),('2025-11-28 10:03:39',NULL,'2025-11-28 10:03:42',1,2,'fb386a3c-f41c-4344-a8ff-4193ab81f512','0efce84a-39bd-4602-8342-d23c0189db75'),('2025-11-28 10:03:47',NULL,'2025-11-28 10:04:03',1,3,'5bb8e5c1-b168-4814-b7f9-c6b116731dc3','90a7920b-efc2-4c48-9c81-f901f0607aaf'),('2025-11-28 10:04:04',NULL,'2025-11-28 10:04:10',1,4,'80703c86-0cc3-4b56-99e8-bbda90d2bedd','ebd685df-6615-42cf-b71c-80d71cdc9535'),('2025-11-28 10:05:32',NULL,'2025-11-28 10:05:39',1,5,'9e639737-6ba0-4823-95c4-cc509eaf4ceb','5da9d15e-3a2b-4b77-898e-f8afbeb62e23'),('2025-11-28 10:05:34',NULL,'2025-11-28 10:05:38',1,6,'9e639737-6ba0-4823-95c4-cc509eaf4ceb','8cc9871e-6178-490e-a36d-6126432cf64b'),('2025-11-28 10:07:41',NULL,'2025-11-28 10:07:51',1,7,'8206fca6-970a-4db0-a8a4-eeedbc6e2000','05a5fb3c-7e79-48b3-9bf5-ec7bd77e2596'),('2025-11-28 10:08:23',NULL,'2025-11-28 10:08:28',1,8,'20e0a967-28dc-4052-8098-21af5d5e2558','3bb1a8a3-e81b-4656-b516-5153fdf461b8'),('2025-11-28 10:08:24',NULL,'2025-11-28 10:08:28',1,9,'20e0a967-28dc-4052-8098-21af5d5e2558','151f6d71-fc16-4440-bfd1-9e0d2bf27ea9'),('2025-11-28 10:08:30',NULL,'2025-11-28 10:08:38',1,10,'0597ffbc-528c-4291-980f-e63e19b57f1a','c9b3b6d2-1582-40c6-b22c-254fe470ec9c'),('2025-11-28 10:08:30',NULL,'2025-11-28 10:08:32',1,11,'f59c6f03-04cc-4d37-ab75-f9948448d675','aa2d717a-d79c-4da2-8214-4d2f0254e2ee');
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
INSERT INTO `groups` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `cluster_name`, `host`, `availability_zone`, `name`, `description`, `group_type_id`, `status`, `group_snapshot_id`, `source_group_id`, `replication_status`) VALUES ('2025-11-28 10:07:41','2025-11-28 10:07:51','2025-11-28 10:07:51',1,'05a5fb3c-7e79-48b3-9bf5-ec7bd77e2596','60a0061fff1842b898c067834f6b0b0d','44e47888bf384f2290cbd80a83fd1322',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupSnapshotsV319Test-Group-1074886511',NULL,'75abd592-dc86-4e3f-aabb-850b72e2175d','deleted',NULL,NULL,'disabled'),('2025-11-28 10:03:39','2025-11-28 10:03:42','2025-11-28 10:03:42',1,'0efce84a-39bd-4602-8342-d23c0189db75','fe65864ca994460c9f786e2a187aa538','115c143e37394d77b81665435ce51c10',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-Group_from_snap-427666095',NULL,'22dadf78-142e-4055-ab8a-fa1f0b2af2ff','deleted','ea054be1-3b60-4483-8b22-4308ec08290b',NULL,'disabled'),('2025-11-28 10:08:24','2025-11-28 10:08:28','2025-11-28 10:08:28',1,'151f6d71-fc16-4440-bfd1-9e0d2bf27ea9','7b566f8cb0d949bc89f5b8706fa7ef3f','708e5a4db87c470c994eb117a4c58083',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-Group2-959689131',NULL,'db46197e-0d3b-4912-addf-7bec75634e92','deleted',NULL,NULL,'disabled'),('2025-11-28 10:03:34','2025-11-28 10:03:46','2025-11-28 10:03:46',1,'39505b62-0741-4d93-9e2f-a0407f5bf3b3','fe65864ca994460c9f786e2a187aa538','115c143e37394d77b81665435ce51c10',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupSnapshotsTest-Group-1608052074',NULL,'22dadf78-142e-4055-ab8a-fa1f0b2af2ff','deleted',NULL,NULL,'disabled'),('2025-11-28 10:08:23','2025-11-28 10:08:28','2025-11-28 10:08:28',1,'3bb1a8a3-e81b-4656-b516-5153fdf461b8','7b566f8cb0d949bc89f5b8706fa7ef3f','708e5a4db87c470c994eb117a4c58083',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-Group1-1841852591',NULL,'db46197e-0d3b-4912-addf-7bec75634e92','deleted',NULL,NULL,'disabled'),('2025-11-28 10:05:32','2025-11-28 10:05:39','2025-11-28 10:05:39',1,'5da9d15e-3a2b-4b77-898e-f8afbeb62e23','c0286a07766246c0b685593779a1b7bd','5c1cc8bd04e04964bf55c27886efbf5c',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupsV314Test-Group-685229172',NULL,'589d4528-e5c1-42b4-9877-0e13f6ca998a','deleted',NULL,NULL,'disabled'),('2025-11-28 10:05:36','2025-11-28 10:05:38','2025-11-28 10:05:38',1,'8cc9871e-6178-490e-a36d-6126432cf64b','c0286a07766246c0b685593779a1b7bd','5c1cc8bd04e04964bf55c27886efbf5c',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-Group_from_grp-368782717',NULL,'589d4528-e5c1-42b4-9877-0e13f6ca998a','deleted',NULL,'5da9d15e-3a2b-4b77-898e-f8afbeb62e23','disabled'),('2025-11-28 10:03:47','2025-11-28 10:04:03','2025-11-28 10:04:03',1,'90a7920b-efc2-4c48-9c81-f901f0607aaf','fe65864ca994460c9f786e2a187aa538','115c143e37394d77b81665435ce51c10',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupSnapshotsTest-Group-848015773',NULL,'059849ec-b2f2-4270-85b8-335555837cfc','deleted',NULL,NULL,'disabled'),('2025-11-28 10:08:30','2025-11-28 10:08:32','2025-11-28 10:08:32',1,'aa2d717a-d79c-4da2-8214-4d2f0254e2ee','23ad49b44ba343c7a7084a420bf4bea8','b1155d9e62f747aab975f341b5b53a22',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupsV320Test-Group-862905492',NULL,'6dd6eddb-f5b0-4ea5-8703-e2ce2434b0b8','deleted',NULL,NULL,'disabled'),('2025-11-28 10:08:30','2025-11-28 10:08:37','2025-11-28 10:08:38',1,'c9b3b6d2-1582-40c6-b22c-254fe470ec9c','7b566f8cb0d949bc89f5b8706fa7ef3f','708e5a4db87c470c994eb117a4c58083',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','new_group','This is a new group','25d65df1-7f3f-41a3-893d-e33cc67d5e6d','deleted',NULL,NULL,'disabled'),('2025-11-28 10:04:04','2025-11-28 10:04:10','2025-11-28 10:04:10',1,'ebd685df-6615-42cf-b71c-80d71cdc9535','fe65864ca994460c9f786e2a187aa538','115c143e37394d77b81665435ce51c10',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupSnapshotsTest-Group-2045494536',NULL,'20925f1f-a333-4081-a944-08e8efffcb21','deleted',NULL,NULL,'disabled');
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`),
  KEY `ix_image_volume_cache_entries_host` (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
INSERT INTO `messages` (`id`, `project_id`, `request_id`, `resource_type`, `resource_uuid`, `event_id`, `message_level`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `expires_at`, `detail_id`, `action_id`) VALUES ('7876b855-8262-40ac-95fd-2fe6a77ce900','f85d8ffada2842738a1307658c19c621','req-fbbca2fa-fdfd-46e4-b6b1-9e2da93049c9','VOLUME','f5e86292-8aa3-4beb-97f1-964514fec777','VOLUME_VOLUME_001_003','ERROR','2025-11-28 10:08:57',NULL,'2025-11-28 10:08:58',1,'2025-12-28 10:08:57','003','001'),('90116282-b2f2-4099-9fa2-ff1b6cc6ec23','f85d8ffada2842738a1307658c19c621','req-692536ea-434d-4ca9-ae48-97c7bb6e7732','VOLUME','f7f7d02c-ae73-40c9-8e71-f720df169558','VOLUME_VOLUME_001_003','ERROR','2025-11-28 10:08:59',NULL,'2025-11-28 10:09:00',1,'2025-12-28 10:08:59','003','001');
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('cinder','/usr/lib/python3.9/site-packages/cinder/db/sqlalchemy/migrate_repo',145);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
INSERT INTO `quality_of_service_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `specs_id`, `key`, `value`) VALUES ('2025-11-28 10:08:44',NULL,'2025-11-28 10:08:44',1,'1750e510-54ec-4c25-b313-0fb1029989b9','8374ad02-dcc0-47f5-b77d-d4346ed809d8','iops_bytes','500'),('2025-11-28 10:08:43',NULL,'2025-11-28 10:08:44',1,'5fe2cbd7-ba51-45b4-9455-b080b210a01c','8374ad02-dcc0-47f5-b77d-d4346ed809d8','consumer','front-end'),('2025-11-28 10:08:43',NULL,'2025-11-28 10:08:44',1,'8374ad02-dcc0-47f5-b77d-d4346ed809d8',NULL,'QoS_Specs_Name','tempest-QosSpecsTestJSON-QoS-779318408'),('2025-11-28 10:08:44',NULL,'2025-11-28 10:08:44',1,'896d1312-afc9-4a5e-8ce0-904fe2310a7e','bdbf6da4-b856-4d99-8049-193ea01c5f32','consumer','back-end'),('2025-11-28 10:08:44',NULL,'2025-11-28 10:08:44',1,'900c8107-0175-4fc4-9598-0fc281bcc895','efa11c22-fa78-41e1-8d35-dcb9d27412a9','consumer','both'),('2025-11-28 10:08:44',NULL,'2025-11-28 10:08:44',1,'bdbf6da4-b856-4d99-8049-193ea01c5f32',NULL,'QoS_Specs_Name','tempest-QosSpecsTestJSON-qos-238700425'),('2025-11-28 10:08:43',NULL,'2025-11-28 10:08:44',1,'bdfbfd70-a6ff-439d-8f4d-390007539709','8374ad02-dcc0-47f5-b77d-d4346ed809d8','read_iops_sec','2000'),('2025-11-28 10:08:44',NULL,'2025-11-28 10:08:44',1,'e4b0d518-fba8-45d5-819d-fba2d93b5f74','e5fb73d5-4a7a-4540-ad60-73ebf4817e4c','consumer','front-end'),('2025-11-28 10:08:44',NULL,'2025-11-28 10:08:44',1,'e5fb73d5-4a7a-4540-ad60-73ebf4817e4c',NULL,'QoS_Specs_Name','tempest-QosSpecsTestJSON-qos-1335060865'),('2025-11-28 10:08:44',NULL,'2025-11-28 10:08:44',1,'efa11c22-fa78-41e1-8d35-dcb9d27412a9',NULL,'QoS_Specs_Name','tempest-QosSpecsTestJSON-qos-1268182834');
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2025-11-28 08:14:40','2025-11-28 10:09:05',NULL,0,2,'default','volumes',10),('2025-11-28 08:14:40','2025-11-28 10:09:05',NULL,0,5,'default','snapshots',10),('2025-11-28 08:14:40','2025-11-28 10:09:05',NULL,0,8,'default','gigabytes',1000),('2025-11-28 08:14:40',NULL,NULL,0,11,'default','consistencygroups',10),('2025-11-28 08:14:40',NULL,NULL,0,14,'default','per_volume_gigabytes',-1),('2025-11-28 08:14:40',NULL,NULL,0,17,'default','groups',10),('2025-11-28 10:09:05','2025-11-28 10:09:05',NULL,0,20,'default','backups',10),('2025-11-28 10:09:05','2025-11-28 10:09:05',NULL,0,21,'default','backup_gigabytes',1000),('2025-11-28 10:09:05',NULL,NULL,0,22,'default','volumes_tempest-VolumeQuotaClassesTest-volume-type-3430912',7),('2025-11-28 10:09:05',NULL,NULL,0,23,'default','snapshots_tempest-VolumeQuotaClassesTest-volume-type-3430912',4),('2025-11-28 10:09:05',NULL,NULL,0,24,'default','gigabytes_tempest-VolumeQuotaClassesTest-volume-type-3430912',3);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `quota_usages_project_id_key` (`project_id`,`resource`,`race_preventer`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=224 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `race_preventer`) VALUES ('2025-11-28 10:03:33','2025-11-28 10:04:10',NULL,0,1,'115c143e37394d77b81665435ce51c10','groups',0,0,NULL,1),('2025-11-28 10:03:35','2025-11-28 10:04:10',NULL,0,2,'115c143e37394d77b81665435ce51c10','volumes',0,0,NULL,1),('2025-11-28 10:03:35','2025-11-28 10:04:10',NULL,0,3,'115c143e37394d77b81665435ce51c10','gigabytes',0,0,NULL,1),('2025-11-28 10:03:35','2025-11-28 10:03:46',NULL,0,4,'115c143e37394d77b81665435ce51c10','volumes_tempest-GroupSnapshotsTest-volume-type-1857876428',0,0,NULL,1),('2025-11-28 10:03:35','2025-11-28 10:03:45',NULL,0,5,'115c143e37394d77b81665435ce51c10','gigabytes_tempest-GroupSnapshotsTest-volume-type-1857876428',0,0,NULL,1),('2025-11-28 10:03:37','2025-11-28 10:04:09',NULL,0,6,'115c143e37394d77b81665435ce51c10','snapshots',0,0,NULL,1),('2025-11-28 10:03:37','2025-11-28 10:03:45',NULL,0,7,'115c143e37394d77b81665435ce51c10','snapshots_tempest-GroupSnapshotsTest-volume-type-1857876428',0,0,NULL,1),('2025-11-28 10:03:49','2025-11-28 10:04:03',NULL,0,8,'115c143e37394d77b81665435ce51c10','volumes_tempest-GroupSnapshotsTest-volume-type-835004530',0,0,NULL,1),('2025-11-28 10:03:49','2025-11-28 10:04:03',NULL,0,9,'115c143e37394d77b81665435ce51c10','gigabytes_tempest-GroupSnapshotsTest-volume-type-835004530',0,0,NULL,1),('2025-11-28 10:03:56','2025-11-28 10:04:01',NULL,0,10,'115c143e37394d77b81665435ce51c10','snapshots_tempest-GroupSnapshotsTest-volume-type-835004530',0,0,NULL,1),('2025-11-28 10:04:05','2025-11-28 10:04:10',NULL,0,11,'115c143e37394d77b81665435ce51c10','volumes_tempest-GroupSnapshotsTest-volume-type-807881257',0,0,NULL,1),('2025-11-28 10:04:05','2025-11-28 10:04:10',NULL,0,12,'115c143e37394d77b81665435ce51c10','gigabytes_tempest-GroupSnapshotsTest-volume-type-807881257',0,0,NULL,1),('2025-11-28 10:04:07','2025-11-28 10:04:09',NULL,0,13,'115c143e37394d77b81665435ce51c10','snapshots_tempest-GroupSnapshotsTest-volume-type-807881257',0,0,NULL,1),('2025-11-28 10:04:27','2025-11-28 10:04:29',NULL,0,14,'70de67fe9f1d43a793c239829fcd6ef2','volumes',0,0,NULL,1),('2025-11-28 10:04:27','2025-11-28 10:04:29',NULL,0,15,'70de67fe9f1d43a793c239829fcd6ef2','gigabytes',0,0,NULL,1),('2025-11-28 10:04:27','2025-11-28 10:04:29',NULL,0,16,'70de67fe9f1d43a793c239829fcd6ef2','volumes_tempest-VolumeTypesAccessTest-volume-type-1038300301',0,0,NULL,1),('2025-11-28 10:04:27','2025-11-28 10:04:29',NULL,0,17,'70de67fe9f1d43a793c239829fcd6ef2','gigabytes_tempest-VolumeTypesAccessTest-volume-type-1038300301',0,0,NULL,1),('2025-11-28 10:05:19','2025-11-28 10:05:32',NULL,0,18,'aa5be61eafca4d96976422f0e0103210','volumes',0,0,NULL,1),('2025-11-28 10:05:19','2025-11-28 10:05:32',NULL,0,19,'aa5be61eafca4d96976422f0e0103210','gigabytes',0,0,NULL,1),('2025-11-28 10:05:19','2025-11-28 10:05:32',NULL,0,20,'aa5be61eafca4d96976422f0e0103210','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:05:19','2025-11-28 10:05:32',NULL,0,21,'aa5be61eafca4d96976422f0e0103210','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:05:29','2025-11-28 10:05:32',NULL,0,22,'cc1fbd7319614f7ab4566dfed25610b8','volumes',0,0,NULL,1),('2025-11-28 10:05:29','2025-11-28 10:05:32',NULL,0,23,'cc1fbd7319614f7ab4566dfed25610b8','gigabytes',0,0,NULL,1),('2025-11-28 10:05:29','2025-11-28 10:05:31',NULL,0,24,'cc1fbd7319614f7ab4566dfed25610b8','volumes_volume-type-1',0,0,NULL,1),('2025-11-28 10:05:29','2025-11-28 10:05:31',NULL,0,25,'cc1fbd7319614f7ab4566dfed25610b8','gigabytes_volume-type-1',0,0,NULL,1),('2025-11-28 10:05:31','2025-11-28 10:05:32',NULL,0,26,'cc1fbd7319614f7ab4566dfed25610b8','volumes_volume-type-2',0,0,NULL,1),('2025-11-28 10:05:31','2025-11-28 10:05:32',NULL,0,27,'cc1fbd7319614f7ab4566dfed25610b8','gigabytes_volume-type-2',0,0,NULL,1),('2025-11-28 10:05:32','2025-11-28 10:05:39',NULL,0,28,'5c1cc8bd04e04964bf55c27886efbf5c','groups',0,0,NULL,1),('2025-11-28 10:05:33','2025-11-28 10:05:39',NULL,0,29,'5c1cc8bd04e04964bf55c27886efbf5c','volumes',0,0,NULL,1),('2025-11-28 10:05:33','2025-11-28 10:05:39',NULL,0,30,'5c1cc8bd04e04964bf55c27886efbf5c','gigabytes',0,0,NULL,1),('2025-11-28 10:05:33','2025-11-28 10:05:39',NULL,0,31,'5c1cc8bd04e04964bf55c27886efbf5c','volumes_tempest-GroupsV314Test-volume-type-739357787',0,0,NULL,1),('2025-11-28 10:05:33','2025-11-28 10:05:39',NULL,0,32,'5c1cc8bd04e04964bf55c27886efbf5c','gigabytes_tempest-GroupsV314Test-volume-type-739357787',0,0,NULL,1),('2025-11-28 10:05:45','2025-11-28 10:05:51',NULL,0,33,'ba7456648a0f43028832ef04ff1d03da','volumes',0,0,NULL,1),('2025-11-28 10:05:45','2025-11-28 10:05:51',NULL,0,34,'ba7456648a0f43028832ef04ff1d03da','gigabytes',0,0,NULL,1),('2025-11-28 10:05:45','2025-11-28 10:05:51',NULL,0,35,'ba7456648a0f43028832ef04ff1d03da','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:05:45','2025-11-28 10:05:51',NULL,0,36,'ba7456648a0f43028832ef04ff1d03da','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:05:46','2025-11-28 10:05:49',NULL,0,37,'ba7456648a0f43028832ef04ff1d03da','snapshots',0,0,NULL,1),('2025-11-28 10:05:46','2025-11-28 10:05:49',NULL,0,38,'ba7456648a0f43028832ef04ff1d03da','snapshots_tripleo',0,0,NULL,1),('2025-11-28 10:05:49','2025-11-28 10:05:59',NULL,0,39,'38c774f4f3a34ba7822603fa362cd4c8','volumes',0,0,NULL,1),('2025-11-28 10:05:49','2025-11-28 10:05:59',NULL,0,40,'38c774f4f3a34ba7822603fa362cd4c8','gigabytes',0,0,NULL,1),('2025-11-28 10:05:49','2025-11-28 10:05:59',NULL,0,41,'38c774f4f3a34ba7822603fa362cd4c8','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:05:49','2025-11-28 10:05:59',NULL,0,42,'38c774f4f3a34ba7822603fa362cd4c8','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:05:55','2025-11-28 10:06:24',NULL,0,43,'d2d31a928b84446c97d35bb770c268e5','volumes',0,0,NULL,1),('2025-11-28 10:05:55','2025-11-28 10:06:24',NULL,0,44,'d2d31a928b84446c97d35bb770c268e5','gigabytes',0,0,NULL,1),('2025-11-28 10:05:55','2025-11-28 10:06:24',NULL,0,45,'d2d31a928b84446c97d35bb770c268e5','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:05:55','2025-11-28 10:06:24',NULL,0,46,'d2d31a928b84446c97d35bb770c268e5','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:05:55','2025-11-28 10:05:58',NULL,0,47,'16a57eec68224f4d9395015bb4c6714b','volumes',0,0,NULL,1),('2025-11-28 10:05:55','2025-11-28 10:05:58',NULL,0,48,'16a57eec68224f4d9395015bb4c6714b','gigabytes',0,0,NULL,1),('2025-11-28 10:05:55','2025-11-28 10:05:58',NULL,0,49,'16a57eec68224f4d9395015bb4c6714b','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:05:55','2025-11-28 10:05:58',NULL,0,50,'16a57eec68224f4d9395015bb4c6714b','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:05:57','2025-11-28 10:06:21',NULL,0,51,'d2d31a928b84446c97d35bb770c268e5','backups',0,0,NULL,1),('2025-11-28 10:05:57','2025-11-28 10:06:21',NULL,0,52,'d2d31a928b84446c97d35bb770c268e5','backup_gigabytes',0,0,NULL,1),('2025-11-28 10:06:02','2025-11-28 10:06:04',NULL,0,53,'09ce8f94e31a412b82a6b18baad225fe','volumes',0,0,NULL,1),('2025-11-28 10:06:02','2025-11-28 10:06:04',NULL,0,54,'09ce8f94e31a412b82a6b18baad225fe','gigabytes',0,0,NULL,1),('2025-11-28 10:06:02','2025-11-28 10:06:04',NULL,0,55,'09ce8f94e31a412b82a6b18baad225fe','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:06:02','2025-11-28 10:06:04',NULL,0,56,'09ce8f94e31a412b82a6b18baad225fe','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:06:05','2025-11-28 10:06:10',NULL,0,57,'aff7b7030d9c4af69b909a2b53581468','backups',0,0,NULL,1),('2025-11-28 10:06:05','2025-11-28 10:06:10',NULL,0,58,'aff7b7030d9c4af69b909a2b53581468','backup_gigabytes',0,0,NULL,1),('2025-11-28 10:06:08','2025-11-28 10:06:10',NULL,0,59,'e8a245ce85d845b5aa0d1f9c0238c9e1','volumes',0,0,NULL,1),('2025-11-28 10:06:08','2025-11-28 10:06:10',NULL,0,60,'e8a245ce85d845b5aa0d1f9c0238c9e1','gigabytes',0,0,NULL,1),('2025-11-28 10:06:08','2025-11-28 10:06:10',NULL,0,61,'e8a245ce85d845b5aa0d1f9c0238c9e1','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:06:08','2025-11-28 10:06:10',NULL,0,62,'e8a245ce85d845b5aa0d1f9c0238c9e1','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:06:21','2025-11-28 10:08:07',NULL,0,63,'d3c0d1ce8d854a7b9ffc953e88cd2c44','volumes',0,0,NULL,1),('2025-11-28 10:06:21','2025-11-28 10:08:07',NULL,0,64,'d3c0d1ce8d854a7b9ffc953e88cd2c44','gigabytes',0,0,NULL,1),('2025-11-28 10:06:21','2025-11-28 10:08:07',NULL,0,65,'d3c0d1ce8d854a7b9ffc953e88cd2c44','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:06:21','2025-11-28 10:08:07',NULL,0,66,'d3c0d1ce8d854a7b9ffc953e88cd2c44','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:06:22','2025-11-28 10:06:45',NULL,0,67,'85f17f60fae2462cb663ba226772cedd','volumes',0,0,NULL,1),('2025-11-28 10:06:22','2025-11-28 10:06:45',NULL,0,68,'85f17f60fae2462cb663ba226772cedd','gigabytes',0,0,NULL,1),('2025-11-28 10:06:22','2025-11-28 10:06:45',NULL,0,69,'85f17f60fae2462cb663ba226772cedd','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:06:22','2025-11-28 10:06:45',NULL,0,70,'85f17f60fae2462cb663ba226772cedd','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:06:23','2025-11-28 10:06:42',NULL,0,71,'85f17f60fae2462cb663ba226772cedd','snapshots',0,0,NULL,1),('2025-11-28 10:06:23','2025-11-28 10:06:42',NULL,0,72,'85f17f60fae2462cb663ba226772cedd','snapshots_tripleo',0,0,NULL,1),('2025-11-28 10:06:24','2025-11-28 10:07:13',NULL,0,73,'29d0d5b3ba0745d58aee3845ea704b73','volumes',0,0,NULL,1),('2025-11-28 10:06:24','2025-11-28 10:07:13',NULL,0,74,'29d0d5b3ba0745d58aee3845ea704b73','gigabytes',0,0,NULL,1),('2025-11-28 10:06:24','2025-11-28 10:07:13',NULL,0,75,'29d0d5b3ba0745d58aee3845ea704b73','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:06:24','2025-11-28 10:07:13',NULL,0,76,'29d0d5b3ba0745d58aee3845ea704b73','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:06:27','2025-11-28 10:07:55',NULL,0,77,'d3c0d1ce8d854a7b9ffc953e88cd2c44','backups',0,0,NULL,1),('2025-11-28 10:06:27','2025-11-28 10:07:55',NULL,0,78,'d3c0d1ce8d854a7b9ffc953e88cd2c44','backup_gigabytes',0,0,NULL,1),('2025-11-28 10:06:32','2025-11-28 10:06:38',NULL,0,79,'87556d11d3894443a0252992df39cd59','volumes',0,0,NULL,1),('2025-11-28 10:06:32','2025-11-28 10:06:38',NULL,0,80,'87556d11d3894443a0252992df39cd59','gigabytes',0,0,NULL,1),('2025-11-28 10:06:32','2025-11-28 10:06:38',NULL,0,81,'87556d11d3894443a0252992df39cd59','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:06:32','2025-11-28 10:06:38',NULL,0,82,'87556d11d3894443a0252992df39cd59','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:06:33','2025-11-28 10:06:35',NULL,0,83,'030c225d7ed34b12a2a9020cd72dbf3a','volumes',0,0,NULL,1),('2025-11-28 10:06:33','2025-11-28 10:06:35',NULL,0,84,'030c225d7ed34b12a2a9020cd72dbf3a','gigabytes',0,0,NULL,1),('2025-11-28 10:06:33','2025-11-28 10:06:35',NULL,0,85,'030c225d7ed34b12a2a9020cd72dbf3a','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:06:33','2025-11-28 10:06:35',NULL,0,86,'030c225d7ed34b12a2a9020cd72dbf3a','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:06:33',NULL,NULL,0,87,'030c225d7ed34b12a2a9020cd72dbf3a','snapshots',0,0,NULL,1),('2025-11-28 10:06:33',NULL,NULL,0,88,'030c225d7ed34b12a2a9020cd72dbf3a','snapshots_tripleo',0,0,NULL,1),('2025-11-28 10:06:33',NULL,NULL,0,89,'87556d11d3894443a0252992df39cd59','snapshots',0,0,NULL,1),('2025-11-28 10:06:33',NULL,NULL,0,90,'87556d11d3894443a0252992df39cd59','snapshots_tripleo',0,0,NULL,1),('2025-11-28 10:06:50','2025-11-28 10:07:05',NULL,0,91,'a1eb2d80861b4077b9ef4c3389f19286','volumes',0,0,NULL,1),('2025-11-28 10:06:50','2025-11-28 10:07:05',NULL,0,92,'a1eb2d80861b4077b9ef4c3389f19286','gigabytes',0,0,NULL,1),('2025-11-28 10:06:50','2025-11-28 10:07:05',NULL,0,93,'a1eb2d80861b4077b9ef4c3389f19286','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:06:50','2025-11-28 10:07:05',NULL,0,94,'a1eb2d80861b4077b9ef4c3389f19286','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:07:14','2025-11-28 10:07:26',NULL,0,95,'7369c667b30341f7b300e32774b31181','volumes',0,0,NULL,1),('2025-11-28 10:07:14','2025-11-28 10:07:26',NULL,0,96,'7369c667b30341f7b300e32774b31181','gigabytes',0,0,NULL,1),('2025-11-28 10:07:14','2025-11-28 10:07:26',NULL,0,97,'7369c667b30341f7b300e32774b31181','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:07:14','2025-11-28 10:07:26',NULL,0,98,'7369c667b30341f7b300e32774b31181','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:07:16','2025-11-28 10:07:25',NULL,0,99,'7369c667b30341f7b300e32774b31181','snapshots',0,0,NULL,1),('2025-11-28 10:07:16','2025-11-28 10:07:25',NULL,0,100,'7369c667b30341f7b300e32774b31181','snapshots_tripleo',0,0,NULL,1),('2025-11-28 10:07:27','2025-11-28 10:07:29',NULL,0,101,'b4ab010fc80b442f8f29d2f02f18ecc9','volumes',0,0,NULL,1),('2025-11-28 10:07:27','2025-11-28 10:07:29',NULL,0,102,'b4ab010fc80b442f8f29d2f02f18ecc9','gigabytes',0,0,NULL,1),('2025-11-28 10:07:27','2025-11-28 10:07:29',NULL,0,103,'b4ab010fc80b442f8f29d2f02f18ecc9','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:07:27','2025-11-28 10:07:29',NULL,0,104,'b4ab010fc80b442f8f29d2f02f18ecc9','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:07:34','2025-11-28 10:07:46',NULL,0,105,'7dd88588dc3b46ab8658061b1ac13996','volumes',0,0,NULL,1),('2025-11-28 10:07:34','2025-11-28 10:07:46',NULL,0,106,'7dd88588dc3b46ab8658061b1ac13996','gigabytes',0,0,NULL,1),('2025-11-28 10:07:34','2025-11-28 10:07:46',NULL,0,107,'7dd88588dc3b46ab8658061b1ac13996','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:07:34','2025-11-28 10:07:46',NULL,0,108,'7dd88588dc3b46ab8658061b1ac13996','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:07:41','2025-11-28 10:07:51',NULL,0,109,'44e47888bf384f2290cbd80a83fd1322','groups',0,0,NULL,1),('2025-11-28 10:07:43','2025-11-28 10:07:51',NULL,0,110,'44e47888bf384f2290cbd80a83fd1322','volumes',0,0,NULL,1),('2025-11-28 10:07:43','2025-11-28 10:07:51',NULL,0,111,'44e47888bf384f2290cbd80a83fd1322','gigabytes',0,0,NULL,1),('2025-11-28 10:07:43','2025-11-28 10:07:51',NULL,0,112,'44e47888bf384f2290cbd80a83fd1322','volumes_tempest-GroupSnapshotsV319Test-volume-type-1428748724',0,0,NULL,1),('2025-11-28 10:07:43','2025-11-28 10:07:51',NULL,0,113,'44e47888bf384f2290cbd80a83fd1322','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-1428748724',0,0,NULL,1),('2025-11-28 10:07:45','2025-11-28 10:07:49',NULL,0,114,'44e47888bf384f2290cbd80a83fd1322','snapshots',0,0,NULL,1),('2025-11-28 10:07:45','2025-11-28 10:07:49',NULL,0,115,'44e47888bf384f2290cbd80a83fd1322','snapshots_tempest-GroupSnapshotsV319Test-volume-type-1428748724',0,0,NULL,1),('2025-11-28 10:08:01','2025-11-28 10:08:06',NULL,0,116,'5171816b5d3845278c70b062bedaa177','volumes',0,0,NULL,1),('2025-11-28 10:08:01','2025-11-28 10:08:06',NULL,0,117,'5171816b5d3845278c70b062bedaa177','gigabytes',0,0,NULL,1),('2025-11-28 10:08:01','2025-11-28 10:08:06',NULL,0,118,'5171816b5d3845278c70b062bedaa177','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:08:01','2025-11-28 10:08:06',NULL,0,119,'5171816b5d3845278c70b062bedaa177','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:08:06','2025-11-28 10:08:07',NULL,0,120,'6f9594f9fb704068b77cd4ff3489e542','volumes',0,0,NULL,1),('2025-11-28 10:08:06','2025-11-28 10:08:07',NULL,0,121,'6f9594f9fb704068b77cd4ff3489e542','gigabytes',0,0,NULL,1),('2025-11-28 10:08:06','2025-11-28 10:08:07',NULL,0,122,'6f9594f9fb704068b77cd4ff3489e542','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:08:06','2025-11-28 10:08:07',NULL,0,123,'6f9594f9fb704068b77cd4ff3489e542','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:08:06',NULL,NULL,0,124,'6f9594f9fb704068b77cd4ff3489e542','snapshots',0,0,NULL,1),('2025-11-28 10:08:06',NULL,NULL,0,125,'6f9594f9fb704068b77cd4ff3489e542','snapshots_tripleo',0,0,NULL,1),('2025-11-28 10:08:06',NULL,NULL,0,126,'5171816b5d3845278c70b062bedaa177','snapshots',0,0,NULL,1),('2025-11-28 10:08:06',NULL,NULL,0,127,'5171816b5d3845278c70b062bedaa177','snapshots_tripleo',0,0,NULL,1),('2025-11-28 10:08:18','2025-11-28 10:08:34',NULL,0,128,'6732fa86445147cdb019a2189d601a62','volumes',0,0,NULL,1),('2025-11-28 10:08:18','2025-11-28 10:08:34',NULL,0,129,'6732fa86445147cdb019a2189d601a62','gigabytes',0,0,NULL,1),('2025-11-28 10:08:18','2025-11-28 10:08:34',NULL,0,130,'6732fa86445147cdb019a2189d601a62','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:08:18','2025-11-28 10:08:34',NULL,0,131,'6732fa86445147cdb019a2189d601a62','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:08:19','2025-11-28 10:08:24',NULL,0,132,'b75145391b1642aa86ac346010612ae1','volumes',0,0,NULL,1),('2025-11-28 10:08:19','2025-11-28 10:08:24',NULL,0,133,'b75145391b1642aa86ac346010612ae1','gigabytes',0,0,NULL,1),('2025-11-28 10:08:19','2025-11-28 10:08:24',NULL,0,134,'b75145391b1642aa86ac346010612ae1','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:08:19','2025-11-28 10:08:24',NULL,0,135,'b75145391b1642aa86ac346010612ae1','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:08:21','2025-11-28 10:08:22',NULL,0,136,'e40ad514f1414282aba0c087f08f4797','volumes',0,0,NULL,1),('2025-11-28 10:08:21','2025-11-28 10:08:22',NULL,0,137,'e40ad514f1414282aba0c087f08f4797','gigabytes',0,0,NULL,1),('2025-11-28 10:08:21','2025-11-28 10:08:22',NULL,0,138,'e40ad514f1414282aba0c087f08f4797','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:08:21','2025-11-28 10:08:22',NULL,0,139,'e40ad514f1414282aba0c087f08f4797','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:08:21',NULL,NULL,0,140,'e40ad514f1414282aba0c087f08f4797','snapshots',0,0,NULL,1),('2025-11-28 10:08:21',NULL,NULL,0,141,'e40ad514f1414282aba0c087f08f4797','snapshots_tripleo',0,0,NULL,1),('2025-11-28 10:08:21',NULL,NULL,0,142,'b75145391b1642aa86ac346010612ae1','snapshots',0,0,NULL,1),('2025-11-28 10:08:21',NULL,NULL,0,143,'b75145391b1642aa86ac346010612ae1','snapshots_tripleo',0,0,NULL,1),('2025-11-28 10:08:23','2025-11-28 10:08:38',NULL,0,144,'708e5a4db87c470c994eb117a4c58083','groups',0,0,NULL,1),('2025-11-28 10:08:25','2025-11-28 10:08:38',NULL,0,145,'708e5a4db87c470c994eb117a4c58083','volumes',0,0,NULL,1),('2025-11-28 10:08:25','2025-11-28 10:08:38',NULL,0,146,'708e5a4db87c470c994eb117a4c58083','gigabytes',0,0,NULL,1),('2025-11-28 10:08:25','2025-11-28 10:08:28',NULL,0,147,'708e5a4db87c470c994eb117a4c58083','volumes_tempest-GroupsTest-volume-type-1256221482',0,0,NULL,1),('2025-11-28 10:08:25','2025-11-28 10:08:28',NULL,0,148,'708e5a4db87c470c994eb117a4c58083','gigabytes_tempest-GroupsTest-volume-type-1256221482',0,0,NULL,1),('2025-11-28 10:08:28','2025-11-28 10:08:32',NULL,0,149,'6732fa86445147cdb019a2189d601a62','snapshots',0,0,NULL,1),('2025-11-28 10:08:28','2025-11-28 10:08:32',NULL,0,150,'6732fa86445147cdb019a2189d601a62','snapshots_tripleo',0,0,NULL,1),('2025-11-28 10:08:30','2025-11-28 10:08:32',NULL,0,151,'b1155d9e62f747aab975f341b5b53a22','groups',0,0,NULL,1),('2025-11-28 10:08:30','2025-11-28 10:08:36',NULL,0,152,'79cbcb0957f54ef09645577668ab7937','volumes',0,0,NULL,1),('2025-11-28 10:08:30','2025-11-28 10:08:36',NULL,0,153,'79cbcb0957f54ef09645577668ab7937','gigabytes',0,0,NULL,1),('2025-11-28 10:08:30','2025-11-28 10:08:36',NULL,0,154,'79cbcb0957f54ef09645577668ab7937','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:08:30','2025-11-28 10:08:36',NULL,0,155,'79cbcb0957f54ef09645577668ab7937','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:08:31','2025-11-28 10:08:50',NULL,0,156,'a6f735cf317e42218560e5eb75b569f6','volumes',0,0,NULL,1),('2025-11-28 10:08:31','2025-11-28 10:08:50',NULL,0,157,'a6f735cf317e42218560e5eb75b569f6','gigabytes',0,0,NULL,1),('2025-11-28 10:08:31','2025-11-28 10:08:50',NULL,0,158,'a6f735cf317e42218560e5eb75b569f6','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:08:31','2025-11-28 10:08:50',NULL,0,159,'a6f735cf317e42218560e5eb75b569f6','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:08:31','2025-11-28 10:08:38',NULL,0,160,'708e5a4db87c470c994eb117a4c58083','volumes_tempest-GroupsTest-volume-type-541534715',0,0,NULL,1),('2025-11-28 10:08:31','2025-11-28 10:08:38',NULL,0,161,'708e5a4db87c470c994eb117a4c58083','gigabytes_tempest-GroupsTest-volume-type-541534715',0,0,NULL,1),('2025-11-28 10:08:32','2025-11-28 10:08:34',NULL,0,162,'79cbcb0957f54ef09645577668ab7937','snapshots',0,0,NULL,1),('2025-11-28 10:08:32','2025-11-28 10:08:34',NULL,0,163,'79cbcb0957f54ef09645577668ab7937','snapshots_tripleo',0,0,NULL,1),('2025-11-28 10:08:32','2025-11-28 10:08:49',NULL,0,164,'a6f735cf317e42218560e5eb75b569f6','snapshots',0,0,NULL,1),('2025-11-28 10:08:32','2025-11-28 10:08:49',NULL,0,165,'a6f735cf317e42218560e5eb75b569f6','snapshots_tripleo',0,0,NULL,1),('2025-11-28 10:08:49','2025-11-28 10:08:54',NULL,0,166,'282cf5c7f55f44abb1217a52fa10743f','volumes',0,0,NULL,1),('2025-11-28 10:08:49','2025-11-28 10:08:54',NULL,0,167,'282cf5c7f55f44abb1217a52fa10743f','gigabytes',0,0,NULL,1),('2025-11-28 10:08:49','2025-11-28 10:08:54',NULL,0,168,'282cf5c7f55f44abb1217a52fa10743f','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:08:49','2025-11-28 10:08:54',NULL,0,169,'282cf5c7f55f44abb1217a52fa10743f','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:08:50','2025-11-28 10:08:51',NULL,0,170,'e7cc91f8f0484d558c7d91f23a229370','volumes',0,0,NULL,1),('2025-11-28 10:08:50','2025-11-28 10:08:51',NULL,0,171,'e7cc91f8f0484d558c7d91f23a229370','gigabytes',0,0,NULL,1),('2025-11-28 10:08:50','2025-11-28 10:08:51',NULL,0,172,'e7cc91f8f0484d558c7d91f23a229370','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:08:50','2025-11-28 10:08:51',NULL,0,173,'e7cc91f8f0484d558c7d91f23a229370','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:08:50',NULL,NULL,0,174,'e7cc91f8f0484d558c7d91f23a229370','snapshots',0,0,NULL,1),('2025-11-28 10:08:50',NULL,NULL,0,175,'e7cc91f8f0484d558c7d91f23a229370','snapshots_tripleo',0,0,NULL,1),('2025-11-28 10:08:50',NULL,NULL,0,176,'282cf5c7f55f44abb1217a52fa10743f','snapshots',0,0,NULL,1),('2025-11-28 10:08:50',NULL,NULL,0,177,'282cf5c7f55f44abb1217a52fa10743f','snapshots_tripleo',0,0,NULL,1),('2025-11-28 10:08:55','2025-11-28 10:09:04',NULL,0,178,'af627bb6800b48f795f524c5240dd96e','volumes',0,0,NULL,1),('2025-11-28 10:08:55','2025-11-28 10:09:04',NULL,0,179,'af627bb6800b48f795f524c5240dd96e','gigabytes',0,0,NULL,1),('2025-11-28 10:08:55','2025-11-28 10:09:04',NULL,0,180,'af627bb6800b48f795f524c5240dd96e','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:08:55','2025-11-28 10:09:04',NULL,0,181,'af627bb6800b48f795f524c5240dd96e','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:08:57','2025-11-28 10:09:00',NULL,0,182,'f85d8ffada2842738a1307658c19c621','volumes',0,0,NULL,1),('2025-11-28 10:08:57','2025-11-28 10:09:00',NULL,0,183,'f85d8ffada2842738a1307658c19c621','gigabytes',0,0,NULL,1),('2025-11-28 10:08:57','2025-11-28 10:08:58',NULL,0,184,'f85d8ffada2842738a1307658c19c621','volumes_tempest-UserMessagesTest-volume-type-537457498',0,0,NULL,1),('2025-11-28 10:08:57','2025-11-28 10:08:58',NULL,0,185,'f85d8ffada2842738a1307658c19c621','gigabytes_tempest-UserMessagesTest-volume-type-537457498',0,0,NULL,1),('2025-11-28 10:08:58','2025-11-28 10:09:00',NULL,0,186,'f85d8ffada2842738a1307658c19c621','volumes_tempest-UserMessagesTest-volume-type-1856484675',0,0,NULL,1),('2025-11-28 10:08:58','2025-11-28 10:09:00',NULL,0,187,'f85d8ffada2842738a1307658c19c621','gigabytes_tempest-UserMessagesTest-volume-type-1856484675',0,0,NULL,1),('2025-11-28 10:08:59','2025-11-28 10:09:01',NULL,0,188,'85b0cd4fbc9547ea80ee82fddaeca666','volumes',0,0,NULL,1),('2025-11-28 10:08:59','2025-11-28 10:09:01',NULL,0,189,'85b0cd4fbc9547ea80ee82fddaeca666','gigabytes',0,0,NULL,1),('2025-11-28 10:08:59','2025-11-28 10:09:01',NULL,0,190,'85b0cd4fbc9547ea80ee82fddaeca666','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:08:59','2025-11-28 10:09:01',NULL,0,191,'85b0cd4fbc9547ea80ee82fddaeca666','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:09:00','2025-11-28 10:09:08',NULL,0,192,'fc7fccbd32a74bc3b7becd3530d9005e','volumes',0,0,NULL,1),('2025-11-28 10:09:00','2025-11-28 10:09:08',NULL,0,193,'fc7fccbd32a74bc3b7becd3530d9005e','gigabytes',0,0,NULL,1),('2025-11-28 10:09:00','2025-11-28 10:09:08',NULL,0,194,'fc7fccbd32a74bc3b7becd3530d9005e','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:09:00','2025-11-28 10:09:08',NULL,0,195,'fc7fccbd32a74bc3b7becd3530d9005e','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:09:01','2025-11-28 10:09:06',NULL,0,196,'fc7fccbd32a74bc3b7becd3530d9005e','backups',0,0,NULL,1),('2025-11-28 10:09:01','2025-11-28 10:09:06',NULL,0,197,'fc7fccbd32a74bc3b7becd3530d9005e','backup_gigabytes',0,0,NULL,1),('2025-11-28 10:09:08','2025-11-28 10:09:22',NULL,0,198,'673b477f9d70449480701aa9846d8f60','volumes',0,0,NULL,1),('2025-11-28 10:09:08','2025-11-28 10:09:22',NULL,0,199,'673b477f9d70449480701aa9846d8f60','gigabytes',0,0,NULL,1),('2025-11-28 10:09:08','2025-11-28 10:09:22',NULL,0,200,'673b477f9d70449480701aa9846d8f60','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:09:08','2025-11-28 10:09:22',NULL,0,201,'673b477f9d70449480701aa9846d8f60','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:09:10','2025-11-28 10:09:13',NULL,0,202,'6da8102120594d6c98901d137ca0bc9b','volumes',0,0,NULL,1),('2025-11-28 10:09:10','2025-11-28 10:09:13',NULL,0,203,'6da8102120594d6c98901d137ca0bc9b','gigabytes',0,0,NULL,1),('2025-11-28 10:09:10','2025-11-28 10:09:13',NULL,0,204,'6da8102120594d6c98901d137ca0bc9b','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:09:10','2025-11-28 10:09:13',NULL,0,205,'6da8102120594d6c98901d137ca0bc9b','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:09:18','2025-11-28 10:09:24',NULL,0,206,'e67c42de6de84a6eba7382934e59b9b3','volumes',0,0,NULL,1),('2025-11-28 10:09:18','2025-11-28 10:09:24',NULL,0,207,'e67c42de6de84a6eba7382934e59b9b3','gigabytes',0,0,NULL,1),('2025-11-28 10:09:18','2025-11-28 10:09:24',NULL,0,208,'e67c42de6de84a6eba7382934e59b9b3','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:09:18','2025-11-28 10:09:24',NULL,0,209,'e67c42de6de84a6eba7382934e59b9b3','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:09:20','2025-11-28 10:09:22',NULL,0,210,'e67c42de6de84a6eba7382934e59b9b3','snapshots',0,0,NULL,1),('2025-11-28 10:09:20','2025-11-28 10:09:22',NULL,0,211,'e67c42de6de84a6eba7382934e59b9b3','snapshots_tripleo',0,0,NULL,1),('2025-11-28 10:09:22','2025-11-28 10:10:00',NULL,0,212,'3e2ec027cab64e90a22b087eafacf760','volumes',0,0,NULL,1),('2025-11-28 10:09:22','2025-11-28 10:10:00',NULL,0,213,'3e2ec027cab64e90a22b087eafacf760','gigabytes',0,0,NULL,1),('2025-11-28 10:09:22','2025-11-28 10:10:00',NULL,0,214,'3e2ec027cab64e90a22b087eafacf760','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:09:22','2025-11-28 10:10:00',NULL,0,215,'3e2ec027cab64e90a22b087eafacf760','gigabytes_tripleo',0,0,NULL,1),('2025-11-28 10:09:23','2025-11-28 10:09:58',NULL,0,216,'3e2ec027cab64e90a22b087eafacf760','snapshots',0,0,NULL,1),('2025-11-28 10:09:23','2025-11-28 10:09:58',NULL,0,217,'3e2ec027cab64e90a22b087eafacf760','snapshots_tripleo',0,0,NULL,1),('2025-11-28 10:09:24','2025-11-28 10:09:40',NULL,0,218,'3e2ec027cab64e90a22b087eafacf760','backups',0,0,NULL,1),('2025-11-28 10:09:24','2025-11-28 10:09:40',NULL,0,219,'3e2ec027cab64e90a22b087eafacf760','backup_gigabytes',0,0,NULL,1),('2025-11-28 10:09:26','2025-11-28 10:09:53',NULL,0,220,'df6949ad183e4e1e8db4a49117054e84','volumes',0,0,NULL,1),('2025-11-28 10:09:26','2025-11-28 10:09:53',NULL,0,221,'df6949ad183e4e1e8db4a49117054e84','gigabytes',0,0,NULL,1),('2025-11-28 10:09:26','2025-11-28 10:09:53',NULL,0,222,'df6949ad183e4e1e8db4a49117054e84','volumes_tripleo',0,0,NULL,1),('2025-11-28 10:09:26','2025-11-28 10:09:53',NULL,0,223,'df6949ad183e4e1e8db4a49117054e84','gigabytes_tripleo',0,0,NULL,1);
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
INSERT INTO `quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `project_id`, `resource`, `hard_limit`, `allocated`) VALUES (1,'2025-11-28 10:08:01','2025-11-28 10:08:01','2025-11-28 10:08:01',1,'5171816b5d3845278c70b062bedaa177','volumes',15,0),(2,'2025-11-28 10:08:01','2025-11-28 10:08:08',NULL,0,'5171816b5d3845278c70b062bedaa177','volumes',10,0),(3,'2025-11-28 10:08:01','2025-11-28 10:08:08',NULL,0,'5171816b5d3845278c70b062bedaa177','per_volume_gigabytes',-1,0),(4,'2025-11-28 10:08:01','2025-11-28 10:08:08',NULL,0,'5171816b5d3845278c70b062bedaa177','snapshots',10,0),(5,'2025-11-28 10:08:01','2025-11-28 10:08:08',NULL,0,'5171816b5d3845278c70b062bedaa177','gigabytes',1000,0),(6,'2025-11-28 10:08:01','2025-11-28 10:08:08',NULL,0,'5171816b5d3845278c70b062bedaa177','backups',10,0),(7,'2025-11-28 10:08:01','2025-11-28 10:08:08',NULL,0,'5171816b5d3845278c70b062bedaa177','backup_gigabytes',1000,0),(8,'2025-11-28 10:09:11','2025-11-28 10:09:13',NULL,0,'6da8102120594d6c98901d137ca0bc9b','gigabytes',1000,0),(9,'2025-11-28 10:09:11','2025-11-28 10:09:13',NULL,0,'6da8102120594d6c98901d137ca0bc9b','volumes',10,0),(10,'2025-11-28 10:09:13',NULL,NULL,0,'6da8102120594d6c98901d137ca0bc9b','per_volume_gigabytes',-1,0),(11,'2025-11-28 10:09:13',NULL,NULL,0,'6da8102120594d6c98901d137ca0bc9b','snapshots',10,0),(12,'2025-11-28 10:09:13',NULL,NULL,0,'6da8102120594d6c98901d137ca0bc9b','backups',10,0),(13,'2025-11-28 10:09:13',NULL,NULL,0,'6da8102120594d6c98901d137ca0bc9b','backup_gigabytes',1000,0),(14,'2025-11-28 10:09:18','2025-11-28 10:09:24',NULL,0,'e67c42de6de84a6eba7382934e59b9b3','gigabytes',1000,0),(15,'2025-11-28 10:09:18','2025-11-28 10:09:24',NULL,0,'e67c42de6de84a6eba7382934e59b9b3','volumes',10,0),(16,'2025-11-28 10:09:18','2025-11-28 10:09:24',NULL,0,'e67c42de6de84a6eba7382934e59b9b3','snapshots',10,0),(17,'2025-11-28 10:09:24',NULL,NULL,0,'e67c42de6de84a6eba7382934e59b9b3','per_volume_gigabytes',-1,0),(18,'2025-11-28 10:09:24',NULL,NULL,0,'e67c42de6de84a6eba7382934e59b9b3','backups',10,0),(19,'2025-11-28 10:09:24',NULL,NULL,0,'e67c42de6de84a6eba7382934e59b9b3','backup_gigabytes',1000,0);
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=925 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `allocated_id`) VALUES ('2025-11-28 10:03:33','2025-11-28 10:03:33','2025-11-28 10:03:33',1,1,'a4ae56a2-10c6-4a3f-81d1-3fb06fd2ed69',1,'115c143e37394d77b81665435ce51c10','groups',1,'2025-11-29 10:03:33',NULL),('2025-11-28 10:03:35','2025-11-28 10:03:35','2025-11-28 10:03:35',1,2,'5ed3d5c4-437c-420c-a559-0762459956a5',2,'115c143e37394d77b81665435ce51c10','volumes',1,'2025-11-29 10:03:35',NULL),('2025-11-28 10:03:35','2025-11-28 10:03:35','2025-11-28 10:03:35',1,3,'c12af4c3-5e89-404d-ad91-95ec6861f63c',3,'115c143e37394d77b81665435ce51c10','gigabytes',1,'2025-11-29 10:03:35',NULL),('2025-11-28 10:03:35','2025-11-28 10:03:35','2025-11-28 10:03:35',1,4,'c5112a8e-fb09-4610-a634-2e35d6fdf5af',4,'115c143e37394d77b81665435ce51c10','volumes_tempest-GroupSnapshotsTest-volume-type-1857876428',1,'2025-11-29 10:03:35',NULL),('2025-11-28 10:03:35','2025-11-28 10:03:35','2025-11-28 10:03:35',1,5,'c1dc35c9-68af-408e-84fe-d9f255740d9c',5,'115c143e37394d77b81665435ce51c10','gigabytes_tempest-GroupSnapshotsTest-volume-type-1857876428',1,'2025-11-29 10:03:35',NULL),('2025-11-28 10:03:37','2025-11-28 10:03:37','2025-11-28 10:03:37',1,6,'cb97f601-470a-4c65-a26f-24ee9e6f7210',6,'115c143e37394d77b81665435ce51c10','snapshots',1,'2025-11-29 10:03:37',NULL),('2025-11-28 10:03:37','2025-11-28 10:03:37','2025-11-28 10:03:37',1,7,'6e79e46f-70d5-40e5-86bd-c1e5166a62de',3,'115c143e37394d77b81665435ce51c10','gigabytes',1,'2025-11-29 10:03:37',NULL),('2025-11-28 10:03:37','2025-11-28 10:03:37','2025-11-28 10:03:37',1,8,'976df521-98b0-4331-9dd7-d34e875e96e1',5,'115c143e37394d77b81665435ce51c10','gigabytes_tempest-GroupSnapshotsTest-volume-type-1857876428',1,'2025-11-29 10:03:37',NULL),('2025-11-28 10:03:37','2025-11-28 10:03:37','2025-11-28 10:03:37',1,9,'f67f343e-6684-42ac-9a90-f88e8669cfa4',7,'115c143e37394d77b81665435ce51c10','snapshots_tempest-GroupSnapshotsTest-volume-type-1857876428',1,'2025-11-29 10:03:37',NULL),('2025-11-28 10:03:39','2025-11-28 10:03:39','2025-11-28 10:03:39',1,10,'eb0f403b-ed07-4078-897b-9194dd8321ff',1,'115c143e37394d77b81665435ce51c10','groups',1,'2025-11-29 10:03:39',NULL),('2025-11-28 10:03:39','2025-11-28 10:03:39','2025-11-28 10:03:39',1,11,'3eb25e88-2ffd-4872-8d49-0536b0b08ac9',2,'115c143e37394d77b81665435ce51c10','volumes',1,'2025-11-29 10:03:39',NULL),('2025-11-28 10:03:39','2025-11-28 10:03:39','2025-11-28 10:03:39',1,12,'302cec83-9144-4254-968b-3dd432af1b5c',4,'115c143e37394d77b81665435ce51c10','volumes_tempest-GroupSnapshotsTest-volume-type-1857876428',1,'2025-11-29 10:03:39',NULL),('2025-11-28 10:03:42','2025-11-28 10:03:42','2025-11-28 10:03:42',1,13,'112c2ca4-3077-4666-94c2-5477e0728fb4',1,'115c143e37394d77b81665435ce51c10','groups',-1,'2025-11-29 10:03:42',NULL),('2025-11-28 10:03:42','2025-11-28 10:03:42','2025-11-28 10:03:42',1,14,'3645a8de-c8e6-4695-955f-e7f03e113705',2,'115c143e37394d77b81665435ce51c10','volumes',-1,'2025-11-29 10:03:42',NULL),('2025-11-28 10:03:42','2025-11-28 10:03:42','2025-11-28 10:03:42',1,15,'d7c1e5e1-aaf7-4acd-b354-b5d0b13d8e9b',3,'115c143e37394d77b81665435ce51c10','gigabytes',-1,'2025-11-29 10:03:42',NULL),('2025-11-28 10:03:42','2025-11-28 10:03:42','2025-11-28 10:03:42',1,16,'d2725920-42af-4b3d-ae22-5683689c7ba9',4,'115c143e37394d77b81665435ce51c10','volumes_tempest-GroupSnapshotsTest-volume-type-1857876428',-1,'2025-11-29 10:03:42',NULL),('2025-11-28 10:03:42','2025-11-28 10:03:42','2025-11-28 10:03:42',1,17,'03fb5f68-09ba-43b7-b0d1-c80be5335b99',5,'115c143e37394d77b81665435ce51c10','gigabytes_tempest-GroupSnapshotsTest-volume-type-1857876428',-1,'2025-11-29 10:03:42',NULL),('2025-11-28 10:03:45','2025-11-28 10:03:45','2025-11-28 10:03:45',1,18,'336dde4c-2f82-4b53-9a4e-8de093af4162',6,'115c143e37394d77b81665435ce51c10','snapshots',-1,'2025-11-29 10:03:45',NULL),('2025-11-28 10:03:45','2025-11-28 10:03:45','2025-11-28 10:03:45',1,19,'7d7130e9-8803-45e1-941a-bcd32d983606',3,'115c143e37394d77b81665435ce51c10','gigabytes',-1,'2025-11-29 10:03:45',NULL),('2025-11-28 10:03:45','2025-11-28 10:03:45','2025-11-28 10:03:45',1,20,'93c28389-50c9-4c72-b4aa-d9ada7b67c69',5,'115c143e37394d77b81665435ce51c10','gigabytes_tempest-GroupSnapshotsTest-volume-type-1857876428',-1,'2025-11-29 10:03:45',NULL),('2025-11-28 10:03:45','2025-11-28 10:03:45','2025-11-28 10:03:45',1,21,'f36a18f1-ee3a-42b4-ae2d-a0630efaf0ab',7,'115c143e37394d77b81665435ce51c10','snapshots_tempest-GroupSnapshotsTest-volume-type-1857876428',-1,'2025-11-29 10:03:45',NULL),('2025-11-28 10:03:46','2025-11-28 10:03:46','2025-11-28 10:03:46',1,22,'06ec6023-0829-472e-b26e-eb422296a4fd',1,'115c143e37394d77b81665435ce51c10','groups',-1,'2025-11-29 10:03:46',NULL),('2025-11-28 10:03:46','2025-11-28 10:03:46','2025-11-28 10:03:46',1,23,'7a9b3b11-cf4e-4c61-8fac-88fd81e3f398',2,'115c143e37394d77b81665435ce51c10','volumes',-1,'2025-11-29 10:03:46',NULL),('2025-11-28 10:03:46','2025-11-28 10:03:46','2025-11-28 10:03:46',1,24,'b9781378-3bea-4790-bdfa-d91c8e265d11',3,'115c143e37394d77b81665435ce51c10','gigabytes',-1,'2025-11-29 10:03:46',NULL),('2025-11-28 10:03:46','2025-11-28 10:03:46','2025-11-28 10:03:46',1,25,'29ce1eff-c80d-4d1e-8e8a-667a7e3ec7d1',4,'115c143e37394d77b81665435ce51c10','volumes_tempest-GroupSnapshotsTest-volume-type-1857876428',-1,'2025-11-29 10:03:46',NULL),('2025-11-28 10:03:46','2025-11-28 10:03:46','2025-11-28 10:03:46',1,26,'61b3ad4d-9cf1-4994-9430-c9d0186ccca5',5,'115c143e37394d77b81665435ce51c10','gigabytes_tempest-GroupSnapshotsTest-volume-type-1857876428',-1,'2025-11-29 10:03:46',NULL),('2025-11-28 10:03:47','2025-11-28 10:03:47','2025-11-28 10:03:47',1,27,'f4ae72d5-0491-4c9b-817a-78e39c495480',1,'115c143e37394d77b81665435ce51c10','groups',1,'2025-11-29 10:03:47',NULL),('2025-11-28 10:03:49','2025-11-28 10:03:49','2025-11-28 10:03:49',1,28,'921e8c82-0a62-41bf-8391-787a6c4108b1',2,'115c143e37394d77b81665435ce51c10','volumes',1,'2025-11-29 10:03:49',NULL),('2025-11-28 10:03:49','2025-11-28 10:03:49','2025-11-28 10:03:49',1,29,'e97b6650-ea26-4fdc-9283-8b04ca5f6b10',3,'115c143e37394d77b81665435ce51c10','gigabytes',1,'2025-11-29 10:03:49',NULL),('2025-11-28 10:03:49','2025-11-28 10:03:49','2025-11-28 10:03:49',1,30,'0db32819-6a2f-44ae-b18c-b4182ea0bb4e',8,'115c143e37394d77b81665435ce51c10','volumes_tempest-GroupSnapshotsTest-volume-type-835004530',1,'2025-11-29 10:03:49',NULL),('2025-11-28 10:03:49','2025-11-28 10:03:49','2025-11-28 10:03:49',1,31,'98f2bb5e-b8cf-41d6-b844-f5004da6eec8',9,'115c143e37394d77b81665435ce51c10','gigabytes_tempest-GroupSnapshotsTest-volume-type-835004530',1,'2025-11-29 10:03:49',NULL),('2025-11-28 10:03:50','2025-11-28 10:03:50','2025-11-28 10:03:50',1,32,'ec747e1b-9104-4885-99c2-acea674284cd',2,'115c143e37394d77b81665435ce51c10','volumes',1,'2025-11-29 10:03:50',NULL),('2025-11-28 10:03:50','2025-11-28 10:03:50','2025-11-28 10:03:50',1,33,'8b23d696-1db4-402d-b079-3a69611b16a0',3,'115c143e37394d77b81665435ce51c10','gigabytes',1,'2025-11-29 10:03:50',NULL),('2025-11-28 10:03:50','2025-11-28 10:03:50','2025-11-28 10:03:50',1,34,'1bf0d3ad-271b-4897-a46f-53fce8a15db5',8,'115c143e37394d77b81665435ce51c10','volumes_tempest-GroupSnapshotsTest-volume-type-835004530',1,'2025-11-29 10:03:50',NULL),('2025-11-28 10:03:50','2025-11-28 10:03:50','2025-11-28 10:03:50',1,35,'27805c72-bf19-4d52-82fc-fa1162354f38',9,'115c143e37394d77b81665435ce51c10','gigabytes_tempest-GroupSnapshotsTest-volume-type-835004530',1,'2025-11-29 10:03:50',NULL),('2025-11-28 10:03:56','2025-11-28 10:03:56','2025-11-28 10:03:56',1,36,'da81b348-2f57-49a4-87da-e509d65e2814',6,'115c143e37394d77b81665435ce51c10','snapshots',2,'2025-11-29 10:03:56',NULL),('2025-11-28 10:03:56','2025-11-28 10:03:56','2025-11-28 10:03:56',1,37,'cf028632-916f-47cb-bd27-f9bc4502102d',3,'115c143e37394d77b81665435ce51c10','gigabytes',2,'2025-11-29 10:03:56',NULL),('2025-11-28 10:03:56','2025-11-28 10:03:56','2025-11-28 10:03:56',1,38,'81ef4aa2-7f09-463d-b23f-e89aa6c03229',9,'115c143e37394d77b81665435ce51c10','gigabytes_tempest-GroupSnapshotsTest-volume-type-835004530',2,'2025-11-29 10:03:56',NULL),('2025-11-28 10:03:56','2025-11-28 10:03:56','2025-11-28 10:03:56',1,39,'d6ce9d63-427b-4d90-b22f-ef72c27bc10b',10,'115c143e37394d77b81665435ce51c10','snapshots_tempest-GroupSnapshotsTest-volume-type-835004530',2,'2025-11-29 10:03:56',NULL),('2025-11-28 10:04:01','2025-11-28 10:04:01','2025-11-28 10:04:01',1,40,'1f0fd510-ab0e-4a2d-953c-fd811450ca52',6,'115c143e37394d77b81665435ce51c10','snapshots',-1,'2025-11-29 10:04:01',NULL),('2025-11-28 10:04:01','2025-11-28 10:04:01','2025-11-28 10:04:01',1,41,'5ef2430d-2676-4fe6-b211-2a1465037501',3,'115c143e37394d77b81665435ce51c10','gigabytes',-1,'2025-11-29 10:04:01',NULL),('2025-11-28 10:04:01','2025-11-28 10:04:01','2025-11-28 10:04:01',1,42,'9a87cd11-3760-4fb4-bf63-83f14be91bcb',9,'115c143e37394d77b81665435ce51c10','gigabytes_tempest-GroupSnapshotsTest-volume-type-835004530',-1,'2025-11-29 10:04:01',NULL),('2025-11-28 10:04:01','2025-11-28 10:04:01','2025-11-28 10:04:01',1,43,'5cb74ca6-dee0-4034-8069-cd80aea5cfca',10,'115c143e37394d77b81665435ce51c10','snapshots_tempest-GroupSnapshotsTest-volume-type-835004530',-1,'2025-11-29 10:04:01',NULL),('2025-11-28 10:04:01','2025-11-28 10:04:01','2025-11-28 10:04:01',1,44,'1210783b-c3de-4b38-9d5e-2c5f19557c59',6,'115c143e37394d77b81665435ce51c10','snapshots',-1,'2025-11-29 10:04:01',NULL),('2025-11-28 10:04:01','2025-11-28 10:04:01','2025-11-28 10:04:01',1,45,'351f50d1-8789-47c7-b229-f1c2b51d1065',3,'115c143e37394d77b81665435ce51c10','gigabytes',-1,'2025-11-29 10:04:01',NULL),('2025-11-28 10:04:01','2025-11-28 10:04:01','2025-11-28 10:04:01',1,46,'1153478f-0fb9-45d3-b03a-c0b9cff51cf6',9,'115c143e37394d77b81665435ce51c10','gigabytes_tempest-GroupSnapshotsTest-volume-type-835004530',-1,'2025-11-29 10:04:01',NULL),('2025-11-28 10:04:01','2025-11-28 10:04:01','2025-11-28 10:04:01',1,47,'fbe12336-b971-4079-9f15-ce3fb4be09be',10,'115c143e37394d77b81665435ce51c10','snapshots_tempest-GroupSnapshotsTest-volume-type-835004530',-1,'2025-11-29 10:04:01',NULL),('2025-11-28 10:04:03','2025-11-28 10:04:03','2025-11-28 10:04:03',1,48,'bad3e30e-73d3-4155-b623-fb91abd1e23d',1,'115c143e37394d77b81665435ce51c10','groups',-1,'2025-11-29 10:04:03',NULL),('2025-11-28 10:04:03','2025-11-28 10:04:03','2025-11-28 10:04:03',1,49,'e486fab5-a4ea-47f9-a2c1-bcfc107d0d44',2,'115c143e37394d77b81665435ce51c10','volumes',-1,'2025-11-29 10:04:03',NULL),('2025-11-28 10:04:03','2025-11-28 10:04:03','2025-11-28 10:04:03',1,50,'ff193544-d54f-4466-bfcd-e509d5fc47de',3,'115c143e37394d77b81665435ce51c10','gigabytes',-1,'2025-11-29 10:04:03',NULL),('2025-11-28 10:04:03','2025-11-28 10:04:03','2025-11-28 10:04:03',1,51,'a5e17183-e69b-45ae-9f03-d6058c233e81',8,'115c143e37394d77b81665435ce51c10','volumes_tempest-GroupSnapshotsTest-volume-type-835004530',-1,'2025-11-29 10:04:03',NULL),('2025-11-28 10:04:03','2025-11-28 10:04:03','2025-11-28 10:04:03',1,52,'d4749772-cf54-4e31-9a25-388c08e18630',9,'115c143e37394d77b81665435ce51c10','gigabytes_tempest-GroupSnapshotsTest-volume-type-835004530',-1,'2025-11-29 10:04:03',NULL),('2025-11-28 10:04:03','2025-11-28 10:04:03','2025-11-28 10:04:03',1,53,'336aeab5-fabf-41a8-8780-f80d3fea17cc',2,'115c143e37394d77b81665435ce51c10','volumes',-1,'2025-11-29 10:04:03',NULL),('2025-11-28 10:04:03','2025-11-28 10:04:03','2025-11-28 10:04:03',1,54,'64daf86f-1dd4-44ed-9a4d-5fba852a03e6',3,'115c143e37394d77b81665435ce51c10','gigabytes',-1,'2025-11-29 10:04:03',NULL),('2025-11-28 10:04:03','2025-11-28 10:04:03','2025-11-28 10:04:03',1,55,'9f598907-c5e3-424e-ab40-84d172852c5b',8,'115c143e37394d77b81665435ce51c10','volumes_tempest-GroupSnapshotsTest-volume-type-835004530',-1,'2025-11-29 10:04:03',NULL),('2025-11-28 10:04:03','2025-11-28 10:04:03','2025-11-28 10:04:03',1,56,'7df07c82-5849-439c-8081-8c2fedd5ae44',9,'115c143e37394d77b81665435ce51c10','gigabytes_tempest-GroupSnapshotsTest-volume-type-835004530',-1,'2025-11-29 10:04:03',NULL),('2025-11-28 10:04:04','2025-11-28 10:04:04','2025-11-28 10:04:04',1,57,'8e9d51ab-3903-4d40-b9cb-c5e87aa55b68',1,'115c143e37394d77b81665435ce51c10','groups',1,'2025-11-29 10:04:04',NULL),('2025-11-28 10:04:05','2025-11-28 10:04:05','2025-11-28 10:04:05',1,58,'af7ccc90-16f6-4a63-a221-4428fe6b07f1',2,'115c143e37394d77b81665435ce51c10','volumes',1,'2025-11-29 10:04:05',NULL),('2025-11-28 10:04:05','2025-11-28 10:04:05','2025-11-28 10:04:05',1,59,'2022f432-3dc7-4b3a-af5a-8b2404644828',3,'115c143e37394d77b81665435ce51c10','gigabytes',1,'2025-11-29 10:04:05',NULL),('2025-11-28 10:04:05','2025-11-28 10:04:05','2025-11-28 10:04:05',1,60,'ca891888-6fb6-47b4-95d2-5d8c95a2e283',11,'115c143e37394d77b81665435ce51c10','volumes_tempest-GroupSnapshotsTest-volume-type-807881257',1,'2025-11-29 10:04:05',NULL),('2025-11-28 10:04:05','2025-11-28 10:04:05','2025-11-28 10:04:05',1,61,'8a954c40-fc22-4ea3-b473-02b2f14bab2d',12,'115c143e37394d77b81665435ce51c10','gigabytes_tempest-GroupSnapshotsTest-volume-type-807881257',1,'2025-11-29 10:04:05',NULL),('2025-11-28 10:04:07','2025-11-28 10:04:07','2025-11-28 10:04:07',1,62,'42c7cbb5-fc19-46f0-a358-fb37750dabfd',6,'115c143e37394d77b81665435ce51c10','snapshots',1,'2025-11-29 10:04:07',NULL),('2025-11-28 10:04:07','2025-11-28 10:04:07','2025-11-28 10:04:07',1,63,'dcd615aa-26ce-4d92-aa3f-8b73bef73873',3,'115c143e37394d77b81665435ce51c10','gigabytes',1,'2025-11-29 10:04:07',NULL),('2025-11-28 10:04:07','2025-11-28 10:04:07','2025-11-28 10:04:07',1,64,'653d3b10-c542-4126-be9f-dbbadafec8e7',12,'115c143e37394d77b81665435ce51c10','gigabytes_tempest-GroupSnapshotsTest-volume-type-807881257',1,'2025-11-29 10:04:07',NULL),('2025-11-28 10:04:07','2025-11-28 10:04:07','2025-11-28 10:04:07',1,65,'2521d23d-cdc8-4feb-bf77-12a9791ab118',13,'115c143e37394d77b81665435ce51c10','snapshots_tempest-GroupSnapshotsTest-volume-type-807881257',1,'2025-11-29 10:04:07',NULL),('2025-11-28 10:04:09','2025-11-28 10:04:09','2025-11-28 10:04:09',1,66,'7d4936e2-3051-467a-9107-c2c0b681a288',6,'115c143e37394d77b81665435ce51c10','snapshots',-1,'2025-11-29 10:04:09',NULL),('2025-11-28 10:04:09','2025-11-28 10:04:09','2025-11-28 10:04:09',1,67,'f13b577f-1e8b-4164-a6b8-18f1cb0a0976',3,'115c143e37394d77b81665435ce51c10','gigabytes',-1,'2025-11-29 10:04:09',NULL),('2025-11-28 10:04:09','2025-11-28 10:04:09','2025-11-28 10:04:09',1,68,'44b5bb90-d4b9-4fc7-ac14-39aa13bba255',12,'115c143e37394d77b81665435ce51c10','gigabytes_tempest-GroupSnapshotsTest-volume-type-807881257',-1,'2025-11-29 10:04:09',NULL),('2025-11-28 10:04:09','2025-11-28 10:04:09','2025-11-28 10:04:09',1,69,'414b1c93-d130-4881-b2af-d20baaea3e91',13,'115c143e37394d77b81665435ce51c10','snapshots_tempest-GroupSnapshotsTest-volume-type-807881257',-1,'2025-11-29 10:04:09',NULL),('2025-11-28 10:04:10','2025-11-28 10:04:10','2025-11-28 10:04:10',1,70,'befe3e01-b2b3-4c1a-9579-00898bf0c58a',1,'115c143e37394d77b81665435ce51c10','groups',-1,'2025-11-29 10:04:10',NULL),('2025-11-28 10:04:10','2025-11-28 10:04:10','2025-11-28 10:04:10',1,71,'51c1c98c-2540-4a6a-a901-bcf284d8709e',2,'115c143e37394d77b81665435ce51c10','volumes',-1,'2025-11-29 10:04:10',NULL),('2025-11-28 10:04:10','2025-11-28 10:04:10','2025-11-28 10:04:10',1,72,'da537f94-797c-44f1-af26-ae4761213afb',3,'115c143e37394d77b81665435ce51c10','gigabytes',-1,'2025-11-29 10:04:10',NULL),('2025-11-28 10:04:10','2025-11-28 10:04:10','2025-11-28 10:04:10',1,73,'d25a015d-b38e-4714-a829-268f8d288d04',11,'115c143e37394d77b81665435ce51c10','volumes_tempest-GroupSnapshotsTest-volume-type-807881257',-1,'2025-11-29 10:04:10',NULL),('2025-11-28 10:04:10','2025-11-28 10:04:10','2025-11-28 10:04:10',1,74,'248e88a4-5eb2-4884-8906-06288f5e42f7',12,'115c143e37394d77b81665435ce51c10','gigabytes_tempest-GroupSnapshotsTest-volume-type-807881257',-1,'2025-11-29 10:04:10',NULL),('2025-11-28 10:04:27','2025-11-28 10:04:27','2025-11-28 10:04:27',1,75,'11b4456f-a3d3-4e0f-846d-61e056ac35bb',14,'70de67fe9f1d43a793c239829fcd6ef2','volumes',1,'2025-11-29 10:04:27',NULL),('2025-11-28 10:04:27','2025-11-28 10:04:27','2025-11-28 10:04:27',1,76,'0df5d7a6-644b-4c49-8660-872b83b000d7',15,'70de67fe9f1d43a793c239829fcd6ef2','gigabytes',1,'2025-11-29 10:04:27',NULL),('2025-11-28 10:04:27','2025-11-28 10:04:27','2025-11-28 10:04:27',1,77,'822c4338-8981-4a05-8fb4-1715601aee23',16,'70de67fe9f1d43a793c239829fcd6ef2','volumes_tempest-VolumeTypesAccessTest-volume-type-1038300301',1,'2025-11-29 10:04:27',NULL),('2025-11-28 10:04:27','2025-11-28 10:04:27','2025-11-28 10:04:27',1,78,'6ab32b3f-3665-4dcf-b86b-86196498bc80',17,'70de67fe9f1d43a793c239829fcd6ef2','gigabytes_tempest-VolumeTypesAccessTest-volume-type-1038300301',1,'2025-11-29 10:04:27',NULL),('2025-11-28 10:04:29','2025-11-28 10:04:29','2025-11-28 10:04:29',1,79,'78848256-b87f-44bd-86f4-b2f72a47d5fb',14,'70de67fe9f1d43a793c239829fcd6ef2','volumes',-1,'2025-11-29 10:04:29',NULL),('2025-11-28 10:04:29','2025-11-28 10:04:29','2025-11-28 10:04:29',1,80,'1d0d01f6-b055-42ef-94cd-4049cc686fe2',15,'70de67fe9f1d43a793c239829fcd6ef2','gigabytes',-1,'2025-11-29 10:04:29',NULL),('2025-11-28 10:04:29','2025-11-28 10:04:29','2025-11-28 10:04:29',1,81,'1c6233d9-2a7f-4218-af63-6c23661d9e97',16,'70de67fe9f1d43a793c239829fcd6ef2','volumes_tempest-VolumeTypesAccessTest-volume-type-1038300301',-1,'2025-11-29 10:04:29',NULL),('2025-11-28 10:04:29','2025-11-28 10:04:29','2025-11-28 10:04:29',1,82,'ee6f55de-af88-406f-8d5a-c928757fe514',17,'70de67fe9f1d43a793c239829fcd6ef2','gigabytes_tempest-VolumeTypesAccessTest-volume-type-1038300301',-1,'2025-11-29 10:04:29',NULL),('2025-11-28 10:05:19','2025-11-28 10:05:19','2025-11-28 10:05:19',1,83,'885a310a-d6b7-4262-8cbc-fd2f88f35553',18,'aa5be61eafca4d96976422f0e0103210','volumes',1,'2025-11-29 10:05:19',NULL),('2025-11-28 10:05:19','2025-11-28 10:05:19','2025-11-28 10:05:19',1,84,'bd764420-b5da-4aca-8c10-3103dd930358',19,'aa5be61eafca4d96976422f0e0103210','gigabytes',1,'2025-11-29 10:05:19',NULL),('2025-11-28 10:05:19','2025-11-28 10:05:19','2025-11-28 10:05:19',1,85,'1b7025ff-340a-4b75-8d20-be1105597c4a',20,'aa5be61eafca4d96976422f0e0103210','volumes_tripleo',1,'2025-11-29 10:05:19',NULL),('2025-11-28 10:05:19','2025-11-28 10:05:19','2025-11-28 10:05:19',1,86,'04b602f7-c02c-4e3a-be92-6b7053aa8ce6',21,'aa5be61eafca4d96976422f0e0103210','gigabytes_tripleo',1,'2025-11-29 10:05:19',NULL),('2025-11-28 10:05:21','2025-11-28 10:05:21','2025-11-28 10:05:21',1,87,'0e192ebf-30b0-41eb-bf4f-009738c13c7f',18,'aa5be61eafca4d96976422f0e0103210','volumes',-1,'2025-11-29 10:05:21',NULL),('2025-11-28 10:05:21','2025-11-28 10:05:21','2025-11-28 10:05:21',1,88,'b6be300d-e13b-4f86-b924-d2cd125cd4cc',19,'aa5be61eafca4d96976422f0e0103210','gigabytes',-1,'2025-11-29 10:05:21',NULL),('2025-11-28 10:05:21','2025-11-28 10:05:21','2025-11-28 10:05:21',1,89,'f3c8b978-91cb-4e8a-92e9-b88ec88606a1',20,'aa5be61eafca4d96976422f0e0103210','volumes_tripleo',-1,'2025-11-29 10:05:21',NULL),('2025-11-28 10:05:21','2025-11-28 10:05:21','2025-11-28 10:05:21',1,90,'d2af6af2-0012-4747-9bac-55fe063628d4',21,'aa5be61eafca4d96976422f0e0103210','gigabytes_tripleo',-1,'2025-11-29 10:05:21',NULL),('2025-11-28 10:05:22','2025-11-28 10:05:22','2025-11-28 10:05:22',1,91,'ceb8953e-f269-4eb9-8f4b-c3851d394e33',18,'aa5be61eafca4d96976422f0e0103210','volumes',1,'2025-11-29 10:05:22',NULL),('2025-11-28 10:05:22','2025-11-28 10:05:22','2025-11-28 10:05:22',1,92,'13a66da2-bb42-4d80-8c4a-36c0cadf1410',19,'aa5be61eafca4d96976422f0e0103210','gigabytes',1,'2025-11-29 10:05:22',NULL),('2025-11-28 10:05:22','2025-11-28 10:05:22','2025-11-28 10:05:22',1,93,'590819a4-4116-4e78-b811-d9dc1e1bc63e',20,'aa5be61eafca4d96976422f0e0103210','volumes_tripleo',1,'2025-11-29 10:05:22',NULL),('2025-11-28 10:05:22','2025-11-28 10:05:22','2025-11-28 10:05:22',1,94,'8cfafd36-137c-4d84-9691-7c14621f4ea0',21,'aa5be61eafca4d96976422f0e0103210','gigabytes_tripleo',1,'2025-11-29 10:05:22',NULL),('2025-11-28 10:05:24','2025-11-28 10:05:24','2025-11-28 10:05:24',1,95,'73a3db59-3f51-4b19-a793-566cfaf02e2a',18,'aa5be61eafca4d96976422f0e0103210','volumes',-1,'2025-11-29 10:05:24',NULL),('2025-11-28 10:05:24','2025-11-28 10:05:24','2025-11-28 10:05:24',1,96,'9db50072-951f-4e71-b9a0-71a448130527',19,'aa5be61eafca4d96976422f0e0103210','gigabytes',-1,'2025-11-29 10:05:24',NULL),('2025-11-28 10:05:24','2025-11-28 10:05:24','2025-11-28 10:05:24',1,97,'9414e3c5-4685-4ec4-a51b-e80649d8761b',20,'aa5be61eafca4d96976422f0e0103210','volumes_tripleo',-1,'2025-11-29 10:05:24',NULL),('2025-11-28 10:05:24','2025-11-28 10:05:24','2025-11-28 10:05:24',1,98,'c9592642-1823-43e0-88e8-72987476f44c',21,'aa5be61eafca4d96976422f0e0103210','gigabytes_tripleo',-1,'2025-11-29 10:05:24',NULL),('2025-11-28 10:05:24','2025-11-28 10:05:25','2025-11-28 10:05:25',1,99,'7ec8d563-807b-40d8-88bd-5cae3b21c79e',18,'aa5be61eafca4d96976422f0e0103210','volumes',1,'2025-11-29 10:05:24',NULL),('2025-11-28 10:05:24','2025-11-28 10:05:25','2025-11-28 10:05:25',1,100,'b9492827-123f-492e-90bd-442b564f007f',19,'aa5be61eafca4d96976422f0e0103210','gigabytes',1,'2025-11-29 10:05:24',NULL),('2025-11-28 10:05:24','2025-11-28 10:05:25','2025-11-28 10:05:25',1,101,'3a8adbb3-ff7b-42ee-8312-635cfea81434',20,'aa5be61eafca4d96976422f0e0103210','volumes_tripleo',1,'2025-11-29 10:05:24',NULL),('2025-11-28 10:05:24','2025-11-28 10:05:25','2025-11-28 10:05:24',1,102,'20aba1ae-704e-4fa9-abdf-d7c398466a9f',21,'aa5be61eafca4d96976422f0e0103210','gigabytes_tripleo',1,'2025-11-29 10:05:24',NULL),('2025-11-28 10:05:26','2025-11-28 10:05:26','2025-11-28 10:05:26',1,103,'9d095f8b-7cb3-4b4f-86bb-04ee4f2aad94',18,'aa5be61eafca4d96976422f0e0103210','volumes',-1,'2025-11-29 10:05:26',NULL),('2025-11-28 10:05:26','2025-11-28 10:05:26','2025-11-28 10:05:26',1,104,'86257ce4-b615-4410-b4dc-08c74da50909',19,'aa5be61eafca4d96976422f0e0103210','gigabytes',-1,'2025-11-29 10:05:26',NULL),('2025-11-28 10:05:26','2025-11-28 10:05:26','2025-11-28 10:05:26',1,105,'dbd683a5-7451-4199-ad95-157c207054f4',20,'aa5be61eafca4d96976422f0e0103210','volumes_tripleo',-1,'2025-11-29 10:05:26',NULL),('2025-11-28 10:05:26','2025-11-28 10:05:26','2025-11-28 10:05:26',1,106,'1aab3113-b462-45d5-b5ae-54379396d82b',21,'aa5be61eafca4d96976422f0e0103210','gigabytes_tripleo',-1,'2025-11-29 10:05:26',NULL),('2025-11-28 10:05:27','2025-11-28 10:05:27','2025-11-28 10:05:27',1,107,'9e5ec95a-d90b-4d88-b613-4b117e2e33ea',18,'aa5be61eafca4d96976422f0e0103210','volumes',1,'2025-11-29 10:05:27',NULL),('2025-11-28 10:05:27','2025-11-28 10:05:27','2025-11-28 10:05:27',1,108,'6a069bfb-b0f7-47ff-9a79-9ce89fabb583',19,'aa5be61eafca4d96976422f0e0103210','gigabytes',1,'2025-11-29 10:05:27',NULL),('2025-11-28 10:05:27','2025-11-28 10:05:27','2025-11-28 10:05:27',1,109,'406430c3-88ad-495e-9217-c3dafb255a15',20,'aa5be61eafca4d96976422f0e0103210','volumes_tripleo',1,'2025-11-29 10:05:27',NULL),('2025-11-28 10:05:27','2025-11-28 10:05:27','2025-11-28 10:05:27',1,110,'0f1c67fb-113a-42e5-af80-f0eff5fc103b',21,'aa5be61eafca4d96976422f0e0103210','gigabytes_tripleo',1,'2025-11-29 10:05:27',NULL),('2025-11-28 10:05:29','2025-11-28 10:05:29','2025-11-28 10:05:29',1,111,'91d25c40-8732-48ee-b367-926a495bc60e',18,'aa5be61eafca4d96976422f0e0103210','volumes',-1,'2025-11-29 10:05:29',NULL),('2025-11-28 10:05:29','2025-11-28 10:05:29','2025-11-28 10:05:29',1,112,'0cfea9d1-c10f-4f01-8a31-f37f2da9dd20',19,'aa5be61eafca4d96976422f0e0103210','gigabytes',-1,'2025-11-29 10:05:29',NULL),('2025-11-28 10:05:29','2025-11-28 10:05:29','2025-11-28 10:05:29',1,113,'37418b2d-b355-4bbc-b096-c36862a2f913',20,'aa5be61eafca4d96976422f0e0103210','volumes_tripleo',-1,'2025-11-29 10:05:29',NULL),('2025-11-28 10:05:29','2025-11-28 10:05:29','2025-11-28 10:05:29',1,114,'013b5c4c-af0a-487d-b210-75f00464940f',21,'aa5be61eafca4d96976422f0e0103210','gigabytes_tripleo',-1,'2025-11-29 10:05:29',NULL),('2025-11-28 10:05:29','2025-11-28 10:05:29','2025-11-28 10:05:29',1,115,'44b12358-4f58-471c-aa3d-95c270c0c774',22,'cc1fbd7319614f7ab4566dfed25610b8','volumes',1,'2025-11-29 10:05:29',NULL),('2025-11-28 10:05:29','2025-11-28 10:05:29','2025-11-28 10:05:29',1,116,'2bf7723c-41d7-4d0b-a4df-665e716b715d',23,'cc1fbd7319614f7ab4566dfed25610b8','gigabytes',1,'2025-11-29 10:05:29',NULL),('2025-11-28 10:05:29','2025-11-28 10:05:29','2025-11-28 10:05:29',1,117,'e5091e72-dc42-4207-9407-779a88aabd0f',24,'cc1fbd7319614f7ab4566dfed25610b8','volumes_volume-type-1',1,'2025-11-29 10:05:29',NULL),('2025-11-28 10:05:29','2025-11-28 10:05:29','2025-11-28 10:05:29',1,118,'6d7a2aa3-a0c0-4661-a105-ea4ab9200301',25,'cc1fbd7319614f7ab4566dfed25610b8','gigabytes_volume-type-1',1,'2025-11-29 10:05:29',NULL),('2025-11-28 10:05:30','2025-11-28 10:05:30','2025-11-28 10:05:30',1,119,'07a26102-43ff-4f0e-a1e7-0c189237a07a',18,'aa5be61eafca4d96976422f0e0103210','volumes',1,'2025-11-29 10:05:30',NULL),('2025-11-28 10:05:30','2025-11-28 10:05:30','2025-11-28 10:05:30',1,120,'c047f225-cc0a-4460-9cde-a40a2bcabcdc',19,'aa5be61eafca4d96976422f0e0103210','gigabytes',1,'2025-11-29 10:05:30',NULL),('2025-11-28 10:05:30','2025-11-28 10:05:30','2025-11-28 10:05:30',1,121,'c6752397-8a19-4162-8220-4e3cd6a18483',20,'aa5be61eafca4d96976422f0e0103210','volumes_tripleo',1,'2025-11-29 10:05:30',NULL),('2025-11-28 10:05:30','2025-11-28 10:05:30','2025-11-28 10:05:30',1,122,'8463d9a7-bbee-4f75-b061-dfce9afbc924',21,'aa5be61eafca4d96976422f0e0103210','gigabytes_tripleo',1,'2025-11-29 10:05:30',NULL),('2025-11-28 10:05:31','2025-11-28 10:05:31','2025-11-28 10:05:31',1,123,'98822344-f047-4797-8c1a-2a3a4aee748a',26,'cc1fbd7319614f7ab4566dfed25610b8','volumes_volume-type-2',1,'2025-11-29 10:05:31',NULL),('2025-11-28 10:05:31','2025-11-28 10:05:31','2025-11-28 10:05:31',1,124,'91973104-ad47-4c77-875b-785057307e1c',27,'cc1fbd7319614f7ab4566dfed25610b8','gigabytes_volume-type-2',1,'2025-11-29 10:05:31',NULL),('2025-11-28 10:05:31','2025-11-28 10:05:31','2025-11-28 10:05:31',1,125,'721b3612-6cc5-4922-9ddf-1ea7323407aa',24,'cc1fbd7319614f7ab4566dfed25610b8','volumes_volume-type-1',-1,'2025-11-29 10:05:31',NULL),('2025-11-28 10:05:31','2025-11-28 10:05:31','2025-11-28 10:05:31',1,126,'8b09eb5d-6f32-4931-b65e-59520efda580',25,'cc1fbd7319614f7ab4566dfed25610b8','gigabytes_volume-type-1',-1,'2025-11-29 10:05:31',NULL),('2025-11-28 10:05:32','2025-11-28 10:05:32','2025-11-28 10:05:32',1,127,'be4933bf-97ad-47d5-b796-01b412f6ddc2',28,'5c1cc8bd04e04964bf55c27886efbf5c','groups',1,'2025-11-29 10:05:32',NULL),('2025-11-28 10:05:32','2025-11-28 10:05:32','2025-11-28 10:05:32',1,128,'878cea77-39f6-4d73-8698-f36198cc5e6d',18,'aa5be61eafca4d96976422f0e0103210','volumes',-1,'2025-11-29 10:05:32',NULL),('2025-11-28 10:05:32','2025-11-28 10:05:32','2025-11-28 10:05:32',1,129,'b12fcb73-4b5b-404d-8aaf-c9bb108bc754',19,'aa5be61eafca4d96976422f0e0103210','gigabytes',-1,'2025-11-29 10:05:32',NULL),('2025-11-28 10:05:32','2025-11-28 10:05:32','2025-11-28 10:05:32',1,130,'225a4777-9273-4cf8-a3b5-48c41595209a',20,'aa5be61eafca4d96976422f0e0103210','volumes_tripleo',-1,'2025-11-29 10:05:32',NULL),('2025-11-28 10:05:32','2025-11-28 10:05:32','2025-11-28 10:05:32',1,131,'b81d8995-7bdc-4ec2-97c3-d69e8a679695',21,'aa5be61eafca4d96976422f0e0103210','gigabytes_tripleo',-1,'2025-11-29 10:05:32',NULL),('2025-11-28 10:05:32','2025-11-28 10:05:32','2025-11-28 10:05:32',1,132,'249c50bd-638d-49cc-b4f1-0a55451bd960',22,'cc1fbd7319614f7ab4566dfed25610b8','volumes',-1,'2025-11-29 10:05:32',NULL),('2025-11-28 10:05:32','2025-11-28 10:05:32','2025-11-28 10:05:32',1,133,'30809408-f9f3-482d-9114-9ef91baeccea',23,'cc1fbd7319614f7ab4566dfed25610b8','gigabytes',-1,'2025-11-29 10:05:32',NULL),('2025-11-28 10:05:32','2025-11-28 10:05:32','2025-11-28 10:05:32',1,134,'0eb8abc0-4351-4aeb-b0ea-8896834b34db',26,'cc1fbd7319614f7ab4566dfed25610b8','volumes_volume-type-2',-1,'2025-11-29 10:05:32',NULL),('2025-11-28 10:05:32','2025-11-28 10:05:32','2025-11-28 10:05:32',1,135,'dbb5df00-e9a8-4ba0-944b-73ee5627c602',27,'cc1fbd7319614f7ab4566dfed25610b8','gigabytes_volume-type-2',-1,'2025-11-29 10:05:32',NULL),('2025-11-28 10:05:33','2025-11-28 10:05:33','2025-11-28 10:05:33',1,136,'ee14a2db-f34f-4eeb-9afe-d576e4aae757',29,'5c1cc8bd04e04964bf55c27886efbf5c','volumes',1,'2025-11-29 10:05:33',NULL),('2025-11-28 10:05:33','2025-11-28 10:05:33','2025-11-28 10:05:33',1,137,'605e2432-192d-47e5-908c-4c1f5d1ddb14',30,'5c1cc8bd04e04964bf55c27886efbf5c','gigabytes',1,'2025-11-29 10:05:33',NULL),('2025-11-28 10:05:33','2025-11-28 10:05:33','2025-11-28 10:05:33',1,138,'97668591-bdf8-4deb-bfdd-c6a4e9b7ba31',31,'5c1cc8bd04e04964bf55c27886efbf5c','volumes_tempest-GroupsV314Test-volume-type-739357787',1,'2025-11-29 10:05:33',NULL),('2025-11-28 10:05:33','2025-11-28 10:05:33','2025-11-28 10:05:33',1,139,'8aea7f74-6c4a-4386-8e67-fbc71e80bc44',32,'5c1cc8bd04e04964bf55c27886efbf5c','gigabytes_tempest-GroupsV314Test-volume-type-739357787',1,'2025-11-29 10:05:33',NULL),('2025-11-28 10:05:34','2025-11-28 10:05:34','2025-11-28 10:05:34',1,140,'7d47ed98-18a2-4ea9-85c3-3894f22cd56f',28,'5c1cc8bd04e04964bf55c27886efbf5c','groups',1,'2025-11-29 10:05:34',NULL),('2025-11-28 10:05:34','2025-11-28 10:05:35','2025-11-28 10:05:35',1,141,'c90ac0a4-a8fc-43d7-8272-faa33f7c582f',29,'5c1cc8bd04e04964bf55c27886efbf5c','volumes',1,'2025-11-29 10:05:34',NULL),('2025-11-28 10:05:34','2025-11-28 10:05:34','2025-11-28 10:05:34',1,142,'7730e8a0-30de-4063-9c70-23f3f285246b',30,'5c1cc8bd04e04964bf55c27886efbf5c','gigabytes',1,'2025-11-29 10:05:34',NULL),('2025-11-28 10:05:34','2025-11-28 10:05:35','2025-11-28 10:05:35',1,143,'93e1661c-f86e-4a9e-ad97-73fecb636b43',31,'5c1cc8bd04e04964bf55c27886efbf5c','volumes_tempest-GroupsV314Test-volume-type-739357787',1,'2025-11-29 10:05:34',NULL),('2025-11-28 10:05:34','2025-11-28 10:05:34','2025-11-28 10:05:34',1,144,'3421c087-9cb1-4ccc-a1d8-04ec4c908e8a',32,'5c1cc8bd04e04964bf55c27886efbf5c','gigabytes_tempest-GroupsV314Test-volume-type-739357787',1,'2025-11-29 10:05:34',NULL),('2025-11-28 10:05:38','2025-11-28 10:05:38','2025-11-28 10:05:38',1,145,'2ac63bfe-fa4e-4e09-a25b-8620511ba5c8',28,'5c1cc8bd04e04964bf55c27886efbf5c','groups',-1,'2025-11-29 10:05:38',NULL),('2025-11-28 10:05:38','2025-11-28 10:05:38','2025-11-28 10:05:38',1,146,'e66d62c4-9f32-41b6-9137-f9d10da333c0',29,'5c1cc8bd04e04964bf55c27886efbf5c','volumes',-1,'2025-11-29 10:05:38',NULL),('2025-11-28 10:05:38','2025-11-28 10:05:38','2025-11-28 10:05:38',1,147,'d3207a86-e8e8-4fbe-a88e-018738dc336c',30,'5c1cc8bd04e04964bf55c27886efbf5c','gigabytes',-1,'2025-11-29 10:05:38',NULL),('2025-11-28 10:05:38','2025-11-28 10:05:38','2025-11-28 10:05:38',1,148,'a44b2aff-6a43-45c7-b2ea-b0f99211b935',31,'5c1cc8bd04e04964bf55c27886efbf5c','volumes_tempest-GroupsV314Test-volume-type-739357787',-1,'2025-11-29 10:05:38',NULL),('2025-11-28 10:05:38','2025-11-28 10:05:38','2025-11-28 10:05:38',1,149,'3a618afe-8798-417c-8337-7ba0752e506f',32,'5c1cc8bd04e04964bf55c27886efbf5c','gigabytes_tempest-GroupsV314Test-volume-type-739357787',-1,'2025-11-29 10:05:38',NULL),('2025-11-28 10:05:39','2025-11-28 10:05:39','2025-11-28 10:05:39',1,150,'083e7ccc-b03b-4929-bbdc-aab5e122c5b0',28,'5c1cc8bd04e04964bf55c27886efbf5c','groups',-1,'2025-11-29 10:05:39',NULL),('2025-11-28 10:05:39','2025-11-28 10:05:39','2025-11-28 10:05:39',1,151,'dab51e91-b09e-4717-a8cf-ca43ba184bfc',29,'5c1cc8bd04e04964bf55c27886efbf5c','volumes',-1,'2025-11-29 10:05:39',NULL),('2025-11-28 10:05:39','2025-11-28 10:05:39','2025-11-28 10:05:39',1,152,'7a63ec09-7d01-4e0f-b4a7-071f5fc0c18d',30,'5c1cc8bd04e04964bf55c27886efbf5c','gigabytes',-1,'2025-11-29 10:05:39',NULL),('2025-11-28 10:05:39','2025-11-28 10:05:39','2025-11-28 10:05:39',1,153,'a886c80d-6a71-4a02-b4b8-c6cb37f6faf3',31,'5c1cc8bd04e04964bf55c27886efbf5c','volumes_tempest-GroupsV314Test-volume-type-739357787',-1,'2025-11-29 10:05:39',NULL),('2025-11-28 10:05:39','2025-11-28 10:05:39','2025-11-28 10:05:39',1,154,'65c7e5e2-0520-431a-be0d-0782cd2cd8e8',32,'5c1cc8bd04e04964bf55c27886efbf5c','gigabytes_tempest-GroupsV314Test-volume-type-739357787',-1,'2025-11-29 10:05:39',NULL),('2025-11-28 10:05:45','2025-11-28 10:05:45','2025-11-28 10:05:45',1,155,'73b9dfc5-0250-42f7-81f6-82f6d8d9c4df',33,'ba7456648a0f43028832ef04ff1d03da','volumes',1,'2025-11-29 10:05:45',NULL),('2025-11-28 10:05:45','2025-11-28 10:05:45','2025-11-28 10:05:45',1,156,'91eb78c6-5b57-4da3-b3a0-f677db2264aa',34,'ba7456648a0f43028832ef04ff1d03da','gigabytes',1,'2025-11-29 10:05:45',NULL),('2025-11-28 10:05:45','2025-11-28 10:05:45','2025-11-28 10:05:45',1,157,'7d9a254a-ad55-4abb-8792-afa463154ff2',35,'ba7456648a0f43028832ef04ff1d03da','volumes_tripleo',1,'2025-11-29 10:05:45',NULL),('2025-11-28 10:05:45','2025-11-28 10:05:45','2025-11-28 10:05:45',1,158,'666a41d7-3670-4e50-99d8-dd88f7316f2e',36,'ba7456648a0f43028832ef04ff1d03da','gigabytes_tripleo',1,'2025-11-29 10:05:45',NULL),('2025-11-28 10:05:46','2025-11-28 10:05:46','2025-11-28 10:05:46',1,159,'43b260f4-c23b-413e-a927-7ebfed85f989',37,'ba7456648a0f43028832ef04ff1d03da','snapshots',1,'2025-11-29 10:05:46',NULL),('2025-11-28 10:05:46','2025-11-28 10:05:46','2025-11-28 10:05:46',1,160,'525a8e92-375c-45d3-8eac-671df5a04ff1',34,'ba7456648a0f43028832ef04ff1d03da','gigabytes',1,'2025-11-29 10:05:46',NULL),('2025-11-28 10:05:46','2025-11-28 10:05:46','2025-11-28 10:05:46',1,161,'5d45ec0c-ebda-4924-bdef-608d0ca77f6f',36,'ba7456648a0f43028832ef04ff1d03da','gigabytes_tripleo',1,'2025-11-29 10:05:46',NULL),('2025-11-28 10:05:46','2025-11-28 10:05:46','2025-11-28 10:05:46',1,162,'29a7fef4-9f6d-48ff-b78f-700887c6322b',38,'ba7456648a0f43028832ef04ff1d03da','snapshots_tripleo',1,'2025-11-29 10:05:46',NULL),('2025-11-28 10:05:49','2025-11-28 10:05:49','2025-11-28 10:05:49',1,163,'1259a2d0-1793-425e-9ea3-82add3f549a7',39,'38c774f4f3a34ba7822603fa362cd4c8','volumes',1,'2025-11-29 10:05:49',NULL),('2025-11-28 10:05:49','2025-11-28 10:05:49','2025-11-28 10:05:49',1,164,'97633a5c-8593-49db-ae92-529175cadecf',37,'ba7456648a0f43028832ef04ff1d03da','snapshots',-1,'2025-11-29 10:05:49',NULL),('2025-11-28 10:05:49','2025-11-28 10:05:49','2025-11-28 10:05:49',1,165,'6db32c87-c11c-4a6d-9bd0-d7822de9886a',34,'ba7456648a0f43028832ef04ff1d03da','gigabytes',-1,'2025-11-29 10:05:49',NULL),('2025-11-28 10:05:49','2025-11-28 10:05:49','2025-11-28 10:05:49',1,166,'399d208f-aedf-44f1-a251-aec88e6472ee',40,'38c774f4f3a34ba7822603fa362cd4c8','gigabytes',1,'2025-11-29 10:05:49',NULL),('2025-11-28 10:05:49','2025-11-28 10:05:49','2025-11-28 10:05:49',1,167,'1b41878c-9fb1-41f6-9ec4-f200683af429',36,'ba7456648a0f43028832ef04ff1d03da','gigabytes_tripleo',-1,'2025-11-29 10:05:49',NULL),('2025-11-28 10:05:49','2025-11-28 10:05:49','2025-11-28 10:05:49',1,168,'0ec89755-b454-4624-b18b-43da718cd3d9',38,'ba7456648a0f43028832ef04ff1d03da','snapshots_tripleo',-1,'2025-11-29 10:05:49',NULL),('2025-11-28 10:05:49','2025-11-28 10:05:49','2025-11-28 10:05:49',1,169,'72b29407-f553-4873-a285-34a23d3a8668',41,'38c774f4f3a34ba7822603fa362cd4c8','volumes_tripleo',1,'2025-11-29 10:05:49',NULL),('2025-11-28 10:05:49','2025-11-28 10:05:49','2025-11-28 10:05:49',1,170,'b3cc48d1-443d-4a05-bcc1-eb4df14b9316',42,'38c774f4f3a34ba7822603fa362cd4c8','gigabytes_tripleo',1,'2025-11-29 10:05:49',NULL),('2025-11-28 10:05:50','2025-11-28 10:05:51','2025-11-28 10:05:51',1,171,'dbb70463-50be-4af1-8e13-7cedaf29a13d',33,'ba7456648a0f43028832ef04ff1d03da','volumes',-1,'2025-11-29 10:05:50',NULL),('2025-11-28 10:05:50','2025-11-28 10:05:51','2025-11-28 10:05:51',1,172,'15ea6a74-73e7-42f2-9e74-44f7d87f776c',34,'ba7456648a0f43028832ef04ff1d03da','gigabytes',-1,'2025-11-29 10:05:50',NULL),('2025-11-28 10:05:50','2025-11-28 10:05:51','2025-11-28 10:05:51',1,173,'8d3981e2-504f-4a19-8b4e-eaadce8fc46a',35,'ba7456648a0f43028832ef04ff1d03da','volumes_tripleo',-1,'2025-11-29 10:05:50',NULL),('2025-11-28 10:05:50','2025-11-28 10:05:51','2025-11-28 10:05:51',1,174,'fa93da1b-e882-417b-9e30-a56ba7c49f39',36,'ba7456648a0f43028832ef04ff1d03da','gigabytes_tripleo',-1,'2025-11-29 10:05:50',NULL),('2025-11-28 10:05:55','2025-11-28 10:05:56','2025-11-28 10:05:56',1,175,'b57b75a9-e9f9-40e8-bc2e-aa9fe758810f',47,'16a57eec68224f4d9395015bb4c6714b','volumes',1,'2025-11-29 10:05:55',NULL),('2025-11-28 10:05:55','2025-11-28 10:05:56','2025-11-28 10:05:56',1,176,'d85adb56-eb1b-499e-8796-1fbbac3c0731',43,'d2d31a928b84446c97d35bb770c268e5','volumes',1,'2025-11-29 10:05:55',NULL),('2025-11-28 10:05:55','2025-11-28 10:05:56','2025-11-28 10:05:56',1,177,'3a7ba4e5-047f-4a3b-a047-cc2333ef2275',48,'16a57eec68224f4d9395015bb4c6714b','gigabytes',1,'2025-11-29 10:05:55',NULL),('2025-11-28 10:05:55','2025-11-28 10:05:56','2025-11-28 10:05:56',1,178,'46f39e5e-ef02-4d0f-8b42-4ab61d2e28e7',44,'d2d31a928b84446c97d35bb770c268e5','gigabytes',1,'2025-11-29 10:05:55',NULL),('2025-11-28 10:05:55','2025-11-28 10:05:56','2025-11-28 10:05:56',1,179,'70bccee5-5be0-4490-9f2a-e8ab358da766',49,'16a57eec68224f4d9395015bb4c6714b','volumes_tripleo',1,'2025-11-29 10:05:55',NULL),('2025-11-28 10:05:55','2025-11-28 10:05:56','2025-11-28 10:05:56',1,180,'56e7104c-75c2-45e6-bba5-2e646414b67e',45,'d2d31a928b84446c97d35bb770c268e5','volumes_tripleo',1,'2025-11-29 10:05:55',NULL),('2025-11-28 10:05:55','2025-11-28 10:05:56','2025-11-28 10:05:56',1,181,'b202ba11-7f23-4db9-b61f-95b6254bde05',50,'16a57eec68224f4d9395015bb4c6714b','gigabytes_tripleo',1,'2025-11-29 10:05:55',NULL),('2025-11-28 10:05:55','2025-11-28 10:05:56','2025-11-28 10:05:56',1,182,'4c135400-dabf-42e4-8071-c84044cd9f01',46,'d2d31a928b84446c97d35bb770c268e5','gigabytes_tripleo',1,'2025-11-29 10:05:55',NULL),('2025-11-28 10:05:57','2025-11-28 10:05:57','2025-11-28 10:05:57',1,183,'c519df22-1a14-4bc2-adac-e2e44ebc58ed',51,'d2d31a928b84446c97d35bb770c268e5','backups',1,'2025-11-29 10:05:57',NULL),('2025-11-28 10:05:57','2025-11-28 10:05:57','2025-11-28 10:05:57',1,184,'95c1f194-7f9d-4961-b933-74588a3ad9ac',52,'d2d31a928b84446c97d35bb770c268e5','backup_gigabytes',1,'2025-11-29 10:05:57',NULL),('2025-11-28 10:05:58','2025-11-28 10:05:58','2025-11-28 10:05:58',1,185,'0a45210a-cda0-43ab-a67e-7f54945d98a7',47,'16a57eec68224f4d9395015bb4c6714b','volumes',-1,'2025-11-29 10:05:58',NULL),('2025-11-28 10:05:58','2025-11-28 10:05:58','2025-11-28 10:05:58',1,186,'fd99f052-f752-4de2-bff2-1c1ba2a8840d',48,'16a57eec68224f4d9395015bb4c6714b','gigabytes',-1,'2025-11-29 10:05:58',NULL),('2025-11-28 10:05:58','2025-11-28 10:05:58','2025-11-28 10:05:58',1,187,'7a087cb8-6e7f-4510-bac0-7a2fd5b2ef91',49,'16a57eec68224f4d9395015bb4c6714b','volumes_tripleo',-1,'2025-11-29 10:05:58',NULL),('2025-11-28 10:05:58','2025-11-28 10:05:58','2025-11-28 10:05:58',1,188,'e94583be-1b11-4212-93e0-6021d235a6f8',50,'16a57eec68224f4d9395015bb4c6714b','gigabytes_tripleo',-1,'2025-11-29 10:05:58',NULL),('2025-11-28 10:05:59','2025-11-28 10:05:59','2025-11-28 10:05:59',1,189,'0b38e193-945f-4a5e-9011-64a16b9e8bec',39,'38c774f4f3a34ba7822603fa362cd4c8','volumes',-1,'2025-11-29 10:05:59',NULL),('2025-11-28 10:05:59','2025-11-28 10:05:59','2025-11-28 10:05:59',1,190,'745760fb-97fe-4c38-ba42-7ddd4a2adf24',40,'38c774f4f3a34ba7822603fa362cd4c8','gigabytes',-1,'2025-11-29 10:05:59',NULL),('2025-11-28 10:05:59','2025-11-28 10:05:59','2025-11-28 10:05:59',1,191,'b8860c2d-bc5a-4484-b4e3-4b8a9cf92bf8',41,'38c774f4f3a34ba7822603fa362cd4c8','volumes_tripleo',-1,'2025-11-29 10:05:59',NULL),('2025-11-28 10:05:59','2025-11-28 10:05:59','2025-11-28 10:05:59',1,192,'6efc26a6-2f04-47d4-ae0c-2394818f8848',42,'38c774f4f3a34ba7822603fa362cd4c8','gigabytes_tripleo',-1,'2025-11-29 10:05:59',NULL),('2025-11-28 10:06:02','2025-11-28 10:06:02','2025-11-28 10:06:02',1,193,'a99199a4-2337-4414-968b-ef3af8b335bc',53,'09ce8f94e31a412b82a6b18baad225fe','volumes',1,'2025-11-29 10:06:02',NULL),('2025-11-28 10:06:02','2025-11-28 10:06:02','2025-11-28 10:06:02',1,194,'11dae98d-b650-4930-a669-77b80c4fb15e',54,'09ce8f94e31a412b82a6b18baad225fe','gigabytes',1,'2025-11-29 10:06:02',NULL),('2025-11-28 10:06:02','2025-11-28 10:06:02','2025-11-28 10:06:02',1,195,'5ab80c78-82f8-4add-9b2a-11fa1303e13a',55,'09ce8f94e31a412b82a6b18baad225fe','volumes_tripleo',1,'2025-11-29 10:06:02',NULL),('2025-11-28 10:06:02','2025-11-28 10:06:02','2025-11-28 10:06:02',1,196,'c38c5f4a-fc49-4359-819e-d3dc8c00aa6e',56,'09ce8f94e31a412b82a6b18baad225fe','gigabytes_tripleo',1,'2025-11-29 10:06:02',NULL),('2025-11-28 10:06:04','2025-11-28 10:06:04','2025-11-28 10:06:04',1,197,'626f954f-f716-46e3-8dfd-6f709447f8fb',53,'09ce8f94e31a412b82a6b18baad225fe','volumes',-1,'2025-11-29 10:06:04',NULL),('2025-11-28 10:06:04','2025-11-28 10:06:04','2025-11-28 10:06:04',1,198,'6c1490f4-1f59-40fb-9ac5-ae1ad6b17e16',54,'09ce8f94e31a412b82a6b18baad225fe','gigabytes',-1,'2025-11-29 10:06:04',NULL),('2025-11-28 10:06:04','2025-11-28 10:06:04','2025-11-28 10:06:04',1,199,'d22e100d-dcf2-4e4f-ba93-aba486682b7e',55,'09ce8f94e31a412b82a6b18baad225fe','volumes_tripleo',-1,'2025-11-29 10:06:04',NULL),('2025-11-28 10:06:04','2025-11-28 10:06:04','2025-11-28 10:06:04',1,200,'5e8e09c2-a37b-4b92-800b-9347a716f65b',56,'09ce8f94e31a412b82a6b18baad225fe','gigabytes_tripleo',-1,'2025-11-29 10:06:04',NULL),('2025-11-28 10:06:05','2025-11-28 10:06:05','2025-11-28 10:06:05',1,201,'776bcbcf-1dcf-4b48-80f9-a12cf0e6aa3e',57,'aff7b7030d9c4af69b909a2b53581468','backups',1,'2025-11-29 10:06:05',NULL),('2025-11-28 10:06:05','2025-11-28 10:06:05','2025-11-28 10:06:05',1,202,'1f65c87e-9f95-45b0-a9bc-b75c663773c7',58,'aff7b7030d9c4af69b909a2b53581468','backup_gigabytes',1,'2025-11-29 10:06:05',NULL),('2025-11-28 10:06:06','2025-11-28 10:06:06','2025-11-28 10:06:06',1,203,'08909e3d-872e-4489-bcdd-49392b0c5ded',43,'d2d31a928b84446c97d35bb770c268e5','volumes',1,'2025-11-29 10:06:06',NULL),('2025-11-28 10:06:06','2025-11-28 10:06:06','2025-11-28 10:06:06',1,204,'50eb4534-362a-407e-9967-82ab96e28f10',44,'d2d31a928b84446c97d35bb770c268e5','gigabytes',1,'2025-11-29 10:06:06',NULL),('2025-11-28 10:06:06','2025-11-28 10:06:06','2025-11-28 10:06:06',1,205,'e7f508ce-365e-4aa0-b768-621b5b9ff84f',45,'d2d31a928b84446c97d35bb770c268e5','volumes_tripleo',1,'2025-11-29 10:06:06',NULL),('2025-11-28 10:06:06','2025-11-28 10:06:06','2025-11-28 10:06:06',1,206,'980b9d8a-1ece-4ae7-be3c-4b9dc0885698',46,'d2d31a928b84446c97d35bb770c268e5','gigabytes_tripleo',1,'2025-11-29 10:06:06',NULL),('2025-11-28 10:06:08','2025-11-28 10:06:08','2025-11-28 10:06:08',1,207,'677a5e41-2cbd-4f23-aee9-dd46ec585e24',59,'e8a245ce85d845b5aa0d1f9c0238c9e1','volumes',1,'2025-11-29 10:06:08',NULL),('2025-11-28 10:06:08','2025-11-28 10:06:08','2025-11-28 10:06:08',1,208,'7b7dca92-60b4-4b4a-a6ab-acca5490a1d3',60,'e8a245ce85d845b5aa0d1f9c0238c9e1','gigabytes',1,'2025-11-29 10:06:08',NULL),('2025-11-28 10:06:08','2025-11-28 10:06:08','2025-11-28 10:06:08',1,209,'f31c6be3-85c2-4516-a969-d5c726bfd214',61,'e8a245ce85d845b5aa0d1f9c0238c9e1','volumes_tripleo',1,'2025-11-29 10:06:08',NULL),('2025-11-28 10:06:08','2025-11-28 10:06:08','2025-11-28 10:06:08',1,210,'f4e1678a-1b4d-4939-bcd8-3c9027c01203',62,'e8a245ce85d845b5aa0d1f9c0238c9e1','gigabytes_tripleo',1,'2025-11-29 10:06:08',NULL),('2025-11-28 10:06:10','2025-11-28 10:06:10','2025-11-28 10:06:10',1,211,'67e35d6e-0b4c-42d8-9e89-a9ec21e5d9c0',57,'aff7b7030d9c4af69b909a2b53581468','backups',-1,'2025-11-29 10:06:10',NULL),('2025-11-28 10:06:10','2025-11-28 10:06:10','2025-11-28 10:06:10',1,212,'2db84822-5ace-4741-9e91-80a11b74befe',58,'aff7b7030d9c4af69b909a2b53581468','backup_gigabytes',-1,'2025-11-29 10:06:10',NULL),('2025-11-28 10:06:10','2025-11-28 10:06:10','2025-11-28 10:06:10',1,213,'150af476-104f-4759-8358-e3a905a493c2',59,'e8a245ce85d845b5aa0d1f9c0238c9e1','volumes',-1,'2025-11-29 10:06:10',NULL),('2025-11-28 10:06:10','2025-11-28 10:06:10','2025-11-28 10:06:10',1,214,'fff6a6d7-acd6-4f02-8188-693c39cd5daa',60,'e8a245ce85d845b5aa0d1f9c0238c9e1','gigabytes',-1,'2025-11-29 10:06:10',NULL),('2025-11-28 10:06:10','2025-11-28 10:06:10','2025-11-28 10:06:10',1,215,'2f7a5114-1565-4401-9165-548a76d1447d',61,'e8a245ce85d845b5aa0d1f9c0238c9e1','volumes_tripleo',-1,'2025-11-29 10:06:10',NULL),('2025-11-28 10:06:10','2025-11-28 10:06:10','2025-11-28 10:06:10',1,216,'1fef6e5e-955c-41a1-8ed6-f847a6cd8900',62,'e8a245ce85d845b5aa0d1f9c0238c9e1','gigabytes_tripleo',-1,'2025-11-29 10:06:10',NULL),('2025-11-28 10:06:11','2025-11-28 10:06:11','2025-11-28 10:06:11',1,217,'3c3a345e-ea3c-4367-a6e0-e0133e829e5f',43,'d2d31a928b84446c97d35bb770c268e5','volumes',-1,'2025-11-29 10:06:11',NULL),('2025-11-28 10:06:11','2025-11-28 10:06:11','2025-11-28 10:06:11',1,218,'4944d891-600c-420d-9cbf-002a4f5dae4c',44,'d2d31a928b84446c97d35bb770c268e5','gigabytes',-1,'2025-11-29 10:06:11',NULL),('2025-11-28 10:06:11','2025-11-28 10:06:11','2025-11-28 10:06:11',1,219,'80645fb4-17dc-4378-b271-3d031cc9027c',45,'d2d31a928b84446c97d35bb770c268e5','volumes_tripleo',-1,'2025-11-29 10:06:11',NULL),('2025-11-28 10:06:11','2025-11-28 10:06:11','2025-11-28 10:06:11',1,220,'778dc09b-6bed-499f-ae2d-b3747b0a5e6a',46,'d2d31a928b84446c97d35bb770c268e5','gigabytes_tripleo',-1,'2025-11-29 10:06:11',NULL),('2025-11-28 10:06:12','2025-11-28 10:06:12','2025-11-28 10:06:12',1,221,'b7b9854b-d995-4c82-ad96-33a4c5016ed6',51,'d2d31a928b84446c97d35bb770c268e5','backups',-1,'2025-11-29 10:06:12',NULL),('2025-11-28 10:06:12','2025-11-28 10:06:12','2025-11-28 10:06:12',1,222,'2461e102-c876-4264-90f6-9c08146a596a',52,'d2d31a928b84446c97d35bb770c268e5','backup_gigabytes',-1,'2025-11-29 10:06:12',NULL),('2025-11-28 10:06:14','2025-11-28 10:06:14','2025-11-28 10:06:14',1,223,'1c0fe0ed-222a-4ee6-8bf4-68072d6f65f4',43,'d2d31a928b84446c97d35bb770c268e5','volumes',-1,'2025-11-29 10:06:14',NULL),('2025-11-28 10:06:14','2025-11-28 10:06:14','2025-11-28 10:06:14',1,224,'2c757d84-4572-42d2-b240-7ad3c4284563',44,'d2d31a928b84446c97d35bb770c268e5','gigabytes',-1,'2025-11-29 10:06:14',NULL),('2025-11-28 10:06:14','2025-11-28 10:06:14','2025-11-28 10:06:14',1,225,'46d63e93-31b5-4e55-97bf-adb8a939a81c',45,'d2d31a928b84446c97d35bb770c268e5','volumes_tripleo',-1,'2025-11-29 10:06:14',NULL),('2025-11-28 10:06:14','2025-11-28 10:06:14','2025-11-28 10:06:14',1,226,'3e054fe3-a131-4e04-9bb6-b65f7206e713',46,'d2d31a928b84446c97d35bb770c268e5','gigabytes_tripleo',-1,'2025-11-29 10:06:14',NULL),('2025-11-28 10:06:15','2025-11-28 10:06:15','2025-11-28 10:06:15',1,227,'b13232ea-3022-4c9d-b8f2-28bc6d1db5b5',43,'d2d31a928b84446c97d35bb770c268e5','volumes',1,'2025-11-29 10:06:15',NULL),('2025-11-28 10:06:15','2025-11-28 10:06:15','2025-11-28 10:06:15',1,228,'62139213-5b64-4e2d-a963-738f01323965',44,'d2d31a928b84446c97d35bb770c268e5','gigabytes',1,'2025-11-29 10:06:15',NULL),('2025-11-28 10:06:15','2025-11-28 10:06:15','2025-11-28 10:06:15',1,229,'627ff242-0c1d-4398-8e6c-9c2a49a144ef',45,'d2d31a928b84446c97d35bb770c268e5','volumes_tripleo',1,'2025-11-29 10:06:15',NULL),('2025-11-28 10:06:15','2025-11-28 10:06:15','2025-11-28 10:06:15',1,230,'e81d773b-bbce-40c2-83ce-b40e05e37d1a',46,'d2d31a928b84446c97d35bb770c268e5','gigabytes_tripleo',1,'2025-11-29 10:06:15',NULL),('2025-11-28 10:06:16','2025-11-28 10:06:16','2025-11-28 10:06:16',1,231,'7d9e3ba7-9b68-409c-930f-639ec63becfd',51,'d2d31a928b84446c97d35bb770c268e5','backups',1,'2025-11-29 10:06:16',NULL),('2025-11-28 10:06:16','2025-11-28 10:06:16','2025-11-28 10:06:16',1,232,'5666cf8a-2965-4fb5-bb1d-245a0923f521',52,'d2d31a928b84446c97d35bb770c268e5','backup_gigabytes',1,'2025-11-29 10:06:16',NULL),('2025-11-28 10:06:21','2025-11-28 10:06:21','2025-11-28 10:06:21',1,233,'88692203-ca0b-448e-8af9-a8a1de18f426',63,'d3c0d1ce8d854a7b9ffc953e88cd2c44','volumes',1,'2025-11-29 10:06:21',NULL),('2025-11-28 10:06:21','2025-11-28 10:06:21','2025-11-28 10:06:21',1,234,'6ecbcaf8-2102-43b3-9171-ce48f597bddb',64,'d3c0d1ce8d854a7b9ffc953e88cd2c44','gigabytes',1,'2025-11-29 10:06:21',NULL),('2025-11-28 10:06:21','2025-11-28 10:06:21','2025-11-28 10:06:21',1,235,'f8a65820-979b-401b-b86c-704d6010bf14',65,'d3c0d1ce8d854a7b9ffc953e88cd2c44','volumes_tripleo',1,'2025-11-29 10:06:21',NULL),('2025-11-28 10:06:21','2025-11-28 10:06:21','2025-11-28 10:06:21',1,236,'5f598ec1-21f3-4299-b2a0-f2a21f07c4c6',66,'d3c0d1ce8d854a7b9ffc953e88cd2c44','gigabytes_tripleo',1,'2025-11-29 10:06:21',NULL),('2025-11-28 10:06:21','2025-11-28 10:06:21','2025-11-28 10:06:21',1,237,'18b2eccf-e9ba-473d-be57-9fc27acef2db',51,'d2d31a928b84446c97d35bb770c268e5','backups',-1,'2025-11-29 10:06:21',NULL),('2025-11-28 10:06:21','2025-11-28 10:06:21','2025-11-28 10:06:21',1,238,'17f43377-cab2-4b9b-a61a-d8cdd464838c',52,'d2d31a928b84446c97d35bb770c268e5','backup_gigabytes',-1,'2025-11-29 10:06:21',NULL),('2025-11-28 10:06:22','2025-11-28 10:06:22','2025-11-28 10:06:22',1,239,'4ae0ce8e-c2dd-430e-aa4d-c22b1db0b59d',67,'85f17f60fae2462cb663ba226772cedd','volumes',1,'2025-11-29 10:06:22',NULL),('2025-11-28 10:06:22','2025-11-28 10:06:22','2025-11-28 10:06:22',1,240,'77d7a7a8-5169-4cf3-b45d-b3b7badc2a9a',68,'85f17f60fae2462cb663ba226772cedd','gigabytes',1,'2025-11-29 10:06:22',NULL),('2025-11-28 10:06:22','2025-11-28 10:06:22','2025-11-28 10:06:22',1,241,'f477f8fa-5b06-4775-bd95-6948654a6c11',69,'85f17f60fae2462cb663ba226772cedd','volumes_tripleo',1,'2025-11-29 10:06:22',NULL),('2025-11-28 10:06:22','2025-11-28 10:06:22','2025-11-28 10:06:22',1,242,'47c1211a-0aa7-4c48-b0e6-276850423ff3',70,'85f17f60fae2462cb663ba226772cedd','gigabytes_tripleo',1,'2025-11-29 10:06:22',NULL),('2025-11-28 10:06:23','2025-11-28 10:06:23','2025-11-28 10:06:23',1,243,'a433c688-6611-4838-ad8d-1a5d1e5eb387',71,'85f17f60fae2462cb663ba226772cedd','snapshots',1,'2025-11-29 10:06:23',NULL),('2025-11-28 10:06:23','2025-11-28 10:06:23','2025-11-28 10:06:23',1,244,'5e0217f6-c73f-42e4-9b57-7b5553ae951a',68,'85f17f60fae2462cb663ba226772cedd','gigabytes',1,'2025-11-29 10:06:23',NULL),('2025-11-28 10:06:23','2025-11-28 10:06:23','2025-11-28 10:06:23',1,245,'7db4afcf-d13d-4968-be8d-3aded63c5448',70,'85f17f60fae2462cb663ba226772cedd','gigabytes_tripleo',1,'2025-11-29 10:06:23',NULL),('2025-11-28 10:06:23','2025-11-28 10:06:23','2025-11-28 10:06:23',1,246,'10f82d88-45e6-4c1f-bf22-b5dfe356c47e',72,'85f17f60fae2462cb663ba226772cedd','snapshots_tripleo',1,'2025-11-29 10:06:23',NULL),('2025-11-28 10:06:24','2025-11-28 10:06:24','2025-11-28 10:06:24',1,247,'ab417c43-838f-419e-ac9d-b67d1f71a2c1',43,'d2d31a928b84446c97d35bb770c268e5','volumes',-1,'2025-11-29 10:06:24',NULL),('2025-11-28 10:06:24','2025-11-28 10:06:24','2025-11-28 10:06:24',1,248,'03eee504-3b42-440f-85cd-13d09abb19f2',44,'d2d31a928b84446c97d35bb770c268e5','gigabytes',-1,'2025-11-29 10:06:24',NULL),('2025-11-28 10:06:24','2025-11-28 10:06:24','2025-11-28 10:06:24',1,249,'4f9a4a98-715a-4479-b6f1-0117e6c3f878',45,'d2d31a928b84446c97d35bb770c268e5','volumes_tripleo',-1,'2025-11-29 10:06:24',NULL),('2025-11-28 10:06:24','2025-11-28 10:06:24','2025-11-28 10:06:24',1,250,'dc4dc00d-4454-419a-97f4-ccdcf5fb28f6',46,'d2d31a928b84446c97d35bb770c268e5','gigabytes_tripleo',-1,'2025-11-29 10:06:24',NULL),('2025-11-28 10:06:24','2025-11-28 10:06:24','2025-11-28 10:06:24',1,251,'93948a01-0a63-4c1e-96e8-f342f2b3025e',73,'29d0d5b3ba0745d58aee3845ea704b73','volumes',1,'2025-11-29 10:06:24',NULL),('2025-11-28 10:06:24','2025-11-28 10:06:24','2025-11-28 10:06:24',1,252,'540baf55-e35d-4466-ac09-50904802926e',74,'29d0d5b3ba0745d58aee3845ea704b73','gigabytes',1,'2025-11-29 10:06:24',NULL),('2025-11-28 10:06:24','2025-11-28 10:06:24','2025-11-28 10:06:24',1,253,'3792b4fb-bea0-4c81-bf57-d2eba393bb3c',75,'29d0d5b3ba0745d58aee3845ea704b73','volumes_tripleo',1,'2025-11-29 10:06:24',NULL),('2025-11-28 10:06:24','2025-11-28 10:06:24','2025-11-28 10:06:24',1,254,'7bb0badb-046c-4428-a00c-6fe74d34387a',76,'29d0d5b3ba0745d58aee3845ea704b73','gigabytes_tripleo',1,'2025-11-29 10:06:24',NULL),('2025-11-28 10:06:25','2025-11-28 10:06:25','2025-11-28 10:06:25',1,255,'639de72a-5788-4e50-80f7-0b063797de55',71,'85f17f60fae2462cb663ba226772cedd','snapshots',1,'2025-11-29 10:06:24',NULL),('2025-11-28 10:06:25','2025-11-28 10:06:25','2025-11-28 10:06:25',1,256,'a96dbf2d-a7ed-4cce-b2a4-6f47f7181ddd',68,'85f17f60fae2462cb663ba226772cedd','gigabytes',1,'2025-11-29 10:06:24',NULL),('2025-11-28 10:06:25','2025-11-28 10:06:25','2025-11-28 10:06:25',1,257,'cc8249b1-e6aa-48e8-8caa-b8c08c6cbdc8',70,'85f17f60fae2462cb663ba226772cedd','gigabytes_tripleo',1,'2025-11-29 10:06:24',NULL),('2025-11-28 10:06:25','2025-11-28 10:06:25','2025-11-28 10:06:25',1,258,'dc4ea8ec-a36e-4b1a-90f0-4a77dbd9a195',72,'85f17f60fae2462cb663ba226772cedd','snapshots_tripleo',1,'2025-11-29 10:06:24',NULL),('2025-11-28 10:06:27','2025-11-28 10:06:27','2025-11-28 10:06:27',1,259,'25d1fec4-913a-4c7a-9ab5-1a97fbee4fd6',77,'d3c0d1ce8d854a7b9ffc953e88cd2c44','backups',1,'2025-11-29 10:06:27',NULL),('2025-11-28 10:06:27','2025-11-28 10:06:27','2025-11-28 10:06:27',1,260,'80c96b96-e56e-4416-8c4a-af3e23e2fd59',78,'d3c0d1ce8d854a7b9ffc953e88cd2c44','backup_gigabytes',1,'2025-11-29 10:06:27',NULL),('2025-11-28 10:06:28','2025-11-28 10:06:28','2025-11-28 10:06:28',1,261,'68c70540-9b62-4944-8ad7-9dbde7fa6964',71,'85f17f60fae2462cb663ba226772cedd','snapshots',-1,'2025-11-29 10:06:28',NULL),('2025-11-28 10:06:28','2025-11-28 10:06:28','2025-11-28 10:06:28',1,262,'e3ee5593-d66c-4cc7-b4a2-7a444d5d6d85',68,'85f17f60fae2462cb663ba226772cedd','gigabytes',-1,'2025-11-29 10:06:28',NULL),('2025-11-28 10:06:28','2025-11-28 10:06:28','2025-11-28 10:06:28',1,263,'7e47f9c9-b94b-4427-8363-acbd0f860cd5',70,'85f17f60fae2462cb663ba226772cedd','gigabytes_tripleo',-1,'2025-11-29 10:06:28',NULL),('2025-11-28 10:06:28','2025-11-28 10:06:28','2025-11-28 10:06:28',1,264,'c880a508-0879-4a92-8471-6390f60bcdb4',72,'85f17f60fae2462cb663ba226772cedd','snapshots_tripleo',-1,'2025-11-29 10:06:28',NULL),('2025-11-28 10:06:29','2025-11-28 10:06:29','2025-11-28 10:06:29',1,265,'58907773-5c74-46b3-91ce-1d75ec21ab68',71,'85f17f60fae2462cb663ba226772cedd','snapshots',-1,'2025-11-29 10:06:29',NULL),('2025-11-28 10:06:29','2025-11-28 10:06:29','2025-11-28 10:06:29',1,266,'b4346705-a6a9-44c3-aa40-d7e59d6bd8e2',68,'85f17f60fae2462cb663ba226772cedd','gigabytes',-1,'2025-11-29 10:06:29',NULL),('2025-11-28 10:06:29','2025-11-28 10:06:29','2025-11-28 10:06:29',1,267,'675bddc1-733a-4f82-a0aa-39ae4d250b81',70,'85f17f60fae2462cb663ba226772cedd','gigabytes_tripleo',-1,'2025-11-29 10:06:29',NULL),('2025-11-28 10:06:29','2025-11-28 10:06:29','2025-11-28 10:06:29',1,268,'83877d03-4428-4c17-ab24-dd34b42f84ce',72,'85f17f60fae2462cb663ba226772cedd','snapshots_tripleo',-1,'2025-11-29 10:06:29',NULL),('2025-11-28 10:06:29','2025-11-28 10:06:29','2025-11-28 10:06:29',1,269,'24e6e573-d3be-4510-90ca-617b2c2afda8',67,'85f17f60fae2462cb663ba226772cedd','volumes',-1,'2025-11-29 10:06:29',NULL),('2025-11-28 10:06:29','2025-11-28 10:06:29','2025-11-28 10:06:29',1,270,'47344eb6-67a0-4e62-a0fe-9bf536b564cb',68,'85f17f60fae2462cb663ba226772cedd','gigabytes',-1,'2025-11-29 10:06:29',NULL),('2025-11-28 10:06:29','2025-11-28 10:06:29','2025-11-28 10:06:29',1,271,'941df6af-bb88-4968-aa45-4bdf44ea0bb6',69,'85f17f60fae2462cb663ba226772cedd','volumes_tripleo',-1,'2025-11-29 10:06:29',NULL),('2025-11-28 10:06:29','2025-11-28 10:06:29','2025-11-28 10:06:29',1,272,'739630d7-0ffb-4db3-8415-7fcea63f4613',70,'85f17f60fae2462cb663ba226772cedd','gigabytes_tripleo',-1,'2025-11-29 10:06:29',NULL),('2025-11-28 10:06:30','2025-11-28 10:06:30','2025-11-28 10:06:30',1,273,'6f149c79-eea0-4afb-97b3-a8689ebd9350',67,'85f17f60fae2462cb663ba226772cedd','volumes',1,'2025-11-29 10:06:30',NULL),('2025-11-28 10:06:30','2025-11-28 10:06:30','2025-11-28 10:06:30',1,274,'0b0a84c4-a913-4b65-8d25-09f8caf309c6',68,'85f17f60fae2462cb663ba226772cedd','gigabytes',1,'2025-11-29 10:06:30',NULL),('2025-11-28 10:06:30','2025-11-28 10:06:30','2025-11-28 10:06:30',1,275,'9a0434c0-a3bc-4f68-a574-9b46e2cbf9b4',69,'85f17f60fae2462cb663ba226772cedd','volumes_tripleo',1,'2025-11-29 10:06:30',NULL),('2025-11-28 10:06:30','2025-11-28 10:06:30','2025-11-28 10:06:30',1,276,'7ee2b697-6c98-4c3d-9ce7-a107973c8c4a',70,'85f17f60fae2462cb663ba226772cedd','gigabytes_tripleo',1,'2025-11-29 10:06:30',NULL),('2025-11-28 10:06:31','2025-11-28 10:06:31','2025-11-28 10:06:31',1,277,'ee3de413-be25-484b-be26-330c5372511f',71,'85f17f60fae2462cb663ba226772cedd','snapshots',1,'2025-11-29 10:06:31',NULL),('2025-11-28 10:06:31','2025-11-28 10:06:31','2025-11-28 10:06:31',1,278,'abffbccd-3475-4121-ac39-2ff0179368e7',68,'85f17f60fae2462cb663ba226772cedd','gigabytes',1,'2025-11-29 10:06:31',NULL),('2025-11-28 10:06:31','2025-11-28 10:06:31','2025-11-28 10:06:31',1,279,'dc5380e0-1b18-4b91-91c1-e3c0c46b01b6',70,'85f17f60fae2462cb663ba226772cedd','gigabytes_tripleo',1,'2025-11-29 10:06:31',NULL),('2025-11-28 10:06:31','2025-11-28 10:06:31','2025-11-28 10:06:31',1,280,'5dac90d7-019d-4b63-ae5f-7be47c44354f',72,'85f17f60fae2462cb663ba226772cedd','snapshots_tripleo',1,'2025-11-29 10:06:31',NULL),('2025-11-28 10:06:32','2025-11-28 10:06:32','2025-11-28 10:06:32',1,281,'8e1da4d1-e70a-4393-91ad-719d99cb8c2d',79,'87556d11d3894443a0252992df39cd59','volumes',1,'2025-11-29 10:06:32',NULL),('2025-11-28 10:06:32','2025-11-28 10:06:32','2025-11-28 10:06:32',1,282,'e893df0f-9af0-4fed-af1e-2f815181518b',80,'87556d11d3894443a0252992df39cd59','gigabytes',1,'2025-11-29 10:06:32',NULL),('2025-11-28 10:06:32','2025-11-28 10:06:32','2025-11-28 10:06:32',1,283,'896ec927-e90e-4e41-881c-623889e5aab8',81,'87556d11d3894443a0252992df39cd59','volumes_tripleo',1,'2025-11-29 10:06:32',NULL),('2025-11-28 10:06:32','2025-11-28 10:06:32','2025-11-28 10:06:32',1,284,'f588f47d-e049-4c97-aa82-35af815f4cf6',82,'87556d11d3894443a0252992df39cd59','gigabytes_tripleo',1,'2025-11-29 10:06:32',NULL),('2025-11-28 10:06:33','2025-11-28 10:06:33','2025-11-28 10:06:33',1,285,'96484531-e2c7-470a-81ca-360c346aa431',63,'d3c0d1ce8d854a7b9ffc953e88cd2c44','volumes',1,'2025-11-29 10:06:33',NULL),('2025-11-28 10:06:33','2025-11-28 10:06:33','2025-11-28 10:06:33',1,286,'71b54e80-568e-4483-a669-47f249483dc0',64,'d3c0d1ce8d854a7b9ffc953e88cd2c44','gigabytes',1,'2025-11-29 10:06:33',NULL),('2025-11-28 10:06:33','2025-11-28 10:06:33','2025-11-28 10:06:33',1,287,'976df8c2-4765-4605-ab89-96713a640274',65,'d3c0d1ce8d854a7b9ffc953e88cd2c44','volumes_tripleo',1,'2025-11-29 10:06:33',NULL),('2025-11-28 10:06:33','2025-11-28 10:06:33','2025-11-28 10:06:33',1,288,'63d08e8f-cb70-4ebe-b99b-75aaa5522092',66,'d3c0d1ce8d854a7b9ffc953e88cd2c44','gigabytes_tripleo',1,'2025-11-29 10:06:33',NULL),('2025-11-28 10:06:33','2025-11-28 10:06:33','2025-11-28 10:06:33',1,289,'fb7db90e-98aa-46af-8baf-8ef30cfead4f',83,'030c225d7ed34b12a2a9020cd72dbf3a','volumes',1,'2025-11-29 10:06:33',NULL),('2025-11-28 10:06:33','2025-11-28 10:06:33','2025-11-28 10:06:33',1,290,'dfdbdf99-3195-4493-ace9-37dfba9d8581',84,'030c225d7ed34b12a2a9020cd72dbf3a','gigabytes',1,'2025-11-29 10:06:33',NULL),('2025-11-28 10:06:33','2025-11-28 10:06:33','2025-11-28 10:06:33',1,291,'46befb1b-5481-474e-8ca0-981605c96534',85,'030c225d7ed34b12a2a9020cd72dbf3a','volumes_tripleo',1,'2025-11-29 10:06:33',NULL),('2025-11-28 10:06:33','2025-11-28 10:06:33','2025-11-28 10:06:33',1,292,'4039e60f-d30d-44b7-940e-a984b8c4189c',86,'030c225d7ed34b12a2a9020cd72dbf3a','gigabytes_tripleo',1,'2025-11-29 10:06:33',NULL),('2025-11-28 10:06:33','2025-11-28 10:06:33','2025-11-28 10:06:33',1,293,'d7c01054-9642-4cb4-958b-46243a158f06',79,'87556d11d3894443a0252992df39cd59','volumes',-1,'2025-11-29 10:06:33',NULL),('2025-11-28 10:06:33','2025-11-28 10:06:33','2025-11-28 10:06:33',1,294,'19f610db-ccaa-4a62-82c4-bcea234fa9be',80,'87556d11d3894443a0252992df39cd59','gigabytes',-1,'2025-11-29 10:06:33',NULL),('2025-11-28 10:06:33','2025-11-28 10:06:33','2025-11-28 10:06:33',1,295,'b33086c1-9412-480a-8e5c-9bfe5190467a',81,'87556d11d3894443a0252992df39cd59','volumes_tripleo',-1,'2025-11-29 10:06:33',NULL),('2025-11-28 10:06:33','2025-11-28 10:06:33','2025-11-28 10:06:33',1,296,'b531dc4e-d67a-4fa1-b8c9-ca21d62f4bcd',82,'87556d11d3894443a0252992df39cd59','gigabytes_tripleo',-1,'2025-11-29 10:06:33',NULL),('2025-11-28 10:06:33','2025-11-28 10:06:33','2025-11-28 10:06:33',1,297,'e336666d-3218-4f84-9f23-f07dff5a1a9d',87,'030c225d7ed34b12a2a9020cd72dbf3a','snapshots',0,'2025-11-29 10:06:33',NULL),('2025-11-28 10:06:33','2025-11-28 10:06:33','2025-11-28 10:06:33',1,298,'c633d7fb-6c90-4ba3-91a9-525ecd7faa84',84,'030c225d7ed34b12a2a9020cd72dbf3a','gigabytes',0,'2025-11-29 10:06:33',NULL),('2025-11-28 10:06:33','2025-11-28 10:06:33','2025-11-28 10:06:33',1,299,'fd6bdd07-07b4-4845-bcfc-b2cdb3d65525',86,'030c225d7ed34b12a2a9020cd72dbf3a','gigabytes_tripleo',0,'2025-11-29 10:06:33',NULL),('2025-11-28 10:06:33','2025-11-28 10:06:33','2025-11-28 10:06:33',1,300,'af2d8ff9-4a6e-4c70-90fb-c32dd2995338',88,'030c225d7ed34b12a2a9020cd72dbf3a','snapshots_tripleo',0,'2025-11-29 10:06:33',NULL),('2025-11-28 10:06:33','2025-11-28 10:06:33','2025-11-28 10:06:33',1,301,'0ecdf4da-bf7a-4150-97e0-0f574c92fed2',89,'87556d11d3894443a0252992df39cd59','snapshots',0,'2025-11-29 10:06:33',NULL),('2025-11-28 10:06:33','2025-11-28 10:06:33','2025-11-28 10:06:33',1,302,'62398ac2-28d3-4fd3-803f-3a7aaa4380d3',80,'87556d11d3894443a0252992df39cd59','gigabytes',0,'2025-11-29 10:06:33',NULL),('2025-11-28 10:06:33','2025-11-28 10:06:33','2025-11-28 10:06:33',1,303,'50e45feb-23bc-47ef-bbdf-42f1d4e3ee56',82,'87556d11d3894443a0252992df39cd59','gigabytes_tripleo',0,'2025-11-29 10:06:33',NULL),('2025-11-28 10:06:33','2025-11-28 10:06:33','2025-11-28 10:06:33',1,304,'beef412d-70ac-44b0-98ae-1fed2481ab34',90,'87556d11d3894443a0252992df39cd59','snapshots_tripleo',0,'2025-11-29 10:06:33',NULL),('2025-11-28 10:06:34','2025-11-28 10:06:34','2025-11-28 10:06:34',1,305,'2e2c3b97-99c9-464d-a763-a03f1cec296e',67,'85f17f60fae2462cb663ba226772cedd','volumes',1,'2025-11-29 10:06:34',NULL),('2025-11-28 10:06:34','2025-11-28 10:06:34','2025-11-28 10:06:34',1,306,'c02fdd78-2401-4d9c-b067-078bf4611b1c',68,'85f17f60fae2462cb663ba226772cedd','gigabytes',1,'2025-11-29 10:06:34',NULL),('2025-11-28 10:06:34','2025-11-28 10:06:34','2025-11-28 10:06:34',1,307,'d89ec5ff-d639-4af2-825a-430c86b277d6',69,'85f17f60fae2462cb663ba226772cedd','volumes_tripleo',1,'2025-11-29 10:06:34',NULL),('2025-11-28 10:06:34','2025-11-28 10:06:34','2025-11-28 10:06:34',1,308,'31d9e2c7-5272-4850-93d8-ef11bd0cb303',70,'85f17f60fae2462cb663ba226772cedd','gigabytes_tripleo',1,'2025-11-29 10:06:34',NULL),('2025-11-28 10:06:35','2025-11-28 10:06:35','2025-11-28 10:06:35',1,309,'ede9e33f-90d2-4284-ad5a-ed3577a51068',83,'030c225d7ed34b12a2a9020cd72dbf3a','volumes',-1,'2025-11-29 10:06:34',NULL),('2025-11-28 10:06:35','2025-11-28 10:06:35','2025-11-28 10:06:35',1,310,'5628c4f8-3252-4cfa-b3f9-226ed3fa8da2',84,'030c225d7ed34b12a2a9020cd72dbf3a','gigabytes',-1,'2025-11-29 10:06:34',NULL),('2025-11-28 10:06:35','2025-11-28 10:06:35','2025-11-28 10:06:35',1,311,'11b1d261-a6c5-4a2d-b514-f6a4572ad5ac',85,'030c225d7ed34b12a2a9020cd72dbf3a','volumes_tripleo',-1,'2025-11-29 10:06:34',NULL),('2025-11-28 10:06:35','2025-11-28 10:06:35','2025-11-28 10:06:35',1,312,'3dd9523d-e49d-49cf-84e6-637fe19855aa',86,'030c225d7ed34b12a2a9020cd72dbf3a','gigabytes_tripleo',-1,'2025-11-29 10:06:34',NULL),('2025-11-28 10:06:35','2025-11-28 10:06:35','2025-11-28 10:06:35',1,313,'0626cf42-c989-49a5-9ced-95072377c10f',79,'87556d11d3894443a0252992df39cd59','volumes',1,'2025-11-29 10:06:35',NULL),('2025-11-28 10:06:35','2025-11-28 10:06:35','2025-11-28 10:06:35',1,314,'9583f814-c912-4b8a-b28b-25a0c6b13731',80,'87556d11d3894443a0252992df39cd59','gigabytes',1,'2025-11-29 10:06:35',NULL),('2025-11-28 10:06:35','2025-11-28 10:06:35','2025-11-28 10:06:35',1,315,'e45ad7db-3889-4938-81d9-a5af1c0941a8',81,'87556d11d3894443a0252992df39cd59','volumes_tripleo',1,'2025-11-29 10:06:35',NULL),('2025-11-28 10:06:35','2025-11-28 10:06:35','2025-11-28 10:06:35',1,316,'3694069e-5d98-4e78-87ba-9478c92b2b8c',82,'87556d11d3894443a0252992df39cd59','gigabytes_tripleo',1,'2025-11-29 10:06:35',NULL),('2025-11-28 10:06:38','2025-11-28 10:06:38','2025-11-28 10:06:38',1,317,'bcc508ce-0cdf-4291-92e4-684bec527d9b',79,'87556d11d3894443a0252992df39cd59','volumes',-1,'2025-11-29 10:06:38',NULL),('2025-11-28 10:06:38','2025-11-28 10:06:38','2025-11-28 10:06:38',1,318,'e3d2901e-51c2-4364-87ae-c85314074123',80,'87556d11d3894443a0252992df39cd59','gigabytes',-1,'2025-11-29 10:06:38',NULL),('2025-11-28 10:06:38','2025-11-28 10:06:38','2025-11-28 10:06:38',1,319,'08b62b06-1260-4473-81e3-557b0ab08791',81,'87556d11d3894443a0252992df39cd59','volumes_tripleo',-1,'2025-11-29 10:06:38',NULL),('2025-11-28 10:06:38','2025-11-28 10:06:38','2025-11-28 10:06:38',1,320,'bfc7d4ab-279c-42f5-b8a5-35c1405655c2',82,'87556d11d3894443a0252992df39cd59','gigabytes_tripleo',-1,'2025-11-29 10:06:38',NULL),('2025-11-28 10:06:40','2025-11-28 10:06:40','2025-11-28 10:06:40',1,321,'fc21b0e6-e906-4ad4-aa0b-ff0e6c5938f0',63,'d3c0d1ce8d854a7b9ffc953e88cd2c44','volumes',-1,'2025-11-29 10:06:40',NULL),('2025-11-28 10:06:40','2025-11-28 10:06:40','2025-11-28 10:06:40',1,322,'73a0dee3-ebc7-45d3-9f25-d59f9e38fe3b',64,'d3c0d1ce8d854a7b9ffc953e88cd2c44','gigabytes',-1,'2025-11-29 10:06:40',NULL),('2025-11-28 10:06:40','2025-11-28 10:06:40','2025-11-28 10:06:40',1,323,'04d4084e-03d0-44ba-857d-04d95874be43',65,'d3c0d1ce8d854a7b9ffc953e88cd2c44','volumes_tripleo',-1,'2025-11-29 10:06:40',NULL),('2025-11-28 10:06:40','2025-11-28 10:06:40','2025-11-28 10:06:40',1,324,'14f428ce-d03e-4f7e-8c17-271e1682c83e',66,'d3c0d1ce8d854a7b9ffc953e88cd2c44','gigabytes_tripleo',-1,'2025-11-29 10:06:40',NULL),('2025-11-28 10:06:42','2025-11-28 10:06:42','2025-11-28 10:06:42',1,325,'fa494fcb-41fc-421f-91b5-5547fe04271b',77,'d3c0d1ce8d854a7b9ffc953e88cd2c44','backups',-1,'2025-11-29 10:06:42',NULL),('2025-11-28 10:06:42','2025-11-28 10:06:42','2025-11-28 10:06:42',1,326,'a776b195-6113-4c37-9285-77b05c63cdf2',78,'d3c0d1ce8d854a7b9ffc953e88cd2c44','backup_gigabytes',-1,'2025-11-29 10:06:42',NULL),('2025-11-28 10:06:42','2025-11-28 10:06:42','2025-11-28 10:06:42',1,327,'1c0dc7ac-8796-4aad-a3e7-699a99f8c867',71,'85f17f60fae2462cb663ba226772cedd','snapshots',-1,'2025-11-29 10:06:42',NULL),('2025-11-28 10:06:42','2025-11-28 10:06:42','2025-11-28 10:06:42',1,328,'da83ebd3-d343-4be8-b328-408e34e28f02',68,'85f17f60fae2462cb663ba226772cedd','gigabytes',-1,'2025-11-29 10:06:42',NULL),('2025-11-28 10:06:42','2025-11-28 10:06:42','2025-11-28 10:06:42',1,329,'b782332d-3b69-49d4-825d-ef56ed717e1c',70,'85f17f60fae2462cb663ba226772cedd','gigabytes_tripleo',-1,'2025-11-29 10:06:42',NULL),('2025-11-28 10:06:42','2025-11-28 10:06:42','2025-11-28 10:06:42',1,330,'f1dce066-3590-4725-9d11-033240c687e2',72,'85f17f60fae2462cb663ba226772cedd','snapshots_tripleo',-1,'2025-11-29 10:06:42',NULL),('2025-11-28 10:06:43','2025-11-28 10:06:43','2025-11-28 10:06:43',1,331,'9b318c63-5ccb-444c-93e7-a7a4819dde4e',67,'85f17f60fae2462cb663ba226772cedd','volumes',-1,'2025-11-29 10:06:43',NULL),('2025-11-28 10:06:43','2025-11-28 10:06:43','2025-11-28 10:06:43',1,332,'893d58ba-ad5e-485d-89a0-acad01905e52',68,'85f17f60fae2462cb663ba226772cedd','gigabytes',-1,'2025-11-29 10:06:43',NULL),('2025-11-28 10:06:43','2025-11-28 10:06:43','2025-11-28 10:06:43',1,333,'e9cd4aab-1d95-4770-9fcf-c36d2cdfe175',69,'85f17f60fae2462cb663ba226772cedd','volumes_tripleo',-1,'2025-11-29 10:06:43',NULL),('2025-11-28 10:06:43','2025-11-28 10:06:43','2025-11-28 10:06:43',1,334,'f9880641-f1ad-4f2f-9920-e96c43d340d0',70,'85f17f60fae2462cb663ba226772cedd','gigabytes_tripleo',-1,'2025-11-29 10:06:43',NULL),('2025-11-28 10:06:45','2025-11-28 10:06:45','2025-11-28 10:06:45',1,335,'9b263076-21de-4d9a-a722-1844dc085ee9',67,'85f17f60fae2462cb663ba226772cedd','volumes',-1,'2025-11-29 10:06:45',NULL),('2025-11-28 10:06:45','2025-11-28 10:06:45','2025-11-28 10:06:45',1,336,'5e603a30-ad90-4727-8523-fc1b9cbee125',68,'85f17f60fae2462cb663ba226772cedd','gigabytes',-1,'2025-11-29 10:06:45',NULL),('2025-11-28 10:06:45','2025-11-28 10:06:45','2025-11-28 10:06:45',1,337,'5b81f010-10cd-4972-9375-071e973a8ee3',69,'85f17f60fae2462cb663ba226772cedd','volumes_tripleo',-1,'2025-11-29 10:06:45',NULL),('2025-11-28 10:06:45','2025-11-28 10:06:45','2025-11-28 10:06:45',1,338,'8ad4f134-ac7f-4263-8953-a99e8e2f3118',70,'85f17f60fae2462cb663ba226772cedd','gigabytes_tripleo',-1,'2025-11-29 10:06:45',NULL),('2025-11-28 10:06:46','2025-11-28 10:06:46','2025-11-28 10:06:46',1,339,'6a2d9fdf-d2bd-4730-80da-0d9097d61cb0',63,'d3c0d1ce8d854a7b9ffc953e88cd2c44','volumes',-1,'2025-11-29 10:06:46',NULL),('2025-11-28 10:06:46','2025-11-28 10:06:46','2025-11-28 10:06:46',1,340,'8fcb179b-939f-4282-b455-be14271610fd',64,'d3c0d1ce8d854a7b9ffc953e88cd2c44','gigabytes',-1,'2025-11-29 10:06:46',NULL),('2025-11-28 10:06:46','2025-11-28 10:06:46','2025-11-28 10:06:46',1,341,'92121b49-2152-43b0-97d9-b116c404d2c7',65,'d3c0d1ce8d854a7b9ffc953e88cd2c44','volumes_tripleo',-1,'2025-11-29 10:06:46',NULL),('2025-11-28 10:06:46','2025-11-28 10:06:46','2025-11-28 10:06:46',1,342,'4619cf0d-7d92-449a-92c3-0901ba488324',66,'d3c0d1ce8d854a7b9ffc953e88cd2c44','gigabytes_tripleo',-1,'2025-11-29 10:06:46',NULL),('2025-11-28 10:06:46','2025-11-28 10:06:46','2025-11-28 10:06:46',1,343,'0864585f-a13a-4c2c-b74c-4559138181d8',63,'d3c0d1ce8d854a7b9ffc953e88cd2c44','volumes',1,'2025-11-29 10:06:46',NULL),('2025-11-28 10:06:46','2025-11-28 10:06:46','2025-11-28 10:06:46',1,344,'42254c97-13ca-4944-9c4c-59ec2f7910d5',64,'d3c0d1ce8d854a7b9ffc953e88cd2c44','gigabytes',1,'2025-11-29 10:06:46',NULL),('2025-11-28 10:06:46','2025-11-28 10:06:46','2025-11-28 10:06:46',1,345,'19c02e06-2f39-4abf-99a4-fcd63a8895a2',65,'d3c0d1ce8d854a7b9ffc953e88cd2c44','volumes_tripleo',1,'2025-11-29 10:06:46',NULL),('2025-11-28 10:06:46','2025-11-28 10:06:46','2025-11-28 10:06:46',1,346,'b9440951-aa4f-4215-89b4-f055b68ae133',66,'d3c0d1ce8d854a7b9ffc953e88cd2c44','gigabytes_tripleo',1,'2025-11-29 10:06:46',NULL),('2025-11-28 10:06:50','2025-11-28 10:06:50','2025-11-28 10:06:50',1,347,'c8615c7c-efd7-4d77-97cc-0620e1eaf9f8',91,'a1eb2d80861b4077b9ef4c3389f19286','volumes',1,'2025-11-29 10:06:50',NULL),('2025-11-28 10:06:50','2025-11-28 10:06:50','2025-11-28 10:06:50',1,348,'58a9189b-d885-4d7a-bf57-e005d56dbbbd',92,'a1eb2d80861b4077b9ef4c3389f19286','gigabytes',1,'2025-11-29 10:06:50',NULL),('2025-11-28 10:06:50','2025-11-28 10:06:50','2025-11-28 10:06:50',1,349,'051e2a08-6493-4c7d-b30f-1ac4aaf32f22',93,'a1eb2d80861b4077b9ef4c3389f19286','volumes_tripleo',1,'2025-11-29 10:06:50',NULL),('2025-11-28 10:06:50','2025-11-28 10:06:50','2025-11-28 10:06:50',1,350,'535199da-0218-4e15-8b96-bb913e8afa7c',94,'a1eb2d80861b4077b9ef4c3389f19286','gigabytes_tripleo',1,'2025-11-29 10:06:50',NULL),('2025-11-28 10:06:51','2025-11-28 10:06:51','2025-11-28 10:06:51',1,351,'5da89cec-6722-49e3-aeee-31cc6d71d02f',91,'a1eb2d80861b4077b9ef4c3389f19286','volumes',1,'2025-11-29 10:06:51',NULL),('2025-11-28 10:06:51','2025-11-28 10:06:51','2025-11-28 10:06:51',1,352,'b800d63f-a045-4059-8b3a-e158248357a6',92,'a1eb2d80861b4077b9ef4c3389f19286','gigabytes',1,'2025-11-29 10:06:51',NULL),('2025-11-28 10:06:51','2025-11-28 10:06:51','2025-11-28 10:06:51',1,353,'6cf3f8ef-e514-4acb-bfb2-df48dd6b1575',93,'a1eb2d80861b4077b9ef4c3389f19286','volumes_tripleo',1,'2025-11-29 10:06:51',NULL),('2025-11-28 10:06:51','2025-11-28 10:06:51','2025-11-28 10:06:51',1,354,'a8c71ac6-54c1-4ffa-ac3f-d99617327150',94,'a1eb2d80861b4077b9ef4c3389f19286','gigabytes_tripleo',1,'2025-11-29 10:06:51',NULL),('2025-11-28 10:06:53','2025-11-28 10:06:53','2025-11-28 10:06:53',1,355,'103bebaf-3fba-457c-a9ea-3d4a6e90f81e',91,'a1eb2d80861b4077b9ef4c3389f19286','volumes',1,'2025-11-29 10:06:53',NULL),('2025-11-28 10:06:53','2025-11-28 10:06:53','2025-11-28 10:06:53',1,356,'792fe879-07ee-4929-ab94-b1564e774d4e',92,'a1eb2d80861b4077b9ef4c3389f19286','gigabytes',1,'2025-11-29 10:06:53',NULL),('2025-11-28 10:06:53','2025-11-28 10:06:53','2025-11-28 10:06:53',1,357,'32fa7d77-75f1-4d9a-863d-9861808962bc',93,'a1eb2d80861b4077b9ef4c3389f19286','volumes_tripleo',1,'2025-11-29 10:06:53',NULL),('2025-11-28 10:06:53','2025-11-28 10:06:53','2025-11-28 10:06:53',1,358,'18074ae6-b981-4fe1-9276-44b5f71ed977',94,'a1eb2d80861b4077b9ef4c3389f19286','gigabytes_tripleo',1,'2025-11-29 10:06:53',NULL),('2025-11-28 10:06:59','2025-11-28 10:06:59','2025-11-28 10:06:59',1,359,'6622c384-f4b6-4fe6-abd1-28904eba26a6',91,'a1eb2d80861b4077b9ef4c3389f19286','volumes',-1,'2025-11-29 10:06:59',NULL),('2025-11-28 10:06:59','2025-11-28 10:06:59','2025-11-28 10:06:59',1,360,'4e9e98bd-0adc-4cb9-b817-83cb93395b18',92,'a1eb2d80861b4077b9ef4c3389f19286','gigabytes',-1,'2025-11-29 10:06:59',NULL),('2025-11-28 10:06:59','2025-11-28 10:06:59','2025-11-28 10:06:59',1,361,'c4b15c2a-c64b-4c70-be52-dc811ffc8ce5',93,'a1eb2d80861b4077b9ef4c3389f19286','volumes_tripleo',-1,'2025-11-29 10:06:59',NULL),('2025-11-28 10:06:59','2025-11-28 10:06:59','2025-11-28 10:06:59',1,362,'3d06d3e7-cdaf-47db-aebb-de3435e7f670',94,'a1eb2d80861b4077b9ef4c3389f19286','gigabytes_tripleo',-1,'2025-11-29 10:06:59',NULL),('2025-11-28 10:07:02','2025-11-28 10:07:02','2025-11-28 10:07:02',1,363,'ae123d66-10b6-479c-a9fc-3c13ec942ef6',91,'a1eb2d80861b4077b9ef4c3389f19286','volumes',-1,'2025-11-29 10:07:02',NULL),('2025-11-28 10:07:02','2025-11-28 10:07:02','2025-11-28 10:07:02',1,364,'6d2c3be6-a4ef-48fd-8aca-3757cab08cea',92,'a1eb2d80861b4077b9ef4c3389f19286','gigabytes',-1,'2025-11-29 10:07:02',NULL),('2025-11-28 10:07:02','2025-11-28 10:07:02','2025-11-28 10:07:02',1,365,'d0d14cff-c353-41cd-bc9c-69c2decc2249',93,'a1eb2d80861b4077b9ef4c3389f19286','volumes_tripleo',-1,'2025-11-29 10:07:02',NULL),('2025-11-28 10:07:02','2025-11-28 10:07:02','2025-11-28 10:07:02',1,366,'f51dac57-070a-4812-ae3d-1e5ddd94bfef',94,'a1eb2d80861b4077b9ef4c3389f19286','gigabytes_tripleo',-1,'2025-11-29 10:07:02',NULL),('2025-11-28 10:07:04','2025-11-28 10:07:05','2025-11-28 10:07:05',1,367,'c6b813cc-e042-45da-a3ef-d3cee7172b5c',91,'a1eb2d80861b4077b9ef4c3389f19286','volumes',-1,'2025-11-29 10:07:04',NULL),('2025-11-28 10:07:04','2025-11-28 10:07:05','2025-11-28 10:07:05',1,368,'ebc3eef3-71e3-4bd9-857b-bf0afe0ec71f',92,'a1eb2d80861b4077b9ef4c3389f19286','gigabytes',-1,'2025-11-29 10:07:04',NULL),('2025-11-28 10:07:04','2025-11-28 10:07:05','2025-11-28 10:07:05',1,369,'438058b9-6238-459e-a2fd-a199d6f83aff',93,'a1eb2d80861b4077b9ef4c3389f19286','volumes_tripleo',-1,'2025-11-29 10:07:04',NULL),('2025-11-28 10:07:04','2025-11-28 10:07:05','2025-11-28 10:07:05',1,370,'98aae60b-aac9-419a-9ad4-25d0cd2a040c',94,'a1eb2d80861b4077b9ef4c3389f19286','gigabytes_tripleo',-1,'2025-11-29 10:07:04',NULL),('2025-11-28 10:07:13','2025-11-28 10:07:13','2025-11-28 10:07:13',1,371,'72fb0207-e349-498d-8469-6788677012cb',73,'29d0d5b3ba0745d58aee3845ea704b73','volumes',-1,'2025-11-29 10:07:13',NULL),('2025-11-28 10:07:13','2025-11-28 10:07:13','2025-11-28 10:07:13',1,372,'9a7b5b4e-46f5-4ea2-811e-20428d35c2ec',74,'29d0d5b3ba0745d58aee3845ea704b73','gigabytes',-1,'2025-11-29 10:07:13',NULL),('2025-11-28 10:07:13','2025-11-28 10:07:13','2025-11-28 10:07:13',1,373,'22c9539c-70f0-4429-9b46-e893bc80bc58',75,'29d0d5b3ba0745d58aee3845ea704b73','volumes_tripleo',-1,'2025-11-29 10:07:13',NULL),('2025-11-28 10:07:13','2025-11-28 10:07:13','2025-11-28 10:07:13',1,374,'fc44da3d-ff7a-479e-b14f-fc00bf3defc9',76,'29d0d5b3ba0745d58aee3845ea704b73','gigabytes_tripleo',-1,'2025-11-29 10:07:13',NULL),('2025-11-28 10:07:14','2025-11-28 10:07:14','2025-11-28 10:07:14',1,375,'7cb5243c-cb46-45c6-9821-9603ffa0977f',95,'7369c667b30341f7b300e32774b31181','volumes',1,'2025-11-29 10:07:14',NULL),('2025-11-28 10:07:14','2025-11-28 10:07:14','2025-11-28 10:07:14',1,376,'315cf439-32ca-4103-8698-6f9c9b821631',96,'7369c667b30341f7b300e32774b31181','gigabytes',1,'2025-11-29 10:07:14',NULL),('2025-11-28 10:07:14','2025-11-28 10:07:14','2025-11-28 10:07:14',1,377,'38f97af9-111c-4f95-afe5-21e57ffe0849',97,'7369c667b30341f7b300e32774b31181','volumes_tripleo',1,'2025-11-29 10:07:14',NULL),('2025-11-28 10:07:14','2025-11-28 10:07:14','2025-11-28 10:07:14',1,378,'af8efb0a-2374-409a-adf8-17219c98eccf',98,'7369c667b30341f7b300e32774b31181','gigabytes_tripleo',1,'2025-11-29 10:07:14',NULL),('2025-11-28 10:07:16','2025-11-28 10:07:16','2025-11-28 10:07:16',1,379,'6e2446f4-6593-43d7-bc47-043faf5bd0e4',99,'7369c667b30341f7b300e32774b31181','snapshots',1,'2025-11-29 10:07:16',NULL),('2025-11-28 10:07:16','2025-11-28 10:07:16','2025-11-28 10:07:16',1,380,'dde9aaf6-85f8-4b2c-bbeb-68380c58acae',96,'7369c667b30341f7b300e32774b31181','gigabytes',1,'2025-11-29 10:07:16',NULL),('2025-11-28 10:07:16','2025-11-28 10:07:16','2025-11-28 10:07:16',1,381,'ac142206-f271-4d7e-a3b6-b569827f90a0',98,'7369c667b30341f7b300e32774b31181','gigabytes_tripleo',1,'2025-11-29 10:07:16',NULL),('2025-11-28 10:07:16','2025-11-28 10:07:16','2025-11-28 10:07:16',1,382,'29dd72de-5413-4bbf-8680-441585690046',100,'7369c667b30341f7b300e32774b31181','snapshots_tripleo',1,'2025-11-29 10:07:16',NULL),('2025-11-28 10:07:17','2025-11-28 10:07:17','2025-11-28 10:07:17',1,383,'ac2135cf-e6ee-4f58-abed-e63a5fcd8c1d',99,'7369c667b30341f7b300e32774b31181','snapshots',1,'2025-11-29 10:07:17',NULL),('2025-11-28 10:07:17','2025-11-28 10:07:17','2025-11-28 10:07:17',1,384,'bf71fe85-4c45-436b-8b10-b966f6c0d6d1',96,'7369c667b30341f7b300e32774b31181','gigabytes',1,'2025-11-29 10:07:17',NULL),('2025-11-28 10:07:17','2025-11-28 10:07:17','2025-11-28 10:07:17',1,385,'9e3bad01-2a82-4987-9980-d91fc448f6e7',98,'7369c667b30341f7b300e32774b31181','gigabytes_tripleo',1,'2025-11-29 10:07:17',NULL),('2025-11-28 10:07:17','2025-11-28 10:07:17','2025-11-28 10:07:17',1,386,'24c6fe6e-39b0-4295-aca9-2d7c60fd7ec2',100,'7369c667b30341f7b300e32774b31181','snapshots_tripleo',1,'2025-11-29 10:07:17',NULL),('2025-11-28 10:07:19','2025-11-28 10:07:19','2025-11-28 10:07:19',1,387,'e3ebda82-d859-4ada-b96c-f97e6051a728',99,'7369c667b30341f7b300e32774b31181','snapshots',1,'2025-11-29 10:07:19',NULL),('2025-11-28 10:07:19','2025-11-28 10:07:19','2025-11-28 10:07:19',1,388,'3d1d911a-7fa8-4d4d-bbdc-367073bac065',96,'7369c667b30341f7b300e32774b31181','gigabytes',1,'2025-11-29 10:07:19',NULL),('2025-11-28 10:07:19','2025-11-28 10:07:19','2025-11-28 10:07:19',1,389,'47af01a5-dce1-49de-b692-8473249e32a5',98,'7369c667b30341f7b300e32774b31181','gigabytes_tripleo',1,'2025-11-29 10:07:19',NULL),('2025-11-28 10:07:19','2025-11-28 10:07:19','2025-11-28 10:07:19',1,390,'005eba1b-5957-4f99-b4cf-96f62edff99c',100,'7369c667b30341f7b300e32774b31181','snapshots_tripleo',1,'2025-11-29 10:07:19',NULL),('2025-11-28 10:07:21','2025-11-28 10:07:21','2025-11-28 10:07:21',1,391,'1971cd52-036c-47c6-afe0-279669dd5e0b',99,'7369c667b30341f7b300e32774b31181','snapshots',-1,'2025-11-29 10:07:21',NULL),('2025-11-28 10:07:21','2025-11-28 10:07:21','2025-11-28 10:07:21',1,392,'d0f10eb1-ffee-40a7-9d6f-99492dde7442',96,'7369c667b30341f7b300e32774b31181','gigabytes',-1,'2025-11-29 10:07:21',NULL),('2025-11-28 10:07:21','2025-11-28 10:07:21','2025-11-28 10:07:21',1,393,'212f72e9-50c3-46e0-bec3-118e897e079b',98,'7369c667b30341f7b300e32774b31181','gigabytes_tripleo',-1,'2025-11-29 10:07:21',NULL),('2025-11-28 10:07:21','2025-11-28 10:07:21','2025-11-28 10:07:21',1,394,'d3a3f678-146d-4ebd-bbcc-5c1a41a8b673',100,'7369c667b30341f7b300e32774b31181','snapshots_tripleo',-1,'2025-11-29 10:07:21',NULL),('2025-11-28 10:07:22','2025-11-28 10:07:22','2025-11-28 10:07:22',1,395,'668465de-b1a0-45b3-aaed-2dbbd66783e0',99,'7369c667b30341f7b300e32774b31181','snapshots',-1,'2025-11-29 10:07:22',NULL),('2025-11-28 10:07:22','2025-11-28 10:07:22','2025-11-28 10:07:22',1,396,'fa14c9ba-a8a9-4631-b93e-4c4a2fbc9b10',96,'7369c667b30341f7b300e32774b31181','gigabytes',-1,'2025-11-29 10:07:22',NULL),('2025-11-28 10:07:22','2025-11-28 10:07:22','2025-11-28 10:07:22',1,397,'91bbabc6-659e-4481-b7a0-75f8b593aa05',98,'7369c667b30341f7b300e32774b31181','gigabytes_tripleo',-1,'2025-11-29 10:07:22',NULL),('2025-11-28 10:07:22','2025-11-28 10:07:22','2025-11-28 10:07:22',1,398,'3a03421a-e778-4c69-8c70-6b49ff9bf104',100,'7369c667b30341f7b300e32774b31181','snapshots_tripleo',-1,'2025-11-29 10:07:22',NULL),('2025-11-28 10:07:24','2025-11-28 10:07:25','2025-11-28 10:07:25',1,399,'01c34957-1e6c-4b17-b24f-24e5486a1275',99,'7369c667b30341f7b300e32774b31181','snapshots',-1,'2025-11-29 10:07:24',NULL),('2025-11-28 10:07:24','2025-11-28 10:07:25','2025-11-28 10:07:25',1,400,'52efa493-6f4d-4f25-aa6e-2b22c927dd06',96,'7369c667b30341f7b300e32774b31181','gigabytes',-1,'2025-11-29 10:07:24',NULL),('2025-11-28 10:07:24','2025-11-28 10:07:25','2025-11-28 10:07:25',1,401,'4f64ea64-6d37-477f-8eb9-e5868e86bae3',98,'7369c667b30341f7b300e32774b31181','gigabytes_tripleo',-1,'2025-11-29 10:07:24',NULL),('2025-11-28 10:07:24','2025-11-28 10:07:25','2025-11-28 10:07:25',1,402,'219ad0ae-85a1-4396-9e2a-8bafa49ad2e0',100,'7369c667b30341f7b300e32774b31181','snapshots_tripleo',-1,'2025-11-29 10:07:24',NULL),('2025-11-28 10:07:26','2025-11-28 10:07:26','2025-11-28 10:07:26',1,403,'42647919-5f03-430d-b42b-29322e466e64',95,'7369c667b30341f7b300e32774b31181','volumes',-1,'2025-11-29 10:07:26',NULL),('2025-11-28 10:07:26','2025-11-28 10:07:26','2025-11-28 10:07:26',1,404,'1ed5b3aa-a88e-4fc2-a2b7-2da96a7cba3a',96,'7369c667b30341f7b300e32774b31181','gigabytes',-1,'2025-11-29 10:07:26',NULL),('2025-11-28 10:07:26','2025-11-28 10:07:26','2025-11-28 10:07:26',1,405,'a56a2053-1bb7-43e3-9777-1bf4ab3eae06',97,'7369c667b30341f7b300e32774b31181','volumes_tripleo',-1,'2025-11-29 10:07:26',NULL),('2025-11-28 10:07:26','2025-11-28 10:07:26','2025-11-28 10:07:26',1,406,'8948d148-7220-4e56-8285-6606658c8b02',98,'7369c667b30341f7b300e32774b31181','gigabytes_tripleo',-1,'2025-11-29 10:07:26',NULL),('2025-11-28 10:07:27','2025-11-28 10:07:27','2025-11-28 10:07:27',1,407,'3b5e739b-88f8-4912-8ef5-a85029cedcdb',101,'b4ab010fc80b442f8f29d2f02f18ecc9','volumes',1,'2025-11-29 10:07:27',NULL),('2025-11-28 10:07:27','2025-11-28 10:07:27','2025-11-28 10:07:27',1,408,'80709b4b-a78f-4a14-94b2-911efccd59c8',102,'b4ab010fc80b442f8f29d2f02f18ecc9','gigabytes',2,'2025-11-29 10:07:27',NULL),('2025-11-28 10:07:27','2025-11-28 10:07:27','2025-11-28 10:07:27',1,409,'b38d00c7-5838-4642-b0e3-2d0c2fe3aeb6',103,'b4ab010fc80b442f8f29d2f02f18ecc9','volumes_tripleo',1,'2025-11-29 10:07:27',NULL),('2025-11-28 10:07:27','2025-11-28 10:07:27','2025-11-28 10:07:27',1,410,'220fbe50-0905-4387-bb62-a530464582b2',104,'b4ab010fc80b442f8f29d2f02f18ecc9','gigabytes_tripleo',2,'2025-11-29 10:07:27',NULL),('2025-11-28 10:07:29','2025-11-28 10:07:29','2025-11-28 10:07:29',1,411,'bb95aab8-d9fe-4702-8673-0e1458a7269a',101,'b4ab010fc80b442f8f29d2f02f18ecc9','volumes',-1,'2025-11-29 10:07:29',NULL),('2025-11-28 10:07:29','2025-11-28 10:07:29','2025-11-28 10:07:29',1,412,'276fe2b0-fd68-48cd-9aee-ca987b1654af',102,'b4ab010fc80b442f8f29d2f02f18ecc9','gigabytes',-2,'2025-11-29 10:07:29',NULL),('2025-11-28 10:07:29','2025-11-28 10:07:29','2025-11-28 10:07:29',1,413,'0f76ab0d-9c69-4bb3-a1cd-8fabbbb4bd33',103,'b4ab010fc80b442f8f29d2f02f18ecc9','volumes_tripleo',-1,'2025-11-29 10:07:29',NULL),('2025-11-28 10:07:29','2025-11-28 10:07:29','2025-11-28 10:07:29',1,414,'9ba2f2d5-f3bc-40dd-83ea-b6818b49631a',104,'b4ab010fc80b442f8f29d2f02f18ecc9','gigabytes_tripleo',-2,'2025-11-29 10:07:29',NULL),('2025-11-28 10:07:34','2025-11-28 10:07:34','2025-11-28 10:07:34',1,415,'8b6b6d5e-58f8-4d88-8c66-34b94cb453d1',105,'7dd88588dc3b46ab8658061b1ac13996','volumes',1,'2025-11-29 10:07:34',NULL),('2025-11-28 10:07:34','2025-11-28 10:07:34','2025-11-28 10:07:34',1,416,'40a13222-15d4-49f2-b158-6183f484c105',106,'7dd88588dc3b46ab8658061b1ac13996','gigabytes',1,'2025-11-29 10:07:34',NULL),('2025-11-28 10:07:34','2025-11-28 10:07:34','2025-11-28 10:07:34',1,417,'1abefa94-a1c9-4959-ac0f-bb5c118944e6',107,'7dd88588dc3b46ab8658061b1ac13996','volumes_tripleo',1,'2025-11-29 10:07:34',NULL),('2025-11-28 10:07:34','2025-11-28 10:07:34','2025-11-28 10:07:34',1,418,'b194f67c-01cc-4777-b99c-e66140621362',108,'7dd88588dc3b46ab8658061b1ac13996','gigabytes_tripleo',1,'2025-11-29 10:07:34',NULL),('2025-11-28 10:07:38','2025-11-28 10:07:38','2025-11-28 10:07:38',1,419,'62ee595e-80b5-47d7-a931-b5d16e7c1f59',77,'d3c0d1ce8d854a7b9ffc953e88cd2c44','backups',1,'2025-11-29 10:07:38',NULL),('2025-11-28 10:07:38','2025-11-28 10:07:38','2025-11-28 10:07:38',1,420,'96a39be8-f0e1-4f8d-b9db-108257474b9b',78,'d3c0d1ce8d854a7b9ffc953e88cd2c44','backup_gigabytes',1,'2025-11-29 10:07:38',NULL),('2025-11-28 10:07:41','2025-11-28 10:07:41','2025-11-28 10:07:41',1,421,'6fa11664-4005-479e-b84c-29d98cd73b45',109,'44e47888bf384f2290cbd80a83fd1322','groups',1,'2025-11-29 10:07:41',NULL),('2025-11-28 10:07:42','2025-11-28 10:07:42','2025-11-28 10:07:42',1,422,'0aacd175-e7c9-4706-a552-30e97151e582',77,'d3c0d1ce8d854a7b9ffc953e88cd2c44','backups',1,'2025-11-29 10:07:42',NULL),('2025-11-28 10:07:42','2025-11-28 10:07:42','2025-11-28 10:07:42',1,423,'50113c8f-9403-4f90-b948-e3d44d4f4b17',78,'d3c0d1ce8d854a7b9ffc953e88cd2c44','backup_gigabytes',1,'2025-11-29 10:07:42',NULL),('2025-11-28 10:07:43','2025-11-28 10:07:43','2025-11-28 10:07:43',1,424,'a4e79453-0015-40c3-ac7f-686eb06d3973',110,'44e47888bf384f2290cbd80a83fd1322','volumes',1,'2025-11-29 10:07:43',NULL),('2025-11-28 10:07:43','2025-11-28 10:07:43','2025-11-28 10:07:43',1,425,'137a4aa2-daba-4022-9651-b34e2755c01d',111,'44e47888bf384f2290cbd80a83fd1322','gigabytes',1,'2025-11-29 10:07:43',NULL),('2025-11-28 10:07:43','2025-11-28 10:07:43','2025-11-28 10:07:43',1,426,'1601ade5-399b-4c77-b8f5-166c813486a0',112,'44e47888bf384f2290cbd80a83fd1322','volumes_tempest-GroupSnapshotsV319Test-volume-type-1428748724',1,'2025-11-29 10:07:43',NULL),('2025-11-28 10:07:43','2025-11-28 10:07:43','2025-11-28 10:07:43',1,427,'c72e0903-8cf2-4302-ab26-367928424e13',113,'44e47888bf384f2290cbd80a83fd1322','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-1428748724',1,'2025-11-29 10:07:43',NULL),('2025-11-28 10:07:45','2025-11-28 10:07:45','2025-11-28 10:07:45',1,428,'b39bdba7-ea9c-45c1-a5ac-f06bd99bde1c',114,'44e47888bf384f2290cbd80a83fd1322','snapshots',1,'2025-11-29 10:07:45',NULL),('2025-11-28 10:07:45','2025-11-28 10:07:45','2025-11-28 10:07:45',1,429,'37bb34f0-82c2-4e6d-8d2e-35b728c409a9',111,'44e47888bf384f2290cbd80a83fd1322','gigabytes',1,'2025-11-29 10:07:45',NULL),('2025-11-28 10:07:45','2025-11-28 10:07:45','2025-11-28 10:07:45',1,430,'7ac0a49d-63ec-4c6d-8818-1e31aa497f0e',113,'44e47888bf384f2290cbd80a83fd1322','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-1428748724',1,'2025-11-29 10:07:45',NULL),('2025-11-28 10:07:45','2025-11-28 10:07:45','2025-11-28 10:07:45',1,431,'bdab8ff3-2f20-480c-82db-f6bb701a2d77',115,'44e47888bf384f2290cbd80a83fd1322','snapshots_tempest-GroupSnapshotsV319Test-volume-type-1428748724',1,'2025-11-29 10:07:45',NULL),('2025-11-28 10:07:46','2025-11-28 10:07:46','2025-11-28 10:07:46',1,432,'a91be3f0-8968-4455-8647-0136496e0c75',105,'7dd88588dc3b46ab8658061b1ac13996','volumes',-1,'2025-11-29 10:07:46',NULL),('2025-11-28 10:07:46','2025-11-28 10:07:46','2025-11-28 10:07:46',1,433,'38188b6d-fc51-410d-9f8f-744d4820cdfa',106,'7dd88588dc3b46ab8658061b1ac13996','gigabytes',-1,'2025-11-29 10:07:46',NULL),('2025-11-28 10:07:46','2025-11-28 10:07:46','2025-11-28 10:07:46',1,434,'774c8dda-3546-4ddb-9fdf-f6ec5dc22631',107,'7dd88588dc3b46ab8658061b1ac13996','volumes_tripleo',-1,'2025-11-29 10:07:46',NULL),('2025-11-28 10:07:46','2025-11-28 10:07:46','2025-11-28 10:07:46',1,435,'49899611-53d6-4a0c-bc93-64d2202b2491',108,'7dd88588dc3b46ab8658061b1ac13996','gigabytes_tripleo',-1,'2025-11-29 10:07:46',NULL),('2025-11-28 10:07:47','2025-11-28 10:07:48','2025-11-28 10:07:48',1,436,'9d5dc3df-81c3-4c9c-902c-579e9b928654',77,'d3c0d1ce8d854a7b9ffc953e88cd2c44','backups',-1,'2025-11-29 10:07:47',NULL),('2025-11-28 10:07:47','2025-11-28 10:07:48','2025-11-28 10:07:48',1,437,'dc178a62-c479-48e6-b192-e1e825503f24',78,'d3c0d1ce8d854a7b9ffc953e88cd2c44','backup_gigabytes',-1,'2025-11-29 10:07:47',NULL),('2025-11-28 10:07:48','2025-11-28 10:07:48','2025-11-28 10:07:48',1,438,'7c5a5c1b-944e-427e-bcf2-d44003f606c6',77,'d3c0d1ce8d854a7b9ffc953e88cd2c44','backups',1,'2025-11-29 10:07:48',NULL),('2025-11-28 10:07:48','2025-11-28 10:07:48','2025-11-28 10:07:48',1,439,'aa8003a4-cb59-4a45-b49d-be1543e91d5b',78,'d3c0d1ce8d854a7b9ffc953e88cd2c44','backup_gigabytes',1,'2025-11-29 10:07:48',NULL),('2025-11-28 10:07:49','2025-11-28 10:07:49','2025-11-28 10:07:49',1,440,'0bbd54cb-7362-4a9f-8859-306993101e6e',114,'44e47888bf384f2290cbd80a83fd1322','snapshots',-1,'2025-11-29 10:07:49',NULL),('2025-11-28 10:07:49','2025-11-28 10:07:49','2025-11-28 10:07:49',1,441,'332b4059-9948-4a66-95b8-74417dd76fd6',111,'44e47888bf384f2290cbd80a83fd1322','gigabytes',-1,'2025-11-29 10:07:49',NULL),('2025-11-28 10:07:49','2025-11-28 10:07:49','2025-11-28 10:07:49',1,442,'010615ee-72e8-49bd-9358-a51382e5ac23',113,'44e47888bf384f2290cbd80a83fd1322','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-1428748724',-1,'2025-11-29 10:07:49',NULL),('2025-11-28 10:07:49','2025-11-28 10:07:49','2025-11-28 10:07:49',1,443,'c32c56e6-4440-4bfe-8a88-368b7aed5506',115,'44e47888bf384f2290cbd80a83fd1322','snapshots_tempest-GroupSnapshotsV319Test-volume-type-1428748724',-1,'2025-11-29 10:07:49',NULL),('2025-11-28 10:07:51','2025-11-28 10:07:51','2025-11-28 10:07:51',1,444,'82b6389e-2881-4456-bd3c-093f3b03e7a7',109,'44e47888bf384f2290cbd80a83fd1322','groups',-1,'2025-11-29 10:07:51',NULL),('2025-11-28 10:07:51','2025-11-28 10:07:51','2025-11-28 10:07:51',1,445,'6df674c2-eca6-4c97-9a8d-05d414c8cc3e',110,'44e47888bf384f2290cbd80a83fd1322','volumes',-1,'2025-11-29 10:07:51',NULL),('2025-11-28 10:07:51','2025-11-28 10:07:51','2025-11-28 10:07:51',1,446,'d26204b8-fda8-415d-a296-a9e18dc50459',111,'44e47888bf384f2290cbd80a83fd1322','gigabytes',-1,'2025-11-29 10:07:51',NULL),('2025-11-28 10:07:51','2025-11-28 10:07:51','2025-11-28 10:07:51',1,447,'90e6a81a-26f2-4747-8475-5db1a106bfec',112,'44e47888bf384f2290cbd80a83fd1322','volumes_tempest-GroupSnapshotsV319Test-volume-type-1428748724',-1,'2025-11-29 10:07:51',NULL),('2025-11-28 10:07:51','2025-11-28 10:07:51','2025-11-28 10:07:51',1,448,'fb60aef2-913d-426d-b296-b92059d8b9a1',113,'44e47888bf384f2290cbd80a83fd1322','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-1428748724',-1,'2025-11-29 10:07:51',NULL),('2025-11-28 10:07:54','2025-11-28 10:07:54','2025-11-28 10:07:54',1,449,'01b08d5c-3d86-4a5c-94b8-5069f4742ae1',77,'d3c0d1ce8d854a7b9ffc953e88cd2c44','backups',-1,'2025-11-29 10:07:54',NULL),('2025-11-28 10:07:54','2025-11-28 10:07:54','2025-11-28 10:07:54',1,450,'b780a2fb-1129-4c2a-88db-ee418855bf1a',78,'d3c0d1ce8d854a7b9ffc953e88cd2c44','backup_gigabytes',-1,'2025-11-29 10:07:54',NULL),('2025-11-28 10:07:55','2025-11-28 10:07:55','2025-11-28 10:07:55',1,451,'73b45d3a-7ee6-4119-b086-cc4f0f805676',77,'d3c0d1ce8d854a7b9ffc953e88cd2c44','backups',-1,'2025-11-29 10:07:55',NULL),('2025-11-28 10:07:55','2025-11-28 10:07:55','2025-11-28 10:07:55',1,452,'a7bf9bcb-9c0d-4b5a-81f4-436c64d29487',78,'d3c0d1ce8d854a7b9ffc953e88cd2c44','backup_gigabytes',-1,'2025-11-29 10:07:55',NULL),('2025-11-28 10:08:02','2025-11-28 10:08:02','2025-11-28 10:08:02',1,453,'9ea232ad-f476-4109-b086-b2b37fe74546',116,'5171816b5d3845278c70b062bedaa177','volumes',1,'2025-11-29 10:08:01',NULL),('2025-11-28 10:08:02','2025-11-28 10:08:02','2025-11-28 10:08:02',1,454,'cccafcfa-a2f6-48a3-83d2-0121a9904b95',117,'5171816b5d3845278c70b062bedaa177','gigabytes',1,'2025-11-29 10:08:01',NULL),('2025-11-28 10:08:02','2025-11-28 10:08:02','2025-11-28 10:08:02',1,455,'11963a90-e639-4da6-aec5-792a0c6f8182',118,'5171816b5d3845278c70b062bedaa177','volumes_tripleo',1,'2025-11-29 10:08:01',NULL),('2025-11-28 10:08:02','2025-11-28 10:08:02','2025-11-28 10:08:02',1,456,'09305184-3bc5-4ad3-be0c-9dad04b8d454',119,'5171816b5d3845278c70b062bedaa177','gigabytes_tripleo',1,'2025-11-29 10:08:01',NULL),('2025-11-28 10:08:03','2025-11-28 10:08:03','2025-11-28 10:08:03',1,457,'a096706f-c9c1-4930-980d-77d2063b11cb',116,'5171816b5d3845278c70b062bedaa177','volumes',-1,'2025-11-29 10:08:03',NULL),('2025-11-28 10:08:03','2025-11-28 10:08:03','2025-11-28 10:08:03',1,458,'21ae766a-2424-43c5-a83b-1960f675fbbd',117,'5171816b5d3845278c70b062bedaa177','gigabytes',-1,'2025-11-29 10:08:03',NULL),('2025-11-28 10:08:03','2025-11-28 10:08:03','2025-11-28 10:08:03',1,459,'a99156c0-49f7-4fd7-8257-15a22cabdb08',118,'5171816b5d3845278c70b062bedaa177','volumes_tripleo',-1,'2025-11-29 10:08:03',NULL),('2025-11-28 10:08:03','2025-11-28 10:08:03','2025-11-28 10:08:03',1,460,'d78eb9ae-9d3e-4b1f-a94a-a361cc8d3acd',119,'5171816b5d3845278c70b062bedaa177','gigabytes_tripleo',-1,'2025-11-29 10:08:03',NULL),('2025-11-28 10:08:04','2025-11-28 10:08:04','2025-11-28 10:08:04',1,461,'3db6388e-c079-47e1-82cf-1765eb400f18',116,'5171816b5d3845278c70b062bedaa177','volumes',1,'2025-11-29 10:08:04',NULL),('2025-11-28 10:08:04','2025-11-28 10:08:04','2025-11-28 10:08:04',1,462,'a0a84d2b-6615-4967-9aca-2d2be08d63d0',117,'5171816b5d3845278c70b062bedaa177','gigabytes',1,'2025-11-29 10:08:04',NULL),('2025-11-28 10:08:04','2025-11-28 10:08:04','2025-11-28 10:08:04',1,463,'442107e7-e1bf-41b5-aed1-5563ec32290a',118,'5171816b5d3845278c70b062bedaa177','volumes_tripleo',1,'2025-11-29 10:08:04',NULL),('2025-11-28 10:08:04','2025-11-28 10:08:04','2025-11-28 10:08:04',1,464,'aba1e5db-f4c2-4243-a516-95687fd79e16',119,'5171816b5d3845278c70b062bedaa177','gigabytes_tripleo',1,'2025-11-29 10:08:04',NULL),('2025-11-28 10:08:06','2025-11-28 10:08:06','2025-11-28 10:08:06',1,465,'d5ba4d75-9460-4eb5-a7bd-ad29ba0171fb',120,'6f9594f9fb704068b77cd4ff3489e542','volumes',1,'2025-11-29 10:08:06',NULL),('2025-11-28 10:08:06','2025-11-28 10:08:06','2025-11-28 10:08:06',1,466,'8d7ded01-fd7c-4188-981b-a30c8c19d45b',121,'6f9594f9fb704068b77cd4ff3489e542','gigabytes',1,'2025-11-29 10:08:06',NULL),('2025-11-28 10:08:06','2025-11-28 10:08:06','2025-11-28 10:08:06',1,467,'6555c9eb-ab48-4bc3-af7b-3b223ff7556e',122,'6f9594f9fb704068b77cd4ff3489e542','volumes_tripleo',1,'2025-11-29 10:08:06',NULL),('2025-11-28 10:08:06','2025-11-28 10:08:06','2025-11-28 10:08:06',1,468,'15eaff91-ed90-49a6-8d7f-211349e619b0',123,'6f9594f9fb704068b77cd4ff3489e542','gigabytes_tripleo',1,'2025-11-29 10:08:06',NULL),('2025-11-28 10:08:06','2025-11-28 10:08:06','2025-11-28 10:08:06',1,469,'40e4ece8-8539-49b1-a4f7-957a0b6eff75',116,'5171816b5d3845278c70b062bedaa177','volumes',-1,'2025-11-29 10:08:06',NULL),('2025-11-28 10:08:06','2025-11-28 10:08:06','2025-11-28 10:08:06',1,470,'56aea905-acdd-48b8-92d0-139e2b676dbe',117,'5171816b5d3845278c70b062bedaa177','gigabytes',-1,'2025-11-29 10:08:06',NULL),('2025-11-28 10:08:06','2025-11-28 10:08:06','2025-11-28 10:08:06',1,471,'cd31f7da-e0a0-425d-8bc8-72b2be0f4516',118,'5171816b5d3845278c70b062bedaa177','volumes_tripleo',-1,'2025-11-29 10:08:06',NULL),('2025-11-28 10:08:06','2025-11-28 10:08:06','2025-11-28 10:08:06',1,472,'4f67b1f7-066d-4add-8b61-4136e112b10d',119,'5171816b5d3845278c70b062bedaa177','gigabytes_tripleo',-1,'2025-11-29 10:08:06',NULL),('2025-11-28 10:08:06','2025-11-28 10:08:06','2025-11-28 10:08:06',1,473,'3a15e3d3-e375-451d-9328-7f76cfc4ad67',124,'6f9594f9fb704068b77cd4ff3489e542','snapshots',0,'2025-11-29 10:08:06',NULL),('2025-11-28 10:08:06','2025-11-28 10:08:06','2025-11-28 10:08:06',1,474,'0029356f-4095-4301-be85-7a7e59672525',121,'6f9594f9fb704068b77cd4ff3489e542','gigabytes',0,'2025-11-29 10:08:06',NULL),('2025-11-28 10:08:06','2025-11-28 10:08:06','2025-11-28 10:08:06',1,475,'bc26404f-c3aa-4ff7-89f1-90cd96a49d54',123,'6f9594f9fb704068b77cd4ff3489e542','gigabytes_tripleo',0,'2025-11-29 10:08:06',NULL),('2025-11-28 10:08:06','2025-11-28 10:08:06','2025-11-28 10:08:06',1,476,'8a4f5b80-390a-4043-9e1a-211c6f34b1bd',125,'6f9594f9fb704068b77cd4ff3489e542','snapshots_tripleo',0,'2025-11-29 10:08:06',NULL),('2025-11-28 10:08:06','2025-11-28 10:08:06','2025-11-28 10:08:06',1,477,'d91f361d-9669-41ee-a411-2978c46651cb',126,'5171816b5d3845278c70b062bedaa177','snapshots',0,'2025-11-29 10:08:06',NULL),('2025-11-28 10:08:06','2025-11-28 10:08:06','2025-11-28 10:08:06',1,478,'fb22b332-026b-4df1-97b7-e051d082fe01',117,'5171816b5d3845278c70b062bedaa177','gigabytes',0,'2025-11-29 10:08:06',NULL),('2025-11-28 10:08:06','2025-11-28 10:08:06','2025-11-28 10:08:06',1,479,'aa826af9-863f-4765-979a-ee6602e051d8',119,'5171816b5d3845278c70b062bedaa177','gigabytes_tripleo',0,'2025-11-29 10:08:06',NULL),('2025-11-28 10:08:06','2025-11-28 10:08:06','2025-11-28 10:08:06',1,480,'34b79209-4bd7-4fc5-a171-1208090113d1',127,'5171816b5d3845278c70b062bedaa177','snapshots_tripleo',0,'2025-11-29 10:08:06',NULL),('2025-11-28 10:08:07','2025-11-28 10:08:07','2025-11-28 10:08:07',1,481,'3ac447af-d15b-40f0-9b36-704543ce6444',120,'6f9594f9fb704068b77cd4ff3489e542','volumes',-1,'2025-11-29 10:08:07',NULL),('2025-11-28 10:08:07','2025-11-28 10:08:07','2025-11-28 10:08:07',1,482,'b9d604ec-9fd0-4eb2-bc17-36dccedaaebb',121,'6f9594f9fb704068b77cd4ff3489e542','gigabytes',-1,'2025-11-29 10:08:07',NULL),('2025-11-28 10:08:07','2025-11-28 10:08:07','2025-11-28 10:08:07',1,483,'abf07e2b-7e58-4f60-8a56-302aad050b31',122,'6f9594f9fb704068b77cd4ff3489e542','volumes_tripleo',-1,'2025-11-29 10:08:07',NULL),('2025-11-28 10:08:07','2025-11-28 10:08:07','2025-11-28 10:08:07',1,484,'ea424525-4384-4423-b2ff-161c53bf8599',123,'6f9594f9fb704068b77cd4ff3489e542','gigabytes_tripleo',-1,'2025-11-29 10:08:07',NULL),('2025-11-28 10:08:07','2025-11-28 10:08:07','2025-11-28 10:08:07',1,485,'cde56667-1829-49e3-9892-537d37d0e3ab',63,'d3c0d1ce8d854a7b9ffc953e88cd2c44','volumes',-1,'2025-11-29 10:08:07',NULL),('2025-11-28 10:08:07','2025-11-28 10:08:07','2025-11-28 10:08:07',1,486,'575ef47e-f75d-481c-b25a-fbde381e3dbc',64,'d3c0d1ce8d854a7b9ffc953e88cd2c44','gigabytes',-1,'2025-11-29 10:08:07',NULL),('2025-11-28 10:08:07','2025-11-28 10:08:07','2025-11-28 10:08:07',1,487,'575f91e8-d5db-43a7-b9fa-8059f9e96f8e',65,'d3c0d1ce8d854a7b9ffc953e88cd2c44','volumes_tripleo',-1,'2025-11-29 10:08:07',NULL),('2025-11-28 10:08:07','2025-11-28 10:08:07','2025-11-28 10:08:07',1,488,'8a4e6c21-fa08-4535-a417-5c646001e655',66,'d3c0d1ce8d854a7b9ffc953e88cd2c44','gigabytes_tripleo',-1,'2025-11-29 10:08:07',NULL),('2025-11-28 10:08:18','2025-11-28 10:08:18','2025-11-28 10:08:18',1,489,'be9c6cc6-756f-432d-845d-c3fa68c7410b',128,'6732fa86445147cdb019a2189d601a62','volumes',1,'2025-11-29 10:08:18',NULL),('2025-11-28 10:08:18','2025-11-28 10:08:18','2025-11-28 10:08:18',1,490,'8dcd5584-8395-4068-8444-0c8d11d4c228',129,'6732fa86445147cdb019a2189d601a62','gigabytes',1,'2025-11-29 10:08:18',NULL),('2025-11-28 10:08:18','2025-11-28 10:08:18','2025-11-28 10:08:18',1,491,'38ad7986-d3ed-46bc-95d2-0b2429d8c8b5',130,'6732fa86445147cdb019a2189d601a62','volumes_tripleo',1,'2025-11-29 10:08:18',NULL),('2025-11-28 10:08:18','2025-11-28 10:08:18','2025-11-28 10:08:18',1,492,'45b8ab84-03e7-4cdd-b200-b27241409177',131,'6732fa86445147cdb019a2189d601a62','gigabytes_tripleo',1,'2025-11-29 10:08:18',NULL),('2025-11-28 10:08:19','2025-11-28 10:08:19','2025-11-28 10:08:19',1,493,'5bd06abe-f1ed-4723-80d6-4394c2bcbea4',132,'b75145391b1642aa86ac346010612ae1','volumes',1,'2025-11-29 10:08:19',NULL),('2025-11-28 10:08:19','2025-11-28 10:08:19','2025-11-28 10:08:19',1,494,'de6dd19b-f77e-4d73-afa1-108908e729ba',133,'b75145391b1642aa86ac346010612ae1','gigabytes',1,'2025-11-29 10:08:19',NULL),('2025-11-28 10:08:19','2025-11-28 10:08:19','2025-11-28 10:08:19',1,495,'3a23baca-6c8a-481f-bd32-49ebe5f26157',134,'b75145391b1642aa86ac346010612ae1','volumes_tripleo',1,'2025-11-29 10:08:19',NULL),('2025-11-28 10:08:19','2025-11-28 10:08:19','2025-11-28 10:08:19',1,496,'b039d369-c7d3-4fb8-bceb-2b0cad6295a1',135,'b75145391b1642aa86ac346010612ae1','gigabytes_tripleo',1,'2025-11-29 10:08:19',NULL),('2025-11-28 10:08:21','2025-11-28 10:08:21','2025-11-28 10:08:21',1,497,'f606f7e7-486b-4fda-ad6c-59961125c6fd',136,'e40ad514f1414282aba0c087f08f4797','volumes',1,'2025-11-29 10:08:21',NULL),('2025-11-28 10:08:21','2025-11-28 10:08:21','2025-11-28 10:08:21',1,498,'dc2a9fd0-44a9-48be-98a3-042aae20b853',137,'e40ad514f1414282aba0c087f08f4797','gigabytes',1,'2025-11-29 10:08:21',NULL),('2025-11-28 10:08:21','2025-11-28 10:08:21','2025-11-28 10:08:21',1,499,'e8c158d7-e6f0-45a9-b965-1000a2bcb398',138,'e40ad514f1414282aba0c087f08f4797','volumes_tripleo',1,'2025-11-29 10:08:21',NULL),('2025-11-28 10:08:21','2025-11-28 10:08:21','2025-11-28 10:08:21',1,500,'fd6a7b01-4fab-43ec-a5d9-1c9cfdd788bc',139,'e40ad514f1414282aba0c087f08f4797','gigabytes_tripleo',1,'2025-11-29 10:08:21',NULL),('2025-11-28 10:08:21','2025-11-28 10:08:21','2025-11-28 10:08:21',1,501,'644f5749-eba0-4a51-9169-4e61d20a1103',132,'b75145391b1642aa86ac346010612ae1','volumes',-1,'2025-11-29 10:08:21',NULL),('2025-11-28 10:08:21','2025-11-28 10:08:21','2025-11-28 10:08:21',1,502,'81c23297-1be5-4893-be61-06d24d655094',133,'b75145391b1642aa86ac346010612ae1','gigabytes',-1,'2025-11-29 10:08:21',NULL),('2025-11-28 10:08:21','2025-11-28 10:08:21','2025-11-28 10:08:21',1,503,'da26b6e4-9848-4691-a473-73e55e72e363',134,'b75145391b1642aa86ac346010612ae1','volumes_tripleo',-1,'2025-11-29 10:08:21',NULL),('2025-11-28 10:08:21','2025-11-28 10:08:21','2025-11-28 10:08:21',1,504,'13ad9754-e5d9-40d2-aa37-bba7cbc0d140',135,'b75145391b1642aa86ac346010612ae1','gigabytes_tripleo',-1,'2025-11-29 10:08:21',NULL),('2025-11-28 10:08:21','2025-11-28 10:08:21','2025-11-28 10:08:21',1,505,'9792c31b-e5ac-416f-937f-afc7278fc906',140,'e40ad514f1414282aba0c087f08f4797','snapshots',0,'2025-11-29 10:08:21',NULL),('2025-11-28 10:08:21','2025-11-28 10:08:21','2025-11-28 10:08:21',1,506,'37d68645-bed0-4fe5-8f81-9aa743cbc210',137,'e40ad514f1414282aba0c087f08f4797','gigabytes',0,'2025-11-29 10:08:21',NULL),('2025-11-28 10:08:21','2025-11-28 10:08:21','2025-11-28 10:08:21',1,507,'53822d8b-f4fc-4c90-8f34-a8ac211f5c83',139,'e40ad514f1414282aba0c087f08f4797','gigabytes_tripleo',0,'2025-11-29 10:08:21',NULL),('2025-11-28 10:08:21','2025-11-28 10:08:21','2025-11-28 10:08:21',1,508,'f5bcd782-49f5-45a3-bd38-20031d56be08',141,'e40ad514f1414282aba0c087f08f4797','snapshots_tripleo',0,'2025-11-29 10:08:21',NULL),('2025-11-28 10:08:21','2025-11-28 10:08:21','2025-11-28 10:08:21',1,509,'e3b363ae-f261-4f05-9bce-95686b1b2212',142,'b75145391b1642aa86ac346010612ae1','snapshots',0,'2025-11-29 10:08:21',NULL),('2025-11-28 10:08:21','2025-11-28 10:08:21','2025-11-28 10:08:21',1,510,'6f72ba54-d1a9-4202-a7b0-cefb62276e23',133,'b75145391b1642aa86ac346010612ae1','gigabytes',0,'2025-11-29 10:08:21',NULL),('2025-11-28 10:08:21','2025-11-28 10:08:21','2025-11-28 10:08:21',1,511,'3f93b257-1676-49db-a44b-cb9495667e81',135,'b75145391b1642aa86ac346010612ae1','gigabytes_tripleo',0,'2025-11-29 10:08:21',NULL),('2025-11-28 10:08:21','2025-11-28 10:08:21','2025-11-28 10:08:21',1,512,'8dc39428-caca-4727-9ad3-cc06ca94a9f3',143,'b75145391b1642aa86ac346010612ae1','snapshots_tripleo',0,'2025-11-29 10:08:21',NULL),('2025-11-28 10:08:22','2025-11-28 10:08:22','2025-11-28 10:08:22',1,513,'159d99de-caaa-44c5-a41f-7f1124d6561e',136,'e40ad514f1414282aba0c087f08f4797','volumes',-1,'2025-11-29 10:08:22',NULL),('2025-11-28 10:08:22','2025-11-28 10:08:22','2025-11-28 10:08:22',1,514,'02b7cde5-04a2-4dd4-86ec-cfe0bbbba0a1',137,'e40ad514f1414282aba0c087f08f4797','gigabytes',-1,'2025-11-29 10:08:22',NULL),('2025-11-28 10:08:22','2025-11-28 10:08:22','2025-11-28 10:08:22',1,515,'5a0a2e13-0811-45cb-98d2-ebb90626feb6',138,'e40ad514f1414282aba0c087f08f4797','volumes_tripleo',-1,'2025-11-29 10:08:22',NULL),('2025-11-28 10:08:22','2025-11-28 10:08:22','2025-11-28 10:08:22',1,516,'3c253bb5-f08e-489e-8c1f-64bbeb118215',139,'e40ad514f1414282aba0c087f08f4797','gigabytes_tripleo',-1,'2025-11-29 10:08:22',NULL),('2025-11-28 10:08:22','2025-11-28 10:08:22','2025-11-28 10:08:22',1,517,'9239a648-f751-4268-820e-8530e7a28f16',132,'b75145391b1642aa86ac346010612ae1','volumes',1,'2025-11-29 10:08:22',NULL),('2025-11-28 10:08:22','2025-11-28 10:08:22','2025-11-28 10:08:22',1,518,'405f46de-3100-46c2-b5f7-00150560e435',133,'b75145391b1642aa86ac346010612ae1','gigabytes',1,'2025-11-29 10:08:22',NULL),('2025-11-28 10:08:22','2025-11-28 10:08:22','2025-11-28 10:08:22',1,519,'83b07d74-fa0e-4c4b-b248-7344e0e61620',134,'b75145391b1642aa86ac346010612ae1','volumes_tripleo',1,'2025-11-29 10:08:22',NULL),('2025-11-28 10:08:22','2025-11-28 10:08:22','2025-11-28 10:08:22',1,520,'06eb4076-3c93-4e57-ab68-6fc6f668351c',135,'b75145391b1642aa86ac346010612ae1','gigabytes_tripleo',1,'2025-11-29 10:08:22',NULL),('2025-11-28 10:08:23','2025-11-28 10:08:23','2025-11-28 10:08:23',1,521,'7bcae4cc-a458-4805-bf28-41fc0b24ad01',144,'708e5a4db87c470c994eb117a4c58083','groups',1,'2025-11-29 10:08:23',NULL),('2025-11-28 10:08:24','2025-11-28 10:08:24','2025-11-28 10:08:24',1,522,'04b7d711-ced6-4bb0-86f3-6089464ccf3a',144,'708e5a4db87c470c994eb117a4c58083','groups',1,'2025-11-29 10:08:24',NULL),('2025-11-28 10:08:24','2025-11-28 10:08:24','2025-11-28 10:08:24',1,523,'aa5531cb-fc4a-4cf6-bb2b-984611063adc',132,'b75145391b1642aa86ac346010612ae1','volumes',-1,'2025-11-29 10:08:24',NULL),('2025-11-28 10:08:24','2025-11-28 10:08:24','2025-11-28 10:08:24',1,524,'2503b71e-c2ab-4349-b989-a52bbd6db4b5',133,'b75145391b1642aa86ac346010612ae1','gigabytes',-1,'2025-11-29 10:08:24',NULL),('2025-11-28 10:08:24','2025-11-28 10:08:24','2025-11-28 10:08:24',1,525,'3c40352c-faaf-4cd1-8790-5676aedc6773',134,'b75145391b1642aa86ac346010612ae1','volumes_tripleo',-1,'2025-11-29 10:08:24',NULL),('2025-11-28 10:08:24','2025-11-28 10:08:24','2025-11-28 10:08:24',1,526,'ef8b88bc-1e2b-4411-ad29-e89d3a18bb85',135,'b75145391b1642aa86ac346010612ae1','gigabytes_tripleo',-1,'2025-11-29 10:08:24',NULL),('2025-11-28 10:08:24','2025-11-28 10:08:25','2025-11-28 10:08:25',1,527,'4439b6f7-196b-4be5-903d-e2190f8fae51',129,'6732fa86445147cdb019a2189d601a62','gigabytes',1,'2025-11-29 10:08:24',NULL),('2025-11-28 10:08:24','2025-11-28 10:08:25','2025-11-28 10:08:25',1,528,'e12b5340-c747-4df5-97e8-81be60b342c3',131,'6732fa86445147cdb019a2189d601a62','gigabytes_tripleo',1,'2025-11-29 10:08:24',NULL),('2025-11-28 10:08:25','2025-11-28 10:08:25','2025-11-28 10:08:25',1,529,'2d401478-869c-4821-9a72-4c3995e93cad',145,'708e5a4db87c470c994eb117a4c58083','volumes',1,'2025-11-29 10:08:25',NULL),('2025-11-28 10:08:25','2025-11-28 10:08:25','2025-11-28 10:08:25',1,530,'aa19dd22-a95d-433b-ae90-e85d2b54cc89',146,'708e5a4db87c470c994eb117a4c58083','gigabytes',1,'2025-11-29 10:08:25',NULL),('2025-11-28 10:08:25','2025-11-28 10:08:25','2025-11-28 10:08:25',1,531,'d3f6e119-cb41-4376-bfea-3121b196b5a1',147,'708e5a4db87c470c994eb117a4c58083','volumes_tempest-GroupsTest-volume-type-1256221482',1,'2025-11-29 10:08:25',NULL),('2025-11-28 10:08:25','2025-11-28 10:08:26','2025-11-28 10:08:26',1,532,'73be7252-791d-4263-8d38-41984c9e5887',148,'708e5a4db87c470c994eb117a4c58083','gigabytes_tempest-GroupsTest-volume-type-1256221482',1,'2025-11-29 10:08:25',NULL),('2025-11-28 10:08:26','2025-11-28 10:08:27','2025-11-28 10:08:27',1,533,'4d029e3b-32b7-49f4-b639-9d6a1030d62e',128,'6732fa86445147cdb019a2189d601a62','volumes',-1,'2025-11-29 10:08:26',NULL),('2025-11-28 10:08:26','2025-11-28 10:08:27','2025-11-28 10:08:27',1,534,'8ae45ccf-9a8e-48d2-bfcb-c37989391e8a',129,'6732fa86445147cdb019a2189d601a62','gigabytes',-2,'2025-11-29 10:08:26',NULL),('2025-11-28 10:08:26','2025-11-28 10:08:27','2025-11-28 10:08:27',1,535,'f570efa3-0c97-4e14-97e7-99ef018fde84',130,'6732fa86445147cdb019a2189d601a62','volumes_tripleo',-1,'2025-11-29 10:08:26',NULL),('2025-11-28 10:08:26','2025-11-28 10:08:27','2025-11-28 10:08:27',1,536,'24510231-92dc-4067-b7b4-8295d5357adf',131,'6732fa86445147cdb019a2189d601a62','gigabytes_tripleo',-2,'2025-11-29 10:08:26',NULL),('2025-11-28 10:08:27','2025-11-28 10:08:27','2025-11-28 10:08:27',1,537,'f4f43936-eee5-479e-b961-2ef76391f11b',128,'6732fa86445147cdb019a2189d601a62','volumes',1,'2025-11-29 10:08:27',NULL),('2025-11-28 10:08:27','2025-11-28 10:08:27','2025-11-28 10:08:27',1,538,'1c8f9c0c-da1c-4854-93ee-aa8fe9257c2e',129,'6732fa86445147cdb019a2189d601a62','gigabytes',1,'2025-11-29 10:08:27',NULL),('2025-11-28 10:08:27','2025-11-28 10:08:27','2025-11-28 10:08:27',1,539,'277b1e3e-fdc1-4d15-916f-736895ceec24',130,'6732fa86445147cdb019a2189d601a62','volumes_tripleo',1,'2025-11-29 10:08:27',NULL),('2025-11-28 10:08:27','2025-11-28 10:08:27','2025-11-28 10:08:27',1,540,'ac528c7c-da4d-4502-8cd5-1c3dfea0305f',131,'6732fa86445147cdb019a2189d601a62','gigabytes_tripleo',1,'2025-11-29 10:08:27',NULL),('2025-11-28 10:08:28','2025-11-28 10:08:28','2025-11-28 10:08:28',1,541,'6e3d1535-af54-4b15-9cb3-5c865e76fedc',144,'708e5a4db87c470c994eb117a4c58083','groups',-1,'2025-11-29 10:08:28',NULL),('2025-11-28 10:08:28','2025-11-28 10:08:28','2025-11-28 10:08:28',1,542,'837b6b6b-cb9d-4ac6-b5df-fa67c623eedd',145,'708e5a4db87c470c994eb117a4c58083','volumes',-1,'2025-11-29 10:08:28',NULL),('2025-11-28 10:08:28','2025-11-28 10:08:28','2025-11-28 10:08:28',1,543,'7c307d8f-6452-480c-bd10-9fe74153a636',146,'708e5a4db87c470c994eb117a4c58083','gigabytes',-1,'2025-11-29 10:08:28',NULL),('2025-11-28 10:08:28','2025-11-28 10:08:28','2025-11-28 10:08:28',1,544,'5c9ba222-ded8-4f45-b654-00ef43b4ee86',147,'708e5a4db87c470c994eb117a4c58083','volumes_tempest-GroupsTest-volume-type-1256221482',-1,'2025-11-29 10:08:28',NULL),('2025-11-28 10:08:28','2025-11-28 10:08:28','2025-11-28 10:08:28',1,545,'dc0d3522-e247-48e0-9c4b-f8a99e6057d6',148,'708e5a4db87c470c994eb117a4c58083','gigabytes_tempest-GroupsTest-volume-type-1256221482',-1,'2025-11-29 10:08:28',NULL),('2025-11-28 10:08:28','2025-11-28 10:08:28','2025-11-28 10:08:28',1,546,'d536f673-f3a1-4275-ba11-c379909df16a',149,'6732fa86445147cdb019a2189d601a62','snapshots',1,'2025-11-29 10:08:28',NULL),('2025-11-28 10:08:28','2025-11-28 10:08:28','2025-11-28 10:08:28',1,547,'ce4a20d1-8849-4219-b9ba-dfa15accc071',129,'6732fa86445147cdb019a2189d601a62','gigabytes',1,'2025-11-29 10:08:28',NULL),('2025-11-28 10:08:28','2025-11-28 10:08:28','2025-11-28 10:08:28',1,548,'c4396fa3-626b-409a-afea-6830bb6a41a9',131,'6732fa86445147cdb019a2189d601a62','gigabytes_tripleo',1,'2025-11-29 10:08:28',NULL),('2025-11-28 10:08:28','2025-11-28 10:08:28','2025-11-28 10:08:28',1,549,'a037f81b-afbf-457a-bb61-a0c2ba6524e9',150,'6732fa86445147cdb019a2189d601a62','snapshots_tripleo',1,'2025-11-29 10:08:28',NULL),('2025-11-28 10:08:28','2025-11-28 10:08:28','2025-11-28 10:08:28',1,550,'7278495a-5445-4356-b040-63655eb9d50d',144,'708e5a4db87c470c994eb117a4c58083','groups',-1,'2025-11-29 10:08:28',NULL),('2025-11-28 10:08:29','2025-11-28 10:08:30','2025-11-28 10:08:30',1,551,'2edfe7e6-d6e4-4709-aa63-a4868e988e9e',129,'6732fa86445147cdb019a2189d601a62','gigabytes',1,'2025-11-29 10:08:29',NULL),('2025-11-28 10:08:29','2025-11-28 10:08:30','2025-11-28 10:08:30',1,552,'a7c63607-3adb-4065-9cbc-e5407452e2cb',131,'6732fa86445147cdb019a2189d601a62','gigabytes_tripleo',1,'2025-11-29 10:08:29',NULL),('2025-11-28 10:08:30','2025-11-28 10:08:30','2025-11-28 10:08:30',1,553,'98db4ce2-05b9-4799-a8ee-4cba3284e69c',144,'708e5a4db87c470c994eb117a4c58083','groups',1,'2025-11-29 10:08:30',NULL),('2025-11-28 10:08:30','2025-11-28 10:08:30','2025-11-28 10:08:30',1,554,'69815baf-be36-460a-b41b-91fcff231c67',151,'b1155d9e62f747aab975f341b5b53a22','groups',1,'2025-11-29 10:08:30',NULL),('2025-11-28 10:08:30','2025-11-28 10:08:30','2025-11-28 10:08:30',1,555,'4a9ed736-e62f-414c-a927-6325ad10251d',152,'79cbcb0957f54ef09645577668ab7937','volumes',1,'2025-11-29 10:08:30',NULL),('2025-11-28 10:08:30','2025-11-28 10:08:30','2025-11-28 10:08:30',1,556,'26081f1a-b714-4826-b89f-75419969db57',153,'79cbcb0957f54ef09645577668ab7937','gigabytes',2,'2025-11-29 10:08:30',NULL),('2025-11-28 10:08:30','2025-11-28 10:08:30','2025-11-28 10:08:30',1,557,'0d3306f0-a79d-4c52-89b1-f5fb0f36a5dc',154,'79cbcb0957f54ef09645577668ab7937','volumes_tripleo',1,'2025-11-29 10:08:30',NULL),('2025-11-28 10:08:30','2025-11-28 10:08:30','2025-11-28 10:08:30',1,558,'2c5f03d7-990f-4fd7-b31b-5561a667dae4',155,'79cbcb0957f54ef09645577668ab7937','gigabytes_tripleo',2,'2025-11-29 10:08:30',NULL),('2025-11-28 10:08:31','2025-11-28 10:08:31','2025-11-28 10:08:31',1,559,'e6fbd1fb-e96c-4283-88a8-2143f4dd948e',156,'a6f735cf317e42218560e5eb75b569f6','volumes',1,'2025-11-29 10:08:31',NULL),('2025-11-28 10:08:31','2025-11-28 10:08:31','2025-11-28 10:08:31',1,560,'0252d1ff-1054-4af6-bcd2-307d3299f221',157,'a6f735cf317e42218560e5eb75b569f6','gigabytes',1,'2025-11-29 10:08:31',NULL),('2025-11-28 10:08:31','2025-11-28 10:08:31','2025-11-28 10:08:31',1,561,'3105e51e-3ae8-4445-a02e-c0922d34a5bc',158,'a6f735cf317e42218560e5eb75b569f6','volumes_tripleo',1,'2025-11-29 10:08:31',NULL),('2025-11-28 10:08:31','2025-11-28 10:08:31','2025-11-28 10:08:31',1,562,'49459d89-0a5c-4edb-a6d7-c367540c5021',159,'a6f735cf317e42218560e5eb75b569f6','gigabytes_tripleo',1,'2025-11-29 10:08:31',NULL),('2025-11-28 10:08:31','2025-11-28 10:08:31','2025-11-28 10:08:31',1,563,'79f465cd-24a2-485e-b1b1-525872d03e42',145,'708e5a4db87c470c994eb117a4c58083','volumes',1,'2025-11-29 10:08:31',NULL),('2025-11-28 10:08:31','2025-11-28 10:08:31','2025-11-28 10:08:31',1,564,'0d031256-4b4f-4958-8a42-b13b82690a89',146,'708e5a4db87c470c994eb117a4c58083','gigabytes',1,'2025-11-29 10:08:31',NULL),('2025-11-28 10:08:31','2025-11-28 10:08:31','2025-11-28 10:08:31',1,565,'95fdd9b2-3737-4012-98c4-63e5409d0c3f',160,'708e5a4db87c470c994eb117a4c58083','volumes_tempest-GroupsTest-volume-type-541534715',1,'2025-11-29 10:08:31',NULL),('2025-11-28 10:08:31','2025-11-28 10:08:31','2025-11-28 10:08:31',1,566,'c7a2384a-40e5-4d65-8a8b-0298d97ffd0f',161,'708e5a4db87c470c994eb117a4c58083','gigabytes_tempest-GroupsTest-volume-type-541534715',1,'2025-11-29 10:08:31',NULL),('2025-11-28 10:08:32','2025-11-28 10:08:32','2025-11-28 10:08:32',1,567,'634b63e5-c9ff-4f66-868c-a0691a49765d',151,'b1155d9e62f747aab975f341b5b53a22','groups',-1,'2025-11-29 10:08:32',NULL),('2025-11-28 10:08:32','2025-11-28 10:08:32','2025-11-28 10:08:32',1,568,'a87697f0-8045-44d8-9f69-7b6e940cd402',162,'79cbcb0957f54ef09645577668ab7937','snapshots',1,'2025-11-29 10:08:32',NULL),('2025-11-28 10:08:32','2025-11-28 10:08:32','2025-11-28 10:08:32',1,569,'714ed697-1354-46d7-b304-18a3d68e7979',153,'79cbcb0957f54ef09645577668ab7937','gigabytes',2,'2025-11-29 10:08:32',NULL),('2025-11-28 10:08:32','2025-11-28 10:08:32','2025-11-28 10:08:32',1,570,'f40487c9-4b0d-41b2-b65a-51a3573d8a79',155,'79cbcb0957f54ef09645577668ab7937','gigabytes_tripleo',2,'2025-11-29 10:08:32',NULL),('2025-11-28 10:08:32','2025-11-28 10:08:32','2025-11-28 10:08:32',1,571,'8022d9ee-9bb6-4c6f-b161-14edff08a9f7',163,'79cbcb0957f54ef09645577668ab7937','snapshots_tripleo',1,'2025-11-29 10:08:32',NULL),('2025-11-28 10:08:32','2025-11-28 10:08:32','2025-11-28 10:08:32',1,572,'6d1d753a-ab34-4ae9-b0ca-985540cfa8e8',164,'a6f735cf317e42218560e5eb75b569f6','snapshots',1,'2025-11-29 10:08:32',NULL),('2025-11-28 10:08:32','2025-11-28 10:08:32','2025-11-28 10:08:32',1,573,'6ef0e7e8-a852-4905-927a-5d8f9a0bac74',157,'a6f735cf317e42218560e5eb75b569f6','gigabytes',1,'2025-11-29 10:08:32',NULL),('2025-11-28 10:08:32','2025-11-28 10:08:32','2025-11-28 10:08:32',1,574,'104b3e10-cae4-43f0-b63a-e6aadf832aa3',159,'a6f735cf317e42218560e5eb75b569f6','gigabytes_tripleo',1,'2025-11-29 10:08:32',NULL),('2025-11-28 10:08:32','2025-11-28 10:08:32','2025-11-28 10:08:32',1,575,'4f60805c-b780-457c-b416-195ab579c173',165,'a6f735cf317e42218560e5eb75b569f6','snapshots_tripleo',1,'2025-11-29 10:08:32',NULL),('2025-11-28 10:08:32','2025-11-28 10:08:32','2025-11-28 10:08:32',1,576,'73978a1c-b86d-4cb2-91d2-5485a25e876e',149,'6732fa86445147cdb019a2189d601a62','snapshots',-1,'2025-11-29 10:08:32',NULL),('2025-11-28 10:08:32','2025-11-28 10:08:32','2025-11-28 10:08:32',1,577,'24ce5f83-1456-4750-82b3-3e370112e8ca',129,'6732fa86445147cdb019a2189d601a62','gigabytes',-1,'2025-11-29 10:08:32',NULL),('2025-11-28 10:08:32','2025-11-28 10:08:32','2025-11-28 10:08:32',1,578,'4f078b50-4b2b-40a4-b7cc-1008126e5186',131,'6732fa86445147cdb019a2189d601a62','gigabytes_tripleo',-1,'2025-11-29 10:08:32',NULL),('2025-11-28 10:08:32','2025-11-28 10:08:32','2025-11-28 10:08:32',1,579,'bf471dd0-c09c-4b5b-bf71-328a1aacb700',150,'6732fa86445147cdb019a2189d601a62','snapshots_tripleo',-1,'2025-11-29 10:08:32',NULL),('2025-11-28 10:08:32','2025-11-28 10:08:32','2025-11-28 10:08:32',1,580,'97936b5f-1461-46c3-98d8-d2b3713a3d8a',145,'708e5a4db87c470c994eb117a4c58083','volumes',1,'2025-11-29 10:08:32',NULL),('2025-11-28 10:08:32','2025-11-28 10:08:32','2025-11-28 10:08:32',1,581,'a273e7ca-8de3-4fa2-b2bd-f68fdedf9cb2',146,'708e5a4db87c470c994eb117a4c58083','gigabytes',1,'2025-11-29 10:08:32',NULL),('2025-11-28 10:08:32','2025-11-28 10:08:32','2025-11-28 10:08:32',1,582,'6139d4ba-23ce-446a-96de-a2526ba8360b',160,'708e5a4db87c470c994eb117a4c58083','volumes_tempest-GroupsTest-volume-type-541534715',1,'2025-11-29 10:08:32',NULL),('2025-11-28 10:08:32','2025-11-28 10:08:32','2025-11-28 10:08:32',1,583,'5e427bda-92e1-482e-a313-68ab9dad710e',161,'708e5a4db87c470c994eb117a4c58083','gigabytes_tempest-GroupsTest-volume-type-541534715',1,'2025-11-29 10:08:32',NULL),('2025-11-28 10:08:33','2025-11-28 10:08:34','2025-11-28 10:08:34',1,584,'0da37e37-bcd0-44fd-b48e-77925cd6de73',128,'6732fa86445147cdb019a2189d601a62','volumes',-1,'2025-11-29 10:08:33',NULL),('2025-11-28 10:08:33','2025-11-28 10:08:34','2025-11-28 10:08:34',1,585,'d9e0963e-ce19-4245-afee-cced06d21556',129,'6732fa86445147cdb019a2189d601a62','gigabytes',-2,'2025-11-29 10:08:33',NULL),('2025-11-28 10:08:33','2025-11-28 10:08:34','2025-11-28 10:08:34',1,586,'8f968285-503b-4b33-a6fc-242489e50b35',130,'6732fa86445147cdb019a2189d601a62','volumes_tripleo',-1,'2025-11-29 10:08:33',NULL),('2025-11-28 10:08:33','2025-11-28 10:08:34','2025-11-28 10:08:34',1,587,'313b59dd-486f-43b5-a9c3-6d7703b1c2c5',131,'6732fa86445147cdb019a2189d601a62','gigabytes_tripleo',-2,'2025-11-29 10:08:33',NULL),('2025-11-28 10:08:34','2025-11-28 10:08:34','2025-11-28 10:08:34',1,588,'35a5216c-4e88-452a-9b89-720e2f26df39',162,'79cbcb0957f54ef09645577668ab7937','snapshots',-1,'2025-11-29 10:08:34',NULL),('2025-11-28 10:08:34','2025-11-28 10:08:34','2025-11-28 10:08:34',1,589,'84164af4-8e94-4130-aee9-aaa49f30e520',153,'79cbcb0957f54ef09645577668ab7937','gigabytes',-2,'2025-11-29 10:08:34',NULL),('2025-11-28 10:08:34','2025-11-28 10:08:34','2025-11-28 10:08:34',1,590,'787be32d-ffa2-4431-a8e6-6636fbed8e47',155,'79cbcb0957f54ef09645577668ab7937','gigabytes_tripleo',-2,'2025-11-29 10:08:34',NULL),('2025-11-28 10:08:34','2025-11-28 10:08:34','2025-11-28 10:08:34',1,591,'d2129edc-00d7-4f53-89ed-f95984574965',163,'79cbcb0957f54ef09645577668ab7937','snapshots_tripleo',-1,'2025-11-29 10:08:34',NULL),('2025-11-28 10:08:35','2025-11-28 10:08:35','2025-11-28 10:08:35',1,592,'3ace24bd-0e97-4366-b7c3-bfeda32ffcff',164,'a6f735cf317e42218560e5eb75b569f6','snapshots',1,'2025-11-29 10:08:35',NULL),('2025-11-28 10:08:35','2025-11-28 10:08:35','2025-11-28 10:08:35',1,593,'ff73f328-2a29-4dd3-b5bd-8514c7dc9db3',157,'a6f735cf317e42218560e5eb75b569f6','gigabytes',1,'2025-11-29 10:08:35',NULL),('2025-11-28 10:08:35','2025-11-28 10:08:35','2025-11-28 10:08:35',1,594,'968621df-7d51-440d-9e40-2900675d8cfe',159,'a6f735cf317e42218560e5eb75b569f6','gigabytes_tripleo',1,'2025-11-29 10:08:35',NULL),('2025-11-28 10:08:35','2025-11-28 10:08:35','2025-11-28 10:08:35',1,595,'0b0c6ed5-298a-4bee-ad83-7e352009332a',165,'a6f735cf317e42218560e5eb75b569f6','snapshots_tripleo',1,'2025-11-29 10:08:35',NULL),('2025-11-28 10:08:36','2025-11-28 10:08:36','2025-11-28 10:08:36',1,596,'5783e72e-b3bb-44f5-bbca-2530dfcd61ad',152,'79cbcb0957f54ef09645577668ab7937','volumes',-1,'2025-11-29 10:08:36',NULL),('2025-11-28 10:08:36','2025-11-28 10:08:36','2025-11-28 10:08:36',1,597,'1aed1b2b-23ca-45a0-8a8d-3ec60542afe8',153,'79cbcb0957f54ef09645577668ab7937','gigabytes',-2,'2025-11-29 10:08:36',NULL),('2025-11-28 10:08:36','2025-11-28 10:08:36','2025-11-28 10:08:36',1,598,'b8409cef-f823-4316-8c14-bce3d58012f3',154,'79cbcb0957f54ef09645577668ab7937','volumes_tripleo',-1,'2025-11-29 10:08:36',NULL),('2025-11-28 10:08:36','2025-11-28 10:08:36','2025-11-28 10:08:36',1,599,'da172280-a7c1-4c82-a65e-df00fc2548ba',155,'79cbcb0957f54ef09645577668ab7937','gigabytes_tripleo',-2,'2025-11-29 10:08:36',NULL),('2025-11-28 10:08:37','2025-11-28 10:08:37','2025-11-28 10:08:37',1,600,'3838a615-d236-42f5-ae92-2fed83c2a033',164,'a6f735cf317e42218560e5eb75b569f6','snapshots',-1,'2025-11-29 10:08:37',NULL),('2025-11-28 10:08:37','2025-11-28 10:08:37','2025-11-28 10:08:37',1,601,'25cdff0d-4039-40d2-ac59-9e8ef8bab00e',157,'a6f735cf317e42218560e5eb75b569f6','gigabytes',-1,'2025-11-29 10:08:37',NULL),('2025-11-28 10:08:37','2025-11-28 10:08:37','2025-11-28 10:08:37',1,602,'0ab9961d-5977-4c70-8143-331ef492e646',159,'a6f735cf317e42218560e5eb75b569f6','gigabytes_tripleo',-1,'2025-11-29 10:08:37',NULL),('2025-11-28 10:08:37','2025-11-28 10:08:37','2025-11-28 10:08:37',1,603,'eff9b506-a890-460b-a851-71398c559c38',165,'a6f735cf317e42218560e5eb75b569f6','snapshots_tripleo',-1,'2025-11-29 10:08:37',NULL),('2025-11-28 10:08:37','2025-11-28 10:08:38','2025-11-28 10:08:38',1,604,'41a5f5d4-3fb1-4718-8f2b-293025023fc7',144,'708e5a4db87c470c994eb117a4c58083','groups',-1,'2025-11-29 10:08:37',NULL),('2025-11-28 10:08:37','2025-11-28 10:08:38','2025-11-28 10:08:38',1,605,'48aebfa4-2924-41d5-a1b9-e76528060d05',145,'708e5a4db87c470c994eb117a4c58083','volumes',-1,'2025-11-29 10:08:37',NULL),('2025-11-28 10:08:37','2025-11-28 10:08:38','2025-11-28 10:08:38',1,606,'610bd6e4-eaf1-432e-9574-cc81cdda0531',146,'708e5a4db87c470c994eb117a4c58083','gigabytes',-1,'2025-11-29 10:08:37',NULL),('2025-11-28 10:08:37','2025-11-28 10:08:38','2025-11-28 10:08:38',1,607,'247b57e3-5018-436b-ac61-53fa10c4a7e4',160,'708e5a4db87c470c994eb117a4c58083','volumes_tempest-GroupsTest-volume-type-541534715',-1,'2025-11-29 10:08:37',NULL),('2025-11-28 10:08:37','2025-11-28 10:08:38','2025-11-28 10:08:38',1,608,'01ff59b8-4f3c-4fcf-801a-04e353391c5c',161,'708e5a4db87c470c994eb117a4c58083','gigabytes_tempest-GroupsTest-volume-type-541534715',-1,'2025-11-29 10:08:37',NULL),('2025-11-28 10:08:38','2025-11-28 10:08:38','2025-11-28 10:08:38',1,609,'b21118d7-d3fd-43b2-9f13-cfa07ab5f5c8',145,'708e5a4db87c470c994eb117a4c58083','volumes',-1,'2025-11-29 10:08:38',NULL),('2025-11-28 10:08:38','2025-11-28 10:08:38','2025-11-28 10:08:38',1,610,'e2336038-617c-46ed-ac54-9f1092a3489f',146,'708e5a4db87c470c994eb117a4c58083','gigabytes',-1,'2025-11-29 10:08:38',NULL),('2025-11-28 10:08:38','2025-11-28 10:08:38','2025-11-28 10:08:38',1,611,'b50dbd05-240f-4d9b-bfa3-0191fffca58e',160,'708e5a4db87c470c994eb117a4c58083','volumes_tempest-GroupsTest-volume-type-541534715',-1,'2025-11-29 10:08:38',NULL),('2025-11-28 10:08:38','2025-11-28 10:08:38','2025-11-28 10:08:38',1,612,'74192a3a-c563-420b-9ac1-d1263b20c806',161,'708e5a4db87c470c994eb117a4c58083','gigabytes_tempest-GroupsTest-volume-type-541534715',-1,'2025-11-29 10:08:38',NULL),('2025-11-28 10:08:38','2025-11-28 10:08:38','2025-11-28 10:08:38',1,613,'6ca2cf35-0101-4a02-8be4-c758aecc9baa',164,'a6f735cf317e42218560e5eb75b569f6','snapshots',1,'2025-11-29 10:08:38',NULL),('2025-11-28 10:08:38','2025-11-28 10:08:38','2025-11-28 10:08:38',1,614,'ee8cd144-56b0-45e8-8bf1-880316779d7b',157,'a6f735cf317e42218560e5eb75b569f6','gigabytes',1,'2025-11-29 10:08:38',NULL),('2025-11-28 10:08:38','2025-11-28 10:08:38','2025-11-28 10:08:38',1,615,'223f5a9b-60ab-4ec2-9f4f-79ad15c59520',159,'a6f735cf317e42218560e5eb75b569f6','gigabytes_tripleo',1,'2025-11-29 10:08:38',NULL),('2025-11-28 10:08:38','2025-11-28 10:08:38','2025-11-28 10:08:38',1,616,'3589d777-c0b8-40d8-aecd-9d3579619b23',165,'a6f735cf317e42218560e5eb75b569f6','snapshots_tripleo',1,'2025-11-29 10:08:38',NULL),('2025-11-28 10:08:40','2025-11-28 10:08:40','2025-11-28 10:08:40',1,617,'f93a1080-311a-4290-a6a2-55c53836cd32',164,'a6f735cf317e42218560e5eb75b569f6','snapshots',-1,'2025-11-29 10:08:40',NULL),('2025-11-28 10:08:40','2025-11-28 10:08:40','2025-11-28 10:08:40',1,618,'50b396b4-b3b0-4b56-af79-9260c1ee1de8',157,'a6f735cf317e42218560e5eb75b569f6','gigabytes',-1,'2025-11-29 10:08:40',NULL),('2025-11-28 10:08:40','2025-11-28 10:08:40','2025-11-28 10:08:40',1,619,'46ff9c0c-242e-42e1-ae3c-0356a08d1582',159,'a6f735cf317e42218560e5eb75b569f6','gigabytes_tripleo',-1,'2025-11-29 10:08:40',NULL),('2025-11-28 10:08:40','2025-11-28 10:08:40','2025-11-28 10:08:40',1,620,'2557c17b-1af5-4098-b431-e45352814663',165,'a6f735cf317e42218560e5eb75b569f6','snapshots_tripleo',-1,'2025-11-29 10:08:40',NULL),('2025-11-28 10:08:41','2025-11-28 10:08:41','2025-11-28 10:08:41',1,621,'8ad9f3c5-2d08-410d-9268-2804f549e721',164,'a6f735cf317e42218560e5eb75b569f6','snapshots',1,'2025-11-29 10:08:41',NULL),('2025-11-28 10:08:41','2025-11-28 10:08:41','2025-11-28 10:08:41',1,622,'0184ebc9-6539-4c9d-8ff3-9807a9ebd24c',157,'a6f735cf317e42218560e5eb75b569f6','gigabytes',1,'2025-11-29 10:08:41',NULL),('2025-11-28 10:08:41','2025-11-28 10:08:41','2025-11-28 10:08:41',1,623,'41b4bd05-b031-49f8-9e55-eafc71ad30cc',159,'a6f735cf317e42218560e5eb75b569f6','gigabytes_tripleo',1,'2025-11-29 10:08:41',NULL),('2025-11-28 10:08:41','2025-11-28 10:08:41','2025-11-28 10:08:41',1,624,'8ee64b60-4dd8-4052-82e7-d4c140042b79',165,'a6f735cf317e42218560e5eb75b569f6','snapshots_tripleo',1,'2025-11-29 10:08:41',NULL),('2025-11-28 10:08:44','2025-11-28 10:08:44','2025-11-28 10:08:44',1,625,'cbee3edd-66e9-433c-b248-10f4b6b2b948',164,'a6f735cf317e42218560e5eb75b569f6','snapshots',-1,'2025-11-29 10:08:44',NULL),('2025-11-28 10:08:44','2025-11-28 10:08:44','2025-11-28 10:08:44',1,626,'81fc4c0b-731c-4577-b89e-a63f9a07d367',157,'a6f735cf317e42218560e5eb75b569f6','gigabytes',-1,'2025-11-29 10:08:44',NULL),('2025-11-28 10:08:44','2025-11-28 10:08:44','2025-11-28 10:08:44',1,627,'87793d2e-ede3-4918-b234-504594ed744c',159,'a6f735cf317e42218560e5eb75b569f6','gigabytes_tripleo',-1,'2025-11-29 10:08:44',NULL),('2025-11-28 10:08:44','2025-11-28 10:08:44','2025-11-28 10:08:44',1,628,'665aa02b-adf6-42de-90f1-192abdaa14fa',165,'a6f735cf317e42218560e5eb75b569f6','snapshots_tripleo',-1,'2025-11-29 10:08:44',NULL),('2025-11-28 10:08:45','2025-11-28 10:08:45','2025-11-28 10:08:45',1,629,'f2ac2166-9872-42e2-b10a-ace8bafeb360',164,'a6f735cf317e42218560e5eb75b569f6','snapshots',1,'2025-11-29 10:08:45',NULL),('2025-11-28 10:08:45','2025-11-28 10:08:45','2025-11-28 10:08:45',1,630,'608dd475-b7ec-4a09-91d4-2a8c782a2adb',157,'a6f735cf317e42218560e5eb75b569f6','gigabytes',1,'2025-11-29 10:08:45',NULL),('2025-11-28 10:08:45','2025-11-28 10:08:45','2025-11-28 10:08:45',1,631,'ad73dbaf-503d-468f-b0f6-4bf50be4275e',159,'a6f735cf317e42218560e5eb75b569f6','gigabytes_tripleo',1,'2025-11-29 10:08:45',NULL),('2025-11-28 10:08:45','2025-11-28 10:08:45','2025-11-28 10:08:45',1,632,'17895185-0d32-4adc-863f-435e1480dc4e',165,'a6f735cf317e42218560e5eb75b569f6','snapshots_tripleo',1,'2025-11-29 10:08:45',NULL),('2025-11-28 10:08:47','2025-11-28 10:08:47','2025-11-28 10:08:47',1,633,'fbed6272-bef1-4b86-94a5-0cebc52c111c',164,'a6f735cf317e42218560e5eb75b569f6','snapshots',-1,'2025-11-29 10:08:47',NULL),('2025-11-28 10:08:47','2025-11-28 10:08:47','2025-11-28 10:08:47',1,634,'11a947f5-f2c7-4038-bd89-a2811ca09f5d',157,'a6f735cf317e42218560e5eb75b569f6','gigabytes',-1,'2025-11-29 10:08:47',NULL),('2025-11-28 10:08:47','2025-11-28 10:08:47','2025-11-28 10:08:47',1,635,'a666d1aa-a7cd-40c2-b494-5853e1a11c6f',159,'a6f735cf317e42218560e5eb75b569f6','gigabytes_tripleo',-1,'2025-11-29 10:08:47',NULL),('2025-11-28 10:08:47','2025-11-28 10:08:47','2025-11-28 10:08:47',1,636,'e47d2789-4d5b-45ae-9233-ecbe6ab77ee6',165,'a6f735cf317e42218560e5eb75b569f6','snapshots_tripleo',-1,'2025-11-29 10:08:47',NULL),('2025-11-28 10:08:49','2025-11-28 10:08:49','2025-11-28 10:08:49',1,637,'19b24b20-e817-491d-b477-30668e8ac8a4',166,'282cf5c7f55f44abb1217a52fa10743f','volumes',1,'2025-11-29 10:08:49',NULL),('2025-11-28 10:08:49','2025-11-28 10:08:49','2025-11-28 10:08:49',1,638,'76015d83-3175-406a-9303-84e92d752728',167,'282cf5c7f55f44abb1217a52fa10743f','gigabytes',1,'2025-11-29 10:08:49',NULL),('2025-11-28 10:08:49','2025-11-28 10:08:49','2025-11-28 10:08:49',1,639,'c86d8678-822d-4ddd-a15a-69ea5ba78650',168,'282cf5c7f55f44abb1217a52fa10743f','volumes_tripleo',1,'2025-11-29 10:08:49',NULL),('2025-11-28 10:08:49','2025-11-28 10:08:49','2025-11-28 10:08:49',1,640,'62d79bfc-c5c5-4426-bc20-7d626040c577',169,'282cf5c7f55f44abb1217a52fa10743f','gigabytes_tripleo',1,'2025-11-29 10:08:49',NULL),('2025-11-28 10:08:49','2025-11-28 10:08:49','2025-11-28 10:08:49',1,641,'6ff8015c-d64c-4261-a883-57f099c6a7b1',164,'a6f735cf317e42218560e5eb75b569f6','snapshots',-1,'2025-11-29 10:08:49',NULL),('2025-11-28 10:08:49','2025-11-28 10:08:49','2025-11-28 10:08:49',1,642,'456a3449-57ce-4f07-a855-170bc198e4b9',157,'a6f735cf317e42218560e5eb75b569f6','gigabytes',-1,'2025-11-29 10:08:49',NULL),('2025-11-28 10:08:49','2025-11-28 10:08:49','2025-11-28 10:08:49',1,643,'e041faeb-4eac-47c8-8f8d-fbb530bce9cb',159,'a6f735cf317e42218560e5eb75b569f6','gigabytes_tripleo',-1,'2025-11-29 10:08:49',NULL),('2025-11-28 10:08:49','2025-11-28 10:08:49','2025-11-28 10:08:49',1,644,'b07852e9-52ba-4c9a-b75b-bb9a167197c8',165,'a6f735cf317e42218560e5eb75b569f6','snapshots_tripleo',-1,'2025-11-29 10:08:49',NULL),('2025-11-28 10:08:50','2025-11-28 10:08:50','2025-11-28 10:08:50',1,645,'49d98833-f772-4a6a-9c55-c36057e65def',156,'a6f735cf317e42218560e5eb75b569f6','volumes',-1,'2025-11-29 10:08:50',NULL),('2025-11-28 10:08:50','2025-11-28 10:08:50','2025-11-28 10:08:50',1,646,'f095a174-919f-455d-9ad7-867730341759',157,'a6f735cf317e42218560e5eb75b569f6','gigabytes',-1,'2025-11-29 10:08:50',NULL),('2025-11-28 10:08:50','2025-11-28 10:08:50','2025-11-28 10:08:50',1,647,'b933d852-89bd-45b0-b38e-3ff5dc01fc46',158,'a6f735cf317e42218560e5eb75b569f6','volumes_tripleo',-1,'2025-11-29 10:08:50',NULL),('2025-11-28 10:08:50','2025-11-28 10:08:50','2025-11-28 10:08:50',1,648,'4392c9f8-a2af-43c6-8bf4-c18e7b886816',159,'a6f735cf317e42218560e5eb75b569f6','gigabytes_tripleo',-1,'2025-11-29 10:08:50',NULL),('2025-11-28 10:08:50','2025-11-28 10:08:50','2025-11-28 10:08:50',1,649,'73c83253-451c-43af-8a6e-67c00ae9af54',170,'e7cc91f8f0484d558c7d91f23a229370','volumes',1,'2025-11-29 10:08:50',NULL),('2025-11-28 10:08:50','2025-11-28 10:08:50','2025-11-28 10:08:50',1,650,'be366d66-f5d2-42db-a41a-3fe9df6505be',171,'e7cc91f8f0484d558c7d91f23a229370','gigabytes',1,'2025-11-29 10:08:50',NULL),('2025-11-28 10:08:50','2025-11-28 10:08:50','2025-11-28 10:08:50',1,651,'c0336d2a-d66e-4e06-823e-20d809c9a24a',172,'e7cc91f8f0484d558c7d91f23a229370','volumes_tripleo',1,'2025-11-29 10:08:50',NULL),('2025-11-28 10:08:50','2025-11-28 10:08:50','2025-11-28 10:08:50',1,652,'f4506f5e-1750-4d15-ad74-7000f292dff5',173,'e7cc91f8f0484d558c7d91f23a229370','gigabytes_tripleo',1,'2025-11-29 10:08:50',NULL),('2025-11-28 10:08:50','2025-11-28 10:08:51','2025-11-28 10:08:51',1,653,'69d64057-5584-41f6-8cae-5291a43863ef',166,'282cf5c7f55f44abb1217a52fa10743f','volumes',-1,'2025-11-29 10:08:50',NULL),('2025-11-28 10:08:50','2025-11-28 10:08:51','2025-11-28 10:08:51',1,654,'aebcbbcc-04cd-463b-b495-67d9b768f9e3',167,'282cf5c7f55f44abb1217a52fa10743f','gigabytes',-1,'2025-11-29 10:08:50',NULL),('2025-11-28 10:08:50','2025-11-28 10:08:51','2025-11-28 10:08:51',1,655,'0b4c3612-1982-4042-b996-6b247f7f382a',168,'282cf5c7f55f44abb1217a52fa10743f','volumes_tripleo',-1,'2025-11-29 10:08:50',NULL),('2025-11-28 10:08:50','2025-11-28 10:08:51','2025-11-28 10:08:51',1,656,'f636e7f2-19dc-4e4e-9034-e853a54a5966',169,'282cf5c7f55f44abb1217a52fa10743f','gigabytes_tripleo',-1,'2025-11-29 10:08:50',NULL),('2025-11-28 10:08:50','2025-11-28 10:08:50','2025-11-28 10:08:50',1,657,'d0fca186-bf10-4f9b-bfcc-02abb3bdd11d',174,'e7cc91f8f0484d558c7d91f23a229370','snapshots',0,'2025-11-29 10:08:50',NULL),('2025-11-28 10:08:50','2025-11-28 10:08:50','2025-11-28 10:08:50',1,658,'bc33f126-f5ce-4374-9d79-103d7ee85125',171,'e7cc91f8f0484d558c7d91f23a229370','gigabytes',0,'2025-11-29 10:08:50',NULL),('2025-11-28 10:08:50','2025-11-28 10:08:50','2025-11-28 10:08:50',1,659,'7482b824-a5ed-4bf0-a978-7ec1b1f69fe4',173,'e7cc91f8f0484d558c7d91f23a229370','gigabytes_tripleo',0,'2025-11-29 10:08:50',NULL),('2025-11-28 10:08:50','2025-11-28 10:08:50','2025-11-28 10:08:50',1,660,'07813e03-04c0-4f08-ad08-fba268dacef0',175,'e7cc91f8f0484d558c7d91f23a229370','snapshots_tripleo',0,'2025-11-29 10:08:50',NULL),('2025-11-28 10:08:50','2025-11-28 10:08:51','2025-11-28 10:08:51',1,661,'8d3fda16-9b94-4def-9c4a-827d2ac5e92b',176,'282cf5c7f55f44abb1217a52fa10743f','snapshots',0,'2025-11-29 10:08:50',NULL),('2025-11-28 10:08:50','2025-11-28 10:08:51','2025-11-28 10:08:51',1,662,'386208f7-f0d7-4c60-b3be-a677ea57f7b4',167,'282cf5c7f55f44abb1217a52fa10743f','gigabytes',0,'2025-11-29 10:08:50',NULL),('2025-11-28 10:08:50','2025-11-28 10:08:51','2025-11-28 10:08:51',1,663,'60d48506-b199-42bd-ba70-a0dc103f4ce3',169,'282cf5c7f55f44abb1217a52fa10743f','gigabytes_tripleo',0,'2025-11-29 10:08:50',NULL),('2025-11-28 10:08:50','2025-11-28 10:08:51','2025-11-28 10:08:51',1,664,'4ec30354-7283-4d70-abc0-09870952dcd4',177,'282cf5c7f55f44abb1217a52fa10743f','snapshots_tripleo',0,'2025-11-29 10:08:50',NULL),('2025-11-28 10:08:51','2025-11-28 10:08:51','2025-11-28 10:08:51',1,665,'0e7ad394-6979-4326-8792-6bc3b1e6aa5f',170,'e7cc91f8f0484d558c7d91f23a229370','volumes',-1,'2025-11-29 10:08:51',NULL),('2025-11-28 10:08:51','2025-11-28 10:08:51','2025-11-28 10:08:51',1,666,'9a7fb7f5-18dc-4ef3-b591-238ecb64e693',171,'e7cc91f8f0484d558c7d91f23a229370','gigabytes',-1,'2025-11-29 10:08:51',NULL),('2025-11-28 10:08:51','2025-11-28 10:08:51','2025-11-28 10:08:51',1,667,'2b8b3e71-c592-499b-9f9a-8320e9c3dc43',172,'e7cc91f8f0484d558c7d91f23a229370','volumes_tripleo',-1,'2025-11-29 10:08:51',NULL),('2025-11-28 10:08:51','2025-11-28 10:08:51','2025-11-28 10:08:51',1,668,'96704a24-d212-41d2-aa54-e6532b4b5057',173,'e7cc91f8f0484d558c7d91f23a229370','gigabytes_tripleo',-1,'2025-11-29 10:08:51',NULL),('2025-11-28 10:08:52','2025-11-28 10:08:52','2025-11-28 10:08:52',1,669,'9008743d-0650-4b7a-93dd-e237fa39086f',166,'282cf5c7f55f44abb1217a52fa10743f','volumes',1,'2025-11-29 10:08:52',NULL),('2025-11-28 10:08:52','2025-11-28 10:08:52','2025-11-28 10:08:52',1,670,'39b8cf4e-5e95-4dfd-b8b9-0d57e392fd1e',167,'282cf5c7f55f44abb1217a52fa10743f','gigabytes',1,'2025-11-29 10:08:52',NULL),('2025-11-28 10:08:52','2025-11-28 10:08:52','2025-11-28 10:08:52',1,671,'e64ea0de-e976-45c1-8b22-b301ce0c3f09',168,'282cf5c7f55f44abb1217a52fa10743f','volumes_tripleo',1,'2025-11-29 10:08:52',NULL),('2025-11-28 10:08:52','2025-11-28 10:08:52','2025-11-28 10:08:52',1,672,'2288680e-5f2d-473a-8024-702123665ba6',169,'282cf5c7f55f44abb1217a52fa10743f','gigabytes_tripleo',1,'2025-11-29 10:08:52',NULL),('2025-11-28 10:08:54','2025-11-28 10:08:54','2025-11-28 10:08:54',1,673,'b5fa3e77-484d-46a6-8fc1-c6cf903da0ea',166,'282cf5c7f55f44abb1217a52fa10743f','volumes',-1,'2025-11-29 10:08:54',NULL),('2025-11-28 10:08:54','2025-11-28 10:08:54','2025-11-28 10:08:54',1,674,'b5a8ce85-86fc-4d59-a895-bda3ef156a82',167,'282cf5c7f55f44abb1217a52fa10743f','gigabytes',-1,'2025-11-29 10:08:54',NULL),('2025-11-28 10:08:54','2025-11-28 10:08:54','2025-11-28 10:08:54',1,675,'d2cbe237-e7fd-44cb-92cf-000377114ff2',168,'282cf5c7f55f44abb1217a52fa10743f','volumes_tripleo',-1,'2025-11-29 10:08:54',NULL),('2025-11-28 10:08:54','2025-11-28 10:08:54','2025-11-28 10:08:54',1,676,'aef14bc4-4d93-481b-930b-2fe9de2862fb',169,'282cf5c7f55f44abb1217a52fa10743f','gigabytes_tripleo',-1,'2025-11-29 10:08:54',NULL),('2025-11-28 10:08:55','2025-11-28 10:08:55','2025-11-28 10:08:55',1,677,'263a5707-827e-4d3b-987b-ac84e53e2bd2',178,'af627bb6800b48f795f524c5240dd96e','volumes',1,'2025-11-29 10:08:55',NULL),('2025-11-28 10:08:55','2025-11-28 10:08:55','2025-11-28 10:08:55',1,678,'3d59df43-d158-47bd-9381-76f10ff62a79',179,'af627bb6800b48f795f524c5240dd96e','gigabytes',1,'2025-11-29 10:08:55',NULL),('2025-11-28 10:08:55','2025-11-28 10:08:55','2025-11-28 10:08:55',1,679,'cda26ff0-b901-423c-81f6-ed0a27a8ad30',180,'af627bb6800b48f795f524c5240dd96e','volumes_tripleo',1,'2025-11-29 10:08:55',NULL),('2025-11-28 10:08:55','2025-11-28 10:08:55','2025-11-28 10:08:55',1,680,'83b87235-b778-4f80-92c8-4b229138e46b',181,'af627bb6800b48f795f524c5240dd96e','gigabytes_tripleo',1,'2025-11-29 10:08:55',NULL),('2025-11-28 10:08:57','2025-11-28 10:08:57','2025-11-28 10:08:57',1,681,'bd9ae2c0-6836-4019-b03b-c46517ef70ba',178,'af627bb6800b48f795f524c5240dd96e','volumes',1,'2025-11-29 10:08:57',NULL),('2025-11-28 10:08:57','2025-11-28 10:08:57','2025-11-28 10:08:57',1,682,'71ccc79e-207f-450d-96a4-21dda6fc3c33',179,'af627bb6800b48f795f524c5240dd96e','gigabytes',1,'2025-11-29 10:08:57',NULL),('2025-11-28 10:08:57','2025-11-28 10:08:57','2025-11-28 10:08:57',1,683,'fcde006f-76d4-41ac-8e74-b267d36da716',180,'af627bb6800b48f795f524c5240dd96e','volumes_tripleo',1,'2025-11-29 10:08:57',NULL),('2025-11-28 10:08:57','2025-11-28 10:08:57','2025-11-28 10:08:57',1,684,'61aadf31-6bb1-4063-9d8a-64e24f1948a5',181,'af627bb6800b48f795f524c5240dd96e','gigabytes_tripleo',1,'2025-11-29 10:08:57',NULL),('2025-11-28 10:08:57','2025-11-28 10:08:57','2025-11-28 10:08:57',1,685,'06adb89c-81a6-456e-bedb-d0730fbd4e42',182,'f85d8ffada2842738a1307658c19c621','volumes',1,'2025-11-29 10:08:57',NULL),('2025-11-28 10:08:57','2025-11-28 10:08:57','2025-11-28 10:08:57',1,686,'f9582bd2-ecae-4d32-bc67-f46cc7671e40',183,'f85d8ffada2842738a1307658c19c621','gigabytes',1,'2025-11-29 10:08:57',NULL),('2025-11-28 10:08:57','2025-11-28 10:08:57','2025-11-28 10:08:57',1,687,'d2632284-fcf4-4762-8070-cab821dfdf40',184,'f85d8ffada2842738a1307658c19c621','volumes_tempest-UserMessagesTest-volume-type-537457498',1,'2025-11-29 10:08:57',NULL),('2025-11-28 10:08:57','2025-11-28 10:08:57','2025-11-28 10:08:57',1,688,'7b0a97d4-3d91-4b9b-b522-0b68475ea342',185,'f85d8ffada2842738a1307658c19c621','gigabytes_tempest-UserMessagesTest-volume-type-537457498',1,'2025-11-29 10:08:57',NULL),('2025-11-28 10:08:58','2025-11-28 10:08:58','2025-11-28 10:08:58',1,689,'25d29369-c799-4656-9511-d0b68be929af',178,'af627bb6800b48f795f524c5240dd96e','volumes',1,'2025-11-29 10:08:58',NULL),('2025-11-28 10:08:58','2025-11-28 10:08:58','2025-11-28 10:08:58',1,690,'9dcf20a4-8597-4d88-9636-de4e1c4ceffb',179,'af627bb6800b48f795f524c5240dd96e','gigabytes',1,'2025-11-29 10:08:58',NULL),('2025-11-28 10:08:58','2025-11-28 10:08:58','2025-11-28 10:08:58',1,691,'5a5cee61-05bb-44e4-8aae-0d4a26cc0474',180,'af627bb6800b48f795f524c5240dd96e','volumes_tripleo',1,'2025-11-29 10:08:58',NULL),('2025-11-28 10:08:58','2025-11-28 10:08:58','2025-11-28 10:08:58',1,692,'dffbf950-d1df-4106-b7f0-f0d1f6bbe6bd',181,'af627bb6800b48f795f524c5240dd96e','gigabytes_tripleo',1,'2025-11-29 10:08:58',NULL),('2025-11-28 10:08:58','2025-11-28 10:08:58','2025-11-28 10:08:58',1,693,'7353a8df-beb4-4e91-a354-281e1aa96a0d',182,'f85d8ffada2842738a1307658c19c621','volumes',-1,'2025-11-29 10:08:58',NULL),('2025-11-28 10:08:58','2025-11-28 10:08:58','2025-11-28 10:08:58',1,694,'19b3c6b1-25e8-49e4-80a5-7bbbd88f4976',183,'f85d8ffada2842738a1307658c19c621','gigabytes',-1,'2025-11-29 10:08:58',NULL),('2025-11-28 10:08:58','2025-11-28 10:08:58','2025-11-28 10:08:58',1,695,'9cca87dd-d82b-4f46-bf0a-75bfbf993f92',184,'f85d8ffada2842738a1307658c19c621','volumes_tempest-UserMessagesTest-volume-type-537457498',-1,'2025-11-29 10:08:58',NULL),('2025-11-28 10:08:58','2025-11-28 10:08:58','2025-11-28 10:08:58',1,696,'e129b7d1-dba0-4640-9635-d229d24d1c0d',185,'f85d8ffada2842738a1307658c19c621','gigabytes_tempest-UserMessagesTest-volume-type-537457498',-1,'2025-11-29 10:08:58',NULL),('2025-11-28 10:08:58','2025-11-28 10:08:59','2025-11-28 10:08:59',1,697,'87ee9b30-e733-499f-8e6e-fa3cacfa9967',182,'f85d8ffada2842738a1307658c19c621','volumes',1,'2025-11-29 10:08:58',NULL),('2025-11-28 10:08:59','2025-11-28 10:08:59','2025-11-28 10:08:59',1,698,'fe66dc35-f06e-4a15-8419-32933baa97d7',183,'f85d8ffada2842738a1307658c19c621','gigabytes',1,'2025-11-29 10:08:58',NULL),('2025-11-28 10:08:59','2025-11-28 10:08:59','2025-11-28 10:08:59',1,699,'7ac361b3-ba39-4da9-8954-a74ac7f56eaf',186,'f85d8ffada2842738a1307658c19c621','volumes_tempest-UserMessagesTest-volume-type-1856484675',1,'2025-11-29 10:08:58',NULL),('2025-11-28 10:08:59','2025-11-28 10:08:59','2025-11-28 10:08:59',1,700,'32539c8c-d4f7-48af-9f5a-b876a7dfe6b7',187,'f85d8ffada2842738a1307658c19c621','gigabytes_tempest-UserMessagesTest-volume-type-1856484675',1,'2025-11-29 10:08:58',NULL),('2025-11-28 10:08:59','2025-11-28 10:08:59','2025-11-28 10:08:59',1,701,'3241530d-9f68-4cac-a530-496997b8d779',188,'85b0cd4fbc9547ea80ee82fddaeca666','volumes',1,'2025-11-29 10:08:59',NULL),('2025-11-28 10:08:59','2025-11-28 10:08:59','2025-11-28 10:08:59',1,702,'3dc47fc1-869a-44f9-ba78-23211fd0c81d',189,'85b0cd4fbc9547ea80ee82fddaeca666','gigabytes',1,'2025-11-29 10:08:59',NULL),('2025-11-28 10:08:59','2025-11-28 10:08:59','2025-11-28 10:08:59',1,703,'1d0f79f1-a872-4db3-b79d-dee32828d64f',190,'85b0cd4fbc9547ea80ee82fddaeca666','volumes_tripleo',1,'2025-11-29 10:08:59',NULL),('2025-11-28 10:08:59','2025-11-28 10:09:00','2025-11-28 10:08:59',1,704,'342fdbc7-0f2e-4198-8d8e-6762e7fc4c23',191,'85b0cd4fbc9547ea80ee82fddaeca666','gigabytes_tripleo',1,'2025-11-29 10:08:59',NULL),('2025-11-28 10:09:00','2025-11-28 10:09:00','2025-11-28 10:09:00',1,705,'dcc2ae7f-6945-4311-8188-03066d3746d4',192,'fc7fccbd32a74bc3b7becd3530d9005e','volumes',1,'2025-11-29 10:09:00',NULL),('2025-11-28 10:09:00','2025-11-28 10:09:00','2025-11-28 10:09:00',1,706,'2815acb8-fb5f-4e77-83a4-5990cd985575',193,'fc7fccbd32a74bc3b7becd3530d9005e','gigabytes',1,'2025-11-29 10:09:00',NULL),('2025-11-28 10:09:00','2025-11-28 10:09:00','2025-11-28 10:09:00',1,707,'9521b549-1cff-4ed7-8630-375558dc8102',194,'fc7fccbd32a74bc3b7becd3530d9005e','volumes_tripleo',1,'2025-11-29 10:09:00',NULL),('2025-11-28 10:09:00','2025-11-28 10:09:00','2025-11-28 10:09:00',1,708,'0b1e03da-72b2-4bf7-bbf2-06189caaada1',195,'fc7fccbd32a74bc3b7becd3530d9005e','gigabytes_tripleo',1,'2025-11-29 10:09:00',NULL),('2025-11-28 10:09:00','2025-11-28 10:09:00','2025-11-28 10:09:00',1,709,'a77f6962-f136-488b-a648-0a2a3a8c5de8',182,'f85d8ffada2842738a1307658c19c621','volumes',-1,'2025-11-29 10:09:00',NULL),('2025-11-28 10:09:00','2025-11-28 10:09:00','2025-11-28 10:09:00',1,710,'d51f1c8c-19bb-4fd5-9807-6300c1bdccd2',183,'f85d8ffada2842738a1307658c19c621','gigabytes',-1,'2025-11-29 10:09:00',NULL),('2025-11-28 10:09:00','2025-11-28 10:09:00','2025-11-28 10:09:00',1,711,'2fd830f1-9868-4c27-8b0d-6168ea1ccf82',186,'f85d8ffada2842738a1307658c19c621','volumes_tempest-UserMessagesTest-volume-type-1856484675',-1,'2025-11-29 10:09:00',NULL),('2025-11-28 10:09:00','2025-11-28 10:09:00','2025-11-28 10:09:00',1,712,'c5ca26d5-dd6e-4afd-b0d6-6c974df1576c',187,'f85d8ffada2842738a1307658c19c621','gigabytes_tempest-UserMessagesTest-volume-type-1856484675',-1,'2025-11-29 10:09:00',NULL),('2025-11-28 10:09:01','2025-11-28 10:09:01','2025-11-28 10:09:01',1,713,'b6c7ed83-566e-4ede-80ae-efb87138daef',196,'fc7fccbd32a74bc3b7becd3530d9005e','backups',1,'2025-11-29 10:09:01',NULL),('2025-11-28 10:09:01','2025-11-28 10:09:01','2025-11-28 10:09:01',1,714,'a215b753-778b-4c4e-9f09-1191bebfa8ec',197,'fc7fccbd32a74bc3b7becd3530d9005e','backup_gigabytes',1,'2025-11-29 10:09:01',NULL),('2025-11-28 10:09:01','2025-11-28 10:09:01','2025-11-28 10:09:01',1,715,'64da5197-c87c-4738-9781-2b29e6e2ba72',188,'85b0cd4fbc9547ea80ee82fddaeca666','volumes',-1,'2025-11-29 10:09:01',NULL),('2025-11-28 10:09:01','2025-11-28 10:09:01','2025-11-28 10:09:01',1,716,'503c5103-c83a-47c3-a6ab-ac786c86cca3',189,'85b0cd4fbc9547ea80ee82fddaeca666','gigabytes',-1,'2025-11-29 10:09:01',NULL),('2025-11-28 10:09:01','2025-11-28 10:09:01','2025-11-28 10:09:01',1,717,'1217a47b-f1d5-4a2c-96f8-74e19bf9aa4c',190,'85b0cd4fbc9547ea80ee82fddaeca666','volumes_tripleo',-1,'2025-11-29 10:09:01',NULL),('2025-11-28 10:09:01','2025-11-28 10:09:01','2025-11-28 10:09:01',1,718,'326c3540-f2c8-4f83-bda6-d1f71bce41b0',191,'85b0cd4fbc9547ea80ee82fddaeca666','gigabytes_tripleo',-1,'2025-11-29 10:09:01',NULL),('2025-11-28 10:09:02','2025-11-28 10:09:02','2025-11-28 10:09:02',1,719,'2ca61aac-75ce-4809-81ae-669211002395',178,'af627bb6800b48f795f524c5240dd96e','volumes',-1,'2025-11-29 10:09:02',NULL),('2025-11-28 10:09:02','2025-11-28 10:09:02','2025-11-28 10:09:02',1,720,'be46bdf4-bf85-49a7-9287-c92d11c2ee17',179,'af627bb6800b48f795f524c5240dd96e','gigabytes',-1,'2025-11-29 10:09:02',NULL),('2025-11-28 10:09:02','2025-11-28 10:09:02','2025-11-28 10:09:02',1,721,'d41ce5d1-308b-4679-ab6c-923a0f103f2b',180,'af627bb6800b48f795f524c5240dd96e','volumes_tripleo',-1,'2025-11-29 10:09:02',NULL),('2025-11-28 10:09:02','2025-11-28 10:09:02','2025-11-28 10:09:02',1,722,'d2d8027b-e286-4c89-b1dd-2140178fc2bf',181,'af627bb6800b48f795f524c5240dd96e','gigabytes_tripleo',-1,'2025-11-29 10:09:02',NULL),('2025-11-28 10:09:03','2025-11-28 10:09:03','2025-11-28 10:09:03',1,723,'eeb84653-63c8-48a8-9f96-9fafe1cbb68e',178,'af627bb6800b48f795f524c5240dd96e','volumes',-1,'2025-11-29 10:09:02',NULL),('2025-11-28 10:09:03','2025-11-28 10:09:03','2025-11-28 10:09:03',1,724,'4556138e-a47d-4792-84d1-a9376aa3a9c6',179,'af627bb6800b48f795f524c5240dd96e','gigabytes',-1,'2025-11-29 10:09:02',NULL),('2025-11-28 10:09:03','2025-11-28 10:09:03','2025-11-28 10:09:03',1,725,'6c1eba5a-3824-45aa-bf49-113c5dada5e6',180,'af627bb6800b48f795f524c5240dd96e','volumes_tripleo',-1,'2025-11-29 10:09:02',NULL),('2025-11-28 10:09:03','2025-11-28 10:09:03','2025-11-28 10:09:03',1,726,'68b8d088-080c-4fd5-8b7f-dbca8a7e26f5',181,'af627bb6800b48f795f524c5240dd96e','gigabytes_tripleo',-1,'2025-11-29 10:09:02',NULL),('2025-11-28 10:09:04','2025-11-28 10:09:04','2025-11-28 10:09:04',1,727,'8b0cba7d-7b4c-4d0f-9b10-b9d4d1e31ce6',178,'af627bb6800b48f795f524c5240dd96e','volumes',-1,'2025-11-29 10:09:04',NULL),('2025-11-28 10:09:04','2025-11-28 10:09:04','2025-11-28 10:09:04',1,728,'1f33a0f3-55cf-442e-95ed-709996fab80e',179,'af627bb6800b48f795f524c5240dd96e','gigabytes',-1,'2025-11-29 10:09:04',NULL),('2025-11-28 10:09:04','2025-11-28 10:09:04','2025-11-28 10:09:04',1,729,'5d72d6db-696b-481c-ae89-36821e47d8a7',180,'af627bb6800b48f795f524c5240dd96e','volumes_tripleo',-1,'2025-11-29 10:09:04',NULL),('2025-11-28 10:09:04','2025-11-28 10:09:04','2025-11-28 10:09:04',1,730,'9618d66a-7494-4b97-a593-dd5281c94dac',181,'af627bb6800b48f795f524c5240dd96e','gigabytes_tripleo',-1,'2025-11-29 10:09:04',NULL),('2025-11-28 10:09:06','2025-11-28 10:09:06','2025-11-28 10:09:06',1,731,'3cad9873-3364-4798-9d5b-de74b9630aa0',196,'fc7fccbd32a74bc3b7becd3530d9005e','backups',-1,'2025-11-29 10:09:06',NULL),('2025-11-28 10:09:06','2025-11-28 10:09:06','2025-11-28 10:09:06',1,732,'f0ffdf2c-7559-4141-8b4e-95e06dadfeef',197,'fc7fccbd32a74bc3b7becd3530d9005e','backup_gigabytes',-1,'2025-11-29 10:09:06',NULL),('2025-11-28 10:09:08','2025-11-28 10:09:08','2025-11-28 10:09:08',1,733,'ab5e33b4-285a-4d45-8701-7b0ddc56e953',192,'fc7fccbd32a74bc3b7becd3530d9005e','volumes',-1,'2025-11-29 10:09:08',NULL),('2025-11-28 10:09:08','2025-11-28 10:09:08','2025-11-28 10:09:08',1,734,'71d78599-55b3-4ff8-9174-e1453defd9ed',193,'fc7fccbd32a74bc3b7becd3530d9005e','gigabytes',-1,'2025-11-29 10:09:08',NULL),('2025-11-28 10:09:08','2025-11-28 10:09:08','2025-11-28 10:09:08',1,735,'faf04b7f-91ba-45b5-a9c3-b4ee3605090d',194,'fc7fccbd32a74bc3b7becd3530d9005e','volumes_tripleo',-1,'2025-11-29 10:09:08',NULL),('2025-11-28 10:09:08','2025-11-28 10:09:08','2025-11-28 10:09:08',1,736,'60b616d5-4a16-41bd-9e7e-49696ad4e82f',195,'fc7fccbd32a74bc3b7becd3530d9005e','gigabytes_tripleo',-1,'2025-11-29 10:09:08',NULL),('2025-11-28 10:09:08','2025-11-28 10:09:08','2025-11-28 10:09:08',1,737,'69038465-91cf-47dc-a8cf-e8c202634411',198,'673b477f9d70449480701aa9846d8f60','volumes',1,'2025-11-29 10:09:08',NULL),('2025-11-28 10:09:08','2025-11-28 10:09:08','2025-11-28 10:09:08',1,738,'3c066bf2-5e20-4531-bcb6-16cc288ef185',199,'673b477f9d70449480701aa9846d8f60','gigabytes',1,'2025-11-29 10:09:08',NULL),('2025-11-28 10:09:08','2025-11-28 10:09:08','2025-11-28 10:09:08',1,739,'9c27b851-9f06-4dcb-9ca8-4346a60b3dd4',200,'673b477f9d70449480701aa9846d8f60','volumes_tripleo',1,'2025-11-29 10:09:08',NULL),('2025-11-28 10:09:08','2025-11-28 10:09:08','2025-11-28 10:09:08',1,740,'a11099ea-3327-4c1d-a69b-7756600e3160',201,'673b477f9d70449480701aa9846d8f60','gigabytes_tripleo',1,'2025-11-29 10:09:08',NULL),('2025-11-28 10:09:10','2025-11-28 10:09:10','2025-11-28 10:09:10',1,741,'c2a0f80f-ec0d-4a89-8597-f9fdacc13e90',202,'6da8102120594d6c98901d137ca0bc9b','volumes',1,'2025-11-29 10:09:10',NULL),('2025-11-28 10:09:10','2025-11-28 10:09:10','2025-11-28 10:09:10',1,742,'6014ac8a-7db7-47bf-9d96-780a9fba5a7f',203,'6da8102120594d6c98901d137ca0bc9b','gigabytes',1,'2025-11-29 10:09:10',NULL),('2025-11-28 10:09:10','2025-11-28 10:09:10','2025-11-28 10:09:10',1,743,'b6d10987-cb4a-4485-8b28-743840ee52d5',204,'6da8102120594d6c98901d137ca0bc9b','volumes_tripleo',1,'2025-11-29 10:09:10',NULL),('2025-11-28 10:09:10','2025-11-28 10:09:10','2025-11-28 10:09:10',1,744,'a65f54b6-3835-4034-b258-ba06aee08ec2',205,'6da8102120594d6c98901d137ca0bc9b','gigabytes_tripleo',1,'2025-11-29 10:09:10',NULL),('2025-11-28 10:09:13','2025-11-28 10:09:13','2025-11-28 10:09:13',1,745,'9c1d8b40-c2d7-447e-9935-f30efde44312',202,'6da8102120594d6c98901d137ca0bc9b','volumes',-1,'2025-11-29 10:09:13',NULL),('2025-11-28 10:09:13','2025-11-28 10:09:13','2025-11-28 10:09:13',1,746,'810b54e4-e181-4f33-a973-4effa3f68738',203,'6da8102120594d6c98901d137ca0bc9b','gigabytes',-1,'2025-11-29 10:09:13',NULL),('2025-11-28 10:09:13','2025-11-28 10:09:13','2025-11-28 10:09:13',1,747,'7faa29b5-2175-451a-a1a5-1db8e351decb',204,'6da8102120594d6c98901d137ca0bc9b','volumes_tripleo',-1,'2025-11-29 10:09:13',NULL),('2025-11-28 10:09:13','2025-11-28 10:09:13','2025-11-28 10:09:13',1,748,'83fa1a33-dcb2-48d7-94c1-64a58f171efe',205,'6da8102120594d6c98901d137ca0bc9b','gigabytes_tripleo',-1,'2025-11-29 10:09:13',NULL),('2025-11-28 10:09:14','2025-11-28 10:09:14','2025-11-28 10:09:14',1,749,'c079b3a5-b35f-4385-b9ca-a3e70c17220c',198,'673b477f9d70449480701aa9846d8f60','volumes',1,'2025-11-29 10:09:14',NULL),('2025-11-28 10:09:14','2025-11-28 10:09:14','2025-11-28 10:09:14',1,750,'1a8ea684-9446-40f0-bbc6-0476fa70005d',199,'673b477f9d70449480701aa9846d8f60','gigabytes',1,'2025-11-29 10:09:14',NULL),('2025-11-28 10:09:14','2025-11-28 10:09:14','2025-11-28 10:09:14',1,751,'c440f32a-668b-4463-b600-5bb506212c11',200,'673b477f9d70449480701aa9846d8f60','volumes_tripleo',1,'2025-11-29 10:09:14',NULL),('2025-11-28 10:09:14','2025-11-28 10:09:14','2025-11-28 10:09:14',1,752,'3eb72baa-0d60-4245-bcde-4e02f0ecd2e8',201,'673b477f9d70449480701aa9846d8f60','gigabytes_tripleo',1,'2025-11-29 10:09:14',NULL),('2025-11-28 10:09:16','2025-11-28 10:09:16','2025-11-28 10:09:16',1,753,'2f45bc97-56f3-48cf-af53-20dc7d865445',198,'673b477f9d70449480701aa9846d8f60','volumes',-1,'2025-11-29 10:09:16',NULL),('2025-11-28 10:09:16','2025-11-28 10:09:16','2025-11-28 10:09:16',1,754,'cdba4559-e254-44a8-81a9-297c49d37c34',199,'673b477f9d70449480701aa9846d8f60','gigabytes',-1,'2025-11-29 10:09:16',NULL),('2025-11-28 10:09:16','2025-11-28 10:09:16','2025-11-28 10:09:16',1,755,'f93f400d-2559-4bc5-a1c0-d8b0c1207b8f',200,'673b477f9d70449480701aa9846d8f60','volumes_tripleo',-1,'2025-11-29 10:09:16',NULL),('2025-11-28 10:09:16','2025-11-28 10:09:16','2025-11-28 10:09:16',1,756,'109e7e2e-458d-4498-94b4-cf957879a529',201,'673b477f9d70449480701aa9846d8f60','gigabytes_tripleo',-1,'2025-11-29 10:09:16',NULL),('2025-11-28 10:09:17','2025-11-28 10:09:17','2025-11-28 10:09:17',1,757,'733cc481-bfd0-48bb-b5dc-186806e06dc9',198,'673b477f9d70449480701aa9846d8f60','volumes',-1,'2025-11-29 10:09:17',NULL),('2025-11-28 10:09:17','2025-11-28 10:09:17','2025-11-28 10:09:17',1,758,'124f5d50-d732-4e7e-bd52-4f8ad01c30f0',199,'673b477f9d70449480701aa9846d8f60','gigabytes',-1,'2025-11-29 10:09:17',NULL),('2025-11-28 10:09:17','2025-11-28 10:09:17','2025-11-28 10:09:17',1,759,'fe5f3663-208c-46d7-b1df-e463a03c9b7f',200,'673b477f9d70449480701aa9846d8f60','volumes_tripleo',-1,'2025-11-29 10:09:17',NULL),('2025-11-28 10:09:17','2025-11-28 10:09:17','2025-11-28 10:09:17',1,760,'a2d958be-2b5a-4aa0-8864-febbc73546ed',201,'673b477f9d70449480701aa9846d8f60','gigabytes_tripleo',-1,'2025-11-29 10:09:17',NULL),('2025-11-28 10:09:17','2025-11-28 10:09:17','2025-11-28 10:09:17',1,761,'dc939053-318d-4730-803d-4b94172001ad',198,'673b477f9d70449480701aa9846d8f60','volumes',1,'2025-11-29 10:09:17',NULL),('2025-11-28 10:09:17','2025-11-28 10:09:17','2025-11-28 10:09:17',1,762,'1cf63414-d7f1-4e35-b95f-4a804ce4fd43',199,'673b477f9d70449480701aa9846d8f60','gigabytes',1,'2025-11-29 10:09:17',NULL),('2025-11-28 10:09:17','2025-11-28 10:09:17','2025-11-28 10:09:17',1,763,'c0b7bc92-690b-4c37-b314-04668083bffe',200,'673b477f9d70449480701aa9846d8f60','volumes_tripleo',1,'2025-11-29 10:09:17',NULL),('2025-11-28 10:09:17','2025-11-28 10:09:17','2025-11-28 10:09:17',1,764,'b83ca73b-669e-4498-a734-a76d06a742d8',201,'673b477f9d70449480701aa9846d8f60','gigabytes_tripleo',1,'2025-11-29 10:09:17',NULL),('2025-11-28 10:09:18','2025-11-28 10:09:18','2025-11-28 10:09:18',1,765,'b7bb5ebb-5fd4-410b-b3f2-ea75af69a7da',206,'e67c42de6de84a6eba7382934e59b9b3','volumes',1,'2025-11-29 10:09:18',NULL),('2025-11-28 10:09:18','2025-11-28 10:09:18','2025-11-28 10:09:18',1,766,'2a0a6477-e136-46f7-a5f8-49f87e051b2c',207,'e67c42de6de84a6eba7382934e59b9b3','gigabytes',1,'2025-11-29 10:09:18',NULL),('2025-11-28 10:09:18','2025-11-28 10:09:18','2025-11-28 10:09:18',1,767,'965ecae8-fa66-468e-8e00-ab769dbfea38',208,'e67c42de6de84a6eba7382934e59b9b3','volumes_tripleo',1,'2025-11-29 10:09:18',NULL),('2025-11-28 10:09:18','2025-11-28 10:09:18','2025-11-28 10:09:18',1,768,'b3412133-559b-4655-851c-f9a306cfb425',209,'e67c42de6de84a6eba7382934e59b9b3','gigabytes_tripleo',1,'2025-11-29 10:09:18',NULL),('2025-11-28 10:09:19','2025-11-28 10:09:19','2025-11-28 10:09:19',1,769,'f024d2a9-31d2-4860-9b0a-9692856893dc',198,'673b477f9d70449480701aa9846d8f60','volumes',1,'2025-11-29 10:09:19',NULL),('2025-11-28 10:09:19','2025-11-28 10:09:19','2025-11-28 10:09:19',1,770,'67c847ef-3d12-41db-9fe2-4cd2534c385e',199,'673b477f9d70449480701aa9846d8f60','gigabytes',2,'2025-11-29 10:09:19',NULL),('2025-11-28 10:09:19','2025-11-28 10:09:19','2025-11-28 10:09:19',1,771,'cdb86bba-5d64-4632-9dca-bbe5bfc4385e',200,'673b477f9d70449480701aa9846d8f60','volumes_tripleo',1,'2025-11-29 10:09:19',NULL),('2025-11-28 10:09:19','2025-11-28 10:09:19','2025-11-28 10:09:19',1,772,'03c0cb57-2147-4dc6-8e48-c98767078254',201,'673b477f9d70449480701aa9846d8f60','gigabytes_tripleo',2,'2025-11-29 10:09:19',NULL),('2025-11-28 10:09:20','2025-11-28 10:09:20','2025-11-28 10:09:20',1,773,'3c4f740c-8b2e-4616-b163-bd954f99834d',210,'e67c42de6de84a6eba7382934e59b9b3','snapshots',1,'2025-11-29 10:09:20',NULL),('2025-11-28 10:09:20','2025-11-28 10:09:20','2025-11-28 10:09:20',1,774,'34537fb9-eef1-4785-9c5e-0582ab1d0c83',207,'e67c42de6de84a6eba7382934e59b9b3','gigabytes',1,'2025-11-29 10:09:20',NULL),('2025-11-28 10:09:20','2025-11-28 10:09:20','2025-11-28 10:09:20',1,775,'70ed1a2d-9321-4f7b-9d8c-20aa8c27cdfd',209,'e67c42de6de84a6eba7382934e59b9b3','gigabytes_tripleo',1,'2025-11-29 10:09:20',NULL),('2025-11-28 10:09:20','2025-11-28 10:09:20','2025-11-28 10:09:20',1,776,'e281a41e-8147-4a57-9d8e-6bde9ed1a531',211,'e67c42de6de84a6eba7382934e59b9b3','snapshots_tripleo',1,'2025-11-29 10:09:20',NULL),('2025-11-28 10:09:20','2025-11-28 10:09:21','2025-11-28 10:09:21',1,777,'e0612e88-1085-4a29-89fe-23ca2f3e219d',198,'673b477f9d70449480701aa9846d8f60','volumes',-1,'2025-11-29 10:09:20',NULL),('2025-11-28 10:09:20','2025-11-28 10:09:21','2025-11-28 10:09:21',1,778,'0a5ce033-c7dd-4632-b138-cb81e00a7770',199,'673b477f9d70449480701aa9846d8f60','gigabytes',-2,'2025-11-29 10:09:20',NULL),('2025-11-28 10:09:20','2025-11-28 10:09:21','2025-11-28 10:09:21',1,779,'ff04d9c1-a518-4118-9cac-e54fffb3ad65',200,'673b477f9d70449480701aa9846d8f60','volumes_tripleo',-1,'2025-11-29 10:09:20',NULL),('2025-11-28 10:09:20','2025-11-28 10:09:21','2025-11-28 10:09:21',1,780,'a04fa7a5-3728-4566-b108-c2c249a4681a',201,'673b477f9d70449480701aa9846d8f60','gigabytes_tripleo',-2,'2025-11-29 10:09:20',NULL),('2025-11-28 10:09:22','2025-11-28 10:09:22','2025-11-28 10:09:22',1,781,'ca1cd8fb-979a-44f1-9eb7-f6683ffa9d6a',198,'673b477f9d70449480701aa9846d8f60','volumes',-1,'2025-11-29 10:09:22',NULL),('2025-11-28 10:09:22','2025-11-28 10:09:22','2025-11-28 10:09:22',1,782,'ca8b9a29-fac1-40f1-8d1f-18e9915d0756',199,'673b477f9d70449480701aa9846d8f60','gigabytes',-1,'2025-11-29 10:09:22',NULL),('2025-11-28 10:09:22','2025-11-28 10:09:22','2025-11-28 10:09:22',1,783,'3bf63f3f-0eb5-49eb-ac44-700fa636656f',200,'673b477f9d70449480701aa9846d8f60','volumes_tripleo',-1,'2025-11-29 10:09:22',NULL),('2025-11-28 10:09:22','2025-11-28 10:09:22','2025-11-28 10:09:22',1,784,'616534ec-f2e9-4b7c-97b0-5d5e700338c0',201,'673b477f9d70449480701aa9846d8f60','gigabytes_tripleo',-1,'2025-11-29 10:09:22',NULL),('2025-11-28 10:09:22','2025-11-28 10:09:22','2025-11-28 10:09:22',1,785,'7c458301-7d9f-47d1-bd17-b5a8b8b1e6c9',212,'3e2ec027cab64e90a22b087eafacf760','volumes',1,'2025-11-29 10:09:22',NULL),('2025-11-28 10:09:22','2025-11-28 10:09:22','2025-11-28 10:09:22',1,786,'7a077a12-ef88-4b87-9857-036c1debd300',213,'3e2ec027cab64e90a22b087eafacf760','gigabytes',1,'2025-11-29 10:09:22',NULL),('2025-11-28 10:09:22','2025-11-28 10:09:22','2025-11-28 10:09:22',1,787,'106ebdbc-f78d-4f06-a048-7d1aa1cacd0d',214,'3e2ec027cab64e90a22b087eafacf760','volumes_tripleo',1,'2025-11-29 10:09:22',NULL),('2025-11-28 10:09:22','2025-11-28 10:09:22','2025-11-28 10:09:22',1,788,'aaf2eea3-e29d-44da-a9da-99a900d40547',215,'3e2ec027cab64e90a22b087eafacf760','gigabytes_tripleo',1,'2025-11-29 10:09:22',NULL),('2025-11-28 10:09:22','2025-11-28 10:09:22','2025-11-28 10:09:22',1,789,'c1dc5fe2-237c-4f93-aca4-22ac7ad6810c',210,'e67c42de6de84a6eba7382934e59b9b3','snapshots',-1,'2025-11-29 10:09:22',NULL),('2025-11-28 10:09:22','2025-11-28 10:09:22','2025-11-28 10:09:22',1,790,'0a3d1ba5-50e3-43be-9fce-77fd4ecb51aa',207,'e67c42de6de84a6eba7382934e59b9b3','gigabytes',-1,'2025-11-29 10:09:22',NULL),('2025-11-28 10:09:22','2025-11-28 10:09:22','2025-11-28 10:09:22',1,791,'01bdbe26-8df7-45cd-a565-aa9a5e6fc837',209,'e67c42de6de84a6eba7382934e59b9b3','gigabytes_tripleo',-1,'2025-11-29 10:09:22',NULL),('2025-11-28 10:09:22','2025-11-28 10:09:22','2025-11-28 10:09:22',1,792,'9cafb947-9d80-45ef-8d57-cf47a7564446',211,'e67c42de6de84a6eba7382934e59b9b3','snapshots_tripleo',-1,'2025-11-29 10:09:22',NULL),('2025-11-28 10:09:23','2025-11-28 10:09:23','2025-11-28 10:09:23',1,793,'5f647f5c-6aa0-41f6-92c0-149efb4f1bce',216,'3e2ec027cab64e90a22b087eafacf760','snapshots',1,'2025-11-29 10:09:23',NULL),('2025-11-28 10:09:23','2025-11-28 10:09:23','2025-11-28 10:09:23',1,794,'622bc801-4102-4ee6-bcbe-629bcd83be98',213,'3e2ec027cab64e90a22b087eafacf760','gigabytes',1,'2025-11-29 10:09:23',NULL),('2025-11-28 10:09:23','2025-11-28 10:09:23','2025-11-28 10:09:23',1,795,'eab7dfe9-6d9d-4460-9e0c-9af07b123541',215,'3e2ec027cab64e90a22b087eafacf760','gigabytes_tripleo',1,'2025-11-29 10:09:23',NULL),('2025-11-28 10:09:23','2025-11-28 10:09:23','2025-11-28 10:09:23',1,796,'ba154e45-995a-45aa-8a88-e8e40f4d5a45',217,'3e2ec027cab64e90a22b087eafacf760','snapshots_tripleo',1,'2025-11-29 10:09:23',NULL),('2025-11-28 10:09:24','2025-11-28 10:09:24','2025-11-28 10:09:24',1,797,'0709f639-fa4c-44d4-a8da-f79eba1349ab',206,'e67c42de6de84a6eba7382934e59b9b3','volumes',-1,'2025-11-29 10:09:24',NULL),('2025-11-28 10:09:24','2025-11-28 10:09:24','2025-11-28 10:09:24',1,798,'0e47aa31-3fb9-49f6-9b61-69db710df829',207,'e67c42de6de84a6eba7382934e59b9b3','gigabytes',-1,'2025-11-29 10:09:24',NULL),('2025-11-28 10:09:24','2025-11-28 10:09:24','2025-11-28 10:09:24',1,799,'8c1a1515-126c-4f69-89af-97929fc6e3a0',208,'e67c42de6de84a6eba7382934e59b9b3','volumes_tripleo',-1,'2025-11-29 10:09:24',NULL),('2025-11-28 10:09:24','2025-11-28 10:09:24','2025-11-28 10:09:24',1,800,'e17a3089-17d7-4ebd-9fcb-19335ccda2fc',209,'e67c42de6de84a6eba7382934e59b9b3','gigabytes_tripleo',-1,'2025-11-29 10:09:24',NULL),('2025-11-28 10:09:24','2025-11-28 10:09:24','2025-11-28 10:09:24',1,801,'f772807c-b6e8-4240-b695-e2617f7baa9f',218,'3e2ec027cab64e90a22b087eafacf760','backups',1,'2025-11-29 10:09:24',NULL),('2025-11-28 10:09:24','2025-11-28 10:09:24','2025-11-28 10:09:24',1,802,'8ab8230d-686d-4331-99a7-7ebdf94f8bbd',219,'3e2ec027cab64e90a22b087eafacf760','backup_gigabytes',1,'2025-11-29 10:09:24',NULL),('2025-11-28 10:09:26','2025-11-28 10:09:26','2025-11-28 10:09:26',1,803,'12c71af0-cb02-4e2b-99b1-c568d2e40fe5',220,'df6949ad183e4e1e8db4a49117054e84','volumes',1,'2025-11-29 10:09:26',NULL),('2025-11-28 10:09:26','2025-11-28 10:09:26','2025-11-28 10:09:26',1,804,'64ff4281-878f-45ac-b03f-ac3565cca2e7',221,'df6949ad183e4e1e8db4a49117054e84','gigabytes',1,'2025-11-29 10:09:26',NULL),('2025-11-28 10:09:26','2025-11-28 10:09:26','2025-11-28 10:09:26',1,805,'4fe03596-2044-4507-9eb0-e07fd891708b',222,'df6949ad183e4e1e8db4a49117054e84','volumes_tripleo',1,'2025-11-29 10:09:26',NULL),('2025-11-28 10:09:26','2025-11-28 10:09:26','2025-11-28 10:09:26',1,806,'97191244-9635-4238-919b-542a0de3fd70',223,'df6949ad183e4e1e8db4a49117054e84','gigabytes_tripleo',1,'2025-11-29 10:09:26',NULL),('2025-11-28 10:09:27','2025-11-28 10:09:27','2025-11-28 10:09:27',1,807,'a19f17da-eab6-415b-bd81-c7edb1cb0756',220,'df6949ad183e4e1e8db4a49117054e84','volumes',1,'2025-11-29 10:09:27',NULL),('2025-11-28 10:09:27','2025-11-28 10:09:27','2025-11-28 10:09:27',1,808,'e9a3f26b-79f4-43d2-b105-d0b4dc71f5dc',221,'df6949ad183e4e1e8db4a49117054e84','gigabytes',1,'2025-11-29 10:09:27',NULL),('2025-11-28 10:09:27','2025-11-28 10:09:27','2025-11-28 10:09:27',1,809,'1460b050-e985-46f9-8873-5b3bcc08b970',222,'df6949ad183e4e1e8db4a49117054e84','volumes_tripleo',1,'2025-11-29 10:09:27',NULL),('2025-11-28 10:09:27','2025-11-28 10:09:27','2025-11-28 10:09:27',1,810,'5a51bbb1-9d14-4e01-975b-32d9f31c5d51',223,'df6949ad183e4e1e8db4a49117054e84','gigabytes_tripleo',1,'2025-11-29 10:09:27',NULL),('2025-11-28 10:09:30','2025-11-28 10:09:30','2025-11-28 10:09:30',1,811,'ea5214ad-236d-45d6-b9ea-5e60b6859ed1',220,'df6949ad183e4e1e8db4a49117054e84','volumes',-1,'2025-11-29 10:09:30',NULL),('2025-11-28 10:09:30','2025-11-28 10:09:30','2025-11-28 10:09:30',1,812,'e732f44a-77cd-44c6-a6c8-3698a1b5d4d4',221,'df6949ad183e4e1e8db4a49117054e84','gigabytes',-1,'2025-11-29 10:09:30',NULL),('2025-11-28 10:09:30','2025-11-28 10:09:30','2025-11-28 10:09:30',1,813,'a19910cd-724f-462e-bb04-a0f8cb2588a2',222,'df6949ad183e4e1e8db4a49117054e84','volumes_tripleo',-1,'2025-11-29 10:09:30',NULL),('2025-11-28 10:09:30','2025-11-28 10:09:30','2025-11-28 10:09:30',1,814,'4382a0f1-a24b-4c25-8210-96013b660a80',223,'df6949ad183e4e1e8db4a49117054e84','gigabytes_tripleo',-1,'2025-11-29 10:09:30',NULL),('2025-11-28 10:09:32','2025-11-28 10:09:32','2025-11-28 10:09:32',1,815,'2fac81a9-353a-40af-b6b3-7effd648e9df',220,'df6949ad183e4e1e8db4a49117054e84','volumes',-1,'2025-11-29 10:09:32',NULL),('2025-11-28 10:09:32','2025-11-28 10:09:32','2025-11-28 10:09:32',1,816,'742ed0bb-8da8-4e38-97d6-a8c111c6a223',221,'df6949ad183e4e1e8db4a49117054e84','gigabytes',-1,'2025-11-29 10:09:32',NULL),('2025-11-28 10:09:32','2025-11-28 10:09:32','2025-11-28 10:09:32',1,817,'24ed2410-61ec-4a29-b1a2-5b37efa31241',222,'df6949ad183e4e1e8db4a49117054e84','volumes_tripleo',-1,'2025-11-29 10:09:32',NULL),('2025-11-28 10:09:32','2025-11-28 10:09:32','2025-11-28 10:09:32',1,818,'121d6c73-3de4-4754-904c-11f6dafcd3d7',223,'df6949ad183e4e1e8db4a49117054e84','gigabytes_tripleo',-1,'2025-11-29 10:09:32',NULL),('2025-11-28 10:09:33','2025-11-28 10:09:33','2025-11-28 10:09:33',1,819,'662f1795-0bd4-45f6-a6c2-e2aaa705230b',220,'df6949ad183e4e1e8db4a49117054e84','volumes',1,'2025-11-29 10:09:33',NULL),('2025-11-28 10:09:33','2025-11-28 10:09:33','2025-11-28 10:09:33',1,820,'ec2798a3-aa51-4654-9453-9aa0e2d32025',221,'df6949ad183e4e1e8db4a49117054e84','gigabytes',1,'2025-11-29 10:09:33',NULL),('2025-11-28 10:09:33','2025-11-28 10:09:33','2025-11-28 10:09:33',1,821,'7e67ded6-be57-4c6f-80d7-6dbd244e0a55',222,'df6949ad183e4e1e8db4a49117054e84','volumes_tripleo',1,'2025-11-29 10:09:33',NULL),('2025-11-28 10:09:33','2025-11-28 10:09:33','2025-11-28 10:09:33',1,822,'e3773c7a-cfce-4c52-8cda-1893353377c2',223,'df6949ad183e4e1e8db4a49117054e84','gigabytes_tripleo',1,'2025-11-29 10:09:33',NULL),('2025-11-28 10:09:34','2025-11-28 10:09:34','2025-11-28 10:09:34',1,823,'3bb1ebcf-42d1-4581-8602-b51e44d43974',220,'df6949ad183e4e1e8db4a49117054e84','volumes',1,'2025-11-29 10:09:34',NULL),('2025-11-28 10:09:34','2025-11-28 10:09:34','2025-11-28 10:09:34',1,824,'dda0ce8b-1f43-4521-9a69-47fa7581d1f3',221,'df6949ad183e4e1e8db4a49117054e84','gigabytes',1,'2025-11-29 10:09:34',NULL),('2025-11-28 10:09:34','2025-11-28 10:09:34','2025-11-28 10:09:34',1,825,'f71b0033-4a59-42c8-944e-e72a3f6d28cb',222,'df6949ad183e4e1e8db4a49117054e84','volumes_tripleo',1,'2025-11-29 10:09:34',NULL),('2025-11-28 10:09:34','2025-11-28 10:09:34','2025-11-28 10:09:34',1,826,'d089d1c9-479d-4810-af7e-f73a203bab53',223,'df6949ad183e4e1e8db4a49117054e84','gigabytes_tripleo',1,'2025-11-29 10:09:34',NULL),('2025-11-28 10:09:38','2025-11-28 10:09:38','2025-11-28 10:09:38',1,827,'9a3ba5ce-a393-4f0e-800d-09be6236afb1',220,'df6949ad183e4e1e8db4a49117054e84','volumes',1,'2025-11-29 10:09:38',NULL),('2025-11-28 10:09:38','2025-11-28 10:09:38','2025-11-28 10:09:38',1,828,'f959b3fe-da18-4517-a0fd-817b360a4d36',221,'df6949ad183e4e1e8db4a49117054e84','gigabytes',1,'2025-11-29 10:09:38',NULL),('2025-11-28 10:09:38','2025-11-28 10:09:38','2025-11-28 10:09:38',1,829,'ba9ae908-47ac-4255-8fb6-320bd9f07ef8',222,'df6949ad183e4e1e8db4a49117054e84','volumes_tripleo',1,'2025-11-29 10:09:38',NULL),('2025-11-28 10:09:38','2025-11-28 10:09:38','2025-11-28 10:09:38',1,830,'6f2f189c-8850-4b48-bd47-a946ef63a922',223,'df6949ad183e4e1e8db4a49117054e84','gigabytes_tripleo',1,'2025-11-29 10:09:38',NULL),('2025-11-28 10:09:39','2025-11-28 10:09:39','2025-11-28 10:09:39',1,831,'91a18121-f8d0-4c62-9559-31b03625491d',220,'df6949ad183e4e1e8db4a49117054e84','volumes',-1,'2025-11-29 10:09:39',NULL),('2025-11-28 10:09:39','2025-11-28 10:09:39','2025-11-28 10:09:39',1,832,'cbae0791-c706-48fd-bc4f-349cbd5b8839',221,'df6949ad183e4e1e8db4a49117054e84','gigabytes',-1,'2025-11-29 10:09:39',NULL),('2025-11-28 10:09:39','2025-11-28 10:09:39','2025-11-28 10:09:39',1,833,'df382278-97f2-4c46-a93f-95775a750b40',222,'df6949ad183e4e1e8db4a49117054e84','volumes_tripleo',-1,'2025-11-29 10:09:39',NULL),('2025-11-28 10:09:39','2025-11-28 10:09:39','2025-11-28 10:09:39',1,834,'e4c1bf70-4391-4926-9426-c09f32b8c7b1',223,'df6949ad183e4e1e8db4a49117054e84','gigabytes_tripleo',-1,'2025-11-29 10:09:39',NULL),('2025-11-28 10:09:40','2025-11-28 10:09:40','2025-11-28 10:09:40',1,835,'98315ed8-e530-427d-b964-ba97729b4a5f',218,'3e2ec027cab64e90a22b087eafacf760','backups',-1,'2025-11-29 10:09:39',NULL),('2025-11-28 10:09:40','2025-11-28 10:09:40','2025-11-28 10:09:40',1,836,'ca1570b3-8db7-479c-bd85-b94d34002199',219,'3e2ec027cab64e90a22b087eafacf760','backup_gigabytes',-1,'2025-11-29 10:09:39',NULL),('2025-11-28 10:09:41','2025-11-28 10:09:41','2025-11-28 10:09:41',1,837,'b710da44-1b17-4e6b-8b6f-35c83bab1e6d',220,'df6949ad183e4e1e8db4a49117054e84','volumes',-1,'2025-11-29 10:09:41',NULL),('2025-11-28 10:09:41','2025-11-28 10:09:41','2025-11-28 10:09:41',1,838,'6d4ce85b-9936-486d-b40e-43c8f8b3d71b',221,'df6949ad183e4e1e8db4a49117054e84','gigabytes',-1,'2025-11-29 10:09:41',NULL),('2025-11-28 10:09:41','2025-11-28 10:09:41','2025-11-28 10:09:41',1,839,'e55a667e-fc8e-4bc7-aa48-6cff307e4fcb',222,'df6949ad183e4e1e8db4a49117054e84','volumes_tripleo',-1,'2025-11-29 10:09:41',NULL),('2025-11-28 10:09:41','2025-11-28 10:09:41','2025-11-28 10:09:41',1,840,'74d8f198-d48b-4bfa-80f6-ccd9d1bbf67d',223,'df6949ad183e4e1e8db4a49117054e84','gigabytes_tripleo',-1,'2025-11-29 10:09:41',NULL),('2025-11-28 10:09:41','2025-11-28 10:09:41','2025-11-28 10:09:41',1,841,'459944de-7712-4b6a-9298-d0c702b00bc9',216,'3e2ec027cab64e90a22b087eafacf760','snapshots',-1,'2025-11-29 10:09:41',NULL),('2025-11-28 10:09:41','2025-11-28 10:09:41','2025-11-28 10:09:41',1,842,'75270025-f805-43b4-8438-40d425ed99b0',213,'3e2ec027cab64e90a22b087eafacf760','gigabytes',-1,'2025-11-29 10:09:41',NULL),('2025-11-28 10:09:41','2025-11-28 10:09:41','2025-11-28 10:09:41',1,843,'b0231780-7e17-4ec8-9e1a-e96adb91da98',215,'3e2ec027cab64e90a22b087eafacf760','gigabytes_tripleo',-1,'2025-11-29 10:09:41',NULL),('2025-11-28 10:09:41','2025-11-28 10:09:41','2025-11-28 10:09:41',1,844,'1d7ec471-61b5-4aa4-bd28-ea8a1bbfaf67',217,'3e2ec027cab64e90a22b087eafacf760','snapshots_tripleo',-1,'2025-11-29 10:09:41',NULL),('2025-11-28 10:09:41','2025-11-28 10:09:41','2025-11-28 10:09:41',1,845,'806746ee-270f-45f7-be9f-11e0528cb084',216,'3e2ec027cab64e90a22b087eafacf760','snapshots',1,'2025-11-29 10:09:41',NULL),('2025-11-28 10:09:41','2025-11-28 10:09:41','2025-11-28 10:09:41',1,846,'a3d79734-2cce-452b-b212-8b49b5fd81fd',213,'3e2ec027cab64e90a22b087eafacf760','gigabytes',1,'2025-11-29 10:09:41',NULL),('2025-11-28 10:09:41','2025-11-28 10:09:41','2025-11-28 10:09:41',1,847,'bd936b9e-42af-46c9-9a13-f21091d92141',215,'3e2ec027cab64e90a22b087eafacf760','gigabytes_tripleo',1,'2025-11-29 10:09:41',NULL),('2025-11-28 10:09:41','2025-11-28 10:09:41','2025-11-28 10:09:41',1,848,'742b1502-aa5e-46f4-bf37-c026f5c5ccfb',217,'3e2ec027cab64e90a22b087eafacf760','snapshots_tripleo',1,'2025-11-29 10:09:41',NULL),('2025-11-28 10:09:42','2025-11-28 10:09:42','2025-11-28 10:09:42',1,849,'0352e4ac-1c53-4034-9676-e60badd10593',220,'df6949ad183e4e1e8db4a49117054e84','volumes',-1,'2025-11-29 10:09:42',NULL),('2025-11-28 10:09:42','2025-11-28 10:09:42','2025-11-28 10:09:42',1,850,'6c9b209a-ed8b-4321-bde1-218daf322f9a',221,'df6949ad183e4e1e8db4a49117054e84','gigabytes',-1,'2025-11-29 10:09:42',NULL),('2025-11-28 10:09:42','2025-11-28 10:09:42','2025-11-28 10:09:42',1,851,'2cc5955c-fa85-473f-b2be-e9519015e367',222,'df6949ad183e4e1e8db4a49117054e84','volumes_tripleo',-1,'2025-11-29 10:09:42',NULL),('2025-11-28 10:09:42','2025-11-28 10:09:42','2025-11-28 10:09:42',1,852,'f7c0fd26-b188-4e74-8aab-88d232068b52',223,'df6949ad183e4e1e8db4a49117054e84','gigabytes_tripleo',-1,'2025-11-29 10:09:42',NULL),('2025-11-28 10:09:42','2025-11-28 10:09:43','2025-11-28 10:09:43',1,853,'fbc1b1d8-9b4c-4646-811c-92acdb62470d',220,'df6949ad183e4e1e8db4a49117054e84','volumes',1,'2025-11-29 10:09:42',NULL),('2025-11-28 10:09:42','2025-11-28 10:09:43','2025-11-28 10:09:43',1,854,'73d9afac-b20b-4814-bb49-02ba9a80f602',221,'df6949ad183e4e1e8db4a49117054e84','gigabytes',1,'2025-11-29 10:09:42',NULL),('2025-11-28 10:09:42','2025-11-28 10:09:43','2025-11-28 10:09:43',1,855,'82445198-99f6-4477-b214-9c680ce67ea4',222,'df6949ad183e4e1e8db4a49117054e84','volumes_tripleo',1,'2025-11-29 10:09:42',NULL),('2025-11-28 10:09:42','2025-11-28 10:09:43','2025-11-28 10:09:43',1,856,'13ef79d8-5e15-4aa5-ab5d-968ddb380ef6',223,'df6949ad183e4e1e8db4a49117054e84','gigabytes_tripleo',1,'2025-11-29 10:09:42',NULL),('2025-11-28 10:09:44','2025-11-28 10:09:44','2025-11-28 10:09:44',1,857,'588c590e-ebed-42b7-be11-019e5b25cfa7',216,'3e2ec027cab64e90a22b087eafacf760','snapshots',-1,'2025-11-29 10:09:44',NULL),('2025-11-28 10:09:44','2025-11-28 10:09:44','2025-11-28 10:09:44',1,858,'703f4c5a-79d0-4a53-87f9-d085818d9ee2',213,'3e2ec027cab64e90a22b087eafacf760','gigabytes',-1,'2025-11-29 10:09:44',NULL),('2025-11-28 10:09:44','2025-11-28 10:09:44','2025-11-28 10:09:44',1,859,'4e705550-d9da-4a67-92d9-5dfc9d6c3bf9',215,'3e2ec027cab64e90a22b087eafacf760','gigabytes_tripleo',-1,'2025-11-29 10:09:44',NULL),('2025-11-28 10:09:44','2025-11-28 10:09:44','2025-11-28 10:09:44',1,860,'1d9728c1-9cb7-4057-83fc-50450ea640ec',217,'3e2ec027cab64e90a22b087eafacf760','snapshots_tripleo',-1,'2025-11-29 10:09:44',NULL),('2025-11-28 10:09:44','2025-11-28 10:09:45','2025-11-28 10:09:45',1,861,'57d2c0fa-5582-4a1b-bb50-ef64b8709cf9',212,'3e2ec027cab64e90a22b087eafacf760','volumes',1,'2025-11-29 10:09:44',NULL),('2025-11-28 10:09:44','2025-11-28 10:09:45','2025-11-28 10:09:45',1,862,'8a135bda-0c2f-48cc-a104-7c3fc3060bec',213,'3e2ec027cab64e90a22b087eafacf760','gigabytes',1,'2025-11-29 10:09:44',NULL),('2025-11-28 10:09:44','2025-11-28 10:09:45','2025-11-28 10:09:45',1,863,'ff5b1f14-419e-4983-a22a-91f698c1a9f3',214,'3e2ec027cab64e90a22b087eafacf760','volumes_tripleo',1,'2025-11-29 10:09:44',NULL),('2025-11-28 10:09:44','2025-11-28 10:09:45','2025-11-28 10:09:45',1,864,'0ae2339c-4fdb-4293-a0be-4f45e1a63868',215,'3e2ec027cab64e90a22b087eafacf760','gigabytes_tripleo',1,'2025-11-29 10:09:44',NULL),('2025-11-28 10:09:46','2025-11-28 10:09:46','2025-11-28 10:09:46',1,865,'2384cd1d-0a7d-4e77-b557-9b11bbec9961',216,'3e2ec027cab64e90a22b087eafacf760','snapshots',1,'2025-11-29 10:09:46',NULL),('2025-11-28 10:09:46','2025-11-28 10:09:46','2025-11-28 10:09:46',1,866,'1c54e7a6-86b4-4db7-b33b-f9023aa7c9f8',213,'3e2ec027cab64e90a22b087eafacf760','gigabytes',1,'2025-11-29 10:09:46',NULL),('2025-11-28 10:09:46','2025-11-28 10:09:46','2025-11-28 10:09:46',1,867,'6d501daf-3d58-4704-b002-86381da81a39',215,'3e2ec027cab64e90a22b087eafacf760','gigabytes_tripleo',1,'2025-11-29 10:09:46',NULL),('2025-11-28 10:09:46','2025-11-28 10:09:46','2025-11-28 10:09:46',1,868,'8b547b78-960d-467a-93b7-15cd74676338',217,'3e2ec027cab64e90a22b087eafacf760','snapshots_tripleo',1,'2025-11-29 10:09:46',NULL),('2025-11-28 10:09:47','2025-11-28 10:09:47','2025-11-28 10:09:47',1,869,'a93cb6a8-ea6d-4af0-846e-e50fc916fa02',212,'3e2ec027cab64e90a22b087eafacf760','volumes',1,'2025-11-29 10:09:47',NULL),('2025-11-28 10:09:47','2025-11-28 10:09:47','2025-11-28 10:09:47',1,870,'7236cb27-cc56-4fa4-abea-87ad851c47d7',213,'3e2ec027cab64e90a22b087eafacf760','gigabytes',2,'2025-11-29 10:09:47',NULL),('2025-11-28 10:09:47','2025-11-28 10:09:47','2025-11-28 10:09:47',1,871,'6c8a371f-0c2d-4cfd-976c-82af919af2b7',214,'3e2ec027cab64e90a22b087eafacf760','volumes_tripleo',1,'2025-11-29 10:09:47',NULL),('2025-11-28 10:09:47','2025-11-28 10:09:47','2025-11-28 10:09:47',1,872,'b6700a47-00c9-4aea-ba32-5b18a6c4c625',215,'3e2ec027cab64e90a22b087eafacf760','gigabytes_tripleo',2,'2025-11-29 10:09:47',NULL),('2025-11-28 10:09:49','2025-11-28 10:09:49','2025-11-28 10:09:49',1,873,'0fefd5a0-8c87-419b-a76a-9ea06eca2875',212,'3e2ec027cab64e90a22b087eafacf760','volumes',-1,'2025-11-29 10:09:49',NULL),('2025-11-28 10:09:49','2025-11-28 10:09:49','2025-11-28 10:09:49',1,874,'e9004daf-18b6-4d44-8700-e54ada3dea9d',213,'3e2ec027cab64e90a22b087eafacf760','gigabytes',-2,'2025-11-29 10:09:49',NULL),('2025-11-28 10:09:49','2025-11-28 10:09:49','2025-11-28 10:09:49',1,875,'a3569194-70cd-4424-be9e-2a228b5a4315',214,'3e2ec027cab64e90a22b087eafacf760','volumes_tripleo',-1,'2025-11-29 10:09:49',NULL),('2025-11-28 10:09:49','2025-11-28 10:09:49','2025-11-28 10:09:49',1,876,'7d184b40-a90a-443f-b3c4-4bd92862d4a3',215,'3e2ec027cab64e90a22b087eafacf760','gigabytes_tripleo',-2,'2025-11-29 10:09:49',NULL),('2025-11-28 10:09:49','2025-11-28 10:09:49','2025-11-28 10:09:49',1,877,'3182bb82-2a5a-4280-96d7-950efc10c05d',220,'df6949ad183e4e1e8db4a49117054e84','volumes',1,'2025-11-29 10:09:49',NULL),('2025-11-28 10:09:49','2025-11-28 10:09:49','2025-11-28 10:09:49',1,878,'8c20c950-d277-4855-b9cf-9cbfe404ed48',221,'df6949ad183e4e1e8db4a49117054e84','gigabytes',1,'2025-11-29 10:09:49',NULL),('2025-11-28 10:09:49','2025-11-28 10:09:49','2025-11-28 10:09:49',1,879,'f41dd526-ec62-48d1-86a3-3df8df90b73d',222,'df6949ad183e4e1e8db4a49117054e84','volumes_tripleo',1,'2025-11-29 10:09:49',NULL),('2025-11-28 10:09:49','2025-11-28 10:09:49','2025-11-28 10:09:49',1,880,'79055a39-625b-403b-9b68-88048fddd885',223,'df6949ad183e4e1e8db4a49117054e84','gigabytes_tripleo',1,'2025-11-29 10:09:49',NULL),('2025-11-28 10:09:50','2025-11-28 10:09:50','2025-11-28 10:09:50',1,881,'bbf525e3-7d1b-463c-a7c0-9cacbfb2014a',216,'3e2ec027cab64e90a22b087eafacf760','snapshots',-1,'2025-11-29 10:09:50',NULL),('2025-11-28 10:09:50','2025-11-28 10:09:50','2025-11-28 10:09:50',1,882,'41b9edd6-ad2f-4389-b9a2-187a65a550ea',213,'3e2ec027cab64e90a22b087eafacf760','gigabytes',-1,'2025-11-29 10:09:50',NULL),('2025-11-28 10:09:50','2025-11-28 10:09:50','2025-11-28 10:09:50',1,883,'652c2299-ccbd-4898-bb3c-fefbd1427cbe',215,'3e2ec027cab64e90a22b087eafacf760','gigabytes_tripleo',-1,'2025-11-29 10:09:50',NULL),('2025-11-28 10:09:50','2025-11-28 10:09:50','2025-11-28 10:09:50',1,884,'f079866f-5f06-40ae-b88e-b940e823e6d7',217,'3e2ec027cab64e90a22b087eafacf760','snapshots_tripleo',-1,'2025-11-29 10:09:50',NULL),('2025-11-28 10:09:51','2025-11-28 10:09:51','2025-11-28 10:09:51',1,885,'17699baf-833f-4d0a-836f-3e1876a6f854',212,'3e2ec027cab64e90a22b087eafacf760','volumes',-1,'2025-11-29 10:09:51',NULL),('2025-11-28 10:09:51','2025-11-28 10:09:51','2025-11-28 10:09:51',1,886,'6059145b-fa2e-4d62-9aa1-4587d69c740d',213,'3e2ec027cab64e90a22b087eafacf760','gigabytes',-1,'2025-11-29 10:09:51',NULL),('2025-11-28 10:09:51','2025-11-28 10:09:51','2025-11-28 10:09:51',1,887,'d3c8aa20-07b4-417e-8e16-a8bdf639d760',214,'3e2ec027cab64e90a22b087eafacf760','volumes_tripleo',-1,'2025-11-29 10:09:51',NULL),('2025-11-28 10:09:51','2025-11-28 10:09:51','2025-11-28 10:09:51',1,888,'3bb06333-ec94-4886-ab2d-ab7aa6e04477',215,'3e2ec027cab64e90a22b087eafacf760','gigabytes_tripleo',-1,'2025-11-29 10:09:51',NULL),('2025-11-28 10:09:51','2025-11-28 10:09:51','2025-11-28 10:09:51',1,889,'92a6fb45-ebe3-4463-bc8e-bd0a43f4d565',220,'df6949ad183e4e1e8db4a49117054e84','volumes',-1,'2025-11-29 10:09:51',NULL),('2025-11-28 10:09:51','2025-11-28 10:09:51','2025-11-28 10:09:51',1,890,'50905dc3-e9f8-4ae6-ba10-bf1d708b3906',221,'df6949ad183e4e1e8db4a49117054e84','gigabytes',-1,'2025-11-29 10:09:51',NULL),('2025-11-28 10:09:51','2025-11-28 10:09:51','2025-11-28 10:09:51',1,891,'c01a4593-3e9b-4148-a0e8-2c3257e37369',222,'df6949ad183e4e1e8db4a49117054e84','volumes_tripleo',-1,'2025-11-29 10:09:51',NULL),('2025-11-28 10:09:51','2025-11-28 10:09:51','2025-11-28 10:09:51',1,892,'35e5b1ef-3837-4c26-91d0-be8c4224944e',223,'df6949ad183e4e1e8db4a49117054e84','gigabytes_tripleo',-1,'2025-11-29 10:09:51',NULL),('2025-11-28 10:09:52','2025-11-28 10:09:52','2025-11-28 10:09:52',1,893,'dd3c3856-46c5-4267-be5d-1d5e567897c0',212,'3e2ec027cab64e90a22b087eafacf760','volumes',1,'2025-11-29 10:09:52',NULL),('2025-11-28 10:09:52','2025-11-28 10:09:52','2025-11-28 10:09:52',1,894,'d14a1ac7-11e5-4414-b8a3-b8a0370db8e3',213,'3e2ec027cab64e90a22b087eafacf760','gigabytes',1,'2025-11-29 10:09:52',NULL),('2025-11-28 10:09:52','2025-11-28 10:09:52','2025-11-28 10:09:52',1,895,'671963aa-3c40-43e3-b0dd-95cc28c3b661',214,'3e2ec027cab64e90a22b087eafacf760','volumes_tripleo',1,'2025-11-29 10:09:52',NULL),('2025-11-28 10:09:52','2025-11-28 10:09:52','2025-11-28 10:09:52',1,896,'913ab285-5038-4b20-b4a8-06aec63004c8',215,'3e2ec027cab64e90a22b087eafacf760','gigabytes_tripleo',1,'2025-11-29 10:09:52',NULL),('2025-11-28 10:09:53','2025-11-28 10:09:53','2025-11-28 10:09:53',1,897,'52d42d25-ed09-4499-9ac7-f6c5bc0b189c',220,'df6949ad183e4e1e8db4a49117054e84','volumes',-1,'2025-11-29 10:09:53',NULL),('2025-11-28 10:09:53','2025-11-28 10:09:53','2025-11-28 10:09:53',1,898,'56b37482-21a5-4237-be07-6bc817e0bffc',221,'df6949ad183e4e1e8db4a49117054e84','gigabytes',-1,'2025-11-29 10:09:53',NULL),('2025-11-28 10:09:53','2025-11-28 10:09:53','2025-11-28 10:09:53',1,899,'8cd43f2e-2487-4590-b7ca-854a09162168',222,'df6949ad183e4e1e8db4a49117054e84','volumes_tripleo',-1,'2025-11-29 10:09:53',NULL),('2025-11-28 10:09:53','2025-11-28 10:09:53','2025-11-28 10:09:53',1,900,'17bad276-878b-43ec-9f09-41d93665fbe0',223,'df6949ad183e4e1e8db4a49117054e84','gigabytes_tripleo',-1,'2025-11-29 10:09:53',NULL),('2025-11-28 10:09:53','2025-11-28 10:09:53','2025-11-28 10:09:53',1,901,'58426ca0-1550-4d63-8892-a19400673760',216,'3e2ec027cab64e90a22b087eafacf760','snapshots',1,'2025-11-29 10:09:53',NULL),('2025-11-28 10:09:53','2025-11-28 10:09:53','2025-11-28 10:09:53',1,902,'bcdbf6fa-25f1-41fe-a32e-4083f64f1cc0',213,'3e2ec027cab64e90a22b087eafacf760','gigabytes',1,'2025-11-29 10:09:53',NULL),('2025-11-28 10:09:53','2025-11-28 10:09:53','2025-11-28 10:09:53',1,903,'d6e0b760-fa8f-4293-a50f-597917c637b5',215,'3e2ec027cab64e90a22b087eafacf760','gigabytes_tripleo',1,'2025-11-29 10:09:53',NULL),('2025-11-28 10:09:53','2025-11-28 10:09:53','2025-11-28 10:09:53',1,904,'785263ad-fe3c-44d0-9aad-2578a95e041e',217,'3e2ec027cab64e90a22b087eafacf760','snapshots_tripleo',1,'2025-11-29 10:09:53',NULL),('2025-11-28 10:09:55','2025-11-28 10:09:55','2025-11-28 10:09:55',1,905,'0908a136-8ed1-4623-82a8-f265061c8ece',212,'3e2ec027cab64e90a22b087eafacf760','volumes',1,'2025-11-29 10:09:55',NULL),('2025-11-28 10:09:55','2025-11-28 10:09:55','2025-11-28 10:09:55',1,906,'5587af91-b5d1-44ce-b714-58285faf1f2a',213,'3e2ec027cab64e90a22b087eafacf760','gigabytes',1,'2025-11-29 10:09:55',NULL),('2025-11-28 10:09:55','2025-11-28 10:09:55','2025-11-28 10:09:55',1,907,'ae0248da-d316-4403-b820-8d6702115ab8',214,'3e2ec027cab64e90a22b087eafacf760','volumes_tripleo',1,'2025-11-29 10:09:55',NULL),('2025-11-28 10:09:55','2025-11-28 10:09:55','2025-11-28 10:09:55',1,908,'821388cc-a8e9-4161-be73-8375491b01f6',215,'3e2ec027cab64e90a22b087eafacf760','gigabytes_tripleo',1,'2025-11-29 10:09:55',NULL),('2025-11-28 10:09:57','2025-11-28 10:09:57','2025-11-28 10:09:57',1,909,'4f68a8f3-a721-4a1e-828f-03e8970df927',212,'3e2ec027cab64e90a22b087eafacf760','volumes',-1,'2025-11-29 10:09:57',NULL),('2025-11-28 10:09:57','2025-11-28 10:09:57','2025-11-28 10:09:57',1,910,'d4156ff3-ca05-4361-a11f-1defdddbbb88',213,'3e2ec027cab64e90a22b087eafacf760','gigabytes',-1,'2025-11-29 10:09:57',NULL),('2025-11-28 10:09:57','2025-11-28 10:09:57','2025-11-28 10:09:57',1,911,'f8e83071-392d-4bc1-a7c3-9d325da0c6ea',214,'3e2ec027cab64e90a22b087eafacf760','volumes_tripleo',-1,'2025-11-29 10:09:57',NULL),('2025-11-28 10:09:57','2025-11-28 10:09:57','2025-11-28 10:09:57',1,912,'94a916c1-3dcc-40da-aa54-3ca329e52cfe',215,'3e2ec027cab64e90a22b087eafacf760','gigabytes_tripleo',-1,'2025-11-29 10:09:57',NULL),('2025-11-28 10:09:58','2025-11-28 10:09:58','2025-11-28 10:09:58',1,913,'dbebfa46-384f-4e31-b530-b18947a02a75',216,'3e2ec027cab64e90a22b087eafacf760','snapshots',-1,'2025-11-29 10:09:58',NULL),('2025-11-28 10:09:58','2025-11-28 10:09:58','2025-11-28 10:09:58',1,914,'42a5b183-1b38-4e7d-8b77-f6c1ea22f978',213,'3e2ec027cab64e90a22b087eafacf760','gigabytes',-1,'2025-11-29 10:09:58',NULL),('2025-11-28 10:09:58','2025-11-28 10:09:58','2025-11-28 10:09:58',1,915,'e99d36ef-f5a5-4e5f-84d7-d91494e3d8bd',215,'3e2ec027cab64e90a22b087eafacf760','gigabytes_tripleo',-1,'2025-11-29 10:09:58',NULL),('2025-11-28 10:09:58','2025-11-28 10:09:58','2025-11-28 10:09:58',1,916,'8bb72034-03f4-4656-8660-772f6eec27af',217,'3e2ec027cab64e90a22b087eafacf760','snapshots_tripleo',-1,'2025-11-29 10:09:58',NULL),('2025-11-28 10:09:59','2025-11-28 10:09:59','2025-11-28 10:09:59',1,917,'c1eb9407-5e3c-41a1-ae9b-41bfa6206672',212,'3e2ec027cab64e90a22b087eafacf760','volumes',-1,'2025-11-29 10:09:59',NULL),('2025-11-28 10:09:59','2025-11-28 10:09:59','2025-11-28 10:09:59',1,918,'4c6f08ed-1c3b-42e3-83f8-e8d7e6736dc8',213,'3e2ec027cab64e90a22b087eafacf760','gigabytes',-1,'2025-11-29 10:09:59',NULL),('2025-11-28 10:09:59','2025-11-28 10:09:59','2025-11-28 10:09:59',1,919,'03a021b3-1df0-4793-ab6c-28dac0a02767',214,'3e2ec027cab64e90a22b087eafacf760','volumes_tripleo',-1,'2025-11-29 10:09:59',NULL),('2025-11-28 10:09:59','2025-11-28 10:09:59','2025-11-28 10:09:59',1,920,'9f9008b2-c521-49de-8d95-4c92cbde0f1c',215,'3e2ec027cab64e90a22b087eafacf760','gigabytes_tripleo',-1,'2025-11-29 10:09:59',NULL),('2025-11-28 10:10:00','2025-11-28 10:10:00','2025-11-28 10:10:00',1,921,'e4059327-1b59-4821-9706-d8d4eb1b6860',212,'3e2ec027cab64e90a22b087eafacf760','volumes',-1,'2025-11-29 10:10:00',NULL),('2025-11-28 10:10:00','2025-11-28 10:10:00','2025-11-28 10:10:00',1,922,'cfd4efda-38a3-4bba-8f56-de82bf1bb7a8',213,'3e2ec027cab64e90a22b087eafacf760','gigabytes',-1,'2025-11-29 10:10:00',NULL),('2025-11-28 10:10:00','2025-11-28 10:10:00','2025-11-28 10:10:00',1,923,'95d7c2c8-9ed6-4c72-ae13-27eb9b57df62',214,'3e2ec027cab64e90a22b087eafacf760','volumes_tripleo',-1,'2025-11-29 10:10:00',NULL),('2025-11-28 10:10:00','2025-11-28 10:10:00','2025-11-28 10:10:00',1,924,'6d7ae200-f8d1-42b3-bb90-f8b2e3ec00c6',215,'3e2ec027cab64e90a22b087eafacf760','gigabytes_tripleo',-1,'2025-11-29 10:10:00',NULL);
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`disabled` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`frozen` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2025-11-28 08:19:22','2025-11-28 08:55:04','2025-11-28 08:55:04',1,2,'np0005538510.localdomain','cinder-scheduler','cinder-scheduler',119,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'8b8adb85-53c2-4f14-bbdf-4d57751590f7'),('2025-11-28 08:19:36','2025-11-28 08:55:07','2025-11-28 08:55:07',1,5,'np0005538511.localdomain','cinder-scheduler','cinder-scheduler',117,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'91e3a4a9-ecb3-40b1-9afe-213592e4e6ac'),('2025-11-28 08:19:38','2025-11-28 08:55:09','2025-11-28 08:55:09',1,8,'np0005538512.localdomain','cinder-scheduler','cinder-scheduler',117,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'953061b5-1662-4aa4-8f1a-b68ac57d157b'),('2025-11-28 08:23:01','2025-11-28 08:55:00','2025-11-28 08:55:00',1,11,'np0005538510.localdomain','cinder-backup','cinder-backup',132,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'872b00c4-8c20-42d9-8aa0-723a7b9c8cb6'),('2025-11-28 08:23:36','2025-11-28 10:25:30',NULL,0,14,'hostgroup@tripleo_ceph','cinder-volume','cinder-volume',668,0,'nova',NULL,NULL,'3.18','1.39','disabled',0,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5'),('2025-11-28 08:55:14','2025-11-28 10:25:29',NULL,0,17,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',540,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'ee2e5bf1-6fc5-4613-83c2-ad41a4fe755b'),('2025-11-28 08:55:18','2025-11-28 10:25:29',NULL,0,18,'cinder-backup-0','cinder-backup','cinder-backup',541,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'13abcadb-405d-4776-94af-4ec7584d12c2');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
INSERT INTO `snapshot_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `snapshot_id`, `key`, `value`) VALUES ('2025-11-28 10:05:47','2025-11-28 10:05:47','2025-11-28 10:05:47',1,1,'cca97447-c5f9-4d8e-88c0-2f64c5283f2a','key1','value1'),('2025-11-28 10:05:47','2025-11-28 10:05:47','2025-11-28 10:05:47',1,2,'cca97447-c5f9-4d8e-88c0-2f64c5283f2a','key2','value2'),('2025-11-28 10:05:47','2025-11-28 10:05:47','2025-11-28 10:05:47',1,3,'cca97447-c5f9-4d8e-88c0-2f64c5283f2a','key3','value3_update'),('2025-11-28 10:05:47','2025-11-28 10:05:47','2025-11-28 10:05:47',1,4,'cca97447-c5f9-4d8e-88c0-2f64c5283f2a','key4','value4'),('2025-11-28 10:05:48','2025-11-28 10:05:48','2025-11-28 10:05:48',1,5,'cca97447-c5f9-4d8e-88c0-2f64c5283f2a','key1','value1'),('2025-11-28 10:05:48','2025-11-28 10:05:48','2025-11-28 10:05:48',1,6,'cca97447-c5f9-4d8e-88c0-2f64c5283f2a','key2','value2'),('2025-11-28 10:05:48','2025-11-28 10:05:48','2025-11-28 10:05:48',1,7,'cca97447-c5f9-4d8e-88c0-2f64c5283f2a','key3','value3_update'),('2025-11-28 10:09:41',NULL,'2025-11-28 10:09:44',1,8,'b1438f57-b236-426c-84a8-f34889d10338','snap-meta1','value1'),('2025-11-28 10:09:41',NULL,'2025-11-28 10:09:44',1,9,'b1438f57-b236-426c-84a8-f34889d10338','snap-meta2','value2'),('2025-11-28 10:09:41',NULL,'2025-11-28 10:09:44',1,10,'b1438f57-b236-426c-84a8-f34889d10338','snap-meta3','value3');
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
INSERT INTO `snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `status`, `progress`, `volume_size`, `scheduled_at`, `display_name`, `display_description`, `provider_location`, `encryption_key_id`, `volume_type_id`, `cgsnapshot_id`, `provider_id`, `provider_auth`, `group_snapshot_id`, `use_quota`) VALUES ('2025-11-28 10:09:23','2025-11-28 10:09:40','2025-11-28 10:09:41',1,'020542e3-299d-4c17-8a59-99558bed4ff1','e38d3f86-1fc2-412d-99d4-43c43990555a','3e0c0f1d7904439c976f777b4f3c59a9','3e2ec027cab64e90a22b087eafacf760','deleted','100%',1,NULL,'tempest-VolumesSnapshotTestJSON-Snapshot-1219963726',NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,NULL,NULL,NULL,1),('2025-11-28 10:07:45','2025-11-28 10:07:49','2025-11-28 10:07:49',1,'0f43c641-14ba-4ee8-b7ac-79a6883da3db','f440973d-0b6b-4889-bf4a-2156cfb3e249','60a0061fff1842b898c067834f6b0b0d','44e47888bf384f2290cbd80a83fd1322','deleted','100%',1,NULL,'tempest-GroupSnapshotsV319Test-Group_Snapshot-1873264378',NULL,NULL,NULL,'8206fca6-970a-4db0-a8a4-eeedbc6e2000',NULL,NULL,NULL,'8fcbafc2-ee8c-4338-a54b-78e87d269c39',1),('2025-11-28 10:08:38','2025-11-28 10:08:40','2025-11-28 10:08:40',1,'338197b7-7814-40d5-a896-7b558631cd3e','596a022d-09b3-4d24-9e17-a6b92d595b8a','9f195c7e6aa347d4966c7781cadc2cee','a6f735cf317e42218560e5eb75b569f6','deleted','100%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-542575965',NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,NULL,NULL,NULL,1),('2025-11-28 10:06:23','2025-11-28 10:06:27','2025-11-28 10:06:28',1,'38c99163-cbea-414c-be51-b031c42e6808','cccef904-2be7-4d83-aa3a-74f49c47124f','fcce45225cfa4ce6b64c668fe9c9cb2c','85f17f60fae2462cb663ba226772cedd','deleted','100%',1,NULL,'tempest-VolumesDeleteCascade-Snapshot-710248453',NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,NULL,NULL,NULL,1),('2025-11-28 10:08:45','2025-11-28 10:08:46','2025-11-28 10:08:47',1,'4142cd20-f742-4aff-a27b-0244577c1144','596a022d-09b3-4d24-9e17-a6b92d595b8a','9f195c7e6aa347d4966c7781cadc2cee','a6f735cf317e42218560e5eb75b569f6','deleted','100%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-308493432',NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,NULL,NULL,NULL,1),('2025-11-28 10:09:53','2025-11-28 10:09:58','2025-11-28 10:09:58',1,'4444cce2-dceb-4cf6-a170-cd50860695b1','459cfae8-1cbd-4766-b8f0-28736fe59db4','3e0c0f1d7904439c976f777b4f3c59a9','3e2ec027cab64e90a22b087eafacf760','deleted','100%',1,NULL,'tempest-VolumesSnapshotTestJSON-Snapshot-35447698',NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,NULL,NULL,NULL,1),('2025-11-28 10:08:35','2025-11-28 10:08:36','2025-11-28 10:08:37',1,'5614d4c7-9a25-4a42-aba7-48cea027a970','596a022d-09b3-4d24-9e17-a6b92d595b8a','9f195c7e6aa347d4966c7781cadc2cee','a6f735cf317e42218560e5eb75b569f6','deleted','100%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-1931395906',NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,NULL,NULL,NULL,1),('2025-11-28 10:06:25','2025-11-28 10:06:27','2025-11-28 10:06:29',1,'566c72bf-e9cc-40c2-aaaf-29cef6e69e8d','cccef904-2be7-4d83-aa3a-74f49c47124f','fcce45225cfa4ce6b64c668fe9c9cb2c','85f17f60fae2462cb663ba226772cedd','deleted','100%',1,NULL,'tempest-VolumesDeleteCascade-Snapshot-965647960',NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,NULL,NULL,NULL,1),('2025-11-28 10:04:07','2025-11-28 10:04:09','2025-11-28 10:04:09',1,'68b11add-467e-4e42-9128-f9bef333db35','56adaabf-286b-425c-8224-b7a9554b04b4','fe65864ca994460c9f786e2a187aa538','115c143e37394d77b81665435ce51c10','deleted','100%',1,NULL,'tempest-group_snapshot-1716109261',NULL,NULL,NULL,'80703c86-0cc3-4b56-99e8-bbda90d2bedd',NULL,NULL,NULL,'15c3024a-1a77-4bf4-a9e6-33f2c820c2e3',1),('2025-11-28 10:06:31','2025-11-28 10:06:35','2025-11-28 10:06:42',1,'6dd19e2d-1850-46c5-8d88-3be915e8807a','afb48f47-720d-479f-b1cc-92049fd898a8','fcce45225cfa4ce6b64c668fe9c9cb2c','85f17f60fae2462cb663ba226772cedd','deleted','100%',1,NULL,'tempest-VolumesDeleteCascade-Snapshot-853360072',NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,NULL,NULL,NULL,1),('2025-11-28 10:09:20','2025-11-28 10:09:21','2025-11-28 10:09:22',1,'81cda870-cf7a-4fac-b9a5-55b2dd0714e5','2e9cc95b-6af3-4d96-992c-c46ccf9e3c9c','734ab171f3e74a6888b27f8bfe048473','e67c42de6de84a6eba7382934e59b9b3','deleted','100%',1,NULL,'tempest-VolumeSnapshotQuotasNegativeTestJSON-Snapshot-1051706078',NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,NULL,NULL,NULL,1),('2025-11-28 10:09:46','2025-11-28 10:09:49','2025-11-28 10:09:50',1,'aff5c950-2760-443e-b5e4-32ab70adb74d','1a5b9f39-1bc5-4eeb-9fd7-4c8e363a63a3','3e0c0f1d7904439c976f777b4f3c59a9','3e2ec027cab64e90a22b087eafacf760','deleted','100%',1,NULL,'tempest-VolumesSnapshotTestJSON-Snapshot-1468118285',NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,NULL,NULL,NULL,1),('2025-11-28 10:09:41','2025-11-28 10:09:43','2025-11-28 10:09:44',1,'b1438f57-b236-426c-84a8-f34889d10338','e38d3f86-1fc2-412d-99d4-43c43990555a','3e0c0f1d7904439c976f777b4f3c59a9','3e2ec027cab64e90a22b087eafacf760','deleted','100%',1,NULL,'tempest-VolumesSnapshotTestJSON-new-snap-944478646','This is the new description of snapshot.',NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,NULL,NULL,NULL,1),('2025-11-28 10:08:41','2025-11-28 10:08:43','2025-11-28 10:08:44',1,'b796592e-d87b-414d-a69b-bc35b44a4f39','596a022d-09b3-4d24-9e17-a6b92d595b8a','9f195c7e6aa347d4966c7781cadc2cee','a6f735cf317e42218560e5eb75b569f6','deleted','100%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-2068419606',NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,NULL,NULL,NULL,1),('2025-11-28 10:03:37','2025-11-28 10:03:45','2025-11-28 10:03:45',1,'b8923c3e-0b65-497d-9875-9388e1c13731','35675ea9-f512-49d3-9b24-ebad1a252f73','fe65864ca994460c9f786e2a187aa538','115c143e37394d77b81665435ce51c10','deleted','100%',1,NULL,'tempest-group_snapshot-1329091637',NULL,NULL,NULL,'fb386a3c-f41c-4344-a8ff-4193ab81f512',NULL,NULL,NULL,'ea054be1-3b60-4483-8b22-4308ec08290b',1),('2025-11-28 10:03:56','2025-11-28 10:04:01','2025-11-28 10:04:01',1,'bf9ae0cd-4d4c-49ed-921b-7f925ae33218','21022556-6fd5-4b51-855b-5d93bf93c547','fe65864ca994460c9f786e2a187aa538','115c143e37394d77b81665435ce51c10','deleted','100%',1,NULL,'tempest-GroupSnapshotsTest-Group_Snapshot-1409184827',NULL,NULL,NULL,'5bb8e5c1-b168-4814-b7f9-c6b116731dc3',NULL,NULL,NULL,'b7fd025d-8ab8-40ca-9a9c-2374b78fba0c',1),('2025-11-28 10:08:32','2025-11-28 10:08:48','2025-11-28 10:08:49',1,'c084a55d-6943-4262-8e0e-9d97d15dce41','596a022d-09b3-4d24-9e17-a6b92d595b8a','9f195c7e6aa347d4966c7781cadc2cee','a6f735cf317e42218560e5eb75b569f6','deleted','80%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-1178777991',NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,NULL,NULL,NULL,1),('2025-11-28 10:07:17','2025-11-28 10:07:22','2025-11-28 10:07:22',1,'c56e5c64-3068-4d1e-92b3-1dae624bedd2','8291a367-8c2f-4aba-b040-ce2be12abee0','883e728ccb5648cbaf84cd0cbbd59aba','7369c667b30341f7b300e32774b31181','deleted','100%',1,NULL,'tempest-VolumesSnapshotListTestJSON-Snapshot-1102515327',NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,NULL,NULL,NULL,1),('2025-11-28 10:05:46','2025-11-28 10:05:48','2025-11-28 10:05:49',1,'cca97447-c5f9-4d8e-88c0-2f64c5283f2a','440192cb-b293-4b11-a750-420f2b48bf74','3ff9ea6d4ad646d8b2459f66f1af33fc','ba7456648a0f43028832ef04ff1d03da','deleted','100%',1,NULL,'tempest-SnapshotMetadataTestJSON-Snapshot-812967312',NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,NULL,NULL,NULL,1),('2025-11-28 10:07:19','2025-11-28 10:07:20','2025-11-28 10:07:21',1,'d35c7403-cd6a-4697-8e4c-dff7959fa2cc','8291a367-8c2f-4aba-b040-ce2be12abee0','883e728ccb5648cbaf84cd0cbbd59aba','7369c667b30341f7b300e32774b31181','deleted','100%',1,NULL,'tempest-VolumesSnapshotListTestJSON-Snapshot-778354417',NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,NULL,NULL,NULL,1),('2025-11-28 10:08:32','2025-11-28 10:08:33','2025-11-28 10:08:34',1,'d52f35b3-5b52-45d3-a361-afc828cba11a','b8195552-c477-42f9-b39c-8c4684873173','af5b23808fe14f21a1025d9d48164f85','79cbcb0957f54ef09645577668ab7937','deleted','100%',2,NULL,'tempest-VolumesSnapshotNegativeTestJSON-Snapshot-366302887',NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,NULL,NULL,NULL,1),('2025-11-28 10:07:16','2025-11-28 10:07:23','2025-11-28 10:07:24',1,'dbddb85a-e9b9-4868-8143-84bde78f5233','8291a367-8c2f-4aba-b040-ce2be12abee0','883e728ccb5648cbaf84cd0cbbd59aba','7369c667b30341f7b300e32774b31181','deleted','100%',1,NULL,'tempest-VolumesSnapshotListTestJSON-Snapshot-370061387',NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,NULL,NULL,NULL,1),('2025-11-28 10:08:28','2025-11-28 10:08:31','2025-11-28 10:08:32',1,'f0634dda-b666-49cd-aecf-e11f76b70375','3f422f6d-4527-49fa-8d66-5a09d9d5964b','204e4aad7e2340eebed299dd8030708b','6732fa86445147cdb019a2189d601a62','deleted','100%',1,NULL,'tempest-VolumesExtendTest-Snapshot-1618324010',NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,NULL,NULL,NULL,1),('2025-11-28 10:03:56','2025-11-28 10:04:01','2025-11-28 10:04:01',1,'f77826cc-f2d9-4475-8e2d-a0c48f231090','93b53a10-ec03-4d6b-a5c0-b9bab815117b','fe65864ca994460c9f786e2a187aa538','115c143e37394d77b81665435ce51c10','deleted','100%',1,NULL,'tempest-GroupSnapshotsTest-Group_Snapshot-1409184827',NULL,NULL,NULL,'5bb8e5c1-b168-4814-b7f9-c6b116731dc3',NULL,NULL,NULL,'b7fd025d-8ab8-40ca-9a9c-2374b78fba0c',1);
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`no_snapshots` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
INSERT INTO `transfers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `display_name`, `salt`, `crypt_hash`, `expires_at`, `no_snapshots`, `source_project_id`, `destination_project_id`, `accepted`) VALUES ('2025-11-28 10:08:06',NULL,'2025-11-28 10:08:06',1,'243abf85-cbf0-4c9b-9576-a58329d61eaf','e9ef34e3-c3d7-4eab-ad8a-90355ef732f1',NULL,'5d3eeb2f','b571a98d6a577060762bc646e61f362982597102',NULL,0,'5171816b5d3845278c70b062bedaa177','6f9594f9fb704068b77cd4ff3489e542',1),('2025-11-28 10:08:50',NULL,'2025-11-28 10:08:50',1,'4cb4f0ee-f96a-45f0-8d01-f27ac4aa6f85','66270463-29bc-426b-9bee-4ac99727025f',NULL,'4c5010c5','ec98b27a33c20a668cb4df3ebe912781d8f85ce3',NULL,0,'282cf5c7f55f44abb1217a52fa10743f','e7cc91f8f0484d558c7d91f23a229370',1),('2025-11-28 10:08:53',NULL,'2025-11-28 10:08:53',1,'a06ce21e-a45d-48a5-a928-0d0c5b09fbe0','7fb5a324-9940-41e3-b2b7-3d52eacf9685',NULL,'5dfed0bf','a8eb85c8d42fb9139c019acfe1ea71c555e16ae0',NULL,0,'282cf5c7f55f44abb1217a52fa10743f',NULL,0),('2025-11-28 10:08:24',NULL,'2025-11-28 10:08:24',1,'a957e513-0d52-4691-a594-0add4e5d4b29','f25421b6-8785-435c-977a-1024caf09aa1',NULL,'4dd7ff7a','3d9bc4076c893910c8e5b389c86e174485a27ffa',NULL,0,'b75145391b1642aa86ac346010612ae1',NULL,0),('2025-11-28 10:06:36',NULL,'2025-11-28 10:06:36',1,'af2fa95c-58ac-42ff-b9bd-22d372b52109','ab0bacba-4829-4f55-aaae-0bcba18e585b',NULL,'e81af327','9b3e4d9aee5ab71e8e0a1753afdb7ba9470eeab7',NULL,0,'87556d11d3894443a0252992df39cd59',NULL,0),('2025-11-28 10:06:33',NULL,'2025-11-28 10:06:33',1,'e026a0c0-e36f-4355-b135-356dda7b0e2c','406274d6-0728-4fc5-a564-5f713ebc07bb',NULL,'ff5d4661','81c987ffbc814c9b548a05033c0d6873074f66df',NULL,0,'87556d11d3894443a0252992df39cd59','030c225d7ed34b12a2a9020cd72dbf3a',1),('2025-11-28 10:08:20',NULL,'2025-11-28 10:08:21',1,'ffd1cbc2-3e5f-4002-a23b-2d1188d01ca7','33950d06-fc08-4c03-be84-d2f665efc921',NULL,'f17a245d','a9b09c7ad67adefd5b37355f1eab12e9dcc13ce4',NULL,0,'b75145391b1642aa86ac346010612ae1','e40ad514f1414282aba0c087f08f4797',1);
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
INSERT INTO `volume_admin_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `key`, `value`) VALUES ('2025-11-28 10:06:25','2025-11-28 10:06:25','2025-11-28 10:07:13',1,1,'2ba804be-3cec-4533-8cb3-cdcaacce6a06','readonly','False'),('2025-11-28 10:09:24',NULL,'2025-11-28 10:09:39',1,2,'b34f0df5-f83d-4b31-a927-c6a5b1b240aa','temporary','True');
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
INSERT INTO `volume_attachment` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `attached_host`, `instance_uuid`, `mountpoint`, `attach_time`, `detach_time`, `attach_mode`, `attach_status`, `connection_info`, `connector`) VALUES ('2025-11-28 10:07:34','2025-11-28 10:07:56','2025-11-28 10:07:56',1,'8cbb6c04-bc9e-406c-a8b8-f585cb16f401','bd027205-a608-4caf-a797-22f77fcdb9dd','np0005538514.localdomain','640e688c-f2ca-49b5-a84f-ca1ea976a9cd','/dev/vdb','2025-11-28 10:07:37','2025-11-28 10:07:56','rw','detached','{\"name\": \"volumes/volume-bd027205-a608-4caf-a797-22f77fcdb9dd\", \"hosts\": [\"172.18.0.103\", \"172.18.0.104\", \"172.18.0.105\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2c5417c9-00eb-57d5-a565-ddecbc7995c1\", \"volume_id\": \"bd027205-a608-4caf-a797-22f77fcdb9dd\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"8cbb6c04-bc9e-406c-a8b8-f585cb16f401\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.107\", \"host\": \"np0005538514.localdomain\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:10fd9ec73f0\", \"do_local_attach\": false, \"nvme_hostid\": \"168d1537-a23e-475c-b93c-8c4d290d6dcb\", \"system uuid\": \"168d1537-a23e-475c-b93c-8c4d290d6dcb\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:168d1537-a23e-475c-b93c-8c4d290d6dcb\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}');
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
INSERT INTO `volume_glance_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `snapshot_id`, `key`, `value`) VALUES ('2025-11-28 10:05:54',NULL,'2025-11-28 10:05:59',1,1,'3ca1f192-d8a6-4d41-a193-b54d7adca069',NULL,'signature_verified','False'),('2025-11-28 10:05:58',NULL,'2025-11-28 10:05:59',1,2,'3ca1f192-d8a6-4d41-a193-b54d7adca069',NULL,'hw_rng_model','virtio'),('2025-11-28 10:05:58','2025-11-28 10:05:59','2025-11-28 10:05:59',1,3,'3ca1f192-d8a6-4d41-a193-b54d7adca069',NULL,'image_id','5137a025-3c5f-43c1-bc64-5f41270040a5'),('2025-11-28 10:05:58','2025-11-28 10:05:59','2025-11-28 10:05:59',1,4,'3ca1f192-d8a6-4d41-a193-b54d7adca069',NULL,'image_name','image'),('2025-11-28 10:05:58',NULL,'2025-11-28 10:05:59',1,5,'3ca1f192-d8a6-4d41-a193-b54d7adca069',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-28 10:05:58',NULL,'2025-11-28 10:05:59',1,6,'3ca1f192-d8a6-4d41-a193-b54d7adca069',NULL,'container_format','bare'),('2025-11-28 10:05:58',NULL,'2025-11-28 10:05:59',1,7,'3ca1f192-d8a6-4d41-a193-b54d7adca069',NULL,'disk_format','qcow2'),('2025-11-28 10:05:58',NULL,'2025-11-28 10:05:59',1,8,'3ca1f192-d8a6-4d41-a193-b54d7adca069',NULL,'min_disk','0'),('2025-11-28 10:05:58',NULL,'2025-11-28 10:05:59',1,9,'3ca1f192-d8a6-4d41-a193-b54d7adca069',NULL,'min_ram','0'),('2025-11-28 10:05:58',NULL,'2025-11-28 10:05:59',1,10,'3ca1f192-d8a6-4d41-a193-b54d7adca069',NULL,'size','21430272'),('2025-11-28 10:05:59',NULL,'2025-11-28 10:05:59',1,11,'3ca1f192-d8a6-4d41-a193-b54d7adca069',NULL,'kernel_id','6ff710d2-942b-4d6b-9168-8c9cc2404ab1'),('2025-11-28 10:05:59',NULL,'2025-11-28 10:05:59',1,12,'3ca1f192-d8a6-4d41-a193-b54d7adca069',NULL,'ramdisk_id','somedisk'),('2025-11-28 10:06:22',NULL,'2025-11-28 10:06:46',1,13,'5a82eb95-1559-4a88-822e-951361a380e2',NULL,'signature_verified','False'),('2025-11-28 10:06:26',NULL,'2025-11-28 10:06:46',1,14,'5a82eb95-1559-4a88-822e-951361a380e2',NULL,'hw_rng_model','virtio'),('2025-11-28 10:06:26',NULL,'2025-11-28 10:06:46',1,15,'5a82eb95-1559-4a88-822e-951361a380e2',NULL,'image_id','85968a96-5a0e-43a4-9c04-3954f640a7ed'),('2025-11-28 10:06:26',NULL,'2025-11-28 10:06:46',1,16,'5a82eb95-1559-4a88-822e-951361a380e2',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-28 10:06:26',NULL,'2025-11-28 10:06:46',1,17,'5a82eb95-1559-4a88-822e-951361a380e2',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-28 10:06:26',NULL,'2025-11-28 10:06:46',1,18,'5a82eb95-1559-4a88-822e-951361a380e2',NULL,'container_format','bare'),('2025-11-28 10:06:26',NULL,'2025-11-28 10:06:46',1,19,'5a82eb95-1559-4a88-822e-951361a380e2',NULL,'disk_format','qcow2'),('2025-11-28 10:06:26',NULL,'2025-11-28 10:06:46',1,20,'5a82eb95-1559-4a88-822e-951361a380e2',NULL,'min_disk','0'),('2025-11-28 10:06:26',NULL,'2025-11-28 10:06:46',1,21,'5a82eb95-1559-4a88-822e-951361a380e2',NULL,'min_ram','0'),('2025-11-28 10:06:26',NULL,'2025-11-28 10:06:46',1,22,'5a82eb95-1559-4a88-822e-951361a380e2',NULL,'size','21430272'),('2025-11-28 10:06:37',NULL,'2025-11-28 10:06:40',1,23,'ba20f281-f8ef-460a-a916-8659cb86fe77',NULL,'signature_verified','False'),('2025-11-28 10:06:37',NULL,'2025-11-28 10:06:40',1,24,'ba20f281-f8ef-460a-a916-8659cb86fe77',NULL,'hw_rng_model','virtio'),('2025-11-28 10:06:37',NULL,'2025-11-28 10:06:40',1,25,'ba20f281-f8ef-460a-a916-8659cb86fe77',NULL,'image_id','85968a96-5a0e-43a4-9c04-3954f640a7ed'),('2025-11-28 10:06:37',NULL,'2025-11-28 10:06:40',1,26,'ba20f281-f8ef-460a-a916-8659cb86fe77',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-28 10:06:37',NULL,'2025-11-28 10:06:40',1,27,'ba20f281-f8ef-460a-a916-8659cb86fe77',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-28 10:06:37',NULL,'2025-11-28 10:06:40',1,28,'ba20f281-f8ef-460a-a916-8659cb86fe77',NULL,'container_format','bare'),('2025-11-28 10:06:37',NULL,'2025-11-28 10:06:40',1,29,'ba20f281-f8ef-460a-a916-8659cb86fe77',NULL,'disk_format','qcow2'),('2025-11-28 10:06:37',NULL,'2025-11-28 10:06:40',1,30,'ba20f281-f8ef-460a-a916-8659cb86fe77',NULL,'min_disk','0'),('2025-11-28 10:06:38',NULL,'2025-11-28 10:06:40',1,31,'ba20f281-f8ef-460a-a916-8659cb86fe77',NULL,'min_ram','0'),('2025-11-28 10:06:38',NULL,'2025-11-28 10:06:40',1,32,'ba20f281-f8ef-460a-a916-8659cb86fe77',NULL,'size','21430272'),('2025-11-28 10:08:20',NULL,'2025-11-28 10:08:26',1,33,'c731eac0-368d-468d-9419-e1f90b56f670',NULL,'signature_verified','False'),('2025-11-28 10:08:23',NULL,'2025-11-28 10:08:26',1,34,'c731eac0-368d-468d-9419-e1f90b56f670',NULL,'hw_rng_model','virtio'),('2025-11-28 10:08:23',NULL,'2025-11-28 10:08:26',1,35,'c731eac0-368d-468d-9419-e1f90b56f670',NULL,'image_id','85968a96-5a0e-43a4-9c04-3954f640a7ed'),('2025-11-28 10:08:23',NULL,'2025-11-28 10:08:26',1,36,'c731eac0-368d-468d-9419-e1f90b56f670',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-28 10:08:23',NULL,'2025-11-28 10:08:26',1,37,'c731eac0-368d-468d-9419-e1f90b56f670',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-28 10:08:23',NULL,'2025-11-28 10:08:26',1,38,'c731eac0-368d-468d-9419-e1f90b56f670',NULL,'container_format','bare'),('2025-11-28 10:08:23',NULL,'2025-11-28 10:08:26',1,39,'c731eac0-368d-468d-9419-e1f90b56f670',NULL,'disk_format','qcow2'),('2025-11-28 10:08:23',NULL,'2025-11-28 10:08:26',1,40,'c731eac0-368d-468d-9419-e1f90b56f670',NULL,'min_disk','0'),('2025-11-28 10:08:23',NULL,'2025-11-28 10:08:26',1,41,'c731eac0-368d-468d-9419-e1f90b56f670',NULL,'min_ram','0'),('2025-11-28 10:08:23',NULL,'2025-11-28 10:08:26',1,42,'c731eac0-368d-468d-9419-e1f90b56f670',NULL,'size','21430272'),('2025-11-28 10:09:10',NULL,'2025-11-28 10:09:17',1,43,'2be343e1-0720-4240-8d53-d6ea9dba43a0',NULL,'signature_verified','False'),('2025-11-28 10:09:13',NULL,'2025-11-28 10:09:17',1,44,'2be343e1-0720-4240-8d53-d6ea9dba43a0',NULL,'hw_rng_model','virtio'),('2025-11-28 10:09:13',NULL,'2025-11-28 10:09:17',1,45,'2be343e1-0720-4240-8d53-d6ea9dba43a0',NULL,'image_id','85968a96-5a0e-43a4-9c04-3954f640a7ed'),('2025-11-28 10:09:13',NULL,'2025-11-28 10:09:17',1,46,'2be343e1-0720-4240-8d53-d6ea9dba43a0',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-28 10:09:13',NULL,'2025-11-28 10:09:17',1,47,'2be343e1-0720-4240-8d53-d6ea9dba43a0',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-28 10:09:13',NULL,'2025-11-28 10:09:17',1,48,'2be343e1-0720-4240-8d53-d6ea9dba43a0',NULL,'container_format','bare'),('2025-11-28 10:09:13',NULL,'2025-11-28 10:09:17',1,49,'2be343e1-0720-4240-8d53-d6ea9dba43a0',NULL,'disk_format','qcow2'),('2025-11-28 10:09:13',NULL,'2025-11-28 10:09:17',1,50,'2be343e1-0720-4240-8d53-d6ea9dba43a0',NULL,'min_disk','0'),('2025-11-28 10:09:13',NULL,'2025-11-28 10:09:17',1,51,'2be343e1-0720-4240-8d53-d6ea9dba43a0',NULL,'min_ram','0'),('2025-11-28 10:09:13',NULL,'2025-11-28 10:09:17',1,52,'2be343e1-0720-4240-8d53-d6ea9dba43a0',NULL,'size','21430272'),('2025-11-28 10:09:14',NULL,'2025-11-28 10:09:16',1,53,'b352ba15-335d-4fa7-b53c-70aaa91cdb89',NULL,'signature_verified','False'),('2025-11-28 10:09:14',NULL,'2025-11-28 10:09:16',1,54,'b352ba15-335d-4fa7-b53c-70aaa91cdb89',NULL,'hw_rng_model','virtio'),('2025-11-28 10:09:14',NULL,'2025-11-28 10:09:16',1,55,'b352ba15-335d-4fa7-b53c-70aaa91cdb89',NULL,'image_id','85968a96-5a0e-43a4-9c04-3954f640a7ed'),('2025-11-28 10:09:14',NULL,'2025-11-28 10:09:16',1,56,'b352ba15-335d-4fa7-b53c-70aaa91cdb89',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-28 10:09:14',NULL,'2025-11-28 10:09:16',1,57,'b352ba15-335d-4fa7-b53c-70aaa91cdb89',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-28 10:09:14',NULL,'2025-11-28 10:09:16',1,58,'b352ba15-335d-4fa7-b53c-70aaa91cdb89',NULL,'container_format','bare'),('2025-11-28 10:09:14',NULL,'2025-11-28 10:09:16',1,59,'b352ba15-335d-4fa7-b53c-70aaa91cdb89',NULL,'disk_format','qcow2'),('2025-11-28 10:09:14',NULL,'2025-11-28 10:09:16',1,60,'b352ba15-335d-4fa7-b53c-70aaa91cdb89',NULL,'min_disk','0'),('2025-11-28 10:09:14',NULL,'2025-11-28 10:09:16',1,61,'b352ba15-335d-4fa7-b53c-70aaa91cdb89',NULL,'min_ram','0'),('2025-11-28 10:09:14',NULL,'2025-11-28 10:09:16',1,62,'b352ba15-335d-4fa7-b53c-70aaa91cdb89',NULL,'size','21430272'),('2025-11-28 10:09:44',NULL,'2025-11-28 10:09:53',1,63,'4892dc00-f0e8-4ba0-bef5-a429066ff3a7',NULL,'signature_verified','False'),('2025-11-28 10:09:48',NULL,'2025-11-28 10:09:53',1,64,'4892dc00-f0e8-4ba0-bef5-a429066ff3a7',NULL,'hw_rng_model','virtio'),('2025-11-28 10:09:48',NULL,'2025-11-28 10:09:53',1,65,'4892dc00-f0e8-4ba0-bef5-a429066ff3a7',NULL,'image_id','85968a96-5a0e-43a4-9c04-3954f640a7ed'),('2025-11-28 10:09:48',NULL,'2025-11-28 10:09:53',1,66,'4892dc00-f0e8-4ba0-bef5-a429066ff3a7',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-28 10:09:48',NULL,'2025-11-28 10:09:53',1,67,'4892dc00-f0e8-4ba0-bef5-a429066ff3a7',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-28 10:09:48',NULL,'2025-11-28 10:09:53',1,68,'4892dc00-f0e8-4ba0-bef5-a429066ff3a7',NULL,'container_format','bare'),('2025-11-28 10:09:48',NULL,'2025-11-28 10:09:53',1,69,'4892dc00-f0e8-4ba0-bef5-a429066ff3a7',NULL,'disk_format','qcow2'),('2025-11-28 10:09:48',NULL,'2025-11-28 10:09:53',1,70,'4892dc00-f0e8-4ba0-bef5-a429066ff3a7',NULL,'min_disk','0'),('2025-11-28 10:09:48',NULL,'2025-11-28 10:09:53',1,71,'4892dc00-f0e8-4ba0-bef5-a429066ff3a7',NULL,'min_ram','0'),('2025-11-28 10:09:48',NULL,'2025-11-28 10:09:53',1,72,'4892dc00-f0e8-4ba0-bef5-a429066ff3a7',NULL,'size','21430272');
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
INSERT INTO `volume_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `key`, `value`) VALUES ('2025-11-28 10:06:03','2025-11-28 10:06:03','2025-11-28 10:06:03',1,1,'8f85faad-5932-4590-95c0-c4ce838742fb','key1','value1_update'),('2025-11-28 10:06:03','2025-11-28 10:06:03','2025-11-28 10:06:03',1,2,'8f85faad-5932-4590-95c0-c4ce838742fb','key2','value2'),('2025-11-28 10:06:03','2025-11-28 10:06:03','2025-11-28 10:06:03',1,3,'8f85faad-5932-4590-95c0-c4ce838742fb','key3','value3'),('2025-11-28 10:06:03','2025-11-28 10:06:03','2025-11-28 10:06:03',1,4,'8f85faad-5932-4590-95c0-c4ce838742fb','key4','value4'),('2025-11-28 10:06:03','2025-11-28 10:06:04','2025-11-28 10:06:04',1,5,'8f85faad-5932-4590-95c0-c4ce838742fb','key1','value1'),('2025-11-28 10:06:03','2025-11-28 10:06:04','2025-11-28 10:06:04',1,6,'8f85faad-5932-4590-95c0-c4ce838742fb','key2','value2'),('2025-11-28 10:06:03','2025-11-28 10:06:04','2025-11-28 10:06:04',1,7,'8f85faad-5932-4590-95c0-c4ce838742fb','key3','value3_update'),('2025-11-28 10:06:09',NULL,'2025-11-28 10:06:11',1,8,'d0de0b22-5f61-4344-a73e-704f542a8f23','src_backup_id','9f3517e9-25ac-4726-b091-74cec2691488'),('2025-11-28 10:06:38',NULL,'2025-11-28 10:06:40',1,9,'ba20f281-f8ef-460a-a916-8659cb86fe77','src_backup_id','b90dfbda-b3d9-40c5-98ea-bad0a8f43d72'),('2025-11-28 10:06:50',NULL,'2025-11-28 10:07:05',1,10,'1e28f2fe-0f3a-4cd7-adeb-6e11eb668dfa','Type','work'),('2025-11-28 10:06:51',NULL,'2025-11-28 10:07:02',1,11,'aea10aff-4c4e-4172-b969-91a0c04cf9c4','Type','work'),('2025-11-28 10:06:53',NULL,'2025-11-28 10:06:59',1,12,'fdbbaa71-48fa-4391-ab9a-950e96883f3c','Type','work'),('2025-11-28 10:09:26',NULL,'2025-11-28 10:09:32',1,13,'551787d0-92be-4f4b-bfe2-c9b6b7fe4fd1','Type','Test'),('2025-11-28 10:09:34',NULL,'2025-11-28 10:09:41',1,14,'eaf296fa-7079-472c-9fa1-865447808257','Type','Test'),('2025-11-28 10:09:42',NULL,'2025-11-28 10:09:53',1,15,'4892dc00-f0e8-4ba0-bef5-a429066ff3a7','Type','Test');
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
INSERT INTO `volume_type_extra_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_type_id`, `key`, `value`) VALUES ('2025-11-28 10:04:38',NULL,'2025-11-28 10:04:38',1,1,'779fc8f9-146d-4ecc-ac4f-dfab08c74e33','spec1','val1'),('2025-11-28 10:05:39',NULL,'2025-11-28 10:05:39',1,2,'2c4c1e2a-dfae-4630-bfbf-4242b0af7695','spec3','val1'),('2025-11-28 10:05:40',NULL,'2025-11-28 10:05:40',1,3,'2c4c1e2a-dfae-4630-bfbf-4242b0af7695','spec1','val1'),('2025-11-28 10:05:40','2025-11-28 10:05:40','2025-11-28 10:05:40',1,4,'2c4c1e2a-dfae-4630-bfbf-4242b0af7695','spec2','val3'),('2025-11-28 10:05:40',NULL,'2025-11-28 10:05:40',1,5,'2c4c1e2a-dfae-4630-bfbf-4242b0af7695','spec4','val4'),('2025-11-28 10:08:39',NULL,'2025-11-28 10:08:39',1,6,'9cda10c8-dd7c-4c7d-a0a4-d2f227f94a2a','storage_protocol','iSCSI'),('2025-11-28 10:08:39',NULL,'2025-11-28 10:08:39',1,7,'9cda10c8-dd7c-4c7d-a0a4-d2f227f94a2a','vendor_name','Open Source'),('2025-11-28 10:08:57',NULL,'2025-11-28 10:08:58',1,8,'57626bb5-ef99-4f80-9808-c2abd2c69f4c','storage_protocol','tempest-storage_protocol-1117781501'),('2025-11-28 10:08:57',NULL,'2025-11-28 10:08:58',1,9,'57626bb5-ef99-4f80-9808-c2abd2c69f4c','vendor_name','tempest-vendor_name-1645169552'),('2025-11-28 10:08:58',NULL,'2025-11-28 10:09:00',1,10,'13813c7d-a460-4556-babd-44f8c94e01b3','storage_protocol','tempest-storage_protocol-366155599'),('2025-11-28 10:08:58',NULL,'2025-11-28 10:09:00',1,11,'13813c7d-a460-4556-babd-44f8c94e01b3','vendor_name','tempest-vendor_name-125559852');
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
INSERT INTO `volume_type_projects` (`id`, `created_at`, `updated_at`, `deleted_at`, `volume_type_id`, `project_id`, `deleted`) VALUES (1,'2025-11-28 10:04:27',NULL,'2025-11-28 10:04:29','28497b99-6fc7-4605-a27c-c9e5edd31ccf','70de67fe9f1d43a793c239829fcd6ef2',1),(2,'2025-11-28 10:04:29',NULL,'2025-11-28 10:04:29','3526c3e7-f1a3-4d3d-aa5e-11cffc35cfb2','70de67fe9f1d43a793c239829fcd6ef2',2),(3,'2025-11-28 10:04:29',NULL,'2025-11-28 10:04:29','3526c3e7-f1a3-4d3d-aa5e-11cffc35cfb2','9411c201a4d84f2bbafab50cddd239fa',3);
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`is_public` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2025-11-28 10:08:30',NULL,'2025-11-28 10:08:38',1,'0597ffbc-528c-4291-980f-e63e19b57f1a','tempest-GroupsTest-volume-type-541534715',NULL,1,NULL),('2025-11-28 10:05:49',NULL,'2025-11-28 10:05:49',1,'0a51e716-12fd-4f45-bc8c-a9ceabb68008','tempest-VolumeTypesNegativeTest-volume-type-1656682684',NULL,0,NULL),('2025-11-28 10:08:58',NULL,'2025-11-28 10:09:00',1,'13813c7d-a460-4556-babd-44f8c94e01b3','tempest-UserMessagesTest-volume-type-1856484675',NULL,1,NULL),('2025-11-28 10:08:23',NULL,'2025-11-28 10:08:30',1,'20e0a967-28dc-4052-8098-21af5d5e2558','tempest-GroupsTest-volume-type-1256221482',NULL,1,NULL),('2025-11-28 10:04:27',NULL,'2025-11-28 10:04:29',1,'28497b99-6fc7-4605-a27c-c9e5edd31ccf','tempest-VolumeTypesAccessTest-volume-type-1038300301',NULL,0,NULL),('2025-11-28 10:05:39',NULL,'2025-11-28 10:05:40',1,'2c4c1e2a-dfae-4630-bfbf-4242b0af7695','tempest-VolumeTypesExtraSpecsTest-volume-type-1644325883',NULL,1,NULL),('2025-11-28 10:05:29',NULL,'2025-11-28 10:05:33',1,'304af168-d2b0-4ca9-a502-313ca6aa1b60','volume-type-1',NULL,1,NULL),('2025-11-28 08:14:45','2025-11-28 08:14:45','2025-11-28 08:22:25',1,'30e8c5f1-cd69-4800-973c-112d0dd6231b','__DEFAULT__',NULL,1,'Default Volume Type'),('2025-11-28 10:04:29',NULL,'2025-11-28 10:04:29',1,'3526c3e7-f1a3-4d3d-aa5e-11cffc35cfb2','tempest-VolumeTypesAccessTest-volume-type-1234782273',NULL,0,NULL),('2025-11-28 10:08:43','2025-11-28 10:08:44','2025-11-28 10:08:44',1,'454ec861-50ef-4abd-9f04-5e77369aaa4b','tempest-QosSpecsTestJSON-volume-type-814587684',NULL,1,NULL),('2025-11-28 10:08:57',NULL,'2025-11-28 10:08:58',1,'57626bb5-ef99-4f80-9808-c2abd2c69f4c','tempest-UserMessagesTest-volume-type-537457498',NULL,1,NULL),('2025-11-28 10:03:47',NULL,'2025-11-28 10:04:04',1,'5bb8e5c1-b168-4814-b7f9-c6b116731dc3','tempest-GroupSnapshotsTest-volume-type-835004530',NULL,1,NULL),('2025-11-28 10:08:43','2025-11-28 10:08:44','2025-11-28 10:08:44',1,'659d1d17-9bf2-41b2-bd69-5f9f297bf43f','tempest-QosSpecsTestJSON-volume-type-797237050',NULL,1,NULL),('2025-11-28 10:04:38',NULL,'2025-11-28 10:04:38',1,'779fc8f9-146d-4ecc-ac4f-dfab08c74e33','tempest-ExtraSpecsNegativeTest-volume-type-187926534',NULL,1,NULL),('2025-11-28 10:05:29',NULL,'2025-11-28 10:05:33',1,'7e64364b-87e8-4f24-90aa-eace434f412b','volume-type-2',NULL,1,NULL),('2025-11-28 10:04:04',NULL,'2025-11-28 10:04:10',1,'80703c86-0cc3-4b56-99e8-bbda90d2bedd','tempest-GroupSnapshotsTest-volume-type-807881257',NULL,1,NULL),('2025-11-28 08:22:20',NULL,NULL,0,'81cd8392-f063-4c6f-92d5-8c65f8ede5db','tripleo',NULL,1,NULL),('2025-11-28 10:07:41',NULL,'2025-11-28 10:07:52',1,'8206fca6-970a-4db0-a8a4-eeedbc6e2000','tempest-GroupSnapshotsV319Test-volume-type-1428748724',NULL,1,NULL),('2025-11-28 10:05:49',NULL,'2025-11-28 10:05:49',1,'9a1e0bd3-51ca-4cdc-8b5a-4978f846c935','tempest-VolumeTypesNegativeTest-volume-type-523933885',NULL,1,NULL),('2025-11-28 10:08:39',NULL,'2025-11-28 10:08:39',1,'9cda10c8-dd7c-4c7d-a0a4-d2f227f94a2a','tempest-VolumeTypesTest-volume-type-798451113',NULL,1,'tempest-volume-type-description-81651043'),('2025-11-28 10:05:32',NULL,'2025-11-28 10:05:40',1,'9e639737-6ba0-4823-95c4-cc509eaf4ceb','tempest-GroupsV314Test-volume-type-739357787',NULL,1,NULL),('2025-11-28 10:08:39',NULL,'2025-11-28 10:08:39',1,'a982fd09-a91b-47e6-8418-b6472e830642','tempest-VolumeTypesTest-volume-type-1370120816',NULL,1,NULL),('2025-11-28 10:09:05',NULL,'2025-11-28 10:09:05',1,'d5e98699-1fd4-4d91-acbd-88d1b3591a24','tempest-VolumeQuotaClassesTest-volume-type-3430912',NULL,1,NULL),('2025-11-28 10:08:40','2025-11-28 10:08:40','2025-11-28 10:08:40',1,'d97487ee-7146-4030-81df-51162157689c','tempest-volume-type-2141070796',NULL,0,'tempest-volume-type-description-1166056690'),('2025-11-28 10:08:43','2025-11-28 10:08:43','2025-11-28 10:08:44',1,'e82714c5-3e1f-4dbe-b4b1-dc7d70d08aca','tempest-QosSpecsTestJSON-volume-type-999496854',NULL,1,NULL),('2025-11-28 10:08:30',NULL,'2025-11-28 10:08:33',1,'f59c6f03-04cc-4d37-ab75-f9948448d675','tempest-GroupsV320Test-volume-type-754146453',NULL,1,NULL),('2025-11-28 10:03:33',NULL,'2025-11-28 10:03:47',1,'fb386a3c-f41c-4344-a8ff-4193ab81f512','tempest-GroupSnapshotsTest-volume-type-1857876428',NULL,1,NULL);
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`bootable` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`multiattach` in (0,1)),
  CONSTRAINT `CONSTRAINT_4` CHECK (`shared_targets` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
INSERT INTO `volumes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `ec2_id`, `user_id`, `project_id`, `host`, `size`, `availability_zone`, `status`, `attach_status`, `scheduled_at`, `launched_at`, `terminated_at`, `display_name`, `display_description`, `provider_location`, `provider_auth`, `snapshot_id`, `volume_type_id`, `source_volid`, `bootable`, `provider_geometry`, `_name_id`, `encryption_key_id`, `migration_status`, `replication_status`, `replication_extended_status`, `replication_driver_data`, `consistencygroup_id`, `provider_id`, `multiattach`, `previous_status`, `cluster_name`, `group_id`, `service_uuid`, `shared_targets`, `use_quota`) VALUES ('2025-11-28 10:08:02','2025-11-28 10:08:03','2025-11-28 10:08:03',1,'0f63557c-ff5a-4c68-af93-4471e6e7aa9e',NULL,'6a89f5a2896d47ad962186b0b7b1a2de','5171816b5d3845278c70b062bedaa177','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:08:02','2025-11-28 10:08:02','2025-11-28 10:08:03','tempest-VolumeQuotasAdminTestJSON-Volume-1859898440',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:09:33','2025-11-28 10:09:41','2025-11-28 10:09:42',1,'12b76a79-c5e4-4af3-a994-e2ada2b6da6f',NULL,'b9ac6ab3dd0b4f7a93a114e6ff84cd7a','df6949ad183e4e1e8db4a49117054e84','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:09:33','2025-11-28 10:09:33','2025-11-28 10:09:41','tempest-VolumesGetTest-Volume-1125444931',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:05:36','2025-11-28 10:05:38','2025-11-28 10:05:38',1,'148aa949-b665-4716-886c-0b5b1510790f',NULL,'c0286a07766246c0b685593779a1b7bd','5c1cc8bd04e04964bf55c27886efbf5c','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'9e639737-6ba0-4823-95c4-cc509eaf4ceb','e1e62b1f-1cfc-4c00-a2fb-935d8e95ef31',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'8cc9871e-6178-490e-a36d-6126432cf64b',NULL,1,1),('2025-11-28 10:09:55','2025-11-28 10:09:57','2025-11-28 10:09:57',1,'176d5f5f-8717-423f-b79c-6e40af4a760f',NULL,'3e0c0f1d7904439c976f777b4f3c59a9','3e2ec027cab64e90a22b087eafacf760','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:09:55','2025-11-28 10:09:56','2025-11-28 10:09:57','tempest-VolumesSnapshotTestJSON-Volume-1673317150',NULL,NULL,NULL,'4444cce2-dceb-4cf6-a170-cd50860695b1','81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:05:55','2025-11-28 10:06:13','2025-11-28 10:06:14',1,'19ea2973-b5b1-456d-a6a8-e46bc69b156d',NULL,'3149cb791b864349a3ef9639d9664574','d2d31a928b84446c97d35bb770c268e5','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:05:56','2025-11-28 10:05:56','2025-11-28 10:06:13','tempest-VolumesBackupsAdminTest-Volume-188316658',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:09:44','2025-11-28 10:09:50','2025-11-28 10:09:51',1,'1a5b9f39-1bc5-4eeb-9fd7-4c8e363a63a3',NULL,'3e0c0f1d7904439c976f777b4f3c59a9','3e2ec027cab64e90a22b087eafacf760','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:09:45','2025-11-28 10:09:45','2025-11-28 10:09:50','tempest-VolumesSnapshotTestJSON-Volume-255374114',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:06:15','2025-11-28 10:06:22','2025-11-28 10:06:24',1,'1b200e79-095d-4520-bba6-ede140fda7b2',NULL,'3149cb791b864349a3ef9639d9664574','d2d31a928b84446c97d35bb770c268e5','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:06:15','2025-11-28 10:06:15','2025-11-28 10:06:22','tempest-VolumesBackupsAdminTest-Volume-1504906136',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:06:50','2025-11-28 10:07:03','2025-11-28 10:07:05',1,'1e28f2fe-0f3a-4cd7-adeb-6e11eb668dfa',NULL,'fdd5d9aeb097405795bc809f7d091c26','a1eb2d80861b4077b9ef4c3389f19286','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:06:50','2025-11-28 10:06:50','2025-11-28 10:07:03','tempest-VolumesListTestJSON-Volume-199090755',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:06:08','2025-11-28 10:06:10','2025-11-28 10:06:10',1,'1e3bfd66-8752-40f9-8f2d-1623f219824d',NULL,'117a085f54e0434f9a993b9abe38624d','e8a245ce85d845b5aa0d1f9c0238c9e1','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:06:09','2025-11-28 10:06:09','2025-11-28 10:06:10','tempest-VolumesServicesTestJSON-Volume-1620851388',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:09:10','2025-11-28 10:09:12','2025-11-28 10:09:13',1,'20692b0c-b28a-4a08-b474-b84e48dea956',NULL,'67e2445009bb4f0f8f7daf92e0d698b8','6da8102120594d6c98901d137ca0bc9b','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:09:10','2025-11-28 10:09:10','2025-11-28 10:09:12','tempest-VolumeQuotasNegativeTestJSON-Volume-789574185',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:03:49','2025-11-28 10:04:03','2025-11-28 10:04:03',1,'21022556-6fd5-4b51-855b-5d93bf93c547',NULL,'fe65864ca994460c9f786e2a187aa538','115c143e37394d77b81665435ce51c10','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:03:49','2025-11-28 10:03:49',NULL,'tempest-volume-1102975088',NULL,NULL,NULL,NULL,'5bb8e5c1-b168-4814-b7f9-c6b116731dc3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'90a7920b-efc2-4c48-9c81-f901f0607aaf','6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:06:24','2025-11-28 10:07:12','2025-11-28 10:07:13',1,'2ba804be-3cec-4533-8cb3-cdcaacce6a06',NULL,'a23b9285fdb048bb82226cc138cfb339','29d0d5b3ba0745d58aee3845ea704b73','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:06:24','2025-11-28 10:06:24','2025-11-28 10:07:12','tempest-VolumesActionsTest-Volume-2044509663',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:09:08','2025-11-28 10:09:16','2025-11-28 10:09:17',1,'2be343e1-0720-4240-8d53-d6ea9dba43a0',NULL,'b4f253dd53c54043a43353fe20d0964d','673b477f9d70449480701aa9846d8f60','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:09:08','2025-11-28 10:09:13','2025-11-28 10:09:16','tempest-VolumesCloneTest-Volume-367580696',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:08:25','2025-11-28 10:08:28','2025-11-28 10:08:28',1,'2c92cb51-9caf-4e55-a4c9-1cd3bcac47a8',NULL,'7b566f8cb0d949bc89f5b8706fa7ef3f','708e5a4db87c470c994eb117a4c58083','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:08:26','2025-11-28 10:08:26',NULL,'tempest-volume-794265601',NULL,NULL,NULL,NULL,'20e0a967-28dc-4052-8098-21af5d5e2558',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'3bb1a8a3-e81b-4656-b516-5153fdf461b8','6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:09:18','2025-11-28 10:09:23','2025-11-28 10:09:24',1,'2e9cc95b-6af3-4d96-992c-c46ccf9e3c9c',NULL,'734ab171f3e74a6888b27f8bfe048473','e67c42de6de84a6eba7382934e59b9b3','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:09:19','2025-11-28 10:09:19','2025-11-28 10:09:23','tempest-VolumeSnapshotQuotasNegativeTestJSON-Volume-341755682',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:08:19','2025-11-28 10:08:21','2025-11-28 10:08:22',1,'33950d06-fc08-4c03-be84-d2f665efc921',NULL,'d00591a3ea0a49e4a6b4f6412a179daf','e40ad514f1414282aba0c087f08f4797','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:08:19','2025-11-28 10:08:19','2025-11-28 10:08:21','tempest-VolumesTransfersV357Test-Volume-1942580427',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:03:35','2025-11-28 10:03:46','2025-11-28 10:03:46',1,'35675ea9-f512-49d3-9b24-ebad1a252f73',NULL,'fe65864ca994460c9f786e2a187aa538','115c143e37394d77b81665435ce51c10','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:03:35','2025-11-28 10:03:37',NULL,'tempest-volume-1779858995',NULL,NULL,NULL,NULL,'fb386a3c-f41c-4344-a8ff-4193ab81f512',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'39505b62-0741-4d93-9e2f-a0407f5bf3b3','6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:05:49','2025-11-28 10:05:59','2025-11-28 10:05:59',1,'3ca1f192-d8a6-4d41-a193-b54d7adca069',NULL,'f46816cd3c564ba389a739ec48b81a14','38c774f4f3a34ba7822603fa362cd4c8','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:05:49','2025-11-28 10:05:58','2025-11-28 10:05:59','tempest-VolumesImageMetadata-Volume-414639797',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:08:27','2025-11-28 10:08:33','2025-11-28 10:08:33',1,'3f422f6d-4527-49fa-8d66-5a09d9d5964b',NULL,'204e4aad7e2340eebed299dd8030708b','6732fa86445147cdb019a2189d601a62','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-11-28 10:08:27','2025-11-28 10:08:27','2025-11-28 10:08:33','tempest-VolumesExtendTest-Volume-1835358864',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:06:32','2025-11-28 10:06:34','2025-11-28 10:06:35',1,'406274d6-0728-4fc5-a564-5f713ebc07bb',NULL,'be97c4ddafb44556909c1e0abac9ef55','030c225d7ed34b12a2a9020cd72dbf3a','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:06:32','2025-11-28 10:06:32','2025-11-28 10:06:34','tempest-VolumesTransfersTest-Volume-259966384',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:08:32','2025-11-28 10:08:37','2025-11-28 10:08:37',1,'436249b1-dd17-44ae-b229-d1c7b1a2ca4c',NULL,'7b566f8cb0d949bc89f5b8706fa7ef3f','708e5a4db87c470c994eb117a4c58083','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:08:32','2025-11-28 10:08:33',NULL,'tempest-volume-1974358440',NULL,NULL,NULL,NULL,'0597ffbc-528c-4291-980f-e63e19b57f1a',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'c9b3b6d2-1582-40c6-b22c-254fe470ec9c','6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:05:45','2025-11-28 10:05:50','2025-11-28 10:05:50',1,'440192cb-b293-4b11-a750-420f2b48bf74',NULL,'3ff9ea6d4ad646d8b2459f66f1af33fc','ba7456648a0f43028832ef04ff1d03da','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:05:45','2025-11-28 10:05:45','2025-11-28 10:05:50','tempest-SnapshotMetadataTestJSON-Volume-1412397367',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:09:52','2025-11-28 10:09:59','2025-11-28 10:09:59',1,'459cfae8-1cbd-4766-b8f0-28736fe59db4',NULL,'3e0c0f1d7904439c976f777b4f3c59a9','3e2ec027cab64e90a22b087eafacf760','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:09:52','2025-11-28 10:09:52','2025-11-28 10:09:59','tempest-VolumesSnapshotTestJSON-Volume-1962929507',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:09:19','2025-11-28 10:09:20','2025-11-28 10:09:20',1,'47a460db-13c3-4afc-bcc0-548289eb3c64',NULL,'b4f253dd53c54043a43353fe20d0964d','673b477f9d70449480701aa9846d8f60','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-11-28 10:09:19','2025-11-28 10:09:20','2025-11-28 10:09:20','tempest-VolumesCloneTest-Volume-834388113',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db','5527cd54-6748-4890-8c69-db01fd0d25fb',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:09:42','2025-11-28 10:09:52','2025-11-28 10:09:53',1,'4892dc00-f0e8-4ba0-bef5-a429066ff3a7',NULL,'b9ac6ab3dd0b4f7a93a114e6ff84cd7a','df6949ad183e4e1e8db4a49117054e84','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:09:43','2025-11-28 10:09:48','2025-11-28 10:09:52','tempest-VolumesGetTest-new-Volume-486457562','This is the new description of volume',NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:08:55','2025-11-28 10:09:03','2025-11-28 10:09:04',1,'4aea0048-53f9-41a0-8417-303e43589ac8',NULL,'463f0a482daf45f1b54b00148c9c0291','af627bb6800b48f795f524c5240dd96e','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:08:56','2025-11-28 10:08:56','2025-11-28 10:09:03','tempest-VolumesListAdminTestJSON-Volume-606635856',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:05:27','2025-11-28 10:05:28','2025-11-28 10:05:29',1,'55093d27-9f6d-47d4-9706-86879d2f1fa5',NULL,'fae7d4d0d8c7416fa91763e2c8fbce1c','aa5be61eafca4d96976422f0e0103210','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:05:27','2025-11-28 10:05:27','2025-11-28 10:05:28','tempest-VolumesActionsTest-Volume-1266043459',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:09:26','2025-11-28 10:09:31','2025-11-28 10:09:32',1,'551787d0-92be-4f4b-bfe2-c9b6b7fe4fd1',NULL,'b9ac6ab3dd0b4f7a93a114e6ff84cd7a','df6949ad183e4e1e8db4a49117054e84','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:09:26','2025-11-28 10:09:26','2025-11-28 10:09:31','tempest-VolumesGetTest-new-Volume-1314890551','This is the new description of volume',NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:09:17','2025-11-28 10:09:21','2025-11-28 10:09:22',1,'5527cd54-6748-4890-8c69-db01fd0d25fb',NULL,'b4f253dd53c54043a43353fe20d0964d','673b477f9d70449480701aa9846d8f60','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:09:18','2025-11-28 10:09:18','2025-11-28 10:09:21','tempest-VolumesCloneTest-Volume-1141199075',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:04:05','2025-11-28 10:04:10','2025-11-28 10:04:10',1,'56adaabf-286b-425c-8224-b7a9554b04b4',NULL,'fe65864ca994460c9f786e2a187aa538','115c143e37394d77b81665435ce51c10','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:04:05','2025-11-28 10:04:06',NULL,'tempest-volume-1215790940',NULL,NULL,NULL,NULL,'80703c86-0cc3-4b56-99e8-bbda90d2bedd',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'ebd685df-6615-42cf-b71c-80d71cdc9535','6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:08:31','2025-11-28 10:08:50','2025-11-28 10:08:50',1,'596a022d-09b3-4d24-9e17-a6b92d595b8a',NULL,'9f195c7e6aa347d4966c7781cadc2cee','a6f735cf317e42218560e5eb75b569f6','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:08:31','2025-11-28 10:08:31','2025-11-28 10:08:50','tempest-SnapshotsActionsTest-Volume-298134539',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:06:21','2025-11-28 10:06:43','2025-11-28 10:06:46',1,'5a82eb95-1559-4a88-822e-951361a380e2',NULL,'87cf17c48bab44279b2e7eca9e0882a2','d3c0d1ce8d854a7b9ffc953e88cd2c44','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:06:21','2025-11-28 10:06:26','2025-11-28 10:06:43','tempest-VolumesBackupsTest-Volume-282582525',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:08:31','2025-11-28 10:08:37','2025-11-28 10:08:38',1,'6481bd95-1948-44e5-80ae-5ce3e28ff090',NULL,'7b566f8cb0d949bc89f5b8706fa7ef3f','708e5a4db87c470c994eb117a4c58083','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:08:31','2025-11-28 10:08:31',NULL,'tempest-volume-7306467',NULL,NULL,NULL,NULL,'0597ffbc-528c-4291-980f-e63e19b57f1a',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'c9b3b6d2-1582-40c6-b22c-254fe470ec9c','6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:08:49','2025-11-28 10:08:51','2025-11-28 10:08:51',1,'66270463-29bc-426b-9bee-4ac99727025f',NULL,'2c9cf04d80854625937382a24a03de76','e7cc91f8f0484d558c7d91f23a229370','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:08:49','2025-11-28 10:08:49','2025-11-28 10:08:51','tempest-VolumesTransfersV355Test-Volume-1995678508',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:09:27','2025-11-28 10:09:28','2025-11-28 10:09:30',1,'6d36fd4b-a030-4d8a-bd11-b636bed09d74',NULL,'b9ac6ab3dd0b4f7a93a114e6ff84cd7a','df6949ad183e4e1e8db4a49117054e84','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:09:27','2025-11-28 10:09:28','2025-11-28 10:09:28','tempest-VolumesGetTest-Volume-2079455319',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:06:34','2025-11-28 10:06:44','2025-11-28 10:06:45',1,'6ffe84bb-45c1-44a1-8d18-9a1115a2fc59',NULL,'fcce45225cfa4ce6b64c668fe9c9cb2c','85f17f60fae2462cb663ba226772cedd','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:06:34','2025-11-28 10:06:35','2025-11-28 10:06:44','tempest-VolumesDeleteCascade-Volume-350739512',NULL,NULL,NULL,'6dd19e2d-1850-46c5-8d88-3be915e8807a','81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:07:34','2025-11-28 10:07:44','2025-11-28 10:07:46',1,'7a6e1031-8ab9-4ee4-a1fb-2c6bf7bfe852',NULL,'67612e3b1c4e49a08c92601eb6d60858','7dd88588dc3b46ab8658061b1ac13996','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:07:35','2025-11-28 10:07:36','2025-11-28 10:07:44','tempest-VolumesNegativeTest-Volume-806516086',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:05:29','2025-11-28 10:05:32','2025-11-28 10:05:32',1,'7e9c53cf-004b-440a-a0f7-aa05f5b350db',NULL,'117d90e37590425482be7f5ca8861ab3','cc1fbd7319614f7ab4566dfed25610b8','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:05:30','2025-11-28 10:05:30','2025-11-28 10:05:32','tempest-VolumeRetypeWithoutMigrationTest-Volume-1664892553',NULL,NULL,NULL,NULL,'7e64364b-87e8-4f24-90aa-eace434f412b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:08:52','2025-11-28 10:08:53','2025-11-28 10:08:54',1,'7fb5a324-9940-41e3-b2b7-3d52eacf9685',NULL,'fb7c8f09a45e480e8b0b39091e94d6b0','282cf5c7f55f44abb1217a52fa10743f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:08:52','2025-11-28 10:08:52','2025-11-28 10:08:53','tempest-VolumesTransfersV355Test-Volume-640455229',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:07:14','2025-11-28 10:07:26','2025-11-28 10:07:26',1,'8291a367-8c2f-4aba-b040-ce2be12abee0',NULL,'883e728ccb5648cbaf84cd0cbbd59aba','7369c667b30341f7b300e32774b31181','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:07:15','2025-11-28 10:07:15','2025-11-28 10:07:26','tempest-VolumesSnapshotListTestJSON-Volume-290154782',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:03:39','2025-11-28 10:03:42','2025-11-28 10:03:42',1,'84ea89f2-12f6-4d27-b190-9eda209d6383',NULL,'fe65864ca994460c9f786e2a187aa538','115c143e37394d77b81665435ce51c10','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'b8923c3e-0b65-497d-9875-9388e1c13731','fb386a3c-f41c-4344-a8ff-4193ab81f512',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'0efce84a-39bd-4602-8342-d23c0189db75',NULL,1,1),('2025-11-28 10:04:27','2025-11-28 10:04:28','2025-11-28 10:04:29',1,'88349b82-e84b-470b-8d54-3b0a4d6318da',NULL,'396301196c3347439dbe21dc63938d37','70de67fe9f1d43a793c239829fcd6ef2','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:04:27','2025-11-28 10:04:27','2025-11-28 10:04:28','tempest-VolumeTypesAccessTest-Volume-1976805818',NULL,NULL,NULL,NULL,'28497b99-6fc7-4605-a27c-c9e5edd31ccf',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:05:30','2025-11-28 10:05:31','2025-11-28 10:05:32',1,'8dd650f1-e5cb-419f-ac25-246f3477a5ff',NULL,'fae7d4d0d8c7416fa91763e2c8fbce1c','aa5be61eafca4d96976422f0e0103210','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:05:30','2025-11-28 10:05:30','2025-11-28 10:05:31','tempest-VolumesActionsTest-Volume-1199353658',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:06:02','2025-11-28 10:06:04','2025-11-28 10:06:04',1,'8f85faad-5932-4590-95c0-c4ce838742fb',NULL,'9fea8a2c86e844838cfa99f187754b04','09ce8f94e31a412b82a6b18baad225fe','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:06:02','2025-11-28 10:06:02','2025-11-28 10:06:04','tempest-VolumesMetadataTest-Volume-44941462',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:08:58','2025-11-28 10:09:01','2025-11-28 10:09:02',1,'8fde7eda-9515-497c-a4ef-613f6592ec01',NULL,'463f0a482daf45f1b54b00148c9c0291','af627bb6800b48f795f524c5240dd96e','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:08:58','2025-11-28 10:08:58','2025-11-28 10:09:01','tempest-VolumesListAdminTestJSON-Volume-351597875',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:07:27','2025-11-28 10:07:28','2025-11-28 10:07:29',1,'91c95082-8f57-45bc-9c77-23e7df6aecf7',NULL,'ad2176136d4f4e5fa6103d8fa21d86ca','b4ab010fc80b442f8f29d2f02f18ecc9','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-11-28 10:07:27','2025-11-28 10:07:27','2025-11-28 10:07:28','tempest-VolumesCloneNegativeTest-Volume-1239747447',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:05:19','2025-11-28 10:05:21','2025-11-28 10:05:21',1,'926e222c-4d5b-47b9-9147-518b9c184e36',NULL,'fae7d4d0d8c7416fa91763e2c8fbce1c','aa5be61eafca4d96976422f0e0103210','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:05:19','2025-11-28 10:05:19','2025-11-28 10:05:21','tempest-VolumesActionsTest-Volume-1890460576',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:03:50','2025-11-28 10:04:03','2025-11-28 10:04:03',1,'93b53a10-ec03-4d6b-a5c0-b9bab815117b',NULL,'fe65864ca994460c9f786e2a187aa538','115c143e37394d77b81665435ce51c10','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:03:50','2025-11-28 10:03:50',NULL,'tempest-volume-1172950012',NULL,NULL,NULL,NULL,'5bb8e5c1-b168-4814-b7f9-c6b116731dc3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'90a7920b-efc2-4c48-9c81-f901f0607aaf','6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:09:00','2025-11-28 10:09:06','2025-11-28 10:09:08',1,'a1e919fa-31eb-43c9-a2c1-f5491ff82934',NULL,'e3c99f9fe4d541e6b1670e0d113fcd19','fc7fccbd32a74bc3b7becd3530d9005e','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:09:00','2025-11-28 10:09:00','2025-11-28 10:09:06','tempest-VolumesBackupsV39Test-Volume-1746977495',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:05:24','2025-11-28 10:05:26','2025-11-28 10:05:26',1,'a3c88a38-eec0-44b6-b7b2-33342085d912',NULL,'fae7d4d0d8c7416fa91763e2c8fbce1c','aa5be61eafca4d96976422f0e0103210','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:05:25','2025-11-28 10:05:25','2025-11-28 10:05:26','tempest-VolumesActionsTest-Volume-1409836180',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:06:35','2025-11-28 10:06:37','2025-11-28 10:06:38',1,'ab0bacba-4829-4f55-aaae-0bcba18e585b',NULL,'2087eeee3b234b87a20f8c5b2d97b53b','87556d11d3894443a0252992df39cd59','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:06:35','2025-11-28 10:06:36','2025-11-28 10:06:37','tempest-VolumesTransfersTest-Volume-2014142638',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:05:22','2025-11-28 10:05:23','2025-11-28 10:05:24',1,'add3c8a1-d4cc-47e4-a136-684aedb3cf21',NULL,'fae7d4d0d8c7416fa91763e2c8fbce1c','aa5be61eafca4d96976422f0e0103210','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:05:22','2025-11-28 10:05:22','2025-11-28 10:05:23','tempest-VolumesActionsTest-Volume-1998320503',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:06:51','2025-11-28 10:07:01','2025-11-28 10:07:02',1,'aea10aff-4c4e-4172-b969-91a0c04cf9c4',NULL,'fdd5d9aeb097405795bc809f7d091c26','a1eb2d80861b4077b9ef4c3389f19286','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:06:52','2025-11-28 10:06:52','2025-11-28 10:07:01','tempest-VolumesListTestJSON-Volume-232667910',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:06:30','2025-11-28 10:06:35','2025-11-28 10:06:43',1,'afb48f47-720d-479f-b1cc-92049fd898a8',NULL,'fcce45225cfa4ce6b64c668fe9c9cb2c','85f17f60fae2462cb663ba226772cedd','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:06:30','2025-11-28 10:06:31','2025-11-28 10:06:35','tempest-VolumesDeleteCascade-Volume-2055651304',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:09:24','2025-11-28 10:09:25','2025-11-28 10:09:39',1,'b34f0df5-f83d-4b31-a927-c6a5b1b240aa',NULL,'3e0c0f1d7904439c976f777b4f3c59a9','3e2ec027cab64e90a22b087eafacf760','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached',NULL,NULL,NULL,'backup-vol-e38d3f86-1fc2-412d-99d4-43c43990555a',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,1,0),('2025-11-28 10:09:14','2025-11-28 10:09:15','2025-11-28 10:09:16',1,'b352ba15-335d-4fa7-b53c-70aaa91cdb89',NULL,'b4f253dd53c54043a43353fe20d0964d','673b477f9d70449480701aa9846d8f60','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:09:14','2025-11-28 10:09:14','2025-11-28 10:09:15','tempest-VolumesCloneTest-Volume-1408620213',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db','2be343e1-0720-4240-8d53-d6ea9dba43a0',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:08:59','2025-11-28 10:09:01','2025-11-28 10:09:01',1,'b41af2fd-b4c9-4f3e-b879-24674a431c5d',NULL,'681a898abdc741a487d051592f131465','85b0cd4fbc9547ea80ee82fddaeca666','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:09:00','2025-11-28 10:09:00','2025-11-28 10:09:01',NULL,NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:08:30','2025-11-28 10:08:35','2025-11-28 10:08:36',1,'b8195552-c477-42f9-b39c-8c4684873173',NULL,'af5b23808fe14f21a1025d9d48164f85','79cbcb0957f54ef09645577668ab7937','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-11-28 10:08:30','2025-11-28 10:08:31','2025-11-28 10:08:35','tempest-VolumesSnapshotNegativeTestJSON-Volume-47144872',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:05:56','2025-11-28 10:05:57','2025-11-28 10:05:58',1,'b8bd40ee-67db-4225-a840-29c3947d2215',NULL,'d62f3b7ee9a2437a895cfdb1eaa1523b','16a57eec68224f4d9395015bb4c6714b','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:05:56','2025-11-28 10:05:56','2025-11-28 10:05:57','tempest-AbsoluteLimitsTests-Volume-1636457976',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:09:38','2025-11-28 10:09:39','2025-11-28 10:09:39',1,'b9d7ca8a-fc55-4e65-bb0b-d84f4a6f992e',NULL,'b9ac6ab3dd0b4f7a93a114e6ff84cd7a','df6949ad183e4e1e8db4a49117054e84','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:09:38','2025-11-28 10:09:38','2025-11-28 10:09:39','tempest-VolumesGetTest-Volume-861033573',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:06:33','2025-11-28 10:06:38','2025-11-28 10:06:40',1,'ba20f281-f8ef-460a-a916-8659cb86fe77',NULL,'87cf17c48bab44279b2e7eca9e0882a2','d3c0d1ce8d854a7b9ffc953e88cd2c44','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:06:33','2025-11-28 10:06:33','2025-11-28 10:06:38','tempest-VolumesBackupsTest-Volume-282582525',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:06:46','2025-11-28 10:08:03','2025-11-28 10:08:07',1,'bd027205-a608-4caf-a797-22f77fcdb9dd',NULL,'87cf17c48bab44279b2e7eca9e0882a2','d3c0d1ce8d854a7b9ffc953e88cd2c44','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:06:46','2025-11-28 10:06:47','2025-11-28 10:08:03','tempest-VolumesBackupsTest-Volume-907248427',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:08:57','2025-11-28 10:09:02','2025-11-28 10:09:03',1,'bd2bcac7-ac0b-4753-a222-e0c44d919d31',NULL,'463f0a482daf45f1b54b00148c9c0291','af627bb6800b48f795f524c5240dd96e','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:08:57','2025-11-28 10:08:57','2025-11-28 10:09:02','tempest-VolumesListAdminTestJSON-Volume-1705265686',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:08:18','2025-11-28 10:08:26','2025-11-28 10:08:26',1,'c731eac0-368d-468d-9419-e1f90b56f670',NULL,'204e4aad7e2340eebed299dd8030708b','6732fa86445147cdb019a2189d601a62','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-11-28 10:08:18','2025-11-28 10:08:23','2025-11-28 10:08:26','tempest-VolumesExtendTest-Volume-2123461534',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:06:22','2025-11-28 10:06:27','2025-11-28 10:06:29',1,'cccef904-2be7-4d83-aa3a-74f49c47124f',NULL,'fcce45225cfa4ce6b64c668fe9c9cb2c','85f17f60fae2462cb663ba226772cedd','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:06:22','2025-11-28 10:06:22','2025-11-28 10:06:27','tempest-VolumesDeleteCascade-Volume-104528884',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:06:06','2025-11-28 10:06:09','2025-11-28 10:06:11',1,'d0de0b22-5f61-4344-a73e-704f542a8f23',NULL,'3149cb791b864349a3ef9639d9664574','d2d31a928b84446c97d35bb770c268e5','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:06:06','2025-11-28 10:06:07','2025-11-28 10:06:09','tempest-VolumesBackupsAdminTest-Volume-188316658',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:09:47','2025-11-28 10:09:48','2025-11-28 10:09:49',1,'e0ac2d26-6ce7-4cd0-a3e6-253092296fb3',NULL,'3e0c0f1d7904439c976f777b4f3c59a9','3e2ec027cab64e90a22b087eafacf760','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-11-28 10:09:47','2025-11-28 10:09:48','2025-11-28 10:09:48','tempest-VolumesSnapshotTestJSON-Volume-1311068365',NULL,NULL,NULL,'aff5c950-2760-443e-b5e4-32ab70adb74d','81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:05:33','2025-11-28 10:05:39','2025-11-28 10:05:39',1,'e1e62b1f-1cfc-4c00-a2fb-935d8e95ef31',NULL,'c0286a07766246c0b685593779a1b7bd','5c1cc8bd04e04964bf55c27886efbf5c','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:05:33','2025-11-28 10:05:33',NULL,'tempest-volume-481958481',NULL,NULL,NULL,NULL,'9e639737-6ba0-4823-95c4-cc509eaf4ceb',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'5da9d15e-3a2b-4b77-898e-f8afbeb62e23','6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:09:22','2025-11-28 10:10:00','2025-11-28 10:10:00',1,'e38d3f86-1fc2-412d-99d4-43c43990555a',NULL,'3e0c0f1d7904439c976f777b4f3c59a9','3e2ec027cab64e90a22b087eafacf760','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:09:22','2025-11-28 10:09:22','2025-11-28 10:10:00','tempest-VolumesSnapshotTestJSON-Volume-1540804753',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:08:04','2025-11-28 10:08:06','2025-11-28 10:08:07',1,'e9ef34e3-c3d7-4eab-ad8a-90355ef732f1',NULL,'dedc77f9200d4e4d8ca1155c55fc8389','6f9594f9fb704068b77cd4ff3489e542','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:08:04','2025-11-28 10:08:05','2025-11-28 10:08:06','tempest-VolumeQuotasAdminTestJSON-Volume-361197468',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:09:34','2025-11-28 10:09:40','2025-11-28 10:09:41',1,'eaf296fa-7079-472c-9fa1-865447808257',NULL,'b9ac6ab3dd0b4f7a93a114e6ff84cd7a','df6949ad183e4e1e8db4a49117054e84','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:09:34','2025-11-28 10:09:36','2025-11-28 10:09:40','tempest-VolumesGetTest-new-Volume-604757782','This is the new description of volume',NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db','12b76a79-c5e4-4af3-a994-e2ada2b6da6f',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:09:49','2025-11-28 10:09:51','2025-11-28 10:09:51',1,'ef198070-6e9c-4a4f-8a48-f8bd1ee7e474',NULL,'b9ac6ab3dd0b4f7a93a114e6ff84cd7a','df6949ad183e4e1e8db4a49117054e84','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:09:50','2025-11-28 10:09:50','2025-11-28 10:09:51','tempest-VolumesGetTest-Volume-1948960356',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:08:22','2025-11-28 10:08:24','2025-11-28 10:08:24',1,'f25421b6-8785-435c-977a-1024caf09aa1',NULL,'1f9281b9a78649359bbe8f6081cce80f','b75145391b1642aa86ac346010612ae1','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:08:23','2025-11-28 10:08:23','2025-11-28 10:08:24','tempest-VolumesTransfersV357Test-Volume-1038253578',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:07:43','2025-11-28 10:07:51','2025-11-28 10:07:51',1,'f440973d-0b6b-4889-bf4a-2156cfb3e249',NULL,'60a0061fff1842b898c067834f6b0b0d','44e47888bf384f2290cbd80a83fd1322','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:07:43','2025-11-28 10:07:43',NULL,'tempest-volume-595797595',NULL,NULL,NULL,NULL,'8206fca6-970a-4db0-a8a4-eeedbc6e2000',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'05a5fb3c-7e79-48b3-9bf5-ec7bd77e2596','6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1),('2025-11-28 10:08:57','2025-11-28 10:08:57','2025-11-28 10:08:58',1,'f5e86292-8aa3-4beb-97f1-964514fec777',NULL,'d7b125136014403fb045eae0db96b386','f85d8ffada2842738a1307658c19c621',NULL,1,'nova','deleted','detached',NULL,NULL,NULL,'tempest-UserMessagesTest-Volume-101219600',NULL,NULL,NULL,NULL,'57626bb5-ef99-4f80-9808-c2abd2c69f4c',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,1,1),('2025-11-28 10:08:59','2025-11-28 10:08:59','2025-11-28 10:09:00',1,'f7f7d02c-ae73-40c9-8e71-f720df169558',NULL,'d7b125136014403fb045eae0db96b386','f85d8ffada2842738a1307658c19c621',NULL,1,'nova','deleted','detached',NULL,NULL,NULL,'tempest-UserMessagesTest-Volume-1195770714',NULL,NULL,NULL,NULL,'13813c7d-a460-4556-babd-44f8c94e01b3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,1,1),('2025-11-28 10:06:53','2025-11-28 10:06:57','2025-11-28 10:06:59',1,'fdbbaa71-48fa-4391-ab9a-950e96883f3c',NULL,'fdd5d9aeb097405795bc809f7d091c26','a1eb2d80861b4077b9ef4c3389f19286','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-11-28 10:06:53','2025-11-28 10:06:54','2025-11-28 10:06:57','tempest-VolumesListTestJSON-Volume-208167745',NULL,NULL,NULL,NULL,'81cd8392-f063-4c6f-92d5-8c65f8ede5db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'6008c4d5-ccb8-4df4-a679-b807fbb608d5',0,1);
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=161 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2025-11-28 08:14:44','2025-11-28 08:14:44.000123',NULL,0,2,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (2,'391767f1-35f2-4b68-ae15-e0b29db66dcb','rbd://2c5417c9-00eb-57d5-a565-ddecbc7995c1/images/391767f1-35f2-4b68-ae15-e0b29db66dcb/snap','2025-11-28 08:31:55','2025-11-28 08:31:55',NULL,0,'{\"store\": \"default_backend\"}','active'),(5,'85968a96-5a0e-43a4-9c04-3954f640a7ed','rbd://2c5417c9-00eb-57d5-a565-ddecbc7995c1/images/85968a96-5a0e-43a4-9c04-3954f640a7ed/snap','2025-11-28 09:59:46','2025-11-28 09:59:46',NULL,0,'{\"store\": \"default_backend\"}','active'),(6,'8b38f477-f33c-44a4-ae26-4483554674f1','rbd://2c5417c9-00eb-57d5-a565-ddecbc7995c1/images/8b38f477-f33c-44a4-ae26-4483554674f1/snap','2025-11-28 09:59:48','2025-11-28 09:59:48',NULL,0,'{\"store\": \"default_backend\"}','active'),(7,'1ede6fca-deb8-426e-9e1e-173a2473b99b','rbd://2c5417c9-00eb-57d5-a565-ddecbc7995c1/images/1ede6fca-deb8-426e-9e1e-173a2473b99b/snap','2025-11-28 10:00:56','2025-11-28 10:00:58','2025-11-28 10:00:58',1,'{\"store\": \"default_backend\"}','deleted'),(8,'c045142b-5f2b-4f4d-80b7-ca5ee791067d','rbd://2c5417c9-00eb-57d5-a565-ddecbc7995c1/images/c045142b-5f2b-4f4d-80b7-ca5ee791067d/snap','2025-11-28 10:01:41','2025-11-28 10:01:53','2025-11-28 10:01:53',1,'{\"store\": \"default_backend\"}','deleted'),(9,'a2def208-be38-4da4-a3f2-d5c5045455ca','rbd://2c5417c9-00eb-57d5-a565-ddecbc7995c1/images/a2def208-be38-4da4-a3f2-d5c5045455ca/snap','2025-11-28 10:02:12','2025-11-28 10:02:21','2025-11-28 10:02:21',1,'{\"store\": \"default_backend\"}','deleted'),(10,'0ac675a4-b681-4f0e-9e84-de6fd8496fca','rbd://2c5417c9-00eb-57d5-a565-ddecbc7995c1/images/0ac675a4-b681-4f0e-9e84-de6fd8496fca/snap','2025-11-28 10:02:19','2025-11-28 10:02:32','2025-11-28 10:02:32',1,'{\"store\": \"default_backend\"}','deleted'),(11,'befe1640-633f-4214-8875-d0ca462c82f2','rbd://2c5417c9-00eb-57d5-a565-ddecbc7995c1/images/befe1640-633f-4214-8875-d0ca462c82f2/snap','2025-11-28 10:02:20','2025-11-28 10:02:31','2025-11-28 10:02:31',1,'{\"store\": \"default_backend\"}','deleted'),(12,'914a4b1e-615f-4ae5-b8ca-930ce81d31d4','rbd://2c5417c9-00eb-57d5-a565-ddecbc7995c1/images/914a4b1e-615f-4ae5-b8ca-930ce81d31d4/snap','2025-11-28 10:02:21','2025-11-28 10:02:29','2025-11-28 10:02:29',1,'{\"store\": \"default_backend\"}','deleted'),(13,'983e58c0-ed4d-46c1-ae33-33e93a09faac','rbd://2c5417c9-00eb-57d5-a565-ddecbc7995c1/images/983e58c0-ed4d-46c1-ae33-33e93a09faac/snap','2025-11-28 10:02:22','2025-11-28 10:02:28','2025-11-28 10:02:28',1,'{\"store\": \"default_backend\"}','deleted'),(14,'c86d966f-191b-4259-9d1c-5ed99268be16','rbd://2c5417c9-00eb-57d5-a565-ddecbc7995c1/images/c86d966f-191b-4259-9d1c-5ed99268be16/snap','2025-11-28 10:02:23','2025-11-28 10:02:27','2025-11-28 10:02:27',1,'{\"store\": \"default_backend\"}','deleted'),(15,'98bb9dcf-45f4-417c-85b8-e8bce0dae63d','rbd://2c5417c9-00eb-57d5-a565-ddecbc7995c1/images/98bb9dcf-45f4-417c-85b8-e8bce0dae63d/snap','2025-11-28 10:02:24','2025-11-28 10:02:26','2025-11-28 10:02:26',1,'{\"store\": \"default_backend\"}','deleted'),(16,'6f11982d-60e1-412b-8f66-f29c90f97b74','rbd://2c5417c9-00eb-57d5-a565-ddecbc7995c1/images/6f11982d-60e1-412b-8f66-f29c90f97b74/snap','2025-11-28 10:02:43','2025-11-28 10:02:48','2025-11-28 10:02:48',1,'{\"store\": \"default_backend\"}','deleted'),(17,'bdaf1f9e-5ef5-4734-ab2a-e070353e7199','rbd://2c5417c9-00eb-57d5-a565-ddecbc7995c1/images/bdaf1f9e-5ef5-4734-ab2a-e070353e7199/snap','2025-11-28 10:03:26','2025-11-28 10:03:32','2025-11-28 10:03:32',1,'{\"store\": \"default_backend\"}','deleted'),(18,'f5327737-7f73-4a11-9a91-6f3a647c2da0','rbd://2c5417c9-00eb-57d5-a565-ddecbc7995c1/images/f5327737-7f73-4a11-9a91-6f3a647c2da0/snap','2025-11-28 10:03:28','2025-11-28 10:03:30','2025-11-28 10:03:30',1,'{\"store\": \"default_backend\"}','deleted'),(19,'191ae142-9d7e-4de5-80cc-5aa64590b368','rbd://2c5417c9-00eb-57d5-a565-ddecbc7995c1/images/191ae142-9d7e-4de5-80cc-5aa64590b368/snap','2025-11-28 10:03:38','2025-11-28 10:03:48','2025-11-28 10:03:48',1,'{\"store\": \"default_backend\"}','deleted'),(20,'77243701-5a5b-4139-b157-a98a6dc541c2','rbd://2c5417c9-00eb-57d5-a565-ddecbc7995c1/images/77243701-5a5b-4139-b157-a98a6dc541c2/snap','2025-11-28 10:03:45','2025-11-28 10:03:47','2025-11-28 10:03:47',1,'{\"store\": \"default_backend\"}','deleted'),(21,'da8c5697-43f9-4800-8d34-77966965d9b5','rbd://2c5417c9-00eb-57d5-a565-ddecbc7995c1/images/da8c5697-43f9-4800-8d34-77966965d9b5/snap','2025-11-28 10:04:44','2025-11-28 10:04:45','2025-11-28 10:04:45',1,'{\"store\": \"default_backend\"}','deleted'),(22,'cab46c0c-a05f-4016-af11-748fb4935f2a','rbd://2c5417c9-00eb-57d5-a565-ddecbc7995c1/images/cab46c0c-a05f-4016-af11-748fb4935f2a/snap','2025-11-28 10:07:09','2025-11-28 10:07:12','2025-11-28 10:07:12',1,'{\"store\": \"default_backend\"}','deleted'),(23,'f24e424e-58bb-4162-b9e4-2755b88d903f','rbd://2c5417c9-00eb-57d5-a565-ddecbc7995c1/images/f24e424e-58bb-4162-b9e4-2755b88d903f/snap','2025-11-28 10:07:38','2025-11-28 10:07:39','2025-11-28 10:07:39',1,'{\"store\": \"default_backend\"}','deleted'),(24,'dc6a370f-a578-4b95-8552-d0fa64f9c04d','rbd://2c5417c9-00eb-57d5-a565-ddecbc7995c1/images/dc6a370f-a578-4b95-8552-d0fa64f9c04d/snap','2025-11-28 10:07:40','2025-11-28 10:07:43','2025-11-28 10:07:43',1,'{\"store\": \"default_backend\"}','deleted'),(25,'f66d3903-be10-4b76-aed5-bb024af82937','rbd://2c5417c9-00eb-57d5-a565-ddecbc7995c1/images/f66d3903-be10-4b76-aed5-bb024af82937/snap','2025-11-28 10:12:05','2025-11-28 10:12:07','2025-11-28 10:12:07',1,'{\"store\": \"default_backend\"}','deleted');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
INSERT INTO `image_members` (`id`, `image_id`, `member`, `can_share`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`) VALUES (1,'321c468e-742e-4748-9cbd-5aaaf17ac4c4','feb670babb684e57b1bd5b69be19c112',0,'2025-11-28 10:02:03','2025-11-28 10:02:03','2025-11-28 10:02:03',1,'accepted'),(2,'3f257d37-5c63-4b9c-b860-b18872e4c7a9','feb670babb684e57b1bd5b69be19c112',0,'2025-11-28 10:02:03','2025-11-28 10:02:03','2025-11-28 10:02:03',1,'accepted'),(3,'9d941f12-6d16-46a1-ba98-ca01528a686a','feb670babb684e57b1bd5b69be19c112',0,'2025-11-28 10:02:03','2025-11-28 10:02:04','2025-11-28 10:02:04',1,'rejected'),(4,'3b8c30ec-1a94-49a0-9cde-938802f9c359','feb670babb684e57b1bd5b69be19c112',0,'2025-11-28 10:02:04','2025-11-28 10:02:04','2025-11-28 10:02:04',1,'accepted'),(5,'7e110b8d-65f5-4c49-ba99-8e1c5a589d50','50f633f21a23431199a2ef69dba5bc2b',0,'2025-11-28 10:02:21','2025-11-28 10:02:21','2025-11-28 10:02:21',1,'pending'),(6,'872e4485-2b54-4bea-b2e2-6f0d396db55d','50f633f21a23431199a2ef69dba5bc2b',0,'2025-11-28 10:02:21','2025-11-28 10:02:21','2025-11-28 10:02:21',1,'pending'),(7,'da8c5697-43f9-4800-8d34-77966965d9b5','0113d7f8462a4524ad600d9ec0d97f5f',0,'2025-11-28 10:04:44','2025-11-28 10:04:45','2025-11-28 10:04:45',1,'pending');
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (2,'391767f1-35f2-4b68-ae15-e0b29db66dcb','owner_specified.openstack.md5','','2025-11-28 08:31:50','2025-11-28 08:31:50',NULL,0),(5,'391767f1-35f2-4b68-ae15-e0b29db66dcb','owner_specified.openstack.sha256','','2025-11-28 08:31:50','2025-11-28 08:31:50',NULL,0),(8,'391767f1-35f2-4b68-ae15-e0b29db66dcb','owner_specified.openstack.object','images/cirros','2025-11-28 08:31:50','2025-11-28 08:31:50',NULL,0),(11,'85968a96-5a0e-43a4-9c04-3954f640a7ed','hw_rng_model','virtio','2025-11-28 09:59:44','2025-11-28 09:59:44',NULL,0),(12,'8b38f477-f33c-44a4-ae26-4483554674f1','hw_rng_model','virtio','2025-11-28 09:59:46','2025-11-28 09:59:46',NULL,0),(13,'c045142b-5f2b-4f4d-80b7-ca5ee791067d','hw_rng_model','virtio','2025-11-28 10:01:11','2025-11-28 10:01:53','2025-11-28 10:01:53',1),(14,'c045142b-5f2b-4f4d-80b7-ca5ee791067d','base_image_ref','85968a96-5a0e-43a4-9c04-3954f640a7ed','2025-11-28 10:01:11','2025-11-28 10:01:53','2025-11-28 10:01:53',1),(15,'c045142b-5f2b-4f4d-80b7-ca5ee791067d','owner_user_name','tempest-UnshelveToHostMultiNodesTest-426973173-project-member','2025-11-28 10:01:11','2025-11-28 10:01:53','2025-11-28 10:01:53',1),(16,'c045142b-5f2b-4f4d-80b7-ca5ee791067d','owner_project_name','tempest-UnshelveToHostMultiNodesTest-426973173','2025-11-28 10:01:11','2025-11-28 10:01:53','2025-11-28 10:01:53',1),(17,'c045142b-5f2b-4f4d-80b7-ca5ee791067d','boot_roles','reader,member','2025-11-28 10:01:11','2025-11-28 10:01:53','2025-11-28 10:01:53',1),(18,'c045142b-5f2b-4f4d-80b7-ca5ee791067d','hw_machine_type','q35','2025-11-28 10:01:11','2025-11-28 10:01:53','2025-11-28 10:01:53',1),(19,'c045142b-5f2b-4f4d-80b7-ca5ee791067d','hw_cdrom_bus','sata','2025-11-28 10:01:11','2025-11-28 10:01:53','2025-11-28 10:01:53',1),(20,'c045142b-5f2b-4f4d-80b7-ca5ee791067d','hw_disk_bus','virtio','2025-11-28 10:01:11','2025-11-28 10:01:53','2025-11-28 10:01:53',1),(21,'c045142b-5f2b-4f4d-80b7-ca5ee791067d','hw_input_bus','usb','2025-11-28 10:01:11','2025-11-28 10:01:53','2025-11-28 10:01:53',1),(22,'c045142b-5f2b-4f4d-80b7-ca5ee791067d','hw_pointer_model','usbtablet','2025-11-28 10:01:11','2025-11-28 10:01:53','2025-11-28 10:01:53',1),(23,'c045142b-5f2b-4f4d-80b7-ca5ee791067d','hw_video_model','virtio','2025-11-28 10:01:11','2025-11-28 10:01:53','2025-11-28 10:01:53',1),(24,'c045142b-5f2b-4f4d-80b7-ca5ee791067d','hw_vif_model','virtio','2025-11-28 10:01:11','2025-11-28 10:01:53','2025-11-28 10:01:53',1),(25,'c045142b-5f2b-4f4d-80b7-ca5ee791067d','instance_uuid','7292509e-f294-4159-96e5-22d4712df2a0','2025-11-28 10:01:11','2025-11-28 10:01:53','2025-11-28 10:01:53',1),(26,'c045142b-5f2b-4f4d-80b7-ca5ee791067d','user_id','28578129c91d407a92af609ba8bac430','2025-11-28 10:01:11','2025-11-28 10:01:53','2025-11-28 10:01:53',1),(27,'c045142b-5f2b-4f4d-80b7-ca5ee791067d','image_type','snapshot','2025-11-28 10:01:11','2025-11-28 10:01:53','2025-11-28 10:01:53',1),(28,'c045142b-5f2b-4f4d-80b7-ca5ee791067d','image_state','available','2025-11-28 10:01:40','2025-11-28 10:01:53','2025-11-28 10:01:53',1),(29,'c045142b-5f2b-4f4d-80b7-ca5ee791067d','image_location','snapshot','2025-11-28 10:01:40','2025-11-28 10:01:53','2025-11-28 10:01:53',1),(30,'c045142b-5f2b-4f4d-80b7-ca5ee791067d','owner_id','a30386ba68ee46f4a1bac43cf415f3a4','2025-11-28 10:01:40','2025-11-28 10:01:53','2025-11-28 10:01:53',1),(31,'a2def208-be38-4da4-a3f2-d5c5045455ca','hw_rng_model','virtio','2025-11-28 10:01:56','2025-11-28 10:02:21','2025-11-28 10:02:21',1),(32,'a2def208-be38-4da4-a3f2-d5c5045455ca','base_image_ref','85968a96-5a0e-43a4-9c04-3954f640a7ed','2025-11-28 10:01:56','2025-11-28 10:02:21','2025-11-28 10:02:21',1),(33,'a2def208-be38-4da4-a3f2-d5c5045455ca','owner_user_name','tempest-UnshelveToHostMultiNodesTest-426973173-project-member','2025-11-28 10:01:56','2025-11-28 10:02:21','2025-11-28 10:02:21',1),(34,'a2def208-be38-4da4-a3f2-d5c5045455ca','owner_project_name','tempest-UnshelveToHostMultiNodesTest-426973173','2025-11-28 10:01:56','2025-11-28 10:02:21','2025-11-28 10:02:21',1),(35,'a2def208-be38-4da4-a3f2-d5c5045455ca','boot_roles','reader,member','2025-11-28 10:01:56','2025-11-28 10:02:21','2025-11-28 10:02:21',1),(36,'a2def208-be38-4da4-a3f2-d5c5045455ca','hw_machine_type','q35','2025-11-28 10:01:56','2025-11-28 10:02:21','2025-11-28 10:02:21',1),(37,'a2def208-be38-4da4-a3f2-d5c5045455ca','hw_cdrom_bus','sata','2025-11-28 10:01:56','2025-11-28 10:02:21','2025-11-28 10:02:21',1),(38,'a2def208-be38-4da4-a3f2-d5c5045455ca','hw_disk_bus','virtio','2025-11-28 10:01:56','2025-11-28 10:02:21','2025-11-28 10:02:21',1),(39,'a2def208-be38-4da4-a3f2-d5c5045455ca','hw_input_bus','usb','2025-11-28 10:01:56','2025-11-28 10:02:21','2025-11-28 10:02:21',1),(40,'a2def208-be38-4da4-a3f2-d5c5045455ca','hw_pointer_model','usbtablet','2025-11-28 10:01:56','2025-11-28 10:02:21','2025-11-28 10:02:21',1),(41,'a2def208-be38-4da4-a3f2-d5c5045455ca','hw_video_model','virtio','2025-11-28 10:01:56','2025-11-28 10:02:21','2025-11-28 10:02:21',1),(42,'a2def208-be38-4da4-a3f2-d5c5045455ca','hw_vif_model','virtio','2025-11-28 10:01:56','2025-11-28 10:02:21','2025-11-28 10:02:21',1),(43,'a2def208-be38-4da4-a3f2-d5c5045455ca','clean_attempts','1','2025-11-28 10:01:56','2025-11-28 10:02:21','2025-11-28 10:02:21',1),(44,'a2def208-be38-4da4-a3f2-d5c5045455ca','instance_uuid','7292509e-f294-4159-96e5-22d4712df2a0','2025-11-28 10:01:56','2025-11-28 10:02:21','2025-11-28 10:02:21',1),(45,'a2def208-be38-4da4-a3f2-d5c5045455ca','user_id','28578129c91d407a92af609ba8bac430','2025-11-28 10:01:56','2025-11-28 10:02:21','2025-11-28 10:02:21',1),(46,'a2def208-be38-4da4-a3f2-d5c5045455ca','image_type','snapshot','2025-11-28 10:01:56','2025-11-28 10:02:21','2025-11-28 10:02:21',1),(47,'a2def208-be38-4da4-a3f2-d5c5045455ca','image_state','available','2025-11-28 10:02:12','2025-11-28 10:02:21','2025-11-28 10:02:21',1),(48,'a2def208-be38-4da4-a3f2-d5c5045455ca','image_location','snapshot','2025-11-28 10:02:12','2025-11-28 10:02:21','2025-11-28 10:02:21',1),(49,'a2def208-be38-4da4-a3f2-d5c5045455ca','owner_id','a30386ba68ee46f4a1bac43cf415f3a4','2025-11-28 10:02:12','2025-11-28 10:02:21','2025-11-28 10:02:21',1),(50,'6f11982d-60e1-412b-8f66-f29c90f97b74','os_distro','value2','2025-11-28 10:02:43','2025-11-28 10:02:48','2025-11-28 10:02:48',1),(51,'6f11982d-60e1-412b-8f66-f29c90f97b74','os_version','alt1','2025-11-28 10:02:43','2025-11-28 10:02:48','2025-11-28 10:02:48',1),(52,'6f11982d-60e1-412b-8f66-f29c90f97b74','architecture','value3','2025-11-28 10:02:45','2025-11-28 10:02:48','2025-11-28 10:02:48',1),(53,'f5327737-7f73-4a11-9a91-6f3a647c2da0','ramdisk_id','00000000-1111-2222-3333-444455556666','2025-11-28 10:03:26','2025-11-28 10:03:30','2025-11-28 10:03:30',1),(54,'191ae142-9d7e-4de5-80cc-5aa64590b368','ramdisk_id','00000000-1111-2222-3333-444455556666','2025-11-28 10:03:36','2025-11-28 10:03:48','2025-11-28 10:03:48',1),(55,'191ae142-9d7e-4de5-80cc-5aa64590b368','os_glance_stage_host','http://glance-default-external-api-0.glance-default-external-api.openstack.svc:9292','2025-11-28 10:03:36','2025-11-28 10:03:48','2025-11-28 10:03:48',1),(57,'191ae142-9d7e-4de5-80cc-5aa64590b368','os_glance_importing_to_stores','','2025-11-28 10:03:37','2025-11-28 10:03:48','2025-11-28 10:03:48',1),(58,'191ae142-9d7e-4de5-80cc-5aa64590b368','os_glance_failed_import','','2025-11-28 10:03:37','2025-11-28 10:03:48','2025-11-28 10:03:48',1),(59,'77243701-5a5b-4139-b157-a98a6dc541c2','ramdisk_id','00000000-1111-2222-3333-444455556666','2025-11-28 10:03:39','2025-11-28 10:03:47','2025-11-28 10:03:47',1),(61,'77243701-5a5b-4139-b157-a98a6dc541c2','os_glance_importing_to_stores','','2025-11-28 10:03:39','2025-11-28 10:03:47','2025-11-28 10:03:47',1),(62,'77243701-5a5b-4139-b157-a98a6dc541c2','os_glance_failed_import','','2025-11-28 10:03:39','2025-11-28 10:03:47','2025-11-28 10:03:47',1),(64,'6db7e5d2-083b-4c63-9086-6685af0eda4f','os_glance_importing_to_stores','','2025-11-28 10:03:54','2025-11-28 10:03:54',NULL,0),(65,'6db7e5d2-083b-4c63-9086-6685af0eda4f','os_glance_failed_import','default_backend','2025-11-28 10:03:54','2025-11-28 10:03:54',NULL,0);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
INSERT INTO `image_tags` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'0ac675a4-b681-4f0e-9e84-de6fd8496fca','tempest-tag-1756187072','2025-11-28 10:02:18','2025-11-28 10:02:32','2025-11-28 10:02:32',1),(2,'0ac675a4-b681-4f0e-9e84-de6fd8496fca','tempest-tag-1381925183','2025-11-28 10:02:18','2025-11-28 10:02:32','2025-11-28 10:02:32',1),(3,'befe1640-633f-4214-8875-d0ca462c82f2','tempest-tag-1218970439','2025-11-28 10:02:19','2025-11-28 10:02:31','2025-11-28 10:02:31',1),(4,'befe1640-633f-4214-8875-d0ca462c82f2','tempest-tag-918632765','2025-11-28 10:02:19','2025-11-28 10:02:31','2025-11-28 10:02:31',1),(5,'914a4b1e-615f-4ae5-b8ca-930ce81d31d4','tempest-tag-1850636465','2025-11-28 10:02:20','2025-11-28 10:02:29','2025-11-28 10:02:29',1),(6,'914a4b1e-615f-4ae5-b8ca-930ce81d31d4','tempest-tag-704008953','2025-11-28 10:02:20','2025-11-28 10:02:29','2025-11-28 10:02:29',1),(7,'983e58c0-ed4d-46c1-ae33-33e93a09faac','tempest-tag-1679328759','2025-11-28 10:02:21','2025-11-28 10:02:28','2025-11-28 10:02:28',1),(8,'983e58c0-ed4d-46c1-ae33-33e93a09faac','tempest-tag-1835947919','2025-11-28 10:02:21','2025-11-28 10:02:28','2025-11-28 10:02:28',1),(9,'c86d966f-191b-4259-9d1c-5ed99268be16','tempest-tag-2125943619','2025-11-28 10:02:22','2025-11-28 10:02:27','2025-11-28 10:02:27',1),(10,'c86d966f-191b-4259-9d1c-5ed99268be16','tempest-tag-1208060005','2025-11-28 10:02:22','2025-11-28 10:02:27','2025-11-28 10:02:27',1),(11,'98bb9dcf-45f4-417c-85b8-e8bce0dae63d','tempest-tag-1788515265','2025-11-28 10:02:23','2025-11-28 10:02:26','2025-11-28 10:02:26',1),(12,'98bb9dcf-45f4-417c-85b8-e8bce0dae63d','tempest-tag-32543431','2025-11-28 10:02:23','2025-11-28 10:02:26','2025-11-28 10:02:26',1),(13,'6582a0ce-decd-43c5-8e15-6f9d4a99042a','tempest-tag-1222807207','2025-11-28 10:02:46','2025-11-28 10:02:46','2025-11-28 10:02:46',1);
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1)),
  CONSTRAINT `CONSTRAINT_4` CHECK (`os_hidden` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('0ac675a4-b681-4f0e-9e84-de6fd8496fca','tempest-ListUserImagesTest-image-505135850',1150,'deleted','2025-11-28 10:02:18','2025-11-28 10:02:32','2025-11-28 10:02:32',1,'qcow2','bare','86f4a7df28b4489a4f04b0e2208ad290','247ed00f7c5b491bae368cbfb1c6129c',0,0,0,NULL,'private',0,'sha512','38017c4a58d8f5d20afcf41598ace6ec786dabd5595c788faf8f7d67839aea7a7afb5d3368e0b10d5377d1d39dcc451339e284e570033f78fe79c63c43f67cfd'),('151297cd-9aa1-4308-85fe-21a750df7e5a','tempest-test-1569661780',NULL,'deleted','2025-11-28 10:02:41','2025-11-28 10:02:42','2025-11-28 10:02:42',1,'raw','bare',NULL,'e1847d10753a4aa190c218096ab5b477',0,0,0,NULL,'shared',0,NULL,NULL),('191ae142-9d7e-4de5-80cc-5aa64590b368','tempest-image-71413887',1024,'deleted','2025-11-28 10:03:36','2025-11-28 10:03:48','2025-11-28 10:03:48',1,'raw','bare','2eca1513c306b25b064a2247568743fd','c57c5dfffe2a46d99b4de8a1c43bc77d',0,0,0,1024,'private',0,'sha512','bf3dda6008145df1c8a477c523a4f28c21ccf23b0920bec5705e09b7d5022de65e2098ea9dc14081d48d61eb65fdb3f397aea12339bfe9dc1ab4f500492958eb'),('1ede6fca-deb8-426e-9e1e-173a2473b99b','tempest-image-1398228236',2624,'deleted','2025-11-28 10:00:54','2025-11-28 10:00:58','2025-11-28 10:00:58',1,'qcow2','bare','f473e25a6b6a7f4fe0b592593e796a85','d0382aeb13484547a998b9d02420a2ed',0,129,0,NULL,'private',0,'sha512','3abd4796685f106830519b342e04a0e3b1d76cb3f4b97d696e1896fc36181fc2f93d15a1ff818f8a038f1b79355ee7a0da671aebd20091021f00600004753f34'),('26bdc228-f9e6-46e3-afa7-4f60179463f3','tempest-task_image-677029937',NULL,'deleted','2025-11-28 10:03:58','2025-11-28 10:03:59','2025-11-28 10:03:59',1,'qcow2','bare',NULL,NULL,0,0,0,NULL,'public',0,NULL,NULL),('321c468e-742e-4748-9cbd-5aaaf17ac4c4','tempest-ImagesMemberTest-image-258834166',NULL,'deleted','2025-11-28 10:02:03','2025-11-28 10:02:03','2025-11-28 10:02:03',1,'raw','bare',NULL,'c26fc81d00de40b4a639eb8d3402b1da',0,0,0,NULL,'shared',0,NULL,NULL),('391767f1-35f2-4b68-ae15-e0b29db66dcb','cirros',21692416,'active','2025-11-28 08:31:50','2025-11-28 08:31:55',NULL,0,'qcow2','bare','87617e24a5e30cb3b87fda8c0764838f','9dda653c53224db086060962b0702694',0,0,0,117440512,'shared',0,'sha512','9a9bce0083a00939ec17c11febbfc767aa211aaa54f51e75c5a8b271a9b5637c77205a518b7a2007cb391d23cceb01e0e4e8d64832317151bc85b734b92a7be0'),('3b8c30ec-1a94-49a0-9cde-938802f9c359','tempest-ImagesMemberTest-image-1241112472',NULL,'deleted','2025-11-28 10:02:04','2025-11-28 10:02:04','2025-11-28 10:02:04',1,'raw','bare',NULL,'c26fc81d00de40b4a639eb8d3402b1da',0,0,0,NULL,'shared',0,NULL,NULL),('3f257d37-5c63-4b9c-b860-b18872e4c7a9','tempest-ImagesMemberTest-image-2141460180',NULL,'deleted','2025-11-28 10:02:03','2025-11-28 10:02:03','2025-11-28 10:02:03',1,'raw','bare',NULL,'c26fc81d00de40b4a639eb8d3402b1da',0,0,0,NULL,'shared',0,NULL,NULL),('416079f6-24a2-4962-b187-b886e55ac74a','tempest-ListUserImagesTest-image-1765001747',NULL,'deleted','2025-11-28 10:02:25','2025-11-28 10:02:25','2025-11-28 10:02:25',1,NULL,NULL,NULL,'247ed00f7c5b491bae368cbfb1c6129c',0,0,0,NULL,'shared',1,NULL,NULL),('6582a0ce-decd-43c5-8e15-6f9d4a99042a','tempest-ImagesTagsTest-image-1916117950',NULL,'deleted','2025-11-28 10:02:46','2025-11-28 10:02:47','2025-11-28 10:02:47',1,'raw','bare',NULL,'c08afd9b18674f9d8b722faa10e160e9',0,0,0,NULL,'private',0,NULL,NULL),('6db7e5d2-083b-4c63-9086-6685af0eda4f','tempest-test-25093263',NULL,'queued','2025-11-28 10:03:54','2025-11-28 10:03:54',NULL,0,'raw','bare',NULL,'97d088731e5740f69c6a5c2639052701',0,0,0,NULL,'shared',0,NULL,NULL),('6f11982d-60e1-412b-8f66-f29c90f97b74','tempest-image-1702271708',1024,'deleted','2025-11-28 10:02:41','2025-11-28 10:02:48','2025-11-28 10:02:48',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','c6c8ee017594492ab888039b88aee852',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('77243701-5a5b-4139-b157-a98a6dc541c2','tempest-image-481593757',117440512,'deleted','2025-11-28 10:03:39','2025-11-28 10:03:47','2025-11-28 10:03:47',1,'raw','bare','4245576e3df99ea1211871b8b9514d3b','c57c5dfffe2a46d99b4de8a1c43bc77d',0,0,0,117440512,'private',0,'sha512','dbb480bdc4f13ead7e00b62766df2815ddc8d4775af8a82ec40f8afd433d4cb95a109a58fbe7e0a661be86e0a06321c00362bc881f58c61c40bd2d1486954594'),('7e110b8d-65f5-4c49-ba99-8e1c5a589d50','tempest-ImagesMemberNegativeTest-image-1871663013',NULL,'deleted','2025-11-28 10:02:21','2025-11-28 10:02:21','2025-11-28 10:02:21',1,'raw','bare',NULL,'5bbbbcc8dc624f5182ff167e47427b9e',0,0,0,NULL,'shared',0,NULL,NULL),('85968a96-5a0e-43a4-9c04-3954f640a7ed','cirros-0.6.2-x86_64-disk.img',21430272,'active','2025-11-28 09:59:44','2025-11-28 09:59:46',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','9dda653c53224db086060962b0702694',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('872e4485-2b54-4bea-b2e2-6f0d396db55d','tempest-ImagesMemberNegativeTest-image-80430152',NULL,'deleted','2025-11-28 10:02:21','2025-11-28 10:02:21','2025-11-28 10:02:21',1,'raw','bare',NULL,'5bbbbcc8dc624f5182ff167e47427b9e',0,0,0,NULL,'shared',0,NULL,NULL),('8b38f477-f33c-44a4-ae26-4483554674f1','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2025-11-28 09:59:46','2025-11-28 09:59:48',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','9dda653c53224db086060962b0702694',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('914a4b1e-615f-4ae5-b8ca-930ce81d31d4','tempest-ListUserImagesTest-image-1230741444',1324,'deleted','2025-11-28 10:02:20','2025-11-28 10:02:29','2025-11-28 10:02:29',1,'ami','bare','8582de08ee81cc189e03aec60cfe8850','247ed00f7c5b491bae368cbfb1c6129c',0,0,0,NULL,'private',0,'sha512','a197ce0a4c6ceb6bc760d6b4ac80e73eb15e8934e7778f7c5ab2db1fc9d7ed66566ffb40ba515d5594c91e5be81d593fbaa7e859ac3b3e511dd398e6ab5c5dbe'),('92a9620c-501c-4153-a9e3-c241f262d4ad','tempest-test-2102936676',NULL,'deleted','2025-11-28 10:02:41','2025-11-28 10:02:42','2025-11-28 10:02:42',1,NULL,NULL,NULL,'e1847d10753a4aa190c218096ab5b477',0,0,0,NULL,'shared',0,NULL,NULL),('983e58c0-ed4d-46c1-ae33-33e93a09faac','tempest-ListUserImagesTest-image-1603766802',3368,'deleted','2025-11-28 10:02:21','2025-11-28 10:02:28','2025-11-28 10:02:28',1,'ari','bare','3dcd02e5ed5a9d2eed2b9ecafc401e98','247ed00f7c5b491bae368cbfb1c6129c',0,0,0,NULL,'private',0,'sha512','26dacf4692e20c76d03a6ab7368e5fffdb9b3f62df508b6da90bee868b8a775b2b3535cad7c6547c306bbc13808b7c4e2b24c17d6d87f74d13efa483903b3005'),('98bb9dcf-45f4-417c-85b8-e8bce0dae63d','tempest-ListUserImagesTest-image-1550804322',3770,'deleted','2025-11-28 10:02:23','2025-11-28 10:02:26','2025-11-28 10:02:26',1,'vhd','bare','7792bc9ad242fc0d92ef4bbe230be623','247ed00f7c5b491bae368cbfb1c6129c',0,0,0,NULL,'private',0,'sha512','c75d0e4d1edacf102cc7b41e0722a9ff62fccf95549d529f8b22fa292d3a5c71d76e024ae3d0ee2ad51bfe2e1ae51451d655f430411c3cc36106dbbafd73bc35'),('9d941f12-6d16-46a1-ba98-ca01528a686a','tempest-ImagesMemberTest-image-675488698',NULL,'deleted','2025-11-28 10:02:03','2025-11-28 10:02:04','2025-11-28 10:02:04',1,'raw','bare',NULL,'c26fc81d00de40b4a639eb8d3402b1da',0,0,0,NULL,'shared',0,NULL,NULL),('a2def208-be38-4da4-a3f2-d5c5045455ca','tempest-UnshelveToHostMultiNodesTest-server-650509197-shelved',1073741824,'deleted','2025-11-28 10:01:56','2025-11-28 10:02:21','2025-11-28 10:02:21',1,'raw','bare',NULL,'a30386ba68ee46f4a1bac43cf415f3a4',1,0,0,NULL,'private',0,NULL,NULL),('aa0ce762-921f-48a8-b112-4cd6fdfc2fec','tempest-new-image-1876604962',NULL,'deleted','2025-11-28 10:03:28','2025-11-28 10:03:29','2025-11-28 10:03:29',1,'qcow2','bare',NULL,'93c441d1ffc345239cce5aa7b1a18610',0,0,0,NULL,'private',0,NULL,NULL),('b8f24a0d-6ee9-4d11-8cc1-de18b6286e33',NULL,NULL,'deleted','2025-11-28 10:01:49','2025-11-28 10:01:49','2025-11-28 10:01:49',1,'raw','bare',NULL,'3f14137cf841420cbc214183cca11327',0,0,0,NULL,'shared',0,NULL,NULL),('bdaf1f9e-5ef5-4734-ab2a-e070353e7199','tempest-image-1844827821',1024,'deleted','2025-11-28 10:03:24','2025-11-28 10:03:32','2025-11-28 10:03:32',1,'raw','bare','09e9e76310bfb9aba0f53113ae237b82','93c441d1ffc345239cce5aa7b1a18610',0,0,0,1024,'private',0,'sha512','15a81aece1ff92820ec4c962da247fd83b88869342f23d2bf5c28362edd7efcac900728cd708079bd352da7518fe47b34e31423ec215b70433da5021e5a59756'),('befe1640-633f-4214-8875-d0ca462c82f2','tempest-ListUserImagesTest-image-1891156897',1858,'deleted','2025-11-28 10:02:19','2025-11-28 10:02:31','2025-11-28 10:02:31',1,'raw','bare','4f93aa30e4b64abbd5ff7be302d82fe1','247ed00f7c5b491bae368cbfb1c6129c',0,0,0,1858,'private',0,'sha512','1dbc5ed0e2425ebe3b971d4428f93d0a3431e86e3fe61d25504b71a6e795103d03c8e6c1681403eb3315814727c77f8fa8cc4b6b372d05995e8669b31d09e2c3'),('c045142b-5f2b-4f4d-80b7-ca5ee791067d','tempest-UnshelveToHostMultiNodesTest-server-650509197-shelved',1073741824,'deleted','2025-11-28 10:01:11','2025-11-28 10:01:54','2025-11-28 10:01:54',1,'raw','bare',NULL,'a30386ba68ee46f4a1bac43cf415f3a4',1,0,0,NULL,'private',0,NULL,NULL),('c86d966f-191b-4259-9d1c-5ed99268be16','tempest-ListUserImagesTest-image-1027634724',1440,'deleted','2025-11-28 10:02:22','2025-11-28 10:02:27','2025-11-28 10:02:27',1,'aki','bare','42cf4d17e80a3340ee1269f16b8ac6ca','247ed00f7c5b491bae368cbfb1c6129c',0,0,0,NULL,'private',0,'sha512','c80b83c7f4688a696701d2d0c2686984b1e8516de87b9ec7a1de81b6fd2c59cd31c3d46029ab5fcf322ec0c7fefb57fac9e1176307db3ca209369a73204bee7a'),('ca22bad1-ef1c-4277-8739-14b662d21481',NULL,NULL,'deleted','2025-11-28 10:01:50','2025-11-28 10:01:50','2025-11-28 10:01:50',1,'raw','bare',NULL,'f9766e2f9a504038b288978ce2c4747b',0,0,0,NULL,'shared',0,NULL,NULL),('ca2853af-c67f-49b0-9807-e92e7db3e0ee','tempest-image-441646486',NULL,'deleted','2025-11-28 10:03:26','2025-11-28 10:03:26','2025-11-28 10:03:26',1,'qcow2','bare',NULL,'93c441d1ffc345239cce5aa7b1a18610',0,0,0,NULL,'private',0,NULL,NULL),('cab46c0c-a05f-4016-af11-748fb4935f2a','tempest-VolumesActionsTest-Image-458307652',1073741824,'deleted','2025-11-28 10:06:26','2025-11-28 10:07:12','2025-11-28 10:07:12',1,'raw','bare','cd573cfaace07e7949bc0c46028904ff','29d0d5b3ba0745d58aee3845ea704b73',0,0,0,1073741824,'shared',0,'sha512','c5041ae163cf0f65600acfe7f6a63f212101687d41a57a4e18ffd2a07a452cd8175b8f5a4868dd2330bfe5ae123f18216bdbc9e0f80d131e64b94913a7b40bb5'),('d4d36632-0fac-4056-881c-818d86dbb398','tempest-BasicOperationsImagesAdminTest-Image-870548390',NULL,'deleted','2025-11-28 10:01:49','2025-11-28 10:01:50','2025-11-28 10:01:50',1,'raw','bare',NULL,'5d17afd93a1944699b4df1caf16b3220',0,0,0,NULL,'public',0,NULL,NULL),('da8c5697-43f9-4800-8d34-77966965d9b5','tempest-ListSharedImagesTest-image-849436223',2048,'deleted','2025-11-28 10:04:43','2025-11-28 10:04:45','2025-11-28 10:04:45',1,'qcow2','bare','46727847c3388d1662b46d8216f6fc42','c0f009875fab4d21a86066fc64145791',0,0,0,NULL,'shared',0,'sha512','fcb461419dfb3563b149a475ebb2bd6173ee4e61580b23dd76a02911248bf09ad2d3a75f66acf582404fd875c2578d1bad1571b2754b6c773f6ea407e4c83580'),('dc6a370f-a578-4b95-8552-d0fa64f9c04d','tempest-VolumesNegativeTest-image-306605000',1024,'deleted','2025-11-28 10:07:40','2025-11-28 10:07:43','2025-11-28 10:07:43',1,'qcow2','bare','fc61cdcf67f0a423b77f62ca6b0eae09','7dd88588dc3b46ab8658061b1ac13996',2,0,0,NULL,'private',0,'sha512','6cd7648ec25229c2bce5a036a444455915dbe3c8322ceb9a125a3d2d228e31ad3cac8f4920d175e3a64746fa533f4df753bb1fda0c4f0da6eaacf85b0b838767'),('df7fa10f-9e2a-4b05-85d8-fc4e1f902b7f',NULL,NULL,'deleted','2025-11-28 10:02:24','2025-11-28 10:02:24','2025-11-28 10:02:24',1,NULL,NULL,NULL,'247ed00f7c5b491bae368cbfb1c6129c',0,0,0,NULL,'shared',1,NULL,NULL),('e2b8d4e0-9a59-463b-8e4d-6be612be551a','tempest-ImagesTagsNegativeTest-image-1094904512',NULL,'deleted','2025-11-28 10:04:15','2025-11-28 10:04:15','2025-11-28 10:04:15',1,'raw','bare',NULL,'db36720df2c1422da5ae72b591ed7bef',0,0,0,NULL,'private',0,NULL,NULL),('f24e424e-58bb-4162-b9e4-2755b88d903f','tempest-VolumesNegativeTest-image-627381777',1024,'deleted','2025-11-28 10:07:37','2025-11-28 10:07:40','2025-11-28 10:07:40',1,'qcow2','bare','7d5c0ce7202d83f436d9b9882e86a507','7dd88588dc3b46ab8658061b1ac13996',2,0,0,NULL,'private',0,'sha512','2a38148f50439659825fba7c4a8428cb3d462fbb37bca58d0bc96393f3737e845f06f8c042239b1d33f163cbb5265d9f42d1f5f002a8f97ed98de73b6a74b217'),('f5327737-7f73-4a11-9a91-6f3a647c2da0','tempest-image-1837612865',1024,'deleted','2025-11-28 10:03:26','2025-11-28 10:03:31','2025-11-28 10:03:31',1,'qcow2','bare','647bc37cd6e1a01d4b6607bb530590d7','93c441d1ffc345239cce5aa7b1a18610',0,0,0,NULL,'private',0,'sha512','5cbed32401bebfbe8f3e42ee31161146fc883b5bb46474bd391601dfdc15921baeaf99c9af7bf67817e9fe86a49fe0b8416f3e49b58f7e46950838976ecccd8f'),('f54b9509-09a5-44cb-9df7-8b07ffb11d47','tempest-test-1484821957',NULL,'deleted','2025-11-28 10:02:42','2025-11-28 10:02:42','2025-11-28 10:02:42',1,'raw','bare',NULL,'e1847d10753a4aa190c218096ab5b477',0,0,0,NULL,'shared',0,NULL,NULL),('f66d3903-be10-4b76-aed5-bb024af82937','tempest-scenario-img--298695878',21430272,'deleted','2025-11-28 10:12:03','2025-11-28 10:12:07','2025-11-28 10:12:07',1,'qcow2','bare','c8fc807773e5354afe61636071771906','729a918c0a8248ff9fef91d8e41e340a',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b');
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (2,2,'image','CIM_PASD_','2025-11-28 08:14:46',NULL),(2,5,'image','CIM_RASD_','2025-11-28 08:14:46',NULL),(2,8,NULL,'CIM_SASD_','2025-11-28 08:14:47',NULL),(2,23,'image','hw_','2025-11-28 08:14:48',NULL),(2,26,'image','hw_','2025-11-28 08:14:48',NULL),(2,38,'image',NULL,'2025-11-28 08:14:49',NULL),(2,53,'image','hw_','2025-11-28 08:14:51',NULL),(2,65,'image','hw_','2025-11-28 08:14:52',NULL),(2,77,'image',NULL,'2025-11-28 08:14:53',NULL),(2,80,'image',NULL,'2025-11-28 08:14:53',NULL),(2,83,'image',NULL,'2025-11-28 08:14:54',NULL),(2,86,'image',NULL,'2025-11-28 08:14:55',NULL),(5,2,NULL,'CIM_PASD_','2025-11-28 08:14:46',NULL),(5,23,NULL,'hw_','2025-11-28 08:14:48',NULL),(5,26,NULL,'hw_','2025-11-28 08:14:48',NULL),(5,29,NULL,NULL,'2025-11-28 08:14:49',NULL),(5,35,NULL,NULL,'2025-11-28 08:14:49',NULL),(5,38,NULL,NULL,'2025-11-28 08:14:49',NULL),(5,41,NULL,NULL,'2025-11-28 08:14:50',NULL),(5,44,NULL,'hw_','2025-11-28 08:14:50',NULL),(5,53,NULL,'hw_','2025-11-28 08:14:51',NULL),(5,62,NULL,NULL,'2025-11-28 08:14:52',NULL),(5,65,NULL,'hw_','2025-11-28 08:14:52',NULL),(5,68,NULL,NULL,'2025-11-28 08:14:53',NULL),(5,74,NULL,NULL,'2025-11-28 08:14:53',NULL),(5,77,NULL,NULL,'2025-11-28 08:14:53',NULL),(5,80,NULL,NULL,'2025-11-28 08:14:53',NULL),(5,83,NULL,NULL,'2025-11-28 08:14:54',NULL),(5,86,NULL,NULL,'2025-11-28 08:14:55',NULL),(5,89,NULL,'cinder_','2025-11-28 08:14:55',NULL),(5,92,NULL,'hw_','2025-11-28 08:50:41',NULL),(5,93,NULL,'hw_','2025-11-28 08:50:41',NULL),(5,94,NULL,'traits:','2025-11-28 08:50:41',NULL),(8,2,NULL,'CIM_PASD_','2025-11-28 08:14:46',NULL),(8,5,NULL,'CIM_RASD_','2025-11-28 08:14:46',NULL),(8,8,NULL,'CIM_SASD_','2025-11-28 08:14:47',NULL),(8,11,NULL,'CIM_VSSD_','2025-11-28 08:14:47',NULL),(8,14,NULL,NULL,'2025-11-28 08:14:48',NULL),(8,17,NULL,NULL,'2025-11-28 08:14:48',NULL),(8,20,NULL,NULL,'2025-11-28 08:14:48',NULL),(8,32,NULL,'aggregate_instance_extra_specs:','2025-11-28 08:14:49',NULL),(11,2,NULL,'CIM_PASD_','2025-11-28 08:14:46',NULL),(11,5,NULL,'CIM_RASD_','2025-11-28 08:14:46',NULL),(11,8,NULL,'CIM_SASD_','2025-11-28 08:14:47',NULL),(11,11,NULL,'CIM_VSSD_','2025-11-28 08:14:47',NULL),(11,23,NULL,'hw:','2025-11-28 08:14:48',NULL),(11,26,NULL,'hw:','2025-11-28 08:14:48',NULL),(11,32,NULL,'capabilities:','2025-11-28 08:14:49',NULL),(11,44,NULL,'hw:','2025-11-28 08:14:51',NULL),(11,47,NULL,NULL,'2025-11-28 08:14:51',NULL),(11,50,NULL,NULL,'2025-11-28 08:14:51',NULL),(11,53,NULL,'hw:','2025-11-28 08:14:51',NULL),(11,56,NULL,NULL,'2025-11-28 08:14:52',NULL),(11,59,NULL,NULL,'2025-11-28 08:14:52',NULL),(11,65,NULL,'hw:','2025-11-28 08:14:52',NULL),(11,92,NULL,'hw:','2025-11-28 08:50:41',NULL),(11,93,NULL,'hw:','2025-11-28 08:50:41',NULL),(11,94,NULL,'traits:','2025-11-28 08:50:41',NULL),(14,2,'scheduler_hints',NULL,'2025-11-28 08:14:46',NULL),(14,80,'metadata',NULL,'2025-11-28 08:14:53',NULL),(14,83,'metadata',NULL,'2025-11-28 08:14:54',NULL),(14,86,'metadata',NULL,'2025-11-28 08:14:55',NULL),(17,80,NULL,NULL,'2025-11-28 08:14:54',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=103 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (2,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2025-11-28 08:14:46',NULL),(5,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2025-11-28 08:14:46',NULL),(8,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2025-11-28 08:14:47',NULL),(11,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2025-11-28 08:14:47',NULL),(14,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-11-28 08:14:48',NULL),(17,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-11-28 08:14:48',NULL),(20,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2025-11-28 08:14:48',NULL),(23,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2025-11-28 08:14:48',NULL),(26,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2025-11-28 08:14:48',NULL),(29,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2025-11-28 08:14:49',NULL),(32,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2025-11-28 08:14:49',NULL),(35,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2025-11-28 08:14:49',NULL),(38,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2025-11-28 08:14:49',NULL),(41,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-28 08:14:50',NULL),(44,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-28 08:14:50',NULL),(47,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-28 08:14:51',NULL),(50,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2025-11-28 08:14:51',NULL),(53,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2025-11-28 08:14:51',NULL),(56,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-28 08:14:52',NULL),(59,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-28 08:14:52',NULL),(62,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-28 08:14:52',NULL),(65,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-28 08:14:52',NULL),(68,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-28 08:14:52',NULL),(71,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2025-11-28 08:14:53',NULL),(74,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2025-11-28 08:14:53',NULL),(77,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2025-11-28 08:14:53',NULL),(80,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2025-11-28 08:14:53',NULL),(83,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2025-11-28 08:14:54',NULL),(86,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2025-11-28 08:14:54',NULL),(89,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2025-11-28 08:14:55',NULL),(92,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2025-11-28 08:50:41',NULL),(93,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2025-11-28 08:50:41',NULL),(94,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2025-11-28 08:50:41',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (2,47,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2025-11-28 08:14:51',NULL),(5,47,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2025-11-28 08:14:51',NULL),(8,47,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2025-11-28 08:14:51',NULL),(11,80,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2025-11-28 08:14:54',NULL),(14,80,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2025-11-28 08:14:54',NULL),(17,80,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2025-11-28 08:14:54',NULL),(20,80,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2025-11-28 08:14:54',NULL),(23,80,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-11-28 08:14:54',NULL),(26,80,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-11-28 08:14:54',NULL),(29,80,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-11-28 08:14:54',NULL),(32,80,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-11-28 08:14:54',NULL),(35,80,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-11-28 08:14:54',NULL),(38,80,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2025-11-28 08:14:54',NULL),(41,80,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2025-11-28 08:14:54',NULL),(44,80,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2025-11-28 08:14:54',NULL),(47,83,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2025-11-28 08:14:54',NULL),(50,83,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2025-11-28 08:14:54',NULL),(53,83,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2025-11-28 08:14:54',NULL),(56,83,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2025-11-28 08:14:54',NULL),(59,83,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2025-11-28 08:14:54',NULL),(62,86,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-11-28 08:14:55',NULL),(65,86,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-11-28 08:14:55',NULL),(68,86,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-11-28 08:14:55',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=388 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (2,2,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2025-11-28 08:14:46',NULL),(5,2,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2025-11-28 08:14:46',NULL),(8,2,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2025-11-28 08:14:46',NULL),(11,5,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2025-11-28 08:14:46',NULL),(14,5,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2025-11-28 08:14:46',NULL),(17,5,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2025-11-28 08:14:46',NULL),(20,5,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2025-11-28 08:14:46',NULL),(23,5,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2025-11-28 08:14:46',NULL),(26,5,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-11-28 08:14:47',NULL),(29,5,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2025-11-28 08:14:47',NULL),(32,5,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2025-11-28 08:14:47',NULL),(35,5,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2025-11-28 08:14:47',NULL),(38,5,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2025-11-28 08:14:47',NULL),(41,5,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2025-11-28 08:14:47',NULL),(44,5,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2025-11-28 08:14:47',NULL),(47,5,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2025-11-28 08:14:47',NULL),(50,5,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-11-28 08:14:47',NULL),(53,5,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2025-11-28 08:14:47',NULL),(56,5,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-11-28 08:14:47',NULL),(59,5,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2025-11-28 08:14:47',NULL),(62,5,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2025-11-28 08:14:47',NULL),(65,5,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2025-11-28 08:14:47',NULL),(68,8,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2025-11-28 08:14:47',NULL),(71,8,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2025-11-28 08:14:47',NULL),(74,8,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2025-11-28 08:14:47',NULL),(77,8,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2025-11-28 08:14:47',NULL),(80,8,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2025-11-28 08:14:47',NULL),(83,8,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-11-28 08:14:47',NULL),(86,8,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-11-28 08:14:47',NULL),(89,8,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2025-11-28 08:14:47',NULL),(92,8,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2025-11-28 08:14:47',NULL),(95,8,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-11-28 08:14:47',NULL),(98,8,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2025-11-28 08:14:47',NULL),(101,8,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-11-28 08:14:47',NULL),(104,8,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-11-28 08:14:47',NULL),(107,11,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2025-11-28 08:14:47',NULL),(110,11,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2025-11-28 08:14:47',NULL),(113,11,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2025-11-28 08:14:47',NULL),(116,11,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2025-11-28 08:14:47',NULL),(119,11,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2025-11-28 08:14:47',NULL),(122,11,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-11-28 08:14:47',NULL),(125,11,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-11-28 08:14:48',NULL),(128,11,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2025-11-28 08:14:48',NULL),(131,11,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2025-11-28 08:14:48',NULL),(134,11,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2025-11-28 08:14:48',NULL),(137,11,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2025-11-28 08:14:48',NULL),(140,11,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2025-11-28 08:14:48',NULL),(143,11,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2025-11-28 08:14:48',NULL),(146,11,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2025-11-28 08:14:48',NULL),(149,11,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2025-11-28 08:14:48',NULL),(152,11,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2025-11-28 08:14:48',NULL),(155,11,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2025-11-28 08:14:48',NULL),(158,14,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2025-11-28 08:14:48',NULL),(161,17,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2025-11-28 08:14:48',NULL),(164,20,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2025-11-28 08:14:48',NULL),(167,23,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2025-11-28 08:14:48',NULL),(170,23,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2025-11-28 08:14:48',NULL),(173,26,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2025-11-28 08:14:48',NULL),(176,29,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-28 08:14:49',NULL),(179,32,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2025-11-28 08:14:49',NULL),(182,32,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2025-11-28 08:14:49',NULL),(185,32,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2025-11-28 08:14:49',NULL),(188,32,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-11-28 08:14:49',NULL),(191,32,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-11-28 08:14:49',NULL),(194,32,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-11-28 08:14:49',NULL),(197,32,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2025-11-28 08:14:49',NULL),(200,35,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2025-11-28 08:14:49',NULL),(203,35,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2025-11-28 08:14:49',NULL),(206,38,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2025-11-28 08:14:49',NULL),(209,38,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-11-28 08:14:49',NULL),(212,41,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-11-28 08:14:50',NULL),(215,41,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-11-28 08:14:50',NULL),(218,41,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2025-11-28 08:14:50',NULL),(221,41,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2025-11-28 08:14:50',NULL),(224,41,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2025-11-28 08:14:50',NULL),(227,41,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2025-11-28 08:14:50',NULL),(230,41,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\"]}','2025-11-28 08:14:50',NULL),(233,41,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-28 08:14:50',NULL),(236,41,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2025-11-28 08:14:50',NULL),(239,41,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2025-11-28 08:14:50',NULL),(242,41,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, and virtio. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\"]}','2025-11-28 08:14:50',NULL),(245,41,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-28 08:14:50',NULL),(248,41,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-28 08:14:50',NULL),(251,41,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-11-28 08:14:50',NULL),(254,41,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2025-11-28 08:14:50',NULL),(257,41,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-11-28 08:14:50',NULL),(260,44,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-28 08:14:51',NULL),(263,44,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-28 08:14:51',NULL),(266,44,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-28 08:14:51',NULL),(269,50,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2025-11-28 08:14:51',NULL),(272,50,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2025-11-28 08:14:51',NULL),(275,50,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2025-11-28 08:14:51',NULL),(278,53,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-11-28 08:14:51',NULL),(281,53,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-11-28 08:14:51',NULL),(284,53,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-11-28 08:14:51',NULL),(287,53,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-11-28 08:14:51',NULL),(290,53,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-11-28 08:14:51',NULL),(293,53,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-11-28 08:14:52',NULL),(296,56,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2025-11-28 08:14:52',NULL),(299,56,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2025-11-28 08:14:52',NULL),(302,59,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-28 08:14:52',NULL),(305,59,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-28 08:14:52',NULL),(308,62,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2025-11-28 08:14:52',NULL),(311,62,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2025-11-28 08:14:52',NULL),(314,62,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2025-11-28 08:14:52',NULL),(317,62,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2025-11-28 08:14:52',NULL),(320,62,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, VirtualSriovEthernetCard, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualSriovEthernetCard\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2025-11-28 08:14:52',NULL),(323,62,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-28 08:14:52',NULL),(326,65,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2025-11-28 08:14:52',NULL),(329,68,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2025-11-28 08:14:53',NULL),(332,71,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2025-11-28 08:14:53',NULL),(335,71,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2025-11-28 08:14:53',NULL),(338,71,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2025-11-28 08:14:53',NULL),(341,71,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2025-11-28 08:14:53',NULL),(344,71,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-11-28 08:14:53',NULL),(347,71,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-11-28 08:14:53',NULL),(350,71,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2025-11-28 08:14:53',NULL),(353,71,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2025-11-28 08:14:53',NULL),(356,71,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2025-11-28 08:14:53',NULL),(359,74,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2025-11-28 08:14:53',NULL),(362,74,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2025-11-28 08:14:53',NULL),(365,74,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2025-11-28 08:14:53',NULL),(368,74,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2025-11-28 08:14:53',NULL),(371,77,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-11-28 08:14:53',NULL),(374,77,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-11-28 08:14:53',NULL),(377,77,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2025-11-28 08:14:53',NULL),(380,89,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2025-11-28 08:14:55',NULL),(383,92,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2025-11-28 08:50:41',NULL),(384,93,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2025-11-28 08:50:41',NULL),(385,94,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-11-28 08:50:41',NULL),(386,94,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-11-28 08:50:41',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (2,'OS::Cinder::Volume',1,'2025-11-28 08:14:46',NULL),(5,'OS::Glance::Image',1,'2025-11-28 08:14:46',NULL),(8,'OS::Nova::Aggregate',1,'2025-11-28 08:14:46',NULL),(11,'OS::Nova::Flavor',1,'2025-11-28 08:14:46',NULL),(14,'OS::Nova::Server',1,'2025-11-28 08:14:46',NULL),(17,'OS::Trove::Instance',1,'2025-11-28 08:14:53',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('Glance Migrations','/usr/lib/python3.9/site-packages/glance/db/sqlalchemy/migrate_repo',0);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
INSERT INTO `task_info` (`task_id`, `input`, `result`, `message`) VALUES ('08c4a742-08d0-48a4-90dd-b5fe5ae58fde','{\"image_properties\": {\"container_format\": \"bare\", \"disk_format\": \"qcow2\", \"visibility\": \"public\", \"name\": \"tempest-task_image-677029937\"}, \"import_from_format\": \"qcow2\", \"import_from\": \"http://tempest-dummy-img-file-26578770.qcow2\"}',NULL,'Task failed due to Internal Error'),('6c7176a9-0cba-411d-bd2e-8995e85f48fb','{\"image_id\": \"6db7e5d2-083b-4c63-9086-6685af0eda4f\", \"import_req\": {\"method\": {\"name\": \"web-download\", \"uri\": \"http://does-not.exist/no/possible/way\"}, \"stores\": [\"default_backend\"]}, \"backend\": [\"default_backend\"]}',NULL,'Task failed due to Internal Error'),('98320867-d7be-42ba-a7d2-91db30b942f1','{\"image_id\": \"77243701-5a5b-4139-b157-a98a6dc541c2\", \"import_req\": {\"method\": {\"name\": \"web-download\", \"uri\": \"https://download.cirros-cloud.net/0.6.2/cirros-0.6.2-x86_64-disk.img\"}, \"all_stores\": true}, \"backend\": [\"default_backend\"]}','{\"image_id\": \"77243701-5a5b-4139-b157-a98a6dc541c2\"}','Copied 112 MiB'),('cb72022b-407d-46ae-acfa-98cd65484485','{\"image_id\": \"191ae142-9d7e-4de5-80cc-5aa64590b368\", \"import_req\": {\"method\": {\"name\": \"glance-direct\"}, \"all_stores\": true}, \"backend\": [\"default_backend\"]}','{\"image_id\": \"191ae142-9d7e-4de5-80cc-5aa64590b368\"}','Copied 0 MiB');
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
INSERT INTO `tasks` (`id`, `type`, `status`, `owner`, `expires_at`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `image_id`, `request_id`, `user_id`) VALUES ('08c4a742-08d0-48a4-90dd-b5fe5ae58fde','import','failure','3a6bc1104ced4f17a79fdec910ce3950','2025-11-30 10:03:59','2025-11-28 10:03:58','2025-11-28 10:03:59',NULL,0,NULL,'req-485e8e8e-d168-4a0a-8d84-9ba2e6804793','06c57f3efffc46ebbf7c4775077abaf0'),('6c7176a9-0cba-411d-bd2e-8995e85f48fb','api_image_import','failure','97d088731e5740f69c6a5c2639052701','2025-11-30 10:03:54','2025-11-28 10:03:54','2025-11-28 10:03:54',NULL,0,'6db7e5d2-083b-4c63-9086-6685af0eda4f','req-9903c699-dbbf-458e-9f90-9476ad4f735c','c6ca66535429485d860824489d89b251'),('98320867-d7be-42ba-a7d2-91db30b942f1','api_image_import','success','c57c5dfffe2a46d99b4de8a1c43bc77d','2025-11-30 10:03:45','2025-11-28 10:03:39','2025-11-28 10:03:45',NULL,0,'77243701-5a5b-4139-b157-a98a6dc541c2','req-2e23eebe-fd9c-4878-bde5-fceb8ff6ffdd','59f52847072a48c9ba23dd63da725099'),('cb72022b-407d-46ae-acfa-98cd65484485','api_image_import','success','c57c5dfffe2a46d99b4de8a1c43bc77d','2025-11-30 10:03:38','2025-11-28 10:03:36','2025-11-28 10:03:38',NULL,0,'191ae142-9d7e-4de5-80cc-5aa64590b368','req-e0aa679e-3de4-4333-9122-d7814703648f','59f52847072a48c9ba23dd63da725099');
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `heat`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `heat` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `heat`;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `resource_action` varchar(255) DEFAULT NULL,
  `resource_status` varchar(255) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `physical_resource_id` varchar(255) DEFAULT NULL,
  `resource_status_reason` varchar(255) DEFAULT NULL,
  `resource_type` varchar(255) DEFAULT NULL,
  `resource_properties` blob DEFAULT NULL,
  `rsrc_prop_data_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `stack_id` (`stack_id`),
  KEY `ev_rsrc_prop_data_ref` (`rsrc_prop_data_id`),
  CONSTRAINT `ev_rsrc_prop_data_ref` FOREIGN KEY (`rsrc_prop_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `event_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `event`
--

LOCK TABLES `event` WRITE;
/*!40000 ALTER TABLE `event` DISABLE KEYS */;
/*!40000 ALTER TABLE `event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('heat','/usr/lib/python3.9/site-packages/heat/db/sqlalchemy/migrate_repo',86);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raw_template`
--

DROP TABLE IF EXISTS `raw_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `raw_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `template` longtext DEFAULT NULL,
  `files` longtext DEFAULT NULL,
  `environment` longtext DEFAULT NULL,
  `files_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_tmpl_files_fkey_ref` (`files_id`),
  CONSTRAINT `raw_tmpl_files_fkey_ref` FOREIGN KEY (`files_id`) REFERENCES `raw_template_files` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raw_template`
--

LOCK TABLES `raw_template` WRITE;
/*!40000 ALTER TABLE `raw_template` DISABLE KEYS */;
/*!40000 ALTER TABLE `raw_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raw_template_files`
--

DROP TABLE IF EXISTS `raw_template_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `raw_template_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `files` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raw_template_files`
--

LOCK TABLES `raw_template_files` WRITE;
/*!40000 ALTER TABLE `raw_template_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `raw_template_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource`
--

DROP TABLE IF EXISTS `resource`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `nova_instance` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  `rsrc_metadata` longtext DEFAULT NULL,
  `properties_data` longtext DEFAULT NULL,
  `engine_id` varchar(36) DEFAULT NULL,
  `atomic_key` int(11) DEFAULT NULL,
  `needed_by` longtext DEFAULT NULL,
  `requires` longtext DEFAULT NULL,
  `replaces` int(11) DEFAULT NULL,
  `replaced_by` int(11) DEFAULT NULL,
  `current_template_id` int(11) DEFAULT NULL,
  `properties_data_encrypted` tinyint(1) DEFAULT NULL,
  `root_stack_id` varchar(36) DEFAULT NULL,
  `rsrc_prop_data_id` int(11) DEFAULT NULL,
  `attr_data_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `stack_id` (`stack_id`),
  KEY `current_template_id` (`current_template_id`),
  KEY `ix_resource_root_stack_id` (`root_stack_id`),
  KEY `rsrc_rsrc_prop_data_ref` (`rsrc_prop_data_id`),
  KEY `rsrc_attr_data_ref` (`attr_data_id`),
  CONSTRAINT `resource_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`),
  CONSTRAINT `resource_ibfk_2` FOREIGN KEY (`current_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `rsrc_attr_data_ref` FOREIGN KEY (`attr_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `rsrc_rsrc_prop_data_ref` FOREIGN KEY (`rsrc_prop_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`properties_data_encrypted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource`
--

LOCK TABLES `resource` WRITE;
/*!40000 ALTER TABLE `resource` DISABLE KEYS */;
/*!40000 ALTER TABLE `resource` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_data`
--

DROP TABLE IF EXISTS `resource_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  `redact` tinyint(1) DEFAULT NULL,
  `decrypt_method` varchar(64) DEFAULT NULL,
  `resource_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_resource_id` (`resource_id`),
  CONSTRAINT `fk_resource_id` FOREIGN KEY (`resource_id`) REFERENCES `resource` (`id`) ON DELETE CASCADE,
  CONSTRAINT `CONSTRAINT_1` CHECK (`redact` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_data`
--

LOCK TABLES `resource_data` WRITE;
/*!40000 ALTER TABLE `resource_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `resource_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_properties_data`
--

DROP TABLE IF EXISTS `resource_properties_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource_properties_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `data` longtext DEFAULT NULL,
  `encrypted` tinyint(1) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`encrypted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_properties_data`
--

LOCK TABLES `resource_properties_data` WRITE;
/*!40000 ALTER TABLE `resource_properties_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `resource_properties_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(36) NOT NULL,
  `engine_id` varchar(36) NOT NULL,
  `host` varchar(255) NOT NULL,
  `hostname` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `topic` varchar(255) NOT NULL,
  `report_interval` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `engine_id`, `host`, `hostname`, `binary`, `topic`, `report_interval`, `created_at`, `updated_at`, `deleted_at`) VALUES ('0017bb7b-f816-43fa-946c-16d6804df5df','7cd9ae4a-d110-4d1f-bd56-e96187ab0b67','np0005538510.localdomain','np0005538510.localdomain','heat-engine','engine',60,'2025-11-28 08:19:26','2025-11-28 08:44:26',NULL),('0e7845b6-f626-41a2-bf81-28bd23799471','7085c174-4d7a-49a6-93b3-2c2dfcef1984','heat-engine-5b8b49c7cc-tdcbd','heat-engine-5b8b49c7cc-tdcbd','heat-engine','engine',60,'2025-11-28 08:58:52','2025-11-28 10:24:52',NULL),('1d57bb67-f9af-4478-8e47-c917c383154c','975b1a4a-8c1b-42bc-952c-98e674e2c61d','np0005538511.localdomain','np0005538511.localdomain','heat-engine','engine',60,'2025-11-28 08:19:40','2025-11-28 08:44:40',NULL),('96bad52a-de8b-479a-aa15-ed80cd2f2e28','e3fd64f4-9440-4b8b-b4de-20e22aa4f28f','heat-engine-5b8b49c7cc-tdcbd','heat-engine-5b8b49c7cc-tdcbd','heat-engine','engine',60,'2025-11-28 08:58:52','2025-11-28 10:24:52',NULL),('a4f3f422-9655-4f4a-beba-ed88fb9d6751','e60203d8-c638-4598-b769-c67529cbd433','heat-engine-5b8b49c7cc-tdcbd','heat-engine-5b8b49c7cc-tdcbd','heat-engine','engine',60,'2025-11-28 08:58:51','2025-11-28 10:24:52',NULL),('de66f4a4-66d4-434d-af3c-a4ab208f38c1','94d6935f-a30f-4d06-9c20-247bb6beb8d2','np0005538512.localdomain','np0005538512.localdomain','heat-engine','engine',60,'2025-11-28 08:19:40','2025-11-28 08:44:40',NULL),('eeeb4c86-a7fa-4fb4-bb05-4db4be56446a','5ed2624a-9935-4553-9c9f-746b0f579c1f','heat-engine-5b8b49c7cc-tdcbd','heat-engine-5b8b49c7cc-tdcbd','heat-engine','engine',60,'2025-11-28 08:58:51','2025-11-28 10:24:52',NULL);
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot`
--

DROP TABLE IF EXISTS `snapshot`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot` (
  `id` varchar(36) NOT NULL,
  `stack_id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` varchar(255) DEFAULT NULL,
  `data` longtext DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stack_id` (`stack_id`),
  KEY `ix_snapshot_tenant` (`tenant`),
  CONSTRAINT `snapshot_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot`
--

LOCK TABLES `snapshot` WRITE;
/*!40000 ALTER TABLE `snapshot` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `software_config`
--

DROP TABLE IF EXISTS `software_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `software_config` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `group` varchar(255) DEFAULT NULL,
  `config` longtext DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_software_config_tenant` (`tenant`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `software_config`
--

LOCK TABLES `software_config` WRITE;
/*!40000 ALTER TABLE `software_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `software_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `software_deployment`
--

DROP TABLE IF EXISTS `software_deployment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `software_deployment` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `server_id` varchar(36) NOT NULL,
  `config_id` varchar(36) NOT NULL,
  `input_values` longtext DEFAULT NULL,
  `output_values` longtext DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  `stack_user_project_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `config_id` (`config_id`),
  KEY `ix_software_deployment_server_id` (`server_id`),
  KEY `ix_software_deployment_tenant` (`tenant`),
  KEY `ix_software_deployment_created_at` (`created_at`),
  CONSTRAINT `software_deployment_ibfk_1` FOREIGN KEY (`config_id`) REFERENCES `software_config` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `software_deployment`
--

LOCK TABLES `software_deployment` WRITE;
/*!40000 ALTER TABLE `software_deployment` DISABLE KEYS */;
/*!40000 ALTER TABLE `software_deployment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack`
--

DROP TABLE IF EXISTS `stack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `raw_template_id` int(11) NOT NULL,
  `prev_raw_template_id` int(11) DEFAULT NULL,
  `user_creds_id` int(11) DEFAULT NULL,
  `username` varchar(256) DEFAULT NULL,
  `owner_id` varchar(36) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `timeout` int(11) DEFAULT NULL,
  `tenant` varchar(256) DEFAULT NULL,
  `disable_rollback` tinyint(1) NOT NULL,
  `stack_user_project_id` varchar(64) DEFAULT NULL,
  `backup` tinyint(1) DEFAULT NULL,
  `nested_depth` int(11) DEFAULT NULL,
  `convergence` tinyint(1) DEFAULT NULL,
  `current_traversal` varchar(36) DEFAULT NULL,
  `current_deps` longtext DEFAULT NULL,
  `parent_resource_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_template_id` (`raw_template_id`),
  KEY `prev_raw_template_id` (`prev_raw_template_id`),
  KEY `user_creds_id` (`user_creds_id`),
  KEY `ix_stack_owner_id` (`owner_id`),
  KEY `ix_stack_tenant` (`tenant`(255)),
  KEY `ix_stack_name` (`name`),
  CONSTRAINT `stack_ibfk_1` FOREIGN KEY (`raw_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `stack_ibfk_2` FOREIGN KEY (`prev_raw_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `stack_ibfk_3` FOREIGN KEY (`user_creds_id`) REFERENCES `user_creds` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`disable_rollback` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`backup` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`convergence` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack`
--

LOCK TABLES `stack` WRITE;
/*!40000 ALTER TABLE `stack` DISABLE KEYS */;
/*!40000 ALTER TABLE `stack` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack_lock`
--

DROP TABLE IF EXISTS `stack_lock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack_lock` (
  `stack_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `engine_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`stack_id`),
  CONSTRAINT `stack_lock_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack_lock`
--

LOCK TABLES `stack_lock` WRITE;
/*!40000 ALTER TABLE `stack_lock` DISABLE KEYS */;
/*!40000 ALTER TABLE `stack_lock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack_tag`
--

DROP TABLE IF EXISTS `stack_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `tag` varchar(80) DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stack_id` (`stack_id`),
  CONSTRAINT `stack_tag_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack_tag`
--

LOCK TABLES `stack_tag` WRITE;
/*!40000 ALTER TABLE `stack_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `stack_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_point`
--

DROP TABLE IF EXISTS `sync_point`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sync_point` (
  `entity_id` varchar(36) NOT NULL,
  `traversal_id` varchar(36) NOT NULL,
  `is_update` tinyint(1) NOT NULL,
  `atomic_key` int(11) NOT NULL,
  `stack_id` varchar(36) NOT NULL,
  `input_data` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`traversal_id`,`is_update`),
  KEY `fk_stack_id` (`stack_id`),
  CONSTRAINT `fk_stack_id` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`is_update` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_point`
--

LOCK TABLES `sync_point` WRITE;
/*!40000 ALTER TABLE `sync_point` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_point` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_creds`
--

DROP TABLE IF EXISTS `user_creds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_creds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `username` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `region_name` varchar(255) DEFAULT NULL,
  `decrypt_method` varchar(64) DEFAULT NULL,
  `tenant` varchar(1024) DEFAULT NULL,
  `auth_url` text DEFAULT NULL,
  `tenant_id` varchar(256) DEFAULT NULL,
  `trust_id` varchar(255) DEFAULT NULL,
  `trustor_user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_creds`
--

LOCK TABLES `user_creds` WRITE;
/*!40000 ALTER TABLE `user_creds` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_creds` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `external_id` (`external_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`inherited` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','069be17722904b06be51a88095236729','e2c76e4d27554fd5a4f85cce208b136f','2730d0ff14d741bd9e6c60c570a153b7',0),('UserProject','0d543a6dcb564de5b39062ca08440499','e2c76e4d27554fd5a4f85cce208b136f','2730d0ff14d741bd9e6c60c570a153b7',0),('UserProject','0d543a6dcb564de5b39062ca08440499','e2c76e4d27554fd5a4f85cce208b136f','37803348eee54a1484e11e63d6915add',0),('UserProject','176f6a8192694fdc8f5a874f565dae4f','e2c76e4d27554fd5a4f85cce208b136f','2730d0ff14d741bd9e6c60c570a153b7',0),('UserProject','1f2d1d5b87f64cd6b5ffb655a337a986','c326253de5044a60be18dcfa12e29a2c','f9468b44e1534b7da74729620e342ef9',0),('UserProject','20dd68de85a14e1597411b67f815a244','e2c76e4d27554fd5a4f85cce208b136f','2730d0ff14d741bd9e6c60c570a153b7',0),('UserProject','20dd68de85a14e1597411b67f815a244','e2c76e4d27554fd5a4f85cce208b136f','37803348eee54a1484e11e63d6915add',0),('UserProject','2295229c552d4f70bade64908b85fbc4','e2c76e4d27554fd5a4f85cce208b136f','2730d0ff14d741bd9e6c60c570a153b7',0),('UserProject','2c8f139093484298a0d156130273e0b1','e2c76e4d27554fd5a4f85cce208b136f','2730d0ff14d741bd9e6c60c570a153b7',0),('UserProject','2c8f139093484298a0d156130273e0b1','e2c76e4d27554fd5a4f85cce208b136f','37803348eee54a1484e11e63d6915add',0),('UserProject','4d9169247d4447d0a8dd4c33f8b23dee','9dda653c53224db086060962b0702694','2730d0ff14d741bd9e6c60c570a153b7',0),('UserProject','4d9169247d4447d0a8dd4c33f8b23dee','c326253de5044a60be18dcfa12e29a2c','2730d0ff14d741bd9e6c60c570a153b7',0),('UserProject','4eaac26ddf16416eb8e7962b917a291d','e2c76e4d27554fd5a4f85cce208b136f','2730d0ff14d741bd9e6c60c570a153b7',0),('UserProject','4eaac26ddf16416eb8e7962b917a291d','e2c76e4d27554fd5a4f85cce208b136f','37803348eee54a1484e11e63d6915add',0),('UserProject','657c117bbb694de4b647b6f4c16afb44','e2c76e4d27554fd5a4f85cce208b136f','2730d0ff14d741bd9e6c60c570a153b7',0),('UserProject','657c117bbb694de4b647b6f4c16afb44','e2c76e4d27554fd5a4f85cce208b136f','37803348eee54a1484e11e63d6915add',0),('UserProject','7d7888cde8444ea191022389b22bb7f2','e2c76e4d27554fd5a4f85cce208b136f','2730d0ff14d741bd9e6c60c570a153b7',0),('UserProject','7d7888cde8444ea191022389b22bb7f2','e2c76e4d27554fd5a4f85cce208b136f','37803348eee54a1484e11e63d6915add',0),('UserProject','80832b2c07e64888adb9ec3c64cf8f39','e2c76e4d27554fd5a4f85cce208b136f','2730d0ff14d741bd9e6c60c570a153b7',0),('UserProject','80832b2c07e64888adb9ec3c64cf8f39','e2c76e4d27554fd5a4f85cce208b136f','37803348eee54a1484e11e63d6915add',0),('UserProject','9106a54d8d90470c87b4256768613691','e2c76e4d27554fd5a4f85cce208b136f','2730d0ff14d741bd9e6c60c570a153b7',0),('UserProject','9e5033e84dec44f4956046cabe7e22af','e2c76e4d27554fd5a4f85cce208b136f','2730d0ff14d741bd9e6c60c570a153b7',0),('UserProject','9e5033e84dec44f4956046cabe7e22af','e2c76e4d27554fd5a4f85cce208b136f','37803348eee54a1484e11e63d6915add',0),('UserProject','b49d2f4029e74b29872c82f75d741e99','e2c76e4d27554fd5a4f85cce208b136f','2730d0ff14d741bd9e6c60c570a153b7',0),('UserProject','b49d2f4029e74b29872c82f75d741e99','e2c76e4d27554fd5a4f85cce208b136f','37803348eee54a1484e11e63d6915add',0),('UserProject','b49d2f4029e74b29872c82f75d741e99','e2c76e4d27554fd5a4f85cce208b136f','fb07db2d79cd410ba3acbc79f475716f',0),('UserProject','d71fc4c5f0a54a339aa0e15fff315b07','e2c76e4d27554fd5a4f85cce208b136f','2730d0ff14d741bd9e6c60c570a153b7',0),('UserProject','d71fc4c5f0a54a339aa0e15fff315b07','e2c76e4d27554fd5a4f85cce208b136f','37803348eee54a1484e11e63d6915add',0),('UserProject','e8269f1ec92a49e2bb9d5152bb96a794','e2c76e4d27554fd5a4f85cce208b136f','2730d0ff14d741bd9e6c60c570a153b7',0),('UserProject','e8269f1ec92a49e2bb9d5152bb96a794','e2c76e4d27554fd5a4f85cce208b136f','37803348eee54a1484e11e63d6915add',0),('UserDomain','2e0fb7f84a3e447ab26824c8de1937e6','f8357292046f427cac08ac9d6a7512b6','2730d0ff14d741bd9e6c60c570a153b7',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
INSERT INTO `credential` (`id`, `user_id`, `project_id`, `type`, `extra`, `key_hash`, `encrypted_blob`) VALUES ('f192f2b947bc4ec49bd279fa4e5aa296','4d9169247d4447d0a8dd4c33f8b23dee',NULL,'cert','{}','a7e3b3e199e811c37576c27c085b897455fc1f38','gAAAAABpKV5ioNg7tByVFfJhxM-Yb9QhYrfF6_Cjxc839kAPC0-AN1X_MIRpmkNrXAf3EQmSUbHTIY7T3J4crNmAwOGyHnswWQ==');
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `service_id` (`service_id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('135d4b589a854ee19741e92b4d93f507',NULL,'internal','51ae879ca152446497cd73a15fdb420c','http://heat-api-internal.openstack.svc:8004/v1/%(tenant_id)s','{\"name\": \"heat\"}',1,'regionOne'),('1ab68f61058e48dcaf588477743ebcb5',NULL,'public','4db04cc4905f4af5aa5ca31068b811bc','http://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('1cdffa581ef84403b7f52ca4dd6cf707',NULL,'public','19718d5ea2f94a1fbb6f8e1c47732fe5','http://manila-public-openstack.apps-crc.testing/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne'),('3cd291882b6d46fdb193e1432abda82b',NULL,'internal','45210e5f59744d57b48cdead64587be4','http://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('3d55d87492ed4eb3b8ae5a436caa270d',NULL,'internal','4db04cc4905f4af5aa5ca31068b811bc','http://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('3fc5dbf41fb148a38194c63d05d22f8a',NULL,'internal','fe9b389d8c6749d7985c12016223c7bd','http://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('54c986d2266c4a5485ee4f34266e8ed8',NULL,'internal','19718d5ea2f94a1fbb6f8e1c47732fe5','http://manila-internal.openstack.svc:8786/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne'),('56f0433607ea4578be6d5ddcc0dceb32',NULL,'public','22da0d7f3f66485f88e4b29ef9ee1ec6','http://manila-public-openstack.apps-crc.testing/v2','{\"name\": \"manilav2\"}',1,'regionOne'),('57b3de92e3de4f82bb47e85c16efc3a9',NULL,'internal','d5c725f751d64b90b89de705fce7b5fa','http://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('6e0bc9a4226a4466ac51be9562b2f65b',NULL,'internal','22da0d7f3f66485f88e4b29ef9ee1ec6','http://manila-internal.openstack.svc:8786/v2','{\"name\": \"manilav2\"}',1,'regionOne'),('72fd5433b99c4bd59eb7d1e6a61a2cb8',NULL,'public','6650354ecf7a44bbbf58c30b5629cc42','http://aodh-public-openstack.apps-crc.testing','{\"name\": \"aodh\"}',1,'regionOne'),('757ddc0205ae41268a32d19cf5f73bfd',NULL,'public','b0913dc275dc43b38f06511a7907670c','http://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('86ded89ffa79445c8dbcbde7c00a46b2',NULL,'internal','b0913dc275dc43b38f06511a7907670c','http://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('8a67414b9fe2449f895191c831a9651e',NULL,'internal','45da105b23b64c2d91b3218c9a97c456','http://heat-cfnapi-internal.openstack.svc:8000/v1','{\"name\": \"heat-cfn\"}',1,'regionOne'),('9ad8e7a37d4c416a920e2304a3d2f385',NULL,'public','45210e5f59744d57b48cdead64587be4','http://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('9c82f424114442628c19135596fdfd4b',NULL,'public','fe9b389d8c6749d7985c12016223c7bd','http://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('a01807286d904b04b4c18ee76e7e85bc',NULL,'public','f9b2b1cb06574dc2bbc7dd48ebe10182','http://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('a07e62a82ea94d13bda89a2a226f06a2',NULL,'public','79be73d345fc412487f607f6317897d6','http://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('a1564c7c50d542a8808dc3485ac6296b',NULL,'public','51ae879ca152446497cd73a15fdb420c','http://heat-api-public-openstack.apps-crc.testing/v1/%(tenant_id)s','{\"name\": \"heat\"}',1,'regionOne'),('a322cf6bec684420a6d5d7156a116cc5',NULL,'internal','f9b2b1cb06574dc2bbc7dd48ebe10182','http://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('a768be83f4ef46a49268d8518be348c4',NULL,'internal','79be73d345fc412487f607f6317897d6','http://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('b31cf2c94025496088817ff133082f4d',NULL,'internal','6650354ecf7a44bbbf58c30b5629cc42','http://aodh-internal.openstack.svc:8042','{\"name\": \"aodh\"}',1,'regionOne'),('bb1f7c3f66cc42ea8d51b46b8809ef57',NULL,'public','45da105b23b64c2d91b3218c9a97c456','http://heat-cfnapi-public-openstack.apps-crc.testing/v1','{\"name\": \"heat-cfn\"}',1,'regionOne'),('d3b26fc0f711453cafeaed9ee89b92a9',NULL,'public','d5c725f751d64b90b89de705fce7b5fa','http://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `user_id` (`user_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('2730d0ff14d741bd9e6c60c570a153b7','f9468b44e1534b7da74729620e342ef9'),('f9468b44e1534b7da74729620e342ef9','2412ac8e3fcc4ad2bb47433bdaa1fa75');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=644 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (2,'4d9169247d4447d0a8dd4c33f8b23dee','default','admin',0,NULL),(5,'d71fc4c5f0a54a339aa0e15fff315b07','default','aodh',0,NULL),(8,'b49d2f4029e74b29872c82f75d741e99','default','ceilometer',0,NULL),(11,'7d7888cde8444ea191022389b22bb7f2','default','cinder',0,NULL),(14,'e8269f1ec92a49e2bb9d5152bb96a794','default','cinderv3',0,NULL),(17,'80832b2c07e64888adb9ec3c64cf8f39','default','glance',0,NULL),(20,'2295229c552d4f70bade64908b85fbc4','default','gnocchi',0,NULL),(23,'4eaac26ddf16416eb8e7962b917a291d','default','heat',0,NULL),(26,'2e0fb7f84a3e447ab26824c8de1937e6','f8357292046f427cac08ac9d6a7512b6','heat_stack_domain_admin',0,NULL),(29,'069be17722904b06be51a88095236729','default','heat-cfn',0,NULL),(32,'2c8f139093484298a0d156130273e0b1','default','manila',0,NULL),(35,'9106a54d8d90470c87b4256768613691','default','manilav2',0,NULL),(38,'0d543a6dcb564de5b39062ca08440499','default','neutron',0,NULL),(41,'9e5033e84dec44f4956046cabe7e22af','default','nova',0,NULL),(44,'657c117bbb694de4b647b6f4c16afb44','default','placement',0,NULL),(47,'176f6a8192694fdc8f5a874f565dae4f','default','swift',0,NULL),(50,'20dd68de85a14e1597411b67f815a244','default','barbican',0,NULL),(51,'1f2d1d5b87f64cd6b5ffb655a337a986','default','demo_tempestconf',0,NULL),(52,'5230cee3a0274ecc89c935a3aa7dbad1','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('keystone','/usr/lib/python3.9/site-packages/keystone/common/sql/migrate_repo',109),('keystone_contract','/usr/lib/python3.9/site-packages/keystone/common/sql/contract_repo',79),('keystone_data_migrate','/usr/lib/python3.9/site-packages/keystone/common/sql/data_migration_repo',79),('keystone_expand','/usr/lib/python3.9/site-packages/keystone/common/sql/expand_repo',79);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=646 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (2,2,'2025-11-28 08:46:28',0,'$2b$12$mWbaPEv74VDKxLnkJLjdHemAqk28FpWpr21GCexwHP7OId5k8MCo2',1764317714575311,1764319588226079,'2025-11-28 08:15:14'),(5,5,NULL,0,'$2b$12$vhu6Qs5iOxLR6VT6Xh.zRuRfgvuphug4M5IZeO1FlRsxFlfifFAb6',1764317858768673,NULL,'2025-11-28 08:17:38'),(8,8,NULL,0,'$2b$12$Lqq7ERNRnS/6ZDJMIX8vve8Mh7KzRTwGg1B.QuGxky14QMQPVA.NK',1764317859232110,NULL,'2025-11-28 08:17:39'),(11,11,NULL,0,'$2b$12$Zyw3uAZSharwgxIrU90QPOQt6nzNvqUwNsjAWL9RJsI8HzitBSVUC',1764317859529332,NULL,'2025-11-28 08:17:39'),(14,14,NULL,0,'$2b$12$TOTQ5xB1C.SEbTTqYxfgCuZGQMYOxmGRfDa0ofxICmoiDI.UVehy6',1764317860073164,NULL,'2025-11-28 08:17:40'),(17,17,NULL,0,'$2b$12$UrqsRppJ7WI1v8rCvi4Tx.3Ig/xTQXhe3XtB9BE2Yk.sS2gfqHyOG',1764317860443199,NULL,'2025-11-28 08:17:40'),(20,20,NULL,0,'$2b$12$5tMLeB/tuPDvRcUdoxMSEuuQQVCIwcpQBfvV46Qj8gNXseM1yEKyO',1764317860795399,NULL,'2025-11-28 08:17:40'),(23,23,NULL,0,'$2b$12$/lbpGy2yz44iuXEeq/K1fuN7rv0FY9SPklKzI7IWJkfsC/pdDGfu.',1764317861106064,NULL,'2025-11-28 08:17:41'),(26,26,NULL,0,'$2b$12$M.uYV92nitPztv/BWaRFE.rL4F5VWTvX2x7924qE/tAFQcWU3Z2WC',1764317861676715,NULL,'2025-11-28 08:17:41'),(29,29,NULL,0,'$2b$12$GP1OQpGL9dop5mr8arUY5uFn/ergcZfo8U5uMoBugR83/cuxWJRne',1764317862168194,NULL,'2025-11-28 08:17:42'),(32,32,NULL,0,'$2b$12$4G9BwAk0wEZdhe65/0fLwe3p4k9POkIsu/1L9Yhfn7TB7QhqrmIde',1764317862458978,NULL,'2025-11-28 08:17:42'),(35,35,NULL,0,'$2b$12$GJ0b83zkTc0.2mMe8npovut1/73ksr6rOx93ylipYfiT2ce3eIcYq',1764317871115716,NULL,'2025-11-28 08:17:51'),(38,38,NULL,0,'$2b$12$KLYhuepGtVeAkfi///2i8OJ6AYdrzlxbp9m2P.W23X7aaLa7wO.GS',1764317871380599,NULL,'2025-11-28 08:17:51'),(41,41,NULL,0,'$2b$12$pkvXJoRjv8HrGNXhYQNivugmGQs.Uu1XQzky6/fH.zDgh6A4XYwAy',1764317871731323,NULL,'2025-11-28 08:17:51'),(44,44,NULL,0,'$2b$12$CCbY2jKSfZmWjOGr6880tOA3fgi/dcI14nig.YcTa5F4MOcEcCgtq',1764317872348922,NULL,'2025-11-28 08:17:52'),(47,47,NULL,0,'$2b$12$mpAtVYJcmXJwf/g4Mu7TJ.LEKT64eTUFcCHP6.L7kJsGR7J/1XWX6',1764317872615768,NULL,'2025-11-28 08:17:52'),(50,2,NULL,0,'$2b$12$vdiyRu6rOW4mfoE4WXzvperXUJBEe.icMOTzzk2vaiKPlmWahrsoi',1764319588226079,NULL,'2025-11-28 08:46:28'),(51,50,NULL,0,'$2b$12$6ebvDpVYN.kV14z1NWe2B.G6ZPNklCNFMKSsiDqDH/yMaykWmusdy',1764319738049838,NULL,'2025-11-28 08:48:58'),(52,51,NULL,0,'$2b$12$It.oIbd5sequs5nwWlpLAe.to2ic/064hEZzetEVxSUyhfwrl43m6',1764323978412482,NULL,'2025-11-28 09:59:38'),(53,52,NULL,0,'$2b$12$PxcMfBofTO0jqpPSp2vtJOsf2uCAqd9lGKOGqXFUmtIIosB6oUbca',1764323978831858,NULL,'2025-11-28 09:59:38');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('9dda653c53224db086060962b0702694','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('a09b875cf74047b3b7a00da606f36904','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0),('c326253de5044a60be18dcfa12e29a2c','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1),('e2c76e4d27554fd5a4f85cce208b136f','service','{}',NULL,1,'default','default',0),('f8357292046f427cac08ac9d6a7512b6','heat_stack','{}','',1,'<<keystone.domain.root>>',NULL,1);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=1201 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (1,NULL,NULL,'4d9169247d4447d0a8dd4c33f8b23dee',NULL,NULL,NULL,NULL,'2025-11-28 08:46:28',NULL,'2025-11-28 08:46:28',NULL,NULL),(2,NULL,NULL,'15b0e5a3f34e47cd89aef4685e4bbead',NULL,NULL,NULL,NULL,'2025-11-28 10:00:14',NULL,'2025-11-28 10:00:14',NULL,NULL),(3,NULL,NULL,'9854d8a1b35d49e29f4099f615f25bc7',NULL,NULL,NULL,NULL,'2025-11-28 10:00:17',NULL,'2025-11-28 10:00:17',NULL,NULL),(4,NULL,NULL,'0bf3e72f1c4a4ffba05df1d6e4f852e0',NULL,NULL,NULL,NULL,'2025-11-28 10:00:17',NULL,'2025-11-28 10:00:17',NULL,NULL),(5,NULL,'f1d640d06c3c44f6a4048a72b25cb90b',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:17',NULL,'2025-11-28 10:00:17',NULL,NULL),(6,NULL,NULL,'9b51aaa0f6664a8084d6e0dc5dda382e',NULL,NULL,NULL,NULL,'2025-11-28 10:00:17',NULL,'2025-11-28 10:00:17',NULL,NULL),(7,NULL,NULL,'45f60dd5b01d4c65b8c1e9cf217d6f71',NULL,NULL,NULL,NULL,'2025-11-28 10:00:18',NULL,'2025-11-28 10:00:18',NULL,NULL),(8,NULL,NULL,'164a15d0cdd140dcb5a893e1efa4ffdc',NULL,NULL,NULL,NULL,'2025-11-28 10:00:18',NULL,'2025-11-28 10:00:18',NULL,NULL),(9,NULL,NULL,'6c8f09a1710942598415fc2c8154fbdb',NULL,NULL,NULL,NULL,'2025-11-28 10:00:18',NULL,'2025-11-28 10:00:18',NULL,NULL),(10,NULL,NULL,'82570d0db4b04e10915c8f8a45af146b',NULL,NULL,NULL,NULL,'2025-11-28 10:00:18',NULL,'2025-11-28 10:00:18',NULL,NULL),(11,NULL,NULL,'4cd6b033c5f04f9bb568830d196422cc',NULL,NULL,NULL,NULL,'2025-11-28 10:00:18',NULL,'2025-11-28 10:00:18',NULL,NULL),(12,NULL,NULL,'7fb73d40ade24bae9dac477b96df9bed',NULL,NULL,NULL,NULL,'2025-11-28 10:00:19',NULL,'2025-11-28 10:00:19',NULL,NULL),(13,NULL,NULL,'0d45e6c5fd90454bbdb51d1ae7248195',NULL,NULL,NULL,NULL,'2025-11-28 10:00:19',NULL,'2025-11-28 10:00:19',NULL,NULL),(14,NULL,'2ab0afe59212442fbcc2f4bd1ebd9b97',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:19',NULL,'2025-11-28 10:00:19',NULL,NULL),(15,NULL,'b8a345d0cde54424a2cc3fa8e6b4e02b',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:19',NULL,'2025-11-28 10:00:19',NULL,NULL),(16,NULL,'5af13a59c19b4c88944d217ea18271e6',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:20',NULL,'2025-11-28 10:00:20',NULL,NULL),(17,NULL,'5e7319a49e6445d9bf52fb2725fa61ed',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:20',NULL,'2025-11-28 10:00:20',NULL,NULL),(18,NULL,'386700638a41419aa2c43f407111a8f2',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:20',NULL,'2025-11-28 10:00:20',NULL,NULL),(19,NULL,'f8f109444bac4667a72ab3008ba1c6ce',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:20',NULL,'2025-11-28 10:00:20',NULL,NULL),(20,NULL,'b268de38ce4d4509bf57bcce307c63f7',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:20',NULL,'2025-11-28 10:00:20',NULL,NULL),(21,NULL,'542170173cf44d298588e911cab46c9f',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:20',NULL,'2025-11-28 10:00:20',NULL,NULL),(22,NULL,NULL,'4de9cf287af1480980dbd1720624dd4a',NULL,NULL,NULL,NULL,'2025-11-28 10:00:20',NULL,'2025-11-28 10:00:20',NULL,NULL),(23,NULL,'73ed5e715b2145ca98f858d1a6aa36a4',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:21',NULL,'2025-11-28 10:00:21',NULL,NULL),(24,NULL,NULL,'dc9f3f13467743db9331ccb7111f9e21',NULL,NULL,NULL,NULL,'2025-11-28 10:00:21',NULL,'2025-11-28 10:00:21',NULL,NULL),(25,NULL,NULL,'dcfca92f9f094207b300108767d0bb2a',NULL,NULL,NULL,NULL,'2025-11-28 10:00:21',NULL,'2025-11-28 10:00:21',NULL,NULL),(26,NULL,'4f8e048e3d0b492a98c6a95bec38e352',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:21',NULL,'2025-11-28 10:00:21',NULL,NULL),(27,NULL,NULL,'3cac1a2f795946f48bafe04e8b32993f',NULL,NULL,NULL,NULL,'2025-11-28 10:00:22',NULL,'2025-11-28 10:00:22',NULL,NULL),(28,NULL,NULL,'d638c71a75f747ee9bfe1ede4b8954aa',NULL,NULL,NULL,NULL,'2025-11-28 10:00:22',NULL,'2025-11-28 10:00:22',NULL,NULL),(29,NULL,'e9fe1efff3e24c4ea347f6271e8adc08',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:23',NULL,'2025-11-28 10:00:23',NULL,NULL),(30,NULL,'0b6f740367724946ae4cb869a018a139',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:23',NULL,'2025-11-28 10:00:23',NULL,NULL),(31,NULL,'34292b5bdbdf4fc681900e86bcdec56b',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:24',NULL,'2025-11-28 10:00:24',NULL,NULL),(32,NULL,'7972d93d20864c40b435112a86134f88',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:25',NULL,'2025-11-28 10:00:25',NULL,NULL),(33,NULL,NULL,'117a67f1050e4edb89e8f5000eb4c9e5',NULL,NULL,NULL,NULL,'2025-11-28 10:00:25',NULL,'2025-11-28 10:00:25',NULL,NULL),(34,NULL,'dad323e081d448ed9471071d95f0c646',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:25',NULL,'2025-11-28 10:00:25',NULL,NULL),(35,NULL,NULL,'8b6f359612de4d8e905d2d1adf9cfd20',NULL,NULL,NULL,NULL,'2025-11-28 10:00:25',NULL,'2025-11-28 10:00:25',NULL,NULL),(36,NULL,NULL,'c2043fb1efed49afaf8fbcb3ee130291',NULL,NULL,NULL,NULL,'2025-11-28 10:00:25',NULL,'2025-11-28 10:00:25',NULL,NULL),(37,NULL,NULL,'47a26a23a0e2470eae63768ee9b91678',NULL,NULL,NULL,NULL,'2025-11-28 10:00:25',NULL,'2025-11-28 10:00:25',NULL,NULL),(38,NULL,NULL,'0d3e1567139f4d69b1a7c516b0bea811',NULL,NULL,NULL,NULL,'2025-11-28 10:00:26',NULL,'2025-11-28 10:00:26',NULL,NULL),(39,NULL,NULL,'c8889ae927bf40e097f582dc7a95c1f2',NULL,NULL,NULL,NULL,'2025-11-28 10:00:26',NULL,'2025-11-28 10:00:26',NULL,NULL),(40,NULL,NULL,'169ecae2f44642449fd0001d0e1f739d',NULL,NULL,NULL,NULL,'2025-11-28 10:00:26',NULL,'2025-11-28 10:00:26',NULL,NULL),(41,NULL,NULL,'4abedb3542f3445684200ef74e4c30ff',NULL,NULL,NULL,NULL,'2025-11-28 10:00:26',NULL,'2025-11-28 10:00:26',NULL,NULL),(42,NULL,'22ba6f479b8f422794ab22f611aef7a1',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:27',NULL,'2025-11-28 10:00:27',NULL,NULL),(43,NULL,'cdbbd77611fd4866b04fd97c4877f4e9',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:27',NULL,'2025-11-28 10:00:27',NULL,NULL),(44,NULL,'d168fac9de4d4ef2b4406ac9558fecfa',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:27',NULL,'2025-11-28 10:00:27',NULL,NULL),(45,NULL,'81782ad55d7b42089469ce1f24ffc4b1',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:27',NULL,'2025-11-28 10:00:27',NULL,NULL),(46,NULL,'2177c2c6b4324ef2b29aa2bf275e8e0f',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:28',NULL,'2025-11-28 10:00:28',NULL,NULL),(47,NULL,'b99dfd807cd1453c858c79efc9bcb635',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:28',NULL,'2025-11-28 10:00:28',NULL,NULL),(48,NULL,'fe8f013ad3764d3f9e38681ff48cb8a9',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:28',NULL,'2025-11-28 10:00:28',NULL,NULL),(49,NULL,NULL,'a22d96ace6e94a01ae323d94409aefe8',NULL,NULL,NULL,NULL,'2025-11-28 10:00:29',NULL,'2025-11-28 10:00:29',NULL,NULL),(50,NULL,'c14c946fab6b40a69e7cc866e1143c54',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:29',NULL,'2025-11-28 10:00:29',NULL,NULL),(51,NULL,NULL,'2c3f07a40411404fa1292ec665b8c62e',NULL,NULL,NULL,NULL,'2025-11-28 10:00:29',NULL,'2025-11-28 10:00:29',NULL,NULL),(52,NULL,NULL,'ce52ce9da9f24d529cfd0f98a86a8a7f',NULL,NULL,NULL,NULL,'2025-11-28 10:00:30',NULL,'2025-11-28 10:00:30',NULL,NULL),(53,NULL,NULL,'9a4b58baffd540018c71f72d527763f2',NULL,NULL,NULL,NULL,'2025-11-28 10:00:30',NULL,'2025-11-28 10:00:30',NULL,NULL),(54,NULL,'30df8f2f87e4410b83d8513cc8a15f23',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:31',NULL,'2025-11-28 10:00:31',NULL,NULL),(55,NULL,'df78cae308d44301bb4396d2a7a61954',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:32',NULL,'2025-11-28 10:00:32',NULL,NULL),(56,NULL,'d8bd874f21024ec49961a8de8f238021',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:32',NULL,'2025-11-28 10:00:32',NULL,NULL),(57,NULL,NULL,'1464c3ae1a40415c9861b68fd4d6e6f5',NULL,NULL,NULL,NULL,'2025-11-28 10:00:32',NULL,'2025-11-28 10:00:32',NULL,NULL),(58,NULL,NULL,'8ea6e2aec9474e6594c08987b8c79204',NULL,NULL,NULL,NULL,'2025-11-28 10:00:33',NULL,'2025-11-28 10:00:33',NULL,NULL),(59,NULL,NULL,'dfd85aa2703a4f17b586a97ceee07f1a',NULL,NULL,NULL,NULL,'2025-11-28 10:00:33',NULL,'2025-11-28 10:00:33',NULL,NULL),(60,NULL,NULL,'77c33b0864f54574b8fc2b30ee2a8add',NULL,NULL,NULL,NULL,'2025-11-28 10:00:33',NULL,'2025-11-28 10:00:33',NULL,NULL),(61,NULL,'c757adc2dc8c48e1b460932a9580c4bd',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:33',NULL,'2025-11-28 10:00:33',NULL,NULL),(62,NULL,NULL,'e7bc0337c17d4112b299dbb784e98481',NULL,NULL,NULL,NULL,'2025-11-28 10:00:33',NULL,'2025-11-28 10:00:33',NULL,NULL),(63,NULL,NULL,'73a49eab535840469b1fd052d386c16a',NULL,NULL,NULL,NULL,'2025-11-28 10:00:34',NULL,'2025-11-28 10:00:34',NULL,NULL),(64,NULL,'ea61a5236ad2407485482a6f7462d550',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:35',NULL,'2025-11-28 10:00:35',NULL,NULL),(65,NULL,'550909bce9df4cff9325bd86f3b599f3',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:35',NULL,'2025-11-28 10:00:35',NULL,NULL),(66,NULL,'f4988e6de5c64160a7cba363e4047720',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:36',NULL,'2025-11-28 10:00:36',NULL,NULL),(67,NULL,'553891aaf9f649f19a30645c7f28c510',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:36',NULL,'2025-11-28 10:00:36',NULL,NULL),(68,NULL,'8c69e96788ec4d79a9d8cd177bdb2175',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:37',NULL,'2025-11-28 10:00:37',NULL,NULL),(69,NULL,NULL,'b50f1018db0046e3b87d23258ec4ec8f',NULL,NULL,NULL,NULL,'2025-11-28 10:00:38',NULL,'2025-11-28 10:00:38',NULL,NULL),(70,NULL,'f138d3119eda462c8f3d5cc1879beeb6',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:38',NULL,'2025-11-28 10:00:38',NULL,NULL),(71,NULL,NULL,'9e5853d964bb42ff8490c05f28bba6e0',NULL,NULL,NULL,NULL,'2025-11-28 10:00:38',NULL,'2025-11-28 10:00:38',NULL,NULL),(72,NULL,NULL,'9fd050514ba34168b2fcf9c3f2ec38b1',NULL,NULL,NULL,NULL,'2025-11-28 10:00:39',NULL,'2025-11-28 10:00:39',NULL,NULL),(73,NULL,'c2eecb54daee43a1b96cab14bdfb1ccd',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:40',NULL,'2025-11-28 10:00:40',NULL,NULL),(74,NULL,'e759105895c542a0bccbe08b81ef5fde',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:40',NULL,'2025-11-28 10:00:40',NULL,NULL),(75,NULL,NULL,'ab5bf68a7d59460f81bb9d87f2669127',NULL,NULL,NULL,NULL,'2025-11-28 10:00:40',NULL,'2025-11-28 10:00:40',NULL,NULL),(76,NULL,NULL,'63f423bbc3a04685988641c9af6e9c95',NULL,NULL,NULL,NULL,'2025-11-28 10:00:41',NULL,'2025-11-28 10:00:41',NULL,NULL),(77,NULL,'ad10e3c8cce04ad8a199f4fc50ee11db',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:41',NULL,'2025-11-28 10:00:41',NULL,NULL),(78,NULL,NULL,'a042c1924c494f0ebccdc2ffb11230e8',NULL,NULL,NULL,NULL,'2025-11-28 10:00:42',NULL,'2025-11-28 10:00:42',NULL,NULL),(79,NULL,NULL,'f074a7a75d604e499e5b509fa77c056e',NULL,NULL,NULL,NULL,'2025-11-28 10:00:42',NULL,'2025-11-28 10:00:42',NULL,NULL),(80,NULL,NULL,'3c413995ea3e47ada56e7d02ddd5a62b',NULL,NULL,NULL,NULL,'2025-11-28 10:00:42',NULL,'2025-11-28 10:00:42',NULL,NULL),(81,NULL,NULL,'1de323f9fd77441aadde585c684fdf75',NULL,NULL,NULL,NULL,'2025-11-28 10:00:42',NULL,'2025-11-28 10:00:42',NULL,NULL),(82,NULL,'5d92ae911eec465ab808de5732bbecf3',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:42',NULL,'2025-11-28 10:00:42',NULL,NULL),(83,NULL,'deb7a3f0134f4f1e870fb7d7b7170c60',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:43',NULL,'2025-11-28 10:00:43',NULL,NULL),(84,NULL,NULL,'a781fe9273574b9e8d8266768d748025',NULL,NULL,NULL,NULL,'2025-11-28 10:00:44',NULL,'2025-11-28 10:00:44',NULL,NULL),(85,NULL,'3bc68b6081b5454a95979d04a3663f09',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:44',NULL,'2025-11-28 10:00:44',NULL,NULL),(86,NULL,NULL,'06957516976247d38f7b4b1c58033cab',NULL,NULL,NULL,NULL,'2025-11-28 10:00:44',NULL,'2025-11-28 10:00:44',NULL,NULL),(87,NULL,'7fe6789bcd44497ea6996532674448ff',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:44',NULL,'2025-11-28 10:00:44',NULL,NULL),(88,NULL,'7cad071f1d4942be8ab6ba740c6d6fe1',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:45',NULL,'2025-11-28 10:00:45',NULL,NULL),(89,NULL,NULL,'76abe76510a24863bea6625dfecacfc5',NULL,NULL,NULL,NULL,'2025-11-28 10:00:45',NULL,'2025-11-28 10:00:45',NULL,NULL),(90,NULL,'42939b867a274f78a2c69f378db22dca',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:45',NULL,'2025-11-28 10:00:45',NULL,NULL),(91,NULL,'9551b63c8bf64437b58b02bfebb382cf',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:46',NULL,'2025-11-28 10:00:46',NULL,NULL),(92,NULL,'4bcbe957eb104e228b60512e10ff9b5b',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:46',NULL,'2025-11-28 10:00:46',NULL,NULL),(93,NULL,'534e4cd2872d4e6181346dc703f760a0',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:47',NULL,'2025-11-28 10:00:47',NULL,NULL),(94,NULL,'e405ae4b9827452a9eb3f1e358344029',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:48',NULL,'2025-11-28 10:00:48',NULL,NULL),(95,NULL,NULL,'91c2589169654337afae308e308efda3',NULL,NULL,NULL,NULL,'2025-11-28 10:00:49',NULL,'2025-11-28 10:00:49',NULL,NULL),(96,NULL,NULL,'856862730e974197ad6c2d2b9a587d90',NULL,NULL,NULL,NULL,'2025-11-28 10:00:49',NULL,'2025-11-28 10:00:49',NULL,NULL),(97,NULL,NULL,'3987d608c9494f3ca3c1ff12f3f9ba05',NULL,NULL,NULL,NULL,'2025-11-28 10:00:50',NULL,'2025-11-28 10:00:50',NULL,NULL),(98,NULL,'d9b0890251a44b658129fb659f52601d',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:50',NULL,'2025-11-28 10:00:50',NULL,NULL),(99,NULL,'ce69f3fb57fd4425aeffafefa94b5996',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:51',NULL,'2025-11-28 10:00:51',NULL,NULL),(100,NULL,'ea3b22800a914cd8b03bcc997a21f172',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:51',NULL,'2025-11-28 10:00:51',NULL,NULL),(101,NULL,'dd038ff5322740abbde870ab86cad298',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:51',NULL,'2025-11-28 10:00:51',NULL,NULL),(102,NULL,NULL,'1a0b787341b84c3990ae014a08ab054b',NULL,NULL,NULL,NULL,'2025-11-28 10:00:52',NULL,'2025-11-28 10:00:52',NULL,NULL),(103,NULL,NULL,'2a7318aa496a4e53b0fc3b2257fc4ead',NULL,NULL,NULL,NULL,'2025-11-28 10:00:52',NULL,'2025-11-28 10:00:52',NULL,NULL),(104,NULL,'306fce93acb3431b8b751866749d1cd6',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:52',NULL,'2025-11-28 10:00:52',NULL,NULL),(105,NULL,NULL,'bc0f7f6434594b84b4ee4619d318fff5',NULL,NULL,NULL,NULL,'2025-11-28 10:00:52',NULL,'2025-11-28 10:00:52',NULL,NULL),(106,NULL,NULL,'d9cdd4876b0046c79d6b9f1caaf1ec55',NULL,NULL,NULL,NULL,'2025-11-28 10:00:52',NULL,'2025-11-28 10:00:52',NULL,NULL),(107,NULL,NULL,'67aa4e1531db4854a2788f0bbeaba314',NULL,NULL,NULL,NULL,'2025-11-28 10:00:54',NULL,'2025-11-28 10:00:54',NULL,NULL),(108,NULL,'478401a63ec543cdaad066198244e8d5',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:54',NULL,'2025-11-28 10:00:54',NULL,NULL),(109,NULL,NULL,'765055feb06b4d71aeb11500f5dc1b6f',NULL,NULL,NULL,NULL,'2025-11-28 10:00:54',NULL,'2025-11-28 10:00:54',NULL,NULL),(110,NULL,'cb48f5d02d9244d880dc8d7802e91a4b',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:54',NULL,'2025-11-28 10:00:54',NULL,NULL),(111,NULL,'d5bf6eddb14c429e9008c84d3db4a842',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:54',NULL,'2025-11-28 10:00:54',NULL,NULL),(112,NULL,NULL,'5027be676b0a4cc09171f4428e5365e1',NULL,NULL,NULL,NULL,'2025-11-28 10:00:54',NULL,'2025-11-28 10:00:54',NULL,NULL),(113,NULL,'40693e6dadaf448a8cb4caeb6899effc',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:54',NULL,'2025-11-28 10:00:54',NULL,NULL),(114,NULL,NULL,'5760cd83ff77483499114597e9d459cf',NULL,NULL,NULL,NULL,'2025-11-28 10:00:55',NULL,'2025-11-28 10:00:55',NULL,NULL),(115,NULL,'70708bb5afe040a2a9ac6c457472958c',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:55',NULL,'2025-11-28 10:00:55',NULL,NULL),(116,NULL,NULL,'97f37bc96e644c819473d9e512aee72b',NULL,NULL,NULL,NULL,'2025-11-28 10:00:55',NULL,'2025-11-28 10:00:55',NULL,NULL),(117,NULL,NULL,'2423236c29a548a3a39ebda9d9712626',NULL,NULL,NULL,NULL,'2025-11-28 10:00:55',NULL,'2025-11-28 10:00:55',NULL,NULL),(118,NULL,'0d3a1535faee4feaad18b47117cdaaff',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:55',NULL,'2025-11-28 10:00:55',NULL,NULL),(119,NULL,'32a5dc4aa4f147758fc879fe2f7b4bba',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:57',NULL,'2025-11-28 10:00:57',NULL,NULL),(120,NULL,'679c9be092a343b791c916779854e8aa',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:57',NULL,'2025-11-28 10:00:57',NULL,NULL),(121,NULL,'8d6eb2f3ab4b49c4808e7d7491133899',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:58',NULL,'2025-11-28 10:00:58',NULL,NULL),(122,NULL,NULL,'84bd12e63f534ab99b4214313a62a86a',NULL,NULL,NULL,NULL,'2025-11-28 10:00:58',NULL,'2025-11-28 10:00:58',NULL,NULL),(123,NULL,NULL,'a0cd7db9199c4943833833f7ac52a66b',NULL,NULL,NULL,NULL,'2025-11-28 10:00:58',NULL,'2025-11-28 10:00:58',NULL,NULL),(124,NULL,'bb4873534db74c0da4cb03869426658d',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:00:59',NULL,'2025-11-28 10:00:59',NULL,NULL),(125,NULL,'d0382aeb13484547a998b9d02420a2ed',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:00',NULL,'2025-11-28 10:01:00',NULL,NULL),(126,NULL,'54d4b66c89d444a8abad78ac85993252',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:01',NULL,'2025-11-28 10:01:01',NULL,NULL),(127,NULL,NULL,'b44ecc83800d4e1dbc157ec167b94ba7',NULL,NULL,NULL,NULL,'2025-11-28 10:01:03',NULL,'2025-11-28 10:01:03',NULL,NULL),(128,NULL,NULL,'b2a402eb5c3f4646901a32a5b8752034',NULL,NULL,NULL,NULL,'2025-11-28 10:01:03',NULL,'2025-11-28 10:01:03',NULL,NULL),(129,NULL,NULL,'d84da80ebefa499eb10eb03346f6ce22',NULL,NULL,NULL,NULL,'2025-11-28 10:01:04',NULL,'2025-11-28 10:01:04',NULL,NULL),(130,NULL,NULL,'fddb94296a404e0782ec9c5e19641d51',NULL,NULL,NULL,NULL,'2025-11-28 10:01:04',NULL,'2025-11-28 10:01:04',NULL,NULL),(131,NULL,NULL,'42aebd7d8c064ecda5e638f26bc00d9a',NULL,NULL,NULL,NULL,'2025-11-28 10:01:04',NULL,'2025-11-28 10:01:04',NULL,NULL),(132,NULL,NULL,'d6ae2e747864478f853b8804102840d3',NULL,NULL,NULL,NULL,'2025-11-28 10:01:05',NULL,'2025-11-28 10:01:05',NULL,NULL),(133,NULL,'a7d55520ed4143a2bfe5c3f21a44b94d',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:06',NULL,'2025-11-28 10:01:06',NULL,NULL),(134,NULL,'764645781859472598e1d078c9edea1a',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:06',NULL,'2025-11-28 10:01:06',NULL,NULL),(135,NULL,'64be4b3e093641dfb655227537fb6ba0',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:06',NULL,'2025-11-28 10:01:06',NULL,NULL),(136,NULL,NULL,'db0d2d91cc0a47ae8928acc007d73e6e',NULL,NULL,NULL,NULL,'2025-11-28 10:01:06',NULL,'2025-11-28 10:01:06',NULL,NULL),(137,NULL,'1d4f4589da37428d84c4b6d5f61959fa',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:07',NULL,'2025-11-28 10:01:07',NULL,NULL),(138,NULL,NULL,'f18b19f2b24e4b4789c8f67d513d0585',NULL,NULL,NULL,NULL,'2025-11-28 10:01:07',NULL,'2025-11-28 10:01:07',NULL,NULL),(139,NULL,'3e3ccf26c9934aa4a2821805cf8bf8d3',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:07',NULL,'2025-11-28 10:01:07',NULL,NULL),(140,NULL,NULL,'8a83eb0b4d304ec0b20d9c59d135f710',NULL,NULL,NULL,NULL,'2025-11-28 10:01:08',NULL,'2025-11-28 10:01:08',NULL,NULL),(141,NULL,'0c65f8372b4c42a19f25e3044c8d4f09',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:09',NULL,'2025-11-28 10:01:09',NULL,NULL),(142,NULL,'f91e460467be47309490831552febf3b',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:09',NULL,'2025-11-28 10:01:09',NULL,NULL),(143,NULL,NULL,'476bb2694f23485ebe2f9581560d92a5',NULL,NULL,NULL,NULL,'2025-11-28 10:01:09',NULL,'2025-11-28 10:01:09',NULL,NULL),(144,NULL,'1122aae03cf446bb91b3a3ba4d103228',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:10',NULL,'2025-11-28 10:01:10',NULL,NULL),(145,NULL,'09f0d51826274e64a495fbdd78dfb9b3',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:11',NULL,'2025-11-28 10:01:11',NULL,NULL),(146,NULL,'711fa96d60af4d44a78f78e79561a946',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:11',NULL,'2025-11-28 10:01:11',NULL,NULL),(147,NULL,NULL,'68dd4a0831a74185b0f8a833642c52ac',NULL,NULL,NULL,NULL,'2025-11-28 10:01:14',NULL,'2025-11-28 10:01:14',NULL,NULL),(148,NULL,NULL,'0000085425e8444d96884498a6a25058',NULL,NULL,NULL,NULL,'2025-11-28 10:01:14',NULL,'2025-11-28 10:01:14',NULL,NULL),(149,NULL,NULL,'d9e1ccabdd094a3999a0f165cb98a361',NULL,NULL,NULL,NULL,'2025-11-28 10:01:15',NULL,'2025-11-28 10:01:15',NULL,NULL),(150,NULL,NULL,'72f27d2cb28e44698bb04a3d51e19e8d',NULL,NULL,NULL,NULL,'2025-11-28 10:01:15',NULL,'2025-11-28 10:01:15',NULL,NULL),(151,NULL,NULL,'dec74413ea7d4d05a0ae1b78c1fca760',NULL,NULL,NULL,NULL,'2025-11-28 10:01:15',NULL,'2025-11-28 10:01:15',NULL,NULL),(152,NULL,NULL,'72f27d2cb28e44698bb04a3d51e19e8d',NULL,NULL,NULL,NULL,'2025-11-28 10:01:15',NULL,'2025-11-28 10:01:15',NULL,NULL),(153,NULL,NULL,'b399a6a803a145be89797a7f4be7cd41',NULL,NULL,NULL,NULL,'2025-11-28 10:01:15',NULL,'2025-11-28 10:01:15',NULL,NULL),(154,NULL,NULL,'d9e1ccabdd094a3999a0f165cb98a361',NULL,NULL,NULL,NULL,'2025-11-28 10:01:15',NULL,'2025-11-28 10:01:15',NULL,NULL),(155,NULL,NULL,'0000085425e8444d96884498a6a25058',NULL,NULL,NULL,NULL,'2025-11-28 10:01:15',NULL,'2025-11-28 10:01:15',NULL,NULL),(156,NULL,'5bffc4853cf2492a9e9b74271c7edd6b',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:15',NULL,'2025-11-28 10:01:15',NULL,NULL),(157,NULL,NULL,'65a3555905544cd188402a46270b7977',NULL,NULL,NULL,NULL,'2025-11-28 10:01:16',NULL,'2025-11-28 10:01:16',NULL,NULL),(158,NULL,NULL,'1699b2b9385441efb0c5b0330882baea',NULL,NULL,NULL,NULL,'2025-11-28 10:01:16',NULL,'2025-11-28 10:01:16',NULL,NULL),(159,NULL,'96401a254609402db2c8811359ed2f04',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:16',NULL,'2025-11-28 10:01:16',NULL,NULL),(160,NULL,'97c8b2b812a840b1bd8269ae6de961d3',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:18',NULL,'2025-11-28 10:01:18',NULL,NULL),(161,NULL,NULL,'bc2305a82562401ba0cf9b6f54b8fdf2',NULL,NULL,NULL,NULL,'2025-11-28 10:01:18',NULL,'2025-11-28 10:01:18',NULL,NULL),(162,NULL,'f71cdc9e1fa0438caa567580cee0335d',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:18',NULL,'2025-11-28 10:01:18',NULL,NULL),(163,NULL,NULL,'49ad23b3d7b04be5be63dcf89b624671',NULL,NULL,NULL,NULL,'2025-11-28 10:01:18',NULL,'2025-11-28 10:01:18',NULL,NULL),(164,NULL,NULL,'fafa8a04f22f48768f84d2988e7691b9',NULL,NULL,NULL,NULL,'2025-11-28 10:01:18',NULL,'2025-11-28 10:01:18',NULL,NULL),(165,NULL,'54c4aae5935144dcae2936bbd68d93af',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:19',NULL,'2025-11-28 10:01:19',NULL,NULL),(166,NULL,NULL,'15f26e6f9d374af28caee62c2def82a7',NULL,NULL,NULL,NULL,'2025-11-28 10:01:20',NULL,'2025-11-28 10:01:20',NULL,NULL),(167,NULL,'d84cd734f6eb4be6a50c52bc176c197a',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:20',NULL,'2025-11-28 10:01:20',NULL,NULL),(168,NULL,NULL,'1e2bf0818e5846ee9164ee50d33634db',NULL,NULL,NULL,NULL,'2025-11-28 10:01:20',NULL,'2025-11-28 10:01:20',NULL,NULL),(169,NULL,'ea70898bb8114d1597c81e56f87846b9',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:22',NULL,'2025-11-28 10:01:22',NULL,NULL),(170,NULL,'32333e43bf30436880a578ccf3b19a63',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:23',NULL,'2025-11-28 10:01:23',NULL,NULL),(171,NULL,NULL,'ec6633629837476999858beb4d812c6e',NULL,NULL,NULL,NULL,'2025-11-28 10:01:23',NULL,'2025-11-28 10:01:23',NULL,NULL),(172,NULL,'13916998509948489e1eca7ea6622abe',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:23',NULL,'2025-11-28 10:01:23',NULL,NULL),(173,NULL,NULL,'08fa5dc8c4e342ce93df3cdd74c82e80',NULL,NULL,NULL,NULL,'2025-11-28 10:01:23',NULL,'2025-11-28 10:01:23',NULL,NULL),(174,NULL,'7fa32c5398f247d48d69298cc9e9328b',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:24',NULL,'2025-11-28 10:01:24',NULL,NULL),(175,NULL,'ff1e6903b51e4f2f9cd2a1bfe7f938e8',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:25',NULL,'2025-11-28 10:01:25',NULL,NULL),(176,NULL,'e0d19aca5bf54add8422bb702d254c37',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:26',NULL,'2025-11-28 10:01:26',NULL,NULL),(177,NULL,'cd77281d07fc4c6fa54a785758a84326',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:26',NULL,'2025-11-28 10:01:26',NULL,NULL),(178,NULL,'c6ca85c714574fbfbe048a92672759c5',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:26',NULL,'2025-11-28 10:01:26',NULL,NULL),(179,NULL,NULL,'fdd7edcd6abb48cd8db675413cb52781',NULL,NULL,NULL,NULL,'2025-11-28 10:01:26',NULL,'2025-11-28 10:01:26',NULL,NULL),(180,NULL,NULL,'f8b5672d25324ff383e4bc31f3c2cf96',NULL,NULL,NULL,NULL,'2025-11-28 10:01:26',NULL,'2025-11-28 10:01:26',NULL,NULL),(181,NULL,NULL,'c64867c2bac34a819c0995d0b72ee9a7',NULL,NULL,NULL,NULL,'2025-11-28 10:01:27',NULL,'2025-11-28 10:01:27',NULL,NULL),(182,NULL,NULL,'b663adc3c1ab4012828d493e2b3ebb79',NULL,NULL,NULL,NULL,'2025-11-28 10:01:27',NULL,'2025-11-28 10:01:27',NULL,NULL),(183,NULL,NULL,'2feb3642803c457899809089d674a293',NULL,NULL,NULL,NULL,'2025-11-28 10:01:27',NULL,'2025-11-28 10:01:27',NULL,NULL),(184,NULL,'8af52db5e461483db346cf9b7e812179',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:27',NULL,'2025-11-28 10:01:27',NULL,NULL),(185,NULL,'3e4b394501d24dc7954ec5d2f27b8081',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:27',NULL,'2025-11-28 10:01:27',NULL,NULL),(186,NULL,'e689ac1ee8ad4c48a85f68f7dbe377c5',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:28',NULL,'2025-11-28 10:01:28',NULL,NULL),(187,NULL,NULL,'8d5d553b1d904cd39daae9e8588982c6',NULL,NULL,NULL,NULL,'2025-11-28 10:01:29',NULL,'2025-11-28 10:01:29',NULL,NULL),(188,NULL,'6dce7e95fa0443beb41563da37907095',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:29',NULL,'2025-11-28 10:01:29',NULL,NULL),(189,NULL,NULL,'91b802e4ced9493f8111aecaa2e9fa12',NULL,NULL,NULL,NULL,'2025-11-28 10:01:29',NULL,'2025-11-28 10:01:29',NULL,NULL),(190,NULL,'2159235bf1c5407eac7a3e3826561913',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:30',NULL,'2025-11-28 10:01:30',NULL,NULL),(191,NULL,'8fb9ca02cefd4ee8b109ce4336bbf55b',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:31',NULL,'2025-11-28 10:01:31',NULL,NULL),(192,NULL,'49433d201a314885ab86b2ea203f43d5',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:31',NULL,'2025-11-28 10:01:31',NULL,NULL),(193,NULL,NULL,'c522343c0f7c46d3b836684e621604f7',NULL,NULL,NULL,NULL,'2025-11-28 10:01:32',NULL,'2025-11-28 10:01:32',NULL,NULL),(194,NULL,NULL,'dd3866c36e8346eb951eec0eb0b1fcb6',NULL,NULL,NULL,NULL,'2025-11-28 10:01:32',NULL,'2025-11-28 10:01:32',NULL,NULL),(195,NULL,'a957e80650af478da4cea70625a2b7f9',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:32',NULL,'2025-11-28 10:01:32',NULL,NULL),(196,NULL,NULL,'3e2f994174234b61af8aba9ad097dc41',NULL,NULL,NULL,NULL,'2025-11-28 10:01:33',NULL,'2025-11-28 10:01:33',NULL,NULL),(197,NULL,'b1bad028ae0241beb2ac2ad53bb51cbc',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:33',NULL,'2025-11-28 10:01:33',NULL,NULL),(198,NULL,'a3aca1179e8946c7a334ebe576446b4c',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:33',NULL,'2025-11-28 10:01:33',NULL,NULL),(199,NULL,'e5b90e86fa41442c971fe7379ebb33da',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:34',NULL,'2025-11-28 10:01:34',NULL,NULL),(200,NULL,NULL,'9c8dbf79032e456c8754b878f4736653',NULL,NULL,NULL,NULL,'2025-11-28 10:01:36',NULL,'2025-11-28 10:01:36',NULL,NULL),(201,NULL,NULL,'47a392d7f81d4855a296b21b1f13b89a',NULL,NULL,NULL,NULL,'2025-11-28 10:01:37',NULL,'2025-11-28 10:01:37',NULL,NULL),(202,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:38',NULL,'2025-11-28 10:01:38','7TvkW6jZQoaov0qXgew7jw',NULL),(203,NULL,NULL,'f785c62cd2b843a2a4c327e200a35d71',NULL,NULL,NULL,NULL,'2025-11-28 10:01:38',NULL,'2025-11-28 10:01:38',NULL,NULL),(204,NULL,NULL,'237656f73b7642459720c3b28ab955d1',NULL,NULL,NULL,NULL,'2025-11-28 10:01:38',NULL,'2025-11-28 10:01:38',NULL,NULL),(205,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:38',NULL,'2025-11-28 10:01:38','nCsnP6xARnmIH3GTilcPDg',NULL),(206,NULL,NULL,'a99bd80f96ae4d2dbda415db310200de',NULL,NULL,NULL,NULL,'2025-11-28 10:01:38',NULL,'2025-11-28 10:01:38',NULL,NULL),(207,NULL,NULL,'58ac05943c1d4a48b661bfe9e2e8dc85',NULL,NULL,NULL,NULL,'2025-11-28 10:01:38',NULL,'2025-11-28 10:01:38',NULL,NULL),(208,NULL,'c1344acd25134db581a16560bc736fed',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:38',NULL,'2025-11-28 10:01:38',NULL,NULL),(209,NULL,NULL,'ba3193b0e364461781d4ef596fb2df7b',NULL,NULL,NULL,NULL,'2025-11-28 10:01:44',NULL,'2025-11-28 10:01:44',NULL,NULL),(210,NULL,'668c877da7094670ad0b61fb97036770',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:44',NULL,'2025-11-28 10:01:44',NULL,NULL),(211,NULL,'374d68184d7e48af92907d644aa4245d',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:44',NULL,'2025-11-28 10:01:44',NULL,NULL),(212,NULL,'8e5737432c54465db716819e632a0d25',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:44',NULL,'2025-11-28 10:01:44',NULL,NULL),(213,NULL,'4df3f444fbc54fea8e5a25c8af46877e',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:46',NULL,'2025-11-28 10:01:46',NULL,NULL),(214,NULL,'a9c643f526d74db5aa94fed5415f35fc',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:46',NULL,'2025-11-28 10:01:46',NULL,NULL),(215,NULL,'1177308bb71e4993b9f474c7fa8ac6be',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:46',NULL,'2025-11-28 10:01:46',NULL,NULL),(216,NULL,NULL,'d34a31d12c2e4d9988e5c78aa7f26e03',NULL,NULL,NULL,NULL,'2025-11-28 10:01:46',NULL,'2025-11-28 10:01:46',NULL,NULL),(217,NULL,NULL,'d6b4e15bcfed455db2ca4619a5b706a6',NULL,NULL,NULL,NULL,'2025-11-28 10:01:47',NULL,'2025-11-28 10:01:47',NULL,NULL),(218,NULL,'6ad5cc945c4a4ceda603318537f79333',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:48',NULL,'2025-11-28 10:01:48',NULL,NULL),(219,NULL,NULL,'cda7a3d511f246669fb715e3e7fa404e',NULL,NULL,NULL,NULL,'2025-11-28 10:01:49',NULL,'2025-11-28 10:01:49',NULL,NULL),(220,NULL,NULL,'ec7b8bc4d818469caaf0274eb0bc7385',NULL,NULL,NULL,NULL,'2025-11-28 10:01:50',NULL,'2025-11-28 10:01:50',NULL,NULL),(221,NULL,'9fff11cc9f2447d398ce8f751d98fcfd',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:50',NULL,'2025-11-28 10:01:50',NULL,NULL),(222,NULL,NULL,'c03da89e79fe45dfa99798c30a68f936',NULL,NULL,NULL,NULL,'2025-11-28 10:01:50',NULL,'2025-11-28 10:01:50',NULL,NULL),(223,NULL,NULL,'bfbc7a0c4918417297fce54f801f016c',NULL,NULL,NULL,NULL,'2025-11-28 10:01:51',NULL,'2025-11-28 10:01:51',NULL,NULL),(224,NULL,'5d17afd93a1944699b4df1caf16b3220',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:52',NULL,'2025-11-28 10:01:52',NULL,NULL),(225,NULL,NULL,'db049420298e41008c2b77991fb6ac55',NULL,NULL,NULL,NULL,'2025-11-28 10:01:52',NULL,'2025-11-28 10:01:52',NULL,NULL),(226,NULL,'de42e158be5541f4a75b3aa3a1418afe',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:52',NULL,'2025-11-28 10:01:52',NULL,NULL),(227,NULL,'d9a7d3bab45c448493e88305bc47cbdb',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:52',NULL,'2025-11-28 10:01:52',NULL,NULL),(228,NULL,NULL,'0d4b5399e0804796b66f509f6e6daa20',NULL,NULL,NULL,NULL,'2025-11-28 10:01:52',NULL,'2025-11-28 10:01:52',NULL,NULL),(229,NULL,'3c2a3ea68e914972b6c5766dd7b9ca0a',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:53',NULL,'2025-11-28 10:01:53',NULL,NULL),(230,NULL,'5743247e53194d00906cff46fbcc0b0f',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:55',NULL,'2025-11-28 10:01:55',NULL,NULL),(231,NULL,NULL,'5d9c5a43ceb04f0cb11dc889f6f83679',NULL,NULL,NULL,NULL,'2025-11-28 10:01:56',NULL,'2025-11-28 10:01:56',NULL,NULL),(232,NULL,NULL,'ed05c4d0a3394e61b28755e1bad4059e',NULL,NULL,NULL,NULL,'2025-11-28 10:01:57',NULL,'2025-11-28 10:01:57',NULL,NULL),(233,NULL,NULL,'13307968b6dc43169a07a6934374c7b1',NULL,NULL,NULL,NULL,'2025-11-28 10:01:57',NULL,'2025-11-28 10:01:57',NULL,NULL),(234,NULL,NULL,'0e0ef75943874826b102766defe7cc10',NULL,NULL,NULL,NULL,'2025-11-28 10:01:57',NULL,'2025-11-28 10:01:57',NULL,NULL),(235,NULL,'d5f53552bd5f4f95bc99d03be473fbd3',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:58',NULL,'2025-11-28 10:01:58',NULL,NULL),(236,NULL,NULL,'d3918eb64cda4b28b5de23c49272c2fe',NULL,NULL,NULL,NULL,'2025-11-28 10:01:59',NULL,'2025-11-28 10:01:59',NULL,NULL),(237,NULL,NULL,'d495dba9d4694a6e8c9ec6d27e525aee',NULL,NULL,NULL,NULL,'2025-11-28 10:01:59',NULL,'2025-11-28 10:01:59',NULL,NULL),(238,NULL,'3d42eab459154c02821d5de680e85879',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:59',NULL,'2025-11-28 10:01:59',NULL,NULL),(239,NULL,'5a8a2b97ed5648f194d2acd94eea59a2',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:01:59',NULL,'2025-11-28 10:01:59',NULL,NULL),(240,NULL,'d999670518ce49678c721c61dc8bce48',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:00',NULL,'2025-11-28 10:02:00',NULL,NULL),(241,NULL,'5be951bf1514422aab50184945d641e3',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:00',NULL,'2025-11-28 10:02:00',NULL,NULL),(242,NULL,'2da6dcc004c84e799d02c47025881e63',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:02',NULL,'2025-11-28 10:02:02',NULL,NULL),(243,NULL,NULL,'ae70be6855054c3487f0094d9de2da41',NULL,NULL,NULL,NULL,'2025-11-28 10:02:04',NULL,'2025-11-28 10:02:04',NULL,NULL),(244,NULL,NULL,'ca247ee3a98a4676a007b385c9bac267',NULL,NULL,NULL,NULL,'2025-11-28 10:02:04',NULL,'2025-11-28 10:02:04',NULL,NULL),(245,NULL,NULL,'9988041c58cd4e10b75d018bfbd9619c',NULL,NULL,NULL,NULL,'2025-11-28 10:02:04',NULL,'2025-11-28 10:02:04',NULL,NULL),(246,NULL,NULL,'f8f043f1c19843179bcd51a135b21681',NULL,NULL,NULL,NULL,'2025-11-28 10:02:04',NULL,'2025-11-28 10:02:04',NULL,NULL),(247,NULL,NULL,'e620f114cef649f5974d61d1919b9cee',NULL,NULL,NULL,NULL,'2025-11-28 10:02:04',NULL,'2025-11-28 10:02:04',NULL,NULL),(248,NULL,NULL,'235211f50ec44d9aae712f3139ddc2ad',NULL,NULL,NULL,NULL,'2025-11-28 10:02:05',NULL,'2025-11-28 10:02:05',NULL,NULL),(249,NULL,'093ac952423e4ab794e138b0b4f337c4',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:06',NULL,'2025-11-28 10:02:06',NULL,NULL),(250,NULL,'c26fc81d00de40b4a639eb8d3402b1da',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:06',NULL,'2025-11-28 10:02:06',NULL,NULL),(251,NULL,'03aa7615d2d349368b842cc081557686',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:06',NULL,'2025-11-28 10:02:06',NULL,NULL),(252,NULL,NULL,'76caaf04f9e5427ca10e0bb020dbffa2',NULL,NULL,NULL,NULL,'2025-11-28 10:02:07',NULL,'2025-11-28 10:02:07',NULL,NULL),(253,NULL,'b611dab50b584c4a94abf0a2f5b38b77',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:07',NULL,'2025-11-28 10:02:07',NULL,NULL),(254,NULL,'0ef8c79f4c8e43e9b63d13352ae1a5c3',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:08',NULL,'2025-11-28 10:02:08',NULL,NULL),(255,NULL,'feb670babb684e57b1bd5b69be19c112',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:08',NULL,'2025-11-28 10:02:08',NULL,NULL),(256,NULL,'6fec370fed684ed6ba04de00336f61ee',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:08',NULL,'2025-11-28 10:02:08',NULL,NULL),(257,NULL,NULL,'9644d4520ce149188df6029d2ccae6e9',NULL,NULL,NULL,NULL,'2025-11-28 10:02:11',NULL,'2025-11-28 10:02:11',NULL,NULL),(258,NULL,'7b468a02cba84737a61aeefa79719c70',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:12',NULL,'2025-11-28 10:02:12',NULL,NULL),(259,NULL,NULL,'4bee1a1c37364a5aa0681dac40615360',NULL,NULL,NULL,NULL,'2025-11-28 10:02:12',NULL,'2025-11-28 10:02:12',NULL,NULL),(260,NULL,NULL,'4126f23a09c544ff82326c51c730fd2b',NULL,NULL,NULL,NULL,'2025-11-28 10:02:12',NULL,'2025-11-28 10:02:12',NULL,NULL),(261,NULL,'fcddaf52e239480889f64094bdf0a00f',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:12',NULL,'2025-11-28 10:02:12',NULL,NULL),(262,NULL,NULL,'e174bc0991b24ad88274ba12db6ba9df',NULL,NULL,NULL,NULL,'2025-11-28 10:02:12',NULL,'2025-11-28 10:02:12',NULL,NULL),(263,NULL,NULL,'2cb6ac11b7774b6f9f1e66683854eed8',NULL,NULL,NULL,NULL,'2025-11-28 10:02:12',NULL,'2025-11-28 10:02:12',NULL,NULL),(264,NULL,NULL,'318114281cb649bc9eeed12ecdc7273f',NULL,NULL,NULL,NULL,'2025-11-28 10:02:13',NULL,'2025-11-28 10:02:13',NULL,NULL),(265,NULL,NULL,'13de913d83d648919edb1da3601d106c',NULL,NULL,NULL,NULL,'2025-11-28 10:02:13',NULL,'2025-11-28 10:02:13',NULL,NULL),(266,NULL,'b29147196d564e3996265274c8bc69bd',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:13',NULL,'2025-11-28 10:02:13',NULL,NULL),(267,NULL,'02cc81c72fe1463f82dd83f0c77a6f8a',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:14',NULL,'2025-11-28 10:02:14',NULL,NULL),(268,NULL,'f1bee3918a2345388c202f74e60af9c5',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:14',NULL,'2025-11-28 10:02:14',NULL,NULL),(269,NULL,'7f5e952171f74ef28ead35d870c29d2b',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:15',NULL,'2025-11-28 10:02:15',NULL,NULL),(270,NULL,NULL,'1c88685db35b4069b2d1221b9538d555',NULL,NULL,NULL,NULL,'2025-11-28 10:02:15',NULL,'2025-11-28 10:02:15',NULL,NULL),(271,NULL,'2ac2634ea5b64c14b35c4ce38a4dd602',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:15',NULL,'2025-11-28 10:02:15',NULL,NULL),(272,NULL,'310745a04bd441169ff77f55ccf6bd7b',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:15',NULL,'2025-11-28 10:02:15',NULL,NULL),(273,NULL,NULL,'edc5500bc6c543f5a0262575594b839c',NULL,NULL,NULL,NULL,'2025-11-28 10:02:15',NULL,'2025-11-28 10:02:15',NULL,NULL),(274,NULL,'2cb7873bc84d4f9ebf79debe02366e2f',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:15',NULL,'2025-11-28 10:02:15',NULL,NULL),(275,NULL,NULL,'f8e165c9106c41a08c7d28ccc2503d86',NULL,NULL,NULL,NULL,'2025-11-28 10:02:15',NULL,'2025-11-28 10:02:15',NULL,NULL),(276,NULL,'b9d5d0d5dc28445f854288051977b3d1',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:15',NULL,'2025-11-28 10:02:15',NULL,NULL),(277,NULL,'5b62cec87ec84f1fad9bb66a2474f513',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:17',NULL,'2025-11-28 10:02:17',NULL,NULL),(278,NULL,'f26858e957ce4f2f82e45a8738c2e462',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:18',NULL,'2025-11-28 10:02:18',NULL,NULL),(279,NULL,NULL,'4e120e1478e74f9c9c8be96f9fcbaf3e',NULL,NULL,NULL,NULL,'2025-11-28 10:02:19',NULL,'2025-11-28 10:02:19',NULL,NULL),(280,NULL,'1559fb44e5a84bffbfe84e08a95f37b6',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:19',NULL,'2025-11-28 10:02:19',NULL,NULL),(281,NULL,NULL,'633b29dc264444cdae411eb53e3fd50a',NULL,NULL,NULL,NULL,'2025-11-28 10:02:19',NULL,'2025-11-28 10:02:19',NULL,NULL),(282,NULL,NULL,'5d518df30d354c3b9386168ca8dfb27d',NULL,NULL,NULL,NULL,'2025-11-28 10:02:19',NULL,'2025-11-28 10:02:19',NULL,NULL),(283,NULL,'267c20cf6b8b48db9cf7afea8b376a3d',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:19',NULL,'2025-11-28 10:02:19',NULL,NULL),(284,NULL,'7975bb5ab599416ca283be55dbc997cd',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:20',NULL,'2025-11-28 10:02:20',NULL,NULL),(285,NULL,'2b27ebd8697c407a92775a9f99ed9984',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:20',NULL,'2025-11-28 10:02:20',NULL,NULL),(286,NULL,NULL,'26c983d4f94a4071b528366d5a5fa20f',NULL,NULL,NULL,NULL,'2025-11-28 10:02:20',NULL,'2025-11-28 10:02:20',NULL,NULL),(287,NULL,'57b6746a683c4010a538201ecaf34081',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:20',NULL,'2025-11-28 10:02:20',NULL,NULL),(288,NULL,NULL,'3360ea071a2045a483778667e877984c',NULL,NULL,NULL,NULL,'2025-11-28 10:02:20',NULL,'2025-11-28 10:02:20',NULL,NULL),(289,NULL,'687b6d0e819646abb22cfe0e2c527511',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:20',NULL,'2025-11-28 10:02:20',NULL,NULL),(290,NULL,'160f189bb6c34f32b24924a1fbbbe8c3',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:21',NULL,'2025-11-28 10:02:21',NULL,NULL),(291,NULL,'ebdfbc832b0c4fafab54b789c0841acd',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:21',NULL,'2025-11-28 10:02:21',NULL,NULL),(292,NULL,'bf0754e21e6a4f9b985bac13489bdd31',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:21',NULL,'2025-11-28 10:02:21',NULL,NULL),(293,NULL,'df3f5677264a4b6c845de8719cac3a82',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:21',NULL,'2025-11-28 10:02:21',NULL,NULL),(294,NULL,NULL,'ce27c6073d444160a71b96f4a5c703da',NULL,NULL,NULL,NULL,'2025-11-28 10:02:22',NULL,'2025-11-28 10:02:22',NULL,NULL),(295,NULL,'a2fd0ae23cf44bdcadd7e51a9a43616b',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:22',NULL,'2025-11-28 10:02:22',NULL,NULL),(296,NULL,NULL,'9a29cff1d10f429cb5548203e6f3f6da',NULL,NULL,NULL,NULL,'2025-11-28 10:02:22',NULL,'2025-11-28 10:02:22',NULL,NULL),(297,NULL,'cec5f8be37194414b674b1ee633e8f75',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:22',NULL,'2025-11-28 10:02:22',NULL,NULL),(298,NULL,NULL,'22acadd619894658963be66e4d5b1560',NULL,NULL,NULL,NULL,'2025-11-28 10:02:22',NULL,'2025-11-28 10:02:22',NULL,NULL),(299,NULL,NULL,'4382637b74a94d6993c5546990ecaa05',NULL,NULL,NULL,NULL,'2025-11-28 10:02:22',NULL,'2025-11-28 10:02:22',NULL,NULL),(300,NULL,'24246c15206b45eb8fd4541fdba99381',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:22',NULL,'2025-11-28 10:02:22',NULL,NULL),(301,NULL,'3c32f1fa6a7943799490425bb6894924',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:23',NULL,'2025-11-28 10:02:23',NULL,NULL),(302,NULL,'c9ed55c4a9e14a0690cd2df5b29638ef',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:23',NULL,'2025-11-28 10:02:23',NULL,NULL),(303,NULL,'754ced97d33c4b9f84e6309918daf176',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:23',NULL,'2025-11-28 10:02:23',NULL,NULL),(304,NULL,'50f633f21a23431199a2ef69dba5bc2b',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:23',NULL,'2025-11-28 10:02:23',NULL,NULL),(305,NULL,'c392ec6560a84f50922b02c7cea46dbf',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:24',NULL,'2025-11-28 10:02:24',NULL,NULL),(306,NULL,'f835da1d00254812856d9e82d0738495',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:24',NULL,'2025-11-28 10:02:24',NULL,NULL),(307,NULL,'5bbbbcc8dc624f5182ff167e47427b9e',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:24',NULL,'2025-11-28 10:02:24',NULL,NULL),(308,NULL,'cc289324ce1c418e906163fb29e51ece',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:24',NULL,'2025-11-28 10:02:24',NULL,NULL),(309,NULL,NULL,'119c7cee07924ce1923c45cfcd201295',NULL,NULL,NULL,NULL,'2025-11-28 10:02:25',NULL,'2025-11-28 10:02:25',NULL,NULL),(310,NULL,NULL,'71bb50bba7f64fafad580e836e0a7c1e',NULL,NULL,NULL,NULL,'2025-11-28 10:02:25',NULL,'2025-11-28 10:02:25',NULL,NULL),(311,NULL,NULL,'d8216ef1ebb244d1bf85d201f1bbfc20',NULL,NULL,NULL,NULL,'2025-11-28 10:02:26',NULL,'2025-11-28 10:02:26',NULL,NULL),(312,NULL,NULL,'28578129c91d407a92af609ba8bac430',NULL,NULL,NULL,NULL,'2025-11-28 10:02:26',NULL,'2025-11-28 10:02:26',NULL,NULL),(313,NULL,NULL,'734ca2d323084815a7ec954d4e95f7c1',NULL,NULL,NULL,NULL,'2025-11-28 10:02:26',NULL,'2025-11-28 10:02:26',NULL,NULL),(314,NULL,'3b15b9c21c3c481c8647792ec7ab9079',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:27',NULL,'2025-11-28 10:02:27',NULL,NULL),(315,NULL,'1ae3296419584d9faa4d39f3b1b93d88',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:27',NULL,'2025-11-28 10:02:27',NULL,NULL),(316,NULL,'947308d7b9604364afc22c80dc9659a3',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:28',NULL,'2025-11-28 10:02:28',NULL,NULL),(317,NULL,'cee9624834b94e80a7bbe35b2f1a1739',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:28',NULL,'2025-11-28 10:02:28',NULL,NULL),(318,NULL,'a30386ba68ee46f4a1bac43cf415f3a4',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:29',NULL,'2025-11-28 10:02:29',NULL,NULL),(319,NULL,NULL,'0cf4f9445b574074ad82c36370db3c34',NULL,NULL,NULL,NULL,'2025-11-28 10:02:30',NULL,'2025-11-28 10:02:30',NULL,NULL),(320,NULL,NULL,'f07f45cfcff54d0ebaf2baa44164993c',NULL,NULL,NULL,NULL,'2025-11-28 10:02:31',NULL,'2025-11-28 10:02:31',NULL,NULL),(321,NULL,NULL,'e1998ba82ff742ef89b85ada5cb0f924',NULL,NULL,NULL,NULL,'2025-11-28 10:02:31',NULL,'2025-11-28 10:02:31',NULL,NULL),(322,NULL,'589ca40d457a4d02b0ce4abbe44c27c9',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:31',NULL,'2025-11-28 10:02:31',NULL,NULL),(323,NULL,'c9e5a1174cf24425a47c1bada232821d',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:32',NULL,'2025-11-28 10:02:32',NULL,NULL),(324,NULL,NULL,'fb142b33672b4fe480a1d726ee5fa706',NULL,NULL,NULL,NULL,'2025-11-28 10:02:32',NULL,'2025-11-28 10:02:32',NULL,NULL),(325,NULL,'9ee1e31c4d0e4865a79b676fa472bf1e',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:33',NULL,'2025-11-28 10:02:33',NULL,NULL),(326,NULL,NULL,'3eeb203096704f51913ad630533b54eb',NULL,NULL,NULL,NULL,'2025-11-28 10:02:33',NULL,'2025-11-28 10:02:33',NULL,NULL),(327,NULL,'247ed00f7c5b491bae368cbfb1c6129c',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:34',NULL,'2025-11-28 10:02:34',NULL,NULL),(328,NULL,'9188b51067884ca28af5e31f65904796',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:35',NULL,'2025-11-28 10:02:35',NULL,NULL),(329,NULL,'70100da7c35243709364707d7f51d724',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:35',NULL,'2025-11-28 10:02:35',NULL,NULL),(330,NULL,NULL,'f4266c4d6e8142128c9a0cdab6b58720',NULL,NULL,NULL,NULL,'2025-11-28 10:02:36',NULL,'2025-11-28 10:02:36',NULL,NULL),(331,NULL,NULL,'93403268f8df4b7294c42b2f38874ba6',NULL,NULL,NULL,NULL,'2025-11-28 10:02:37',NULL,'2025-11-28 10:02:37',NULL,NULL),(332,NULL,NULL,'3a7da69e8602424ca2135ec87a387a22',NULL,NULL,NULL,NULL,'2025-11-28 10:02:37',NULL,'2025-11-28 10:02:37',NULL,NULL),(333,NULL,'525f33a37e304a8c8db574c71dac6634',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:38',NULL,'2025-11-28 10:02:38',NULL,NULL),(334,NULL,'9e8e81745038438dbed4037518b183b9',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:38',NULL,'2025-11-28 10:02:38',NULL,NULL),(335,NULL,'8f730ac88fa6413e8715ec8355f72384',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:39',NULL,'2025-11-28 10:02:39',NULL,NULL),(336,NULL,NULL,'c8f1b9a7e79b49e88182fe235684ac7b',NULL,NULL,NULL,NULL,'2025-11-28 10:02:39',NULL,'2025-11-28 10:02:39',NULL,NULL),(337,NULL,'c2c0c1e4c01948dd97a9140ab841c494',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:40',NULL,'2025-11-28 10:02:40',NULL,NULL),(338,NULL,'f7e04d95538d47f382a1ef584270618b',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:41',NULL,'2025-11-28 10:02:41',NULL,NULL),(339,NULL,NULL,'c8f1b9a7e79b49e88182fe235684ac7b',NULL,NULL,NULL,NULL,'2025-11-28 10:02:41',NULL,'2025-11-28 10:02:41',NULL,NULL),(340,NULL,'ad9601c8935f4e6787adc6f28a6262a4',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:42',NULL,'2025-11-28 10:02:42',NULL,NULL),(341,NULL,NULL,'b07702d0d9b14309a6ff4824e4fac875',NULL,NULL,NULL,NULL,'2025-11-28 10:02:42',NULL,'2025-11-28 10:02:42',NULL,NULL),(342,NULL,'56bf46a9f4964d1280f39b178b2d4e51',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:42',NULL,'2025-11-28 10:02:42',NULL,NULL),(343,NULL,NULL,'c8233ed2616445f08e46761fd7c3c778',NULL,NULL,NULL,NULL,'2025-11-28 10:02:44',NULL,'2025-11-28 10:02:44',NULL,NULL),(344,NULL,NULL,'2543a272951846bca5343aa2c54c498d',NULL,NULL,NULL,NULL,'2025-11-28 10:02:44',NULL,'2025-11-28 10:02:44',NULL,NULL),(345,NULL,'e1847d10753a4aa190c218096ab5b477',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:44',NULL,'2025-11-28 10:02:44',NULL,NULL),(346,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:44',NULL,'2025-11-28 10:02:44','5nW8wGvXSY-5DxRST76x6g',NULL),(347,NULL,'183452c0e1f84b88b4d443957c99d8be',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:45',NULL,'2025-11-28 10:02:45',NULL,NULL),(348,NULL,'da9ad3c33cb74e60b29799ad3c9aab5b',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:45',NULL,'2025-11-28 10:02:45',NULL,NULL),(349,NULL,NULL,'2613803f959a4e8c8459d636b050372a',NULL,NULL,NULL,NULL,'2025-11-28 10:02:45',NULL,'2025-11-28 10:02:45',NULL,NULL),(350,NULL,NULL,'d2eb3b9f32f847c393de516329d44744',NULL,NULL,NULL,NULL,'2025-11-28 10:02:45',NULL,'2025-11-28 10:02:45',NULL,NULL),(351,NULL,'0836cdc7f02041f5b96187777f3a90dd',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:45',NULL,'2025-11-28 10:02:45',NULL,NULL),(352,NULL,NULL,'0ac7465c9cf041b2b181d58b1214c905',NULL,NULL,NULL,NULL,'2025-11-28 10:02:46',NULL,'2025-11-28 10:02:46',NULL,NULL),(353,NULL,NULL,'c8f1b9a7e79b49e88182fe235684ac7b',NULL,NULL,NULL,NULL,'2025-11-28 10:02:46',NULL,'2025-11-28 10:02:46',NULL,NULL),(354,NULL,'a8dbc1712ce044e095493f81575f2d07',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:47',NULL,'2025-11-28 10:02:47',NULL,NULL),(355,NULL,NULL,'45fa61603d494cd2a114f4702e5807d9',NULL,NULL,NULL,NULL,'2025-11-28 10:02:47',NULL,'2025-11-28 10:02:47',NULL,NULL),(356,NULL,NULL,'e7e9911a0a864af086319080e1a08e27',NULL,NULL,NULL,NULL,'2025-11-28 10:02:49',NULL,'2025-11-28 10:02:49',NULL,NULL),(357,NULL,NULL,'2676b6e4513c43b7803f6e45facbabb8',NULL,NULL,NULL,NULL,'2025-11-28 10:02:49',NULL,'2025-11-28 10:02:49',NULL,NULL),(358,NULL,'c08afd9b18674f9d8b722faa10e160e9',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:49',NULL,'2025-11-28 10:02:49',NULL,NULL),(359,NULL,'58326abff6514fb1a993578457c3058b',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:49',NULL,'2025-11-28 10:02:49',NULL,NULL),(360,NULL,'740a222689ef485e9cae4051068b21c4',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:50',NULL,'2025-11-28 10:02:50',NULL,NULL),(361,NULL,'a7913f694a0c456794b7dd9ed628cb12',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:50',NULL,'2025-11-28 10:02:50',NULL,NULL),(362,NULL,'c6c8ee017594492ab888039b88aee852',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:50',NULL,'2025-11-28 10:02:50',NULL,NULL),(363,NULL,'88fb2a2c7f484220a81f63b74e7fc382',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:51',NULL,'2025-11-28 10:02:51',NULL,NULL),(364,NULL,NULL,'b97430f38d544448bcb1f84d60affd50',NULL,NULL,NULL,NULL,'2025-11-28 10:02:53',NULL,'2025-11-28 10:02:53',NULL,NULL),(365,NULL,NULL,'13f9cb21b44f4449817d81123d502e18',NULL,NULL,NULL,NULL,'2025-11-28 10:02:53',NULL,'2025-11-28 10:02:53',NULL,NULL),(366,NULL,NULL,'f65c5e7cbc254926a250d287f4c30727',NULL,NULL,NULL,NULL,'2025-11-28 10:02:53',NULL,'2025-11-28 10:02:53',NULL,NULL),(367,NULL,NULL,'7b7d32deeba249568b4bf0f462e341ed',NULL,NULL,NULL,NULL,'2025-11-28 10:02:53',NULL,'2025-11-28 10:02:53',NULL,NULL),(368,NULL,NULL,'8d08db2c7b2643bcb4237e853e805dfb',NULL,NULL,NULL,NULL,'2025-11-28 10:02:53',NULL,'2025-11-28 10:02:53',NULL,NULL),(369,NULL,'66375e6e36e8439f9a2219b4827244a1',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:55',NULL,'2025-11-28 10:02:55',NULL,NULL),(370,NULL,NULL,'be087f3c47434902825c1762b87d3a59',NULL,NULL,NULL,NULL,'2025-11-28 10:02:55',NULL,'2025-11-28 10:02:55',NULL,NULL),(371,NULL,'dcf8c6a8bcc24376a9268bd1bed95dfd',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:55',NULL,'2025-11-28 10:02:55',NULL,NULL),(372,NULL,'dc7d206bacd049fd898c7e4b125df6f5',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:55',NULL,'2025-11-28 10:02:55',NULL,NULL),(373,NULL,'574d83d51ff24798a0e01f6f6ddcf0c5',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:56',NULL,'2025-11-28 10:02:56',NULL,NULL),(374,NULL,'027b13dbeb954cf39d0a61dfa61a925a',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:57',NULL,'2025-11-28 10:02:57',NULL,NULL),(375,NULL,'de3e0252f93f4292a50666c75925854e',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:57',NULL,'2025-11-28 10:02:57',NULL,NULL),(376,NULL,NULL,'2cb6ef60645b45529e64f8e157774650',NULL,NULL,NULL,NULL,'2025-11-28 10:02:57',NULL,'2025-11-28 10:02:57',NULL,NULL),(377,NULL,'cd852bfe661443da8fc8465f2da37ac5',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:58',NULL,'2025-11-28 10:02:58',NULL,NULL),(378,NULL,'f23b7feb8db740db9eea6302444ed3a8',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:02:58',NULL,'2025-11-28 10:02:58',NULL,NULL),(379,NULL,NULL,'6043647a24754a06a200d2a6cc64bf56',NULL,NULL,NULL,NULL,'2025-11-28 10:02:59',NULL,'2025-11-28 10:02:59',NULL,NULL),(380,NULL,'62de6fd116db4a588ff77501d60d03b3',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:00',NULL,'2025-11-28 10:03:00',NULL,NULL),(381,NULL,'096e83d794b0497cb24538fbd5f6e8b1',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:00',NULL,'2025-11-28 10:03:00',NULL,NULL),(382,NULL,NULL,'8ce16632d496470daf250c51b1292c1f',NULL,NULL,NULL,NULL,'2025-11-28 10:03:00',NULL,'2025-11-28 10:03:00',NULL,NULL),(383,NULL,NULL,'26e529968573437c8591f252934a6064',NULL,NULL,NULL,NULL,'2025-11-28 10:03:00',NULL,'2025-11-28 10:03:00',NULL,NULL),(384,NULL,NULL,'6043647a24754a06a200d2a6cc64bf56',NULL,NULL,NULL,NULL,'2025-11-28 10:03:00',NULL,'2025-11-28 10:03:00',NULL,NULL),(385,NULL,'5f75395ea0db4ec885f11096d9d99fff',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:01',NULL,'2025-11-28 10:03:01',NULL,NULL),(386,NULL,NULL,'a7f5f360c6fe41c5bbe429be743ad37a',NULL,NULL,NULL,NULL,'2025-11-28 10:03:02',NULL,'2025-11-28 10:03:02',NULL,NULL),(387,NULL,NULL,'7fc6e2eeaf3a4e86987780e0b1967d14',NULL,NULL,NULL,NULL,'2025-11-28 10:03:03',NULL,'2025-11-28 10:03:03',NULL,NULL),(388,NULL,NULL,'9b378f0258a649b58fa739fe0352a236',NULL,NULL,NULL,NULL,'2025-11-28 10:03:03',NULL,'2025-11-28 10:03:03',NULL,NULL),(389,NULL,NULL,'75ac6a26227c40ba81e61e610018d23f',NULL,NULL,NULL,NULL,'2025-11-28 10:03:04',NULL,'2025-11-28 10:03:04',NULL,NULL),(390,NULL,'71aabed46e6f4450a2822a9b4230cbce',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:04',NULL,'2025-11-28 10:03:04',NULL,NULL),(391,NULL,'1f9b84b894e641c4bee3ebcd1409ad9f',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:05',NULL,'2025-11-28 10:03:05',NULL,NULL),(392,NULL,'06681cd2e58a4259aed20506967c1a08',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:06',NULL,'2025-11-28 10:03:06',NULL,NULL),(393,NULL,'516e0bba3f78446789fc88fc297d0de8',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:06',NULL,'2025-11-28 10:03:06',NULL,NULL),(394,NULL,NULL,'71ecb0f3a7134d7b9df2193facc19faa',NULL,NULL,NULL,NULL,'2025-11-28 10:03:07',NULL,'2025-11-28 10:03:07',NULL,NULL),(395,NULL,NULL,'db6b2950549b47a2a2693ecffb5083c4',NULL,NULL,NULL,NULL,'2025-11-28 10:03:08',NULL,'2025-11-28 10:03:08',NULL,NULL),(396,NULL,'8add663886d94df3ae7c7f1bcc6427d4',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:08',NULL,'2025-11-28 10:03:08',NULL,NULL),(397,NULL,'cd9b97e6d04840f3a546b260a8ee9b24',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:09',NULL,'2025-11-28 10:03:09',NULL,NULL),(398,NULL,'8719fde070c849d8ab362af6d1d73346',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:10',NULL,'2025-11-28 10:03:10',NULL,NULL),(399,NULL,NULL,'7efa3ec3924147ac88d3f5809a9c6b74',NULL,NULL,NULL,NULL,'2025-11-28 10:03:10',NULL,'2025-11-28 10:03:10',NULL,NULL),(400,NULL,'fdaddf5b96684681a99b486e0d0e73fd',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:11',NULL,'2025-11-28 10:03:11',NULL,NULL),(401,NULL,'173eadb321da4bd5a575e750ff5fc28e',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:11',NULL,'2025-11-28 10:03:11',NULL,NULL),(402,NULL,'b5f607fa8ce640fcb01e8adc8154ea5f',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:12',NULL,'2025-11-28 10:03:12',NULL,NULL),(403,NULL,NULL,'f6a5516f43fb48ebaa16e4040dd82b84',NULL,NULL,NULL,NULL,'2025-11-28 10:03:12',NULL,'2025-11-28 10:03:12',NULL,NULL),(404,NULL,'0c7819d3fd7a4a1bacbe157ce86654dc',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:12',NULL,'2025-11-28 10:03:12',NULL,NULL),(405,NULL,'cd7c5d213d924d3d9d4428db9d286082',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:13',NULL,'2025-11-28 10:03:13',NULL,NULL),(406,NULL,NULL,'d2683a3526b944688e8e4247babea278',NULL,NULL,NULL,NULL,'2025-11-28 10:03:15',NULL,'2025-11-28 10:03:15',NULL,NULL),(407,NULL,NULL,'dd56aba088464de2b1a6fbb23bdf6a63',NULL,NULL,NULL,NULL,'2025-11-28 10:03:15',NULL,'2025-11-28 10:03:15',NULL,NULL),(408,NULL,NULL,'7dd8e21cfc81423e88248cb5fa529d85',NULL,NULL,NULL,NULL,'2025-11-28 10:03:16',NULL,'2025-11-28 10:03:16',NULL,NULL),(409,NULL,NULL,'e56c024904e842ebaf66f8e9d78c3f8b',NULL,NULL,NULL,NULL,'2025-11-28 10:03:17',NULL,'2025-11-28 10:03:17',NULL,NULL),(410,NULL,NULL,'918835b28b244a59a741af8f4b84fccb',NULL,NULL,NULL,NULL,'2025-11-28 10:03:17',NULL,'2025-11-28 10:03:17',NULL,NULL),(411,NULL,'039b20e548df46d5a9e86787e667b7a9',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:17',NULL,'2025-11-28 10:03:17',NULL,NULL),(412,NULL,'2cfa67078b8440d0bf985b2a5e0e5558',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:18',NULL,'2025-11-28 10:03:18',NULL,NULL),(413,NULL,'342ff14515bd49e3a07e8623d44a30f4',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:20',NULL,'2025-11-28 10:03:20',NULL,NULL),(414,NULL,'41ce7d259e9f4aecb473575a492ed4ec',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:20',NULL,'2025-11-28 10:03:20',NULL,NULL),(415,NULL,NULL,'3eb191149c824d27b03d4087e06c0515',NULL,NULL,NULL,NULL,'2025-11-28 10:03:22',NULL,'2025-11-28 10:03:22',NULL,NULL),(416,NULL,NULL,'078cec78b66d44acb2dcf304e572f2cf',NULL,NULL,NULL,NULL,'2025-11-28 10:03:22',NULL,'2025-11-28 10:03:22',NULL,NULL),(417,NULL,'0feb63bfdd0b4570a8117be519c6e271',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:22',NULL,'2025-11-28 10:03:22',NULL,NULL),(418,NULL,NULL,'aebca59708754190bf09a878160c5b26',NULL,NULL,NULL,NULL,'2025-11-28 10:03:22',NULL,'2025-11-28 10:03:22',NULL,NULL),(419,NULL,'ec3181bdc2434bd5ab7dd249b31357f3',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:23',NULL,'2025-11-28 10:03:23',NULL,NULL),(420,NULL,'3aeda4b8255a4b4b88f2af6da7cdb38f',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:24',NULL,'2025-11-28 10:03:24',NULL,NULL),(421,NULL,'ee1b6e73133041259c74201f68838aff',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:24',NULL,'2025-11-28 10:03:24',NULL,NULL),(422,NULL,'1918e2c2f1ff41b493230f6371a212ba',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:24',NULL,'2025-11-28 10:03:24',NULL,NULL),(423,NULL,'34db787aa2e046fe995f76b6f5244442',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:24',NULL,'2025-11-28 10:03:24',NULL,NULL),(424,NULL,'dba68040958c4e4c89f84cd27a771cd2',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:25',NULL,'2025-11-28 10:03:25',NULL,NULL),(425,NULL,NULL,'5bd2bbf785cf45ae9f7177f253698734',NULL,NULL,NULL,NULL,'2025-11-28 10:03:25',NULL,'2025-11-28 10:03:25',NULL,NULL),(426,NULL,'2d42155c3bad49098bd39abd353aba3c',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:25',NULL,'2025-11-28 10:03:25',NULL,NULL),(427,NULL,'e9fb3ef9e763415cb3c71be780b6fa6f',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:26',NULL,'2025-11-28 10:03:26',NULL,NULL),(428,NULL,'867d4779a51340ebac922f58a4aab50a',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:27',NULL,'2025-11-28 10:03:27',NULL,NULL),(429,NULL,NULL,'7c5bcad89d50440b88b41a1497e02625',NULL,NULL,NULL,NULL,'2025-11-28 10:03:27',NULL,'2025-11-28 10:03:27',NULL,NULL),(430,NULL,'329f0a76cfa8473d925a9b084b01e986',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:27',NULL,'2025-11-28 10:03:27',NULL,NULL),(431,NULL,NULL,'773f24c31709483ba1480c748a1a03cb',NULL,NULL,NULL,NULL,'2025-11-28 10:03:27',NULL,'2025-11-28 10:03:27',NULL,NULL),(432,NULL,NULL,'acaf5f04f62446e5a4fef702112a1cc4',NULL,NULL,NULL,NULL,'2025-11-28 10:03:28',NULL,'2025-11-28 10:03:28',NULL,NULL),(433,NULL,'b85a788d6d5a4d79ae26d4ad36338e13',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:30',NULL,'2025-11-28 10:03:30',NULL,NULL),(434,NULL,'6e873c55c8394e3490b2a70bef5aab9d',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:31',NULL,'2025-11-28 10:03:31',NULL,NULL),(435,NULL,'078483c967674c63878a2bab23995686',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:32',NULL,'2025-11-28 10:03:32',NULL,NULL),(436,NULL,NULL,'c5294fd8bd914a6e8108db5b9a37b78c',NULL,NULL,NULL,NULL,'2025-11-28 10:03:32',NULL,'2025-11-28 10:03:32',NULL,NULL),(437,NULL,'93c441d1ffc345239cce5aa7b1a18610',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:34',NULL,'2025-11-28 10:03:34',NULL,NULL),(438,NULL,NULL,'a18b0089ab204e29a924a9785b7ce58a',NULL,NULL,NULL,NULL,'2025-11-28 10:03:35',NULL,'2025-11-28 10:03:35',NULL,NULL),(439,NULL,'e57f32c896874ed19e42c6de5d47171b',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:35',NULL,'2025-11-28 10:03:35',NULL,NULL),(440,NULL,NULL,'fc6062df90f84020856a0bfdcd77d8fb',NULL,NULL,NULL,NULL,'2025-11-28 10:03:38',NULL,'2025-11-28 10:03:38',NULL,NULL),(441,NULL,NULL,'179dfde489c74c4380a361606ebfc29a',NULL,NULL,NULL,NULL,'2025-11-28 10:03:38',NULL,'2025-11-28 10:03:38',NULL,NULL),(442,NULL,NULL,'d59945f0a752468580cf54cc43f99a74',NULL,NULL,NULL,NULL,'2025-11-28 10:03:39',NULL,'2025-11-28 10:03:39',NULL,NULL),(443,NULL,'ad3ef7d331514ead880f0295c7223912',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:40',NULL,'2025-11-28 10:03:40',NULL,NULL),(444,NULL,'8c50d114601549b1bcff1d256649c7c6',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:41',NULL,'2025-11-28 10:03:41',NULL,NULL),(445,NULL,'c2d865ab906b4683a0e02519e087eedd',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:42',NULL,'2025-11-28 10:03:42',NULL,NULL),(446,NULL,NULL,'7d4b15ea8a4047118722ae315cff554a',NULL,NULL,NULL,NULL,'2025-11-28 10:03:45',NULL,'2025-11-28 10:03:45',NULL,NULL),(447,NULL,NULL,'274b2bb25bfd473688c0148dbb6923dd',NULL,NULL,NULL,NULL,'2025-11-28 10:03:45',NULL,'2025-11-28 10:03:45',NULL,NULL),(448,NULL,'32223b0d67b142c2a4e25f4dc18ebb64',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:48',NULL,'2025-11-28 10:03:48',NULL,NULL),(449,NULL,NULL,'59f52847072a48c9ba23dd63da725099',NULL,NULL,NULL,NULL,'2025-11-28 10:03:48',NULL,'2025-11-28 10:03:48',NULL,NULL),(450,NULL,'5242e590b61d46038cd791e3c64609e6',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:49',NULL,'2025-11-28 10:03:49',NULL,NULL),(451,NULL,'7c9c2efb726347a2ae61c6260e39dac0',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:49',NULL,'2025-11-28 10:03:49',NULL,NULL),(452,NULL,NULL,'91b1bfa1fbed4a06aebefa5dfe23375d',NULL,NULL,NULL,NULL,'2025-11-28 10:03:49',NULL,'2025-11-28 10:03:49',NULL,NULL),(453,NULL,'0142f5b476b043239e12a8a9cf0c5395',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:50',NULL,'2025-11-28 10:03:50',NULL,NULL),(454,NULL,NULL,'647f518ff6bc44399252bc73415820c9',NULL,NULL,NULL,NULL,'2025-11-28 10:03:50',NULL,'2025-11-28 10:03:50',NULL,NULL),(455,NULL,'71e8503e32b14b90a46a60e2c6122cb4',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:51',NULL,'2025-11-28 10:03:51',NULL,NULL),(456,NULL,'08fac6c2adb64ba59a4f396b445d388b',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:51',NULL,'2025-11-28 10:03:51',NULL,NULL),(457,NULL,'c57c5dfffe2a46d99b4de8a1c43bc77d',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:51',NULL,'2025-11-28 10:03:51',NULL,NULL),(458,NULL,'5943238f50e64ee78453a43d136342e1',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:51',NULL,'2025-11-28 10:03:51',NULL,NULL),(459,NULL,NULL,'55a1d24c02ce46cfb8a56ae7899c4cf3',NULL,NULL,NULL,NULL,'2025-11-28 10:03:52',NULL,'2025-11-28 10:03:52',NULL,NULL),(460,NULL,NULL,'4120efc3afab4ef7a4bf018621be4004',NULL,NULL,NULL,NULL,'2025-11-28 10:03:52',NULL,'2025-11-28 10:03:52',NULL,NULL),(461,NULL,NULL,'68d0de798f1848b0bf4fd4f2070056e6',NULL,NULL,NULL,NULL,'2025-11-28 10:03:53',NULL,'2025-11-28 10:03:53',NULL,NULL),(462,NULL,'ea87a73fa7b04a82b7af78d00e907c0d',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:54',NULL,'2025-11-28 10:03:54',NULL,NULL),(463,NULL,NULL,'c6ca66535429485d860824489d89b251',NULL,NULL,NULL,NULL,'2025-11-28 10:03:55',NULL,'2025-11-28 10:03:55',NULL,NULL),(464,NULL,'233e7c1143b54779aba98e9c52eaf073',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:55',NULL,'2025-11-28 10:03:55',NULL,NULL),(465,NULL,'7e79f1a6a8e14f4f827d3ff6c3021125',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:56',NULL,'2025-11-28 10:03:56',NULL,NULL),(466,NULL,'97d088731e5740f69c6a5c2639052701',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:03:57',NULL,'2025-11-28 10:03:57',NULL,NULL),(467,NULL,NULL,'7928e8c814e94d4ba6f87f32d52e8e5f',NULL,NULL,NULL,NULL,'2025-11-28 10:03:59',NULL,'2025-11-28 10:03:59',NULL,NULL),(468,NULL,NULL,'06c57f3efffc46ebbf7c4775077abaf0',NULL,NULL,NULL,NULL,'2025-11-28 10:04:00',NULL,'2025-11-28 10:04:00',NULL,NULL),(469,NULL,NULL,'a9e20725c5f64ee2bb40ab4c3037798c',NULL,NULL,NULL,NULL,'2025-11-28 10:04:00',NULL,'2025-11-28 10:04:00',NULL,NULL),(470,NULL,NULL,'4ff10a26864a44ba85d928260b58e850',NULL,NULL,NULL,NULL,'2025-11-28 10:04:02',NULL,'2025-11-28 10:04:02',NULL,NULL),(471,NULL,'319584c70d0b435a98d62733e7de80a8',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:03',NULL,'2025-11-28 10:04:03',NULL,NULL),(472,NULL,'3a6bc1104ced4f17a79fdec910ce3950',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:03',NULL,'2025-11-28 10:04:03',NULL,NULL),(473,NULL,'a6cbe3c6ac3547e2b4fd80a2e29a91b0',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:05',NULL,'2025-11-28 10:04:05',NULL,NULL),(474,NULL,'9bec1de8b74341efaeb7542d167bef0d',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:06',NULL,'2025-11-28 10:04:06',NULL,NULL),(475,NULL,NULL,'0edcbbf6485441c3a311ed9a72fdced6',NULL,NULL,NULL,NULL,'2025-11-28 10:04:07',NULL,'2025-11-28 10:04:07',NULL,NULL),(476,NULL,NULL,'4ff10a26864a44ba85d928260b58e850',NULL,NULL,NULL,NULL,'2025-11-28 10:04:07',NULL,'2025-11-28 10:04:07',NULL,NULL),(477,NULL,'f3f804d15f1144ba83b5a5526eaf9e7b',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:07',NULL,'2025-11-28 10:04:07',NULL,NULL),(478,NULL,'a5e18feab7374c11856c65a1a35947aa',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:07',NULL,'2025-11-28 10:04:07',NULL,NULL),(479,NULL,NULL,'66fa27b4387c41b9b15418f675fb71c3',NULL,NULL,NULL,NULL,'2025-11-28 10:04:08',NULL,'2025-11-28 10:04:08',NULL,NULL),(480,NULL,NULL,'e131c98d1a96489880934e23934faecb',NULL,NULL,NULL,NULL,'2025-11-28 10:04:08',NULL,'2025-11-28 10:04:08',NULL,NULL),(481,NULL,NULL,'4a883f11564843d894d7f2a784068cb1',NULL,NULL,NULL,NULL,'2025-11-28 10:04:09',NULL,'2025-11-28 10:04:09',NULL,NULL),(482,NULL,NULL,'5f9b9bea8fb84a2482dfd48c8e9b895e',NULL,NULL,NULL,NULL,'2025-11-28 10:04:09',NULL,'2025-11-28 10:04:09',NULL,NULL),(483,NULL,'267e398d01d64133aa3d7fb97e2ccc6f',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:10',NULL,'2025-11-28 10:04:10',NULL,NULL),(484,NULL,NULL,'fe65864ca994460c9f786e2a187aa538',NULL,NULL,NULL,NULL,'2025-11-28 10:04:11',NULL,'2025-11-28 10:04:11',NULL,NULL),(485,NULL,NULL,'697ee57b73d84734874f9510a9464c25',NULL,NULL,NULL,NULL,'2025-11-28 10:04:11',NULL,'2025-11-28 10:04:11',NULL,NULL),(486,NULL,'9064afdc99904eb4942674dbb546f450',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:11',NULL,'2025-11-28 10:04:11',NULL,NULL),(487,NULL,'82f30d7aafbe4e52a4bcb693e0917715',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:11',NULL,'2025-11-28 10:04:11',NULL,NULL),(488,NULL,'8cbf90414cd54303afc92a6a19865e5a',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:13',NULL,'2025-11-28 10:04:13',NULL,NULL),(489,NULL,'af8499f268394ff8af1ecb69b1b505c8',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:13',NULL,'2025-11-28 10:04:13',NULL,NULL),(490,NULL,'582ea453f87c4c118059efffce814f95',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:13',NULL,'2025-11-28 10:04:13',NULL,NULL),(491,NULL,'115c143e37394d77b81665435ce51c10',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:15',NULL,'2025-11-28 10:04:15',NULL,NULL),(492,NULL,NULL,'8e0bef62d120468f8c796e117c42a0f3',NULL,NULL,NULL,NULL,'2025-11-28 10:04:16',NULL,'2025-11-28 10:04:16',NULL,NULL),(493,NULL,NULL,'fc986bc6befc4e3da531cbe929a685cd',NULL,NULL,NULL,NULL,'2025-11-28 10:04:17',NULL,'2025-11-28 10:04:17',NULL,NULL),(494,NULL,NULL,NULL,NULL,'fc11832f951e4045b5cf0848f58a6cd6',NULL,NULL,'2025-11-28 10:04:18',NULL,'2025-11-28 10:04:18',NULL,NULL),(495,NULL,'6b11f04c88dd4db3aa7f405d125f76a4',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:18',NULL,'2025-11-28 10:04:18',NULL,NULL),(496,NULL,'db36720df2c1422da5ae72b591ed7bef',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:18',NULL,'2025-11-28 10:04:18',NULL,NULL),(497,NULL,NULL,'e88bdd0d25784c05a16af6bada539278',NULL,NULL,NULL,NULL,'2025-11-28 10:04:18',NULL,'2025-11-28 10:04:18',NULL,NULL),(498,NULL,NULL,'888c3d92c86b464898d3543558908dfb',NULL,NULL,NULL,NULL,'2025-11-28 10:04:18',NULL,'2025-11-28 10:04:18',NULL,NULL),(499,NULL,'43746927d3ab4eb8af9efbe421e8266e',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:18',NULL,'2025-11-28 10:04:18',NULL,NULL),(500,NULL,NULL,'c3b23ca10f7c4aa9abf650d80ef43f3b',NULL,NULL,NULL,NULL,'2025-11-28 10:04:18',NULL,'2025-11-28 10:04:18',NULL,NULL),(501,NULL,NULL,'da7c4a1c9ae34c0193590fc24cb92674',NULL,NULL,NULL,NULL,'2025-11-28 10:04:20',NULL,'2025-11-28 10:04:20',NULL,NULL),(502,NULL,NULL,NULL,NULL,'c17b7241bb3341288fc21c55f8c54b99',NULL,NULL,'2025-11-28 10:04:20',NULL,'2025-11-28 10:04:20',NULL,NULL),(503,NULL,'4bd289c1edd84e60ba519b4c8e563700',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:20',NULL,'2025-11-28 10:04:20',NULL,NULL),(504,NULL,NULL,'437b6784c91044009b391e569a528556',NULL,NULL,NULL,NULL,'2025-11-28 10:04:21',NULL,'2025-11-28 10:04:21',NULL,NULL),(505,NULL,'0e1b817e7b774c91af81657cdda45508',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:21',NULL,'2025-11-28 10:04:21',NULL,NULL),(506,NULL,'47e52fef5ed94c6c969b1ccd5e604b17',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:22',NULL,'2025-11-28 10:04:22',NULL,NULL),(507,NULL,'8adec50093674b339d37b80125a537b0',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:22',NULL,'2025-11-28 10:04:22',NULL,NULL),(508,NULL,NULL,'9ff2e7b86c8c4b0ba2564ac4f2d7e69f',NULL,NULL,NULL,NULL,'2025-11-28 10:04:23',NULL,'2025-11-28 10:04:23',NULL,NULL),(509,NULL,'0804c69628974d3d88dafe436f90b495',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:23',NULL,'2025-11-28 10:04:23',NULL,NULL),(510,NULL,NULL,NULL,NULL,'b82f91e1a3e14a01973734678f4724f9',NULL,NULL,'2025-11-28 10:04:24',NULL,'2025-11-28 10:04:24',NULL,NULL),(511,NULL,'554601e38c7a43bcb11a39f4453bc814',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:24',NULL,'2025-11-28 10:04:24',NULL,NULL),(512,NULL,NULL,'92fe68990d514962a3610cab35f1a5b3',NULL,NULL,NULL,NULL,'2025-11-28 10:04:24',NULL,'2025-11-28 10:04:24',NULL,NULL),(513,NULL,NULL,'0f53393b713d444dbe256938ac88dca0',NULL,NULL,NULL,NULL,'2025-11-28 10:04:24',NULL,'2025-11-28 10:04:24',NULL,NULL),(514,NULL,NULL,'a89a596b9bac4351a6070dcff732ad03',NULL,NULL,NULL,NULL,'2025-11-28 10:04:24',NULL,'2025-11-28 10:04:24',NULL,NULL),(515,NULL,'dc61616595214fc5bab09aea5a481656',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:24',NULL,'2025-11-28 10:04:24',NULL,NULL),(516,NULL,'66b99b7ad01341f68b952743c49e0776',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:25',NULL,'2025-11-28 10:04:25',NULL,NULL),(517,NULL,NULL,'ba2c4199b22c40c0ba2c51e99c49fcff',NULL,NULL,NULL,NULL,'2025-11-28 10:04:27',NULL,'2025-11-28 10:04:27',NULL,NULL),(518,NULL,'2d43293694c24082aa4dec5445ce1d63',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:27',NULL,'2025-11-28 10:04:27',NULL,NULL),(519,NULL,'deb7a13bbfe848b7bc80123c7e1964e9',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:27',NULL,'2025-11-28 10:04:27',NULL,NULL),(520,NULL,NULL,NULL,NULL,'a40db55dde3a4f7a87681590bc0af397',NULL,NULL,'2025-11-28 10:04:29',NULL,'2025-11-28 10:04:29',NULL,NULL),(521,NULL,NULL,'065b83b6f1884cb7bda95e36ef496584',NULL,NULL,NULL,NULL,'2025-11-28 10:04:29',NULL,'2025-11-28 10:04:29',NULL,NULL),(522,NULL,'8d7f9329049b453f817567e677faca33',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:30',NULL,'2025-11-28 10:04:30',NULL,NULL),(523,NULL,NULL,'396301196c3347439dbe21dc63938d37',NULL,NULL,NULL,NULL,'2025-11-28 10:04:30',NULL,'2025-11-28 10:04:30',NULL,NULL),(524,NULL,NULL,'b23dcdb3173447aaa09fbdfb292f87e0',NULL,NULL,NULL,NULL,'2025-11-28 10:04:30',NULL,'2025-11-28 10:04:30',NULL,NULL),(525,NULL,NULL,'74aa4f466b424bba8e9e71a5f2cf4142',NULL,NULL,NULL,NULL,'2025-11-28 10:04:30',NULL,'2025-11-28 10:04:30',NULL,NULL),(526,NULL,NULL,NULL,NULL,NULL,'34adf2419f904eb08c978e8f510022f6',NULL,'2025-11-28 10:04:30',NULL,'2025-11-28 10:04:30',NULL,NULL),(527,NULL,NULL,NULL,NULL,NULL,'1621b3e0ae2a43b69cd20af647061f70',NULL,'2025-11-28 10:04:30',NULL,'2025-11-28 10:04:30',NULL,NULL),(528,NULL,NULL,NULL,NULL,NULL,'83d000c05ce443efb5ca4bdd6255cd43',NULL,'2025-11-28 10:04:31',NULL,'2025-11-28 10:04:31',NULL,NULL),(529,NULL,NULL,NULL,NULL,NULL,'fdfa5883ab684937b4ad10a8b9344ae0',NULL,'2025-11-28 10:04:31',NULL,'2025-11-28 10:04:31',NULL,NULL),(530,NULL,NULL,NULL,NULL,NULL,'aa712db50caf45699ace1606b345b9eb',NULL,'2025-11-28 10:04:31',NULL,'2025-11-28 10:04:31',NULL,NULL),(531,NULL,NULL,'b10a84efe3f5423b94f39fd27bc966f9',NULL,NULL,NULL,NULL,'2025-11-28 10:04:31',NULL,'2025-11-28 10:04:31',NULL,NULL),(532,NULL,NULL,'c41ab8c06b7f441fac4d2b09ed09c08c',NULL,NULL,NULL,NULL,'2025-11-28 10:04:31',NULL,'2025-11-28 10:04:31',NULL,NULL),(533,NULL,NULL,NULL,NULL,'43ec8d626a0146958740c5d7656969ee',NULL,NULL,'2025-11-28 10:04:32',NULL,'2025-11-28 10:04:32',NULL,NULL),(534,NULL,'70de67fe9f1d43a793c239829fcd6ef2',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:32',NULL,'2025-11-28 10:04:32',NULL,NULL),(535,NULL,NULL,'f152fde9d8f542cb87a13c43a795e62f',NULL,NULL,NULL,NULL,'2025-11-28 10:04:32',NULL,'2025-11-28 10:04:32',NULL,NULL),(536,NULL,'9c8d8e5a130b492a9dc9daba498c0cfc',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:32',NULL,'2025-11-28 10:04:32',NULL,NULL),(537,NULL,'0482da4b754a489f915436358dbcb16f',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:32',NULL,'2025-11-28 10:04:32',NULL,NULL),(538,NULL,NULL,'4c950481738f4efba6d02a37cd58cc94',NULL,NULL,NULL,NULL,'2025-11-28 10:04:33',NULL,'2025-11-28 10:04:33',NULL,NULL),(539,NULL,NULL,'36a8371732f842dcb220a688f3d5ace8',NULL,NULL,NULL,NULL,'2025-11-28 10:04:33',NULL,'2025-11-28 10:04:33',NULL,NULL),(540,NULL,'9411c201a4d84f2bbafab50cddd239fa',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:33',NULL,'2025-11-28 10:04:33',NULL,NULL),(541,NULL,'6bbca6d263444b1db406831d66764e05',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:33',NULL,'2025-11-28 10:04:33',NULL,NULL),(542,NULL,'ce4ec11533e64e9eb8157fefd551ae24',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:35',NULL,'2025-11-28 10:04:35',NULL,NULL),(543,NULL,'2cc02feaeb36461c804c336cb5872422',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:35',NULL,'2025-11-28 10:04:35',NULL,NULL),(544,NULL,'d26bcd3dfe264189835f6a44549dc0c0',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:36',NULL,'2025-11-28 10:04:36',NULL,NULL),(545,NULL,'4e65fefdddc44cb2901a66fade5db1d9',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:36',NULL,'2025-11-28 10:04:36',NULL,NULL),(546,NULL,'6068c7dd108843a990307a2b3dd5eca5',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:37',NULL,'2025-11-28 10:04:37',NULL,NULL),(547,NULL,NULL,'85cea99a54174dcf9ba718e75668791e',NULL,NULL,NULL,NULL,'2025-11-28 10:04:37',NULL,'2025-11-28 10:04:37',NULL,NULL),(548,NULL,NULL,'442cc7f626724253ac2704f4f5366ece',NULL,NULL,NULL,NULL,'2025-11-28 10:04:37',NULL,'2025-11-28 10:04:37',NULL,NULL),(549,NULL,'38f367b323b442b98d47a65b3b361aaf',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:38',NULL,'2025-11-28 10:04:38',NULL,NULL),(550,NULL,NULL,'d09d37496693499986d5fb9d834ca3c8',NULL,NULL,NULL,NULL,'2025-11-28 10:04:39',NULL,'2025-11-28 10:04:39',NULL,NULL),(551,NULL,NULL,'5875037f9d484b32be8f1db71d62ada1',NULL,NULL,NULL,NULL,'2025-11-28 10:04:39',NULL,'2025-11-28 10:04:39',NULL,NULL),(552,NULL,NULL,'5b66735b723642a184ff05fff3af61b4',NULL,NULL,NULL,NULL,'2025-11-28 10:04:40',NULL,'2025-11-28 10:04:40',NULL,NULL),(553,NULL,NULL,'5b66735b723642a184ff05fff3af61b4',NULL,NULL,NULL,NULL,'2025-11-28 10:04:40',NULL,'2025-11-28 10:04:40',NULL,NULL),(554,NULL,'204f753568644db1aeb12e86cde2690d',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:40',NULL,'2025-11-28 10:04:40',NULL,NULL),(555,NULL,'a724b755879c43e18f9593de23b10199',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:40',NULL,'2025-11-28 10:04:40',NULL,NULL),(556,NULL,NULL,'99bd5597481645d886c31299fc59a86b',NULL,NULL,NULL,NULL,'2025-11-28 10:04:40',NULL,'2025-11-28 10:04:40',NULL,NULL),(557,NULL,NULL,'ed8c259fa9504189afd48e98ace07064',NULL,NULL,NULL,NULL,'2025-11-28 10:04:40',NULL,'2025-11-28 10:04:40',NULL,NULL),(558,NULL,'0c0414677f9a410991db01df4334d6de',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:41',NULL,'2025-11-28 10:04:41',NULL,NULL),(559,NULL,'1a415fd9a1cd47a6a2ee49f9b46f965f',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:41',NULL,'2025-11-28 10:04:41',NULL,NULL),(560,NULL,'2a9ef55513a54533893abc82d39b70f8',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:42',NULL,'2025-11-28 10:04:42',NULL,NULL),(561,NULL,'d8bb5d24482b4613b08788bb3a3b3179',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:44',NULL,'2025-11-28 10:04:44',NULL,NULL),(562,NULL,NULL,'a03feb1bac904d3e96b7bf31d3c9074d',NULL,NULL,NULL,NULL,'2025-11-28 10:04:45',NULL,'2025-11-28 10:04:45',NULL,NULL),(563,NULL,NULL,'78bcfd909c80443c82881da0a50cb890',NULL,NULL,NULL,NULL,'2025-11-28 10:04:45',NULL,'2025-11-28 10:04:45',NULL,NULL),(564,NULL,NULL,'12b992946fba4e2eabd288e1f66297be',NULL,NULL,NULL,NULL,'2025-11-28 10:04:45',NULL,'2025-11-28 10:04:45',NULL,NULL),(565,NULL,NULL,'645f8f7706cf4ad69581bbfc76d7ebca',NULL,NULL,NULL,NULL,'2025-11-28 10:04:46',NULL,'2025-11-28 10:04:46',NULL,NULL),(566,NULL,'c0f009875fab4d21a86066fc64145791',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:48',NULL,'2025-11-28 10:04:48',NULL,NULL),(567,NULL,'eb930246fe254f8e8b4c5a732a791c06',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:48',NULL,'2025-11-28 10:04:48',NULL,NULL),(568,NULL,'1f4f3ac2eb374358b060b6f9f110ac37',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:50',NULL,'2025-11-28 10:04:50',NULL,NULL),(569,NULL,'0113d7f8462a4524ad600d9ec0d97f5f',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:50',NULL,'2025-11-28 10:04:50',NULL,NULL),(570,NULL,NULL,'b25fc12c4c624fb19c7a7270969e1085',NULL,NULL,NULL,NULL,'2025-11-28 10:04:53',NULL,'2025-11-28 10:04:53',NULL,NULL),(571,NULL,NULL,'52bbcb6b43784ff0af32e108e0dd3cbb',NULL,NULL,NULL,NULL,'2025-11-28 10:04:53',NULL,'2025-11-28 10:04:53',NULL,NULL),(572,NULL,'9d13d1511fc3485e975f8ee38a7f82ec',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:56',NULL,'2025-11-28 10:04:56',NULL,NULL),(573,NULL,'3f9e090f7e6c4fa3a4809c674995736a',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:04:59',NULL,'2025-11-28 10:04:59',NULL,NULL),(574,NULL,NULL,'197a6f4a4a5941b4b4528555b651d8eb',NULL,NULL,NULL,NULL,'2025-11-28 10:05:01',NULL,'2025-11-28 10:05:01',NULL,NULL),(575,NULL,'d22aa955cd34443a92ea14760a38883d',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:03',NULL,'2025-11-28 10:05:03',NULL,NULL),(576,NULL,NULL,'6aa2d31d87d44bd68f3306827a96cb84',NULL,NULL,NULL,NULL,'2025-11-28 10:05:07',NULL,'2025-11-28 10:05:07',NULL,NULL),(577,NULL,NULL,'b286c38dfd0e4889806c62c7b4b9ee98',NULL,NULL,NULL,NULL,'2025-11-28 10:05:09',NULL,'2025-11-28 10:05:09',NULL,NULL),(578,NULL,'7163b69fa8fc4d998fb494edfa303457',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:09',NULL,'2025-11-28 10:05:09',NULL,NULL),(579,NULL,'50a1392ce96c4024bcd36a3df403ca29',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:10',NULL,'2025-11-28 10:05:10',NULL,NULL),(580,NULL,NULL,'e750bb00ffc649d4a72c2c35e47376b7',NULL,NULL,NULL,NULL,'2025-11-28 10:05:14',NULL,'2025-11-28 10:05:14',NULL,NULL),(581,NULL,NULL,'3024861035ab4bc8915e869b36963015',NULL,NULL,NULL,NULL,'2025-11-28 10:05:14',NULL,'2025-11-28 10:05:14',NULL,NULL),(582,NULL,'898ef11d52344936851dc6b524b8d7c3',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:17',NULL,'2025-11-28 10:05:17',NULL,NULL),(583,NULL,'926ee04702e14b898509043de6622587',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:19',NULL,'2025-11-28 10:05:19',NULL,NULL),(584,NULL,NULL,'595b5cbed3764c7a95b0ab3634e5becb',NULL,NULL,NULL,NULL,'2025-11-28 10:05:21',NULL,'2025-11-28 10:05:21',NULL,NULL),(585,NULL,NULL,'23393884193b4f948bc14907a2fd0aec',NULL,NULL,NULL,NULL,'2025-11-28 10:05:22',NULL,'2025-11-28 10:05:22',NULL,NULL),(586,NULL,'8c66e098e4fb4a349dc2bb4293454135',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:22',NULL,'2025-11-28 10:05:22',NULL,NULL),(587,NULL,NULL,'9af6b5d9d0004a4e936c15a989e952ac',NULL,NULL,NULL,NULL,'2025-11-28 10:05:22',NULL,'2025-11-28 10:05:22',NULL,NULL),(588,NULL,'b96cbd3702cb48479a70acb136ca2d12',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:25',NULL,'2025-11-28 10:05:25',NULL,NULL),(589,NULL,NULL,'a22fc7f25dd74349be1fe8842a517a9e',NULL,NULL,NULL,NULL,'2025-11-28 10:05:25',NULL,'2025-11-28 10:05:25',NULL,NULL),(590,NULL,'4f7137403007434e97774612a2073213',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:26',NULL,'2025-11-28 10:05:26',NULL,NULL),(591,NULL,'e8063417cfc540ba8948734a0d2952d7',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:27',NULL,'2025-11-28 10:05:27',NULL,NULL),(592,NULL,NULL,'4d2a0ee370da4e688f1d8f5c639f278d',NULL,NULL,NULL,NULL,'2025-11-28 10:05:27',NULL,'2025-11-28 10:05:27',NULL,NULL),(593,NULL,NULL,'322220371f7e445ebc08ccefe1675e7b',NULL,NULL,NULL,NULL,'2025-11-28 10:05:27',NULL,'2025-11-28 10:05:27',NULL,NULL),(594,NULL,NULL,'e7c9d49fbf5f41059b8d32426e1740a6',NULL,NULL,NULL,NULL,'2025-11-28 10:05:27',NULL,'2025-11-28 10:05:27',NULL,NULL),(595,NULL,'517e4cc7e34e4fe7b49313300e5db635',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:28',NULL,'2025-11-28 10:05:28',NULL,NULL),(596,NULL,'ac0f848cde7c47c998a8b80087a3b59d',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:29',NULL,'2025-11-28 10:05:29',NULL,NULL),(597,NULL,'e28ed2da438047e79f641282bcdfc202',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:29',NULL,'2025-11-28 10:05:29',NULL,NULL),(598,NULL,NULL,'117d90e37590425482be7f5ca8861ab3',NULL,NULL,NULL,NULL,'2025-11-28 10:05:33',NULL,'2025-11-28 10:05:33',NULL,NULL),(599,NULL,NULL,'195d74006384403fbdf59464db0e42a5',NULL,NULL,NULL,NULL,'2025-11-28 10:05:33',NULL,'2025-11-28 10:05:33',NULL,NULL),(600,NULL,NULL,'48f54094604448288052e0203d18d8df',NULL,NULL,NULL,NULL,'2025-11-28 10:05:35',NULL,'2025-11-28 10:05:35',NULL,NULL),(601,NULL,'4497ce1c534b4d95b88be3dcf50f94b3',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:35',NULL,'2025-11-28 10:05:35',NULL,NULL),(602,NULL,NULL,'3d5775f04ea44c8ba2cf2fd7c2599604',NULL,NULL,NULL,NULL,'2025-11-28 10:05:36',NULL,'2025-11-28 10:05:36',NULL,NULL),(603,NULL,NULL,'1170e00b193540e48a34e21b33f08b7a',NULL,NULL,NULL,NULL,'2025-11-28 10:05:36',NULL,'2025-11-28 10:05:36',NULL,NULL),(604,NULL,NULL,'cb58c56533984a129050414c9b160b63',NULL,NULL,NULL,NULL,'2025-11-28 10:05:36',NULL,'2025-11-28 10:05:36',NULL,NULL),(605,NULL,'45fdbe27569f45449de58f1d1899ceea',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:36',NULL,'2025-11-28 10:05:36',NULL,NULL),(606,NULL,'cc1fbd7319614f7ab4566dfed25610b8',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:37',NULL,'2025-11-28 10:05:37',NULL,NULL),(607,NULL,'a8f8694ac11a4237ad168b64c39ca114',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:37',NULL,'2025-11-28 10:05:37',NULL,NULL),(608,NULL,'de1aeac8abd545fcb83eb3ee06f16689',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:38',NULL,'2025-11-28 10:05:38',NULL,NULL),(609,NULL,'12d04cc70bb24d2d8d655728df98df84',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:39',NULL,'2025-11-28 10:05:39',NULL,NULL),(610,NULL,NULL,'c0286a07766246c0b685593779a1b7bd',NULL,NULL,NULL,NULL,'2025-11-28 10:05:40',NULL,'2025-11-28 10:05:40',NULL,NULL),(611,NULL,NULL,'139025e282cd4c1e9b9b02ca9ce6a593',NULL,NULL,NULL,NULL,'2025-11-28 10:05:40',NULL,'2025-11-28 10:05:40',NULL,NULL),(612,NULL,NULL,'0e4afff2cfa645c7b8f8ba9f95a355ba',NULL,NULL,NULL,NULL,'2025-11-28 10:05:40',NULL,'2025-11-28 10:05:40',NULL,NULL),(613,NULL,NULL,'0aa0e67023024c51bb948f9e5ef93c1d',NULL,NULL,NULL,NULL,'2025-11-28 10:05:40',NULL,'2025-11-28 10:05:40',NULL,NULL),(614,NULL,NULL,'fae7d4d0d8c7416fa91763e2c8fbce1c',NULL,NULL,NULL,NULL,'2025-11-28 10:05:41',NULL,'2025-11-28 10:05:41',NULL,NULL),(615,NULL,NULL,'7c31bc993fd045bcb3023e83fe4f7a43',NULL,NULL,NULL,NULL,'2025-11-28 10:05:42',NULL,'2025-11-28 10:05:42',NULL,NULL),(616,NULL,'c20eb3e942c1476ca84fcab1d1d197de',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:42',NULL,'2025-11-28 10:05:42',NULL,NULL),(617,NULL,'aa5be61eafca4d96976422f0e0103210',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:43',NULL,'2025-11-28 10:05:43',NULL,NULL),(618,NULL,'42fcb68b18ae4a57a98f2680fd548bbe',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:43',NULL,'2025-11-28 10:05:43',NULL,NULL),(619,NULL,'72c07ab412914ce7b290f4b4ad2f9681',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:43',NULL,'2025-11-28 10:05:43',NULL,NULL),(620,NULL,'5c1cc8bd04e04964bf55c27886efbf5c',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:46',NULL,'2025-11-28 10:05:46',NULL,NULL),(621,NULL,'cf9c61deb45a484589550e8095a7f6d8',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:46',NULL,'2025-11-28 10:05:46',NULL,NULL),(622,NULL,NULL,'134e7edec6c94816a5720be1cdb3e098',NULL,NULL,NULL,NULL,'2025-11-28 10:05:49',NULL,'2025-11-28 10:05:49',NULL,NULL),(623,NULL,NULL,'ea0b0a21ed1b43f6aacbc76d07507144',NULL,NULL,NULL,NULL,'2025-11-28 10:05:50',NULL,'2025-11-28 10:05:50',NULL,NULL),(624,NULL,'ca597e4ddf9347b09810afe64bd41106',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:51',NULL,'2025-11-28 10:05:51',NULL,NULL),(625,NULL,NULL,'e0f29aacf6a94315b178b4a16e3fd03d',NULL,NULL,NULL,NULL,'2025-11-28 10:05:51',NULL,'2025-11-28 10:05:51',NULL,NULL),(626,NULL,NULL,'3ff9ea6d4ad646d8b2459f66f1af33fc',NULL,NULL,NULL,NULL,'2025-11-28 10:05:51',NULL,'2025-11-28 10:05:51',NULL,NULL),(627,NULL,'ffe54d2f01f94accafb29c013731f2df',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:52',NULL,'2025-11-28 10:05:52',NULL,NULL),(628,NULL,'ba7456648a0f43028832ef04ff1d03da',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:52',NULL,'2025-11-28 10:05:52',NULL,NULL),(629,NULL,NULL,'e43a85c4f33243c68013ab45985ff356',NULL,NULL,NULL,NULL,'2025-11-28 10:05:52',NULL,'2025-11-28 10:05:52',NULL,NULL),(630,NULL,'79185418333d4a93b24c87e39a4a1847',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:52',NULL,'2025-11-28 10:05:52',NULL,NULL),(631,NULL,'79c7da76f5894b10864b69d1961b95ab',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:54',NULL,'2025-11-28 10:05:54',NULL,NULL),(632,NULL,NULL,'8ae84c7a815a4064b40748ab9db8c8a0',NULL,NULL,NULL,NULL,'2025-11-28 10:05:56',NULL,'2025-11-28 10:05:56',NULL,NULL),(633,NULL,NULL,'d62f3b7ee9a2437a895cfdb1eaa1523b',NULL,NULL,NULL,NULL,'2025-11-28 10:05:58',NULL,'2025-11-28 10:05:58',NULL,NULL),(634,NULL,NULL,'fbab78ff4a004e9c80e219c9c3b8f351',NULL,NULL,NULL,NULL,'2025-11-28 10:05:58',NULL,'2025-11-28 10:05:58',NULL,NULL),(635,NULL,'c7c1968def7541328ce1a83ff9fab794',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:59',NULL,'2025-11-28 10:05:59',NULL,NULL),(636,NULL,'16a57eec68224f4d9395015bb4c6714b',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:05:59',NULL,'2025-11-28 10:05:59',NULL,NULL),(637,NULL,NULL,'f46816cd3c564ba389a739ec48b81a14',NULL,NULL,NULL,NULL,'2025-11-28 10:06:00',NULL,'2025-11-28 10:06:00',NULL,NULL),(638,NULL,'66c18a9c492e485f9792ea13f46839c3',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:06:00',NULL,'2025-11-28 10:06:00',NULL,NULL),(639,NULL,NULL,'4ecef67ff5284536a16df4fed4247e70',NULL,NULL,NULL,NULL,'2025-11-28 10:06:02',NULL,'2025-11-28 10:06:02',NULL,NULL),(640,NULL,NULL,'cc9db80f802d43b8b0a335d9e32a7885',NULL,NULL,NULL,NULL,'2025-11-28 10:06:02',NULL,'2025-11-28 10:06:02',NULL,NULL),(641,NULL,'38c774f4f3a34ba7822603fa362cd4c8',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:06:02',NULL,'2025-11-28 10:06:02',NULL,NULL),(642,NULL,NULL,'8d30c732fa674cae8e1de9092f58edd9',NULL,NULL,NULL,NULL,'2025-11-28 10:06:03',NULL,'2025-11-28 10:06:03',NULL,NULL),(643,NULL,'a75e608082fb4bb7b8cbde2d7be059fd',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:06:04',NULL,'2025-11-28 10:06:04',NULL,NULL),(644,NULL,'3a67d7f32f5e49c3aed3e09278dd6c95',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:06:05',NULL,'2025-11-28 10:06:05',NULL,NULL),(645,NULL,NULL,'9fea8a2c86e844838cfa99f187754b04',NULL,NULL,NULL,NULL,'2025-11-28 10:06:05',NULL,'2025-11-28 10:06:05',NULL,NULL),(646,NULL,'8300cdc271374c008d447a499d00e24c',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:06:05',NULL,'2025-11-28 10:06:05',NULL,NULL),(647,NULL,'09ce8f94e31a412b82a6b18baad225fe',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:06:06',NULL,'2025-11-28 10:06:06',NULL,NULL),(648,NULL,NULL,'117a085f54e0434f9a993b9abe38624d',NULL,NULL,NULL,NULL,'2025-11-28 10:06:11',NULL,'2025-11-28 10:06:11',NULL,NULL),(649,NULL,NULL,'a06f1fb3104e4b4eae2f1a207fcaea64',NULL,NULL,NULL,NULL,'2025-11-28 10:06:11',NULL,'2025-11-28 10:06:11',NULL,NULL),(650,NULL,'e8a245ce85d845b5aa0d1f9c0238c9e1',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:06:14',NULL,'2025-11-28 10:06:14',NULL,NULL),(651,NULL,'7c54b82fb35442e19cf77c07978351d5',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:06:17',NULL,'2025-11-28 10:06:17',NULL,NULL),(652,NULL,NULL,'f8f99474abad42d09f438e8486e8aac5',NULL,NULL,NULL,NULL,'2025-11-28 10:06:19',NULL,'2025-11-28 10:06:19',NULL,NULL),(653,NULL,'edc8731a5dd349f5916e34906416c8f6',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:06:20',NULL,'2025-11-28 10:06:20',NULL,NULL),(654,NULL,NULL,'3149cb791b864349a3ef9639d9664574',NULL,NULL,NULL,NULL,'2025-11-28 10:06:24',NULL,'2025-11-28 10:06:24',NULL,NULL),(655,NULL,NULL,'bd780e43b91a4421b44e70b1380a67a0',NULL,NULL,NULL,NULL,'2025-11-28 10:06:24',NULL,'2025-11-28 10:06:24',NULL,NULL),(656,NULL,'aff7b7030d9c4af69b909a2b53581468',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:06:26',NULL,'2025-11-28 10:06:26',NULL,NULL),(657,NULL,'d2d31a928b84446c97d35bb770c268e5',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:06:27',NULL,'2025-11-28 10:06:27',NULL,NULL),(658,NULL,NULL,'2087eeee3b234b87a20f8c5b2d97b53b',NULL,NULL,NULL,NULL,'2025-11-28 10:06:39',NULL,'2025-11-28 10:06:39',NULL,NULL),(659,NULL,NULL,'be97c4ddafb44556909c1e0abac9ef55',NULL,NULL,NULL,NULL,'2025-11-28 10:06:39',NULL,'2025-11-28 10:06:39',NULL,NULL),(660,NULL,NULL,'a057fbd9353d492fa7f6445cdcb12a39',NULL,NULL,NULL,NULL,'2025-11-28 10:06:39',NULL,'2025-11-28 10:06:39',NULL,NULL),(661,NULL,'87556d11d3894443a0252992df39cd59',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:06:41',NULL,'2025-11-28 10:06:41',NULL,NULL),(662,NULL,'030c225d7ed34b12a2a9020cd72dbf3a',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:06:43',NULL,'2025-11-28 10:06:43',NULL,NULL),(663,NULL,'bf7859f09ce4498daf51ea5d35c03e45',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:06:44',NULL,'2025-11-28 10:06:44',NULL,NULL),(664,NULL,NULL,'fcce45225cfa4ce6b64c668fe9c9cb2c',NULL,NULL,NULL,NULL,'2025-11-28 10:06:45',NULL,'2025-11-28 10:06:45',NULL,NULL),(665,NULL,'85f17f60fae2462cb663ba226772cedd',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:06:47',NULL,'2025-11-28 10:06:47',NULL,NULL),(666,NULL,NULL,'74af3073964044a9809773a20e5f4201',NULL,NULL,NULL,NULL,'2025-11-28 10:06:50',NULL,'2025-11-28 10:06:50',NULL,NULL),(667,NULL,NULL,'90084b2d3a7c4255976d70516ed70a08',NULL,NULL,NULL,NULL,'2025-11-28 10:06:52',NULL,'2025-11-28 10:06:52',NULL,NULL),(668,NULL,'8499932c523b4e26933fff84403e296e',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:06:52',NULL,'2025-11-28 10:06:52',NULL,NULL),(669,NULL,'b2dec4622fe844c592a13e779612beaa',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:06:54',NULL,'2025-11-28 10:06:54',NULL,NULL),(670,NULL,NULL,'3f2851204a0b425389ef80d7351580ba',NULL,NULL,NULL,NULL,'2025-11-28 10:06:55',NULL,'2025-11-28 10:06:55',NULL,NULL),(671,NULL,'89aab8a3cfaf48a1aacdd58fce034ea8',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:07:03',NULL,'2025-11-28 10:07:03',NULL,NULL),(672,NULL,NULL,'fdd5d9aeb097405795bc809f7d091c26',NULL,NULL,NULL,NULL,'2025-11-28 10:07:06',NULL,'2025-11-28 10:07:06',NULL,NULL),(673,NULL,'a1eb2d80861b4077b9ef4c3389f19286',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:07:10',NULL,'2025-11-28 10:07:10',NULL,NULL),(674,NULL,NULL,'a23b9285fdb048bb82226cc138cfb339',NULL,NULL,NULL,NULL,'2025-11-28 10:07:24',NULL,'2025-11-28 10:07:24',NULL,NULL),(675,NULL,'29d0d5b3ba0745d58aee3845ea704b73',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:07:25',NULL,'2025-11-28 10:07:25',NULL,NULL),(676,NULL,NULL,'883e728ccb5648cbaf84cd0cbbd59aba',NULL,NULL,NULL,NULL,'2025-11-28 10:07:27',NULL,'2025-11-28 10:07:27',NULL,NULL),(677,NULL,'7369c667b30341f7b300e32774b31181',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:07:29',NULL,'2025-11-28 10:07:29',NULL,NULL),(678,NULL,NULL,'ad2176136d4f4e5fa6103d8fa21d86ca',NULL,NULL,NULL,NULL,'2025-11-28 10:07:29',NULL,'2025-11-28 10:07:29',NULL,NULL),(679,NULL,NULL,'e32848e36ae94f66ae634ff4d7716d6f',NULL,NULL,NULL,NULL,'2025-11-28 10:07:32',NULL,'2025-11-28 10:07:32',NULL,NULL),(680,NULL,'b4ab010fc80b442f8f29d2f02f18ecc9',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:07:32',NULL,'2025-11-28 10:07:32',NULL,NULL),(681,NULL,'8462a4a9a313405e8fd212f9ec4a0c92',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:07:32',NULL,'2025-11-28 10:07:32',NULL,NULL),(682,NULL,NULL,'a1d02f85571c496fa615d761b2464703',NULL,NULL,NULL,NULL,'2025-11-28 10:07:36',NULL,'2025-11-28 10:07:36',NULL,NULL),(683,NULL,'ee6aa8c633644b158e9fe795d31a0175',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:07:38',NULL,'2025-11-28 10:07:38',NULL,NULL),(684,NULL,NULL,'37a7201bc0284463b319fc435fb52569',NULL,NULL,NULL,NULL,'2025-11-28 10:07:43',NULL,'2025-11-28 10:07:43',NULL,NULL),(685,NULL,NULL,'67612e3b1c4e49a08c92601eb6d60858',NULL,NULL,NULL,NULL,'2025-11-28 10:07:47',NULL,'2025-11-28 10:07:47',NULL,NULL),(686,NULL,NULL,'cffa139c406d4127918aad4c001ef0ab',NULL,NULL,NULL,NULL,'2025-11-28 10:07:50',NULL,'2025-11-28 10:07:50',NULL,NULL),(687,NULL,'7dd88588dc3b46ab8658061b1ac13996',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:07:51',NULL,'2025-11-28 10:07:51',NULL,NULL),(688,NULL,NULL,'1cfd6459891e4d3ca56f91c4edbd0b7a',NULL,NULL,NULL,NULL,'2025-11-28 10:07:51',NULL,'2025-11-28 10:07:51',NULL,NULL),(689,NULL,NULL,'f802db1a51604b1dbdd96ee766d48fa6',NULL,NULL,NULL,NULL,'2025-11-28 10:07:51',NULL,'2025-11-28 10:07:51',NULL,NULL),(690,NULL,NULL,'60a0061fff1842b898c067834f6b0b0d',NULL,NULL,NULL,NULL,'2025-11-28 10:07:52',NULL,'2025-11-28 10:07:52',NULL,NULL),(691,NULL,NULL,'1a09ced33a70401784acd0da1556fc5c',NULL,NULL,NULL,NULL,'2025-11-28 10:07:52',NULL,'2025-11-28 10:07:52',NULL,NULL),(692,NULL,NULL,'6b80a7d6f65f4ebe8363ccaae26f3e87',NULL,NULL,NULL,NULL,'2025-11-28 10:07:52',NULL,'2025-11-28 10:07:52',NULL,NULL),(693,NULL,NULL,'fc238af5830b477c97af65a2b1686a54',NULL,NULL,NULL,NULL,'2025-11-28 10:07:53',NULL,'2025-11-28 10:07:53',NULL,NULL),(694,NULL,NULL,'646af4638a054ec4b7eb9e5438a2ab60',NULL,NULL,NULL,NULL,'2025-11-28 10:07:54',NULL,'2025-11-28 10:07:54',NULL,NULL),(695,NULL,'74dd3f57c2cc4046814a4d262ad8dca8',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:07:54',NULL,'2025-11-28 10:07:54',NULL,NULL),(696,NULL,'ae10569a38284f298c961498da620c5f',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:07:54',NULL,'2025-11-28 10:07:54',NULL,NULL),(697,NULL,NULL,'083d0ba1630b4d97846f3cc648dc6251',NULL,NULL,NULL,NULL,'2025-11-28 10:07:54',NULL,'2025-11-28 10:07:54',NULL,NULL),(698,NULL,'abc4c747e68d44fbb8317bb86ed8c6d8',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:07:54',NULL,'2025-11-28 10:07:54',NULL,NULL),(699,NULL,'a569d731bef04fb89d34131fc9ebf2c6',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:07:55',NULL,'2025-11-28 10:07:55',NULL,NULL),(700,NULL,'5e7a07c97c664076bc825e05137c574c',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:07:55',NULL,'2025-11-28 10:07:55',NULL,NULL),(701,NULL,'0fe88735f93e44e5be8e4734b052914c',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:07:55',NULL,'2025-11-28 10:07:55',NULL,NULL),(702,NULL,'44e47888bf384f2290cbd80a83fd1322',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:07:55',NULL,'2025-11-28 10:07:55',NULL,NULL),(703,NULL,'ea7bdd98a9904e47a2dfed5bcc54bc4a',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:07:55',NULL,'2025-11-28 10:07:55',NULL,NULL),(704,NULL,'e1e8edf49321409fa6251c05bd4ed83a',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:07:56',NULL,'2025-11-28 10:07:56',NULL,NULL),(705,NULL,NULL,'da70a1314b9b437b926546f46890d2f1',NULL,NULL,NULL,NULL,'2025-11-28 10:08:01',NULL,'2025-11-28 10:08:01',NULL,NULL),(706,NULL,NULL,'5eb00a5b22bc4e9e90a2f6119b428b05',NULL,NULL,NULL,NULL,'2025-11-28 10:08:03',NULL,'2025-11-28 10:08:03',NULL,NULL),(707,NULL,NULL,'184f96221e1e4058860fbaf4a4be8976',NULL,NULL,NULL,NULL,'2025-11-28 10:08:03',NULL,'2025-11-28 10:08:03',NULL,NULL),(708,NULL,NULL,'48aa9aa4ed684b6caf98538e63100e49',NULL,NULL,NULL,NULL,'2025-11-28 10:08:03',NULL,'2025-11-28 10:08:03',NULL,NULL),(709,NULL,NULL,'490606f40e6646e6a6102a88d6b1a222',NULL,NULL,NULL,NULL,'2025-11-28 10:08:03',NULL,'2025-11-28 10:08:03',NULL,NULL),(710,NULL,'ae80a63945c14e9699ceafcd55584efa',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:03',NULL,'2025-11-28 10:08:03',NULL,NULL),(711,NULL,'dcd65d3dc01646ae83cc5a8394d827e7',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:05',NULL,'2025-11-28 10:08:05',NULL,NULL),(712,NULL,'0b167058632344199627e1b3de0e71dc',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:06',NULL,'2025-11-28 10:08:06',NULL,NULL),(713,NULL,'023dce3afc3746fdaf509629f2da41b0',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:07',NULL,'2025-11-28 10:08:07',NULL,NULL),(714,NULL,NULL,'6a89f5a2896d47ad962186b0b7b1a2de',NULL,NULL,NULL,NULL,'2025-11-28 10:08:08',NULL,'2025-11-28 10:08:08',NULL,NULL),(715,NULL,NULL,'dedc77f9200d4e4d8ca1155c55fc8389',NULL,NULL,NULL,NULL,'2025-11-28 10:08:08',NULL,'2025-11-28 10:08:08',NULL,NULL),(716,NULL,NULL,'584c38b1a4af4781b7fc95515cffdd52',NULL,NULL,NULL,NULL,'2025-11-28 10:08:08',NULL,'2025-11-28 10:08:08',NULL,NULL),(717,NULL,'5171816b5d3845278c70b062bedaa177',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:10',NULL,'2025-11-28 10:08:10',NULL,NULL),(718,NULL,NULL,'54f3b35e07cf4ef18a22dfd35f96616d',NULL,NULL,NULL,NULL,'2025-11-28 10:08:11',NULL,'2025-11-28 10:08:11',NULL,NULL),(719,NULL,NULL,'f56d2237e5b74576a33d9840c9346817',NULL,NULL,NULL,NULL,'2025-11-28 10:08:11',NULL,'2025-11-28 10:08:11',NULL,NULL),(720,NULL,'56ef50e311664fb78c180a36006b4502',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:12',NULL,'2025-11-28 10:08:12',NULL,NULL),(721,NULL,'1a102f2199154c01ba49e2af38e4fc0a',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:12',NULL,'2025-11-28 10:08:12',NULL,NULL),(722,NULL,'9ce143270a4649669232b53b6a44e4ba',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:13',NULL,'2025-11-28 10:08:13',NULL,NULL),(723,NULL,NULL,'cedb40889fbd4a029cbd1938fd1266ee',NULL,NULL,NULL,NULL,'2025-11-28 10:08:13',NULL,'2025-11-28 10:08:13',NULL,NULL),(724,NULL,'6f9594f9fb704068b77cd4ff3489e542',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:13',NULL,'2025-11-28 10:08:13',NULL,NULL),(725,NULL,NULL,'87cf17c48bab44279b2e7eca9e0882a2',NULL,NULL,NULL,NULL,'2025-11-28 10:08:13',NULL,'2025-11-28 10:08:13',NULL,NULL),(726,NULL,'d3c0d1ce8d854a7b9ffc953e88cd2c44',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:14',NULL,'2025-11-28 10:08:14',NULL,NULL),(727,NULL,'8c33f10ccf134f4faab82ed622e3c707',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:14',NULL,'2025-11-28 10:08:14',NULL,NULL),(728,NULL,NULL,'98015f849ce5423d83599c846511f268',NULL,NULL,NULL,NULL,'2025-11-28 10:08:15',NULL,'2025-11-28 10:08:15',NULL,NULL),(729,NULL,NULL,'4946fab2fc3e4b6a824c5b97d5395e1f',NULL,NULL,NULL,NULL,'2025-11-28 10:08:15',NULL,'2025-11-28 10:08:15',NULL,NULL),(730,NULL,'ed1e45c023a5404a97377641c4a6c580',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:17',NULL,'2025-11-28 10:08:17',NULL,NULL),(731,NULL,'6aa84c7049ec4634978c2f2583d7c1dd',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:17',NULL,'2025-11-28 10:08:17',NULL,NULL),(732,NULL,NULL,'549d4450b5cb44db8ee84d1c9b56ca52',NULL,NULL,NULL,NULL,'2025-11-28 10:08:18',NULL,'2025-11-28 10:08:18',NULL,NULL),(733,NULL,NULL,'dd3d6ee631864db6ae89c23bd3d41d1f',NULL,NULL,NULL,NULL,'2025-11-28 10:08:18',NULL,'2025-11-28 10:08:18',NULL,NULL),(734,NULL,'ca6dc7d8b4734b17b7b7b17d1c736669',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:19',NULL,'2025-11-28 10:08:19',NULL,NULL),(735,NULL,'2911e2d698514fdeab8610aa96485c01',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:20',NULL,'2025-11-28 10:08:20',NULL,NULL),(736,NULL,NULL,'397ae286549f4936afa2820dae60ba57',NULL,NULL,NULL,NULL,'2025-11-28 10:08:20',NULL,'2025-11-28 10:08:20',NULL,NULL),(737,NULL,'3b3a94b107524e81a6368eb9596632ef',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:21',NULL,'2025-11-28 10:08:21',NULL,NULL),(738,NULL,NULL,'928984aba4ca475bae7e743997b5e87f',NULL,NULL,NULL,NULL,'2025-11-28 10:08:22',NULL,'2025-11-28 10:08:22',NULL,NULL),(739,NULL,NULL,'290c95bac4f44f9daecb4d5fbd5ae05f',NULL,NULL,NULL,NULL,'2025-11-28 10:08:22',NULL,'2025-11-28 10:08:22',NULL,NULL),(740,NULL,NULL,'c513c158568240f4823ba51d0af1ad53',NULL,NULL,NULL,NULL,'2025-11-28 10:08:22',NULL,'2025-11-28 10:08:22',NULL,NULL),(741,NULL,NULL,'67a07c82c81046698514ac5fa7571a75',NULL,NULL,NULL,NULL,'2025-11-28 10:08:22',NULL,'2025-11-28 10:08:22',NULL,NULL),(742,NULL,'00f7f96da8e44b0684f1351735dac562',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:23',NULL,'2025-11-28 10:08:23',NULL,NULL),(743,NULL,NULL,'eeaddc83b1fd49a883a82168934c872b',NULL,NULL,NULL,NULL,'2025-11-28 10:08:23',NULL,'2025-11-28 10:08:23',NULL,NULL),(744,NULL,'ccbf5149212849408d2ab4e8af858080',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:24',NULL,'2025-11-28 10:08:24',NULL,NULL),(745,NULL,'355bd44b363d4120835742c05aa32477',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:25',NULL,'2025-11-28 10:08:25',NULL,NULL),(746,NULL,'eaacddd7c7ae44869632c24b4e5d2d1b',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:25',NULL,'2025-11-28 10:08:25',NULL,NULL),(747,NULL,NULL,'b3ad92f082324bf2b498b6ec57fa1994',NULL,NULL,NULL,NULL,'2025-11-28 10:08:25',NULL,'2025-11-28 10:08:25',NULL,NULL),(748,NULL,NULL,'1f9281b9a78649359bbe8f6081cce80f',NULL,NULL,NULL,NULL,'2025-11-28 10:08:25',NULL,'2025-11-28 10:08:25',NULL,NULL),(749,NULL,NULL,'d00591a3ea0a49e4a6b4f6412a179daf',NULL,NULL,NULL,NULL,'2025-11-28 10:08:25',NULL,'2025-11-28 10:08:25',NULL,NULL),(750,NULL,NULL,'89a7507e31c74b6c8a76cc1c3acd2585',NULL,NULL,NULL,NULL,'2025-11-28 10:08:26',NULL,'2025-11-28 10:08:26',NULL,NULL),(751,NULL,NULL,'2d65c21983fa4a008a09c7a8bb7a6484',NULL,NULL,NULL,NULL,'2025-11-28 10:08:26',NULL,'2025-11-28 10:08:26',NULL,NULL),(752,NULL,'f4aa6a98849143efbe0d34d745657eb8',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:26',NULL,'2025-11-28 10:08:26',NULL,NULL),(753,NULL,NULL,'2e098820236b47dbb210a0ac5c812f3e',NULL,NULL,NULL,NULL,'2025-11-28 10:08:27',NULL,'2025-11-28 10:08:27',NULL,NULL),(754,NULL,'9d7aad7439d04fac877f2e8da638e43b',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:27',NULL,'2025-11-28 10:08:27',NULL,NULL),(755,NULL,'2603cf17f09846a397a42aba4be9d81b',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:27',NULL,'2025-11-28 10:08:27',NULL,NULL),(756,NULL,'b75145391b1642aa86ac346010612ae1',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:28',NULL,'2025-11-28 10:08:28',NULL,NULL),(757,NULL,'a7a35fd1ae2d46c1995f8a1ce8b08ad1',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:28',NULL,'2025-11-28 10:08:28',NULL,NULL),(758,NULL,'e40ad514f1414282aba0c087f08f4797',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:28',NULL,'2025-11-28 10:08:28',NULL,NULL),(759,NULL,NULL,'5de4dd7908fb49eb9d6e27edc2c641f7',NULL,NULL,NULL,NULL,'2025-11-28 10:08:30',NULL,'2025-11-28 10:08:30',NULL,NULL),(760,NULL,'337cbee558934919bc9ec34449f79f09',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:31',NULL,'2025-11-28 10:08:31',NULL,NULL),(761,NULL,NULL,'23ad49b44ba343c7a7084a420bf4bea8',NULL,NULL,NULL,NULL,'2025-11-28 10:08:33',NULL,'2025-11-28 10:08:33',NULL,NULL),(762,NULL,NULL,'e5be30b3d0cc415685a54a84cdb58919',NULL,NULL,NULL,NULL,'2025-11-28 10:08:33',NULL,'2025-11-28 10:08:33',NULL,NULL),(763,NULL,NULL,'66d08c64d503469287840f6e04a7ff27',NULL,NULL,NULL,NULL,'2025-11-28 10:08:33',NULL,'2025-11-28 10:08:33',NULL,NULL),(764,NULL,NULL,'204e4aad7e2340eebed299dd8030708b',NULL,NULL,NULL,NULL,'2025-11-28 10:08:34',NULL,'2025-11-28 10:08:34',NULL,NULL),(765,NULL,'b1155d9e62f747aab975f341b5b53a22',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:35',NULL,'2025-11-28 10:08:35',NULL,NULL),(766,NULL,'7a8312880dff46f58cc561061ee4ce98',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:35',NULL,'2025-11-28 10:08:35',NULL,NULL),(767,NULL,'6732fa86445147cdb019a2189d601a62',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:35',NULL,'2025-11-28 10:08:35',NULL,NULL),(768,NULL,'5d376e9be28e42989eb535743d072e5e',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:36',NULL,'2025-11-28 10:08:36',NULL,NULL),(769,NULL,NULL,'af5b23808fe14f21a1025d9d48164f85',NULL,NULL,NULL,NULL,'2025-11-28 10:08:36',NULL,'2025-11-28 10:08:36',NULL,NULL),(770,NULL,'79cbcb0957f54ef09645577668ab7937',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:37',NULL,'2025-11-28 10:08:37',NULL,NULL),(771,NULL,NULL,'91322660e72c446aa7c83fe69bf7c110',NULL,NULL,NULL,NULL,'2025-11-28 10:08:37',NULL,'2025-11-28 10:08:37',NULL,NULL),(772,NULL,NULL,'5417d84395284ff3946139ec82755956',NULL,NULL,NULL,NULL,'2025-11-28 10:08:38',NULL,'2025-11-28 10:08:38',NULL,NULL),(773,NULL,NULL,'7b566f8cb0d949bc89f5b8706fa7ef3f',NULL,NULL,NULL,NULL,'2025-11-28 10:08:38',NULL,'2025-11-28 10:08:38',NULL,NULL),(774,NULL,NULL,'6428f71284f34711a5567db1ae6bc752',NULL,NULL,NULL,NULL,'2025-11-28 10:08:38',NULL,'2025-11-28 10:08:38',NULL,NULL),(775,NULL,'57d392ac9c2d4241830508232b59efc1',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:38',NULL,'2025-11-28 10:08:38',NULL,NULL),(776,NULL,'8df0fb1c05454b0395ad878c5f470a48',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:39',NULL,'2025-11-28 10:08:39',NULL,NULL),(777,NULL,'0de8f13c45d947008f128502ce7ba7d3',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:39',NULL,'2025-11-28 10:08:39',NULL,NULL),(778,NULL,NULL,'3da1676c16cc482db7b290c01ed53c8f',NULL,NULL,NULL,NULL,'2025-11-28 10:08:40',NULL,'2025-11-28 10:08:40',NULL,NULL),(779,NULL,NULL,'2315bba485384453a102e8ab0bc846db',NULL,NULL,NULL,NULL,'2025-11-28 10:08:40',NULL,'2025-11-28 10:08:40',NULL,NULL),(780,NULL,'708e5a4db87c470c994eb117a4c58083',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:40',NULL,'2025-11-28 10:08:40',NULL,NULL),(781,NULL,'7643dd1626e04b34b6998a83d430a82e',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:42',NULL,'2025-11-28 10:08:42',NULL,NULL),(782,NULL,'8af180e32fd442ec9753388c1a2b9ec9',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:42',NULL,'2025-11-28 10:08:42',NULL,NULL),(783,NULL,NULL,'dbb930f9410646ec834a7f181982a729',NULL,NULL,NULL,NULL,'2025-11-28 10:08:43',NULL,'2025-11-28 10:08:43',NULL,NULL),(784,NULL,NULL,'320c6105df99406cbb307643d76a4b6c',NULL,NULL,NULL,NULL,'2025-11-28 10:08:43',NULL,'2025-11-28 10:08:43',NULL,NULL),(785,NULL,NULL,'cdd34958e13c4d2c84819f77a74b08d9',NULL,NULL,NULL,NULL,'2025-11-28 10:08:43',NULL,'2025-11-28 10:08:43',NULL,NULL),(786,NULL,NULL,'a089a928ea464f7b9816886d792707c7',NULL,NULL,NULL,NULL,'2025-11-28 10:08:43',NULL,'2025-11-28 10:08:43',NULL,NULL),(787,NULL,NULL,'f628267034e046f0b3f47723bdd203b9',NULL,NULL,NULL,NULL,'2025-11-28 10:08:44',NULL,'2025-11-28 10:08:44',NULL,NULL),(788,NULL,'43b8e09a28f248f7890a4355af86b60b',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:44',NULL,'2025-11-28 10:08:44',NULL,NULL),(789,NULL,NULL,'d027e3580b9044f3b4c3dd7a2c6a77f2',NULL,NULL,NULL,NULL,'2025-11-28 10:08:44',NULL,'2025-11-28 10:08:44',NULL,NULL),(790,NULL,NULL,'2f069ad9e0214a89ae6c4ad4c0955826',NULL,NULL,NULL,NULL,'2025-11-28 10:08:45',NULL,'2025-11-28 10:08:45',NULL,NULL),(791,NULL,'2af0b29df73f4400ab9f9acab7e1612e',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:45',NULL,'2025-11-28 10:08:45',NULL,NULL),(792,NULL,'2fdb65e99ec144ef821d311006e30908',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:45',NULL,'2025-11-28 10:08:45',NULL,NULL),(793,NULL,'9acc2adaee49410fb3cb9acd812a852a',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:45',NULL,'2025-11-28 10:08:45',NULL,NULL),(794,NULL,'5427e3a4eee74364a4f24a662f405a71',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:46',NULL,'2025-11-28 10:08:46',NULL,NULL),(795,NULL,'b0c7de338cba44dbbca7ba17c09841ff',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:46',NULL,'2025-11-28 10:08:46',NULL,NULL),(796,NULL,NULL,'5b5c4ae6c8044d868e84a781f378f7e7',NULL,NULL,NULL,NULL,'2025-11-28 10:08:47',NULL,'2025-11-28 10:08:47',NULL,NULL),(797,NULL,'46a8a74dd94d45d3ace6b003925252fc',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:48',NULL,'2025-11-28 10:08:48',NULL,NULL),(798,NULL,NULL,'e2f26fe9b8734c0fa7e6c6447c03e8e2',NULL,NULL,NULL,NULL,'2025-11-28 10:08:49',NULL,'2025-11-28 10:08:49',NULL,NULL),(799,NULL,NULL,'096b825723f54f7e9a05a421ec92257e',NULL,NULL,NULL,NULL,'2025-11-28 10:08:49',NULL,'2025-11-28 10:08:49',NULL,NULL),(800,NULL,NULL,'a4d4e735c95040e6924dc6e4489b0678',NULL,NULL,NULL,NULL,'2025-11-28 10:08:49',NULL,'2025-11-28 10:08:49',NULL,NULL),(801,NULL,'fa43b66fb64742319307c393a8613a34',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:50',NULL,'2025-11-28 10:08:50',NULL,NULL),(802,NULL,NULL,'a7746e0e81da48a1966961e2b1327e89',NULL,NULL,NULL,NULL,'2025-11-28 10:08:50',NULL,'2025-11-28 10:08:50',NULL,NULL),(803,NULL,'db6f23e35315445fae8a31809a066611',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:50',NULL,'2025-11-28 10:08:50',NULL,NULL),(804,NULL,NULL,'9f195c7e6aa347d4966c7781cadc2cee',NULL,NULL,NULL,NULL,'2025-11-28 10:08:51',NULL,'2025-11-28 10:08:51',NULL,NULL),(805,NULL,NULL,'ce60ff28afda42c7997df6074ac902be',NULL,NULL,NULL,NULL,'2025-11-28 10:08:51',NULL,'2025-11-28 10:08:51',NULL,NULL),(806,NULL,'d3d48eb324b44187aace233b3e63324a',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:51',NULL,'2025-11-28 10:08:51',NULL,NULL),(807,NULL,'cd8b68f220e743118869e800835250db',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:51',NULL,'2025-11-28 10:08:51',NULL,NULL),(808,NULL,'a6f735cf317e42218560e5eb75b569f6',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:52',NULL,'2025-11-28 10:08:52',NULL,NULL),(809,NULL,'8a4c114d5adc48b59a5cc028fb41d8f8',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:52',NULL,'2025-11-28 10:08:52',NULL,NULL),(810,NULL,NULL,'fb7c8f09a45e480e8b0b39091e94d6b0',NULL,NULL,NULL,NULL,'2025-11-28 10:08:55',NULL,'2025-11-28 10:08:55',NULL,NULL),(811,NULL,NULL,'2c9cf04d80854625937382a24a03de76',NULL,NULL,NULL,NULL,'2025-11-28 10:08:55',NULL,'2025-11-28 10:08:55',NULL,NULL),(812,NULL,NULL,'3943530c4c8b4d35b61c14cdd3dbd5c2',NULL,NULL,NULL,NULL,'2025-11-28 10:08:56',NULL,'2025-11-28 10:08:56',NULL,NULL),(813,NULL,'282cf5c7f55f44abb1217a52fa10743f',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:57',NULL,'2025-11-28 10:08:57',NULL,NULL),(814,NULL,NULL,'563b9a11bd714046bd8a1337a204eee6',NULL,NULL,NULL,NULL,'2025-11-28 10:08:57',NULL,'2025-11-28 10:08:57',NULL,NULL),(815,NULL,NULL,'1be7f690fcc84f3792d4ed90d3d021e3',NULL,NULL,NULL,NULL,'2025-11-28 10:08:57',NULL,'2025-11-28 10:08:57',NULL,NULL),(816,NULL,'e7cc91f8f0484d558c7d91f23a229370',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:57',NULL,'2025-11-28 10:08:57',NULL,NULL),(817,NULL,NULL,'2573dff6558c49da9f5a8734356472dd',NULL,NULL,NULL,NULL,'2025-11-28 10:08:57',NULL,'2025-11-28 10:08:57',NULL,NULL),(818,NULL,NULL,'4dc754b220f84a609f3f7d67e318f8fc',NULL,NULL,NULL,NULL,'2025-11-28 10:08:57',NULL,'2025-11-28 10:08:57',NULL,NULL),(819,NULL,NULL,'fbaa01834d0f43deb2abe5a919efb1a0',NULL,NULL,NULL,NULL,'2025-11-28 10:08:57',NULL,'2025-11-28 10:08:57',NULL,NULL),(820,NULL,NULL,'3c7061945daf4c41bfb3eb3d7862e9f1',NULL,NULL,NULL,NULL,'2025-11-28 10:08:58',NULL,'2025-11-28 10:08:58',NULL,NULL),(821,NULL,NULL,'fea7bbcaf8f54a6898ff53cda564e490',NULL,NULL,NULL,NULL,'2025-11-28 10:08:58',NULL,'2025-11-28 10:08:58',NULL,NULL),(822,NULL,NULL,'8f3b6c0d761f4a16834e9542dde4448d',NULL,NULL,NULL,NULL,'2025-11-28 10:08:58',NULL,'2025-11-28 10:08:58',NULL,NULL),(823,NULL,'60fc9706f1de4854ba28dcf33c0e4aa9',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:58',NULL,'2025-11-28 10:08:58',NULL,NULL),(824,NULL,'bfbdaa7c0452458faa54b9e8c546ad15',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:59',NULL,'2025-11-28 10:08:59',NULL,NULL),(825,NULL,'8e2080a7d3e6485281f64ef53c35b0cf',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:59',NULL,'2025-11-28 10:08:59',NULL,NULL),(826,NULL,'8e0ee0c4ca0f4a53b4a2131c47577548',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:59',NULL,'2025-11-28 10:08:59',NULL,NULL),(827,NULL,'c1c4ecd48c654f85b98d7f86e45ad517',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:08:59',NULL,'2025-11-28 10:08:59',NULL,NULL),(828,NULL,'7b0f6782d0fb431b9fae9ffd3abbcba9',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:00',NULL,'2025-11-28 10:09:00',NULL,NULL),(829,NULL,'d8bb5df4ce1c44cb803a4b7357dea0f9',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:00',NULL,'2025-11-28 10:09:00',NULL,NULL),(830,NULL,NULL,'d7b125136014403fb045eae0db96b386',NULL,NULL,NULL,NULL,'2025-11-28 10:09:00',NULL,'2025-11-28 10:09:00',NULL,NULL),(831,NULL,NULL,'fe480c46a540470ebb93e2290dfcc729',NULL,NULL,NULL,NULL,'2025-11-28 10:09:00',NULL,'2025-11-28 10:09:00',NULL,NULL),(832,NULL,'f85d8ffada2842738a1307658c19c621',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:01',NULL,'2025-11-28 10:09:01',NULL,NULL),(833,NULL,NULL,'65e0ec2332604f95938ebc6579431fed',NULL,NULL,NULL,NULL,'2025-11-28 10:09:01',NULL,'2025-11-28 10:09:01',NULL,NULL),(834,NULL,'0b12b88697fa4592ab5f0a69e470a369',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:02',NULL,'2025-11-28 10:09:02',NULL,NULL),(835,NULL,'18d9dcca520543cb91fca27cd99187b3',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:02',NULL,'2025-11-28 10:09:02',NULL,NULL),(836,NULL,NULL,'5503f91f9baa4e78a17baa7dac901d6f',NULL,NULL,NULL,NULL,'2025-11-28 10:09:04',NULL,'2025-11-28 10:09:04',NULL,NULL),(837,NULL,NULL,'463f0a482daf45f1b54b00148c9c0291',NULL,NULL,NULL,NULL,'2025-11-28 10:09:04',NULL,'2025-11-28 10:09:04',NULL,NULL),(838,NULL,NULL,'681a898abdc741a487d051592f131465',NULL,NULL,NULL,NULL,'2025-11-28 10:09:04',NULL,'2025-11-28 10:09:04',NULL,NULL),(839,NULL,NULL,'8c8bbd4325d54a30a3e49517be4e8eee',NULL,NULL,NULL,NULL,'2025-11-28 10:09:05',NULL,'2025-11-28 10:09:05',NULL,NULL),(840,NULL,'64fe2e3bbbb14685a941e1fe12015357',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:05',NULL,'2025-11-28 10:09:05',NULL,NULL),(841,NULL,NULL,'7c406c0683144ca1be11720f47d550be',NULL,NULL,NULL,NULL,'2025-11-28 10:09:05',NULL,'2025-11-28 10:09:05',NULL,NULL),(842,NULL,NULL,'22f032ec5e9840e3b493e5e8ab8cca25',NULL,NULL,NULL,NULL,'2025-11-28 10:09:05',NULL,'2025-11-28 10:09:05',NULL,NULL),(843,NULL,'f925cfb2990e48e2982c1632dfb9635d',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:06',NULL,'2025-11-28 10:09:06',NULL,NULL),(844,NULL,'85b0cd4fbc9547ea80ee82fddaeca666',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:06',NULL,'2025-11-28 10:09:06',NULL,NULL),(845,NULL,'3f91e76373a34e0880a287181873b7a3',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:06',NULL,'2025-11-28 10:09:06',NULL,NULL),(846,NULL,'af627bb6800b48f795f524c5240dd96e',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:06',NULL,'2025-11-28 10:09:06',NULL,NULL),(847,NULL,'fca2a7b4592f411ea0dc0e6a9a25fb72',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:06',NULL,'2025-11-28 10:09:06',NULL,NULL),(848,NULL,'1e6514b9bc3f4f8a8c0b6e51b488a43d',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:07',NULL,'2025-11-28 10:09:07',NULL,NULL),(849,NULL,NULL,'e3c99f9fe4d541e6b1670e0d113fcd19',NULL,NULL,NULL,NULL,'2025-11-28 10:09:09',NULL,'2025-11-28 10:09:09',NULL,NULL),(850,NULL,NULL,'a23d1ae8b6bb4b148707617b2d4f0173',NULL,NULL,NULL,NULL,'2025-11-28 10:09:09',NULL,'2025-11-28 10:09:09',NULL,NULL),(851,NULL,'fc7fccbd32a74bc3b7becd3530d9005e',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:10',NULL,'2025-11-28 10:09:10',NULL,NULL),(852,NULL,NULL,'595152befc2142d4a554b02dcbccc474',NULL,NULL,NULL,NULL,'2025-11-28 10:09:10',NULL,'2025-11-28 10:09:10',NULL,NULL),(853,NULL,NULL,'157d18a0bd724c588ae748751ed2ae67',NULL,NULL,NULL,NULL,'2025-11-28 10:09:10',NULL,'2025-11-28 10:09:10',NULL,NULL),(854,NULL,NULL,'d300e3097daf46baa7cb78b365376384',NULL,NULL,NULL,NULL,'2025-11-28 10:09:10',NULL,'2025-11-28 10:09:10',NULL,NULL),(855,NULL,'5bdc2310db3b4da0a6d98b320aa85f31',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:10',NULL,'2025-11-28 10:09:10',NULL,NULL),(856,NULL,NULL,'69113aece8cd4200aad9ea2eecf0a1e3',NULL,NULL,NULL,NULL,'2025-11-28 10:09:10',NULL,'2025-11-28 10:09:10',NULL,NULL),(857,NULL,NULL,'f3ec0532b0174ad4b1f93201a8ad0aca',NULL,NULL,NULL,NULL,'2025-11-28 10:09:11',NULL,'2025-11-28 10:09:11',NULL,NULL),(858,NULL,'85b11b708e1b4e3895328aa79d491067',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:12',NULL,'2025-11-28 10:09:12',NULL,NULL),(859,NULL,'229e379b5cea42ea9163c9c6c335adab',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:12',NULL,'2025-11-28 10:09:12',NULL,NULL),(860,NULL,'8406d97038404cb68fb843f52a7bfbad',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:13',NULL,'2025-11-28 10:09:13',NULL,NULL),(861,NULL,'738bcaf9dc11446880fa6a03f358842b',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:13',NULL,'2025-11-28 10:09:13',NULL,NULL),(862,NULL,NULL,'67e2445009bb4f0f8f7daf92e0d698b8',NULL,NULL,NULL,NULL,'2025-11-28 10:09:13',NULL,'2025-11-28 10:09:13',NULL,NULL),(863,NULL,NULL,'39d8bd469b3141e295fb70d5b9418898',NULL,NULL,NULL,NULL,'2025-11-28 10:09:13',NULL,'2025-11-28 10:09:13',NULL,NULL),(864,NULL,'c34b37048cc14da680ee18ebff690d24',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:14',NULL,'2025-11-28 10:09:14',NULL,NULL),(865,NULL,'6da8102120594d6c98901d137ca0bc9b',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:15',NULL,'2025-11-28 10:09:15',NULL,NULL),(866,NULL,NULL,'571c8db1d62c42b2a968a166578b720c',NULL,NULL,NULL,NULL,'2025-11-28 10:09:17',NULL,'2025-11-28 10:09:17',NULL,NULL),(867,NULL,'761c122e3fe94bb6be6f10c7921c5430',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:18',NULL,'2025-11-28 10:09:18',NULL,NULL),(868,NULL,NULL,'082c93c777ef461fa468dec4d8ee6c5c',NULL,NULL,NULL,NULL,'2025-11-28 10:09:20',NULL,'2025-11-28 10:09:20',NULL,NULL),(869,NULL,NULL,'79b441a1fd154f7c9c86fbfe93791f2d',NULL,NULL,NULL,NULL,'2025-11-28 10:09:21',NULL,'2025-11-28 10:09:21',NULL,NULL),(870,NULL,NULL,'8c50454275f240429f5da523281376df',NULL,NULL,NULL,NULL,'2025-11-28 10:09:21',NULL,'2025-11-28 10:09:21',NULL,NULL),(871,NULL,'032453f27c1041d9b3bfb29a8365ddcc',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:21',NULL,'2025-11-28 10:09:21',NULL,NULL),(872,NULL,NULL,'f1cb496e64624f0aac9d25aa9ab06dc6',NULL,NULL,NULL,NULL,'2025-11-28 10:09:21',NULL,'2025-11-28 10:09:21',NULL,NULL),(873,NULL,NULL,'df35df42c1e54f2f9c11569598196825',NULL,NULL,NULL,NULL,'2025-11-28 10:09:21',NULL,'2025-11-28 10:09:21',NULL,NULL),(874,NULL,NULL,'0c582186c0ed48b5b46bde7689b3c440',NULL,NULL,NULL,NULL,'2025-11-28 10:09:22',NULL,'2025-11-28 10:09:22',NULL,NULL),(875,NULL,'5b387b21e944465fab5a6c519e7144b0',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:22',NULL,'2025-11-28 10:09:22',NULL,NULL),(876,NULL,NULL,'b4f253dd53c54043a43353fe20d0964d',NULL,NULL,NULL,NULL,'2025-11-28 10:09:22',NULL,'2025-11-28 10:09:22',NULL,NULL),(877,NULL,'226708802ce3437782709fd7cec0d96e',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:23',NULL,'2025-11-28 10:09:23',NULL,NULL),(878,NULL,NULL,'5fdb619b68d64778b7ea0e6d95f375d9',NULL,NULL,NULL,NULL,'2025-11-28 10:09:23',NULL,'2025-11-28 10:09:23',NULL,NULL),(879,NULL,'12b605b0706b49d7b50bd67675f75239',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:23',NULL,'2025-11-28 10:09:23',NULL,NULL),(880,NULL,'2ae137d178b746b480ca3630e24b5bcf',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:23',NULL,'2025-11-28 10:09:23',NULL,NULL),(881,NULL,'673b477f9d70449480701aa9846d8f60',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:23',NULL,'2025-11-28 10:09:23',NULL,NULL),(882,NULL,'b72f88647ae54409a4d084be9e4f2be0',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:24',NULL,'2025-11-28 10:09:24',NULL,NULL),(883,NULL,NULL,'734ab171f3e74a6888b27f8bfe048473',NULL,NULL,NULL,NULL,'2025-11-28 10:09:25',NULL,'2025-11-28 10:09:25',NULL,NULL),(884,NULL,NULL,'753e3ea5beac47d7b44700a6136ca97b',NULL,NULL,NULL,NULL,'2025-11-28 10:09:25',NULL,'2025-11-28 10:09:25',NULL,NULL),(885,NULL,'e67c42de6de84a6eba7382934e59b9b3',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:26',NULL,'2025-11-28 10:09:26',NULL,NULL),(886,NULL,'d1fe23f2ac0f4241a0dffd79eea47929',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:27',NULL,'2025-11-28 10:09:27',NULL,NULL),(887,NULL,NULL,'7dda0cb163d64baba58939c0be1f46de',NULL,NULL,NULL,NULL,'2025-11-28 10:09:29',NULL,'2025-11-28 10:09:29',NULL,NULL),(888,NULL,NULL,'33b9fa1e557c44df9219e33ff434f7a1',NULL,NULL,NULL,NULL,'2025-11-28 10:09:29',NULL,'2025-11-28 10:09:29',NULL,NULL),(889,NULL,NULL,'5852e30ca4414e0785d0e7ac3245a88a',NULL,NULL,NULL,NULL,'2025-11-28 10:09:29',NULL,'2025-11-28 10:09:29',NULL,NULL),(890,NULL,NULL,'eac5033731f7487c99638cf0999e6ba3',NULL,NULL,NULL,NULL,'2025-11-28 10:09:30',NULL,'2025-11-28 10:09:30',NULL,NULL),(891,NULL,NULL,'58cc6965aadd442d975403cf22bc9e81',NULL,NULL,NULL,NULL,'2025-11-28 10:09:30',NULL,'2025-11-28 10:09:30',NULL,NULL),(892,NULL,'a524d5c59c0141378af851722d81d7bc',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:31',NULL,'2025-11-28 10:09:31',NULL,NULL),(893,NULL,'640be86558c44c7dbb6178d68c7c0e51',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:32',NULL,'2025-11-28 10:09:32',NULL,NULL),(894,NULL,'aeb35c30d5ac4722ba47a5d5cee07953',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:32',NULL,'2025-11-28 10:09:32',NULL,NULL),(895,NULL,NULL,'5486f77258744d0f93a0c1f0b9cfc752',NULL,NULL,NULL,NULL,'2025-11-28 10:09:33',NULL,'2025-11-28 10:09:33',NULL,NULL),(896,NULL,'27cbd94fc85e4c0c951e913640de9721',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:33',NULL,'2025-11-28 10:09:33',NULL,NULL),(897,NULL,'920ed4871b934d73a098bd5de9da3a34',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:34',NULL,'2025-11-28 10:09:34',NULL,NULL),(898,NULL,NULL,'7f1b90eec6204d12bac6f797d6748a53',NULL,NULL,NULL,NULL,'2025-11-28 10:09:43',NULL,'2025-11-28 10:09:43',NULL,NULL),(899,NULL,NULL,'d73cf1135d49436897cbfb435039e1ba',NULL,NULL,NULL,NULL,'2025-11-28 10:09:45',NULL,'2025-11-28 10:09:45',NULL,NULL),(900,NULL,NULL,'b208c649583047b082c9e6544837a732',NULL,NULL,NULL,NULL,'2025-11-28 10:09:46',NULL,'2025-11-28 10:09:46',NULL,NULL),(901,NULL,NULL,'36119fcdb1254f13aa4fdb537ace352c',NULL,NULL,NULL,NULL,'2025-11-28 10:09:46',NULL,'2025-11-28 10:09:46',NULL,NULL),(902,NULL,'140d992a075d4f1886445e3c1f7f4e58',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:46',NULL,'2025-11-28 10:09:46',NULL,NULL),(903,NULL,NULL,'c6c04037ddce4b068df4a5875ae176f6',NULL,NULL,NULL,NULL,'2025-11-28 10:09:46',NULL,'2025-11-28 10:09:46',NULL,NULL),(904,NULL,'410e335578834258b6cf71ca3ea642ab',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:47',NULL,'2025-11-28 10:09:47',NULL,NULL),(905,NULL,'f4ba15859d884126ad01452244214a25',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:48',NULL,'2025-11-28 10:09:48',NULL,NULL),(906,NULL,NULL,'b573ad48f0fa46dba115411f601c7e6c',NULL,NULL,NULL,NULL,'2025-11-28 10:09:48',NULL,'2025-11-28 10:09:48',NULL,NULL),(907,NULL,NULL,'ecc9f47db40c4d5cac6c86eb6ab064a6',NULL,NULL,NULL,NULL,'2025-11-28 10:09:48',NULL,'2025-11-28 10:09:48',NULL,NULL),(908,NULL,'b1551f23d1de4927bb7aa64f10c9091e',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:48',NULL,'2025-11-28 10:09:48',NULL,NULL),(909,NULL,NULL,'d695349bee344dfbbced1de2bcceb2ed',NULL,NULL,NULL,NULL,'2025-11-28 10:09:49',NULL,'2025-11-28 10:09:49',NULL,NULL),(910,NULL,NULL,'93f119b9085348aea6cded2c532c4c9e',NULL,NULL,NULL,NULL,'2025-11-28 10:09:49',NULL,'2025-11-28 10:09:49',NULL,NULL),(911,NULL,NULL,'152fc536b0154249a3868f97180c8fed',NULL,NULL,NULL,NULL,'2025-11-28 10:09:50',NULL,'2025-11-28 10:09:50',NULL,NULL),(912,NULL,'af2ef0576c374a64b15c9e169211a0e0',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:50',NULL,'2025-11-28 10:09:50',NULL,NULL),(913,NULL,'597cc112de0e4ec09ecca2dc3c8cbd06',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:51',NULL,'2025-11-28 10:09:51',NULL,NULL),(914,NULL,'186c552add1f41c9839a95b23b48c519',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:52',NULL,'2025-11-28 10:09:52',NULL,NULL),(915,NULL,'2cc8a146763846fabfe8e260b70f3971',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:52',NULL,'2025-11-28 10:09:52',NULL,NULL),(916,NULL,NULL,'b9ac6ab3dd0b4f7a93a114e6ff84cd7a',NULL,NULL,NULL,NULL,'2025-11-28 10:09:53',NULL,'2025-11-28 10:09:53',NULL,NULL),(917,NULL,'df6949ad183e4e1e8db4a49117054e84',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:54',NULL,'2025-11-28 10:09:54',NULL,NULL),(918,NULL,NULL,'053c8c5fbd8c4cc494cefb6d77138317',NULL,NULL,NULL,NULL,'2025-11-28 10:09:56',NULL,'2025-11-28 10:09:56',NULL,NULL),(919,NULL,NULL,'c7ed55fc11cf444993c13e8890a53960',NULL,NULL,NULL,NULL,'2025-11-28 10:09:56',NULL,'2025-11-28 10:09:56',NULL,NULL),(920,NULL,NULL,'9076bb497172401982b1e8791886203e',NULL,NULL,NULL,NULL,'2025-11-28 10:09:56',NULL,'2025-11-28 10:09:56',NULL,NULL),(921,NULL,NULL,'4777181e32e64a57b64344456966113e',NULL,NULL,NULL,NULL,'2025-11-28 10:09:56',NULL,'2025-11-28 10:09:56',NULL,NULL),(922,NULL,'07726e6f202441c78c67a877cfe7dcad',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:57',NULL,'2025-11-28 10:09:57',NULL,NULL),(923,NULL,'f7d1041a39314766921c69081d3b2ba0',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:58',NULL,'2025-11-28 10:09:58',NULL,NULL),(924,NULL,'17b6dfe61b9a45ea9c71f3c79074e4cf',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:09:58',NULL,'2025-11-28 10:09:58',NULL,NULL),(925,NULL,NULL,'04b45146b0ab498fbc11c9fb27eaa424',NULL,NULL,NULL,NULL,'2025-11-28 10:10:01',NULL,'2025-11-28 10:10:01',NULL,NULL),(926,NULL,'56c91df0287e4974b45f4ed0b63d771d',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:02',NULL,'2025-11-28 10:10:02',NULL,NULL),(927,NULL,NULL,'5d0403a083cd46acaac3fda1743e48b6',NULL,NULL,NULL,NULL,'2025-11-28 10:10:03',NULL,'2025-11-28 10:10:03',NULL,NULL),(928,NULL,NULL,'7afed44218a648d5a0c85a27e89ef1fe',NULL,NULL,NULL,NULL,'2025-11-28 10:10:04',NULL,'2025-11-28 10:10:04',NULL,NULL),(929,NULL,NULL,'3e0c0f1d7904439c976f777b4f3c59a9',NULL,NULL,NULL,NULL,'2025-11-28 10:10:04',NULL,'2025-11-28 10:10:04',NULL,NULL),(930,NULL,'3e2ec027cab64e90a22b087eafacf760',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:04',NULL,'2025-11-28 10:10:04',NULL,NULL),(931,NULL,'2206d3fd75404feab662a3ce296c7ba8',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:05',NULL,'2025-11-28 10:10:05',NULL,NULL),(932,NULL,NULL,'074e1dba8d9f45e1a034bf5478dd7a89',NULL,NULL,NULL,NULL,'2025-11-28 10:10:06',NULL,'2025-11-28 10:10:06',NULL,NULL),(933,NULL,NULL,'d078f3ee21824f3f828f4465a0bc1c2e',NULL,NULL,NULL,NULL,'2025-11-28 10:10:07',NULL,'2025-11-28 10:10:07',NULL,NULL),(934,NULL,'ed761b604a6b4d78ad4779e45435e5c8',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:07',NULL,'2025-11-28 10:10:07',NULL,NULL),(935,NULL,NULL,'c01cd4f3c8c344d1aff71fb3e3172dfa',NULL,NULL,NULL,NULL,'2025-11-28 10:10:07',NULL,'2025-11-28 10:10:07',NULL,NULL),(936,NULL,NULL,'bb79385c64e04edebbffe34d05ef597c',NULL,NULL,NULL,NULL,'2025-11-28 10:10:07',NULL,'2025-11-28 10:10:07',NULL,NULL),(937,NULL,'f192b411466f4eca964ef243563ccb39',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:08',NULL,'2025-11-28 10:10:08',NULL,NULL),(938,NULL,'e88b43741b4343fc868c707ffb269d46',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:09',NULL,'2025-11-28 10:10:09',NULL,NULL),(939,NULL,'7ccd2022daf64a6998725722e4ad2ecf',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:09',NULL,'2025-11-28 10:10:09',NULL,NULL),(940,NULL,NULL,'09496c381bc4475ca539bc9a9a1384cd',NULL,NULL,NULL,NULL,'2025-11-28 10:10:09',NULL,'2025-11-28 10:10:09',NULL,NULL),(941,NULL,'24191832e2ba4721bb4ed5c2a9254d67',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:10',NULL,'2025-11-28 10:10:10',NULL,NULL),(942,NULL,NULL,'d405e1ced93a4b7f9732c9daccfc5d43',NULL,NULL,NULL,NULL,'2025-11-28 10:10:11',NULL,'2025-11-28 10:10:11',NULL,NULL),(943,NULL,NULL,'50b293b14c8246f4913a7c5e2b742808',NULL,NULL,NULL,NULL,'2025-11-28 10:10:12',NULL,'2025-11-28 10:10:12',NULL,NULL),(944,NULL,'3e75d8532ea44ff88f2e686f89303ba0',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:12',NULL,'2025-11-28 10:10:12',NULL,NULL),(945,NULL,NULL,'4d9cd8b785bd48a9b410676f929ff612',NULL,NULL,NULL,NULL,'2025-11-28 10:10:13',NULL,'2025-11-28 10:10:13',NULL,NULL),(946,NULL,'c28a9156d93341b0876c13953eb860c2',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:13',NULL,'2025-11-28 10:10:13',NULL,NULL),(947,NULL,NULL,'e798a8a5767c4ed2bce970382d5d37e2',NULL,NULL,NULL,NULL,'2025-11-28 10:10:15',NULL,'2025-11-28 10:10:15',NULL,NULL),(948,NULL,NULL,'dc699ad7140a43a1b42fc8794c2bd6e7',NULL,NULL,NULL,NULL,'2025-11-28 10:10:16',NULL,'2025-11-28 10:10:16',NULL,NULL),(949,NULL,'83aea4fea8644e63a071b04356576f9a',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:16',NULL,'2025-11-28 10:10:16',NULL,NULL),(950,NULL,NULL,'8ea5668b7da944e3889979a0a4ebd864',NULL,NULL,NULL,NULL,'2025-11-28 10:10:16',NULL,'2025-11-28 10:10:16',NULL,NULL),(951,NULL,NULL,'d44445e8a9d040ffb14b407c00c5eab0',NULL,NULL,NULL,NULL,'2025-11-28 10:10:17',NULL,'2025-11-28 10:10:17',NULL,NULL),(952,NULL,NULL,'3339c84c00e841d39d3b9ece693db824',NULL,NULL,NULL,NULL,'2025-11-28 10:10:17',NULL,'2025-11-28 10:10:17',NULL,NULL),(953,NULL,NULL,'0c590c99613c4bfba0a433924d4f0272',NULL,NULL,NULL,NULL,'2025-11-28 10:10:17',NULL,'2025-11-28 10:10:17',NULL,NULL),(954,NULL,NULL,'af234196fab047ceb089a9efd4f4cdf2',NULL,NULL,NULL,NULL,'2025-11-28 10:10:17',NULL,'2025-11-28 10:10:17',NULL,NULL),(955,NULL,NULL,'7365471ed46d40d6bedf922c53fd4393',NULL,NULL,NULL,NULL,'2025-11-28 10:10:17',NULL,'2025-11-28 10:10:17',NULL,NULL),(956,NULL,NULL,'29018e7823e746e0a7e61beb49669935',NULL,NULL,NULL,NULL,'2025-11-28 10:10:17',NULL,'2025-11-28 10:10:17',NULL,NULL),(957,NULL,NULL,'aba77c8dbd744d4d8e8162ce69fc303e',NULL,NULL,NULL,NULL,'2025-11-28 10:10:18',NULL,'2025-11-28 10:10:18',NULL,NULL),(958,NULL,'9ae469011da74f5abbce684003b3bb7b',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:18',NULL,'2025-11-28 10:10:18',NULL,NULL),(959,NULL,'74afadd96b5b4a14a88aba78e326b7df',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:18',NULL,'2025-11-28 10:10:18',NULL,NULL),(960,NULL,NULL,'7d6203af93ca4a05af921d0d4772067e',NULL,NULL,NULL,NULL,'2025-11-28 10:10:18',NULL,'2025-11-28 10:10:18',NULL,NULL),(961,NULL,'d282e01c91d246caa265f741056c5bda',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:18',NULL,'2025-11-28 10:10:18',NULL,NULL),(962,NULL,'20fec43a3a4446938f9dcafec6c9893a',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:18',NULL,'2025-11-28 10:10:18',NULL,NULL),(963,NULL,'b60e123f9ae24bc4b0d8f898464e0468',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:19',NULL,'2025-11-28 10:10:19',NULL,NULL),(964,NULL,'04d61d2cdf774ebbb6fb21b7bd0f01e3',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:19',NULL,'2025-11-28 10:10:19',NULL,NULL),(965,NULL,NULL,'aacfed70c0f6444daadb20ebae2a9c70',NULL,NULL,NULL,NULL,'2025-11-28 10:10:19',NULL,'2025-11-28 10:10:19',NULL,NULL),(966,NULL,NULL,'dd0692a41d69485882ee75fa1e3604eb',NULL,NULL,NULL,NULL,'2025-11-28 10:10:19',NULL,'2025-11-28 10:10:19',NULL,NULL),(967,NULL,'c87069bba8ff410aa80aea184dc8e1b7',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:19',NULL,'2025-11-28 10:10:19',NULL,NULL),(968,NULL,NULL,'58240497ff70497c86a838c21e58b59d',NULL,NULL,NULL,NULL,'2025-11-28 10:10:19',NULL,'2025-11-28 10:10:19',NULL,NULL),(969,NULL,NULL,'ad548c783c6643969069291a0192871b',NULL,NULL,NULL,NULL,'2025-11-28 10:10:20',NULL,'2025-11-28 10:10:20',NULL,NULL),(970,NULL,NULL,'d3b6d62e085a4d95bdeb1efff668b621',NULL,NULL,NULL,NULL,'2025-11-28 10:10:21',NULL,'2025-11-28 10:10:21',NULL,NULL),(971,NULL,'901425b7bcd84c769215083cf562a98e',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:21',NULL,'2025-11-28 10:10:21',NULL,NULL),(972,NULL,NULL,'1005fbefb770416b9617bac66e95df89',NULL,NULL,NULL,NULL,'2025-11-28 10:10:21',NULL,'2025-11-28 10:10:21',NULL,NULL),(973,NULL,NULL,'602222d369634823abe91c45310779b0',NULL,NULL,NULL,NULL,'2025-11-28 10:10:21',NULL,'2025-11-28 10:10:21',NULL,NULL),(974,NULL,'5d8ed186fa094e7ab5fcf01fd5d4cbd3',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:21',NULL,'2025-11-28 10:10:21',NULL,NULL),(975,NULL,NULL,'1ab92ac3045f4b5aafd9ae9de6017992',NULL,NULL,NULL,NULL,'2025-11-28 10:10:22',NULL,'2025-11-28 10:10:22',NULL,NULL),(976,NULL,'a818045065b44180aa06b8fb2068fda1',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:22',NULL,'2025-11-28 10:10:22',NULL,NULL),(977,NULL,'d534350f45d7471e883783e44c4670a9',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:22',NULL,'2025-11-28 10:10:22',NULL,NULL),(978,NULL,'cb247b575ea94fc39851d771dd0d7d3c',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:22',NULL,'2025-11-28 10:10:22',NULL,NULL),(979,NULL,'ed59ec099bfe470982dfd8309e19126f',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:23',NULL,'2025-11-28 10:10:23',NULL,NULL),(980,NULL,'7bd97846275c4fc0966febc87bb1fe3f',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:23',NULL,'2025-11-28 10:10:23',NULL,NULL),(981,NULL,NULL,'2e2211aed0014a1999382093cd43bbb2',NULL,NULL,NULL,NULL,'2025-11-28 10:10:24',NULL,'2025-11-28 10:10:24',NULL,NULL),(982,NULL,'07d38a516c9e414eaa34c109123c792d',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:25',NULL,'2025-11-28 10:10:25',NULL,NULL),(983,NULL,NULL,'d29c040d4f56451fbc1991da309e3875',NULL,NULL,NULL,NULL,'2025-11-28 10:10:27',NULL,'2025-11-28 10:10:27',NULL,NULL),(984,NULL,NULL,'f13feb8037cc481d95283c05ec9f8c23',NULL,NULL,NULL,NULL,'2025-11-28 10:10:27',NULL,'2025-11-28 10:10:27',NULL,NULL),(985,NULL,NULL,'fe5a177f7488487e910ff3a84521bd9b',NULL,NULL,NULL,NULL,'2025-11-28 10:10:27',NULL,'2025-11-28 10:10:27',NULL,NULL),(986,NULL,NULL,'0995a7db92874eb2b529bb5327955ed0',NULL,NULL,NULL,NULL,'2025-11-28 10:10:28',NULL,'2025-11-28 10:10:28',NULL,NULL),(987,NULL,NULL,'811cc6e1003c4af59e7385d1d446e884',NULL,NULL,NULL,NULL,'2025-11-28 10:10:28',NULL,'2025-11-28 10:10:28',NULL,NULL),(988,NULL,NULL,'b7e0d127787647e89bc75befc34ac1ff',NULL,NULL,NULL,NULL,'2025-11-28 10:10:28',NULL,'2025-11-28 10:10:28',NULL,NULL),(989,NULL,NULL,'9e3941ba66cd4271a9d6104e381d5b3c',NULL,NULL,NULL,NULL,'2025-11-28 10:10:28',NULL,'2025-11-28 10:10:28',NULL,NULL),(990,NULL,'9dd2d545faf14e75ab4a7e7a89021ae8',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:28',NULL,'2025-11-28 10:10:28',NULL,NULL),(991,NULL,'4395abd486d947d5ba2cd486b8c2f257',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:29',NULL,'2025-11-28 10:10:29',NULL,NULL),(992,NULL,'5c6915db146c463385d79cf64f535563',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:30',NULL,'2025-11-28 10:10:30',NULL,NULL),(993,NULL,'d520472fdc8446f4a4ed904d4da623d0',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:30',NULL,'2025-11-28 10:10:30',NULL,NULL),(994,NULL,'49dd17a2ed694c499fca7b45bbab62bb',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:30',NULL,'2025-11-28 10:10:30',NULL,NULL),(995,NULL,'fec11530f7e04a66821383253faee0d1',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:31',NULL,'2025-11-28 10:10:31',NULL,NULL),(996,NULL,NULL,'0804ba0385d64149854f94f189fa5228',NULL,NULL,NULL,NULL,'2025-11-28 10:10:32',NULL,'2025-11-28 10:10:32',NULL,NULL),(997,NULL,NULL,'301510e57f704445a88ba81ce82ef43f',NULL,NULL,NULL,NULL,'2025-11-28 10:10:32',NULL,'2025-11-28 10:10:32',NULL,NULL),(998,NULL,'daf2a6ddfe26498bb16828d2d6abca81',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:33',NULL,'2025-11-28 10:10:33',NULL,NULL),(999,NULL,NULL,'23e974252be74a33b38079dd12f15ef0',NULL,NULL,NULL,NULL,'2025-11-28 10:10:33',NULL,'2025-11-28 10:10:33',NULL,NULL),(1000,NULL,NULL,'c594f5b4c2d041edaef66dde66ce0f9d',NULL,NULL,NULL,NULL,'2025-11-28 10:10:35',NULL,'2025-11-28 10:10:35',NULL,NULL),(1001,NULL,NULL,'0fd3dcc54c404120a9825fccd48033ce',NULL,NULL,NULL,NULL,'2025-11-28 10:10:35',NULL,'2025-11-28 10:10:35',NULL,NULL),(1002,NULL,NULL,'c5881061051a4f378d3d11d6d07054d1',NULL,NULL,NULL,NULL,'2025-11-28 10:10:36',NULL,'2025-11-28 10:10:36',NULL,NULL),(1003,NULL,NULL,'a433fe964e8c4d2a8e8c39f2e7aa6c99',NULL,NULL,NULL,NULL,'2025-11-28 10:10:36',NULL,'2025-11-28 10:10:36',NULL,NULL),(1004,NULL,'dc8d808d5c674b61996efce8d01e24f6',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:37',NULL,'2025-11-28 10:10:37',NULL,NULL),(1005,NULL,'812fdddd56884840a41aa34ee2fc2d7d',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:38',NULL,'2025-11-28 10:10:38',NULL,NULL),(1006,NULL,'60053654f2bb4df09df6e51ef30aa4dc',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:39',NULL,'2025-11-28 10:10:39',NULL,NULL),(1007,NULL,NULL,'677aab2179fe42298307c846ff69184a',NULL,NULL,NULL,NULL,'2025-11-28 10:10:43',NULL,'2025-11-28 10:10:43',NULL,NULL),(1008,NULL,NULL,'d7a08f3d5ec34c0fb5f31344c4d36d8a',NULL,NULL,NULL,NULL,'2025-11-28 10:10:43',NULL,'2025-11-28 10:10:43',NULL,NULL),(1009,NULL,NULL,'c6cf684b119542d1a249c4ecf00eb1b5',NULL,NULL,NULL,NULL,'2025-11-28 10:10:44',NULL,'2025-11-28 10:10:44',NULL,NULL),(1010,NULL,NULL,'0cef63841aaf44849d79d226587c527c',NULL,NULL,NULL,NULL,'2025-11-28 10:10:44',NULL,'2025-11-28 10:10:44',NULL,NULL),(1011,NULL,NULL,'f69d30d8a24b43a7b006c46d101f1a3d',NULL,NULL,NULL,NULL,'2025-11-28 10:10:44',NULL,'2025-11-28 10:10:44',NULL,NULL),(1012,NULL,NULL,'9619fa94b5894a44ad7131ab7dd60655',NULL,NULL,NULL,NULL,'2025-11-28 10:10:45',NULL,'2025-11-28 10:10:45',NULL,NULL),(1013,NULL,'7e49453e42454f828250f90f4c9319b5',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:45',NULL,'2025-11-28 10:10:45',NULL,NULL),(1014,NULL,'8fb574399e074da6b174573059b7801e',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:45',NULL,'2025-11-28 10:10:45',NULL,NULL),(1015,NULL,'fc71214f4a11474cb606687bd1ef00b1',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:46',NULL,'2025-11-28 10:10:46',NULL,NULL),(1016,NULL,'ea58894d49794901ac5df655c3ed20fa',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:46',NULL,'2025-11-28 10:10:46',NULL,NULL),(1017,NULL,'e0c40d8bf169430ba137dca405115c59',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:46',NULL,'2025-11-28 10:10:46',NULL,NULL),(1018,NULL,'a65552de119e4309a43e9e85b3f7e533',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:46',NULL,'2025-11-28 10:10:46',NULL,NULL),(1019,NULL,NULL,'b5918060f5574f91b2d7c451d525fb11',NULL,NULL,NULL,NULL,'2025-11-28 10:10:48',NULL,'2025-11-28 10:10:48',NULL,NULL),(1020,NULL,'49292e39a71849cab7a1ab21fdf607e3',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:49',NULL,'2025-11-28 10:10:49',NULL,NULL),(1021,NULL,NULL,'abdfdc36332245e5b7d392e7703d51df',NULL,NULL,NULL,NULL,'2025-11-28 10:10:51',NULL,'2025-11-28 10:10:51',NULL,NULL),(1022,NULL,NULL,'b81484063c294e2b9fbd79c48d3a78e1',NULL,NULL,NULL,NULL,'2025-11-28 10:10:54',NULL,'2025-11-28 10:10:54',NULL,NULL),(1023,NULL,NULL,'ef6e2ea58bc9409486f06fa3ad2cf663',NULL,NULL,NULL,NULL,'2025-11-28 10:10:54',NULL,'2025-11-28 10:10:54',NULL,NULL),(1024,NULL,NULL,'b737039887e148918fa283c4d2ec7657',NULL,NULL,NULL,NULL,'2025-11-28 10:10:54',NULL,'2025-11-28 10:10:54',NULL,NULL),(1025,NULL,'8e3baf6078d441fead64f612139a9c5e',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:57',NULL,'2025-11-28 10:10:57',NULL,NULL),(1026,NULL,NULL,'1e472579bdf041a89332b4e1e3e1b646',NULL,NULL,NULL,NULL,'2025-11-28 10:10:58',NULL,'2025-11-28 10:10:58',NULL,NULL),(1027,NULL,'f85270971da84d908e67638e6f9c43e2',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:58',NULL,'2025-11-28 10:10:58',NULL,NULL),(1028,NULL,'2a776fa1bf8f44a8a8683d666d24967d',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:10:58',NULL,'2025-11-28 10:10:58',NULL,NULL),(1029,NULL,NULL,'c18e0008a435427c9fdb998cc1b49bd6',NULL,NULL,NULL,NULL,'2025-11-28 10:11:00',NULL,'2025-11-28 10:11:00',NULL,NULL),(1030,NULL,NULL,'b9ed7c3197fe41acb466b145065114d3',NULL,NULL,NULL,NULL,'2025-11-28 10:11:00',NULL,'2025-11-28 10:11:00',NULL,NULL),(1031,NULL,NULL,'fa0d986262574d1aa5bfcc3cd2fa05e7',NULL,NULL,NULL,NULL,'2025-11-28 10:11:01',NULL,'2025-11-28 10:11:01',NULL,NULL),(1032,NULL,NULL,'2d80bb49b2874192a2995e3b8a95a95b',NULL,NULL,NULL,NULL,'2025-11-28 10:11:01',NULL,'2025-11-28 10:11:01',NULL,NULL),(1033,NULL,NULL,'3602eb59752942f68890c3d4bb1ab475',NULL,NULL,NULL,NULL,'2025-11-28 10:11:01',NULL,'2025-11-28 10:11:01',NULL,NULL),(1034,NULL,'ff65105a3fab48e98884ea81356ec03e',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:01',NULL,'2025-11-28 10:11:01',NULL,NULL),(1035,NULL,'7683e4ed98894de19dc2538cc36bcd6c',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:03',NULL,'2025-11-28 10:11:03',NULL,NULL),(1036,NULL,NULL,'7bc3ef3ffab64db9bace56f06272f5e4',NULL,NULL,NULL,NULL,'2025-11-28 10:11:04',NULL,'2025-11-28 10:11:04',NULL,NULL),(1037,NULL,NULL,'1deacee2ac724bf2ad53fa5464f5376c',NULL,NULL,NULL,NULL,'2025-11-28 10:11:04',NULL,'2025-11-28 10:11:04',NULL,NULL),(1038,NULL,'5943334897af43ca9607f31d178fb7ef',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:04',NULL,'2025-11-28 10:11:04',NULL,NULL),(1039,NULL,NULL,'4ffa5c61508d49849de97a3accfcdbf0',NULL,NULL,NULL,NULL,'2025-11-28 10:11:05',NULL,'2025-11-28 10:11:05',NULL,NULL),(1040,NULL,NULL,'9d9669e6eec44c67a3b3cb7f7cba2b9a',NULL,NULL,NULL,NULL,'2025-11-28 10:11:05',NULL,'2025-11-28 10:11:05',NULL,NULL),(1041,NULL,'1a203a668ad442b7a0e1a122f4122c81',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:05',NULL,'2025-11-28 10:11:05',NULL,NULL),(1042,NULL,'18d310ce35d8405580ba68aec31b97f9',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:05',NULL,'2025-11-28 10:11:05',NULL,NULL),(1043,NULL,'740baade34594373abe8496e4a2507dc',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:08',NULL,'2025-11-28 10:11:08',NULL,NULL),(1044,NULL,NULL,'309f1623ac464390842d8dc4785118f9',NULL,NULL,NULL,NULL,'2025-11-28 10:11:08',NULL,'2025-11-28 10:11:08',NULL,NULL),(1045,NULL,'c19ea3131fac4617898b6a69c330495c',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:09',NULL,'2025-11-28 10:11:09',NULL,NULL),(1046,NULL,'39ffeead9f734f13b1a489e1ce8313ab',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:09',NULL,'2025-11-28 10:11:09',NULL,NULL),(1047,NULL,'c338b8c098fe40d5914b19147b719b2e',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:09',NULL,'2025-11-28 10:11:09',NULL,NULL),(1048,NULL,NULL,'69e64f04cc014583afe06a34535d656f',NULL,NULL,NULL,NULL,'2025-11-28 10:11:12',NULL,'2025-11-28 10:11:12',NULL,NULL),(1049,NULL,NULL,'37b161d00e3a4ba2998c09b04ab23967',NULL,NULL,NULL,NULL,'2025-11-28 10:11:12',NULL,'2025-11-28 10:11:12',NULL,NULL),(1050,NULL,NULL,'98263d358bae43ad913c306a25a62696',NULL,NULL,NULL,NULL,'2025-11-28 10:11:13',NULL,'2025-11-28 10:11:13',NULL,NULL),(1051,NULL,NULL,'efa7dc903daa4c7e88d958a7d7a53613',NULL,NULL,NULL,NULL,'2025-11-28 10:11:13',NULL,'2025-11-28 10:11:13',NULL,NULL),(1052,NULL,NULL,'6212ed28bd2b4d8798c54ea530b32b6f',NULL,NULL,NULL,NULL,'2025-11-28 10:11:13',NULL,'2025-11-28 10:11:13',NULL,NULL),(1053,NULL,'d089ee3db63e4c9b9444d4f687d0619a',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:16',NULL,'2025-11-28 10:11:16',NULL,NULL),(1054,NULL,'00c2fa4a34ea4bfba4d0fde13e213f92',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:17',NULL,'2025-11-28 10:11:17',NULL,NULL),(1055,NULL,'32eca9275b924feb9e3556245c89ded4',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:18',NULL,'2025-11-28 10:11:18',NULL,NULL),(1056,NULL,'0696a710ed08487a88f951b508649399',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:19',NULL,'2025-11-28 10:11:19',NULL,NULL),(1057,NULL,NULL,'9fb1fef6d5a842e9a6faca8076f232c1',NULL,NULL,NULL,NULL,'2025-11-28 10:11:25',NULL,'2025-11-28 10:11:25',NULL,NULL),(1058,NULL,NULL,'e8cba1a5c43c462a90aadaedb33560f9',NULL,NULL,NULL,NULL,'2025-11-28 10:11:26',NULL,'2025-11-28 10:11:26',NULL,NULL),(1059,NULL,NULL,'2c18bdb9472f4e51b2790ea95ef17eb3',NULL,NULL,NULL,NULL,'2025-11-28 10:11:26',NULL,'2025-11-28 10:11:26',NULL,NULL),(1060,NULL,NULL,'223c40b56a4243b8a3a15201a2eea777',NULL,NULL,NULL,NULL,'2025-11-28 10:11:27',NULL,'2025-11-28 10:11:27',NULL,NULL),(1061,NULL,NULL,'5083faf930734819b0eb437899c37899',NULL,NULL,NULL,NULL,'2025-11-28 10:11:27',NULL,'2025-11-28 10:11:27',NULL,NULL),(1062,NULL,'2e6e3251bacd42d6b03534a552ecb206',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:28',NULL,'2025-11-28 10:11:28',NULL,NULL),(1063,NULL,'05f22ff0b27f4271942799617a0920d2',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:30',NULL,'2025-11-28 10:11:30',NULL,NULL),(1064,NULL,'4388e8db5655401598e4178835fa81ad',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:32',NULL,'2025-11-28 10:11:32',NULL,NULL),(1065,NULL,NULL,'370d5fdf34db427999f72998224c9539',NULL,NULL,NULL,NULL,'2025-11-28 10:11:32',NULL,'2025-11-28 10:11:32',NULL,NULL),(1066,NULL,NULL,'0e4a868caf7745428b930f5df0b3e2fe',NULL,NULL,NULL,NULL,'2025-11-28 10:11:34',NULL,'2025-11-28 10:11:34',NULL,NULL),(1067,NULL,NULL,'6daf5658ba374c049f41816394d1e59c',NULL,NULL,NULL,NULL,'2025-11-28 10:11:34',NULL,'2025-11-28 10:11:34',NULL,NULL),(1068,NULL,NULL,'40f42c961d7c4c308eba6da8ad9bc719',NULL,NULL,NULL,NULL,'2025-11-28 10:11:35',NULL,'2025-11-28 10:11:35',NULL,NULL),(1069,NULL,'cf4072fdb44640e5ad87951e3702b5d2',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:36',NULL,'2025-11-28 10:11:36',NULL,NULL),(1070,NULL,'ab97bc5516b54755ac262ba68a804978',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:36',NULL,'2025-11-28 10:11:36',NULL,NULL),(1071,NULL,'2b88e501d7154744a9fc48a25542f5e0',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:37',NULL,'2025-11-28 10:11:37',NULL,NULL),(1072,NULL,NULL,'1cd81a5bd3cc4a28aba7f0fa23decc0c',NULL,NULL,NULL,NULL,'2025-11-28 10:11:38',NULL,'2025-11-28 10:11:38',NULL,NULL),(1073,NULL,NULL,'ffce0a872a0f4a8fa868de2152ea3e8f',NULL,NULL,NULL,NULL,'2025-11-28 10:11:39',NULL,'2025-11-28 10:11:39',NULL,NULL),(1074,NULL,NULL,'d2e0cda103814a879e952c4cb24a9ba8',NULL,NULL,NULL,NULL,'2025-11-28 10:11:39',NULL,'2025-11-28 10:11:39',NULL,NULL),(1075,NULL,NULL,'2fd3cfae601d4a66b0478393bd739747',NULL,NULL,NULL,NULL,'2025-11-28 10:11:39',NULL,'2025-11-28 10:11:39',NULL,NULL),(1076,NULL,NULL,'84ddfea824c34d8a8a13891c8d895ff6',NULL,NULL,NULL,NULL,'2025-11-28 10:11:39',NULL,'2025-11-28 10:11:39',NULL,NULL),(1077,NULL,NULL,'58e184925fcd405da6dfaaa181ae6bd4',NULL,NULL,NULL,NULL,'2025-11-28 10:11:40',NULL,'2025-11-28 10:11:40',NULL,NULL),(1078,NULL,NULL,'7ec703de666d4fe09e09fba0bb8bee2c',NULL,NULL,NULL,NULL,'2025-11-28 10:11:40',NULL,'2025-11-28 10:11:40',NULL,NULL),(1079,NULL,'61249b3db7384c3baa4d8ab844d6f491',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:40',NULL,'2025-11-28 10:11:40',NULL,NULL),(1080,NULL,NULL,'9510e53a3e6c460c8597a5767b39085a',NULL,NULL,NULL,NULL,'2025-11-28 10:11:40',NULL,'2025-11-28 10:11:40',NULL,NULL),(1081,NULL,'aaf1f8cead8f4f8b8cda2e0813ee1aef',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:40',NULL,'2025-11-28 10:11:40',NULL,NULL),(1082,NULL,'7dc33b8a173348f5a1fc870414f6918d',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:41',NULL,'2025-11-28 10:11:41',NULL,NULL),(1083,NULL,'1779ca7ab1244aca8ed5c75fa03f80d3',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:41',NULL,'2025-11-28 10:11:41',NULL,NULL),(1084,NULL,'71ad6158856d4ca4b69fb59604a83c60',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:41',NULL,'2025-11-28 10:11:41',NULL,NULL),(1085,NULL,'ab751ad57e3447c4bff1cb1cd230019a',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:42',NULL,'2025-11-28 10:11:42',NULL,NULL),(1086,NULL,NULL,'f3d324761d4d4aa795552e22b71f606d',NULL,NULL,NULL,NULL,'2025-11-28 10:11:42',NULL,'2025-11-28 10:11:42',NULL,NULL),(1087,NULL,NULL,'b304534ce0904f7186e0791aebb395d7',NULL,NULL,NULL,NULL,'2025-11-28 10:11:43',NULL,'2025-11-28 10:11:43',NULL,NULL),(1088,NULL,NULL,'d99033a8cc8b4fdc87fca6977fb695e5',NULL,NULL,NULL,NULL,'2025-11-28 10:11:43',NULL,'2025-11-28 10:11:43',NULL,NULL),(1089,NULL,NULL,'8c16b00ee1be48d68b91b59b1485ccee',NULL,NULL,NULL,NULL,'2025-11-28 10:11:43',NULL,'2025-11-28 10:11:43',NULL,NULL),(1090,NULL,'4fb812bee854424d9fbe6d7fe0bb18bd',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:44',NULL,'2025-11-28 10:11:44',NULL,NULL),(1091,NULL,'913fdcbd803e4dc19baf84fbdd43f8e5',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:44',NULL,'2025-11-28 10:11:44',NULL,NULL),(1092,NULL,'b909be09fc194724a4b7cbb660268161',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:45',NULL,'2025-11-28 10:11:45',NULL,NULL),(1093,NULL,NULL,'47cdb2911922414c87c44fadac1c1fbb',NULL,NULL,NULL,NULL,'2025-11-28 10:11:47',NULL,'2025-11-28 10:11:47',NULL,NULL),(1094,NULL,NULL,'15a97d7d02d94797bdbda18acdf4b988',NULL,NULL,NULL,NULL,'2025-11-28 10:11:47',NULL,'2025-11-28 10:11:47',NULL,NULL),(1095,NULL,NULL,'00a06023e043457ab6ddd5959627fbe0',NULL,NULL,NULL,NULL,'2025-11-28 10:11:47',NULL,'2025-11-28 10:11:47',NULL,NULL),(1096,NULL,'b1445a4fdb8340e78ff1c8816e76989c',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:48',NULL,'2025-11-28 10:11:48',NULL,NULL),(1097,NULL,'a1ab6d5dbd57453f92ddf8599a8c5cff',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:49',NULL,'2025-11-28 10:11:49',NULL,NULL),(1098,NULL,'a945679224714a5a88d8628b23fb9679',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:11:50',NULL,'2025-11-28 10:11:50',NULL,NULL),(1099,NULL,NULL,'888f0d19f3c04dc9a2e6a2e5eabd71cc',NULL,NULL,NULL,NULL,'2025-11-28 10:11:55',NULL,'2025-11-28 10:11:55',NULL,NULL),(1100,NULL,NULL,'4b6fb13e2801445d804ef42e351046aa',NULL,NULL,NULL,NULL,'2025-11-28 10:11:56',NULL,'2025-11-28 10:11:56',NULL,NULL),(1101,NULL,NULL,'b44ef903be4543c38c7ff39887ede90c',NULL,NULL,NULL,NULL,'2025-11-28 10:11:59',NULL,'2025-11-28 10:11:59',NULL,NULL),(1102,NULL,NULL,'3dbc3b7c545f46bf825e3cc12e8b2c06',NULL,NULL,NULL,NULL,'2025-11-28 10:12:00',NULL,'2025-11-28 10:12:00',NULL,NULL),(1103,NULL,NULL,'d2d36fb315394904be0499b7611bcbb1',NULL,NULL,NULL,NULL,'2025-11-28 10:12:00',NULL,'2025-11-28 10:12:00',NULL,NULL),(1104,NULL,'30c973713f884651b4770ee5bb95a1e4',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:12:01',NULL,'2025-11-28 10:12:01',NULL,NULL),(1105,NULL,'1562d9ae673b4a5ea5a1a571bd0ea2c8',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:12:02',NULL,'2025-11-28 10:12:02',NULL,NULL),(1106,NULL,'07bdc3050eee40838f7453fe645c09fe',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:12:03',NULL,'2025-11-28 10:12:03',NULL,NULL),(1107,NULL,NULL,'80391e48913f43e0bf5babfb4338f5e1',NULL,NULL,NULL,NULL,'2025-11-28 10:12:07',NULL,'2025-11-28 10:12:07',NULL,NULL),(1108,NULL,NULL,'74d8b810569e4d009530eb40339a7eb5',NULL,NULL,NULL,NULL,'2025-11-28 10:12:07',NULL,'2025-11-28 10:12:07',NULL,NULL),(1109,NULL,'b183bba5ae624f349d21889e13a69feb',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:12:09',NULL,'2025-11-28 10:12:09',NULL,NULL),(1110,NULL,NULL,'c96639555ce44e9d9b8fafdf95d9aef8',NULL,NULL,NULL,NULL,'2025-11-28 10:12:14',NULL,'2025-11-28 10:12:14',NULL,NULL),(1111,NULL,NULL,'a7b278de857d4692bf27cdb0e053391c',NULL,NULL,NULL,NULL,'2025-11-28 10:12:14',NULL,'2025-11-28 10:12:14',NULL,NULL),(1112,NULL,NULL,'79b5723611614d498eb5d227395859b0',NULL,NULL,NULL,NULL,'2025-11-28 10:12:15',NULL,'2025-11-28 10:12:15',NULL,NULL),(1113,NULL,'5fb4541c15384e0a9b79f3d143dd0e20',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:12:16',NULL,'2025-11-28 10:12:16',NULL,NULL),(1114,NULL,NULL,'e9b97c480aec4c32a447af8dc45ef300',NULL,NULL,NULL,NULL,'2025-11-28 10:12:16',NULL,'2025-11-28 10:12:16',NULL,NULL),(1115,NULL,NULL,'f73a591d20c848d3a2aa5d5a4c264b6d',NULL,NULL,NULL,NULL,'2025-11-28 10:12:16',NULL,'2025-11-28 10:12:16',NULL,NULL),(1116,NULL,'1353b256ba2c444f92d94a37fc2b399e',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:12:17',NULL,'2025-11-28 10:12:17',NULL,NULL),(1117,NULL,NULL,'612cd8b40f034c1b8249303a7dae5a5b',NULL,NULL,NULL,NULL,'2025-11-28 10:12:17',NULL,'2025-11-28 10:12:17',NULL,NULL),(1118,NULL,'729a918c0a8248ff9fef91d8e41e340a',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:12:17',NULL,'2025-11-28 10:12:17',NULL,NULL),(1119,NULL,NULL,'267556ee7e92440b82bfee4afa050c0e',NULL,NULL,NULL,NULL,'2025-11-28 10:12:17',NULL,'2025-11-28 10:12:17',NULL,NULL),(1120,NULL,NULL,'f7286d162cf44c89bd54062f6db089b2',NULL,NULL,NULL,NULL,'2025-11-28 10:12:17',NULL,'2025-11-28 10:12:17',NULL,NULL),(1121,NULL,NULL,'1d0cf1427e4a46f394fe31b82887224c',NULL,NULL,NULL,NULL,'2025-11-28 10:12:17',NULL,'2025-11-28 10:12:17',NULL,NULL),(1122,NULL,'c73683dfcb5d4d26b843a355bc2ccf79',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:12:17',NULL,'2025-11-28 10:12:17',NULL,NULL),(1123,NULL,'e2d0632559584739b35a1601ad5b1ba9',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:12:17',NULL,'2025-11-28 10:12:17',NULL,NULL),(1124,NULL,'3a9ab40bef1e43ba8ef70307b5f2224e',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:12:19',NULL,'2025-11-28 10:12:19',NULL,NULL),(1125,NULL,'b5e7474ddfa74462ace1d5deca683f14',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:12:19',NULL,'2025-11-28 10:12:19',NULL,NULL),(1126,NULL,'66b89eedb02147ebb9b971f25a266711',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:12:20',NULL,'2025-11-28 10:12:20',NULL,NULL),(1127,NULL,NULL,'f623ff675f744775887b4913bd3a1af2',NULL,NULL,NULL,NULL,'2025-11-28 10:12:32',NULL,'2025-11-28 10:12:32',NULL,NULL),(1128,NULL,NULL,'d0c253824fbd4e0cb6c981f5f83d84ce',NULL,NULL,NULL,NULL,'2025-11-28 10:12:39',NULL,'2025-11-28 10:12:39',NULL,NULL),(1129,NULL,NULL,'ad9cb85fd5c6468d897815c25b9a150f',NULL,NULL,NULL,NULL,'2025-11-28 10:12:39',NULL,'2025-11-28 10:12:39',NULL,NULL),(1130,NULL,'2a5eaeee8da34a54a7b5240b18a0f9b2',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:12:39',NULL,'2025-11-28 10:12:39',NULL,NULL),(1131,NULL,NULL,'7bb93a6b8f964bc29e0142d853d16f29',NULL,NULL,NULL,NULL,'2025-11-28 10:12:39',NULL,'2025-11-28 10:12:39',NULL,NULL),(1132,NULL,NULL,'2073da7a360948fcb480ddf561d3bbc8',NULL,NULL,NULL,NULL,'2025-11-28 10:12:39',NULL,'2025-11-28 10:12:39',NULL,NULL),(1133,NULL,'7e00077694d04943bac29b5322007c91',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:12:41',NULL,'2025-11-28 10:12:41',NULL,NULL),(1134,NULL,'7e3af8a3bac3495d93a9072a440e6c65',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:12:42',NULL,'2025-11-28 10:12:42',NULL,NULL),(1135,NULL,'d460680b47094447953e679d694e6dad',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:12:43',NULL,'2025-11-28 10:12:43',NULL,NULL),(1136,NULL,NULL,'55ed4d0c2e4f4f5abfcaaebc65e62bbd',NULL,NULL,NULL,NULL,'2025-11-28 10:13:03',NULL,'2025-11-28 10:13:03',NULL,NULL),(1137,NULL,NULL,'be1b571888e44262a403b371a4e20f04',NULL,NULL,NULL,NULL,'2025-11-28 10:13:05',NULL,'2025-11-28 10:13:05',NULL,NULL),(1138,NULL,NULL,'372e238309d04dea8256f42b7a2dba29',NULL,NULL,NULL,NULL,'2025-11-28 10:13:06',NULL,'2025-11-28 10:13:06',NULL,NULL),(1139,NULL,'44b4985cb9a749eda4ec250cf7829272',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:13:06',NULL,'2025-11-28 10:13:06',NULL,NULL),(1140,NULL,NULL,'e95edee12bfe457fa03c63124837eded',NULL,NULL,NULL,NULL,'2025-11-28 10:13:07',NULL,'2025-11-28 10:13:07',NULL,NULL),(1141,NULL,NULL,'41a2249a02614c68b3f36a511706f6bd',NULL,NULL,NULL,NULL,'2025-11-28 10:13:07',NULL,'2025-11-28 10:13:07',NULL,NULL),(1142,NULL,'110ad6d62797451bbbddc050ea0ad663',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:13:17',NULL,'2025-11-28 10:13:17',NULL,NULL),(1143,NULL,'c951d122f9814c12b7d1f55672cccce8',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:13:18',NULL,'2025-11-28 10:13:18',NULL,NULL),(1144,NULL,'7849a0d812124969961ed960ba5526ec',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:13:19',NULL,'2025-11-28 10:13:19',NULL,NULL),(1145,NULL,NULL,'330805f063ac445cb9cc06f6cb0ee160',NULL,NULL,NULL,NULL,'2025-11-28 10:13:25',NULL,'2025-11-28 10:13:25',NULL,NULL),(1146,NULL,NULL,'d38f8fd012304d2c865d364d03d74c23',NULL,NULL,NULL,NULL,'2025-11-28 10:13:25',NULL,'2025-11-28 10:13:25',NULL,NULL),(1147,NULL,NULL,'02f95342d6d447f68245ab40ee72ef4b',NULL,NULL,NULL,NULL,'2025-11-28 10:13:25',NULL,'2025-11-28 10:13:25',NULL,NULL),(1148,NULL,NULL,'c5bb2299db4541238456ef2807dc2a26',NULL,NULL,NULL,NULL,'2025-11-28 10:13:26',NULL,'2025-11-28 10:13:26',NULL,NULL),(1149,NULL,'417d0819d5f34cc096d85cb3eadd5298',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:13:27',NULL,'2025-11-28 10:13:27',NULL,NULL),(1150,NULL,NULL,'ea70fa3b130d430b800da3c2ce257943',NULL,NULL,NULL,NULL,'2025-11-28 10:13:27',NULL,'2025-11-28 10:13:27',NULL,NULL),(1151,NULL,NULL,'a0605977e7a845efa971b7a142ab9916',NULL,NULL,NULL,NULL,'2025-11-28 10:13:28',NULL,'2025-11-28 10:13:28',NULL,NULL),(1152,NULL,'009cc02bdc8341d0b35daab25fb94513',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:13:28',NULL,'2025-11-28 10:13:28',NULL,NULL),(1153,NULL,'8ce454c94ec74465ac8200d5fe0b153e',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:13:28',NULL,'2025-11-28 10:13:28',NULL,NULL),(1154,NULL,'5c95488e6ec54cabb2f1a168391e1d60',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:13:30',NULL,'2025-11-28 10:13:30',NULL,NULL),(1155,NULL,'ba677652c37f4744932c533daaac77ef',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:13:30',NULL,'2025-11-28 10:13:30',NULL,NULL),(1156,NULL,NULL,'2647db0d8961437d8b12a2d16d413960',NULL,NULL,NULL,NULL,'2025-11-28 10:13:39',NULL,'2025-11-28 10:13:39',NULL,NULL),(1157,NULL,NULL,'f76d7d6f14984f9b81a1d6af12c7b908',NULL,NULL,NULL,NULL,'2025-11-28 10:13:39',NULL,'2025-11-28 10:13:39',NULL,NULL),(1158,NULL,NULL,'cbf66f4180d843eeafcfa90b799ce933',NULL,NULL,NULL,NULL,'2025-11-28 10:13:46',NULL,'2025-11-28 10:13:46',NULL,NULL),(1159,NULL,NULL,'453bb2b6c908409faa4c5882869559f1',NULL,NULL,NULL,NULL,'2025-11-28 10:13:46',NULL,'2025-11-28 10:13:46',NULL,NULL),(1160,NULL,NULL,'5e8b13d7ad8c4f4aa1918fe4c29a583a',NULL,NULL,NULL,NULL,'2025-11-28 10:13:46',NULL,'2025-11-28 10:13:46',NULL,NULL),(1161,NULL,'201be3bc29ff448e9bb51b46b705f04f',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:13:48',NULL,'2025-11-28 10:13:48',NULL,NULL),(1162,NULL,NULL,'e6d339a2ff3148df937dc437ec255af3',NULL,NULL,NULL,NULL,'2025-11-28 10:13:48',NULL,'2025-11-28 10:13:48',NULL,NULL),(1163,NULL,'2d16f2c2a361488d89253e32d19e9500',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:13:48',NULL,'2025-11-28 10:13:48',NULL,NULL),(1164,NULL,'74f1e898e17c4b33b4591a47dd63a599',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:13:48',NULL,'2025-11-28 10:13:48',NULL,NULL),(1165,NULL,'38de2f991c8946e4ad86ddc6b9c2ae73',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:13:49',NULL,'2025-11-28 10:13:49',NULL,NULL),(1166,NULL,NULL,'f6da790abbda45278927265da987408b',NULL,NULL,NULL,NULL,'2025-11-28 10:14:46',NULL,'2025-11-28 10:14:46',NULL,NULL),(1167,NULL,NULL,'6cc1c18a7e244cc796e077a2b595df2a',NULL,NULL,NULL,NULL,'2025-11-28 10:14:59',NULL,'2025-11-28 10:14:59',NULL,NULL),(1168,NULL,NULL,'a4a20dfb6d8746bf9d4dfae82189957b',NULL,NULL,NULL,NULL,'2025-11-28 10:14:59',NULL,'2025-11-28 10:14:59',NULL,NULL),(1169,NULL,NULL,'de57749b50cb4e599650aabc9dfae610',NULL,NULL,NULL,NULL,'2025-11-28 10:14:59',NULL,'2025-11-28 10:14:59',NULL,NULL),(1170,NULL,'b90c445933704341b38d135548fb5388',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:15:01',NULL,'2025-11-28 10:15:01',NULL,NULL),(1171,NULL,'301971e834c14ea7aa009696c3f04782',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:15:01',NULL,'2025-11-28 10:15:01',NULL,NULL),(1172,NULL,'fd0003318fe04e658dbcce3685647aff',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:15:03',NULL,'2025-11-28 10:15:03',NULL,NULL),(1173,NULL,NULL,'ef4b3fd2e66a49908bbd90f2d8708162',NULL,NULL,NULL,NULL,'2025-11-28 10:15:09',NULL,'2025-11-28 10:15:09',NULL,NULL),(1174,NULL,NULL,'b79a3a528ea74665849dbf02dfc0f84c',NULL,NULL,NULL,NULL,'2025-11-28 10:15:09',NULL,'2025-11-28 10:15:09',NULL,NULL),(1175,NULL,NULL,'059fd32a03194cddae6175339b7e553d',NULL,NULL,NULL,NULL,'2025-11-28 10:15:09',NULL,'2025-11-28 10:15:09',NULL,NULL),(1176,NULL,NULL,'71188e952fb04b7380718cfded3386d6',NULL,NULL,NULL,NULL,'2025-11-28 10:15:09',NULL,'2025-11-28 10:15:09',NULL,NULL),(1177,NULL,'7e596b943e6847d3a99845c08eb62e34',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:15:10',NULL,'2025-11-28 10:15:10',NULL,NULL),(1178,NULL,'0522cf724fcc4ea59498be7b9865e908',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:15:11',NULL,'2025-11-28 10:15:11',NULL,NULL),(1179,NULL,'3d9c16b562c04a9098e29ed582c18ed9',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:15:13',NULL,'2025-11-28 10:15:13',NULL,NULL),(1180,NULL,NULL,'5bb542699d704fe28bdd7372faa1ed18',NULL,NULL,NULL,NULL,'2025-11-28 10:15:32',NULL,'2025-11-28 10:15:32',NULL,NULL),(1181,NULL,NULL,'1f60574029c1406aa5a4e544b63686a8',NULL,NULL,NULL,NULL,'2025-11-28 10:15:45',NULL,'2025-11-28 10:15:45',NULL,NULL),(1182,NULL,NULL,'84f851b44b9d4dedbc8da4937c9cdb68',NULL,NULL,NULL,NULL,'2025-11-28 10:15:45',NULL,'2025-11-28 10:15:45',NULL,NULL),(1183,NULL,NULL,'c2511bec85db4927b0fa4a467c8ac3e9',NULL,NULL,NULL,NULL,'2025-11-28 10:15:45',NULL,'2025-11-28 10:15:45',NULL,NULL),(1184,NULL,'616f52247fa34416888be26765de5d37',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:15:46',NULL,'2025-11-28 10:15:46',NULL,NULL),(1185,NULL,'4fd4367d7eac444bae1496b393bb25f7',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:15:47',NULL,'2025-11-28 10:15:47',NULL,NULL),(1186,NULL,'f8d3043644994668bf881f2ed76593cb',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:15:48',NULL,'2025-11-28 10:15:48',NULL,NULL),(1187,NULL,NULL,'a606cf1eb30743c2b23727b1cc2dfe59',NULL,NULL,NULL,NULL,'2025-11-28 10:15:59',NULL,'2025-11-28 10:15:59',NULL,NULL),(1188,NULL,NULL,'bc75d35d76b8426ea0b7e931d84ebe92',NULL,NULL,NULL,NULL,'2025-11-28 10:16:06',NULL,'2025-11-28 10:16:06',NULL,NULL),(1189,NULL,NULL,'1c4989ef612741b6af30aafb9ec30f10',NULL,NULL,NULL,NULL,'2025-11-28 10:16:06',NULL,'2025-11-28 10:16:06',NULL,NULL),(1190,NULL,NULL,'fba76f8e9b774d0892f0163ccfa35058',NULL,NULL,NULL,NULL,'2025-11-28 10:16:06',NULL,'2025-11-28 10:16:06',NULL,NULL),(1191,NULL,'2801de39cf164ad48f22d9f089f3ae99',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:16:07',NULL,'2025-11-28 10:16:07',NULL,NULL),(1192,NULL,'ae1723357a08440e8ac316b1180170a5',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:16:08',NULL,'2025-11-28 10:16:08',NULL,NULL),(1193,NULL,'0147627d62bc4964a1323729b5e4e7e4',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:16:08',NULL,'2025-11-28 10:16:08',NULL,NULL),(1194,NULL,NULL,'e5e757b30cba4781acc7a09e2178c1c8',NULL,NULL,NULL,NULL,'2025-11-28 10:16:20',NULL,'2025-11-28 10:16:20',NULL,NULL),(1195,NULL,NULL,'a4133f743ebf43048b0d18e3d70b82d2',NULL,NULL,NULL,NULL,'2025-11-28 10:16:26',NULL,'2025-11-28 10:16:26',NULL,NULL),(1196,NULL,NULL,'0c3a519d16114207aa2cab6e2d17cdb9',NULL,NULL,NULL,NULL,'2025-11-28 10:16:27',NULL,'2025-11-28 10:16:27',NULL,NULL),(1197,NULL,NULL,'c4ff475458394031a6b982b445e96add',NULL,NULL,NULL,NULL,'2025-11-28 10:16:27',NULL,'2025-11-28 10:16:27',NULL,NULL),(1198,NULL,'3b04ab7c7d86413bbf382ef8d4ba4786',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:16:28',NULL,'2025-11-28 10:16:28',NULL,NULL),(1199,NULL,'a7c0c439f55c4179a9932a53b7755072',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:16:29',NULL,'2025-11-28 10:16:29',NULL,NULL),(1200,NULL,'321027c256e546a79237bc6b8b8a4747',NULL,NULL,NULL,NULL,NULL,'2025-11-28 10:16:30',NULL,'2025-11-28 10:16:30',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('19b05de55f9c4d01b1f314f50aa66e6e','heat_stack_user','{}','<<null>>',NULL),('2412ac8e3fcc4ad2bb47433bdaa1fa75','reader','{}','<<null>>',NULL),('272a3f8e0a7246019a978a4004d5f3f2','swiftoperator','{}','<<null>>',NULL),('2730d0ff14d741bd9e6c60c570a153b7','admin','{}','<<null>>',NULL),('37803348eee54a1484e11e63d6915add','service','{}','<<null>>',NULL),('f9468b44e1534b7da74729620e342ef9','member','{}','<<null>>',NULL),('fb07db2d79cd410ba3acbc79f475716f','ResellerAdmin','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('2412ac8e3fcc4ad2bb47433bdaa1fa75','IMMU','true'),('2730d0ff14d741bd9e6c60c570a153b7','IMMU','true'),('f9468b44e1534b7da74729620e342ef9','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('19718d5ea2f94a1fbb6f8e1c47732fe5','share',1,'{\"description\": \"Manila V1 Service\", \"name\": \"manila\"}'),('22da0d7f3f66485f88e4b29ef9ee1ec6','sharev2',1,'{\"description\": \"Manila V2 Service\", \"name\": \"manilav2\"}'),('45210e5f59744d57b48cdead64587be4','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('45da105b23b64c2d91b3218c9a97c456','cloudformation',1,'{\"description\": \"Heat Cloudformation API service\", \"name\": \"heat-cfn\"}'),('4db04cc4905f4af5aa5ca31068b811bc','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}'),('51ae879ca152446497cd73a15fdb420c','orchestration',1,'{\"description\": \"Heat API service\", \"name\": \"heat\"}'),('6650354ecf7a44bbbf58c30b5629cc42','alarming',1,'{\"description\": \"Aodh for autoscaling Service\", \"name\": \"aodh\"}'),('79be73d345fc412487f607f6317897d6','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}'),('83e40eb728934d7eb62fd036033aa5c3','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('b0913dc275dc43b38f06511a7907670c','identity',1,'{\"name\": \"keystone\"}'),('d5c725f751d64b90b89de705fce7b5fa','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('f9b2b1cb06574dc2bbc7dd48ebe10182','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}'),('fe9b389d8c6749d7985c12016223c7bd','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`inherited` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','4d9169247d4447d0a8dd4c33f8b23dee','system','2730d0ff14d741bd9e6c60c570a153b7',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_expires` (`expires`),
  KEY `ix_token_expires_valid` (`expires`,`valid`),
  KEY `ix_token_user_id` (`user_id`),
  KEY `ix_token_trust_id` (`trust_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`valid` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`impersonation` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
INSERT INTO `trust` (`id`, `trustor_user_id`, `trustee_user_id`, `project_id`, `impersonation`, `deleted_at`, `expires_at`, `remaining_uses`, `extra`, `expires_at_int`, `redelegated_trust_id`, `redelegation_count`) VALUES ('43ec8d626a0146958740c5d7656969ee','f152fde9d8f542cb87a13c43a795e62f','4c950481738f4efba6d02a37cd58cc94','9c8d8e5a130b492a9dc9daba498c0cfc',0,'2025-11-28 10:04:32',NULL,NULL,'{\"roles\": [{\"id\": \"9cbdc0bbed094592a0a90abb6a33b495\"}]}',NULL,NULL,0),('a40db55dde3a4f7a87681590bc0af397','065b83b6f1884cb7bda95e36ef496584','4c950481738f4efba6d02a37cd58cc94','8d7f9329049b453f817567e677faca33',1,'2025-11-28 10:04:30',NULL,NULL,'{\"roles\": [{\"id\": \"f5858f1a23ae41b2b81fc3c912199bb6\"}]}',NULL,NULL,0),('b82f91e1a3e14a01973734678f4724f9','a89a596b9bac4351a6070dcff732ad03','4c950481738f4efba6d02a37cd58cc94','dc61616595214fc5bab09aea5a481656',1,'2025-11-28 10:04:24','2025-11-28 11:04:22',NULL,'{\"roles\": [{\"id\": \"e9665dad69c541f1a9258eda89804095\"}]}',1764327862000000,NULL,0),('c17b7241bb3341288fc21c55f8c54b99','437b6784c91044009b391e569a528556','4c950481738f4efba6d02a37cd58cc94','0e1b817e7b774c91af81657cdda45508',1,'2025-11-28 10:04:21',NULL,NULL,'{\"roles\": [{\"id\": \"eb60abade05d412d8c01d451455d3685\"}]}',NULL,NULL,0),('fc11832f951e4045b5cf0848f58a6cd6','e88bdd0d25784c05a16af6bada539278','4c950481738f4efba6d02a37cd58cc94','43746927d3ab4eb8af9efbe421e8266e',1,'2025-11-28 10:04:18',NULL,NULL,'{\"roles\": [{\"id\": \"17304ba2c1d6439ca332720b3a321af4\"}]}',NULL,NULL,0);
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
INSERT INTO `trust_role` (`trust_id`, `role_id`) VALUES ('43ec8d626a0146958740c5d7656969ee','9cbdc0bbed094592a0a90abb6a33b495'),('a40db55dde3a4f7a87681590bc0af397','f5858f1a23ae41b2b81fc3c912199bb6'),('b82f91e1a3e14a01973734678f4724f9','e9665dad69c541f1a9258eda89804095'),('c17b7241bb3341288fc21c55f8c54b99','eb60abade05d412d8c01d451455d3685'),('fc11832f951e4045b5cf0848f58a6cd6','17304ba2c1d6439ca332720b3a321af4');
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `domain_id` (`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('069be17722904b06be51a88095236729','{\"email\": \"heat-cfn@localhost\", \"description\": null}',1,NULL,'2025-11-28 08:17:42',NULL,'default'),('0d543a6dcb564de5b39062ca08440499','{\"email\": \"neutron@localhost\", \"description\": null}',1,NULL,'2025-11-28 08:17:51','2025-11-28','default'),('176f6a8192694fdc8f5a874f565dae4f','{\"email\": \"swift@localhost\", \"description\": null}',1,NULL,'2025-11-28 08:17:52','2025-11-28','default'),('1f2d1d5b87f64cd6b5ffb655a337a986','{\"tenantId\": \"c326253de5044a60be18dcfa12e29a2c\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2025-11-28 09:59:38','2025-11-28','default'),('20dd68de85a14e1597411b67f815a244','{}',1,'e2c76e4d27554fd5a4f85cce208b136f','2025-11-28 08:48:58','2025-11-28','default'),('2295229c552d4f70bade64908b85fbc4','{\"email\": \"gnocchi@localhost\", \"description\": null}',1,NULL,'2025-11-28 08:17:41','2025-11-28','default'),('2c8f139093484298a0d156130273e0b1','{\"email\": \"manila@localhost\", \"description\": null}',1,NULL,'2025-11-28 08:17:42','2025-11-28','default'),('2e0fb7f84a3e447ab26824c8de1937e6','{\"email\": \"heat_stack_domain_admin@localhost\", \"description\": null}',1,NULL,'2025-11-28 08:17:41',NULL,'f8357292046f427cac08ac9d6a7512b6'),('4d9169247d4447d0a8dd4c33f8b23dee','{\"email\": \"admin@localhost\"}',1,NULL,'2025-11-28 08:15:14','2025-11-28','default'),('4eaac26ddf16416eb8e7962b917a291d','{\"email\": \"heat@localhost\", \"description\": null}',1,NULL,'2025-11-28 08:17:41','2025-11-28','default'),('5230cee3a0274ecc89c935a3aa7dbad1','{\"tenantId\": \"a09b875cf74047b3b7a00da606f36904\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2025-11-28 09:59:39',NULL,'default'),('657c117bbb694de4b647b6f4c16afb44','{\"email\": \"placement@localhost\", \"description\": null}',1,NULL,'2025-11-28 08:17:52','2025-11-28','default'),('7d7888cde8444ea191022389b22bb7f2','{\"email\": \"cinder@localhost\", \"description\": null}',1,NULL,'2025-11-28 08:17:39','2025-11-28','default'),('80832b2c07e64888adb9ec3c64cf8f39','{\"email\": \"glance@localhost\", \"description\": null}',1,NULL,'2025-11-28 08:17:40','2025-11-28','default'),('9106a54d8d90470c87b4256768613691','{\"email\": \"manilav2@localhost\", \"description\": null}',1,NULL,'2025-11-28 08:17:51',NULL,'default'),('9e5033e84dec44f4956046cabe7e22af','{\"email\": \"nova@localhost\", \"description\": null}',1,NULL,'2025-11-28 08:17:52','2025-11-28','default'),('b49d2f4029e74b29872c82f75d741e99','{\"email\": \"ceilometer@localhost\", \"description\": null}',1,NULL,'2025-11-28 08:17:39','2025-11-28','default'),('d71fc4c5f0a54a339aa0e15fff315b07','{\"email\": \"aodh@localhost\", \"description\": null}',1,NULL,'2025-11-28 08:17:39','2025-11-28','default'),('e8269f1ec92a49e2bb9d5152bb96a794','{\"email\": \"cinderv3@localhost\", \"description\": null}',1,NULL,'2025-11-28 08:17:40',NULL,'default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `manila`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `manila` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `manila`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('aebe2a413e13');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `async_operation_data`
--

DROP TABLE IF EXISTS `async_operation_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `async_operation_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `async_operation_data`
--

LOCK TABLES `async_operation_data` WRITE;
/*!40000 ALTER TABLE `async_operation_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `async_operation_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `availability_zones`
--

DROP TABLE IF EXISTS `availability_zones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `availability_zones` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `az_name_uc` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `availability_zones`
--

LOCK TABLES `availability_zones` WRITE;
/*!40000 ALTER TABLE `availability_zones` DISABLE KEYS */;
INSERT INTO `availability_zones` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`) VALUES ('2025-11-28 08:19:25.203598',NULL,NULL,'False','49785509-54bf-4198-9d2c-820184b44d63','nova');
/*!40000 ALTER TABLE `availability_zones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backend_info`
--

DROP TABLE IF EXISTS `backend_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backend_info` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `host` varchar(255) NOT NULL,
  `info_hash` varchar(255) NOT NULL,
  PRIMARY KEY (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backend_info`
--

LOCK TABLES `backend_info` WRITE;
/*!40000 ALTER TABLE `backend_info` DISABLE KEYS */;
INSERT INTO `backend_info` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `host`, `info_hash`) VALUES ('2025-11-28 09:01:58.974063',NULL,NULL,0,'hostgroup@cephfs','e66c0dfc0d422efa26af62f5a81dd60603e2d39a');
/*!40000 ALTER TABLE `backend_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `drivers_private_data`
--

DROP TABLE IF EXISTS `drivers_private_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `drivers_private_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `drivers_private_data`
--

LOCK TABLES `drivers_private_data` WRITE;
/*!40000 ALTER TABLE `drivers_private_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `drivers_private_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(255) DEFAULT NULL,
  `resource_id` varchar(36) DEFAULT NULL,
  `action_id` varchar(10) NOT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
INSERT INTO `messages` (`id`, `project_id`, `request_id`, `resource_type`, `resource_id`, `action_id`, `detail_id`, `message_level`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `expires_at`) VALUES ('0a91ab1f-e648-414a-a39f-4e22b662171f','2cc8a146763846fabfe8e260b70f3971','req-4121cc05-ee7e-492a-9ce9-b414473a0fcd','SHARE','9bcba301-b7f5-4281-b335-245ce71b4f14','001','008','ERROR','2025-11-28 10:09:30.779490',NULL,NULL,'False','2025-12-28 10:09:30'),('123b12aa-ad91-497d-a315-e4bd596ebeb5','56c91df0287e4974b45f4ed0b63d771d','req-33d22ad4-175a-4b4d-8cf7-e0666bc71069','SHARE','3ce16d0d-0880-4d5b-a3a1-4851c6b74364','001','008','ERROR','2025-11-28 10:09:23.128846',NULL,NULL,'False','2025-12-28 10:09:23'),('176eadee-1824-4c6d-ba26-de2ef90f6c63','56c91df0287e4974b45f4ed0b63d771d','req-bdb7a968-6dd7-4e69-99c4-8d029875245e','SHARE','d927a7f6-21ca-4568-9e3d-881f9a18d255','001','008','ERROR','2025-11-28 10:09:57.405021',NULL,'2025-11-28 10:10:00.484929','176eadee-1824-4c6d-ba26-de2ef90f6c63','2025-12-28 10:09:57'),('21fb5f3a-07c6-4c17-a783-89e48ff7355b','56c91df0287e4974b45f4ed0b63d771d','req-c0722a33-82d4-44eb-a8bc-22f857864df5','SHARE','c7c38121-6711-4126-95cb-96796f10c693','001','008','ERROR','2025-11-28 10:09:33.875319',NULL,NULL,'False','2025-12-28 10:09:33'),('4767a5c7-86dd-4ced-aaf0-bbb1e3748db9','56c91df0287e4974b45f4ed0b63d771d','req-957c06e4-9070-4aeb-ba72-05b48761900e','SHARE','164405d2-771f-449d-a0fd-fffde1b22b8a','001','008','ERROR','2025-11-28 10:09:26.474064',NULL,NULL,'False','2025-12-28 10:09:26'),('575d49fb-783c-410b-944c-7bc0510b3ad2','56c91df0287e4974b45f4ed0b63d771d','req-8988f0a2-a74d-4cb6-ab80-82ee4add8dfc','SHARE','198f6085-294c-4144-b470-0fe1f3a7acd7','001','008','ERROR','2025-11-28 10:09:19.618543',NULL,NULL,'False','2025-12-28 10:09:19'),('5e6e19aa-4517-4340-8631-268afa3ce5f0','2cc8a146763846fabfe8e260b70f3971','req-34dff84d-4928-44ba-8cab-35d87436c225','SHARE','135d33f1-7eb6-4136-b081-5eb5ed0056de','001','008','ERROR','2025-11-28 10:09:37.967641',NULL,NULL,'False','2025-12-28 10:09:37'),('6376a299-4e1d-4e00-bbdc-1943b21286a6','2cc8a146763846fabfe8e260b70f3971','req-1c432692-1667-4a1f-8719-f07156ecf050','SHARE','5cd6feec-2710-4666-9575-ec810230bcc7','001','008','ERROR','2025-11-28 10:09:45.075172',NULL,NULL,'False','2025-12-28 10:09:45'),('730df400-5de3-400b-b903-1216e7094a03','2cc8a146763846fabfe8e260b70f3971','req-d55bdfc3-6f51-4ef5-80c0-4c2778bc537b','SHARE','03e06571-bf61-4b13-9cbb-6e9c411cd828','001','008','ERROR','2025-11-28 10:09:41.471693',NULL,NULL,'False','2025-12-28 10:09:41'),('75e35881-278a-4725-8ab9-cde157ad5651','56c91df0287e4974b45f4ed0b63d771d','req-a4f55dd4-61f9-481b-9a07-7dff0a387072','SHARE','c4966eef-17d6-4fa3-a5f2-2e3062d8f632','001','008','ERROR','2025-11-28 10:09:44.149675',NULL,NULL,'False','2025-12-28 10:09:44'),('86d6d475-6f99-4b2f-bb18-b042f5a1f3d7','56c91df0287e4974b45f4ed0b63d771d','req-8205f1ad-8a43-4989-9807-3c2d1bf3e2bd','SHARE','88d2dac6-ab1e-42ed-b733-265a43f7280d','001','008','ERROR','2025-11-28 10:09:12.867764',NULL,'2025-11-28 10:09:18.987520','86d6d475-6f99-4b2f-bb18-b042f5a1f3d7','2025-12-28 10:09:12'),('a42eae17-5dd4-4345-8e2b-e9ae21938e9f','2cc8a146763846fabfe8e260b70f3971','req-526c6e4c-a3de-4382-b71d-940fb73ac731','SHARE','3611d81c-ec40-499d-ab9b-e5c378e17dbb','001','008','ERROR','2025-11-28 10:09:34.406832',NULL,NULL,'False','2025-12-28 10:09:34'),('b973d448-54b0-4a2e-b176-3e3fa4deae9d','56c91df0287e4974b45f4ed0b63d771d','req-c4639011-db49-4aa9-b8d4-547e653aa6e1','SHARE','a628a1a3-1286-480b-9777-7ef3279102bb','001','008','ERROR','2025-11-28 10:09:30.618277',NULL,NULL,'False','2025-12-28 10:09:30'),('bc20b96c-d530-4856-a0bc-556f041a39e5','301971e834c14ea7aa009696c3f04782','req-40be4548-0d4f-447e-a3fe-06ba1dadcc2a','SHARE','6172a82a-87af-44bc-9def-f9261d205c20','010','020','ERROR','2025-11-28 10:14:26.885429',NULL,NULL,'False','2025-12-28 10:14:26'),('cbdf0dc3-d05b-49f4-91b7-6958da154e22','56c91df0287e4974b45f4ed0b63d771d','req-579829bc-a5f4-4b1c-96d4-c380e306a11c','SHARE','47e9a475-c28f-472a-bbbf-8827a01e2b59','001','008','ERROR','2025-11-28 10:09:50.638311',NULL,NULL,'False','2025-12-28 10:09:50'),('ea3a6a5a-a94e-4a3a-858d-bc7989d8b242','56c91df0287e4974b45f4ed0b63d771d','req-5bbdb4fe-a52c-497b-8543-e12a996806e2','SHARE','e1adbf32-01c2-41ce-9c17-7ae5e812b5e3','001','008','ERROR','2025-11-28 10:09:40.199070',NULL,NULL,'False','2025-12-28 10:09:40');
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `network_allocations`
--

DROP TABLE IF EXISTS `network_allocations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `network_allocations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ip_address` varchar(64) DEFAULT NULL,
  `mac_address` varchar(32) DEFAULT NULL,
  `share_server_id` varchar(36) NOT NULL,
  `label` varchar(255) DEFAULT 'user',
  `network_type` varchar(32) DEFAULT NULL,
  `segmentation_id` int(11) DEFAULT NULL,
  `ip_version` int(11) DEFAULT NULL,
  `cidr` varchar(64) DEFAULT NULL,
  `gateway` varchar(64) DEFAULT NULL,
  `mtu` int(11) DEFAULT NULL,
  `share_network_subnet_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_server_id` (`share_server_id`),
  KEY `fk_network_allocation_subnet_id_share_network_subnets` (`share_network_subnet_id`),
  CONSTRAINT `fk_network_allocation_subnet_id_share_network_subnets` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`),
  CONSTRAINT `network_allocations_ibfk_1` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `network_allocations`
--

LOCK TABLES `network_allocations` WRITE;
/*!40000 ALTER TABLE `network_allocations` DISABLE KEYS */;
/*!40000 ALTER TABLE `network_allocations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_share_type_quotas`
--

DROP TABLE IF EXISTS `project_share_type_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_share_type_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uc_quotas_per_share_types` (`share_type_id`,`resource`,`deleted`,`project_id`),
  CONSTRAINT `share_type_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_share_type_quotas`
--

LOCK TABLES `project_share_type_quotas` WRITE;
/*!40000 ALTER TABLE `project_share_type_quotas` DISABLE KEYS */;
INSERT INTO `project_share_type_quotas` (`id`, `project_id`, `resource`, `hard_limit`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `share_type_id`) VALUES (1,'3e75d8532ea44ff88f2e686f89303ba0','shares',2,'2025-11-28 10:09:51.471234',NULL,'2025-11-28 10:10:11.301428',1,'01098295-4230-40a5-a351-8cabb1732714'),(2,'3e75d8532ea44ff88f2e686f89303ba0','gigabytes',4,'2025-11-28 10:09:51.476041',NULL,'2025-11-28 10:10:11.301428',2,'01098295-4230-40a5-a351-8cabb1732714'),(3,'3e75d8532ea44ff88f2e686f89303ba0','shares',2,'2025-11-28 10:09:51.561843',NULL,'2025-11-28 10:10:11.249199',3,'5a147245-c70c-4d91-92f3-86f2fe59f721'),(4,'3e75d8532ea44ff88f2e686f89303ba0','gigabytes',4,'2025-11-28 10:09:51.567141',NULL,'2025-11-28 10:10:11.249199',4,'5a147245-c70c-4d91-92f3-86f2fe59f721'),(5,'3e75d8532ea44ff88f2e686f89303ba0','shares',53,'2025-11-28 10:10:05.289830',NULL,'2025-11-28 10:10:05.337293',5,'cc07a96c-0df9-4937-aec9-fef9effea32a'),(6,'3e75d8532ea44ff88f2e686f89303ba0','snapshots',53,'2025-11-28 10:10:05.294383',NULL,'2025-11-28 10:10:05.337293',6,'cc07a96c-0df9-4937-aec9-fef9effea32a'),(7,'3e75d8532ea44ff88f2e686f89303ba0','gigabytes',1003,'2025-11-28 10:10:05.298119',NULL,'2025-11-28 10:10:05.337293',7,'cc07a96c-0df9-4937-aec9-fef9effea32a'),(8,'3e75d8532ea44ff88f2e686f89303ba0','snapshot_gigabytes',1003,'2025-11-28 10:10:05.301843',NULL,'2025-11-28 10:10:05.337293',8,'cc07a96c-0df9-4937-aec9-fef9effea32a'),(9,'3e75d8532ea44ff88f2e686f89303ba0','share_replicas',103,'2025-11-28 10:10:05.305545',NULL,'2025-11-28 10:10:05.337293',9,'cc07a96c-0df9-4937-aec9-fef9effea32a'),(10,'3e75d8532ea44ff88f2e686f89303ba0','replica_gigabytes',1003,'2025-11-28 10:10:05.311825',NULL,'2025-11-28 10:10:05.337293',10,'cc07a96c-0df9-4937-aec9-fef9effea32a'),(11,'3e75d8532ea44ff88f2e686f89303ba0','shares',53,'2025-11-28 10:10:05.614100',NULL,'2025-11-28 10:10:05.662038',11,'5181c18a-0cc8-4aeb-a336-912c4cafe6d4'),(12,'3e75d8532ea44ff88f2e686f89303ba0','snapshots',53,'2025-11-28 10:10:05.618155',NULL,'2025-11-28 10:10:05.662038',12,'5181c18a-0cc8-4aeb-a336-912c4cafe6d4'),(13,'3e75d8532ea44ff88f2e686f89303ba0','gigabytes',1003,'2025-11-28 10:10:05.621355',NULL,'2025-11-28 10:10:05.662038',13,'5181c18a-0cc8-4aeb-a336-912c4cafe6d4'),(14,'3e75d8532ea44ff88f2e686f89303ba0','snapshot_gigabytes',1003,'2025-11-28 10:10:05.624910',NULL,'2025-11-28 10:10:05.662038',14,'5181c18a-0cc8-4aeb-a336-912c4cafe6d4'),(15,'3e75d8532ea44ff88f2e686f89303ba0','share_replicas',103,'2025-11-28 10:10:05.628233',NULL,'2025-11-28 10:10:05.662038',15,'5181c18a-0cc8-4aeb-a336-912c4cafe6d4'),(16,'3e75d8532ea44ff88f2e686f89303ba0','replica_gigabytes',1003,'2025-11-28 10:10:05.632329',NULL,'2025-11-28 10:10:05.662038',16,'5181c18a-0cc8-4aeb-a336-912c4cafe6d4'),(17,'3e75d8532ea44ff88f2e686f89303ba0','shares',12,'2025-11-28 10:10:06.140411',NULL,'2025-11-28 10:10:11.059597',17,'2a907469-1633-4670-b953-7bf6bae478a2'),(18,'3e75d8532ea44ff88f2e686f89303ba0','shares',49,'2025-11-28 10:10:07.622382',NULL,'2025-11-28 10:10:10.988044',18,'32e64882-0d49-434a-bf22-fb2104469a4f'),(19,'3e75d8532ea44ff88f2e686f89303ba0','gigabytes',999,'2025-11-28 10:10:07.671956',NULL,'2025-11-28 10:10:10.988044',19,'32e64882-0d49-434a-bf22-fb2104469a4f'),(20,'3e75d8532ea44ff88f2e686f89303ba0','snapshots',49,'2025-11-28 10:10:07.725618',NULL,'2025-11-28 10:10:10.988044',20,'32e64882-0d49-434a-bf22-fb2104469a4f'),(21,'3e75d8532ea44ff88f2e686f89303ba0','snapshot_gigabytes',999,'2025-11-28 10:10:07.778700',NULL,'2025-11-28 10:10:10.988044',21,'32e64882-0d49-434a-bf22-fb2104469a4f'),(22,'3e75d8532ea44ff88f2e686f89303ba0','share_replicas',99,'2025-11-28 10:10:07.833447',NULL,'2025-11-28 10:10:10.988044',22,'32e64882-0d49-434a-bf22-fb2104469a4f'),(23,'3e75d8532ea44ff88f2e686f89303ba0','replica_gigabytes',999,'2025-11-28 10:10:07.887333',NULL,'2025-11-28 10:10:10.988044',23,'32e64882-0d49-434a-bf22-fb2104469a4f'),(24,'3e75d8532ea44ff88f2e686f89303ba0','shares',49,'2025-11-28 10:10:08.066703',NULL,'2025-11-28 10:10:10.933064',24,'c3564038-3696-4f02-be06-264c03d03f5e'),(25,'3e75d8532ea44ff88f2e686f89303ba0','gigabytes',999,'2025-11-28 10:10:08.149588',NULL,'2025-11-28 10:10:10.933064',25,'c3564038-3696-4f02-be06-264c03d03f5e'),(26,'3e75d8532ea44ff88f2e686f89303ba0','snapshots',49,'2025-11-28 10:10:08.221243',NULL,'2025-11-28 10:10:10.933064',26,'c3564038-3696-4f02-be06-264c03d03f5e'),(27,'3e75d8532ea44ff88f2e686f89303ba0','snapshot_gigabytes',999,'2025-11-28 10:10:08.295057',NULL,'2025-11-28 10:10:10.933064',27,'c3564038-3696-4f02-be06-264c03d03f5e'),(28,'3e75d8532ea44ff88f2e686f89303ba0','share_replicas',99,'2025-11-28 10:10:08.390161',NULL,'2025-11-28 10:10:10.933064',28,'c3564038-3696-4f02-be06-264c03d03f5e'),(29,'3e75d8532ea44ff88f2e686f89303ba0','replica_gigabytes',999,'2025-11-28 10:10:08.485044',NULL,'2025-11-28 10:10:10.933064',29,'c3564038-3696-4f02-be06-264c03d03f5e'),(30,'3e75d8532ea44ff88f2e686f89303ba0','shares',11,'2025-11-28 10:10:08.662298',NULL,'2025-11-28 10:10:10.878190',30,'f37ad62d-1fc0-449f-8bf2-01f087185640'),(31,'3e75d8532ea44ff88f2e686f89303ba0','shares',-1,'2025-11-28 10:10:08.821798',NULL,'2025-11-28 10:10:10.817818',31,'4b5dd723-ddc7-43f9-90e4-c5928cec788a');
/*!40000 ALTER TABLE `project_share_type_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_user_quotas`
--

DROP TABLE IF EXISTS `project_user_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_user_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `resource` varchar(25) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_user_quotas`
--

LOCK TABLES `project_user_quotas` WRITE;
/*!40000 ALTER TABLE `project_user_quotas` DISABLE KEYS */;
INSERT INTO `project_user_quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `user_id`, `project_id`, `resource`, `hard_limit`) VALUES (1,'2025-11-28 10:09:51.373804',NULL,'2025-11-28 10:10:05.041682',1,'d405e1ced93a4b7f9732c9daccfc5d43','3e75d8532ea44ff88f2e686f89303ba0','shares',2),(2,'2025-11-28 10:09:51.381571',NULL,'2025-11-28 10:10:05.041682',2,'d405e1ced93a4b7f9732c9daccfc5d43','3e75d8532ea44ff88f2e686f89303ba0','gigabytes',7),(3,'2025-11-28 10:10:06.072178',NULL,'2025-11-28 10:10:06.159790',3,'d405e1ced93a4b7f9732c9daccfc5d43','3e75d8532ea44ff88f2e686f89303ba0','shares',11),(4,'2025-11-28 10:10:06.765361',NULL,'2025-11-28 10:10:06.810889',4,'d405e1ced93a4b7f9732c9daccfc5d43','3e75d8532ea44ff88f2e686f89303ba0','gigabytes',-1),(5,'2025-11-28 10:10:06.911878',NULL,'2025-11-28 10:10:06.964714',5,'d405e1ced93a4b7f9732c9daccfc5d43','3e75d8532ea44ff88f2e686f89303ba0','share_replicas',-1),(6,'2025-11-28 10:10:07.027722',NULL,'2025-11-28 10:10:07.074688',6,'d405e1ced93a4b7f9732c9daccfc5d43','3e75d8532ea44ff88f2e686f89303ba0','replica_gigabytes',-1),(7,'2025-11-28 10:10:07.136651',NULL,'2025-11-28 10:10:07.210313',7,'d405e1ced93a4b7f9732c9daccfc5d43','3e75d8532ea44ff88f2e686f89303ba0','share_networks',-1),(8,'2025-11-28 10:10:07.267329',NULL,'2025-11-28 10:10:07.320227',8,'d405e1ced93a4b7f9732c9daccfc5d43','3e75d8532ea44ff88f2e686f89303ba0','shares',-1),(9,'2025-11-28 10:10:07.376622',NULL,'2025-11-28 10:10:07.421242',9,'d405e1ced93a4b7f9732c9daccfc5d43','3e75d8532ea44ff88f2e686f89303ba0','snapshot_gigabytes',-1),(10,'2025-11-28 10:10:07.479904',NULL,'2025-11-28 10:10:07.522611',10,'d405e1ced93a4b7f9732c9daccfc5d43','3e75d8532ea44ff88f2e686f89303ba0','snapshots',-1),(11,'2025-11-28 10:10:09.473579',NULL,'2025-11-28 10:10:09.496589',11,'d405e1ced93a4b7f9732c9daccfc5d43','3e75d8532ea44ff88f2e686f89303ba0','gigabytes',999),(12,'2025-11-28 10:10:09.783215',NULL,'2025-11-28 10:10:09.810554',12,'d405e1ced93a4b7f9732c9daccfc5d43','3e75d8532ea44ff88f2e686f89303ba0','share_replicas',99),(13,'2025-11-28 10:10:10.010575',NULL,'2025-11-28 10:10:10.042234',13,'d405e1ced93a4b7f9732c9daccfc5d43','3e75d8532ea44ff88f2e686f89303ba0','replica_gigabytes',999),(14,'2025-11-28 10:10:10.104105',NULL,'2025-11-28 10:10:10.122224',14,'d405e1ced93a4b7f9732c9daccfc5d43','3e75d8532ea44ff88f2e686f89303ba0','share_networks',9),(15,'2025-11-28 10:10:10.210579',NULL,'2025-11-28 10:10:10.245911',15,'d405e1ced93a4b7f9732c9daccfc5d43','3e75d8532ea44ff88f2e686f89303ba0','shares',49),(16,'2025-11-28 10:10:10.310356',NULL,'2025-11-28 10:10:10.331777',16,'d405e1ced93a4b7f9732c9daccfc5d43','3e75d8532ea44ff88f2e686f89303ba0','snapshot_gigabytes',999),(17,'2025-11-28 10:10:10.422818',NULL,'2025-11-28 10:10:10.456258',17,'d405e1ced93a4b7f9732c9daccfc5d43','3e75d8532ea44ff88f2e686f89303ba0','snapshots',49),(18,'2025-11-28 10:10:10.578293',NULL,'2025-11-28 10:10:10.601962',18,'d405e1ced93a4b7f9732c9daccfc5d43','3e75d8532ea44ff88f2e686f89303ba0','shares',11),(19,'2025-11-28 10:10:10.728544',NULL,'2025-11-28 10:10:10.757592',19,'d405e1ced93a4b7f9732c9daccfc5d43','3e75d8532ea44ff88f2e686f89303ba0','shares',-1);
/*!40000 ALTER TABLE `project_user_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_usages_project_id` (`project_id`)
) ENGINE=InnoDB AUTO_INCREMENT=270 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `share_type_id`) VALUES ('2025-11-28 10:06:48.036748','2025-11-28 10:08:17.605737',NULL,0,1,'397ae286549f4936afa2820dae60ba57','3b3a94b107524e81a6368eb9596632ef','shares',0,0,NULL,NULL),('2025-11-28 10:06:48.041931','2025-11-28 10:08:17.605740',NULL,0,2,'397ae286549f4936afa2820dae60ba57','3b3a94b107524e81a6368eb9596632ef','gigabytes',0,0,NULL,NULL),('2025-11-28 10:06:48.062383','2025-11-28 10:08:17.605741','2025-11-28 10:08:20.425832',3,3,NULL,'3b3a94b107524e81a6368eb9596632ef','shares',0,0,NULL,'b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:06:48.066137','2025-11-28 10:08:17.605742','2025-11-28 10:08:20.425832',4,4,NULL,'3b3a94b107524e81a6368eb9596632ef','gigabytes',0,0,NULL,'b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:30.561062','2025-11-28 10:08:14.254830',NULL,0,5,'397ae286549f4936afa2820dae60ba57','3b3a94b107524e81a6368eb9596632ef','snapshots',0,0,NULL,NULL),('2025-11-28 10:07:30.564754','2025-11-28 10:08:14.254834',NULL,0,6,'397ae286549f4936afa2820dae60ba57','3b3a94b107524e81a6368eb9596632ef','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-28 10:07:30.577361','2025-11-28 10:08:14.254836','2025-11-28 10:08:20.425832',7,7,NULL,'3b3a94b107524e81a6368eb9596632ef','snapshots',0,0,NULL,'b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:30.581404','2025-11-28 10:08:14.254839','2025-11-28 10:08:20.425832',8,8,NULL,'3b3a94b107524e81a6368eb9596632ef','snapshot_gigabytes',0,0,NULL,'b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:35.573782','2025-11-28 10:07:47.831666',NULL,0,9,'f802db1a51604b1dbdd96ee766d48fa6','a569d731bef04fb89d34131fc9ebf2c6','shares',0,0,NULL,NULL),('2025-11-28 10:07:35.577681','2025-11-28 10:07:47.831669',NULL,0,10,'f802db1a51604b1dbdd96ee766d48fa6','a569d731bef04fb89d34131fc9ebf2c6','gigabytes',0,0,NULL,NULL),('2025-11-28 10:07:35.588576','2025-11-28 10:07:47.831670','2025-11-28 10:07:50.761901',11,11,NULL,'a569d731bef04fb89d34131fc9ebf2c6','shares',0,0,NULL,'d3ceaea7-88b9-454d-8532-5f948430c211'),('2025-11-28 10:07:35.592455','2025-11-28 10:07:47.831671','2025-11-28 10:07:50.761901',12,12,NULL,'a569d731bef04fb89d34131fc9ebf2c6','gigabytes',0,0,NULL,'d3ceaea7-88b9-454d-8532-5f948430c211'),('2025-11-28 10:07:39.135799','2025-11-28 10:07:44.055953',NULL,0,13,'f802db1a51604b1dbdd96ee766d48fa6','a569d731bef04fb89d34131fc9ebf2c6','snapshots',0,0,NULL,NULL),('2025-11-28 10:07:39.138969','2025-11-28 10:07:44.055956',NULL,0,14,'f802db1a51604b1dbdd96ee766d48fa6','a569d731bef04fb89d34131fc9ebf2c6','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-28 10:07:39.152216','2025-11-28 10:07:44.055957','2025-11-28 10:07:50.761901',15,15,NULL,'a569d731bef04fb89d34131fc9ebf2c6','snapshots',0,0,NULL,'d3ceaea7-88b9-454d-8532-5f948430c211'),('2025-11-28 10:07:39.158700','2025-11-28 10:07:44.055958','2025-11-28 10:07:50.761901',16,16,NULL,'a569d731bef04fb89d34131fc9ebf2c6','snapshot_gigabytes',0,0,NULL,'d3ceaea7-88b9-454d-8532-5f948430c211'),('2025-11-28 10:08:06.120575','2025-11-28 10:08:09.943852',NULL,0,17,'cedb40889fbd4a029cbd1938fd1266ee','8c33f10ccf134f4faab82ed622e3c707','shares',0,0,NULL,NULL),('2025-11-28 10:08:06.125145','2025-11-28 10:08:09.943855',NULL,0,18,'cedb40889fbd4a029cbd1938fd1266ee','8c33f10ccf134f4faab82ed622e3c707','gigabytes',0,0,NULL,NULL),('2025-11-28 10:08:06.140815','2025-11-28 10:08:09.943856','2025-11-28 10:08:12.783927',19,19,NULL,'8c33f10ccf134f4faab82ed622e3c707','shares',0,0,NULL,'cf1a6cda-dacb-4121-8321-fcda1cab307d'),('2025-11-28 10:08:06.145700','2025-11-28 10:08:09.943857','2025-11-28 10:08:12.783927',20,20,NULL,'8c33f10ccf134f4faab82ed622e3c707','gigabytes',0,0,NULL,'cf1a6cda-dacb-4121-8321-fcda1cab307d'),('2025-11-28 10:08:16.140162','2025-11-28 10:09:14.073335',NULL,0,21,'571c8db1d62c42b2a968a166578b720c','761c122e3fe94bb6be6f10c7921c5430','shares',0,0,NULL,NULL),('2025-11-28 10:08:16.142637','2025-11-28 10:09:14.073338',NULL,0,22,'571c8db1d62c42b2a968a166578b720c','761c122e3fe94bb6be6f10c7921c5430','gigabytes',0,0,NULL,NULL),('2025-11-28 10:08:16.151897','2025-11-28 10:09:14.073339','2025-11-28 10:09:16.882772',23,23,NULL,'761c122e3fe94bb6be6f10c7921c5430','shares',0,0,NULL,'af507655-39b7-440e-b343-057f120fe78f'),('2025-11-28 10:08:16.153621','2025-11-28 10:09:14.073341','2025-11-28 10:09:16.882772',24,24,NULL,'761c122e3fe94bb6be6f10c7921c5430','gigabytes',0,0,NULL,'af507655-39b7-440e-b343-057f120fe78f'),('2025-11-28 10:08:19.434358','2025-11-28 10:09:10.826960',NULL,0,25,'571c8db1d62c42b2a968a166578b720c','761c122e3fe94bb6be6f10c7921c5430','snapshots',0,0,NULL,NULL),('2025-11-28 10:08:19.436358','2025-11-28 10:09:10.826963',NULL,0,26,'571c8db1d62c42b2a968a166578b720c','761c122e3fe94bb6be6f10c7921c5430','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-28 10:08:19.452182','2025-11-28 10:09:10.826965','2025-11-28 10:09:16.882772',27,27,NULL,'761c122e3fe94bb6be6f10c7921c5430','snapshots',0,0,NULL,'af507655-39b7-440e-b343-057f120fe78f'),('2025-11-28 10:08:19.454447','2025-11-28 10:09:10.826966','2025-11-28 10:09:16.882772',28,28,NULL,'761c122e3fe94bb6be6f10c7921c5430','snapshot_gigabytes',0,0,NULL,'af507655-39b7-440e-b343-057f120fe78f'),('2025-11-28 10:08:21.175837','2025-11-28 10:08:21.990285',NULL,0,29,'290c95bac4f44f9daecb4d5fbd5ae05f','eaacddd7c7ae44869632c24b4e5d2d1b','share_networks',0,0,NULL,NULL),('2025-11-28 10:08:41.651684','2025-11-28 10:08:41.999074','2025-11-28 10:08:45.285947',30,30,'8c8bbd4325d54a30a3e49517be4e8eee','3f91e76373a34e0880a287181873b7a3','gigabytes',1,0,NULL,NULL),('2025-11-28 10:08:41.654668','2025-11-28 10:08:41.999080','2025-11-28 10:08:45.285947',31,31,'8c8bbd4325d54a30a3e49517be4e8eee','3f91e76373a34e0880a287181873b7a3','shares',1,0,NULL,NULL),('2025-11-28 10:08:41.887396','2025-11-28 10:08:41.999083','2025-11-28 10:08:45.285947',32,32,NULL,'3f91e76373a34e0880a287181873b7a3','gigabytes',1,0,NULL,'3e14384d-bfb8-44c0-8caf-18495421b84d'),('2025-11-28 10:08:41.891390','2025-11-28 10:08:41.999086','2025-11-28 10:08:45.285947',33,33,NULL,'3f91e76373a34e0880a287181873b7a3','shares',1,0,NULL,'3e14384d-bfb8-44c0-8caf-18495421b84d'),('2025-11-28 10:08:42.102919','2025-11-28 10:08:46.359483',NULL,0,34,'e2f26fe9b8734c0fa7e6c6447c03e8e2','fa43b66fb64742319307c393a8613a34','shares',0,0,NULL,NULL),('2025-11-28 10:08:42.105528','2025-11-28 10:08:46.359486',NULL,0,35,'e2f26fe9b8734c0fa7e6c6447c03e8e2','fa43b66fb64742319307c393a8613a34','gigabytes',0,0,NULL,NULL),('2025-11-28 10:08:42.115317','2025-11-28 10:08:46.359488','2025-11-28 10:08:49.203990',36,36,NULL,'fa43b66fb64742319307c393a8613a34','shares',0,0,NULL,'46d729d7-c40b-4017-8e82-bccb637d666c'),('2025-11-28 10:08:42.117207','2025-11-28 10:08:46.359489','2025-11-28 10:08:49.203990',37,37,NULL,'fa43b66fb64742319307c393a8613a34','gigabytes',0,0,NULL,'46d729d7-c40b-4017-8e82-bccb637d666c'),('2025-11-28 10:08:45.370420','2025-11-28 10:08:45.495166','2025-11-28 10:08:52.209755',38,38,'8c8bbd4325d54a30a3e49517be4e8eee','3f91e76373a34e0880a287181873b7a3','shares',2,0,NULL,NULL),('2025-11-28 10:08:45.373847','2025-11-28 10:08:45.495169','2025-11-28 10:08:52.209755',39,39,'8c8bbd4325d54a30a3e49517be4e8eee','3f91e76373a34e0880a287181873b7a3','gigabytes',2,0,NULL,NULL),('2025-11-28 10:08:45.468783','2025-11-28 10:08:45.495170','2025-11-28 10:08:52.209755',40,40,NULL,'3f91e76373a34e0880a287181873b7a3','shares',1,0,NULL,'d1d573e6-f9e2-4736-b87e-8764ea52daaf'),('2025-11-28 10:08:45.470896','2025-11-28 10:08:45.495171','2025-11-28 10:08:52.209755',41,41,NULL,'3f91e76373a34e0880a287181873b7a3','gigabytes',1,0,NULL,'d1d573e6-f9e2-4736-b87e-8764ea52daaf'),('2025-11-28 10:08:48.961557','2025-11-28 10:08:49.044835','2025-11-28 10:08:52.209755',42,42,'8c8bbd4325d54a30a3e49517be4e8eee','3f91e76373a34e0880a287181873b7a3','snapshots',1,0,NULL,NULL),('2025-11-28 10:08:48.963685','2025-11-28 10:08:49.044838','2025-11-28 10:08:52.209755',43,43,'8c8bbd4325d54a30a3e49517be4e8eee','3f91e76373a34e0880a287181873b7a3','snapshot_gigabytes',1,0,NULL,NULL),('2025-11-28 10:08:48.973246','2025-11-28 10:08:49.044840','2025-11-28 10:08:52.209755',44,44,NULL,'3f91e76373a34e0880a287181873b7a3','snapshots',1,0,NULL,'d1d573e6-f9e2-4736-b87e-8764ea52daaf'),('2025-11-28 10:08:48.975656','2025-11-28 10:08:49.044842','2025-11-28 10:08:52.209755',45,45,NULL,'3f91e76373a34e0880a287181873b7a3','snapshot_gigabytes',1,0,NULL,'d1d573e6-f9e2-4736-b87e-8764ea52daaf'),('2025-11-28 10:08:56.103707','2025-11-28 10:08:56.147184',NULL,0,46,'8c8bbd4325d54a30a3e49517be4e8eee','3f91e76373a34e0880a287181873b7a3','snapshot_gigabytes',-1,0,NULL,NULL),('2025-11-28 10:08:56.109660','2025-11-28 10:08:56.147188',NULL,0,47,'8c8bbd4325d54a30a3e49517be4e8eee','3f91e76373a34e0880a287181873b7a3','snapshots',-1,0,NULL,NULL),('2025-11-28 10:08:56.124440','2025-11-28 10:08:56.147190','2025-11-28 10:09:01.704889',48,48,NULL,'3f91e76373a34e0880a287181873b7a3','snapshot_gigabytes',-1,0,NULL,'d1d573e6-f9e2-4736-b87e-8764ea52daaf'),('2025-11-28 10:08:56.129854','2025-11-28 10:08:56.147192','2025-11-28 10:09:01.704889',49,49,NULL,'3f91e76373a34e0880a287181873b7a3','snapshots',-1,0,NULL,'d1d573e6-f9e2-4736-b87e-8764ea52daaf'),('2025-11-28 10:08:56.277556','2025-11-28 10:08:57.792836',NULL,0,50,'4dc754b220f84a609f3f7d67e318f8fc','7b0f6782d0fb431b9fae9ffd3abbcba9','share_networks',0,0,NULL,NULL),('2025-11-28 10:08:56.576010','2025-11-28 10:08:56.610705',NULL,0,51,'3c7061945daf4c41bfb3eb3d7862e9f1','c1c4ecd48c654f85b98d7f86e45ad517','share_networks',1,0,NULL,NULL),('2025-11-28 10:08:58.826195','2025-11-28 10:09:02.055136',NULL,0,52,'8c8bbd4325d54a30a3e49517be4e8eee','3f91e76373a34e0880a287181873b7a3','shares',0,0,NULL,NULL),('2025-11-28 10:08:58.832362','2025-11-28 10:09:02.055138',NULL,0,53,'8c8bbd4325d54a30a3e49517be4e8eee','3f91e76373a34e0880a287181873b7a3','gigabytes',0,0,NULL,NULL),('2025-11-28 10:08:58.848737','2025-11-28 10:08:58.868235','2025-11-28 10:09:01.704889',54,54,NULL,'3f91e76373a34e0880a287181873b7a3','shares',0,0,NULL,'d1d573e6-f9e2-4736-b87e-8764ea52daaf'),('2025-11-28 10:08:58.856265','2025-11-28 10:08:58.868236','2025-11-28 10:09:01.704889',55,55,NULL,'3f91e76373a34e0880a287181873b7a3','gigabytes',0,0,NULL,'d1d573e6-f9e2-4736-b87e-8764ea52daaf'),('2025-11-28 10:09:02.040436','2025-11-28 10:09:02.055140','2025-11-28 10:09:05.068779',56,56,NULL,'3f91e76373a34e0880a287181873b7a3','shares',0,0,NULL,'3e14384d-bfb8-44c0-8caf-18495421b84d'),('2025-11-28 10:09:02.043555','2025-11-28 10:09:02.055141','2025-11-28 10:09:05.068779',57,57,NULL,'3f91e76373a34e0880a287181873b7a3','gigabytes',0,0,NULL,'3e14384d-bfb8-44c0-8caf-18495421b84d'),('2025-11-28 10:09:02.249079','2025-11-28 10:09:19.686236',NULL,0,58,'0c582186c0ed48b5b46bde7689b3c440','12b605b0706b49d7b50bd67675f75239','shares',0,0,NULL,NULL),('2025-11-28 10:09:02.252074','2025-11-28 10:09:19.686240',NULL,0,59,'0c582186c0ed48b5b46bde7689b3c440','12b605b0706b49d7b50bd67675f75239','gigabytes',0,0,NULL,NULL),('2025-11-28 10:09:02.268055','2025-11-28 10:09:19.686242','2025-11-28 10:09:22.397298',60,60,NULL,'12b605b0706b49d7b50bd67675f75239','shares',0,0,NULL,'6d9a44e6-5425-4bc4-897b-744c603d89a3'),('2025-11-28 10:09:02.271408','2025-11-28 10:09:19.686243','2025-11-28 10:09:22.397298',61,61,NULL,'12b605b0706b49d7b50bd67675f75239','gigabytes',0,0,NULL,'6d9a44e6-5425-4bc4-897b-744c603d89a3'),('2025-11-28 10:09:05.525224','2025-11-28 10:09:16.326272',NULL,0,62,'0c582186c0ed48b5b46bde7689b3c440','12b605b0706b49d7b50bd67675f75239','snapshots',0,0,NULL,NULL),('2025-11-28 10:09:05.527096','2025-11-28 10:09:16.326275',NULL,0,63,'0c582186c0ed48b5b46bde7689b3c440','12b605b0706b49d7b50bd67675f75239','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-28 10:09:05.535999','2025-11-28 10:09:16.326276','2025-11-28 10:09:22.397298',64,64,NULL,'12b605b0706b49d7b50bd67675f75239','snapshots',0,0,NULL,'6d9a44e6-5425-4bc4-897b-744c603d89a3'),('2025-11-28 10:09:05.538199','2025-11-28 10:09:16.326277','2025-11-28 10:09:22.397298',65,65,NULL,'12b605b0706b49d7b50bd67675f75239','snapshot_gigabytes',0,0,NULL,'6d9a44e6-5425-4bc4-897b-744c603d89a3'),('2025-11-28 10:09:12.707229','2025-11-28 10:10:00.736044',NULL,0,66,'04b45146b0ab498fbc11c9fb27eaa424','56c91df0287e4974b45f4ed0b63d771d','shares',0,0,NULL,NULL),('2025-11-28 10:09:12.709257','2025-11-28 10:10:00.736046',NULL,0,67,'04b45146b0ab498fbc11c9fb27eaa424','56c91df0287e4974b45f4ed0b63d771d','gigabytes',0,0,NULL,NULL),('2025-11-28 10:09:12.721387','2025-11-28 10:09:19.266810','2025-11-28 10:10:01.312410',68,68,NULL,'56c91df0287e4974b45f4ed0b63d771d','shares',0,0,NULL,'92b5d720-8b2c-44a0-8b87-437bdeefaf18'),('2025-11-28 10:09:12.725947','2025-11-28 10:09:19.266812','2025-11-28 10:10:01.312410',69,69,NULL,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',0,0,NULL,'92b5d720-8b2c-44a0-8b87-437bdeefaf18'),('2025-11-28 10:09:19.487202','2025-11-28 10:09:22.951753','2025-11-28 10:10:01.223741',70,70,NULL,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',0,0,NULL,'8c13b500-b5e4-40a8-bf38-ed79df3a09e4'),('2025-11-28 10:09:19.489757','2025-11-28 10:09:22.951755','2025-11-28 10:10:01.223741',71,71,NULL,'56c91df0287e4974b45f4ed0b63d771d','shares',0,0,NULL,'8c13b500-b5e4-40a8-bf38-ed79df3a09e4'),('2025-11-28 10:09:23.038090','2025-11-28 10:09:30.394259','2025-11-28 10:10:01.157910',72,72,NULL,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',0,0,NULL,'9a9b0b49-6080-4623-9106-4d195108be5a'),('2025-11-28 10:09:23.040660','2025-11-28 10:09:30.394261','2025-11-28 10:10:01.157910',73,73,NULL,'56c91df0287e4974b45f4ed0b63d771d','shares',0,0,NULL,'9a9b0b49-6080-4623-9106-4d195108be5a'),('2025-11-28 10:09:26.286452','2025-11-28 10:09:29.951721','2025-11-28 10:10:01.107102',74,74,NULL,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',0,0,NULL,'b83d9f61-20cf-4020-8ef9-0f4237cb3bb5'),('2025-11-28 10:09:26.288112','2025-11-28 10:09:29.951722','2025-11-28 10:10:01.107102',75,75,NULL,'56c91df0287e4974b45f4ed0b63d771d','shares',0,0,NULL,'b83d9f61-20cf-4020-8ef9-0f4237cb3bb5'),('2025-11-28 10:09:29.540723','2025-11-28 10:10:13.423859',NULL,0,76,'8ea5668b7da944e3889979a0a4ebd864','9ae469011da74f5abbce684003b3bb7b','gigabytes',0,0,NULL,NULL),('2025-11-28 10:09:29.542809','2025-11-28 10:10:13.423863',NULL,0,77,'8ea5668b7da944e3889979a0a4ebd864','9ae469011da74f5abbce684003b3bb7b','shares',0,0,NULL,NULL),('2025-11-28 10:09:29.554644','2025-11-28 10:09:39.791158','2025-11-28 10:09:42.655073',78,78,NULL,'9ae469011da74f5abbce684003b3bb7b','gigabytes',0,0,NULL,'084f8ef2-4e4e-4a86-9926-577e24d8a08e'),('2025-11-28 10:09:29.556725','2025-11-28 10:09:39.791161','2025-11-28 10:09:42.655073',79,79,NULL,'9ae469011da74f5abbce684003b3bb7b','shares',0,0,NULL,'084f8ef2-4e4e-4a86-9926-577e24d8a08e'),('2025-11-28 10:09:30.494553','2025-11-28 10:09:43.884904','2025-11-28 10:10:01.049676',80,80,NULL,'56c91df0287e4974b45f4ed0b63d771d','shares',0,0,NULL,'a6cf2de5-f03d-4685-96db-213c06469eaa'),('2025-11-28 10:09:30.496206','2025-11-28 10:09:43.884905','2025-11-28 10:10:01.049676',81,81,NULL,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',0,0,NULL,'a6cf2de5-f03d-4685-96db-213c06469eaa'),('2025-11-28 10:09:30.665252','2025-11-28 10:09:48.411363',NULL,0,82,'d695349bee344dfbbced1de2bcceb2ed','2cc8a146763846fabfe8e260b70f3971','shares',0,0,NULL,NULL),('2025-11-28 10:09:30.668912','2025-11-28 10:09:48.411366',NULL,0,83,'d695349bee344dfbbced1de2bcceb2ed','2cc8a146763846fabfe8e260b70f3971','gigabytes',0,0,NULL,NULL),('2025-11-28 10:09:30.677702','2025-11-28 10:09:34.160695','2025-11-28 10:09:49.162284',84,84,NULL,'2cc8a146763846fabfe8e260b70f3971','shares',0,0,NULL,'0ab6e61c-00e8-4c14-a175-ff57dd99da97'),('2025-11-28 10:09:30.679566','2025-11-28 10:09:34.160696','2025-11-28 10:09:49.162284',85,85,NULL,'2cc8a146763846fabfe8e260b70f3971','gigabytes',0,0,NULL,'0ab6e61c-00e8-4c14-a175-ff57dd99da97'),('2025-11-28 10:09:32.953356','2025-11-28 10:10:10.253018',NULL,0,86,'8ea5668b7da944e3889979a0a4ebd864','9ae469011da74f5abbce684003b3bb7b','snapshots',0,0,NULL,NULL),('2025-11-28 10:09:32.955264','2025-11-28 10:10:10.253021',NULL,0,87,'8ea5668b7da944e3889979a0a4ebd864','9ae469011da74f5abbce684003b3bb7b','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-28 10:09:32.971160','2025-11-28 10:09:36.750984','2025-11-28 10:09:42.655073',88,88,NULL,'9ae469011da74f5abbce684003b3bb7b','snapshots',0,0,NULL,'084f8ef2-4e4e-4a86-9926-577e24d8a08e'),('2025-11-28 10:09:32.972980','2025-11-28 10:09:36.750985','2025-11-28 10:09:42.655073',89,89,NULL,'9ae469011da74f5abbce684003b3bb7b','snapshot_gigabytes',0,0,NULL,'084f8ef2-4e4e-4a86-9926-577e24d8a08e'),('2025-11-28 10:09:33.762116','2025-11-28 10:09:43.649393','2025-11-28 10:10:00.978142',90,90,NULL,'56c91df0287e4974b45f4ed0b63d771d','shares',0,0,NULL,'de7477ef-93cf-4399-8f54-c6779de5c085'),('2025-11-28 10:09:33.764310','2025-11-28 10:09:43.649395','2025-11-28 10:10:00.978142',91,91,NULL,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',0,0,NULL,'de7477ef-93cf-4399-8f54-c6779de5c085'),('2025-11-28 10:09:34.285405','2025-11-28 10:09:37.722371','2025-11-28 10:09:49.104032',92,92,NULL,'2cc8a146763846fabfe8e260b70f3971','gigabytes',0,0,NULL,'61dacce4-f310-4d57-871f-5a8e0d73a9d8'),('2025-11-28 10:09:34.288085','2025-11-28 10:09:37.722373','2025-11-28 10:09:49.104032',93,93,NULL,'2cc8a146763846fabfe8e260b70f3971','shares',0,0,NULL,'61dacce4-f310-4d57-871f-5a8e0d73a9d8'),('2025-11-28 10:09:35.204954','2025-11-28 10:09:42.421805',NULL,0,94,'d73cf1135d49436897cbfb435039e1ba','140d992a075d4f1886445e3c1f7f4e58','shares',0,0,NULL,NULL),('2025-11-28 10:09:35.207936','2025-11-28 10:09:42.421811',NULL,0,95,'d73cf1135d49436897cbfb435039e1ba','140d992a075d4f1886445e3c1f7f4e58','gigabytes',0,0,NULL,NULL),('2025-11-28 10:09:35.226200','2025-11-28 10:09:42.421814','2025-11-28 10:09:45.242326',96,96,NULL,'140d992a075d4f1886445e3c1f7f4e58','shares',0,0,NULL,'db8a169e-f049-4a4a-ba40-e83a93f51c46'),('2025-11-28 10:09:35.229713','2025-11-28 10:09:42.421817','2025-11-28 10:09:45.242326',97,97,NULL,'140d992a075d4f1886445e3c1f7f4e58','gigabytes',0,0,NULL,'db8a169e-f049-4a4a-ba40-e83a93f51c46'),('2025-11-28 10:09:37.855567','2025-11-28 10:09:41.280746','2025-11-28 10:09:48.991799',98,98,NULL,'2cc8a146763846fabfe8e260b70f3971','shares',0,0,NULL,'0b2af550-033f-43f7-8dc6-2cba6a6a0d41'),('2025-11-28 10:09:37.858762','2025-11-28 10:09:41.280747','2025-11-28 10:09:48.991799',99,99,NULL,'2cc8a146763846fabfe8e260b70f3971','gigabytes',0,0,NULL,'0b2af550-033f-43f7-8dc6-2cba6a6a0d41'),('2025-11-28 10:09:38.673650','2025-11-28 10:09:43.511533',NULL,0,100,'c6c04037ddce4b068df4a5875ae176f6','410e335578834258b6cf71ca3ea642ab','shares',0,0,NULL,NULL),('2025-11-28 10:09:38.675335','2025-11-28 10:09:43.511536',NULL,0,101,'c6c04037ddce4b068df4a5875ae176f6','410e335578834258b6cf71ca3ea642ab','gigabytes',0,0,NULL,NULL),('2025-11-28 10:09:38.685226','2025-11-28 10:09:43.511538','2025-11-28 10:09:46.347732',102,102,NULL,'410e335578834258b6cf71ca3ea642ab','shares',0,0,NULL,'1017739b-5ffb-4329-bcab-62c8a3bbd78b'),('2025-11-28 10:09:38.687133','2025-11-28 10:09:43.511539','2025-11-28 10:09:46.347732',103,103,NULL,'410e335578834258b6cf71ca3ea642ab','gigabytes',0,0,NULL,'1017739b-5ffb-4329-bcab-62c8a3bbd78b'),('2025-11-28 10:09:40.081338','2025-11-28 10:09:43.451309','2025-11-28 10:10:00.921503',104,104,NULL,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',0,0,NULL,'192f6d83-e644-4b10-b095-74d844f8f9a3'),('2025-11-28 10:09:40.083193','2025-11-28 10:09:43.451310','2025-11-28 10:10:00.921503',105,105,NULL,'56c91df0287e4974b45f4ed0b63d771d','shares',0,0,NULL,'192f6d83-e644-4b10-b095-74d844f8f9a3'),('2025-11-28 10:09:41.352316','2025-11-28 10:09:44.765312','2025-11-28 10:09:48.907424',106,106,NULL,'2cc8a146763846fabfe8e260b70f3971','gigabytes',0,0,NULL,'0a11ce91-4605-4683-9e66-2e39e2023c84'),('2025-11-28 10:09:41.354850','2025-11-28 10:09:44.765314','2025-11-28 10:09:48.907424',107,107,NULL,'2cc8a146763846fabfe8e260b70f3971','shares',0,0,NULL,'0a11ce91-4605-4683-9e66-2e39e2023c84'),('2025-11-28 10:09:42.754960','2025-11-28 10:09:46.574225','2025-11-28 10:10:16.763680',108,108,NULL,'9ae469011da74f5abbce684003b3bb7b','shares',0,0,NULL,'649540ff-edd6-432a-980c-dffae9dab5ec'),('2025-11-28 10:09:42.758358','2025-11-28 10:09:46.574227','2025-11-28 10:10:16.763680',109,109,NULL,'9ae469011da74f5abbce684003b3bb7b','gigabytes',0,0,NULL,'649540ff-edd6-432a-980c-dffae9dab5ec'),('2025-11-28 10:09:44.012686','2025-11-28 10:09:57.170387','2025-11-28 10:10:00.872356',110,110,NULL,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',0,0,NULL,'88ea85e2-148e-4d8d-8f52-2ace5e4a8e88'),('2025-11-28 10:09:44.017397','2025-11-28 10:09:57.170389','2025-11-28 10:10:00.872356',111,111,NULL,'56c91df0287e4974b45f4ed0b63d771d','shares',0,0,NULL,'88ea85e2-148e-4d8d-8f52-2ace5e4a8e88'),('2025-11-28 10:09:44.915212','2025-11-28 10:09:48.411368','2025-11-28 10:09:48.832163',112,112,NULL,'2cc8a146763846fabfe8e260b70f3971','shares',0,0,NULL,'2824c130-0095-47f3-8876-9ba1a2df6000'),('2025-11-28 10:09:44.917575','2025-11-28 10:09:48.411370','2025-11-28 10:09:48.832163',113,113,NULL,'2cc8a146763846fabfe8e260b70f3971','gigabytes',0,0,NULL,'2824c130-0095-47f3-8876-9ba1a2df6000'),('2025-11-28 10:09:49.669350','2025-11-28 10:10:13.423865','2025-11-28 10:10:16.327853',114,114,NULL,'9ae469011da74f5abbce684003b3bb7b','gigabytes',0,0,NULL,'cb2d0222-2ac0-4831-b40e-6a0e3630b51a'),('2025-11-28 10:09:49.673186','2025-11-28 10:10:13.423867','2025-11-28 10:10:16.327853',115,115,NULL,'9ae469011da74f5abbce684003b3bb7b','shares',0,0,NULL,'cb2d0222-2ac0-4831-b40e-6a0e3630b51a'),('2025-11-28 10:09:50.533138','2025-11-28 10:09:56.968819','2025-11-28 10:10:00.826172',116,116,NULL,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',0,0,NULL,'a32f9924-0842-4f19-b22d-40d1a6f0a208'),('2025-11-28 10:09:50.535915','2025-11-28 10:09:56.968820','2025-11-28 10:10:00.826172',117,117,NULL,'56c91df0287e4974b45f4ed0b63d771d','shares',0,0,NULL,'a32f9924-0842-4f19-b22d-40d1a6f0a208'),('2025-11-28 10:09:51.625325','2025-11-28 10:10:01.932770','2025-11-28 10:10:05.045738',118,118,'d405e1ced93a4b7f9732c9daccfc5d43','3e75d8532ea44ff88f2e686f89303ba0','shares',0,0,NULL,NULL),('2025-11-28 10:09:51.627264','2025-11-28 10:10:01.932773','2025-11-28 10:10:05.045738',119,119,'d405e1ced93a4b7f9732c9daccfc5d43','3e75d8532ea44ff88f2e686f89303ba0','gigabytes',0,0,NULL,NULL),('2025-11-28 10:09:51.636821','2025-11-28 10:10:00.680146','2025-11-28 10:10:05.071922',120,120,NULL,'3e75d8532ea44ff88f2e686f89303ba0','shares',0,0,NULL,'01098295-4230-40a5-a351-8cabb1732714'),('2025-11-28 10:09:51.638824','2025-11-28 10:10:00.680147','2025-11-28 10:10:05.071922',121,121,NULL,'3e75d8532ea44ff88f2e686f89303ba0','gigabytes',0,0,NULL,'01098295-4230-40a5-a351-8cabb1732714'),('2025-11-28 10:09:53.622559','2025-11-28 10:10:10.253022','2025-11-28 10:10:16.327853',122,122,NULL,'9ae469011da74f5abbce684003b3bb7b','snapshots',0,0,NULL,'cb2d0222-2ac0-4831-b40e-6a0e3630b51a'),('2025-11-28 10:09:53.626058','2025-11-28 10:10:10.253023','2025-11-28 10:10:16.327853',123,123,NULL,'9ae469011da74f5abbce684003b3bb7b','snapshot_gigabytes',0,0,NULL,'cb2d0222-2ac0-4831-b40e-6a0e3630b51a'),('2025-11-28 10:09:54.973496','2025-11-28 10:10:01.932774','2025-11-28 10:10:05.071922',124,124,NULL,'3e75d8532ea44ff88f2e686f89303ba0','shares',0,0,NULL,'5a147245-c70c-4d91-92f3-86f2fe59f721'),('2025-11-28 10:09:54.975338','2025-11-28 10:10:01.932775','2025-11-28 10:10:05.071922',125,125,NULL,'3e75d8532ea44ff88f2e686f89303ba0','gigabytes',0,0,NULL,'5a147245-c70c-4d91-92f3-86f2fe59f721'),('2025-11-28 10:09:57.015886','2025-11-28 10:10:18.615746',NULL,0,126,'d3b6d62e085a4d95bdeb1efff668b621','ed59ec099bfe470982dfd8309e19126f','shares',0,0,NULL,NULL),('2025-11-28 10:09:57.017710','2025-11-28 10:10:18.615749',NULL,0,127,'d3b6d62e085a4d95bdeb1efff668b621','ed59ec099bfe470982dfd8309e19126f','gigabytes',0,0,NULL,NULL),('2025-11-28 10:09:57.026964','2025-11-28 10:10:18.615750','2025-11-28 10:10:20.925590',128,128,NULL,'ed59ec099bfe470982dfd8309e19126f','shares',0,0,NULL,'84b20621-c945-4853-94b1-f0c82a2eb815'),('2025-11-28 10:09:57.029070','2025-11-28 10:10:18.615751','2025-11-28 10:10:20.925590',129,129,NULL,'ed59ec099bfe470982dfd8309e19126f','gigabytes',0,0,NULL,'84b20621-c945-4853-94b1-f0c82a2eb815'),('2025-11-28 10:09:57.300599','2025-11-28 10:10:00.736047','2025-11-28 10:10:00.768168',130,130,NULL,'56c91df0287e4974b45f4ed0b63d771d','shares',0,0,NULL,'d9f2031f-c743-45fb-9bd3-8793a2be69c1'),('2025-11-28 10:09:57.302568','2025-11-28 10:10:00.736049','2025-11-28 10:10:00.768168',131,131,NULL,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',0,0,NULL,'d9f2031f-c743-45fb-9bd3-8793a2be69c1'),('2025-11-28 10:09:58.751357','2025-11-28 10:10:05.774833',NULL,0,132,'bb79385c64e04edebbffe34d05ef597c','7ccd2022daf64a6998725722e4ad2ecf','shares',0,0,NULL,NULL),('2025-11-28 10:09:58.753111','2025-11-28 10:10:05.774836',NULL,0,133,'bb79385c64e04edebbffe34d05ef597c','7ccd2022daf64a6998725722e4ad2ecf','gigabytes',0,0,NULL,NULL),('2025-11-28 10:09:58.761131','2025-11-28 10:10:05.774838','2025-11-28 10:10:07.262900',134,134,NULL,'7ccd2022daf64a6998725722e4ad2ecf','shares',0,0,NULL,'610122e4-5b17-49ab-8a14-82498fa4e576'),('2025-11-28 10:09:58.762977','2025-11-28 10:10:05.774839','2025-11-28 10:10:07.262900',135,135,NULL,'7ccd2022daf64a6998725722e4ad2ecf','gigabytes',0,0,NULL,'610122e4-5b17-49ab-8a14-82498fa4e576'),('2025-11-28 10:10:03.495598','2025-11-28 10:10:51.825041',NULL,0,136,'b81484063c294e2b9fbd79c48d3a78e1','8e3baf6078d441fead64f612139a9c5e','shares',0,0,NULL,NULL),('2025-11-28 10:10:03.497355','2025-11-28 10:10:51.825044',NULL,0,137,'b81484063c294e2b9fbd79c48d3a78e1','8e3baf6078d441fead64f612139a9c5e','gigabytes',0,0,NULL,NULL),('2025-11-28 10:10:03.507154','2025-11-28 10:10:51.825046','2025-11-28 10:10:54.535430',138,138,NULL,'8e3baf6078d441fead64f612139a9c5e','shares',0,0,NULL,'12de8a30-5c34-4d8e-ac9a-152a96e413e3'),('2025-11-28 10:10:03.509398','2025-11-28 10:10:51.825048','2025-11-28 10:10:54.535430',139,139,NULL,'8e3baf6078d441fead64f612139a9c5e','gigabytes',0,0,NULL,'12de8a30-5c34-4d8e-ac9a-152a96e413e3'),('2025-11-28 10:10:09.620505','2025-11-28 10:10:14.433413',NULL,0,140,'7365471ed46d40d6bedf922c53fd4393','20fec43a3a4446938f9dcafec6c9893a','shares',0,0,NULL,NULL),('2025-11-28 10:10:09.624000','2025-11-28 10:10:14.433416',NULL,0,141,'7365471ed46d40d6bedf922c53fd4393','20fec43a3a4446938f9dcafec6c9893a','gigabytes',0,0,NULL,NULL),('2025-11-28 10:10:09.641099','2025-11-28 10:10:14.433417','2025-11-28 10:10:16.911776',142,142,NULL,'20fec43a3a4446938f9dcafec6c9893a','shares',0,0,NULL,'921ff349-dfdc-472f-a671-644f6fd49864'),('2025-11-28 10:10:09.644741','2025-11-28 10:10:14.433419','2025-11-28 10:10:16.911776',143,143,NULL,'20fec43a3a4446938f9dcafec6c9893a','gigabytes',0,0,NULL,'921ff349-dfdc-472f-a671-644f6fd49864'),('2025-11-28 10:10:13.851554','2025-11-28 10:10:24.567751',NULL,0,144,'fe5a177f7488487e910ff3a84521bd9b','4395abd486d947d5ba2cd486b8c2f257','gigabytes',0,0,NULL,NULL),('2025-11-28 10:10:13.853302','2025-11-28 10:10:24.567753',NULL,0,145,'fe5a177f7488487e910ff3a84521bd9b','4395abd486d947d5ba2cd486b8c2f257','shares',0,0,NULL,NULL),('2025-11-28 10:10:13.861143','2025-11-28 10:10:24.567755','2025-11-28 10:10:27.298121',146,146,NULL,'4395abd486d947d5ba2cd486b8c2f257','gigabytes',0,0,NULL,'10bc0b19-2cf0-4cb4-a06e-cd95828efafc'),('2025-11-28 10:10:13.863610','2025-11-28 10:10:24.567756','2025-11-28 10:10:27.298121',147,147,NULL,'4395abd486d947d5ba2cd486b8c2f257','shares',0,0,NULL,'10bc0b19-2cf0-4cb4-a06e-cd95828efafc'),('2025-11-28 10:10:17.079025','2025-11-28 10:10:21.463185',NULL,0,148,'fe5a177f7488487e910ff3a84521bd9b','4395abd486d947d5ba2cd486b8c2f257','snapshots',0,0,NULL,NULL),('2025-11-28 10:10:17.081841','2025-11-28 10:10:21.463189',NULL,0,149,'fe5a177f7488487e910ff3a84521bd9b','4395abd486d947d5ba2cd486b8c2f257','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-28 10:10:17.091434','2025-11-28 10:10:21.463191','2025-11-28 10:10:27.298121',150,150,NULL,'4395abd486d947d5ba2cd486b8c2f257','snapshots',0,0,NULL,'10bc0b19-2cf0-4cb4-a06e-cd95828efafc'),('2025-11-28 10:10:17.094194','2025-11-28 10:10:21.463193','2025-11-28 10:10:27.298121',151,151,NULL,'4395abd486d947d5ba2cd486b8c2f257','snapshot_gigabytes',0,0,NULL,'10bc0b19-2cf0-4cb4-a06e-cd95828efafc'),('2025-11-28 10:10:24.999258','2025-11-28 10:13:43.410157',NULL,0,152,'cbf66f4180d843eeafcfa90b799ce933','38de2f991c8946e4ad86ddc6b9c2ae73','shares',0,0,NULL,NULL),('2025-11-28 10:10:25.002771','2025-11-28 10:13:43.410160',NULL,0,153,'cbf66f4180d843eeafcfa90b799ce933','38de2f991c8946e4ad86ddc6b9c2ae73','gigabytes',0,0,NULL,NULL),('2025-11-28 10:10:25.019790','2025-11-28 10:13:43.410161','2025-11-28 10:13:46.273587',154,154,NULL,'38de2f991c8946e4ad86ddc6b9c2ae73','shares',0,0,NULL,'ee2272a1-6734-4413-816b-800e8e100609'),('2025-11-28 10:10:25.023891','2025-11-28 10:13:43.410162','2025-11-28 10:13:46.273587',155,155,NULL,'38de2f991c8946e4ad86ddc6b9c2ae73','gigabytes',0,0,NULL,'ee2272a1-6734-4413-816b-800e8e100609'),('2025-11-28 10:10:25.048014','2025-11-28 10:11:44.374090',NULL,0,156,'47cdb2911922414c87c44fadac1c1fbb','a1ab6d5dbd57453f92ddf8599a8c5cff','shares',0,0,NULL,NULL),('2025-11-28 10:10:25.050680','2025-11-28 10:11:44.374093',NULL,0,157,'47cdb2911922414c87c44fadac1c1fbb','a1ab6d5dbd57453f92ddf8599a8c5cff','gigabytes',0,0,NULL,NULL),('2025-11-28 10:10:25.071363','2025-11-28 10:11:44.374094','2025-11-28 10:11:47.211176',158,158,NULL,'a1ab6d5dbd57453f92ddf8599a8c5cff','shares',0,0,NULL,'a4689c66-7480-4db7-9279-095cdd632232'),('2025-11-28 10:10:25.074274','2025-11-28 10:11:44.374095','2025-11-28 10:11:47.211176',159,159,NULL,'a1ab6d5dbd57453f92ddf8599a8c5cff','gigabytes',0,0,NULL,'a4689c66-7480-4db7-9279-095cdd632232'),('2025-11-28 10:10:28.226381','2025-11-28 10:10:42.184546',NULL,0,160,'0cef63841aaf44849d79d226587c527c','a65552de119e4309a43e9e85b3f7e533','gigabytes',0,0,NULL,NULL),('2025-11-28 10:10:28.228559','2025-11-28 10:10:42.184548',NULL,0,161,'0cef63841aaf44849d79d226587c527c','a65552de119e4309a43e9e85b3f7e533','shares',0,0,NULL,NULL),('2025-11-28 10:10:28.240021','2025-11-28 10:10:42.184550','2025-11-28 10:10:44.643391',162,162,NULL,'a65552de119e4309a43e9e85b3f7e533','gigabytes',0,0,NULL,'26a485c3-64f3-4dbe-ac98-4f322b0c870c'),('2025-11-28 10:10:28.242492','2025-11-28 10:10:42.184551','2025-11-28 10:10:44.643391',163,163,NULL,'a65552de119e4309a43e9e85b3f7e533','shares',0,0,NULL,'26a485c3-64f3-4dbe-ac98-4f322b0c870c'),('2025-11-28 10:10:28.501394','2025-11-28 10:11:41.134227',NULL,0,164,'47cdb2911922414c87c44fadac1c1fbb','a1ab6d5dbd57453f92ddf8599a8c5cff','snapshots',0,0,NULL,NULL),('2025-11-28 10:10:28.505309','2025-11-28 10:11:41.134231',NULL,0,165,'47cdb2911922414c87c44fadac1c1fbb','a1ab6d5dbd57453f92ddf8599a8c5cff','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-28 10:10:28.514434','2025-11-28 10:11:41.134233','2025-11-28 10:11:47.211176',166,166,NULL,'a1ab6d5dbd57453f92ddf8599a8c5cff','snapshots',0,0,NULL,'a4689c66-7480-4db7-9279-095cdd632232'),('2025-11-28 10:10:28.517447','2025-11-28 10:11:41.134235','2025-11-28 10:11:47.211176',167,167,NULL,'a1ab6d5dbd57453f92ddf8599a8c5cff','snapshot_gigabytes',0,0,NULL,'a4689c66-7480-4db7-9279-095cdd632232'),('2025-11-28 10:10:30.025857','2025-11-28 10:10:41.063771',NULL,0,168,'677aab2179fe42298307c846ff69184a','e0c40d8bf169430ba137dca405115c59','gigabytes',0,0,NULL,NULL),('2025-11-28 10:10:30.028141','2025-11-28 10:10:41.063774',NULL,0,169,'677aab2179fe42298307c846ff69184a','e0c40d8bf169430ba137dca405115c59','shares',0,0,NULL,NULL),('2025-11-28 10:10:30.042821','2025-11-28 10:10:41.063776','2025-11-28 10:10:43.161549',170,170,NULL,'e0c40d8bf169430ba137dca405115c59','gigabytes',0,0,NULL,'bab89685-cea5-4f03-919d-475c107118d0'),('2025-11-28 10:10:30.046746','2025-11-28 10:10:41.063778','2025-11-28 10:10:43.161549',171,171,NULL,'e0c40d8bf169430ba137dca405115c59','shares',0,0,NULL,'bab89685-cea5-4f03-919d-475c107118d0'),('2025-11-28 10:10:37.319120','2025-11-28 10:10:51.207813',NULL,0,172,'3602eb59752942f68890c3d4bb1ab475','7683e4ed98894de19dc2538cc36bcd6c','gigabytes',0,0,NULL,NULL),('2025-11-28 10:10:37.321682','2025-11-28 10:10:51.207816',NULL,0,173,'3602eb59752942f68890c3d4bb1ab475','7683e4ed98894de19dc2538cc36bcd6c','shares',0,0,NULL,NULL),('2025-11-28 10:10:37.332297','2025-11-28 10:10:51.207817','2025-11-28 10:11:00.986568',174,174,NULL,'7683e4ed98894de19dc2538cc36bcd6c','gigabytes',0,0,NULL,'3ad5f084-f3cc-4797-ab97-02662574deca'),('2025-11-28 10:10:37.334055','2025-11-28 10:10:51.207818','2025-11-28 10:11:00.986568',175,175,NULL,'7683e4ed98894de19dc2538cc36bcd6c','shares',0,0,NULL,'3ad5f084-f3cc-4797-ab97-02662574deca'),('2025-11-28 10:10:43.707796','2025-11-28 10:10:58.111019',NULL,0,176,'fa0d986262574d1aa5bfcc3cd2fa05e7','1a203a668ad442b7a0e1a122f4122c81','shares',0,0,NULL,NULL),('2025-11-28 10:10:43.852550','2025-11-28 10:10:58.111023',NULL,0,177,'fa0d986262574d1aa5bfcc3cd2fa05e7','1a203a668ad442b7a0e1a122f4122c81','gigabytes',0,0,NULL,NULL),('2025-11-28 10:10:43.888810','2025-11-28 10:10:58.111024','2025-11-28 10:11:00.986568',178,178,NULL,'1a203a668ad442b7a0e1a122f4122c81','shares',0,0,NULL,'3ad5f084-f3cc-4797-ab97-02662574deca'),('2025-11-28 10:10:43.891107','2025-11-28 10:10:58.111026','2025-11-28 10:11:00.986568',179,179,NULL,'1a203a668ad442b7a0e1a122f4122c81','gigabytes',0,0,NULL,'3ad5f084-f3cc-4797-ab97-02662574deca'),('2025-11-28 10:10:44.480615','2025-11-28 10:11:30.075884',NULL,0,180,'0e4a868caf7745428b930f5df0b3e2fe','ab97bc5516b54755ac262ba68a804978','shares',0,0,NULL,NULL),('2025-11-28 10:10:44.482575','2025-11-28 10:11:30.075914',NULL,0,181,'0e4a868caf7745428b930f5df0b3e2fe','ab97bc5516b54755ac262ba68a804978','gigabytes',0,0,NULL,NULL),('2025-11-28 10:10:44.644366','2025-11-28 10:11:30.075917','2025-11-28 10:11:32.801086',182,182,NULL,'ab97bc5516b54755ac262ba68a804978','shares',0,0,NULL,'6cd102ad-9540-4dde-8628-56d0d62564e3'),('2025-11-28 10:10:44.651028','2025-11-28 10:11:30.075919','2025-11-28 10:11:32.801086',183,183,NULL,'ab97bc5516b54755ac262ba68a804978','gigabytes',0,0,NULL,'6cd102ad-9540-4dde-8628-56d0d62564e3'),('2025-11-28 10:10:47.962335','2025-11-28 10:11:26.811533',NULL,0,184,'0e4a868caf7745428b930f5df0b3e2fe','ab97bc5516b54755ac262ba68a804978','snapshots',0,0,NULL,NULL),('2025-11-28 10:10:47.964589','2025-11-28 10:11:26.811536',NULL,0,185,'0e4a868caf7745428b930f5df0b3e2fe','ab97bc5516b54755ac262ba68a804978','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-28 10:10:47.977483','2025-11-28 10:11:26.811538','2025-11-28 10:11:32.801086',186,186,NULL,'ab97bc5516b54755ac262ba68a804978','snapshots',0,0,NULL,'6cd102ad-9540-4dde-8628-56d0d62564e3'),('2025-11-28 10:10:47.979899','2025-11-28 10:11:26.811540','2025-11-28 10:11:32.801086',187,187,NULL,'ab97bc5516b54755ac262ba68a804978','snapshot_gigabytes',0,0,NULL,'6cd102ad-9540-4dde-8628-56d0d62564e3'),('2025-11-28 10:10:50.700865','2025-11-28 10:11:01.853035',NULL,0,188,'1deacee2ac724bf2ad53fa5464f5376c','39ffeead9f734f13b1a489e1ce8313ab','shares',0,0,NULL,NULL),('2025-11-28 10:10:50.702715','2025-11-28 10:11:01.853038',NULL,0,189,'1deacee2ac724bf2ad53fa5464f5376c','39ffeead9f734f13b1a489e1ce8313ab','gigabytes',0,0,NULL,NULL),('2025-11-28 10:10:50.715054','2025-11-28 10:11:01.853039','2025-11-28 10:11:04.483392',190,190,NULL,'39ffeead9f734f13b1a489e1ce8313ab','shares',0,0,NULL,'eeb58100-1c78-4a03-b14f-9f29610af10b'),('2025-11-28 10:10:50.717242','2025-11-28 10:11:01.853041','2025-11-28 10:11:04.483392',191,191,NULL,'39ffeead9f734f13b1a489e1ce8313ab','gigabytes',0,0,NULL,'eeb58100-1c78-4a03-b14f-9f29610af10b'),('2025-11-28 10:10:53.948959','2025-11-28 10:10:58.789812',NULL,0,192,'1deacee2ac724bf2ad53fa5464f5376c','39ffeead9f734f13b1a489e1ce8313ab','snapshots',0,0,NULL,NULL),('2025-11-28 10:10:53.951157','2025-11-28 10:10:58.789817',NULL,0,193,'1deacee2ac724bf2ad53fa5464f5376c','39ffeead9f734f13b1a489e1ce8313ab','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-28 10:10:53.988443','2025-11-28 10:11:57.108276',NULL,0,194,'b44ef903be4543c38c7ff39887ede90c','1562d9ae673b4a5ea5a1a571bd0ea2c8','gigabytes',0,0,NULL,NULL),('2025-11-28 10:10:53.990549','2025-11-28 10:11:57.108278',NULL,0,195,'b44ef903be4543c38c7ff39887ede90c','1562d9ae673b4a5ea5a1a571bd0ea2c8','shares',0,0,NULL,NULL),('2025-11-28 10:10:54.090868','2025-11-28 10:11:57.108279','2025-11-28 10:11:59.532600',196,196,NULL,'1562d9ae673b4a5ea5a1a571bd0ea2c8','gigabytes',0,0,NULL,'5ddfe74e-bc86-429d-b4a5-b582d6d4201d'),('2025-11-28 10:10:54.092101','2025-11-28 10:10:58.789820','2025-11-28 10:11:04.483392',197,197,NULL,'39ffeead9f734f13b1a489e1ce8313ab','snapshots',0,0,NULL,'eeb58100-1c78-4a03-b14f-9f29610af10b'),('2025-11-28 10:10:54.093061','2025-11-28 10:11:57.108280','2025-11-28 10:11:59.532600',198,198,NULL,'1562d9ae673b4a5ea5a1a571bd0ea2c8','shares',0,0,NULL,'5ddfe74e-bc86-429d-b4a5-b582d6d4201d'),('2025-11-28 10:10:54.094724','2025-11-28 10:10:58.789821','2025-11-28 10:11:04.483392',199,199,NULL,'39ffeead9f734f13b1a489e1ce8313ab','snapshot_gigabytes',0,0,NULL,'eeb58100-1c78-4a03-b14f-9f29610af10b'),('2025-11-28 10:11:12.060002','2025-11-28 10:11:12.223063',NULL,0,200,'6212ed28bd2b4d8798c54ea530b32b6f','00c2fa4a34ea4bfba4d0fde13e213f92','share_networks',1,0,NULL,NULL),('2025-11-28 10:11:22.732046','2025-11-28 10:11:35.375703',NULL,0,201,'ffce0a872a0f4a8fa868de2152ea3e8f','aaf1f8cead8f4f8b8cda2e0813ee1aef','gigabytes',1,0,NULL,NULL),('2025-11-28 10:11:22.734007','2025-11-28 10:11:35.375706',NULL,0,202,'ffce0a872a0f4a8fa868de2152ea3e8f','aaf1f8cead8f4f8b8cda2e0813ee1aef','shares',1,0,NULL,NULL),('2025-11-28 10:11:22.743561','2025-11-28 10:11:35.375707','2025-11-28 10:11:38.983433',203,203,NULL,'aaf1f8cead8f4f8b8cda2e0813ee1aef','gigabytes',1,0,NULL,'6227a0a2-3eff-4efb-b06b-cb10d330a936'),('2025-11-28 10:11:22.748589','2025-11-28 10:11:35.375708','2025-11-28 10:11:38.983433',204,204,NULL,'aaf1f8cead8f4f8b8cda2e0813ee1aef','shares',1,0,NULL,'6227a0a2-3eff-4efb-b06b-cb10d330a936'),('2025-11-28 10:11:24.519002','2025-11-28 10:11:25.939655',NULL,0,205,'2c18bdb9472f4e51b2790ea95ef17eb3','2e6e3251bacd42d6b03534a552ecb206','share_networks',0,0,NULL,NULL),('2025-11-28 10:11:26.231902','2025-11-28 10:11:27.543772',NULL,0,206,'d2e0cda103814a879e952c4cb24a9ba8','7dc33b8a173348f5a1fc870414f6918d','shares',0,0,NULL,NULL),('2025-11-28 10:11:26.233867','2025-11-28 10:11:27.543777',NULL,0,207,'d2e0cda103814a879e952c4cb24a9ba8','7dc33b8a173348f5a1fc870414f6918d','gigabytes',0,0,NULL,NULL),('2025-11-28 10:11:26.302614','2025-11-28 10:11:26.716661',NULL,0,208,'d2e0cda103814a879e952c4cb24a9ba8','aaf1f8cead8f4f8b8cda2e0813ee1aef','shares',-1,0,NULL,NULL),('2025-11-28 10:11:26.306948','2025-11-28 10:11:26.716664',NULL,0,209,'d2e0cda103814a879e952c4cb24a9ba8','aaf1f8cead8f4f8b8cda2e0813ee1aef','gigabytes',-1,0,NULL,NULL),('2025-11-28 10:11:27.470446','2025-11-28 10:11:27.543780','2025-11-28 10:11:38.983433',210,210,NULL,'7dc33b8a173348f5a1fc870414f6918d','shares',0,0,NULL,'6227a0a2-3eff-4efb-b06b-cb10d330a936'),('2025-11-28 10:11:27.478410','2025-11-28 10:11:27.543782','2025-11-28 10:11:38.983433',211,211,NULL,'7dc33b8a173348f5a1fc870414f6918d','gigabytes',0,0,NULL,'6227a0a2-3eff-4efb-b06b-cb10d330a936'),('2025-11-28 10:11:45.687637','2025-11-28 10:12:36.575452',NULL,0,212,'ad9cb85fd5c6468d897815c25b9a150f','7e3af8a3bac3495d93a9072a440e6c65','shares',0,0,NULL,NULL),('2025-11-28 10:11:45.689650','2025-11-28 10:12:36.575455',NULL,0,213,'ad9cb85fd5c6468d897815c25b9a150f','7e3af8a3bac3495d93a9072a440e6c65','gigabytes',0,0,NULL,NULL),('2025-11-28 10:11:45.699088','2025-11-28 10:12:36.575456','2025-11-28 10:12:39.403627',214,214,NULL,'7e3af8a3bac3495d93a9072a440e6c65','shares',0,0,NULL,'3d7253d3-6d03-4922-a324-c083e417d3ba'),('2025-11-28 10:11:45.701037','2025-11-28 10:12:36.575457','2025-11-28 10:12:39.403627',215,215,NULL,'7e3af8a3bac3495d93a9072a440e6c65','gigabytes',0,0,NULL,'3d7253d3-6d03-4922-a324-c083e417d3ba'),('2025-11-28 10:11:47.195896','2025-11-28 10:12:11.738578',NULL,0,216,'c96639555ce44e9d9b8fafdf95d9aef8','1353b256ba2c444f92d94a37fc2b399e','shares',0,0,NULL,NULL),('2025-11-28 10:11:47.197795','2025-11-28 10:12:11.738581',NULL,0,217,'c96639555ce44e9d9b8fafdf95d9aef8','1353b256ba2c444f92d94a37fc2b399e','gigabytes',0,0,NULL,NULL),('2025-11-28 10:11:47.206573','2025-11-28 10:12:11.738582','2025-11-28 10:12:14.561112',218,218,NULL,'1353b256ba2c444f92d94a37fc2b399e','shares',0,0,NULL,'e9e11a72-0904-4ff8-85de-04a9d769d418'),('2025-11-28 10:11:47.208656','2025-11-28 10:12:11.738583','2025-11-28 10:12:14.561112',219,219,NULL,'1353b256ba2c444f92d94a37fc2b399e','gigabytes',0,0,NULL,'e9e11a72-0904-4ff8-85de-04a9d769d418'),('2025-11-28 10:11:48.907153','2025-11-28 10:12:33.517029',NULL,0,220,'ad9cb85fd5c6468d897815c25b9a150f','7e3af8a3bac3495d93a9072a440e6c65','snapshots',0,0,NULL,NULL),('2025-11-28 10:11:48.909409','2025-11-28 10:12:33.517033',NULL,0,221,'ad9cb85fd5c6468d897815c25b9a150f','7e3af8a3bac3495d93a9072a440e6c65','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-28 10:11:48.920844','2025-11-28 10:12:33.517035','2025-11-28 10:12:39.403627',222,222,NULL,'7e3af8a3bac3495d93a9072a440e6c65','snapshots',0,0,NULL,'3d7253d3-6d03-4922-a324-c083e417d3ba'),('2025-11-28 10:11:48.922745','2025-11-28 10:12:33.517036','2025-11-28 10:12:39.403627',223,223,NULL,'7e3af8a3bac3495d93a9072a440e6c65','snapshot_gigabytes',0,0,NULL,'3d7253d3-6d03-4922-a324-c083e417d3ba'),('2025-11-28 10:11:50.504570','2025-11-28 10:12:08.290729',NULL,0,224,'c96639555ce44e9d9b8fafdf95d9aef8','1353b256ba2c444f92d94a37fc2b399e','snapshots',0,0,NULL,NULL),('2025-11-28 10:11:50.507183','2025-11-28 10:12:08.290732',NULL,0,225,'c96639555ce44e9d9b8fafdf95d9aef8','1353b256ba2c444f92d94a37fc2b399e','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-28 10:11:50.516633','2025-11-28 10:12:08.290733','2025-11-28 10:12:14.561112',226,226,NULL,'1353b256ba2c444f92d94a37fc2b399e','snapshots',0,0,NULL,'e9e11a72-0904-4ff8-85de-04a9d769d418'),('2025-11-28 10:11:50.519655','2025-11-28 10:12:08.290734','2025-11-28 10:12:14.561112',227,227,NULL,'1353b256ba2c444f92d94a37fc2b399e','snapshot_gigabytes',0,0,NULL,'e9e11a72-0904-4ff8-85de-04a9d769d418'),('2025-11-28 10:12:05.938601','2025-11-28 10:12:07.338998',NULL,0,228,'80391e48913f43e0bf5babfb4338f5e1','b183bba5ae624f349d21889e13a69feb','share_networks',0,0,NULL,NULL),('2025-11-28 10:12:14.402315','2025-11-28 10:12:17.284622',NULL,0,229,'267556ee7e92440b82bfee4afa050c0e','b5e7474ddfa74462ace1d5deca683f14','share_networks',0,0,NULL,NULL),('2025-11-28 10:12:27.435593','2025-11-28 10:13:01.582437',NULL,0,230,'372e238309d04dea8256f42b7a2dba29','7849a0d812124969961ed960ba5526ec','shares',0,0,NULL,NULL),('2025-11-28 10:12:27.437369','2025-11-28 10:13:01.582441',NULL,0,231,'372e238309d04dea8256f42b7a2dba29','7849a0d812124969961ed960ba5526ec','gigabytes',0,0,NULL,NULL),('2025-11-28 10:12:27.446807','2025-11-28 10:13:01.582443','2025-11-28 10:13:05.693589',232,232,NULL,'7849a0d812124969961ed960ba5526ec','shares',0,0,NULL,'1622227d-a551-4d4c-a9ec-de9c0bcdd51d'),('2025-11-28 10:12:27.448544','2025-11-28 10:13:01.582445','2025-11-28 10:13:05.693589',233,233,NULL,'7849a0d812124969961ed960ba5526ec','gigabytes',0,0,NULL,'1622227d-a551-4d4c-a9ec-de9c0bcdd51d'),('2025-11-28 10:12:40.943251','2025-11-28 10:12:50.642568',NULL,0,234,'372e238309d04dea8256f42b7a2dba29','7849a0d812124969961ed960ba5526ec','share_groups',0,0,NULL,NULL),('2025-11-28 10:13:24.767685','2025-11-28 10:13:40.596182',NULL,0,235,'f76d7d6f14984f9b81a1d6af12c7b908','38de2f991c8946e4ad86ddc6b9c2ae73','shares',0,0,NULL,NULL),('2025-11-28 10:13:24.770308','2025-11-28 10:13:40.596184',NULL,0,236,'f76d7d6f14984f9b81a1d6af12c7b908','38de2f991c8946e4ad86ddc6b9c2ae73','gigabytes',0,0,NULL,NULL),('2025-11-28 10:13:55.199514','2025-11-28 10:14:56.878403',NULL,0,237,'6cc1c18a7e244cc796e077a2b595df2a','301971e834c14ea7aa009696c3f04782','shares',0,0,NULL,NULL),('2025-11-28 10:13:55.201882','2025-11-28 10:14:56.878406',NULL,0,238,'6cc1c18a7e244cc796e077a2b595df2a','301971e834c14ea7aa009696c3f04782','gigabytes',0,0,NULL,NULL),('2025-11-28 10:13:55.292006','2025-11-28 10:14:56.878407','2025-11-28 10:14:59.500113',239,239,NULL,'301971e834c14ea7aa009696c3f04782','shares',0,0,NULL,'4dc5d4a9-4532-4c9d-bc2d-71be15c0343e'),('2025-11-28 10:13:55.294444','2025-11-28 10:14:56.878408','2025-11-28 10:14:59.500113',240,240,NULL,'301971e834c14ea7aa009696c3f04782','gigabytes',0,0,NULL,'4dc5d4a9-4532-4c9d-bc2d-71be15c0343e'),('2025-11-28 10:13:58.602281','2025-11-28 10:14:53.389802',NULL,0,241,NULL,'301971e834c14ea7aa009696c3f04782','shares',0,0,NULL,'2b13b4f2-f001-426c-8761-f32013aa3647'),('2025-11-28 10:13:58.604360','2025-11-28 10:14:53.389803',NULL,0,242,NULL,'301971e834c14ea7aa009696c3f04782','gigabytes',0,0,NULL,'2b13b4f2-f001-426c-8761-f32013aa3647'),('2025-11-28 10:14:06.209877','2025-11-28 10:14:50.179973',NULL,0,243,'a4a20dfb6d8746bf9d4dfae82189957b','b90c445933704341b38d135548fb5388','shares',0,0,NULL,NULL),('2025-11-28 10:14:06.211828','2025-11-28 10:14:50.179976',NULL,0,244,'a4a20dfb6d8746bf9d4dfae82189957b','b90c445933704341b38d135548fb5388','gigabytes',0,0,NULL,NULL),('2025-11-28 10:14:06.899914','2025-11-28 10:14:50.179977',NULL,0,245,NULL,'b90c445933704341b38d135548fb5388','shares',0,0,NULL,'2b13b4f2-f001-426c-8761-f32013aa3647'),('2025-11-28 10:14:06.905270','2025-11-28 10:14:50.179978',NULL,0,246,NULL,'b90c445933704341b38d135548fb5388','gigabytes',0,0,NULL,'2b13b4f2-f001-426c-8761-f32013aa3647'),('2025-11-28 10:14:33.215047','2025-11-28 10:14:46.987528','2025-11-28 10:14:59.500113',247,247,NULL,'b90c445933704341b38d135548fb5388','gigabytes',0,0,NULL,'4dc5d4a9-4532-4c9d-bc2d-71be15c0343e'),('2025-11-28 10:14:33.217236','2025-11-28 10:14:46.987530','2025-11-28 10:14:59.500113',248,248,NULL,'b90c445933704341b38d135548fb5388','shares',0,0,NULL,'4dc5d4a9-4532-4c9d-bc2d-71be15c0343e'),('2025-11-28 10:15:07.242122','2025-11-28 10:15:09.302417',NULL,0,249,'b79a3a528ea74665849dbf02dfc0f84c','7e596b943e6847d3a99845c08eb62e34','share_networks',0,0,NULL,NULL),('2025-11-28 10:15:17.910097','2025-11-28 10:15:42.639119',NULL,0,250,'1f60574029c1406aa5a4e544b63686a8','4fd4367d7eac444bae1496b393bb25f7','shares',0,0,NULL,NULL),('2025-11-28 10:15:17.912067','2025-11-28 10:15:42.639121',NULL,0,251,'1f60574029c1406aa5a4e544b63686a8','4fd4367d7eac444bae1496b393bb25f7','gigabytes',0,0,NULL,NULL),('2025-11-28 10:15:17.920605','2025-11-28 10:15:42.639122','2025-11-28 10:15:45.583921',252,252,NULL,'4fd4367d7eac444bae1496b393bb25f7','shares',0,0,NULL,'113ca3c9-a85a-4dff-bcc6-56c30882320e'),('2025-11-28 10:15:17.922926','2025-11-28 10:15:42.639124','2025-11-28 10:15:45.583921',253,253,NULL,'4fd4367d7eac444bae1496b393bb25f7','gigabytes',0,0,NULL,'113ca3c9-a85a-4dff-bcc6-56c30882320e'),('2025-11-28 10:15:52.820815','2025-11-28 10:16:03.372714',NULL,0,254,'bc75d35d76b8426ea0b7e931d84ebe92','ae1723357a08440e8ac316b1180170a5','shares',0,0,NULL,NULL),('2025-11-28 10:15:52.822573','2025-11-28 10:16:03.372717',NULL,0,255,'bc75d35d76b8426ea0b7e931d84ebe92','ae1723357a08440e8ac316b1180170a5','gigabytes',0,0,NULL,NULL),('2025-11-28 10:15:52.830144','2025-11-28 10:16:03.372718','2025-11-28 10:16:06.293312',256,256,NULL,'ae1723357a08440e8ac316b1180170a5','shares',0,0,NULL,'3c7ce0e8-a8e1-41a4-95c4-deab167745c4'),('2025-11-28 10:15:52.832182','2025-11-28 10:16:03.372719','2025-11-28 10:16:06.293312',257,257,NULL,'ae1723357a08440e8ac316b1180170a5','gigabytes',0,0,NULL,'3c7ce0e8-a8e1-41a4-95c4-deab167745c4'),('2025-11-28 10:15:56.051102','2025-11-28 10:16:00.240858',NULL,0,258,'bc75d35d76b8426ea0b7e931d84ebe92','ae1723357a08440e8ac316b1180170a5','snapshots',0,0,NULL,NULL),('2025-11-28 10:15:56.054348','2025-11-28 10:16:00.240860',NULL,0,259,'bc75d35d76b8426ea0b7e931d84ebe92','ae1723357a08440e8ac316b1180170a5','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-28 10:15:56.065280','2025-11-28 10:16:00.240862','2025-11-28 10:16:06.293312',260,260,NULL,'ae1723357a08440e8ac316b1180170a5','snapshots',0,0,NULL,'3c7ce0e8-a8e1-41a4-95c4-deab167745c4'),('2025-11-28 10:15:56.068821','2025-11-28 10:16:00.240863','2025-11-28 10:16:06.293312',261,261,NULL,'ae1723357a08440e8ac316b1180170a5','snapshot_gigabytes',0,0,NULL,'3c7ce0e8-a8e1-41a4-95c4-deab167745c4'),('2025-11-28 10:16:13.093651','2025-11-28 10:16:23.931906',NULL,0,262,'a4133f743ebf43048b0d18e3d70b82d2','a7c0c439f55c4179a9932a53b7755072','shares',0,0,NULL,NULL),('2025-11-28 10:16:13.097133','2025-11-28 10:16:23.931909',NULL,0,263,'a4133f743ebf43048b0d18e3d70b82d2','a7c0c439f55c4179a9932a53b7755072','gigabytes',0,0,NULL,NULL),('2025-11-28 10:16:13.113947','2025-11-28 10:16:23.931911','2025-11-28 10:16:26.764782',264,264,NULL,'a7c0c439f55c4179a9932a53b7755072','shares',0,0,NULL,'0981c7e7-55c4-4fb6-ae7d-bd0d6445b95b'),('2025-11-28 10:16:13.116632','2025-11-28 10:16:23.931912','2025-11-28 10:16:26.764782',265,265,NULL,'a7c0c439f55c4179a9932a53b7755072','gigabytes',0,0,NULL,'0981c7e7-55c4-4fb6-ae7d-bd0d6445b95b'),('2025-11-28 10:16:16.391502','2025-11-28 10:16:20.695133',NULL,0,266,'a4133f743ebf43048b0d18e3d70b82d2','a7c0c439f55c4179a9932a53b7755072','snapshots',0,0,NULL,NULL),('2025-11-28 10:16:16.393878','2025-11-28 10:16:20.695136',NULL,0,267,'a4133f743ebf43048b0d18e3d70b82d2','a7c0c439f55c4179a9932a53b7755072','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-28 10:16:16.408918','2025-11-28 10:16:20.695138','2025-11-28 10:16:26.764782',268,268,NULL,'a7c0c439f55c4179a9932a53b7755072','snapshots',0,0,NULL,'0981c7e7-55c4-4fb6-ae7d-bd0d6445b95b'),('2025-11-28 10:16:16.411830','2025-11-28 10:16:20.695140','2025-11-28 10:16:26.764782',269,269,NULL,'a7c0c439f55c4179a9932a53b7755072','snapshot_gigabytes',0,0,NULL,'0981c7e7-55c4-4fb6-ae7d-bd0d6445b95b');
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
INSERT INTO `quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `project_id`, `resource`, `hard_limit`) VALUES (1,'2025-11-28 10:08:45.194742',NULL,'2025-11-28 10:08:45.280607',1,'3f91e76373a34e0880a287181873b7a3','shares',1),(2,'2025-11-28 10:08:48.818774',NULL,'2025-11-28 10:08:52.207107',2,'3f91e76373a34e0880a287181873b7a3','snapshots',1),(3,'2025-11-28 10:08:53.974097',NULL,'2025-11-28 10:08:54.088236',3,'3f91e76373a34e0880a287181873b7a3','shares',10),(4,'2025-11-28 10:08:54.161853',NULL,'2025-11-28 10:08:54.249884',4,'3f91e76373a34e0880a287181873b7a3','shares',10),(5,'2025-11-28 10:09:51.316475',NULL,'2025-11-28 10:10:05.067696',5,'3e75d8532ea44ff88f2e686f89303ba0','shares',3),(6,'2025-11-28 10:09:51.322533',NULL,'2025-11-28 10:10:05.067696',6,'3e75d8532ea44ff88f2e686f89303ba0','gigabytes',10),(7,'2025-11-28 10:10:05.202648',NULL,'2025-11-28 10:10:05.424488',7,'3e75d8532ea44ff88f2e686f89303ba0','shares',55),(8,'2025-11-28 10:10:05.206286',NULL,'2025-11-28 10:10:05.424488',8,'3e75d8532ea44ff88f2e686f89303ba0','snapshots',55),(9,'2025-11-28 10:10:05.209838',NULL,'2025-11-28 10:10:05.424488',9,'3e75d8532ea44ff88f2e686f89303ba0','gigabytes',1005),(10,'2025-11-28 10:10:05.213098',NULL,'2025-11-28 10:10:05.424488',10,'3e75d8532ea44ff88f2e686f89303ba0','snapshot_gigabytes',1005),(11,'2025-11-28 10:10:05.216041',NULL,'2025-11-28 10:10:05.424488',11,'3e75d8532ea44ff88f2e686f89303ba0','share_replicas',105),(12,'2025-11-28 10:10:05.222386',NULL,'2025-11-28 10:10:05.424488',12,'3e75d8532ea44ff88f2e686f89303ba0','replica_gigabytes',1005),(13,'2025-11-28 10:10:05.528296',NULL,'2025-11-28 10:10:05.745248',13,'3e75d8532ea44ff88f2e686f89303ba0','shares',55),(14,'2025-11-28 10:10:05.532439',NULL,'2025-11-28 10:10:05.745248',14,'3e75d8532ea44ff88f2e686f89303ba0','snapshots',55),(15,'2025-11-28 10:10:05.537100',NULL,'2025-11-28 10:10:05.745248',15,'3e75d8532ea44ff88f2e686f89303ba0','gigabytes',1005),(16,'2025-11-28 10:10:05.542223',NULL,'2025-11-28 10:10:05.745248',16,'3e75d8532ea44ff88f2e686f89303ba0','snapshot_gigabytes',1005),(17,'2025-11-28 10:10:05.547802',NULL,'2025-11-28 10:10:05.745248',17,'3e75d8532ea44ff88f2e686f89303ba0','share_replicas',105),(18,'2025-11-28 10:10:05.551650',NULL,'2025-11-28 10:10:05.745248',18,'3e75d8532ea44ff88f2e686f89303ba0','replica_gigabytes',1005),(19,'2025-11-28 10:10:05.832272',NULL,'2025-11-28 10:10:05.915191',19,'3e75d8532ea44ff88f2e686f89303ba0','shares',52),(20,'2025-11-28 10:10:05.840810',NULL,'2025-11-28 10:10:05.915191',20,'3e75d8532ea44ff88f2e686f89303ba0','snapshots',52),(21,'2025-11-28 10:10:05.856048',NULL,'2025-11-28 10:10:05.915191',21,'3e75d8532ea44ff88f2e686f89303ba0','gigabytes',1002),(22,'2025-11-28 10:10:05.863182',NULL,'2025-11-28 10:10:05.915191',22,'3e75d8532ea44ff88f2e686f89303ba0','snapshot_gigabytes',1002),(23,'2025-11-28 10:10:05.870574',NULL,'2025-11-28 10:10:05.915191',23,'3e75d8532ea44ff88f2e686f89303ba0','share_networks',12),(24,'2025-11-28 10:10:05.875784',NULL,'2025-11-28 10:10:05.915191',24,'3e75d8532ea44ff88f2e686f89303ba0','share_replicas',102),(25,'2025-11-28 10:10:05.881365',NULL,'2025-11-28 10:10:05.915191',25,'3e75d8532ea44ff88f2e686f89303ba0','replica_gigabytes',1002),(26,'2025-11-28 10:10:06.021025',NULL,'2025-11-28 10:10:06.178228',26,'3e75d8532ea44ff88f2e686f89303ba0','shares',13),(27,'2025-11-28 10:10:06.213144',NULL,'2025-11-28 10:10:06.246112',27,'3e75d8532ea44ff88f2e686f89303ba0','gigabytes',-1),(28,'2025-11-28 10:10:06.282145',NULL,'2025-11-28 10:10:06.312683',28,'3e75d8532ea44ff88f2e686f89303ba0','share_replicas',-1),(29,'2025-11-28 10:10:06.357528',NULL,'2025-11-28 10:10:06.394702',29,'3e75d8532ea44ff88f2e686f89303ba0','replica_gigabytes',-1),(30,'2025-11-28 10:10:06.443491',NULL,'2025-11-28 10:10:06.491262',30,'3e75d8532ea44ff88f2e686f89303ba0','share_networks',-1),(31,'2025-11-28 10:10:06.526623',NULL,'2025-11-28 10:10:06.563381',31,'3e75d8532ea44ff88f2e686f89303ba0','shares',-1),(32,'2025-11-28 10:10:06.608893',NULL,'2025-11-28 10:10:06.650278',32,'3e75d8532ea44ff88f2e686f89303ba0','snapshot_gigabytes',-1),(33,'2025-11-28 10:10:06.687745',NULL,'2025-11-28 10:10:06.721501',33,'3e75d8532ea44ff88f2e686f89303ba0','snapshots',-1),(34,'2025-11-28 10:10:08.587410',NULL,'2025-11-28 10:10:08.692130',34,'3e75d8532ea44ff88f2e686f89303ba0','shares',10),(35,'2025-11-28 10:10:08.766266',NULL,'2025-11-28 10:10:08.852971',35,'3e75d8532ea44ff88f2e686f89303ba0','shares',10),(36,'2025-11-28 10:10:08.936388',NULL,'2025-11-28 10:10:08.955156',36,'3e75d8532ea44ff88f2e686f89303ba0','gigabytes',1002),(37,'2025-11-28 10:10:09.011723',NULL,'2025-11-28 10:10:09.030730',37,'3e75d8532ea44ff88f2e686f89303ba0','share_networks',12),(38,'2025-11-28 10:10:09.092272',NULL,'2025-11-28 10:10:09.115496',38,'3e75d8532ea44ff88f2e686f89303ba0','shares',52),(39,'2025-11-28 10:10:09.233149',NULL,'2025-11-28 10:10:09.250718',39,'3e75d8532ea44ff88f2e686f89303ba0','snapshot_gigabytes',1002),(40,'2025-11-28 10:10:09.325399',NULL,'2025-11-28 10:10:09.345501',40,'3e75d8532ea44ff88f2e686f89303ba0','snapshots',52),(41,'2025-11-28 10:10:09.680812',NULL,'2025-11-28 10:10:09.705858',41,'3e75d8532ea44ff88f2e686f89303ba0','share_replicas',99),(42,'2025-11-28 10:10:09.886280',NULL,'2025-11-28 10:10:09.912387',42,'3e75d8532ea44ff88f2e686f89303ba0','replica_gigabytes',999),(43,'2025-11-28 10:10:10.509159',NULL,'2025-11-28 10:10:10.621897',43,'3e75d8532ea44ff88f2e686f89303ba0','shares',10),(44,'2025-11-28 10:10:10.666260',NULL,'2025-11-28 10:10:10.774456',44,'3e75d8532ea44ff88f2e686f89303ba0','shares',10);
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `usage_id` (`usage_id`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=979 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `share_type_id`) VALUES ('2025-11-28 10:06:48.049719',NULL,'2025-11-28 10:06:48.250126',1,1,'397ae286549f4936afa2820dae60ba57','1484ffb7-cd72-46ed-b10a-b270fcf66f32',1,'3b3a94b107524e81a6368eb9596632ef','shares',1,'2025-11-29 10:06:47',NULL),('2025-11-28 10:06:48.053430',NULL,'2025-11-28 10:06:48.250126',2,2,'397ae286549f4936afa2820dae60ba57','5ce17801-c6a8-430b-adf4-87ba9914ff23',2,'3b3a94b107524e81a6368eb9596632ef','gigabytes',1,'2025-11-29 10:06:47',NULL),('2025-11-28 10:06:48.069915',NULL,'2025-11-28 10:06:48.250126',3,3,NULL,'b3be7159-f5dd-4f3e-b666-2c4e943f2cd2',3,'3b3a94b107524e81a6368eb9596632ef','shares',1,'2025-11-29 10:06:47','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:06:48.076857',NULL,'2025-11-28 10:06:48.250126',4,4,NULL,'6e645bc8-148c-4fe7-862b-69ee56f5bb5f',4,'3b3a94b107524e81a6368eb9596632ef','gigabytes',1,'2025-11-29 10:06:47','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:06:53.298137',NULL,'2025-11-28 10:06:53.549164',5,5,'397ae286549f4936afa2820dae60ba57','b316497e-3929-40aa-8209-8cdfd121d0ab',1,'3b3a94b107524e81a6368eb9596632ef','shares',1,'2025-11-29 10:06:53',NULL),('2025-11-28 10:06:53.307577',NULL,'2025-11-28 10:06:53.549164',6,6,'397ae286549f4936afa2820dae60ba57','00efa66d-8195-4171-b462-1989e5fedc79',2,'3b3a94b107524e81a6368eb9596632ef','gigabytes',1,'2025-11-29 10:06:53',NULL),('2025-11-28 10:06:53.466601',NULL,'2025-11-28 10:06:53.549164',7,7,NULL,'b533ac4f-5c1c-4265-b88e-1c569c382e3a',3,'3b3a94b107524e81a6368eb9596632ef','shares',1,'2025-11-29 10:06:53','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:06:53.468062',NULL,'2025-11-28 10:06:53.549164',8,8,NULL,'c70bc0e7-006d-4feb-a2e3-c59ed1f63e2b',4,'3b3a94b107524e81a6368eb9596632ef','gigabytes',1,'2025-11-29 10:06:53','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:06:57.055052',NULL,'2025-11-28 10:06:58.390178',9,9,'397ae286549f4936afa2820dae60ba57','745daf7f-c1f9-4333-ba7c-927436893fa5',2,'3b3a94b107524e81a6368eb9596632ef','gigabytes',1,'2025-11-29 10:06:57',NULL),('2025-11-28 10:06:58.156349',NULL,'2025-11-28 10:06:58.390178',10,10,NULL,'1e3aec02-13ff-4fd2-abdf-fa6f00bd2d02',4,'3b3a94b107524e81a6368eb9596632ef','gigabytes',1,'2025-11-29 10:06:57','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:02.302557',NULL,'2025-11-28 10:07:02.823256',11,11,'397ae286549f4936afa2820dae60ba57','9139133d-6c55-4684-9341-a0088fd9d640',1,'3b3a94b107524e81a6368eb9596632ef','shares',-1,'2025-11-29 10:07:02',NULL),('2025-11-28 10:07:02.303392',NULL,'2025-11-28 10:07:02.823256',12,12,'397ae286549f4936afa2820dae60ba57','0b6ef82a-d91e-46e5-b412-6abc11df3d67',2,'3b3a94b107524e81a6368eb9596632ef','gigabytes',-2,'2025-11-29 10:07:02',NULL),('2025-11-28 10:07:02.465240',NULL,'2025-11-28 10:07:02.823256',13,13,NULL,'8c6a1a35-c52c-445f-b9ea-0788ae4d889b',3,'3b3a94b107524e81a6368eb9596632ef','shares',-1,'2025-11-29 10:07:02','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:02.466719',NULL,'2025-11-28 10:07:02.823256',14,14,NULL,'c5b087b2-4099-4721-965c-3913bb81a985',4,'3b3a94b107524e81a6368eb9596632ef','gigabytes',-2,'2025-11-29 10:07:02','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:05.177769',NULL,'2025-11-28 10:07:05.651713',15,15,'397ae286549f4936afa2820dae60ba57','26cb7d3c-6307-4daf-873b-688da2e7dcad',1,'3b3a94b107524e81a6368eb9596632ef','shares',1,'2025-11-29 10:07:05',NULL),('2025-11-28 10:07:05.185517',NULL,'2025-11-28 10:07:05.651713',16,16,'397ae286549f4936afa2820dae60ba57','49e930a9-4ff3-4cf7-a7f7-d8f99471cb2a',2,'3b3a94b107524e81a6368eb9596632ef','gigabytes',1,'2025-11-29 10:07:05',NULL),('2025-11-28 10:07:05.295505',NULL,'2025-11-28 10:07:05.651713',17,17,NULL,'e2f30a43-b1df-4315-a6fe-b265145c8c3d',3,'3b3a94b107524e81a6368eb9596632ef','shares',1,'2025-11-29 10:07:05','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:05.296592',NULL,'2025-11-28 10:07:05.651713',18,18,NULL,'c8e5f4d0-4525-4585-88e8-36e347a53fe0',4,'3b3a94b107524e81a6368eb9596632ef','gigabytes',1,'2025-11-29 10:07:05','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:09.420964',NULL,'2025-11-28 10:07:10.203888',19,19,'397ae286549f4936afa2820dae60ba57','ad14aa08-0182-4984-a8f4-c52a5b1ae78c',2,'3b3a94b107524e81a6368eb9596632ef','gigabytes',1,'2025-11-29 10:07:09',NULL),('2025-11-28 10:07:09.481931',NULL,'2025-11-28 10:07:10.203888',20,20,NULL,'765aeffd-1db7-4580-981c-0ce3cef559bb',4,'3b3a94b107524e81a6368eb9596632ef','gigabytes',1,'2025-11-29 10:07:09','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:13.765280',NULL,'2025-11-28 10:07:13.805795',21,21,'397ae286549f4936afa2820dae60ba57','3f5f3604-372f-44ea-ade9-f2cbb2ac720c',1,'3b3a94b107524e81a6368eb9596632ef','shares',-1,'2025-11-29 10:07:13',NULL),('2025-11-28 10:07:13.765905',NULL,'2025-11-28 10:07:13.805795',22,22,'397ae286549f4936afa2820dae60ba57','5ce0ec03-2a1e-436a-b930-d28290c49e58',2,'3b3a94b107524e81a6368eb9596632ef','gigabytes',-2,'2025-11-29 10:07:13',NULL),('2025-11-28 10:07:13.795147',NULL,'2025-11-28 10:07:13.805795',23,23,NULL,'c0906da2-c1c2-4274-90e9-58287e6d49eb',3,'3b3a94b107524e81a6368eb9596632ef','shares',-1,'2025-11-29 10:07:13','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:13.795902',NULL,'2025-11-28 10:07:13.805795',24,24,NULL,'5e92dd92-2d1e-46ff-a72c-8bbf0c79b37d',4,'3b3a94b107524e81a6368eb9596632ef','gigabytes',-2,'2025-11-29 10:07:13','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:16.683930',NULL,'2025-11-28 10:07:17.226211',25,25,'397ae286549f4936afa2820dae60ba57','7cc8470d-953d-478f-8300-16e5c47460b9',1,'3b3a94b107524e81a6368eb9596632ef','shares',1,'2025-11-29 10:07:16',NULL),('2025-11-28 10:07:16.685078',NULL,'2025-11-28 10:07:17.226211',26,26,'397ae286549f4936afa2820dae60ba57','8d401521-c45b-4077-8234-e9537a38e006',2,'3b3a94b107524e81a6368eb9596632ef','gigabytes',1,'2025-11-29 10:07:16',NULL),('2025-11-28 10:07:16.853343',NULL,'2025-11-28 10:07:17.226211',27,27,NULL,'8b8a901c-1eac-478e-83ce-c41209f23e4b',3,'3b3a94b107524e81a6368eb9596632ef','shares',1,'2025-11-29 10:07:16','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:16.854511',NULL,'2025-11-28 10:07:17.226211',28,28,NULL,'ccbfdaeb-be79-4110-8d72-1a526d8e5fda',4,'3b3a94b107524e81a6368eb9596632ef','gigabytes',1,'2025-11-29 10:07:16','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:21.032900',NULL,'2025-11-28 10:07:21.053580',29,29,'397ae286549f4936afa2820dae60ba57','c041bf3f-110c-489e-92bb-8cd445d47d13',1,'3b3a94b107524e81a6368eb9596632ef','shares',-1,'2025-11-29 10:07:20',NULL),('2025-11-28 10:07:21.034065',NULL,'2025-11-28 10:07:21.053580',30,30,'397ae286549f4936afa2820dae60ba57','ddcc9a98-e36b-4d4f-9f75-11af69e50d90',2,'3b3a94b107524e81a6368eb9596632ef','gigabytes',-1,'2025-11-29 10:07:20',NULL),('2025-11-28 10:07:21.041880',NULL,'2025-11-28 10:07:21.053580',31,31,NULL,'b4e77fb5-36aa-40b6-afad-5aefd67a5a12',3,'3b3a94b107524e81a6368eb9596632ef','shares',-1,'2025-11-29 10:07:20','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:21.043386',NULL,'2025-11-28 10:07:21.053580',32,32,NULL,'a0ebaf1a-f7d3-40b0-8546-00df7f5099a2',4,'3b3a94b107524e81a6368eb9596632ef','gigabytes',-1,'2025-11-29 10:07:20','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:23.843293',NULL,'2025-11-28 10:07:23.901063',33,33,'397ae286549f4936afa2820dae60ba57','3dbbb81c-965d-4d33-b789-48838f0d62c0',1,'3b3a94b107524e81a6368eb9596632ef','shares',1,'2025-11-29 10:07:23',NULL),('2025-11-28 10:07:23.846266',NULL,'2025-11-28 10:07:23.901063',34,34,'397ae286549f4936afa2820dae60ba57','e6416802-9c7a-45f4-bfe4-2044e9b68b28',2,'3b3a94b107524e81a6368eb9596632ef','gigabytes',1,'2025-11-29 10:07:23',NULL),('2025-11-28 10:07:23.860234',NULL,'2025-11-28 10:07:23.901063',35,35,NULL,'7bb720bc-6c6a-4260-aed7-2b3617a80620',3,'3b3a94b107524e81a6368eb9596632ef','shares',1,'2025-11-29 10:07:23','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:23.861672',NULL,'2025-11-28 10:07:23.901063',36,36,NULL,'7eddad4e-c3fe-4e78-ae8e-cbe3ac241305',4,'3b3a94b107524e81a6368eb9596632ef','gigabytes',1,'2025-11-29 10:07:23','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:27.599148',NULL,'2025-11-28 10:07:27.623663',37,37,'397ae286549f4936afa2820dae60ba57','fe83612b-308b-46f5-b5e5-f9a13c39542c',1,'3b3a94b107524e81a6368eb9596632ef','shares',-1,'2025-11-29 10:07:27',NULL),('2025-11-28 10:07:27.599895',NULL,'2025-11-28 10:07:27.623663',38,38,'397ae286549f4936afa2820dae60ba57','db380e37-56d5-4a61-8172-ab97280dc736',2,'3b3a94b107524e81a6368eb9596632ef','gigabytes',-1,'2025-11-29 10:07:27',NULL),('2025-11-28 10:07:27.610708',NULL,'2025-11-28 10:07:27.623663',39,39,NULL,'3191245a-80b6-46c6-9eb5-d9f2cf1ebb5a',3,'3b3a94b107524e81a6368eb9596632ef','shares',-1,'2025-11-29 10:07:27','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:27.611858',NULL,'2025-11-28 10:07:27.623663',40,40,NULL,'f4cc6237-df52-4680-9450-3ae68ef5c082',4,'3b3a94b107524e81a6368eb9596632ef','gigabytes',-1,'2025-11-29 10:07:27','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:30.567706',NULL,'2025-11-28 10:07:30.692752',41,41,'397ae286549f4936afa2820dae60ba57','81cbbbc7-8053-4052-bfdc-03d2ecba809b',5,'3b3a94b107524e81a6368eb9596632ef','snapshots',1,'2025-11-29 10:07:30',NULL),('2025-11-28 10:07:30.569859',NULL,'2025-11-28 10:07:30.692752',42,42,'397ae286549f4936afa2820dae60ba57','a96b829e-d340-4bda-ab49-d2d7430ada47',6,'3b3a94b107524e81a6368eb9596632ef','snapshot_gigabytes',1,'2025-11-29 10:07:30',NULL),('2025-11-28 10:07:30.583273',NULL,'2025-11-28 10:07:30.692752',43,43,NULL,'1394ea9b-60ad-40b6-9057-e3e86eb0f38e',7,'3b3a94b107524e81a6368eb9596632ef','snapshots',1,'2025-11-29 10:07:30','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:30.585964',NULL,'2025-11-28 10:07:30.692752',44,44,NULL,'b585b750-07f7-429e-a600-3a26f24e4e5a',8,'3b3a94b107524e81a6368eb9596632ef','snapshot_gigabytes',1,'2025-11-29 10:07:30','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:35.579922',NULL,'2025-11-28 10:07:35.636531',45,45,'f802db1a51604b1dbdd96ee766d48fa6','d01e40ff-1519-4ce3-b537-555e05024df2',9,'a569d731bef04fb89d34131fc9ebf2c6','shares',1,'2025-11-29 10:07:35',NULL),('2025-11-28 10:07:35.581329',NULL,'2025-11-28 10:07:35.636531',46,46,'f802db1a51604b1dbdd96ee766d48fa6','fa83a95e-7b1e-4f12-ba67-864de717e636',10,'a569d731bef04fb89d34131fc9ebf2c6','gigabytes',1,'2025-11-29 10:07:35',NULL),('2025-11-28 10:07:35.595243',NULL,'2025-11-28 10:07:35.636531',47,47,NULL,'8e411451-9747-42d8-97a4-f1d7be0ff73d',11,'a569d731bef04fb89d34131fc9ebf2c6','shares',1,'2025-11-29 10:07:35','d3ceaea7-88b9-454d-8532-5f948430c211'),('2025-11-28 10:07:35.597046',NULL,'2025-11-28 10:07:35.636531',48,48,NULL,'223505a5-9a43-4e73-9c0c-9c8d17eb84a6',12,'a569d731bef04fb89d34131fc9ebf2c6','gigabytes',1,'2025-11-29 10:07:35','d3ceaea7-88b9-454d-8532-5f948430c211'),('2025-11-28 10:07:36.600718',NULL,'2025-11-28 10:07:36.708513',49,49,'397ae286549f4936afa2820dae60ba57','0df655dd-f74e-4272-8a89-5ba2f12435c5',5,'3b3a94b107524e81a6368eb9596632ef','snapshots',-1,'2025-11-29 10:07:36',NULL),('2025-11-28 10:07:36.602117',NULL,'2025-11-28 10:07:36.708513',50,50,'397ae286549f4936afa2820dae60ba57','59154589-9e56-45c2-a9f7-b7543adc1dc7',6,'3b3a94b107524e81a6368eb9596632ef','snapshot_gigabytes',-1,'2025-11-29 10:07:36',NULL),('2025-11-28 10:07:36.616700',NULL,'2025-11-28 10:07:36.708513',51,51,NULL,'bb68e76c-746a-4019-b715-59195c3dc914',7,'3b3a94b107524e81a6368eb9596632ef','snapshots',-1,'2025-11-29 10:07:36','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:36.617588',NULL,'2025-11-28 10:07:36.708513',52,52,NULL,'289f0ea9-dfda-4a2d-8add-f12b836d7777',8,'3b3a94b107524e81a6368eb9596632ef','snapshot_gigabytes',-1,'2025-11-29 10:07:36','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:39.141551',NULL,'2025-11-28 10:07:39.282500',53,53,'f802db1a51604b1dbdd96ee766d48fa6','a899b652-fb6a-43cf-86fa-886a54ce55ed',13,'a569d731bef04fb89d34131fc9ebf2c6','snapshots',1,'2025-11-29 10:07:39',NULL),('2025-11-28 10:07:39.144098',NULL,'2025-11-28 10:07:39.282500',54,54,'f802db1a51604b1dbdd96ee766d48fa6','e8d8f7a2-7429-44be-b7b8-2c917cb77c65',14,'a569d731bef04fb89d34131fc9ebf2c6','snapshot_gigabytes',1,'2025-11-29 10:07:39',NULL),('2025-11-28 10:07:39.160291',NULL,'2025-11-28 10:07:39.282500',55,55,NULL,'2599c4f3-4cc2-46c5-8142-b6b722a9c59c',15,'a569d731bef04fb89d34131fc9ebf2c6','snapshots',1,'2025-11-29 10:07:39','d3ceaea7-88b9-454d-8532-5f948430c211'),('2025-11-28 10:07:39.161499',NULL,'2025-11-28 10:07:39.282500',56,56,NULL,'f7fd630f-ecb9-4b43-974d-08fb050ec555',16,'a569d731bef04fb89d34131fc9ebf2c6','snapshot_gigabytes',1,'2025-11-29 10:07:39','d3ceaea7-88b9-454d-8532-5f948430c211'),('2025-11-28 10:07:40.790375',NULL,'2025-11-28 10:07:40.856437',57,57,'397ae286549f4936afa2820dae60ba57','1cbda123-5539-4310-bc7e-99f1180349fa',5,'3b3a94b107524e81a6368eb9596632ef','snapshots',1,'2025-11-29 10:07:40',NULL),('2025-11-28 10:07:40.791653',NULL,'2025-11-28 10:07:40.856437',58,58,'397ae286549f4936afa2820dae60ba57','ec52f9ac-1cc7-4f77-9ac6-aed48db5715a',6,'3b3a94b107524e81a6368eb9596632ef','snapshot_gigabytes',1,'2025-11-29 10:07:40',NULL),('2025-11-28 10:07:40.797167',NULL,'2025-11-28 10:07:40.856437',59,59,NULL,'a4654ed4-6510-4247-87af-cda5bbe43021',7,'3b3a94b107524e81a6368eb9596632ef','snapshots',1,'2025-11-29 10:07:40','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:40.798209',NULL,'2025-11-28 10:07:40.856437',60,60,NULL,'22ec94d0-9942-4bb4-a49d-d0b6500df934',8,'3b3a94b107524e81a6368eb9596632ef','snapshot_gigabytes',1,'2025-11-29 10:07:40','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:44.016348',NULL,'2025-11-28 10:07:44.055517',61,61,'f802db1a51604b1dbdd96ee766d48fa6','fbd3ee47-bfb4-46e3-bd95-02aea19d9792',13,'a569d731bef04fb89d34131fc9ebf2c6','snapshots',-1,'2025-11-29 10:07:43',NULL),('2025-11-28 10:07:44.017265',NULL,'2025-11-28 10:07:44.055517',62,62,'f802db1a51604b1dbdd96ee766d48fa6','e1abbc15-2dd3-4f52-a8ce-a4dac82f935e',14,'a569d731bef04fb89d34131fc9ebf2c6','snapshot_gigabytes',-1,'2025-11-29 10:07:43',NULL),('2025-11-28 10:07:44.042757',NULL,'2025-11-28 10:07:44.055517',63,63,NULL,'1559308a-1ced-4e82-8b8b-1e2bac5d8f65',15,'a569d731bef04fb89d34131fc9ebf2c6','snapshots',-1,'2025-11-29 10:07:43','d3ceaea7-88b9-454d-8532-5f948430c211'),('2025-11-28 10:07:44.043531',NULL,'2025-11-28 10:07:44.055517',64,64,NULL,'24b93e47-4d88-48b2-bff9-06d39320de70',16,'a569d731bef04fb89d34131fc9ebf2c6','snapshot_gigabytes',-1,'2025-11-29 10:07:43','d3ceaea7-88b9-454d-8532-5f948430c211'),('2025-11-28 10:07:44.476710',NULL,'2025-11-28 10:07:45.768501',65,65,'397ae286549f4936afa2820dae60ba57','7f21fbd2-f400-4216-b8d0-a0a3ecc681e4',5,'3b3a94b107524e81a6368eb9596632ef','snapshots',1,'2025-11-29 10:07:44',NULL),('2025-11-28 10:07:44.477933',NULL,'2025-11-28 10:07:45.768501',66,66,'397ae286549f4936afa2820dae60ba57','eccd9a63-7804-49c5-a75b-6ec53f568b73',6,'3b3a94b107524e81a6368eb9596632ef','snapshot_gigabytes',1,'2025-11-29 10:07:44',NULL),('2025-11-28 10:07:44.708423',NULL,'2025-11-28 10:07:45.768501',67,67,NULL,'2d1cbfb5-eff7-4024-8700-728e6ea4a546',7,'3b3a94b107524e81a6368eb9596632ef','snapshots',1,'2025-11-29 10:07:44','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:44.710188',NULL,'2025-11-28 10:07:45.768501',68,68,NULL,'8a1064fa-62ce-489d-bcfa-0176319954ca',8,'3b3a94b107524e81a6368eb9596632ef','snapshot_gigabytes',1,'2025-11-29 10:07:44','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:47.716914',NULL,'2025-11-28 10:07:47.831242',69,69,'f802db1a51604b1dbdd96ee766d48fa6','e2a2ddb6-ec1b-4751-be83-f74db3879fcf',9,'a569d731bef04fb89d34131fc9ebf2c6','shares',-1,'2025-11-29 10:07:47',NULL),('2025-11-28 10:07:47.717815',NULL,'2025-11-28 10:07:47.831242',70,70,'f802db1a51604b1dbdd96ee766d48fa6','81126c95-f188-4d69-bad6-509a56272282',10,'a569d731bef04fb89d34131fc9ebf2c6','gigabytes',-1,'2025-11-29 10:07:47',NULL),('2025-11-28 10:07:47.735447',NULL,'2025-11-28 10:07:47.831242',71,71,NULL,'d0e06bce-69a0-49af-8afd-9f07bd978469',11,'a569d731bef04fb89d34131fc9ebf2c6','shares',-1,'2025-11-29 10:07:47','d3ceaea7-88b9-454d-8532-5f948430c211'),('2025-11-28 10:07:47.736446',NULL,'2025-11-28 10:07:47.831242',72,72,NULL,'b2c4e562-c8bd-42ec-88fa-07dfe57e4554',12,'a569d731bef04fb89d34131fc9ebf2c6','gigabytes',-1,'2025-11-29 10:07:47','d3ceaea7-88b9-454d-8532-5f948430c211'),('2025-11-28 10:07:49.260661',NULL,'2025-11-28 10:07:49.703359',73,73,'397ae286549f4936afa2820dae60ba57','ec38ba19-62f7-499a-aee5-168c235dbf20',5,'3b3a94b107524e81a6368eb9596632ef','snapshots',1,'2025-11-29 10:07:49',NULL),('2025-11-28 10:07:49.262409',NULL,'2025-11-28 10:07:49.703359',74,74,'397ae286549f4936afa2820dae60ba57','c90f17d7-9c2d-44ae-9966-fcbb9290cc35',6,'3b3a94b107524e81a6368eb9596632ef','snapshot_gigabytes',1,'2025-11-29 10:07:49',NULL),('2025-11-28 10:07:49.506526',NULL,'2025-11-28 10:07:49.703359',75,75,NULL,'2356ea1a-c44a-4e66-be89-5a51b556b771',7,'3b3a94b107524e81a6368eb9596632ef','snapshots',1,'2025-11-29 10:07:49','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:49.508271',NULL,'2025-11-28 10:07:49.703359',76,76,NULL,'c2c65e4b-0fb0-4b46-8ffb-8c9d8c8ff57a',8,'3b3a94b107524e81a6368eb9596632ef','snapshot_gigabytes',1,'2025-11-29 10:07:49','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:53.641882',NULL,'2025-11-28 10:07:53.876337',77,77,'397ae286549f4936afa2820dae60ba57','65586a1b-327b-4ec2-ba11-6ba412b790bb',5,'3b3a94b107524e81a6368eb9596632ef','snapshots',1,'2025-11-29 10:07:53',NULL),('2025-11-28 10:07:53.643259',NULL,'2025-11-28 10:07:53.876337',78,78,'397ae286549f4936afa2820dae60ba57','cff33389-7195-4bb9-af55-f6823deaa7f5',6,'3b3a94b107524e81a6368eb9596632ef','snapshot_gigabytes',1,'2025-11-29 10:07:53',NULL),('2025-11-28 10:07:53.655327',NULL,'2025-11-28 10:07:53.876337',79,79,NULL,'a7e003d0-258f-4dba-88ce-3dfd76802818',7,'3b3a94b107524e81a6368eb9596632ef','snapshots',1,'2025-11-29 10:07:53','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:53.656779',NULL,'2025-11-28 10:07:53.876337',80,80,NULL,'cd6931aa-c0d9-4631-b502-340f88bf9764',8,'3b3a94b107524e81a6368eb9596632ef','snapshot_gigabytes',1,'2025-11-29 10:07:53','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:57.369611',NULL,'2025-11-28 10:07:57.427659',81,81,'397ae286549f4936afa2820dae60ba57','15455f40-1578-44ab-b5d2-d91a895c13b6',5,'3b3a94b107524e81a6368eb9596632ef','snapshots',1,'2025-11-29 10:07:57',NULL),('2025-11-28 10:07:57.371942',NULL,'2025-11-28 10:07:57.427659',82,82,'397ae286549f4936afa2820dae60ba57','d1e75507-58ab-467d-849f-d8641adf2e12',6,'3b3a94b107524e81a6368eb9596632ef','snapshot_gigabytes',1,'2025-11-29 10:07:57',NULL),('2025-11-28 10:07:57.380405',NULL,'2025-11-28 10:07:57.427659',83,83,NULL,'073bcb54-8b9d-499a-9290-292819e6a03a',7,'3b3a94b107524e81a6368eb9596632ef','snapshots',1,'2025-11-29 10:07:57','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:07:57.381833',NULL,'2025-11-28 10:07:57.427659',84,84,NULL,'c0eb7475-5d4a-4a64-8650-df0e60ad6009',8,'3b3a94b107524e81a6368eb9596632ef','snapshot_gigabytes',1,'2025-11-29 10:07:57','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:08:01.288044',NULL,'2025-11-28 10:08:01.319490',85,85,'397ae286549f4936afa2820dae60ba57','94ce1160-6204-467e-8837-0dca62df6f7e',5,'3b3a94b107524e81a6368eb9596632ef','snapshots',-1,'2025-11-29 10:08:01',NULL),('2025-11-28 10:08:01.288986',NULL,'2025-11-28 10:08:01.319490',86,86,'397ae286549f4936afa2820dae60ba57','a6cf128e-d3d5-4f65-84d6-6b8e117b24a4',6,'3b3a94b107524e81a6368eb9596632ef','snapshot_gigabytes',-1,'2025-11-29 10:08:01',NULL),('2025-11-28 10:08:01.295458',NULL,'2025-11-28 10:08:01.319490',87,87,NULL,'127138d2-4dc3-4a0f-8d73-8d5171b1edd2',7,'3b3a94b107524e81a6368eb9596632ef','snapshots',-1,'2025-11-29 10:08:01','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:08:01.296329',NULL,'2025-11-28 10:08:01.319490',88,88,NULL,'4d5f8816-0c29-4a39-91e0-e95f58570c79',8,'3b3a94b107524e81a6368eb9596632ef','snapshot_gigabytes',-1,'2025-11-29 10:08:01','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:08:04.473256',NULL,'2025-11-28 10:08:04.491519',89,89,'397ae286549f4936afa2820dae60ba57','9a0a0aca-6264-4edc-abdf-5fec5242113b',5,'3b3a94b107524e81a6368eb9596632ef','snapshots',-1,'2025-11-29 10:08:04',NULL),('2025-11-28 10:08:04.477014',NULL,'2025-11-28 10:08:04.491519',90,90,'397ae286549f4936afa2820dae60ba57','e44f1ef5-b022-4126-89f9-afa8e23685e7',6,'3b3a94b107524e81a6368eb9596632ef','snapshot_gigabytes',-1,'2025-11-29 10:08:04',NULL),('2025-11-28 10:08:04.482674',NULL,'2025-11-28 10:08:04.491519',91,91,NULL,'6bab710b-d315-4aa2-aff4-de1e5689cc6a',7,'3b3a94b107524e81a6368eb9596632ef','snapshots',-1,'2025-11-29 10:08:04','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:08:04.483425',NULL,'2025-11-28 10:08:04.491519',92,92,NULL,'0c93512c-226b-48bd-99c7-35990ce69404',8,'3b3a94b107524e81a6368eb9596632ef','snapshot_gigabytes',-1,'2025-11-29 10:08:04','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:08:06.127131',NULL,'2025-11-28 10:08:06.166324',93,93,'cedb40889fbd4a029cbd1938fd1266ee','d37877c7-cf9b-4549-973c-6378a1585184',17,'8c33f10ccf134f4faab82ed622e3c707','shares',1,'2025-11-29 10:08:06',NULL),('2025-11-28 10:08:06.128453',NULL,'2025-11-28 10:08:06.166324',94,94,'cedb40889fbd4a029cbd1938fd1266ee','18fffc92-b67f-4458-9940-972efd801ae9',18,'8c33f10ccf134f4faab82ed622e3c707','gigabytes',1,'2025-11-29 10:08:06',NULL),('2025-11-28 10:08:06.147514',NULL,'2025-11-28 10:08:06.166324',95,95,NULL,'d4781516-563b-4ec6-99bb-a4e86edefa81',19,'8c33f10ccf134f4faab82ed622e3c707','shares',1,'2025-11-29 10:08:06','cf1a6cda-dacb-4121-8321-fcda1cab307d'),('2025-11-28 10:08:06.148574',NULL,'2025-11-28 10:08:06.166324',96,96,NULL,'917f10e8-8bd0-4d67-b1e6-6d5452bfaf7e',20,'8c33f10ccf134f4faab82ed622e3c707','gigabytes',1,'2025-11-29 10:08:06','cf1a6cda-dacb-4121-8321-fcda1cab307d'),('2025-11-28 10:08:07.695870',NULL,'2025-11-28 10:08:07.713206',97,97,'397ae286549f4936afa2820dae60ba57','59dbfc13-5740-4e17-beeb-ba96a6e4fa93',5,'3b3a94b107524e81a6368eb9596632ef','snapshots',-1,'2025-11-29 10:08:07',NULL),('2025-11-28 10:08:07.697071',NULL,'2025-11-28 10:08:07.713206',98,98,'397ae286549f4936afa2820dae60ba57','1bec343d-c052-468d-a18d-c3694ddd3eb3',6,'3b3a94b107524e81a6368eb9596632ef','snapshot_gigabytes',-1,'2025-11-29 10:08:07',NULL),('2025-11-28 10:08:07.702904',NULL,'2025-11-28 10:08:07.713206',99,99,NULL,'e9f32296-b0bf-4511-947a-ad1ee1cc75f6',7,'3b3a94b107524e81a6368eb9596632ef','snapshots',-1,'2025-11-29 10:08:07','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:08:07.703738',NULL,'2025-11-28 10:08:07.713206',100,100,NULL,'373a3505-2432-4c59-aa57-a30e7d49069c',8,'3b3a94b107524e81a6368eb9596632ef','snapshot_gigabytes',-1,'2025-11-29 10:08:07','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:08:09.924303',NULL,'2025-11-28 10:08:09.943432',101,101,'cedb40889fbd4a029cbd1938fd1266ee','b7e1c29d-554a-4213-be3e-6a6d90262f2c',17,'8c33f10ccf134f4faab82ed622e3c707','shares',-1,'2025-11-29 10:08:09',NULL),('2025-11-28 10:08:09.926177',NULL,'2025-11-28 10:08:09.943432',102,102,'cedb40889fbd4a029cbd1938fd1266ee','b7033fbf-4e9c-49bc-93ec-fd3a0ee5cfd3',18,'8c33f10ccf134f4faab82ed622e3c707','gigabytes',-1,'2025-11-29 10:08:09',NULL),('2025-11-28 10:08:09.934786',NULL,'2025-11-28 10:08:09.943432',103,103,NULL,'3c618ee8-bed9-4dbe-9f1a-d3fb0815f000',19,'8c33f10ccf134f4faab82ed622e3c707','shares',-1,'2025-11-29 10:08:09','cf1a6cda-dacb-4121-8321-fcda1cab307d'),('2025-11-28 10:08:09.935587',NULL,'2025-11-28 10:08:09.943432',104,104,NULL,'e433cb9f-fa3b-406d-b234-0f4478c2a1fa',20,'8c33f10ccf134f4faab82ed622e3c707','gigabytes',-1,'2025-11-29 10:08:09','cf1a6cda-dacb-4121-8321-fcda1cab307d'),('2025-11-28 10:08:11.377118',NULL,'2025-11-28 10:08:11.404319',105,105,'397ae286549f4936afa2820dae60ba57','a320fc7f-d352-49c9-9133-fef9ec7ac723',5,'3b3a94b107524e81a6368eb9596632ef','snapshots',-1,'2025-11-29 10:08:11',NULL),('2025-11-28 10:08:11.377923',NULL,'2025-11-28 10:08:11.404319',106,106,'397ae286549f4936afa2820dae60ba57','c53014c1-cbf2-40c1-bf9a-ba24869412f6',6,'3b3a94b107524e81a6368eb9596632ef','snapshot_gigabytes',-1,'2025-11-29 10:08:11',NULL),('2025-11-28 10:08:11.388778',NULL,'2025-11-28 10:08:11.404319',107,107,NULL,'b986a520-981b-4d79-a7dd-072d4d6a64e5',7,'3b3a94b107524e81a6368eb9596632ef','snapshots',-1,'2025-11-29 10:08:11','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:08:11.391528',NULL,'2025-11-28 10:08:11.404319',108,108,NULL,'b1148913-632d-4337-87f3-7404722c6e40',8,'3b3a94b107524e81a6368eb9596632ef','snapshot_gigabytes',-1,'2025-11-29 10:08:11','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:08:14.209315',NULL,'2025-11-28 10:08:14.254271',109,109,'397ae286549f4936afa2820dae60ba57','a9d74c8b-770b-44b0-a21e-bddc4a200f76',5,'3b3a94b107524e81a6368eb9596632ef','snapshots',-1,'2025-11-29 10:08:14',NULL),('2025-11-28 10:08:14.210994',NULL,'2025-11-28 10:08:14.254271',110,110,'397ae286549f4936afa2820dae60ba57','92f8890a-5492-4653-8a38-22e5a4b950f1',6,'3b3a94b107524e81a6368eb9596632ef','snapshot_gigabytes',-1,'2025-11-29 10:08:14',NULL),('2025-11-28 10:08:14.236365',NULL,'2025-11-28 10:08:14.254271',111,111,NULL,'e3346fca-519d-44db-9d17-e52c2a5b5b1d',7,'3b3a94b107524e81a6368eb9596632ef','snapshots',-1,'2025-11-29 10:08:14','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:08:14.238790',NULL,'2025-11-28 10:08:14.254271',112,112,NULL,'b20d860a-7244-447a-a39e-66aa21782218',8,'3b3a94b107524e81a6368eb9596632ef','snapshot_gigabytes',-1,'2025-11-29 10:08:14','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:08:16.144569',NULL,'2025-11-28 10:08:16.184500',113,113,'571c8db1d62c42b2a968a166578b720c','bfbfa264-430c-47bc-b099-e61a9a66c64a',21,'761c122e3fe94bb6be6f10c7921c5430','shares',1,'2025-11-29 10:08:16',NULL),('2025-11-28 10:08:16.145877',NULL,'2025-11-28 10:08:16.184500',114,114,'571c8db1d62c42b2a968a166578b720c','9cb7b288-6b4c-4c56-8cd2-9fca71af9d7f',22,'761c122e3fe94bb6be6f10c7921c5430','gigabytes',1,'2025-11-29 10:08:16',NULL),('2025-11-28 10:08:16.155108',NULL,'2025-11-28 10:08:16.184500',115,115,NULL,'1d4303aa-6f49-48f5-ab9f-9ccf0b64fd0d',23,'761c122e3fe94bb6be6f10c7921c5430','shares',1,'2025-11-29 10:08:16','af507655-39b7-440e-b343-057f120fe78f'),('2025-11-28 10:08:16.156251',NULL,'2025-11-28 10:08:16.184500',116,116,NULL,'09cf1cd8-5411-4ad9-b548-32d1fbd774dc',24,'761c122e3fe94bb6be6f10c7921c5430','gigabytes',1,'2025-11-29 10:08:16','af507655-39b7-440e-b343-057f120fe78f'),('2025-11-28 10:08:17.589689',NULL,'2025-11-28 10:08:17.605313',117,117,'397ae286549f4936afa2820dae60ba57','966c06b4-51a5-40f9-9b11-66c2a41801f2',1,'3b3a94b107524e81a6368eb9596632ef','shares',-1,'2025-11-29 10:08:17',NULL),('2025-11-28 10:08:17.590416',NULL,'2025-11-28 10:08:17.605313',118,118,'397ae286549f4936afa2820dae60ba57','d4d26f38-05b2-45bb-bf65-0a56b27407a3',2,'3b3a94b107524e81a6368eb9596632ef','gigabytes',-1,'2025-11-29 10:08:17',NULL),('2025-11-28 10:08:17.595823',NULL,'2025-11-28 10:08:17.605313',119,119,NULL,'e8ee791c-f1e0-47e8-9ec1-3926954f4b63',3,'3b3a94b107524e81a6368eb9596632ef','shares',-1,'2025-11-29 10:08:17','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:08:17.596827',NULL,'2025-11-28 10:08:17.605313',120,120,NULL,'8bbefa9b-2858-4f37-a908-42207c18647a',4,'3b3a94b107524e81a6368eb9596632ef','gigabytes',-1,'2025-11-29 10:08:17','b2de6b61-666d-4a5b-9312-54000d9fa4ba'),('2025-11-28 10:08:19.438246',NULL,'2025-11-28 10:08:19.515167',121,121,'571c8db1d62c42b2a968a166578b720c','53c489a3-db4c-4eed-b1be-2dc169fc1bf7',25,'761c122e3fe94bb6be6f10c7921c5430','snapshots',1,'2025-11-29 10:08:19',NULL),('2025-11-28 10:08:19.439359',NULL,'2025-11-28 10:08:19.515167',122,122,'571c8db1d62c42b2a968a166578b720c','5a9adfb3-c5ed-42e7-9704-746abe63bfb5',26,'761c122e3fe94bb6be6f10c7921c5430','snapshot_gigabytes',1,'2025-11-29 10:08:19',NULL),('2025-11-28 10:08:19.457221',NULL,'2025-11-28 10:08:19.515167',123,123,NULL,'adb49aa7-ee25-4390-bcb3-2bf52ba89e7a',27,'761c122e3fe94bb6be6f10c7921c5430','snapshots',1,'2025-11-29 10:08:19','af507655-39b7-440e-b343-057f120fe78f'),('2025-11-28 10:08:19.461538',NULL,'2025-11-28 10:08:19.515167',124,124,NULL,'cb21cdb8-1fa5-4982-9b25-ee6c12a6af18',28,'761c122e3fe94bb6be6f10c7921c5430','snapshot_gigabytes',1,'2025-11-29 10:08:19','af507655-39b7-440e-b343-057f120fe78f'),('2025-11-28 10:08:21.179715',NULL,'2025-11-28 10:08:21.245872',125,125,'290c95bac4f44f9daecb4d5fbd5ae05f','f2cb2814-b316-4efa-b1d1-242d50745b93',29,'eaacddd7c7ae44869632c24b4e5d2d1b','share_networks',1,'2025-11-29 10:08:21',NULL),('2025-11-28 10:08:21.322002',NULL,'2025-11-28 10:08:21.390075',126,126,'290c95bac4f44f9daecb4d5fbd5ae05f','7dcc0f53-c15a-4b09-9eaf-fa3f322e9cef',29,'eaacddd7c7ae44869632c24b4e5d2d1b','share_networks',1,'2025-11-29 10:08:21',NULL),('2025-11-28 10:08:21.844624',NULL,'2025-11-28 10:08:21.850604',127,127,'290c95bac4f44f9daecb4d5fbd5ae05f','34608316-4f4b-4741-bf99-5f79f815c826',29,'eaacddd7c7ae44869632c24b4e5d2d1b','share_networks',-1,'2025-11-29 10:08:21',NULL),('2025-11-28 10:08:21.984625',NULL,'2025-11-28 10:08:21.989708',128,128,'290c95bac4f44f9daecb4d5fbd5ae05f','ba1975eb-26b7-498e-9e32-9c00cb457a27',29,'eaacddd7c7ae44869632c24b4e5d2d1b','share_networks',-1,'2025-11-29 10:08:21',NULL),('2025-11-28 10:08:22.818715',NULL,'2025-11-28 10:08:22.853704',129,129,'571c8db1d62c42b2a968a166578b720c','b8575ce7-39f4-4be3-af05-a9f5e47b8c24',21,'761c122e3fe94bb6be6f10c7921c5430','shares',1,'2025-11-29 10:08:22',NULL),('2025-11-28 10:08:22.820672',NULL,'2025-11-28 10:08:22.853704',130,130,'571c8db1d62c42b2a968a166578b720c','b36a1941-bca7-426c-9152-76d7ec544ca9',22,'761c122e3fe94bb6be6f10c7921c5430','gigabytes',1,'2025-11-29 10:08:22',NULL),('2025-11-28 10:08:22.830786',NULL,'2025-11-28 10:08:22.853704',131,131,NULL,'6f1a4e29-a16e-47b1-bf9f-abac2aede205',23,'761c122e3fe94bb6be6f10c7921c5430','shares',1,'2025-11-29 10:08:22','af507655-39b7-440e-b343-057f120fe78f'),('2025-11-28 10:08:22.832828',NULL,'2025-11-28 10:08:22.853704',132,132,NULL,'4fc48a70-af49-4ca6-9000-129ee6825333',24,'761c122e3fe94bb6be6f10c7921c5430','gigabytes',1,'2025-11-29 10:08:22','af507655-39b7-440e-b343-057f120fe78f'),('2025-11-28 10:08:41.656496',NULL,'2025-11-28 10:08:41.998176',133,133,'8c8bbd4325d54a30a3e49517be4e8eee','11f6e7f8-f91d-440b-b688-afa0702bc665',31,'3f91e76373a34e0880a287181873b7a3','shares',1,'2025-11-29 10:08:41',NULL),('2025-11-28 10:08:41.657535',NULL,'2025-11-28 10:08:41.998176',134,134,'8c8bbd4325d54a30a3e49517be4e8eee','071edea1-b41e-4908-8a36-6c78ebb09d56',30,'3f91e76373a34e0880a287181873b7a3','gigabytes',1,'2025-11-29 10:08:41',NULL),('2025-11-28 10:08:41.895496',NULL,'2025-11-28 10:08:41.998176',135,135,NULL,'09c37cad-1c37-4afc-ac8b-ba56c0b3597d',33,'3f91e76373a34e0880a287181873b7a3','shares',1,'2025-11-29 10:08:41','3e14384d-bfb8-44c0-8caf-18495421b84d'),('2025-11-28 10:08:41.897715',NULL,'2025-11-28 10:08:41.998176',136,136,NULL,'a391d874-baa0-4cfa-b4ec-f7b090d620a2',32,'3f91e76373a34e0880a287181873b7a3','gigabytes',1,'2025-11-29 10:08:41','3e14384d-bfb8-44c0-8caf-18495421b84d'),('2025-11-28 10:08:42.107434',NULL,'2025-11-28 10:08:42.139281',137,137,'e2f26fe9b8734c0fa7e6c6447c03e8e2','06ad9d97-2a9d-42be-b69b-4d5ff0975b99',34,'fa43b66fb64742319307c393a8613a34','shares',1,'2025-11-29 10:08:42',NULL),('2025-11-28 10:08:42.108817',NULL,'2025-11-28 10:08:42.139281',138,138,'e2f26fe9b8734c0fa7e6c6447c03e8e2','46703d14-69bb-44db-a86c-30969561c807',35,'fa43b66fb64742319307c393a8613a34','gigabytes',1,'2025-11-29 10:08:42',NULL),('2025-11-28 10:08:42.119243',NULL,'2025-11-28 10:08:42.139281',139,139,NULL,'35027b86-10c8-4e5b-aed4-94add82a75b7',36,'fa43b66fb64742319307c393a8613a34','shares',1,'2025-11-29 10:08:42','46d729d7-c40b-4017-8e82-bccb637d666c'),('2025-11-28 10:08:42.120415',NULL,'2025-11-28 10:08:42.139281',140,140,NULL,'b7d88923-d143-46b8-98b3-0e5d7eac5396',37,'fa43b66fb64742319307c393a8613a34','gigabytes',1,'2025-11-29 10:08:42','46d729d7-c40b-4017-8e82-bccb637d666c'),('2025-11-28 10:08:45.461713',NULL,'2025-11-28 10:08:45.494767',141,141,'8c8bbd4325d54a30a3e49517be4e8eee','2865bd90-4044-4813-905e-45f284ed1bd9',38,'3f91e76373a34e0880a287181873b7a3','shares',1,'2025-11-29 10:08:45',NULL),('2025-11-28 10:08:45.462996',NULL,'2025-11-28 10:08:45.494767',142,142,'8c8bbd4325d54a30a3e49517be4e8eee','2c2a0837-f741-4975-abf9-3a8f254a3a52',39,'3f91e76373a34e0880a287181873b7a3','gigabytes',1,'2025-11-29 10:08:45',NULL),('2025-11-28 10:08:45.472507',NULL,'2025-11-28 10:08:45.494767',143,143,NULL,'f9347056-dc05-4d1e-bdc4-3a34a2caf58f',40,'3f91e76373a34e0880a287181873b7a3','shares',1,'2025-11-29 10:08:45','d1d573e6-f9e2-4736-b87e-8764ea52daaf'),('2025-11-28 10:08:45.475651',NULL,'2025-11-28 10:08:45.494767',144,144,NULL,'f53087ee-5132-47bb-9eea-3572b9faa118',41,'3f91e76373a34e0880a287181873b7a3','gigabytes',1,'2025-11-29 10:08:45','d1d573e6-f9e2-4736-b87e-8764ea52daaf'),('2025-11-28 10:08:46.338755',NULL,'2025-11-28 10:08:46.358994',145,145,'e2f26fe9b8734c0fa7e6c6447c03e8e2','4728ae12-79d6-46e2-8c46-bc1c685bac16',34,'fa43b66fb64742319307c393a8613a34','shares',-1,'2025-11-29 10:08:46',NULL),('2025-11-28 10:08:46.339625',NULL,'2025-11-28 10:08:46.358994',146,146,'e2f26fe9b8734c0fa7e6c6447c03e8e2','a326d036-5f48-4c46-8126-c7ba8b3f8259',35,'fa43b66fb64742319307c393a8613a34','gigabytes',-1,'2025-11-29 10:08:46',NULL),('2025-11-28 10:08:46.347303',NULL,'2025-11-28 10:08:46.358994',147,147,NULL,'10b6f58b-285b-43dd-a94b-b98c52f1714c',36,'fa43b66fb64742319307c393a8613a34','shares',-1,'2025-11-29 10:08:46','46d729d7-c40b-4017-8e82-bccb637d666c'),('2025-11-28 10:08:46.349002',NULL,'2025-11-28 10:08:46.358994',148,148,NULL,'1b97050d-7c1d-43d3-b196-74e2b0d5c8a3',37,'fa43b66fb64742319307c393a8613a34','gigabytes',-1,'2025-11-29 10:08:46','46d729d7-c40b-4017-8e82-bccb637d666c'),('2025-11-28 10:08:48.965571',NULL,'2025-11-28 10:08:49.044435',149,149,'8c8bbd4325d54a30a3e49517be4e8eee','5b08d143-dc8f-4e64-aeb2-1db8197704c6',42,'3f91e76373a34e0880a287181873b7a3','snapshots',1,'2025-11-29 10:08:48',NULL),('2025-11-28 10:08:48.966860',NULL,'2025-11-28 10:08:49.044435',150,150,'8c8bbd4325d54a30a3e49517be4e8eee','6160e3d6-c269-4de1-9a72-4fe0d7745b97',43,'3f91e76373a34e0880a287181873b7a3','snapshot_gigabytes',1,'2025-11-29 10:08:48',NULL),('2025-11-28 10:08:48.977505',NULL,'2025-11-28 10:08:49.044435',151,151,NULL,'05b21ec4-4f30-4fed-adf5-d48df787b283',44,'3f91e76373a34e0880a287181873b7a3','snapshots',1,'2025-11-29 10:08:48','d1d573e6-f9e2-4736-b87e-8764ea52daaf'),('2025-11-28 10:08:48.978721',NULL,'2025-11-28 10:08:49.044435',152,152,NULL,'25d6e0b6-06d6-4825-b852-a772767c46f5',45,'3f91e76373a34e0880a287181873b7a3','snapshot_gigabytes',1,'2025-11-29 10:08:48','d1d573e6-f9e2-4736-b87e-8764ea52daaf'),('2025-11-28 10:08:56.112940',NULL,'2025-11-28 10:08:56.146587',153,153,'8c8bbd4325d54a30a3e49517be4e8eee','462cec08-4c3b-483e-8a8b-6c8295e98df7',47,'3f91e76373a34e0880a287181873b7a3','snapshots',-1,'2025-11-29 10:08:56',NULL),('2025-11-28 10:08:56.114048',NULL,'2025-11-28 10:08:56.146587',154,154,'8c8bbd4325d54a30a3e49517be4e8eee','e57d6b4f-929b-4b82-8edd-faba92c0bb13',46,'3f91e76373a34e0880a287181873b7a3','snapshot_gigabytes',-1,'2025-11-29 10:08:56',NULL),('2025-11-28 10:08:56.133851',NULL,'2025-11-28 10:08:56.146587',155,155,NULL,'8b6e2594-73fc-46a3-8a83-9dd6641d7215',49,'3f91e76373a34e0880a287181873b7a3','snapshots',-1,'2025-11-29 10:08:56','d1d573e6-f9e2-4736-b87e-8764ea52daaf'),('2025-11-28 10:08:56.134903',NULL,'2025-11-28 10:08:56.146587',156,156,NULL,'4b8080fb-b71e-4734-a50f-2c447a2164dd',48,'3f91e76373a34e0880a287181873b7a3','snapshot_gigabytes',-1,'2025-11-29 10:08:56','d1d573e6-f9e2-4736-b87e-8764ea52daaf'),('2025-11-28 10:08:56.280159',NULL,'2025-11-28 10:08:56.307433',157,157,'4dc754b220f84a609f3f7d67e318f8fc','b0013f3b-56ed-49dd-952b-13b41a36895b',50,'7b0f6782d0fb431b9fae9ffd3abbcba9','share_networks',1,'2025-11-29 10:08:56',NULL),('2025-11-28 10:08:56.578509',NULL,'2025-11-28 10:08:56.610213',158,158,'3c7061945daf4c41bfb3eb3d7862e9f1','03aef90c-1ca3-4499-bff3-e5090d0473ce',51,'c1c4ecd48c654f85b98d7f86e45ad517','share_networks',1,'2025-11-29 10:08:56',NULL),('2025-11-28 10:08:57.786969',NULL,'2025-11-28 10:08:57.792196',159,159,'4dc754b220f84a609f3f7d67e318f8fc','c903d33a-f691-42f5-bd0b-c1d2f5b8395a',50,'7b0f6782d0fb431b9fae9ffd3abbcba9','share_networks',-1,'2025-11-29 10:08:57',NULL),('2025-11-28 10:08:58.836677',NULL,'2025-11-28 10:08:58.867858',160,160,'8c8bbd4325d54a30a3e49517be4e8eee','71941821-6825-419f-8b32-9274b437e41e',52,'3f91e76373a34e0880a287181873b7a3','shares',-1,'2025-11-29 10:08:58',NULL),('2025-11-28 10:08:58.838102',NULL,'2025-11-28 10:08:58.867858',161,161,'8c8bbd4325d54a30a3e49517be4e8eee','6117eb48-9d48-413b-bbe7-a9ed6bf5e5e8',53,'3f91e76373a34e0880a287181873b7a3','gigabytes',-1,'2025-11-29 10:08:58',NULL),('2025-11-28 10:08:58.859524',NULL,'2025-11-28 10:08:58.867858',162,162,NULL,'88bb2ca7-c67f-47a7-928b-a064b50a153c',54,'3f91e76373a34e0880a287181873b7a3','shares',-1,'2025-11-29 10:08:58','d1d573e6-f9e2-4736-b87e-8764ea52daaf'),('2025-11-28 10:08:58.860246',NULL,'2025-11-28 10:08:58.867858',163,163,NULL,'e69e7a08-ae2a-4163-a917-5a085af6f856',55,'3f91e76373a34e0880a287181873b7a3','gigabytes',-1,'2025-11-29 10:08:58','d1d573e6-f9e2-4736-b87e-8764ea52daaf'),('2025-11-28 10:09:02.033945',NULL,'2025-11-28 10:09:02.054740',164,164,'8c8bbd4325d54a30a3e49517be4e8eee','a32dd8e7-94e1-4d5c-99a0-a0e4ae52a94e',52,'3f91e76373a34e0880a287181873b7a3','shares',-1,'2025-11-29 10:09:02',NULL),('2025-11-28 10:09:02.034700',NULL,'2025-11-28 10:09:02.054740',165,165,'8c8bbd4325d54a30a3e49517be4e8eee','1d18381f-56fb-4c47-8c20-0a95dfdcc676',53,'3f91e76373a34e0880a287181873b7a3','gigabytes',-1,'2025-11-29 10:09:02',NULL),('2025-11-28 10:09:02.046734',NULL,'2025-11-28 10:09:02.054740',166,166,NULL,'aecb4c15-d1b0-45dd-b12c-2f489410c328',56,'3f91e76373a34e0880a287181873b7a3','shares',-1,'2025-11-29 10:09:02','3e14384d-bfb8-44c0-8caf-18495421b84d'),('2025-11-28 10:09:02.047550',NULL,'2025-11-28 10:09:02.054740',167,167,NULL,'31314eba-4371-48d2-9e12-e2b3f4fe23ee',57,'3f91e76373a34e0880a287181873b7a3','gigabytes',-1,'2025-11-29 10:09:02','3e14384d-bfb8-44c0-8caf-18495421b84d'),('2025-11-28 10:09:02.255440',NULL,'2025-11-28 10:09:02.296705',168,168,'0c582186c0ed48b5b46bde7689b3c440','ed1d1463-6ff7-4ba7-a550-41566f289a4c',58,'12b605b0706b49d7b50bd67675f75239','shares',1,'2025-11-29 10:09:02',NULL),('2025-11-28 10:09:02.256529',NULL,'2025-11-28 10:09:02.296705',169,169,'0c582186c0ed48b5b46bde7689b3c440','fddc7853-e380-4e21-95e1-69831cdd73db',59,'12b605b0706b49d7b50bd67675f75239','gigabytes',1,'2025-11-29 10:09:02',NULL),('2025-11-28 10:09:02.273289',NULL,'2025-11-28 10:09:02.296705',170,170,NULL,'757451d5-dda8-4c88-aaaf-49f16e790b46',60,'12b605b0706b49d7b50bd67675f75239','shares',1,'2025-11-29 10:09:02','6d9a44e6-5425-4bc4-897b-744c603d89a3'),('2025-11-28 10:09:02.274624',NULL,'2025-11-28 10:09:02.296705',171,171,NULL,'79d9e1df-fa59-4c25-b24e-b96f589df49f',61,'12b605b0706b49d7b50bd67675f75239','gigabytes',1,'2025-11-29 10:09:02','6d9a44e6-5425-4bc4-897b-744c603d89a3'),('2025-11-28 10:09:05.528540',NULL,'2025-11-28 10:09:05.719961',172,172,'0c582186c0ed48b5b46bde7689b3c440','a6e40d99-58bc-4712-bb84-fc246edca0de',62,'12b605b0706b49d7b50bd67675f75239','snapshots',1,'2025-11-29 10:09:05',NULL),('2025-11-28 10:09:05.529642',NULL,'2025-11-28 10:09:05.719961',173,173,'0c582186c0ed48b5b46bde7689b3c440','67fafe3c-9fda-46d3-aba0-fa10fdbe90ae',63,'12b605b0706b49d7b50bd67675f75239','snapshot_gigabytes',1,'2025-11-29 10:09:05',NULL),('2025-11-28 10:09:05.540035',NULL,'2025-11-28 10:09:05.719961',174,174,NULL,'3aca5711-22f7-4d84-8e5c-c1d7ae6f4cc2',64,'12b605b0706b49d7b50bd67675f75239','snapshots',1,'2025-11-29 10:09:05','6d9a44e6-5425-4bc4-897b-744c603d89a3'),('2025-11-28 10:09:05.541078',NULL,'2025-11-28 10:09:05.719961',175,175,NULL,'f43db8eb-dc7e-47ac-be27-63c547b70961',65,'12b605b0706b49d7b50bd67675f75239','snapshot_gigabytes',1,'2025-11-29 10:09:05','6d9a44e6-5425-4bc4-897b-744c603d89a3'),('2025-11-28 10:09:07.568959',NULL,'2025-11-28 10:09:07.585014',176,176,'571c8db1d62c42b2a968a166578b720c','c178d3be-658c-4f02-b5a5-0e95402fa3eb',21,'761c122e3fe94bb6be6f10c7921c5430','shares',-1,'2025-11-29 10:09:07',NULL),('2025-11-28 10:09:07.569588',NULL,'2025-11-28 10:09:07.585014',177,177,'571c8db1d62c42b2a968a166578b720c','dbe4a1f7-0fa3-4cc3-95fd-32e7bf42f640',22,'761c122e3fe94bb6be6f10c7921c5430','gigabytes',-1,'2025-11-29 10:09:07',NULL),('2025-11-28 10:09:07.576228',NULL,'2025-11-28 10:09:07.585014',178,178,NULL,'4f8a698e-2a48-4bd8-a12c-af863e770473',23,'761c122e3fe94bb6be6f10c7921c5430','shares',-1,'2025-11-29 10:09:07','af507655-39b7-440e-b343-057f120fe78f'),('2025-11-28 10:09:07.576962',NULL,'2025-11-28 10:09:07.585014',179,179,NULL,'8cd878b2-3ec5-48d5-9056-e7e22d7ed6c8',24,'761c122e3fe94bb6be6f10c7921c5430','gigabytes',-1,'2025-11-29 10:09:07','af507655-39b7-440e-b343-057f120fe78f'),('2025-11-28 10:09:09.256402',NULL,'2025-11-28 10:09:09.354092',180,180,'0c582186c0ed48b5b46bde7689b3c440','627b5112-8ab6-4ca2-b5a5-ee553e80caf6',62,'12b605b0706b49d7b50bd67675f75239','snapshots',1,'2025-11-29 10:09:09',NULL),('2025-11-28 10:09:09.258337',NULL,'2025-11-28 10:09:09.354092',181,181,'0c582186c0ed48b5b46bde7689b3c440','c3cb37cb-3cc9-4278-b0e7-ea5fbb0d9fb6',63,'12b605b0706b49d7b50bd67675f75239','snapshot_gigabytes',1,'2025-11-29 10:09:09',NULL),('2025-11-28 10:09:09.279079',NULL,'2025-11-28 10:09:09.354092',182,182,NULL,'f1c547d0-3401-4982-b9c9-6a893530bf62',64,'12b605b0706b49d7b50bd67675f75239','snapshots',1,'2025-11-29 10:09:09','6d9a44e6-5425-4bc4-897b-744c603d89a3'),('2025-11-28 10:09:09.283266',NULL,'2025-11-28 10:09:09.354092',183,183,NULL,'08aecb1a-833a-4f31-96d3-fafb4cae72f1',65,'12b605b0706b49d7b50bd67675f75239','snapshot_gigabytes',1,'2025-11-29 10:09:09','6d9a44e6-5425-4bc4-897b-744c603d89a3'),('2025-11-28 10:09:10.810611',NULL,'2025-11-28 10:09:10.826226',184,184,'571c8db1d62c42b2a968a166578b720c','8c8ea977-e9a0-494c-85ca-e2151f943a03',25,'761c122e3fe94bb6be6f10c7921c5430','snapshots',-1,'2025-11-29 10:09:10',NULL),('2025-11-28 10:09:10.811385',NULL,'2025-11-28 10:09:10.826226',185,185,'571c8db1d62c42b2a968a166578b720c','1615d7a9-f26d-4622-a782-1bbaea4bcaf4',26,'761c122e3fe94bb6be6f10c7921c5430','snapshot_gigabytes',-1,'2025-11-29 10:09:10',NULL),('2025-11-28 10:09:10.817505',NULL,'2025-11-28 10:09:10.826226',186,186,NULL,'2e83e044-f547-4043-9cc8-ea32a2e7566d',27,'761c122e3fe94bb6be6f10c7921c5430','snapshots',-1,'2025-11-29 10:09:10','af507655-39b7-440e-b343-057f120fe78f'),('2025-11-28 10:09:10.818225',NULL,'2025-11-28 10:09:10.826226',187,187,NULL,'db710993-e400-4c3b-b814-0de2d55cbe08',28,'761c122e3fe94bb6be6f10c7921c5430','snapshot_gigabytes',-1,'2025-11-29 10:09:10','af507655-39b7-440e-b343-057f120fe78f'),('2025-11-28 10:09:12.711584',NULL,'2025-11-28 10:09:12.750713',188,188,'04b45146b0ab498fbc11c9fb27eaa424','07be9cf4-9699-49b6-a6f4-3e4997ab2cd6',66,'56c91df0287e4974b45f4ed0b63d771d','shares',1,'2025-11-29 10:09:12',NULL),('2025-11-28 10:09:12.712932',NULL,'2025-11-28 10:09:12.750713',189,189,'04b45146b0ab498fbc11c9fb27eaa424','216e038c-a3c0-4695-a2a5-411777ba2ca5',67,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',1,'2025-11-29 10:09:12',NULL),('2025-11-28 10:09:12.728038',NULL,'2025-11-28 10:09:12.750713',190,190,NULL,'a43e2c96-11ea-4925-9d40-395e981d0c7a',68,'56c91df0287e4974b45f4ed0b63d771d','shares',1,'2025-11-29 10:09:12','92b5d720-8b2c-44a0-8b87-437bdeefaf18'),('2025-11-28 10:09:12.729625',NULL,'2025-11-28 10:09:12.750713',191,191,NULL,'eb50d47f-c87f-418a-9ed1-6fe53b731d41',69,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',1,'2025-11-29 10:09:12','92b5d720-8b2c-44a0-8b87-437bdeefaf18'),('2025-11-28 10:09:13.084329',NULL,'2025-11-28 10:09:13.103306',192,192,'0c582186c0ed48b5b46bde7689b3c440','395acf2e-dcc5-4a31-a22f-c4effc1f09a5',62,'12b605b0706b49d7b50bd67675f75239','snapshots',-1,'2025-11-29 10:09:13',NULL),('2025-11-28 10:09:13.085193',NULL,'2025-11-28 10:09:13.103306',193,193,'0c582186c0ed48b5b46bde7689b3c440','31d8913b-47bc-4143-85f7-339188200826',63,'12b605b0706b49d7b50bd67675f75239','snapshot_gigabytes',-1,'2025-11-29 10:09:13',NULL),('2025-11-28 10:09:13.091997',NULL,'2025-11-28 10:09:13.103306',194,194,NULL,'cc712821-c2d7-4789-8203-c8035ae4bd41',64,'12b605b0706b49d7b50bd67675f75239','snapshots',-1,'2025-11-29 10:09:13','6d9a44e6-5425-4bc4-897b-744c603d89a3'),('2025-11-28 10:09:13.092889',NULL,'2025-11-28 10:09:13.103306',195,195,NULL,'93f6258e-5706-4edb-984e-d6b776f07950',65,'12b605b0706b49d7b50bd67675f75239','snapshot_gigabytes',-1,'2025-11-29 10:09:13','6d9a44e6-5425-4bc4-897b-744c603d89a3'),('2025-11-28 10:09:14.056284',NULL,'2025-11-28 10:09:14.072203',196,196,'571c8db1d62c42b2a968a166578b720c','04dce364-a9ec-4227-b8a4-7d768bfb7b14',21,'761c122e3fe94bb6be6f10c7921c5430','shares',-1,'2025-11-29 10:09:14',NULL),('2025-11-28 10:09:14.057291',NULL,'2025-11-28 10:09:14.072203',197,197,'571c8db1d62c42b2a968a166578b720c','2f617df5-3eeb-493b-b4f5-c7b34a4996ac',22,'761c122e3fe94bb6be6f10c7921c5430','gigabytes',-1,'2025-11-29 10:09:14',NULL),('2025-11-28 10:09:14.063624',NULL,'2025-11-28 10:09:14.072203',198,198,NULL,'9ef5f3c7-a323-4917-be97-6195b64edafa',23,'761c122e3fe94bb6be6f10c7921c5430','shares',-1,'2025-11-29 10:09:14','af507655-39b7-440e-b343-057f120fe78f'),('2025-11-28 10:09:14.064241',NULL,'2025-11-28 10:09:14.072203',199,199,NULL,'78ba7676-31dc-4991-a746-00cfc7478e9f',24,'761c122e3fe94bb6be6f10c7921c5430','gigabytes',-1,'2025-11-29 10:09:14','af507655-39b7-440e-b343-057f120fe78f'),('2025-11-28 10:09:16.304205',NULL,'2025-11-28 10:09:16.325883',200,200,'0c582186c0ed48b5b46bde7689b3c440','4e4408eb-ab4a-4f57-9edd-6290dcd90cab',62,'12b605b0706b49d7b50bd67675f75239','snapshots',-1,'2025-11-29 10:09:16',NULL),('2025-11-28 10:09:16.304877',NULL,'2025-11-28 10:09:16.325883',201,201,'0c582186c0ed48b5b46bde7689b3c440','d0a80d17-62f4-4314-8eeb-52816872177a',63,'12b605b0706b49d7b50bd67675f75239','snapshot_gigabytes',-1,'2025-11-29 10:09:16',NULL),('2025-11-28 10:09:16.311921',NULL,'2025-11-28 10:09:16.325883',202,202,NULL,'f8034878-8bfa-4a57-af5a-4168c2377a95',64,'12b605b0706b49d7b50bd67675f75239','snapshots',-1,'2025-11-29 10:09:16','6d9a44e6-5425-4bc4-897b-744c603d89a3'),('2025-11-28 10:09:16.312786',NULL,'2025-11-28 10:09:16.325883',203,203,NULL,'3dade49d-90f6-4c1d-93d2-a73ab5a55271',65,'12b605b0706b49d7b50bd67675f75239','snapshot_gigabytes',-1,'2025-11-29 10:09:16','6d9a44e6-5425-4bc4-897b-744c603d89a3'),('2025-11-28 10:09:19.224803',NULL,'2025-11-28 10:09:19.265696',204,204,'04b45146b0ab498fbc11c9fb27eaa424','04e165c9-335c-42ac-bd69-2fd8ee053e14',66,'56c91df0287e4974b45f4ed0b63d771d','shares',-1,'2025-11-29 10:09:19',NULL),('2025-11-28 10:09:19.225730',NULL,'2025-11-28 10:09:19.265696',205,205,'04b45146b0ab498fbc11c9fb27eaa424','d5b66ff9-8a2c-4ceb-ae7f-c809b58cfc73',67,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',-1,'2025-11-29 10:09:19',NULL),('2025-11-28 10:09:19.239243',NULL,'2025-11-28 10:09:19.265696',206,206,NULL,'502877d5-b4ad-49b1-aac5-d0e77b8c22eb',68,'56c91df0287e4974b45f4ed0b63d771d','shares',-1,'2025-11-29 10:09:19','92b5d720-8b2c-44a0-8b87-437bdeefaf18'),('2025-11-28 10:09:19.244244',NULL,'2025-11-28 10:09:19.265696',207,207,NULL,'759446d7-27a1-4a22-8b1c-ab7d5b1fc663',69,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',-1,'2025-11-29 10:09:19','92b5d720-8b2c-44a0-8b87-437bdeefaf18'),('2025-11-28 10:09:19.472411',NULL,'2025-11-28 10:09:19.524962',208,208,'04b45146b0ab498fbc11c9fb27eaa424','459923ff-9af5-48e6-be81-5b0c8373c939',66,'56c91df0287e4974b45f4ed0b63d771d','shares',1,'2025-11-29 10:09:19',NULL),('2025-11-28 10:09:19.473875',NULL,'2025-11-28 10:09:19.524962',209,209,'04b45146b0ab498fbc11c9fb27eaa424','5d84a2a3-a11f-4140-ab1e-7981e69c32ee',67,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',1,'2025-11-29 10:09:19',NULL),('2025-11-28 10:09:19.493521',NULL,'2025-11-28 10:09:19.524962',210,210,NULL,'8bdcdfbc-10ae-4e3b-8922-09314ac517b7',71,'56c91df0287e4974b45f4ed0b63d771d','shares',1,'2025-11-29 10:09:19','8c13b500-b5e4-40a8-bf38-ed79df3a09e4'),('2025-11-28 10:09:19.494927',NULL,'2025-11-28 10:09:19.524962',211,211,NULL,'942d735b-51f4-4e50-a1a0-a334a4be74ea',70,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',1,'2025-11-29 10:09:19','8c13b500-b5e4-40a8-bf38-ed79df3a09e4'),('2025-11-28 10:09:19.664260',NULL,'2025-11-28 10:09:19.685743',212,212,'0c582186c0ed48b5b46bde7689b3c440','735f1ad7-1032-4558-bec4-f4718223e25d',58,'12b605b0706b49d7b50bd67675f75239','shares',-1,'2025-11-29 10:09:19',NULL),('2025-11-28 10:09:19.665932',NULL,'2025-11-28 10:09:19.685743',213,213,'0c582186c0ed48b5b46bde7689b3c440','07931996-1efb-43f1-bff4-64d32a70ad99',59,'12b605b0706b49d7b50bd67675f75239','gigabytes',-1,'2025-11-29 10:09:19',NULL),('2025-11-28 10:09:19.677356',NULL,'2025-11-28 10:09:19.685743',214,214,NULL,'96f67971-c6b0-4d0a-aafb-91263fdfaf42',60,'12b605b0706b49d7b50bd67675f75239','shares',-1,'2025-11-29 10:09:19','6d9a44e6-5425-4bc4-897b-744c603d89a3'),('2025-11-28 10:09:19.678248',NULL,'2025-11-28 10:09:19.685743',215,215,NULL,'6f9eb1de-8dcb-4f55-a97c-95c94376a07f',61,'12b605b0706b49d7b50bd67675f75239','gigabytes',-1,'2025-11-29 10:09:19','6d9a44e6-5425-4bc4-897b-744c603d89a3'),('2025-11-28 10:09:22.935458',NULL,'2025-11-28 10:09:22.950685',216,216,'04b45146b0ab498fbc11c9fb27eaa424','e9d46bec-f697-4aae-9323-68306726a346',66,'56c91df0287e4974b45f4ed0b63d771d','shares',-1,'2025-11-29 10:09:22',NULL),('2025-11-28 10:09:22.936184',NULL,'2025-11-28 10:09:22.950685',217,217,'04b45146b0ab498fbc11c9fb27eaa424','87ff74ba-ba4c-4d38-84f8-e2bfba5f5e38',67,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',-1,'2025-11-29 10:09:22',NULL),('2025-11-28 10:09:22.943251',NULL,'2025-11-28 10:09:22.950685',218,218,NULL,'f352989e-77d4-4a6d-bbda-c32ca20cfcf6',71,'56c91df0287e4974b45f4ed0b63d771d','shares',-1,'2025-11-29 10:09:22','8c13b500-b5e4-40a8-bf38-ed79df3a09e4'),('2025-11-28 10:09:22.944032',NULL,'2025-11-28 10:09:22.950685',219,219,NULL,'657827eb-4a85-44ea-9c27-169918fa6587',70,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',-1,'2025-11-29 10:09:22','8c13b500-b5e4-40a8-bf38-ed79df3a09e4'),('2025-11-28 10:09:23.029985',NULL,'2025-11-28 10:09:23.061968',220,220,'04b45146b0ab498fbc11c9fb27eaa424','ae3290d3-1979-4783-aa76-e8552f30fcf5',66,'56c91df0287e4974b45f4ed0b63d771d','shares',1,'2025-11-29 10:09:23',NULL),('2025-11-28 10:09:23.031354',NULL,'2025-11-28 10:09:23.061968',221,221,'04b45146b0ab498fbc11c9fb27eaa424','b371b801-acde-46d7-8387-8302f6bda7e7',67,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',1,'2025-11-29 10:09:23',NULL),('2025-11-28 10:09:23.042242',NULL,'2025-11-28 10:09:23.061968',222,222,NULL,'c482fe18-8e33-4b7c-9c82-cbed27e54b25',73,'56c91df0287e4974b45f4ed0b63d771d','shares',1,'2025-11-29 10:09:23','9a9b0b49-6080-4623-9106-4d195108be5a'),('2025-11-28 10:09:23.043345',NULL,'2025-11-28 10:09:23.061968',223,223,NULL,'b0f9e4ee-f2f5-488b-9a0e-c9670452af5b',72,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',1,'2025-11-29 10:09:23','9a9b0b49-6080-4623-9106-4d195108be5a'),('2025-11-28 10:09:26.279366',NULL,'2025-11-28 10:09:26.306148',224,224,'04b45146b0ab498fbc11c9fb27eaa424','fcda8465-05e7-4242-af8e-d9f20d5a4714',66,'56c91df0287e4974b45f4ed0b63d771d','shares',1,'2025-11-29 10:09:26',NULL),('2025-11-28 10:09:26.280437',NULL,'2025-11-28 10:09:26.306148',225,225,'04b45146b0ab498fbc11c9fb27eaa424','1b4f3027-b92a-4293-b153-ba1f033970e6',67,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',1,'2025-11-29 10:09:26',NULL),('2025-11-28 10:09:26.289699',NULL,'2025-11-28 10:09:26.306148',226,226,NULL,'264165d7-a6cc-450b-9777-6c463dcffa17',75,'56c91df0287e4974b45f4ed0b63d771d','shares',1,'2025-11-29 10:09:26','b83d9f61-20cf-4020-8ef9-0f4237cb3bb5'),('2025-11-28 10:09:26.290644',NULL,'2025-11-28 10:09:26.306148',227,227,NULL,'4619828b-11eb-4ba5-a00d-f162cbf4e99f',74,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',1,'2025-11-29 10:09:26','b83d9f61-20cf-4020-8ef9-0f4237cb3bb5'),('2025-11-28 10:09:29.544362',NULL,'2025-11-28 10:09:29.582162',228,228,'8ea5668b7da944e3889979a0a4ebd864','23fc4dda-a87e-49c8-98e8-f23d21b2e95a',77,'9ae469011da74f5abbce684003b3bb7b','shares',1,'2025-11-29 10:09:29',NULL),('2025-11-28 10:09:29.547454',NULL,'2025-11-28 10:09:29.582162',229,229,'8ea5668b7da944e3889979a0a4ebd864','2a678464-8e4d-4e03-8642-07dba1a78f64',76,'9ae469011da74f5abbce684003b3bb7b','gigabytes',1,'2025-11-29 10:09:29',NULL),('2025-11-28 10:09:29.558236',NULL,'2025-11-28 10:09:29.582162',230,230,NULL,'fafe784c-d9a7-4680-9533-88a0e45ff49f',79,'9ae469011da74f5abbce684003b3bb7b','shares',1,'2025-11-29 10:09:29','084f8ef2-4e4e-4a86-9926-577e24d8a08e'),('2025-11-28 10:09:29.559952',NULL,'2025-11-28 10:09:29.582162',231,231,NULL,'499c4189-243b-474e-900c-a76f04f24975',78,'9ae469011da74f5abbce684003b3bb7b','gigabytes',1,'2025-11-29 10:09:29','084f8ef2-4e4e-4a86-9926-577e24d8a08e'),('2025-11-28 10:09:29.933957',NULL,'2025-11-28 10:09:29.951308',232,232,'04b45146b0ab498fbc11c9fb27eaa424','12206836-3d5a-46ef-84f8-eb5d0fb8fa00',66,'56c91df0287e4974b45f4ed0b63d771d','shares',-1,'2025-11-29 10:09:29',NULL),('2025-11-28 10:09:29.934696',NULL,'2025-11-28 10:09:29.951308',233,233,'04b45146b0ab498fbc11c9fb27eaa424','f0d09a8a-ec42-4a4e-b8ac-cb0ce30ad941',67,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',-1,'2025-11-29 10:09:29',NULL),('2025-11-28 10:09:29.942913',NULL,'2025-11-28 10:09:29.951308',234,234,NULL,'b5ac4058-8b25-4568-a297-e23d10152ab3',75,'56c91df0287e4974b45f4ed0b63d771d','shares',-1,'2025-11-29 10:09:29','b83d9f61-20cf-4020-8ef9-0f4237cb3bb5'),('2025-11-28 10:09:29.943623',NULL,'2025-11-28 10:09:29.951308',235,235,NULL,'7ec35979-599c-407a-85b2-dacfd5842c9c',74,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',-1,'2025-11-29 10:09:29','b83d9f61-20cf-4020-8ef9-0f4237cb3bb5'),('2025-11-28 10:09:30.368681',NULL,'2025-11-28 10:09:30.393240',236,236,'04b45146b0ab498fbc11c9fb27eaa424','1b93706f-3c21-48da-991a-8df8f9a66dfa',66,'56c91df0287e4974b45f4ed0b63d771d','shares',-1,'2025-11-29 10:09:30',NULL),('2025-11-28 10:09:30.370568',NULL,'2025-11-28 10:09:30.393240',237,237,'04b45146b0ab498fbc11c9fb27eaa424','395ebd6d-4b1b-4078-8323-99583fabb73e',67,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',-1,'2025-11-29 10:09:30',NULL),('2025-11-28 10:09:30.379319',NULL,'2025-11-28 10:09:30.393240',238,238,NULL,'fd132850-c769-492a-9ee8-a06540484972',73,'56c91df0287e4974b45f4ed0b63d771d','shares',-1,'2025-11-29 10:09:30','9a9b0b49-6080-4623-9106-4d195108be5a'),('2025-11-28 10:09:30.380397',NULL,'2025-11-28 10:09:30.393240',239,239,NULL,'db2ab5ca-7988-4529-a2cf-ec9c009bffac',72,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',-1,'2025-11-29 10:09:30','9a9b0b49-6080-4623-9106-4d195108be5a'),('2025-11-28 10:09:30.488595',NULL,'2025-11-28 10:09:30.515426',240,240,'04b45146b0ab498fbc11c9fb27eaa424','23de5317-31ad-41c0-a333-e820eeb82f4a',66,'56c91df0287e4974b45f4ed0b63d771d','shares',1,'2025-11-29 10:09:30',NULL),('2025-11-28 10:09:30.489687',NULL,'2025-11-28 10:09:30.515426',241,241,'04b45146b0ab498fbc11c9fb27eaa424','beb4469c-2e9b-416d-8f11-33bf7fe7879d',67,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',1,'2025-11-29 10:09:30',NULL),('2025-11-28 10:09:30.497538',NULL,'2025-11-28 10:09:30.515426',242,242,NULL,'baa115d0-29ae-401a-9733-b15d7ac0523c',80,'56c91df0287e4974b45f4ed0b63d771d','shares',1,'2025-11-29 10:09:30','a6cf2de5-f03d-4685-96db-213c06469eaa'),('2025-11-28 10:09:30.498440',NULL,'2025-11-28 10:09:30.515426',243,243,NULL,'1d244729-0bc2-4129-914c-4764dc8ea1fe',81,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',1,'2025-11-29 10:09:30','a6cf2de5-f03d-4685-96db-213c06469eaa'),('2025-11-28 10:09:30.670448',NULL,'2025-11-28 10:09:30.706107',244,244,'d695349bee344dfbbced1de2bcceb2ed','e1f86122-88a4-4231-abd0-fc3380d2fad3',82,'2cc8a146763846fabfe8e260b70f3971','shares',1,'2025-11-29 10:09:30',NULL),('2025-11-28 10:09:30.671785',NULL,'2025-11-28 10:09:30.706107',245,245,'d695349bee344dfbbced1de2bcceb2ed','779573b2-07b5-45a4-9bd6-5fafeb70c350',83,'2cc8a146763846fabfe8e260b70f3971','gigabytes',1,'2025-11-29 10:09:30',NULL),('2025-11-28 10:09:30.681004',NULL,'2025-11-28 10:09:30.706107',246,246,NULL,'10379877-6cef-4500-831b-9e479d88a033',84,'2cc8a146763846fabfe8e260b70f3971','shares',1,'2025-11-29 10:09:30','0ab6e61c-00e8-4c14-a175-ff57dd99da97'),('2025-11-28 10:09:30.682030',NULL,'2025-11-28 10:09:30.706107',247,247,NULL,'04e96d9f-8579-4c97-944f-446f33c8e53c',85,'2cc8a146763846fabfe8e260b70f3971','gigabytes',1,'2025-11-29 10:09:30','0ab6e61c-00e8-4c14-a175-ff57dd99da97'),('2025-11-28 10:09:32.957011',NULL,'2025-11-28 10:09:33.063585',248,248,'8ea5668b7da944e3889979a0a4ebd864','fb66ba09-8a97-4297-a50c-cd3f2f7d8b2b',86,'9ae469011da74f5abbce684003b3bb7b','snapshots',1,'2025-11-29 10:09:32',NULL),('2025-11-28 10:09:32.961902',NULL,'2025-11-28 10:09:33.063585',249,249,'8ea5668b7da944e3889979a0a4ebd864','fd27f793-aa10-4eac-84ba-2a6e85c279c6',87,'9ae469011da74f5abbce684003b3bb7b','snapshot_gigabytes',1,'2025-11-29 10:09:32',NULL),('2025-11-28 10:09:32.974592',NULL,'2025-11-28 10:09:33.063585',250,250,NULL,'1f165fef-4754-4ba2-97aa-ed4b3e69884e',88,'9ae469011da74f5abbce684003b3bb7b','snapshots',1,'2025-11-29 10:09:32','084f8ef2-4e4e-4a86-9926-577e24d8a08e'),('2025-11-28 10:09:32.975936',NULL,'2025-11-28 10:09:33.063585',251,251,NULL,'cd0de4b8-3672-4a95-a924-943b9582f382',89,'9ae469011da74f5abbce684003b3bb7b','snapshot_gigabytes',1,'2025-11-29 10:09:32','084f8ef2-4e4e-4a86-9926-577e24d8a08e'),('2025-11-28 10:09:33.748276',NULL,'2025-11-28 10:09:33.787709',252,252,'04b45146b0ab498fbc11c9fb27eaa424','7feb5c10-4542-465d-b68f-46a3550736e1',66,'56c91df0287e4974b45f4ed0b63d771d','shares',1,'2025-11-29 10:09:33',NULL),('2025-11-28 10:09:33.749451',NULL,'2025-11-28 10:09:33.787709',253,253,'04b45146b0ab498fbc11c9fb27eaa424','7506651b-b669-41cb-9389-0d6aaedfaedd',67,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',1,'2025-11-29 10:09:33',NULL),('2025-11-28 10:09:33.765943',NULL,'2025-11-28 10:09:33.787709',254,254,NULL,'f1b133dd-3121-4f3f-bb6c-0d8a47716b0b',90,'56c91df0287e4974b45f4ed0b63d771d','shares',1,'2025-11-29 10:09:33','de7477ef-93cf-4399-8f54-c6779de5c085'),('2025-11-28 10:09:33.767029',NULL,'2025-11-28 10:09:33.787709',255,255,NULL,'562291c1-9049-46ac-87d6-62e66fae1331',91,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',1,'2025-11-29 10:09:33','de7477ef-93cf-4399-8f54-c6779de5c085'),('2025-11-28 10:09:34.145413',NULL,'2025-11-28 10:09:34.160311',256,256,'d695349bee344dfbbced1de2bcceb2ed','6ea974c8-6400-4998-9912-d13272e17a19',82,'2cc8a146763846fabfe8e260b70f3971','shares',-1,'2025-11-29 10:09:34',NULL),('2025-11-28 10:09:34.146130',NULL,'2025-11-28 10:09:34.160311',257,257,'d695349bee344dfbbced1de2bcceb2ed','6744c391-a356-4047-baf8-5ff309da2143',83,'2cc8a146763846fabfe8e260b70f3971','gigabytes',-1,'2025-11-29 10:09:34',NULL),('2025-11-28 10:09:34.153211',NULL,'2025-11-28 10:09:34.160311',258,258,NULL,'167b7527-5273-4800-8fb6-d044611fa768',84,'2cc8a146763846fabfe8e260b70f3971','shares',-1,'2025-11-29 10:09:34','0ab6e61c-00e8-4c14-a175-ff57dd99da97'),('2025-11-28 10:09:34.153832',NULL,'2025-11-28 10:09:34.160311',259,259,NULL,'0c5ea724-91ee-4e7e-aa8b-83d474394ae5',85,'2cc8a146763846fabfe8e260b70f3971','gigabytes',-1,'2025-11-29 10:09:34','0ab6e61c-00e8-4c14-a175-ff57dd99da97'),('2025-11-28 10:09:34.268231',NULL,'2025-11-28 10:09:34.319243',260,260,'d695349bee344dfbbced1de2bcceb2ed','dad90415-a096-4120-ab37-8a7817867362',82,'2cc8a146763846fabfe8e260b70f3971','shares',1,'2025-11-29 10:09:34',NULL),('2025-11-28 10:09:34.269543',NULL,'2025-11-28 10:09:34.319243',261,261,'d695349bee344dfbbced1de2bcceb2ed','06e1233c-4557-4dfd-925f-4798fc9b13fd',83,'2cc8a146763846fabfe8e260b70f3971','gigabytes',1,'2025-11-29 10:09:34',NULL),('2025-11-28 10:09:34.291694',NULL,'2025-11-28 10:09:34.319243',262,262,NULL,'7413e208-0b58-47f3-94d6-3c5714babe45',93,'2cc8a146763846fabfe8e260b70f3971','shares',1,'2025-11-29 10:09:34','61dacce4-f310-4d57-871f-5a8e0d73a9d8'),('2025-11-28 10:09:34.293386',NULL,'2025-11-28 10:09:34.319243',263,263,NULL,'eeebfe40-4fb5-4058-bb35-394ea3da6bfb',92,'2cc8a146763846fabfe8e260b70f3971','gigabytes',1,'2025-11-29 10:09:34','61dacce4-f310-4d57-871f-5a8e0d73a9d8'),('2025-11-28 10:09:35.210240',NULL,'2025-11-28 10:09:35.257976',264,264,'d73cf1135d49436897cbfb435039e1ba','57303f34-d392-4680-bd8f-5a535c5da79f',94,'140d992a075d4f1886445e3c1f7f4e58','shares',1,'2025-11-29 10:09:35',NULL),('2025-11-28 10:09:35.211946',NULL,'2025-11-28 10:09:35.257976',265,265,'d73cf1135d49436897cbfb435039e1ba','d98a7dc2-2cd4-4704-b148-834db7ca48b5',95,'140d992a075d4f1886445e3c1f7f4e58','gigabytes',1,'2025-11-29 10:09:35',NULL),('2025-11-28 10:09:35.231548',NULL,'2025-11-28 10:09:35.257976',266,266,NULL,'9634cd07-d4e9-417c-81e6-6ee5556e24f3',96,'140d992a075d4f1886445e3c1f7f4e58','shares',1,'2025-11-29 10:09:35','db8a169e-f049-4a4a-ba40-e83a93f51c46'),('2025-11-28 10:09:35.232805',NULL,'2025-11-28 10:09:35.257976',267,267,NULL,'48795577-4445-4563-ac13-5be34fe93bfd',97,'140d992a075d4f1886445e3c1f7f4e58','gigabytes',1,'2025-11-29 10:09:35','db8a169e-f049-4a4a-ba40-e83a93f51c46'),('2025-11-28 10:09:36.734822',NULL,'2025-11-28 10:09:36.750488',268,268,'8ea5668b7da944e3889979a0a4ebd864','8e51176d-1e2e-48ec-92a4-2abeb7402e50',86,'9ae469011da74f5abbce684003b3bb7b','snapshots',-1,'2025-11-29 10:09:36',NULL),('2025-11-28 10:09:36.735634',NULL,'2025-11-28 10:09:36.750488',269,269,'8ea5668b7da944e3889979a0a4ebd864','c4a80d02-8f9d-492a-b152-951f038b5ef4',87,'9ae469011da74f5abbce684003b3bb7b','snapshot_gigabytes',-1,'2025-11-29 10:09:36',NULL),('2025-11-28 10:09:36.741036',NULL,'2025-11-28 10:09:36.750488',270,270,NULL,'67458efa-ee24-4838-a3b8-7dd31a0e44af',88,'9ae469011da74f5abbce684003b3bb7b','snapshots',-1,'2025-11-29 10:09:36','084f8ef2-4e4e-4a86-9926-577e24d8a08e'),('2025-11-28 10:09:36.741770',NULL,'2025-11-28 10:09:36.750488',271,271,NULL,'93c4f475-a1ec-4a02-95ee-f92567562bd3',89,'9ae469011da74f5abbce684003b3bb7b','snapshot_gigabytes',-1,'2025-11-29 10:09:36','084f8ef2-4e4e-4a86-9926-577e24d8a08e'),('2025-11-28 10:09:37.707049',NULL,'2025-11-28 10:09:37.721863',272,272,'d695349bee344dfbbced1de2bcceb2ed','584bfa03-3dbe-4e14-aa45-09fd627a13b2',82,'2cc8a146763846fabfe8e260b70f3971','shares',-1,'2025-11-29 10:09:37',NULL),('2025-11-28 10:09:37.707882',NULL,'2025-11-28 10:09:37.721863',273,273,'d695349bee344dfbbced1de2bcceb2ed','4bf042d8-afe9-4d37-af88-e1b679c9f4fd',83,'2cc8a146763846fabfe8e260b70f3971','gigabytes',-1,'2025-11-29 10:09:37',NULL),('2025-11-28 10:09:37.713697',NULL,'2025-11-28 10:09:37.721863',274,274,NULL,'7803adc0-40b0-455c-8ae8-81b0df8995b8',93,'2cc8a146763846fabfe8e260b70f3971','shares',-1,'2025-11-29 10:09:37','61dacce4-f310-4d57-871f-5a8e0d73a9d8'),('2025-11-28 10:09:37.714539',NULL,'2025-11-28 10:09:37.721863',275,275,NULL,'ded0b2e9-be4d-402c-a69c-9b45d88e9871',92,'2cc8a146763846fabfe8e260b70f3971','gigabytes',-1,'2025-11-29 10:09:37','61dacce4-f310-4d57-871f-5a8e0d73a9d8'),('2025-11-28 10:09:37.845267',NULL,'2025-11-28 10:09:37.886011',276,276,'d695349bee344dfbbced1de2bcceb2ed','b5cfb095-7e5b-4401-9128-7d5b32d00c1f',82,'2cc8a146763846fabfe8e260b70f3971','shares',1,'2025-11-29 10:09:37',NULL),('2025-11-28 10:09:37.847250',NULL,'2025-11-28 10:09:37.886011',277,277,'d695349bee344dfbbced1de2bcceb2ed','303c1689-13e0-4a0c-b9db-9d1d5d22ea2f',83,'2cc8a146763846fabfe8e260b70f3971','gigabytes',1,'2025-11-29 10:09:37',NULL),('2025-11-28 10:09:37.861182',NULL,'2025-11-28 10:09:37.886011',278,278,NULL,'c1e3356a-ff13-4015-a53a-06cc2f889203',98,'2cc8a146763846fabfe8e260b70f3971','shares',1,'2025-11-29 10:09:37','0b2af550-033f-43f7-8dc6-2cba6a6a0d41'),('2025-11-28 10:09:37.862793',NULL,'2025-11-28 10:09:37.886011',279,279,NULL,'c16ad9ba-7349-4b26-8588-1d892b8cfe2d',99,'2cc8a146763846fabfe8e260b70f3971','gigabytes',1,'2025-11-29 10:09:37','0b2af550-033f-43f7-8dc6-2cba6a6a0d41'),('2025-11-28 10:09:38.676713',NULL,'2025-11-28 10:09:38.710945',280,280,'c6c04037ddce4b068df4a5875ae176f6','12476eb7-ab4b-424b-a010-bb5a0985fbb7',100,'410e335578834258b6cf71ca3ea642ab','shares',1,'2025-11-29 10:09:38',NULL),('2025-11-28 10:09:38.677751',NULL,'2025-11-28 10:09:38.710945',281,281,'c6c04037ddce4b068df4a5875ae176f6','c70c87d8-fddd-48a9-b97e-e3e5d3a0ff66',101,'410e335578834258b6cf71ca3ea642ab','gigabytes',1,'2025-11-29 10:09:38',NULL),('2025-11-28 10:09:38.689147',NULL,'2025-11-28 10:09:38.710945',282,282,NULL,'f28746a1-ed6b-447e-9ad4-c19bd8d90cb1',102,'410e335578834258b6cf71ca3ea642ab','shares',1,'2025-11-29 10:09:38','1017739b-5ffb-4329-bcab-62c8a3bbd78b'),('2025-11-28 10:09:38.690204',NULL,'2025-11-28 10:09:38.710945',283,283,NULL,'61e8080c-b9ce-4c24-b4c7-1b6a024363a1',103,'410e335578834258b6cf71ca3ea642ab','gigabytes',1,'2025-11-29 10:09:38','1017739b-5ffb-4329-bcab-62c8a3bbd78b'),('2025-11-28 10:09:39.756642',NULL,'2025-11-28 10:09:39.789759',284,284,'8ea5668b7da944e3889979a0a4ebd864','30cdc149-af18-4e16-a497-e3c7b9f3e8bd',77,'9ae469011da74f5abbce684003b3bb7b','shares',-1,'2025-11-29 10:09:39',NULL),('2025-11-28 10:09:39.758507',NULL,'2025-11-28 10:09:39.789759',285,285,'8ea5668b7da944e3889979a0a4ebd864','40bb61bb-5835-4f65-84e8-dfd57d284fb3',76,'9ae469011da74f5abbce684003b3bb7b','gigabytes',-1,'2025-11-29 10:09:39',NULL),('2025-11-28 10:09:39.769851',NULL,'2025-11-28 10:09:39.789759',286,286,NULL,'a371aa44-09a0-43ed-a32d-b32d7169655e',79,'9ae469011da74f5abbce684003b3bb7b','shares',-1,'2025-11-29 10:09:39','084f8ef2-4e4e-4a86-9926-577e24d8a08e'),('2025-11-28 10:09:39.772802',NULL,'2025-11-28 10:09:39.789759',287,287,NULL,'e78bad03-d990-4375-8f72-2a4c78e89780',78,'9ae469011da74f5abbce684003b3bb7b','gigabytes',-1,'2025-11-29 10:09:39','084f8ef2-4e4e-4a86-9926-577e24d8a08e'),('2025-11-28 10:09:40.069974',NULL,'2025-11-28 10:09:40.104513',288,288,'04b45146b0ab498fbc11c9fb27eaa424','daeccaaa-cb73-415c-a78b-0e6942de14a0',66,'56c91df0287e4974b45f4ed0b63d771d','shares',1,'2025-11-29 10:09:40',NULL),('2025-11-28 10:09:40.071624',NULL,'2025-11-28 10:09:40.104513',289,289,'04b45146b0ab498fbc11c9fb27eaa424','de3fcb21-f98a-46b5-9341-44392c4f42e5',67,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',1,'2025-11-29 10:09:40',NULL),('2025-11-28 10:09:40.084701',NULL,'2025-11-28 10:09:40.104513',290,290,NULL,'726e1ac6-fcd3-4858-9671-c467244ef66d',105,'56c91df0287e4974b45f4ed0b63d771d','shares',1,'2025-11-29 10:09:40','192f6d83-e644-4b10-b095-74d844f8f9a3'),('2025-11-28 10:09:40.085677',NULL,'2025-11-28 10:09:40.104513',291,291,NULL,'e39f8a6c-14fe-4a7e-8220-2e130e2676e2',104,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',1,'2025-11-29 10:09:40','192f6d83-e644-4b10-b095-74d844f8f9a3'),('2025-11-28 10:09:41.265933',NULL,'2025-11-28 10:09:41.280054',292,292,'d695349bee344dfbbced1de2bcceb2ed','9603f08a-c364-40b6-850a-bbc83c7233ff',82,'2cc8a146763846fabfe8e260b70f3971','shares',-1,'2025-11-29 10:09:41',NULL),('2025-11-28 10:09:41.266624',NULL,'2025-11-28 10:09:41.280054',293,293,'d695349bee344dfbbced1de2bcceb2ed','4171cc54-0f40-49a6-934f-5e54b459b14c',83,'2cc8a146763846fabfe8e260b70f3971','gigabytes',-1,'2025-11-29 10:09:41',NULL),('2025-11-28 10:09:41.272423',NULL,'2025-11-28 10:09:41.280054',294,294,NULL,'d7f3392f-7456-4fa3-b81c-afd8970921af',98,'2cc8a146763846fabfe8e260b70f3971','shares',-1,'2025-11-29 10:09:41','0b2af550-033f-43f7-8dc6-2cba6a6a0d41'),('2025-11-28 10:09:41.273279',NULL,'2025-11-28 10:09:41.280054',295,295,NULL,'97aeedfb-9680-4b7a-9e42-163516732765',99,'2cc8a146763846fabfe8e260b70f3971','gigabytes',-1,'2025-11-29 10:09:41','0b2af550-033f-43f7-8dc6-2cba6a6a0d41'),('2025-11-28 10:09:41.346208',NULL,'2025-11-28 10:09:41.387198',296,296,'d695349bee344dfbbced1de2bcceb2ed','300b76b3-86a4-482b-bdbf-d92fca8ca618',82,'2cc8a146763846fabfe8e260b70f3971','shares',1,'2025-11-29 10:09:41',NULL),('2025-11-28 10:09:41.347484',NULL,'2025-11-28 10:09:41.387198',297,297,'d695349bee344dfbbced1de2bcceb2ed','191dc99b-647d-4987-965e-6d8048b2fa2c',83,'2cc8a146763846fabfe8e260b70f3971','gigabytes',1,'2025-11-29 10:09:41',NULL),('2025-11-28 10:09:41.356757',NULL,'2025-11-28 10:09:41.387198',298,298,NULL,'f46372ad-70eb-4515-b21f-18635bd48e25',107,'2cc8a146763846fabfe8e260b70f3971','shares',1,'2025-11-29 10:09:41','0a11ce91-4605-4683-9e66-2e39e2023c84'),('2025-11-28 10:09:41.358135',NULL,'2025-11-28 10:09:41.387198',299,299,NULL,'c7555a12-5eb6-40db-80aa-83e3ed27a0f4',106,'2cc8a146763846fabfe8e260b70f3971','gigabytes',1,'2025-11-29 10:09:41','0a11ce91-4605-4683-9e66-2e39e2023c84'),('2025-11-28 10:09:42.397641',NULL,'2025-11-28 10:09:42.420970',300,300,'d73cf1135d49436897cbfb435039e1ba','69fbf00a-c064-45c6-9a8e-5741cd622889',94,'140d992a075d4f1886445e3c1f7f4e58','shares',-1,'2025-11-29 10:09:42',NULL),('2025-11-28 10:09:42.398572',NULL,'2025-11-28 10:09:42.420970',301,301,'d73cf1135d49436897cbfb435039e1ba','cea4bbc2-cfb6-458f-94a3-1bfed877d4d1',95,'140d992a075d4f1886445e3c1f7f4e58','gigabytes',-1,'2025-11-29 10:09:42',NULL),('2025-11-28 10:09:42.405623',NULL,'2025-11-28 10:09:42.420970',302,302,NULL,'2984864e-40fe-4586-8037-ecd85ef6db14',96,'140d992a075d4f1886445e3c1f7f4e58','shares',-1,'2025-11-29 10:09:42','db8a169e-f049-4a4a-ba40-e83a93f51c46'),('2025-11-28 10:09:42.407693',NULL,'2025-11-28 10:09:42.420970',303,303,NULL,'06bed800-bff2-44f4-be5c-fa40308af839',97,'140d992a075d4f1886445e3c1f7f4e58','gigabytes',-1,'2025-11-29 10:09:42','db8a169e-f049-4a4a-ba40-e83a93f51c46'),('2025-11-28 10:09:42.741577',NULL,'2025-11-28 10:09:42.791145',304,304,'8ea5668b7da944e3889979a0a4ebd864','6f098b6e-b32e-4ca2-951e-a480dd0e01eb',77,'9ae469011da74f5abbce684003b3bb7b','shares',1,'2025-11-29 10:09:42',NULL),('2025-11-28 10:09:42.743158',NULL,'2025-11-28 10:09:42.791145',305,305,'8ea5668b7da944e3889979a0a4ebd864','ea53d52f-cbc2-4e69-9162-181eb9aa5554',76,'9ae469011da74f5abbce684003b3bb7b','gigabytes',1,'2025-11-29 10:09:42',NULL),('2025-11-28 10:09:42.761791',NULL,'2025-11-28 10:09:42.791145',306,306,NULL,'932d7c37-dcbf-489f-9485-6d8ee3c8dddd',108,'9ae469011da74f5abbce684003b3bb7b','shares',1,'2025-11-29 10:09:42','649540ff-edd6-432a-980c-dffae9dab5ec'),('2025-11-28 10:09:42.763444',NULL,'2025-11-28 10:09:42.791145',307,307,NULL,'5029cf6d-2a05-41f9-8c55-9c3baf5f2a16',109,'9ae469011da74f5abbce684003b3bb7b','gigabytes',1,'2025-11-29 10:09:42','649540ff-edd6-432a-980c-dffae9dab5ec'),('2025-11-28 10:09:43.437798',NULL,'2025-11-28 10:09:43.450931',308,308,'04b45146b0ab498fbc11c9fb27eaa424','23296ef7-488e-404f-abdd-acc07bf00253',66,'56c91df0287e4974b45f4ed0b63d771d','shares',-1,'2025-11-29 10:09:43',NULL),('2025-11-28 10:09:43.438618',NULL,'2025-11-28 10:09:43.450931',309,309,'04b45146b0ab498fbc11c9fb27eaa424','c048b1e7-f02d-493e-ba7a-9e9ed5b1c780',67,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',-1,'2025-11-29 10:09:43',NULL),('2025-11-28 10:09:43.444275',NULL,'2025-11-28 10:09:43.450931',310,310,NULL,'7993297c-99d1-4c69-bbe9-580200a56eb8',105,'56c91df0287e4974b45f4ed0b63d771d','shares',-1,'2025-11-29 10:09:43','192f6d83-e644-4b10-b095-74d844f8f9a3'),('2025-11-28 10:09:43.444898',NULL,'2025-11-28 10:09:43.450931',311,311,NULL,'3c28bdd5-937b-4e2a-9467-979db90de218',104,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',-1,'2025-11-29 10:09:43','192f6d83-e644-4b10-b095-74d844f8f9a3'),('2025-11-28 10:09:43.498562',NULL,'2025-11-28 10:09:43.511162',312,312,'c6c04037ddce4b068df4a5875ae176f6','51de8298-79c2-422d-b27f-db686c10707d',100,'410e335578834258b6cf71ca3ea642ab','shares',-1,'2025-11-29 10:09:43',NULL),('2025-11-28 10:09:43.499402',NULL,'2025-11-28 10:09:43.511162',313,313,'c6c04037ddce4b068df4a5875ae176f6','c861240d-de45-47a4-b08c-c6679d36f0d8',101,'410e335578834258b6cf71ca3ea642ab','gigabytes',-1,'2025-11-29 10:09:43',NULL),('2025-11-28 10:09:43.504703',NULL,'2025-11-28 10:09:43.511162',314,314,NULL,'cf05ec3a-afcf-4c39-9acc-ac5ee6842264',102,'410e335578834258b6cf71ca3ea642ab','shares',-1,'2025-11-29 10:09:43','1017739b-5ffb-4329-bcab-62c8a3bbd78b'),('2025-11-28 10:09:43.505423',NULL,'2025-11-28 10:09:43.511162',315,315,NULL,'08875474-7f8a-49de-b4a4-36229cf12445',103,'410e335578834258b6cf71ca3ea642ab','gigabytes',-1,'2025-11-29 10:09:43','1017739b-5ffb-4329-bcab-62c8a3bbd78b'),('2025-11-28 10:09:43.624820',NULL,'2025-11-28 10:09:43.648828',316,316,'04b45146b0ab498fbc11c9fb27eaa424','c755b106-bd5b-4dda-9e89-65b1fea05ab4',66,'56c91df0287e4974b45f4ed0b63d771d','shares',-1,'2025-11-29 10:09:43',NULL),('2025-11-28 10:09:43.627296',NULL,'2025-11-28 10:09:43.648828',317,317,'04b45146b0ab498fbc11c9fb27eaa424','591ee1a1-9efa-4c86-8b50-0d4e46a6c051',67,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',-1,'2025-11-29 10:09:43',NULL),('2025-11-28 10:09:43.635806',NULL,'2025-11-28 10:09:43.648828',318,318,NULL,'254df286-9b8d-48b1-8406-7ecae37b18d6',90,'56c91df0287e4974b45f4ed0b63d771d','shares',-1,'2025-11-29 10:09:43','de7477ef-93cf-4399-8f54-c6779de5c085'),('2025-11-28 10:09:43.636709',NULL,'2025-11-28 10:09:43.648828',319,319,NULL,'0c99bbe1-c54f-4937-8858-cf4cd148e3cc',91,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',-1,'2025-11-29 10:09:43','de7477ef-93cf-4399-8f54-c6779de5c085'),('2025-11-28 10:09:43.863758',NULL,'2025-11-28 10:09:43.884492',320,320,'04b45146b0ab498fbc11c9fb27eaa424','c4628995-6788-441d-8c2e-6ad71469e8dd',66,'56c91df0287e4974b45f4ed0b63d771d','shares',-1,'2025-11-29 10:09:43',NULL),('2025-11-28 10:09:43.864421',NULL,'2025-11-28 10:09:43.884492',321,321,'04b45146b0ab498fbc11c9fb27eaa424','ac59dbf9-7e94-49fc-8fe1-bddf2ea58c87',67,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',-1,'2025-11-29 10:09:43',NULL),('2025-11-28 10:09:43.875168',NULL,'2025-11-28 10:09:43.884492',322,322,NULL,'b73d35b8-9934-4bf7-9c88-75eb0b7d486a',80,'56c91df0287e4974b45f4ed0b63d771d','shares',-1,'2025-11-29 10:09:43','a6cf2de5-f03d-4685-96db-213c06469eaa'),('2025-11-28 10:09:43.876692',NULL,'2025-11-28 10:09:43.884492',323,323,NULL,'fe158a07-3d73-4472-a5d2-36ac6c8ff21e',81,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',-1,'2025-11-29 10:09:43','a6cf2de5-f03d-4685-96db-213c06469eaa'),('2025-11-28 10:09:44.002297',NULL,'2025-11-28 10:09:44.041256',324,324,'04b45146b0ab498fbc11c9fb27eaa424','5a6b6595-2d23-4ff8-8749-02212ea8e5d3',66,'56c91df0287e4974b45f4ed0b63d771d','shares',1,'2025-11-29 10:09:43',NULL),('2025-11-28 10:09:44.005025',NULL,'2025-11-28 10:09:44.041256',325,325,'04b45146b0ab498fbc11c9fb27eaa424','f1096cb0-13e6-49c8-a8d5-fe5a519b4166',67,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',1,'2025-11-29 10:09:43',NULL),('2025-11-28 10:09:44.019056',NULL,'2025-11-28 10:09:44.041256',326,326,NULL,'6c79e8e4-c4db-47d7-9deb-b1c6301cd4bd',111,'56c91df0287e4974b45f4ed0b63d771d','shares',1,'2025-11-29 10:09:43','88ea85e2-148e-4d8d-8f52-2ace5e4a8e88'),('2025-11-28 10:09:44.020072',NULL,'2025-11-28 10:09:44.041256',327,327,NULL,'7230914c-7947-4730-8c41-a542e897650b',110,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',1,'2025-11-29 10:09:43','88ea85e2-148e-4d8d-8f52-2ace5e4a8e88'),('2025-11-28 10:09:44.742759',NULL,'2025-11-28 10:09:44.764737',328,328,'d695349bee344dfbbced1de2bcceb2ed','2307b2c0-0bc6-47dd-ad8b-f8168464b9ba',82,'2cc8a146763846fabfe8e260b70f3971','shares',-1,'2025-11-29 10:09:44',NULL),('2025-11-28 10:09:44.743803',NULL,'2025-11-28 10:09:44.764737',329,329,'d695349bee344dfbbced1de2bcceb2ed','3ffe93a4-2b07-4a5e-bdec-6b689aa92ea5',83,'2cc8a146763846fabfe8e260b70f3971','gigabytes',-1,'2025-11-29 10:09:44',NULL),('2025-11-28 10:09:44.755514',NULL,'2025-11-28 10:09:44.764737',330,330,NULL,'ef8b8420-9eb1-4a62-8a2f-76364bcfccd3',107,'2cc8a146763846fabfe8e260b70f3971','shares',-1,'2025-11-29 10:09:44','0a11ce91-4605-4683-9e66-2e39e2023c84'),('2025-11-28 10:09:44.756307',NULL,'2025-11-28 10:09:44.764737',331,331,NULL,'48c17428-c0bb-4811-9436-eed79af1c83a',106,'2cc8a146763846fabfe8e260b70f3971','gigabytes',-1,'2025-11-29 10:09:44','0a11ce91-4605-4683-9e66-2e39e2023c84'),('2025-11-28 10:09:44.900956',NULL,'2025-11-28 10:09:44.981173',332,332,'d695349bee344dfbbced1de2bcceb2ed','3a6bb042-d4e1-4df9-ac8f-b9790b89b2ba',82,'2cc8a146763846fabfe8e260b70f3971','shares',1,'2025-11-29 10:09:44',NULL),('2025-11-28 10:09:44.903200',NULL,'2025-11-28 10:09:44.981173',333,333,'d695349bee344dfbbced1de2bcceb2ed','89fdab7f-0090-4bbe-8607-9a6a49f0f561',83,'2cc8a146763846fabfe8e260b70f3971','gigabytes',1,'2025-11-29 10:09:44',NULL),('2025-11-28 10:09:44.919862',NULL,'2025-11-28 10:09:44.981173',334,334,NULL,'050d6a1c-3635-4cd9-9898-8301ad9a983e',112,'2cc8a146763846fabfe8e260b70f3971','shares',1,'2025-11-29 10:09:44','2824c130-0095-47f3-8876-9ba1a2df6000'),('2025-11-28 10:09:44.921599',NULL,'2025-11-28 10:09:44.981173',335,335,NULL,'bfed121d-3692-4950-a8c7-28336f6cbb1b',113,'2cc8a146763846fabfe8e260b70f3971','gigabytes',1,'2025-11-29 10:09:44','2824c130-0095-47f3-8876-9ba1a2df6000'),('2025-11-28 10:09:46.562396',NULL,'2025-11-28 10:09:46.573874',336,336,'8ea5668b7da944e3889979a0a4ebd864','bf1e32bb-04cb-4873-b82a-ac2e58f84409',77,'9ae469011da74f5abbce684003b3bb7b','shares',-1,'2025-11-29 10:09:46',NULL),('2025-11-28 10:09:46.563145',NULL,'2025-11-28 10:09:46.573874',337,337,'8ea5668b7da944e3889979a0a4ebd864','d60d6e94-c24f-4133-82b3-98f1f86eece6',76,'9ae469011da74f5abbce684003b3bb7b','gigabytes',-1,'2025-11-29 10:09:46',NULL),('2025-11-28 10:09:46.567754',NULL,'2025-11-28 10:09:46.573874',338,338,NULL,'a86112fe-cb85-46ae-8a2c-68b7d15a3aa0',108,'9ae469011da74f5abbce684003b3bb7b','shares',-1,'2025-11-29 10:09:46','649540ff-edd6-432a-980c-dffae9dab5ec'),('2025-11-28 10:09:46.568416',NULL,'2025-11-28 10:09:46.573874',339,339,NULL,'2f6cebab-f660-46eb-ad2e-88af2af4bb81',109,'9ae469011da74f5abbce684003b3bb7b','gigabytes',-1,'2025-11-29 10:09:46','649540ff-edd6-432a-980c-dffae9dab5ec'),('2025-11-28 10:09:48.392316',NULL,'2025-11-28 10:09:48.410727',340,340,'d695349bee344dfbbced1de2bcceb2ed','5e4ff106-7941-4fb5-a728-155dc85500f5',82,'2cc8a146763846fabfe8e260b70f3971','shares',-1,'2025-11-29 10:09:48',NULL),('2025-11-28 10:09:48.393118',NULL,'2025-11-28 10:09:48.410727',341,341,'d695349bee344dfbbced1de2bcceb2ed','cfb2b6f3-9fec-4d70-9ea3-0ae56bd44ded',83,'2cc8a146763846fabfe8e260b70f3971','gigabytes',-1,'2025-11-29 10:09:48',NULL),('2025-11-28 10:09:48.399582',NULL,'2025-11-28 10:09:48.410727',342,342,NULL,'43c6ce5b-9957-477e-b14e-211a619eebd5',112,'2cc8a146763846fabfe8e260b70f3971','shares',-1,'2025-11-29 10:09:48','2824c130-0095-47f3-8876-9ba1a2df6000'),('2025-11-28 10:09:48.401185',NULL,'2025-11-28 10:09:48.410727',343,343,NULL,'c5f651b0-ae79-4fac-b135-76aa122e6026',113,'2cc8a146763846fabfe8e260b70f3971','gigabytes',-1,'2025-11-29 10:09:48','2824c130-0095-47f3-8876-9ba1a2df6000'),('2025-11-28 10:09:49.552031',NULL,'2025-11-28 10:09:49.909739',344,344,'8ea5668b7da944e3889979a0a4ebd864','98261e18-3aad-48d7-9a55-1663dd444724',77,'9ae469011da74f5abbce684003b3bb7b','shares',1,'2025-11-29 10:09:49',NULL),('2025-11-28 10:09:49.553381',NULL,'2025-11-28 10:09:49.909739',345,345,'8ea5668b7da944e3889979a0a4ebd864','f337281b-4187-4970-b1d9-225484acf518',76,'9ae469011da74f5abbce684003b3bb7b','gigabytes',1,'2025-11-29 10:09:49',NULL),('2025-11-28 10:09:49.711365',NULL,'2025-11-28 10:09:49.909739',346,346,NULL,'6edf7ca2-b155-40d4-abf2-9ca78cd00ed5',115,'9ae469011da74f5abbce684003b3bb7b','shares',1,'2025-11-29 10:09:49','cb2d0222-2ac0-4831-b40e-6a0e3630b51a'),('2025-11-28 10:09:49.713290',NULL,'2025-11-28 10:09:49.909739',347,347,NULL,'c78777e2-3232-4025-846d-06e6cdaf16e6',114,'9ae469011da74f5abbce684003b3bb7b','gigabytes',1,'2025-11-29 10:09:49','cb2d0222-2ac0-4831-b40e-6a0e3630b51a'),('2025-11-28 10:09:50.523991',NULL,'2025-11-28 10:09:50.561766',348,348,'04b45146b0ab498fbc11c9fb27eaa424','24374c92-7be0-4a28-a021-cc6675a8b995',66,'56c91df0287e4974b45f4ed0b63d771d','shares',1,'2025-11-29 10:09:50',NULL),('2025-11-28 10:09:50.525431',NULL,'2025-11-28 10:09:50.561766',349,349,'04b45146b0ab498fbc11c9fb27eaa424','54f16ce0-a065-4d54-8d8a-70043d8828eb',67,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',1,'2025-11-29 10:09:50',NULL),('2025-11-28 10:09:50.538058',NULL,'2025-11-28 10:09:50.561766',350,350,NULL,'becd6e5d-5341-4a8e-87e2-909e949c5d41',117,'56c91df0287e4974b45f4ed0b63d771d','shares',1,'2025-11-29 10:09:50','a32f9924-0842-4f19-b22d-40d1a6f0a208'),('2025-11-28 10:09:50.540788',NULL,'2025-11-28 10:09:50.561766',351,351,NULL,'834677f0-6657-4839-ada0-2e68b620ecd7',116,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',1,'2025-11-29 10:09:50','a32f9924-0842-4f19-b22d-40d1a6f0a208'),('2025-11-28 10:09:51.628723',NULL,'2025-11-28 10:09:51.660318',352,352,'d405e1ced93a4b7f9732c9daccfc5d43','bf23c56b-21de-423d-a50f-fb9f104d364c',118,'3e75d8532ea44ff88f2e686f89303ba0','shares',1,'2025-11-29 10:09:51',NULL),('2025-11-28 10:09:51.629743',NULL,'2025-11-28 10:09:51.660318',353,353,'d405e1ced93a4b7f9732c9daccfc5d43','d7b69201-41ff-4a3d-b74b-18fbfc4d15db',119,'3e75d8532ea44ff88f2e686f89303ba0','gigabytes',4,'2025-11-29 10:09:51',NULL),('2025-11-28 10:09:51.641365',NULL,'2025-11-28 10:09:51.660318',354,354,NULL,'3a16c9f9-a16e-4e02-a80e-d0e247ed63dc',120,'3e75d8532ea44ff88f2e686f89303ba0','shares',1,'2025-11-29 10:09:51','01098295-4230-40a5-a351-8cabb1732714'),('2025-11-28 10:09:51.642610',NULL,'2025-11-28 10:09:51.660318',355,355,NULL,'22e5bc84-00d0-45e0-aaf0-7f8ce4c78eb9',121,'3e75d8532ea44ff88f2e686f89303ba0','gigabytes',4,'2025-11-29 10:09:51','01098295-4230-40a5-a351-8cabb1732714'),('2025-11-28 10:09:53.610762',NULL,'2025-11-28 10:09:53.716981',356,356,'8ea5668b7da944e3889979a0a4ebd864','492a007a-71c4-4152-bda5-60e81564802c',86,'9ae469011da74f5abbce684003b3bb7b','snapshots',1,'2025-11-29 10:09:53',NULL),('2025-11-28 10:09:53.612701',NULL,'2025-11-28 10:09:53.716981',357,357,'8ea5668b7da944e3889979a0a4ebd864','62ea336b-b784-46cf-9470-e2edae697c6f',87,'9ae469011da74f5abbce684003b3bb7b','snapshot_gigabytes',1,'2025-11-29 10:09:53',NULL),('2025-11-28 10:09:53.630017',NULL,'2025-11-28 10:09:53.716981',358,358,NULL,'c8cd5e93-3d8b-4dfb-a9cb-d87fad8c0c9f',122,'9ae469011da74f5abbce684003b3bb7b','snapshots',1,'2025-11-29 10:09:53','cb2d0222-2ac0-4831-b40e-6a0e3630b51a'),('2025-11-28 10:09:53.631458',NULL,'2025-11-28 10:09:53.716981',359,359,NULL,'70a1e66f-8a2d-47ca-8d42-152fc6b3af98',123,'9ae469011da74f5abbce684003b3bb7b','snapshot_gigabytes',1,'2025-11-29 10:09:53','cb2d0222-2ac0-4831-b40e-6a0e3630b51a'),('2025-11-28 10:09:54.839214',NULL,'2025-11-28 10:09:54.850590',360,360,'d405e1ced93a4b7f9732c9daccfc5d43','4ccb6539-b24b-4d1c-a158-0adf37894c08',118,'3e75d8532ea44ff88f2e686f89303ba0','shares',1,'2025-11-29 10:09:54',NULL),('2025-11-28 10:09:54.840729',NULL,'2025-11-28 10:09:54.850590',361,361,'d405e1ced93a4b7f9732c9daccfc5d43','bdcc03a9-49ce-402f-89a7-61690f03336d',119,'3e75d8532ea44ff88f2e686f89303ba0','gigabytes',3,'2025-11-29 10:09:54',NULL),('2025-11-28 10:09:54.964304',NULL,'2025-11-28 10:09:54.994520',362,362,'d405e1ced93a4b7f9732c9daccfc5d43','4fc5be8e-f126-4431-bff8-30333dc989df',118,'3e75d8532ea44ff88f2e686f89303ba0','shares',1,'2025-11-29 10:09:54',NULL),('2025-11-28 10:09:54.965544',NULL,'2025-11-28 10:09:54.994520',363,363,'d405e1ced93a4b7f9732c9daccfc5d43','a7e9c690-b14e-49cd-a9de-3ef52ed421c3',119,'3e75d8532ea44ff88f2e686f89303ba0','gigabytes',3,'2025-11-29 10:09:54',NULL),('2025-11-28 10:09:54.977041',NULL,'2025-11-28 10:09:54.994520',364,364,NULL,'858633cd-1b63-488a-98f2-b4e6844fd66f',124,'3e75d8532ea44ff88f2e686f89303ba0','shares',1,'2025-11-29 10:09:54','5a147245-c70c-4d91-92f3-86f2fe59f721'),('2025-11-28 10:09:54.978098',NULL,'2025-11-28 10:09:54.994520',365,365,NULL,'b2ab4cbe-3998-40f3-b306-cee74962e786',125,'3e75d8532ea44ff88f2e686f89303ba0','gigabytes',3,'2025-11-29 10:09:54','5a147245-c70c-4d91-92f3-86f2fe59f721'),('2025-11-28 10:09:56.955050',NULL,'2025-11-28 10:09:56.968381',366,366,'04b45146b0ab498fbc11c9fb27eaa424','2d4da404-d878-44a4-b686-7acd69e7f22d',66,'56c91df0287e4974b45f4ed0b63d771d','shares',-1,'2025-11-29 10:09:56',NULL),('2025-11-28 10:09:56.955877',NULL,'2025-11-28 10:09:56.968381',367,367,'04b45146b0ab498fbc11c9fb27eaa424','5901d66b-c71e-4291-bb32-1820cf19e6f8',67,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',-1,'2025-11-29 10:09:56',NULL),('2025-11-28 10:09:56.961140',NULL,'2025-11-28 10:09:56.968381',368,368,NULL,'21a04b81-79a8-41b9-ba47-11e374227a61',117,'56c91df0287e4974b45f4ed0b63d771d','shares',-1,'2025-11-29 10:09:56','a32f9924-0842-4f19-b22d-40d1a6f0a208'),('2025-11-28 10:09:56.962782',NULL,'2025-11-28 10:09:56.968381',369,369,NULL,'2cb289e2-9a03-4c2f-95e8-4b03ba558ba3',116,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',-1,'2025-11-29 10:09:56','a32f9924-0842-4f19-b22d-40d1a6f0a208'),('2025-11-28 10:09:57.019509',NULL,'2025-11-28 10:09:57.051288',370,370,'d3b6d62e085a4d95bdeb1efff668b621','a44a947a-0503-420e-8dd1-4894b05d2939',126,'ed59ec099bfe470982dfd8309e19126f','shares',1,'2025-11-29 10:09:56',NULL),('2025-11-28 10:09:57.020835',NULL,'2025-11-28 10:09:57.051288',371,371,'d3b6d62e085a4d95bdeb1efff668b621','c15ecfb8-ea55-4fe8-9e4c-6a59dc430cc0',127,'ed59ec099bfe470982dfd8309e19126f','gigabytes',1,'2025-11-29 10:09:56',NULL),('2025-11-28 10:09:57.031169',NULL,'2025-11-28 10:09:57.051288',372,372,NULL,'8abaf34e-5a8d-42f3-a740-805beffccaea',128,'ed59ec099bfe470982dfd8309e19126f','shares',1,'2025-11-29 10:09:56','84b20621-c945-4853-94b1-f0c82a2eb815'),('2025-11-28 10:09:57.032872',NULL,'2025-11-28 10:09:57.051288',373,373,NULL,'b6968c16-05bc-4e5d-ac5d-416829b87470',129,'ed59ec099bfe470982dfd8309e19126f','gigabytes',1,'2025-11-29 10:09:56','84b20621-c945-4853-94b1-f0c82a2eb815'),('2025-11-28 10:09:57.146390',NULL,'2025-11-28 10:09:57.339708',374,374,'8ea5668b7da944e3889979a0a4ebd864','76bec2c6-77b1-4937-a38c-931700b31234',77,'9ae469011da74f5abbce684003b3bb7b','shares',1,'2025-11-29 10:09:57',NULL),('2025-11-28 10:09:57.147790',NULL,'2025-11-28 10:09:57.169795',375,375,'04b45146b0ab498fbc11c9fb27eaa424','5a6f0463-0b39-4dbd-9933-6f16afe61196',66,'56c91df0287e4974b45f4ed0b63d771d','shares',-1,'2025-11-29 10:09:57',NULL),('2025-11-28 10:09:57.148501',NULL,'2025-11-28 10:09:57.169795',376,376,'04b45146b0ab498fbc11c9fb27eaa424','57c8b2a6-a2bf-4cb0-9540-69a18a4f613d',67,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',-1,'2025-11-29 10:09:57',NULL),('2025-11-28 10:09:57.148906',NULL,'2025-11-28 10:09:57.339708',377,377,'8ea5668b7da944e3889979a0a4ebd864','e172ef60-42a6-4a17-8ed4-6411c8ce155e',76,'9ae469011da74f5abbce684003b3bb7b','gigabytes',1,'2025-11-29 10:09:57',NULL),('2025-11-28 10:09:57.158292',NULL,'2025-11-28 10:09:57.169795',378,378,NULL,'b4436fb9-ea32-46ac-9cf3-78c9f783dce0',111,'56c91df0287e4974b45f4ed0b63d771d','shares',-1,'2025-11-29 10:09:57','88ea85e2-148e-4d8d-8f52-2ace5e4a8e88'),('2025-11-28 10:09:57.159552',NULL,'2025-11-28 10:09:57.169795',379,379,NULL,'cf25adcf-d26d-4cff-a83a-a4daf015ce94',110,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',-1,'2025-11-29 10:09:57','88ea85e2-148e-4d8d-8f52-2ace5e4a8e88'),('2025-11-28 10:09:57.160104',NULL,'2025-11-28 10:09:57.339708',380,380,NULL,'7c459d1a-a6ea-4426-a200-6587cd27e5cb',115,'9ae469011da74f5abbce684003b3bb7b','shares',1,'2025-11-29 10:09:57','cb2d0222-2ac0-4831-b40e-6a0e3630b51a'),('2025-11-28 10:09:57.162921',NULL,'2025-11-28 10:09:57.339708',381,381,NULL,'f367166f-9129-47db-8c7e-b6fc1f0d6cd2',114,'9ae469011da74f5abbce684003b3bb7b','gigabytes',1,'2025-11-29 10:09:57','cb2d0222-2ac0-4831-b40e-6a0e3630b51a'),('2025-11-28 10:09:57.291453',NULL,'2025-11-28 10:09:57.328634',382,382,'04b45146b0ab498fbc11c9fb27eaa424','fa5e2e77-7622-42dc-a59e-6dbd329bd766',66,'56c91df0287e4974b45f4ed0b63d771d','shares',1,'2025-11-29 10:09:57',NULL),('2025-11-28 10:09:57.293390',NULL,'2025-11-28 10:09:57.328634',383,383,'04b45146b0ab498fbc11c9fb27eaa424','e2d75988-4afa-4719-ac32-7f26d89bd9ec',67,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',1,'2025-11-29 10:09:57',NULL),('2025-11-28 10:09:57.304400',NULL,'2025-11-28 10:09:57.328634',384,384,NULL,'4bc5d49a-d0a2-4657-a8e0-d4e734d4879e',130,'56c91df0287e4974b45f4ed0b63d771d','shares',1,'2025-11-29 10:09:57','d9f2031f-c743-45fb-9bd3-8793a2be69c1'),('2025-11-28 10:09:57.305540',NULL,'2025-11-28 10:09:57.328634',385,385,NULL,'1dc6de6a-9603-4022-863a-350c695233c6',131,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',1,'2025-11-29 10:09:57','d9f2031f-c743-45fb-9bd3-8793a2be69c1'),('2025-11-28 10:09:58.754564',NULL,'2025-11-28 10:09:58.784843',386,386,'bb79385c64e04edebbffe34d05ef597c','0162063c-6d30-4a56-adb9-a0019971cdfa',132,'7ccd2022daf64a6998725722e4ad2ecf','shares',1,'2025-11-29 10:09:58',NULL),('2025-11-28 10:09:58.755547',NULL,'2025-11-28 10:09:58.784843',387,387,'bb79385c64e04edebbffe34d05ef597c','d71edca6-8753-4f29-a8e9-4994ddd545f5',133,'7ccd2022daf64a6998725722e4ad2ecf','gigabytes',1,'2025-11-29 10:09:58',NULL),('2025-11-28 10:09:58.764646',NULL,'2025-11-28 10:09:58.784843',388,388,NULL,'bd2e9f0e-0757-4c5b-8035-6053fc896dfc',134,'7ccd2022daf64a6998725722e4ad2ecf','shares',1,'2025-11-29 10:09:58','610122e4-5b17-49ab-8a14-82498fa4e576'),('2025-11-28 10:09:58.765711',NULL,'2025-11-28 10:09:58.784843',389,389,NULL,'90f0b090-29c4-4c2b-9e23-68f0c9cc9cd2',135,'7ccd2022daf64a6998725722e4ad2ecf','gigabytes',1,'2025-11-29 10:09:58','610122e4-5b17-49ab-8a14-82498fa4e576'),('2025-11-28 10:10:00.644088',NULL,'2025-11-28 10:10:00.679640',390,390,'d405e1ced93a4b7f9732c9daccfc5d43','61294cbd-7bfb-4a3f-b4f7-053060f92bc9',118,'3e75d8532ea44ff88f2e686f89303ba0','shares',-1,'2025-11-29 10:10:00',NULL),('2025-11-28 10:10:00.645638',NULL,'2025-11-28 10:10:00.679640',391,391,'d405e1ced93a4b7f9732c9daccfc5d43','35593b85-e5d3-428b-b36a-63db6696ccc5',119,'3e75d8532ea44ff88f2e686f89303ba0','gigabytes',-4,'2025-11-29 10:10:00',NULL),('2025-11-28 10:10:00.665317',NULL,'2025-11-28 10:10:00.679640',392,392,NULL,'9837ec9b-0cf1-46ee-999d-386e5b9e4427',120,'3e75d8532ea44ff88f2e686f89303ba0','shares',-1,'2025-11-29 10:10:00','01098295-4230-40a5-a351-8cabb1732714'),('2025-11-28 10:10:00.667868',NULL,'2025-11-28 10:10:00.679640',393,393,NULL,'1b8d725f-603c-4b7a-af13-1f69c14f561c',121,'3e75d8532ea44ff88f2e686f89303ba0','gigabytes',-4,'2025-11-29 10:10:00','01098295-4230-40a5-a351-8cabb1732714'),('2025-11-28 10:10:00.717944',NULL,'2025-11-28 10:10:00.735650',394,394,'04b45146b0ab498fbc11c9fb27eaa424','f470a6a8-1263-40ff-a792-1aa43513349d',66,'56c91df0287e4974b45f4ed0b63d771d','shares',-1,'2025-11-29 10:10:00',NULL),('2025-11-28 10:10:00.718752',NULL,'2025-11-28 10:10:00.735650',395,395,'04b45146b0ab498fbc11c9fb27eaa424','6135f7a7-7196-444c-8750-7a525669198f',67,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',-1,'2025-11-29 10:10:00',NULL),('2025-11-28 10:10:00.726224',NULL,'2025-11-28 10:10:00.735650',396,396,NULL,'e87f73f5-d11a-49c9-b696-5c6445becce3',130,'56c91df0287e4974b45f4ed0b63d771d','shares',-1,'2025-11-29 10:10:00','d9f2031f-c743-45fb-9bd3-8793a2be69c1'),('2025-11-28 10:10:00.726918',NULL,'2025-11-28 10:10:00.735650',397,397,NULL,'7b3526a7-b869-4852-8de6-b2fe210a99ae',131,'56c91df0287e4974b45f4ed0b63d771d','gigabytes',-1,'2025-11-29 10:10:00','d9f2031f-c743-45fb-9bd3-8793a2be69c1'),('2025-11-28 10:10:01.917365',NULL,'2025-11-28 10:10:01.932287',398,398,'d405e1ced93a4b7f9732c9daccfc5d43','ada57c6f-9745-4839-abe7-19ef8c2a2fbc',118,'3e75d8532ea44ff88f2e686f89303ba0','shares',-1,'2025-11-29 10:10:01',NULL),('2025-11-28 10:10:01.918073',NULL,'2025-11-28 10:10:01.932287',399,399,'d405e1ced93a4b7f9732c9daccfc5d43','d60b987e-497a-4b41-b84f-a8dcedcd3a60',119,'3e75d8532ea44ff88f2e686f89303ba0','gigabytes',-3,'2025-11-29 10:10:01',NULL),('2025-11-28 10:10:01.923308',NULL,'2025-11-28 10:10:01.932287',400,400,NULL,'f7e1afc9-9144-4165-8ace-39eb6a740b93',124,'3e75d8532ea44ff88f2e686f89303ba0','shares',-1,'2025-11-29 10:10:01','5a147245-c70c-4d91-92f3-86f2fe59f721'),('2025-11-28 10:10:01.924127',NULL,'2025-11-28 10:10:01.932287',401,401,NULL,'21f19eaa-d8bd-4f1b-a0e1-086cad7adb79',125,'3e75d8532ea44ff88f2e686f89303ba0','gigabytes',-3,'2025-11-29 10:10:01','5a147245-c70c-4d91-92f3-86f2fe59f721'),('2025-11-28 10:10:03.499104',NULL,'2025-11-28 10:10:03.557875',402,402,'b81484063c294e2b9fbd79c48d3a78e1','b82536fd-2016-4d23-8c86-08b307eba982',136,'8e3baf6078d441fead64f612139a9c5e','shares',1,'2025-11-29 10:10:03',NULL),('2025-11-28 10:10:03.500215',NULL,'2025-11-28 10:10:03.557875',403,403,'b81484063c294e2b9fbd79c48d3a78e1','d9d356d2-ff8d-4e54-ae4d-5139a2389046',137,'8e3baf6078d441fead64f612139a9c5e','gigabytes',1,'2025-11-29 10:10:03',NULL),('2025-11-28 10:10:03.511017',NULL,'2025-11-28 10:10:03.557875',404,404,NULL,'30bf5fc3-1675-4c65-96a8-a34c2d13c2bd',138,'8e3baf6078d441fead64f612139a9c5e','shares',1,'2025-11-29 10:10:03','12de8a30-5c34-4d8e-ac9a-152a96e413e3'),('2025-11-28 10:10:03.512233',NULL,'2025-11-28 10:10:03.557875',405,405,NULL,'527bdce9-ee41-47e7-9636-3a6a46609fee',139,'8e3baf6078d441fead64f612139a9c5e','gigabytes',1,'2025-11-29 10:10:03','12de8a30-5c34-4d8e-ac9a-152a96e413e3'),('2025-11-28 10:10:05.747025',NULL,'2025-11-28 10:10:05.774311',406,406,'bb79385c64e04edebbffe34d05ef597c','9ca2fdad-f38f-4e49-80b2-28f3359539e0',132,'7ccd2022daf64a6998725722e4ad2ecf','shares',-1,'2025-11-29 10:10:05',NULL),('2025-11-28 10:10:05.748212',NULL,'2025-11-28 10:10:05.774311',407,407,'bb79385c64e04edebbffe34d05ef597c','0bced248-3523-489a-acfd-c48bba30b46d',133,'7ccd2022daf64a6998725722e4ad2ecf','gigabytes',-1,'2025-11-29 10:10:05',NULL),('2025-11-28 10:10:05.760230',NULL,'2025-11-28 10:10:05.774311',408,408,NULL,'cb08f222-f874-4ddc-bfb1-5d7591461f92',134,'7ccd2022daf64a6998725722e4ad2ecf','shares',-1,'2025-11-29 10:10:05','610122e4-5b17-49ab-8a14-82498fa4e576'),('2025-11-28 10:10:05.761281',NULL,'2025-11-28 10:10:05.774311',409,409,NULL,'97e87846-2960-434d-afc3-8c87cc8cda7e',135,'7ccd2022daf64a6998725722e4ad2ecf','gigabytes',-1,'2025-11-29 10:10:05','610122e4-5b17-49ab-8a14-82498fa4e576'),('2025-11-28 10:10:06.776453',NULL,'2025-11-28 10:10:06.832121',410,410,'b81484063c294e2b9fbd79c48d3a78e1','08cda744-f8c1-4b32-9161-f253863e48bc',136,'8e3baf6078d441fead64f612139a9c5e','shares',1,'2025-11-29 10:10:06',NULL),('2025-11-28 10:10:06.778901',NULL,'2025-11-28 10:10:06.832121',411,411,'b81484063c294e2b9fbd79c48d3a78e1','70fdc5d6-2eee-4a25-bd8f-5131f008cf8a',137,'8e3baf6078d441fead64f612139a9c5e','gigabytes',1,'2025-11-29 10:10:06',NULL),('2025-11-28 10:10:06.792818',NULL,'2025-11-28 10:10:06.832121',412,412,NULL,'5d6d0329-1148-44e0-acc9-45051778eaf7',138,'8e3baf6078d441fead64f612139a9c5e','shares',1,'2025-11-29 10:10:06','12de8a30-5c34-4d8e-ac9a-152a96e413e3'),('2025-11-28 10:10:06.795392',NULL,'2025-11-28 10:10:06.832121',413,413,NULL,'8f1d8693-b67e-4e2b-aeba-6709792a9cd2',139,'8e3baf6078d441fead64f612139a9c5e','gigabytes',1,'2025-11-29 10:10:06','12de8a30-5c34-4d8e-ac9a-152a96e413e3'),('2025-11-28 10:10:07.210488',NULL,'2025-11-28 10:10:07.251759',414,414,'8ea5668b7da944e3889979a0a4ebd864','424cfd45-2ad5-4d15-b751-54844fdc88bb',77,'9ae469011da74f5abbce684003b3bb7b','shares',-1,'2025-11-29 10:10:07',NULL),('2025-11-28 10:10:07.211958',NULL,'2025-11-28 10:10:07.251759',415,415,'8ea5668b7da944e3889979a0a4ebd864','fe83ca43-83b8-4e9b-a02f-7a04c9a62a1d',76,'9ae469011da74f5abbce684003b3bb7b','gigabytes',-1,'2025-11-29 10:10:07',NULL),('2025-11-28 10:10:07.233028',NULL,'2025-11-28 10:10:07.251759',416,416,NULL,'d2d7a163-a1e9-4e18-8ae7-1b56a555ea25',115,'9ae469011da74f5abbce684003b3bb7b','shares',-1,'2025-11-29 10:10:07','cb2d0222-2ac0-4831-b40e-6a0e3630b51a'),('2025-11-28 10:10:07.234286',NULL,'2025-11-28 10:10:07.251759',417,417,NULL,'050bf345-be3c-422a-8357-a8c582e89b17',114,'9ae469011da74f5abbce684003b3bb7b','gigabytes',-1,'2025-11-29 10:10:07','cb2d0222-2ac0-4831-b40e-6a0e3630b51a'),('2025-11-28 10:10:09.627780',NULL,'2025-11-28 10:10:09.668050',418,418,'7365471ed46d40d6bedf922c53fd4393','c227c24f-ff9a-4828-8fff-6c3957808f4e',140,'20fec43a3a4446938f9dcafec6c9893a','shares',1,'2025-11-29 10:10:09',NULL),('2025-11-28 10:10:09.630019',NULL,'2025-11-28 10:10:09.668050',419,419,'7365471ed46d40d6bedf922c53fd4393','2810633a-3dc9-4cd4-a6cc-817d8c8f711f',141,'20fec43a3a4446938f9dcafec6c9893a','gigabytes',1,'2025-11-29 10:10:09',NULL),('2025-11-28 10:10:09.646920',NULL,'2025-11-28 10:10:09.668050',420,420,NULL,'55fd8b0f-7990-455a-80f5-bb0afd188acf',142,'20fec43a3a4446938f9dcafec6c9893a','shares',1,'2025-11-29 10:10:09','921ff349-dfdc-472f-a671-644f6fd49864'),('2025-11-28 10:10:09.648080',NULL,'2025-11-28 10:10:09.668050',421,421,NULL,'c8a63327-e439-4951-a90f-7534d0e02a5a',143,'20fec43a3a4446938f9dcafec6c9893a','gigabytes',1,'2025-11-29 10:10:09','921ff349-dfdc-472f-a671-644f6fd49864'),('2025-11-28 10:10:10.232428',NULL,'2025-11-28 10:10:10.252201',422,422,'8ea5668b7da944e3889979a0a4ebd864','dcfa0199-04b4-4623-8144-229bf9968c62',86,'9ae469011da74f5abbce684003b3bb7b','snapshots',-1,'2025-11-29 10:10:10',NULL),('2025-11-28 10:10:10.233213',NULL,'2025-11-28 10:10:10.252201',423,423,'8ea5668b7da944e3889979a0a4ebd864','184f5d05-bc53-4225-93ac-6c829f5a7249',87,'9ae469011da74f5abbce684003b3bb7b','snapshot_gigabytes',-1,'2025-11-29 10:10:10',NULL),('2025-11-28 10:10:10.238114',NULL,'2025-11-28 10:10:10.252201',424,424,NULL,'301fbc02-47a6-48b3-88f4-aadc4e41b1eb',122,'9ae469011da74f5abbce684003b3bb7b','snapshots',-1,'2025-11-29 10:10:10','cb2d0222-2ac0-4831-b40e-6a0e3630b51a'),('2025-11-28 10:10:10.238840',NULL,'2025-11-28 10:10:10.252201',425,425,NULL,'3cd66bea-a490-46b7-9a3a-4f4524d19d55',123,'9ae469011da74f5abbce684003b3bb7b','snapshot_gigabytes',-1,'2025-11-29 10:10:10','cb2d0222-2ac0-4831-b40e-6a0e3630b51a'),('2025-11-28 10:10:10.985567',NULL,'2025-11-28 10:10:11.010661',426,426,'b81484063c294e2b9fbd79c48d3a78e1','b325d8bd-2e5e-4bbd-8be2-7400ed368c0f',136,'8e3baf6078d441fead64f612139a9c5e','shares',-1,'2025-11-29 10:10:10',NULL),('2025-11-28 10:10:10.986948',NULL,'2025-11-28 10:10:11.010661',427,427,'b81484063c294e2b9fbd79c48d3a78e1','d93305c4-061b-4948-a9f7-1a44d6a566a9',137,'8e3baf6078d441fead64f612139a9c5e','gigabytes',-1,'2025-11-29 10:10:10',NULL),('2025-11-28 10:10:10.995191',NULL,'2025-11-28 10:10:11.010661',428,428,NULL,'68e18fba-d6fb-40ba-8c38-d37e5ac8c268',138,'8e3baf6078d441fead64f612139a9c5e','shares',-1,'2025-11-29 10:10:10','12de8a30-5c34-4d8e-ac9a-152a96e413e3'),('2025-11-28 10:10:10.996350',NULL,'2025-11-28 10:10:11.010661',429,429,NULL,'6a5c5de9-3011-4040-8148-544c83e8fc22',139,'8e3baf6078d441fead64f612139a9c5e','gigabytes',-1,'2025-11-29 10:10:10','12de8a30-5c34-4d8e-ac9a-152a96e413e3'),('2025-11-28 10:10:13.398498',NULL,'2025-11-28 10:10:13.423257',430,430,'8ea5668b7da944e3889979a0a4ebd864','2a455da5-7f61-4ce8-8885-bf2de95ff893',77,'9ae469011da74f5abbce684003b3bb7b','shares',-1,'2025-11-29 10:10:13',NULL),('2025-11-28 10:10:13.399328',NULL,'2025-11-28 10:10:13.423257',431,431,'8ea5668b7da944e3889979a0a4ebd864','de614282-5687-4eb8-8532-fbb10fa36e25',76,'9ae469011da74f5abbce684003b3bb7b','gigabytes',-1,'2025-11-29 10:10:13',NULL),('2025-11-28 10:10:13.405659',NULL,'2025-11-28 10:10:13.423257',432,432,NULL,'d4d6df9e-410d-4db2-b475-e28ffd8bebaf',115,'9ae469011da74f5abbce684003b3bb7b','shares',-1,'2025-11-29 10:10:13','cb2d0222-2ac0-4831-b40e-6a0e3630b51a'),('2025-11-28 10:10:13.407311',NULL,'2025-11-28 10:10:13.423257',433,433,NULL,'f704e0f0-5c84-4fde-a5d2-ccb1878200d6',114,'9ae469011da74f5abbce684003b3bb7b','gigabytes',-1,'2025-11-29 10:10:13','cb2d0222-2ac0-4831-b40e-6a0e3630b51a'),('2025-11-28 10:10:13.813205',NULL,'2025-11-28 10:10:13.850100',434,434,'b81484063c294e2b9fbd79c48d3a78e1','1a6a350c-633b-492e-a3a9-0aa8e0f055ac',136,'8e3baf6078d441fead64f612139a9c5e','shares',1,'2025-11-29 10:10:13',NULL),('2025-11-28 10:10:13.815024',NULL,'2025-11-28 10:10:13.850100',435,435,'b81484063c294e2b9fbd79c48d3a78e1','02f5b984-2649-46d3-9988-d0256cb0f6e1',137,'8e3baf6078d441fead64f612139a9c5e','gigabytes',1,'2025-11-29 10:10:13',NULL),('2025-11-28 10:10:13.821141',NULL,'2025-11-28 10:10:13.850100',436,436,NULL,'1edc8794-81ba-4553-a04e-9c5c03dde8ef',138,'8e3baf6078d441fead64f612139a9c5e','shares',1,'2025-11-29 10:10:13','12de8a30-5c34-4d8e-ac9a-152a96e413e3'),('2025-11-28 10:10:13.822347',NULL,'2025-11-28 10:10:13.850100',437,437,NULL,'c4393d93-4f96-44f0-b1a1-a0fbc78c0773',139,'8e3baf6078d441fead64f612139a9c5e','gigabytes',1,'2025-11-29 10:10:13','12de8a30-5c34-4d8e-ac9a-152a96e413e3'),('2025-11-28 10:10:13.855079',NULL,'2025-11-28 10:10:13.887840',438,438,'fe5a177f7488487e910ff3a84521bd9b','fe27900a-69d3-4ed5-ad94-a9d28164f884',145,'4395abd486d947d5ba2cd486b8c2f257','shares',1,'2025-11-29 10:10:13',NULL),('2025-11-28 10:10:13.856180',NULL,'2025-11-28 10:10:13.887840',439,439,'fe5a177f7488487e910ff3a84521bd9b','f954703c-3eb8-42c4-bed8-b3cba5cb3623',144,'4395abd486d947d5ba2cd486b8c2f257','gigabytes',1,'2025-11-29 10:10:13',NULL),('2025-11-28 10:10:13.866770',NULL,'2025-11-28 10:10:13.887840',440,440,NULL,'b29b31aa-b9f8-4c98-bdd4-8ff8e9919acf',147,'4395abd486d947d5ba2cd486b8c2f257','shares',1,'2025-11-29 10:10:13','10bc0b19-2cf0-4cb4-a06e-cd95828efafc'),('2025-11-28 10:10:13.868628',NULL,'2025-11-28 10:10:13.887840',441,441,NULL,'fd31fb07-9ff5-4a73-922b-609286014806',146,'4395abd486d947d5ba2cd486b8c2f257','gigabytes',1,'2025-11-29 10:10:13','10bc0b19-2cf0-4cb4-a06e-cd95828efafc'),('2025-11-28 10:10:14.386510',NULL,'2025-11-28 10:10:14.432907',442,442,'7365471ed46d40d6bedf922c53fd4393','f090bf1d-c686-4fd8-ba78-084c548579d7',140,'20fec43a3a4446938f9dcafec6c9893a','shares',-1,'2025-11-29 10:10:14',NULL),('2025-11-28 10:10:14.387702',NULL,'2025-11-28 10:10:14.432907',443,443,'7365471ed46d40d6bedf922c53fd4393','7f15b9e3-bdad-454c-9ea8-44fb102d6c01',141,'20fec43a3a4446938f9dcafec6c9893a','gigabytes',-1,'2025-11-29 10:10:14',NULL),('2025-11-28 10:10:14.410253',NULL,'2025-11-28 10:10:14.432907',444,444,NULL,'fb474e13-beb1-4120-8c1a-877823e8143c',142,'20fec43a3a4446938f9dcafec6c9893a','shares',-1,'2025-11-29 10:10:14','921ff349-dfdc-472f-a671-644f6fd49864'),('2025-11-28 10:10:14.412947',NULL,'2025-11-28 10:10:14.432907',445,445,NULL,'bfa57414-8ad8-43eb-bb5a-041ecdc6332b',143,'20fec43a3a4446938f9dcafec6c9893a','gigabytes',-1,'2025-11-29 10:10:14','921ff349-dfdc-472f-a671-644f6fd49864'),('2025-11-28 10:10:17.083914',NULL,'2025-11-28 10:10:17.160376',446,446,'fe5a177f7488487e910ff3a84521bd9b','6407e2df-ab39-4af6-a2df-129e68c8620c',148,'4395abd486d947d5ba2cd486b8c2f257','snapshots',1,'2025-11-29 10:10:17',NULL),('2025-11-28 10:10:17.085202',NULL,'2025-11-28 10:10:17.160376',447,447,'fe5a177f7488487e910ff3a84521bd9b','c0ce40b8-e4d6-4603-b37f-5d869b824ff1',149,'4395abd486d947d5ba2cd486b8c2f257','snapshot_gigabytes',1,'2025-11-29 10:10:17',NULL),('2025-11-28 10:10:17.097600',NULL,'2025-11-28 10:10:17.160376',448,448,NULL,'93e51116-72c5-4139-a8c4-baa4eefb7200',150,'4395abd486d947d5ba2cd486b8c2f257','snapshots',1,'2025-11-29 10:10:17','10bc0b19-2cf0-4cb4-a06e-cd95828efafc'),('2025-11-28 10:10:17.099171',NULL,'2025-11-28 10:10:17.160376',449,449,NULL,'975a705d-9433-4139-8968-26708f5294c0',151,'4395abd486d947d5ba2cd486b8c2f257','snapshot_gigabytes',1,'2025-11-29 10:10:17','10bc0b19-2cf0-4cb4-a06e-cd95828efafc'),('2025-11-28 10:10:18.121248',NULL,'2025-11-28 10:10:18.149868',450,450,'b81484063c294e2b9fbd79c48d3a78e1','54a24cf9-1d2a-4768-b9a4-6e2788500426',136,'8e3baf6078d441fead64f612139a9c5e','shares',-1,'2025-11-29 10:10:18',NULL),('2025-11-28 10:10:18.122216',NULL,'2025-11-28 10:10:18.149868',451,451,'b81484063c294e2b9fbd79c48d3a78e1','a1083c26-3482-4d98-b22f-8c4b03b1672a',137,'8e3baf6078d441fead64f612139a9c5e','gigabytes',-1,'2025-11-29 10:10:18',NULL),('2025-11-28 10:10:18.132759',NULL,'2025-11-28 10:10:18.149868',452,452,NULL,'0496f842-58db-4a1f-b1ae-b08fede84063',138,'8e3baf6078d441fead64f612139a9c5e','shares',-1,'2025-11-29 10:10:18','12de8a30-5c34-4d8e-ac9a-152a96e413e3'),('2025-11-28 10:10:18.134215',NULL,'2025-11-28 10:10:18.149868',453,453,NULL,'db6a2dc8-7cfe-46c5-9e3c-6fa374d2c151',139,'8e3baf6078d441fead64f612139a9c5e','gigabytes',-1,'2025-11-29 10:10:18','12de8a30-5c34-4d8e-ac9a-152a96e413e3'),('2025-11-28 10:10:18.592083',NULL,'2025-11-28 10:10:18.615336',454,454,'d3b6d62e085a4d95bdeb1efff668b621','7a34e1c2-7849-4f50-9d8b-08d80a15b1f8',126,'ed59ec099bfe470982dfd8309e19126f','shares',-1,'2025-11-29 10:10:18',NULL),('2025-11-28 10:10:18.593039',NULL,'2025-11-28 10:10:18.615336',455,455,'d3b6d62e085a4d95bdeb1efff668b621','56e6f5b5-2225-4b21-956b-d876e7a5e059',127,'ed59ec099bfe470982dfd8309e19126f','gigabytes',-1,'2025-11-29 10:10:18',NULL),('2025-11-28 10:10:18.605480',NULL,'2025-11-28 10:10:18.615336',456,456,NULL,'7316752d-d790-47a6-b649-bed49b9245ff',128,'ed59ec099bfe470982dfd8309e19126f','shares',-1,'2025-11-29 10:10:18','84b20621-c945-4853-94b1-f0c82a2eb815'),('2025-11-28 10:10:18.606616',NULL,'2025-11-28 10:10:18.615336',457,457,NULL,'76cc0ecb-2959-4ed0-95a5-747da2ae3399',129,'ed59ec099bfe470982dfd8309e19126f','gigabytes',-1,'2025-11-29 10:10:18','84b20621-c945-4853-94b1-f0c82a2eb815'),('2025-11-28 10:10:20.962644',NULL,'2025-11-28 10:10:21.002118',458,458,'b81484063c294e2b9fbd79c48d3a78e1','08f8e9e1-c79d-4d9b-b28b-2e6992c00c31',136,'8e3baf6078d441fead64f612139a9c5e','shares',1,'2025-11-29 10:10:20',NULL),('2025-11-28 10:10:20.963801',NULL,'2025-11-28 10:10:21.002118',459,459,'b81484063c294e2b9fbd79c48d3a78e1','34c07d7c-d21d-4581-ae8b-4f27012e4e16',137,'8e3baf6078d441fead64f612139a9c5e','gigabytes',1,'2025-11-29 10:10:20',NULL),('2025-11-28 10:10:20.973274',NULL,'2025-11-28 10:10:21.002118',460,460,NULL,'40ef89da-69d0-4cac-a8a1-8fc39392e80a',138,'8e3baf6078d441fead64f612139a9c5e','shares',1,'2025-11-29 10:10:20','12de8a30-5c34-4d8e-ac9a-152a96e413e3'),('2025-11-28 10:10:20.976901',NULL,'2025-11-28 10:10:21.002118',461,461,NULL,'9023738e-eba9-4d00-b2cb-9134bbabbf4c',139,'8e3baf6078d441fead64f612139a9c5e','gigabytes',1,'2025-11-29 10:10:20','12de8a30-5c34-4d8e-ac9a-152a96e413e3'),('2025-11-28 10:10:21.417346',NULL,'2025-11-28 10:10:21.462460',462,462,'fe5a177f7488487e910ff3a84521bd9b','2a6ea8d7-8ac7-4cfd-809d-ce93bc1502fa',148,'4395abd486d947d5ba2cd486b8c2f257','snapshots',-1,'2025-11-29 10:10:21',NULL),('2025-11-28 10:10:21.419984',NULL,'2025-11-28 10:10:21.462460',463,463,'fe5a177f7488487e910ff3a84521bd9b','f827d133-6fdf-45a2-810b-3430e6c78804',149,'4395abd486d947d5ba2cd486b8c2f257','snapshot_gigabytes',-1,'2025-11-29 10:10:21',NULL),('2025-11-28 10:10:21.432942',NULL,'2025-11-28 10:10:21.462460',464,464,NULL,'6bb1683d-673b-45ab-bfce-a7e92b40d40d',150,'4395abd486d947d5ba2cd486b8c2f257','snapshots',-1,'2025-11-29 10:10:21','10bc0b19-2cf0-4cb4-a06e-cd95828efafc'),('2025-11-28 10:10:21.438830',NULL,'2025-11-28 10:10:21.462460',465,465,NULL,'6a2d924e-e449-4ce8-8256-7adb84eb16b8',151,'4395abd486d947d5ba2cd486b8c2f257','snapshot_gigabytes',-1,'2025-11-29 10:10:21','10bc0b19-2cf0-4cb4-a06e-cd95828efafc'),('2025-11-28 10:10:24.490658',NULL,'2025-11-28 10:10:24.567308',466,466,'fe5a177f7488487e910ff3a84521bd9b','45609330-97d6-43e0-a189-435babf5fc4b',145,'4395abd486d947d5ba2cd486b8c2f257','shares',-1,'2025-11-29 10:10:24',NULL),('2025-11-28 10:10:24.492728',NULL,'2025-11-28 10:10:24.567308',467,467,'fe5a177f7488487e910ff3a84521bd9b','2ec89152-1933-4ab6-a68b-c3ce88bb988e',144,'4395abd486d947d5ba2cd486b8c2f257','gigabytes',-1,'2025-11-29 10:10:24',NULL),('2025-11-28 10:10:24.511400',NULL,'2025-11-28 10:10:24.567308',468,468,NULL,'015f7536-cc9c-4dc7-ae60-7487456c9389',147,'4395abd486d947d5ba2cd486b8c2f257','shares',-1,'2025-11-29 10:10:24','10bc0b19-2cf0-4cb4-a06e-cd95828efafc'),('2025-11-28 10:10:24.512742',NULL,'2025-11-28 10:10:24.567308',469,469,NULL,'65fa1c83-5561-4675-904b-8833db5635f4',146,'4395abd486d947d5ba2cd486b8c2f257','gigabytes',-1,'2025-11-29 10:10:24','10bc0b19-2cf0-4cb4-a06e-cd95828efafc'),('2025-11-28 10:10:24.639812',NULL,'2025-11-28 10:10:24.657676',470,470,'b81484063c294e2b9fbd79c48d3a78e1','26bd07d9-3395-40ae-bd0f-8ea8995d0f4b',136,'8e3baf6078d441fead64f612139a9c5e','shares',-1,'2025-11-29 10:10:24',NULL),('2025-11-28 10:10:24.642240',NULL,'2025-11-28 10:10:24.657676',471,471,'b81484063c294e2b9fbd79c48d3a78e1','2677a050-bae9-462e-a5f2-fee24d695b2e',137,'8e3baf6078d441fead64f612139a9c5e','gigabytes',-1,'2025-11-29 10:10:24',NULL),('2025-11-28 10:10:24.649865',NULL,'2025-11-28 10:10:24.657676',472,472,NULL,'52f7d1a6-0c8f-4223-adb3-12e822292e3a',138,'8e3baf6078d441fead64f612139a9c5e','shares',-1,'2025-11-29 10:10:24','12de8a30-5c34-4d8e-ac9a-152a96e413e3'),('2025-11-28 10:10:24.650642',NULL,'2025-11-28 10:10:24.657676',473,473,NULL,'e44d823a-775d-451b-a2c7-d17ce370c7a6',139,'8e3baf6078d441fead64f612139a9c5e','gigabytes',-1,'2025-11-29 10:10:24','12de8a30-5c34-4d8e-ac9a-152a96e413e3'),('2025-11-28 10:10:25.005832',NULL,'2025-11-28 10:10:25.052762',474,474,'cbf66f4180d843eeafcfa90b799ce933','74c8fda0-1b1e-48d5-b69b-1d7e2f6781ef',152,'38de2f991c8946e4ad86ddc6b9c2ae73','shares',1,'2025-11-29 10:10:24',NULL),('2025-11-28 10:10:25.009701',NULL,'2025-11-28 10:10:25.052762',475,475,'cbf66f4180d843eeafcfa90b799ce933','20933572-1dc0-4cb0-9b86-fae68f2583d7',153,'38de2f991c8946e4ad86ddc6b9c2ae73','gigabytes',1,'2025-11-29 10:10:24',NULL),('2025-11-28 10:10:25.026943',NULL,'2025-11-28 10:10:25.052762',476,476,NULL,'aee97183-ba88-4603-9a1e-741e7d8f2d0c',154,'38de2f991c8946e4ad86ddc6b9c2ae73','shares',1,'2025-11-29 10:10:24','ee2272a1-6734-4413-816b-800e8e100609'),('2025-11-28 10:10:25.028285',NULL,'2025-11-28 10:10:25.052762',477,477,NULL,'8af3525f-64f3-492a-9ef2-b9ee7e6b62fd',155,'38de2f991c8946e4ad86ddc6b9c2ae73','gigabytes',1,'2025-11-29 10:10:24','ee2272a1-6734-4413-816b-800e8e100609'),('2025-11-28 10:10:25.053037',NULL,'2025-11-28 10:10:25.119585',478,478,'47cdb2911922414c87c44fadac1c1fbb','a8931a0a-e406-4f70-b16a-cfd08ad8fa2b',156,'a1ab6d5dbd57453f92ddf8599a8c5cff','shares',1,'2025-11-29 10:10:25',NULL),('2025-11-28 10:10:25.059178',NULL,'2025-11-28 10:10:25.119585',479,479,'47cdb2911922414c87c44fadac1c1fbb','7510b952-174a-41c0-8934-a7315e904dca',157,'a1ab6d5dbd57453f92ddf8599a8c5cff','gigabytes',1,'2025-11-29 10:10:25',NULL),('2025-11-28 10:10:25.082511',NULL,'2025-11-28 10:10:25.119585',480,480,NULL,'726dca8d-1946-4cf0-9058-6ec8471537d3',158,'a1ab6d5dbd57453f92ddf8599a8c5cff','shares',1,'2025-11-29 10:10:25','a4689c66-7480-4db7-9279-095cdd632232'),('2025-11-28 10:10:25.084367',NULL,'2025-11-28 10:10:25.119585',481,481,NULL,'417ea259-1fc9-4595-be12-fefac05a3060',159,'a1ab6d5dbd57453f92ddf8599a8c5cff','gigabytes',1,'2025-11-29 10:10:25','a4689c66-7480-4db7-9279-095cdd632232'),('2025-11-28 10:10:27.528237',NULL,'2025-11-28 10:10:27.569704',482,482,'b81484063c294e2b9fbd79c48d3a78e1','e296d90a-2f4c-4073-9ca1-cde21d773c79',136,'8e3baf6078d441fead64f612139a9c5e','shares',1,'2025-11-29 10:10:27',NULL),('2025-11-28 10:10:27.529690',NULL,'2025-11-28 10:10:27.569704',483,483,'b81484063c294e2b9fbd79c48d3a78e1','985938d1-abb6-4623-964e-2bfa6e09ec75',137,'8e3baf6078d441fead64f612139a9c5e','gigabytes',1,'2025-11-29 10:10:27',NULL),('2025-11-28 10:10:27.539214',NULL,'2025-11-28 10:10:27.569704',484,484,NULL,'0755ef1f-e002-4518-8339-fcbb9183ab7e',138,'8e3baf6078d441fead64f612139a9c5e','shares',1,'2025-11-29 10:10:27','12de8a30-5c34-4d8e-ac9a-152a96e413e3'),('2025-11-28 10:10:27.540496',NULL,'2025-11-28 10:10:27.569704',485,485,NULL,'4c9a2539-06a2-4f4f-b4ae-b7a3be705615',139,'8e3baf6078d441fead64f612139a9c5e','gigabytes',1,'2025-11-29 10:10:27','12de8a30-5c34-4d8e-ac9a-152a96e413e3'),('2025-11-28 10:10:28.230496',NULL,'2025-11-28 10:10:28.286989',486,486,'0cef63841aaf44849d79d226587c527c','4537baf1-09a3-434a-9288-b881cd343e98',161,'a65552de119e4309a43e9e85b3f7e533','shares',1,'2025-11-29 10:10:28',NULL),('2025-11-28 10:10:28.231843',NULL,'2025-11-28 10:10:28.286989',487,487,'0cef63841aaf44849d79d226587c527c','40667949-83ce-4704-974a-62de2260ba91',160,'a65552de119e4309a43e9e85b3f7e533','gigabytes',1,'2025-11-29 10:10:28',NULL),('2025-11-28 10:10:28.247996',NULL,'2025-11-28 10:10:28.286989',488,488,NULL,'aab83d6f-88dd-4bcc-ab44-8f0e058d2182',163,'a65552de119e4309a43e9e85b3f7e533','shares',1,'2025-11-29 10:10:28','26a485c3-64f3-4dbe-ac98-4f322b0c870c'),('2025-11-28 10:10:28.250249',NULL,'2025-11-28 10:10:28.286989',489,489,NULL,'22f83478-b1f4-4fef-a8a6-fbe45e532c4a',162,'a65552de119e4309a43e9e85b3f7e533','gigabytes',1,'2025-11-29 10:10:28','26a485c3-64f3-4dbe-ac98-4f322b0c870c'),('2025-11-28 10:10:28.507222',NULL,'2025-11-28 10:10:28.585743',490,490,'47cdb2911922414c87c44fadac1c1fbb','74a60971-1f62-4e41-a803-b54f17db0115',164,'a1ab6d5dbd57453f92ddf8599a8c5cff','snapshots',1,'2025-11-29 10:10:28',NULL),('2025-11-28 10:10:28.508317',NULL,'2025-11-28 10:10:28.585743',491,491,'47cdb2911922414c87c44fadac1c1fbb','19db3aaf-1ef7-4cba-ae75-73a23b230fac',165,'a1ab6d5dbd57453f92ddf8599a8c5cff','snapshot_gigabytes',1,'2025-11-29 10:10:28',NULL),('2025-11-28 10:10:28.519534',NULL,'2025-11-28 10:10:28.585743',492,492,NULL,'d60d3696-3c12-4632-9738-fd1c132af05b',166,'a1ab6d5dbd57453f92ddf8599a8c5cff','snapshots',1,'2025-11-29 10:10:28','a4689c66-7480-4db7-9279-095cdd632232'),('2025-11-28 10:10:28.520788',NULL,'2025-11-28 10:10:28.585743',493,493,NULL,'0b32f60e-557d-4fb3-b76d-9bccb3962e19',167,'a1ab6d5dbd57453f92ddf8599a8c5cff','snapshot_gigabytes',1,'2025-11-29 10:10:28','a4689c66-7480-4db7-9279-095cdd632232'),('2025-11-28 10:10:30.029629',NULL,'2025-11-28 10:10:30.071995',494,494,'677aab2179fe42298307c846ff69184a','afbdddad-dd20-426b-b7e7-dcbb0e3bfc3b',169,'e0c40d8bf169430ba137dca405115c59','shares',1,'2025-11-29 10:10:30',NULL),('2025-11-28 10:10:30.030590',NULL,'2025-11-28 10:10:30.071995',495,495,'677aab2179fe42298307c846ff69184a','6f3d8892-9a13-4e58-9c34-02b1c7064275',168,'e0c40d8bf169430ba137dca405115c59','gigabytes',1,'2025-11-29 10:10:30',NULL),('2025-11-28 10:10:30.048633',NULL,'2025-11-28 10:10:30.071995',496,496,NULL,'936a7db1-920a-4c9e-8b02-70f41796cfcf',171,'e0c40d8bf169430ba137dca405115c59','shares',1,'2025-11-29 10:10:30','bab89685-cea5-4f03-919d-475c107118d0'),('2025-11-28 10:10:30.050016',NULL,'2025-11-28 10:10:30.071995',497,497,NULL,'27de613a-7418-4163-9eb1-64e9f09ad97d',170,'e0c40d8bf169430ba137dca405115c59','gigabytes',1,'2025-11-29 10:10:30','bab89685-cea5-4f03-919d-475c107118d0'),('2025-11-28 10:10:31.883187',NULL,'2025-11-28 10:10:31.947677',498,498,'47cdb2911922414c87c44fadac1c1fbb','5a56f9c4-eb8d-459e-baf8-ecb414c895a2',156,'a1ab6d5dbd57453f92ddf8599a8c5cff','shares',1,'2025-11-29 10:10:31',NULL),('2025-11-28 10:10:31.885405',NULL,'2025-11-28 10:10:31.947677',499,499,'47cdb2911922414c87c44fadac1c1fbb','a39afa03-33a0-4df7-a4a5-40e0112291e3',157,'a1ab6d5dbd57453f92ddf8599a8c5cff','gigabytes',1,'2025-11-29 10:10:31',NULL),('2025-11-28 10:10:31.893410',NULL,'2025-11-28 10:10:31.947677',500,500,NULL,'e1fce38f-186e-4e57-9e89-befbf963428c',158,'a1ab6d5dbd57453f92ddf8599a8c5cff','shares',1,'2025-11-29 10:10:31','a4689c66-7480-4db7-9279-095cdd632232'),('2025-11-28 10:10:31.894828',NULL,'2025-11-28 10:10:31.947677',501,501,NULL,'8a35ec4f-08b5-4a5d-8017-d90646b579a3',159,'a1ab6d5dbd57453f92ddf8599a8c5cff','gigabytes',1,'2025-11-29 10:10:31','a4689c66-7480-4db7-9279-095cdd632232'),('2025-11-28 10:10:37.323433',NULL,'2025-11-28 10:10:37.357870',502,502,'3602eb59752942f68890c3d4bb1ab475','43a9d5da-d970-488e-a77b-7abab6f01780',173,'7683e4ed98894de19dc2538cc36bcd6c','shares',1,'2025-11-29 10:10:37',NULL),('2025-11-28 10:10:37.325859',NULL,'2025-11-28 10:10:37.357870',503,503,'3602eb59752942f68890c3d4bb1ab475','5f8092b1-46da-4b8b-a387-34c24327cfe6',172,'7683e4ed98894de19dc2538cc36bcd6c','gigabytes',1,'2025-11-29 10:10:37',NULL),('2025-11-28 10:10:37.335666',NULL,'2025-11-28 10:10:37.357870',504,504,NULL,'91848f6a-6bdb-45a8-afe1-2657ca490926',175,'7683e4ed98894de19dc2538cc36bcd6c','shares',1,'2025-11-29 10:10:37','3ad5f084-f3cc-4797-ab97-02662574deca'),('2025-11-28 10:10:37.336970',NULL,'2025-11-28 10:10:37.357870',505,505,NULL,'1bae85b6-b23a-4202-8387-04e691875428',174,'7683e4ed98894de19dc2538cc36bcd6c','gigabytes',1,'2025-11-29 10:10:37','3ad5f084-f3cc-4797-ab97-02662574deca'),('2025-11-28 10:10:40.662309',NULL,'2025-11-28 10:10:40.904014',506,506,'b81484063c294e2b9fbd79c48d3a78e1','fafcf2c4-a498-4619-8ca7-f4cc1d0c75b1',136,'8e3baf6078d441fead64f612139a9c5e','shares',-1,'2025-11-29 10:10:40',NULL),('2025-11-28 10:10:40.665888',NULL,'2025-11-28 10:10:40.904014',507,507,'b81484063c294e2b9fbd79c48d3a78e1','28a15802-a35e-4dbc-bd59-b65f23a8d140',137,'8e3baf6078d441fead64f612139a9c5e','gigabytes',-1,'2025-11-29 10:10:40',NULL),('2025-11-28 10:10:40.818451',NULL,'2025-11-28 10:10:40.904014',508,508,NULL,'2061fc4c-204f-4fb9-b14a-f9b860f53d89',138,'8e3baf6078d441fead64f612139a9c5e','shares',-1,'2025-11-29 10:10:40','12de8a30-5c34-4d8e-ac9a-152a96e413e3'),('2025-11-28 10:10:40.836452',NULL,'2025-11-28 10:10:40.904014',509,509,NULL,'53bbfc76-324a-4c9e-bcfd-9c0cff44fb4a',139,'8e3baf6078d441fead64f612139a9c5e','gigabytes',-1,'2025-11-29 10:10:40','12de8a30-5c34-4d8e-ac9a-152a96e413e3'),('2025-11-28 10:10:41.043876',NULL,'2025-11-28 10:10:41.063348',510,510,'677aab2179fe42298307c846ff69184a','785c74f6-e672-43ea-9ce4-269279ace629',169,'e0c40d8bf169430ba137dca405115c59','shares',-1,'2025-11-29 10:10:40',NULL),('2025-11-28 10:10:41.044820',NULL,'2025-11-28 10:10:41.063348',511,511,'677aab2179fe42298307c846ff69184a','a2e589aa-4ce4-47d2-a8eb-bdb057e64984',168,'e0c40d8bf169430ba137dca405115c59','gigabytes',-1,'2025-11-29 10:10:40',NULL),('2025-11-28 10:10:41.051913',NULL,'2025-11-28 10:10:41.063348',512,512,NULL,'e8956d73-3acc-4b26-87a3-2d230e395f4a',171,'e0c40d8bf169430ba137dca405115c59','shares',-1,'2025-11-29 10:10:40','bab89685-cea5-4f03-919d-475c107118d0'),('2025-11-28 10:10:41.052879',NULL,'2025-11-28 10:10:41.063348',513,513,NULL,'5b2c70ff-10d4-490a-a17e-af533a3ba26b',170,'e0c40d8bf169430ba137dca405115c59','gigabytes',-1,'2025-11-29 10:10:40','bab89685-cea5-4f03-919d-475c107118d0'),('2025-11-28 10:10:42.159788',NULL,'2025-11-28 10:10:42.198753',514,514,'b81484063c294e2b9fbd79c48d3a78e1','5386c874-ce21-4dcb-be9b-3b848315a82d',136,'8e3baf6078d441fead64f612139a9c5e','shares',1,'2025-11-29 10:10:42',NULL),('2025-11-28 10:10:42.161659',NULL,'2025-11-28 10:10:42.198753',515,515,'b81484063c294e2b9fbd79c48d3a78e1','945b4883-76ca-4961-a8a6-a07d1e01b721',137,'8e3baf6078d441fead64f612139a9c5e','gigabytes',1,'2025-11-29 10:10:42',NULL),('2025-11-28 10:10:42.169118',NULL,'2025-11-28 10:10:42.184127',516,516,'0cef63841aaf44849d79d226587c527c','a4dca53a-6316-4c34-b161-fc60377102df',161,'a65552de119e4309a43e9e85b3f7e533','shares',-1,'2025-11-29 10:10:42',NULL),('2025-11-28 10:10:42.170188',NULL,'2025-11-28 10:10:42.184127',517,517,'0cef63841aaf44849d79d226587c527c','410f73ab-c538-444a-82dd-f6639874cec5',160,'a65552de119e4309a43e9e85b3f7e533','gigabytes',-1,'2025-11-29 10:10:42',NULL),('2025-11-28 10:10:42.172065',NULL,'2025-11-28 10:10:42.198753',518,518,NULL,'669cc13f-66d4-4b56-9778-474b61d416bd',138,'8e3baf6078d441fead64f612139a9c5e','shares',1,'2025-11-29 10:10:42','12de8a30-5c34-4d8e-ac9a-152a96e413e3'),('2025-11-28 10:10:42.173943',NULL,'2025-11-28 10:10:42.198753',519,519,NULL,'0f9ac6ed-395a-4552-be11-d83b367d5bd2',139,'8e3baf6078d441fead64f612139a9c5e','gigabytes',1,'2025-11-29 10:10:42','12de8a30-5c34-4d8e-ac9a-152a96e413e3'),('2025-11-28 10:10:42.176969',NULL,'2025-11-28 10:10:42.184127',520,520,NULL,'490376be-b9b5-42ad-88fe-0afb8e24b031',163,'a65552de119e4309a43e9e85b3f7e533','shares',-1,'2025-11-29 10:10:42','26a485c3-64f3-4dbe-ac98-4f322b0c870c'),('2025-11-28 10:10:42.177825',NULL,'2025-11-28 10:10:42.184127',521,521,NULL,'9f04f26d-78b5-489f-8713-a6f5f181d4bd',162,'a65552de119e4309a43e9e85b3f7e533','gigabytes',-1,'2025-11-29 10:10:42','26a485c3-64f3-4dbe-ac98-4f322b0c870c'),('2025-11-28 10:10:43.855166',NULL,'2025-11-28 10:10:44.095932',522,522,'fa0d986262574d1aa5bfcc3cd2fa05e7','badb5078-f2d8-4313-ae14-5e06cbc39fe0',176,'1a203a668ad442b7a0e1a122f4122c81','shares',1,'2025-11-29 10:10:43',NULL),('2025-11-28 10:10:43.856628',NULL,'2025-11-28 10:10:44.095932',523,523,'fa0d986262574d1aa5bfcc3cd2fa05e7','563a0f8f-41bd-41c2-912a-2a2b459fe9c5',177,'1a203a668ad442b7a0e1a122f4122c81','gigabytes',1,'2025-11-29 10:10:43',NULL),('2025-11-28 10:10:43.892806',NULL,'2025-11-28 10:10:44.095932',524,524,NULL,'e634c6cc-3329-4f35-ba6a-20324487b673',178,'1a203a668ad442b7a0e1a122f4122c81','shares',1,'2025-11-29 10:10:43','3ad5f084-f3cc-4797-ab97-02662574deca'),('2025-11-28 10:10:43.893886',NULL,'2025-11-28 10:10:44.095932',525,525,NULL,'10b73940-1249-4fda-a793-4981b7b72462',179,'1a203a668ad442b7a0e1a122f4122c81','gigabytes',1,'2025-11-29 10:10:43','3ad5f084-f3cc-4797-ab97-02662574deca'),('2025-11-28 10:10:44.484599',NULL,'2025-11-28 10:10:44.729424',526,526,'0e4a868caf7745428b930f5df0b3e2fe','67d2ef1c-1443-4c58-af2e-3ef5477b315e',180,'ab97bc5516b54755ac262ba68a804978','shares',1,'2025-11-29 10:10:44',NULL),('2025-11-28 10:10:44.486942',NULL,'2025-11-28 10:10:44.729424',527,527,'0e4a868caf7745428b930f5df0b3e2fe','8099ea61-c397-4f1c-8df9-f70de0fecda1',181,'ab97bc5516b54755ac262ba68a804978','gigabytes',1,'2025-11-29 10:10:44',NULL),('2025-11-28 10:10:44.653198',NULL,'2025-11-28 10:10:44.729424',528,528,NULL,'91a94522-da6f-4544-9219-9bd199f4fdd4',182,'ab97bc5516b54755ac262ba68a804978','shares',1,'2025-11-29 10:10:44','6cd102ad-9540-4dde-8628-56d0d62564e3'),('2025-11-28 10:10:44.654802',NULL,'2025-11-28 10:10:44.729424',529,529,NULL,'1de14bd1-626c-4d8b-936f-e3e04eb5ca7c',183,'ab97bc5516b54755ac262ba68a804978','gigabytes',1,'2025-11-29 10:10:44','6cd102ad-9540-4dde-8628-56d0d62564e3'),('2025-11-28 10:10:47.015837',NULL,'2025-11-28 10:10:47.029486',530,530,'b81484063c294e2b9fbd79c48d3a78e1','4e105014-9207-42c7-b6ca-16245bae773c',136,'8e3baf6078d441fead64f612139a9c5e','shares',-1,'2025-11-29 10:10:46',NULL),('2025-11-28 10:10:47.016614',NULL,'2025-11-28 10:10:47.029486',531,531,'b81484063c294e2b9fbd79c48d3a78e1','c78d0bfb-8c5b-48ca-98a4-18027757d558',137,'8e3baf6078d441fead64f612139a9c5e','gigabytes',-1,'2025-11-29 10:10:46',NULL),('2025-11-28 10:10:47.021365',NULL,'2025-11-28 10:10:47.029486',532,532,NULL,'69801c41-79e1-4938-998a-9a774234cdac',138,'8e3baf6078d441fead64f612139a9c5e','shares',-1,'2025-11-29 10:10:46','12de8a30-5c34-4d8e-ac9a-152a96e413e3'),('2025-11-28 10:10:47.021979',NULL,'2025-11-28 10:10:47.029486',533,533,NULL,'0b12c3eb-f6ac-4ec4-a490-4b8bd0d228aa',139,'8e3baf6078d441fead64f612139a9c5e','gigabytes',-1,'2025-11-29 10:10:46','12de8a30-5c34-4d8e-ac9a-152a96e413e3'),('2025-11-28 10:10:47.902298',NULL,'2025-11-28 10:10:47.925691',534,534,'fa0d986262574d1aa5bfcc3cd2fa05e7','cd5337a9-5678-4056-9a89-b762628c91e8',176,'1a203a668ad442b7a0e1a122f4122c81','shares',-1,'2025-11-29 10:10:47',NULL),('2025-11-28 10:10:47.903188',NULL,'2025-11-28 10:10:47.925691',535,535,'fa0d986262574d1aa5bfcc3cd2fa05e7','ac26a01d-5d3d-4532-a4b6-cedbde643224',177,'1a203a668ad442b7a0e1a122f4122c81','gigabytes',-1,'2025-11-29 10:10:47',NULL),('2025-11-28 10:10:47.911247',NULL,'2025-11-28 10:10:47.925691',536,536,NULL,'dade363e-f5fa-401c-8b32-c269eb1af976',178,'1a203a668ad442b7a0e1a122f4122c81','shares',-1,'2025-11-29 10:10:47','3ad5f084-f3cc-4797-ab97-02662574deca'),('2025-11-28 10:10:47.916083',NULL,'2025-11-28 10:10:47.925691',537,537,NULL,'7e8faf41-bba1-4411-832a-06aade4d7bd2',179,'1a203a668ad442b7a0e1a122f4122c81','gigabytes',-1,'2025-11-29 10:10:47','3ad5f084-f3cc-4797-ab97-02662574deca'),('2025-11-28 10:10:47.966656',NULL,'2025-11-28 10:10:48.044269',538,538,'0e4a868caf7745428b930f5df0b3e2fe','b191da60-e263-4721-90ce-2edc9502ea8e',184,'ab97bc5516b54755ac262ba68a804978','snapshots',1,'2025-11-29 10:10:47',NULL),('2025-11-28 10:10:47.967957',NULL,'2025-11-28 10:10:48.044269',539,539,'0e4a868caf7745428b930f5df0b3e2fe','045bd395-6f36-472e-98bf-0509b91a450e',185,'ab97bc5516b54755ac262ba68a804978','snapshot_gigabytes',1,'2025-11-29 10:10:47',NULL),('2025-11-28 10:10:47.981750',NULL,'2025-11-28 10:10:48.044269',540,540,NULL,'42702f5d-1973-4862-8568-150e02f10917',186,'ab97bc5516b54755ac262ba68a804978','snapshots',1,'2025-11-29 10:10:47','6cd102ad-9540-4dde-8628-56d0d62564e3'),('2025-11-28 10:10:47.983282',NULL,'2025-11-28 10:10:48.044269',541,541,NULL,'1a23609a-a057-43c2-b6be-d6f5a78262ef',187,'ab97bc5516b54755ac262ba68a804978','snapshot_gigabytes',1,'2025-11-29 10:10:47','6cd102ad-9540-4dde-8628-56d0d62564e3'),('2025-11-28 10:10:50.706765',NULL,'2025-11-28 10:10:50.737771',542,542,'1deacee2ac724bf2ad53fa5464f5376c','8261fbd5-53d0-4084-8a54-94c2aae87961',188,'39ffeead9f734f13b1a489e1ce8313ab','shares',1,'2025-11-29 10:10:50',NULL),('2025-11-28 10:10:50.708098',NULL,'2025-11-28 10:10:50.737771',543,543,'1deacee2ac724bf2ad53fa5464f5376c','7cad0ec6-40fc-410b-8f95-d2bd1778734f',189,'39ffeead9f734f13b1a489e1ce8313ab','gigabytes',1,'2025-11-29 10:10:50',NULL),('2025-11-28 10:10:50.719055',NULL,'2025-11-28 10:10:50.737771',544,544,NULL,'b069fa3a-11a4-4c16-a14b-3ea5617e4de4',190,'39ffeead9f734f13b1a489e1ce8313ab','shares',1,'2025-11-29 10:10:50','eeb58100-1c78-4a03-b14f-9f29610af10b'),('2025-11-28 10:10:50.720182',NULL,'2025-11-28 10:10:50.737771',545,545,NULL,'e4865546-6a22-4817-99a2-8764ce0f18e8',191,'39ffeead9f734f13b1a489e1ce8313ab','gigabytes',1,'2025-11-29 10:10:50','eeb58100-1c78-4a03-b14f-9f29610af10b'),('2025-11-28 10:10:51.193710',NULL,'2025-11-28 10:10:51.207395',546,546,'3602eb59752942f68890c3d4bb1ab475','91d80eb8-98c2-43d8-be7d-e195edf640a4',173,'7683e4ed98894de19dc2538cc36bcd6c','shares',-1,'2025-11-29 10:10:51',NULL),('2025-11-28 10:10:51.194567',NULL,'2025-11-28 10:10:51.207395',547,547,'3602eb59752942f68890c3d4bb1ab475','41d44bd4-d80e-4ad2-9b98-43933c02c1ef',172,'7683e4ed98894de19dc2538cc36bcd6c','gigabytes',-1,'2025-11-29 10:10:51',NULL),('2025-11-28 10:10:51.199755',NULL,'2025-11-28 10:10:51.207395',548,548,NULL,'5155c830-237f-4abc-8739-e6f4749f26e5',175,'7683e4ed98894de19dc2538cc36bcd6c','shares',-1,'2025-11-29 10:10:51','3ad5f084-f3cc-4797-ab97-02662574deca'),('2025-11-28 10:10:51.200440',NULL,'2025-11-28 10:10:51.207395',549,549,NULL,'11364fc6-2e8b-4178-be00-82d7da87f619',174,'7683e4ed98894de19dc2538cc36bcd6c','gigabytes',-1,'2025-11-29 10:10:51','3ad5f084-f3cc-4797-ab97-02662574deca'),('2025-11-28 10:10:51.765491',NULL,'2025-11-28 10:10:51.788046',550,550,'0e4a868caf7745428b930f5df0b3e2fe','ad07bde2-77a4-4452-9e01-a9adb5dd2828',180,'ab97bc5516b54755ac262ba68a804978','shares',1,'2025-11-29 10:10:51',NULL),('2025-11-28 10:10:51.766602',NULL,'2025-11-28 10:10:51.788046',551,551,'0e4a868caf7745428b930f5df0b3e2fe','637be31f-74e2-4156-8942-e7b108fce836',181,'ab97bc5516b54755ac262ba68a804978','gigabytes',1,'2025-11-29 10:10:51',NULL),('2025-11-28 10:10:51.771485',NULL,'2025-11-28 10:10:51.788046',552,552,NULL,'00cfade1-1ce2-4c8e-9e81-ddd2ba23db1f',182,'ab97bc5516b54755ac262ba68a804978','shares',1,'2025-11-29 10:10:51','6cd102ad-9540-4dde-8628-56d0d62564e3'),('2025-11-28 10:10:51.772414',NULL,'2025-11-28 10:10:51.788046',553,553,NULL,'0983d0aa-6585-46be-a188-4591b5d8b1a1',183,'ab97bc5516b54755ac262ba68a804978','gigabytes',1,'2025-11-29 10:10:51','6cd102ad-9540-4dde-8628-56d0d62564e3'),('2025-11-28 10:10:51.806590',NULL,'2025-11-28 10:10:51.824631',554,554,'b81484063c294e2b9fbd79c48d3a78e1','c38353c8-90ee-4dde-a277-dd58222780ee',136,'8e3baf6078d441fead64f612139a9c5e','shares',-1,'2025-11-29 10:10:51',NULL),('2025-11-28 10:10:51.807245',NULL,'2025-11-28 10:10:51.824631',555,555,'b81484063c294e2b9fbd79c48d3a78e1','bd48697b-a31c-471e-9f7f-9d52aa85c71c',137,'8e3baf6078d441fead64f612139a9c5e','gigabytes',-1,'2025-11-29 10:10:51',NULL),('2025-11-28 10:10:51.813369',NULL,'2025-11-28 10:10:51.824631',556,556,NULL,'dbcac84e-66d0-4df3-9101-b23ae68e35bc',138,'8e3baf6078d441fead64f612139a9c5e','shares',-1,'2025-11-29 10:10:51','12de8a30-5c34-4d8e-ac9a-152a96e413e3'),('2025-11-28 10:10:51.814063',NULL,'2025-11-28 10:10:51.824631',557,557,NULL,'2fc9e6a0-bdad-4284-bcd1-386870d7485a',139,'8e3baf6078d441fead64f612139a9c5e','gigabytes',-1,'2025-11-29 10:10:51','12de8a30-5c34-4d8e-ac9a-152a96e413e3'),('2025-11-28 10:10:53.938404',NULL,'2025-11-28 10:10:54.155703',558,558,'fa0d986262574d1aa5bfcc3cd2fa05e7','bb4d19bb-a9d8-4965-aa32-adce7024e3e0',176,'1a203a668ad442b7a0e1a122f4122c81','shares',1,'2025-11-29 10:10:53',NULL),('2025-11-28 10:10:53.940404',NULL,'2025-11-28 10:10:54.155703',559,559,'fa0d986262574d1aa5bfcc3cd2fa05e7','4ca03245-2ecd-4aec-ac85-57004406b979',177,'1a203a668ad442b7a0e1a122f4122c81','gigabytes',1,'2025-11-29 10:10:53',NULL),('2025-11-28 10:10:53.952892',NULL,'2025-11-28 10:10:54.203701',560,560,'1deacee2ac724bf2ad53fa5464f5376c','801445ae-3118-4636-bad8-c5a62f41214c',192,'39ffeead9f734f13b1a489e1ce8313ab','snapshots',1,'2025-11-29 10:10:53',NULL),('2025-11-28 10:10:53.954289',NULL,'2025-11-28 10:10:54.203701',561,561,'1deacee2ac724bf2ad53fa5464f5376c','918ba784-327a-4de2-8a2e-1cd2221f5d25',193,'39ffeead9f734f13b1a489e1ce8313ab','snapshot_gigabytes',1,'2025-11-29 10:10:53',NULL),('2025-11-28 10:10:53.992147',NULL,'2025-11-28 10:10:54.167292',562,562,'b44ef903be4543c38c7ff39887ede90c','aaeb47e8-e24f-4a18-95b9-d2a3f92dacc9',195,'1562d9ae673b4a5ea5a1a571bd0ea2c8','shares',1,'2025-11-29 10:10:53',NULL),('2025-11-28 10:10:53.993418',NULL,'2025-11-28 10:10:54.167292',563,563,'b44ef903be4543c38c7ff39887ede90c','cad26980-9ab4-48fb-a634-c314fb71bad4',194,'1562d9ae673b4a5ea5a1a571bd0ea2c8','gigabytes',1,'2025-11-29 10:10:53',NULL),('2025-11-28 10:10:54.071237',NULL,'2025-11-28 10:10:54.155703',564,564,NULL,'d20a8e21-baef-4720-8e0f-2873e52b39d0',178,'1a203a668ad442b7a0e1a122f4122c81','shares',1,'2025-11-29 10:10:53','3ad5f084-f3cc-4797-ab97-02662574deca'),('2025-11-28 10:10:54.072585',NULL,'2025-11-28 10:10:54.155703',565,565,NULL,'82ffdcaf-9a20-4f3f-bc08-e6534a4f24c8',179,'1a203a668ad442b7a0e1a122f4122c81','gigabytes',1,'2025-11-29 10:10:53','3ad5f084-f3cc-4797-ab97-02662574deca'),('2025-11-28 10:10:54.094671',NULL,'2025-11-28 10:10:54.167292',566,566,NULL,'169397aa-882d-486f-b9a6-edb77dfcddbd',198,'1562d9ae673b4a5ea5a1a571bd0ea2c8','shares',1,'2025-11-29 10:10:53','5ddfe74e-bc86-429d-b4a5-b582d6d4201d'),('2025-11-28 10:10:54.095657',NULL,'2025-11-28 10:10:54.167292',567,567,NULL,'ac707127-61f0-49a3-9e71-db05a3e36b62',196,'1562d9ae673b4a5ea5a1a571bd0ea2c8','gigabytes',1,'2025-11-29 10:10:53','5ddfe74e-bc86-429d-b4a5-b582d6d4201d'),('2025-11-28 10:10:54.096884',NULL,'2025-11-28 10:10:54.203701',568,568,NULL,'8ea34b8c-8c36-44a2-920b-6f86a643f01a',197,'39ffeead9f734f13b1a489e1ce8313ab','snapshots',1,'2025-11-29 10:10:53','eeb58100-1c78-4a03-b14f-9f29610af10b'),('2025-11-28 10:10:54.098458',NULL,'2025-11-28 10:10:54.203701',569,569,NULL,'bfac0e2f-10ee-40cb-a32d-4dba09c128bb',199,'39ffeead9f734f13b1a489e1ce8313ab','snapshot_gigabytes',1,'2025-11-29 10:10:53','eeb58100-1c78-4a03-b14f-9f29610af10b'),('2025-11-28 10:10:55.395556',NULL,'2025-11-28 10:10:55.414433',570,570,'0e4a868caf7745428b930f5df0b3e2fe','31b26f86-02c2-4f83-b527-cd0c77f31d31',180,'ab97bc5516b54755ac262ba68a804978','shares',-1,'2025-11-29 10:10:55',NULL),('2025-11-28 10:10:55.396272',NULL,'2025-11-28 10:10:55.414433',571,571,'0e4a868caf7745428b930f5df0b3e2fe','541df3bc-1e56-4209-919a-612d39d2743c',181,'ab97bc5516b54755ac262ba68a804978','gigabytes',-1,'2025-11-29 10:10:55',NULL),('2025-11-28 10:10:55.402389',NULL,'2025-11-28 10:10:55.414433',572,572,NULL,'071fc264-e6a6-4d07-b1ee-1610a6834cc9',182,'ab97bc5516b54755ac262ba68a804978','shares',-1,'2025-11-29 10:10:55','6cd102ad-9540-4dde-8628-56d0d62564e3'),('2025-11-28 10:10:55.403333',NULL,'2025-11-28 10:10:55.414433',573,573,NULL,'c15ccfc6-e271-4fa2-8656-6e40debcefd3',183,'ab97bc5516b54755ac262ba68a804978','gigabytes',-1,'2025-11-29 10:10:55','6cd102ad-9540-4dde-8628-56d0d62564e3'),('2025-11-28 10:10:58.065245',NULL,'2025-11-28 10:10:58.110392',574,574,'fa0d986262574d1aa5bfcc3cd2fa05e7','31c8a9ca-7691-4bb9-82c4-338dc1001dd3',176,'1a203a668ad442b7a0e1a122f4122c81','shares',-1,'2025-11-29 10:10:58',NULL),('2025-11-28 10:10:58.067561',NULL,'2025-11-28 10:10:58.110392',575,575,'fa0d986262574d1aa5bfcc3cd2fa05e7','aa2d0695-db1b-416f-a65b-75d5ebcad492',177,'1a203a668ad442b7a0e1a122f4122c81','gigabytes',-1,'2025-11-29 10:10:58',NULL),('2025-11-28 10:10:58.085293',NULL,'2025-11-28 10:10:58.110392',576,576,NULL,'a444c43c-3eb4-4bd9-a098-addc01bd25b7',178,'1a203a668ad442b7a0e1a122f4122c81','shares',-1,'2025-11-29 10:10:58','3ad5f084-f3cc-4797-ab97-02662574deca'),('2025-11-28 10:10:58.088603',NULL,'2025-11-28 10:10:58.110392',577,577,NULL,'d34df511-6360-43e2-8fc9-0d6b89298b1e',179,'1a203a668ad442b7a0e1a122f4122c81','gigabytes',-1,'2025-11-29 10:10:58','3ad5f084-f3cc-4797-ab97-02662574deca'),('2025-11-28 10:10:58.306988',NULL,'2025-11-28 10:10:58.348984',578,578,'b44ef903be4543c38c7ff39887ede90c','1633e8ac-1607-4141-97f6-1a9b5179ffca',195,'1562d9ae673b4a5ea5a1a571bd0ea2c8','shares',1,'2025-11-29 10:10:58',NULL),('2025-11-28 10:10:58.308536',NULL,'2025-11-28 10:10:58.348984',579,579,'b44ef903be4543c38c7ff39887ede90c','bceb4997-83fa-4811-9618-16573e268531',194,'1562d9ae673b4a5ea5a1a571bd0ea2c8','gigabytes',1,'2025-11-29 10:10:58',NULL),('2025-11-28 10:10:58.318728',NULL,'2025-11-28 10:10:58.348984',580,580,NULL,'bc1930a8-2569-43b0-a296-b8722171a8d0',198,'1562d9ae673b4a5ea5a1a571bd0ea2c8','shares',1,'2025-11-29 10:10:58','5ddfe74e-bc86-429d-b4a5-b582d6d4201d'),('2025-11-28 10:10:58.320702',NULL,'2025-11-28 10:10:58.348984',581,581,NULL,'36ea0a1a-c605-4feb-aaa3-9070449d9078',196,'1562d9ae673b4a5ea5a1a571bd0ea2c8','gigabytes',1,'2025-11-29 10:10:58','5ddfe74e-bc86-429d-b4a5-b582d6d4201d'),('2025-11-28 10:10:58.492955',NULL,'2025-11-28 10:10:58.531722',582,582,'0e4a868caf7745428b930f5df0b3e2fe','befee2cc-98ef-47d9-a022-0dc572bcea95',180,'ab97bc5516b54755ac262ba68a804978','shares',1,'2025-11-29 10:10:58',NULL),('2025-11-28 10:10:58.494812',NULL,'2025-11-28 10:10:58.531722',583,583,'0e4a868caf7745428b930f5df0b3e2fe','80a3f2b8-ec5e-4cab-8446-06875bafed85',181,'ab97bc5516b54755ac262ba68a804978','gigabytes',2,'2025-11-29 10:10:58',NULL),('2025-11-28 10:10:58.501679',NULL,'2025-11-28 10:10:58.531722',584,584,NULL,'1172adc8-c126-46d4-8e87-2ec5a9d1bf0c',182,'ab97bc5516b54755ac262ba68a804978','shares',1,'2025-11-29 10:10:58','6cd102ad-9540-4dde-8628-56d0d62564e3'),('2025-11-28 10:10:58.503413',NULL,'2025-11-28 10:10:58.531722',585,585,NULL,'c09d7340-0375-4210-aa74-fd3f98714336',183,'ab97bc5516b54755ac262ba68a804978','gigabytes',2,'2025-11-29 10:10:58','6cd102ad-9540-4dde-8628-56d0d62564e3'),('2025-11-28 10:10:58.670188',NULL,'2025-11-28 10:10:58.789155',586,586,'1deacee2ac724bf2ad53fa5464f5376c','397066e0-8042-4f86-9fd2-861a58054276',192,'39ffeead9f734f13b1a489e1ce8313ab','snapshots',-1,'2025-11-29 10:10:58',NULL),('2025-11-28 10:10:58.671169',NULL,'2025-11-28 10:10:58.789155',587,587,'1deacee2ac724bf2ad53fa5464f5376c','31bad887-b9a1-446a-a2c6-a7e94332ed5e',193,'39ffeead9f734f13b1a489e1ce8313ab','snapshot_gigabytes',-1,'2025-11-29 10:10:58',NULL),('2025-11-28 10:10:58.694934',NULL,'2025-11-28 10:10:58.789155',588,588,NULL,'71ac5171-9d0a-4a6f-88f4-ce7e22f3a06b',197,'39ffeead9f734f13b1a489e1ce8313ab','snapshots',-1,'2025-11-29 10:10:58','eeb58100-1c78-4a03-b14f-9f29610af10b'),('2025-11-28 10:10:58.701527',NULL,'2025-11-28 10:10:58.789155',589,589,NULL,'9a7cdf26-42c4-4317-ab04-bfddd91a8999',199,'39ffeead9f734f13b1a489e1ce8313ab','snapshot_gigabytes',-1,'2025-11-29 10:10:58','eeb58100-1c78-4a03-b14f-9f29610af10b'),('2025-11-28 10:11:01.820201',NULL,'2025-11-28 10:11:01.852612',590,590,'1deacee2ac724bf2ad53fa5464f5376c','cb9eef4b-415b-413a-9308-530cf76ee579',188,'39ffeead9f734f13b1a489e1ce8313ab','shares',-1,'2025-11-29 10:11:01',NULL),('2025-11-28 10:11:01.821061',NULL,'2025-11-28 10:11:01.852612',591,591,'1deacee2ac724bf2ad53fa5464f5376c','cbf0b2e9-7918-4bdc-a171-f1a0190c6165',189,'39ffeead9f734f13b1a489e1ce8313ab','gigabytes',-1,'2025-11-29 10:11:01',NULL),('2025-11-28 10:11:01.837153',NULL,'2025-11-28 10:11:01.852612',592,592,NULL,'1a77e181-d478-4d09-a44c-dc883db28619',190,'39ffeead9f734f13b1a489e1ce8313ab','shares',-1,'2025-11-29 10:11:01','eeb58100-1c78-4a03-b14f-9f29610af10b'),('2025-11-28 10:11:01.841981',NULL,'2025-11-28 10:11:01.852612',593,593,NULL,'e8af6412-34f2-4571-aad0-0d0af3333317',191,'39ffeead9f734f13b1a489e1ce8313ab','gigabytes',-1,'2025-11-29 10:11:01','eeb58100-1c78-4a03-b14f-9f29610af10b'),('2025-11-28 10:11:02.421156',NULL,'2025-11-28 10:11:03.120105',594,594,'0e4a868caf7745428b930f5df0b3e2fe','b7848cc3-4f30-4341-a570-f0c120ce3036',180,'ab97bc5516b54755ac262ba68a804978','shares',-1,'2025-11-29 10:11:02',NULL),('2025-11-28 10:11:02.901345',NULL,'2025-11-28 10:11:03.120105',595,595,'0e4a868caf7745428b930f5df0b3e2fe','837d3f99-d432-4eca-9cbb-e55ea768f162',181,'ab97bc5516b54755ac262ba68a804978','gigabytes',-2,'2025-11-29 10:11:02',NULL),('2025-11-28 10:11:03.029551',NULL,'2025-11-28 10:11:03.120105',596,596,NULL,'771a0ba5-a837-4a07-b0f0-2cc3cf7aaff7',182,'ab97bc5516b54755ac262ba68a804978','shares',-1,'2025-11-29 10:11:02','6cd102ad-9540-4dde-8628-56d0d62564e3'),('2025-11-28 10:11:03.030293',NULL,'2025-11-28 10:11:03.120105',597,597,NULL,'9080df42-c370-469f-a774-5156605e2ad2',183,'ab97bc5516b54755ac262ba68a804978','gigabytes',-2,'2025-11-29 10:11:02','6cd102ad-9540-4dde-8628-56d0d62564e3'),('2025-11-28 10:11:05.082348',NULL,'2025-11-28 10:11:05.291774',598,598,'0e4a868caf7745428b930f5df0b3e2fe','b4065d96-81b2-4c04-9e60-34a51e981ab2',180,'ab97bc5516b54755ac262ba68a804978','shares',1,'2025-11-29 10:11:05',NULL),('2025-11-28 10:11:05.084418',NULL,'2025-11-28 10:11:05.291774',599,599,'0e4a868caf7745428b930f5df0b3e2fe','feeafab9-8796-49cb-a94f-250182b0054a',181,'ab97bc5516b54755ac262ba68a804978','gigabytes',1,'2025-11-29 10:11:05',NULL),('2025-11-28 10:11:05.247658',NULL,'2025-11-28 10:11:05.291774',600,600,NULL,'335b02d5-8f0c-4928-9371-eb294a8a316b',182,'ab97bc5516b54755ac262ba68a804978','shares',1,'2025-11-29 10:11:05','6cd102ad-9540-4dde-8628-56d0d62564e3'),('2025-11-28 10:11:05.256180',NULL,'2025-11-28 10:11:05.291774',601,601,NULL,'1775a706-92f0-4623-baba-8935c776c655',183,'ab97bc5516b54755ac262ba68a804978','gigabytes',1,'2025-11-29 10:11:05','6cd102ad-9540-4dde-8628-56d0d62564e3'),('2025-11-28 10:11:05.646653',NULL,'2025-11-28 10:11:05.675976',602,602,'47cdb2911922414c87c44fadac1c1fbb','b1a8c3a5-9df6-41a7-9c63-ee7dd4c4e1fd',156,'a1ab6d5dbd57453f92ddf8599a8c5cff','shares',1,'2025-11-29 10:11:05',NULL),('2025-11-28 10:11:05.648414',NULL,'2025-11-28 10:11:05.675976',603,603,'47cdb2911922414c87c44fadac1c1fbb','e26093e3-e8d0-4619-9939-3b97a47432d2',157,'a1ab6d5dbd57453f92ddf8599a8c5cff','gigabytes',1,'2025-11-29 10:11:05',NULL),('2025-11-28 10:11:05.654626',NULL,'2025-11-28 10:11:05.675976',604,604,NULL,'a17b54d5-cfaa-4744-9713-16b2c9258445',158,'a1ab6d5dbd57453f92ddf8599a8c5cff','shares',1,'2025-11-29 10:11:05','a4689c66-7480-4db7-9279-095cdd632232'),('2025-11-28 10:11:05.655667',NULL,'2025-11-28 10:11:05.675976',605,605,NULL,'c3c50858-275e-4940-9e3b-7ae634095b76',159,'a1ab6d5dbd57453f92ddf8599a8c5cff','gigabytes',1,'2025-11-29 10:11:05','a4689c66-7480-4db7-9279-095cdd632232'),('2025-11-28 10:11:07.802348',NULL,'2025-11-28 10:11:07.819401',606,606,'b44ef903be4543c38c7ff39887ede90c','3272c645-54ad-4442-912d-2c4405ba0e2c',195,'1562d9ae673b4a5ea5a1a571bd0ea2c8','shares',-1,'2025-11-29 10:11:07',NULL),('2025-11-28 10:11:07.803292',NULL,'2025-11-28 10:11:07.819401',607,607,'b44ef903be4543c38c7ff39887ede90c','3aed3261-1fa1-4158-a0c6-02e2f9e8b996',194,'1562d9ae673b4a5ea5a1a571bd0ea2c8','gigabytes',-1,'2025-11-29 10:11:07',NULL),('2025-11-28 10:11:07.811126',NULL,'2025-11-28 10:11:07.819401',608,608,NULL,'bfd111d3-c3e5-4f83-b9a4-f79ce6c5787c',198,'1562d9ae673b4a5ea5a1a571bd0ea2c8','shares',-1,'2025-11-29 10:11:07','5ddfe74e-bc86-429d-b4a5-b582d6d4201d'),('2025-11-28 10:11:07.811878',NULL,'2025-11-28 10:11:07.819401',609,609,NULL,'3968a6b6-f214-40dd-a130-912f0e7ae5e9',196,'1562d9ae673b4a5ea5a1a571bd0ea2c8','gigabytes',-1,'2025-11-29 10:11:07','5ddfe74e-bc86-429d-b4a5-b582d6d4201d'),('2025-11-28 10:11:08.183363',NULL,'2025-11-28 10:11:08.256522',610,610,'b44ef903be4543c38c7ff39887ede90c','74e657bf-e75c-4d7f-b888-ab8c569cccd4',195,'1562d9ae673b4a5ea5a1a571bd0ea2c8','shares',1,'2025-11-29 10:11:08',NULL),('2025-11-28 10:11:08.185223',NULL,'2025-11-28 10:11:08.256522',611,611,'b44ef903be4543c38c7ff39887ede90c','b5adcd4f-296f-4f38-b015-477808fc7cde',194,'1562d9ae673b4a5ea5a1a571bd0ea2c8','gigabytes',1,'2025-11-29 10:11:08',NULL),('2025-11-28 10:11:08.201149',NULL,'2025-11-28 10:11:08.256522',612,612,NULL,'6787b7a8-6b18-4467-8e4d-6eb0e5c38c9f',198,'1562d9ae673b4a5ea5a1a571bd0ea2c8','shares',1,'2025-11-29 10:11:08','5ddfe74e-bc86-429d-b4a5-b582d6d4201d'),('2025-11-28 10:11:08.202561',NULL,'2025-11-28 10:11:08.256522',613,613,NULL,'f07f05c3-f3a2-4c43-9f89-7d9bd005fc8c',196,'1562d9ae673b4a5ea5a1a571bd0ea2c8','gigabytes',1,'2025-11-29 10:11:08','5ddfe74e-bc86-429d-b4a5-b582d6d4201d'),('2025-11-28 10:11:08.890057',NULL,'2025-11-28 10:11:09.152231',614,614,'47cdb2911922414c87c44fadac1c1fbb','da9b13c7-ee11-4eaf-99d8-10b632bbd8db',157,'a1ab6d5dbd57453f92ddf8599a8c5cff','gigabytes',1,'2025-11-29 10:11:08',NULL),('2025-11-28 10:11:08.898563',NULL,'2025-11-28 10:11:09.152231',615,615,NULL,'2f2d4809-756c-4bad-b78f-3c13dae03e45',159,'a1ab6d5dbd57453f92ddf8599a8c5cff','gigabytes',1,'2025-11-29 10:11:08','a4689c66-7480-4db7-9279-095cdd632232'),('2025-11-28 10:11:09.219607',NULL,'2025-11-28 10:11:09.234566',616,616,'0e4a868caf7745428b930f5df0b3e2fe','13792ad5-d3b9-42e1-916c-4be83ba859d0',180,'ab97bc5516b54755ac262ba68a804978','shares',-1,'2025