/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.11.15-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.11.15-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `mysql`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `mysql` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;

USE `mysql`;

--
-- Table structure for table `general_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `general_log` (
  `event_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `command_type` varchar(64) NOT NULL,
  `argument` mediumtext NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci COMMENT='General log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slow_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `slow_log` (
  `start_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `query_time` time(6) NOT NULL,
  `lock_time` time(6) NOT NULL,
  `rows_sent` bigint(20) unsigned NOT NULL,
  `rows_examined` bigint(20) unsigned NOT NULL,
  `db` varchar(512) NOT NULL,
  `last_insert_id` int(11) NOT NULL,
  `insert_id` int(11) NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `sql_text` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `rows_affected` bigint(20) unsigned NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci COMMENT='Slow log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `column_stats`
--

DROP TABLE IF EXISTS `column_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `column_stats` (
  `db_name` varchar(64) NOT NULL,
  `table_name` varchar(64) NOT NULL,
  `column_name` varchar(64) NOT NULL,
  `min_value` varbinary(255) DEFAULT NULL,
  `max_value` varbinary(255) DEFAULT NULL,
  `nulls_ratio` decimal(12,4) DEFAULT NULL,
  `avg_length` decimal(12,4) DEFAULT NULL,
  `avg_frequency` decimal(12,4) DEFAULT NULL,
  `hist_size` tinyint(3) unsigned DEFAULT NULL,
  `hist_type` enum('SINGLE_PREC_HB','DOUBLE_PREC_HB','JSON_HB') DEFAULT NULL,
  `histogram` longblob DEFAULT NULL,
  PRIMARY KEY (`db_name`,`table_name`,`column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_bin PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='Statistics on Columns';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `column_stats`
--

LOCK TABLES `column_stats` WRITE;
/*!40000 ALTER TABLE `column_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `column_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `columns_priv` (
  `Host` char(255) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(128) NOT NULL DEFAULT '',
  `Table_name` char(64) NOT NULL DEFAULT '',
  `Column_name` char(64) NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `db` (
  `Host` char(255) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(128) NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N',
  `Delete_history_priv` enum('N','Y') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT INTO `db` (`Host`, `Db`, `User`, `Select_priv`, `Insert_priv`, `Update_priv`, `Delete_priv`, `Create_priv`, `Drop_priv`, `Grant_priv`, `References_priv`, `Index_priv`, `Alter_priv`, `Create_tmp_table_priv`, `Lock_tables_priv`, `Create_view_priv`, `Show_view_priv`, `Create_routine_priv`, `Alter_routine_priv`, `Execute_priv`, `Event_priv`, `Trigger_priv`, `Delete_history_priv`) VALUES ('localhost','nova_cell1','nova_cell1_0e1c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),
('%','nova_cell1','nova_cell1_0e1c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `db` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` varchar(384) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','IGNORE_BAD_TABLE_OPTIONS','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH','EMPTY_STRING_IS_NULL','SIMULTANEOUS_ASSIGNMENT','TIME_ROUND_FRACTIONAL') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL,
  `collation_connection` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL,
  `db_collation` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL,
  `body_utf8` longblob DEFAULT NULL,
  PRIMARY KEY (`db`,`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `func` (
  `name` char(64) NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT 0,
  `dl` char(128) NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `global_priv`
--

DROP TABLE IF EXISTS `global_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_priv` (
  `Host` char(255) NOT NULL DEFAULT '',
  `User` char(128) NOT NULL DEFAULT '',
  `Priv` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '{}' CHECK (json_valid(`Priv`)),
  PRIMARY KEY (`Host`,`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_priv`
--

LOCK TABLES `global_priv` WRITE;
/*!40000 ALTER TABLE `global_priv` DISABLE KEYS */;
INSERT INTO `global_priv` (`Host`, `User`, `Priv`) VALUES ('localhost','mariadb.sys','{\"access\":0,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"\",\"account_locked\":true,\"password_last_changed\":0}'),
('localhost','root','{\"access\": 549755813887, \"plugin\": \"mysql_native_password\", \"authentication_string\": \"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\", \"auth_or\": [{}],\"version_id\":101115,\"password_last_changed\":1769432326}'),
('','PUBLIC','{\"access\":0,\"is_role\":true}'),
('%','root','{\"access\":549755813887,\"version_id\":101115,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\",\"password_last_changed\":1769432326}'),
('localhost','nova_cell1_0e1c','{\"access\":0,\"version_id\":101115,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*A1436250F6ABC38F200D547EF142152D083B3FDD\",\"password_last_changed\":1769432475}'),
('%','nova_cell1_0e1c','{\"access\":0,\"version_id\":101115,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*A1436250F6ABC38F200D547EF142152D083B3FDD\",\"password_last_changed\":1769432475}');
/*!40000 ALTER TABLE `global_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gtid_slave_pos`
--

DROP TABLE IF EXISTS `gtid_slave_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gtid_slave_pos` (
  `domain_id` int(10) unsigned NOT NULL,
  `sub_id` bigint(20) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `seq_no` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`domain_id`,`sub_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Replication slave GTID position';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gtid_slave_pos`
--

LOCK TABLES `gtid_slave_pos` WRITE;
/*!40000 ALTER TABLE `gtid_slave_pos` DISABLE KEYS */;
/*!40000 ALTER TABLE `gtid_slave_pos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT INTO `help_category` (`help_category_id`, `name`, `parent_category_id`, `url`) VALUES (1,'Contents',0,''),
(2,'Polygon Properties',34,''),
(3,'WKT',34,''),
(4,'Numeric Functions',37,''),
(5,'Plugins',1,''),
(6,'MBR',34,''),
(7,'Control Flow Functions',37,''),
(8,'Transactions',1,''),
(9,'Help Metadata',1,''),
(10,'Account Management',1,''),
(11,'Point Properties',34,''),
(12,'Encryption Functions',37,''),
(13,'LineString Properties',34,''),
(14,'Miscellaneous Functions',37,''),
(15,'Logical Operators',47,''),
(16,'Functions and Modifiers for Use with GROUP BY',1,''),
(17,'Information Functions',37,''),
(18,'Assignment Operators',47,''),
(19,'Comparison Operators',47,''),
(20,'Bit Functions',37,''),
(21,'Table Maintenance',1,''),
(22,'User-Defined Functions',1,''),
(23,'Data Types',1,''),
(24,'Compound Statements',1,''),
(25,'Geometry Constructors',34,''),
(26,'Administration',1,''),
(27,'Data Manipulation',1,''),
(28,'Utility',1,''),
(29,'Language Structure',1,''),
(30,'Geometry Relations',34,''),
(31,'Date and Time Functions',37,''),
(32,'WKB',34,''),
(33,'Procedures',1,''),
(34,'Geographic Features',1,''),
(35,'Geometry Properties',34,''),
(36,'String Functions',37,''),
(37,'Functions',1,''),
(38,'Data Definition',1,''),
(39,'Sequences',1,''),
(40,'JSON Functions',37,''),
(41,'Window Functions',37,''),
(42,'Spider Functions',37,''),
(43,'Dynamic Column Functions',37,''),
(44,'Galera Functions',37,''),
(45,'Temporal Tables',1,''),
(46,'GeoJSON',34,''),
(47,'Operators',1,''),
(48,'Arithmetic Operators',47,''),
(49,'Replication',1,''),
(50,'Prepared Statements',1,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT INTO `help_keyword` (`help_keyword_id`, `name`) VALUES (1,'work'),
(2,'locks'),
(3,'locking'),
(4,'drop'),
(5,'super'),
(6,'usage'),
(7,'binlog admin'),
(8,'binlog monitor'),
(9,'binlog replay'),
(10,'connection admin'),
(11,'federated admin'),
(12,'grant option'),
(13,'read_only admin'),
(14,'replica monitor'),
(15,'replication replica'),
(16,'roles'),
(17,'values'),
(18,'value'),
(19,'not'),
(20,'and'),
(21,'or'),
(22,':='),
(23,'assignment operator'),
(24,'='),
(25,'!='),
(26,'<>'),
(27,'not equal'),
(28,'less than'),
(29,'less than or equal'),
(30,'NULL-safe equal'),
(31,'equal'),
(32,'greater than'),
(33,'greater than or equal'),
(34,'bitwise and'),
(35,'shift left'),
(36,'shift right'),
(37,'bitwise xor'),
(38,'bitwise or'),
(39,'bitwise not'),
(40,'returns'),
(41,'udfs'),
(42,'udf calling sequences'),
(43,'udf security'),
(44,'int1'),
(45,'int2'),
(46,'int3'),
(47,'integer'),
(48,'int4'),
(49,'int8'),
(50,'dec'),
(51,'numeric'),
(52,'fixed'),
(53,'number'),
(54,'real'),
(55,'double precision'),
(56,'nchar'),
(57,'long'),
(58,'long varchar'),
(59,'repeat'),
(60,'declare'),
(61,'cursor'),
(62,'show'),
(63,'columns'),
(64,'kill connection'),
(65,'kill query'),
(66,'delete returning'),
(67,'sql_big_result'),
(68,'minus'),
(69,'cte'),
(70,'insert returning'),
(71,'queries'),
(72,'query'),
(73,'explain format'),
(74,'explain format json'),
(75,'rlike'),
(76,'character_length'),
(77,'escape'),
(78,'mode'),
(79,'trim_oracle'),
(80,'schedule'),
(81,'row_format'),
(82,'starts'),
(83,'host'),
(84,'generated columns'),
(85,'virtual columns'),
(86,'computed columns'),
(87,'hidden columns'),
(88,'nextval'),
(89,'lastval'),
(90,'+'),
(91,'addition operator'),
(92,'/'),
(93,'division operator'),
(94,'%'),
(95,'modulo operator'),
(96,'*'),
(97,'multiplication operator'),
(98,'-'),
(99,'subtraction operator'),
(100,'master_ssl_verify_cert'),
(101,'start replica'),
(102,'stop replica'),
(103,'reset slave'),
(104,'reset replica'),
(105,'drop prepare'),
(106,'deallocate prepare');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`),
  KEY `help_topic_id` (`help_topic_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT INTO `help_relation` (`help_topic_id`, `help_keyword_id`) VALUES (94,1),
(98,2),
(100,2),
(102,2),
(117,2),
(149,2),
(154,2),
(159,2),
(163,2),
(164,2),
(344,2),
(444,2),
(98,3),
(100,3),
(102,3),
(117,3),
(149,3),
(154,3),
(159,3),
(163,3),
(164,3),
(344,3),
(444,3),
(107,4),
(113,4),
(254,4),
(697,4),
(707,4),
(723,4),
(724,4),
(725,4),
(726,4),
(727,4),
(728,4),
(729,4),
(730,4),
(732,4),
(733,4),
(741,4),
(108,5),
(108,6),
(108,7),
(108,8),
(108,9),
(108,10),
(108,11),
(108,12),
(108,13),
(108,14),
(108,15),
(116,16),
(169,17),
(169,18),
(170,19),
(171,20),
(173,21),
(214,22),
(214,23),
(215,23),
(215,24),
(216,25),
(216,26),
(216,27),
(217,28),
(218,29),
(219,30),
(220,31),
(221,32),
(222,33),
(236,34),
(237,35),
(238,36),
(240,37),
(241,38),
(242,39),
(253,40),
(255,41),
(256,42),
(257,43),
(259,44),
(261,45),
(262,46),
(263,47),
(263,48),
(264,49),
(265,50),
(265,51),
(265,52),
(265,53),
(267,54),
(267,55),
(273,56),
(280,57),
(280,58),
(310,59),
(672,59),
(317,60),
(317,61),
(337,62),
(338,62),
(339,62),
(340,62),
(341,62),
(348,62),
(349,62),
(350,62),
(351,62),
(352,62),
(353,62),
(360,62),
(362,62),
(363,62),
(364,62),
(365,62),
(366,62),
(367,62),
(368,62),
(369,62),
(370,62),
(371,62),
(372,62),
(373,62),
(374,62),
(375,62),
(376,62),
(377,62),
(378,62),
(379,62),
(380,62),
(381,62),
(382,62),
(383,62),
(384,62),
(385,62),
(386,62),
(387,62),
(388,62),
(389,62),
(390,62),
(391,62),
(392,62),
(393,62),
(394,62),
(395,62),
(396,62),
(397,62),
(398,62),
(399,62),
(400,62),
(401,62),
(402,62),
(403,62),
(404,62),
(414,62),
(415,62),
(339,63),
(409,64),
(409,65),
(416,66),
(420,67),
(431,68),
(437,69),
(438,69),
(439,69),
(459,70),
(466,71),
(466,72),
(472,73),
(472,74),
(629,75),
(639,76),
(658,77),
(664,78),
(688,79),
(699,80),
(706,81),
(711,82),
(717,83),
(721,84),
(721,85),
(721,86),
(722,87),
(742,88),
(743,89),
(820,90),
(820,91),
(821,92),
(821,93),
(822,94),
(822,95),
(823,96),
(823,97),
(824,98),
(824,99),
(825,100),
(826,101),
(827,102),
(828,103),
(828,104),
(832,105),
(832,106);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
INSERT INTO `help_topic` (`help_topic_id`, `name`, `help_category_id`, `description`, `example`, `url`) VALUES (1,'HELP_DATE',9,'Help Contents generated from the MariaDB Knowledge Base on 25 July 2023.','',''),
(2,'HELP_VERSION',9,'Help Contents generated for MariaDB 10.11 from the MariaDB Knowledge Base on 25 July 2023.','',''),
(3,'AREA',2,'A synonym for ST_AREA.\n\nURL: https://mariadb.com/kb/en/polygon-properties-area/','','https://mariadb.com/kb/en/polygon-properties-area/'),
(4,'CENTROID',2,'A synonym for ST_CENTROID.\n\nURL: https://mariadb.com/kb/en/centroid/','','https://mariadb.com/kb/en/centroid/'),
(5,'ExteriorRing',2,'A synonym for ST_ExteriorRing.\n\nURL: https://mariadb.com/kb/en/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/polygon-properties-exteriorring/'),
(6,'InteriorRingN',2,'A synonym for ST_InteriorRingN.\n\nURL: https://mariadb.com/kb/en/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/polygon-properties-interiorringn/'),
(7,'NumInteriorRings',2,'A synonym for ST_NumInteriorRings.\n\nURL: https://mariadb.com/kb/en/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/polygon-properties-numinteriorrings/'),
(8,'ST_AREA',2,'Syntax\n------\n\nST_Area(poly)\nArea(poly)\n\nDescription\n-----------\n\nReturns as a double-precision number the area of the Polygon value poly, as\nmeasured in its spatial reference system.\n\nST_Area() and Area() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\n\nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/st_area/','','https://mariadb.com/kb/en/st_area/'),
(9,'ST_CENTROID',2,'Syntax\n------\n\nST_Centroid(mpoly)\nCentroid(mpoly)\n\nDescription\n-----------\n\nReturns a point reflecting the mathematical centroid (geometric center) for\nthe MultiPolygon mpoly. The resulting point will not necessarily be on the\nMultiPolygon.\n\nST_Centroid() and Centroid() are synonyms.\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0 0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n+--------------+\n| center       |\n+--------------+\n| POINT(10 10) |\n+--------------+\n\nURL: https://mariadb.com/kb/en/st_centroid/','','https://mariadb.com/kb/en/st_centroid/'),
(10,'ST_ExteriorRing',2,'Syntax\n------\n\nST_ExteriorRing(poly)\nExteriorRing(poly)\n\nDescription\n-----------\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() and ExteriorRing() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_exteriorring/','','https://mariadb.com/kb/en/st_exteriorring/'),
(11,'ST_InteriorRingN',2,'Syntax\n------\n\nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n\nDescription\n-----------\n\nReturns the N-th interior ring for the Polygon value poly as a LineString.\nRings are numbered beginning with 1.\n\nST_InteriorRingN() and InteriorRingN() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_interiorringn/','','https://mariadb.com/kb/en/st_interiorringn/'),
(12,'ST_NumInteriorRings',2,'Syntax\n------\n\nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n\nDescription\n-----------\n\nReturns an integer containing the number of interior rings in the Polygon\nvalue poly.\n\nNote that according the the OpenGIS standard, a POLYGON should have exactly\none ExteriorRing and all other rings should lie within that ExteriorRing and\nthus be the InteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several \'ExteriorRings\'. In the case of\nthere being multiple, non-overlapping exterior rings ST_NumInteriorRings()\nwill return 1.\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/st_numinteriorrings/','','https://mariadb.com/kb/en/st_numinteriorrings/'),
(14,'AsText',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-astext/','','https://mariadb.com/kb/en/wkt-astext/'),
(15,'AsWKT',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-aswkt/','','https://mariadb.com/kb/en/wkt-aswkt/'),
(16,'GeomCollFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/wkt-geomcollfromtext/'),
(17,'GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromtext/','','https://mariadb.com/kb/en/geometrycollectionfromtext/'),
(18,'GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/geometryfromtext/','','https://mariadb.com/kb/en/geometryfromtext/'),
(19,'GeomFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomfromtext/','','https://mariadb.com/kb/en/wkt-geomfromtext/'),
(20,'LineFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/wkt-linefromtext/','','https://mariadb.com/kb/en/wkt-linefromtext/'),
(21,'LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/linestringfromtext/','','https://mariadb.com/kb/en/linestringfromtext/'),
(22,'MLineFromText',3,'Syntax\n------\n\nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n\nMLineFromText() and MultiLineStringFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\nINSERT INTO gis_multi_line VALUES\n  (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16\n23,16 48))\')),\n  (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n  (MLineFromWKB(AsWKB(MultiLineString(\n   LineString(Point(1, 2), Point(3, 5)),\n   LineString(Point(2, 5), Point(5, 8), Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/mlinefromtext/','','https://mariadb.com/kb/en/mlinefromtext/'),
(23,'MPointFromText',3,'Syntax\n------\n\nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nMPointFromText() and MultiPointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/mpointfromtext/','','https://mariadb.com/kb/en/mpointfromtext/'),
(13,'WKT Definition',3,'Description\n-----------\n\nThe Well-Known Text (WKT) representation of Geometry is designed to exchange\ngeometry data in ASCII form. Examples of the basic geometry types include:\n\n+-----------------------------------------------------------------------------+\n| Geometry Types                                                              |\n+-----------------------------------------------------------------------------+\n| POINT                                                                       |\n+-----------------------------------------------------------------------------+\n| LINESTRING                                                                  |\n+-----------------------------------------------------------------------------+\n| POLYGON                                                                     |\n+-----------------------------------------------------------------------------+\n| MULTIPOINT                                                                  |\n+-----------------------------------------------------------------------------+\n| MULTILINESTRING                                                             |\n+-----------------------------------------------------------------------------+\n| MULTIPOLYGON                                                                |\n+-----------------------------------------------------------------------------+\n| GEOMETRYCOLLECTION                                                          |\n+-----------------------------------------------------------------------------+\n| GEOMETRY                                                                    |\n+-----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/wkt-definition/','','https://mariadb.com/kb/en/wkt-definition/'),
(24,'MPolyFromText',3,'Syntax\n------\n\nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nMPolyFromText() and MultiPolygonFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(\n   LineString(Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/mpolyfromtext/','','https://mariadb.com/kb/en/mpolyfromtext/'),
(25,'MultiLineStringFromText',3,'A synonym for MLineFromText.\n\nURL: https://mariadb.com/kb/en/multilinestringfromtext/','','https://mariadb.com/kb/en/multilinestringfromtext/'),
(26,'MultiPointFromText',3,'A synonym for MPointFromText.\n\nURL: https://mariadb.com/kb/en/multipointfromtext/','','https://mariadb.com/kb/en/multipointfromtext/'),
(27,'MultiPolygonFromText',3,'A synonym for MPolyFromText.\n\nURL: https://mariadb.com/kb/en/multipolygonfromtext/','','https://mariadb.com/kb/en/multipolygonfromtext/'),
(28,'PointFromText',3,'A synonym for ST_PointFromText.\n\nURL: https://mariadb.com/kb/en/wkt-pointfromtext/','','https://mariadb.com/kb/en/wkt-pointfromtext/'),
(29,'PolyFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/wkt-polyfromtext/','','https://mariadb.com/kb/en/wkt-polyfromtext/'),
(30,'PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/polygonfromtext/','','https://mariadb.com/kb/en/polygonfromtext/'),
(31,'ST_AsText',3,'Syntax\n------\n\nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKT representation and\nreturns the string result.\n\nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all synonyms.\n\nExamples\n--------\n\nSET @g = \'LineString(1 1,4 4,6 6)\';\n\nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6)        |\n+--------------------------------+\n\nURL: https://mariadb.com/kb/en/st_astext/','','https://mariadb.com/kb/en/st_astext/'),
(32,'ST_ASWKT',3,'A synonym for ST_ASTEXT().\n\nURL: https://mariadb.com/kb/en/st_aswkt/','','https://mariadb.com/kb/en/st_aswkt/'),
(33,'ST_GeomCollFromText',3,'Syntax\n------\n\nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(), GeomCollFromText() and\nGeometryCollectionFromText() are all synonyms.\n\nExample\n-------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/st_geomcollfromtext/','','https://mariadb.com/kb/en/st_geomcollfromtext/'),
(34,'ST_GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/st_geometrycollectionfromtext/'),
(35,'ST_GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/st_geometryfromtext/','','https://mariadb.com/kb/en/st_geometryfromtext/'),
(36,'ST_GeomFromText',3,'Syntax\n------\n\nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKT representation and SRID.\n\nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n\nExample\n-------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nURL: https://mariadb.com/kb/en/st_geomfromtext/','','https://mariadb.com/kb/en/st_geomfromtext/'),
(37,'ST_LineFromText',3,'Syntax\n------\n\nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nST_LineFromText(), ST_LineStringFromText(), ST_LineFromText() and\nST_LineStringFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_line  (g LINESTRING);\nSHOW FIELDS FROM gis_line;\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/st_linefromtext/','','https://mariadb.com/kb/en/st_linefromtext/'),
(38,'ST_LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/st_linestringfromtext/','','https://mariadb.com/kb/en/st_linestringfromtext/'),
(39,'ST_PointFromText',3,'Syntax\n------\n\nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKT representation and SRID.\n\nST_PointFromText() and PointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_point  (g POINT);\nSHOW FIELDS FROM gis_point;\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/st_pointfromtext/','','https://mariadb.com/kb/en/st_pointfromtext/'),
(40,'ST_PolyFromText',3,'Syntax\n------\n\nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\'));\n\nURL: https://mariadb.com/kb/en/st_polyfromtext/','','https://mariadb.com/kb/en/st_polyfromtext/'),
(41,'ST_PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/st_polygonfromtext/','','https://mariadb.com/kb/en/st_polygonfromtext/'),
(42,'DIV',4,'Syntax\n------\n\nDIV\n\nDescription\n-----------\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for non-integer operands that exceed BIGINT range.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a division by zero produces\nan error. Otherwise, it returns NULL.\n\nThe remainder of a division can be obtained using the MOD operator.\n\nExamples\n--------\n\nSELECT 300 DIV 7;\n+-----------+\n| 300 DIV 7 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT 300 DIV 0;\n+-----------+\n| 300 DIV 0 |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/div/','','https://mariadb.com/kb/en/div/'),
(43,'ABS',4,'Syntax\n------\n\nABS(X)\n\nDescription\n-----------\n\nReturns the absolute (non-negative) value of X. If X is not a number, it is\nconverted to a numeric type.\n\nExamples\n--------\n\nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n|      42 |\n+---------+\n\nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n|       42 |\n+----------+\n\nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n|               19940101 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/abs/','','https://mariadb.com/kb/en/abs/'),
(44,'ACOS',4,'Syntax\n------\n\nACOS(X)\n\nDescription\n-----------\n\nReturns the arc cosine of X, that is, the value whose cosine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n|         NULL |\n+--------------+\n\nSELECT ACOS(0);\n+-----------------+\n| ACOS(0)         |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234)      |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/acos/','','https://mariadb.com/kb/en/acos/'),
(45,'ASIN',4,'Syntax\n------\n\nASIN(X)\n\nDescription\n-----------\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns NULL if\nX is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2)          |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n\nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n\nSHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n\nURL: https://mariadb.com/kb/en/asin/','','https://mariadb.com/kb/en/asin/'),
(46,'ATAN',4,'Syntax\n------\n\nATAN(X)\n\nDescription\n-----------\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nExamples\n--------\n\nSELECT ATAN(2);\n+--------------------+\n| ATAN(2)            |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n\nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2)            |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/atan/','','https://mariadb.com/kb/en/atan/'),
(47,'ATAN2',4,'Syntax\n------\n\nATAN(Y,X), ATAN2(Y,X)\n\nDescription\n-----------\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both arguments\nare used to determine the quadrant of the result.\n\nExamples\n--------\n\nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2)          |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n\nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0)      |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/atan2/','','https://mariadb.com/kb/en/atan2/'),
(48,'CEIL',4,'Syntax\n------\n\nCEIL(X)\n\nDescription\n-----------\n\nCEIL() is a synonym for CEILING().\n\nURL: https://mariadb.com/kb/en/ceil/','','https://mariadb.com/kb/en/ceil/'),
(49,'CEILING',4,'Syntax\n------\n\nCEILING(X)\n\nDescription\n-----------\n\nReturns the smallest integer value not less than X.\n\nExamples\n--------\n\nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n|             -1 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/ceiling/','','https://mariadb.com/kb/en/ceiling/'),
(51,'COS',4,'Syntax\n------\n\nCOS(X)\n\nDescription\n-----------\n\nReturns the cosine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n|        -1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/cos/','','https://mariadb.com/kb/en/cos/'),
(52,'COT',4,'Syntax\n------\n\nCOT(X)\n\nDescription\n-----------\n\nReturns the cotangent of X.\n\nExamples\n--------\n\nSELECT COT(42);\n+--------------------+\n| COT(42)            |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n\nSELECT COT(12);\n+---------------------+\n| COT(12)             |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n\nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in \'cot(0)\'\n\nURL: https://mariadb.com/kb/en/cot/','','https://mariadb.com/kb/en/cot/'),
(55,'DEGREES',4,'Syntax\n------\n\nDEGREES(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from radians to degrees.\n\nThis is the converse of the RADIANS() function.\n\nExamples\n--------\n\nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n|           180 |\n+---------------+\n\nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n|                90 |\n+-------------------+\n\nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45)     |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/degrees/','','https://mariadb.com/kb/en/degrees/'),
(56,'EXP',4,'Syntax\n------\n\nEXP(X)\n\nDescription\n-----------\n\nReturns the value of e (the base of natural logarithms) raised to the power of\nX. The inverse of this function is LOG() (using a single argument only) or\nLN().\n\nIf X is NULL, this function returns NULL.\n\nExamples\n--------\n\nSELECT EXP(2);\n+------------------+\n| EXP(2)           |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n\nSELECT EXP(-2);\n+--------------------+\n| EXP(-2)            |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n\nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n|      1 |\n+--------+\n\nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/exp/','','https://mariadb.com/kb/en/exp/'),
(50,'CONV',4,'Syntax\n------\n\nCONV(N,from_base,to_base)\n\nDescription\n-----------\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base to_base.\n\nReturns NULL if any argument is NULL, or if the second or third argument are\nnot in the allowed range.\n\nThe argument N is interpreted as an integer, but may be specified as an\ninteger or a string. The minimum base is 2 and the maximum base is 36. If\nto_base is a negative number, N is regarded as a signed number. Otherwise, N\nis treated as unsigned. CONV() works with 64-bit precision.\n\nSome shortcuts for this function are also available: BIN(), OCT(), HEX(),\nUNHEX(). Also, MariaDB allows binary literal values and hexadecimal literal\nvalues.\n\nExamples\n--------\n\nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010           |\n+----------------+\n\nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172             |\n+-----------------+\n\nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H               |\n+------------------+\n\nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42                           |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/conv/','','https://mariadb.com/kb/en/conv/'),
(53,'CRC32',4,'Syntax\n------\n\n<= MariaDB 10.7\n\nCRC32(expr)\n\nFrom MariaDB 10.8\n\nCRC32([par,]expr)\n\nDescription\n-----------\n\nComputes a cyclic redundancy check (CRC) value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is expected to\nbe a string and (if possible) is treated as one if it is not.\n\nUses the ISO 3309 polynomial that used by zlib and many others. MariaDB 10.8\nintroduced the CRC32C() function, which uses the alternate Castagnoli\npolynomia.\n\nMariaDB starting with 10.8\n--------------------------\nOften, CRC is computed in pieces. To facilitate this, MariaDB 10.8.0\nintroduced an optional parameter: CRC32(\'MariaDB\')=CRC32(CRC32(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n|       4227209140 |\n+------------------+\n\nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n|       2594253378 |\n+------------------+\n\nFrom MariaDB 10.8.0\n\nSELECT CRC32(CRC32(\'Maria\'),\'DB\');\n+----------------------------+\n| CRC32(CRC32(\'Maria\'),\'DB\') |\n+----------------------------+\n|                 4227209140 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/crc32/','','https://mariadb.com/kb/en/crc32/'),
(54,'CRC32C',4,'MariaDB starting with 10.8\n--------------------------\nIntroduced in MariaDB 10.8.0 to compute a cyclic redundancy check (CRC) value\nusing the Castagnoli polynomial.\n\nSyntax\n------\n\nCRC32C([par,]expr)\n\nDescription\n-----------\n\nMariaDB has always included a native unary function CRC32() that computes the\nCRC-32 of a string using the ISO 3309 polynomial that used by zlib and many\nothers.\n\nInnoDB and MyRocks use a different polynomial, which was implemented in SSE4.2\ninstructions that were introduced in the Intel Nehalem microarchitecture. This\nis commonly called CRC-32C (Castagnoli).\n\nThe CRC32C function uses the Castagnoli polynomial.\n\nThis allows SELECT…INTO DUMPFILE to be used for the creation of files with\nvalid checksums, such as a logically empty InnoDB redo log file ib_logfile0\ncorresponding to a particular log sequence number.\n\nThe optional parameter allows the checksum to be computed in pieces:\nCRC32C(\'MariaDB\')=CRC32C(CRC32C(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32C(\'MariaDB\');\n+-------------------+\n| CRC32C(\'MariaDB\') |\n+-------------------+\n|         809606978 |\n+-------------------+\n\nSELECT CRC32C(CRC32C(\'Maria\'),\'DB\');\n+------------------------------+\n| CRC32C(CRC32C(\'Maria\'),\'DB\') |\n+------------------------------+\n|                    809606978 |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/crc32c/','','https://mariadb.com/kb/en/crc32c/'),
(57,'FLOOR',4,'Syntax\n------\n\nFLOOR(X)\n\nDescription\n-----------\n\nReturns the largest integer value not greater than X.\n\nExamples\n--------\n\nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n|           -2 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/floor/','','https://mariadb.com/kb/en/floor/'),
(58,'LN',4,'Syntax\n------\n\nLN(X)\n\nDescription\n-----------\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X. If X\nis less than or equal to 0, or NULL, then NULL is returned.\n\nThe inverse of this function is EXP().\n\nExamples\n--------\n\nSELECT LN(2);\n+-------------------+\n| LN(2)             |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n|   NULL |\n+--------+\n\nURL: https://mariadb.com/kb/en/ln/','','https://mariadb.com/kb/en/ln/'),
(60,'LOG10',4,'Syntax\n------\n\nLOG10(X)\n\nDescription\n-----------\n\nReturns the base-10 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG10(2);\n+-------------------+\n| LOG10(2)          |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n\nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n|          2 |\n+------------+\n\nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/log10/','','https://mariadb.com/kb/en/log10/'),
(61,'LOG2',4,'Syntax\n------\n\nLOG2(X)\n\nDescription\n-----------\n\nReturns the base-2 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n|                  42 |\n+---------------------+\n\nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n|          16 |\n+-------------+\n\nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n|       NULL |\n+------------+\n\nURL: https://mariadb.com/kb/en/log2/','','https://mariadb.com/kb/en/log2/'),
(63,'OCT',4,'Syntax\n------\n\nOCT(N)\n\nDescription\n-----------\n\nReturns a string representation of the octal value of N, where N is a longlong\n(BIGINT) number. This is equivalent to CONV(N,10,8). Returns NULL if N is NULL.\n\nExamples\n--------\n\nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42      |\n+---------+\n\nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14      |\n+---------+\n\nURL: https://mariadb.com/kb/en/oct/','','https://mariadb.com/kb/en/oct/'),
(64,'PI',4,'Syntax\n------\n\nPI()\n\nDescription\n-----------\n\nReturns the value of π (pi). The default number of decimal places displayed is\nsix, but MariaDB uses the full double-precision value internally.\n\nExamples\n--------\n\nSELECT PI();\n+----------+\n| PI()     |\n+----------+\n| 3.141593 |\n+----------+\n\nSELECT PI()+0.0000000000000000000000;\n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n|      3.1415926535897931159980 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/pi/','','https://mariadb.com/kb/en/pi/'),
(65,'POW',4,'Syntax\n------\n\nPOW(X,Y)\n\nDescription\n-----------\n\nReturns the value of X raised to the power of Y.\n\nPOWER() is a synonym.\n\nExamples\n--------\n\nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n|        8 |\n+----------+\n\nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n|      0.25 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/pow/','','https://mariadb.com/kb/en/pow/'),
(59,'LOG',4,'Syntax\n------\n\nLOG(X), LOG(B,X)\n\nDescription\n-----------\n\nIf called with one parameter, this function returns the natural logarithm of\nX. If X is less than or equal to 0, then NULL is returned.\n\nIf called with two parameters, it returns the logarithm of X to the base B. If\nB is <= 1 or X <= 0, the function returns NULL.\n\nIf any argument is NULL, the function returns NULL.\n\nThe inverse of this function (when called with a single argument) is the EXP()\nfunction.\n\nExamples\n--------\n\nLOG(X):\n\nSELECT LOG(2);\n+-------------------+\n| LOG(2)            |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LOG(-2);\n+---------+\n| LOG(-2) |\n+---------+\n|    NULL |\n+---------+\n\nLOG(B,X)\n\nSELECT LOG(2,16);\n+-----------+\n| LOG(2,16) |\n+-----------+\n|         4 |\n+-----------+\n\nSELECT LOG(3,27);\n+-----------+\n| LOG(3,27) |\n+-----------+\n|         3 |\n+-----------+\n\nSELECT LOG(3,1);\n+----------+\n| LOG(3,1) |\n+----------+\n|        0 |\n+----------+\n\nSELECT LOG(3,0);\n+----------+\n| LOG(3,0) |\n+----------+\n|     NULL |\n+----------+\n\nURL: https://mariadb.com/kb/en/log/','','https://mariadb.com/kb/en/log/'),
(62,'MOD',4,'Syntax\n------\n\nMOD(N,M), N % M, N MOD M\n\nDescription\n-----------\n\nModulo operation. Returns the remainder of N divided by M. See also Modulo\nOperator.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any number modulus zero\nproduces an error. Otherwise, it returns NULL.\n\nThe integer part of a division can be obtained using DIV.\n\nExamples\n--------\n\nSELECT 1042 % 50;\n+-----------+\n| 1042 % 50 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n|            4 |\n+--------------+\n\nSELECT 253 % 7;\n+---------+\n| 253 % 7 |\n+---------+\n|       1 |\n+---------+\n\nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n|         2 |\n+-----------+\n\nSELECT 29 MOD 9;\n+----------+\n| 29 MOD 9 |\n+----------+\n|        2 |\n+----------+\n\nURL: https://mariadb.com/kb/en/mod/','','https://mariadb.com/kb/en/mod/'),
(66,'POWER',4,'Syntax\n------\n\nPOWER(X,Y)\n\nDescription\n-----------\n\nThis is a synonym for POW(), which returns the value of X raised to the power\nof Y.\n\nURL: https://mariadb.com/kb/en/power/','','https://mariadb.com/kb/en/power/'),
(67,'RADIANS',4,'Syntax\n------\n\nRADIANS(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from degrees to radians. Note that π radians\nequals 180 degrees.\n\nThis is the converse of the DEGREES() function.\n\nExamples\n--------\n\nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45)       |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n\nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90)     |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI())      |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n\nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180)     |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/radians/','','https://mariadb.com/kb/en/radians/'),
(68,'RAND',4,'Syntax\n------\n\nRAND(), RAND(N)\n\nDescription\n-----------\n\nReturns a random DOUBLE precision floating point value v in the range 0 <= v <\n1.0. If a constant integer argument N is specified, it is used as the seed\nvalue, which produces a repeatable sequence of column values. In the example\nbelow, note that the sequences of values produced by RAND(3) is the same both\nplaces where it occurs.\n\nIn a WHERE clause, RAND() is evaluated each time the WHERE is executed.\n\nStatements using the RAND() function are not safe for statement-based\nreplication.\n\nPractical uses\n--------------\n\nThe expression to get a random integer from a given range is the following:\n\nFLOOR(min_value + RAND() * (max_value - min_value +1))\n\nRAND() is often used to read random rows from a table, as follows:\n\nSELECT * FROM my_table ORDER BY RAND() LIMIT 10;\n\nNote, however, that this technique should never be used on a large table as it\nwill be extremely slow. MariaDB will read all rows in the table, generate a\nrandom value for each of them, order them, and finally will apply the LIMIT\nclause.\n\nExamples\n--------\n\nCREATE TABLE t (i INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.255651095188829 |\n|    2 | 0.833920199269355 |\n|    3 |  0.40264774151393 |\n+------+-------------------+\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.511478140495232 |\n|    2 | 0.349447508668012 |\n|    3 | 0.212803152588013 |\n+------+-------------------+\n\nUsing the same seed, the same sequence will be returned:\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nGenerating a random number from 5 to 15:\n\nSELECT FLOOR(5 + (RAND() * 11));\n\nURL: https://mariadb.com/kb/en/rand/','','https://mariadb.com/kb/en/rand/'),
(70,'SIGN',4,'Syntax\n------\n\nSIGN(X)\n\nDescription\n-----------\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X is\nnegative, zero, or positive.\n\nExamples\n--------\n\nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n|        -1 |\n+-----------+\n\nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n|       0 |\n+---------+\n\nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/sign/','','https://mariadb.com/kb/en/sign/'),
(71,'SIN',4,'Syntax\n------\n\nSIN(X)\n\nDescription\n-----------\n\nReturns the sine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT SIN(PI());\n+----------------------+\n| SIN(PI())            |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n\nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n|                0 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/sin/','','https://mariadb.com/kb/en/sin/'),
(72,'SQRT',4,'Syntax\n------\n\nSQRT(X)\n\nDescription\n-----------\n\nReturns the square root of X. If X is negative, NULL is returned.\n\nExamples\n--------\n\nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n|       2 |\n+---------+\n\nSELECT SQRT(20);\n+------------------+\n| SQRT(20)         |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n\nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n|         42 |\n+------------+\n\nURL: https://mariadb.com/kb/en/sqrt/','','https://mariadb.com/kb/en/sqrt/'),
(73,'TAN',4,'Syntax\n------\n\nTAN(X)\n\nDescription\n-----------\n\nReturns the tangent of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n|      0.9999999999999999 |\n+-------------------------+\n\nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI())             |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n\nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1)     |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n\nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/tan/','','https://mariadb.com/kb/en/tan/'),
(69,'ROUND',4,'Syntax\n------\n\nROUND(X), ROUND(X,D)\n\nDescription\n-----------\n\nRounds the argument X to D decimal places. D defaults to 0 if not specified. D\ncan be negative to cause D digits left of the decimal point of the value X to\nbecome zero.\n\nThe rounding algorithm depends on the data type of X:\n\n* for floating point types (FLOAT, DOUBLE) the C libraries rounding function\nis used, so the behavior *may* differ between operating systems\n* for fixed point types (DECIMAL, DEC/NUMBER/FIXED) the \"round half up\" rule\nis used, meaning that e.g. a value ending in exactly .5 is always rounded up.\n\nExamples\n--------\n\nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n|           -1 |\n+--------------+\n\nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n|           -2 |\n+--------------+\n\nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n|           2 |\n+-------------+\n\nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n|             1.3 |\n+-----------------+\n\nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n|                20 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/round/','','https://mariadb.com/kb/en/round/'),
(74,'TRUNCATE',4,'This page documents the TRUNCATE function. See TRUNCATE TABLE for the DDL\nstatement.\n\nSyntax\n------\n\nTRUNCATE(X,D)\n\nDescription\n-----------\n\nReturns the number X, truncated to D decimal places. If D is 0, the result has\nno decimal point or fractional part. D can be negative to cause D digits left\nof the decimal point of the value X to become zero.\n\nExamples\n--------\n\nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n|               1.2 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n|               1.9 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n|               -1.9 |\n+--------------------+\n\nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n|              100 |\n+------------------+\n\nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n|                  1028 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/truncate/','','https://mariadb.com/kb/en/truncate/'),
(76,'UNINSTALL PLUGIN',5,'Syntax\n------\n\nUNINSTALL PLUGIN [IF EXISTS] plugin_name\n\nDescription\n-----------\n\nThis statement removes a single installed plugin. To uninstall the whole\nlibrary which contains the plugin, use UNINSTALL SONAME. You cannot uninstall\na plugin if any table that uses it is open.\n\nplugin_name must be the name of some plugin that is listed in the mysql.plugin\ntable. The server executes the plugin\'s deinitialization function and removes\nthe row for the plugin from the mysql.plugin table, so that subsequent server\nrestarts will not load and initialize the plugin. UNINSTALL PLUGIN does not\nremove the plugin\'s shared library file.\n\nTo use UNINSTALL PLUGIN, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nUNINSTALL PLUGIN example;\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------+\n| Level | Code | Message                       |\n+-------+------+-------------------------------+\n| Note  | 1305 | PLUGIN example does not exist |\n+-------+------+-------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-plugin/','','https://mariadb.com/kb/en/uninstall-plugin/'),
(77,'INSTALL SONAME',5,'Syntax\n------\n\nINSTALL SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of INSTALL PLUGIN. It installs all plugins from a\ngiven plugin_library. See INSTALL PLUGIN for details.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL SONAME adds one or more lines to the mysql.plugin table that describes\nthe plugin. This table contains the plugin name and library file name.\n\nINSTALL SONAME causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL SONAME also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL SONAME, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nSONAME only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nIf you need to install only one plugin from a library, use the INSTALL PLUGIN\nstatement.\n\nExamples\n--------\n\nTo load the XtraDB storage engine and all of its information_schema tables\nwith one statement, use\n\nINSTALL SONAME \'ha_xtradb\';\n\nThis statement can be used instead of INSTALL PLUGIN even when the library\ncontains only one plugin:\n\nINSTALL SONAME \'ha_sequence\';\n\nURL: https://mariadb.com/kb/en/install-soname/','','https://mariadb.com/kb/en/install-soname/'),
(75,'INSTALL PLUGIN',5,'Syntax\n------\n\nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement installs an individual plugin from the specified library. To\ninstall the whole library (which could be required), use INSTALL SONAME. See\nalso Installing a Plugin.\n\nplugin_name is the name of the plugin as defined in the plugin declaration\nstructure contained in the library file. Plugin names are not case sensitive.\nFor maximal compatibility, plugin names should be limited to ASCII letters,\ndigits, and underscore, because they are used in C source files, shell command\nlines, M4 and Bourne shell scripts, and SQL environments.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension can be omitted (which makes the statement look\nthe same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nINSTALL PLUGIN causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nPLUGIN only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a note instead of\nan error if the specified plugin already exists. See SHOW WARNINGS.\n\nExamples\n--------\n\nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n\nThe extension can also be omitted:\n\nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected (0.104 sec)\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------+\n| Level | Code | Message                            |\n+-------+------+------------------------------------+\n| Note  | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n\nURL: https://mariadb.com/kb/en/install-plugin/','','https://mariadb.com/kb/en/install-plugin/'),
(78,'UNINSTALL SONAME',5,'Syntax\n------\n\nUNINSTALL SONAME  [IF EXISTS] \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of UNINSTALL PLUGIN statement, that removes all\nplugins belonging to a specified plugin_library. See UNINSTALL PLUGIN for\ndetails.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nTo use UNINSTALL SONAME, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin library does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nTo uninstall the XtraDB plugin and all of its information_schema tables with\none statement, use\n\nUNINSTALL SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------------+\n| Level | Code | Message                             |\n+-------+------+-------------------------------------+\n| Note  | 1305 | SONAME ha_example.so does not exist |\n+-------+------+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-soname/','','https://mariadb.com/kb/en/uninstall-soname/'),
(79,'Plugin Overview',5,'Plugins are server components that enhance MariaDB in some way. These can be\nanything from new storage engines, plugins for enhancing full-text parsing, or\neven small enhancements, such as a plugin to get a timestamp as an integer.\n\nQuerying Plugin Information\n---------------------------\n\nThere are a number of ways to see which plugins are currently active.\n\nA server almost always has a large number of active plugins, because the\nserver contains a large number of built-in plugins, which are active by\ndefault and cannot be uninstalled.\n\nQuerying Plugin Information with SHOW PLUGINS\n---------------------------------------------\n\nThe SHOW PLUGINS statement can be used to query information about all active\nplugins.\n\nFor example:\n\nSHOW PLUGINS\\G;\n********************** 1. row **********************\n Name: binlog\n Status: ACTIVE\n Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n********************** 2. row **********************\n Name: mysql_native_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n********************** 3. row **********************\n Name: mysql_old_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n...\n\nIf a plugin\'s Library column has a NULL value, then the plugin is built-in,\nand it cannot be uninstalled.\n\nQuerying Plugin Information with information_schema.PLUGINS\n-----------------------------------------------------------\n\nThe information_schema.PLUGINS table can be queried to get more detailed\ninformation about plugins.\n\nFor example:\n\nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row ***************************\n     PLUGIN_NAME: CSV\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: Brian Aker, MySQL AB\n  PLUGIN_DESCRIPTION: CSV storage engine\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row ***************************\n     PLUGIN_NAME: MEMORY\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: MySQL AB\n  PLUGIN_DESCRIPTION: Hash based, stored in memory, useful for temporary\ntables\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n\nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value, then the plugin is\nbuilt-in, and it cannot be uninstalled.\n\nQuerying Plugin Information with mysql.plugin\n---------------------------------------------\n\nThe mysql.plugin table can be queried to get information about installed\nplugins.\n\nThis table only contains information about plugins that have been installed\nvia the following methods:\n\n* The INSTALL SONAME statement.\n* The INSTALL PLUGIN statement.\n* The mariadb-plugin utility.\n\nThis table does not contain information about:\n\n* Built-in plugins.\n* Plugins loaded with the --plugin-load-add option.\n* Plugins loaded with the --plugin-load option.\n\nThis table only contains enough information to reload the plugin when the\nserver is restarted, which means it only contains the plugin name and the\nplugin library.\n\nFor example:\n\nSELECT * FROM mysql.plugin;\n\n+------+------------+\n| name | dl         |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n\nInstalling a Plugin\n-------------------\n\nThere are three primary ways to install a plugin:\n\n* A plugin can be installed dynamically with an SQL statement.\n* A plugin can be installed with a mariadbd option, but it requires a server\nrestart.\n* A plugin can be installed with the mariadb-plugin utility, while the server\nis completely offline.\n\nWhen you are installing a plugin, you also have to ensure that:\n\n* The server\'s plugin directory is properly configured, and the plugin\'s\nlibrary is in the plugin directory.\n* The server\'s minimum plugin maturity is properly configured, and the plugin\nis mature enough to be installed.\n\nInstalling a Plugin Dynamically\n-------------------------------\n\nA plugin can be installed dynamically by executing either the INSTALL SONAME\nor the INSTALL PLUGIN statement.\n\nIf a plugin is installed with one of these statements, then a record will be\nadded to the mysql.plugins table for the plugin. This means that the plugin\nwill automatically be loaded every time the server restarts, unless\nspecifically uninstalled or deactivated.\n\nInstalling a Plugin with INSTALL SONAME\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL SONAME\nstatement. INSTALL SONAME installs all plugins from the given plugin library.\nThis could be required for some plugin libraries.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin), you could execute the\nfollowing:\n\nINSTALL SONAME \'server_audit\';\n\nInstalling a Plugin with INSTALL PLUGIN\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL PLUGIN\nstatement. INSTALL PLUGIN installs a single plugin from the given plugin\nlibrary.\n\nFor example, to install the server_audit audit plugin from the server_audit\nplugin library, you could execute the following:\n\nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n\nInstalling a Plugin with Plugin Load Options\n--------------------------------------------\n\nA plugin can be installed with a mariadbd option by providing either the\n--plugin-load-add or the --plugin-load option.\n\nIf a plugin is installed with one of these options, then a record will not be\nadded to the mysql.plugins table for the plugin. This means that if the server\nis restarted without the same option set, then the plugin will not\nautomatically be loaded.\n\nInstalling a Plugin with --plugin-load-add\n------------------------------------------\n\nYou can install a plugin with the --plugin-load-add option by specifying the\noption as a command-line argument to mariadbd or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load-add option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mariadbd --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nSpecial care must be taken when specifying both the --plugin-load option and\nthe --plugin-load-add option together. The --plugin-load option resets the\nplugin load list, and this can cause unexpected problems if you are not aware.\nThe --plugin-load-add option does not reset the plugin load list, so it is\nmuch safer to use. See Specifying Multiple Plugin Load Options for more\ninformation.\n\nInstalling a Plugin with --plugin-load\n--------------------------------------\n\nYou can install a plugin with the --plugin-load option by specifying the\noption as a command-line argument to mariadbd or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mariadbd --user=mysql --plugin-load=\'server_audit;ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option together. The --plugin-load option resets the plugin\nload list, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use. See Specifying Multiple Plugin Load Options for more information.\n\nSpecifying Multiple Plugin Load Options\n---------------------------------------\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use.\n\nThis can have the following consequences:\n\n* If the --plugin-load option is specified multiple times, then only the last\ninstance will have any effect. For example, in the following case, the first\ninstance of the option is reset:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* If the --plugin-load option is specified after the --plugin-load-add option,\nthen it will also reset the changes made by that option. For example, in the\nfollowing case, the --plugin-load-add option does not do anything, because the\nsubsequent --plugin-load option resets the plugin load list:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* In contrast, if the --plugin-load option is specified before the\n--plugin-load-add option, then it will work fine, because the\n--plugin-load-add option does not reset the plugin load list. For example, in\nthe following case, both plugins are properly loaded:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nInstalling a Plugin with mariadb-plugin\n---------------------------------------\n\nA plugin can be installed with the mariadb-plugin utility if the server is\ncompletely offline.\n\nThe syntax is:\n\nmariadb-plugin [options] <plugin> ENABLE|DISABLE\n\nFor example, to install the server_audit audit plugin, you could execute the\nfollowing:\n\nmariadb-plugin server_audit ENABLE\n\nIf a plugin is installed with this utility, then a record will be added to the\nmysql.plugins table for the plugin. This means that the plugin will\nautomatically be loaded every time the server restarts, unless specifically\nuninstalled or deactivated.\n\nConfiguring the Plugin Directory\n--------------------------------\n\nWhen a plugin is being installed, the server looks for the plugin\'s library in\nthe server\'s plugin directory. This directory is configured by the plugin_dir\nsystem variable. This can be specified as a command-line argument to mariadbd\nor it can be specified in a relevant server option group in an option file.\nFor example:\n\n[mariadb]\n...\nplugin_dir = /usr/lib64/mysql/plugin\n\nConfiguring the Minimum Plugin Maturity\n---------------------------------------\n\nWhen a plugin is being installed, the server compares the plugin\'s maturity\nlevel against the server\'s minimum allowed plugin maturity. This can help\nprevent users from using unstable plugins on production servers. This minimum\nplugin maturity is configured by the plugin_maturity system variable. This can\nbe specified as a command-line argument to mariadbd or it can be specified in\na relevant server option group in an option file. For example:\n\n[mariadb]\n...\nplugin_maturity = stable\n\nConfiguring Plugin Activation at Server Startup\n-----------------------------------------------\n\nA plugin will be loaded by default when the server starts if:\n\n* The plugin was installed with the INSTALL SONAME statement.\n* The plugin was installed with the INSTALL PLUGIN statement.\n* The plugin was installed with the mariadb-plugin utility.\n* The server is configured to load the plugin with the --plugin-load-add\noption.\n* The server is configured to load the plugin with the --plugin-load option.\n\nThis behavior can be changed with special options that take the form\n--plugin-name. For example, for the server_audit audit plugin, the special\noption is called --server-audit.\n\nThe possible values for these special options are:\n\n+---------------------------------------+------------------------------------+\n| Option Value                          | Description                        |\n+---------------------------------------+------------------------------------+\n| OFF                                   | Disables the plugin without        |\n|                                       | removing it from the               |\n|                                       | mysql.plugins table.               |\n+---------------------------------------+------------------------------------+\n| ON                                    | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will still continue         |\n|                                       | starting up, but the plugin will   |\n|                                       | be disabled.                       |\n+---------------------------------------+------------------------------------+\n| FORCE                                 | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error.                             |\n+---------------------------------------+------------------------------------+\n| FORCE_PLUS_PERMANENT                  | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error. In addition, the plugin     |\n|                                       | cannot be uninstalled with         |\n|                                       | UNINSTALL SONAME or UNINSTALL      |\n|                                       | PLUGIN while the server is         |\n|                                       | running.                           |\n+---------------------------------------+------------------------------------+\n\nA plugin\'s status can be found by looking at the PLUGIN_STATUS column of the\ninformation_schema.PLUGINS table.\n\nUninstalling Plugins\n--------------------\n\nPlugins that are found in the mysql.plugin table, that is those that were\ninstalled with INSTALL SONAME, INSTALL PLUGIN or mariadb-plugin can be\nuninstalled in one of two ways:\n\n* The UNINSTALL SONAME or the UNINSTALL PLUGIN statement while the server is\nrunning\n* With mariadb-plugin while the server is offline.\n\nPlugins that were enabled as a --plugin-load option do not need to be\nuninstalled. If --plugin-load is omitted the next time the server starts, or\nthe plugin is not listed as one of the --plugin-load entries, the plugin will\nnot be loaded.\n\nUNINSTALL PLUGIN uninstalls a single installed plugin, while UNINSTALL SONAME\nuninstalls all plugins belonging to a given library.\n\nURL: https://mariadb.com/kb/en/plugin-overview/','','https://mariadb.com/kb/en/plugin-overview/'),
(80,'MBR Definition',6,'Description\n-----------\n\nThe MBR (Minimum Bounding Rectangle), or Envelope is the bounding geometry,\nformed by the minimum and maximum (X,Y) coordinates:\n\nExamples\n--------\n\n((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n\nURL: https://mariadb.com/kb/en/mbr-definition/','','https://mariadb.com/kb/en/mbr-definition/'),
(81,'MBRContains',6,'Syntax\n------\n\nMBRContains(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\ncontains the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRWithin().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\n\nSET @g2 = GeomFromText(\'Point(1 1)\');\n\nSELECT MBRContains(@g1,@g2), MBRContains(@g2,@g1);\n+----------------------+----------------------+\n| MBRContains(@g1,@g2) | MBRContains(@g2,@g1) |\n+----------------------+----------------------+\n|                    1 |                    0 |\n+----------------------+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrcontains/','','https://mariadb.com/kb/en/mbrcontains/'),
(83,'MBREqual',6,'Syntax\n------\n\nMBREqual(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are the same.\n\nExamples\n--------\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 2)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 2, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 3)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 4, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 0 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/mbrequal/','','https://mariadb.com/kb/en/mbrequal/'),
(82,'MBRDisjoint',6,'Syntax\n------\n\nMBRDisjoint(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are disjoint. Two geometries are disjoint if they do not\nintersect, that is touch or overlap.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECTmbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrdisjoint/','','https://mariadb.com/kb/en/mbrdisjoint/'),
(84,'MBRIntersects',6,'Syntax\n------\n\nMBRIntersects(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 intersect.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      1 |\n+------------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      0 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/mbrintersects/','','https://mariadb.com/kb/en/mbrintersects/'),
(85,'MBROverlaps',6,'Syntax\n------\n\nMBROverlaps(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 overlap. The term spatially overlaps is used if two\ngeometries intersect and their intersection results in a geometry of the same\ndimension but not equal to either of the given geometries.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbroverlaps/','','https://mariadb.com/kb/en/mbroverlaps/'),
(86,'MBRTouches',6,'Syntax\n------\n\nMBRTouches(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 touch. Two geometries spatially touch if the interiors of\nthe geometries do not intersect, but the boundary of one of the geometries\nintersects either the boundary or the interior of the other.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   1 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/mbrtouches/','','https://mariadb.com/kb/en/mbrtouches/'),
(87,'MBRWithin',6,'Syntax\n------\n\nMBRWithin(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1 is\nwithin the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRContains().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((0 0,0 5,5 5,5 0,0 0))\');\nSELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+\n\nURL: https://mariadb.com/kb/en/mbrwithin/','','https://mariadb.com/kb/en/mbrwithin/'),
(91,'NULLIF',7,'Syntax\n------\n\nNULLIF(expr1,expr2)\n\nDescription\n-----------\n\nReturns NULL if expr1 = expr2 is true, otherwise returns expr1. This is the\nsame as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1 END.\n\nExamples\n--------\n\nSELECT NULLIF(1,1);\n+-------------+\n| NULLIF(1,1) |\n+-------------+\n|        NULL |\n+-------------+\n\nSELECT NULLIF(1,2);\n+-------------+\n| NULLIF(1,2) |\n+-------------+\n|           1 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/nullif/','','https://mariadb.com/kb/en/nullif/'),
(92,'NVL',7,'MariaDB starting with 10.3\n--------------------------\nFrom MariaDB 10.3, NVL is a synonym for IFNULL.\n\nURL: https://mariadb.com/kb/en/nvl/','','https://mariadb.com/kb/en/nvl/'),
(93,'NVL2',7,'MariaDB starting with 10.3\n--------------------------\nThe NLV2 function was introduced in MariaDB 10.3.0.\n\nSyntax\n------\n\nNVL2(expr1,expr2,expr3)\n\nDescription\n-----------\n\nThe NVL2 function returns a value based on whether a specified expression is\nNULL or not. If expr1 is not NULL, then NVL2 returns expr2. If expr1 is NULL,\nthen NVL2 returns expr3.\n\nExamples\n--------\n\nSELECT NVL2(NULL,1,2);\n+----------------+\n| NVL2(NULL,1,2) |\n+----------------+\n|              2 |\n+----------------+\n\nSELECT NVL2(\'x\',1,2);\n+---------------+\n| NVL2(\'x\',1,2) |\n+---------------+\n|             1 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/nvl2/','','https://mariadb.com/kb/en/nvl2/'),
(102,'UNLOCK TABLES',8,'Syntax\n------\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\nSee LOCK TABLES for more information.\n\nIn addition to releasing table locks acquired by the LOCK TABLES statement,\nthe UNLOCK TABLES statement also releases the global read lock acquired by the\nFLUSH TABLES WITH READ LOCK statement. The FLUSH TABLES WITH READ LOCK\nstatement is very useful for performing backups. See FLUSH for more\ninformation about FLUSH TABLES WITH READ LOCK.\n\nURL: https://mariadb.com/kb/en/transactions-unlock-tables/','','https://mariadb.com/kb/en/transactions-unlock-tables/'),
(104,'XA Transactions',8,'Overview\n--------\n\nThe MariaDB XA implementation is based on the X/Open CAE document Distributed\nTransaction Processing: The XA Specification. This document is published by\nThe Open Group and available at\nhttp://www.opengroup.org/public/pubs/catalog/c193.htm.\n\nXA transactions are designed to allow distributed transactions, where a\ntransaction manager (the application) controls a transaction which involves\nmultiple resources. Such resources are usually DBMSs, but could be resources\nof any type. The whole set of required transactional operations is called a\nglobal transaction. Each subset of operations which involve a single resource\nis called a local transaction. XA used a 2-phases commit (2PC). With the first\ncommit, the transaction manager tells each resource to prepare an effective\ncommit, and waits for a confirm message. The changes are not still made\neffective at this point. If any of the resources encountered an error, the\ntransaction manager will rollback the global transaction. If all resources\ncommunicate that the first commit is successful, the transaction manager can\nrequire a second commit, which makes the changes effective.\n\nIn MariaDB, XA transactions can only be used with storage engines that support\nthem. At least InnoDB, TokuDB, SPIDER and MyRocks support them. For InnoDB,\nuntil MariaDB 10.2, XA transactions can be disabled by setting the\ninnodb_support_xa server system variable to 0. From MariaDB 10.3, XA\ntransactions are always supported.\n\nLike regular transactions, XA transactions create metadata locks on accessed\ntables.\n\nXA transactions require REPEATABLE READ as a minimum isolation level. However,\ndistributed transactions should always use SERIALIZABLE.\n\nTrying to start more than one XA transaction at the same time produces a 1400\nerror (SQLSTATE \'XAE09\'). The same error is produced when attempting to start\nan XA transaction while a regular transaction is in effect. Trying to start a\nregular transaction while an XA transaction is in effect produces a 1399 error\n(SQLSTATE \'XAE07\').\n\nThe statements that cause an implicit COMMIT for regular transactions produce\na 1400 error (SQLSTATE \'XAE09\') if a XA transaction is in effect.\n\nInternal XA vs External XA\n--------------------------\n\nXA transactions are an overloaded term in MariaDB. If a storage engine is\nXA-capable, it can mean one or both of these:\n\n* It supports MariaDB\'s internal two-phase commit API. This is transparent to\nthe user. Sometimes this is called \"internal XA\", since MariaDB\'s internal\ntransaction coordinator log can handle coordinating these transactions.\n\n* It supports XA transactions, with the XA START, XA PREPARE, XA COMMIT, etc.\nstatements. Sometimes this is called \"external XA\", since it requires the use\nof an external transaction coordinator to use this feature properly.\n\nTransaction Coordinator Log\n---------------------------\n\nIf you have two or more XA-capable storage engines enabled, then a transaction\ncoordinator log must be available.\n\nThere are currently two implementations of the transaction coordinator log:\n\n* Binary log-based transaction coordinator log\n* Memory-mapped file-based transaction coordinator log\n\nIf the binary log is enabled on a server, then the server will use the binary\nlog-based transaction coordinator log. Otherwise, it will use the\nmemory-mapped file-based transaction coordinator log.\n\nSee Transaction Coordinator Log for more information.\n\nSyntax\n------\n\nXA {START|BEGIN} xid [JOIN|RESUME]\n\nXA END xid [SUSPEND [FOR MIGRATE]]\n\nXA PREPARE xid\n\nXA COMMIT xid [ONE PHASE]\n\nXA ROLLBACK xid\n\nXA RECOVER [FORMAT=[\'RAW\'|\'SQL\']]\n\nxid: gtrid [, bqual [, formatID ]]\n\nThe interface to XA transactions is a set of SQL statements starting with XA.\nEach statement changes a transaction\'s state, determining which actions it can\nperform. A transaction which does not exist is in the NON-EXISTING state.\n\nXA START (or BEGIN) starts a transaction and defines its xid (a transaction\nidentifier). The JOIN or RESUME keywords have no effect. The new transaction\nwill be in ACTIVE state.\n\nThe xid can have 3 components, though only the first one is mandatory. gtrid\nis a quoted string representing a global transaction identifier. bqual is a\nquoted string representing a local transaction identifier. formatID is an\nunsigned integer indicating the format used for the first two components; if\nnot specified, defaults to 1. MariaDB does not interpret in any way these\ncomponents, and only uses them to identify a transaction. xids of transactions\nin effect must be unique.\n\nXA END declares that the specified ACTIVE transaction is finished and it\nchanges its state to IDLE. SUSPEND [FOR MIGRATE] has no effect.\n\nXA PREPARE prepares an IDLE transaction for commit, changing its state to\nPREPARED. This is the first commit.\n\nXA COMMIT definitely commits and terminates a transaction which has already\nbeen PREPARED. If the ONE PHASE clause is specified, this statements performs\na 1-phase commit on an IDLE transaction.\n\nXA ROLLBACK rolls back and terminates an IDLE or PREPARED transaction.\n\nXA RECOVER shows information about all PREPARED transactions.\n\nWhen trying to execute an operation which is not allowed for the transaction\'s\ncurrent state, an error is produced:\n\nXA COMMIT \'test\' ONE PHASE;\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  ACTIVE state\n\nXA COMMIT \'test2\';\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  NON-EXISTING state\n\nXA RECOVER\n----------\n\nThe XA RECOVER statement shows information about all transactions which are in\nthe PREPARED state. It does not matter which connection created the\ntransaction: if it has been PREPARED, it appears. But this does not mean that\na connection can commit or rollback a transaction which was started by another\nconnection. Note that transactions using a 1-phase commit are never in the\nPREPARED state, so they cannot be shown by XA RECOVER.\n\nXA RECOVER produces four columns:\n\nXA RECOVER;\n+----------+--------------+--------------+------+\n| formatID | gtrid_length | bqual_length | data |\n+----------+--------------+--------------+------+\n|        1 |            4 |            0 | test |\n+----------+--------------+--------------+------+\n\nMariaDB starting with 10.3.3\n----------------------------\nYou can use XA RECOVER FORMAT=\'SQL\' to get the data in a human readable form\nthat can be directly copy-pasted into XA COMMIT or XA ROLLBACK. This is\nparticularly useful for binary xid generated by some transaction coordinators.\n\nformatID is the formatID part of xid.\n\ndata are the gtrid and bqual parts of xid, concatenated.\n\ngtrid_length and bqual_length are the lengths of gtrid and bqual, respectevely.\n\nExamples\n--------\n\n2-phases commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA PREPARE \'test\';\n\nXA COMMIT \'test\';\n\n1-phase commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA COMMIT \'test\' ONE PHASE;\n\nHuman-readable:\n\nxa start \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\ninsert t1 values (40);\n\nxa end \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa prepare \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa recover format=\'RAW\';\n+----------+--------------+--------------+--------------------+\n| formatID | gtrid_length | bqual_length | data               |\n+----------+--------------+--------------+--------------------+\n34      67v78abc       11 |            7 | 12\ndef |\n+----------+--------------+--------------+--------------------+\n\nxa recover format=\'SQL\';\n+----------+--------------+--------------+-------------------------------------\n---------+\n| formatID | gtrid_length | bqual_length | data                               \n     |\n+----------+--------------+--------------+-------------------------------------\n---------+\n|        3 |           11 |            7 |\nX\'31320d3334093637763738\',X\'6162630a646566\',3 |\n+----------+--------------+--------------+-------------------------------------\n---------+\n\nxa rollback X\'31320d3334093637763738\',X\'6162630a646566\',3;\n\nKnown Issues\n------------\n\nMariaDB Galera Cluster\n----------------------\n\nMariaDB Galera Cluster does not support XA transactions.\n\nHowever, MariaDB Galera Cluster builds include a built-in plugin called wsrep.\nPrior to MariaDB 10.4.3, this plugin was internally considered an XA-capable\nstorage engine. Consequently, these MariaDB Galera Cluster builds have\nmultiple XA-capable storage engines by default, even if the only \"real\"\nstorage engine that supports external XA transactions enabled on these builds\nby default is InnoDB. Therefore, when using one these builds MariaDB would be\nforced to use a transaction coordinator log by default, which could have\nperformance implications.\n\nSee Transaction Coordinator Log Overview: MariaDB Galera Cluster for more\ninformation.\n\nURL: https://mariadb.com/kb/en/xa-transactions/','','https://mariadb.com/kb/en/xa-transactions/'),
(105,'CREATE USER',10,'Syntax\n------\n\nCREATE [OR REPLACE] USER [IF NOT EXISTS] \n user_specification [,user_specification ...] \n [REQUIRE {NONE | tls_option [[AND] tls_option ...] }]\n [WITH resource_option [resource_option ...] ]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe CREATE USER statement creates new MariaDB accounts. To use it, you must\nhave the global CREATE USER privilege or the INSERT privilege for the mysql\ndatabase. For each account, CREATE USER creates a new row in mysql.user (until\nMariaDB 10.3 this is a table, from MariaDB 10.4 it\'s a view) or\nmysql.global_priv_table (from MariaDB 10.4) that has no privileges.\n\nIf any of the specified accounts, or any permissions for the specified\naccounts, already exist, then the server returns ERROR 1396 (HY000). If an\nerror occurs, CREATE USER will still create the accounts that do not result in\nan error. Only one error is produced for all users which have not been created:\n\nERROR 1396 (HY000): \n Operation CREATE USER failed for \'u1\'@\'%\',\'u2\'@\'%\'\n\nCREATE USER, DROP USER, CREATE ROLE, and DROP ROLE all produce the same error\ncode when they fail.\n\nSee Account Names below for details on how account names are specified.\n\nOR REPLACE\n----------\n\nIf the optional OR REPLACE clause is used, it is basically a shortcut for:\n\nDROP USER IF EXISTS name;\nCREATE USER name ...;\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE OR REPLACE USER foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected (0.00 sec)\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a warning instead\nof an error if the specified user already exists.\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE USER IF NOT EXISTS foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+----------------------------------------------------+\n| Level | Code | Message                                            |\n+-------+------+----------------------------------------------------+\n| Note  | 1973 | Can\'t create user \'foo2\'@\'test\'; it already exists |\n+-------+------+----------------------------------------------------+\n\nAuthentication Options\n----------------------\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored in the\nmysql.user/mysql.global_priv_table table.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nCREATE USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored in the\nmysql.user/mysql.global_priv_table table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nCREATE USER foo2@test IDENTIFIED BY PASSWORD\n\'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nCREATE USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nCREATE USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\') OR\nunix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nCREATE USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to create a user with resource limits:\n\nCREATE USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mariadb-admin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nAccount Names\n-------------\n\nAccount names have both a user name component and a host name component, and\nare specified as \'user_name\'@\'host_name\'.\n\nThe user name and host name may be unquoted, quoted as strings using double\nquotes (\") or single quotes (\'), or quoted as identifiers using backticks (`).\nYou must use quotes when using special characters (such as a hyphen) or\nwildcard characters. If you quote, you must quote the user name and host name\nseparately (for example \'user_name\'@\'host_name\').\n\nHost Name Component\n-------------------\n\nIf the host name is not provided, it is assumed to be \'%\'.\n\nHost names may contain the wildcard characters % and _. They are matched as if\nby the LIKE clause. If you need to use a wildcard character literally (for\nexample, to match a domain name with an underscore), prefix the character with\na backslash. See LIKE for more information on escaping wildcard characters.\n\nHost name matches are case-insensitive. Host names can match either domain\nnames or IP addresses. Use \'localhost\' as the host name to allow only local\nclient connections. On Linux, the loopback interface (127.0.0.1) will not\nmatch \'localhost\' as it is not considered a local connection: this means that\nonly connections via UNIX-domain sockets will match \'localhost\'.\n\nYou can use a netmask to match a range of IP addresses using \'base_ip/netmask\'\nas the host name. A user with an IP address ip_addr will be allowed to connect\nif the following condition is true:\n\nip_addr & netmask = base_ip\n\nFor example, given a user:\n\nCREATE USER \'maria\'@\'247.150.130.0/255.255.255.0\';\n\nthe IP addresses satisfying this condition range from 247.150.130.0 to\n247.150.130.255.\n\nUsing 255.255.255.255 is equivalent to not using a netmask at all. Netmasks\ncannot be used for IPv6 addresses.\n\nNote that the credentials added when creating a user with the \'%\' wildcard\nhost will not grant access in all cases. For example, some systems come with\nan anonymous localhost user, and when connecting from localhost this will take\nprecedence.\n\nBefore MariaDB 10.6, the host name component could be up to 60 characters in\nlength. Starting from MariaDB 10.6, it can be up to 255 characters.\n\nUser Name Component\n-------------------\n\nUser names must match exactly, including case. A user name that is empty is\nknown as an anonymous account and is allowed to match a login attempt with any\nuser name component. These are described more in the next section.\n\nFor valid identifiers to use as user names, see Identifier Names.\n\nIt is possible for more than one account to match when a user connects.\nMariaDB selects the first matching account after sorting according to the\nfollowing criteria:\n\n* Accounts with an exact host name are sorted before accounts using a wildcard\nin the\nhost name. Host names using a netmask are considered to be exact for sorting.\n* Accounts with a wildcard in the host name are sorted according to the\nposition of\nthe first wildcard character. Those with a wildcard character later in the\nhost name\nsort before those with a wildcard character earlier in the host name.\n* Accounts with a non-empty user name sort before accounts with an empty user\nname.\n* Accounts with an empty user name are sorted last. As mentioned previously,\nthese are known as anonymous accounts. These are described more in the next\nsection.\n\nThe following table shows a list of example account as sorted by these\ncriteria:\n\n+---------+-------------+\n| User    | Host        |\n+---------+-------------+\n| joffrey | 192.168.0.3 |\n|         | 192.168.0.% |\n| joffrey | 192.168.%   |\n|         | 192.168.%   |\n+---------+-------------+\n\nOnce connected, you only have the privileges granted to the account that\nmatched, not all accounts that could have matched. For example, consider the\nfollowing commands:\n\nCREATE USER \'joffrey\'@\'192.168.0.3\';\nCREATE USER \'joffrey\'@\'%\';\nGRANT SELECT ON test.t1 to \'joffrey\'@\'192.168.0.3\';\nGRANT SELECT ON test.t2 to \'joffrey\'@\'%\';\n\nIf you connect as joffrey from 192.168.0.3, you will have the SELECT privilege\non the table test.t1, but not on the table test.t2. If you connect as joffrey\nfrom any other IP address, you will have the SELECT privilege on the table\ntest.t2, but not on the table test.t1.\n\nUsernames can be up to 80 characters long before 10.6 and starting from 10.6\nit can be 128 characters long.\n\nAnonymous Accounts\n------------------\n\nAnonymous accounts are accounts where the user name portion of the account\nname is empty. These accounts act as special catch-all accounts. If a user\nattempts to log into the system from a host, and an anonymous account exists\nwith a host name portion that matches the user\'s host, then the user will log\nin as the anonymous account if there is no more specific account match for the\nuser name that the user entered.\n\nFor example, here are some anonymous accounts:\n\nCREATE USER \'\'@\'localhost\';\nCREATE USER \'\'@\'192.168.0.3\';\n\nFixing a Legacy Default Anonymous Account\n-----------------------------------------\n\nOn some systems, the mysql.db table has some entries for the \'\'@\'%\' anonymous\naccount by default. Unfortunately, there is no matching entry in the\nmysql.user/mysql.global_priv_table table, which means that this anonymous\naccount doesn\'t exactly exist, but it does have privileges--usually on the\ndefault test database created by mariadb-install-db. These account-less\nprivileges are a legacy that is leftover from a time when MySQL\'s privilege\nsystem was less advanced.\n\nThis situation means that you will run into errors if you try to create a\n\'\'@\'%\' account. For example:\n\nCREATE USER \'\'@\'%\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'\'@\'%\'\n\nThe fix is to DELETE the row in the mysql.db table and then execute FLUSH\nPRIVILEGES:\n\nDELETE FROM mysql.db WHERE User=\'\' AND Host=\'%\';\nFLUSH PRIVILEGES;\n\nAnd then the account can be created:\n\nCREATE USER \'\'@\'%\';\nQuery OK, 0 rows affected (0.01 sec)\n\nSee MDEV-13486 for more information.\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nCREATE USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/create-user/','','https://mariadb.com/kb/en/create-user/'),
(106,'ALTER USER',10,'Syntax\n------\n\nALTER USER [IF EXISTS] \n user_specification [,user_specification] ...\n [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n [WITH resource_option [resource_option] ...]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule] ...\n\nauthentication_rule:\n authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe ALTER USER statement modifies existing MariaDB accounts. To use it, you\nmust have the global CREATE USER privilege or the UPDATE privilege for the\nmysql database. The global SUPER privilege is also required if the read_only\nsystem variable is enabled.\n\nIf any of the specified user accounts do not yet exist, an error results. If\nan error occurs, ALTER USER will still modify the accounts that do not result\nin an error. Only one error is produced for all users which have not been\nmodified.\n\nIF EXISTS\n---------\n\nWhen the IF EXISTS clause is used, MariaDB will return a warning instead of an\nerror for each specified user that does not exist.\n\nAccount Names\n-------------\n\nFor ALTER USER statements, account names are specified as the username\nargument in the same way as they are for CREATE USER statements. See account\nnames from the CREATE USER page for details on how account names are specified.\n\nCURRENT_USER or CURRENT_USER() can also be used to alter the account logged\ninto the current session. For example, to change the current user\'s password\nto mariadb:\n\nALTER USER CURRENT_USER() IDENTIFIED BY \'mariadb\';\n\nAuthentication Options\n----------------------\n\nMariaDB starting with 10.4\n--------------------------\nFrom MariaDB 10.4, it is possible to use more than one authentication plugin\nfor each user account. For example, this can be useful to slowly migrate users\nto the more secure ed25519 authentication plugin over time, while allowing the\nold mysql_native_password authentication plugin as an alternative for the\ntransitional period. See Authentication from MariaDB 10.4 for more.\n\nWhen running ALTER USER, not specifying an authentication option in the\nIDENTIFIED VIA clause will remove that authentication method. (However this\nwas not the case before MariaDB 10.4.13, see MDEV-21928)\n\nFor example, a user is created with the ability to authenticate via both a\npassword and unix_socket:\n\nCREATE USER \'bob\'@\'localhost\' \n IDENTIFIED VIA mysql_native_password USING PASSWORD(\'pwd\')\n OR unix_socket;\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED VIA mysql_native_password\n USING \'*975B2CD4FF9AE554FE8AD33168FBFC326D2021DD\'\n OR unix_socket\n\nIf the user\'s password is updated, but unix_socket authentication is not\nspecified in the IDENTIFIED VIA clause, unix_socket authentication will no\nlonger be permitted.\n\nALTER USER \'bob\'@\'localhost\' IDENTIFIED VIA mysql_native_password \n USING PASSWORD(\'pwd2\');\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED BY PASSWORD \'*38366FDA01695B6A5A9DD4E428D9FB8F7EB75512\'\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored to the mysql.user table.\n\nFor example, if our password is mariadb, then we can set the account\'s\npassword with:\n\nALTER USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD#function. It will be stored to the\nmysql.user table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n\nAnd then we can set an account\'s password with the hash:\n\nALTER USER foo2@test \n IDENTIFIED BY PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nALTER USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nALTER USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nIn MariaDB 10.4 and later, the USING or AS keyword can also be used to provide\na plain-text password to a plugin if it\'s provided as an argument to the\nPASSWORD() function. This is only valid for authentication plugins that have\nimplemented a hook for the PASSWORD() function. For example, the ed25519\nauthentication plugin supports this:\n\nALTER USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can alter a user account to require these TLS options with\nthe following:\n\nALTER USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\' AND\n ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+------------------------------------+---------------------------------------+\n| Limit Type                         | Description                           |\n+------------------------------------+---------------------------------------+\n| MAX_QUERIES_PER_HOUR               | Number of statements that the         |\n|                                    | account can issue per hour            |\n|                                    | (including updates)                   |\n+------------------------------------+---------------------------------------+\n| MAX_UPDATES_PER_HOUR               | Number of updates (not queries) that  |\n|                                    | the account can issue per hour        |\n+------------------------------------+---------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR           | Number of connections that the        |\n|                                    | account can start per hour            |\n+------------------------------------+---------------------------------------+\n| MAX_USER_CONNECTIONS               | Number of simultaneous connections    |\n|                                    | that can be accepted from the same    |\n|                                    | account; if it is 0, max_connections  |\n|                                    | will be used instead; if              |\n|                                    | max_connections is 0, there is no     |\n|                                    | limit for this account\'s              |\n|                                    | simultaneous connections.             |\n+------------------------------------+---------------------------------------+\n| MAX_STATEMENT_TIME                 | Timeout, in seconds, for statements   |\n|                                    | executed by the user. See also        |\n|                                    | Aborting Statements that Exceed a     |\n|                                    | Certain Time to Execute.              |\n+------------------------------------+---------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to set an account\'s resource limits:\n\nALTER USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE NEVER;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nALTER USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/alter-user/','','https://mariadb.com/kb/en/alter-user/'),
(108,'GRANT',10,'Syntax\n------\n\nGRANT\n  priv_type [(column_list)]\n   [, priv_type [(column_list)]] ...\n  ON [object_type] priv_level\n  TO user_specification [ user_options ...]\n\nuser_specification:\n username [authentication_option]\n | PUBLIC\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\nGRANT PROXY ON username\n  TO user_specification [, user_specification ...]\n  [WITH GRANT OPTION]\n\nGRANT rolename TO grantee [, grantee ...]\n  [WITH ADMIN OPTION]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nuser_options:\n  [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n  [WITH with_option [with_option] ...]\n\nobject_type:\n  TABLE\n | FUNCTION\n | PROCEDURE\n | PACKAGE\n\npriv_level:\n  *\n | *.*\n | db_name.*\n | db_name.tbl_name\n | tbl_name\n | db_name.routine_name\n\nwith_option:\n  GRANT OPTION\n | resource_option\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nDescription\n-----------\n\nThe GRANT statement allows you to grant privileges or roles to accounts. To\nuse GRANT, you must have the GRANT OPTION privilege, and you must have the\nprivileges that you are granting.\n\nUse the REVOKE statement to revoke privileges granted with the GRANT statement.\n\nUse the SHOW GRANTS statement to determine what privileges an account has.\n\nAccount Names\n-------------\n\nFor GRANT statements, account names are specified as the username argument in\nthe same way as they are for CREATE USER statements. See account names from\nthe CREATE USER page for details on how account names are specified.\n\nImplicit Account Creation\n-------------------------\n\nThe GRANT statement also allows you to implicitly create accounts in some\ncases.\n\nIf the account does not yet exist, then GRANT can implicitly create it. To\nimplicitly create an account with GRANT, a user is required to have the same\nprivileges that would be required to explicitly create the account with the\nCREATE USER statement.\n\nIf the NO_AUTO_CREATE_USER SQL_MODE is set, then accounts can only be created\nif authentication information is specified, or with a CREATE USER statement.\nIf no authentication information is provided, GRANT will produce an error when\nthe specified account does not exist, for example:\n\nshow variables like \'%sql_mode%\' ;\n+---------------+--------------------------------------------+\n| Variable_name | Value                                      |\n+---------------+--------------------------------------------+\n| sql_mode      | NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION |\n+---------------+--------------------------------------------+\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' IDENTIFIED BY \'\';\nERROR 1133 (28000): Can\'t find any matching row in the user table\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' \n IDENTIFIED VIA PAM using \'mariadb\' require ssl ;\nQuery OK, 0 rows affected (0.00 sec)\n\nselect host, user from mysql.user where user=\'user123\' ;\n\n+------+----------+\n| host | user     |\n+------+----------+\n| %    | user123 |\n+------+----------+\n\nPrivilege Levels\n----------------\n\nPrivileges can be set globally, for an entire database, for a table or\nroutine, or for individual columns in a table. Certain privileges can only be\nset at certain levels.\n\nGlobal privileges do not take effect immediately and are only applied to\nconnections created after the GRANT statement was executed.\n\n* Global privileges priv_type are granted using *.* for\npriv_level. Global privileges include privileges to administer the database\nand manage user accounts, as well as privileges for all tables, functions, and\nprocedures. Global privileges are stored in the mysql.user table prior to\nMariaDB 10.4, and in  mysql.global_priv table afterwards.\n* Database privileges priv_type are granted using db_name.*\nfor priv_level, or using just * to use default database. Database\nprivileges include privileges to create tables and functions, as well as\nprivileges for all tables, functions, and procedures in the database. Database\nprivileges are stored in the mysql.db table.\n* Table privileges priv_type are granted using db_name.tbl_name\nfor priv_level, or using just tbl_name to specify a table in the default\ndatabase. The TABLE keyword is optional. Table privileges include the\nability to select and change data in the table. Certain table privileges can\nbe granted for individual columns.\n* Column privileges priv_type are granted by specifying a table for\npriv_level and providing a column list after the privilege type. They allow\nyou to control exactly which columns in a table users can select and change.\n* Function privileges priv_type are granted using FUNCTION db_name.routine_name\nfor priv_level, or using just  FUNCTION routine_name to specify a function\nin the default database.\n* Procedure privileges priv_type are granted using PROCEDURE\ndb_name.routine_name\nfor priv_level, or using just PROCEDURE routine_name to specify a procedure\nin the default database.\n\nThe USAGE Privilege\n-------------------\n\nThe USAGE privilege grants no real privileges. The SHOW GRANTS statement will\nshow a global USAGE privilege for a newly-created user. You can use USAGE with\nthe GRANT statement to change options like GRANT OPTION and\nMAX_USER_CONNECTIONS without changing any account privileges.\n\nThe ALL PRIVILEGES Privilege\n----------------------------\n\nThe ALL PRIVILEGES privilege grants all available privileges. Granting all\nprivileges only affects the given privilege level. For example, granting all\nprivileges on a table does not grant any privileges on the database or\nglobally.\n\nUsing ALL PRIVILEGES does not grant the special GRANT OPTION privilege.\n\nYou can use ALL instead of ALL PRIVILEGES.\n\nThe GRANT OPTION Privilege\n--------------------------\n\nUse the WITH GRANT OPTION clause to give users the ability to grant privileges\nto other users at the given privilege level. Users with the GRANT OPTION\nprivilege can only grant privileges they have. They cannot grant privileges at\na higher privilege level than they have the GRANT OPTION privilege.\n\nThe GRANT OPTION privilege cannot be set for individual columns. If you use\nWITH GRANT OPTION when specifying column privileges, the GRANT OPTION\nprivilege will be granted for the entire table.\n\nUsing the WITH GRANT OPTION clause is equivalent to listing GRANT OPTION as a\nprivilege.\n\nGlobal Privileges\n-----------------\n\nThe following table lists the privileges that can be granted globally. You can\nalso grant all database, table, and function privileges globally. When granted\nglobally, these privileges apply to all databases, tables, or functions,\nincluding those created later.\n\nTo set a global privilege, use *.* for priv_level.\n\nBINLOG ADMIN\n------------\n\nEnables administration of the binary log, including the PURGE BINARY LOGS\nstatement and setting the system variables:\n\n* binlog_annotate_row_events\n* binlog_cache_size\n* binlog_commit_wait_count\n* binlog_commit_wait_usec\n* binlog_direct_non_transactional_updates\n* binlog_expire_logs_seconds\n* binlog_file_cache_size\n* binlog_format\n* binlog_row_image\n* binlog_row_metadata\n* binlog_stmt_cache_size\n* expire_logs_days\n* log_bin_compress\n* log_bin_compress_min_len\n* log_bin_trust_function_creators\n* max_binlog_cache_size\n* max_binlog_size\n* max_binlog_stmt_cache_size\n* sql_log_bin and\n* sync_binlog.\n\nAdded in MariaDB 10.5.2.\n\nBINLOG MONITOR\n--------------\n\nNew name for REPLICATION CLIENT from MariaDB 10.5.2, (REPLICATION CLIENT still\nsupported as an alias for compatibility purposes). Permits running SHOW\ncommands related to the binary log, in particular the SHOW BINLOG STATUS and\nSHOW BINARY LOGS statements. Unlike REPLICATION CLIENT prior to MariaDB 10.5,\nSHOW REPLICA STATUS isn\'t included in this privilege, and REPLICA MONITOR is\nrequired.\n\nBINLOG REPLAY\n-------------\n\nEnables replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), executing SET timestamp when secure_timestamp is set to\nreplication, and setting the session values of system variables usually\nincluded in BINLOG output, in particular:\n\n* gtid_domain_id\n* gtid_seq_no\n* pseudo_thread_id\n* server_id.\n\nAdded in MariaDB 10.5.2\n\nCONNECTION ADMIN\n----------------\n\nEnables administering connection resource limit options. This includes\nignoring the limits specified by:\n\n* max_connections\n* max_user_connections and\n* max_password_errors.\n\nThe statements specified in init_connect are not executed, killing connections\nand queries owned by other users is permitted. The following\nconnection-related system variables can be changed:\n\n* connect_timeout\n* disconnect_on_expired_password\n* extra_max_connections\n* init_connect\n* max_connections\n* max_connect_errors\n* max_password_errors\n* proxy_protocol_networks\n* secure_auth\n* slow_launch_time\n* thread_pool_exact_stats\n* thread_pool_dedicated_listener\n* thread_pool_idle_timeout\n* thread_pool_max_threads\n* thread_pool_min_threads\n* thread_pool_oversubscribe\n* thread_pool_prio_kickup_timer\n* thread_pool_priority\n* thread_pool_size, and\n* thread_pool_stall_limit.\n\nAdded in MariaDB 10.5.2.\n\nCREATE USER\n-----------\n\nCreate a user using the CREATE USER statement, or implicitly create a user\nwith the GRANT statement.\n\nFEDERATED ADMIN\n---------------\n\nExecute CREATE SERVER, ALTER SERVER, and DROP SERVER statements. Added in\nMariaDB 10.5.2.\n\nFILE\n----\n\nRead and write files on the server, using statements like LOAD DATA INFILE or\nfunctions like LOAD_FILE(). Also needed to create CONNECT outward tables.\nMariaDB server must have the permissions to access those files.\n\nGRANT OPTION\n------------\n\nGrant global privileges. You can only grant privileges that you have.\n\nPROCESS\n-------\n\nShow information about the active processes, for example via SHOW PROCESSLIST\nor mariadb-admin processlist. If you have the PROCESS privilege, you can see\nall threads. Otherwise, you can see only your own threads (that is, threads\nassociated with the MariaDB account that you are using).\n\nREAD_ONLY ADMIN\n---------------\n\nUser can set the read_only system variable and allows the user to perform\nwrite operations, even when the read_only option is active. Added in MariaDB\n10.5.2.\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary.\n\nRELOAD\n------\n\nExecute FLUSH statements or equivalent mariadb-admin commands.\n\nREPLICATION CLIENT\n------------------\n\nExecute SHOW MASTER STATUS and SHOW BINARY LOGS informative statements.\nRenamed to BINLOG MONITOR in MariaDB 10.5.2 (but still supported as an alias\nfor compatibility reasons). SHOW SLAVE STATUS was part of REPLICATION CLIENT\nprior to MariaDB 10.5.\n\nREPLICATION MASTER ADMIN\n------------------------\n\nPermits administration of primary servers, including the SHOW REPLICA HOSTS\nstatement, and setting the gtid_binlog_state, gtid_domain_id,\nmaster_verify_checksum and server_id system variables. Added in MariaDB 10.5.2.\n\nREPLICA MONITOR\n---------------\n\nPermit SHOW REPLICA STATUS and SHOW RELAYLOG EVENTS. From MariaDB 10.5.9.\n\nWhen a user would upgrade from an older major release to a MariaDB 10.5 minor\nrelease prior to MariaDB 10.5.9, certain user accounts would lose\ncapabilities. For example, a user account that had the REPLICATION CLIENT\nprivilege in older major releases could run SHOW REPLICA STATUS, but after\nupgrading to a MariaDB 10.5 minor release prior to MariaDB 10.5.9, they could\nno longer run SHOW REPLICA STATUS, because that statement was changed to\nrequire the REPLICATION REPLICA ADMIN privilege.\n\nThis issue is fixed in MariaDB 10.5.9 with this new privilege, which now\ngrants the user the ability to execute SHOW [ALL] (SLAVE | REPLICA) STATUS.\n\nWhen a database is upgraded from an older major release to MariaDB Server\n10.5.9 or later, any user accounts with the REPLICATION CLIENT or REPLICATION\nSLAVE privileges will automatically be granted the new REPLICA MONITOR\nprivilege. The privilege fix occurs when the server is started up, not when\nmariadb-upgrade is performed.\n\nHowever, when a database is upgraded from an early 10.5 minor release to\n10.5.9 and later, the user will have to fix any user account privileges\nmanually.\n\nREPLICATION REPLICA\n-------------------\n\nSynonym for REPLICATION SLAVE. From MariaDB 10.5.1.\n\nREPLICATION SLAVE\n-----------------\n\nAccounts used by replica servers on the primary need this privilege. This is\nneeded to get the updates made on the master. From MariaDB 10.5.1, REPLICATION\nREPLICA is an alias for REPLICATION SLAVE.\n\nREPLICATION SLAVE ADMIN\n-----------------------\n\nPermits administering replica servers, including START REPLICA/SLAVE, STOP\nREPLICA/SLAVE, CHANGE MASTER, SHOW REPLICA/SLAVE STATUS, SHOW RELAYLOG EVENTS\nstatements, replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), and setting the system variables:\n\n* gtid_cleanup_batch_size\n* gtid_ignore_duplicates\n* gtid_pos_auto_engines\n* gtid_slave_pos\n* gtid_strict_mode\n* init_slave\n* read_binlog_speed_limit\n* relay_log_purge\n* relay_log_recovery\n* replicate_do_db\n* replicate_do_table\n* replicate_events_marked_for_skip\n* replicate_ignore_db\n* replicate_ignore_table\n* replicate_wild_do_table\n* replicate_wild_ignore_table\n* slave_compressed_protocol\n* slave_ddl_exec_mode\n* slave_domain_parallel_threads\n* slave_exec_mode\n* slave_max_allowed_packet\n* slave_net_timeout\n* slave_parallel_max_queued\n* slave_parallel_mode\n* slave_parallel_threads\n* slave_parallel_workers\n* slave_run_triggers_for_rbr\n* slave_sql_verify_checksum\n* slave_transaction_retry_interval\n* slave_type_conversions\n* sync_master_info\n* sync_relay_log, and\n* sync_relay_log_info.\n\nAdded in MariaDB 10.5.2.\n\nSET USER\n--------\n\nEnables setting the DEFINER when creating triggers, views, stored functions\nand stored procedures. Added in MariaDB 10.5.2.\n\nSHOW DATABASES\n--------------\n\nList all databases using the SHOW DATABASES statement. Without the SHOW\nDATABASES privilege, you can still issue the SHOW DATABASES statement, but it\nwill only list databases containing tables on which you have privileges.\n\nSHUTDOWN\n--------\n\nShut down the server using SHUTDOWN or the mariadb-admin shutdown command.\n\nSUPER\n-----\n\nExecute superuser statements: CHANGE MASTER TO, KILL (users who do not have\nthis privilege can only KILL their own threads), PURGE LOGS, SET global system\nvariables, or the mariadb-admin debug command. Also, this permission allows\nthe user to write data even if the read_only startup option is set, enable or\ndisable logging, enable or disable replication on replica, specify a DEFINER\nfor statements that support that clause, connect once reaching the\nMAX_CONNECTIONS. If a statement has been specified for the init-connect mysqld\noption, that command will not be executed when a user with SUPER privileges\nconnects to the server.\n\nThe SUPER privilege has been split into multiple smaller privileges from\nMariaDB 10.5.2 to allow for more fine-grained privileges (MDEV-21743). The\nprivileges are:\n\n* SET USER\n* FEDERATED ADMIN\n* CONNECTION ADMIN\n* REPLICATION SLAVE ADMIN\n* BINLOG ADMIN\n* BINLOG REPLAY\n* REPLICA MONITOR\n* BINLOG MONITOR\n* REPLICATION MASTER ADMIN\n* READ_ONLY ADMIN\n\nHowever, the smaller privileges are still a part of the SUPER grant in MariaDB\n10.5.2. From MariaDB 11.0.1 onwards, these grants are no longer a part of\nSUPER and need to be granted separately (MDEV-29668).\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary (MDEV-29596).\n\nDatabase Privileges\n-------------------\n\nThe following table lists the privileges that can be granted at the database\nlevel. You can also grant all table and function privileges at the database\nlevel. Table and function privileges on a database apply to all tables or\nfunctions in that database, including those created later.\n\nTo set a privilege for a database, specify the database using db_name.* for\npriv_level, or just use * to specify the default database.\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a database using the CREATE      |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. You can      |\n|                                  | grant the CREATE privilege on           |\n|                                  | databases that do not yet exist. This   |\n|                                  | also grants the CREATE privilege on     |\n|                                  | all tables in the database.             |\n+----------------------------------+-----------------------------------------+\n| CREATE ROUTINE                   | Create Stored Programs using the        |\n|                                  | CREATE PROCEDURE and CREATE FUNCTION    |\n|                                  | statements.                             |\n+----------------------------------+-----------------------------------------+\n| CREATE TEMPORARY TABLES          | Create temporary tables with the        |\n|                                  | CREATE TEMPORARY TABLE statement. This  |\n|                                  | privilege enable writing and dropping   |\n|                                  | those temporary tables                  |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a database using the DROP          |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. This also    |\n|                                  | grants the DROP privilege on all        |\n|                                  | tables in the database.                 |\n+----------------------------------+-----------------------------------------+\n| EVENT                            | Create, drop and alter EVENTs.          |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant database privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n| LOCK TABLES                      | Acquire explicit locks using the LOCK   |\n|                                  | TABLES statement; you also need to      |\n|                                  | have the SELECT privilege on a table,   |\n|                                  | in order to lock it.                    |\n+----------------------------------+-----------------------------------------+\n\nTable Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER                            | Change the structure of an existing     |\n|                                  | table using the ALTER TABLE statement.  |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a table using the CREATE TABLE   |\n|                                  | statement.  You can grant the CREATE    |\n|                                  | privilege on tables that do not yet     |\n|                                  | exist.                                  |\n+----------------------------------+-----------------------------------------+\n| CREATE VIEW                      | Create a view using the CREATE_VIEW     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| DELETE                           | Remove rows from a table using the      |\n|                                  | DELETE statement.                       |\n+----------------------------------+-----------------------------------------+\n| DELETE HISTORY                   | Remove historical rows from a table     |\n|                                  | using the DELETE HISTORY statement.     |\n|                                  | Displays as DELETE VERSIONING ROWS      |\n|                                  | when running SHOW GRANTS until MariaDB  |\n|                                  | 10.3.15 and until MariaDB 10.4.5        |\n|                                  | (MDEV-17655), or when running SHOW      |\n|                                  | PRIVILEGES until MariaDB 10.5.2,        |\n|                                  | MariaDB 10.4.13 and MariaDB 10.3.23     |\n|                                  | (MDEV-20382). From MariaDB 10.3.4.      |\n|                                  | From MariaDB 10.3.5, if a user has the  |\n|                                  | SUPER privilege but not this            |\n|                                  | privilege, running mariadb-upgrade      |\n|                                  | will grant this privilege as well.      |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a table using the DROP TABLE       |\n|                                  | statement or a view using the DROP      |\n|                                  | VIEW statement. Also required to        |\n|                                  | execute the TRUNCATE TABLE statement.   |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant table privileges. You can only    |\n|                                  | grant privileges that you have.         |\n+----------------------------------+-----------------------------------------+\n| INDEX                            | Create an index on a table using the    |\n|                                  | CREATE INDEX statement. Without the     |\n|                                  | INDEX privilege, you can still create   |\n|                                  | indexes when creating a table using     |\n|                                  | the CREATE TABLE statement if the you   |\n|                                  | have the CREATE privilege, and you can  |\n|                                  | create indexes using the ALTER TABLE    |\n|                                  | statement if you have the ALTER         |\n|                                  | privilege.                              |\n+----------------------------------+-----------------------------------------+\n| INSERT                           | Add rows to a table using the INSERT    |\n|                                  | statement.  The INSERT privilege can    |\n|                                  | also be set on individual columns; see  |\n|                                  | Column Privileges below for details.    |\n+----------------------------------+-----------------------------------------+\n| REFERENCES                       | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT                           | Read data from a table using the        |\n|                                  | SELECT statement. The SELECT privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n| SHOW VIEW                        | Show the CREATE VIEW statement to       |\n|                                  | create a view using the SHOW CREATE     |\n|                                  | VIEW statement.                         |\n+----------------------------------+-----------------------------------------+\n| TRIGGER                          | Execute triggers associated to tables   |\n|                                  | you update, execute the CREATE          |\n|                                  | TRIGGER, DROP TRIGGER, and SHOW CREATE  |\n|                                  | TRIGGER statements.                     |\n+----------------------------------+-----------------------------------------+\n| UPDATE                           | Update existing rows in a table using   |\n|                                  | the UPDATE statement. UPDATE            |\n|                                  | statements usually include a WHERE      |\n|                                  | clause to update only certain rows.     |\n|                                  | You must have SELECT privileges on the  |\n|                                  | table or the appropriate columns for    |\n|                                  | the WHERE clause. The UPDATE privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n\nColumn Privileges\n-----------------\n\nSome table privileges can be set for individual columns of a table. To use\ncolumn privileges, specify the table explicitly and provide a list of column\nnames after the privilege type. For example, the following statement would\nallow the user to read the names and positions of employees, but not other\ninformation from the same table, such as salaries.\n\nGRANT SELECT (name, position) on Employee to \'jeffrey\'@\'localhost\';\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| INSERT (column_list)             | Add rows specifying values in columns   |\n|                                  | using the INSERT statement. If you      |\n|                                  | only have column-level INSERT           |\n|                                  | privileges, you must specify the        |\n|                                  | columns you are setting in the INSERT   |\n|                                  | statement. All other columns will be    |\n|                                  | set to their default values, or NULL.   |\n+----------------------------------+-----------------------------------------+\n| REFERENCES (column_list)         | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT (column_list)             | Read values in columns using the        |\n|                                  | SELECT statement. You cannot access or  |\n|                                  | query any columns for which you do not  |\n|                                  | have SELECT privileges, including in    |\n|                                  | WHERE, ON, GROUP BY, and ORDER BY       |\n|                                  | clauses.                                |\n+----------------------------------+-----------------------------------------+\n| UPDATE (column_list)             | Update values in columns of existing    |\n|                                  | rows using the UPDATE statement.        |\n|                                  | UPDATE statements usually include a     |\n|                                  | WHERE clause to update only certain     |\n|                                  | rows. You must have SELECT privileges   |\n|                                  | on the table or the appropriate         |\n|                                  | columns for the WHERE clause.           |\n+----------------------------------+-----------------------------------------+\n\nFunction Privileges\n-------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | function using the ALTER FUNCTION       |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Use a stored function. You need SELECT  |\n|                                  | privileges for any tables or columns    |\n|                                  | accessed by the function.               |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant function privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nProcedure Privileges\n--------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | procedure using the ALTER PROCEDURE     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Execute a stored procedure using the    |\n|                                  | CALL statement. The privilege to call   |\n|                                  | a procedure may allow you to perform    |\n|                                  | actions you wouldn\'t otherwise be able  |\n|                                  | to do, such as insert rows into a       |\n|                                  | table.                                  |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant procedure privileges. You can     |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nGRANT EXECUTE ON PROCEDURE mysql.create_db TO maintainer;\n\nProxy Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| PROXY                            | Permits one user to be a proxy for      |\n|                                  | another.                                |\n+----------------------------------+-----------------------------------------+\n\nThe PROXY privilege allows one user to proxy as another user, which means\ntheir privileges change to that of the proxy user, and the CURRENT_USER()\nfunction returns the user name of the proxy user.\n\nThe PROXY privilege only works with authentication plugins that support it.\nThe default mysql_native_password authentication plugin does not support proxy\nusers.\n\nThe pam authentication plugin is the only plugin included with MariaDB that\ncurrently supports proxy users. The PROXY privilege is commonly used with the\npam authentication plugin to enable user and group mapping with PAM.\n\nFor example, to grant the PROXY privilege to an anonymous account that\nauthenticates with the pam authentication plugin, you could execute the\nfollowing:\n\nCREATE USER \'dba\'@\'%\' IDENTIFIED BY \'strongpassword\';\nGRANT ALL PRIVILEGES ON *.* TO \'dba\'@\'%\' ;\n\nCREATE USER \'\'@\'%\' IDENTIFIED VIA pam USING \'mariadb\';\nGRANT PROXY ON \'dba\'@\'%\' TO \'\'@\'%\';\n\nA user account can only grant the PROXY privilege for a specific user account\nif the granter also has the PROXY privilege for that specific user account,\nand if that privilege is defined WITH GRANT OPTION. For example, the following\nexample fails because the granter does not have the PROXY privilege for that\nspecific user account at all:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nAnd the following example fails because the granter does have the PROXY\nprivilege for that specific user account, but it is not defined WITH GRANT\nOPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\'                     \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nBut the following example succeeds because the granter does have the PROXY\nprivilege for that specific user account, and it is defined WITH GRANT OPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\' WITH GRANT OPTION   \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\n\nA user account can grant the PROXY privilege for any other user account if the\ngranter has the PROXY privilege for the \'\'@\'%\' anonymous user account, like\nthis:\n\nGRANT PROXY ON \'\'@\'%\' TO \'dba\'@\'localhost\' WITH GRANT OPTION;\n\nFor example, the following example succeeds because the user can grant the\nPROXY privilege for any other user account:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'\'@\'%\' TO \'alice\'@\'localhost\' WITH GRANT OPTION              \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'app1_dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nGRANT PROXY ON \'app2_dba\'@\'localhost\' TO \'carol\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nThe default root user accounts created by mariadb-install-db have this\nprivilege. For example:\n\nGRANT ALL PRIVILEGES ON *.* TO \'root\'@\'localhost\' WITH GRANT OPTION;\nGRANT PROXY ON \'\'@\'%\' TO \'root\'@\'localhost\' WITH GRANT OPTION;\n\nThis allows the default root user accounts to grant the PROXY privilege for\nany other user account, and it also allows the default root user accounts to\ngrant others the privilege to do the same.\n\nAuthentication Options\n----------------------\n\nThe authentication options for the GRANT statement are the same as those for\nthe CREATE USER statement.\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \n PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\') OR unix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nTo set resource limits for an account, if you do not want to change that\naccount\'s privileges, you can issue a GRANT statement with the USAGE\nprivilege, which has no meaning. The statement can name some or all limit\ntypes, in any order.\n\nHere is an example showing how to set resource limits:\n\nGRANT USAGE ON *.* TO \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 0\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mariadb-admin reload.\n\nUsers with the CONNECTION ADMIN privilege (in MariaDB 10.5.2 and later) or the\nSUPER privilege are not restricted by max_user_connections, max_connections,\nor max_password_errors.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nGRANT USAGE ON *.* TO \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nRoles\n-----\n\nSyntax\n------\n\nGRANT role TO grantee [, grantee ... ]\n[ WITH ADMIN OPTION ]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nThe GRANT statement is also used to grant the use of a role to one or more\nusers or other roles. In order to be able to grant a role, the grantor doing\nso must have permission to do so (see WITH ADMIN in the CREATE ROLE article).\n\nSpecifying the WITH ADMIN OPTION permits the grantee to in turn grant the role\nto another.\n\nFor example, the following commands show how to grant the same role to a\ncouple different users.\n\nGRANT journalist TO hulda;\n\nGRANT journalist TO berengar WITH ADMIN OPTION;\n\nIf a user has been granted a role, they do not automatically obtain all\npermissions associated with that role. These permissions are only in use when\nthe user activates the role with the SET ROLE statement.\n\nTO PUBLIC\n---------\n\nMariaDB starting with 10.11\n---------------------------\n\nSyntax\n------\n\nGRANT <privilege> ON <database>.<object> TO PUBLIC;\nREVOKE <privilege> ON <database>.<object> FROM PUBLIC;\n\nGRANT ... TO PUBLIC grants privileges to all users with access to the server.\nThe privileges also apply to users created after the privileges are granted.\nThis can be useful when one only wants to state once that all users need to\nhave a certain set of privileges.\n\nWhen running SHOW GRANTS, a user will also see all privileges inherited from\nPUBLIC. SHOW GRANTS FOR PUBLIC will only show TO PUBLIC grants.\n\nGrant Examples\n--------------\n\nGranting Root-like Privileges\n-----------------------------\n\nYou can create a user that has privileges similar to the default root accounts\nby executing the following:\n\nCREATE USER \'alexander\'@\'localhost\';\nGRANT ALL PRIVILEGES ON  *.* to \'alexander\'@\'localhost\' WITH GRANT OPTION;\n\nURL: https://mariadb.com/kb/en/grant/','','https://mariadb.com/kb/en/grant/'),
(118,'Authentication from MariaDB 10.4',10,'MariaDB starting with 10.4\n--------------------------\nMariaDB 10.4 introduced a number of changes to the authentication process,\nintended to make things easier and more intuitive.\n\nOverview\n--------\n\nThere are four new main features in 10.4 relating to authentication:\n\n* It is possible to use more than one authentication plugin for each user\naccount. For example, this can be useful to slowly migrate users to the more\nsecure ed25519 authentication plugin over time, while allowing the old\nmysql_native_password authentication plugin as an alternative for the\ntransitional period.\n* The root@localhost user account created by mariadb-install-db is created\nwith the ability to use two authentication plugins.\nFirst, it is configured to try to use the unix_socket authentication plugin.\nThis allows the root@localhost user to login without a password via the local\nUnix socket file defined by the socket system variable, as long as the login\nis attempted from a process owned by the operating system root user account.\nSecond, if authentication fails with the unix_socket authentication plugin,\nthen it is configured to try to use the mysql_native_password authentication\nplugin. However, an invalid password is initially set, so in order to\nauthenticate this way, a password must be set with SET PASSWORD.\nHowever, just using the unix_socket authentication plugin may be fine for many\nusers, and it is very secure. You may want to try going without password\nauthentication to see how well it works for you. Remember, the best way to\nkeep your password safe is not to have one!\n\n* All user accounts, passwords, and global privileges are now stored in the\nmysql.global_priv table. The mysql.user table still exists and has exactly the\nsame set of columns as before, but it’s now a view that references the\nmysql.global_priv table. Tools that analyze the mysql.user table should\ncontinue to work as before. From MariaDB 10.4.13, the dedicated mariadb.sys\nuser is created as the definer of this view. Previously root was the definer,\nwhich resulted in privilege problems when this username was changed.\n* MariaDB 10.4 adds supports for User Password Expiry, which is not active by\ndefault.\n\nDescription\n-----------\n\nAs a result of the above changes, the open-for-everyone all-powerful root\naccount is finally gone. And installation scripts will no longer demand that\nyou \"PLEASE REMEMBER TO SET A PASSWORD FOR THE MariaDB root USER !\", because\nthe root account is securely created automatically.\n\nTwo all-powerful accounts are created by default — root and the OS user that\nowns the data directory, typically mysql. They are created as:\n\nCREATE USER root@localhost IDENTIFIED VIA unix_socket OR mysql_native_password\nUSING \'invalid\'\nCREATE USER mysql@localhost IDENTIFIED VIA unix_socket OR\nmysql_native_password USING \'invalid\'\n\nUsing unix_socket means that if you are the system root user, you can login as\nroot@locahost without a password. This technique was pioneered by Otto\nKekäläinen in Debian MariaDB packages and has been successfully used in Debian\nsince as early as MariaDB 10.0.\n\nIt is based on a simple fact that asking the system root for a password adds\nno extra security — root has full access to all the data files and all process\nmemory anyway. But not asking for a password means, there is no root password\nto forget (no need for the numerous tutorials on \"how to reset MariaDB root\npassword\"). And if you want to script some tedious database work, there is no\nneed to store the root password in plain text for the script to use (no need\nfor debian-sys-maint user).\n\nStill, some users may wish to log in as MariaDB root without using sudo. Hence\nthe old authentication method — conventional MariaDB password — is still\navailable. By default it is disabled (\"invalid\" is not a valid password hash),\nbut one can set the password with a usual SET PASSWORD statement. And still\nretain the password-less access via sudo.\n\nIf you install MariaDB locally (say from a tarball), you would not want to use\nsudo to be able to login. This is why MariaDB creates a second all-powerful\nuser with the same name as a system user that owns the data directory. In\nlocal (not system-wide) installations, this will be the user who installed\nMariaDB — they automatically get convenient password-less root-like access,\nbecause they can access all the data files anyway.\n\nEven if MariaDB is installed system-wide, you may not want to run your\ndatabase maintenance scripts as system root — now you can run them as system\nmysql user. And you will know that they will never destroy your entire system,\neven if you make a typo in a shell script.\n\nHowever, seasoned MariaDB DBAs who are used to the old ways do need to make\nsome changes. See the examples below for common tasks.\n\nCookbook\n--------\n\nAfter installing MariaDB system-wide the first thing you’ve got used to doing\nis logging in into the unprotected root account and protecting it, that is,\nsetting the root password:\n\n$ sudo dnf install MariaDB-server\n$ mysql -uroot\n...\nMariaDB> set password = password(\"XH4VmT3_jt\");\n\nThis is not only unnecessary now, it will simply not work — there is no\nunprotected root account. To login as root use\n\n$ sudo dnf install MariaDB-server\n$ sudo mysql\n\nNote that it implies you are connecting via the unix socket, not tcp. If you\nhappen to have protocol=tcp in a system-wide /etc/my.cnf file, use sudo mysql\n--protocol=socket.\n\nAfter installing MariaDB locally you’ve also used to connect to the\nunprotected root account using mysql -uroot. This will not work either, simply\nuse mysql without specifying a username.\n\nIf you\'ve forgotten your root password, no problem — you can still connect\nusing sudo and change the password. And if you\'ve also removed unix_socket\nauthentication, to restore access do as follows:\n\n* restart MariaDB with --skip-grant-tables\n* login into the unprotected server\n* run FLUSH PRIVILEGES (note, before 10.4 this would’ve been the last step,\nnot anymore). This disables --skip-grant-tables and allows you to change the\nstored authentication method\n* run SET PASSWORD FOR root@localhost to change the root password.\n\nTo view inside privilege tables, the old mysql.user table still exists. You\ncan select from it as before, although you cannot update it anymore. It\ndoesn’t show alternative authentication plugins and this was one of the\nreasons for switching to the mysql.global_priv table — complex authentication\nrules did not fit into rigid structure of a relational table. You can select\nfrom the new table, for example:\n\nselect concat(user, \'@\', host, \' => \', json_detailed(priv)) from\nmysql.global_priv;\n\nReverting to the Previous Authentication Method for root@localhost\n------------------------------------------------------------------\n\nIf you don\'t want the root@localhost user account created by\nmariadb-install-db to use unix_socket authentication by default, then there\nare a few ways to revert to the previous mysql_native_password authentication\nmethod for this user account.\n\nConfiguring mariadb-install-db to Revert to the Previous Authentication Method\n------------------------------------------------------------------------------\n\nOne way to revert to the previous mysql_native_password authentication method\nfor the root@localhost user account is to execute mariadb-install-db with a\nspecial option. If mariadb-install-db is executed while\n--auth-root-authentication-method=normal is specified, then it will create the\ndefault user accounts using the default behavior of MariaDB 10.3 and before.\n\nThis means that the root@localhost user account will use mysql_native_password\nauthentication by default. There are some other differences as well. See\nmariadb-install-db: User Accounts Created by Default for more information.\n\nFor example, the option can be set on the command-line while running\nmariadb-install-db:\n\nmariadb-install-db --user=mysql --datadir=/var/lib/mysql\n--auth-root-authentication-method=normal\n\nThe option can also be set in an option file in an option group supported by\nmariadb-install-db. For example:\n\n[mysql_install_db]\nauth_root_authentication_method=normal\n\nIf the option is set in an option file and if mariadb-install-db is executed,\nthen mariadb-install-db will read this option from the option file, and it\nwill automatically set this option.\n\nAltering the User Account to Revert to the Previous Authentication Method\n-------------------------------------------------------------------------\n\nIf you have already installed MariaDB, and if the root@localhost user account\nis already using unix_socket authentication, then you can revert to the old\nmysql_native_password authentication method for the user account by executing\nthe following:\n\nALTER USER root@localhost IDENTIFIED VIA mysql_native_password USING\nPASSWORD(\"verysecret\")\n\nURL: https://mariadb.com/kb/en/authentication-from-mariadb-104/','','https://mariadb.com/kb/en/authentication-from-mariadb-104/'),
(88,'CASE OPERATOR',7,'Syntax\n------\n\nCASE value WHEN [compare_value] THEN result [WHEN [compare_value] THEN\nresult ...] [ELSE result] END\n\nCASE WHEN [condition] THEN result [WHEN [condition] THEN result ...]\n[ELSE result] END\n\nDescription\n-----------\n\nThe first version returns the result where value=compare_value. The second\nversion returns the result for the first condition that is true. If there was\nno matching result value, the result after ELSE is returned, or NULL if there\nis no ELSE part.\n\nThere is also a CASE statement, which differs from the CASE operator described\nhere.\n\nExamples\n--------\n\nSELECT CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END;\n+------------------------------------------------------------+\n| CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END |\n+------------------------------------------------------------+\n| one                                                        |\n+------------------------------------------------------------+\n\nSELECT CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END;\n+--------------------------------------------+\n| CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END |\n+--------------------------------------------+\n| true                                       |\n+--------------------------------------------+\n\nSELECT CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END;\n+-----------------------------------------------------+\n| CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END |\n+-----------------------------------------------------+\n|                                                NULL |\n+-----------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/case-operator/','','https://mariadb.com/kb/en/case-operator/'),
(89,'IF Function',7,'Syntax\n------\n\nIF(expr1,expr2,expr3)\n\nDescription\n-----------\n\nIf expr1 is TRUE (expr1 <> 0 and expr1 <> NULL) then IF() returns expr2;\notherwise it returns expr3. IF() returns a numeric or string value, depending\non the context in which it is used.\n\nNote: There is also an IF statement which differs from the IF() function\ndescribed here.\n\nExamples\n--------\n\nSELECT IF(1>2,2,3);\n+-------------+\n| IF(1>2,2,3) |\n+-------------+\n|           3 |\n+-------------+\n\nSELECT IF(1<2,\'yes\',\'no\');\n+--------------------+\n| IF(1<2,\'yes\',\'no\') |\n+--------------------+\n| yes                |\n+--------------------+\n\nSELECT IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\');\n+---------------------------------------+\n| IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\') |\n+---------------------------------------+\n| no                                    |\n+---------------------------------------+\n\nURL: https://mariadb.com/kb/en/if-function/','','https://mariadb.com/kb/en/if-function/'),
(90,'IFNULL',7,'Syntax\n------\n\nIFNULL(expr1,expr2)\nNVL(expr1,expr2)\n\nDescription\n-----------\n\nIf expr1 is not NULL, IFNULL() returns expr1; otherwise it returns expr2.\nIFNULL() returns a numeric or string value, depending on the context in which\nit is used.\n\nFrom MariaDB 10.3, NVL() is an alias for IFNULL().\n\nExamples\n--------\n\nSELECT IFNULL(1,0); \n+-------------+\n| IFNULL(1,0) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT IFNULL(NULL,10);\n+-----------------+\n| IFNULL(NULL,10) |\n+-----------------+\n|              10 |\n+-----------------+\n\nSELECT IFNULL(1/0,10);\n+----------------+\n| IFNULL(1/0,10) |\n+----------------+\n|        10.0000 |\n+----------------+\n\nSELECT IFNULL(1/0,\'yes\');\n+-------------------+\n| IFNULL(1/0,\'yes\') |\n+-------------------+\n| yes               |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/ifnull/','','https://mariadb.com/kb/en/ifnull/'),
(95,'COMMIT',8,'The COMMIT statement ends a transaction, saving any changes to the data so\nthat they become visible to subsequent transactions. Also, unlocks metadata\nchanged by current transaction. If autocommit is set to 1, an implicit commit\nis performed after each statement. Otherwise, all transactions which don\'t end\nwith an explicit COMMIT are implicitly rollbacked and the changes are lost.\nThe ROLLBACK statement can be used to do this explicitly.\n\nThe required syntax for the COMMIT statement is as follows:\n\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\n\nCOMMIT is the more important transaction terminator, as well as the more\ninteresting one. The basic form of the COMMIT statement is simply the keyword\nCOMMIT (the keyword WORK is simply noise and can be omitted without changing\nthe effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated.\n\nRELEASE tells the server to disconnect the client immediately after the\ncurrent transaction.\n\nThere are NO RELEASE and AND NO CHAIN options. By default, commits do not\nRELEASE or CHAIN, but it\'s possible to change this default behavior with the\ncompletion_type server system variable. In this case, the AND NO CHAIN and NO\nRELEASE options override the server default.\n\nURL: https://mariadb.com/kb/en/commit/','','https://mariadb.com/kb/en/commit/'),
(120,'ST_X',11,'Syntax\n------\n\nST_X(p)\nX(p)\n\nDescription\n-----------\n\nReturns the X-coordinate value for the point p as a double-precision number.\n\nST_X() and X() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT X(GeomFromText(@pt));\n+----------------------+\n| X(GeomFromText(@pt)) |\n+----------------------+\n|                 56.7 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_x/','','https://mariadb.com/kb/en/st_x/'),
(121,'ST_Y',11,'Syntax\n------\n\nST_Y(p)\nY(p)\n\nDescription\n-----------\n\nReturns the Y-coordinate value for the point p as a double-precision number.\n\nST_Y() and Y() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT Y(GeomFromText(@pt));\n+----------------------+\n| Y(GeomFromText(@pt)) |\n+----------------------+\n|                53.34 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_y/','','https://mariadb.com/kb/en/st_y/'),
(122,'X',11,'A synonym for ST_X.\n\nURL: https://mariadb.com/kb/en/point-properties-x/','','https://mariadb.com/kb/en/point-properties-x/'),
(123,'Y',11,'A synonym for ST_Y.\n\nURL: https://mariadb.com/kb/en/point-properties-y/','','https://mariadb.com/kb/en/point-properties-y/'),
(126,'DECODE_ORACLE',12,'MariaDB starting with 10.3.2\n----------------------------\nDECODE_ORACLE is a synonym for the Oracle mode version of the DECODE function,\nand is available in all modes.\n\nURL: https://mariadb.com/kb/en/decode_oracle/','','https://mariadb.com/kb/en/decode_oracle/'),
(134,'MD5',12,'Syntax\n------\n\nMD5(str)\n\nDescription\n-----------\n\nCalculates an MD5 128-bit checksum for the string.\n\nThe return value is a 32-hex digit string, and as of MariaDB 5.5, is a\nnonbinary string in the connection character set and collation, determined by\nthe values of the character_set_connection and collation_connection system\nvariables. Before 5.5, the return value was a binary string.\n\nNULL is returned if the argument was NULL.\n\nExamples\n--------\n\nSELECT MD5(\'testing\');\n+----------------------------------+\n| MD5(\'testing\')                   |\n+----------------------------------+\n| ae2b1fca515949e5d54fb22b8ed95575 |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/md5/','','https://mariadb.com/kb/en/md5/'),
(94,'START TRANSACTION',8,'Syntax\n------\n\nSTART TRANSACTION [transaction_property [, transaction_property] ...] | BEGIN\n[WORK]\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nROLLBACK [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nSET autocommit = {0 | 1}\n\ntransaction_property:\n  WITH CONSISTENT SNAPSHOT\n | READ WRITE\n | READ ONLY\n\nDescription\n-----------\n\nThe START TRANSACTION or BEGIN statement begins a new transaction. COMMIT\ncommits the current transaction, making its changes permanent. ROLLBACK rolls\nback the current transaction, canceling its changes. The SET autocommit\nstatement disables or enables the default autocommit mode for the current\nsession.\n\nSTART TRANSACTION and SET autocommit = 1 implicitly commit the current\ntransaction, if any.\n\nThe optional WORK keyword is supported for COMMIT and ROLLBACK, as are the\nCHAIN and RELEASE clauses. CHAIN and RELEASE can be used for additional\ncontrol over transaction completion. The value of the completion_type system\nvariable determines the default completion behavior.\n\nThe AND CHAIN clause causes a new transaction to begin as soon as the current\none ends, and the new transaction has the same isolation level as the\njust-terminated transaction. The RELEASE clause causes the server to\ndisconnect the current client session after terminating the current\ntransaction. Including the NO keyword suppresses CHAIN or RELEASE completion,\nwhich can be useful if the completion_type system variable is set to cause\nchaining or release completion by default.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. Note that\nunlike the global read_only mode, READ_ONLY ADMIN (and SUPER before MariaDB\n10.11.0) privilege doesn\'t allow writes and DDL statements on temporary tables\nare not allowed either.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the SET TRANSACTION\nstatement, in which case the specified mode is valid for all sessions, or for\nall subsequent transaction used by the current session.\n\nautocommit\n----------\n\nBy default, MariaDB runs with autocommit mode enabled. This means that as soon\nas you execute a statement that updates (modifies) a table, MariaDB stores the\nupdate on disk to make it permanent. To disable autocommit mode, use the\nfollowing statement:\n\nSET autocommit=0;\n\nAfter disabling autocommit mode by setting the autocommit variable to zero,\nchanges to transaction-safe tables (such as those for InnoDB or NDBCLUSTER)\nare not made permanent immediately. You must use COMMIT to store your changes\nto disk or ROLLBACK to ignore the changes.\n\nTo disable autocommit mode for a single series of statements, use the START\nTRANSACTION statement.\n\nDDL Statements\n--------------\n\nDDL statements (CREATE, ALTER, DROP) and administrative statements (FLUSH,\nRESET, OPTIMIZE, ANALYZE, CHECK, REPAIR, CACHE INDEX), transaction management\nstatements (BEGIN, START TRANSACTION) and LOAD DATA INFILE, cause an implicit\nCOMMIT and start a new transaction. An exception to this rule are the DDL that\noperate on temporary tables: you can CREATE, ALTER and DROP them without\ncausing any COMMIT, but those actions cannot be rolled back. This means that\nif you call ROLLBACK, the temporary tables you created in the transaction will\nremain, while the rest of the transaction will be rolled back.\n\nTransactions cannot be used in Stored Functions or Triggers. In Stored\nProcedures and Events BEGIN is not allowed, so you should use START\nTRANSACTION instead.\n\nA transaction acquires a metadata lock on every table it accesses to prevent\nother connections from altering their structure. The lock is released at the\nend of the transaction. This happens even with non-transactional storage\nengines (like MEMORY or CONNECT), so it makes sense to use transactions with\nnon-transactional tables.\n\nin_transaction\n--------------\n\nThe in_transaction system variable is a session-only, read-only variable that\nreturns 1 inside a transaction, and 0 if not in a transaction.\n\nWITH CONSISTENT SNAPSHOT\n------------------------\n\nThe WITH CONSISTENT SNAPSHOT option starts a consistent read for storage\nengines such as InnoDB that can do so, the same as if a START TRANSACTION\nfollowed by a SELECT from any InnoDB table was issued.\n\nSee Enhancements for START TRANSACTION WITH CONSISTENT SNAPSHOT.\n\nExamples\n--------\n\nSTART TRANSACTION;\nSELECT @A:=SUM(salary) FROM table1 WHERE type=1;\nUPDATE table2 SET summary=@A WHERE type=1;\nCOMMIT;\n\nURL: https://mariadb.com/kb/en/start-transaction/','','https://mariadb.com/kb/en/start-transaction/'),
(99,'SAVEPOINT',8,'Syntax\n------\n\nSAVEPOINT identifier\nROLLBACK [WORK] TO [SAVEPOINT] identifier\nRELEASE SAVEPOINT identifier\n\nDescription\n-----------\n\nInnoDB supports the SQL statements SAVEPOINT, ROLLBACK TO SAVEPOINT, RELEASE\nSAVEPOINT and the optional WORK keyword for ROLLBACK.\n\nEach savepoint must have a legal MariaDB identifier. A savepoint is a named\nsub-transaction.\n\nNormally ROLLBACK undoes the changes performed by the whole transaction. When\nused with the TO clause, it undoes the changes performed after the specified\nsavepoint, and erases all subsequent savepoints. However, all locks that have\nbeen acquired after the save point will survive. RELEASE SAVEPOINT does not\nrollback or commit any changes, but removes the specified savepoint.\n\nWhen the execution of a trigger or a stored function begins, it is not\npossible to use statements which reference a savepoint which was defined from\nout of that stored program.\n\nWhen a COMMIT (including implicit commits) or a ROLLBACK statement (with no TO\nclause) is performed, they act on the whole transaction, and all savepoints\nare removed.\n\nErrors\n------\n\nIf COMMIT or ROLLBACK is issued and no transaction was started, no error is\nreported.\n\nIf SAVEPOINT is issued and no transaction was started, no error is reported\nbut no savepoint is created. When ROLLBACK TO SAVEPOINT or RELEASE SAVEPOINT\nis called for a savepoint that does not exist, an error like this is issued:\n\nERROR 1305 (42000): SAVEPOINT svp_name does not exist\n\nURL: https://mariadb.com/kb/en/savepoint/','','https://mariadb.com/kb/en/savepoint/'),
(140,'ENDPOINT',13,'A synonym for ST_ENDPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-endpoint/','','https://mariadb.com/kb/en/linestring-properties-endpoint/'),
(141,'GLENGTH',13,'Syntax\n------\n\nGLength(ls)\n\nDescription\n-----------\n\nReturns as a double-precision number the length of the LineString value ls in\nits associated spatial reference.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT GLength(GeomFromText(@ls));\n+----------------------------+\n| GLength(GeomFromText(@ls)) |\n+----------------------------+\n|           2.82842712474619 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/glength/','','https://mariadb.com/kb/en/glength/'),
(142,'NumPoints',13,'A synonym for ST_NumPoints.\n\nURL: https://mariadb.com/kb/en/linestring-properties-numpoints/','','https://mariadb.com/kb/en/linestring-properties-numpoints/'),
(143,'PointN',13,'A synonym for ST_PointN.\n\nURL: https://mariadb.com/kb/en/linestring-properties-pointn/','','https://mariadb.com/kb/en/linestring-properties-pointn/'),
(96,'ROLLBACK',8,'The ROLLBACK statement rolls back (ends) a transaction, destroying any changes\nto SQL-data so that they never become visible to subsequent transactions. The\nrequired syntax for the ROLLBACK statement is as follows.\n\nROLLBACK [ WORK ] [ AND [ NO ] CHAIN ] \n[ TO [ SAVEPOINT ] {<savepoint name> | <simple target specification>} ]\n\nThe ROLLBACK statement will either end a transaction, destroying all data\nchanges that happened during any of the transaction, or it will just destroy\nany data changes that happened since you established a savepoint. The basic\nform of the ROLLBACK statement is just the keyword ROLLBACK (the keyword WORK\nis simply noise and can be omitted without changing the effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated. The AND NO CHAIN option just tells your DBMS to end the\ntransaction — that is, these four SQL statements are equivalent:\n\nROLLBACK; \nROLLBACK WORK; \nROLLBACK AND NO CHAIN; \nROLLBACK WORK AND NO CHAIN;\n\nAll of them end a transaction without saving any transaction characteristics.\nThe only other options, the equivalent statements:\n\nROLLBACK AND CHAIN;\nROLLBACK WORK AND CHAIN;\n\nboth tell your DBMS to end a transaction, but to save that transaction\'s\ncharacteristics for the next transaction.\n\nROLLBACK is much simpler than COMMIT: it may involve no more than a few\ndeletions (of Cursors, locks, prepared SQL statements and log-file entries).\nIt\'s usually assumed that ROLLBACK can\'t fail, although such a thing is\nconceivable (for example, an encompassing transaction might reject an attempt\nto ROLLBACK because it\'s lining up for a COMMIT).\n\nROLLBACK cancels all effects of a transaction. It does not cancel effects on\nobjects outside the DBMS\'s control (for example the values in host program\nvariables or the settings made by some SQL/CLI function calls). But in\ngeneral, it is a convenient statement for those situations when you say \"oops,\nthis isn\'t working\" or when you simply don\'t care whether your temporary work\nbecomes permanent or not.\n\nHere is a moot question. If all you\'ve been doing is SELECTs, so that there\nhave been no data changes, should you end the transaction with ROLLBACK or\nCOMMIT? It shouldn\'t really matter because both ROLLBACK and COMMIT do the\nsame transaction-terminating job. However, the popular conception is that\nROLLBACK implies failure, so after a successful series of SELECT statements\nthe convention is to end the transaction with COMMIT rather than ROLLBACK.\n\nMariaDB (and most other DBMSs) supports rollback of SQL-data change\nstatements, but not of SQL-Schema statements. This means that if you use any\nof CREATE, ALTER, DROP, GRANT, REVOKE, you are implicitly committing at\nexecution time.\n\nINSERT INTO Table_2 VALUES(5); \nDROP TABLE Table_3 CASCADE; \nROLLBACK;\n\nThe result will be that both the INSERT and the DROP will go through as\nseparate transactions so the ROLLBACK will have no effect.\n\nURL: https://mariadb.com/kb/en/rollback/','','https://mariadb.com/kb/en/rollback/'),
(100,'Metadata Locking',8,'MariaDB supports metadata locking. This means that when a transaction\n(including XA transactions) uses a table, it locks its metadata until the end\nof transaction. Non-transactional tables are also locked, as well as views and\nobjects which are related to locked tables/views (stored functions, triggers,\netc). When a connection tries to use a DDL statement (like an ALTER TABLE)\nwhich modifies a table that is locked, that connection is queued, and has to\nwait until it\'s unlocked. Using savepoints and performing a partial rollback\ndoes not release metadata locks.\n\nLOCK TABLES ... WRITE are also queued. Some wrong statements which produce an\nerror may not need to wait for the lock to be freed.\n\nThe metadata lock\'s timeout is determined by the value of the\nlock_wait_timeout server system variable (in seconds). However, note that its\ndefault value is 31536000 (1 year, MariaDB <= 10.2.3), or 86400 (1 day,\nMariaDB >= 10.2.4). If this timeout is exceeded, the following error is\nreturned:\n\nERROR 1205 (HY000): Lock wait timeout exceeded; try restarting transaction\n\nIf the metadata_lock_info plugin is installed, the Information Schema\nmetadata_lock_info table stores information about existing metadata locks.\n\nMariaDB starting with 10.5.2\n----------------------------\nFrom MariaDB 10.5, the Performance Schema metadata_locks table contains\nmetadata lock information.\n\nExample\n-------\n\nLet\'s use the following MEMORY (non-transactional) table:\n\nCREATE TABLE t (a INT) ENGINE = MEMORY;\n\nConnection 1 starts a transaction, and INSERTs a row into t:\n\nSTART TRANSACTION;\n\nINSERT INTO t SET a=1;\n\nt\'s metadata is now locked by connection 1. Connection 2 tries to alter t, but\nhas to wait:\n\nALTER TABLE t ADD COLUMN b INT;\n\nConnection 2\'s prompt is blocked now.\n\nNow connection 1 ends the transaction:\n\nCOMMIT;\n\n...and connection 2 finally gets the output of its command:\n\nQuery OK, 1 row affected (35.23 sec)\nRecords: 1  Duplicates: 0  Warnings: 0\n\nURL: https://mariadb.com/kb/en/metadata-locking/','','https://mariadb.com/kb/en/metadata-locking/'),
(144,'STARTPOINT',13,'A synonym for ST_STARTPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-startpoint/','','https://mariadb.com/kb/en/linestring-properties-startpoint/'),
(145,'ST_ENDPOINT',13,'Syntax\n------\n\nST_EndPoint(ls)\nEndPoint(ls)\n\nDescription\n-----------\n\nReturns the Point that is the endpoint of the LineString value ls.\n\nST_EndPoint() and EndPoint() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(EndPoint(GeomFromText(@ls)));\n+-------------------------------------+\n| AsText(EndPoint(GeomFromText(@ls))) |\n+-------------------------------------+\n| POINT(3 3)                          |\n+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_endpoint/','','https://mariadb.com/kb/en/st_endpoint/'),
(146,'ST_NUMPOINTS',13,'Syntax\n------\n\nST_NumPoints(ls)\nNumPoints(ls)\n\nDescription\n-----------\n\nReturns the number of Point objects in the LineString value ls.\n\nST_NumPoints() and NumPoints() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT NumPoints(GeomFromText(@ls));\n+------------------------------+\n| NumPoints(GeomFromText(@ls)) |\n+------------------------------+\n|                            3 |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/st_numpoints/','','https://mariadb.com/kb/en/st_numpoints/'),
(147,'ST_POINTN',13,'Syntax\n------\n\nST_PointN(ls,N)\nPointN(ls,N)\n\nDescription\n-----------\n\nReturns the N-th Point in the LineString value ls. Points are numbered\nbeginning with 1.\n\nST_PointN() and PointN() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(PointN(GeomFromText(@ls),2));\n+-------------------------------------+\n| AsText(PointN(GeomFromText(@ls),2)) |\n+-------------------------------------+\n| POINT(2 2)                          |\n+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_pointn/','','https://mariadb.com/kb/en/st_pointn/'),
(97,'SET TRANSACTION',8,'Syntax\n------\n\nSET [GLOBAL | SESSION] TRANSACTION\n  transaction_property [, transaction_property] ...\n\ntransaction_property:\n  ISOLATION LEVEL level\n | READ WRITE\n | READ ONLY\n\nlevel:\n  REPEATABLE READ\n | READ COMMITTED\n | READ UNCOMMITTED\n | SERIALIZABLE\n\nDescription\n-----------\n\nThis statement sets the transaction isolation level or the transaction access\nmode globally, for the current session, or for the next transaction:\n\n* With the GLOBAL keyword, the statement sets the default\n transaction level globally for all subsequent sessions. Existing sessions are\n unaffected.\n* With the SESSION keyword, the statement sets the default\n transaction level for all subsequent transactions performed within the\n current session.\n* Without any SESSION or GLOBAL keyword,\n the statement sets the isolation level for the next (not started) transaction\n performed within the current session.\n\nA change to the global default isolation level requires the SUPER privilege.\nAny session is free to change its session isolation level (even in the middle\nof a transaction), or the isolation level for its next transaction.\n\nIsolation Level\n---------------\n\nTo set the global default isolation level at server startup, use the\n--transaction-isolation=level option on the command line or in an option file.\nValues of level for this option use dashes rather than spaces, so the\nallowable values are READ_UNCOMMITTED, READ-COMMITTED, REPEATABLE-READ, or\nSERIALIZABLE. For example, to set the default isolation level to REPEATABLE\nREAD, use these lines in the [mysqld] section of an option file:\n\n[mysqld]\ntransaction-isolation = REPEATABLE-READ\nTo determine the global and session transaction isolation levels at runtime,\ncheck the value of the tx_isolation system variable (note that the variable\nhas been renamed transaction_isolation from MariaDB 11.1.1, to match the\noption, and the old name deprecated).\n\nSELECT @@GLOBAL.tx_isolation, @@tx_isolation;\n\nFrom MariaDB 11.1.1:\n\nSELECT @@GLOBAL.transaction_isolation, @@transaction_isolation;\n\nInnoDB supports each of the translation isolation levels described here using\ndifferent locking strategies. The default level is REPEATABLE READ. For\nadditional information about InnoDB record-level locks and how it uses them to\nexecute various types of statements, see InnoDB Lock Modes, and\nhttp://dev.mysql.com/doc/refman/en/innodb-locks-set.html.\n\nIsolation Levels\n----------------\n\nThe following sections describe how MariaDB supports the different transaction\nlevels.\n\nREAD UNCOMMITTED\n----------------\n\nSELECT statements are performed in a non-locking fashion, but a possible\nearlier version of a row might be used. Thus, using this isolation level, such\nreads are not consistent. This is also called a \"dirty read.\" Otherwise, this\nisolation level works like READ COMMITTED.\n\nREAD COMMITTED\n--------------\n\nA somewhat Oracle-like isolation level with respect to consistent\n(non-locking) reads: Each consistent read, even within the same transaction,\nsets and reads its own fresh snapshot. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), InnoDB locks\nonly index records, not the gaps before them, and thus allows the free\ninsertion of new records next to locked records. For UPDATE and DELETE\nstatements, locking depends on whether the statement uses a unique index with\na unique search condition (such as WHERE id = 100), or a range-type search\ncondition (such as WHERE id > 100). For a unique index with a unique search\ncondition, InnoDB locks only the index record found, not the gap before it.\nFor range-type searches, InnoDB locks the index range scanned, using gap locks\nor next-key (gap plus index-record) locks to block insertions by other\nsessions into the gaps covered by the range. This is necessary because\n\"phantom rows\" must be blocked for MySQL replication and recovery to work.\n\nNote: If the READ COMMITTED isolation level is used or the\ninnodb_locks_unsafe_for_binlog system variable is enabled, there is no InnoDB\ngap locking except for foreign-key constraint checking and duplicate-key\nchecking. Also, record locks for non-matching rows are released after MariaDB\nhas evaluated the WHERE condition.If you use READ COMMITTED or enable\ninnodb_locks_unsafe_for_binlog, you must use row-based binary logging.\n\nREPEATABLE READ\n---------------\n\nThis is the default isolation level for InnoDB. For consistent reads, there is\nan important difference from the READ COMMITTED isolation level: All\nconsistent reads within the same transaction read the snapshot established by\nthe first read. This convention means that if you issue several plain\n(non-locking) SELECT statements within the same transaction, these SELECT\nstatements are consistent also with respect to each other. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), UPDATE, and\nDELETE statements, locking depends on whether the statement uses a unique\nindex with a unique search condition, or a range-type search condition. For a\nunique index with a unique search condition, InnoDB locks only the index\nrecord found, not the gap before it. For other search conditions, InnoDB locks\nthe index range scanned, using gap locks or next-key (gap plus index-record)\nlocks to block insertions by other sessions into the gaps covered by the range.\n\nThis is the minimum isolation level for non-distributed XA transactions.\n\nSERIALIZABLE\n------------\n\nThis level is like REPEATABLE READ, but InnoDB implicitly converts all plain\nSELECT statements to SELECT ... LOCK IN SHARE MODE if autocommit is disabled.\nIf autocommit is enabled, the SELECT is its own transaction. It therefore is\nknown to be read only and can be serialized if performed as a consistent\n(non-locking) read and need not block for other transactions. (This means that\nto force a plain SELECT to block if other transactions have modified the\nselected rows, you should disable autocommit.)\n\nDistributed XA transactions should always use this isolation level.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. Note that\nunlike the global read_only mode, READ_ONLY ADMIN (and SUPER before MariaDB\n10.11.0) privilege doesn\'t allow writes and DDL statements on temporary tables\nare not allowed either.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the START TRANSACTION\nstatement, in which case the specified mode is only valid for one transaction.\n\nExamples\n--------\n\nSET GLOBAL TRANSACTION ISOLATION LEVEL SERIALIZABLE;\n\nAttempting to set the isolation level within an existing transaction without\nspecifying GLOBAL or SESSION.\n\nSTART TRANSACTION;\n\nSET TRANSACTION ISOLATION LEVEL SERIALIZABLE;\nERROR 1568 (25001): Transaction characteristics can\'t be changed while a\ntransaction is in progress\n\nURL: https://mariadb.com/kb/en/set-transaction/','','https://mariadb.com/kb/en/set-transaction/'),
(148,'ST_STARTPOINT',13,'Syntax\n------\n\nST_StartPoint(ls)\nStartPoint(ls)\n\nDescription\n-----------\n\nReturns the Point that is the start point of the LineString value ls.\n\nST_StartPoint() and StartPoint() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(StartPoint(GeomFromText(@ls)));\n+---------------------------------------+\n| AsText(StartPoint(GeomFromText(@ls))) |\n+---------------------------------------+\n| POINT(1 1)                            |\n+---------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_startpoint/','','https://mariadb.com/kb/en/st_startpoint/'),
(98,'LOCK TABLES',8,'Syntax\n------\n\nLOCK TABLE[S]\n  tbl_name [[AS] alias] lock_type\n  [, tbl_name [[AS] alias] lock_type] ...\n  [WAIT n|NOWAIT]\n\nlock_type:\n  READ [LOCAL]\n | [LOW_PRIORITY] WRITE\n | WRITE CONCURRENT\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nThe lock_type can be one of:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| READ                      | Read lock, no writes allowed                   |\n+---------------------------+------------------------------------------------+\n| READ LOCAL                | Read lock, but allow concurrent inserts        |\n+---------------------------+------------------------------------------------+\n| WRITE                     | Exclusive write lock. No other connections     |\n|                           | can read or write to this table                |\n+---------------------------+------------------------------------------------+\n| LOW_PRIORITY WRITE        | Exclusive write lock, but allow new read       |\n|                           | locks on the table until we get the write      |\n|                           | lock.                                          |\n+---------------------------+------------------------------------------------+\n| WRITE CONCURRENT          | Exclusive write lock, but allow READ LOCAL     |\n|                           | locks to the table.                            |\n+---------------------------+------------------------------------------------+\n\nMariaDB enables client sessions to acquire table locks explicitly for the\npurpose of cooperating with other sessions for access to tables, or to prevent\nother sessions from modifying tables during periods when a session requires\nexclusive access to them. A session can acquire or release locks only for\nitself. One session cannot acquire locks for another session or release locks\nheld by another session.\n\nLocks may be used to emulate transactions or to get more speed when updating\ntables.\n\nLOCK TABLES explicitly acquires table locks for the current client session.\nTable locks can be acquired for base tables or views. To use LOCK TABLES, you\nmust have the LOCK TABLES privilege, and the SELECT privilege for each object\nto be locked. See GRANT\n\nFor view locking, LOCK TABLES adds all base tables used in the view to the set\nof tables to be locked and locks them automatically. If you lock a table\nexplicitly with LOCK TABLES, any tables used in triggers are also locked\nimplicitly, as described in Triggers and Implicit Locks.\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\n\nMariaDB starting with 10.3.0\n----------------------------\n\nWAIT/NOWAIT\n-----------\n\nSet the lock wait timeout. See WAIT and NOWAIT.\n\nLimitations\n-----------\n\n* LOCK TABLES doesn\'t work when using Galera cluster.   You may experience\ncrashes or locks when used with Galera.\n* LOCK TABLES works on XtraDB/InnoDB tables only if the innodb_table_locks\nsystem variable is set to 1 (the default) and autocommit is set to 0 (1 is\ndefault). Please note that no error message will be returned on LOCK TABLES\nwith innodb_table_locks = 0.\n* LOCK TABLES implicitly commits the active transaction, if any. Also,\nstarting a transaction always releases all table locks acquired with LOCK\nTABLES. This means that there is no way to have table locks and an active\ntransaction at the same time. The only exceptions are the transactions in\nautocommit mode. To preserve the data integrity between transactional and\nnon-transactional tables, the GET_LOCK() function can be used.\n* When using LOCK TABLES on a TEMPORARY table, it will always be locked with a\nWRITE lock.\n* While a connection holds an explicit read lock on a table, it cannot modify\nit. If you try, the following error will be produced:\n\nERROR 1099 (HY000): Table \'tab_name\' was locked with a READ lock and can\'t be\nupdated\n\n* While a connection holds an explicit lock on a table, it cannot access a\nnon-locked table. If you try, the following error will be produced:\n\nERROR 1100 (HY000): Table \'tab_name\' was not locked with LOCK TABLES\n\n* While a connection holds an explicit lock on a table, it cannot issue the\nfollowing: INSERT DELAYED, CREATE TABLE, CREATE TABLE ... LIKE, and DDL\nstatements involving stored programs and views (except for triggers). If you\ntry, the following error will be produced:\n\nERROR 1192 (HY000): Can\'t execute the given command because you have active\nlocked tables or an active transaction\n\n* LOCK TABLES can not be used in stored routines - if you try, the following\nerror will be produced on creation:\n\nERROR 1314 (0A000): LOCK is not allowed in stored procedures\n\nURL: https://mariadb.com/kb/en/lock-tables/','','https://mariadb.com/kb/en/lock-tables/'),
(101,'Transaction Timeouts',8,'MariaDB has always had the wait_timeout and interactive_timeout settings,\nwhich close connections after a certain period of inactivity.\n\nHowever, these are by default set to a long wait period. In situations where\ntransactions may be started, but not committed or rolled back, more granular\ncontrol and a shorter timeout may be desirable so as to avoid locks being held\nfor too long.\n\nMariaDB 10.3 introduced three new variables to handle this situation.\n\n* idle_transaction_timeout (all transactions)\n* idle_write_transaction_timeout (write transactions - called\nidle_readwrite_transaction_timeout until MariaDB 10.3.2)\n* idle_readonly_transaction_timeout (read transactions)\n\nThese accept a time in seconds to time out, by closing the connection,\ntransactions that are idle for longer than this period. By default all are set\nto zero, or no timeout.\n\nidle_transaction_timeout affects all transactions,\nidle_write_transaction_timeout affects write transactions only and\nidle_readonly_transaction_timeout affects read transactions only. The latter\ntwo variables work independently. However, if either is set along with\nidle_transaction_timeout, the settings for idle_write_transaction_timeout or\nidle_readonly_transaction_timeout will take precedence.\n\nExamples\n--------\n\nSET SESSION idle_transaction_timeout=2;\nBEGIN;\nSELECT * FROM t;\nEmpty set (0.000 sec)\n## wait 3 seconds\nSELECT * FROM t;\nERROR 2006 (HY000): MySQL server has gone away\n\nSET SESSION idle_write_transaction_timeout=2;\nBEGIN;\nSELECT * FROM t;\nEmpty set (0.000 sec)\n## wait 3 seconds\nSELECT * FROM t;\nEmpty set (0.000 sec)\nINSERT INTO t VALUES(1);\n## wait 3 seconds\nSELECT * FROM t;\nERROR 2006 (HY000): MySQL server has gone away\n\nSET SESSION idle_transaction_timeout=2, SESSION\nidle_readonly_transaction_timeout=10;\nBEGIN;\nSELECT * FROM t;\nEmpty set (0.000 sec)\n ## wait 3 seconds\nSELECT * FROM t;\nEmpty set (0.000 sec)\n## wait 11 seconds\nSELECT * FROM t;\nERROR 2006 (HY000): MySQL server has gone away\n\nURL: https://mariadb.com/kb/en/transaction-timeouts/','','https://mariadb.com/kb/en/transaction-timeouts/'),
(152,'INET_ATON',14,'Syntax\n------\n\nINET_ATON(expr)\n\nDescription\n-----------\n\nGiven the dotted-quad representation of an IPv4 network address as a string,\nreturns an integer that represents the numeric value of the address. Addresses\nmay be 4- or 8-byte addresses.\n\nReturns NULL if the argument is not understood.\n\nExamples\n--------\n\nSELECT INET_ATON(\'192.168.1.1\');\n+--------------------------+\n| INET_ATON(\'192.168.1.1\') |\n+--------------------------+\n|               3232235777 |\n+--------------------------+\n\nThis is calculated as follows: 192 x 2563 + 168 x 256 2 + 1 x 256 + 1\n\nURL: https://mariadb.com/kb/en/inet_aton/','','https://mariadb.com/kb/en/inet_aton/'),
(103,'WAIT and NOWAIT',8,'Extended syntax so that it is possible to set innodb_lock_wait_timeout and\nlock_wait_timeout for the following statements:\n\nSyntax\n------\n\nALTER TABLE tbl_name [WAIT n|NOWAIT] ...\nCREATE ... INDEX ON tbl_name (index_col_name, ...) [WAIT n|NOWAIT] ...\nDROP INDEX ... [WAIT n|NOWAIT]\nDROP TABLE tbl_name [WAIT n|NOWAIT] ...\nLOCK TABLE ... [WAIT n|NOWAIT]\nOPTIMIZE TABLE tbl_name [WAIT n|NOWAIT]\nRENAME TABLE tbl_name [WAIT n|NOWAIT] ...\nSELECT ... FOR UPDATE [WAIT n|NOWAIT]\nSELECT ... LOCK IN SHARE MODE [WAIT n|NOWAIT]\nTRUNCATE TABLE tbl_name [WAIT n|NOWAIT]\n\nDescription\n-----------\n\nThe lock wait timeout can be explicitly set in the statement by using either\nWAIT n (to set the wait in seconds) or NOWAIT, in which case the statement\nwill immediately fail if the lock cannot be obtained. WAIT 0 is equivalent to\nNOWAIT.\n\nURL: https://mariadb.com/kb/en/wait-and-nowait/','','https://mariadb.com/kb/en/wait-and-nowait/'),
(107,'DROP USER',10,'Syntax\n------\n\nDROP USER [IF EXISTS] user_name [, user_name] ...\n\nDescription\n-----------\n\nThe DROP USER statement removes one or more MariaDB accounts. It removes\nprivilege rows for the account from all grant tables. To use this statement,\nyou must have the global CREATE USER privilege or the DELETE privilege for the\nmysql database. Each account is named using the same format as for the CREATE\nUSER statement; for example, \'jeffrey\'@\'localhost\'. If you specify only the\nuser name part of the account name, a host name part of \'%\' is used. For\nadditional information about specifying account names, see CREATE USER.\n\nNote that, if you specify an account that is currently connected, it will not\nbe deleted until the connection is closed. The connection will not be\nautomatically closed.\n\nIf any of the specified user accounts do not exist, ERROR 1396 (HY000)\nresults. If an error occurs, DROP USER will still drop the accounts that do\nnot result in an error. Only one error is produced for all users which have\nnot been dropped:\n\nERROR 1396 (HY000): Operation DROP USER failed for \'u1\'@\'%\',\'u2\'@\'%\'\n\nFailed CREATE or DROP operations, for both users and roles, produce the same\nerror code.\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the user does not exist.\n\nExamples\n--------\n\nDROP USER bob;\n\nDROP USER foo2@localhost,foo2@\'127.%\';\n\nIF EXISTS:\n\nDROP USER bob;\nERROR 1396 (HY000): Operation DROP USER failed for \'bob\'@\'%\'\n\nDROP USER IF EXISTS bob;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+---------------------------------------------+\n| Level | Code | Message                                     |\n+-------+------+---------------------------------------------+\n| Note  | 1974 | Can\'t drop user \'bob\'@\'%\'; it doesn\'t exist |\n+-------+------+---------------------------------------------+\n\nURL: https://mariadb.com/kb/en/drop-user/','','https://mariadb.com/kb/en/drop-user/'),
(109,'RENAME USER',10,'Syntax\n------\n\nRENAME USER old_user TO new_user\n  [, old_user TO new_user] ...\n\nDescription\n-----------\n\nThe RENAME USER statement renames existing MariaDB accounts. To use it, you\nmust have the global CREATE USER privilege or the UPDATE privilege for the\nmysql database. Each account is named using the same format as for the CREATE\nUSER statement; for example, \'jeffrey\'@\'localhost\'. If you specify only the\nuser name part of the account name, a host name part of \'%\' is used.\n\nIf any of the old user accounts do not exist or any of the new user accounts\nalready exist, ERROR 1396 (HY000) results. If an error occurs, RENAME USER\nwill still rename the accounts that do not result in an error.\n\nExamples\n--------\n\nCREATE USER \'donald\', \'mickey\';\nRENAME USER \'donald\' TO \'duck\'@\'localhost\', \'mickey\' TO \'mouse\'@\'localhost\';\n\nURL: https://mariadb.com/kb/en/rename-user/','','https://mariadb.com/kb/en/rename-user/'),
(110,'REVOKE',10,'Privileges\n----------\n\nSyntax\n------\n\nREVOKE \n  priv_type [(column_list)]\n   [, priv_type [(column_list)]] ...\n  ON [object_type] priv_level\n  FROM user [, user] ...\n\nREVOKE ALL PRIVILEGES, GRANT OPTION\n  FROM user [, user] ...\n\nDescription\n-----------\n\nThe REVOKE statement enables system administrators to revoke privileges (or\nroles - see section below) from MariaDB accounts. Each account is named using\nthe same format as for the GRANT statement; for example,\n\'jeffrey\'@\'localhost\'. If you specify only the user name part of the account\nname, a host name part of \'%\' is used. For details on the levels at which\nprivileges exist, the allowable priv_type and priv_level values, and the\nsyntax for specifying users and passwords, see GRANT.\n\nTo use the first REVOKE syntax, you must have the GRANT OPTION privilege, and\nyou must have the privileges that you are revoking.\n\nTo revoke all privileges, use the second syntax, which drops all global,\ndatabase, table, column, and routine privileges for the named user or users:\n\nREVOKE ALL PRIVILEGES, GRANT OPTION FROM user [, user] ...\n\nTo use this REVOKE syntax, you must have the global CREATE USER privilege or\nthe UPDATE privilege for the mysql database. See GRANT.\n\nExamples\n--------\n\nREVOKE SUPER ON *.* FROM \'alexander\'@\'localhost\';\n\nRoles\n-----\n\nSyntax\n------\n\nREVOKE role  [, role ...]\n  FROM grantee [, grantee2 ... ]\n\nREVOKE ADMIN OPTION FOR role FROM grantee [, grantee2]\n\nDescription\n-----------\n\nREVOKE is also used to remove a role from a user or another role that it\'s\npreviously been assigned to. If a role has previously been set as a default\nrole, REVOKE does not remove the record of the default role from the\nmysql.user table. If the role is subsequently granted again, it will again be\nthe user\'s default. Use SET DEFAULT ROLE NONE to explicitly remove this.\n\nBefore MariaDB 10.1.13, the REVOKE role statement was not permitted in\nprepared statements.\n\nExample\n-------\n\nREVOKE journalist FROM hulda\n\nURL: https://mariadb.com/kb/en/revoke/','','https://mariadb.com/kb/en/revoke/'),
(153,'INET_NTOA',14,'Syntax\n------\n\nINET_NTOA(expr)\n\nDescription\n-----------\n\nGiven a numeric IPv4 network address in network byte order (4 or 8 byte),\nreturns the dotted-quad representation of the address as a string.\n\nExamples\n--------\n\nSELECT INET_NTOA(3232235777);\n+-----------------------+\n| INET_NTOA(3232235777) |\n+-----------------------+\n| 192.168.1.1           |\n+-----------------------+\n\n192.168.1.1 corresponds to 3232235777 since 192 x 2563 + 168 x 256 2 + 1 x 256\n+ 1 = 3232235777\n\nURL: https://mariadb.com/kb/en/inet_ntoa/','','https://mariadb.com/kb/en/inet_ntoa/'),
(154,'IS_FREE_LOCK',14,'Syntax\n------\n\nIS_FREE_LOCK(str)\n\nDescription\n-----------\n\nChecks whether the lock named str is free to use (that is, not locked).\nReturns 1 if the lock is free (no one is using the lock), 0 if the lock is in\nuse, and NULL if an error occurs (such as an incorrect argument, like an empty\nstring or NULL). str is case insensitive.\n\nIf the metadata_lock_info plugin is installed, the Information Schema\nmetadata_lock_info table contains information about locks of this kind (as\nwell as metadata locks).\n\nStatements using the IS_FREE_LOCK function are not safe for statement-based\nreplication.\n\nURL: https://mariadb.com/kb/en/is_free_lock/','','https://mariadb.com/kb/en/is_free_lock/'),
(158,'IS_IPV6',14,'Syntax\n------\n\nIS_IPV6(expr)\n\nDescription\n-----------\n\nReturns 1 if the expression is a valid IPv6 address specified as a string,\notherwise returns 0. Does not consider IPv4 addresses to be valid IPv6\naddresses.\n\nExamples\n--------\n\nSELECT IS_IPV6(\'48f3::d432:1431:ba23:846f\');\n+--------------------------------------+\n| IS_IPV6(\'48f3::d432:1431:ba23:846f\') |\n+--------------------------------------+\n|                                    1 |\n+--------------------------------------+\n1 row in set (0.02 sec)\n\nSELECT IS_IPV6(\'10.0.1.1\');\n+---------------------+\n| IS_IPV6(\'10.0.1.1\') |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/is_ipv6/','','https://mariadb.com/kb/en/is_ipv6/'),
(111,'SET PASSWORD',10,'Syntax\n------\n\nSET PASSWORD [FOR user] =\n  {\n    PASSWORD(\'some password\')\n   | OLD_PASSWORD(\'some password\')\n   | \'encrypted password\'\n  }\n\nDescription\n-----------\n\nThe SET PASSWORD statement assigns a password to an existing MariaDB user\naccount.\n\nIf the password is specified using the PASSWORD() or OLD_PASSWORD() function,\nthe literal text of the password should be given. If the password is specified\nwithout using either function, the password should be the already-encrypted\npassword value as returned by PASSWORD().\n\nOLD_PASSWORD() should only be used if your MariaDB/MySQL clients are very old\n(< 4.0.0).\n\nWith no FOR clause, this statement sets the password for the current user. Any\nclient that has connected to the server using a non-anonymous account can\nchange the password for that account.\n\nWith a FOR clause, this statement sets the password for a specific account on\nthe current server host. Only clients that have the UPDATE privilege for the\nmysql database can do this. The user value should be given in\nuser_name@host_name format, where user_name and host_name are exactly as they\nare listed in the User and Host columns of the mysql.user table (or view in\nMariaDB-10.4 onwards) entry.\n\nThe argument to PASSWORD() and the password given to MariaDB clients can be of\narbitrary length.\n\nAuthentication Plugin Support\n-----------------------------\n\nMariaDB starting with 10.4\n--------------------------\nIn MariaDB 10.4 and later, SET PASSWORD (with or without PASSWORD()) works for\naccounts authenticated via any authentication plugin that supports passwords\nstored in the mysql.global_priv table.\n\nThe ed25519, mysql_native_password, and mysql_old_password authentication\nplugins store passwords in the mysql.global_priv table.\n\nIf you run SET PASSWORD on an account that authenticates with one of these\nauthentication plugins that stores passwords in the mysql.global_priv table,\nthen the PASSWORD() function is evaluated by the specific authentication\nplugin used by the account. The authentication plugin hashes the password with\na method that is compatible with that specific authentication plugin.\n\nThe unix_socket, named_pipe, gssapi, and pam authentication plugins do not\nstore passwords in the mysql.global_priv table. These authentication plugins\nrely on other methods to authenticate the user.\n\nIf you attempt to run SET PASSWORD on an account that authenticates with one\nof these authentication plugins that doesn\'t store a password in the\nmysql.global_priv table, then MariaDB Server will raise a warning like the\nfollowing:\n\nSET PASSWORD is ignored for users authenticating via unix_socket plugin\n\nSee Authentication from MariaDB 10.4 for an overview of authentication changes\nin MariaDB 10.4.\n\nMariaDB until 10.3\n------------------\nIn MariaDB 10.3 and before, SET PASSWORD (with or without PASSWORD()) only\nworks for accounts authenticated via mysql_native_password or\nmysql_old_password authentication plugins\n\nPasswordless User Accounts\n--------------------------\n\nUser accounts do not always require passwords to login.\n\nThe unix_socket , named_pipe and gssapi authentication plugins do not require\na password to authenticate the user.\n\nThe pam authentication plugin may or may not require a password to\nauthenticate the user, depending on the specific configuration.\n\nThe mysql_native_password and mysql_old_password authentication plugins\nrequire passwords for authentication, but the password can be blank. In that\ncase, no password is required.\n\nIf you provide a password while attempting to log into the server as an\naccount that doesn\'t require a password, then MariaDB server will simply\nignore the password.\n\nMariaDB starting with 10.4\n--------------------------\nIn MariaDB 10.4 and later, a user account can be defined to use multiple\nauthentication plugins in a specific order of preference. This specific\nscenario may be more noticeable in these versions, since an account could be\nassociated with some authentication plugins that require a password, and some\nthat do not.\n\nExample\n-------\n\nFor example, if you had an entry with User and Host column values of \'bob\' and\n\'%.loc.gov\', you would write the statement like this:\n\nSET PASSWORD FOR \'bob\'@\'%.loc.gov\' = PASSWORD(\'newpass\');\n\nIf you want to delete a password for a user, you would do:\n\nSET PASSWORD FOR \'bob\'@localhost = PASSWORD(\"\");\n\nURL: https://mariadb.com/kb/en/set-password/','','https://mariadb.com/kb/en/set-password/'),
(113,'DROP ROLE',10,'Syntax\n------\n\nDROP ROLE [IF EXISTS] role_name [,role_name ...]\n\nDescription\n-----------\n\nThe DROP ROLE statement removes one or more MariaDB roles. To use this\nstatement, you must have the global CREATE USER privilege or the DELETE\nprivilege for the mysql database.\n\nDROP ROLE does not disable roles for connections which selected them with SET\nROLE. If a role has previously been set as a default role, DROP ROLE does not\nremove the record of the default role from the mysql.user table. If the role\nis subsequently recreated and granted, it will again be the user\'s default.\nUse SET DEFAULT ROLE NONE to explicitly remove this.\n\nIf any of the specified user accounts do not exist, ERROR 1396 (HY000)\nresults. If an error occurs, DROP ROLE will still drop the roles that do not\nresult in an error. Only one error is produced for all roles which have not\nbeen dropped:\n\nERROR 1396 (HY000): Operation DROP ROLE failed for \'a\',\'b\',\'c\'\n\nFailed CREATE or DROP operations, for both users and roles, produce the same\nerror code.\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a warning instead of an\nerror if the role does not exist.\n\nExamples\n--------\n\nDROP ROLE journalist;\n\nThe same thing using the optional IF EXISTS clause:\n\nDROP ROLE journalist;\nERROR 1396 (HY000): Operation DROP ROLE failed for \'journalist\'\n\nDROP ROLE IF EXISTS journalist;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nNote (Code 1975): Can\'t drop role \'journalist\'; it doesn\'t exist\n\nURL: https://mariadb.com/kb/en/drop-role/','','https://mariadb.com/kb/en/drop-role/'),
(159,'IS_USED_LOCK',14,'Syntax\n------\n\nIS_USED_LOCK(str)\n\nDescription\n-----------\n\nChecks whether the lock named str is in use (that is, locked). If so, it\nreturns the connection identifier of the client that holds the lock.\nOtherwise, it returns NULL. str is case insensitive.\n\nIf the metadata_lock_info plugin is installed, the Information Schema\nmetadata_lock_info table contains information about locks of this kind (as\nwell as metadata locks).\n\nStatements using the IS_USED_LOCK function are not safe for statement-based\nreplication.\n\nURL: https://mariadb.com/kb/en/is_used_lock/','','https://mariadb.com/kb/en/is_used_lock/'),
(162,'NAME_CONST',14,'Syntax\n------\n\nNAME_CONST(name,value)\n\nDescription\n-----------\n\nReturns the given value. When used to produce a result set column,\nNAME_CONST() causes the column to have the given name. The arguments should be\nconstants.\n\nThis function is used internally when replicating stored procedures. It makes\nlittle sense to use it explicitly in SQL statements, and it was not supposed\nto be used like that.\n\nSELECT NAME_CONST(\'myname\', 14);\n+--------+\n| myname |\n+--------+\n|     14 |\n+--------+\n\nURL: https://mariadb.com/kb/en/name_const/','','https://mariadb.com/kb/en/name_const/'),
(165,'SLEEP',14,'Syntax\n------\n\nSLEEP(duration)\n\nDescription\n-----------\n\nSleeps (pauses) for the number of seconds given by the duration argument, then\nreturns 0. If SLEEP() is interrupted, it returns 1. The duration may have a\nfractional part given in microseconds.\n\nStatements using the SLEEP() function are not safe for replication.\n\nExample\n-------\n\nSELECT SLEEP(5.5);\n+------------+\n| SLEEP(5.5) |\n+------------+\n|          0 |\n+------------+\n1 row in set (5.50 sec)\n\nURL: https://mariadb.com/kb/en/sleep/','','https://mariadb.com/kb/en/sleep/'),
(112,'CREATE ROLE',10,'Syntax\n------\n\nCREATE [OR REPLACE] ROLE [IF NOT EXISTS] role \n [WITH ADMIN\n  {CURRENT_USER | CURRENT_ROLE | user | role}]\n\nDescription\n-----------\n\nThe CREATE ROLE statement creates one or more MariaDB roles. To use it, you\nmust have the global CREATE USER privilege or the INSERT privilege for the\nmysql database. For each account, CREATE ROLE creates a new row in the\nmysql.user table that has no privileges, and with the corresponding is_role\nfield set to Y. It also creates a record in the mysql.roles_mapping table.\n\nIf any of the specified roles already exist, ERROR 1396 (HY000) results. If an\nerror occurs, CREATE ROLE will still create the roles that do not result in an\nerror. The maximum length for a role is 128 characters. Role names can be\nquoted, as explained in the Identifier names page. Only one error is produced\nfor all roles which have not been created:\n\nERROR 1396 (HY000): Operation CREATE ROLE failed for \'a\',\'b\',\'c\'\n\nFailed CREATE or DROP operations, for both users and roles, produce the same\nerror code.\n\nPUBLIC and NONE are reserved, and cannot be used as role names. NONE is used\nto unset a role and PUBLIC has a special use in other systems, such as Oracle,\nso is reserved for compatibility purposes.\n\nFor valid identifiers to use as role names, see Identifier Names.\n\nWITH ADMIN\n----------\n\nThe optional WITH ADMIN clause determines whether the current user, the\ncurrent role or another user or role has use of the newly created role. If the\nclause is omitted, WITH ADMIN CURRENT_USER is treated as the default, which\nmeans that the current user will be able to GRANT this role to users.\n\nOR REPLACE\n----------\n\nIf the optional OR REPLACE clause is used, it acts as a shortcut for:\n\nDROP ROLE IF EXISTS name;\nCREATE ROLE name ...;\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a warning instead\nof an error if the specified role already exists. Cannot be used together with\nthe OR REPLACE clause.\n\nExamples\n--------\n\nCREATE ROLE journalist;\n\nCREATE ROLE developer WITH ADMIN lorinda@localhost;\n\nGranting the role to another user. Only user lorinda@localhost has permission\nto grant the developer role:\n\nSELECT USER();\n+-------------------+\n| USER()            |\n+-------------------+\n| henning@localhost |\n+-------------------+\n...\nGRANT developer TO ian@localhost;\nAccess denied for user \'henning\'@\'localhost\'\n\nSELECT USER();\n+-------------------+\n| USER()            |\n+-------------------+\n| lorinda@localhost |\n+-------------------+\n\nGRANT m_role TO ian@localhost;\n\nThe OR REPLACE and IF NOT EXISTS clauses. The journalist role already exists:\n\nCREATE ROLE journalist;\nERROR 1396 (HY000): Operation CREATE ROLE failed for \'journalist\'\n\nCREATE OR REPLACE ROLE journalist;\nQuery OK, 0 rows affected (0.00 sec)\n\nCREATE ROLE IF NOT EXISTS journalist;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+---------------------------------------------------+\n| Level | Code | Message                                           |\n+-------+------+---------------------------------------------------+\n| Note  | 1975 | Can\'t create role \'journalist\'; it already exists |\n+-------+------+---------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/create-role/','','https://mariadb.com/kb/en/create-role/'),
(114,'SET ROLE',10,'Syntax\n------\n\nSET ROLE { role | NONE }\n\nDescription\n-----------\n\nThe SET ROLE statement enables a role, along with all of its associated\npermissions, for the current session. To unset a role, use NONE .\n\nIf a role that doesn\'t exist, or to which the user has not been assigned, is\nspecified, an ERROR 1959 (OP000): Invalid role specification error occurs.\n\nAn automatic SET ROLE is implicitly performed when a user connects if that\nuser has been assigned a default role. See SET DEFAULT ROLE.\n\nExample\n-------\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| NULL         |\n+--------------+\n\nSET ROLE staff;\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| staff        |\n+--------------+\n\nSET ROLE NONE;\n\nSELECT CURRENT_ROLE();\n+----------------+\n| CURRENT_ROLE() |\n+----------------+\n| NULL           |\n+----------------+\n\nURL: https://mariadb.com/kb/en/set-role/','','https://mariadb.com/kb/en/set-role/'),
(115,'SET DEFAULT ROLE',10,'Syntax\n------\n\nSET DEFAULT ROLE { role | NONE } [ FOR user@host ]\n\nDescription\n-----------\n\nThe SET DEFAULT ROLE statement sets a default role for a specified (or\ncurrent) user. A default role is automatically enabled when a user connects\n(an implicit SET ROLE statement is executed immediately after a connection is\nestablished).\n\nTo be able to set a role as a default, the role must already have been granted\nto that user, and one needs the privileges to enable this role (if you cannot\ndo SET ROLE X, you won\'t be able to do SET DEFAULT ROLE X). To set a default\nrole for another user one needs to have write access to the mysql database.\n\nTo remove a user\'s default role, use SET DEFAULT ROLE NONE [ FOR user@host ].\nThe record of the default role is not removed if the role is dropped or\nrevoked, so if the role is subsequently re-created or granted, it will again\nbe the user\'s default role.\n\nThe default role is stored in the default_role column in the mysql.user\ntable/view, as well as in the Information Schema APPLICABLE_ROLES table, so\nthese can be viewed to see which role has been assigned to a user as the\ndefault.\n\nExamples\n--------\n\nSetting a default role for the current user:\n\nSET DEFAULT ROLE journalist;\n\nRemoving a default role from the current user:\n\nSET DEFAULT ROLE NONE;\n\nSetting a default role for another user. The role has to have been granted to\nthe user before it can be set as default:\n\nCREATE ROLE journalist;\nCREATE USER taniel;\n\nSET DEFAULT ROLE journalist FOR taniel;\nERROR 1959 (OP000): Invalid role specification `journalist`\n\nGRANT journalist TO taniel;\nSET DEFAULT ROLE journalist FOR taniel;\n\nViewing mysql.user:\n\nselect * from mysql.user where user=\'taniel\'\\G\n*************************** 1. row ***************************\n         Host: %\n         User: taniel\n...\n       is_role: N\n     default_role: journalist\n...\n\nRemoving a default role for another user\n\nSET DEFAULT ROLE NONE FOR taniel;\n\nURL: https://mariadb.com/kb/en/set-default-role/','','https://mariadb.com/kb/en/set-default-role/'),
(166,'SYS_GUID',14,'MariaDB starting with 10.6.1\n----------------------------\nThe SYS_GUID function was introduced in MariaDB 10.6.1 to enhance Oracle\ncompatibility. Similar functionality can be achieved with the UUID function.\n\nSyntax\n------\n\nSYS_GUID()\n\nDescription\n-----------\n\nReturns a 16-byte globally unique identifier (GUID), similar to the UUID\nfunction, but without the - character.\n\nExample\n-------\n\nSELECT SYS_GUID();\n+----------------------------------+\n| SYS_GUID()                       |\n+----------------------------------+\n| 2C574E45BA2811EBB265F859713E4BE4 |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/sys_guid/','','https://mariadb.com/kb/en/sys_guid/'),
(170,'!',15,'Syntax\n------\n\nNOT, !\n\nDescription\n-----------\n\nLogical NOT. Evaluates to 1 if the operand is 0, to 0 if the operand is\nnon-zero, and NOT NULL returns NULL.\n\nBy default, the ! operator has a higher precedence. If the HIGH_NOT_PRECEDENCE\nSQL_MODE flag is set, NOT and ! have the same precedence.\n\nExamples\n--------\n\nSELECT NOT 10;\n+--------+\n| NOT 10 |\n+--------+\n|      0 |\n+--------+\n\nSELECT NOT 0;\n+-------+\n| NOT 0 |\n+-------+\n|     1 |\n+-------+\n\nSELECT NOT NULL;\n+----------+\n| NOT NULL |\n+----------+\n|     NULL |\n+----------+\n\nSELECT ! (1+1);\n+---------+\n| ! (1+1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ! 1+1;\n+-------+\n| ! 1+1 |\n+-------+\n|     1 |\n+-------+\n\nURL: https://mariadb.com/kb/en/not/','','https://mariadb.com/kb/en/not/'),
(116,'Roles Overview',10,'Description\n-----------\n\nA role bundles a number of privileges together. It assists larger\norganizations where, typically, a number of users would have the same\nprivileges, and, previously, the only way to change the privileges for a group\nof users was by changing each user\'s privileges individually.\n\nAlternatively, multiple external users could have been assigned the same user,\nand there would have been no way to see which actual user was responsible for\nwhich action.\n\nWith roles, managing this is easy. For example, there could be a number of\nusers assigned to a journalist role, with identical privileges. Changing the\nprivileges for all the journalists is a matter of simply changing the role\'s\nprivileges, while the individual user is still linked with any changes that\ntake place.\n\nRoles are created with the CREATE ROLE statement, and dropped with the DROP\nROLE statement. Roles are then assigned to a user with an extension to the\nGRANT statement, while privileges are assigned to a role in the regular way\nwith GRANT. Similarly, the REVOKE statement can be used to both revoke a role\nfrom a user, or revoke a privilege from a role.\n\nOnce a user has connected, he can obtain all privileges associated with a role\nby setting a role with the SET ROLE statement. The CURRENT_ROLE function\nreturns the currently set role for the session, if any.\n\nOnly roles granted directly to a user can be set, roles granted to other roles\ncannot. Instead the privileges granted to a role, which is, in turn, granted\nto another role (grantee), will be immediately available to any user who sets\nthis second grantee role.\n\nThe SET DEFAULT ROLE statement allows one to set a default role for a user. A\ndefault role is automatically enabled when a user connects (an implicit SET\nROLE statement is executed immediately after a connection is established).\n\nRoles were implemented as a GSoC 2013 project by Vicentiu Ciorbaru.\n\nSystem Tables\n-------------\n\nInformation about roles and who they\'ve been granted to can be found in the\nInformation Schema APPLICABLE_ROLES table as well as the mysql.ROLES_MAPPING\ntable.\n\nThe Information Schema ENABLED_ROLES table shows the enabled roles for the\ncurrent session.\n\nExamples\n--------\n\nCreating a role and granting a privilege:\n\nCREATE ROLE journalist;\n\nGRANT SHOW DATABASES ON *.* TO journalist;\n\nGRANT journalist to hulda;\n\nNote, that hulda has no SHOW DATABASES privilege, even though she was granted\nthe journalist role. She needs to set the role first:\n\nSHOW DATABASES;\n+--------------------+\n| Database           |\n+--------------------+\n| information_schema |\n+--------------------+\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| NULL         |\n+--------------+\n\nSET ROLE journalist;\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| journalist   |\n+--------------+\n\nSHOW DATABASES;\n+--------------------+\n| Database           |\n+--------------------+\n| ...                |\n| information_schema |\n| mysql              |\n| performance_schema |\n| test               |\n| ...                |\n+--------------------+\n\nSET ROLE NONE;\n\nRoles can be granted to roles:\n\nCREATE ROLE writer;\n\nGRANT SELECT ON data.* TO writer;\n\nGRANT writer TO journalist;\n\nBut one does not need to set a role granted to a role. For example, hulda will\nautomatically get all writer privileges when she sets the journalist role:\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| NULL         |\n+--------------+\n\nSHOW TABLES FROM data;\nEmpty set (0.01 sec)\n\nSET ROLE journalist;\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| journalist   |\n+--------------+\n\nSHOW TABLES FROM data;\n+------------------------------+\n| Tables_in_data               |\n+------------------------------+\n| set1                         |\n| ...                          |\n+------------------------------+\n\nRoles and Views (and Stored Routines)\n-------------------------------------\n\nWhen a user sets a role, he, in a sense, has two identities with two\nassociated sets of privileges. But a view (or a stored routine) can have only\none definer. So, when a view (or a stored routine) is created with the SQL\nSECURITY DEFINER, one can specify whether the definer should be CURRENT_USER\n(and the view will have none of the privileges of the user\'s role) or\nCURRENT_ROLE (in this case, the view will use role\'s privileges, but none of\nthe user\'s privileges). As a result, sometimes one can create a view that is\nimpossible to use.\n\nCREATE ROLE r1;\n\nGRANT ALL ON db1.* TO r1;\n\nGRANT r1 TO foo@localhost;\n\nGRANT ALL ON db.* TO foo@localhost;\n\nSELECT CURRENT_USER\n+---------------+\n| current_user  |\n+---------------+\n| foo@localhost |\n+---------------+\n\nSET ROLE r1;\n\nCREATE TABLE db1.t1 (i int);\n\nCREATE VIEW db.v1 AS SELECT * FROM db1.t1;\n\nSHOW CREATE VIEW db.v1;\n+------+-----------------------------------------------------------------------\n------------------------------------------------------------------+------------\n---------+----------------------+\n| View | Create View                                                          \n                                 |\ncharacter_set_client | collation_connection |\n+------+-----------------------------------------------------------------------\n------------------------------------------------------------------+------------\n---------+----------------------+\n| v1   | CREATE ALGORITHM=UNDEFINED DEFINER=`foo`@`localhost` SQL SECURITY\nDEFINER VIEW `db`.`v1` AS SELECT `db1`.`t1`.`i` AS `i` from `db1`.`t1` | utf8 \n       | utf8_general_ci      |\n+------+-----------------------------------------------------------------------\n------------------------------------------------------------------+------------\n---------+----------------------+\n\nCREATE DEFINER=CURRENT_ROLE VIEW db.v2 AS SELECT * FROM db1.t1;\n\nSHOW CREATE VIEW db.b2;\n+------+-----------------------------------------------------------------------\n-----------------------------------------------------+----------------------+--\n-------------------+\n| View | Create View                                                          \n                           | character_set_client |\ncollation_connection |\n+------+-----------------------------------------------------------------------\n-----------------------------------------------------+----------------------+--\n-------------------+\n| v2   | CREATE ALGORITHM=UNDEFINED DEFINER=`r1` SQL SECURITY DEFINER VIEW\n`db`.`v2` AS select `db1`.`t1`.`a` AS `a` from `db1`.`t1` | utf8              \n | utf8_general_ci      |\n+------+-----------------------------------------------------------------------\n-----------------------------------------------------+----------------------+--\n-------------------+\n\nOther Resources\n---------------\n\n* Roles Review by Peter Gulutzan\n\nURL: https://mariadb.com/kb/en/roles_overview/','','https://mariadb.com/kb/en/roles_overview/'),
(171,'&&',15,'Syntax\n------\n\nAND, &&\n\nDescription\n-----------\n\nLogical AND. Evaluates to 1 if all operands are non-zero and not NULL, to 0 if\none or more operands are 0, otherwise NULL is returned.\n\nFor this operator, short-circuit evaluation can be used.\n\nExamples\n--------\n\nSELECT 1 && 1;\n+--------+\n| 1 && 1 |\n+--------+\n|      1 |\n+--------+\n\nSELECT 1 && 0;\n+--------+\n| 1 && 0 |\n+--------+\n|      0 |\n+--------+\n\nSELECT 1 && NULL;\n+-----------+\n| 1 && NULL |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT 0 && NULL;\n+-----------+\n| 0 && NULL |\n+-----------+\n|         0 |\n+-----------+\n\nSELECT NULL && 0;\n+-----------+\n| NULL && 0 |\n+-----------+\n|         0 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/and/','','https://mariadb.com/kb/en/and/'),
(117,'Account Locking',10,'MariaDB starting with 10.4.2\n----------------------------\nAccount locking was introduced in MariaDB 10.4.2.\n\nDescription\n-----------\n\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected).\n\nUser accounts can be locked at creation, with the CREATE USER statement, or\nmodified after creation with the ALTER USER statement. For example:\n\nCREATE USER \'lorin\'@\'localhost\' ACCOUNT LOCK;\n\nor\n\nALTER USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nThe server will return an ER_ACCOUNT_HAS_BEEN_LOCKED error when locked users\nattempt to connect:\n\nmysql -ulorin\n ERROR 4151 (HY000): Access denied, this account is locked\n\nThe ALTER USER statement is also used to unlock a user:\n\nALTER USER \'lorin\'@\'localhost\' ACCOUNT UNLOCK;\n\nThe SHOW CREATE USER statement will show whether the account is locked:\n\nSHOW CREATE USER \'marijn\'@\'localhost\';\n+-----------------------------------------------+\n| CREATE USER for marijn@localhost              |\n+-----------------------------------------------+\n| CREATE USER \'marijn\'@\'localhost\' ACCOUNT LOCK |\n+-----------------------------------------------+\n\nas well as querying the mysql.global_priv table:\n\nSELECT CONCAT(user, \'@\', host, \' => \', JSON_DETAILED(priv)) FROM\nmysql.global_priv \n WHERE user=\'marijn\';\n+------------------------------------------------------------------------------\n-------+\n| CONCAT(user, \'@\', host, \' => \', JSON_DETAILED(priv))                        \n    |\n+------------------------------------------------------------------------------\n-------+\n| marijn@localhost => {\n  \"access\": 0,\n  \"plugin\": \"mysql_native_password\",\n  \"authentication_string\": \"\",\n  \"account_locked\": true,\n  \"password_last_changed\": 1558017158\n} |\n+------------------------------------------------------------------------------\n-------+\n\nURL: https://mariadb.com/kb/en/account-locking/','','https://mariadb.com/kb/en/account-locking/'),
(119,'User Password Expiry',10,'MariaDB starting with 10.4.3\n----------------------------\nUser password expiry was introduced in MariaDB 10.4.3.\n\nPassword expiry permits administrators to expire user passwords, either\nmanually or automatically.\n\nSystem Variables\n----------------\n\nThere are two system variables which affect password expiry:\ndefault_password_lifetime, which determines the amount of time between\nrequiring the user to change their password. 0, the default, means automatic\npassword expiry is not active.\n\nThe second variable, disconnect_on_expired_password determines whether a\nclient is permitted to connect if their password has expired, or whether they\nare permitted to connect in sandbox mode, able to perform a limited subset of\nqueries related to resetting the password, in particular SET PASSWORD and SET.\n\nSetting a Password Expiry Limit for a User\n------------------------------------------\n\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal using the CREATE USER or ALTER USER statements, for example:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\n\nLimits can be disabled by use of the NEVER keyword, for example:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE NEVER;\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE NEVER;\n\nA manually set limit can be restored the system default by use of DEFAULT, for\nexample:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nSHOW CREATE USER\n----------------\n\nThe SHOW CREATE USER statement will display information about the password\nexpiry status of the user. Unlike MySQL, it will not display if the user is\nunlocked, or if the password expiry is set to default.\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\nCREATE USER \'konstantin\'@\'localhost\' PASSWORD EXPIRE NEVER;\nCREATE USER \'amse\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nSHOW CREATE USER \'monty\'@\'localhost\';\n+------------------------------------------------------------------+\n| CREATE USER for monty@localhost                                  |\n+------------------------------------------------------------------+\n| CREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY |\n+------------------------------------------------------------------+\n\nSHOW CREATE USER \'konstantin\'@\'localhost\';\n+------------------------------------------------------------+\n| CREATE USER for konstantin@localhost                       |\n+------------------------------------------------------------+\n| CREATE USER \'konstantin\'@\'localhost\' PASSWORD EXPIRE NEVER |\n+------------------------------------------------------------+\n\nSHOW CREATE USER \'amse\'@\'localhost\';\n+--------------------------------+\n| CREATE USER for amse@localhost |\n+--------------------------------+\n| CREATE USER \'amse\'@\'localhost\' |\n+--------------------------------+\n\nChecking When Passwords Expire\n------------------------------\n\nThe following query can be used to check when the current passwords expire for\nall users:\n\nWITH password_expiration_info AS (\n SELECT User, Host,\n IF(\n IFNULL(JSON_EXTRACT(Priv, \'$.password_lifetime\'), -1) = -1,\n @@global.default_password_lifetime,\n JSON_EXTRACT(Priv, \'$.password_lifetime\')\n ) AS password_lifetime,\n JSON_EXTRACT(Priv, \'$.password_last_changed\') AS password_last_changed\n FROM mysql.global_priv\n)\nSELECT pei.User, pei.Host,\n pei.password_lifetime,\n FROM_UNIXTIME(pei.password_last_changed) AS password_last_changed_datetime,\n FROM_UNIXTIME(\n pei.password_last_changed +\n (pei.password_lifetime * 60 * 60 * 24)\n ) AS password_expiration_datetime\n FROM password_expiration_info pei\n WHERE pei.password_lifetime != 0\n AND pei.password_last_changed IS NOT NULL\nUNION\nSELECT pei.User, pei.Host,\n pei.password_lifetime,\n FROM_UNIXTIME(pei.password_last_changed) AS password_last_changed_datetime,\n 0 AS password_expiration_datetime\n FROM password_expiration_info pei\n WHERE pei.password_lifetime = 0\n OR pei.password_last_changed IS NULL;\n\n--connect-expired-password Client Option\n----------------------------------------\n\nThe mariadb client --connect-expired-password option notifies the server that\nthe client is prepared to handle expired password sandbox mode (even if the\n--batch option was specified).\n\nURL: https://mariadb.com/kb/en/user-password-expiry/','','https://mariadb.com/kb/en/user-password-expiry/'),
(172,'XOR',15,'Syntax\n------\n\nXOR\n\nDescription\n-----------\n\nXOR stands for eXclusive OR. Returns NULL if either operand is NULL. For\nnon-NULL operands, evaluates to 1 if an odd number of operands is non-zero,\notherwise 0 is returned.\n\nExamples\n--------\n\nSELECT 1 XOR 1;\n+---------+\n| 1 XOR 1 |\n+---------+\n|       0 |\n+---------+\n\nSELECT 1 XOR 0;\n+---------+\n| 1 XOR 0 |\n+---------+\n|       1 |\n+---------+\n\nSELECT 1 XOR NULL;\n+------------+\n| 1 XOR NULL |\n+------------+\n|       NULL |\n+------------+\n\nIn the following example, the right 1 XOR 1 is evaluated first, and returns 0.\nThen, 1 XOR 0 is evaluated, and 1 is returned.\n\nSELECT 1 XOR 1 XOR 1;\n+---------------+\n| 1 XOR 1 XOR 1 |\n+---------------+\n|             1 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/xor/','','https://mariadb.com/kb/en/xor/'),
(187,'STDDEV_SAMP',16,'Syntax\n------\n\nSTDDEV_SAMP(expr)\n\nDescription\n-----------\n\nReturns the sample standard deviation of expr (the square root of VAR_SAMP()).\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nSTDDEV_SAMP() can be used as a window function.\n\nSTDDEV_SAMP() returns NULL if there were no matching rows.\n\nURL: https://mariadb.com/kb/en/stddev_samp/','','https://mariadb.com/kb/en/stddev_samp/'),
(124,'UNCOMPRESS',12,'Syntax\n------\n\nUNCOMPRESS(string_to_uncompress)\n\nDescription\n-----------\n\nUncompresses a string compressed by the COMPRESS() function. If the argument\nis not a compressed value, the result is NULL. This function requires MariaDB\nto have been compiled with a compression library such as zlib. Otherwise, the\nreturn value is always NULL. The have_compress server system variable\nindicates whether a compression library is present.\n\nExamples\n--------\n\nSELECT UNCOMPRESS(COMPRESS(\'a string\'));\n+----------------------------------+\n| UNCOMPRESS(COMPRESS(\'a string\')) |\n+----------------------------------+\n| a string                         |\n+----------------------------------+\n\nSELECT UNCOMPRESS(\'a string\');\n+------------------------+\n| UNCOMPRESS(\'a string\') |\n+------------------------+\n| NULL                   |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/uncompress/','','https://mariadb.com/kb/en/uncompress/'),
(125,'DECODE',12,'Syntax\n------\n\nDECODE(crypt_str,pass_str)\n\nIn Oracle mode from MariaDB 10.3.2:\n\nDECODE(expr, search_expr, result_expr [, search_expr2, result_expr2 ...]\n[default_expr])\n\nIn all modes from MariaDB 10.3.2:\n\nDECODE_ORACLE(expr, search_expr, result_expr [, search_expr2, result_expr2\n...] [default_expr])\n\nDescription\n-----------\n\nIn the default mode, DECODE decrypts the encrypted string crypt_str using\npass_str as the password. crypt_str should be a string returned from ENCODE().\nThe resulting string will be the original string only if pass_str is the same.\n\nIn Oracle mode from MariaDB 10.3.2, DECODE compares expr to the search\nexpressions, in order. If it finds a match, the corresponding result\nexpression is returned. If no matches are found, the default expression is\nreturned, or NULL if no default is provided.\n\nNULLs are treated as equivalent.\n\nDECODE_ORACLE is a synonym for the Oracle-mode version of the function, and is\navailable in all modes.\n\nExamples\n--------\n\nFrom MariaDB 10.3.2:\n\nSELECT DECODE_ORACLE(2+1,3*1,\'found1\',3*2,\'found2\',\'default\');\n+--------------------------------------------------------+\n| DECODE_ORACLE(2+1,3*1,\'found1\',3*2,\'found2\',\'default\') |\n+--------------------------------------------------------+\n| found1                                                 |\n+--------------------------------------------------------+\n\nSELECT DECODE_ORACLE(2+4,3*1,\'found1\',3*2,\'found2\',\'default\');\n+--------------------------------------------------------+\n| DECODE_ORACLE(2+4,3*1,\'found1\',3*2,\'found2\',\'default\') |\n+--------------------------------------------------------+\n| found2                                                 |\n+--------------------------------------------------------+\n\nSELECT DECODE_ORACLE(2+2,3*1,\'found1\',3*2,\'found2\',\'default\');\n+--------------------------------------------------------+\n| DECODE_ORACLE(2+2,3*1,\'found1\',3*2,\'found2\',\'default\') |\n+--------------------------------------------------------+\n| default                                                |\n+--------------------------------------------------------+\n\nNulls are treated as equivalent:\n\nSELECT DECODE_ORACLE(NULL,NULL,\'Nulls are equivalent\',\'Nulls are not\nequivalent\');\n+----------------------------------------------------------------------------+\n| DECODE_ORACLE(NULL,NULL,\'Nulls are equivalent\',\'Nulls are not equivalent\') |\n+----------------------------------------------------------------------------+\n| Nulls are equivalent                                                       |\n+----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/decode/','','https://mariadb.com/kb/en/decode/'),
(127,'AES_DECRYPT',12,'Syntax\n------\n\nAES_DECRYPT(crypt_str,key_str)\n\nFrom MariaDB 11.2.0\n\nAES_ENCRYPT(crypt_str, key_str, [, iv [, mode]])\n\nDescription\n-----------\n\nThis function allows decryption of data using the official AES (Advanced\nEncryption Standard) algorithm. For more information, see the description of\nAES_ENCRYPT().\n\nMariaDB starting with 11.2\n--------------------------\nFrom MariaDB 11.2, the function supports an initialization vector, and control\nof the block encryption mode. The default mode is specified by the\nblock_encryption_mode system variable, which can be changed when calling the\nfunction with a mode. mode is aes-{128,192,256}-{ecb,cbc,ctr} for example:\n\"AES-128-cbc\".\n\nFor modes that require it, the initialization_vector iv should be 16 bytes (it\ncan be longer, but the extra bytes are ignored). A shorter iv, where one is\nrequired, results in the function returning NULL. Calling RANDOM_BYTES(16)\nwill generate a random series of bytes that can be used for the iv.\n\nExamples\n--------\n\nFrom MariaDB 11.2.0:\n\nSELECT HEX(AES_ENCRYPT(\'foo\', \'bar\', \'0123456789abcdef\', \'aes-128-ctr\')) AS x; \n+--------+\n| x      |\n+--------+\n| C57C4B |\n+--------+\n\nSELECT AES_DECRYPT(x\'C57C4B\', \'bar\', \'0123456789abcdef\', \'aes-128-ctr\'); \n+------------------------------------------------------------------+\n| AES_DECRYPT(x\'C57C4B\', \'bar\', \'0123456789abcdef\', \'aes-128-ctr\') |\n+------------------------------------------------------------------+\n| foo                                                              |\n+------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/aes_decrypt/','','https://mariadb.com/kb/en/aes_decrypt/'),
(192,'BENCHMARK',17,'Syntax\n------\n\nBENCHMARK(count,expr)\n\nDescription\n-----------\n\nThe BENCHMARK() function executes the expression expr repeatedly count times.\nIt may be used to time how quickly MariaDB processes the expression. The\nresult value is always 0. The intended use is from within the mariadb client,\nwhich reports query execution times.\n\nExamples\n--------\n\nSELECT BENCHMARK(1000000,ENCODE(\'hello\',\'goodbye\'));\n+----------------------------------------------+\n| BENCHMARK(1000000,ENCODE(\'hello\',\'goodbye\')) |\n+----------------------------------------------+\n|                                            0 |\n+----------------------------------------------+\n1 row in set (0.21 sec)\n\nURL: https://mariadb.com/kb/en/benchmark/','','https://mariadb.com/kb/en/benchmark/'),
(193,'BINLOG_GTID_POS',17,'Syntax\n------\n\nBINLOG_GTID_POS(binlog_filename,binlog_offset)\n\nDescription\n-----------\n\nThe BINLOG_GTID_POS() function takes as input an old-style binary log position\nin the form of a file name and a file offset. It looks up the position in the\ncurrent binlog, and returns a string representation of the corresponding GTID\nposition. If the position is not found in the current binlog, NULL is returned.\n\nExamples\n--------\n\nSELECT BINLOG_GTID_POS(\"master-bin.000001\", 600);\n\nURL: https://mariadb.com/kb/en/binlog_gtid_pos/','','https://mariadb.com/kb/en/binlog_gtid_pos/'),
(196,'COLLATION',17,'Syntax\n------\n\nCOLLATION(str)\n\nDescription\n-----------\n\nReturns the collation of the string argument. If str is not a string, it is\nconsidered as a binary string (so the function returns \'binary\'). This applies\nto NULL, too. The return value is a string in the utf8 character set.\n\nSee Character Sets and Collations.\n\nExamples\n--------\n\nSELECT COLLATION(\'abc\');\n+-------------------+\n| COLLATION(\'abc\')  |\n+-------------------+\n| latin1_swedish_ci |\n+-------------------+\n\nSELECT COLLATION(_utf8\'abc\');\n+-----------------------+\n| COLLATION(_utf8\'abc\') |\n+-----------------------+\n| utf8_general_ci       |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/collation/','','https://mariadb.com/kb/en/collation/'),
(128,'AES_ENCRYPT',12,'Syntax\n------\n\nAES_ENCRYPT(str,key_str)\n\nFrom MariaDB 11.2.0\n\nAES_ENCRYPT(str, key, [, iv [, mode]])\n\nDescription\n-----------\n\nAES_ENCRYPT() and AES_DECRYPT() allow encryption and decryption of data using\nthe official AES (Advanced Encryption Standard) algorithm, previously known as\n\"Rijndael.\" Encoding with a 128-bit key length is used (from MariaDB 11.2.0,\nthis is the default, and can be changed). 128 bits is much faster and is\nsecure enough for most purposes.\n\nAES_ENCRYPT() encrypts a string str using the key key_str, and returns a\nbinary string.\n\nAES_DECRYPT() decrypts the encrypted string and returns the original string.\n\nThe input arguments may be any length. If either argument is NULL, the result\nof this function is also NULL.\n\nBecause AES is a block-level algorithm, padding is used to encode uneven\nlength strings and so the result string length may be calculated using this\nformula:\n\n16 x (trunc(string_length / 16) + 1)\n\nIf AES_DECRYPT() detects invalid data or incorrect padding, it returns NULL.\nHowever, it is possible for AES_DECRYPT() to return a non-NULL value (possibly\ngarbage) if the input data or the key is invalid.\n\nMariaDB starting with 11.2\n--------------------------\nFrom MariaDB 11.2, the function supports an initialization vector, and control\nof the block encryption mode. The default mode is specified by the\nblock_encryption_mode system variable, which can be changed when calling the\nfunction with a mode. mode is aes-{128,192,256}-{ecb,cbc,ctr} for example:\n\"AES-128-cbc\".\n\nAES_ENCRYPT(str, key) can no longer be used in persistent virtual columns (and\nthe like).\n\nExamples\n--------\n\nINSERT INTO t VALUES (AES_ENCRYPT(\'text\',SHA2(\'password\',512)));\n\nFrom MariaDB 11.2.0:\n\nSELECT HEX(AES_ENCRYPT(\'foo\', \'bar\', \'0123456789abcdef\', \'aes-256-cbc\')) AS x;\n+----------------------------------+\n| x                                |\n+----------------------------------+\n| 42A3EB91E6DFC40A900D278F99E0726E |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/aes_encrypt/','','https://mariadb.com/kb/en/aes_encrypt/'),
(129,'COMPRESS',12,'Syntax\n------\n\nCOMPRESS(string_to_compress)\n\nDescription\n-----------\n\nCompresses a string and returns the result as a binary string. This function\nrequires MariaDB to have been compiled with a compression library such as\nzlib. Otherwise, the return value is always NULL. The compressed string can be\nuncompressed with UNCOMPRESS().\n\nThe have_compress server system variable indicates whether a compression\nlibrary is present.\n\nExamples\n--------\n\nSELECT LENGTH(COMPRESS(REPEAT(\'a\',1000)));\n+------------------------------------+\n| LENGTH(COMPRESS(REPEAT(\'a\',1000))) |\n+------------------------------------+\n|                                 21 |\n+------------------------------------+\n\nSELECT LENGTH(COMPRESS(\'\'));\n+----------------------+\n| LENGTH(COMPRESS(\'\')) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSELECT LENGTH(COMPRESS(\'a\'));\n+-----------------------+\n| LENGTH(COMPRESS(\'a\')) |\n+-----------------------+\n|                    13 |\n+-----------------------+\n\nSELECT LENGTH(COMPRESS(REPEAT(\'a\',16)));\n+----------------------------------+\n| LENGTH(COMPRESS(REPEAT(\'a\',16))) |\n+----------------------------------+\n|                               15 |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/compress/','','https://mariadb.com/kb/en/compress/'),
(130,'DES_DECRYPT',12,'DES_DECRYPT has been deprecated from MariaDB 10.10.0, and will be removed in a\nfuture release.\n\nSyntax\n------\n\nDES_DECRYPT(crypt_str[,key_str])\n\nDescription\n-----------\n\nDecrypts a string encrypted with DES_ENCRYPT(). If an error occurs, this\nfunction returns NULL.\n\nThis function works only if MariaDB has been configured with TLS support.\n\nIf no key_str argument is given, DES_DECRYPT() examines the first byte of the\nencrypted string to determine the DES key number that was used to encrypt the\noriginal string, and then reads the key from the DES key file to decrypt the\nmessage. For this to work, the user must have the SUPER privilege. The key\nfile can be specified with the --des-key-file server option.\n\nIf you pass this function a key_str argument, that string is used as the key\nfor decrypting the message.\n\nIf the crypt_str argument does not appear to be an encrypted string, MariaDB\nreturns the given crypt_str.\n\nURL: https://mariadb.com/kb/en/des_decrypt/','','https://mariadb.com/kb/en/des_decrypt/'),
(131,'DES_ENCRYPT',12,'DES_ENCRYPT has been deprecated from MariaDB 10.10.0, and will be removed in a\nfuture release.\n\nSyntax\n------\n\nDES_ENCRYPT(str[,{key_num|key_str}])\n\nDescription\n-----------\n\nEncrypts the string with the given key using the Triple-DES algorithm.\n\nThis function works only if MariaDB has been configured with TLS support.\n\nThe encryption key to use is chosen based on the second argument to\nDES_ENCRYPT(), if one was given. With no argument, the first key from the DES\nkey file is used. With a key_num argument, the given key number (0-9) from the\nDES key file is used. With a key_str argument, the given key string is used to\nencrypt str.\n\nThe key file can be specified with the --des-key-file server option.\n\nThe return string is a binary string where the first character is CHAR(128 |\nkey_num). If an error occurs, DES_ENCRYPT() returns NULL.\n\nThe 128 is added to make it easier to recognize an encrypted key. If you use a\nstring key, key_num is 127.\n\nThe string length for the result is given by this formula:\n\nnew_len = orig_len + (8 - (orig_len % 8)) + 1\n\nEach line in the DES key file has the following format:\n\nkey_num des_key_str\n\nEach key_num value must be a number in the range from 0 to 9. Lines in the\nfile may be in any order. des_key_str is the string that is used to encrypt\nthe message. There should be at least one space between the number and the\nkey. The first key is the default key that is used if you do not specify any\nkey argument to DES_ENCRYPT().\n\nYou can tell MariaDB to read new key values from the key file with the FLUSH\nDES_KEY_FILE statement. This requires the RELOAD privilege.\n\nOne benefit of having a set of default keys is that it gives applications a\nway to check for the existence of encrypted column values, without giving the\nend user the right to decrypt those values.\n\nExamples\n--------\n\nSELECT customer_address FROM customer_table \n WHERE crypted_credit_card = DES_ENCRYPT(\'credit_card_number\');\n\nURL: https://mariadb.com/kb/en/des_encrypt/','','https://mariadb.com/kb/en/des_encrypt/'),
(197,'CONNECTION_ID',17,'Syntax\n------\n\nCONNECTION_ID()\n\nDescription\n-----------\n\nReturns the connection ID for the connection. Every connection (including\nevents) has an ID that is unique among the set of currently connected clients.\n\nUntil MariaDB 10.3.1, returns MYSQL_TYPE_LONGLONG, or bigint(10), in all\ncases. From MariaDB 10.3.1, returns MYSQL_TYPE_LONG, or int(10), when the\nresult would fit within 32-bits.\n\nExamples\n--------\n\nSELECT CONNECTION_ID();\n+-----------------+\n| CONNECTION_ID() |\n+-----------------+\n|               3 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/connection_id/','','https://mariadb.com/kb/en/connection_id/'),
(209,'SCHEMA',17,'Syntax\n------\n\nSCHEMA()\n\nDescription\n-----------\n\nThis function is a synonym for DATABASE().\n\nURL: https://mariadb.com/kb/en/schema/','','https://mariadb.com/kb/en/schema/'),
(210,'SESSION_USER',17,'Syntax\n------\n\nSESSION_USER()\n\nDescription\n-----------\n\nSESSION_USER() is a synonym for USER().\n\nURL: https://mariadb.com/kb/en/session_user/','','https://mariadb.com/kb/en/session_user/'),
(132,'ENCODE',12,'Syntax\n------\n\nENCODE(str,pass_str)\n\nDescription\n-----------\n\nENCODE is not considered cryptographically secure, and should not be used for\npassword encryption.\n\nEncrypt str using pass_str as the password. To decrypt the result, use\nDECODE().\n\nThe result is a binary string of the same length as str.\n\nThe strength of the encryption is based on how good the random generator is.\n\nIt is not recommended to rely on the encryption performed by the ENCODE\nfunction. Using a salt value (changed when a password is updated) will improve\nmatters somewhat, but for storing passwords, consider a more cryptographically\nsecure function, such as SHA2().\n\nExamples\n--------\n\nENCODE(\'not so secret text\', CONCAT(\'random_salt\',\'password\'))\n\nURL: https://mariadb.com/kb/en/encode/','','https://mariadb.com/kb/en/encode/'),
(133,'ENCRYPT',12,'Syntax\n------\n\nENCRYPT(str[,salt])\n\nDescription\n-----------\n\nEncrypts a string using the Unix crypt() system call, returning an encrypted\nbinary string. The salt argument should be a string with at least two\ncharacters or the returned result will be NULL. If no salt argument is given,\na random value of sufficient length is used.\n\nIt is not recommended to use ENCRYPT() with utf16, utf32 or ucs2 multi-byte\ncharacter sets because the crypt() system call expects a string terminated\nwith a zero byte.\n\nNote that the underlying crypt() system call may have some limitations, such\nas ignoring all but the first eight characters.\n\nIf the have_crypt system variable is set to NO (because the crypt() system\ncall is not available), the ENCRYPT function will always return NULL.\n\nExamples\n--------\n\nSELECT ENCRYPT(\'encrypt me\');\n+-----------------------+\n| ENCRYPT(\'encrypt me\') |\n+-----------------------+\n| 4I5BsEx0lqTDk         |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/encrypt/','','https://mariadb.com/kb/en/encrypt/'),
(135,'OLD_PASSWORD',12,'Syntax\n------\n\nOLD_PASSWORD(str)\n\nDescription\n-----------\n\nOLD_PASSWORD() was added to MySQL when the implementation of PASSWORD() was\nchanged to improve security. OLD_PASSWORD() returns the value of the old\n(pre-MySQL 4.1) implementation of PASSWORD() as a string, and is intended to\npermit you to reset passwords for any pre-4.1 clients that need to connect to\na more recent MySQL server version, or any version of MariaDB, without locking\nthem out.\n\nAs of MariaDB 5.5, the return value is a nonbinary string in the connection\ncharacter set and collation, determined by the values of the\ncharacter_set_connection and collation_connection system variables. Before\n5.5, the return value was a binary string.\n\nThe return value is 16 bytes in length, or NULL if the argument was NULL.\n\nURL: https://mariadb.com/kb/en/old_password/','','https://mariadb.com/kb/en/old_password/'),
(136,'PASSWORD',12,'Syntax\n------\n\nPASSWORD(str)\n\nDescription\n-----------\n\nThe PASSWORD() function is used for hashing passwords for use in\nauthentication by the MariaDB server. It is not intended for use in other\napplications.\n\nCalculates and returns a hashed password string from the plaintext password\nstr. Returns an empty string (>= MariaDB 10.0.4) if the argument was NULL.\n\nThe return value is a nonbinary string in the connection character set and\ncollation, determined by the values of the character_set_connection and\ncollation_connection system variables.\n\nThis is the function that is used for hashing MariaDB passwords for storage in\nthe Password column of the user table (see privileges), usually used with the\nSET PASSWORD statement. It is not intended for use in other applications.\n\nUntil MariaDB 10.3, the return value is 41-bytes in length, and the first\ncharacter is always \'*\'. From MariaDB 10.4, the function takes into account\nthe authentication plugin where applicable (A CREATE USER or SET PASSWORD\nstatement). For example, when used in conjunction with a user authenticated by\nthe ed25519 plugin, the statement will create a longer hash:\n\nCREATE USER edtest@localhost IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nCREATE USER edtest2@localhost IDENTIFIED BY \'secret\';\n\nSELECT CONCAT(user, \'@\', host, \' => \', JSON_DETAILED(priv)) FROM\nmysql.global_priv\n WHERE user LIKE \'edtest%\'\\G\n*************************** 1. row ***************************\nCONCAT(user, \'@\', host, \' => \', JSON_DETAILED(priv)): edtest@localhost => {\n...\n  \"plugin\": \"ed25519\",\n  \"authentication_string\": \"ZIgUREUg5PVgQ6LskhXmO+eZLS0nC8be6HPjYWR4YJY\",\n...\n}\n*************************** 2. row ***************************\nCONCAT(user, \'@\', host, \' => \', JSON_DETAILED(priv)): edtest2@localhost => {\n...\n  \"plugin\": \"mysql_native_password\",\n  \"authentication_string\": \"*14E65567ABDB5135D0CFD9A70B3032C179A49EE7\",\n...\n}\n\nThe behavior of this function is affected by the value of the old_passwords\nsystem variable. If this is set to 1 (0 is default), MariaDB reverts to using\nthe mysql_old_password authentication plugin by default for newly created\nusers and passwords.\n\nExamples\n--------\n\nSELECT PASSWORD(\'notagoodpwd\');\n+-------------------------------------------+\n| PASSWORD(\'notagoodpwd\')                   |\n+-------------------------------------------+\n| *3A70EE9FC6594F88CE9E959CD51C5A1C002DC937 |\n+-------------------------------------------+\n\nSET PASSWORD FOR \'bob\'@\'%.loc.gov\' = PASSWORD(\'newpass\');\n\nURL: https://mariadb.com/kb/en/password/','','https://mariadb.com/kb/en/password/'),
(211,'SYSTEM_USER',17,'Syntax\n------\n\nSYSTEM_USER()\n\nDescription\n-----------\n\nSYSTEM_USER() is a synonym for USER().\n\nURL: https://mariadb.com/kb/en/system_user/','','https://mariadb.com/kb/en/system_user/'),
(214,'Assignment Operator (:=)',18,'Syntax\n------\n\nvar_name := expr\n\nDescription\n-----------\n\nAssignment operator for assigning a value. The value on the right is assigned\nto the variable on left.\n\nUnlike the = operator, := can always be used to assign a value to a variable.\n\nThis operator works with both user-defined variables and local variables.\n\nWhen assigning the same value to several variables, LAST_VALUE() can be useful.\n\nExamples\n--------\n\nSELECT @x := 10;\n+----------+\n| @x := 10 |\n+----------+\n|       10 |\n+----------+\n\nSELECT @x, @y := @x;\n+------+----------+\n| @x   | @y := @x |\n+------+----------+\n|   10 |       10 |\n+------+----------+\n\nURL: https://mariadb.com/kb/en/assignment-operator/','','https://mariadb.com/kb/en/assignment-operator/'),
(225,'GREATEST',19,'Syntax\n------\n\nGREATEST(value1,value2,...)\n\nDescription\n-----------\n\nWith two or more arguments, returns the largest (maximum-valued) argument. The\narguments are compared using the same rules as for LEAST().\n\nExamples\n--------\n\nSELECT GREATEST(2,0);\n+---------------+\n| GREATEST(2,0) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT GREATEST(34.0,3.0,5.0,767.0);\n+------------------------------+\n| GREATEST(34.0,3.0,5.0,767.0) |\n+------------------------------+\n|                        767.0 |\n+------------------------------+\n\nSELECT GREATEST(\'B\',\'A\',\'C\');\n+-----------------------+\n| GREATEST(\'B\',\'A\',\'C\') |\n+-----------------------+\n| C                     |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/greatest/','','https://mariadb.com/kb/en/greatest/'),
(230,'IS NOT NULL',19,'Syntax\n------\n\nIS NOT NULL\n\nDescription\n-----------\n\nTests whether a value is not NULL. See also NULL Values in MariaDB.\n\nExamples\n--------\n\nSELECT 1 IS NOT NULL, 0 IS NOT NULL, NULL IS NOT NULL;\n+---------------+---------------+------------------+\n| 1 IS NOT NULL | 0 IS NOT NULL | NULL IS NOT NULL |\n+---------------+---------------+------------------+\n|             1 |             1 |                0 |\n+---------------+---------------+------------------+\n\nURL: https://mariadb.com/kb/en/is-not-null/','','https://mariadb.com/kb/en/is-not-null/'),
(137,'RANDOM_BYTES',12,'MariaDB starting with 10.10.0\n-----------------------------\nThe RANDOM_BYTES function generates a binary string of random bytes. It was\nadded in MariaDB 10.10.0.\n\nSyntax\n------\n\nRANDOM_BYTES(length)\n\nDescription\n-----------\n\nGiven a length from 1 to 1024, generates a binary string of length consisting\nof random bytes generated by the SSL library\'s random number generator.\n\nSee the RAND_bytes() function documentation of your SSL library for\ninformation on the random number generator. In the case of OpenSSL, a\ncryptographically secure pseudo random generator (CSPRNG) is used.\n\nStatements containing the RANDOM_BYTES function are unsafe for statement-based\nreplication.\n\nAn error occurs if length is outside the range 1 to 1024.\n\nURL: https://mariadb.com/kb/en/random_bytes/','','https://mariadb.com/kb/en/random_bytes/'),
(138,'SHA1',12,'Syntax\n------\n\nSHA1(str), SHA(str)\n\nDescription\n-----------\n\nCalculates an SHA-1 160-bit checksum for the string str, as described in RFC\n3174 (Secure Hash Algorithm).\n\nThe value is returned as a string of 40 hex digits, or NULL if the argument\nwas NULL. As of MariaDB 5.5, the return value is a nonbinary string in the\nconnection character set and collation, determined by the values of the\ncharacter_set_connection and collation_connection system variables. Before\n5.5, the return value was a binary string.\n\nExamples\n--------\n\nSELECT SHA1(\'some boring text\');\n+------------------------------------------+\n| SHA1(\'some boring text\')                 |\n+------------------------------------------+\n| af969fc2085b1bb6d31e517d5c456def5cdd7093 |\n+------------------------------------------+\n\nURL: https://mariadb.com/kb/en/sha1/','','https://mariadb.com/kb/en/sha1/'),
(139,'SHA2',12,'Syntax\n------\n\nSHA2(str,hash_len)\n\nDescription\n-----------\n\nGiven a string str, calculates an SHA-2 checksum, which is considered more\ncryptographically secure than its SHA-1 equivalent. The SHA-2 family includes\nSHA-224, SHA-256, SHA-384, and SHA-512, and the hash_len must correspond to\none of these, i.e. 224, 256, 384 or 512. 0 is equivalent to 256.\n\nThe return value is a nonbinary string in the connection character set and\ncollation, determined by the values of the character_set_connection and\ncollation_connection system variables.\n\nNULL is returned if the hash length is not valid, or the string str is NULL.\n\nSHA2 will only work if MariaDB was has been configured with TLS support.\n\nExamples\n--------\n\nSELECT SHA2(\'Maria\',224);\n+----------------------------------------------------------+\n| SHA2(\'Maria\',224)                                        |\n+----------------------------------------------------------+\n| 6cc67add32286412efcab9d0e1675a43a5c2ef3cec8879f81516ff83 |\n+----------------------------------------------------------+\n\nSELECT SHA2(\'Maria\',256);\n+------------------------------------------------------------------+\n| SHA2(\'Maria\',256)                                                |\n+------------------------------------------------------------------+\n| 9ff18ebe7449349f358e3af0b57cf7a032c1c6b2272cb2656ff85eb112232f16 |\n+------------------------------------------------------------------+\n\nSELECT SHA2(\'Maria\',0);\n+------------------------------------------------------------------+\n| SHA2(\'Maria\',0)                                                  |\n+------------------------------------------------------------------+\n| 9ff18ebe7449349f358e3af0b57cf7a032c1c6b2272cb2656ff85eb112232f16 |\n+------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/sha2/','','https://mariadb.com/kb/en/sha2/'),
(150,'INET6_ATON',14,'Syntax\n------\n\nINET6_ATON(expr)\n\nDescription\n-----------\n\nGiven an IPv6 or IPv4 network address as a string, returns a binary string\nthat represents the numeric value of the address.\n\nNo trailing zone ID\'s or traling network masks are permitted. For IPv4\naddresses, or IPv6 addresses with IPv4 address parts, no classful addresses or\ntrailing port numbers are permitted and octal numbers are not supported.\n\nThe returned binary string will be VARBINARY(16) or VARBINARY(4) for IPv6 and\nIPv4 addresses respectively.\n\nReturns NULL if the argument is not understood.\n\nMariaDB starting with 10.5.0\n----------------------------\nFrom MariaDB 10.5.0, INET6_ATON can take INET6 as an argument.\n\nExamples\n--------\n\nSELECT HEX(INET6_ATON(\'10.0.1.1\'));\n+-----------------------------+\n| HEX(INET6_ATON(\'10.0.1.1\')) |\n+-----------------------------+\n| 0A000101                    |\n+-----------------------------+\n\nSELECT HEX(INET6_ATON(\'48f3::d432:1431:ba23:846f\'));\n+----------------------------------------------+\n| HEX(INET6_ATON(\'48f3::d432:1431:ba23:846f\')) |\n+----------------------------------------------+\n| 48F3000000000000D4321431BA23846F             |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/inet6_aton/','','https://mariadb.com/kb/en/inet6_aton/'),
(232,'ISNULL',19,'Syntax\n------\n\nISNULL(expr)\n\nDescription\n-----------\n\nIf expr is NULL, ISNULL() returns 1, otherwise it returns 0.\n\nSee also NULL Values in MariaDB.\n\nExamples\n--------\n\nSELECT ISNULL(1+1);\n+-------------+\n| ISNULL(1+1) |\n+-------------+\n|           0 |\n+-------------+\n\nSELECT ISNULL(1/0);\n+-------------+\n| ISNULL(1/0) |\n+-------------+\n|           1 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/isnull/','','https://mariadb.com/kb/en/isnull/'),
(236,'&',20,'Syntax\n------\n\n&\n\nDescription\n-----------\n\nBitwise AND. Converts the values to binary and compares bits. Only if both the\ncorresponding bits are 1 is the resulting bit also 1.\n\nSee also bitwise OR.\n\nExamples\n--------\n\nSELECT 2&1;\n+-----+\n| 2&1 |\n+-----+\n|   0 |\n+-----+\n\nSELECT 3&1;\n+-----+\n| 3&1 |\n+-----+\n|   1 |\n+-----+\n\nSELECT 29 & 15;\n+---------+\n| 29 & 15 |\n+---------+\n|      13 |\n+---------+\n\nURL: https://mariadb.com/kb/en/bitwise_and/','','https://mariadb.com/kb/en/bitwise_and/'),
(237,'<<',20,'Syntax\n------\n\nvalue1 << value2\n\nDescription\n-----------\n\nConverts a longlong (BIGINT) number (value1) to binary and shifts value2 units\nto the left.\n\nExamples\n--------\n\nSELECT 1 << 2;\n+--------+\n| 1 << 2 |\n+--------+\n|      4 |\n+--------+\n\nURL: https://mariadb.com/kb/en/shift-left/','','https://mariadb.com/kb/en/shift-left/'),
(238,'>>',20,'Syntax\n------\n\nvalue1 >> value2\n\nDescription\n-----------\n\nConverts a longlong (BIGINT) number (value1) to binary and shifts value2 units\nto the right.\n\nExamples\n--------\n\nSELECT 4 >> 2;\n+--------+\n| 4 >> 2 |\n+--------+\n|      1 |\n+--------+\n\nURL: https://mariadb.com/kb/en/shift-right/','','https://mariadb.com/kb/en/shift-right/'),
(239,'BIT_COUNT',20,'Syntax\n------\n\nBIT_COUNT(N)\n\nDescription\n-----------\n\nReturns the number of bits that are set in the argument N.\n\nExamples\n--------\n\nSELECT BIT_COUNT(29), BIT_COUNT(b\'101010\');\n+---------------+----------------------+\n| BIT_COUNT(29) | BIT_COUNT(b\'101010\') |\n+---------------+----------------------+\n|             4 |                    3 |\n+---------------+----------------------+\n\nURL: https://mariadb.com/kb/en/bit_count/','','https://mariadb.com/kb/en/bit_count/'),
(240,'^',20,'Syntax\n------\n\n^\n\nDescription\n-----------\n\nBitwise XOR. Converts the values to binary and compares bits. If one (and only\none) of the corresponding bits is 1 is the resulting bit also 1.\n\nExamples\n--------\n\nSELECT 1 ^ 1;\n+-------+\n| 1 ^ 1 |\n+-------+\n|     0 |\n+-------+\n\nSELECT 1 ^ 0;\n+-------+\n| 1 ^ 0 |\n+-------+\n|     1 |\n+-------+\n\nSELECT 11 ^ 3;\n+--------+\n| 11 ^ 3 |\n+--------+\n|      8 |\n+--------+\n\nURL: https://mariadb.com/kb/en/bitwise-xor/','','https://mariadb.com/kb/en/bitwise-xor/'),
(149,'GET_LOCK',14,'Syntax\n------\n\nGET_LOCK(str,timeout)\n\nDescription\n-----------\n\nTries to obtain a lock with a name given by the string str, using a timeout of\ntimeout seconds. Returns 1 if the lock was obtained successfully, 0 if the\nattempt timed out (for example, because another client has previously locked\nthe name), or NULL if an error occurred (such as running out of memory or the\nthread was killed with mariadb-admin kill).\n\nA lock is released with RELEASE_LOCK(), when the connection terminates (either\nnormally or abnormally). A connection can hold multiple locks at the same\ntime, so a lock that is no longer needed needs to be explicitly released.\n\nThe IS_FREE_LOCK function returns whether a specified lock a free or not, and\nthe IS_USED_LOCK whether the function is in use or not.\n\nLocks obtained with GET_LOCK() do not interact with transactions. That is,\ncommitting a transaction does not release any such locks obtained during the\ntransaction.\n\nIt is also possible to recursively set the same lock. If a lock with the same\nname is set n times, it needs to be released n times as well.\n\nstr is case insensitive for GET_LOCK() and related functions. If str is an\nempty string or NULL, GET_LOCK() returns NULL and does nothing. timeout\nsupports microseconds.\n\nIf the metadata_lock_info plugin is installed, locks acquired with this\nfunction are visible in the Information Schema METADATA_LOCK_INFO table.\n\nThis function can be used to implement application locks or to simulate record\nlocks. Names are locked on a server-wide basis. If a name has been locked by\none client, GET_LOCK() blocks any request by another client for a lock with\nthe same name. This allows clients that agree on a given lock name to use the\nname to perform cooperative advisory locking. But be aware that it also allows\na client that is not among the set of cooperating clients to lock a name,\neither inadvertently or deliberately, and thus prevent any of the cooperating\nclients from locking that name. One way to reduce the likelihood of this is to\nuse lock names that are database-specific or application-specific. For\nexample, use lock names of the form db_name.str or app_name.str.\n\nStatements using the GET_LOCK function are not safe for statement-based\nreplication.\n\nThe patch to permit multiple locks was contributed by Konstantin \"Kostja\"\nOsipov (MDEV-3917).\n\nExamples\n--------\n\nSELECT GET_LOCK(\'lock1\',10);\n+----------------------+\n| GET_LOCK(\'lock1\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT IS_FREE_LOCK(\'lock1\'), IS_USED_LOCK(\'lock1\');\n+-----------------------+-----------------------+\n| IS_FREE_LOCK(\'lock1\') | IS_USED_LOCK(\'lock1\') |\n+-----------------------+-----------------------+\n|                     0 |                    46 |\n+-----------------------+-----------------------+\n\nSELECT IS_FREE_LOCK(\'lock2\'), IS_USED_LOCK(\'lock2\');\n+-----------------------+-----------------------+\n| IS_FREE_LOCK(\'lock2\') | IS_USED_LOCK(\'lock2\') |\n+-----------------------+-----------------------+\n|                     1 |                  NULL |\n+-----------------------+-----------------------+\n\nMultiple locks can be held:\n\nSELECT GET_LOCK(\'lock2\',10);\n+----------------------+\n| GET_LOCK(\'lock2\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT IS_FREE_LOCK(\'lock1\'), IS_FREE_LOCK(\'lock2\');\n+-----------------------+-----------------------+\n| IS_FREE_LOCK(\'lock1\') | IS_FREE_LOCK(\'lock2\') |\n+-----------------------+-----------------------+\n|                     0 |                     0 |\n+-----------------------+-----------------------+\n\nSELECT RELEASE_LOCK(\'lock1\'), RELEASE_LOCK(\'lock2\');\n+-----------------------+-----------------------+\n| RELEASE_LOCK(\'lock1\') | RELEASE_LOCK(\'lock2\') |\n+-----------------------+-----------------------+\n|                     1 |                     1 |\n+-----------------------+-----------------------+\n\nIt is possible to hold the same lock recursively. This example is viewed using\nthe metadata_lock_info plugin:\n\nSELECT GET_LOCK(\'lock3\',10);\n+----------------------+\n| GET_LOCK(\'lock3\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT GET_LOCK(\'lock3\',10);\n+----------------------+\n| GET_LOCK(\'lock3\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n| THREAD_ID | LOCK_MODE           | LOCK_DURATION | LOCK_TYPE | TABLE_SCHEMA |\nTABLE_NAME |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n|        46 | MDL_SHARED_NO_WRITE | NULL          | User lock | lock3        |\n     |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n\nSELECT RELEASE_LOCK(\'lock3\');\n+-----------------------+\n| RELEASE_LOCK(\'lock3\') |\n+-----------------------+\n|                     1 |\n+-----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n| THREAD_ID | LOCK_MODE           | LOCK_DURATION | LOCK_TYPE | TABLE_SCHEMA |\nTABLE_NAME |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n|        46 | MDL_SHARED_NO_WRITE | NULL          | User lock | lock3        |\n     |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n\nSELECT RELEASE_LOCK(\'lock3\');\n+-----------------------+\n| RELEASE_LOCK(\'lock3\') |\n+-----------------------+\n|                     1 |\n+-----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\nEmpty set (0.000 sec)\n\nTimeout example: Connection 1:\n\nSELECT GET_LOCK(\'lock4\',10);\n+----------------------+\n| GET_LOCK(\'lock4\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nConnection 2:\n\nSELECT GET_LOCK(\'lock4\',10);\n\nAfter 10 seconds...\n\n+----------------------+\n| GET_LOCK(\'lock4\',10) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nDeadlocks are automatically detected and resolved. Connection 1:\n\nSELECT GET_LOCK(\'lock5\',10); \n+----------------------+\n| GET_LOCK(\'lock5\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nConnection 2:\n\nSELECT GET_LOCK(\'lock6\',10);\n+----------------------+\n| GET_LOCK(\'lock6\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nConnection 1:\n\nSELECT GET_LOCK(\'lock6\',10); \n+----------------------+\n| GET_LOCK(\'lock6\',10) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nConnection 2:\n\nSELECT GET_LOCK(\'lock5\',10);\nERROR 1213 (40001): Deadlock found when trying to get lock; try restarting\ntransaction\n\nURL: https://mariadb.com/kb/en/get_lock/','','https://mariadb.com/kb/en/get_lock/'),
(241,'|',20,'Syntax\n------\n\n|\n\nDescription\n-----------\n\nBitwise OR. Converts the values to binary and compares bits. If either of the\ncorresponding bits has a value of 1, the resulting bit is also 1.\n\nSee also bitwise AND.\n\nExamples\n--------\n\nSELECT 2|1;\n+-----+\n| 2|1 |\n+-----+\n|   3 |\n+-----+\n\nSELECT 29 | 15;\n+---------+\n| 29 | 15 |\n+---------+\n|      31 |\n+---------+\n\nURL: https://mariadb.com/kb/en/bitwise-or/','','https://mariadb.com/kb/en/bitwise-or/'),
(151,'INET6_NTOA',14,'Syntax\n------\n\nINET6_NTOA(expr)\n\nDescription\n-----------\n\nGiven an IPv6 or IPv4 network address as a numeric binary string, returns the\naddress as a nonbinary string in the connection character set.\n\nThe return string is lowercase, and is platform independent, since it does not\nuse functions specific to the operating system. It has a maximum length of 39\ncharacters.\n\nReturns NULL if the argument is not understood.\n\nExamples\n--------\n\nSELECT INET6_NTOA(UNHEX(\'0A000101\'));\n+-------------------------------+\n| INET6_NTOA(UNHEX(\'0A000101\')) |\n+-------------------------------+\n| 10.0.1.1                      |\n+-------------------------------+\n\nSELECT INET6_NTOA(UNHEX(\'48F3000000000000D4321431BA23846F\'));\n+-------------------------------------------------------+\n| INET6_NTOA(UNHEX(\'48F3000000000000D4321431BA23846F\')) |\n+-------------------------------------------------------+\n| 48f3::d432:1431:ba23:846f                             |\n+-------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/inet6_ntoa/','','https://mariadb.com/kb/en/inet6_ntoa/'),
(155,'IS_IPV4',14,'Syntax\n------\n\nIS_IPV4(expr)\n\nDescription\n-----------\n\nIf the expression is a valid IPv4 address, returns 1, otherwise returns 0.\n\nIS_IPV4() is stricter than INET_ATON(), but as strict as INET6_ATON(), in\ndetermining the validity of an IPv4 address. This implies that if IS_IPV4\nreturns 1, the same expression will always return a non-NULL result when\npassed to INET_ATON(), but that the reverse may not apply.\n\nExamples\n--------\n\nSELECT IS_IPV4(\'1110.0.1.1\');\n+-----------------------+\n| IS_IPV4(\'1110.0.1.1\') |\n+-----------------------+\n|                     0 |\n+-----------------------+\n\nSELECT IS_IPV4(\'48f3::d432:1431:ba23:846f\');\n+--------------------------------------+\n| IS_IPV4(\'48f3::d432:1431:ba23:846f\') |\n+--------------------------------------+\n|                                    0 |\n+--------------------------------------+\n\nURL: https://mariadb.com/kb/en/is_ipv4/','','https://mariadb.com/kb/en/is_ipv4/'),
(156,'IS_IPV4_COMPAT',14,'Syntax\n------\n\nIS_IPV4_COMPAT(expr)\n\nDescription\n-----------\n\nReturns 1 if a given numeric binary string IPv6 address, such as returned by\nINET6_ATON(), is IPv4-compatible, otherwise returns 0.\n\nMariaDB starting with 10.5.0\n----------------------------\nFrom MariaDB 10.5.0, when the argument is not INET6, automatic implicit CAST\nto INET6 is applied. As a consequence, IS_IPV4_COMPAT now understands\narguments in both text representation and binary(16) representation. Before\nMariaDB 10.5.0, the function understood only binary(16) representation.\n\nExamples\n--------\n\nSELECT IS_IPV4_COMPAT(INET6_ATON(\'::10.0.1.1\'));\n+------------------------------------------+\n| IS_IPV4_COMPAT(INET6_ATON(\'::10.0.1.1\')) |\n+------------------------------------------+\n|                                        1 |\n+------------------------------------------+\n\nSELECT IS_IPV4_COMPAT(INET6_ATON(\'::48f3::d432:1431:ba23:846f\'));\n+-----------------------------------------------------------+\n| IS_IPV4_COMPAT(INET6_ATON(\'::48f3::d432:1431:ba23:846f\')) |\n+-----------------------------------------------------------+\n|                                                         0 |\n+-----------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/is_ipv4_compat/','','https://mariadb.com/kb/en/is_ipv4_compat/'),
(157,'IS_IPV4_MAPPED',14,'Syntax\n------\n\nIS_IPV4_MAPPED(expr)\n\nDescription\n-----------\n\nReturns 1 if a given a numeric binary string IPv6 address, such as returned by\nINET6_ATON(), is a valid IPv4-mapped address, otherwise returns 0.\n\nMariaDB starting with 10.5.0\n----------------------------\nFrom MariaDB 10.5.0, when the argument is not INET6, automatic implicit CAST\nto INET6 is applied. As a consequence, IS_IPV4_MAPPED now understands\narguments in both text representation and binary(16) representation. Before\nMariaDB 10.5.0, the function understood only binary(16) representation.\n\nExamples\n--------\n\nSELECT IS_IPV4_MAPPED(INET6_ATON(\'::10.0.1.1\'));\n+------------------------------------------+\n| IS_IPV4_MAPPED(INET6_ATON(\'::10.0.1.1\')) |\n+------------------------------------------+\n|                                        0 |\n+------------------------------------------+\n\nSELECT IS_IPV4_MAPPED(INET6_ATON(\'::ffff:10.0.1.1\'));\n+-----------------------------------------------+\n| IS_IPV4_MAPPED(INET6_ATON(\'::ffff:10.0.1.1\')) |\n+-----------------------------------------------+\n|                                             1 |\n+-----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/is_ipv4_mapped/','','https://mariadb.com/kb/en/is_ipv4_mapped/'),
(161,'MASTER_POS_WAIT',14,'Syntax\n------\n\nMASTER_POS_WAIT(log_name,log_pos[,timeout,[\"connection_name\"]])\n\nDescription\n-----------\n\nThis function is useful in replication for controlling primary/replica\nsynchronization. It blocks until the replica has read and applied all updates\nup to the specified position (log_name,log_pos) in the primary log. The return\nvalue is the number of log events the replica had to wait for to advance to\nthe specified position. The function returns NULL if the replica SQL thread is\nnot started, the replica\'s primary information is not initialized, the\narguments are incorrect, or an error occurs. It returns -1 if the timeout has\nbeen exceeded. If the replica SQL thread stops while MASTER_POS_WAIT() is\nwaiting, the function returns NULL. If the replica is past the specified\nposition, the function returns immediately.\n\nIf a timeout value is specified, MASTER_POS_WAIT() stops waiting when timeout\nseconds have elapsed. timeout must be greater than 0; a zero or negative\ntimeout means no timeout.\n\nThe connection_name is used when you are using multi-source-replication. If\nyou don\'t specify it, it\'s set to the value of the default_master_connection\nsystem variable.\n\nStatements using the MASTER_POS_WAIT() function are not safe for replication.\n\nURL: https://mariadb.com/kb/en/master_pos_wait/','','https://mariadb.com/kb/en/master_pos_wait/'),
(242,'~',20,'Syntax\n------\n\n~\n\nDescription\n-----------\n\nBitwise NOT. Converts the value to 4 bytes binary and inverts all bits.\n\nExamples\n--------\n\nSELECT 3 & ~1;\n+--------+\n| 3 & ~1 |\n+--------+\n|      2 |\n+--------+\n\nSELECT 5 & ~1;\n+--------+\n| 5 & ~1 |\n+--------+\n|      4 |\n+--------+\n\nURL: https://mariadb.com/kb/en/bitwise-not/','','https://mariadb.com/kb/en/bitwise-not/'),
(244,'TRUE FALSE',20,'Description\n-----------\n\nThe constants TRUE and FALSE evaluate to 1 and 0, respectively. The constant\nnames can be written in any lettercase.\n\nExamples\n--------\n\nSELECT TRUE, true, FALSE, false;\n+------+------+-------+-------+\n| TRUE | TRUE | FALSE | FALSE |\n+------+------+-------+-------+\n|    1 |    1 |     0 |     0 |\n+------+------+-------+-------+\n\nURL: https://mariadb.com/kb/en/true-false/','','https://mariadb.com/kb/en/true-false/'),
(247,'CHECK VIEW',21,'Syntax\n------\n\nCHECK VIEW view_name\n\nDescription\n-----------\n\nThe CHECK VIEW statement was introduced in MariaDB 10.0.18 to assist with\nfixing MDEV-6916, an issue introduced in MariaDB 5.2 where the view algorithms\nwere swapped. It checks whether the view algorithm is correct. It is run as\npart of mariadb-upgrade, and should not normally be required in regular use.\n\nURL: https://mariadb.com/kb/en/check-view/','','https://mariadb.com/kb/en/check-view/'),
(160,'MASTER_GTID_WAIT',14,'Syntax\n------\n\nMASTER_GTID_WAIT(gtid-list[, timeout)\n\nDescription\n-----------\n\nThis function takes a string containing a comma-separated list of global\ntransaction id\'s (similar to the value of, for example, gtid_binlog_pos). It\nwaits until the value of gtid_slave_pos has the same or higher seq_no within\nall replication domains specified in the gtid-list; in other words, it waits\nuntil the slave has reached the specified GTID position.\n\nAn optional second argument gives a timeout in seconds. If the timeout expires\nbefore the specified GTID position is reached, then the function returns -1.\nPassing NULL or a negative number for the timeout means no timeout, and the\nfunction will wait indefinitely.\n\nIf the wait completes without a timeout, 0 is returned. Passing NULL for the\ngtid-list makes the function return NULL immediately, without waiting.\n\nThe gtid-list may be the empty string, in which case MASTER_GTID_WAIT()\nreturns immediately. If the gtid-list contains fewer domains than\ngtid_slave_pos, then only those domains are waited upon. If gtid-list contains\na domain that is not present in @@gtid_slave_pos, then MASTER_GTID_WAIT() will\nwait until an event containing such domain_id arrives on the slave (or until\ntimed out or killed).\n\nMASTER_GTID_WAIT() can be useful to ensure that a slave has caught up to a\nmaster. Simply take the value of gtid_binlog_pos on the master, and use it in\na MASTER_GTID_WAIT() call on the slave; when the call completes, the slave\nwill have caught up with that master position.\n\nMASTER_GTID_WAIT() can also be used in client applications together with the\nlast_gtid session variable. This is useful in a read-scaleout replication\nsetup, where the application writes to a single master but divides the reads\nout to a number of slaves to distribute the load. In such a setup, there is a\nrisk that an application could first do an update on the master, and then a\nbit later do a read on a slave, and if the slave is not fast enough, the data\nread from the slave might not include the update just made, possibly confusing\nthe application and/or the end-user. One way to avoid this is to request the\nvalue of last_gtid on the master just after the update. Then before doing the\nread on the slave, do a MASTER_GTID_WAIT() on the value obtained from the\nmaster; this will ensure that the read is not performed until the slave has\nreplicated sufficiently far for the update to have become visible.\n\nNote that MASTER_GTID_WAIT() can be used even if the slave is configured not\nto use GTID for connections (CHANGE MASTER TO master_use_gtid=no). This is\nbecause from MariaDB 10, GTIDs are always logged on the master server, and\nalways recorded on the slave servers.\n\nDifferences to MASTER_POS_WAIT()\n--------------------------------\n\n* MASTER_GTID_WAIT() is global; it waits for any master connection to reach\n the specified GTID position. MASTER_POS_WAIT() works only against a\n specific connection. This also means that while MASTER_POS_WAIT() aborts if\n its master connection is terminated with STOP SLAVE or due to an error,\n MASTER_GTID_WAIT() continues to wait while slaves are stopped.\n\n* MASTER_GTID_WAIT() can take its timeout as a floating-point value, so a\n timeout in fractional seconds is supported, eg. MASTER_GTID_WAIT(\"0-1-100\",\n 0.5). (The minimum wait is one microsecond, 0.000001 seconds).\n\n* MASTER_GTID_WAIT() allows one to specify a timeout of zero in order to do a\n non-blocking check to see if the slaves have progressed to a specific GTID\nposition\n (MASTER_POS_WAIT() takes a zero timeout as meaning an infinite wait). To do\n an infinite MASTER_GTID_WAIT(), specify a negative timeout, or omit the\n timeout argument.\n\n* MASTER_GTID_WAIT() does not return the number of events executed since the\n wait started, nor does it return NULL if a slave thread is stopped. It\n always returns either 0 for successful wait completed, or -1 for timeout\n reached (or NULL if the specified gtid-pos is NULL).\n\nSince MASTER_GTID_WAIT() looks only at the seq_no part of the GTIDs, not the\nserver_id, care is needed if a slave becomes diverged from another server so\nthat two different GTIDs with the same seq_no (in the same domain) arrive at\nthe same server. This situation is in any case best avoided; setting\ngtid_strict_mode is recommended, as this will prevent any such out-of-order\nsequence numbers from ever being replicated on a slave.\n\nURL: https://mariadb.com/kb/en/master_gtid_wait/','','https://mariadb.com/kb/en/master_gtid_wait/'),
(163,'RELEASE_ALL_LOCKS',14,'MariaDB until 10.5.2\n--------------------\nRELEASE_ALL_LOCKS was added in MariaDB 10.5.2.\n\nSyntax\n------\n\nRELEASE_ALL_LOCKS()\n\nDescription\n-----------\n\nReleases all named locks held by the current session. Returns the number of\nlocks released, or 0 if none were held.\n\nStatements using the RELEASE_ALL_LOCKS function are not safe for\nstatement-based replication.\n\nExamples\n--------\n\nSELECT RELEASE_ALL_LOCKS();\n+---------------------+\n| RELEASE_ALL_LOCKS() | \n+---------------------+\n|                   0 |\n+---------------------+\n\nSELECT GET_LOCK(\'lock1\',10);\n+----------------------+\n| GET_LOCK(\'lock1\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT RELEASE_ALL_LOCKS();\n+---------------------+\n| RELEASE_ALL_LOCKS() | \n+---------------------+\n|                   1 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/release_all_locks/','','https://mariadb.com/kb/en/release_all_locks/'),
(272,'BLOB and TEXT Data Types',23,'Description\n-----------\n\nA BLOB is a binary large object that can hold a variable amount of data. The\nfour BLOB types are\n\n* TINYBLOB,\n* BLOB, \n* MEDIUMBLOB, and\n* LONGBLOB.\n\nThese differ only in the maximum length of the values they can hold.\n\nThe TEXT types are\n\n* TINYTEXT,\n* TEXT,\n* MEDIUMTEXT, and\n* LONGTEXT.\n* JSON (alias for LONGTEXT)\n\nThese correspond to the four BLOB types and have the same maximum lengths and\nstorage requirements.\n\nBLOB and TEXT columns can have a DEFAULT value.\n\nMariaDB starting with 10.4.3\n----------------------------\nFrom MariaDB 10.4, it is possible to set a unique index on columns that use\nthe BLOB or TEXT data types.\n\nURL: https://mariadb.com/kb/en/blob-and-text-data-types/','','https://mariadb.com/kb/en/blob-and-text-data-types/'),
(274,'CHAR BYTE',23,'Description\n-----------\n\nThe CHAR BYTE data type is an alias for the BINARY data type. This is a\ncompatibility feature.\n\nURL: https://mariadb.com/kb/en/char-byte/','','https://mariadb.com/kb/en/char-byte/'),
(277,'INET6',23,'MariaDB starting with 10.5.0\n----------------------------\nThe INET6 data type was added in MariaDB 10.5.0\n\nSyntax\n------\n\nINET6\n\nDescription\n-----------\n\nThe INET6 data type is intended for storage of IPv6 addresses, as well as IPv4\naddresses assuming conventional mapping of IPv4 addresses into IPv6 addresses.\n\nBoth short and long IPv6 notation are permitted, according to RFC-5952.\n\n* Values are stored as a 16-byte fixed length binary string, with most\nsignificant byte first.\n* Storage engines see INET6 as BINARY(16).\n* Clients see INET6 as CHAR(39) and get text representation on retrieval.\n\nThe IPv4-compatible notation is considered as deprecated. It is supported for\ncompatibility with the INET6_ATON function, which also understands this\nformat. It\'s recommended to use the mapped format to store IPv4 addresses in\nINET6.\n\nWhen an IPv4 mapped (or compatible) value is stored in INET6, it still\noccupies 16 bytes:\n\nRetrieval\n---------\n\nOn retrieval, in the client-server text protocol, INET6 values are converted\nto the short text representation, according to RFC-5952, that is with all\nleading zeroes in each group removed and with consequent zero groups\ncompressed.\n\nBesides creating one\'s own stored function, there is no a way to retrieve an\nINET6 value using long text representation.\n\nCasting\n-------\n\n* CAST from a character string to INET6 understands addresses in short or long\ntext notation (including IPv4 mapped and compatible addresses). NULL is\nreturned if the format is not understood.\n* CAST from a binary string to INET6 requires a 16-byte string as an argument.\nNULL is returned if the argument length is not equal to 16.\n* CAST from other data types to INET6 first converts data to a character\nstring, then CAST from character string to INET6 is applied.\n* CAST from INET6 to CHAR returns short text address notation.\n* CAST from INET6 to BINARY returns its 16-byte binary string representation.\n* CAST from INET6 to data types other than CHAR (e.g. SIGNED, UNSIGNED, TIME,\netc) returns an error.\n\nComparisons\n-----------\n\nAn INET6 expression can be compared to:\n\n* another INET6 expression\n* a character string expression with a text (short or long) address\nrepresentation:\n* a 16-byte binary string expression:\n\nAttempting to compare INET6 to an expression of any other data type returns an\nerror.\n\nMixing INET6 Values for Result\n------------------------------\n\nAn INET6 expression can be mixed for result (i.e. UNION, CASE..THEN, COALESCE\netc) with:\n\n* another INET6 expression. The resulting data type is INET6.\n* a character string in text (short or long) address representation. The\nresult data type is INET6. The character string counterpart is automatically\nconverted to INET6. If the string format is not understood, it\'s converted\nwith a warning to either NULL or to \'::\', depending on the NULL-ability of the\nresult.\n* a 16-byte binary string. The resulting data type is INET6. The binary string\ncounterpart is automatically converted to INET6. If the length of the binary\nstring is not equal to 16, it\'s converted with a warning to NULL or to \'::\'\ndepending on the NULL-ability of the result.\n\nAttempts to mix INET6 for result with other data types will return an error.\n\nMixing INET6 with other data types for LEAST and GREATEST, when mixing for\ncomparison and mixing for result are involved at the same time, uses the same\nrules with mixing for result, described in the previous paragraphs.\n\nFunctions and Operators\n-----------------------\n\n* HEX() with an INET6 argument returns a hexadecimal representation of the\nunderlying 16-byte binary string\n* Arithmetic operators (+,-,*,/,MOD,DIV) are not supported for INET6. This may\nchange in the future.\n* The INET6_ATON function now understands INET6 values as an argument\n* The prototypes of the IS_IPV4_COMPAT and IS_IPV4_MAPPED functions have\nchanged from a BINARY(16) to a INET6,\n* When the argument for these two functions is not INET6, automatic implicit\nCAST to INET6 is applied. As a consequence, both functions now understand\narguments in both text representation and binary(16) representation. Before\nMariaDB 10.5.0, these functions understood only binary(16) representation.\n\nPrepared Statement Parameters\n-----------------------------\n\nINET6 understands both text and binary(16) address representation in prepared\nstatement parameters (PREPARE..EXECUTE and EXECUTE IMMEDIATE statements).\n\nMigration between  BINARY(16) and INET6\n---------------------------------------\n\nBefore MariaDB 10.5.0, you may have used BINARY(16) as a storage for IPv6\ninternet addresses, in combination with INET6_ATON and INET6_NTOA to\nrespectively insert and retrieve data.\n\nFrom 10.5, you can ALTER BINARY(16) columns storing IPv6 addresses to INET6.\nAfter such an alter, there is no a need to use INET6_ATON() and INET6_NTOA().\nAddresses can be inserted and retrieved directly.\n\nIt is also possible to convert INET6 columns to BINARY(16) and continue using\nthe data in combination with INET6_NTOA() and INET6_ATON().\n\nExamples\n--------\n\nCREATE TABLE t1 (a INET6);\n\nInserting using short text address notation:\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\n\nLong text address notation:\n\nINSERT INTO t1 VALUES (\'2001:0db8:0000:0000:0000:ff00:0042:8329\');\n\n16-byte binary string notation:\n\nINSERT INTO t1 VALUES (0x20010DB8000000000000FF0000428329);\nINSERT INTO t1 VALUES (UNHEX(\'20010DB8000000000000FF0000428329\'));\n\nIPv4 addresses, using IPv4-mapped and IPv4-compatible notations:\n\nINSERT INTO t1 VALUES (\'::ffff:192.0.2.128\'); -- mapped\nINSERT INTO t1 VALUES (\'::192.0.2.128\'); -- compatible\n\nSELECT * FROM t1;\n+------------------------+\n| a                      |\n+------------------------+\n| 2001:db8::ff00:42:8329 |\n| 2001:db8::ff00:42:8329 |\n| 2001:db8::ff00:42:8329 |\n| 2001:db8::ff00:42:8329 |\n| ::ffff:192.0.2.128     |\n| ::192.0.2.128          |\n+------------------------+\n\nIPv4 mapped (or compatible) values still occupy 16 bytes:\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'::ffff:192.0.2.128\');\n\nSELECT * FROM t1;\n+--------------------+\n| a                  |\n+--------------------+\n| ::ffff:192.0.2.128 |\n+--------------------+\n\nSELECT HEX(a) FROM t1;\n+----------------------------------+\n| HEX(a)                           |\n+----------------------------------+\n| 00000000000000000000FFFFC0000280 |\n+----------------------------------+\n\nCasting from INET6 to anything other than CHAR returns an error:\n\nSELECT CAST(a AS DECIMAL) FROM t1;\n\nERROR 4079 (HY000): Illegal parameter data type inet6 for operation\n\'decimal_typecast\'\n\nComparison Examples\n-------------------\n\nComparison with another INET6 expression:\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n  CREATE OR REPLACE TABLE t2 (a INET6);\n\nINSERT INTO t1 VALUES\n(\'2001:db8::ff00:42:8328\'),(\'2001:db8::ff00:42:8329\');\n  INSERT INTO t2 VALUES\n(\'2001:db8::ff00:42:832a\'),(\'2001:db8::ff00:42:8329\');\n\nSELECT t1.* FROM t1,t2 WHERE t1.a=t2.a;\n  +------------------------+\n  | a                      |\n  +------------------------+\n  | 2001:db8::ff00:42:8329 |\n  +------------------------+\n\nWith a character string expression with a text (short or long) address\nrepresentation:\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\n\nSELECT * FROM t1 WHERE a=\'2001:db8::ff00:42:8329\';\n  +------------------------+\n  | a                      |\n  +------------------------+\n  | 2001:db8::ff00:42:8329 |\n  +------------------------+\n\nWith a 16-byte binary string expression:\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\n\nSELECT * FROM t1 WHERE a=X\'20010DB8000000000000FF0000428329\';\n  +------------------------+\n  | a                      |\n  +------------------------+\n  | 2001:db8::ff00:42:8329 |\n  +------------------------+\n\nWith an expression of another data type:\n\nSELECT * FROM t1 WHERE a=1;\nERROR 4078 (HY000): Illegal parameter data types inet6 and int for operation\n\'=\'\n\nMixing for Result Examples\n--------------------------\n\nMixed with another INET6 expression, returning an INET6 data type:\n\nCREATE OR REPLACE TABLE t1 (a INET6, b INET6);\n\nINSERT INTO t1 VALUES (NULL,\'2001:db8::ff00:42:8329\');\n\nSELECT a FROM t1 UNION SELECT b FROM t1;\n  +------------------------+\n  | a                      |\n  +------------------------+\n  | NULL                   |\n  | 2001:db8::ff00:42:8329 |\n  +------------------------+\n\nSELECT COALESCE(a, b) FROM t1;\n  +------------------------+\n  | COALESCE(a, b)         |\n  +------------------------+\n  | 2001:db8::ff00:42:8329 |\n  +------------------------+\n\nMixed with a character string in text (short or long) address representation:\n\nCREATE OR REPLACE TABLE t1 (a INET6, b VARCHAR(64));\n\nINSERT INTO t1 VALUES (NULL,\'2001:db8::ff00:42:8328\');\n\nINSERT INTO t1 VALUES (NULL,\'2001:db8::ff00:42:832a garbage\');\n\nSELECT COALESCE(a,b) FROM t1;\n  +------------------------+\n  | COALESCE(a,b)          |\n  +------------------------+\n  | 2001:db8::ff00:42:8328 |\n  | NULL                   |\n  +------------------------+\n  2 rows in set, 1 warning (0.001 sec)\n\nSHOW WARNINGS;\n\n+---------+------+---------------------------------------------------------+\n  | Level   | Code | Message\n|\n\n+---------+------+---------------------------------------------------------+\n  | Warning | 1292 | Incorrect inet6 value: \'2001:db8::ff00:42:832a garbage\'\n|\n\n+---------+------+---------------------------------------------------------+\n\nMixed with a 16-byte binary string:\n\nCREATE OR REPLACE TABLE t1 (a INET6, b VARBINARY(16));\n\nINSERT INTO t1 VALUES (NULL,CONCAT(0xFFFF,REPEAT(0x0000,6),0xFFFF));\n\nINSERT INTO t1 VALUES (NULL,0x00/*garbage*/);\n\nSELECT COALESCE(a,b) FROM t1;\n  +---------------+\n  | COALESCE(a,b) |\n  +---------------+\n  | ffff::ffff    |\n  | NULL          |\n  +---------------+\n  2 rows in set, 1 warning (0.001 sec)\n\nSHOW WARNINGS;\n  +---------+------+-------------------------------+\n  | Level   | Code | Message                       |\n  +---------+------+-------------------------------+\n  | Warning | 1292 | Incorrect inet6 value: \'\\x00\' |\n  +---------+------+-------------------------------+\n\nMixing with other data types:\n\nSELECT CAST(\'ffff::ffff\' AS INET6) UNION SELECT 1;\nERROR 4078 (HY000): Illegal parameter data types inet6 and int for operation\n\'UNION\'\n\nFunctions and Operators Examples\n--------------------------------\n\nHEX with an INET6 argument returning a hexadecimal representation:\n\nSELECT HEX(CAST(\'2001:db8::ff00:42:8329\' AS INET6));\n  +----------------------------------------------+\n  | HEX(CAST(\'2001:db8::ff00:42:8329\' AS INET6)) |\n  +----------------------------------------------+\n  | 20010DB8000000000000FF0000428329             |\n  +----------------------------------------------+\n\nINET6_ATON now understands INET6 values as an argument:\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\n\nSELECT a, HEX(INET6_ATON(a)) FROM t1;\n  +------------------------+----------------------------------+\n  | a                      | HEX(INET6_ATON(a))               |\n  +------------------------+----------------------------------+\n  | 2001:db8::ff00:42:8329 | 20010DB8000000000000FF0000428329 |\n  +------------------------+----------------------------------+\n\nIS_IPV4_COMPAT and IS_IPV4_MAPPED prototype now a BINARY(16)):\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\n  INSERT INTO t1 VALUES (\'::ffff:192.168.0.1\');\n  INSERT INTO t1 VALUES (\'::192.168.0.1\');\n\nSELECT a, IS_IPV4_MAPPED(a), IS_IPV4_COMPAT(a) FROM t1;\n  +------------------------+-------------------+-------------------+\n  | a                      | IS_IPV4_MAPPED(a) | IS_IPV4_COMPAT(a) |\n  +------------------------+-------------------+-------------------+\n  | 2001:db8::ff00:42:8329 |                 0 |                 0 |\n  | ::ffff:192.168.0.1     |                 1 |                 0 |\n  | ::192.168.0.1          |                 0 |                 1 |\n  +------------------------+-------------------+-------------------+\n\nAutomatic implicit CAST to INET6:\n\nCREATE OR REPLACE TABLE t1 (\n   a INET6,\n   b VARCHAR(39) DEFAULT a\n  );\n\nINSERT INTO t1 (a) VALUES (\'ffff::ffff\'),(\'::ffff:192.168.0.1\');\n\nSELECT a, IS_IPV4_MAPPED(a), b, IS_IPV4_MAPPED(b) FROM t1;\n\n+--------------------+-------------------+--------------------+----------------\n--+\n  | a                  | IS_IPV4_MAPPED(a) | b                  |\nIS_IPV4_MAPPED(b) |\n\n+--------------------+-------------------+--------------------+----------------\n--+\n  | ffff::ffff         |                 0 | ffff::ffff         |\n  0 |\n  | ::ffff:192.168.0.1 |                 1 | ::ffff:192.168.0.1 |\n  1 |\n\n+--------------------+-------------------+--------------------+----------------\n--+\n\nCREATE OR REPLACE TABLE t1 (\n   a INET6,\n   b BINARY(16) DEFAULT UNHEX(HEX(a))\n  );\n\nINSERT INTO t1 (a) VALUES (\'ffff::ffff\'),(\'::ffff:192.168.0.1\');\n\nSELECT a, IS_IPV4_MAPPED(a), HEX(b), IS_IPV4_MAPPED(b) FROM t1;\n\n+--------------------+-------------------+----------------------------------+--\n----------------+\n  | a                  | IS_IPV4_MAPPED(a) | HEX(b)\n | IS_IPV4_MAPPED(b) |\n\n+--------------------+-------------------+----------------------------------+--\n----------------+\n  | ffff::ffff         |                 0 |\nFFFF000000000000000000000000FFFF |                 0 |\n  | ::ffff:192.168.0.1 |                 1 |\n00000000000000000000FFFFC0A80001 |                 1 |\n\n+--------------------+-------------------+----------------------------------+--\n----------------+\n\nPrepared Statement Parameters Examples\n--------------------------------------\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nEXECUTE IMMEDIATE \'INSERT INTO t1 VALUES (?)\' USING \'ffff::fffe\';\nEXECUTE IMMEDIATE \'INSERT INTO t1 VALUES (?)\' USING\nX\'FFFF000000000000000000000000FFFF\';\n\nSELECT * FROM t1;\n+------------+\n| a          |\n+------------+\n| ffff::fffe |\n| ffff::ffff |\n+------------+\n\nEXECUTE IMMEDIATE \'SELECT * FROM t1 WHERE a=?\' USING \'ffff::fffe\';\n+------------+\n| a          |\n+------------+\n| ffff::fffe |\n+------------+\n\nEXECUTE IMMEDIATE \'SELECT * FROM t1 WHERE a=?\' USING\nX\'FFFF000000000000000000000000FFFF\';\n+------------+\n| a          |\n+------------+\n| ffff::ffff |\n+------------+\n\nMigration between BINARY(16) and INET6 Examples\n-----------------------------------------------\n\nBefore MariaDB 10.5:\n\nCREATE OR REPLACE TABLE t1 (a BINARY(16));\n\nINSERT INTO t1 VALUES (INET6_ATON(\'ffff::ffff\'));\n\nSELECT INET6_NTOA(a) FROM t1;\n+---------------+\n| INET6_NTOA(a) |\n+---------------+\n| ffff::ffff    |\n+---------------+\n\nMigrating to INET6, from MariaDB 10.5:\n\nALTER TABLE t1 MODIFY a INET6;\n\nINSERT INTO t1 VALUES (\'ffff::fffe\');\n\nSELECT * FROM t1;\n+------------+\n| a          |\n+------------+\n| ffff::ffff |\n| ffff::fffe |\n+------------+\n\nMigration from INET6 to BINARY(16):\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\nINSERT INTO t1 VALUES (\'::ffff:192.168.0.1\');\nINSERT INTO t1 VALUES (\'::192.168.0.1\');\n\nALTER TABLE t1 MODIFY a BINARY(16);\n\nSELECT INET6_NTOA(a) FROM t1;\n+------------------------+\n| INET6_NTOA(a)          |\n+------------------------+\n| 2001:db8::ff00:42:8329 |\n| ::ffff:192.168.0.1     |\n| ::192.168.0.1          |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/inet6/','','https://mariadb.com/kb/en/inet6/'),
(279,'MEDIUMBLOB',23,'Syntax\n------\n\nMEDIUMBLOB\n\nDescription\n-----------\n\nA BLOB column with a maximum length of 16,777,215 (224 - 1) bytes. Each\nMEDIUMBLOB value is stored using a three-byte length prefix that indicates the\nnumber of bytes in the value.\n\nURL: https://mariadb.com/kb/en/mediumblob/','','https://mariadb.com/kb/en/mediumblob/'),
(280,'MEDIUMTEXT',23,'Syntax\n------\n\nMEDIUMTEXT [CHARACTER SET charset_name] [COLLATE collation_name]\n\nDescription\n-----------\n\nA TEXT column with a maximum length of 16,777,215 (224 - 1) characters. The\neffective maximum length is less if the value contains multi-byte characters.\nEach MEDIUMTEXT value is stored using a three-byte length prefix that\nindicates the number of bytes in the value.\n\nURL: https://mariadb.com/kb/en/mediumtext/','','https://mariadb.com/kb/en/mediumtext/'),
(164,'RELEASE_LOCK',14,'Syntax\n------\n\nRELEASE_LOCK(str)\n\nDescription\n-----------\n\nReleases the lock named by the string str that was obtained with GET_LOCK().\nReturns 1 if the lock was released, 0 if the lock was not established by this\nthread (in which case the lock is not released), and NULL if the named lock\ndid not exist. The lock does not exist if it was never obtained by a call to\nGET_LOCK() or if it has previously been released.\n\nstr is case insensitive. If str is an empty string or NULL, RELEASE_LOCK()\nreturns NULL and does nothing.\n\nStatements using the RELEASE_LOCK() function are not safe for replication.\n\nThe DO statement is convenient to use with RELEASE_LOCK().\n\nExamples\n--------\n\nConnection1:\n\nSELECT GET_LOCK(\'lock1\',10);\n+----------------------+\n| GET_LOCK(\'lock1\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nConnection 2:\n\nSELECT GET_LOCK(\'lock2\',10);\n+----------------------+\n| GET_LOCK(\'lock2\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nConnection 1:\n\nSELECT RELEASE_LOCK(\'lock1\'), RELEASE_LOCK(\'lock2\'), RELEASE_LOCK(\'lock3\');\n+-----------------------+-----------------------+-----------------------+\n| RELEASE_LOCK(\'lock1\') | RELEASE_LOCK(\'lock2\') | RELEASE_LOCK(\'lock3\') |\n+-----------------------+-----------------------+-----------------------+\n|                     1 |                     0 |                  NULL |\n+-----------------------+-----------------------+-----------------------+\n\nFrom MariaDB 10.0.2, it is possible to hold the same lock recursively. This\nexample is viewed using the metadata_lock_info plugin:\n\nSELECT GET_LOCK(\'lock3\',10);\n+----------------------+\n| GET_LOCK(\'lock3\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT GET_LOCK(\'lock3\',10);\n+----------------------+\n| GET_LOCK(\'lock3\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n| THREAD_ID | LOCK_MODE           | LOCK_DURATION | LOCK_TYPE | TABLE_SCHEMA |\nTABLE_NAME |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n|        46 | MDL_SHARED_NO_WRITE | NULL          | User lock | lock3        |\n     |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n\nSELECT RELEASE_LOCK(\'lock3\');\n+-----------------------+\n| RELEASE_LOCK(\'lock3\') |\n+-----------------------+\n|                     1 |\n+-----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n| THREAD_ID | LOCK_MODE           | LOCK_DURATION | LOCK_TYPE | TABLE_SCHEMA |\nTABLE_NAME |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n|        46 | MDL_SHARED_NO_WRITE | NULL          | User lock | lock3        |\n     |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n\nSELECT RELEASE_LOCK(\'lock3\');\n+-----------------------+\n| RELEASE_LOCK(\'lock3\') |\n+-----------------------+\n|                     1 |\n+-----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\nEmpty set (0.000 sec)\n\nURL: https://mariadb.com/kb/en/release_lock/','','https://mariadb.com/kb/en/release_lock/'),
(167,'UUID',14,'Syntax\n------\n\nUUID()\n\nDescription\n-----------\n\nReturns a Universally Unique Identifier (UUID).\n\nA UUID is designed as a number that is globally unique in space and time. Two\ncalls to UUID() are expected to generate two different values, even if these\ncalls are performed on two separate computers that are not connected to each\nother.\n\nUUID() results are intended to be unique, but cannot always be relied upon to\nunpredictable and unguessable, so should not be relied upon for these purposes.\n\nA UUID is a 128-bit number represented by a utf8 string of five hexadecimal\nnumbers in aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee format:\n\n* The first three numbers are generated from a timestamp.\n* The fourth number preserves temporal uniqueness in case the timestamp value\n loses monotonicity (for example, due to daylight saving time).\n* The fifth number is an IEEE 802 node number that provides spatial uniqueness.\n A random number is substituted if the latter is not available (for example,\n because the host computer has no Ethernet card, or we do not know how to find\n the hardware address of an interface on your operating system). In this case,\n spatial uniqueness cannot be guaranteed. Nevertheless, a collision should\n have very low probability.\n\nCurrently, the MAC address of an interface is taken into account only on\nFreeBSD and Linux. On other operating systems, MariaDB uses a randomly\ngenerated 48-bit number.\n\nStatements using the UUID() function are not safe for replication.\n\nThe results are generated according to the \"DCE 1.1:Remote Procedure Call\"\n(Appendix A) CAE (Common Applications Environment) Specifications published by\nThe Open Group in October 1997 (Document Number C706).\n\nExamples\n--------\n\nSELECT UUID();\n+--------------------------------------+\n| UUID()                               |\n+--------------------------------------+\n| cd41294a-afb0-11df-bc9b-00241dd75637 |\n+--------------------------------------+\n\nURL: https://mariadb.com/kb/en/uuid/','','https://mariadb.com/kb/en/uuid/'),
(281,'LONGBLOB',23,'Syntax\n------\n\nLONGBLOB\n\nDescription\n-----------\n\nA BLOB column with a maximum length of 4,294,967,295 bytes or 4GB (232 - 1).\nThe effective maximum length of LONGBLOB columns depends on the configured\nmaximum packet size in the client/server protocol and available memory. Each\nLONGBLOB value is stored using a four-byte length prefix that indicates the\nnumber of bytes in the value.\n\nOracle Mode\n-----------\n\nMariaDB starting with 10.3\n--------------------------\nIn Oracle mode from MariaDB 10.3, BLOB is a synonym for LONGBLOB.\n\nURL: https://mariadb.com/kb/en/longblob/','','https://mariadb.com/kb/en/longblob/'),
(285,'TINYBLOB',23,'Syntax\n------\n\nTINYBLOB\n\nDescription\n-----------\n\nA BLOB column with a maximum length of 255 (28 - 1) bytes. Each TINYBLOB value\nis stored using a one-byte length prefix that indicates the number of bytes in\nthe value.\n\nURL: https://mariadb.com/kb/en/tinyblob/','','https://mariadb.com/kb/en/tinyblob/'),
(286,'TINYTEXT',23,'Syntax\n------\n\nTINYTEXT [CHARACTER SET charset_name] [COLLATE collation_name]\n\nDescription\n-----------\n\nA TEXT column with a maximum length of 255 (28 - 1) characters. The effective\nmaximum length is less if the value contains multi-byte characters. Each\nTINYTEXT value is stored using a one-byte length prefix that indicates the\nnumber of bytes in the value.\n\nURL: https://mariadb.com/kb/en/tinytext/','','https://mariadb.com/kb/en/tinytext/'),
(289,'SET Data Type',23,'Syntax\n------\n\nSET(\'value1\',\'value2\',...) [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n\nDescription\n-----------\n\nA set. A string object that can have zero or more values, each of which must\nbe chosen from the list of values \'value1\', \'value2\', ... A SET column can\nhave a maximum of 64 members. SET values are represented internally as\nintegers.\n\nSET values cannot contain commas.\n\nIf a SET contains duplicate values, an error will be returned if strict mode\nis enabled, or a warning if strict mode is not enabled.\n\nURL: https://mariadb.com/kb/en/set-data-type/','','https://mariadb.com/kb/en/set-data-type/'),
(168,'UUID_SHORT',14,'Syntax\n------\n\nUUID_SHORT()\n\nDescription\n-----------\n\nReturns a \"short\" universally unique identifier as a 64-bit unsigned integer\n(rather than a string-form 128-bit identifier as returned by the UUID()\nfunction).\n\nThe value of UUID_SHORT() is guaranteed to be unique if the following\nconditions hold:\n\n* The server_id of the current host is unique among your set of master and\n slave servers\n* server_id is between 0 and 255\n* You don\'t set back your system time for your server between mysqld restarts\n* You do not invoke UUID_SHORT() on average more than 16\n million times per second between mysqld restarts\n\nThe UUID_SHORT() return value is constructed this way:\n\n(server_id & 255) << 56\n+ (server_startup_time_in_seconds << 24)\n+ incremented_variable++;\n\nStatements using the UUID_SHORT() function are not safe for statement-based\nreplication.\n\nExamples\n--------\n\nSELECT UUID_SHORT();\n+-------------------+\n| UUID_SHORT()      |\n+-------------------+\n| 21517162376069120 |\n+-------------------+\n\ncreate table t1 (a bigint unsigned default(uuid_short()) primary key);\ninsert into t1 values(),();\nselect * from t1;\n+-------------------+\n| a                 |\n+-------------------+\n| 98113699159474176 |\n| 98113699159474177 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/uuid_short/','','https://mariadb.com/kb/en/uuid_short/'),
(169,'VALUES / VALUE',14,'Syntax\n------\n\nMariaDB starting with 10.3.3\n----------------------------\n\nVALUE(col_name)\n\nMariaDB until 10.3.2\n--------------------\n\nVALUES(col_name)\n\nDescription\n-----------\n\nIn an INSERT ... ON DUPLICATE KEY UPDATE statement, you can use the\nVALUES(col_name) function in the UPDATE clause to refer to column values from\nthe INSERT portion of the statement. In other words, VALUES(col_name) in the\nUPDATE clause refers to the value of col_name that would be inserted, had no\nduplicate-key conflict occurred. This function is especially useful in\nmultiple-row inserts.\n\nThe VALUES() function is meaningful only in INSERT ... ON DUPLICATE KEY UPDATE\nstatements and returns NULL otherwise.\n\nIn MariaDB 10.3.3 this function was renamed to VALUE(), because it\'s\nincompatible with the standard Table Value Constructors syntax, implemented in\nMariaDB 10.3.3.\n\nThe VALUES() function can still be used even from MariaDB 10.3.3, but only in\nINSERT ... ON DUPLICATE KEY UPDATE statements; it\'s a syntax error otherwise.\n\nExamples\n--------\n\nMariaDB starting with 10.3.3\n----------------------------\n\nINSERT INTO t (a,b,c) VALUES (1,2,3),(4,5,6)\n  ON DUPLICATE KEY UPDATE c=VALUE(a)+VALUE(b);\n\nMariaDB until 10.3.2\n--------------------\n\nINSERT INTO t (a,b,c) VALUES (1,2,3),(4,5,6)\n  ON DUPLICATE KEY UPDATE c=VALUES(a)+VALUES(b);\n\nURL: https://mariadb.com/kb/en/values-value/','','https://mariadb.com/kb/en/values-value/'),
(173,'||',15,'Syntax\n------\n\nOR, ||\n\nDescription\n-----------\n\nLogical OR. When both operands are non-NULL, the result is 1 if any operand is\nnon-zero, and 0 otherwise. With a NULL operand, the result is 1 if the other\noperand is non-zero, and NULL otherwise. If both operands are NULL, the result\nis NULL.\n\nFor this operator, short-circuit evaluation can be used.\n\nNote that, if the PIPES_AS_CONCAT SQL_MODE is set, || is used as a string\nconcatenation operator. This means that a || b is the same as CONCAT(a,b). See\nCONCAT() for details.\n\nOracle Mode\n-----------\n\nMariaDB starting with 10.3\n--------------------------\nIn Oracle mode from MariaDB 10.3, || ignores NULL.\n\nExamples\n--------\n\nSELECT 1 || 1;\n+--------+\n| 1 || 1 |\n+--------+\n|      1 |\n+--------+\n\nSELECT 1 || 0;\n+--------+\n| 1 || 0 |\n+--------+\n|      1 |\n+--------+\n\nSELECT 0 || 0;\n+--------+\n| 0 || 0 |\n+--------+\n|      0 |\n+--------+\n\nSELECT 0 || NULL;\n+-----------+\n| 0 || NULL |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT 1 || NULL;\n+-----------+\n| 1 || NULL |\n+-----------+\n|         1 |\n+-----------+\n\nIn Oracle mode, from MariaDB 10.3:\n\nSELECT 0 || NULL;\n+-----------+\n| 0 || NULL |\n+-----------+\n| 0         |\n+-----------+\n\nURL: https://mariadb.com/kb/en/or/','','https://mariadb.com/kb/en/or/'),
(175,'AVG',16,'Syntax\n------\n\nAVG([DISTINCT] expr)\n\nDescription\n-----------\n\nReturns the average value of expr. The DISTINCT option can be used to return\nthe average of the distinct values of expr. NULL values are ignored. It is an\naggregate function, and so can be used with the GROUP BY clause.\n\nAVG() returns NULL if there were no matching rows.\n\nAVG() can be used as a window function.\n\nExamples\n--------\n\nCREATE TABLE sales (sales_value INT);\n\nINSERT INTO sales VALUES(10),(20),(20),(40);\n\nSELECT AVG(sales_value) FROM sales;\n+------------------+\n| AVG(sales_value) |\n+------------------+\n|          22.5000 |\n+------------------+\n\nSELECT AVG(DISTINCT(sales_value)) FROM sales;\n+----------------------------+\n| AVG(DISTINCT(sales_value)) |\n+----------------------------+\n|                    23.3333 |\n+----------------------------+\n\nCommonly, AVG() is used with a GROUP BY clause:\n\nCREATE TABLE student (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT name, AVG(score) FROM student GROUP BY name;\n+---------+------------+\n| name    | AVG(score) |\n+---------+------------+\n| Chun    |    74.0000 |\n| Esben   |    37.0000 |\n| Kaolin  |    72.0000 |\n| Tatiana |    85.0000 |\n+---------+------------+\n\nBe careful to avoid this common mistake, not grouping correctly and returning\nmismatched data:\n\nSELECT name,test,AVG(score) FROM student;\n+------+------+------------+\n| name | test | MIN(score) |\n+------+------+------------+\n| Chun | SQL  |         31 |\n+------+------+------------+\n\nAs a window function:\n\nCREATE TABLE student_test (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT name, test, score, AVG(score) OVER (PARTITION BY test) \n  AS average_by_test FROM student_test;\n+---------+--------+-------+-----------------+\n| name    | test   | score | average_by_test |\n+---------+--------+-------+-----------------+\n| Chun    | SQL    |    75 |         65.2500 |\n| Chun    | Tuning |    73 |         68.7500 |\n| Esben   | SQL    |    43 |         65.2500 |\n| Esben   | Tuning |    31 |         68.7500 |\n| Kaolin  | SQL    |    56 |         65.2500 |\n| Kaolin  | Tuning |    88 |         68.7500 |\n| Tatiana | SQL    |    87 |         65.2500 |\n| Tatiana | Tuning |    83 |         68.7500 |\n+---------+--------+-------+-----------------+\n\nURL: https://mariadb.com/kb/en/avg/','','https://mariadb.com/kb/en/avg/'),
(294,'TIMESTAMP',23,'Syntax\n------\n\nTIMESTAMP [(<microsecond precision)]\n\nDescription\n-----------\n\nA timestamp in the format YYYY-MM-DD HH:MM:SS.ffffff.\n\nThe timestamp field is generally used to define at which moment in time a row\nwas added or updated and by default will automatically be assigned the current\ndatetime when a record is inserted or updated. The automatic properties only\napply to the first TIMESTAMP in the record; subsequent TIMESTAMP columns will\nnot be changed.\n\nMariaDB includes the --mysql56-temporal-format option, on by default, which\nallows MariaDB to store TIMESTAMPs using the same low-level format MySQL 5.6\nuses.\n\nFor more information, see Internal Format.\n\nSupported Values\n----------------\n\nMariaDB stores values that use the TIMESTAMP data type as the number of\nseconds since \'1970-01-01 00:00:00\' (UTC). This means that the TIMESTAMP data\ntype can hold values between \'1970-01-01 00:00:01\' (UTC) and \'2038-01-19\n03:14:07\' (UTC).\n\nMariaDB can also store microseconds with a precision between 0 and 6. If no\nmicrosecond precision is specified, then 0 is used by default.\n\nAutomatic Values\n----------------\n\nMariaDB has special behavior for the first column that uses the TIMESTAMP data\ntype in a specific table when the system variable\nexplicit_defaults_for_timestamp is not set (which is the default until MariaDB\n10.10). For the first column that uses the TIMESTAMP data type in a specific\ntable, MariaDB automatically assigns the following properties to the column:\n\n* DEFAULT CURRENT_TIMESTAMP\n* ON UPDATE CURRENT_TIMESTAMP\n\nThis means that if the column is not explicitly assigned a value in an INSERT\nor UPDATE query, then MariaDB will automatically initialize the column\'s value\nwith the current date and time.\n\nThis automatic initialization for INSERT and UPDATE queries can also be\nexplicitly enabled for a column that uses the TIMESTAMP data type by\nspecifying the DEFAULT CURRENT_TIMESTAMP and ON UPDATE CURRENT_TIMESTAMP\nclauses for the column. In these clauses, any synonym of CURRENT_TIMESTAMP is\naccepted, including CURRENT_TIMESTAMP(), NOW(), LOCALTIME, LOCALTIME(),\nLOCALTIMESTAMP, and LOCALTIMESTAMP().\n\nThis automatic initialization for INSERT queries can also be explicitly\ndisabled for a column that uses the TIMESTAMP data type by specifying a\nconstant DEFAULT value. For example, DEFAULT 0.\n\nThis automatic initialization for UPDATE queries can also be explicitly\ndisabled for a column that uses the TIMESTAMP data type by specifying a\nDEFAULT clause for the column, but no ON UPDATE clause. If a DEFAULT clause is\nexplicitly specified for a column that uses the TIMESTAMP data type, but an ON\nUPDATE clause is not specified for the column, then the timestamp value will\nnot automatically change when an UPDATE statement is executed.\n\nMariaDB also has special behavior if NULL is assigned to column that uses the\nTIMESTAMP data type. If the column is assigned the NULL value in an INSERT or\nUPDATE query, then MariaDB will automatically initialize the column\'s value\nwith the current date and time. For details, see NULL values in MariaDB.\n\nThis automatic initialization for NULL values can also be explicitly disabled\nfor a column that uses the TIMESTAMP data type by specifying the NULL\nattribute for the column. In this case, if the column\'s value is set to NULL,\nthen the column\'s value will actually be set to NULL.\n\nTime Zones\n----------\n\nIf a column uses the TIMESTAMP data type, then any inserted values are\nconverted from the session\'s time zone to Coordinated Universal Time (UTC)\nwhen stored, and converted back to the session\'s time zone when retrieved.\n\nMariaDB validates TIMESTAMP literals against the session\'s time zone. For\nexample, if a specific time range never occurred in a specific time zone due\nto daylight savings time, then TIMESTAMP values within that range would be\ninvalid for that time zone.\n\nMariaDB does not currently store any time zone identifier with the value of\nthe TIMESTAMP data type. See MDEV-10018 for more information.\n\nMariaDB does not currently support time zone literals that contain time zone\nidentifiers. See MDEV-11829 for more information.\n\nLimitations\n-----------\n\n* Because the TIMESTAMP value is stored as Epoch Seconds, the timestamp value\n\'1970-01-01 00:00:00\' (UTC) is reserved since the second #0 is used to\nrepresent \'0000-00-00 00:00:00\'.\n* In MariaDB 5.5 and before there could only be one TIMESTAMP column per table\nthat had CURRENT_TIMESTAMP defined as its default value. This limit has no\nlonger applied since MariaDB 10.0.\n\nSQL_MODE=MAXDB\n--------------\n\nIf the SQL_MODE is set to MAXDB, TIMESTAMP fields will be silently converted\nto DATETIME.\n\nInternal Format\n---------------\n\nIn MariaDB 10.1.2 a new temporal format was introduced from MySQL 5.6 that\nalters how the TIME, DATETIME and TIMESTAMP columns operate at lower levels.\nThese changes allow these temporal data types to have fractional parts and\nnegative values. You can disable this feature using the\nmysql56_temporal_format system variable.\n\nTables that include TIMESTAMP values that were created on an older version of\nMariaDB or that were created while the mysql56_temporal_format system variable\nwas disabled continue to store data using the older data type format.\n\nIn order to update table columns from the older format to the newer format,\nexecute an ALTER TABLE... MODIFY COLUMN statement that changes the column to\nthe *same* data type. This change may be needed if you want to export the\ntable\'s tablespace and import it onto a server that has\nmysql56_temporal_format=ON set (see MDEV-15225).\n\nFor instance, if you have a TIMESTAMP column in your table:\n\nSHOW VARIABLES LIKE \'mysql56_temporal_format\';\n\n+-------------------------+-------+\n| Variable_name           | Value |\n+-------------------------+-------+\n| mysql56_temporal_format | ON    |\n+-------------------------+-------+\n\nALTER TABLE example_table MODIFY ts_col TIMESTAMP;\n\nWhen MariaDB executes the ALTER TABLE statement, it converts the data from the\nolder temporal format to the newer one.\n\nIn the event that you have several tables and columns using temporal data\ntypes that you want to switch over to the new format, make sure the system\nvariable is enabled, then perform a dump and restore using mysqldump. The\ncolumns using relevant temporal data types are restored using the new temporal\nformat.\n\nStarting from MariaDB 10.5.1 columns with old temporal formats are marked with\na /* mariadb-5.3 */ comment in the output of SHOW CREATE TABLE, SHOW COLUMNS,\nDESCRIBE statements, as well as in the COLUMN_TYPE column of the\nINFORMATION_SCHEMA.COLUMNS Table.\n\nSHOW CREATE TABLE mariadb5312_timestamp\\G\n*************************** 1. row ***************************\n   Table: mariadb5312_timestamp\nCreate Table: CREATE TABLE `mariadb5312_timestamp` (\n `ts0` timestamp /* mariadb-5.3 */ NOT NULL DEFAULT current_timestamp() ON\nUPDATE current_timestamp(),\n `ts6` timestamp(6) /* mariadb-5.3 */ NOT NULL DEFAULT \'0000-00-00\n00:00:00.000000\'\n) ENGINE=MyISAM DEFAULT CHARSET=latin1\n\nNote: Prior to MySQL 4.1 a different format for the TIMESTAMP datatype was\nused. This format is unsupported in MariaDB 5.1 and upwards.\n\nExamples\n--------\n\nCREATE TABLE t (id INT, ts TIMESTAMP);\n\nDESC t;\n+-------+-----------+------+-----+-------------------+-------------------------\n---+\n| Field | Type      | Null | Key | Default           | Extra                  \n  |\n+-------+-----------+------+-----+-------------------+-------------------------\n---+\n| id    | int(11)   | YES  |     | NULL              |                        \n  |\n| ts    | timestamp | NO   |     | CURRENT_TIMESTAMP | on update\nCURRENT_TIMESTAMP |\n+-------+-----------+------+-----+-------------------+-------------------------\n---+\n\nINSERT INTO t(id)  VALUES (1),(2);\n\nSELECT * FROM t;\n+------+---------------------+\n| id   | ts                  |\n+------+---------------------+\n|    1 | 2013-07-22 12:50:05 |\n|    2 | 2013-07-22 12:50:05 |\n+------+---------------------+\n\nINSERT INTO t  VALUES (3,NULL),(4,\'2001-07-22 12:12:12\');\n\nSELECT * FROM t;\n+------+---------------------+\n| id   | ts                  |\n+------+---------------------+\n|    1 | 2013-07-22 12:50:05 |\n|    2 | 2013-07-22 12:50:05 |\n|    3 | 2013-07-22 12:51:56 |\n|    4 | 2001-07-22 12:12:12 |\n+------+---------------------+\n\nConverting to Unix epoch:\n\nSELECT ts, UNIX_TIMESTAMP(ts) FROM t;\n+---------------------+--------------------+\n| ts                  | UNIX_TIMESTAMP(ts) |\n+---------------------+--------------------+\n| 2013-07-22 12:50:05 |         1374490205 |\n| 2013-07-22 12:50:05 |         1374490205 |\n| 2013-07-22 12:51:56 |         1374490316 |\n| 2001-07-22 12:12:12 |          995796732 |\n+---------------------+--------------------+\n\nUpdate also changes the timestamp:\n\nUPDATE t set id=5 WHERE id=1;\n\nSELECT * FROM t;\n+------+---------------------+\n| id   | ts                  |\n+------+---------------------+\n|    5 | 2013-07-22 14:52:33 |\n|    2 | 2013-07-22 12:50:05 |\n|    3 | 2013-07-22 12:51:56 |\n|    4 | 2001-07-22 12:12:12 |\n+------+---------------------+\n\nDefault NULL:\n\nCREATE TABLE t2 (id INT, ts TIMESTAMP NULL ON UPDATE CURRENT_TIMESTAMP);\n\nINSERT INTO t(id)  VALUES (1),(2);\n\nSELECT * FROM t2;\n\nINSERT INTO t2(id)  VALUES (1),(2);\n\nSELECT * FROM t2;\n+------+------+\n| id   | ts   |\n+------+------+\n|    1 | NULL |\n|    2 | NULL |\n+------+------+\n\nUPDATE t2 SET id=3 WHERE id=1;\n\nSELECT * FROM t2;\n+------+---------------------+\n| id   | ts                  |\n+------+---------------------+\n|    3 | 2013-07-22 15:32:22 |\n|    2 | NULL                |\n+------+---------------------+\n\nOnly the first timestamp is automatically inserted and updated:\n\nCREATE TABLE t3 (id INT, ts1 TIMESTAMP, ts2 TIMESTAMP);\n\nINSERT INTO t3(id)  VALUES (1),(2);\n\nSELECT * FROM t3;\n+------+---------------------+---------------------+\n| id   | ts1                 | ts2                 |\n+------+---------------------+---------------------+\n|    1 | 2013-07-22 15:35:07 | 0000-00-00 00:00:00 |\n|    2 | 2013-07-22 15:35:07 | 0000-00-00 00:00:00 |\n+------+---------------------+---------------------+\n\nDESC t3;\n+-------+-----------+------+-----+---------------------+-----------------------\n-----+\n| Field | Type      | Null | Key | Default             | Extra                \n   |\n+-------+-----------+------+-----+---------------------+-----------------------\n-----+\n| id    | int(11)   | YES  |     | NULL                |                      \n   |\n| ts1   | timestamp | NO   |     | CURRENT_TIMESTAMP   | on update\nCURRENT_TIMESTAMP |\n| ts2   | timestamp | NO   |     | 0000-00-00 00:00:00 |                      \n   |\n+-------+-----------+------+-----+---------------------+-----------------------\n-----+\n\nExplicitly setting a timestamp with the CURRENT_TIMESTAMP function:\n\nINSERT INTO t3(id,ts2)  VALUES (3,CURRENT_TIMESTAMP());\n\nSELECT * FROM t3;\n+------+---------------------+---------------------+\n| id   | ts1                 | ts2                 |\n+------+---------------------+---------------------+\n|    1 | 2013-07-22 15:35:07 | 0000-00-00 00:00:00 |\n|    2 | 2013-07-22 15:35:07 | 0000-00-00 00:00:00 |\n|    3 | 2013-07-22 15:38:52 | 2013-07-22 15:38:52 |\n+------+---------------------+---------------------+\n\nSpecifying the timestamp as NOT NULL:\n\nCREATE TABLE t4 (id INT, ts TIMESTAMP NOT NULL);\n\nINSERT INTO t4(id)  VALUES (1);\nSELECT SLEEP(1);\nINSERT INTO t4(id,ts) VALUES (2,NULL);\n\nSELECT * FROM t4;\n\nURL: https://mariadb.com/kb/en/timestamp/','','https://mariadb.com/kb/en/timestamp/'),
(304,'GOTO',24,'MariaDB starting with 10.3\n--------------------------\nThe GOTO statement was introduced in MariaDB 10.3 for Oracle compatibility.\n\nSyntax\n------\n\nGOTO label\n\nDescription\n-----------\n\nThe GOTO statement causes the code to jump to the specified label, and\ncontinue operating from there. It is only accepted when in Oracle mode.\n\nExample\n-------\n\nSET sql_mode=ORACLE;\n\nDELIMITER //\n\nCREATE OR REPLACE PROCEDURE p1 AS\n\nBEGIN\n\nSELECT 1;\n GOTO label;\n SELECT 2;\n <<label>>\n SELECT 3;\n\nEND;\n\n//\n\nDELIMITER\n\ncall p1();\n+---+\n| 1 |\n+---+\n| 1 |\n+---+\n1 row in set (0.000 sec)\n\n+---+\n| 3 |\n+---+\n| 3 |\n+---+\n1 row in set (0.000 sec)\n\nURL: https://mariadb.com/kb/en/goto/','','https://mariadb.com/kb/en/goto/'),
(174,'Stored Aggregate Functions',16,'MariaDB starting with 10.3.3\n----------------------------\nThe ability to create stored aggregate functions was added in MariaDB 10.3.3.\n\nAggregate functions are functions that are computed over a sequence of rows\nand return one result for the sequence of rows.\n\nCreating a custom aggregate function is done using the CREATE FUNCTION\nstatement with two main differences:\n\n* The addition of the AGGREGATE keyword, so CREATE AGGREGATE FUNCTION\n* The FETCH GROUP NEXT ROW instruction inside the loop\n* Oracle PL/SQL compatibility using SQL/PL is provided\n\nStandard Syntax\n---------------\n\nCREATE AGGREGATE FUNCTION function_name (parameters) RETURNS return_type\nBEGIN\n   All types of declarations\n   DECLARE CONTINUE HANDLER FOR NOT FOUND RETURN return_val;\n   LOOP\n     FETCH GROUP NEXT ROW; // fetches next row from table\n     other instructions\n   END LOOP;\nEND\n\nStored aggregate functions were a 2016 Google Summer of Code project by Varun\nGupta.\n\nUsing SQL/PL\n------------\n\nSET sql_mode=Oracle;\nDELIMITER //\n\nCREATE AGGREGATE FUNCTION function_name (parameters) RETURN return_type\n declarations\nBEGIN\n LOOP\n   FETCH GROUP NEXT ROW; -- fetches next row from table\n   -- other instructions\n\nEND LOOP;\nEXCEPTION\n WHEN NO_DATA_FOUND THEN\n   RETURN return_val;\nEND //\n\nDELIMITER ;\n\nExamples\n--------\n\nFirst a simplified example:\n\nCREATE TABLE marks(stud_id INT, grade_count INT);\n\nINSERT INTO marks VALUES (1,6), (2,4), (3,7), (4,5), (5,8);\n\nSELECT * FROM marks;\n+---------+-------------+\n| stud_id | grade_count |\n+---------+-------------+\n|       1 |           6 |\n|       2 |           4 |\n|       3 |           7 |\n|       4 |           5 |\n|       5 |           8 |\n+---------+-------------+\n\nDELIMITER //\nCREATE AGGREGATE FUNCTION IF NOT EXISTS aggregate_count(x INT) RETURNS INT\nBEGIN\n DECLARE count_students INT DEFAULT 0;\n DECLARE CONTINUE HANDLER FOR NOT FOUND\n RETURN count_students;\n   LOOP\n     FETCH GROUP NEXT ROW;\n     IF x  THEN\n      SET count_students = count_students+1;\n     END IF;\n   END LOOP;\nEND //\nDELIMITER ;\n\nA non-trivial example that cannot easily be rewritten using existing functions:\n\nDELIMITER //\nCREATE AGGREGATE FUNCTION medi_int(x INT) RETURNS DOUBLE\nBEGIN\n DECLARE CONTINUE HANDLER FOR NOT FOUND\n  BEGIN\n   DECLARE res DOUBLE;\n   DECLARE cnt INT DEFAULT (SELECT COUNT(*) FROM tt);\n   DECLARE lim INT DEFAULT (cnt-1) DIV 2;\n   IF cnt % 2 = 0 THEN\n    SET res = (SELECT AVG(a) FROM (SELECT a FROM tt ORDER BY a LIMIT\nlim,2) ttt);\n   ELSE\n    SET res = (SELECT a FROM tt ORDER BY a LIMIT lim,1);\n   END IF;\n   DROP TEMPORARY TABLE tt;\n   RETURN res;\n  END;\n CREATE TEMPORARY TABLE tt (a INT);\n LOOP\n  FETCH GROUP NEXT ROW;\n  INSERT INTO tt VALUES (x);\n END LOOP;\nEND //\nDELIMITER ;\n\nSQL/PL Example\n--------------\n\nThis uses the same marks table as created above.\n\nSET sql_mode=Oracle;\nDELIMITER //\n\nCREATE AGGREGATE FUNCTION aggregate_count(x INT) RETURN INT AS count_students\nINT DEFAULT 0;\nBEGIN\n LOOP\n   FETCH GROUP NEXT ROW;\n   IF x  THEN\n    SET count_students := count_students+1;\n   END IF;\n END LOOP;\nEXCEPTION\n WHEN NO_DATA_FOUND THEN\n   RETURN count_students;\nEND aggregate_count //\nDELIMITER ;\n\nSELECT aggregate_count(stud_id) FROM marks;\n\nURL: https://mariadb.com/kb/en/stored-aggregate-functions/','','https://mariadb.com/kb/en/stored-aggregate-functions/'),
(176,'BIT_AND',16,'Syntax\n------\n\nBIT_AND(expr) [over_clause]\n\nDescription\n-----------\n\nReturns the bitwise AND of all bits in expr. The calculation is performed with\n64-bit (BIGINT) precision. It is an aggregate function, and so can be used\nwith the GROUP BY clause.\n\nIf no rows match, BIT_AND will return a value with all bits set to 1. NULL\nvalues have no effect on the result unless all results are NULL, which is\ntreated as no match.\n\nBIT_AND can be used as a window function with the addition of the over_clause.\n\nExamples\n--------\n\nCREATE TABLE vals (x INT);\n\nINSERT INTO vals VALUES(111),(110),(100);\n\nSELECT BIT_AND(x), BIT_OR(x), BIT_XOR(x) FROM vals;\n+------------+-----------+------------+\n| BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+------------+-----------+------------+\n|        100 |       111 |        101 |\n+------------+-----------+------------+\n\nAs an aggregate function:\n\nCREATE TABLE vals2 (category VARCHAR(1), x INT);\n\nINSERT INTO vals2 VALUES\n (\'a\',111),(\'a\',110),(\'a\',100),\n (\'b\',\'000\'),(\'b\',001),(\'b\',011);\n\nSELECT category, BIT_AND(x), BIT_OR(x), BIT_XOR(x) \n FROM vals GROUP BY category;\n+----------+------------+-----------+------------+\n| category | BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+----------+------------+-----------+------------+\n| a        |        100 |       111 |        101 |\n| b        |          0 |        11 |         10 |\n+----------+------------+-----------+------------+\n\nNo match:\n\nSELECT BIT_AND(NULL);\n+----------------------+\n| BIT_AND(NULL)        |\n+----------------------+\n| 18446744073709551615 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/bit_and/','','https://mariadb.com/kb/en/bit_and/'),
(305,'IF',24,'Syntax\n------\n\nIF search_condition THEN statement_list\n  [ELSEIF search_condition THEN statement_list] ...\n  [ELSE statement_list]\nEND IF;\n\nDescription\n-----------\n\nIF implements a basic conditional construct. If the search_condition evaluates\nto true, the corresponding SQL statement list is executed. If no\nsearch_condition matches, the statement list in the ELSE clause is executed.\nEach statement_list consists of one or more statements.\n\nURL: https://mariadb.com/kb/en/if/','','https://mariadb.com/kb/en/if/'),
(309,'LOOP',24,'Syntax\n------\n\n[begin_label:] LOOP\n  statement_list\nEND LOOP [end_label]\n\nDescription\n-----------\n\nLOOP implements a simple loop construct, enabling repeated execution of the\nstatement list, which consists of one or more statements, each terminated by a\nsemicolon (i.e., ;) statement delimiter. The statements within the loop are\nrepeated until the loop is exited; usually this is accomplished with a LEAVE\nstatement.\n\nA LOOP statement can be labeled. end_label cannot be given unless begin_label\nalso is present. If both are present, they must be the same.\n\nSee Delimiters in the mariadb client for more on delimiter usage in the client.\n\nURL: https://mariadb.com/kb/en/loop/','','https://mariadb.com/kb/en/loop/'),
(312,'RETURN',24,'Syntax\n------\n\nRETURN expr\n\nThe RETURN statement terminates execution of a stored function and returns the\nvalue expr to the function caller. There must be at least one RETURN statement\nin a stored function. If the function has multiple exit points, all exit\npoints must have a RETURN.\n\nThis statement is not used in stored procedures, triggers, or events. LEAVE\ncan be used instead.\n\nThe following example shows that RETURN can return the result of a scalar\nsubquery:\n\nCREATE FUNCTION users_count() RETURNS BOOL\n READS SQL DATA\nBEGIN\n RETURN (SELECT COUNT(DISTINCT User) FROM mysql.user);\nEND;\n\nURL: https://mariadb.com/kb/en/return/','','https://mariadb.com/kb/en/return/'),
(315,'WHILE',24,'Syntax\n------\n\n[begin_label:] WHILE search_condition DO\n  statement_list\nEND WHILE [end_label]\n\nDescription\n-----------\n\nThe statement list within a WHILE statement is repeated as long as the\nsearch_condition is true. statement_list consists of one or more statements.\nIf the loop must be executed at least once, REPEAT ... LOOP can be used\ninstead.\n\nA WHILE statement can be labeled. end_label cannot be given unless begin_label\nalso is present. If both are present, they must be the same.\n\nExamples\n--------\n\nCREATE PROCEDURE dowhile()\nBEGIN\n DECLARE v1 INT DEFAULT 5;\n\nWHILE v1 > 0 DO\n  ...\n  SET v1 = v1 - 1;\n END WHILE;\nEND\n\nURL: https://mariadb.com/kb/en/while/','','https://mariadb.com/kb/en/while/'),
(177,'BIT_OR',16,'Syntax\n------\n\nBIT_OR(expr) [over_clause]\n\nDescription\n-----------\n\nReturns the bitwise OR of all bits in expr. The calculation is performed with\n64-bit (BIGINT) precision. It is an aggregate function, and so can be used\nwith the GROUP BY clause.\n\nIf no rows match, BIT_OR will return a value with all bits set to 0. NULL\nvalues have no effect on the result unless all results are NULL, which is\ntreated as no match.\n\nBIT_OR can be used as a window function with the addition of the over_clause.\n\nExamples\n--------\n\nCREATE TABLE vals (x INT);\n\nINSERT INTO vals VALUES(111),(110),(100);\n\nSELECT BIT_AND(x), BIT_OR(x), BIT_XOR(x) FROM vals;\n+------------+-----------+------------+\n| BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+------------+-----------+------------+\n|        100 |       111 |        101 |\n+------------+-----------+------------+\n\nAs an aggregate function:\n\nCREATE TABLE vals2 (category VARCHAR(1), x INT);\n\nINSERT INTO vals2 VALUES\n (\'a\',111),(\'a\',110),(\'a\',100),\n (\'b\',\'000\'),(\'b\',001),(\'b\',011);\n\nSELECT category, BIT_AND(x), BIT_OR(x), BIT_XOR(x) \n FROM vals GROUP BY category;\n+----------+------------+-----------+------------+\n| category | BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+----------+------------+-----------+------------+\n| a        |        100 |       111 |        101 |\n| b        |          0 |        11 |         10 |\n+----------+------------+-----------+------------+\n\nNo match:\n\nSELECT BIT_OR(NULL);\n+--------------+\n| BIT_OR(NULL) |\n+--------------+\n|            0 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/bit_or/','','https://mariadb.com/kb/en/bit_or/'),
(178,'BIT_XOR',16,'Syntax\n------\n\nBIT_XOR(expr) [over_clause]\n\nDescription\n-----------\n\nReturns the bitwise XOR of all bits in expr. The calculation is performed with\n64-bit (BIGINT) precision. It is an aggregate function, and so can be used\nwith the GROUP BY clause.\n\nIf no rows match, BIT_XOR will return a value with all bits set to 0. NULL\nvalues have no effect on the result unless all results are NULL, which is\ntreated as no match.\n\nBIT_XOR can be used as a window function with the addition of the over_clause.\n\nExamples\n--------\n\nCREATE TABLE vals (x INT);\n\nINSERT INTO vals VALUES(111),(110),(100);\n\nSELECT BIT_AND(x), BIT_OR(x), BIT_XOR(x) FROM vals;\n+------------+-----------+------------+\n| BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+------------+-----------+------------+\n|        100 |       111 |        101 |\n+------------+-----------+------------+\n\nAs an aggregate function:\n\nCREATE TABLE vals2 (category VARCHAR(1), x INT);\n\nINSERT INTO vals2 VALUES\n (\'a\',111),(\'a\',110),(\'a\',100),\n (\'b\',\'000\'),(\'b\',001),(\'b\',011);\n\nSELECT category, BIT_AND(x), BIT_OR(x), BIT_XOR(x) \n FROM vals GROUP BY category;\n+----------+------------+-----------+------------+\n| category | BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+----------+------------+-----------+------------+\n| a        |        100 |       111 |        101 |\n| b        |          0 |        11 |         10 |\n+----------+------------+-----------+------------+\n\nNo match:\n\nSELECT BIT_XOR(NULL);\n+---------------+\n| BIT_XOR(NULL) |\n+---------------+\n|             0 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/bit_xor/','','https://mariadb.com/kb/en/bit_xor/'),
(179,'COUNT',16,'Syntax\n------\n\nCOUNT(expr)\n\nDescription\n-----------\n\nReturns a count of the number of non-NULL values of expr in the rows retrieved\nby a SELECT statement. The result is a BIGINT value. It is an aggregate\nfunction, and so can be used with the GROUP BY clause.\n\nCOUNT(*) counts the total number of rows in a table.\n\nCOUNT() returns 0 if there were no matching rows.\n\nCOUNT() can be used as a window function.\n\nExamples\n--------\n\nCREATE TABLE student (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT COUNT(*) FROM student;\n+----------+\n| COUNT(*) |\n+----------+\n|        8 |\n+----------+\n\nCOUNT(DISTINCT) example:\n\nSELECT COUNT(DISTINCT (name)) FROM student;\n+------------------------+\n| COUNT(DISTINCT (name)) |\n+------------------------+\n|                      4 |\n+------------------------+\n\nAs a window function\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, COUNT(score) OVER (PARTITION BY name) \n  AS tests_written FROM student_test;\n+---------+--------+-------+---------------+\n| name    | test   | score | tests_written |\n+---------+--------+-------+---------------+\n| Chun    | SQL    |    75 |             2 |\n| Chun    | Tuning |    73 |             2 |\n| Esben   | SQL    |    43 |             2 |\n| Esben   | Tuning |    31 |             2 |\n| Kaolin  | SQL    |    56 |             2 |\n| Kaolin  | Tuning |    88 |             2 |\n| Tatiana | SQL    |    87 |             1 |\n+---------+--------+-------+---------------+\n\nURL: https://mariadb.com/kb/en/count/','','https://mariadb.com/kb/en/count/'),
(318,'OPEN',24,'Syntax\n------\n\n<= MariaDB 10.2\n\nOPEN cursor_name\n\nFrom MariaDB 10.3\n\nOPEN cursor_name [expression[,...]];\n\nDescription\n-----------\n\nThis statement opens a cursor which was previously declared with DECLARE\nCURSOR.\n\nThe query associated to the DECLARE CURSOR is executed when OPEN is executed.\nIt is important to remember this if the query produces an error, or calls\nfunctions which have side effects.\n\nThis is necessary in order to FETCH rows from a cursor.\n\nSee Cursor Overview for an example.\n\nURL: https://mariadb.com/kb/en/open/','','https://mariadb.com/kb/en/open/'),
(319,'FETCH',24,'Syntax\n------\n\nFETCH cursor_name INTO var_name [, var_name] ...\n\nDescription\n-----------\n\nThis statement fetches the next row (if a row exists) using the specified open\ncursor, and advances the cursor pointer.\n\nvar_name can be a local variable, but not a user-defined variable.\n\nIf no more rows are available, a No Data condition occurs with SQLSTATE value\n02000. To detect this condition, you can set up a handler for it (or for a NOT\nFOUND condition).\n\nSee Cursor Overview for an example.\n\nURL: https://mariadb.com/kb/en/fetch/','','https://mariadb.com/kb/en/fetch/'),
(320,'CLOSE',24,'Syntax\n------\n\nCLOSE cursor_name\n\nDescription\n-----------\n\nThis statement closes a previously opened cursor. The cursor must have been\npreviously opened or else an error occurs.\n\nIf not closed explicitly, a cursor is closed at the end of the compound\nstatement in which it was declared.\n\nSee Cursor Overview for an example.\n\nURL: https://mariadb.com/kb/en/close/','','https://mariadb.com/kb/en/close/'),
(321,'BUFFER',25,'A synonym for ST_BUFFER.\n\nURL: https://mariadb.com/kb/en/buffer/','','https://mariadb.com/kb/en/buffer/'),
(322,'CONVEXHULL',25,'A synonym for ST_CONVEXHULL.\n\nURL: https://mariadb.com/kb/en/convexhull/','','https://mariadb.com/kb/en/convexhull/'),
(323,'GEOMETRYCOLLECTION',25,'Syntax\n------\n\nGeometryCollection(g1,g2,...)\n\nDescription\n-----------\n\nConstructs a WKB GeometryCollection. If any argument is not a well-formed WKB\nrepresentation of a geometry, the return value is NULL.\n\nExamples\n--------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/geometrycollection/','','https://mariadb.com/kb/en/geometrycollection/'),
(180,'COUNT DISTINCT',16,'Syntax\n------\n\nCOUNT(DISTINCT expr,[expr...])\n\nDescription\n-----------\n\nReturns a count of the number of different non-NULL values.\n\nCOUNT(DISTINCT) returns 0 if there were no matching rows.\n\nAlthough, from MariaDB 10.2.0, COUNT can be used as a window function, COUNT\nDISTINCT cannot be.\n\nExamples\n--------\n\nCREATE TABLE student (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT COUNT(*) FROM student;\n+----------+\n| COUNT(*) |\n+----------+\n|        8 |\n+----------+\n\nSELECT COUNT(DISTINCT (name)) FROM student;\n+------------------------+\n| COUNT(DISTINCT (name)) |\n+------------------------+\n|                      4 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/count-distinct/','','https://mariadb.com/kb/en/count-distinct/'),
(181,'GROUP_CONCAT',16,'Syntax\n------\n\nGROUP_CONCAT(expr)\n\nDescription\n-----------\n\nThis function returns a string result with the concatenated non-NULL values\nfrom a group. It returns NULL if there are no non-NULL values.\n\nThe maximum returned length in bytes is determined by the group_concat_max_len\nserver system variable, which defaults to 1M (>= MariaDB 10.2.4) or 1K (<=\nMariaDB 10.2.3).\n\nIf group_concat_max_len <= 512, the return type is VARBINARY or VARCHAR;\notherwise, the return type is BLOB or TEXT. The choice between binary or\nnon-binary types depends from the input.\n\nThe full syntax is as follows:\n\nGROUP_CONCAT([DISTINCT] expr [,expr ...]\n      [ORDER BY {unsigned_integer | col_name | expr}\n        [ASC | DESC] [,col_name ...]]\n      [SEPARATOR str_val]\n      [LIMIT {[offset,] row_count | row_count OFFSET offset}])\n\nDISTINCT eliminates duplicate values from the output string.\n\nORDER BY determines the order of returned values.\n\nSEPARATOR specifies a separator between the values. The default separator is a\ncomma (,). It is possible to avoid using a separator by specifying an empty\nstring.\n\nLIMIT\n-----\n\nMariaDB starting with 10.3.3\n----------------------------\nUntil MariaDB 10.3.2, it was not possible to use the LIMIT clause with\nGROUP_CONCAT. This restriction was lifted in MariaDB 10.3.3.\n\nExamples\n--------\n\nSELECT student_name,\n   GROUP_CONCAT(test_score)\n   FROM student\n   GROUP BY student_name;\n\nGet a readable list of MariaDB users from the mysql.user table:\n\nSELECT GROUP_CONCAT(DISTINCT User ORDER BY User SEPARATOR \'\\n\')\n FROM mysql.user;\n\nIn the former example, DISTINCT is used because the same user may occur more\nthan once. The new line (\\n) used as a SEPARATOR makes the results easier to\nread.\n\nGet a readable list of hosts from which each user can connect:\n\nSELECT User, GROUP_CONCAT(Host ORDER BY Host SEPARATOR \', \') \n FROM mysql.user GROUP BY User ORDER BY User;\n\nThe former example shows the difference between the GROUP_CONCAT\'s ORDER BY\n(which sorts the concatenated hosts), and the SELECT\'s ORDER BY (which sorts\nthe rows).\n\nFrom MariaDB 10.3.3, LIMIT can be used with GROUP_CONCAT, so, for example,\ngiven the following table:\n\nCREATE TABLE d (dd DATE, cc INT);\n\nINSERT INTO d VALUES (\'2017-01-01\',1);\nINSERT INTO d VALUES (\'2017-01-02\',2);\nINSERT INTO d VALUES (\'2017-01-04\',3);\n\nthe following query:\n\nSELECT SUBSTRING_INDEX(GROUP_CONCAT(CONCAT_WS(\":\",dd,cc) ORDER BY cc\nDESC),\",\",1) FROM d;\n+----------------------------------------------------------------------------+\n| SUBSTRING_INDEX(GROUP_CONCAT(CONCAT_WS(\":\",dd,cc) ORDER BY cc DESC),\",\",1) |\n+----------------------------------------------------------------------------+\n| 2017-01-04:3                                                               |\n+----------------------------------------------------------------------------+\n\ncan be more simply rewritten as:\n\nSELECT GROUP_CONCAT(CONCAT_WS(\":\",dd,cc) ORDER BY cc DESC LIMIT 1) FROM d;\n+-------------------------------------------------------------+\n| GROUP_CONCAT(CONCAT_WS(\":\",dd,cc) ORDER BY cc DESC LIMIT 1) |\n+-------------------------------------------------------------+\n| 2017-01-04:3                                                |\n+-------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/group_concat/','','https://mariadb.com/kb/en/group_concat/'),
(182,'MAX',16,'Syntax\n------\n\nMAX([DISTINCT] expr)\n\nDescription\n-----------\n\nReturns the largest, or maximum, value of expr. MAX() can also take a string\nargument in which case it returns the maximum string value. The DISTINCT\nkeyword can be used to find the maximum of the distinct values of expr,\nhowever, this produces the same result as omitting DISTINCT.\n\nNote that SET and ENUM fields are currently compared by their string value\nrather than their relative position in the set, so MAX() may produce a\ndifferent highest result than ORDER BY DESC.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nMAX() can be used as a window function.\n\nMAX() returns NULL if there were no matching rows.\n\nExamples\n--------\n\nCREATE TABLE student (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT name, MAX(score) FROM student GROUP BY name;\n+---------+------------+\n| name    | MAX(score) |\n+---------+------------+\n| Chun    |         75 |\n| Esben   |         43 |\n| Kaolin  |         88 |\n| Tatiana |         87 |\n+---------+------------+\n\nMAX string:\n\nSELECT MAX(name) FROM student;\n+-----------+\n| MAX(name) |\n+-----------+\n| Tatiana   |\n+-----------+\n\nBe careful to avoid this common mistake, not grouping correctly and returning\nmismatched data:\n\nSELECT name,test,MAX(SCORE) FROM student;\n+------+------+------------+\n| name | test | MAX(SCORE) |\n+------+------+------------+\n| Chun | SQL  |         88 |\n+------+------+------------+\n\nDifference between ORDER BY DESC and MAX():\n\nCREATE TABLE student2(name CHAR(10),grade ENUM(\'b\',\'c\',\'a\'));\n\nINSERT INTO student2 VALUES(\'Chun\',\'b\'),(\'Esben\',\'c\'),(\'Kaolin\',\'a\');\n\nSELECT MAX(grade) FROM student2;\n+------------+\n| MAX(grade) |\n+------------+\n| c          |\n+------------+\n\nSELECT grade FROM student2 ORDER BY grade DESC LIMIT 1;\n+-------+\n| grade |\n+-------+\n| a     |\n+-------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, MAX(score) \n OVER (PARTITION BY name) AS highest_score FROM student_test;\n+---------+--------+-------+---------------+\n| name    | test   | score | highest_score |\n+---------+--------+-------+---------------+\n| Chun    | SQL    |    75 |            75 |\n| Chun    | Tuning |    73 |            75 |\n| Esben   | SQL    |    43 |            43 |\n| Esben   | Tuning |    31 |            43 |\n| Kaolin  | SQL    |    56 |            88 |\n| Kaolin  | Tuning |    88 |            88 |\n| Tatiana | SQL    |    87 |            87 |\n+---------+--------+-------+---------------+\n\nURL: https://mariadb.com/kb/en/max/','','https://mariadb.com/kb/en/max/'),
(183,'MIN',16,'Syntax\n------\n\nMIN([DISTINCT] expr)\n\nDescription\n-----------\n\nReturns the minimum value of expr. MIN() may take a string argument, in which\ncase it returns the minimum string value. The DISTINCT keyword can be used to\nfind the minimum of the distinct values of expr, however, this produces the\nsame result as omitting DISTINCT.\n\nNote that SET and ENUM fields are currently compared by their string value\nrather than their relative position in the set, so MIN() may produce a\ndifferent lowest result than ORDER BY ASC.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nMIN() can be used as a window function.\n\nMIN() returns NULL if there were no matching rows.\n\nExamples\n--------\n\nCREATE TABLE student (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT name, MIN(score) FROM student GROUP BY name;\n+---------+------------+\n| name    | MIN(score) |\n+---------+------------+\n| Chun    |         73 |\n| Esben   |         31 |\n| Kaolin  |         56 |\n| Tatiana |         83 |\n+---------+------------+\n\nMIN() with a string:\n\nSELECT MIN(name) FROM student;\n+-----------+\n| MIN(name) |\n+-----------+\n| Chun      |\n+-----------+\n\nBe careful to avoid this common mistake, not grouping correctly and returning\nmismatched data:\n\nSELECT name,test,MIN(score) FROM student;\n+------+------+------------+\n| name | test | MIN(score) |\n+------+------+------------+\n| Chun | SQL  |         31 |\n+------+------+------------+\n\nDifference between ORDER BY ASC and MIN():\n\nCREATE TABLE student2(name CHAR(10),grade ENUM(\'b\',\'c\',\'a\'));\n\nINSERT INTO student2 VALUES(\'Chun\',\'b\'),(\'Esben\',\'c\'),(\'Kaolin\',\'a\');\n\nSELECT MIN(grade) FROM student2;\n+------------+\n| MIN(grade) |\n+------------+\n| a          |\n+------------+\n\nSELECT grade FROM student2 ORDER BY grade ASC LIMIT 1;\n+-------+\n| grade |\n+-------+\n| b     |\n+-------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, MIN(score) \n OVER (PARTITION BY name) AS lowest_score FROM student_test;\n+---------+--------+-------+--------------+\n| name    | test   | score | lowest_score |\n+---------+--------+-------+--------------+\n| Chun    | SQL    |    75 |           73 |\n| Chun    | Tuning |    73 |           73 |\n| Esben   | SQL    |    43 |           31 |\n| Esben   | Tuning |    31 |           31 |\n| Kaolin  | SQL    |    56 |           56 |\n| Kaolin  | Tuning |    88 |           56 |\n| Tatiana | SQL    |    87 |           87 |\n+---------+--------+-------+--------------+\n\nURL: https://mariadb.com/kb/en/min/','','https://mariadb.com/kb/en/min/'),
(184,'STD',16,'Syntax\n------\n\nSTD(expr)\n\nDescription\n-----------\n\nReturns the population standard deviation of expr. This is an extension to\nstandard SQL. The standard SQL function STDDEV_POP() can be used instead.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nSTD() can be used as a window function.\n\nThis function returns NULL if there were no matching rows.\n\nExamples\n--------\n\nAs an aggregate function:\n\nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n\nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n\nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a        |        0.8165 |         1.0000 |     0.6667 |\n| b        |       18.0400 |        20.1693 |   325.4400 |\n+----------+---------------+----------------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, STDDEV_POP(score) \n OVER (PARTITION BY test) AS stddev_results FROM student_test;\n+---------+--------+-------+----------------+\n| name    | test   | score | stddev_results |\n+---------+--------+-------+----------------+\n| Chun    | SQL    |    75 |        16.9466 |\n| Chun    | Tuning |    73 |        24.1247 |\n| Esben   | SQL    |    43 |        16.9466 |\n| Esben   | Tuning |    31 |        24.1247 |\n| Kaolin  | SQL    |    56 |        16.9466 |\n| Kaolin  | Tuning |    88 |        24.1247 |\n| Tatiana | SQL    |    87 |        16.9466 |\n+---------+--------+-------+----------------+\n\nURL: https://mariadb.com/kb/en/std/','','https://mariadb.com/kb/en/std/'),
(325,'MULTILINESTRING',25,'Syntax\n------\n\nMultiLineString(ls1,ls2,...)\n\nDescription\n-----------\n\nConstructs a WKB MultiLineString value using WKB LineString arguments. If any\nargument is not a WKB LineString, the return value is NULL.\n\nExample\n-------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nINSERT INTO gis_multi_line VALUES\n (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16 23,16\n48))\')),\n (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n (MLineFromWKB(AsWKB(MultiLineString(LineString(Point(1, 2), \n  Point(3, 5)), LineString(Point(2, 5),Point(5, 8),Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/multilinestring/','','https://mariadb.com/kb/en/multilinestring/'),
(326,'MULTIPOINT',25,'Syntax\n------\n\nMultiPoint(pt1,pt2,...)\n\nDescription\n-----------\n\nConstructs a WKB MultiPoint value using WKB Point arguments. If any argument\nis not a WKB Point, the return value is NULL.\n\nExamples\n--------\n\nSET @g = ST_GEOMFROMTEXT(\'MultiPoint( 1 1, 2 2, 5 3, 7 2, 9 3, 8 4, 6 6, 6 9,\n4 9, 1 5 )\');\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/multipoint/','','https://mariadb.com/kb/en/multipoint/'),
(328,'POINT',25,'Syntax\n------\n\nPoint(x,y)\n\nDescription\n-----------\n\nConstructs a WKB Point using the given coordinates.\n\nExamples\n--------\n\nSET @g = ST_GEOMFROMTEXT(\'Point(1 1)\');\n\nCREATE TABLE gis_point  (g POINT);\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/point/','','https://mariadb.com/kb/en/point/'),
(329,'PointOnSurface',25,'A synonym for ST_PointOnSurface.\n\nURL: https://mariadb.com/kb/en/pointonsurface/','','https://mariadb.com/kb/en/pointonsurface/'),
(333,'ST_INTERSECTION',25,'Syntax\n------\n\nST_INTERSECTION(g1,g2)\n\nDescription\n-----------\n\nReturns a geometry that is the intersection, or shared portion, of geometry g1\nand geometry g2.\n\nExamples\n--------\n\nSET @g1 = ST_GEOMFROMTEXT(\'POINT(2 1)\');\n\nSET @g2 = ST_GEOMFROMTEXT(\'LINESTRING(2 1, 0 2)\');\n\nSELECT ASTEXT(ST_INTERSECTION(@g1,@g2));\n+----------------------------------+\n| ASTEXT(ST_INTERSECTION(@g1,@g2)) |\n+----------------------------------+\n| POINT(2 1)                       |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/st_intersection/','','https://mariadb.com/kb/en/st_intersection/'),
(185,'STDDEV',16,'Syntax\n------\n\nSTDDEV(expr)\n\nDescription\n-----------\n\nReturns the population standard deviation of expr. This function is provided\nfor compatibility with Oracle. The standard SQL function STDDEV_POP() can be\nused instead.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nSTDDEV() can be used as a window function.\n\nThis function returns NULL if there were no matching rows.\n\nExamples\n--------\n\nAs an aggregate function:\n\nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n\nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n\nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a        |        0.8165 |         1.0000 |     0.6667 |\n| b        |       18.0400 |        20.1693 |   325.4400 |\n+----------+---------------+----------------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, STDDEV_POP(score) \n OVER (PARTITION BY test) AS stddev_results FROM student_test;\n+---------+--------+-------+----------------+\n| name    | test   | score | stddev_results |\n+---------+--------+-------+----------------+\n| Chun    | SQL    |    75 |        16.9466 |\n| Chun    | Tuning |    73 |        24.1247 |\n| Esben   | SQL    |    43 |        16.9466 |\n| Esben   | Tuning |    31 |        24.1247 |\n| Kaolin  | SQL    |    56 |        16.9466 |\n| Kaolin  | Tuning |    88 |        24.1247 |\n| Tatiana | SQL    |    87 |        16.9466 |\n+---------+--------+-------+----------------+\n\nURL: https://mariadb.com/kb/en/stddev/','','https://mariadb.com/kb/en/stddev/'),
(186,'STDDEV_POP',16,'Syntax\n------\n\nSTDDEV_POP(expr)\n\nDescription\n-----------\n\nReturns the population standard deviation of expr (the square root of\nVAR_POP()). You can also use STD() or STDDEV(), which are equivalent but not\nstandard SQL.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nSTDDEV_POP() can be used as a window function.\n\nSTDDEV_POP() returns NULL if there were no matching rows.\n\nExamples\n--------\n\nAs an aggregate function:\n\nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n\nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n\nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a        |        0.8165 |         1.0000 |     0.6667 |\n| b        |       18.0400 |        20.1693 |   325.4400 |\n+----------+---------------+----------------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, STDDEV_POP(score) \n OVER (PARTITION BY test) AS stddev_results FROM student_test;\n+---------+--------+-------+----------------+\n| name    | test   | score | stddev_results |\n+---------+--------+-------+----------------+\n| Chun    | SQL    |    75 |        16.9466 |\n| Chun    | Tuning |    73 |        24.1247 |\n| Esben   | SQL    |    43 |        16.9466 |\n| Esben   | Tuning |    31 |        24.1247 |\n| Kaolin  | SQL    |    56 |        16.9466 |\n| Kaolin  | Tuning |    88 |        24.1247 |\n| Tatiana | SQL    |    87 |        16.9466 |\n+---------+--------+-------+----------------+\n\nURL: https://mariadb.com/kb/en/stddev_pop/','','https://mariadb.com/kb/en/stddev_pop/'),
(188,'SUM',16,'Syntax\n------\n\nSUM([DISTINCT] expr)\n\nDescription\n-----------\n\nReturns the sum of expr. If the return set has no rows, SUM() returns NULL.\nThe DISTINCT keyword can be used to sum only the distinct values of expr.\n\nSUM() can be used as a window function, although not with the DISTINCT\nspecifier.\n\nExamples\n--------\n\nCREATE TABLE sales (sales_value INT);\nINSERT INTO sales VALUES(10),(20),(20),(40);\n\nSELECT SUM(sales_value) FROM sales;\n+------------------+\n| SUM(sales_value) |\n+------------------+\n|               90 |\n+------------------+\n\nSELECT SUM(DISTINCT(sales_value)) FROM sales;\n+----------------------------+\n| SUM(DISTINCT(sales_value)) |\n+----------------------------+\n|                         70 |\n+----------------------------+\n\nCommonly, SUM is used with a GROUP BY clause:\n\nCREATE TABLE sales (name CHAR(10), month CHAR(10), units INT);\n\nINSERT INTO sales VALUES \n (\'Chun\', \'Jan\', 75), (\'Chun\', \'Feb\', 73),\n (\'Esben\', \'Jan\', 43), (\'Esben\', \'Feb\', 31),\n (\'Kaolin\', \'Jan\', 56), (\'Kaolin\', \'Feb\', 88),\n (\'Tatiana\', \'Jan\', 87), (\'Tatiana\', \'Feb\', 83);\n\nSELECT name, SUM(units) FROM sales GROUP BY name;\n+---------+------------+\n| name    | SUM(units) |\n+---------+------------+\n| Chun    |        148 |\n| Esben   |         74 |\n| Kaolin  |        144 |\n| Tatiana |        170 |\n+---------+------------+\n\nThe GROUP BY clause is required when using an aggregate function along with\nregular column data, otherwise the result will be a mismatch, as in the\nfollowing common type of mistake:\n\nSELECT name,SUM(units) FROM sales\n;+------+------------+\n| name | SUM(units) |\n+------+------------+\n| Chun |        536 |\n+------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, SUM(score) OVER (PARTITION BY name) AS total_score\nFROM student_test;\n+---------+--------+-------+-------------+\n| name    | test   | score | total_score |\n+---------+--------+-------+-------------+\n| Chun    | SQL    |    75 |         148 |\n| Chun    | Tuning |    73 |         148 |\n| Esben   | SQL    |    43 |          74 |\n| Esben   | Tuning |    31 |          74 |\n| Kaolin  | SQL    |    56 |         144 |\n| Kaolin  | Tuning |    88 |         144 |\n| Tatiana | SQL    |    87 |          87 |\n+---------+--------+-------+-------------+\n\nURL: https://mariadb.com/kb/en/sum/','','https://mariadb.com/kb/en/sum/'),
(334,'ST_POINTONSURFACE',25,'MariaDB starting with 10.1.2\n----------------------------\nST_POINTONSURFACE() was introduced in MariaDB 10.1.2\n\nSyntax\n------\n\nST_PointOnSurface(g)\nPointOnSurface(g)\n\nDescription\n-----------\n\nGiven a geometry, returns a POINT guaranteed to intersect a surface. However,\nsee MDEV-7514.\n\nST_PointOnSurface() and PointOnSurface() are synonyms.\n\nURL: https://mariadb.com/kb/en/st_pointonsurface/','','https://mariadb.com/kb/en/st_pointonsurface/'),
(345,'FLUSH',26,'Syntax\n------\n\nFLUSH [NO_WRITE_TO_BINLOG | LOCAL]\n  flush_option [, flush_option] ...\n\nor when flushing tables:\n\nFLUSH [NO_WRITE_TO_BINLOG | LOCAL] TABLES [table_list]  [table_flush_option]\n\nwhere table_list is a list of tables separated by , (comma).\n\nDescription\n-----------\n\nThe FLUSH statement clears or reloads various internal caches used by MariaDB.\nTo execute FLUSH, you must have the RELOAD privilege. See GRANT.\n\nThe RESET statement is similar to FLUSH. See RESET.\n\nYou cannot issue a FLUSH statement from within a stored function or a trigger.\nDoing so within a stored procedure is permitted, as long as it is not called\nby a stored function or trigger. See Stored Routine Limitations, Stored\nFunction Limitations and Trigger Limitations.\n\nIf a listed table is a view, an error like the following will be produced:\n\nERROR 1347 (HY000): \'test.v\' is not BASE TABLE\n\nBy default, FLUSH statements are written to the binary log and will be\nreplicated. The NO_WRITE_TO_BINLOG keyword (LOCAL is an alias) will ensure the\nstatement is not written to the binary log.\n\nThe different flush options are:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| CHANGED_PAGE_BITMAPS      | XtraDB only. Internal command used for backup  |\n|                           | purposes. See the Information Schema           |\n|                           | CHANGED_PAGE_BITMAPS Table.                    |\n+---------------------------+------------------------------------------------+\n| CLIENT_STATISTICS         | Reset client statistics (see SHOW              |\n|                           | CLIENT_STATISTICS).                            |\n+---------------------------+------------------------------------------------+\n| DES_KEY_FILE              | Reloads the DES key file (Specified with the   |\n|                           | --des-key-file startup option).                |\n+---------------------------+------------------------------------------------+\n| HOSTS                     | Flush the hostname cache (used for converting  |\n|                           | ip to host names and for unblocking blocked    |\n|                           | hosts. See max_connect_errors and              |\n|                           | performance_schema.host_cache                  |\n+---------------------------+------------------------------------------------+\n| INDEX_STATISTICS          | Reset index statistics (see SHOW               |\n|                           | INDEX_STATISTICS).                             |\n+---------------------------+------------------------------------------------+\n| [ERROR | ENGINE |         | Close and reopen the specified log type, or    |\n| GENERAL | SLOW | BINARY   | all log types if none are specified. FLUSH     |\n| | RELAY] LOGS             | RELAY LOGS [connection-name] can be used to    |\n|                           | flush the relay logs for a specific            |\n|                           | connection. Only one connection can be         |\n|                           | specified per FLUSH command. See Multi-source  |\n|                           | replication. FLUSH ENGINE LOGS will delete     |\n|                           | all unneeded Aria redo logs. FLUSH BINARY      |\n|                           | LOGS DELETE_DOMAIN_ID=(list-of-domains) can    |\n|                           | be used to discard obsolete GTID domains from  |\n|                           | the server\'s binary log state. In order for    |\n|                           | this to be successful, no event group from     |\n|                           | the listed GTID domains can be present in      |\n|                           | existing binary log files. If some still       |\n|                           | exist, then they must be purged prior to       |\n|                           | executing this command. If the command         |\n|                           | completes successfully, then it also rotates   |\n|                           | the binary log.                                |\n+---------------------------+------------------------------------------------+\n| MASTER                    | Deprecated option, use RESET MASTER instead.   |\n+---------------------------+------------------------------------------------+\n| PRIVILEGES                | Reload all privileges from the privilege       |\n|                           | tables in the mysql database. If the server    |\n|                           | is started with --skip-grant-table option,     |\n|                           | this will activate the privilege tables again. |\n+---------------------------+------------------------------------------------+\n| QUERY CACHE               | Defragment the query cache to better utilize   |\n|                           | its memory. If you want to reset the query     |\n|                           | cache, you can do it with RESET QUERY CACHE.   |\n+---------------------------+------------------------------------------------+\n| QUERY_RESPONSE_TIME       | See the QUERY_RESPONSE_TIME plugin.            |\n+---------------------------+------------------------------------------------+\n| SLAVE                     | Deprecated option, use RESET REPLICA or RESET  |\n|                           | SLAVE instead.                                 |\n+---------------------------+------------------------------------------------+\n| SSL                       | Used to dynamically reinitialize the server\'s  |\n|                           | TLS context by reloading the files defined by  |\n|                           | several TLS system variables. See FLUSH SSL    |\n|                           | for more information.                          |\n+---------------------------+------------------------------------------------+\n| STATUS                    | Resets all server status variables that can    |\n|                           | be reset to 0. Not all global status           |\n|                           | variables support this, so not all global      |\n|                           | values are reset. See FLUSH STATUS for more    |\n|                           | information.                                   |\n+---------------------------+------------------------------------------------+\n| TABLE                     | Close tables given as options or all open      |\n|                           | tables if no table list was used. From         |\n|                           | MariaDB 10.4.1, using without any table list   |\n|                           | will only close tables not in use, and tables  |\n|                           | not locked by the FLUSH TABLES connection. If  |\n|                           | there are no locked tables, FLUSH TABLES will  |\n|                           | be instant and will not cause any waits, as    |\n|                           | it no longer waits for tables in use. When a   |\n|                           | table list is provided, from MariaDB 10.4.1,   |\n|                           | the server will wait for the end of any        |\n|                           | transactions that are using the tables.        |\n|                           | Previously, FLUSH TABLES only waited for the   |\n|                           | statements to complete.                        |\n+---------------------------+------------------------------------------------+\n| TABLES                    | Same as FLUSH TABLE.                           |\n+---------------------------+------------------------------------------------+\n| TABLES ... FOR EXPORT     | For InnoDB tables, flushes table changes to    |\n|                           | disk to permit binary table copies while the   |\n|                           | server is running. See FLUSH TABLES ... FOR    |\n|                           | EXPORT for more.                               |\n+---------------------------+------------------------------------------------+\n| TABLES WITH READ LOCK     | Closes all open tables. New tables are only    |\n|                           | allowed to be opened with read locks until an  |\n|                           | UNLOCK TABLES is given.                        |\n+---------------------------+------------------------------------------------+\n| TABLES WITH READ LOCK     | As TABLES WITH READ LOCK but also disable all  |\n| AND DISABLE CHECKPOINT    | checkpoint writes by transactional table       |\n|                           | engines. This is useful when doing a disk      |\n|                           | snapshot of all tables.                        |\n+---------------------------+------------------------------------------------+\n| TABLE_STATISTICS          | Reset table statistics (see SHOW               |\n|                           | TABLE_STATISTICS).                             |\n+---------------------------+------------------------------------------------+\n| USER_RESOURCES            | Resets all per hour user resources. This       |\n|                           | enables clients that have exhausted their      |\n|                           | resources to connect again.                    |\n+---------------------------+------------------------------------------------+\n| USER_STATISTICS           | Reset user statistics (see SHOW                |\n|                           | USER_STATISTICS).                              |\n+---------------------------+------------------------------------------------+\n| USER_VARIABLES            | Reset user variables (see User-defined         |\n|                           | variables).                                    |\n+---------------------------+------------------------------------------------+\n\nYou can also use the mariadb-admin client to flush things. Use mariadb-admin\n--help to examine what flush commands it supports.\n\nFLUSH RELAY LOGS\n----------------\n\nFLUSH RELAY LOGS \'connection_name\';\n\nCompatibility with MySQL\n------------------------\n\nMariaDB starting with 10.7.0\n----------------------------\nThe FOR CHANNEL keyword was added for MySQL compatibility. This is identical\nas using the channel_name directly after the FLUSH command.\n\nFor example, one can now use:\n\nFLUSH RELAY LOGS FOR CHANNEL \'connection_name\';\n\nFLUSH STATUS\n------------\n\nServer status variables can be reset by executing the following:\n\nFLUSH STATUS;\n\nGlobal Status Variables that Support FLUSH STATUS\n-------------------------------------------------\n\nNot all global status variables support being reset by FLUSH STATUS.\nCurrently, the following status variables are reset by FLUSH STATUS:\n\n* Aborted_clients\n* Aborted_connects\n* Binlog_cache_disk_use\n* Binlog_cache_use\n* Binlog_stmt_cache_disk_use\n* Binlog_stmt_cache_use\n* Connection_errors_accept\n* Connection_errors_internal\n* Connection_errors_max_connections\n* Connection_errors_peer_address\n* Connection_errors_select\n* Connection_errors_tcpwrap\n* Created_tmp_files\n* Delayed_errors\n* Delayed_writes\n* Feature_check_constraint\n* Feature_delay_key_write\n* Max_used_connections\n* Opened_plugin_libraries\n* Performance_schema_accounts_lost\n* Performance_schema_cond_instances_lost\n* Performance_schema_digest_lost\n* Performance_schema_file_handles_lost\n* Performance_schema_file_instances_lost\n* Performance_schema_hosts_lost\n* Performance_schema_locker_lost\n* Performance_schema_mutex_instances_lost\n* Performance_schema_rwlock_instances_lost\n* Performance_schema_session_connect_attrs_lost\n* Performance_schema_socket_instances_lost\n* Performance_schema_stage_classes_lost\n* Performance_schema_statement_classes_lost\n* Performance_schema_table_handles_lost\n* Performance_schema_table_instances_lost\n* Performance_schema_thread_instances_lost\n* Performance_schema_users_lost\n* Qcache_hits\n* Qcache_inserts\n* Qcache_lowmem_prunes\n* Qcache_not_cached\n* Rpl_semi_sync_master_no_times\n* Rpl_semi_sync_master_no_tx\n* Rpl_semi_sync_master_timefunc_failures\n* Rpl_semi_sync_master_wait_pos_backtraverse\n* Rpl_semi_sync_master_yes_tx\n* Rpl_transactions_multi_engine\n* Server_audit_writes_failed\n* Slave_retried_transactions\n* Slow_launch_threads\n* Ssl_accept_renegotiates\n* Ssl_accepts\n* Ssl_callback_cache_hits\n* Ssl_client_connects\n* Ssl_connect_renegotiates\n* Ssl_ctx_verify_depth\n* Ssl_ctx_verify_mode\n* Ssl_finished_accepts\n* Ssl_finished_connects\n* Ssl_session_cache_hits\n* Ssl_session_cache_misses\n* Ssl_session_cache_overflows\n* Ssl_session_cache_size\n* Ssl_session_cache_timeouts\n* Ssl_sessions_reused\n* Ssl_used_session_cache_entries\n* Subquery_cache_hit\n* Subquery_cache_miss\n* Table_locks_immediate\n* Table_locks_waited\n* Tc_log_max_pages_used\n* Tc_log_page_waits\n* Transactions_gtid_foreign_engine\n* Transactions_multi_engine\n\nThe different usage of FLUSH TABLES\n-----------------------------------\n\nThe purpose of FLUSH TABLES\n---------------------------\n\nThe purpose of FLUSH TABLES is to clean up the open table cache and table\ndefinition cache from not in use tables. This frees up memory and file\ndescriptors. Normally this is not needed as the caches works on a FIFO bases,\nbut can be useful if the server seams to use up to much memory for some reason.\n\nThe purpose of FLUSH TABLES WITH READ LOCK \n-------------------------------------------\n\nFLUSH TABLES WITH READ LOCK is useful if you want to take a backup of some\ntables. When FLUSH TABLES WITH READ LOCK returns, all write access to tables\nare blocked and all tables are marked as \'properly closed\' on disk. The tables\ncan still be used for read operations.\n\nThe purpose of FLUSH TABLES table_list\n--------------------------------------\n\nFLUSH TABLES table_list is useful if you want to copy a table object/files to\nor from the server. This command puts a lock that stops new users of the table\nand will wait until everyone has stopped using the table. The table is then\nremoved from the table definition and table cache.\n\nNote that it\'s up to the user to ensure that no one is accessing the table\nbetween FLUSH TABLES and the table is copied to or from the server. This can\nbe secured by using LOCK TABLES.\n\nIf there are any tables locked by the connection that is using FLUSH TABLES\nall the locked tables will be closed as part of the flush and reopened and\nrelocked before FLUSH TABLES returns. This allows one to copy the table after\nFLUSH TABLES returns without having any writes on the table. For now this\nworks works with most tables, except InnoDB as InnoDB may do background purges\non the table even while it\'s write locked.\n\nThe purpose of FLUSH TABLES table_list WITH READ LOCK\n-----------------------------------------------------\n\nFLUSH TABLES table_list WITH READ LOCK should work as FLUSH TABLES WITH READ\nLOCK, but only those tables that are listed will be properly closed. However\nin practice this works exactly like FLUSH TABLES WITH READ LOCK as the FLUSH\ncommand has anyway to wait for all WRITE operations to end because we are\ndepending on a global read lock for this code. In the future we should\nconsider fixing this to instead use meta data locks.\n\nImplementation of FLUSH TABLES commands in MariaDB 10.4.8 and above\n-------------------------------------------------------------------\n\nImplementation of FLUSH TABLES\n------------------------------\n\n* Free memory and file descriptors not in use\n\nImplementation of FLUSH TABLES WITH READ LOCK\n---------------------------------------------\n\n* Lock all tables read only for simple old style backup.\n* All background writes are suspended and tables are marked as closed.\n* No statement requiring table changes are allowed for any user until UNLOCK\nTABLES.\n\nInstead of using FLUSH TABLE WITH READ LOCK one should in most cases instead\nuse BACKUP STAGE BLOCK_COMMIT.\n\nImplementation of FLUSH TABLES table_list\n-----------------------------------------\n\n* Free memory and file descriptors for tables not in use from table list.\n* Lock given tables as read only.\n* Wait until all translations has ended that uses any of the given tables.\n* Wait until all background writes are suspended and tables are marked as\nclosed.\n\nImplementation of FLUSH TABLES table_list FOR EXPORT\n----------------------------------------------------\n\n* Free memory and file descriptors for tables not in use from table list\n* Lock given tables as read.\n* Wait until all background writes are suspended and tables are marked as\nclosed.\n* Check that all tables supports FOR EXPORT\n* No changes to these tables allowed until UNLOCK TABLES\n\nThis is basically the same behavior as in old MariaDB version if one first\nlock the tables, then do FLUSH TABLES. The tables will be copyable until\nUNLOCK TABLES.\n\nFLUSH SSL\n---------\n\nMariaDB starting with 10.4\n--------------------------\nThe FLUSH SSL command was first added in MariaDB 10.4.\n\nIn MariaDB 10.4 and later, the FLUSH SSL command can be used to dynamically\nreinitialize the server\'s TLS context. This is most useful if you need to\nreplace a certificate that is about to expire without restarting the server.\n\nThis operation is performed by reloading the files defined by the following\nTLS system variables:\n\n* ssl_cert\n* ssl_key\n* ssl_ca\n* ssl_capath\n* ssl_crl\n* ssl_crlpath\n\nThese TLS system variables are not dynamic, so their values can not be changed\nwithout restarting the server.\n\nIf you want to dynamically reinitialize the server\'s TLS context, then you\nneed to change the certificate and key files at the relevant paths defined by\nthese TLS system variables, without actually changing the values of the\nvariables. See MDEV-19341 for more information.\n\nReducing Memory Usage\n---------------------\n\nTo flush some of the global caches that take up memory, you could execute the\nfollowing command:\n\nFLUSH LOCAL HOSTS,\n QUERY CACHE,\n TABLE_STATISTICS,\n INDEX_STATISTICS,\n USER_STATISTICS;\n\nURL: https://mariadb.com/kb/en/flush/','','https://mariadb.com/kb/en/flush/'),
(346,'FLUSH QUERY CACHE',26,'Description\n-----------\n\nYou can defragment the query cache to better utilize its memory with the FLUSH\nQUERY CACHE statement. The statement does not remove any queries from the\ncache.\n\nThe RESET QUERY CACHE statement removes all query results from the query\ncache. The FLUSH TABLES statement also does this.\n\nURL: https://mariadb.com/kb/en/flush-query-cache/','','https://mariadb.com/kb/en/flush-query-cache/'),
(189,'VARIANCE',16,'Syntax\n------\n\nVARIANCE(expr)\n\nDescription\n-----------\n\nReturns the population standard variance of expr. This is an extension to\nstandard SQL. The standard SQL function VAR_POP() can be used instead.\n\nVariance is calculated by\n\n* working out the mean for the set\n* for each number, subtracting the mean and squaring the result\n* calculate the average of the resulting differences\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nVARIANCE() can be used as a window function.\n\nVARIANCE() returns NULL if there were no matching rows.\n\nExamples\n--------\n\nCREATE TABLE v(i tinyint);\n\nINSERT INTO v VALUES(101),(99);\n\nSELECT VARIANCE(i) FROM v;\n+-------------+\n| VARIANCE(i) |\n+-------------+\n|      1.0000 |\n+-------------+\n\nINSERT INTO v VALUES(120),(80);\n\nSELECT VARIANCE(i) FROM v;\n+-------------+\n| VARIANCE(i) |\n+-------------+\n|    200.5000 |\n+-------------+\n\nAs an aggregate function:\n\nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n\nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n\nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a        |        0.8165 |         1.0000 |     0.6667 |\n| b        |       18.0400 |        20.1693 |   325.4400 |\n+----------+---------------+----------------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, VAR_POP(score) \n OVER (PARTITION BY test) AS variance_results FROM student_test;\n+---------+--------+-------+------------------+\n| name    | test   | score | variance_results |\n+---------+--------+-------+------------------+\n| Chun    | SQL    |    75 |         287.1875 |\n| Chun    | Tuning |    73 |         582.0000 |\n| Esben   | SQL    |    43 |         287.1875 |\n| Esben   | Tuning |    31 |         582.0000 |\n| Kaolin  | SQL    |    56 |         287.1875 |\n| Kaolin  | Tuning |    88 |         582.0000 |\n| Tatiana | SQL    |    87 |         287.1875 |\n+---------+--------+-------+------------------+\n\nURL: https://mariadb.com/kb/en/variance/','','https://mariadb.com/kb/en/variance/'),
(190,'VAR_POP',16,'Syntax\n------\n\nVAR_POP(expr)\n\nDescription\n-----------\n\nReturns the population standard variance of expr. It considers rows as the\nwhole population, not as a sample, so it has the number of rows as the\ndenominator. You can also use VARIANCE(), which is equivalent but is not\nstandard SQL.\n\nVariance is calculated by\n\n* working out the mean for the set\n* for each number, subtracting the mean and squaring the result\n* calculate the average of the resulting differences\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nVAR_POP() can be used as a window function.\n\nVAR_POP() returns NULL if there were no matching rows.\n\nExamples\n--------\n\nCREATE TABLE v(i tinyint);\n\nINSERT INTO v VALUES(101),(99);\n\nSELECT VAR_POP(i) FROM v;\n+------------+\n| VAR_POP(i) |\n+------------+\n|     1.0000 |\n+------------+\n\nINSERT INTO v VALUES(120),(80);\n\nSELECT VAR_POP(i) FROM v;\n+------------+\n| VAR_POP(i) |\n+------------+\n|   200.5000 |\n+------------+\n\nAs an aggregate function:\n\nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n\nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n\nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a        |        0.8165 |         1.0000 |     0.6667 |\n| b        |       18.0400 |        20.1693 |   325.4400 |\n+----------+---------------+----------------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, VAR_POP(score) \n OVER (PARTITION BY test) AS variance_results FROM student_test;\n+---------+--------+-------+------------------+\n| name    | test   | score | variance_results |\n+---------+--------+-------+------------------+\n| Chun    | SQL    |    75 |         287.1875 |\n| Esben   | SQL    |    43 |         287.1875 |\n| Kaolin  | SQL    |    56 |         287.1875 |\n| Tatiana | SQL    |    87 |         287.1875 |\n| Chun    | Tuning |    73 |         582.0000 |\n| Esben   | Tuning |    31 |         582.0000 |\n| Kaolin  | Tuning |    88 |         582.0000 |\n+---------+--------+-------+------------------+\n\nURL: https://mariadb.com/kb/en/var_pop/','','https://mariadb.com/kb/en/var_pop/'),
(349,'SHOW SLAVE STATUS',26,'Syntax\n------\n\nSHOW SLAVE [\"connection_name\"] STATUS [FOR CHANNEL \"connection_name\"]\nSHOW REPLICA [\"connection_name\"] STATUS -- From MariaDB 10.5.1\n\nor\n\nSHOW ALL SLAVES STATUS\nSHOW ALL REPLICAS STATUS -- From MariaDB 10.5.1\n\nDescription\n-----------\n\nThis statement is to be run on a replica and provides status information on\nessential parameters of the replica threads.\n\nThis statement requires the SUPER privilege, the REPLICATION_CLIENT privilege,\nor, from MariaDB 10.5.2, the REPLICATION SLAVE ADMIN privilege, or, from\nMariaDB 10.5.9, the REPLICA MONITOR privilege.\n\nMulti-Source\n------------\n\nThe ALL and \"connection_name\" options allow you to connect to many primaries\nat the same time.\n\nALL SLAVES (or ALL REPLICAS from MariaDB 10.5.1) gives you a list of all\nconnections to the primary nodes.\n\nThe rows will be sorted according to Connection_name.\n\nIf you specify a connection_name, you only get the information about that\nconnection. If connection_name is not used, then the name set by\ndefault_master_connection is used. If the connection name doesn\'t exist you\nwill get an error: There is no master connection for \'xxx\'.\n\nMariaDB starting with 10.7.0\n----------------------------\nThe FOR CHANNEL keyword was added for MySQL compatibility. This is identical\nto using the channel_name directly after SHOW SLAVE.\n\nColumn Descriptions\n-------------------\n\n+---------------------+------------------------------------------------------+\n| Name                | Description                                          |\n+---------------------+------------------------------------------------------+\n| Connection_name     | Name of the primary connection. Returned with SHOW   |\n|                     | ALL SLAVES STATUS (or SHOW ALL REPLICAS STATUS from  |\n|                     | MariaDB 10.5.1) only.                                |\n+---------------------+------------------------------------------------------+\n| Slave_SQL_State     | State of SQL thread. Returned with SHOW ALL SLAVES   |\n|                     | STATUS (or SHOW ALL REPLICAS STATUS from MariaDB     |\n|                     | 10.5.1) only. See Slave SQL Thread States.           |\n+---------------------+------------------------------------------------------+\n| Slave_IO_State      | State of I/O thread. See Slave I/O Thread States.    |\n+---------------------+------------------------------------------------------+\n| Master_host         | Master host that the replica is connected to.        |\n+---------------------+------------------------------------------------------+\n| Master_user         | Account user name being used to connect to the       |\n|                     | primary.                                             |\n+---------------------+------------------------------------------------------+\n| Master_port         | The port being used to connect to the primary.       |\n+---------------------+------------------------------------------------------+\n| Connect_Retry       | Time in seconds between retries to connect. The      |\n|                     | default is 60. The CHANGE MASTER TO statement can    |\n|                     | set this. The master-retry-count option determines   |\n|                     | the maximum number of reconnection attempts.         |\n+---------------------+------------------------------------------------------+\n| Master_Log_File     | Name of the primary binary log file that the I/O     |\n|                     | thread is currently reading from.                    |\n+---------------------+------------------------------------------------------+\n| Read_Master_Log_Pos | Position up to which the I/O thread has read in the  |\n|                     | current primary binary log file.                     |\n+---------------------+------------------------------------------------------+\n| Relay_Log_File      | Name of the relay log file that the SQL thread is    |\n|                     | currently processing.                                |\n+---------------------+------------------------------------------------------+\n| Relay_Log_Pos       | Position up to which the SQL thread has finished     |\n|                     | processing in the current relay log file.            |\n+---------------------+------------------------------------------------------+\n| Relay_Master_Log_Fi | Name of the primary binary log file that contains    |\n| e                   | the most recent event executed by the SQL thread.    |\n+---------------------+------------------------------------------------------+\n| Slave_IO_Running    | Whether the replica I/O thread is running and        |\n|                     | connected (Yes), running but not connected to a      |\n|                     | primary (Connecting) or not running (No).            |\n+---------------------+------------------------------------------------------+\n| Slave_SQL_Running   | Whether or not the SQL thread is running.            |\n+---------------------+------------------------------------------------------+\n| Replicate_Rewrite_D | Databases specified for replicating  and rewriting   |\n|                     | with the replicate_rewrite_db option. Added in       |\n|                     | MariaDB 10.11                                        |\n+---------------------+------------------------------------------------------+\n| Replicate_Do_DB     | Databases specified for replicating with the         |\n|                     | replicate_do_db option.                              |\n+---------------------+------------------------------------------------------+\n| Replicate_Ignore_DB | Databases specified for ignoring with the            |\n|                     | replicate_ignore_db option.                          |\n+---------------------+------------------------------------------------------+\n| Replicate_Do_Table  | Tables specified for replicating with the            |\n|                     | replicate_do_table option.                           |\n+---------------------+------------------------------------------------------+\n| Replicate_Ignore_Ta | Tables specified for ignoring with the               |\n| le                  | replicate_ignore_table option.                       |\n+---------------------+------------------------------------------------------+\n| Replicate_Wild_Do_T | Tables specified for replicating with the            |\n| ble                 | replicate_wild_do_table option.                      |\n+---------------------+------------------------------------------------------+\n| Replicate_Wild_Igno | Tables specified for ignoring with the               |\n| e_Table             | replicate_wild_ignore_table option.                  |\n+---------------------+------------------------------------------------------+\n| Last_Errno          | Alias for Last_SQL_Errno (see below)                 |\n+---------------------+------------------------------------------------------+\n| Last Error          | Alias for Last_SQL_Error (see below)                 |\n+---------------------+------------------------------------------------------+\n| Skip_Counter        | Number of events that a replica skips from the       |\n|                     | master, as recorded in the sql_slave_skip_counter    |\n|                     | system variable.                                     |\n+---------------------+------------------------------------------------------+\n| Exec_Master_Log_Pos | Position up to which the SQL thread has processed    |\n|                     | in the current master binary log file. Can be used   |\n|                     | to start a new replica from a current replica with   |\n|                     | the CHANGE MASTER TO ... MASTER_LOG_POS option.      |\n+---------------------+------------------------------------------------------+\n| Relay_Log_Space     | Total size of all relay log files combined.          |\n+---------------------+------------------------------------------------------+\n| Until_Condition     |                                                      |\n+---------------------+------------------------------------------------------+\n| Until_Log_File      | The MASTER_LOG_FILE value of the START SLAVE UNTIL   |\n|                     | condition.                                           |\n+---------------------+------------------------------------------------------+\n| Until_Log_Pos       | The MASTER_LOG_POS value of the START SLAVE UNTIL    |\n|                     | condition.                                           |\n+---------------------+------------------------------------------------------+\n| Master_SSL_Allowed  | Whether an SSL connection is permitted (Yes), not    |\n|                     | permitted (No) or permitted but without the replica  |\n|                     | having SSL support enabled (Ignored)                 |\n+---------------------+------------------------------------------------------+\n| Master_SSL_CA_File  | The MASTER_SSL_CA option of the CHANGE MASTER TO     |\n|                     | statement.                                           |\n+---------------------+------------------------------------------------------+\n| Master_SSL_CA_Path  | The MASTER_SSL_CAPATH option of the CHANGE MASTER    |\n|                     | TO statement.                                        |\n+---------------------+------------------------------------------------------+\n| Master_SSL_Cert     | The MASTER_SSL_CERT option of the CHANGE MASTER TO   |\n|                     | statement.                                           |\n+---------------------+------------------------------------------------------+\n| Master_SSL_Cipher   | The MASTER_SSL_CIPHER option of the CHANGE MASTER    |\n|                     | TO statement.                                        |\n+---------------------+------------------------------------------------------+\n| Master_SSL_Key      | The MASTER_SSL_KEY option of the CHANGE MASTER TO    |\n|                     | statement.                                           |\n+---------------------+------------------------------------------------------+\n| Seconds_Behind_Mast | Difference between the timestamp logged on the       |\n| r                   | master for the event that the replica is currently   |\n|                     | processing, and the current timestamp on the         |\n|                     | replica. Zero if the replica is not currently        |\n|                     | processing an event. With serial replication,        |\n|                     | seconds_behind_master is updated when the SQL        |\n|                     | thread begins executing a transaction. With          |\n|                     | parallel replication, seconds_behind_master is       |\n|                     | updated only after transactions commit. Starting in  |\n|                     | MariaDB 10.3.38, 10.4.28, 10.5.19, 10.6.12, 10.8.7,  |\n|                     | 10.9.5, 10.10.3, and 10.11.2, an exception is drawn  |\n|                     | on the parallel replica to additionally update       |\n|                     | seconds_behind_master when the first transaction     |\n|                     | received after idling is queued to a worker for      |\n|                     | execution, to provide a reliable initial value for   |\n|                     | the duration until a transaction commits.            |\n|                     | Additional behaviors to be aware of are as follows:  |\n|                     | 1) Seconds_Behind_Master will update for ignored     |\n|                     | events, e.g. those skipped due to                    |\n|                     | sql_slave_skip_counter. 2) On the serial replica,    |\n|                     | transactions with prior timestamps can update        |\n|                     | Seconds_Behind_Master such that it can go            |\n|                     | backwards, though this is not true for the parallel  |\n|                     | replica. 3) When configured with MASTER_DELAY, as a  |\n|                     | replicated transaction begins executing (i.e. on a   |\n|                     | serial or post-idle parallel replica),               |\n|                     | Seconds_Behind_Master will update before delaying,   |\n|                     | and while delaying occurs will grow to encompass     |\n|                     | the configured value. 4) There is a known issue,     |\n|                     | tracked by MDEV-17516, such that                     |\n|                     | Seconds_Behind_Master will initially present as 0    |\n|                     | on replica restart until a replicated transaction    |\n|                     | begins executing, even if the last replica session   |\n|                     | was lagging behind when stopped.                     |\n+---------------------+------------------------------------------------------+\n| Master_SSL_Verify_S | The MASTER_SSL_VERIFY_SERVER_CERT option of the      |\n| rver_Cert           | CHANGE MASTER TO statement.                          |\n+---------------------+------------------------------------------------------+\n| Last_IO_Errno       | Error code of the most recent error that caused the  |\n|                     | I/O thread to stop (also recorded in the replica\'s   |\n|                     | error log). 0 means no error. RESET SLAVE or RESET   |\n|                     | MASTER will reset this value.                        |\n+---------------------+------------------------------------------------------+\n| Last_IO_Error       | Error message of the most recent error that caused   |\n|                     | the I/O thread to stop (also recorded in the         |\n|                     | replica\'s error log). An empty string means no       |\n|                     | error. RESET SLAVE or RESET MASTER will reset this   |\n|                     | value.                                               |\n+---------------------+------------------------------------------------------+\n| Last_SQL_Errno      | Error code of the most recent error that caused the  |\n|                     | SQL thread to stop (also recorded in the replica\'s   |\n|                     | error log). 0 means no error. RESET SLAVE or RESET   |\n|                     | MASTER will reset this value.                        |\n+---------------------+------------------------------------------------------+\n| Last_SQL_Error      | Error message of the most recent error that caused   |\n|                     | the SQL thread to stop (also recorded in the         |\n|                     | replica\'s error log). An empty string means no       |\n|                     | error. RESET SLAVE or RESET MASTER will reset this   |\n|                     | value.                                               |\n+---------------------+------------------------------------------------------+\n| Replicate_Ignore_Se | List of server_ids that are currently being ignored  |\n| ver_Ids             | for replication purposes, or an empty string for     |\n|                     | none, as specified in the IGNORE_SERVER_IDS option   |\n|                     | of the CHANGE MASTER TO statement.                   |\n+---------------------+------------------------------------------------------+\n| Master_Server_Id    | The master\'s server_id value.                        |\n+---------------------+------------------------------------------------------+\n| Master_SSL_Crl      | The MASTER_SSL_CRL option of the CHANGE MASTER TO    |\n|                     | statement.                                           |\n+---------------------+------------------------------------------------------+\n| Master_SSL_Crlpath  | The MASTER_SSL_CRLPATH option of the CHANGE MASTER   |\n|                     | TO statement.                                        |\n+---------------------+------------------------------------------------------+\n| Using_Gtid          | Whether or not global transaction ID\'s are being     |\n|                     | used for replication (can be No, Slave_Pos, or       |\n|                     | Current_Pos).                                        |\n+---------------------+------------------------------------------------------+\n| Gtid_IO_Pos         | Current global transaction ID value.                 |\n+---------------------+------------------------------------------------------+\n| Retried_transaction | Number of retried transactions for this connection.  |\n|                     | Returned with SHOW ALL SLAVES STATUS only.           |\n+---------------------+------------------------------------------------------+\n| Max_relay_log_size  | Max relay log size for this connection. Returned     |\n|                     | with SHOW ALL SLAVES STATUS only.                    |\n+---------------------+------------------------------------------------------+\n| Executed_log_entrie | How many log entries the replica has executed.       |\n|                     | Returned with SHOW ALL SLAVES STATUS only.           |\n+---------------------+------------------------------------------------------+\n| Slave_received_hear | How many heartbeats we have got from the master.     |\n| beats               | Returned with SHOW ALL SLAVES STATUS only.           |\n+---------------------+------------------------------------------------------+\n| Slave_heartbeat_per | How often to request a heartbeat packet from the     |\n| od                  | master (in seconds). Returned with SHOW ALL SLAVES   |\n|                     | STATUS only.                                         |\n+---------------------+------------------------------------------------------+\n| Gtid_Slave_Pos      | GTID of the last event group replicated on a         |\n|                     | replica server, for each replication domain, as      |\n|                     | stored in the gtid_slave_pos system variable.        |\n|                     | Returned with SHOW ALL SLAVES STATUS only.           |\n+---------------------+------------------------------------------------------+\n| SQL_Delay           | Value specified by MASTER_DELAY in CHANGE MASTER     |\n|                     | (or 0 if none).                                      |\n+---------------------+------------------------------------------------------+\n| SQL_Remaining_Delay | When the replica is delaying the execution of an     |\n|                     | event due to MASTER_DELAY, this is the number of     |\n|                     | seconds of delay remaining before the event will be  |\n|                     | applied. Otherwise, the value is NULL.               |\n+---------------------+------------------------------------------------------+\n| Slave_SQL_Running_S | The state of the SQL driver threads, same as in      |\n| ate                 | SHOW PROCESSLIST. When the replica is delaying the   |\n|                     | execution of an event due to MASTER_DELAY, this      |\n|                     | field displays: \"Waiting until MASTER_DELAY seconds  |\n|                     | after master executed event\".                        |\n+---------------------+------------------------------------------------------+\n| Slave_DDL_Groups    | This status variable counts the occurrence of DDL    |\n|                     | statements.  This is a replica-side counter for      |\n|                     | optimistic parallel replication.                     |\n+---------------------+------------------------------------------------------+\n| Slave_Non_Transacti | This status variable counts the occurrence of        |\n| nal_Groups          | non-transactional event groups.  This is a           |\n|                     | replica-side counter for optimistic parallel         |\n|                     | replication.                                         |\n+---------------------+------------------------------------------------------+\n| Slave_Transactional | This status variable counts the occurrence of        |\n| Groups              | transactional event groups.  This is a replica-side  |\n|                     | counter for optimistic parallel replication.         |\n+---------------------+------------------------------------------------------+\n\nSHOW REPLICA STATUS\n-------------------\n\nMariaDB starting with 10.5.1\n----------------------------\nSHOW REPLICA STATUS is an alias for SHOW SLAVE STATUS from MariaDB 10.5.1.\n\nExamples\n--------\n\nIf you issue this statement using the mariadb client, you can use a \\G\nstatement terminator rather than a semicolon to obtain a more readable\nvertical layout.\n\nSHOW SLAVE STATUS\\G\n*************************** 1. row ***************************\n       Slave_IO_State: Waiting for master to send event\n         Master_Host: db01.example.com\n         Master_User: replicant\n         Master_Port: 3306\n        Connect_Retry: 60\n       Master_Log_File: mariadb-bin.000010\n     Read_Master_Log_Pos: 548\n       Relay_Log_File: relay-bin.000004\n        Relay_Log_Pos: 837\n    Relay_Master_Log_File: mariadb-bin.000010\n      Slave_IO_Running: Yes\n      Slave_SQL_Running: Yes\n       Replicate_Do_DB:\n     Replicate_Ignore_DB:\n     Replicate_Do_Table:\n   Replicate_Ignore_Table:\n   Replicate_Wild_Do_Table:\n Replicate_Wild_Ignore_Table:\n         Last_Errno: 0\n         Last_Error:\n        Skip_Counter: 0\n     Exec_Master_Log_Pos: 548\n       Relay_Log_Space: 1497\n       Until_Condition: None\n       Until_Log_File:\n        Until_Log_Pos: 0\n     Master_SSL_Allowed: No\n     Master_SSL_CA_File:\n     Master_SSL_CA_Path:\n       Master_SSL_Cert:\n      Master_SSL_Cipher:\n       Master_SSL_Key:\n    Seconds_Behind_Master: 0\nMaster_SSL_Verify_Server_Cert: No\n        Last_IO_Errno: 0\n        Last_IO_Error:\n       Last_SQL_Errno: 0\n       Last_SQL_Error:\n Replicate_Ignore_Server_Ids:\n      Master_Server_Id: 101\n       Master_SSL_Crl:\n     Master_SSL_Crlpath:\n         Using_Gtid: No\n         Gtid_IO_Pos:\n\nSHOW ALL SLAVES STATUS\\G\n*************************** 1. row ***************************\n       Connection_name:\n       Slave_SQL_State: Slave has read all relay log; waiting for the\nslave I/O thread to update it\n       Slave_IO_State: Waiting for master to send event\n         Master_Host: db01.example.com\n         Master_User: replicant\n         Master_Port: 3306\n        Connect_Retry: 60\n       Master_Log_File: mariadb-bin.000010\n     Read_Master_Log_Pos: 3608\n       Relay_Log_File: relay-bin.000004\n        Relay_Log_Pos: 3897\n    Relay_Master_Log_File: mariadb-bin.000010\n      Slave_IO_Running: Yes\n      Slave_SQL_Running: Yes\n       Replicate_Do_DB:\n     Replicate_Ignore_DB:\n     Replicate_Do_Table:\n   Replicate_Ignore_Table:\n   Replicate_Wild_Do_Table:\n Replicate_Wild_Ignore_Table:\n         Last_Errno: 0\n         Last_Error:\n        Skip_Counter: 0\n     Exec_Master_Log_Pos: 3608\n       Relay_Log_Space: 4557\n       Until_Condition: None\n       Until_Log_File:\n        Until_Log_Pos: 0\n     Master_SSL_Allowed: No\n     Master_SSL_CA_File:\n     Master_SSL_CA_Path:\n       Master_SSL_Cert:\n      Master_SSL_Cipher:\n       Master_SSL_Key:\n    Seconds_Behind_Master: 0\nMaster_SSL_Verify_Server_Cert: No\n        Last_IO_Errno: 0\n        Last_IO_Error:\n       Last_SQL_Errno: 0\n       Last_SQL_Error:\n Replicate_Ignore_Server_Ids:\n      Master_Server_Id: 101\n       Master_SSL_Crl:\n     Master_SSL_Crlpath:\n         Using_Gtid: No\n         Gtid_IO_Pos:\n    Retried_transactions: 0\n     Max_relay_log_size: 104857600\n    Executed_log_entries: 40\n  Slave_received_heartbeats: 11\n   Slave_heartbeat_period: 1800.000\n       Gtid_Slave_Pos: 0-101-2320\n\nYou can also access some of the variables directly from status variables:\n\nSET @@default_master_connection=\"test\" ;\nshow status like \"%slave%\"\n\nVariable_name   Value\nCom_show_slave_hosts    0\nCom_show_slave_status   0\nCom_start_all_slaves    0\nCom_start_slave 0\nCom_stop_all_slaves     0\nCom_stop_slave  0\nRpl_semi_sync_slave_status      OFF\nSlave_connections       0\nSlave_heartbeat_period  1800.000\nSlave_open_temp_tables  0\nSlave_received_heartbeats       0\nSlave_retried_transactions      0\nSlave_running   OFF\nSlaves_connected        0\nSlaves_running  1\n\nURL: https://mariadb.com/kb/en/show-replica-status/','','https://mariadb.com/kb/en/show-replica-status/'),
(357,'SET SQL_LOG_BIN',26,'Syntax\n------\n\nSET [SESSION] sql_log_bin = {0|1}\n\nDescription\n-----------\n\nSets the sql_log_bin system variable, which disables or enables binary logging\nfor the current connection, if the client has the SUPER privilege. The\nstatement is refused with an error if the client does not have that privilege.\n\nBefore MariaDB 5.5 and before MySQL 5.6 one could also set sql_log_bin as a\nglobal variable. This was disabled as this was too dangerous as it could\ndamage replication.\n\nURL: https://mariadb.com/kb/en/set-sql_log_bin/','','https://mariadb.com/kb/en/set-sql_log_bin/'),
(393,'SHOW PROFILES',26,'Syntax\n------\n\nSHOW PROFILES\n\nDescription\n-----------\n\nThe SHOW PROFILES statement displays profiling information that indicates\nresource usage for statements executed during the course of the current\nsession. It is used together with SHOW PROFILE.\n\nURL: https://mariadb.com/kb/en/show-profiles/','','https://mariadb.com/kb/en/show-profiles/'),
(394,'SHOW QUERY_RESPONSE_TIME',26,'It is possible to use SHOW QUERY_RESPONSE_TIME as an alternative for\nretrieving information from the QUERY_RESPONSE_TIME plugin.\n\nThis was introduced as part of the Information Schema plugin extension.\n\nURL: https://mariadb.com/kb/en/show-query_response_time/','','https://mariadb.com/kb/en/show-query_response_time/'),
(405,'BINLOG',26,'Syntax\n------\n\nBINLOG \'str\'\n\nDescription\n-----------\n\nBINLOG is an internal-use statement. It is generated by the mariadb-binlog\nprogram as the printable representation of certain events in binary log files.\nThe \'str\' value is a base 64-encoded string that the server decodes to\ndetermine the data change indicated by the corresponding event. This statement\nrequires the SUPER privilege (<= MariaDB 10.5.1) or the BINLOG REPLAY\nprivilege (>= MariaDB 10.5.2).\n\nURL: https://mariadb.com/kb/en/binlog/','','https://mariadb.com/kb/en/binlog/'),
(410,'LOAD INDEX',26,'Syntax\n------\n\nLOAD INDEX INTO CACHE\n tbl_index_list [, tbl_index_list] ...\n\ntbl_index_list:\n tbl_name\n  [[INDEX|KEY] (index_name[, index_name] ...)]\n  [IGNORE LEAVES]\n\nDescription\n-----------\n\nThe LOAD INDEX INTO CACHE statement preloads a table index into the key cache\nto which it has been assigned by an explicit CACHE INDEX statement, or into\nthe default key cache otherwise. LOAD INDEX INTO CACHE is used only for MyISAM\nor Aria tables.\n\nThe IGNORE LEAVES modifier causes only blocks for the nonleaf nodes of the\nindex to be preloaded.\n\nURL: https://mariadb.com/kb/en/load-index/','','https://mariadb.com/kb/en/load-index/'),
(191,'VAR_SAMP',16,'Syntax\n------\n\nVAR_SAMP(expr)\n\nDescription\n-----------\n\nReturns the sample variance of expr. That is, the denominator is the number of\nrows minus one.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nVAR_SAMP() can be used as a window function.\n\nVAR_SAMP() returns NULL if there were no matching rows.\n\nExamples\n--------\n\nAs an aggregate function:\n\nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n\nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n\nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a        |        0.8165 |         1.0000 |     0.6667 |\n| b        |       18.0400 |        20.1693 |   325.4400 |\n+----------+---------------+----------------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, VAR_SAMP(score) \n OVER (PARTITION BY test) AS variance_results FROM student_test;\n+---------+--------+-------+------------------+\n| name    | test   | score | variance_results |\n+---------+--------+-------+------------------+\n| Chun    | SQL    |    75 |         382.9167 |\n| Chun    | Tuning |    73 |         873.0000 |\n| Esben   | SQL    |    43 |         382.9167 |\n| Esben   | Tuning |    31 |         873.0000 |\n| Kaolin  | SQL    |    56 |         382.9167 |\n| Kaolin  | Tuning |    88 |         873.0000 |\n| Tatiana | SQL    |    87 |         382.9167 |\n+---------+--------+-------+------------------+\n\nURL: https://mariadb.com/kb/en/var_samp/','','https://mariadb.com/kb/en/var_samp/'),
(194,'CHARSET',17,'Syntax\n------\n\nCHARSET(str)\n\nDescription\n-----------\n\nReturns the character set of the string argument. If str is not a string, it\nis considered as a binary string (so the function returns \'binary\'). This\napplies to NULL, too. The return value is a string in the utf8 character set.\n\nExamples\n--------\n\nSELECT CHARSET(\'abc\');\n+----------------+\n| CHARSET(\'abc\') |\n+----------------+\n| latin1         |\n+----------------+\n\nSELECT CHARSET(CONVERT(\'abc\' USING utf8));\n+------------------------------------+\n| CHARSET(CONVERT(\'abc\' USING utf8)) |\n+------------------------------------+\n| utf8                               |\n+------------------------------------+\n\nSELECT CHARSET(USER());\n+-----------------+\n| CHARSET(USER()) |\n+-----------------+\n| utf8            |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/charset/','','https://mariadb.com/kb/en/charset/'),
(195,'COERCIBILITY',17,'Syntax\n------\n\nCOERCIBILITY(str)\n\nDescription\n-----------\n\nReturns the collation coercibility value of the string argument. Coercibility\ndefines what will be converted to what in case of collation conflict, with an\nexpression with higher coercibility being converted to the collation of an\nexpression with lower coercibility.\n\n+-----------------------------+---------------------------+------------------+\n| Coercibility                | Description               | Example          |\n+-----------------------------+---------------------------+------------------+\n| 0                           | Explicit                  | Value using a    |\n|                             |                           | COLLATE clause   |\n+-----------------------------+---------------------------+------------------+\n| 1                           | No collation              | Concatenated     |\n|                             |                           | strings using    |\n|                             |                           | different        |\n|                             |                           | collations       |\n+-----------------------------+---------------------------+------------------+\n| 2                           | Implicit                  | Column value     |\n+-----------------------------+---------------------------+------------------+\n| 3                           | Constant                  | USER() return    |\n|                             |                           | value            |\n+-----------------------------+---------------------------+------------------+\n| 4                           | Coercible                 | Literal string   |\n+-----------------------------+---------------------------+------------------+\n| 5                           | Ignorable                 | NULL or derived  |\n|                             |                           | from NULL        |\n+-----------------------------+---------------------------+------------------+\n\nExamples\n--------\n\nSELECT COERCIBILITY(\'abc\' COLLATE latin1_swedish_ci);\n+-----------------------------------------------+\n| COERCIBILITY(\'abc\' COLLATE latin1_swedish_ci) |\n+-----------------------------------------------+\n|                                             0 |\n+-----------------------------------------------+\n\nSELECT COERCIBILITY(USER());\n+----------------------+\n| COERCIBILITY(USER()) |\n+----------------------+\n|                    3 |\n+----------------------+\n\nSELECT COERCIBILITY(\'abc\');\n+---------------------+\n| COERCIBILITY(\'abc\') |\n+---------------------+\n|                   4 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/coercibility/','','https://mariadb.com/kb/en/coercibility/'),
(414,'SHOW FUNCTION CODE',26,'Syntax\n------\n\nSHOW FUNCTION CODE func_name\n\nDescription\n-----------\n\nSHOW FUNCTION CODE shows a representation of the internal implementation of\nthe stored function.\n\nIt is similar to SHOW PROCEDURE CODE but for stored functions.\n\nURL: https://mariadb.com/kb/en/show-function-code/','','https://mariadb.com/kb/en/show-function-code/'),
(444,'LOCK IN SHARE MODE',27,'InnoDB supports row-level locking. Selected rows can be locked using LOCK IN\nSHARE MODE or FOR UPDATE. In both cases, a lock is acquired on the rows read\nby the query, and it will be released when the current transaction is\ncommitted.\n\nWhen LOCK IN SHARE MODE is specified in a SELECT statement, MariaDB will wait\nuntil all transactions that have modified the rows are committed. Then, a\nwrite lock is acquired. All transactions can read the rows, but if they want\nto modify them, they have to wait until your transaction is committed.\n\nIf autocommit is set to 1 (the default), the LOCK IN SHARE MODE and FOR UPDATE\nclauses have no effect.\n\nURL: https://mariadb.com/kb/en/lock-in-share-mode/','','https://mariadb.com/kb/en/lock-in-share-mode/'),
(446,'PROCEDURE',27,'The PROCEDURE clause of SELECT passes the whole result set to a Procedure\nwhich will process it. These Procedures are not Stored Procedures, and can\nonly be written in the C language, so it is necessary to recompile the server.\n\nCurrently, the only available procedure is ANALYSE, which examines the\nresultset and suggests the optimal datatypes for each column. It is defined in\nthe sql/sql_analyse.cc file, and can be used as an example to create more\nProcedures.\n\nThis clause cannot be used in a view\'s definition.\n\nURL: https://mariadb.com/kb/en/procedure/','','https://mariadb.com/kb/en/procedure/'),
(198,'CURRENT_ROLE',17,'Syntax\n------\n\nCURRENT_ROLE, CURRENT_ROLE()\n\nDescription\n-----------\n\nReturns the current role name. This determines your access privileges. The\nreturn value is a string in the utf8 character set.\n\nIf there is no current role, NULL is returned.\n\nThe output of SELECT CURRENT_ROLE is equivalent to the contents of the\nENABLED_ROLES Information Schema table.\n\nUSER() returns the combination of user and host used to login. CURRENT_USER()\nreturns the account used to determine current connection\'s privileges.\n\nExamples\n--------\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| NULL         |\n+--------------+\n\nSET ROLE staff;\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| staff        |\n+--------------+\n\nURL: https://mariadb.com/kb/en/current_role/','','https://mariadb.com/kb/en/current_role/'),
(199,'CURRENT_USER',17,'Syntax\n------\n\nCURRENT_USER, CURRENT_USER()\n\nDescription\n-----------\n\nReturns the user name and host name combination for the MariaDB account that\nthe server used to authenticate the current client. This account determines\nyour access privileges. The return value is a string in the utf8 character set.\n\nThe value of CURRENT_USER() can differ from the value of USER().\nCURRENT_ROLE() returns the current active role.\n\nExamples\n--------\n\nshell> mysql --user=\"anonymous\"\n\nselect user(),current_user();\n+---------------------+----------------+\n| user()              | current_user() |\n+---------------------+----------------+\n| anonymous@localhost | @localhost     |\n+---------------------+----------------+\n\nWhen calling CURRENT_USER() in a stored procedure, it returns the owner of the\nstored procedure, as defined with DEFINER.\n\nURL: https://mariadb.com/kb/en/current_user/','','https://mariadb.com/kb/en/current_user/'),
(200,'DATABASE',17,'Syntax\n------\n\nDATABASE()\nSCHEMA()\n\nDescription\n-----------\n\nReturns the default (current) database name as a string in the utf8 character\nset. If there is no default database, DATABASE() returns NULL. Within a stored\nroutine, the default database is the database that the routine is associated\nwith, which is not necessarily the same as the database that is the default in\nthe calling context.\n\nSCHEMA() is a synonym for DATABASE().\n\nTo select a default database, the USE statement can be run. Another way to set\nthe default database is specifying its name at mariadb command line client\nstartup.\n\nExamples\n--------\n\nSELECT DATABASE();\n+------------+\n| DATABASE() |\n+------------+\n| NULL       |\n+------------+\n\nUSE test;\nDatabase changed\n\nSELECT DATABASE();\n+------------+\n| DATABASE() |\n+------------+\n| test       |\n+------------+\n\nURL: https://mariadb.com/kb/en/database/','','https://mariadb.com/kb/en/database/'),
(203,'FOUND_ROWS',17,'Syntax\n------\n\nFOUND_ROWS()\n\nDescription\n-----------\n\nA SELECT statement may include a LIMIT clause to restrict the number of rows\nthe server returns to the client. In some cases, it is desirable to know how\nmany rows the statement would have returned without the LIMIT, but without\nrunning the statement again. To obtain this row count, include a\nSQL_CALC_FOUND_ROWS option in the SELECT statement, and then invoke\nFOUND_ROWS() afterwards.\n\nYou can also use FOUND_ROWS() to obtain the number of rows returned by a\nSELECT which does not contain a LIMIT clause. In this case you don\'t need to\nuse the SQL_CALC_FOUND_ROWS option. This can be useful for example in a stored\nprocedure.\n\nAlso, this function works with some other statements which return a resultset,\nincluding SHOW, DESC and HELP. For DELETE ... RETURNING you should use\nROW_COUNT(). It also works as a prepared statement, or after executing a\nprepared statement.\n\nStatements which don\'t return any results don\'t affect FOUND_ROWS() - the\nprevious value will still be returned.\n\nWarning: When used after a CALL statement, this function returns the number of\nrows selected by the last query in the procedure, not by the whole procedure.\n\nStatements using the FOUND_ROWS() function are not safe for replication.\n\nExamples\n--------\n\nSHOW ENGINES\\G\n*************************** 1. row ***************************\n   Engine: CSV\n  Support: YES\n  Comment: Stores tables as CSV files\nTransactions: NO\n     XA: NO\n Savepoints: NO\n*************************** 2. row ***************************\n   Engine: MRG_MyISAM\n  Support: YES\n  Comment: Collection of identical MyISAM tables\nTransactions: NO\n     XA: NO\n Savepoints: NO\n\n...\n\n*************************** 8. row ***************************\n   Engine: PERFORMANCE_SCHEMA\n  Support: YES\n  Comment: Performance Schema\nTransactions: NO\n     XA: NO\n Savepoints: NO\n8 rows in set (0.000 sec)\n\nSELECT FOUND_ROWS();\n+--------------+\n| FOUND_ROWS() |\n+--------------+\n|           8 |\n+--------------+\n\nSELECT SQL_CALC_FOUND_ROWS * FROM tbl_name WHERE id > 100 LIMIT 10;\n\nSELECT FOUND_ROWS();\n+--------------+\n| FOUND_ROWS() |\n+--------------+\n|           23 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/found_rows/','','https://mariadb.com/kb/en/found_rows/'),
(447,'DUAL',27,'Description\n-----------\n\nYou are allowed to specify DUAL as a dummy table name in situations where no\ntables are referenced, such as the following SELECT statement:\n\nSELECT 1 + 1 FROM DUAL;\n+-------+\n| 1 + 1 |\n+-------+\n|     2 |\n+-------+\n\nDUAL is purely for the convenience of people who require that all SELECT\nstatements should have FROM and possibly other clauses. MariaDB ignores the\nclauses. MariaDB does not require FROM DUAL if no tables are referenced.\n\nFROM DUAL could be used when you only SELECT computed values, but require a\nWHERE clause, perhaps to test that a script correctly handles empty resultsets:\n\nSELECT 1 FROM DUAL WHERE FALSE;\nEmpty set (0.00 sec)\n\nURL: https://mariadb.com/kb/en/dual/','','https://mariadb.com/kb/en/dual/'),
(452,'LOAD DATA INFILE',27,'Syntax\n------\n\nLOAD DATA [LOW_PRIORITY | CONCURRENT] [LOCAL] INFILE \'file_name\'\n  [REPLACE | IGNORE]\n  INTO TABLE tbl_name\n  [CHARACTER SET charset_name]\n  [{FIELDS | COLUMNS}\n    [TERMINATED BY \'string\']\n    [[OPTIONALLY] ENCLOSED BY \'char\']\n    [ESCAPED BY \'char\']\n  ]\n  [LINES\n    [STARTING BY \'string\']\n    [TERMINATED BY \'string\']\n  ]\n  [IGNORE number {LINES|ROWS}]\n  [(col_name_or_user_var,...)]\n  [SET col_name = expr,...]\n\nDescription\n-----------\n\nLOAD DATA INFILE is unsafe for statement-based replication.\n\nReads rows from a text file into the designated table on the database at a\nvery high speed. The file name must be given as a literal string.\n\nFiles are written to disk using the SELECT INTO OUTFILE statement. You can\nthen read the files back into a table using the LOAD DATA INFILE statement.\nThe FIELDS and LINES clauses are the same in both statements. These clauses\nare optional, but if both are specified then the FIELDS clause must precede\nLINES.\n\nExecuting this statement activates INSERT triggers.\n\nOne must have the FILE privilege to be able to execute LOAD DATA INFILE. This\nis to ensure normal users cannot read system files. LOAD DATA LOCAL INFILE\ndoes not have this requirement.\n\nIf the secure_file_priv system variable is set (by default it is not), the\nloaded file must be present in the specified directory.\n\nNote that MariaDB\'s systemd unit file restricts access to /home, /root, and\n/run/user by default. See Configuring access to home directories.\n\nLOAD DATA LOCAL INFILE\n----------------------\n\nWhen you execute the LOAD DATA INFILE statement, MariaDB Server attempts to\nread the input file from its own file system. By contrast, when you execute\nthe LOAD DATA LOCAL INFILE statement, the client attempts to read the input\nfile from its file system, and it sends the contents of the input file to the\nMariaDB Server. This allows you to load files from the client\'s local file\nsystem into the database.\n\nIf you don\'t want to permit this operation (perhaps for security reasons), you\ncan disable the LOAD DATA LOCAL INFILE statement on either the server or the\nclient.\n\n* The LOAD DATA LOCAL INFILE statement can be disabled on the server by\nsetting the local_infile system variable to 0.\n* The LOAD DATA LOCAL INFILE statement can be disabled on the client. If you\nare using MariaDB Connector/C, this can be done by unsetting the\nCLIENT_LOCAL_FILES capability flag with the mysql_real_connect function or by\nunsetting the MYSQL_OPT_LOCAL_INFILE option with mysql_optionsv function. If\nyou are using a different client or client library, then see the documentation\nfor your specific client or client library to determine how it handles the\nLOAD DATA LOCAL INFILE statement.\n\nIf the LOAD DATA LOCAL INFILE statement is disabled by either the server or\nthe client and if the user attempts to execute it, then the server will cause\nthe statement to fail with the following error message:\n\nThe used command is not allowed with this MariaDB version\n\nNote that it is not entirely accurate to say that the MariaDB version does not\nsupport the command. It would be more accurate to say that the MariaDB\nconfiguration does not support the command. See MDEV-20500 for more\ninformation.\n\nFrom MariaDB 10.5.2, the error message is more accurate:\n\nThe used command is not allowed because the MariaDB server or client \n has disabled the local infile capability\n\nREPLACE and IGNORE\n------------------\n\nIf you load data from a file into a table that already contains data and has a\nprimary key, you may encounter issues where the statement attempts to insert a\nrow with a primary key that already exists. When this happens, the statement\nfails with Error 1064, protecting the data already on the table. If you want\nMariaDB to overwrite duplicates, use the REPLACE keyword.\n\nThe REPLACE keyword works like the REPLACE statement. Here, the statement\nattempts to load the data from the file. If the row does not exist, it adds it\nto the table. If the row contains an existing primary key, it replaces the\ntable data. That is, in the event of a conflict, it assumes the file contains\nthe desired row.\n\nThis operation can cause a degradation in load speed by a factor of 20 or more\nif the part that has already been loaded is larger than the capacity of the\nInnoDB Buffer Pool. This happens because it causes a lot of turnaround in the\nbuffer pool.\n\nUse the IGNORE keyword when you want to skip any rows that contain a\nconflicting primary key. Here, the statement attempts to load the data from\nthe file. If the row does not exist, it adds it to the table. If the row\ncontains an existing primary key, it ignores the addition request and moves on\nto the next. That is, in the event of a conflict, it assumes the table\ncontains the desired row.\n\nCharacter-sets\n--------------\n\nWhen the statement opens the file, it attempts to read the contents using the\ndefault character-set, as defined by the character_set_database system\nvariable.\n\nIn the cases where the file was written using a character-set other than the\ndefault, you can specify the character-set to use with the CHARACTER SET\nclause in the statement. It ignores character-sets specified by the SET NAMES\nstatement and by the character_set_client system variable. Setting the\nCHARACTER SET clause to a value of binary indicates \"no conversion.\"\n\nThe statement interprets all fields in the file as having the same\ncharacter-set, regardless of the column data type. To properly interpret file\ncontents, you must ensure that it was written with the correct character-set.\nIf you write a data file with mariadb-dump -T or with the SELECT INTO OUTFILE\nstatement with the mariadb client, be sure to use the --default-character-set\noption, so that the output is written with the desired character-set.\n\nWhen using mixed character sets, use the CHARACTER SET clause in both SELECT\nINTO OUTFILE and LOAD DATA INFILE to ensure that MariaDB correctly interprets\nthe escape sequences.\n\nThe character_set_filesystem system variable controls the interpretation of\nthe filename.\n\nIt is currently not possible to load data files that use the ucs2 character\nset.\n\nPreprocessing Inputs\n--------------------\n\ncol_name_or_user_var can be a column name, or a user variable. In the case of\na variable, the SET statement can be used to preprocess the value before\nloading into the table.\n\nPriority and Concurrency\n------------------------\n\nIn storage engines that perform table-level locking (MyISAM, MEMORY and\nMERGE), using the LOW_PRIORITY keyword, MariaDB delays insertions until no\nother clients are reading from the table. Alternatively, when using the MyISAM\nstorage engine, you can use the CONCURRENT keyword to perform concurrent\ninsertion.\n\nThe LOW_PRIORITY and CONCURRENT keywords are mutually exclusive. They cannot\nbe used in the same statement.\n\nProgress Reporting\n------------------\n\nThe LOAD DATA INFILE statement supports progress reporting. You may find this\nuseful when dealing with long-running operations. Using another client you can\nissue a SHOW PROCESSLIST query to check the progress of the data load.\n\nUsing mariadb-import\n--------------------\n\nMariaDB ships with a separate utility for loading data from files:\nmariadb-import (or mysqlimport before MariaDB 10.5). It operates by sending\nLOAD DATA INFILE statements to the server.\n\nUsing mariadb-import you can compress the file using the --compress option, to\nget better performance over slow networks, providing both the client and\nserver support the compressed protocol. Use the --local option to load from\nthe local file system.\n\nIndexing\n--------\n\nIn cases where the storage engine supports ALTER TABLE... DISABLE KEYS\nstatements (MyISAM and Aria), the LOAD DATA INFILE statement automatically\ndisables indexes during the execution.\n\nExamples\n--------\n\nYou have a file with this content (note the the separator is \',\', not tab,\nwhich is the default):\n\n2,2\n3,3\n4,4\n5,5\n6,8\n\nCREATE TABLE t1 (a int, b int, c int, d int, PRIMARY KEY (a));\nLOAD DATA LOCAL INFILE \n \'/tmp/loaddata7.dat\' INTO TABLE t1 FIELDS TERMINATED BY \',\' (a,b) SET c=a+b;\nSELECT * FROM t1;\n+------+------+------+\n| a    | b    | c    |\n+------+------+------+\n|    2 |    2 |    4 |\n|    3 |    3 |    6 |\n|    4 |    4 |    8 |\n|    5 |    5 |   10 |\n|    6 |    8 |   14 |\n+------+------+------+\n\nAnother example, given the following data (the separator is a tab):\n\n1       a\n2       b\n\nThe value of the first column is doubled before loading:\n\nLOAD DATA INFILE \'ld.txt\' INTO TABLE ld (@i,v) SET i=@i*2;\n\nSELECT * FROM ld;\n+------+------+\n| i    | v    |\n+------+------+\n|    2 | a    |\n|    4 | b    |\n+------+------+\n\nURL: https://mariadb.com/kb/en/load-data-infile/','','https://mariadb.com/kb/en/load-data-infile/'),
(462,'DO',27,'Syntax\n------\n\nDO expr [, expr] ...\n\nDescription\n-----------\n\nDO executes the expressions but does not return any results. In most respects,\nDO is shorthand for SELECT expr, ..., but has the advantage that it is\nslightly faster when you do not care about the result.\n\nDO is useful primarily with functions that have side effects, such as\nRELEASE_LOCK().\n\nURL: https://mariadb.com/kb/en/do/','','https://mariadb.com/kb/en/do/'),
(466,'Useful MariaDB Queries',27,'This page is intended to be a quick reference of commonly-used and/or useful\nqueries in MariaDB.\n\nCreating a Table\n----------------\n\nCREATE TABLE t1 ( a INT );\nCREATE TABLE t2 ( b INT );\nCREATE TABLE student_tests (\n name CHAR(10), test CHAR(10), \n score TINYINT, test_date DATE\n);\n\nSee CREATE TABLE for more.\n\nInserting Records\n-----------------\n\nINSERT INTO t1 VALUES (1), (2), (3);\nINSERT INTO t2 VALUES (2), (4);\n\nINSERT INTO student_tests \n (name, test, score, test_date) VALUES\n (\'Chun\', \'SQL\', 75, \'2012-11-05\'), \n (\'Chun\', \'Tuning\', 73, \'2013-06-14\'),\n (\'Esben\', \'SQL\', 43, \'2014-02-11\'), \n (\'Esben\', \'Tuning\', 31, \'2014-02-09\'), \n (\'Kaolin\', \'SQL\', 56, \'2014-01-01\'),\n (\'Kaolin\', \'Tuning\', 88, \'2013-12-29\'), \n (\'Tatiana\', \'SQL\', 87, \'2012-04-28\'), \n (\'Tatiana\', \'Tuning\', 83, \'2013-09-30\');\n\nSee INSERT for more.\n\nUsing AUTO_INCREMENT\n--------------------\n\nThe AUTO_INCREMENT attribute is used to automatically generate a unique\nidentity for new rows.\n\nCREATE TABLE student_details (\n id INT NOT NULL AUTO_INCREMENT, name CHAR(10), \n date_of_birth DATE, PRIMARY KEY (id)\n);\n\nWhen inserting, the id field can be omitted, and is automatically created.\n\nINSERT INTO student_details (name,date_of_birth) VALUES \n (\'Chun\', \'1993-12-31\'), \n (\'Esben\',\'1946-01-01\'),\n (\'Kaolin\',\'1996-07-16\'),\n (\'Tatiana\', \'1988-04-13\');\n\nSELECT * FROM student_details;\n+----+---------+---------------+\n| id | name    | date_of_birth |\n+----+---------+---------------+\n|  1 | Chun    | 1993-12-31    |\n|  2 | Esben   | 1946-01-01    |\n|  3 | Kaolin  | 1996-07-16    |\n|  4 | Tatiana | 1988-04-13    |\n+----+---------+---------------+\n\nSee AUTO_INCREMENT for more.\n\nQuerying from two tables on a common value\n------------------------------------------\n\nSELECT * FROM t1 INNER JOIN t2 ON t1.a = t2.b;\n\nThis kind of query is called a join - see JOINS for more.\n\nFinding the Maximum Value\n-------------------------\n\nSELECT MAX(a) FROM t1;\n+--------+\n| MAX(a) |\n+--------+\n|      3 |\n+--------+\n\nSee the MAX() function for more, as well as Finding the maximum value and\ngrouping the results below for a more practical example.\n\nFinding the Minimum Value\n-------------------------\n\nSELECT MIN(a) FROM t1;\n+--------+\n| MIN(a) |\n+--------+\n|      1 |\n+--------+\n\nSee the MIN() function for more.\n\nFinding the Average Value\n-------------------------\n\nSELECT AVG(a) FROM t1;\n+--------+\n| AVG(a) |\n+--------+\n| 2.0000 |\n+--------+\n\nSee the AVG() function for more.\n\nFinding the Maximum Value and Grouping the Results\n--------------------------------------------------\n\nSELECT name, MAX(score) FROM student_tests GROUP BY name;\n+---------+------------+\n| name    | MAX(score) |\n+---------+------------+\n| Chun    |         75 |\n| Esben   |         43 |\n| Kaolin  |         88 |\n| Tatiana |         87 |\n+---------+------------+\n\nSee the MAX() function for more.\n\nOrdering Results\n----------------\n\nSELECT name, test, score FROM student_tests ORDER BY score DESC;\n+---------+--------+-------+\n| name    | test   | score |\n+---------+--------+-------+\n| Kaolin  | Tuning |    88 |\n| Tatiana | SQL    |    87 |\n| Tatiana | Tuning |    83 |\n| Chun    | SQL    |    75 |\n| Chun    | Tuning |    73 |\n| Kaolin  | SQL    |    56 |\n| Esben   | SQL    |    43 |\n| Esben   | Tuning |    31 |\n+---------+--------+-------+\n\nSee ORDER BY for more.\n\nFinding the Row with the Minimum of a Particular Column\n-------------------------------------------------------\n\nIn this example, we want to find the lowest test score for any student.\n\nSELECT name,test, score FROM student_tests WHERE score=(SELECT MIN(score) FROM\nstudent);\n+-------+--------+-------+\n| name  | test   | score |\n+-------+--------+-------+\n| Esben | Tuning |    31 |\n+-------+--------+-------+\n\nFinding Rows with the Maximum Value of a Column by Group\n--------------------------------------------------------\n\nThis example returns the best test results of each student:\n\nSELECT name, test, score FROM student_tests st1 WHERE score = (\n SELECT MAX(score) FROM student st2 WHERE st1.name = st2.name\n); \n+---------+--------+-------+\n| name    | test   | score |\n+---------+--------+-------+\n| Chun    | SQL    |    75 |\n| Esben   | SQL    |    43 |\n| Kaolin  | Tuning |    88 |\n| Tatiana | SQL    |    87 |\n+---------+--------+-------+\n\nCalculating Age\n---------------\n\nThe TIMESTAMPDIFF function can be used to calculate someone\'s age:\n\nSELECT CURDATE() AS today;\n+------------+\n| today      |\n+------------+\n| 2014-02-17 |\n+------------+\n\nSELECT name, date_of_birth, TIMESTAMPDIFF(YEAR,date_of_birth,\'2014-08-02\') AS\nage \n FROM student_details;\n+---------+---------------+------+\n| name    | date_of_birth | age  |\n+---------+---------------+------+\n| Chun    | 1993-12-31    |   20 |\n| Esben   | 1946-01-01    |   68 |\n| Kaolin  | 1996-07-16    |   18 |\n| Tatiana | 1988-04-13    |   26 |\n+---------+---------------+------+\n\nSee TIMESTAMPDIFF() for more.\n\nUsing User-defined Variables\n----------------------------\n\nThis example sets a user-defined variable with the average test score, and\nthen uses it in a later query to return all results above the average.\n\nSELECT @avg_score:= AVG(score) FROM student_tests;\n+-------------------------+\n| @avg_score:= AVG(score) |\n+-------------------------+\n|            67.000000000 |\n+-------------------------+\n\nSELECT * FROM student_tests WHERE score > @avg_score;\n+---------+--------+-------+------------+\n| name    | test   | score | test_date  |\n+---------+--------+-------+------------+\n| Chun    | SQL    |    75 | 2012-11-05 |\n| Chun    | Tuning |    73 | 2013-06-14 |\n| Kaolin  | Tuning |    88 | 2013-12-29 |\n| Tatiana | SQL    |    87 | 2012-04-28 |\n| Tatiana | Tuning |    83 | 2013-09-30 |\n+---------+--------+-------+------------+\n\nUser-defined variables can also be used to add an incremental counter to a\nresultset:\n\nSET @count = 0;\n\nSELECT @count := @count + 1 AS counter, name, date_of_birth FROM\nstudent_details;\n+---------+---------+---------------+\n| counter | name    | date_of_birth |\n+---------+---------+---------------+\n|       1 | Chun    | 1993-12-31    |\n|       2 | Esben   | 1946-01-01    |\n|       3 | Kaolin  | 1996-07-16    |\n|       4 | Tatiana | 1988-04-13    |\n+---------+---------+---------------+\n\nSee User-defined Variables for more.\n\nView Tables in Order of Size\n----------------------------\n\nReturns a list of all tables in the database, ordered by size:\n\nSELECT table_schema as `DB`, table_name AS `Table`, \n ROUND(((data_length + index_length) / 1024 / 1024), 2) `Size (MB)`\n FROM information_schema.TABLES\n ORDER BY (data_length + index_length) DESC;\n\n+--------------------+---------------------------------------+-----------+\n| DB                 | Table                                 | Size (MB) |\n+--------------------+---------------------------------------+-----------+\n| wordpress          | wp_simple_history_contexts            |      7.05 |\n| wordpress          | wp_posts                              |      6.59 |\n| wordpress          | wp_simple_history                     |      3.05 |\n| wordpress          | wp_comments                           |      2.73 |\n| wordpress          | wp_commentmeta                        |      2.47 |\n| wordpress          | wp_simple_login_log                   |      2.03 |\n...\n\nRemoving Duplicates\n-------------------\n\nMariaDB starting with 10.3\n--------------------------\nThe following syntax is only valid MariaDB 10.3 and beyond:\n\nThis example assumes there\'s a unique ID, but that all other fields are\nidentical. In the example below, there are 4 records, 3 of which are\nduplicates, so two of the three duplicates need to be removed. The\nintermediate SELECT is not necessary, but demonstrates what is being returned.\n\nCREATE TABLE t (id INT, f1 VARCHAR(2));\n\nINSERT INTO t VALUES (1,\'a\'), (2,\'a\'), (3,\'b\'), (4,\'a\');\n\nSELECT * FROM t t1, t t2 WHERE t1.f1=t2.f1 AND t1.id<>t2.id AND t1.id=(\n SELECT MAX(id) FROM t tab WHERE tab.f1=t1.f1\n);\n+------+------+------+------+\n| id   | f1   | id   | f1   |\n+------+------+------+------+\n|    4 | a    |    1 | a    |\n|    4 | a    |    2 | a    |\n+------+------+------+------+\n\nDELETE FROM t WHERE id IN (\n SELECT t2.id FROM t t1, t t2 WHERE t1.f1=t2.f1 AND t1.id<>t2.id AND t1.id=(\n  SELECT MAX(id) FROM t tab WHERE tab.f1=t1.f1\n )\n);\nQuery OK, 2 rows affected (0.120 sec)\n\nSELECT * FROM t;\n+------+------+\n| id   | f1   |\n+------+------+\n|    3 | b    |\n|    4 | a    |\n+------+------\n\nURL: https://mariadb.com/kb/en/useful-mariadb-queries/','','https://mariadb.com/kb/en/useful-mariadb-queries/'),
(470,'EXPLAIN',28,'Syntax\n------\n\nEXPLAIN tbl_name [col_name | wild]\n\nOr\n\nEXPLAIN [EXTENDED | PARTITIONS | FORMAT=JSON] \n {SELECT select_options | UPDATE update_options | DELETE delete_options}\n\nDescription\n-----------\n\nThe EXPLAIN statement can be used either as a synonym for DESCRIBE or as a way\nto obtain information about how MariaDB executes a SELECT, UPDATE or DELETE\nstatement:\n\n* \'EXPLAIN tbl_name\' is synonymous with \n \'DESCRIBE tbl_name\' or\n \'SHOW COLUMNS FROM tbl_name\'.\n* When you precede a SELECT, UPDATE or a DELETE statement with the keyword \n EXPLAIN, MariaDB displays information from the optimizer\n about the query execution plan. That is, MariaDB explains how it would\n process the SELECT, UPDATE or DELETE, including information about how tables\n are joined and in which order. EXPLAIN EXTENDED can be\n used to provide additional information.\n* EXPLAIN PARTITIONS is useful only when examining queries involving\npartitioned tables. For details, see Partition pruning and selection.\n* ANALYZE statement performs the query as well as producing EXPLAIN output,\nand provides actual as well as estimated statistics.\n* EXPLAIN output can be printed in the slow query log. See EXPLAIN in the Slow\nQuery Log for details.\n\nSHOW EXPLAIN shows the output of a running statement. In some cases, its\noutput can be closer to reality than EXPLAIN.\n\nThe ANALYZE statement runs a statement and returns information about its\nexecution plan. It also shows additional columns, to check how much the\noptimizer\'s estimation about filtering and found rows are close to reality.\n\nThere is an online EXPLAIN Analyzer that you can use to share EXPLAIN and\nEXPLAIN EXTENDED output with others.\n\nEXPLAIN can acquire metadata locks in the same way that SELECT does, as it\nneeds to know table metadata and, sometimes, data as well.\n\nColumns in EXPLAIN ... SELECT\n-----------------------------\n\n+--------------------------------------+--------------------------------------+\n| Column name                          | Description                          |\n+--------------------------------------+--------------------------------------+\n| id                                   | Sequence number that shows in which  |\n|                                      | order tables are joined.             |\n+--------------------------------------+--------------------------------------+\n| select_type                          | What kind of SELECT the table comes  |\n|                                      | from.                                |\n+--------------------------------------+--------------------------------------+\n| table                                | Alias name of table. Materialized    |\n|                                      | temporary tables for sub queries     |\n|                                      | are named <subquery#>                |\n+--------------------------------------+--------------------------------------+\n| type                                 | How rows are found from the table    |\n|                                      | (join type).                         |\n+--------------------------------------+--------------------------------------+\n| possible_keys                        | keys in table that could be used to  |\n|                                      | find rows in the table               |\n+--------------------------------------+--------------------------------------+\n| key                                  | The name of the key that is used to  |\n|                                      | retrieve rows. NULL is no key was    |\n|                                      | used.                                |\n+--------------------------------------+--------------------------------------+\n| key_len                              | How many bytes of the key that was   |\n|                                      | used (shows if we are using only     |\n|                                      | parts of the multi-column key).      |\n+--------------------------------------+--------------------------------------+\n| ref                                  | The reference that is used as the    |\n|                                      | key value.                           |\n+--------------------------------------+--------------------------------------+\n| rows                                 | An estimate of how many rows we      |\n|                                      | will find in the table for each key  |\n|                                      | lookup.                              |\n+--------------------------------------+--------------------------------------+\n| Extra                                | Extra information about this join.   |\n+--------------------------------------+--------------------------------------+\n\nHere are descriptions of the values for some of the more complex columns in\nEXPLAIN ... SELECT:\n\n\"Select_type\" Column\n--------------------\n\nThe select_type column can have the following values:\n\n+-----------------+-----------------------------------+-----------------------+\n| Value           | Description                       | Comment               |\n+-----------------+-----------------------------------+-----------------------+\n| DEPENDENT       | The SUBQUERY is DEPENDENT.        |                       |\n| SUBQUERY        |                                   |                       |\n+-----------------+-----------------------------------+-----------------------+\n| DEPENDENT UNION | The UNION is DEPENDENT.           |                       |\n+-----------------+-----------------------------------+-----------------------+\n| DERIVED         | The SELECT is DERIVED from the    |                       |\n|                 | PRIMARY.                          |                       |\n+-----------------+-----------------------------------+-----------------------+\n| MATERIALIZED    | The SUBQUERY is MATERIALIZED.     | Materialized tables   |\n|                 |                                   | will be populated at  |\n|                 |                                   | first access and      |\n|                 |                                   | will be accessed by   |\n|                 |                                   | the primary key (=    |\n|                 |                                   | one key lookup).      |\n|                 |                                   | Number of rows in     |\n|                 |                                   | EXPLAIN shows the     |\n|                 |                                   | cost of populating    |\n|                 |                                   | the table             |\n+-----------------+-----------------------------------+-----------------------+\n| PRIMARY         | The SELECT is in the outermost    |                       |\n|                 | query, but there is also a        |                       |\n|                 | SUBQUERY within it.               |                       |\n+-----------------+-----------------------------------+-----------------------+\n| SIMPLE          | It is a simple SELECT query       |                       |\n|                 | without any SUBQUERY or UNION.    |                       |\n+-----------------+-----------------------------------+-----------------------+\n| SUBQUERY        | The SELECT is a SUBQUERY of the   |                       |\n|                 | PRIMARY.                          |                       |\n+-----------------+-----------------------------------+-----------------------+\n| UNCACHEABLE     | The SUBQUERY is UNCACHEABLE.      |                       |\n| SUBQUERY        |                                   |                       |\n+-----------------+-----------------------------------+-----------------------+\n| UNCACHEABLE     | The UNION is UNCACHEABLE.         |                       |\n| UNION           |                                   |                       |\n+-----------------+-----------------------------------+-----------------------+\n| UNION           | The SELECT is a UNION of the      |                       |\n|                 | PRIMARY.                          |                       |\n+-----------------+-----------------------------------+-----------------------+\n| UNION RESULT    | The result of the UNION.          |                       |\n+-----------------+-----------------------------------+-----------------------+\n| LATERAL DERIVED | The SELECT uses a Lateral         |                       |\n|                 | Derived optimization              |                       |\n+-----------------+-----------------------------------+-----------------------+\n\n\"Type\" Column\n-------------\n\nThis column contains information on how the table is accessed.\n\n+------------------------+---------------------------------------------------+\n| Value                  | Description                                       |\n+------------------------+---------------------------------------------------+\n| ALL                    | A full table scan is done for the table (all      |\n|                        | rows are read). This is bad if the table is       |\n|                        | large and the table is joined against a previous  |\n|                        | table!  This happens when the optimizer could     |\n|                        | not find any usable index to access rows.         |\n+------------------------+---------------------------------------------------+\n| const                  | There is only one possibly matching row in the    |\n|                        | table. The row is read before the optimization    |\n|                        | phase and all columns in the table are treated    |\n|                        | as constants.                                     |\n+------------------------+---------------------------------------------------+\n| eq_ref                 | A unique index is used to find the rows. This is  |\n|                        | the best possible plan to find the row.           |\n+------------------------+---------------------------------------------------+\n| fulltext               | A fulltext index is used to access the rows.      |\n+------------------------+---------------------------------------------------+\n| index_merge            | A \'range\' access is done for for several index    |\n|                        | and the found rows are merged. The key column     |\n|                        | shows which keys are used.                        |\n+------------------------+---------------------------------------------------+\n| index_subquery         | This is similar as ref, but used for sub queries  |\n|                        | that are transformed to key lookups.              |\n+------------------------+---------------------------------------------------+\n| index                  | A full scan over the used index.  Better than     |\n|                        | ALL but still bad if index is large and the       |\n|                        | table is joined against a previous table.         |\n+------------------------+---------------------------------------------------+\n| range                  | The table will be accessed with a key over one    |\n|                        | or more value ranges.                             |\n+------------------------+---------------------------------------------------+\n| ref_or_null            | Like \'ref\' but in addition another search for     |\n|                        | the \'null\' value is done if the first value was   |\n|                        | not found. This happens usually with sub queries. |\n+------------------------+---------------------------------------------------+\n| ref                    | A non unique index or prefix of an unique index   |\n|                        | is used to find the rows. Good if the prefix      |\n|                        | doesn\'t match many rows.                          |\n+------------------------+---------------------------------------------------+\n| system                 | The table has 0 or 1 rows.                        |\n+------------------------+---------------------------------------------------+\n| unique_subquery        | This is similar as eq_ref, but used for sub       |\n|                        | queries that are transformed to key lookups       |\n+------------------------+---------------------------------------------------+\n\n\"Extra\" Column\n--------------\n\nThis column consists of one or more of the following values, separated by \';\'\n\nNote that some of these values are detected after the optimization phase.\n\nThe optimization phase can do the following changes to the WHERE clause:\n\n* Add the expressions from the ON and USING clauses to the WHERE\n clause.\n* Constant propagation:  If there is column=constant, replace all column\n instances with this constant.\n* Replace all columns from \'const\' tables with their values.\n* Remove the used key columns from the WHERE (as this will be tested as\n part of the key lookup).\n* Remove impossible constant sub expressions.\n For example WHERE \'(a=1 and a=2) OR b=1\' becomes \'b=1\'.\n* Replace columns with other columns that has identical values:\n Example:  WHERE a=b and a=c may be treated\n as \'WHERE a=b and a=c and b=c\'.\n* Add extra conditions to detect impossible row conditions earlier. This\n happens mainly with OUTER JOIN where we in some cases add detection\n of NULL values in the WHERE (Part of \'Not exists\' optimization).\n This can cause an unexpected \'Using where\' in the Extra column.\n* For each table level we remove expressions that have already been tested when\n we read the previous row. Example: When joining tables t1 with t2\n using the following WHERE \'t1.a=1 and t1.a=t2.b\', we don\'t have to\n test \'t1.a=1\' when checking rows in t2 as we already know that this\n expression is true.\n\n+------------------------+---------------------------------------------------+\n| Value                  | Description                                       |\n+------------------------+---------------------------------------------------+\n| const row not found    | The table was a system table (a table with        |\n|                        | should exactly one row), but no row was found.    |\n+------------------------+---------------------------------------------------+\n| Distinct               | If distinct optimization (remove duplicates) was  |\n|                        | used. This is marked only for the last table in   |\n|                        | the SELECT.                                       |\n+------------------------+---------------------------------------------------+\n| Full scan on NULL key  | The table is a part of the sub query and if the   |\n|                        | value that is used to match the sub query will    |\n|                        | be NULL, we will do a full table scan.            |\n+------------------------+---------------------------------------------------+\n| Impossible HAVING      | The used HAVING clause is always false so the     |\n|                        | SELECT will return no rows.                       |\n+------------------------+---------------------------------------------------+\n| Impossible WHERE       | The used WHERE clause is always false so the      |\n| noticed after reading  | SELECT will return no rows. This case was         |\n| const tables.          | detected after we had read all \'const\' tables     |\n|                        | and used the column values as constant in the     |\n|                        | WHERE clause. For example: WHERE const_column=5   |\n|                        | and const_column had a value of 4.                |\n+------------------------+---------------------------------------------------+\n| Impossible WHERE       | The used WHERE clause is always false so the      |\n|                        | SELECT will return no rows. For example: WHERE    |\n|                        | 1=2                                               |\n+------------------------+---------------------------------------------------+\n| No matching min/max    | During early optimization of MIN()/MAX() values   |\n| row                    | it was detected that no row could match the       |\n|                        | WHERE clause. The MIN()/MAX() function will       |\n|                        | return NULL.                                      |\n+------------------------+---------------------------------------------------+\n| no matching row in     | The table was a const table (a table with only    |\n| const table            | one possible matching row), but no row was found. |\n+------------------------+---------------------------------------------------+\n| No tables used         | The SELECT was a sub query that did not use any   |\n|                        | tables. For example a there was no FROM clause    |\n|                        | or a FROM DUAL clause.                            |\n+------------------------+---------------------------------------------------+\n| Not exists             | Stop searching after more row if we find one      |\n|                        | single matching row. This optimization is used    |\n|                        | with LEFT JOIN where one is explicitly searching  |\n|                        | for rows that doesn\'t exists in the LEFT JOIN     |\n|                        | TABLE. Example: SELECT * FROM t1 LEFT JOIN t2 on  |\n|                        | (...) WHERE t2.not_null_column IS NULL.  As       |\n|                        | t2.not_null_column can only be NULL if there was  |\n|                        | no matching row for on condition, we can stop     |\n|                        | searching if we find a single matching row.       |\n+------------------------+---------------------------------------------------+\n| Open_frm_only          | For information_schema tables.  Only the frm      |\n|                        | (table definition file was opened) was opened     |\n|                        | for each matching row.                            |\n+------------------------+---------------------------------------------------+\n| Open_full_table        | For information_schema tables. A full table open  |\n|                        | for each matching row is done to retrieve the     |\n|                        | requested information. (Slow)                     |\n+------------------------+---------------------------------------------------+\n| Open_trigger_only      | For information_schema tables. Only the trigger   |\n|                        | file definition was opened for each matching row. |\n+------------------------+---------------------------------------------------+\n| Range checked for      | This only happens when there was no good default  |\n| each record (index     | index to use but there may some index that could  |\n| map: ...)              | be used when we can treat all columns from        |\n|                        | previous table as constants.  For each row        |\n|                        | combination the optimizer will decide which       |\n|                        | index to use (if any) to fetch a row from this    |\n|                        | table. This is not fast, but faster than a full   |\n|                        | table scan that is the only other choice. The     |\n|                        | index map is a bitmask that shows which index     |\n|                        | are considered for each row condition.            |\n+------------------------+---------------------------------------------------+\n| Scanned 0/1/all        | For information_schema tables. Shows how many     |\n| databases              | times we had to do a directory scan.              |\n+------------------------+---------------------------------------------------+\n| Select tables          | All tables in the join was optimized away. This   |\n| optimized away         | happens when we are only using COUNT(*), MIN()    |\n|                        | and MAX() functions in the SELECT and we where    |\n|                        | able to replace all of these with constants.      |\n+------------------------+---------------------------------------------------+\n| Skip_open_table        | For information_schema tables. The queried table  |\n|                        | didn\'t need to be opened.                         |\n+------------------------+---------------------------------------------------+\n| unique row not found   | The table was detected to be a const table (a     |\n|                        | table with only one possible matching row)        |\n|                        | during the early optimization phase, but no row   |\n|                        | was found.                                        |\n+------------------------+---------------------------------------------------+\n| Using filesort         | Filesort is needed to resolve the query. This     |\n|                        | means an extra phase where we first collect all   |\n|                        | columns to sort, sort them with a disk based      |\n|                        | merge sort and then use the sorted set to         |\n|                        | retrieve the rows in sorted order. If the column  |\n|                        | set is small, we store all the columns in the     |\n|                        | sort file to not have to go to the database to    |\n|                        | retrieve them again.                              |\n+------------------------+---------------------------------------------------+\n| Using index            | Only the index is used to retrieve the needed     |\n|                        | information from the table. There is no need to   |\n|                        | perform an extra seek to retrieve the actual      |\n|                        | record.                                           |\n+------------------------+---------------------------------------------------+\n| Using index condition  | Like \'Using where\' but the where condition is     |\n|                        | pushed down to the table engine for internal      |\n|                        | optimization at the index level.                  |\n+------------------------+---------------------------------------------------+\n| Using index            | Like \'Using index condition\' but in addition we   |\n| condition(BKA)         | use batch key access to retrieve rows.            |\n+------------------------+---------------------------------------------------+\n| Using index for        | The index is being used to resolve a GROUP BY or  |\n| group-by               | DISTINCT query. The rows are not read.  This is   |\n|                        | very efficient if the table has a lot of          |\n|                        | identical index entries as duplicates are         |\n|                        | quickly jumped over.                              |\n+------------------------+---------------------------------------------------+\n| Using intersect(...)   | For index_merge joins. Shows which index are      |\n|                        | part of the intersect.                            |\n+------------------------+---------------------------------------------------+\n| Using join buffer      | We store previous row combinations in a row       |\n|                        | buffer to be able to match each row against all   |\n|                        | of the rows combinations in the join buffer at    |\n|                        | one go.                                           |\n+------------------------+---------------------------------------------------+\n| Using sort_union(...)  | For index_merge joins. Shows which index are      |\n|                        | part of the union.                                |\n+------------------------+---------------------------------------------------+\n| Using temporary        | A temporary table is created to hold the result.  |\n|                        | This typically happens if you are using GROUP     |\n|                        | BY, DISTINCT or ORDER BY.                         |\n+------------------------+---------------------------------------------------+\n| Using where            | A WHERE expression (in additional to the          |\n|                        | possible key lookup) is used to check if the row  |\n|                        | should be accepted. If you don\'t have \'Using      |\n|                        | where\' together with a join type of ALL, you are  |\n|                        | probably doing something wrong!                   |\n+------------------------+---------------------------------------------------+\n| Using where with       | Like \'Using where\' but the where condition is     |\n| pushed condition       | pushed down to the table engine for internal      |\n|                        | optimization at the row level.                    |\n+------------------------+---------------------------------------------------+\n| Using buffer           | The UPDATE statement will first buffer the rows,  |\n|                        | and then run the updates, rather than do updates  |\n|                        | on the fly. See Using Buffer UPDATE Algorithm     |\n|                        | for a detailed explanation.                       |\n+------------------------+---------------------------------------------------+\n\nEXPLAIN EXTENDED\n----------------\n\nThe EXTENDED keyword adds another column, filtered, to the output. This is a\npercentage estimate of the table rows that will be filtered by the condition.\n\nAn EXPLAIN EXTENDED will always throw a warning, as it adds extra Message\ninformation to a subsequent SHOW WARNINGS statement. This includes what the\nSELECT query would look like after optimizing and rewriting rules are applied\nand how the optimizer qualifies columns and tables.\n\nExamples\n--------\n\nAs synonym for DESCRIBE or SHOW COLUMNS FROM:\n\nDESCRIBE city;\n+------------+----------+------+-----+---------+----------------+\n| Field      | Type     | Null | Key | Default | Extra          |\n+------------+----------+------+-----+---------+----------------+\n| Id         | int(11)  | NO   | PRI | NULL    | auto_increment |\n| Name       | char(35) | YES  |     | NULL    |                |\n| Country    | char(3)  | NO   | UNI |         |                |\n| District   | char(20) | YES  | MUL |         |                |\n| Population | int(11)  | YES  |     | NULL    |                |\n+------------+----------+------+-----+---------+----------------+\n\nA simple set of examples to see how EXPLAIN can identify poor index usage:\n\nCREATE TABLE IF NOT EXISTS `employees_example` (\n `id` int(11) NOT NULL AUTO_INCREMENT,\n `first_name` varchar(30) NOT NULL,\n `last_name` varchar(40) NOT NULL,\n `position` varchar(25) NOT NULL,\n `home_address` varchar(50) NOT NULL,\n `home_phone` varchar(12) NOT NULL,\n `employee_code` varchar(25) NOT NULL,\n PRIMARY KEY (`id`),\n UNIQUE KEY `employee_code` (`employee_code`),\n KEY `first_name` (`first_name`,`last_name`)\n) ENGINE=Aria;\n\nINSERT INTO `employees_example` (`first_name`, `last_name`, `position`,\n`home_address`, `home_phone`, `employee_code`)\n VALUES\n (\'Mustapha\', \'Mond\', \'Chief Executive Officer\', \'692 Promiscuous Plaza\',\n\'326-555-3492\', \'MM1\'),\n (\'Henry\', \'Foster\', \'Store Manager\', \'314 Savage Circle\', \'326-555-3847\',\n\'HF1\'),\n (\'Bernard\', \'Marx\', \'Cashier\', \'1240 Ambient Avenue\', \'326-555-8456\', \'BM1\'),\n (\'Lenina\', \'Crowne\', \'Cashier\', \'281 Bumblepuppy Boulevard\', \'328-555-2349\',\n\'LC1\'),\n (\'Fanny\', \'Crowne\', \'Restocker\', \'1023 Bokanovsky Lane\', \'326-555-6329\',\n\'FC1\'),\n (\'Helmholtz\', \'Watson\', \'Janitor\', \'944 Soma Court\', \'329-555-2478\', \'HW1\');\n\nSHOW INDEXES FROM employees_example;\n+-------------------+------------+---------------+--------------+--------------\n+-----------+-------------+----------+--------+------+------------+---------+--\n------------+\n| Table             | Non_unique | Key_name      | Seq_in_index | Column_name \n | Collation | Cardinality | Sub_part | Packed | Null | Index_type | Comment |\nIndex_comment |\n+-------------------+------------+---------------+--------------+--------------\n+-----------+-------------+----------+--------+------+------------+---------+--\n------------+\n| employees_example |          0 | PRIMARY       |            1 | id          \n | A         |           7 |     NULL | NULL   |      | BTREE      |         |\n       |\n| employees_example |          0 | employee_code |            1 |\nemployee_code | A         |           7 |     NULL | NULL   |      | BTREE    \n |         |               |\n| employees_example |          1 | first_name    |            1 | first_name  \n | A         |        NULL |     NULL | NULL   |      | BTREE      |         |\n       |\n| employees_example |          1 | first_name    |            2 | last_name   \n | A         |        NULL |     NULL | NULL   |      | BTREE      |         |\n       |\n+-------------------+------------+---------------+--------------+--------------\n+-----------+-------------+----------+--------+------+------------+---------+--\n------------+\n\nSELECT on a primary key:\n\nEXPLAIN SELECT * FROM employees_example WHERE id=1;\n+------+-------------+-------------------+-------+---------------+---------+---\n-----+-------+------+-------+\n| id   | select_type | table             | type  | possible_keys | key     |\nkey_len | ref   | rows | Extra |\n+------+-------------+-------------------+-------+---------------+---------+---\n-----+-------+------+-------+\n|    1 | SIMPLE      | employees_example | const | PRIMARY       | PRIMARY | 4\n   | const |    1 |       |\n+------+-------------+-------------------+-------+---------------+---------+---\n-----+-------+------+-------+\n\nThe type is const, which means that only one possible result could be\nreturned. Now, returning the same record but searching by their phone number:\n\nEXPLAIN SELECT * FROM employees_example WHERE home_phone=\'326-555-3492\';\n+------+-------------+-------------------+------+---------------+------+-------\n-+------+------+-------------+\n| id   | select_type | table             | type | possible_keys | key  |\nkey_len | ref  | rows | Extra       |\n+------+-------------+-------------------+------+---------------+------+-------\n-+------+------+-------------+\n|    1 | SIMPLE      | employees_example | ALL  | NULL          | NULL | NULL \n | NULL |    6 | Using where |\n+------+-------------+-------------------+------+---------------+------+-------\n-+------+------+-------------+\n\nHere, the type is All, which means no index could be used. Looking at the rows\ncount, a full table scan (all six rows) had to be performed in order to\nretrieve the record. If it\'s a requirement to search by phone number, an index\nwill have to be created.\n\nSHOW EXPLAIN example:\n\nSHOW EXPLAIN FOR 1;\n+------+-------------+-------+-------+---------------+------+---------+------+-\n-------+-------------+\n| id   | select_type | table | type  | possible_keys | key  | key_len | ref  |\nrows    | Extra       |\n+------+-------------+-------+-------+---------------+------+---------+------+-\n-------+-------------+\n|    1 | SIMPLE      | tbl   | index | NULL          | a    | 5       | NULL |\n1000107 | Using index |\n+------+-------------+-------+-------+---------------+------+---------+------+-\n-------+-------------+\n1 row in set, 1 warning (0.00 sec)\n\nExample of ref_or_null Optimization\n-----------------------------------\n\nSELECT * FROM table_name\n WHERE key_column=expr OR key_column IS NULL;\n\nref_or_null is something that often happens when you use subqueries with NOT\nIN as then one has to do an extra check for NULL values if the first value\ndidn\'t have a matching row.\n\nURL: https://mariadb.com/kb/en/explain/','','https://mariadb.com/kb/en/explain/'),
(471,'EXPLAIN ANALYZE',28,'The syntax for the EXPLAIN ANALYZE feature was changed to ANALYZE statement,\navailable since MariaDB 10.1.0. See ANALYZE statement.\n\nURL: https://mariadb.com/kb/en/explain-analyze/','','https://mariadb.com/kb/en/explain-analyze/'),
(476,'Binary Literals',29,'Binary literals can be written in one of the following formats: b\'value\',\nB\'value\' or 0bvalue, where value is a string composed by 0 and 1 digits.\n\nBinary literals are interpreted as binary strings, and are convenient to\nrepresent VARBINARY, BINARY or BIT values.\n\nTo convert a binary literal into an integer, just add 0.\n\nExamples\n--------\n\nPrinting the value as a binary string:\n\nSELECT 0b1000001;\n+-----------+\n| 0b1000001 |\n+-----------+\n| A         |\n+-----------+\n\nConverting the same value into a number:\n\nSELECT 0b1000001+0;\n+-------------+\n| 0b1000001+0 |\n+-------------+\n|          65 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/binary-literals/','','https://mariadb.com/kb/en/binary-literals/'),
(201,'DECODE_HISTOGRAM',17,'Syntax\n------\n\nDECODE_HISTOGRAM(hist_type,histogram)\n\nDescription\n-----------\n\nReturns a string of comma separated numeric values corresponding to a\nprobability distribution represented by the histogram of type hist_type\n(SINGLE_PREC_HB or DOUBLE_PREC_HB). The hist_type and histogram would be\ncommonly used from the mysql.column_stats table.\n\nSee Histogram Based Statistics for details.\n\nExamples\n--------\n\nCREATE TABLE origin (\n i INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,\n v INT UNSIGNED NOT NULL\n);\n\nINSERT INTO origin(v) VALUES \n (1),(2),(3),(4),(5),(10),(20),\n (30),(40),(50),(60),(70),(80),\n (90),(100),(200),(400),(800);\n\nSET histogram_size=10,histogram_type=SINGLE_PREC_HB;\n\nANALYZE TABLE origin PERSISTENT FOR ALL;\n+-------------+---------+----------+-----------------------------------------+\n| Table       | Op      | Msg_type | Msg_text                                |\n+-------------+---------+----------+-----------------------------------------+\n| test.origin | analyze | status   | Engine-independent statistics collected |\n| test.origin | analyze | status   | OK                                      |\n+-------------+---------+----------+-----------------------------------------+\n\nSELECT db_name,table_name,column_name,hist_type,\n hex(histogram),decode_histogram(hist_type,histogram)\n FROM mysql.column_stats WHERE db_name=\'test\' and table_name=\'origin\';\n+---------+------------+-------------+----------------+----------------------+-\n-----------------------------------------------------------------+\n| db_name | table_name | column_name | hist_type      | hex(histogram)       |\ndecode_histogram(hist_type,histogram)                             |\n+---------+------------+-------------+----------------+----------------------+-\n-----------------------------------------------------------------+\n| test    | origin     | i           | SINGLE_PREC_HB | 0F2D3C5A7887A5C3D2F0 |\n0.059,0.118,0.059,0.118,0.118,0.059,0.118,0.118,0.059,0.118,0.059 |\n| test    | origin     | v           | SINGLE_PREC_HB | 000001060C0F161C1F7F |\n0.000,0.000,0.004,0.020,0.024,0.012,0.027,0.024,0.012,0.376,0.502 |\n+---------+------------+-------------+----------------+----------------------+-\n-----------------------------------------------------------------+\n\nSET histogram_size=20,histogram_type=DOUBLE_PREC_HB;\n\nANALYZE TABLE origin PERSISTENT FOR ALL;\n+-------------+---------+----------+-----------------------------------------+\n| Table       | Op      | Msg_type | Msg_text                                |\n+-------------+---------+----------+-----------------------------------------+\n| test.origin | analyze | status   | Engine-independent statistics collected |\n| test.origin | analyze | status   | OK                                      |\n+-------------+---------+----------+-----------------------------------------+\n\nSELECT db_name,table_name,column_name,\n hist_type,hex(histogram),decode_histogram(hist_type,histogram)\n FROM mysql.column_stats WHERE db_name=\'test\' and table_name=\'origin\';\n+---------+------------+-------------+----------------+------------------------\n-----------------+-------------------------------------------------------------\n---------------------------+\n| db_name | table_name | column_name | hist_type      | hex(histogram)        \n         | decode_histogram(hist_type,histogram)\n              |\n+---------+------------+-------------+----------------+------------------------\n-----------------+-------------------------------------------------------------\n---------------------------+\n| test    | origin     | i           | DOUBLE_PREC_HB |\n0F0F2D2D3C3C5A5A78788787A5A5C3C3D2D2F0F0 |\n0.05882,0.11765,0.05882,0.11765,0.11765,0.05882,0.11765,0.11765,0.05882,0.11765\n0.05882 |\n| test    | origin     | v           | DOUBLE_PREC_HB |\n5200F600480116067E0CB30F1B16831CB81FD67F |\n0.00125,0.00250,0.00125,0.01877,0.02502,0.01253,0.02502,0.02502,0.01253,0.37546\n0.50063 |\n\nURL: https://mariadb.com/kb/en/decode_histogram/','','https://mariadb.com/kb/en/decode_histogram/'),
(206,'PROCEDURE ANALYSE',17,'Syntax\n------\n\nanalyse([max_elements[,max_memory]])\n\nDescription\n-----------\n\nThis procedure is defined in the sql/sql_analyse.cc file. It examines the\nresult from a query and returns an analysis of the results that suggests\noptimal data types for each column. To obtain this analysis, append PROCEDURE\nANALYSE to the end of a SELECT statement:\n\nSELECT ... FROM ... WHERE ... PROCEDURE ANALYSE([max_elements,[max_memory]])\n\nFor example:\n\nSELECT col1, col2 FROM table1 PROCEDURE ANALYSE(10, 2000);\n\nThe results show some statistics for the values returned by the query, and\npropose an optimal data type for the columns. This can be helpful for checking\nyour existing tables, or after importing new data. You may need to try\ndifferent settings for the arguments so that PROCEDURE ANALYSE() does not\nsuggest the ENUM data type when it is not appropriate.\n\nThe arguments are optional and are used as follows:\n\n* max_elements (default 256) is the maximum number of distinct values that\nanalyse notices per column. This is used by analyse to check whether the\noptimal data type should be of type ENUM; if there are more than max_elements\ndistinct values, then ENUM is not a suggested type.\n* max_memory (default 8192) is the maximum amount of memory that analyse\nshould allocate per column while trying to find all distinct values.\n\nURL: https://mariadb.com/kb/en/procedure-analyse/','','https://mariadb.com/kb/en/procedure-analyse/'),
(477,'Boolean Literals',29,'In MariaDB, FALSE is a synonym of 0 and TRUE is a synonym of 1. These\nconstants are case insensitive, so TRUE, True, and true are equivalent.\n\nThese terms are not synonyms of 0 and 1 when used with the IS operator. So,\nfor example, 10 IS TRUE returns 1, while 10 = TRUE returns 0 (because 1 != 10).\n\nThe IS operator accepts a third constant exists: UNKNOWN. It is always a\nsynonym of NULL.\n\nTRUE and FALSE are reserved words, while UNKNOWN is not.\n\nURL: https://mariadb.com/kb/en/sql-language-structure-boolean-literals/','','https://mariadb.com/kb/en/sql-language-structure-boolean-literals/'),
(483,'Reserved Words',29,'The following is a list of all reserved words in MariaDB.\n\nReserved words cannot be used as Identifiers, unless they are quoted.\n\nThe definitive list of reserved words for each version can be found by\nexamining the sql/lex.h and sql/sql_yacc.yy files.\n\nReserved Words\n--------------\n\n+--------------------------------------------+--------------------------------+\n| Keyword                                    | Notes                          |\n+--------------------------------------------+--------------------------------+\n| ACCESSIBLE                                 |                                |\n+--------------------------------------------+--------------------------------+\n| ADD                                        |                                |\n+--------------------------------------------+--------------------------------+\n| ALL                                        |                                |\n+--------------------------------------------+--------------------------------+\n| ALTER                                      |                                |\n+--------------------------------------------+--------------------------------+\n| ANALYZE                                    |                                |\n+--------------------------------------------+--------------------------------+\n| AND                                        |                                |\n+--------------------------------------------+--------------------------------+\n| AS                                         |                                |\n+--------------------------------------------+--------------------------------+\n| ASC                                        |                                |\n+--------------------------------------------+--------------------------------+\n| ASENSITIVE                                 |                                |\n+--------------------------------------------+--------------------------------+\n| BEFORE                                     |                                |\n+--------------------------------------------+--------------------------------+\n| BETWEEN                                    |                                |\n+--------------------------------------------+--------------------------------+\n| BIGINT                                     |                                |\n+--------------------------------------------+--------------------------------+\n| BINARY                                     |                                |\n+--------------------------------------------+--------------------------------+\n| BLOB                                       |                                |\n+--------------------------------------------+--------------------------------+\n| BOTH                                       |                                |\n+--------------------------------------------+--------------------------------+\n| BY                                         |                                |\n+--------------------------------------------+--------------------------------+\n| CALL                                       |                                |\n+--------------------------------------------+--------------------------------+\n| CASCADE                                    |                                |\n+--------------------------------------------+--------------------------------+\n| CASE                                       |                                |\n+--------------------------------------------+--------------------------------+\n| CHANGE                                     |                                |\n+--------------------------------------------+--------------------------------+\n| CHAR                                       |                                |\n+--------------------------------------------+--------------------------------+\n| CHARACTER                                  |                                |\n+--------------------------------------------+--------------------------------+\n| CHECK                                      |                                |\n+--------------------------------------------+--------------------------------+\n| COLLATE                                    |                                |\n+--------------------------------------------+--------------------------------+\n| COLUMN                                     |                                |\n+--------------------------------------------+--------------------------------+\n| CONDITION                                  |                                |\n+--------------------------------------------+--------------------------------+\n| CONSTRAINT                                 |                                |\n+--------------------------------------------+--------------------------------+\n| CONTINUE                                   |                                |\n+--------------------------------------------+--------------------------------+\n| CONVERT                                    |                                |\n+--------------------------------------------+--------------------------------+\n| CREATE                                     |                                |\n+--------------------------------------------+--------------------------------+\n| CROSS                                      |                                |\n+--------------------------------------------+--------------------------------+\n| CURRENT_DATE                               |                                |\n+--------------------------------------------+--------------------------------+\n| CURRENT_ROLE                               |                                |\n+--------------------------------------------+--------------------------------+\n| CURRENT_TIME                               |                                |\n+--------------------------------------------+--------------------------------+\n| CURRENT_TIMESTAMP                          |                                |\n+--------------------------------------------+--------------------------------+\n| CURRENT_USER                               |                                |\n+--------------------------------------------+--------------------------------+\n| CURSOR                                     |                                |\n+--------------------------------------------+--------------------------------+\n| DATABASE                                   |                                |\n+--------------------------------------------+--------------------------------+\n| DATABASES                                  |                                |\n+--------------------------------------------+--------------------------------+\n| DAY_HOUR                                   |                                |\n+--------------------------------------------+--------------------------------+\n| DAY_MICROSECOND                            |                                |\n+--------------------------------------------+--------------------------------+\n| DAY_MINUTE                                 |                                |\n+--------------------------------------------+--------------------------------+\n| DAY_SECOND                                 |                                |\n+--------------------------------------------+--------------------------------+\n| DEC                                        |                                |\n+--------------------------------------------+--------------------------------+\n| DECIMAL                                    |                                |\n+--------------------------------------------+--------------------------------+\n| DECLARE                                    |                                |\n+--------------------------------------------+--------------------------------+\n| DEFAULT                                    |                                |\n+--------------------------------------------+--------------------------------+\n| DELAYED                                    |                                |\n+--------------------------------------------+--------------------------------+\n| DELETE                                     |                                |\n+--------------------------------------------+--------------------------------+\n| DELETE_DOMAIN_ID                           |                                |\n+--------------------------------------------+--------------------------------+\n| DESC                                       |                                |\n+--------------------------------------------+--------------------------------+\n| DESCRIBE                                   |                                |\n+--------------------------------------------+--------------------------------+\n| DETERMINISTIC                              |                                |\n+--------------------------------------------+--------------------------------+\n| DISTINCT                                   |                                |\n+--------------------------------------------+--------------------------------+\n| DISTINCTROW                                |                                |\n+--------------------------------------------+--------------------------------+\n| DIV                                        |                                |\n+--------------------------------------------+--------------------------------+\n| DO_DOMAIN_IDS                              |                                |\n+--------------------------------------------+--------------------------------+\n| DOUBLE                                     |                                |\n+--------------------------------------------+--------------------------------+\n| DROP                                       |                                |\n+--------------------------------------------+--------------------------------+\n| DUAL                                       |                                |\n+--------------------------------------------+--------------------------------+\n| EACH                                       |                                |\n+--------------------------------------------+--------------------------------+\n| ELSE                                       |                                |\n+--------------------------------------------+--------------------------------+\n| ELSEIF                                     |                                |\n+--------------------------------------------+--------------------------------+\n| ENCLOSED                                   |                                |\n+--------------------------------------------+--------------------------------+\n| ESCAPED                                    |                                |\n+--------------------------------------------+--------------------------------+\n| EXCEPT                                     | Added in MariaDB 10.3.0        |\n+--------------------------------------------+--------------------------------+\n| EXISTS                                     |                                |\n+--------------------------------------------+--------------------------------+\n| EXIT                                       |                                |\n+--------------------------------------------+--------------------------------+\n| EXPLAIN                                    |                                |\n+--------------------------------------------+--------------------------------+\n| FALSE                                      |                                |\n+--------------------------------------------+--------------------------------+\n| FETCH                                      |                                |\n+--------------------------------------------+--------------------------------+\n| FLOAT                                      |                                |\n+--------------------------------------------+--------------------------------+\n| FLOAT4                                     |                                |\n+--------------------------------------------+--------------------------------+\n| FLOAT8                                     |                                |\n+--------------------------------------------+--------------------------------+\n| FOR                                        |                                |\n+--------------------------------------------+--------------------------------+\n| FORCE                                      |                                |\n+--------------------------------------------+--------------------------------+\n| FOREIGN                                    |                                |\n+--------------------------------------------+--------------------------------+\n| FROM                                       |                                |\n+--------------------------------------------+--------------------------------+\n| FULLTEXT                                   |                                |\n+--------------------------------------------+--------------------------------+\n| GENERAL                                    |                                |\n+--------------------------------------------+--------------------------------+\n| GRANT                                      |                                |\n+--------------------------------------------+--------------------------------+\n| GROUP                                      |                                |\n+--------------------------------------------+--------------------------------+\n| HAVING                                     |                                |\n+--------------------------------------------+--------------------------------+\n| HIGH_PRIORITY                              |                                |\n+--------------------------------------------+--------------------------------+\n| HOUR_MICROSECOND                           |                                |\n+--------------------------------------------+--------------------------------+\n| HOUR_MINUTE                                |                                |\n+--------------------------------------------+--------------------------------+\n| HOUR_SECOND                                |                                |\n+--------------------------------------------+--------------------------------+\n| IF                                         |                                |\n+--------------------------------------------+--------------------------------+\n| IGNORE                                     |                                |\n+--------------------------------------------+--------------------------------+\n| IGNORE_DOMAIN_IDS                          |                                |\n+--------------------------------------------+--------------------------------+\n| IGNORE_SERVER_IDS                          |                                |\n+--------------------------------------------+--------------------------------+\n| IN                                         |                                |\n+--------------------------------------------+--------------------------------+\n| INDEX                                      |                                |\n+--------------------------------------------+--------------------------------+\n| INFILE                                     |                                |\n+--------------------------------------------+--------------------------------+\n| INNER                                      |                                |\n+--------------------------------------------+--------------------------------+\n| INOUT                                      |                                |\n+--------------------------------------------+--------------------------------+\n| INSENSITIVE                                |                                |\n+--------------------------------------------+--------------------------------+\n| INSERT                                     |                                |\n+--------------------------------------------+--------------------------------+\n| INT                                        |                                |\n+--------------------------------------------+--------------------------------+\n| INT1                                       |                                |\n+--------------------------------------------+--------------------------------+\n| INT2                                       |                                |\n+--------------------------------------------+--------------------------------+\n| INT3                                       |                                |\n+--------------------------------------------+--------------------------------+\n| INT4                                       |                                |\n+--------------------------------------------+--------------------------------+\n| INT8                                       |                                |\n+--------------------------------------------+--------------------------------+\n| INTEGER                                    |                                |\n+--------------------------------------------+--------------------------------+\n| INTERSECT                                  | Added in MariaDB 10.3.0        |\n+--------------------------------------------+--------------------------------+\n| INTERVAL                                   |                                |\n+--------------------------------------------+--------------------------------+\n| INTO                                       |                                |\n+--------------------------------------------+--------------------------------+\n| IS                                         |                                |\n+--------------------------------------------+--------------------------------+\n| ITERATE                                    |                                |\n+--------------------------------------------+--------------------------------+\n| JOIN                                       |                                |\n+--------------------------------------------+--------------------------------+\n| KEY                                        |                                |\n+--------------------------------------------+--------------------------------+\n| KEYS                                       |                                |\n+--------------------------------------------+--------------------------------+\n| KILL                                       |                                |\n+--------------------------------------------+--------------------------------+\n| LEADING                                    |                                |\n+--------------------------------------------+--------------------------------+\n| LEAVE                                      |                                |\n+--------------------------------------------+--------------------------------+\n| LEFT                                       |                                |\n+--------------------------------------------+--------------------------------+\n| LIKE                                       |                                |\n+--------------------------------------------+--------------------------------+\n| LIMIT                                      |                                |\n+--------------------------------------------+--------------------------------+\n| LINEAR                                     |                                |\n+--------------------------------------------+--------------------------------+\n| LINES                                      |                                |\n+--------------------------------------------+--------------------------------+\n| LOAD                                       |                                |\n+--------------------------------------------+--------------------------------+\n| LOCALTIME                                  |                                |\n+--------------------------------------------+--------------------------------+\n| LOCALTIMESTAMP                             |                                |\n+--------------------------------------------+--------------------------------+\n| LOCK                                       |                                |\n+--------------------------------------------+--------------------------------+\n| LONG                                       |                                |\n+--------------------------------------------+--------------------------------+\n| LONGBLOB                                   |                                |\n+--------------------------------------------+--------------------------------+\n| LONGTEXT                                   |                                |\n+--------------------------------------------+--------------------------------+\n| LOOP                                       |                                |\n+--------------------------------------------+--------------------------------+\n| LOW_PRIORITY                               |                                |\n+--------------------------------------------+--------------------------------+\n| MASTER_HEARTBEAT_PERIOD                    |                                |\n+--------------------------------------------+--------------------------------+\n| MASTER_SSL_VERIFY_SERVER_CERT              |                                |\n+--------------------------------------------+--------------------------------+\n| MATCH                                      |                                |\n+--------------------------------------------+--------------------------------+\n| MAXVALUE                                   |                                |\n+--------------------------------------------+--------------------------------+\n| MEDIUMBLOB                                 |                                |\n+--------------------------------------------+--------------------------------+\n| MEDIUMINT                                  |                                |\n+--------------------------------------------+--------------------------------+\n| MEDIUMTEXT                                 |                                |\n+--------------------------------------------+--------------------------------+\n| MIDDLEINT                                  |                                |\n+--------------------------------------------+--------------------------------+\n| MINUTE_MICROSECOND                         |                                |\n+--------------------------------------------+--------------------------------+\n| MINUTE_SECOND                              |                                |\n+--------------------------------------------+--------------------------------+\n| MOD                                        |                                |\n+--------------------------------------------+--------------------------------+\n| MODIFIES                                   |                                |\n+--------------------------------------------+--------------------------------+\n| NATURAL                                    |                                |\n+--------------------------------------------+--------------------------------+\n| NOT                                        |                                |\n+--------------------------------------------+--------------------------------+\n| NO_WRITE_TO_BINLOG                         |                                |\n+--------------------------------------------+--------------------------------+\n| NULL                                       |                                |\n+--------------------------------------------+--------------------------------+\n| NUMERIC                                    |                                |\n+--------------------------------------------+--------------------------------+\n| OFFSET                                     | Added in MariaDB 10.6.0        |\n+--------------------------------------------+--------------------------------+\n| ON                                         |                                |\n+--------------------------------------------+--------------------------------+\n| OPTIMIZE                                   |                                |\n+--------------------------------------------+--------------------------------+\n| OPTION                                     |                                |\n+--------------------------------------------+--------------------------------+\n| OPTIONALLY                                 |                                |\n+--------------------------------------------+--------------------------------+\n| OR                                         |                                |\n+--------------------------------------------+--------------------------------+\n| ORDER                                      |                                |\n+--------------------------------------------+--------------------------------+\n| OUT                                        |                                |\n+--------------------------------------------+--------------------------------+\n| OUTER                                      |                                |\n+--------------------------------------------+--------------------------------+\n| OUTFILE                                    |                                |\n+--------------------------------------------+--------------------------------+\n| OVER                                       |                                |\n+--------------------------------------------+--------------------------------+\n| PAGE_CHECKSUM                              |                                |\n+--------------------------------------------+--------------------------------+\n| PARSE_VCOL_EXPR                            |                                |\n+--------------------------------------------+--------------------------------+\n| PARTITION                                  |                                |\n+--------------------------------------------+--------------------------------+\n| POSITION                                   |                                |\n+--------------------------------------------+--------------------------------+\n| PRECISION                                  |                                |\n+--------------------------------------------+--------------------------------+\n| PRIMARY                                    |                                |\n+--------------------------------------------+--------------------------------+\n| PROCEDURE                                  |                                |\n+--------------------------------------------+--------------------------------+\n| PURGE                                      |                                |\n+--------------------------------------------+--------------------------------+\n| RANGE                                      |                                |\n+--------------------------------------------+--------------------------------+\n| READ                                       |                                |\n+--------------------------------------------+--------------------------------+\n| READS                                      |                                |\n+--------------------------------------------+--------------------------------+\n| READ_WRITE                                 |                                |\n+--------------------------------------------+--------------------------------+\n| REAL                                       |                                |\n+--------------------------------------------+--------------------------------+\n| RECURSIVE                                  |                                |\n+--------------------------------------------+--------------------------------+\n| REF_SYSTEM_ID                              |                                |\n+--------------------------------------------+--------------------------------+\n| REFERENCES                                 |                                |\n+--------------------------------------------+--------------------------------+\n| REGEXP                                     |                                |\n+--------------------------------------------+--------------------------------+\n| RELEASE                                    |                                |\n+--------------------------------------------+--------------------------------+\n| RENAME                                     |                                |\n+--------------------------------------------+--------------------------------+\n| REPEAT                                     |                                |\n+--------------------------------------------+--------------------------------+\n| REPLACE                                    |                                |\n+--------------------------------------------+--------------------------------+\n| REQUIRE                                    |                                |\n+--------------------------------------------+--------------------------------+\n| RESIGNAL                                   |                                |\n+--------------------------------------------+--------------------------------+\n| RESTRICT                                   |                                |\n+--------------------------------------------+--------------------------------+\n| RETURN                                     |                                |\n+--------------------------------------------+--------------------------------+\n| RETURNING                                  |                                |\n+--------------------------------------------+--------------------------------+\n| REVOKE                                     |                                |\n+--------------------------------------------+--------------------------------+\n| RIGHT                                      |                                |\n+--------------------------------------------+--------------------------------+\n| RLIKE                                      |                                |\n+--------------------------------------------+--------------------------------+\n| ROW_NUMBER                                 | From MariaDB 10.7              |\n+--------------------------------------------+--------------------------------+\n| ROWS                                       |                                |\n+--------------------------------------------+--------------------------------+\n| SCHEMA                                     |                                |\n+--------------------------------------------+--------------------------------+\n| SCHEMAS                                    |                                |\n+--------------------------------------------+--------------------------------+\n| SECOND_MICROSECOND                         |                                |\n+--------------------------------------------+--------------------------------+\n| SELECT                                     |                                |\n+--------------------------------------------+--------------------------------+\n| SENSITIVE                                  |                                |\n+--------------------------------------------+--------------------------------+\n| SEPARATOR                                  |                                |\n+--------------------------------------------+--------------------------------+\n| SET                                        |                                |\n+--------------------------------------------+--------------------------------+\n| SHOW                                       |                                |\n+--------------------------------------------+--------------------------------+\n| SIGNAL                                     |                                |\n+--------------------------------------------+--------------------------------+\n| SLOW                                       |                                |\n+--------------------------------------------+--------------------------------+\n| SMALLINT                                   |                                |\n+--------------------------------------------+--------------------------------+\n| SPATIAL                                    |                                |\n+--------------------------------------------+--------------------------------+\n| SPECIFIC                                   |                                |\n+--------------------------------------------+--------------------------------+\n| SQL                                        |                                |\n+--------------------------------------------+--------------------------------+\n| SQLEXCEPTION                               |                                |\n+--------------------------------------------+--------------------------------+\n| SQLSTATE                                   |                                |\n+--------------------------------------------+--------------------------------+\n| SQLWARNING                                 |                                |\n+--------------------------------------------+--------------------------------+\n| SQL_BIG_RESULT                             |                                |\n+--------------------------------------------+--------------------------------+\n| SQL_CALC_FOUND_ROWS                        |                                |\n+--------------------------------------------+--------------------------------+\n| SQL_SMALL_RESULT                           |                                |\n+--------------------------------------------+--------------------------------+\n| SSL                                        |                                |\n+--------------------------------------------+--------------------------------+\n| STARTING                                   |                                |\n+--------------------------------------------+--------------------------------+\n| STATS_AUTO_RECALC                          |                                |\n+--------------------------------------------+--------------------------------+\n| STATS_PERSISTENT                           |                                |\n+--------------------------------------------+--------------------------------+\n| STATS_SAMPLE_PAGES                         |                                |\n+--------------------------------------------+--------------------------------+\n| STRAIGHT_JOIN                              |                                |\n+--------------------------------------------+--------------------------------+\n| TABLE                                      |                                |\n+--------------------------------------------+--------------------------------+\n| TERMINATED                                 |                                |\n+--------------------------------------------+--------------------------------+\n| THEN                                       |                                |\n+--------------------------------------------+--------------------------------+\n| TINYBLOB                                   |                                |\n+--------------------------------------------+--------------------------------+\n| TINYINT                                    |                                |\n+--------------------------------------------+--------------------------------+\n| TINYTEXT                                   |                                |\n+--------------------------------------------+--------------------------------+\n| TO                                         |                                |\n+--------------------------------------------+--------------------------------+\n| TRAILING                                   |                                |\n+--------------------------------------------+--------------------------------+\n| TRIGGER                                    |                                |\n+--------------------------------------------+--------------------------------+\n| TRUE                                       |                                |\n+--------------------------------------------+--------------------------------+\n| UNDO                                       |                                |\n+--------------------------------------------+--------------------------------+\n| UNION                                      |                                |\n+--------------------------------------------+--------------------------------+\n| UNIQUE                                     |                                |\n+--------------------------------------------+--------------------------------+\n| UNLOCK                                     |                                |\n+--------------------------------------------+--------------------------------+\n| UNSIGNED                                   |                                |\n+--------------------------------------------+--------------------------------+\n| UPDATE                                     |                                |\n+--------------------------------------------+--------------------------------+\n| USAGE                                      |                                |\n+--------------------------------------------+--------------------------------+\n| USE                                        |                                |\n+--------------------------------------------+--------------------------------+\n| USING                                      |                                |\n+--------------------------------------------+--------------------------------+\n| UTC_DATE                                   |                                |\n+--------------------------------------------+--------------------------------+\n| UTC_TIME                                   |                                |\n+--------------------------------------------+--------------------------------+\n| UTC_TIMESTAMP                              |                                |\n+--------------------------------------------+--------------------------------+\n| VALUES                                     |                                |\n+--------------------------------------------+--------------------------------+\n| VARBINARY                                  |                                |\n+--------------------------------------------+--------------------------------+\n| VARCHAR                                    |                                |\n+--------------------------------------------+--------------------------------+\n| VARCHARACTER                               |                                |\n+--------------------------------------------+--------------------------------+\n| VARYING                                    |                                |\n+--------------------------------------------+--------------------------------+\n| WHEN                                       |                                |\n+--------------------------------------------+--------------------------------+\n| WHERE                                      |                                |\n+--------------------------------------------+--------------------------------+\n| WHILE                                      |                                |\n+--------------------------------------------+--------------------------------+\n| WINDOW                                     | Only disallowed for table      |\n|                                            | aliases.                       |\n+--------------------------------------------+--------------------------------+\n| WITH                                       |                                |\n+--------------------------------------------+--------------------------------+\n| WRITE                                      |                                |\n+--------------------------------------------+--------------------------------+\n| XOR                                        |                                |\n+--------------------------------------------+--------------------------------+\n| YEAR_MONTH                                 |                                |\n+--------------------------------------------+--------------------------------+\n| ZEROFILL                                   |                                |\n+--------------------------------------------+--------------------------------+\n\nExceptions\n----------\n\nSome keywords are exceptions for historical reasons, and are permitted as\nunquoted identifiers. These include:\n\n+-----------------------------------------------------------------------------+\n| Keyword                                                                     |\n+-----------------------------------------------------------------------------+\n| ACTION                                                                      |\n+-----------------------------------------------------------------------------+\n| BIT                                                                         |\n+-----------------------------------------------------------------------------+\n| DATE                                                                        |\n+-----------------------------------------------------------------------------+\n| ENUM                                                                        |\n+-----------------------------------------------------------------------------+\n| NO                                                                          |\n+-----------------------------------------------------------------------------+\n| TEXT                                                                        |\n+-----------------------------------------------------------------------------+\n| TIME                                                                        |\n+-----------------------------------------------------------------------------+\n| TIMESTAMP                                                                   |\n+-----------------------------------------------------------------------------+\n\nOracle Mode\n-----------\n\nIn Oracle mode, from MariaDB 10.3, there are a number of extra reserved words:\n\n+--------------------------------------------+--------------------------------+\n| Keyword                                    | Notes                          |\n+--------------------------------------------+--------------------------------+\n| BODY                                       |                                |\n+--------------------------------------------+--------------------------------+\n| ELSIF                                      |                                |\n+--------------------------------------------+--------------------------------+\n| GOTO                                       |                                |\n+--------------------------------------------+--------------------------------+\n| HISTORY                                    | <= MariaDB 10.3.6 only         |\n+--------------------------------------------+--------------------------------+\n| MINUS                                      | From MariaDB 10.6.1            |\n+--------------------------------------------+--------------------------------+\n| OTHERS                                     |                                |\n+--------------------------------------------+--------------------------------+\n| PACKAGE                                    |                                |\n+--------------------------------------------+--------------------------------+\n| PERIOD                                     | <= MariaDB 10.3.6 only         |\n+--------------------------------------------+--------------------------------+\n| RAISE                                      |                                |\n+--------------------------------------------+--------------------------------+\n| ROWNUM                                     | From MariaDB 10.6.1            |\n+--------------------------------------------+--------------------------------+\n| ROWTYPE                                    |                                |\n+--------------------------------------------+--------------------------------+\n| SYSDATE                                    | From MariaDB 10.6.1            |\n+--------------------------------------------+--------------------------------+\n| SYSTEM                                     | <= MariaDB 10.3.6 only. Note   |\n|                                            | however that SYSTEM sometimes  |\n|                                            | needs to be quoted to avoid    |\n|                                            | confusion with                 |\n|                                            | System-versioned tables.       |\n+--------------------------------------------+--------------------------------+\n| SYSTEM_TIME                                | <= MariaDB 10.3.6 only         |\n+--------------------------------------------+--------------------------------+\n| VERSIONING                                 | <= MariaDB 10.3.6 only         |\n+--------------------------------------------+--------------------------------+\n| WITHOUT                                    | <= MariaDB 10.3.6 only         |\n+--------------------------------------------+--------------------------------+\n\nFunction Names\n--------------\n\nIf the IGNORE_SPACE SQL_MODE flag is set, function names become reserved words.\n\nURL: https://mariadb.com/kb/en/reserved-words/','','https://mariadb.com/kb/en/reserved-words/'),
(488,'SQL_MODE=ORACLE',29,'From MariaDB 10.3, setting the sql_mode system variable to Oracle allows the\nserver to understand a subset of Oracle\'s PL/SQL language. For example:\n\nSET SQL_MODE=\'ORACLE\';\n\nAll traditional MariaDB SQL/PSM syntax should work as before, as long as it\ndoes not conflict with Oracle\'s PL/SQL syntax. All MariaDB functions should be\nsupported in both normal and Oracle modes.\n\nPrior to MariaDB 10.3, MariaDB does not support Oracle\'s PL/SQL language, and\nSET SQL_MODE=ORACLE is only an alias for the following sql_mode in those\nversions:\n\nSET SQL_MODE=\'PIPES_AS_CONCAT, ANSI_QUOTES, IGNORE_SPACE, NO_KEY_OPTIONS,\nNO_TABLE_OPTIONS, NO_FIELD_OPTIONS, NO_AUTO_CREATE_USER\';\n\nFrom MariaDB 10.3, SET SQL_MODE=ORACLE is same as:\n\nSET SQL_MODE=\'PIPES_AS_CONCAT,ANSI_QUOTES,IGNORE_SPACE,ORACLE,NO_KEY_OPTIONS,\nNO_TABLE_OPTIONS,NO_FIELD_OPTIONS,NO_AUTO_CREATE_USER,SIMULTANEOUS_ASSIGNMENT\';\n\nSupported Syntax in Oracle Mode\n-------------------------------\n\nStored Procedures and Stored Functions\n--------------------------------------\n\nOracle mode makes the following changes to Stored Procedures and Stored\nFunctions:\n\n+-----------------------------------------+-----------------------------------+\n| Oracle syntax                           | Description                       |\n+-----------------------------------------+-----------------------------------+\n| CREATE PROCEDURE p1 (param OUT INT)     | ANSI uses (OUT param INT)         |\n+-----------------------------------------+-----------------------------------+\n| CREATE PROCEDURE p1 (a IN OUT INT)      | ANSI uses (INOUT param INT)       |\n+-----------------------------------------+-----------------------------------+\n| AS before function body                 | CREATE FUNCTION f1 RETURN NUMBER  |\n|                                         | AS BEGIN...                       |\n+-----------------------------------------+-----------------------------------+\n| IS before function body                 | CREATE FUNCTION f1 RETURN NUMBER  |\n|                                         | IS BEGIN...                       |\n+-----------------------------------------+-----------------------------------+\n| If function has no parameters then      | Example: CREATE PROCEDURE p1 AS   |\n| parentheses must be omitted             | BEGIN NULL; END;                  |\n+-----------------------------------------+-----------------------------------+\n| CREATE PROCEDURE p1 AS BEGIN END p1;    | Optional routine name after END   |\n|                                         | keyword. MDEV-12089               |\n+-----------------------------------------+-----------------------------------+\n| CREATE FUNCTION f1(a VARCHAR)           | VARCHAR can be used without       |\n|                                         | length for routine parameters     |\n|                                         | and RETURN clause. The length is  |\n|                                         | inherited from the argument at    |\n|                                         | call time. MDEV-10596             |\n+-----------------------------------------+-----------------------------------+\n| CREATE AGGREGATE FUNCTION f1( )         | Creates an aggregate function,    |\n|                                         | which performs the function       |\n|                                         | against a set of rows and         |\n|                                         | returns one aggregate result.     |\n+-----------------------------------------+-----------------------------------+\n| No CALL needed in Stored Procedures     | In Oracle mode one can call       |\n|                                         | other stored procedures with      |\n|                                         | name only. MDEV-12107             |\n+-----------------------------------------+-----------------------------------+\n| RETURN. Can also be used in stored      | ANSI uses RETURNS. MariaDB mode   |\n| procedures                              | only supports RETURNS in stored   |\n|                                         | functions                         |\n+-----------------------------------------+-----------------------------------+\n\nCursors\n-------\n\nOracle mode makes the following changes to Cursors:\n\n+-----------------------------------------+-----------------------------------+\n| Oracle syntax                           | Description                       |\n+-----------------------------------------+-----------------------------------+\n| CREATE PROCEDURE p1 AS CURSOR cur IS    | Explicit cursor with FOR loop.    |\n| (SELECT a, b FROM t1); BEGIN  FOR rec   | MDEV-10581                        |\n| IN cur ...                              |                                   |\n+-----------------------------------------+-----------------------------------+\n| CREATE PROCEDURE p1 AS rec IN (SELECT   | Implicit cursor with FOR loop.    |\n| a, b FROM t1)                           | MDEV-12098                        |\n+-----------------------------------------+-----------------------------------+\n| CURSOR c(prm_a VARCHAR2, prm_b          | Cursor with parameters.           |\n| VARCHAR2) ... OPEN c(1,2)               | MDEV-10597                        |\n+-----------------------------------------+-----------------------------------+\n| CURSOR c(prm_a VARCHAR2, prm_b          | Cursor with parameters and FOR    |\n| VARCHAR2) ... FOR rec in c(1,2)         | loop. MDEV-12314                  |\n+-----------------------------------------+-----------------------------------+\n| s %ISOPEN, %ROWCOUNT, %FOUND, %NOTFOUND | Explicit cursor attributes.       |\n|                                         | MDEV-10582                        |\n+-----------------------------------------+-----------------------------------+\n\nLOOP\n----\n\nOracle mode makes the following changes to LOOP:\n\n+-----------------------------------------+-----------------------------------+\n| Oracle syntax                           | Description                       |\n+-----------------------------------------+-----------------------------------+\n| FOR i IN 1..10 LOOP ... END LOOP        | Numeric FOR loop. MDEV-10580      |\n+-----------------------------------------+-----------------------------------+\n| GOTO                                    | GOTO statement.  MDEV-10697       |\n+-----------------------------------------+-----------------------------------+\n| <<label>> used with GOTO                | ANSI uses label:. MDEV-10697      |\n+-----------------------------------------+-----------------------------------+\n| To leave loop block: EXIT [ label ] [   | ANSI syntax is IF bool_expr THEN  |\n| WHEN bool_expr ]                        | LEAVE label                       |\n+-----------------------------------------+-----------------------------------+\n| [<<label>>] WHILE boolean_expression    | Oracle style WHILE loop           |\n| LOOP statement... END LOOP [ label ] ;  |                                   |\n+-----------------------------------------+-----------------------------------+\n| CONTINUE [ label ] [ WHEN               | CONTINUE is only valid inside a   |\n| boolean_expression]                     | loop                              |\n+-----------------------------------------+-----------------------------------+\n\nVariables\n---------\n\n+------------------------------+-----------------+--------------------------+\n| Oracle syntax                | Version         | Description              |\n+------------------------------+-----------------+--------------------------+\n| var:= 10; Can also be used   | 10.3            | MariaDB uses SET var=    |\n| with MariaDB systemvariables |                 | 10;                      |\n+------------------------------+-----------------+--------------------------+\n| var INT := 10                | 10.3            | Default variable value   |\n+------------------------------+-----------------+--------------------------+\n| var1                         | 10.3            | Take data type from a    |\n| table_name.column_name%TYPE  |                 | table column. MDEV-10577 |\n+------------------------------+-----------------+--------------------------+\n| var2 var1%TYPE               | 10.3            | Take data type from      |\n|                              |                 | another variable         |\n+------------------------------+-----------------+--------------------------+\n| rec1 table_name%ROWTYPE      | 10.3            | Take ROW structure from  |\n|                              |                 | a table. MDEV-12133      |\n+------------------------------+-----------------+--------------------------+\n| rec2 rec1%ROWTYPE            | 10.3            | Take ROW structure from  |\n|                              |                 | ROW variable             |\n+------------------------------+-----------------+--------------------------+\n| CURSOR c1 IS SELECT a,b      | 10.3            | Take ROW structure from  |\n| FROM t1; rec1 c1%ROWTYPE;    |                 | a cursor. MDEV-12011     |\n+------------------------------+-----------------+--------------------------+\n| Variables can be declared    | 10.3            | In MariaDB mode,         |\n| after cursor declarations    |                 | variables must be        |\n|                              |                 | declared before          |\n|                              |                 | cursors. MDEV-10598      |\n+------------------------------+-----------------+--------------------------+\n| Triggers uses :NEW and :OLD  | 10.3            | ANSI uses NEW and OLD.   |\n|                              |                 | MDEV-10579               |\n+------------------------------+-----------------+--------------------------+\n| SQLCODE                      | 10.3            | Returns the number code  |\n|                              |                 | of the most recent       |\n|                              |                 | exception. Can only be   |\n|                              |                 | used in Stored           |\n|                              |                 | Procedures. MDEV-10578   |\n+------------------------------+-----------------+--------------------------+\n| SQLERRM                      | 10.3            | Returns the error        |\n|                              |                 | message associdated to   |\n|                              |                 | it\'s error number        |\n|                              |                 | argument or SQLCODE if   |\n|                              |                 | no argument is given.    |\n|                              |                 | Can only be used in      |\n|                              |                 | Stored Procedures.       |\n|                              |                 | MDEV-10578               |\n+------------------------------+-----------------+--------------------------+\n| SQL%ROWCOUNT                 | 10.3            | Almost same as           |\n|                              |                 | ROW_COUNT(). MDEV-10583  |\n+------------------------------+-----------------+--------------------------+\n| ROWNUM                       | 10.6.1          | Returns number of        |\n|                              |                 | accepted rows            |\n+------------------------------+-----------------+--------------------------+\n\nExceptions\n----------\n\n+-----------------------------------------+-----------------------------------+\n| Oracle syntax                           | Description                       |\n+-----------------------------------------+-----------------------------------+\n| BEGIN ... EXCEPTION WHEN OTHERS THEN    | Exception handlers are declared   |\n| BEGIN ..  END; END;                     | at the end of a block             |\n+-----------------------------------------+-----------------------------------+\n| TOO_MANY_ROWS, NO_DATA_FOUND,           | Predefined exceptions. MDEV-10839 |\n| DUP_VAL_ON_INDEX                        |                                   |\n+-----------------------------------------+-----------------------------------+\n| RAISE TOO_MANY_ROWS ; .... EXCEPTION    | Exception can be used with RAISE  |\n| WHEN TOO_MANY_ROWS THEN ...             | and EXCEPTION...WHEN. MDEV-10840  |\n+-----------------------------------------+-----------------------------------+\n| CREATE OR REPLACE FUNCTION f1 (a INT)   | User defined exceptions.          |\n| RETURN INT AS e1 EXCEPTION...           | MDEV-10587                        |\n+-----------------------------------------+-----------------------------------+\n\nBEGIN Blocks\n------------\n\n+-----------------------------------------+-----------------------------------+\n| Oracle syntax                           | Description                       |\n+-----------------------------------------+-----------------------------------+\n| BEGIN to start a block                  | MariaDB uses BEGIN NOT ATOMIC     |\n|                                         | for anyonymous blocks. MDEV-10655 |\n+-----------------------------------------+-----------------------------------+\n| DECLARE is used before BEGIN            | DECLARE a INT; b VARCHAR(10);     |\n|                                         | BEGIN v:= 10; END;                |\n+-----------------------------------------+-----------------------------------+\n| WHEN DUP_VAL_ON_INDEX THEN NULL ;       | Do not require BEGIN..END in      |\n| NULL; WHEN OTHERS THEN NULL             | multi-statement exception         |\n|                                         | handlers in THEN clause.          |\n|                                         | MDEV-12088                        |\n+-----------------------------------------+-----------------------------------+\n\nSimple Syntax Compatibility\n---------------------------\n\n+------------------------------+-----------------+--------------------------+\n| Oracle syntax                | Version         | Description              |\n+------------------------------+-----------------+--------------------------+\n| ELSIF                        | 10.3            | ANSI uses ELSEIF         |\n+------------------------------+-----------------+--------------------------+\n| SELECT UNIQUE                | 10.3            | Same as SELECT           |\n|                              |                 | DISTINCT. MDEV-12086     |\n+------------------------------+-----------------+--------------------------+\n| TRUNCATE TABLE t1 [DROP      | 10.3            | DROP STORAGE and REUSE   |\n| STORAGE] or [REUSE STORAGE]  |                 | STORAGE are allowed as   |\n|                              |                 | optional keywords for    |\n|                              |                 | TRUNCATE TABLE.          |\n|                              |                 | MDEV-10588               |\n+------------------------------+-----------------+--------------------------+\n| Subqueries in a FROM clause  | 10.6            | SELECT * FROM (SELECT 1  |\n| without an alias             |                 | FROM DUAL), (SELECT 2    |\n|                              |                 | FROM DUAL)               |\n+------------------------------+-----------------+--------------------------+\n| UNION, EXCEPT and INTERSECT  | 10.3            | INTERSECT has higher     |\n| all have the same            |                 | precedence than UNION    |\n| precedence.                  |                 | and EXCEPT in            |\n|                              |                 | non-Oracle modes.        |\n+------------------------------+-----------------+--------------------------+\n| MINUS                        | 10.6            | MINUS is a synonym for   |\n|                              |                 | EXCEPT.                  |\n+------------------------------+-----------------+--------------------------+\n\nFunctions\n---------\n\n+------------------------------+-----------------+--------------------------+\n| Oracle syntax                | Version         | Description              |\n+------------------------------+-----------------+--------------------------+\n| ADD_MONTHS()                 | 10.6.1          | Added as a wrapper for   |\n|                              |                 | DATE_ADD() to enhance    |\n|                              |                 | Oracle compatibility.    |\n|                              |                 | All modes.               |\n+------------------------------+-----------------+--------------------------+\n| CAST(expr as VARCHAR(N))     | 10.3            | Cast expression to a     |\n|                              |                 | VARCHAR(N). MDEV-11275   |\n+------------------------------+-----------------+--------------------------+\n| DECODE                       | 10.3            | In Oracle mode,          |\n|                              |                 | compares and matches     |\n|                              |                 | search expressions       |\n+------------------------------+-----------------+--------------------------+\n| LENGTH() is same as          | 10.3            | MariaDB translates       |\n| CHAR_LENGTH()                |                 | LENGTH() to              |\n|                              |                 | OCTET_LENGTH(). In all   |\n|                              |                 | modes one can use        |\n|                              |                 | LENGTHB() as a synonym   |\n|                              |                 | to OCTET_LENGTH()        |\n+------------------------------+-----------------+--------------------------+\n| CHR(num)                     | 10.3            | Returns a VARCHAR(1)     |\n|                              |                 | with character set and   |\n|                              |                 | collation according to   |\n|                              |                 | @@character_set_database |\n|                              |                 | and @@collation_database |\n+------------------------------+-----------------+--------------------------+\n| substr(\'abc\',0 ,3) same as   | 10.3            | Position 0 for substr()  |\n| substr(\'abc\', 1 ,3)          |                 | is same as position 1    |\n+------------------------------+-----------------+--------------------------+\n| SYS_GUID                     | 10.6.1          | Generates a globally     |\n|                              |                 | unique identifier.       |\n|                              |                 | Similar to UUID but      |\n|                              |                 | without the -. All       |\n|                              |                 | modes.                   |\n+------------------------------+-----------------+--------------------------+\n| TO_CHAR                      | 10.6.1          | Added to enhance Oracle  |\n|                              |                 | compatibility. All       |\n|                              |                 | modes.                   |\n+------------------------------+-----------------+--------------------------+\n| TRIM, LTRIM, RTRIM, LPAD     | 10.3            | Returns NULL instead of  |\n| and RPAD                     |                 | an empty string if       |\n|                              |                 | returning an empty       |\n|                              |                 | result. These functions  |\n|                              |                 | can also be accessed     |\n|                              |                 | outside of ORACLE mode   |\n|                              |                 | by suffixing _ORACLE     |\n|                              |                 | onto the end of the      |\n|                              |                 | function name, such as   |\n|                              |                 | TRIM_ORACLE.             |\n+------------------------------+-----------------+--------------------------+\n\nPrepared Statements\n-------------------\n\nOracle mode makes the following changes to Prepared Statements:\n\n+-----------------------------------------+-----------------------------------+\n| Oracle syntax                           | Description                       |\n+-----------------------------------------+-----------------------------------+\n| PREPARE stmt FROM \'SELECT :1, :2\'       | ANSI uses ?. MDEV-10801           |\n+-----------------------------------------+-----------------------------------+\n| EXECUTE IMMEDIATE \'INSERT INTO t1       | Dynamic placeholders. MDEV-10801  |\n| SELECT (:x,:y) FROM DUAL\' USING 10,20   |                                   |\n+-----------------------------------------+-----------------------------------+\n\nSynonyms for Basic SQL Types\n----------------------------\n\n+--------------------------------+-------------------------------------------+\n| Oracle type                    | MariaDB synonym                           |\n+--------------------------------+-------------------------------------------+\n| VARCHAR2                       | VARCHAR                                   |\n+--------------------------------+-------------------------------------------+\n| NUMBER                         | DECIMAL                                   |\n+--------------------------------+-------------------------------------------+\n| DATE (with time portion)       | MariaDB DATETIME                          |\n+--------------------------------+-------------------------------------------+\n| RAW                            | VARBINARY                                 |\n+--------------------------------+-------------------------------------------+\n| CLOB                           | LONGTEXT                                  |\n+--------------------------------+-------------------------------------------+\n| BLOB                           | LONGBLOB                                  |\n+--------------------------------+-------------------------------------------+\n\nThis was implemented as part of MDEV-10343.\n\nIf one does a SHOW CREATE TABLE in ORACLE mode on a table that has a native\nMariaDB DATE column, it will be displayed as mariadb_schema.date to not\nconflict with the Oracle DATE type.\n\nPackages\n--------\n\nThe following syntax has been supported since MariaDB 10.3.5:\n\n* CREATE PACKAGE\n* CREATE PACKAGE BODY\n* DROP PACKAGE\n* DROP PACKAGE BODY\n* SHOW CREATE PACKAGE\n* SHOW CREATE PACKAGE BODY\n\nNULL Handling\n-------------\n\nOracle mode makes the following changes to NULL handling:\n\nNULL As a Statement\n-------------------\n\nNULL can be used as a statement:\n\nIF a=10 THEN NULL; ELSE NULL; END IF\n\nTranslating Empty String Literals to NULL\n-----------------------------------------\n\nIn Oracle, empty string (\'\') and NULL are the same thing,\n\nBy using sql_mode=EMPTY_STRING_IS_NULL you can get a similar experience in\nMariaDB:\n\nSET sql_mode=EMPTY_STRING_IS_NULL;\nSELECT \'\' IS NULL; -- returns TRUE\nINSERT INTO t1 VALUES (\'\'); -- inserts NULL\n\nConcat Operator Ignores NULL\n----------------------------\n\nCONCAT() and || ignore NULL in Oracle mode. Can also be accessed outside of\nORACLE mode by using CONCAT_OPERATOR_ORACLE. MDEV-11880 and MDEV-12143.\n\nReserved Words\n--------------\n\nThere are a number of extra reserved words in Oracle mode.\n\nSHOW CREATE TABLE\n-----------------\n\nThe SHOW CREATE TABLE statement will not display MariaDB-specific table\noptions, such as AUTO_INCREMENT or CHARSET, when Oracle mode is set.\n\nURL: https://mariadb.com/kb/en/sql_modeoracle/','','https://mariadb.com/kb/en/sql_modeoracle/'),
(489,'CONTAINS',30,'Syntax\n------\n\nContains(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether a geometry g1 completely contains geometry\ng2. CONTAINS() is based on the original MySQL implementation and uses object\nbounding rectangles, while ST_CONTAINS() uses object shapes.\n\nThis tests the opposite relationship to Within().\n\nURL: https://mariadb.com/kb/en/contains/','','https://mariadb.com/kb/en/contains/'),
(490,'CROSSES',30,'Syntax\n------\n\nCrosses(g1,g2)\n\nDescription\n-----------\n\nReturns 1 if g1 spatially crosses g2. Returns NULL if g1 is a Polygon or a\nMultiPolygon, or if g2 is a Point or a MultiPoint. Otherwise, returns 0.\n\nThe term spatially crosses denotes a spatial relation between two given\ngeometries that has the following properties:\n\n* The two geometries intersect\n* Their intersection results in a geometry that has a dimension that is one\n less than the maximum dimension of the two given geometries\n* Their intersection is not equal to either of the two given geometries\n\nCROSSES() is based on the original MySQL implementation, and uses object\nbounding rectangles, while ST_CROSSES() uses object shapes.\n\nURL: https://mariadb.com/kb/en/crosses/','','https://mariadb.com/kb/en/crosses/'),
(202,'DEFAULT',17,'Syntax\n------\n\nDEFAULT(col_name)\n\nDescription\n-----------\n\nReturns the default value for a table column. If the column has no default\nvalue (and is not NULLABLE - NULLABLE fields have a NULL default), an error is\nreturned.\n\nFor integer columns using AUTO_INCREMENT, 0 is returned.\n\nWhen using DEFAULT as a value to set in an INSERT or UPDATE statement, you can\nuse the bare keyword DEFAULT without the parentheses and argument to refer to\nthe column in context. You can only use DEFAULT as a bare keyword if you are\nusing it alone without a surrounding expression or function.\n\nExamples\n--------\n\nSelect only non-default values for a column:\n\nSELECT i FROM t WHERE i != DEFAULT(i);\n\nUpdate values to be one greater than the default value:\n\nUPDATE t SET i = DEFAULT(i)+1 WHERE i < 100;\n\nWhen referring to the default value exactly in UPDATE or INSERT, you can omit\nthe argument:\n\nINSERT INTO t (i) VALUES (DEFAULT);\nUPDATE t SET i = DEFAULT WHERE i < 100;\n\nCREATE OR REPLACE TABLE t (\n i INT NOT NULL AUTO_INCREMENT,\n j INT NOT NULL,\n k INT DEFAULT 3,\n l INT NOT NULL DEFAULT 4,\n m INT,\n PRIMARY KEY (i)\n);\n\nDESC t;\n+-------+---------+------+-----+---------+----------------+\n| Field | Type    | Null | Key | Default | Extra          |\n+-------+---------+------+-----+---------+----------------+\n| i     | int(11) | NO   | PRI | NULL    | auto_increment |\n| j     | int(11) | NO   |     | NULL    |                |\n| k     | int(11) | YES  |     | 3       |                |\n| l     | int(11) | NO   |     | 4       |                |\n| m     | int(11) | YES  |     | NULL    |                |\n+-------+---------+------+-----+---------+----------------+\n\nINSERT INTO t (j) VALUES (1);\nINSERT INTO t (j,m) VALUES (2,2);\nINSERT INTO t (j,l,m) VALUES (3,3,3);\n\nSELECT * FROM t;\n+---+---+------+---+------+\n| i | j | k    | l | m    |\n+---+---+------+---+------+\n| 1 | 1 |    3 | 4 | NULL |\n| 2 | 2 |    3 | 4 |    2 |\n| 3 | 3 |    3 | 3 |    3 |\n+---+---+------+---+------+\n\nSELECT DEFAULT(i), DEFAULT(k), DEFAULT (l), DEFAULT(m) FROM t;\n+------------+------------+-------------+------------+\n| DEFAULT(i) | DEFAULT(k) | DEFAULT (l) | DEFAULT(m) |\n+------------+------------+-------------+------------+\n|          0 |          3 |           4 |       NULL |\n|          0 |          3 |           4 |       NULL |\n|          0 |          3 |           4 |       NULL |\n+------------+------------+-------------+------------+\n\nSELECT DEFAULT(i), DEFAULT(k), DEFAULT (l), DEFAULT(m), DEFAULT(j)  FROM t;\nERROR 1364 (HY000): Field \'j\' doesn\'t have a default value\n\nSELECT * FROM t WHERE i = DEFAULT(i);\nEmpty set (0.001 sec)\n\nSELECT * FROM t WHERE j = DEFAULT(j);\nERROR 1364 (HY000): Field \'j\' doesn\'t have a default value\n\nSELECT * FROM t WHERE k = DEFAULT(k);\n+---+---+------+---+------+\n| i | j | k    | l | m    |\n+---+---+------+---+------+\n| 1 | 1 |    3 | 4 | NULL |\n| 2 | 2 |    3 | 4 |    2 |\n| 3 | 3 |    3 | 3 |    3 |\n+---+---+------+---+------+\n\nSELECT * FROM t WHERE l = DEFAULT(l);\n+---+---+------+---+------+\n| i | j | k    | l | m    |\n+---+---+------+---+------+\n| 1 | 1 |    3 | 4 | NULL |\n| 2 | 2 |    3 | 4 |    2 |\n+---+---+------+---+------+\n\nSELECT * FROM t WHERE m = DEFAULT(m);\nEmpty set (0.001 sec)\n\nSELECT * FROM t WHERE m <=> DEFAULT(m);\n+---+---+------+---+------+\n| i | j | k    | l | m    |\n+---+---+------+---+------+\n| 1 | 1 |    3 | 4 | NULL |\n+---+---+------+---+------+\n\nURL: https://mariadb.com/kb/en/default/','','https://mariadb.com/kb/en/default/'),
(208,'ROW_COUNT',17,'Syntax\n------\n\nROW_COUNT()\n\nDescription\n-----------\n\nROW_COUNT() returns the number of rows updated, inserted or deleted by the\npreceding statement. This is the same as the row count that the mariadb client\ndisplays and the value from the mysql_affected_rows() C API function.\n\nGenerally:\n\n* For statements which return a result set (such as SELECT, SHOW, DESC or\nHELP), returns -1, even when the result set is empty. This is also true for\nadministrative statements, such as OPTIMIZE.\n* For DML statements other than SELECT and for ALTER TABLE, returns the number\nof affected rows.\n* For DDL statements (including TRUNCATE) and for other statements which don\'t\nreturn any result set (such as USE, DO, SIGNAL or DEALLOCATE PREPARE), returns\n0.\n\nFor UPDATE, affected rows is by default the number of rows that were actually\nchanged. If the CLIENT_FOUND_ROWS flag to mysql_real_connect() is specified\nwhen connecting to mysqld, affected rows is instead the number of rows matched\nby the WHERE clause.\n\nFor REPLACE, deleted rows are also counted. So, if REPLACE deletes a row and\nadds a new row, ROW_COUNT() returns 2.\n\nFor INSERT ... ON DUPLICATE KEY, updated rows are counted twice. So, if INSERT\nadds a new rows and modifies another row, ROW_COUNT() returns 3.\n\nROW_COUNT() does not take into account rows that are not directly\ndeleted/updated by the last statement. This means that rows deleted by foreign\nkeys or triggers are not counted.\n\nWarning: You can use ROW_COUNT() with prepared statements, but you need to\ncall it after EXECUTE, not after DEALLOCATE PREPARE, because the row count for\nallocate prepare is always 0.\n\nWarning: When used after a CALL statement, this function returns the number of\nrows affected by the last statement in the procedure, not by the whole\nprocedure.\n\nWarning: After INSERT DELAYED, ROW_COUNT() returns the number of the rows you\ntried to insert, not the number of the successful writes.\n\nThis information can also be found in the diagnostics area.\n\nStatements using the ROW_COUNT() function are not safe for replication.\n\nExamples\n--------\n\nCREATE TABLE t (A INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT ROW_COUNT();\n+-------------+\n| ROW_COUNT() |\n+-------------+\n|           3 |\n+-------------+\n\nDELETE FROM t WHERE A IN(1,2);\n\nSELECT ROW_COUNT(); \n+-------------+\n| ROW_COUNT() |\n+-------------+\n|           2 |\n+-------------+\n\nExample with prepared statements:\n\nSET @q = \'INSERT INTO t VALUES(1),(2),(3);\';\n\nPREPARE stmt FROM @q;\n\nEXECUTE stmt;\nQuery OK, 3 rows affected (0.39 sec)\nRecords: 3  Duplicates: 0  Warnings: 0\n\nSELECT ROW_COUNT();\n+-------------+\n| ROW_COUNT() |\n+-------------+\n|           3 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/row_count/','','https://mariadb.com/kb/en/row_count/'),
(491,'DISJOINT',30,'Syntax\n------\n\nDisjoint(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether g1 is spatially disjoint from (does not\nintersect) g2.\n\nDISJOINT() tests the opposite relationship to INTERSECTS().\n\nDISJOINT() is based on the original MySQL implementation and uses object\nbounding rectangles, while ST_DISJOINT() uses object shapes.\n\nURL: https://mariadb.com/kb/en/disjoint/','','https://mariadb.com/kb/en/disjoint/'),
(492,'EQUALS',30,'Syntax\n------\n\nEquals(g1,g2)\n\nFrom MariaDB 10.2.3:\n\nMBREQUALS(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether g1 is spatially equal to g2.\n\nEQUALS() is based on the original MySQL implementation and uses object\nbounding rectangles, while ST_EQUALS() uses object shapes.\n\nFrom MariaDB 10.2.3, MBREQUALS is a synonym for Equals.\n\nURL: https://mariadb.com/kb/en/equals/','','https://mariadb.com/kb/en/equals/'),
(493,'INTERSECTS',30,'Syntax\n------\n\nINTERSECTS(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether geometry g1 spatially intersects geometry\ng2.\n\nINTERSECTS() is based on the original MySQL implementation and uses object\nbounding rectangles, while ST_INTERSECTS() uses object shapes.\n\nINTERSECTS() tests the opposite relationship to DISJOINT().\n\nURL: https://mariadb.com/kb/en/intersects/','','https://mariadb.com/kb/en/intersects/'),
(204,'LAST_INSERT_ID',17,'Syntax\n------\n\nLAST_INSERT_ID(), LAST_INSERT_ID(expr)\n\nDescription\n-----------\n\nLAST_INSERT_ID() (no arguments) returns the first automatically generated\nvalue successfully inserted for an AUTO_INCREMENT column as a result of the\nmost recently executed INSERT statement. The value of LAST_INSERT_ID() remains\nunchanged if no rows are successfully inserted.\n\nIf one gives an argument to LAST_INSERT_ID(), then it will return the value of\nthe expression and the next call to LAST_INSERT_ID() will return the same\nvalue. The value will also be sent to the client and can be accessed by the\nmysql_insert_id function.\n\nFor example, after inserting a row that generates an AUTO_INCREMENT value, you\ncan get the value like this:\n\nSELECT LAST_INSERT_ID();\n+------------------+\n| LAST_INSERT_ID() |\n+------------------+\n|                9 |\n+------------------+\n\nYou can also use LAST_INSERT_ID() to delete the last inserted row:\n\nDELETE FROM product WHERE id = LAST_INSERT_ID();\n\nIf no rows were successfully inserted, LAST_INSERT_ID() returns 0.\n\nThe value of LAST_INSERT_ID() will be consistent across all versions if all\nrows in the INSERT or UPDATE statement were successful.\n\nThe currently executing statement does not affect the value of\nLAST_INSERT_ID(). Suppose that you generate an AUTO_INCREMENT value with one\nstatement, and then refer to LAST_INSERT_ID() in a multiple-row INSERT\nstatement that inserts rows into a table with its own AUTO_INCREMENT column.\nThe value of LAST_INSERT_ID() will remain stable in the second statement; its\nvalue for the second and later rows is not affected by the earlier row\ninsertions. (However, if you mix references to LAST_INSERT_ID() and\nLAST_INSERT_ID(expr), the effect is undefined.)\n\nIf the previous statement returned an error, the value of LAST_INSERT_ID() is\nundefined. For transactional tables, if the statement is rolled back due to an\nerror, the value of LAST_INSERT_ID() is left undefined. For manual ROLLBACK,\nthe value of LAST_INSERT_ID() is not restored to that before the transaction;\nit remains as it was at the point of the ROLLBACK.\n\nWithin the body of a stored routine (procedure or function) or a trigger, the\nvalue of LAST_INSERT_ID() changes the same way as for statements executed\noutside the body of these kinds of objects. The effect of a stored routine or\ntrigger upon the value of LAST_INSERT_ID() that is seen by following\nstatements depends on the kind of routine:\n\n* If a stored procedure executes statements that change the value of\nLAST_INSERT_ID(), the new value will be seen by statements that follow the\nprocedure call.\n\n* For stored functions and triggers that change the value, the value is\nrestored when the function or trigger ends, so following statements will not\nsee a changed value.\n\nExamples\n--------\n\nCREATE TABLE t (\n id INTEGER UNSIGNED AUTO_INCREMENT PRIMARY KEY,\n f VARCHAR(1))\nENGINE = InnoDB;\n\nINSERT INTO t(f) VALUES(\'a\');\n\nSELECT LAST_INSERT_ID();\n+------------------+\n| LAST_INSERT_ID() |\n+------------------+\n|                1 |\n+------------------+\n\nINSERT INTO t(f) VALUES(\'b\');\n\nINSERT INTO t(f) VALUES(\'c\');\n\nSELECT LAST_INSERT_ID();\n+------------------+\n| LAST_INSERT_ID() |\n+------------------+\n|                3 |\n+------------------+\n\nINSERT INTO t(f) VALUES(\'d\'),(\'e\');\n\nSELECT LAST_INSERT_ID();\n+------------------+\n| LAST_INSERT_ID() |\n+------------------+\n|                4 |\n+------------------+\n\nSELECT * FROM t;\n+----+------+\n| id | f    |\n+----+------+\n|  1 | a    |\n|  2 | b    |\n|  3 | c    |\n|  4 | d    |\n|  5 | e    |\n+----+------+\n\nSELECT LAST_INSERT_ID(12);\n+--------------------+\n| LAST_INSERT_ID(12) |\n+--------------------+\n|                 12 |\n+--------------------+\n\nSELECT LAST_INSERT_ID();\n+------------------+\n| LAST_INSERT_ID() |\n+------------------+\n|               12 |\n+------------------+\n\nINSERT INTO t(f) VALUES(\'f\');\n\nSELECT LAST_INSERT_ID();\n+------------------+\n| LAST_INSERT_ID() |\n+------------------+\n|                6 |\n+------------------+\n\nSELECT * FROM t;\n+----+------+\n| id | f    |\n+----+------+\n|  1 | a    |\n|  2 | b    |\n|  3 | c    |\n|  4 | d    |\n|  5 | e    |\n|  6 | f    |\n+----+------+\n\nSELECT LAST_INSERT_ID(12);\n+--------------------+\n| LAST_INSERT_ID(12) |\n+--------------------+\n|                 12 |\n+--------------------+\n\nINSERT INTO t(f) VALUES(\'g\');\n\nSELECT * FROM t;\n+----+------+\n| id | f    |\n+----+------+\n|  1 | a    |\n|  2 | b    |\n|  3 | c    |\n|  4 | d    |\n|  5 | e    |\n|  6 | f    |\n|  7 | g    |\n+----+------+\n\nURL: https://mariadb.com/kb/en/last_insert_id/','','https://mariadb.com/kb/en/last_insert_id/'),
(212,'USER',17,'Syntax\n------\n\nUSER()\n\nDescription\n-----------\n\nReturns the current MariaDB user name and host name, given when authenticating\nto MariaDB, as a string in the utf8 character set.\n\nNote that the value of USER() may differ from the value of CURRENT_USER(),\nwhich is the user used to authenticate the current client. CURRENT_ROLE()\nreturns the current active role.\n\nSYSTEM_USER() and SESSION_USER are synonyms for USER().\n\nStatements using the USER() function or one of its synonyms are not safe for\nstatement level replication.\n\nExamples\n--------\n\nshell> mysql --user=\"anonymous\"\n\nSELECT USER(),CURRENT_USER();\n+---------------------+----------------+\n| USER()              | CURRENT_USER() |\n+---------------------+----------------+\n| anonymous@localhost | @localhost     |\n+---------------------+----------------+\n\nTo select only the IP address, use SUBSTRING_INDEX(),\n\nSELECT SUBSTRING_INDEX(USER(), \'@\', -1);\n+----------------------------------+\n| SUBSTRING_INDEX(USER(), \'@\', -1) |\n+----------------------------------+\n| 192.168.0.101                    |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/user/','','https://mariadb.com/kb/en/user/'),
(494,'OVERLAPS',30,'Syntax\n------\n\nOVERLAPS(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether g1 spatially overlaps g2. The term\nspatially overlaps is used if two geometries intersect and their intersection\nresults in a geometry of the same dimension but not equal to either of the\ngiven geometries.\n\nOVERLAPS() is based on the original MySQL implementation and uses object\nbounding rectangles, while ST_OVERLAPS() uses object shapes.\n\nURL: https://mariadb.com/kb/en/overlaps/','','https://mariadb.com/kb/en/overlaps/'),
(497,'ST_DIFFERENCE',30,'Syntax\n------\n\nST_DIFFERENCE(g1,g2)\n\nDescription\n-----------\n\nReturns a geometry representing the point set difference of the given geometry\nvalues.\n\nExample\n-------\n\nSET @g1 = POINT(10,10), @g2 = POINT(20,20);\n\nSELECT ST_AsText(ST_Difference(@g1, @g2));\n+------------------------------------+\n| ST_AsText(ST_Difference(@g1, @g2)) |\n+------------------------------------+\n| POINT(10 10)                       |\n+------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_difference/','','https://mariadb.com/kb/en/st_difference/'),
(499,'ST_DISTANCE',30,'Syntax\n------\n\nST_DISTANCE(g1,g2)\n\nDescription\n-----------\n\nReturns the distance between two geometries, or null if not given valid inputs.\n\nExample\n-------\n\nSELECT ST_Distance(POINT(1,2),POINT(2,2));\n+------------------------------------+\n| ST_Distance(POINT(1,2),POINT(2,2)) |\n+------------------------------------+\n|                                  1 |\n+------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_distance/','','https://mariadb.com/kb/en/st_distance/'),
(205,'LAST_VALUE',17,'Syntax\n------\n\nLAST_VALUE(expr,[expr,...])\n\nLAST_VALUE(expr) OVER (\n [ PARTITION BY partition_expression ]\n [ ORDER BY order_list ]\n)\n\nDescription\n-----------\n\nLAST_VALUE() evaluates all expressions and returns the last.\n\nThis is useful together with setting user variables to a value with\n@var:=expr, for example when you want to get data of rows updated/deleted\nwithout having to do two queries against the table.\n\nLAST_VALUE can be used as a window function.\n\nReturns NULL if no last value exists.\n\nExamples\n--------\n\nCREATE TABLE t1 (a int, b int);\nINSERT INTO t1 VALUES(1,10),(2,20);\nDELETE FROM t1 WHERE a=1 AND last_value(@a:=a,@b:=b,1);\nSELECT @a,@b;\n+------+------+\n| @a   | @b   |\n+------+------+\n|    1 |   10 |\n+------+------+\n\nAs a window function:\n\nCREATE TABLE t1 (\n pk int primary key,\n a int,\n b int,\n c char(10),\n d decimal(10, 3),\n e real\n);\n\nINSERT INTO t1 VALUES\n( 1, 0, 1,    \'one\',    0.1,  0.001),\n( 2, 0, 2,    \'two\',    0.2,  0.002),\n( 3, 0, 3,    \'three\',  0.3,  0.003),\n( 4, 1, 2,    \'three\',  0.4,  0.004),\n( 5, 1, 1,    \'two\',    0.5,  0.005),\n( 6, 1, 1,    \'one\',    0.6,  0.006),\n( 7, 2, NULL, \'n_one\',  0.5,  0.007),\n( 8, 2, 1,    \'n_two\',  NULL, 0.008),\n( 9, 2, 2,    NULL,     0.7,  0.009),\n(10, 2, 0,    \'n_four\', 0.8,  0.010),\n(11, 2, 10,   NULL,     0.9,  NULL);\n\nSELECT pk, FIRST_VALUE(pk) OVER (ORDER BY pk) AS first_asc,\n     LAST_VALUE(pk) OVER (ORDER BY pk) AS last_asc,\n     FIRST_VALUE(pk) OVER (ORDER BY pk DESC) AS first_desc,\n     LAST_VALUE(pk) OVER (ORDER BY pk DESC) AS last_desc\nFROM t1\nORDER BY pk DESC;\n\n+----+-----------+----------+------------+-----------+\n| pk | first_asc | last_asc | first_desc | last_desc |\n+----+-----------+----------+------------+-----------+\n| 11 |         1 |       11 |         11 |        11 |\n| 10 |         1 |       10 |         11 |        10 |\n|  9 |         1 |        9 |         11 |         9 |\n|  8 |         1 |        8 |         11 |         8 |\n|  7 |         1 |        7 |         11 |         7 |\n|  6 |         1 |        6 |         11 |         6 |\n|  5 |         1 |        5 |         11 |         5 |\n|  4 |         1 |        4 |         11 |         4 |\n|  3 |         1 |        3 |         11 |         3 |\n|  2 |         1 |        2 |         11 |         2 |\n|  1 |         1 |        1 |         11 |         1 |\n+----+-----------+----------+------------+-----------+\n\nCREATE OR REPLACE TABLE t1 (i int);\nINSERT INTO t1 VALUES (1),(2),(3),(4),(5),(6),(7),(8),(9),(10);\n\nSELECT i,\n FIRST_VALUE(i) OVER (ORDER BY i ROWS BETWEEN CURRENT ROW and 1 FOLLOWING) AS\nf_1f,\n LAST_VALUE(i) OVER (ORDER BY i ROWS BETWEEN CURRENT ROW and 1 FOLLOWING) AS\nl_1f,\n FIRST_VALUE(i) OVER (ORDER BY i ROWS BETWEEN 1 PRECEDING AND 1 FOLLOWING) AS\nf_1p1f,\n LAST_VALUE(i) OVER (ORDER BY i ROWS BETWEEN 1 PRECEDING AND 1 FOLLOWING) AS\nl_1p1f,\n FIRST_VALUE(i) OVER (ORDER BY i ROWS BETWEEN 2 PRECEDING AND 1 PRECEDING) AS\nf_2p1p,\n LAST_VALUE(i) OVER (ORDER BY i ROWS BETWEEN 2 PRECEDING AND 1 PRECEDING) AS\nl_2p1p,\n FIRST_VALUE(i) OVER (ORDER BY i ROWS BETWEEN 1 FOLLOWING AND 2 FOLLOWING) AS\nf_1f2f,\n LAST_VALUE(i) OVER (ORDER BY i ROWS BETWEEN 1 FOLLOWING AND 2 FOLLOWING) AS\nl_1f2f\nFROM t1;\n\n+------+------+------+--------+--------+--------+--------+--------+--------+\n| i    | f_1f | l_1f | f_1p1f | l_1p1f | f_2p1p | l_2p1p | f_1f2f | l_1f2f |\n+------+------+------+--------+--------+--------+--------+--------+--------+\n|    1 |    1 |    2 |      1 |      2 |   NULL |   NULL |      2 |      3 |\n|    2 |    2 |    3 |      1 |      3 |      1 |      1 |      3 |      4 |\n|    3 |    3 |    4 |      2 |      4 |      1 |      2 |      4 |      5 |\n|    4 |    4 |    5 |      3 |      5 |      2 |      3 |      5 |      6 |\n|    5 |    5 |    6 |      4 |      6 |      3 |      4 |      6 |      7 |\n|    6 |    6 |    7 |      5 |      7 |      4 |      5 |      7 |      8 |\n|    7 |    7 |    8 |      6 |      8 |      5 |      6 |      8 |      9 |\n|    8 |    8 |    9 |      7 |      9 |      6 |      7 |      9 |     10 |\n|    9 |    9 |   10 |      8 |     10 |      7 |      8 |     10 |     10 |\n|   10 |   10 |   10 |      9 |     10 |      8 |      9 |   NULL |   NULL |\n+------+------+------+--------+--------+--------+--------+--------+--------+\n\nURL: https://mariadb.com/kb/en/last_value/','','https://mariadb.com/kb/en/last_value/'),
(213,'VERSION',17,'Syntax\n------\n\nVERSION()\n\nDescription\n-----------\n\nReturns a string that indicates the MariaDB server version. The string uses\nthe utf8 character set.\n\nExamples\n--------\n\nSELECT VERSION();\n+----------------+\n| VERSION()      |\n+----------------+\n| 10.4.7-MariaDB |\n+----------------+\n\nThe VERSION() string may have one or more of the following suffixes:\n\n+---------------------------+------------------------------------------------+\n| Suffix                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| -embedded                 | The server is an embedded server               |\n|                           | (libmariadbd).                                 |\n+---------------------------+------------------------------------------------+\n| -log                      | General logging, slow logging or binary        |\n|                           | (replication) logging is enabled.              |\n+---------------------------+------------------------------------------------+\n| -debug                    | The server is compiled for debugging.          |\n+---------------------------+------------------------------------------------+\n| -valgrind                 | The server is compiled to be instrumented      |\n|                           | with valgrind.                                 |\n+---------------------------+------------------------------------------------+\n\nChanging the Version String\n---------------------------\n\nSome old legacy code may break because they are parsing the VERSION string and\nexpecting a MySQL string or a simple version string like Joomla til API17, see\nMDEV-7780.\n\nOne can fool these applications by setting the version string from the command\nline or the my.cnf files with --version=....\n\nURL: https://mariadb.com/kb/en/version/','','https://mariadb.com/kb/en/version/'),
(500,'ST_DISTANCE_SPHERE',30,'MariaDB starting with 10.2.38\n-----------------------------\nST_DISTANCE_SPHERE was introduced in MariaDB 10.2.38, MariaDB 10.3.29, MariaDB\n10.4.19 and MariaDB 10.5.10.\n\nSyntax\n------\n\nST_DISTANCE_SPHERE(g1,g2,[r])\n\nDescription\n-----------\n\nReturns the spherical distance between two geometries (point or multipoint) on\na sphere with the optional radius r (default is the Earth radius if r is not\nspecified), or NULL if not given valid inputs.\n\nExample\n-------\n\nset @zenica   = ST_GeomFromText(\'POINT(17.907743 44.203438)\');\nset @sarajevo = ST_GeomFromText(\'POINT(18.413076 43.856258)\');\nSELECT ST_Distance_Sphere(@zenica, @sarajevo);\n55878.59337591705\n\nURL: https://mariadb.com/kb/en/st_distance_sphere/','','https://mariadb.com/kb/en/st_distance_sphere/'),
(503,'ST_LENGTH',30,'Syntax\n------\n\nST_LENGTH(ls)\n\nDescription\n-----------\n\nReturns as a double-precision number the length of the LineString value ls in\nits associated spatial reference.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT ST_LENGTH(ST_GeomFromText(@ls));\n+---------------------------------+\n| ST_LENGTH(ST_GeomFromText(@ls)) |\n+---------------------------------+\n|                2.82842712474619 |\n+---------------------------------+\n\nURL: https://mariadb.com/kb/en/st_length/','','https://mariadb.com/kb/en/st_length/'),
(207,'ROWNUM',17,'MariaDB starting with 10.6.1\n----------------------------\nFrom MariaDB 10.6.1, the ROWNUM() function is supported.\n\nSyntax\n------\n\nROWNUM()\n\nIn Oracle mode one can just use ROWNUM, without the parentheses.\n\nDescription\n-----------\n\nROWNUM() returns the current number of accepted rows in the current context.\nIt main purpose is to emulate the ROWNUM pseudo column in Oracle. For MariaDB\nnative applications, we recommend the usage of LIMIT, as it is easier to use\nand gives more predictable results than the usage of ROWNUM().\n\nThe main difference between using LIMIT and ROWNUM() to limit the rows in the\nresult is that LIMIT works on the result set while ROWNUM works on the number\nof accepted rows (before any ORDER or GROUP BY clauses).\n\nThe following queries will return the same results:\n\nSELECT * from t1 LIMIT 10;\nSELECT * from t1 WHERE ROWNUM() <= 10;\n\nWhile the following may return different results based on in which orders the\nrows are found:\n\nSELECT * from t1 ORDER BY a LIMIT 10;\nSELECT * from t1 ORDER BY a WHERE ROWNUM() <= 10;\n\nThe recommended way to use ROWNUM to limit the number of returned rows and get\npredictable results is to have the query in a subquery and test for ROWNUM()\nin the outer query:\n\nSELECT * FROM (select * from t1 ORDER BY a) WHERE ROWNUM() <= 10;\n\nROWNUM() can be used in the following contexts:\n\n* SELECT\n* INSERT\n* UPDATE\n* DELETE\n* LOAD DATA INFILE\n\nUsed in other contexts, ROWNUM() will return 0.\n\nExamples\n--------\n\nINSERT INTO t1 VALUES (1,ROWNUM()),(2,ROWNUM()),(3,ROWNUM());\n\nINSERT INTO t1 VALUES (1),(2) returning a, ROWNUM();\n\nUPDATE t1 SET row_num_column=ROWNUM();\n\nDELETE FROM t1 WHERE a < 10 AND ROWNUM() < 2;\n\nLOAD DATA INFILE \'filename\' into table t1 fields terminated by \',\' \n lines terminated by \"\\r\\n\" (a,b) set c=ROWNUM();\n\nOptimizations\n-------------\n\nIn many cases where ROWNUM() is used, MariaDB will use the same optimizations\nit uses with LIMIT.\n\nLIMIT optimization is possible when using ROWNUM in the following manner:\n\n* When one is in a top level WHERE clause comparing ROWNUM() with a numerical\nconstant using any of the following expressions:\nROWNUM() < number\nROWNUM() <= number\nROWNUM() = 1\nROWNUM() can be also be the right argument to the comparison function.\n\nIn the above cases, LIMIT optimization can be done in the following cases:\n\n* For the current sub query when the ROWNUM comparison is done on the top\nlevel:\n\nSELECT * from t1 WHERE ROWNUM() <= 2 AND t1.a > 0\n\n* For an inner sub query, when the upper level has only a ROWNUM() comparison\nin the WHERE clause:\n\nSELECT * from (select * from t1) as t WHERE ROWNUM() <= 2\n\nOther Changes Related to ROWNUM\n-------------------------------\n\nWhen ROWNUM() is used anywhere in a query, the optimization to ignore ORDER BY\nin subqueries are disabled.\n\nThis was done to get the following common Oracle query to work as expected:\n\nselect * from (select * from t1 order by a desc) as t where rownum() <= 2;\n\nBy default MariaDB ignores any ORDER BY in subqueries both because the SQL\nstandard defines results sets in subqueries to be un-ordered and because of\nperformance reasons (especially when using views in subqueries). See MDEV-3926\n\"Wrong result with GROUP BY ... WITH ROLLUP\" for a discussion of this topic.\n\nOther Considerations\n--------------------\n\nWhile MariaDB tries to emulate Oracle\'s usage of ROWNUM() as closely as\npossible, there are cases where the result is different:\n\n* When the optimizer finds rows in a different order (because of different\nstorage methods or optimization). This may also happen in Oracle if one adds\nor deletes an index, in which case the rows may be found in a different order.\n\nNote that usage of ROWNUM() in functions or stored procedures will use their\nown context, not the caller\'s context.\n\nURL: https://mariadb.com/kb/en/rownum/','','https://mariadb.com/kb/en/rownum/'),
(215,'Assignment Operator (=)',18,'Syntax\n------\n\nidentifier = expr\n\nDescription\n-----------\n\nThe equal sign is used as both an assignment operator in certain contexts, and\nas a comparison operator. When used as assignment operator, the value on the\nright is assigned to the variable (or column, in some contexts) on the left.\n\nSince its use can be ambiguous, unlike the := assignment operator, the =\nassignment operator cannot be used in all contexts, and is only valid as part\nof a SET statement, or the SET clause of an UPDATE statement\n\nThis operator works with both user-defined variables and local variables.\n\nExamples\n--------\n\nUPDATE table_name SET x = 2 WHERE x > 100;\n\nSET @x = 1, @y := 2;\n\nURL: https://mariadb.com/kb/en/assignment-operators-assignment-operator/','','https://mariadb.com/kb/en/assignment-operators-assignment-operator/'),
(216,'Not Equal Operator',19,'Syntax\n------\n\n<>, !=\n\nDescription\n-----------\n\nNot equal operator. Evaluates both SQL expressions and returns 1 if they are\nnot equal and 0 if they are equal, or NULL if either expression is NULL. If\nthe expressions return different data types, (for instance, a number and a\nstring), performs type conversion.\n\nWhen used in row comparisons these two queries return the same results:\n\nSELECT (t1.a, t1.b) != (t2.x, t2.y) \nFROM t1 INNER JOIN t2;\n\nSELECT (t1.a != t2.x) OR (t1.b != t2.y)\nFROM t1 INNER JOIN t2;\n\nExamples\n--------\n\nSELECT \'.01\' <> \'0.01\';\n+-----------------+\n| \'.01\' <> \'0.01\' |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT .01 <> \'0.01\';\n+---------------+\n| .01 <> \'0.01\' |\n+---------------+\n|             0 |\n+---------------+\n\nSELECT \'zapp\' <> \'zappp\';\n+-------------------+\n| \'zapp\' <> \'zappp\' |\n+-------------------+\n|                 1 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/not-equal/','','https://mariadb.com/kb/en/not-equal/'),
(504,'ST_OVERLAPS',30,'Syntax\n------\n\nST_OVERLAPS(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether geometry g1 spatially overlaps geometry g2.\n\nThe term spatially overlaps is used if two geometries intersect and their\nintersection results in a geometry of the same dimension but not equal to\neither of the given geometries.\n\nST_OVERLAPS() uses object shapes, while OVERLAPS(), based on the original\nMySQL implementation, uses object bounding rectangles.\n\nURL: https://mariadb.com/kb/en/st-overlaps/','','https://mariadb.com/kb/en/st-overlaps/'),
(507,'TOUCHES',30,'Syntax\n------\n\nTouches(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether g1 spatially touches g2. Two geometries\nspatially touch if the interiors of the geometries do not intersect, but the\nboundary of one of the geometries intersects either the boundary or the\ninterior of the other.\n\nTOUCHES() is based on the original MySQL implementation and uses object\nbounding rectangles, while ST_TOUCHES() uses object shapes.\n\nURL: https://mariadb.com/kb/en/touches/','','https://mariadb.com/kb/en/touches/'),
(516,'CURRENT_DATE',31,'Syntax\n------\n\nCURRENT_DATE, CURRENT_DATE()\n\nDescription\n-----------\n\nCURRENT_DATE and CURRENT_DATE() are synonyms for CURDATE().\n\nURL: https://mariadb.com/kb/en/current_date/','','https://mariadb.com/kb/en/current_date/'),
(517,'CURRENT_TIME',31,'Syntax\n------\n\nCURRENT_TIME\nCURRENT_TIME([precision])\n\nDescription\n-----------\n\nCURRENT_TIME and CURRENT_TIME() are synonyms for CURTIME().\n\nURL: https://mariadb.com/kb/en/current_time/','','https://mariadb.com/kb/en/current_time/'),
(518,'CURRENT_TIMESTAMP',31,'Syntax\n------\n\nCURRENT_TIMESTAMP\nCURRENT_TIMESTAMP([precision])\n\nDescription\n-----------\n\nCURRENT_TIMESTAMP and CURRENT_TIMESTAMP() are synonyms for NOW().\n\nURL: https://mariadb.com/kb/en/current_timestamp/','','https://mariadb.com/kb/en/current_timestamp/'),
(217,'<',19,'Syntax\n------\n\n<\n\nDescription\n-----------\n\nLess than operator. Evaluates both SQL expressions and returns 1 if the left\nvalue is less than the right value and 0 if it is not, or NULL if either\nexpression is NULL. If the expressions return different data types, (for\ninstance, a number and a string), performs type conversion.\n\nWhen used in row comparisons these two queries return the same results:\n\nSELECT (t1.a, t1.b) < (t2.x, t2.y) \nFROM t1 INNER JOIN t2;\n\nSELECT (t1.a < t2.x) OR ((t1.a = t2.x) AND (t1.b < t2.y))\nFROM t1 INNER JOIN t2;\n\nExamples\n--------\n\nSELECT 2 < 2;\n+-------+\n| 2 < 2 |\n+-------+\n|     0 |\n+-------+\n\nType conversion:\n\nSELECT 3<\'4\';\n+-------+\n| 3<\'4\' |\n+-------+\n|     1 |\n+-------+\n\nCase insensitivity - see Character Sets and Collations:\n\nSELECT \'a\'<\'A\';\n+---------+\n| \'a\'<\'A\' |\n+---------+\n|       0 |\n+---------+\n\nURL: https://mariadb.com/kb/en/less-than/','','https://mariadb.com/kb/en/less-than/'),
(218,'<=',19,'Syntax\n------\n\n<=\n\nDescription\n-----------\n\nLess than or equal operator. Evaluates both SQL expressions and returns 1 if\nthe left value is less than or equal to the right value and 0 if it is not, or\nNULL if either expression is NULL. If the expressions return different data\ntypes, (for instance, a number and a string), performs type conversion.\n\nWhen used in row comparisons these two queries return the same results:\n\nSELECT (t1.a, t1.b) <= (t2.x, t2.y) \nFROM t1 INNER JOIN t2;\n\nSELECT (t1.a < t2.x) OR ((t1.a = t2.x) AND (t1.b <= t2.y))\nFROM t1 INNER JOIN t2;\n\nExamples\n--------\n\nSELECT 0.1 <= 2;\n+----------+\n| 0.1 <= 2 |\n+----------+\n|        1 |\n+----------+\n\nSELECT \'a\'<=\'A\';\n+----------+\n| \'a\'<=\'A\' |\n+----------+\n|        1 |\n+----------+\n\nURL: https://mariadb.com/kb/en/less-than-or-equal/','','https://mariadb.com/kb/en/less-than-or-equal/'),
(219,'<=>',19,'Syntax\n------\n\n<=>\n\nDescription\n-----------\n\nNULL-safe equal operator. It performs an equality comparison like the =\noperator, but returns 1 rather than NULL if both operands are NULL, and 0\nrather than NULL if one operand is NULL.\n\na <=> b is equivalent to a = b OR (a IS NULL AND b IS NULL).\n\nWhen used in row comparisons these two queries return the same results:\n\nSELECT (t1.a, t1.b) <=> (t2.x, t2.y) \nFROM t1 INNER JOIN t2;\n\nSELECT (t1.a <=> t2.x) AND (t1.b <=> t2.y)\nFROM t1 INNER JOIN t2;\n\nSee also NULL Values in MariaDB.\n\nExamples\n--------\n\nSELECT 1 <=> 1, NULL <=> NULL, 1 <=> NULL;\n+---------+---------------+------------+\n| 1 <=> 1 | NULL <=> NULL | 1 <=> NULL |\n+---------+---------------+------------+\n|       1 |             1 |          0 |\n+---------+---------------+------------+\n\nSELECT 1 = 1, NULL = NULL, 1 = NULL;\n+-------+-------------+----------+\n| 1 = 1 | NULL = NULL | 1 = NULL |\n+-------+-------------+----------+\n|     1 |        NULL |     NULL |\n+-------+-------------+----------+\n\nURL: https://mariadb.com/kb/en/null-safe-equal/','','https://mariadb.com/kb/en/null-safe-equal/'),
(220,'=',19,'Syntax\n------\n\nleft_expr = right_expr\n\nDescription\n-----------\n\nEqual operator. Evaluates both SQL expressions and returns 1 if they are\nequal, 0 if they are not equal, or NULL if either expression is NULL. If the\nexpressions return different data types (for example, a number and a string),\na type conversion is performed.\n\nWhen used in row comparisons these two queries are synonymous and return the\nsame results:\n\nSELECT (t1.a, t1.b) = (t2.x, t2.y) FROM t1 INNER JOIN t2;\n\nSELECT (t1.a = t2.x) AND (t1.b = t2.y) FROM t1 INNER JOIN t2;\n\nTo perform a NULL-safe comparison, use the <=> operator.\n\n= can also be used as an assignment operator.\n\nExamples\n--------\n\nSELECT 1 = 0;\n+-------+\n| 1 = 0 |\n+-------+\n|     0 |\n+-------+\n\nSELECT \'0\' = 0;\n+---------+\n| \'0\' = 0 |\n+---------+\n|       1 |\n+---------+\n\nSELECT \'0.0\' = 0;\n+-----------+\n| \'0.0\' = 0 |\n+-----------+\n|         1 |\n+-----------+\n\nSELECT \'0.01\' = 0;\n+------------+\n| \'0.01\' = 0 |\n+------------+\n|          0 |\n+------------+\n\nSELECT \'.01\' = 0.01;\n+--------------+\n| \'.01\' = 0.01 |\n+--------------+\n|            1 |\n+--------------+\n\nSELECT (5 * 2) = CONCAT(\'1\', \'0\');\n+----------------------------+\n| (5 * 2) = CONCAT(\'1\', \'0\') |\n+----------------------------+\n|                          1 |\n+----------------------------+\n\nSELECT 1 = NULL;\n+----------+\n| 1 = NULL |\n+----------+\n|     NULL |\n+----------+\n\nSELECT NULL = NULL;\n+-------------+\n| NULL = NULL |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/equal/','','https://mariadb.com/kb/en/equal/'),
(221,'>',19,'Syntax\n------\n\n>\n\nDescription\n-----------\n\nGreater than operator. Evaluates both SQL expressions and returns 1 if the\nleft value is greater than the right value and 0 if it is not, or NULL if\neither expression is NULL. If the expressions return different data types,\n(for instance, a number and a string), performs type conversion.\n\nWhen used in row comparisons these two queries return the same results:\n\nSELECT (t1.a, t1.b) > (t2.x, t2.y) \nFROM t1 INNER JOIN t2;\n\nSELECT (t1.a > t2.x) OR ((t1.a = t2.x) AND (t1.b > t2.y))\nFROM t1 INNER JOIN t2;\n\nExamples\n--------\n\nSELECT 2 > 2;\n+-------+\n| 2 > 2 |\n+-------+\n|     0 |\n+-------+\n\nSELECT \'b\' > \'a\';\n+-----------+\n| \'b\' > \'a\' |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/greater-than/','','https://mariadb.com/kb/en/greater-than/'),
(519,'CURTIME',31,'Syntax\n------\n\nCURTIME([precision])\n\nDescription\n-----------\n\nReturns the current time as a value in \'HH:MM:SS\' or HHMMSS.uuuuuu format,\ndepending on whether the function is used in a string or numeric context. The\nvalue is expressed in the current time zone.\n\nThe optional precision determines the microsecond precision. See Microseconds\nin MariaDB.\n\nExamples\n--------\n\nSELECT CURTIME();\n+-----------+\n| CURTIME() |\n+-----------+\n| 12:45:39  |\n+-----------+\n\nSELECT CURTIME() + 0;\n+---------------+\n| CURTIME() + 0 |\n+---------------+\n| 124545.000000 |\n+---------------+\n\nWith precision:\n\nSELECT CURTIME(2);\n+-------------+\n| CURTIME(2)  |\n+-------------+\n| 09:49:08.09 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/curtime/','','https://mariadb.com/kb/en/curtime/'),
(520,'DATE FUNCTION',31,'Syntax\n------\n\nDATE(expr)\n\nDescription\n-----------\n\nExtracts the date part of the date or datetime expression expr. Returns NULL\nand throws a warning when passed an invalid date.\n\nExamples\n--------\n\nSELECT DATE(\'2013-07-18 12:21:32\');\n+-----------------------------+\n| DATE(\'2013-07-18 12:21:32\') |\n+-----------------------------+\n| 2013-07-18                  |\n+-----------------------------+\n\nURL: https://mariadb.com/kb/en/date-function/','','https://mariadb.com/kb/en/date-function/'),
(523,'DATE_FORMAT',31,'Syntax\n------\n\nDATE_FORMAT(date, format[, locale])\n\nDescription\n-----------\n\nFormats the date value according to the format string.\n\nThe language used for the names is controlled by the value of the\nlc_time_names system variable. See server locale for more on the supported\nlocales.\n\nThe options that can be used by DATE_FORMAT(), as well as its inverse\nSTR_TO_DATE() and the FROM_UNIXTIME() function, are:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| %a                        | Short weekday name in current locale           |\n|                           | (Variable lc_time_names).                      |\n+---------------------------+------------------------------------------------+\n| %b                        | Short form month name in current locale. For   |\n|                           | locale en_US this is one of:                   |\n|                           | Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov    |\n|                           | or Dec.                                        |\n+---------------------------+------------------------------------------------+\n| %c                        | Month with 1 or 2 digits.                      |\n+---------------------------+------------------------------------------------+\n| %D                        | Day with English suffix \'th\', \'nd\', \'st\' or    |\n|                           | \'rd\'\'. (1st, 2nd, 3rd...).                     |\n+---------------------------+------------------------------------------------+\n| %d                        | Day with 2 digits.                             |\n+---------------------------+------------------------------------------------+\n| %e                        | Day with 1 or 2 digits.                        |\n+---------------------------+------------------------------------------------+\n| %f                        | Microseconds 6 digits.                         |\n+---------------------------+------------------------------------------------+\n| %H                        | Hour with 2 digits between 00-23.              |\n+---------------------------+------------------------------------------------+\n| %h                        | Hour with 2 digits between 01-12.              |\n+---------------------------+------------------------------------------------+\n| %I                        | Hour with 2 digits between 01-12.              |\n+---------------------------+------------------------------------------------+\n| %i                        | Minute with 2 digits.                          |\n+---------------------------+------------------------------------------------+\n| %j                        | Day of the year (001-366)                      |\n+---------------------------+------------------------------------------------+\n| %k                        | Hour with 1 digits between 0-23.               |\n+---------------------------+------------------------------------------------+\n| %l                        | Hour with 1 digits between 1-12.               |\n+---------------------------+------------------------------------------------+\n| %M                        | Full month name in current locale (Variable    |\n|                           | lc_time_names).                                |\n+---------------------------+------------------------------------------------+\n| %m                        | Month with 2 digits.                           |\n+---------------------------+------------------------------------------------+\n| %p                        | AM/PM according to current locale (Variable    |\n|                           | lc_time_names).                                |\n+---------------------------+------------------------------------------------+\n| %r                        | Time in 12 hour format, followed by AM/PM.     |\n|                           | Short for \'%I:%i:%S %p\'.                       |\n+---------------------------+------------------------------------------------+\n| %S                        | Seconds with 2 digits.                         |\n+---------------------------+------------------------------------------------+\n| %s                        | Seconds with 2 digits.                         |\n+---------------------------+------------------------------------------------+\n| %T                        | Time in 24 hour format. Short for \'%H:%i:%S\'.  |\n+---------------------------+------------------------------------------------+\n| %U                        | Week number (00-53), when first day of the     |\n|                           | week is Sunday.                                |\n+---------------------------+------------------------------------------------+\n| %u                        | Week number (00-53), when first day of the     |\n|                           | week is Monday.                                |\n+---------------------------+------------------------------------------------+\n| %V                        | Week number (01-53), when first day of the     |\n|                           | week is Sunday. Used with %X.                  |\n+---------------------------+------------------------------------------------+\n| %v                        | Week number (01-53), when first day of the     |\n|                           | week is Monday. Used with %x.                  |\n+---------------------------+------------------------------------------------+\n| %W                        | Full weekday name in current locale (Variable  |\n|                           | lc_time_names).                                |\n+---------------------------+------------------------------------------------+\n| %w                        | Day of the week. 0 = Sunday, 6 = Saturday.     |\n+---------------------------+------------------------------------------------+\n| %X                        | Year with 4 digits when first day of the week  |\n|                           | is Sunday. Used with %V.                       |\n+---------------------------+------------------------------------------------+\n| %x                        | Year with 4 digits when first day of the week  |\n|                           | is Monday. Used with %v.                       |\n+---------------------------+------------------------------------------------+\n| %Y                        | Year with 4 digits.                            |\n+---------------------------+------------------------------------------------+\n| %y                        | Year with 2 digits.                            |\n+---------------------------+------------------------------------------------+\n| %#                        | For str_to_date(), skip all numbers.           |\n+---------------------------+------------------------------------------------+\n| %.                        | For str_to_date(), skip all punctation         |\n|                           | characters.                                    |\n+---------------------------+------------------------------------------------+\n| %@                        | For str_to_date(), skip all alpha characters.  |\n+---------------------------+------------------------------------------------+\n| %%                        | A literal % character.                         |\n+---------------------------+------------------------------------------------+\n\nTo get a date in one of the standard formats, GET_FORMAT() can be used.\n\nExamples\n--------\n\nSELECT DATE_FORMAT(\'2009-10-04 22:23:00\', \'%W %M %Y\');\n+------------------------------------------------+\n| DATE_FORMAT(\'2009-10-04 22:23:00\', \'%W %M %Y\') |\n+------------------------------------------------+\n| Sunday October 2009                            |\n+------------------------------------------------+\n\nSELECT DATE_FORMAT(\'2007-10-04 22:23:00\', \'%H:%i:%s\');\n+------------------------------------------------+\n| DATE_FORMAT(\'2007-10-04 22:23:00\', \'%H:%i:%s\') |\n+------------------------------------------------+\n| 22:23:00                                       |\n+------------------------------------------------+\n\nSELECT DATE_FORMAT(\'1900-10-04 22:23:00\', \'%D %y %a %d %m %b %j\');\n+------------------------------------------------------------+\n| DATE_FORMAT(\'1900-10-04 22:23:00\', \'%D %y %a %d %m %b %j\') |\n+------------------------------------------------------------+\n| 4th 00 Thu 04 10 Oct 277                                   |\n+------------------------------------------------------------+\n\nSELECT DATE_FORMAT(\'1997-10-04 22:23:00\', \'%H %k %I %r %T %S %w\');\n+------------------------------------------------------------+\n| DATE_FORMAT(\'1997-10-04 22:23:00\', \'%H %k %I %r %T %S %w\') |\n+------------------------------------------------------------+\n| 22 22 10 10:23:00 PM 22:23:00 00 6                         |\n+------------------------------------------------------------+\n\nSELECT DATE_FORMAT(\'1999-01-01\', \'%X %V\');\n+------------------------------------+\n| DATE_FORMAT(\'1999-01-01\', \'%X %V\') |\n+------------------------------------+\n| 1998 52                            |\n+------------------------------------+\n\nSELECT DATE_FORMAT(\'2006-06-00\', \'%d\');\n+---------------------------------+\n| DATE_FORMAT(\'2006-06-00\', \'%d\') |\n+---------------------------------+\n| 00                              |\n+---------------------------------+\n\nOptionally, the locale can be explicitly specified as the third DATE_FORMAT()\nargument. Doing so makes the function independent from the session settings,\nand the three argument version of DATE_FORMAT() can be used in virtual indexed\nand persistent generated-columns:\n\nSELECT DATE_FORMAT(\'2006-01-01\', \'%W\', \'el_GR\');\n+------------------------------------------+\n| DATE_FORMAT(\'2006-01-01\', \'%W\', \'el_GR\') |\n+------------------------------------------+\n| Κυριακή                                  |\n+------------------------------------------+\n\nURL: https://mariadb.com/kb/en/date_format/','','https://mariadb.com/kb/en/date_format/'),
(525,'DAY',31,'Syntax\n------\n\nDAY(date)\n\nDescription\n-----------\n\nDAY() is a synonym for DAYOFMONTH().\n\nURL: https://mariadb.com/kb/en/day/','','https://mariadb.com/kb/en/day/'),
(529,'DAYOFYEAR',31,'Syntax\n------\n\nDAYOFYEAR(date)\n\nDescription\n-----------\n\nReturns the day of the year for date, in the range 1 to 366.\n\nExamples\n--------\n\nSELECT DAYOFYEAR(\'2018-02-16\');\n+-------------------------+\n| DAYOFYEAR(\'2018-02-16\') |\n+-------------------------+\n|                      47 |\n+-------------------------+\n\nURL: https://mariadb.com/kb/en/dayofyear/','','https://mariadb.com/kb/en/dayofyear/'),
(531,'FROM_DAYS',31,'Syntax\n------\n\nFROM_DAYS(N)\n\nDescription\n-----------\n\nGiven a day number N, returns a DATE value. The day count is based on the\nnumber of days from the start of the standard calendar (0000-00-00).\n\nThe function is not designed for use with dates before the advent of the\nGregorian calendar in October 1582. Results will not be reliable since it\ndoesn\'t account for the lost days when the calendar changed from the Julian\ncalendar.\n\nThis is the converse of the TO_DAYS() function.\n\nExamples\n--------\n\nSELECT FROM_DAYS(730669);\n+-------------------+\n| FROM_DAYS(730669) |\n+-------------------+\n| 2000-07-03        |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/from_days/','','https://mariadb.com/kb/en/from_days/'),
(222,'>=',19,'Syntax\n------\n\n>=\n\nDescription\n-----------\n\nGreater than or equal operator. Evaluates both SQL expressions and returns 1\nif the left value is greater than or equal to the right value and 0 if it is\nnot, or NULL if either expression is NULL. If the expressions return different\ndata types, (for instance, a number and a string), performs type conversion.\n\nWhen used in row comparisons these two queries return the same results:\n\nSELECT (t1.a, t1.b) >= (t2.x, t2.y) \nFROM t1 INNER JOIN t2;\n\nSELECT (t1.a > t2.x) OR ((t1.a = t2.x) AND (t1.b >= t2.y))\nFROM t1 INNER JOIN t2;\n\nExamples\n--------\n\nSELECT 2 >= 2;\n+--------+\n| 2 >= 2 |\n+--------+\n|      1 |\n+--------+\n\nSELECT \'A\' >= \'a\';\n+------------+\n| \'A\' >= \'a\' |\n+------------+\n|          1 |\n+------------+\n\nURL: https://mariadb.com/kb/en/greater-than-or-equal/','','https://mariadb.com/kb/en/greater-than-or-equal/'),
(223,'BETWEEN AND',19,'Syntax\n------\n\nexpr BETWEEN min AND max\n\nDescription\n-----------\n\nIf expr is greater than or equal to min and expr is less than or equal to max,\nBETWEEN returns 1, otherwise it returns 0. This is equivalent to the\nexpression (min <= expr AND expr <= max) if all the arguments are of the same\ntype. Otherwise type conversion takes place according to the rules described\nat Type Conversion, but applied to all the three arguments.\n\nExamples\n--------\n\nSELECT 1 BETWEEN 2 AND 3;\n+-------------------+\n| 1 BETWEEN 2 AND 3 |\n+-------------------+\n|                 0 |\n+-------------------+\n\nSELECT \'b\' BETWEEN \'a\' AND \'c\';\n+-------------------------+\n| \'b\' BETWEEN \'a\' AND \'c\' |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT 2 BETWEEN 2 AND \'3\';\n+---------------------+\n| 2 BETWEEN 2 AND \'3\' |\n+---------------------+\n|                   1 |\n+---------------------+\n\nSELECT 2 BETWEEN 2 AND \'x-3\';\n+-----------------------+\n| 2 BETWEEN 2 AND \'x-3\' |\n+-----------------------+\n|                     0 |\n+-----------------------+\n1 row in set, 1 warning (0.00 sec)\n\nWarning (Code 1292): Truncated incorrect DOUBLE value: \'x-3\'\n\nNULL:\n\nSELECT 1 BETWEEN 1 AND NULL;\n+----------------------+\n| 1 BETWEEN 1 AND NULL |\n+----------------------+\n|                 NULL |\n+----------------------+\n\nDATE, DATETIME and TIMESTAMP examples. Omitting the time component compares\nagainst 00:00, so later times on the same date are not returned:\n\nCREATE TABLE `x` (\n a date ,\n b datetime,\n c timestamp\n)\n\nINSERT INTO x VALUES \n (\'2018-11-11\', \'2018-11-11 05:15\', \'2018-11-11 05:15\'), \n (\'2018-11-12\', \'2018-11-12 05:15\', \'2018-11-12 05:15\');\n\nSELECT * FROM x WHERE a BETWEEN \'2018-11-11\' AND \'2018-11-12\';\n+------------+---------------------+---------------------+\n| a          | b                   | c                   |\n+------------+---------------------+---------------------+\n| 2018-11-11 | 2018-11-11 05:15:00 | 2018-11-11 05:15:00 |\n| 2018-11-12 | 2018-11-12 05:15:00 | 2018-11-12 05:15:00 |\n+------------+---------------------+---------------------+\n\nSELECT * FROM x WHERE b BETWEEN \'2018-11-11\' AND \'2018-11-12\';\n+------------+---------------------+---------------------+\n| a          | b                   | c                   |\n+------------+---------------------+---------------------+\n| 2018-11-11 | 2018-11-11 05:15:00 | 2018-11-11 05:15:00 |\n+------------+---------------------+---------------------+\n\nSELECT * FROM x WHERE c BETWEEN \'2018-11-11\' AND \'2018-11-12\';\n+------------+---------------------+---------------------+\n| a          | b                   | c                   |\n+------------+---------------------+---------------------+\n| 2018-11-11 | 2018-11-11 05:15:00 | 2018-11-11 05:15:00 |\n+------------+---------------------+---------------------+\n\nURL: https://mariadb.com/kb/en/between-and/','','https://mariadb.com/kb/en/between-and/'),
(224,'COALESCE',19,'Syntax\n------\n\nCOALESCE(value,...)\n\nDescription\n-----------\n\nReturns the first non-NULL value in the list, or NULL if there are no non-NULL\nvalues. At least one parameter must be passed.\n\nThe function is useful when substituting a default value for null values when\ndisplaying data.\n\nSee also NULL Values in MariaDB.\n\nExamples\n--------\n\nSELECT COALESCE(NULL,1);\n+------------------+\n| COALESCE(NULL,1) |\n+------------------+\n|                1 |\n+------------------+\n\nSELECT COALESCE(NULL,NULL,NULL);\n+--------------------------+\n| COALESCE(NULL,NULL,NULL) |\n+--------------------------+\n|                     NULL |\n+--------------------------+\n\nWhen two arguments are given, COALESCE() is the same as IFNULL():\n\nSET @a=NULL, @b=1;\n\nSELECT COALESCE(@a, @b), IFNULL(@a, @b);\n+------------------+----------------+\n| COALESCE(@a, @b) | IFNULL(@a, @b) |\n+------------------+----------------+\n|                1 |              1 |\n+------------------+----------------+\n\nHex type confusion:\n\nCREATE TABLE t1 (a INT, b VARCHAR(10));\nINSERT INTO t1 VALUES (0x31, 0x61),(COALESCE(0x31), COALESCE(0x61));\n\nSELECT * FROM t1;\n+------+------+\n| a    | b    |\n+------+------+\n|   49 | a    |\n|    1 | a    |\n+------+------+\n\nThe reason for the differing results above is that when 0x31 is inserted\ndirectly to the column, it\'s treated as a number (see Hexadecimal Literals),\nwhile when 0x31 is passed to COALESCE(), it\'s treated as a string, because:\n\n* HEX values have a string data type by default.\n* COALESCE() has the same data type as the argument.\n\nSubstituting zero for NULL (in this case when the aggregate function returns\nNULL after finding no rows):\n\nSELECT SUM(score) FROM student;\n+------------+\n| SUM(score) |\n+------------+\n|       NULL |\n+------------+\n\nSELECT COALESCE(SUM(score),0) FROM student;\n+------------------------+\n| COALESCE(SUM(score),0) |\n+------------------------+\n|                      0 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/coalesce/','','https://mariadb.com/kb/en/coalesce/'),
(532,'FROM_UNIXTIME',31,'Syntax\n------\n\nFROM_UNIXTIME(unix_timestamp), FROM_UNIXTIME(unix_timestamp,format)\n\nDescription\n-----------\n\nReturns a representation of the unix_timestamp argument as a value in\n\'YYYY-MM-DD HH:MM:SS\' or YYYYMMDDHHMMSS.uuuuuu format, depending on whether\nthe function is used in a string or numeric context. The value is expressed in\nthe current time zone. unix_timestamp is an internal timestamp value such as\nis produced by the UNIX_TIMESTAMP() function.\n\nIf format is given, the result is formatted according to the format string,\nwhich is used the same way as listed in the entry for the DATE_FORMAT()\nfunction.\n\nTimestamps in MariaDB have a maximum value of 2147483647, equivalent to\n2038-01-19 05:14:07. This is due to the underlying 32-bit limitation. Using\nthe function on a timestamp beyond this will result in NULL being returned.\nUse DATETIME as a storage type if you require dates beyond this.\n\nThe options that can be used by FROM_UNIXTIME(), as well as DATE_FORMAT() and\nSTR_TO_DATE(), are:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| %a                        | Short weekday name in current locale           |\n|                           | (Variable lc_time_names).                      |\n+---------------------------+------------------------------------------------+\n| %b                        | Short form month name in current locale. For   |\n|                           | locale en_US this is one of:                   |\n|                           | Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov    |\n|                           | or Dec.                                        |\n+---------------------------+------------------------------------------------+\n| %c                        | Month with 1 or 2 digits.                      |\n+---------------------------+------------------------------------------------+\n| %D                        | Day with English suffix \'th\', \'nd\', \'st\' or    |\n|                           | \'rd\'\'. (1st, 2nd, 3rd...).                     |\n+---------------------------+------------------------------------------------+\n| %d                        | Day with 2 digits.                             |\n+---------------------------+------------------------------------------------+\n| %e                        | Day with 1 or 2 digits.                        |\n+---------------------------+------------------------------------------------+\n| %f                        | Microseconds 6 digits.                         |\n+---------------------------+------------------------------------------------+\n| %H                        | Hour with 2 digits between 00-23.              |\n+---------------------------+------------------------------------------------+\n| %h                        | Hour with 2 digits between 01-12.              |\n+---------------------------+------------------------------------------------+\n| %I                        | Hour with 2 digits between 01-12.              |\n+---------------------------+------------------------------------------------+\n| %i                        | Minute with 2 digits.                          |\n+---------------------------+------------------------------------------------+\n| %j                        | Day of the year (001-366)                      |\n+---------------------------+------------------------------------------------+\n| %k                        | Hour with 1 digits between 0-23.               |\n+---------------------------+------------------------------------------------+\n| %l                        | Hour with 1 digits between 1-12.               |\n+---------------------------+------------------------------------------------+\n| %M                        | Full month name in current locale (Variable    |\n|                           | lc_time_names).                                |\n+---------------------------+------------------------------------------------+\n| %m                        | Month with 2 digits.                           |\n+---------------------------+------------------------------------------------+\n| %p                        | AM/PM according to current locale (Variable    |\n|                           | lc_time_names).                                |\n+---------------------------+------------------------------------------------+\n| %r                        | Time in 12 hour format, followed by AM/PM.     |\n|                           | Short for \'%I:%i:%S %p\'.                       |\n+---------------------------+------------------------------------------------+\n| %S                        | Seconds with 2 digits.                         |\n+---------------------------+------------------------------------------------+\n| %s                        | Seconds with 2 digits.                         |\n+---------------------------+------------------------------------------------+\n| %T                        | Time in 24 hour format. Short for \'%H:%i:%S\'.  |\n+---------------------------+------------------------------------------------+\n| %U                        | Week number (00-53), when first day of the     |\n|                           | week is Sunday.                                |\n+---------------------------+------------------------------------------------+\n| %u                        | Week number (00-53), when first day of the     |\n|                           | week is Monday.                                |\n+---------------------------+------------------------------------------------+\n| %V                        | Week number (01-53), when first day of the     |\n|                           | week is Sunday. Used with %X.                  |\n+---------------------------+------------------------------------------------+\n| %v                        | Week number (01-53), when first day of the     |\n|                           | week is Monday. Used with %x.                  |\n+---------------------------+------------------------------------------------+\n| %W                        | Full weekday name in current locale (Variable  |\n|                           | lc_time_names).                                |\n+---------------------------+------------------------------------------------+\n| %w                        | Day of the week. 0 = Sunday, 6 = Saturday.     |\n+---------------------------+------------------------------------------------+\n| %X                        | Year with 4 digits when first day of the week  |\n|                           | is Sunday. Used with %V.                       |\n+---------------------------+------------------------------------------------+\n| %x                        | Year with 4 digits when first day of the week  |\n|                           | is Sunday. Used with %v.                       |\n+---------------------------+------------------------------------------------+\n| %Y                        | Year with 4 digits.                            |\n+---------------------------+------------------------------------------------+\n| %y                        | Year with 2 digits.                            |\n+---------------------------+------------------------------------------------+\n| %#                        | For str_to_date(), skip all numbers.           |\n+---------------------------+------------------------------------------------+\n| %.                        | For str_to_date(), skip all punctation         |\n|                           | characters.                                    |\n+---------------------------+------------------------------------------------+\n| %@                        | For str_to_date(), skip all alpha characters.  |\n+---------------------------+------------------------------------------------+\n| %%                        | A literal % character.                         |\n+---------------------------+------------------------------------------------+\n\nPerformance Considerations\n--------------------------\n\nIf your session time zone is set to SYSTEM (the default), FROM_UNIXTIME() will\ncall the OS function to convert the data using the system time zone. At least\non Linux, the corresponding function (localtime_r) uses a global mutex inside\nglibc that can cause contention under high concurrent load.\n\nSet your time zone to a named time zone to avoid this issue. See mysql time\nzone tables for details on how to do this.\n\nExamples\n--------\n\nSELECT FROM_UNIXTIME(1196440219);\n+---------------------------+\n| FROM_UNIXTIME(1196440219) |\n+---------------------------+\n| 2007-11-30 11:30:19       |\n+---------------------------+\n\nSELECT FROM_UNIXTIME(1196440219) + 0;\n+-------------------------------+\n| FROM_UNIXTIME(1196440219) + 0 |\n+-------------------------------+\n|         20071130113019.000000 |\n+-------------------------------+\n\nSELECT FROM_UNIXTIME(UNIX_TIMESTAMP(), \'%Y %D %M %h:%i:%s %x\');\n+---------------------------------------------------------+\n| FROM_UNIXTIME(UNIX_TIMESTAMP(), \'%Y %D %M %h:%i:%s %x\') |\n+---------------------------------------------------------+\n| 2010 27th March 01:03:47 2010                           |\n+---------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/from_unixtime/','','https://mariadb.com/kb/en/from_unixtime/'),
(536,'LOCALTIME',31,'Syntax\n------\n\nLOCALTIME\nLOCALTIME([precision])\n\nDescription\n-----------\n\nLOCALTIME and LOCALTIME() are synonyms for NOW().\n\nURL: https://mariadb.com/kb/en/localtime/','','https://mariadb.com/kb/en/localtime/'),
(537,'LOCALTIMESTAMP',31,'Syntax\n------\n\nLOCALTIMESTAMP\nLOCALTIMESTAMP([precision])\n\nDescription\n-----------\n\nLOCALTIMESTAMP and LOCALTIMESTAMP() are synonyms for NOW().\n\nURL: https://mariadb.com/kb/en/localtimestamp/','','https://mariadb.com/kb/en/localtimestamp/'),
(541,'MINUTE',31,'Syntax\n------\n\nMINUTE(time)\n\nDescription\n-----------\n\nReturns the minute for time, in the range 0 to 59.\n\nExamples\n--------\n\nSELECT MINUTE(\'2013-08-03 11:04:03\');\n+-------------------------------+\n| MINUTE(\'2013-08-03 11:04:03\') |\n+-------------------------------+\n|                             4 |\n+-------------------------------+\n\nSELECT MINUTE (\'23:12:50\');\n+---------------------+\n| MINUTE (\'23:12:50\') |\n+---------------------+\n|                  12 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/minute/','','https://mariadb.com/kb/en/minute/'),
(542,'MONTH',31,'Syntax\n------\n\nMONTH(date)\n\nDescription\n-----------\n\nReturns the month for date in the range 1 to 12 for January to December, or 0\nfor dates such as \'0000-00-00\' or \'2008-00-00\' that have a zero month part.\n\nExamples\n--------\n\nSELECT MONTH(\'2019-01-03\');\n+---------------------+\n| MONTH(\'2019-01-03\') |\n+---------------------+\n|                   1 |\n+---------------------+\n\nSELECT MONTH(\'2019-00-03\');\n+---------------------+\n| MONTH(\'2019-00-03\') |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/month/','','https://mariadb.com/kb/en/month/'),
(226,'IN',19,'Syntax\n------\n\nexpr IN (value,...)\n\nDescription\n-----------\n\nReturns 1 if expr is equal to any of the values in the IN list, else returns\n0. If all values are constants, they are evaluated according to the type of\nexpr and sorted. The search for the item then is done using a binary search.\nThis means IN is very quick if the IN value list consists entirely of\nconstants. Otherwise, type conversion takes place according to the rules\ndescribed at Type Conversion, but applied to all the arguments.\n\nIf expr is NULL, IN always returns NULL. If at least one of the values in the\nlist is NULL, and one of the comparisons is true, the result is 1. If at least\none of the values in the list is NULL and none of the comparisons is true, the\nresult is NULL.\n\nExamples\n--------\n\nSELECT 2 IN (0,3,5,7);\n+----------------+\n| 2 IN (0,3,5,7) |\n+----------------+\n|              0 |\n+----------------+\n\nSELECT \'wefwf\' IN (\'wee\',\'wefwf\',\'weg\');\n+----------------------------------+\n| \'wefwf\' IN (\'wee\',\'wefwf\',\'weg\') |\n+----------------------------------+\n|                                1 |\n+----------------------------------+\n\nType conversion:\n\nSELECT 1 IN (\'1\', \'2\', \'3\');\n+----------------------+\n| 1 IN (\'1\', \'2\', \'3\') |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT NULL IN (1, 2, 3);\n+-------------------+\n| NULL IN (1, 2, 3) |\n+-------------------+\n|              NULL |\n+-------------------+\n\nSELECT 1 IN (1, 2, NULL);\n+-------------------+\n| 1 IN (1, 2, NULL) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT 5 IN (1, 2, NULL);\n+-------------------+\n| 5 IN (1, 2, NULL) |\n+-------------------+\n|              NULL |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/in/','','https://mariadb.com/kb/en/in/'),
(227,'INTERVAL',19,'Syntax\n------\n\nINTERVAL(N,N1,N2,N3,...)\n\nDescription\n-----------\n\nReturns the index of the last argument that is less than the first argument or\nis NULL.\n\nReturns 0 if N < N1, 1 if N < N2, 2 if N < N3 and so on or -1 if N is NULL.\nAll arguments are treated as integers. It is required that N1 < N2 < N3 < ...\n< Nn for this function to work correctly. This is because a fast binary search\nis used.\n\nExamples\n--------\n\nSELECT INTERVAL(23, 1, 15, 17, 30, 44, 200);\n+--------------------------------------+\n| INTERVAL(23, 1, 15, 17, 30, 44, 200) |\n+--------------------------------------+\n|                                    3 |\n+--------------------------------------+\n\nSELECT INTERVAL(10, 1, 10, 100, 1000);\n+--------------------------------+\n| INTERVAL(10, 1, 10, 100, 1000) |\n+--------------------------------+\n|                              2 |\n+--------------------------------+\n\nSELECT INTERVAL(22, 23, 30, 44, 200);\n+-------------------------------+\n| INTERVAL(22, 23, 30, 44, 200) |\n+-------------------------------+\n|                             0 |\n+-------------------------------+\n\nSELECT INTERVAL(10, 2, NULL);\n+-----------------------+\n| INTERVAL(10, 2, NULL) |\n+-----------------------+\n|                     2 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/interval/','','https://mariadb.com/kb/en/interval/'),
(228,'IS',19,'Syntax\n------\n\nIS boolean_value\n\nDescription\n-----------\n\nTests a value against a boolean value, where boolean_value can be TRUE, FALSE,\nor UNKNOWN.\n\nThere is an important difference between using IS TRUE or comparing a value\nwith TRUE using =. When using =, only 1 equals to TRUE. But when using IS\nTRUE, all values which are logically true (like a number > 1) return TRUE.\n\nExamples\n--------\n\nSELECT 1 IS TRUE, 0 IS FALSE, NULL IS UNKNOWN;\n+-----------+------------+-----------------+\n| 1 IS TRUE | 0 IS FALSE | NULL IS UNKNOWN |\n+-----------+------------+-----------------+\n|         1 |          1 |               1 |\n+-----------+------------+-----------------+\n\nDifference between = and IS TRUE:\n\nSELECT 2 = TRUE, 2 IS TRUE;\n+----------+-----------+\n| 2 = TRUE | 2 IS TRUE |\n+----------+-----------+\n|        0 |         1 |\n+----------+-----------+\n\nURL: https://mariadb.com/kb/en/is/','','https://mariadb.com/kb/en/is/'),
(229,'IS NOT',19,'Syntax\n------\n\nIS NOT boolean_value\n\nDescription\n-----------\n\nTests a value against a boolean value, where boolean_value can be TRUE, FALSE,\nor UNKNOWN.\n\nExamples\n--------\n\nSELECT 1 IS NOT UNKNOWN, 0 IS NOT UNKNOWN, NULL IS NOT UNKNOWN;\n+------------------+------------------+---------------------+\n| 1 IS NOT UNKNOWN | 0 IS NOT UNKNOWN | NULL IS NOT UNKNOWN |\n+------------------+------------------+---------------------+\n|                1 |                1 |                   0 |\n+------------------+------------------+---------------------+\n\nSELECT NULL IS NOT TRUE, NULL IS NOT FALSE;\n+------------------+-------------------+\n| NULL IS NOT TRUE | NULL IS NOT FALSE |\n+------------------+-------------------+\n|                1 |                 1 |\n+------------------+-------------------+\n\nURL: https://mariadb.com/kb/en/is-not/','','https://mariadb.com/kb/en/is-not/'),
(543,'MONTHNAME',31,'Syntax\n------\n\nMONTHNAME(date)\n\nDescription\n-----------\n\nReturns the full name of the month for date. The language used for the name is\ncontrolled by the value of the lc_time_names system variable. See server\nlocale for more on the supported locales.\n\nExamples\n--------\n\nSELECT MONTHNAME(\'2019-02-03\');\n+-------------------------+\n| MONTHNAME(\'2019-02-03\') |\n+-------------------------+\n| February                |\n+-------------------------+\n\nChanging the locale:\n\nSET lc_time_names = \'fr_CA\';\n\nSELECT MONTHNAME(\'2019-05-21\');\n+-------------------------+\n| MONTHNAME(\'2019-05-21\') |\n+-------------------------+\n| mai                     |\n+-------------------------+\n\nURL: https://mariadb.com/kb/en/monthname/','','https://mariadb.com/kb/en/monthname/'),
(547,'QUARTER',31,'Syntax\n------\n\nQUARTER(date)\n\nDescription\n-----------\n\nReturns the quarter of the year for date, in the range 1 to 4. Returns 0 if\nmonth contains a zero value, or NULL if the given value is not otherwise a\nvalid date (zero values are accepted).\n\nExamples\n--------\n\nSELECT QUARTER(\'2008-04-01\');\n+-----------------------+\n| QUARTER(\'2008-04-01\') |\n+-----------------------+\n|                     2 |\n+-----------------------+\n\nSELECT QUARTER(\'2019-00-01\');\n+-----------------------+\n| QUARTER(\'2019-00-01\') |\n+-----------------------+\n|                     0 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/quarter/','','https://mariadb.com/kb/en/quarter/'),
(548,'SECOND',31,'Syntax\n------\n\nSECOND(time)\n\nDescription\n-----------\n\nReturns the second for a given time (which can include microseconds), in the\nrange 0 to 59, or NULL if not given a valid time value.\n\nExamples\n--------\n\nSELECT SECOND(\'10:05:03\');\n+--------------------+\n| SECOND(\'10:05:03\') |\n+--------------------+\n|                  3 |\n+--------------------+\n\nSELECT SECOND(\'10:05:01.999999\');\n+---------------------------+\n| SECOND(\'10:05:01.999999\') |\n+---------------------------+\n|                         1 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/second/','','https://mariadb.com/kb/en/second/'),
(550,'STR_TO_DATE',31,'Syntax\n------\n\nSTR_TO_DATE(str,format)\n\nDescription\n-----------\n\nThis is the inverse of the DATE_FORMAT() function. It takes a string str and a\nformat string format. STR_TO_DATE() returns a DATETIME value if the format\nstring contains both date and time parts, or a DATE or TIME value if the\nstring contains only date or time parts.\n\nThe date, time, or datetime values contained in str should be given in the\nformat indicated by format. If str contains an illegal date, time, or datetime\nvalue, STR_TO_DATE() returns NULL. An illegal value also produces a warning.\n\nUnder specific SQL_MODE settings an error may also be generated if the str\nisn\'t a valid date:\n\n* ALLOW_INVALID_DATES\n* NO_ZERO_DATE\n* NO_ZERO_IN_DATE\n\nThe options that can be used by STR_TO_DATE(), as well as its inverse\nDATE_FORMAT() and the FROM_UNIXTIME() function, are:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| %a                        | Short weekday name in current locale           |\n|                           | (Variable lc_time_names).                      |\n+---------------------------+------------------------------------------------+\n| %b                        | Short form month name in current locale. For   |\n|                           | locale en_US this is one of:                   |\n|                           | Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov    |\n|                           | or Dec.                                        |\n+---------------------------+------------------------------------------------+\n| %c                        | Month with 1 or 2 digits.                      |\n+---------------------------+------------------------------------------------+\n| %D                        | Day with English suffix \'th\', \'nd\', \'st\' or    |\n|                           | \'rd\'\'. (1st, 2nd, 3rd...).                     |\n+---------------------------+------------------------------------------------+\n| %d                        | Day with 2 digits.                             |\n+---------------------------+------------------------------------------------+\n| %e                        | Day with 1 or 2 digits.                        |\n+---------------------------+------------------------------------------------+\n| %f                        | Microseconds 6 digits.                         |\n+---------------------------+------------------------------------------------+\n| %H                        | Hour with 2 digits between 00-23.              |\n+---------------------------+------------------------------------------------+\n| %h                        | Hour with 2 digits between 01-12.              |\n+---------------------------+------------------------------------------------+\n| %I                        | Hour with 2 digits between 01-12.              |\n+---------------------------+------------------------------------------------+\n| %i                        | Minute with 2 digits.                          |\n+---------------------------+------------------------------------------------+\n| %j                        | Day of the year (001-366)                      |\n+---------------------------+------------------------------------------------+\n| %k                        | Hour with 1 digits between 0-23.               |\n+---------------------------+------------------------------------------------+\n| %l                        | Hour with 1 digits between 1-12.               |\n+---------------------------+------------------------------------------------+\n| %M                        | Full month name in current locale (Variable    |\n|                           | lc_time_names).                                |\n+---------------------------+------------------------------------------------+\n| %m                        | Month with 2 digits.                           |\n+---------------------------+------------------------------------------------+\n| %p                        | AM/PM according to current locale (Variable    |\n|                           | lc_time_names).                                |\n+---------------------------+------------------------------------------------+\n| %r                        | Time in 12 hour format, followed by AM/PM.     |\n|                           | Short for \'%I:%i:%S %p\'.                       |\n+---------------------------+------------------------------------------------+\n| %S                        | Seconds with 2 digits.                         |\n+---------------------------+------------------------------------------------+\n| %s                        | Seconds with 2 digits.                         |\n+---------------------------+------------------------------------------------+\n| %T                        | Time in 24 hour format. Short for \'%H:%i:%S\'.  |\n+---------------------------+------------------------------------------------+\n| %U                        | Week number (00-53), when first day of the     |\n|                           | week is Sunday.                                |\n+---------------------------+------------------------------------------------+\n| %u                        | Week number (00-53), when first day of the     |\n|                           | week is Monday.                                |\n+---------------------------+------------------------------------------------+\n| %V                        | Week number (01-53), when first day of the     |\n|                           | week is Sunday. Used with %X.                  |\n+---------------------------+------------------------------------------------+\n| %v                        | Week number (01-53), when first day of the     |\n|                           | week is Monday. Used with %x.                  |\n+---------------------------+------------------------------------------------+\n| %W                        | Full weekday name in current locale (Variable  |\n|                           | lc_time_names).                                |\n+---------------------------+------------------------------------------------+\n| %w                        | Day of the week. 0 = Sunday, 6 = Saturday.     |\n+---------------------------+------------------------------------------------+\n| %X                        | Year with 4 digits when first day of the week  |\n|                           | is Sunday. Used with %V.                       |\n+---------------------------+------------------------------------------------+\n| %x                        | Year with 4 digits when first day of the week  |\n|                           | is Monday. Used with %v.                       |\n+---------------------------+------------------------------------------------+\n| %Y                        | Year with 4 digits.                            |\n+---------------------------+------------------------------------------------+\n| %y                        | Year with 2 digits.                            |\n+---------------------------+------------------------------------------------+\n| %#                        | For str_to_date(), skip all numbers.           |\n+---------------------------+------------------------------------------------+\n| %.                        | For str_to_date(), skip all punctation         |\n|                           | characters.                                    |\n+---------------------------+------------------------------------------------+\n| %@                        | For str_to_date(), skip all alpha characters.  |\n+---------------------------+------------------------------------------------+\n| %%                        | A literal % character.                         |\n+---------------------------+------------------------------------------------+\n\nExamples\n--------\n\nSELECT STR_TO_DATE(\'Wednesday, June 2, 2014\', \'%W, %M %e, %Y\');\n+---------------------------------------------------------+\n| STR_TO_DATE(\'Wednesday, June 2, 2014\', \'%W, %M %e, %Y\') |\n+---------------------------------------------------------+\n| 2014-06-02                                              |\n+---------------------------------------------------------+\n\nSELECT STR_TO_DATE(\'Wednesday23423, June 2, 2014\', \'%W, %M %e, %Y\');\n+--------------------------------------------------------------+\n| STR_TO_DATE(\'Wednesday23423, June 2, 2014\', \'%W, %M %e, %Y\') |\n+--------------------------------------------------------------+\n| NULL                                                         |\n+--------------------------------------------------------------+\n1 row in set, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+---------+------+-------------------------------------------------------------\n---------------------+\n| Level   | Code | Message                                                    \n           |\n+---------+------+-------------------------------------------------------------\n---------------------+\n| Warning | 1411 | Incorrect datetime value: \'Wednesday23423, June 2, 2014\'\nfor function str_to_date |\n+---------+------+-------------------------------------------------------------\n---------------------+\n\nSELECT STR_TO_DATE(\'Wednesday23423, June 2, 2014\', \'%W%#, %M %e, %Y\');\n+----------------------------------------------------------------+\n| STR_TO_DATE(\'Wednesday23423, June 2, 2014\', \'%W%#, %M %e, %Y\') |\n+----------------------------------------------------------------+\n| 2014-06-02                                                     |\n+----------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/str_to_date/','','https://mariadb.com/kb/en/str_to_date/'),
(554,'TIME Function',31,'Syntax\n------\n\nTIME(expr)\n\nDescription\n-----------\n\nExtracts the time part of the time or datetime expression expr and returns it\nas a string.\n\nExamples\n--------\n\nSELECT TIME(\'2003-12-31 01:02:03\');\n+-----------------------------+\n| TIME(\'2003-12-31 01:02:03\') |\n+-----------------------------+\n| 01:02:03                    |\n+-----------------------------+\n\nSELECT TIME(\'2003-12-31 01:02:03.000123\');\n+------------------------------------+\n| TIME(\'2003-12-31 01:02:03.000123\') |\n+------------------------------------+\n| 01:02:03.000123                    |\n+------------------------------------+\n\nURL: https://mariadb.com/kb/en/time-function/','','https://mariadb.com/kb/en/time-function/'),
(231,'IS NULL',19,'Syntax\n------\n\nIS NULL\n\nDescription\n-----------\n\nTests whether a value is NULL. See also NULL Values in MariaDB.\n\nExamples\n--------\n\nSELECT 1 IS NULL, 0 IS NULL, NULL IS NULL;\n+-----------+-----------+--------------+\n| 1 IS NULL | 0 IS NULL | NULL IS NULL |\n+-----------+-----------+--------------+\n|         0 |         0 |            1 |\n+-----------+-----------+--------------+\n\nCompatibility\n-------------\n\nSome ODBC applications use the syntax auto_increment_field IS NOT NULL to find\nthe latest row that was inserted with an autogenerated key value. If your\napplications need this, you can set the sql_auto_is_null variable to 1.\n\nSET @@sql_auto_is_null=1;\nCREATE TABLE t1 (auto_increment_column INT NOT NULL AUTO_INCREMENT PRIMARY\nKEY);\nINSERT INTO t1 VALUES (NULL);\nSELECT * FROM t1 WHERE auto_increment_column IS NULL;\n\n+-----------------------+\n| auto_increment_column |\n+-----------------------+\n|                     1 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/is-null/','','https://mariadb.com/kb/en/is-null/'),
(233,'LEAST',19,'Syntax\n------\n\nLEAST(value1,value2,...)\n\nDescription\n-----------\n\nWith two or more arguments, returns the smallest (minimum-valued) argument.\nThe arguments are compared using the following rules:\n\n* If the return value is used in an INTEGER context or all arguments are\ninteger-valued, they are compared as integers.\n* If the return value is used in a REAL context or all arguments are\nreal-valued, they are compared as reals.\n* If any argument is a case-sensitive string, the arguments are compared as\ncase-sensitive strings.\n* In all other cases, the arguments are compared as case-insensitive strings.\n\nLEAST() returns NULL if any argument is NULL.\n\nExamples\n--------\n\nSELECT LEAST(2,0);\n+------------+\n| LEAST(2,0) |\n+------------+\n|          0 |\n+------------+\n\nSELECT LEAST(34.0,3.0,5.0,767.0);\n+---------------------------+\n| LEAST(34.0,3.0,5.0,767.0) |\n+---------------------------+\n|                       3.0 |\n+---------------------------+\n\nSELECT LEAST(\'B\',\'A\',\'C\');\n+--------------------+\n| LEAST(\'B\',\'A\',\'C\') |\n+--------------------+\n| A                  |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/least/','','https://mariadb.com/kb/en/least/'),
(234,'NOT BETWEEN',19,'Syntax\n------\n\nexpr NOT BETWEEN min AND max\n\nDescription\n-----------\n\nThis is the same as NOT (expr BETWEEN min AND max).\n\nNote that the meaning of the alternative form NOT expr BETWEEN min AND max is\naffected by the HIGH_NOT_PRECEDENCE SQL_MODE flag.\n\nExamples\n--------\n\nSELECT 1 NOT BETWEEN 2 AND 3;\n+-----------------------+\n| 1 NOT BETWEEN 2 AND 3 |\n+-----------------------+\n|                     1 |\n+-----------------------+\n\nSELECT \'b\' NOT BETWEEN \'a\' AND \'c\';\n+-----------------------------+\n| \'b\' NOT BETWEEN \'a\' AND \'c\' |\n+-----------------------------+\n|                           0 |\n+-----------------------------+\n\nNULL:\n\nSELECT 1 NOT BETWEEN 1 AND NULL;\n+--------------------------+\n| 1 NOT BETWEEN 1 AND NULL |\n+--------------------------+\n|                     NULL |\n+--------------------------+\n\nURL: https://mariadb.com/kb/en/not-between/','','https://mariadb.com/kb/en/not-between/'),
(235,'NOT IN',19,'Syntax\n------\n\nexpr NOT IN (value,...)\n\nDescription\n-----------\n\nThis is the same as NOT (expr IN (value,...)).\n\nExamples\n--------\n\nSELECT 2 NOT IN (0,3,5,7);\n+--------------------+\n| 2 NOT IN (0,3,5,7) |\n+--------------------+\n|                  1 |\n+--------------------+\n\nSELECT \'wefwf\' NOT IN (\'wee\',\'wefwf\',\'weg\');\n+--------------------------------------+\n| \'wefwf\' NOT IN (\'wee\',\'wefwf\',\'weg\') |\n+--------------------------------------+\n|                                    0 |\n+--------------------------------------+\n\nSELECT 1 NOT IN (\'1\', \'2\', \'3\');\n+--------------------------+\n| 1 NOT IN (\'1\', \'2\', \'3\') |\n+--------------------------+\n|                        0 |\n+--------------------------+\n\nNULL:\n\nSELECT NULL NOT IN (1, 2, 3);\n+-----------------------+\n| NULL NOT IN (1, 2, 3) |\n+-----------------------+\n|                  NULL |\n+-----------------------+\n\nSELECT 1 NOT IN (1, 2, NULL);\n+-----------------------+\n| 1 NOT IN (1, 2, NULL) |\n+-----------------------+\n|                     0 |\n+-----------------------+\n\nSELECT 5 NOT IN (1, 2, NULL);\n+-----------------------+\n| 5 NOT IN (1, 2, NULL) |\n+-----------------------+\n|                  NULL |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/not-in/','','https://mariadb.com/kb/en/not-in/'),
(243,'Parentheses',20,'Parentheses are sometimes called precedence operators - this means that they\ncan be used to change the other operator\'s precedence in an expression. The\nexpressions that are written between parentheses are computed before the\nexpressions that are written outside. Parentheses must always contain an\nexpression (that is, they cannot be empty), and can be nested.\n\nFor example, the following expressions could return different results:\n\n* NOT a OR b\n* NOT (a OR b)\n\nIn the first case, NOT applies to a, so if a is FALSE or b is TRUE, the\nexpression returns TRUE. In the second case, NOT applies to the result of a OR\nb, so if at least one of a or b is TRUE, the expression is TRUE.\n\nWhen the precedence of operators is not intuitive, you can use parentheses to\nmake it immediately clear for whoever reads the statement.\n\nThe precedence of the NOT operator can also be affected by the\nHIGH_NOT_PRECEDENCE SQL_MODE flag.\n\nOther uses\n----------\n\nParentheses must always be used to enclose subqueries.\n\nParentheses can also be used in a JOIN statement between multiple tables to\ndetermine which tables must be joined first.\n\nAlso, parentheses are used to enclose the list of parameters to be passed to\nbuilt-in functions, user-defined functions and stored routines. However, when\nno parameter is passed to a stored procedure, parentheses are optional. For\nbuiltin functions and user-defined functions, spaces are not allowed between\nthe function name and the open parenthesis, unless the IGNORE_SPACE SQL_MODE\nis set. For stored routines (and for functions if IGNORE_SPACE is set) spaces\nare allowed before the open parenthesis, including tab characters and new line\ncharacters.\n\nSyntax errors\n-------------\n\nIf there are more open parentheses than closed parentheses, the error usually\nlooks like this:\n\nERROR 1064 (42000): You have an error in your SQL syntax; check the manual that\ncorresponds to your MariaDB server version for the right syntax to use near \'\'\na\nt line 1\n\nNote the empty string.\n\nIf there are more closed parentheses than open parentheses, the error usually\nlooks like this:\n\nERROR 1064 (42000): You have an error in your SQL syntax; check the manual that\ncorresponds to your MariaDB server version for the right syntax to use near \')\'\nat line 1\n\nNote the quoted closed parenthesis.\n\nURL: https://mariadb.com/kb/en/parentheses/','','https://mariadb.com/kb/en/parentheses/'),
(559,'TIME_FORMAT',31,'Syntax\n------\n\nTIME_FORMAT(time,format)\n\nDescription\n-----------\n\nThis is used like the DATE_FORMAT() function, but the format string may\ncontain format specifiers only for hours, minutes, and seconds. Other\nspecifiers produce a NULL value or 0.\n\nExamples\n--------\n\nSELECT TIME_FORMAT(\'100:00:00\', \'%H %k %h %I %l\');\n+--------------------------------------------+\n| TIME_FORMAT(\'100:00:00\', \'%H %k %h %I %l\') |\n+--------------------------------------------+\n| 100 100 04 04 4                            |\n+--------------------------------------------+\n\nURL: https://mariadb.com/kb/en/time_format/','','https://mariadb.com/kb/en/time_format/'),
(245,'ANALYZE TABLE',21,'Syntax\n------\n\nANALYZE [NO_WRITE_TO_BINLOG | LOCAL] TABLE tbl_name [,tbl_name ...]\n [PERSISTENT FOR\n  { ALL\n   | COLUMNS ([col_name [,col_name ...]]) INDEXES ([index_name [,index_name\n...]])\n  }\n ]\n\nDescription\n-----------\n\nANALYZE TABLE analyzes and stores the key distribution for a table (index\nstatistics). This statement works with MyISAM, Aria and InnoDB tables. During\nthe analysis, InnoDB will allow reads/writes, and MyISAM/Aria reads/inserts.\nFor MyISAM tables, this statement is equivalent to using myisamchk --analyze.\n\nFor more information on how the analysis works within InnoDB, see InnoDB\nLimitations.\n\nMariaDB uses the stored key distribution to decide the order in which tables\nshould be joined when you perform a join on something other than a constant.\nIn addition, key distributions can be used when deciding which indexes to use\nfor a specific table within a query.\n\nThis statement requires SELECT and INSERT privileges for the table.\n\nBy default, ANALYZE TABLE statements are written to the binary log and will be\nreplicated. The NO_WRITE_TO_BINLOG keyword (LOCAL is an alias) will ensure the\nstatement is not written to the binary log.\n\nFrom MariaDB 10.3.19, ANALYZE TABLE statements are not logged to the binary\nlog if read_only is set. See also Read-Only Replicas.\n\nANALYZE TABLE is also supported for partitioned tables. You can use ALTER\nTABLE ... ANALYZE PARTITION to analyze one or more partitions.\n\nThe Aria storage engine supports progress reporting for the ANALYZE TABLE\nstatement.\n\nEngine-Independent Statistics\n-----------------------------\n\nANALYZE TABLE supports engine-independent statistics. See Engine-Independent\nTable Statistics: Collecting Statistics with the ANALYZE TABLE Statement for\nmore information.\n\nUseful Variables\n----------------\n\nFor calculating the number of duplicates, ANALYZE TABLE uses a buffer of\nsort_buffer_size bytes per column. You can slightly increase the speed of\nANALYZE TABLE by increasing this variable.\n\nExamples\n--------\n\n-- update all engine-independent statistics for all columns and indexes\nANALYZE TABLE tbl PERSISTENT FOR ALL;\n\n-- update specific columns and indexes:\nANALYZE TABLE tbl PERSISTENT FOR COLUMNS (col1,col2,...) INDEXES\n(idx1,idx2,...);\n\n-- empty lists are allowed:\nANALYZE TABLE tbl PERSISTENT FOR COLUMNS (col1,col2,...) INDEXES ();\nANALYZE TABLE tbl PERSISTENT FOR COLUMNS () INDEXES (idx1,idx2,...);\n\n-- the following will only update mysql.table_stats fields:\nANALYZE TABLE tbl PERSISTENT FOR COLUMNS () INDEXES ();\n\n-- when use_stat_tables is set to \'COMPLEMENTARY\' or \'PREFERABLY\', \n-- a simple ANALYZE TABLE  collects engine-independent statistics for all\ncolumns and indexes.\nSET SESSION use_stat_tables=\'COMPLEMENTARY\';\nANALYZE TABLE tbl;\n\nURL: https://mariadb.com/kb/en/analyze-table/','','https://mariadb.com/kb/en/analyze-table/'),
(248,'CHECKSUM TABLE',21,'Syntax\n------\n\nCHECKSUM TABLE tbl_name [, tbl_name] ... [ QUICK | EXTENDED ]\n\nDescription\n-----------\n\nCHECKSUM TABLE reports a table checksum. This is very useful if you want to\nknow if two tables are the same (for example on a master and slave).\n\nWith QUICK, the live table checksum is reported if it is available, or NULL\notherwise. This is very fast. A live checksum is enabled by specifying the\nCHECKSUM=1 table option when you create the table; currently, this is\nsupported only for Aria and MyISAM tables.\n\nWith EXTENDED, the entire table is read row by row and the checksum is\ncalculated. This can be very slow for large tables.\n\nIf neither QUICK nor EXTENDED is specified, MariaDB returns a live checksum if\nthe table storage engine supports it and scans the table otherwise.\n\nCHECKSUM TABLE requires the SELECT privilege for the table.\n\nFor a nonexistent table, CHECKSUM TABLE returns NULL and generates a warning.\n\nThe table row format affects the checksum value. If the row format changes,\nthe checksum will change. This means that when a table created with a\nMariaDB/MySQL version is upgraded to another version, the checksum value will\nprobably change.\n\nTwo identical tables should always match to the same checksum value; however,\nalso for non-identical tables there is a very slight chance that they will\nreturn the same value as the hashing algorithm is not completely\ncollision-free.\n\nIdentical Tables\n----------------\n\nIdentical tables mean that the CREATE statement is identical and that the\nfollowing variable, which affects the storage formats, was the same when the\ntables were created:\n\n* mysql56-temporal-format\n\nDifferences Between MariaDB and MySQL\n-------------------------------------\n\nCHECKSUM TABLE may give a different result as MariaDB doesn\'t ignore NULLs in\nthe columns as MySQL 5.1 does (Later MySQL versions should calculate checksums\nthe same way as MariaDB). You can get the \'old style\' checksum in MariaDB by\nstarting mysqld with the --old option. Note however that that the MyISAM and\nAria storage engines in MariaDB are using the new checksum internally, so if\nyou are using --old, the CHECKSUM command will be slower as it needs to\ncalculate the checksum row by row. Starting from MariaDB Server 10.9, --old is\ndeprecated and will be removed in a future release. Set --old-mode or OLD_MODE\nto COMPAT_5_1_CHECKSUM to get \'old style\' checksum.\n\nURL: https://mariadb.com/kb/en/checksum-table/','','https://mariadb.com/kb/en/checksum-table/'),
(564,'UTC_DATE',31,'Syntax\n------\n\nUTC_DATE, UTC_DATE()\n\nDescription\n-----------\n\nReturns the current UTC date as a value in \'YYYY-MM-DD\' or YYYYMMDD format,\ndepending on whether the function is used in a string or numeric context.\n\nExamples\n--------\n\nSELECT UTC_DATE(), UTC_DATE() + 0;\n+------------+----------------+\n| UTC_DATE() | UTC_DATE() + 0 |\n+------------+----------------+\n| 2010-03-27 |       20100327 |\n+------------+----------------+\n\nURL: https://mariadb.com/kb/en/utc_date/','','https://mariadb.com/kb/en/utc_date/'),
(565,'UTC_TIME',31,'Syntax\n------\n\nUTC_TIME\nUTC_TIME([precision])\n\nDescription\n-----------\n\nReturns the current UTC time as a value in \'HH:MM:SS\' or HHMMSS.uuuuuu format,\ndepending on whether the function is used in a string or numeric context.\n\nThe optional precision determines the microsecond precision. See Microseconds\nin MariaDB.\n\nExamples\n--------\n\nSELECT UTC_TIME(), UTC_TIME() + 0;\n+------------+----------------+\n| UTC_TIME() | UTC_TIME() + 0 |\n+------------+----------------+\n| 17:32:34   |  173234.000000 |\n+------------+----------------+\n\nWith precision:\n\nSELECT UTC_TIME(5);\n+----------------+\n| UTC_TIME(5)    |\n+----------------+\n| 07:52:50.78369 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/utc_time/','','https://mariadb.com/kb/en/utc_time/'),
(573,'AsBinary',32,'A synonym for ST_AsBinary().\n\nURL: https://mariadb.com/kb/en/wkb-asbinary/','','https://mariadb.com/kb/en/wkb-asbinary/'),
(574,'AsWKB',32,'A synonym for ST_AsBinary().\n\nURL: https://mariadb.com/kb/en/aswkb/','','https://mariadb.com/kb/en/aswkb/'),
(575,'MLineFromWKB',32,'Syntax\n------\n\nMLineFromWKB(wkb[,srid])\nMultiLineStringFromWKB(wkb[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKB representation and SRID.\n\nMLineFromWKB() and MultiLineStringFromWKB() are synonyms.\n\nExamples\n--------\n\nSET @g = ST_AsBinary(MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16\n0,16 23,16 48))\'));\n\nSELECT ST_AsText(MLineFromWKB(@g));\n+--------------------------------------------------------+\n| ST_AsText(MLineFromWKB(@g))                            |\n+--------------------------------------------------------+\n| MULTILINESTRING((10 48,10 21,10 0),(16 0,16 23,16 48)) |\n+--------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/mlinefromwkb/','','https://mariadb.com/kb/en/mlinefromwkb/'),
(246,'CHECK TABLE',21,'Syntax\n------\n\nCHECK TABLE tbl_name [, tbl_name] ... [option] ...\n\noption = {FOR UPGRADE | QUICK | FAST | MEDIUM | EXTENDED | CHANGED}\n\nDescription\n-----------\n\nCHECK TABLE checks a table or tables for errors. CHECK TABLE works for\nArchive, Aria, CSV, InnoDB and MyISAM tables. For Aria and MyISAM tables, the\nkey statistics are updated as well. For CSV, see also Checking and Repairing\nCSV Tables.\n\nAs an alternative, myisamchk is a commandline tool for checking MyISAM tables\nwhen the tables are not being accessed. For Aria tables, there is a similar\ntool: aria_chk.\n\nFor checking dynamic columns integrity, COLUMN_CHECK() can be used.\n\nCHECK TABLE can also check views for problems, such as tables that are\nreferenced in the view definition that no longer exist.\n\nCHECK TABLE is also supported for partitioned tables. You can use ALTER TABLE\n... CHECK PARTITION to check one or more partitions.\n\nThe meaning of the different options are as follows - note that this can vary\na bit between storage engines:\n\n+-----+----------------------------------------------------------------------+\n| FOR | Do a very quick check if the storage format for the table has        |\n| UPG | changed so that one needs to do a REPAIR. This is only needed when   |\n| ADE | one upgrades between major versions of MariaDB or MySQL. This is     |\n|     | usually done by running mariadb-upgrade.                             |\n+-----+----------------------------------------------------------------------+\n| FAS | Only check tables that has not been closed properly or are marked    |\n|     | as corrupt. Only supported by the MyISAM and Aria engines. For       |\n|     | other engines the table is checked normally                          |\n+-----+----------------------------------------------------------------------+\n| CHA | Check only tables that has changed since last REPAIR / CHECK. Only   |\n| GED | supported by the MyISAM and Aria engines. For other engines the      |\n|     | table is checked normally.                                           |\n+-----+----------------------------------------------------------------------+\n| QUI | Do a fast check. For MyISAM and Aria, this means skipping the check  |\n| K   | of the delete link chain, which may take some time.                  |\n+-----+----------------------------------------------------------------------+\n| MED | Scan also the data files. Checks integrity between data and index    |\n| UM  | files with checksums. In most cases this should find all possible    |\n|     | errors.                                                              |\n+-----+----------------------------------------------------------------------+\n| EXT | Does a full check to verify every possible error. For InnoDB, Aria,  |\n| NDE | and MyISAM, verify for each row that all its keys exists, and for    |\n|     | those index keys, they point back to the primary clustered key.      |\n|     | This may take a long time on large tables. This option was           |\n|     | previously ignored by InnoDB before MariaDB 10.6.11, MariaDB         |\n|     | 10.7.7, MariaDB 10.8.6 and MariaDB 10.9.4.                           |\n+-----+----------------------------------------------------------------------+\n\nFor most cases running CHECK TABLE without options or MEDIUM should be good\nenough.\n\nThe Aria storage engine supports progress reporting for this statement.\n\nIf you want to know if two tables are identical, take a look at CHECKSUM TABLE.\n\nInnoDB\n------\n\nIf CHECK TABLE finds an error in an InnoDB table, MariaDB might shutdown to\nprevent the error propagation. In this case, the problem will be reported in\nthe error log. Otherwise the table or an index might be marked as corrupted,\nto prevent use. This does not happen with some minor problems, like a wrong\nnumber of entries in a secondary index. Those problems are reported in the\noutput of CHECK TABLE.\n\nEach tablespace contains a header with metadata. This header is not checked by\nthis statement.\n\nDuring the execution of CHECK TABLE, other threads may be blocked.\n\nURL: https://mariadb.com/kb/en/check-table/','','https://mariadb.com/kb/en/check-table/'),
(250,'REPAIR TABLE',21,'Syntax\n------\n\nREPAIR [NO_WRITE_TO_BINLOG | LOCAL] TABLE\n  tbl_name [, tbl_name] ...\n  [QUICK] [EXTENDED] [USE_FRM]\n\nDescription\n-----------\n\nREPAIR TABLE repairs a possibly corrupted table. By default, it has the same\neffect as\n\nmyisamchk --recover tbl_name\n\nor\n\naria_chk --recover tbl_name\n\nSee aria_chk and myisamchk for more.\n\nREPAIR TABLE works for Archive, Aria, CSV and MyISAM tables. For InnoDB, see\nrecovery modes. For CSV, see also Checking and Repairing CSV Tables. For\nArchive, this statement also improves compression. If the storage engine does\nnot support this statement, a warning is issued.\n\nThis statement requires SELECT and INSERT privileges for the table.\n\nBy default, REPAIR TABLE statements are written to the binary log and will be\nreplicated. The NO_WRITE_TO_BINLOG keyword (LOCAL is an alias) will ensure the\nstatement is not written to the binary log.\n\nFrom MariaDB 10.3.19, REPAIR TABLE statements are not logged to the binary log\nif read_only is set. See also Read-Only Replicas.\n\nWhen an index is recreated, the storage engine may use a configurable buffer\nin the process. Incrementing the buffer speeds up the index creation. Aria and\nMyISAM allocate a buffer whose size is defined by aria_sort_buffer_size or\nmyisam_sort_buffer_size, also used for ALTER TABLE.\n\nREPAIR TABLE is also supported for partitioned tables. However, the USE_FRM\noption cannot be used with this statement on a partitioned table.\n\nALTER TABLE ... REPAIR PARTITION can be used to repair one or more partitions.\n\nThe Aria storage engine supports progress reporting for this statement.\n\nURL: https://mariadb.com/kb/en/repair-table/','','https://mariadb.com/kb/en/repair-table/'),
(576,'MPointFromWKB',32,'Syntax\n------\n\nMPointFromWKB(wkb[,srid])\nMultiPointFromWKB(wkb[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKB representation and SRID.\n\nMPointFromWKB() and MultiPointFromWKB() are synonyms.\n\nExamples\n--------\n\nSET @g = ST_AsBinary(MPointFromText(\'MultiPoint( 1 1, 2 2, 5 3, 7 2, 9 3, 8 4,\n6 6, 6 9, 4 9, 1 5 )\'));\n\nSELECT ST_AsText(MPointFromWKB(@g));\n+-----------------------------------------------------+\n| ST_AsText(MPointFromWKB(@g))                        |\n+-----------------------------------------------------+\n| MULTIPOINT(1 1,2 2,5 3,7 2,9 3,8 4,6 6,6 9,4 9,1 5) |\n+-----------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/mpointfromwkb/','','https://mariadb.com/kb/en/mpointfromwkb/'),
(577,'MPolyFromWKB',32,'Syntax\n------\n\nMPolyFromWKB(wkb[,srid])\nMultiPolygonFromWKB(wkb[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKB representation and SRID.\n\nMPolyFromWKB() and MultiPolygonFromWKB() are synonyms.\n\nExamples\n--------\n\nSET @g = ST_AsBinary(MPointFromText(\'MULTIPOLYGON(((28 26,28 0,84 0,84 42,28\n26),(52 18,66 23,73 9,48 6,52 18)),((59 18,67 18,67 13,59 13,59 18)))\'));\n\nSELECT ST_AsText(MPolyFromWKB(@g))\\G\n*************************** 1. row ***************************\nST_AsText(MPolyFromWKB(@g)): MULTIPOLYGON(((28 26,28 0,84 0,84 42,28 26),(52\n18,66 23,73 9,48 6,52 18)),((59 18,67 18,67 13,59 13,59 18)))\n\nURL: https://mariadb.com/kb/en/mpolyfromwkb/','','https://mariadb.com/kb/en/mpolyfromwkb/'),
(249,'OPTIMIZE TABLE',21,'Syntax\n------\n\nOPTIMIZE [NO_WRITE_TO_BINLOG | LOCAL] TABLE\n  tbl_name [, tbl_name] ...\n  [WAIT n | NOWAIT]\n\nDescription\n-----------\n\nOPTIMIZE TABLE has two main functions. It can either be used to defragment\ntables, or to update the InnoDB fulltext index.\n\nWAIT/NOWAIT\n-----------\n\nSet the lock wait timeout. See WAIT and NOWAIT.\n\nDefragmenting\n-------------\n\nOPTIMIZE TABLE works for InnoDB (before MariaDB 10.1.1, only if the\ninnodb_file_per_table server system variable is set), Aria, MyISAM and ARCHIVE\ntables, and should be used if you have deleted a large part of a table or if\nyou have made many changes to a table with variable-length rows (tables that\nhave VARCHAR, VARBINARY, BLOB, or TEXT columns). Deleted rows are maintained\nin a linked list and subsequent INSERT operations reuse old row positions.\n\nThis statement requires SELECT and INSERT privileges for the table.\n\nBy default, OPTIMIZE TABLE statements are written to the binary log and will\nbe replicated. The NO_WRITE_TO_BINLOG keyword (LOCAL is an alias) will ensure\nthe statement is not written to the binary log.\n\nOPTIMIZE TABLE statements are not logged to the binary log if read_only is\nset. See also Read-Only Replicas.\n\nOPTIMIZE TABLE is also supported for partitioned tables. You can use ALTER\nTABLE ... OPTIMIZE PARTITION to optimize one or more partitions.\n\nYou can use OPTIMIZE TABLE to reclaim the unused space and to defragment the\ndata file. With other storage engines, OPTIMIZE TABLE does nothing by default,\nand returns this message: \" The storage engine for the table doesn\'t support\noptimize\". However, if the server has been started with the --skip-new option,\nOPTIMIZE TABLE is linked to ALTER TABLE, and recreates the table. This\noperation frees the unused space and updates index statistics.\n\nThe Aria storage engine supports progress reporting for this statement.\n\nIf a MyISAM table is fragmented, concurrent inserts will not be performed\nuntil an OPTIMIZE TABLE statement is executed on that table, unless the\nconcurrent_insert server system variable is set to ALWAYS.\n\nUpdating an InnoDB fulltext index\n---------------------------------\n\nWhen rows are added or deleted to an InnoDB fulltext index, the index is not\nimmediately re-organized, as this can be an expensive operation. Change\nstatistics are stored in a separate location . The fulltext index is only\nfully re-organized when an OPTIMIZE TABLE statement is run.\n\nBy default, an OPTIMIZE TABLE will defragment a table. In order to use it to\nupdate fulltext index statistics, the innodb_optimize_fulltext_only system\nvariable must be set to 1. This is intended to be a temporary setting, and\nshould be reset to 0 once the fulltext index has been re-organized.\n\nSince fulltext re-organization can take a long time, the\ninnodb_ft_num_word_optimize variable limits the re-organization to a number of\nwords (2000 by default). You can run multiple OPTIMIZE statements to fully\nre-organize the index.\n\nDefragmenting InnoDB tablespaces\n--------------------------------\n\nMariaDB 10.1.1 merged the Facebook/Kakao defragmentation patch, allowing one\nto use OPTIMIZE TABLE to defragment InnoDB tablespaces. For this functionality\nto be enabled, the innodb_defragment system variable must be enabled. No new\ntables are created and there is no need to copy data from old tables to new\ntables. Instead, this feature loads n pages (determined by\ninnodb-defragment-n-pages) and tries to move records so that pages would be\nfull of records and then frees pages that are fully empty after the operation.\nNote that tablespace files (including ibdata1) will not shrink as the result\nof defragmentation, but one will get better memory utilization in the InnoDB\nbuffer pool as there are fewer data pages in use.\n\nSee Defragmenting InnoDB Tablespaces for more details.\n\nURL: https://mariadb.com/kb/en/optimize-table/','','https://mariadb.com/kb/en/optimize-table/'),
(251,'REPAIR VIEW',21,'Syntax\n------\n\nREPAIR [NO_WRITE_TO_BINLOG | LOCAL] VIEW  view_name[, view_name] ... [FROM\nMYSQL]\n\nDescription\n-----------\n\nThe REPAIR VIEW statement was introduced to assist with fixing MDEV-6916, an\nissue introduced in MariaDB 5.2 where the view algorithms were swapped\ncompared to their MySQL on disk representation. It checks whether the view\nalgorithm is correct. It is run as part of mariadb-upgrade, and should not\nnormally be required in regular use.\n\nBy default it corrects the checksum and if necessary adds the mariadb-version\nfield. If the optional FROM MYSQL clause is used, and no mariadb-version field\nis present, the MERGE and TEMPTABLE algorithms are toggled.\n\nBy default, REPAIR VIEW statements are written to the binary log and will be\nreplicated. The NO_WRITE_TO_BINLOG keyword (LOCAL is an alias) will ensure the\nstatement is not written to the binary log.\n\nURL: https://mariadb.com/kb/en/repair-view/','','https://mariadb.com/kb/en/repair-view/'),
(578,'GeomCollFromWKB',32,'A synonym for ST_GeomCollFromWKB.\n\nURL: https://mariadb.com/kb/en/wkb-geomcollfromwkb/','','https://mariadb.com/kb/en/wkb-geomcollfromwkb/'),
(579,'GeometryCollectionFromWKB',32,'A synonym for ST_GeomCollFromWKB.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromwkb/','','https://mariadb.com/kb/en/geometrycollectionfromwkb/'),
(580,'GeometryFromWKB',32,'A synonym for ST_GeomFromWKB.\n\nURL: https://mariadb.com/kb/en/geometryfromwkb/','','https://mariadb.com/kb/en/geometryfromwkb/'),
(581,'GeomFromWKB',32,'A synonym for ST_GeomFromWKB.\n\nURL: https://mariadb.com/kb/en/wkb-geomfromwkb/','','https://mariadb.com/kb/en/wkb-geomfromwkb/'),
(582,'LineFromWKB',32,'A synonym for ST_LineFromWKB.\n\nURL: https://mariadb.com/kb/en/wkb-linefromwkb/','','https://mariadb.com/kb/en/wkb-linefromwkb/'),
(583,'LineStringFromWKB',32,'A synonym for ST_LineFromWKB.\n\nURL: https://mariadb.com/kb/en/linestringfromwkb/','','https://mariadb.com/kb/en/linestringfromwkb/'),
(584,'MultiLineStringFromWKB',32,'A synonym for MLineFromWKB().\n\nURL: https://mariadb.com/kb/en/multilinestringfromwkb/','','https://mariadb.com/kb/en/multilinestringfromwkb/'),
(585,'MultiPointFromWKB',32,'A synonym for MPointFromWKB.\n\nURL: https://mariadb.com/kb/en/multipointfromwkb/','','https://mariadb.com/kb/en/multipointfromwkb/'),
(586,'MultiPolygonFromWKB',32,'Synonym for MPolyFromWKB.\n\nURL: https://mariadb.com/kb/en/multipolygonfromwkb/','','https://mariadb.com/kb/en/multipolygonfromwkb/'),
(587,'PointFromWKB',32,'A synonym for ST_PointFromWKB.\n\nURL: https://mariadb.com/kb/en/wkb-pointfromwkb/','','https://mariadb.com/kb/en/wkb-pointfromwkb/'),
(588,'PolyFromWKB',32,'A synonym for ST_PolyFromWKB.\n\nURL: https://mariadb.com/kb/en/wkb-polyfromwkb/','','https://mariadb.com/kb/en/wkb-polyfromwkb/'),
(589,'PolygonFromWKB',32,'A synonym for ST_PolyFromWKB.\n\nURL: https://mariadb.com/kb/en/polygonfromwkb/','','https://mariadb.com/kb/en/polygonfromwkb/'),
(590,'ST_AsBinary',32,'Syntax\n------\n\nST_AsBinary(g)\nAsBinary(g)\nST_AsWKB(g)\nAsWKB(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKB representation and\nreturns the binary result.\n\nST_AsBinary(), AsBinary(), ST_AsWKB() and AsWKB() are synonyms,\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,0 1,1 1,1 0,0 0))\');\nSELECT ST_AsBinary(@poly);\n\nSELECT ST_AsText(ST_GeomFromWKB(ST_AsWKB(@poly)));\n+--------------------------------------------+\n| ST_AsText(ST_GeomFromWKB(ST_AsWKB(@poly))) |\n+--------------------------------------------+\n| POLYGON((0 0,0 1,1 1,1 0,0 0))             |\n+--------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_asbinary/','','https://mariadb.com/kb/en/st_asbinary/'),
(252,'mysql.func Table',22,'The mysql.func table stores information about user-defined functions (UDFs)\ncreated with the CREATE FUNCTION UDF statement.\n\nMariaDB starting with 10.4\n--------------------------\nIn MariaDB 10.4 and later, this table uses the Aria storage engine.\n\nMariaDB until 10.3\n------------------\nIn MariaDB 10.3 and before, this table uses the MyISAM storage engine.\n\nThe mysql.func table contains the following fields:\n\n+----------+---------+---------+-------+--------------+---------------------+\n| Field    | Type    | Null    | Key   | Default      | Description         |\n+----------+---------+---------+-------+--------------+---------------------+\n| name     | char(64 | NO      | PRI   |              | UDF name            |\n|          |         |         |       |              |                     |\n+----------+---------+---------+-------+--------------+---------------------+\n| ret      | tinyint | NO      |       | 0            |                     |\n|          | 1)      |         |       |              |                     |\n+----------+---------+---------+-------+--------------+---------------------+\n| dl       | char(12 | NO      |       |              | Shared library name |\n|          | )       |         |       |              |                     |\n+----------+---------+---------+-------+--------------+---------------------+\n| type     | enum(\'f | NO      |       | NULL         | Type, either        |\n|          | nction\' |         |       |              | function or         |\n|          | \'aggreg |         |       |              | aggregate.          |\n|          | te\')    |         |       |              | Aggregate           |\n|          |         |         |       |              | functions are       |\n|          |         |         |       |              | summary functions   |\n|          |         |         |       |              | such as SUM() and   |\n|          |         |         |       |              | AVG().              |\n+----------+---------+---------+-------+--------------+---------------------+\n\nExample\n-------\n\nSELECT * FROM mysql.func;\n+------------------------------+-----+--------------+-----------+\n| name                         | ret | dl           | type      |\n+------------------------------+-----+--------------+-----------+\n| spider_direct_sql            |   2 | ha_spider.so | function  |\n| spider_bg_direct_sql         |   2 | ha_spider.so | aggregate |\n| spider_ping_table            |   2 | ha_spider.so | function  |\n| spider_copy_tables           |   2 | ha_spider.so | function  |\n| spider_flush_table_mon_cache |   2 | ha_spider.so | function  |\n+------------------------------+-----+--------------+-----------+\n\nURL: https://mariadb.com/kb/en/mysqlfunc-table/','','https://mariadb.com/kb/en/mysqlfunc-table/'),
(254,'DROP FUNCTION UDF',22,'Syntax\n------\n\nDROP FUNCTION [IF EXISTS] function_name\n\nDescription\n-----------\n\nThis statement drops the user-defined function (UDF) named function_name.\n\nTo drop a function, you must have the DELETE privilege for the mysql database.\nThis is because DROP FUNCTION removes the row from the mysql.func system table\nthat records the function\'s name, type and shared library name.\n\nFor dropping a stored function, see DROP FUNCTION.\n\nUpgrading a UDF\n---------------\n\nTo upgrade the UDF\'s shared library, first run a DROP FUNCTION statement, then\nupgrade the shared library and finally run the CREATE FUNCTION statement. If\nyou upgrade without following this process, you may crash the server.\n\nExamples\n--------\n\nDROP FUNCTION jsoncontains_path;\n\nIF EXISTS:\n\nDROP FUNCTION jsoncontains_path;\nERROR 1305 (42000): FUNCTION test.jsoncontains_path does not exist\n\nDROP FUNCTION IF EXISTS jsoncontains_path;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------------------+\n| Level | Code | Message                                        |\n+-------+------+------------------------------------------------+\n| Note  | 1305 | FUNCTION test.jsoncontains_path does not exist |\n+-------+------+------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/drop-function-udf/','','https://mariadb.com/kb/en/drop-function-udf/'),
(257,'User-Defined Functions Security',22,'The MariaDB server imposes a number of limitations on user-defined functions\nfor security purposes.\n\n* The INSERT privilege for the mysql database is required to run CREATE\nFUNCTION, as a record will be added to the mysql.func-table.\n* The DELETE privilege for the mysql database is required to run DROP FUNCTION\nas the corresponding record will be removed from the mysql.func-table.\n* UDF object files can only be placed in the plugin directory, as specified by\nthe value of the plugin_dir system variable.\n* At least one symbol, beyond the required x() - corresponding to an SQL\nfunction X()) - is required. These can be x_init(), x_deinit(), xxx_reset(),\nx_clear() and x_add() functions (see Creating User-defined Functions). The\nallow-suspicious-udfs mysqld option (by default unset) provides a workaround,\npermitting only one symbol to be used. This is not recommended, as it opens\nthe possibility of loading shared objects that are not legitimate user-defined\nfunctions.\n\nURL: https://mariadb.com/kb/en/user-defined-functions-security/','','https://mariadb.com/kb/en/user-defined-functions-security/'),
(591,'ST_AsWKB',32,'A synonym for ST_AsBinary().\n\nURL: https://mariadb.com/kb/en/st_aswkb/','','https://mariadb.com/kb/en/st_aswkb/'),
(593,'ST_GeometryCollectionFromWKB',32,'A synonym for ST_GeomCollFromWKB.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromwkb/','','https://mariadb.com/kb/en/st_geometrycollectionfromwkb/'),
(594,'ST_GeometryFromWKB',32,'A synonym for ST_GeomFromWKB.\n\nURL: https://mariadb.com/kb/en/st_geometryfromwkb/','','https://mariadb.com/kb/en/st_geometryfromwkb/'),
(595,'ST_GeomFromWKB',32,'Syntax\n------\n\nST_GeomFromWKB(wkb[,srid])\nST_GeometryFromWKB(wkb[,srid])\nGeomFromWKB(wkb[,srid])\nGeometryFromWKB(wkb[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKB representation and SRID.\n\nST_GeomFromWKB(), ST_GeometryFromWKB(), GeomFromWKB() and GeometryFromWKB()\nare synonyms.\n\nExamples\n--------\n\nSET @g = ST_AsBinary(ST_LineFromText(\'LINESTRING(0 4, 4 6)\'));\n\nSELECT ST_AsText(ST_GeomFromWKB(@g));\n+-------------------------------+\n| ST_AsText(ST_GeomFromWKB(@g)) |\n+-------------------------------+\n| LINESTRING(0 4,4 6)           |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/st_geomfromwkb/','','https://mariadb.com/kb/en/st_geomfromwkb/'),
(596,'ST_LineFromWKB',32,'Syntax\n------\n\nST_LineFromWKB(wkb[,srid])\nLineFromWKB(wkb[,srid])\nST_LineStringFromWKB(wkb[,srid])\nLineStringFromWKB(wkb[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKB representation and SRID.\n\nST_LineFromWKB(), LineFromWKB(), ST_LineStringFromWKB(), and\nLineStringFromWKB() are synonyms.\n\nExamples\n--------\n\nSET @g = ST_AsBinary(ST_LineFromText(\'LineString(0 4,4 6)\'));\n\nSELECT ST_AsText(ST_LineFromWKB(@g)) AS l;\n+---------------------+\n| l                   |\n+---------------------+\n| LINESTRING(0 4,4 6) |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/st_linefromwkb/','','https://mariadb.com/kb/en/st_linefromwkb/'),
(597,'ST_LineStringFromWKB',32,'A synonym for ST_LineFromWKB.\n\nURL: https://mariadb.com/kb/en/st_linestringfromwkb/','','https://mariadb.com/kb/en/st_linestringfromwkb/'),
(253,'CREATE FUNCTION UDF',22,'Syntax\n------\n\nCREATE [OR REPLACE] [AGGREGATE] FUNCTION [IF NOT EXISTS] function_name\n  RETURNS {STRING|INTEGER|REAL|DECIMAL}\n  SONAME shared_library_name\n\nDescription\n-----------\n\nA user-defined function (UDF) is a way to extend MariaDB with a new function\nthat works like a native (built-in) MariaDB function such as ABS() or CONCAT().\n\nfunction_name is the name that should be used in SQL statements to invoke the\nfunction.\n\nTo create a function, you must have the INSERT privilege for the mysql\ndatabase. This is necessary becauseCREATE FUNCTION adds a row to the\nmysql.func system table that records the function\'s name, type, and shared\nlibrary name. If you do not have this table, you should run the\nmariadb-upgrade command to create it.\n\nUDFs need to be written in C, C++ or another language that uses C calling\nconventions, MariaDB needs to have been dynamically compiled, and your\noperating system must support dynamic loading.\n\nFor an example, see sql/udf_example.cc in the source tree. For a collection of\nexisting UDFs see http://www.mysqludf.org/.\n\nStatements making use of user-defined functions are not safe for replication.\n\nFor creating a stored function as opposed to a user-defined function, see\nCREATE FUNCTION.\n\nFor valid identifiers to use as function names, see Identifier Names.\n\nRETURNS\n-------\n\nThe RETURNS clause indicates the type of the function\'s return value, and can\nbe one of STRING, INTEGER, REAL or DECIMAL. DECIMAL functions currently return\nstring values and should be written like STRING functions.\n\nshared_library_name\n-------------------\n\nshared_library_name is the basename of the shared object file that contains\nthe code that implements the function. The file must be located in the plugin\ndirectory. This directory is given by the value of the plugin_dir system\nvariable. Note that before MariaDB/MySQL 5.1, the shared object could be\nlocated in any directory that was searched by your system\'s dynamic linker.\n\nAGGREGATE\n---------\n\nAggregate functions are summary functions such as SUM() and AVG().\n\nMariaDB starting with 10.4\n--------------------------\nAggregate UDF functions can be used as window functions.\n\nOR REPLACE\n----------\n\nMariaDB starting with 10.1.3\n----------------------------\nThe OR REPLACE clause was added in MariaDB 10.1.3\n\nIf the optional OR REPLACE clause is used, it acts as a shortcut for:\n\nDROP FUNCTION IF EXISTS function_name;\nCREATE FUNCTION name ...;\n\nIF NOT EXISTS\n-------------\n\nMariaDB starting with 10.1.3\n----------------------------\nThe IF NOT EXISTS clause was added in MariaDB 10.1.3\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a warning instead\nof an error if the specified function already exists. Cannot be used together\nwith OR REPLACE.\n\nUpgrading a UDF\n---------------\n\nTo upgrade the UDF\'s shared library, first run a DROP FUNCTION statement, then\nupgrade the shared library and finally run the CREATE FUNCTION statement. If\nyou upgrade without following this process, you may crash the server.\n\nExamples\n--------\n\nCREATE FUNCTION jsoncontains_path RETURNS integer SONAME \'ha_connect.so\';\nQuery OK, 0 rows affected (0.00 sec)\n\nOR REPLACE and IF NOT EXISTS:\n\nCREATE FUNCTION jsoncontains_path RETURNS integer SONAME \'ha_connect.so\';\nERROR 1125 (HY000): Function \'jsoncontains_path\' already exists\n\nCREATE OR REPLACE FUNCTION jsoncontains_path RETURNS integer SONAME\n\'ha_connect.so\';\nQuery OK, 0 rows affected (0.00 sec)\n\nCREATE FUNCTION IF NOT EXISTS jsoncontains_path RETURNS integer SONAME\n\'ha_connect.so\';\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+---------------------------------------------+\n| Level | Code | Message                                     |\n+-------+------+---------------------------------------------+\n| Note  | 1125 | Function \'jsoncontains_path\' already exists |\n+-------+------+---------------------------------------------+\n\nURL: https://mariadb.com/kb/en/create-function-udf/','','https://mariadb.com/kb/en/create-function-udf/'),
(259,'TINYINT',23,'Syntax\n------\n\nTINYINT[(M)] [SIGNED | UNSIGNED | ZEROFILL]\n\nDescription\n-----------\n\nA very small integer. The signed range is -128 to 127. The unsigned range is 0\nto 255. For details on the attributes, see Numeric Data Type Overview.\n\nINT1 is a synonym for TINYINT. BOOL and BOOLEAN are synonyms for TINYINT(1).\n\nExamples\n--------\n\nCREATE TABLE tinyints (a TINYINT,b TINYINT UNSIGNED,c TINYINT ZEROFILL);\n\nWith strict_mode set, the default from MariaDB 10.2.4:\n\nINSERT INTO tinyints VALUES (-10,-10,-10);\nERROR 1264 (22003): Out of range value for column \'b\' at row 1\n\nINSERT INTO tinyints VALUES (-10,10,-10);\nERROR 1264 (22003): Out of range value for column \'c\' at row 1\n\nINSERT INTO tinyints VALUES (-10,10,10);\n\nSELECT * FROM tinyints;\n+------+------+------+\n| a    | b    | c    |\n+------+------+------+\n|  -10 |   10 |  010 |\n+------+------+------+\n\nINSERT INTO tinyints VALUES (128,128,128);\nERROR 1264 (22003): Out of range value for column \'a\' at row 1\n\nINSERT INTO tinyints VALUES (127,128,128);\n\nSELECT * FROM tinyints;\n+------+------+------+\n| a    | b    | c    |\n+------+------+------+\n|  -10 |   10 |  010 |\n|  127 |  128 |  128 |\n+------+------+------+\n\nWith strict_mode unset, the default until MariaDB 10.2.3:\n\nINSERT INTO tinyints VALUES (-10,-10,-10);\nQuery OK, 1 row affected, 2 warnings (0.08 sec)\nWarning (Code 1264): Out of range value for column \'b\' at row 1\nWarning (Code 1264): Out of range value for column \'c\' at row 1\n\nINSERT INTO tinyints VALUES (-10,10,-10);\nQuery OK, 1 row affected, 1 warning (0.11 sec)\nWarning (Code 1264): Out of range value for column \'c\' at row 1\n\nINSERT INTO tinyints VALUES (-10,10,10);\n\nSELECT * FROM tinyints;\n+------+------+------+\n| a    | b    | c    |\n+------+------+------+\n|  -10 |    0 |  000 |\n|  -10 |   10 |  000 |\n|  -10 |   10 |  010 |\n+------+------+------+\n\nINSERT INTO tinyints VALUES (128,128,128);\nQuery OK, 1 row affected, 1 warning (0.19 sec)\nWarning (Code 1264): Out of range value for column \'a\' at row 1\n\nINSERT INTO tinyints VALUES (127,128,128);\n\nSELECT * FROM tinyints;\n+------+------+------+\n| a    | b    | c    |\n+------+------+------+\n|  -10 |    0 |  000 |\n|  -10 |   10 |  000 |\n|  -10 |   10 |  010 |\n|  127 |  128 |  128 |\n|  127 |  128 |  128 |\n+------+------+------+\n\nURL: https://mariadb.com/kb/en/tinyint/','','https://mariadb.com/kb/en/tinyint/'),
(598,'ST_PointFromWKB',32,'Syntax\n------\n\nST_PointFromWKB(wkb[,srid])\nPointFromWKB(wkb[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKB representation and SRID.\n\nST_PointFromWKB() and PointFromWKB() are synonyms.\n\nExamples\n--------\n\nSET @g = ST_AsBinary(ST_PointFromText(\'POINT(0 4)\'));\n\nSELECT ST_AsText(ST_PointFromWKB(@g)) AS p;\n+------------+\n| p          |\n+------------+\n| POINT(0 4) |\n+------------+\n\nURL: https://mariadb.com/kb/en/st_pointfromwkb/','','https://mariadb.com/kb/en/st_pointfromwkb/'),
(599,'ST_PolyFromWKB',32,'Syntax\n------\n\nST_PolyFromWKB(wkb[,srid])\nST_PolygonFromWKB(wkb[,srid])\nPolyFromWKB(wkb[,srid])\nPolygonFromWKB(wkb[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKB representation and SRID.\n\nST_PolyFromWKB(), ST_PolygonFromWKB(), PolyFromWKB() and PolygonFromWKB() are\nsynonyms.\n\nExamples\n--------\n\nSET @g = ST_AsBinary(ST_PolyFromText(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1\n1))\'));\n\nSELECT ST_AsText(ST_PolyFromWKB(@g)) AS p;\n+----------------------------------------+\n| p                                      |\n+----------------------------------------+\n| POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1)) |\n+----------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_polyfromwkb/','','https://mariadb.com/kb/en/st_polyfromwkb/'),
(255,'Creating User-Defined Functions',22,'User-defined functions allow MariaDB to be extended with a new function that\nworks like a native (built-in) MariaDB function such as ABS() or CONCAT().\nThere are alternative ways to add a new function: writing a native function\n(which requires modifying and compiling the server source code), or writing a\nstored function.\n\nStatements making use of user-defined functions are not safe for replication.\n\nFunctions are written in C or C++, and to make use of them, the operating\nsystem must support dynamic loading.\n\nEach new SQL function requires corresponding functions written in C/C++. In\nthe list below, at least the main function - x() - and one other, are\nrequired. x should be replaced by the name of the function you are creating.\n\nAll functions need to be thread-safe, so not global or static variables that\nchange can be allocated. Memory is allocated in x_init()/ and freed in\nx_deinit().\n\nSimple Functions\n----------------\n\nx()\n---\n\nRequired for all UDFs; this is where the results are calculated.\n\n+------------------------------------------+----------------------------------+\n| C/C++ type                               | SQL type                         |\n+------------------------------------------+----------------------------------+\n| char *                                   | STRING                           |\n+------------------------------------------+----------------------------------+\n| long long                                | INTEGER                          |\n+------------------------------------------+----------------------------------+\n| double                                   | REAL                             |\n+------------------------------------------+----------------------------------+\n\nDECIMAL functions return string values, and so should be written accordingly.\nIt is not possible to create ROW functions.\n\nx_init()\n--------\n\nInitialization function for x(). Can be used for the following:\n\n* Check the number of arguments to X() (the SQL equivalent).\n* Verify the argument types, or to force arguments to be of a particular type\nafter the function is called.\n* Specify whether the result can be NULL.\n* Specify the maximum result length.\n* For REAL functions, specify the maximum number of decimals for the result.\n* Allocate any required memory.\n\nx_deinit()\n----------\n\nDe-initialization function for x(). Used to de-allocate memory that was\nallocated in x_init().\n\nDescription\n-----------\n\nEach time the SQL function X() is called:\n\n* MariaDB will first call the C/C++ initialization function, x_init(),\nassuming it exists. All setup will be performed, and if it returns an error,\nthe SQL statement is aborted and no further functions are called.\n* If there is no x_init() function, or it has been called and did not return\nan error, x() is then called once per row.\n* After all rows have finished processing, x_deinit() is called, if present,\nto clean up by de-allocating any memory that was allocated in x_init().\n* See User-defined Functions Calling Sequences for more details on the\nfunctions.\n\nAggregate Functions\n-------------------\n\nThe following functions are required for aggregate functions, such as AVG()\nand SUM(). When using CREATE FUNCTION, the AGGREGATE keyword is required.\n\nx_clear()\n---------\n\nUsed to reset the current aggregate, but without inserting the argument as the\ninitial aggregate value for the new group.\n\nx_add()\n-------\n\nUsed to add the argument to the current aggregate.\n\nx_remove()\n----------\n\nStarting from MariaDB 10.4, improves the support of window functions (so it is\nnot obligatory to add it) and should remove the argument from the current\naggregate.\n\nDescription\n-----------\n\nEach time the aggregate SQL function X() is called:\n\n* MariaDB will first call the C/C++ initialization function, x_init(),\nassuming it exists. All setup will be performed, and if it returns an error,\nthe SQL statement is aborted and no further functions are called.\n* If there is no x_init() function, or it has been called and did not return\nan error, x() is then called once per row.\n* After all rows have finished processing, x_deinit() is called, if present,\nto clean up by de-allocating any memory that was allocated in x_init().\n\n* MariaDB will first call the C/C++ initialization function, x_init(),\nassuming it exists. All setup will be performed, and if it returns an error,\nthe SQL statement is aborted and no further functions are called.\n* The table is sorted according to the GROUP BY expression.\n* x_clear() is called for the first row of each new group.\n* x_add() is called once per row for each row in the same group.\n* x() is called when the group changes, or after the last row, to get the\naggregate result. \n* The latter three steps are repeated until all rows have been processed.\n* After all rows have finished processing, x_deinit() is called, if present,\nto clean up by de-allocating any memory that was allocated in x_init().\n\nExamples\n--------\n\nFor an example, see sql/udf_example.cc in the source tree. For a collection of\nexisting UDFs see https://github.com/mysqludf.\n\nURL: https://mariadb.com/kb/en/creating-user-defined-functions/','','https://mariadb.com/kb/en/creating-user-defined-functions/'),
(600,'ST_PolygonFromWKB',32,'A synonym for ST_PolyFromWKB.\n\nURL: https://mariadb.com/kb/en/st_polygonfromwkb/','','https://mariadb.com/kb/en/st_polygonfromwkb/'),
(604,'BOUNDARY',35,'A synonym for ST_BOUNDARY.\n\nURL: https://mariadb.com/kb/en/geometry-properties-boundary/','','https://mariadb.com/kb/en/geometry-properties-boundary/'),
(605,'DIMENSION',35,'A synonym for ST_DIMENSION.\n\nURL: https://mariadb.com/kb/en/dimension/','','https://mariadb.com/kb/en/dimension/'),
(606,'ENVELOPE',35,'A synonym for ST_ENVELOPE.\n\nURL: https://mariadb.com/kb/en/geometry-properties-envelope/','','https://mariadb.com/kb/en/geometry-properties-envelope/'),
(607,'GeometryN',35,'A synonym for ST_GeometryN.\n\nURL: https://mariadb.com/kb/en/geometry-properties-geometryn/','','https://mariadb.com/kb/en/geometry-properties-geometryn/'),
(608,'GeometryType',35,'A synonym for ST_GeometryType.\n\nURL: https://mariadb.com/kb/en/geometry-properties-geometrytype/','','https://mariadb.com/kb/en/geometry-properties-geometrytype/'),
(609,'IsClosed',35,'A synonym for ST_IsClosed.\n\nURL: https://mariadb.com/kb/en/isclosed/','','https://mariadb.com/kb/en/isclosed/'),
(610,'IsEmpty',35,'A synonym for ST_IsEmpty.\n\nURL: https://mariadb.com/kb/en/geometry-properties-isempty/','','https://mariadb.com/kb/en/geometry-properties-isempty/'),
(611,'IsRing',35,'A synonym for ST_IsRing.\n\nURL: https://mariadb.com/kb/en/isring/','','https://mariadb.com/kb/en/isring/'),
(612,'IsSimple',35,'A synonym for ST_IsSImple.\n\nURL: https://mariadb.com/kb/en/geometry-properties-issimple/','','https://mariadb.com/kb/en/geometry-properties-issimple/'),
(613,'NumGeometries',35,'A synonym for ST_NumGeometries.\n\nURL: https://mariadb.com/kb/en/geometry-properties-numgeometries/','','https://mariadb.com/kb/en/geometry-properties-numgeometries/'),
(614,'SRID',35,'A synonym for ST_SRID.\n\nURL: https://mariadb.com/kb/en/geometry-properties-srid/','','https://mariadb.com/kb/en/geometry-properties-srid/'),
(618,'ST_GEOMETRYN',35,'Syntax\n------\n\nST_GeometryN(gc,N)\nGeometryN(gc,N)\n\nDescription\n-----------\n\nReturns the N-th geometry in the GeometryCollection gc. Geometries are\nnumbered beginning with 1.\n\nST_GeometryN() and GeometryN() are synonyms.\n\nExample\n-------\n\nSET @gc = \'GeometryCollection(Point(1 1),LineString(12 14, 9 11))\';\n\nSELECT AsText(GeometryN(GeomFromText(@gc),1));\n+----------------------------------------+\n| AsText(GeometryN(GeomFromText(@gc),1)) |\n+----------------------------------------+\n| POINT(1 1)                             |\n+----------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_geometryn/','','https://mariadb.com/kb/en/st_geometryn/'),
(256,'User-Defined Functions Calling Sequences',22,'The functions described in Creating User-defined Functions are expanded on\nthis page. They are declared as follows:\n\nSimple Functions\n----------------\n\nx()\n---\n\nIf x() returns an integer, it is declared as follows:\n\nlong long x(UDF_INIT *initid, UDF_ARGS *args,\n       char *is_null, char *error);\n\nIf x() returns a string (DECIMAL functions also return string values), it is\ndeclared as follows:\n\nchar *x(UDF_INIT *initid, UDF_ARGS *args,\n     char *result, unsigned long *length,\n     char *is_null, char *error);\n\nIf x() returns a real, it is declared as follows:\n\ndouble x(UDF_INIT *initid, UDF_ARGS *args,\n       char *is_null, char *error);\n\nx_init()\n--------\n\nmy_bool x_init(UDF_INIT *initid, UDF_ARGS *args, char *message);\n\nx_deinit()\n----------\n\nvoid x_deinit(UDF_INIT *initid);\n\nDescription\n-----------\n\ninitid is a parameter passed to all three functions that points to a UDF_INIT\nstructure, used for communicating information between the functions. Its\nstructure members are:\n\n* my_bool maybe_null\nmaybe_null should be set to 1 if x_init can return a NULL value, Defaults to 1\nif any arguments are declared maybe_null.\n\n* unsigned int decimals\nNumber of decimals after the decimal point. The default, if an explicit number\nof decimals is passed in the arguments to the main function, is the maximum\nnumber of decimals, so if 9.5, 9.55 and 9.555 are passed to the function, the\ndefault would be three (based on 9.555, the maximum).  If there are no\nexplicit number of decimals, the default is set to 31, or one more than the\nmaximum for the DOUBLE, FLOAT and DECIMAL types. This default can be changed\nin the function to suit the actual calculation.\n\n* unsigned int max_length\nMaximum length of the result. For integers, the default is 21. For strings,\nthe length of the longest argument. For reals, the default is 13 plus the\nnumber of decimals indicated by initid->decimals. The length includes any\nsigns or decimal points. Can also be set to 65KB or 16MB in order to return a\nBLOB. The memory remains unallocated, but this is used to decide on the data\ntype to use if the data needs to be temporarily stored.\n\n* char *ptr\nA pointer for use as required by the function. Commonly, initid->ptr is used\nto communicate allocated memory, with x_init() allocating the memory and\nassigning it to this pointer, x() using it, and x_deinit() de-allocating it.\n\n* my_bool const_item\nShould be set to 1 in x_init() if x() always returns the same value, otherwise\n0.\n\nAggregate Functions\n-------------------\n\nx_clear()\n---------\n\nx_clear() is a required function for aggregate functions, and is declared as\nfollows:\n\nvoid x_clear(UDF_INIT *initid, char *is_null, char *error);\n\nIt is called when the summary results need to be reset, that is at the\nbeginning of each new group. but also to reset the values when there were no\nmatching rows.\n\nis_null is set to point to CHAR(0) before calling x_clear().\n\nIn the case of an error, you can store the value to which the error argument\npoints (a single-byte variable, not a string string buffer) in the variable.\n\nx_reset()\n---------\n\nx_reset() is declared as follows:\n\nvoid x_reset(UDF_INIT *initid, UDF_ARGS *args,\n       char *is_null, char *error);\n\nIt is called on finding the first row in a new group. Should reset the summary\nvariables, and then use UDF_ARGS as the first value in the group\'s internal\nsummary value. The function is not required if the UDF interface uses\nx_clear().\n\nx_add()\n-------\n\nx_add() is declared as follows:\n\nvoid x_add(UDF_INIT *initid, UDF_ARGS *args,\n      char *is_null, char *error);\n\nIt is called for all rows belonging to the same group, and should be used to\nadd the value in UDF_ARGS to the internal summary variable.\n\nx_remove()\n----------\n\nx_remove() was added in MariaDB 10.4 and is declared as follows (same as\nx_add()):\n\nvoid x_remove(UDF_INIT* initid, UDF_ARGS* args,\n       char* is_null, char *error );\n\nIt adds more efficient support of aggregate UDFs as window functions.\nx_remove() should \"subtract\" the row (reverse x_add()). In MariaDB 10.4\naggregate UDFs will work as WINDOW functions without x_remove() but it will\nnot be so efficient.\n\nIf x_remove() supported (defined) detected automatically.\n\nURL: https://mariadb.com/kb/en/user-defined-functions-calling-sequences/','','https://mariadb.com/kb/en/user-defined-functions-calling-sequences/'),
(260,'BOOLEAN',23,'Syntax\n------\n\nBOOL, BOOLEAN\n\nDescription\n-----------\n\nThese types are synonyms for TINYINT(1). A value of zero is considered false.\nNon-zero values are considered true.\n\nHowever, the values TRUE and FALSE are merely aliases for 1 and 0. See Boolean\nLiterals, as well as the IS operator for testing values against a boolean.\n\nExamples\n--------\n\nCREATE TABLE boo (i BOOLEAN);\n\nDESC boo;\n+-------+------------+------+-----+---------+-------+\n| Field | Type       | Null | Key | Default | Extra |\n+-------+------------+------+-----+---------+-------+\n| i     | tinyint(1) | YES  |     | NULL    |       |\n+-------+------------+------+-----+---------+-------+\n\nSELECT IF(0, \'true\', \'false\');\n+------------------------+\n| IF(0, \'true\', \'false\') |\n+------------------------+\n| false                  |\n+------------------------+\n\nSELECT IF(1, \'true\', \'false\');\n+------------------------+\n| IF(1, \'true\', \'false\') |\n+------------------------+\n| true                   |\n+------------------------+\n\nSELECT IF(2, \'true\', \'false\');\n+------------------------+\n| IF(2, \'true\', \'false\') |\n+------------------------+\n| true                   |\n+------------------------+\n\nTRUE and FALSE as aliases for 1 and 0:\n\nSELECT IF(0 = FALSE, \'true\', \'false\');\n\n+--------------------------------+\n| IF(0 = FALSE, \'true\', \'false\') |\n+--------------------------------+\n| true                           |\n+--------------------------------+\n\nSELECT IF(1 = TRUE, \'true\', \'false\');\n+-------------------------------+\n| IF(1 = TRUE, \'true\', \'false\') |\n+-------------------------------+\n| true                          |\n+-------------------------------+\n\nSELECT IF(2 = TRUE, \'true\', \'false\');\n+-------------------------------+\n| IF(2 = TRUE, \'true\', \'false\') |\n+-------------------------------+\n| false                         |\n+-------------------------------+\n\nSELECT IF(2 = FALSE, \'true\', \'false\');\n+--------------------------------+\n| IF(2 = FALSE, \'true\', \'false\') |\n+--------------------------------+\n| false                          |\n+--------------------------------+\n\nThe last two statements display the results shown because 2 is equal to\nneither 1 nor 0.\n\nURL: https://mariadb.com/kb/en/boolean/','','https://mariadb.com/kb/en/boolean/'),
(619,'ST_GEOMETRYTYPE',35,'Syntax\n------\n\nST_GeometryType(g)\nGeometryType(g)\n\nDescription\n-----------\n\nReturns as a string the name of the geometry type of which the geometry\ninstance g is a member. The name corresponds to one of the instantiable\nGeometry subclasses.\n\nST_GeometryType() and GeometryType() are synonyms.\n\nExamples\n--------\n\nSELECT GeometryType(GeomFromText(\'POINT(1 1)\'));\n+------------------------------------------+\n| GeometryType(GeomFromText(\'POINT(1 1)\')) |\n+------------------------------------------+\n| POINT                                    |\n+------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_geometrytype/','','https://mariadb.com/kb/en/st_geometrytype/'),
(621,'ST_ISEMPTY',35,'Syntax\n------\n\nST_IsEmpty(g)\nIsEmpty(g)\n\nDescription\n-----------\n\nIsEmpty is a function defined by the OpenGIS specification, but is not fully\nimplemented by MariaDB or MySQL.\n\nSince MariaDB and MySQL do not support GIS EMPTY values such as POINT EMPTY,\nas implemented it simply returns 1 if the geometry value g is invalid, 0 if it\nis valid, and NULL if the argument is NULL.\n\nST_IsEmpty() and IsEmpty() are synonyms.\n\nURL: https://mariadb.com/kb/en/st_isempty/','','https://mariadb.com/kb/en/st_isempty/'),
(258,'Numeric Data Type Overview',23,'There are a number of numeric data types:\n\n* TINYINT\n* BOOLEAN - Synonym for TINYINT(1)\n* INT1 - Synonym for TINYINT\n* SMALLINT\n* INT2 - Synonym for SMALLINT\n* MEDIUMINT\n* INT3 - Synonym for MEDIUMINT\n* INT, INTEGER\n* INT4 - Synonym for INT\n* BIGINT\n* INT8 - Synonym for BIGINT\n* DECIMAL, DEC, NUMERIC, FIXED\n* FLOAT\n* DOUBLE, DOUBLE PRECISION, REAL\n* BIT\n\nSee the specific articles for detailed information on each.\n\nSIGNED, UNSIGNED and ZEROFILL\n-----------------------------\n\nMost numeric types can be defined as SIGNED, UNSIGNED or ZEROFILL, for example:\n\nTINYINT[(M)] [SIGNED | UNSIGNED | ZEROFILL]\n\nIf SIGNED, or no attribute, is specified, a portion of the numeric type will\nbe reserved for the sign (plus or minus). For example, a TINYINT SIGNED can\nrange from -128 to 127.\n\nIf UNSIGNED is specified, no portion of the numeric type is reserved for the\nsign, so for integer types range can be larger. For example, a TINYINT\nUNSIGNED can range from 0 to 255. Floating point and fixed-point types also\ncan be UNSIGNED, but this only prevents negative values from being stored and\ndoesn\'t alter the range.\n\nIf ZEROFILL is specified, the column will be set to UNSIGNED and the spaces\nused by default to pad the field are replaced with zeros. ZEROFILL is ignored\nin expressions or as part of a UNION. ZEROFILL is a non-standard MySQL and\nMariaDB enhancement.\n\nNote that although the preferred syntax indicates that the attributes are\nexclusive, more than one attribute can be specified.\n\nUntil MariaDB 10.2.7 (MDEV-8659), any combination of the attributes could be\nused in any order, with duplicates. In this case:\n\n* the presence of ZEROFILL makes the column UNSIGNED ZEROFILL.\n* the presence of UNSIGNED makes the column UNSIGNED.\n\nFrom MariaDB 10.2.8, only the following combinations are supported:\n\n* SIGNED\n* UNSIGNED\n* ZEROFILL\n* UNSIGNED ZEROFILL\n* ZEROFILL UNSIGNED\n\nThe latter two should be replaced with simply ZEROFILL, but are still accepted\nby the parser.\n\nExamples\n--------\n\nCREATE TABLE zf (\n i1 TINYINT SIGNED,\n i2 TINYINT UNSIGNED,\n i3 TINYINT ZEROFILL\n);\n\nINSERT INTO zf VALUES (2,2,2);\n\nSELECT * FROM zf;\n+------+------+------+\n| i1   | i2   | i3   |\n+------+------+------+\n|    2 |    2 |  002 |\n+------+------+------+\n\nRange\n-----\n\nWhen attempting to add a value that is out of the valid range for the numeric\ntype, MariaDB will react depending on the strict SQL_MODE setting.\n\nIf strict_mode has been set (the default from MariaDB 10.2.4), MariaDB will\nreturn an error.\n\nIf strict_mode has not been set (the default until MariaDB 10.2.3), MariaDB\nwill adjust the number to fit in the field, returning a warning.\n\nExamples\n--------\n\nWith strict_mode set:\n\nSHOW VARIABLES LIKE \'sql_mode\';\n+---------------+--------------------------------------------------------------\n----------------------------+\n| Variable_name | Value                                                       \n              |\n+---------------+--------------------------------------------------------------\n----------------------------+\n| sql_mode      |\nSTRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SU\nSTITUTION |\n+---------------+--------------------------------------------------------------\n----------------------------+\n\nCREATE TABLE ranges (i1 TINYINT, i2 SMALLINT, i3 TINYINT UNSIGNED);\n\nINSERT INTO ranges VALUES (257,257,257);\nERROR 1264 (22003): Out of range value for column \'i1\' at row 1\n\nSELECT * FROM ranges;\nEmpty set (0.10 sec)\n\nWith strict_mode unset:\n\nSHOW VARIABLES LIKE \'sql_mode%\';\n+---------------+-------+\n| Variable_name | Value |\n+---------------+-------+\n| sql_mode      |       |\n+---------------+-------+\n\nCREATE TABLE ranges (i1 TINYINT, i2 SMALLINT, i3 TINYINT UNSIGNED);\n\nINSERT INTO ranges VALUES (257,257,257);\nQuery OK, 1 row affected, 2 warnings (0.00 sec)\n\nSHOW WARNINGS;\n+---------+------+---------------------------------------------+\n| Level   | Code | Message                                     |\n+---------+------+---------------------------------------------+\n| Warning | 1264 | Out of range value for column \'i1\' at row 1 |\n| Warning | 1264 | Out of range value for column \'i3\' at row 1 |\n+---------+------+---------------------------------------------+\n2 rows in set (0.00 sec)\n\nSELECT * FROM ranges;\n+------+------+------+\n| i1   | i2   | i3   |\n+------+------+------+\n|  127 |  257 |  255 |\n+------+------+------+\n\nAuto_increment\n--------------\n\nThe AUTO_INCREMENT attribute can be used to generate a unique identity for new\nrows. For more details, see auto_increment.\n\nURL: https://mariadb.com/kb/en/numeric-data-type-overview/','','https://mariadb.com/kb/en/numeric-data-type-overview/'),
(261,'SMALLINT',23,'Syntax\n------\n\nSMALLINT[(M)] [SIGNED | UNSIGNED | ZEROFILL]\n\nDescription\n-----------\n\nA small integer. The signed range is -32768 to 32767. The unsigned range is 0\nto 65535.\n\nIf a column has been set to ZEROFILL, all values will be prepended by zeros so\nthat the SMALLINT value contains a number of M digits.\n\nNote: If the ZEROFILL attribute has been specified, the column will\nautomatically become UNSIGNED.\n\nINT2 is a synonym for SMALLINT.\n\nFor more details on the attributes, see Numeric Data Type Overview.\n\nExamples\n--------\n\nCREATE TABLE smallints (a SMALLINT,b SMALLINT UNSIGNED,c SMALLINT ZEROFILL);\n\nWith strict_mode set, the default from MariaDB 10.2.4:\n\nINSERT INTO smallints VALUES (-10,-10,-10);\nERROR 1264 (22003): Out of range value for column \'b\' at row 1\n\nINSERT INTO smallints VALUES (-10,10,-10);\nERROR 1264 (22003): Out of range value for column \'c\' at row 1\n\nINSERT INTO smallints VALUES (-10,10,10);\n\nINSERT INTO smallints VALUES (32768,32768,32768);\nERROR 1264 (22003): Out of range value for column \'a\' at row 1\n\nINSERT INTO smallints VALUES (32767,32768,32768);\n\nSELECT * FROM smallints;\n+-------+-------+-------+\n| a     | b     | c     |\n+-------+-------+-------+\n|   -10 |    10 | 00010 |\n| 32767 | 32768 | 32768 |\n+-------+-------+-------+\n\nWith strict_mode unset, the default until MariaDB 10.2.3:\n\nINSERT INTO smallints VALUES (-10,-10,-10);\nQuery OK, 1 row affected, 2 warnings (0.09 sec)\nWarning (Code 1264): Out of range value for column \'b\' at row 1\nWarning (Code 1264): Out of range value for column \'c\' at row 1\n\nINSERT INTO smallints VALUES (-10,10,-10);\nQuery OK, 1 row affected, 1 warning (0.08 sec)\nWarning (Code 1264): Out of range value for column \'c\' at row 1\n\nINSERT INTO smallints VALUES (-10,10,10);\n\nINSERT INTO smallints VALUES (32768,32768,32768);\nQuery OK, 1 row affected, 1 warning (0.04 sec)\nWarning (Code 1264): Out of range value for column \'a\' at row 1\n\nINSERT INTO smallints VALUES (32767,32768,32768);\n\nSELECT * FROM smallints;\n+-------+-------+-------+\n| a     | b     | c     |\n+-------+-------+-------+\n|   -10 |     0 | 00000 |\n|   -10 |    10 | 00000 |\n|   -10 |    10 | 00010 |\n| 32767 | 32768 | 32768 |\n| 32767 | 32768 | 32768 |\n+-------+-------+-------+\n\nURL: https://mariadb.com/kb/en/smallint/','','https://mariadb.com/kb/en/smallint/'),
(622,'ST_IsRing',35,'MariaDB starting with 10.1.2\n----------------------------\nThe ST_IsRing function was introduced in MariaDB 10.1.2\n\nSyntax\n------\n\nST_IsRing(g)\nIsRing(g)\n\nDescription\n-----------\n\nReturns true if a given LINESTRING is a ring, that is, both ST_IsClosed and\nST_IsSimple. A simple curve does not pass through the same point more than\nonce. However, see MDEV-7510.\n\nSt_IsRing() and IsRing() are synonyms.\n\nURL: https://mariadb.com/kb/en/st_isring/','','https://mariadb.com/kb/en/st_isring/'),
(262,'MEDIUMINT',23,'Syntax\n------\n\nMEDIUMINT[(M)] [SIGNED | UNSIGNED | ZEROFILL]\n\nDescription\n-----------\n\nA medium-sized integer. The signed range is -8388608 to 8388607. The unsigned\nrange is 0 to 16777215.\n\nZEROFILL pads the integer with zeroes and assumes UNSIGNED (even if UNSIGNED\nis not specified).\n\nINT3 is a synonym for MEDIUMINT.\n\nFor details on the attributes, see Numeric Data Type Overview.\n\nExamples\n--------\n\nCREATE TABLE mediumints (a MEDIUMINT,b MEDIUMINT UNSIGNED,c MEDIUMINT\nZEROFILL);\n\nDESCRIBE mediumints;\n+-------+--------------------------------+------+-----+---------+-------+\n| Field | Type                           | Null | Key | Default | Extra |\n+-------+--------------------------------+------+-----+---------+-------+\n| a     | mediumint(9)                   | YES  |     | NULL    |       |\n| b     | mediumint(8) unsigned          | YES  |     | NULL    |       |\n| c     | mediumint(8) unsigned zerofill | YES  |     | NULL    |       |\n+-------+--------------------------------+------+-----+---------+-------+\n\nWith strict_mode set, the default from MariaDB 10.2.4:\n\nINSERT INTO mediumints VALUES (-10,-10,-10);\nERROR 1264 (22003): Out of range value for column \'b\' at row 1\n\nINSERT INTO mediumints VALUES (-10,10,-10);\nERROR 1264 (22003): Out of range value for column \'c\' at row 1\n\nINSERT INTO mediumints VALUES (-10,10,10);\n\nINSERT INTO mediumints VALUES (8388608,8388608,8388608);\nERROR 1264 (22003): Out of range value for column \'a\' at row 1\n\nINSERT INTO mediumints VALUES (8388607,8388608,8388608);\n\nSELECT * FROM mediumints;\n+---------+---------+----------+\n| a       | b       | c        |\n+---------+---------+----------+\n|     -10 |      10 | 00000010 |\n| 8388607 | 8388608 | 08388608 |\n+---------+---------+----------+\n\nWith strict_mode unset, the default until MariaDB 10.2.3:\n\nINSERT INTO mediumints VALUES (-10,-10,-10);\nQuery OK, 1 row affected, 2 warnings (0.05 sec)\nWarning (Code 1264): Out of range value for column \'b\' at row 1\nWarning (Code 1264): Out of range value for column \'c\' at row 1\n\nINSERT INTO mediumints VALUES (-10,10,-10);\nQuery OK, 1 row affected, 1 warning (0.08 sec)\nWarning (Code 1264): Out of range value for column \'c\' at row 1\n\nINSERT INTO mediumints VALUES (-10,10,10);\n\nINSERT INTO mediumints VALUES (8388608,8388608,8388608);\nQuery OK, 1 row affected, 1 warning (0.05 sec)\nWarning (Code 1264): Out of range value for column \'a\' at row 1\n\nINSERT INTO mediumints VALUES (8388607,8388608,8388608);\n\nSELECT * FROM mediumints;\n+---------+---------+----------+\n| a       | b       | c        |\n+---------+---------+----------+\n|     -10 |       0 | 00000000 |\n|     -10 |       0 | 00000000 |\n|     -10 |      10 | 00000000 |\n|     -10 |      10 | 00000010 |\n| 8388607 | 8388608 | 08388608 |\n| 8388607 | 8388608 | 08388608 |\n+---------+---------+----------+\n\nURL: https://mariadb.com/kb/en/mediumint/','','https://mariadb.com/kb/en/mediumint/'),
(263,'INT',23,'Syntax\n------\n\nINT[(M)] [SIGNED | UNSIGNED | ZEROFILL]\nINTEGER[(M)] [SIGNED | UNSIGNED | ZEROFILL]\n\nDescription\n-----------\n\nA normal-size integer. When marked UNSIGNED, it ranges from 0 to 4294967295,\notherwise its range is -2147483648 to 2147483647 (SIGNED is the default). If a\ncolumn has been set to ZEROFILL, all values will be prepended by zeros so that\nthe INT value contains a number of M digits. INTEGER is a synonym for INT.\n\nNote: If the ZEROFILL attribute has been specified, the column will\nautomatically become UNSIGNED.\n\nINT4 is a synonym for INT.\n\nFor details on the attributes, see Numeric Data Type Overview.\n\nExamples\n--------\n\nCREATE TABLE ints (a INT,b INT UNSIGNED,c INT ZEROFILL);\n\nWith strict_mode set, the default from MariaDB 10.2.4:\n\nINSERT INTO ints VALUES (-10,-10,-10);\nERROR 1264 (22003): Out of range value for column \'b\' at row 1\n\nINSERT INTO ints VALUES (-10,10,-10);\nERROR 1264 (22003): Out of range value for column \'c\' at row 1\n\nINSERT INTO ints VALUES (-10,10,10);\n\nINSERT INTO ints VALUES (2147483648,2147483648,2147483648);\nERROR 1264 (22003): Out of range value for column \'a\' at row 1\n\nINSERT INTO ints VALUES (2147483647,2147483648,2147483648);\n\nSELECT * FROM ints;\n+------------+------------+------------+\n| a          | b          | c          |\n+------------+------------+------------+\n|        -10 |         10 | 0000000010 |\n| 2147483647 | 2147483648 | 2147483648 |\n+------------+------------+------------+\n\nWith strict_mode unset, the default until MariaDB 10.2.3:\n\nINSERT INTO ints VALUES (-10,-10,-10);\nQuery OK, 1 row affected, 2 warnings (0.10 sec)\nWarning (Code 1264): Out of range value for column \'b\' at row 1\nWarning (Code 1264): Out of range value for column \'c\' at row 1\n\nINSERT INTO ints VALUES (-10,10,-10);\nQuery OK, 1 row affected, 1 warning (0.08 sec)\nWarning (Code 1264): Out of range value for column \'c\' at row 1\n\nINSERT INTO ints VALUES (-10,10,10);\n\nINSERT INTO ints VALUES (2147483648,2147483648,2147483648);\nQuery OK, 1 row affected, 1 warning (0.07 sec)\nWarning (Code 1264): Out of range value for column \'a\' at row 1\n\nINSERT INTO ints VALUES (2147483647,2147483648,2147483648);\n\nSELECT * FROM ints;\n+------------+------------+------------+\n| a          | b          | c          |\n+------------+------------+------------+\n|        -10 |          0 | 0000000000 |\n|        -10 |         10 | 0000000000 |\n|        -10 |         10 | 0000000010 |\n| 2147483647 | 2147483648 | 2147483648 |\n| 2147483647 | 2147483648 | 2147483648 |\n+------------+------------+------------+\n\nURL: https://mariadb.com/kb/en/int/','','https://mariadb.com/kb/en/int/'),
(623,'ST_IsSimple',35,'Syntax\n------\n\nST_IsSimple(g)\nIsSimple(g)\n\nDescription\n-----------\n\nReturns true if the given Geometry has no anomalous geometric points, false if\nit does, or NULL if given a NULL value.\n\nST_IsSimple() and IsSimple() are synonyms.\n\nExamples\n--------\n\nA POINT is always simple.\n\nSET @g = \'Point(1 2)\';\n\nSELECT ST_ISSIMPLE(GEOMFROMTEXT(@g));\n+-------------------------------+\n| ST_ISSIMPLE(GEOMFROMTEXT(@g)) |\n+-------------------------------+\n|                             1 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/st_issimple/','','https://mariadb.com/kb/en/st_issimple/'),
(624,'ST_NUMGEOMETRIES',35,'Syntax\n------\n\nST_NumGeometries(gc)\nNumGeometries(gc)\n\nDescription\n-----------\n\nReturns the number of geometries in the GeometryCollection gc.\n\nST_NumGeometries() and NumGeometries() are synonyms.\n\nExample\n-------\n\nSET @gc = \'GeometryCollection(Point(1 1),LineString(2 2, 3 3))\';\n\nSELECT NUMGEOMETRIES(GeomFromText(@gc));\n+----------------------------------+\n| NUMGEOMETRIES(GeomFromText(@gc)) |\n+----------------------------------+\n|                                2 |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/st_numgeometries/','','https://mariadb.com/kb/en/st_numgeometries/'),
(625,'ST_RELATE',35,'MariaDB starting with 10.1.2\n----------------------------\nThe ST_RELATE() function was introduced in MariaDB 10.1.2\n\nSyntax\n------\n\nST_Relate(g1, g2, i)\n\nDescription\n-----------\n\nReturns true if Geometry g1 is spatially related to Geometryg2 by testing for\nintersections between the interior, boundary and exterior of the two\ngeometries as specified by the values in intersection matrix pattern i.\n\nURL: https://mariadb.com/kb/en/st_relate/','','https://mariadb.com/kb/en/st_relate/'),
(626,'ST_SRID',35,'Syntax\n------\n\nST_SRID(g)\nSRID(g)\n\nDescription\n-----------\n\nReturns an integer indicating the Spatial Reference System ID for the geometry\nvalue g.\n\nIn MariaDB, the SRID value is just an integer associated with the geometry\nvalue. All calculations are done assuming Euclidean (planar) geometry.\n\nST_SRID() and SRID() are synonyms.\n\nExamples\n--------\n\nSELECT SRID(GeomFromText(\'LineString(1 1,2 2)\',101));\n+-----------------------------------------------+\n| SRID(GeomFromText(\'LineString(1 1,2 2)\',101)) |\n+-----------------------------------------------+\n|                                           101 |\n+-----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_srid/','','https://mariadb.com/kb/en/st_srid/'),
(264,'BIGINT',23,'Syntax\n------\n\nBIGINT[(M)] [SIGNED | UNSIGNED | ZEROFILL]\n\nDescription\n-----------\n\nA large integer. The signed range is -9223372036854775808 to\n9223372036854775807. The unsigned range is 0 to 18446744073709551615.\n\nIf a column has been set to ZEROFILL, all values will be prepended by zeros so\nthat the BIGINT value contains a number of M digits.\n\nNote: If the ZEROFILL attribute has been specified, the column will\nautomatically become UNSIGNED.\n\nFor more details on the attributes, see Numeric Data Type Overview.\n\nSERIAL is an alias for:\n\nBIGINT UNSIGNED NOT NULL AUTO_INCREMENT UNIQUE\n\nINT8 is a synonym for BIGINT.\n\nExamples\n--------\n\nCREATE TABLE bigints (a BIGINT,b BIGINT UNSIGNED,c BIGINT ZEROFILL);\n\nWith strict_mode set, the default from MariaDB 10.2.4:\n\nINSERT INTO bigints VALUES (-10,-10,-10);\nERROR 1264 (22003): Out of range value for column \'b\' at row 1\n\nINSERT INTO bigints VALUES (-10,10,-10);\nERROR 1264 (22003): Out of range value for column \'c\' at row 1\n\nINSERT INTO bigints VALUES (-10,10,10);\n\nINSERT INTO bigints VALUES\n(9223372036854775808,9223372036854775808,9223372036854775808);\nERROR 1264 (22003): Out of range value for column \'a\' at row 1\n\nINSERT INTO bigints VALUES\n(9223372036854775807,9223372036854775808,9223372036854775808);\n\nSELECT * FROM bigints;\n+---------------------+---------------------+----------------------+\n| a                   | b                   | c                    |\n+---------------------+---------------------+----------------------+\n|                 -10 |                  10 | 00000000000000000010 |\n| 9223372036854775807 | 9223372036854775808 | 09223372036854775808 |\n+---------------------+---------------------+----------------------+\n\nWith strict_mode unset, the default until MariaDB 10.2.3:\n\nINSERT INTO bigints VALUES (-10,-10,-10);\nQuery OK, 1 row affected, 2 warnings (0.08 sec)\nWarning (Code 1264): Out of range value for column \'b\' at row 1\nWarning (Code 1264): Out of range value for column \'c\' at row 1\n\nINSERT INTO bigints VALUES (-10,10,-10);\nQuery OK, 1 row affected, 1 warning (0.08 sec)\nWarning (Code 1264): Out of range value for column \'c\' at row 1\n\nINSERT INTO bigints VALUES (-10,10,10);\n\nINSERT INTO bigints VALUES\n(9223372036854775808,9223372036854775808,9223372036854775808);\nQuery OK, 1 row affected, 1 warning (0.07 sec)\nWarning (Code 1264): Out of range value for column \'a\' at row 1\n\nINSERT INTO bigints VALUES\n(9223372036854775807,9223372036854775808,9223372036854775808);\n\nSELECT * FROM bigints;\n+---------------------+---------------------+----------------------+\n| a                   | b                   | c                    |\n+---------------------+---------------------+----------------------+\n|                 -10 |                   0 | 00000000000000000000 |\n|                 -10 |                  10 | 00000000000000000000 |\n|                 -10 |                  10 | 00000000000000000010 |\n| 9223372036854775807 | 9223372036854775808 | 09223372036854775808 |\n| 9223372036854775807 | 9223372036854775808 | 09223372036854775808 |\n+---------------------+---------------------+----------------------+\n\nURL: https://mariadb.com/kb/en/bigint/','','https://mariadb.com/kb/en/bigint/'),
(265,'DECIMAL',23,'Syntax\n------\n\nDECIMAL[(M[,D])] [SIGNED | UNSIGNED | ZEROFILL]\n\nDescription\n-----------\n\nA packed \"exact\" fixed-point number. M is the total number of digits (the\nprecision) and D is the number of digits after the decimal point (the scale).\n\n* The decimal point and (for negative numbers) the \"-\" sign are not\ncounted in M. \n* If D is 0, values have no decimal point or fractional\npart and on INSERT the value will be rounded to the nearest DECIMAL. \n* The maximum number of digits (M) for DECIMAL is 65. \n* The maximum number of supported decimals (D) is 30 before MariadB 10.2.1 and\n38 afterwards. \n* If D is omitted, the default is 0. If M is omitted, the default is 10.\n\nUNSIGNED, if specified, disallows negative values.\n\nZEROFILL, if specified, pads the number with zeros, up to the total number of\ndigits specified by M.\n\nAll basic calculations (+, -, *, /) with DECIMAL columns are done with a\nprecision of 65 digits.\n\nFor more details on the attributes, see Numeric Data Type Overview.\n\nDEC, NUMERIC and FIXED are synonyms, as well as NUMBER in Oracle mode from\nMariaDB 10.3.\n\nExamples\n--------\n\nCREATE TABLE t1 (d DECIMAL UNSIGNED ZEROFILL);\n\nINSERT INTO t1 VALUES (1),(2),(3),(4.0),(5.2),(5.7);\nQuery OK, 6 rows affected, 2 warnings (0.16 sec)\nRecords: 6  Duplicates: 0  Warnings: 2\n\nNote (Code 1265): Data truncated for column \'d\' at row 5\nNote (Code 1265): Data truncated for column \'d\' at row 6\n\nSELECT * FROM t1;\n+------------+\n| d          |\n+------------+\n| 0000000001 |\n| 0000000002 |\n| 0000000003 |\n| 0000000004 |\n| 0000000005 |\n| 0000000006 |\n+------------+\n\nWith strict_mode set, the default from MariaDB 10.2.4:\n\nINSERT INTO t1 VALUES (-7);\nERROR 1264 (22003): Out of range value for column \'d\' at row 1\n\nWith strict_mode unset, the default until MariaDB 10.2.3:\n\nINSERT INTO t1 VALUES (-7);\nQuery OK, 1 row affected, 1 warning (0.02 sec)\nWarning (Code 1264): Out of range value for column \'d\' at row 1\n\nSELECT * FROM t1;\n+------------+\n| d          |\n+------------+\n| 0000000001 |\n| 0000000002 |\n| 0000000003 |\n| 0000000004 |\n| 0000000005 |\n| 0000000006 |\n| 0000000000 |\n+------------+\n\nURL: https://mariadb.com/kb/en/decimal/','','https://mariadb.com/kb/en/decimal/'),
(628,'NOT REGEXP',36,'Syntax\n------\n\nexpr NOT REGEXP pat, expr NOT RLIKE pat\n\nDescription\n-----------\n\nThis is the same as NOT (expr REGEXP pat).\n\nURL: https://mariadb.com/kb/en/not-regexp/','','https://mariadb.com/kb/en/not-regexp/'),
(633,'ASCII',36,'Syntax\n------\n\nASCII(str)\n\nDescription\n-----------\n\nReturns the numeric ASCII value of the leftmost character of the string\nargument. Returns 0 if the given string is empty and NULL if it is NULL.\n\nASCII() works for 8-bit characters.\n\nExamples\n--------\n\nSELECT ASCII(9);\n+----------+\n| ASCII(9) |\n+----------+\n|       57 |\n+----------+\n\nSELECT ASCII(\'9\');\n+------------+\n| ASCII(\'9\') |\n+------------+\n|         57 |\n+------------+\n\nSELECT ASCII(\'abc\');\n+--------------+\n| ASCII(\'abc\') |\n+--------------+\n|           97 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/ascii/','','https://mariadb.com/kb/en/ascii/'),
(634,'BIN',36,'Syntax\n------\n\nBIN(N)\n\nDescription\n-----------\n\nReturns a string representation of the binary value of the given longlong\n(that is, BIGINT) number. This is equivalent to CONV(N,10,2). The argument\nshould be positive. If it is a FLOAT, it will be truncated. Returns NULL if\nthe argument is NULL.\n\nExamples\n--------\n\nSELECT BIN(12);\n+---------+\n| BIN(12) |\n+---------+\n| 1100    |\n+---------+\n\nURL: https://mariadb.com/kb/en/bin/','','https://mariadb.com/kb/en/bin/'),
(636,'BIT_LENGTH',36,'Syntax\n------\n\nBIT_LENGTH(str)\n\nDescription\n-----------\n\nReturns the length of the given string argument in bits. If the argument is\nnot a string, it will be converted to string. If the argument is NULL, it\nreturns NULL.\n\nExamples\n--------\n\nSELECT BIT_LENGTH(\'text\');\n+--------------------+\n| BIT_LENGTH(\'text\') |\n+--------------------+\n|                 32 |\n+--------------------+\n\nSELECT BIT_LENGTH(\'\');\n+----------------+\n| BIT_LENGTH(\'\') |\n+----------------+\n|              0 |\n+----------------+\n\nCompatibility\n-------------\n\nPostgreSQL and Sybase support BIT_LENGTH().\n\nURL: https://mariadb.com/kb/en/bit_length/','','https://mariadb.com/kb/en/bit_length/'),
(266,'FLOAT',23,'Syntax\n------\n\nFLOAT[(M,D)] [SIGNED | UNSIGNED | ZEROFILL]\n\nDescription\n-----------\n\nA small (single-precision) floating-point number (see DOUBLE for a\nregular-size floating point number). Allowable values are:\n\n* -3.402823466E+38 to -1.175494351E-38\n* 0\n* 1.175494351E-38 to 3.402823466E+38.\n\nThese are the theoretical limits, based on the IEEE standard. The actual range\nmight be slightly smaller depending on your hardware or operating system.\n\nM is the total number of digits and D is the number of digits following the\ndecimal point. If M and D are omitted, values are stored to the limits allowed\nby the hardware. A single-precision floating-point number is accurate to\napproximately 7 decimal places.\n\nUNSIGNED, if specified, disallows negative values.\n\nUsing FLOAT might give you some unexpected problems because all calculations\nin MariaDB are done with double precision. See Floating Point Accuracy.\n\nFor more details on the attributes, see Numeric Data Type Overview.\n\nURL: https://mariadb.com/kb/en/float/','','https://mariadb.com/kb/en/float/'),
(267,'DOUBLE',23,'Syntax\n------\n\nDOUBLE[(M,D)] [SIGNED | UNSIGNED | ZEROFILL]\nDOUBLE PRECISION[(M,D)] [SIGNED | UNSIGNED | ZEROFILL]\nREAL[(M,D)] [SIGNED | UNSIGNED | ZEROFILL]\n\nDescription\n-----------\n\nA normal-size (double-precision) floating-point number (see FLOAT for a\nsingle-precision floating-point number).\n\nAllowable values are:\n\n* -1.7976931348623157E+308 to -2.2250738585072014E-308\n* 0\n* 2.2250738585072014E-308 to 1.7976931348623157E+308\n\nThese are the theoretical limits, based on the IEEE standard. The actual range\nmight be slightly smaller depending on your hardware or operating system.\n\nM is the total number of digits and D is the number of digits following the\ndecimal point. If M and D are omitted, values are stored to the limits allowed\nby the hardware. A double-precision floating-point number is accurate to\napproximately 15 decimal places.\n\nUNSIGNED, if specified, disallows negative values.\n\nZEROFILL, if specified, pads the number with zeros, up to the total number of\ndigits specified by M.\n\nREAL and DOUBLE PRECISION are synonyms, unless the REAL_AS_FLOAT SQL mode is\nenabled, in which case REAL is a synonym for FLOAT rather than DOUBLE.\n\nSee Floating Point Accuracy for issues when using floating-point numbers.\n\nFor more details on the attributes, see Numeric Data Type Overview.\n\nExamples\n--------\n\nCREATE TABLE t1 (d DOUBLE(5,0) zerofill);\n\nINSERT INTO t1 VALUES (1),(2),(3),(4);\n\nSELECT * FROM t1;\n+-------+\n| d     |\n+-------+\n| 00001 |\n| 00002 |\n| 00003 |\n| 00004 |\n+-------+\n\nURL: https://mariadb.com/kb/en/double/','','https://mariadb.com/kb/en/double/'),
(268,'BIT',23,'Syntax\n------\n\nBIT[(M)]\n\nDescription\n-----------\n\nA bit-field type. M indicates the number of bits per value, from 1 to 64. The\ndefault is 1 if M is omitted.\n\nBit values can be inserted with b\'value\' notation, where value is the bit\nvalue in 0\'s and 1\'s.\n\nBit fields are automatically zero-padded from the left to the full length of\nthe bit, so for example in a BIT(4) field, \'10\' is equivalent to \'0010\'.\n\nBits are returned as binary, so to display them, either add 0, or use a\nfunction such as HEX, OCT or BIN to convert them.\n\nExamples\n--------\n\nCREATE TABLE b ( b1 BIT(8) );\n\nWith strict_mode set, the default from MariaDB 10.2.4:\n\nINSERT INTO b VALUES (b\'11111111\');\n\nINSERT INTO b VALUES (b\'01010101\');\n\nINSERT INTO b VALUES (b\'1111111111111\');\nERROR 1406 (22001): Data too long for column \'b1\' at row 1\n\nSELECT b1+0, HEX(b1), OCT(b1), BIN(b1) FROM b;\n+------+---------+---------+----------+\n| b1+0 | HEX(b1) | OCT(b1) | BIN(b1)  |\n+------+---------+---------+----------+\n|  255 | FF      | 377     | 11111111 |\n|   85 | 55      | 125     | 1010101  |\n+------+---------+---------+----------+\n\nWith strict_mode unset, the default until MariaDB 10.2.3:\n\nINSERT INTO b VALUES (b\'11111111\'),(b\'01010101\'),(b\'1111111111111\');\nQuery OK, 3 rows affected, 1 warning (0.10 sec)\nRecords: 3  Duplicates: 0  Warnings: 1\n\nSHOW WARNINGS;\n+---------+------+---------------------------------------------+\n| Level   | Code | Message                                     |\n+---------+------+---------------------------------------------+\n| Warning | 1264 | Out of range value for column \'b1\' at row 3 |\n+---------+------+---------------------------------------------+\n\nSELECT b1+0, HEX(b1), OCT(b1), BIN(b1) FROM b;\n+------+---------+---------+----------+\n| b1+0 | HEX(b1) | OCT(b1) | BIN(b1)  |\n+------+---------+---------+----------+\n|  255 | FF      | 377     | 11111111 |\n|   85 | 55      | 125     | 1010101  |\n|  255 | FF      | 377     | 11111111 |\n+------+---------+---------+----------+\n\nURL: https://mariadb.com/kb/en/bit/','','https://mariadb.com/kb/en/bit/'),
(269,'Floating-point Accuracy',23,'Due to their nature, not all floating-point numbers can be stored with exact\nprecision. Hardware architecture, the CPU or even the compiler version and\noptimization level may affect the precision.\n\nIf you are comparing DOUBLEs or FLOATs with numeric decimals, it is not safe\nto use the equality operator.\n\nSometimes, changing a floating-point number from single-precision (FLOAT) to\ndouble-precision (DOUBLE) will fix the problem.\n\nExample\n-------\n\nf1, f2 and f3 have seemingly identical values across each row, but due to\nfloating point accuracy, the results may be unexpected.\n\nCREATE TABLE fpn (id INT, f1 FLOAT, f2 DOUBLE, f3 DECIMAL (10,3));\nINSERT INTO fpn VALUES (1,2,2,2),(2,0.1,0.1,0.1);\n\nSELECT * FROM fpn WHERE f1*f1 = f2*f2;\n+------+------+------+-------+\n| id   | f1   | f2   | f3    |\n+------+------+------+-------+\n|    1 |    2 |    2 | 2.000 |\n+------+------+------+-------+\n\nThe reason why only one instead of two rows was returned becomes clear when we\nsee how the floating point squares were evaluated.\n\nSELECT f1*f1, f2*f2, f3*f3 FROM fpn;\n+----------------------+----------------------+----------+\n| f1*f1                | f2*f2                | f3*f3    |\n+----------------------+----------------------+----------+\n|                    4 |                    4 | 4.000000 |\n| 0.010000000298023226 | 0.010000000000000002 | 0.010000 |\n+----------------------+----------------------+----------+\n\nURL: https://mariadb.com/kb/en/floating-point-accuracy/','','https://mariadb.com/kb/en/floating-point-accuracy/'),
(652,'INSTR',36,'Syntax\n------\n\nINSTR(str,substr)\n\nDescription\n-----------\n\nReturns the position of the first occurrence of substring substr in string\nstr. This is the same as the two-argument form of LOCATE(), except that the\norder of the arguments is reversed.\n\nINSTR() performs a case-insensitive search.\n\nIf any argument is NULL, returns NULL.\n\nExamples\n--------\n\nSELECT INSTR(\'foobarbar\', \'bar\');\n+---------------------------+\n| INSTR(\'foobarbar\', \'bar\') |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nSELECT INSTR(\'My\', \'Maria\');\n+----------------------+\n| INSTR(\'My\', \'Maria\') |\n+----------------------+\n|                    0 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/instr/','','https://mariadb.com/kb/en/instr/'),
(653,'LCASE',36,'Syntax\n------\n\nLCASE(str)\n\nDescription\n-----------\n\nLCASE() is a synonym for LOWER().\n\nURL: https://mariadb.com/kb/en/lcase/','','https://mariadb.com/kb/en/lcase/'),
(654,'LEFT',36,'Syntax\n------\n\nLEFT(str,len)\n\nDescription\n-----------\n\nReturns the leftmost len characters from the string str, or NULL if any\nargument is NULL.\n\nExamples\n--------\n\nSELECT LEFT(\'MariaDB\', 5);\n+--------------------+\n| LEFT(\'MariaDB\', 5) |\n+--------------------+\n| Maria              |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/left/','','https://mariadb.com/kb/en/left/'),
(270,'BINARY',23,'This page describes the BINARY data type. For details about the operator, see\nBinary Operator.\n\nSyntax\n------\n\nBINARY(M)\n\nDescription\n-----------\n\nThe BINARY type is similar to the CHAR type, but stores binary byte strings\nrather than non-binary character strings. M represents the column length in\nbytes.\n\nIt contains no character set, and comparison and sorting are based on the\nnumeric value of the bytes.\n\nIf the maximum length is exceeded, and SQL strict mode is not enabled , the\nextra characters will be dropped with a warning. If strict mode is enabled, an\nerror will occur.\n\nBINARY values are right-padded with 0x00 (the zero byte) to the specified\nlength when inserted. The padding is not removed on select, so this needs to\nbe taken into account when sorting and comparing, where all bytes are\nsignificant. The zero byte, 0x00 is less than a space for comparison purposes.\n\nExamples\n--------\n\nInserting too many characters, first with strict mode off, then with it on:\n\nCREATE TABLE bins (a BINARY(10));\n\nINSERT INTO bins VALUES(\'12345678901\');\nQuery OK, 1 row affected, 1 warning (0.04 sec)\n\nSELECT * FROM bins;\n+------------+\n| a          |\n+------------+\n| 1234567890 |\n+------------+\n\nSET sql_mode=\'STRICT_ALL_TABLES\';\n\nINSERT INTO bins VALUES(\'12345678901\');\nERROR 1406 (22001): Data too long for column \'a\' at row 1\n\nSorting is performed with the byte value:\n\nTRUNCATE bins;\n\nINSERT INTO bins VALUES(\'A\'),(\'B\'),(\'a\'),(\'b\');\n\nSELECT * FROM bins ORDER BY a;\n+------+\n| a    |\n+------+\n| A    |\n| B    |\n| a    |\n| b    |\n+------+\n\nUsing CAST to sort as a CHAR instead:\n\nSELECT * FROM bins ORDER BY CAST(a AS CHAR);\n+------+\n| a    |\n+------+\n| a    |\n| A    |\n| b    |\n| B    |\n+------+\n\nThe field is a BINARY(10), so padding of two \'\\0\'s are inserted, causing\ncomparisons that don\'t take this into account to fail:\n\nTRUNCATE bins;\n\nINSERT INTO bins VALUES(\'12345678\');\n\nSELECT a = \'12345678\', a = \'12345678\\0\\0\' from bins;\n+----------------+--------------------+\n| a = \'12345678\' | a = \'12345678\\0\\0\' |\n+----------------+--------------------+\n|              0 |                  1 |\n+----------------+--------------------+\n\nURL: https://mariadb.com/kb/en/binary/','','https://mariadb.com/kb/en/binary/'),
(271,'BLOB',23,'Syntax\n------\n\nBLOB[(M)]\n\nDescription\n-----------\n\nA BLOB column with a maximum length of 65,535 (216 - 1) bytes. Each BLOB value\nis stored using a two-byte length prefix that indicates the number of bytes in\nthe value.\n\nAn optional length M can be given for this type. If this is done, MariaDB\ncreates the column as the smallest BLOB type large enough to hold values M\nbytes long.\n\nBLOBS can also be used to store dynamic columns.\n\nBLOB and TEXT columns can both be assigned a DEFAULT value.\n\nIndexing\n--------\n\nMariaDB starting with 10.4\n--------------------------\nFrom MariaDB 10.4, it is possible to set a unique index on a column that uses\nthe BLOB data type. In previous releases this was not possible, as the index\nwould only guarantee the uniqueness of a fixed number of characters.\n\nOracle Mode\n-----------\n\nIn Oracle mode from MariaDB 10.3, BLOB is a synonym for LONGBLOB.\n\nURL: https://mariadb.com/kb/en/blob/','','https://mariadb.com/kb/en/blob/'),
(273,'CHAR',23,'This article covers the CHAR data type. See CHAR Function for the function.\n\nSyntax\n------\n\n[NATIONAL] CHAR[(M)] [CHARACTER SET charset_name] [COLLATE collation_name]\n\nDescription\n-----------\n\nA fixed-length string that is always right-padded with spaces to the specified\nlength when stored. M represents the column length in characters. The range of\nM is 0 to 255. If M is omitted, the length is 1.\n\nCHAR(0) columns can contain 2 values: an empty string or NULL. Such columns\ncannot be part of an index. The CONNECT storage engine does not support\nCHAR(0).\n\nNote: Trailing spaces are removed when CHAR values are retrieved unless the\nPAD_CHAR_TO_FULL_LENGTH SQL mode is enabled.\n\nBefore MariaDB 10.2, all collations were of type PADSPACE, meaning that CHAR\n(as well as VARCHAR and TEXT) values are compared without regard for trailing\nspaces. This does not apply to the LIKE pattern-matching operator, which takes\ninto account trailing spaces.\n\nIf a unique index consists of a column where trailing pad characters are\nstripped or ignored, inserts into that column where values differ only by the\nnumber of trailing pad characters will result in a duplicate-key error.\n\nExamples\n--------\n\nTrailing spaces:\n\nCREATE TABLE strtest (c CHAR(10));\nINSERT INTO strtest VALUES(\'Maria   \');\n\nSELECT c=\'Maria\',c=\'Maria   \' FROM strtest;\n+-----------+--------------+\n| c=\'Maria\' | c=\'Maria   \' |\n+-----------+--------------+\n|         1 |            1 |\n+-----------+--------------+\n\nSELECT c LIKE \'Maria\',c LIKE \'Maria   \' FROM strtest;\n+----------------+-------------------+\n| c LIKE \'Maria\' | c LIKE \'Maria   \' |\n+----------------+-------------------+\n|              1 |                 0 |\n+----------------+-------------------+\n\nNO PAD Collations\n-----------------\n\nNO PAD collations regard trailing spaces as normal characters. You can get a\nlist of all NO PAD collations by querying the Information Schema Collations\ntable, for example:\n\nSELECT collation_name FROM information_schema.collations \n WHERE collation_name LIKE \"%nopad%\";\n+------------------------------+\n| collation_name               |\n+------------------------------+\n| big5_chinese_nopad_ci        |\n| big5_nopad_bin               |\n...\n\nURL: https://mariadb.com/kb/en/char/','','https://mariadb.com/kb/en/char/'),
(665,'MID',36,'Syntax\n------\n\nMID(str,pos,len)\n\nDescription\n-----------\n\nMID(str,pos,len) is a synonym for SUBSTRING(str,pos,len).\n\nExamples\n--------\n\nSELECT MID(\'abcd\',4,1);\n+-----------------+\n| MID(\'abcd\',4,1) |\n+-----------------+\n| d               |\n+-----------------+\n\nSELECT MID(\'abcd\',2,2);\n+-----------------+\n| MID(\'abcd\',2,2) |\n+-----------------+\n| bc              |\n+-----------------+\n\nA negative starting position:\n\nSELECT MID(\'abcd\',-2,4);\n+------------------+\n| MID(\'abcd\',-2,4) |\n+------------------+\n| cd               |\n+------------------+\n\nURL: https://mariadb.com/kb/en/mid/','','https://mariadb.com/kb/en/mid/'),
(667,'NOT LIKE',36,'Syntax\n------\n\nexpr NOT LIKE pat [ESCAPE \'escape_char\']\n\nDescription\n-----------\n\nThis is the same as NOT (expr LIKE pat [ESCAPE \'escape_char\']).\n\nURL: https://mariadb.com/kb/en/not-like/','','https://mariadb.com/kb/en/not-like/'),
(669,'ORD',36,'Syntax\n------\n\nORD(str)\n\nDescription\n-----------\n\nIf the leftmost character of the string str is a multi-byte character, returns\nthe code for that character, calculated from the numeric values of its\nconstituent bytes using this formula:\n\n(1st byte code)\n+ (2nd byte code x 256)\n+ (3rd byte code x 256 x 256) ...\n\nIf the leftmost character is not a multi-byte character, ORD() returns the\nsame value as the ASCII() function.\n\nExamples\n--------\n\nSELECT ORD(\'2\');\n+----------+\n| ORD(\'2\') |\n+----------+\n|       50 |\n+----------+\n\nURL: https://mariadb.com/kb/en/ord/','','https://mariadb.com/kb/en/ord/'),
(670,'POSITION',36,'Syntax\n------\n\nPOSITION(substr IN str)\n\nDescription\n-----------\n\nPOSITION(substr IN str) is a synonym for LOCATE(substr,str).\n\nIt\'s part of ODBC 3.0.\n\nURL: https://mariadb.com/kb/en/position/','','https://mariadb.com/kb/en/position/'),
(671,'QUOTE',36,'Syntax\n------\n\nQUOTE(str)\n\nDescription\n-----------\n\nQuotes a string to produce a result that can be used as a properly escaped\ndata value in an SQL statement. The string is returned enclosed by single\nquotes and with each instance of single quote (\"\'\"), backslash (\"\\\"), ASCII\nNUL, and Control-Z preceded by a backslash. If the argument is NULL, the\nreturn value is the word \"NULL\" without enclosing single quotes.\n\nExamples\n--------\n\nSELECT QUOTE(\"Don\'t!\");\n+-----------------+\n| QUOTE(\"Don\'t!\") |\n+-----------------+\n| \'Don\\\'t!\'       |\n+-----------------+\n\nSELECT QUOTE(NULL); \n+-------------+\n| QUOTE(NULL) |\n+-------------+\n| NULL        |\n+-------------+\n\nURL: https://mariadb.com/kb/en/quote/','','https://mariadb.com/kb/en/quote/'),
(275,'ENUM',23,'Syntax\n------\n\nENUM(\'value1\',\'value2\',...) [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n\nDescription\n-----------\n\nAn enumeration. A string object that can have only one value, chosen from the\nlist of values \'value1\', \'value2\', ..., NULL or the special \'\' error value. In\ntheory, an ENUM column can have a maximum of 65,535 distinct values; in\npractice, the real maximum depends on many factors. ENUM values are\nrepresented internally as integers.\n\nTrailing spaces are automatically stripped from ENUM values on table creation.\n\nENUMs require relatively little storage space compared to strings, either one\nor two bytes depending on the number of enumeration values.\n\nNULL and empty values\n---------------------\n\nAn ENUM can also contain NULL and empty values. If the ENUM column is declared\nto permit NULL values, NULL becomes a valid value, as well as the default\nvalue (see below). If strict SQL Mode is not enabled, and an invalid value is\ninserted into an ENUM, a special empty string, with an index value of zero\n(see Numeric index, below), is inserted, with a warning. This may be\nconfusing, because the empty string is also a possible value, and the only\ndifference if that is this case its index is not 0. Inserting will fail with\nan error if strict mode is active.\n\nIf a DEFAULT clause is missing, the default value will be:\n\n* NULL if the column is nullable;\n* otherwise, the first value in the enumeration.\n\nNumeric index\n-------------\n\nENUM values are indexed numerically in the order they are defined, and sorting\nwill be performed in this numeric order. We suggest not using ENUM to store\nnumerals, as there is little to no storage space benefit, and it is easy to\nconfuse the enum integer with the enum numeral value by leaving out the quotes.\n\nAn ENUM defined as ENUM(\'apple\',\'orange\',\'pear\') would have the following\nindex values:\n\n+--------------------------------------+--------------------------------------+\n| Index                                | Value                                |\n+--------------------------------------+--------------------------------------+\n| NULL                                 | NULL                                 |\n+--------------------------------------+--------------------------------------+\n| 0                                    | \'\'                                   |\n+--------------------------------------+--------------------------------------+\n| 1                                    | \'apple\'                              |\n+--------------------------------------+--------------------------------------+\n| 2                                    | \'orange\'                             |\n+--------------------------------------+--------------------------------------+\n| 3                                    | \'pear\'                               |\n+--------------------------------------+--------------------------------------+\n\nExamples\n--------\n\nCREATE TABLE fruits (\n id INT NOT NULL auto_increment PRIMARY KEY,\n fruit ENUM(\'apple\',\'orange\',\'pear\'),\n bushels INT);\n\nDESCRIBE fruits;\n+---------+-------------------------------+------+-----+---------+-------------\n--+\n| Field   | Type                          | Null | Key | Default | Extra      \n |\n+---------+-------------------------------+------+-----+---------+-------------\n--+\n| id      | int(11)                       | NO   | PRI | NULL    |\nauto_increment |\n| fruit   | enum(\'apple\',\'orange\',\'pear\') | YES  |     | NULL    |            \n |\n| bushels | int(11)                       | YES  |     | NULL    |            \n |\n+---------+-------------------------------+------+-----+---------+-------------\n--+\n\nINSERT INTO fruits\n  (fruit,bushels) VALUES\n  (\'pear\',20),\n  (\'apple\',100),\n  (\'orange\',25);\n\nINSERT INTO fruits\n  (fruit,bushels) VALUES\n  (\'avocado\',10);\nERROR 1265 (01000): Data truncated for column \'fruit\' at row 1\n\nSELECT * FROM fruits;\n+----+--------+---------+\n| id | fruit  | bushels |\n+----+--------+---------+\n|  1 | pear   |      20 |\n|  2 | apple  |     100 |\n|  3 | orange |      25 |\n+----+--------+---------+\n\nSelecting by numeric index:\n\nSELECT * FROM fruits WHERE fruit=2;\n+----+--------+---------+\n| id | fruit  | bushels |\n+----+--------+---------+\n|  3 | orange |      25 |\n+----+--------+---------+\n\nSorting is according to the index value:\n\nCREATE TABLE enums (a ENUM(\'2\',\'1\'));\n\nINSERT INTO enums VALUES (\'1\'),(\'2\');\n\nSELECT * FROM enums ORDER BY a ASC;\n+------+\n| a    |\n+------+\n| 2    |\n| 1    |\n+------+\n\nIt\'s easy to get confused between returning the enum integer with the stored\nvalue, so we don\'t suggest using ENUM to store numerals. The first example\nreturns the 1st indexed field (\'2\' has an index value of 1, as it\'s defined\nfirst), while the second example returns the string value \'1\'.\n\nSELECT * FROM enums WHERE a=1;\n+------+\n| a    |\n+------+\n| 2    |\n+------+\n\nSELECT * FROM enums WHERE a=\'1\';\n+------+\n| a    |\n+------+\n| 1    |\n+------+\n\nURL: https://mariadb.com/kb/en/enum/','','https://mariadb.com/kb/en/enum/'),
(672,'REPEAT Function',36,'Syntax\n------\n\nREPEAT(str,count)\n\nDescription\n-----------\n\nReturns a string consisting of the string str repeated count times. If count\nis less than 1, returns an empty string. Returns NULL if str or count are NULL.\n\nExamples\n--------\n\nSELECT QUOTE(REPEAT(\'MariaDB \',4));\n+------------------------------------+\n| QUOTE(REPEAT(\'MariaDB \',4))        |\n+------------------------------------+\n| \'MariaDB MariaDB MariaDB MariaDB \' |\n+------------------------------------+\n\nURL: https://mariadb.com/kb/en/repeat-function/','','https://mariadb.com/kb/en/repeat-function/'),
(673,'REPLACE Function',36,'Syntax\n------\n\nREPLACE(str,from_str,to_str)\n\nDescription\n-----------\n\nReturns the string str with all occurrences of the string from_str replaced by\nthe string to_str. REPLACE() performs a case-sensitive match when searching\nfor from_str.\n\nExamples\n--------\n\nSELECT REPLACE(\'www.mariadb.org\', \'w\', \'Ww\');\n+---------------------------------------+\n| REPLACE(\'www.mariadb.org\', \'w\', \'Ww\') |\n+---------------------------------------+\n| WwWwWw.mariadb.org                    |\n+---------------------------------------+\n\nURL: https://mariadb.com/kb/en/replace-function/','','https://mariadb.com/kb/en/replace-function/'),
(674,'REVERSE',36,'Syntax\n------\n\nREVERSE(str)\n\nDescription\n-----------\n\nReturns the string str with the order of the characters reversed.\n\nExamples\n--------\n\nSELECT REVERSE(\'desserts\');\n+---------------------+\n| REVERSE(\'desserts\') |\n+---------------------+\n| stressed            |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/reverse/','','https://mariadb.com/kb/en/reverse/'),
(675,'RIGHT',36,'Syntax\n------\n\nRIGHT(str,len)\n\nDescription\n-----------\n\nReturns the rightmost len characters from the string str, or NULL if any\nargument is NULL.\n\nExamples\n--------\n\nSELECT RIGHT(\'MariaDB\', 2);\n+---------------------+\n| RIGHT(\'MariaDB\', 2) |\n+---------------------+\n| DB                  |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/right/','','https://mariadb.com/kb/en/right/'),
(680,'SOUNDS LIKE',36,'Syntax\n------\n\nexpr1 SOUNDS LIKE expr2\n\nDescription\n-----------\n\nThis is the same as SOUNDEX(expr1) = SOUNDEX(expr2).\n\nExample\n-------\n\nSELECT givenname, surname FROM users WHERE givenname SOUNDS LIKE \"robert\";\n+-----------+---------+\n| givenname | surname |\n+-----------+---------+\n| Roberto   | Castro  |\n+-----------+---------+\n\nURL: https://mariadb.com/kb/en/sounds-like/','','https://mariadb.com/kb/en/sounds-like/'),
(276,'INET4',23,'MariaDB starting with 10.10.0\n-----------------------------\nThe INET4 data type was added in MariaDB 10.10.0\n\nSyntax\n------\n\nINET4\n\nDescription\n-----------\n\nINET4 is a data type to store IPv4 addresses, as 4-byte binary strings.\n\nExamples\n--------\n\nCREATE OR REPLACE TABLE t1 (a INET4);\n\nINSERT INTO t1 VALUES(\'0.0.0.0\'), (\'255.10.0.0\'), (\'255.255.255.255\');\n\nINSERT INTO t1 VALUES (0xa0000001);\nINSERT INTO t1 VALUES (0xf0000000);\nINSERT INTO t1 VALUES (0xff000001);\n\nSELECT HEX(a), a FROM t1 ORDER BY a;\n+----------+-----------------+\n| HEX(a)   | a               |\n+----------+-----------------+\n| 00000000 | 0.0.0.0         |\n| A0000001 | 160.0.0.1       |\n| F0000000 | 240.0.0.0       |\n| FF000001 | 255.0.0.1       |\n| FF0A0000 | 255.10.0.0      |\n| FFFFFFFF | 255.255.255.255 |\n+----------+-----------------+\n\nURL: https://mariadb.com/kb/en/inet4/','','https://mariadb.com/kb/en/inet4/'),
(278,'JSON Data Type',23,'The JSON alias was added to make it possible to use JSON columns in statement\nbased replication from MySQL to MariaDB and to make it possible for MariaDB to\nread mysqldumps from MySQL.\n\nJSON is an alias for LONGTEXT introduced for compatibility reasons with\nMySQL\'s JSON data type. MariaDB implements this as a LONGTEXT rather, as the\nJSON data type contradicts the SQL standard, and MariaDB\'s benchmarks indicate\nthat performance is at least equivalent.\n\nIn order to ensure that a a valid json document is inserted, the JSON_VALID\nfunction can be used as a CHECK constraint. This constraint is automatically\nincluded for types using the JSON alias from MariaDB 10.4.3.\n\nExamples\n--------\n\nCREATE TABLE t (j JSON);\n\nDESC t;\n+-------+----------+------+-----+---------+-------+\n| Field | Type     | Null | Key | Default | Extra |\n+-------+----------+------+-----+---------+-------+\n| j     | longtext | YES  |     | NULL    |       |\n+-------+----------+------+-----+---------+-------+\n\nWith validation:\n\nCREATE TABLE t2 (\n j JSON\n CHECK (JSON_VALID(j))\n);\n\nINSERT INTO t2 VALUES (\'invalid\');\nERROR 4025 (23000): CONSTRAINT `j` failed for `test`.`t2`\n\nINSERT INTO t2 VALUES (\'{\"id\": 1, \"name\": \"Monty\"}\');\nQuery OK, 1 row affected (0.13 sec)\n\nReplicating JSON Data Between MySQL and MariaDB\n-----------------------------------------------\n\nThe JSON type in MySQL stores the JSON object in a compact form, not as\nLONGTEXT as in MariaDB. This means that row based replication will not work\nfor JSON types from MySQL to MariaDB.\n\nThere are a a few different ways to solve this:\n\n* Use statement based replication.\n* Change the JSON column to type TEXT in MySQL\n* If you must use row-based replication and cannot change the MySQL master\nfrom JSON to TEXT, you can try to introduce an intermediate MySQL slave and\nchange the column type from JSON to TEXT on it. Then you replicate from this\nintermediate slave to MariaDB.\n\nConverting a MySQL TABLE with JSON Fields to MariaDB\n----------------------------------------------------\n\nMariaDB can\'t directly access MySQL\'s JSON format.\n\nThere are a a few different ways to move the table to MariaDB:\n\n* From MariaDB 10.5.7, see the you can use the mysql_json plugin. See Making\nMariaDB understand MySQL JSON.\n* Change the JSON column to type TEXT in MySQL.  After this, MariaDB can\ndirectly use the table without any need for a dump and restore.\n* Use mysqldump to copy the table.\n\nDifferences Between MySQL JSON Strings and MariaDB JSON Strings\n---------------------------------------------------------------\n\n* In MySQL, JSON is an object and is compared according to json values. In\nMariaDB JSON strings are normal strings and compared as strings. One exception\nis when using JSON_EXTRACT() in which case strings are unescaped before\ncomparison.\n\nURL: https://mariadb.com/kb/en/json-data-type/','','https://mariadb.com/kb/en/json-data-type/'),
(282,'LONGTEXT',23,'Syntax\n------\n\nLONGTEXT [CHARACTER SET charset_name] [COLLATE collation_name]\n\nDescription\n-----------\n\nA TEXT column with a maximum length of 4,294,967,295 or 4GB (232 - 1)\ncharacters. The effective maximum length is less if the value contains\nmulti-byte characters. The effective maximum length of LONGTEXT columns also\ndepends on the configured maximum packet size in the client/server protocol\nand available memory. Each LONGTEXT value is stored using a four-byte length\nprefix that indicates the number of bytes in the value.\n\nFrom MariaDB 10.2.7, JSON is an alias for LONGTEXT. See JSON Data Type for\ndetails.\n\nOracle Mode\n-----------\n\nMariaDB starting with 10.3\n--------------------------\nIn Oracle mode from MariaDB 10.3, CLOB is a synonym for LONGTEXT.\n\nURL: https://mariadb.com/kb/en/longtext/','','https://mariadb.com/kb/en/longtext/'),
(287,'VARBINARY',23,'Syntax\n------\n\nVARBINARY(M)\n\nDescription\n-----------\n\nThe VARBINARY type is similar to the VARCHAR type, but stores binary byte\nstrings rather than non-binary character strings. M represents the maximum\ncolumn length in bytes.\n\nIt contains no character set, and comparison and sorting are based on the\nnumeric value of the bytes.\n\nIf the maximum length is exceeded, and SQL strict mode is not enabled , the\nextra characters will be dropped with a warning. If strict mode is enabled, an\nerror will occur.\n\nUnlike BINARY values, VARBINARYs are not right-padded when inserting.\n\nOracle Mode\n-----------\n\nMariaDB starting with 10.3\n--------------------------\nIn Oracle mode from MariaDB 10.3, RAW is a synonym for VARBINARY.\n\nExamples\n--------\n\nInserting too many characters, first with strict mode off, then with it on:\n\nCREATE TABLE varbins (a VARBINARY(10));\n\nINSERT INTO varbins VALUES(\'12345678901\');\nQuery OK, 1 row affected, 1 warning (0.04 sec)\n\nSELECT * FROM varbins;\n+------------+\n| a          |\n+------------+\n| 1234567890 |\n+------------+\n\nSET sql_mode=\'STRICT_ALL_TABLES\';\n\nINSERT INTO varbins VALUES(\'12345678901\');\nERROR 1406 (22001): Data too long for column \'a\' at row 1\n\nSorting is performed with the byte value:\n\nTRUNCATE varbins;\n\nINSERT INTO varbins VALUES(\'A\'),(\'B\'),(\'a\'),(\'b\');\n\nSELECT * FROM varbins ORDER BY a;\n+------+\n| a    |\n+------+\n| A    |\n| B    |\n| a    |\n| b    |\n+------+\n\nUsing CAST to sort as a CHAR instead:\n\nSELECT * FROM varbins ORDER BY CAST(a AS CHAR);\n+------+\n| a    |\n+------+\n| a    |\n| A    |\n| b    |\n| B    |\n+------+\n\nURL: https://mariadb.com/kb/en/varbinary/','','https://mariadb.com/kb/en/varbinary/'),
(681,'SPACE',36,'Syntax\n------\n\nSPACE(N)\n\nDescription\n-----------\n\nReturns a string consisting of N space characters. If N is NULL, returns NULL.\n\nExamples\n--------\n\nSELECT QUOTE(SPACE(6));\n+-----------------+\n| QUOTE(SPACE(6)) |\n+-----------------+\n| \'      \'        |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/space/','','https://mariadb.com/kb/en/space/'),
(683,'SUBSTR',36,'Description\n-----------\n\nSUBSTR() is a synonym for SUBSTRING().\n\nURL: https://mariadb.com/kb/en/substr/','','https://mariadb.com/kb/en/substr/'),
(689,'UCASE',36,'Syntax\n------\n\nUCASE(str)\n\nDescription\n-----------\n\nUCASE() is a synonym for UPPER().\n\nURL: https://mariadb.com/kb/en/ucase/','','https://mariadb.com/kb/en/ucase/'),
(693,'UPPER',36,'Syntax\n------\n\nUPPER(str)\n\nDescription\n-----------\n\nReturns the string str with all characters changed to uppercase according to\nthe current character set mapping. The default is latin1 (cp1252 West\nEuropean).\n\nSELECT UPPER(surname), givenname FROM users ORDER BY surname;\n+----------------+------------+\n| UPPER(surname) | givenname  |\n+----------------+------------+\n| ABEL           | Jacinto    |\n| CASTRO         | Robert     |\n| COSTA          | Phestos    |\n| MOSCHELLA      | Hippolytos |\n+----------------+------------+\n\nUPPER() is ineffective when applied to binary strings (BINARY, VARBINARY,\nBLOB). The description of LOWER() shows how to perform lettercase conversion\nof binary strings.\n\nURL: https://mariadb.com/kb/en/upper/','','https://mariadb.com/kb/en/upper/'),
(283,'ROW',23,'MariaDB starting with 10.3.0\n----------------------------\nThe ROW data type was introduced in MariaDB 10.3.0.\n\nSyntax\n------\n\nROW (<field name> <data type> [{, <field name> <data type>}... ])\n\nDescription\n-----------\n\nROW is a data type for stored procedure variables.\n\nFeatures\n--------\n\nROW fields as normal variables\n------------------------------\n\nROW fields (members) act as normal variables, and are able to appear in all\nquery parts where a stored procedure variable is allowed:\n\n* Assignment is using the := operator and the SET command:\n\na.x:= 10;\na.x:= b.x;\nSET a.x= 10, a.y=20, a.z= b.z;\n\n* Passing to functions and operators:\n\nSELECT f1(rec.a), rec.a<10;\n\n* Clauses (select list, WHERE, HAVING, LIMIT, etc...,):\n\nSELECT var.a, t1.b FROM t1 WHERE t1.b=var.b LIMIT var.c;\n\n* INSERT values:\n\nINSERT INTO t1 VALUES (rec.a, rec.b, rec.c);\n\n* SELECT .. INTO targets\n\nSELECT a,b INTO rec.a, rec.b FROM t1 WHERE t1.id=10;\n\n* Dynamic SQL out parameters (EXECUTE and EXECUTE IMMEDIATE)\n\nEXECUTE IMMEDIATE \'CALL proc_with_out_param(?)\' USING rec.a;\n\nROW type variables as FETCH targets\n-----------------------------------\n\nROW type variables are allowed as FETCH targets:\n\nFETCH cur INTO rec;\n\nwhere cur is a CURSOR and rec is a ROW type stored procedure variable.\n\nNote, currently an attempt to use FETCH for a ROW type variable returns this\nerror:\n\nERROR 1328 (HY000): Incorrect number of FETCH variables\n\nFETCH from a cursor cur into a ROW variable rec works as follows:\n\n* The number of fields in cur must match the number of fields in rec.\n Otherwise, an error is reported.\n\n* Assignment is done from left to right. The first cursor field is assigned to\n the first variable field, the second cursor field is assigned to the second\n variable field, etc.\n\n* Field names in rec are not important and can differ from field names\n in cur.\n\nSee FETCH Examples (below) for examples of using this with sql_mode=ORACLE and\nsql_mode=DEFAULT.\n\nROW type variables as SELECT...INTO targets\n-------------------------------------------\n\nROW type variables are allowed as SELECT..INTO targets with some differences\ndepending on which sql_mode is in use.\n\n* When using sql_mode=ORACLE, table%ROWTYPE and cursor%ROWTYPE\n variables can be used as SELECT...INTO targets.\n\n* Using multiple ROW variables in the SELECT..INTO list will report an\n error.\n\n* Using ROW variables with a different column count than in\n the SELECT..INTO list will report an error.\n\nSee SELECT...INTO Examples (below) for examples of using this with\nsql_mode=ORACLE and sql_mode=DEFAULT.\n\nFeatures not implemented\n------------------------\n\nThe following features are planned, but not implemented yet:\n\n* Returning a ROW type expression from a stored function (see MDEV-12252).\nThis will need some grammar change to support field names after parentheses:\n\nSELECT f1().x FROM DUAL;\n\n* Returning a ROW type expression from a built-in hybrid type function, such\nas CASE, IF, etc. \n* ROW of ROWs\n\nExamples\n--------\n\nDeclaring a ROW in a stored procedure\n-------------------------------------\n\nDELIMITER $$\nCREATE PROCEDURE p1()\nBEGIN\n DECLARE r ROW (c1 INT, c2 VARCHAR(10));\n SET r.c1= 10;\n SET r.c2= \'test\';\n INSERT INTO t1 VALUES (r.c1, r.c2);\nEND;\n$$\nDELIMITER ;\nCALL p1();\n\nFETCH Examples\n--------------\n\nA complete FETCH example for sql_mode=ORACLE:\n\nDROP TABLE IF EXISTS t1;\nCREATE TABLE t1 (a INT, b VARCHAR(32));\nINSERT INTO t1 VALUES (10,\'b10\');\nINSERT INTO t1 VALUES (20,\'b20\');\nINSERT INTO t1 VALUES (30,\'b30\');\n\nSET sql_mode=oracle;\nDROP PROCEDURE IF EXISTS p1;\nDELIMITER $$\nCREATE PROCEDURE p1 AS\n rec ROW(a INT, b VARCHAR(32));\n CURSOR c IS SELECT a,b FROM t1;\nBEGIN\n OPEN c;\n LOOP\n  FETCH c INTO rec;\n  EXIT WHEN c%NOTFOUND;\n  SELECT (\'rec=(\' || rec.a ||\',\'|| rec.b||\')\');\n END LOOP;\n CLOSE c;\nEND;\n$$\nDELIMITER ;\nCALL p1();\n\nA complete FETCH example for sql_mode=DEFAULT:\n\nDROP TABLE IF EXISTS t1;\nCREATE TABLE t1 (a INT, b VARCHAR(32));\nINSERT INTO t1 VALUES (10,\'b10\');\nINSERT INTO t1 VALUES (20,\'b20\');\nINSERT INTO t1 VALUES (30,\'b30\');\n\nSET sql_mode=DEFAULT;\nDROP PROCEDURE IF EXISTS p1;\nDELIMITER $$\nCREATE PROCEDURE p1()\nBEGIN\n DECLARE done INT DEFAULT FALSE;\n DECLARE rec ROW(a INT, b VARCHAR(32));\n DECLARE c CURSOR FOR SELECT a,b FROM t1;\n DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;\n OPEN c;\nread_loop:\n LOOP\n  FETCH c INTO rec;\n  IF done THEN\n   LEAVE read_loop;\n  END IF;\n  SELECT CONCAT(\'rec=(\',rec.a,\',\',rec.b,\')\');\n END LOOP;\n CLOSE c;\nEND;\n$$\nDELIMITER ;\nCALL p1();\n\nSELECT...INTO Examples\n----------------------\n\nA SELECT...INTO example for sql_mode=DEFAULT:\n\nSET sql_mode=DEFAULT;\nDROP TABLE IF EXISTS t1;\nDROP PROCEDURE IF EXISTS p1;\nCREATE TABLE t1 (a INT, b VARCHAR(32));\nINSERT INTO t1 VALUES (10,\'b10\');\nDELIMITER $$\nCREATE PROCEDURE p1()\nBEGIN\n DECLARE rec1 ROW(a INT, b VARCHAR(32));\n SELECT * FROM t1 INTO rec1;\n SELECT rec1.a, rec1.b;\nEND;\n$$\nDELIMITER ;\nCALL p1();\n\nThe above example returns:\n\n+--------+--------+\n| rec1.a | rec1.b |\n+--------+--------+\n|     10 | b10    |\n+--------+--------+\n\nA SELECT...INTO example for sql_mode=ORACLE:\n\nSET sql_mode=ORACLE;\nDROP TABLE IF EXISTS t1;\nDROP PROCEDURE IF EXISTS p1;\nCREATE TABLE t1 (a INT, b VARCHAR(32));\nINSERT INTO t1 VALUES (10,\'b10\');\nDELIMITER $$\nCREATE PROCEDURE p1 AS\n rec1 ROW(a INT, b VARCHAR(32));\nBEGIN\n SELECT * FROM t1 INTO rec1;\n SELECT rec1.a, rec1.b;\nEND;\n$$\nDELIMITER ;\nCALL p1();\n\nThe above example returns:\n\n+--------+--------+\n| rec1.a | rec1.b |\n+--------+--------+\n|     10 | b10    |\n+--------+--------+\n\nAn example for sql_mode=ORACLE using table%ROWTYPE variables as SELECT..INTO\ntargets:\n\nSET sql_mode=ORACLE;\nDROP TABLE IF EXISTS t1;\nDROP PROCEDURE IF EXISTS p1;\nCREATE TABLE t1 (a INT, b VARCHAR(32));\nINSERT INTO t1 VALUES (10,\'b10\');\nDELIMITER $$\nCREATE PROCEDURE p1 AS\n rec1 t1%ROWTYPE;\nBEGIN\n SELECT * FROM t1 INTO rec1;\n SELECT rec1.a, rec1.b;\nEND;\n$$\nDELIMITER ;\nCALL p1();\n\nThe above example returns:\n\n+--------+--------+\n| rec1.a | rec1.b |\n+--------+--------+\n|     10 | b10    |\n+--------+--------+\n\nAn example for sql_mode=ORACLE using cursor%ROWTYPE variables as SELECT..INTO\ntargets:\n\nSET sql_mode=ORACLE;\nDROP TABLE IF EXISTS t1;\nDROP PROCEDURE IF EXISTS p1;\nCREATE TABLE t1 (a INT, b VARCHAR(32));\nINSERT INTO t1 VALUES (10,\'b10\');\nDELIMITER $$\nCREATE PROCEDURE p1 AS\n CURSOR cur1 IS SELECT * FROM t1;\n rec1 cur1%ROWTYPE;\nBEGIN\n SELECT * FROM t1 INTO rec1;\n SELECT rec1.a, rec1.b;\nEND;\n$$\nDELIMITER ;\nCALL p1();\n\nThe above example returns:\n\n+--------+--------+\n| rec1.a | rec1.b |\n+--------+--------+\n|     10 | b10    |\n+--------+--------+\n\nURL: https://mariadb.com/kb/en/row/','','https://mariadb.com/kb/en/row/'),
(696,'_rowid',37,'Syntax\n------\n\n_rowid\n\nDescription\n-----------\n\nThe _rowid pseudo column is mapped to the primary key in the related table.\nThis can be used as a replacement of the rowid pseudo column in other\ndatabases. Another usage is to simplify sql queries as one doesn\'t have to\nknow the name of the primary key.\n\nExamples\n--------\n\ncreate table t1 (a int primary key, b varchar(80));\ninsert into t1 values (1,\"one\"),(2,\"two\");\nselect * from t1 where _rowid=1;\n\n+---+------+\n| a | b    |\n+---+------+\n| 1 | one  |\n+---+------+\n\nupdate t1 set b=\"three\" where _rowid=2;\nselect * from t1 where _rowid>=1 and _rowid<=10;\n\n+---+-------+\n| a | b     |\n+---+-------+\n| 1 | one   |\n| 2 | three |\n+---+-------+\n\nURL: https://mariadb.com/kb/en/_rowid/','','https://mariadb.com/kb/en/_rowid/'),
(284,'TEXT',23,'Syntax\n------\n\nTEXT[(M)] [CHARACTER SET charset_name] [COLLATE collation_name]\n\nDescription\n-----------\n\nA TEXT column with a maximum length of 65,535 (216 - 1) characters. The\neffective maximum length is less if the value contains multi-byte characters.\nEach TEXT value is stored using a two-byte length prefix that indicates the\nnumber of bytes in the value. If you need a bigger storage, consider using\nMEDIUMTEXT instead.\n\nAn optional length M can be given for this type. If this is done, MariaDB\ncreates the column as the smallest TEXT type large enough to hold values M\ncharacters long.\n\nBefore MariaDB 10.2, all MariaDB collations were of type PADSPACE, meaning\nthat TEXT (as well as VARCHAR and CHAR values) are compared without regard for\ntrailing spaces. This does not apply to the LIKE pattern-matching operator,\nwhich takes into account trailing spaces.\n\nBefore MariaDB 10.2.1, BLOB and TEXT columns could not be assigned a DEFAULT\nvalue. This restriction was lifted in MariaDB 10.2.1.\n\nExamples\n--------\n\nTrailing spaces:\n\nCREATE TABLE strtest (d TEXT(10));\nINSERT INTO strtest VALUES(\'Maria   \');\n\nSELECT d=\'Maria\',d=\'Maria   \' FROM strtest;\n+-----------+--------------+\n| d=\'Maria\' | d=\'Maria   \' |\n+-----------+--------------+\n|         1 |            1 |\n+-----------+--------------+\n\nSELECT d LIKE \'Maria\',d LIKE \'Maria   \' FROM strtest;\n+----------------+-------------------+\n| d LIKE \'Maria\' | d LIKE \'Maria   \' |\n+----------------+-------------------+\n|              0 |                 1 |\n+----------------+-------------------+\n\nIndexing\n--------\n\nTEXT columns can only be indexed over a specified length. This means that they\ncannot be used as the primary key of a table norm until MariaDB 10.4, can a\nunique index be created on them.\n\nMariaDB starting with 10.4\n--------------------------\nStarting with MariaDB 10.4, a unique index can be created on a TEXT column.\n\nInternally, this uses hash indexing to quickly check the values and if a hash\ncollision is found, the actual stored values are compared in order to retain\nthe uniqueness.\n\nDifference between VARCHAR and TEXT\n-----------------------------------\n\n* VARCHAR columns can be fully indexed. TEXT columns can only be indexed over\na specified length.\n* Using TEXT or BLOB in a SELECT query that uses temporary tables for storing\nintermediate results will force the temporary table to be disk based (using\nthe Aria storage engine instead of the memory storage engine, which is a bit\nslower. This is not that bad as the Aria storage engine caches the rows in\nmemory. To get the benefit of this, one should ensure that the\naria_pagecache_buffer_size variable is big enough to hold most of the row and\nindex data for temporary tables.\n\nFor Storage Engine Developers\n-----------------------------\n\n* Internally the full length of the VARCHAR column is allocated inside each\nTABLE objects record[] structure. As there are three such buffers, each open\ntable will allocate 3 times max-length-to-store-varchar bytes of memory.\n* TEXT and BLOB columns are stored with a pointer (4 or 8 bytes) + a 1-4 bytes\nlength.  The TEXT data is only stored once. This means that internally TEXT\nuses less memory for each open table but instead has the additional overhead\nthat each TEXT object needs to be allocated and freed for each row access\n(with some caching in between).\n\nURL: https://mariadb.com/kb/en/text/','','https://mariadb.com/kb/en/text/'),
(291,'DATE',23,'Syntax\n------\n\nDATE\n\nDescription\n-----------\n\nA date. The supported range is \'1000-01-01\' to \'9999-12-31\'. MariaDB displays\nDATE values in \'YYYY-MM-DD\' format, but can be assigned dates in looser\nformats, including strings or numbers, as long as they make sense. These\ninclude a short year, YY-MM-DD, no delimiters, YYMMDD, or any other acceptable\ndelimiter, for example YYYY/MM/DD. For details, see date and time literals.\n\n\'0000-00-00\' is a permitted special value (zero-date), unless the NO_ZERO_DATE\nSQL_MODE is used. Also, individual components of a date can be set to 0 (for\nexample: \'2015-00-12\'), unless the NO_ZERO_IN_DATE SQL_MODE is used. In many\ncases, the result of en expression involving a zero-date, or a date with\nzero-parts, is NULL. If the ALLOW_INVALID_DATES SQL_MODE is enabled, if the\nday part is in the range between 1 and 31, the date does not produce any\nerror, even for months that have less than 31 days.\n\nOracle Mode\n-----------\n\nMariaDB starting with 10.3\n--------------------------\nIn Oracle mode from MariaDB 10.3, DATE with a time portion is a synonym for\nDATETIME. See also mariadb_schema.\n\nExamples\n--------\n\nCREATE TABLE t1 (d DATE);\n\nINSERT INTO t1 VALUES (\"2010-01-12\"), (\"2011-2-28\"), (\'120314\'),(\'13*04*21\');\n\nSELECT * FROM t1;\n+------------+\n| d          |\n+------------+\n| 2010-01-12 |\n| 2011-02-28 |\n| 2012-03-14 |\n| 2013-04-21 |\n+------------+\n\nURL: https://mariadb.com/kb/en/date/','','https://mariadb.com/kb/en/date/'),
(697,'ALTER TABLE',38,'Syntax\n------\n\nALTER [ONLINE] [IGNORE] TABLE [IF EXISTS] tbl_name\n  [WAIT n | NOWAIT]\n  alter_specification [, alter_specification] ...\nalter_specification:\n  table_option ...\n | ADD [COLUMN] [IF NOT EXISTS] col_name column_definition\n    [FIRST | AFTER col_name ]\n | ADD [COLUMN] [IF NOT EXISTS] (col_name column_definition,...)\n | ADD {INDEX|KEY} [IF NOT EXISTS] [index_name]\n    [index_type] (index_col_name,...) [index_option] ...\n | ADD [CONSTRAINT [symbol]] PRIMARY KEY\n    [index_type] (index_col_name,...) [index_option] ...\n | ADD [CONSTRAINT [symbol]]\n    UNIQUE [INDEX|KEY] [index_name]\n    [index_type] (index_col_name,...) [index_option] ...\n | ADD FULLTEXT [INDEX|KEY] [index_name]\n    (index_col_name,...) [index_option] ...\n | ADD SPATIAL [INDEX|KEY] [index_name]\n    (index_col_name,...) [index_option] ...\n | ADD [CONSTRAINT [symbol]]\n    FOREIGN KEY [IF NOT EXISTS] [index_name] (index_col_name,...)\n    reference_definition\n | ADD PERIOD FOR SYSTEM_TIME (start_column_name, end_column_name)\n | ALTER [COLUMN] col_name SET DEFAULT literal | (expression)\n | ALTER [COLUMN] col_name DROP DEFAULT\n | ALTER {INDEX|KEY} index_name [NOT] INVISIBLE\n | CHANGE [COLUMN] [IF EXISTS] old_col_name new_col_name column_definition\n    [FIRST|AFTER col_name]\n | MODIFY [COLUMN] [IF EXISTS] col_name column_definition\n    [FIRST | AFTER col_name]\n | DROP [COLUMN] [IF EXISTS] col_name [RESTRICT|CASCADE]\n | DROP PRIMARY KEY\n | DROP {INDEX|KEY} [IF EXISTS] index_name\n | DROP FOREIGN KEY [IF EXISTS] fk_symbol\n | DROP CONSTRAINT [IF EXISTS] constraint_name\n | DISABLE KEYS\n | ENABLE KEYS\n | RENAME [TO] new_tbl_name\n | ORDER BY col_name [, col_name] ...\n | RENAME COLUMN old_col_name TO new_col_name\n | RENAME {INDEX|KEY} old_index_name TO new_index_name\n | CONVERT TO CHARACTER SET charset_name [COLLATE collation_name]\n | [DEFAULT] CHARACTER SET [=] charset_name\n | [DEFAULT] COLLATE [=] collation_name\n | DISCARD TABLESPACE\n | IMPORT TABLESPACE\n | ALGORITHM [=] {DEFAULT|INPLACE|COPY|NOCOPY|INSTANT}\n | LOCK [=] {DEFAULT|NONE|SHARED|EXCLUSIVE}\n | FORCE\n | partition_options\n | CONVERT TABLE normal_table TO partition_definition\n | CONVERT PARTITION partition_name TO TABLE tbl_name\n | ADD PARTITION [IF NOT EXISTS] (partition_definition)\n | DROP PARTITION [IF EXISTS] partition_names\n | COALESCE PARTITION number\n | REORGANIZE PARTITION [partition_names INTO (partition_definitions)]\n | ANALYZE PARTITION partition_names\n | CHECK PARTITION partition_names\n | OPTIMIZE PARTITION partition_names\n | REBUILD PARTITION partition_names\n | REPAIR PARTITION partition_names\n | EXCHANGE PARTITION partition_name WITH TABLE tbl_name\n | REMOVE PARTITIONING\n | ADD SYSTEM VERSIONING\n | DROP SYSTEM VERSIONING\nindex_col_name:\n  col_name [(length)] [ASC | DESC]\nindex_type:\n  USING {BTREE | HASH | RTREE}\nindex_option:\n  [ KEY_BLOCK_SIZE [=] value\n | index_type\n | WITH PARSER parser_name\n | COMMENT \'string\'\n | CLUSTERING={YES| NO} ]\n [ IGNORED | NOT IGNORED ]\ntable_options:\n  table_option [[,] table_option] ...\n\nDescription\n-----------\n\nALTER TABLE enables you to change the structure of an existing table. For\nexample, you can add or delete columns, create or destroy indexes, change the\ntype of existing columns, or rename columns or the table itself. You can also\nchange the comment for the table and the storage engine of the table.\n\nIf another connection is using the table, a metadata lock is active, and this\nstatement will wait until the lock is released. This is also true for\nnon-transactional tables.\n\nWhen adding a UNIQUE index on a column (or a set of columns) which have\nduplicated values, an error will be produced and the statement will be\nstopped. To suppress the error and force the creation of UNIQUE indexes,\ndiscarding duplicates, the IGNORE option can be specified. This can be useful\nif a column (or a set of columns) should be UNIQUE but it contains duplicate\nvalues; however, this technique provides no control on which rows are\npreserved and which are deleted. Also, note that IGNORE is accepted but\nignored in ALTER TABLE ... EXCHANGE PARTITION statements.\n\nThis statement can also be used to rename a table. For details see RENAME\nTABLE.\n\nWhen an index is created, the storage engine may use a configurable buffer in\nthe process. Incrementing the buffer speeds up the index creation. Aria and\nMyISAM allocate a buffer whose size is defined by aria_sort_buffer_size or\nmyisam_sort_buffer_size, also used for REPAIR TABLE. InnoDB allocates three\nbuffers whose size is defined by innodb_sort_buffer_size.\n\nPrivileges\n----------\n\nExecuting the ALTER TABLE statement generally requires at least the ALTER\nprivilege for the table or the database..\n\nIf you are renaming a table, then it also requires the DROP, CREATE and INSERT\nprivileges for the table or the database as well.\n\nOnline DDL\n----------\n\nOnline DDL is supported with the ALGORITHM and LOCK clauses.\n\nSee InnoDB Online DDL Overview for more information on online DDL with InnoDB.\n\nALTER ONLINE TABLE\n------------------\n\nALTER ONLINE TABLE also works for partitioned tables.\n\nOnline ALTER TABLE is available by executing the following:\n\nALTER ONLINE TABLE ...;\n\nThis statement has the following semantics:\n\nThis statement is equivalent to the following:\n\nALTER TABLE ... LOCK=NONE;\n\nSee the LOCK alter specification for more information.\n\nThis statement is equivalent to the following:\n\nALTER TABLE ... ALGORITHM=INPLACE;\n\nSee the ALGORITHM alter specification for more information.\n\nWAIT/NOWAIT\n-----------\n\nSet the lock wait timeout. See WAIT and NOWAIT.\n\nIF EXISTS\n---------\n\nThe IF EXISTS and IF NOT EXISTS clauses are available for the following:\n\nADD COLUMN       [IF NOT EXISTS]\nADD INDEX        [IF NOT EXISTS]\nADD FOREIGN KEY  [IF NOT EXISTS]\nADD PARTITION    [IF NOT EXISTS]\nCREATE INDEX     [IF NOT EXISTS]\nDROP COLUMN      [IF EXISTS]\nDROP INDEX       [IF EXISTS]\nDROP FOREIGN KEY [IF EXISTS]\nDROP PARTITION   [IF EXISTS]\nCHANGE COLUMN    [IF EXISTS]\nMODIFY COLUMN    [IF EXISTS]\nDROP INDEX       [IF EXISTS]\nWhen IF EXISTS and IF NOT EXISTS are used in clauses, queries will not report\nerrors when the condition is triggered for that clause. A warning with the\nsame message text will be issued and the ALTER will move on to the next clause\nin the statement (or end if finished).\n\nMariaDB starting with 10.5.2\n----------------------------\nIf this is directive is used after ALTER ... TABLE, one will not get an error\nif the table doesn\'t exist.\n\nColumn Definitions\n------------------\n\nSee CREATE TABLE: Column Definitions for information about column definitions.\n\nIndex Definitions\n-----------------\n\nSee CREATE TABLE: Index Definitions for information about index definitions.\n\nThe CREATE INDEX and DROP INDEX statements can also be used to add or remove\nan index.\n\nCharacter Sets and Collations\n-----------------------------\n\nCONVERT TO CHARACTER SET charset_name [COLLATE collation_name]\n[DEFAULT] CHARACTER SET [=] charset_name\n[DEFAULT] COLLATE [=] collation_name\nSee Setting Character Sets and Collations for details on setting the character\nsets and collations.\n\nAlter Specifications\n--------------------\n\nTable Options\n-------------\n\nSee CREATE TABLE: Table Options for information about table options.\n\nADD COLUMN\n----------\n\n... ADD COLUMN [IF NOT EXISTS]  (col_name column_definition,...)\nAdds a column to the table. The syntax is the same as in CREATE TABLE. If you\nare using IF NOT_EXISTS the column will not be added if it was not there\nalready. This is very useful when doing scripts to modify tables.\n\nThe FIRST and AFTER clauses affect the physical order of columns in the\ndatafile. Use FIRST to add a column in the first (leftmost) position, or AFTER\nfollowed by a column name to add the new column in any other position. Note\nthat, nowadays, the physical position of a column is usually irrelevant.\n\nSee also Instant ADD COLUMN for InnoDB.\n\nDROP COLUMN\n-----------\n\n... DROP COLUMN [IF EXISTS] col_name [CASCADE|RESTRICT]\nDrops the column from the table. If you are using IF EXISTS you will not get\nan error if the column didn\'t exist. If the column is part of any index, the\ncolumn will be dropped from them, except if you add a new column with\nidentical name at the same time. The index will be dropped if all columns from\nthe index were dropped. If the column was used in a view or trigger, you will\nget an error next time the view or trigger is accessed. Dropping a column that\nis part of a multi-column UNIQUE constraint is not permitted. For example:\n\nCREATE TABLE a (\n a int,\n b int,\n primary key (a,b)\n);\n\nALTER TABLE x DROP COLUMN a;\n[42000][1072] Key column \'A\' doesn\'t exist in table\n\nThe reason is that dropping column a would result in the new constraint that\nall values in column b be unique. In order to drop the column, an explicit\nDROP PRIMARY KEY and ADD PRIMARY KEY would be required. Up until MariaDB\n10.2.7, the column was dropped and the additional constraint applied,\nresulting in the following structure:\n\nALTER TABLE x DROP COLUMN a;\nQuery OK, 0 rows affected (0.46 sec)\n\nDESC x;\n+-------+---------+------+-----+---------+-------+\n| Field | Type    | Null | Key | Default | Extra |\n+-------+---------+------+-----+---------+-------+\n| b     | int(11) | NO   | PRI | NULL    |       |\n+-------+---------+------+-----+---------+-------+\n\nMariaDB starting with 10.4.0\n----------------------------\nMariaDB 10.4.0 supports instant DROP COLUMN. DROP COLUMN of an indexed column\nwould imply DROP INDEX (and in the case of a non-UNIQUE multi-column index,\npossibly ADD INDEX). These will not be allowed with ALGORITHM=INSTANT, but\nunlike before, they can be allowed with ALGORITHM=NOCOPY\n\nRESTRICT and CASCADE are allowed to make porting from other database systems\neasier. In MariaDB, they do nothing.\n\nMODIFY COLUMN\n-------------\n\nAllows you to modify the type of a column. The column will be at the same\nplace as the original column and all indexes on the column will be kept. Note\nthat when modifying column, you should specify all attributes for the new\ncolumn.\n\nCREATE TABLE t1 (a INT UNSIGNED AUTO_INCREMENT, PRIMARY KEY((a));\nALTER TABLE t1 MODIFY a BIGINT UNSIGNED AUTO_INCREMENT;\n\nCHANGE COLUMN\n-------------\n\nWorks like MODIFY COLUMN except that you can also change the name of the\ncolumn. The column will be at the same place as the original column and all\nindex on the column will be kept.\n\nCREATE TABLE t1 (a INT UNSIGNED AUTO_INCREMENT, PRIMARY KEY(a));\nALTER TABLE t1 CHANGE a b BIGINT UNSIGNED AUTO_INCREMENT;\n\nALTER COLUMN\n------------\n\nThis lets you change column options.\n\nCREATE TABLE t1 (a INT UNSIGNED AUTO_INCREMENT, b varchar(50), PRIMARY KEY(a));\nALTER TABLE t1 ALTER b SET DEFAULT \'hello\';\n\nRENAME INDEX/KEY\n----------------\n\nMariaDB starting with 10.5.2\n----------------------------\nFrom MariaDB 10.5.2, it is possible to rename an index using the RENAME INDEX\n(or RENAME KEY) syntax, for example:\n\nALTER TABLE t1 RENAME INDEX i_old TO i_new;\n\nRENAME COLUMN\n-------------\n\nMariaDB starting with 10.5.2\n----------------------------\nFrom MariaDB 10.5.2, it is possible to rename a column using the RENAME COLUMN\nsyntax, for example:\n\nALTER TABLE t1 RENAME COLUMN c_old TO c_new;\n\nADD PRIMARY KEY\n---------------\n\nAdd a primary key.\n\nFor PRIMARY KEY indexes, you can specify a name for the index, but it is\nsilently ignored, and the name of the index is always PRIMARY.\n\nSee Getting Started with Indexes: Primary Key for more information.\n\nDROP PRIMARY KEY\n----------------\n\nDrop a primary key.\n\nFor PRIMARY KEY indexes, you can specify a name for the index, but it is\nsilently ignored, and the name of the index is always PRIMARY.\n\nSee Getting Started with Indexes: Primary Key for more information.\n\nADD FOREIGN KEY\n---------------\n\nAdd a foreign key.\n\nFor FOREIGN KEY indexes, a reference definition must be provided.\n\nFor FOREIGN KEY indexes, you can specify a name for the constraint, using the\nCONSTRAINT keyword. That name will be used in error messages.\n\nFirst, you have to specify the name of the target (parent) table and a column\nor a column list which must be indexed and whose values must match to the\nforeign key\'s values. The MATCH clause is accepted to improve the\ncompatibility with other DBMS\'s, but has no meaning in MariaDB. The ON DELETE\nand ON UPDATE clauses specify what must be done when a DELETE (or a REPLACE)\nstatements attempts to delete a referenced row from the parent table, and when\nan UPDATE statement attempts to modify the referenced foreign key columns in a\nparent table row, respectively. The following options are allowed:\n\n* RESTRICT: The delete/update operation is not performed.  The statement\nterminates with a 1451 error (SQLSTATE \'2300\').\n* NO ACTION: Synonym for RESTRICT.\n* CASCADE: The delete/update operation is performed in both tables.\n* SET NULL: The update or delete goes ahead in the parent table, and the\ncorresponding foreign key fields in the child table are set to NULL.  (They\nmust not be defined as NOT NULL for this to succeed).\n* SET DEFAULT: This option is implemented only for the legacy PBXT storage\nengine, which is disabled by default and no longer maintained. It sets the\nchild table\'s foreign key fields to their DEFAULT values when the referenced\nparent table key entries are updated or deleted.\n\nIf either clause is omitted, the default behavior for the omitted clause is\nRESTRICT.\n\nSee Foreign Keys for more information.\n\nDROP FOREIGN KEY\n----------------\n\nDrop a foreign key.\n\nSee Foreign Keys for more information.\n\nADD INDEX\n---------\n\nAdd a plain index.\n\nPlain indexes are regular indexes that are not unique, and are not acting as a\nprimary key or a foreign key. They are also not the \"specialized\" FULLTEXT or\nSPATIAL indexes.\n\nSee Getting Started with Indexes: Plain Indexes for more information.\n\nDROP INDEX\n----------\n\nDrop a plain index.\n\nPlain indexes are regular indexes that are not unique, and are not acting as a\nprimary key or a foreign key. They are also not the \"specialized\" FULLTEXT or\nSPATIAL indexes.\n\nSee Getting Started with Indexes: Plain Indexes for more information.\n\nADD UNIQUE INDEX\n----------------\n\nAdd a unique index.\n\nThe UNIQUE keyword means that the index will not accept duplicated values,\nexcept for NULLs. An error will raise if you try to insert duplicate values in\na UNIQUE index.\n\nFor UNIQUE indexes, you can specify a name for the constraint, using the\nCONSTRAINT keyword. That name will be used in error messages.\n\nSee Getting Started with Indexes: Unique Index for more information.\n\nDROP UNIQUE INDEX\n-----------------\n\nDrop a unique index.\n\nThe UNIQUE keyword means that the index will not accept duplicated values,\nexcept for NULLs. An error will raise if you try to insert duplicate values in\na UNIQUE index.\n\nFor UNIQUE indexes, you can specify a name for the constraint, using the\nCONSTRAINT keyword. That name will be used in error messages.\n\nSee Getting Started with Indexes: Unique Index for more information.\n\nADD FULLTEXT INDEX\n------------------\n\nAdd a FULLTEXT index.\n\nSee Full-Text Indexes for more information.\n\nDROP FULLTEXT INDEX\n-------------------\n\nDrop a FULLTEXT index.\n\nSee Full-Text Indexes for more information.\n\nADD SPATIAL INDEX\n-----------------\n\nAdd a SPATIAL index.\n\nSee SPATIAL INDEX for more information.\n\nDROP SPATIAL INDEX\n------------------\n\nDrop a SPATIAL index.\n\nSee SPATIAL INDEX for more information.\n\nENABLE/ DISABLE KEYS\n--------------------\n\nDISABLE KEYS will disable all non unique keys for the table for storage\nengines that support this (at least MyISAM and Aria). This can be used to\nspeed up inserts into empty tables.\n\nENABLE KEYS will enable all disabled keys.\n\nRENAME TO\n---------\n\nRenames the table. See also RENAME TABLE.\n\nADD CONSTRAINT\n--------------\n\nModifies the table adding a constraint on a particular column or columns.\n\nALTER TABLE table_name \nADD CONSTRAINT [constraint_name] CHECK(expression);\nBefore a row is inserted or updated, all constraints are evaluated in the\norder they are defined. If any constraint fails, then the row will not be\nupdated. One can use most deterministic functions in a constraint, including\nUDF\'s.\n\nCREATE TABLE account_ledger (\n	id INT PRIMARY KEY AUTO_INCREMENT,\n	transaction_name VARCHAR(100),\n	credit_account VARCHAR(100),\n	credit_amount INT,\n	debit_account VARCHAR(100),\n	debit_amount INT);\n\nALTER TABLE account_ledger \nADD CONSTRAINT is_balanced \n  CHECK((debit_amount + credit_amount) = 0);\n\nThe constraint_name is optional. If you don\'t provide one in the ALTER TABLE\nstatement, MariaDB auto-generates a name for you. This is done so that you can\nremove it later using DROP CONSTRAINT clause.\n\nYou can disable all constraint expression checks by setting the variable\ncheck_constraint_checks to OFF. You may find this useful when loading a table\nthat violates some constraints that you want to later find and fix in SQL.\n\nTo view constraints on a table, query information_schema.TABLE_CONSTRAINTS:\n\nSELECT CONSTRAINT_NAME, TABLE_NAME, CONSTRAINT_TYPE \nFROM information_schema.TABLE_CONSTRAINTS\nWHERE TABLE_NAME = \'account_ledger\';\n\n+-----------------+----------------+-----------------+\n| CONSTRAINT_NAME | TABLE_NAME     | CONSTRAINT_TYPE |\n+-----------------+----------------+-----------------+\n| is_balanced     | account_ledger | CHECK           |\n+-----------------+----------------+-----------------+\n\nDROP CONSTRAINT\n---------------\n\nDROP CONSTRAINT for UNIQUE and FOREIGN KEY constraints was introduced in\nMariaDB 10.2.22 and MariaDB 10.3.13.\n\nDROP CONSTRAINT for CHECK constraints was introduced in MariaDB 10.2.1\n\nModifies the table, removing the given constraint.\n\nALTER TABLE table_name\nDROP CONSTRAINT constraint_name;\n\nWhen you add a constraint to a table, whether through a CREATE TABLE or ALTER\nTABLE...ADD CONSTRAINT statement, you can either set a constraint_name\nyourself, or allow MariaDB to auto-generate one for you. To view constraints\non a table, query information_schema.TABLE_CONSTRAINTS. For instance,\n\nCREATE TABLE t (\n a INT,\n b INT,\n c INT,\n CONSTRAINT CHECK(a > b),\n CONSTRAINT check_equals CHECK(a = c));\n\nSELECT CONSTRAINT_NAME, TABLE_NAME, CONSTRAINT_TYPE \nFROM information_schema.TABLE_CONSTRAINTS\nWHERE TABLE_NAME = \'t\';\n\n+-----------------+----------------+-----------------+\n| CONSTRAINT_NAME | TABLE_NAME     | CONSTRAINT_TYPE |\n+-----------------+----------------+-----------------+\n| check_equals    | t              | CHECK           |\n| CONSTRAINT_1    | t              | CHECK           |\n+-----------------+----------------+-----------------+\n\nTo remove a constraint from the table, issue an ALTER TABLE...DROP CONSTRAINT\nstatement. For example,\n\nALTER TABLE t DROP CONSTRAINT is_unique;\n\nADD SYSTEM VERSIONING\n---------------------\n\nAdd system versioning. See System-versioned tables.\n\nDROP SYSTEM VERSIONING\n----------------------\n\nDrop system versioning. See System-versioned tables.\n\nADD PERIOD FOR SYSTEM_TIME\n--------------------------\n\nSee System-versioned tables.\n\nFORCE\n-----\n\nALTER TABLE ... FORCE can force MariaDB to re-build the table.\n\nIn MariaDB 5.5 and before, this could only be done by setting the ENGINE table\noption to its old value. For example, for an InnoDB table, one could execute\nthe following:\n\nALTER TABLE tab_name ENGINE = InnoDB;\n\nThe FORCE option can be used instead. For example, :\n\nALTER TABLE tab_name FORCE;\n\nWith InnoDB, the table rebuild will only reclaim unused space (i.e. the space\npreviously used for deleted rows) if the innodb_file_per_table system variable\nis set to ON (the default). If the system variable is OFF, then the space will\nnot be reclaimed, but it will be-re-used for new data that\'s later added.\n\nCONVERT TABLE / CONVERT PARTITION\n---------------------------------\n\nCONVERT TABLE and CONVERT PARTITION was introduced in MariaDB 10.7.1.\n\nCONVERT PARTITION can be used to remove a partition from a table and make this\nan ordinary table. For example:\n\nALTER TABLE partitioned_table CONVERT PARTITION part1 TO TABLE normal_table;\n\nCONVERT PARTITION will take an existing table and move this to another table\nas its own partition with a specified partition definition. For example the\nfollowing moves normal_table to a partition of partitioned_table with a\ndefinition that its values, based on the PARTITION BY of the\npartitioned_table, are less than 12345.\n\nALTER TABLE partitioned_table CONVERT TABLE normal_table TO PARTITION part1\nVALUES LESS THAN (12345);\n\nEXCHANGE PARTITION\n------------------\n\nThis is used to exchange the contents of a partition with another table.\n\nThis is performed by swapping the tablespaces of the partition with the other\ntable.\n\nSee copying InnoDB\'s transportable tablespaces for more information.\n\nDISCARD TABLESPACE\n------------------\n\nThis is used to discard an InnoDB table\'s tablespace.\n\nSee copying InnoDB\'s transportable tablespaces for more information.\n\nIMPORT TABLESPACE\n-----------------\n\nThis is used to import an InnoDB table\'s tablespace. The tablespace should\nhave been copied from its original server after executing FLUSH TABLES FOR\nEXPORT.\n\nSee copying InnoDB\'s transportable tablespaces for more information.\n\nALTER TABLE ... IMPORT only applies to InnoDB tables. Most other popular\nstorage engines, such as Aria and MyISAM, will recognize their data files as\nsoon as they\'ve been placed in the proper directory under the datadir, and no\nspecial DDL is required to import them.\n\nALGORITHM\n---------\n\nThe ALTER TABLE statement supports the ALGORITHM clause. This clause is one of\nthe clauses that is used to implement online DDL. ALTER TABLE supports several\ndifferent algorithms. An algorithm can be explicitly chosen for an ALTER TABLE\noperation by setting the ALGORITHM clause. The supported values are:\n\n* ALGORITHM=DEFAULT - This implies the default behavior for the specific\nstatement, such as if no ALGORITHM clause is specified.\n* ALGORITHM=COPY\n* ALGORITHM=INPLACE\n* ALGORITHM=NOCOPY - This was added in MariaDB 10.3.7.\n* ALGORITHM=INSTANT - This was added in MariaDB 10.3.7.\n\nSee InnoDB Online DDL Overview: ALGORITHM for information on how the ALGORITHM\nclause affects InnoDB.\n\nALGORITHM=DEFAULT\n-----------------\n\nThe default behavior, which occurs if ALGORITHM=DEFAULT is specified, or if\nALGORITHM is not specified at all, usually only makes a copy if the operation\ndoesn\'t support being done in-place at all. In this case, the most efficient\navailable algorithm will usually be used.\n\nHowever, in MariaDB 10.3.6 and before, if the value of the old_alter_table\nsystem variable is set to ON, then the default behavior is to perform ALTER\nTABLE operations by making a copy of the table using the old algorithm.\n\nIn MariaDB 10.3.7 and later, the old_alter_table system variable is\ndeprecated. Instead, the alter_algorithm system variable defines the default\nalgorithm for ALTER TABLE operations.\n\nALGORITHM=COPY\n--------------\n\nALGORITHM=COPY is the name for the original ALTER TABLE algorithm from early\nMariaDB versions.\n\nWhen ALGORITHM=COPY is set, MariaDB essentially does the following operations:\n\n-- Create a temporary table with the new definition\nCREATE TEMPORARY TABLE tmp_tab (\n...\n);\n\n-- Copy the data from the original table\nINSERT INTO tmp_tab\n SELECT * FROM original_tab;\n\n-- Drop the original table\nDROP TABLE original_tab;\n\n-- Rename the temporary table, so that it replaces the original one\nRENAME TABLE tmp_tab TO original_tab;\n\nThis algorithm is very inefficient, but it is generic, so it works for all\nstorage engines.\n\nIf ALGORITHM=COPY is specified, then the copy algorithm will be used even if\nit is not necessary. This can result in a lengthy table copy. If multiple\nALTER TABLE operations are required that each require the table to be rebuilt,\nthen it is best to specify all operations in a single ALTER TABLE statement,\nso that the table is only rebuilt once.\n\nALGORITHM=INPLACE\n-----------------\n\nALGORITHM=COPY can be incredibly slow, because the whole table has to be\ncopied and rebuilt. ALGORITHM=INPLACE was introduced as a way to avoid this by\nperforming operations in-place and avoiding the table copy and rebuild, when\npossible.\n\nWhen ALGORITHM=INPLACE is set, the underlying storage engine uses\noptimizations to perform the operation while avoiding the table copy and\nrebuild. However, INPLACE is a bit of a misnomer, since some operations may\nstill require the table to be rebuilt for some storage engines. Regardless,\nseveral operations can be performed without a full copy of the table for some\nstorage engines.\n\nA more accurate name would have been ALGORITHM=ENGINE, where ENGINE refers to\nan \"engine-specific\" algorithm.\n\nIf an ALTER TABLE operation supports ALGORITHM=INPLACE, then it can be\nperformed using optimizations by the underlying storage engine, but it may\nrebuilt.\n\nSee InnoDB Online DDL Operations with ALGORITHM=INPLACE for more.\n\nALGORITHM=NOCOPY\n----------------\n\nALGORITHM=NOCOPY was introduced in MariaDB 10.3.7.\n\nALGORITHM=INPLACE can sometimes be surprisingly slow in instances where it has\nto rebuild the clustered index, because when the clustered index has to be\nrebuilt, the whole table has to be rebuilt. ALGORITHM=NOCOPY was introduced as\na way to avoid this.\n\nIf an ALTER TABLE operation supports ALGORITHM=NOCOPY, then it can be\nperformed without rebuilding the clustered index.\n\nIf ALGORITHM=NOCOPY is specified for an ALTER TABLE operation that does not\nsupport ALGORITHM=NOCOPY, then an error will be raised. In this case, raising\nan error is preferable, if the alternative is for the operation to rebuild the\nclustered index, and perform unexpectedly slowly.\n\nSee InnoDB Online DDL Operations with ALGORITHM=NOCOPY for more.\n\nALGORITHM=INSTANT\n-----------------\n\nALGORITHM=INSTANT was introduced in MariaDB 10.3.7.\n\nALGORITHM=INPLACE can sometimes be surprisingly slow in instances where it has\nto modify data files. ALGORITHM=INSTANT was introduced as a way to avoid this.\n\nIf an ALTER TABLE operation supports ALGORITHM=INSTANT, then it can be\nperformed without modifying any data files.\n\nIf ALGORITHM=INSTANT is specified for an ALTER TABLE operation that does not\nsupport ALGORITHM=INSTANT, then an error will be raised. In this case, raising\nan error is preferable, if the alternative is for the operation to modify data\nfiles, and perform unexpectedly slowly.\n\nSee InnoDB Online DDL Operations with ALGORITHM=INSTANT for more.\n\nLOCK\n----\n\nThe ALTER TABLE statement supports the LOCK clause. This clause is one of the\nclauses that is used to implement online DDL. ALTER TABLE supports several\ndifferent locking strategies. A locking strategy can be explicitly chosen for\nan ALTER TABLE operation by setting the LOCK clause. The supported values are:\n\n* DEFAULT: Acquire the least restrictive lock on the table that is supported\nfor the specific operation. Permit the maximum amount of concurrency that is\nsupported for the specific operation.\n* NONE: Acquire no lock on the table. Permit all concurrent DML. If this\nlocking strategy is not permitted for an operation, then an error is raised.\n* SHARED: Acquire a read lock on the table. Permit read-only concurrent DML.\nIf this locking strategy is not permitted for an operation, then an error is\nraised.\n* EXCLUSIVE: Acquire a write lock on the table. Do not permit concurrent DML.\n\nDifferent storage engines support different locking strategies for different\noperations. If a specific locking strategy is chosen for an ALTER TABLE\noperation, and that table\'s storage engine does not support that locking\nstrategy for that specific operation, then an error will be raised.\n\nIf the LOCK clause is not explicitly set, then the operation uses LOCK=DEFAULT.\n\nALTER ONLINE TABLE is equivalent to LOCK=NONE. Therefore, the ALTER ONLINE\nTABLE statement can be used to ensure that your ALTER TABLE operation allows\nall concurrent DML.\n\nSee InnoDB Online DDL Overview: LOCK for information on how the LOCK clause\naffects InnoDB.\n\nProgress Reporting\n------------------\n\nMariaDB provides progress reporting for ALTER TABLE statement for clients that\nsupport the new progress reporting protocol. For example, if you were using\nthe mariadb client, then the progress report might look like this::\n\nALTER TABLE test ENGINE=Aria;\nStage: 1 of 2 \'copy to tmp table\'    46% of stage\n\nThe progress report is also shown in the output of the SHOW PROCESSLIST\nstatement and in the contents of the information_schema.PROCESSLIST table.\n\nSee Progress Reporting for more information.\n\nAborting ALTER TABLE Operations\n-------------------------------\n\nIf an ALTER TABLE operation is being performed and the connection is killed,\nthe changes will be rolled back in a controlled manner. The rollback can be a\nslow operation as the time it takes is relative to how far the operation has\nprogressed.\n\nAborting ALTER TABLE ... ALGORITHM=COPY was made faster in MariaDB 10.2.13 by\nremoving excessive undo logging (MDEV-11415). This significantly shortened the\ntime it takes to abort a running ALTER TABLE operation, compared with earlier\nreleases.\n\nAtomic ALTER TABLE\n------------------\n\nMariaDB starting with 10.6.1\n----------------------------\nFrom MariaDB 10.6, ALTER TABLE is atomic for most engines, including InnoDB,\nMyRocks, MyISAM and Aria (MDEV-25180). This means that if there is a crash\n(server down or power outage) during an ALTER TABLE operation, after recovery,\neither the old table and associated triggers and status will be intact, or the\nnew table will be active.\n\nIn older MariaDB versions one could get leftover #sql-alter..\',\n\'#sql-backup..\' or \'table_name.frm˝\' files if the system crashed during the\nALTER TABLE operation.\n\nSee Atomic DDL for more information.\n\nReplication\n-----------\n\nMariaDB starting with 10.8.1\n----------------------------\nBefore MariaDB 10.8.1, ALTER TABLE got fully executed on the primary first,\nand only then was it replicated and started executing on replicas. From\nMariaDB 10.8.1, ALTER TABLE gains an option to replicate sooner and begin\nexecuting on replicas when it merely starts executing on the primary, not when\nit finishes. This way the replication lag caused by a heavy ALTER TABLE can be\ncompletely eliminated (MDEV-11675).\n\nExamples\n--------\n\nAdding a new column:\n\nALTER TABLE t1 ADD x INT;\n\nDropping a column:\n\nALTER TABLE t1 DROP x;\n\nModifying the type of a column:\n\nALTER TABLE t1 MODIFY x bigint unsigned;\n\nChanging the name and type of a column:\n\nALTER TABLE t1 CHANGE a b bigint unsigned auto_increment;\n\nCombining multiple clauses in a single ALTER TABLE statement, separated by\ncommas:\n\nALTER TABLE t1 DROP x, ADD x2 INT,  CHANGE y y2 INT;\n\nChanging the storage engine and adding a comment:\n\nALTER TABLE t1 \n ENGINE = InnoDB\n COMMENT = \'First of three tables containing usage info\';\n\nRebuilding the table (the previous example will also rebuild the table if it\nwas already InnoDB):\n\nALTER TABLE t1 FORCE;\n\nDropping an index:\n\nALTER TABLE rooms DROP INDEX u;\n\nAdding a unique index:\n\nALTER TABLE rooms ADD UNIQUE INDEX u(room_number);\n\nFrom MariaDB 10.5.3, adding a primary key for an application-time period table\nwith a WITHOUT OVERLAPS constraint:\n\nALTER TABLE rooms ADD PRIMARY KEY(room_number, p WITHOUT OVERLAPS);\n\nFrom MariaDB 10.8.1, ALTER query can be replicated faster with the setting of\n\nSET @@SESSION.binlog_alter_two_phase = true;\n\nprior the ALTER query. Binlog would contain two event groups\n\n| master-bin.000001 | 495 | Gtid              |         1 |         537 | GTID\n0-1-2 START ALTER                                        |\n| master-bin.000001 | 537 | Query             |         1 |         655 | use\n`test`; alter table t add column b int, algorithm=inplace |\n| master-bin.000001 | 655 | Gtid              |         1 |         700 | GTID\n0-1-3 COMMIT ALTER id=2                                  |\n| master-bin.000001 | 700 | Query             |         1 |         835 | use\n`test`; alter table t add column b int, algorithm=inplace |\n\nof which the first one gets delivered to replicas before ALTER is taken to\nactual execution on the primary.\n\nURL: https://mariadb.com/kb/en/alter-table/','','https://mariadb.com/kb/en/alter-table/'),
(701,'ALTER LOGFILE GROUP',38,'Syntax\n------\n\nALTER LOGFILE GROUP logfile_group\n  ADD UNDOFILE \'file_name\'\n  [INITIAL_SIZE [=] size]\n  [WAIT]\n  ENGINE [=] engine_name\n\nThe ALTER LOGFILE GROUP statement is not supported by MariaDB. It was\noriginally inherited from MySQL NDB Cluster. See MDEV-19295 for more\ninformation.\n\nURL: https://mariadb.com/kb/en/alter-logfile-group/','','https://mariadb.com/kb/en/alter-logfile-group/'),
(703,'ALTER SERVER',38,'Syntax\n------\n\nALTER SERVER server_name\n  OPTIONS (option [, option] ...)\n\nDescription\n-----------\n\nAlters the server information for server_name, adjusting the specified options\nas per the CREATE SERVER command. The corresponding fields in the\nmysql.servers table are updated accordingly. This statement requires the SUPER\nprivilege or, from MariaDB 10.5.2, the FEDERATED ADMIN privilege.\n\nALTER SERVER is not written to the binary log, irrespective of the binary log\nformat being used. From MariaDB 10.1.13, Galera replicates the CREATE SERVER,\nALTER SERVER and DROP SERVER statements.\n\nExamples\n--------\n\nALTER SERVER s OPTIONS (USER \'sally\');\n\nURL: https://mariadb.com/kb/en/alter-server/','','https://mariadb.com/kb/en/alter-server/'),
(704,'ALTER TABLESPACE',38,'The ALTER TABLESPACE statement is not supported by MariaDB. It was originally\ninherited from MySQL NDB Cluster. In MySQL 5.7 and later, the statement is\nalso supported for InnoDB. However, MariaDB has chosen not to include that\nspecific feature. See MDEV-19294 for more information.\n\nURL: https://mariadb.com/kb/en/alter-tablespace/','','https://mariadb.com/kb/en/alter-tablespace/'),
(706,'CREATE TABLE',38,'Syntax\n------\n\nCREATE [OR REPLACE] [TEMPORARY] TABLE [IF NOT EXISTS] tbl_name\n  (create_definition,...) [table_options    ]... [partition_options]\nCREATE [OR REPLACE] [TEMPORARY] TABLE [IF NOT EXISTS] tbl_name\n  [(create_definition,...)] [table_options   ]... [partition_options]\n  select_statement\nCREATE [OR REPLACE] [TEMPORARY] TABLE [IF NOT EXISTS] tbl_name\n { LIKE old_table_name | (LIKE old_table_name) }\nselect_statement:\n  [IGNORE | REPLACE] [AS] SELECT ...   (Some legal select statement)\n\nDescription\n-----------\n\nUse the CREATE TABLE statement to create a table with the given name.\n\nIn its most basic form, the CREATE TABLE statement provides a table name\nfollowed by a list of columns, indexes, and constraints. By default, the table\nis created in the default database. Specify a database with db_name.tbl_name.\nIf you quote the table name, you must quote the database name and table name\nseparately as `db_name`.`tbl_name`. This is particularly useful for CREATE\nTABLE ... SELECT, because it allows to create a table into a database, which\ncontains data from other databases. See Identifier Qualifiers.\n\nIf a table with the same name exists, error 1050 results. Use IF NOT EXISTS to\nsuppress this error and issue a note instead. Use SHOW WARNINGS to see notes.\n\nThe CREATE TABLE statement automatically commits the current transaction,\nexcept when using the TEMPORARY keyword.\n\nFor valid identifiers to use as table names, see Identifier Names.\n\nNote: if the default_storage_engine is set to ColumnStore then it needs\nsetting on all UMs. Otherwise when the tables using the default engine are\nreplicated across UMs they will use the wrong engine. You should therefore not\nuse this option as a session variable with ColumnStore.\n\nMicrosecond precision can be between 0-6. If no precision is specified it is\nassumed to be 0, for backward compatibility reasons.\n\nPrivileges\n----------\n\nExecuting the CREATE TABLE statement requires the CREATE privilege for the\ntable or the database.\n\nCREATE OR REPLACE\n-----------------\n\nIf the OR REPLACE clause is used and the table already exists, then instead of\nreturning an error, the server will drop the existing table and replace it\nwith the newly defined table.\n\nThis syntax was originally added to make replication more robust if it has to\nrollback and repeat statements such as CREATE ... SELECT on replicas.\n\nCREATE OR REPLACE TABLE table_name (a int);\n\nis basically the same as:\n\nDROP TABLE IF EXISTS table_name;\nCREATE TABLE table_name (a int);\n\nwith the following exceptions:\n\n* If table_name was locked with LOCK TABLES it will continue to be locked\nafter the statement.\n* Temporary tables are only dropped if the TEMPORARY keyword was used.  (With\nDROP TABLE,  temporary tables are preferred to be dropped before normal\ntables).\n\nThings to be Aware of With CREATE OR REPLACE\n--------------------------------------------\n\n* The table is dropped first (if it existed), after that the CREATE is done.\nBecause of this, if the CREATE fails, then the table will not exist anymore\nafter the statement.  If the table was used with LOCK TABLES it will be\nunlocked.\n* One can\'t use OR REPLACE together with IF EXISTS.\n* Slaves in replication will by default use CREATE OR REPLACE when replicating\nCREATE statements that don\'\'t use IF EXISTS. This can be changed by setting\nthe variable slave-ddl-exec-mode to STRICT.\n\nCREATE TABLE IF NOT EXISTS\n--------------------------\n\nIf the IF NOT EXISTS clause is used, then the table will only be created if a\ntable with the same name does not already exist. If the table already exists,\nthen a warning will be triggered by default.\n\nCREATE TEMPORARY TABLE\n----------------------\n\nUse the TEMPORARY keyword to create a temporary table that is only available\nto the current session. Temporary tables are dropped when the session ends.\nTemporary table names are specific to the session. They will not conflict with\nother temporary tables from other sessions even if they share the same name.\nThey will shadow names of non-temporary tables or views, if they are\nidentical. A temporary table can have the same name as a non-temporary table\nwhich is located in the same database. In that case, their name will reference\nthe temporary table when used in SQL statements. You must have the CREATE\nTEMPORARY TABLES privilege on the database to create temporary tables. If no\nstorage engine is specified, the default_tmp_storage_engine setting will\ndetermine the engine.\n\nROCKSDB temporary tables cannot be created by setting the\ndefault_tmp_storage_engine system variable, or using CREATE TEMPORARY TABLE\nLIKE. Before MariaDB 10.7, they could be specified, but would silently fail,\nand a MyISAM table would be created instead. From MariaDB 10.7 an error is\nreturned. Explicitly creating a temporary table with ENGINE=ROCKSDB has never\nbeen permitted.\n\nCREATE TABLE ... LIKE\n---------------------\n\nUse the LIKE clause instead of a full table definition to create a table with\nthe same definition as another table, including columns, indexes, and table\noptions. Foreign key definitions, as well as any DATA DIRECTORY or INDEX\nDIRECTORY table options specified on the original table, will not be created.\n\nCREATE TABLE ... SELECT\n-----------------------\n\nYou can create a table containing data from other tables using the CREATE ...\nSELECT statement. Columns will be created in the table for each field returned\nby the SELECT query.\n\nYou can also define some columns normally and add other columns from a SELECT.\nYou can also create columns in the normal way and assign them some values\nusing the query, this is done to force a certain type or other field\ncharacteristics. The columns that are not named in the query will be placed\nbefore the others. For example:\n\nCREATE TABLE test (a INT NOT NULL, b CHAR(10)) ENGINE=MyISAM\n  SELECT 5 AS b, c, d FROM another_table;\n\nRemember that the query just returns data. If you want to use the same\nindexes, or the same columns attributes ([NOT] NULL, DEFAULT, AUTO_INCREMENT)\nin the new table, you need to specify them manually. Types and sizes are not\nautomatically preserved if no data returned by the SELECT requires the full\nsize, and VARCHAR could be converted into CHAR. The CAST() function can be\nused to forcee the new table to use certain types.\n\nAliases (AS) are taken into account, and they should always be used when you\nSELECT an expression (function, arithmetical operation, etc).\n\nIf an error occurs during the query, the table will not be created at all.\n\nIf the new table has a primary key or UNIQUE indexes, you can use the IGNORE\nor REPLACE keywords to handle duplicate key errors during the query. IGNORE\nmeans that the newer values must not be inserted an identical value exists in\nthe index. REPLACE means that older values must be overwritten.\n\nIf the columns in the new table are more than the rows returned by the query,\nthe columns populated by the query will be placed after other columns. Note\nthat if the strict SQL_MODE is on, and the columns that are not names in the\nquery do not have a DEFAULT value, an error will raise and no rows will be\ncopied.\n\nConcurrent inserts are not used during the execution of a CREATE ... SELECT.\n\nIf the table already exists, an error similar to the following will be\nreturned:\n\nERROR 1050 (42S01): Table \'t\' already exists\n\nIf the IF NOT EXISTS clause is used and the table exists, a note will be\nproduced instead of an error.\n\nTo insert rows from a query into an existing table, INSERT ... SELECT can be\nused.\n\nColumn Definitions\n------------------\n\ncreate_definition:\n { col_name column_definition | index_definition | period_definition | CHECK\n(expr) }\ncolumn_definition:\n data_type\n  [NOT NULL | NULL] [DEFAULT default_value | (expression)]\n  [ON UPDATE [NOW | CURRENT_TIMESTAMP] [(precision)]]\n  [AUTO_INCREMENT] [ZEROFILL] [UNIQUE [KEY] | [PRIMARY] KEY]\n  [INVISIBLE] [{WITH|WITHOUT} SYSTEM VERSIONING]\n  [COMMENT \'string\'] [REF_SYSTEM_ID = value]\n  [reference_definition]\n | data_type [GENERATED ALWAYS]\n AS { { ROW {START|END} } | { (expression) [VIRTUAL | PERSISTENT | STORED] } }\n   [UNIQUE [KEY]] [COMMENT \'string\']\nconstraint_definition:\n CONSTRAINT [constraint_name] CHECK (expression)\nNote: Until MariaDB 10.4, MariaDB accepts the shortcut format with a\nREFERENCES clause only in ALTER TABLE and CREATE TABLE statements, but that\nsyntax does nothing. For example:\n\nCREATE TABLE b(for_key INT REFERENCES a(not_key));\n\nMariaDB simply parses it without returning any error or warning, for\ncompatibility with other DBMS\'s. Before MariaDB 10.2.1 this was also true for\nCHECK constraints. However, only the syntax described below creates foreign\nkeys.\n\nFrom MariaDB 10.5, MariaDB will attempt to apply the constraint. See Foreign\nKeys examples.\n\nEach definition either creates a column in the table or specifies and index or\nconstraint on one or more columns. See Indexes below for details on creating\nindexes.\n\nCreate a column by specifying a column name and a data type, optionally\nfollowed by column options. See Data Types for a full list of data types\nallowed in MariaDB.\n\nNULL and NOT NULL\n-----------------\n\nUse the NULL or NOT NULL options to specify that values in the column may or\nmay not be NULL, respectively. By default, values may be NULL. See also NULL\nValues in MariaDB.\n\nDEFAULT Column Option\n---------------------\n\nSpecify a default value using the DEFAULT clause. If you don\'t specify DEFAULT\nthen the following rules apply:\n\n* If the column is not defined with NOT NULL, AUTO_INCREMENT or TIMESTAMP, an\nexplicit DEFAULT NULL will be added.\nNote that in MySQL and in MariaDB before 10.1.6, you may get an explicit\nDEFAULT for primary key parts, if not specified with NOT NULL.\n\nThe default value will be used if you INSERT a row without specifying a value\nfor that column, or if you specify DEFAULT for that column. Before MariaDB\n10.2.1 you couldn\'t usually provide an expression or function to evaluate at\ninsertion time. You had to provide a constant default value instead. The one\nexception is that you may use CURRENT_TIMESTAMP as the default value for a\nTIMESTAMP column to use the current timestamp at insertion time.\n\nCURRENT_TIMESTAMP may also be used as the default value for a DATETIME\n\nYou can use most functions in DEFAULT. Expressions should have parentheses\naround them. If you use a non deterministic function in DEFAULT then all\ninserts to the table will be replicated in row mode. You can even refer to\nearlier columns in the DEFAULT expression (excluding AUTO_INCREMENT columns):\n\nCREATE TABLE t1 (a int DEFAULT (1+1), b int DEFAULT (a+1));\nCREATE TABLE t2 (a bigint primary key DEFAULT UUID_SHORT());\n\nThe DEFAULT clause cannot contain any stored functions or subqueries, and a\ncolumn used in the clause must already have been defined earlier in the\nstatement.\n\nIt is possible to assign BLOB or TEXT columns a DEFAULT value. In versions\nprior to MariaDB 10.2.1, assigning a default to these columns was not possible.\n\nYou can also use DEFAULT (NEXT VALUE FOR sequence)\n\nAUTO_INCREMENT Column Option\n----------------------------\n\nUse AUTO_INCREMENT to create a column whose value can can be set automatically\nfrom a simple counter. You can only use AUTO_INCREMENT on a column with an\ninteger type. The column must be a key, and there can only be one\nAUTO_INCREMENT column in a table. If you insert a row without specifying a\nvalue for that column (or if you specify 0, NULL, or DEFAULT as the value),\nthe actual value will be taken from the counter, with each insertion\nincrementing the counter by one. You can still insert a value explicitly. If\nyou insert a value that is greater than the current counter value, the counter\nis set based on the new value. An AUTO_INCREMENT column is implicitly NOT\nNULL. Use LAST_INSERT_ID to get the AUTO_INCREMENT value most recently used by\nan INSERT statement.\n\nZEROFILL Column Option\n----------------------\n\nIf the ZEROFILL column option is specified for a column using a numeric data\ntype, then the column will be set to UNSIGNED and the spaces used by default\nto pad the field are replaced with zeros. ZEROFILL is ignored in expressions\nor as part of a UNION. ZEROFILL is a non-standard MySQL and MariaDB\nenhancement.\n\nPRIMARY KEY Column Option\n-------------------------\n\nUse PRIMARY KEY to make a column a primary key. A primary key is a special\ntype of a unique key. There can be at most one primary key per table, and it\nis implicitly NOT NULL.\n\nSpecifying a column as a unique key creates a unique index on that column. See\nthe Index Definitions section below for more information.\n\nUNIQUE KEY Column Option\n------------------------\n\nUse UNIQUE KEY (or just UNIQUE) to specify that all values in the column must\nbe distinct from each other. Unless the column is NOT NULL, there may be\nmultiple rows with NULL in the column.\n\nSpecifying a column as a unique key creates a unique index on that column.\n\nSee the Index Definitions section below for more information.\n\nCOMMENT Column Option\n---------------------\n\nYou can provide a comment for each column using the COMMENT clause. The\nmaximum length is 1024 characters. Use the SHOW FULL COLUMNS statement to see\ncolumn comments.\n\nREF_SYSTEM_ID\n-------------\n\nREF_SYSTEM_ID can be used to specify Spatial Reference System IDs for spatial\ndata type columns. For example:\n\nCREATE TABLE t1(g GEOMETRY(9,4) REF_SYSTEM_ID=101);\n\nGenerated Columns\n-----------------\n\nA generated column is a column in a table that cannot explicitly be set to a\nspecific value in a DML query. Instead, its value is automatically generated\nbased on an expression. This expression might generate the value based on the\nvalues of other columns in the table, or it might generate the value by\ncalling built-in functions or user-defined functions (UDFs).\n\nThere are two types of generated columns:\n\n* PERSISTENT or STORED: This type\'s value is actually stored in the table.\n* VIRTUAL: This type\'s value is not stored at all. Instead, the value is\ngenerated dynamically when the table is queried. This type is the default.\n\nGenerated columns are also sometimes called computed columns or virtual\ncolumns.\n\nFor a complete description about generated columns and their limitations, see\nGenerated (Virtual and Persistent/Stored) Columns.\n\nCOMPRESSED\n----------\n\nCertain columns may be compressed. See Storage-Engine Independent Column\nCompression.\n\nINVISIBLE\n---------\n\nColumns may be made invisible, and hidden in certain contexts. See Invisible\nColumns.\n\nWITH SYSTEM VERSIONING Column Option\n------------------------------------\n\nColumns may be explicitly marked as included from system versioning. See\nSystem-versioned tables for details.\n\nWITHOUT SYSTEM VERSIONING Column Option\n---------------------------------------\n\nColumns may be explicitly marked as excluded from system versioning. See\nSystem-versioned tables for details.\n\nIndex Definitions\n-----------------\n\nindex_definition:\n  {INDEX|KEY} [index_name] [index_type] (index_col_name,...) [index_option]\n...\n {{{|}}} {FULLTEXT|SPATIAL} [INDEX|KEY] [index_name] (index_col_name,...)\n[index_option] ...\n {{{|}}} [CONSTRAINT [symbol]] PRIMARY KEY [index_type] (index_col_name,...)\n[index_option] ...\n {{{|}}} [CONSTRAINT [symbol]] UNIQUE [INDEX|KEY] [index_name] [index_type]\n(index_col_name,...) [index_option] ...\n {{{|}}} [CONSTRAINT [symbol]] FOREIGN KEY [index_name] (index_col_name,...)\nreference_definition\n\nindex_col_name:\n  col_name [(length)] [ASC | DESC]\n\nindex_type:\n  USING {BTREE | HASH | RTREE}\n\nindex_option:\n  [ KEY_BLOCK_SIZE [=] value\n {{{|}}} index_type\n {{{|}}} WITH PARSER parser_name\n {{{|}}} COMMENT \'string\'\n {{{|}}} CLUSTERING={YES| NO} ]\n [ IGNORED | NOT IGNORED ]\n\nreference_definition:\n  REFERENCES tbl_name (index_col_name,...)\n   [MATCH FULL | MATCH PARTIAL | MATCH SIMPLE]\n   [ON DELETE reference_option]\n   [ON UPDATE reference_option]\n\nreference_option:\n  RESTRICT | CASCADE | SET NULL | NO ACTION\n\nINDEX and KEY are synonyms.\n\nIndex names are optional, if not specified an automatic name will be assigned.\nIndex name are needed to drop indexes and appear in error messages when a\nconstraint is violated.\n\nIndex Categories\n----------------\n\nPlain Indexes\n-------------\n\nPlain indexes are regular indexes that are not unique, and are not acting as a\nprimary key or a foreign key. They are also not the \"specialized\" FULLTEXT or\nSPATIAL indexes.\n\nSee Getting Started with Indexes: Plain Indexes for more information.\n\nPRIMARY KEY\n-----------\n\nFor PRIMARY KEY indexes, you can specify a name for the index, but it is\nignored, and the name of the index is always PRIMARY. From MariaDB 10.3.18 and\nMariaDB 10.4.8, a warning is explicitly issued if a name is specified. Before\nthen, the name was silently ignored.\n\nSee Getting Started with Indexes: Primary Key for more information.\n\nUNIQUE\n------\n\nThe UNIQUE keyword means that the index will not accept duplicated values,\nexcept for NULLs. An error will raise if you try to insert duplicate values in\na UNIQUE index.\n\nFor UNIQUE indexes, you can specify a name for the constraint, using the\nCONSTRAINT keyword. That name will be used in error messages.\n\nMariaDB starting with 10.5\n--------------------------\nUnique, if index type is not specified, is normally a BTREE index that can\nalso be used by the optimizer to find rows. If the key is longer than the max\nkey length for the used storage engine, a HASH key will be created. This\nenables MariaDB to enforce uniqueness for any type or number of columns.\n\nSee Getting Started with Indexes: Unique Index for more information.\n\nFOREIGN KEY\n-----------\n\nFor FOREIGN KEY indexes, a reference definition must be provided.\n\nFor FOREIGN KEY indexes, you can specify a name for the constraint, using the\nCONSTRAINT keyword. That name will be used in error messages.\n\nFirst, you have to specify the name of the target (parent) table and a column\nor a column list which must be indexed and whose values must match to the\nforeign key\'s values. The MATCH clause is accepted to improve the\ncompatibility with other DBMS\'s, but has no meaning in MariaDB. The ON DELETE\nand ON UPDATE clauses specify what must be done when a DELETE (or a REPLACE)\nstatements attempts to delete a referenced row from the parent table, and when\nan UPDATE statement attempts to modify the referenced foreign key columns in a\nparent table row, respectively. The following options are allowed:\n\n* RESTRICT: The delete/update operation is not performed.  The statement\nterminates with a 1451 error (SQLSTATE \'2300\').\n* NO ACTION: Synonym for RESTRICT.\n* CASCADE: The delete/update operation is performed in both tables.\n* SET NULL: The update or delete goes ahead in the parent table, and the\ncorresponding foreign key fields in the child table are set to NULL.  (They\nmust not be defined as NOT NULL for this to succeed).\n* SET DEFAULT: This option is currently implemented only for the PBXT storage\nengine, which is disabled by default and no longer maintained. It sets the\nchild table\'s foreign key fields to their DEFAULT values when the referenced\nparent table key entries are updated or deleted.\n\nIf either clause is omitted, the default behavior for the omitted clause is\nRESTRICT.\n\nSee Foreign Keys for more information.\n\nFULLTEXT\n--------\n\nUse the FULLTEXT keyword to create full-text indexes.\n\nSee Full-Text Indexes for more information.\n\nSPATIAL\n-------\n\nUse the SPATIAL keyword to create geometric indexes.\n\nSee SPATIAL INDEX for more information.\n\nIndex Options\n-------------\n\nKEY_BLOCK_SIZE Index Option\n---------------------------\n\nThe KEY_BLOCK_SIZE index option is similar to the KEY_BLOCK_SIZE table option.\n\nWith the InnoDB storage engine, if you specify a non-zero value for the\nKEY_BLOCK_SIZE table option for the whole table, then the table will\nimplicitly be created with the ROW_FORMAT table option set to COMPRESSED.\nHowever, this does not happen if you just set the KEY_BLOCK_SIZE index option\nfor one or more indexes in the table. The InnoDB storage engine ignores the\nKEY_BLOCK_SIZE index option. However, the SHOW CREATE TABLE statement may\nstill report it for the index.\n\nFor information about the KEY_BLOCK_SIZE index option, see the KEY_BLOCK_SIZE\ntable option below.\n\nIndex Types\n-----------\n\nEach storage engine supports some or all index types. See Storage Engine Index\nTypes for details on permitted index types for each storage engine.\n\nDifferent index types are optimized for different kind of operations:\n\n* BTREE is the default type, and normally is the best choice. It is supported\nby all storage engines. It can be used to compare a column\'s value with a\nvalue using the =, >, >=, <, <=, BETWEEN, and LIKE operators. BTREE can also\nbe used to find NULL values. Searches against an index prefix are possible.\n* HASH is only supported by the MEMORY storage engine. HASH indexes can only\nbe used for =, <=, and >= comparisons. It can not be used for the ORDER BY\nclause. Searches against an index prefix are not possible.\n* RTREE is the default for SPATIAL indexes, but if the storage engine does not\nsupport it BTREE can be used.\n\nIndex columns names are listed between parenthesis. After each column, a\nprefix length can be specified. If no length is specified, the whole column\nwill be indexed. ASC and DESC can be specified for compatibility with are\nDBMS\'s, but have no meaning in MariaDB.\n\nWITH PARSER Index Option\n------------------------\n\nThe WITH PARSER index option only applies to FULLTEXT indexes and contains the\nfulltext parser name. The fulltext parser must be an installed plugin.\n\nCOMMENT Index Option\n--------------------\n\nA comment of up to 1024 characters is permitted with the COMMENT index option.\n\nThe COMMENT index option allows you to specify a comment with user-readable\ntext describing what the index is for. This information is not used by the\nserver itself.\n\nCLUSTERING Index Option\n-----------------------\n\nThe CLUSTERING index option is only valid for tables using the TokuDB storage\nengine.\n\nIGNORED / NOT IGNORED\n---------------------\n\nMariaDB starting with 10.6.0\n----------------------------\nFrom MariaDB 10.6.0, indexes can be specified to be ignored by the optimizer.\nSee Ignored Indexes.\n\nPeriods\n-------\n\nperiod_definition:\n  PERIOD FOR SYSTEM_TIME (start_column_name, end_column_name)\nMariaDB supports a subset of the standard syntax for periods. At the moment\nit\'s only used for creating System-versioned tables. Both columns must be\ncreated, must be either of a TIMESTAMP(6) or BIGINT UNSIGNED type, and be\ngenerated as ROW START and ROW END accordingly. See System-versioned tables\nfor details.\n\nThe table must also have the WITH SYSTEM VERSIONING clause.\n\nConstraint Expressions\n----------------------\n\nNote: Before MariaDB 10.2.1, constraint expressions were accepted in the\nsyntax but ignored.\n\nMariaDB 10.2.1 introduced two ways to define a constraint:\n\n* CHECK(expression) given as part of a column definition.\n* CONSTRAINT [constraint_name] CHECK (expression)\n\nBefore a row is inserted or updated, all constraints are evaluated in the\norder they are defined. If any constraints fails, then the row will not be\nupdated. One can use most deterministic functions in a constraint, including\nUDFs.\n\ncreate table t1 (a int check(a>0) ,b int check (b> 0), constraint abc check\n(a>b));\n\nIf you use the second format and you don\'t give a name to the constraint, then\nthe constraint will get a auto generated name. This is done so that you can\nlater delete the constraint with ALTER TABLE DROP constraint_name.\n\nOne can disable all constraint expression checks by setting the variable\ncheck_constraint_checks to OFF. This is useful for example when loading a\ntable that violates some constraints that you want to later find and fix in\nSQL.\n\nSee CONSTRAINT for more information.\n\nTable Options\n-------------\n\nFor each individual table you create (or alter), you can set some table\noptions. The general syntax for setting options is:\n\n<OPTION_NAME> = <option_value>, [<OPTION_NAME> = <option_value> ...]\n\nThe equal sign is optional.\n\nSome options are supported by the server and can be used for all tables, no\nmatter what storage engine they use; other options can be specified for all\nstorage engines, but have a meaning only for some engines. Also, engines can\nextend CREATE TABLE with new options.\n\nIf the IGNORE_BAD_TABLE_OPTIONS SQL_MODE is enabled, wrong table options\ngenerate a warning; otherwise, they generate an error.\n\ntable_option:    \n  [STORAGE] ENGINE [=] engine_name\n | AUTO_INCREMENT [=] value\n | AVG_ROW_LENGTH [=] value\n | [DEFAULT] CHARACTER SET [=] charset_name\n | CHECKSUM [=] {0 | 1}\n | [DEFAULT] COLLATE [=] collation_name\n | COMMENT [=] \'string\'\n | CONNECTION [=] \'connect_string\'\n | DATA DIRECTORY [=] \'absolute path to directory\'\n | DELAY_KEY_WRITE [=] {0 | 1}\n | ENCRYPTED [=] {YES | NO}\n | ENCRYPTION_KEY_ID [=] value\n | IETF_QUOTES [=] {YES | NO}\n | INDEX DIRECTORY [=] \'absolute path to directory\'\n | INSERT_METHOD [=] { NO | FIRST | LAST }\n | KEY_BLOCK_SIZE [=] value\n | MAX_ROWS [=] value\n | MIN_ROWS [=] value\n | PACK_KEYS [=] {0 | 1 | DEFAULT}\n | PAGE_CHECKSUM [=] {0 | 1}\n | PAGE_COMPRESSED [=] {0 | 1}\n | PAGE_COMPRESSION_LEVEL [=] {0 .. 9}\n | PASSWORD [=] \'string\'\n | ROW_FORMAT [=] {DEFAULT|DYNAMIC|FIXED|COMPRESSED|REDUNDANT|COMPACT|PAGE}\n | SEQUENCE [=] {0|1}\n | STATS_AUTO_RECALC [=] {DEFAULT|0|1}\n | STATS_PERSISTENT [=] {DEFAULT|0|1}\n | STATS_SAMPLE_PAGES [=] {DEFAULT|value}\n | TABLESPACE tablespace_name\n | TRANSACTIONAL [=]  {0 | 1}\n | UNION [=] (tbl_name[,tbl_name]...)\n | WITH SYSTEM VERSIONING\n\n[STORAGE] ENGINE\n----------------\n\n[STORAGE] ENGINE specifies a storage engine for the table. If this option is\nnot used, the default storage engine is used instead. That is, the\ndefault_storage_engine session option value if it is set, or the value\nspecified for the --default-storage-engine mysqld startup option, or the\ndefault storage engine, InnoDB. If the specified storage engine is not\ninstalled and active, the default value will be used, unless the\nNO_ENGINE_SUBSTITUTION SQL MODE is set (default). This is only true for CREATE\nTABLE, not for ALTER TABLE. For a list of storage engines that are present in\nyour server, issue a SHOW ENGINES.\n\nAUTO_INCREMENT\n--------------\n\nAUTO_INCREMENT specifies the initial value for the AUTO_INCREMENT primary key.\nThis works for MyISAM, Aria, InnoDB, MEMORY, and ARCHIVE tables. You can\nchange this option with ALTER TABLE, but in that case the new value must be\nhigher than the highest value which is present in the AUTO_INCREMENT column.\nIf the storage engine does not support this option, you can insert (and then\ndelete) a row having the wanted value - 1 in the AUTO_INCREMENT column.\n\nAVG_ROW_LENGTH\n--------------\n\nAVG_ROW_LENGTH is the average rows size. It only applies to tables using\nMyISAM and Aria storage engines that have the ROW_FORMAT table option set to\nFIXED format.\n\nMyISAM uses MAX_ROWS and AVG_ROW_LENGTH to decide the maximum size of a table\n(default: 256TB, or the maximum file size allowed by the system).\n\n[DEFAULT] CHARACTER SET/CHARSET\n-------------------------------\n\n[DEFAULT] CHARACTER SET (or [DEFAULT] CHARSET) is used to set a default\ncharacter set for the table. This is the character set used for all columns\nwhere an explicit character set is not specified. If this option is omitted or\nDEFAULT is specified, database\'s default character set will be used. See\nSetting Character Sets and Collations for details on setting the character\nsets.\n\nCHECKSUM/TABLE_CHECKSUM\n-----------------------\n\nCHECKSUM (or TABLE_CHECKSUM) can be set to 1 to maintain a live checksum for\nall table\'s rows. This makes write operations slower, but CHECKSUM TABLE will\nbe very fast. This option is only supported for MyISAM and Aria tables.\n\n[DEFAULT] COLLATE\n-----------------\n\n[DEFAULT] COLLATE is used to set a default collation for the table. This is\nthe collation used for all columns where an explicit character set is not\nspecified. If this option is omitted or DEFAULT is specified, database\'s\ndefault option will be used. See Setting Character Sets and Collations for\ndetails on setting the collations\n\nCOMMENT\n-------\n\nCOMMENT is a comment for the table. The maximum length is 2048 characters.\nAlso used to define table parameters when creating a Spider table.\n\nCONNECTION\n----------\n\nCONNECTION is used to specify a server name or a connection string for a\nSpider, CONNECT, Federated or FederatedX table.\n\nDATA DIRECTORY/INDEX DIRECTORY\n------------------------------\n\nDATA DIRECTORY and INDEX DIRECTORY are supported for MyISAM and Aria, and DATA\nDIRECTORY is also supported by InnoDB if the innodb_file_per_table server\nsystem variable is enabled, but only in CREATE TABLE, not in ALTER TABLE. So,\ncarefully choose a path for InnoDB tables at creation time, because it cannot\nbe changed without dropping and re-creating the table. These options specify\nthe paths for data files and index files, respectively. If these options are\nomitted, the database\'s directory will be used to store data files and index\nfiles. Note that these table options do not work for partitioned tables (use\nthe partition options instead), or if the server has been invoked with the\n--skip-symbolic-links startup option. To avoid the overwriting of old files\nwith the same name that could be present in the directories, you can use the\n--keep_files_on_create option (an error will be issued if files already\nexist). These options are ignored if the NO_DIR_IN_CREATE SQL_MODE is enabled\n(useful for replication slaves). Also note that symbolic links cannot be used\nfor InnoDB tables.\n\nDATA DIRECTORY works by creating symlinks from where the table would normally\nhave been (inside the datadir) to where the option specifies. For security\nreasons, to avoid bypassing the privilege system, the server does not permit\nsymlinks inside the datadir. Therefore, DATA DIRECTORY cannot be used to\nspecify a location inside the datadir. An attempt to do so will result in an\nerror 1210 (HY000) Incorrect arguments to DATA DIRECTORY.\n\nDELAY_KEY_WRITE\n---------------\n\nDELAY_KEY_WRITE is supported by MyISAM and Aria, and can be set to 1 to speed\nup write operations. In that case, when data are modified, the indexes are not\nupdated until the table is closed. Writing the changes to the index file\naltogether can be much faster. However, note that this option is applied only\nif the delay_key_write server variable is set to \'ON\'. If it is \'OFF\' the\ndelayed index writes are always disabled, and if it is \'ALL\' the delayed index\nwrites are always used, disregarding the value of DELAY_KEY_WRITE.\n\nENCRYPTED\n---------\n\nThe ENCRYPTED table option can be used to manually set the encryption status\nof an InnoDB table. See InnoDB Encryption for more information.\n\nAria does not support the ENCRYPTED table option. See MDEV-18049.\n\nSee Data-at-Rest Encryption for more information.\n\nENCRYPTION_KEY_ID\n-----------------\n\nThe ENCRYPTION_KEY_ID table option can be used to manually set the encryption\nkey of an InnoDB table. See InnoDB Encryption for more information.\n\nAria does not support the ENCRYPTION_KEY_ID table option. See MDEV-18049.\n\nSee Data-at-Rest Encryption for more information.\n\nIETF_QUOTES\n-----------\n\nFor the CSV storage engine, the IETF_QUOTES option, when set to YES, enables\nIETF-compatible parsing of embedded quote and comma characters. Enabling this\noption for a table improves compatibility with other tools that use CSV, but\nis not compatible with MySQL CSV tables, or MariaDB CSV tables created without\nthis option. Disabled by default.\n\nINSERT_METHOD\n-------------\n\nINSERT_METHOD is only used with MERGE tables. This option determines in which\nunderlying table the new rows should be inserted. If you set it to \'NO\' (which\nis the default) no new rows can be added to the table (but you will still be\nable to perform INSERTs directly against the underlying tables). FIRST means\nthat the rows are inserted into the first table, and LAST means that thet are\ninserted into the last table.\n\nKEY_BLOCK_SIZE\n--------------\n\nKEY_BLOCK_SIZE is used to determine the size of key blocks, in bytes or\nkilobytes. However, this value is just a hint, and the storage engine could\nmodify or ignore it. If KEY_BLOCK_SIZE is set to 0, the storage engine\'s\ndefault value will be used.\n\nWith the InnoDB storage engine, if you specify a non-zero value for the\nKEY_BLOCK_SIZE table option for the whole table, then the table will\nimplicitly be created with the ROW_FORMAT table option set to COMPRESSED.\n\nMIN_ROWS/MAX_ROWS\n-----------------\n\nMIN_ROWS and MAX_ROWS let the storage engine know how many rows you are\nplanning to store as a minimum and as a maximum. These values will not be used\nas real limits, but they help the storage engine to optimize the table.\nMIN_ROWS is only used by MEMORY storage engine to decide the minimum memory\nthat is always allocated. MAX_ROWS is used to decide the minimum size for\nindexes.\n\nPACK_KEYS\n---------\n\nPACK_KEYS can be used to determine whether the indexes will be compressed. Set\nit to 1 to compress all keys. With a value of 0, compression will not be used.\nWith the DEFAULT value, only long strings will be compressed. Uncompressed\nkeys are faster.\n\nPAGE_CHECKSUM\n-------------\n\nPAGE_CHECKSUM is only applicable to Aria tables, and determines whether\nindexes and data should use page checksums for extra safety.\n\nPAGE_COMPRESSED\n---------------\n\nPAGE_COMPRESSED is used to enable InnoDB page compression for InnoDB tables.\n\nPAGE_COMPRESSION_LEVEL\n----------------------\n\nPAGE_COMPRESSION_LEVEL is used to set the compression level for InnoDB page\ncompression for InnoDB tables. The table must also have the PAGE_COMPRESSED\ntable option set to 1.\n\nValid values for PAGE_COMPRESSION_LEVEL are 1 (the best speed) through 9 (the\nbest compression), .\n\nPASSWORD\n--------\n\nPASSWORD is unused.\n\nRAID_TYPE\n---------\n\nRAID_TYPE is an obsolete option, as the raid support has been disabled since\nMySQL 5.0.\n\nROW_FORMAT\n----------\n\nThe ROW_FORMAT table option specifies the row format for the data file.\nPossible values are engine-dependent.\n\nSupported MyISAM Row Formats\n----------------------------\n\nFor MyISAM, the supported row formats are:\n\n* FIXED\n* DYNAMIC\n* COMPRESSED\n\nThe COMPRESSED row format can only be set by the myisampack command line tool.\n\nSee MyISAM Storage Formats for more information.\n\nSupported Aria Row Formats\n--------------------------\n\nFor Aria, the supported row formats are:\n\n* PAGE\n* FIXED\n* DYNAMIC.\n\nSee Aria Storage Formats for more information.\n\nSupported InnoDB Row Formats\n----------------------------\n\nFor InnoDB, the supported row formats are:\n\n* COMPACT\n* REDUNDANT\n* COMPRESSED\n* DYNAMIC.\n\nIf the ROW_FORMAT table option is set to FIXED for an InnoDB table, then the\nserver will either return an error or a warning depending on the value of the\ninnodb_strict_mode system variable. If the innodb_strict_mode system variable\nis set to OFF, then a warning is issued, and MariaDB will create the table\nusing the default row format for the specific MariaDB server version. If the\ninnodb_strict_mode system variable is set to ON, then an error will be raised.\n\nSee InnoDB Storage Formats for more information.\n\nOther Storage Engines and ROW_FORMAT\n------------------------------------\n\nOther storage engines do not support the ROW_FORMAT table option.\n\nSEQUENCE\n--------\n\nIf the table is a sequence, then it will have the SEQUENCE set to 1.\n\nSTATS_AUTO_RECALC\n-----------------\n\nSTATS_AUTO_RECALC indicates whether to automatically recalculate persistent\nstatistics (see STATS_PERSISTENT, below) for an InnoDB table. If set to 1,\nstatistics will be recalculated when more than 10% of the data has changed.\nWhen set to 0, stats will be recalculated only when an ANALYZE TABLE is run.\nIf set to DEFAULT, or left out, the value set by the innodb_stats_auto_recalc\nsystem variable applies. See InnoDB Persistent Statistics.\n\nSTATS_PERSISTENT\n----------------\n\nSTATS_PERSISTENT indicates whether the InnoDB statistics created by ANALYZE\nTABLE will remain on disk or not. It can be set to 1 (on disk), 0 (not on\ndisk, the pre-MariaDB 10 behavior), or DEFAULT (the same as leaving out the\noption), in which case the value set by the innodb_stats_persistent system\nvariable will apply. Persistent statistics stored on disk allow the statistics\nto survive server restarts, and provide better query plan stability. See\nInnoDB Persistent Statistics.\n\nSTATS_SAMPLE_PAGES\n------------------\n\nSTATS_SAMPLE_PAGES indicates how many pages are used to sample index\nstatistics. If 0 or DEFAULT, the default value, the innodb_stats_sample_pages\nvalue is used. See InnoDB Persistent Statistics.\n\nTRANSACTIONAL\n-------------\n\nTRANSACTIONAL is only applicable for Aria tables. In future Aria tables\ncreated with this option will be fully transactional, but currently this\nprovides a form of crash protection. See Aria Storage Engine for more details.\n\nUNION\n-----\n\nUNION must be specified when you create a MERGE table. This option contains a\ncomma-separated list of MyISAM tables which are accessed by the new table. The\nlist is enclosed between parenthesis. Example: UNION = (t1,t2)\n\nWITH SYSTEM VERSIONING\n----------------------\n\nWITH SYSTEM VERSIONING is used for creating System-versioned tables.\n\nPartitions\n----------\n\npartition_options:\n  PARTITION BY\n    { [LINEAR] HASH(expr)\n    | [LINEAR] KEY(column_list)\n    | RANGE(expr)\n    | LIST(expr)\n    | SYSTEM_TIME [INTERVAL time_quantity time_unit] [LIMIT num] }\n  [PARTITIONS num]\n  [SUBPARTITION BY\n    { [LINEAR] HASH(expr)\n    | [LINEAR] KEY(column_list) }\n   [SUBPARTITIONS num]\n  ]\n  [(partition_definition [, partition_definition] ...)]\npartition_definition:\n  PARTITION partition_name\n    [VALUES {LESS THAN {(expr) | MAXVALUE} | IN (value_list)}]\n    [[STORAGE] ENGINE [=] engine_name]\n    [COMMENT [=] \'comment_text\' ]\n    [DATA DIRECTORY [=] \'data_dir\']\n    [INDEX DIRECTORY [=] \'index_dir\']\n    [MAX_ROWS [=] max_number_of_rows]\n    [MIN_ROWS [=] min_number_of_rows]\n    [TABLESPACE [=] tablespace_name]\n    [NODEGROUP [=] node_group_id]\n    [(subpartition_definition [, subpartition_definition] ...)]\nsubpartition_definition:\n  SUBPARTITION logical_name\n    [[STORAGE] ENGINE [=] engine_name]\n    [COMMENT [=] \'comment_text\' ]\n    [DATA DIRECTORY [=] \'data_dir\']\n    [INDEX DIRECTORY [=] \'index_dir\']\n    [MAX_ROWS [=] max_number_of_rows]\n    [MIN_ROWS [=] min_number_of_rows]\n    [TABLESPACE [=] tablespace_name]\n    [NODEGROUP [=] node_group_id]\nIf the PARTITION BY clause is used, the table will be partitioned. A partition\nmethod must be explicitly indicated for partitions and subpartitions.\nPartition methods are:\n\n* [LINEAR] HASH creates a hash key which will be used to read and write rows.\nThe partition function can be any valid SQL expression which returns an\nINTEGER number. Thus, it is possible to use the HASH method on an integer\ncolumn, or on functions which accept integer columns as an argument. However,\nVALUES LESS THAN and VALUES IN clauses can not be used with HASH. An example:\n\nCREATE TABLE t1 (a INT, b CHAR(5), c DATETIME)\n  PARTITION BY HASH ( YEAR(c) );\n\n[LINEAR] HASH can be used for subpartitions, too.\n\n* [LINEAR] KEY is similar to HASH, but the index has an even distribution of\ndata. Also, the expression can only be a column or a list of columns. VALUES\nLESS THAN and VALUES IN clauses can not be used with KEY.\n* RANGE partitions the rows using on a range of values, using the VALUES LESS\nTHAN operator. VALUES IN is not allowed with RANGE. The partition function can\nbe any valid SQL expression which returns a single value.\n* LIST assigns partitions based on a table\'s column with a restricted set of\npossible values. It is similar to RANGE, but VALUES IN must be used for at\nleast 1 columns, and VALUES LESS THAN is disallowed.\n* SYSTEM_TIME partitioning is used for System-versioned tables to store\nhistorical data separately from current data.\n\nOnly HASH and KEY can be used for subpartitions, and they can be [LINEAR].\n\nIt is possible to define up to 1024 partitions and subpartitions.\n\nThe number of defined partitions can be optionally specified as PARTITION\ncount. This can be done to avoid specifying all partitions individually. But\nyou can also declare each individual partition and, additionally, specify a\nPARTITIONS count clause; in the case, the number of PARTITIONs must equal\ncount.\n\nAlso see Partitioning Types Overview.\n\nSequences\n---------\n\nCREATE TABLE can also be used to create a SEQUENCE. See CREATE SEQUENCE and\nSequence Overview.\n\nAtomic DDL\n----------\n\nMariaDB starting with 10.6.1\n----------------------------\nMariaDB 10.6.1 supports Atomic DDL. CREATE TABLE is atomic, except for CREATE\nOR REPLACE, which is only crash safe.\n\nExamples\n--------\n\ncreate table if not exists test (\na bigint auto_increment primary key,\nname varchar(128) charset utf8,\nkey name (name(32))\n) engine=InnoDB default charset latin1;\n\nThis example shows a couple of things:\n\n* Usage of IF NOT EXISTS; If the table already existed, it will not be\ncreated.  There will not be any error for the client, just a warning.\n* How to create a PRIMARY KEY that is automatically generated.\n* How to specify a table-specific character set and another for a column.\n* How to create an index (name) that is only partly indexed (to save space).\n\nThe following clauses will work from MariaDB 10.2.1 only.\n\nCREATE TABLE t1(\n a int DEFAULT (1+1),\n b int DEFAULT (a+1),\n expires DATETIME DEFAULT(NOW() + INTERVAL 1 YEAR),\n x BLOB DEFAULT USER()\n);\n\nURL: https://mariadb.com/kb/en/create-table/','','https://mariadb.com/kb/en/create-table/'),
(712,'CREATE FUNCTION',38,'Syntax\n------\n\nCREATE [OR REPLACE]\n  [DEFINER = {user | CURRENT_USER | role | CURRENT_ROLE }]\n  [AGGREGATE] FUNCTION [IF NOT EXISTS] func_name ([func_parameter[,...]])\n  RETURNS type\n  [characteristic ...]\n  RETURN func_body\nfunc_parameter:\n  [ IN | OUT | INOUT | IN OUT ]  param_name type\ntype:\n  Any valid MariaDB data type\ncharacteristic:\n  LANGUAGE SQL\n | [NOT] DETERMINISTIC\n | { CONTAINS SQL | NO SQL | READS SQL DATA | MODIFIES SQL DATA }\n | SQL SECURITY { DEFINER | INVOKER }\n | COMMENT \'string\'\nfunc_body:\n  Valid SQL procedure statement\n\nDescription\n-----------\n\nUse the CREATE FUNCTION statement to create a new stored function. You must\nhave the CREATE ROUTINE database privilege to use CREATE FUNCTION. A function\ntakes any number of arguments and returns a value from the function body. The\nfunction body can be any valid SQL expression as you would use, for example,\nin any select expression. If you have the appropriate privileges, you can call\nthe function exactly as you would any built-in function. See Security below\nfor details on privileges.\n\nYou can also use a variant of the CREATE FUNCTION statement to install a\nuser-defined function (UDF) defined by a plugin. See CREATE FUNCTION (UDF) for\ndetails.\n\nYou can use a SELECT statement for the function body by enclosing it in\nparentheses, exactly as you would to use a subselect for any other expression.\nThe SELECT statement must return a single value. If more than one column is\nreturned when the function is called, error 1241 results. If more than one row\nis returned when the function is called, error 1242 results. Use a LIMIT\nclause to ensure only one row is returned.\n\nYou can also replace the RETURN clause with a BEGIN...END compound statement.\nThe compound statement must contain a RETURN statement. When the function is\ncalled, the RETURN statement immediately returns its result, and any\nstatements after RETURN are effectively ignored.\n\nBy default, a function is associated with the current database. To associate\nthe function explicitly with a given database, specify the fully-qualified\nname as db_name.func_name when you create it. If the function name is the same\nas the name of a built-in function, you must use the fully qualified name when\nyou call it.\n\nThe parameter list enclosed within parentheses must always be present. If\nthere are no parameters, an empty parameter list of () should be used.\nParameter names are not case sensitive.\n\nEach parameter can be declared to use any valid data type, except that the\nCOLLATE attribute cannot be used.\n\nFor valid identifiers to use as function names, see Identifier Names.\n\nIN | OUT | INOUT | IN OUT\n-------------------------\n\nMariaDB starting with 10.8.0\n----------------------------\nThe function parameter qualifiers for IN, OUT, INOUT, and IN OUT were added in\na 10.8.0 preview release. Prior to 10.8.0 quantifiers were supported only in\nprocedures.\n\nOUT, INOUT and its equivalent IN OUT, are only valid if called from SET and\nnot SELECT. These quantifiers are especially useful for creating functions\nwith more than one return value. This allows functions to be more complex and\nnested.\n\nDELIMITER $$\nCREATE FUNCTION add_func3(IN a INT, IN b INT, OUT c INT) RETURNS INT\nBEGIN\n SET c = 100;\n RETURN a + b;\nEND;\n$$\nDELIMITER ;\n\nSET @a = 2;\nSET @b = 3;\nSET @c = 0;\nSET @res= add_func3(@a, @b, @c);\n\nSELECT add_func3(@a, @b, @c);\nERROR 4186 (HY000): OUT or INOUT argument 3 for function add_func3 is not\nallowed here\n\nDELIMITER $$\nCREATE FUNCTION add_func4(IN a INT, IN b INT, d INT) RETURNS INT\nBEGIN\n DECLARE c, res INT;\n SET res = add_func3(a, b, c) + d;\n if (c > 99) then\n  return  3;\n else\n  return res;\n end if;\nEND;\n$$\n\nDELIMITER ;\n\nSELECT add_func4(1,2,3);\n+------------------+\n| add_func4(1,2,3) |\n+------------------+\n|                3 |\n+------------------+\n\nAGGREGATE\n---------\n\nIt is possible to create stored aggregate functions as well. See Stored\nAggregate Functions for details.\n\nRETURNS\n-------\n\nThe RETURNS clause specifies the return type of the function. NULL values are\npermitted with all return types.\n\nWhat happens if the RETURN clause returns a value of a different type? It\ndepends on the SQL_MODE in effect at the moment of the function creation.\n\nIf the SQL_MODE is strict (STRICT_ALL_TABLES or STRICT_TRANS_TABLES flags are\nspecified), a 1366 error will be produced.\n\nOtherwise, the value is coerced to the proper type. For example, if a function\nspecifies an ENUM or SET value in the RETURNS clause, but the RETURN clause\nreturns an integer, the value returned from the function is the string for the\ncorresponding ENUM member of set of SET members.\n\nMariaDB stores the SQL_MODE system variable setting that is in effect at the\ntime a routine is created, and always executes the routine with this setting\nin force, regardless of the server SQL mode in effect when the routine is\ninvoked.\n\nLANGUAGE SQL\n------------\n\nLANGUAGE SQL is a standard SQL clause, and it can be used in MariaDB for\nportability. However that clause has no meaning, because SQL is the only\nsupported language for stored functions.\n\nA function is deterministic if it can produce only one result for a given list\nof parameters. If the result may be affected by stored data, server variables,\nrandom numbers or any value that is not explicitly passed, then the function\nis not deterministic. Also, a function is non-deterministic if it uses\nnon-deterministic functions like NOW() or CURRENT_TIMESTAMP(). The optimizer\nmay choose a faster execution plan if it known that the function is\ndeterministic. In such cases, you should declare the routine using the\nDETERMINISTIC keyword. If you want to explicitly state that the function is\nnot deterministic (which is the default) you can use the NOT DETERMINISTIC\nkeywords.\n\nIf you declare a non-deterministic function as DETERMINISTIC, you may get\nincorrect results. If you declare a deterministic function as NOT\nDETERMINISTIC, in some cases the queries will be slower.\n\nOR REPLACE\n----------\n\nIf the optional OR REPLACE clause is used, it acts as a shortcut for:\n\nDROP FUNCTION IF EXISTS function_name;\nCREATE FUNCTION function_name ...;\n\nwith the exception that any existing privileges for the function are not\ndropped.\n\nIF NOT EXISTS\n-------------\n\nIf the IF NOT EXISTS clause is used, MariaDB will return a warning instead of\nan error if the function already exists. Cannot be used together with OR\nREPLACE.\n\n[NOT] DETERMINISTIC\n-------------------\n\nThe [NOT] DETERMINISTIC clause also affects binary logging, because the\nSTATEMENT format can not be used to store or replicate non-deterministic\nstatements.\n\nCONTAINS SQL, NO SQL, READS SQL DATA, and MODIFIES SQL DATA are informative\nclauses that tell the server what the function does. MariaDB does not check in\nany way whether the specified clause is correct. If none of these clauses are\nspecified, CONTAINS SQL is used by default.\n\nMODIFIES SQL DATA\n-----------------\n\nMODIFIES SQL DATA means that the function contains statements that may modify\ndata stored in databases. This happens if the function contains statements\nlike DELETE, UPDATE, INSERT, REPLACE or DDL.\n\nREADS SQL DATA\n--------------\n\nREADS SQL DATA means that the function reads data stored in databases, but\ndoes not modify any data. This happens if SELECT statements are used, but\nthere no write operations are executed.\n\nCONTAINS SQL\n------------\n\nCONTAINS SQL means that the function contains at least one SQL statement, but\nit does not read or write any data stored in a database. Examples include SET\nor DO.\n\nNO SQL\n------\n\nNO SQL means nothing, because MariaDB does not currently support any language\nother than SQL.\n\nOracle Mode\n-----------\n\nA subset of Oracle\'s PL/SQL language is supported in addition to the\ntraditional SQL/PSM-based MariaDB syntax. See Oracle mode for details on\nchanges when running Oracle mode.\n\nSecurity\n--------\n\nYou must have the EXECUTE privilege on a function to call it. MariaDB\nautomatically grants the EXECUTE and ALTER ROUTINE privileges to the account\nthat called CREATE FUNCTION, even if the DEFINER clause was used.\n\nEach function has an account associated as the definer. By default, the\ndefiner is the account that created the function. Use the DEFINER clause to\nspecify a different account as the definer. You must have the SUPER privilege,\nor, from MariaDB 10.5.2, the SET USER privilege, to use the DEFINER clause.\nSee Account Names for details on specifying accounts.\n\nThe SQL SECURITY clause specifies what privileges are used when a function is\ncalled. If SQL SECURITY is INVOKER, the function body will be evaluated using\nthe privileges of the user calling the function. If SQL SECURITY is DEFINER,\nthe function body is always evaluated using the privileges of the definer\naccount. DEFINER is the default.\n\nThis allows you to create functions that grant limited access to certain data.\nFor example, say you have a table that stores some employee information, and\nthat you\'ve granted SELECT privileges only on certain columns to the user\naccount roger.\n\nCREATE TABLE employees (name TINYTEXT, dept TINYTEXT, salary INT);\nGRANT SELECT (name, dept) ON employees TO roger;\n\nTo allow the user the get the maximum salary for a department, define a\nfunction and grant the EXECUTE privilege:\n\nCREATE FUNCTION max_salary (dept TINYTEXT) RETURNS INT RETURN\n (SELECT MAX(salary) FROM employees WHERE employees.dept = dept);\nGRANT EXECUTE ON FUNCTION max_salary TO roger;\n\nSince SQL SECURITY defaults to DEFINER, whenever the user roger calls this\nfunction, the subselect will execute with your privileges. As long as you have\nprivileges to select the salary of each employee, the caller of the function\nwill be able to get the maximum salary for each department without being able\nto see individual salaries.\n\nCharacter sets and collations\n-----------------------------\n\nFunction return types can be declared to use any valid character set and\ncollation. If used, the COLLATE attribute needs to be preceded by a CHARACTER\nSET attribute.\n\nIf the character set and collation are not specifically set in the statement,\nthe database defaults at the time of creation will be used. If the database\ndefaults change at a later stage, the stored function character set/collation\nwill not be changed at the same time; the stored function needs to be dropped\nand recreated to ensure the same character set/collation as the database is\nused.\n\nExamples\n--------\n\nThe following example function takes a parameter, performs an operation using\nan SQL function, and returns the result.\n\nCREATE FUNCTION hello (s CHAR(20))\n  RETURNS CHAR(50) DETERMINISTIC\n  RETURN CONCAT(\'Hello, \',s,\'!\');\n\nSELECT hello(\'world\');\n+----------------+\n| hello(\'world\') |\n+----------------+\n| Hello, world!  |\n+----------------+\n\nYou can use a compound statement in a function to manipulate data with\nstatements like INSERT and UPDATE. The following example creates a counter\nfunction that uses a temporary table to store the current value. Because the\ncompound statement contains statements terminated with semicolons, you have to\nfirst change the statement delimiter with the DELIMITER statement to allow the\nsemicolon to be used in the function body. See Delimiters in the mariadb\nclient for more.\n\nCREATE TEMPORARY TABLE counter (c INT);\nINSERT INTO counter VALUES (0);\nDELIMITER //\nCREATE FUNCTION counter () RETURNS INT\n BEGIN\n  UPDATE counter SET c = c + 1;\n  RETURN (SELECT c FROM counter LIMIT 1);\n END //\nDELIMITER ;\n\nCharacter set and collation:\n\nCREATE FUNCTION hello2 (s CHAR(20))\n RETURNS CHAR(50) CHARACTER SET \'utf8\' COLLATE \'utf8_bin\' DETERMINISTIC\n RETURN CONCAT(\'Hello, \',s,\'!\');\n\nURL: https://mariadb.com/kb/en/create-function/','','https://mariadb.com/kb/en/create-function/'),
(716,'CREATE PROCEDURE',38,'Syntax\n------\n\nCREATE\n  [OR REPLACE]\n  [DEFINER = { user | CURRENT_USER | role | CURRENT_ROLE }]\n  PROCEDURE [IF NOT EXISTS] sp_name ([proc_parameter[,...]])\n  [characteristic ...] routine_body\n\nproc_parameter:\n  [ IN | OUT | INOUT ] param_name type\n\ntype:\n  Any valid MariaDB data type\n\ncharacteristic:\n  LANGUAGE SQL\n | [NOT] DETERMINISTIC\n | { CONTAINS SQL | NO SQL | READS SQL DATA | MODIFIES SQL DATA }\n | SQL SECURITY { DEFINER | INVOKER }\n | COMMENT \'string\'\n\nroutine_body:\n  Valid SQL procedure statement\n\nDescription\n-----------\n\nCreates a stored procedure. By default, a routine is associated with the\ndefault database. To associate the routine explicitly with a given database,\nspecify the name as db_name.sp_name when you create it.\n\nWhen the routine is invoked, an implicit USE db_name is performed (and undone\nwhen the routine terminates). The causes the routine to have the given default\ndatabase while it executes. USE statements within stored routines are\ndisallowed.\n\nWhen a stored procedure has been created, you invoke it by using the CALL\nstatement (see CALL).\n\nTo execute the CREATE PROCEDURE statement, it is necessary to have the CREATE\nROUTINE privilege. By default, MariaDB automatically grants the ALTER ROUTINE\nand EXECUTE privileges to the routine creator. See also Stored Routine\nPrivileges.\n\nThe DEFINER and SQL SECURITY clauses specify the security context to be used\nwhen checking access privileges at routine execution time, as described here.\nRequires the SUPER privilege, or, from MariaDB 10.5.2, the SET USER privilege.\n\nIf the routine name is the same as the name of a built-in SQL function, you\nmust use a space between the name and the following parenthesis when defining\nthe routine, or a syntax error occurs. This is also true when you invoke the\nroutine later. For this reason, we suggest that it is better to avoid re-using\nthe names of existing SQL functions for your own stored routines.\n\nThe IGNORE_SPACE SQL mode applies to built-in functions, not to stored\nroutines. It is always allowable to have spaces after a routine name,\nregardless of whether IGNORE_SPACE is enabled.\n\nThe parameter list enclosed within parentheses must always be present. If\nthere are no parameters, an empty parameter list of () should be used.\nParameter names are not case sensitive.\n\nEach parameter can be declared to use any valid data type, except that the\nCOLLATE attribute cannot be used.\n\nFor valid identifiers to use as procedure names, see Identifier Names.\n\nThings to be Aware of With CREATE OR REPLACE\n--------------------------------------------\n\n* One can\'t use OR REPLACE together with IF EXISTS.\n\nCREATE PROCEDURE IF NOT EXISTS\n------------------------------\n\nIf the IF NOT EXISTS clause is used, then the procedure will only be created\nif a procedure with the same name does not already exist. If the procedure\nalready exists, then a warning will be triggered by default.\n\nIN/OUT/INOUT\n------------\n\nEach parameter is an IN parameter by default. To specify otherwise for a\nparameter, use the keyword OUT or INOUT before the parameter name.\n\nAn IN parameter passes a value into a procedure. The procedure might modify\nthe value, but the modification is not visible to the caller when the\nprocedure returns. An OUT parameter passes a value from the procedure back to\nthe caller. Its initial value is NULL within the procedure, and its value is\nvisible to the caller when the procedure returns. An INOUT parameter is\ninitialized by the caller, can be modified by the procedure, and any change\nmade by the procedure is visible to the caller when the procedure returns.\n\nFor each OUT or INOUT parameter, pass a user-defined variable in the CALL\nstatement that invokes the procedure so that you can obtain its value when the\nprocedure returns. If you are calling the procedure from within another stored\nprocedure or function, you can also pass a routine parameter or local routine\nvariable as an IN or INOUT parameter.\n\nDETERMINISTIC/NOT DETERMINISTIC\n-------------------------------\n\nDETERMINISTIC and NOT DETERMINISTIC apply only to functions. Specifying\nDETERMINISTC or NON-DETERMINISTIC in procedures has no effect. The default\nvalue is NOT DETERMINISTIC. Functions are DETERMINISTIC when they always\nreturn the same value for the same input. For example, a truncate or substring\nfunction. Any function involving data, therefore, is always NOT DETERMINISTIC.\n\nCONTAINS SQL/NO SQL/READS SQL DATA/MODIFIES SQL DATA\n----------------------------------------------------\n\nCONTAINS SQL, NO SQL, READS SQL DATA, and MODIFIES SQL DATA are informative\nclauses that tell the server what the function does. MariaDB does not check in\nany way whether the specified clause is correct. If none of these clauses are\nspecified, CONTAINS SQL is used by default.\n\nMODIFIES SQL DATA means that the function contains statements that may modify\ndata stored in databases. This happens if the function contains statements\nlike DELETE, UPDATE, INSERT, REPLACE or DDL.\n\nREADS SQL DATA means that the function reads data stored in databases, but\ndoes not modify any data. This happens if SELECT statements are used, but\nthere no write operations are executed.\n\nCONTAINS SQL means that the function contains at least one SQL statement, but\nit does not read or write any data stored in a database. Examples include SET\nor DO.\n\nNO SQL means nothing, because MariaDB does not currently support any language\nother than SQL.\n\nThe routine_body consists of a valid SQL procedure statement. This can be a\nsimple statement such as SELECT or INSERT, or it can be a compound statement\nwritten using BEGIN and END. Compound statements can contain declarations,\nloops, and other control structure statements. See Programmatic and Compound\nStatements for syntax details.\n\nMariaDB allows routines to contain DDL statements, such as CREATE and DROP.\nMariaDB also allows stored procedures (but not stored functions) to contain\nSQL transaction statements such as COMMIT.\n\nFor additional information about statements that are not allowed in stored\nroutines, see Stored Routine Limitations.\n\nInvoking stored procedure from within programs\n----------------------------------------------\n\nFor information about invoking stored procedures from within programs written\nin a language that has a MariaDB/MySQL interface, see CALL.\n\nOR REPLACE\n----------\n\nIf the optional OR REPLACE clause is used, it acts as a shortcut for:\n\nDROP PROCEDURE IF EXISTS name;\nCREATE PROCEDURE name ...;\n\nwith the exception that any existing privileges for the procedure are not\ndropped.\n\nsql_mode\n--------\n\nMariaDB stores the sql_mode system variable setting that is in effect at the\ntime a routine is created, and always executes the routine with this setting\nin force, regardless of the server SQL mode in effect when the routine is\ninvoked.\n\nCharacter Sets and Collations\n-----------------------------\n\nProcedure parameters can be declared with any character set/collation. If the\ncharacter set and collation are not specifically set, the database defaults at\nthe time of creation will be used. If the database defaults change at a later\nstage, the stored procedure character set/collation will not be changed at the\nsame time; the stored procedure needs to be dropped and recreated to ensure\nthe same character set/collation as the database is used.\n\nOracle Mode\n-----------\n\nA subset of Oracle\'s PL/SQL language is supported in addition to the\ntraditional SQL/PSM-based MariaDB syntax. See Oracle mode for details on\nchanges when running Oracle mode.\n\nExamples\n--------\n\nThe following example shows a simple stored procedure that uses an OUT\nparameter. It uses the DELIMITER command to set a new delimiter for the\nduration of the process — see Delimiters in the mariadb client.\n\nDELIMITER //\n\nCREATE PROCEDURE simpleproc (OUT param1 INT)\n BEGIN\n SELECT COUNT(*) INTO param1 FROM t;\n END;\n//\n\nDELIMITER ;\n\nCALL simpleproc(@a);\n\nSELECT @a;\n+------+\n| @a   |\n+------+\n|    1 |\n+------+\n\nCharacter set and collation:\n\nDELIMITER //\n\nCREATE PROCEDURE simpleproc2 (\n OUT param1 CHAR(10) CHARACTER SET \'utf8\' COLLATE \'utf8_bin\'\n)\n BEGIN\n SELECT CONCAT(\'a\'),f1 INTO param1 FROM t;\n END;\n//\n\nDELIMITER ;\n\nCREATE OR REPLACE:\n\nDELIMITER //\n\nCREATE PROCEDURE simpleproc2 (\n OUT param1 CHAR(10) CHARACTER SET \'utf8\' COLLATE \'utf8_bin\'\n)\n BEGIN\n SELECT CONCAT(\'a\'),f1 INTO param1 FROM t;\n END;\n//\nERROR 1304 (42000): PROCEDURE simpleproc2 already exists\n\nDELIMITER ;\n\nDELIMITER //\n\nCREATE OR REPLACE PROCEDURE simpleproc2 (\n OUT param1 CHAR(10) CHARACTER SET \'utf8\' COLLATE \'utf8_bin\'\n)\n BEGIN\n SELECT CONCAT(\'a\'),f1 INTO param1 FROM t;\n END;\n//\nERROR 1304 (42000): PROCEDURE simpleproc2 already exists\n\nDELIMITER ;\nQuery OK, 0 rows affected (0.03 sec)\n\nURL: https://mariadb.com/kb/en/create-procedure/','','https://mariadb.com/kb/en/create-procedure/'),
(718,'CREATE TABLESPACE',38,'The CREATE TABLESPACE statement is not supported by MariaDB. It was originally\ninherited from MySQL NDB Cluster. In MySQL 5.7 and later, the statement is\nalso supported for InnoDB. However, MariaDB has chosen not to include that\nspecific feature. See MDEV-19294 for more information.\n\nURL: https://mariadb.com/kb/en/create-tablespace/','','https://mariadb.com/kb/en/create-tablespace/'),
(720,'CREATE VIEW',38,'Syntax\n------\n\nCREATE\n  [OR REPLACE]\n  [ALGORITHM = {UNDEFINED | MERGE | TEMPTABLE}]\n  [DEFINER = { user | CURRENT_USER | role | CURRENT_ROLE }]\n  [SQL SECURITY { DEFINER | INVOKER }]\n  VIEW [IF NOT EXISTS] view_name [(column_list)]\n  AS select_statement\n  [WITH [CASCADED | LOCAL] CHECK OPTION]\n\nDescription\n-----------\n\nThe CREATE VIEW statement creates a new view, or replaces an existing one if\nthe OR REPLACE clause is given. If the view does not exist, CREATE OR REPLACE\nVIEW is the same as CREATE VIEW. If the view does exist, CREATE OR REPLACE\nVIEW is the same as ALTER VIEW.\n\nThe select_statement is a SELECT statement that provides the definition of the\nview. (When you select from the view, you select in effect using the SELECT\nstatement.) select_statement can select from base tables or other views.\n\nThe view definition is \"frozen\" at creation time, so changes to the underlying\ntables afterwards do not affect the view definition. For example, if a view is\ndefined as SELECT * on a table, new columns added to the table later do not\nbecome part of the view. A SHOW CREATE VIEW shows that such queries are\nrewritten and column names are included in the view definition.\n\nThe view definition must be a query that does not return errors at view\ncreation times. However, the base tables used by the views might be altered\nlater and the query may not be valid anymore. In this case, querying the view\nwill result in an error. CHECK TABLE helps in finding this kind of problems.\n\nThe ALGORITHM clause affects how MariaDB processes the view. The DEFINER and\nSQL SECURITY clauses specify the security context to be used when checking\naccess privileges at view invocation time. The WITH CHECK OPTION clause can be\ngiven to constrain inserts or updates to rows in tables referenced by the\nview. These clauses are described later in this section.\n\nThe CREATE VIEW statement requires the CREATE VIEW privilege for the view, and\nsome privilege for each column selected by the SELECT statement. For columns\nused elsewhere in the SELECT statement you must have the SELECT privilege. If\nthe OR REPLACE clause is present, you must also have the DROP privilege for\nthe view.\n\nA view belongs to a database. By default, a new view is created in the default\ndatabase. To create the view explicitly in a given database, specify the name\nas db_name.view_name when you create it.\n\nCREATE VIEW test.v AS SELECT * FROM t;\n\nBase tables and views share the same namespace within a database, so a\ndatabase cannot contain a base table and a view that have the same name.\n\nViews must have unique column names with no duplicates, just like base tables.\nBy default, the names of the columns retrieved by the SELECT statement are\nused for the view column names. To define explicit names for the view columns,\nthe optional column_list clause can be given as a list of comma-separated\nidentifiers. The number of names in column_list must be the same as the number\nof columns retrieved by the SELECT statement.\n\nMySQL until 5.1.28\n------------------\nPrior to MySQL 5.1.29, When you modify an existing view, the current view\ndefinition is backed up and saved. It is stored in that table\'s database\ndirectory, in a subdirectory named arc. The backup file for a view v is named\nv.frm-00001. If you alter the view again, the next backup is named\nv.frm-00002. The three latest view backup definitions are stored. Backed up\nview definitions are not preserved by mysqldump, or any other such programs,\nbut you can retain them using a file copy operation. However, they are not\nneeded for anything but to provide you with a backup of your previous view\ndefinition. It is safe to remove these backup definitions, but only while\nmysqld is not running. If you delete the arc subdirectory or its files while\nmysqld is running, you will receive an error the next time you try to alter\nthe view:\n\nMariaDB [test]> ALTER VIEW v AS SELECT * FROM t; \nERROR 6 (HY000): Error on delete of \'.\\test\\arc/v.frm-0004\' (Errcode: 2)\n\nColumns retrieved by the SELECT statement can be simple references to table\ncolumns. They can also be expressions that use functions, constant values,\noperators, and so forth.\n\nUnqualified table or view names in the SELECT statement are interpreted with\nrespect to the default database. A view can refer to tables or views in other\ndatabases by qualifying the table or view name with the proper database name.\n\nA view can be created from many kinds of SELECT statements. It can refer to\nbase tables or other views. It can use joins, UNION, and subqueries. The\nSELECT need not even refer to any tables. The following example defines a view\nthat selects two columns from another table, as well as an expression\ncalculated from those columns:\n\nCREATE TABLE t (qty INT, price INT);\n\nINSERT INTO t VALUES(3, 50);\n\nCREATE VIEW v AS SELECT qty, price, qty*price AS value FROM t;\n\nSELECT * FROM v;\n+------+-------+-------+\n| qty  | price | value |\n+------+-------+-------+\n|    3 |    50 |   150 |\n+------+-------+-------+\n\nA view definition is subject to the following restrictions:\n\n* The SELECT statement cannot contain a subquery in the FROM clause.\n* The SELECT statement cannot refer to system or user variables.\n* Within a stored program, the definition cannot refer to program parameters\nor local variables.\n* The SELECT statement cannot refer to prepared statement parameters.\n* Any table or view referred to in the definition must exist. However, after a\nview has been created, it is possible to drop a table or view that the\ndefinition refers to. In this case, use of the view results in an error. To\ncheck a view definition for problems of this kind, use the CHECK TABLE\nstatement.\n* The definition cannot refer to a TEMPORARY table, and you cannot create a\nTEMPORARY view.\n* Any tables named in the view definition must exist at definition time.\n* You cannot associate a trigger with a view.\n* For valid identifiers to use as view names, see Identifier Names.\n\nORDER BY is allowed in a view definition, but it is ignored if you select from\na view using a statement that has its own ORDER BY.\n\nFor other options or clauses in the definition, they are added to the options\nor clauses of the statement that references the view, but the effect is\nundefined. For example, if a view definition includes a LIMIT clause, and you\nselect from the view using a statement that has its own LIMIT clause, it is\nundefined which limit applies. This same principle applies to options such as\nALL, DISTINCT, or SQL_SMALL_RESULT that follow the SELECT keyword, and to\nclauses such as INTO, FOR UPDATE, and LOCK IN SHARE MODE.\n\nThe PROCEDURE clause cannot be used in a view definition, and it cannot be\nused if a view is referenced in the FROM clause.\n\nIf you create a view and then change the query processing environment by\nchanging system variables, that may affect the results that you get from the\nview:\n\nCREATE VIEW v (mycol) AS SELECT \'abc\';\n\nSET sql_mode = \'\';\n\nSELECT \"mycol\" FROM v;\n+-------+\n| mycol |\n+-------+\n| mycol | \n+-------+\n\nSET sql_mode = \'ANSI_QUOTES\';\n\nSELECT \"mycol\" FROM v;\n+-------+\n| mycol |\n+-------+\n| abc   | \n+-------+\n\nThe DEFINER and SQL SECURITY clauses determine which MariaDB account to use\nwhen checking access privileges for the view when a statement is executed that\nreferences the view. They were added in MySQL 5.1.2. The legal SQL SECURITY\ncharacteristic values are DEFINER and INVOKER. These indicate that the\nrequired privileges must be held by the user who defined or invoked the view,\nrespectively. The default SQL SECURITY value is DEFINER.\n\nIf a user value is given for the DEFINER clause, it should be a MariaDB\naccount in \'user_name\'@\'host_name\' format (the same format used in the GRANT\nstatement). The user_name and host_name values both are required. The definer\ncan also be given as CURRENT_USER or CURRENT_USER(). The default DEFINER value\nis the user who executes the CREATE VIEW statement. This is the same as\nspecifying DEFINER = CURRENT_USER explicitly.\n\nIf you specify the DEFINER clause, these rules determine the legal DEFINER\nuser values:\n\n* If you do not have the SUPER privilege, or, from MariaDB 10.5.2, the SET\nUSER privilege, the only legal user value is your own account, either\nspecified literally or by using CURRENT_USER. You cannot set the definer to\nsome other account.\n* If you have the SUPER privilege, or, from MariaDB 10.5.2, the SET USER\nprivilege, you can specify any syntactically legal account name. If the\naccount does not actually exist, a warning is generated.\n* If the SQL SECURITY value is DEFINER but the definer account does not exist\nwhen the view is referenced, an error occurs.\n\nWithin a view definition, CURRENT_USER returns the view\'s DEFINER value by\ndefault. For views defined with the SQL SECURITY INVOKER characteristic,\nCURRENT_USER returns the account for the view\'s invoker. For information about\nuser auditing within views, see\nhttp://dev.mysql.com/doc/refman/5.1/en/account-activity-auditing.html.\n\nWithin a stored routine that is defined with the SQL SECURITY DEFINER\ncharacteristic, CURRENT_USER returns the routine\'s DEFINER value. This also\naffects a view defined within such a program, if the view definition contains\na DEFINER value of CURRENT_USER.\n\nView privileges are checked like this:\n\n* At view definition time, the view creator must have the privileges needed to\nuse the top-level objects accessed by the view. For example, if the view\ndefinition refers to table columns, the creator must have privileges for the\ncolumns, as described previously. If the definition refers to a stored\nfunction, only the privileges needed to invoke the function can be checked.\nThe privileges required when the function runs can be checked only as it\nexecutes: For different invocations of the function, different execution paths\nwithin the function might be taken.\n* When a view is referenced, privileges for objects accessed by the view are\nchecked against the privileges held by the view creator or invoker, depending\non whether the SQL SECURITY characteristic is DEFINER or INVOKER, respectively.\n* If reference to a view causes execution of a stored function, privilege\nchecking for statements executed within the function depend on whether the\nfunction is defined with a SQL SECURITY characteristic of DEFINER or INVOKER.\nIf the security characteristic is DEFINER, the function runs with the\nprivileges of its creator. If the characteristic is INVOKER, the function runs\nwith the privileges determined by the view\'s SQL SECURITY characteristic.\n\nExample: A view might depend on a stored function, and that function might\ninvoke other stored routines. For example, the following view invokes a stored\nfunction f():\n\nCREATE VIEW v AS SELECT * FROM t WHERE t.id = f(t.name);\n\nSuppose that f() contains a statement such as this:\n\nIF name IS NULL then\n CALL p1();\nELSE\n CALL p2();\nEND IF;\n\nThe privileges required for executing statements within f() need to be checked\nwhen f() executes. This might mean that privileges are needed for p1() or\np2(), depending on the execution path within f(). Those privileges must be\nchecked at runtime, and the user who must possess the privileges is determined\nby the SQL SECURITY values of the view v and the function f().\n\nThe DEFINER and SQL SECURITY clauses for views are extensions to standard SQL.\nIn standard SQL, views are handled using the rules for SQL SECURITY INVOKER.\n\nIf you invoke a view that was created before MySQL 5.1.2, it is treated as\nthough it was created with a SQL SECURITY DEFINER clause and with a DEFINER\nvalue that is the same as your account. However, because the actual definer is\nunknown, MySQL issues a warning. To make the warning go away, it is sufficient\nto re-create the view so that the view definition includes a DEFINER clause.\n\nThe optional ALGORITHM clause is an extension to standard SQL. It affects how\nMariaDB processes the view. ALGORITHM takes three values: MERGE, TEMPTABLE, or\nUNDEFINED. The default algorithm is UNDEFINED if no ALGORITHM clause is\npresent. See View Algorithms for more information.\n\nSome views are updatable. That is, you can use them in statements such as\nUPDATE, DELETE, or INSERT to update the contents of the underlying table. For\na view to be updatable, there must be a one-to-one relationship between the\nrows in the view and the rows in the underlying table. There are also certain\nother constructs that make a view non-updatable. See Inserting and Updating\nwith Views.\n\nWITH CHECK OPTION\n-----------------\n\nThe WITH CHECK OPTION clause can be given for an updatable view to prevent\ninserts or updates to rows except those for which the WHERE clause in the\nselect_statement is true.\n\nIn a WITH CHECK OPTION clause for an updatable view, the LOCAL and CASCADED\nkeywords determine the scope of check testing when the view is defined in\nterms of another view. The LOCAL keyword restricts the CHECK OPTION only to\nthe view being defined. CASCADED causes the checks for underlying views to be\nevaluated as well. When neither keyword is given, the default is CASCADED.\n\nFor more information about updatable views and the WITH CHECK OPTION clause,\nsee Inserting and Updating with Views.\n\nIF NOT EXISTS\n-------------\n\nMariaDB starting with 10.1.3\n----------------------------\nThe IF NOT EXISTS clause was added in MariaDB 10.1.3\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a warning instead\nof an error if the specified view already exists. Cannot be used together with\nthe OR REPLACE clause.\n\nAtomic DDL\n----------\n\nMariaDB starting with 10.6.1\n----------------------------\nMariaDB 10.6.1 supports Atomic DDL and CREATE VIEW is atomic.\n\nExamples\n--------\n\nCREATE TABLE t (a INT, b INT) ENGINE = InnoDB;\n\nINSERT INTO t VALUES (1,1), (2,2), (3,3);\n\nCREATE VIEW v AS SELECT a, a*2 AS a2 FROM t;\n\nSELECT * FROM v;\n+------+------+\n| a    | a2   |\n+------+------+\n|    1 |    2 |\n|    2 |    4 |\n|    3 |    6 |\n+------+------+\n\nOR REPLACE and IF NOT EXISTS:\n\nCREATE VIEW v AS SELECT a, a*2 AS a2 FROM t;\nERROR 1050 (42S01): Table \'v\' already exists\n\nCREATE OR REPLACE VIEW v AS SELECT a, a*2 AS a2 FROM t;\nQuery OK, 0 rows affected (0.04 sec)\n\nCREATE VIEW IF NOT EXISTS v AS SELECT a, a*2 AS a2 FROM t;\nQuery OK, 0 rows affected, 1 warning (0.01 sec)\n\nSHOW WARNINGS;\n+-------+------+--------------------------+\n| Level | Code | Message                  |\n+-------+------+--------------------------+\n| Note  | 1050 | Table \'v\' already exists |\n+-------+------+--------------------------+\n\nURL: https://mariadb.com/kb/en/create-view/','','https://mariadb.com/kb/en/create-view/'),
(721,'Generated (Virtual and Persistent/Stored) Columns',38,'Syntax\n------\n\n<type>  [GENERATED ALWAYS]  AS   ( <expression> )\n[VIRTUAL | PERSISTENT | STORED]  [UNIQUE] [UNIQUE KEY] [COMMENT <text>]\n\nMariaDB\'s generated columns syntax is designed to be similar to the syntax for\nMicrosoft SQL Server\'s computed columns and Oracle Database\'s virtual columns.\nIn MariaDB 10.2 and later, the syntax is also compatible with the syntax for\nMySQL\'s generated columns.\n\nDescription\n-----------\n\nA generated column is a column in a table that cannot explicitly be set to a\nspecific value in a DML query. Instead, its value is automatically generated\nbased on an expression. This expression might generate the value based on the\nvalues of other columns in the table, or it might generate the value by\ncalling built-in functions or user-defined functions (UDFs).\n\nThere are two types of generated columns:\n\n* PERSISTENT (a.k.a. STORED): This type\'s value is actually stored in the\ntable.\n* VIRTUAL: This type\'s value is not stored at all. Instead, the value is\ngenerated dynamically when the table is queried. This type is the default.\n\nGenerated columns are also sometimes called computed columns or virtual\ncolumns.\n\nSupported Features\n------------------\n\nStorage Engine Support\n----------------------\n\n* Generated columns can only be used with storage engines which support them.\nIf you try to use a storage engine that does not support them, then you will\nsee an error similar to the following:\n\nERROR 1910 (HY000): TokuDB storage engine does not support computed columns\n\n* InnoDB, Aria, MyISAM and CONNECT support generated columns.\n\n* A column in a MERGE table can be built on a PERSISTENT generated column.\nHowever, a column in a MERGE table can not be defined as a VIRTUAL and\nPERSISTENT generated column.\n\nData Type Support\n-----------------\n\n* All data types are supported when defining generated columns.\n\n* Using the ZEROFILL column option is supported when defining generated\ncolumns.\n\n* Using the AUTO_INCREMENT column option is not supported when defining\ngenerated columns. Until MariaDB 10.2.25, it was supported, but this support\nwas removed, because it would not work correctly. See MDEV-11117.\n\nIndex Support\n-------------\n\n* Using a generated column as a table\'s primary key is not supported. See\nMDEV-5590 for more information. If you try to use one as a primary key, then\nyou will see an error similar to the following:\n\nERROR 1903 (HY000): Primary key cannot be defined upon a computed column\n\n* Using PERSISTENT generated columns as part of a foreign key is supported.\n\n* Referencing PERSISTENT generated columns as part of a foreign key is also\nsupported.\nHowever, using the ON UPDATE CASCADE, ON UPDATE SET NULL, or ON DELETE SET\nNULL clauses is not supported. If you try to use an unsupported clause, then\nyou will see an error similar to the following:\n\nERROR 1905 (HY000): Cannot define foreign key with ON UPDATE SET NULL clause\non a computed column\n\n* Defining indexes on both VIRTUAL and PERSISTENT generated columns is\nsupported.\nIf an index is defined on a generated column, then the optimizer considers\nusing it in the same way as indexes based on \"real\" columns.\n\nStatement Support\n-----------------\n\n* Generated columns are used in DML queries just as if they were \"real\"\ncolumns.\nHowever, VIRTUAL and PERSISTENT generated columns differ in how their data is\nstored.\nValues for PERSISTENT generated columns are generated whenever a DML queries\ninserts or updates the row with the special DEFAULT value. This generates the\ncolumns value, and it is stored in the table like the other \"real\" columns.\nThis value can be read by other DML queries just like the other \"real\" columns.\nValues for VIRTUAL generated columns are not stored in the table. Instead, the\nvalue is generated dynamically whenever the column is queried. If other\ncolumns in a row are queried, but the VIRTUAL generated column is not one of\nthe queried columns, then the column\'s value is not generated.\n\n* The SELECT statement supports generated columns.\n\n* Generated columns can be referenced in the INSERT, UPDATE, and DELETE\nstatements.\nHowever, VIRTUAL or PERSISTENT generated columns cannot be explicitly set to\nany other values than NULL or DEFAULT. If a generated column is explicitly set\nto any other value, then the outcome depends on whether strict mode is enabled\nin sql_mode. If it is not enabled, then a warning will be raised and the\ndefault generated value will be used instead. If it is enabled, then an error\nwill be raised instead.\n\n* The CREATE TABLE statement has limited support for generated columns.\nIt supports defining generated columns in a new table.\nIt supports using generated columns to partition tables.\nIt does not support using the versioning clauses with generated columns.\n\n* The ALTER TABLE statement has limited support for generated columns.\nIt supports the MODIFY and CHANGE clauses for PERSISTENT generated columns.\nIt does not support the MODIFY clause for VIRTUAL generated columns if\nALGORITHM is not set to COPY. See MDEV-15476 for more information.\nIt does not support the  CHANGE clause for VIRTUAL generated columns if\nALGORITHM is not set to COPY. See MDEV-17035 for more information.\nIt does not support altering a table if ALGORITHM is not set to COPY if the\ntable has a VIRTUAL generated column that is indexed. See MDEV-14046 for more\ninformation.\nIt does not support adding a VIRTUAL generated column with the ADD clause if\nthe same statement is also adding other columns if ALGORITHM is not set to\nCOPY. See MDEV-17468 for more information.\nIt also does not support altering an existing column into a VIRTUAL generated\ncolumn.\nIt supports using generated columns to partition tables.\nIt does not support using the versioning clauses with generated columns.\n\n* The SHOW CREATE TABLE statement supports generated columns.\n\n* The DESCRIBE statement can be used to check whether a table has generated\ncolumns.\nYou can tell which columns are generated by looking for the ones where the\nExtra column is set to either VIRTUAL or PERSISTENT. For example:\n\nDESCRIBE table1;\n+-------+-------------+------+-----+---------+------------+\n| Field | Type        | Null | Key | Default | Extra      |\n+-------+-------------+------+-----+---------+------------+\n| a     | int(11)     | NO   |     | NULL    |            |\n| b     | varchar(32) | YES  |     | NULL    |            |\n| c     | int(11)     | YES  |     | NULL    | VIRTUAL    |\n| d     | varchar(5)  | YES  |     | NULL    | PERSISTENT |\n+-------+-------------+------+-----+---------+------------+\n\n* Generated columns can be properly referenced in the NEW and OLD rows in\ntriggers.\n\n* Stored procedures support generated columns.\n\n* The HANDLER statement supports generated columns.\n\nExpression Support\n------------------\n\n* Most legal, deterministic expressions which can be calculated are supported\nin expressions for generated columns.\n\n* Most built-in functions are supported in expressions for generated columns.\nHowever, some built-in functions can\'t be supported for technical reasons. For\nexample,  If you try to use an unsupported function in an expression, an error\nis generated similar to the following:\n\nERROR 1901 (HY000): Function or expression \'dayname()\' cannot be used in the\nGENERATED ALWAYS AS clause of `v`\n\n* Subqueries are not supported in expressions for generated columns because\nthe underlying data can change.\n\n* Using anything that depends on data outside the row is not supported in\nexpressions for generated columns.\n\n* Stored functions are not supported in expressions for generated columns. See\nMDEV-17587 for more information.\n\n* Non-deterministic built-in functions are supported in expressions for not\nindexed VIRTUAL generated columns.\n\n* Non-deterministic built-in functions are not supported in expressions for\nPERSISTENT or indexed VIRTUAL generated columns.\n\n* User-defined functions (UDFs) are supported in expressions for generated\ncolumns.\nHowever, MariaDB can\'t check whether a UDF is deterministic, so it is up to\nthe user to be sure that they do not use non-deterministic UDFs with VIRTUAL\ngenerated columns.\n\n* Defining a generated column based on other generated columns defined before\nit in the table definition is supported. For example:\n\nCREATE TABLE t1 (a int as (1), b int as (a));\n\n* However, defining a generated column based on other generated columns\ndefined after in the table definition is not supported in expressions for\ngeneration columns because generated columns are calculated in the order they\nare defined.\n\n* Using an expression that exceeds 255 characters in length is supported in\nexpressions for generated columns. The new limit for the entire table\ndefinition, including all expressions for generated columns, is 65,535 bytes.\n\n* Using constant expressions is supported in expressions for generated\ncolumns. For example:\n\nCREATE TABLE t1 (a int as (1));\n\nMaking Stored Values Consistent\n-------------------------------\n\nWhen a generated column is PERSISTENT or indexed, the value of the expression\nneeds to be consistent regardless of the SQL Mode flags in the current\nsession. If it is not, then the table will be seen as corrupted when the value\nthat should actually be returned by the computed expression and the value that\nwas previously stored and/or indexed using a different sql_mode setting\ndisagree.\n\nThere are currently two affected classes of inconsistencies: character padding\nand unsigned subtraction:\n\n* For a VARCHAR or TEXT generated column the length of the value returned can\nvary depending on the PAD_CHAR_TO_FULL_LENGTH sql_mode flag.  To make the\nvalue consistent, create the generated column using an RTRIM() or RPAD()\nfunction.  Alternately, create the generated column as a CHAR column so that\nits data is always fully padded.\n\n* If a SIGNED generated column is based on the subtraction of an UNSIGNED\nvalue, the resulting value can vary depending on how large the value is and\nthe NO_UNSIGNED_SUBTRACTION sql_mode flag.  To make the value consistent, use\nCAST() to ensure that each UNSIGNED operand is SIGNED before the subtraction.\n\nMariaDB starting with 10.5\n--------------------------\nBeginning in MariaDB 10.5, there is a fatal error generated when trying to\ncreate a generated column whose value can change depending on the SQL Mode\nwhen its data is PERSISTENT or indexed.\n\nFor an existing generated column that has a potentially inconsistent value, a\nwarning about a bad expression is generated the first time it is used (if\nwarnings are enabled).\n\nBeginning in MariaDB 10.4.8, MariaDB 10.3.18, and MariaDB 10.2.27 a\npotentially inconsistent generated column outputs a warning when created or\nfirst used (without restricting their creation).\n\nHere is an example of two tables that would be rejected in MariaDB 10.5 and\nwarned about in the other listed versions:\n\nCREATE TABLE bad_pad (\n txt CHAR(5),\n -- CHAR -> VARCHAR or CHAR -> TEXT can\'t be persistent or indexed:\n vtxt VARCHAR(5) AS (txt) PERSISTENT\n);\n\nCREATE TABLE bad_sub (\n num1 BIGINT UNSIGNED,\n num2 BIGINT UNSIGNED,\n -- The resulting value can vary for some large values\n vnum BIGINT AS (num1 - num2) VIRTUAL,\n KEY(vnum)\n);\n\nThe warnings for the above tables look like this:\n\nWarning (Code 1901): Function or expression \'`txt`\' cannot be used in the\nGENERATED ALWAYS AS clause of `vtxt`\nWarning (Code 1105): Expression depends on the @@sql_mode value\nPAD_CHAR_TO_FULL_LENGTH\n\nWarning (Code 1901): Function or expression \'`num1` - `num2`\' cannot be used\nin the GENERATED ALWAYS AS clause of `vnum`\nWarning (Code 1105): Expression depends on the @@sql_mode value\nNO_UNSIGNED_SUBTRACTION\n\nTo work around the issue, force the padding or type to make the generated\ncolumn\'s expression return a consistent value. For example:\n\nCREATE TABLE good_pad (\n txt CHAR(5),\n -- Using RTRIM() or RPAD() makes the value consistent:\n vtxt VARCHAR(5) AS (RTRIM(txt)) PERSISTENT,\n -- When not persistent or indexed, it is OK for the value to vary by mode:\n vtxt2 VARCHAR(5) AS (txt) VIRTUAL,\n -- CHAR -> CHAR is always OK:\n txt2 CHAR(5) AS (txt) PERSISTENT\n);\n\nCREATE TABLE good_sub (\n num1 BIGINT UNSIGNED,\n num2 BIGINT UNSIGNED,\n -- The indexed value will always be consistent in this expression:\n vnum BIGINT AS (CAST(num1 AS SIGNED) - CAST(num2 AS SIGNED)) VIRTUAL,\n KEY(vnum)\n);\n\nMySQL Compatibility Support\n---------------------------\n\n* The STORED keyword is supported as an alias for the PERSISTENT keyword.\n\n* Tables created with MySQL 5.7 or later that contain MySQL\'s generated\ncolumns can be imported into MariaDB without a dump and restore.\n\nImplementation Differences\n--------------------------\n\nGenerated columns are subject to various constraints in other DBMSs that are\nnot present in MariaDB\'s implementation. Generated columns may also be called\ncomputed columns or virtual columns in different implementations. The various\ndetails for a specific implementation can be found in the documentation for\neach specific DBMS.\n\nImplementation Differences Compared to Microsoft SQL Server\n-----------------------------------------------------------\n\nMariaDB\'s generated columns implementation does not enforce the following\nrestrictions that are present in Microsoft SQL Server\'s computed columns\nimplementation:\n\n* MariaDB allows server variables in generated column expressions, including\nthose that change dynamically, such as warning_count.\n* MariaDB allows the CONVERT_TZ() function to be called with a named time zone\nas an argument, even though time zone names and time offsets are configurable.\n* MariaDB allows the CAST() function to be used with non-unicode character\nsets, even though character sets are configurable and differ between\nbinaries/versions.\n* MariaDB allows FLOAT expressions to be used in generated columns. Microsoft\nSQL Server considers these expressions to be \"imprecise\" due to potential\ncross-platform differences in floating-point implementations and precision.\n* Microsoft SQL Server requires the ARITHABORT mode to be set, so that\ndivision by zero returns an error, and not a NULL.\n* Microsoft SQL Server requires QUOTED_IDENTIFIER to be set in sql_mode. In\nMariaDB, if data is inserted without ANSI_QUOTES set in sql_mode, then it will\nbe processed and stored differently in a generated column that contains quoted\nidentifiers.\n\nMicrosoft SQL Server enforces the above restrictions by doing one of the\nfollowing things:\n\n* Refusing to create computed columns.\n* Refusing to allow updates to a table containing them.\n* Refusing to use an index over such a column if it can not be guaranteed that\nthe expression is fully deterministic.\n\nIn MariaDB, as long as the sql_mode, language, and other settings that were in\neffect during the CREATE TABLE remain unchanged, the generated column\nexpression will always be evaluated the same. If any of these things change,\nthen please be aware that the generated column expression might not be\nevaluated the same way as it previously was.\n\nIf you try to update a virtual column, you will get an error if the default\nstrict mode is enabled in sql_mode, or a warning otherwise.\n\nDevelopment History\n-------------------\n\nGenerated columns was originally developed by Andrey Zhakov. It was then\nmodified by Sanja Byelkin and Igor Babaev at Monty Program for inclusion in\nMariaDB. Monty did the work on MariaDB 10.2 to lift a some of the old\nlimitations.\n\nExamples\n--------\n\nHere is an example table that uses both VIRTUAL and PERSISTENT virtual columns:\n\nUSE TEST;\n\nCREATE TABLE table1 (\n  a INT NOT NULL,\n  b VARCHAR(32),\n  c INT AS (a mod 10) VIRTUAL,\n  d VARCHAR(5) AS (left(b,5)) PERSISTENT);\n\nIf you describe the table, you can easily see which columns are virtual by\nlooking in the \"Extra\" column:\n\nDESCRIBE table1;\n+-------+-------------+------+-----+---------+------------+\n| Field | Type        | Null | Key | Default | Extra      |\n+-------+-------------+------+-----+---------+------------+\n| a     | int(11)     | NO   |     | NULL    |            |\n| b     | varchar(32) | YES  |     | NULL    |            |\n| c     | int(11)     | YES  |     | NULL    | VIRTUAL    |\n| d     | varchar(5)  | YES  |     | NULL    | PERSISTENT |\n+-------+-------------+------+-----+---------+------------+\n\nTo find out what function(s) generate the value of the virtual column you can\nuse SHOW CREATE TABLE:\n\nSHOW CREATE TABLE table1;\n\n| table1 | CREATE TABLE `table1` (\n `a` int(11) NOT NULL,\n `b` varchar(32) DEFAULT NULL,\n `c` int(11) AS (a mod 10) VIRTUAL,\n `d` varchar(5) AS (left(b,5)) PERSISTENT\n) ENGINE=MyISAM DEFAULT CHARSET=latin1 |\n\nIf you try to insert non-default values into a virtual column, you will\nreceive a warning and what you tried to insert will be ignored and the derived\nvalue inserted instead:\n\nWARNINGS;\nShow warnings enabled.\n\nINSERT INTO table1 VALUES (1, \'some text\',default,default);\nQuery OK, 1 row affected (0.00 sec)\n\nINSERT INTO table1 VALUES (2, \'more text\',5,default);\nQuery OK, 1 row affected, 1 warning (0.00 sec)\n\nWarning (Code 1645): The value specified for computed column \'c\' in table\n\'table1\' has been ignored.\n\nINSERT INTO table1 VALUES (123, \'even more text\',default,\'something\');\nQuery OK, 1 row affected, 2 warnings (0.00 sec)\n\nWarning (Code 1645): The value specified for computed column \'d\' in table\n\'table1\' has been ignored.\nWarning (Code 1265): Data truncated for column \'d\' at row 1\n\nSELECT * FROM table1;\n+-----+----------------+------+-------+\n| a   | b              | c    | d     |\n+-----+----------------+------+-------+\n|   1 | some text      |    1 | some  |\n|   2 | more text      |    2 | more  |\n| 123 | even more text |    3 | even  |\n+-----+----------------+------+-------+\n3 rows in set (0.00 sec)\n\nIf the ZEROFILL clause is specified, it should be placed directly after the\ntype definition, before the AS (<expression>):\n\nCREATE TABLE table2 (a INT, b INT ZEROFILL AS (a*2) VIRTUAL);\nINSERT INTO table2 (a) VALUES (1);\n\nSELECT * FROM table2;\n+------+------------+\n| a    | b          |\n+------+------------+\n|    1 | 0000000002 |\n+------+------------+\n1 row in set (0.00 sec)\n\nYou can also use virtual columns to implement a \"poor man\'s partial index\".\nSee example at the end of Unique Index.\n\nURL: https://mariadb.com/kb/en/generated-columns/','','https://mariadb.com/kb/en/generated-columns/'),
(727,'DROP PACKAGE',38,'MariaDB starting with 10.3.5\n----------------------------\nOracle-style packages were introduced in MariaDB 10.3.5.\n\nSyntax\n------\n\nDROP PACKAGE [IF EXISTS]  [ db_name . ] package_name\n\nDescription\n-----------\n\nThe DROP PACKAGE statement can be used when Oracle SQL_MODE is set.\n\nThe DROP PACKAGE statement drops a stored package entirely:\n\n* Drops the package specification (earlier created using the CREATE PACKAGE\nstatement).\n* Drops the package implementation, if the implementation was already created\nusing the CREATE PACKAGE BODY statement.\n\nURL: https://mariadb.com/kb/en/drop-package/','','https://mariadb.com/kb/en/drop-package/'),
(288,'VARCHAR',23,'Syntax\n------\n\n[NATIONAL] VARCHAR(M) [CHARACTER SET charset_name] [COLLATE collation_name]\n\nDescription\n-----------\n\nA variable-length string. M represents the maximum column length in\ncharacters. The range of M is 0 to 65,532. The effective maximum length of a\nVARCHAR is subject to the maximum row size and the character set used. For\nexample, utf8 characters can require up to three bytes per character, so a\nVARCHAR column that uses the utf8 character set can be declared to be a\nmaximum of 21,844 characters.\n\nNote: For the ColumnStore engine, M represents the maximum column length in\nbytes.\n\nMariaDB stores VARCHAR values as a one-byte or two-byte length prefix plus\ndata. The length prefix indicates the number of bytes in the value. A VARCHAR\ncolumn uses one length byte if values require no more than 255 bytes, two\nlength bytes if values may require more than 255 bytes.\n\nMariaDB follows the standard SQL specification, and does not remove trailing\nspaces from VARCHAR values.\n\nVARCHAR(0) columns can contain 2 values: an empty string or NULL. Such columns\ncannot be part of an index. The CONNECT storage engine does not support\nVARCHAR(0).\n\nVARCHAR is shorthand for CHARACTER VARYING. NATIONAL VARCHAR is the standard\nSQL way to define that a VARCHAR column should use some predefined character\nset. MariaDB uses utf8 as this predefined character set, as does MySQL 4.1 and\nup. NVARCHAR is shorthand for NATIONAL VARCHAR.\n\nBefore MariaDB 10.2, all MariaDB collations were of type PADSPACE, meaning\nthat VARCHAR (as well as CHAR and TEXT values) are compared without regard for\ntrailing spaces. This does not apply to the LIKE pattern-matching operator,\nwhich takes into account trailing spaces. From MariaDB 10.2, a number of NO\nPAD collations are available.\n\nIf a unique index consists of a column where trailing pad characters are\nstripped or ignored, inserts into that column where values differ only by the\nnumber of trailing pad characters will result in a duplicate-key error.\n\nExamples\n--------\n\nThe following are equivalent:\n\nVARCHAR(30) CHARACTER SET utf8\nNATIONAL VARCHAR(30)\nNVARCHAR(30)\nNCHAR VARCHAR(30)\nNATIONAL CHARACTER VARYING(30)\nNATIONAL CHAR VARYING(30)\n\nTrailing spaces:\n\nCREATE TABLE strtest (v VARCHAR(10));\nINSERT INTO strtest VALUES(\'Maria   \');\n\nSELECT v=\'Maria\',v=\'Maria   \' FROM strtest;\n+-----------+--------------+\n| v=\'Maria\' | v=\'Maria   \' |\n+-----------+--------------+\n|         1 |            1 |\n+-----------+--------------+\n\nSELECT v LIKE \'Maria\',v LIKE \'Maria   \' FROM strtest;\n+----------------+-------------------+\n| v LIKE \'Maria\' | v LIKE \'Maria   \' |\n+----------------+-------------------+\n|              0 |                 1 |\n+----------------+-------------------+\n\nTruncation\n----------\n\n* Depending on whether or not strict sql mode is set, you will either get a\nwarning or an error if you try to insert a string that is too long into a\nVARCHAR column. If the extra characters are spaces, the spaces that can\'t fit\nwill be removed and you will always get a warning, regardless of the sql mode\nsetting.\n\nDifference Between VARCHAR and TEXT\n-----------------------------------\n\n* VARCHAR columns can be fully indexed. TEXT columns can only be indexed over\na specified length.\n* Using TEXT or BLOB in a SELECT query that uses temporary tables for storing\nintermediate results will force the temporary table to be disk based (using\nthe Aria storage engine instead of the memory storage engine, which is a bit\nslower. This is not that bad as the Aria storage engine caches the rows in\nmemory. To get the benefit of this, one should ensure that the\naria_pagecache_buffer_size variable is big enough to hold most of the row and\nindex data for temporary tables.\n\nOracle Mode\n-----------\n\nMariaDB starting with 10.3\n--------------------------\nIn Oracle mode from MariaDB 10.3, VARCHAR2 is a synonym.\n\nFor Storage Engine Developers\n-----------------------------\n\n* Internally the full length of the VARCHAR column is allocated inside each\nTABLE objects record[] structure. As there are three such buffers, each open\ntable will allocate 3 times max-length-to-store-varchar bytes of memory.\n* TEXT and BLOB columns are stored with a pointer (4 or 8 bytes) + a 1-4 bytes\nlength.  The TEXT data is only stored once. This means that internally TEXT\nuses less memory for each open table but instead has the additional overhead\nthat each TEXT object needs to be allocated and freed for each row access\n(with some caching in between).\n\nURL: https://mariadb.com/kb/en/varchar/','','https://mariadb.com/kb/en/varchar/'),
(295,'YEAR Data Type',23,'Syntax\n------\n\nYEAR[(4)]\n\nDescription\n-----------\n\nA year in two-digit or four-digit format. The default is four-digit format.\nNote that the two-digit format has been deprecated since MariaDB 5.5.27.\n\nIn four-digit format, the allowable values are 1901 to 2155, and 0000. In\ntwo-digit format, the allowable values are 70 to 69, representing years from\n1970 to 2069. MariaDB displays YEAR values in YYYY format, but allows you to\nassign values to YEAR columns using either strings or numbers.\n\nInserting numeric zero has a different result for YEAR(4) and YEAR(2). For\nYEAR(2), the value 00 reflects the year 2000. For YEAR(4), the value 0000\nreflects the year zero. This only applies to numeric zero. String zero always\nreflects the year 2000.\n\nExamples\n--------\n\nAccepting a string or a number:\n\nCREATE TABLE y(y YEAR);\n\nINSERT INTO y VALUES (1990),(\'2012\');\n\nSELECT * FROM y;\n+------+\n| y    |\n+------+\n| 1990 |\n| 2012 |\n+------+\n\nWith strict_mode set, the default from MariaDB 10.2.4:\n\nOut of range:\n\nINSERT INTO y VALUES (1005),(\'3080\');\nERROR 1264 (22003): Out of range value for column \'y\' at row 1\n\nINSERT INTO y VALUES (\'2013-12-12\');\nERROR 1265 (01000): Data truncated for column \'y\' at row 1\n\nSELECT * FROM y;\n+------+\n| y    |\n+------+\n| 1990 |\n| 2012 |\n+------+\n\nWith strict_mode unset, the default until MariaDB 10.2.3:\n\nOut of range:\n\nINSERT INTO y VALUES (1005),(\'3080\');\nQuery OK, 2 rows affected, 2 warnings (0.05 sec)\nRecords: 2  Duplicates: 0  Warnings: 2\n\nSHOW WARNINGS;\n+---------+------+--------------------------------------------+\n| Level   | Code | Message                                    |\n+---------+------+--------------------------------------------+\n| Warning | 1264 | Out of range value for column \'y\' at row 1 |\n| Warning | 1264 | Out of range value for column \'y\' at row 2 |\n+---------+------+--------------------------------------------+\n\nSELECT * FROM y;\n+------+\n| y    |\n+------+\n| 1990 |\n| 2012 |\n| 0000 |\n| 0000 |\n+------+\n\nTruncating:\n\nINSERT INTO y VALUES (\'2013-12-12\');\nQuery OK, 1 row affected, 1 warning (0.05 sec)\n\nSHOW WARNINGS;\n+---------+------+----------------------------------------+\n| Level   | Code | Message                                |\n+---------+------+----------------------------------------+\n| Warning | 1265 | Data truncated for column \'y\' at row 1 |\n+---------+------+----------------------------------------+\n\nSELECT * FROM y;\n+------+\n| y    |\n+------+\n| 1990 |\n| 2012 |\n| 0000 |\n| 0000 |\n| 2013 |\n+------+\n\nDifference between YEAR(2) and YEAR(4), and string and numeric zero:\n\nCREATE TABLE y2(y YEAR(4), y2 YEAR(2));\nQuery OK, 0 rows affected, 1 warning (0.40 sec)\n\nNote (Code 1287): \'YEAR(2)\' is deprecated and will be removed in a future\nrelease. \n Please use YEAR(4) instead\n\nINSERT INTO y2 VALUES(0,0),(\'0\',\'0\');\n\nSELECT YEAR(y),YEAR(y2) FROM y2;\n+---------+----------+\n| YEAR(y) | YEAR(y2) |\n+---------+----------+\n|       0 |     2000 |\n|    2000 |     2000 |\n+---------+----------+\n\nURL: https://mariadb.com/kb/en/year-data-type/','','https://mariadb.com/kb/en/year-data-type/'),
(290,'UUID Data Type',23,'MariaDB starting with 10.7.0\n----------------------------\nThe UUID data type was added in a MariaDB 10.7.0 preview.\n\nSyntax\n------\n\nUUID\n\nDescription\n-----------\n\nThe UUID data type is intended for the storage of 128-bit UUID (Universally\nUnique Identifier) data. See the UUID function page for more details on UUIDs\nthemselves.\n\nRetrieval\n---------\n\nData retrieved by this data type is in the string representation defined in\nRFC4122.\n\nCasting\n-------\n\nString literals of hexadecimal characters and CHAR/VARCHAR/TEXT can be cast to\nthe UUID data type. Likewise hexadecimal literals, binary-literals, and\nBINARY/VARBINARY/BLOB types can also be cast to UUID.\n\nThe data type will not accept a short UUID generated with the UUID_SHORT\nfunction, but will accept a value without the - character generated by the\nSYS_GUID function (or inserted directly). Hyphens can be partially omitted as\nwell, or included after any group of two digits.\n\nThe type does not accept UUIDs in braces, permitted by some implementations.\n\nStorage\n-------\n\nUUID are stored in an index friendly manner, the order of a UUID of\nllllllll-mmmm-Vhhh-vsss-nnnnnnnnnnnn is stored as:\n\nnnnnnnnnnnnn-vsss-Vhhh-mmmm-llllllll\n\nThis provides a sorting order, if a UUIDv1 (node and timestamp) is used, of\nthe node, followed by the timestamp.\n\nExamples\n--------\n\nCREATE TABLE t1 (id UUID);\n\nDirectly Inserting via string literals:\n\nINSERT INTO t1 VALUES(\'123e4567-e89b-12d3-a456-426655440000\');\n\nDirectly Inserting via hexadecimal literals:\n\nINSERT INTO t1 VALUES (x\'fffffffffffffffffffffffffffffffe\');\n\nGenerating and inserting via the UUID function.\n\nINSERT INTO t1 VALUES (UUID());\n\nRetrieval:\n\nSELECT * FROM t1;\n+--------------------------------------+\n| id                                   |\n+--------------------------------------+\n| 123e4567-e89b-12d3-a456-426655440000 |\n| ffffffff-ffff-ffff-ffff-fffffffffffe |\n| 93aac041-1a14-11ec-ab4e-f859713e4be4 |\n+--------------------------------------+\n\nThe UUID_SHORT function does not generate valid full-length UUID:\n\nINSERT INTO t1 VALUES (UUID_SHORT());\nERROR 1292 (22007): Incorrect uuid value: \'99440417627439104\' \n for column `test`.`t1`.`id` at row 1\n\nAccepting a value without the - character, either directly or generated by the\nSYS_GUID function:\n\nINSERT INTO t1 VALUES (SYS_GUID());\n\nSELECT * FROM t1;\n+--------------------------------------+\n| id                                   |\n+--------------------------------------+\n| 123e4567-e89b-12d3-a456-426655440000 |\n| ffffffff-ffff-ffff-ffff-fffffffffffe |\n| 93aac041-1a14-11ec-ab4e-f859713e4be4 |\n| ea0368d3-1a14-11ec-ab4e-f859713e4be4 |\n+--------------------------------------+\n\nSELECT SYS_GUID();\n+----------------------------------+\n| SYS_GUID()                       |\n+----------------------------------+\n| ff5b6bcc1a1411ecab4ef859713e4be4 |\n+----------------------------------+\n\nINSERT INTO t1 VALUES (\'ff5b6bcc1a1411ecab4ef859713e4be4\');\n\nSELECT * FROM t1;\n+--------------------------------------+\n| id                                   |\n+--------------------------------------+\n| 123e4567-e89b-12d3-a456-426655440000 |\n| ffffffff-ffff-ffff-ffff-fffffffffffe |\n| 93aac041-1a14-11ec-ab4e-f859713e4be4 |\n| ea0368d3-1a14-11ec-ab4e-f859713e4be4 |\n| ff5b6bcc-1a14-11ec-ab4e-f859713e4be4 |\n+--------------------------------------+\n\nValid and invalid hyphen and brace usage:\n\nTRUNCATE t1;\n\nINSERT INTO t1 VALUES (\'f8aa-ed66-1a1b-11ec-ab4e-f859-713e-4be4\');\n\nINSERT INTO t1 VALUES (\'1b80667f1a1c-11ecab4ef859713e4be4\');\n\nINSERT INTO t1 VALUES (\'2fd6c945-1a-1c-11ec-ab4e-f859713e4be4\');\n\nINSERT INTO t1 VALUES (\'49-c9-f9-59-1a-1c-11ec-ab4e-f859713e4be4\');\n\nINSERT INTO t1 VALUES (\'57-96-da-c1-1a-1c-11-ec-ab-4e-f8-59-71-3e-4b-e4\');\n\nINSERT INTO t1 VALUES (\'6-eb74f8f-1a1c-11ec-ab4e-f859713e4be4\');\n\nINSERT INTO t1 VALUES (\'{29bad136-1a1d-11ec-ab4e-f859713e4be4}\');\nERROR 1292 (22007): Incorrect uuid value:\n\'{29bad136-1a1d-11ec-ab4e-f859713e4be4}\' \n for column `test`.`t1`.`id` at row 1\n\nSELECT * FROM t1;\n+--------------------------------------+\n| id                                   |\n+--------------------------------------+\n| f8aaed66-1a1b-11ec-ab4e-f859713e4be4 |\n| 1b80667f-1a1c-11ec-ab4e-f859713e4be4 |\n| 2fd6c945-1a1c-11ec-ab4e-f859713e4be4 |\n| 49c9f959-1a1c-11ec-ab4e-f859713e4be4 |\n| 5796dac1-1a1c-11ec-ab4e-f859713e4be4 |\n| 6eb74f8f-1a1c-11ec-ab4e-f859713e4be4 |\n+--------------------------------------+\n\nURL: https://mariadb.com/kb/en/uuid-data-type/','','https://mariadb.com/kb/en/uuid-data-type/'),
(297,'Using Compound Statements Outside of Stored Programs',24,'Compound statements can also be used outside of stored programs.\n\ndelimiter |\nIF @have_innodb THEN\n CREATE TABLE IF NOT EXISTS innodb_index_stats (\n  database_name    VARCHAR(64) NOT NULL,\n  table_name       VARCHAR(64) NOT NULL,\n  index_name       VARCHAR(64) NOT NULL,\n  last_update      TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE\nCURRENT_TIMESTAMP,\n  stat_name        VARCHAR(64) NOT NULL,\n  stat_value       BIGINT UNSIGNED NOT NULL,\n  sample_size      BIGINT UNSIGNED,\n  stat_description VARCHAR(1024) NOT NULL,\n  PRIMARY KEY (database_name, table_name, index_name, stat_name)\n ) ENGINE=INNODB DEFAULT CHARSET=utf8 COLLATE=utf8_bin STATS_PERSISTENT=0;\nEND IF|\nQuery OK, 0 rows affected, 2 warnings (0.00 sec)\n\nNote, that using compound statements this way is subject to following\nlimitations:\n\n* Only BEGIN, IF, CASE, LOOP, WHILE, REPEAT statements may start a compound\nstatement outside of stored programs.\n* BEGIN must use the BEGIN NOT ATOMIC syntax (otherwise it\'ll be confused with\nBEGIN that starts a transaction).\n* A compound statement might not start with a label.\n* A compound statement is parsed completely—note \"2 warnings\" in the above\nexample, even if the condition was false (InnoDB was, indeed, disabled), and\nthe CREATE TABLE statement was not executed, it was still parsed and the\nparser produced \"Unknown storage engine\" warning.\n\nInside a compound block first three limitations do not apply, one can use\nanything that can be used inside a stored program — including labels,\ncondition handlers, variables, and so on:\n\nBEGIN NOT ATOMIC\n  DECLARE foo CONDITION FOR 1146;\n  DECLARE x INT DEFAULT 0;\n  DECLARE CONTINUE HANDLER FOR SET x=1;\n  INSERT INTO test.t1 VALUES (\"hndlr1\", val, 2);\n  END|\n\nExample how to use IF:\n\nIF (1>0) THEN BEGIN NOT ATOMIC SELECT 1; END ; END IF;;\n\nExample of how to use WHILE loop:\n\nDELIMITER |\nBEGIN NOT ATOMIC\n  DECLARE x INT DEFAULT 0;\n  WHILE x <= 10 DO\n    SET x = x + 1;\n    SELECT x;\n  END WHILE;\nEND|\nDELIMITER ;\n\nURL:\nhttps://mariadb.com/kb/en/using-compound-statements-outside-of-stored-programs/','','https://mariadb.com/kb/en/using-compound-statements-outside-of-stored-programs/'),
(728,'DROP PACKAGE BODY',38,'MariaDB starting with 10.3.5\n----------------------------\nOracle-style packages were introduced in MariaDB 10.3.5.\n\nSyntax\n------\n\nDROP PACKAGE BODY [IF EXISTS]  [ db_name . ] package_name\n\nDescription\n-----------\n\nThe DROP PACKAGE BODY statement can be used when Oracle SQL_MODE is set.\n\nThe DROP PACKAGE BODY statement drops the package body (i.e the\nimplementation), previously created using the CREATE PACKAGE BODY statement.\n\nNote, DROP PACKAGE BODY drops only the package implementation, but does not\ndrop the package specification. Use DROP PACKAGE to drop the package entirely\n(i.e. both implementation and specification).\n\nURL: https://mariadb.com/kb/en/drop-package-body/','','https://mariadb.com/kb/en/drop-package-body/'),
(292,'TIME',23,'Syntax\n------\n\nTIME [(<microsecond precision>)]\n\nDescription\n-----------\n\nA time. The range is \'-838:59:59.999999\' to \'838:59:59.999999\'. Microsecond\nprecision can be from 0-6; if not specified 0 is used. Microseconds have been\navailable since MariaDB 5.3.\n\nMariaDB displays TIME values in \'HH:MM:SS.ssssss\' format, but allows\nassignment of times in looser formats, including \'D HH:MM:SS\', \'HH:MM:SS\',\n\'HH:MM\', \'D HH:MM\', \'D HH\', \'SS\', or \'HHMMSS\', as well as permitting dropping\nof any leading zeros when a delimiter is provided, for example \'3:9:10\'. For\ndetails, see date and time literals.\n\nMariaDB 10.1.2 introduced the --mysql56-temporal-format option, on by default,\nwhich allows MariaDB to store TIMEs using the same low-level format MySQL 5.6\nuses.\n\nInternal Format\n---------------\n\nIn MariaDB 10.1.2 a new temporal format was introduced from MySQL 5.6 that\nalters how the TIME, DATETIME and TIMESTAMP columns operate at lower levels.\nThese changes allow these temporal data types to have fractional parts and\nnegative values. You can disable this feature using the\nmysql56_temporal_format system variable.\n\nTables that include TIMESTAMP values that were created on an older version of\nMariaDB or that were created while the mysql56_temporal_format system variable\nwas disabled continue to store data using the older data type format.\n\nIn order to update table columns from the older format to the newer format,\nexecute an ALTER TABLE... MODIFY COLUMN statement that changes the column to\nthe *same* data type. This change may be needed if you want to export the\ntable\'s tablespace and import it onto a server that has\nmysql56_temporal_format=ON set (see MDEV-15225).\n\nFor instance, if you have a TIME column in your table:\n\nSHOW VARIABLES LIKE \'mysql56_temporal_format\';\n\n+-------------------------+-------+\n| Variable_name           | Value |\n+-------------------------+-------+\n| mysql56_temporal_format | ON    |\n+-------------------------+-------+\n\nALTER TABLE example_table MODIFY ts_col TIME;\n\nWhen MariaDB executes the ALTER TABLE statement, it converts the data from the\nolder temporal format to the newer one.\n\nIn the event that you have several tables and columns using temporal data\ntypes that you want to switch over to the new format, make sure the system\nvariable is enabled, then perform a dump and restore using mariadb-dump. The\ncolumns using relevant temporal data types are restored using the new temporal\nformat.\n\nStarting from MariaDB 10.5.1 columns with old temporal formats are marked with\na /* mariadb-5.3 */ comment in the output of SHOW CREATE TABLE, SHOW COLUMNS,\nDESCRIBE statements, as well as in the COLUMN_TYPE column of the\nINFORMATION_SCHEMA.COLUMNS Table.\n\nSHOW CREATE TABLE mariadb5312_time\\G\n*************************** 1. row ***************************\n   Table: mariadb5312_time\nCreate Table: CREATE TABLE `mariadb5312_time` (\n `t0` time /* mariadb-5.3 */ DEFAULT NULL,\n `t6` time(6) /* mariadb-5.3 */ DEFAULT NULL\n) ENGINE=MyISAM DEFAULT CHARSET=latin1\n\nNote, columns with the current format are not marked with a comment.\n\nExamples\n--------\n\nINSERT INTO time VALUES (\'90:00:00\'), (\'800:00:00\'), (800), (22), (151413),\n(\'9:6:3\'), (\'12 09\');\n\nSELECT * FROM time;\n+-----------+\n| t         |\n+-----------+\n| 90:00:00  |\n| 800:00:00 |\n| 00:08:00  |\n| 00:00:22  |\n| 15:14:13  |\n| 09:06:03  |\n| 297:00:00 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/time/',