/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `aodh`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `aodh` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `aodh`;

--
-- Table structure for table `alarm`
--

DROP TABLE IF EXISTS `alarm`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alarm` (
  `alarm_id` varchar(128) NOT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `name` text DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `severity` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `timestamp` datetime(6) DEFAULT NULL,
  `user_id` varchar(128) DEFAULT NULL,
  `project_id` varchar(128) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `state_reason` text DEFAULT NULL,
  `state_timestamp` datetime(6) DEFAULT NULL,
  `ok_actions` text DEFAULT NULL,
  `alarm_actions` text DEFAULT NULL,
  `insufficient_data_actions` text DEFAULT NULL,
  `repeat_actions` tinyint(1) DEFAULT NULL,
  `rule` text DEFAULT NULL,
  `time_constraints` text DEFAULT NULL,
  `evaluate_timestamp` datetime DEFAULT NULL,
  PRIMARY KEY (`alarm_id`),
  KEY `ix_alarm_user_id` (`user_id`),
  KEY `ix_alarm_type` (`type`),
  KEY `ix_alarm_project_id` (`project_id`),
  KEY `ix_alarm_enabled` (`enabled`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alarm`
--

LOCK TABLES `alarm` WRITE;
/*!40000 ALTER TABLE `alarm` DISABLE KEYS */;
/*!40000 ALTER TABLE `alarm` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alarm_history`
--

DROP TABLE IF EXISTS `alarm_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alarm_history` (
  `event_id` varchar(128) NOT NULL,
  `alarm_id` varchar(128) DEFAULT NULL,
  `on_behalf_of` varchar(128) DEFAULT NULL,
  `project_id` varchar(128) DEFAULT NULL,
  `user_id` varchar(128) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `detail` text DEFAULT NULL,
  `timestamp` datetime(6) DEFAULT NULL,
  `severity` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`event_id`),
  KEY `ix_alarm_history_alarm_id` (`alarm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alarm_history`
--

LOCK TABLES `alarm_history` WRITE;
/*!40000 ALTER TABLE `alarm_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `alarm_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('007');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota`
--

DROP TABLE IF EXISTS `quota`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(128) DEFAULT NULL,
  `resource` varchar(50) DEFAULT NULL,
  `limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`),
  KEY `ix_quota_project_id_resource` (`project_id`,`resource`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota`
--

LOCK TABLES `quota` WRITE;
/*!40000 ALTER TABLE `quota` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('2e433f24-c159-4708-9c28-79c9b8b11a27','2026-02-20 08:41:43','2026-02-20 08:41:43',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
INSERT INTO `backups` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `host`, `availability_zone`, `display_name`, `display_description`, `container`, `status`, `fail_reason`, `service_metadata`, `service`, `size`, `object_count`, `parent_id`, `temp_volume_id`, `temp_snapshot_id`, `num_dependent_backups`, `snapshot_id`, `data_timestamp`, `restore_volume_id`, `encryption_key_id`) VALUES ('2026-02-20 09:59:20','2026-02-20 09:59:23','2026-02-20 09:59:24',1,'27dd9a5c-1e99-4dbb-bc42-862bbe4b0bf4','46236fa4-de9b-4076-afa4-b3fdca1d5fb9','555b92d39f27422695207483d3e530ad','dc400fd7b37f468c83d54846895b6cba','cinder-backup-0',NULL,'tempest-VolumesBackupsAdminTest-Backup-396290958',NULL,'backups','deleted',NULL,'{\"base\": \"volume-46236fa4-de9b-4076-afa4-b3fdca1d5fb9.backup.27dd9a5c-1e99-4dbb-bc42-862bbe4b0bf4\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:20',NULL,NULL),('2026-02-20 10:00:12','2026-02-20 10:00:16','2026-02-20 10:00:17',1,'304fc213-633d-44b9-a1df-ec7aff73de15','8eeb869d-f1f3-4733-a610-c567aaf12a0c','2ba1a8d771344f0a918e0a8bed2efd06','9fdf2c09b98d48c0bc67cc1c7702a8f4','cinder-backup-0',NULL,NULL,NULL,'backups','deleted',NULL,'{\"base\": \"volume-8eeb869d-f1f3-4733-a610-c567aaf12a0c.backup.473c338f-5e58-4dee-924b-be65d997ccc6\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,'473c338f-5e58-4dee-924b-be65d997ccc6',NULL,NULL,NULL,NULL,'2026-02-20 10:00:12',NULL,NULL),('2026-02-20 10:00:07','2026-02-20 10:00:25','2026-02-20 10:00:27',1,'473c338f-5e58-4dee-924b-be65d997ccc6','8eeb869d-f1f3-4733-a610-c567aaf12a0c','2ba1a8d771344f0a918e0a8bed2efd06','9fdf2c09b98d48c0bc67cc1c7702a8f4','cinder-backup-0',NULL,'tempest-VolumesBackupsTest-Backup-740289001',NULL,'backups','deleted',NULL,'{\"base\": \"volume-8eeb869d-f1f3-4733-a610-c567aaf12a0c.backup.473c338f-5e58-4dee-924b-be65d997ccc6\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,0,NULL,'2026-02-20 10:00:07',NULL,NULL),('2026-02-20 09:58:55','2026-02-20 09:59:07','2026-02-20 09:59:08',1,'5bc79e8f-79de-4c3b-862c-a9b28cc9ceaf','b134140b-bf4f-40e9-987b-6889d71ec45a','7058374f87364f958ccdd85f706ecfe0','4208cd0fbab541f399d332d0956cc0d5','cinder-backup-0','nova','tempest-VolumesBackupsAdminTest-Backup-646862142',NULL,'backups','deleted',NULL,'{\"base\": \"volume-b134140b-bf4f-40e9-987b-6889d71ec45a.backup.a1a84c96-aa0f-4fb2-8eb9-6327a408f2e1\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,0,NULL,NULL,NULL,0,NULL,'2026-02-20 09:58:55',NULL,NULL),('2026-02-20 09:58:55','2026-02-20 09:59:09','2026-02-20 09:59:16',1,'a1a84c96-aa0f-4fb2-8eb9-6327a408f2e1','b134140b-bf4f-40e9-987b-6889d71ec45a','555b92d39f27422695207483d3e530ad','dc400fd7b37f468c83d54846895b6cba','cinder-backup-0',NULL,'tempest-VolumesBackupsAdminTest-Backup-646862142',NULL,'backups','deleted',NULL,'{\"base\": \"volume-b134140b-bf4f-40e9-987b-6889d71ec45a.backup.a1a84c96-aa0f-4fb2-8eb9-6327a408f2e1\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:58:55','82a61cb1-4fd5-4805-8fd0-06f26a6e3132',NULL),('2026-02-20 10:00:09','2026-02-20 10:00:25','2026-02-20 10:00:26',1,'c610a0d6-14e1-48f3-a770-f6dcc5605f44','53af8aa6-057c-4cb9-8a9e-c2bf19735f85','0a59a4e0759a4900accbf97025764545','55965a8332c94f2da5d707adc081ab9c','cinder-backup-0',NULL,'tempest-VolumesSnapshotTestJSON-Backup-2055368131',NULL,'backups','deleted',NULL,NULL,'cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,'89b9b715-5115-4fd7-9674-df31ca383c1e','2026-02-20 10:00:07',NULL,NULL),('2026-02-20 09:58:55','2026-02-20 09:59:13','2026-02-20 09:59:18',1,'c97d1c82-4ed8-4592-ba9b-83de9658d77f','7021fb58-60d1-4a77-9009-334fb28abc5e','2ba1a8d771344f0a918e0a8bed2efd06','9fdf2c09b98d48c0bc67cc1c7702a8f4','cinder-backup-0',NULL,'tempest-VolumesBackupsTest-Backup-487868534',NULL,'backups','deleted',NULL,'{\"base\": \"volume-7021fb58-60d1-4a77-9009-334fb28abc5e.backup.c97d1c82-4ed8-4592-ba9b-83de9658d77f\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:58:55','910d88c1-0f88-4edf-ae6d-58b26ff1dc99',NULL),('2026-02-20 10:00:18','2026-02-20 10:00:23','2026-02-20 10:00:25',1,'dd6c0113-c0ab-499f-856e-6bdd49150722','8eeb869d-f1f3-4733-a610-c567aaf12a0c','2ba1a8d771344f0a918e0a8bed2efd06','9fdf2c09b98d48c0bc67cc1c7702a8f4','cinder-backup-0',NULL,'tempest-VolumesBackupsTest-Backup-1037146061',NULL,'backups','deleted',NULL,'{\"base\": \"volume-8eeb869d-f1f3-4733-a610-c567aaf12a0c.backup.473c338f-5e58-4dee-924b-be65d997ccc6\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,'473c338f-5e58-4dee-924b-be65d997ccc6',NULL,NULL,NULL,NULL,'2026-02-20 10:00:18',NULL,NULL),('2026-02-20 09:56:31','2026-02-20 09:56:38','2026-02-20 09:56:39',1,'e8c14ee9-960c-4ca9-801a-80eac4a80e79','35565fa6-046a-4989-b49c-6a04300da192','461cbaeb01d54029a644a346151cbf22','226ab368400e4186b91e98a77b240268','cinder-backup-0',NULL,'tempest-VolumesBackupsV39Test-Backup-1100767818','tempest-volume-backup-description-928742710','backups','deleted',NULL,'{\"base\": \"volume-35565fa6-046a-4989-b49c-6a04300da192.backup.e8c14ee9-960c-4ca9-801a-80eac4a80e79\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:56:31',NULL,NULL);
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`disabled` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`frozen` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
INSERT INTO `encryption` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `cipher`, `control_location`, `key_size`, `provider`, `volume_type_id`, `encryption_id`) VALUES ('2026-02-20 09:55:44','2026-02-20 09:55:44','2026-02-20 09:55:44',1,'aes-xts-plain64','back-end',128,'SomeProvider','c5aaf48b-7390-4ce5-b523-589a02f7b9b3','a3c8337d-aa23-4dae-b55f-ad7e26ea76fb');
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
INSERT INTO `group_snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `group_id`, `user_id`, `project_id`, `name`, `description`, `status`, `group_type_id`) VALUES ('2026-02-20 09:55:15','2026-02-20 09:55:17','2026-02-20 09:55:18',1,'62f2d471-1c4c-43ab-abf4-249a999898b5','523fd1fa-8d01-419d-ba3b-b8e73a667c29','ffbb979ff9fb4e37a3cdbc9384522ee4','dcc08d5e298941e3a9de201aa565b6a9','tempest-group_snapshot-125563722',NULL,'deleted','b42141af-c578-4cde-a328-79351c04a8c8'),('2026-02-20 09:54:44','2026-02-20 09:54:50','2026-02-20 09:54:52',1,'6d3f2094-6cff-46a5-aa20-462d7fcbd2e9','72ffb4ea-d9e9-4d05-8e08-0868a8a71a9e','ffbb979ff9fb4e37a3cdbc9384522ee4','dcc08d5e298941e3a9de201aa565b6a9','tempest-group_snapshot-211378977',NULL,'deleted','a6efa6d9-64ad-44fb-8540-17c29d407ddf'),('2026-02-20 09:57:32','2026-02-20 09:57:33','2026-02-20 09:57:34',1,'87669497-51c9-4f85-aa67-d2b972045d78','f34fe2ac-c196-40f5-a2ae-230b5a9a0e69','64bc298504924a43b95ce2758bfa5477','a48d774a595542e4a66f14036bc080ce','tempest-GroupSnapshotsV319Test-Group_Snapshot-391968842',NULL,'deleted','44fecc21-cb6a-4632-9551-dc2e8548ee33'),('2026-02-20 09:55:03','2026-02-20 09:55:07','2026-02-20 09:55:09',1,'fb1a58cd-8488-4fee-88a6-181edc0e3efe','21a6bf48-fb20-49c1-9d06-ca601aa63b63','ffbb979ff9fb4e37a3cdbc9384522ee4','dcc08d5e298941e3a9de201aa565b6a9','tempest-GroupSnapshotsTest-Group_Snapshot-536418899',NULL,'deleted','9ed5cb54-0516-4a76-bcb4-80f5d01b7b51');
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (2,'consistent_group_snapshot_enabled','<is> True','5e978037-f22a-4f38-b146-894137a9c0a6','2026-02-20 08:05:42','2026-02-20 08:05:42',NULL,0),(5,'key1','value1','7762d12c-8d80-41ed-b6c5-bb6ea969181a','2026-02-20 09:57:22',NULL,'2026-02-20 09:57:22',1),(6,'key2','value2-updated','7762d12c-8d80-41ed-b6c5-bb6ea969181a','2026-02-20 09:57:22','2026-02-20 09:57:22','2026-02-20 09:57:22',1),(7,'key3','value3-updated','7762d12c-8d80-41ed-b6c5-bb6ea969181a','2026-02-20 09:57:22','2026-02-20 09:57:22','2026-02-20 09:57:22',1),(8,'consistent_group_snapshot_enabled','<is> False','5eb9795a-5710-43f3-aeff-5017b69be0fe','2026-02-20 09:57:28',NULL,'2026-02-20 09:57:29',1);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`is_public` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('1216ed9b-7c30-4d99-802b-a74d6d441172','tempest-GroupsV314Test-group-type-210515593',NULL,'2026-02-20 09:59:24',NULL,'2026-02-20 09:59:31',1,1),('44fecc21-cb6a-4632-9551-dc2e8548ee33','tempest-GroupSnapshotsV319Test-group-type-675752465',NULL,'2026-02-20 09:57:29',NULL,'2026-02-20 09:57:36',1,1),('5e978037-f22a-4f38-b146-894137a9c0a6','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2026-02-20 08:05:42','2026-02-20 08:05:42',NULL,0,1),('5eb9795a-5710-43f3-aeff-5017b69be0fe','tempest-GroupTypesTest-updated-group-type-322107583','updated-group-type-desc','2026-02-20 09:57:28','2026-02-20 09:57:29','2026-02-20 09:57:29',1,1),('7762d12c-8d80-41ed-b6c5-bb6ea969181a','tempest-GroupTypeSpecsTest-group-type-1239482429',NULL,'2026-02-20 09:57:22',NULL,'2026-02-20 09:57:22',1,1),('77de15d2-5eb2-4af1-9ccd-5d720043d865','tempest-GroupsTest-group-type-245029839',NULL,'2026-02-20 09:56:49',NULL,'2026-02-20 09:56:59',1,1),('98653d59-6b41-44ce-acb4-1ecdacc9615d','tempest-GroupsV320Test-group-type-588250693',NULL,'2026-02-20 09:57:05',NULL,'2026-02-20 09:57:07',1,1),('99160ac6-7af8-4b6e-b057-ce9e8ba1992a','tempest-GroupsTest-group-type-420077883',NULL,'2026-02-20 09:56:42',NULL,'2026-02-20 09:56:49',1,1),('9ed5cb54-0516-4a76-bcb4-80f5d01b7b51','tempest-GroupSnapshotsTest-group-type-1926401365',NULL,'2026-02-20 09:54:54',NULL,'2026-02-20 09:55:13',1,1),('a6efa6d9-64ad-44fb-8540-17c29d407ddf','tempest-GroupSnapshotsTest-group-type-1397517766',NULL,'2026-02-20 09:54:41',NULL,'2026-02-20 09:54:54',1,1),('af2b7076-bee7-483e-a5c5-7c6db7db60d3','a_tempest-group-type-2022150665',NULL,'2026-02-20 09:57:29',NULL,'2026-02-20 09:57:29',1,1),('b42141af-c578-4cde-a328-79351c04a8c8','tempest-GroupSnapshotsTest-group-type-2146712363',NULL,'2026-02-20 09:55:13',NULL,'2026-02-20 09:55:20',1,1),('f91e2ac3-ef85-45d0-a9a3-1e409f9239f6','b_tempest-group-type-100514641',NULL,'2026-02-20 09:57:29',NULL,'2026-02-20 09:57:29',1,0);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
INSERT INTO `group_volume_type_mapping` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_type_id`, `group_id`) VALUES ('2026-02-20 09:54:41',NULL,'2026-02-20 09:54:53',1,1,'b0ad793f-edef-47f4-a688-78153e5d36ea','72ffb4ea-d9e9-4d05-8e08-0868a8a71a9e'),('2026-02-20 09:54:46',NULL,'2026-02-20 09:54:49',1,2,'b0ad793f-edef-47f4-a688-78153e5d36ea','22246b22-9b6c-4a80-afa0-bcae335fa203'),('2026-02-20 09:54:54',NULL,'2026-02-20 09:55:12',1,3,'9fbc5f58-7d77-4e9c-a111-2ee5ce9db580','21a6bf48-fb20-49c1-9d06-ca601aa63b63'),('2026-02-20 09:55:13',NULL,'2026-02-20 09:55:19',1,4,'211da78d-0ac0-446b-b9cb-70aa203883c3','523fd1fa-8d01-419d-ba3b-b8e73a667c29'),('2026-02-20 09:56:42',NULL,'2026-02-20 09:56:47',1,5,'91e655c2-f217-4612-bc71-3497021f6790','2f6a6216-769a-49fd-82ac-de23d1290eb2'),('2026-02-20 09:56:43',NULL,'2026-02-20 09:56:48',1,6,'91e655c2-f217-4612-bc71-3497021f6790','e05e07db-b098-4c53-b447-a04ecd61f829'),('2026-02-20 09:56:49',NULL,'2026-02-20 09:56:58',1,7,'519de3af-d85b-4d9a-aac2-b9c51c95164d','60fc2d42-b6dc-47a0-a7e7-6a289a579f14'),('2026-02-20 09:57:05',NULL,'2026-02-20 09:57:06',1,8,'47acb9d3-a1f5-45fa-a58a-6a04937a7a23','d75d35f4-b7a0-45c9-a830-73bebfbb7e76'),('2026-02-20 09:57:29',NULL,'2026-02-20 09:57:36',1,9,'d29ddbab-68de-4b71-aa71-4b968f18ee1d','f34fe2ac-c196-40f5-a2ae-230b5a9a0e69'),('2026-02-20 09:59:24',NULL,'2026-02-20 09:59:30',1,10,'9107e722-35f2-487a-9e8c-688c465ca7e2','c66a2d0e-858d-404d-96f8-5f66c0296e90'),('2026-02-20 09:59:27',NULL,'2026-02-20 09:59:30',1,11,'9107e722-35f2-487a-9e8c-688c465ca7e2','9eebd1ea-aec1-4f10-bc6e-d8327496c1ad');
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
INSERT INTO `groups` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `cluster_name`, `host`, `availability_zone`, `name`, `description`, `group_type_id`, `status`, `group_snapshot_id`, `source_group_id`, `replication_status`) VALUES ('2026-02-20 09:54:54','2026-02-20 09:55:12','2026-02-20 09:55:12',1,'21a6bf48-fb20-49c1-9d06-ca601aa63b63','ffbb979ff9fb4e37a3cdbc9384522ee4','dcc08d5e298941e3a9de201aa565b6a9',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupSnapshotsTest-Group-39902423',NULL,'9ed5cb54-0516-4a76-bcb4-80f5d01b7b51','deleted',NULL,NULL,'disabled'),('2026-02-20 09:54:47','2026-02-20 09:54:49','2026-02-20 09:54:49',1,'22246b22-9b6c-4a80-afa0-bcae335fa203','ffbb979ff9fb4e37a3cdbc9384522ee4','dcc08d5e298941e3a9de201aa565b6a9',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-Group_from_snap-829482295',NULL,'a6efa6d9-64ad-44fb-8540-17c29d407ddf','deleted','6d3f2094-6cff-46a5-aa20-462d7fcbd2e9',NULL,'disabled'),('2026-02-20 09:56:42','2026-02-20 09:56:47','2026-02-20 09:56:47',1,'2f6a6216-769a-49fd-82ac-de23d1290eb2','05feeb2aee824362a8103784cc43648d','fd2fac9a2a1a4fd49d87e5d4ff1b64b3',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-Group1-943317737',NULL,'99160ac6-7af8-4b6e-b057-ce9e8ba1992a','deleted',NULL,NULL,'disabled'),('2026-02-20 09:55:13','2026-02-20 09:55:19','2026-02-20 09:55:19',1,'523fd1fa-8d01-419d-ba3b-b8e73a667c29','ffbb979ff9fb4e37a3cdbc9384522ee4','dcc08d5e298941e3a9de201aa565b6a9',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupSnapshotsTest-Group-1942614881',NULL,'b42141af-c578-4cde-a328-79351c04a8c8','deleted',NULL,NULL,'disabled'),('2026-02-20 09:56:49','2026-02-20 09:56:58','2026-02-20 09:56:58',1,'60fc2d42-b6dc-47a0-a7e7-6a289a579f14','05feeb2aee824362a8103784cc43648d','fd2fac9a2a1a4fd49d87e5d4ff1b64b3',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','new_group','This is a new group','77de15d2-5eb2-4af1-9ccd-5d720043d865','deleted',NULL,NULL,'disabled'),('2026-02-20 09:54:41','2026-02-20 09:54:53','2026-02-20 09:54:53',1,'72ffb4ea-d9e9-4d05-8e08-0868a8a71a9e','ffbb979ff9fb4e37a3cdbc9384522ee4','dcc08d5e298941e3a9de201aa565b6a9',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupSnapshotsTest-Group-708904546',NULL,'a6efa6d9-64ad-44fb-8540-17c29d407ddf','deleted',NULL,NULL,'disabled'),('2026-02-20 09:59:28','2026-02-20 09:59:29','2026-02-20 09:59:30',1,'9eebd1ea-aec1-4f10-bc6e-d8327496c1ad','9b3af574e998460eb018052ec24016f7','4eb963516e994397b5c6f3bb155e8d11',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-Group_from_grp-1641961225',NULL,'1216ed9b-7c30-4d99-802b-a74d6d441172','deleted',NULL,'c66a2d0e-858d-404d-96f8-5f66c0296e90','disabled'),('2026-02-20 09:59:24','2026-02-20 09:59:30','2026-02-20 09:59:30',1,'c66a2d0e-858d-404d-96f8-5f66c0296e90','9b3af574e998460eb018052ec24016f7','4eb963516e994397b5c6f3bb155e8d11',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupsV314Test-Group-729436929',NULL,'1216ed9b-7c30-4d99-802b-a74d6d441172','deleted',NULL,NULL,'disabled'),('2026-02-20 09:57:05','2026-02-20 09:57:06','2026-02-20 09:57:06',1,'d75d35f4-b7a0-45c9-a830-73bebfbb7e76','cdcdf2bba3fc49669c5018aa7c39d281','eee793ed531548448eb1446c169fbf7a',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupsV320Test-Group-773249980',NULL,'98653d59-6b41-44ce-acb4-1ecdacc9615d','deleted',NULL,NULL,'disabled'),('2026-02-20 09:56:43','2026-02-20 09:56:48','2026-02-20 09:56:48',1,'e05e07db-b098-4c53-b447-a04ecd61f829','05feeb2aee824362a8103784cc43648d','fd2fac9a2a1a4fd49d87e5d4ff1b64b3',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-Group2-1708344364',NULL,'99160ac6-7af8-4b6e-b057-ce9e8ba1992a','deleted',NULL,NULL,'disabled'),('2026-02-20 09:57:29','2026-02-20 09:57:35','2026-02-20 09:57:36',1,'f34fe2ac-c196-40f5-a2ae-230b5a9a0e69','64bc298504924a43b95ce2758bfa5477','a48d774a595542e4a66f14036bc080ce',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupSnapshotsV319Test-Group-185698595',NULL,'44fecc21-cb6a-4632-9551-dc2e8548ee33','deleted',NULL,NULL,'disabled');
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_host` (`host`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
INSERT INTO `messages` (`id`, `project_id`, `request_id`, `resource_type`, `resource_uuid`, `event_id`, `message_level`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `expires_at`, `detail_id`, `action_id`) VALUES ('08ce0a55-67e5-4333-8aa1-0305794d0cf8','128736e99cb541468aa88da3588f267d','req-c4440083-bb4e-44fc-8f63-097eec0b3b71','VOLUME','5b8b44ec-5798-44d9-bb77-87a19d8d66be','VOLUME_VOLUME_001_003','ERROR','2026-02-20 09:57:49',NULL,'2026-02-20 09:57:50',1,'2026-03-22 09:57:49','003','001'),('7ae5e2aa-cad8-4409-8396-7f4ef2988a13','128736e99cb541468aa88da3588f267d','req-0a942a53-94a8-4f19-bd12-dced1802fdc1','VOLUME','8d0df121-f82d-4261-88b0-55eaec3e4df8','VOLUME_VOLUME_001_003','ERROR','2026-02-20 09:57:47',NULL,'2026-02-20 09:57:48',1,'2026-03-22 09:57:47','003','001');
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('cinder','/usr/lib/python3.9/site-packages/cinder/db/sqlalchemy/migrate_repo',145);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
INSERT INTO `quality_of_service_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `specs_id`, `key`, `value`) VALUES ('2026-02-20 09:57:36',NULL,'2026-02-20 09:57:36',1,'06a78e9c-e22c-4206-8d51-fcef214343ce',NULL,'QoS_Specs_Name','tempest-QosSpecsTestJSON-qos-175411208'),('2026-02-20 09:57:37',NULL,'2026-02-20 09:57:37',1,'06d48d6e-cc52-4425-84c5-a40b9926420c','e7e5461f-dbb2-43b0-8655-1ef901ddd87c','consumer','front-end'),('2026-02-20 09:57:37',NULL,'2026-02-20 09:57:37',1,'1d46e452-4688-4866-b1ab-deb95ff17017','af7cde60-e4c6-471e-8831-1a232de551fb','consumer','both'),('2026-02-20 09:57:36',NULL,'2026-02-20 09:57:37',1,'2814e8c6-afdf-419c-a708-b725bd76ec67','90ee2eb3-c152-4930-9c76-3a8e4b0f9e7a','read_iops_sec','2000'),('2026-02-20 09:57:36',NULL,'2026-02-20 09:57:37',1,'6093484e-349a-4b81-9eb6-c6602903309b','90ee2eb3-c152-4930-9c76-3a8e4b0f9e7a','consumer','front-end'),('2026-02-20 09:57:36',NULL,'2026-02-20 09:57:37',1,'90ee2eb3-c152-4930-9c76-3a8e4b0f9e7a',NULL,'QoS_Specs_Name','tempest-QosSpecsTestJSON-QoS-229121553'),('2026-02-20 09:57:37',NULL,'2026-02-20 09:57:37',1,'ad375971-a681-4ed6-803a-47dcb82f807c','90ee2eb3-c152-4930-9c76-3a8e4b0f9e7a','iops_bytes','500'),('2026-02-20 09:57:37',NULL,'2026-02-20 09:57:37',1,'af7cde60-e4c6-471e-8831-1a232de551fb',NULL,'QoS_Specs_Name','tempest-QosSpecsTestJSON-qos-1038000454'),('2026-02-20 09:57:37',NULL,'2026-02-20 09:57:37',1,'e7e5461f-dbb2-43b0-8655-1ef901ddd87c',NULL,'QoS_Specs_Name','tempest-QosSpecsTestJSON-qos-1574986772'),('2026-02-20 09:57:36',NULL,'2026-02-20 09:57:36',1,'ec100f28-3c8b-48cb-bdf5-93707c60c1d4','06a78e9c-e22c-4206-8d51-fcef214343ce','consumer','back-end');
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2026-02-20 08:05:38','2026-02-20 09:55:27',NULL,0,2,'default','volumes',10),('2026-02-20 08:05:38','2026-02-20 09:55:27',NULL,0,5,'default','snapshots',10),('2026-02-20 08:05:38','2026-02-20 09:55:27',NULL,0,8,'default','gigabytes',1000),('2026-02-20 08:05:38',NULL,NULL,0,11,'default','consistencygroups',10),('2026-02-20 08:05:38',NULL,NULL,0,14,'default','per_volume_gigabytes',-1),('2026-02-20 08:05:38',NULL,NULL,0,17,'default','groups',10),('2026-02-20 09:55:27','2026-02-20 09:55:27',NULL,0,20,'default','backups',10),('2026-02-20 09:55:27','2026-02-20 09:55:27',NULL,0,21,'default','backup_gigabytes',1000),('2026-02-20 09:55:27',NULL,NULL,0,22,'default','volumes_tempest-VolumeQuotaClassesTest-volume-type-2090279830',7),('2026-02-20 09:55:27',NULL,NULL,0,23,'default','snapshots_tempest-VolumeQuotaClassesTest-volume-type-2090279830',4),('2026-02-20 09:55:27',NULL,NULL,0,24,'default','gigabytes_tempest-VolumeQuotaClassesTest-volume-type-2090279830',8);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `quota_usages_project_id_key` (`project_id`,`resource`,`race_preventer`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=224 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `race_preventer`) VALUES ('2026-02-20 09:53:51','2026-02-20 09:54:08',NULL,0,1,'ceda6d23d7184b90ba109505854d972f','volumes',0,0,NULL,1),('2026-02-20 09:53:51','2026-02-20 09:54:08',NULL,0,2,'ceda6d23d7184b90ba109505854d972f','gigabytes',0,0,NULL,1),('2026-02-20 09:53:51','2026-02-20 09:54:08',NULL,0,3,'ceda6d23d7184b90ba109505854d972f','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:53:51','2026-02-20 09:54:08',NULL,0,4,'ceda6d23d7184b90ba109505854d972f','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:53:57','2026-02-20 09:54:06',NULL,0,5,'22b016cf9f2d403d952239fb4ab79c4a','volumes',0,0,NULL,1),('2026-02-20 09:53:57','2026-02-20 09:54:06',NULL,0,6,'22b016cf9f2d403d952239fb4ab79c4a','gigabytes',0,0,NULL,1),('2026-02-20 09:53:57','2026-02-20 09:54:06',NULL,0,7,'22b016cf9f2d403d952239fb4ab79c4a','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:53:57','2026-02-20 09:54:06',NULL,0,8,'22b016cf9f2d403d952239fb4ab79c4a','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:54:17','2026-02-20 09:54:19',NULL,0,9,'c11d214ddb8444b499694b7fa72c8896','volumes',0,0,NULL,1),('2026-02-20 09:54:17','2026-02-20 09:54:19',NULL,0,10,'c11d214ddb8444b499694b7fa72c8896','gigabytes',0,0,NULL,1),('2026-02-20 09:54:17','2026-02-20 09:54:19',NULL,0,11,'c11d214ddb8444b499694b7fa72c8896','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:54:17','2026-02-20 09:54:19',NULL,0,12,'c11d214ddb8444b499694b7fa72c8896','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:54:29','2026-02-20 09:54:39',NULL,0,13,'416b8c7a0c6f48629bf55e44152bc962','volumes',0,0,NULL,1),('2026-02-20 09:54:29','2026-02-20 09:54:39',NULL,0,14,'416b8c7a0c6f48629bf55e44152bc962','gigabytes',0,0,NULL,1),('2026-02-20 09:54:29','2026-02-20 09:54:39',NULL,0,15,'416b8c7a0c6f48629bf55e44152bc962','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:54:29','2026-02-20 09:54:39',NULL,0,16,'416b8c7a0c6f48629bf55e44152bc962','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:54:41','2026-02-20 09:55:19',NULL,0,17,'dcc08d5e298941e3a9de201aa565b6a9','groups',0,0,NULL,1),('2026-02-20 09:54:43','2026-02-20 09:55:19',NULL,0,18,'dcc08d5e298941e3a9de201aa565b6a9','volumes',0,0,NULL,1),('2026-02-20 09:54:43','2026-02-20 09:55:19',NULL,0,19,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes',0,0,NULL,1),('2026-02-20 09:54:43','2026-02-20 09:54:53',NULL,0,20,'dcc08d5e298941e3a9de201aa565b6a9','volumes_tempest-GroupSnapshotsTest-volume-type-1659843599',0,0,NULL,1),('2026-02-20 09:54:43','2026-02-20 09:54:52',NULL,0,21,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes_tempest-GroupSnapshotsTest-volume-type-1659843599',0,0,NULL,1),('2026-02-20 09:54:44','2026-02-20 09:55:18',NULL,0,22,'dcc08d5e298941e3a9de201aa565b6a9','snapshots',0,0,NULL,1),('2026-02-20 09:54:44','2026-02-20 09:54:52',NULL,0,23,'dcc08d5e298941e3a9de201aa565b6a9','snapshots_tempest-GroupSnapshotsTest-volume-type-1659843599',0,0,NULL,1),('2026-02-20 09:54:55','2026-02-20 09:55:12',NULL,0,24,'dcc08d5e298941e3a9de201aa565b6a9','volumes_tempest-GroupSnapshotsTest-volume-type-2074118595',0,0,NULL,1),('2026-02-20 09:54:55','2026-02-20 09:55:12',NULL,0,25,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes_tempest-GroupSnapshotsTest-volume-type-2074118595',0,0,NULL,1),('2026-02-20 09:55:03','2026-02-20 09:55:09',NULL,0,26,'dcc08d5e298941e3a9de201aa565b6a9','snapshots_tempest-GroupSnapshotsTest-volume-type-2074118595',0,0,NULL,1),('2026-02-20 09:55:14','2026-02-20 09:55:19',NULL,0,27,'dcc08d5e298941e3a9de201aa565b6a9','volumes_tempest-GroupSnapshotsTest-volume-type-247800390',0,0,NULL,1),('2026-02-20 09:55:14','2026-02-20 09:55:19',NULL,0,28,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes_tempest-GroupSnapshotsTest-volume-type-247800390',0,0,NULL,1),('2026-02-20 09:55:15','2026-02-20 09:55:18',NULL,0,29,'dcc08d5e298941e3a9de201aa565b6a9','snapshots_tempest-GroupSnapshotsTest-volume-type-247800390',0,0,NULL,1),('2026-02-20 09:55:35','2026-02-20 09:55:37',NULL,0,30,'17f50febac1846c0a653b60a8f30a43a','volumes',0,0,NULL,1),('2026-02-20 09:55:35','2026-02-20 09:55:37',NULL,0,31,'17f50febac1846c0a653b60a8f30a43a','gigabytes',0,0,NULL,1),('2026-02-20 09:55:35','2026-02-20 09:55:37',NULL,0,32,'17f50febac1846c0a653b60a8f30a43a','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:55:35','2026-02-20 09:55:37',NULL,0,33,'17f50febac1846c0a653b60a8f30a43a','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:55:45','2026-02-20 09:55:55',NULL,0,34,'f1d88f620ed14a4da04788bf096bb225','volumes',0,0,NULL,1),('2026-02-20 09:55:45','2026-02-20 09:55:55',NULL,0,35,'f1d88f620ed14a4da04788bf096bb225','gigabytes',0,0,NULL,1),('2026-02-20 09:55:45','2026-02-20 09:55:55',NULL,0,36,'f1d88f620ed14a4da04788bf096bb225','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:55:45','2026-02-20 09:55:55',NULL,0,37,'f1d88f620ed14a4da04788bf096bb225','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:56:02','2026-02-20 09:56:07',NULL,0,38,'50be2d6048314f72aad782543bcc440d','volumes',0,0,NULL,1),('2026-02-20 09:56:02','2026-02-20 09:56:07',NULL,0,39,'50be2d6048314f72aad782543bcc440d','gigabytes',0,0,NULL,1),('2026-02-20 09:56:02','2026-02-20 09:56:07',NULL,0,40,'50be2d6048314f72aad782543bcc440d','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:56:02','2026-02-20 09:56:07',NULL,0,41,'50be2d6048314f72aad782543bcc440d','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:56:03','2026-02-20 09:56:04',NULL,0,42,'ffe95c3ecb8041f08ab64f85fb74a65b','volumes',0,0,NULL,1),('2026-02-20 09:56:03','2026-02-20 09:56:04',NULL,0,43,'ffe95c3ecb8041f08ab64f85fb74a65b','gigabytes',0,0,NULL,1),('2026-02-20 09:56:03','2026-02-20 09:56:04',NULL,0,44,'ffe95c3ecb8041f08ab64f85fb74a65b','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:56:03','2026-02-20 09:56:04',NULL,0,45,'ffe95c3ecb8041f08ab64f85fb74a65b','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:56:03',NULL,NULL,0,46,'ffe95c3ecb8041f08ab64f85fb74a65b','snapshots',0,0,NULL,1),('2026-02-20 09:56:03',NULL,NULL,0,47,'ffe95c3ecb8041f08ab64f85fb74a65b','snapshots_tripleo',0,0,NULL,1),('2026-02-20 09:56:03',NULL,NULL,0,48,'50be2d6048314f72aad782543bcc440d','snapshots',0,0,NULL,1),('2026-02-20 09:56:03',NULL,NULL,0,49,'50be2d6048314f72aad782543bcc440d','snapshots_tripleo',0,0,NULL,1),('2026-02-20 09:56:15','2026-02-20 09:56:20',NULL,0,50,'8b33a3c1c64247628d4927f39794f13e','volumes',0,0,NULL,1),('2026-02-20 09:56:15','2026-02-20 09:56:20',NULL,0,51,'8b33a3c1c64247628d4927f39794f13e','gigabytes',0,0,NULL,1),('2026-02-20 09:56:15','2026-02-20 09:56:20',NULL,0,52,'8b33a3c1c64247628d4927f39794f13e','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:56:15','2026-02-20 09:56:20',NULL,0,53,'8b33a3c1c64247628d4927f39794f13e','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:56:16','2026-02-20 09:56:17',NULL,0,54,'1eff39cdacfd4eb28de1fa5742b73d15','volumes',0,0,NULL,1),('2026-02-20 09:56:16','2026-02-20 09:56:17',NULL,0,55,'1eff39cdacfd4eb28de1fa5742b73d15','gigabytes',0,0,NULL,1),('2026-02-20 09:56:16','2026-02-20 09:56:17',NULL,0,56,'1eff39cdacfd4eb28de1fa5742b73d15','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:56:16','2026-02-20 09:56:17',NULL,0,57,'1eff39cdacfd4eb28de1fa5742b73d15','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:56:17',NULL,NULL,0,58,'1eff39cdacfd4eb28de1fa5742b73d15','snapshots',0,0,NULL,1),('2026-02-20 09:56:17',NULL,NULL,0,59,'1eff39cdacfd4eb28de1fa5742b73d15','snapshots_tripleo',0,0,NULL,1),('2026-02-20 09:56:17',NULL,NULL,0,60,'8b33a3c1c64247628d4927f39794f13e','snapshots',0,0,NULL,1),('2026-02-20 09:56:17',NULL,NULL,0,61,'8b33a3c1c64247628d4927f39794f13e','snapshots_tripleo',0,0,NULL,1),('2026-02-20 09:56:29','2026-02-20 09:56:40',NULL,0,62,'226ab368400e4186b91e98a77b240268','volumes',0,0,NULL,1),('2026-02-20 09:56:29','2026-02-20 09:56:40',NULL,0,63,'226ab368400e4186b91e98a77b240268','gigabytes',0,0,NULL,1),('2026-02-20 09:56:29','2026-02-20 09:56:40',NULL,0,64,'226ab368400e4186b91e98a77b240268','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:56:29','2026-02-20 09:56:40',NULL,0,65,'226ab368400e4186b91e98a77b240268','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:56:31','2026-02-20 09:56:39',NULL,0,66,'226ab368400e4186b91e98a77b240268','backups',0,0,NULL,1),('2026-02-20 09:56:31','2026-02-20 09:56:39',NULL,0,67,'226ab368400e4186b91e98a77b240268','backup_gigabytes',0,0,NULL,1),('2026-02-20 09:56:33','2026-02-20 09:56:38',NULL,0,68,'6b6c3ea6fad948cbaee73bff3485d7da','volumes',0,0,NULL,1),('2026-02-20 09:56:33','2026-02-20 09:56:38',NULL,0,69,'6b6c3ea6fad948cbaee73bff3485d7da','gigabytes',0,0,NULL,1),('2026-02-20 09:56:33','2026-02-20 09:56:38',NULL,0,70,'6b6c3ea6fad948cbaee73bff3485d7da','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:56:33','2026-02-20 09:56:38',NULL,0,71,'6b6c3ea6fad948cbaee73bff3485d7da','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:56:35','2026-02-20 09:56:37',NULL,0,72,'6b6c3ea6fad948cbaee73bff3485d7da','snapshots',0,0,NULL,1),('2026-02-20 09:56:35','2026-02-20 09:56:37',NULL,0,73,'6b6c3ea6fad948cbaee73bff3485d7da','snapshots_tripleo',0,0,NULL,1),('2026-02-20 09:56:42','2026-02-20 09:56:58',NULL,0,74,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','groups',0,0,NULL,1),('2026-02-20 09:56:44','2026-02-20 09:56:59',NULL,0,75,'c415a23ac6624be8b258d5fae2607759','volumes',0,0,NULL,1),('2026-02-20 09:56:44','2026-02-20 09:56:59',NULL,0,76,'c415a23ac6624be8b258d5fae2607759','gigabytes',0,0,NULL,1),('2026-02-20 09:56:44','2026-02-20 09:56:59',NULL,0,77,'c415a23ac6624be8b258d5fae2607759','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:56:44','2026-02-20 09:56:59',NULL,0,78,'c415a23ac6624be8b258d5fae2607759','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:56:44','2026-02-20 09:57:00',NULL,0,79,'63c8b3e7b8b445b68b501883951607d3','volumes',0,0,NULL,1),('2026-02-20 09:56:44','2026-02-20 09:57:00',NULL,0,80,'63c8b3e7b8b445b68b501883951607d3','gigabytes',0,0,NULL,1),('2026-02-20 09:56:44','2026-02-20 09:57:00',NULL,0,81,'63c8b3e7b8b445b68b501883951607d3','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:56:44','2026-02-20 09:57:00',NULL,0,82,'63c8b3e7b8b445b68b501883951607d3','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:56:45','2026-02-20 09:56:58',NULL,0,83,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','volumes',0,0,NULL,1),('2026-02-20 09:56:45','2026-02-20 09:56:58',NULL,0,84,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','gigabytes',0,0,NULL,1),('2026-02-20 09:56:45','2026-02-20 09:56:47',NULL,0,85,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','volumes_tempest-GroupsTest-volume-type-1805649748',0,0,NULL,1),('2026-02-20 09:56:45','2026-02-20 09:56:47',NULL,0,86,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','gigabytes_tempest-GroupsTest-volume-type-1805649748',0,0,NULL,1),('2026-02-20 09:56:50','2026-02-20 09:56:58',NULL,0,87,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','volumes_tempest-GroupsTest-volume-type-1756718363',0,0,NULL,1),('2026-02-20 09:56:50','2026-02-20 09:56:58',NULL,0,88,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','gigabytes_tempest-GroupsTest-volume-type-1756718363',0,0,NULL,1),('2026-02-20 09:56:54','2026-02-20 09:56:57',NULL,0,89,'c415a23ac6624be8b258d5fae2607759','snapshots',0,0,NULL,1),('2026-02-20 09:56:54','2026-02-20 09:56:57',NULL,0,90,'c415a23ac6624be8b258d5fae2607759','snapshots_tripleo',0,0,NULL,1),('2026-02-20 09:57:05','2026-02-20 09:57:06',NULL,0,91,'eee793ed531548448eb1446c169fbf7a','groups',0,0,NULL,1),('2026-02-20 09:57:05','2026-02-20 09:57:27',NULL,0,92,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes',0,0,NULL,1),('2026-02-20 09:57:05','2026-02-20 09:57:27',NULL,0,93,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes',0,0,NULL,1),('2026-02-20 09:57:05','2026-02-20 09:57:27',NULL,0,94,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:57:05','2026-02-20 09:57:27',NULL,0,95,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:57:12','2026-02-20 09:57:33',NULL,0,96,'b937092feb204d07b7daa9302db5204f','volumes',0,0,NULL,1),('2026-02-20 09:57:12','2026-02-20 09:57:33',NULL,0,97,'b937092feb204d07b7daa9302db5204f','gigabytes',0,0,NULL,1),('2026-02-20 09:57:12','2026-02-20 09:57:33',NULL,0,98,'b937092feb204d07b7daa9302db5204f','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:57:12','2026-02-20 09:57:33',NULL,0,99,'b937092feb204d07b7daa9302db5204f','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:57:14','2026-02-20 09:57:32',NULL,0,100,'b937092feb204d07b7daa9302db5204f','snapshots',0,0,NULL,1),('2026-02-20 09:57:14','2026-02-20 09:57:32',NULL,0,101,'b937092feb204d07b7daa9302db5204f','snapshots_tripleo',0,0,NULL,1),('2026-02-20 09:57:29','2026-02-20 09:57:36',NULL,0,102,'a48d774a595542e4a66f14036bc080ce','groups',0,0,NULL,1),('2026-02-20 09:57:30','2026-02-20 09:57:36',NULL,0,103,'a48d774a595542e4a66f14036bc080ce','volumes',0,0,NULL,1),('2026-02-20 09:57:30','2026-02-20 09:57:36',NULL,0,104,'a48d774a595542e4a66f14036bc080ce','gigabytes',0,0,NULL,1),('2026-02-20 09:57:30','2026-02-20 09:57:36',NULL,0,105,'a48d774a595542e4a66f14036bc080ce','volumes_tempest-GroupSnapshotsV319Test-volume-type-1380989222',0,0,NULL,1),('2026-02-20 09:57:30','2026-02-20 09:57:36',NULL,0,106,'a48d774a595542e4a66f14036bc080ce','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-1380989222',0,0,NULL,1),('2026-02-20 09:57:32','2026-02-20 09:57:34',NULL,0,107,'a48d774a595542e4a66f14036bc080ce','snapshots',0,0,NULL,1),('2026-02-20 09:57:32','2026-02-20 09:57:34',NULL,0,108,'a48d774a595542e4a66f14036bc080ce','snapshots_tempest-GroupSnapshotsV319Test-volume-type-1380989222',0,0,NULL,1),('2026-02-20 09:57:47','2026-02-20 09:57:50',NULL,0,109,'128736e99cb541468aa88da3588f267d','volumes',0,0,NULL,1),('2026-02-20 09:57:47','2026-02-20 09:57:50',NULL,0,110,'128736e99cb541468aa88da3588f267d','gigabytes',0,0,NULL,1),('2026-02-20 09:57:47','2026-02-20 09:57:49',NULL,0,111,'128736e99cb541468aa88da3588f267d','volumes_tempest-UserMessagesTest-volume-type-507641628',0,0,NULL,1),('2026-02-20 09:57:47','2026-02-20 09:57:49',NULL,0,112,'128736e99cb541468aa88da3588f267d','gigabytes_tempest-UserMessagesTest-volume-type-507641628',0,0,NULL,1),('2026-02-20 09:57:49','2026-02-20 09:57:50',NULL,0,113,'128736e99cb541468aa88da3588f267d','volumes_tempest-UserMessagesTest-volume-type-1936315209',0,0,NULL,1),('2026-02-20 09:57:49','2026-02-20 09:57:50',NULL,0,114,'128736e99cb541468aa88da3588f267d','gigabytes_tempest-UserMessagesTest-volume-type-1936315209',0,0,NULL,1),('2026-02-20 09:57:51','2026-02-20 09:57:56',NULL,0,115,'51750f18434b4b60802ec6c49b096963','volumes',0,0,NULL,1),('2026-02-20 09:57:51','2026-02-20 09:57:56',NULL,0,116,'51750f18434b4b60802ec6c49b096963','gigabytes',0,0,NULL,1),('2026-02-20 09:57:51','2026-02-20 09:57:56',NULL,0,117,'51750f18434b4b60802ec6c49b096963','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:57:51','2026-02-20 09:57:56',NULL,0,118,'51750f18434b4b60802ec6c49b096963','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:57:52','2026-02-20 09:57:55',NULL,0,119,'51750f18434b4b60802ec6c49b096963','snapshots',0,0,NULL,1),('2026-02-20 09:57:52','2026-02-20 09:57:55',NULL,0,120,'51750f18434b4b60802ec6c49b096963','snapshots_tripleo',0,0,NULL,1),('2026-02-20 09:58:01','2026-02-20 09:58:03',NULL,0,121,'0507ba67b65244e7a826c6949689a381','volumes',0,0,NULL,1),('2026-02-20 09:58:01','2026-02-20 09:58:03',NULL,0,122,'0507ba67b65244e7a826c6949689a381','gigabytes',0,0,NULL,1),('2026-02-20 09:58:01','2026-02-20 09:58:03',NULL,0,123,'0507ba67b65244e7a826c6949689a381','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:58:01','2026-02-20 09:58:03',NULL,0,124,'0507ba67b65244e7a826c6949689a381','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:58:03','2026-02-20 09:58:07',NULL,0,125,'d0fbb54da9274272b09aae9be8d15d07','volumes',0,0,NULL,1),('2026-02-20 09:58:03','2026-02-20 09:58:07',NULL,0,126,'d0fbb54da9274272b09aae9be8d15d07','gigabytes',0,0,NULL,1),('2026-02-20 09:58:03','2026-02-20 09:58:07',NULL,0,127,'d0fbb54da9274272b09aae9be8d15d07','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:58:03','2026-02-20 09:58:07',NULL,0,128,'d0fbb54da9274272b09aae9be8d15d07','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:58:07','2026-02-20 09:58:07',NULL,0,129,'c6099dcc2ecd4794925d1793d1a2a72c','volumes',0,0,NULL,1),('2026-02-20 09:58:07','2026-02-20 09:58:07',NULL,0,130,'c6099dcc2ecd4794925d1793d1a2a72c','gigabytes',0,0,NULL,1),('2026-02-20 09:58:07','2026-02-20 09:58:07',NULL,0,131,'c6099dcc2ecd4794925d1793d1a2a72c','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:58:07','2026-02-20 09:58:07',NULL,0,132,'c6099dcc2ecd4794925d1793d1a2a72c','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:58:07',NULL,NULL,0,133,'c6099dcc2ecd4794925d1793d1a2a72c','snapshots',0,0,NULL,1),('2026-02-20 09:58:07',NULL,NULL,0,134,'c6099dcc2ecd4794925d1793d1a2a72c','snapshots_tripleo',0,0,NULL,1),('2026-02-20 09:58:07',NULL,NULL,0,135,'d0fbb54da9274272b09aae9be8d15d07','snapshots',0,0,NULL,1),('2026-02-20 09:58:07',NULL,NULL,0,136,'d0fbb54da9274272b09aae9be8d15d07','snapshots_tripleo',0,0,NULL,1),('2026-02-20 09:58:08','2026-02-20 09:58:28',NULL,0,137,'8a43ccd6212d4626a208a271337f7a5b','volumes',0,0,NULL,1),('2026-02-20 09:58:08','2026-02-20 09:58:28',NULL,0,138,'8a43ccd6212d4626a208a271337f7a5b','gigabytes',0,0,NULL,1),('2026-02-20 09:58:08','2026-02-20 09:58:28',NULL,0,139,'8a43ccd6212d4626a208a271337f7a5b','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:58:08','2026-02-20 09:58:28',NULL,0,140,'8a43ccd6212d4626a208a271337f7a5b','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:58:10','2026-02-20 09:58:26',NULL,0,141,'8a43ccd6212d4626a208a271337f7a5b','snapshots',0,0,NULL,1),('2026-02-20 09:58:10','2026-02-20 09:58:26',NULL,0,142,'8a43ccd6212d4626a208a271337f7a5b','snapshots_tripleo',0,0,NULL,1),('2026-02-20 09:58:16','2026-02-20 09:58:18',NULL,0,143,'b39170cd6b2b43fa90080079febc7f43','volumes',0,0,NULL,1),('2026-02-20 09:58:16','2026-02-20 09:58:18',NULL,0,144,'b39170cd6b2b43fa90080079febc7f43','gigabytes',0,0,NULL,1),('2026-02-20 09:58:16','2026-02-20 09:58:18',NULL,0,145,'b39170cd6b2b43fa90080079febc7f43','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:58:16','2026-02-20 09:58:18',NULL,0,146,'b39170cd6b2b43fa90080079febc7f43','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:58:20','2026-02-20 09:58:33',NULL,0,147,'d0e47cd34a784cbb89cbe56eafed5650','volumes',0,0,NULL,1),('2026-02-20 09:58:20','2026-02-20 09:58:33',NULL,0,148,'d0e47cd34a784cbb89cbe56eafed5650','gigabytes',0,0,NULL,1),('2026-02-20 09:58:20','2026-02-20 09:58:33',NULL,0,149,'d0e47cd34a784cbb89cbe56eafed5650','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:58:20','2026-02-20 09:58:33',NULL,0,150,'d0e47cd34a784cbb89cbe56eafed5650','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:58:43','2026-02-20 09:59:39',NULL,0,151,'68573218a6b141beb49fbacc5b306c7d','volumes',0,0,NULL,1),('2026-02-20 09:58:43','2026-02-20 09:59:39',NULL,0,152,'68573218a6b141beb49fbacc5b306c7d','gigabytes',0,0,NULL,1),('2026-02-20 09:58:43','2026-02-20 09:59:39',NULL,0,153,'68573218a6b141beb49fbacc5b306c7d','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:58:43','2026-02-20 09:59:39',NULL,0,154,'68573218a6b141beb49fbacc5b306c7d','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:58:48','2026-02-20 10:00:37',NULL,0,155,'9fdf2c09b98d48c0bc67cc1c7702a8f4','volumes',0,0,NULL,1),('2026-02-20 09:58:48','2026-02-20 10:00:37',NULL,0,156,'9fdf2c09b98d48c0bc67cc1c7702a8f4','gigabytes',0,0,NULL,1),('2026-02-20 09:58:48','2026-02-20 10:00:37',NULL,0,157,'9fdf2c09b98d48c0bc67cc1c7702a8f4','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:58:48','2026-02-20 10:00:37',NULL,0,158,'9fdf2c09b98d48c0bc67cc1c7702a8f4','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:58:53','2026-02-20 09:59:27',NULL,0,159,'dc400fd7b37f468c83d54846895b6cba','volumes',0,0,NULL,1),('2026-02-20 09:58:53','2026-02-20 09:59:27',NULL,0,160,'dc400fd7b37f468c83d54846895b6cba','gigabytes',0,0,NULL,1),('2026-02-20 09:58:53','2026-02-20 09:59:27',NULL,0,161,'dc400fd7b37f468c83d54846895b6cba','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:58:53','2026-02-20 09:59:27',NULL,0,162,'dc400fd7b37f468c83d54846895b6cba','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:58:55','2026-02-20 09:59:24',NULL,0,163,'dc400fd7b37f468c83d54846895b6cba','backups',0,0,NULL,1),('2026-02-20 09:58:55','2026-02-20 09:59:24',NULL,0,164,'dc400fd7b37f468c83d54846895b6cba','backup_gigabytes',0,0,NULL,1),('2026-02-20 09:58:55','2026-02-20 10:00:27',NULL,0,165,'9fdf2c09b98d48c0bc67cc1c7702a8f4','backups',0,0,NULL,1),('2026-02-20 09:58:55','2026-02-20 10:00:27',NULL,0,166,'9fdf2c09b98d48c0bc67cc1c7702a8f4','backup_gigabytes',0,0,NULL,1),('2026-02-20 09:58:59','2026-02-20 09:59:08',NULL,0,167,'4208cd0fbab541f399d332d0956cc0d5','backups',0,0,NULL,1),('2026-02-20 09:58:59','2026-02-20 09:59:08',NULL,0,168,'4208cd0fbab541f399d332d0956cc0d5','backup_gigabytes',0,0,NULL,1),('2026-02-20 09:59:24','2026-02-20 09:59:30',NULL,0,169,'4eb963516e994397b5c6f3bb155e8d11','groups',0,0,NULL,1),('2026-02-20 09:59:26','2026-02-20 09:59:30',NULL,0,170,'4eb963516e994397b5c6f3bb155e8d11','volumes',0,0,NULL,1),('2026-02-20 09:59:26','2026-02-20 09:59:30',NULL,0,171,'4eb963516e994397b5c6f3bb155e8d11','gigabytes',0,0,NULL,1),('2026-02-20 09:59:26','2026-02-20 09:59:30',NULL,0,172,'4eb963516e994397b5c6f3bb155e8d11','volumes_tempest-GroupsV314Test-volume-type-940356249',0,0,NULL,1),('2026-02-20 09:59:26','2026-02-20 09:59:30',NULL,0,173,'4eb963516e994397b5c6f3bb155e8d11','gigabytes_tempest-GroupsV314Test-volume-type-940356249',0,0,NULL,1),('2026-02-20 09:59:34','2026-02-20 09:59:36',NULL,0,174,'2cd3436ad8a1427598e20bbea13ed671','volumes',0,0,NULL,1),('2026-02-20 09:59:34','2026-02-20 09:59:36',NULL,0,175,'2cd3436ad8a1427598e20bbea13ed671','gigabytes',0,0,NULL,1),('2026-02-20 09:59:34','2026-02-20 09:59:36',NULL,0,176,'2cd3436ad8a1427598e20bbea13ed671','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:59:34','2026-02-20 09:59:36',NULL,0,177,'2cd3436ad8a1427598e20bbea13ed671','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:59:36','2026-02-20 09:59:39',NULL,0,178,'af7558d3f3e7491c82e203a181c2b164','volumes',0,0,NULL,1),('2026-02-20 09:59:36','2026-02-20 09:59:39',NULL,0,179,'af7558d3f3e7491c82e203a181c2b164','gigabytes',0,0,NULL,1),('2026-02-20 09:59:36','2026-02-20 09:59:38',NULL,0,180,'af7558d3f3e7491c82e203a181c2b164','volumes_volume-type-1',0,0,NULL,1),('2026-02-20 09:59:36','2026-02-20 09:59:38',NULL,0,181,'af7558d3f3e7491c82e203a181c2b164','gigabytes_volume-type-1',0,0,NULL,1),('2026-02-20 09:59:37','2026-02-20 09:59:39',NULL,0,182,'af7558d3f3e7491c82e203a181c2b164','volumes_volume-type-2',0,0,NULL,1),('2026-02-20 09:59:37','2026-02-20 09:59:39',NULL,0,183,'af7558d3f3e7491c82e203a181c2b164','gigabytes_volume-type-2',0,0,NULL,1),('2026-02-20 09:59:41','2026-02-20 09:59:46',NULL,0,184,'f47cf27181924d37b1f66305014193c3','volumes',0,0,NULL,1),('2026-02-20 09:59:41','2026-02-20 09:59:46',NULL,0,185,'f47cf27181924d37b1f66305014193c3','gigabytes',0,0,NULL,1),('2026-02-20 09:59:41','2026-02-20 09:59:46',NULL,0,186,'f47cf27181924d37b1f66305014193c3','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:59:41','2026-02-20 09:59:46',NULL,0,187,'f47cf27181924d37b1f66305014193c3','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:59:43','2026-02-20 09:59:44',NULL,0,188,'6191d07901a6491993d029fffa6c4d91','volumes',0,0,NULL,1),('2026-02-20 09:59:43','2026-02-20 09:59:44',NULL,0,189,'6191d07901a6491993d029fffa6c4d91','gigabytes',0,0,NULL,1),('2026-02-20 09:59:43','2026-02-20 09:59:44',NULL,0,190,'6191d07901a6491993d029fffa6c4d91','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:59:43','2026-02-20 09:59:44',NULL,0,191,'6191d07901a6491993d029fffa6c4d91','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:59:43',NULL,NULL,0,192,'6191d07901a6491993d029fffa6c4d91','snapshots',0,0,NULL,1),('2026-02-20 09:59:43',NULL,NULL,0,193,'6191d07901a6491993d029fffa6c4d91','snapshots_tripleo',0,0,NULL,1),('2026-02-20 09:59:43',NULL,NULL,0,194,'f47cf27181924d37b1f66305014193c3','snapshots',0,0,NULL,1),('2026-02-20 09:59:43',NULL,NULL,0,195,'f47cf27181924d37b1f66305014193c3','snapshots_tripleo',0,0,NULL,1),('2026-02-20 09:59:45','2026-02-20 09:59:53',NULL,0,196,'d8d571d58a9b4b3cb35695d51c9ad2dc','volumes',0,0,NULL,1),('2026-02-20 09:59:45','2026-02-20 09:59:53',NULL,0,197,'d8d571d58a9b4b3cb35695d51c9ad2dc','gigabytes',0,0,NULL,1),('2026-02-20 09:59:45','2026-02-20 09:59:53',NULL,0,198,'d8d571d58a9b4b3cb35695d51c9ad2dc','volumes_tripleo',0,0,NULL,1),('2026-02-20 09:59:45','2026-02-20 09:59:53',NULL,0,199,'d8d571d58a9b4b3cb35695d51c9ad2dc','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 09:59:46','2026-02-20 09:59:48',NULL,0,200,'647a6092d7ca4d98a6d581a879bbcbac','volumes',0,0,NULL,1),('2026-02-20 09:59:46','2026-02-20 09:59:48',NULL,0,201,'647a6092d7ca4d98a6d581a879bbcbac','gigabytes',0,0,NULL,1),('2026-02-20 09:59:46','2026-02-20 09:59:48',NULL,0,202,'647a6092d7ca4d98a6d581a879bbcbac','volumes_tempest-VolumeTypesAccessTest-volume-type-761717452',0,0,NULL,1),('2026-02-20 09:59:46','2026-02-20 09:59:48',NULL,0,203,'647a6092d7ca4d98a6d581a879bbcbac','gigabytes_tempest-VolumeTypesAccessTest-volume-type-761717452',0,0,NULL,1),('2026-02-20 10:00:06','2026-02-20 10:00:49',NULL,0,204,'55965a8332c94f2da5d707adc081ab9c','volumes',0,0,NULL,1),('2026-02-20 10:00:06','2026-02-20 10:00:49',NULL,0,205,'55965a8332c94f2da5d707adc081ab9c','gigabytes',0,0,NULL,1),('2026-02-20 10:00:06','2026-02-20 10:00:49',NULL,0,206,'55965a8332c94f2da5d707adc081ab9c','volumes_tripleo',0,0,NULL,1),('2026-02-20 10:00:06','2026-02-20 10:00:49',NULL,0,207,'55965a8332c94f2da5d707adc081ab9c','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 10:00:07','2026-02-20 10:00:47',NULL,0,208,'55965a8332c94f2da5d707adc081ab9c','snapshots',0,0,NULL,1),('2026-02-20 10:00:07','2026-02-20 10:00:47',NULL,0,209,'55965a8332c94f2da5d707adc081ab9c','snapshots_tripleo',0,0,NULL,1),('2026-02-20 10:00:09','2026-02-20 10:00:26',NULL,0,210,'55965a8332c94f2da5d707adc081ab9c','backups',0,0,NULL,1),('2026-02-20 10:00:09','2026-02-20 10:00:26',NULL,0,211,'55965a8332c94f2da5d707adc081ab9c','backup_gigabytes',0,0,NULL,1),('2026-02-20 10:00:56','2026-02-20 10:01:08',NULL,0,212,'1effd5c1f8144a25a1cfdcbbbfeeb59f','volumes',0,0,NULL,1),('2026-02-20 10:00:56','2026-02-20 10:01:08',NULL,0,213,'1effd5c1f8144a25a1cfdcbbbfeeb59f','gigabytes',0,0,NULL,1),('2026-02-20 10:00:56','2026-02-20 10:01:08',NULL,0,214,'1effd5c1f8144a25a1cfdcbbbfeeb59f','volumes_tripleo',0,0,NULL,1),('2026-02-20 10:00:56','2026-02-20 10:01:08',NULL,0,215,'1effd5c1f8144a25a1cfdcbbbfeeb59f','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 10:00:57','2026-02-20 10:01:07',NULL,0,216,'1effd5c1f8144a25a1cfdcbbbfeeb59f','snapshots',0,0,NULL,1),('2026-02-20 10:00:57','2026-02-20 10:01:07',NULL,0,217,'1effd5c1f8144a25a1cfdcbbbfeeb59f','snapshots_tripleo',0,0,NULL,1),('2026-02-20 10:01:12','2026-02-20 10:01:16',NULL,0,218,'d3558f588a6e4dd690ecc5be43692a2e','volumes',0,0,NULL,1),('2026-02-20 10:01:12','2026-02-20 10:01:16',NULL,0,219,'d3558f588a6e4dd690ecc5be43692a2e','gigabytes',0,0,NULL,1),('2026-02-20 10:01:12','2026-02-20 10:01:16',NULL,0,220,'d3558f588a6e4dd690ecc5be43692a2e','volumes_tripleo',0,0,NULL,1),('2026-02-20 10:01:12','2026-02-20 10:01:16',NULL,0,221,'d3558f588a6e4dd690ecc5be43692a2e','gigabytes_tripleo',0,0,NULL,1),('2026-02-20 10:01:13','2026-02-20 10:01:15',NULL,0,222,'d3558f588a6e4dd690ecc5be43692a2e','snapshots',0,0,NULL,1),('2026-02-20 10:01:13','2026-02-20 10:01:15',NULL,0,223,'d3558f588a6e4dd690ecc5be43692a2e','snapshots_tripleo',0,0,NULL,1);
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
INSERT INTO `quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `project_id`, `resource`, `hard_limit`, `allocated`) VALUES (1,'2026-02-20 09:57:50','2026-02-20 09:57:57',NULL,0,'51750f18434b4b60802ec6c49b096963','gigabytes',1000,0),(2,'2026-02-20 09:57:50','2026-02-20 09:57:57',NULL,0,'51750f18434b4b60802ec6c49b096963','volumes',10,0),(3,'2026-02-20 09:57:50','2026-02-20 09:57:57',NULL,0,'51750f18434b4b60802ec6c49b096963','snapshots',10,0),(4,'2026-02-20 09:57:57',NULL,NULL,0,'51750f18434b4b60802ec6c49b096963','per_volume_gigabytes',-1,0),(5,'2026-02-20 09:57:57',NULL,NULL,0,'51750f18434b4b60802ec6c49b096963','backups',10,0),(6,'2026-02-20 09:57:57',NULL,NULL,0,'51750f18434b4b60802ec6c49b096963','backup_gigabytes',1000,0),(7,'2026-02-20 09:58:02','2026-02-20 09:58:02','2026-02-20 09:58:02',1,'d0fbb54da9274272b09aae9be8d15d07','volumes',15,0),(8,'2026-02-20 09:58:02','2026-02-20 09:58:08',NULL,0,'d0fbb54da9274272b09aae9be8d15d07','volumes',10,0),(9,'2026-02-20 09:58:02','2026-02-20 09:58:08',NULL,0,'d0fbb54da9274272b09aae9be8d15d07','per_volume_gigabytes',-1,0),(10,'2026-02-20 09:58:02','2026-02-20 09:58:08',NULL,0,'d0fbb54da9274272b09aae9be8d15d07','snapshots',10,0),(11,'2026-02-20 09:58:02','2026-02-20 09:58:08',NULL,0,'d0fbb54da9274272b09aae9be8d15d07','gigabytes',1000,0),(12,'2026-02-20 09:58:02','2026-02-20 09:58:08',NULL,0,'d0fbb54da9274272b09aae9be8d15d07','backups',10,0),(13,'2026-02-20 09:58:02','2026-02-20 09:58:08',NULL,0,'d0fbb54da9274272b09aae9be8d15d07','backup_gigabytes',1000,0),(14,'2026-02-20 09:58:17','2026-02-20 09:58:19',NULL,0,'b39170cd6b2b43fa90080079febc7f43','gigabytes',1000,0),(15,'2026-02-20 09:58:17','2026-02-20 09:58:19',NULL,0,'b39170cd6b2b43fa90080079febc7f43','volumes',10,0),(16,'2026-02-20 09:58:19',NULL,NULL,0,'b39170cd6b2b43fa90080079febc7f43','per_volume_gigabytes',-1,0),(17,'2026-02-20 09:58:19',NULL,NULL,0,'b39170cd6b2b43fa90080079febc7f43','snapshots',10,0),(18,'2026-02-20 09:58:19',NULL,NULL,0,'b39170cd6b2b43fa90080079febc7f43','backups',10,0),(19,'2026-02-20 09:58:19',NULL,NULL,0,'b39170cd6b2b43fa90080079febc7f43','backup_gigabytes',1000,0);
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=925 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `allocated_id`) VALUES ('2026-02-20 09:53:51','2026-02-20 09:53:51','2026-02-20 09:53:51',1,1,'fb2ff115-bf69-4d80-93a0-49b3fa8bbf8c',1,'ceda6d23d7184b90ba109505854d972f','volumes',1,'2026-02-21 09:53:51',NULL),('2026-02-20 09:53:51','2026-02-20 09:53:51','2026-02-20 09:53:51',1,2,'f39781fb-4711-45a7-9508-98dded25b72e',2,'ceda6d23d7184b90ba109505854d972f','gigabytes',1,'2026-02-21 09:53:51',NULL),('2026-02-20 09:53:51','2026-02-20 09:53:51','2026-02-20 09:53:51',1,3,'287af5e7-3bab-4cc3-bb06-282dd28c2f60',3,'ceda6d23d7184b90ba109505854d972f','volumes_tripleo',1,'2026-02-21 09:53:51',NULL),('2026-02-20 09:53:51','2026-02-20 09:53:51','2026-02-20 09:53:51',1,4,'d77a82d6-755a-434c-b2f1-48dbe53d71ec',4,'ceda6d23d7184b90ba109505854d972f','gigabytes_tripleo',1,'2026-02-21 09:53:51',NULL),('2026-02-20 09:53:54','2026-02-20 09:53:54','2026-02-20 09:53:54',1,5,'59c7724d-17c2-46aa-9fd6-3cf27288c187',1,'ceda6d23d7184b90ba109505854d972f','volumes',1,'2026-02-21 09:53:54',NULL),('2026-02-20 09:53:54','2026-02-20 09:53:54','2026-02-20 09:53:54',1,6,'db2193c7-d257-4e80-8907-3869c5b7d816',2,'ceda6d23d7184b90ba109505854d972f','gigabytes',1,'2026-02-21 09:53:54',NULL),('2026-02-20 09:53:54','2026-02-20 09:53:54','2026-02-20 09:53:54',1,7,'47041e12-53bb-4397-a6f1-f98a3d9828bb',3,'ceda6d23d7184b90ba109505854d972f','volumes_tripleo',1,'2026-02-21 09:53:54',NULL),('2026-02-20 09:53:54','2026-02-20 09:53:54','2026-02-20 09:53:54',1,8,'7fe77059-3f38-47af-a53e-c83100c848ad',4,'ceda6d23d7184b90ba109505854d972f','gigabytes_tripleo',1,'2026-02-21 09:53:54',NULL),('2026-02-20 09:53:56','2026-02-20 09:53:56','2026-02-20 09:53:56',1,9,'1e078fba-eb31-4abd-ac03-35df432b0ee0',1,'ceda6d23d7184b90ba109505854d972f','volumes',1,'2026-02-21 09:53:56',NULL),('2026-02-20 09:53:56','2026-02-20 09:53:56','2026-02-20 09:53:56',1,10,'ae868634-c2e6-4a0d-ba2f-d3d71fe2215d',2,'ceda6d23d7184b90ba109505854d972f','gigabytes',1,'2026-02-21 09:53:56',NULL),('2026-02-20 09:53:56','2026-02-20 09:53:56','2026-02-20 09:53:56',1,11,'2c13f920-20ec-4ef0-827d-1f930efc2559',3,'ceda6d23d7184b90ba109505854d972f','volumes_tripleo',1,'2026-02-21 09:53:56',NULL),('2026-02-20 09:53:56','2026-02-20 09:53:56','2026-02-20 09:53:56',1,12,'22454e3b-18f7-4d57-8378-987d69f14f49',4,'ceda6d23d7184b90ba109505854d972f','gigabytes_tripleo',1,'2026-02-21 09:53:56',NULL),('2026-02-20 09:53:57','2026-02-20 09:53:58','2026-02-20 09:53:58',1,13,'997cb251-679b-46b1-9c86-b0b92318f8de',5,'22b016cf9f2d403d952239fb4ab79c4a','volumes',1,'2026-02-21 09:53:57',NULL),('2026-02-20 09:53:57','2026-02-20 09:53:58','2026-02-20 09:53:58',1,14,'35316af5-de7a-481a-afcf-09cf3fcefbfe',6,'22b016cf9f2d403d952239fb4ab79c4a','gigabytes',1,'2026-02-21 09:53:57',NULL),('2026-02-20 09:53:58','2026-02-20 09:53:58','2026-02-20 09:53:58',1,15,'dd8c7705-eb8b-48aa-8c5a-29d7f682a8cb',7,'22b016cf9f2d403d952239fb4ab79c4a','volumes_tripleo',1,'2026-02-21 09:53:57',NULL),('2026-02-20 09:53:58','2026-02-20 09:53:58','2026-02-20 09:53:58',1,16,'7506b970-1641-49d8-a4c8-81e4fddb7e0c',8,'22b016cf9f2d403d952239fb4ab79c4a','gigabytes_tripleo',1,'2026-02-21 09:53:57',NULL),('2026-02-20 09:54:06','2026-02-20 09:54:06','2026-02-20 09:54:06',1,17,'5e9fec0b-9b2a-4d7a-a9c0-6e6f07b17c43',5,'22b016cf9f2d403d952239fb4ab79c4a','volumes',-1,'2026-02-21 09:54:06',NULL),('2026-02-20 09:54:06','2026-02-20 09:54:06','2026-02-20 09:54:06',1,18,'390db36a-1408-40da-80e1-bd882fb4e3b9',6,'22b016cf9f2d403d952239fb4ab79c4a','gigabytes',-1,'2026-02-21 09:54:06',NULL),('2026-02-20 09:54:06','2026-02-20 09:54:06','2026-02-20 09:54:06',1,19,'6930c0a5-b1f3-4218-94c0-b06a5ea63cbb',7,'22b016cf9f2d403d952239fb4ab79c4a','volumes_tripleo',-1,'2026-02-21 09:54:06',NULL),('2026-02-20 09:54:06','2026-02-20 09:54:06','2026-02-20 09:54:06',1,20,'bacce59a-816b-47cb-b116-79cdb9a58e25',8,'22b016cf9f2d403d952239fb4ab79c4a','gigabytes_tripleo',-1,'2026-02-21 09:54:06',NULL),('2026-02-20 09:54:06','2026-02-20 09:54:06','2026-02-20 09:54:06',1,21,'13bff18a-93b8-4d50-87d8-2bed2a629419',1,'ceda6d23d7184b90ba109505854d972f','volumes',-1,'2026-02-21 09:54:06',NULL),('2026-02-20 09:54:06','2026-02-20 09:54:06','2026-02-20 09:54:06',1,22,'25f155f1-6b40-472c-9c71-e58dbeeafa81',2,'ceda6d23d7184b90ba109505854d972f','gigabytes',-1,'2026-02-21 09:54:06',NULL),('2026-02-20 09:54:06','2026-02-20 09:54:06','2026-02-20 09:54:06',1,23,'496c7540-e633-423f-a78e-0685b354289c',3,'ceda6d23d7184b90ba109505854d972f','volumes_tripleo',-1,'2026-02-21 09:54:06',NULL),('2026-02-20 09:54:06','2026-02-20 09:54:06','2026-02-20 09:54:06',1,24,'12e69125-82b8-4ccc-874b-6eae819e43b4',4,'ceda6d23d7184b90ba109505854d972f','gigabytes_tripleo',-1,'2026-02-21 09:54:06',NULL),('2026-02-20 09:54:07','2026-02-20 09:54:07','2026-02-20 09:54:07',1,25,'ee33bbab-5ca9-47b9-8764-80fd0f609713',1,'ceda6d23d7184b90ba109505854d972f','volumes',-1,'2026-02-21 09:54:07',NULL),('2026-02-20 09:54:07','2026-02-20 09:54:07','2026-02-20 09:54:07',1,26,'396820ee-0575-422b-aa8b-b8a2ef80519f',2,'ceda6d23d7184b90ba109505854d972f','gigabytes',-1,'2026-02-21 09:54:07',NULL),('2026-02-20 09:54:07','2026-02-20 09:54:07','2026-02-20 09:54:07',1,27,'ee9239dc-269b-439d-9411-3e6989e568e1',3,'ceda6d23d7184b90ba109505854d972f','volumes_tripleo',-1,'2026-02-21 09:54:07',NULL),('2026-02-20 09:54:07','2026-02-20 09:54:07','2026-02-20 09:54:07',1,28,'5183e8fd-0a15-4fa1-b5d4-6b68b941f78a',4,'ceda6d23d7184b90ba109505854d972f','gigabytes_tripleo',-1,'2026-02-21 09:54:07',NULL),('2026-02-20 09:54:08','2026-02-20 09:54:08','2026-02-20 09:54:08',1,29,'47556065-0707-4d3d-8aaa-7523585075f4',1,'ceda6d23d7184b90ba109505854d972f','volumes',-1,'2026-02-21 09:54:08',NULL),('2026-02-20 09:54:08','2026-02-20 09:54:08','2026-02-20 09:54:08',1,30,'44c509e7-46c3-4349-a79b-e3d2cce638da',2,'ceda6d23d7184b90ba109505854d972f','gigabytes',-1,'2026-02-21 09:54:08',NULL),('2026-02-20 09:54:08','2026-02-20 09:54:08','2026-02-20 09:54:08',1,31,'d7e28e0b-40a0-4150-b4ea-c7c1980629dc',3,'ceda6d23d7184b90ba109505854d972f','volumes_tripleo',-1,'2026-02-21 09:54:08',NULL),('2026-02-20 09:54:08','2026-02-20 09:54:08','2026-02-20 09:54:08',1,32,'3fada90e-fa4e-4c23-85b8-d208ad95ffe6',4,'ceda6d23d7184b90ba109505854d972f','gigabytes_tripleo',-1,'2026-02-21 09:54:08',NULL),('2026-02-20 09:54:17','2026-02-20 09:54:17','2026-02-20 09:54:17',1,33,'1ddddde2-9483-49c7-b80a-4766c4f5e130',9,'c11d214ddb8444b499694b7fa72c8896','volumes',1,'2026-02-21 09:54:17',NULL),('2026-02-20 09:54:17','2026-02-20 09:54:17','2026-02-20 09:54:17',1,34,'0deb0b20-6fb4-4a59-8797-639e5e797614',10,'c11d214ddb8444b499694b7fa72c8896','gigabytes',2,'2026-02-21 09:54:17',NULL),('2026-02-20 09:54:17','2026-02-20 09:54:17','2026-02-20 09:54:17',1,35,'c09412a8-730f-40e7-9edc-07c8f815dff7',11,'c11d214ddb8444b499694b7fa72c8896','volumes_tripleo',1,'2026-02-21 09:54:17',NULL),('2026-02-20 09:54:17','2026-02-20 09:54:17','2026-02-20 09:54:17',1,36,'fa687ce8-049e-4912-9f12-f781539a2145',12,'c11d214ddb8444b499694b7fa72c8896','gigabytes_tripleo',2,'2026-02-21 09:54:17',NULL),('2026-02-20 09:54:19','2026-02-20 09:54:19','2026-02-20 09:54:19',1,37,'7dd156b5-eb19-421e-9d69-bb9d14ac54ca',9,'c11d214ddb8444b499694b7fa72c8896','volumes',-1,'2026-02-21 09:54:19',NULL),('2026-02-20 09:54:19','2026-02-20 09:54:19','2026-02-20 09:54:19',1,38,'7e5799dd-16cd-4580-b6b9-cc588ee55d12',10,'c11d214ddb8444b499694b7fa72c8896','gigabytes',-2,'2026-02-21 09:54:19',NULL),('2026-02-20 09:54:19','2026-02-20 09:54:19','2026-02-20 09:54:19',1,39,'6b25eda1-c118-4c96-bf40-0b90d03c9902',11,'c11d214ddb8444b499694b7fa72c8896','volumes_tripleo',-1,'2026-02-21 09:54:19',NULL),('2026-02-20 09:54:19','2026-02-20 09:54:19','2026-02-20 09:54:19',1,40,'8afaa548-1155-4d56-96ba-a327c51812f2',12,'c11d214ddb8444b499694b7fa72c8896','gigabytes_tripleo',-2,'2026-02-21 09:54:19',NULL),('2026-02-20 09:54:29','2026-02-20 09:54:29','2026-02-20 09:54:29',1,41,'1e51cbbc-877c-43d9-bfd3-ff74d3c172ff',13,'416b8c7a0c6f48629bf55e44152bc962','volumes',1,'2026-02-21 09:54:29',NULL),('2026-02-20 09:54:29','2026-02-20 09:54:29','2026-02-20 09:54:29',1,42,'d13bc874-a936-4815-af11-6a2090c899af',14,'416b8c7a0c6f48629bf55e44152bc962','gigabytes',1,'2026-02-21 09:54:29',NULL),('2026-02-20 09:54:29','2026-02-20 09:54:29','2026-02-20 09:54:29',1,43,'7bd8f529-9a5c-48e6-bc29-c8f25d863f55',15,'416b8c7a0c6f48629bf55e44152bc962','volumes_tripleo',1,'2026-02-21 09:54:29',NULL),('2026-02-20 09:54:29','2026-02-20 09:54:29','2026-02-20 09:54:29',1,44,'72e4d3d6-0c7c-4db3-ad8f-f49bc05231af',16,'416b8c7a0c6f48629bf55e44152bc962','gigabytes_tripleo',1,'2026-02-21 09:54:29',NULL),('2026-02-20 09:54:39','2026-02-20 09:54:39','2026-02-20 09:54:39',1,45,'c4e3a8e8-d822-4480-a9cc-dd1d00ed511b',13,'416b8c7a0c6f48629bf55e44152bc962','volumes',-1,'2026-02-21 09:54:39',NULL),('2026-02-20 09:54:39','2026-02-20 09:54:39','2026-02-20 09:54:39',1,46,'cdb84370-f393-4126-bb7b-665aaf79109f',14,'416b8c7a0c6f48629bf55e44152bc962','gigabytes',-1,'2026-02-21 09:54:39',NULL),('2026-02-20 09:54:39','2026-02-20 09:54:39','2026-02-20 09:54:39',1,47,'3b483ecb-00d9-4bd4-b485-b2add24aab9e',15,'416b8c7a0c6f48629bf55e44152bc962','volumes_tripleo',-1,'2026-02-21 09:54:39',NULL),('2026-02-20 09:54:39','2026-02-20 09:54:39','2026-02-20 09:54:39',1,48,'ed93b479-83db-4ab7-a87b-b15ce89fdd53',16,'416b8c7a0c6f48629bf55e44152bc962','gigabytes_tripleo',-1,'2026-02-21 09:54:39',NULL),('2026-02-20 09:54:41','2026-02-20 09:54:41','2026-02-20 09:54:41',1,49,'137fae15-f112-4588-982a-fca76c6c735d',17,'dcc08d5e298941e3a9de201aa565b6a9','groups',1,'2026-02-21 09:54:41',NULL),('2026-02-20 09:54:43','2026-02-20 09:54:43','2026-02-20 09:54:43',1,50,'4bc8708b-8fda-41a8-8603-103f496f2b29',18,'dcc08d5e298941e3a9de201aa565b6a9','volumes',1,'2026-02-21 09:54:43',NULL),('2026-02-20 09:54:43','2026-02-20 09:54:43','2026-02-20 09:54:43',1,51,'91f91b7b-1fa4-4fbc-8616-4ba9d3c07ef7',19,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes',1,'2026-02-21 09:54:43',NULL),('2026-02-20 09:54:43','2026-02-20 09:54:43','2026-02-20 09:54:43',1,52,'1f36b567-0ff7-4cbb-8133-fb28aea76aec',20,'dcc08d5e298941e3a9de201aa565b6a9','volumes_tempest-GroupSnapshotsTest-volume-type-1659843599',1,'2026-02-21 09:54:43',NULL),('2026-02-20 09:54:43','2026-02-20 09:54:43','2026-02-20 09:54:43',1,53,'fc64d7d4-d6b0-4c08-8ae9-5a7b3b43e812',21,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes_tempest-GroupSnapshotsTest-volume-type-1659843599',1,'2026-02-21 09:54:43',NULL),('2026-02-20 09:54:44','2026-02-20 09:54:44','2026-02-20 09:54:44',1,54,'19a95dfd-780b-4376-8299-0e89d54021da',22,'dcc08d5e298941e3a9de201aa565b6a9','snapshots',1,'2026-02-21 09:54:44',NULL),('2026-02-20 09:54:44','2026-02-20 09:54:44','2026-02-20 09:54:44',1,55,'862b5f4d-4e55-4cf0-89d3-beb9a88645ab',19,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes',1,'2026-02-21 09:54:44',NULL),('2026-02-20 09:54:44','2026-02-20 09:54:44','2026-02-20 09:54:44',1,56,'0f0c53ba-71a2-4487-b134-b6c63f6abe34',21,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes_tempest-GroupSnapshotsTest-volume-type-1659843599',1,'2026-02-21 09:54:44',NULL),('2026-02-20 09:54:44','2026-02-20 09:54:44','2026-02-20 09:54:44',1,57,'6f426f6b-3f3f-49d4-b08d-2826d1fee97b',23,'dcc08d5e298941e3a9de201aa565b6a9','snapshots_tempest-GroupSnapshotsTest-volume-type-1659843599',1,'2026-02-21 09:54:44',NULL),('2026-02-20 09:54:46','2026-02-20 09:54:46','2026-02-20 09:54:46',1,58,'dc621aab-201f-40ca-9e60-af0b284e25de',17,'dcc08d5e298941e3a9de201aa565b6a9','groups',1,'2026-02-21 09:54:46',NULL),('2026-02-20 09:54:46','2026-02-20 09:54:46','2026-02-20 09:54:46',1,59,'ec9e6bab-88ba-4a6f-a676-e4f57b31cc41',18,'dcc08d5e298941e3a9de201aa565b6a9','volumes',1,'2026-02-21 09:54:46',NULL),('2026-02-20 09:54:46','2026-02-20 09:54:46','2026-02-20 09:54:46',1,60,'5093e316-4d31-4fa4-8c32-379470b5cdea',20,'dcc08d5e298941e3a9de201aa565b6a9','volumes_tempest-GroupSnapshotsTest-volume-type-1659843599',1,'2026-02-21 09:54:46',NULL),('2026-02-20 09:54:49','2026-02-20 09:54:49','2026-02-20 09:54:49',1,61,'700c1697-07c2-42df-8f75-4782d2a20f9e',17,'dcc08d5e298941e3a9de201aa565b6a9','groups',-1,'2026-02-21 09:54:49',NULL),('2026-02-20 09:54:49','2026-02-20 09:54:49','2026-02-20 09:54:49',1,62,'f86d094d-e3a2-499d-aa2b-a5dd615d341e',18,'dcc08d5e298941e3a9de201aa565b6a9','volumes',-1,'2026-02-21 09:54:49',NULL),('2026-02-20 09:54:49','2026-02-20 09:54:49','2026-02-20 09:54:49',1,63,'2b69b198-a927-41aa-8f84-8870a39668a3',19,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes',-1,'2026-02-21 09:54:49',NULL),('2026-02-20 09:54:49','2026-02-20 09:54:49','2026-02-20 09:54:49',1,64,'764e7f20-31bd-403f-85fb-d92c65271390',20,'dcc08d5e298941e3a9de201aa565b6a9','volumes_tempest-GroupSnapshotsTest-volume-type-1659843599',-1,'2026-02-21 09:54:49',NULL),('2026-02-20 09:54:49','2026-02-20 09:54:49','2026-02-20 09:54:49',1,65,'efaa94fe-720f-4662-a116-60170041963f',21,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes_tempest-GroupSnapshotsTest-volume-type-1659843599',-1,'2026-02-21 09:54:49',NULL),('2026-02-20 09:54:52','2026-02-20 09:54:52','2026-02-20 09:54:52',1,66,'1ba47692-bd6b-4934-9fe5-682f69b3a50b',22,'dcc08d5e298941e3a9de201aa565b6a9','snapshots',-1,'2026-02-21 09:54:52',NULL),('2026-02-20 09:54:52','2026-02-20 09:54:52','2026-02-20 09:54:52',1,67,'70076573-e0d9-4f81-9355-218a2a750574',19,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes',-1,'2026-02-21 09:54:52',NULL),('2026-02-20 09:54:52','2026-02-20 09:54:52','2026-02-20 09:54:52',1,68,'6d58f0c4-5604-41fc-9864-caa53b9277b9',21,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes_tempest-GroupSnapshotsTest-volume-type-1659843599',-1,'2026-02-21 09:54:52',NULL),('2026-02-20 09:54:52','2026-02-20 09:54:52','2026-02-20 09:54:52',1,69,'720cd701-5447-4fd7-aa73-e23cc584aa55',23,'dcc08d5e298941e3a9de201aa565b6a9','snapshots_tempest-GroupSnapshotsTest-volume-type-1659843599',-1,'2026-02-21 09:54:52',NULL),('2026-02-20 09:54:53','2026-02-20 09:54:53','2026-02-20 09:54:53',1,70,'d9a16a0a-4ebd-4dde-b121-533307aa6fe6',17,'dcc08d5e298941e3a9de201aa565b6a9','groups',-1,'2026-02-21 09:54:53',NULL),('2026-02-20 09:54:53','2026-02-20 09:54:53','2026-02-20 09:54:53',1,71,'d47def88-8eea-463b-9b62-c17d75a13f58',18,'dcc08d5e298941e3a9de201aa565b6a9','volumes',-1,'2026-02-21 09:54:53',NULL),('2026-02-20 09:54:53','2026-02-20 09:54:53','2026-02-20 09:54:53',1,72,'7d305ef6-8ae9-4a73-addb-f263d3795bc7',19,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes',-1,'2026-02-21 09:54:53',NULL),('2026-02-20 09:54:53','2026-02-20 09:54:53','2026-02-20 09:54:53',1,73,'a2872d79-b332-4e0f-9856-e12307acdc70',20,'dcc08d5e298941e3a9de201aa565b6a9','volumes_tempest-GroupSnapshotsTest-volume-type-1659843599',-1,'2026-02-21 09:54:53',NULL),('2026-02-20 09:54:53','2026-02-20 09:54:53','2026-02-20 09:54:53',1,74,'0d1f7788-906a-4ba8-9878-6ad1a570418e',21,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes_tempest-GroupSnapshotsTest-volume-type-1659843599',-1,'2026-02-21 09:54:53',NULL),('2026-02-20 09:54:54','2026-02-20 09:54:54','2026-02-20 09:54:54',1,75,'cb7a5d44-2f3b-497b-bd47-675c700df4d6',17,'dcc08d5e298941e3a9de201aa565b6a9','groups',1,'2026-02-21 09:54:54',NULL),('2026-02-20 09:54:55','2026-02-20 09:54:55','2026-02-20 09:54:55',1,76,'e4a5127e-8479-490d-b466-f31e308a874f',18,'dcc08d5e298941e3a9de201aa565b6a9','volumes',1,'2026-02-21 09:54:55',NULL),('2026-02-20 09:54:55','2026-02-20 09:54:55','2026-02-20 09:54:55',1,77,'35fef5b7-8ce0-4e3a-8c1d-3b3aa5859c42',19,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes',1,'2026-02-21 09:54:55',NULL),('2026-02-20 09:54:55','2026-02-20 09:54:55','2026-02-20 09:54:55',1,78,'fd3982bc-2943-4d6f-94e6-307f6595c6ab',24,'dcc08d5e298941e3a9de201aa565b6a9','volumes_tempest-GroupSnapshotsTest-volume-type-2074118595',1,'2026-02-21 09:54:55',NULL),('2026-02-20 09:54:55','2026-02-20 09:54:55','2026-02-20 09:54:55',1,79,'c5e8aa3e-d931-4de2-8039-a1bad8eadc71',25,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes_tempest-GroupSnapshotsTest-volume-type-2074118595',1,'2026-02-21 09:54:55',NULL),('2026-02-20 09:54:57','2026-02-20 09:54:57','2026-02-20 09:54:57',1,80,'a473abfc-29bf-4b11-8b16-7a6bac5e4f89',18,'dcc08d5e298941e3a9de201aa565b6a9','volumes',1,'2026-02-21 09:54:57',NULL),('2026-02-20 09:54:57','2026-02-20 09:54:57','2026-02-20 09:54:57',1,81,'d2a00199-314b-4dc0-adc6-de9be65f7d9e',19,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes',1,'2026-02-21 09:54:57',NULL),('2026-02-20 09:54:57','2026-02-20 09:54:57','2026-02-20 09:54:57',1,82,'2a76accd-a743-4fe3-9b70-cebb0bc98f69',24,'dcc08d5e298941e3a9de201aa565b6a9','volumes_tempest-GroupSnapshotsTest-volume-type-2074118595',1,'2026-02-21 09:54:57',NULL),('2026-02-20 09:54:57','2026-02-20 09:54:57','2026-02-20 09:54:57',1,83,'30412a90-4c53-4698-ba01-b505f8f3c8cb',25,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes_tempest-GroupSnapshotsTest-volume-type-2074118595',1,'2026-02-21 09:54:57',NULL),('2026-02-20 09:55:03','2026-02-20 09:55:03','2026-02-20 09:55:03',1,84,'0f993d89-e624-4bc5-b418-e2ee9cbc7fae',22,'dcc08d5e298941e3a9de201aa565b6a9','snapshots',2,'2026-02-21 09:55:03',NULL),('2026-02-20 09:55:03','2026-02-20 09:55:03','2026-02-20 09:55:03',1,85,'62d5dc27-198b-4e04-89c8-0999a076d3f1',19,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes',2,'2026-02-21 09:55:03',NULL),('2026-02-20 09:55:03','2026-02-20 09:55:03','2026-02-20 09:55:03',1,86,'6088ca44-4086-426a-bc7a-fea777a46be7',25,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes_tempest-GroupSnapshotsTest-volume-type-2074118595',2,'2026-02-21 09:55:03',NULL),('2026-02-20 09:55:03','2026-02-20 09:55:03','2026-02-20 09:55:03',1,87,'830da6f0-2c95-451f-bebe-25e080dd5b1c',26,'dcc08d5e298941e3a9de201aa565b6a9','snapshots_tempest-GroupSnapshotsTest-volume-type-2074118595',2,'2026-02-21 09:55:03',NULL),('2026-02-20 09:55:09','2026-02-20 09:55:09','2026-02-20 09:55:09',1,88,'f2c2b13e-1ea0-475b-bbce-55dfe314d86c',22,'dcc08d5e298941e3a9de201aa565b6a9','snapshots',-1,'2026-02-21 09:55:09',NULL),('2026-02-20 09:55:09','2026-02-20 09:55:09','2026-02-20 09:55:09',1,89,'46a14585-e515-441f-bdec-d8b68820605f',19,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes',-1,'2026-02-21 09:55:09',NULL),('2026-02-20 09:55:09','2026-02-20 09:55:09','2026-02-20 09:55:09',1,90,'760d50b5-c35a-4f66-88a5-f07b6828ac8d',25,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes_tempest-GroupSnapshotsTest-volume-type-2074118595',-1,'2026-02-21 09:55:09',NULL),('2026-02-20 09:55:09','2026-02-20 09:55:09','2026-02-20 09:55:09',1,91,'d06cdea6-1853-4d6f-b5e2-9d4eafdc1795',26,'dcc08d5e298941e3a9de201aa565b6a9','snapshots_tempest-GroupSnapshotsTest-volume-type-2074118595',-1,'2026-02-21 09:55:09',NULL),('2026-02-20 09:55:09','2026-02-20 09:55:09','2026-02-20 09:55:09',1,92,'2a54ee47-5a97-4ff1-a1f5-1947f9efa423',22,'dcc08d5e298941e3a9de201aa565b6a9','snapshots',-1,'2026-02-21 09:55:09',NULL),('2026-02-20 09:55:09','2026-02-20 09:55:09','2026-02-20 09:55:09',1,93,'fecbd342-a01d-42c6-b300-ccf125ea767c',19,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes',-1,'2026-02-21 09:55:09',NULL),('2026-02-20 09:55:09','2026-02-20 09:55:09','2026-02-20 09:55:09',1,94,'4e06b023-db46-425b-bcb3-8948fa9be054',25,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes_tempest-GroupSnapshotsTest-volume-type-2074118595',-1,'2026-02-21 09:55:09',NULL),('2026-02-20 09:55:09','2026-02-20 09:55:09','2026-02-20 09:55:09',1,95,'0e9d0e49-4d0c-4212-8fdd-a210acd9a2ff',26,'dcc08d5e298941e3a9de201aa565b6a9','snapshots_tempest-GroupSnapshotsTest-volume-type-2074118595',-1,'2026-02-21 09:55:09',NULL),('2026-02-20 09:55:12','2026-02-20 09:55:12','2026-02-20 09:55:12',1,96,'b38997cf-4aed-4175-a1b1-d1d857d95f40',17,'dcc08d5e298941e3a9de201aa565b6a9','groups',-1,'2026-02-21 09:55:12',NULL),('2026-02-20 09:55:12','2026-02-20 09:55:12','2026-02-20 09:55:12',1,97,'02526e32-2443-490d-9d34-d1fdc2f20c78',18,'dcc08d5e298941e3a9de201aa565b6a9','volumes',-1,'2026-02-21 09:55:12',NULL),('2026-02-20 09:55:12','2026-02-20 09:55:12','2026-02-20 09:55:12',1,98,'8481417a-6da2-4a3d-a47a-9c154aac62ab',19,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes',-1,'2026-02-21 09:55:12',NULL),('2026-02-20 09:55:12','2026-02-20 09:55:12','2026-02-20 09:55:12',1,99,'c5af3388-c725-4a1b-8a87-0feaa42da20d',24,'dcc08d5e298941e3a9de201aa565b6a9','volumes_tempest-GroupSnapshotsTest-volume-type-2074118595',-1,'2026-02-21 09:55:12',NULL),('2026-02-20 09:55:12','2026-02-20 09:55:12','2026-02-20 09:55:12',1,100,'dd8f8328-57b7-4a06-99a8-5e814e2a4249',25,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes_tempest-GroupSnapshotsTest-volume-type-2074118595',-1,'2026-02-21 09:55:12',NULL),('2026-02-20 09:55:12','2026-02-20 09:55:12','2026-02-20 09:55:12',1,101,'3af0609c-8e2b-429e-ad6e-bfc348dd7498',18,'dcc08d5e298941e3a9de201aa565b6a9','volumes',-1,'2026-02-21 09:55:12',NULL),('2026-02-20 09:55:12','2026-02-20 09:55:12','2026-02-20 09:55:12',1,102,'32e73fce-4a1c-4274-a767-dd3745ef0070',19,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes',-1,'2026-02-21 09:55:12',NULL),('2026-02-20 09:55:12','2026-02-20 09:55:12','2026-02-20 09:55:12',1,103,'de1f67ad-36c6-4ae0-a2d1-a73118eb9d13',24,'dcc08d5e298941e3a9de201aa565b6a9','volumes_tempest-GroupSnapshotsTest-volume-type-2074118595',-1,'2026-02-21 09:55:12',NULL),('2026-02-20 09:55:12','2026-02-20 09:55:12','2026-02-20 09:55:12',1,104,'3d79e0eb-7df4-4f74-ad44-786840c621d0',25,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes_tempest-GroupSnapshotsTest-volume-type-2074118595',-1,'2026-02-21 09:55:12',NULL),('2026-02-20 09:55:13','2026-02-20 09:55:13','2026-02-20 09:55:13',1,105,'b7d39360-92c2-4063-a495-aa197d3efb58',17,'dcc08d5e298941e3a9de201aa565b6a9','groups',1,'2026-02-21 09:55:13',NULL),('2026-02-20 09:55:14','2026-02-20 09:55:14','2026-02-20 09:55:14',1,106,'2a370d67-d9fe-41d8-a0c0-405cf995d0d1',18,'dcc08d5e298941e3a9de201aa565b6a9','volumes',1,'2026-02-21 09:55:14',NULL),('2026-02-20 09:55:14','2026-02-20 09:55:14','2026-02-20 09:55:14',1,107,'d09389b8-86e9-4db5-ba75-b0902d9b8648',19,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes',1,'2026-02-21 09:55:14',NULL),('2026-02-20 09:55:14','2026-02-20 09:55:14','2026-02-20 09:55:14',1,108,'64b5e5c8-823b-4b22-8775-4b83bcd63947',27,'dcc08d5e298941e3a9de201aa565b6a9','volumes_tempest-GroupSnapshotsTest-volume-type-247800390',1,'2026-02-21 09:55:14',NULL),('2026-02-20 09:55:14','2026-02-20 09:55:14','2026-02-20 09:55:14',1,109,'dc0f9515-50f4-4546-bd16-02f899b2d6f6',28,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes_tempest-GroupSnapshotsTest-volume-type-247800390',1,'2026-02-21 09:55:14',NULL),('2026-02-20 09:55:15','2026-02-20 09:55:15','2026-02-20 09:55:15',1,110,'15b94f98-083f-44d3-a2dd-1572f471bbd1',22,'dcc08d5e298941e3a9de201aa565b6a9','snapshots',1,'2026-02-21 09:55:15',NULL),('2026-02-20 09:55:15','2026-02-20 09:55:16','2026-02-20 09:55:16',1,111,'d21e3e03-f86e-49a9-8b56-bac1f955497a',19,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes',1,'2026-02-21 09:55:15',NULL),('2026-02-20 09:55:15','2026-02-20 09:55:16','2026-02-20 09:55:16',1,112,'1f3efd9b-3b85-4532-94e7-aeb567b56384',28,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes_tempest-GroupSnapshotsTest-volume-type-247800390',1,'2026-02-21 09:55:15',NULL),('2026-02-20 09:55:15','2026-02-20 09:55:16','2026-02-20 09:55:16',1,113,'645dfeb6-4745-45a1-9341-bf48a5377661',29,'dcc08d5e298941e3a9de201aa565b6a9','snapshots_tempest-GroupSnapshotsTest-volume-type-247800390',1,'2026-02-21 09:55:15',NULL),('2026-02-20 09:55:18','2026-02-20 09:55:18','2026-02-20 09:55:18',1,114,'db196c41-6df9-4897-9f1a-70b1d8efd0f6',22,'dcc08d5e298941e3a9de201aa565b6a9','snapshots',-1,'2026-02-21 09:55:18',NULL),('2026-02-20 09:55:18','2026-02-20 09:55:18','2026-02-20 09:55:18',1,115,'8bf80ef2-91fd-4ee2-9136-0e87625c203f',19,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes',-1,'2026-02-21 09:55:18',NULL),('2026-02-20 09:55:18','2026-02-20 09:55:18','2026-02-20 09:55:18',1,116,'84fb79d3-7af5-4385-bef3-3140cf63f8ab',28,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes_tempest-GroupSnapshotsTest-volume-type-247800390',-1,'2026-02-21 09:55:18',NULL),('2026-02-20 09:55:18','2026-02-20 09:55:18','2026-02-20 09:55:18',1,117,'47edf0ec-b861-4890-b06f-e315627e92df',29,'dcc08d5e298941e3a9de201aa565b6a9','snapshots_tempest-GroupSnapshotsTest-volume-type-247800390',-1,'2026-02-21 09:55:18',NULL),('2026-02-20 09:55:19','2026-02-20 09:55:19','2026-02-20 09:55:19',1,118,'bcecff31-62ed-4d72-9bed-4ee0cd3e241d',17,'dcc08d5e298941e3a9de201aa565b6a9','groups',-1,'2026-02-21 09:55:19',NULL),('2026-02-20 09:55:19','2026-02-20 09:55:19','2026-02-20 09:55:19',1,119,'9b1dd88f-0819-4b44-b833-9520cbda65b2',18,'dcc08d5e298941e3a9de201aa565b6a9','volumes',-1,'2026-02-21 09:55:19',NULL),('2026-02-20 09:55:19','2026-02-20 09:55:19','2026-02-20 09:55:19',1,120,'de71021d-2d6a-48bc-b2c8-de172ad575bf',19,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes',-1,'2026-02-21 09:55:19',NULL),('2026-02-20 09:55:19','2026-02-20 09:55:19','2026-02-20 09:55:19',1,121,'1a19a2f7-37d5-48ca-9feb-48bba65e9811',27,'dcc08d5e298941e3a9de201aa565b6a9','volumes_tempest-GroupSnapshotsTest-volume-type-247800390',-1,'2026-02-21 09:55:19',NULL),('2026-02-20 09:55:19','2026-02-20 09:55:19','2026-02-20 09:55:19',1,122,'8fec4f22-e7a1-4d5f-94ef-6e4e599b4a36',28,'dcc08d5e298941e3a9de201aa565b6a9','gigabytes_tempest-GroupSnapshotsTest-volume-type-247800390',-1,'2026-02-21 09:55:19',NULL),('2026-02-20 09:55:35','2026-02-20 09:55:35','2026-02-20 09:55:35',1,123,'fd73f69b-4306-49a0-bae5-7cde1df81d23',30,'17f50febac1846c0a653b60a8f30a43a','volumes',1,'2026-02-21 09:55:35',NULL),('2026-02-20 09:55:35','2026-02-20 09:55:35','2026-02-20 09:55:35',1,124,'0693bb21-bd21-4828-810a-94393e14d842',31,'17f50febac1846c0a653b60a8f30a43a','gigabytes',1,'2026-02-21 09:55:35',NULL),('2026-02-20 09:55:35','2026-02-20 09:55:35','2026-02-20 09:55:35',1,125,'ce21e8e6-a5cd-41d8-ac8d-a0239e5c5808',32,'17f50febac1846c0a653b60a8f30a43a','volumes_tripleo',1,'2026-02-21 09:55:35',NULL),('2026-02-20 09:55:35','2026-02-20 09:55:35','2026-02-20 09:55:35',1,126,'94b1c120-9b87-428d-a250-cdee506f8a30',33,'17f50febac1846c0a653b60a8f30a43a','gigabytes_tripleo',1,'2026-02-21 09:55:35',NULL),('2026-02-20 09:55:37','2026-02-20 09:55:37','2026-02-20 09:55:37',1,127,'b5a7fdca-b3e3-494f-a4b8-1215e09fd9b3',30,'17f50febac1846c0a653b60a8f30a43a','volumes',-1,'2026-02-21 09:55:37',NULL),('2026-02-20 09:55:37','2026-02-20 09:55:37','2026-02-20 09:55:37',1,128,'965a5ddf-fa6d-40dc-af80-1560fabc6824',31,'17f50febac1846c0a653b60a8f30a43a','gigabytes',-1,'2026-02-21 09:55:37',NULL),('2026-02-20 09:55:37','2026-02-20 09:55:37','2026-02-20 09:55:37',1,129,'393da235-1fe5-4a29-ac05-cd6d82a8740c',32,'17f50febac1846c0a653b60a8f30a43a','volumes_tripleo',-1,'2026-02-21 09:55:37',NULL),('2026-02-20 09:55:37','2026-02-20 09:55:37','2026-02-20 09:55:37',1,130,'ceeddae2-7b0e-47d0-84ae-b86c97bd9427',33,'17f50febac1846c0a653b60a8f30a43a','gigabytes_tripleo',-1,'2026-02-21 09:55:37',NULL),('2026-02-20 09:55:45','2026-02-20 09:55:45','2026-02-20 09:55:45',1,131,'6fb9be74-1fe9-441c-b90b-86b861be1d34',34,'f1d88f620ed14a4da04788bf096bb225','volumes',1,'2026-02-21 09:55:45',NULL),('2026-02-20 09:55:45','2026-02-20 09:55:45','2026-02-20 09:55:45',1,132,'6f4851a4-6692-4c69-95ff-028f0dbdf5e4',35,'f1d88f620ed14a4da04788bf096bb225','gigabytes',1,'2026-02-21 09:55:45',NULL),('2026-02-20 09:55:45','2026-02-20 09:55:45','2026-02-20 09:55:45',1,133,'e3a3fa8d-1c8e-41cb-add9-19160d65b15d',36,'f1d88f620ed14a4da04788bf096bb225','volumes_tripleo',1,'2026-02-21 09:55:45',NULL),('2026-02-20 09:55:45','2026-02-20 09:55:45','2026-02-20 09:55:45',1,134,'7266bc14-3d0b-4465-b682-a3f0194f62da',37,'f1d88f620ed14a4da04788bf096bb225','gigabytes_tripleo',1,'2026-02-21 09:55:45',NULL),('2026-02-20 09:55:55','2026-02-20 09:55:55','2026-02-20 09:55:55',1,135,'e50edd0e-e207-412f-bfbb-c3159e7c806b',34,'f1d88f620ed14a4da04788bf096bb225','volumes',-1,'2026-02-21 09:55:55',NULL),('2026-02-20 09:55:55','2026-02-20 09:55:55','2026-02-20 09:55:55',1,136,'06d17d24-af83-4ae5-a845-5cfa095fc7d2',35,'f1d88f620ed14a4da04788bf096bb225','gigabytes',-1,'2026-02-21 09:55:55',NULL),('2026-02-20 09:55:55','2026-02-20 09:55:55','2026-02-20 09:55:55',1,137,'9f96cca6-113d-4367-998d-9db54da97aa8',36,'f1d88f620ed14a4da04788bf096bb225','volumes_tripleo',-1,'2026-02-21 09:55:55',NULL),('2026-02-20 09:55:55','2026-02-20 09:55:55','2026-02-20 09:55:55',1,138,'5d8baea1-d3d3-498d-a8ad-a2f9ff2b9e3a',37,'f1d88f620ed14a4da04788bf096bb225','gigabytes_tripleo',-1,'2026-02-21 09:55:55',NULL),('2026-02-20 09:56:02','2026-02-20 09:56:02','2026-02-20 09:56:02',1,139,'9c58ac33-bafd-4d11-9ec7-724f81eb0459',38,'50be2d6048314f72aad782543bcc440d','volumes',1,'2026-02-21 09:56:02',NULL),('2026-02-20 09:56:02','2026-02-20 09:56:02','2026-02-20 09:56:02',1,140,'7136958d-91e7-4e66-ad9b-eea5b851dea5',39,'50be2d6048314f72aad782543bcc440d','gigabytes',1,'2026-02-21 09:56:02',NULL),('2026-02-20 09:56:02','2026-02-20 09:56:02','2026-02-20 09:56:02',1,141,'f5dfd2d1-106b-480c-8b43-d174935bebb3',40,'50be2d6048314f72aad782543bcc440d','volumes_tripleo',1,'2026-02-21 09:56:02',NULL),('2026-02-20 09:56:02','2026-02-20 09:56:02','2026-02-20 09:56:02',1,142,'0cb245df-fbd4-4028-90e4-56e596d532f3',41,'50be2d6048314f72aad782543bcc440d','gigabytes_tripleo',1,'2026-02-21 09:56:02',NULL),('2026-02-20 09:56:03','2026-02-20 09:56:03','2026-02-20 09:56:03',1,143,'3b66abe3-5706-466d-aaaa-ae6080426bf5',42,'ffe95c3ecb8041f08ab64f85fb74a65b','volumes',1,'2026-02-21 09:56:03',NULL),('2026-02-20 09:56:03','2026-02-20 09:56:03','2026-02-20 09:56:03',1,144,'7cf1d02d-eb1a-4655-8fac-0b844408ddc7',43,'ffe95c3ecb8041f08ab64f85fb74a65b','gigabytes',1,'2026-02-21 09:56:03',NULL),('2026-02-20 09:56:03','2026-02-20 09:56:03','2026-02-20 09:56:03',1,145,'81639eda-7c9d-4ae7-8d63-0ef8c91e21b2',44,'ffe95c3ecb8041f08ab64f85fb74a65b','volumes_tripleo',1,'2026-02-21 09:56:03',NULL),('2026-02-20 09:56:03','2026-02-20 09:56:03','2026-02-20 09:56:03',1,146,'728f55d1-ca3b-4e13-a471-d01f7354039b',45,'ffe95c3ecb8041f08ab64f85fb74a65b','gigabytes_tripleo',1,'2026-02-21 09:56:03',NULL),('2026-02-20 09:56:03','2026-02-20 09:56:04','2026-02-20 09:56:04',1,147,'9746fd1c-d83f-4000-9b81-404b260f1b34',38,'50be2d6048314f72aad782543bcc440d','volumes',-1,'2026-02-21 09:56:03',NULL),('2026-02-20 09:56:03','2026-02-20 09:56:04','2026-02-20 09:56:04',1,148,'e062ab03-b52c-438f-b105-a1f2bff0f577',39,'50be2d6048314f72aad782543bcc440d','gigabytes',-1,'2026-02-21 09:56:03',NULL),('2026-02-20 09:56:03','2026-02-20 09:56:04','2026-02-20 09:56:04',1,149,'574e34ab-d727-433e-9101-145dcc459c7e',40,'50be2d6048314f72aad782543bcc440d','volumes_tripleo',-1,'2026-02-21 09:56:03',NULL),('2026-02-20 09:56:03','2026-02-20 09:56:04','2026-02-20 09:56:04',1,150,'c12e6543-fd1f-429c-a737-dda8bbd465a9',41,'50be2d6048314f72aad782543bcc440d','gigabytes_tripleo',-1,'2026-02-21 09:56:03',NULL),('2026-02-20 09:56:03','2026-02-20 09:56:03','2026-02-20 09:56:03',1,151,'c3e9a0cf-4e06-4d38-a310-bf47b7016708',46,'ffe95c3ecb8041f08ab64f85fb74a65b','snapshots',0,'2026-02-21 09:56:03',NULL),('2026-02-20 09:56:03','2026-02-20 09:56:03','2026-02-20 09:56:03',1,152,'e4a7d72d-3020-4b7e-b886-1e3d584af25b',43,'ffe95c3ecb8041f08ab64f85fb74a65b','gigabytes',0,'2026-02-21 09:56:03',NULL),('2026-02-20 09:56:03','2026-02-20 09:56:03','2026-02-20 09:56:03',1,153,'ce78a5c8-ac68-4b6e-ac5a-cb1467b85cc0',45,'ffe95c3ecb8041f08ab64f85fb74a65b','gigabytes_tripleo',0,'2026-02-21 09:56:03',NULL),('2026-02-20 09:56:03','2026-02-20 09:56:04','2026-02-20 09:56:04',1,154,'eb04f241-65c5-490c-b047-7900dc37d379',47,'ffe95c3ecb8041f08ab64f85fb74a65b','snapshots_tripleo',0,'2026-02-21 09:56:03',NULL),('2026-02-20 09:56:03','2026-02-20 09:56:04','2026-02-20 09:56:04',1,155,'68583361-3cba-4a50-b316-5d621598df9a',48,'50be2d6048314f72aad782543bcc440d','snapshots',0,'2026-02-21 09:56:03',NULL),('2026-02-20 09:56:03','2026-02-20 09:56:04','2026-02-20 09:56:04',1,156,'cc7cfb30-8e24-467d-b1e5-aff060b2c453',39,'50be2d6048314f72aad782543bcc440d','gigabytes',0,'2026-02-21 09:56:03',NULL),('2026-02-20 09:56:03','2026-02-20 09:56:04','2026-02-20 09:56:04',1,157,'4b34c606-2a10-4725-990b-a58b7d6148de',41,'50be2d6048314f72aad782543bcc440d','gigabytes_tripleo',0,'2026-02-21 09:56:03',NULL),('2026-02-20 09:56:03','2026-02-20 09:56:04','2026-02-20 09:56:04',1,158,'d829da56-d816-4422-8d03-1af799db2edb',49,'50be2d6048314f72aad782543bcc440d','snapshots_tripleo',0,'2026-02-21 09:56:03',NULL),('2026-02-20 09:56:04','2026-02-20 09:56:04','2026-02-20 09:56:04',1,159,'7c78e696-8f87-497f-b532-b50d9df8286d',42,'ffe95c3ecb8041f08ab64f85fb74a65b','volumes',-1,'2026-02-21 09:56:04',NULL),('2026-02-20 09:56:04','2026-02-20 09:56:04','2026-02-20 09:56:04',1,160,'e7812720-f530-42f9-8df9-5a602d2b9e87',43,'ffe95c3ecb8041f08ab64f85fb74a65b','gigabytes',-1,'2026-02-21 09:56:04',NULL),('2026-02-20 09:56:04','2026-02-20 09:56:04','2026-02-20 09:56:04',1,161,'2d26ece7-30eb-4200-90e7-260ff08e3ff0',44,'ffe95c3ecb8041f08ab64f85fb74a65b','volumes_tripleo',-1,'2026-02-21 09:56:04',NULL),('2026-02-20 09:56:04','2026-02-20 09:56:04','2026-02-20 09:56:04',1,162,'90cff92b-cdae-4382-a7de-e3049a3c6372',45,'ffe95c3ecb8041f08ab64f85fb74a65b','gigabytes_tripleo',-1,'2026-02-21 09:56:04',NULL),('2026-02-20 09:56:05','2026-02-20 09:56:05','2026-02-20 09:56:05',1,163,'2b83b58c-c7b8-408d-ad1e-4f1f2a5cf361',38,'50be2d6048314f72aad782543bcc440d','volumes',1,'2026-02-21 09:56:05',NULL),('2026-02-20 09:56:05','2026-02-20 09:56:05','2026-02-20 09:56:05',1,164,'6d9cdae2-0bca-4009-a114-f7686c4a6619',39,'50be2d6048314f72aad782543bcc440d','gigabytes',1,'2026-02-21 09:56:05',NULL),('2026-02-20 09:56:05','2026-02-20 09:56:05','2026-02-20 09:56:05',1,165,'4883388d-527c-4bb1-a29f-4fc45bba43e9',40,'50be2d6048314f72aad782543bcc440d','volumes_tripleo',1,'2026-02-21 09:56:05',NULL),('2026-02-20 09:56:05','2026-02-20 09:56:05','2026-02-20 09:56:05',1,166,'d599dd94-454f-4606-b2cb-2a56ab8bf344',41,'50be2d6048314f72aad782543bcc440d','gigabytes_tripleo',1,'2026-02-21 09:56:05',NULL),('2026-02-20 09:56:07','2026-02-20 09:56:07','2026-02-20 09:56:07',1,167,'edcd0a02-9f76-4a4c-b328-cad27a5e6482',38,'50be2d6048314f72aad782543bcc440d','volumes',-1,'2026-02-21 09:56:07',NULL),('2026-02-20 09:56:07','2026-02-20 09:56:07','2026-02-20 09:56:07',1,168,'fcc68072-0bee-47f8-bd2d-1c648cee5470',39,'50be2d6048314f72aad782543bcc440d','gigabytes',-1,'2026-02-21 09:56:07',NULL),('2026-02-20 09:56:07','2026-02-20 09:56:07','2026-02-20 09:56:07',1,169,'0bb54cda-aeed-4bf5-b71a-f4799d337881',40,'50be2d6048314f72aad782543bcc440d','volumes_tripleo',-1,'2026-02-21 09:56:07',NULL),('2026-02-20 09:56:07','2026-02-20 09:56:07','2026-02-20 09:56:07',1,170,'f23f8a5b-009f-4088-806a-8f0b8314a38f',41,'50be2d6048314f72aad782543bcc440d','gigabytes_tripleo',-1,'2026-02-21 09:56:07',NULL),('2026-02-20 09:56:15','2026-02-20 09:56:15','2026-02-20 09:56:15',1,171,'be8a87fb-b5cf-4d0c-9402-10c5afa417b4',50,'8b33a3c1c64247628d4927f39794f13e','volumes',1,'2026-02-21 09:56:15',NULL),('2026-02-20 09:56:15','2026-02-20 09:56:15','2026-02-20 09:56:15',1,172,'bcc762d8-dd37-4c71-bd52-8f80ec8c56e7',51,'8b33a3c1c64247628d4927f39794f13e','gigabytes',1,'2026-02-21 09:56:15',NULL),('2026-02-20 09:56:15','2026-02-20 09:56:15','2026-02-20 09:56:15',1,173,'377b5aca-c07a-40f6-99bb-e35340dda2cc',52,'8b33a3c1c64247628d4927f39794f13e','volumes_tripleo',1,'2026-02-21 09:56:15',NULL),('2026-02-20 09:56:15','2026-02-20 09:56:15','2026-02-20 09:56:15',1,174,'2ed5f2ac-1281-4c02-a90c-2ee321c8848d',53,'8b33a3c1c64247628d4927f39794f13e','gigabytes_tripleo',1,'2026-02-21 09:56:15',NULL),('2026-02-20 09:56:16','2026-02-20 09:56:17','2026-02-20 09:56:17',1,175,'5fc50931-2492-4459-8976-0b0ada9b5ceb',54,'1eff39cdacfd4eb28de1fa5742b73d15','volumes',1,'2026-02-21 09:56:16',NULL),('2026-02-20 09:56:16','2026-02-20 09:56:17','2026-02-20 09:56:17',1,176,'a26073f1-c910-40d6-b581-495b6d1d697c',55,'1eff39cdacfd4eb28de1fa5742b73d15','gigabytes',1,'2026-02-21 09:56:16',NULL),('2026-02-20 09:56:16','2026-02-20 09:56:17','2026-02-20 09:56:17',1,177,'586e4074-e7ae-4f94-ad22-f2afcd4f5ede',56,'1eff39cdacfd4eb28de1fa5742b73d15','volumes_tripleo',1,'2026-02-21 09:56:16',NULL),('2026-02-20 09:56:16','2026-02-20 09:56:17','2026-02-20 09:56:17',1,178,'832ee38c-a368-467a-9883-5095d9899594',57,'1eff39cdacfd4eb28de1fa5742b73d15','gigabytes_tripleo',1,'2026-02-21 09:56:16',NULL),('2026-02-20 09:56:16','2026-02-20 09:56:17','2026-02-20 09:56:17',1,179,'78ce8a61-e691-4083-bef8-22ed121d8c90',50,'8b33a3c1c64247628d4927f39794f13e','volumes',-1,'2026-02-21 09:56:16',NULL),('2026-02-20 09:56:16','2026-02-20 09:56:17','2026-02-20 09:56:17',1,180,'a8205724-eae8-45cf-a839-cc3e5e86953f',51,'8b33a3c1c64247628d4927f39794f13e','gigabytes',-1,'2026-02-21 09:56:16',NULL),('2026-02-20 09:56:16','2026-02-20 09:56:17','2026-02-20 09:56:17',1,181,'f83cb454-156c-4e82-8a04-27640235880f',52,'8b33a3c1c64247628d4927f39794f13e','volumes_tripleo',-1,'2026-02-21 09:56:16',NULL),('2026-02-20 09:56:16','2026-02-20 09:56:17','2026-02-20 09:56:17',1,182,'ed03a53d-6d9c-4066-8ccc-855de0114d8e',53,'8b33a3c1c64247628d4927f39794f13e','gigabytes_tripleo',-1,'2026-02-21 09:56:16',NULL),('2026-02-20 09:56:17','2026-02-20 09:56:17','2026-02-20 09:56:17',1,183,'a5222358-141b-4279-8ed6-1172f2320fec',58,'1eff39cdacfd4eb28de1fa5742b73d15','snapshots',0,'2026-02-21 09:56:17',NULL),('2026-02-20 09:56:17','2026-02-20 09:56:17','2026-02-20 09:56:17',1,184,'d22c3f21-61a4-4b37-9ac8-f65935a28695',55,'1eff39cdacfd4eb28de1fa5742b73d15','gigabytes',0,'2026-02-21 09:56:17',NULL),('2026-02-20 09:56:17','2026-02-20 09:56:17','2026-02-20 09:56:17',1,185,'c6805038-6b7d-4cb4-b636-a068764b326e',57,'1eff39cdacfd4eb28de1fa5742b73d15','gigabytes_tripleo',0,'2026-02-21 09:56:17',NULL),('2026-02-20 09:56:17','2026-02-20 09:56:17','2026-02-20 09:56:17',1,186,'2f5bb8d3-a0fe-4796-adf8-de576434c390',59,'1eff39cdacfd4eb28de1fa5742b73d15','snapshots_tripleo',0,'2026-02-21 09:56:17',NULL),('2026-02-20 09:56:17','2026-02-20 09:56:17','2026-02-20 09:56:17',1,187,'3b8927c8-42a0-49f8-9769-7fd66fc51a00',60,'8b33a3c1c64247628d4927f39794f13e','snapshots',0,'2026-02-21 09:56:17',NULL),('2026-02-20 09:56:17','2026-02-20 09:56:17','2026-02-20 09:56:17',1,188,'dd81fe7f-11da-4def-b770-5c627fdbdff6',51,'8b33a3c1c64247628d4927f39794f13e','gigabytes',0,'2026-02-21 09:56:17',NULL),('2026-02-20 09:56:17','2026-02-20 09:56:17','2026-02-20 09:56:17',1,189,'d3b92f44-badb-408e-b982-8076cec1ed2f',53,'8b33a3c1c64247628d4927f39794f13e','gigabytes_tripleo',0,'2026-02-21 09:56:17',NULL),('2026-02-20 09:56:17','2026-02-20 09:56:17','2026-02-20 09:56:17',1,190,'c846947d-3dfa-4f1b-bea6-0920df071223',61,'8b33a3c1c64247628d4927f39794f13e','snapshots_tripleo',0,'2026-02-21 09:56:17',NULL),('2026-02-20 09:56:17','2026-02-20 09:56:17','2026-02-20 09:56:17',1,191,'a33e24c9-caa9-4214-8daa-6bf926656f5f',54,'1eff39cdacfd4eb28de1fa5742b73d15','volumes',-1,'2026-02-21 09:56:17',NULL),('2026-02-20 09:56:17','2026-02-20 09:56:17','2026-02-20 09:56:17',1,192,'90137947-d57e-4dbb-a19b-e061d2ced77e',55,'1eff39cdacfd4eb28de1fa5742b73d15','gigabytes',-1,'2026-02-21 09:56:17',NULL),('2026-02-20 09:56:17','2026-02-20 09:56:17','2026-02-20 09:56:17',1,193,'c440cdad-5247-4cf0-82fe-f52fb53a3e01',56,'1eff39cdacfd4eb28de1fa5742b73d15','volumes_tripleo',-1,'2026-02-21 09:56:17',NULL),('2026-02-20 09:56:17','2026-02-20 09:56:17','2026-02-20 09:56:17',1,194,'6edf276e-6e7a-4db6-ad8d-4b3ed4af4a30',57,'1eff39cdacfd4eb28de1fa5742b73d15','gigabytes_tripleo',-1,'2026-02-21 09:56:17',NULL),('2026-02-20 09:56:18','2026-02-20 09:56:18','2026-02-20 09:56:18',1,195,'eec82325-9d0e-41e1-a743-abe625007068',50,'8b33a3c1c64247628d4927f39794f13e','volumes',1,'2026-02-21 09:56:18',NULL),('2026-02-20 09:56:18','2026-02-20 09:56:18','2026-02-20 09:56:18',1,196,'81650493-6525-4783-9869-97dbc7cfa91a',51,'8b33a3c1c64247628d4927f39794f13e','gigabytes',1,'2026-02-21 09:56:18',NULL),('2026-02-20 09:56:18','2026-02-20 09:56:18','2026-02-20 09:56:18',1,197,'e9d73f98-cd0f-46df-86ed-9aa96ade3326',52,'8b33a3c1c64247628d4927f39794f13e','volumes_tripleo',1,'2026-02-21 09:56:18',NULL),('2026-02-20 09:56:18','2026-02-20 09:56:18','2026-02-20 09:56:18',1,198,'b6c7d78f-036d-4bd9-b0a5-9f7dcf28a9ca',53,'8b33a3c1c64247628d4927f39794f13e','gigabytes_tripleo',1,'2026-02-21 09:56:18',NULL),('2026-02-20 09:56:20','2026-02-20 09:56:20','2026-02-20 09:56:20',1,199,'358d02f6-6576-42b8-9dcd-9cc23996be93',50,'8b33a3c1c64247628d4927f39794f13e','volumes',-1,'2026-02-21 09:56:20',NULL),('2026-02-20 09:56:20','2026-02-20 09:56:20','2026-02-20 09:56:20',1,200,'ed7f6349-7f79-4bf6-9e66-f216ff5c24b1',51,'8b33a3c1c64247628d4927f39794f13e','gigabytes',-1,'2026-02-21 09:56:20',NULL),('2026-02-20 09:56:20','2026-02-20 09:56:20','2026-02-20 09:56:20',1,201,'b5671582-9f36-4cf1-bc39-d28289e45ab0',52,'8b33a3c1c64247628d4927f39794f13e','volumes_tripleo',-1,'2026-02-21 09:56:20',NULL),('2026-02-20 09:56:20','2026-02-20 09:56:20','2026-02-20 09:56:20',1,202,'776bd0fb-9f9a-46d0-b964-4afd4e1a7674',53,'8b33a3c1c64247628d4927f39794f13e','gigabytes_tripleo',-1,'2026-02-21 09:56:20',NULL),('2026-02-20 09:56:29','2026-02-20 09:56:29','2026-02-20 09:56:29',1,203,'14e00b5a-143d-4c69-a717-3a2102c7577b',62,'226ab368400e4186b91e98a77b240268','volumes',1,'2026-02-21 09:56:29',NULL),('2026-02-20 09:56:29','2026-02-20 09:56:29','2026-02-20 09:56:29',1,204,'bc85853d-9157-40d5-8b08-b7dc88ff850a',63,'226ab368400e4186b91e98a77b240268','gigabytes',1,'2026-02-21 09:56:29',NULL),('2026-02-20 09:56:29','2026-02-20 09:56:29','2026-02-20 09:56:29',1,205,'249f8a49-5c96-4032-8e3e-c82c2121047c',64,'226ab368400e4186b91e98a77b240268','volumes_tripleo',1,'2026-02-21 09:56:29',NULL),('2026-02-20 09:56:29','2026-02-20 09:56:29','2026-02-20 09:56:29',1,206,'8dda5aa4-0780-4018-a9c3-e7698af9cb2c',65,'226ab368400e4186b91e98a77b240268','gigabytes_tripleo',1,'2026-02-21 09:56:29',NULL),('2026-02-20 09:56:31','2026-02-20 09:56:31','2026-02-20 09:56:31',1,207,'1b500fe2-b27f-48ad-880d-af74610e369e',66,'226ab368400e4186b91e98a77b240268','backups',1,'2026-02-21 09:56:31',NULL),('2026-02-20 09:56:31','2026-02-20 09:56:31','2026-02-20 09:56:31',1,208,'a014a1af-2872-40a6-9d8c-07002ebf6f67',67,'226ab368400e4186b91e98a77b240268','backup_gigabytes',1,'2026-02-21 09:56:31',NULL),('2026-02-20 09:56:33','2026-02-20 09:56:33','2026-02-20 09:56:33',1,209,'93504485-e4f6-42fa-b460-b864057bde9e',68,'6b6c3ea6fad948cbaee73bff3485d7da','volumes',1,'2026-02-21 09:56:33',NULL),('2026-02-20 09:56:33','2026-02-20 09:56:33','2026-02-20 09:56:33',1,210,'a29d6595-080b-4e5c-9f41-009da7c6bc27',69,'6b6c3ea6fad948cbaee73bff3485d7da','gigabytes',1,'2026-02-21 09:56:33',NULL),('2026-02-20 09:56:33','2026-02-20 09:56:33','2026-02-20 09:56:33',1,211,'03917562-1107-4a9c-84d4-ea3d07c7a35f',70,'6b6c3ea6fad948cbaee73bff3485d7da','volumes_tripleo',1,'2026-02-21 09:56:33',NULL),('2026-02-20 09:56:33','2026-02-20 09:56:33','2026-02-20 09:56:33',1,212,'feff76eb-e7ca-4e58-a3d3-cb1a66b0eb67',71,'6b6c3ea6fad948cbaee73bff3485d7da','gigabytes_tripleo',1,'2026-02-21 09:56:33',NULL),('2026-02-20 09:56:35','2026-02-20 09:56:35','2026-02-20 09:56:35',1,213,'a2ca0053-9a8e-4a25-b7a2-2823248a28c4',72,'6b6c3ea6fad948cbaee73bff3485d7da','snapshots',1,'2026-02-21 09:56:35',NULL),('2026-02-20 09:56:35','2026-02-20 09:56:35','2026-02-20 09:56:35',1,214,'40949d41-d541-4cc9-948b-57eff681bbbc',69,'6b6c3ea6fad948cbaee73bff3485d7da','gigabytes',1,'2026-02-21 09:56:35',NULL),('2026-02-20 09:56:35','2026-02-20 09:56:35','2026-02-20 09:56:35',1,215,'ffc9c0f3-fdf2-48b0-9a5c-6f5424523357',71,'6b6c3ea6fad948cbaee73bff3485d7da','gigabytes_tripleo',1,'2026-02-21 09:56:35',NULL),('2026-02-20 09:56:35','2026-02-20 09:56:35','2026-02-20 09:56:35',1,216,'c51949db-0921-41f1-ac27-3052c0c5830b',73,'6b6c3ea6fad948cbaee73bff3485d7da','snapshots_tripleo',1,'2026-02-21 09:56:35',NULL),('2026-02-20 09:56:37','2026-02-20 09:56:37','2026-02-20 09:56:37',1,217,'a0a152a5-08fd-42ff-af82-baf897942908',72,'6b6c3ea6fad948cbaee73bff3485d7da','snapshots',-1,'2026-02-21 09:56:37',NULL),('2026-02-20 09:56:37','2026-02-20 09:56:37','2026-02-20 09:56:37',1,218,'79efd056-b259-45a3-b71b-9c447bff0524',69,'6b6c3ea6fad948cbaee73bff3485d7da','gigabytes',-1,'2026-02-21 09:56:37',NULL),('2026-02-20 09:56:37','2026-02-20 09:56:37','2026-02-20 09:56:37',1,219,'50d39c88-66ae-41bc-9e2f-137cb8847ff9',71,'6b6c3ea6fad948cbaee73bff3485d7da','gigabytes_tripleo',-1,'2026-02-21 09:56:37',NULL),('2026-02-20 09:56:37','2026-02-20 09:56:37','2026-02-20 09:56:37',1,220,'505e7ecf-8782-4777-8202-5dee38a1f572',73,'6b6c3ea6fad948cbaee73bff3485d7da','snapshots_tripleo',-1,'2026-02-21 09:56:37',NULL),('2026-02-20 09:56:38','2026-02-20 09:56:38','2026-02-20 09:56:38',1,221,'e3ede56f-be1b-456c-be8b-f36a4232674a',68,'6b6c3ea6fad948cbaee73bff3485d7da','volumes',-1,'2026-02-21 09:56:38',NULL),('2026-02-20 09:56:38','2026-02-20 09:56:38','2026-02-20 09:56:38',1,222,'fc098916-4a6a-4dc8-8ad1-8eb6d2598014',69,'6b6c3ea6fad948cbaee73bff3485d7da','gigabytes',-1,'2026-02-21 09:56:38',NULL),('2026-02-20 09:56:38','2026-02-20 09:56:38','2026-02-20 09:56:38',1,223,'8ed76669-9e5d-4b90-b83e-5f9f1a7c3896',70,'6b6c3ea6fad948cbaee73bff3485d7da','volumes_tripleo',-1,'2026-02-21 09:56:38',NULL),('2026-02-20 09:56:38','2026-02-20 09:56:38','2026-02-20 09:56:38',1,224,'e75e677b-4cf8-4ffa-aad6-2128303b836e',71,'6b6c3ea6fad948cbaee73bff3485d7da','gigabytes_tripleo',-1,'2026-02-21 09:56:38',NULL),('2026-02-20 09:56:39','2026-02-20 09:56:39','2026-02-20 09:56:39',1,225,'03dd47b4-58d6-437e-96c6-e93f66636397',66,'226ab368400e4186b91e98a77b240268','backups',-1,'2026-02-21 09:56:39',NULL),('2026-02-20 09:56:39','2026-02-20 09:56:39','2026-02-20 09:56:39',1,226,'f66b02bd-e8ec-49f5-837f-6ec89bcbc680',67,'226ab368400e4186b91e98a77b240268','backup_gigabytes',-1,'2026-02-21 09:56:39',NULL),('2026-02-20 09:56:40','2026-02-20 09:56:40','2026-02-20 09:56:40',1,227,'c6e67ccf-38b7-4fb0-843d-9a5f5ce5125f',62,'226ab368400e4186b91e98a77b240268','volumes',-1,'2026-02-21 09:56:40',NULL),('2026-02-20 09:56:40','2026-02-20 09:56:40','2026-02-20 09:56:40',1,228,'5a060d24-cd14-4c21-bb9a-469daa4bb78b',63,'226ab368400e4186b91e98a77b240268','gigabytes',-1,'2026-02-21 09:56:40',NULL),('2026-02-20 09:56:40','2026-02-20 09:56:40','2026-02-20 09:56:40',1,229,'264b7570-d02d-40b4-becb-b18dd617c39f',64,'226ab368400e4186b91e98a77b240268','volumes_tripleo',-1,'2026-02-21 09:56:40',NULL),('2026-02-20 09:56:40','2026-02-20 09:56:40','2026-02-20 09:56:40',1,230,'87254bef-7294-4de6-9179-a3a17aebc9f9',65,'226ab368400e4186b91e98a77b240268','gigabytes_tripleo',-1,'2026-02-21 09:56:40',NULL),('2026-02-20 09:56:42','2026-02-20 09:56:42','2026-02-20 09:56:42',1,231,'3d30d4f5-0688-42f0-963b-3b5c0aadb18a',74,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','groups',1,'2026-02-21 09:56:42',NULL),('2026-02-20 09:56:43','2026-02-20 09:56:43','2026-02-20 09:56:43',1,232,'30cebd5c-d74c-4df3-bdb5-f574e71d9f9a',74,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','groups',1,'2026-02-21 09:56:43',NULL),('2026-02-20 09:56:44','2026-02-20 09:56:44','2026-02-20 09:56:44',1,233,'f7511c4a-69e9-4ca4-87a0-babe7d21c582',75,'c415a23ac6624be8b258d5fae2607759','volumes',1,'2026-02-21 09:56:43',NULL),('2026-02-20 09:56:44','2026-02-20 09:56:44','2026-02-20 09:56:44',1,234,'bde8e20c-713a-4777-8466-8c470bc33ab0',76,'c415a23ac6624be8b258d5fae2607759','gigabytes',1,'2026-02-21 09:56:43',NULL),('2026-02-20 09:56:44','2026-02-20 09:56:44','2026-02-20 09:56:44',1,235,'77941e20-9a7d-4655-8d74-d102d26b911e',77,'c415a23ac6624be8b258d5fae2607759','volumes_tripleo',1,'2026-02-21 09:56:43',NULL),('2026-02-20 09:56:44','2026-02-20 09:56:44','2026-02-20 09:56:44',1,236,'8b5cd5f9-6ba0-43ee-adec-f24aff443d9c',78,'c415a23ac6624be8b258d5fae2607759','gigabytes_tripleo',1,'2026-02-21 09:56:43',NULL),('2026-02-20 09:56:44','2026-02-20 09:56:44','2026-02-20 09:56:44',1,237,'e69c7eef-65b2-4853-a7ab-55649cb7ccde',79,'63c8b3e7b8b445b68b501883951607d3','volumes',1,'2026-02-21 09:56:44',NULL),('2026-02-20 09:56:44','2026-02-20 09:56:44','2026-02-20 09:56:44',1,238,'9fe649fe-3f38-4355-ae1f-4a82dedadce6',80,'63c8b3e7b8b445b68b501883951607d3','gigabytes',1,'2026-02-21 09:56:44',NULL),('2026-02-20 09:56:44','2026-02-20 09:56:44','2026-02-20 09:56:44',1,239,'cf903412-16ab-4f48-b144-0a66910cf37a',81,'63c8b3e7b8b445b68b501883951607d3','volumes_tripleo',1,'2026-02-21 09:56:44',NULL),('2026-02-20 09:56:44','2026-02-20 09:56:44','2026-02-20 09:56:44',1,240,'0c441d85-5014-4ca0-b741-94546e0a16c7',82,'63c8b3e7b8b445b68b501883951607d3','gigabytes_tripleo',1,'2026-02-21 09:56:44',NULL),('2026-02-20 09:56:45','2026-02-20 09:56:45','2026-02-20 09:56:45',1,241,'403e4486-7f29-4fa6-98b7-0d1a05dd2084',83,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','volumes',1,'2026-02-21 09:56:45',NULL),('2026-02-20 09:56:45','2026-02-20 09:56:45','2026-02-20 09:56:45',1,242,'027f7d8b-db83-4a4d-ac3f-4d6c22e6dd62',84,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','gigabytes',1,'2026-02-21 09:56:45',NULL),('2026-02-20 09:56:45','2026-02-20 09:56:45','2026-02-20 09:56:45',1,243,'d768e8a1-ed5f-4ac3-9058-92fb10c1a066',85,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','volumes_tempest-GroupsTest-volume-type-1805649748',1,'2026-02-21 09:56:45',NULL),('2026-02-20 09:56:45','2026-02-20 09:56:45','2026-02-20 09:56:45',1,244,'efd5d6db-a60e-4079-ac2f-efe184447c13',86,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','gigabytes_tempest-GroupsTest-volume-type-1805649748',1,'2026-02-21 09:56:45',NULL),('2026-02-20 09:56:47','2026-02-20 09:56:47','2026-02-20 09:56:47',1,245,'9d129b22-6605-4642-8f17-2e3f3a397c8c',74,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','groups',-1,'2026-02-21 09:56:47',NULL),('2026-02-20 09:56:47','2026-02-20 09:56:47','2026-02-20 09:56:47',1,246,'84e81007-4148-4d8b-a3fa-228e9ca26872',83,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','volumes',-1,'2026-02-21 09:56:47',NULL),('2026-02-20 09:56:47','2026-02-20 09:56:47','2026-02-20 09:56:47',1,247,'dbf4e48a-a13c-414c-97ab-0c3c06402db0',84,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','gigabytes',-1,'2026-02-21 09:56:47',NULL),('2026-02-20 09:56:47','2026-02-20 09:56:47','2026-02-20 09:56:47',1,248,'bee883b3-ebe6-4a42-a5a9-922e4e372f3f',85,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','volumes_tempest-GroupsTest-volume-type-1805649748',-1,'2026-02-21 09:56:47',NULL),('2026-02-20 09:56:47','2026-02-20 09:56:47','2026-02-20 09:56:47',1,249,'fe3db11c-9904-43f2-b987-79aff55174bc',86,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','gigabytes_tempest-GroupsTest-volume-type-1805649748',-1,'2026-02-21 09:56:47',NULL),('2026-02-20 09:56:48','2026-02-20 09:56:48','2026-02-20 09:56:48',1,250,'d2d48556-035e-4977-b61d-86e8e75176be',74,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','groups',-1,'2026-02-21 09:56:48',NULL),('2026-02-20 09:56:49','2026-02-20 09:56:49','2026-02-20 09:56:49',1,251,'e936f2d0-42d0-4f4b-bac0-749c0db02142',76,'c415a23ac6624be8b258d5fae2607759','gigabytes',1,'2026-02-21 09:56:49',NULL),('2026-02-20 09:56:49','2026-02-20 09:56:49','2026-02-20 09:56:49',1,252,'f69e2e07-2aa1-4a59-90cb-bed8c0b84cb5',78,'c415a23ac6624be8b258d5fae2607759','gigabytes_tripleo',1,'2026-02-21 09:56:49',NULL),('2026-02-20 09:56:49','2026-02-20 09:56:49','2026-02-20 09:56:49',1,253,'6899b82e-877a-4cd6-bb6c-e995f4df3616',74,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','groups',1,'2026-02-21 09:56:49',NULL),('2026-02-20 09:56:50','2026-02-20 09:56:50','2026-02-20 09:56:50',1,254,'0978ce05-e54a-4dcb-8223-8c299fc87b73',83,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','volumes',1,'2026-02-21 09:56:50',NULL),('2026-02-20 09:56:50','2026-02-20 09:56:50','2026-02-20 09:56:50',1,255,'93085d04-11eb-4080-851f-2b4476fa0b30',84,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','gigabytes',1,'2026-02-21 09:56:50',NULL),('2026-02-20 09:56:50','2026-02-20 09:56:50','2026-02-20 09:56:50',1,256,'88a61b1a-378a-45fa-a71f-df9f07ea93bd',87,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','volumes_tempest-GroupsTest-volume-type-1756718363',1,'2026-02-21 09:56:50',NULL),('2026-02-20 09:56:50','2026-02-20 09:56:50','2026-02-20 09:56:50',1,257,'54d9a959-1b06-4ab1-9768-40c21cc3039d',88,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','gigabytes_tempest-GroupsTest-volume-type-1756718363',1,'2026-02-21 09:56:50',NULL),('2026-02-20 09:56:51','2026-02-20 09:56:51','2026-02-20 09:56:51',1,258,'20ca6279-8287-4f9a-8cca-aa2f8eb9cea9',79,'63c8b3e7b8b445b68b501883951607d3','volumes',1,'2026-02-21 09:56:51',NULL),('2026-02-20 09:56:51','2026-02-20 09:56:51','2026-02-20 09:56:51',1,259,'74231b95-82c8-4a52-9aca-25acce2735c0',80,'63c8b3e7b8b445b68b501883951607d3','gigabytes',1,'2026-02-21 09:56:51',NULL),('2026-02-20 09:56:51','2026-02-20 09:56:51','2026-02-20 09:56:51',1,260,'569de4c7-139f-4e98-a0da-36f91d690f7e',81,'63c8b3e7b8b445b68b501883951607d3','volumes_tripleo',1,'2026-02-21 09:56:51',NULL),('2026-02-20 09:56:51','2026-02-20 09:56:51','2026-02-20 09:56:51',1,261,'dfe4c787-919b-414f-9fb8-828baf65fc10',82,'63c8b3e7b8b445b68b501883951607d3','gigabytes_tripleo',1,'2026-02-21 09:56:51',NULL),('2026-02-20 09:56:51','2026-02-20 09:56:52','2026-02-20 09:56:52',1,262,'1b0fd6bd-4b55-4868-9bab-2ce909574c84',75,'c415a23ac6624be8b258d5fae2607759','volumes',-1,'2026-02-21 09:56:51',NULL),('2026-02-20 09:56:51','2026-02-20 09:56:52','2026-02-20 09:56:52',1,263,'f22cf041-dd70-402e-8797-83656c1534e8',76,'c415a23ac6624be8b258d5fae2607759','gigabytes',-2,'2026-02-21 09:56:51',NULL),('2026-02-20 09:56:51','2026-02-20 09:56:52','2026-02-20 09:56:52',1,264,'182b92b2-a087-4cc6-9bf9-77dbb4eb7ba4',77,'c415a23ac6624be8b258d5fae2607759','volumes_tripleo',-1,'2026-02-21 09:56:51',NULL),('2026-02-20 09:56:51','2026-02-20 09:56:52','2026-02-20 09:56:52',1,265,'9b58034c-c91b-4073-acde-92f6bb14f25b',78,'c415a23ac6624be8b258d5fae2607759','gigabytes_tripleo',-2,'2026-02-21 09:56:51',NULL),('2026-02-20 09:56:52','2026-02-20 09:56:52','2026-02-20 09:56:52',1,266,'df74a5e3-7a2b-42f9-b97e-a8ecc2ef6a24',83,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','volumes',1,'2026-02-21 09:56:52',NULL),('2026-02-20 09:56:52','2026-02-20 09:56:52','2026-02-20 09:56:52',1,267,'20da1eaf-70e6-408d-931f-bc4ed918c15a',84,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','gigabytes',1,'2026-02-21 09:56:52',NULL),('2026-02-20 09:56:52','2026-02-20 09:56:52','2026-02-20 09:56:52',1,268,'d9b7c7e7-3453-4efd-9d78-f724b1c2e209',87,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','volumes_tempest-GroupsTest-volume-type-1756718363',1,'2026-02-21 09:56:52',NULL),('2026-02-20 09:56:52','2026-02-20 09:56:52','2026-02-20 09:56:52',1,269,'a2af556a-31a8-4e96-8b31-95fbc1257732',88,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','gigabytes_tempest-GroupsTest-volume-type-1756718363',1,'2026-02-21 09:56:52',NULL),('2026-02-20 09:56:52','2026-02-20 09:56:52','2026-02-20 09:56:52',1,270,'76f58910-5355-4709-9928-654e14cd9135',75,'c415a23ac6624be8b258d5fae2607759','volumes',1,'2026-02-21 09:56:52',NULL),('2026-02-20 09:56:52','2026-02-20 09:56:52','2026-02-20 09:56:52',1,271,'0e4e7d33-f387-40a7-828b-fbc076471fe4',76,'c415a23ac6624be8b258d5fae2607759','gigabytes',1,'2026-02-21 09:56:52',NULL),('2026-02-20 09:56:52','2026-02-20 09:56:52','2026-02-20 09:56:52',1,272,'386dfdb4-72b7-4148-9860-f71299a22879',77,'c415a23ac6624be8b258d5fae2607759','volumes_tripleo',1,'2026-02-21 09:56:52',NULL),('2026-02-20 09:56:52','2026-02-20 09:56:52','2026-02-20 09:56:52',1,273,'ca9b2af6-b4ff-4048-940f-81be27bbb092',78,'c415a23ac6624be8b258d5fae2607759','gigabytes_tripleo',1,'2026-02-21 09:56:52',NULL),('2026-02-20 09:56:53','2026-02-20 09:56:53','2026-02-20 09:56:53',1,274,'6840224f-10eb-408e-8e60-fd51151668fd',79,'63c8b3e7b8b445b68b501883951607d3','volumes',-1,'2026-02-21 09:56:53',NULL),('2026-02-20 09:56:53','2026-02-20 09:56:53','2026-02-20 09:56:53',1,275,'ecb52b4f-511b-4a9d-ae1b-030110983678',80,'63c8b3e7b8b445b68b501883951607d3','gigabytes',-1,'2026-02-21 09:56:53',NULL),('2026-02-20 09:56:53','2026-02-20 09:56:53','2026-02-20 09:56:53',1,276,'9c25525e-eb7e-4535-953c-af816373e88e',81,'63c8b3e7b8b445b68b501883951607d3','volumes_tripleo',-1,'2026-02-21 09:56:53',NULL),('2026-02-20 09:56:53','2026-02-20 09:56:53','2026-02-20 09:56:53',1,277,'bd1e571e-3049-4720-a62b-6dc840df4cb2',82,'63c8b3e7b8b445b68b501883951607d3','gigabytes_tripleo',-1,'2026-02-21 09:56:53',NULL),('2026-02-20 09:56:54','2026-02-20 09:56:54','2026-02-20 09:56:54',1,278,'2aac757b-0c08-4fdf-ade6-eb5badcad5bf',89,'c415a23ac6624be8b258d5fae2607759','snapshots',1,'2026-02-21 09:56:54',NULL),('2026-02-20 09:56:54','2026-02-20 09:56:54','2026-02-20 09:56:54',1,279,'d6c4690b-2698-4dbe-ac82-519314cab3e2',76,'c415a23ac6624be8b258d5fae2607759','gigabytes',1,'2026-02-21 09:56:54',NULL),('2026-02-20 09:56:54','2026-02-20 09:56:54','2026-02-20 09:56:54',1,280,'565d53cb-48b8-4ec4-8452-85de04f563a9',78,'c415a23ac6624be8b258d5fae2607759','gigabytes_tripleo',1,'2026-02-21 09:56:54',NULL),('2026-02-20 09:56:54','2026-02-20 09:56:54','2026-02-20 09:56:54',1,281,'7486dcad-45dd-4e78-8ab0-647ab6a2a42f',90,'c415a23ac6624be8b258d5fae2607759','snapshots_tripleo',1,'2026-02-21 09:56:54',NULL),('2026-02-20 09:56:54','2026-02-20 09:56:54','2026-02-20 09:56:54',1,282,'703df3df-1ddc-40e2-ad2c-ded0fc2c2359',79,'63c8b3e7b8b445b68b501883951607d3','volumes',-1,'2026-02-21 09:56:54',NULL),('2026-02-20 09:56:54','2026-02-20 09:56:54','2026-02-20 09:56:54',1,283,'26722abc-d47d-4814-ac77-82b2acc67174',80,'63c8b3e7b8b445b68b501883951607d3','gigabytes',-1,'2026-02-21 09:56:54',NULL),('2026-02-20 09:56:54','2026-02-20 09:56:54','2026-02-20 09:56:54',1,284,'9d56b515-a7cd-43c3-91e9-388a1e108cf8',81,'63c8b3e7b8b445b68b501883951607d3','volumes_tripleo',-1,'2026-02-21 09:56:54',NULL),('2026-02-20 09:56:54','2026-02-20 09:56:54','2026-02-20 09:56:54',1,285,'a17fd837-5570-4517-8b97-5495f4231e88',82,'63c8b3e7b8b445b68b501883951607d3','gigabytes_tripleo',-1,'2026-02-21 09:56:54',NULL),('2026-02-20 09:56:55','2026-02-20 09:56:55','2026-02-20 09:56:55',1,286,'38565569-9520-40f3-8e3c-369c96311826',76,'c415a23ac6624be8b258d5fae2607759','gigabytes',1,'2026-02-21 09:56:55',NULL),('2026-02-20 09:56:55','2026-02-20 09:56:55','2026-02-20 09:56:55',1,287,'b0e773c7-42f0-4d21-b651-268d27bc9a4d',78,'c415a23ac6624be8b258d5fae2607759','gigabytes_tripleo',1,'2026-02-21 09:56:55',NULL),('2026-02-20 09:56:55','2026-02-20 09:56:55','2026-02-20 09:56:55',1,288,'cd713c45-598b-43fa-8e3b-60b1fcd5ee13',79,'63c8b3e7b8b445b68b501883951607d3','volumes',1,'2026-02-21 09:56:55',NULL),('2026-02-20 09:56:55','2026-02-20 09:56:55','2026-02-20 09:56:55',1,289,'afda9311-d9a1-498e-90e8-d468bd56856c',80,'63c8b3e7b8b445b68b501883951607d3','gigabytes',1,'2026-02-21 09:56:55',NULL),('2026-02-20 09:56:55','2026-02-20 09:56:55','2026-02-20 09:56:55',1,290,'72974eb6-9e84-4c50-8db2-94e745c1d344',81,'63c8b3e7b8b445b68b501883951607d3','volumes_tripleo',1,'2026-02-21 09:56:55',NULL),('2026-02-20 09:56:55','2026-02-20 09:56:55','2026-02-20 09:56:55',1,291,'5aab7e46-ecb1-470e-b35d-a756021b0762',82,'63c8b3e7b8b445b68b501883951607d3','gigabytes_tripleo',1,'2026-02-21 09:56:55',NULL),('2026-02-20 09:56:56','2026-02-20 09:56:57','2026-02-20 09:56:57',1,292,'770d3440-5473-4d4f-af05-864e77610653',79,'63c8b3e7b8b445b68b501883951607d3','volumes',1,'2026-02-21 09:56:56',NULL),('2026-02-20 09:56:56','2026-02-20 09:56:57','2026-02-20 09:56:57',1,293,'466ec61f-8b2f-4ec1-b9e8-2bb8d682bdb2',80,'63c8b3e7b8b445b68b501883951607d3','gigabytes',2,'2026-02-21 09:56:56',NULL),('2026-02-20 09:56:56','2026-02-20 09:56:57','2026-02-20 09:56:57',1,294,'ed4a09a3-0b5f-4c11-877e-69df90810699',81,'63c8b3e7b8b445b68b501883951607d3','volumes_tripleo',1,'2026-02-21 09:56:56',NULL),('2026-02-20 09:56:56','2026-02-20 09:56:57','2026-02-20 09:56:57',1,295,'b7c253a2-c9d1-47ee-a81b-dc320e5a3fae',82,'63c8b3e7b8b445b68b501883951607d3','gigabytes_tripleo',2,'2026-02-21 09:56:56',NULL),('2026-02-20 09:56:57','2026-02-20 09:56:57','2026-02-20 09:56:57',1,296,'a8df4d6b-bb06-4f3b-b694-1db2c1770cd8',89,'c415a23ac6624be8b258d5fae2607759','snapshots',-1,'2026-02-21 09:56:57',NULL),('2026-02-20 09:56:57','2026-02-20 09:56:57','2026-02-20 09:56:57',1,297,'a98605e6-7fc0-457b-8b1c-ed020fabce63',76,'c415a23ac6624be8b258d5fae2607759','gigabytes',-1,'2026-02-21 09:56:57',NULL),('2026-02-20 09:56:57','2026-02-20 09:56:57','2026-02-20 09:56:57',1,298,'719747cd-1278-4902-b3f9-4de9e5c799d0',78,'c415a23ac6624be8b258d5fae2607759','gigabytes_tripleo',-1,'2026-02-21 09:56:57',NULL),('2026-02-20 09:56:57','2026-02-20 09:56:57','2026-02-20 09:56:57',1,299,'4a5d3ebb-9850-4387-88b3-4b2440e6eb7c',90,'c415a23ac6624be8b258d5fae2607759','snapshots_tripleo',-1,'2026-02-21 09:56:57',NULL),('2026-02-20 09:56:58','2026-02-20 09:56:58','2026-02-20 09:56:58',1,300,'9cbdbede-40b4-4ef6-91af-10b625ede0a0',74,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','groups',-1,'2026-02-21 09:56:58',NULL),('2026-02-20 09:56:58','2026-02-20 09:56:58','2026-02-20 09:56:58',1,301,'ef514777-beca-4ec9-a99a-d73f05368f17',83,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','volumes',-1,'2026-02-21 09:56:58',NULL),('2026-02-20 09:56:58','2026-02-20 09:56:58','2026-02-20 09:56:58',1,302,'baf06c71-e003-4320-8cca-3207b840e058',84,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','gigabytes',-1,'2026-02-21 09:56:58',NULL),('2026-02-20 09:56:58','2026-02-20 09:56:58','2026-02-20 09:56:58',1,303,'4c8682c9-6840-4e53-819d-ecc82c64ddf8',87,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','volumes_tempest-GroupsTest-volume-type-1756718363',-1,'2026-02-21 09:56:58',NULL),('2026-02-20 09:56:58','2026-02-20 09:56:58','2026-02-20 09:56:58',1,304,'392bd756-ae6f-457f-b7bf-cbb7d00c7b7d',88,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','gigabytes_tempest-GroupsTest-volume-type-1756718363',-1,'2026-02-21 09:56:58',NULL),('2026-02-20 09:56:58','2026-02-20 09:56:58','2026-02-20 09:56:58',1,305,'9e7738d2-4073-4658-921f-42c8013796d5',83,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','volumes',-1,'2026-02-21 09:56:58',NULL),('2026-02-20 09:56:58','2026-02-20 09:56:58','2026-02-20 09:56:58',1,306,'d5c49779-d48e-42af-8fc2-f78a9343cf8b',84,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','gigabytes',-1,'2026-02-21 09:56:58',NULL),('2026-02-20 09:56:58','2026-02-20 09:56:58','2026-02-20 09:56:58',1,307,'bbc744fe-e05c-43d3-995d-07ddbc73c4d3',87,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','volumes_tempest-GroupsTest-volume-type-1756718363',-1,'2026-02-21 09:56:58',NULL),('2026-02-20 09:56:58','2026-02-20 09:56:58','2026-02-20 09:56:58',1,308,'7db9bb3f-47e7-4376-82e2-abe7e46b9f91',88,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3','gigabytes_tempest-GroupsTest-volume-type-1756718363',-1,'2026-02-21 09:56:58',NULL),('2026-02-20 09:56:58','2026-02-20 09:56:59','2026-02-20 09:56:59',1,309,'b24fdfc9-e8c6-48fc-bd01-900d989dfe78',75,'c415a23ac6624be8b258d5fae2607759','volumes',-1,'2026-02-21 09:56:58',NULL),('2026-02-20 09:56:58','2026-02-20 09:56:59','2026-02-20 09:56:59',1,310,'cf0ad784-e875-45a2-859d-fafabcfd38e5',76,'c415a23ac6624be8b258d5fae2607759','gigabytes',-2,'2026-02-21 09:56:58',NULL),('2026-02-20 09:56:58','2026-02-20 09:56:59','2026-02-20 09:56:59',1,311,'2f34e455-7fb7-4044-9897-44a4502fac9d',77,'c415a23ac6624be8b258d5fae2607759','volumes_tripleo',-1,'2026-02-21 09:56:58',NULL),('2026-02-20 09:56:58','2026-02-20 09:56:59','2026-02-20 09:56:59',1,312,'1cb9a155-8715-4350-bb17-9bb4ad11db6a',78,'c415a23ac6624be8b258d5fae2607759','gigabytes_tripleo',-2,'2026-02-21 09:56:58',NULL),('2026-02-20 09:56:59','2026-02-20 09:56:59','2026-02-20 09:56:59',1,313,'c8d06173-9ffa-40ef-ab36-a76e48f5990c',79,'63c8b3e7b8b445b68b501883951607d3','volumes',-1,'2026-02-21 09:56:59',NULL),('2026-02-20 09:56:59','2026-02-20 09:56:59','2026-02-20 09:56:59',1,314,'b49e03a7-9f87-4ae9-985d-5922f57a5951',80,'63c8b3e7b8b445b68b501883951607d3','gigabytes',-2,'2026-02-21 09:56:59',NULL),('2026-02-20 09:56:59','2026-02-20 09:56:59','2026-02-20 09:56:59',1,315,'d254e8ad-34b7-4997-ba32-74a558fe8f30',81,'63c8b3e7b8b445b68b501883951607d3','volumes_tripleo',-1,'2026-02-21 09:56:59',NULL),('2026-02-20 09:56:59','2026-02-20 09:56:59','2026-02-20 09:56:59',1,316,'7dbe5918-5ac8-471a-9301-29695a45af2f',82,'63c8b3e7b8b445b68b501883951607d3','gigabytes_tripleo',-2,'2026-02-21 09:56:59',NULL),('2026-02-20 09:57:00','2026-02-20 09:57:00','2026-02-20 09:57:00',1,317,'999d1a1b-a709-4473-9a50-13c256cf2ea4',79,'63c8b3e7b8b445b68b501883951607d3','volumes',-1,'2026-02-21 09:57:00',NULL),('2026-02-20 09:57:00','2026-02-20 09:57:00','2026-02-20 09:57:00',1,318,'212cf1c8-1f64-4e72-bb73-fbeae0bdec15',80,'63c8b3e7b8b445b68b501883951607d3','gigabytes',-1,'2026-02-21 09:57:00',NULL),('2026-02-20 09:57:00','2026-02-20 09:57:00','2026-02-20 09:57:00',1,319,'023eee3e-d5f9-44e3-a15b-95e972d306d3',81,'63c8b3e7b8b445b68b501883951607d3','volumes_tripleo',-1,'2026-02-21 09:57:00',NULL),('2026-02-20 09:57:00','2026-02-20 09:57:00','2026-02-20 09:57:00',1,320,'7aa873c1-99bf-48ed-bd3e-179be749d13e',82,'63c8b3e7b8b445b68b501883951607d3','gigabytes_tripleo',-1,'2026-02-21 09:57:00',NULL),('2026-02-20 09:57:05','2026-02-20 09:57:05','2026-02-20 09:57:05',1,321,'f2f87aa9-ce09-4f8a-9d7a-f24795663d72',91,'eee793ed531548448eb1446c169fbf7a','groups',1,'2026-02-21 09:57:05',NULL),('2026-02-20 09:57:05','2026-02-20 09:57:05','2026-02-20 09:57:05',1,322,'9f840338-8794-463b-abdd-989e2945dd0c',92,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes',1,'2026-02-21 09:57:05',NULL),('2026-02-20 09:57:05','2026-02-20 09:57:05','2026-02-20 09:57:05',1,323,'dc186881-57f6-418f-b2ea-d292a36cd2f0',93,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes',1,'2026-02-21 09:57:05',NULL),('2026-02-20 09:57:05','2026-02-20 09:57:05','2026-02-20 09:57:05',1,324,'739bde6a-64af-476f-b25d-1f808007a277',94,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes_tripleo',1,'2026-02-21 09:57:05',NULL),('2026-02-20 09:57:05','2026-02-20 09:57:05','2026-02-20 09:57:05',1,325,'02efb2fa-001a-4a02-baa1-ff536fae9eb5',95,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes_tripleo',1,'2026-02-21 09:57:05',NULL),('2026-02-20 09:57:06','2026-02-20 09:57:06','2026-02-20 09:57:06',1,326,'a0c2e55a-234d-4b2a-b679-a2931c59c543',92,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes',1,'2026-02-21 09:57:06',NULL),('2026-02-20 09:57:06','2026-02-20 09:57:06','2026-02-20 09:57:06',1,327,'bfe97c89-2f77-4ddc-a128-0c1d40e09406',93,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes',1,'2026-02-21 09:57:06',NULL),('2026-02-20 09:57:06','2026-02-20 09:57:06','2026-02-20 09:57:06',1,328,'e7d81320-7992-4e90-8072-4d9d74720963',94,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes_tripleo',1,'2026-02-21 09:57:06',NULL),('2026-02-20 09:57:06','2026-02-20 09:57:06','2026-02-20 09:57:06',1,329,'1559789e-dc07-4459-a056-2e0fbaf97951',95,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes_tripleo',1,'2026-02-21 09:57:06',NULL),('2026-02-20 09:57:06','2026-02-20 09:57:06','2026-02-20 09:57:06',1,330,'2c161dc4-7705-4502-9d8a-114ec3126543',91,'eee793ed531548448eb1446c169fbf7a','groups',-1,'2026-02-21 09:57:06',NULL),('2026-02-20 09:57:08','2026-02-20 09:57:08','2026-02-20 09:57:08',1,331,'1cef94c3-b80a-4957-9b84-ef7f8079fbf5',92,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes',-1,'2026-02-21 09:57:08',NULL),('2026-02-20 09:57:08','2026-02-20 09:57:08','2026-02-20 09:57:08',1,332,'f89b0289-293b-4a41-8fe0-8f343de7ab51',93,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes',-1,'2026-02-21 09:57:08',NULL),('2026-02-20 09:57:08','2026-02-20 09:57:08','2026-02-20 09:57:08',1,333,'eb7f360c-b7e7-43e5-b5ec-c8e0f0f1bca9',94,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes_tripleo',-1,'2026-02-21 09:57:08',NULL),('2026-02-20 09:57:08','2026-02-20 09:57:08','2026-02-20 09:57:08',1,334,'1677910c-194d-47fe-89ac-42c302cee479',95,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes_tripleo',-1,'2026-02-21 09:57:08',NULL),('2026-02-20 09:57:09','2026-02-20 09:57:09','2026-02-20 09:57:09',1,335,'ce5dca6c-4549-4bbb-a363-ee653de55bd4',92,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes',-1,'2026-02-21 09:57:09',NULL),('2026-02-20 09:57:09','2026-02-20 09:57:09','2026-02-20 09:57:09',1,336,'c1882fcc-6bf2-4e70-b5d3-29df47a70645',93,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes',-1,'2026-02-21 09:57:09',NULL),('2026-02-20 09:57:09','2026-02-20 09:57:09','2026-02-20 09:57:09',1,337,'1a7214a7-367d-46cb-b515-2435ed8d8b54',94,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes_tripleo',-1,'2026-02-21 09:57:09',NULL),('2026-02-20 09:57:09','2026-02-20 09:57:09','2026-02-20 09:57:09',1,338,'4bcffa1b-9dc7-4bf8-8bd1-3ed4ebb038fc',95,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes_tripleo',-1,'2026-02-21 09:57:09',NULL),('2026-02-20 09:57:10','2026-02-20 09:57:10','2026-02-20 09:57:10',1,339,'49fa6197-ef07-43ce-a098-2bd60f6553b1',92,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes',1,'2026-02-21 09:57:10',NULL),('2026-02-20 09:57:10','2026-02-20 09:57:10','2026-02-20 09:57:10',1,340,'9cca1e2e-b1e1-4877-a8d4-ca2ed6a099f4',93,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes',1,'2026-02-21 09:57:10',NULL),('2026-02-20 09:57:10','2026-02-20 09:57:10','2026-02-20 09:57:10',1,341,'2cc9e264-53d3-49ae-a5e4-2c91493e2ddc',94,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes_tripleo',1,'2026-02-21 09:57:10',NULL),('2026-02-20 09:57:10','2026-02-20 09:57:10','2026-02-20 09:57:10',1,342,'e79272e9-9e84-4947-8b93-906fa89d6fbf',95,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes_tripleo',1,'2026-02-21 09:57:10',NULL),('2026-02-20 09:57:11','2026-02-20 09:57:11','2026-02-20 09:57:11',1,343,'1533587b-87e2-49be-9896-df240735bd08',92,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes',1,'2026-02-21 09:57:11',NULL),('2026-02-20 09:57:11','2026-02-20 09:57:11','2026-02-20 09:57:11',1,344,'b0ccf61c-0d3f-4796-8ae8-4e107c993b40',93,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes',1,'2026-02-21 09:57:11',NULL),('2026-02-20 09:57:11','2026-02-20 09:57:11','2026-02-20 09:57:11',1,345,'db969b4c-e830-4248-8859-917be1e3898a',94,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes_tripleo',1,'2026-02-21 09:57:11',NULL),('2026-02-20 09:57:11','2026-02-20 09:57:11','2026-02-20 09:57:11',1,346,'84bfd977-3550-4637-afa6-176a386f03c2',95,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes_tripleo',1,'2026-02-21 09:57:11',NULL),('2026-02-20 09:57:12','2026-02-20 09:57:12','2026-02-20 09:57:12',1,347,'f5eb8008-df6c-445b-8a01-43139fd78884',96,'b937092feb204d07b7daa9302db5204f','volumes',1,'2026-02-21 09:57:12',NULL),('2026-02-20 09:57:12','2026-02-20 09:57:12','2026-02-20 09:57:12',1,348,'86294589-7235-4976-a218-f0810a953701',97,'b937092feb204d07b7daa9302db5204f','gigabytes',1,'2026-02-21 09:57:12',NULL),('2026-02-20 09:57:12','2026-02-20 09:57:12','2026-02-20 09:57:12',1,349,'243942ea-647d-4a07-a330-00312135083e',98,'b937092feb204d07b7daa9302db5204f','volumes_tripleo',1,'2026-02-21 09:57:12',NULL),('2026-02-20 09:57:12','2026-02-20 09:57:12','2026-02-20 09:57:12',1,350,'deeb1711-8a0c-4dae-a1ea-87035d8576df',99,'b937092feb204d07b7daa9302db5204f','gigabytes_tripleo',1,'2026-02-21 09:57:12',NULL),('2026-02-20 09:57:13','2026-02-20 09:57:13','2026-02-20 09:57:13',1,351,'f0e83865-2395-4187-ad71-39096ecd4fe0',92,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes',1,'2026-02-21 09:57:13',NULL),('2026-02-20 09:57:13','2026-02-20 09:57:13','2026-02-20 09:57:13',1,352,'d4727c5f-965d-4309-a275-de283812faa5',93,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes',1,'2026-02-21 09:57:13',NULL),('2026-02-20 09:57:13','2026-02-20 09:57:13','2026-02-20 09:57:13',1,353,'13f28216-1bc7-4a18-a8d6-f37998ff67fe',94,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes_tripleo',1,'2026-02-21 09:57:13',NULL),('2026-02-20 09:57:13','2026-02-20 09:57:13','2026-02-20 09:57:13',1,354,'05d0eb3f-8966-423f-b7a8-5dc0dbedfaa5',95,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes_tripleo',1,'2026-02-21 09:57:13',NULL),('2026-02-20 09:57:14','2026-02-20 09:57:14','2026-02-20 09:57:14',1,355,'80d49c6a-fa8e-4669-b095-299b68313123',100,'b937092feb204d07b7daa9302db5204f','snapshots',1,'2026-02-21 09:57:14',NULL),('2026-02-20 09:57:14','2026-02-20 09:57:14','2026-02-20 09:57:14',1,356,'ec2bbc09-2c66-4e47-a60b-caca6d3da502',97,'b937092feb204d07b7daa9302db5204f','gigabytes',1,'2026-02-21 09:57:14',NULL),('2026-02-20 09:57:14','2026-02-20 09:57:14','2026-02-20 09:57:14',1,357,'8e558470-c1f6-45b5-a7e3-ff7cbfd08e62',99,'b937092feb204d07b7daa9302db5204f','gigabytes_tripleo',1,'2026-02-21 09:57:14',NULL),('2026-02-20 09:57:14','2026-02-20 09:57:14','2026-02-20 09:57:14',1,358,'1d2e6163-6641-4af4-b5fc-504ef22c4575',101,'b937092feb204d07b7daa9302db5204f','snapshots_tripleo',1,'2026-02-21 09:57:14',NULL),('2026-02-20 09:57:14','2026-02-20 09:57:14','2026-02-20 09:57:14',1,359,'70a6331a-9257-4e21-9493-0674b2041d87',92,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes',-1,'2026-02-21 09:57:14',NULL),('2026-02-20 09:57:14','2026-02-20 09:57:14','2026-02-20 09:57:14',1,360,'c8e7834d-db63-4068-a890-351e6a78dfe8',93,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes',-1,'2026-02-21 09:57:14',NULL),('2026-02-20 09:57:14','2026-02-20 09:57:14','2026-02-20 09:57:14',1,361,'b216d2b5-efb9-4333-9a2d-80b30a89292d',94,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes_tripleo',-1,'2026-02-21 09:57:14',NULL),('2026-02-20 09:57:14','2026-02-20 09:57:14','2026-02-20 09:57:14',1,362,'da40a501-4478-4ff9-9b21-60949bce46ea',95,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes_tripleo',-1,'2026-02-21 09:57:14',NULL),('2026-02-20 09:57:15','2026-02-20 09:57:15','2026-02-20 09:57:15',1,363,'56d96fb9-8ad7-4ee1-87d2-7beefbc5006a',92,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes',-1,'2026-02-21 09:57:15',NULL),('2026-02-20 09:57:15','2026-02-20 09:57:15','2026-02-20 09:57:15',1,364,'51e261e2-e74d-4e76-a0fc-eef9b3fb4d1c',93,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes',-1,'2026-02-21 09:57:15',NULL),('2026-02-20 09:57:15','2026-02-20 09:57:15','2026-02-20 09:57:15',1,365,'5cda1b02-48b5-467d-b312-5efc5860431d',94,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes_tripleo',-1,'2026-02-21 09:57:15',NULL),('2026-02-20 09:57:15','2026-02-20 09:57:15','2026-02-20 09:57:15',1,366,'4a92c81b-010a-4951-8bc8-747229f6c9d5',95,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes_tripleo',-1,'2026-02-21 09:57:15',NULL),('2026-02-20 09:57:16','2026-02-20 09:57:16','2026-02-20 09:57:16',1,367,'b84fdc89-5be4-4e65-be66-4ec63d00f5a5',100,'b937092feb204d07b7daa9302db5204f','snapshots',1,'2026-02-21 09:57:16',NULL),('2026-02-20 09:57:16','2026-02-20 09:57:16','2026-02-20 09:57:16',1,368,'84a8be34-e3d8-4520-a214-2b4999176931',97,'b937092feb204d07b7daa9302db5204f','gigabytes',1,'2026-02-21 09:57:16',NULL),('2026-02-20 09:57:16','2026-02-20 09:57:16','2026-02-20 09:57:16',1,369,'9db735f8-e9a2-438c-9837-f7168781330d',99,'b937092feb204d07b7daa9302db5204f','gigabytes_tripleo',1,'2026-02-21 09:57:16',NULL),('2026-02-20 09:57:16','2026-02-20 09:57:16','2026-02-20 09:57:16',1,370,'44192c6f-d65d-4a11-8214-5c0a234aeab7',101,'b937092feb204d07b7daa9302db5204f','snapshots_tripleo',1,'2026-02-21 09:57:16',NULL),('2026-02-20 09:57:16','2026-02-20 09:57:17','2026-02-20 09:57:17',1,371,'3017576c-f2a4-4546-882f-f5321548c4af',92,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes',-1,'2026-02-21 09:57:16',NULL),('2026-02-20 09:57:16','2026-02-20 09:57:17','2026-02-20 09:57:17',1,372,'3673d417-ce35-4c08-9ec6-0f0213f7c35d',93,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes',-1,'2026-02-21 09:57:16',NULL),('2026-02-20 09:57:16','2026-02-20 09:57:17','2026-02-20 09:57:17',1,373,'aea88cfb-3f1e-40ce-80b9-54f3cce23658',94,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes_tripleo',-1,'2026-02-21 09:57:16',NULL),('2026-02-20 09:57:16','2026-02-20 09:57:17','2026-02-20 09:57:17',1,374,'efdd80c7-4392-43b6-a76a-c36306b0c515',95,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes_tripleo',-1,'2026-02-21 09:57:16',NULL),('2026-02-20 09:57:17','2026-02-20 09:57:17','2026-02-20 09:57:17',1,375,'15021350-7667-4755-be67-2cf974efd3e6',92,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes',1,'2026-02-21 09:57:17',NULL),('2026-02-20 09:57:17','2026-02-20 09:57:17','2026-02-20 09:57:17',1,376,'b8b9a6ad-4973-4c5d-8372-fd93ee74be71',93,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes',1,'2026-02-21 09:57:17',NULL),('2026-02-20 09:57:17','2026-02-20 09:57:17','2026-02-20 09:57:17',1,377,'3af66c63-818f-444c-b55c-882b832dc00c',94,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes_tripleo',1,'2026-02-21 09:57:17',NULL),('2026-02-20 09:57:17','2026-02-20 09:57:17','2026-02-20 09:57:17',1,378,'774a100b-40f9-480e-8de6-ab7bbf04e8a8',95,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes_tripleo',1,'2026-02-21 09:57:17',NULL),('2026-02-20 09:57:19','2026-02-20 09:57:19','2026-02-20 09:57:19',1,379,'670342ce-b787-464b-bf9c-c67ccacb6c7f',100,'b937092feb204d07b7daa9302db5204f','snapshots',-1,'2026-02-21 09:57:19',NULL),('2026-02-20 09:57:19','2026-02-20 09:57:19','2026-02-20 09:57:19',1,380,'169be5fb-336b-46cb-b83e-51c88872b2cb',97,'b937092feb204d07b7daa9302db5204f','gigabytes',-1,'2026-02-21 09:57:19',NULL),('2026-02-20 09:57:19','2026-02-20 09:57:19','2026-02-20 09:57:19',1,381,'ed5c0cca-c264-4ac7-968b-e962926299f2',99,'b937092feb204d07b7daa9302db5204f','gigabytes_tripleo',-1,'2026-02-21 09:57:19',NULL),('2026-02-20 09:57:19','2026-02-20 09:57:19','2026-02-20 09:57:19',1,382,'602e52a5-5e8b-49cb-bb37-9e218dd8b265',101,'b937092feb204d07b7daa9302db5204f','snapshots_tripleo',-1,'2026-02-21 09:57:19',NULL),('2026-02-20 09:57:20','2026-02-20 09:57:20','2026-02-20 09:57:20',1,383,'3821349c-fb02-43e6-a72e-d5351355ec01',100,'b937092feb204d07b7daa9302db5204f','snapshots',1,'2026-02-21 09:57:20',NULL),('2026-02-20 09:57:20','2026-02-20 09:57:20','2026-02-20 09:57:20',1,384,'17a044f0-343e-4a77-8202-db0d949c322c',97,'b937092feb204d07b7daa9302db5204f','gigabytes',1,'2026-02-21 09:57:20',NULL),('2026-02-20 09:57:20','2026-02-20 09:57:20','2026-02-20 09:57:20',1,385,'9a765efc-9e8e-4441-b266-7c129591d69d',99,'b937092feb204d07b7daa9302db5204f','gigabytes_tripleo',1,'2026-02-21 09:57:20',NULL),('2026-02-20 09:57:20','2026-02-20 09:57:20','2026-02-20 09:57:20',1,386,'d58811c9-57e5-4225-9e9a-ea5989348f2c',101,'b937092feb204d07b7daa9302db5204f','snapshots_tripleo',1,'2026-02-21 09:57:20',NULL),('2026-02-20 09:57:24','2026-02-20 09:57:24','2026-02-20 09:57:24',1,387,'925a2edf-5344-464b-9307-bf87f5e3c9e2',100,'b937092feb204d07b7daa9302db5204f','snapshots',-1,'2026-02-21 09:57:23',NULL),('2026-02-20 09:57:24','2026-02-20 09:57:24','2026-02-20 09:57:24',1,388,'f651b78c-98e8-401e-889f-ddd44538ca99',97,'b937092feb204d07b7daa9302db5204f','gigabytes',-1,'2026-02-21 09:57:23',NULL),('2026-02-20 09:57:24','2026-02-20 09:57:24','2026-02-20 09:57:24',1,389,'5ff0ae57-f8cc-4c6e-9b2a-8b15e0e27f54',99,'b937092feb204d07b7daa9302db5204f','gigabytes_tripleo',-1,'2026-02-21 09:57:23',NULL),('2026-02-20 09:57:24','2026-02-20 09:57:24','2026-02-20 09:57:24',1,390,'8f0c29b6-dffb-4e38-98b3-0acb882e8d86',101,'b937092feb204d07b7daa9302db5204f','snapshots_tripleo',-1,'2026-02-21 09:57:23',NULL),('2026-02-20 09:57:24','2026-02-20 09:57:24','2026-02-20 09:57:24',1,391,'ddc18959-00de-4481-9d18-ef6bf5578ec3',92,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes',1,'2026-02-21 09:57:24',NULL),('2026-02-20 09:57:24','2026-02-20 09:57:24','2026-02-20 09:57:24',1,392,'9723dfd9-ca1f-4f20-a6e0-da1091980423',93,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes',1,'2026-02-21 09:57:24',NULL),('2026-02-20 09:57:24','2026-02-20 09:57:24','2026-02-20 09:57:24',1,393,'9ad61589-4b4c-49b0-b9a2-f82d2c814d6c',94,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes_tripleo',1,'2026-02-21 09:57:24',NULL),('2026-02-20 09:57:24','2026-02-20 09:57:24','2026-02-20 09:57:24',1,394,'d7d19b42-b7c3-4120-b7e5-2591cf1c866c',95,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes_tripleo',1,'2026-02-21 09:57:24',NULL),('2026-02-20 09:57:25','2026-02-20 09:57:25','2026-02-20 09:57:25',1,395,'f16acd41-4c53-4172-9fe3-1cc59952d618',100,'b937092feb204d07b7daa9302db5204f','snapshots',1,'2026-02-21 09:57:25',NULL),('2026-02-20 09:57:25','2026-02-20 09:57:25','2026-02-20 09:57:25',1,396,'68990c91-7cf0-43f8-8fc0-c3c4edca6383',97,'b937092feb204d07b7daa9302db5204f','gigabytes',1,'2026-02-21 09:57:25',NULL),('2026-02-20 09:57:25','2026-02-20 09:57:25','2026-02-20 09:57:25',1,397,'2adfe4ab-ed60-47b1-a5e0-112f6c124b71',99,'b937092feb204d07b7daa9302db5204f','gigabytes_tripleo',1,'2026-02-21 09:57:25',NULL),('2026-02-20 09:57:25','2026-02-20 09:57:25','2026-02-20 09:57:25',1,398,'5768637e-8685-4553-87c8-e7285d519968',101,'b937092feb204d07b7daa9302db5204f','snapshots_tripleo',1,'2026-02-21 09:57:25',NULL),('2026-02-20 09:57:26','2026-02-20 09:57:26','2026-02-20 09:57:26',1,399,'6708cd21-84bd-4d36-9313-d42aeff90679',92,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes',-1,'2026-02-21 09:57:26',NULL),('2026-02-20 09:57:26','2026-02-20 09:57:26','2026-02-20 09:57:26',1,400,'e5053ed6-d96b-413c-9716-7630166bdfe5',93,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes',-1,'2026-02-21 09:57:26',NULL),('2026-02-20 09:57:26','2026-02-20 09:57:26','2026-02-20 09:57:26',1,401,'eed9099a-45cd-40f0-93af-daa3a0f0ec5a',94,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes_tripleo',-1,'2026-02-21 09:57:26',NULL),('2026-02-20 09:57:26','2026-02-20 09:57:26','2026-02-20 09:57:26',1,402,'b9144e40-5b6c-4270-89b3-10af4fc9c6aa',95,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes_tripleo',-1,'2026-02-21 09:57:26',NULL),('2026-02-20 09:57:27','2026-02-20 09:57:27','2026-02-20 09:57:27',1,403,'7dd5652d-5cca-4fbc-b54d-8914eab2f74d',100,'b937092feb204d07b7daa9302db5204f','snapshots',-1,'2026-02-21 09:57:27',NULL),('2026-02-20 09:57:27','2026-02-20 09:57:27','2026-02-20 09:57:27',1,404,'d8f2f8c2-3b1c-44db-8ab2-f776a99ef8d8',97,'b937092feb204d07b7daa9302db5204f','gigabytes',-1,'2026-02-21 09:57:27',NULL),('2026-02-20 09:57:27','2026-02-20 09:57:27','2026-02-20 09:57:27',1,405,'67d1bd4a-7ba9-44db-a760-c9b6cbcc2c00',99,'b937092feb204d07b7daa9302db5204f','gigabytes_tripleo',-1,'2026-02-21 09:57:27',NULL),('2026-02-20 09:57:27','2026-02-20 09:57:27','2026-02-20 09:57:27',1,406,'0bc0342e-5b5e-4dc9-b6e9-655de1a85908',101,'b937092feb204d07b7daa9302db5204f','snapshots_tripleo',-1,'2026-02-21 09:57:27',NULL),('2026-02-20 09:57:27','2026-02-20 09:57:27','2026-02-20 09:57:27',1,407,'19ba3f41-c545-4048-8f2e-5851c5ce3932',100,'b937092feb204d07b7daa9302db5204f','snapshots',1,'2026-02-21 09:57:27',NULL),('2026-02-20 09:57:27','2026-02-20 09:57:27','2026-02-20 09:57:27',1,408,'074ba1c1-fb11-4953-8557-7727ff22af7f',97,'b937092feb204d07b7daa9302db5204f','gigabytes',1,'2026-02-21 09:57:27',NULL),('2026-02-20 09:57:27','2026-02-20 09:57:27','2026-02-20 09:57:27',1,409,'b9dc57f2-1cea-4124-9b40-d705dc073bae',99,'b937092feb204d07b7daa9302db5204f','gigabytes_tripleo',1,'2026-02-21 09:57:27',NULL),('2026-02-20 09:57:27','2026-02-20 09:57:27','2026-02-20 09:57:27',1,410,'27869d75-2e8d-44b3-b34a-06be2e0c4a5f',101,'b937092feb204d07b7daa9302db5204f','snapshots_tripleo',1,'2026-02-21 09:57:27',NULL),('2026-02-20 09:57:27','2026-02-20 09:57:27','2026-02-20 09:57:27',1,411,'4ff8012f-ca60-42e8-b7a2-838631cffaf9',92,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes',-1,'2026-02-21 09:57:27',NULL),('2026-02-20 09:57:27','2026-02-20 09:57:27','2026-02-20 09:57:27',1,412,'2112191d-0f33-4531-899c-1c74c65df6fd',93,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes',-1,'2026-02-21 09:57:27',NULL),('2026-02-20 09:57:27','2026-02-20 09:57:27','2026-02-20 09:57:27',1,413,'379869c3-f724-4bd2-98fd-c7da94b191e6',94,'43a8c5592dc64c5a935d4d8b5fb44ad8','volumes_tripleo',-1,'2026-02-21 09:57:27',NULL),('2026-02-20 09:57:27','2026-02-20 09:57:27','2026-02-20 09:57:27',1,414,'ce72f506-def4-47c0-8556-5c9533745bcc',95,'43a8c5592dc64c5a935d4d8b5fb44ad8','gigabytes_tripleo',-1,'2026-02-21 09:57:27',NULL),('2026-02-20 09:57:29','2026-02-20 09:57:29','2026-02-20 09:57:29',1,415,'29477552-4681-433a-9dd7-6d8d3eff7e04',102,'a48d774a595542e4a66f14036bc080ce','groups',1,'2026-02-21 09:57:29',NULL),('2026-02-20 09:57:30','2026-02-20 09:57:30','2026-02-20 09:57:30',1,416,'914b2b55-45ee-435f-aa82-5f190ec87d5a',100,'b937092feb204d07b7daa9302db5204f','snapshots',-1,'2026-02-21 09:57:30',NULL),('2026-02-20 09:57:30','2026-02-20 09:57:30','2026-02-20 09:57:30',1,417,'416cb58e-ce51-444f-a831-892d11250436',97,'b937092feb204d07b7daa9302db5204f','gigabytes',-1,'2026-02-21 09:57:30',NULL),('2026-02-20 09:57:30','2026-02-20 09:57:30','2026-02-20 09:57:30',1,418,'074cd53b-ddfa-4d5b-baf3-dd4943720637',99,'b937092feb204d07b7daa9302db5204f','gigabytes_tripleo',-1,'2026-02-21 09:57:30',NULL),('2026-02-20 09:57:30','2026-02-20 09:57:30','2026-02-20 09:57:30',1,419,'5bf81dcd-012b-46dc-9065-7ad574bf12a3',101,'b937092feb204d07b7daa9302db5204f','snapshots_tripleo',-1,'2026-02-21 09:57:30',NULL),('2026-02-20 09:57:30','2026-02-20 09:57:30','2026-02-20 09:57:30',1,420,'08ff53df-4a3a-431c-88ad-5608d9cdb757',103,'a48d774a595542e4a66f14036bc080ce','volumes',1,'2026-02-21 09:57:30',NULL),('2026-02-20 09:57:30','2026-02-20 09:57:30','2026-02-20 09:57:30',1,421,'5c3b661c-ea1b-4187-8cd8-c6b0768a96d0',104,'a48d774a595542e4a66f14036bc080ce','gigabytes',1,'2026-02-21 09:57:30',NULL),('2026-02-20 09:57:30','2026-02-20 09:57:30','2026-02-20 09:57:30',1,422,'b1b1e9ef-5557-446a-bb4d-5611de9753cf',105,'a48d774a595542e4a66f14036bc080ce','volumes_tempest-GroupSnapshotsV319Test-volume-type-1380989222',1,'2026-02-21 09:57:30',NULL),('2026-02-20 09:57:30','2026-02-20 09:57:30','2026-02-20 09:57:30',1,423,'5d789cac-2fc7-4fc0-b242-b93711505d57',106,'a48d774a595542e4a66f14036bc080ce','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-1380989222',1,'2026-02-21 09:57:30',NULL),('2026-02-20 09:57:32','2026-02-20 09:57:32','2026-02-20 09:57:32',1,424,'30dd99d2-f08c-4d2c-a5ec-2fa7b6e69955',100,'b937092feb204d07b7daa9302db5204f','snapshots',-1,'2026-02-21 09:57:32',NULL),('2026-02-20 09:57:32','2026-02-20 09:57:32','2026-02-20 09:57:32',1,425,'668e3f69-ddd5-4046-b8e2-6a6c66da37eb',97,'b937092feb204d07b7daa9302db5204f','gigabytes',-1,'2026-02-21 09:57:32',NULL),('2026-02-20 09:57:32','2026-02-20 09:57:32','2026-02-20 09:57:32',1,426,'023bad1b-d8d3-4b0c-bdd1-a30258650ea8',99,'b937092feb204d07b7daa9302db5204f','gigabytes_tripleo',-1,'2026-02-21 09:57:32',NULL),('2026-02-20 09:57:32','2026-02-20 09:57:32','2026-02-20 09:57:32',1,427,'1ddd310d-3026-4f20-a141-4672593b7e0f',101,'b937092feb204d07b7daa9302db5204f','snapshots_tripleo',-1,'2026-02-21 09:57:32',NULL),('2026-02-20 09:57:32','2026-02-20 09:57:32','2026-02-20 09:57:32',1,428,'718a55fe-4526-4956-a408-65c8b674e9ef',107,'a48d774a595542e4a66f14036bc080ce','snapshots',1,'2026-02-21 09:57:32',NULL),('2026-02-20 09:57:32','2026-02-20 09:57:32','2026-02-20 09:57:32',1,429,'24919ae2-5007-44c5-9e22-b166ee406848',104,'a48d774a595542e4a66f14036bc080ce','gigabytes',1,'2026-02-21 09:57:32',NULL),('2026-02-20 09:57:32','2026-02-20 09:57:32','2026-02-20 09:57:32',1,430,'11dd517e-0a6d-4b31-b5a2-74af1325a6d3',106,'a48d774a595542e4a66f14036bc080ce','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-1380989222',1,'2026-02-21 09:57:32',NULL),('2026-02-20 09:57:32','2026-02-20 09:57:32','2026-02-20 09:57:32',1,431,'0806b2e3-23d5-4324-8ca2-71866fe2896d',108,'a48d774a595542e4a66f14036bc080ce','snapshots_tempest-GroupSnapshotsV319Test-volume-type-1380989222',1,'2026-02-21 09:57:32',NULL),('2026-02-20 09:57:33','2026-02-20 09:57:33','2026-02-20 09:57:33',1,432,'b40757f1-1d8f-40d4-a573-23c4ad9ef825',96,'b937092feb204d07b7daa9302db5204f','volumes',-1,'2026-02-21 09:57:33',NULL),('2026-02-20 09:57:33','2026-02-20 09:57:33','2026-02-20 09:57:33',1,433,'82d97a97-0821-49d0-8281-6ebe451efdd4',97,'b937092feb204d07b7daa9302db5204f','gigabytes',-1,'2026-02-21 09:57:33',NULL),('2026-02-20 09:57:33','2026-02-20 09:57:33','2026-02-20 09:57:33',1,434,'cc872707-6bb9-4885-bd51-f440ce606ae7',98,'b937092feb204d07b7daa9302db5204f','volumes_tripleo',-1,'2026-02-21 09:57:33',NULL),('2026-02-20 09:57:33','2026-02-20 09:57:33','2026-02-20 09:57:33',1,435,'98892098-e2cb-4b5e-8541-02ace6154d8f',99,'b937092feb204d07b7daa9302db5204f','gigabytes_tripleo',-1,'2026-02-21 09:57:33',NULL),('2026-02-20 09:57:34','2026-02-20 09:57:34','2026-02-20 09:57:34',1,436,'690731f2-7bf1-46e6-9fd8-7fa2ff0df910',107,'a48d774a595542e4a66f14036bc080ce','snapshots',-1,'2026-02-21 09:57:34',NULL),('2026-02-20 09:57:34','2026-02-20 09:57:34','2026-02-20 09:57:34',1,437,'acd01238-831e-40d0-ac30-59502fa9abcf',104,'a48d774a595542e4a66f14036bc080ce','gigabytes',-1,'2026-02-21 09:57:34',NULL),('2026-02-20 09:57:34','2026-02-20 09:57:34','2026-02-20 09:57:34',1,438,'20e981ed-9415-4836-8259-51392e236b52',106,'a48d774a595542e4a66f14036bc080ce','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-1380989222',-1,'2026-02-21 09:57:34',NULL),('2026-02-20 09:57:34','2026-02-20 09:57:34','2026-02-20 09:57:34',1,439,'cf4dad0c-8093-43d5-814a-d30a0f64a9ae',108,'a48d774a595542e4a66f14036bc080ce','snapshots_tempest-GroupSnapshotsV319Test-volume-type-1380989222',-1,'2026-02-21 09:57:34',NULL),('2026-02-20 09:57:36','2026-02-20 09:57:36','2026-02-20 09:57:36',1,440,'d171d242-5497-4b4f-a30c-01033349ba65',102,'a48d774a595542e4a66f14036bc080ce','groups',-1,'2026-02-21 09:57:35',NULL),('2026-02-20 09:57:36','2026-02-20 09:57:36','2026-02-20 09:57:36',1,441,'1d25337b-7f02-422c-9c7c-07a0f47fb4b1',103,'a48d774a595542e4a66f14036bc080ce','volumes',-1,'2026-02-21 09:57:36',NULL),('2026-02-20 09:57:36','2026-02-20 09:57:36','2026-02-20 09:57:36',1,442,'06b0c50b-09f8-44ad-875f-9ad58ef3386c',104,'a48d774a595542e4a66f14036bc080ce','gigabytes',-1,'2026-02-21 09:57:36',NULL),('2026-02-20 09:57:36','2026-02-20 09:57:36','2026-02-20 09:57:36',1,443,'57b4f78e-f78b-4bda-b165-55c24fa20308',105,'a48d774a595542e4a66f14036bc080ce','volumes_tempest-GroupSnapshotsV319Test-volume-type-1380989222',-1,'2026-02-21 09:57:36',NULL),('2026-02-20 09:57:36','2026-02-20 09:57:36','2026-02-20 09:57:36',1,444,'86c22141-9467-4b4b-ba95-1b80e13531d4',106,'a48d774a595542e4a66f14036bc080ce','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-1380989222',-1,'2026-02-21 09:57:36',NULL),('2026-02-20 09:57:47','2026-02-20 09:57:47','2026-02-20 09:57:47',1,445,'3f07eb84-9a2d-4a2c-b5a7-8d55e9069c61',109,'128736e99cb541468aa88da3588f267d','volumes',1,'2026-02-21 09:57:47',NULL),('2026-02-20 09:57:47','2026-02-20 09:57:47','2026-02-20 09:57:47',1,446,'044144f8-28a9-4375-a411-46ee0b6c5238',110,'128736e99cb541468aa88da3588f267d','gigabytes',1,'2026-02-21 09:57:47',NULL),('2026-02-20 09:57:47','2026-02-20 09:57:47','2026-02-20 09:57:47',1,447,'2c5c073f-0fec-41b7-8169-54d83cdf4d4d',111,'128736e99cb541468aa88da3588f267d','volumes_tempest-UserMessagesTest-volume-type-507641628',1,'2026-02-21 09:57:47',NULL),('2026-02-20 09:57:47','2026-02-20 09:57:47','2026-02-20 09:57:47',1,448,'87a9f079-36ef-43d4-95a8-b37560563814',112,'128736e99cb541468aa88da3588f267d','gigabytes_tempest-UserMessagesTest-volume-type-507641628',1,'2026-02-21 09:57:47',NULL),('2026-02-20 09:57:48','2026-02-20 09:57:48','2026-02-20 09:57:48',1,449,'34f6ef7c-a4d1-4012-810b-1f7cfda15b61',109,'128736e99cb541468aa88da3588f267d','volumes',-1,'2026-02-21 09:57:48',NULL),('2026-02-20 09:57:48','2026-02-20 09:57:48','2026-02-20 09:57:48',1,450,'2db9da8c-1d37-4367-b7ae-9b7e8d157fad',110,'128736e99cb541468aa88da3588f267d','gigabytes',-1,'2026-02-21 09:57:48',NULL),('2026-02-20 09:57:48','2026-02-20 09:57:49','2026-02-20 09:57:49',1,451,'cbebb6a2-c3e5-40bc-8230-6f750303227a',111,'128736e99cb541468aa88da3588f267d','volumes_tempest-UserMessagesTest-volume-type-507641628',-1,'2026-02-21 09:57:48',NULL),('2026-02-20 09:57:48','2026-02-20 09:57:49','2026-02-20 09:57:49',1,452,'b51fee66-1388-40b4-b2d3-f142bf175a17',112,'128736e99cb541468aa88da3588f267d','gigabytes_tempest-UserMessagesTest-volume-type-507641628',-1,'2026-02-21 09:57:48',NULL),('2026-02-20 09:57:49','2026-02-20 09:57:49','2026-02-20 09:57:49',1,453,'f950290c-fd45-415b-9ecf-ebdbc578c21f',109,'128736e99cb541468aa88da3588f267d','volumes',1,'2026-02-21 09:57:49',NULL),('2026-02-20 09:57:49','2026-02-20 09:57:49','2026-02-20 09:57:49',1,454,'5e2c7296-2b89-4bab-a0f3-1bfb45a251a2',110,'128736e99cb541468aa88da3588f267d','gigabytes',1,'2026-02-21 09:57:49',NULL),('2026-02-20 09:57:49','2026-02-20 09:57:49','2026-02-20 09:57:49',1,455,'c56cd295-1a11-421c-aa38-e34cd619485a',113,'128736e99cb541468aa88da3588f267d','volumes_tempest-UserMessagesTest-volume-type-1936315209',1,'2026-02-21 09:57:49',NULL),('2026-02-20 09:57:49','2026-02-20 09:57:49','2026-02-20 09:57:49',1,456,'bd256552-cddc-4d48-a223-b67fb78ec901',114,'128736e99cb541468aa88da3588f267d','gigabytes_tempest-UserMessagesTest-volume-type-1936315209',1,'2026-02-21 09:57:49',NULL),('2026-02-20 09:57:50','2026-02-20 09:57:50','2026-02-20 09:57:50',1,457,'c8c88356-4412-42ec-9ff5-90eb0ed88d42',109,'128736e99cb541468aa88da3588f267d','volumes',-1,'2026-02-21 09:57:50',NULL),('2026-02-20 09:57:50','2026-02-20 09:57:50','2026-02-20 09:57:50',1,458,'c85f8562-a25a-4f6c-b3ad-492fb51dd3b2',110,'128736e99cb541468aa88da3588f267d','gigabytes',-1,'2026-02-21 09:57:50',NULL),('2026-02-20 09:57:50','2026-02-20 09:57:50','2026-02-20 09:57:50',1,459,'d2e4da85-d6c1-427e-b256-603e43f7cd7e',113,'128736e99cb541468aa88da3588f267d','volumes_tempest-UserMessagesTest-volume-type-1936315209',-1,'2026-02-21 09:57:50',NULL),('2026-02-20 09:57:50','2026-02-20 09:57:50','2026-02-20 09:57:50',1,460,'bd89caf6-60bb-4689-8ad9-3981434646d4',114,'128736e99cb541468aa88da3588f267d','gigabytes_tempest-UserMessagesTest-volume-type-1936315209',-1,'2026-02-21 09:57:50',NULL),('2026-02-20 09:57:51','2026-02-20 09:57:51','2026-02-20 09:57:51',1,461,'1330ce4a-0b06-4853-aae5-583e7c196921',115,'51750f18434b4b60802ec6c49b096963','volumes',1,'2026-02-21 09:57:51',NULL),('2026-02-20 09:57:51','2026-02-20 09:57:51','2026-02-20 09:57:51',1,462,'c3fd3d2d-40bb-4d44-a3a7-104cb1c190ea',116,'51750f18434b4b60802ec6c49b096963','gigabytes',1,'2026-02-21 09:57:51',NULL),('2026-02-20 09:57:51','2026-02-20 09:57:51','2026-02-20 09:57:51',1,463,'2a9403f1-de98-4410-9e08-a71d4661b868',117,'51750f18434b4b60802ec6c49b096963','volumes_tripleo',1,'2026-02-21 09:57:51',NULL),('2026-02-20 09:57:51','2026-02-20 09:57:51','2026-02-20 09:57:51',1,464,'31fbe376-a131-40aa-99d9-4c53f6ba3cc7',118,'51750f18434b4b60802ec6c49b096963','gigabytes_tripleo',1,'2026-02-21 09:57:51',NULL),('2026-02-20 09:57:52','2026-02-20 09:57:52','2026-02-20 09:57:52',1,465,'5647f586-a564-45be-a74d-e77a785086bb',119,'51750f18434b4b60802ec6c49b096963','snapshots',1,'2026-02-21 09:57:52',NULL),('2026-02-20 09:57:52','2026-02-20 09:57:52','2026-02-20 09:57:52',1,466,'9f973eaf-9070-41bc-b2a9-fd0f5c0b5b27',116,'51750f18434b4b60802ec6c49b096963','gigabytes',1,'2026-02-21 09:57:52',NULL),('2026-02-20 09:57:52','2026-02-20 09:57:52','2026-02-20 09:57:52',1,467,'f94dea94-d5c0-4d74-9a85-025c00409261',118,'51750f18434b4b60802ec6c49b096963','gigabytes_tripleo',1,'2026-02-21 09:57:52',NULL),('2026-02-20 09:57:52','2026-02-20 09:57:52','2026-02-20 09:57:52',1,468,'a81cac79-4aec-4aca-8bfa-439faa9134a1',120,'51750f18434b4b60802ec6c49b096963','snapshots_tripleo',1,'2026-02-21 09:57:52',NULL),('2026-02-20 09:57:55','2026-02-20 09:57:55','2026-02-20 09:57:55',1,469,'3ba9256e-e16c-4dd1-9f57-1a7dda71ed73',119,'51750f18434b4b60802ec6c49b096963','snapshots',-1,'2026-02-21 09:57:55',NULL),('2026-02-20 09:57:55','2026-02-20 09:57:55','2026-02-20 09:57:55',1,470,'1aaa1d50-8591-4cb0-a8ee-9a46e1b5a564',116,'51750f18434b4b60802ec6c49b096963','gigabytes',-1,'2026-02-21 09:57:55',NULL),('2026-02-20 09:57:55','2026-02-20 09:57:55','2026-02-20 09:57:55',1,471,'3149098e-4d35-4114-be5f-d31c8466533d',118,'51750f18434b4b60802ec6c49b096963','gigabytes_tripleo',-1,'2026-02-21 09:57:55',NULL),('2026-02-20 09:57:55','2026-02-20 09:57:55','2026-02-20 09:57:55',1,472,'d00a4268-bad1-4128-bbb6-0b10745d8bd6',120,'51750f18434b4b60802ec6c49b096963','snapshots_tripleo',-1,'2026-02-21 09:57:55',NULL),('2026-02-20 09:57:56','2026-02-20 09:57:56','2026-02-20 09:57:56',1,473,'ee1cb4eb-264c-4be3-b097-b5a0d57e6e7a',115,'51750f18434b4b60802ec6c49b096963','volumes',-1,'2026-02-21 09:57:56',NULL),('2026-02-20 09:57:56','2026-02-20 09:57:56','2026-02-20 09:57:56',1,474,'f6b2bb27-323b-49c6-a596-0e17a63205ef',116,'51750f18434b4b60802ec6c49b096963','gigabytes',-1,'2026-02-21 09:57:56',NULL),('2026-02-20 09:57:56','2026-02-20 09:57:56','2026-02-20 09:57:56',1,475,'55833c39-0043-4cdc-aff2-3497a6a03972',117,'51750f18434b4b60802ec6c49b096963','volumes_tripleo',-1,'2026-02-21 09:57:56',NULL),('2026-02-20 09:57:56','2026-02-20 09:57:56','2026-02-20 09:57:56',1,476,'2c2ee4a2-0f7e-4153-bd97-197a9eb90c7f',118,'51750f18434b4b60802ec6c49b096963','gigabytes_tripleo',-1,'2026-02-21 09:57:56',NULL),('2026-02-20 09:58:01','2026-02-20 09:58:01','2026-02-20 09:58:01',1,477,'18b09aa3-82e9-4e6a-ba27-18e17cd0264f',121,'0507ba67b65244e7a826c6949689a381','volumes',1,'2026-02-21 09:58:01',NULL),('2026-02-20 09:58:01','2026-02-20 09:58:01','2026-02-20 09:58:01',1,478,'6f079aa3-1893-4eb6-a7d6-83434d0d2224',122,'0507ba67b65244e7a826c6949689a381','gigabytes',1,'2026-02-21 09:58:01',NULL),('2026-02-20 09:58:01','2026-02-20 09:58:01','2026-02-20 09:58:01',1,479,'89e62bc4-71ae-4567-a198-b0435e82ffdc',123,'0507ba67b65244e7a826c6949689a381','volumes_tripleo',1,'2026-02-21 09:58:01',NULL),('2026-02-20 09:58:01','2026-02-20 09:58:01','2026-02-20 09:58:01',1,480,'264aa6e7-9231-4e5d-b1b8-48046402417f',124,'0507ba67b65244e7a826c6949689a381','gigabytes_tripleo',1,'2026-02-21 09:58:01',NULL),('2026-02-20 09:58:03','2026-02-20 09:58:03','2026-02-20 09:58:03',1,481,'329d9d41-7c3b-44ca-a3da-2cbdbc2a3f56',125,'d0fbb54da9274272b09aae9be8d15d07','volumes',1,'2026-02-21 09:58:03',NULL),('2026-02-20 09:58:03','2026-02-20 09:58:03','2026-02-20 09:58:03',1,482,'51126e3b-104c-4457-904b-a40aa9cb212c',126,'d0fbb54da9274272b09aae9be8d15d07','gigabytes',1,'2026-02-21 09:58:03',NULL),('2026-02-20 09:58:03','2026-02-20 09:58:03','2026-02-20 09:58:03',1,483,'88377475-458c-45a3-888e-169fcc25b1e5',127,'d0fbb54da9274272b09aae9be8d15d07','volumes_tripleo',1,'2026-02-21 09:58:03',NULL),('2026-02-20 09:58:03','2026-02-20 09:58:03','2026-02-20 09:58:03',1,484,'77718261-7c0f-429a-8c85-b839154e69b0',128,'d0fbb54da9274272b09aae9be8d15d07','gigabytes_tripleo',1,'2026-02-21 09:58:03',NULL),('2026-02-20 09:58:03','2026-02-20 09:58:03','2026-02-20 09:58:03',1,485,'63125da9-f34d-40cd-8616-e54ddf048724',121,'0507ba67b65244e7a826c6949689a381','volumes',-1,'2026-02-21 09:58:03',NULL),('2026-02-20 09:58:03','2026-02-20 09:58:03','2026-02-20 09:58:03',1,486,'65d9620f-9816-482c-a1e6-5195c620173c',122,'0507ba67b65244e7a826c6949689a381','gigabytes',-1,'2026-02-21 09:58:03',NULL),('2026-02-20 09:58:03','2026-02-20 09:58:03','2026-02-20 09:58:03',1,487,'c7f2353c-fcb3-47d5-aa67-a912432ac22d',123,'0507ba67b65244e7a826c6949689a381','volumes_tripleo',-1,'2026-02-21 09:58:03',NULL),('2026-02-20 09:58:03','2026-02-20 09:58:03','2026-02-20 09:58:03',1,488,'a5a98f82-f1c0-4c0e-987d-3f29253af02d',124,'0507ba67b65244e7a826c6949689a381','gigabytes_tripleo',-1,'2026-02-21 09:58:03',NULL),('2026-02-20 09:58:04','2026-02-20 09:58:04','2026-02-20 09:58:04',1,489,'1a2353e6-b748-4e8e-a5cc-fd5d721310d0',125,'d0fbb54da9274272b09aae9be8d15d07','volumes',-1,'2026-02-21 09:58:04',NULL),('2026-02-20 09:58:04','2026-02-20 09:58:04','2026-02-20 09:58:04',1,490,'76cd457d-564e-4ec0-ab03-ffb2d29b6e6d',126,'d0fbb54da9274272b09aae9be8d15d07','gigabytes',-1,'2026-02-21 09:58:04',NULL),('2026-02-20 09:58:04','2026-02-20 09:58:04','2026-02-20 09:58:04',1,491,'5cca3314-9f20-4323-a437-ded6eec9e1bd',127,'d0fbb54da9274272b09aae9be8d15d07','volumes_tripleo',-1,'2026-02-21 09:58:04',NULL),('2026-02-20 09:58:04','2026-02-20 09:58:04','2026-02-20 09:58:04',1,492,'4c7d4105-3684-4df8-b058-34d399dd33d4',128,'d0fbb54da9274272b09aae9be8d15d07','gigabytes_tripleo',-1,'2026-02-21 09:58:04',NULL),('2026-02-20 09:58:05','2026-02-20 09:58:05','2026-02-20 09:58:05',1,493,'d290f5eb-52be-4d86-a107-de6959dcb2bd',125,'d0fbb54da9274272b09aae9be8d15d07','volumes',1,'2026-02-21 09:58:05',NULL),('2026-02-20 09:58:05','2026-02-20 09:58:05','2026-02-20 09:58:05',1,494,'ce3afbc5-94cf-4fc6-8a43-b6331fca6391',126,'d0fbb54da9274272b09aae9be8d15d07','gigabytes',1,'2026-02-21 09:58:05',NULL),('2026-02-20 09:58:05','2026-02-20 09:58:05','2026-02-20 09:58:05',1,495,'57294ed3-7f5e-430b-84a0-20932657aa4e',127,'d0fbb54da9274272b09aae9be8d15d07','volumes_tripleo',1,'2026-02-21 09:58:05',NULL),('2026-02-20 09:58:05','2026-02-20 09:58:05','2026-02-20 09:58:05',1,496,'0e0fcee7-a16d-4eea-947d-8e35651e0c7f',128,'d0fbb54da9274272b09aae9be8d15d07','gigabytes_tripleo',1,'2026-02-21 09:58:05',NULL),('2026-02-20 09:58:07','2026-02-20 09:58:07','2026-02-20 09:58:07',1,497,'722f616a-556c-4612-bd93-a17370e7686b',129,'c6099dcc2ecd4794925d1793d1a2a72c','volumes',1,'2026-02-21 09:58:07',NULL),('2026-02-20 09:58:07','2026-02-20 09:58:07','2026-02-20 09:58:07',1,498,'851cb7f7-3baf-4b54-bbcc-812cd938315f',130,'c6099dcc2ecd4794925d1793d1a2a72c','gigabytes',1,'2026-02-21 09:58:07',NULL),('2026-02-20 09:58:07','2026-02-20 09:58:07','2026-02-20 09:58:07',1,499,'7c39b4d8-3c2d-408a-847a-25a2c57adf18',131,'c6099dcc2ecd4794925d1793d1a2a72c','volumes_tripleo',1,'2026-02-21 09:58:07',NULL),('2026-02-20 09:58:07','2026-02-20 09:58:07','2026-02-20 09:58:07',1,500,'8514b03b-631e-456a-be0b-47eeb30016ee',132,'c6099dcc2ecd4794925d1793d1a2a72c','gigabytes_tripleo',1,'2026-02-21 09:58:07',NULL),('2026-02-20 09:58:07','2026-02-20 09:58:07','2026-02-20 09:58:07',1,501,'57f6189f-3aa3-419e-ba09-d0f4ea58416d',125,'d0fbb54da9274272b09aae9be8d15d07','volumes',-1,'2026-02-21 09:58:07',NULL),('2026-02-20 09:58:07','2026-02-20 09:58:07','2026-02-20 09:58:07',1,502,'8549c159-f7a8-4142-aff8-1116561ad754',126,'d0fbb54da9274272b09aae9be8d15d07','gigabytes',-1,'2026-02-21 09:58:07',NULL),('2026-02-20 09:58:07','2026-02-20 09:58:07','2026-02-20 09:58:07',1,503,'98db7ef0-1d06-4b7e-92e9-7bbfc815a7a1',127,'d0fbb54da9274272b09aae9be8d15d07','volumes_tripleo',-1,'2026-02-21 09:58:07',NULL),('2026-02-20 09:58:07','2026-02-20 09:58:07','2026-02-20 09:58:07',1,504,'181eaa7f-aacc-4b5b-9f22-f2d00c0561ab',128,'d0fbb54da9274272b09aae9be8d15d07','gigabytes_tripleo',-1,'2026-02-21 09:58:07',NULL),('2026-02-20 09:58:07','2026-02-20 09:58:07','2026-02-20 09:58:07',1,505,'500b032e-829f-4a10-ae09-92f414b94f35',133,'c6099dcc2ecd4794925d1793d1a2a72c','snapshots',0,'2026-02-21 09:58:07',NULL),('2026-02-20 09:58:07','2026-02-20 09:58:07','2026-02-20 09:58:07',1,506,'f6569ab0-3ca4-45ab-871c-6e9a2a3663c5',130,'c6099dcc2ecd4794925d1793d1a2a72c','gigabytes',0,'2026-02-21 09:58:07',NULL),('2026-02-20 09:58:07','2026-02-20 09:58:07','2026-02-20 09:58:07',1,507,'aa688271-6d7b-465c-9a21-9acba06b372e',132,'c6099dcc2ecd4794925d1793d1a2a72c','gigabytes_tripleo',0,'2026-02-21 09:58:07',NULL),('2026-02-20 09:58:07','2026-02-20 09:58:07','2026-02-20 09:58:07',1,508,'7fb25a5e-c11d-4063-b54a-14de4e7c4145',134,'c6099dcc2ecd4794925d1793d1a2a72c','snapshots_tripleo',0,'2026-02-21 09:58:07',NULL),('2026-02-20 09:58:07','2026-02-20 09:58:07','2026-02-20 09:58:07',1,509,'50f9f8d6-a118-44f6-aa67-76e4784e424c',135,'d0fbb54da9274272b09aae9be8d15d07','snapshots',0,'2026-02-21 09:58:07',NULL),('2026-02-20 09:58:07','2026-02-20 09:58:07','2026-02-20 09:58:07',1,510,'b11b0cd5-f017-4329-b085-89ef0a1e3b19',126,'d0fbb54da9274272b09aae9be8d15d07','gigabytes',0,'2026-02-21 09:58:07',NULL),('2026-02-20 09:58:07','2026-02-20 09:58:07','2026-02-20 09:58:07',1,511,'401ac40c-6ee5-4b8c-8ab0-ba4f9e6c7f89',128,'d0fbb54da9274272b09aae9be8d15d07','gigabytes_tripleo',0,'2026-02-21 09:58:07',NULL),('2026-02-20 09:58:07','2026-02-20 09:58:07','2026-02-20 09:58:07',1,512,'b5f68dc8-223e-4a1e-bebe-7630a82aed92',136,'d0fbb54da9274272b09aae9be8d15d07','snapshots_tripleo',0,'2026-02-21 09:58:07',NULL),('2026-02-20 09:58:07','2026-02-20 09:58:07','2026-02-20 09:58:07',1,513,'ccf242ed-e372-4db5-8118-5b319474f44d',129,'c6099dcc2ecd4794925d1793d1a2a72c','volumes',-1,'2026-02-21 09:58:07',NULL),('2026-02-20 09:58:07','2026-02-20 09:58:07','2026-02-20 09:58:07',1,514,'0e14845f-39a3-4968-8b8f-79c6ced01268',130,'c6099dcc2ecd4794925d1793d1a2a72c','gigabytes',-1,'2026-02-21 09:58:07',NULL),('2026-02-20 09:58:07','2026-02-20 09:58:07','2026-02-20 09:58:07',1,515,'6dcb3012-75f7-436a-81e9-9731883a02bb',131,'c6099dcc2ecd4794925d1793d1a2a72c','volumes_tripleo',-1,'2026-02-21 09:58:07',NULL),('2026-02-20 09:58:07','2026-02-20 09:58:07','2026-02-20 09:58:07',1,516,'d5e4f542-a694-4e0b-b083-87bb111c1583',132,'c6099dcc2ecd4794925d1793d1a2a72c','gigabytes_tripleo',-1,'2026-02-21 09:58:07',NULL),('2026-02-20 09:58:08','2026-02-20 09:58:08','2026-02-20 09:58:08',1,517,'2f5d3bb1-aaf1-4261-ae5c-54119cdcba5a',137,'8a43ccd6212d4626a208a271337f7a5b','volumes',1,'2026-02-21 09:58:08',NULL),('2026-02-20 09:58:08','2026-02-20 09:58:08','2026-02-20 09:58:08',1,518,'04a4550a-cb1d-4429-8703-82147559febe',138,'8a43ccd6212d4626a208a271337f7a5b','gigabytes',1,'2026-02-21 09:58:08',NULL),('2026-02-20 09:58:08','2026-02-20 09:58:08','2026-02-20 09:58:08',1,519,'26bcf80f-4a70-4080-b3cc-f722433e78ec',139,'8a43ccd6212d4626a208a271337f7a5b','volumes_tripleo',1,'2026-02-21 09:58:08',NULL),('2026-02-20 09:58:08','2026-02-20 09:58:08','2026-02-20 09:58:08',1,520,'0b56ad4f-c098-41db-97a0-bd53c23b589b',140,'8a43ccd6212d4626a208a271337f7a5b','gigabytes_tripleo',1,'2026-02-21 09:58:08',NULL),('2026-02-20 09:58:10','2026-02-20 09:58:10','2026-02-20 09:58:10',1,521,'e02e4b8c-ab8e-4f01-ae9e-8b63c59fbadb',141,'8a43ccd6212d4626a208a271337f7a5b','snapshots',1,'2026-02-21 09:58:10',NULL),('2026-02-20 09:58:10','2026-02-20 09:58:10','2026-02-20 09:58:10',1,522,'38ee58bd-f570-49ae-a840-f9d0ee2e79f4',138,'8a43ccd6212d4626a208a271337f7a5b','gigabytes',1,'2026-02-21 09:58:10',NULL),('2026-02-20 09:58:10','2026-02-20 09:58:10','2026-02-20 09:58:10',1,523,'c945e4b9-d4e3-4a8f-b379-cfbe39caa1c8',140,'8a43ccd6212d4626a208a271337f7a5b','gigabytes_tripleo',1,'2026-02-21 09:58:10',NULL),('2026-02-20 09:58:10','2026-02-20 09:58:10','2026-02-20 09:58:10',1,524,'63815759-7b6d-4683-810a-c19c8bc17b6d',142,'8a43ccd6212d4626a208a271337f7a5b','snapshots_tripleo',1,'2026-02-21 09:58:10',NULL),('2026-02-20 09:58:11','2026-02-20 09:58:11','2026-02-20 09:58:11',1,525,'9fa5d2be-576d-46fa-9f38-cc303575fe4f',141,'8a43ccd6212d4626a208a271337f7a5b','snapshots',1,'2026-02-21 09:58:11',NULL),('2026-02-20 09:58:11','2026-02-20 09:58:11','2026-02-20 09:58:11',1,526,'5cd15012-4309-4ef4-b6c3-63d3d77b5d89',138,'8a43ccd6212d4626a208a271337f7a5b','gigabytes',1,'2026-02-21 09:58:11',NULL),('2026-02-20 09:58:11','2026-02-20 09:58:11','2026-02-20 09:58:11',1,527,'e72f5bda-f176-40f9-9885-bf7475d5b40f',140,'8a43ccd6212d4626a208a271337f7a5b','gigabytes_tripleo',1,'2026-02-21 09:58:11',NULL),('2026-02-20 09:58:11','2026-02-20 09:58:11','2026-02-20 09:58:11',1,528,'34610d1f-79ff-49c2-a659-4eb18ae5d331',142,'8a43ccd6212d4626a208a271337f7a5b','snapshots_tripleo',1,'2026-02-21 09:58:11',NULL),('2026-02-20 09:58:14','2026-02-20 09:58:14','2026-02-20 09:58:14',1,529,'e0392beb-5c0b-4035-b474-d826ba4d06a2',141,'8a43ccd6212d4626a208a271337f7a5b','snapshots',-1,'2026-02-21 09:58:14',NULL),('2026-02-20 09:58:14','2026-02-20 09:58:14','2026-02-20 09:58:14',1,530,'3b78c300-ce07-4c9f-a33c-456a51f27b8d',138,'8a43ccd6212d4626a208a271337f7a5b','gigabytes',-1,'2026-02-21 09:58:14',NULL),('2026-02-20 09:58:14','2026-02-20 09:58:14','2026-02-20 09:58:14',1,531,'b6578849-70a1-4352-8f0e-69aafd6554a6',140,'8a43ccd6212d4626a208a271337f7a5b','gigabytes_tripleo',-1,'2026-02-21 09:58:14',NULL),('2026-02-20 09:58:14','2026-02-20 09:58:14','2026-02-20 09:58:14',1,532,'530c49ad-21c1-4ec6-8fd5-c4231cf9ae98',142,'8a43ccd6212d4626a208a271337f7a5b','snapshots_tripleo',-1,'2026-02-21 09:58:14',NULL),('2026-02-20 09:58:15','2026-02-20 09:58:15','2026-02-20 09:58:15',1,533,'971823eb-ff2e-4741-9b31-1368518b0e3f',141,'8a43ccd6212d4626a208a271337f7a5b','snapshots',-1,'2026-02-21 09:58:15',NULL),('2026-02-20 09:58:15','2026-02-20 09:58:15','2026-02-20 09:58:15',1,534,'d872638c-b3ce-4646-bae9-9dd91efd14ef',138,'8a43ccd6212d4626a208a271337f7a5b','gigabytes',-1,'2026-02-21 09:58:15',NULL),('2026-02-20 09:58:15','2026-02-20 09:58:15','2026-02-20 09:58:15',1,535,'a5318e9a-1946-468c-b313-b6735aed26b0',140,'8a43ccd6212d4626a208a271337f7a5b','gigabytes_tripleo',-1,'2026-02-21 09:58:15',NULL),('2026-02-20 09:58:15','2026-02-20 09:58:15','2026-02-20 09:58:15',1,536,'e04feeca-870f-4ab1-a8a5-3d63985e85e3',142,'8a43ccd6212d4626a208a271337f7a5b','snapshots_tripleo',-1,'2026-02-21 09:58:15',NULL),('2026-02-20 09:58:15','2026-02-20 09:58:15','2026-02-20 09:58:15',1,537,'8460e92f-902c-49cf-9bab-b3206b4d8545',137,'8a43ccd6212d4626a208a271337f7a5b','volumes',-1,'2026-02-21 09:58:15',NULL),('2026-02-20 09:58:15','2026-02-20 09:58:15','2026-02-20 09:58:15',1,538,'157e3c7c-d90b-4c7f-87d4-da87e0486ea3',138,'8a43ccd6212d4626a208a271337f7a5b','gigabytes',-1,'2026-02-21 09:58:15',NULL),('2026-02-20 09:58:15','2026-02-20 09:58:15','2026-02-20 09:58:15',1,539,'5b38b2e0-e3dd-4ef2-8de6-d839cd5b1dbc',139,'8a43ccd6212d4626a208a271337f7a5b','volumes_tripleo',-1,'2026-02-21 09:58:15',NULL),('2026-02-20 09:58:15','2026-02-20 09:58:15','2026-02-20 09:58:15',1,540,'eb5339da-7825-45dc-a501-b7b5a640db19',140,'8a43ccd6212d4626a208a271337f7a5b','gigabytes_tripleo',-1,'2026-02-21 09:58:15',NULL),('2026-02-20 09:58:16','2026-02-20 09:58:16','2026-02-20 09:58:16',1,541,'2d636fe9-3cd2-44b3-838e-a9a3c63ddef6',143,'b39170cd6b2b43fa90080079febc7f43','volumes',1,'2026-02-21 09:58:16',NULL),('2026-02-20 09:58:16','2026-02-20 09:58:16','2026-02-20 09:58:16',1,542,'f305531f-a690-499d-b1ec-7985a2d0448a',144,'b39170cd6b2b43fa90080079febc7f43','gigabytes',1,'2026-02-21 09:58:16',NULL),('2026-02-20 09:58:16','2026-02-20 09:58:16','2026-02-20 09:58:16',1,543,'a411a0a3-7359-4462-91e6-52c04ee971e1',145,'b39170cd6b2b43fa90080079febc7f43','volumes_tripleo',1,'2026-02-21 09:58:16',NULL),('2026-02-20 09:58:16','2026-02-20 09:58:16','2026-02-20 09:58:16',1,544,'ef35e48a-37a8-4628-bdfb-4f52379b0446',146,'b39170cd6b2b43fa90080079febc7f43','gigabytes_tripleo',1,'2026-02-21 09:58:16',NULL),('2026-02-20 09:58:16','2026-02-20 09:58:16','2026-02-20 09:58:16',1,545,'d7fc4c52-78b3-4995-8439-9f56c135a547',137,'8a43ccd6212d4626a208a271337f7a5b','volumes',1,'2026-02-21 09:58:16',NULL),('2026-02-20 09:58:16','2026-02-20 09:58:16','2026-02-20 09:58:16',1,546,'6c50460d-46a3-4a50-a2d4-ba215bf1ad53',138,'8a43ccd6212d4626a208a271337f7a5b','gigabytes',1,'2026-02-21 09:58:16',NULL),('2026-02-20 09:58:16','2026-02-20 09:58:16','2026-02-20 09:58:16',1,547,'3e5dbaab-256a-4837-aa2f-aec6701e1c61',139,'8a43ccd6212d4626a208a271337f7a5b','volumes_tripleo',1,'2026-02-21 09:58:16',NULL),('2026-02-20 09:58:16','2026-02-20 09:58:16','2026-02-20 09:58:16',1,548,'7dc2d7f0-3139-4507-9b30-6de74f430bad',140,'8a43ccd6212d4626a208a271337f7a5b','gigabytes_tripleo',1,'2026-02-21 09:58:16',NULL),('2026-02-20 09:58:17','2026-02-20 09:58:17','2026-02-20 09:58:17',1,549,'e01db326-801f-410d-96dd-9ba3f1863f5e',141,'8a43ccd6212d4626a208a271337f7a5b','snapshots',1,'2026-02-21 09:58:17',NULL),('2026-02-20 09:58:17','2026-02-20 09:58:17','2026-02-20 09:58:17',1,550,'949d8363-84b4-4b45-a950-9887bb8c2672',138,'8a43ccd6212d4626a208a271337f7a5b','gigabytes',1,'2026-02-21 09:58:17',NULL),('2026-02-20 09:58:17','2026-02-20 09:58:17','2026-02-20 09:58:17',1,551,'c2396136-5ee2-4f66-b91d-4c8938d3587b',140,'8a43ccd6212d4626a208a271337f7a5b','gigabytes_tripleo',1,'2026-02-21 09:58:17',NULL),('2026-02-20 09:58:17','2026-02-20 09:58:17','2026-02-20 09:58:17',1,552,'0783da33-dbbb-4ec6-9489-75c49dcc750f',142,'8a43ccd6212d4626a208a271337f7a5b','snapshots_tripleo',1,'2026-02-21 09:58:17',NULL),('2026-02-20 09:58:18','2026-02-20 09:58:18','2026-02-20 09:58:18',1,553,'7c9b8403-4250-4831-bc17-5483be0ed96b',143,'b39170cd6b2b43fa90080079febc7f43','volumes',-1,'2026-02-21 09:58:18',NULL),('2026-02-20 09:58:18','2026-02-20 09:58:18','2026-02-20 09:58:18',1,554,'0e0fd167-b8dc-4bb8-8d75-39ab4b0991c9',144,'b39170cd6b2b43fa90080079febc7f43','gigabytes',-1,'2026-02-21 09:58:18',NULL),('2026-02-20 09:58:18','2026-02-20 09:58:18','2026-02-20 09:58:18',1,555,'dbe8b5d4-7506-4b76-8b50-f4a4cf7803ea',145,'b39170cd6b2b43fa90080079febc7f43','volumes_tripleo',-1,'2026-02-21 09:58:18',NULL),('2026-02-20 09:58:18','2026-02-20 09:58:18','2026-02-20 09:58:18',1,556,'4e57d4f3-1c42-470a-8eb6-fb5701a9c4cf',146,'b39170cd6b2b43fa90080079febc7f43','gigabytes_tripleo',-1,'2026-02-21 09:58:18',NULL),('2026-02-20 09:58:18','2026-02-20 09:58:18','2026-02-20 09:58:18',1,557,'9c634c11-ce8c-4534-906c-a183536bdced',137,'8a43ccd6212d4626a208a271337f7a5b','volumes',1,'2026-02-21 09:58:18',NULL),('2026-02-20 09:58:18','2026-02-20 09:58:18','2026-02-20 09:58:18',1,558,'53786930-c3d5-48bd-a53b-be0607cf7d4f',138,'8a43ccd6212d4626a208a271337f7a5b','gigabytes',1,'2026-02-21 09:58:18',NULL),('2026-02-20 09:58:18','2026-02-20 09:58:18','2026-02-20 09:58:18',1,559,'bf714dbc-91fd-4d09-bd91-408658e8ce93',139,'8a43ccd6212d4626a208a271337f7a5b','volumes_tripleo',1,'2026-02-21 09:58:18',NULL),('2026-02-20 09:58:18','2026-02-20 09:58:18','2026-02-20 09:58:18',1,560,'579fc711-6a43-4ed3-8320-8d6ac3bc84f6',140,'8a43ccd6212d4626a208a271337f7a5b','gigabytes_tripleo',1,'2026-02-21 09:58:18',NULL),('2026-02-20 09:58:20','2026-02-20 09:58:20','2026-02-20 09:58:20',1,561,'101c2af9-e287-418d-a691-94dbaa4546c6',147,'d0e47cd34a784cbb89cbe56eafed5650','volumes',1,'2026-02-21 09:58:20',NULL),('2026-02-20 09:58:20','2026-02-20 09:58:20','2026-02-20 09:58:20',1,562,'c37a7a94-6b7d-491d-ab9c-1c93a3b151bf',148,'d0e47cd34a784cbb89cbe56eafed5650','gigabytes',1,'2026-02-21 09:58:20',NULL),('2026-02-20 09:58:20','2026-02-20 09:58:20','2026-02-20 09:58:20',1,563,'9de04d34-992d-40fe-b6a2-ab84ec6d6e79',149,'d0e47cd34a784cbb89cbe56eafed5650','volumes_tripleo',1,'2026-02-21 09:58:20',NULL),('2026-02-20 09:58:20','2026-02-20 09:58:20','2026-02-20 09:58:20',1,564,'811622b4-3b76-437a-aea6-c78bb8a1d5a4',150,'d0e47cd34a784cbb89cbe56eafed5650','gigabytes_tripleo',1,'2026-02-21 09:58:20',NULL),('2026-02-20 09:58:22','2026-02-20 09:58:22','2026-02-20 09:58:22',1,565,'e6ce4985-6430-42ec-8fee-fa3b5e8f4230',147,'d0e47cd34a784cbb89cbe56eafed5650','volumes',-1,'2026-02-21 09:58:22',NULL),('2026-02-20 09:58:22','2026-02-20 09:58:22','2026-02-20 09:58:22',1,566,'edab8c73-bdba-4429-a469-aa26f6279a65',148,'d0e47cd34a784cbb89cbe56eafed5650','gigabytes',-1,'2026-02-21 09:58:22',NULL),('2026-02-20 09:58:22','2026-02-20 09:58:22','2026-02-20 09:58:22',1,567,'0e0e1255-bb14-47c1-a723-03e8bbf35cae',149,'d0e47cd34a784cbb89cbe56eafed5650','volumes_tripleo',-1,'2026-02-21 09:58:22',NULL),('2026-02-20 09:58:22','2026-02-20 09:58:22','2026-02-20 09:58:22',1,568,'9ccddb70-b8b0-4ecb-b35d-f6bb5843b30a',150,'d0e47cd34a784cbb89cbe56eafed5650','gigabytes_tripleo',-1,'2026-02-21 09:58:22',NULL),('2026-02-20 09:58:23','2026-02-20 09:58:23','2026-02-20 09:58:23',1,569,'544cbef2-a43d-4bf2-8844-df88fea43be8',147,'d0e47cd34a784cbb89cbe56eafed5650','volumes',1,'2026-02-21 09:58:23',NULL),('2026-02-20 09:58:23','2026-02-20 09:58:23','2026-02-20 09:58:23',1,570,'c6a4e95b-2255-409e-9288-ab6ad2c96f54',148,'d0e47cd34a784cbb89cbe56eafed5650','gigabytes',1,'2026-02-21 09:58:23',NULL),('2026-02-20 09:58:23','2026-02-20 09:58:23','2026-02-20 09:58:23',1,571,'ef9eb707-882c-459a-8624-f3295f72ff76',149,'d0e47cd34a784cbb89cbe56eafed5650','volumes_tripleo',1,'2026-02-21 09:58:23',NULL),('2026-02-20 09:58:23','2026-02-20 09:58:23','2026-02-20 09:58:23',1,572,'3804a690-87ad-4812-8833-89619f172ee8',150,'d0e47cd34a784cbb89cbe56eafed5650','gigabytes_tripleo',1,'2026-02-21 09:58:23',NULL),('2026-02-20 09:58:25','2026-02-20 09:58:25','2026-02-20 09:58:25',1,573,'22e1cafb-9abd-420b-b7c7-5a45f13e84e8',147,'d0e47cd34a784cbb89cbe56eafed5650','volumes',-1,'2026-02-21 09:58:25',NULL),('2026-02-20 09:58:25','2026-02-20 09:58:25','2026-02-20 09:58:25',1,574,'4fdaafbe-88c7-40b8-93c3-576479b722e4',148,'d0e47cd34a784cbb89cbe56eafed5650','gigabytes',-1,'2026-02-21 09:58:25',NULL),('2026-02-20 09:58:25','2026-02-20 09:58:25','2026-02-20 09:58:25',1,575,'1ed662a8-6354-4df0-b09c-5a16e8a9e34a',149,'d0e47cd34a784cbb89cbe56eafed5650','volumes_tripleo',-1,'2026-02-21 09:58:25',NULL),('2026-02-20 09:58:25','2026-02-20 09:58:25','2026-02-20 09:58:25',1,576,'38898f23-d984-4b33-96e5-ae70e321a406',150,'d0e47cd34a784cbb89cbe56eafed5650','gigabytes_tripleo',-1,'2026-02-21 09:58:25',NULL),('2026-02-20 09:58:25','2026-02-20 09:58:25','2026-02-20 09:58:25',1,577,'06ff4e4b-21c5-4086-8410-479973a0041d',147,'d0e47cd34a784cbb89cbe56eafed5650','volumes',1,'2026-02-21 09:58:25',NULL),('2026-02-20 09:58:25','2026-02-20 09:58:25','2026-02-20 09:58:25',1,578,'17ea46a0-80be-4fa1-9689-22fc638d2d40',148,'d0e47cd34a784cbb89cbe56eafed5650','gigabytes',1,'2026-02-21 09:58:25',NULL),('2026-02-20 09:58:25','2026-02-20 09:58:25','2026-02-20 09:58:25',1,579,'d83cb1b1-d90f-4027-a228-d025d8961d81',149,'d0e47cd34a784cbb89cbe56eafed5650','volumes_tripleo',1,'2026-02-21 09:58:25',NULL),('2026-02-20 09:58:25','2026-02-20 09:58:25','2026-02-20 09:58:25',1,580,'b75e4d62-f0bd-4295-8580-dc17766d7608',150,'d0e47cd34a784cbb89cbe56eafed5650','gigabytes_tripleo',1,'2026-02-21 09:58:25',NULL),('2026-02-20 09:58:26','2026-02-20 09:58:26','2026-02-20 09:58:26',1,581,'36c16e83-426c-4412-aeef-90b27c248aa1',141,'8a43ccd6212d4626a208a271337f7a5b','snapshots',-1,'2026-02-21 09:58:26',NULL),('2026-02-20 09:58:26','2026-02-20 09:58:26','2026-02-20 09:58:26',1,582,'3772764d-649f-4eed-939d-f19f3a52f0dd',138,'8a43ccd6212d4626a208a271337f7a5b','gigabytes',-1,'2026-02-21 09:58:26',NULL),('2026-02-20 09:58:26','2026-02-20 09:58:26','2026-02-20 09:58:26',1,583,'08124b90-57b7-4bd3-adb8-c127a10fc901',140,'8a43ccd6212d4626a208a271337f7a5b','gigabytes_tripleo',-1,'2026-02-21 09:58:26',NULL),('2026-02-20 09:58:26','2026-02-20 09:58:26','2026-02-20 09:58:26',1,584,'31aa565e-8f6d-4238-b36c-fef087a900c7',142,'8a43ccd6212d4626a208a271337f7a5b','snapshots_tripleo',-1,'2026-02-21 09:58:26',NULL),('2026-02-20 09:58:26','2026-02-20 09:58:26','2026-02-20 09:58:26',1,585,'0cf63c01-dcec-4b19-9ec2-c5c9ae1b9962',137,'8a43ccd6212d4626a208a271337f7a5b','volumes',-1,'2026-02-21 09:58:26',NULL),('2026-02-20 09:58:26','2026-02-20 09:58:26','2026-02-20 09:58:26',1,586,'41d31706-f119-4076-91ef-c1c308bcee7f',138,'8a43ccd6212d4626a208a271337f7a5b','gigabytes',-1,'2026-02-21 09:58:26',NULL),('2026-02-20 09:58:26','2026-02-20 09:58:26','2026-02-20 09:58:26',1,587,'5a37e26f-f5b7-4c7a-89e0-c3bc7047ffa4',139,'8a43ccd6212d4626a208a271337f7a5b','volumes_tripleo',-1,'2026-02-21 09:58:26',NULL),('2026-02-20 09:58:26','2026-02-20 09:58:26','2026-02-20 09:58:26',1,588,'8e54605e-1b21-4ae8-b1d9-5907df903b35',140,'8a43ccd6212d4626a208a271337f7a5b','gigabytes_tripleo',-1,'2026-02-21 09:58:26',NULL),('2026-02-20 09:58:27','2026-02-20 09:58:27','2026-02-20 09:58:27',1,589,'6f0e9f40-99ee-4469-93f7-f563e7ef20e8',147,'d0e47cd34a784cbb89cbe56eafed5650','volumes',-1,'2026-02-21 09:58:27',NULL),('2026-02-20 09:58:27','2026-02-20 09:58:27','2026-02-20 09:58:27',1,590,'1da5bf0a-034c-484b-bcbb-ed36556fd789',148,'d0e47cd34a784cbb89cbe56eafed5650','gigabytes',-1,'2026-02-21 09:58:27',NULL),('2026-02-20 09:58:27','2026-02-20 09:58:27','2026-02-20 09:58:27',1,591,'b9610dce-6e51-4f79-8565-38cd2827bf31',149,'d0e47cd34a784cbb89cbe56eafed5650','volumes_tripleo',-1,'2026-02-21 09:58:27',NULL),('2026-02-20 09:58:27','2026-02-20 09:58:27','2026-02-20 09:58:27',1,592,'20ebdf7a-938d-429e-b0f5-488d56973461',150,'d0e47cd34a784cbb89cbe56eafed5650','gigabytes_tripleo',-1,'2026-02-21 09:58:27',NULL),('2026-02-20 09:58:28','2026-02-20 09:58:28','2026-02-20 09:58:28',1,593,'681d4787-051d-4799-96e9-a47151989c35',137,'8a43ccd6212d4626a208a271337f7a5b','volumes',-1,'2026-02-21 09:58:28',NULL),('2026-02-20 09:58:28','2026-02-20 09:58:28','2026-02-20 09:58:28',1,594,'9da5bb1f-3b53-4297-9394-d781e3f7a036',138,'8a43ccd6212d4626a208a271337f7a5b','gigabytes',-1,'2026-02-21 09:58:28',NULL),('2026-02-20 09:58:28','2026-02-20 09:58:28','2026-02-20 09:58:28',1,595,'54f8869c-72a6-4a45-951c-64d16302b8da',139,'8a43ccd6212d4626a208a271337f7a5b','volumes_tripleo',-1,'2026-02-21 09:58:28',NULL),('2026-02-20 09:58:28','2026-02-20 09:58:28','2026-02-20 09:58:28',1,596,'fc8ac492-41d1-4a12-ba7e-1753be80ead4',140,'8a43ccd6212d4626a208a271337f7a5b','gigabytes_tripleo',-1,'2026-02-21 09:58:28',NULL),('2026-02-20 09:58:28','2026-02-20 09:58:28','2026-02-20 09:58:28',1,597,'d29b4b31-9da0-4733-a219-0eb62acac95f',147,'d0e47cd34a784cbb89cbe56eafed5650','volumes',1,'2026-02-21 09:58:28',NULL),('2026-02-20 09:58:28','2026-02-20 09:58:28','2026-02-20 09:58:28',1,598,'0aab3b7a-db12-4a86-a06b-5889a0d5fa1b',148,'d0e47cd34a784cbb89cbe56eafed5650','gigabytes',1,'2026-02-21 09:58:28',NULL),('2026-02-20 09:58:28','2026-02-20 09:58:28','2026-02-20 09:58:28',1,599,'1eec3830-cc45-4c70-be2b-fed793a86f1f',149,'d0e47cd34a784cbb89cbe56eafed5650','volumes_tripleo',1,'2026-02-21 09:58:28',NULL),('2026-02-20 09:58:28','2026-02-20 09:58:28','2026-02-20 09:58:28',1,600,'3a858c30-6a42-4b45-bacf-ea582a6c04fa',150,'d0e47cd34a784cbb89cbe56eafed5650','gigabytes_tripleo',1,'2026-02-21 09:58:28',NULL),('2026-02-20 09:58:30','2026-02-20 09:58:30','2026-02-20 09:58:30',1,601,'884ebc6a-b74f-48a9-9871-9976547d8711',147,'d0e47cd34a784cbb89cbe56eafed5650','volumes',-1,'2026-02-21 09:58:30',NULL),('2026-02-20 09:58:30','2026-02-20 09:58:30','2026-02-20 09:58:30',1,602,'97a85994-9bec-4390-85cf-0dd0f5c7b3bd',148,'d0e47cd34a784cbb89cbe56eafed5650','gigabytes',-1,'2026-02-21 09:58:30',NULL),('2026-02-20 09:58:30','2026-02-20 09:58:30','2026-02-20 09:58:30',1,603,'4a829b52-8414-48c8-b28c-40f0cea0c6a8',149,'d0e47cd34a784cbb89cbe56eafed5650','volumes_tripleo',-1,'2026-02-21 09:58:30',NULL),('2026-02-20 09:58:30','2026-02-20 09:58:30','2026-02-20 09:58:30',1,604,'bd37d598-62f7-4d98-b823-bbce738c499d',150,'d0e47cd34a784cbb89cbe56eafed5650','gigabytes_tripleo',-1,'2026-02-21 09:58:30',NULL),('2026-02-20 09:58:30','2026-02-20 09:58:30','2026-02-20 09:58:30',1,605,'b09870d7-f498-4fe2-9cca-16f9a919955e',147,'d0e47cd34a784cbb89cbe56eafed5650','volumes',1,'2026-02-21 09:58:30',NULL),('2026-02-20 09:58:30','2026-02-20 09:58:30','2026-02-20 09:58:30',1,606,'97c81662-96f1-4cf6-b34f-51ede95f67ed',148,'d0e47cd34a784cbb89cbe56eafed5650','gigabytes',1,'2026-02-21 09:58:30',NULL),('2026-02-20 09:58:30','2026-02-20 09:58:30','2026-02-20 09:58:30',1,607,'44e0d89a-933b-4959-95e3-d79cad4855f7',149,'d0e47cd34a784cbb89cbe56eafed5650','volumes_tripleo',1,'2026-02-21 09:58:30',NULL),('2026-02-20 09:58:30','2026-02-20 09:58:30','2026-02-20 09:58:30',1,608,'b500badf-d0e6-43e3-81e6-b30383a0e192',150,'d0e47cd34a784cbb89cbe56eafed5650','gigabytes_tripleo',1,'2026-02-21 09:58:30',NULL),('2026-02-20 09:58:33','2026-02-20 09:58:33','2026-02-20 09:58:33',1,609,'ed370e4c-42a4-4b59-88be-874eaa266519',147,'d0e47cd34a784cbb89cbe56eafed5650','volumes',-1,'2026-02-21 09:58:33',NULL),('2026-02-20 09:58:33','2026-02-20 09:58:33','2026-02-20 09:58:33',1,610,'aa6b6181-2c02-4c58-aabb-7d84d315a907',148,'d0e47cd34a784cbb89cbe56eafed5650','gigabytes',-1,'2026-02-21 09:58:33',NULL),('2026-02-20 09:58:33','2026-02-20 09:58:33','2026-02-20 09:58:33',1,611,'e46bdb2e-dcb6-414e-82ae-88268c348f99',149,'d0e47cd34a784cbb89cbe56eafed5650','volumes_tripleo',-1,'2026-02-21 09:58:33',NULL),('2026-02-20 09:58:33','2026-02-20 09:58:33','2026-02-20 09:58:33',1,612,'bbd362a8-cf60-4d0c-a689-85dbf9f00b75',150,'d0e47cd34a784cbb89cbe56eafed5650','gigabytes_tripleo',-1,'2026-02-21 09:58:33',NULL),('2026-02-20 09:58:43','2026-02-20 09:58:43','2026-02-20 09:58:43',1,613,'6ca04c95-5599-4f60-be24-56e1d556bb90',151,'68573218a6b141beb49fbacc5b306c7d','volumes',1,'2026-02-21 09:58:43',NULL),('2026-02-20 09:58:43','2026-02-20 09:58:43','2026-02-20 09:58:43',1,614,'7c66ee15-eee5-4961-b94c-886db9c63f3c',152,'68573218a6b141beb49fbacc5b306c7d','gigabytes',1,'2026-02-21 09:58:43',NULL),('2026-02-20 09:58:43','2026-02-20 09:58:43','2026-02-20 09:58:43',1,615,'51283256-45a3-48fe-84dd-9372b651460a',153,'68573218a6b141beb49fbacc5b306c7d','volumes_tripleo',1,'2026-02-21 09:58:43',NULL),('2026-02-20 09:58:43','2026-02-20 09:58:43','2026-02-20 09:58:43',1,616,'6f370579-ad03-4ecd-9315-0fca7d802ec2',154,'68573218a6b141beb49fbacc5b306c7d','gigabytes_tripleo',1,'2026-02-21 09:58:43',NULL),('2026-02-20 09:58:48','2026-02-20 09:58:48','2026-02-20 09:58:48',1,617,'dcb6ffb3-e1ec-4b0e-bbe6-86f569dcf1c4',155,'9fdf2c09b98d48c0bc67cc1c7702a8f4','volumes',1,'2026-02-21 09:58:48',NULL),('2026-02-20 09:58:48','2026-02-20 09:58:48','2026-02-20 09:58:48',1,618,'17ac8a5a-ded0-43f7-9368-92b1644d598c',156,'9fdf2c09b98d48c0bc67cc1c7702a8f4','gigabytes',1,'2026-02-21 09:58:48',NULL),('2026-02-20 09:58:48','2026-02-20 09:58:48','2026-02-20 09:58:48',1,619,'54af7ad8-b892-4fc9-948d-2d82f804e52d',157,'9fdf2c09b98d48c0bc67cc1c7702a8f4','volumes_tripleo',1,'2026-02-21 09:58:48',NULL),('2026-02-20 09:58:48','2026-02-20 09:58:48','2026-02-20 09:58:48',1,620,'9b0f8daa-8691-4d59-9c04-4d8dbd2a3313',158,'9fdf2c09b98d48c0bc67cc1c7702a8f4','gigabytes_tripleo',1,'2026-02-21 09:58:48',NULL),('2026-02-20 09:58:53','2026-02-20 09:58:53','2026-02-20 09:58:53',1,621,'b6d0c5fb-18e9-4d16-b082-7b1a1908631e',159,'dc400fd7b37f468c83d54846895b6cba','volumes',1,'2026-02-21 09:58:53',NULL),('2026-02-20 09:58:53','2026-02-20 09:58:53','2026-02-20 09:58:53',1,622,'c913b807-0214-4f7c-8a43-fdbd6e831432',160,'dc400fd7b37f468c83d54846895b6cba','gigabytes',1,'2026-02-21 09:58:53',NULL),('2026-02-20 09:58:53','2026-02-20 09:58:53','2026-02-20 09:58:53',1,623,'fd0ab544-d9b1-4131-9bc8-21c97ae5e592',161,'dc400fd7b37f468c83d54846895b6cba','volumes_tripleo',1,'2026-02-21 09:58:53',NULL),('2026-02-20 09:58:53','2026-02-20 09:58:53','2026-02-20 09:58:53',1,624,'367482b0-d7fa-4d6a-96ba-939d706317fb',162,'dc400fd7b37f468c83d54846895b6cba','gigabytes_tripleo',1,'2026-02-21 09:58:53',NULL),('2026-02-20 09:58:55','2026-02-20 09:58:55','2026-02-20 09:58:55',1,625,'54be849e-5795-4063-a48a-9a41ec458ffa',163,'dc400fd7b37f468c83d54846895b6cba','backups',1,'2026-02-21 09:58:55',NULL),('2026-02-20 09:58:55','2026-02-20 09:58:55','2026-02-20 09:58:55',1,626,'728ca579-acf8-45f0-8359-198fbb3c1860',164,'dc400fd7b37f468c83d54846895b6cba','backup_gigabytes',1,'2026-02-21 09:58:55',NULL),('2026-02-20 09:58:55','2026-02-20 09:58:55','2026-02-20 09:58:55',1,627,'14be4982-cdae-4afa-b92e-fb0d6e9ca0e9',165,'9fdf2c09b98d48c0bc67cc1c7702a8f4','backups',1,'2026-02-21 09:58:55',NULL),('2026-02-20 09:58:55','2026-02-20 09:58:55','2026-02-20 09:58:55',1,628,'27063467-4d23-4e88-a79c-68d2f2104562',166,'9fdf2c09b98d48c0bc67cc1c7702a8f4','backup_gigabytes',1,'2026-02-21 09:58:55',NULL),('2026-02-20 09:58:59','2026-02-20 09:58:59','2026-02-20 09:58:59',1,629,'6cde73ba-e685-4caa-a272-05bb5fed80f9',167,'4208cd0fbab541f399d332d0956cc0d5','backups',1,'2026-02-21 09:58:59',NULL),('2026-02-20 09:58:59','2026-02-20 09:58:59','2026-02-20 09:58:59',1,630,'29abe9e3-7211-417a-abb7-35a5b11d3117',168,'4208cd0fbab541f399d332d0956cc0d5','backup_gigabytes',1,'2026-02-21 09:58:59',NULL),('2026-02-20 09:58:59','2026-02-20 09:58:59','2026-02-20 09:58:59',1,631,'00b10440-6ada-423e-9952-e6a4f52bcb46',155,'9fdf2c09b98d48c0bc67cc1c7702a8f4','volumes',1,'2026-02-21 09:58:59',NULL),('2026-02-20 09:58:59','2026-02-20 09:58:59','2026-02-20 09:58:59',1,632,'36b2e883-3685-4477-bd36-4a63b56a9ea3',156,'9fdf2c09b98d48c0bc67cc1c7702a8f4','gigabytes',1,'2026-02-21 09:58:59',NULL),('2026-02-20 09:58:59','2026-02-20 09:58:59','2026-02-20 09:58:59',1,633,'68c66bda-3aa9-4afa-8f5d-2baa53479932',157,'9fdf2c09b98d48c0bc67cc1c7702a8f4','volumes_tripleo',1,'2026-02-21 09:58:59',NULL),('2026-02-20 09:58:59','2026-02-20 09:58:59','2026-02-20 09:58:59',1,634,'cab47dc2-a428-4ff1-b60f-ee64916f8432',158,'9fdf2c09b98d48c0bc67cc1c7702a8f4','gigabytes_tripleo',1,'2026-02-21 09:58:59',NULL),('2026-02-20 09:59:00','2026-02-20 09:59:00','2026-02-20 09:59:00',1,635,'f7074e0d-3dc8-4956-82fa-fcbdc62428de',159,'dc400fd7b37f468c83d54846895b6cba','volumes',1,'2026-02-21 09:59:00',NULL),('2026-02-20 09:59:00','2026-02-20 09:59:00','2026-02-20 09:59:00',1,636,'e1b21307-7c2d-4beb-a725-247c1e8f860a',160,'dc400fd7b37f468c83d54846895b6cba','gigabytes',1,'2026-02-21 09:59:00',NULL),('2026-02-20 09:59:00','2026-02-20 09:59:00','2026-02-20 09:59:00',1,637,'72b1a5c4-5c35-486d-9009-6083078f6077',161,'dc400fd7b37f468c83d54846895b6cba','volumes_tripleo',1,'2026-02-21 09:59:00',NULL),('2026-02-20 09:59:00','2026-02-20 09:59:00','2026-02-20 09:59:00',1,638,'13178bcd-76e3-4fb0-929f-46edbb85e2fa',162,'dc400fd7b37f468c83d54846895b6cba','gigabytes_tripleo',1,'2026-02-21 09:59:00',NULL),('2026-02-20 09:59:08','2026-02-20 09:59:08','2026-02-20 09:59:08',1,639,'7284b151-930f-45ab-8b3c-5b0e41efe4ec',167,'4208cd0fbab541f399d332d0956cc0d5','backups',-1,'2026-02-21 09:59:08',NULL),('2026-02-20 09:59:08','2026-02-20 09:59:08','2026-02-20 09:59:08',1,640,'b8a67f4c-7ad6-408f-bbdd-09ade1b1c631',168,'4208cd0fbab541f399d332d0956cc0d5','backup_gigabytes',-1,'2026-02-21 09:59:08',NULL),('2026-02-20 09:59:12','2026-02-20 09:59:12','2026-02-20 09:59:12',1,641,'f2e288b8-4b5e-478b-909a-3d0dd2f8c29d',155,'9fdf2c09b98d48c0bc67cc1c7702a8f4','volumes',-1,'2026-02-21 09:59:12',NULL),('2026-02-20 09:59:12','2026-02-20 09:59:12','2026-02-20 09:59:12',1,642,'e2fc3c8e-fdb3-4973-9095-9f08d552defe',159,'dc400fd7b37f468c83d54846895b6cba','volumes',-1,'2026-02-21 09:59:12',NULL),('2026-02-20 09:59:12','2026-02-20 09:59:12','2026-02-20 09:59:12',1,643,'4ab9bcdd-b30e-48b7-96e3-4671373a5812',156,'9fdf2c09b98d48c0bc67cc1c7702a8f4','gigabytes',-1,'2026-02-21 09:59:12',NULL),('2026-02-20 09:59:12','2026-02-20 09:59:12','2026-02-20 09:59:12',1,644,'04e128db-ff21-4aeb-9e2e-bc78286ec8ab',160,'dc400fd7b37f468c83d54846895b6cba','gigabytes',-1,'2026-02-21 09:59:12',NULL),('2026-02-20 09:59:12','2026-02-20 09:59:12','2026-02-20 09:59:12',1,645,'549904a7-1f0a-4758-866e-42bdd92bcd75',157,'9fdf2c09b98d48c0bc67cc1c7702a8f4','volumes_tripleo',-1,'2026-02-21 09:59:12',NULL),('2026-02-20 09:59:12','2026-02-20 09:59:12','2026-02-20 09:59:12',1,646,'d948e3ff-c61c-4d5c-8e81-ee2268f6e4a2',161,'dc400fd7b37f468c83d54846895b6cba','volumes_tripleo',-1,'2026-02-21 09:59:12',NULL),('2026-02-20 09:59:12','2026-02-20 09:59:12','2026-02-20 09:59:12',1,647,'52f2b3bb-4a3f-4019-911a-abb41c1d7aae',158,'9fdf2c09b98d48c0bc67cc1c7702a8f4','gigabytes_tripleo',-1,'2026-02-21 09:59:12',NULL),('2026-02-20 09:59:12','2026-02-20 09:59:12','2026-02-20 09:59:12',1,648,'16f5a668-e2e4-424c-8026-6f50f25b1dc2',162,'dc400fd7b37f468c83d54846895b6cba','gigabytes_tripleo',-1,'2026-02-21 09:59:12',NULL),('2026-02-20 09:59:16','2026-02-20 09:59:16','2026-02-20 09:59:16',1,649,'2140e24b-2cc6-4789-a6b8-ba462cb48992',163,'dc400fd7b37f468c83d54846895b6cba','backups',-1,'2026-02-21 09:59:16',NULL),('2026-02-20 09:59:16','2026-02-20 09:59:16','2026-02-20 09:59:16',1,650,'95fd51cd-7523-457f-aff4-0d9e93625328',164,'dc400fd7b37f468c83d54846895b6cba','backup_gigabytes',-1,'2026-02-21 09:59:16',NULL),('2026-02-20 09:59:18','2026-02-20 09:59:18','2026-02-20 09:59:18',1,651,'3dd60827-0d48-435f-a3a1-e5782290ed06',165,'9fdf2c09b98d48c0bc67cc1c7702a8f4','backups',-1,'2026-02-21 09:59:18',NULL),('2026-02-20 09:59:18','2026-02-20 09:59:18','2026-02-20 09:59:18',1,652,'2d028111-b7ce-4c3b-beab-03b22d1053bc',166,'9fdf2c09b98d48c0bc67cc1c7702a8f4','backup_gigabytes',-1,'2026-02-21 09:59:18',NULL),('2026-02-20 09:59:18','2026-02-20 09:59:18','2026-02-20 09:59:18',1,653,'9fc71230-3091-4e51-9793-3805c94452dd',159,'dc400fd7b37f468c83d54846895b6cba','volumes',-1,'2026-02-21 09:59:18',NULL),('2026-02-20 09:59:18','2026-02-20 09:59:18','2026-02-20 09:59:18',1,654,'4ac100e3-afc9-4964-9cbb-e417b5303716',160,'dc400fd7b37f468c83d54846895b6cba','gigabytes',-1,'2026-02-21 09:59:18',NULL),('2026-02-20 09:59:18','2026-02-20 09:59:18','2026-02-20 09:59:18',1,655,'4c559ebf-0b32-4ce4-a339-7cbe155c964e',161,'dc400fd7b37f468c83d54846895b6cba','volumes_tripleo',-1,'2026-02-21 09:59:18',NULL),('2026-02-20 09:59:18','2026-02-20 09:59:18','2026-02-20 09:59:18',1,656,'2458986f-f63c-4916-909e-ae01bfa0ffcf',162,'dc400fd7b37f468c83d54846895b6cba','gigabytes_tripleo',-1,'2026-02-21 09:59:18',NULL),('2026-02-20 09:59:18','2026-02-20 09:59:18','2026-02-20 09:59:18',1,657,'676a1804-6c5d-4cdd-b834-cd8c761aa23a',159,'dc400fd7b37f468c83d54846895b6cba','volumes',1,'2026-02-21 09:59:18',NULL),('2026-02-20 09:59:18','2026-02-20 09:59:18','2026-02-20 09:59:18',1,658,'d102f3b9-52d9-4d28-8655-49c638733746',160,'dc400fd7b37f468c83d54846895b6cba','gigabytes',1,'2026-02-21 09:59:18',NULL),('2026-02-20 09:59:18','2026-02-20 09:59:18','2026-02-20 09:59:18',1,659,'1a198b17-b5b3-484b-b519-b7f3ca380e57',161,'dc400fd7b37f468c83d54846895b6cba','volumes_tripleo',1,'2026-02-21 09:59:18',NULL),('2026-02-20 09:59:18','2026-02-20 09:59:18','2026-02-20 09:59:18',1,660,'b14479f5-dabf-42f3-8731-afd3e83cdd96',162,'dc400fd7b37f468c83d54846895b6cba','gigabytes_tripleo',1,'2026-02-21 09:59:18',NULL),('2026-02-20 09:59:20','2026-02-20 09:59:20','2026-02-20 09:59:20',1,661,'c35ace60-ac46-4c9f-973f-9fe155ccbf82',163,'dc400fd7b37f468c83d54846895b6cba','backups',1,'2026-02-21 09:59:20',NULL),('2026-02-20 09:59:20','2026-02-20 09:59:20','2026-02-20 09:59:20',1,662,'50f5fc82-a864-4a79-b1d8-b1362fd99f43',164,'dc400fd7b37f468c83d54846895b6cba','backup_gigabytes',1,'2026-02-21 09:59:20',NULL),('2026-02-20 09:59:20','2026-02-20 09:59:20','2026-02-20 09:59:20',1,663,'a5e5cbef-2f33-4fc0-b4a3-37188f107604',155,'9fdf2c09b98d48c0bc67cc1c7702a8f4','volumes',-1,'2026-02-21 09:59:20',NULL),('2026-02-20 09:59:20','2026-02-20 09:59:20','2026-02-20 09:59:20',1,664,'af2172b5-4855-4bfb-ba92-4f5ba5fea2da',156,'9fdf2c09b98d48c0bc67cc1c7702a8f4','gigabytes',-1,'2026-02-21 09:59:20',NULL),('2026-02-20 09:59:20','2026-02-20 09:59:20','2026-02-20 09:59:20',1,665,'d7a3235d-2ea8-49b4-a9a2-f25a8e9d682f',157,'9fdf2c09b98d48c0bc67cc1c7702a8f4','volumes_tripleo',-1,'2026-02-21 09:59:20',NULL),('2026-02-20 09:59:20','2026-02-20 09:59:20','2026-02-20 09:59:20',1,666,'34708635-bf63-42b3-9e07-289fc96bf4e9',158,'9fdf2c09b98d48c0bc67cc1c7702a8f4','gigabytes_tripleo',-1,'2026-02-21 09:59:20',NULL),('2026-02-20 09:59:21','2026-02-20 09:59:21','2026-02-20 09:59:21',1,667,'29d7360d-b36c-429f-a9a4-e5e4ca5a6323',155,'9fdf2c09b98d48c0bc67cc1c7702a8f4','volumes',1,'2026-02-21 09:59:21',NULL),('2026-02-20 09:59:21','2026-02-20 09:59:21','2026-02-20 09:59:21',1,668,'667d415e-c712-4f5c-b7d8-3fa7f4663922',156,'9fdf2c09b98d48c0bc67cc1c7702a8f4','gigabytes',1,'2026-02-21 09:59:21',NULL),('2026-02-20 09:59:21','2026-02-20 09:59:21','2026-02-20 09:59:21',1,669,'937f21f8-200b-446d-9795-e27ca2b6c9cf',157,'9fdf2c09b98d48c0bc67cc1c7702a8f4','volumes_tripleo',1,'2026-02-21 09:59:21',NULL),('2026-02-20 09:59:21','2026-02-20 09:59:21','2026-02-20 09:59:21',1,670,'8b2727fe-3718-424e-8a77-223b0d88ea91',158,'9fdf2c09b98d48c0bc67cc1c7702a8f4','gigabytes_tripleo',1,'2026-02-21 09:59:21',NULL),('2026-02-20 09:59:24','2026-02-20 09:59:24','2026-02-20 09:59:24',1,671,'5d887e15-7bb6-4abc-beda-d2f5532ef4e4',169,'4eb963516e994397b5c6f3bb155e8d11','groups',1,'2026-02-21 09:59:24',NULL),('2026-02-20 09:59:24','2026-02-20 09:59:24','2026-02-20 09:59:24',1,672,'46a5af81-2b38-4df2-8ec3-8914f874f070',163,'dc400fd7b37f468c83d54846895b6cba','backups',-1,'2026-02-21 09:59:24',NULL),('2026-02-20 09:59:24','2026-02-20 09:59:24','2026-02-20 09:59:24',1,673,'d3607b81-4494-45d2-825d-6c054fbf502b',164,'dc400fd7b37f468c83d54846895b6cba','backup_gigabytes',-1,'2026-02-21 09:59:24',NULL),('2026-02-20 09:59:26','2026-02-20 09:59:26','2026-02-20 09:59:26',1,674,'327f783e-8935-4cae-bbfa-eedf925b0c3b',170,'4eb963516e994397b5c6f3bb155e8d11','volumes',1,'2026-02-21 09:59:26',NULL),('2026-02-20 09:59:26','2026-02-20 09:59:26','2026-02-20 09:59:26',1,675,'1628b5d7-f08c-4f22-abb5-1256774e3ee9',171,'4eb963516e994397b5c6f3bb155e8d11','gigabytes',1,'2026-02-21 09:59:26',NULL),('2026-02-20 09:59:26','2026-02-20 09:59:26','2026-02-20 09:59:26',1,676,'ef42f296-7ff0-4b85-aba1-2054016df93c',172,'4eb963516e994397b5c6f3bb155e8d11','volumes_tempest-GroupsV314Test-volume-type-940356249',1,'2026-02-21 09:59:26',NULL),('2026-02-20 09:59:26','2026-02-20 09:59:26','2026-02-20 09:59:26',1,677,'ee90b864-276f-4005-9c0a-49a0f44e9dfc',173,'4eb963516e994397b5c6f3bb155e8d11','gigabytes_tempest-GroupsV314Test-volume-type-940356249',1,'2026-02-21 09:59:26',NULL),('2026-02-20 09:59:27','2026-02-20 09:59:27','2026-02-20 09:59:27',1,678,'0386a980-727f-4c4a-aaa8-baad90636458',159,'dc400fd7b37f468c83d54846895b6cba','volumes',-1,'2026-02-21 09:59:27',NULL),('2026-02-20 09:59:27','2026-02-20 09:59:27','2026-02-20 09:59:27',1,679,'bbf50f6d-221d-4ad6-a522-4595f8c30016',160,'dc400fd7b37f468c83d54846895b6cba','gigabytes',-1,'2026-02-21 09:59:27',NULL),('2026-02-20 09:59:27','2026-02-20 09:59:27','2026-02-20 09:59:27',1,680,'adc8d975-4d49-45e2-a7a3-7e18f8fff3b2',161,'dc400fd7b37f468c83d54846895b6cba','volumes_tripleo',-1,'2026-02-21 09:59:27',NULL),('2026-02-20 09:59:27','2026-02-20 09:59:27','2026-02-20 09:59:27',1,681,'845d16d7-a1db-483d-96d5-4eb78ff459bf',162,'dc400fd7b37f468c83d54846895b6cba','gigabytes_tripleo',-1,'2026-02-21 09:59:27',NULL),('2026-02-20 09:59:27','2026-02-20 09:59:27','2026-02-20 09:59:27',1,682,'1b85d181-0603-4a83-9d5d-ad3769eb5dc1',169,'4eb963516e994397b5c6f3bb155e8d11','groups',1,'2026-02-21 09:59:27',NULL),('2026-02-20 09:59:27','2026-02-20 09:59:27','2026-02-20 09:59:27',1,683,'29ced6f2-bf99-4759-98f4-57cd7a00d8d9',170,'4eb963516e994397b5c6f3bb155e8d11','volumes',1,'2026-02-21 09:59:27',NULL),('2026-02-20 09:59:27','2026-02-20 09:59:27','2026-02-20 09:59:27',1,684,'8f028114-081a-44ae-91a3-683c18ed47a8',171,'4eb963516e994397b5c6f3bb155e8d11','gigabytes',1,'2026-02-21 09:59:27',NULL),('2026-02-20 09:59:27','2026-02-20 09:59:27','2026-02-20 09:59:27',1,685,'ddb373d1-54d4-430c-918f-bcf2ca8d09e7',172,'4eb963516e994397b5c6f3bb155e8d11','volumes_tempest-GroupsV314Test-volume-type-940356249',1,'2026-02-21 09:59:27',NULL),('2026-02-20 09:59:27','2026-02-20 09:59:27','2026-02-20 09:59:27',1,686,'87c340f7-aefd-4896-ba7b-fa15b581d850',173,'4eb963516e994397b5c6f3bb155e8d11','gigabytes_tempest-GroupsV314Test-volume-type-940356249',1,'2026-02-21 09:59:27',NULL),('2026-02-20 09:59:29','2026-02-20 09:59:30','2026-02-20 09:59:30',1,687,'1f179743-94dd-4f68-9021-06b86eae02df',169,'4eb963516e994397b5c6f3bb155e8d11','groups',-1,'2026-02-21 09:59:29',NULL),('2026-02-20 09:59:29','2026-02-20 09:59:30','2026-02-20 09:59:30',1,688,'7333670b-5f61-4cc3-9a8f-9eef01bb64e7',170,'4eb963516e994397b5c6f3bb155e8d11','volumes',-1,'2026-02-21 09:59:29',NULL),('2026-02-20 09:59:29','2026-02-20 09:59:30','2026-02-20 09:59:30',1,689,'bbdb6d9b-b72c-4224-bf40-b1d309262649',171,'4eb963516e994397b5c6f3bb155e8d11','gigabytes',-1,'2026-02-21 09:59:29',NULL),('2026-02-20 09:59:29','2026-02-20 09:59:30','2026-02-20 09:59:30',1,690,'89a21b6a-5b11-4ea2-a2da-c53f9571785c',172,'4eb963516e994397b5c6f3bb155e8d11','volumes_tempest-GroupsV314Test-volume-type-940356249',-1,'2026-02-21 09:59:29',NULL),('2026-02-20 09:59:29','2026-02-20 09:59:30','2026-02-20 09:59:30',1,691,'a0c56089-02cc-4797-9952-0e054de4f68d',173,'4eb963516e994397b5c6f3bb155e8d11','gigabytes_tempest-GroupsV314Test-volume-type-940356249',-1,'2026-02-21 09:59:29',NULL),('2026-02-20 09:59:30','2026-02-20 09:59:30','2026-02-20 09:59:30',1,692,'3b1acb83-cf14-469e-9de3-2e5c94f9f6cf',169,'4eb963516e994397b5c6f3bb155e8d11','groups',-1,'2026-02-21 09:59:30',NULL),('2026-02-20 09:59:30','2026-02-20 09:59:30','2026-02-20 09:59:30',1,693,'00431df0-ea21-4900-a361-b3367f279696',170,'4eb963516e994397b5c6f3bb155e8d11','volumes',-1,'2026-02-21 09:59:30',NULL),('2026-02-20 09:59:30','2026-02-20 09:59:30','2026-02-20 09:59:30',1,694,'48cc9416-9c3a-4d48-9fac-e40d0a5e9fb5',171,'4eb963516e994397b5c6f3bb155e8d11','gigabytes',-1,'2026-02-21 09:59:30',NULL),('2026-02-20 09:59:30','2026-02-20 09:59:30','2026-02-20 09:59:30',1,695,'110729f3-9aa1-49e9-b561-d65493ef4240',172,'4eb963516e994397b5c6f3bb155e8d11','volumes_tempest-GroupsV314Test-volume-type-940356249',-1,'2026-02-21 09:59:30',NULL),('2026-02-20 09:59:30','2026-02-20 09:59:30','2026-02-20 09:59:30',1,696,'a7c568c8-715c-4a31-83c3-24525c5c0831',173,'4eb963516e994397b5c6f3bb155e8d11','gigabytes_tempest-GroupsV314Test-volume-type-940356249',-1,'2026-02-21 09:59:30',NULL),('2026-02-20 09:59:34','2026-02-20 09:59:34','2026-02-20 09:59:34',1,697,'f38fe4d2-4dd5-4866-869e-1248b84edd6c',174,'2cd3436ad8a1427598e20bbea13ed671','volumes',1,'2026-02-21 09:59:34',NULL),('2026-02-20 09:59:34','2026-02-20 09:59:34','2026-02-20 09:59:34',1,698,'0eb9c67f-b53a-4bff-a526-4ae7b9e62d45',175,'2cd3436ad8a1427598e20bbea13ed671','gigabytes',1,'2026-02-21 09:59:34',NULL),('2026-02-20 09:59:34','2026-02-20 09:59:34','2026-02-20 09:59:34',1,699,'5ddc2dfd-213b-4a9a-9acb-d0f0eb37590e',176,'2cd3436ad8a1427598e20bbea13ed671','volumes_tripleo',1,'2026-02-21 09:59:34',NULL),('2026-02-20 09:59:34','2026-02-20 09:59:34','2026-02-20 09:59:34',1,700,'d150affe-1bfc-4b9a-beac-4961226984cb',177,'2cd3436ad8a1427598e20bbea13ed671','gigabytes_tripleo',1,'2026-02-21 09:59:34',NULL),('2026-02-20 09:59:36','2026-02-20 09:59:36','2026-02-20 09:59:36',1,701,'4f5f4d30-3c0a-478c-a26d-bc7ae01b9ede',174,'2cd3436ad8a1427598e20bbea13ed671','volumes',-1,'2026-02-21 09:59:36',NULL),('2026-02-20 09:59:36','2026-02-20 09:59:36','2026-02-20 09:59:36',1,702,'4e628ffc-3cf4-4c55-94d7-70d0ed40f24c',175,'2cd3436ad8a1427598e20bbea13ed671','gigabytes',-1,'2026-02-21 09:59:36',NULL),('2026-02-20 09:59:36','2026-02-20 09:59:36','2026-02-20 09:59:36',1,703,'f1b83db3-0569-4eec-adb6-2a01e0351f16',176,'2cd3436ad8a1427598e20bbea13ed671','volumes_tripleo',-1,'2026-02-21 09:59:36',NULL),('2026-02-20 09:59:36','2026-02-20 09:59:36','2026-02-20 09:59:36',1,704,'3e38c543-1fba-418b-bbfb-7cf0e6ff371d',177,'2cd3436ad8a1427598e20bbea13ed671','gigabytes_tripleo',-1,'2026-02-21 09:59:36',NULL),('2026-02-20 09:59:36','2026-02-20 09:59:36','2026-02-20 09:59:36',1,705,'356f6785-8d19-4f7f-bb50-2440803d9db6',178,'af7558d3f3e7491c82e203a181c2b164','volumes',1,'2026-02-21 09:59:36',NULL),('2026-02-20 09:59:36','2026-02-20 09:59:36','2026-02-20 09:59:36',1,706,'c8a7488e-94ec-40ed-b917-ef2db0f7d2e9',179,'af7558d3f3e7491c82e203a181c2b164','gigabytes',1,'2026-02-21 09:59:36',NULL),('2026-02-20 09:59:36','2026-02-20 09:59:36','2026-02-20 09:59:36',1,707,'237748a8-72db-4275-b1d4-a3e433ae6a4c',180,'af7558d3f3e7491c82e203a181c2b164','volumes_volume-type-1',1,'2026-02-21 09:59:36',NULL),('2026-02-20 09:59:36','2026-02-20 09:59:36','2026-02-20 09:59:36',1,708,'274b21db-c065-4f59-ab5c-ad7a5415e4a6',181,'af7558d3f3e7491c82e203a181c2b164','gigabytes_volume-type-1',1,'2026-02-21 09:59:36',NULL),('2026-02-20 09:59:37','2026-02-20 09:59:38','2026-02-20 09:59:38',1,709,'29180d20-07f6-4d79-8ff2-da3814435c49',182,'af7558d3f3e7491c82e203a181c2b164','volumes_volume-type-2',1,'2026-02-21 09:59:37',NULL),('2026-02-20 09:59:37','2026-02-20 09:59:38','2026-02-20 09:59:38',1,710,'ea2deb0a-7302-45eb-a324-2e65d09f9d4c',183,'af7558d3f3e7491c82e203a181c2b164','gigabytes_volume-type-2',1,'2026-02-21 09:59:37',NULL),('2026-02-20 09:59:37','2026-02-20 09:59:38','2026-02-20 09:59:38',1,711,'2072066f-2235-4573-b61e-843e4e8e5a10',180,'af7558d3f3e7491c82e203a181c2b164','volumes_volume-type-1',-1,'2026-02-21 09:59:37',NULL),('2026-02-20 09:59:37','2026-02-20 09:59:38','2026-02-20 09:59:38',1,712,'1e8cedc6-8cc5-4b5e-92a1-1cf0ba68ef5b',181,'af7558d3f3e7491c82e203a181c2b164','gigabytes_volume-type-1',-1,'2026-02-21 09:59:37',NULL),('2026-02-20 09:59:39','2026-02-20 09:59:39','2026-02-20 09:59:39',1,713,'992fb63e-8b67-46c7-8df3-89f8040a173c',151,'68573218a6b141beb49fbacc5b306c7d','volumes',-1,'2026-02-21 09:59:39',NULL),('2026-02-20 09:59:39','2026-02-20 09:59:39','2026-02-20 09:59:39',1,714,'7db8e6a2-9b60-4eff-a752-9ff9ac6459a5',152,'68573218a6b141beb49fbacc5b306c7d','gigabytes',-1,'2026-02-21 09:59:39',NULL),('2026-02-20 09:59:39','2026-02-20 09:59:39','2026-02-20 09:59:39',1,715,'0c1cf158-47cf-4321-80c9-554b073074bf',153,'68573218a6b141beb49fbacc5b306c7d','volumes_tripleo',-1,'2026-02-21 09:59:39',NULL),('2026-02-20 09:59:39','2026-02-20 09:59:39','2026-02-20 09:59:39',1,716,'8b268519-176d-40e7-91dc-36e7faa8ca11',154,'68573218a6b141beb49fbacc5b306c7d','gigabytes_tripleo',-1,'2026-02-21 09:59:39',NULL),('2026-02-20 09:59:39','2026-02-20 09:59:39','2026-02-20 09:59:39',1,717,'fdec22b2-2105-41d7-aca7-a4682f4b3c35',178,'af7558d3f3e7491c82e203a181c2b164','volumes',-1,'2026-02-21 09:59:39',NULL),('2026-02-20 09:59:39','2026-02-20 09:59:39','2026-02-20 09:59:39',1,718,'cb5cb62e-e314-4072-b478-68cc70724d05',179,'af7558d3f3e7491c82e203a181c2b164','gigabytes',-1,'2026-02-21 09:59:39',NULL),('2026-02-20 09:59:39','2026-02-20 09:59:39','2026-02-20 09:59:39',1,719,'60f1d2a0-c1b0-471e-b067-322f08563faa',182,'af7558d3f3e7491c82e203a181c2b164','volumes_volume-type-2',-1,'2026-02-21 09:59:39',NULL),('2026-02-20 09:59:39','2026-02-20 09:59:39','2026-02-20 09:59:39',1,720,'e4f6d860-c186-487c-a4bc-f52ba97ebecf',183,'af7558d3f3e7491c82e203a181c2b164','gigabytes_volume-type-2',-1,'2026-02-21 09:59:39',NULL),('2026-02-20 09:59:41','2026-02-20 09:59:41','2026-02-20 09:59:41',1,721,'eeae70dd-20c3-44ea-9127-9e5fc0c8868c',184,'f47cf27181924d37b1f66305014193c3','volumes',1,'2026-02-21 09:59:41',NULL),('2026-02-20 09:59:41','2026-02-20 09:59:41','2026-02-20 09:59:41',1,722,'f8dc8d37-ddf7-4ef7-acd5-72fa66af2262',185,'f47cf27181924d37b1f66305014193c3','gigabytes',1,'2026-02-21 09:59:41',NULL),('2026-02-20 09:59:41','2026-02-20 09:59:41','2026-02-20 09:59:41',1,723,'0147960a-c60f-4dbf-b3e8-3a0daf5221df',186,'f47cf27181924d37b1f66305014193c3','volumes_tripleo',1,'2026-02-21 09:59:41',NULL),('2026-02-20 09:59:41','2026-02-20 09:59:41','2026-02-20 09:59:41',1,724,'80330b8b-d153-4ecb-ba0d-df9db39f70b2',187,'f47cf27181924d37b1f66305014193c3','gigabytes_tripleo',1,'2026-02-21 09:59:41',NULL),('2026-02-20 09:59:43','2026-02-20 09:59:43','2026-02-20 09:59:43',1,725,'50ec2d5a-cf6a-432f-a0c7-5063f9edd19b',188,'6191d07901a6491993d029fffa6c4d91','volumes',1,'2026-02-21 09:59:43',NULL),('2026-02-20 09:59:43','2026-02-20 09:59:43','2026-02-20 09:59:43',1,726,'9db4d598-10e7-4bcd-8ed5-cf4a4846307c',189,'6191d07901a6491993d029fffa6c4d91','gigabytes',1,'2026-02-21 09:59:43',NULL),('2026-02-20 09:59:43','2026-02-20 09:59:43','2026-02-20 09:59:43',1,727,'09795f34-ee1e-4503-97a0-3f0a48be0737',190,'6191d07901a6491993d029fffa6c4d91','volumes_tripleo',1,'2026-02-21 09:59:43',NULL),('2026-02-20 09:59:43','2026-02-20 09:59:43','2026-02-20 09:59:43',1,728,'72cadb40-d72f-4b1c-bba0-f81ad8aae39e',191,'6191d07901a6491993d029fffa6c4d91','gigabytes_tripleo',1,'2026-02-21 09:59:43',NULL),('2026-02-20 09:59:43','2026-02-20 09:59:43','2026-02-20 09:59:43',1,729,'225953ce-1534-4750-88d7-15791b9c0de1',184,'f47cf27181924d37b1f66305014193c3','volumes',-1,'2026-02-21 09:59:43',NULL),('2026-02-20 09:59:43','2026-02-20 09:59:43','2026-02-20 09:59:43',1,730,'825f7712-6535-48d5-a233-6136d44c1c7d',185,'f47cf27181924d37b1f66305014193c3','gigabytes',-1,'2026-02-21 09:59:43',NULL),('2026-02-20 09:59:43','2026-02-20 09:59:43','2026-02-20 09:59:43',1,731,'c8117106-bf41-4ff3-8940-d51061f98637',186,'f47cf27181924d37b1f66305014193c3','volumes_tripleo',-1,'2026-02-21 09:59:43',NULL),('2026-02-20 09:59:43','2026-02-20 09:59:43','2026-02-20 09:59:43',1,732,'07317bdd-eb20-46d1-9ff4-4297090aa79d',187,'f47cf27181924d37b1f66305014193c3','gigabytes_tripleo',-1,'2026-02-21 09:59:43',NULL),('2026-02-20 09:59:43','2026-02-20 09:59:43','2026-02-20 09:59:43',1,733,'1fe87a56-d4bf-4f79-b7c9-ca00ea596e7a',192,'6191d07901a6491993d029fffa6c4d91','snapshots',0,'2026-02-21 09:59:43',NULL),('2026-02-20 09:59:43','2026-02-20 09:59:43','2026-02-20 09:59:43',1,734,'cfe7574b-2943-47c1-bac5-2d2e3a3b67c0',189,'6191d07901a6491993d029fffa6c4d91','gigabytes',0,'2026-02-21 09:59:43',NULL),('2026-02-20 09:59:43','2026-02-20 09:59:43','2026-02-20 09:59:43',1,735,'8a26902b-db39-4f6e-951d-f1ef671db1bb',191,'6191d07901a6491993d029fffa6c4d91','gigabytes_tripleo',0,'2026-02-21 09:59:43',NULL),('2026-02-20 09:59:43','2026-02-20 09:59:43','2026-02-20 09:59:43',1,736,'ce041d7e-aac1-4231-8117-291f6cfdb959',193,'6191d07901a6491993d029fffa6c4d91','snapshots_tripleo',0,'2026-02-21 09:59:43',NULL),('2026-02-20 09:59:43','2026-02-20 09:59:43','2026-02-20 09:59:43',1,737,'84b99631-54ac-4fc3-b87d-ff1a918469ea',194,'f47cf27181924d37b1f66305014193c3','snapshots',0,'2026-02-21 09:59:43',NULL),('2026-02-20 09:59:43','2026-02-20 09:59:43','2026-02-20 09:59:43',1,738,'3cf78c21-9101-42e3-8bcd-b7f35feb3a4b',185,'f47cf27181924d37b1f66305014193c3','gigabytes',0,'2026-02-21 09:59:43',NULL),('2026-02-20 09:59:43','2026-02-20 09:59:43','2026-02-20 09:59:43',1,739,'498ff25b-233d-4260-973e-14b4b6a0ebfc',187,'f47cf27181924d37b1f66305014193c3','gigabytes_tripleo',0,'2026-02-21 09:59:43',NULL),('2026-02-20 09:59:43','2026-02-20 09:59:43','2026-02-20 09:59:43',1,740,'0f69d387-20d3-49f5-b554-dcc2232d9342',195,'f47cf27181924d37b1f66305014193c3','snapshots_tripleo',0,'2026-02-21 09:59:43',NULL),('2026-02-20 09:59:44','2026-02-20 09:59:44','2026-02-20 09:59:44',1,741,'5b373e0c-ecf7-4298-906d-97f4c827de5f',188,'6191d07901a6491993d029fffa6c4d91','volumes',-1,'2026-02-21 09:59:44',NULL),('2026-02-20 09:59:44','2026-02-20 09:59:44','2026-02-20 09:59:44',1,742,'874485ec-c810-4af5-af1d-f86711915498',189,'6191d07901a6491993d029fffa6c4d91','gigabytes',-1,'2026-02-21 09:59:44',NULL),('2026-02-20 09:59:44','2026-02-20 09:59:44','2026-02-20 09:59:44',1,743,'9fa5f82e-066a-484e-a8e6-769c7bf7aebb',190,'6191d07901a6491993d029fffa6c4d91','volumes_tripleo',-1,'2026-02-21 09:59:44',NULL),('2026-02-20 09:59:44','2026-02-20 09:59:44','2026-02-20 09:59:44',1,744,'0359c929-76fc-4561-8a52-6a396db76c18',191,'6191d07901a6491993d029fffa6c4d91','gigabytes_tripleo',-1,'2026-02-21 09:59:44',NULL),('2026-02-20 09:59:44','2026-02-20 09:59:44','2026-02-20 09:59:44',1,745,'5c869ea3-9267-42fd-83bf-03a345e518bd',184,'f47cf27181924d37b1f66305014193c3','volumes',1,'2026-02-21 09:59:44',NULL),('2026-02-20 09:59:44','2026-02-20 09:59:44','2026-02-20 09:59:44',1,746,'492ccf01-37dc-4514-9c69-f7c5b19dcf60',185,'f47cf27181924d37b1f66305014193c3','gigabytes',1,'2026-02-21 09:59:44',NULL),('2026-02-20 09:59:44','2026-02-20 09:59:44','2026-02-20 09:59:44',1,747,'43bdd5ef-cfe0-41d1-9880-d57084d3fd8c',186,'f47cf27181924d37b1f66305014193c3','volumes_tripleo',1,'2026-02-21 09:59:44',NULL),('2026-02-20 09:59:44','2026-02-20 09:59:44','2026-02-20 09:59:44',1,748,'12a505b5-aae6-4865-b4fd-a95c2f55ad1c',187,'f47cf27181924d37b1f66305014193c3','gigabytes_tripleo',1,'2026-02-21 09:59:44',NULL),('2026-02-20 09:59:45','2026-02-20 09:59:45','2026-02-20 09:59:45',1,749,'28fda80b-0574-414a-b46a-63543b07a5ea',196,'d8d571d58a9b4b3cb35695d51c9ad2dc','volumes',1,'2026-02-21 09:59:45',NULL),('2026-02-20 09:59:45','2026-02-20 09:59:45','2026-02-20 09:59:45',1,750,'971e3482-037a-4e1b-a4a1-b40620c779d6',197,'d8d571d58a9b4b3cb35695d51c9ad2dc','gigabytes',1,'2026-02-21 09:59:45',NULL),('2026-02-20 09:59:45','2026-02-20 09:59:45','2026-02-20 09:59:45',1,751,'9c678b81-59d3-4738-ac30-fed0fdccfa45',198,'d8d571d58a9b4b3cb35695d51c9ad2dc','volumes_tripleo',1,'2026-02-21 09:59:45',NULL),('2026-02-20 09:59:45','2026-02-20 09:59:45','2026-02-20 09:59:45',1,752,'0e281d1e-c8ef-4c82-816f-284ebca5cbfd',199,'d8d571d58a9b4b3cb35695d51c9ad2dc','gigabytes_tripleo',1,'2026-02-21 09:59:45',NULL),('2026-02-20 09:59:46','2026-02-20 09:59:46','2026-02-20 09:59:46',1,753,'55efc8b2-162f-4bdd-9125-f9db3171a647',200,'647a6092d7ca4d98a6d581a879bbcbac','volumes',1,'2026-02-21 09:59:46',NULL),('2026-02-20 09:59:46','2026-02-20 09:59:46','2026-02-20 09:59:46',1,754,'28cf3117-e729-46e9-8037-d377c7ece632',201,'647a6092d7ca4d98a6d581a879bbcbac','gigabytes',1,'2026-02-21 09:59:46',NULL),('2026-02-20 09:59:46','2026-02-20 09:59:46','2026-02-20 09:59:46',1,755,'e12a047b-94e7-4357-a046-fdd11184840b',202,'647a6092d7ca4d98a6d581a879bbcbac','volumes_tempest-VolumeTypesAccessTest-volume-type-761717452',1,'2026-02-21 09:59:46',NULL),('2026-02-20 09:59:46','2026-02-20 09:59:46','2026-02-20 09:59:46',1,756,'51ce5617-d130-408b-af76-fe0b71fa6c39',203,'647a6092d7ca4d98a6d581a879bbcbac','gigabytes_tempest-VolumeTypesAccessTest-volume-type-761717452',1,'2026-02-21 09:59:46',NULL),('2026-02-20 09:59:46','2026-02-20 09:59:46','2026-02-20 09:59:46',1,757,'e36b9251-38a4-46d5-b48e-973947bbea3f',196,'d8d571d58a9b4b3cb35695d51c9ad2dc','volumes',1,'2026-02-21 09:59:46',NULL),('2026-02-20 09:59:46','2026-02-20 09:59:46','2026-02-20 09:59:46',1,758,'e25dcf76-57ab-4e7a-90bd-e93103b022b3',197,'d8d571d58a9b4b3cb35695d51c9ad2dc','gigabytes',1,'2026-02-21 09:59:46',NULL),('2026-02-20 09:59:46','2026-02-20 09:59:46','2026-02-20 09:59:46',1,759,'42be51f5-a062-4f30-b907-7ca9960d7814',198,'d8d571d58a9b4b3cb35695d51c9ad2dc','volumes_tripleo',1,'2026-02-21 09:59:46',NULL),('2026-02-20 09:59:46','2026-02-20 09:59:46','2026-02-20 09:59:46',1,760,'409ba7d5-4e02-4c69-861a-c2a0d0f01d08',199,'d8d571d58a9b4b3cb35695d51c9ad2dc','gigabytes_tripleo',1,'2026-02-21 09:59:46',NULL),('2026-02-20 09:59:46','2026-02-20 09:59:46','2026-02-20 09:59:46',1,761,'bd67a78a-ffe9-428a-81e9-f1d77810a47e',184,'f47cf27181924d37b1f66305014193c3','volumes',-1,'2026-02-21 09:59:46',NULL),('2026-02-20 09:59:46','2026-02-20 09:59:46','2026-02-20 09:59:46',1,762,'ea8d1151-46b2-46ce-ab36-051ecedd6288',185,'f47cf27181924d37b1f66305014193c3','gigabytes',-1,'2026-02-21 09:59:46',NULL),('2026-02-20 09:59:46','2026-02-20 09:59:46','2026-02-20 09:59:46',1,763,'8cdae740-aba1-43c7-b21b-72901f12c7ca',186,'f47cf27181924d37b1f66305014193c3','volumes_tripleo',-1,'2026-02-21 09:59:46',NULL),('2026-02-20 09:59:46','2026-02-20 09:59:46','2026-02-20 09:59:46',1,764,'024fc250-3922-4c60-80af-85ce959f4b7f',187,'f47cf27181924d37b1f66305014193c3','gigabytes_tripleo',-1,'2026-02-21 09:59:46',NULL),('2026-02-20 09:59:47','2026-02-20 09:59:47','2026-02-20 09:59:47',1,765,'fd7c726c-5310-484a-88da-71c24e468862',196,'d8d571d58a9b4b3cb35695d51c9ad2dc','volumes',1,'2026-02-21 09:59:47',NULL),('2026-02-20 09:59:47','2026-02-20 09:59:47','2026-02-20 09:59:47',1,766,'07ebc2c6-b61c-4b8a-a322-e52138a00426',197,'d8d571d58a9b4b3cb35695d51c9ad2dc','gigabytes',1,'2026-02-21 09:59:47',NULL),('2026-02-20 09:59:47','2026-02-20 09:59:47','2026-02-20 09:59:47',1,767,'b966b9a1-f970-42ec-8d8a-351051ec49cf',198,'d8d571d58a9b4b3cb35695d51c9ad2dc','volumes_tripleo',1,'2026-02-21 09:59:47',NULL),('2026-02-20 09:59:47','2026-02-20 09:59:47','2026-02-20 09:59:47',1,768,'66ae378d-93c7-4bd6-a3a6-be7e5aedcb54',199,'d8d571d58a9b4b3cb35695d51c9ad2dc','gigabytes_tripleo',1,'2026-02-21 09:59:47',NULL),('2026-02-20 09:59:48','2026-02-20 09:59:48','2026-02-20 09:59:48',1,769,'fd187a4b-11bf-4cc9-91f2-5afa478a3b7c',200,'647a6092d7ca4d98a6d581a879bbcbac','volumes',-1,'2026-02-21 09:59:48',NULL),('2026-02-20 09:59:48','2026-02-20 09:59:48','2026-02-20 09:59:48',1,770,'4335aaad-c9d5-4d30-82d7-563fbbd9fe5d',201,'647a6092d7ca4d98a6d581a879bbcbac','gigabytes',-1,'2026-02-21 09:59:48',NULL),('2026-02-20 09:59:48','2026-02-20 09:59:48','2026-02-20 09:59:48',1,771,'810c3080-dd97-46cf-8d09-e5ff57c6eef0',202,'647a6092d7ca4d98a6d581a879bbcbac','volumes_tempest-VolumeTypesAccessTest-volume-type-761717452',-1,'2026-02-21 09:59:48',NULL),('2026-02-20 09:59:48','2026-02-20 09:59:48','2026-02-20 09:59:48',1,772,'d95a4f7a-f145-4666-94e7-029bf3279a8c',203,'647a6092d7ca4d98a6d581a879bbcbac','gigabytes_tempest-VolumeTypesAccessTest-volume-type-761717452',-1,'2026-02-21 09:59:48',NULL),('2026-02-20 09:59:51','2026-02-20 09:59:51','2026-02-20 09:59:51',1,773,'9df6252e-4f8c-4774-a17b-18920d95160e',196,'d8d571d58a9b4b3cb35695d51c9ad2dc','volumes',-1,'2026-02-21 09:59:51',NULL),('2026-02-20 09:59:51','2026-02-20 09:59:51','2026-02-20 09:59:51',1,774,'0e4b5079-0773-403b-a41a-2780cc009907',197,'d8d571d58a9b4b3cb35695d51c9ad2dc','gigabytes',-1,'2026-02-21 09:59:51',NULL),('2026-02-20 09:59:51','2026-02-20 09:59:51','2026-02-20 09:59:51',1,775,'7851e0d2-57bf-48fe-84e5-7118f584392b',198,'d8d571d58a9b4b3cb35695d51c9ad2dc','volumes_tripleo',-1,'2026-02-21 09:59:51',NULL),('2026-02-20 09:59:51','2026-02-20 09:59:51','2026-02-20 09:59:51',1,776,'61dab3fc-15dc-44df-83be-4480b8960a82',199,'d8d571d58a9b4b3cb35695d51c9ad2dc','gigabytes_tripleo',-1,'2026-02-21 09:59:51',NULL),('2026-02-20 09:59:52','2026-02-20 09:59:52','2026-02-20 09:59:52',1,777,'d2f3d50f-2ebe-4460-8071-0bff477839b5',196,'d8d571d58a9b4b3cb35695d51c9ad2dc','volumes',-1,'2026-02-21 09:59:52',NULL),('2026-02-20 09:59:52','2026-02-20 09:59:52','2026-02-20 09:59:52',1,778,'2231ec14-0bda-405b-a6a3-b7a85e9cfa3f',197,'d8d571d58a9b4b3cb35695d51c9ad2dc','gigabytes',-1,'2026-02-21 09:59:52',NULL),('2026-02-20 09:59:52','2026-02-20 09:59:52','2026-02-20 09:59:52',1,779,'0cef498d-1002-4a3c-ba79-147278a18982',198,'d8d571d58a9b4b3cb35695d51c9ad2dc','volumes_tripleo',-1,'2026-02-21 09:59:52',NULL),('2026-02-20 09:59:52','2026-02-20 09:59:52','2026-02-20 09:59:52',1,780,'9a085201-6392-45c3-8c83-ba35f0c6d4dc',199,'d8d571d58a9b4b3cb35695d51c9ad2dc','gigabytes_tripleo',-1,'2026-02-21 09:59:52',NULL),('2026-02-20 09:59:53','2026-02-20 09:59:53','2026-02-20 09:59:53',1,781,'84a3515e-bc36-4568-a9f9-819eb11c68dc',196,'d8d571d58a9b4b3cb35695d51c9ad2dc','volumes',-1,'2026-02-21 09:59:53',NULL),('2026-02-20 09:59:53','2026-02-20 09:59:53','2026-02-20 09:59:53',1,782,'8b55fbe2-bd81-4483-b765-2398294c5bcd',197,'d8d571d58a9b4b3cb35695d51c9ad2dc','gigabytes',-1,'2026-02-21 09:59:53',NULL),('2026-02-20 09:59:53','2026-02-20 09:59:53','2026-02-20 09:59:53',1,783,'aade2b89-a29e-408b-b36b-a8af6c0f0225',198,'d8d571d58a9b4b3cb35695d51c9ad2dc','volumes_tripleo',-1,'2026-02-21 09:59:53',NULL),('2026-02-20 09:59:53','2026-02-20 09:59:53','2026-02-20 09:59:53',1,784,'10d6d926-6112-4d40-a3be-e9a3c30e139e',199,'d8d571d58a9b4b3cb35695d51c9ad2dc','gigabytes_tripleo',-1,'2026-02-21 09:59:53',NULL),('2026-02-20 10:00:06','2026-02-20 10:00:06','2026-02-20 10:00:06',1,785,'d2b6b14a-1eb8-43c7-87e7-072ebe178739',204,'55965a8332c94f2da5d707adc081ab9c','volumes',1,'2026-02-21 10:00:06',NULL),('2026-02-20 10:00:06','2026-02-20 10:00:06','2026-02-20 10:00:06',1,786,'8b29dcb6-f6f0-426e-8d15-c186625b70f0',205,'55965a8332c94f2da5d707adc081ab9c','gigabytes',1,'2026-02-21 10:00:06',NULL),('2026-02-20 10:00:06','2026-02-20 10:00:06','2026-02-20 10:00:06',1,787,'6f3dbbed-1157-4a7b-ab77-81461e2cb28d',206,'55965a8332c94f2da5d707adc081ab9c','volumes_tripleo',1,'2026-02-21 10:00:06',NULL),('2026-02-20 10:00:06','2026-02-20 10:00:06','2026-02-20 10:00:06',1,788,'6485d1ea-18b8-4936-a235-cb4abadc104e',207,'55965a8332c94f2da5d707adc081ab9c','gigabytes_tripleo',1,'2026-02-21 10:00:06',NULL),('2026-02-20 10:00:07','2026-02-20 10:00:07','2026-02-20 10:00:07',1,789,'fcaade2f-81ff-459d-afaa-5787b25dd13f',208,'55965a8332c94f2da5d707adc081ab9c','snapshots',1,'2026-02-21 10:00:07',NULL),('2026-02-20 10:00:07','2026-02-20 10:00:07','2026-02-20 10:00:07',1,790,'c2de11b2-85e3-4136-82eb-20a9886181b1',205,'55965a8332c94f2da5d707adc081ab9c','gigabytes',1,'2026-02-21 10:00:07',NULL),('2026-02-20 10:00:07','2026-02-20 10:00:07','2026-02-20 10:00:07',1,791,'727e6fec-28a8-4a64-b510-f6fdec85a6c9',207,'55965a8332c94f2da5d707adc081ab9c','gigabytes_tripleo',1,'2026-02-21 10:00:07',NULL),('2026-02-20 10:00:07','2026-02-20 10:00:07','2026-02-20 10:00:07',1,792,'29135e00-d837-447b-8885-7ad956eee024',209,'55965a8332c94f2da5d707adc081ab9c','snapshots_tripleo',1,'2026-02-21 10:00:07',NULL),('2026-02-20 10:00:07','2026-02-20 10:00:07','2026-02-20 10:00:07',1,793,'38b70413-3e09-4e51-840d-3c7debfefa01',165,'9fdf2c09b98d48c0bc67cc1c7702a8f4','backups',1,'2026-02-21 10:00:07',NULL),('2026-02-20 10:00:07','2026-02-20 10:00:07','2026-02-20 10:00:07',1,794,'b1873375-1e72-4755-ac7e-14592c641191',166,'9fdf2c09b98d48c0bc67cc1c7702a8f4','backup_gigabytes',1,'2026-02-21 10:00:07',NULL),('2026-02-20 10:00:09','2026-02-20 10:00:09','2026-02-20 10:00:09',1,795,'3e2d049f-089f-436f-b36b-7aa279914353',210,'55965a8332c94f2da5d707adc081ab9c','backups',1,'2026-02-21 10:00:09',NULL),('2026-02-20 10:00:09','2026-02-20 10:00:09','2026-02-20 10:00:09',1,796,'6f2c869d-d602-4839-9d92-2d8ad1a7ce12',211,'55965a8332c94f2da5d707adc081ab9c','backup_gigabytes',1,'2026-02-21 10:00:09',NULL),('2026-02-20 10:00:12','2026-02-20 10:00:12','2026-02-20 10:00:12',1,797,'3eab6875-3c2c-485e-a524-aa2f8b460847',165,'9fdf2c09b98d48c0bc67cc1c7702a8f4','backups',1,'2026-02-21 10:00:12',NULL),('2026-02-20 10:00:12','2026-02-20 10:00:12','2026-02-20 10:00:12',1,798,'e3f5d59b-0bb1-4a65-b212-7cafe09048ed',166,'9fdf2c09b98d48c0bc67cc1c7702a8f4','backup_gigabytes',1,'2026-02-21 10:00:12',NULL),('2026-02-20 10:00:17','2026-02-20 10:00:17','2026-02-20 10:00:17',1,799,'0f1b8550-9866-4dd9-babd-c2c2b7266460',165,'9fdf2c09b98d48c0bc67cc1c7702a8f4','backups',-1,'2026-02-21 10:00:17',NULL),('2026-02-20 10:00:17','2026-02-20 10:00:17','2026-02-20 10:00:17',1,800,'b286f179-c8b0-4be5-9169-58b0d390d581',166,'9fdf2c09b98d48c0bc67cc1c7702a8f4','backup_gigabytes',-1,'2026-02-21 10:00:17',NULL),('2026-02-20 10:00:18','2026-02-20 10:00:18','2026-02-20 10:00:18',1,801,'c729f072-8c02-44ea-95a0-41fd2c51d6cf',165,'9fdf2c09b98d48c0bc67cc1c7702a8f4','backups',1,'2026-02-21 10:00:18',NULL),('2026-02-20 10:00:18','2026-02-20 10:00:18','2026-02-20 10:00:18',1,802,'dfb03976-7a12-4e7e-a73b-2a7d17f01212',166,'9fdf2c09b98d48c0bc67cc1c7702a8f4','backup_gigabytes',1,'2026-02-21 10:00:18',NULL),('2026-02-20 10:00:25','2026-02-20 10:00:25','2026-02-20 10:00:25',1,803,'0a01a146-23da-4da7-9cf0-93f59cb2aa24',165,'9fdf2c09b98d48c0bc67cc1c7702a8f4','backups',-1,'2026-02-21 10:00:25',NULL),('2026-02-20 10:00:25','2026-02-20 10:00:25','2026-02-20 10:00:25',1,804,'d98bb307-8dd8-4cec-91da-45cd2dffa818',166,'9fdf2c09b98d48c0bc67cc1c7702a8f4','backup_gigabytes',-1,'2026-02-21 10:00:25',NULL),('2026-02-20 10:00:26','2026-02-20 10:00:26','2026-02-20 10:00:26',1,805,'034a2180-8d86-4f8d-a1c4-148b78dc1b3d',210,'55965a8332c94f2da5d707adc081ab9c','backups',-1,'2026-02-21 10:00:26',NULL),('2026-02-20 10:00:26','2026-02-20 10:00:26','2026-02-20 10:00:26',1,806,'d5d9d16f-c8bc-4d31-a433-d762f24bf33a',211,'55965a8332c94f2da5d707adc081ab9c','backup_gigabytes',-1,'2026-02-21 10:00:26',NULL),('2026-02-20 10:00:27','2026-02-20 10:00:27','2026-02-20 10:00:27',1,807,'ca18d66a-2987-465c-8fd0-135c0dc7f170',208,'55965a8332c94f2da5d707adc081ab9c','snapshots',-1,'2026-02-21 10:00:26',NULL),('2026-02-20 10:00:27','2026-02-20 10:00:27','2026-02-20 10:00:27',1,808,'ccf74ae0-072b-4c29-8e46-72b50019bd95',205,'55965a8332c94f2da5d707adc081ab9c','gigabytes',-1,'2026-02-21 10:00:26',NULL),('2026-02-20 10:00:27','2026-02-20 10:00:27','2026-02-20 10:00:27',1,809,'47be34b9-5735-4518-9f40-1d5a5cc1f039',207,'55965a8332c94f2da5d707adc081ab9c','gigabytes_tripleo',-1,'2026-02-21 10:00:26',NULL),('2026-02-20 10:00:27','2026-02-20 10:00:27','2026-02-20 10:00:27',1,810,'f79bc5fd-635e-4125-91f5-69809f1542cf',209,'55965a8332c94f2da5d707adc081ab9c','snapshots_tripleo',-1,'2026-02-21 10:00:26',NULL),('2026-02-20 10:00:27','2026-02-20 10:00:27','2026-02-20 10:00:27',1,811,'585c4573-8647-4a7d-bfb9-05f6c216e956',165,'9fdf2c09b98d48c0bc67cc1c7702a8f4','backups',-1,'2026-02-21 10:00:27',NULL),('2026-02-20 10:00:27','2026-02-20 10:00:27','2026-02-20 10:00:27',1,812,'66c994b9-4c88-4464-9a38-2114c7ca8937',166,'9fdf2c09b98d48c0bc67cc1c7702a8f4','backup_gigabytes',-1,'2026-02-21 10:00:27',NULL),('2026-02-20 10:00:27','2026-02-20 10:00:27','2026-02-20 10:00:27',1,813,'54c85841-dd7e-474d-9a5a-baa2533e7955',208,'55965a8332c94f2da5d707adc081ab9c','snapshots',1,'2026-02-21 10:00:27',NULL),('2026-02-20 10:00:27','2026-02-20 10:00:27','2026-02-20 10:00:27',1,814,'f49ebacb-f302-4c6c-ace3-a77ce5b76188',205,'55965a8332c94f2da5d707adc081ab9c','gigabytes',1,'2026-02-21 10:00:27',NULL),('2026-02-20 10:00:27','2026-02-20 10:00:27','2026-02-20 10:00:27',1,815,'83970cd6-971d-4455-9891-a9950d54c7b1',207,'55965a8332c94f2da5d707adc081ab9c','gigabytes_tripleo',1,'2026-02-21 10:00:27',NULL),('2026-02-20 10:00:27','2026-02-20 10:00:27','2026-02-20 10:00:27',1,816,'643e7456-d588-4f2b-8045-8b14320c47be',209,'55965a8332c94f2da5d707adc081ab9c','snapshots_tripleo',1,'2026-02-21 10:00:27',NULL),('2026-02-20 10:00:30','2026-02-20 10:00:30','2026-02-20 10:00:30',1,817,'740133f6-2b03-44eb-8828-bf6a8d4b0d95',208,'55965a8332c94f2da5d707adc081ab9c','snapshots',-1,'2026-02-21 10:00:30',NULL),('2026-02-20 10:00:30','2026-02-20 10:00:30','2026-02-20 10:00:30',1,818,'a468c887-75bc-40a9-b813-f6e430b01407',205,'55965a8332c94f2da5d707adc081ab9c','gigabytes',-1,'2026-02-21 10:00:30',NULL),('2026-02-20 10:00:30','2026-02-20 10:00:30','2026-02-20 10:00:30',1,819,'878cfa55-1f7c-425d-8bbf-a6d269cfe78d',207,'55965a8332c94f2da5d707adc081ab9c','gigabytes_tripleo',-1,'2026-02-21 10:00:30',NULL),('2026-02-20 10:00:30','2026-02-20 10:00:30','2026-02-20 10:00:30',1,820,'b0352f43-7904-42cf-8ce2-9ef6560f120f',209,'55965a8332c94f2da5d707adc081ab9c','snapshots_tripleo',-1,'2026-02-21 10:00:30',NULL),('2026-02-20 10:00:31','2026-02-20 10:00:31','2026-02-20 10:00:31',1,821,'f19a9c5c-60b4-44e6-9e5b-c336031ad1c0',204,'55965a8332c94f2da5d707adc081ab9c','volumes',1,'2026-02-21 10:00:31',NULL),('2026-02-20 10:00:31','2026-02-20 10:00:31','2026-02-20 10:00:31',1,822,'5edc76bd-a05c-4f6c-87a2-d264977f0a17',205,'55965a8332c94f2da5d707adc081ab9c','gigabytes',1,'2026-02-21 10:00:31',NULL),('2026-02-20 10:00:31','2026-02-20 10:00:31','2026-02-20 10:00:31',1,823,'172d47e9-eddf-4eb6-af1f-71736d875dec',206,'55965a8332c94f2da5d707adc081ab9c','volumes_tripleo',1,'2026-02-21 10:00:31',NULL),('2026-02-20 10:00:31','2026-02-20 10:00:31','2026-02-20 10:00:31',1,824,'3258cd21-f8a6-469c-8b5f-5cec9a7740cc',207,'55965a8332c94f2da5d707adc081ab9c','gigabytes_tripleo',1,'2026-02-21 10:00:31',NULL),('2026-02-20 10:00:32','2026-02-20 10:00:32','2026-02-20 10:00:32',1,825,'59d62b90-39ee-4ef5-9d84-9aaa9ad36e61',208,'55965a8332c94f2da5d707adc081ab9c','snapshots',1,'2026-02-21 10:00:32',NULL),('2026-02-20 10:00:32','2026-02-20 10:00:32','2026-02-20 10:00:32',1,826,'adcd5ac0-9e8e-4ce1-89f9-0b9b6905821e',205,'55965a8332c94f2da5d707adc081ab9c','gigabytes',1,'2026-02-21 10:00:32',NULL),('2026-02-20 10:00:32','2026-02-20 10:00:32','2026-02-20 10:00:32',1,827,'2b80b7bf-b83c-4fa6-822c-977847f763f2',207,'55965a8332c94f2da5d707adc081ab9c','gigabytes_tripleo',1,'2026-02-21 10:00:32',NULL),('2026-02-20 10:00:32','2026-02-20 10:00:32','2026-02-20 10:00:32',1,828,'32722015-700f-41b9-ad52-2eca34617eea',209,'55965a8332c94f2da5d707adc081ab9c','snapshots_tripleo',1,'2026-02-21 10:00:32',NULL),('2026-02-20 10:00:35','2026-02-20 10:00:35','2026-02-20 10:00:35',1,829,'47dddcd4-9564-42ed-9784-c9e1a8df9ff0',204,'55965a8332c94f2da5d707adc081ab9c','volumes',1,'2026-02-21 10:00:35',NULL),('2026-02-20 10:00:35','2026-02-20 10:00:35','2026-02-20 10:00:35',1,830,'ff08060a-1f40-4639-a1b9-19f708847dfb',205,'55965a8332c94f2da5d707adc081ab9c','gigabytes',2,'2026-02-21 10:00:35',NULL),('2026-02-20 10:00:35','2026-02-20 10:00:35','2026-02-20 10:00:35',1,831,'877a16b3-91e6-4d7c-be5c-46e252902529',206,'55965a8332c94f2da5d707adc081ab9c','volumes_tripleo',1,'2026-02-21 10:00:35',NULL),('2026-02-20 10:00:35','2026-02-20 10:00:35','2026-02-20 10:00:35',1,832,'be0c5915-82f1-4c73-b014-10934e5399d6',207,'55965a8332c94f2da5d707adc081ab9c','gigabytes_tripleo',2,'2026-02-21 10:00:35',NULL),('2026-02-20 10:00:37','2026-02-20 10:00:37','2026-02-20 10:00:37',1,833,'7a60c929-086e-4a99-bceb-b2647a0ae692',155,'9fdf2c09b98d48c0bc67cc1c7702a8f4','volumes',-1,'2026-02-21 10:00:37',NULL),('2026-02-20 10:00:37','2026-02-20 10:00:37','2026-02-20 10:00:37',1,834,'49cf0411-cb49-429f-b569-cca5dd85b9e4',156,'9fdf2c09b98d48c0bc67cc1c7702a8f4','gigabytes',-1,'2026-02-21 10:00:37',NULL),('2026-02-20 10:00:37','2026-02-20 10:00:37','2026-02-20 10:00:37',1,835,'77c85ded-4008-40f3-82a1-92efcabb7494',157,'9fdf2c09b98d48c0bc67cc1c7702a8f4','volumes_tripleo',-1,'2026-02-21 10:00:37',NULL),('2026-02-20 10:00:37','2026-02-20 10:00:37','2026-02-20 10:00:37',1,836,'9180e161-7e06-43f8-a310-d1ae351c3da0',158,'9fdf2c09b98d48c0bc67cc1c7702a8f4','gigabytes_tripleo',-1,'2026-02-21 10:00:37',NULL),('2026-02-20 10:00:37','2026-02-20 10:00:37','2026-02-20 10:00:37',1,837,'bed092c8-316a-4b02-a946-4f9df09ba7b3',204,'55965a8332c94f2da5d707adc081ab9c','volumes',-1,'2026-02-21 10:00:37',NULL),('2026-02-20 10:00:37','2026-02-20 10:00:37','2026-02-20 10:00:37',1,838,'28751aab-beff-4334-af8c-7d00d60add00',205,'55965a8332c94f2da5d707adc081ab9c','gigabytes',-2,'2026-02-21 10:00:37',NULL),('2026-02-20 10:00:37','2026-02-20 10:00:37','2026-02-20 10:00:37',1,839,'0a849cd3-a054-4c08-801a-86354a72b45e',206,'55965a8332c94f2da5d707adc081ab9c','volumes_tripleo',-1,'2026-02-21 10:00:37',NULL),('2026-02-20 10:00:37','2026-02-20 10:00:37','2026-02-20 10:00:37',1,840,'c1f6f705-f6fe-40d0-9540-fb70effab5af',207,'55965a8332c94f2da5d707adc081ab9c','gigabytes_tripleo',-2,'2026-02-21 10:00:37',NULL),('2026-02-20 10:00:39','2026-02-20 10:00:39','2026-02-20 10:00:39',1,841,'2e6de56f-6d32-4c49-88dd-2071aa1eb081',208,'55965a8332c94f2da5d707adc081ab9c','snapshots',-1,'2026-02-21 10:00:39',NULL),('2026-02-20 10:00:39','2026-02-20 10:00:39','2026-02-20 10:00:39',1,842,'1c485fff-1b6b-49a1-a15d-7617b7a055e8',205,'55965a8332c94f2da5d707adc081ab9c','gigabytes',-1,'2026-02-21 10:00:39',NULL),('2026-02-20 10:00:39','2026-02-20 10:00:39','2026-02-20 10:00:39',1,843,'cf47a34b-7a8e-490a-ba22-df1a98eb5f10',207,'55965a8332c94f2da5d707adc081ab9c','gigabytes_tripleo',-1,'2026-02-21 10:00:39',NULL),('2026-02-20 10:00:39','2026-02-20 10:00:39','2026-02-20 10:00:39',1,844,'3fd46b76-d1a4-4b42-9803-636d561cdeed',209,'55965a8332c94f2da5d707adc081ab9c','snapshots_tripleo',-1,'2026-02-21 10:00:39',NULL),('2026-02-20 10:00:40','2026-02-20 10:00:40','2026-02-20 10:00:40',1,845,'049d61ee-8dec-4c6b-ac33-1bf67fd97111',204,'55965a8332c94f2da5d707adc081ab9c','volumes',-1,'2026-02-21 10:00:40',NULL),('2026-02-20 10:00:40','2026-02-20 10:00:40','2026-02-20 10:00:40',1,846,'c412b96a-2995-4d38-b1c8-cfc7281f4c94',205,'55965a8332c94f2da5d707adc081ab9c','gigabytes',-1,'2026-02-21 10:00:40',NULL),('2026-02-20 10:00:40','2026-02-20 10:00:40','2026-02-20 10:00:40',1,847,'055f87ac-2545-4c84-ad84-3494bf517925',206,'55965a8332c94f2da5d707adc081ab9c','volumes_tripleo',-1,'2026-02-21 10:00:40',NULL),('2026-02-20 10:00:40','2026-02-20 10:00:40','2026-02-20 10:00:40',1,848,'e7e99b5e-4ca4-4d87-a552-8575912729b0',207,'55965a8332c94f2da5d707adc081ab9c','gigabytes_tripleo',-1,'2026-02-21 10:00:40',NULL),('2026-02-20 10:00:41','2026-02-20 10:00:41','2026-02-20 10:00:41',1,849,'a7c90949-7f2b-40f2-8090-71e67762c1de',204,'55965a8332c94f2da5d707adc081ab9c','volumes',1,'2026-02-21 10:00:41',NULL),('2026-02-20 10:00:41','2026-02-20 10:00:41','2026-02-20 10:00:41',1,850,'9ce982d2-e2bf-4b72-8552-f5f0ec72a5c4',205,'55965a8332c94f2da5d707adc081ab9c','gigabytes',1,'2026-02-21 10:00:41',NULL),('2026-02-20 10:00:41','2026-02-20 10:00:41','2026-02-20 10:00:41',1,851,'5b7b1cd6-7963-4496-8976-d6f23de107e4',206,'55965a8332c94f2da5d707adc081ab9c','volumes_tripleo',1,'2026-02-21 10:00:41',NULL),('2026-02-20 10:00:41','2026-02-20 10:00:41','2026-02-20 10:00:41',1,852,'ce0dcb95-2f4f-4c0c-9a14-4e0732582a2a',207,'55965a8332c94f2da5d707adc081ab9c','gigabytes_tripleo',1,'2026-02-21 10:00:41',NULL),('2026-02-20 10:00:42','2026-02-20 10:00:42','2026-02-20 10:00:42',1,853,'1258ce18-451f-4079-ac94-104b5eb5808a',208,'55965a8332c94f2da5d707adc081ab9c','snapshots',1,'2026-02-21 10:00:42',NULL),('2026-02-20 10:00:42','2026-02-20 10:00:42','2026-02-20 10:00:42',1,854,'83ff4237-7146-48d5-8c1a-78a3e5b0b88b',205,'55965a8332c94f2da5d707adc081ab9c','gigabytes',1,'2026-02-21 10:00:42',NULL),('2026-02-20 10:00:42','2026-02-20 10:00:42','2026-02-20 10:00:42',1,855,'73cd6e30-686a-4e50-8f97-9adb5fff305c',207,'55965a8332c94f2da5d707adc081ab9c','gigabytes_tripleo',1,'2026-02-21 10:00:42',NULL),('2026-02-20 10:00:42','2026-02-20 10:00:42','2026-02-20 10:00:42',1,856,'3d9ad3bf-0cb5-44f4-8601-e7ede4a97fc3',209,'55965a8332c94f2da5d707adc081ab9c','snapshots_tripleo',1,'2026-02-21 10:00:42',NULL),('2026-02-20 10:00:43','2026-02-20 10:00:43','2026-02-20 10:00:43',1,857,'484b0ef6-c4b6-43e7-8774-61362f57c0fa',204,'55965a8332c94f2da5d707adc081ab9c','volumes',1,'2026-02-21 10:00:43',NULL),('2026-02-20 10:00:43','2026-02-20 10:00:43','2026-02-20 10:00:43',1,858,'167c534d-db13-4060-8424-31fa4b52028c',205,'55965a8332c94f2da5d707adc081ab9c','gigabytes',1,'2026-02-21 10:00:43',NULL),('2026-02-20 10:00:43','2026-02-20 10:00:43','2026-02-20 10:00:43',1,859,'cbe0f78c-54c9-41a6-9d20-67db36abd977',206,'55965a8332c94f2da5d707adc081ab9c','volumes_tripleo',1,'2026-02-21 10:00:43',NULL),('2026-02-20 10:00:43','2026-02-20 10:00:43','2026-02-20 10:00:43',1,860,'ee861d3b-9698-45b9-8cd1-bc88edd14e86',207,'55965a8332c94f2da5d707adc081ab9c','gigabytes_tripleo',1,'2026-02-21 10:00:43',NULL),('2026-02-20 10:00:45','2026-02-20 10:00:45','2026-02-20 10:00:45',1,861,'3f3ac215-d5ca-41b9-9804-00821f48042f',204,'55965a8332c94f2da5d707adc081ab9c','volumes',-1,'2026-02-21 10:00:45',NULL),('2026-02-20 10:00:45','2026-02-20 10:00:45','2026-02-20 10:00:45',1,862,'c95bd6e7-552b-4091-8e1c-a96bb6a6c040',205,'55965a8332c94f2da5d707adc081ab9c','gigabytes',-1,'2026-02-21 10:00:45',NULL),('2026-02-20 10:00:45','2026-02-20 10:00:45','2026-02-20 10:00:45',1,863,'7a98ffdf-93d9-4f0b-beba-33d6b46bf559',206,'55965a8332c94f2da5d707adc081ab9c','volumes_tripleo',-1,'2026-02-21 10:00:45',NULL),('2026-02-20 10:00:45','2026-02-20 10:00:45','2026-02-20 10:00:45',1,864,'0649e6a4-0536-49d6-b2b2-c0c1be7f49f8',207,'55965a8332c94f2da5d707adc081ab9c','gigabytes_tripleo',-1,'2026-02-21 10:00:45',NULL),('2026-02-20 10:00:47','2026-02-20 10:00:47','2026-02-20 10:00:47',1,865,'b5ef978c-4569-405a-ad30-b0999c516eae',208,'55965a8332c94f2da5d707adc081ab9c','snapshots',-1,'2026-02-21 10:00:47',NULL),('2026-02-20 10:00:47','2026-02-20 10:00:47','2026-02-20 10:00:47',1,866,'2ab9a9b2-6ae9-43c5-9d8c-17d199a1024d',205,'55965a8332c94f2da5d707adc081ab9c','gigabytes',-1,'2026-02-21 10:00:47',NULL),('2026-02-20 10:00:47','2026-02-20 10:00:47','2026-02-20 10:00:47',1,867,'21b7064e-8985-4a8e-aa6a-27388c8546a5',207,'55965a8332c94f2da5d707adc081ab9c','gigabytes_tripleo',-1,'2026-02-21 10:00:47',NULL),('2026-02-20 10:00:47','2026-02-20 10:00:47','2026-02-20 10:00:47',1,868,'3e1ab130-bd77-440e-800e-93ce7301cfb6',209,'55965a8332c94f2da5d707adc081ab9c','snapshots_tripleo',-1,'2026-02-21 10:00:47',NULL),('2026-02-20 10:00:48','2026-02-20 10:00:48','2026-02-20 10:00:48',1,869,'f683fae3-8eaa-407f-a774-af11f1332ec6',204,'55965a8332c94f2da5d707adc081ab9c','volumes',-1,'2026-02-21 10:00:48',NULL),('2026-02-20 10:00:48','2026-02-20 10:00:48','2026-02-20 10:00:48',1,870,'ca26bab6-3d5a-4d33-8726-c46d361e9aef',205,'55965a8332c94f2da5d707adc081ab9c','gigabytes',-1,'2026-02-21 10:00:48',NULL),('2026-02-20 10:00:48','2026-02-20 10:00:48','2026-02-20 10:00:48',1,871,'bc2f0416-8a57-4f22-976b-e906368fbdeb',206,'55965a8332c94f2da5d707adc081ab9c','volumes_tripleo',-1,'2026-02-21 10:00:48',NULL),('2026-02-20 10:00:48','2026-02-20 10:00:48','2026-02-20 10:00:48',1,872,'124dd027-687a-4143-afef-441e362b5514',207,'55965a8332c94f2da5d707adc081ab9c','gigabytes_tripleo',-1,'2026-02-21 10:00:48',NULL),('2026-02-20 10:00:49','2026-02-20 10:00:49','2026-02-20 10:00:49',1,873,'a90e77a0-3d06-47e4-bef0-ed69781c8b08',204,'55965a8332c94f2da5d707adc081ab9c','volumes',-1,'2026-02-21 10:00:49',NULL),('2026-02-20 10:00:49','2026-02-20 10:00:49','2026-02-20 10:00:49',1,874,'c96e03e1-76f1-408f-a7fc-de261bcbf481',205,'55965a8332c94f2da5d707adc081ab9c','gigabytes',-1,'2026-02-21 10:00:49',NULL),('2026-02-20 10:00:49','2026-02-20 10:00:49','2026-02-20 10:00:49',1,875,'c9c0c10d-b1e2-45e6-ac58-cf6fceee84ed',206,'55965a8332c94f2da5d707adc081ab9c','volumes_tripleo',-1,'2026-02-21 10:00:49',NULL),('2026-02-20 10:00:49','2026-02-20 10:00:49','2026-02-20 10:00:49',1,876,'bd7e833d-35dc-41ea-9932-96366eb0b578',207,'55965a8332c94f2da5d707adc081ab9c','gigabytes_tripleo',-1,'2026-02-21 10:00:49',NULL),('2026-02-20 10:00:56','2026-02-20 10:00:56','2026-02-20 10:00:56',1,877,'c7b5771c-52d8-4e2e-8610-c9b8fdadb5bb',212,'1effd5c1f8144a25a1cfdcbbbfeeb59f','volumes',1,'2026-02-21 10:00:56',NULL),('2026-02-20 10:00:56','2026-02-20 10:00:56','2026-02-20 10:00:56',1,878,'1ec8384f-084f-48ce-883e-f2e9dba9ce65',213,'1effd5c1f8144a25a1cfdcbbbfeeb59f','gigabytes',1,'2026-02-21 10:00:56',NULL),('2026-02-20 10:00:56','2026-02-20 10:00:56','2026-02-20 10:00:56',1,879,'6b19aac3-676e-4929-aa13-d41f00d3ff97',214,'1effd5c1f8144a25a1cfdcbbbfeeb59f','volumes_tripleo',1,'2026-02-21 10:00:56',NULL),('2026-02-20 10:00:56','2026-02-20 10:00:56','2026-02-20 10:00:56',1,880,'77ab3c7c-4590-4956-8857-c6433e01394a',215,'1effd5c1f8144a25a1cfdcbbbfeeb59f','gigabytes_tripleo',1,'2026-02-21 10:00:56',NULL),('2026-02-20 10:00:57','2026-02-20 10:00:57','2026-02-20 10:00:57',1,881,'f0dcc709-e803-45fb-bfc5-9d22b4f116c2',216,'1effd5c1f8144a25a1cfdcbbbfeeb59f','snapshots',1,'2026-02-21 10:00:57',NULL),('2026-02-20 10:00:57','2026-02-20 10:00:57','2026-02-20 10:00:57',1,882,'294df072-87e2-409e-af04-09266f0556f3',213,'1effd5c1f8144a25a1cfdcbbbfeeb59f','gigabytes',1,'2026-02-21 10:00:57',NULL),('2026-02-20 10:00:57','2026-02-20 10:00:57','2026-02-20 10:00:57',1,883,'1be82e70-d900-4f31-afff-c160c3887e5d',215,'1effd5c1f8144a25a1cfdcbbbfeeb59f','gigabytes_tripleo',1,'2026-02-21 10:00:57',NULL),('2026-02-20 10:00:57','2026-02-20 10:00:57','2026-02-20 10:00:57',1,884,'fb0a7d02-ef0b-486b-98f4-55044024332e',217,'1effd5c1f8144a25a1cfdcbbbfeeb59f','snapshots_tripleo',1,'2026-02-21 10:00:57',NULL),('2026-02-20 10:00:58','2026-02-20 10:00:58','2026-02-20 10:00:58',1,885,'343609df-03f0-48cf-9fc2-276173e8c890',216,'1effd5c1f8144a25a1cfdcbbbfeeb59f','snapshots',1,'2026-02-21 10:00:58',NULL),('2026-02-20 10:00:58','2026-02-20 10:00:58','2026-02-20 10:00:58',1,886,'c1d1b541-50e2-4479-8ec2-5febce79bb5e',213,'1effd5c1f8144a25a1cfdcbbbfeeb59f','gigabytes',1,'2026-02-21 10:00:58',NULL),('2026-02-20 10:00:58','2026-02-20 10:00:58','2026-02-20 10:00:58',1,887,'cc9920f4-417a-4380-83cf-6a80404ade8e',215,'1effd5c1f8144a25a1cfdcbbbfeeb59f','gigabytes_tripleo',1,'2026-02-21 10:00:58',NULL),('2026-02-20 10:00:58','2026-02-20 10:00:58','2026-02-20 10:00:58',1,888,'1f2fc7ac-4462-4055-9282-04c41cef52fe',217,'1effd5c1f8144a25a1cfdcbbbfeeb59f','snapshots_tripleo',1,'2026-02-21 10:00:58',NULL),('2026-02-20 10:01:00','2026-02-20 10:01:00','2026-02-20 10:01:00',1,889,'feef9cc8-e150-4c80-b8ec-37165989f4b2',216,'1effd5c1f8144a25a1cfdcbbbfeeb59f','snapshots',1,'2026-02-21 10:01:00',NULL),('2026-02-20 10:01:00','2026-02-20 10:01:00','2026-02-20 10:01:00',1,890,'1bfa7365-663d-4a35-8589-efdf9bb1c49f',213,'1effd5c1f8144a25a1cfdcbbbfeeb59f','gigabytes',1,'2026-02-21 10:01:00',NULL),('2026-02-20 10:01:00','2026-02-20 10:01:00','2026-02-20 10:01:00',1,891,'52491e26-99eb-4e6c-a1fc-29f251f94a4a',215,'1effd5c1f8144a25a1cfdcbbbfeeb59f','gigabytes_tripleo',1,'2026-02-21 10:01:00',NULL),('2026-02-20 10:01:00','2026-02-20 10:01:00','2026-02-20 10:01:00',1,892,'001520c8-3502-4993-a3e3-1d78aee67c6b',217,'1effd5c1f8144a25a1cfdcbbbfeeb59f','snapshots_tripleo',1,'2026-02-21 10:01:00',NULL),('2026-02-20 10:01:02','2026-02-20 10:01:03','2026-02-20 10:01:03',1,893,'ac47e70f-831e-4801-adad-15e2e7384dc2',216,'1effd5c1f8144a25a1cfdcbbbfeeb59f','snapshots',-1,'2026-02-21 10:01:02',NULL),('2026-02-20 10:01:02','2026-02-20 10:01:03','2026-02-20 10:01:03',1,894,'bef210e4-a82c-494a-80e4-8259de84e27c',213,'1effd5c1f8144a25a1cfdcbbbfeeb59f','gigabytes',-1,'2026-02-21 10:01:02',NULL),('2026-02-20 10:01:02','2026-02-20 10:01:03','2026-02-20 10:01:03',1,895,'35f25325-69af-46e9-a8bb-32fc3ddc9688',215,'1effd5c1f8144a25a1cfdcbbbfeeb59f','gigabytes_tripleo',-1,'2026-02-21 10:01:02',NULL),('2026-02-20 10:01:02','2026-02-20 10:01:03','2026-02-20 10:01:03',1,896,'681a72cf-bf62-43fe-9f7c-f45485597e2a',217,'1effd5c1f8144a25a1cfdcbbbfeeb59f','snapshots_tripleo',-1,'2026-02-21 10:01:02',NULL),('2026-02-20 10:01:05','2026-02-20 10:01:05','2026-02-20 10:01:05',1,897,'64e135cd-5fb3-459e-8139-8dc361fe5f11',216,'1effd5c1f8144a25a1cfdcbbbfeeb59f','snapshots',-1,'2026-02-21 10:01:05',NULL),('2026-02-20 10:01:05','2026-02-20 10:01:05','2026-02-20 10:01:05',1,898,'d048220d-a83a-45bd-a3fd-ee4c61828ec1',213,'1effd5c1f8144a25a1cfdcbbbfeeb59f','gigabytes',-1,'2026-02-21 10:01:05',NULL),('2026-02-20 10:01:05','2026-02-20 10:01:05','2026-02-20 10:01:05',1,899,'c37cf174-cc86-4888-ac20-2aadd14a5e6b',215,'1effd5c1f8144a25a1cfdcbbbfeeb59f','gigabytes_tripleo',-1,'2026-02-21 10:01:05',NULL),('2026-02-20 10:01:05','2026-02-20 10:01:05','2026-02-20 10:01:05',1,900,'3942228c-b893-4a35-8c67-a9edc00e4464',217,'1effd5c1f8144a25a1cfdcbbbfeeb59f','snapshots_tripleo',-1,'2026-02-21 10:01:05',NULL),('2026-02-20 10:01:07','2026-02-20 10:01:07','2026-02-20 10:01:07',1,901,'de53de38-3df3-4b10-adad-31c44b376e1e',216,'1effd5c1f8144a25a1cfdcbbbfeeb59f','snapshots',-1,'2026-02-21 10:01:07',NULL),('2026-02-20 10:01:07','2026-02-20 10:01:07','2026-02-20 10:01:07',1,902,'865871ee-8501-42be-89d8-7098fa6e6b6a',213,'1effd5c1f8144a25a1cfdcbbbfeeb59f','gigabytes',-1,'2026-02-21 10:01:07',NULL),('2026-02-20 10:01:07','2026-02-20 10:01:07','2026-02-20 10:01:07',1,903,'dd33d18e-f985-4bf3-8660-629f2b3f967d',215,'1effd5c1f8144a25a1cfdcbbbfeeb59f','gigabytes_tripleo',-1,'2026-02-21 10:01:07',NULL),('2026-02-20 10:01:07','2026-02-20 10:01:07','2026-02-20 10:01:07',1,904,'ff4c0b65-25b7-49a3-9a96-304821c0db64',217,'1effd5c1f8144a25a1cfdcbbbfeeb59f','snapshots_tripleo',-1,'2026-02-21 10:01:07',NULL),('2026-02-20 10:01:08','2026-02-20 10:01:08','2026-02-20 10:01:08',1,905,'1ab773e2-f710-4df0-b540-817961d23f5d',212,'1effd5c1f8144a25a1cfdcbbbfeeb59f','volumes',-1,'2026-02-21 10:01:08',NULL),('2026-02-20 10:01:08','2026-02-20 10:01:08','2026-02-20 10:01:08',1,906,'42ec84d7-e5e2-460e-884f-918d9bf5d3e2',213,'1effd5c1f8144a25a1cfdcbbbfeeb59f','gigabytes',-1,'2026-02-21 10:01:08',NULL),('2026-02-20 10:01:08','2026-02-20 10:01:08','2026-02-20 10:01:08',1,907,'66696acc-4229-4495-aa9b-7732bc6a7c3f',214,'1effd5c1f8144a25a1cfdcbbbfeeb59f','volumes_tripleo',-1,'2026-02-21 10:01:08',NULL),('2026-02-20 10:01:08','2026-02-20 10:01:08','2026-02-20 10:01:08',1,908,'a6ec3d5c-5029-48e5-93b2-af983e0f531f',215,'1effd5c1f8144a25a1cfdcbbbfeeb59f','gigabytes_tripleo',-1,'2026-02-21 10:01:08',NULL),('2026-02-20 10:01:12','2026-02-20 10:01:12','2026-02-20 10:01:12',1,909,'36d57270-438f-4650-8428-a0516b836bb8',218,'d3558f588a6e4dd690ecc5be43692a2e','volumes',1,'2026-02-21 10:01:12',NULL),('2026-02-20 10:01:12','2026-02-20 10:01:12','2026-02-20 10:01:12',1,910,'a0c078ee-4347-471f-9cdc-35dd82c830b9',219,'d3558f588a6e4dd690ecc5be43692a2e','gigabytes',2,'2026-02-21 10:01:12',NULL),('2026-02-20 10:01:12','2026-02-20 10:01:12','2026-02-20 10:01:12',1,911,'685b283e-ab62-4934-b942-55f35a7402ae',220,'d3558f588a6e4dd690ecc5be43692a2e','volumes_tripleo',1,'2026-02-21 10:01:12',NULL),('2026-02-20 10:01:12','2026-02-20 10:01:12','2026-02-20 10:01:12',1,912,'ca390122-a281-4bbc-b081-ed735eeb0a95',221,'d3558f588a6e4dd690ecc5be43692a2e','gigabytes_tripleo',2,'2026-02-21 10:01:12',NULL),('2026-02-20 10:01:13','2026-02-20 10:01:13','2026-02-20 10:01:13',1,913,'96aa09a7-4896-45e2-b3c4-14abfa648d7f',222,'d3558f588a6e4dd690ecc5be43692a2e','snapshots',1,'2026-02-21 10:01:13',NULL),('2026-02-20 10:01:13','2026-02-20 10:01:13','2026-02-20 10:01:13',1,914,'803080b4-8ea0-40e7-ba9b-0e3d2d38d05c',219,'d3558f588a6e4dd690ecc5be43692a2e','gigabytes',2,'2026-02-21 10:01:13',NULL),('2026-02-20 10:01:13','2026-02-20 10:01:13','2026-02-20 10:01:13',1,915,'d3a44326-d7be-4cc0-a72e-e14d38896941',221,'d3558f588a6e4dd690ecc5be43692a2e','gigabytes_tripleo',2,'2026-02-21 10:01:13',NULL),('2026-02-20 10:01:13','2026-02-20 10:01:13','2026-02-20 10:01:13',1,916,'28f256fb-5935-487f-b623-66380b5775d6',223,'d3558f588a6e4dd690ecc5be43692a2e','snapshots_tripleo',1,'2026-02-21 10:01:13',NULL),('2026-02-20 10:01:15','2026-02-20 10:01:15','2026-02-20 10:01:15',1,917,'91eeda86-af10-4ca6-8b24-364d31c1e5e9',222,'d3558f588a6e4dd690ecc5be43692a2e','snapshots',-1,'2026-02-21 10:01:15',NULL),('2026-02-20 10:01:15','2026-02-20 10:01:15','2026-02-20 10:01:15',1,918,'e6af13ba-d708-4f5c-ba86-2d94eb4a9776',219,'d3558f588a6e4dd690ecc5be43692a2e','gigabytes',-2,'2026-02-21 10:01:15',NULL),('2026-02-20 10:01:15','2026-02-20 10:01:15','2026-02-20 10:01:15',1,919,'b17c3fd2-7edf-47c2-80e4-a15dccdf79d9',221,'d3558f588a6e4dd690ecc5be43692a2e','gigabytes_tripleo',-2,'2026-02-21 10:01:15',NULL),('2026-02-20 10:01:15','2026-02-20 10:01:15','2026-02-20 10:01:15',1,920,'2ea69430-a70a-407c-ba1e-ccba57766f77',223,'d3558f588a6e4dd690ecc5be43692a2e','snapshots_tripleo',-1,'2026-02-21 10:01:15',NULL),('2026-02-20 10:01:16','2026-02-20 10:01:16','2026-02-20 10:01:16',1,921,'0b45a6bc-8c75-4f96-93ae-91c3b7b9a522',218,'d3558f588a6e4dd690ecc5be43692a2e','volumes',-1,'2026-02-21 10:01:16',NULL),('2026-02-20 10:01:16','2026-02-20 10:01:16','2026-02-20 10:01:16',1,922,'e309bc36-9f1c-4d12-824c-933ef0fe798a',219,'d3558f588a6e4dd690ecc5be43692a2e','gigabytes',-2,'2026-02-21 10:01:16',NULL),('2026-02-20 10:01:16','2026-02-20 10:01:16','2026-02-20 10:01:16',1,923,'3da3d895-2467-4ea1-b862-93a600026d3c',220,'d3558f588a6e4dd690ecc5be43692a2e','volumes_tripleo',-1,'2026-02-21 10:01:16',NULL),('2026-02-20 10:01:16','2026-02-20 10:01:16','2026-02-20 10:01:16',1,924,'a3a418b1-e7c8-4447-ba00-ec7566419c1f',221,'d3558f588a6e4dd690ecc5be43692a2e','gigabytes_tripleo',-2,'2026-02-21 10:01:16',NULL);
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`disabled` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`frozen` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2026-02-20 08:10:14','2026-02-20 08:47:29','2026-02-20 08:47:29',1,2,'np0005625199.localdomain','cinder-scheduler','cinder-scheduler',115,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'57d29300-05ff-4042-9a75-d101491044b9'),('2026-02-20 08:10:28','2026-02-20 08:47:31','2026-02-20 08:47:31',1,5,'np0005625200.localdomain','cinder-scheduler','cinder-scheduler',114,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'8e9658bd-c6f1-419a-8e19-f1c8993873db'),('2026-02-20 08:10:28','2026-02-20 08:47:33','2026-02-20 08:47:33',1,8,'np0005625201.localdomain','cinder-scheduler','cinder-scheduler',114,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'0ca50108-c53a-40c8-a6c0-564541d8e9d6'),('2026-02-20 08:13:53','2026-02-20 08:47:23','2026-02-20 08:47:23',1,11,'np0005625199.localdomain','cinder-backup','cinder-backup',141,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'81a788a0-ffdc-4670-a0aa-bd9ca7757e5e'),('2026-02-20 08:14:28','2026-02-20 10:13:54',NULL,0,14,'hostgroup@tripleo_ceph','cinder-volume','cinder-volume',653,0,'nova',NULL,NULL,'3.18','1.39','disabled',0,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587'),('2026-02-20 08:47:38','2026-02-20 10:13:52',NULL,0,17,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',516,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'1b1420d9-242e-46dd-b081-1bcbb3590117'),('2026-02-20 08:47:42','2026-02-20 10:13:52',NULL,0,18,'cinder-backup-0','cinder-backup','cinder-backup',517,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'050b77e1-2de4-4e28-98be-4f74a1757a82');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
INSERT INTO `snapshot_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `snapshot_id`, `key`, `value`) VALUES ('2026-02-20 09:56:36','2026-02-20 09:56:36','2026-02-20 09:56:36',1,1,'4e9a5c70-4b3d-4409-af23-93bc402ccff9','key1','value1'),('2026-02-20 09:56:36','2026-02-20 09:56:36','2026-02-20 09:56:36',1,2,'4e9a5c70-4b3d-4409-af23-93bc402ccff9','key2','value2'),('2026-02-20 09:56:36','2026-02-20 09:56:36','2026-02-20 09:56:36',1,3,'4e9a5c70-4b3d-4409-af23-93bc402ccff9','key3','value3_update'),('2026-02-20 09:56:36','2026-02-20 09:56:36','2026-02-20 09:56:36',1,4,'4e9a5c70-4b3d-4409-af23-93bc402ccff9','key4','value4'),('2026-02-20 09:56:36','2026-02-20 09:56:36','2026-02-20 09:56:36',1,5,'4e9a5c70-4b3d-4409-af23-93bc402ccff9','key1','value1'),('2026-02-20 09:56:36','2026-02-20 09:56:36','2026-02-20 09:56:36',1,6,'4e9a5c70-4b3d-4409-af23-93bc402ccff9','key2','value2'),('2026-02-20 09:56:36','2026-02-20 09:56:36','2026-02-20 09:56:36',1,7,'4e9a5c70-4b3d-4409-af23-93bc402ccff9','key3','value3_update'),('2026-02-20 10:00:27',NULL,'2026-02-20 10:00:30',1,8,'61c9c285-df5e-4830-acba-cdee71839b2a','snap-meta1','value1'),('2026-02-20 10:00:27',NULL,'2026-02-20 10:00:30',1,9,'61c9c285-df5e-4830-acba-cdee71839b2a','snap-meta2','value2'),('2026-02-20 10:00:27',NULL,'2026-02-20 10:00:30',1,10,'61c9c285-df5e-4830-acba-cdee71839b2a','snap-meta3','value3');
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
INSERT INTO `snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `status`, `progress`, `volume_size`, `scheduled_at`, `display_name`, `display_description`, `provider_location`, `encryption_key_id`, `volume_type_id`, `cgsnapshot_id`, `provider_id`, `provider_auth`, `group_snapshot_id`, `use_quota`) VALUES ('2026-02-20 10:00:58','2026-02-20 10:01:03','2026-02-20 10:01:05',1,'0d1604dd-c194-466d-afd4-1662f13058e1','5476cf79-b8d2-4c00-8659-e6a5397770d6','cbd4c180af67497989b022e398f54cc0','1effd5c1f8144a25a1cfdcbbbfeeb59f','deleted','100%',1,NULL,'tempest-VolumesSnapshotListTestJSON-Snapshot-65587643',NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,NULL,NULL,NULL,1),('2026-02-20 09:57:25','2026-02-20 09:57:26','2026-02-20 09:57:27',1,'0e2a5876-9b1c-4213-80ab-a53d82a433ac','be42e48b-8334-4f89-a54f-ccf0cb67978d','82d57f5053f740799c189ab7be7e42cb','b937092feb204d07b7daa9302db5204f','deleted','100%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-643005791',NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,NULL,NULL,NULL,1),('2026-02-20 09:57:14','2026-02-20 09:57:31','2026-02-20 09:57:32',1,'1acda105-9c19-4f7b-a676-f69c641f143f','be42e48b-8334-4f89-a54f-ccf0cb67978d','82d57f5053f740799c189ab7be7e42cb','b937092feb204d07b7daa9302db5204f','deleted','80%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-47844458',NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,NULL,NULL,NULL,1),('2026-02-20 09:57:27','2026-02-20 09:57:28','2026-02-20 09:57:30',1,'4785f0e2-7a16-42a8-86c0-fd8c5cc32b0d','be42e48b-8334-4f89-a54f-ccf0cb67978d','82d57f5053f740799c189ab7be7e42cb','b937092feb204d07b7daa9302db5204f','deleted','100%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-98835114',NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,NULL,NULL,NULL,1),('2026-02-20 09:55:15','2026-02-20 09:55:18','2026-02-20 09:55:18',1,'4af1eef8-9dc2-4191-99b2-b21167914709','d1517577-a2ea-4ea7-b84a-d089c1148465','ffbb979ff9fb4e37a3cdbc9384522ee4','dcc08d5e298941e3a9de201aa565b6a9','deleted','100%',1,NULL,'tempest-group_snapshot-125563722',NULL,NULL,NULL,'211da78d-0ac0-446b-b9cb-70aa203883c3',NULL,NULL,NULL,'62f2d471-1c4c-43ab-abf4-249a999898b5',1),('2026-02-20 09:56:35','2026-02-20 09:56:36','2026-02-20 09:56:37',1,'4e9a5c70-4b3d-4409-af23-93bc402ccff9','7f0557eb-9b8b-4427-bd2f-9ed9ae60cb24','df2bafbc0815447296ee536b0161623a','6b6c3ea6fad948cbaee73bff3485d7da','deleted','100%',1,NULL,'tempest-SnapshotMetadataTestJSON-Snapshot-1683252224',NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,NULL,NULL,NULL,1),('2026-02-20 10:00:32','2026-02-20 10:00:38','2026-02-20 10:00:39',1,'5892d266-ac85-4099-9c59-aac93526e226','93ff9562-90bb-4b46-8669-dc485cc31a88','0a59a4e0759a4900accbf97025764545','55965a8332c94f2da5d707adc081ab9c','deleted','100%',1,NULL,'tempest-VolumesSnapshotTestJSON-Snapshot-1795962673',NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,NULL,NULL,NULL,1),('2026-02-20 10:00:27','2026-02-20 10:00:28','2026-02-20 10:00:30',1,'61c9c285-df5e-4830-acba-cdee71839b2a','53af8aa6-057c-4cb9-8a9e-c2bf19735f85','0a59a4e0759a4900accbf97025764545','55965a8332c94f2da5d707adc081ab9c','deleted','100%',1,NULL,'tempest-VolumesSnapshotTestJSON-new-snap-1867575351','This is the new description of snapshot.',NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,NULL,NULL,NULL,1),('2026-02-20 10:00:57','2026-02-20 10:01:06','2026-02-20 10:01:07',1,'620efbbb-66cc-4bec-9202-328611faf01c','5476cf79-b8d2-4c00-8659-e6a5397770d6','cbd4c180af67497989b022e398f54cc0','1effd5c1f8144a25a1cfdcbbbfeeb59f','deleted','100%',1,NULL,'tempest-VolumesSnapshotListTestJSON-Snapshot-1799730701',NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,NULL,NULL,NULL,1),('2026-02-20 09:58:10','2026-02-20 09:58:12','2026-02-20 09:58:14',1,'6b682091-3fba-4eb7-a547-f33c9bdc88f5','15481572-d93d-4c42-a618-d7ec3ab35f66','129368ce43b64853b24a36395c84b7b0','8a43ccd6212d4626a208a271337f7a5b','deleted','100%',1,NULL,'tempest-VolumesDeleteCascade-Snapshot-1330946677',NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,NULL,NULL,NULL,1),('2026-02-20 09:57:32','2026-02-20 09:57:34','2026-02-20 09:57:34',1,'820cfb18-d750-4adb-89ab-fba0f1848f22','f0918f8b-df1a-4352-9e10-0df4cafc6419','64bc298504924a43b95ce2758bfa5477','a48d774a595542e4a66f14036bc080ce','deleted','100%',1,NULL,'tempest-GroupSnapshotsV319Test-Group_Snapshot-391968842',NULL,NULL,NULL,'d29ddbab-68de-4b71-aa71-4b968f18ee1d',NULL,NULL,NULL,'87669497-51c9-4f85-aa67-d2b972045d78',1),('2026-02-20 10:00:07','2026-02-20 10:00:26','2026-02-20 10:00:27',1,'89b9b715-5115-4fd7-9674-df31ca383c1e','53af8aa6-057c-4cb9-8a9e-c2bf19735f85','0a59a4e0759a4900accbf97025764545','55965a8332c94f2da5d707adc081ab9c','deleted','100%',1,NULL,'tempest-VolumesSnapshotTestJSON-Snapshot-22202199',NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,NULL,NULL,NULL,1),('2026-02-20 09:57:20','2026-02-20 09:57:22','2026-02-20 09:57:24',1,'8ceae1dd-4957-4cfd-b079-7e3dfab79d34','be42e48b-8334-4f89-a54f-ccf0cb67978d','82d57f5053f740799c189ab7be7e42cb','b937092feb204d07b7daa9302db5204f','deleted','100%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-1481919996',NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,NULL,NULL,NULL,1),('2026-02-20 10:01:00','2026-02-20 10:01:01','2026-02-20 10:01:02',1,'9654035d-e689-4889-b572-4277055da93e','5476cf79-b8d2-4c00-8659-e6a5397770d6','cbd4c180af67497989b022e398f54cc0','1effd5c1f8144a25a1cfdcbbbfeeb59f','deleted','100%',1,NULL,'tempest-VolumesSnapshotListTestJSON-Snapshot-1239058511',NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,NULL,NULL,NULL,1),('2026-02-20 10:00:42','2026-02-20 10:00:46','2026-02-20 10:00:47',1,'9b2a9b3d-0b5f-4614-a890-b13e76b1f200','66fd0b3e-3dcd-4e5e-8ecb-5d255b8a77ed','0a59a4e0759a4900accbf97025764545','55965a8332c94f2da5d707adc081ab9c','deleted','100%',1,NULL,'tempest-VolumesSnapshotTestJSON-Snapshot-408191250',NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,NULL,NULL,NULL,1),('2026-02-20 09:58:11','2026-02-20 09:58:12','2026-02-20 09:58:15',1,'9f1a787f-eeb4-4ea9-84a0-da762b3cffc0','15481572-d93d-4c42-a618-d7ec3ab35f66','129368ce43b64853b24a36395c84b7b0','8a43ccd6212d4626a208a271337f7a5b','deleted','100%',1,NULL,'tempest-VolumesDeleteCascade-Snapshot-1900282468',NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,NULL,NULL,NULL,1),('2026-02-20 10:01:13','2026-02-20 10:01:14','2026-02-20 10:01:15',1,'a7d913b7-b007-446b-91fa-9dc7a4972bcb','ac458691-61e7-4c11-8988-ca478b6baff6','03068d945a904ed681322842db1eca83','d3558f588a6e4dd690ecc5be43692a2e','deleted','100%',2,NULL,'tempest-VolumesSnapshotNegativeTestJSON-Snapshot-1710313152',NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,NULL,NULL,NULL,1),('2026-02-20 09:58:17','2026-02-20 09:58:20','2026-02-20 09:58:26',1,'ac0fd9c7-f7c0-4544-8baf-2ce078604e01','9b7c1883-4d4b-42cb-861c-50b81e4f9838','129368ce43b64853b24a36395c84b7b0','8a43ccd6212d4626a208a271337f7a5b','deleted','100%',1,NULL,'tempest-VolumesDeleteCascade-Snapshot-917875588',NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,NULL,NULL,NULL,1),('2026-02-20 09:57:52','2026-02-20 09:57:53','2026-02-20 09:57:55',1,'b681b878-b6ae-47d6-9608-97055f670de5','8600f630-91e6-443b-ae20-e89f0c12ff23','0dc008e570d04b43bb408f77d498ec03','51750f18434b4b60802ec6c49b096963','deleted','100%',1,NULL,'tempest-VolumeSnapshotQuotasNegativeTestJSON-Snapshot-498012135',NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,NULL,NULL,NULL,1),('2026-02-20 09:55:03','2026-02-20 09:55:09','2026-02-20 09:55:09',1,'bb048e50-3b90-456c-8dc5-7820bf412e37','34b09412-b810-4dc4-bc61-23a42c9dc49b','ffbb979ff9fb4e37a3cdbc9384522ee4','dcc08d5e298941e3a9de201aa565b6a9','deleted','100%',1,NULL,'tempest-GroupSnapshotsTest-Group_Snapshot-536418899',NULL,NULL,NULL,'9fbc5f58-7d77-4e9c-a111-2ee5ce9db580',NULL,NULL,NULL,'fb1a58cd-8488-4fee-88a6-181edc0e3efe',1),('2026-02-20 09:54:44','2026-02-20 09:54:51','2026-02-20 09:54:52',1,'c88d07b8-6d46-40ea-9155-1443261dcb12','e2a80799-fe57-4b63-8df7-e93ba7c73145','ffbb979ff9fb4e37a3cdbc9384522ee4','dcc08d5e298941e3a9de201aa565b6a9','deleted','100%',1,NULL,'tempest-group_snapshot-211378977',NULL,NULL,NULL,'b0ad793f-edef-47f4-a688-78153e5d36ea',NULL,NULL,NULL,'6d3f2094-6cff-46a5-aa20-462d7fcbd2e9',1),('2026-02-20 09:56:54','2026-02-20 09:56:56','2026-02-20 09:56:57',1,'cbf81c80-d06a-48e9-9372-d03c56abf153','8177547f-f2a3-4052-93ef-74c6f8e166ee','f46e8e39708342449b0ca6f44ee962d6','c415a23ac6624be8b258d5fae2607759','deleted','100%',1,NULL,'tempest-VolumesExtendTest-Snapshot-81047563',NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,NULL,NULL,NULL,1),('2026-02-20 09:55:03','2026-02-20 09:55:09','2026-02-20 09:55:09',1,'e1631406-ea82-4ac9-b344-f8bae6d8aa76','0bece557-9474-447b-81bc-f9ab3b1ca47f','ffbb979ff9fb4e37a3cdbc9384522ee4','dcc08d5e298941e3a9de201aa565b6a9','deleted','100%',1,NULL,'tempest-GroupSnapshotsTest-Group_Snapshot-536418899',NULL,NULL,NULL,'9fbc5f58-7d77-4e9c-a111-2ee5ce9db580',NULL,NULL,NULL,'fb1a58cd-8488-4fee-88a6-181edc0e3efe',1),('2026-02-20 09:57:16','2026-02-20 09:57:18','2026-02-20 09:57:19',1,'f1a16d61-8840-442c-b3e7-dd2b5e237b31','be42e48b-8334-4f89-a54f-ccf0cb67978d','82d57f5053f740799c189ab7be7e42cb','b937092feb204d07b7daa9302db5204f','deleted','100%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-1922733804',NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,NULL,NULL,NULL,1);
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`no_snapshots` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
INSERT INTO `transfers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `display_name`, `salt`, `crypt_hash`, `expires_at`, `no_snapshots`, `source_project_id`, `destination_project_id`, `accepted`) VALUES ('2026-02-20 09:58:06',NULL,'2026-02-20 09:58:07',1,'45f36029-e4dc-4f88-b6f4-cec7bb77ea82','b9816ab7-6ba1-4966-aecb-75e933ebd4b9',NULL,'91fd577f','863a27fae71629aecd4cbde56ef08607034fbe30',NULL,0,'d0fbb54da9274272b09aae9be8d15d07','c6099dcc2ecd4794925d1793d1a2a72c',1),('2026-02-20 09:59:42',NULL,'2026-02-20 09:59:43',1,'8314a15c-95af-4542-a537-8dcda1adc07b','c59f3375-9915-4b48-8e7e-7b0d9c0e8d24',NULL,'8e1f34e7','f8477c1af2f338ee06c53c037456b3d8226f6e89',NULL,0,'f47cf27181924d37b1f66305014193c3','6191d07901a6491993d029fffa6c4d91',1),('2026-02-20 09:56:03',NULL,'2026-02-20 09:56:03',1,'8b52f85d-fe62-417d-9a63-039843602cfa','28171f8f-705a-4eea-95b4-d8eed332cb6e',NULL,'eaae928d','a18105b3932981d66e2bab06cb596cba3c2fec52',NULL,0,'50be2d6048314f72aad782543bcc440d','ffe95c3ecb8041f08ab64f85fb74a65b',1),('2026-02-20 09:59:46',NULL,'2026-02-20 09:59:46',1,'c287b28c-d414-4726-95be-be1cc34c51e9','9e5bd5b9-6469-464a-a0ce-55379df0db4c',NULL,'4bcdbf0e','7862efcbbd610552edd4dc90d10753ff84856e63',NULL,0,'f47cf27181924d37b1f66305014193c3',NULL,0),('2026-02-20 09:56:16',NULL,'2026-02-20 09:56:17',1,'dca69267-000a-4759-bc2e-2551e72aeea4','92051fc0-2c83-44bf-a919-3a4f7ad25c2d',NULL,'9b1f16c4','75ecc59b1d4d07a0d539d39bf644f1cb9bd2d99a',NULL,0,'8b33a3c1c64247628d4927f39794f13e','1eff39cdacfd4eb28de1fa5742b73d15',1),('2026-02-20 09:56:19',NULL,'2026-02-20 09:56:19',1,'e9a406be-b382-43a9-a398-825ef96076ed','b3b1c023-43f4-4285-aba4-7b176d82a8fc',NULL,'b3acb1aa','901ae969b1a2a9cecdec411714043164983476ca',NULL,0,'8b33a3c1c64247628d4927f39794f13e',NULL,0),('2026-02-20 09:56:06',NULL,'2026-02-20 09:56:06',1,'f432d890-076d-4324-a3de-c9940c6d226b','4fcde82a-0c75-48a7-a859-cb00da2ca48d',NULL,'17505481','500b710d9051d8207b5966c72a7060ab92cbb846',NULL,0,'50be2d6048314f72aad782543bcc440d',NULL,0);
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
INSERT INTO `volume_admin_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `key`, `value`) VALUES ('2026-02-20 09:58:45','2026-02-20 09:58:45','2026-02-20 09:59:39',1,1,'1531bc86-bd90-4094-bd54-cbd8bc2ed2a9','readonly','False'),('2026-02-20 10:00:09',NULL,'2026-02-20 10:00:25',1,2,'02f5b768-6faa-4836-8aef-5d7ff3fbd831','temporary','True');
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
INSERT INTO `volume_attachment` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `attached_host`, `instance_uuid`, `mountpoint`, `attach_time`, `detach_time`, `attach_mode`, `attach_status`, `connection_info`, `connector`) VALUES ('2026-02-20 10:00:05','2026-02-20 10:00:28','2026-02-20 10:00:28',1,'de3d0ef3-bd59-4a88-ad53-923db98c831b','8eeb869d-f1f3-4733-a610-c567aaf12a0c','np0005625202.localdomain','25d7d566-3a21-4292-a6ad-96dca2d2ec79','/dev/vdb','2026-02-20 10:00:07','2026-02-20 10:00:28','rw','detached','{\"name\": \"volumes/volume-8eeb869d-f1f3-4733-a610-c567aaf12a0c\", \"hosts\": [\"172.18.0.103\", \"172.18.0.104\", \"172.18.0.105\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"a8557ee9-b55d-5519-942c-cf8f6172f1d8\", \"volume_id\": \"8eeb869d-f1f3-4733-a610-c567aaf12a0c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"de3d0ef3-bd59-4a88-ad53-923db98c831b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.106\", \"host\": \"np0005625202.localdomain\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d07221e4f0\", \"do_local_attach\": false, \"nvme_hostid\": \"61530aa3-6295-40fa-9f19-edfd227b2bca\", \"system uuid\": \"61530aa3-6295-40fa-9f19-edfd227b2bca\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:61530aa3-6295-40fa-9f19-edfd227b2bca\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}');
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
INSERT INTO `volume_glance_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `snapshot_id`, `key`, `value`) VALUES ('2026-02-20 09:55:50',NULL,'2026-02-20 09:55:55',1,1,'f6a2ba0c-d775-4bf9-b3f6-c42ecd4f66b1',NULL,'signature_verified','False'),('2026-02-20 09:55:53',NULL,'2026-02-20 09:55:55',1,2,'f6a2ba0c-d775-4bf9-b3f6-c42ecd4f66b1',NULL,'hw_rng_model','virtio'),('2026-02-20 09:55:53','2026-02-20 09:55:54','2026-02-20 09:55:55',1,3,'f6a2ba0c-d775-4bf9-b3f6-c42ecd4f66b1',NULL,'image_id','5137a025-3c5f-43c1-bc64-5f41270040a5'),('2026-02-20 09:55:53','2026-02-20 09:55:54','2026-02-20 09:55:55',1,4,'f6a2ba0c-d775-4bf9-b3f6-c42ecd4f66b1',NULL,'image_name','image'),('2026-02-20 09:55:53',NULL,'2026-02-20 09:55:55',1,5,'f6a2ba0c-d775-4bf9-b3f6-c42ecd4f66b1',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-02-20 09:55:53',NULL,'2026-02-20 09:55:55',1,6,'f6a2ba0c-d775-4bf9-b3f6-c42ecd4f66b1',NULL,'container_format','bare'),('2026-02-20 09:55:53',NULL,'2026-02-20 09:55:55',1,7,'f6a2ba0c-d775-4bf9-b3f6-c42ecd4f66b1',NULL,'disk_format','qcow2'),('2026-02-20 09:55:53',NULL,'2026-02-20 09:55:55',1,8,'f6a2ba0c-d775-4bf9-b3f6-c42ecd4f66b1',NULL,'min_disk','0'),('2026-02-20 09:55:53',NULL,'2026-02-20 09:55:55',1,9,'f6a2ba0c-d775-4bf9-b3f6-c42ecd4f66b1',NULL,'min_ram','0'),('2026-02-20 09:55:53',NULL,'2026-02-20 09:55:55',1,10,'f6a2ba0c-d775-4bf9-b3f6-c42ecd4f66b1',NULL,'size','21430272'),('2026-02-20 09:55:54',NULL,'2026-02-20 09:55:55',1,11,'f6a2ba0c-d775-4bf9-b3f6-c42ecd4f66b1',NULL,'kernel_id','6ff710d2-942b-4d6b-9168-8c9cc2404ab1'),('2026-02-20 09:55:54',NULL,'2026-02-20 09:55:54',1,12,'f6a2ba0c-d775-4bf9-b3f6-c42ecd4f66b1',NULL,'ramdisk_id','somedisk'),('2026-02-20 09:56:45',NULL,'2026-02-20 09:56:52',1,13,'0a01c029-e44f-4431-a641-08edcc6d758e',NULL,'signature_verified','False'),('2026-02-20 09:56:46',NULL,'2026-02-20 09:56:54',1,14,'3061139d-410e-4314-9b49-51bc1f02b41a',NULL,'signature_verified','False'),('2026-02-20 09:56:49',NULL,'2026-02-20 09:56:52',1,15,'0a01c029-e44f-4431-a641-08edcc6d758e',NULL,'hw_rng_model','virtio'),('2026-02-20 09:56:49',NULL,'2026-02-20 09:56:52',1,16,'0a01c029-e44f-4431-a641-08edcc6d758e',NULL,'image_id','06bd71fd-c415-45d9-b669-46209b7ca2f4'),('2026-02-20 09:56:49',NULL,'2026-02-20 09:56:52',1,17,'0a01c029-e44f-4431-a641-08edcc6d758e',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-02-20 09:56:49',NULL,'2026-02-20 09:56:52',1,18,'0a01c029-e44f-4431-a641-08edcc6d758e',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-02-20 09:56:49',NULL,'2026-02-20 09:56:52',1,19,'0a01c029-e44f-4431-a641-08edcc6d758e',NULL,'container_format','bare'),('2026-02-20 09:56:49',NULL,'2026-02-20 09:56:52',1,20,'0a01c029-e44f-4431-a641-08edcc6d758e',NULL,'disk_format','qcow2'),('2026-02-20 09:56:49',NULL,'2026-02-20 09:56:52',1,21,'0a01c029-e44f-4431-a641-08edcc6d758e',NULL,'min_disk','0'),('2026-02-20 09:56:49',NULL,'2026-02-20 09:56:52',1,22,'0a01c029-e44f-4431-a641-08edcc6d758e',NULL,'min_ram','0'),('2026-02-20 09:56:49',NULL,'2026-02-20 09:56:52',1,23,'0a01c029-e44f-4431-a641-08edcc6d758e',NULL,'size','21430272'),('2026-02-20 09:56:50',NULL,'2026-02-20 09:56:54',1,24,'3061139d-410e-4314-9b49-51bc1f02b41a',NULL,'hw_rng_model','virtio'),('2026-02-20 09:56:50',NULL,'2026-02-20 09:56:54',1,25,'3061139d-410e-4314-9b49-51bc1f02b41a',NULL,'image_id','06bd71fd-c415-45d9-b669-46209b7ca2f4'),('2026-02-20 09:56:50',NULL,'2026-02-20 09:56:54',1,26,'3061139d-410e-4314-9b49-51bc1f02b41a',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-02-20 09:56:50',NULL,'2026-02-20 09:56:54',1,27,'3061139d-410e-4314-9b49-51bc1f02b41a',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-02-20 09:56:50',NULL,'2026-02-20 09:56:54',1,28,'3061139d-410e-4314-9b49-51bc1f02b41a',NULL,'container_format','bare'),('2026-02-20 09:56:50',NULL,'2026-02-20 09:56:54',1,29,'3061139d-410e-4314-9b49-51bc1f02b41a',NULL,'disk_format','qcow2'),('2026-02-20 09:56:50',NULL,'2026-02-20 09:56:54',1,30,'3061139d-410e-4314-9b49-51bc1f02b41a',NULL,'min_disk','0'),('2026-02-20 09:56:50',NULL,'2026-02-20 09:56:54',1,31,'3061139d-410e-4314-9b49-51bc1f02b41a',NULL,'min_ram','0'),('2026-02-20 09:56:50',NULL,'2026-02-20 09:56:54',1,32,'3061139d-410e-4314-9b49-51bc1f02b41a',NULL,'size','21430272'),('2026-02-20 09:56:52',NULL,'2026-02-20 09:56:53',1,33,'295a8e6e-da01-4427-846d-3272c65f5830',NULL,'signature_verified','False'),('2026-02-20 09:56:52',NULL,'2026-02-20 09:56:53',1,34,'295a8e6e-da01-4427-846d-3272c65f5830',NULL,'hw_rng_model','virtio'),('2026-02-20 09:56:52',NULL,'2026-02-20 09:56:53',1,35,'295a8e6e-da01-4427-846d-3272c65f5830',NULL,'image_id','06bd71fd-c415-45d9-b669-46209b7ca2f4'),('2026-02-20 09:56:52',NULL,'2026-02-20 09:56:53',1,36,'295a8e6e-da01-4427-846d-3272c65f5830',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-02-20 09:56:52',NULL,'2026-02-20 09:56:53',1,37,'295a8e6e-da01-4427-846d-3272c65f5830',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-02-20 09:56:52',NULL,'2026-02-20 09:56:53',1,38,'295a8e6e-da01-4427-846d-3272c65f5830',NULL,'container_format','bare'),('2026-02-20 09:56:52',NULL,'2026-02-20 09:56:53',1,39,'295a8e6e-da01-4427-846d-3272c65f5830',NULL,'disk_format','qcow2'),('2026-02-20 09:56:52',NULL,'2026-02-20 09:56:53',1,40,'295a8e6e-da01-4427-846d-3272c65f5830',NULL,'min_disk','0'),('2026-02-20 09:56:52',NULL,'2026-02-20 09:56:53',1,41,'295a8e6e-da01-4427-846d-3272c65f5830',NULL,'min_ram','0'),('2026-02-20 09:56:52',NULL,'2026-02-20 09:56:53',1,42,'295a8e6e-da01-4427-846d-3272c65f5830',NULL,'size','21430272'),('2026-02-20 09:57:19',NULL,'2026-02-20 09:57:27',1,43,'e5649d73-d362-4467-a638-9d93425f0e41',NULL,'signature_verified','False'),('2026-02-20 09:57:23',NULL,'2026-02-20 09:57:27',1,44,'e5649d73-d362-4467-a638-9d93425f0e41',NULL,'hw_rng_model','virtio'),('2026-02-20 09:57:23',NULL,'2026-02-20 09:57:27',1,45,'e5649d73-d362-4467-a638-9d93425f0e41',NULL,'image_id','06bd71fd-c415-45d9-b669-46209b7ca2f4'),('2026-02-20 09:57:23',NULL,'2026-02-20 09:57:27',1,46,'e5649d73-d362-4467-a638-9d93425f0e41',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-02-20 09:57:23',NULL,'2026-02-20 09:57:27',1,47,'e5649d73-d362-4467-a638-9d93425f0e41',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-02-20 09:57:23',NULL,'2026-02-20 09:57:27',1,48,'e5649d73-d362-4467-a638-9d93425f0e41',NULL,'container_format','bare'),('2026-02-20 09:57:23',NULL,'2026-02-20 09:57:27',1,49,'e5649d73-d362-4467-a638-9d93425f0e41',NULL,'disk_format','qcow2'),('2026-02-20 09:57:23',NULL,'2026-02-20 09:57:27',1,50,'e5649d73-d362-4467-a638-9d93425f0e41',NULL,'min_disk','0'),('2026-02-20 09:57:23',NULL,'2026-02-20 09:57:27',1,51,'e5649d73-d362-4467-a638-9d93425f0e41',NULL,'min_ram','0'),('2026-02-20 09:57:23',NULL,'2026-02-20 09:57:27',1,52,'e5649d73-d362-4467-a638-9d93425f0e41',NULL,'size','21430272'),('2026-02-20 09:58:50',NULL,'2026-02-20 09:59:20',1,53,'7021fb58-60d1-4a77-9009-334fb28abc5e',NULL,'signature_verified','False'),('2026-02-20 09:58:54',NULL,'2026-02-20 09:59:20',1,54,'7021fb58-60d1-4a77-9009-334fb28abc5e',NULL,'hw_rng_model','virtio'),('2026-02-20 09:58:54',NULL,'2026-02-20 09:59:20',1,55,'7021fb58-60d1-4a77-9009-334fb28abc5e',NULL,'image_id','06bd71fd-c415-45d9-b669-46209b7ca2f4'),('2026-02-20 09:58:54',NULL,'2026-02-20 09:59:20',1,56,'7021fb58-60d1-4a77-9009-334fb28abc5e',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-02-20 09:58:54',NULL,'2026-02-20 09:59:20',1,57,'7021fb58-60d1-4a77-9009-334fb28abc5e',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-02-20 09:58:54',NULL,'2026-02-20 09:59:20',1,58,'7021fb58-60d1-4a77-9009-334fb28abc5e',NULL,'container_format','bare'),('2026-02-20 09:58:54',NULL,'2026-02-20 09:59:20',1,59,'7021fb58-60d1-4a77-9009-334fb28abc5e',NULL,'disk_format','qcow2'),('2026-02-20 09:58:54',NULL,'2026-02-20 09:59:20',1,60,'7021fb58-60d1-4a77-9009-334fb28abc5e',NULL,'min_disk','0'),('2026-02-20 09:58:54',NULL,'2026-02-20 09:59:20',1,61,'7021fb58-60d1-4a77-9009-334fb28abc5e',NULL,'min_ram','0'),('2026-02-20 09:58:54',NULL,'2026-02-20 09:59:20',1,62,'7021fb58-60d1-4a77-9009-334fb28abc5e',NULL,'size','21430272'),('2026-02-20 09:59:06',NULL,'2026-02-20 09:59:12',1,63,'910d88c1-0f88-4edf-ae6d-58b26ff1dc99',NULL,'signature_verified','False'),('2026-02-20 09:59:06',NULL,'2026-02-20 09:59:12',1,64,'910d88c1-0f88-4edf-ae6d-58b26ff1dc99',NULL,'hw_rng_model','virtio'),('2026-02-20 09:59:06',NULL,'2026-02-20 09:59:12',1,65,'910d88c1-0f88-4edf-ae6d-58b26ff1dc99',NULL,'image_id','06bd71fd-c415-45d9-b669-46209b7ca2f4'),('2026-02-20 09:59:06',NULL,'2026-02-20 09:59:12',1,66,'910d88c1-0f88-4edf-ae6d-58b26ff1dc99',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-02-20 09:59:06',NULL,'2026-02-20 09:59:12',1,67,'910d88c1-0f88-4edf-ae6d-58b26ff1dc99',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-02-20 09:59:06',NULL,'2026-02-20 09:59:12',1,68,'910d88c1-0f88-4edf-ae6d-58b26ff1dc99',NULL,'container_format','bare'),('2026-02-20 09:59:06',NULL,'2026-02-20 09:59:12',1,69,'910d88c1-0f88-4edf-ae6d-58b26ff1dc99',NULL,'disk_format','qcow2'),('2026-02-20 09:59:06',NULL,'2026-02-20 09:59:12',1,70,'910d88c1-0f88-4edf-ae6d-58b26ff1dc99',NULL,'min_disk','0'),('2026-02-20 09:59:06',NULL,'2026-02-20 09:59:12',1,71,'910d88c1-0f88-4edf-ae6d-58b26ff1dc99',NULL,'min_ram','0'),('2026-02-20 09:59:06',NULL,'2026-02-20 09:59:12',1,72,'910d88c1-0f88-4edf-ae6d-58b26ff1dc99',NULL,'size','21430272');
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
INSERT INTO `volume_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `key`, `value`) VALUES ('2026-02-20 09:57:05',NULL,'2026-02-20 09:57:09',1,1,'76bda116-d53d-4394-bda2-395c40dcc082','Type','Test'),('2026-02-20 09:57:11',NULL,'2026-02-20 09:57:15',1,2,'940f08b8-4e61-45c6-aade-f071fddf9681','Type','Test'),('2026-02-20 09:57:17',NULL,'2026-02-20 09:57:27',1,3,'e5649d73-d362-4467-a638-9d93425f0e41','Type','Test'),('2026-02-20 09:59:06',NULL,'2026-02-20 09:59:12',1,4,'82a61cb1-4fd5-4805-8fd0-06f26a6e3132','src_backup_id','a1a84c96-aa0f-4fb2-8eb9-6327a408f2e1'),('2026-02-20 09:59:06',NULL,'2026-02-20 09:59:12',1,5,'910d88c1-0f88-4edf-ae6d-58b26ff1dc99','src_backup_id','c97d1c82-4ed8-4592-ba9b-83de9658d77f'),('2026-02-20 09:59:35','2026-02-20 09:59:35','2026-02-20 09:59:35',1,6,'cf391c27-b7cf-4cd9-a897-7993a73afac7','key1','value1_update'),('2026-02-20 09:59:35','2026-02-20 09:59:35','2026-02-20 09:59:35',1,7,'cf391c27-b7cf-4cd9-a897-7993a73afac7','key2','value2'),('2026-02-20 09:59:35','2026-02-20 09:59:35','2026-02-20 09:59:35',1,8,'cf391c27-b7cf-4cd9-a897-7993a73afac7','key3','value3'),('2026-02-20 09:59:35','2026-02-20 09:59:35','2026-02-20 09:59:35',1,9,'cf391c27-b7cf-4cd9-a897-7993a73afac7','key4','value4'),('2026-02-20 09:59:35','2026-02-20 09:59:35','2026-02-20 09:59:35',1,10,'cf391c27-b7cf-4cd9-a897-7993a73afac7','key1','value1'),('2026-02-20 09:59:35','2026-02-20 09:59:35','2026-02-20 09:59:35',1,11,'cf391c27-b7cf-4cd9-a897-7993a73afac7','key2','value2'),('2026-02-20 09:59:35','2026-02-20 09:59:35','2026-02-20 09:59:35',1,12,'cf391c27-b7cf-4cd9-a897-7993a73afac7','key3','value3_update'),('2026-02-20 09:59:45',NULL,'2026-02-20 09:59:53',1,13,'42fb7373-958f-459d-8a12-a7bf6cb7f862','Type','work'),('2026-02-20 09:59:46',NULL,'2026-02-20 09:59:52',1,14,'0a91bfd1-1458-4293-9054-3da063f2351b','Type','work'),('2026-02-20 09:59:47',NULL,'2026-02-20 09:59:51',1,15,'35127d1d-3c34-4bb4-b818-da03b8ec0147','Type','work');
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
INSERT INTO `volume_type_extra_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_type_id`, `key`, `value`) VALUES ('2026-02-20 09:53:42',NULL,'2026-02-20 09:53:43',1,1,'5c2480bd-666a-49b3-bf0b-43b91238dea0','spec1','val1'),('2026-02-20 09:55:44',NULL,'2026-02-20 09:55:44',1,2,'1b75ecaa-cd19-4d86-9c13-fb8ce75dd13b','storage_protocol','iSCSI'),('2026-02-20 09:55:44',NULL,'2026-02-20 09:55:44',1,3,'1b75ecaa-cd19-4d86-9c13-fb8ce75dd13b','vendor_name','Open Source'),('2026-02-20 09:57:47',NULL,'2026-02-20 09:57:49',1,4,'cac8b652-2d04-4f08-a778-2fe5be4b5b05','storage_protocol','tempest-storage_protocol-2026439195'),('2026-02-20 09:57:47',NULL,'2026-02-20 09:57:49',1,5,'cac8b652-2d04-4f08-a778-2fe5be4b5b05','vendor_name','tempest-vendor_name-563172303'),('2026-02-20 09:57:49',NULL,'2026-02-20 09:57:50',1,6,'5ebd5d18-fcf0-4620-a390-bd39fc723ca3','storage_protocol','tempest-storage_protocol-2113742035'),('2026-02-20 09:57:49',NULL,'2026-02-20 09:57:50',1,7,'5ebd5d18-fcf0-4620-a390-bd39fc723ca3','vendor_name','tempest-vendor_name-1204171650'),('2026-02-20 09:57:55',NULL,'2026-02-20 09:57:56',1,8,'2b36e92d-b24d-4de9-b820-0db954c78fcd','spec3','val1'),('2026-02-20 09:57:56',NULL,'2026-02-20 09:57:56',1,9,'2b36e92d-b24d-4de9-b820-0db954c78fcd','spec1','val1'),('2026-02-20 09:57:56','2026-02-20 09:57:56','2026-02-20 09:57:56',1,10,'2b36e92d-b24d-4de9-b820-0db954c78fcd','spec2','val3'),('2026-02-20 09:57:56',NULL,'2026-02-20 09:57:56',1,11,'2b36e92d-b24d-4de9-b820-0db954c78fcd','spec4','val4');
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
INSERT INTO `volume_type_projects` (`id`, `created_at`, `updated_at`, `deleted_at`, `volume_type_id`, `project_id`, `deleted`) VALUES (1,'2026-02-20 09:59:46',NULL,'2026-02-20 09:59:48','cb62b5b0-2f76-4f4c-8be0-6b1241d47549','647a6092d7ca4d98a6d581a879bbcbac',1),(2,'2026-02-20 09:59:48',NULL,'2026-02-20 09:59:48','fbc22834-a871-45e4-853b-0c8d2e8504f2','647a6092d7ca4d98a6d581a879bbcbac',2),(3,'2026-02-20 09:59:48',NULL,'2026-02-20 09:59:48','fbc22834-a871-45e4-853b-0c8d2e8504f2','be93acd07fde4f3e825670e22220d787',3);
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`is_public` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2026-02-20 09:57:36','2026-02-20 09:57:36','2026-02-20 09:57:36',1,'0b01841e-4d5b-457b-992b-40f66041aa23','tempest-QosSpecsTestJSON-volume-type-1658810233',NULL,1,NULL),('2026-02-20 09:57:36','2026-02-20 09:57:36','2026-02-20 09:57:36',1,'12e5c7ea-43a6-4934-a65c-59ad0a8d9ee7','tempest-QosSpecsTestJSON-volume-type-213843957',NULL,1,NULL),('2026-02-20 09:55:45','2026-02-20 09:55:45','2026-02-20 09:55:45',1,'15209175-1c94-4a85-a8cf-2f61ca9d4515','tempest-volume-type-290761554',NULL,0,'tempest-volume-type-description-810230948'),('2026-02-20 09:55:44',NULL,'2026-02-20 09:55:44',1,'1b75ecaa-cd19-4d86-9c13-fb8ce75dd13b','tempest-VolumeTypesTest-volume-type-1581315237',NULL,1,'tempest-volume-type-description-1172851706'),('2026-02-20 09:55:13',NULL,'2026-02-20 09:55:20',1,'211da78d-0ac0-446b-b9cb-70aa203883c3','tempest-GroupSnapshotsTest-volume-type-247800390',NULL,1,NULL),('2026-02-20 09:57:55',NULL,'2026-02-20 09:57:56',1,'2b36e92d-b24d-4de9-b820-0db954c78fcd','tempest-VolumeTypesExtraSpecsTest-volume-type-55963574',NULL,1,NULL),('2026-02-20 09:58:24',NULL,'2026-02-20 09:58:24',1,'2f13275b-3083-47ec-8877-52470ce5c3db','tempest-VolumeTypesNegativeTest-volume-type-637908258',NULL,1,NULL),('2026-02-20 09:57:05',NULL,'2026-02-20 09:57:08',1,'47acb9d3-a1f5-45fa-a58a-6a04937a7a23','tempest-GroupsV320Test-volume-type-206826528',NULL,1,NULL),('2026-02-20 09:56:49',NULL,'2026-02-20 09:56:59',1,'519de3af-d85b-4d9a-aac2-b9c51c95164d','tempest-GroupsTest-volume-type-1756718363',NULL,1,NULL),('2026-02-20 09:53:42',NULL,'2026-02-20 09:53:43',1,'5c2480bd-666a-49b3-bf0b-43b91238dea0','tempest-ExtraSpecsNegativeTest-volume-type-1602795702',NULL,1,NULL),('2026-02-20 09:57:49',NULL,'2026-02-20 09:57:50',1,'5ebd5d18-fcf0-4620-a390-bd39fc723ca3','tempest-UserMessagesTest-volume-type-1936315209',NULL,1,NULL),('2026-02-20 09:59:24',NULL,'2026-02-20 09:59:31',1,'9107e722-35f2-487a-9e8c-688c465ca7e2','tempest-GroupsV314Test-volume-type-940356249',NULL,1,NULL),('2026-02-20 09:56:42',NULL,'2026-02-20 09:56:49',1,'91e655c2-f217-4612-bc71-3497021f6790','tempest-GroupsTest-volume-type-1805649748',NULL,1,NULL),('2026-02-20 09:59:36',NULL,'2026-02-20 09:59:40',1,'92286037-b8ce-4fe6-8915-4777bbcd74f3','volume-type-2',NULL,1,NULL),('2026-02-20 09:57:36','2026-02-20 09:57:36','2026-02-20 09:57:36',1,'9ba68fc8-624d-4c84-9b42-10052d09253b','tempest-QosSpecsTestJSON-volume-type-1873738804',NULL,1,NULL),('2026-02-20 09:54:54',NULL,'2026-02-20 09:55:13',1,'9fbc5f58-7d77-4e9c-a111-2ee5ce9db580','tempest-GroupSnapshotsTest-volume-type-2074118595',NULL,1,NULL),('2026-02-20 09:54:41',NULL,'2026-02-20 09:54:54',1,'b0ad793f-edef-47f4-a688-78153e5d36ea','tempest-GroupSnapshotsTest-volume-type-1659843599',NULL,1,NULL),('2026-02-20 08:13:10',NULL,NULL,0,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d','tripleo',NULL,1,NULL),('2026-02-20 09:58:24',NULL,'2026-02-20 09:58:24',1,'bc15bb90-db91-4774-bc74-9361ded3b18c','tempest-VolumeTypesNegativeTest-volume-type-1564840820',NULL,0,NULL),('2026-02-20 09:55:44',NULL,'2026-02-20 09:55:45',1,'c5aaf48b-7390-4ce5-b523-589a02f7b9b3','tempest-VolumeTypesTest-volume-type-412252153',NULL,1,NULL),('2026-02-20 09:57:47',NULL,'2026-02-20 09:57:49',1,'cac8b652-2d04-4f08-a778-2fe5be4b5b05','tempest-UserMessagesTest-volume-type-507641628',NULL,1,NULL),('2026-02-20 09:59:46',NULL,'2026-02-20 09:59:48',1,'cb62b5b0-2f76-4f4c-8be0-6b1241d47549','tempest-VolumeTypesAccessTest-volume-type-761717452',NULL,0,NULL),('2026-02-20 08:05:43','2026-02-20 08:05:43','2026-02-20 08:13:15',1,'cf9a4d83-cbe1-4b70-ba0e-8a081a55c495','__DEFAULT__',NULL,1,'Default Volume Type'),('2026-02-20 09:57:29',NULL,'2026-02-20 09:57:36',1,'d29ddbab-68de-4b71-aa71-4b968f18ee1d','tempest-GroupSnapshotsV319Test-volume-type-1380989222',NULL,1,NULL),('2026-02-20 09:59:36',NULL,'2026-02-20 09:59:40',1,'d71460c3-a1de-49db-bfbe-73954050f8dd','volume-type-1',NULL,1,NULL),('2026-02-20 09:55:27',NULL,'2026-02-20 09:55:27',1,'d92a8bb1-244b-4ea7-9e8c-608e6d2eb01e','tempest-VolumeQuotaClassesTest-volume-type-2090279830',NULL,1,NULL),('2026-02-20 09:59:48',NULL,'2026-02-20 09:59:49',1,'fbc22834-a871-45e4-853b-0c8d2e8504f2','tempest-VolumeTypesAccessTest-volume-type-1902892157',NULL,0,NULL);
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`bootable` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`multiattach` in (0,1)),
  CONSTRAINT `CONSTRAINT_4` CHECK (`shared_targets` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
INSERT INTO `volumes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `ec2_id`, `user_id`, `project_id`, `host`, `size`, `availability_zone`, `status`, `attach_status`, `scheduled_at`, `launched_at`, `terminated_at`, `display_name`, `display_description`, `provider_location`, `provider_auth`, `snapshot_id`, `volume_type_id`, `source_volid`, `bootable`, `provider_geometry`, `_name_id`, `encryption_key_id`, `migration_status`, `replication_status`, `replication_extended_status`, `replication_driver_data`, `consistencygroup_id`, `provider_id`, `multiattach`, `previous_status`, `cluster_name`, `group_id`, `service_uuid`, `shared_targets`, `use_quota`) VALUES ('2026-02-20 10:00:09','2026-02-20 10:00:10','2026-02-20 10:00:25',1,'02f5b768-6faa-4836-8aef-5d7ff3fbd831',NULL,'0a59a4e0759a4900accbf97025764545','55965a8332c94f2da5d707adc081ab9c','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached',NULL,NULL,NULL,'backup-vol-53af8aa6-057c-4cb9-8a9e-c2bf19735f85',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,1,0),('2026-02-20 09:56:44','2026-02-20 09:56:50','2026-02-20 09:56:52',1,'0a01c029-e44f-4431-a641-08edcc6d758e',NULL,'f46e8e39708342449b0ca6f44ee962d6','c415a23ac6624be8b258d5fae2607759','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2026-02-20 09:56:44','2026-02-20 09:56:49','2026-02-20 09:56:50','tempest-VolumesExtendTest-Volume-946046370',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:59:46','2026-02-20 09:59:51','2026-02-20 09:59:52',1,'0a91bfd1-1458-4293-9054-3da063f2351b',NULL,'a249774498824462ace4b66a3d81b29c','d8d571d58a9b4b3cb35695d51c9ad2dc','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:59:46','2026-02-20 09:59:46','2026-02-20 09:59:51','tempest-VolumesListTestJSON-Volume-953224299',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:54:55','2026-02-20 09:55:11','2026-02-20 09:55:12',1,'0bece557-9474-447b-81bc-f9ab3b1ca47f',NULL,'ffbb979ff9fb4e37a3cdbc9384522ee4','dcc08d5e298941e3a9de201aa565b6a9','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:54:55','2026-02-20 09:54:55',NULL,'tempest-volume-1738704532',NULL,NULL,NULL,NULL,'9fbc5f58-7d77-4e9c-a111-2ee5ce9db580',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'21a6bf48-fb20-49c1-9d06-ca601aa63b63','2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:57:13','2026-02-20 09:57:14','2026-02-20 09:57:14',1,'0d1c389f-0c6d-42dc-b06a-efb86e68032e',NULL,'3c6a99f7be8048329c5edc3d04bf3c7d','43a8c5592dc64c5a935d4d8b5fb44ad8','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:57:13','2026-02-20 09:57:13','2026-02-20 09:57:14','tempest-VolumesGetTest-Volume-467060540',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:56:50','2026-02-20 09:56:57','2026-02-20 09:56:58',1,'0f02d178-e97f-4b42-aaeb-29d5662fe912',NULL,'05feeb2aee824362a8103784cc43648d','fd2fac9a2a1a4fd49d87e5d4ff1b64b3','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:56:50','2026-02-20 09:56:51',NULL,'tempest-volume-165675287',NULL,NULL,NULL,NULL,'519de3af-d85b-4d9a-aac2-b9c51c95164d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'60fc2d42-b6dc-47a0-a7e7-6a289a579f14','2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:55:35','2026-02-20 09:55:36','2026-02-20 09:55:37',1,'11d6f85d-7af9-43eb-9bea-92e47e4c2798',NULL,'591409f3248041b4b1289e21ae84fd8c','17f50febac1846c0a653b60a8f30a43a','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:55:35','2026-02-20 09:55:35','2026-02-20 09:55:36','tempest-VolumesServicesTestJSON-Volume-280191149',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:58:43','2026-02-20 09:59:38','2026-02-20 09:59:39',1,'1531bc86-bd90-4094-bd54-cbd8bc2ed2a9',NULL,'90550ad21b7d451cb8e34a1909d08113','68573218a6b141beb49fbacc5b306c7d','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:58:43','2026-02-20 09:58:44','2026-02-20 09:59:38','tempest-VolumesActionsTest-Volume-1494678045',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:58:08','2026-02-20 09:58:12','2026-02-20 09:58:15',1,'15481572-d93d-4c42-a618-d7ec3ab35f66',NULL,'129368ce43b64853b24a36395c84b7b0','8a43ccd6212d4626a208a271337f7a5b','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:58:09','2026-02-20 09:58:09','2026-02-20 09:58:12','tempest-VolumesDeleteCascade-Volume-50937376',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:54:29','2026-02-20 09:54:39','2026-02-20 09:54:39',1,'176929d9-43cd-487c-9210-968a1b0fce46',NULL,'27c27b2e003b45569cb3ddf45c5c298e','416b8c7a0c6f48629bf55e44152bc962','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:54:29','2026-02-20 09:54:30','2026-02-20 09:54:39','tempest-VolumesNegativeTest-Volume-1343565356',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:54:47','2026-02-20 09:54:49','2026-02-20 09:54:49',1,'1bdfff6e-1573-473e-8a2a-9c9adcac86b6',NULL,'ffbb979ff9fb4e37a3cdbc9384522ee4','dcc08d5e298941e3a9de201aa565b6a9','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'c88d07b8-6d46-40ea-9155-1443261dcb12','b0ad793f-edef-47f4-a688-78153e5d36ea',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'22246b22-9b6c-4a80-afa0-bcae335fa203',NULL,1,1),('2026-02-20 09:56:02','2026-02-20 09:56:04','2026-02-20 09:56:04',1,'28171f8f-705a-4eea-95b4-d8eed332cb6e',NULL,'c1930390ea784351b9366656b06dbbce','ffe95c3ecb8041f08ab64f85fb74a65b','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:56:02','2026-02-20 09:56:02','2026-02-20 09:56:04','tempest-VolumesTransfersTest-Volume-1059609693',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:56:51','2026-02-20 09:56:53','2026-02-20 09:56:53',1,'295a8e6e-da01-4427-846d-3272c65f5830',NULL,'cfd8fd24bbb54adf8f682266baa12b35','63c8b3e7b8b445b68b501883951607d3','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:56:51','2026-02-20 09:56:52','2026-02-20 09:56:53','tempest-VolumesCloneTest-Volume-1884273326',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d','3061139d-410e-4314-9b49-51bc1f02b41a',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:56:44','2026-02-20 09:56:54','2026-02-20 09:56:54',1,'3061139d-410e-4314-9b49-51bc1f02b41a',NULL,'cfd8fd24bbb54adf8f682266baa12b35','63c8b3e7b8b445b68b501883951607d3','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:56:44','2026-02-20 09:56:50','2026-02-20 09:56:54','tempest-VolumesCloneTest-Volume-1849414011',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:54:57','2026-02-20 09:55:11','2026-02-20 09:55:12',1,'34b09412-b810-4dc4-bc61-23a42c9dc49b',NULL,'ffbb979ff9fb4e37a3cdbc9384522ee4','dcc08d5e298941e3a9de201aa565b6a9','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:54:57','2026-02-20 09:54:57',NULL,'tempest-volume-995912294',NULL,NULL,NULL,NULL,'9fbc5f58-7d77-4e9c-a111-2ee5ce9db580',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'21a6bf48-fb20-49c1-9d06-ca601aa63b63','2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:59:47','2026-02-20 09:59:50','2026-02-20 09:59:51',1,'35127d1d-3c34-4bb4-b818-da03b8ec0147',NULL,'a249774498824462ace4b66a3d81b29c','d8d571d58a9b4b3cb35695d51c9ad2dc','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:59:47','2026-02-20 09:59:48','2026-02-20 09:59:50','tempest-VolumesListTestJSON-Volume-1141272266',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:56:29','2026-02-20 09:56:39','2026-02-20 09:56:40',1,'35565fa6-046a-4989-b49c-6a04300da192',NULL,'461cbaeb01d54029a644a346151cbf22','226ab368400e4186b91e98a77b240268','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:56:29','2026-02-20 09:56:30','2026-02-20 09:56:39','tempest-VolumesBackupsV39Test-Volume-1920349157',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:54:17','2026-02-20 09:54:18','2026-02-20 09:54:19',1,'37bd0215-9332-4195-99d1-4f799983c2a0',NULL,'2719d438d7f748859137b8d94fff813a','c11d214ddb8444b499694b7fa72c8896','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2026-02-20 09:54:17','2026-02-20 09:54:17','2026-02-20 09:54:18','tempest-VolumesCloneNegativeTest-Volume-723644506',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 10:00:43','2026-02-20 10:00:45','2026-02-20 10:00:45',1,'3cfb58c2-7c67-4549-9ee3-1638f0feea95',NULL,'0a59a4e0759a4900accbf97025764545','55965a8332c94f2da5d707adc081ab9c','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 10:00:43','2026-02-20 10:00:44','2026-02-20 10:00:45','tempest-VolumesSnapshotTestJSON-Volume-430915954',NULL,NULL,NULL,'9b2a9b3d-0b5f-4614-a890-b13e76b1f200','b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:59:46','2026-02-20 09:59:47','2026-02-20 09:59:48',1,'412d7f9b-8230-4178-977c-c5c2e42b28fe',NULL,'893fd6f0dfd84429b2495b07d86777af','647a6092d7ca4d98a6d581a879bbcbac','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:59:46','2026-02-20 09:59:46','2026-02-20 09:59:47','tempest-VolumeTypesAccessTest-Volume-576205255',NULL,NULL,NULL,NULL,'cb62b5b0-2f76-4f4c-8be0-6b1241d47549',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:59:45','2026-02-20 09:59:53','2026-02-20 09:59:53',1,'42fb7373-958f-459d-8a12-a7bf6cb7f862',NULL,'a249774498824462ace4b66a3d81b29c','d8d571d58a9b4b3cb35695d51c9ad2dc','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:59:45','2026-02-20 09:59:45','2026-02-20 09:59:53','tempest-VolumesListTestJSON-Volume-1933029688',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:59:18','2026-02-20 09:59:25','2026-02-20 09:59:27',1,'46236fa4-de9b-4076-afa4-b3fdca1d5fb9',NULL,'555b92d39f27422695207483d3e530ad','dc400fd7b37f468c83d54846895b6cba','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:59:18','2026-02-20 09:59:19','2026-02-20 09:59:25','tempest-VolumesBackupsAdminTest-Volume-1937148386',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:56:05','2026-02-20 09:56:06','2026-02-20 09:56:07',1,'4fcde82a-0c75-48a7-a859-cb00da2ca48d',NULL,'8d032c6e05ba4d399a9e92d9fafd8ae7','50be2d6048314f72aad782543bcc440d','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:56:05','2026-02-20 09:56:05','2026-02-20 09:56:06','tempest-VolumesTransfersTest-Volume-1825536965',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 10:00:06','2026-02-20 10:00:48','2026-02-20 10:00:49',1,'53af8aa6-057c-4cb9-8a9e-c2bf19735f85',NULL,'0a59a4e0759a4900accbf97025764545','55965a8332c94f2da5d707adc081ab9c','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 10:00:06','2026-02-20 10:00:06','2026-02-20 10:00:48','tempest-VolumesSnapshotTestJSON-Volume-247982068',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 10:00:56','2026-02-20 10:01:08','2026-02-20 10:01:08',1,'5476cf79-b8d2-4c00-8659-e6a5397770d6',NULL,'cbd4c180af67497989b022e398f54cc0','1effd5c1f8144a25a1cfdcbbbfeeb59f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 10:00:56','2026-02-20 10:00:56','2026-02-20 10:01:08','tempest-VolumesSnapshotListTestJSON-Volume-1685935491',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:58:30','2026-02-20 09:58:32','2026-02-20 09:58:33',1,'5aa9db08-5006-448a-9282-b4c6c2ce7aa6',NULL,'c95f42a86dd348a68ea4d21f5679364c','d0e47cd34a784cbb89cbe56eafed5650','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:58:31','2026-02-20 09:58:31','2026-02-20 09:58:32','tempest-VolumesActionsTest-Volume-206315259',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:57:49','2026-02-20 09:57:49','2026-02-20 09:57:50',1,'5b8b44ec-5798-44d9-bb77-87a19d8d66be',NULL,'0ba3933a0cac4d92b59661133ccf4646','128736e99cb541468aa88da3588f267d',NULL,1,'nova','deleted','detached',NULL,NULL,NULL,'tempest-UserMessagesTest-Volume-380133626',NULL,NULL,NULL,NULL,'5ebd5d18-fcf0-4620-a390-bd39fc723ca3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,1,1),('2026-02-20 09:53:51','2026-02-20 09:54:08','2026-02-20 09:54:08',1,'5fcad25a-e0a8-4250-976a-336c69c42e10',NULL,'755eb55caba940e6acb67e3260f0126c','ceda6d23d7184b90ba109505854d972f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:53:51','2026-02-20 09:53:53','2026-02-20 09:54:08','tempest-VolumesListAdminTestJSON-Volume-989094033',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:53:54','2026-02-20 09:54:07','2026-02-20 09:54:07',1,'6566884f-7e9a-45f4-8147-68cda53253a5',NULL,'755eb55caba940e6acb67e3260f0126c','ceda6d23d7184b90ba109505854d972f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:53:54','2026-02-20 09:53:54','2026-02-20 09:54:07','tempest-VolumesListAdminTestJSON-Volume-2009599046',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 10:00:41','2026-02-20 10:00:47','2026-02-20 10:00:48',1,'66fd0b3e-3dcd-4e5e-8ecb-5d255b8a77ed',NULL,'0a59a4e0759a4900accbf97025764545','55965a8332c94f2da5d707adc081ab9c','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 10:00:41','2026-02-20 10:00:41','2026-02-20 10:00:47','tempest-VolumesSnapshotTestJSON-Volume-143400257',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:58:48','2026-02-20 09:59:18','2026-02-20 09:59:20',1,'7021fb58-60d1-4a77-9009-334fb28abc5e',NULL,'2ba1a8d771344f0a918e0a8bed2efd06','9fdf2c09b98d48c0bc67cc1c7702a8f4','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:58:48','2026-02-20 09:58:54','2026-02-20 09:59:18','tempest-VolumesBackupsTest-Volume-641331832',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:59:28','2026-02-20 09:59:29','2026-02-20 09:59:29',1,'75fc0508-0bdf-4a85-8e3a-7ae3cc535f61',NULL,'9b3af574e998460eb018052ec24016f7','4eb963516e994397b5c6f3bb155e8d11','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'9107e722-35f2-487a-9e8c-688c465ca7e2','c1f378f5-173c-43be-820d-3aa59494ed81',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'9eebd1ea-aec1-4f10-bc6e-d8327496c1ad',NULL,1,1),('2026-02-20 09:57:05','2026-02-20 09:57:09','2026-02-20 09:57:09',1,'76bda116-d53d-4394-bda2-395c40dcc082',NULL,'3c6a99f7be8048329c5edc3d04bf3c7d','43a8c5592dc64c5a935d4d8b5fb44ad8','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:57:05','2026-02-20 09:57:05','2026-02-20 09:57:09','tempest-VolumesGetTest-new-Volume-849070021','This is the new description of volume',NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:59:36','2026-02-20 09:59:39','2026-02-20 09:59:39',1,'7a396ea1-0e87-4979-90f4-ecc508d5e907',NULL,'471ad779c8384258880718ac3bd4246e','af7558d3f3e7491c82e203a181c2b164','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:59:36','2026-02-20 09:59:36','2026-02-20 09:59:39','tempest-VolumeRetypeWithoutMigrationTest-Volume-1291109880',NULL,NULL,NULL,NULL,'92286037-b8ce-4fe6-8915-4777bbcd74f3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 10:00:35','2026-02-20 10:00:36','2026-02-20 10:00:37',1,'7ac05bf3-6c68-4d64-851a-76a8b66d26f6',NULL,'0a59a4e0759a4900accbf97025764545','55965a8332c94f2da5d707adc081ab9c','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2026-02-20 10:00:35','2026-02-20 10:00:36','2026-02-20 10:00:36','tempest-VolumesSnapshotTestJSON-Volume-347732394',NULL,NULL,NULL,'5892d266-ac85-4099-9c59-aac93526e226','b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:56:33','2026-02-20 09:56:37','2026-02-20 09:56:38',1,'7f0557eb-9b8b-4427-bd2f-9ed9ae60cb24',NULL,'df2bafbc0815447296ee536b0161623a','6b6c3ea6fad948cbaee73bff3485d7da','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:56:33','2026-02-20 09:56:34','2026-02-20 09:56:37','tempest-SnapshotMetadataTestJSON-Volume-120864966',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:56:52','2026-02-20 09:56:57','2026-02-20 09:56:58',1,'8177547f-f2a3-4052-93ef-74c6f8e166ee',NULL,'f46e8e39708342449b0ca6f44ee962d6','c415a23ac6624be8b258d5fae2607759','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2026-02-20 09:56:53','2026-02-20 09:56:53','2026-02-20 09:56:57','tempest-VolumesExtendTest-Volume-334772785',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:59:00','2026-02-20 09:59:07','2026-02-20 09:59:12',1,'82a61cb1-4fd5-4805-8fd0-06f26a6e3132',NULL,'555b92d39f27422695207483d3e530ad','dc400fd7b37f468c83d54846895b6cba','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:59:00','2026-02-20 09:59:01','2026-02-20 09:59:07','tempest-VolumesBackupsAdminTest-Volume-2094930508',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:58:23','2026-02-20 09:58:24','2026-02-20 09:58:25',1,'8347b9a5-b524-4e4d-80c7-30a45e25b8c3',NULL,'c95f42a86dd348a68ea4d21f5679364c','d0e47cd34a784cbb89cbe56eafed5650','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:58:23','2026-02-20 09:58:23','2026-02-20 09:58:24','tempest-VolumesActionsTest-Volume-2108195914',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:57:51','2026-02-20 09:57:56','2026-02-20 09:57:56',1,'8600f630-91e6-443b-ae20-e89f0c12ff23',NULL,'0dc008e570d04b43bb408f77d498ec03','51750f18434b4b60802ec6c49b096963','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:57:51','2026-02-20 09:57:51','2026-02-20 09:57:56','tempest-VolumeSnapshotQuotasNegativeTestJSON-Volume-658355642',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:58:25','2026-02-20 09:58:27','2026-02-20 09:58:27',1,'86cbd60b-f875-412f-82eb-58f26659f5ff',NULL,'c95f42a86dd348a68ea4d21f5679364c','d0e47cd34a784cbb89cbe56eafed5650','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:58:26','2026-02-20 09:58:26','2026-02-20 09:58:27','tempest-VolumesActionsTest-Volume-604757738',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:58:03','2026-02-20 09:58:04','2026-02-20 09:58:04',1,'86fe6fd4-da02-489b-a4d6-7ff406d250d7',NULL,'af186077fdaf4bdb943cf9d65db6b218','d0fbb54da9274272b09aae9be8d15d07','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:58:03','2026-02-20 09:58:03','2026-02-20 09:58:04','tempest-VolumeQuotasAdminTestJSON-Volume-298933563',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:53:56','2026-02-20 09:53:59','2026-02-20 09:54:06',1,'876a36ef-1c0a-460b-aed9-5f080c4179b4',NULL,'755eb55caba940e6acb67e3260f0126c','ceda6d23d7184b90ba109505854d972f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:53:56','2026-02-20 09:53:56','2026-02-20 09:53:59','tempest-VolumesListAdminTestJSON-Volume-550439297',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:57:47','2026-02-20 09:57:47','2026-02-20 09:57:48',1,'8d0df121-f82d-4261-88b0-55eaec3e4df8',NULL,'0ba3933a0cac4d92b59661133ccf4646','128736e99cb541468aa88da3588f267d',NULL,1,'nova','deleted','detached',NULL,NULL,NULL,'tempest-UserMessagesTest-Volume-383182589',NULL,NULL,NULL,NULL,'cac8b652-2d04-4f08-a778-2fe5be4b5b05',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,1,1),('2026-02-20 09:56:52','2026-02-20 09:56:58','2026-02-20 09:56:58',1,'8d480b6d-1d6d-4c32-a491-71d72a4cd901',NULL,'05feeb2aee824362a8103784cc43648d','fd2fac9a2a1a4fd49d87e5d4ff1b64b3','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:56:52','2026-02-20 09:56:52',NULL,'tempest-volume-1162918968',NULL,NULL,NULL,NULL,'519de3af-d85b-4d9a-aac2-b9c51c95164d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'60fc2d42-b6dc-47a0-a7e7-6a289a579f14','2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:59:21','2026-02-20 10:00:34','2026-02-20 10:00:37',1,'8eeb869d-f1f3-4733-a610-c567aaf12a0c',NULL,'2ba1a8d771344f0a918e0a8bed2efd06','9fdf2c09b98d48c0bc67cc1c7702a8f4','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:59:21','2026-02-20 09:59:21','2026-02-20 10:00:34','tempest-VolumesBackupsTest-Volume-911328051',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:53:58','2026-02-20 09:53:59','2026-02-20 09:54:06',1,'8f6ec4ed-f239-40c0-b4d2-d6401462cf21',NULL,'021e5846b896423b9fc9866d8ce0eb8a','22b016cf9f2d403d952239fb4ab79c4a','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:53:58','2026-02-20 09:53:58','2026-02-20 09:53:59',NULL,NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:58:59','2026-02-20 09:59:07','2026-02-20 09:59:12',1,'910d88c1-0f88-4edf-ae6d-58b26ff1dc99',NULL,'2ba1a8d771344f0a918e0a8bed2efd06','9fdf2c09b98d48c0bc67cc1c7702a8f4','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:59:00','2026-02-20 09:59:00','2026-02-20 09:59:07','tempest-VolumesBackupsTest-Volume-641331832',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:56:15','2026-02-20 09:56:17','2026-02-20 09:56:17',1,'92051fc0-2c83-44bf-a919-3a4f7ad25c2d',NULL,'6094994f24954c42ac628c0b09fe3743','1eff39cdacfd4eb28de1fa5742b73d15','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:56:15','2026-02-20 09:56:15','2026-02-20 09:56:17','tempest-VolumesTransfersV357Test-Volume-274191206',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 10:00:31','2026-02-20 10:00:40','2026-02-20 10:00:40',1,'93ff9562-90bb-4b46-8669-dc485cc31a88',NULL,'0a59a4e0759a4900accbf97025764545','55965a8332c94f2da5d707adc081ab9c','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 10:00:31','2026-02-20 10:00:32','2026-02-20 10:00:40','tempest-VolumesSnapshotTestJSON-Volume-749073567',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:57:11','2026-02-20 09:57:15','2026-02-20 09:57:15',1,'940f08b8-4e61-45c6-aade-f071fddf9681',NULL,'3c6a99f7be8048329c5edc3d04bf3c7d','43a8c5592dc64c5a935d4d8b5fb44ad8','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:57:11','2026-02-20 09:57:12','2026-02-20 09:57:15','tempest-VolumesGetTest-new-Volume-1789503421','This is the new description of volume',NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d','db266298-fc55-41e4-a772-93601f135714',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:58:16','2026-02-20 09:58:20','2026-02-20 09:58:26',1,'9b7c1883-4d4b-42cb-861c-50b81e4f9838',NULL,'129368ce43b64853b24a36395c84b7b0','8a43ccd6212d4626a208a271337f7a5b','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:58:16','2026-02-20 09:58:16','2026-02-20 09:58:20','tempest-VolumesDeleteCascade-Volume-1055462050',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:59:44','2026-02-20 09:59:46','2026-02-20 09:59:46',1,'9e5bd5b9-6469-464a-a0ce-55379df0db4c',NULL,'dd268c1f9ee446539e3c068b23100abc','f47cf27181924d37b1f66305014193c3','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:59:44','2026-02-20 09:59:45','2026-02-20 09:59:46','tempest-VolumesTransfersV355Test-Volume-1194834468',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 10:01:12','2026-02-20 10:01:15','2026-02-20 10:01:16',1,'ac458691-61e7-4c11-8988-ca478b6baff6',NULL,'03068d945a904ed681322842db1eca83','d3558f588a6e4dd690ecc5be43692a2e','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2026-02-20 10:01:12','2026-02-20 10:01:12','2026-02-20 10:01:15','tempest-VolumesSnapshotNegativeTestJSON-Volume-1232671604',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:58:53','2026-02-20 09:59:16','2026-02-20 09:59:18',1,'b134140b-bf4f-40e9-987b-6889d71ec45a',NULL,'555b92d39f27422695207483d3e530ad','dc400fd7b37f468c83d54846895b6cba','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:58:53','2026-02-20 09:58:54','2026-02-20 09:59:16','tempest-VolumesBackupsAdminTest-Volume-2094930508',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:56:18','2026-02-20 09:56:19','2026-02-20 09:56:20',1,'b3b1c023-43f4-4285-aba4-7b176d82a8fc',NULL,'35bf19fc0896430baaf96bc10f70181f','8b33a3c1c64247628d4927f39794f13e','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:56:18','2026-02-20 09:56:18','2026-02-20 09:56:19','tempest-VolumesTransfersV357Test-Volume-1089006806',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:58:05','2026-02-20 09:58:07','2026-02-20 09:58:07',1,'b9816ab7-6ba1-4966-aecb-75e933ebd4b9',NULL,'293922800a244eaca4a73432a4eef3bd','c6099dcc2ecd4794925d1793d1a2a72c','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:58:05','2026-02-20 09:58:05','2026-02-20 09:58:07','tempest-VolumeQuotasAdminTestJSON-Volume-1578764071',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:58:18','2026-02-20 09:58:27','2026-02-20 09:58:28',1,'bb2bf1e5-a249-4c86-8807-5a10ec7d9735',NULL,'129368ce43b64853b24a36395c84b7b0','8a43ccd6212d4626a208a271337f7a5b','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:58:18','2026-02-20 09:58:19','2026-02-20 09:58:27','tempest-VolumesDeleteCascade-Volume-59300723',NULL,NULL,NULL,'ac0fd9c7-f7c0-4544-8baf-2ce078604e01','b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:57:12','2026-02-20 09:57:32','2026-02-20 09:57:33',1,'be42e48b-8334-4f89-a54f-ccf0cb67978d',NULL,'82d57f5053f740799c189ab7be7e42cb','b937092feb204d07b7daa9302db5204f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:57:13','2026-02-20 09:57:13','2026-02-20 09:57:32','tempest-SnapshotsActionsTest-Volume-808757746',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:58:28','2026-02-20 09:58:29','2026-02-20 09:58:30',1,'c0548444-beec-4133-aae3-c181f2b0b10f',NULL,'c95f42a86dd348a68ea4d21f5679364c','d0e47cd34a784cbb89cbe56eafed5650','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:58:28','2026-02-20 09:58:28','2026-02-20 09:58:29','tempest-VolumesActionsTest-Volume-101525538',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:59:26','2026-02-20 09:59:30','2026-02-20 09:59:30',1,'c1f378f5-173c-43be-820d-3aa59494ed81',NULL,'9b3af574e998460eb018052ec24016f7','4eb963516e994397b5c6f3bb155e8d11','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:59:26','2026-02-20 09:59:26',NULL,'tempest-volume-150424426',NULL,NULL,NULL,NULL,'9107e722-35f2-487a-9e8c-688c465ca7e2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'c66a2d0e-858d-404d-96f8-5f66c0296e90','2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:59:41','2026-02-20 09:59:43','2026-02-20 09:59:44',1,'c59f3375-9915-4b48-8e7e-7b0d9c0e8d24',NULL,'7103a027069f4ba29519e2409a57e190','6191d07901a6491993d029fffa6c4d91','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:59:41','2026-02-20 09:59:41','2026-02-20 09:59:43','tempest-VolumesTransfersV355Test-Volume-1363441577',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:59:34','2026-02-20 09:59:35','2026-02-20 09:59:36',1,'cf391c27-b7cf-4cd9-a897-7993a73afac7',NULL,'c359eaee59074888af5d3306b57c5ed6','2cd3436ad8a1427598e20bbea13ed671','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:59:34','2026-02-20 09:59:34','2026-02-20 09:59:35','tempest-VolumesMetadataTest-Volume-33214583',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:56:45','2026-02-20 09:56:47','2026-02-20 09:56:47',1,'cfcb2206-e455-4e13-8193-88b3a803b9f3',NULL,'05feeb2aee824362a8103784cc43648d','fd2fac9a2a1a4fd49d87e5d4ff1b64b3','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:56:45','2026-02-20 09:56:45',NULL,'tempest-volume-823631834',NULL,NULL,NULL,NULL,'91e655c2-f217-4612-bc71-3497021f6790',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'2f6a6216-769a-49fd-82ac-de23d1290eb2','2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:55:14','2026-02-20 09:55:19','2026-02-20 09:55:19',1,'d1517577-a2ea-4ea7-b84a-d089c1148465',NULL,'ffbb979ff9fb4e37a3cdbc9384522ee4','dcc08d5e298941e3a9de201aa565b6a9','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:55:14','2026-02-20 09:55:14',NULL,'tempest-volume-94300017',NULL,NULL,NULL,NULL,'211da78d-0ac0-446b-b9cb-70aa203883c3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'523fd1fa-8d01-419d-ba3b-b8e73a667c29','2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:58:16','2026-02-20 09:58:18','2026-02-20 09:58:18',1,'d5953ac9-b9d2-4cb7-91ad-c17001776c05',NULL,'26c178031b9b453ca3b66e309e6bd2a8','b39170cd6b2b43fa90080079febc7f43','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:58:16','2026-02-20 09:58:16','2026-02-20 09:58:18','tempest-VolumeQuotasNegativeTestJSON-Volume-1976403466',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:57:10','2026-02-20 09:57:16','2026-02-20 09:57:16',1,'db266298-fc55-41e4-a772-93601f135714',NULL,'3c6a99f7be8048329c5edc3d04bf3c7d','43a8c5592dc64c5a935d4d8b5fb44ad8','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:57:10','2026-02-20 09:57:10','2026-02-20 09:57:16','tempest-VolumesGetTest-Volume-1804951286',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:57:06','2026-02-20 09:57:08','2026-02-20 09:57:08',1,'dca503c8-d0a1-4e75-9672-374bedccdcd9',NULL,'3c6a99f7be8048329c5edc3d04bf3c7d','43a8c5592dc64c5a935d4d8b5fb44ad8','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:57:07','2026-02-20 09:57:07','2026-02-20 09:57:08','tempest-VolumesGetTest-Volume-1906720051',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:54:43','2026-02-20 09:54:53','2026-02-20 09:54:53',1,'e2a80799-fe57-4b63-8df7-e93ba7c73145',NULL,'ffbb979ff9fb4e37a3cdbc9384522ee4','dcc08d5e298941e3a9de201aa565b6a9','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:54:43','2026-02-20 09:54:43',NULL,'tempest-volume-1996209311',NULL,NULL,NULL,NULL,'b0ad793f-edef-47f4-a688-78153e5d36ea',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'72ffb4ea-d9e9-4d05-8e08-0868a8a71a9e','2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:56:55','2026-02-20 09:57:00','2026-02-20 09:57:00',1,'e3744499-b21f-479b-b87f-ebbc6875fc6c',NULL,'cfd8fd24bbb54adf8f682266baa12b35','63c8b3e7b8b445b68b501883951607d3','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:56:55','2026-02-20 09:56:56','2026-02-20 09:57:00','tempest-VolumesCloneTest-Volume-1966515951',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:58:01','2026-02-20 09:58:02','2026-02-20 09:58:03',1,'e4a6c243-4ff0-4d57-a640-f3b1c549741b',NULL,'b7563d8cd4d142b89354d656cfd05add','0507ba67b65244e7a826c6949689a381','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:58:01','2026-02-20 09:58:01','2026-02-20 09:58:02','tempest-AbsoluteLimitsTests-Volume-1700302370',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:57:24','2026-02-20 09:57:26','2026-02-20 09:57:26',1,'e5480d25-a8e2-443b-a1e0-e5c6ff0aac14',NULL,'3c6a99f7be8048329c5edc3d04bf3c7d','43a8c5592dc64c5a935d4d8b5fb44ad8','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:57:25','2026-02-20 09:57:25','2026-02-20 09:57:26','tempest-VolumesGetTest-Volume-1863073169',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:57:17','2026-02-20 09:57:27','2026-02-20 09:57:27',1,'e5649d73-d362-4467-a638-9d93425f0e41',NULL,'3c6a99f7be8048329c5edc3d04bf3c7d','43a8c5592dc64c5a935d4d8b5fb44ad8','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:57:18','2026-02-20 09:57:23','2026-02-20 09:57:27','tempest-VolumesGetTest-new-Volume-2145576049','This is the new description of volume',NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:57:30','2026-02-20 09:57:35','2026-02-20 09:57:36',1,'f0918f8b-df1a-4352-9e10-0df4cafc6419',NULL,'64bc298504924a43b95ce2758bfa5477','a48d774a595542e4a66f14036bc080ce','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:57:31','2026-02-20 09:57:31',NULL,'tempest-volume-1701247332',NULL,NULL,NULL,NULL,'d29ddbab-68de-4b71-aa71-4b968f18ee1d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'f34fe2ac-c196-40f5-a2ae-230b5a9a0e69','2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:58:20','2026-02-20 09:58:22','2026-02-20 09:58:22',1,'f4436184-e49f-4049-bb69-f3da1d188a44',NULL,'c95f42a86dd348a68ea4d21f5679364c','d0e47cd34a784cbb89cbe56eafed5650','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:58:20','2026-02-20 09:58:21','2026-02-20 09:58:22','tempest-VolumesActionsTest-Volume-1303926858',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:55:45','2026-02-20 09:55:54','2026-02-20 09:55:55',1,'f6a2ba0c-d775-4bf9-b3f6-c42ecd4f66b1',NULL,'7a847498e34a4755829111fb54b0632b','f1d88f620ed14a4da04788bf096bb225','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2026-02-20 09:55:45','2026-02-20 09:55:53','2026-02-20 09:55:54','tempest-VolumesImageMetadata-Volume-922192949',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1),('2026-02-20 09:56:56','2026-02-20 09:56:59','2026-02-20 09:56:59',1,'fb2064a3-8911-407b-81a2-41e849d19188',NULL,'cfd8fd24bbb54adf8f682266baa12b35','63c8b3e7b8b445b68b501883951607d3','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2026-02-20 09:56:57','2026-02-20 09:56:58','2026-02-20 09:56:59','tempest-VolumesCloneTest-Volume-465887364',NULL,NULL,NULL,NULL,'b7c23f21-5442-473d-b3ab-ffcaecfb2e5d','e3744499-b21f-479b-b87f-ebbc6875fc6c',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2e3e135d-366a-49aa-93ab-286fe2733587',0,1);
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=161 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2026-02-20 08:05:42','2026-02-20 08:05:42.000123',NULL,0,2,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (2,'43eca6d8-1b99-4300-a417-76015fcc59e1','rbd://a8557ee9-b55d-5519-942c-cf8f6172f1d8/images/43eca6d8-1b99-4300-a417-76015fcc59e1/snap','2026-02-20 08:22:26','2026-02-20 08:22:26',NULL,0,'{\"store\": \"default_backend\"}','active'),(5,'06bd71fd-c415-45d9-b669-46209b7ca2f4','rbd://a8557ee9-b55d-5519-942c-cf8f6172f1d8/images/06bd71fd-c415-45d9-b669-46209b7ca2f4/snap','2026-02-20 09:49:59','2026-02-20 09:49:59',NULL,0,'{\"store\": \"default_backend\"}','active'),(6,'1f433eb2-73b2-4e72-b378-409a8e786723','rbd://a8557ee9-b55d-5519-942c-cf8f6172f1d8/images/1f433eb2-73b2-4e72-b378-409a8e786723/snap','2026-02-20 09:50:01','2026-02-20 09:50:01',NULL,0,'{\"store\": \"default_backend\"}','active'),(7,'8725d688-b65c-4963-9a48-b777102b1ae4','rbd://a8557ee9-b55d-5519-942c-cf8f6172f1d8/images/8725d688-b65c-4963-9a48-b777102b1ae4/snap','2026-02-20 09:51:15','2026-02-20 09:51:21','2026-02-20 09:51:21',1,'{\"store\": \"default_backend\"}','deleted'),(8,'dada1057-f48f-427f-9e19-8ae0a27ed3e8','rbd://a8557ee9-b55d-5519-942c-cf8f6172f1d8/images/dada1057-f48f-427f-9e19-8ae0a27ed3e8/snap','2026-02-20 09:51:22','2026-02-20 09:51:33','2026-02-20 09:51:33',1,'{\"store\": \"default_backend\"}','deleted'),(9,'81e74b19-c5d0-4ea0-a92a-7a4da4aefaee','rbd://a8557ee9-b55d-5519-942c-cf8f6172f1d8/images/81e74b19-c5d0-4ea0-a92a-7a4da4aefaee/snap','2026-02-20 09:51:25','2026-02-20 09:51:31','2026-02-20 09:51:31',1,'{\"store\": \"default_backend\"}','deleted'),(10,'ee866e72-ca41-417c-b19c-1225b839037e','rbd://a8557ee9-b55d-5519-942c-cf8f6172f1d8/images/ee866e72-ca41-417c-b19c-1225b839037e/snap','2026-02-20 09:51:27','2026-02-20 09:51:29','2026-02-20 09:51:29',1,'{\"store\": \"default_backend\"}','deleted'),(11,'2ca20fba-0573-4823-861d-917510483c1a','rbd://a8557ee9-b55d-5519-942c-cf8f6172f1d8/images/2ca20fba-0573-4823-861d-917510483c1a/snap','2026-02-20 09:51:53','2026-02-20 09:52:05','2026-02-20 09:52:05',1,'{\"store\": \"default_backend\"}','deleted'),(12,'0514dd80-1184-4a06-9952-33c8efc7858f','rbd://a8557ee9-b55d-5519-942c-cf8f6172f1d8/images/0514dd80-1184-4a06-9952-33c8efc7858f/snap','2026-02-20 09:52:45','2026-02-20 09:52:47','2026-02-20 09:52:47',1,'{\"store\": \"default_backend\"}','deleted'),(13,'89196198-213f-4707-9812-6792c7d067bd','rbd://a8557ee9-b55d-5519-942c-cf8f6172f1d8/images/89196198-213f-4707-9812-6792c7d067bd/snap','2026-02-20 09:53:48','2026-02-20 09:53:58','2026-02-20 09:53:58',1,'{\"store\": \"default_backend\"}','deleted'),(14,'a2608ad0-4e88-4c27-ae87-1698cecac71c','rbd://a8557ee9-b55d-5519-942c-cf8f6172f1d8/images/a2608ad0-4e88-4c27-ae87-1698cecac71c/snap','2026-02-20 09:53:55','2026-02-20 09:53:57','2026-02-20 09:53:57',1,'{\"store\": \"default_backend\"}','deleted'),(15,'fb9d5455-3f05-491c-84ee-c7d611bc6ed1','rbd://a8557ee9-b55d-5519-942c-cf8f6172f1d8/images/fb9d5455-3f05-491c-84ee-c7d611bc6ed1/snap','2026-02-20 09:54:07','2026-02-20 09:54:09','2026-02-20 09:54:09',1,'{\"store\": \"default_backend\"}','deleted'),(16,'5b7bdd13-6f70-4816-80bf-095fbba622a5','rbd://a8557ee9-b55d-5519-942c-cf8f6172f1d8/images/5b7bdd13-6f70-4816-80bf-095fbba622a5/snap','2026-02-20 09:54:25','2026-02-20 09:54:39','2026-02-20 09:54:39',1,'{\"store\": \"default_backend\"}','deleted'),(17,'6318d9a0-945f-4163-8954-d3f704b093e6','rbd://a8557ee9-b55d-5519-942c-cf8f6172f1d8/images/6318d9a0-945f-4163-8954-d3f704b093e6/snap','2026-02-20 09:54:27','2026-02-20 09:54:37','2026-02-20 09:54:37',1,'{\"store\": \"default_backend\"}','deleted'),(18,'dd75af07-760b-48ba-8484-2aa55f369c8a','rbd://a8557ee9-b55d-5519-942c-cf8f6172f1d8/images/dd75af07-760b-48ba-8484-2aa55f369c8a/snap','2026-02-20 09:54:28','2026-02-20 09:54:36','2026-02-20 09:54:36',1,'{\"store\": \"default_backend\"}','deleted'),(19,'734d0d1d-6d98-42b3-aa72-f22b269d3670','rbd://a8557ee9-b55d-5519-942c-cf8f6172f1d8/images/734d0d1d-6d98-42b3-aa72-f22b269d3670/snap','2026-02-20 09:54:29','2026-02-20 09:54:35','2026-02-20 09:54:35',1,'{\"store\": \"default_backend\"}','deleted'),(20,'ec4eac00-e755-4849-aed9-44af6a993e38','rbd://a8557ee9-b55d-5519-942c-cf8f6172f1d8/images/ec4eac00-e755-4849-aed9-44af6a993e38/snap','2026-02-20 09:54:30','2026-02-20 09:54:34','2026-02-20 09:54:34',1,'{\"store\": \"default_backend\"}','deleted'),(21,'bd766cea-aba9-4268-9547-f6e34fd59d32','rbd://a8557ee9-b55d-5519-942c-cf8f6172f1d8/images/bd766cea-aba9-4268-9547-f6e34fd59d32/snap','2026-02-20 09:54:31','2026-02-20 09:54:33','2026-02-20 09:54:33',1,'{\"store\": \"default_backend\"}','deleted'),(22,'38fbf9d9-f608-4744-adbe-8693b7ad18f8','rbd://a8557ee9-b55d-5519-942c-cf8f6172f1d8/images/38fbf9d9-f608-4744-adbe-8693b7ad18f8/snap','2026-02-20 09:54:32','2026-02-20 09:54:34','2026-02-20 09:54:34',1,'{\"store\": \"default_backend\"}','deleted'),(23,'5ff167cf-4203-4431-b2ab-bdde9724a46f','rbd://a8557ee9-b55d-5519-942c-cf8f6172f1d8/images/5ff167cf-4203-4431-b2ab-bdde9724a46f/snap','2026-02-20 09:54:36','2026-02-20 09:54:38','2026-02-20 09:54:38',1,'{\"store\": \"default_backend\"}','deleted'),(24,'7f471756-4ac2-42f1-b4b0-16b47efea049','rbd://a8557ee9-b55d-5519-942c-cf8f6172f1d8/images/7f471756-4ac2-42f1-b4b0-16b47efea049/snap','2026-02-20 09:59:35','2026-02-20 09:59:38','2026-02-20 09:59:38',1,'{\"store\": \"default_backend\"}','deleted'),(25,'64be4a0d-a6dd-41f8-8600-65189750e087','rbd://a8557ee9-b55d-5519-942c-cf8f6172f1d8/images/64be4a0d-a6dd-41f8-8600-65189750e087/snap','2026-02-20 10:04:36','2026-02-20 10:04:37','2026-02-20 10:04:37',1,'{\"store\": \"default_backend\"}','deleted');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
INSERT INTO `image_members` (`id`, `image_id`, `member`, `can_share`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`) VALUES (1,'4b2018f8-fc26-4e31-a632-c03932db03b3','77452cde52964970833d13336153edc3',0,'2026-02-20 09:51:36','2026-02-20 09:51:36','2026-02-20 09:51:36',1,'pending'),(2,'ef207260-a049-4784-9113-68ff25e0d50d','77452cde52964970833d13336153edc3',0,'2026-02-20 09:51:36','2026-02-20 09:51:36','2026-02-20 09:51:36',1,'pending'),(3,'6b5f1e26-ac77-406a-842b-94cfe4793268','fdd67a0b1d79454a888f737b76fddcc6',0,'2026-02-20 09:54:03','2026-02-20 09:54:04','2026-02-20 09:54:04',1,'accepted'),(4,'4270cf6a-efb7-4eb1-9b85-2b615cf3ff96','fdd67a0b1d79454a888f737b76fddcc6',0,'2026-02-20 09:54:04','2026-02-20 09:54:04','2026-02-20 09:54:04',1,'accepted'),(5,'6a0bae25-a318-4c26-afae-932fafee2d4a','fdd67a0b1d79454a888f737b76fddcc6',0,'2026-02-20 09:54:04','2026-02-20 09:54:04','2026-02-20 09:54:04',1,'rejected'),(6,'468aaf39-3b4c-4ec7-a08c-d4b058941e27','fdd67a0b1d79454a888f737b76fddcc6',0,'2026-02-20 09:54:04','2026-02-20 09:54:04','2026-02-20 09:54:04',1,'accepted'),(7,'fb9d5455-3f05-491c-84ee-c7d611bc6ed1','7e33240811a14e919f954b4b6ca73f12',0,'2026-02-20 09:54:07','2026-02-20 09:54:09','2026-02-20 09:54:09',1,'pending');
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (2,'43eca6d8-1b99-4300-a417-76015fcc59e1','owner_specified.openstack.md5','','2026-02-20 08:22:21','2026-02-20 08:22:21',NULL,0),(5,'43eca6d8-1b99-4300-a417-76015fcc59e1','owner_specified.openstack.sha256','','2026-02-20 08:22:21','2026-02-20 08:22:21',NULL,0),(8,'43eca6d8-1b99-4300-a417-76015fcc59e1','owner_specified.openstack.object','images/cirros','2026-02-20 08:22:21','2026-02-20 08:22:21',NULL,0),(11,'06bd71fd-c415-45d9-b669-46209b7ca2f4','hw_rng_model','virtio','2026-02-20 09:49:57','2026-02-20 09:49:57',NULL,0),(12,'1f433eb2-73b2-4e72-b378-409a8e786723','hw_rng_model','virtio','2026-02-20 09:50:00','2026-02-20 09:50:00',NULL,0),(13,'dada1057-f48f-427f-9e19-8ae0a27ed3e8','hw_rng_model','virtio','2026-02-20 09:51:04','2026-02-20 09:51:33','2026-02-20 09:51:33',1),(14,'dada1057-f48f-427f-9e19-8ae0a27ed3e8','base_image_ref','06bd71fd-c415-45d9-b669-46209b7ca2f4','2026-02-20 09:51:04','2026-02-20 09:51:33','2026-02-20 09:51:33',1),(15,'dada1057-f48f-427f-9e19-8ae0a27ed3e8','owner_user_name','tempest-UnshelveToHostMultiNodesTest-1217794180-project-member','2026-02-20 09:51:04','2026-02-20 09:51:33','2026-02-20 09:51:33',1),(16,'dada1057-f48f-427f-9e19-8ae0a27ed3e8','owner_project_name','tempest-UnshelveToHostMultiNodesTest-1217794180','2026-02-20 09:51:04','2026-02-20 09:51:33','2026-02-20 09:51:33',1),(17,'dada1057-f48f-427f-9e19-8ae0a27ed3e8','boot_roles','member,reader','2026-02-20 09:51:04','2026-02-20 09:51:33','2026-02-20 09:51:33',1),(18,'dada1057-f48f-427f-9e19-8ae0a27ed3e8','hw_machine_type','q35','2026-02-20 09:51:04','2026-02-20 09:51:33','2026-02-20 09:51:33',1),(19,'dada1057-f48f-427f-9e19-8ae0a27ed3e8','hw_cdrom_bus','sata','2026-02-20 09:51:04','2026-02-20 09:51:33','2026-02-20 09:51:33',1),(20,'dada1057-f48f-427f-9e19-8ae0a27ed3e8','hw_disk_bus','virtio','2026-02-20 09:51:04','2026-02-20 09:51:33','2026-02-20 09:51:33',1),(21,'dada1057-f48f-427f-9e19-8ae0a27ed3e8','hw_input_bus','usb','2026-02-20 09:51:04','2026-02-20 09:51:33','2026-02-20 09:51:33',1),(22,'dada1057-f48f-427f-9e19-8ae0a27ed3e8','hw_pointer_model','usbtablet','2026-02-20 09:51:04','2026-02-20 09:51:33','2026-02-20 09:51:33',1),(23,'dada1057-f48f-427f-9e19-8ae0a27ed3e8','hw_video_model','virtio','2026-02-20 09:51:04','2026-02-20 09:51:33','2026-02-20 09:51:33',1),(24,'dada1057-f48f-427f-9e19-8ae0a27ed3e8','hw_vif_model','virtio','2026-02-20 09:51:04','2026-02-20 09:51:33','2026-02-20 09:51:33',1),(25,'dada1057-f48f-427f-9e19-8ae0a27ed3e8','instance_uuid','43720f70-168d-461a-8b52-ba71de6033a0','2026-02-20 09:51:04','2026-02-20 09:51:33','2026-02-20 09:51:33',1),(26,'dada1057-f48f-427f-9e19-8ae0a27ed3e8','user_id','65489f8d7cbf42a2960f2d764c16b3f2','2026-02-20 09:51:04','2026-02-20 09:51:33','2026-02-20 09:51:33',1),(27,'dada1057-f48f-427f-9e19-8ae0a27ed3e8','image_type','snapshot','2026-02-20 09:51:04','2026-02-20 09:51:33','2026-02-20 09:51:33',1),(28,'8725d688-b65c-4963-9a48-b777102b1ae4','os_version','alt1','2026-02-20 09:51:16','2026-02-20 09:51:21','2026-02-20 09:51:21',1),(29,'8725d688-b65c-4963-9a48-b777102b1ae4','os_distro','value2','2026-02-20 09:51:16','2026-02-20 09:51:21','2026-02-20 09:51:21',1),(30,'8725d688-b65c-4963-9a48-b777102b1ae4','architecture','value3','2026-02-20 09:51:17','2026-02-20 09:51:21','2026-02-20 09:51:21',1),(31,'dada1057-f48f-427f-9e19-8ae0a27ed3e8','image_location','snapshot','2026-02-20 09:51:21','2026-02-20 09:51:33','2026-02-20 09:51:33',1),(32,'dada1057-f48f-427f-9e19-8ae0a27ed3e8','image_state','available','2026-02-20 09:51:21','2026-02-20 09:51:33','2026-02-20 09:51:33',1),(33,'dada1057-f48f-427f-9e19-8ae0a27ed3e8','owner_id','ff4cacca21b64031adfd6cb25f7e62fc','2026-02-20 09:51:21','2026-02-20 09:51:33','2026-02-20 09:51:33',1),(34,'ee866e72-ca41-417c-b19c-1225b839037e','ramdisk_id','00000000-1111-2222-3333-444455556666','2026-02-20 09:51:26','2026-02-20 09:51:29','2026-02-20 09:51:29',1),(35,'2ca20fba-0573-4823-861d-917510483c1a','hw_rng_model','virtio','2026-02-20 09:51:35','2026-02-20 09:52:05','2026-02-20 09:52:05',1),(36,'2ca20fba-0573-4823-861d-917510483c1a','base_image_ref','06bd71fd-c415-45d9-b669-46209b7ca2f4','2026-02-20 09:51:35','2026-02-20 09:52:05','2026-02-20 09:52:05',1),(37,'2ca20fba-0573-4823-861d-917510483c1a','owner_user_name','tempest-UnshelveToHostMultiNodesTest-1217794180-project-member','2026-02-20 09:51:35','2026-02-20 09:52:05','2026-02-20 09:52:05',1),(38,'2ca20fba-0573-4823-861d-917510483c1a','owner_project_name','tempest-UnshelveToHostMultiNodesTest-1217794180','2026-02-20 09:51:35','2026-02-20 09:52:05','2026-02-20 09:52:05',1),(39,'2ca20fba-0573-4823-861d-917510483c1a','boot_roles','member,reader','2026-02-20 09:51:35','2026-02-20 09:52:05','2026-02-20 09:52:05',1),(40,'2ca20fba-0573-4823-861d-917510483c1a','hw_machine_type','q35','2026-02-20 09:51:35','2026-02-20 09:52:05','2026-02-20 09:52:05',1),(41,'2ca20fba-0573-4823-861d-917510483c1a','hw_cdrom_bus','sata','2026-02-20 09:51:35','2026-02-20 09:52:05','2026-02-20 09:52:05',1),(42,'2ca20fba-0573-4823-861d-917510483c1a','hw_disk_bus','virtio','2026-02-20 09:51:35','2026-02-20 09:52:05','2026-02-20 09:52:05',1),(43,'2ca20fba-0573-4823-861d-917510483c1a','hw_input_bus','usb','2026-02-20 09:51:35','2026-02-20 09:52:05','2026-02-20 09:52:05',1),(44,'2ca20fba-0573-4823-861d-917510483c1a','hw_pointer_model','usbtablet','2026-02-20 09:51:35','2026-02-20 09:52:05','2026-02-20 09:52:05',1),(45,'2ca20fba-0573-4823-861d-917510483c1a','hw_video_model','virtio','2026-02-20 09:51:35','2026-02-20 09:52:05','2026-02-20 09:52:05',1),(46,'2ca20fba-0573-4823-861d-917510483c1a','hw_vif_model','virtio','2026-02-20 09:51:35','2026-02-20 09:52:05','2026-02-20 09:52:05',1),(47,'2ca20fba-0573-4823-861d-917510483c1a','clean_attempts','1','2026-02-20 09:51:35','2026-02-20 09:52:05','2026-02-20 09:52:05',1),(48,'2ca20fba-0573-4823-861d-917510483c1a','instance_uuid','43720f70-168d-461a-8b52-ba71de6033a0','2026-02-20 09:51:35','2026-02-20 09:52:05','2026-02-20 09:52:05',1),(49,'2ca20fba-0573-4823-861d-917510483c1a','user_id','65489f8d7cbf42a2960f2d764c16b3f2','2026-02-20 09:51:35','2026-02-20 09:52:05','2026-02-20 09:52:05',1),(50,'2ca20fba-0573-4823-861d-917510483c1a','image_type','snapshot','2026-02-20 09:51:35','2026-02-20 09:52:05','2026-02-20 09:52:05',1),(51,'2ca20fba-0573-4823-861d-917510483c1a','image_location','snapshot','2026-02-20 09:51:53','2026-02-20 09:52:05','2026-02-20 09:52:05',1),(52,'2ca20fba-0573-4823-861d-917510483c1a','image_state','available','2026-02-20 09:51:53','2026-02-20 09:52:05','2026-02-20 09:52:05',1),(53,'2ca20fba-0573-4823-861d-917510483c1a','owner_id','ff4cacca21b64031adfd6cb25f7e62fc','2026-02-20 09:51:53','2026-02-20 09:52:05','2026-02-20 09:52:05',1),(54,'89196198-213f-4707-9812-6792c7d067bd','ramdisk_id','00000000-1111-2222-3333-444455556666','2026-02-20 09:53:46','2026-02-20 09:53:58','2026-02-20 09:53:58',1),(55,'89196198-213f-4707-9812-6792c7d067bd','os_glance_stage_host','http://glance-default-external-api-0.glance-default-external-api.openstack.svc:9292','2026-02-20 09:53:46','2026-02-20 09:53:58','2026-02-20 09:53:58',1),(57,'89196198-213f-4707-9812-6792c7d067bd','os_glance_importing_to_stores','','2026-02-20 09:53:46','2026-02-20 09:53:58','2026-02-20 09:53:58',1),(58,'89196198-213f-4707-9812-6792c7d067bd','os_glance_failed_import','','2026-02-20 09:53:46','2026-02-20 09:53:58','2026-02-20 09:53:58',1),(59,'a2608ad0-4e88-4c27-ae87-1698cecac71c','ramdisk_id','00000000-1111-2222-3333-444455556666','2026-02-20 09:53:48','2026-02-20 09:53:57','2026-02-20 09:53:57',1),(61,'a2608ad0-4e88-4c27-ae87-1698cecac71c','os_glance_importing_to_stores','','2026-02-20 09:53:49','2026-02-20 09:53:57','2026-02-20 09:53:57',1),(62,'a2608ad0-4e88-4c27-ae87-1698cecac71c','os_glance_failed_import','','2026-02-20 09:53:49','2026-02-20 09:53:57','2026-02-20 09:53:57',1),(64,'b2f689b1-dda5-4f0c-af9d-f7e22e7b53bd','os_glance_importing_to_stores','','2026-02-20 09:54:17','2026-02-20 09:54:17',NULL,0),(65,'b2f689b1-dda5-4f0c-af9d-f7e22e7b53bd','os_glance_failed_import','default_backend','2026-02-20 09:54:17','2026-02-20 09:54:17',NULL,0);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
INSERT INTO `image_tags` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'5b7bdd13-6f70-4816-80bf-095fbba622a5','tempest-tag-1911019239','2026-02-20 09:54:24','2026-02-20 09:54:39','2026-02-20 09:54:39',1),(2,'5b7bdd13-6f70-4816-80bf-095fbba622a5','tempest-tag-1220479377','2026-02-20 09:54:24','2026-02-20 09:54:39','2026-02-20 09:54:39',1),(3,'6318d9a0-945f-4163-8954-d3f704b093e6','tempest-tag-1226688909','2026-02-20 09:54:26','2026-02-20 09:54:37','2026-02-20 09:54:37',1),(4,'6318d9a0-945f-4163-8954-d3f704b093e6','tempest-tag-593924275','2026-02-20 09:54:26','2026-02-20 09:54:37','2026-02-20 09:54:37',1),(5,'dd75af07-760b-48ba-8484-2aa55f369c8a','tempest-tag-667028985','2026-02-20 09:54:27','2026-02-20 09:54:36','2026-02-20 09:54:36',1),(6,'dd75af07-760b-48ba-8484-2aa55f369c8a','tempest-tag-2113236091','2026-02-20 09:54:27','2026-02-20 09:54:36','2026-02-20 09:54:36',1),(7,'734d0d1d-6d98-42b3-aa72-f22b269d3670','tempest-tag-207227587','2026-02-20 09:54:28','2026-02-20 09:54:35','2026-02-20 09:54:35',1),(8,'734d0d1d-6d98-42b3-aa72-f22b269d3670','tempest-tag-140843776','2026-02-20 09:54:28','2026-02-20 09:54:35','2026-02-20 09:54:35',1),(9,'ec4eac00-e755-4849-aed9-44af6a993e38','tempest-tag-1512850527','2026-02-20 09:54:29','2026-02-20 09:54:34','2026-02-20 09:54:34',1),(10,'ec4eac00-e755-4849-aed9-44af6a993e38','tempest-tag-1464902825','2026-02-20 09:54:29','2026-02-20 09:54:34','2026-02-20 09:54:34',1),(11,'bd766cea-aba9-4268-9547-f6e34fd59d32','tempest-tag-69047752','2026-02-20 09:54:30','2026-02-20 09:54:33','2026-02-20 09:54:33',1),(12,'bd766cea-aba9-4268-9547-f6e34fd59d32','tempest-tag-564924662','2026-02-20 09:54:30','2026-02-20 09:54:33','2026-02-20 09:54:33',1),(13,'6fc18547-3c25-48b9-bd0d-128fa13e7ff0','tempest-tag-870357301','2026-02-20 09:54:41','2026-02-20 09:54:41','2026-02-20 09:54:41',1);
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1)),
  CONSTRAINT `CONSTRAINT_4` CHECK (`os_hidden` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('04fcd86c-c81f-4a82-8944-3253952a71ea','tempest-test-1256422833',NULL,'deleted','2026-02-20 09:53:12','2026-02-20 09:53:12','2026-02-20 09:53:12',1,'raw','bare',NULL,'520c55cc26b941f4ad3deacc72bb90cb',0,0,0,NULL,'shared',0,NULL,NULL),('0514dd80-1184-4a06-9952-33c8efc7858f','tempest-image-976822466',3571,'deleted','2026-02-20 09:52:44','2026-02-20 09:52:47','2026-02-20 09:52:47',1,'qcow2','bare','0b5aad52af9eb35627b6156d742d2db9','f1ed1eea11544164a9873856ff8d5e2d',0,129,0,NULL,'private',0,'sha512','b0b2172213e6398eb2c21a905a8184ddb8f12a53f760fe625dac9e83288929278311081efbe897fd6f6998c1838606d9f251a228d8ebef3e559eb8f423376f07'),('06bd71fd-c415-45d9-b669-46209b7ca2f4','cirros-0.6.2-x86_64-disk.img',21430272,'active','2026-02-20 09:49:57','2026-02-20 09:49:59',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','91bce661d685472eb3e7cacab17bf52a',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('1e7e638b-e813-438d-99bd-d4efc8f421e9','tempest-test-1178623007',NULL,'deleted','2026-02-20 09:53:13','2026-02-20 09:53:13','2026-02-20 09:53:13',1,'raw','bare',NULL,'520c55cc26b941f4ad3deacc72bb90cb',0,0,0,NULL,'shared',0,NULL,NULL),('1f433eb2-73b2-4e72-b378-409a8e786723','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2026-02-20 09:50:00','2026-02-20 09:50:01',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','91bce661d685472eb3e7cacab17bf52a',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('2ca20fba-0573-4823-861d-917510483c1a','tempest-UnshelveToHostMultiNodesTest-server-1846377785-shelved',1073741824,'deleted','2026-02-20 09:51:35','2026-02-20 09:52:05','2026-02-20 09:52:05',1,'raw','bare',NULL,'ff4cacca21b64031adfd6cb25f7e62fc',1,0,0,NULL,'private',0,NULL,NULL),('38fbf9d9-f608-4744-adbe-8693b7ad18f8','tempest-VolumesNegativeTest-image-1918912096',1024,'deleted','2026-02-20 09:54:30','2026-02-20 09:54:34','2026-02-20 09:54:34',1,'qcow2','bare','140b8900cdeebb68260add57f129885b','416b8c7a0c6f48629bf55e44152bc962',2,0,0,NULL,'private',0,'sha512','83d8b8a925562288e7e590d7368380224269a70273b5c9e7de6916cddbdae23950070d3af32f2da41747c1c4306a275048942cadc037ba51cbc4aa999e114a71'),('4270cf6a-efb7-4eb1-9b85-2b615cf3ff96','tempest-ImagesMemberTest-image-2047925364',NULL,'deleted','2026-02-20 09:54:04','2026-02-20 09:54:04','2026-02-20 09:54:04',1,'raw','bare',NULL,'129e8b98540540668ea2525cd085cff9',0,0,0,NULL,'shared',0,NULL,NULL),('43eca6d8-1b99-4300-a417-76015fcc59e1','cirros',21692416,'active','2026-02-20 08:22:21','2026-02-20 08:22:26',NULL,0,'qcow2','bare','87617e24a5e30cb3b87fda8c0764838f','91bce661d685472eb3e7cacab17bf52a',0,0,0,117440512,'shared',0,'sha512','9a9bce0083a00939ec17c11febbfc767aa211aaa54f51e75c5a8b271a9b5637c77205a518b7a2007cb391d23cceb01e0e4e8d64832317151bc85b734b92a7be0'),('468aaf39-3b4c-4ec7-a08c-d4b058941e27','tempest-ImagesMemberTest-image-618364193',NULL,'deleted','2026-02-20 09:54:04','2026-02-20 09:54:05','2026-02-20 09:54:05',1,'raw','bare',NULL,'129e8b98540540668ea2525cd085cff9',0,0,0,NULL,'shared',0,NULL,NULL),('4b2018f8-fc26-4e31-a632-c03932db03b3','tempest-ImagesMemberNegativeTest-image-1472237117',NULL,'deleted','2026-02-20 09:51:36','2026-02-20 09:51:36','2026-02-20 09:51:36',1,'raw','bare',NULL,'f32955854d11445f8581df64e022a40e',0,0,0,NULL,'shared',0,NULL,NULL),('54016b79-89fc-45bd-b832-49390398bf00',NULL,NULL,'deleted','2026-02-20 09:51:19','2026-02-20 09:51:20','2026-02-20 09:51:20',1,'raw','bare',NULL,'65592bb0ebe149c1a48ca933c247588b',0,0,0,NULL,'shared',0,NULL,NULL),('5b7bdd13-6f70-4816-80bf-095fbba622a5','tempest-ListUserImagesTest-image-864274613',3843,'deleted','2026-02-20 09:54:24','2026-02-20 09:54:39','2026-02-20 09:54:39',1,'qcow2','bare','5b764be66939e30ab1c56566e220dd89','7dd67ad2515b4bc0afe4284dcef8c0e4',0,0,0,NULL,'private',0,'sha512','a9a760c040ccef7fe93068db1d139e5c4ed63298f2f85a9838c4fac1c78cdc2a960272040153c5dbd0c4656a6ab2dce86b8354c89c95c5299a37928e3cf22d99'),('5ff167cf-4203-4431-b2ab-bdde9724a46f','tempest-VolumesNegativeTest-image-303687897',1024,'deleted','2026-02-20 09:54:34','2026-02-20 09:54:38','2026-02-20 09:54:38',1,'qcow2','bare','1b67a361ac30c90223896e89d806d6d0','416b8c7a0c6f48629bf55e44152bc962',2,0,0,NULL,'private',0,'sha512','f2060c0d214855b255ec3a9d8b4fc0f9ced6072b093999c30d9c5ebdf7f69467f694d81d76e7781dc6a4bc3a88593c43563d6c836de47cce526885fec0229d22'),('6292313e-06db-4ada-9e9b-38925fe927f9',NULL,NULL,'deleted','2026-02-20 09:54:31','2026-02-20 09:54:31','2026-02-20 09:54:31',1,NULL,NULL,NULL,'7dd67ad2515b4bc0afe4284dcef8c0e4',0,0,0,NULL,'shared',1,NULL,NULL),('6318d9a0-945f-4163-8954-d3f704b093e6','tempest-ListUserImagesTest-image-1997591493',3397,'deleted','2026-02-20 09:54:26','2026-02-20 09:54:37','2026-02-20 09:54:37',1,'raw','bare','10100d2e4d5c16cddb40ec77f679d028','7dd67ad2515b4bc0afe4284dcef8c0e4',0,0,0,3397,'private',0,'sha512','265843fdc56896933442db4163b982665b2c93d8ca5c70efc827d0147b4b1cd206cdaffa33ce9979a9fcf57050a9da8d6eef043ac462dcb5893432314945c397'),('64be4a0d-a6dd-41f8-8600-65189750e087','tempest-scenario-img--1459863519',21430272,'deleted','2026-02-20 10:04:33','2026-02-20 10:04:37','2026-02-20 10:04:37',1,'qcow2','bare','c8fc807773e5354afe61636071771906','50ba22298b9844c2b9853d9ca1060aa4',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('6a0bae25-a318-4c26-afae-932fafee2d4a','tempest-ImagesMemberTest-image-339196461',NULL,'deleted','2026-02-20 09:54:04','2026-02-20 09:54:04','2026-02-20 09:54:04',1,'raw','bare',NULL,'129e8b98540540668ea2525cd085cff9',0,0,0,NULL,'shared',0,NULL,NULL),('6b5f1e26-ac77-406a-842b-94cfe4793268','tempest-ImagesMemberTest-image-1181379581',NULL,'deleted','2026-02-20 09:54:03','2026-02-20 09:54:04','2026-02-20 09:54:04',1,'raw','bare',NULL,'129e8b98540540668ea2525cd085cff9',0,0,0,NULL,'shared',0,NULL,NULL),('6edf8f42-06a6-4721-9cd3-40dafde5d8c0','tempest-task_image-352629708',NULL,'deleted','2026-02-20 09:54:17','2026-02-20 09:54:17','2026-02-20 09:54:17',1,'qcow2','bare',NULL,NULL,0,0,0,NULL,'public',0,NULL,NULL),('6fc18547-3c25-48b9-bd0d-128fa13e7ff0','tempest-ImagesTagsTest-image-1849117785',NULL,'deleted','2026-02-20 09:54:41','2026-02-20 09:54:41','2026-02-20 09:54:41',1,'raw','bare',NULL,'273cdd5fae3944c4aebe32b9b69f3c60',0,0,0,NULL,'private',0,NULL,NULL),('734d0d1d-6d98-42b3-aa72-f22b269d3670','tempest-ListUserImagesTest-image-517662117',1801,'deleted','2026-02-20 09:54:28','2026-02-20 09:54:35','2026-02-20 09:54:35',1,'ari','bare','3c2e4c07195399cb032982a2572de799','7dd67ad2515b4bc0afe4284dcef8c0e4',0,0,0,NULL,'private',0,'sha512','dcb924c300003d6740ecfba81a35efdb2c3e1a61e3e0ada0c0b939cd19adc6af36ea6258961d12d17c29ea3a8590f0dc60ae418e0482c2cdb36bfe040d3ed4ef'),('7f471756-4ac2-42f1-b4b0-16b47efea049','tempest-VolumesActionsTest-Image-1582228392',1073741824,'deleted','2026-02-20 09:58:45','2026-02-20 09:59:38','2026-02-20 09:59:38',1,'raw','bare','cd573cfaace07e7949bc0c46028904ff','68573218a6b141beb49fbacc5b306c7d',0,0,0,1073741824,'shared',0,'sha512','c5041ae163cf0f65600acfe7f6a63f212101687d41a57a4e18ffd2a07a452cd8175b8f5a4868dd2330bfe5ae123f18216bdbc9e0f80d131e64b94913a7b40bb5'),('7f8bda41-a7ee-4fca-843b-ae970d192155','tempest-BasicOperationsImagesAdminTest-Image-1144773481',NULL,'deleted','2026-02-20 09:51:20','2026-02-20 09:51:20','2026-02-20 09:51:20',1,'raw','bare',NULL,'99e77dfaf73942b9bd536f91b66ac74d',0,0,0,NULL,'public',0,NULL,NULL),('80ad8133-ce9d-4c21-a021-68f55d31deb6','tempest-test-1719754579',NULL,'deleted','2026-02-20 09:53:12','2026-02-20 09:53:13','2026-02-20 09:53:13',1,NULL,NULL,NULL,'520c55cc26b941f4ad3deacc72bb90cb',0,0,0,NULL,'shared',0,NULL,NULL),('81e74b19-c5d0-4ea0-a92a-7a4da4aefaee','tempest-image-1994706008',1024,'deleted','2026-02-20 09:51:25','2026-02-20 09:51:31','2026-02-20 09:51:31',1,'raw','bare','c9e0ae48158fe51907a4c087fc02931d','90846ea45b3b46d1bbd1e70306c8d790',0,0,0,1024,'private',0,'sha512','a7e080228ca4edf101a9b3ecc72ea093e3225980382070989eb8ea70a90117f7acaf4f2aab260f2318d5ee3a90d7c8eb89ad197f4798d7c7d75a918db8b56bd7'),('8725d688-b65c-4963-9a48-b777102b1ae4','tempest-image-1279180894',1024,'deleted','2026-02-20 09:51:14','2026-02-20 09:51:21','2026-02-20 09:51:21',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','9584c3165f644712b9f56aff1f9c5faf',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('89196198-213f-4707-9812-6792c7d067bd','tempest-image-1935188677',1024,'deleted','2026-02-20 09:53:46','2026-02-20 09:53:58','2026-02-20 09:53:58',1,'raw','bare','79d15d32caa6e0e6b6d6556e8a6efeb5','261998e921914cfaa49fda849e67ebcd',0,0,0,1024,'private',0,'sha512','21488969ef91a70c36529fc5763b42eedff92c654ae7896c7f4f70f6425390f6b8d6f287336ac24b4f9dee39c10391f07929101646f3e567e725bd62059f6187'),('a2608ad0-4e88-4c27-ae87-1698cecac71c','tempest-image-2145134443',117440512,'deleted','2026-02-20 09:53:48','2026-02-20 09:53:57','2026-02-20 09:53:57',1,'raw','bare','4245576e3df99ea1211871b8b9514d3b','261998e921914cfaa49fda849e67ebcd',0,0,0,117440512,'private',0,'sha512','dbb480bdc4f13ead7e00b62766df2815ddc8d4775af8a82ec40f8afd433d4cb95a109a58fbe7e0a661be86e0a06321c00362bc881f58c61c40bd2d1486954594'),('b2f689b1-dda5-4f0c-af9d-f7e22e7b53bd','tempest-test-327045280',NULL,'queued','2026-02-20 09:54:17','2026-02-20 09:54:17',NULL,0,'raw','bare',NULL,'5f45e6e5d5074c16a3ea381aae82ad05',0,0,0,NULL,'shared',0,NULL,NULL),('bd766cea-aba9-4268-9547-f6e34fd59d32','tempest-ListUserImagesTest-image-630955771',2671,'deleted','2026-02-20 09:54:30','2026-02-20 09:54:33','2026-02-20 09:54:33',1,'vhd','bare','67e4749513f083014319e4b669ae7d31','7dd67ad2515b4bc0afe4284dcef8c0e4',0,0,0,NULL,'private',0,'sha512','1b5cf713a5b27f67a506dd9a7d46a11b63ce4ffa26d2a915d751f6bd8922aff96546bae25f0c1547d0f0fe6b7ee852b0e6319eac0c3ea6689e9333613b3fa037'),('c1755e08-59d1-4099-aa39-4dcb1a4e1f4d','tempest-ListUserImagesTest-image-749038492',NULL,'deleted','2026-02-20 09:54:31','2026-02-20 09:54:32','2026-02-20 09:54:32',1,NULL,NULL,NULL,'7dd67ad2515b4bc0afe4284dcef8c0e4',0,0,0,NULL,'shared',1,NULL,NULL),('cc4e6f76-1a4c-4a1a-8ec9-9edde595b476','tempest-new-image-844675344',NULL,'deleted','2026-02-20 09:51:28','2026-02-20 09:51:28','2026-02-20 09:51:28',1,'qcow2','bare',NULL,'90846ea45b3b46d1bbd1e70306c8d790',0,0,0,NULL,'private',0,NULL,NULL),('dada1057-f48f-427f-9e19-8ae0a27ed3e8','tempest-UnshelveToHostMultiNodesTest-server-1846377785-shelved',1073741824,'deleted','2026-02-20 09:51:04','2026-02-20 09:51:33','2026-02-20 09:51:33',1,'raw','bare',NULL,'ff4cacca21b64031adfd6cb25f7e62fc',1,0,0,NULL,'private',0,NULL,NULL),('dd75af07-760b-48ba-8484-2aa55f369c8a','tempest-ListUserImagesTest-image-1512333336',2717,'deleted','2026-02-20 09:54:27','2026-02-20 09:54:36','2026-02-20 09:54:36',1,'ami','bare','0fc0db8597683c83fc7f67a539487130','7dd67ad2515b4bc0afe4284dcef8c0e4',0,0,0,NULL,'private',0,'sha512','f7d0c1f8ab8dc37e715f6925ccb9b580899c2cba44debd522c6e44de313a01928c57a018574ac5438194ab6e066a3127c29e901972f24350f02f1651c67c2f77'),('ec4eac00-e755-4849-aed9-44af6a993e38','tempest-ListUserImagesTest-image-1313548337',3824,'deleted','2026-02-20 09:54:29','2026-02-20 09:54:34','2026-02-20 09:54:34',1,'aki','bare','c5b52e9c2adfbdffd211a764268ff6b6','7dd67ad2515b4bc0afe4284dcef8c0e4',0,0,0,NULL,'private',0,'sha512','eeeb467d84ee71d6ee6903a3237cc3ddfc11e440f2dab62e830a1a7ff892b5dd04f882fdf11a8eb8698cac0201aef2d28988cdf489edad93a0ee0903de0ce77e'),('ee866e72-ca41-417c-b19c-1225b839037e','tempest-image-319190916',1024,'deleted','2026-02-20 09:51:26','2026-02-20 09:51:29','2026-02-20 09:51:29',1,'qcow2','bare','4006ab544dc8b92ebec614526210801f','90846ea45b3b46d1bbd1e70306c8d790',0,0,0,NULL,'private',0,'sha512','39b6f7a91a99791730693c8229157b71f08feb7ea20a5899697939a4c2c26627db6f87468a1b7516bc6fedd8211d7c6bedb5873cfcbb990a043103ce96f44209'),('ef207260-a049-4784-9113-68ff25e0d50d','tempest-ImagesMemberNegativeTest-image-1129024115',NULL,'deleted','2026-02-20 09:51:36','2026-02-20 09:51:36','2026-02-20 09:51:36',1,'raw','bare',NULL,'f32955854d11445f8581df64e022a40e',0,0,0,NULL,'shared',0,NULL,NULL),('f0af1d26-4e54-4899-be27-c993a12498a1','tempest-image-994460738',NULL,'deleted','2026-02-20 09:51:26','2026-02-20 09:51:26','2026-02-20 09:51:26',1,'qcow2','bare',NULL,'90846ea45b3b46d1bbd1e70306c8d790',0,0,0,NULL,'private',0,NULL,NULL),('f7758fea-5596-4815-a26d-dd84bd3231e4',NULL,NULL,'deleted','2026-02-20 09:51:20','2026-02-20 09:51:20','2026-02-20 09:51:20',1,'raw','bare',NULL,'ae2d511071c74cb8b19e68ec81970a58',0,0,0,NULL,'shared',0,NULL,NULL),('fb9d5455-3f05-491c-84ee-c7d611bc6ed1','tempest-ListSharedImagesTest-image-577482330',2048,'deleted','2026-02-20 09:54:03','2026-02-20 09:54:09','2026-02-20 09:54:09',1,'qcow2','bare','0caf86612c4d5816cb102c7d350422d1','608a5f1732c041cf96804145f5615041',0,0,0,NULL,'shared',0,'sha512','3245567355a34d36bfec7e49afcab1ad1f26f086f4f75c5a29e1a287861a3e21759ab79ac4e41638319a7c9f07247e2136ef1f3dbe868acce3e971eae32060cc'),('fe2c8692-19b5-4463-b0a6-482d6dc94c0e','tempest-ImagesTagsNegativeTest-image-305934882',NULL,'deleted','2026-02-20 09:53:18','2026-02-20 09:53:18','2026-02-20 09:53:18',1,'raw','bare',NULL,'6fb46337a98045f28d6f0ad918c6aa76',0,0,0,NULL,'private',0,NULL,NULL);
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (2,2,'image','CIM_PASD_','2026-02-20 08:05:45',NULL),(2,5,'image','CIM_RASD_','2026-02-20 08:05:45',NULL),(2,8,NULL,'CIM_SASD_','2026-02-20 08:05:45',NULL),(2,23,'image','hw_','2026-02-20 08:05:46',NULL),(2,26,'image','hw_','2026-02-20 08:05:46',NULL),(2,38,'image',NULL,'2026-02-20 08:05:47',NULL),(2,53,'image','hw_','2026-02-20 08:05:49',NULL),(2,65,'image','hw_','2026-02-20 08:05:51',NULL),(2,77,'image',NULL,'2026-02-20 08:05:52',NULL),(2,80,'image',NULL,'2026-02-20 08:05:52',NULL),(2,83,'image',NULL,'2026-02-20 08:05:53',NULL),(2,86,'image',NULL,'2026-02-20 08:05:53',NULL),(5,2,NULL,'CIM_PASD_','2026-02-20 08:05:45',NULL),(5,23,NULL,'hw_','2026-02-20 08:05:46',NULL),(5,26,NULL,'hw_','2026-02-20 08:05:46',NULL),(5,29,NULL,NULL,'2026-02-20 08:05:46',NULL),(5,35,NULL,NULL,'2026-02-20 08:05:47',NULL),(5,38,NULL,NULL,'2026-02-20 08:05:47',NULL),(5,41,NULL,NULL,'2026-02-20 08:05:48',NULL),(5,44,NULL,'hw_','2026-02-20 08:05:49',NULL),(5,53,NULL,'hw_','2026-02-20 08:05:49',NULL),(5,62,NULL,NULL,'2026-02-20 08:05:50',NULL),(5,65,NULL,'hw_','2026-02-20 08:05:51',NULL),(5,68,NULL,NULL,'2026-02-20 08:05:51',NULL),(5,74,NULL,NULL,'2026-02-20 08:05:51',NULL),(5,77,NULL,NULL,'2026-02-20 08:05:52',NULL),(5,80,NULL,NULL,'2026-02-20 08:05:52',NULL),(5,83,NULL,NULL,'2026-02-20 08:05:53',NULL),(5,86,NULL,NULL,'2026-02-20 08:05:53',NULL),(5,89,NULL,'cinder_','2026-02-20 08:05:54',NULL),(5,92,NULL,'hw_','2026-02-20 08:43:17',NULL),(5,93,NULL,'hw_','2026-02-20 08:43:17',NULL),(5,94,NULL,'traits:','2026-02-20 08:43:17',NULL),(8,2,NULL,'CIM_PASD_','2026-02-20 08:05:45',NULL),(8,5,NULL,'CIM_RASD_','2026-02-20 08:05:45',NULL),(8,8,NULL,'CIM_SASD_','2026-02-20 08:05:45',NULL),(8,11,NULL,'CIM_VSSD_','2026-02-20 08:05:45',NULL),(8,14,NULL,NULL,'2026-02-20 08:05:46',NULL),(8,17,NULL,NULL,'2026-02-20 08:05:46',NULL),(8,20,NULL,NULL,'2026-02-20 08:05:46',NULL),(8,32,NULL,'aggregate_instance_extra_specs:','2026-02-20 08:05:47',NULL),(11,2,NULL,'CIM_PASD_','2026-02-20 08:05:45',NULL),(11,5,NULL,'CIM_RASD_','2026-02-20 08:05:45',NULL),(11,8,NULL,'CIM_SASD_','2026-02-20 08:05:45',NULL),(11,11,NULL,'CIM_VSSD_','2026-02-20 08:05:45',NULL),(11,23,NULL,'hw:','2026-02-20 08:05:46',NULL),(11,26,NULL,'hw:','2026-02-20 08:05:46',NULL),(11,32,NULL,'capabilities:','2026-02-20 08:05:47',NULL),(11,44,NULL,'hw:','2026-02-20 08:05:49',NULL),(11,47,NULL,NULL,'2026-02-20 08:05:49',NULL),(11,50,NULL,NULL,'2026-02-20 08:05:49',NULL),(11,53,NULL,'hw:','2026-02-20 08:05:50',NULL),(11,56,NULL,NULL,'2026-02-20 08:05:50',NULL),(11,59,NULL,NULL,'2026-02-20 08:05:50',NULL),(11,65,NULL,'hw:','2026-02-20 08:05:51',NULL),(11,92,NULL,'hw:','2026-02-20 08:43:17',NULL),(11,93,NULL,'hw:','2026-02-20 08:43:17',NULL),(11,94,NULL,'traits:','2026-02-20 08:43:17',NULL),(14,2,'scheduler_hints',NULL,'2026-02-20 08:05:45',NULL),(14,80,'metadata',NULL,'2026-02-20 08:05:52',NULL),(14,83,'metadata',NULL,'2026-02-20 08:05:53',NULL),(14,86,'metadata',NULL,'2026-02-20 08:05:53',NULL),(17,80,NULL,NULL,'2026-02-20 08:05:52',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=103 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (2,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2026-02-20 08:05:44',NULL),(5,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2026-02-20 08:05:45',NULL),(8,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2026-02-20 08:05:45',NULL),(11,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2026-02-20 08:05:45',NULL),(14,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2026-02-20 08:05:46',NULL),(17,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2026-02-20 08:05:46',NULL),(20,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2026-02-20 08:05:46',NULL),(23,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2026-02-20 08:05:46',NULL),(26,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2026-02-20 08:05:46',NULL),(29,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2026-02-20 08:05:46',NULL),(32,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2026-02-20 08:05:47',NULL),(35,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2026-02-20 08:05:47',NULL),(38,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2026-02-20 08:05:47',NULL),(41,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-02-20 08:05:48',NULL),(44,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-02-20 08:05:49',NULL),(47,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-02-20 08:05:49',NULL),(50,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2026-02-20 08:05:49',NULL),(53,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2026-02-20 08:05:49',NULL),(56,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-02-20 08:05:50',NULL),(59,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-02-20 08:05:50',NULL),(62,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-02-20 08:05:50',NULL),(65,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-02-20 08:05:51',NULL),(68,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-02-20 08:05:51',NULL),(71,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2026-02-20 08:05:51',NULL),(74,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2026-02-20 08:05:51',NULL),(77,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2026-02-20 08:05:52',NULL),(80,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2026-02-20 08:05:52',NULL),(83,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2026-02-20 08:05:53',NULL),(86,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2026-02-20 08:05:53',NULL),(89,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2026-02-20 08:05:54',NULL),(92,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2026-02-20 08:43:17',NULL),(93,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2026-02-20 08:43:17',NULL),(94,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2026-02-20 08:43:17',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (2,47,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2026-02-20 08:05:49',NULL),(5,47,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2026-02-20 08:05:49',NULL),(8,47,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2026-02-20 08:05:49',NULL),(11,80,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2026-02-20 08:05:52',NULL),(14,80,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2026-02-20 08:05:52',NULL),(17,80,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2026-02-20 08:05:52',NULL),(20,80,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2026-02-20 08:05:52',NULL),(23,80,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-02-20 08:05:52',NULL),(26,80,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-02-20 08:05:52',NULL),(29,80,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2026-02-20 08:05:52',NULL),(32,80,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2026-02-20 08:05:53',NULL),(35,80,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-02-20 08:05:53',NULL),(38,80,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2026-02-20 08:05:53',NULL),(41,80,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2026-02-20 08:05:53',NULL),(44,80,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2026-02-20 08:05:53',NULL),(47,83,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2026-02-20 08:05:53',NULL),(50,83,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2026-02-20 08:05:53',NULL),(53,83,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2026-02-20 08:05:53',NULL),(56,83,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2026-02-20 08:05:53',NULL),(59,83,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2026-02-20 08:05:53',NULL),(62,86,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-02-20 08:05:53',NULL),(65,86,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-02-20 08:05:54',NULL),(68,86,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-02-20 08:05:54',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=388 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (2,2,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2026-02-20 08:05:45',NULL),(5,2,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2026-02-20 08:05:45',NULL),(8,2,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2026-02-20 08:05:45',NULL),(11,5,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(14,5,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(17,5,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(20,5,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2026-02-20 08:05:45',NULL),(23,5,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2026-02-20 08:05:45',NULL),(26,5,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2026-02-20 08:05:45',NULL),(29,5,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(32,5,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2026-02-20 08:05:45',NULL),(35,5,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(38,5,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(41,5,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(44,5,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(47,5,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(50,5,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2026-02-20 08:05:45',NULL),(53,5,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(56,5,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(59,5,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(62,5,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(65,5,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(68,8,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2026-02-20 08:05:45',NULL),(71,8,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(74,8,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2026-02-20 08:05:45',NULL),(77,8,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2026-02-20 08:05:45',NULL),(80,8,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(83,8,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(86,8,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(89,8,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(92,8,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(95,8,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(98,8,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(101,8,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(104,8,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(107,11,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2026-02-20 08:05:45',NULL),(110,11,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2026-02-20 08:05:45',NULL),(113,11,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2026-02-20 08:05:45',NULL),(116,11,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(119,11,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(122,11,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(125,11,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(128,11,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(131,11,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2026-02-20 08:05:45',NULL),(134,11,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2026-02-20 08:05:46',NULL),(137,11,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2026-02-20 08:05:46',NULL),(140,11,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2026-02-20 08:05:46',NULL),(143,11,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2026-02-20 08:05:46',NULL),(146,11,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2026-02-20 08:05:46',NULL),(149,11,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2026-02-20 08:05:46',NULL),(152,11,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2026-02-20 08:05:46',NULL),(155,11,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2026-02-20 08:05:46',NULL),(158,14,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2026-02-20 08:05:46',NULL),(161,17,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2026-02-20 08:05:46',NULL),(164,20,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2026-02-20 08:05:46',NULL),(167,23,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2026-02-20 08:05:46',NULL),(170,23,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2026-02-20 08:05:46',NULL),(173,26,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2026-02-20 08:05:46',NULL),(176,29,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2026-02-20 08:05:47',NULL),(179,32,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2026-02-20 08:05:47',NULL),(182,32,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2026-02-20 08:05:47',NULL),(185,32,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2026-02-20 08:05:47',NULL),(188,32,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-02-20 08:05:47',NULL),(191,32,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-02-20 08:05:47',NULL),(194,32,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-02-20 08:05:47',NULL),(197,32,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2026-02-20 08:05:47',NULL),(200,35,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2026-02-20 08:05:47',NULL),(203,35,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2026-02-20 08:05:47',NULL),(206,38,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2026-02-20 08:05:47',NULL),(209,38,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-02-20 08:05:48',NULL),(212,41,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2026-02-20 08:05:48',NULL),(215,41,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2026-02-20 08:05:48',NULL),(218,41,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2026-02-20 08:05:48',NULL),(221,41,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2026-02-20 08:05:48',NULL),(224,41,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2026-02-20 08:05:48',NULL),(227,41,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2026-02-20 08:05:48',NULL),(230,41,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\"]}','2026-02-20 08:05:48',NULL),(233,41,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2026-02-20 08:05:48',NULL),(236,41,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2026-02-20 08:05:48',NULL),(239,41,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2026-02-20 08:05:48',NULL),(242,41,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, and virtio. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\"]}','2026-02-20 08:05:48',NULL),(245,41,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-02-20 08:05:48',NULL),(248,41,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-02-20 08:05:48',NULL),(251,41,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-02-20 08:05:48',NULL),(254,41,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2026-02-20 08:05:48',NULL),(257,41,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-02-20 08:05:48',NULL),(260,44,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2026-02-20 08:05:49',NULL),(263,44,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-02-20 08:05:49',NULL),(266,44,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-02-20 08:05:49',NULL),(269,50,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2026-02-20 08:05:49',NULL),(272,50,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2026-02-20 08:05:49',NULL),(275,50,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2026-02-20 08:05:49',NULL),(278,53,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2026-02-20 08:05:50',NULL),(281,53,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2026-02-20 08:05:50',NULL),(284,53,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2026-02-20 08:05:50',NULL),(287,53,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2026-02-20 08:05:50',NULL),(290,53,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2026-02-20 08:05:50',NULL),(293,53,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2026-02-20 08:05:50',NULL),(296,56,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2026-02-20 08:05:50',NULL),(299,56,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2026-02-20 08:05:50',NULL),(302,59,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2026-02-20 08:05:50',NULL),(305,59,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2026-02-20 08:05:50',NULL),(308,62,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2026-02-20 08:05:50',NULL),(311,62,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2026-02-20 08:05:50',NULL),(314,62,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2026-02-20 08:05:50',NULL),(317,62,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2026-02-20 08:05:50',NULL),(320,62,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, VirtualSriovEthernetCard, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualSriovEthernetCard\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2026-02-20 08:05:51',NULL),(323,62,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-02-20 08:05:51',NULL),(326,65,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2026-02-20 08:05:51',NULL),(329,68,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2026-02-20 08:05:51',NULL),(332,71,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2026-02-20 08:05:51',NULL),(335,71,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2026-02-20 08:05:51',NULL),(338,71,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2026-02-20 08:05:51',NULL),(341,71,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2026-02-20 08:05:51',NULL),(344,71,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2026-02-20 08:05:51',NULL),(347,71,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2026-02-20 08:05:51',NULL),(350,71,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2026-02-20 08:05:51',NULL),(353,71,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2026-02-20 08:05:51',NULL),(356,71,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2026-02-20 08:05:51',NULL),(359,74,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2026-02-20 08:05:51',NULL),(362,74,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2026-02-20 08:05:51',NULL),(365,74,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2026-02-20 08:05:52',NULL),(368,74,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2026-02-20 08:05:52',NULL),(371,77,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2026-02-20 08:05:52',NULL),(374,77,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2026-02-20 08:05:52',NULL),(377,77,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2026-02-20 08:05:52',NULL),(380,89,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2026-02-20 08:05:54',NULL),(383,92,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2026-02-20 08:43:17',NULL),(384,93,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2026-02-20 08:43:17',NULL),(385,94,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2026-02-20 08:43:17',NULL),(386,94,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2026-02-20 08:43:17',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (2,'OS::Cinder::Volume',1,'2026-02-20 08:05:44',NULL),(5,'OS::Glance::Image',1,'2026-02-20 08:05:45',NULL),(8,'OS::Nova::Aggregate',1,'2026-02-20 08:05:45',NULL),(11,'OS::Nova::Flavor',1,'2026-02-20 08:05:45',NULL),(14,'OS::Nova::Server',1,'2026-02-20 08:05:45',NULL),(17,'OS::Trove::Instance',1,'2026-02-20 08:05:52',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('Glance Migrations','/usr/lib/python3.9/site-packages/glance/db/sqlalchemy/migrate_repo',0);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
INSERT INTO `task_info` (`task_id`, `input`, `result`, `message`) VALUES ('089e8ad2-deb4-4eb4-989a-9adef0ed5ef7','{\"image_id\": \"a2608ad0-4e88-4c27-ae87-1698cecac71c\", \"import_req\": {\"method\": {\"name\": \"web-download\", \"uri\": \"https://download.cirros-cloud.net/0.6.2/cirros-0.6.2-x86_64-disk.img\"}, \"all_stores\": true}, \"backend\": [\"default_backend\"]}','{\"image_id\": \"a2608ad0-4e88-4c27-ae87-1698cecac71c\"}','Copied 112 MiB'),('0aa66e68-c555-4797-b460-0c2f7fad0b5a','{\"image_properties\": {\"container_format\": \"bare\", \"disk_format\": \"qcow2\", \"visibility\": \"public\", \"name\": \"tempest-task_image-352629708\"}, \"import_from_format\": \"qcow2\", \"import_from\": \"http://tempest-dummy-img-file-291126791.qcow2\"}',NULL,'Task failed due to Internal Error'),('35a47309-b816-448e-81a5-ef40d468c575','{\"image_id\": \"89196198-213f-4707-9812-6792c7d067bd\", \"import_req\": {\"method\": {\"name\": \"glance-direct\"}, \"all_stores\": true}, \"backend\": [\"default_backend\"]}','{\"image_id\": \"89196198-213f-4707-9812-6792c7d067bd\"}','Copied 0 MiB'),('e0efb29d-f03c-4ca1-8633-a81c9d52ca81','{\"image_id\": \"b2f689b1-dda5-4f0c-af9d-f7e22e7b53bd\", \"import_req\": {\"method\": {\"name\": \"web-download\", \"uri\": \"http://does-not.exist/no/possible/way\"}, \"stores\": [\"default_backend\"]}, \"backend\": [\"default_backend\"]}',NULL,'Task failed due to Internal Error');
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
INSERT INTO `tasks` (`id`, `type`, `status`, `owner`, `expires_at`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `image_id`, `request_id`, `user_id`) VALUES ('089e8ad2-deb4-4eb4-989a-9adef0ed5ef7','api_image_import','success','261998e921914cfaa49fda849e67ebcd','2026-02-22 09:53:55','2026-02-20 09:53:48','2026-02-20 09:53:55',NULL,0,'a2608ad0-4e88-4c27-ae87-1698cecac71c','req-27ba9bc4-3271-406a-a043-792679f30a6e','f2c5aba2dfe440adaa0f56831a998120'),('0aa66e68-c555-4797-b460-0c2f7fad0b5a','import','failure','5a6121127b5746ef881da8079ed570e3','2026-02-22 09:54:17','2026-02-20 09:54:17','2026-02-20 09:54:17',NULL,0,NULL,'req-9db416db-4c3c-443e-b77b-e2588453923c','fe01e3377b31438abb8e561123221791'),('35a47309-b816-448e-81a5-ef40d468c575','api_image_import','success','261998e921914cfaa49fda849e67ebcd','2026-02-22 09:53:48','2026-02-20 09:53:46','2026-02-20 09:53:48',NULL,0,'89196198-213f-4707-9812-6792c7d067bd','req-2715fc3b-fcd2-49f1-bea6-d7d5e4644389','f2c5aba2dfe440adaa0f56831a998120'),('e0efb29d-f03c-4ca1-8633-a81c9d52ca81','api_image_import','failure','5f45e6e5d5074c16a3ea381aae82ad05','2026-02-22 09:54:17','2026-02-20 09:54:17','2026-02-20 09:54:17',NULL,0,'b2f689b1-dda5-4f0c-af9d-f7e22e7b53bd','req-5a5ca2e0-6f43-473b-9be2-ec346511173c','9e30418a34374b23a3edd1340c14ec42');
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `heat`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `heat` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `heat`;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `resource_action` varchar(255) DEFAULT NULL,
  `resource_status` varchar(255) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `physical_resource_id` varchar(255) DEFAULT NULL,
  `resource_status_reason` varchar(255) DEFAULT NULL,
  `resource_type` varchar(255) DEFAULT NULL,
  `resource_properties` blob DEFAULT NULL,
  `rsrc_prop_data_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `stack_id` (`stack_id`),
  KEY `ev_rsrc_prop_data_ref` (`rsrc_prop_data_id`),
  CONSTRAINT `ev_rsrc_prop_data_ref` FOREIGN KEY (`rsrc_prop_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `event_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `event`
--

LOCK TABLES `event` WRITE;
/*!40000 ALTER TABLE `event` DISABLE KEYS */;
/*!40000 ALTER TABLE `event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('heat','/usr/lib/python3.9/site-packages/heat/db/sqlalchemy/migrate_repo',86);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raw_template`
--

DROP TABLE IF EXISTS `raw_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `raw_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `template` longtext DEFAULT NULL,
  `files` longtext DEFAULT NULL,
  `environment` longtext DEFAULT NULL,
  `files_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_tmpl_files_fkey_ref` (`files_id`),
  CONSTRAINT `raw_tmpl_files_fkey_ref` FOREIGN KEY (`files_id`) REFERENCES `raw_template_files` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raw_template`
--

LOCK TABLES `raw_template` WRITE;
/*!40000 ALTER TABLE `raw_template` DISABLE KEYS */;
/*!40000 ALTER TABLE `raw_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raw_template_files`
--

DROP TABLE IF EXISTS `raw_template_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `raw_template_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `files` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raw_template_files`
--

LOCK TABLES `raw_template_files` WRITE;
/*!40000 ALTER TABLE `raw_template_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `raw_template_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource`
--

DROP TABLE IF EXISTS `resource`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `nova_instance` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  `rsrc_metadata` longtext DEFAULT NULL,
  `properties_data` longtext DEFAULT NULL,
  `engine_id` varchar(36) DEFAULT NULL,
  `atomic_key` int(11) DEFAULT NULL,
  `needed_by` longtext DEFAULT NULL,
  `requires` longtext DEFAULT NULL,
  `replaces` int(11) DEFAULT NULL,
  `replaced_by` int(11) DEFAULT NULL,
  `current_template_id` int(11) DEFAULT NULL,
  `properties_data_encrypted` tinyint(1) DEFAULT NULL,
  `root_stack_id` varchar(36) DEFAULT NULL,
  `rsrc_prop_data_id` int(11) DEFAULT NULL,
  `attr_data_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `stack_id` (`stack_id`),
  KEY `current_template_id` (`current_template_id`),
  KEY `ix_resource_root_stack_id` (`root_stack_id`),
  KEY `rsrc_rsrc_prop_data_ref` (`rsrc_prop_data_id`),
  KEY `rsrc_attr_data_ref` (`attr_data_id`),
  CONSTRAINT `resource_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`),
  CONSTRAINT `resource_ibfk_2` FOREIGN KEY (`current_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `rsrc_attr_data_ref` FOREIGN KEY (`attr_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `rsrc_rsrc_prop_data_ref` FOREIGN KEY (`rsrc_prop_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`properties_data_encrypted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource`
--

LOCK TABLES `resource` WRITE;
/*!40000 ALTER TABLE `resource` DISABLE KEYS */;
/*!40000 ALTER TABLE `resource` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_data`
--

DROP TABLE IF EXISTS `resource_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  `redact` tinyint(1) DEFAULT NULL,
  `decrypt_method` varchar(64) DEFAULT NULL,
  `resource_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_resource_id` (`resource_id`),
  CONSTRAINT `fk_resource_id` FOREIGN KEY (`resource_id`) REFERENCES `resource` (`id`) ON DELETE CASCADE,
  CONSTRAINT `CONSTRAINT_1` CHECK (`redact` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_data`
--

LOCK TABLES `resource_data` WRITE;
/*!40000 ALTER TABLE `resource_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `resource_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_properties_data`
--

DROP TABLE IF EXISTS `resource_properties_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource_properties_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `data` longtext DEFAULT NULL,
  `encrypted` tinyint(1) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`encrypted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_properties_data`
--

LOCK TABLES `resource_properties_data` WRITE;
/*!40000 ALTER TABLE `resource_properties_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `resource_properties_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(36) NOT NULL,
  `engine_id` varchar(36) NOT NULL,
  `host` varchar(255) NOT NULL,
  `hostname` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `topic` varchar(255) NOT NULL,
  `report_interval` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `engine_id`, `host`, `hostname`, `binary`, `topic`, `report_interval`, `created_at`, `updated_at`, `deleted_at`) VALUES ('82433ad4-455a-44a1-a039-124fa801a9cd','071e1252-64a7-4ca4-ab92-98f3bfe1ac1c','np0005625201.localdomain','np0005625201.localdomain','heat-engine','engine',60,'2026-02-20 08:10:31','2026-02-20 08:36:31',NULL),('9e86372b-ef17-4869-8cbd-50072dd35a65','e0c75589-3fb4-4e5c-98ec-6c39f84c8216','heat-engine-68d6fbc7c5-czl7r','heat-engine-68d6fbc7c5-czl7r','heat-engine','engine',60,'2026-02-20 08:51:13','2026-02-20 10:13:14',NULL),('ac4f4759-ed37-430c-ab28-caacdcd7107d','9ae5b948-512e-4b76-8685-48925171e135','heat-engine-68d6fbc7c5-czl7r','heat-engine-68d6fbc7c5-czl7r','heat-engine','engine',60,'2026-02-20 08:51:14','2026-02-20 10:13:14',NULL),('c2d46ff3-0ef4-4e9b-8742-225b81956c04','4d1a9685-1a17-4b35-a2ef-066767690902','np0005625200.localdomain','np0005625200.localdomain','heat-engine','engine',60,'2026-02-20 08:10:29','2026-02-20 08:36:29',NULL),('c6ccade1-15b0-4882-bfd5-e5e25644ad52','694272dc-dadd-4729-b01d-5b6597212738','np0005625199.localdomain','np0005625199.localdomain','heat-engine','engine',60,'2026-02-20 08:10:17','2026-02-20 08:37:17',NULL),('d50c92a4-aab4-4a8e-bc7d-15b47c48a371','1df91442-6c53-4e91-8e4e-1f21c90c858f','heat-engine-68d6fbc7c5-czl7r','heat-engine-68d6fbc7c5-czl7r','heat-engine','engine',60,'2026-02-20 08:51:14','2026-02-20 10:13:14',NULL),('ebf20c9f-a398-47f4-9b97-d027a2ef663d','e2044ec6-8bc0-47a3-9fba-07bc4761fdaf','heat-engine-68d6fbc7c5-czl7r','heat-engine-68d6fbc7c5-czl7r','heat-engine','engine',60,'2026-02-20 08:51:14','2026-02-20 10:13:14',NULL);
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot`
--

DROP TABLE IF EXISTS `snapshot`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot` (
  `id` varchar(36) NOT NULL,
  `stack_id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` varchar(255) DEFAULT NULL,
  `data` longtext DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stack_id` (`stack_id`),
  KEY `ix_snapshot_tenant` (`tenant`),
  CONSTRAINT `snapshot_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot`
--

LOCK TABLES `snapshot` WRITE;
/*!40000 ALTER TABLE `snapshot` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `software_config`
--

DROP TABLE IF EXISTS `software_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `software_config` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `group` varchar(255) DEFAULT NULL,
  `config` longtext DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_software_config_tenant` (`tenant`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `software_config`
--

LOCK TABLES `software_config` WRITE;
/*!40000 ALTER TABLE `software_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `software_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `software_deployment`
--

DROP TABLE IF EXISTS `software_deployment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `software_deployment` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `server_id` varchar(36) NOT NULL,
  `config_id` varchar(36) NOT NULL,
  `input_values` longtext DEFAULT NULL,
  `output_values` longtext DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  `stack_user_project_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `config_id` (`config_id`),
  KEY `ix_software_deployment_server_id` (`server_id`),
  KEY `ix_software_deployment_tenant` (`tenant`),
  KEY `ix_software_deployment_created_at` (`created_at`),
  CONSTRAINT `software_deployment_ibfk_1` FOREIGN KEY (`config_id`) REFERENCES `software_config` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `software_deployment`
--

LOCK TABLES `software_deployment` WRITE;
/*!40000 ALTER TABLE `software_deployment` DISABLE KEYS */;
/*!40000 ALTER TABLE `software_deployment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack`
--

DROP TABLE IF EXISTS `stack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `raw_template_id` int(11) NOT NULL,
  `prev_raw_template_id` int(11) DEFAULT NULL,
  `user_creds_id` int(11) DEFAULT NULL,
  `username` varchar(256) DEFAULT NULL,
  `owner_id` varchar(36) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `timeout` int(11) DEFAULT NULL,
  `tenant` varchar(256) DEFAULT NULL,
  `disable_rollback` tinyint(1) NOT NULL,
  `stack_user_project_id` varchar(64) DEFAULT NULL,
  `backup` tinyint(1) DEFAULT NULL,
  `nested_depth` int(11) DEFAULT NULL,
  `convergence` tinyint(1) DEFAULT NULL,
  `current_traversal` varchar(36) DEFAULT NULL,
  `current_deps` longtext DEFAULT NULL,
  `parent_resource_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_template_id` (`raw_template_id`),
  KEY `prev_raw_template_id` (`prev_raw_template_id`),
  KEY `user_creds_id` (`user_creds_id`),
  KEY `ix_stack_owner_id` (`owner_id`),
  KEY `ix_stack_tenant` (`tenant`(255)),
  KEY `ix_stack_name` (`name`),
  CONSTRAINT `stack_ibfk_1` FOREIGN KEY (`raw_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `stack_ibfk_2` FOREIGN KEY (`prev_raw_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `stack_ibfk_3` FOREIGN KEY (`user_creds_id`) REFERENCES `user_creds` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`disable_rollback` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`backup` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`convergence` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack`
--

LOCK TABLES `stack` WRITE;
/*!40000 ALTER TABLE `stack` DISABLE KEYS */;
/*!40000 ALTER TABLE `stack` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack_lock`
--

DROP TABLE IF EXISTS `stack_lock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack_lock` (
  `stack_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `engine_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`stack_id`),
  CONSTRAINT `stack_lock_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack_lock`
--

LOCK TABLES `stack_lock` WRITE;
/*!40000 ALTER TABLE `stack_lock` DISABLE KEYS */;
/*!40000 ALTER TABLE `stack_lock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack_tag`
--

DROP TABLE IF EXISTS `stack_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `tag` varchar(80) DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stack_id` (`stack_id`),
  CONSTRAINT `stack_tag_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack_tag`
--

LOCK TABLES `stack_tag` WRITE;
/*!40000 ALTER TABLE `stack_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `stack_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_point`
--

DROP TABLE IF EXISTS `sync_point`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sync_point` (
  `entity_id` varchar(36) NOT NULL,
  `traversal_id` varchar(36) NOT NULL,
  `is_update` tinyint(1) NOT NULL,
  `atomic_key` int(11) NOT NULL,
  `stack_id` varchar(36) NOT NULL,
  `input_data` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`traversal_id`,`is_update`),
  KEY `fk_stack_id` (`stack_id`),
  CONSTRAINT `fk_stack_id` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`is_update` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_point`
--

LOCK TABLES `sync_point` WRITE;
/*!40000 ALTER TABLE `sync_point` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_point` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_creds`
--

DROP TABLE IF EXISTS `user_creds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_creds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `username` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `region_name` varchar(255) DEFAULT NULL,
  `decrypt_method` varchar(64) DEFAULT NULL,
  `tenant` varchar(1024) DEFAULT NULL,
  `auth_url` text DEFAULT NULL,
  `tenant_id` varchar(256) DEFAULT NULL,
  `trust_id` varchar(255) DEFAULT NULL,
  `trustor_user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_creds`
--

LOCK TABLES `user_creds` WRITE;
/*!40000 ALTER TABLE `user_creds` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_creds` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `external_id` (`external_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`inherited` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','141ec720081546bb92f7e9338deb8445','264535d5b76c4b86bf9c7436214b5148','cc700751479048f082e85692f6600d0d',0),('UserProject','141ec720081546bb92f7e9338deb8445','91bce661d685472eb3e7cacab17bf52a','cc700751479048f082e85692f6600d0d',0),('UserProject','1aee44201097494db02d5a0ec5e7b270','f6685cdb0ff24cddaeb987c63c89eafb','98378602b46040e0b4664b6f17f91a02',0),('UserProject','1aee44201097494db02d5a0ec5e7b270','f6685cdb0ff24cddaeb987c63c89eafb','cc700751479048f082e85692f6600d0d',0),('UserProject','29fecd7c129b4e79866913417e27923e','f6685cdb0ff24cddaeb987c63c89eafb','cc700751479048f082e85692f6600d0d',0),('UserProject','3b0869df13184a91b920fca8cf2896fa','f6685cdb0ff24cddaeb987c63c89eafb','98378602b46040e0b4664b6f17f91a02',0),('UserProject','3b0869df13184a91b920fca8cf2896fa','f6685cdb0ff24cddaeb987c63c89eafb','cc700751479048f082e85692f6600d0d',0),('UserProject','92a26b03910849b19773f5ef68be1016','f6685cdb0ff24cddaeb987c63c89eafb','98378602b46040e0b4664b6f17f91a02',0),('UserProject','92a26b03910849b19773f5ef68be1016','f6685cdb0ff24cddaeb987c63c89eafb','9b41ffadc4424c549cca081c67f29ac6',0),('UserProject','92a26b03910849b19773f5ef68be1016','f6685cdb0ff24cddaeb987c63c89eafb','cc700751479048f082e85692f6600d0d',0),('UserProject','9332b168e872428cae64128f4c8874e5','264535d5b76c4b86bf9c7436214b5148','644be31e5f394041812bd8167937931a',0),('UserProject','9578855b599e48b3a4d4bbfe4eebca75','f6685cdb0ff24cddaeb987c63c89eafb','98378602b46040e0b4664b6f17f91a02',0),('UserProject','9578855b599e48b3a4d4bbfe4eebca75','f6685cdb0ff24cddaeb987c63c89eafb','cc700751479048f082e85692f6600d0d',0),('UserProject','a732f9eab686436ba0e796c4fb81d8b9','f6685cdb0ff24cddaeb987c63c89eafb','cc700751479048f082e85692f6600d0d',0),('UserProject','b8b513544fa842a6ae344dba14bf31db','f6685cdb0ff24cddaeb987c63c89eafb','98378602b46040e0b4664b6f17f91a02',0),('UserProject','b8b513544fa842a6ae344dba14bf31db','f6685cdb0ff24cddaeb987c63c89eafb','cc700751479048f082e85692f6600d0d',0),('UserProject','c80dae22963f44ba8c18e973063f60e8','f6685cdb0ff24cddaeb987c63c89eafb','98378602b46040e0b4664b6f17f91a02',0),('UserProject','c80dae22963f44ba8c18e973063f60e8','f6685cdb0ff24cddaeb987c63c89eafb','cc700751479048f082e85692f6600d0d',0),('UserProject','c89c61ffa24148588c0da28995456d59','f6685cdb0ff24cddaeb987c63c89eafb','98378602b46040e0b4664b6f17f91a02',0),('UserProject','c89c61ffa24148588c0da28995456d59','f6685cdb0ff24cddaeb987c63c89eafb','cc700751479048f082e85692f6600d0d',0),('UserProject','d3e4f90a6846431f8b13739d28930fe2','f6685cdb0ff24cddaeb987c63c89eafb','98378602b46040e0b4664b6f17f91a02',0),('UserProject','d3e4f90a6846431f8b13739d28930fe2','f6685cdb0ff24cddaeb987c63c89eafb','cc700751479048f082e85692f6600d0d',0),('UserProject','d4446b63864e47aebd18955a38393018','f6685cdb0ff24cddaeb987c63c89eafb','98378602b46040e0b4664b6f17f91a02',0),('UserProject','d4446b63864e47aebd18955a38393018','f6685cdb0ff24cddaeb987c63c89eafb','cc700751479048f082e85692f6600d0d',0),('UserProject','ebe74705f9b941a692221d116f352f52','f6685cdb0ff24cddaeb987c63c89eafb','98378602b46040e0b4664b6f17f91a02',0),('UserProject','ebe74705f9b941a692221d116f352f52','f6685cdb0ff24cddaeb987c63c89eafb','cc700751479048f082e85692f6600d0d',0),('UserProject','ed1cd2326e314ca1836f768c07b469fe','f6685cdb0ff24cddaeb987c63c89eafb','cc700751479048f082e85692f6600d0d',0),('UserProject','ee9eca1990444ff194d64f17b38bb757','f6685cdb0ff24cddaeb987c63c89eafb','cc700751479048f082e85692f6600d0d',0),('UserProject','f971eeeb93204342bb1360dba42c6139','f6685cdb0ff24cddaeb987c63c89eafb','98378602b46040e0b4664b6f17f91a02',0),('UserProject','f971eeeb93204342bb1360dba42c6139','f6685cdb0ff24cddaeb987c63c89eafb','cc700751479048f082e85692f6600d0d',0),('UserDomain','00513770429844a5a4666546246bf8be','56508c3c3c0e4baeab4dc07a84bd9d78','cc700751479048f082e85692f6600d0d',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
INSERT INTO `credential` (`id`, `user_id`, `project_id`, `type`, `extra`, `key_hash`, `encrypted_blob`) VALUES ('5d305ea5c89b499d9721215923cb4eaa','141ec720081546bb92f7e9338deb8445',NULL,'cert','{}','4defc7444f4587038ada1f4d015cd7c2112ffaca','gAAAAABpmBomLaA0Bmda6LHTk-Rq9sMDa-OKK4nDvu4j9M9unjffrD2clf5yNn2HrqEUud44GXFhvEFie3mz51vXgKo6FpCH5A==');
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `service_id` (`service_id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('013959a19c7c41f0a042eb7499914c5e',NULL,'public','6ba10f669677407b906c39c4023af2cf','http://manila-public-openstack.apps-crc.testing/v2','{\"name\": \"manilav2\"}',1,'regionOne'),('112f587141724978b2f922a85b8afca6',NULL,'public','22c723a6716f46f380d77603e40afddc','http://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('414189c33557475fbc7135f5bd9bc016',NULL,'public','fd532baffd844dd38cf34c5c894f000c','http://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('4746a748297246ba9f387da96547cd91',NULL,'internal','6ba10f669677407b906c39c4023af2cf','http://manila-internal.openstack.svc:8786/v2','{\"name\": \"manilav2\"}',1,'regionOne'),('5e644ff89fcf4bf2ac35cae246a541e4',NULL,'internal','29778769d34749e1bd7effe2fb5d54fa','http://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('662f288123b8444f8ee8a2b6fb64ee76',NULL,'public','29778769d34749e1bd7effe2fb5d54fa','http://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('6af5d3599e454144aa2a870f49f2c669',NULL,'public','ac6ee4ccaf3d4e268aa8191643d2dad8','http://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('790b901eae094b079a08e58bea853612',NULL,'internal','c87c6db283e4446083b35f2ce13931d5','http://heat-api-internal.openstack.svc:8004/v1/%(tenant_id)s','{\"name\": \"heat\"}',1,'regionOne'),('7ab38b3e064e411fab1b674d45a7a2bf',NULL,'internal','5bfd6fde3cfa4dbd8b13161ba59dbe04','http://heat-cfnapi-internal.openstack.svc:8000/v1','{\"name\": \"heat-cfn\"}',1,'regionOne'),('811993ca40034836ba1da1f9d6dacaf6',NULL,'public','4d347c59e8ed4632b2d0dd86d4abe201','http://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('82a9cf7f137240998e0a850ac2854dda',NULL,'internal','4d347c59e8ed4632b2d0dd86d4abe201','http://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('851403f3f4744eb886e82585b3f6b99b',NULL,'internal','8d54b02cbb2842ac97d8ce9ac66ba48b','http://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('8b08210e570648759ce906996369adaf',NULL,'public','8d54b02cbb2842ac97d8ce9ac66ba48b','http://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('96e5f3fdf3084599a94331d7e204cc18',NULL,'public','27f292e156e34f9e9cf67b0f9561df2c','http://manila-public-openstack.apps-crc.testing/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne'),('9e9bf5be7d38462498979a66bb681998',NULL,'public','41a5262b7aa9430dba885bb7472378ba','http://aodh-public-openstack.apps-crc.testing','{\"name\": \"aodh\"}',1,'regionOne'),('9f1dd65f86bb4158b333ce9fb87b2a92',NULL,'internal','41a5262b7aa9430dba885bb7472378ba','http://aodh-internal.openstack.svc:8042','{\"name\": \"aodh\"}',1,'regionOne'),('a59e36a001624adfab4b9ad18823c4d5',NULL,'public','5bfd6fde3cfa4dbd8b13161ba59dbe04','http://heat-cfnapi-public-openstack.apps-crc.testing/v1','{\"name\": \"heat-cfn\"}',1,'regionOne'),('b596a74fa9124a12bbcf716a0e4bca70',NULL,'internal','ac6ee4ccaf3d4e268aa8191643d2dad8','http://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('c96d65ee263a4ca3b33c030ecf8d9234',NULL,'internal','fd532baffd844dd38cf34c5c894f000c','http://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('ccefd54ada8842d787fbe53a90b8b585',NULL,'public','de9b5c1b379d4542a41f5596762ebbb4','http://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('d1b159b1696842208a1b7e397e87b8f2',NULL,'public','c87c6db283e4446083b35f2ce13931d5','http://heat-api-public-openstack.apps-crc.testing/v1/%(tenant_id)s','{\"name\": \"heat\"}',1,'regionOne'),('f3ca265e0935434eaf6c6a0c1b512209',NULL,'internal','27f292e156e34f9e9cf67b0f9561df2c','http://manila-internal.openstack.svc:8786/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne'),('fbeac6083a36435794184404960ac9c4',NULL,'internal','de9b5c1b379d4542a41f5596762ebbb4','http://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('feba10d92c6b4fbda2c036932b3ce6c7',NULL,'internal','22c723a6716f46f380d77603e40afddc','http://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `user_id` (`user_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('644be31e5f394041812bd8167937931a','d8aeb0940e1b4d27b13b646b369b8963'),('cc700751479048f082e85692f6600d0d','644be31e5f394041812bd8167937931a');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=644 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (2,'141ec720081546bb92f7e9338deb8445','default','admin',0,NULL),(5,'d3e4f90a6846431f8b13739d28930fe2','default','aodh',0,NULL),(8,'92a26b03910849b19773f5ef68be1016','default','ceilometer',0,NULL),(11,'b8b513544fa842a6ae344dba14bf31db','default','cinder',0,NULL),(14,'f971eeeb93204342bb1360dba42c6139','default','cinderv3',0,NULL),(17,'3b0869df13184a91b920fca8cf2896fa','default','glance',0,NULL),(20,'ee9eca1990444ff194d64f17b38bb757','default','gnocchi',0,NULL),(23,'c89c61ffa24148588c0da28995456d59','default','heat',0,NULL),(26,'00513770429844a5a4666546246bf8be','56508c3c3c0e4baeab4dc07a84bd9d78','heat_stack_domain_admin',0,NULL),(29,'a732f9eab686436ba0e796c4fb81d8b9','default','heat-cfn',0,NULL),(32,'1aee44201097494db02d5a0ec5e7b270','default','manila',0,NULL),(35,'29fecd7c129b4e79866913417e27923e','default','manilav2',0,NULL),(38,'d4446b63864e47aebd18955a38393018','default','neutron',0,NULL),(41,'9578855b599e48b3a4d4bbfe4eebca75','default','nova',0,NULL),(44,'c80dae22963f44ba8c18e973063f60e8','default','placement',0,NULL),(47,'ed1cd2326e314ca1836f768c07b469fe','default','swift',0,NULL),(50,'ebe74705f9b941a692221d116f352f52','default','barbican',0,NULL),(51,'9332b168e872428cae64128f4c8874e5','default','demo_tempestconf',0,NULL),(52,'e70a17af78b94d888060107e0ba7f912','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('keystone','/usr/lib/python3.9/site-packages/keystone/common/sql/migrate_repo',109),('keystone_contract','/usr/lib/python3.9/site-packages/keystone/common/sql/contract_repo',79),('keystone_data_migrate','/usr/lib/python3.9/site-packages/keystone/common/sql/data_migration_repo',79),('keystone_expand','/usr/lib/python3.9/site-packages/keystone/common/sql/expand_repo',79);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=646 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (2,2,'2026-02-20 08:38:56',0,'$2b$12$kdHaRuZh5Ryp9Z0vCq9oZOyh11eEsdsWRJZdLzrINqKjoUuxP2Wkm',1771574773784135,1771576736645335,'2026-02-20 08:06:13'),(5,5,NULL,0,'$2b$12$NS.BYQixaapz/jgIL.ZiUOOyNFwHT0IF8XIx7rcCehmtLnr3ilIey',1771574913404164,NULL,'2026-02-20 08:08:33'),(8,8,NULL,0,'$2b$12$GI.Z9tB/XLuSQxlGimKeXOIoqNMR48Mi.MJdikqjx5dOzeyEl5Q.6',1771574914101362,NULL,'2026-02-20 08:08:34'),(11,11,NULL,0,'$2b$12$XX8HIIJpOE9FffA7LQdoRecUJgQ0tdEb.6SRRnGK.LGO8FlNgTxMS',1771574914392790,NULL,'2026-02-20 08:08:34'),(14,14,NULL,0,'$2b$12$if6O7R/L2kDQ7O/lP3Mp8e2d7JUXa/J9qMAgMA2dsWjo8j7Wipz4e',1771574914731460,NULL,'2026-02-20 08:08:34'),(17,17,NULL,0,'$2b$12$0hmzcBrG2TtR9fh35CjBY.QcVxGnM2Jrv2wnfaK1FsKuRHAK54c9u',1771574915051312,NULL,'2026-02-20 08:08:35'),(20,20,NULL,0,'$2b$12$8rkCh5RgH2J0kIridISnJeoaICCpC4i1APrxmRWBshaZX.n2P44LW',1771574915454914,NULL,'2026-02-20 08:08:35'),(23,23,NULL,0,'$2b$12$rgeobv.Yi4oK5/GOWJJZ7.8/NTW1Bu0mXprt7sS5UaPgvrt2EN06O',1771574915742168,NULL,'2026-02-20 08:08:35'),(26,26,NULL,0,'$2b$12$CL5P9cIe.110IUpC6pgSI.O5qROx.bzw1VqflsHpfgsRoMbV6vomW',1771574916505857,NULL,'2026-02-20 08:08:36'),(29,29,NULL,0,'$2b$12$BeRMhwnoSBIWIkxqbeOHu.v21jsQSEuiZSaIvWcPZMc97zFOQTnAK',1771574916607455,NULL,'2026-02-20 08:08:36'),(32,32,NULL,0,'$2b$12$44ekNOFqfXQOr1.rGY39E.H4E0zY9J0sLEyjx8ucL29AUa37lQGCu',1771574917150998,NULL,'2026-02-20 08:08:37'),(35,35,NULL,0,'$2b$12$N.vImfbpXixxHNuAIb45OOB37x9eT0/k1IT2ur7.ZHJ1XiHf0nvVi',1771574925799024,NULL,'2026-02-20 08:08:45'),(38,38,NULL,0,'$2b$12$4.M3/nAoSbFKaiwZs7fU../sM1iqfB5Cuh09mJSmFUz.kKsgW7gBm',1771574926188058,NULL,'2026-02-20 08:08:46'),(41,41,NULL,0,'$2b$12$6q3L2.WjOp71tv4Am6DHw.I2.YH9covjcXa1nPuTr0C8NQsYHjjWu',1771574926684044,NULL,'2026-02-20 08:08:46'),(44,44,NULL,0,'$2b$12$uK0PGrO8TWeyOS5oSFcx/er.GIrn284.Cm9SrjpkR2eCvWyPMNJcq',1771574926980310,NULL,'2026-02-20 08:08:46'),(47,47,NULL,0,'$2b$12$XRE5k7Scf0mIeL8oZ3WYyuBPMAl3.478/Spihvs3RNcPnBfugGxIC',1771574927408233,NULL,'2026-02-20 08:08:47'),(50,2,NULL,0,'$2b$12$y2TgoGUCFyuEcn33Dcz4BuPM5gcksqk/26DxDYWOG2RfPy.J5RY.a',1771576736645335,NULL,'2026-02-20 08:38:56'),(51,50,NULL,0,'$2b$12$11W0LKsTHfwi.25YLz1o2uyj/aDt9pjhSEDQ/UQw3tBQfllxLuluO',1771576887714958,NULL,'2026-02-20 08:41:27'),(52,51,NULL,0,'$2b$12$RrEI9dwcBSjo/enNjLkSVehcuFFuywlmSQ2avZORzvUs6By9SUTLe',1771580989901097,NULL,'2026-02-20 09:49:49'),(53,52,NULL,0,'$2b$12$tS1xcW4k.GReKYJffcQSWuRINIPREQfSdC7MwbWtanYAZR0qvJYUC',1771580990355833,NULL,'2026-02-20 09:49:50');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('264535d5b76c4b86bf9c7436214b5148','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('56508c3c3c0e4baeab4dc07a84bd9d78','heat_stack','{}','',1,'<<keystone.domain.root>>',NULL,1),('70c82d06cf3245c1b4dddd0d8c4493b6','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0),('91bce661d685472eb3e7cacab17bf52a','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1),('f6685cdb0ff24cddaeb987c63c89eafb','service','{}',NULL,1,'default','default',0);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=1201 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (1,NULL,NULL,'141ec720081546bb92f7e9338deb8445',NULL,NULL,NULL,NULL,'2026-02-20 08:38:57',NULL,'2026-02-20 08:38:57',NULL,NULL),(2,NULL,NULL,'8a1295c2dead4cd1896e4106f6036c26',NULL,NULL,NULL,NULL,'2026-02-20 09:50:26',NULL,'2026-02-20 09:50:26',NULL,NULL),(3,NULL,NULL,'7898edcc4139438a955bc8ba9e024537',NULL,NULL,NULL,NULL,'2026-02-20 09:50:27',NULL,'2026-02-20 09:50:27',NULL,NULL),(4,NULL,NULL,'e8eb67a52687402abf51b8e825e3a62d',NULL,NULL,NULL,NULL,'2026-02-20 09:50:27',NULL,'2026-02-20 09:50:27',NULL,NULL),(5,NULL,'18fa8f7a6d1e4f69b2d7d2f4241b5ee1',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:27',NULL,'2026-02-20 09:50:27',NULL,NULL),(6,NULL,NULL,'99c868ccff2f4f00b8cf8c02ea125739',NULL,NULL,NULL,NULL,'2026-02-20 09:50:27',NULL,'2026-02-20 09:50:27',NULL,NULL),(7,NULL,NULL,'db2b8b7703fb412cb340d24e060343b8',NULL,NULL,NULL,NULL,'2026-02-20 09:50:28',NULL,'2026-02-20 09:50:28',NULL,NULL),(8,NULL,NULL,'6028e367fe074c26b0f251f825f9fc77',NULL,NULL,NULL,NULL,'2026-02-20 09:50:28',NULL,'2026-02-20 09:50:28',NULL,NULL),(9,NULL,NULL,'d8d4d0541b43467e932aa08d3661b27e',NULL,NULL,NULL,NULL,'2026-02-20 09:50:28',NULL,'2026-02-20 09:50:28',NULL,NULL),(10,NULL,NULL,'c487354c39944211bd8c4b6c213a40aa',NULL,NULL,NULL,NULL,'2026-02-20 09:50:28',NULL,'2026-02-20 09:50:28',NULL,NULL),(11,NULL,NULL,'5c3d1238c4b24e988c03b3cf2c42d840',NULL,NULL,NULL,NULL,'2026-02-20 09:50:28',NULL,'2026-02-20 09:50:28',NULL,NULL),(12,NULL,NULL,'b2e7480e709b4eb7bcb819a8f4ec1a2b',NULL,NULL,NULL,NULL,'2026-02-20 09:50:28',NULL,'2026-02-20 09:50:28',NULL,NULL),(13,NULL,NULL,'62cf023b91374487a2f69ef6c368b19e',NULL,NULL,NULL,NULL,'2026-02-20 09:50:28',NULL,'2026-02-20 09:50:28',NULL,NULL),(14,NULL,'af5923f12a3941cba75dfad57ceca5c6',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:28',NULL,'2026-02-20 09:50:28',NULL,NULL),(15,NULL,NULL,'d949c056c39242c8af9b3fcb9420f4e1',NULL,NULL,NULL,NULL,'2026-02-20 09:50:28',NULL,'2026-02-20 09:50:28',NULL,NULL),(16,NULL,NULL,'50f009ab2a89475b830fb518143e5713',NULL,NULL,NULL,NULL,'2026-02-20 09:50:29',NULL,'2026-02-20 09:50:29',NULL,NULL),(17,NULL,'eac572fa44784d17bfbf2ae4e7848350',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:29',NULL,'2026-02-20 09:50:29',NULL,NULL),(18,NULL,NULL,'64ef53a890a24353aae977600c014e36',NULL,NULL,NULL,NULL,'2026-02-20 09:50:29',NULL,'2026-02-20 09:50:29',NULL,NULL),(19,NULL,'4131c469bb0a4685853996498268fa8a',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:29',NULL,'2026-02-20 09:50:29',NULL,NULL),(20,NULL,NULL,'dab1cf31ba5d40de9160b09ea96b4a26',NULL,NULL,NULL,NULL,'2026-02-20 09:50:29',NULL,'2026-02-20 09:50:29',NULL,NULL),(21,NULL,'159c7427229d4bff81168fe16ed4e121',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:29',NULL,'2026-02-20 09:50:29',NULL,NULL),(22,NULL,'9f81aa88c8464be9a5dafd4fb785ee4c',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:29',NULL,'2026-02-20 09:50:29',NULL,NULL),(23,NULL,'1a1db8ef6fb94f4eb2e575c14dc3aade',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:30',NULL,'2026-02-20 09:50:30',NULL,NULL),(24,NULL,'d464192d77b347e3a9e7e46f296b8184',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:30',NULL,'2026-02-20 09:50:30',NULL,NULL),(25,NULL,'1036639e9e714fd18e6fed5cf663c2de',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:30',NULL,'2026-02-20 09:50:30',NULL,NULL),(26,NULL,'97e71ae06d864de0b99e3a4e41815f21',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:30',NULL,'2026-02-20 09:50:30',NULL,NULL),(27,NULL,'169c76ad4c6a4b2ab452cf3635c09100',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:31',NULL,'2026-02-20 09:50:31',NULL,NULL),(28,NULL,'6e48623386644d53b61c6e4b451ebd9a',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:31',NULL,'2026-02-20 09:50:31',NULL,NULL),(29,NULL,'70c6d1f00b1942ef8f800fe1955d4b7d',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:31',NULL,'2026-02-20 09:50:31',NULL,NULL),(30,NULL,'794797af222b447c8a54f232926f3507',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:31',NULL,'2026-02-20 09:50:31',NULL,NULL),(31,NULL,'eccb30754873440aba7672262a28cc0b',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:32',NULL,'2026-02-20 09:50:32',NULL,NULL),(32,NULL,NULL,'0fc48e74ecdc4ba48e1686ea6874b04d',NULL,NULL,NULL,NULL,'2026-02-20 09:50:32',NULL,'2026-02-20 09:50:32',NULL,NULL),(33,NULL,NULL,'3d9d2c40afee43a0b4a96071fef2a6f5',NULL,NULL,NULL,NULL,'2026-02-20 09:50:32',NULL,'2026-02-20 09:50:32',NULL,NULL),(34,NULL,'ecba8f4bda77450d9b5e719da0307fcd',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:34',NULL,'2026-02-20 09:50:34',NULL,NULL),(35,NULL,NULL,'442c8765ced54e0e8745cea5c64ea5cf',NULL,NULL,NULL,NULL,'2026-02-20 09:50:34',NULL,'2026-02-20 09:50:34',NULL,NULL),(36,NULL,'972e173b6539424c9d697d47aecf57ea',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:34',NULL,'2026-02-20 09:50:34',NULL,NULL),(37,NULL,NULL,'57906aa83fc24c54b687e2fdf94e9b94',NULL,NULL,NULL,NULL,'2026-02-20 09:50:35',NULL,'2026-02-20 09:50:35',NULL,NULL),(38,NULL,'78e31b8dd6a94d078eb56e62d4d2d399',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:36',NULL,'2026-02-20 09:50:36',NULL,NULL),(39,NULL,NULL,'4c3a74dad33f4c87ae8ff0e0a53d466a',NULL,NULL,NULL,NULL,'2026-02-20 09:50:37',NULL,'2026-02-20 09:50:37',NULL,NULL),(40,NULL,'95a043dc8da344dca48eb88c16246fb9',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:37',NULL,'2026-02-20 09:50:37',NULL,NULL),(41,NULL,NULL,'13664424afeb4adaae3b96f091670e1c',NULL,NULL,NULL,NULL,'2026-02-20 09:50:37',NULL,'2026-02-20 09:50:37',NULL,NULL),(42,NULL,NULL,'bf1e1f7308964f859f3638a44ba80c90',NULL,NULL,NULL,NULL,'2026-02-20 09:50:37',NULL,'2026-02-20 09:50:37',NULL,NULL),(43,NULL,NULL,'efd44f52b9e647b6a5706c872df6f912',NULL,NULL,NULL,NULL,'2026-02-20 09:50:38',NULL,'2026-02-20 09:50:38',NULL,NULL),(44,NULL,NULL,'dfe42a859cbd4c8cb1c0b0bf7805d99b',NULL,NULL,NULL,NULL,'2026-02-20 09:50:38',NULL,'2026-02-20 09:50:38',NULL,NULL),(45,NULL,NULL,'98a847daa2f64252acfbbd048acd7df3',NULL,NULL,NULL,NULL,'2026-02-20 09:50:38',NULL,'2026-02-20 09:50:38',NULL,NULL),(46,NULL,'6c874107bd924fc3ae3186306baa46b3',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:39',NULL,'2026-02-20 09:50:39',NULL,NULL),(47,NULL,NULL,'69080545fa574d9eaf833981085be503',NULL,NULL,NULL,NULL,'2026-02-20 09:50:39',NULL,'2026-02-20 09:50:39',NULL,NULL),(48,NULL,NULL,'51214bceae9e42e5ad822407c4cd891b',NULL,NULL,NULL,NULL,'2026-02-20 09:50:39',NULL,'2026-02-20 09:50:39',NULL,NULL),(49,NULL,'149b761fe629452db211945c3dee415e',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:40',NULL,'2026-02-20 09:50:40',NULL,NULL),(50,NULL,'d802e9f260c741528116ebab1a020839',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:40',NULL,'2026-02-20 09:50:40',NULL,NULL),(51,NULL,'25c5b88addab4c2395a67572f3f995dd',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:40',NULL,'2026-02-20 09:50:40',NULL,NULL),(52,NULL,NULL,'fed3b3be872d4903b44d0e0c8c32e479',NULL,NULL,NULL,NULL,'2026-02-20 09:50:40',NULL,'2026-02-20 09:50:40',NULL,NULL),(53,NULL,NULL,'3a1e620db6b340e7bfa408527be1de5b',NULL,NULL,NULL,NULL,'2026-02-20 09:50:40',NULL,'2026-02-20 09:50:40',NULL,NULL),(54,NULL,'6e0c1c9c00a2467fab4fd6415e9d35e9',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:41',NULL,'2026-02-20 09:50:41',NULL,NULL),(55,NULL,'4b828942ed494b84945b8907f13504d6',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:41',NULL,'2026-02-20 09:50:41',NULL,NULL),(56,NULL,'4aae6c4378ab423eacafa74c1132e5c7',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:41',NULL,'2026-02-20 09:50:41',NULL,NULL),(57,NULL,'5bda1e063d7d46aa95089c7c30281b36',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:41',NULL,'2026-02-20 09:50:41',NULL,NULL),(58,NULL,'550c29d8b7244bbfbcf4a3ed9ef88275',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:42',NULL,'2026-02-20 09:50:42',NULL,NULL),(59,NULL,'ad7518dceeef4b6381d543c2e30f7022',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:42',NULL,'2026-02-20 09:50:42',NULL,NULL),(60,NULL,NULL,'bbca7dd5b2854ab29c3dae0eb287a72f',NULL,NULL,NULL,NULL,'2026-02-20 09:50:42',NULL,'2026-02-20 09:50:42',NULL,NULL),(61,NULL,NULL,'3a453002a5e6431e86325664caafd382',NULL,NULL,NULL,NULL,'2026-02-20 09:50:43',NULL,'2026-02-20 09:50:43',NULL,NULL),(62,NULL,NULL,'9b7d28c772ae4fef8c7a6689ab388156',NULL,NULL,NULL,NULL,'2026-02-20 09:50:43',NULL,'2026-02-20 09:50:43',NULL,NULL),(63,NULL,NULL,'f22fd169a35749298a9d07ed94655d15',NULL,NULL,NULL,NULL,'2026-02-20 09:50:43',NULL,'2026-02-20 09:50:43',NULL,NULL),(64,NULL,NULL,'5530e9dc8c5d4196bfe21fa3a80987b9',NULL,NULL,NULL,NULL,'2026-02-20 09:50:43',NULL,'2026-02-20 09:50:43',NULL,NULL),(65,NULL,NULL,'87238a95b3494a71ab52e51be7dc9a27',NULL,NULL,NULL,NULL,'2026-02-20 09:50:43',NULL,'2026-02-20 09:50:43',NULL,NULL),(66,NULL,NULL,'a1348efba3734ef5b423888cfcfd55d9',NULL,NULL,NULL,NULL,'2026-02-20 09:50:44',NULL,'2026-02-20 09:50:44',NULL,NULL),(67,NULL,'db66a9adaf114a39b0a8f90b5ac56d40',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:44',NULL,'2026-02-20 09:50:44',NULL,NULL),(68,NULL,'550294bd4f004644aaf6e1ed46b07bb8',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:45',NULL,'2026-02-20 09:50:45',NULL,NULL),(69,NULL,'75abfbd10d3e4b43970a932febf426a1',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:45',NULL,'2026-02-20 09:50:45',NULL,NULL),(70,NULL,NULL,'06a1b5a909994241b1f0f334816ec82f',NULL,NULL,NULL,NULL,'2026-02-20 09:50:45',NULL,'2026-02-20 09:50:45',NULL,NULL),(71,NULL,'3f0c71cb5c924e8dbb54155f4dbe5c3e',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:45',NULL,'2026-02-20 09:50:45',NULL,NULL),(72,NULL,NULL,'2a35cb474e7445b79b69940f49c7d3c0',NULL,NULL,NULL,NULL,'2026-02-20 09:50:46',NULL,'2026-02-20 09:50:46',NULL,NULL),(73,NULL,NULL,'c13a9348f1e54faab118514ac346b147',NULL,NULL,NULL,NULL,'2026-02-20 09:50:46',NULL,'2026-02-20 09:50:46',NULL,NULL),(74,NULL,NULL,'afb5275fd954471db33d642bee21cc51',NULL,NULL,NULL,NULL,'2026-02-20 09:50:46',NULL,'2026-02-20 09:50:46',NULL,NULL),(75,NULL,'564eb805c3b447f1bbed0ec2b4d452bc',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:46',NULL,'2026-02-20 09:50:46',NULL,NULL),(76,NULL,'a26a710847f44621a1ad72a2e214eee8',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:46',NULL,'2026-02-20 09:50:46',NULL,NULL),(77,NULL,'ce9099fb79ca480392747a585559f1f0',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:47',NULL,'2026-02-20 09:50:47',NULL,NULL),(78,NULL,'94f2e674c0ff48769db25ab1200f6fa6',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:47',NULL,'2026-02-20 09:50:47',NULL,NULL),(79,NULL,'7d5bbdc806e245c8a91429d0f583de37',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:48',NULL,'2026-02-20 09:50:48',NULL,NULL),(80,NULL,'478ea94281c14d8ca97d8256d0283424',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:48',NULL,'2026-02-20 09:50:48',NULL,NULL),(81,NULL,NULL,'7a4e3fed19194a77bc1546f6dbcdfcc6',NULL,NULL,NULL,NULL,'2026-02-20 09:50:48',NULL,'2026-02-20 09:50:48',NULL,NULL),(82,NULL,'de89f0ac8fd4415a89430bb607e197fd',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:49',NULL,'2026-02-20 09:50:49',NULL,NULL),(83,NULL,NULL,'8f9c5dd53c3048d9852dbe70e089087c',NULL,NULL,NULL,NULL,'2026-02-20 09:50:49',NULL,'2026-02-20 09:50:49',NULL,NULL),(84,NULL,NULL,'b5e4a24d80bc43658118af42d6f10d86',NULL,NULL,NULL,NULL,'2026-02-20 09:50:49',NULL,'2026-02-20 09:50:49',NULL,NULL),(85,NULL,NULL,'da5d9280286f4afea7e499362c672f02',NULL,NULL,NULL,NULL,'2026-02-20 09:50:49',NULL,'2026-02-20 09:50:49',NULL,NULL),(86,NULL,NULL,'6aaecc4ac4934df19b17cd3af44b420a',NULL,NULL,NULL,NULL,'2026-02-20 09:50:49',NULL,'2026-02-20 09:50:49',NULL,NULL),(87,NULL,'6090a312f6ea40aaab7a6a2e673a0cb4',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:50',NULL,'2026-02-20 09:50:50',NULL,NULL),(88,NULL,'2681b47ad3c845e7b3bb1ec35eb5abbe',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:50',NULL,'2026-02-20 09:50:50',NULL,NULL),(89,NULL,NULL,'65f5726a4c294f55b13bc421d524e374',NULL,NULL,NULL,NULL,'2026-02-20 09:50:51',NULL,'2026-02-20 09:50:51',NULL,NULL),(90,NULL,NULL,'052668d0ae88447db511cc566196c98b',NULL,NULL,NULL,NULL,'2026-02-20 09:50:51',NULL,'2026-02-20 09:50:51',NULL,NULL),(91,NULL,'7d53ef1082cc46d0b36b8d8e0dcafbe1',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:52',NULL,'2026-02-20 09:50:52',NULL,NULL),(92,NULL,NULL,'88764dc1e0834c839ed4c010ba382eca',NULL,NULL,NULL,NULL,'2026-02-20 09:50:52',NULL,'2026-02-20 09:50:52',NULL,NULL),(93,NULL,NULL,'6cfa71129ae04734aa717ebe58bfefbb',NULL,NULL,NULL,NULL,'2026-02-20 09:50:52',NULL,'2026-02-20 09:50:52',NULL,NULL),(94,NULL,'d5e9494e90e54cb4aa2784add78b251d',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:52',NULL,'2026-02-20 09:50:52',NULL,NULL),(95,NULL,'1a9710b69407488bb068cb9050c42fe9',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:53',NULL,'2026-02-20 09:50:53',NULL,NULL),(96,NULL,'f600526d0eec44a69c08f34b71dd5661',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:54',NULL,'2026-02-20 09:50:54',NULL,NULL),(97,NULL,'5af3ab087bc2419aa32a0a76ba0d79b7',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:54',NULL,'2026-02-20 09:50:54',NULL,NULL),(98,NULL,'6226e6246eb84f32b7a24c53c3dfd7d5',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:54',NULL,'2026-02-20 09:50:54',NULL,NULL),(99,NULL,'3981c66d3b5c4e0a81704fbc279c3962',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:56',NULL,'2026-02-20 09:50:56',NULL,NULL),(100,NULL,NULL,'e3ebfd1637574ef7a64f22cb055633c8',NULL,NULL,NULL,NULL,'2026-02-20 09:50:57',NULL,'2026-02-20 09:50:57',NULL,NULL),(101,NULL,'6882dd07b72d4afe954a62eceeb8acc3',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:50:58',NULL,'2026-02-20 09:50:58',NULL,NULL),(102,NULL,NULL,'f0711dd503334b069c0ff16a6b214f3b',NULL,NULL,NULL,NULL,'2026-02-20 09:50:59',NULL,'2026-02-20 09:50:59',NULL,NULL),(103,NULL,'9b66e0f522c64dd99ad941decfbb81d4',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:00',NULL,'2026-02-20 09:51:00',NULL,NULL),(104,NULL,'5a71c85068454599bd460f60dda32410',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:00',NULL,'2026-02-20 09:51:00',NULL,NULL),(105,NULL,NULL,'7a1a63f07712432da9689d0c0841cf08',NULL,NULL,NULL,NULL,'2026-02-20 09:51:01',NULL,'2026-02-20 09:51:01',NULL,NULL),(106,NULL,'ed8238c7151b4fa3bde3f0ce50a4b61a',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:01',NULL,'2026-02-20 09:51:01',NULL,NULL),(107,NULL,NULL,'4a07a67200164dbab02143b22c772485',NULL,NULL,NULL,NULL,'2026-02-20 09:51:02',NULL,'2026-02-20 09:51:02',NULL,NULL),(108,NULL,NULL,'45a8a565dfff439392bfe050c2bb8713',NULL,NULL,NULL,NULL,'2026-02-20 09:51:02',NULL,'2026-02-20 09:51:02',NULL,NULL),(109,NULL,NULL,'ce6b41c2e3b14113b0b774ddc62fb5f2',NULL,NULL,NULL,NULL,'2026-02-20 09:51:02',NULL,'2026-02-20 09:51:02',NULL,NULL),(110,NULL,NULL,'0c781e7758604e94939ffd7d61ce0959',NULL,NULL,NULL,NULL,'2026-02-20 09:51:02',NULL,'2026-02-20 09:51:02',NULL,NULL),(111,NULL,NULL,'feaf505d64584cc18a8d9bdbfcedc472',NULL,NULL,NULL,NULL,'2026-02-20 09:51:03',NULL,'2026-02-20 09:51:03',NULL,NULL),(112,NULL,'fc3f0cf1a28b4c0b85fb4776ffd941c4',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:03',NULL,'2026-02-20 09:51:03',NULL,NULL),(113,NULL,'46ca87f2b86f41eaacf1aadaa245e8fe',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:03',NULL,'2026-02-20 09:51:03',NULL,NULL),(114,NULL,'b949c09c0f154fa8a798a7f4080ae918',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:04',NULL,'2026-02-20 09:51:04',NULL,NULL),(115,NULL,'ccc01e4ba67743c0a15e96c60fde05ab',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:04',NULL,'2026-02-20 09:51:04',NULL,NULL),(116,NULL,'247c4a8c162d4c249a17550df2cab2e2',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:05',NULL,'2026-02-20 09:51:05',NULL,NULL),(117,NULL,NULL,'9dd69ebeffc04f2f9533dfa396ee9a39',NULL,NULL,NULL,NULL,'2026-02-20 09:51:06',NULL,'2026-02-20 09:51:06',NULL,NULL),(118,NULL,NULL,'8657812b7964452c9104697bfc349ac9',NULL,NULL,NULL,NULL,'2026-02-20 09:51:06',NULL,'2026-02-20 09:51:06',NULL,NULL),(119,NULL,'c5de48a1ac9c4e2385a9893267075b8c',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:08',NULL,'2026-02-20 09:51:08',NULL,NULL),(120,NULL,NULL,'0a61bfd8454f47e295f463f1c2467f04',NULL,NULL,NULL,NULL,'2026-02-20 09:51:08',NULL,'2026-02-20 09:51:08',NULL,NULL),(121,NULL,NULL,'ea1787d545e4482bb57807dece3292eb',NULL,NULL,NULL,NULL,'2026-02-20 09:51:08',NULL,'2026-02-20 09:51:08',NULL,NULL),(122,NULL,'e8f6b1f6c74e4315899e2b5694c37812',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:09',NULL,'2026-02-20 09:51:09',NULL,NULL),(123,NULL,'89e18e56ab514b3c8ace764d19fe8349',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:11',NULL,'2026-02-20 09:51:11',NULL,NULL),(124,NULL,'c8441ac08d4244a29a9bd23fdf5427ba',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:12',NULL,'2026-02-20 09:51:12',NULL,NULL),(125,NULL,'61c55769b3a54b1eac0b7a5c81b6147b',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:12',NULL,'2026-02-20 09:51:12',NULL,NULL),(126,NULL,'12f1e3201ac84fd0b55a32c52d9999fd',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:12',NULL,'2026-02-20 09:51:12',NULL,NULL),(127,NULL,NULL,'b6114fcf5cc1461fb357aa6421cafe6b',NULL,NULL,NULL,NULL,'2026-02-20 09:51:13',NULL,'2026-02-20 09:51:13',NULL,NULL),(128,NULL,NULL,'87a42cb8c82b47c0814035c64c661af4',NULL,NULL,NULL,NULL,'2026-02-20 09:51:13',NULL,'2026-02-20 09:51:13',NULL,NULL),(129,NULL,'5b2a5882908d463a85288edbff704fe7',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:15',NULL,'2026-02-20 09:51:15',NULL,NULL),(130,NULL,'139148fc12504eac821da529e35e10cc',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:16',NULL,'2026-02-20 09:51:16',NULL,NULL),(131,NULL,NULL,'c35dc1f245dc4c97877f2c1df0437684',NULL,NULL,NULL,NULL,'2026-02-20 09:51:18',NULL,'2026-02-20 09:51:18',NULL,NULL),(132,NULL,'27062c1e0b7d442e92145af8caaac310',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:18',NULL,'2026-02-20 09:51:18',NULL,NULL),(133,NULL,NULL,'2d463ec0b0974b7082ede04725cb03af',NULL,NULL,NULL,NULL,'2026-02-20 09:51:20',NULL,'2026-02-20 09:51:20',NULL,NULL),(134,NULL,NULL,'d7c00f5850e44170ad445b0b493bb570',NULL,NULL,NULL,NULL,'2026-02-20 09:51:20',NULL,'2026-02-20 09:51:20',NULL,NULL),(135,NULL,NULL,'094175d1df314b6787f9e640b498a4c3',NULL,NULL,NULL,NULL,'2026-02-20 09:51:21',NULL,'2026-02-20 09:51:21',NULL,NULL),(136,NULL,NULL,'c10c6077531c4824b66075f7213183ec',NULL,NULL,NULL,NULL,'2026-02-20 09:51:21',NULL,'2026-02-20 09:51:21',NULL,NULL),(137,NULL,'99e77dfaf73942b9bd536f91b66ac74d',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:22',NULL,'2026-02-20 09:51:22',NULL,NULL),(138,NULL,'9584c3165f644712b9f56aff1f9c5faf',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:22',NULL,'2026-02-20 09:51:22',NULL,NULL),(139,NULL,'3f35ed88a2a04d238f41342ee5043c04',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:22',NULL,'2026-02-20 09:51:22',NULL,NULL),(140,NULL,'26f712fb69574ff3b759cd0b9a18c40b',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:23',NULL,'2026-02-20 09:51:23',NULL,NULL),(141,NULL,NULL,'d72ea5cabdf6464c8da57502942528c7',NULL,NULL,NULL,NULL,'2026-02-20 09:51:24',NULL,'2026-02-20 09:51:24',NULL,NULL),(142,NULL,NULL,'065fe9a08d1d401a92aff582ffe9a3ba',NULL,NULL,NULL,NULL,'2026-02-20 09:51:25',NULL,'2026-02-20 09:51:25',NULL,NULL),(143,NULL,'3182e27a2ca4411b98c49902243de2fd',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:26',NULL,'2026-02-20 09:51:26',NULL,NULL),(144,NULL,'6dae517fce2e425e99e82147c19af3bf',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:27',NULL,'2026-02-20 09:51:27',NULL,NULL),(145,NULL,NULL,'be898393b4f34bf5ae70e0f33ae5ca37',NULL,NULL,NULL,NULL,'2026-02-20 09:51:28',NULL,'2026-02-20 09:51:28',NULL,NULL),(146,NULL,NULL,'19c6a0af0d664b5d92fdce6a6ecdbcc4',NULL,NULL,NULL,NULL,'2026-02-20 09:51:28',NULL,'2026-02-20 09:51:28',NULL,NULL),(147,NULL,'b76abbcaaa0b49b3abfcdaf1607439fd',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:28',NULL,'2026-02-20 09:51:28',NULL,NULL),(148,NULL,'5ce7589beebc4b9187ac7a68f3264776',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:28',NULL,'2026-02-20 09:51:28',NULL,NULL),(149,NULL,NULL,'306567a783b34aa9a5a7cda4b5b1bc7f',NULL,NULL,NULL,NULL,'2026-02-20 09:51:30',NULL,'2026-02-20 09:51:30',NULL,NULL),(150,NULL,NULL,'1eaf3c2e0b5c41328ba51c237d8673fe',NULL,NULL,NULL,NULL,'2026-02-20 09:51:30',NULL,'2026-02-20 09:51:30',NULL,NULL),(151,NULL,NULL,'685325b7c65247528852d6527a7e1f26',NULL,NULL,NULL,NULL,'2026-02-20 09:51:31',NULL,'2026-02-20 09:51:31',NULL,NULL),(152,NULL,'1f41a21f1739446987801ad7098fcdfd',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:31',NULL,'2026-02-20 09:51:31',NULL,NULL),(153,NULL,'48cb0ad43a3b446799e1e0a2b889c36a',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:32',NULL,'2026-02-20 09:51:32',NULL,NULL),(154,NULL,'90846ea45b3b46d1bbd1e70306c8d790',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:33',NULL,'2026-02-20 09:51:33',NULL,NULL),(155,NULL,NULL,'ada157da829247299267d17bf5533d7e',NULL,NULL,NULL,NULL,'2026-02-20 09:51:35',NULL,'2026-02-20 09:51:35',NULL,NULL),(156,NULL,NULL,'247debc330744d15a3a1d69ba74bfbad',NULL,NULL,NULL,NULL,'2026-02-20 09:51:36',NULL,'2026-02-20 09:51:36',NULL,NULL),(157,NULL,NULL,'5a726290bc0743b1b614cd1c04a8688f',NULL,NULL,NULL,NULL,'2026-02-20 09:51:37',NULL,'2026-02-20 09:51:37',NULL,NULL),(158,NULL,'c317b961980b401dae3ed7b82d2d9d38',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:37',NULL,'2026-02-20 09:51:37',NULL,NULL),(159,NULL,'f32955854d11445f8581df64e022a40e',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:39',NULL,'2026-02-20 09:51:39',NULL,NULL),(160,NULL,'77452cde52964970833d13336153edc3',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:41',NULL,'2026-02-20 09:51:41',NULL,NULL),(161,NULL,NULL,'748094572d2049dea4faf7ea21338b54',NULL,NULL,NULL,NULL,'2026-02-20 09:51:41',NULL,'2026-02-20 09:51:41',NULL,NULL),(162,NULL,'49a923e0d10f45bb995db1c408c76c95',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:42',NULL,'2026-02-20 09:51:42',NULL,NULL),(163,NULL,'cb057d64b9a04e3eb1d190aa49879a89',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:42',NULL,'2026-02-20 09:51:42',NULL,NULL),(164,NULL,NULL,'326160de115049e78e31fa10844f079b',NULL,NULL,NULL,NULL,'2026-02-20 09:51:42',NULL,'2026-02-20 09:51:42',NULL,NULL),(165,NULL,NULL,'7e7eb5d0d347438b8287109587a47459',NULL,NULL,NULL,NULL,'2026-02-20 09:51:42',NULL,'2026-02-20 09:51:42',NULL,NULL),(166,NULL,NULL,'59d62a6890444991bffe71332fb3a3e2',NULL,NULL,NULL,NULL,'2026-02-20 09:51:43',NULL,'2026-02-20 09:51:43',NULL,NULL),(167,NULL,'52624639c6ac4de0bbf218f016b90992',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:44',NULL,'2026-02-20 09:51:44',NULL,NULL),(168,NULL,'d3fdfa5107a14826974bb186703fcf4d',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:45',NULL,'2026-02-20 09:51:45',NULL,NULL),(169,NULL,'f63906df21404964bb84659f0faae061',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:46',NULL,'2026-02-20 09:51:46',NULL,NULL),(170,NULL,'916ef77b693f4fb6b9c9fba94254b296',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:49',NULL,'2026-02-20 09:51:49',NULL,NULL),(171,NULL,'f47b35ae969e41c9ab40764580ff266e',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:50',NULL,'2026-02-20 09:51:50',NULL,NULL),(172,NULL,'f1291a8ce32a4f47a430ba168fe11915',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:51',NULL,'2026-02-20 09:51:51',NULL,NULL),(173,NULL,NULL,'1f01ef675b2b453a849af64976628f08',NULL,NULL,NULL,NULL,'2026-02-20 09:51:51',NULL,'2026-02-20 09:51:51',NULL,NULL),(174,NULL,NULL,'29686e50adf949459f5773db772ee861',NULL,NULL,NULL,NULL,'2026-02-20 09:51:52',NULL,'2026-02-20 09:51:52',NULL,NULL),(175,NULL,'b95791cfa51d467fac6f25c60d6566ac',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:53',NULL,'2026-02-20 09:51:53',NULL,NULL),(176,NULL,NULL,'1b715825aa1d4e658866f228932cf07c',NULL,NULL,NULL,NULL,'2026-02-20 09:51:53',NULL,'2026-02-20 09:51:53',NULL,NULL),(177,NULL,NULL,'2b17bf7a622e4207a920398e2bb2bbdd',NULL,NULL,NULL,NULL,'2026-02-20 09:51:53',NULL,'2026-02-20 09:51:53',NULL,NULL),(178,NULL,'8cd672e2d1634c5793f3c48f4d1122c9',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:54',NULL,'2026-02-20 09:51:54',NULL,NULL),(179,NULL,'de8c6299efda49e1b356acc700c73803',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:55',NULL,'2026-02-20 09:51:55',NULL,NULL),(180,NULL,'785965d272da4927b43f6acba9cd33d2',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:51:57',NULL,'2026-02-20 09:51:57',NULL,NULL),(181,NULL,NULL,'2d63079600c943628d3d88d775c88255',NULL,NULL,NULL,NULL,'2026-02-20 09:52:02',NULL,'2026-02-20 09:52:02',NULL,NULL),(182,NULL,NULL,'7780c883695d4ab6a2b3620819115cea',NULL,NULL,NULL,NULL,'2026-02-20 09:52:02',NULL,'2026-02-20 09:52:02',NULL,NULL),(183,NULL,'2079b3baacf64c19badff7e6d5941466',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:03',NULL,'2026-02-20 09:52:03',NULL,NULL),(184,NULL,'755c895908b04787bc114df90ae06e5c',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:04',NULL,'2026-02-20 09:52:04',NULL,NULL),(185,NULL,NULL,'145fd44a62064e7c913893b85af3b124',NULL,NULL,NULL,NULL,'2026-02-20 09:52:08',NULL,'2026-02-20 09:52:08',NULL,NULL),(186,NULL,NULL,'107ab22f7bfc4441a4ab7a417331cdb2',NULL,NULL,NULL,NULL,'2026-02-20 09:52:09',NULL,'2026-02-20 09:52:09',NULL,NULL),(187,NULL,'9185355b44514f08891bbd9372fd70c7',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:09',NULL,'2026-02-20 09:52:09',NULL,NULL),(188,NULL,'0e7d3e1cfe9f4e4d8451c6f0b8be3a29',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:09',NULL,'2026-02-20 09:52:09',NULL,NULL),(189,NULL,NULL,'301d08a28628451793d9681cee334aed',NULL,NULL,NULL,NULL,'2026-02-20 09:52:09',NULL,'2026-02-20 09:52:09',NULL,NULL),(190,NULL,NULL,'58d9e4e4a0cf4ade9d5f3019489c4262',NULL,NULL,NULL,NULL,'2026-02-20 09:52:10',NULL,'2026-02-20 09:52:10',NULL,NULL),(191,NULL,'3bf3a16481834e3a81e04ea40bee1d8d',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:10',NULL,'2026-02-20 09:52:10',NULL,NULL),(192,NULL,'906e7f3f29354f98af555abdc6252a00',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:11',NULL,'2026-02-20 09:52:11',NULL,NULL),(193,NULL,NULL,'65489f8d7cbf42a2960f2d764c16b3f2',NULL,NULL,NULL,NULL,'2026-02-20 09:52:11',NULL,'2026-02-20 09:52:11',NULL,NULL),(194,NULL,NULL,'a91dc5272d2640148196b60301210361',NULL,NULL,NULL,NULL,'2026-02-20 09:52:11',NULL,'2026-02-20 09:52:11',NULL,NULL),(195,NULL,'ac3b136875104e8e89ce7713b56dd117',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:11',NULL,'2026-02-20 09:52:11',NULL,NULL),(196,NULL,'ff4cacca21b64031adfd6cb25f7e62fc',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:13',NULL,'2026-02-20 09:52:13',NULL,NULL),(197,NULL,'19914311848542d7bcbd3693656daddb',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:14',NULL,'2026-02-20 09:52:14',NULL,NULL),(198,NULL,NULL,'c9d69a3f4aa14427bfeabde6246c8591',NULL,NULL,NULL,NULL,'2026-02-20 09:52:14',NULL,'2026-02-20 09:52:14',NULL,NULL),(199,NULL,NULL,'6980fa02b4584a74a36c7b9c070ddd43',NULL,NULL,NULL,NULL,'2026-02-20 09:52:14',NULL,'2026-02-20 09:52:14',NULL,NULL),(200,NULL,'397ffb4366cc4e818241aba2b5a4fdff',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:16',NULL,'2026-02-20 09:52:16',NULL,NULL),(201,NULL,'fc985aa28e7d4fb2a8839a27d8bacb69',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:18',NULL,'2026-02-20 09:52:18',NULL,NULL),(202,NULL,NULL,'db61e1aec8f143079e4a8d2a002d73ec',NULL,NULL,NULL,NULL,'2026-02-20 09:52:18',NULL,'2026-02-20 09:52:18',NULL,NULL),(203,NULL,NULL,'bebc3efee48240d4b2432525f2844dfe',NULL,NULL,NULL,NULL,'2026-02-20 09:52:19',NULL,'2026-02-20 09:52:19',NULL,NULL),(204,NULL,NULL,'60e708aac2f54fd8ac831e533e5f2ae0',NULL,NULL,NULL,NULL,'2026-02-20 09:52:19',NULL,'2026-02-20 09:52:19',NULL,NULL),(205,NULL,NULL,'ba15d0e9919d4594a2e6e9d6b3414a5e',NULL,NULL,NULL,NULL,'2026-02-20 09:52:19',NULL,'2026-02-20 09:52:19',NULL,NULL),(206,NULL,NULL,'fc37a88bcbe34be0bfdc7c0bd2787c78',NULL,NULL,NULL,NULL,'2026-02-20 09:52:19',NULL,'2026-02-20 09:52:19',NULL,NULL),(207,NULL,'e704aae5b1ba49d59262f9aa0c366fb4',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:20',NULL,'2026-02-20 09:52:20',NULL,NULL),(208,NULL,NULL,'0db48d5f6f5e44fc93154cf4b34a94e0',NULL,NULL,NULL,NULL,'2026-02-20 09:52:20',NULL,'2026-02-20 09:52:20',NULL,NULL),(209,NULL,'f124d7da84704c24845780437fc937f8',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:20',NULL,'2026-02-20 09:52:20',NULL,NULL),(210,NULL,NULL,'f01e99be64c241eaae4ace2f74d422df',NULL,NULL,NULL,NULL,'2026-02-20 09:52:20',NULL,'2026-02-20 09:52:20',NULL,NULL),(211,NULL,'b1812e6045824b16afa4ff71c8eec54a',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:21',NULL,'2026-02-20 09:52:21',NULL,NULL),(212,NULL,'a966116e4ddf4bdea0571a1bb751916e',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:21',NULL,'2026-02-20 09:52:21',NULL,NULL),(213,NULL,'65685fb154414740b6b5e1276111b8bb',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:21',NULL,'2026-02-20 09:52:21',NULL,NULL),(214,NULL,'5605ba7cb0df4223b48ebf8a1894cdf1',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:21',NULL,'2026-02-20 09:52:21',NULL,NULL),(215,NULL,'036d0daa5a1b45acaa04eeff37099fb0',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:22',NULL,'2026-02-20 09:52:22',NULL,NULL),(216,NULL,NULL,'ad3bee90b7c843958ab29e9ae5697cd5',NULL,NULL,NULL,NULL,'2026-02-20 09:52:24',NULL,'2026-02-20 09:52:24',NULL,NULL),(217,NULL,NULL,'255cd9c4f9a64b8790226c38c16c3650',NULL,NULL,NULL,NULL,'2026-02-20 09:52:25',NULL,'2026-02-20 09:52:25',NULL,NULL),(218,NULL,NULL,'e7bde508afba4fb9b041f8ffc78e153a',NULL,NULL,NULL,NULL,'2026-02-20 09:52:25',NULL,'2026-02-20 09:52:25',NULL,NULL),(219,NULL,NULL,'071edee4cc7844dd8b9af2b8f19630be',NULL,NULL,NULL,NULL,'2026-02-20 09:52:25',NULL,'2026-02-20 09:52:25',NULL,NULL),(220,NULL,'e224961330984638ae0b7241a6db85e9',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:26',NULL,'2026-02-20 09:52:26',NULL,NULL),(221,NULL,'1980e198552f48389d6b0520852b47ad',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:27',NULL,'2026-02-20 09:52:27',NULL,NULL),(222,NULL,NULL,'c7927d2ce2da42cd8871c6b0e13b6cbb',NULL,NULL,NULL,NULL,'2026-02-20 09:52:27',NULL,'2026-02-20 09:52:27',NULL,NULL),(223,NULL,'78fdd34f107b4ec7ac81795ecc3f677c',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:27',NULL,'2026-02-20 09:52:27',NULL,NULL),(224,NULL,NULL,'8437f5bba5954badb84e5270aaf477b8',NULL,NULL,NULL,NULL,'2026-02-20 09:52:28',NULL,'2026-02-20 09:52:28',NULL,NULL),(225,NULL,NULL,'72ba4decc4774b6aa01377da0043b5f4',NULL,NULL,NULL,NULL,'2026-02-20 09:52:28',NULL,'2026-02-20 09:52:28',NULL,NULL),(226,NULL,NULL,'73b1d025a2ec4fcf9911efe351e0aae8',NULL,NULL,NULL,NULL,'2026-02-20 09:52:29',NULL,'2026-02-20 09:52:29',NULL,NULL),(227,NULL,NULL,'2a4f92d4301a48eeac963bf58a6c93cd',NULL,NULL,NULL,NULL,'2026-02-20 09:52:29',NULL,'2026-02-20 09:52:29',NULL,NULL),(228,NULL,'35b58d62ef4a4bc992b8c37ee703519c',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:29',NULL,'2026-02-20 09:52:29',NULL,NULL),(229,NULL,NULL,'dee4ba12ff434825953397f15a60633e',NULL,NULL,NULL,NULL,'2026-02-20 09:52:29',NULL,'2026-02-20 09:52:29',NULL,NULL),(230,NULL,'bd27d965fe8547dfb85545f3f3f2b315',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:30',NULL,'2026-02-20 09:52:30',NULL,NULL),(231,NULL,'3c87ad0e253048e48d34b168f9948627',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:30',NULL,'2026-02-20 09:52:30',NULL,NULL),(232,NULL,'d1e8ba8506004770a5aeba8514a113c0',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:30',NULL,'2026-02-20 09:52:30',NULL,NULL),(233,NULL,'1ef8472cdf8f4b448d413337535708f5',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:31',NULL,'2026-02-20 09:52:31',NULL,NULL),(234,NULL,NULL,'db61e1aec8f143079e4a8d2a002d73ec',NULL,NULL,NULL,NULL,'2026-02-20 09:52:31',NULL,'2026-02-20 09:52:31',NULL,NULL),(235,NULL,'fae6857d8ccd40feadabb0b90de4f169',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:31',NULL,'2026-02-20 09:52:31',NULL,NULL),(236,NULL,NULL,'73b1d025a2ec4fcf9911efe351e0aae8',NULL,NULL,NULL,NULL,'2026-02-20 09:52:31',NULL,'2026-02-20 09:52:31',NULL,NULL),(237,NULL,'66889a05e7e041d0923c538d1dcf36c3',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:31',NULL,'2026-02-20 09:52:31',NULL,NULL),(238,NULL,'7c2c2d52387d44dd9d938f4f6102dca1',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:31',NULL,'2026-02-20 09:52:31',NULL,NULL),(239,NULL,'dd415e851f064ce1a7d8ec55084cb8a0',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:32',NULL,'2026-02-20 09:52:32',NULL,NULL),(240,NULL,'aa88aa940b4646fcac8366681e579716',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:32',NULL,'2026-02-20 09:52:32',NULL,NULL),(241,NULL,'7d7ebb2ca6614f648cbe0aa344f40408',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:32',NULL,'2026-02-20 09:52:32',NULL,NULL),(242,NULL,NULL,'240bd07a94d74490a93f64697b8a7d04',NULL,NULL,NULL,NULL,'2026-02-20 09:52:33',NULL,'2026-02-20 09:52:33',NULL,NULL),(243,NULL,'ff3b5674c52c49e0a44249e2fea72e03',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:33',NULL,'2026-02-20 09:52:33',NULL,NULL),(244,NULL,NULL,'46d00bf482844045b3a4f94428e42a82',NULL,NULL,NULL,NULL,'2026-02-20 09:52:34',NULL,'2026-02-20 09:52:34',NULL,NULL),(245,NULL,NULL,'2188e6de9cae445dadfba1541701ebd2',NULL,NULL,NULL,NULL,'2026-02-20 09:52:35',NULL,'2026-02-20 09:52:35',NULL,NULL),(246,NULL,'f31099d701c5487aac6b31de791802e8',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:36',NULL,'2026-02-20 09:52:36',NULL,NULL),(247,NULL,'f299da1b635f4dafbe62328983ad1fae',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:36',NULL,'2026-02-20 09:52:36',NULL,NULL),(248,NULL,NULL,'0742e0b82e8945dbaae26a5444bf80c8',NULL,NULL,NULL,NULL,'2026-02-20 09:52:36',NULL,'2026-02-20 09:52:36',NULL,NULL),(249,NULL,NULL,'eb9985f5ec574ed18fe4735150bd022a',NULL,NULL,NULL,NULL,'2026-02-20 09:52:37',NULL,'2026-02-20 09:52:37',NULL,NULL),(250,NULL,'3207c43fb43b4477b96e023740319873',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:37',NULL,'2026-02-20 09:52:37',NULL,NULL),(251,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:37',NULL,'2026-02-20 09:52:37','yP_kPsAjSsyw7kGHB5iK1Q',NULL),(252,NULL,NULL,'5eec2270bfab4fe8912939b6d2b44ecd',NULL,NULL,NULL,NULL,'2026-02-20 09:52:37',NULL,'2026-02-20 09:52:37',NULL,NULL),(253,NULL,'22604a65c3b44bbd920ac4fdd8b3be55',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:37',NULL,'2026-02-20 09:52:37',NULL,NULL),(254,NULL,'0709cb66965b440c91d3ba514a5b8445',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:37',NULL,'2026-02-20 09:52:37',NULL,NULL),(255,NULL,'d432ec52034645fc9c023f7534b604f1',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:38',NULL,'2026-02-20 09:52:38',NULL,NULL),(256,NULL,NULL,'c824f2af9daa4fcaac591a25a2abd282',NULL,NULL,NULL,NULL,'2026-02-20 09:52:38',NULL,'2026-02-20 09:52:38',NULL,NULL),(257,NULL,'dfbd7bc491f24cab8e61ab089a4e91d7',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:38',NULL,'2026-02-20 09:52:38',NULL,NULL),(258,NULL,NULL,'3faeea5152004a16b41e9be8a5325b1e',NULL,NULL,NULL,NULL,'2026-02-20 09:52:39',NULL,'2026-02-20 09:52:39',NULL,NULL),(259,NULL,NULL,'414bf7cd4158477ea1db1a1ddae70eef',NULL,NULL,NULL,NULL,'2026-02-20 09:52:39',NULL,'2026-02-20 09:52:39',NULL,NULL),(260,NULL,'6a7463968c384b24abf84716f208ba76',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:39',NULL,'2026-02-20 09:52:39',NULL,NULL),(261,NULL,'65f77080580f4cf78480d26d359d8228',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:39',NULL,'2026-02-20 09:52:39',NULL,NULL),(262,NULL,NULL,'4db138fd62ff4defb1a70387abc62f80',NULL,NULL,NULL,NULL,'2026-02-20 09:52:39',NULL,'2026-02-20 09:52:39',NULL,NULL),(263,NULL,NULL,'ca1b0296a1784d8c851d9e091fb3da6d',NULL,NULL,NULL,NULL,'2026-02-20 09:52:39',NULL,'2026-02-20 09:52:39',NULL,NULL),(264,NULL,NULL,'73b1d025a2ec4fcf9911efe351e0aae8',NULL,NULL,NULL,NULL,'2026-02-20 09:52:39',NULL,'2026-02-20 09:52:39',NULL,NULL),(265,NULL,NULL,'05540725bf9747bab6e46350fc572572',NULL,NULL,NULL,NULL,'2026-02-20 09:52:40',NULL,'2026-02-20 09:52:40',NULL,NULL),(266,NULL,'a01ecec591e4404982cd5646732045d4',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:41',NULL,'2026-02-20 09:52:41',NULL,NULL),(267,NULL,'92d7d92293374948ad786f3b13b453fe',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:41',NULL,'2026-02-20 09:52:41',NULL,NULL),(268,NULL,'b992b40249e1433ebd0c3879368cad69',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:41',NULL,'2026-02-20 09:52:41',NULL,NULL),(269,NULL,NULL,'59c704509de14cf0a8028142e5378d9d',NULL,NULL,NULL,NULL,'2026-02-20 09:52:41',NULL,'2026-02-20 09:52:41',NULL,NULL),(270,NULL,'f738902a0e7849f7a633e93e85281b30',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:41',NULL,'2026-02-20 09:52:41',NULL,NULL),(271,NULL,'63be133347e0474685a43de12706ecde',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:42',NULL,'2026-02-20 09:52:42',NULL,NULL),(272,NULL,'4865f1881d8b4dcf847af795d37df24d',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:42',NULL,'2026-02-20 09:52:42',NULL,NULL),(273,NULL,NULL,'4df16f653f2d423189f72ee3a40fd434',NULL,NULL,NULL,NULL,'2026-02-20 09:52:43',NULL,'2026-02-20 09:52:43',NULL,NULL),(274,NULL,'a97fab8487e541e19123aeb77c5f108c',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:43',NULL,'2026-02-20 09:52:43',NULL,NULL),(275,NULL,NULL,'3aa63ab952c647a0acf5f3e6c76f536c',NULL,NULL,NULL,NULL,'2026-02-20 09:52:45',NULL,'2026-02-20 09:52:45',NULL,NULL),(276,NULL,'89fdb9662013472eafab8ad0bd81b0ad',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:45',NULL,'2026-02-20 09:52:45',NULL,NULL),(277,NULL,NULL,'2f23b1cd7ac74c3d90eca215bcdb7482',NULL,NULL,NULL,NULL,'2026-02-20 09:52:46',NULL,'2026-02-20 09:52:46',NULL,NULL),(278,NULL,NULL,'f5def4d1b9334a1f8d54e13209849359',NULL,NULL,NULL,NULL,'2026-02-20 09:52:46',NULL,'2026-02-20 09:52:46',NULL,NULL),(279,NULL,'8b57a45a7b434467bb3ae4ee6291f8d1',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:46',NULL,'2026-02-20 09:52:46',NULL,NULL),(280,NULL,NULL,'c297fe9381ae4aa49ffbfda92e11e0f1',NULL,NULL,NULL,NULL,'2026-02-20 09:52:47',NULL,'2026-02-20 09:52:47',NULL,NULL),(281,NULL,NULL,'de12668c64a14b3d961f87d1446cd3f7',NULL,NULL,NULL,NULL,'2026-02-20 09:52:47',NULL,'2026-02-20 09:52:47',NULL,NULL),(282,NULL,NULL,'6af5636a9b974a5189ea1dfb9c5867a6',NULL,NULL,NULL,NULL,'2026-02-20 09:52:47',NULL,'2026-02-20 09:52:47',NULL,NULL),(283,NULL,'94b4240ecbef4c759f1108433621dba9',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:48',NULL,'2026-02-20 09:52:48',NULL,NULL),(284,NULL,'ca1bfffabed04c6d8fc33cdd0ddf56a4',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:48',NULL,'2026-02-20 09:52:48',NULL,NULL),(285,NULL,NULL,'483a11a9f3c441b485d3e01daf9f451d',NULL,NULL,NULL,NULL,'2026-02-20 09:52:48',NULL,'2026-02-20 09:52:48',NULL,NULL),(286,NULL,'716274ca239744e28e8227f5171775d3',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:49',NULL,'2026-02-20 09:52:49',NULL,NULL),(287,NULL,'f1ed1eea11544164a9873856ff8d5e2d',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:49',NULL,'2026-02-20 09:52:49',NULL,NULL),(288,NULL,'96d46eb9c15e4889b37ab33f6d50fe85',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:50',NULL,'2026-02-20 09:52:50',NULL,NULL),(289,NULL,'f5544902e8be4737a10cc30d4533cbe2',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:51',NULL,'2026-02-20 09:52:51',NULL,NULL),(290,NULL,NULL,'1a288dffab64485e98e1aad1d53a4604',NULL,NULL,NULL,NULL,'2026-02-20 09:52:52',NULL,'2026-02-20 09:52:52',NULL,NULL),(291,NULL,NULL,'c918164fe36c48e5a65c4a714da9e960',NULL,NULL,NULL,NULL,'2026-02-20 09:52:53',NULL,'2026-02-20 09:52:53',NULL,NULL),(292,NULL,NULL,'a841ba3a3ca64121bcf6a4e9585eb2af',NULL,NULL,NULL,NULL,'2026-02-20 09:52:53',NULL,'2026-02-20 09:52:53',NULL,NULL),(293,NULL,'1fe05cc0cef541b58a817c91bdaa1531',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:53',NULL,'2026-02-20 09:52:53',NULL,NULL),(294,NULL,'9127393608f84bda9ebaa9e35b750f5c',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:54',NULL,'2026-02-20 09:52:54',NULL,NULL),(295,NULL,NULL,'807ed3a56f774f98a6d433fc471177cb',NULL,NULL,NULL,NULL,'2026-02-20 09:52:56',NULL,'2026-02-20 09:52:56',NULL,NULL),(296,NULL,NULL,'2c7bf99080a34bb0b9ae9453f2d3edf7',NULL,NULL,NULL,NULL,'2026-02-20 09:52:56',NULL,'2026-02-20 09:52:56',NULL,NULL),(297,NULL,NULL,'cdc9f427b25a412d9f801efaa8c1589c',NULL,NULL,NULL,NULL,'2026-02-20 09:52:56',NULL,'2026-02-20 09:52:56',NULL,NULL),(298,NULL,'0f1067a041c146f59d974a8dc6fe84a2',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:56',NULL,'2026-02-20 09:52:56',NULL,NULL),(299,NULL,'f1a90e5bcd0f46cd8ae5b7749e071be6',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:57',NULL,'2026-02-20 09:52:57',NULL,NULL),(300,NULL,'46a8d5e311514f7a99bc2346d68701ea',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:58',NULL,'2026-02-20 09:52:58',NULL,NULL),(301,NULL,NULL,'99f87f591a9a49ab9dbbe1a4e4a432bb',NULL,NULL,NULL,NULL,'2026-02-20 09:52:58',NULL,'2026-02-20 09:52:58',NULL,NULL),(302,NULL,NULL,'9b5edcaf5d0f48eea2ef440e3b3c2f79',NULL,NULL,NULL,NULL,'2026-02-20 09:52:59',NULL,'2026-02-20 09:52:59',NULL,NULL),(303,NULL,NULL,'edd6ca8fedfb4b75bd0882f466361f5d',NULL,NULL,NULL,NULL,'2026-02-20 09:52:59',NULL,'2026-02-20 09:52:59',NULL,NULL),(304,NULL,NULL,'a63d5010049c492d8e0a00ad37988002',NULL,NULL,NULL,NULL,'2026-02-20 09:52:59',NULL,'2026-02-20 09:52:59',NULL,NULL),(305,NULL,NULL,'2b3b35a8bbff4daba3271846f1f87c38',NULL,NULL,NULL,NULL,'2026-02-20 09:52:59',NULL,'2026-02-20 09:52:59',NULL,NULL),(306,NULL,'2039424f830e4ef5aa461223cac1ffd5',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:52:59',NULL,'2026-02-20 09:52:59',NULL,NULL),(307,NULL,NULL,'98e793e5bb9b40dbb7935c68bfd824fe',NULL,NULL,NULL,NULL,'2026-02-20 09:53:00',NULL,'2026-02-20 09:53:00',NULL,NULL),(308,NULL,'559420fb58b44b89b25b7207ac03358a',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:00',NULL,'2026-02-20 09:53:00',NULL,NULL),(309,NULL,NULL,'5589ff6f2908434e896dc69f9b16d464',NULL,NULL,NULL,NULL,'2026-02-20 09:53:00',NULL,'2026-02-20 09:53:00',NULL,NULL),(310,NULL,'85741ccf160049968710bbf0d3ed7a21',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:00',NULL,'2026-02-20 09:53:00',NULL,NULL),(311,NULL,'1912094b79b7458d948f9c005e08fee7',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:00',NULL,'2026-02-20 09:53:00',NULL,NULL),(312,NULL,'30dc834268f04c9eaec944bf2d7adf44',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:00',NULL,'2026-02-20 09:53:00',NULL,NULL),(313,NULL,'56f5db641c4449c3a560ee0779071eef',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:01',NULL,'2026-02-20 09:53:01',NULL,NULL),(314,NULL,NULL,'c5defcfc073c4a05a15575def0f66a1b',NULL,NULL,NULL,NULL,'2026-02-20 09:53:01',NULL,'2026-02-20 09:53:01',NULL,NULL),(315,NULL,NULL,'9f2a32573c0646e6af35e4805c1eb4f5',NULL,NULL,NULL,NULL,'2026-02-20 09:53:01',NULL,'2026-02-20 09:53:01',NULL,NULL),(316,NULL,'df17a45008e849ada20047837e697ddf',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:01',NULL,'2026-02-20 09:53:01',NULL,NULL),(317,NULL,'45149b1c1fd24de8a43d5c304de045c1',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:01',NULL,'2026-02-20 09:53:01',NULL,NULL),(318,NULL,'7c0293622f3c48328b57a1b3e89ceab9',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:02',NULL,'2026-02-20 09:53:02',NULL,NULL),(319,NULL,'232815c0dca445c9828c65f0b051417f',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:03',NULL,'2026-02-20 09:53:03',NULL,NULL),(320,NULL,NULL,'86c42cefdfeb4e67b420881b14035eae',NULL,NULL,NULL,NULL,'2026-02-20 09:53:04',NULL,'2026-02-20 09:53:04',NULL,NULL),(321,NULL,NULL,'d2cef4a573d54e1c9376415c1a4c4bd2',NULL,NULL,NULL,NULL,'2026-02-20 09:53:04',NULL,'2026-02-20 09:53:04',NULL,NULL),(322,NULL,NULL,'f0cdfdb3f84a479b96924215b120f6f2',NULL,NULL,NULL,NULL,'2026-02-20 09:53:04',NULL,'2026-02-20 09:53:04',NULL,NULL),(323,NULL,'9ff8580795fd4b7585817fc52a7865d5',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:05',NULL,'2026-02-20 09:53:05',NULL,NULL),(324,NULL,'feec271d9a994eccac92ec183428e94d',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:05',NULL,'2026-02-20 09:53:05',NULL,NULL),(325,NULL,'05c8d74b230b4c34b9ffd201b0228119',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:05',NULL,'2026-02-20 09:53:05',NULL,NULL),(326,NULL,'4585b22184184db9b2c8bd8bf2ff49fe',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:05',NULL,'2026-02-20 09:53:05',NULL,NULL),(327,NULL,NULL,'7df1aa2147ff49d58bca4da97c96df7c',NULL,NULL,NULL,NULL,'2026-02-20 09:53:05',NULL,'2026-02-20 09:53:05',NULL,NULL),(328,NULL,NULL,'28a12daa42c74a7782476038dff04ea8',NULL,NULL,NULL,NULL,'2026-02-20 09:53:05',NULL,'2026-02-20 09:53:05',NULL,NULL),(329,NULL,NULL,'79a209affff84767acd7524416e6d82c',NULL,NULL,NULL,NULL,'2026-02-20 09:53:05',NULL,'2026-02-20 09:53:05',NULL,NULL),(330,NULL,NULL,'8ec1cb9de6ca45168ba1e9b255de4840',NULL,NULL,NULL,NULL,'2026-02-20 09:53:05',NULL,'2026-02-20 09:53:05',NULL,NULL),(331,NULL,'9827594b481f4f26bc755948dfa2e29c',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:05',NULL,'2026-02-20 09:53:05',NULL,NULL),(332,NULL,'ed5a49838d7c49eeace4fd8bfe3ac464',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:06',NULL,'2026-02-20 09:53:06',NULL,NULL),(333,NULL,'02b2e5a707b64d948a63d876400e8673',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:06',NULL,'2026-02-20 09:53:06',NULL,NULL),(334,NULL,NULL,'de6d0195405c4a3b88d76aa28abfe2e9',NULL,NULL,NULL,NULL,'2026-02-20 09:53:07',NULL,'2026-02-20 09:53:07',NULL,NULL),(335,NULL,NULL,'b2736ff8a9fb49c580291eb8b1b6c715',NULL,NULL,NULL,NULL,'2026-02-20 09:53:07',NULL,'2026-02-20 09:53:07',NULL,NULL),(336,NULL,'d47ce7e9b3934175ba71d0010891510f',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:07',NULL,'2026-02-20 09:53:07',NULL,NULL),(337,NULL,'cc1748de1c384334a45295868cb000f1',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:07',NULL,'2026-02-20 09:53:07',NULL,NULL),(338,NULL,'9b8dbef2c546460faa27766650a9611d',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:08',NULL,'2026-02-20 09:53:08',NULL,NULL),(339,NULL,NULL,'0b2afdc61fd040a48e510c7935bb60e6',NULL,NULL,NULL,NULL,'2026-02-20 09:53:08',NULL,'2026-02-20 09:53:08',NULL,NULL),(340,NULL,'2c482727c2874bbcb3f021d06b0eda5e',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:08',NULL,'2026-02-20 09:53:08',NULL,NULL),(341,NULL,'fa30088c6eaa432bac6e44bf0ca2b997',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:08',NULL,'2026-02-20 09:53:08',NULL,NULL),(342,NULL,'27b1638b715a45c0a736f04b6bfe344f',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:09',NULL,'2026-02-20 09:53:09',NULL,NULL),(343,NULL,'109b8b521f0c4b0e811c3f9cd94f2fec',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:09',NULL,'2026-02-20 09:53:09',NULL,NULL),(344,NULL,NULL,'05a754fc1e384392acdae3e9f913b272',NULL,NULL,NULL,NULL,'2026-02-20 09:53:10',NULL,'2026-02-20 09:53:10',NULL,NULL),(345,NULL,NULL,'00529b63b82a4e528171a0e8865b35bf',NULL,NULL,NULL,NULL,'2026-02-20 09:53:11',NULL,'2026-02-20 09:53:11',NULL,NULL),(346,NULL,'cae1c7ffb5614e35a64d6e2e6d4fbb77',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:11',NULL,'2026-02-20 09:53:11',NULL,NULL),(347,NULL,NULL,'e4a1a33d1f5d46f9b3bd40e6505e25d0',NULL,NULL,NULL,NULL,'2026-02-20 09:53:12',NULL,'2026-02-20 09:53:12',NULL,NULL),(348,NULL,NULL,'c1221994c5de4cff9859674ab2192330',NULL,NULL,NULL,NULL,'2026-02-20 09:53:12',NULL,'2026-02-20 09:53:12',NULL,NULL),(349,NULL,NULL,'26aaed62153248ce8311030078f4d3cc',NULL,NULL,NULL,NULL,'2026-02-20 09:53:13',NULL,'2026-02-20 09:53:13',NULL,NULL),(350,NULL,NULL,NULL,NULL,NULL,'00a6e7d9adf04d8faeca070943ce45bc',NULL,'2026-02-20 09:53:13',NULL,'2026-02-20 09:53:13',NULL,NULL),(351,NULL,NULL,NULL,NULL,NULL,'27c66eac2dd14eab991cf436608cc19f',NULL,'2026-02-20 09:53:13',NULL,'2026-02-20 09:53:13',NULL,NULL),(352,NULL,'4a6fa5b6641549168c79044caeacf650',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:13',NULL,'2026-02-20 09:53:13',NULL,NULL),(353,NULL,NULL,NULL,NULL,NULL,'95e558804c09470cb3ebf9bf79de2526',NULL,'2026-02-20 09:53:14',NULL,'2026-02-20 09:53:14',NULL,NULL),(354,NULL,NULL,NULL,NULL,NULL,'f70179aa44a94aa49229e73742a883a5',NULL,'2026-02-20 09:53:14',NULL,'2026-02-20 09:53:14',NULL,NULL),(355,NULL,NULL,NULL,NULL,NULL,'2f823396eeb14670b475bc0f63702e90',NULL,'2026-02-20 09:53:14',NULL,'2026-02-20 09:53:14',NULL,NULL),(356,NULL,NULL,'589d04ea048a4d41bce152f4a28b3876',NULL,NULL,NULL,NULL,'2026-02-20 09:53:14',NULL,'2026-02-20 09:53:14',NULL,NULL),(357,NULL,'82b5f54ce39b47449fff0e943000cd94',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:14',NULL,'2026-02-20 09:53:14',NULL,NULL),(358,NULL,NULL,'d800f25239104c6ea0e163668e73ed31',NULL,NULL,NULL,NULL,'2026-02-20 09:53:14',NULL,'2026-02-20 09:53:14',NULL,NULL),(359,NULL,'f47ba50928db4e1aa57ddb6425ba62c6',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:14',NULL,'2026-02-20 09:53:14',NULL,NULL),(360,NULL,'948f26af0cbc4e598101f40af1d59305',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:15',NULL,'2026-02-20 09:53:15',NULL,NULL),(361,NULL,'520c55cc26b941f4ad3deacc72bb90cb',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:15',NULL,'2026-02-20 09:53:15',NULL,NULL),(362,NULL,NULL,NULL,NULL,'2ddbe2fbcaf749b3816549d5730a088e',NULL,NULL,'2026-02-20 09:53:15',NULL,'2026-02-20 09:53:15',NULL,NULL),(363,NULL,'af71ba6a9ef34b3c9fcf419581ccf2bd',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:15',NULL,'2026-02-20 09:53:15',NULL,NULL),(364,NULL,'8f62023cc78547d3af07b828aafe0f14',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:15',NULL,'2026-02-20 09:53:15',NULL,NULL),(365,NULL,NULL,'8e8a47948da14fa79603d76dd2981b20',NULL,NULL,NULL,NULL,'2026-02-20 09:53:16',NULL,'2026-02-20 09:53:16',NULL,NULL),(366,NULL,'f8f5d88754be4a78b8976c3abb7405e1',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:16',NULL,'2026-02-20 09:53:16',NULL,NULL),(367,NULL,'8b7d10e9b7684574b1405c8b3bc18ee0',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:16',NULL,'2026-02-20 09:53:16',NULL,NULL),(368,NULL,NULL,'75db5ce82b3346aa952f2961f37a5edb',NULL,NULL,NULL,NULL,'2026-02-20 09:53:17',NULL,'2026-02-20 09:53:17',NULL,NULL),(369,NULL,'725e6854982b4715bf3e7c68ba59db16',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:17',NULL,'2026-02-20 09:53:17',NULL,NULL),(370,NULL,NULL,'6f12d63b7bd54930bd7e76948e78eaaa',NULL,NULL,NULL,NULL,'2026-02-20 09:53:18',NULL,'2026-02-20 09:53:18',NULL,NULL),(371,NULL,NULL,NULL,NULL,'3a53380957124ee2b3fbb628c2ca73a5',NULL,NULL,'2026-02-20 09:53:18',NULL,'2026-02-20 09:53:18',NULL,NULL),(372,NULL,NULL,'81c597cc8d234617ba21854e6c5723ce',NULL,NULL,NULL,NULL,'2026-02-20 09:53:19',NULL,'2026-02-20 09:53:19',NULL,NULL),(373,NULL,'3ded6f55ddd741d2af327dd944e93d60',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:19',NULL,'2026-02-20 09:53:19',NULL,NULL),(374,NULL,'e634faa443de4a58b1abd3374961fb13',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:19',NULL,'2026-02-20 09:53:19',NULL,NULL),(375,NULL,NULL,'ec8a3c313dc64436acc2015ed5ca6f1d',NULL,NULL,NULL,NULL,'2026-02-20 09:53:19',NULL,'2026-02-20 09:53:19',NULL,NULL),(376,NULL,'ce58f35e37ff44ae99324c9eac0429a9',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:19',NULL,'2026-02-20 09:53:19',NULL,NULL),(377,NULL,'c1eba5e1292143089efc10860a4d74fe',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:19',NULL,'2026-02-20 09:53:19',NULL,NULL),(378,NULL,NULL,'011068f3519e4b3e9565893ca6b6d8d4',NULL,NULL,NULL,NULL,'2026-02-20 09:53:19',NULL,'2026-02-20 09:53:19',NULL,NULL),(379,NULL,NULL,'467ffa10d1f64aaa9696c8e6811249ea',NULL,NULL,NULL,NULL,'2026-02-20 09:53:19',NULL,'2026-02-20 09:53:19',NULL,NULL),(380,NULL,NULL,'c7fa7e4844f842879139333643fa21ca',NULL,NULL,NULL,NULL,'2026-02-20 09:53:20',NULL,'2026-02-20 09:53:20',NULL,NULL),(381,NULL,'5ceb06a838504815b25cba2f3a349263',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:20',NULL,'2026-02-20 09:53:20',NULL,NULL),(382,NULL,NULL,'1f007f5795e7431ebfa9ace80b04e089',NULL,NULL,NULL,NULL,'2026-02-20 09:53:20',NULL,'2026-02-20 09:53:20',NULL,NULL),(383,NULL,'6fb46337a98045f28d6f0ad918c6aa76',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:20',NULL,'2026-02-20 09:53:20',NULL,NULL),(384,NULL,'458d0fb409744521aa6a39760fb2b246',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:21',NULL,'2026-02-20 09:53:21',NULL,NULL),(385,NULL,'3b900c4e233641fa891ddc24ef24a2af',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:21',NULL,'2026-02-20 09:53:21',NULL,NULL),(386,NULL,'4f4245b606b046e3a9baae8791f2dc77',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:21',NULL,'2026-02-20 09:53:21',NULL,NULL),(387,NULL,NULL,'e2632157dc4c45fa8e2633d134150d5e',NULL,NULL,NULL,NULL,'2026-02-20 09:53:22',NULL,'2026-02-20 09:53:22',NULL,NULL),(388,NULL,'d03de7bac2e24a98a25620c3d6717694',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:22',NULL,'2026-02-20 09:53:22',NULL,NULL),(389,NULL,NULL,'eab28fccca6a48139a7d8b395d8f0b9a',NULL,NULL,NULL,NULL,'2026-02-20 09:53:22',NULL,'2026-02-20 09:53:22',NULL,NULL),(390,NULL,NULL,NULL,NULL,'efb5b5ff9fdd4af4b4a8d61655071480',NULL,NULL,'2026-02-20 09:53:23',NULL,'2026-02-20 09:53:23',NULL,NULL),(391,NULL,NULL,'e54c0e54ca9f4fb1a4411ea9a5b323c3',NULL,NULL,NULL,NULL,'2026-02-20 09:53:23',NULL,'2026-02-20 09:53:23',NULL,NULL),(392,NULL,NULL,'a728775ccc3f4baeb149411ffcc48a0b',NULL,NULL,NULL,NULL,'2026-02-20 09:53:23',NULL,'2026-02-20 09:53:23',NULL,NULL),(393,NULL,NULL,'1fb32614575b41da8d136432b3beff43',NULL,NULL,NULL,NULL,'2026-02-20 09:53:24',NULL,'2026-02-20 09:53:24',NULL,NULL),(394,NULL,'dc182b0a7cbb4e47b6b88befc2c48022',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:24',NULL,'2026-02-20 09:53:24',NULL,NULL),(395,NULL,'6b98ddcbaec94d65bc12cd130ec5a763',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:24',NULL,'2026-02-20 09:53:24',NULL,NULL),(396,NULL,'954c9bfb1dda4ebca46181a3de56cf97',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:26',NULL,'2026-02-20 09:53:26',NULL,NULL),(397,NULL,'54f4e8be4b5743c6b9a2e63020803c09',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:26',NULL,'2026-02-20 09:53:26',NULL,NULL),(398,NULL,'e8f25eb3708b4f42859c0f80fc60a524',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:26',NULL,'2026-02-20 09:53:26',NULL,NULL),(399,NULL,NULL,'f030f47f60254900924042f473738276',NULL,NULL,NULL,NULL,'2026-02-20 09:53:26',NULL,'2026-02-20 09:53:26',NULL,NULL),(400,NULL,NULL,'95adebefb82e49e698152d157798cadf',NULL,NULL,NULL,NULL,'2026-02-20 09:53:26',NULL,'2026-02-20 09:53:26',NULL,NULL),(401,NULL,NULL,'253c13edd6b940a9b5cd64cc7bfa0ff5',NULL,NULL,NULL,NULL,'2026-02-20 09:53:26',NULL,'2026-02-20 09:53:26',NULL,NULL),(402,NULL,'5310d1e603ed4b588919a4807befe156',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:27',NULL,'2026-02-20 09:53:27',NULL,NULL),(403,NULL,NULL,'9fb47c09921447e4b1f4c334048a6d72',NULL,NULL,NULL,NULL,'2026-02-20 09:53:27',NULL,'2026-02-20 09:53:27',NULL,NULL),(404,NULL,'2026367a006c4896ac12adb929526cd5',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:27',NULL,'2026-02-20 09:53:27',NULL,NULL),(405,NULL,NULL,'7bb9aac9f31341e0ac1ced86c02ad0f5',NULL,NULL,NULL,NULL,'2026-02-20 09:53:28',NULL,'2026-02-20 09:53:28',NULL,NULL),(406,NULL,NULL,'5ce7b6d6cadc43548d1ea3281ea05517',NULL,NULL,NULL,NULL,'2026-02-20 09:53:28',NULL,'2026-02-20 09:53:28',NULL,NULL),(407,NULL,NULL,'4355976f59e24bb78e334921bdb07f2a',NULL,NULL,NULL,NULL,'2026-02-20 09:53:28',NULL,'2026-02-20 09:53:28',NULL,NULL),(408,NULL,'bae77758d77d4d43af7ac10744892742',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:28',NULL,'2026-02-20 09:53:28',NULL,NULL),(409,NULL,NULL,'4355976f59e24bb78e334921bdb07f2a',NULL,NULL,NULL,NULL,'2026-02-20 09:53:29',NULL,'2026-02-20 09:53:29',NULL,NULL),(410,NULL,'82c04c1b3fb0491dbd152d505c46a751',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:29',NULL,'2026-02-20 09:53:29',NULL,NULL),(411,NULL,NULL,'5ce7b6d6cadc43548d1ea3281ea05517',NULL,NULL,NULL,NULL,'2026-02-20 09:53:29',NULL,'2026-02-20 09:53:29',NULL,NULL),(412,NULL,NULL,'7bb9aac9f31341e0ac1ced86c02ad0f5',NULL,NULL,NULL,NULL,'2026-02-20 09:53:29',NULL,'2026-02-20 09:53:29',NULL,NULL),(413,NULL,'6f60cf86f3014682a6d9be9f220909bf',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:30',NULL,'2026-02-20 09:53:30',NULL,NULL),(414,NULL,NULL,'45dedc62c7e64717a5b6427bdf2d38bd',NULL,NULL,NULL,NULL,'2026-02-20 09:53:30',NULL,'2026-02-20 09:53:30',NULL,NULL),(415,NULL,NULL,NULL,NULL,'45729a973eef42cf9454cd565d67acbe',NULL,NULL,'2026-02-20 09:53:31',NULL,'2026-02-20 09:53:31',NULL,NULL),(416,NULL,NULL,'c81440be27b3476a9d4319265176bfc5',NULL,NULL,NULL,NULL,'2026-02-20 09:53:32',NULL,'2026-02-20 09:53:32',NULL,NULL),(417,NULL,'fbc8f40c2dda4621ade90218d31e6a98',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:32',NULL,'2026-02-20 09:53:32',NULL,NULL),(418,NULL,NULL,'6ac3575303db41bb80325dd9496c1c56',NULL,NULL,NULL,NULL,'2026-02-20 09:53:33',NULL,'2026-02-20 09:53:33',NULL,NULL),(419,NULL,'f62ade8f427543b596b1df51c34b632a',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:33',NULL,'2026-02-20 09:53:33',NULL,NULL),(420,NULL,'d0800dc96487481d8188f8ab4b4df1d0',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:33',NULL,'2026-02-20 09:53:33',NULL,NULL),(421,NULL,NULL,'4d409f7b2160466a9f2333c36ca76ce4',NULL,NULL,NULL,NULL,'2026-02-20 09:53:34',NULL,'2026-02-20 09:53:34',NULL,NULL),(422,NULL,NULL,'2c2319ebde3042f2b9e9626551a9baab',NULL,NULL,NULL,NULL,'2026-02-20 09:53:34',NULL,'2026-02-20 09:53:34',NULL,NULL),(423,NULL,NULL,NULL,NULL,'ad8771eff39e4aa4865181350f7183a3',NULL,NULL,'2026-02-20 09:53:34',NULL,'2026-02-20 09:53:34',NULL,NULL),(424,NULL,NULL,'df5d0d87f6f2453dbe999712d1ce0129',NULL,NULL,NULL,NULL,'2026-02-20 09:53:35',NULL,'2026-02-20 09:53:35',NULL,NULL),(425,NULL,'0aef41e99209423d87c199be49925c68',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:35',NULL,'2026-02-20 09:53:35',NULL,NULL),(426,NULL,NULL,'9bb5d5099f6d4119b8dc64f00a14fca6',NULL,NULL,NULL,NULL,'2026-02-20 09:53:35',NULL,'2026-02-20 09:53:35',NULL,NULL),(427,NULL,NULL,'c4d44dd619dd4f3692316b30d3929879',NULL,NULL,NULL,NULL,'2026-02-20 09:53:35',NULL,'2026-02-20 09:53:35',NULL,NULL),(428,NULL,NULL,'e3c1dddc9d06411d819ac846d5acd6ab',NULL,NULL,NULL,NULL,'2026-02-20 09:53:35',NULL,'2026-02-20 09:53:35',NULL,NULL),(429,NULL,NULL,'7170b439acd34d0b8c2d190d8a3f7746',NULL,NULL,NULL,NULL,'2026-02-20 09:53:35',NULL,'2026-02-20 09:53:35',NULL,NULL),(430,NULL,NULL,'c65b834dce6d43d8bb9d3e2231cc87fa',NULL,NULL,NULL,NULL,'2026-02-20 09:53:36',NULL,'2026-02-20 09:53:36',NULL,NULL),(431,NULL,'a69b4edf41b04dc1ba1e641a28f4ec14',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:36',NULL,'2026-02-20 09:53:36',NULL,NULL),(432,NULL,NULL,'945c7903a05c4b26bd0f26bad77773be',NULL,NULL,NULL,NULL,'2026-02-20 09:53:37',NULL,'2026-02-20 09:53:37',NULL,NULL),(433,NULL,'22430c84f89843eaaed2cea0cfd5caf1',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:37',NULL,'2026-02-20 09:53:37',NULL,NULL),(434,NULL,'7b82614c298445fc89e1d60f959ed0d3',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:37',NULL,'2026-02-20 09:53:37',NULL,NULL),(435,NULL,'1053150200d149f68452065ec8cacf54',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:38',NULL,'2026-02-20 09:53:38',NULL,NULL),(436,NULL,'3812fd61bcbb4339aaccf620069ba51c',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:38',NULL,'2026-02-20 09:53:38',NULL,NULL),(437,NULL,'e2c509fefaf44bccb977cd25912129cd',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:38',NULL,'2026-02-20 09:53:38',NULL,NULL),(438,NULL,'cd1799583e4c4e64a88b562dd82079d3',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:38',NULL,'2026-02-20 09:53:38',NULL,NULL),(439,NULL,'75007688d77c439d8ee3fe7c58acf581',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:38',NULL,'2026-02-20 09:53:38',NULL,NULL),(440,NULL,'14a4a6e157cc4557b4097903901cbeb7',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:39',NULL,'2026-02-20 09:53:39',NULL,NULL),(441,NULL,NULL,'74ec09036905405484687a833101dcd0',NULL,NULL,NULL,NULL,'2026-02-20 09:53:40',NULL,'2026-02-20 09:53:40',NULL,NULL),(442,NULL,'c5a2540adf694dd98037b7689be10187',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:41',NULL,'2026-02-20 09:53:41',NULL,NULL),(443,NULL,NULL,'b3856d39b2a84a3c8e04c0a57c57b672',NULL,NULL,NULL,NULL,'2026-02-20 09:53:42',NULL,'2026-02-20 09:53:42',NULL,NULL),(444,NULL,NULL,'8d0dc3728a9c41e0853df8f713afdc0e',NULL,NULL,NULL,NULL,'2026-02-20 09:53:42',NULL,'2026-02-20 09:53:42',NULL,NULL),(445,NULL,'155e7d0c9b8248ae9e0956a58a201f20',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:42',NULL,'2026-02-20 09:53:42',NULL,NULL),(446,NULL,'d0cf2986dafe48d39cc54ef9db3ef002',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:43',NULL,'2026-02-20 09:53:43',NULL,NULL),(447,NULL,'4d4d5d5c8324469c858d37df26b3e5cd',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:43',NULL,'2026-02-20 09:53:43',NULL,NULL),(448,NULL,NULL,'152ebfb5ca2142d98decef6e6f4c341a',NULL,NULL,NULL,NULL,'2026-02-20 09:53:43',NULL,'2026-02-20 09:53:43',NULL,NULL),(449,NULL,'b05aa7ce68f64b30b2f0432168a91088',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:43',NULL,'2026-02-20 09:53:43',NULL,NULL),(450,NULL,NULL,'c96b0f745bd0402eabc4cc04f42c2637',NULL,NULL,NULL,NULL,'2026-02-20 09:53:43',NULL,'2026-02-20 09:53:43',NULL,NULL),(451,NULL,'99c45d01d3d6481fb3d7cb43d099714a',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:43',NULL,'2026-02-20 09:53:43',NULL,NULL),(452,NULL,NULL,'14e240fc765046b2b70e9edbfc158508',NULL,NULL,NULL,NULL,'2026-02-20 09:53:44',NULL,'2026-02-20 09:53:44',NULL,NULL),(453,NULL,'0b52313ffddc4ac89a4087e6f626e5db',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:44',NULL,'2026-02-20 09:53:44',NULL,NULL),(454,NULL,NULL,'14e240fc765046b2b70e9edbfc158508',NULL,NULL,NULL,NULL,'2026-02-20 09:53:44',NULL,'2026-02-20 09:53:44',NULL,NULL),(455,NULL,NULL,'bd6d93cef75a43be8ae56f60db044328',NULL,NULL,NULL,NULL,'2026-02-20 09:53:44',NULL,'2026-02-20 09:53:44',NULL,NULL),(456,NULL,'76e4df200fdd459eb3b5ed27efe9d786',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:44',NULL,'2026-02-20 09:53:44',NULL,NULL),(457,NULL,NULL,'9594f4caa08445378e5e9ec013d10465',NULL,NULL,NULL,NULL,'2026-02-20 09:53:44',NULL,'2026-02-20 09:53:44',NULL,NULL),(458,NULL,'505a3b536a90436cb042b1be1e04c86f',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:44',NULL,'2026-02-20 09:53:44',NULL,NULL),(459,NULL,NULL,'b197a709f5fa4609b806331bac25b161',NULL,NULL,NULL,NULL,'2026-02-20 09:53:45',NULL,'2026-02-20 09:53:45',NULL,NULL),(460,NULL,'d344ec763e0b4c828dbfbdddb74b372b',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:45',NULL,'2026-02-20 09:53:45',NULL,NULL),(461,NULL,'3fa036991f5044beb628d865544eeeee',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:45',NULL,'2026-02-20 09:53:45',NULL,NULL),(462,NULL,NULL,'2b985ff957904c969e4947853caad5e1',NULL,NULL,NULL,NULL,'2026-02-20 09:53:45',NULL,'2026-02-20 09:53:45',NULL,NULL),(463,NULL,'79fb73219f16435e8e4fa39d73696e36',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:45',NULL,'2026-02-20 09:53:45',NULL,NULL),(464,NULL,'29f7de553a8a45409a7dbd3ac888901f',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:45',NULL,'2026-02-20 09:53:45',NULL,NULL),(465,NULL,'a37a3f56cc7245a5a297048f83e5b18c',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:46',NULL,'2026-02-20 09:53:46',NULL,NULL),(466,NULL,'949f5c4c3b86408aacdc9e5ba3df49ff',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:46',NULL,'2026-02-20 09:53:46',NULL,NULL),(467,NULL,'a761beeacd544e19bd5c042e526ac2df',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:46',NULL,'2026-02-20 09:53:46',NULL,NULL),(468,NULL,'d7fb137f741b441b82559c9af9edb141',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:47',NULL,'2026-02-20 09:53:47',NULL,NULL),(469,NULL,'856527d71e3e4755b8ad5cc74acc8a7e',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:47',NULL,'2026-02-20 09:53:47',NULL,NULL),(470,NULL,'387a9745703947508b36665f549e9f38',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:47',NULL,'2026-02-20 09:53:47',NULL,NULL),(471,NULL,'4515bfdf821e4566ae0efb8cfe57ea97',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:47',NULL,'2026-02-20 09:53:47',NULL,NULL),(472,NULL,'d733fa838669439caaa1a0559e829e83',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:47',NULL,'2026-02-20 09:53:47',NULL,NULL),(473,NULL,'31d61e7765c94d76acd9915c811c32f9',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:47',NULL,'2026-02-20 09:53:47',NULL,NULL),(474,NULL,NULL,'d006159ec7e14564806eeab73e929288',NULL,NULL,NULL,NULL,'2026-02-20 09:53:48',NULL,'2026-02-20 09:53:48',NULL,NULL),(475,NULL,NULL,'ab09a4067bf940a4bab53aa602efd1fa',NULL,NULL,NULL,NULL,'2026-02-20 09:53:48',NULL,'2026-02-20 09:53:48',NULL,NULL),(476,NULL,'fdd9886d9d4a45248abf5675b8d30fb8',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:50',NULL,'2026-02-20 09:53:50',NULL,NULL),(477,NULL,NULL,'f5171bcc68614401b4b5522d63c6eb2d',NULL,NULL,NULL,NULL,'2026-02-20 09:53:51',NULL,'2026-02-20 09:53:51',NULL,NULL),(478,NULL,'583455a77eb74ca9812095b41813432f',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:51',NULL,'2026-02-20 09:53:51',NULL,NULL),(479,NULL,'979e10be5d944dbdb17d9bcb1757054f',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:52',NULL,'2026-02-20 09:53:52',NULL,NULL),(480,NULL,'410977b7b1de489eb5704edcb9bea39d',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:54',NULL,'2026-02-20 09:53:54',NULL,NULL),(481,NULL,NULL,'5ec9fd06567f4cd995bc8c160bf3aece',NULL,NULL,NULL,NULL,'2026-02-20 09:53:55',NULL,'2026-02-20 09:53:55',NULL,NULL),(482,NULL,'e4b49955eb4c4c9ab9be33a36568f9e9',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:55',NULL,'2026-02-20 09:53:55',NULL,NULL),(483,NULL,'2c001a8b39714c5eb819c106e2c96f29',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:55',NULL,'2026-02-20 09:53:55',NULL,NULL),(484,NULL,NULL,'f8db37020f51409783b5480beb8b59b6',NULL,NULL,NULL,NULL,'2026-02-20 09:53:56',NULL,'2026-02-20 09:53:56',NULL,NULL),(485,NULL,NULL,'3fad38d1ab574afbb80ade3ec9d3fb9e',NULL,NULL,NULL,NULL,'2026-02-20 09:53:56',NULL,'2026-02-20 09:53:56',NULL,NULL),(486,NULL,'bb245762d75747d1900a9eb35d52e1b4',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:56',NULL,'2026-02-20 09:53:56',NULL,NULL),(487,NULL,NULL,'2c595fd88263445a9adf19113b729817',NULL,NULL,NULL,NULL,'2026-02-20 09:53:56',NULL,'2026-02-20 09:53:56',NULL,NULL),(488,NULL,'b5639581a0da47fa9c7b87cc36f95c85',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:57',NULL,'2026-02-20 09:53:57',NULL,NULL),(489,NULL,NULL,'8f6e35e459464e75b0ac18f8a7a6c4ab',NULL,NULL,NULL,NULL,'2026-02-20 09:53:57',NULL,'2026-02-20 09:53:57',NULL,NULL),(490,NULL,NULL,'d713daba6ac745fa834b105a4d86a9b9',NULL,NULL,NULL,NULL,'2026-02-20 09:53:57',NULL,'2026-02-20 09:53:57',NULL,NULL),(491,NULL,'b8eba1ff02d14c78b1302c8524bb02a7',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:57',NULL,'2026-02-20 09:53:57',NULL,NULL),(492,NULL,'274f3ecccb8f4ba5aa27b7fea6e05d76',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:57',NULL,'2026-02-20 09:53:57',NULL,NULL),(493,NULL,NULL,'1cc69e79354f4d78b8c82b6a499e79c7',NULL,NULL,NULL,NULL,'2026-02-20 09:53:58',NULL,'2026-02-20 09:53:58',NULL,NULL),(494,NULL,NULL,'f2c5aba2dfe440adaa0f56831a998120',NULL,NULL,NULL,NULL,'2026-02-20 09:53:58',NULL,'2026-02-20 09:53:58',NULL,NULL),(495,NULL,'4d499bc785f34755b51f0f2b6d0d922c',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:58',NULL,'2026-02-20 09:53:58',NULL,NULL),(496,NULL,NULL,'1b2d25a511a14396a23c89999045cc74',NULL,NULL,NULL,NULL,'2026-02-20 09:53:58',NULL,'2026-02-20 09:53:58',NULL,NULL),(497,NULL,'8439bbb674344461a6c195225545c5e7',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:58',NULL,'2026-02-20 09:53:58',NULL,NULL),(498,NULL,'cacc9a39be574015af501a8392cac830',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:59',NULL,'2026-02-20 09:53:59',NULL,NULL),(499,NULL,'261998e921914cfaa49fda849e67ebcd',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:59',NULL,'2026-02-20 09:53:59',NULL,NULL),(500,NULL,NULL,'65d7191c9476471c8cdb2f7649a2ba25',NULL,NULL,NULL,NULL,'2026-02-20 09:53:59',NULL,'2026-02-20 09:53:59',NULL,NULL),(501,NULL,'c91094550bca41b8ac81e1aef3ebc3a4',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:59',NULL,'2026-02-20 09:53:59',NULL,NULL),(502,NULL,'9479b2674dd2487a81b5a6705ebcff8e',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:53:59',NULL,'2026-02-20 09:53:59',NULL,NULL),(503,NULL,'0ef9022e38e14c5fad80c67e02b6d3fc',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:00',NULL,'2026-02-20 09:54:00',NULL,NULL),(504,NULL,NULL,'65d7191c9476471c8cdb2f7649a2ba25',NULL,NULL,NULL,NULL,'2026-02-20 09:54:01',NULL,'2026-02-20 09:54:01',NULL,NULL),(505,NULL,'8240358f7d574d50aef97f107e7c2465',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:03',NULL,'2026-02-20 09:54:03',NULL,NULL),(506,NULL,NULL,'9bc122e9ad0d4668916a537f5bd3bafe',NULL,NULL,NULL,NULL,'2026-02-20 09:54:03',NULL,'2026-02-20 09:54:03',NULL,NULL),(507,NULL,NULL,'9070b4a1f1704bc5b839fbe50eee2de4',NULL,NULL,NULL,NULL,'2026-02-20 09:54:03',NULL,'2026-02-20 09:54:03',NULL,NULL),(508,NULL,NULL,'d9f21f669a9a43ad85407dd2c03eb601',NULL,NULL,NULL,NULL,'2026-02-20 09:54:03',NULL,'2026-02-20 09:54:03',NULL,NULL),(509,NULL,NULL,'93a14aab025b4092b593847aba8ff656',NULL,NULL,NULL,NULL,'2026-02-20 09:54:04',NULL,'2026-02-20 09:54:04',NULL,NULL),(510,NULL,'2d37fa028cb24c90b24b871bf6d567b3',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:04',NULL,'2026-02-20 09:54:04',NULL,NULL),(511,NULL,NULL,'832cb2520bcc416eaf0fc2266aa9083d',NULL,NULL,NULL,NULL,'2026-02-20 09:54:04',NULL,'2026-02-20 09:54:04',NULL,NULL),(512,NULL,NULL,'0a4e14e256584a019784c4bfae153191',NULL,NULL,NULL,NULL,'2026-02-20 09:54:04',NULL,'2026-02-20 09:54:04',NULL,NULL),(513,NULL,NULL,'64bc2abaa9894bcca40a23bf052330bc',NULL,NULL,NULL,NULL,'2026-02-20 09:54:05',NULL,'2026-02-20 09:54:05',NULL,NULL),(514,NULL,NULL,'cb1efc060021424da7492d88b1372270',NULL,NULL,NULL,NULL,'2026-02-20 09:54:05',NULL,'2026-02-20 09:54:05',NULL,NULL),(515,NULL,'bc11d7f253e548a281f7f8d1491ebd59',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:05',NULL,'2026-02-20 09:54:05',NULL,NULL),(516,NULL,'821f82de19be400fb9b06bed19192214',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:05',NULL,'2026-02-20 09:54:05',NULL,NULL),(517,NULL,'c7860ccf27ca4a11a4b9183b92c9b148',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:06',NULL,'2026-02-20 09:54:06',NULL,NULL),(518,NULL,'ce60501df1fc44a1a2fc8f303c91ae3f',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:06',NULL,'2026-02-20 09:54:06',NULL,NULL),(519,NULL,'ef23fabac7404d1683d096e1d5e36bc9',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:07',NULL,'2026-02-20 09:54:07',NULL,NULL),(520,NULL,'129e8b98540540668ea2525cd085cff9',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:07',NULL,'2026-02-20 09:54:07',NULL,NULL),(521,NULL,'fdd67a0b1d79454a888f737b76fddcc6',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:08',NULL,'2026-02-20 09:54:08',NULL,NULL),(522,NULL,NULL,'1b7c3cbbd99d45afacc974bc2e4cc532',NULL,NULL,NULL,NULL,'2026-02-20 09:54:10',NULL,'2026-02-20 09:54:10',NULL,NULL),(523,NULL,NULL,'755eb55caba940e6acb67e3260f0126c',NULL,NULL,NULL,NULL,'2026-02-20 09:54:10',NULL,'2026-02-20 09:54:10',NULL,NULL),(524,NULL,NULL,'07343b53efae42e4876b4ec35654709d',NULL,NULL,NULL,NULL,'2026-02-20 09:54:10',NULL,'2026-02-20 09:54:10',NULL,NULL),(525,NULL,NULL,'021e5846b896423b9fc9866d8ce0eb8a',NULL,NULL,NULL,NULL,'2026-02-20 09:54:10',NULL,'2026-02-20 09:54:10',NULL,NULL),(526,NULL,NULL,'e5f76f131b6c48edb83395f6786e89a6',NULL,NULL,NULL,NULL,'2026-02-20 09:54:11',NULL,'2026-02-20 09:54:11',NULL,NULL),(527,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:11',NULL,'2026-02-20 09:54:11','bIEdjcrvQYq6GiJz7TZmbA',NULL),(528,NULL,NULL,'eedc91db7da847aab912b3b8401d5b18',NULL,NULL,NULL,NULL,'2026-02-20 09:54:11',NULL,'2026-02-20 09:54:11',NULL,NULL),(529,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:12',NULL,'2026-02-20 09:54:12','BLhIlTYwQyO3n74sXtOiCw',NULL),(530,NULL,'608a5f1732c041cf96804145f5615041',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:12',NULL,'2026-02-20 09:54:12',NULL,NULL),(531,NULL,NULL,'420d71416bd4474eb4ce38a104bb089e',NULL,NULL,NULL,NULL,'2026-02-20 09:54:12',NULL,'2026-02-20 09:54:12',NULL,NULL),(532,NULL,NULL,'3d7a192aa2ae497da1675f3f05426bf3',NULL,NULL,NULL,NULL,'2026-02-20 09:54:12',NULL,'2026-02-20 09:54:12',NULL,NULL),(533,NULL,NULL,'15f5a81bd7a64726909c7e63609ad20f',NULL,NULL,NULL,NULL,'2026-02-20 09:54:12',NULL,'2026-02-20 09:54:12',NULL,NULL),(534,NULL,'22b016cf9f2d403d952239fb4ab79c4a',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:12',NULL,'2026-02-20 09:54:12',NULL,NULL),(535,NULL,NULL,'26b41f1ed37f4e228cad772a4c639bde',NULL,NULL,NULL,NULL,'2026-02-20 09:54:12',NULL,'2026-02-20 09:54:12',NULL,NULL),(536,NULL,'8d5c2f81bbf4423c8ccdbeb44081c499',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:12',NULL,'2026-02-20 09:54:12',NULL,NULL),(537,NULL,'3611c5dbf46b4a03ab2c51f7ac28fe16',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:13',NULL,'2026-02-20 09:54:13',NULL,NULL),(538,NULL,'7e33240811a14e919f954b4b6ca73f12',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:13',NULL,'2026-02-20 09:54:13',NULL,NULL),(539,NULL,'bc55c3aa40634fea8532112af737dcf3',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:14',NULL,'2026-02-20 09:54:14',NULL,NULL),(540,NULL,'ceda6d23d7184b90ba109505854d972f',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:14',NULL,'2026-02-20 09:54:14',NULL,NULL),(541,NULL,'15915fab43f044a5a898a0230d28d4a6',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:14',NULL,'2026-02-20 09:54:14',NULL,NULL),(542,NULL,'b9713eba7e71434baf0048802b1842ec',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:14',NULL,'2026-02-20 09:54:14',NULL,NULL),(543,NULL,'f6f4b5c911a6472790702991c91fd583',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:16',NULL,'2026-02-20 09:54:16',NULL,NULL),(544,NULL,NULL,'e05fecfd5c1249bc9944804c64c4b704',NULL,NULL,NULL,NULL,'2026-02-20 09:54:16',NULL,'2026-02-20 09:54:16',NULL,NULL),(545,NULL,NULL,'fe01e3377b31438abb8e561123221791',NULL,NULL,NULL,NULL,'2026-02-20 09:54:18',NULL,'2026-02-20 09:54:18',NULL,NULL),(546,NULL,'23fcf15a0b2c40c69e318e2ac5c1bf69',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:18',NULL,'2026-02-20 09:54:18',NULL,NULL),(547,NULL,NULL,'d2f1706fd4a9437f8523ce6391c369ca',NULL,NULL,NULL,NULL,'2026-02-20 09:54:18',NULL,'2026-02-20 09:54:18',NULL,NULL),(548,NULL,NULL,'9e30418a34374b23a3edd1340c14ec42',NULL,NULL,NULL,NULL,'2026-02-20 09:54:19',NULL,'2026-02-20 09:54:19',NULL,NULL),(549,NULL,NULL,'ee5420978e2a410f932df4d487e2d3bf',NULL,NULL,NULL,NULL,'2026-02-20 09:54:19',NULL,'2026-02-20 09:54:19',NULL,NULL),(550,NULL,NULL,'00699aa01e984cc2a6fa4522ce81db97',NULL,NULL,NULL,NULL,'2026-02-20 09:54:20',NULL,'2026-02-20 09:54:20',NULL,NULL),(551,NULL,NULL,'2719d438d7f748859137b8d94fff813a',NULL,NULL,NULL,NULL,'2026-02-20 09:54:20',NULL,'2026-02-20 09:54:20',NULL,NULL),(552,NULL,'5a6121127b5746ef881da8079ed570e3',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:20',NULL,'2026-02-20 09:54:20',NULL,NULL),(553,NULL,'5f45e6e5d5074c16a3ea381aae82ad05',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:20',NULL,'2026-02-20 09:54:20',NULL,NULL),(554,NULL,'8c84496e87d54d939f1a9220f3979a08',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:22',NULL,'2026-02-20 09:54:22',NULL,NULL),(555,NULL,'c11d214ddb8444b499694b7fa72c8896',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:23',NULL,'2026-02-20 09:54:23',NULL,NULL),(556,NULL,'2cd2604665c249e388b25f426fab82a0',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:23',NULL,'2026-02-20 09:54:23',NULL,NULL),(557,NULL,NULL,'124fec5084164515a4a8079d3fba8fba',NULL,NULL,NULL,NULL,'2026-02-20 09:54:24',NULL,'2026-02-20 09:54:24',NULL,NULL),(558,NULL,'9bd559cd404b4046a53b7e35bf2febcf',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:24',NULL,'2026-02-20 09:54:24',NULL,NULL),(559,NULL,NULL,'deba5a7b230145ecb3d7c8fd60d69f8e',NULL,NULL,NULL,NULL,'2026-02-20 09:54:24',NULL,'2026-02-20 09:54:24',NULL,NULL),(560,NULL,NULL,'b9d64681c327441a81dfa771b4b413f6',NULL,NULL,NULL,NULL,'2026-02-20 09:54:25',NULL,'2026-02-20 09:54:25',NULL,NULL),(561,NULL,NULL,'8fa8f82c387340ceb1e9f0b8aa55c24a',NULL,NULL,NULL,NULL,'2026-02-20 09:54:25',NULL,'2026-02-20 09:54:25',NULL,NULL),(562,NULL,'0d4c2b96a324436e80a9b37c9d4a15eb',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:25',NULL,'2026-02-20 09:54:25',NULL,NULL),(563,NULL,NULL,'149121084b8549b9b7719d474ff3d3b9',NULL,NULL,NULL,NULL,'2026-02-20 09:54:25',NULL,'2026-02-20 09:54:25',NULL,NULL),(564,NULL,'7af083ea5f674e96a95968f9d3fbdcbf',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:26',NULL,'2026-02-20 09:54:26',NULL,NULL),(565,NULL,'458875be70f94df19eb2f1cbd120a472',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:26',NULL,'2026-02-20 09:54:26',NULL,NULL),(566,NULL,NULL,'a7bf5bd2a08b40838819ba2189f49015',NULL,NULL,NULL,NULL,'2026-02-20 09:54:26',NULL,'2026-02-20 09:54:26',NULL,NULL),(567,NULL,'b7ef526d9e1e4325afc5a8eb7c2f52b5',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:27',NULL,'2026-02-20 09:54:27',NULL,NULL),(568,NULL,'ce97c44a73f94ada962654654798a4af',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:27',NULL,'2026-02-20 09:54:27',NULL,NULL),(569,NULL,'8affd803090342c7a0b4a8c10fbcda95',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:28',NULL,'2026-02-20 09:54:28',NULL,NULL),(570,NULL,NULL,'a0f16005115c49d5a3ea1e9947377baf',NULL,NULL,NULL,NULL,'2026-02-20 09:54:29',NULL,'2026-02-20 09:54:29',NULL,NULL),(571,NULL,NULL,'3c4b280a75974ae09cbb2a2f42b734d7',NULL,NULL,NULL,NULL,'2026-02-20 09:54:29',NULL,'2026-02-20 09:54:29',NULL,NULL),(572,NULL,'ed9b926f0ad24ab39adbd106db41d418',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:31',NULL,'2026-02-20 09:54:31',NULL,NULL),(573,NULL,NULL,'fbe1fd16e6494d9ab0758867c670f6d7',NULL,NULL,NULL,NULL,'2026-02-20 09:54:31',NULL,'2026-02-20 09:54:31',NULL,NULL),(574,NULL,'64d817f4a5c2403da529827627a872f8',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:32',NULL,'2026-02-20 09:54:32',NULL,NULL),(575,NULL,'37f3a6bc87f6409397be231ee64e60ef',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:32',NULL,'2026-02-20 09:54:32',NULL,NULL),(576,NULL,NULL,'dfcd63ef2e794202981b7a0b95c9b346',NULL,NULL,NULL,NULL,'2026-02-20 09:54:36',NULL,'2026-02-20 09:54:36',NULL,NULL),(577,NULL,NULL,'116ea22e3d194077965cf10095cfc97e',NULL,NULL,NULL,NULL,'2026-02-20 09:54:36',NULL,'2026-02-20 09:54:36',NULL,NULL),(578,NULL,NULL,'eed45d0e6e9a4013a0e822ffa85bb5cb',NULL,NULL,NULL,NULL,'2026-02-20 09:54:36',NULL,'2026-02-20 09:54:36',NULL,NULL),(579,NULL,'13f7a9ed49974d1596cd7746bdf2e7c4',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:37',NULL,'2026-02-20 09:54:37',NULL,NULL),(580,NULL,NULL,'2945bbe9734c42c9afc0279f56416c24',NULL,NULL,NULL,NULL,'2026-02-20 09:54:38',NULL,'2026-02-20 09:54:38',NULL,NULL),(581,NULL,NULL,'4933e6fe02114208b37150fff0451535',NULL,NULL,NULL,NULL,'2026-02-20 09:54:38',NULL,'2026-02-20 09:54:38',NULL,NULL),(582,NULL,'ab5759bbaa564deb8dd4562b5b319554',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:39',NULL,'2026-02-20 09:54:39',NULL,NULL),(583,NULL,NULL,'b4d515fc0e19452b83b92a6f0e943d09',NULL,NULL,NULL,NULL,'2026-02-20 09:54:39',NULL,'2026-02-20 09:54:39',NULL,NULL),(584,NULL,'da07bc46ff4f48aba964fa72f0bc8fad',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:39',NULL,'2026-02-20 09:54:39',NULL,NULL),(585,NULL,'1914e90a1dd542168f471550e9dd1772',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:39',NULL,'2026-02-20 09:54:39',NULL,NULL),(586,NULL,NULL,'27c27b2e003b45569cb3ddf45c5c298e',NULL,NULL,NULL,NULL,'2026-02-20 09:54:40',NULL,'2026-02-20 09:54:40',NULL,NULL),(587,NULL,'ac44e858291a43048fa669470213bbd2',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:41',NULL,'2026-02-20 09:54:41',NULL,NULL),(588,NULL,'7dd67ad2515b4bc0afe4284dcef8c0e4',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:41',NULL,'2026-02-20 09:54:41',NULL,NULL),(589,NULL,'416b8c7a0c6f48629bf55e44152bc962',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:42',NULL,'2026-02-20 09:54:42',NULL,NULL),(590,NULL,NULL,'4012510740974250883edae915874896',NULL,NULL,NULL,NULL,'2026-02-20 09:54:42',NULL,'2026-02-20 09:54:42',NULL,NULL),(591,NULL,'273cdd5fae3944c4aebe32b9b69f3c60',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:43',NULL,'2026-02-20 09:54:43',NULL,NULL),(592,NULL,NULL,'6895c7b578a84e70b8930d353f7aca11',NULL,NULL,NULL,NULL,'2026-02-20 09:54:45',NULL,'2026-02-20 09:54:45',NULL,NULL),(593,NULL,'c51e4736a75f4dc9a09a73b18284de25',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:54:47',NULL,'2026-02-20 09:54:47',NULL,NULL),(594,NULL,NULL,'bac5dc873cf242af8d334944b012ce0e',NULL,NULL,NULL,NULL,'2026-02-20 09:54:55',NULL,'2026-02-20 09:54:55',NULL,NULL),(595,NULL,NULL,'d89d4d1c90df43a18f75b47e31c78f62',NULL,NULL,NULL,NULL,'2026-02-20 09:54:58',NULL,'2026-02-20 09:54:58',NULL,NULL),(596,NULL,NULL,'1935b74df3bd425ea57131df429dec95',NULL,NULL,NULL,NULL,'2026-02-20 09:54:59',NULL,'2026-02-20 09:54:59',NULL,NULL),(597,NULL,NULL,'e73817fed2b8474880314d4f46489baf',NULL,NULL,NULL,NULL,'2026-02-20 09:54:59',NULL,'2026-02-20 09:54:59',NULL,NULL),(598,NULL,NULL,'030f7bfb48d5404cb5c2f144493c13ba',NULL,NULL,NULL,NULL,'2026-02-20 09:54:59',NULL,'2026-02-20 09:54:59',NULL,NULL),(599,NULL,'7365eb83b07c4401a5a58afb3f122ce5',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:55:00',NULL,'2026-02-20 09:55:00',NULL,NULL),(600,NULL,'1ef514b3ab6c43c3a1ab48c6d3fbec55',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:55:02',NULL,'2026-02-20 09:55:02',NULL,NULL),(601,NULL,'cbcf29f4bc7945cb826870ae745c76bf',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:55:04',NULL,'2026-02-20 09:55:04',NULL,NULL),(602,NULL,'1316406c3478480189948d89dc4f438c',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:55:06',NULL,'2026-02-20 09:55:06',NULL,NULL),(603,NULL,NULL,'abe93bcc83f4498e831f0715bfe0f7c0',NULL,NULL,NULL,NULL,'2026-02-20 09:55:08',NULL,'2026-02-20 09:55:08',NULL,NULL),(604,NULL,'45f4c6fc6dec41d0b297aea334ec0aab',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:55:11',NULL,'2026-02-20 09:55:11',NULL,NULL),(605,NULL,NULL,'be5d51cbafa3480e8f9376f3d3b04a13',NULL,NULL,NULL,NULL,'2026-02-20 09:55:14',NULL,'2026-02-20 09:55:14',NULL,NULL),(606,NULL,'f6ba84f4ecb24b5ea6108597d3e6092b',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:55:17',NULL,'2026-02-20 09:55:17',NULL,NULL),(607,NULL,NULL,'ffbb979ff9fb4e37a3cdbc9384522ee4',NULL,NULL,NULL,NULL,'2026-02-20 09:55:20',NULL,'2026-02-20 09:55:20',NULL,NULL),(608,NULL,NULL,'bab3cf417e2d400eb5320230f6ac57ef',NULL,NULL,NULL,NULL,'2026-02-20 09:55:20',NULL,'2026-02-20 09:55:20',NULL,NULL),(609,NULL,NULL,'d392efdee74e45ca9f272b0e644e3e43',NULL,NULL,NULL,NULL,'2026-02-20 09:55:21',NULL,'2026-02-20 09:55:21',NULL,NULL),(610,NULL,'128574ead2fb4d96acc712ee4a5124f2',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:55:22',NULL,'2026-02-20 09:55:22',NULL,NULL),(611,NULL,'6798281294ab4a609dca48c1a28c8d8f',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:55:23',NULL,'2026-02-20 09:55:23',NULL,NULL),(612,NULL,'dcc08d5e298941e3a9de201aa565b6a9',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:55:24',NULL,'2026-02-20 09:55:24',NULL,NULL),(613,NULL,'5c42a918d9c34655b137f97ce64f2c34',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:55:27',NULL,'2026-02-20 09:55:27',NULL,NULL),(614,NULL,NULL,'ebca8f3581eb42cfbc81f205cf69e4d2',NULL,NULL,NULL,NULL,'2026-02-20 09:55:28',NULL,'2026-02-20 09:55:28',NULL,NULL),(615,NULL,NULL,'e3aa7f0176e04aedb8d8aceeb3ce21b7',NULL,NULL,NULL,NULL,'2026-02-20 09:55:28',NULL,'2026-02-20 09:55:28',NULL,NULL),(616,NULL,NULL,'5f5cb06fd4c045b1bfc3f890392c3165',NULL,NULL,NULL,NULL,'2026-02-20 09:55:28',NULL,'2026-02-20 09:55:28',NULL,NULL),(617,NULL,'54500b20d6a643669fbf357242dde27f',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:55:30',NULL,'2026-02-20 09:55:30',NULL,NULL),(618,NULL,'b7e1b71084de4b67ae83639c1eb4464e',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:55:31',NULL,'2026-02-20 09:55:31',NULL,NULL),(619,NULL,'4a00c1dc15a341ddb63d82d69365a0b6',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:55:32',NULL,'2026-02-20 09:55:32',NULL,NULL),(620,NULL,NULL,'072b4079d4904227b521f86fa38de26a',NULL,NULL,NULL,NULL,'2026-02-20 09:55:32',NULL,'2026-02-20 09:55:32',NULL,NULL),(621,NULL,'1729f7b955e7449da747f049f9246b4a',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:55:33',NULL,'2026-02-20 09:55:33',NULL,NULL),(622,NULL,NULL,'0fbe314d170a44f881630a733cb5daf8',NULL,NULL,NULL,NULL,'2026-02-20 09:55:36',NULL,'2026-02-20 09:55:36',NULL,NULL),(623,NULL,NULL,'a6b2c0672e6a4322aa906e62594c393e',NULL,NULL,NULL,NULL,'2026-02-20 09:55:37',NULL,'2026-02-20 09:55:37',NULL,NULL),(624,NULL,NULL,'591409f3248041b4b1289e21ae84fd8c',NULL,NULL,NULL,NULL,'2026-02-20 09:55:38',NULL,'2026-02-20 09:55:38',NULL,NULL),(625,NULL,NULL,'d77a3a54194542cea0da733d5bb755b2',NULL,NULL,NULL,NULL,'2026-02-20 09:55:38',NULL,'2026-02-20 09:55:38',NULL,NULL),(626,NULL,'d764b05168774c37b0a1c84cc395c1ba',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:55:38',NULL,'2026-02-20 09:55:38',NULL,NULL),(627,NULL,'17f50febac1846c0a653b60a8f30a43a',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:55:40',NULL,'2026-02-20 09:55:40',NULL,NULL),(628,NULL,'4b504735df764fcd83bf56b5ede88da0',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:55:41',NULL,'2026-02-20 09:55:41',NULL,NULL),(629,NULL,'4bc4af96e2e04065980195d740f64a3c',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:55:42',NULL,'2026-02-20 09:55:42',NULL,NULL),(630,NULL,NULL,'22703561e4e749249e1767c4b50f67c8',NULL,NULL,NULL,NULL,'2026-02-20 09:55:45',NULL,'2026-02-20 09:55:45',NULL,NULL),(631,NULL,NULL,'914def70950f4804987f2feb830c011c',NULL,NULL,NULL,NULL,'2026-02-20 09:55:45',NULL,'2026-02-20 09:55:45',NULL,NULL),(632,NULL,NULL,'37f65b711ccf433f86420da7d18f479c',NULL,NULL,NULL,NULL,'2026-02-20 09:55:46',NULL,'2026-02-20 09:55:46',NULL,NULL),(633,NULL,'c1402ef18966427b97e92eecd02b7faf',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:55:48',NULL,'2026-02-20 09:55:48',NULL,NULL),(634,NULL,'0635b5dae1854e178484d0abec19ab72',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:55:49',NULL,'2026-02-20 09:55:49',NULL,NULL),(635,NULL,'a36841b4fa1f41e7a0ae0a7d7309df2b',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:55:50',NULL,'2026-02-20 09:55:50',NULL,NULL),(636,NULL,NULL,'061949b19d2146debcdb4e85c8db9eec',NULL,NULL,NULL,NULL,'2026-02-20 09:55:50',NULL,'2026-02-20 09:55:50',NULL,NULL),(637,NULL,NULL,'8bab24d278e441f982d809dc59188b78',NULL,NULL,NULL,NULL,'2026-02-20 09:55:52',NULL,'2026-02-20 09:55:52',NULL,NULL),(638,NULL,'b9f8945a2560410b988e395a1db7710f',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:55:52',NULL,'2026-02-20 09:55:52',NULL,NULL),(639,NULL,'7133be0a192449079d228e92f76602f4',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:55:54',NULL,'2026-02-20 09:55:54',NULL,NULL),(640,NULL,NULL,'7a847498e34a4755829111fb54b0632b',NULL,NULL,NULL,NULL,'2026-02-20 09:55:55',NULL,'2026-02-20 09:55:55',NULL,NULL),(641,NULL,'f1d88f620ed14a4da04788bf096bb225',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:55:58',NULL,'2026-02-20 09:55:58',NULL,NULL),(642,NULL,NULL,'8d032c6e05ba4d399a9e92d9fafd8ae7',NULL,NULL,NULL,NULL,'2026-02-20 09:56:07',NULL,'2026-02-20 09:56:07',NULL,NULL),(643,NULL,NULL,'c1930390ea784351b9366656b06dbbce',NULL,NULL,NULL,NULL,'2026-02-20 09:56:08',NULL,'2026-02-20 09:56:08',NULL,NULL),(644,NULL,NULL,'d3c55ea066964e709d397eba183f6d27',NULL,NULL,NULL,NULL,'2026-02-20 09:56:08',NULL,'2026-02-20 09:56:08',NULL,NULL),(645,NULL,'50be2d6048314f72aad782543bcc440d',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:56:10',NULL,'2026-02-20 09:56:10',NULL,NULL),(646,NULL,'d7955d22d06e423c85d7f4446caf63e8',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:56:11',NULL,'2026-02-20 09:56:11',NULL,NULL),(647,NULL,'ffe95c3ecb8041f08ab64f85fb74a65b',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:56:11',NULL,'2026-02-20 09:56:11',NULL,NULL),(648,NULL,NULL,'35bf19fc0896430baaf96bc10f70181f',NULL,NULL,NULL,NULL,'2026-02-20 09:56:21',NULL,'2026-02-20 09:56:21',NULL,NULL),(649,NULL,NULL,'6094994f24954c42ac628c0b09fe3743',NULL,NULL,NULL,NULL,'2026-02-20 09:56:21',NULL,'2026-02-20 09:56:21',NULL,NULL),(650,NULL,NULL,'83bbdc4881184842af17a2b303b05ab0',NULL,NULL,NULL,NULL,'2026-02-20 09:56:21',NULL,'2026-02-20 09:56:21',NULL,NULL),(651,NULL,'e4af5e16f87745d09f03d57282c7c863',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:56:24',NULL,'2026-02-20 09:56:24',NULL,NULL),(652,NULL,'1eff39cdacfd4eb28de1fa5742b73d15',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:56:26',NULL,'2026-02-20 09:56:26',NULL,NULL),(653,NULL,NULL,'51a4789e7d0b404b9882e0c26f7229be',NULL,NULL,NULL,NULL,'2026-02-20 09:56:26',NULL,'2026-02-20 09:56:26',NULL,NULL),(654,NULL,'8b33a3c1c64247628d4927f39794f13e',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:56:27',NULL,'2026-02-20 09:56:27',NULL,NULL),(655,NULL,'1c44e13adebb4610b7c0cd2fdc62a5b7',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:56:28',NULL,'2026-02-20 09:56:28',NULL,NULL),(656,NULL,NULL,'e63c107842b244d4b2348405ac02dcc4',NULL,NULL,NULL,NULL,'2026-02-20 09:56:30',NULL,'2026-02-20 09:56:30',NULL,NULL),(657,NULL,NULL,'809f6e2027f9442d8bd2b94b11475b17',NULL,NULL,NULL,NULL,'2026-02-20 09:56:30',NULL,'2026-02-20 09:56:30',NULL,NULL),(658,NULL,'3a09b3407c3143c8ae0948ccb18c1e61',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:56:31',NULL,'2026-02-20 09:56:31',NULL,NULL),(659,NULL,'9aaa861c377844d48c046b32d623616a',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:56:32',NULL,'2026-02-20 09:56:32',NULL,NULL),(660,NULL,NULL,'3ace3fc0d46241ffa2d6d0b16953a588',NULL,NULL,NULL,NULL,'2026-02-20 09:56:38',NULL,'2026-02-20 09:56:38',NULL,NULL),(661,NULL,NULL,'df2bafbc0815447296ee536b0161623a',NULL,NULL,NULL,NULL,'2026-02-20 09:56:38',NULL,'2026-02-20 09:56:38',NULL,NULL),(662,NULL,'8aa5b5a34cfe458d96fea87261361db1',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:56:39',NULL,'2026-02-20 09:56:39',NULL,NULL),(663,NULL,NULL,'461cbaeb01d54029a644a346151cbf22',NULL,NULL,NULL,NULL,'2026-02-20 09:56:40',NULL,'2026-02-20 09:56:40',NULL,NULL),(664,NULL,'6b6c3ea6fad948cbaee73bff3485d7da',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:56:41',NULL,'2026-02-20 09:56:41',NULL,NULL),(665,NULL,'226ab368400e4186b91e98a77b240268',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:56:42',NULL,'2026-02-20 09:56:42',NULL,NULL),(666,NULL,NULL,'fb1fbd877a8346d5b367f7463ffb510c',NULL,NULL,NULL,NULL,'2026-02-20 09:56:56',NULL,'2026-02-20 09:56:56',NULL,NULL),(667,NULL,'d0927694241842759be660760b008959',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:56:58',NULL,'2026-02-20 09:56:58',NULL,NULL),(668,NULL,NULL,'bfd0239264ec4616ab8ac1831f80cbf9',NULL,NULL,NULL,NULL,'2026-02-20 09:56:58',NULL,'2026-02-20 09:56:58',NULL,NULL),(669,NULL,NULL,'05feeb2aee824362a8103784cc43648d',NULL,NULL,NULL,NULL,'2026-02-20 09:56:59',NULL,'2026-02-20 09:56:59',NULL,NULL),(670,NULL,NULL,'2d77927a4e5146babc582dbe0ea96247',NULL,NULL,NULL,NULL,'2026-02-20 09:56:59',NULL,'2026-02-20 09:56:59',NULL,NULL),(671,NULL,'62f842a102bd4d84b1f4d275ec6dbea2',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:56:59',NULL,'2026-02-20 09:56:59',NULL,NULL),(672,NULL,NULL,'f46e8e39708342449b0ca6f44ee962d6',NULL,NULL,NULL,NULL,'2026-02-20 09:57:00',NULL,'2026-02-20 09:57:00',NULL,NULL),(673,NULL,NULL,'eeb89c74577a4b97b5fef599cd287cce',NULL,NULL,NULL,NULL,'2026-02-20 09:57:00',NULL,'2026-02-20 09:57:00',NULL,NULL),(674,NULL,'c415a23ac6624be8b258d5fae2607759',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:01',NULL,'2026-02-20 09:57:01',NULL,NULL),(675,NULL,NULL,'cfd8fd24bbb54adf8f682266baa12b35',NULL,NULL,NULL,NULL,'2026-02-20 09:57:01',NULL,'2026-02-20 09:57:01',NULL,NULL),(676,NULL,'064faf3ddd3042a18f82df83e30e6c72',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:01',NULL,'2026-02-20 09:57:01',NULL,NULL),(677,NULL,'fd2fac9a2a1a4fd49d87e5d4ff1b64b3',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:02',NULL,'2026-02-20 09:57:02',NULL,NULL),(678,NULL,'1285af80c08045d5a39fcb5e7fc53750',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:02',NULL,'2026-02-20 09:57:02',NULL,NULL),(679,NULL,'63c8b3e7b8b445b68b501883951607d3',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:03',NULL,'2026-02-20 09:57:03',NULL,NULL),(680,NULL,NULL,'f8f7e83376364aed92a95cbecc4fe358',NULL,NULL,NULL,NULL,'2026-02-20 09:57:08',NULL,'2026-02-20 09:57:08',NULL,NULL),(681,NULL,NULL,'cdcdf2bba3fc49669c5018aa7c39d281',NULL,NULL,NULL,NULL,'2026-02-20 09:57:08',NULL,'2026-02-20 09:57:08',NULL,NULL),(682,NULL,NULL,'ea188ae7921a4d8184758901e9d4ec73',NULL,NULL,NULL,NULL,'2026-02-20 09:57:08',NULL,'2026-02-20 09:57:08',NULL,NULL),(683,NULL,'cb36e48ce4264babb412d413a8bf7b9f',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:08',NULL,'2026-02-20 09:57:08',NULL,NULL),(684,NULL,NULL,'90a02ec8973644daaf9f628e26b82aba',NULL,NULL,NULL,NULL,'2026-02-20 09:57:09',NULL,'2026-02-20 09:57:09',NULL,NULL),(685,NULL,'0bf1ebcb4e374b46b459e2b0ef84a591',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:09',NULL,'2026-02-20 09:57:09',NULL,NULL),(686,NULL,'eee793ed531548448eb1446c169fbf7a',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:10',NULL,'2026-02-20 09:57:10',NULL,NULL),(687,NULL,'68587c4c15964f28ad6d155288e119b0',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:10',NULL,'2026-02-20 09:57:10',NULL,NULL),(688,NULL,NULL,'ffe1d1a52ed447ff9f7bb31586f9a524',NULL,NULL,NULL,NULL,'2026-02-20 09:57:12',NULL,'2026-02-20 09:57:12',NULL,NULL),(689,NULL,NULL,'469c956856df4f7fa0303f662df3cdef',NULL,NULL,NULL,NULL,'2026-02-20 09:57:17',NULL,'2026-02-20 09:57:17',NULL,NULL),(690,NULL,'62dd1d7e0cf547678612304aba2895e2',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:18',NULL,'2026-02-20 09:57:18',NULL,NULL),(691,NULL,NULL,'8c63ad2215564b2ba1a91046040dcfc1',NULL,NULL,NULL,NULL,'2026-02-20 09:57:19',NULL,'2026-02-20 09:57:19',NULL,NULL),(692,NULL,NULL,'d775a3f12a7d4ea9a49d61f67b807f50',NULL,NULL,NULL,NULL,'2026-02-20 09:57:19',NULL,'2026-02-20 09:57:19',NULL,NULL),(693,NULL,NULL,'c4ab8562cd0a45e184eb04f8f1291b3c',NULL,NULL,NULL,NULL,'2026-02-20 09:57:19',NULL,'2026-02-20 09:57:19',NULL,NULL),(694,NULL,NULL,'8b934adab96c450395aa1542e65e5970',NULL,NULL,NULL,NULL,'2026-02-20 09:57:20',NULL,'2026-02-20 09:57:20',NULL,NULL),(695,NULL,'d345acb999b945ac8ca92ec3a0b92da6',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:20',NULL,'2026-02-20 09:57:20',NULL,NULL),(696,NULL,'12cc5cd2914e4021ad28fad52a6171d7',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:21',NULL,'2026-02-20 09:57:21',NULL,NULL),(697,NULL,NULL,'300f58a310124838a01f66f6c55f880d',NULL,NULL,NULL,NULL,'2026-02-20 09:57:22',NULL,'2026-02-20 09:57:22',NULL,NULL),(698,NULL,NULL,'a1bf610eaff5467a936504b0858a8a06',NULL,NULL,NULL,NULL,'2026-02-20 09:57:23',NULL,'2026-02-20 09:57:23',NULL,NULL),(699,NULL,'4c23134629034c99a32e1e53486719c7',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:23',NULL,'2026-02-20 09:57:23',NULL,NULL),(700,NULL,NULL,'e8d99e5aba074cfb8aea01d99045d2af',NULL,NULL,NULL,NULL,'2026-02-20 09:57:23',NULL,'2026-02-20 09:57:23',NULL,NULL),(701,NULL,NULL,'3fd5694d6e624148892ddc3041d2f0e1',NULL,NULL,NULL,NULL,'2026-02-20 09:57:24',NULL,'2026-02-20 09:57:24',NULL,NULL),(702,NULL,'106f4405b89e40edaf5d5d0137ae47f5',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:24',NULL,'2026-02-20 09:57:24',NULL,NULL),(703,NULL,'510051849ddf4ee1955b74d69a4e168c',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:24',NULL,'2026-02-20 09:57:24',NULL,NULL),(704,NULL,'c35d86bef4654b9c8023cd264d38a33b',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:25',NULL,'2026-02-20 09:57:25',NULL,NULL),(705,NULL,'8a08202c1391432d972dc0430612e0e0',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:25',NULL,'2026-02-20 09:57:25',NULL,NULL),(706,NULL,'4bc7f22347de4004b73776eab4064bd0',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:25',NULL,'2026-02-20 09:57:25',NULL,NULL),(707,NULL,NULL,'4a3e62b41f1c442498e28766189790d1',NULL,NULL,NULL,NULL,'2026-02-20 09:57:26',NULL,'2026-02-20 09:57:26',NULL,NULL),(708,NULL,NULL,'a72c854c93ed4c57adae44904bf89c6e',NULL,NULL,NULL,NULL,'2026-02-20 09:57:26',NULL,'2026-02-20 09:57:26',NULL,NULL),(709,NULL,NULL,'4b5ed87e2437472da2d50b6ffb357754',NULL,NULL,NULL,NULL,'2026-02-20 09:57:27',NULL,'2026-02-20 09:57:27',NULL,NULL),(710,NULL,NULL,'c4eb6f5ec86941aabe823e1a60db0d85',NULL,NULL,NULL,NULL,'2026-02-20 09:57:27',NULL,'2026-02-20 09:57:27',NULL,NULL),(711,NULL,NULL,'b85557958a8c49e48c9f3729586ca7b9',NULL,NULL,NULL,NULL,'2026-02-20 09:57:28',NULL,'2026-02-20 09:57:28',NULL,NULL),(712,NULL,NULL,'3c6a99f7be8048329c5edc3d04bf3c7d',NULL,NULL,NULL,NULL,'2026-02-20 09:57:28',NULL,'2026-02-20 09:57:28',NULL,NULL),(713,NULL,'6a4d3645690a4fe0b4bac5a45b1fd6a0',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:29',NULL,'2026-02-20 09:57:29',NULL,NULL),(714,NULL,NULL,'5c91205ef697410e89db9293ce0f3b1c',NULL,NULL,NULL,NULL,'2026-02-20 09:57:29',NULL,'2026-02-20 09:57:29',NULL,NULL),(715,NULL,NULL,'9601e0a4445c474b87dcab94b5d89d49',NULL,NULL,NULL,NULL,'2026-02-20 09:57:29',NULL,'2026-02-20 09:57:29',NULL,NULL),(716,NULL,'ab4fb24abb4f46f3b87a99f8c5132e6c',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:30',NULL,'2026-02-20 09:57:30',NULL,NULL),(717,NULL,'43a8c5592dc64c5a935d4d8b5fb44ad8',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:30',NULL,'2026-02-20 09:57:30',NULL,NULL),(718,NULL,'679d4112f29a4a8f886e35e1db29316b',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:31',NULL,'2026-02-20 09:57:31',NULL,NULL),(719,NULL,'5effbe6fba084f389cf7a0a3a14bdc95',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:31',NULL,'2026-02-20 09:57:31',NULL,NULL),(720,NULL,NULL,'006a0e8f7e054ecc87e89aeaefd897ea',NULL,NULL,NULL,NULL,'2026-02-20 09:57:31',NULL,'2026-02-20 09:57:31',NULL,NULL),(721,NULL,NULL,'f9cd1385edbc4127aa5e1872880c9176',NULL,NULL,NULL,NULL,'2026-02-20 09:57:31',NULL,'2026-02-20 09:57:31',NULL,NULL),(722,NULL,NULL,'9784bc44cbdb4cc58551185444225970',NULL,NULL,NULL,NULL,'2026-02-20 09:57:32',NULL,'2026-02-20 09:57:32',NULL,NULL),(723,NULL,'0cba57a76d2c47f1b657cad539c7ae56',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:32',NULL,'2026-02-20 09:57:32',NULL,NULL),(724,NULL,NULL,'e3d1b3d1b2aa4d3a87ba8f3f479f8a17',NULL,NULL,NULL,NULL,'2026-02-20 09:57:32',NULL,'2026-02-20 09:57:32',NULL,NULL),(725,NULL,NULL,'6fe9adca6d784c67af78d3ed8b4f0cd0',NULL,NULL,NULL,NULL,'2026-02-20 09:57:32',NULL,'2026-02-20 09:57:32',NULL,NULL),(726,NULL,NULL,'68596db4321d412fa84a0b3a4888496c',NULL,NULL,NULL,NULL,'2026-02-20 09:57:33',NULL,'2026-02-20 09:57:33',NULL,NULL),(727,NULL,NULL,'8b5bbabe99d84f568cfed466d4ea2347',NULL,NULL,NULL,NULL,'2026-02-20 09:57:33',NULL,'2026-02-20 09:57:33',NULL,NULL),(728,NULL,NULL,'29c6d6ef651c4d468def8f86f644f1d2',NULL,NULL,NULL,NULL,'2026-02-20 09:57:33',NULL,'2026-02-20 09:57:33',NULL,NULL),(729,NULL,NULL,'549c7a7277524232a3c2433341cec5ab',NULL,NULL,NULL,NULL,'2026-02-20 09:57:33',NULL,'2026-02-20 09:57:33',NULL,NULL),(730,NULL,NULL,'82d57f5053f740799c189ab7be7e42cb',NULL,NULL,NULL,NULL,'2026-02-20 09:57:33',NULL,'2026-02-20 09:57:33',NULL,NULL),(731,NULL,NULL,'ef8893d318ac489595063bf9d59fa3a6',NULL,NULL,NULL,NULL,'2026-02-20 09:57:33',NULL,'2026-02-20 09:57:33',NULL,NULL),(732,NULL,'09d57e79baaa4eb891b62a78f1c94de5',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:34',NULL,'2026-02-20 09:57:34',NULL,NULL),(733,NULL,'5207a0d9e0ae4608a5718bb304996958',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:34',NULL,'2026-02-20 09:57:34',NULL,NULL),(734,NULL,'b937092feb204d07b7daa9302db5204f',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:34',NULL,'2026-02-20 09:57:34',NULL,NULL),(735,NULL,'49e1a8306ee544ab909dcd7dcc737fd3',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:35',NULL,'2026-02-20 09:57:35',NULL,NULL),(736,NULL,'6a7f7344c2d148598c2c2dc450d61fbe',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:35',NULL,'2026-02-20 09:57:35',NULL,NULL),(737,NULL,'208565eda0ab416e8a4d0cab3045c853',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:35',NULL,'2026-02-20 09:57:35',NULL,NULL),(738,NULL,'992d662fd56443929ea59d0f0c2033eb',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:36',NULL,'2026-02-20 09:57:36',NULL,NULL),(739,NULL,'1401fb23701440858ed7175cc4dba63b',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:36',NULL,'2026-02-20 09:57:36',NULL,NULL),(740,NULL,'a7fd4740c8af42eda6e38d9605c14b06',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:36',NULL,'2026-02-20 09:57:36',NULL,NULL),(741,NULL,NULL,'64bc298504924a43b95ce2758bfa5477',NULL,NULL,NULL,NULL,'2026-02-20 09:57:36',NULL,'2026-02-20 09:57:36',NULL,NULL),(742,NULL,NULL,'a1c1f758d31a44f2bb5b45a4559944c1',NULL,NULL,NULL,NULL,'2026-02-20 09:57:37',NULL,'2026-02-20 09:57:37',NULL,NULL),(743,NULL,NULL,'8bf631627bbd4ebdbc24dfbdc81bc20d',NULL,NULL,NULL,NULL,'2026-02-20 09:57:37',NULL,'2026-02-20 09:57:37',NULL,NULL),(744,NULL,'6e9714bc4a7c49cda68e7cb1c990f977',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:37',NULL,'2026-02-20 09:57:37',NULL,NULL),(745,NULL,NULL,'170497ba01a04b009bc1ba8aac2a4c05',NULL,NULL,NULL,NULL,'2026-02-20 09:57:37',NULL,'2026-02-20 09:57:37',NULL,NULL),(746,NULL,NULL,'b9359cd851644fc697acbc3f5e795c19',NULL,NULL,NULL,NULL,'2026-02-20 09:57:38',NULL,'2026-02-20 09:57:38',NULL,NULL),(747,NULL,NULL,'6b4baf1e14c147c2b6fb66292ff98ed2',NULL,NULL,NULL,NULL,'2026-02-20 09:57:38',NULL,'2026-02-20 09:57:38',NULL,NULL),(748,NULL,'347214e243dd40cab97e3088ec039f00',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:38',NULL,'2026-02-20 09:57:38',NULL,NULL),(749,NULL,'cca399492ffa4d75949b4a5c86382f51',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:39',NULL,'2026-02-20 09:57:39',NULL,NULL),(750,NULL,NULL,'edc59ee4d28e460f9f8bb691db7b2a62',NULL,NULL,NULL,NULL,'2026-02-20 09:57:39',NULL,'2026-02-20 09:57:39',NULL,NULL),(751,NULL,'a48d774a595542e4a66f14036bc080ce',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:40',NULL,'2026-02-20 09:57:40',NULL,NULL),(752,NULL,'c8c0c5d5376b451c9163b79389c076ff',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:40',NULL,'2026-02-20 09:57:40',NULL,NULL),(753,NULL,'b85fac0c24fe4ed5bf064eba1b0e7836',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:40',NULL,'2026-02-20 09:57:40',NULL,NULL),(754,NULL,'70bb022b35e24abea8664380b7cad595',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:41',NULL,'2026-02-20 09:57:41',NULL,NULL),(755,NULL,'86aaac71adcf42349114a5ecb0b1fe3d',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:41',NULL,'2026-02-20 09:57:41',NULL,NULL),(756,NULL,NULL,'51a52206a9ff445f9cb39f9197292bef',NULL,NULL,NULL,NULL,'2026-02-20 09:57:41',NULL,'2026-02-20 09:57:41',NULL,NULL),(757,NULL,NULL,'e87682ef607f413cbf7fc54b7c33100b',NULL,NULL,NULL,NULL,'2026-02-20 09:57:42',NULL,'2026-02-20 09:57:42',NULL,NULL),(758,NULL,NULL,'fd5cbccf037047f8a8d2b9488223d9dc',NULL,NULL,NULL,NULL,'2026-02-20 09:57:43',NULL,'2026-02-20 09:57:43',NULL,NULL),(759,NULL,'41b6c3c37b6340aea97e97ab128131c6',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:43',NULL,'2026-02-20 09:57:43',NULL,NULL),(760,NULL,'92c7b74ddebf4a4a82ffeb6b9b8a9111',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:44',NULL,'2026-02-20 09:57:44',NULL,NULL),(761,NULL,'4ba33bb7d9914f8e8c66a23ffdbed83e',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:44',NULL,'2026-02-20 09:57:44',NULL,NULL),(762,NULL,NULL,'2b2386a83b93450ea478b6ccd8d0eb67',NULL,NULL,NULL,NULL,'2026-02-20 09:57:46',NULL,'2026-02-20 09:57:46',NULL,NULL),(763,NULL,NULL,'e3384557636646f6817fdbe3e6b04f08',NULL,NULL,NULL,NULL,'2026-02-20 09:57:48',NULL,'2026-02-20 09:57:48',NULL,NULL),(764,NULL,'be29e48b9ab04597a2018420abbbd873',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:48',NULL,'2026-02-20 09:57:48',NULL,NULL),(765,NULL,NULL,'c7a5dabdd45746e083d22f2ad7d9f491',NULL,NULL,NULL,NULL,'2026-02-20 09:57:48',NULL,'2026-02-20 09:57:48',NULL,NULL),(766,NULL,NULL,'521287caa8864d1b89056a612d6439f9',NULL,NULL,NULL,NULL,'2026-02-20 09:57:48',NULL,'2026-02-20 09:57:48',NULL,NULL),(767,NULL,NULL,'71f1f2d363de4ada8cd82b679f881467',NULL,NULL,NULL,NULL,'2026-02-20 09:57:48',NULL,'2026-02-20 09:57:48',NULL,NULL),(768,NULL,NULL,'0369f88afd9c4ad792ea05fa5927e072',NULL,NULL,NULL,NULL,'2026-02-20 09:57:48',NULL,'2026-02-20 09:57:48',NULL,NULL),(769,NULL,NULL,'3151645bdbe94f709e73146f2b8cea68',NULL,NULL,NULL,NULL,'2026-02-20 09:57:49',NULL,'2026-02-20 09:57:49',NULL,NULL),(770,NULL,'84c6f89ee8ab4e5a8414770d1d8ba139',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:50',NULL,'2026-02-20 09:57:50',NULL,NULL),(771,NULL,'209847c437954c8e97a31ee877da2922',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:51',NULL,'2026-02-20 09:57:51',NULL,NULL),(772,NULL,NULL,'0ba3933a0cac4d92b59661133ccf4646',NULL,NULL,NULL,NULL,'2026-02-20 09:57:51',NULL,'2026-02-20 09:57:51',NULL,NULL),(773,NULL,NULL,'a78fe11bcc0b4892986ddde1f2fb3cca',NULL,NULL,NULL,NULL,'2026-02-20 09:57:51',NULL,'2026-02-20 09:57:51',NULL,NULL),(774,NULL,NULL,'11a48bd85b2848c1b2e4332878facd44',NULL,NULL,NULL,NULL,'2026-02-20 09:57:51',NULL,'2026-02-20 09:57:51',NULL,NULL),(775,NULL,'4169aafa2c914922a5a1357c55afd460',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:51',NULL,'2026-02-20 09:57:51',NULL,NULL),(776,NULL,NULL,'46d2da43b69c4228bbe4bc911be273b9',NULL,NULL,NULL,NULL,'2026-02-20 09:57:51',NULL,'2026-02-20 09:57:51',NULL,NULL),(777,NULL,'63d778ff38e643a08cbc512aa52a9bfc',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:51',NULL,'2026-02-20 09:57:51',NULL,NULL),(778,NULL,NULL,'4e73eda6af484935b128bbf81b980c0e',NULL,NULL,NULL,NULL,'2026-02-20 09:57:52',NULL,'2026-02-20 09:57:52',NULL,NULL),(779,NULL,NULL,'568c48301f4247b4ba73d011206ee9e1',NULL,NULL,NULL,NULL,'2026-02-20 09:57:52',NULL,'2026-02-20 09:57:52',NULL,NULL),(780,NULL,'563ea6bfb0f84d1eb144eef09e0012cc',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:52',NULL,'2026-02-20 09:57:52',NULL,NULL),(781,NULL,'5d2341f606e547b1be4b4ce3454e0542',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:52',NULL,'2026-02-20 09:57:52',NULL,NULL),(782,NULL,'128736e99cb541468aa88da3588f267d',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:53',NULL,'2026-02-20 09:57:53',NULL,NULL),(783,NULL,'703953f368c84a05a279629aa7704503',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:53',NULL,'2026-02-20 09:57:53',NULL,NULL),(784,NULL,'45684cef57044673853935ebf96dd4d3',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:54',NULL,'2026-02-20 09:57:54',NULL,NULL),(785,NULL,'151995c664f84bb6a0e0b718e2fff213',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:54',NULL,'2026-02-20 09:57:54',NULL,NULL),(786,NULL,NULL,'bc2dcb120f2d4c5799b2d346eb188c72',NULL,NULL,NULL,NULL,'2026-02-20 09:57:56',NULL,'2026-02-20 09:57:56',NULL,NULL),(787,NULL,NULL,'4f0ea307f5cb493ea54124206dd60bbd',NULL,NULL,NULL,NULL,'2026-02-20 09:57:56',NULL,'2026-02-20 09:57:56',NULL,NULL),(788,NULL,NULL,'435ada98e06d4e2ab2fcda33004e5ce5',NULL,NULL,NULL,NULL,'2026-02-20 09:57:56',NULL,'2026-02-20 09:57:56',NULL,NULL),(789,NULL,NULL,'fff142493ee345f5a6cc748b1c9a9e98',NULL,NULL,NULL,NULL,'2026-02-20 09:57:56',NULL,'2026-02-20 09:57:56',NULL,NULL),(790,NULL,NULL,'4be7f40fee11495bbb53345fbfed57d8',NULL,NULL,NULL,NULL,'2026-02-20 09:57:56',NULL,'2026-02-20 09:57:56',NULL,NULL),(791,NULL,NULL,'0dc008e570d04b43bb408f77d498ec03',NULL,NULL,NULL,NULL,'2026-02-20 09:57:57',NULL,'2026-02-20 09:57:57',NULL,NULL),(792,NULL,NULL,'4459ffcd32784fd4bfbeffb7c633d945',NULL,NULL,NULL,NULL,'2026-02-20 09:57:57',NULL,'2026-02-20 09:57:57',NULL,NULL),(793,NULL,NULL,'88fd81eb72f747a6ade8575fa22ae381',NULL,NULL,NULL,NULL,'2026-02-20 09:57:57',NULL,'2026-02-20 09:57:57',NULL,NULL),(794,NULL,'963851d87da2416fa45dad0f879a8b6c',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:57',NULL,'2026-02-20 09:57:57',NULL,NULL),(795,NULL,'d39ddb875fdb417d9ff133ee99ffcc25',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:57',NULL,'2026-02-20 09:57:57',NULL,NULL),(796,NULL,NULL,'87c600393c09428dbda0464b5570da89',NULL,NULL,NULL,NULL,'2026-02-20 09:57:57',NULL,'2026-02-20 09:57:57',NULL,NULL),(797,NULL,NULL,'96e5d46ff85f4e608d98473a40702905',NULL,NULL,NULL,NULL,'2026-02-20 09:57:58',NULL,'2026-02-20 09:57:58',NULL,NULL),(798,NULL,'59c3d82ea930429192627cc34ce5101e',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:58',NULL,'2026-02-20 09:57:58',NULL,NULL),(799,NULL,'1aaf8ab8ed9846b78823edc92b936857',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:58',NULL,'2026-02-20 09:57:58',NULL,NULL),(800,NULL,'54c1240d13284f0c93759d99e097f79a',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:59',NULL,'2026-02-20 09:57:59',NULL,NULL),(801,NULL,'afcaf104c13b469693ef55c8fafe2873',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:57:59',NULL,'2026-02-20 09:57:59',NULL,NULL),(802,NULL,'51750f18434b4b60802ec6c49b096963',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:58:00',NULL,'2026-02-20 09:58:00',NULL,NULL),(803,NULL,'0717f004a8ae44d892afd76408189cd7',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:58:00',NULL,'2026-02-20 09:58:00',NULL,NULL),(804,NULL,'dfc391bf9a9b4f148621b5eb09eaa1e1',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:58:01',NULL,'2026-02-20 09:58:01',NULL,NULL),(805,NULL,NULL,'b7563d8cd4d142b89354d656cfd05add',NULL,NULL,NULL,NULL,'2026-02-20 09:58:04',NULL,'2026-02-20 09:58:04',NULL,NULL),(806,NULL,NULL,'d7878fbc4e544f3cbf9d87e08753b5c8',NULL,NULL,NULL,NULL,'2026-02-20 09:58:04',NULL,'2026-02-20 09:58:04',NULL,NULL),(807,NULL,NULL,'b19c6d4492a04b7d98d2825a8842e8ff',NULL,NULL,NULL,NULL,'2026-02-20 09:58:05',NULL,'2026-02-20 09:58:05',NULL,NULL),(808,NULL,'0507ba67b65244e7a826c6949689a381',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:58:05',NULL,'2026-02-20 09:58:05',NULL,NULL),(809,NULL,'2ac6bdba4377453b82e5badf03029d7c',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:58:06',NULL,'2026-02-20 09:58:06',NULL,NULL),(810,NULL,'0d3e96dc4ef74313a64d6b73d2726014',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:58:07',NULL,'2026-02-20 09:58:07',NULL,NULL),(811,NULL,NULL,'cc0541b09a4c4e7e93536060cb059a42',NULL,NULL,NULL,NULL,'2026-02-20 09:58:08',NULL,'2026-02-20 09:58:08',NULL,NULL),(812,NULL,NULL,'af186077fdaf4bdb943cf9d65db6b218',NULL,NULL,NULL,NULL,'2026-02-20 09:58:08',NULL,'2026-02-20 09:58:08',NULL,NULL),(813,NULL,NULL,'293922800a244eaca4a73432a4eef3bd',NULL,NULL,NULL,NULL,'2026-02-20 09:58:09',NULL,'2026-02-20 09:58:09',NULL,NULL),(814,NULL,NULL,'268650bb28e745bf997d0b0f3a1902db',NULL,NULL,NULL,NULL,'2026-02-20 09:58:09',NULL,'2026-02-20 09:58:09',NULL,NULL),(815,NULL,'0daa793be13d45c7a84d41fd46b2a8c7',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:58:11',NULL,'2026-02-20 09:58:11',NULL,NULL),(816,NULL,'3ed47f841ef14c6fb908c3727bc3d95f',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:58:11',NULL,'2026-02-20 09:58:11',NULL,NULL),(817,NULL,'d0fbb54da9274272b09aae9be8d15d07',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:58:12',NULL,'2026-02-20 09:58:12',NULL,NULL),(818,NULL,'c6099dcc2ecd4794925d1793d1a2a72c',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:58:13',NULL,'2026-02-20 09:58:13',NULL,NULL),(819,NULL,NULL,'4d0700411621452a8ebf9ade0908bb0a',NULL,NULL,NULL,NULL,'2026-02-20 09:58:13',NULL,'2026-02-20 09:58:13',NULL,NULL),(820,NULL,'3190ff3478094885a44aa058f00dec15',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:58:14',NULL,'2026-02-20 09:58:14',NULL,NULL),(821,NULL,NULL,'26c178031b9b453ca3b66e309e6bd2a8',NULL,NULL,NULL,NULL,'2026-02-20 09:58:19',NULL,'2026-02-20 09:58:19',NULL,NULL),(822,NULL,NULL,'aa25f1aee5d64dc38b37f38c4847419e',NULL,NULL,NULL,NULL,'2026-02-20 09:58:19',NULL,'2026-02-20 09:58:19',NULL,NULL),(823,NULL,'b39170cd6b2b43fa90080079febc7f43',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:58:20',NULL,'2026-02-20 09:58:20',NULL,NULL),(824,NULL,'6ed49739162544dca843cc8939a136b1',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:58:21',NULL,'2026-02-20 09:58:21',NULL,NULL),(825,NULL,NULL,'8042e92b3c524b198620f3d55f5985d2',NULL,NULL,NULL,NULL,'2026-02-20 09:58:24',NULL,'2026-02-20 09:58:24',NULL,NULL),(826,NULL,NULL,'e30be7cbcdbe481ca40e201ba10d8f55',NULL,NULL,NULL,NULL,'2026-02-20 09:58:24',NULL,'2026-02-20 09:58:24',NULL,NULL),(827,NULL,'12153583c2cb49888f6b7561b1199a0a',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:58:26',NULL,'2026-02-20 09:58:26',NULL,NULL),(828,NULL,'de648e0553934e4bb5f82949c4244a11',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:58:26',NULL,'2026-02-20 09:58:26',NULL,NULL),(829,NULL,NULL,'129368ce43b64853b24a36395c84b7b0',NULL,NULL,NULL,NULL,'2026-02-20 09:58:28',NULL,'2026-02-20 09:58:28',NULL,NULL),(830,NULL,'8a43ccd6212d4626a208a271337f7a5b',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:58:30',NULL,'2026-02-20 09:58:30',NULL,NULL),(831,NULL,NULL,'f2ad2575d72249829e095b53d373e41b',NULL,NULL,NULL,NULL,'2026-02-20 09:58:32',NULL,'2026-02-20 09:58:32',NULL,NULL),(832,NULL,NULL,'bf98d88b1c84473e962748cb9ed9824a',NULL,NULL,NULL,NULL,'2026-02-20 09:58:35',NULL,'2026-02-20 09:58:35',NULL,NULL),(833,NULL,NULL,'a0eb33817f4445e683b7a01bc391824c',NULL,NULL,NULL,NULL,'2026-02-20 09:58:35',NULL,'2026-02-20 09:58:35',NULL,NULL),(834,NULL,NULL,'b1b6b1c8649442edb905245c8af8bfc5',NULL,NULL,NULL,NULL,'2026-02-20 09:58:35',NULL,'2026-02-20 09:58:35',NULL,NULL),(835,NULL,'3c38c47b6b7b4f078e218bbefefce029',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:58:38',NULL,'2026-02-20 09:58:38',NULL,NULL),(836,NULL,'735dd74f89e740368caac3ab0ce2d821',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:58:41',NULL,'2026-02-20 09:58:41',NULL,NULL),(837,NULL,'5136931af0b549af91d68baf6dcf0577',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:58:43',NULL,'2026-02-20 09:58:43',NULL,NULL),(838,NULL,NULL,'917e5f4824804cc890c3df2bad9036db',NULL,NULL,NULL,NULL,'2026-02-20 09:58:45',NULL,'2026-02-20 09:58:45',NULL,NULL),(839,NULL,NULL,'9464140297e646c28fb593ff9176e8c6',NULL,NULL,NULL,NULL,'2026-02-20 09:58:45',NULL,'2026-02-20 09:58:45',NULL,NULL),(840,NULL,'80723b5de8af4075aa84c53e89b4d020',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:58:46',NULL,'2026-02-20 09:58:46',NULL,NULL),(841,NULL,'a4c013b15305422189787ce148858a3f',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:58:47',NULL,'2026-02-20 09:58:47',NULL,NULL),(842,NULL,NULL,'8c8cc44c38ca4b3ca339318554bae0a0',NULL,NULL,NULL,NULL,'2026-02-20 09:58:47',NULL,'2026-02-20 09:58:47',NULL,NULL),(843,NULL,'4559942bc629438d88ae332098961d3f',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:58:48',NULL,'2026-02-20 09:58:48',NULL,NULL),(844,NULL,NULL,'c95f42a86dd348a68ea4d21f5679364c',NULL,NULL,NULL,NULL,'2026-02-20 09:58:49',NULL,'2026-02-20 09:58:49',NULL,NULL),(845,NULL,NULL,'f3f545fea104458793d484368b6d4c23',NULL,NULL,NULL,NULL,'2026-02-20 09:58:49',NULL,'2026-02-20 09:58:49',NULL,NULL),(846,NULL,'2124592a7614499d8c7693cd6ba353de',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:58:49',NULL,'2026-02-20 09:58:49',NULL,NULL),(847,NULL,'d0e47cd34a784cbb89cbe56eafed5650',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:58:50',NULL,'2026-02-20 09:58:50',NULL,NULL),(848,NULL,NULL,'2d8d48cb8c00430da470cbc1faeff552',NULL,NULL,NULL,NULL,'2026-02-20 09:58:51',NULL,'2026-02-20 09:58:51',NULL,NULL),(849,NULL,'f101b520ef40417ca5284fa6c186ce1f',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:58:52',NULL,'2026-02-20 09:58:52',NULL,NULL),(850,NULL,NULL,'e3f0db36b0124260abd7f5213aa15607',NULL,NULL,NULL,NULL,'2026-02-20 09:58:59',NULL,'2026-02-20 09:58:59',NULL,NULL),(851,NULL,NULL,'fc2654163ae44cab8ac83cec6540300f',NULL,NULL,NULL,NULL,'2026-02-20 09:58:59',NULL,'2026-02-20 09:58:59',NULL,NULL),(852,NULL,NULL,'13a067daa4bc44be9aa1bcacf0789506',NULL,NULL,NULL,NULL,'2026-02-20 09:58:59',NULL,'2026-02-20 09:58:59',NULL,NULL),(853,NULL,NULL,'9530e3e0e2eb44f39672bc1018461a3b',NULL,NULL,NULL,NULL,'2026-02-20 09:58:59',NULL,'2026-02-20 09:58:59',NULL,NULL),(854,NULL,'b99e28f6b64746ada5efe1c04d5379a2',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:01',NULL,'2026-02-20 09:59:01',NULL,NULL),(855,NULL,'48774a75bd5d4b0b9dc80b5aca83d5fc',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:02',NULL,'2026-02-20 09:59:02',NULL,NULL),(856,NULL,'830e413b9fb04e02af1efdd014797bc3',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:03',NULL,'2026-02-20 09:59:03',NULL,NULL),(857,NULL,NULL,'7ce97ef3705247ccaf53a4ddfee9889c',NULL,NULL,NULL,NULL,'2026-02-20 09:59:09',NULL,'2026-02-20 09:59:09',NULL,NULL),(858,NULL,'db4c2cde6adc4016a4bb7c41aa8e59c8',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:09',NULL,'2026-02-20 09:59:09',NULL,NULL),(859,NULL,NULL,'3ef260a64538468fa2842b6169bdff0c',NULL,NULL,NULL,NULL,'2026-02-20 09:59:15',NULL,'2026-02-20 09:59:15',NULL,NULL),(860,NULL,NULL,'658ecc001e85402995533129aa177bc3',NULL,NULL,NULL,NULL,'2026-02-20 09:59:16',NULL,'2026-02-20 09:59:16',NULL,NULL),(861,NULL,NULL,'22e3c2ce53e245af99073a32a0fad9dd',NULL,NULL,NULL,NULL,'2026-02-20 09:59:16',NULL,'2026-02-20 09:59:16',NULL,NULL),(862,NULL,NULL,'2a38b24f215a478db5cd7da521f1b21b',NULL,NULL,NULL,NULL,'2026-02-20 09:59:16',NULL,'2026-02-20 09:59:16',NULL,NULL),(863,NULL,'b65a7bdec7e44e44a71225086557e7f4',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:18',NULL,'2026-02-20 09:59:18',NULL,NULL),(864,NULL,'4f1b3c403fb148c692c17867833e30a7',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:19',NULL,'2026-02-20 09:59:19',NULL,NULL),(865,NULL,'b466c6b08b5e44ff9593bfa11ccdf0a9',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:19',NULL,'2026-02-20 09:59:19',NULL,NULL),(866,NULL,NULL,'b8c5cd85f3954e32bc8ce4cc39694a8d',NULL,NULL,NULL,NULL,'2026-02-20 09:59:21',NULL,'2026-02-20 09:59:21',NULL,NULL),(867,NULL,'25c20dca96c143a09e2486b79027be5d',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:22',NULL,'2026-02-20 09:59:22',NULL,NULL),(868,NULL,NULL,'3265aa4818ea4de2a5862fddd7c5a576',NULL,NULL,NULL,NULL,'2026-02-20 09:59:22',NULL,'2026-02-20 09:59:22',NULL,NULL),(869,NULL,NULL,'555b92d39f27422695207483d3e530ad',NULL,NULL,NULL,NULL,'2026-02-20 09:59:27',NULL,'2026-02-20 09:59:27',NULL,NULL),(870,NULL,NULL,'7058374f87364f958ccdd85f706ecfe0',NULL,NULL,NULL,NULL,'2026-02-20 09:59:27',NULL,'2026-02-20 09:59:27',NULL,NULL),(871,NULL,NULL,'efc4b1f0e51b435db3cf2654d26819e4',NULL,NULL,NULL,NULL,'2026-02-20 09:59:28',NULL,'2026-02-20 09:59:28',NULL,NULL),(872,NULL,'dc400fd7b37f468c83d54846895b6cba',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:28',NULL,'2026-02-20 09:59:28',NULL,NULL),(873,NULL,'4208cd0fbab541f399d332d0956cc0d5',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:29',NULL,'2026-02-20 09:59:29',NULL,NULL),(874,NULL,NULL,'dc426a91cccf47ebb461d1d3d8b9fb8a',NULL,NULL,NULL,NULL,'2026-02-20 09:59:31',NULL,'2026-02-20 09:59:31',NULL,NULL),(875,NULL,NULL,'621f93a9ff96407cbf40e3e255d00954',NULL,NULL,NULL,NULL,'2026-02-20 09:59:31',NULL,'2026-02-20 09:59:31',NULL,NULL),(876,NULL,NULL,'9b3af574e998460eb018052ec24016f7',NULL,NULL,NULL,NULL,'2026-02-20 09:59:31',NULL,'2026-02-20 09:59:31',NULL,NULL),(877,NULL,NULL,'4c761fa8134f4685918b190d369ecbc6',NULL,NULL,NULL,NULL,'2026-02-20 09:59:31',NULL,'2026-02-20 09:59:31',NULL,NULL),(878,NULL,NULL,'aa0dd7993e8f4b97b1feaf3ee9f371b9',NULL,NULL,NULL,NULL,'2026-02-20 09:59:31',NULL,'2026-02-20 09:59:31',NULL,NULL),(879,NULL,NULL,'58824ecf7ec24f3f8eca46626cadee71',NULL,NULL,NULL,NULL,'2026-02-20 09:59:31',NULL,'2026-02-20 09:59:31',NULL,NULL),(880,NULL,'f8977716243a4d08b796817264c027c2',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:32',NULL,'2026-02-20 09:59:32',NULL,NULL),(881,NULL,'4eb963516e994397b5c6f3bb155e8d11',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:32',NULL,'2026-02-20 09:59:32',NULL,NULL),(882,NULL,'cec3ac3e38f4401bb4bfc7f380ef6f55',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:32',NULL,'2026-02-20 09:59:32',NULL,NULL),(883,NULL,'7abea76c7bee47dcaa21322c49704150',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:33',NULL,'2026-02-20 09:59:33',NULL,NULL),(884,NULL,'57b486bdb5904ffa9dc92b98ab379c6f',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:33',NULL,'2026-02-20 09:59:33',NULL,NULL),(885,NULL,'32333d38a8f8466a94e77c7e26eb66a7',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:34',NULL,'2026-02-20 09:59:34',NULL,NULL),(886,NULL,NULL,'8643c8395fbe4ccfb167772f294c4f4e',NULL,NULL,NULL,NULL,'2026-02-20 09:59:35',NULL,'2026-02-20 09:59:35',NULL,NULL),(887,NULL,NULL,'121eeddb22b645a0842e7891e447bd3e',NULL,NULL,NULL,NULL,'2026-02-20 09:59:35',NULL,'2026-02-20 09:59:35',NULL,NULL),(888,NULL,NULL,'0865905071f249b0b62f978a60ea8258',NULL,NULL,NULL,NULL,'2026-02-20 09:59:35',NULL,'2026-02-20 09:59:35',NULL,NULL),(889,NULL,'a941d89a034a4d0e930fd4fb754ca24c',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:36',NULL,'2026-02-20 09:59:36',NULL,NULL),(890,NULL,NULL,'c359eaee59074888af5d3306b57c5ed6',NULL,NULL,NULL,NULL,'2026-02-20 09:59:37',NULL,'2026-02-20 09:59:37',NULL,NULL),(891,NULL,'0d864a52bf534b55a21f76b3d9a1e409',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:37',NULL,'2026-02-20 09:59:37',NULL,NULL),(892,NULL,'b8a440d7c9084127bfe4c2de0c24b6a4',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:38',NULL,'2026-02-20 09:59:38',NULL,NULL),(893,NULL,'2cd3436ad8a1427598e20bbea13ed671',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:38',NULL,'2026-02-20 09:59:38',NULL,NULL),(894,NULL,NULL,'471ad779c8384258880718ac3bd4246e',NULL,NULL,NULL,NULL,'2026-02-20 09:59:40',NULL,'2026-02-20 09:59:40',NULL,NULL),(895,NULL,NULL,'dd8d32ee66124b4fa1b4bff8b9dc4fba',NULL,NULL,NULL,NULL,'2026-02-20 09:59:40',NULL,'2026-02-20 09:59:40',NULL,NULL),(896,NULL,'97a060b7450c430493cde397f357c8a0',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:41',NULL,'2026-02-20 09:59:41',NULL,NULL),(897,NULL,'af7558d3f3e7491c82e203a181c2b164',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:42',NULL,'2026-02-20 09:59:42',NULL,NULL),(898,NULL,NULL,'90550ad21b7d451cb8e34a1909d08113',NULL,NULL,NULL,NULL,'2026-02-20 09:59:43',NULL,'2026-02-20 09:59:43',NULL,NULL),(899,NULL,'68573218a6b141beb49fbacc5b306c7d',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:43',NULL,'2026-02-20 09:59:43',NULL,NULL),(900,NULL,NULL,'dd268c1f9ee446539e3c068b23100abc',NULL,NULL,NULL,NULL,'2026-02-20 09:59:47',NULL,'2026-02-20 09:59:47',NULL,NULL),(901,NULL,NULL,'7103a027069f4ba29519e2409a57e190',NULL,NULL,NULL,NULL,'2026-02-20 09:59:47',NULL,'2026-02-20 09:59:47',NULL,NULL),(902,NULL,NULL,'84b5e5285490461898ddad70e9062b7c',NULL,NULL,NULL,NULL,'2026-02-20 09:59:47',NULL,'2026-02-20 09:59:47',NULL,NULL),(903,NULL,'f47cf27181924d37b1f66305014193c3',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:49',NULL,'2026-02-20 09:59:49',NULL,NULL),(904,NULL,NULL,'893fd6f0dfd84429b2495b07d86777af',NULL,NULL,NULL,NULL,'2026-02-20 09:59:49',NULL,'2026-02-20 09:59:49',NULL,NULL),(905,NULL,NULL,'19d6e00e3a9948d19bf23d9ec5e6c37b',NULL,NULL,NULL,NULL,'2026-02-20 09:59:49',NULL,'2026-02-20 09:59:49',NULL,NULL),(906,NULL,NULL,'51972ebbaa80484f9c21bc4ef8a3bb0c',NULL,NULL,NULL,NULL,'2026-02-20 09:59:49',NULL,'2026-02-20 09:59:49',NULL,NULL),(907,NULL,'df91ef8bd40145bc8a8f455b3dd7bc70',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:49',NULL,'2026-02-20 09:59:49',NULL,NULL),(908,NULL,'6191d07901a6491993d029fffa6c4d91',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:50',NULL,'2026-02-20 09:59:50',NULL,NULL),(909,NULL,'3d916d4e895e479c9da7595a4e228402',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:50',NULL,'2026-02-20 09:59:50',NULL,NULL),(910,NULL,'647a6092d7ca4d98a6d581a879bbcbac',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:51',NULL,'2026-02-20 09:59:51',NULL,NULL),(911,NULL,'be93acd07fde4f3e825670e22220d787',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:51',NULL,'2026-02-20 09:59:51',NULL,NULL),(912,NULL,NULL,'ac53ac476f2443318193010d210c6b7e',NULL,NULL,NULL,NULL,'2026-02-20 09:59:53',NULL,'2026-02-20 09:59:53',NULL,NULL),(913,NULL,NULL,'a249774498824462ace4b66a3d81b29c',NULL,NULL,NULL,NULL,'2026-02-20 09:59:54',NULL,'2026-02-20 09:59:54',NULL,NULL),(914,NULL,'84e829bce6ac4cb79f2320960e9cc4f6',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:55',NULL,'2026-02-20 09:59:55',NULL,NULL),(915,NULL,'d8d571d58a9b4b3cb35695d51c9ad2dc',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:55',NULL,'2026-02-20 09:59:55',NULL,NULL),(916,NULL,NULL,'1937ebc642294460a8497f196ddea9de',NULL,NULL,NULL,NULL,'2026-02-20 09:59:57',NULL,'2026-02-20 09:59:57',NULL,NULL),(917,NULL,'6054faa8578341babdc8fee726b50c84',NULL,NULL,NULL,NULL,NULL,'2026-02-20 09:59:58',NULL,'2026-02-20 09:59:58',NULL,NULL),(918,NULL,NULL,'651bfdd554864016b919f2b5c8112b5f',NULL,NULL,NULL,NULL,'2026-02-20 10:00:15',NULL,'2026-02-20 10:00:15',NULL,NULL),(919,NULL,'3dca3c8f00214a66a9293134148fac17',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:00:16',NULL,'2026-02-20 10:00:16',NULL,NULL),(920,NULL,NULL,'c1cf03483c7d40b1a7b5cb96f508a5e3',NULL,NULL,NULL,NULL,'2026-02-20 10:00:21',NULL,'2026-02-20 10:00:21',NULL,NULL),(921,NULL,'13d7347e58a645999865c0f5a5839f4f',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:00:22',NULL,'2026-02-20 10:00:22',NULL,NULL),(922,NULL,NULL,'157fe81ea811422c9d325b8c2657d3a9',NULL,NULL,NULL,NULL,'2026-02-20 10:00:26',NULL,'2026-02-20 10:00:26',NULL,NULL),(923,NULL,'fc77d937e5f64d008d60c0ad9d54a545',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:00:27',NULL,'2026-02-20 10:00:27',NULL,NULL),(924,NULL,NULL,'15dd89b8c78946dcb0ef7bab49122e75',NULL,NULL,NULL,NULL,'2026-02-20 10:00:27',NULL,'2026-02-20 10:00:27',NULL,NULL),(925,NULL,NULL,'c3d4dcd50a054b289c9e965fdbd6fb65',NULL,NULL,NULL,NULL,'2026-02-20 10:00:27',NULL,'2026-02-20 10:00:27',NULL,NULL),(926,NULL,NULL,'1ddfe6bf8f2e4cfba9937c77d1562c94',NULL,NULL,NULL,NULL,'2026-02-20 10:00:27',NULL,'2026-02-20 10:00:27',NULL,NULL),(927,NULL,NULL,'1aa21da1c8d442eda1bd15edc6b8d61d',NULL,NULL,NULL,NULL,'2026-02-20 10:00:27',NULL,'2026-02-20 10:00:27',NULL,NULL),(928,NULL,NULL,'8d417ab82fb04f57a9a86575bd8f14a5',NULL,NULL,NULL,NULL,'2026-02-20 10:00:28',NULL,'2026-02-20 10:00:28',NULL,NULL),(929,NULL,'8a6fa5839edc4a84aa96c50c8159c737',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:00:29',NULL,'2026-02-20 10:00:29',NULL,NULL),(930,NULL,'5c5c633190964f31b7a0089137eba7f6',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:00:29',NULL,'2026-02-20 10:00:29',NULL,NULL),(931,NULL,'a1dc588b1c50481a922bed48756ae227',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:00:30',NULL,'2026-02-20 10:00:30',NULL,NULL),(932,NULL,NULL,'3c9aad3e967a4c218c51f5dad8e943bf',NULL,NULL,NULL,NULL,'2026-02-20 10:00:34',NULL,'2026-02-20 10:00:34',NULL,NULL),(933,NULL,NULL,'9c8d531d8a9b4e5681e18a328b4e771d',NULL,NULL,NULL,NULL,'2026-02-20 10:00:34',NULL,'2026-02-20 10:00:34',NULL,NULL),(934,NULL,NULL,'23db3dcc1e034a5da5d56e36d6d9c2a2',NULL,NULL,NULL,NULL,'2026-02-20 10:00:34',NULL,'2026-02-20 10:00:34',NULL,NULL),(935,NULL,NULL,'f57b490f030c4af3bd5a501ec48c66cd',NULL,NULL,NULL,NULL,'2026-02-20 10:00:34',NULL,'2026-02-20 10:00:34',NULL,NULL),(936,NULL,'bd828f3b49c241239beb8e542a40bcbd',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:00:35',NULL,'2026-02-20 10:00:35',NULL,NULL),(937,NULL,'63eac1897fad4032925daf4a4beb106b',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:00:36',NULL,'2026-02-20 10:00:36',NULL,NULL),(938,NULL,NULL,'3811bcf9aa084a2485b8e167851d7a4a',NULL,NULL,NULL,NULL,'2026-02-20 10:00:36',NULL,'2026-02-20 10:00:36',NULL,NULL),(939,NULL,'540f18eae9244cf38cf4bca8c561c1da',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:00:37',NULL,'2026-02-20 10:00:37',NULL,NULL),(940,NULL,'c46bf1229a0b4128b6de1b5e8bac25aa',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:00:37',NULL,'2026-02-20 10:00:37',NULL,NULL),(941,NULL,NULL,'30e9675492b94fbfb1190da91dd57205',NULL,NULL,NULL,NULL,'2026-02-20 10:00:39',NULL,'2026-02-20 10:00:39',NULL,NULL),(942,NULL,NULL,'547cd9b939fb42e980f064389a5be33e',NULL,NULL,NULL,NULL,'2026-02-20 10:00:39',NULL,'2026-02-20 10:00:39',NULL,NULL),(943,NULL,'65d75f4c4e034ef0adff730a323b42fc',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:00:41',NULL,'2026-02-20 10:00:41',NULL,NULL),(944,NULL,'4566fb4070254eaa91389beac2869834',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:00:41',NULL,'2026-02-20 10:00:41',NULL,NULL),(945,NULL,NULL,'e2403c6acd6d4934a0d7baec8e166e83',NULL,NULL,NULL,NULL,'2026-02-20 10:00:41',NULL,'2026-02-20 10:00:41',NULL,NULL),(946,NULL,NULL,'21cbeb9a927145a3bbcad8958770ed83',NULL,NULL,NULL,NULL,'2026-02-20 10:00:41',NULL,'2026-02-20 10:00:41',NULL,NULL),(947,NULL,NULL,'41c298455b7f47aa99f21958bfa61097',NULL,NULL,NULL,NULL,'2026-02-20 10:00:42',NULL,'2026-02-20 10:00:42',NULL,NULL),(948,NULL,NULL,'2ba1a8d771344f0a918e0a8bed2efd06',NULL,NULL,NULL,NULL,'2026-02-20 10:00:42',NULL,'2026-02-20 10:00:42',NULL,NULL),(949,NULL,'9fdf2c09b98d48c0bc67cc1c7702a8f4',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:00:43',NULL,'2026-02-20 10:00:43',NULL,NULL),(950,NULL,'aa9f929345974053942659a5eda45514',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:00:43',NULL,'2026-02-20 10:00:43',NULL,NULL),(951,NULL,'f656f9df86ae4c53b02f471da5bd5ad7',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:00:43',NULL,'2026-02-20 10:00:43',NULL,NULL),(952,NULL,'8fac2513a3ab4162a13f560c6301f671',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:00:44',NULL,'2026-02-20 10:00:44',NULL,NULL),(953,NULL,NULL,'7e30214830a74d3fb604356b76df7f6d',NULL,NULL,NULL,NULL,'2026-02-20 10:00:44',NULL,'2026-02-20 10:00:44',NULL,NULL),(954,NULL,'39c25a9c9a99474ca081350edaed5ee1',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:00:45',NULL,'2026-02-20 10:00:45',NULL,NULL),(955,NULL,NULL,'b5038775fc00469aae9f1bf9af69dcaf',NULL,NULL,NULL,NULL,'2026-02-20 10:00:49',NULL,'2026-02-20 10:00:49',NULL,NULL),(956,NULL,NULL,'b05ed06b6d1849abbe2397c7c658f915',NULL,NULL,NULL,NULL,'2026-02-20 10:00:49',NULL,'2026-02-20 10:00:49',NULL,NULL),(957,NULL,NULL,'771b7b365faf432fbf7aafb4f9d2e4c8',NULL,NULL,NULL,NULL,'2026-02-20 10:00:49',NULL,'2026-02-20 10:00:49',NULL,NULL),(958,NULL,NULL,'a84a950317b14c8a96b58a1678ff5255',NULL,NULL,NULL,NULL,'2026-02-20 10:00:49',NULL,'2026-02-20 10:00:49',NULL,NULL),(959,NULL,'61bf8f493c4b43ada4566b663f38f160',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:00:50',NULL,'2026-02-20 10:00:50',NULL,NULL),(960,NULL,NULL,'a31e3377bc8f4576abbe4ac941b7bfa3',NULL,NULL,NULL,NULL,'2026-02-20 10:00:52',NULL,'2026-02-20 10:00:52',NULL,NULL),(961,NULL,'7269c28813454d11bd17cfd0a6cf3cb1',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:00:52',NULL,'2026-02-20 10:00:52',NULL,NULL),(962,NULL,NULL,'cde95e9d1bec4875b75ef1941e7ac86f',NULL,NULL,NULL,NULL,'2026-02-20 10:00:52',NULL,'2026-02-20 10:00:52',NULL,NULL),(963,NULL,NULL,'e8624d85d62c46838001f49889e87010',NULL,NULL,NULL,NULL,'2026-02-20 10:00:52',NULL,'2026-02-20 10:00:52',NULL,NULL),(964,NULL,NULL,'c6328624e3d24dc5baeed7825550a585',NULL,NULL,NULL,NULL,'2026-02-20 10:00:52',NULL,'2026-02-20 10:00:52',NULL,NULL),(965,NULL,NULL,'ce9ce5cb1ee74b5f87cfa0ff91e5add9',NULL,NULL,NULL,NULL,'2026-02-20 10:00:53',NULL,'2026-02-20 10:00:53',NULL,NULL),(966,NULL,'f3ab99409d424c6fbf39e56ef54c0033',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:00:53',NULL,'2026-02-20 10:00:53',NULL,NULL),(967,NULL,NULL,'0a59a4e0759a4900accbf97025764545',NULL,NULL,NULL,NULL,'2026-02-20 10:00:53',NULL,'2026-02-20 10:00:53',NULL,NULL),(968,NULL,'af9d55219a474f6a9c5ab0f5d5b13023',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:00:54',NULL,'2026-02-20 10:00:54',NULL,NULL),(969,NULL,'55965a8332c94f2da5d707adc081ab9c',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:00:54',NULL,'2026-02-20 10:00:54',NULL,NULL),(970,NULL,'c5b59294e1d548e386c33d09566a66d4',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:00:54',NULL,'2026-02-20 10:00:54',NULL,NULL),(971,NULL,'3ef7f184c684442db427f7fd2ffd3dfd',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:00:55',NULL,'2026-02-20 10:00:55',NULL,NULL),(972,NULL,NULL,'05a1978acf574e179ce39bab096f320a',NULL,NULL,NULL,NULL,'2026-02-20 10:00:56',NULL,'2026-02-20 10:00:56',NULL,NULL),(973,NULL,NULL,'642a645428dc497fb1c20faaac643b8e',NULL,NULL,NULL,NULL,'2026-02-20 10:00:56',NULL,'2026-02-20 10:00:56',NULL,NULL),(974,NULL,NULL,'db5b4f7a88fb448daf836f6600f2fbe4',NULL,NULL,NULL,NULL,'2026-02-20 10:00:57',NULL,'2026-02-20 10:00:57',NULL,NULL),(975,NULL,'9ce5a52649bb4df9a705817aa7ecddca',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:00:58',NULL,'2026-02-20 10:00:58',NULL,NULL),(976,NULL,'7f28560eeca240a382dd3b19ab789dd5',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:00:58',NULL,'2026-02-20 10:00:58',NULL,NULL),(977,NULL,'246d51d6c69f4dd7bb1104d5d120aaeb',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:00:59',NULL,'2026-02-20 10:00:59',NULL,NULL),(978,NULL,NULL,'19788c38a28e437cb64efcca720105be',NULL,NULL,NULL,NULL,'2026-02-20 10:01:01',NULL,'2026-02-20 10:01:01',NULL,NULL),(979,NULL,NULL,'a4b4f4e535804405a115aba5f34bf88d',NULL,NULL,NULL,NULL,'2026-02-20 10:01:02',NULL,'2026-02-20 10:01:02',NULL,NULL),(980,NULL,NULL,'92bd65d8086f4d33a186c08e79937825',NULL,NULL,NULL,NULL,'2026-02-20 10:01:02',NULL,'2026-02-20 10:01:02',NULL,NULL),(981,NULL,NULL,'e79bea78a6954379b40b85507427956b',NULL,NULL,NULL,NULL,'2026-02-20 10:01:02',NULL,'2026-02-20 10:01:02',NULL,NULL),(982,NULL,NULL,'e3c6bc19b8764827863fa2fcb39a6139',NULL,NULL,NULL,NULL,'2026-02-20 10:01:02',NULL,'2026-02-20 10:01:02',NULL,NULL),(983,NULL,'9b4e875799ef4c39a491fbb1cf3f870d',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:02',NULL,'2026-02-20 10:01:02',NULL,NULL),(984,NULL,'bdd870edbab946dfb9a9222903e871fe',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:03',NULL,'2026-02-20 10:01:03',NULL,NULL),(985,NULL,'bff03a999ba44b9bad29218248dce077',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:04',NULL,'2026-02-20 10:01:04',NULL,NULL),(986,NULL,NULL,'c18598f89821490fadfb47e1cca95119',NULL,NULL,NULL,NULL,'2026-02-20 10:01:04',NULL,'2026-02-20 10:01:04',NULL,NULL),(987,NULL,'87ee13d6b2424d0cb5ceffa5d11f2d34',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:04',NULL,'2026-02-20 10:01:04',NULL,NULL),(988,NULL,'1cb274985ec14d71a976b19653f535b8',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:05',NULL,'2026-02-20 10:01:05',NULL,NULL),(989,NULL,NULL,'01f619ef01964cfb8906f3d5f60b087d',NULL,NULL,NULL,NULL,'2026-02-20 10:01:07',NULL,'2026-02-20 10:01:07',NULL,NULL),(990,NULL,'a87693d75a9543268fe7edf904d34844',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:08',NULL,'2026-02-20 10:01:08',NULL,NULL),(991,NULL,NULL,'cbd4c180af67497989b022e398f54cc0',NULL,NULL,NULL,NULL,'2026-02-20 10:01:09',NULL,'2026-02-20 10:01:09',NULL,NULL),(992,NULL,NULL,'600ebf62a2024f7aa8c1b7176d5ed9c6',NULL,NULL,NULL,NULL,'2026-02-20 10:01:09',NULL,'2026-02-20 10:01:09',NULL,NULL),(993,NULL,NULL,'6980113c4b5842759e50a974195113e2',NULL,NULL,NULL,NULL,'2026-02-20 10:01:10',NULL,'2026-02-20 10:01:10',NULL,NULL),(994,NULL,NULL,'d5a4dbec534b402eabf330c7f6e8ad0c',NULL,NULL,NULL,NULL,'2026-02-20 10:01:10',NULL,'2026-02-20 10:01:10',NULL,NULL),(995,NULL,'1effd5c1f8144a25a1cfdcbbbfeeb59f',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:10',NULL,'2026-02-20 10:01:10',NULL,NULL),(996,NULL,NULL,'6def41726bb1492eb7cc46325f95c7cf',NULL,NULL,NULL,NULL,'2026-02-20 10:01:10',NULL,'2026-02-20 10:01:10',NULL,NULL),(997,NULL,NULL,'132009b7cae947c2a949a1e7d1bec18d',NULL,NULL,NULL,NULL,'2026-02-20 10:01:11',NULL,'2026-02-20 10:01:11',NULL,NULL),(998,NULL,'8e7f62f132a84ae7933ec88e31b5244c',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:11',NULL,'2026-02-20 10:01:11',NULL,NULL),(999,NULL,NULL,'48484ad27c834387b5cd08bd9fa83ba2',NULL,NULL,NULL,NULL,'2026-02-20 10:01:11',NULL,'2026-02-20 10:01:11',NULL,NULL),(1000,NULL,NULL,'e9ac31a4015b421dab389cffe00f8e38',NULL,NULL,NULL,NULL,'2026-02-20 10:01:11',NULL,'2026-02-20 10:01:11',NULL,NULL),(1001,NULL,'5ed17d2498ba404a837595f94288d969',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:11',NULL,'2026-02-20 10:01:11',NULL,NULL),(1002,NULL,NULL,'3b130dc20c6948ab9f4e488fa22e1845',NULL,NULL,NULL,NULL,'2026-02-20 10:01:11',NULL,'2026-02-20 10:01:11',NULL,NULL),(1003,NULL,'220e6c2e52ea4a94bfa454d290128ba1',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:12',NULL,'2026-02-20 10:01:12',NULL,NULL),(1004,NULL,'b025f7e649e14d85948ffdb8dffe9697',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:12',NULL,'2026-02-20 10:01:12',NULL,NULL),(1005,NULL,NULL,'d383d28dae124ddc839f66c207f77fb3',NULL,NULL,NULL,NULL,'2026-02-20 10:01:13',NULL,'2026-02-20 10:01:13',NULL,NULL),(1006,NULL,NULL,'a3a8d1a2331d4d8a8c70aa36ab31bfa6',NULL,NULL,NULL,NULL,'2026-02-20 10:01:13',NULL,'2026-02-20 10:01:13',NULL,NULL),(1007,NULL,NULL,'876420344268402db9c074276bcb13f1',NULL,NULL,NULL,NULL,'2026-02-20 10:01:13',NULL,'2026-02-20 10:01:13',NULL,NULL),(1008,NULL,'727c0c22d1ce4028b1005009489ab45d',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:13',NULL,'2026-02-20 10:01:13',NULL,NULL),(1009,NULL,NULL,'936b06634ffd4eb39e68afd76be163dd',NULL,NULL,NULL,NULL,'2026-02-20 10:01:13',NULL,'2026-02-20 10:01:13',NULL,NULL),(1010,NULL,'a6bf77e1495e43cf860c1455170d3357',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:14',NULL,'2026-02-20 10:01:14',NULL,NULL),(1011,NULL,'931b9b1fe1b449bdbb7a6a04cc21096e',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:14',NULL,'2026-02-20 10:01:14',NULL,NULL),(1012,NULL,'5c677d2391c848e998f6e775f992a3f1',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:14',NULL,'2026-02-20 10:01:14',NULL,NULL),(1013,NULL,NULL,'2e3a1a07e08b45baa885977013071b9f',NULL,NULL,NULL,NULL,'2026-02-20 10:01:15',NULL,'2026-02-20 10:01:15',NULL,NULL),(1014,NULL,'9ab3b72b32c34282babd0f59e5d9bd6f',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:15',NULL,'2026-02-20 10:01:15',NULL,NULL),(1015,NULL,NULL,'0ed66b3d9de0414295024c54b79a426c',NULL,NULL,NULL,NULL,'2026-02-20 10:01:16',NULL,'2026-02-20 10:01:16',NULL,NULL),(1016,NULL,'e8035fa10e5f4d1aae154d58e76a9729',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:16',NULL,'2026-02-20 10:01:16',NULL,NULL),(1017,NULL,'f9efb9759aa745ff8734db6d672d1f31',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:17',NULL,'2026-02-20 10:01:17',NULL,NULL),(1018,NULL,NULL,'03068d945a904ed681322842db1eca83',NULL,NULL,NULL,NULL,'2026-02-20 10:01:17',NULL,'2026-02-20 10:01:17',NULL,NULL),(1019,NULL,'d3558f588a6e4dd690ecc5be43692a2e',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:18',NULL,'2026-02-20 10:01:18',NULL,NULL),(1020,NULL,NULL,'2dbcf4f74f5e41b1a8400f2f449822c3',NULL,NULL,NULL,NULL,'2026-02-20 10:01:19',NULL,'2026-02-20 10:01:19',NULL,NULL),(1021,NULL,NULL,'213231b821dd4a49aef80b9f9c5baadd',NULL,NULL,NULL,NULL,'2026-02-20 10:01:20',NULL,'2026-02-20 10:01:20',NULL,NULL),(1022,NULL,'07ed43efcae34b9da6ae3be640d79e05',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:20',NULL,'2026-02-20 10:01:20',NULL,NULL),(1023,NULL,NULL,'3878ee40d293439fb77d533cd8dd6e23',NULL,NULL,NULL,NULL,'2026-02-20 10:01:20',NULL,'2026-02-20 10:01:20',NULL,NULL),(1024,NULL,NULL,'13aa2bc594de47359a3e673f688aa24e',NULL,NULL,NULL,NULL,'2026-02-20 10:01:21',NULL,'2026-02-20 10:01:21',NULL,NULL),(1025,NULL,'f0c3e926deac40968938ca01c0843a52',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:21',NULL,'2026-02-20 10:01:21',NULL,NULL),(1026,NULL,NULL,'927c029fa5ae488cb8d1b7f88aa4b4a4',NULL,NULL,NULL,NULL,'2026-02-20 10:01:21',NULL,'2026-02-20 10:01:21',NULL,NULL),(1027,NULL,NULL,'991a9f1aa0cb4b678c561b7a23632448',NULL,NULL,NULL,NULL,'2026-02-20 10:01:21',NULL,'2026-02-20 10:01:21',NULL,NULL),(1028,NULL,NULL,'a3d7a3fc66854b9fb92a3b1665bddb78',NULL,NULL,NULL,NULL,'2026-02-20 10:01:22',NULL,'2026-02-20 10:01:22',NULL,NULL),(1029,NULL,NULL,'5eff6a7d4a954420a1461705b5b4d25e',NULL,NULL,NULL,NULL,'2026-02-20 10:01:22',NULL,'2026-02-20 10:01:22',NULL,NULL),(1030,NULL,NULL,'2efff1c5c0474e1cb2229959a8798c51',NULL,NULL,NULL,NULL,'2026-02-20 10:01:22',NULL,'2026-02-20 10:01:22',NULL,NULL),(1031,NULL,'c24abf1e78544b85b7ee4c977aa7ec1b',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:22',NULL,'2026-02-20 10:01:22',NULL,NULL),(1032,NULL,'aaa8fb9ba68b49a88d7361c73f09e685',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:23',NULL,'2026-02-20 10:01:23',NULL,NULL),(1033,NULL,'466ab6564c96414a880121fb7a854848',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:23',NULL,'2026-02-20 10:01:23',NULL,NULL),(1034,NULL,'8f212fbfed144a409e8997f3fe3cea7a',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:23',NULL,'2026-02-20 10:01:23',NULL,NULL),(1035,NULL,NULL,'dfd93ba39bd94c4587d04c53978aae7b',NULL,NULL,NULL,NULL,'2026-02-20 10:01:24',NULL,'2026-02-20 10:01:24',NULL,NULL),(1036,NULL,'3e9d51f0e63f4b4fbde56b225fc2c963',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:25',NULL,'2026-02-20 10:01:25',NULL,NULL),(1037,NULL,NULL,'1ad17b48c85a4f10b8c88fa812ff385e',NULL,NULL,NULL,NULL,'2026-02-20 10:01:25',NULL,'2026-02-20 10:01:25',NULL,NULL),(1038,NULL,'8598a7ae7ab94fbf93912cf1c24bccbc',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:27',NULL,'2026-02-20 10:01:27',NULL,NULL),(1039,NULL,NULL,'5cd20806e8514a2f8f652db47abc5179',NULL,NULL,NULL,NULL,'2026-02-20 10:01:28',NULL,'2026-02-20 10:01:28',NULL,NULL),(1040,NULL,NULL,'c744dea67e504ed8bbe87eb5b0c1fc1e',NULL,NULL,NULL,NULL,'2026-02-20 10:01:29',NULL,'2026-02-20 10:01:29',NULL,NULL),(1041,NULL,NULL,'f26799eb9d84470286120e9d9f9a4cc8',NULL,NULL,NULL,NULL,'2026-02-20 10:01:29',NULL,'2026-02-20 10:01:29',NULL,NULL),(1042,NULL,NULL,'1673dbba8dd04709b74d28aa30d650e7',NULL,NULL,NULL,NULL,'2026-02-20 10:01:29',NULL,'2026-02-20 10:01:29',NULL,NULL),(1043,NULL,'2a3562aca8c74cf5843d7d8de23cdf55',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:29',NULL,'2026-02-20 10:01:29',NULL,NULL),(1044,NULL,'17942e30758148b3afb46920a881e2c1',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:30',NULL,'2026-02-20 10:01:30',NULL,NULL),(1045,NULL,'9e2096cc0f5e4070b6434e568416b93c',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:30',NULL,'2026-02-20 10:01:30',NULL,NULL),(1046,NULL,'8e04bc360fa14db4a793bc5de7a0a299',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:31',NULL,'2026-02-20 10:01:31',NULL,NULL),(1047,NULL,NULL,'10115405e9cc48d089dd49419a2f1379',NULL,NULL,NULL,NULL,'2026-02-20 10:01:31',NULL,'2026-02-20 10:01:31',NULL,NULL),(1048,NULL,'aee607d530b844b6a4c38cc404a2d920',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:32',NULL,'2026-02-20 10:01:32',NULL,NULL),(1049,NULL,NULL,'e8ebf552c62f41d5ab1736f36c4a7412',NULL,NULL,NULL,NULL,'2026-02-20 10:01:36',NULL,'2026-02-20 10:01:36',NULL,NULL),(1050,NULL,NULL,'78fa6fb5b778437794cdb6d1438412b0',NULL,NULL,NULL,NULL,'2026-02-20 10:01:40',NULL,'2026-02-20 10:01:40',NULL,NULL),(1051,NULL,NULL,'909c0a77141a4188b66fd23e389b9194',NULL,NULL,NULL,NULL,'2026-02-20 10:01:43',NULL,'2026-02-20 10:01:43',NULL,NULL),(1052,NULL,NULL,'a9d4566f87d14e1d8ee64a52b67c8fca',NULL,NULL,NULL,NULL,'2026-02-20 10:01:43',NULL,'2026-02-20 10:01:43',NULL,NULL),(1053,NULL,NULL,'596b7db794ec4a1ba2829af4b784b600',NULL,NULL,NULL,NULL,'2026-02-20 10:01:43',NULL,'2026-02-20 10:01:43',NULL,NULL),(1054,NULL,NULL,'345374ef0e4d4f488e63abd7bfa28b3f',NULL,NULL,NULL,NULL,'2026-02-20 10:01:43',NULL,'2026-02-20 10:01:43',NULL,NULL),(1055,NULL,NULL,'5f2b08238ced4fe1b4d8e55ee684661d',NULL,NULL,NULL,NULL,'2026-02-20 10:01:44',NULL,'2026-02-20 10:01:44',NULL,NULL),(1056,NULL,NULL,'ab6ebb6dcc6e4cab9332daf1381aba0b',NULL,NULL,NULL,NULL,'2026-02-20 10:01:44',NULL,'2026-02-20 10:01:44',NULL,NULL),(1057,NULL,'8379be9e0a0543189f94c822f9c76f3f',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:44',NULL,'2026-02-20 10:01:44',NULL,NULL),(1058,NULL,'a436fb7980cf4013ae8fb76a16b37ffb',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:44',NULL,'2026-02-20 10:01:44',NULL,NULL),(1059,NULL,'a70836795ce240d8aacde75e2e9ee636',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:45',NULL,'2026-02-20 10:01:45',NULL,NULL),(1060,NULL,'77138a2ad276469cab7b615f9b36fe35',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:45',NULL,'2026-02-20 10:01:45',NULL,NULL),(1061,NULL,'bf508aa6828a4ce0abfa81e79193af3e',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:45',NULL,'2026-02-20 10:01:45',NULL,NULL),(1062,NULL,'a986e1cee42e4d20a367d286ff5b4908',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:46',NULL,'2026-02-20 10:01:46',NULL,NULL),(1063,NULL,NULL,'da1ffe19ccd84cfeaafda0d3b551a3c3',NULL,NULL,NULL,NULL,'2026-02-20 10:01:48',NULL,'2026-02-20 10:01:48',NULL,NULL),(1064,NULL,NULL,'5c3a312a51574695bd2b9a7ca80fa953',NULL,NULL,NULL,NULL,'2026-02-20 10:01:48',NULL,'2026-02-20 10:01:48',NULL,NULL),(1065,NULL,'b832dcf667f54618a9719d294f4bab58',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:49',NULL,'2026-02-20 10:01:49',NULL,NULL),(1066,NULL,'a118e7764ebe412e9b2c989ea7ee5857',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:49',NULL,'2026-02-20 10:01:49',NULL,NULL),(1067,NULL,NULL,'c0ffd871c6b84525954588250c225d58',NULL,NULL,NULL,NULL,'2026-02-20 10:01:49',NULL,'2026-02-20 10:01:49',NULL,NULL),(1068,NULL,NULL,'6e0a1e0ae3534b38bf1af0ecef725e03',NULL,NULL,NULL,NULL,'2026-02-20 10:01:49',NULL,'2026-02-20 10:01:49',NULL,NULL),(1069,NULL,NULL,'f513bc846858471ca213b468a9b8b076',NULL,NULL,NULL,NULL,'2026-02-20 10:01:49',NULL,'2026-02-20 10:01:49',NULL,NULL),(1070,NULL,NULL,'93bb64cba2a443a994de64aff616dc55',NULL,NULL,NULL,NULL,'2026-02-20 10:01:50',NULL,'2026-02-20 10:01:50',NULL,NULL),(1071,NULL,'cff212d1a4ec47a198eaffb5418f0f33',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:51',NULL,'2026-02-20 10:01:51',NULL,NULL),(1072,NULL,'fa5f5f12701349488e6f9e875b4ddfa7',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:51',NULL,'2026-02-20 10:01:51',NULL,NULL),(1073,NULL,'08456f6eba5847d5bb12cc041f951cc1',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:52',NULL,'2026-02-20 10:01:52',NULL,NULL),(1074,NULL,NULL,'a45af7c23eb943e591e6e991634c9001',NULL,NULL,NULL,NULL,'2026-02-20 10:01:57',NULL,'2026-02-20 10:01:57',NULL,NULL),(1075,NULL,NULL,'abfc7066474645aa9e44d1cb1c90bd33',NULL,NULL,NULL,NULL,'2026-02-20 10:01:57',NULL,'2026-02-20 10:01:57',NULL,NULL),(1076,NULL,NULL,'b70d5a61719046998fbdd1d26507f868',NULL,NULL,NULL,NULL,'2026-02-20 10:01:58',NULL,'2026-02-20 10:01:58',NULL,NULL),(1077,NULL,NULL,'b4791555d96c46608841a335bf144cff',NULL,NULL,NULL,NULL,'2026-02-20 10:01:58',NULL,'2026-02-20 10:01:58',NULL,NULL),(1078,NULL,NULL,'d89f9e72a2434e04a13c2b14211cf338',NULL,NULL,NULL,NULL,'2026-02-20 10:01:58',NULL,'2026-02-20 10:01:58',NULL,NULL),(1079,NULL,'649e339601744bf38d39cfbdf90b20e8',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:59',NULL,'2026-02-20 10:01:59',NULL,NULL),(1080,NULL,'4c88edd6a2ff4b19b0696fe79c3f505e',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:01:59',NULL,'2026-02-20 10:01:59',NULL,NULL),(1081,NULL,'045ddb7b79984c23b6d657b11cb1af87',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:00',NULL,'2026-02-20 10:02:00',NULL,NULL),(1082,NULL,NULL,'cbafbbc37779492981511920ba270952',NULL,NULL,NULL,NULL,'2026-02-20 10:02:01',NULL,'2026-02-20 10:02:01',NULL,NULL),(1083,NULL,NULL,'e36239f2dbb54df4852719d68399e9ad',NULL,NULL,NULL,NULL,'2026-02-20 10:02:01',NULL,'2026-02-20 10:02:01',NULL,NULL),(1084,NULL,NULL,'dea8bfbf79d84ac695b87f4f7781bcd1',NULL,NULL,NULL,NULL,'2026-02-20 10:02:01',NULL,'2026-02-20 10:02:01',NULL,NULL),(1085,NULL,'69ba5a301c764301aca0e0e42ed3d123',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:02',NULL,'2026-02-20 10:02:02',NULL,NULL),(1086,NULL,'82f61c6a9a7c4d619c37975b579d49a9',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:02',NULL,'2026-02-20 10:02:02',NULL,NULL),(1087,NULL,'e2c7618200d34da3a2f64f252dae7492',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:03',NULL,'2026-02-20 10:02:03',NULL,NULL),(1088,NULL,NULL,'1618ad118c6842b590b71c56bba463c9',NULL,NULL,NULL,NULL,'2026-02-20 10:02:05',NULL,'2026-02-20 10:02:05',NULL,NULL),(1089,NULL,NULL,'d2eac51571e847448d539b1c360c6c91',NULL,NULL,NULL,NULL,'2026-02-20 10:02:07',NULL,'2026-02-20 10:02:07',NULL,NULL),(1090,NULL,NULL,'174188e09f804a1f816c30718c4ffefa',NULL,NULL,NULL,NULL,'2026-02-20 10:02:07',NULL,'2026-02-20 10:02:07',NULL,NULL),(1091,NULL,NULL,'cc2a2a904191451c84ca03db9548b1c1',NULL,NULL,NULL,NULL,'2026-02-20 10:02:07',NULL,'2026-02-20 10:02:07',NULL,NULL),(1092,NULL,NULL,'996f2783470341f18a642c0718090173',NULL,NULL,NULL,NULL,'2026-02-20 10:02:08',NULL,'2026-02-20 10:02:08',NULL,NULL),(1093,NULL,'032bab6fea8a42baad479d4511ecf307',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:09',NULL,'2026-02-20 10:02:09',NULL,NULL),(1094,NULL,'a4cee113c95c4b31a9978ee42c8b9b17',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:09',NULL,'2026-02-20 10:02:09',NULL,NULL),(1095,NULL,'f04a8eabe8e949f3a1456d71bf86661a',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:11',NULL,'2026-02-20 10:02:11',NULL,NULL),(1096,NULL,NULL,'a0c9395dc24d4c11b818a51ae2f49d99',NULL,NULL,NULL,NULL,'2026-02-20 10:02:12',NULL,'2026-02-20 10:02:12',NULL,NULL),(1097,NULL,NULL,'7d16468bdacd4009b152638bd79b161e',NULL,NULL,NULL,NULL,'2026-02-20 10:02:16',NULL,'2026-02-20 10:02:16',NULL,NULL),(1098,NULL,NULL,'bac13e3bc0e349db8eca0b26ddbee5ee',NULL,NULL,NULL,NULL,'2026-02-20 10:02:16',NULL,'2026-02-20 10:02:16',NULL,NULL),(1099,NULL,NULL,'7bfee52a5c724e069562a3950991091f',NULL,NULL,NULL,NULL,'2026-02-20 10:02:16',NULL,'2026-02-20 10:02:16',NULL,NULL),(1100,NULL,NULL,'0c712234fc3446e291d4acfcd1916288',NULL,NULL,NULL,NULL,'2026-02-20 10:02:16',NULL,'2026-02-20 10:02:16',NULL,NULL),(1101,NULL,'2ad58329e7a14a9e8c2f8a87be176f28',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:18',NULL,'2026-02-20 10:02:18',NULL,NULL),(1102,NULL,NULL,'82f001ca71d44f64a2f5d622ba81e489',NULL,NULL,NULL,NULL,'2026-02-20 10:02:18',NULL,'2026-02-20 10:02:18',NULL,NULL),(1103,NULL,NULL,'7569bbcff9fc4b6e92a66559cfc39fad',NULL,NULL,NULL,NULL,'2026-02-20 10:02:18',NULL,'2026-02-20 10:02:18',NULL,NULL),(1104,NULL,NULL,'fad85e1eee67455aad7389a74af3e3c5',NULL,NULL,NULL,NULL,'2026-02-20 10:02:18',NULL,'2026-02-20 10:02:18',NULL,NULL),(1105,NULL,NULL,'9684238aad3349e4be119bf7c0dc53d5',NULL,NULL,NULL,NULL,'2026-02-20 10:02:18',NULL,'2026-02-20 10:02:18',NULL,NULL),(1106,NULL,NULL,'030bb5ff3baf490f8ef98f23847b668f',NULL,NULL,NULL,NULL,'2026-02-20 10:02:18',NULL,'2026-02-20 10:02:18',NULL,NULL),(1107,NULL,'26c6cea704984d3ea4ffb212bcaed62f',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:18',NULL,'2026-02-20 10:02:18',NULL,NULL),(1108,NULL,NULL,'ab5c67b4260a42149a79986b02cc4a2c',NULL,NULL,NULL,NULL,'2026-02-20 10:02:19',NULL,'2026-02-20 10:02:19',NULL,NULL),(1109,NULL,'d3311cde3c7d4d00a3306ea861856fbd',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:19',NULL,'2026-02-20 10:02:19',NULL,NULL),(1110,NULL,'766977986b8d4935995086e1b7f48c1d',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:20',NULL,'2026-02-20 10:02:20',NULL,NULL),(1111,NULL,'e25d258e44024701a6573909315fd0be',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:20',NULL,'2026-02-20 10:02:20',NULL,NULL),(1112,NULL,'d5d2c6f06b674830ae762a2b6619a376',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:21',NULL,'2026-02-20 10:02:21',NULL,NULL),(1113,NULL,'45448aed55694db39d5cf1e0e0b542b9',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:21',NULL,'2026-02-20 10:02:21',NULL,NULL),(1114,NULL,'bcdd9afe09234c518ed1b3585ae70789',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:22',NULL,'2026-02-20 10:02:22',NULL,NULL),(1115,NULL,'3ee09efe1b1441fd862a4eb1621e86f7',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:22',NULL,'2026-02-20 10:02:22',NULL,NULL),(1116,NULL,NULL,'5d2ad756f245461f8d1f606eaf615bc9',NULL,NULL,NULL,NULL,'2026-02-20 10:02:26',NULL,'2026-02-20 10:02:26',NULL,NULL),(1117,NULL,NULL,'be27c43754f0411f836476b7fed99137',NULL,NULL,NULL,NULL,'2026-02-20 10:02:27',NULL,'2026-02-20 10:02:27',NULL,NULL),(1118,NULL,NULL,'847a05aac20a48b090776fc052ce7bc3',NULL,NULL,NULL,NULL,'2026-02-20 10:02:27',NULL,'2026-02-20 10:02:27',NULL,NULL),(1119,NULL,NULL,'77ee1f680fec437fa44fae27cfd00e21',NULL,NULL,NULL,NULL,'2026-02-20 10:02:27',NULL,'2026-02-20 10:02:27',NULL,NULL),(1120,NULL,'3a86545a7242437faef7151aee6c65ac',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:28',NULL,'2026-02-20 10:02:28',NULL,NULL),(1121,NULL,'3ccd93b5ab144c10baf3f2525baddd4b',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:28',NULL,'2026-02-20 10:02:28',NULL,NULL),(1122,NULL,'b151669fcf7148fcbeedbd07eff8801f',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:29',NULL,'2026-02-20 10:02:29',NULL,NULL),(1123,NULL,NULL,'5eadb5eed7bb4cd1bb3facaa249e83ed',NULL,NULL,NULL,NULL,'2026-02-20 10:02:34',NULL,'2026-02-20 10:02:34',NULL,NULL),(1124,NULL,NULL,'77dafdbf007f49d68078ce99964ab9be',NULL,NULL,NULL,NULL,'2026-02-20 10:02:34',NULL,'2026-02-20 10:02:34',NULL,NULL),(1125,NULL,NULL,'afc9e96105b646f78051750b5d312598',NULL,NULL,NULL,NULL,'2026-02-20 10:02:34',NULL,'2026-02-20 10:02:34',NULL,NULL),(1126,NULL,NULL,'13067f2b863745eabca3330d64ec4f59',NULL,NULL,NULL,NULL,'2026-02-20 10:02:35',NULL,'2026-02-20 10:02:35',NULL,NULL),(1127,NULL,NULL,'f508469c10a94c7bb610e805bbbc6a79',NULL,NULL,NULL,NULL,'2026-02-20 10:02:35',NULL,'2026-02-20 10:02:35',NULL,NULL),(1128,NULL,NULL,'f46d44edd27346438a1eff1c2b567903',NULL,NULL,NULL,NULL,'2026-02-20 10:02:35',NULL,'2026-02-20 10:02:35',NULL,NULL),(1129,NULL,NULL,'57cb2136cffa4f5984596f925b390128',NULL,NULL,NULL,NULL,'2026-02-20 10:02:36',NULL,'2026-02-20 10:02:36',NULL,NULL),(1130,NULL,'3d4b0a39007c41b9a5f8086045d0a546',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:37',NULL,'2026-02-20 10:02:37',NULL,NULL),(1131,NULL,'b3d0b83eb9d040b2a1ee21f2d4ef3fce',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:37',NULL,'2026-02-20 10:02:37',NULL,NULL),(1132,NULL,'68a6dfaa5a244e82963414de97f45e1c',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:38',NULL,'2026-02-20 10:02:38',NULL,NULL),(1133,NULL,NULL,'e4c734194bfd45018fd58baabce64bf6',NULL,NULL,NULL,NULL,'2026-02-20 10:02:38',NULL,'2026-02-20 10:02:38',NULL,NULL),(1134,NULL,NULL,'846cf608132c427495c69f984109cbae',NULL,NULL,NULL,NULL,'2026-02-20 10:02:38',NULL,'2026-02-20 10:02:38',NULL,NULL),(1135,NULL,NULL,'8630db7f3e5e49e684aa4691d6b0235d',NULL,NULL,NULL,NULL,'2026-02-20 10:02:38',NULL,'2026-02-20 10:02:38',NULL,NULL),(1136,NULL,'386ea85270f241479a6a9e0bddeec0cd',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:38',NULL,'2026-02-20 10:02:38',NULL,NULL),(1137,NULL,'2059aefdc37e4a0296a16d8be3ed62ca',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:39',NULL,'2026-02-20 10:02:39',NULL,NULL),(1138,NULL,'ad1dd0d43ec7421b9a4a06c39e3657c6',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:40',NULL,'2026-02-20 10:02:40',NULL,NULL),(1139,NULL,'05c62a1c7488483a8c26997ab9cd78c9',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:41',NULL,'2026-02-20 10:02:41',NULL,NULL),(1140,NULL,NULL,'1fe1df0d3a9d43d68094971a51c49376',NULL,NULL,NULL,NULL,'2026-02-20 10:02:52',NULL,'2026-02-20 10:02:52',NULL,NULL),(1141,NULL,NULL,'4e9df6a2592c43558d50a97bf9b1b30a',NULL,NULL,NULL,NULL,'2026-02-20 10:02:53',NULL,'2026-02-20 10:02:53',NULL,NULL),(1142,NULL,'bc8fc0e37a6140138157135bf1aff7f6',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:53',NULL,'2026-02-20 10:02:53',NULL,NULL),(1143,NULL,NULL,'ef3d573397e946b78d7f99d472476cf2',NULL,NULL,NULL,NULL,'2026-02-20 10:02:53',NULL,'2026-02-20 10:02:53',NULL,NULL),(1144,NULL,NULL,'566b3c30231242a295579c321ac55f13',NULL,NULL,NULL,NULL,'2026-02-20 10:02:53',NULL,'2026-02-20 10:02:53',NULL,NULL),(1145,NULL,NULL,'2361713eed734285b6a40d33947ce7f8',NULL,NULL,NULL,NULL,'2026-02-20 10:02:54',NULL,'2026-02-20 10:02:54',NULL,NULL),(1146,NULL,NULL,'8b2b6f4f5b134a789342f194450c66b3',NULL,NULL,NULL,NULL,'2026-02-20 10:02:54',NULL,'2026-02-20 10:02:54',NULL,NULL),(1147,NULL,NULL,'ad4d0c44b2cb45d1b6f88e333127c0a2',NULL,NULL,NULL,NULL,'2026-02-20 10:02:54',NULL,'2026-02-20 10:02:54',NULL,NULL),(1148,NULL,'e7a5b2c8356e4ac789ec5df8bb7ec411',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:55',NULL,'2026-02-20 10:02:55',NULL,NULL),(1149,NULL,'6f93a5cb09704799837d31f6d6149293',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:55',NULL,'2026-02-20 10:02:55',NULL,NULL),(1150,NULL,'72f6de9a4d894029be8ca744061d09cb',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:02:56',NULL,'2026-02-20 10:02:56',NULL,NULL),(1151,NULL,NULL,'62f732ee77de47129adeeeae62885689',NULL,NULL,NULL,NULL,'2026-02-20 10:02:59',NULL,'2026-02-20 10:02:59',NULL,NULL),(1152,NULL,NULL,'7d10ce1257bf4ed181d67949e39fa8e2',NULL,NULL,NULL,NULL,'2026-02-20 10:02:59',NULL,'2026-02-20 10:02:59',NULL,NULL),(1153,NULL,NULL,'9f98e758a2314dc1a9ff7d2178f708d5',NULL,NULL,NULL,NULL,'2026-02-20 10:02:59',NULL,'2026-02-20 10:02:59',NULL,NULL),(1154,NULL,NULL,'0d95d80655c34179b2ff0ff5a7d7ae65',NULL,NULL,NULL,NULL,'2026-02-20 10:03:00',NULL,'2026-02-20 10:03:00',NULL,NULL),(1155,NULL,'e8b3978073ff48fabcef9dcc7a541058',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:03:00',NULL,'2026-02-20 10:03:00',NULL,NULL),(1156,NULL,NULL,'7c9126e4eb6c46b9932d1080a15f7148',NULL,NULL,NULL,NULL,'2026-02-20 10:03:00',NULL,'2026-02-20 10:03:00',NULL,NULL),(1157,NULL,NULL,'5088c2c8b56d45deae5e113f6cf048e7',NULL,NULL,NULL,NULL,'2026-02-20 10:03:00',NULL,'2026-02-20 10:03:00',NULL,NULL),(1158,NULL,'7c36597f8f9743fab0ad3fa8b0dacc69',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:03:01',NULL,'2026-02-20 10:03:01',NULL,NULL),(1159,NULL,'7a4982b18b04484999b26d85ffc0aeb4',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:03:02',NULL,'2026-02-20 10:03:02',NULL,NULL),(1160,NULL,'4ee66a8a7e064506bcab5aba487223d0',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:03:02',NULL,'2026-02-20 10:03:02',NULL,NULL),(1161,NULL,'424a34c820724cb6b70bcfbbed9ee702',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:03:02',NULL,'2026-02-20 10:03:02',NULL,NULL),(1162,NULL,'32f1d5776c624aa39b7e834a4d5faec5',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:03:03',NULL,'2026-02-20 10:03:03',NULL,NULL),(1163,NULL,NULL,'f61ca372ee3d47faa667bd5a75544250',NULL,NULL,NULL,NULL,'2026-02-20 10:03:08',NULL,'2026-02-20 10:03:08',NULL,NULL),(1164,NULL,NULL,'6482d78aaee741a7b765901310c888fe',NULL,NULL,NULL,NULL,'2026-02-20 10:03:09',NULL,'2026-02-20 10:03:09',NULL,NULL),(1165,NULL,NULL,'c2b8190380cd40698309d60917f53d2b',NULL,NULL,NULL,NULL,'2026-02-20 10:03:09',NULL,'2026-02-20 10:03:09',NULL,NULL),(1166,NULL,NULL,'9dcc89c122ca4ff2814936c64cc1c2b7',NULL,NULL,NULL,NULL,'2026-02-20 10:03:09',NULL,'2026-02-20 10:03:09',NULL,NULL),(1167,NULL,'8b895cabd547455590d56713f9030019',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:03:11',NULL,'2026-02-20 10:03:11',NULL,NULL),(1168,NULL,'7ee6f0f9a6db40ad9518074ffcc8135d',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:03:12',NULL,'2026-02-20 10:03:12',NULL,NULL),(1169,NULL,'88d11de1246c432497eb6fcb4b131b8a',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:03:12',NULL,'2026-02-20 10:03:12',NULL,NULL),(1170,NULL,NULL,'38d7e62a5e1f4981bb36a0274f756182',NULL,NULL,NULL,NULL,'2026-02-20 10:03:13',NULL,'2026-02-20 10:03:13',NULL,NULL),(1171,NULL,NULL,'6d613a23957047998690426d6634d48c',NULL,NULL,NULL,NULL,'2026-02-20 10:03:16',NULL,'2026-02-20 10:03:16',NULL,NULL),(1172,NULL,'0a47e12e114b4e778ff94aca4e5dad8b',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:03:17',NULL,'2026-02-20 10:03:17',NULL,NULL),(1173,NULL,NULL,'cc7cf9b38fae4a579e698f555eceed72',NULL,NULL,NULL,NULL,'2026-02-20 10:03:19',NULL,'2026-02-20 10:03:19',NULL,NULL),(1174,NULL,NULL,'1b2c36ab611347daa8e68e830724aa09',NULL,NULL,NULL,NULL,'2026-02-20 10:03:20',NULL,'2026-02-20 10:03:20',NULL,NULL),(1175,NULL,NULL,'2d9ab25bdf90474e98f90a7003aa4a58',NULL,NULL,NULL,NULL,'2026-02-20 10:03:20',NULL,'2026-02-20 10:03:20',NULL,NULL),(1176,NULL,'0f1471a84bec4c528f2307c1018c28fc',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:03:21',NULL,'2026-02-20 10:03:21',NULL,NULL),(1177,NULL,'34227290958b43d48566076f17d50a24',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:03:21',NULL,'2026-02-20 10:03:21',NULL,NULL),(1178,NULL,'d7b13fb72a384a11a509ae5b87a155e9',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:03:22',NULL,'2026-02-20 10:03:22',NULL,NULL),(1179,NULL,NULL,'f0da2d66a2df4537b6da7dfb053af4e1',NULL,NULL,NULL,NULL,'2026-02-20 10:03:33',NULL,'2026-02-20 10:03:33',NULL,NULL),(1180,NULL,NULL,'6472a81b69a8490a8bf3c98b9cf5d6f8',NULL,NULL,NULL,NULL,'2026-02-20 10:03:40',NULL,'2026-02-20 10:03:40',NULL,NULL),(1181,NULL,NULL,'d502a58a8f78481dbe8297e0e38e7bd7',NULL,NULL,NULL,NULL,'2026-02-20 10:03:40',NULL,'2026-02-20 10:03:40',NULL,NULL),(1182,NULL,NULL,'e89adff53e724fd9bf23d5f6f80b48bb',NULL,NULL,NULL,NULL,'2026-02-20 10:03:40',NULL,'2026-02-20 10:03:40',NULL,NULL),(1183,NULL,NULL,'d220a264bdbb4557b08145d62655df27',NULL,NULL,NULL,NULL,'2026-02-20 10:03:42',NULL,'2026-02-20 10:03:42',NULL,NULL),(1184,NULL,'54b424b4bfc241c88baf0602b9e8a69b',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:03:42',NULL,'2026-02-20 10:03:42',NULL,NULL),(1185,NULL,'47c9696585c248d48fb396c6e57d2870',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:03:42',NULL,'2026-02-20 10:03:42',NULL,NULL),(1186,NULL,'52d1f3b64e6d4b9c92a0e84323b6701c',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:03:43',NULL,'2026-02-20 10:03:43',NULL,NULL),(1187,NULL,NULL,'e249a101b3ba4a47aeac841fb07037fd',NULL,NULL,NULL,NULL,'2026-02-20 10:03:48',NULL,'2026-02-20 10:03:48',NULL,NULL),(1188,NULL,NULL,'165c19af0f974bc89b482a0afd520670',NULL,NULL,NULL,NULL,'2026-02-20 10:03:49',NULL,'2026-02-20 10:03:49',NULL,NULL),(1189,NULL,NULL,'cf884b38413c411cb648df3444726fd7',NULL,NULL,NULL,NULL,'2026-02-20 10:03:49',NULL,'2026-02-20 10:03:49',NULL,NULL),(1190,NULL,'64c0e4bc9c4f49a2b268382a60f753bb',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:03:50',NULL,'2026-02-20 10:03:50',NULL,NULL),(1191,NULL,'e24b64269b354721b46df6f388fdb967',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:03:50',NULL,'2026-02-20 10:03:50',NULL,NULL),(1192,NULL,'966fda30a919409b875fff039d19cd3f',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:03:51',NULL,'2026-02-20 10:03:51',NULL,NULL),(1193,NULL,NULL,'701114a7cdc94ef2b0e080ff26e87393',NULL,NULL,NULL,NULL,'2026-02-20 10:04:12',NULL,'2026-02-20 10:04:12',NULL,NULL),(1194,NULL,NULL,'41551d42b2574751bd41d96221664e32',NULL,NULL,NULL,NULL,'2026-02-20 10:04:12',NULL,'2026-02-20 10:04:12',NULL,NULL),(1195,NULL,'5b72c01c3bfb4852b1b096bf3c216228',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:04:13',NULL,'2026-02-20 10:04:13',NULL,NULL),(1196,NULL,'bb651850cad14d76bf9ffb2d11fd8747',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:04:13',NULL,'2026-02-20 10:04:13',NULL,NULL),(1197,NULL,NULL,'682efe9e59c442b3bba143c8034cdd42',NULL,NULL,NULL,NULL,'2026-02-20 10:04:47',NULL,'2026-02-20 10:04:47',NULL,NULL),(1198,NULL,NULL,'f1094d3347a44d75b4a04d3126fb2066',NULL,NULL,NULL,NULL,'2026-02-20 10:04:47',NULL,'2026-02-20 10:04:47',NULL,NULL),(1199,NULL,'50ba22298b9844c2b9853d9ca1060aa4',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:04:47',NULL,'2026-02-20 10:04:47',NULL,NULL),(1200,NULL,'cf2a5acf56b14171a5a2864e56a6776f',NULL,NULL,NULL,NULL,NULL,'2026-02-20 10:04:48',NULL,'2026-02-20 10:04:48',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('2a26c9d87e2748b985916494831addbb','swiftoperator','{}','<<null>>',NULL),('644be31e5f394041812bd8167937931a','member','{}','<<null>>',NULL),('98378602b46040e0b4664b6f17f91a02','service','{}','<<null>>',NULL),('9b41ffadc4424c549cca081c67f29ac6','ResellerAdmin','{}','<<null>>',NULL),('cc700751479048f082e85692f6600d0d','admin','{}','<<null>>',NULL),('ce65479f257b43d5a093bd7076a8e5a1','heat_stack_user','{}','<<null>>',NULL),('d8aeb0940e1b4d27b13b646b369b8963','reader','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('644be31e5f394041812bd8167937931a','IMMU','true'),('cc700751479048f082e85692f6600d0d','IMMU','true'),('d8aeb0940e1b4d27b13b646b369b8963','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('22c723a6716f46f380d77603e40afddc','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('27f292e156e34f9e9cf67b0f9561df2c','share',1,'{\"description\": \"Manila V1 Service\", \"name\": \"manila\"}'),('29778769d34749e1bd7effe2fb5d54fa','identity',1,'{\"name\": \"keystone\"}'),('41a5262b7aa9430dba885bb7472378ba','alarming',1,'{\"description\": \"Aodh for autoscaling Service\", \"name\": \"aodh\"}'),('4d347c59e8ed4632b2d0dd86d4abe201','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('5bfd6fde3cfa4dbd8b13161ba59dbe04','cloudformation',1,'{\"description\": \"Heat Cloudformation API service\", \"name\": \"heat-cfn\"}'),('6ba10f669677407b906c39c4023af2cf','sharev2',1,'{\"description\": \"Manila V2 Service\", \"name\": \"manilav2\"}'),('8d54b02cbb2842ac97d8ce9ac66ba48b','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('995caa70407e41c3a0cb4fa3a6692721','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('ac6ee4ccaf3d4e268aa8191643d2dad8','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}'),('c87c6db283e4446083b35f2ce13931d5','orchestration',1,'{\"description\": \"Heat API service\", \"name\": \"heat\"}'),('de9b5c1b379d4542a41f5596762ebbb4','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}'),('fd532baffd844dd38cf34c5c894f000c','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`inherited` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','141ec720081546bb92f7e9338deb8445','system','cc700751479048f082e85692f6600d0d',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_expires` (`expires`),
  KEY `ix_token_expires_valid` (`expires`,`valid`),
  KEY `ix_token_user_id` (`user_id`),
  KEY `ix_token_trust_id` (`trust_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`valid` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`impersonation` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
INSERT INTO `trust_role` (`trust_id`, `role_id`) VALUES ('2ddbe2fbcaf749b3816549d5730a088e','abeea8d72ebc4499b8bee5240ec08093'),('3a53380957124ee2b3fbb628c2ca73a5','916b4cf6030f4ff3a9587e15bd54df2d'),('45729a973eef42cf9454cd565d67acbe','e7d8f7186afc439c85704c5aa2cc0288'),('ad8771eff39e4aa4865181350f7183a3','f7d6560c7bcd46b8a9f58fb1b061544a'),('efb5b5ff9fdd4af4b4a8d61655071480','278b7b554efc4ab4b55b7f76d38dcddc');
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `domain_id` (`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('00513770429844a5a4666546246bf8be','{\"email\": \"heat_stack_domain_admin@localhost\", \"description\": null}',1,NULL,'2026-02-20 08:08:36',NULL,'56508c3c3c0e4baeab4dc07a84bd9d78'),('141ec720081546bb92f7e9338deb8445','{\"email\": \"admin@localhost\"}',1,NULL,'2026-02-20 08:06:14','2026-02-20','default'),('1aee44201097494db02d5a0ec5e7b270','{\"email\": \"manila@localhost\", \"description\": null}',1,NULL,'2026-02-20 08:08:37','2026-02-20','default'),('29fecd7c129b4e79866913417e27923e','{\"email\": \"manilav2@localhost\", \"description\": null}',1,NULL,'2026-02-20 08:08:46',NULL,'default'),('3b0869df13184a91b920fca8cf2896fa','{\"email\": \"glance@localhost\", \"description\": null}',1,NULL,'2026-02-20 08:08:35','2026-02-20','default'),('92a26b03910849b19773f5ef68be1016','{\"email\": \"ceilometer@localhost\", \"description\": null}',1,NULL,'2026-02-20 08:08:34','2026-02-20','default'),('9332b168e872428cae64128f4c8874e5','{\"tenantId\": \"264535d5b76c4b86bf9c7436214b5148\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2026-02-20 09:49:50','2026-02-20','default'),('9578855b599e48b3a4d4bbfe4eebca75','{\"email\": \"nova@localhost\", \"description\": null}',1,NULL,'2026-02-20 08:08:46','2026-02-20','default'),('a732f9eab686436ba0e796c4fb81d8b9','{\"email\": \"heat-cfn@localhost\", \"description\": null}',1,NULL,'2026-02-20 08:08:36',NULL,'default'),('b8b513544fa842a6ae344dba14bf31db','{\"email\": \"cinder@localhost\", \"description\": null}',1,NULL,'2026-02-20 08:08:34','2026-02-20','default'),('c80dae22963f44ba8c18e973063f60e8','{\"email\": \"placement@localhost\", \"description\": null}',1,NULL,'2026-02-20 08:08:47','2026-02-20','default'),('c89c61ffa24148588c0da28995456d59','{\"email\": \"heat@localhost\", \"description\": null}',1,NULL,'2026-02-20 08:08:35','2026-02-20','default'),('d3e4f90a6846431f8b13739d28930fe2','{\"email\": \"aodh@localhost\", \"description\": null}',1,NULL,'2026-02-20 08:08:33','2026-02-20','default'),('d4446b63864e47aebd18955a38393018','{\"email\": \"neutron@localhost\", \"description\": null}',1,NULL,'2026-02-20 08:08:46','2026-02-20','default'),('e70a17af78b94d888060107e0ba7f912','{\"tenantId\": \"70c82d06cf3245c1b4dddd0d8c4493b6\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2026-02-20 09:49:50',NULL,'default'),('ebe74705f9b941a692221d116f352f52','{}',1,'f6685cdb0ff24cddaeb987c63c89eafb','2026-02-20 08:41:27','2026-02-20','default'),('ed1cd2326e314ca1836f768c07b469fe','{\"email\": \"swift@localhost\", \"description\": null}',1,NULL,'2026-02-20 08:08:47','2026-02-20','default'),('ee9eca1990444ff194d64f17b38bb757','{\"email\": \"gnocchi@localhost\", \"description\": null}',1,NULL,'2026-02-20 08:08:35','2026-02-20','default'),('f971eeeb93204342bb1360dba42c6139','{\"email\": \"cinderv3@localhost\", \"description\": null}',1,NULL,'2026-02-20 08:08:35',NULL,'default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `manila`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `manila` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `manila`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('aebe2a413e13');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `async_operation_data`
--

DROP TABLE IF EXISTS `async_operation_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `async_operation_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `async_operation_data`
--

LOCK TABLES `async_operation_data` WRITE;
/*!40000 ALTER TABLE `async_operation_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `async_operation_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `availability_zones`
--

DROP TABLE IF EXISTS `availability_zones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `availability_zones` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `az_name_uc` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `availability_zones`
--

LOCK TABLES `availability_zones` WRITE;
/*!40000 ALTER TABLE `availability_zones` DISABLE KEYS */;
INSERT INTO `availability_zones` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`) VALUES ('2026-02-20 08:10:16.791779',NULL,NULL,'False','8ee32c10-d6a3-412a-b6b9-be46fac09abc','nova');
/*!40000 ALTER TABLE `availability_zones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backend_info`
--

DROP TABLE IF EXISTS `backend_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backend_info` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `host` varchar(255) NOT NULL,
  `info_hash` varchar(255) NOT NULL,
  PRIMARY KEY (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backend_info`
--

LOCK TABLES `backend_info` WRITE;
/*!40000 ALTER TABLE `backend_info` DISABLE KEYS */;
INSERT INTO `backend_info` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `host`, `info_hash`) VALUES ('2026-02-20 08:54:28.709478',NULL,NULL,0,'hostgroup@cephfs','e66c0dfc0d422efa26af62f5a81dd60603e2d39a');
/*!40000 ALTER TABLE `backend_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `drivers_private_data`
--

DROP TABLE IF EXISTS `drivers_private_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `drivers_private_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `drivers_private_data`
--

LOCK TABLES `drivers_private_data` WRITE;
/*!40000 ALTER TABLE `drivers_private_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `drivers_private_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(255) DEFAULT NULL,
  `resource_id` varchar(36) DEFAULT NULL,
  `action_id` varchar(10) NOT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
INSERT INTO `messages` (`id`, `project_id`, `request_id`, `resource_type`, `resource_id`, `action_id`, `detail_id`, `message_level`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `expires_at`) VALUES ('0410b027-a187-4fe1-a57f-9cd265faef90','b025f7e649e14d85948ffdb8dffe9697','req-acd3c767-6e63-4acd-8c79-0bbf7fa78d77','SHARE','4fa03e31-ba96-417f-8b31-7b047c99fd67','001','008','ERROR','2026-02-20 10:01:04.724664',NULL,NULL,'False','2026-03-22 10:01:04'),('107539bf-fdd2-446c-bb85-538364e8042a','4559942bc629438d88ae332098961d3f','req-fda7a73f-daf7-4101-82da-160a3b3046d9','SHARE','f7536711-c226-4f82-af1d-61c2dbda095d','001','008','ERROR','2026-02-20 09:58:29.711362',NULL,NULL,'False','2026-03-22 09:58:29'),('1cc7f70c-6b0b-402b-9df5-d49bfc032114','4559942bc629438d88ae332098961d3f','req-55530e9f-c4d3-40f7-b25a-7bbb2983c127','SHARE','8d18950e-d663-4756-89c4-a4854e93c9ad','001','008','ERROR','2026-02-20 09:58:19.525007',NULL,NULL,'False','2026-03-22 09:58:19'),('328a40cd-a2c5-4814-9da2-fe1f65149c69','b025f7e649e14d85948ffdb8dffe9697','req-14d22f7c-e411-48ff-b736-3f9ed7360ce5','SHARE','16195306-905a-4cc7-a084-f5b07c1d2280','001','008','ERROR','2026-02-20 10:00:54.094535',NULL,NULL,'False','2026-03-22 10:00:54'),('45a29f98-7e97-4dbe-b915-931de393c113','4559942bc629438d88ae332098961d3f','req-e7f849d3-ad4a-47df-967a-c942d8112d6e','SHARE','0f4e7712-189a-4d01-baec-4a1abac60d2b','001','008','ERROR','2026-02-20 09:58:40.734135',NULL,'2026-02-20 09:58:46.825203','45a29f98-7e97-4dbe-b915-931de393c113','2026-03-22 09:58:40'),('561b64cc-72b2-4b75-8723-7b896ea5c5c8','4559942bc629438d88ae332098961d3f','req-3925fcfc-bcaf-4b25-b9ae-a35361fb3654','SHARE','4c79764a-825d-4d57-84f7-079283e0e27d','001','008','ERROR','2026-02-20 09:58:26.427795',NULL,NULL,'False','2026-03-22 09:58:26'),('72353cfb-2f13-4a11-a494-97fdd26717b9','b025f7e649e14d85948ffdb8dffe9697','req-6aa0188b-4f1e-4d36-ab9c-1b3e96fd306e','SHARE','cc999099-b218-4b5a-ba2a-44c990f54e87','001','008','ERROR','2026-02-20 10:00:58.161639',NULL,NULL,'False','2026-03-22 10:00:58'),('864ad127-c45b-4e5c-a697-09516ee0f4de','4559942bc629438d88ae332098961d3f','req-5c0ebee9-efcb-4e5a-8ea4-d66fa0aa5829','SHARE','1a4116f1-1993-4e06-a9f9-b032e808aaed','001','008','ERROR','2026-02-20 09:58:16.287366',NULL,NULL,'False','2026-03-22 09:58:16'),('c4887c93-fc3c-4086-8712-2270d5f40b38','4559942bc629438d88ae332098961d3f','req-8e64b973-2f1b-4053-b4a1-97dc84b9124f','SHARE','b5d4329d-3da0-4fc3-8682-fbcd35cbd2d0','001','008','ERROR','2026-02-20 09:58:36.840965',NULL,NULL,'False','2026-03-22 09:58:36'),('c907478a-fa50-40aa-9784-3b5fc9e53f5e','4559942bc629438d88ae332098961d3f','req-4c0e8a90-37cf-49cb-b85f-24f2bb08e19c','SHARE','b692441a-d2c2-4501-a538-092f584f1024','001','008','ERROR','2026-02-20 09:58:33.545254',NULL,NULL,'False','2026-03-22 09:58:33'),('d41c6f77-5ef5-44bb-925b-30e542850365','8fac2513a3ab4162a13f560c6301f671','req-7f06b5ed-0923-4c51-bcab-874ba0471b50','SHARE','8626b91f-2f8c-45ed-a977-c55d1e1fcddf','010','020','ERROR','2026-02-20 10:00:09.136634',NULL,NULL,'False','2026-03-22 10:00:09'),('d6a84eb3-f99b-4833-a1f3-13bd734058ae','b025f7e649e14d85948ffdb8dffe9697','req-f8326b94-12c5-4c73-bfa6-ed0118e2d3c9','SHARE','69a98f3e-1102-4491-ab0c-3ddcabc50d0b','001','008','ERROR','2026-02-20 10:00:50.471369',NULL,NULL,'False','2026-03-22 10:00:50'),('e185dd2e-0b9a-458f-aa3c-3653b6511dec','4559942bc629438d88ae332098961d3f','req-a5689c50-1e10-4389-9da2-6d6944e66609','SHARE','f1825e84-8b33-4e74-836d-0b8373bd3c28','001','008','ERROR','2026-02-20 09:58:23.219357',NULL,NULL,'False','2026-03-22 09:58:23'),('e73f8b02-e718-486e-b124-81b5ff6247e5','4559942bc629438d88ae332098961d3f','req-d290e889-2cd2-4ddb-9a58-e91e510aa02c','SHARE','a747d24c-9851-48bf-8fe1-e5a6cea6f49b','001','008','ERROR','2026-02-20 09:58:03.286042',NULL,'2026-02-20 09:58:09.379926','e73f8b02-e718-486e-b124-81b5ff6247e5','2026-03-22 09:58:03'),('fa2a2a55-99d3-46e5-9bfe-c2b797fd7131','4559942bc629438d88ae332098961d3f','req-8c7a2b1b-6014-4b6e-bf1f-e6e88acb6524','SHARE','e8dd0ae4-66ba-445b-8511-dba2e65373f7','001','008','ERROR','2026-02-20 09:58:09.733542',NULL,NULL,'False','2026-03-22 09:58:09'),('fa921214-ba4c-47c8-848f-1b8a025bc3aa','b025f7e649e14d85948ffdb8dffe9697','req-781befff-c77b-49df-bb2c-35f7867d219a','SHARE','257d1173-9214-4d88-9929-1a813b5ba1ee','001','008','ERROR','2026-02-20 10:00:46.767375',NULL,NULL,'False','2026-03-22 10:00:46');
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `network_allocations`
--

DROP TABLE IF EXISTS `network_allocations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `network_allocations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ip_address` varchar(64) DEFAULT NULL,
  `mac_address` varchar(32) DEFAULT NULL,
  `share_server_id` varchar(36) NOT NULL,
  `label` varchar(255) DEFAULT 'user',
  `network_type` varchar(32) DEFAULT NULL,
  `segmentation_id` int(11) DEFAULT NULL,
  `ip_version` int(11) DEFAULT NULL,
  `cidr` varchar(64) DEFAULT NULL,
  `gateway` varchar(64) DEFAULT NULL,
  `mtu` int(11) DEFAULT NULL,
  `share_network_subnet_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_server_id` (`share_server_id`),
  KEY `fk_network_allocation_subnet_id_share_network_subnets` (`share_network_subnet_id`),
  CONSTRAINT `fk_network_allocation_subnet_id_share_network_subnets` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`),
  CONSTRAINT `network_allocations_ibfk_1` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `network_allocations`
--

LOCK TABLES `network_allocations` WRITE;
/*!40000 ALTER TABLE `network_allocations` DISABLE KEYS */;
/*!40000 ALTER TABLE `network_allocations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_share_type_quotas`
--

DROP TABLE IF EXISTS `project_share_type_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_share_type_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uc_quotas_per_share_types` (`share_type_id`,`resource`,`deleted`,`project_id`),
  CONSTRAINT `share_type_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_share_type_quotas`
--

LOCK TABLES `project_share_type_quotas` WRITE;
/*!40000 ALTER TABLE `project_share_type_quotas` DISABLE KEYS */;
INSERT INTO `project_share_type_quotas` (`id`, `project_id`, `resource`, `hard_limit`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `share_type_id`) VALUES (1,'13d7347e58a645999865c0f5a5839f4f','shares',2,'2026-02-20 10:00:01.108027',NULL,'2026-02-20 10:00:21.311740',1,'6dfdce8c-75c9-4cee-815a-e43c0b596d98'),(2,'13d7347e58a645999865c0f5a5839f4f','gigabytes',4,'2026-02-20 10:00:01.111955',NULL,'2026-02-20 10:00:21.311740',2,'6dfdce8c-75c9-4cee-815a-e43c0b596d98'),(3,'13d7347e58a645999865c0f5a5839f4f','shares',2,'2026-02-20 10:00:01.210941',NULL,'2026-02-20 10:00:21.252193',3,'4586d343-e913-4ae2-9240-d15623f44eec'),(4,'13d7347e58a645999865c0f5a5839f4f','gigabytes',4,'2026-02-20 10:00:01.216139',NULL,'2026-02-20 10:00:21.252193',4,'4586d343-e913-4ae2-9240-d15623f44eec'),(5,'13d7347e58a645999865c0f5a5839f4f','shares',53,'2026-02-20 10:00:15.192448',NULL,'2026-02-20 10:00:15.244201',5,'2391a6c8-3a63-450d-9e97-68e981553c3f'),(6,'13d7347e58a645999865c0f5a5839f4f','snapshots',53,'2026-02-20 10:00:15.197749',NULL,'2026-02-20 10:00:15.244201',6,'2391a6c8-3a63-450d-9e97-68e981553c3f'),(7,'13d7347e58a645999865c0f5a5839f4f','gigabytes',1003,'2026-02-20 10:00:15.201977',NULL,'2026-02-20 10:00:15.244201',7,'2391a6c8-3a63-450d-9e97-68e981553c3f'),(8,'13d7347e58a645999865c0f5a5839f4f','snapshot_gigabytes',1003,'2026-02-20 10:00:15.207678',NULL,'2026-02-20 10:00:15.244201',8,'2391a6c8-3a63-450d-9e97-68e981553c3f'),(9,'13d7347e58a645999865c0f5a5839f4f','share_replicas',103,'2026-02-20 10:00:15.213568',NULL,'2026-02-20 10:00:15.244201',9,'2391a6c8-3a63-450d-9e97-68e981553c3f'),(10,'13d7347e58a645999865c0f5a5839f4f','replica_gigabytes',1003,'2026-02-20 10:00:15.217779',NULL,'2026-02-20 10:00:15.244201',10,'2391a6c8-3a63-450d-9e97-68e981553c3f'),(11,'13d7347e58a645999865c0f5a5839f4f','shares',53,'2026-02-20 10:00:15.502512',NULL,'2026-02-20 10:00:15.548848',11,'1eb8ef97-0644-4fa7-a6b2-62b4cb58049c'),(12,'13d7347e58a645999865c0f5a5839f4f','snapshots',53,'2026-02-20 10:00:15.506414',NULL,'2026-02-20 10:00:15.548848',12,'1eb8ef97-0644-4fa7-a6b2-62b4cb58049c'),(13,'13d7347e58a645999865c0f5a5839f4f','gigabytes',1003,'2026-02-20 10:00:15.515650',NULL,'2026-02-20 10:00:15.548848',13,'1eb8ef97-0644-4fa7-a6b2-62b4cb58049c'),(14,'13d7347e58a645999865c0f5a5839f4f','snapshot_gigabytes',1003,'2026-02-20 10:00:15.519929',NULL,'2026-02-20 10:00:15.548848',14,'1eb8ef97-0644-4fa7-a6b2-62b4cb58049c'),(15,'13d7347e58a645999865c0f5a5839f4f','share_replicas',103,'2026-02-20 10:00:15.523149',NULL,'2026-02-20 10:00:15.548848',15,'1eb8ef97-0644-4fa7-a6b2-62b4cb58049c'),(16,'13d7347e58a645999865c0f5a5839f4f','replica_gigabytes',1003,'2026-02-20 10:00:15.526223',NULL,'2026-02-20 10:00:15.548848',16,'1eb8ef97-0644-4fa7-a6b2-62b4cb58049c'),(17,'13d7347e58a645999865c0f5a5839f4f','shares',12,'2026-02-20 10:00:16.007978',NULL,'2026-02-20 10:00:21.092080',17,'c1e4dc38-8772-4178-969d-5017e1f4b2a7'),(18,'13d7347e58a645999865c0f5a5839f4f','shares',49,'2026-02-20 10:00:18.129810',NULL,'2026-02-20 10:00:21.042184',18,'17279ffb-ed2b-4cf5-9393-ed0316b5dbe9'),(19,'13d7347e58a645999865c0f5a5839f4f','gigabytes',999,'2026-02-20 10:00:18.220334',NULL,'2026-02-20 10:00:21.042184',19,'17279ffb-ed2b-4cf5-9393-ed0316b5dbe9'),(20,'13d7347e58a645999865c0f5a5839f4f','snapshots',49,'2026-02-20 10:00:18.301788',NULL,'2026-02-20 10:00:21.042184',20,'17279ffb-ed2b-4cf5-9393-ed0316b5dbe9'),(21,'13d7347e58a645999865c0f5a5839f4f','snapshot_gigabytes',999,'2026-02-20 10:00:18.364005',NULL,'2026-02-20 10:00:21.042184',21,'17279ffb-ed2b-4cf5-9393-ed0316b5dbe9'),(22,'13d7347e58a645999865c0f5a5839f4f','share_replicas',99,'2026-02-20 10:00:18.425257',NULL,'2026-02-20 10:00:21.042184',22,'17279ffb-ed2b-4cf5-9393-ed0316b5dbe9'),(23,'13d7347e58a645999865c0f5a5839f4f','replica_gigabytes',999,'2026-02-20 10:00:18.508564',NULL,'2026-02-20 10:00:21.042184',23,'17279ffb-ed2b-4cf5-9393-ed0316b5dbe9'),(24,'13d7347e58a645999865c0f5a5839f4f','shares',49,'2026-02-20 10:00:18.668127',NULL,'2026-02-20 10:00:20.994683',24,'e3b1eabc-9915-4389-b8d4-3c0e58653d27'),(25,'13d7347e58a645999865c0f5a5839f4f','gigabytes',999,'2026-02-20 10:00:18.724324',NULL,'2026-02-20 10:00:20.994683',25,'e3b1eabc-9915-4389-b8d4-3c0e58653d27'),(26,'13d7347e58a645999865c0f5a5839f4f','snapshots',49,'2026-02-20 10:00:18.791655',NULL,'2026-02-20 10:00:20.994683',26,'e3b1eabc-9915-4389-b8d4-3c0e58653d27'),(27,'13d7347e58a645999865c0f5a5839f4f','snapshot_gigabytes',999,'2026-02-20 10:00:18.843796',NULL,'2026-02-20 10:00:20.994683',27,'e3b1eabc-9915-4389-b8d4-3c0e58653d27'),(28,'13d7347e58a645999865c0f5a5839f4f','share_replicas',99,'2026-02-20 10:00:18.895927',NULL,'2026-02-20 10:00:20.994683',28,'e3b1eabc-9915-4389-b8d4-3c0e58653d27'),(29,'13d7347e58a645999865c0f5a5839f4f','replica_gigabytes',999,'2026-02-20 10:00:18.951457',NULL,'2026-02-20 10:00:20.994683',29,'e3b1eabc-9915-4389-b8d4-3c0e58653d27'),(30,'13d7347e58a645999865c0f5a5839f4f','shares',11,'2026-02-20 10:00:19.119919',NULL,'2026-02-20 10:00:20.930295',30,'72640cfc-4d15-4cbc-85f1-072ed0012f45'),(31,'13d7347e58a645999865c0f5a5839f4f','shares',-1,'2026-02-20 10:00:19.275118',NULL,'2026-02-20 10:00:20.872552',31,'214fcab2-4306-4e03-826a-88340852d97d');
/*!40000 ALTER TABLE `project_share_type_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_user_quotas`
--

DROP TABLE IF EXISTS `project_user_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_user_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `resource` varchar(25) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_user_quotas`
--

LOCK TABLES `project_user_quotas` WRITE;
/*!40000 ALTER TABLE `project_user_quotas` DISABLE KEYS */;
INSERT INTO `project_user_quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `user_id`, `project_id`, `resource`, `hard_limit`) VALUES (1,'2026-02-20 10:00:01.020420',NULL,'2026-02-20 10:00:14.946050',1,'c1cf03483c7d40b1a7b5cb96f508a5e3','13d7347e58a645999865c0f5a5839f4f','shares',2),(2,'2026-02-20 10:00:01.026258',NULL,'2026-02-20 10:00:14.946050',2,'c1cf03483c7d40b1a7b5cb96f508a5e3','13d7347e58a645999865c0f5a5839f4f','gigabytes',7),(3,'2026-02-20 10:00:15.908422',NULL,'2026-02-20 10:00:16.049488',3,'c1cf03483c7d40b1a7b5cb96f508a5e3','13d7347e58a645999865c0f5a5839f4f','shares',11),(4,'2026-02-20 10:00:17.180970',NULL,'2026-02-20 10:00:17.229601',4,'c1cf03483c7d40b1a7b5cb96f508a5e3','13d7347e58a645999865c0f5a5839f4f','gigabytes',-1),(5,'2026-02-20 10:00:17.296250',NULL,'2026-02-20 10:00:17.343359',5,'c1cf03483c7d40b1a7b5cb96f508a5e3','13d7347e58a645999865c0f5a5839f4f','share_replicas',-1),(6,'2026-02-20 10:00:17.447664',NULL,'2026-02-20 10:00:17.500177',6,'c1cf03483c7d40b1a7b5cb96f508a5e3','13d7347e58a645999865c0f5a5839f4f','replica_gigabytes',-1),(7,'2026-02-20 10:00:17.554753',NULL,'2026-02-20 10:00:17.596586',7,'c1cf03483c7d40b1a7b5cb96f508a5e3','13d7347e58a645999865c0f5a5839f4f','share_networks',-1),(8,'2026-02-20 10:00:17.636646',NULL,'2026-02-20 10:00:17.718168',8,'c1cf03483c7d40b1a7b5cb96f508a5e3','13d7347e58a645999865c0f5a5839f4f','shares',-1),(9,'2026-02-20 10:00:17.782411',NULL,'2026-02-20 10:00:17.835229',9,'c1cf03483c7d40b1a7b5cb96f508a5e3','13d7347e58a645999865c0f5a5839f4f','snapshot_gigabytes',-1),(10,'2026-02-20 10:00:17.926387',NULL,'2026-02-20 10:00:17.988884',10,'c1cf03483c7d40b1a7b5cb96f508a5e3','13d7347e58a645999865c0f5a5839f4f','snapshots',-1),(11,'2026-02-20 10:00:19.801265',NULL,'2026-02-20 10:00:19.817696',11,'c1cf03483c7d40b1a7b5cb96f508a5e3','13d7347e58a645999865c0f5a5839f4f','gigabytes',999),(12,'2026-02-20 10:00:19.938739',NULL,'2026-02-20 10:00:19.958059',12,'c1cf03483c7d40b1a7b5cb96f508a5e3','13d7347e58a645999865c0f5a5839f4f','share_replicas',99),(13,'2026-02-20 10:00:20.097067',NULL,'2026-02-20 10:00:20.113877',13,'c1cf03483c7d40b1a7b5cb96f508a5e3','13d7347e58a645999865c0f5a5839f4f','replica_gigabytes',999),(14,'2026-02-20 10:00:20.186194',NULL,'2026-02-20 10:00:20.207108',14,'c1cf03483c7d40b1a7b5cb96f508a5e3','13d7347e58a645999865c0f5a5839f4f','share_networks',9),(15,'2026-02-20 10:00:20.271273',NULL,'2026-02-20 10:00:20.290832',15,'c1cf03483c7d40b1a7b5cb96f508a5e3','13d7347e58a645999865c0f5a5839f4f','shares',49),(16,'2026-02-20 10:00:20.369827',NULL,'2026-02-20 10:00:20.391855',16,'c1cf03483c7d40b1a7b5cb96f508a5e3','13d7347e58a645999865c0f5a5839f4f','snapshot_gigabytes',999),(17,'2026-02-20 10:00:20.466511',NULL,'2026-02-20 10:00:20.486120',17,'c1cf03483c7d40b1a7b5cb96f508a5e3','13d7347e58a645999865c0f5a5839f4f','snapshots',49),(18,'2026-02-20 10:00:20.615110',NULL,'2026-02-20 10:00:20.649756',18,'c1cf03483c7d40b1a7b5cb96f508a5e3','13d7347e58a645999865c0f5a5839f4f','shares',11),(19,'2026-02-20 10:00:20.799554',NULL,'2026-02-20 10:00:20.821798',19,'c1cf03483c7d40b1a7b5cb96f508a5e3','13d7347e58a645999865c0f5a5839f4f','shares',-1);
/*!40000 ALTER TABLE `project_user_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_usages_project_id` (`project_id`)
) ENGINE=InnoDB AUTO_INCREMENT=270 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `share_type_id`) VALUES ('2026-02-20 09:54:53.016157','2026-02-20 09:54:56.528786',NULL,0,1,'030f7bfb48d5404cb5c2f144493c13ba','1316406c3478480189948d89dc4f438c','shares',0,0,NULL,NULL),('2026-02-20 09:54:53.019890','2026-02-20 09:54:56.528789',NULL,0,2,'030f7bfb48d5404cb5c2f144493c13ba','1316406c3478480189948d89dc4f438c','gigabytes',0,0,NULL,NULL),('2026-02-20 09:54:53.037896','2026-02-20 09:54:56.528790','2026-02-20 09:54:59.263206',3,3,NULL,'1316406c3478480189948d89dc4f438c','shares',0,0,NULL,'33328c95-5381-4fc8-b42b-daec4d660044'),('2026-02-20 09:54:53.041479','2026-02-20 09:54:56.528792','2026-02-20 09:54:59.263206',4,4,NULL,'1316406c3478480189948d89dc4f438c','gigabytes',0,0,NULL,'33328c95-5381-4fc8-b42b-daec4d660044'),('2026-02-20 09:55:25.987401','2026-02-20 09:55:43.328131',NULL,0,5,'37f65b711ccf433f86420da7d18f479c','0635b5dae1854e178484d0abec19ab72','gigabytes',0,0,NULL,NULL),('2026-02-20 09:55:25.991554','2026-02-20 09:55:43.328134',NULL,0,6,'37f65b711ccf433f86420da7d18f479c','0635b5dae1854e178484d0abec19ab72','shares',0,0,NULL,NULL),('2026-02-20 09:55:26.007610','2026-02-20 09:55:43.328135','2026-02-20 09:55:46.185664',7,7,NULL,'0635b5dae1854e178484d0abec19ab72','gigabytes',0,0,NULL,'e77c21ce-a6ed-4799-a84b-87df7ec5cd53'),('2026-02-20 09:55:26.010629','2026-02-20 09:55:43.328136','2026-02-20 09:55:46.185664',8,8,NULL,'0635b5dae1854e178484d0abec19ab72','shares',0,0,NULL,'e77c21ce-a6ed-4799-a84b-87df7ec5cd53'),('2026-02-20 09:55:29.300844','2026-02-20 09:55:40.069407',NULL,0,9,'37f65b711ccf433f86420da7d18f479c','0635b5dae1854e178484d0abec19ab72','snapshot_gigabytes',0,0,NULL,NULL),('2026-02-20 09:55:29.304384','2026-02-20 09:55:40.069410',NULL,0,10,'37f65b711ccf433f86420da7d18f479c','0635b5dae1854e178484d0abec19ab72','snapshots',0,0,NULL,NULL),('2026-02-20 09:55:29.327185','2026-02-20 09:55:40.069412','2026-02-20 09:55:46.185664',11,11,NULL,'0635b5dae1854e178484d0abec19ab72','snapshot_gigabytes',0,0,NULL,'e77c21ce-a6ed-4799-a84b-87df7ec5cd53'),('2026-02-20 09:55:29.329915','2026-02-20 09:55:40.069413','2026-02-20 09:55:46.185664',12,12,NULL,'0635b5dae1854e178484d0abec19ab72','snapshots',0,0,NULL,'e77c21ce-a6ed-4799-a84b-87df7ec5cd53'),('2026-02-20 09:55:51.395140','2026-02-20 09:56:53.187238',NULL,0,13,'fb1fbd877a8346d5b367f7463ffb510c','d0927694241842759be660760b008959','gigabytes',0,0,NULL,NULL),('2026-02-20 09:55:51.396983','2026-02-20 09:56:53.187241',NULL,0,14,'fb1fbd877a8346d5b367f7463ffb510c','d0927694241842759be660760b008959','shares',0,0,NULL,NULL),('2026-02-20 09:55:51.405650','2026-02-20 09:56:53.187243','2026-02-20 09:56:55.995777',15,15,NULL,'d0927694241842759be660760b008959','gigabytes',0,0,NULL,'07221afd-ccd1-4ae1-a11b-cd0c08f035ea'),('2026-02-20 09:55:51.408032','2026-02-20 09:56:53.187245','2026-02-20 09:56:55.995777',16,16,NULL,'d0927694241842759be660760b008959','shares',0,0,NULL,'07221afd-ccd1-4ae1-a11b-cd0c08f035ea'),('2026-02-20 09:55:54.844288','2026-02-20 09:56:50.014736',NULL,0,17,'fb1fbd877a8346d5b367f7463ffb510c','d0927694241842759be660760b008959','snapshot_gigabytes',0,0,NULL,NULL),('2026-02-20 09:55:54.848032','2026-02-20 09:56:50.014740',NULL,0,18,'fb1fbd877a8346d5b367f7463ffb510c','d0927694241842759be660760b008959','snapshots',0,0,NULL,NULL),('2026-02-20 09:55:54.872424','2026-02-20 09:56:50.014742','2026-02-20 09:56:55.995777',19,19,NULL,'d0927694241842759be660760b008959','snapshot_gigabytes',0,0,NULL,'07221afd-ccd1-4ae1-a11b-cd0c08f035ea'),('2026-02-20 09:55:54.875792','2026-02-20 09:56:50.014744','2026-02-20 09:56:55.995777',20,20,NULL,'d0927694241842759be660760b008959','snapshots',0,0,NULL,'07221afd-ccd1-4ae1-a11b-cd0c08f035ea'),('2026-02-20 09:55:56.626303','2026-02-20 09:57:16.178474',NULL,0,21,'8c63ad2215564b2ba1a91046040dcfc1','d345acb999b945ac8ca92ec3a0b92da6','gigabytes',0,0,NULL,NULL),('2026-02-20 09:55:56.629458','2026-02-20 09:57:16.178477',NULL,0,22,'8c63ad2215564b2ba1a91046040dcfc1','d345acb999b945ac8ca92ec3a0b92da6','shares',0,0,NULL,NULL),('2026-02-20 09:55:56.647445','2026-02-20 09:57:16.178478','2026-02-20 09:57:19.020182',23,23,NULL,'d345acb999b945ac8ca92ec3a0b92da6','gigabytes',0,0,NULL,'0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:55:56.652033','2026-02-20 09:57:16.178479','2026-02-20 09:57:19.020182',24,24,NULL,'d345acb999b945ac8ca92ec3a0b92da6','shares',0,0,NULL,'0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:32.714025','2026-02-20 09:57:12.949565',NULL,0,25,'8c63ad2215564b2ba1a91046040dcfc1','d345acb999b945ac8ca92ec3a0b92da6','snapshot_gigabytes',0,0,NULL,NULL),('2026-02-20 09:56:32.720094','2026-02-20 09:57:12.949568',NULL,0,26,'8c63ad2215564b2ba1a91046040dcfc1','d345acb999b945ac8ca92ec3a0b92da6','snapshots',0,0,NULL,NULL),('2026-02-20 09:56:32.731162','2026-02-20 09:57:12.949570','2026-02-20 09:57:19.020182',27,27,NULL,'d345acb999b945ac8ca92ec3a0b92da6','snapshot_gigabytes',0,0,NULL,'0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:32.734553','2026-02-20 09:57:12.949571','2026-02-20 09:57:19.020182',28,28,NULL,'d345acb999b945ac8ca92ec3a0b92da6','snapshots',0,0,NULL,'0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:57:05.816858','2026-02-20 09:57:16.522858',NULL,0,29,'8b934adab96c450395aa1542e65e5970','4c23134629034c99a32e1e53486719c7','shares',0,0,NULL,NULL),('2026-02-20 09:57:05.819435','2026-02-20 09:57:16.522861',NULL,0,30,'8b934adab96c450395aa1542e65e5970','4c23134629034c99a32e1e53486719c7','gigabytes',0,0,NULL,NULL),('2026-02-20 09:57:05.827776','2026-02-20 09:57:16.522862','2026-02-20 09:57:19.362447',31,31,NULL,'4c23134629034c99a32e1e53486719c7','shares',0,0,NULL,'ca78ee45-db85-4fcb-9d36-41f7381cabf1'),('2026-02-20 09:57:05.830480','2026-02-20 09:57:16.522864','2026-02-20 09:57:19.362447',32,32,NULL,'4c23134629034c99a32e1e53486719c7','gigabytes',0,0,NULL,'ca78ee45-db85-4fcb-9d36-41f7381cabf1'),('2026-02-20 09:57:07.267697','2026-02-20 09:57:29.438422',NULL,0,33,'006a0e8f7e054ecc87e89aeaefd897ea','1401fb23701440858ed7175cc4dba63b','gigabytes',0,0,NULL,NULL),('2026-02-20 09:57:07.269818','2026-02-20 09:57:29.438425',NULL,0,34,'006a0e8f7e054ecc87e89aeaefd897ea','1401fb23701440858ed7175cc4dba63b','shares',0,0,NULL,NULL),('2026-02-20 09:57:07.278471','2026-02-20 09:57:29.438426','2026-02-20 09:57:31.513451',35,35,NULL,'1401fb23701440858ed7175cc4dba63b','gigabytes',0,0,NULL,'2c21b407-dddf-4b58-9b9f-aa5427d91232'),('2026-02-20 09:57:07.280201','2026-02-20 09:57:29.438428','2026-02-20 09:57:31.513451',36,36,NULL,'1401fb23701440858ed7175cc4dba63b','shares',0,0,NULL,'2c21b407-dddf-4b58-9b9f-aa5427d91232'),('2026-02-20 09:57:09.119224','2026-02-20 09:57:13.261530',NULL,0,37,'8b934adab96c450395aa1542e65e5970','4c23134629034c99a32e1e53486719c7','snapshots',0,0,NULL,NULL),('2026-02-20 09:57:09.124205','2026-02-20 09:57:13.261534',NULL,0,38,'8b934adab96c450395aa1542e65e5970','4c23134629034c99a32e1e53486719c7','snapshot_gigabytes',0,0,NULL,NULL),('2026-02-20 09:57:09.135234','2026-02-20 09:57:13.261536','2026-02-20 09:57:19.362447',39,39,NULL,'4c23134629034c99a32e1e53486719c7','snapshots',0,0,NULL,'ca78ee45-db85-4fcb-9d36-41f7381cabf1'),('2026-02-20 09:57:09.139328','2026-02-20 09:57:13.261538','2026-02-20 09:57:19.362447',40,40,NULL,'4c23134629034c99a32e1e53486719c7','snapshot_gigabytes',0,0,NULL,'ca78ee45-db85-4fcb-9d36-41f7381cabf1'),('2026-02-20 09:57:30.707451','2026-02-20 09:57:33.010763',NULL,0,41,'68596db4321d412fa84a0b3a4888496c','208565eda0ab416e8a4d0cab3045c853','share_networks',0,0,NULL,NULL),('2026-02-20 09:57:31.146537','2026-02-20 09:57:31.206002',NULL,0,42,'8b5bbabe99d84f568cfed466d4ea2347','a7fd4740c8af42eda6e38d9605c14b06','share_networks',1,0,NULL,NULL),('2026-02-20 09:57:49.103486','2026-02-20 09:57:51.659960',NULL,0,43,'46d2da43b69c4228bbe4bc911be273b9','703953f368c84a05a279629aa7704503','share_networks',0,0,NULL,NULL),('2026-02-20 09:57:50.873824','2026-02-20 09:58:32.869123',NULL,0,44,'bf98d88b1c84473e962748cb9ed9824a','3c38c47b6b7b4f078e218bbefefce029','shares',0,0,NULL,NULL),('2026-02-20 09:57:50.877880','2026-02-20 09:58:32.869125',NULL,0,45,'bf98d88b1c84473e962748cb9ed9824a','3c38c47b6b7b4f078e218bbefefce029','gigabytes',0,0,NULL,NULL),('2026-02-20 09:57:50.887498','2026-02-20 09:58:32.869126','2026-02-20 09:58:35.531287',46,46,NULL,'3c38c47b6b7b4f078e218bbefefce029','shares',0,0,NULL,'83d90b28-64dc-44f1-836d-a413c5e7256b'),('2026-02-20 09:57:50.891667','2026-02-20 09:58:32.869128','2026-02-20 09:58:35.531287',47,47,NULL,'3c38c47b6b7b4f078e218bbefefce029','gigabytes',0,0,NULL,'83d90b28-64dc-44f1-836d-a413c5e7256b'),('2026-02-20 09:57:55.169421','2026-02-20 09:58:01.989337',NULL,0,48,'b19c6d4492a04b7d98d2825a8842e8ff','2ac6bdba4377453b82e5badf03029d7c','shares',0,0,NULL,NULL),('2026-02-20 09:57:55.171802','2026-02-20 09:58:01.989339',NULL,0,49,'b19c6d4492a04b7d98d2825a8842e8ff','2ac6bdba4377453b82e5badf03029d7c','gigabytes',0,0,NULL,NULL),('2026-02-20 09:57:55.190030','2026-02-20 09:58:01.989341','2026-02-20 09:58:04.912694',50,50,NULL,'2ac6bdba4377453b82e5badf03029d7c','shares',0,0,NULL,'99bf4958-7405-48ee-882f-6e517440dc3e'),('2026-02-20 09:57:55.192109','2026-02-20 09:58:01.989342','2026-02-20 09:58:04.912694',51,51,NULL,'2ac6bdba4377453b82e5badf03029d7c','gigabytes',0,0,NULL,'99bf4958-7405-48ee-882f-6e517440dc3e'),('2026-02-20 09:58:03.135275','2026-02-20 09:58:46.985295',NULL,0,52,'8c8cc44c38ca4b3ca339318554bae0a0','4559942bc629438d88ae332098961d3f','shares',0,0,NULL,NULL),('2026-02-20 09:58:03.137663','2026-02-20 09:58:46.985298',NULL,0,53,'8c8cc44c38ca4b3ca339318554bae0a0','4559942bc629438d88ae332098961d3f','gigabytes',0,0,NULL,NULL),('2026-02-20 09:58:03.148252','2026-02-20 09:58:09.568943','2026-02-20 09:58:47.598413',54,54,NULL,'4559942bc629438d88ae332098961d3f','shares',0,0,NULL,'caf81e2c-fad7-42a6-ab00-06993d5936d5'),('2026-02-20 09:58:03.150502','2026-02-20 09:58:09.568945','2026-02-20 09:58:47.598413',55,55,NULL,'4559942bc629438d88ae332098961d3f','gigabytes',0,0,NULL,'caf81e2c-fad7-42a6-ab00-06993d5936d5'),('2026-02-20 09:58:09.638853','2026-02-20 09:58:16.037566','2026-02-20 09:58:47.534738',56,56,NULL,'4559942bc629438d88ae332098961d3f','shares',0,0,NULL,'84db82ef-0262-4237-957b-0b0637bd9b8b'),('2026-02-20 09:58:09.642619','2026-02-20 09:58:16.037567','2026-02-20 09:58:47.534738',57,57,NULL,'4559942bc629438d88ae332098961d3f','gigabytes',0,0,NULL,'84db82ef-0262-4237-957b-0b0637bd9b8b'),('2026-02-20 09:58:16.147984','2026-02-20 09:58:22.983984','2026-02-20 09:58:47.473592',58,58,NULL,'4559942bc629438d88ae332098961d3f','shares',0,0,NULL,'7358cf7e-cc45-46b4-848f-f11edcebbc2a'),('2026-02-20 09:58:16.150495','2026-02-20 09:58:22.983985','2026-02-20 09:58:47.473592',59,59,NULL,'4559942bc629438d88ae332098961d3f','gigabytes',0,0,NULL,'7358cf7e-cc45-46b4-848f-f11edcebbc2a'),('2026-02-20 09:58:19.010092','2026-02-20 10:01:26.094351',NULL,0,60,'c744dea67e504ed8bbe87eb5b0c1fc1e','8e04bc360fa14db4a793bc5de7a0a299','gigabytes',0,0,NULL,NULL),('2026-02-20 09:58:19.012192','2026-02-20 10:01:26.094353',NULL,0,61,'c744dea67e504ed8bbe87eb5b0c1fc1e','8e04bc360fa14db4a793bc5de7a0a299','shares',0,0,NULL,NULL),('2026-02-20 09:58:19.025942','2026-02-20 10:01:26.094354','2026-02-20 10:01:28.975233',62,62,NULL,'8e04bc360fa14db4a793bc5de7a0a299','gigabytes',0,0,NULL,'48a549b7-2e24-48b0-bf7b-3dffd39b684c'),('2026-02-20 09:58:19.028252','2026-02-20 10:01:26.094356','2026-02-20 10:01:28.975233',63,63,NULL,'8e04bc360fa14db4a793bc5de7a0a299','shares',0,0,NULL,'48a549b7-2e24-48b0-bf7b-3dffd39b684c'),('2026-02-20 09:58:19.428117','2026-02-20 09:58:22.756573','2026-02-20 09:58:47.400947',64,64,NULL,'4559942bc629438d88ae332098961d3f','gigabytes',0,0,NULL,'45611395-059b-4ba1-84b0-96eaa8d790dd'),('2026-02-20 09:58:19.430255','2026-02-20 09:58:22.756575','2026-02-20 09:58:47.400947',65,65,NULL,'4559942bc629438d88ae332098961d3f','shares',0,0,NULL,'45611395-059b-4ba1-84b0-96eaa8d790dd'),('2026-02-20 09:58:23.102685','2026-02-20 09:58:33.298135','2026-02-20 09:58:47.313281',66,66,NULL,'4559942bc629438d88ae332098961d3f','shares',0,0,NULL,'03ec41f3-6744-4b9a-8b31-a753f421c19c'),('2026-02-20 09:58:23.105757','2026-02-20 09:58:33.298137','2026-02-20 09:58:47.313281',67,67,NULL,'4559942bc629438d88ae332098961d3f','gigabytes',0,0,NULL,'03ec41f3-6744-4b9a-8b31-a753f421c19c'),('2026-02-20 09:58:26.347277','2026-02-20 09:58:33.097314','2026-02-20 09:58:47.255676',68,68,NULL,'4559942bc629438d88ae332098961d3f','shares',0,0,NULL,'6cceb050-de15-4855-b44a-39794dc87a14'),('2026-02-20 09:58:26.349179','2026-02-20 09:58:33.097315','2026-02-20 09:58:47.255676',69,69,NULL,'4559942bc629438d88ae332098961d3f','gigabytes',0,0,NULL,'6cceb050-de15-4855-b44a-39794dc87a14'),('2026-02-20 09:58:29.577064','2026-02-20 09:58:32.961287','2026-02-20 09:58:47.199492',70,70,NULL,'4559942bc629438d88ae332098961d3f','shares',0,0,NULL,'6fd361a9-526c-4faa-b39f-8a101200778d'),('2026-02-20 09:58:29.579503','2026-02-20 09:58:32.961288','2026-02-20 09:58:47.199492',71,71,NULL,'4559942bc629438d88ae332098961d3f','gigabytes',0,0,NULL,'6fd361a9-526c-4faa-b39f-8a101200778d'),('2026-02-20 09:58:33.397056','2026-02-20 09:58:40.524172','2026-02-20 09:58:47.151454',72,72,NULL,'4559942bc629438d88ae332098961d3f','shares',0,0,NULL,'bc03df9c-9dee-4f87-8f49-45b33581c9b4'),('2026-02-20 09:58:33.400091','2026-02-20 09:58:40.524174','2026-02-20 09:58:47.151454',73,73,NULL,'4559942bc629438d88ae332098961d3f','gigabytes',0,0,NULL,'bc03df9c-9dee-4f87-8f49-45b33581c9b4'),('2026-02-20 09:58:36.709601','2026-02-20 09:58:40.243141','2026-02-20 09:58:47.084044',74,74,NULL,'4559942bc629438d88ae332098961d3f','gigabytes',0,0,NULL,'6f3aaea1-fcb8-4aef-849e-fe826efad48b'),('2026-02-20 09:58:36.713904','2026-02-20 09:58:40.243143','2026-02-20 09:58:47.084044',75,75,NULL,'4559942bc629438d88ae332098961d3f','shares',0,0,NULL,'6f3aaea1-fcb8-4aef-849e-fe826efad48b'),('2026-02-20 09:58:40.625270','2026-02-20 09:58:46.985299','2026-02-20 09:58:47.032542',76,76,NULL,'4559942bc629438d88ae332098961d3f','gigabytes',0,0,NULL,'d4430d83-c86e-48fb-9233-05b8eeb071b8'),('2026-02-20 09:58:40.627144','2026-02-20 09:58:46.985300','2026-02-20 09:58:47.032542',77,77,NULL,'4559942bc629438d88ae332098961d3f','shares',0,0,NULL,'d4430d83-c86e-48fb-9233-05b8eeb071b8'),('2026-02-20 09:58:52.249128','2026-02-20 09:59:03.651739',NULL,0,78,'2a38b24f215a478db5cd7da521f1b21b','b466c6b08b5e44ff9593bfa11ccdf0a9','shares',0,0,NULL,NULL),('2026-02-20 09:58:52.300296','2026-02-20 09:59:03.651742',NULL,0,79,'2a38b24f215a478db5cd7da521f1b21b','b466c6b08b5e44ff9593bfa11ccdf0a9','gigabytes',0,0,NULL,NULL),('2026-02-20 09:58:52.336218','2026-02-20 09:59:03.651744','2026-02-20 09:59:15.948218',80,80,NULL,'b466c6b08b5e44ff9593bfa11ccdf0a9','shares',0,0,NULL,'d75db691-7965-4145-9170-9a4265a3b1f3'),('2026-02-20 09:58:52.338885','2026-02-20 09:59:03.651746','2026-02-20 09:59:15.948218',81,81,NULL,'b466c6b08b5e44ff9593bfa11ccdf0a9','gigabytes',0,0,NULL,'d75db691-7965-4145-9170-9a4265a3b1f3'),('2026-02-20 09:58:56.002954','2026-02-20 09:59:12.867030',NULL,0,82,'658ecc001e85402995533129aa177bc3','4f1b3c403fb148c692c17867833e30a7','shares',0,0,NULL,NULL),('2026-02-20 09:58:56.007934','2026-02-20 09:59:12.867034',NULL,0,83,'658ecc001e85402995533129aa177bc3','4f1b3c403fb148c692c17867833e30a7','gigabytes',0,0,NULL,NULL),('2026-02-20 09:58:56.024762','2026-02-20 09:59:12.867036','2026-02-20 09:59:15.948218',84,84,NULL,'4f1b3c403fb148c692c17867833e30a7','shares',0,0,NULL,'d75db691-7965-4145-9170-9a4265a3b1f3'),('2026-02-20 09:58:56.026761','2026-02-20 09:59:12.867038','2026-02-20 09:59:15.948218',85,85,NULL,'4f1b3c403fb148c692c17867833e30a7','gigabytes',0,0,NULL,'d75db691-7965-4145-9170-9a4265a3b1f3'),('2026-02-20 09:58:58.434844','2026-02-20 09:58:59.092775',NULL,0,86,'fc2654163ae44cab8ac83cec6540300f','830e413b9fb04e02af1efdd014797bc3','share_networks',0,0,NULL,NULL),('2026-02-20 09:59:07.919182','2026-02-20 09:59:32.519882',NULL,0,87,'8643c8395fbe4ccfb167772f294c4f4e','0d864a52bf534b55a21f76b3d9a1e409','gigabytes',0,0,NULL,NULL),('2026-02-20 09:59:07.921483','2026-02-20 09:59:32.519885',NULL,0,88,'8643c8395fbe4ccfb167772f294c4f4e','0d864a52bf534b55a21f76b3d9a1e409','shares',0,0,NULL,NULL),('2026-02-20 09:59:07.932416','2026-02-20 09:59:32.519887','2026-02-20 09:59:35.256127',89,89,NULL,'0d864a52bf534b55a21f76b3d9a1e409','gigabytes',0,0,NULL,'90af42c1-8a5c-4d70-bd40-5357c3133130'),('2026-02-20 09:59:07.934126','2026-02-20 09:59:32.519889','2026-02-20 09:59:35.256127',90,90,NULL,'0d864a52bf534b55a21f76b3d9a1e409','shares',0,0,NULL,'90af42c1-8a5c-4d70-bd40-5357c3133130'),('2026-02-20 09:59:24.015681','2026-02-20 09:59:28.754694',NULL,0,91,'58824ecf7ec24f3f8eca46626cadee71','cec3ac3e38f4401bb4bfc7f380ef6f55','gigabytes',0,0,NULL,NULL),('2026-02-20 09:59:24.019734','2026-02-20 09:59:28.754697',NULL,0,92,'58824ecf7ec24f3f8eca46626cadee71','cec3ac3e38f4401bb4bfc7f380ef6f55','shares',0,0,NULL,NULL),('2026-02-20 09:59:24.031317','2026-02-20 09:59:28.754698','2026-02-20 09:59:31.475676',93,93,NULL,'cec3ac3e38f4401bb4bfc7f380ef6f55','gigabytes',0,0,NULL,'f97a926c-227e-41fa-9f49-8c026cbaad0b'),('2026-02-20 09:59:24.033994','2026-02-20 09:59:28.754699','2026-02-20 09:59:31.475676',94,94,NULL,'cec3ac3e38f4401bb4bfc7f380ef6f55','shares',0,0,NULL,'f97a926c-227e-41fa-9f49-8c026cbaad0b'),('2026-02-20 09:59:38.964933','2026-02-20 10:00:39.736298',NULL,0,95,'e2403c6acd6d4934a0d7baec8e166e83','8fac2513a3ab4162a13f560c6301f671','shares',0,0,NULL,NULL),('2026-02-20 09:59:38.970430','2026-02-20 10:00:39.736301',NULL,0,96,'e2403c6acd6d4934a0d7baec8e166e83','8fac2513a3ab4162a13f560c6301f671','gigabytes',0,0,NULL,NULL),('2026-02-20 09:59:38.981043','2026-02-20 10:00:39.736302','2026-02-20 10:00:41.685775',97,97,NULL,'8fac2513a3ab4162a13f560c6301f671','shares',0,0,NULL,'bb3fe1e2-ba2f-415c-a2f0-e5751f7811cb'),('2026-02-20 09:59:38.983949','2026-02-20 10:00:39.736303','2026-02-20 10:00:41.685775',98,98,NULL,'8fac2513a3ab4162a13f560c6301f671','gigabytes',0,0,NULL,'bb3fe1e2-ba2f-415c-a2f0-e5751f7811cb'),('2026-02-20 09:59:42.287446','2026-02-20 10:00:35.678878',NULL,0,99,NULL,'8fac2513a3ab4162a13f560c6301f671','shares',0,0,NULL,'eb9df654-33ce-4f45-a990-326f72bd8165'),('2026-02-20 09:59:42.291109','2026-02-20 10:00:35.678879',NULL,0,100,NULL,'8fac2513a3ab4162a13f560c6301f671','gigabytes',0,0,NULL,'eb9df654-33ce-4f45-a990-326f72bd8165'),('2026-02-20 09:59:48.974535','2026-02-20 10:00:32.619388',NULL,0,101,'21cbeb9a927145a3bbcad8958770ed83','f656f9df86ae4c53b02f471da5bd5ad7','gigabytes',0,0,NULL,NULL),('2026-02-20 09:59:48.976558','2026-02-20 10:00:32.619391',NULL,0,102,'21cbeb9a927145a3bbcad8958770ed83','f656f9df86ae4c53b02f471da5bd5ad7','shares',0,0,NULL,NULL),('2026-02-20 09:59:48.985474','2026-02-20 10:00:32.619393',NULL,0,103,NULL,'f656f9df86ae4c53b02f471da5bd5ad7','gigabytes',0,0,NULL,'eb9df654-33ce-4f45-a990-326f72bd8165'),('2026-02-20 09:59:48.987483','2026-02-20 10:00:32.619394',NULL,0,104,NULL,'f656f9df86ae4c53b02f471da5bd5ad7','shares',0,0,NULL,'eb9df654-33ce-4f45-a990-326f72bd8165'),('2026-02-20 09:59:52.150286','2026-02-20 09:59:52.194560','2026-02-20 09:59:55.535986',105,105,'651bfdd554864016b919f2b5c8112b5f','3dca3c8f00214a66a9293134148fac17','shares',1,0,NULL,NULL),('2026-02-20 09:59:52.153816','2026-02-20 09:59:52.194562','2026-02-20 09:59:55.535986',106,106,'651bfdd554864016b919f2b5c8112b5f','3dca3c8f00214a66a9293134148fac17','gigabytes',1,0,NULL,NULL),('2026-02-20 09:59:52.162401','2026-02-20 09:59:52.194564','2026-02-20 09:59:55.535986',107,107,NULL,'3dca3c8f00214a66a9293134148fac17','shares',1,0,NULL,'b7211100-1e6b-44a1-ab50-e2eb1739e315'),('2026-02-20 09:59:52.164061','2026-02-20 09:59:52.194565','2026-02-20 09:59:55.535986',108,108,NULL,'3dca3c8f00214a66a9293134148fac17','gigabytes',1,0,NULL,'b7211100-1e6b-44a1-ab50-e2eb1739e315'),('2026-02-20 09:59:55.628203','2026-02-20 09:59:55.802381','2026-02-20 10:00:02.523355',109,109,'651bfdd554864016b919f2b5c8112b5f','3dca3c8f00214a66a9293134148fac17','shares',2,0,NULL,NULL),('2026-02-20 09:59:55.631504','2026-02-20 09:59:55.802384','2026-02-20 10:00:02.523355',110,110,'651bfdd554864016b919f2b5c8112b5f','3dca3c8f00214a66a9293134148fac17','gigabytes',2,0,NULL,NULL),('2026-02-20 09:59:55.747601','2026-02-20 09:59:55.802385','2026-02-20 10:00:02.523355',111,111,NULL,'3dca3c8f00214a66a9293134148fac17','gigabytes',1,0,NULL,'5fe79e8d-459d-4121-8de9-2bdfeb00eefa'),('2026-02-20 09:59:55.751013','2026-02-20 09:59:55.802386','2026-02-20 10:00:02.523355',112,112,NULL,'3dca3c8f00214a66a9293134148fac17','shares',1,0,NULL,'5fe79e8d-459d-4121-8de9-2bdfeb00eefa'),('2026-02-20 09:59:59.221910','2026-02-20 09:59:59.336044','2026-02-20 10:00:02.523355',113,113,'651bfdd554864016b919f2b5c8112b5f','3dca3c8f00214a66a9293134148fac17','snapshots',1,0,NULL,NULL),('2026-02-20 09:59:59.225507','2026-02-20 09:59:59.336048','2026-02-20 10:00:02.523355',114,114,'651bfdd554864016b919f2b5c8112b5f','3dca3c8f00214a66a9293134148fac17','snapshot_gigabytes',1,0,NULL,NULL),('2026-02-20 09:59:59.245004','2026-02-20 09:59:59.336050','2026-02-20 10:00:02.523355',115,115,NULL,'3dca3c8f00214a66a9293134148fac17','snapshots',1,0,NULL,'5fe79e8d-459d-4121-8de9-2bdfeb00eefa'),('2026-02-20 09:59:59.249288','2026-02-20 09:59:59.336052','2026-02-20 10:00:02.523355',116,116,NULL,'3dca3c8f00214a66a9293134148fac17','snapshot_gigabytes',1,0,NULL,'5fe79e8d-459d-4121-8de9-2bdfeb00eefa'),('2026-02-20 10:00:01.313421','2026-02-20 10:00:13.043098','2026-02-20 10:00:14.948420',117,117,'c1cf03483c7d40b1a7b5cb96f508a5e3','13d7347e58a645999865c0f5a5839f4f','shares',0,0,NULL,NULL),('2026-02-20 10:00:01.315820','2026-02-20 10:00:13.043101','2026-02-20 10:00:14.948420',118,118,'c1cf03483c7d40b1a7b5cb96f508a5e3','13d7347e58a645999865c0f5a5839f4f','gigabytes',0,0,NULL,NULL),('2026-02-20 10:00:01.331220','2026-02-20 10:00:08.804784','2026-02-20 10:00:14.968209',119,119,NULL,'13d7347e58a645999865c0f5a5839f4f','shares',0,0,NULL,'6dfdce8c-75c9-4cee-815a-e43c0b596d98'),('2026-02-20 10:00:01.333451','2026-02-20 10:00:08.804786','2026-02-20 10:00:14.968209',120,120,NULL,'13d7347e58a645999865c0f5a5839f4f','gigabytes',0,0,NULL,'6dfdce8c-75c9-4cee-815a-e43c0b596d98'),('2026-02-20 10:00:04.958284','2026-02-20 10:00:13.043102','2026-02-20 10:00:14.968209',121,121,NULL,'13d7347e58a645999865c0f5a5839f4f','shares',0,0,NULL,'4586d343-e913-4ae2-9240-d15623f44eec'),('2026-02-20 10:00:04.960719','2026-02-20 10:00:13.043104','2026-02-20 10:00:14.968209',122,122,NULL,'13d7347e58a645999865c0f5a5839f4f','gigabytes',0,0,NULL,'4586d343-e913-4ae2-9240-d15623f44eec'),('2026-02-20 10:00:06.320994','2026-02-20 10:00:06.351691',NULL,0,123,'651bfdd554864016b919f2b5c8112b5f','3dca3c8f00214a66a9293134148fac17','snapshot_gigabytes',-1,0,NULL,NULL),('2026-02-20 10:00:06.324635','2026-02-20 10:00:06.351694',NULL,0,124,'651bfdd554864016b919f2b5c8112b5f','3dca3c8f00214a66a9293134148fac17','snapshots',-1,0,NULL,NULL),('2026-02-20 10:00:06.335694','2026-02-20 10:00:06.351696','2026-02-20 10:00:12.059226',125,125,NULL,'3dca3c8f00214a66a9293134148fac17','snapshot_gigabytes',-1,0,NULL,'5fe79e8d-459d-4121-8de9-2bdfeb00eefa'),('2026-02-20 10:00:06.339162','2026-02-20 10:00:06.351697','2026-02-20 10:00:12.059226',126,126,NULL,'3dca3c8f00214a66a9293134148fac17','snapshots',-1,0,NULL,'5fe79e8d-459d-4121-8de9-2bdfeb00eefa'),('2026-02-20 10:00:09.435063','2026-02-20 10:00:14.133591',NULL,0,127,'651bfdd554864016b919f2b5c8112b5f','3dca3c8f00214a66a9293134148fac17','gigabytes',0,0,NULL,NULL),('2026-02-20 10:00:09.441103','2026-02-20 10:00:14.133594',NULL,0,128,'651bfdd554864016b919f2b5c8112b5f','3dca3c8f00214a66a9293134148fac17','shares',0,0,NULL,NULL),('2026-02-20 10:00:09.450142','2026-02-20 10:00:09.462051','2026-02-20 10:00:12.059226',129,129,NULL,'3dca3c8f00214a66a9293134148fac17','gigabytes',0,0,NULL,'5fe79e8d-459d-4121-8de9-2bdfeb00eefa'),('2026-02-20 10:00:09.453372','2026-02-20 10:00:09.462053','2026-02-20 10:00:12.059226',130,130,NULL,'3dca3c8f00214a66a9293134148fac17','shares',0,0,NULL,'5fe79e8d-459d-4121-8de9-2bdfeb00eefa'),('2026-02-20 10:00:14.099592','2026-02-20 10:00:14.133595','2026-02-20 10:00:15.393895',131,131,NULL,'3dca3c8f00214a66a9293134148fac17','gigabytes',0,0,NULL,'b7211100-1e6b-44a1-ab50-e2eb1739e315'),('2026-02-20 10:00:14.106432','2026-02-20 10:00:14.133596','2026-02-20 10:00:15.393895',132,132,NULL,'3dca3c8f00214a66a9293134148fac17','shares',0,0,NULL,'b7211100-1e6b-44a1-ab50-e2eb1739e315'),('2026-02-20 10:00:15.214431','2026-02-20 10:00:29.241241','2026-02-20 10:00:41.685775',133,133,NULL,'f656f9df86ae4c53b02f471da5bd5ad7','shares',0,0,NULL,'bb3fe1e2-ba2f-415c-a2f0-e5751f7811cb'),('2026-02-20 10:00:15.217634','2026-02-20 10:00:29.241242','2026-02-20 10:00:41.685775',134,134,NULL,'f656f9df86ae4c53b02f471da5bd5ad7','gigabytes',0,0,NULL,'bb3fe1e2-ba2f-415c-a2f0-e5751f7811cb'),('2026-02-20 10:00:18.649893','2026-02-20 10:00:23.119083',NULL,0,135,'157fe81ea811422c9d325b8c2657d3a9','fc77d937e5f64d008d60c0ad9d54a545','shares',0,0,NULL,NULL),('2026-02-20 10:00:18.651754','2026-02-20 10:00:23.119086',NULL,0,136,'157fe81ea811422c9d325b8c2657d3a9','fc77d937e5f64d008d60c0ad9d54a545','gigabytes',0,0,NULL,NULL),('2026-02-20 10:00:18.658921','2026-02-20 10:00:23.119087','2026-02-20 10:00:25.942864',137,137,NULL,'fc77d937e5f64d008d60c0ad9d54a545','shares',0,0,NULL,'3334a4fc-2669-4424-82cf-eb94eac49695'),('2026-02-20 10:00:18.660640','2026-02-20 10:00:23.119089','2026-02-20 10:00:25.942864',138,138,NULL,'fc77d937e5f64d008d60c0ad9d54a545','gigabytes',0,0,NULL,'3334a4fc-2669-4424-82cf-eb94eac49695'),('2026-02-20 10:00:29.599843','2026-02-20 10:00:34.127506',NULL,0,139,'3811bcf9aa084a2485b8e167851d7a4a','c46bf1229a0b4128b6de1b5e8bac25aa','shares',0,0,NULL,NULL),('2026-02-20 10:00:29.601846','2026-02-20 10:00:34.127510',NULL,0,140,'3811bcf9aa084a2485b8e167851d7a4a','c46bf1229a0b4128b6de1b5e8bac25aa','gigabytes',0,0,NULL,NULL),('2026-02-20 10:00:29.613083','2026-02-20 10:00:34.127512','2026-02-20 10:00:36.221683',141,141,NULL,'c46bf1229a0b4128b6de1b5e8bac25aa','shares',0,0,NULL,'dee7b2d5-ce73-43ef-a94e-a69d40df2957'),('2026-02-20 10:00:29.614862','2026-02-20 10:00:34.127514','2026-02-20 10:00:36.221683',142,142,NULL,'c46bf1229a0b4128b6de1b5e8bac25aa','gigabytes',0,0,NULL,'dee7b2d5-ce73-43ef-a94e-a69d40df2957'),('2026-02-20 10:00:43.140029','2026-02-20 10:00:44.468308',NULL,0,143,'7e30214830a74d3fb604356b76df7f6d','39c25a9c9a99474ca081350edaed5ee1','share_networks',0,0,NULL,NULL),('2026-02-20 10:00:46.625793','2026-02-20 10:01:10.950837',NULL,0,144,'48484ad27c834387b5cd08bd9fa83ba2','b025f7e649e14d85948ffdb8dffe9697','shares',0,0,NULL,NULL),('2026-02-20 10:00:46.628867','2026-02-20 10:01:10.950840',NULL,0,145,'48484ad27c834387b5cd08bd9fa83ba2','b025f7e649e14d85948ffdb8dffe9697','gigabytes',0,0,NULL,NULL),('2026-02-20 10:00:46.640329','2026-02-20 10:00:50.210713','2026-02-20 10:01:11.478318',146,146,NULL,'b025f7e649e14d85948ffdb8dffe9697','shares',0,0,NULL,'80d2aac3-de3a-4505-846d-041b2decb558'),('2026-02-20 10:00:46.642965','2026-02-20 10:00:50.210714','2026-02-20 10:01:11.478318',147,147,NULL,'b025f7e649e14d85948ffdb8dffe9697','gigabytes',0,0,NULL,'80d2aac3-de3a-4505-846d-041b2decb558'),('2026-02-20 10:00:47.993444','2026-02-20 10:00:53.601132',NULL,0,148,'db5b4f7a88fb448daf836f6600f2fbe4','9ce5a52649bb4df9a705817aa7ecddca','shares',0,0,NULL,NULL),('2026-02-20 10:00:47.997347','2026-02-20 10:00:53.601135',NULL,0,149,'db5b4f7a88fb448daf836f6600f2fbe4','9ce5a52649bb4df9a705817aa7ecddca','gigabytes',0,0,NULL,NULL),('2026-02-20 10:00:48.015083','2026-02-20 10:00:53.601137','2026-02-20 10:00:56.655921',150,150,NULL,'9ce5a52649bb4df9a705817aa7ecddca','shares',0,0,NULL,'1053daf4-893c-4900-81d9-0b8d9f20986d'),('2026-02-20 10:00:48.017494','2026-02-20 10:00:53.601138','2026-02-20 10:00:56.655921',151,151,NULL,'9ce5a52649bb4df9a705817aa7ecddca','gigabytes',0,0,NULL,'1053daf4-893c-4900-81d9-0b8d9f20986d'),('2026-02-20 10:00:50.276552','2026-02-20 10:00:51.818296',NULL,0,152,'cde95e9d1bec4875b75ef1941e7ac86f','af9d55219a474f6a9c5ab0f5d5b13023','share_networks',0,0,NULL,NULL),('2026-02-20 10:00:50.321756','2026-02-20 10:00:53.869195','2026-02-20 10:01:11.390501',153,153,NULL,'b025f7e649e14d85948ffdb8dffe9697','shares',0,0,NULL,'1bbbaac3-edbf-47c0-829e-e170ed076081'),('2026-02-20 10:00:50.323821','2026-02-20 10:00:53.869196','2026-02-20 10:01:11.390501',154,154,NULL,'b025f7e649e14d85948ffdb8dffe9697','gigabytes',0,0,NULL,'1bbbaac3-edbf-47c0-829e-e170ed076081'),('2026-02-20 10:00:53.971538','2026-02-20 10:00:57.669034','2026-02-20 10:01:11.337243',155,155,NULL,'b025f7e649e14d85948ffdb8dffe9697','shares',0,0,NULL,'e29102ba-e6d4-44ff-9288-84a47b6b5157'),('2026-02-20 10:00:53.974341','2026-02-20 10:00:57.669036','2026-02-20 10:01:11.337243',156,156,NULL,'b025f7e649e14d85948ffdb8dffe9697','gigabytes',0,0,NULL,'e29102ba-e6d4-44ff-9288-84a47b6b5157'),('2026-02-20 10:00:58.004575','2026-02-20 10:01:04.441535','2026-02-20 10:01:11.275535',157,157,NULL,'b025f7e649e14d85948ffdb8dffe9697','gigabytes',0,0,NULL,'702ce432-33c7-4e10-a03f-0854457649ac'),('2026-02-20 10:00:58.007920','2026-02-20 10:01:04.441537','2026-02-20 10:01:11.275535',158,158,NULL,'b025f7e649e14d85948ffdb8dffe9697','shares',0,0,NULL,'702ce432-33c7-4e10-a03f-0854457649ac'),('2026-02-20 10:00:59.796247','2026-02-20 10:02:15.703154',NULL,0,159,'82f001ca71d44f64a2f5d622ba81e489','766977986b8d4935995086e1b7f48c1d','shares',0,0,NULL,NULL),('2026-02-20 10:00:59.797937','2026-02-20 10:02:15.703156',NULL,0,160,'82f001ca71d44f64a2f5d622ba81e489','766977986b8d4935995086e1b7f48c1d','gigabytes',0,0,NULL,NULL),('2026-02-20 10:00:59.805877','2026-02-20 10:02:15.703158','2026-02-20 10:02:18.495655',161,161,NULL,'766977986b8d4935995086e1b7f48c1d','shares',0,0,NULL,'7e9bd417-8002-4d0b-99cc-e6bed442b5be'),('2026-02-20 10:00:59.810007','2026-02-20 10:02:15.703159','2026-02-20 10:02:18.495655',162,162,NULL,'766977986b8d4935995086e1b7f48c1d','gigabytes',0,0,NULL,'7e9bd417-8002-4d0b-99cc-e6bed442b5be'),('2026-02-20 10:01:03.043612','2026-02-20 10:02:12.529956',NULL,0,163,'82f001ca71d44f64a2f5d622ba81e489','766977986b8d4935995086e1b7f48c1d','snapshot_gigabytes',0,0,NULL,NULL),('2026-02-20 10:01:03.045763','2026-02-20 10:02:12.529959',NULL,0,164,'82f001ca71d44f64a2f5d622ba81e489','766977986b8d4935995086e1b7f48c1d','snapshots',0,0,NULL,NULL),('2026-02-20 10:01:03.054289','2026-02-20 10:02:12.529961','2026-02-20 10:02:18.495655',165,165,NULL,'766977986b8d4935995086e1b7f48c1d','snapshot_gigabytes',0,0,NULL,'7e9bd417-8002-4d0b-99cc-e6bed442b5be'),('2026-02-20 10:01:03.056372','2026-02-20 10:02:12.529962','2026-02-20 10:02:18.495655',166,166,NULL,'766977986b8d4935995086e1b7f48c1d','snapshots',0,0,NULL,'7e9bd417-8002-4d0b-99cc-e6bed442b5be'),('2026-02-20 10:01:04.544576','2026-02-20 10:01:10.950841','2026-02-20 10:01:11.213097',167,167,NULL,'b025f7e649e14d85948ffdb8dffe9697','shares',0,0,NULL,'34001302-113e-451c-849b-0ac909a65c2d'),('2026-02-20 10:01:04.546640','2026-02-20 10:01:10.950843','2026-02-20 10:01:11.213097',168,168,NULL,'b025f7e649e14d85948ffdb8dffe9697','gigabytes',0,0,NULL,'34001302-113e-451c-849b-0ac909a65c2d'),('2026-02-20 10:01:08.992233','2026-02-20 10:01:22.881645',NULL,0,169,'5eff6a7d4a954420a1461705b5b4d25e','8e04bc360fa14db4a793bc5de7a0a299','gigabytes',0,0,NULL,NULL),('2026-02-20 10:01:08.994597','2026-02-20 10:01:22.881646',NULL,0,170,'5eff6a7d4a954420a1461705b5b4d25e','8e04bc360fa14db4a793bc5de7a0a299','shares',0,0,NULL,NULL),('2026-02-20 10:01:14.693677','2026-02-20 10:01:14.750228',NULL,0,171,'2e3a1a07e08b45baa885977013071b9f','e8035fa10e5f4d1aae154d58e76a9729','share_networks',1,0,NULL,NULL),('2026-02-20 10:01:21.187833','2026-02-20 10:02:49.844628',NULL,0,172,'566b3c30231242a295579c321ac55f13','72f6de9a4d894029be8ca744061d09cb','gigabytes',0,0,NULL,NULL),('2026-02-20 10:01:21.190600','2026-02-20 10:02:49.844631',NULL,0,173,'566b3c30231242a295579c321ac55f13','72f6de9a4d894029be8ca744061d09cb','shares',0,0,NULL,NULL),('2026-02-20 10:01:21.206868','2026-02-20 10:01:31.441667','2026-02-20 10:01:34.201027',174,174,NULL,'72f6de9a4d894029be8ca744061d09cb','gigabytes',0,0,NULL,'3ed40b83-b9f0-43a5-b9a1-5fc31174a2a4'),('2026-02-20 10:01:21.209383','2026-02-20 10:01:31.441668','2026-02-20 10:01:34.201027',175,175,NULL,'72f6de9a4d894029be8ca744061d09cb','shares',0,0,NULL,'3ed40b83-b9f0-43a5-b9a1-5fc31174a2a4'),('2026-02-20 10:01:24.497266','2026-02-20 10:02:47.033462',NULL,0,176,'566b3c30231242a295579c321ac55f13','72f6de9a4d894029be8ca744061d09cb','snapshot_gigabytes',0,0,NULL,NULL),('2026-02-20 10:01:24.499388','2026-02-20 10:02:47.033466',NULL,0,177,'566b3c30231242a295579c321ac55f13','72f6de9a4d894029be8ca744061d09cb','snapshots',0,0,NULL,NULL),('2026-02-20 10:01:24.509321','2026-02-20 10:01:28.193530','2026-02-20 10:01:34.201027',178,178,NULL,'72f6de9a4d894029be8ca744061d09cb','snapshot_gigabytes',0,0,NULL,'3ed40b83-b9f0-43a5-b9a1-5fc31174a2a4'),('2026-02-20 10:01:24.511603','2026-02-20 10:01:28.193532','2026-02-20 10:01:34.201027',179,179,NULL,'72f6de9a4d894029be8ca744061d09cb','snapshots',0,0,NULL,'3ed40b83-b9f0-43a5-b9a1-5fc31174a2a4'),('2026-02-20 10:01:28.084723','2026-02-20 10:02:35.522195',NULL,0,180,'e4c734194bfd45018fd58baabce64bf6','ad1dd0d43ec7421b9a4a06c39e3657c6','shares',0,0,NULL,NULL),('2026-02-20 10:01:28.087303','2026-02-20 10:02:35.522200',NULL,0,181,'e4c734194bfd45018fd58baabce64bf6','ad1dd0d43ec7421b9a4a06c39e3657c6','gigabytes',0,0,NULL,NULL),('2026-02-20 10:01:28.095489','2026-02-20 10:02:35.522202','2026-02-20 10:02:38.305300',182,182,NULL,'ad1dd0d43ec7421b9a4a06c39e3657c6','shares',0,0,NULL,'3e721ad7-11c2-42cf-956f-5aeeed7d1d0a'),('2026-02-20 10:01:28.097442','2026-02-20 10:02:35.522204','2026-02-20 10:02:38.305300',183,183,NULL,'ad1dd0d43ec7421b9a4a06c39e3657c6','gigabytes',0,0,NULL,'3e721ad7-11c2-42cf-956f-5aeeed7d1d0a'),('2026-02-20 10:01:29.844279','2026-02-20 10:01:40.274632',NULL,0,184,'596b7db794ec4a1ba2829af4b784b600','8379be9e0a0543189f94c822f9c76f3f','shares',0,0,NULL,NULL),('2026-02-20 10:01:29.847991','2026-02-20 10:01:40.274636',NULL,0,185,'596b7db794ec4a1ba2829af4b784b600','8379be9e0a0543189f94c822f9c76f3f','gigabytes',0,0,NULL,NULL),('2026-02-20 10:01:29.857339','2026-02-20 10:01:40.274638','2026-02-20 10:01:43.128563',186,186,NULL,'8379be9e0a0543189f94c822f9c76f3f','shares',0,0,NULL,'dc030d02-f047-43f1-b057-eeeb15059384'),('2026-02-20 10:01:29.859599','2026-02-20 10:01:40.274640','2026-02-20 10:01:43.128563',187,187,NULL,'8379be9e0a0543189f94c822f9c76f3f','gigabytes',0,0,NULL,'dc030d02-f047-43f1-b057-eeeb15059384'),('2026-02-20 10:01:33.061683','2026-02-20 10:01:37.404396',NULL,0,188,'596b7db794ec4a1ba2829af4b784b600','8379be9e0a0543189f94c822f9c76f3f','snapshots',0,0,NULL,NULL),('2026-02-20 10:01:33.063883','2026-02-20 10:01:37.404402',NULL,0,189,'596b7db794ec4a1ba2829af4b784b600','8379be9e0a0543189f94c822f9c76f3f','snapshot_gigabytes',0,0,NULL,NULL),('2026-02-20 10:01:33.075387','2026-02-20 10:01:37.404405','2026-02-20 10:01:43.128563',190,190,NULL,'8379be9e0a0543189f94c822f9c76f3f','snapshots',0,0,NULL,'dc030d02-f047-43f1-b057-eeeb15059384'),('2026-02-20 10:01:33.077477','2026-02-20 10:01:37.404408','2026-02-20 10:01:43.128563',191,191,NULL,'8379be9e0a0543189f94c822f9c76f3f','snapshot_gigabytes',0,0,NULL,'dc030d02-f047-43f1-b057-eeeb15059384'),('2026-02-20 10:01:34.295300','2026-02-20 10:01:37.986273','2026-02-20 10:02:53.772724',192,192,NULL,'72f6de9a4d894029be8ca744061d09cb','shares',0,0,NULL,'15f2a171-553f-4457-9f33-a8801a176b4d'),('2026-02-20 10:01:34.297373','2026-02-20 10:01:37.986274','2026-02-20 10:02:53.772724',193,193,NULL,'72f6de9a4d894029be8ca744061d09cb','gigabytes',0,0,NULL,'15f2a171-553f-4457-9f33-a8801a176b4d'),('2026-02-20 10:01:35.351363','2026-02-20 10:01:46.413959',NULL,0,194,'6e0a1e0ae3534b38bf1af0ecef725e03','fa5f5f12701349488e6f9e875b4ddfa7','gigabytes',1,0,NULL,NULL),('2026-02-20 10:01:35.353529','2026-02-20 10:01:46.413963',NULL,0,195,'6e0a1e0ae3534b38bf1af0ecef725e03','fa5f5f12701349488e6f9e875b4ddfa7','shares',1,0,NULL,NULL),('2026-02-20 10:01:35.368903','2026-02-20 10:01:46.413965','2026-02-20 10:01:49.666133',196,196,NULL,'fa5f5f12701349488e6f9e875b4ddfa7','gigabytes',1,0,NULL,'01aa61b1-cd56-4424-9115-78005fa90d7f'),('2026-02-20 10:01:35.370749','2026-02-20 10:01:46.413967','2026-02-20 10:01:49.666133',197,197,NULL,'fa5f5f12701349488e6f9e875b4ddfa7','shares',1,0,NULL,'01aa61b1-cd56-4424-9115-78005fa90d7f'),('2026-02-20 10:01:36.735093','2026-02-20 10:01:40.852470',NULL,0,198,'345374ef0e4d4f488e63abd7bfa28b3f','a986e1cee42e4d20a367d286ff5b4908','shares',0,0,NULL,NULL),('2026-02-20 10:01:36.738891','2026-02-20 10:01:40.852472',NULL,0,199,'345374ef0e4d4f488e63abd7bfa28b3f','a986e1cee42e4d20a367d286ff5b4908','gigabytes',0,0,NULL,NULL),('2026-02-20 10:01:36.749508','2026-02-20 10:01:40.852474','2026-02-20 10:01:43.775756',200,200,NULL,'a986e1cee42e4d20a367d286ff5b4908','shares',0,0,NULL,'5a602670-2636-4d3f-a77e-f4467759e162'),('2026-02-20 10:01:36.752963','2026-02-20 10:01:40.852475','2026-02-20 10:01:43.775756',201,201,NULL,'a986e1cee42e4d20a367d286ff5b4908','gigabytes',0,0,NULL,'5a602670-2636-4d3f-a77e-f4467759e162'),('2026-02-20 10:01:38.875518','2026-02-20 10:01:39.812389',NULL,0,202,'f513bc846858471ca213b468a9b8b076','cff212d1a4ec47a198eaffb5418f0f33','shares',0,0,NULL,NULL),('2026-02-20 10:01:38.878283','2026-02-20 10:01:39.812391',NULL,0,203,'f513bc846858471ca213b468a9b8b076','cff212d1a4ec47a198eaffb5418f0f33','gigabytes',0,0,NULL,NULL),('2026-02-20 10:01:38.909743','2026-02-20 10:01:39.142252',NULL,0,204,'f513bc846858471ca213b468a9b8b076','fa5f5f12701349488e6f9e875b4ddfa7','shares',-1,0,NULL,NULL),('2026-02-20 10:01:38.916232','2026-02-20 10:01:39.142255',NULL,0,205,'f513bc846858471ca213b468a9b8b076','fa5f5f12701349488e6f9e875b4ddfa7','gigabytes',-1,0,NULL,NULL),('2026-02-20 10:01:39.796892','2026-02-20 10:01:39.812392','2026-02-20 10:01:49.666133',206,206,NULL,'cff212d1a4ec47a198eaffb5418f0f33','gigabytes',0,0,NULL,'01aa61b1-cd56-4424-9115-78005fa90d7f'),('2026-02-20 10:01:39.800742','2026-02-20 10:01:39.812394','2026-02-20 10:01:49.666133',207,207,NULL,'cff212d1a4ec47a198eaffb5418f0f33','shares',0,0,NULL,'01aa61b1-cd56-4424-9115-78005fa90d7f'),('2026-02-20 10:01:40.961164','2026-02-20 10:02:49.844632','2026-02-20 10:02:52.712869',208,208,NULL,'72f6de9a4d894029be8ca744061d09cb','shares',0,0,NULL,'da4e3d60-1f55-4668-9d53-da3dbdf1163e'),('2026-02-20 10:01:40.964776','2026-02-20 10:02:49.844634','2026-02-20 10:02:52.712869',209,209,NULL,'72f6de9a4d894029be8ca744061d09cb','gigabytes',0,0,NULL,'da4e3d60-1f55-4668-9d53-da3dbdf1163e'),('2026-02-20 10:01:44.448937','2026-02-20 10:02:47.033468','2026-02-20 10:02:52.712869',210,210,NULL,'72f6de9a4d894029be8ca744061d09cb','snapshots',0,0,NULL,'da4e3d60-1f55-4668-9d53-da3dbdf1163e'),('2026-02-20 10:01:44.452829','2026-02-20 10:02:47.033470','2026-02-20 10:02:52.712869',211,211,NULL,'72f6de9a4d894029be8ca744061d09cb','snapshot_gigabytes',0,0,NULL,'da4e3d60-1f55-4668-9d53-da3dbdf1163e'),('2026-02-20 10:01:53.982185','2026-02-20 10:01:58.726165',NULL,0,212,'cbafbbc37779492981511920ba270952','e2c7618200d34da3a2f64f252dae7492','gigabytes',0,0,NULL,NULL),('2026-02-20 10:01:53.984226','2026-02-20 10:01:58.726168',NULL,0,213,'cbafbbc37779492981511920ba270952','e2c7618200d34da3a2f64f252dae7492','shares',0,0,NULL,NULL),('2026-02-20 10:01:53.994580','2026-02-20 10:01:58.726169','2026-02-20 10:02:01.024411',214,214,NULL,'e2c7618200d34da3a2f64f252dae7492','gigabytes',0,0,NULL,'ed8cc1c6-c82a-41e8-a8e0-6ce864cd078f'),('2026-02-20 10:01:53.997028','2026-02-20 10:01:58.726170','2026-02-20 10:02:01.024411',215,215,NULL,'e2c7618200d34da3a2f64f252dae7492','shares',0,0,NULL,'ed8cc1c6-c82a-41e8-a8e0-6ce864cd078f'),('2026-02-20 10:01:55.750353','2026-02-20 10:02:31.646366',NULL,0,216,'13067f2b863745eabca3330d64ec4f59','68a6dfaa5a244e82963414de97f45e1c','shares',0,0,NULL,NULL),('2026-02-20 10:01:55.753359','2026-02-20 10:02:31.646369',NULL,0,217,'13067f2b863745eabca3330d64ec4f59','68a6dfaa5a244e82963414de97f45e1c','gigabytes',0,0,NULL,NULL),('2026-02-20 10:01:55.766571','2026-02-20 10:02:31.646370','2026-02-20 10:02:34.843739',218,218,NULL,'68a6dfaa5a244e82963414de97f45e1c','shares',0,0,NULL,'8d207f00-1409-4835-992f-b0eeed7ba2d2'),('2026-02-20 10:01:55.768931','2026-02-20 10:02:31.646371','2026-02-20 10:02:34.843739',219,219,NULL,'68a6dfaa5a244e82963414de97f45e1c','gigabytes',0,0,NULL,'8d207f00-1409-4835-992f-b0eeed7ba2d2'),('2026-02-20 10:02:05.201461','2026-02-20 10:02:15.806679',NULL,0,220,'7569bbcff9fc4b6e92a66559cfc39fad','45448aed55694db39d5cf1e0e0b542b9','gigabytes',0,0,NULL,NULL),('2026-02-20 10:02:05.205966','2026-02-20 10:02:15.806683',NULL,0,221,'7569bbcff9fc4b6e92a66559cfc39fad','45448aed55694db39d5cf1e0e0b542b9','shares',0,0,NULL,NULL),('2026-02-20 10:02:05.216019','2026-02-20 10:02:15.806685','2026-02-20 10:02:18.565448',222,222,NULL,'45448aed55694db39d5cf1e0e0b542b9','gigabytes',0,0,NULL,'5d85b32c-0d58-480a-bc44-c3f950ed3ccc'),('2026-02-20 10:02:05.217894','2026-02-20 10:02:15.806687','2026-02-20 10:02:18.565448',223,223,NULL,'45448aed55694db39d5cf1e0e0b542b9','shares',0,0,NULL,'5d85b32c-0d58-480a-bc44-c3f950ed3ccc'),('2026-02-20 10:02:08.419343','2026-02-20 10:02:12.704944',NULL,0,224,'7569bbcff9fc4b6e92a66559cfc39fad','45448aed55694db39d5cf1e0e0b542b9','snapshot_gigabytes',0,0,NULL,NULL),('2026-02-20 10:02:08.421207','2026-02-20 10:02:12.704947',NULL,0,225,'7569bbcff9fc4b6e92a66559cfc39fad','45448aed55694db39d5cf1e0e0b542b9','snapshots',0,0,NULL,NULL),('2026-02-20 10:02:08.428686','2026-02-20 10:02:12.704948','2026-02-20 10:02:18.565448',226,226,NULL,'45448aed55694db39d5cf1e0e0b542b9','snapshot_gigabytes',0,0,NULL,'5d85b32c-0d58-480a-bc44-c3f950ed3ccc'),('2026-02-20 10:02:08.430323','2026-02-20 10:02:12.704949','2026-02-20 10:02:18.565448',227,227,NULL,'45448aed55694db39d5cf1e0e0b542b9','snapshots',0,0,NULL,'5d85b32c-0d58-480a-bc44-c3f950ed3ccc'),('2026-02-20 10:02:08.674217','2026-02-20 10:02:18.197717',NULL,0,228,'13067f2b863745eabca3330d64ec4f59','68a6dfaa5a244e82963414de97f45e1c','share_groups',0,0,NULL,NULL),('2026-02-20 10:02:26.320286','2026-02-20 10:03:16.834588',NULL,0,229,'cc7cf9b38fae4a579e698f555eceed72','34227290958b43d48566076f17d50a24','shares',0,0,NULL,NULL),('2026-02-20 10:02:26.322545','2026-02-20 10:03:16.834591',NULL,0,230,'cc7cf9b38fae4a579e698f555eceed72','34227290958b43d48566076f17d50a24','gigabytes',0,0,NULL,NULL),('2026-02-20 10:02:26.331548','2026-02-20 10:03:16.834593','2026-02-20 10:03:19.703287',231,231,NULL,'34227290958b43d48566076f17d50a24','shares',0,0,NULL,'41d815bd-80af-4cdd-8d06-c116e272b15a'),('2026-02-20 10:02:26.333540','2026-02-20 10:03:16.834594','2026-02-20 10:03:19.703287',232,232,NULL,'34227290958b43d48566076f17d50a24','gigabytes',0,0,NULL,'41d815bd-80af-4cdd-8d06-c116e272b15a'),('2026-02-20 10:02:29.585780','2026-02-20 10:03:13.558078',NULL,0,233,'cc7cf9b38fae4a579e698f555eceed72','34227290958b43d48566076f17d50a24','snapshot_gigabytes',0,0,NULL,NULL),('2026-02-20 10:02:29.587517','2026-02-20 10:03:13.558082',NULL,0,234,'cc7cf9b38fae4a579e698f555eceed72','34227290958b43d48566076f17d50a24','snapshots',0,0,NULL,NULL),('2026-02-20 10:02:29.595493','2026-02-20 10:03:13.558084','2026-02-20 10:03:19.703287',235,235,NULL,'34227290958b43d48566076f17d50a24','snapshot_gigabytes',0,0,NULL,'41d815bd-80af-4cdd-8d06-c116e272b15a'),('2026-02-20 10:02:29.597767','2026-02-20 10:03:13.558085','2026-02-20 10:03:19.703287',236,236,NULL,'34227290958b43d48566076f17d50a24','snapshots',0,0,NULL,'41d815bd-80af-4cdd-8d06-c116e272b15a'),('2026-02-20 10:02:33.787398','2026-02-20 10:02:57.755431',NULL,0,237,'0d95d80655c34179b2ff0ff5a7d7ae65','32f1d5776c624aa39b7e834a4d5faec5','shares',0,0,NULL,NULL),('2026-02-20 10:02:33.789161','2026-02-20 10:02:57.755435',NULL,0,238,'0d95d80655c34179b2ff0ff5a7d7ae65','32f1d5776c624aa39b7e834a4d5faec5','gigabytes',0,0,NULL,NULL),('2026-02-20 10:02:33.798280','2026-02-20 10:02:57.755436','2026-02-20 10:03:00.575489',239,239,NULL,'32f1d5776c624aa39b7e834a4d5faec5','shares',0,0,NULL,'c70ee780-92ee-4926-8dcd-b51d13f503de'),('2026-02-20 10:02:33.800009','2026-02-20 10:02:57.755438','2026-02-20 10:03:00.575489',240,240,NULL,'32f1d5776c624aa39b7e834a4d5faec5','gigabytes',0,0,NULL,'c70ee780-92ee-4926-8dcd-b51d13f503de'),('2026-02-20 10:02:37.040981','2026-02-20 10:02:56.328313',NULL,0,241,'0d95d80655c34179b2ff0ff5a7d7ae65','32f1d5776c624aa39b7e834a4d5faec5','snapshot_gigabytes',0,0,NULL,NULL),('2026-02-20 10:02:37.043843','2026-02-20 10:02:56.328317',NULL,0,242,'0d95d80655c34179b2ff0ff5a7d7ae65','32f1d5776c624aa39b7e834a4d5faec5','snapshots',0,0,NULL,NULL),('2026-02-20 10:02:37.061814','2026-02-20 10:02:56.328319','2026-02-20 10:03:00.575489',243,243,NULL,'32f1d5776c624aa39b7e834a4d5faec5','snapshot_gigabytes',0,0,NULL,'c70ee780-92ee-4926-8dcd-b51d13f503de'),('2026-02-20 10:02:37.064330','2026-02-20 10:02:56.328321','2026-02-20 10:03:00.575489',244,244,NULL,'32f1d5776c624aa39b7e834a4d5faec5','snapshots',0,0,NULL,'c70ee780-92ee-4926-8dcd-b51d13f503de'),('2026-02-20 10:02:46.093125','2026-02-20 10:02:56.725314',NULL,0,245,'62f732ee77de47129adeeeae62885689','7a4982b18b04484999b26d85ffc0aeb4','shares',0,0,NULL,NULL),('2026-02-20 10:02:46.096174','2026-02-20 10:02:56.725316',NULL,0,246,'62f732ee77de47129adeeeae62885689','7a4982b18b04484999b26d85ffc0aeb4','gigabytes',0,0,NULL,NULL),('2026-02-20 10:02:46.106254','2026-02-20 10:02:56.725318','2026-02-20 10:02:59.462045',247,247,NULL,'7a4982b18b04484999b26d85ffc0aeb4','shares',0,0,NULL,'e6b4ee71-4259-4da0-9292-defe62779ffe'),('2026-02-20 10:02:46.108549','2026-02-20 10:02:56.725319','2026-02-20 10:02:59.462045',248,248,NULL,'7a4982b18b04484999b26d85ffc0aeb4','gigabytes',0,0,NULL,'e6b4ee71-4259-4da0-9292-defe62779ffe'),('2026-02-20 10:02:49.361240','2026-02-20 10:02:53.383985',NULL,0,249,'62f732ee77de47129adeeeae62885689','7a4982b18b04484999b26d85ffc0aeb4','snapshot_gigabytes',0,0,NULL,NULL),('2026-02-20 10:02:49.362968','2026-02-20 10:02:53.383988',NULL,0,250,'62f732ee77de47129adeeeae62885689','7a4982b18b04484999b26d85ffc0aeb4','snapshots',0,0,NULL,NULL),('2026-02-20 10:02:49.371583','2026-02-20 10:02:53.383989','2026-02-20 10:02:59.462045',251,251,NULL,'7a4982b18b04484999b26d85ffc0aeb4','snapshot_gigabytes',0,0,NULL,'e6b4ee71-4259-4da0-9292-defe62779ffe'),('2026-02-20 10:02:49.373877','2026-02-20 10:02:53.383990','2026-02-20 10:02:59.462045',252,252,NULL,'7a4982b18b04484999b26d85ffc0aeb4','snapshots',0,0,NULL,'e6b4ee71-4259-4da0-9292-defe62779ffe'),('2026-02-20 10:03:01.442236','2026-02-20 10:03:45.826885',NULL,0,253,'e249a101b3ba4a47aeac841fb07037fd','64c0e4bc9c4f49a2b268382a60f753bb','shares',0,0,NULL,NULL),('2026-02-20 10:03:01.448597','2026-02-20 10:03:45.826888',NULL,0,254,'e249a101b3ba4a47aeac841fb07037fd','64c0e4bc9c4f49a2b268382a60f753bb','gigabytes',0,0,NULL,NULL),('2026-02-20 10:03:01.459919','2026-02-20 10:03:45.826890','2026-02-20 10:03:48.696670',255,255,NULL,'64c0e4bc9c4f49a2b268382a60f753bb','shares',0,0,NULL,'3ec155a1-0e37-40f9-97b3-8bc570eb0ddc'),('2026-02-20 10:03:01.462112','2026-02-20 10:03:45.826891','2026-02-20 10:03:48.696670',256,256,NULL,'64c0e4bc9c4f49a2b268382a60f753bb','gigabytes',0,0,NULL,'3ec155a1-0e37-40f9-97b3-8bc570eb0ddc'),('2026-02-20 10:03:04.685028','2026-02-20 10:03:42.523134',NULL,0,257,'e249a101b3ba4a47aeac841fb07037fd','64c0e4bc9c4f49a2b268382a60f753bb','snapshots',0,0,NULL,NULL),('2026-02-20 10:03:04.687020','2026-02-20 10:03:42.523137',NULL,0,258,'e249a101b3ba4a47aeac841fb07037fd','64c0e4bc9c4f49a2b268382a60f753bb','snapshot_gigabytes',0,0,NULL,NULL),('2026-02-20 10:03:04.697641','2026-02-20 10:03:42.523138','2026-02-20 10:03:48.696670',259,259,NULL,'64c0e4bc9c4f49a2b268382a60f753bb','snapshots',0,0,NULL,'3ec155a1-0e37-40f9-97b3-8bc570eb0ddc'),('2026-02-20 10:03:04.699886','2026-02-20 10:03:42.523139','2026-02-20 10:03:48.696670',260,260,NULL,'64c0e4bc9c4f49a2b268382a60f753bb','snapshot_gigabytes',0,0,NULL,'3ec155a1-0e37-40f9-97b3-8bc570eb0ddc'),('2026-02-20 10:03:06.308228','2026-02-20 10:03:08.881253',NULL,0,261,'6482d78aaee741a7b765901310c888fe','8b895cabd547455590d56713f9030019','share_networks',0,0,NULL,NULL),('2026-02-20 10:03:26.734135','2026-02-20 10:03:37.288038',NULL,0,262,'6472a81b69a8490a8bf3c98b9cf5d6f8','52d1f3b64e6d4b9c92a0e84323b6701c','shares',0,0,NULL,NULL),('2026-02-20 10:03:26.736946','2026-02-20 10:03:37.288041',NULL,0,263,'6472a81b69a8490a8bf3c98b9cf5d6f8','52d1f3b64e6d4b9c92a0e84323b6701c','gigabytes',0,0,NULL,NULL),('2026-02-20 10:03:26.750361','2026-02-20 10:03:37.288043','2026-02-20 10:03:40.155717',264,264,NULL,'52d1f3b64e6d4b9c92a0e84323b6701c','shares',0,0,NULL,'b0f9e80d-4037-458e-8def-5b0bf33ad45a'),('2026-02-20 10:03:26.752955','2026-02-20 10:03:37.288045','2026-02-20 10:03:40.155717',265,265,NULL,'52d1f3b64e6d4b9c92a0e84323b6701c','gigabytes',0,0,NULL,'b0f9e80d-4037-458e-8def-5b0bf33ad45a'),('2026-02-20 10:03:29.970015','2026-02-20 10:03:34.090663',NULL,0,266,'6472a81b69a8490a8bf3c98b9cf5d6f8','52d1f3b64e6d4b9c92a0e84323b6701c','snapshots',0,0,NULL,NULL),('2026-02-20 10:03:29.972371','2026-02-20 10:03:34.090667',NULL,0,267,'6472a81b69a8490a8bf3c98b9cf5d6f8','52d1f3b64e6d4b9c92a0e84323b6701c','snapshot_gigabytes',0,0,NULL,NULL),('2026-02-20 10:03:29.979778','2026-02-20 10:03:34.090669','2026-02-20 10:03:40.155717',268,268,NULL,'52d1f3b64e6d4b9c92a0e84323b6701c','snapshots',0,0,NULL,'b0f9e80d-4037-458e-8def-5b0bf33ad45a'),('2026-02-20 10:03:29.981348','2026-02-20 10:03:34.090671','2026-02-20 10:03:40.155717',269,269,NULL,'52d1f3b64e6d4b9c92a0e84323b6701c','snapshot_gigabytes',0,0,NULL,'b0f9e80d-4037-458e-8def-5b0bf33ad45a');
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
INSERT INTO `quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `project_id`, `resource`, `hard_limit`) VALUES (1,'2026-02-20 09:59:55.418144',NULL,'2026-02-20 09:59:55.522084',1,'3dca3c8f00214a66a9293134148fac17','shares',1),(2,'2026-02-20 09:59:59.107146',NULL,'2026-02-20 10:00:02.518561',2,'3dca3c8f00214a66a9293134148fac17','snapshots',1),(3,'2026-02-20 10:00:00.941490',NULL,'2026-02-20 10:00:14.964021',3,'13d7347e58a645999865c0f5a5839f4f','shares',3),(4,'2026-02-20 10:00:00.948896',NULL,'2026-02-20 10:00:14.964021',4,'13d7347e58a645999865c0f5a5839f4f','gigabytes',10),(5,'2026-02-20 10:00:04.396950',NULL,'2026-02-20 10:00:04.471769',5,'3dca3c8f00214a66a9293134148fac17','shares',10),(6,'2026-02-20 10:00:04.783213',NULL,'2026-02-20 10:00:04.888958',6,'3dca3c8f00214a66a9293134148fac17','shares',10),(7,'2026-02-20 10:00:15.057951',NULL,'2026-02-20 10:00:15.320846',7,'13d7347e58a645999865c0f5a5839f4f','shares',55),(8,'2026-02-20 10:00:15.068504',NULL,'2026-02-20 10:00:15.320846',8,'13d7347e58a645999865c0f5a5839f4f','snapshots',55),(9,'2026-02-20 10:00:15.077569',NULL,'2026-02-20 10:00:15.320846',9,'13d7347e58a645999865c0f5a5839f4f','gigabytes',1005),(10,'2026-02-20 10:00:15.083780',NULL,'2026-02-20 10:00:15.320846',10,'13d7347e58a645999865c0f5a5839f4f','snapshot_gigabytes',1005),(11,'2026-02-20 10:00:15.088039',NULL,'2026-02-20 10:00:15.320846',11,'13d7347e58a645999865c0f5a5839f4f','share_replicas',105),(12,'2026-02-20 10:00:15.092653',NULL,'2026-02-20 10:00:15.320846',12,'13d7347e58a645999865c0f5a5839f4f','replica_gigabytes',1005),(13,'2026-02-20 10:00:15.401770',NULL,'2026-02-20 10:00:15.611157',13,'13d7347e58a645999865c0f5a5839f4f','shares',55),(14,'2026-02-20 10:00:15.407294',NULL,'2026-02-20 10:00:15.611157',14,'13d7347e58a645999865c0f5a5839f4f','snapshots',55),(15,'2026-02-20 10:00:15.412431',NULL,'2026-02-20 10:00:15.611157',15,'13d7347e58a645999865c0f5a5839f4f','gigabytes',1005),(16,'2026-02-20 10:00:15.419152',NULL,'2026-02-20 10:00:15.611157',16,'13d7347e58a645999865c0f5a5839f4f','snapshot_gigabytes',1005),(17,'2026-02-20 10:00:15.424558',NULL,'2026-02-20 10:00:15.611157',17,'13d7347e58a645999865c0f5a5839f4f','share_replicas',105),(18,'2026-02-20 10:00:15.433017',NULL,'2026-02-20 10:00:15.611157',18,'13d7347e58a645999865c0f5a5839f4f','replica_gigabytes',1005),(19,'2026-02-20 10:00:15.686530',NULL,'2026-02-20 10:00:15.736993',19,'13d7347e58a645999865c0f5a5839f4f','shares',52),(20,'2026-02-20 10:00:15.690024',NULL,'2026-02-20 10:00:15.736993',20,'13d7347e58a645999865c0f5a5839f4f','snapshots',52),(21,'2026-02-20 10:00:15.693584',NULL,'2026-02-20 10:00:15.736993',21,'13d7347e58a645999865c0f5a5839f4f','gigabytes',1002),(22,'2026-02-20 10:00:15.697593',NULL,'2026-02-20 10:00:15.736993',22,'13d7347e58a645999865c0f5a5839f4f','snapshot_gigabytes',1002),(23,'2026-02-20 10:00:15.702314',NULL,'2026-02-20 10:00:15.736993',23,'13d7347e58a645999865c0f5a5839f4f','share_networks',12),(24,'2026-02-20 10:00:15.706564',NULL,'2026-02-20 10:00:15.736993',24,'13d7347e58a645999865c0f5a5839f4f','share_replicas',102),(25,'2026-02-20 10:00:15.710136',NULL,'2026-02-20 10:00:15.736993',25,'13d7347e58a645999865c0f5a5839f4f','replica_gigabytes',1002),(26,'2026-02-20 10:00:15.840974',NULL,'2026-02-20 10:00:16.098138',26,'13d7347e58a645999865c0f5a5839f4f','shares',13),(27,'2026-02-20 10:00:16.442540',NULL,'2026-02-20 10:00:16.499191',27,'13d7347e58a645999865c0f5a5839f4f','gigabytes',-1),(28,'2026-02-20 10:00:16.549806',NULL,'2026-02-20 10:00:16.585643',28,'13d7347e58a645999865c0f5a5839f4f','share_replicas',-1),(29,'2026-02-20 10:00:16.633318',NULL,'2026-02-20 10:00:16.669065',29,'13d7347e58a645999865c0f5a5839f4f','replica_gigabytes',-1),(30,'2026-02-20 10:00:16.726378',NULL,'2026-02-20 10:00:16.780373',30,'13d7347e58a645999865c0f5a5839f4f','share_networks',-1),(31,'2026-02-20 10:00:16.833634',NULL,'2026-02-20 10:00:16.864463',31,'13d7347e58a645999865c0f5a5839f4f','shares',-1),(32,'2026-02-20 10:00:16.925672',NULL,'2026-02-20 10:00:16.970628',32,'13d7347e58a645999865c0f5a5839f4f','snapshot_gigabytes',-1),(33,'2026-02-20 10:00:17.020666',NULL,'2026-02-20 10:00:17.083390',33,'13d7347e58a645999865c0f5a5839f4f','snapshots',-1),(34,'2026-02-20 10:00:19.052991',NULL,'2026-02-20 10:00:19.139867',34,'13d7347e58a645999865c0f5a5839f4f','shares',10),(35,'2026-02-20 10:00:19.207422',NULL,'2026-02-20 10:00:19.293405',35,'13d7347e58a645999865c0f5a5839f4f','shares',10),(36,'2026-02-20 10:00:19.373211',NULL,'2026-02-20 10:00:19.392013',36,'13d7347e58a645999865c0f5a5839f4f','gigabytes',1002),(37,'2026-02-20 10:00:19.449418',NULL,'2026-02-20 10:00:19.476822',37,'13d7347e58a645999865c0f5a5839f4f','share_networks',12),(38,'2026-02-20 10:00:19.538249',NULL,'2026-02-20 10:00:19.566319',38,'13d7347e58a645999865c0f5a5839f4f','shares',52),(39,'2026-02-20 10:00:19.636450',NULL,'2026-02-20 10:00:19.658871',39,'13d7347e58a645999865c0f5a5839f4f','snapshot_gigabytes',1002),(40,'2026-02-20 10:00:19.718139',NULL,'2026-02-20 10:00:19.735505',40,'13d7347e58a645999865c0f5a5839f4f','snapshots',52),(41,'2026-02-20 10:00:19.867123',NULL,'2026-02-20 10:00:19.882144',41,'13d7347e58a645999865c0f5a5839f4f','share_replicas',99),(42,'2026-02-20 10:00:20.016842',NULL,'2026-02-20 10:00:20.041082',42,'13d7347e58a645999865c0f5a5839f4f','replica_gigabytes',999),(43,'2026-02-20 10:00:20.533915',NULL,'2026-02-20 10:00:20.669361',43,'13d7347e58a645999865c0f5a5839f4f','shares',10),(44,'2026-02-20 10:00:20.722920',NULL,'2026-02-20 10:00:20.839186',44,'13d7347e58a645999865c0f5a5839f4f','shares',10);
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `usage_id` (`usage_id`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=979 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `share_type_id`) VALUES ('2026-02-20 09:54:53.023952',NULL,'2026-02-20 09:54:53.078266',1,1,'030f7bfb48d5404cb5c2f144493c13ba','4342b681-2f55-4620-847e-445e3c08a9c8',1,'1316406c3478480189948d89dc4f438c','shares',1,'2026-02-21 09:54:52',NULL),('2026-02-20 09:54:53.026189',NULL,'2026-02-20 09:54:53.078266',2,2,'030f7bfb48d5404cb5c2f144493c13ba','d48ba8ee-e3ee-4292-8730-1cf3794a75a8',2,'1316406c3478480189948d89dc4f438c','gigabytes',1,'2026-02-21 09:54:52',NULL),('2026-02-20 09:54:53.043086',NULL,'2026-02-20 09:54:53.078266',3,3,NULL,'9a2deb62-0c11-41dd-bffb-73458d50ce88',3,'1316406c3478480189948d89dc4f438c','shares',1,'2026-02-21 09:54:52','33328c95-5381-4fc8-b42b-daec4d660044'),('2026-02-20 09:54:53.044304',NULL,'2026-02-20 09:54:53.078266',4,4,NULL,'ed9b2f4a-987e-4976-826f-9f7b0b5f689f',4,'1316406c3478480189948d89dc4f438c','gigabytes',1,'2026-02-21 09:54:52','33328c95-5381-4fc8-b42b-daec4d660044'),('2026-02-20 09:54:56.497983',NULL,'2026-02-20 09:54:56.527665',5,5,'030f7bfb48d5404cb5c2f144493c13ba','04974e3f-09bc-46e5-87bd-4924b5b66db9',1,'1316406c3478480189948d89dc4f438c','shares',-1,'2026-02-21 09:54:56',NULL),('2026-02-20 09:54:56.500321',NULL,'2026-02-20 09:54:56.527665',6,6,'030f7bfb48d5404cb5c2f144493c13ba','e1d5008e-e188-4e62-b7f9-f4b5e8d68c57',2,'1316406c3478480189948d89dc4f438c','gigabytes',-1,'2026-02-21 09:54:56',NULL),('2026-02-20 09:54:56.512191',NULL,'2026-02-20 09:54:56.527665',7,7,NULL,'75ea8ea4-c326-4f30-a745-f3d7fba610bf',3,'1316406c3478480189948d89dc4f438c','shares',-1,'2026-02-21 09:54:56','33328c95-5381-4fc8-b42b-daec4d660044'),('2026-02-20 09:54:56.513175',NULL,'2026-02-20 09:54:56.527665',8,8,NULL,'87758e09-66e8-415d-ab8b-6ffd04659e0b',4,'1316406c3478480189948d89dc4f438c','gigabytes',-1,'2026-02-21 09:54:56','33328c95-5381-4fc8-b42b-daec4d660044'),('2026-02-20 09:55:25.994460',NULL,'2026-02-20 09:55:26.033025',9,9,'37f65b711ccf433f86420da7d18f479c','4da64a15-ae21-4608-a1c5-6d39c9689ada',6,'0635b5dae1854e178484d0abec19ab72','shares',1,'2026-02-21 09:55:25',NULL),('2026-02-20 09:55:25.996815',NULL,'2026-02-20 09:55:26.033025',10,10,'37f65b711ccf433f86420da7d18f479c','ede8fb2b-6be9-4e93-9cda-c0ab25bcb6e9',5,'0635b5dae1854e178484d0abec19ab72','gigabytes',1,'2026-02-21 09:55:25',NULL),('2026-02-20 09:55:26.012567',NULL,'2026-02-20 09:55:26.033025',11,11,NULL,'6a8ea7fd-3859-4c44-8f78-686d0aab9c9d',8,'0635b5dae1854e178484d0abec19ab72','shares',1,'2026-02-21 09:55:25','e77c21ce-a6ed-4799-a84b-87df7ec5cd53'),('2026-02-20 09:55:26.013660',NULL,'2026-02-20 09:55:26.033025',12,12,NULL,'f42b5ddb-a73f-4da6-933a-4c567f824edb',7,'0635b5dae1854e178484d0abec19ab72','gigabytes',1,'2026-02-21 09:55:25','e77c21ce-a6ed-4799-a84b-87df7ec5cd53'),('2026-02-20 09:55:29.307235',NULL,'2026-02-20 09:55:29.470330',13,13,'37f65b711ccf433f86420da7d18f479c','e30a4ad5-8442-48bb-8788-d4230d22ae7f',10,'0635b5dae1854e178484d0abec19ab72','snapshots',1,'2026-02-21 09:55:29',NULL),('2026-02-20 09:55:29.309010',NULL,'2026-02-20 09:55:29.470330',14,14,'37f65b711ccf433f86420da7d18f479c','bb1afb05-e856-4208-b6ea-631089671f19',9,'0635b5dae1854e178484d0abec19ab72','snapshot_gigabytes',1,'2026-02-21 09:55:29',NULL),('2026-02-20 09:55:29.331807',NULL,'2026-02-20 09:55:29.470330',15,15,NULL,'b120aabd-f026-4b34-a216-891a1e5bca9e',12,'0635b5dae1854e178484d0abec19ab72','snapshots',1,'2026-02-21 09:55:29','e77c21ce-a6ed-4799-a84b-87df7ec5cd53'),('2026-02-20 09:55:29.332930',NULL,'2026-02-20 09:55:29.470330',16,16,NULL,'c2c8e5ad-13ec-4a46-8009-c8cf114e34ea',11,'0635b5dae1854e178484d0abec19ab72','snapshot_gigabytes',1,'2026-02-21 09:55:29','e77c21ce-a6ed-4799-a84b-87df7ec5cd53'),('2026-02-20 09:55:33.003770',NULL,'2026-02-20 09:55:33.070319',17,17,'37f65b711ccf433f86420da7d18f479c','3bbe1981-48ea-41e9-a6fa-b08c6b040547',10,'0635b5dae1854e178484d0abec19ab72','snapshots',1,'2026-02-21 09:55:32',NULL),('2026-02-20 09:55:33.004988',NULL,'2026-02-20 09:55:33.070319',18,18,'37f65b711ccf433f86420da7d18f479c','16df7b24-bb95-4af3-aec1-6d0c1c4aa32e',9,'0635b5dae1854e178484d0abec19ab72','snapshot_gigabytes',1,'2026-02-21 09:55:32',NULL),('2026-02-20 09:55:33.009675',NULL,'2026-02-20 09:55:33.070319',19,19,NULL,'fc6e9312-6f15-4379-8359-c0c93b2074b6',12,'0635b5dae1854e178484d0abec19ab72','snapshots',1,'2026-02-21 09:55:32','e77c21ce-a6ed-4799-a84b-87df7ec5cd53'),('2026-02-20 09:55:33.010785',NULL,'2026-02-20 09:55:33.070319',20,20,NULL,'ed3f3b29-1dd4-4a29-9ff1-0ac297ecfff1',11,'0635b5dae1854e178484d0abec19ab72','snapshot_gigabytes',1,'2026-02-21 09:55:32','e77c21ce-a6ed-4799-a84b-87df7ec5cd53'),('2026-02-20 09:55:36.846482',NULL,'2026-02-20 09:55:36.887275',21,21,'37f65b711ccf433f86420da7d18f479c','5918f886-0bea-45d4-85b0-ebdb0b484d72',10,'0635b5dae1854e178484d0abec19ab72','snapshots',-1,'2026-02-21 09:55:36',NULL),('2026-02-20 09:55:36.848518',NULL,'2026-02-20 09:55:36.887275',22,22,'37f65b711ccf433f86420da7d18f479c','994aa525-2959-47b7-8f84-2d49b0f85408',9,'0635b5dae1854e178484d0abec19ab72','snapshot_gigabytes',-1,'2026-02-21 09:55:36',NULL),('2026-02-20 09:55:36.870019',NULL,'2026-02-20 09:55:36.887275',23,23,NULL,'8b7f8aee-9ae2-42f2-8812-3d656a2e6587',12,'0635b5dae1854e178484d0abec19ab72','snapshots',-1,'2026-02-21 09:55:36','e77c21ce-a6ed-4799-a84b-87df7ec5cd53'),('2026-02-20 09:55:36.871668',NULL,'2026-02-20 09:55:36.887275',24,24,NULL,'bda70063-da0d-4169-84f4-feac51943eb0',11,'0635b5dae1854e178484d0abec19ab72','snapshot_gigabytes',-1,'2026-02-21 09:55:36','e77c21ce-a6ed-4799-a84b-87df7ec5cd53'),('2026-02-20 09:55:40.056916',NULL,'2026-02-20 09:55:40.069011',25,25,'37f65b711ccf433f86420da7d18f479c','506547dd-ef81-4b70-ad41-118006ce48c5',10,'0635b5dae1854e178484d0abec19ab72','snapshots',-1,'2026-02-21 09:55:40',NULL),('2026-02-20 09:55:40.057560',NULL,'2026-02-20 09:55:40.069011',26,26,'37f65b711ccf433f86420da7d18f479c','e6c23017-4cc4-4ef5-99a1-bbb7f6052ddd',9,'0635b5dae1854e178484d0abec19ab72','snapshot_gigabytes',-1,'2026-02-21 09:55:40',NULL),('2026-02-20 09:55:40.062318',NULL,'2026-02-20 09:55:40.069011',27,27,NULL,'efcfd26a-7c01-4352-90f6-b4b5caece01d',12,'0635b5dae1854e178484d0abec19ab72','snapshots',-1,'2026-02-21 09:55:40','e77c21ce-a6ed-4799-a84b-87df7ec5cd53'),('2026-02-20 09:55:40.062988',NULL,'2026-02-20 09:55:40.069011',28,28,NULL,'af0e7d49-9677-4ca0-bd62-22eb3fe5ad21',11,'0635b5dae1854e178484d0abec19ab72','snapshot_gigabytes',-1,'2026-02-21 09:55:40','e77c21ce-a6ed-4799-a84b-87df7ec5cd53'),('2026-02-20 09:55:43.312257',NULL,'2026-02-20 09:55:43.327783',29,29,'37f65b711ccf433f86420da7d18f479c','7c7a72ae-1adf-4734-82d8-69212f76491e',6,'0635b5dae1854e178484d0abec19ab72','shares',-1,'2026-02-21 09:55:43',NULL),('2026-02-20 09:55:43.313035',NULL,'2026-02-20 09:55:43.327783',30,30,'37f65b711ccf433f86420da7d18f479c','a63c1583-03fb-403c-9341-6e0bc9ee7094',5,'0635b5dae1854e178484d0abec19ab72','gigabytes',-1,'2026-02-21 09:55:43',NULL),('2026-02-20 09:55:43.319989',NULL,'2026-02-20 09:55:43.327783',31,31,NULL,'330e9bd2-f690-4618-9642-a0daeb02b8f6',8,'0635b5dae1854e178484d0abec19ab72','shares',-1,'2026-02-21 09:55:43','e77c21ce-a6ed-4799-a84b-87df7ec5cd53'),('2026-02-20 09:55:43.320660',NULL,'2026-02-20 09:55:43.327783',32,32,NULL,'1809d9dd-6a84-4c59-b7ec-ade005e32094',7,'0635b5dae1854e178484d0abec19ab72','gigabytes',-1,'2026-02-21 09:55:43','e77c21ce-a6ed-4799-a84b-87df7ec5cd53'),('2026-02-20 09:55:51.399176',NULL,'2026-02-20 09:55:51.443646',33,33,'fb1fbd877a8346d5b367f7463ffb510c','32cf17d7-bf15-49da-8d29-8f548781d711',14,'d0927694241842759be660760b008959','shares',1,'2026-02-21 09:55:51',NULL),('2026-02-20 09:55:51.400508',NULL,'2026-02-20 09:55:51.443646',34,34,'fb1fbd877a8346d5b367f7463ffb510c','024bdcf8-d6c5-4a00-90cc-7c4305f8e7eb',13,'d0927694241842759be660760b008959','gigabytes',1,'2026-02-21 09:55:51',NULL),('2026-02-20 09:55:51.409588',NULL,'2026-02-20 09:55:51.443646',35,35,NULL,'db25c88d-ae0f-4a40-adc3-1aa6a5571cdf',16,'d0927694241842759be660760b008959','shares',1,'2026-02-21 09:55:51','07221afd-ccd1-4ae1-a11b-cd0c08f035ea'),('2026-02-20 09:55:51.412818',NULL,'2026-02-20 09:55:51.443646',36,36,NULL,'7dd52c4f-3414-45f6-9cf0-56a4e0663996',15,'d0927694241842759be660760b008959','gigabytes',1,'2026-02-21 09:55:51','07221afd-ccd1-4ae1-a11b-cd0c08f035ea'),('2026-02-20 09:55:54.850675',NULL,'2026-02-20 09:55:54.963504',37,37,'fb1fbd877a8346d5b367f7463ffb510c','48f94ccd-4fa7-4e1f-939f-71821484cd5c',18,'d0927694241842759be660760b008959','snapshots',1,'2026-02-21 09:55:54',NULL),('2026-02-20 09:55:54.855439',NULL,'2026-02-20 09:55:54.963504',38,38,'fb1fbd877a8346d5b367f7463ffb510c','eb2c910f-619b-41e0-9d61-1a06640d27e7',17,'d0927694241842759be660760b008959','snapshot_gigabytes',1,'2026-02-21 09:55:54',NULL),('2026-02-20 09:55:54.877946',NULL,'2026-02-20 09:55:54.963504',39,39,NULL,'863bbaae-f4ac-459d-b3dc-db2b50f13c84',20,'d0927694241842759be660760b008959','snapshots',1,'2026-02-21 09:55:54','07221afd-ccd1-4ae1-a11b-cd0c08f035ea'),('2026-02-20 09:55:54.878920',NULL,'2026-02-20 09:55:54.963504',40,40,NULL,'d3998422-a0ae-4723-9c48-bbf4715abd3d',19,'d0927694241842759be660760b008959','snapshot_gigabytes',1,'2026-02-21 09:55:54','07221afd-ccd1-4ae1-a11b-cd0c08f035ea'),('2026-02-20 09:55:56.632099',NULL,'2026-02-20 09:55:56.686769',41,41,'8c63ad2215564b2ba1a91046040dcfc1','df204ed8-6b3d-4d43-afc7-4d03e60b3add',22,'d345acb999b945ac8ca92ec3a0b92da6','shares',1,'2026-02-21 09:55:56',NULL),('2026-02-20 09:55:56.634661',NULL,'2026-02-20 09:55:56.686769',42,42,'8c63ad2215564b2ba1a91046040dcfc1','7f39710b-5ee7-4d3d-95c0-529377737649',21,'d345acb999b945ac8ca92ec3a0b92da6','gigabytes',1,'2026-02-21 09:55:56',NULL),('2026-02-20 09:55:56.654343',NULL,'2026-02-20 09:55:56.686769',43,43,NULL,'322e2be2-b3e0-4b7a-879c-c1a077b80bb3',24,'d345acb999b945ac8ca92ec3a0b92da6','shares',1,'2026-02-21 09:55:56','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:55:56.655955',NULL,'2026-02-20 09:55:56.686769',44,44,NULL,'62eb2ec2-d745-4153-af12-59c8a0cfea17',23,'d345acb999b945ac8ca92ec3a0b92da6','gigabytes',1,'2026-02-21 09:55:56','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:55:58.459312',NULL,'2026-02-20 09:55:58.510471',45,45,'fb1fbd877a8346d5b367f7463ffb510c','82d5c91e-4cc3-4db9-b657-70df66e87b75',14,'d0927694241842759be660760b008959','shares',1,'2026-02-21 09:55:58',NULL),('2026-02-20 09:55:58.460644',NULL,'2026-02-20 09:55:58.510471',46,46,'fb1fbd877a8346d5b367f7463ffb510c','f34aede7-6a07-4a50-8dc7-99b6a1cdb7b4',13,'d0927694241842759be660760b008959','gigabytes',1,'2026-02-21 09:55:58',NULL),('2026-02-20 09:55:58.476462',NULL,'2026-02-20 09:55:58.510471',47,47,NULL,'6584d8e1-6c1e-4ad0-8f88-4cf3fada2882',16,'d0927694241842759be660760b008959','shares',1,'2026-02-21 09:55:58','07221afd-ccd1-4ae1-a11b-cd0c08f035ea'),('2026-02-20 09:55:58.477627',NULL,'2026-02-20 09:55:58.510471',48,48,NULL,'e2ba8b5f-f30d-4bda-8ec2-5dd98b584315',15,'d0927694241842759be660760b008959','gigabytes',1,'2026-02-21 09:55:58','07221afd-ccd1-4ae1-a11b-cd0c08f035ea'),('2026-02-20 09:55:59.928528',NULL,'2026-02-20 09:55:59.965136',49,49,'8c63ad2215564b2ba1a91046040dcfc1','a799f1c5-812c-4ec3-ae9c-6e1be5b7c7e5',22,'d345acb999b945ac8ca92ec3a0b92da6','shares',1,'2026-02-21 09:55:59',NULL),('2026-02-20 09:55:59.929968',NULL,'2026-02-20 09:55:59.965136',50,50,'8c63ad2215564b2ba1a91046040dcfc1','f7c7a7d1-7797-462c-b1ed-b8a7fc0bdd82',21,'d345acb999b945ac8ca92ec3a0b92da6','gigabytes',1,'2026-02-21 09:55:59',NULL),('2026-02-20 09:55:59.941733',NULL,'2026-02-20 09:55:59.965136',51,51,NULL,'2bd92ac8-1ac4-4474-a84b-9ca213c4ef92',24,'d345acb999b945ac8ca92ec3a0b92da6','shares',1,'2026-02-21 09:55:59','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:55:59.943005',NULL,'2026-02-20 09:55:59.965136',52,52,NULL,'a2a5f375-7101-4f32-9b3a-e4c4c3d7c895',23,'d345acb999b945ac8ca92ec3a0b92da6','gigabytes',1,'2026-02-21 09:55:59','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:03.225061',NULL,'2026-02-20 09:56:03.353069',53,53,'8c63ad2215564b2ba1a91046040dcfc1','397973f4-3a61-46df-8e7e-9304efb622b9',21,'d345acb999b945ac8ca92ec3a0b92da6','gigabytes',1,'2026-02-21 09:56:03',NULL),('2026-02-20 09:56:03.234376',NULL,'2026-02-20 09:56:03.353069',54,54,NULL,'64e86a3d-f310-4120-9a8a-d4260026c4e1',23,'d345acb999b945ac8ca92ec3a0b92da6','gigabytes',1,'2026-02-21 09:56:03','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:06.799252',NULL,'2026-02-20 09:56:06.813182',55,55,'8c63ad2215564b2ba1a91046040dcfc1','fd42b4f8-e62b-4fa2-8b9d-19487d8c1545',22,'d345acb999b945ac8ca92ec3a0b92da6','shares',-1,'2026-02-21 09:56:06',NULL),('2026-02-20 09:56:06.799943',NULL,'2026-02-20 09:56:06.813182',56,56,'8c63ad2215564b2ba1a91046040dcfc1','8c9313e2-685e-465e-8a96-ffa65e587478',21,'d345acb999b945ac8ca92ec3a0b92da6','gigabytes',-2,'2026-02-21 09:56:06',NULL),('2026-02-20 09:56:06.806022',NULL,'2026-02-20 09:56:06.813182',57,57,NULL,'7d7bccf4-325e-4a0f-9788-160e1380cccc',24,'d345acb999b945ac8ca92ec3a0b92da6','shares',-1,'2026-02-21 09:56:06','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:06.806688',NULL,'2026-02-20 09:56:06.813182',58,58,NULL,'248432fe-45ba-49f9-8f86-0dae270243ae',23,'d345acb999b945ac8ca92ec3a0b92da6','gigabytes',-2,'2026-02-21 09:56:06','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:09.711421',NULL,'2026-02-20 09:56:09.743851',59,59,'8c63ad2215564b2ba1a91046040dcfc1','fe522ef0-8bfe-451d-b419-5c285e70ea45',22,'d345acb999b945ac8ca92ec3a0b92da6','shares',1,'2026-02-21 09:56:09',NULL),('2026-02-20 09:56:09.716437',NULL,'2026-02-20 09:56:09.743851',60,60,'8c63ad2215564b2ba1a91046040dcfc1','ca246dd4-f535-4f97-85cf-4dcdd7543335',21,'d345acb999b945ac8ca92ec3a0b92da6','gigabytes',1,'2026-02-21 09:56:09',NULL),('2026-02-20 09:56:09.723088',NULL,'2026-02-20 09:56:09.743851',61,61,NULL,'4efcc1ab-060a-488e-8efb-f0732b938664',24,'d345acb999b945ac8ca92ec3a0b92da6','shares',1,'2026-02-21 09:56:09','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:09.724475',NULL,'2026-02-20 09:56:09.743851',62,62,NULL,'8d52e6c4-43cd-4085-8268-2b0b93a35363',23,'d345acb999b945ac8ca92ec3a0b92da6','gigabytes',1,'2026-02-21 09:56:09','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:12.997863',NULL,'2026-02-20 09:56:13.203669',63,63,'8c63ad2215564b2ba1a91046040dcfc1','8b87c7b1-0357-4d64-9f01-fd78d912f816',21,'d345acb999b945ac8ca92ec3a0b92da6','gigabytes',1,'2026-02-21 09:56:12',NULL),('2026-02-20 09:56:13.006111',NULL,'2026-02-20 09:56:13.203669',64,64,NULL,'bb89ab52-924d-4ecc-818b-c299d5ea4d12',23,'d345acb999b945ac8ca92ec3a0b92da6','gigabytes',1,'2026-02-21 09:56:12','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:16.639358',NULL,'2026-02-20 09:56:16.654632',65,65,'8c63ad2215564b2ba1a91046040dcfc1','2c105a7c-a513-4653-8865-42496e2b558d',22,'d345acb999b945ac8ca92ec3a0b92da6','shares',-1,'2026-02-21 09:56:16',NULL),('2026-02-20 09:56:16.640132',NULL,'2026-02-20 09:56:16.654632',66,66,'8c63ad2215564b2ba1a91046040dcfc1','51aa360f-845d-46b6-bc04-0ceafbf7dbb5',21,'d345acb999b945ac8ca92ec3a0b92da6','gigabytes',-2,'2026-02-21 09:56:16',NULL),('2026-02-20 09:56:16.645973',NULL,'2026-02-20 09:56:16.654632',67,67,NULL,'1b722444-8a16-4e95-8175-e6b3304edcc2',24,'d345acb999b945ac8ca92ec3a0b92da6','shares',-1,'2026-02-21 09:56:16','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:16.646755',NULL,'2026-02-20 09:56:16.654632',68,68,NULL,'39df513c-94c5-4a79-b62c-bbc1da59606f',23,'d345acb999b945ac8ca92ec3a0b92da6','gigabytes',-2,'2026-02-21 09:56:16','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:19.576027',NULL,'2026-02-20 09:56:19.605170',69,69,'8c63ad2215564b2ba1a91046040dcfc1','8992acec-8149-4add-b9a7-2604a08be475',22,'d345acb999b945ac8ca92ec3a0b92da6','shares',1,'2026-02-21 09:56:19',NULL),('2026-02-20 09:56:19.577178',NULL,'2026-02-20 09:56:19.605170',70,70,'8c63ad2215564b2ba1a91046040dcfc1','caa644d3-7b54-4fec-ba1b-9bc65ad5aa6e',21,'d345acb999b945ac8ca92ec3a0b92da6','gigabytes',1,'2026-02-21 09:56:19',NULL),('2026-02-20 09:56:19.582196',NULL,'2026-02-20 09:56:19.605170',71,71,NULL,'def794dd-becf-4941-97bc-d6e8975024dc',24,'d345acb999b945ac8ca92ec3a0b92da6','shares',1,'2026-02-21 09:56:19','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:19.583206',NULL,'2026-02-20 09:56:19.605170',72,72,NULL,'19270a74-6a1c-4462-b2ba-4358033c25ee',23,'d345acb999b945ac8ca92ec3a0b92da6','gigabytes',1,'2026-02-21 09:56:19','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:23.181084',NULL,'2026-02-20 09:56:23.196253',73,73,'8c63ad2215564b2ba1a91046040dcfc1','6154b573-77b1-41ca-843e-e5a40423a6c5',22,'d345acb999b945ac8ca92ec3a0b92da6','shares',-1,'2026-02-21 09:56:23',NULL),('2026-02-20 09:56:23.181844',NULL,'2026-02-20 09:56:23.196253',74,74,'8c63ad2215564b2ba1a91046040dcfc1','2ab818b5-c657-478e-bae1-bc9f550a044e',21,'d345acb999b945ac8ca92ec3a0b92da6','gigabytes',-1,'2026-02-21 09:56:23',NULL),('2026-02-20 09:56:23.187313',NULL,'2026-02-20 09:56:23.196253',75,75,NULL,'4c7d0e82-bf0d-4a6e-9947-4e3e5e3d9ede',24,'d345acb999b945ac8ca92ec3a0b92da6','shares',-1,'2026-02-21 09:56:23','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:23.188863',NULL,'2026-02-20 09:56:23.196253',76,76,NULL,'9776792b-caf7-40dd-a37d-867b0b7861fe',23,'d345acb999b945ac8ca92ec3a0b92da6','gigabytes',-1,'2026-02-21 09:56:23','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:26.077194',NULL,'2026-02-20 09:56:26.102546',77,77,'8c63ad2215564b2ba1a91046040dcfc1','b5d22613-39dc-45c5-9bf4-af0e8aab4320',22,'d345acb999b945ac8ca92ec3a0b92da6','shares',1,'2026-02-21 09:56:26',NULL),('2026-02-20 09:56:26.079059',NULL,'2026-02-20 09:56:26.102546',78,78,'8c63ad2215564b2ba1a91046040dcfc1','7de85823-7b76-457a-8884-98d3c741f4ab',21,'d345acb999b945ac8ca92ec3a0b92da6','gigabytes',1,'2026-02-21 09:56:26',NULL),('2026-02-20 09:56:26.084358',NULL,'2026-02-20 09:56:26.102546',79,79,NULL,'ba315856-c735-4cb7-ad79-9a1335b38be3',24,'d345acb999b945ac8ca92ec3a0b92da6','shares',1,'2026-02-21 09:56:26','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:26.085398',NULL,'2026-02-20 09:56:26.102546',80,80,NULL,'a778b454-c6be-4480-b5c0-96f413838351',23,'d345acb999b945ac8ca92ec3a0b92da6','gigabytes',1,'2026-02-21 09:56:26','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:29.724499',NULL,'2026-02-20 09:56:29.737354',81,81,'8c63ad2215564b2ba1a91046040dcfc1','82899fb0-d7c1-46c7-9132-1df9f5778d67',22,'d345acb999b945ac8ca92ec3a0b92da6','shares',-1,'2026-02-21 09:56:29',NULL),('2026-02-20 09:56:29.725286',NULL,'2026-02-20 09:56:29.737354',82,82,'8c63ad2215564b2ba1a91046040dcfc1','c84fe867-c8ac-4883-a89a-0b3ce5a67188',21,'d345acb999b945ac8ca92ec3a0b92da6','gigabytes',-1,'2026-02-21 09:56:29',NULL),('2026-02-20 09:56:29.730492',NULL,'2026-02-20 09:56:29.737354',83,83,NULL,'f87ceadf-80b7-4add-82ab-7fd4ad52589a',24,'d345acb999b945ac8ca92ec3a0b92da6','shares',-1,'2026-02-21 09:56:29','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:29.731292',NULL,'2026-02-20 09:56:29.737354',84,84,NULL,'41a5d6ea-1add-4008-aca2-ee95a04811a7',23,'d345acb999b945ac8ca92ec3a0b92da6','gigabytes',-1,'2026-02-21 09:56:29','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:32.721956',NULL,'2026-02-20 09:56:32.856608',85,85,'8c63ad2215564b2ba1a91046040dcfc1','ae48ad56-3bde-40f4-899a-4061105e760f',26,'d345acb999b945ac8ca92ec3a0b92da6','snapshots',1,'2026-02-21 09:56:32',NULL),('2026-02-20 09:56:32.723370',NULL,'2026-02-20 09:56:32.856608',86,86,'8c63ad2215564b2ba1a91046040dcfc1','96cd5b4e-906b-4446-b4dc-e98c2401e3a4',25,'d345acb999b945ac8ca92ec3a0b92da6','snapshot_gigabytes',1,'2026-02-21 09:56:32',NULL),('2026-02-20 09:56:32.736237',NULL,'2026-02-20 09:56:32.856608',87,87,NULL,'8c58f78f-a942-45f4-81b0-463d23c66af8',28,'d345acb999b945ac8ca92ec3a0b92da6','snapshots',1,'2026-02-21 09:56:32','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:32.737488',NULL,'2026-02-20 09:56:32.856608',88,88,NULL,'6df05abc-2602-44c5-9cf1-3236077b9454',27,'d345acb999b945ac8ca92ec3a0b92da6','snapshot_gigabytes',1,'2026-02-21 09:56:32','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:36.576604',NULL,'2026-02-20 09:56:36.595622',89,89,'8c63ad2215564b2ba1a91046040dcfc1','4f1109fb-398d-4f33-8dba-7458c9fc1902',26,'d345acb999b945ac8ca92ec3a0b92da6','snapshots',-1,'2026-02-21 09:56:36',NULL),('2026-02-20 09:56:36.578648',NULL,'2026-02-20 09:56:36.595622',90,90,'8c63ad2215564b2ba1a91046040dcfc1','f03cfca7-7f62-4ddf-be3b-69633559f013',25,'d345acb999b945ac8ca92ec3a0b92da6','snapshot_gigabytes',-1,'2026-02-21 09:56:36',NULL),('2026-02-20 09:56:36.586353',NULL,'2026-02-20 09:56:36.595622',91,91,NULL,'fa05b9d4-266d-427f-8192-aa3ae7ae7a53',28,'d345acb999b945ac8ca92ec3a0b92da6','snapshots',-1,'2026-02-21 09:56:36','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:36.587046',NULL,'2026-02-20 09:56:36.595622',92,92,NULL,'fba3752d-1975-4867-ba25-cb63ed6ffd58',27,'d345acb999b945ac8ca92ec3a0b92da6','snapshot_gigabytes',-1,'2026-02-21 09:56:36','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:41.939883',NULL,'2026-02-20 09:56:42.029954',93,93,'8c63ad2215564b2ba1a91046040dcfc1','6150b4c0-8f2e-4ce7-bbab-b67c49d9b419',26,'d345acb999b945ac8ca92ec3a0b92da6','snapshots',1,'2026-02-21 09:56:41',NULL),('2026-02-20 09:56:41.941041',NULL,'2026-02-20 09:56:42.029954',94,94,'8c63ad2215564b2ba1a91046040dcfc1','10d678a4-34e3-473c-b308-04aa3d333f6b',25,'d345acb999b945ac8ca92ec3a0b92da6','snapshot_gigabytes',1,'2026-02-21 09:56:41',NULL),('2026-02-20 09:56:41.951379',NULL,'2026-02-20 09:56:42.029954',95,95,NULL,'db67c8be-6140-4156-8d5c-1835a37a94e9',28,'d345acb999b945ac8ca92ec3a0b92da6','snapshots',1,'2026-02-21 09:56:41','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:41.952726',NULL,'2026-02-20 09:56:42.029954',96,96,NULL,'7b2c50bf-f0f3-40dc-be82-a601eee627e1',27,'d345acb999b945ac8ca92ec3a0b92da6','snapshot_gigabytes',1,'2026-02-21 09:56:41','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:45.495403',NULL,'2026-02-20 09:56:45.721536',97,97,'8c63ad2215564b2ba1a91046040dcfc1','158de873-67d6-4dc0-af7f-e864bd67dd7d',26,'d345acb999b945ac8ca92ec3a0b92da6','snapshots',1,'2026-02-21 09:56:45',NULL),('2026-02-20 09:56:45.496982',NULL,'2026-02-20 09:56:45.721536',98,98,'8c63ad2215564b2ba1a91046040dcfc1','b13c729f-b1f4-4c40-b3d4-0c0a1337d66c',25,'d345acb999b945ac8ca92ec3a0b92da6','snapshot_gigabytes',1,'2026-02-21 09:56:45',NULL),('2026-02-20 09:56:45.529855',NULL,'2026-02-20 09:56:45.721536',99,99,NULL,'24858d3f-e95a-4b6d-9943-c0eae9b8c4b5',28,'d345acb999b945ac8ca92ec3a0b92da6','snapshots',1,'2026-02-21 09:56:45','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:45.531651',NULL,'2026-02-20 09:56:45.721536',100,100,NULL,'a1a0eabf-39af-4fe6-aa8d-6336452caa28',27,'d345acb999b945ac8ca92ec3a0b92da6','snapshot_gigabytes',1,'2026-02-21 09:56:45','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:46.643278',NULL,'2026-02-20 09:56:46.659474',101,101,'fb1fbd877a8346d5b367f7463ffb510c','fd8be368-2249-4595-af7b-63bd2619ea8c',14,'d0927694241842759be660760b008959','shares',-1,'2026-02-21 09:56:46',NULL),('2026-02-20 09:56:46.644258',NULL,'2026-02-20 09:56:46.659474',102,102,'fb1fbd877a8346d5b367f7463ffb510c','93e8ef95-6ccf-4272-b373-acc9bbeb9858',13,'d0927694241842759be660760b008959','gigabytes',-1,'2026-02-21 09:56:46',NULL),('2026-02-20 09:56:46.651791',NULL,'2026-02-20 09:56:46.659474',103,103,NULL,'4f4f24c1-cf63-45ca-b34a-3b4ebb1ac3fe',16,'d0927694241842759be660760b008959','shares',-1,'2026-02-21 09:56:46','07221afd-ccd1-4ae1-a11b-cd0c08f035ea'),('2026-02-20 09:56:46.652694',NULL,'2026-02-20 09:56:46.659474',104,104,NULL,'4188e505-af76-4971-bfc1-9ba325ba89c2',15,'d0927694241842759be660760b008959','gigabytes',-1,'2026-02-21 09:56:46','07221afd-ccd1-4ae1-a11b-cd0c08f035ea'),('2026-02-20 09:56:49.231620',NULL,'2026-02-20 09:56:49.343690',105,105,'8c63ad2215564b2ba1a91046040dcfc1','d5d94b30-a054-444c-b0e3-9d6fbc4cdb56',26,'d345acb999b945ac8ca92ec3a0b92da6','snapshots',1,'2026-02-21 09:56:49',NULL),('2026-02-20 09:56:49.233203',NULL,'2026-02-20 09:56:49.343690',106,106,'8c63ad2215564b2ba1a91046040dcfc1','0fcdd33b-29a8-4192-94d0-f2de085de5ba',25,'d345acb999b945ac8ca92ec3a0b92da6','snapshot_gigabytes',1,'2026-02-21 09:56:49',NULL),('2026-02-20 09:56:49.243240',NULL,'2026-02-20 09:56:49.343690',107,107,NULL,'24332406-94cb-436f-8f6a-333630af6c6b',28,'d345acb999b945ac8ca92ec3a0b92da6','snapshots',1,'2026-02-21 09:56:49','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:49.244603',NULL,'2026-02-20 09:56:49.343690',108,108,NULL,'c920041e-2c60-4339-828f-c60aa3cd0fba',27,'d345acb999b945ac8ca92ec3a0b92da6','snapshot_gigabytes',1,'2026-02-21 09:56:49','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:49.998957',NULL,'2026-02-20 09:56:50.014123',109,109,'fb1fbd877a8346d5b367f7463ffb510c','4fa85614-9341-4ef6-97dc-dd27b8d4ccb3',18,'d0927694241842759be660760b008959','snapshots',-1,'2026-02-21 09:56:49',NULL),('2026-02-20 09:56:49.999669',NULL,'2026-02-20 09:56:50.014123',110,110,'fb1fbd877a8346d5b367f7463ffb510c','f704b600-a9f7-4303-ae01-9256b0a3c579',17,'d0927694241842759be660760b008959','snapshot_gigabytes',-1,'2026-02-21 09:56:49',NULL),('2026-02-20 09:56:50.005692',NULL,'2026-02-20 09:56:50.014123',111,111,NULL,'6c313024-6739-4255-8460-082810e24f35',20,'d0927694241842759be660760b008959','snapshots',-1,'2026-02-21 09:56:49','07221afd-ccd1-4ae1-a11b-cd0c08f035ea'),('2026-02-20 09:56:50.006513',NULL,'2026-02-20 09:56:50.014123',112,112,NULL,'3157f41c-ceb6-4985-bf01-ed7c8cbd3f60',19,'d0927694241842759be660760b008959','snapshot_gigabytes',-1,'2026-02-21 09:56:49','07221afd-ccd1-4ae1-a11b-cd0c08f035ea'),('2026-02-20 09:56:52.726622',NULL,'2026-02-20 09:56:52.805768',113,113,'8c63ad2215564b2ba1a91046040dcfc1','d5fc6db0-8de3-4eed-bed8-3938d5af1f71',26,'d345acb999b945ac8ca92ec3a0b92da6','snapshots',1,'2026-02-21 09:56:52',NULL),('2026-02-20 09:56:52.728276',NULL,'2026-02-20 09:56:52.805768',114,114,'8c63ad2215564b2ba1a91046040dcfc1','a008a2d7-fe84-45e5-9ff1-ef6b8ed7a567',25,'d345acb999b945ac8ca92ec3a0b92da6','snapshot_gigabytes',1,'2026-02-21 09:56:52',NULL),('2026-02-20 09:56:52.739497',NULL,'2026-02-20 09:56:52.805768',115,115,NULL,'c513af37-4f35-444c-b160-02f66434d1a2',28,'d345acb999b945ac8ca92ec3a0b92da6','snapshots',1,'2026-02-21 09:56:52','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:52.741131',NULL,'2026-02-20 09:56:52.805768',116,116,NULL,'65a6b290-2961-4e04-a054-a647000966e3',27,'d345acb999b945ac8ca92ec3a0b92da6','snapshot_gigabytes',1,'2026-02-21 09:56:52','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:53.162297',NULL,'2026-02-20 09:56:53.186779',117,117,'fb1fbd877a8346d5b367f7463ffb510c','c71730fd-3535-4836-917c-46054be8c640',14,'d0927694241842759be660760b008959','shares',-1,'2026-02-21 09:56:53',NULL),('2026-02-20 09:56:53.163953',NULL,'2026-02-20 09:56:53.186779',118,118,'fb1fbd877a8346d5b367f7463ffb510c','e545d6fa-b1e0-4f78-8253-3e7b5650d7d5',13,'d0927694241842759be660760b008959','gigabytes',-1,'2026-02-21 09:56:53',NULL),('2026-02-20 09:56:53.172562',NULL,'2026-02-20 09:56:53.186779',119,119,NULL,'3a2db2d4-6c8e-47e1-b7fb-3d88d17f62f9',16,'d0927694241842759be660760b008959','shares',-1,'2026-02-21 09:56:53','07221afd-ccd1-4ae1-a11b-cd0c08f035ea'),('2026-02-20 09:56:53.173496',NULL,'2026-02-20 09:56:53.186779',120,120,NULL,'345731ab-6042-49da-a80e-2d03f16b4408',15,'d0927694241842759be660760b008959','gigabytes',-1,'2026-02-21 09:56:53','07221afd-ccd1-4ae1-a11b-cd0c08f035ea'),('2026-02-20 09:56:56.273734',NULL,'2026-02-20 09:56:56.370611',121,121,'8c63ad2215564b2ba1a91046040dcfc1','d9c4b26d-2dff-4a3d-9373-1a46c471b28d',26,'d345acb999b945ac8ca92ec3a0b92da6','snapshots',1,'2026-02-21 09:56:56',NULL),('2026-02-20 09:56:56.280038',NULL,'2026-02-20 09:56:56.370611',122,122,'8c63ad2215564b2ba1a91046040dcfc1','c3a10abc-b064-4df3-9cfb-aec98f3808f6',25,'d345acb999b945ac8ca92ec3a0b92da6','snapshot_gigabytes',1,'2026-02-21 09:56:56',NULL),('2026-02-20 09:56:56.298652',NULL,'2026-02-20 09:56:56.370611',123,123,NULL,'65e3d7ad-a244-450a-bd60-db85169bdc75',28,'d345acb999b945ac8ca92ec3a0b92da6','snapshots',1,'2026-02-21 09:56:56','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:56:56.306501',NULL,'2026-02-20 09:56:56.370611',124,124,NULL,'2789c387-f244-4dbf-9600-f256294096c0',27,'d345acb999b945ac8ca92ec3a0b92da6','snapshot_gigabytes',1,'2026-02-21 09:56:56','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:57:00.168642',NULL,'2026-02-20 09:57:00.183655',125,125,'8c63ad2215564b2ba1a91046040dcfc1','8832c506-da24-4829-8cb4-f2a3e0c03d49',26,'d345acb999b945ac8ca92ec3a0b92da6','snapshots',-1,'2026-02-21 09:57:00',NULL),('2026-02-20 09:57:00.169398',NULL,'2026-02-20 09:57:00.183655',126,126,'8c63ad2215564b2ba1a91046040dcfc1','5865e14d-a452-4b43-8df8-6d363c725d62',25,'d345acb999b945ac8ca92ec3a0b92da6','snapshot_gigabytes',-1,'2026-02-21 09:57:00',NULL),('2026-02-20 09:57:00.176164',NULL,'2026-02-20 09:57:00.183655',127,127,NULL,'e3f6656e-b9f8-4d66-9ef0-4cdd4a14e785',28,'d345acb999b945ac8ca92ec3a0b92da6','snapshots',-1,'2026-02-21 09:57:00','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:57:00.176949',NULL,'2026-02-20 09:57:00.183655',128,128,NULL,'fb54b718-9957-4e33-91b8-1f003d4bfe3d',27,'d345acb999b945ac8ca92ec3a0b92da6','snapshot_gigabytes',-1,'2026-02-21 09:57:00','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:57:03.361583',NULL,'2026-02-20 09:57:03.381470',129,129,'8c63ad2215564b2ba1a91046040dcfc1','66390f41-1de3-4578-9cec-7ff4fa34da11',26,'d345acb999b945ac8ca92ec3a0b92da6','snapshots',-1,'2026-02-21 09:57:03',NULL),('2026-02-20 09:57:03.362330',NULL,'2026-02-20 09:57:03.381470',130,130,'8c63ad2215564b2ba1a91046040dcfc1','f00ddb17-035c-4644-9458-098840701de9',25,'d345acb999b945ac8ca92ec3a0b92da6','snapshot_gigabytes',-1,'2026-02-21 09:57:03',NULL),('2026-02-20 09:57:03.370149',NULL,'2026-02-20 09:57:03.381470',131,131,NULL,'f7f0855f-9c1d-406a-b399-f199cb6d0215',28,'d345acb999b945ac8ca92ec3a0b92da6','snapshots',-1,'2026-02-21 09:57:03','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:57:03.371560',NULL,'2026-02-20 09:57:03.381470',132,132,NULL,'ce558209-5bfb-4199-bb17-617ed79ff849',27,'d345acb999b945ac8ca92ec3a0b92da6','snapshot_gigabytes',-1,'2026-02-21 09:57:03','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:57:05.820928',NULL,'2026-02-20 09:57:05.849887',133,133,'8b934adab96c450395aa1542e65e5970','0e73e977-12bc-491e-8db3-f6b995659bc0',29,'4c23134629034c99a32e1e53486719c7','shares',1,'2026-02-21 09:57:05',NULL),('2026-02-20 09:57:05.821992',NULL,'2026-02-20 09:57:05.849887',134,134,'8b934adab96c450395aa1542e65e5970','fb9345fe-e888-4fdf-972b-b433e7563965',30,'4c23134629034c99a32e1e53486719c7','gigabytes',1,'2026-02-21 09:57:05',NULL),('2026-02-20 09:57:05.832003',NULL,'2026-02-20 09:57:05.849887',135,135,NULL,'a3e39c7b-d4bb-4b17-be52-32aa7f49c2a6',31,'4c23134629034c99a32e1e53486719c7','shares',1,'2026-02-21 09:57:05','ca78ee45-db85-4fcb-9d36-41f7381cabf1'),('2026-02-20 09:57:05.832975',NULL,'2026-02-20 09:57:05.849887',136,136,NULL,'09cb12a6-b1d5-47e7-b9d5-0da0727778ee',32,'4c23134629034c99a32e1e53486719c7','gigabytes',1,'2026-02-21 09:57:05','ca78ee45-db85-4fcb-9d36-41f7381cabf1'),('2026-02-20 09:57:06.572009',NULL,'2026-02-20 09:57:06.592878',137,137,'8c63ad2215564b2ba1a91046040dcfc1','7cda3b00-1941-4618-8d3f-8d2d889c5504',26,'d345acb999b945ac8ca92ec3a0b92da6','snapshots',-1,'2026-02-21 09:57:06',NULL),('2026-02-20 09:57:06.572777',NULL,'2026-02-20 09:57:06.592878',138,138,'8c63ad2215564b2ba1a91046040dcfc1','3543e248-3b5c-4f98-b511-a2f09236a5cc',25,'d345acb999b945ac8ca92ec3a0b92da6','snapshot_gigabytes',-1,'2026-02-21 09:57:06',NULL),('2026-02-20 09:57:06.578981',NULL,'2026-02-20 09:57:06.592878',139,139,NULL,'aef75601-d3ab-4329-aaca-9784244738c1',28,'d345acb999b945ac8ca92ec3a0b92da6','snapshots',-1,'2026-02-21 09:57:06','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:57:06.579621',NULL,'2026-02-20 09:57:06.592878',140,140,NULL,'73a33f0d-db37-4f6e-a65d-ed47e78fce80',27,'d345acb999b945ac8ca92ec3a0b92da6','snapshot_gigabytes',-1,'2026-02-21 09:57:06','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:57:07.271482',NULL,'2026-02-20 09:57:07.324663',141,141,'006a0e8f7e054ecc87e89aeaefd897ea','9234dec3-b302-4751-aad8-4a06d56f05e8',34,'1401fb23701440858ed7175cc4dba63b','shares',1,'2026-02-21 09:57:07',NULL),('2026-02-20 09:57:07.273288',NULL,'2026-02-20 09:57:07.324663',142,142,'006a0e8f7e054ecc87e89aeaefd897ea','6474fd49-c71f-4904-8020-c55b48dc7804',33,'1401fb23701440858ed7175cc4dba63b','gigabytes',1,'2026-02-21 09:57:07',NULL),('2026-02-20 09:57:07.281619',NULL,'2026-02-20 09:57:07.324663',143,143,NULL,'e4068df7-cb32-4d2c-b3af-eb14e4ff94ee',36,'1401fb23701440858ed7175cc4dba63b','shares',1,'2026-02-21 09:57:07','2c21b407-dddf-4b58-9b9f-aa5427d91232'),('2026-02-20 09:57:07.282641',NULL,'2026-02-20 09:57:07.324663',144,144,NULL,'61a80d9e-7012-4349-9319-d941330d71ec',35,'1401fb23701440858ed7175cc4dba63b','gigabytes',1,'2026-02-21 09:57:07','2c21b407-dddf-4b58-9b9f-aa5427d91232'),('2026-02-20 09:57:09.126414',NULL,'2026-02-20 09:57:09.215299',145,145,'8b934adab96c450395aa1542e65e5970','9917139e-cc4b-42b8-b002-84d69b68cbb5',37,'4c23134629034c99a32e1e53486719c7','snapshots',1,'2026-02-21 09:57:09',NULL),('2026-02-20 09:57:09.127799',NULL,'2026-02-20 09:57:09.215299',146,146,'8b934adab96c450395aa1542e65e5970','d7a72620-e85c-49a4-9629-41dc5d69b76a',38,'4c23134629034c99a32e1e53486719c7','snapshot_gigabytes',1,'2026-02-21 09:57:09',NULL),('2026-02-20 09:57:09.141831',NULL,'2026-02-20 09:57:09.215299',147,147,NULL,'00849dce-a0d2-473e-86dd-2239fb05bb62',39,'4c23134629034c99a32e1e53486719c7','snapshots',1,'2026-02-21 09:57:09','ca78ee45-db85-4fcb-9d36-41f7381cabf1'),('2026-02-20 09:57:09.143353',NULL,'2026-02-20 09:57:09.215299',148,148,NULL,'06aeef84-00c3-48ca-ade6-c06cc330be59',40,'4c23134629034c99a32e1e53486719c7','snapshot_gigabytes',1,'2026-02-21 09:57:09','ca78ee45-db85-4fcb-9d36-41f7381cabf1'),('2026-02-20 09:57:09.699421',NULL,'2026-02-20 09:57:09.717970',149,149,'8c63ad2215564b2ba1a91046040dcfc1','70db8edf-be09-49ff-bf47-f2c2b473f585',26,'d345acb999b945ac8ca92ec3a0b92da6','snapshots',-1,'2026-02-21 09:57:09',NULL),('2026-02-20 09:57:09.700306',NULL,'2026-02-20 09:57:09.717970',150,150,'8c63ad2215564b2ba1a91046040dcfc1','f15f0bca-ed86-45c4-ba6a-3b88b3430247',25,'d345acb999b945ac8ca92ec3a0b92da6','snapshot_gigabytes',-1,'2026-02-21 09:57:09',NULL),('2026-02-20 09:57:09.705366',NULL,'2026-02-20 09:57:09.717970',151,151,NULL,'9f6bdf27-0c1f-4010-bcba-df93e250010a',28,'d345acb999b945ac8ca92ec3a0b92da6','snapshots',-1,'2026-02-21 09:57:09','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:57:09.706218',NULL,'2026-02-20 09:57:09.717970',152,152,NULL,'1e184760-a637-43f0-baab-a8c57304473a',27,'d345acb999b945ac8ca92ec3a0b92da6','snapshot_gigabytes',-1,'2026-02-21 09:57:09','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:57:12.927503',NULL,'2026-02-20 09:57:12.949142',153,153,'8c63ad2215564b2ba1a91046040dcfc1','98d92086-3b40-4c00-811e-f7227d8e3da1',26,'d345acb999b945ac8ca92ec3a0b92da6','snapshots',-1,'2026-02-21 09:57:12',NULL),('2026-02-20 09:57:12.928171',NULL,'2026-02-20 09:57:12.949142',154,154,'8c63ad2215564b2ba1a91046040dcfc1','66cd242f-52c1-42c9-9a19-3a55b8063a75',25,'d345acb999b945ac8ca92ec3a0b92da6','snapshot_gigabytes',-1,'2026-02-21 09:57:12',NULL),('2026-02-20 09:57:12.935158',NULL,'2026-02-20 09:57:12.949142',155,155,NULL,'82b82c9f-8733-4281-a824-adddc6d1754b',28,'d345acb999b945ac8ca92ec3a0b92da6','snapshots',-1,'2026-02-21 09:57:12','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:57:12.937747',NULL,'2026-02-20 09:57:12.949142',156,156,NULL,'4c22e779-05a9-4448-bc8b-0d0f26c7c9fe',27,'d345acb999b945ac8ca92ec3a0b92da6','snapshot_gigabytes',-1,'2026-02-21 09:57:12','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:57:13.222612',NULL,'2026-02-20 09:57:13.261004',157,157,'8b934adab96c450395aa1542e65e5970','a8ba6beb-d749-43f4-a2c6-401af3f9eea0',37,'4c23134629034c99a32e1e53486719c7','snapshots',-1,'2026-02-21 09:57:13',NULL),('2026-02-20 09:57:13.223254',NULL,'2026-02-20 09:57:13.261004',158,158,'8b934adab96c450395aa1542e65e5970','5c75bd18-cf55-4f72-89ed-8b906440d3e9',38,'4c23134629034c99a32e1e53486719c7','snapshot_gigabytes',-1,'2026-02-21 09:57:13',NULL),('2026-02-20 09:57:13.235615',NULL,'2026-02-20 09:57:13.261004',159,159,NULL,'5ab2a125-4f9a-4b8d-a522-ed0a6047706e',39,'4c23134629034c99a32e1e53486719c7','snapshots',-1,'2026-02-21 09:57:13','ca78ee45-db85-4fcb-9d36-41f7381cabf1'),('2026-02-20 09:57:13.247468',NULL,'2026-02-20 09:57:13.261004',160,160,NULL,'6810d14b-56c0-43bf-bce2-a7630196b663',40,'4c23134629034c99a32e1e53486719c7','snapshot_gigabytes',-1,'2026-02-21 09:57:13','ca78ee45-db85-4fcb-9d36-41f7381cabf1'),('2026-02-20 09:57:16.162284',NULL,'2026-02-20 09:57:16.177948',161,161,'8c63ad2215564b2ba1a91046040dcfc1','7154694e-3148-4c88-86c6-357374fd28dd',22,'d345acb999b945ac8ca92ec3a0b92da6','shares',-1,'2026-02-21 09:57:16',NULL),('2026-02-20 09:57:16.163203',NULL,'2026-02-20 09:57:16.177948',162,162,'8c63ad2215564b2ba1a91046040dcfc1','36873dd7-6943-4659-89c4-6bdd6d24c31e',21,'d345acb999b945ac8ca92ec3a0b92da6','gigabytes',-1,'2026-02-21 09:57:16',NULL),('2026-02-20 09:57:16.168962',NULL,'2026-02-20 09:57:16.177948',163,163,NULL,'2ad3cf03-7cdc-4881-a493-9913bb91db52',24,'d345acb999b945ac8ca92ec3a0b92da6','shares',-1,'2026-02-21 09:57:16','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:57:16.169912',NULL,'2026-02-20 09:57:16.177948',164,164,NULL,'c4bd5bb2-5be5-439f-ae4e-bd2a39f905f9',23,'d345acb999b945ac8ca92ec3a0b92da6','gigabytes',-1,'2026-02-21 09:57:16','0ac8f3a2-38bd-4ad3-9af4-6101366866f0'),('2026-02-20 09:57:16.496518',NULL,'2026-02-20 09:57:16.522396',165,165,'8b934adab96c450395aa1542e65e5970','7668e9cd-e5c0-4345-a51e-74d9e565fba6',29,'4c23134629034c99a32e1e53486719c7','shares',-1,'2026-02-21 09:57:16',NULL),('2026-02-20 09:57:16.498163',NULL,'2026-02-20 09:57:16.522396',166,166,'8b934adab96c450395aa1542e65e5970','823014df-90de-43f9-92c4-074e46e6fd7b',30,'4c23134629034c99a32e1e53486719c7','gigabytes',-1,'2026-02-21 09:57:16',NULL),('2026-02-20 09:57:16.510421',NULL,'2026-02-20 09:57:16.522396',167,167,NULL,'2963fe05-7676-47cd-bb45-b009a3d9cbe1',31,'4c23134629034c99a32e1e53486719c7','shares',-1,'2026-02-21 09:57:16','ca78ee45-db85-4fcb-9d36-41f7381cabf1'),('2026-02-20 09:57:16.513833',NULL,'2026-02-20 09:57:16.522396',168,168,NULL,'230144eb-7037-45e7-97b9-a44d85015031',32,'4c23134629034c99a32e1e53486719c7','gigabytes',-1,'2026-02-21 09:57:16','ca78ee45-db85-4fcb-9d36-41f7381cabf1'),('2026-02-20 09:57:29.421219',NULL,'2026-02-20 09:57:29.437977',169,169,'006a0e8f7e054ecc87e89aeaefd897ea','2599c4ce-4d38-4c1c-b3ef-464149751e63',34,'1401fb23701440858ed7175cc4dba63b','shares',-1,'2026-02-21 09:57:29',NULL),('2026-02-20 09:57:29.422058',NULL,'2026-02-20 09:57:29.437977',170,170,'006a0e8f7e054ecc87e89aeaefd897ea','bf3a3ee7-13d4-4e5e-a86b-9e505d1440d2',33,'1401fb23701440858ed7175cc4dba63b','gigabytes',-1,'2026-02-21 09:57:29',NULL),('2026-02-20 09:57:29.427837',NULL,'2026-02-20 09:57:29.437977',171,171,NULL,'b917a093-1ff0-49f6-8749-ef9bc8b81ff3',36,'1401fb23701440858ed7175cc4dba63b','shares',-1,'2026-02-21 09:57:29','2c21b407-dddf-4b58-9b9f-aa5427d91232'),('2026-02-20 09:57:29.428608',NULL,'2026-02-20 09:57:29.437977',172,172,NULL,'90463b1a-388e-4b26-862c-c40c4898699d',35,'1401fb23701440858ed7175cc4dba63b','gigabytes',-1,'2026-02-21 09:57:29','2c21b407-dddf-4b58-9b9f-aa5427d91232'),('2026-02-20 09:57:30.713991',NULL,'2026-02-20 09:57:30.778925',173,173,'68596db4321d412fa84a0b3a4888496c','7f68b48e-35c2-4fd0-8c8d-604709e21920',41,'208565eda0ab416e8a4d0cab3045c853','share_networks',1,'2026-02-21 09:57:30',NULL),('2026-02-20 09:57:31.150557',NULL,'2026-02-20 09:57:31.205414',174,174,'8b5bbabe99d84f568cfed466d4ea2347','ab1ddf17-cfab-496e-80da-ec559e490963',42,'a7fd4740c8af42eda6e38d9605c14b06','share_networks',1,'2026-02-21 09:57:31',NULL),('2026-02-20 09:57:32.999916',NULL,'2026-02-20 09:57:33.010001',175,175,'68596db4321d412fa84a0b3a4888496c','0fd88b4f-4e68-4f80-96f2-a49aef9b06b7',41,'208565eda0ab416e8a4d0cab3045c853','share_networks',-1,'2026-02-21 09:57:32',NULL),('2026-02-20 09:57:49.107536',NULL,'2026-02-20 09:57:49.171091',176,176,'46d2da43b69c4228bbe4bc911be273b9','6141f0ce-2221-49d9-bf35-5ca7c787c3fa',43,'703953f368c84a05a279629aa7704503','share_networks',1,'2026-02-21 09:57:49',NULL),('2026-02-20 09:57:50.191990',NULL,'2026-02-20 09:57:50.238123',177,177,'46d2da43b69c4228bbe4bc911be273b9','e071e9c1-48e0-4486-8825-a84d69807872',43,'703953f368c84a05a279629aa7704503','share_networks',1,'2026-02-21 09:57:50',NULL),('2026-02-20 09:57:50.641869',NULL,'2026-02-20 09:57:50.647027',178,178,'46d2da43b69c4228bbe4bc911be273b9','6459b5d5-67a0-425e-9083-1b00ffdb31b5',43,'703953f368c84a05a279629aa7704503','share_networks',-1,'2026-02-21 09:57:50',NULL),('2026-02-20 09:57:50.716398',NULL,'2026-02-20 09:57:50.749028',179,179,'46d2da43b69c4228bbe4bc911be273b9','9f118f56-588e-4cc6-bb3b-b19ed94bcbe8',43,'703953f368c84a05a279629aa7704503','share_networks',1,'2026-02-21 09:57:50',NULL),('2026-02-20 09:57:50.880010',NULL,'2026-02-20 09:57:50.930672',180,180,'bf98d88b1c84473e962748cb9ed9824a','0c7a16d6-c59a-4ed6-9ca1-33676d25c854',44,'3c38c47b6b7b4f078e218bbefefce029','shares',1,'2026-02-21 09:57:50',NULL),('2026-02-20 09:57:50.881683',NULL,'2026-02-20 09:57:50.930672',181,181,'bf98d88b1c84473e962748cb9ed9824a','406da037-7d24-476b-a103-97a25db33b7e',45,'3c38c47b6b7b4f078e218bbefefce029','gigabytes',1,'2026-02-21 09:57:50',NULL),('2026-02-20 09:57:50.895482',NULL,'2026-02-20 09:57:50.930672',182,182,NULL,'56e7267d-790c-46cf-850a-dc4238aead86',46,'3c38c47b6b7b4f078e218bbefefce029','shares',1,'2026-02-21 09:57:50','83d90b28-64dc-44f1-836d-a413c5e7256b'),('2026-02-20 09:57:50.897648',NULL,'2026-02-20 09:57:50.930672',183,183,NULL,'2c36ee28-2e9f-473b-adae-5c6a2a82e0eb',47,'3c38c47b6b7b4f078e218bbefefce029','gigabytes',1,'2026-02-21 09:57:50','83d90b28-64dc-44f1-836d-a413c5e7256b'),('2026-02-20 09:57:51.166605',NULL,'2026-02-20 09:57:51.171241',184,184,'46d2da43b69c4228bbe4bc911be273b9','9d37fc5e-9453-4458-a14f-89c7d515a9f9',43,'703953f368c84a05a279629aa7704503','share_networks',-1,'2026-02-21 09:57:51',NULL),('2026-02-20 09:57:51.652485',NULL,'2026-02-20 09:57:51.658975',185,185,'46d2da43b69c4228bbe4bc911be273b9','3f17f49c-1626-47f7-9e10-aac56aff8bd9',43,'703953f368c84a05a279629aa7704503','share_networks',-1,'2026-02-21 09:57:51',NULL),('2026-02-20 09:57:54.160938',NULL,'2026-02-20 09:57:54.193366',186,186,'bf98d88b1c84473e962748cb9ed9824a','86b78039-6150-4393-975e-4bf3d56384c5',44,'3c38c47b6b7b4f078e218bbefefce029','shares',1,'2026-02-21 09:57:54',NULL),('2026-02-20 09:57:54.162404',NULL,'2026-02-20 09:57:54.193366',187,187,'bf98d88b1c84473e962748cb9ed9824a','1a321357-74ba-41cc-8d10-46e6bafe7256',45,'3c38c47b6b7b4f078e218bbefefce029','gigabytes',1,'2026-02-21 09:57:54',NULL),('2026-02-20 09:57:54.170343',NULL,'2026-02-20 09:57:54.193366',188,188,NULL,'a5525839-8eae-4735-868a-f5d0d60b059f',46,'3c38c47b6b7b4f078e218bbefefce029','shares',1,'2026-02-21 09:57:54','83d90b28-64dc-44f1-836d-a413c5e7256b'),('2026-02-20 09:57:54.173140',NULL,'2026-02-20 09:57:54.193366',189,189,NULL,'9f99f6bb-971d-4d6b-b859-5db8122837aa',47,'3c38c47b6b7b4f078e218bbefefce029','gigabytes',1,'2026-02-21 09:57:54','83d90b28-64dc-44f1-836d-a413c5e7256b'),('2026-02-20 09:57:55.173555',NULL,'2026-02-20 09:57:55.219017',190,190,'b19c6d4492a04b7d98d2825a8842e8ff','daf4fd9e-5fed-4b4a-bcfb-bcb9185e8831',48,'2ac6bdba4377453b82e5badf03029d7c','shares',1,'2026-02-21 09:57:55',NULL),('2026-02-20 09:57:55.175319',NULL,'2026-02-20 09:57:55.219017',191,191,'b19c6d4492a04b7d98d2825a8842e8ff','a9394ead-7043-42de-a643-29c99540458f',49,'2ac6bdba4377453b82e5badf03029d7c','gigabytes',1,'2026-02-21 09:57:55',NULL),('2026-02-20 09:57:55.194021',NULL,'2026-02-20 09:57:55.219017',192,192,NULL,'9a96e6ce-3889-449d-8d10-4e7db4810dbe',50,'2ac6bdba4377453b82e5badf03029d7c','shares',1,'2026-02-21 09:57:55','99bf4958-7405-48ee-882f-6e517440dc3e'),('2026-02-20 09:57:55.196349',NULL,'2026-02-20 09:57:55.219017',193,193,NULL,'988427bf-f4b0-4653-b619-88e6f4ead8fa',51,'2ac6bdba4377453b82e5badf03029d7c','gigabytes',1,'2026-02-21 09:57:55','99bf4958-7405-48ee-882f-6e517440dc3e'),('2026-02-20 09:57:58.343302',NULL,'2026-02-20 09:57:58.362186',194,194,'bf98d88b1c84473e962748cb9ed9824a','dcc61fd4-926e-4d4f-b4dc-ebb7cd42f50f',44,'3c38c47b6b7b4f078e218bbefefce029','shares',-1,'2026-02-21 09:57:58',NULL),('2026-02-20 09:57:58.344353',NULL,'2026-02-20 09:57:58.362186',195,195,'bf98d88b1c84473e962748cb9ed9824a','b7d2c97c-fa6e-41f0-a8a5-748dbcc6fb70',45,'3c38c47b6b7b4f078e218bbefefce029','gigabytes',-1,'2026-02-21 09:57:58',NULL),('2026-02-20 09:57:58.352539',NULL,'2026-02-20 09:57:58.362186',196,196,NULL,'caf5c711-4c1d-48fb-913e-a4e9d4107545',46,'3c38c47b6b7b4f078e218bbefefce029','shares',-1,'2026-02-21 09:57:58','83d90b28-64dc-44f1-836d-a413c5e7256b'),('2026-02-20 09:57:58.353361',NULL,'2026-02-20 09:57:58.362186',197,197,NULL,'f618b070-b253-44c4-8d74-5b54248b88e5',47,'3c38c47b6b7b4f078e218bbefefce029','gigabytes',-1,'2026-02-21 09:57:58','83d90b28-64dc-44f1-836d-a413c5e7256b'),('2026-02-20 09:58:01.207954',NULL,'2026-02-20 09:58:01.288461',198,198,'bf98d88b1c84473e962748cb9ed9824a','29765dc0-3479-494a-a620-5aac29a03e56',44,'3c38c47b6b7b4f078e218bbefefce029','shares',1,'2026-02-21 09:58:01',NULL),('2026-02-20 09:58:01.210060',NULL,'2026-02-20 09:58:01.288461',199,199,'bf98d88b1c84473e962748cb9ed9824a','df277d74-afcd-462a-916a-64b77ed6f322',45,'3c38c47b6b7b4f078e218bbefefce029','gigabytes',1,'2026-02-21 09:58:01',NULL),('2026-02-20 09:58:01.218557',NULL,'2026-02-20 09:58:01.288461',200,200,NULL,'f901b3d1-c928-425c-83e7-ff458cff2c0f',46,'3c38c47b6b7b4f078e218bbefefce029','shares',1,'2026-02-21 09:58:01','83d90b28-64dc-44f1-836d-a413c5e7256b'),('2026-02-20 09:58:01.220329',NULL,'2026-02-20 09:58:01.288461',201,201,NULL,'733058e8-58df-4247-a675-b154fd86257e',47,'3c38c47b6b7b4f078e218bbefefce029','gigabytes',1,'2026-02-21 09:58:01','83d90b28-64dc-44f1-836d-a413c5e7256b'),('2026-02-20 09:58:01.973101',NULL,'2026-02-20 09:58:01.988990',202,202,'b19c6d4492a04b7d98d2825a8842e8ff','07c8d44c-25f3-4722-840d-1996e2ebe59f',48,'2ac6bdba4377453b82e5badf03029d7c','shares',-1,'2026-02-21 09:58:01',NULL),('2026-02-20 09:58:01.973952',NULL,'2026-02-20 09:58:01.988990',203,203,'b19c6d4492a04b7d98d2825a8842e8ff','7f827d07-3ccc-47fc-a427-b64b10860e43',49,'2ac6bdba4377453b82e5badf03029d7c','gigabytes',-1,'2026-02-21 09:58:01',NULL),('2026-02-20 09:58:01.980103',NULL,'2026-02-20 09:58:01.988990',204,204,NULL,'32c65447-9cdc-4a47-8fac-70ccb305594a',50,'2ac6bdba4377453b82e5badf03029d7c','shares',-1,'2026-02-21 09:58:01','99bf4958-7405-48ee-882f-6e517440dc3e'),('2026-02-20 09:58:01.981516',NULL,'2026-02-20 09:58:01.988990',205,205,NULL,'f4811c61-272a-4777-be4a-b9583111abff',51,'2ac6bdba4377453b82e5badf03029d7c','gigabytes',-1,'2026-02-21 09:58:01','99bf4958-7405-48ee-882f-6e517440dc3e'),('2026-02-20 09:58:03.139864',NULL,'2026-02-20 09:58:03.177947',206,206,'8c8cc44c38ca4b3ca339318554bae0a0','03feac65-e3ab-4cd8-addf-ec27338206d3',52,'4559942bc629438d88ae332098961d3f','shares',1,'2026-02-21 09:58:03',NULL),('2026-02-20 09:58:03.142074',NULL,'2026-02-20 09:58:03.177947',207,207,'8c8cc44c38ca4b3ca339318554bae0a0','c92e74d3-bb3a-4010-a20b-7a343f4c39db',53,'4559942bc629438d88ae332098961d3f','gigabytes',1,'2026-02-21 09:58:03',NULL),('2026-02-20 09:58:03.152460',NULL,'2026-02-20 09:58:03.177947',208,208,NULL,'55e84ec9-4dc6-4149-952d-f0ee532d327f',54,'4559942bc629438d88ae332098961d3f','shares',1,'2026-02-21 09:58:03','caf81e2c-fad7-42a6-ab00-06993d5936d5'),('2026-02-20 09:58:03.153642',NULL,'2026-02-20 09:58:03.177947',209,209,NULL,'8290c7e6-ab50-43fa-8d7f-9a0dbf4cee38',55,'4559942bc629438d88ae332098961d3f','gigabytes',1,'2026-02-21 09:58:03','caf81e2c-fad7-42a6-ab00-06993d5936d5'),('2026-02-20 09:58:05.553951',NULL,'2026-02-20 09:58:05.566503',210,210,'bf98d88b1c84473e962748cb9ed9824a','020fec9c-de74-4d75-80fb-933bbaafade8',44,'3c38c47b6b7b4f078e218bbefefce029','shares',-1,'2026-02-21 09:58:05',NULL),('2026-02-20 09:58:05.554901',NULL,'2026-02-20 09:58:05.566503',211,211,'bf98d88b1c84473e962748cb9ed9824a','41b3be78-da7f-4c89-b563-53a73b19be1c',45,'3c38c47b6b7b4f078e218bbefefce029','gigabytes',-1,'2026-02-21 09:58:05',NULL),('2026-02-20 09:58:05.559907',NULL,'2026-02-20 09:58:05.566503',212,212,NULL,'7c067e4e-4423-462f-87de-7f4ff8efa571',46,'3c38c47b6b7b4f078e218bbefefce029','shares',-1,'2026-02-21 09:58:05','83d90b28-64dc-44f1-836d-a413c5e7256b'),('2026-02-20 09:58:05.560669',NULL,'2026-02-20 09:58:05.566503',213,213,NULL,'2de23f34-bad2-426d-bcdb-bd3fd48bfc12',47,'3c38c47b6b7b4f078e218bbefefce029','gigabytes',-1,'2026-02-21 09:58:05','83d90b28-64dc-44f1-836d-a413c5e7256b'),('2026-02-20 09:58:08.501033',NULL,'2026-02-20 09:58:08.538747',214,214,'bf98d88b1c84473e962748cb9ed9824a','07361e0d-12f2-43be-a17a-ea5e85668b85',44,'3c38c47b6b7b4f078e218bbefefce029','shares',1,'2026-02-21 09:58:08',NULL),('2026-02-20 09:58:08.502966',NULL,'2026-02-20 09:58:08.538747',215,215,'bf98d88b1c84473e962748cb9ed9824a','feccfd2c-7070-4f1b-b083-ea1edd049896',45,'3c38c47b6b7b4f078e218bbefefce029','gigabytes',1,'2026-02-21 09:58:08',NULL),('2026-02-20 09:58:08.510441',NULL,'2026-02-20 09:58:08.538747',216,216,NULL,'6689a233-7a69-41f7-a36a-0e2e5034b72b',46,'3c38c47b6b7b4f078e218bbefefce029','shares',1,'2026-02-21 09:58:08','83d90b28-64dc-44f1-836d-a413c5e7256b'),('2026-02-20 09:58:08.511635',NULL,'2026-02-20 09:58:08.538747',217,217,NULL,'9576d7cd-eb7e-4a1b-9ac8-5758b61aaa03',47,'3c38c47b6b7b4f078e218bbefefce029','gigabytes',1,'2026-02-21 09:58:08','83d90b28-64dc-44f1-836d-a413c5e7256b'),('2026-02-20 09:58:09.554519',NULL,'2026-02-20 09:58:09.568270',218,218,'8c8cc44c38ca4b3ca339318554bae0a0','e14d00e5-c933-4a59-a860-8d82b780b02d',52,'4559942bc629438d88ae332098961d3f','shares',-1,'2026-02-21 09:58:09',NULL),('2026-02-20 09:58:09.555164',NULL,'2026-02-20 09:58:09.568270',219,219,'8c8cc44c38ca4b3ca339318554bae0a0','64dcceaf-c7d3-42c2-bb1f-b7484a044feb',53,'4559942bc629438d88ae332098961d3f','gigabytes',-1,'2026-02-21 09:58:09',NULL),('2026-02-20 09:58:09.559756',NULL,'2026-02-20 09:58:09.568270',220,220,NULL,'114412dc-6360-4a86-bfad-80362fbecd27',54,'4559942bc629438d88ae332098961d3f','shares',-1,'2026-02-21 09:58:09','caf81e2c-fad7-42a6-ab00-06993d5936d5'),('2026-02-20 09:58:09.560977',NULL,'2026-02-20 09:58:09.568270',221,221,NULL,'259d1416-d044-48d4-a094-450516b751c0',55,'4559942bc629438d88ae332098961d3f','gigabytes',-1,'2026-02-21 09:58:09','caf81e2c-fad7-42a6-ab00-06993d5936d5'),('2026-02-20 09:58:09.633397',NULL,'2026-02-20 09:58:09.661851',222,222,'8c8cc44c38ca4b3ca339318554bae0a0','7ca4969c-fc65-48b0-b6f0-3d69bb4b9f69',52,'4559942bc629438d88ae332098961d3f','shares',1,'2026-02-21 09:58:09',NULL),('2026-02-20 09:58:09.634444',NULL,'2026-02-20 09:58:09.661851',223,223,'8c8cc44c38ca4b3ca339318554bae0a0','001898a7-646b-47f8-8037-288a9429440e',53,'4559942bc629438d88ae332098961d3f','gigabytes',1,'2026-02-21 09:58:09',NULL),('2026-02-20 09:58:09.644004',NULL,'2026-02-20 09:58:09.661851',224,224,NULL,'e71061d6-ba1e-42b5-8a6b-c25047cdb99f',56,'4559942bc629438d88ae332098961d3f','shares',1,'2026-02-21 09:58:09','84db82ef-0262-4237-957b-0b0637bd9b8b'),('2026-02-20 09:58:09.644957',NULL,'2026-02-20 09:58:09.661851',225,225,NULL,'628baec5-dcd6-48a6-97ab-7cd6f9c80e20',57,'4559942bc629438d88ae332098961d3f','gigabytes',1,'2026-02-21 09:58:09','84db82ef-0262-4237-957b-0b0637bd9b8b'),('2026-02-20 09:58:12.234850',NULL,'2026-02-20 09:58:12.255986',226,226,'bf98d88b1c84473e962748cb9ed9824a','d62c17fc-c0eb-485a-b26e-0a92c8928de5',44,'3c38c47b6b7b4f078e218bbefefce029','shares',-1,'2026-02-21 09:58:12',NULL),('2026-02-20 09:58:12.235755',NULL,'2026-02-20 09:58:12.255986',227,227,'bf98d88b1c84473e962748cb9ed9824a','47d771ea-30b4-47bd-a9e6-94a18e087e2d',45,'3c38c47b6b7b4f078e218bbefefce029','gigabytes',-1,'2026-02-21 09:58:12',NULL),('2026-02-20 09:58:12.242302',NULL,'2026-02-20 09:58:12.255986',228,228,NULL,'d2022f2a-3c32-49fd-a9f9-5f232aec3aa5',46,'3c38c47b6b7b4f078e218bbefefce029','shares',-1,'2026-02-21 09:58:12','83d90b28-64dc-44f1-836d-a413c5e7256b'),('2026-02-20 09:58:12.243059',NULL,'2026-02-20 09:58:12.255986',229,229,NULL,'66552cda-c955-4f12-af6b-5fd9b45a5b33',47,'3c38c47b6b7b4f078e218bbefefce029','gigabytes',-1,'2026-02-21 09:58:12','83d90b28-64dc-44f1-836d-a413c5e7256b'),('2026-02-20 09:58:15.081503',NULL,'2026-02-20 09:58:15.110180',230,230,'bf98d88b1c84473e962748cb9ed9824a','07b16ef2-f1a1-436a-bfbd-95164a3edd3c',44,'3c38c47b6b7b4f078e218bbefefce029','shares',1,'2026-02-21 09:58:15',NULL),('2026-02-20 09:58:15.082591',NULL,'2026-02-20 09:58:15.110180',231,231,'bf98d88b1c84473e962748cb9ed9824a','307537ca-d810-4144-b01a-65489b2ca7ca',45,'3c38c47b6b7b4f078e218bbefefce029','gigabytes',1,'2026-02-21 09:58:15',NULL),('2026-02-20 09:58:15.089354',NULL,'2026-02-20 09:58:15.110180',232,232,NULL,'043babb3-43f4-4ee6-bf5f-a726eb564ab4',46,'3c38c47b6b7b4f078e218bbefefce029','shares',1,'2026-02-21 09:58:15','83d90b28-64dc-44f1-836d-a413c5e7256b'),('2026-02-20 09:58:15.090320',NULL,'2026-02-20 09:58:15.110180',233,233,NULL,'8dec973f-ae48-4df6-8633-fb8810455512',47,'3c38c47b6b7b4f078e218bbefefce029','gigabytes',1,'2026-02-21 09:58:15','83d90b28-64dc-44f1-836d-a413c5e7256b'),('2026-02-20 09:58:16.022511',NULL,'2026-02-20 09:58:16.037187',234,234,'8c8cc44c38ca4b3ca339318554bae0a0','b38c6dc6-4f1b-49bf-bbd2-fef3b9d9f30e',52,'4559942bc629438d88ae332098961d3f','shares',-1,'2026-02-21 09:58:16',NULL),('2026-02-20 09:58:16.023401',NULL,'2026-02-20 09:58:16.037187',235,235,'8c8cc44c38ca4b3ca339318554bae0a0','40ae000f-7a06-482d-96bf-40ae0450ad5d',53,'4559942bc629438d88ae332098961d3f','gigabytes',-1,'2026-02-21 09:58:16',NULL),('2026-02-20 09:58:16.028897',NULL,'2026-02-20 09:58:16.037187',236,236,NULL,'3100d37a-faad-45db-97b5-dee1fe9cd9ef',56,'4559942bc629438d88ae332098961d3f','shares',-1,'2026-02-21 09:58:16','84db82ef-0262-4237-957b-0b0637bd9b8b'),('2026-02-20 09:58:16.031029',NULL,'2026-02-20 09:58:16.037187',237,237,NULL,'7bbba5cd-89ae-4eda-8087-633dabf2e226',57,'4559942bc629438d88ae332098961d3f','gigabytes',-1,'2026-02-21 09:58:16','84db82ef-0262-4237-957b-0b0637bd9b8b'),('2026-02-20 09:58:16.138477',NULL,'2026-02-20 09:58:16.177023',238,238,'8c8cc44c38ca4b3ca339318554bae0a0','5619cd74-0b47-45e9-ad02-33c93be15648',52,'4559942bc629438d88ae332098961d3f','shares',1,'2026-02-21 09:58:16',NULL),('2026-02-20 09:58:16.139621',NULL,'2026-02-20 09:58:16.177023',239,239,'8c8cc44c38ca4b3ca339318554bae0a0','3e9c0a0f-1bb3-4235-a34c-7c2dfbb04bb2',53,'4559942bc629438d88ae332098961d3f','gigabytes',1,'2026-02-21 09:58:16',NULL),('2026-02-20 09:58:16.152306',NULL,'2026-02-20 09:58:16.177023',240,240,NULL,'4b8cd570-52d3-4beb-b573-12b7ebeb8253',58,'4559942bc629438d88ae332098961d3f','shares',1,'2026-02-21 09:58:16','7358cf7e-cc45-46b4-848f-f11edcebbc2a'),('2026-02-20 09:58:16.153466',NULL,'2026-02-20 09:58:16.177023',241,241,NULL,'ef6a6ed0-cfb5-492f-a8be-45c60b5843a7',59,'4559942bc629438d88ae332098961d3f','gigabytes',1,'2026-02-21 09:58:16','7358cf7e-cc45-46b4-848f-f11edcebbc2a'),('2026-02-20 09:58:19.014286',NULL,'2026-02-20 09:58:19.060664',242,242,'c744dea67e504ed8bbe87eb5b0c1fc1e','12346eb3-c28a-4236-accc-ca7b02f91bfd',61,'8e04bc360fa14db4a793bc5de7a0a299','shares',1,'2026-02-21 09:58:18',NULL),('2026-02-20 09:58:19.018582',NULL,'2026-02-20 09:58:19.060664',243,243,'c744dea67e504ed8bbe87eb5b0c1fc1e','9d0aa5cb-341e-495b-a797-1ac35b96556d',60,'8e04bc360fa14db4a793bc5de7a0a299','gigabytes',1,'2026-02-21 09:58:18',NULL),('2026-02-20 09:58:19.031375',NULL,'2026-02-20 09:58:19.060664',244,244,NULL,'977a4330-9017-4879-9516-34565df5ae85',63,'8e04bc360fa14db4a793bc5de7a0a299','shares',1,'2026-02-21 09:58:18','48a549b7-2e24-48b0-bf7b-3dffd39b684c'),('2026-02-20 09:58:19.036310',NULL,'2026-02-20 09:58:19.060664',245,245,NULL,'c14393ec-6e10-415f-a858-9e26391404f3',62,'8e04bc360fa14db4a793bc5de7a0a299','gigabytes',1,'2026-02-21 09:58:18','48a549b7-2e24-48b0-bf7b-3dffd39b684c'),('2026-02-20 09:58:19.406825',NULL,'2026-02-20 09:58:19.454838',246,246,'8c8cc44c38ca4b3ca339318554bae0a0','25608a1b-e8cd-44ff-b9de-c5cca862564c',52,'4559942bc629438d88ae332098961d3f','shares',1,'2026-02-21 09:58:19',NULL),('2026-02-20 09:58:19.413481',NULL,'2026-02-20 09:58:19.454838',247,247,'8c8cc44c38ca4b3ca339318554bae0a0','f25e45d8-a0c4-4ade-b932-4ea4b0f7a615',53,'4559942bc629438d88ae332098961d3f','gigabytes',1,'2026-02-21 09:58:19',NULL),('2026-02-20 09:58:19.432253',NULL,'2026-02-20 09:58:19.454838',248,248,NULL,'9e9c0392-569e-45ff-93be-1baa4bbbf7e2',65,'4559942bc629438d88ae332098961d3f','shares',1,'2026-02-21 09:58:19','45611395-059b-4ba1-84b0-96eaa8d790dd'),('2026-02-20 09:58:19.433804',NULL,'2026-02-20 09:58:19.454838',249,249,NULL,'c27fdb96-d084-4629-bbaa-d0225f8d530e',64,'4559942bc629438d88ae332098961d3f','gigabytes',1,'2026-02-21 09:58:19','45611395-059b-4ba1-84b0-96eaa8d790dd'),('2026-02-20 09:58:19.605179',NULL,'2026-02-20 09:58:19.616826',250,250,'bf98d88b1c84473e962748cb9ed9824a','03bf3765-7da9-4ddd-8786-4625257a10ec',44,'3c38c47b6b7b4f078e218bbefefce029','shares',-1,'2026-02-21 09:58:19',NULL),('2026-02-20 09:58:19.605867',NULL,'2026-02-20 09:58:19.616826',251,251,'bf98d88b1c84473e962748cb9ed9824a','66811587-886e-497c-bb7e-1e8b1bbbdee3',45,'3c38c47b6b7b4f078e218bbefefce029','gigabytes',-1,'2026-02-21 09:58:19',NULL),('2026-02-20 09:58:19.610526',NULL,'2026-02-20 09:58:19.616826',252,252,NULL,'d0251f6d-55b6-4d6a-8477-80dc157cbe49',46,'3c38c47b6b7b4f078e218bbefefce029','shares',-1,'2026-02-21 09:58:19','83d90b28-64dc-44f1-836d-a413c5e7256b'),('2026-02-20 09:58:19.611190',NULL,'2026-02-20 09:58:19.616826',253,253,NULL,'2c10e8ea-804b-4347-a3e4-cbf46ca6b173',47,'3c38c47b6b7b4f078e218bbefefce029','gigabytes',-1,'2026-02-21 09:58:19','83d90b28-64dc-44f1-836d-a413c5e7256b'),('2026-02-20 09:58:22.740421',NULL,'2026-02-20 09:58:22.755947',254,254,'8c8cc44c38ca4b3ca339318554bae0a0','f1044e67-2b26-4a7c-8adc-40485ba8af98',52,'4559942bc629438d88ae332098961d3f','shares',-1,'2026-02-21 09:58:22',NULL),('2026-02-20 09:58:22.741401',NULL,'2026-02-20 09:58:22.755947',255,255,'8c8cc44c38ca4b3ca339318554bae0a0','1201a592-fe0e-4006-903d-150d2b701ed7',53,'4559942bc629438d88ae332098961d3f','gigabytes',-1,'2026-02-21 09:58:22',NULL),('2026-02-20 09:58:22.748839',NULL,'2026-02-20 09:58:22.755947',256,256,NULL,'2210a0fb-e506-4ba2-ba9f-7257c43b0c9e',65,'4559942bc629438d88ae332098961d3f','shares',-1,'2026-02-21 09:58:22','45611395-059b-4ba1-84b0-96eaa8d790dd'),('2026-02-20 09:58:22.749510',NULL,'2026-02-20 09:58:22.755947',257,257,NULL,'f1c88b75-8ef4-4663-ba9c-e981d09a0bce',64,'4559942bc629438d88ae332098961d3f','gigabytes',-1,'2026-02-21 09:58:22','45611395-059b-4ba1-84b0-96eaa8d790dd'),('2026-02-20 09:58:22.952752',NULL,'2026-02-20 09:58:22.983263',258,258,'8c8cc44c38ca4b3ca339318554bae0a0','1de76807-234f-463b-91c1-66cfbaea8df6',52,'4559942bc629438d88ae332098961d3f','shares',-1,'2026-02-21 09:58:22',NULL),('2026-02-20 09:58:22.953509',NULL,'2026-02-20 09:58:22.983263',259,259,'8c8cc44c38ca4b3ca339318554bae0a0','b6ede19a-0828-4def-8a7a-42ea6dd06328',53,'4559942bc629438d88ae332098961d3f','gigabytes',-1,'2026-02-21 09:58:22',NULL),('2026-02-20 09:58:22.971328',NULL,'2026-02-20 09:58:22.983263',260,260,NULL,'2ecc6f7b-5744-4074-89c0-49e9956f8ab5',58,'4559942bc629438d88ae332098961d3f','shares',-1,'2026-02-21 09:58:22','7358cf7e-cc45-46b4-848f-f11edcebbc2a'),('2026-02-20 09:58:22.973222',NULL,'2026-02-20 09:58:22.983263',261,261,NULL,'fff3b211-8d49-4b96-a2aa-1290dd81ab32',59,'4559942bc629438d88ae332098961d3f','gigabytes',-1,'2026-02-21 09:58:22','7358cf7e-cc45-46b4-848f-f11edcebbc2a'),('2026-02-20 09:58:23.079532',NULL,'2026-02-20 09:58:23.132351',262,262,'8c8cc44c38ca4b3ca339318554bae0a0','4436e10c-dfa4-4924-a842-2a8ce0e0311d',52,'4559942bc629438d88ae332098961d3f','shares',1,'2026-02-21 09:58:23',NULL),('2026-02-20 09:58:23.088009',NULL,'2026-02-20 09:58:23.132351',263,263,'8c8cc44c38ca4b3ca339318554bae0a0','29ff0550-3c5b-4f8d-b3d4-75a6bcc7b08f',53,'4559942bc629438d88ae332098961d3f','gigabytes',1,'2026-02-21 09:58:23',NULL),('2026-02-20 09:58:23.108363',NULL,'2026-02-20 09:58:23.132351',264,264,NULL,'fefb8347-c992-4d30-b1ab-81a8e658b2f1',66,'4559942bc629438d88ae332098961d3f','shares',1,'2026-02-21 09:58:23','03ec41f3-6744-4b9a-8b31-a753f421c19c'),('2026-02-20 09:58:23.109878',NULL,'2026-02-20 09:58:23.132351',265,265,NULL,'63c18172-c7db-4961-9756-231f769427f3',67,'4559942bc629438d88ae332098961d3f','gigabytes',1,'2026-02-21 09:58:23','03ec41f3-6744-4b9a-8b31-a753f421c19c'),('2026-02-20 09:58:23.292156',NULL,'2026-02-20 09:58:23.316752',266,266,'bf98d88b1c84473e962748cb9ed9824a','d057208b-0b5e-4175-b1e6-fcc42a205351',44,'3c38c47b6b7b4f078e218bbefefce029','shares',1,'2026-02-21 09:58:23',NULL),('2026-02-20 09:58:23.293283',NULL,'2026-02-20 09:58:23.316752',267,267,'bf98d88b1c84473e962748cb9ed9824a','d2c7f0e7-f0d3-4cd2-bb7f-85efe7afe0a4',45,'3c38c47b6b7b4f078e218bbefefce029','gigabytes',1,'2026-02-21 09:58:23',NULL),('2026-02-20 09:58:23.298866',NULL,'2026-02-20 09:58:23.316752',268,268,NULL,'d693949d-717f-43dc-a7d9-fb47bc5c7082',46,'3c38c47b6b7b4f078e218bbefefce029','shares',1,'2026-02-21 09:58:23','83d90b28-64dc-44f1-836d-a413c5e7256b'),('2026-02-20 09:58:23.299943',NULL,'2026-02-20 09:58:23.316752',269,269,NULL,'4365cb84-4b4f-4d43-89b4-76dbb7aa3017',47,'3c38c47b6b7b4f078e218bbefefce029','gigabytes',1,'2026-02-21 09:58:23','83d90b28-64dc-44f1-836d-a413c5e7256b'),('2026-02-20 09:58:26.341649',NULL,'2026-02-20 09:58:26.369759',270,270,'8c8cc44c38ca4b3ca339318554bae0a0','7e53af02-b4fa-47cf-930e-281541badd1b',52,'4559942bc629438d88ae332098961d3f','shares',1,'2026-02-21 09:58:26',NULL),('2026-02-20 09:58:26.342749',NULL,'2026-02-20 09:58:26.369759',271,271,'8c8cc44c38ca4b3ca339318554bae0a0','4ee87a12-fead-4dbc-a4b8-72d21d914915',53,'4559942bc629438d88ae332098961d3f','gigabytes',1,'2026-02-21 09:58:26',NULL),('2026-02-20 09:58:26.350610',NULL,'2026-02-20 09:58:26.369759',272,272,NULL,'cf66ef9c-621b-4105-8b5a-37c411089a6c',68,'4559942bc629438d88ae332098961d3f','shares',1,'2026-02-21 09:58:26','6cceb050-de15-4855-b44a-39794dc87a14'),('2026-02-20 09:58:26.351645',NULL,'2026-02-20 09:58:26.369759',273,273,NULL,'d038b84b-f096-4a5d-b299-e77e0ebc3e5a',69,'4559942bc629438d88ae332098961d3f','gigabytes',1,'2026-02-21 09:58:26','6cceb050-de15-4855-b44a-39794dc87a14'),('2026-02-20 09:58:27.973926',NULL,'2026-02-20 09:58:27.988721',274,274,'bf98d88b1c84473e962748cb9ed9824a','96be30f7-df06-4462-a3fc-e16151ceee50',44,'3c38c47b6b7b4f078e218bbefefce029','shares',-1,'2026-02-21 09:58:27',NULL),('2026-02-20 09:58:27.974615',NULL,'2026-02-20 09:58:27.988721',275,275,'bf98d88b1c84473e962748cb9ed9824a','cc2321e3-cc14-41c7-9bf4-d1774c3601e5',45,'3c38c47b6b7b4f078e218bbefefce029','gigabytes',-1,'2026-02-21 09:58:27',NULL),('2026-02-20 09:58:27.980411',NULL,'2026-02-20 09:58:27.988721',276,276,NULL,'242d074d-ee76-496b-9978-fc6753500edc',46,'3c38c47b6b7b4f078e218bbefefce029','shares',-1,'2026-02-21 09:58:27','83d90b28-64dc-44f1-836d-a413c5e7256b'),('2026-02-20 09:58:27.981324',NULL,'2026-02-20 09:58:27.988721',277,277,NULL,'625d5d80-0229-46f2-a4c1-dfdd6488a7e0',47,'3c38c47b6b7b4f078e218bbefefce029','gigabytes',-1,'2026-02-21 09:58:27','83d90b28-64dc-44f1-836d-a413c5e7256b'),('2026-02-20 09:58:29.567552',NULL,'2026-02-20 09:58:29.616988',278,278,'8c8cc44c38ca4b3ca339318554bae0a0','7110c965-3684-45cc-b777-1022e47ae0ab',52,'4559942bc629438d88ae332098961d3f','shares',1,'2026-02-21 09:58:29',NULL),('2026-02-20 09:58:29.570021',NULL,'2026-02-20 09:58:29.616988',279,279,'8c8cc44c38ca4b3ca339318554bae0a0','b60a5c76-5e28-4989-9ae9-74b677528916',53,'4559942bc629438d88ae332098961d3f','gigabytes',1,'2026-02-21 09:58:29',NULL),('2026-02-20 09:58:29.581605',NULL,'2026-02-20 09:58:29.616988',280,280,NULL,'e076fc92-2bf5-41de-a410-001f37c532cd',70,'4559942bc629438d88ae332098961d3f','shares',1,'2026-02-21 09:58:29','6fd361a9-526c-4faa-b39f-8a101200778d'),('2026-02-20 09:58:29.583957',NULL,'2026-02-20 09:58:29.616988',281,281,NULL,'9dba5a85-ca8b-4859-9239-e2c848eeaf5d',71,'4559942bc629438d88ae332098961d3f','gigabytes',1,'2026-02-21 09:58:29','6fd361a9-526c-4faa-b39f-8a101200778d'),('2026-02-20 09:58:32.852288',NULL,'2026-02-20 09:58:32.868695',282,282,'bf98d88b1c84473e962748cb9ed9824a','68cbb48b-b5d8-4727-827c-d5012d7786d2',44,'3c38c47b6b7b4f078e218bbefefce029','shares',-1,'2026-02-21 09:58:32',NULL),('2026-02-20 09:58:32.854310',NULL,'2026-02-20 09:58:32.868695',283,283,'bf98d88b1c84473e962748cb9ed9824a','7349273e-f653-4ba1-97f1-562b6ccc7785',45,'3c38c47b6b7b4f078e218bbefefce029','gigabytes',-1,'2026-02-21 09:58:32',NULL),('2026-02-20 09:58:32.859922',NULL,'2026-02-20 09:58:32.868695',284,284,NULL,'c685848d-f531-4cfe-aff4-66152ffa6623',46,'3c38c47b6b7b4f078e218bbefefce029','shares',-1,'2026-02-21 09:58:32','83d90b28-64dc-44f1-836d-a413c5e7256b'),('2026-02-20 09:58:32.860603',NULL,'2026-02-20 09:58:32.868695',285,285,NULL,'2ea70de8-b204-4319-82e5-702dbe8101a3',47,'3c38c47b6b7b4f078e218bbefefce029','gigabytes',-1,'2026-02-21 09:58:32','83d90b28-64dc-44f1-836d-a413c5e7256b'),('2026-02-20 09:58:32.927224',NULL,'2026-02-20 09:58:32.960937',286,286,'8c8cc44c38ca4b3ca339318554bae0a0','614d33c6-aebf-4b81-9944-0d945dce94b5',52,'4559942bc629438d88ae332098961d3f','shares',-1,'2026-02-21 09:58:32',NULL),('2026-02-20 09:58:32.927952',NULL,'2026-02-20 09:58:32.960937',287,287,'8c8cc44c38ca4b3ca339318554bae0a0','6bced994-0cd0-4644-b1fc-6483aa73f601',53,'4559942bc629438d88ae332098961d3f','gigabytes',-1,'2026-02-21 09:58:32',NULL),('2026-02-20 09:58:32.954068',NULL,'2026-02-20 09:58:32.960937',288,288,NULL,'4080cdf5-aad1-470e-b723-5da09cb6b775',70,'4559942bc629438d88ae332098961d3f','shares',-1,'2026-02-21 09:58:32','6fd361a9-526c-4faa-b39f-8a101200778d'),('2026-02-20 09:58:32.954643',NULL,'2026-02-20 09:58:32.960937',289,289,NULL,'6e02343b-c0c8-4e8a-9a28-b6433a9eb663',71,'4559942bc629438d88ae332098961d3f','gigabytes',-1,'2026-02-21 09:58:32','6fd361a9-526c-4faa-b39f-8a101200778d'),('2026-02-20 09:58:33.085659',NULL,'2026-02-20 09:58:33.097002',290,290,'8c8cc44c38ca4b3ca339318554bae0a0','d063623f-1ac1-4d65-ad2d-8a3b4867da50',52,'4559942bc629438d88ae332098961d3f','shares',-1,'2026-02-21 09:58:33',NULL),('2026-02-20 09:58:33.086303',NULL,'2026-02-20 09:58:33.097002',291,291,'8c8cc44c38ca4b3ca339318554bae0a0','4910e516-2575-410e-8ed2-c2ff5db4da74',53,'4559942bc629438d88ae332098961d3f','gigabytes',-1,'2026-02-21 09:58:33',NULL),('2026-02-20 09:58:33.091107',NULL,'2026-02-20 09:58:33.097002',292,292,NULL,'fb7e921a-94bb-4346-bfbb-878cd379b8df',68,'4559942bc629438d88ae332098961d3f','shares',-1,'2026-02-21 09:58:33','6cceb050-de15-4855-b44a-39794dc87a14'),('2026-02-20 09:58:33.091663',NULL,'2026-02-20 09:58:33.097002',293,293,NULL,'31325a1f-ee65-4364-83d3-97f798c70c7d',69,'4559942bc629438d88ae332098961d3f','gigabytes',-1,'2026-02-21 09:58:33','6cceb050-de15-4855-b44a-39794dc87a14'),('2026-02-20 09:58:33.282067',NULL,'2026-02-20 09:58:33.297622',294,294,'8c8cc44c38ca4b3ca339318554bae0a0','a6efff7a-9299-45bb-b0d4-5159d41926eb',52,'4559942bc629438d88ae332098961d3f','shares',-1,'2026-02-21 09:58:33',NULL),('2026-02-20 09:58:33.282961',NULL,'2026-02-20 09:58:33.297622',295,295,'8c8cc44c38ca4b3ca339318554bae0a0','8b214bf0-9a00-4cf4-8fac-4df6ef16e93c',53,'4559942bc629438d88ae332098961d3f','gigabytes',-1,'2026-02-21 09:58:33',NULL),('2026-02-20 09:58:33.289837',NULL,'2026-02-20 09:58:33.297622',296,296,NULL,'39a5d180-df62-44e7-9538-dd41aa221527',66,'4559942bc629438d88ae332098961d3f','shares',-1,'2026-02-21 09:58:33','03ec41f3-6744-4b9a-8b31-a753f421c19c'),('2026-02-20 09:58:33.290543',NULL,'2026-02-20 09:58:33.297622',297,297,NULL,'2e78b76b-d171-4d80-b838-b652b9632627',67,'4559942bc629438d88ae332098961d3f','gigabytes',-1,'2026-02-21 09:58:33','03ec41f3-6744-4b9a-8b31-a753f421c19c'),('2026-02-20 09:58:33.389935',NULL,'2026-02-20 09:58:33.428210',298,298,'8c8cc44c38ca4b3ca339318554bae0a0','e129f056-a07e-411f-8d5e-f53c78339aa0',52,'4559942bc629438d88ae332098961d3f','shares',1,'2026-02-21 09:58:33',NULL),('2026-02-20 09:58:33.391213',NULL,'2026-02-20 09:58:33.428210',299,299,'8c8cc44c38ca4b3ca339318554bae0a0','e4d31bd2-c0ca-4a1e-ac9e-ffed52aac920',53,'4559942bc629438d88ae332098961d3f','gigabytes',1,'2026-02-21 09:58:33',NULL),('2026-02-20 09:58:33.403521',NULL,'2026-02-20 09:58:33.428210',300,300,NULL,'71b9e2f8-540d-47f0-939d-f57f1b9c47bd',72,'4559942bc629438d88ae332098961d3f','shares',1,'2026-02-21 09:58:33','bc03df9c-9dee-4f87-8f49-45b33581c9b4'),('2026-02-20 09:58:33.405341',NULL,'2026-02-20 09:58:33.428210',301,301,NULL,'0e873a7f-ef2c-4603-8c66-81bd8c8abfa4',73,'4559942bc629438d88ae332098961d3f','gigabytes',1,'2026-02-21 09:58:33','bc03df9c-9dee-4f87-8f49-45b33581c9b4'),('2026-02-20 09:58:36.692454',NULL,'2026-02-20 09:58:36.752777',302,302,'8c8cc44c38ca4b3ca339318554bae0a0','716e7896-5663-4340-8cbf-59e311fa1d48',52,'4559942bc629438d88ae332098961d3f','shares',1,'2026-02-21 09:58:36',NULL),('2026-02-20 09:58:36.694287',NULL,'2026-02-20 09:58:36.752777',303,303,'8c8cc44c38ca4b3ca339318554bae0a0','f23fbb6a-c4ed-4287-9b47-c46b600d24a7',53,'4559942bc629438d88ae332098961d3f','gigabytes',1,'2026-02-21 09:58:36',NULL),('2026-02-20 09:58:36.719033',NULL,'2026-02-20 09:58:36.752777',304,304,NULL,'33ae7cdd-4c8d-4e35-897e-a2de34fd1ce6',75,'4559942bc629438d88ae332098961d3f','shares',1,'2026-02-21 09:58:36','6f3aaea1-fcb8-4aef-849e-fe826efad48b'),('2026-02-20 09:58:36.721761',NULL,'2026-02-20 09:58:36.752777',305,305,NULL,'8d753890-6792-4678-b990-cd283f2be5bd',74,'4559942bc629438d88ae332098961d3f','gigabytes',1,'2026-02-21 09:58:36','6f3aaea1-fcb8-4aef-849e-fe826efad48b'),('2026-02-20 09:58:40.219345',NULL,'2026-02-20 09:58:40.242174',306,306,'8c8cc44c38ca4b3ca339318554bae0a0','ba4206f3-6730-424d-a17e-f9f658ef2339',52,'4559942bc629438d88ae332098961d3f','shares',-1,'2026-02-21 09:58:40',NULL),('2026-02-20 09:58:40.220271',NULL,'2026-02-20 09:58:40.242174',307,307,'8c8cc44c38ca4b3ca339318554bae0a0','ecba0c2a-10bb-48f7-af20-e418c7d230c8',53,'4559942bc629438d88ae332098961d3f','gigabytes',-1,'2026-02-21 09:58:40',NULL),('2026-02-20 09:58:40.232761',NULL,'2026-02-20 09:58:40.242174',308,308,NULL,'8df141ae-0e4f-41cf-a1bd-5a543bac1fe7',75,'4559942bc629438d88ae332098961d3f','shares',-1,'2026-02-21 09:58:40','6f3aaea1-fcb8-4aef-849e-fe826efad48b'),('2026-02-20 09:58:40.234009',NULL,'2026-02-20 09:58:40.242174',309,309,NULL,'3ce2b98c-ef0c-4139-ac7f-4bf19ce855a0',74,'4559942bc629438d88ae332098961d3f','gigabytes',-1,'2026-02-21 09:58:40','6f3aaea1-fcb8-4aef-849e-fe826efad48b'),('2026-02-20 09:58:40.499015',NULL,'2026-02-20 09:58:40.523622',310,310,'8c8cc44c38ca4b3ca339318554bae0a0','f12763e3-351d-4223-a974-33d5334b6e61',52,'4559942bc629438d88ae332098961d3f','shares',-1,'2026-02-21 09:58:40',NULL),('2026-02-20 09:58:40.500397',NULL,'2026-02-20 09:58:40.523622',311,311,'8c8cc44c38ca4b3ca339318554bae0a0','5f632046-32e9-4937-a03c-130927861106',53,'4559942bc629438d88ae332098961d3f','gigabytes',-1,'2026-02-21 09:58:40',NULL),('2026-02-20 09:58:40.509270',NULL,'2026-02-20 09:58:40.523622',312,312,NULL,'98616f46-6ac4-4495-abab-73db60bba0ea',72,'4559942bc629438d88ae332098961d3f','shares',-1,'2026-02-21 09:58:40','bc03df9c-9dee-4f87-8f49-45b33581c9b4'),('2026-02-20 09:58:40.510403',NULL,'2026-02-20 09:58:40.523622',313,313,NULL,'5ecf25c8-b58f-4c78-97e4-cacea2752904',73,'4559942bc629438d88ae332098961d3f','gigabytes',-1,'2026-02-21 09:58:40','bc03df9c-9dee-4f87-8f49-45b33581c9b4'),('2026-02-20 09:58:40.617530',NULL,'2026-02-20 09:58:40.646005',314,314,'8c8cc44c38ca4b3ca339318554bae0a0','d12184bd-b995-4112-b68f-999179228242',52,'4559942bc629438d88ae332098961d3f','shares',1,'2026-02-21 09:58:40',NULL),('2026-02-20 09:58:40.618645',NULL,'2026-02-20 09:58:40.646005',315,315,'8c8cc44c38ca4b3ca339318554bae0a0','8d1239d4-80f0-477c-9fcd-e936aefc9fe0',53,'4559942bc629438d88ae332098961d3f','gigabytes',1,'2026-02-21 09:58:40',NULL),('2026-02-20 09:58:40.628587',NULL,'2026-02-20 09:58:40.646005',316,316,NULL,'06af09ce-2bc8-4d27-a009-22daa255694c',77,'4559942bc629438d88ae332098961d3f','shares',1,'2026-02-21 09:58:40','d4430d83-c86e-48fb-9233-05b8eeb071b8'),('2026-02-20 09:58:40.629613',NULL,'2026-02-20 09:58:40.646005',317,317,NULL,'f783c144-b250-4819-8728-ae3185abcad7',76,'4559942bc629438d88ae332098961d3f','gigabytes',1,'2026-02-21 09:58:40','d4430d83-c86e-48fb-9233-05b8eeb071b8'),('2026-02-20 09:58:46.968649',NULL,'2026-02-20 09:58:46.984957',318,318,'8c8cc44c38ca4b3ca339318554bae0a0','249c7274-8bc8-41c3-8dff-f38e52ec88e6',52,'4559942bc629438d88ae332098961d3f','shares',-1,'2026-02-21 09:58:46',NULL),('2026-02-20 09:58:46.969417',NULL,'2026-02-20 09:58:46.984957',319,319,'8c8cc44c38ca4b3ca339318554bae0a0','9bd84152-87ad-4470-b2a6-e7f2a580cd17',53,'4559942bc629438d88ae332098961d3f','gigabytes',-1,'2026-02-21 09:58:46',NULL),('2026-02-20 09:58:46.977409',NULL,'2026-02-20 09:58:46.984957',320,320,NULL,'f1a6a153-35e1-48d7-9616-105573312bf4',77,'4559942bc629438d88ae332098961d3f','shares',-1,'2026-02-21 09:58:46','d4430d83-c86e-48fb-9233-05b8eeb071b8'),('2026-02-20 09:58:46.978365',NULL,'2026-02-20 09:58:46.984957',321,321,NULL,'2e585eb8-7bb6-4f09-be5f-9550513ab23e',76,'4559942bc629438d88ae332098961d3f','gigabytes',-1,'2026-02-21 09:58:46','d4430d83-c86e-48fb-9233-05b8eeb071b8'),('2026-02-20 09:58:52.327137',NULL,'2026-02-20 09:58:52.398586',322,322,'2a38b24f215a478db5cd7da521f1b21b','b2ad4407-301b-4eec-94c8-0645ffc87b96',78,'b466c6b08b5e44ff9593bfa11ccdf0a9','shares',1,'2026-02-21 09:58:52',NULL),('2026-02-20 09:58:52.328932',NULL,'2026-02-20 09:58:52.398586',323,323,'2a38b24f215a478db5cd7da521f1b21b','3eaf3ff0-7e39-47d2-b540-990f4357ca03',79,'b466c6b08b5e44ff9593bfa11ccdf0a9','gigabytes',1,'2026-02-21 09:58:52',NULL),('2026-02-20 09:58:52.341198',NULL,'2026-02-20 09:58:52.398586',324,324,NULL,'8471c4b3-bf65-4bfb-ae5d-fbec148517fc',80,'b466c6b08b5e44ff9593bfa11ccdf0a9','shares',1,'2026-02-21 09:58:52','d75db691-7965-4145-9170-9a4265a3b1f3'),('2026-02-20 09:58:52.342189',NULL,'2026-02-20 09:58:52.398586',325,325,NULL,'fed5ecc1-9fc3-4879-81a2-26e5106d7609',81,'b466c6b08b5e44ff9593bfa11ccdf0a9','gigabytes',1,'2026-02-21 09:58:52','d75db691-7965-4145-9170-9a4265a3b1f3'),('2026-02-20 09:58:56.010370',NULL,'2026-02-20 09:58:56.061854',326,326,'658ecc001e85402995533129aa177bc3','6b7d89e3-86aa-4382-93d8-7b258a41e381',82,'4f1b3c403fb148c692c17867833e30a7','shares',1,'2026-02-21 09:58:55',NULL),('2026-02-20 09:58:56.011753',NULL,'2026-02-20 09:58:56.061854',327,327,'658ecc001e85402995533129aa177bc3','d018d82b-019a-42de-9f92-1c4da281fbf5',83,'4f1b3c403fb148c692c17867833e30a7','gigabytes',1,'2026-02-21 09:58:55',NULL),('2026-02-20 09:58:56.031033',NULL,'2026-02-20 09:58:56.061854',328,328,NULL,'a83ac006-9314-4fdd-8554-a1813e0baaad',84,'4f1b3c403fb148c692c17867833e30a7','shares',1,'2026-02-21 09:58:55','d75db691-7965-4145-9170-9a4265a3b1f3'),('2026-02-20 09:58:56.032693',NULL,'2026-02-20 09:58:56.061854',329,329,NULL,'2d019ed9-4a3c-4481-8a7b-9a0ac587c455',85,'4f1b3c403fb148c692c17867833e30a7','gigabytes',1,'2026-02-21 09:58:55','d75db691-7965-4145-9170-9a4265a3b1f3'),('2026-02-20 09:58:58.438527',NULL,'2026-02-20 09:58:58.470136',330,330,'fc2654163ae44cab8ac83cec6540300f','85971b90-3676-4697-8bd3-f8d988d82af9',86,'830e413b9fb04e02af1efdd014797bc3','share_networks',1,'2026-02-21 09:58:58',NULL),('2026-02-20 09:58:58.532215',NULL,'2026-02-20 09:58:58.560505',331,331,'fc2654163ae44cab8ac83cec6540300f','cc2dfa96-fc6b-43ca-9c3d-38a9169ee082',86,'830e413b9fb04e02af1efdd014797bc3','share_networks',1,'2026-02-21 09:58:58',NULL),('2026-02-20 09:58:58.949328',NULL,'2026-02-20 09:58:58.956800',332,332,'fc2654163ae44cab8ac83cec6540300f','903373f9-41a4-4f72-8c5d-89e7136afad0',86,'830e413b9fb04e02af1efdd014797bc3','share_networks',-1,'2026-02-21 09:58:58',NULL),('2026-02-20 09:58:59.082878',NULL,'2026-02-20 09:58:59.092265',333,333,'fc2654163ae44cab8ac83cec6540300f','a9d25e60-7d96-4453-88e7-ebddfa7fcea1',86,'830e413b9fb04e02af1efdd014797bc3','share_networks',-1,'2026-02-21 09:58:59',NULL),('2026-02-20 09:58:59.957521',NULL,'2026-02-20 09:58:59.969355',334,334,'658ecc001e85402995533129aa177bc3','6e3a5a7d-2506-474d-86c2-a2ec08a67aa2',82,'4f1b3c403fb148c692c17867833e30a7','shares',-1,'2026-02-21 09:58:59',NULL),('2026-02-20 09:58:59.958186',NULL,'2026-02-20 09:58:59.969355',335,335,'658ecc001e85402995533129aa177bc3','8bd58602-adb8-4213-b792-00a7a388b7da',83,'4f1b3c403fb148c692c17867833e30a7','gigabytes',-1,'2026-02-21 09:58:59',NULL),('2026-02-20 09:58:59.962787',NULL,'2026-02-20 09:58:59.969355',336,336,NULL,'354ee1e8-6147-443a-8be8-506538952ec6',84,'4f1b3c403fb148c692c17867833e30a7','shares',-1,'2026-02-21 09:58:59','d75db691-7965-4145-9170-9a4265a3b1f3'),('2026-02-20 09:58:59.963456',NULL,'2026-02-20 09:58:59.969355',337,337,NULL,'27319232-1009-4c2f-b2fc-febe2fc10db3',85,'4f1b3c403fb148c692c17867833e30a7','gigabytes',-1,'2026-02-21 09:58:59','d75db691-7965-4145-9170-9a4265a3b1f3'),('2026-02-20 09:59:03.629433',NULL,'2026-02-20 09:59:03.651194',338,338,'2a38b24f215a478db5cd7da521f1b21b','42b7fedc-02fa-4ad1-b506-a9fb362bca47',78,'b466c6b08b5e44ff9593bfa11ccdf0a9','shares',-1,'2026-02-21 09:59:03',NULL),('2026-02-20 09:59:03.630734',NULL,'2026-02-20 09:59:03.651194',339,339,'2a38b24f215a478db5cd7da521f1b21b','c4051dad-c682-4407-a2f6-9f52cacb48f6',79,'b466c6b08b5e44ff9593bfa11ccdf0a9','gigabytes',-1,'2026-02-21 09:59:03',NULL),('2026-02-20 09:59:03.641204',NULL,'2026-02-20 09:59:03.651194',340,340,NULL,'1b1d7e9d-5179-47d9-aaea-22dbd3e7419e',80,'b466c6b08b5e44ff9593bfa11ccdf0a9','shares',-1,'2026-02-21 09:59:03','d75db691-7965-4145-9170-9a4265a3b1f3'),('2026-02-20 09:59:03.642265',NULL,'2026-02-20 09:59:03.651194',341,341,NULL,'d946c026-52fb-4f8f-be0a-e275cc0faf69',81,'b466c6b08b5e44ff9593bfa11ccdf0a9','gigabytes',-1,'2026-02-21 09:59:03','d75db691-7965-4145-9170-9a4265a3b1f3'),('2026-02-20 09:59:06.177380',NULL,'2026-02-20 09:59:06.225338',342,342,'658ecc001e85402995533129aa177bc3','972b1faf-18d4-40ef-8ffe-1ee983f899ec',82,'4f1b3c403fb148c692c17867833e30a7','shares',1,'2026-02-21 09:59:06',NULL),('2026-02-20 09:59:06.182486',NULL,'2026-02-20 09:59:06.225338',343,343,'658ecc001e85402995533129aa177bc3','3cb1febd-ba1c-4cfa-a888-a4927c8c8253',83,'4f1b3c403fb148c692c17867833e30a7','gigabytes',1,'2026-02-21 09:59:06',NULL),('2026-02-20 09:59:06.193799',NULL,'2026-02-20 09:59:06.225338',344,344,NULL,'8d2b344d-7dd9-43eb-b31b-7ae9e8556484',84,'4f1b3c403fb148c692c17867833e30a7','shares',1,'2026-02-21 09:59:06','d75db691-7965-4145-9170-9a4265a3b1f3'),('2026-02-20 09:59:06.195479',NULL,'2026-02-20 09:59:06.225338',345,345,NULL,'6685b623-9aad-452d-bfcd-5b8954c1a450',85,'4f1b3c403fb148c692c17867833e30a7','gigabytes',1,'2026-02-21 09:59:06','d75db691-7965-4145-9170-9a4265a3b1f3'),('2026-02-20 09:59:07.923378',NULL,'2026-02-20 09:59:07.962298',346,346,'8643c8395fbe4ccfb167772f294c4f4e','cb894715-592e-4c9a-a9de-5aba84f9b3f9',88,'0d864a52bf534b55a21f76b3d9a1e409','shares',1,'2026-02-21 09:59:07',NULL),('2026-02-20 09:59:07.924841',NULL,'2026-02-20 09:59:07.962298',347,347,'8643c8395fbe4ccfb167772f294c4f4e','08a9c557-ba44-4ecd-836d-526cd3673e47',87,'0d864a52bf534b55a21f76b3d9a1e409','gigabytes',1,'2026-02-21 09:59:07',NULL),('2026-02-20 09:59:07.935667',NULL,'2026-02-20 09:59:07.962298',348,348,NULL,'5fb3223c-4a08-4429-beea-9cce7246d86f',90,'0d864a52bf534b55a21f76b3d9a1e409','shares',1,'2026-02-21 09:59:07','90af42c1-8a5c-4d70-bd40-5357c3133130'),('2026-02-20 09:59:07.936891',NULL,'2026-02-20 09:59:07.962298',349,349,NULL,'19f0dd4a-9f2e-4ace-85c6-e06437690245',89,'0d864a52bf534b55a21f76b3d9a1e409','gigabytes',1,'2026-02-21 09:59:07','90af42c1-8a5c-4d70-bd40-5357c3133130'),('2026-02-20 09:59:11.780935',NULL,'2026-02-20 09:59:11.813940',350,350,'8643c8395fbe4ccfb167772f294c4f4e','bf6230ba-a171-4815-a6cc-944a4f72bbe6',88,'0d864a52bf534b55a21f76b3d9a1e409','shares',1,'2026-02-21 09:59:11',NULL),('2026-02-20 09:59:11.782325',NULL,'2026-02-20 09:59:11.813940',351,351,'8643c8395fbe4ccfb167772f294c4f4e','7d5817e2-78ab-4154-b720-f3575904cd86',87,'0d864a52bf534b55a21f76b3d9a1e409','gigabytes',1,'2026-02-21 09:59:11',NULL),('2026-02-20 09:59:11.788666',NULL,'2026-02-20 09:59:11.813940',352,352,NULL,'392cc8df-656c-40f0-8320-e4c46dcf3c04',90,'0d864a52bf534b55a21f76b3d9a1e409','shares',1,'2026-02-21 09:59:11','90af42c1-8a5c-4d70-bd40-5357c3133130'),('2026-02-20 09:59:11.790092',NULL,'2026-02-20 09:59:11.813940',353,353,NULL,'114da71f-0ac7-4127-8f02-fd3e9da33dcb',89,'0d864a52bf534b55a21f76b3d9a1e409','gigabytes',1,'2026-02-21 09:59:11','90af42c1-8a5c-4d70-bd40-5357c3133130'),('2026-02-20 09:59:12.807297',NULL,'2026-02-20 09:59:12.866573',354,354,'658ecc001e85402995533129aa177bc3','7cc9eebb-d885-43d8-9fd3-a14617450673',82,'4f1b3c403fb148c692c17867833e30a7','shares',-1,'2026-02-21 09:59:12',NULL),('2026-02-20 09:59:12.808602',NULL,'2026-02-20 09:59:12.866573',355,355,'658ecc001e85402995533129aa177bc3','42c532ac-5f05-4a15-94a4-ed86bb2261cf',83,'4f1b3c403fb148c692c17867833e30a7','gigabytes',-1,'2026-02-21 09:59:12',NULL),('2026-02-20 09:59:12.841544',NULL,'2026-02-20 09:59:12.866573',356,356,NULL,'956d1bee-3515-4038-a9dd-22efe2fcc105',84,'4f1b3c403fb148c692c17867833e30a7','shares',-1,'2026-02-21 09:59:12','d75db691-7965-4145-9170-9a4265a3b1f3'),('2026-02-20 09:59:12.843669',NULL,'2026-02-20 09:59:12.866573',357,357,NULL,'9fcf99eb-eea9-4f7d-bda7-de85eec54b25',85,'4f1b3c403fb148c692c17867833e30a7','gigabytes',-1,'2026-02-21 09:59:12','d75db691-7965-4145-9170-9a4265a3b1f3'),('2026-02-20 09:59:15.285551',NULL,'2026-02-20 09:59:15.327510',358,358,'8643c8395fbe4ccfb167772f294c4f4e','19b7e047-052a-4e60-a012-fe55ab0feda0',88,'0d864a52bf534b55a21f76b3d9a1e409','shares',1,'2026-02-21 09:59:15',NULL),('2026-02-20 09:59:15.287543',NULL,'2026-02-20 09:59:15.327510',359,359,'8643c8395fbe4ccfb167772f294c4f4e','cb3e8179-68a7-4a89-8463-b1023763aca7',87,'0d864a52bf534b55a21f76b3d9a1e409','gigabytes',1,'2026-02-21 09:59:15',NULL),('2026-02-20 09:59:15.295115',NULL,'2026-02-20 09:59:15.327510',360,360,NULL,'72e06976-1edc-44fb-b75c-75924c5d63c0',90,'0d864a52bf534b55a21f76b3d9a1e409','shares',1,'2026-02-21 09:59:15','90af42c1-8a5c-4d70-bd40-5357c3133130'),('2026-02-20 09:59:15.296977',NULL,'2026-02-20 09:59:15.327510',361,361,NULL,'15e44c7d-6093-47d5-b4fe-4cbd10eb0fa9',89,'0d864a52bf534b55a21f76b3d9a1e409','gigabytes',1,'2026-02-21 09:59:15','90af42c1-8a5c-4d70-bd40-5357c3133130'),('2026-02-20 09:59:18.754892',NULL,'2026-02-20 09:59:18.792849',362,362,'8643c8395fbe4ccfb167772f294c4f4e','741a2d6d-5679-401a-83b8-acebcd70bf0a',88,'0d864a52bf534b55a21f76b3d9a1e409','shares',1,'2026-02-21 09:59:18',NULL),('2026-02-20 09:59:18.756103',NULL,'2026-02-20 09:59:18.792849',363,363,'8643c8395fbe4ccfb167772f294c4f4e','9f77d3b7-b891-4e40-a75a-7ddfaf3fb562',87,'0d864a52bf534b55a21f76b3d9a1e409','gigabytes',1,'2026-02-21 09:59:18',NULL),('2026-02-20 09:59:18.762558',NULL,'2026-02-20 09:59:18.792849',364,364,NULL,'5c6845b0-8727-4ded-b227-005f12242ec7',90,'0d864a52bf534b55a21f76b3d9a1e409','shares',1,'2026-02-21 09:59:18','90af42c1-8a5c-4d70-bd40-5357c3133130'),('2026-02-20 09:59:18.763871',NULL,'2026-02-20 09:59:18.792849',365,365,NULL,'187e8caa-f673-4c46-805d-702408f5452a',89,'0d864a52bf534b55a21f76b3d9a1e409','gigabytes',1,'2026-02-21 09:59:18','90af42c1-8a5c-4d70-bd40-5357c3133130'),('2026-02-20 09:59:23.020176',NULL,'2026-02-20 09:59:23.032895',366,366,'8643c8395fbe4ccfb167772f294c4f4e','8a4a9b5e-a893-44e4-9151-9887d6d076ae',88,'0d864a52bf534b55a21f76b3d9a1e409','shares',-1,'2026-02-21 09:59:22',NULL),('2026-02-20 09:59:23.020920',NULL,'2026-02-20 09:59:23.032895',367,367,'8643c8395fbe4ccfb167772f294c4f4e','249d635d-6572-408b-92f3-ccf74a867bfa',87,'0d864a52bf534b55a21f76b3d9a1e409','gigabytes',-1,'2026-02-21 09:59:22',NULL),('2026-02-20 09:59:23.026040',NULL,'2026-02-20 09:59:23.032895',368,368,NULL,'73f7fe76-da5f-4271-ab8a-f90775d458e2',90,'0d864a52bf534b55a21f76b3d9a1e409','shares',-1,'2026-02-21 09:59:22','90af42c1-8a5c-4d70-bd40-5357c3133130'),('2026-02-20 09:59:23.026838',NULL,'2026-02-20 09:59:23.032895',369,369,NULL,'cc6ea64b-d545-42c1-8b46-fdbc6088602b',89,'0d864a52bf534b55a21f76b3d9a1e409','gigabytes',-1,'2026-02-21 09:59:22','90af42c1-8a5c-4d70-bd40-5357c3133130'),('2026-02-20 09:59:24.022302',NULL,'2026-02-20 09:59:24.068330',370,370,'58824ecf7ec24f3f8eca46626cadee71','fe075498-1143-4482-abb9-ecfb2318c4c9',92,'cec3ac3e38f4401bb4bfc7f380ef6f55','shares',1,'2026-02-21 09:59:23',NULL),('2026-02-20 09:59:24.024276',NULL,'2026-02-20 09:59:24.068330',371,371,'58824ecf7ec24f3f8eca46626cadee71','8341bcee-6e4a-45fe-9c2c-8b9a9a7876c0',91,'cec3ac3e38f4401bb4bfc7f380ef6f55','gigabytes',1,'2026-02-21 09:59:23',NULL),('2026-02-20 09:59:24.036045',NULL,'2026-02-20 09:59:24.068330',372,372,NULL,'7512c9f5-d5ea-4fd7-b503-4496846c0da8',94,'cec3ac3e38f4401bb4bfc7f380ef6f55','shares',1,'2026-02-21 09:59:23','f97a926c-227e-41fa-9f49-8c026cbaad0b'),('2026-02-20 09:59:24.038566',NULL,'2026-02-20 09:59:24.068330',373,373,NULL,'35ce0863-8cd5-445e-861e-b4d68cbae4b5',93,'cec3ac3e38f4401bb4bfc7f380ef6f55','gigabytes',1,'2026-02-21 09:59:23','f97a926c-227e-41fa-9f49-8c026cbaad0b'),('2026-02-20 09:59:26.324075',NULL,'2026-02-20 09:59:26.339512',374,374,'8643c8395fbe4ccfb167772f294c4f4e','2e846777-ba8e-4d91-bedc-efd6cfdb6cca',88,'0d864a52bf534b55a21f76b3d9a1e409','shares',-1,'2026-02-21 09:59:26',NULL),('2026-02-20 09:59:26.325694',NULL,'2026-02-20 09:59:26.339512',375,375,'8643c8395fbe4ccfb167772f294c4f4e','41a8e3cf-d736-438c-8eed-5eb77697e26c',87,'0d864a52bf534b55a21f76b3d9a1e409','gigabytes',-1,'2026-02-21 09:59:26',NULL),('2026-02-20 09:59:26.331656',NULL,'2026-02-20 09:59:26.339512',376,376,NULL,'e173dcc1-9124-4272-9122-5f23f5edf5f8',90,'0d864a52bf534b55a21f76b3d9a1e409','shares',-1,'2026-02-21 09:59:26','90af42c1-8a5c-4d70-bd40-5357c3133130'),('2026-02-20 09:59:26.332289',NULL,'2026-02-20 09:59:26.339512',377,377,NULL,'3a1324fc-2dc1-4a82-a6c4-6bb7400c509a',89,'0d864a52bf534b55a21f76b3d9a1e409','gigabytes',-1,'2026-02-21 09:59:26','90af42c1-8a5c-4d70-bd40-5357c3133130'),('2026-02-20 09:59:28.712850',NULL,'2026-02-20 09:59:28.754188',378,378,'58824ecf7ec24f3f8eca46626cadee71','6a7c1662-3208-4b7d-a76b-99fc299a6ef3',92,'cec3ac3e38f4401bb4bfc7f380ef6f55','shares',-1,'2026-02-21 09:59:28',NULL),('2026-02-20 09:59:28.713671',NULL,'2026-02-20 09:59:28.754188',379,379,'58824ecf7ec24f3f8eca46626cadee71','746a7c36-e312-4b14-937e-89966327456c',91,'cec3ac3e38f4401bb4bfc7f380ef6f55','gigabytes',-1,'2026-02-21 09:59:28',NULL),('2026-02-20 09:59:28.721323',NULL,'2026-02-20 09:59:28.754188',380,380,NULL,'0651d762-0ec4-4d33-8304-2ec514e5abc7',94,'cec3ac3e38f4401bb4bfc7f380ef6f55','shares',-1,'2026-02-21 09:59:28','f97a926c-227e-41fa-9f49-8c026cbaad0b'),('2026-02-20 09:59:28.722357',NULL,'2026-02-20 09:59:28.754188',381,381,NULL,'ab09ba32-6045-4415-910e-3b3d30a2c9c3',93,'cec3ac3e38f4401bb4bfc7f380ef6f55','gigabytes',-1,'2026-02-21 09:59:28','f97a926c-227e-41fa-9f49-8c026cbaad0b'),('2026-02-20 09:59:29.440296',NULL,'2026-02-20 09:59:29.458451',382,382,'8643c8395fbe4ccfb167772f294c4f4e','200cff80-7eb7-4c5f-8bc4-c66fc0de5594',88,'0d864a52bf534b55a21f76b3d9a1e409','shares',-1,'2026-02-21 09:59:29',NULL),('2026-02-20 09:59:29.441143',NULL,'2026-02-20 09:59:29.458451',383,383,'8643c8395fbe4ccfb167772f294c4f4e','fd2d142a-7824-487e-a27a-983c20864932',87,'0d864a52bf534b55a21f76b3d9a1e409','gigabytes',-1,'2026-02-21 09:59:29',NULL),('2026-02-20 09:59:29.447761',NULL,'2026-02-20 09:59:29.458451',384,384,NULL,'abce1481-b340-41c5-bb00-dbbc371b388e',90,'0d864a52bf534b55a21f76b3d9a1e409','shares',-1,'2026-02-21 09:59:29','90af42c1-8a5c-4d70-bd40-5357c3133130'),('2026-02-20 09:59:29.449860',NULL,'2026-02-20 09:59:29.458451',385,385,NULL,'944d478a-0c8c-4120-a37f-9dd4d270729a',89,'0d864a52bf534b55a21f76b3d9a1e409','gigabytes',-1,'2026-02-21 09:59:29','90af42c1-8a5c-4d70-bd40-5357c3133130'),('2026-02-20 09:59:32.491268',NULL,'2026-02-20 09:59:32.519360',386,386,'8643c8395fbe4ccfb167772f294c4f4e','0839f2ca-3505-4339-8b95-f6a33f199c38',88,'0d864a52bf534b55a21f76b3d9a1e409','shares',-1,'2026-02-21 09:59:32',NULL),('2026-02-20 09:59:32.494462',NULL,'2026-02-20 09:59:32.519360',387,387,'8643c8395fbe4ccfb167772f294c4f4e','044b879a-5d52-42ff-a726-5f44fedc5796',87,'0d864a52bf534b55a21f76b3d9a1e409','gigabytes',-1,'2026-02-21 09:59:32',NULL),('2026-02-20 09:59:32.504236',NULL,'2026-02-20 09:59:32.519360',388,388,NULL,'db753dfb-aae6-4a6e-8e13-8bec856d609f',90,'0d864a52bf534b55a21f76b3d9a1e409','shares',-1,'2026-02-21 09:59:32','90af42c1-8a5c-4d70-bd40-5357c3133130'),('2026-02-20 09:59:32.506479',NULL,'2026-02-20 09:59:32.519360',389,389,NULL,'07f996d2-eda2-4d43-9626-c8e1ddb6a067',89,'0d864a52bf534b55a21f76b3d9a1e409','gigabytes',-1,'2026-02-21 09:59:32','90af42c1-8a5c-4d70-bd40-5357c3133130'),('2026-02-20 09:59:38.972238',NULL,'2026-02-20 09:59:39.003887',390,390,'e2403c6acd6d4934a0d7baec8e166e83','ff23dbd8-9973-4a1f-9077-97e4c4f448ff',95,'8fac2513a3ab4162a13f560c6301f671','shares',1,'2026-02-21 09:59:38',NULL),('2026-02-20 09:59:38.973446',NULL,'2026-02-20 09:59:39.003887',391,391,'e2403c6acd6d4934a0d7baec8e166e83','90e093f3-8108-4d09-aa9a-2fe6e5dd9c3b',96,'8fac2513a3ab4162a13f560c6301f671','gigabytes',1,'2026-02-21 09:59:38',NULL),('2026-02-20 09:59:38.985668',NULL,'2026-02-20 09:59:39.003887',392,392,NULL,'88d23a4e-ff11-4cab-b134-6acdd9b4dc86',97,'8fac2513a3ab4162a13f560c6301f671','shares',1,'2026-02-21 09:59:38','bb3fe1e2-ba2f-415c-a2f0-e5751f7811cb'),('2026-02-20 09:59:38.986931',NULL,'2026-02-20 09:59:39.003887',393,393,NULL,'2249ec7f-6872-4016-8106-1230efd719ba',98,'8fac2513a3ab4162a13f560c6301f671','gigabytes',1,'2026-02-21 09:59:38','bb3fe1e2-ba2f-415c-a2f0-e5751f7811cb'),('2026-02-20 09:59:42.261098',NULL,'2026-02-20 09:59:42.327490',394,394,'e2403c6acd6d4934a0d7baec8e166e83','9727e889-0f05-4ee2-a514-80657802606a',95,'8fac2513a3ab4162a13f560c6301f671','shares',1,'2026-02-21 09:59:42',NULL),('2026-02-20 09:59:42.270482',NULL,'2026-02-20 09:59:42.327490',395,395,'e2403c6acd6d4934a0d7baec8e166e83','6e60f6c4-c879-4ff8-a9e1-ebd03a1baa0b',96,'8fac2513a3ab4162a13f560c6301f671','gigabytes',1,'2026-02-21 09:59:42',NULL),('2026-02-20 09:59:42.292687',NULL,'2026-02-20 09:59:42.327490',396,396,NULL,'acef51be-e737-43a3-9828-c913fc73dea5',99,'8fac2513a3ab4162a13f560c6301f671','shares',1,'2026-02-21 09:59:42','eb9df654-33ce-4f45-a990-326f72bd8165'),('2026-02-20 09:59:42.293900',NULL,'2026-02-20 09:59:42.327490',397,397,NULL,'af086c6c-a855-43e1-8782-96d4cb839614',100,'8fac2513a3ab4162a13f560c6301f671','gigabytes',1,'2026-02-21 09:59:42','eb9df654-33ce-4f45-a990-326f72bd8165'),('2026-02-20 09:59:48.978009',NULL,'2026-02-20 09:59:49.011675',398,398,'21cbeb9a927145a3bbcad8958770ed83','5181eb13-86f1-4799-8107-88cc77b535f8',102,'f656f9df86ae4c53b02f471da5bd5ad7','shares',1,'2026-02-21 09:59:48',NULL),('2026-02-20 09:59:48.979216',NULL,'2026-02-20 09:59:49.011675',399,399,'21cbeb9a927145a3bbcad8958770ed83','02c42f93-24d0-42f8-a413-81ed3052375e',101,'f656f9df86ae4c53b02f471da5bd5ad7','gigabytes',1,'2026-02-21 09:59:48',NULL),('2026-02-20 09:59:48.989049',NULL,'2026-02-20 09:59:49.011675',400,400,NULL,'bc646a73-366f-4c6e-8b33-d1d312c6eec8',104,'f656f9df86ae4c53b02f471da5bd5ad7','shares',1,'2026-02-21 09:59:48','eb9df654-33ce-4f45-a990-326f72bd8165'),('2026-02-20 09:59:48.990181',NULL,'2026-02-20 09:59:49.011675',401,401,NULL,'96d0b4ae-8205-4c3c-9d9b-ddfcbbfbf145',103,'f656f9df86ae4c53b02f471da5bd5ad7','gigabytes',1,'2026-02-21 09:59:48','eb9df654-33ce-4f45-a990-326f72bd8165'),('2026-02-20 09:59:52.155434',NULL,'2026-02-20 09:59:52.194142',402,402,'651bfdd554864016b919f2b5c8112b5f','a4f488a0-86d0-45e5-803f-659ec0dbcac3',105,'3dca3c8f00214a66a9293134148fac17','shares',1,'2026-02-21 09:59:52',NULL),('2026-02-20 09:59:52.156945',NULL,'2026-02-20 09:59:52.194142',403,403,'651bfdd554864016b919f2b5c8112b5f','fa7bfc50-e67d-4cc0-a9dc-def206f850d7',106,'3dca3c8f00214a66a9293134148fac17','gigabytes',1,'2026-02-21 09:59:52',NULL),('2026-02-20 09:59:52.165774',NULL,'2026-02-20 09:59:52.194142',404,404,NULL,'f974cfe1-2f97-4f32-a0a4-427dd0e9fb4c',107,'3dca3c8f00214a66a9293134148fac17','shares',1,'2026-02-21 09:59:52','b7211100-1e6b-44a1-ab50-e2eb1739e315'),('2026-02-20 09:59:52.167041',NULL,'2026-02-20 09:59:52.194142',405,405,NULL,'99d1b93b-5855-4975-af1a-7c3c29cede95',108,'3dca3c8f00214a66a9293134148fac17','gigabytes',1,'2026-02-21 09:59:52','b7211100-1e6b-44a1-ab50-e2eb1739e315'),('2026-02-20 09:59:55.730766',NULL,'2026-02-20 09:59:55.801975',406,406,'651bfdd554864016b919f2b5c8112b5f','d3d5c1fd-6be3-497b-9a2c-71dae4828e02',109,'3dca3c8f00214a66a9293134148fac17','shares',1,'2026-02-21 09:59:55',NULL),('2026-02-20 09:59:55.733565',NULL,'2026-02-20 09:59:55.801975',407,407,'651bfdd554864016b919f2b5c8112b5f','8b674530-ec5f-4c0e-b21b-963e71885247',110,'3dca3c8f00214a66a9293134148fac17','gigabytes',1,'2026-02-21 09:59:55',NULL),('2026-02-20 09:59:55.757094',NULL,'2026-02-20 09:59:55.801975',408,408,NULL,'b79ea39d-a833-4e47-8934-eef352431dd6',112,'3dca3c8f00214a66a9293134148fac17','shares',1,'2026-02-21 09:59:55','5fe79e8d-459d-4121-8de9-2bdfeb00eefa'),('2026-02-20 09:59:55.763024',NULL,'2026-02-20 09:59:55.801975',409,409,NULL,'fcaded87-852f-47a2-a4bf-f6dc28666759',111,'3dca3c8f00214a66a9293134148fac17','gigabytes',1,'2026-02-21 09:59:55','5fe79e8d-459d-4121-8de9-2bdfeb00eefa'),('2026-02-20 09:59:59.228973',NULL,'2026-02-20 09:59:59.335299',410,410,'651bfdd554864016b919f2b5c8112b5f','fe4735f7-5355-49ff-88d9-f2fdec9ad73d',113,'3dca3c8f00214a66a9293134148fac17','snapshots',1,'2026-02-21 09:59:59',NULL),('2026-02-20 09:59:59.231894',NULL,'2026-02-20 09:59:59.335299',411,411,'651bfdd554864016b919f2b5c8112b5f','c50ab30b-bb79-4678-a6a4-8a57f2eee299',114,'3dca3c8f00214a66a9293134148fac17','snapshot_gigabytes',1,'2026-02-21 09:59:59',NULL),('2026-02-20 09:59:59.252252',NULL,'2026-02-20 09:59:59.335299',412,412,NULL,'f55c2cb2-026b-4a6d-9ebe-ab003effaa48',115,'3dca3c8f00214a66a9293134148fac17','snapshots',1,'2026-02-21 09:59:59','5fe79e8d-459d-4121-8de9-2bdfeb00eefa'),('2026-02-20 09:59:59.259023',NULL,'2026-02-20 09:59:59.335299',413,413,NULL,'9b67ed88-5f98-4d5c-8656-cae064147e07',116,'3dca3c8f00214a66a9293134148fac17','snapshot_gigabytes',1,'2026-02-21 09:59:59','5fe79e8d-459d-4121-8de9-2bdfeb00eefa'),('2026-02-20 10:00:01.319314',NULL,'2026-02-20 10:00:01.370981',414,414,'c1cf03483c7d40b1a7b5cb96f508a5e3','31734b77-e747-4603-8368-6d4d80300487',117,'13d7347e58a645999865c0f5a5839f4f','shares',1,'2026-02-21 10:00:01',NULL),('2026-02-20 10:00:01.320516',NULL,'2026-02-20 10:00:01.370981',415,415,'c1cf03483c7d40b1a7b5cb96f508a5e3','e5425c03-6197-4228-a174-ac8187d271f0',118,'13d7347e58a645999865c0f5a5839f4f','gigabytes',4,'2026-02-21 10:00:01',NULL),('2026-02-20 10:00:01.336441',NULL,'2026-02-20 10:00:01.370981',416,416,NULL,'7601127c-5d29-4022-9e89-33173ac758c2',119,'13d7347e58a645999865c0f5a5839f4f','shares',1,'2026-02-21 10:00:01','6dfdce8c-75c9-4cee-815a-e43c0b596d98'),('2026-02-20 10:00:01.338401',NULL,'2026-02-20 10:00:01.370981',417,417,NULL,'0ccc7a20-0adb-4f1d-9f0b-35a3f67a61ad',120,'13d7347e58a645999865c0f5a5839f4f','gigabytes',4,'2026-02-21 10:00:01','6dfdce8c-75c9-4cee-815a-e43c0b596d98'),('2026-02-20 10:00:04.771163',NULL,'2026-02-20 10:00:04.801115',418,418,'c1cf03483c7d40b1a7b5cb96f508a5e3','0e88748b-4765-4fc6-a9ef-7e487be83e0a',117,'13d7347e58a645999865c0f5a5839f4f','shares',1,'2026-02-21 10:00:04',NULL),('2026-02-20 10:00:04.772567',NULL,'2026-02-20 10:00:04.801115',419,419,'c1cf03483c7d40b1a7b5cb96f508a5e3','759da5a2-16f9-481f-89bd-e432b8c09d4c',118,'13d7347e58a645999865c0f5a5839f4f','gigabytes',3,'2026-02-21 10:00:04',NULL),('2026-02-20 10:00:04.947581',NULL,'2026-02-20 10:00:04.986609',420,420,'c1cf03483c7d40b1a7b5cb96f508a5e3','23e61492-61c6-44a2-840d-f645e81f7ce7',117,'13d7347e58a645999865c0f5a5839f4f','shares',1,'2026-02-21 10:00:04',NULL),('2026-02-20 10:00:04.949150',NULL,'2026-02-20 10:00:04.986609',421,421,'c1cf03483c7d40b1a7b5cb96f508a5e3','6a7c7176-9f5e-495d-ab14-dd61069e2ab9',118,'13d7347e58a645999865c0f5a5839f4f','gigabytes',3,'2026-02-21 10:00:04',NULL),('2026-02-20 10:00:04.962604',NULL,'2026-02-20 10:00:04.986609',422,422,NULL,'19481242-37d0-41b0-afef-33f9f71d9bf7',121,'13d7347e58a645999865c0f5a5839f4f','shares',1,'2026-02-21 10:00:04','4586d343-e913-4ae2-9240-d15623f44eec'),('2026-02-20 10:00:04.963682',NULL,'2026-02-20 10:00:04.986609',423,423,NULL,'219d03e8-57f7-406c-b4ca-66f000cc04f9',122,'13d7347e58a645999865c0f5a5839f4f','gigabytes',3,'2026-02-21 10:00:04','4586d343-e913-4ae2-9240-d15623f44eec'),('2026-02-20 10:00:06.326233',NULL,'2026-02-20 10:00:06.351307',424,424,'651bfdd554864016b919f2b5c8112b5f','8abbf801-3692-4b6e-afcf-f57fadb26924',124,'3dca3c8f00214a66a9293134148fac17','snapshots',-1,'2026-02-21 10:00:06',NULL),('2026-02-20 10:00:06.326920',NULL,'2026-02-20 10:00:06.351307',425,425,'651bfdd554864016b919f2b5c8112b5f','42491991-0a20-4739-be51-1d0db604daca',123,'3dca3c8f00214a66a9293134148fac17','snapshot_gigabytes',-1,'2026-02-21 10:00:06',NULL),('2026-02-20 10:00:06.341526',NULL,'2026-02-20 10:00:06.351307',426,426,NULL,'9a21f2d6-f536-4a4e-b93b-88c2d16006ea',126,'3dca3c8f00214a66a9293134148fac17','snapshots',-1,'2026-02-21 10:00:06','5fe79e8d-459d-4121-8de9-2bdfeb00eefa'),('2026-02-20 10:00:06.342400',NULL,'2026-02-20 10:00:06.351307',427,427,NULL,'3a72fbd1-1713-4893-ac99-7456fbc7614e',125,'3dca3c8f00214a66a9293134148fac17','snapshot_gigabytes',-1,'2026-02-21 10:00:06','5fe79e8d-459d-4121-8de9-2bdfeb00eefa'),('2026-02-20 10:00:08.770224',NULL,'2026-02-20 10:00:08.804321',428,428,'c1cf03483c7d40b1a7b5cb96f508a5e3','1eca3a20-6bee-40c9-b2bc-19a6d2d25b7a',117,'13d7347e58a645999865c0f5a5839f4f','shares',-1,'2026-02-21 10:00:08',NULL),('2026-02-20 10:00:08.772662',NULL,'2026-02-20 10:00:08.804321',429,429,'c1cf03483c7d40b1a7b5cb96f508a5e3','e4a41ff8-62f6-4f0e-a2ed-719ab3951cd1',118,'13d7347e58a645999865c0f5a5839f4f','gigabytes',-4,'2026-02-21 10:00:08',NULL),('2026-02-20 10:00:08.787413',NULL,'2026-02-20 10:00:08.804321',430,430,NULL,'b254195b-12f2-4867-aac7-982a52d04bf2',119,'13d7347e58a645999865c0f5a5839f4f','shares',-1,'2026-02-21 10:00:08','6dfdce8c-75c9-4cee-815a-e43c0b596d98'),('2026-02-20 10:00:08.789523',NULL,'2026-02-20 10:00:08.804321',431,431,NULL,'8c5a021f-4919-4a91-92c6-351bea61ac92',120,'13d7347e58a645999865c0f5a5839f4f','gigabytes',-4,'2026-02-21 10:00:08','6dfdce8c-75c9-4cee-815a-e43c0b596d98'),('2026-02-20 10:00:09.443823',NULL,'2026-02-20 10:00:09.461722',432,432,'651bfdd554864016b919f2b5c8112b5f','3d9d604f-e1b4-4658-a689-7e161831f4d7',128,'3dca3c8f00214a66a9293134148fac17','shares',-1,'2026-02-21 10:00:09',NULL),('2026-02-20 10:00:09.444633',NULL,'2026-02-20 10:00:09.461722',433,433,'651bfdd554864016b919f2b5c8112b5f','dbb01aa3-8021-49ca-840c-7f8e1966d638',127,'3dca3c8f00214a66a9293134148fac17','gigabytes',-1,'2026-02-21 10:00:09',NULL),('2026-02-20 10:00:09.455263',NULL,'2026-02-20 10:00:09.461722',434,434,NULL,'3993ca67-0ca1-4826-9df5-cbb0c4f26dc8',130,'3dca3c8f00214a66a9293134148fac17','shares',-1,'2026-02-21 10:00:09','5fe79e8d-459d-4121-8de9-2bdfeb00eefa'),('2026-02-20 10:00:09.455830',NULL,'2026-02-20 10:00:09.461722',435,435,NULL,'3f243e10-9cd6-484f-a037-2b159aad83b5',129,'3dca3c8f00214a66a9293134148fac17','gigabytes',-1,'2026-02-21 10:00:09','5fe79e8d-459d-4121-8de9-2bdfeb00eefa'),('2026-02-20 10:00:12.993006',NULL,'2026-02-20 10:00:13.042648',436,436,'c1cf03483c7d40b1a7b5cb96f508a5e3','72889a67-f188-4d08-a44d-f6d690ea3564',117,'13d7347e58a645999865c0f5a5839f4f','shares',-1,'2026-02-21 10:00:12',NULL),('2026-02-20 10:00:13.002452',NULL,'2026-02-20 10:00:13.042648',437,437,'c1cf03483c7d40b1a7b5cb96f508a5e3','a4aae239-58c5-43f7-9836-aa30ad2dce13',118,'13d7347e58a645999865c0f5a5839f4f','gigabytes',-3,'2026-02-21 10:00:12',NULL),('2026-02-20 10:00:13.019278',NULL,'2026-02-20 10:00:13.042648',438,438,NULL,'c5df23ba-39dc-4d98-bb99-a9a9b3d37de3',121,'13d7347e58a645999865c0f5a5839f4f','shares',-1,'2026-02-21 10:00:12','4586d343-e913-4ae2-9240-d15623f44eec'),('2026-02-20 10:00:13.021477',NULL,'2026-02-20 10:00:13.042648',439,439,NULL,'242e3eb5-75db-42dc-9bd5-2134126c6feb',122,'13d7347e58a645999865c0f5a5839f4f','gigabytes',-3,'2026-02-21 10:00:12','4586d343-e913-4ae2-9240-d15623f44eec'),('2026-02-20 10:00:14.067206',NULL,'2026-02-20 10:00:14.133180',440,440,'651bfdd554864016b919f2b5c8112b5f','65eccf3d-78a9-4bd9-99a0-ab47faa52be1',128,'3dca3c8f00214a66a9293134148fac17','shares',-1,'2026-02-21 10:00:13',NULL),('2026-02-20 10:00:14.071421',NULL,'2026-02-20 10:00:14.133180',441,441,'651bfdd554864016b919f2b5c8112b5f','d0909f81-20ee-4c9f-b2e6-07f5b8caf0e9',127,'3dca3c8f00214a66a9293134148fac17','gigabytes',-1,'2026-02-21 10:00:13',NULL),('2026-02-20 10:00:14.111772',NULL,'2026-02-20 10:00:14.133180',442,442,NULL,'e4f48cd0-6aa1-4af1-b737-8a06ce3b0f62',132,'3dca3c8f00214a66a9293134148fac17','shares',-1,'2026-02-21 10:00:13','b7211100-1e6b-44a1-ab50-e2eb1739e315'),('2026-02-20 10:00:14.113515',NULL,'2026-02-20 10:00:14.133180',443,443,NULL,'e8551129-a17d-494c-ba05-bc4d9940f5c6',131,'3dca3c8f00214a66a9293134148fac17','gigabytes',-1,'2026-02-21 10:00:13','b7211100-1e6b-44a1-ab50-e2eb1739e315'),('2026-02-20 10:00:15.205148',NULL,'2026-02-20 10:00:15.242544',444,444,'21cbeb9a927145a3bbcad8958770ed83','c2b399a2-b518-459f-beed-12e50bed810f',102,'f656f9df86ae4c53b02f471da5bd5ad7','shares',1,'2026-02-21 10:00:15',NULL),('2026-02-20 10:00:15.206419',NULL,'2026-02-20 10:00:15.242544',445,445,'21cbeb9a927145a3bbcad8958770ed83','d753cb31-5308-4a73-a80f-03683a033cb8',101,'f656f9df86ae4c53b02f471da5bd5ad7','gigabytes',1,'2026-02-21 10:00:15',NULL),('2026-02-20 10:00:15.219950',NULL,'2026-02-20 10:00:15.242544',446,446,NULL,'b879d10c-749b-4545-86cb-98fdd1501648',133,'f656f9df86ae4c53b02f471da5bd5ad7','shares',1,'2026-02-21 10:00:15','bb3fe1e2-ba2f-415c-a2f0-e5751f7811cb'),('2026-02-20 10:00:15.221517',NULL,'2026-02-20 10:00:15.242544',447,447,NULL,'311a3ff6-e85b-4938-90f4-b4f62c7c0539',134,'f656f9df86ae4c53b02f471da5bd5ad7','gigabytes',1,'2026-02-21 10:00:15','bb3fe1e2-ba2f-415c-a2f0-e5751f7811cb'),('2026-02-20 10:00:18.653148',NULL,'2026-02-20 10:00:18.678505',448,448,'157fe81ea811422c9d325b8c2657d3a9','c828e16e-387f-45ea-bf6e-f264937f0ab5',135,'fc77d937e5f64d008d60c0ad9d54a545','shares',1,'2026-02-21 10:00:18',NULL),('2026-02-20 10:00:18.654191',NULL,'2026-02-20 10:00:18.678505',449,449,'157fe81ea811422c9d325b8c2657d3a9','01eb45f0-e9ca-4ecf-89ca-18b3bc510292',136,'fc77d937e5f64d008d60c0ad9d54a545','gigabytes',1,'2026-02-21 10:00:18',NULL),('2026-02-20 10:00:18.662173',NULL,'2026-02-20 10:00:18.678505',450,450,NULL,'c88d6313-aca7-4fa2-b534-746b846cb587',137,'fc77d937e5f64d008d60c0ad9d54a545','shares',1,'2026-02-21 10:00:18','3334a4fc-2669-4424-82cf-eb94eac49695'),('2026-02-20 10:00:18.663153',NULL,'2026-02-20 10:00:18.678505',451,451,NULL,'0f115352-591b-4894-a7fd-bae22b962d06',138,'fc77d937e5f64d008d60c0ad9d54a545','gigabytes',1,'2026-02-21 10:00:18','3334a4fc-2669-4424-82cf-eb94eac49695'),('2026-02-20 10:00:23.102233',NULL,'2026-02-20 10:00:23.118606',452,452,'157fe81ea811422c9d325b8c2657d3a9','5a264672-a424-4785-b306-9bd38b465df2',135,'fc77d937e5f64d008d60c0ad9d54a545','shares',-1,'2026-02-21 10:00:23',NULL),('2026-02-20 10:00:23.104229',NULL,'2026-02-20 10:00:23.118606',453,453,'157fe81ea811422c9d325b8c2657d3a9','9d67faf8-2553-45c0-96ae-dbf052ec6c5f',136,'fc77d937e5f64d008d60c0ad9d54a545','gigabytes',-1,'2026-02-21 10:00:23',NULL),('2026-02-20 10:00:23.108864',NULL,'2026-02-20 10:00:23.118606',454,454,NULL,'6f139e30-14ec-4177-9ebd-31b6b4346afe',137,'fc77d937e5f64d008d60c0ad9d54a545','shares',-1,'2026-02-21 10:00:23','3334a4fc-2669-4424-82cf-eb94eac49695'),('2026-02-20 10:00:23.109521',NULL,'2026-02-20 10:00:23.118606',455,455,NULL,'1d4be17c-68aa-4bb6-a43b-4721354b0704',138,'fc77d937e5f64d008d60c0ad9d54a545','gigabytes',-1,'2026-02-21 10:00:23','3334a4fc-2669-4424-82cf-eb94eac49695'),('2026-02-20 10:00:29.225905',NULL,'2026-02-20 10:00:29.240885',456,456,'21cbeb9a927145a3bbcad8958770ed83','d881e269-3fd5-48da-b5e7-53b4dcdb65c4',102,'f656f9df86ae4c53b02f471da5bd5ad7','shares',-1,'2026-02-21 10:00:29',NULL),('2026-02-20 10:00:29.226556',NULL,'2026-02-20 10:00:29.240885',457,457,'21cbeb9a927145a3bbcad8958770ed83','5cf46157-5107-419e-8275-5ba662661685',101,'f656f9df86ae4c53b02f471da5bd5ad7','gigabytes',-1,'2026-02-21 10:00:29',NULL),('2026-02-20 10:00:29.234637',NULL,'2026-02-20 10:00:29.240885',458,458,NULL,'14f49caa-5a80-4f8b-9170-ed187fd1305b',133,'f656f9df86ae4c53b02f471da5bd5ad7','shares',-1,'2026-02-21 10:00:29','bb3fe1e2-ba2f-415c-a2f0-e5751f7811cb'),('2026-02-20 10:00:29.235380',NULL,'2026-02-20 10:00:29.240885',459,459,NULL,'69cc35a7-5d38-43da-8546-802c64785cdb',134,'f656f9df86ae4c53b02f471da5bd5ad7','gigabytes',-1,'2026-02-21 10:00:29','bb3fe1e2-ba2f-415c-a2f0-e5751f7811cb'),('2026-02-20 10:00:29.604386',NULL,'2026-02-20 10:00:29.655503',460,460,'3811bcf9aa084a2485b8e167851d7a4a','3395f8ea-2e04-403c-a1ec-2fac2ae8df24',139,'c46bf1229a0b4128b6de1b5e8bac25aa','shares',1,'2026-02-21 10:00:29',NULL),('2026-02-20 10:00:29.605632',NULL,'2026-02-20 10:00:29.655503',461,461,'3811bcf9aa084a2485b8e167851d7a4a','8916baf6-fca4-4480-bc04-c9143093fcad',140,'c46bf1229a0b4128b6de1b5e8bac25aa','gigabytes',1,'2026-02-21 10:00:29',NULL),('2026-02-20 10:00:29.616506',NULL,'2026-02-20 10:00:29.655503',462,462,NULL,'fca256d8-2cd8-4761-8b30-7e8c67d052b5',141,'c46bf1229a0b4128b6de1b5e8bac25aa','shares',1,'2026-02-21 10:00:29','dee7b2d5-ce73-43ef-a94e-a69d40df2957'),('2026-02-20 10:00:29.619403',NULL,'2026-02-20 10:00:29.655503',463,463,NULL,'5b832594-af6b-4ab8-88b7-53e6026bd5dc',142,'c46bf1229a0b4128b6de1b5e8bac25aa','gigabytes',1,'2026-02-21 10:00:29','dee7b2d5-ce73-43ef-a94e-a69d40df2957'),('2026-02-20 10:00:32.607243',NULL,'2026-02-20 10:00:32.619046',464,464,'21cbeb9a927145a3bbcad8958770ed83','494ffdd4-473b-4308-8619-c096f995e0dd',102,'f656f9df86ae4c53b02f471da5bd5ad7','shares',-1,'2026-02-21 10:00:32',NULL),('2026-02-20 10:00:32.607926',NULL,'2026-02-20 10:00:32.619046',465,465,'21cbeb9a927145a3bbcad8958770ed83','718214e1-93e9-4915-b534-b5b926e7b3e3',101,'f656f9df86ae4c53b02f471da5bd5ad7','gigabytes',-1,'2026-02-21 10:00:32',NULL),('2026-02-20 10:00:32.612616',NULL,'2026-02-20 10:00:32.619046',466,466,NULL,'1a846fa1-36d9-4c23-a8d5-05a154ebefa9',104,'f656f9df86ae4c53b02f471da5bd5ad7','shares',-1,'2026-02-21 10:00:32','eb9df654-33ce-4f45-a990-326f72bd8165'),('2026-02-20 10:00:32.613332',NULL,'2026-02-20 10:00:32.619046',467,467,NULL,'c40f426d-78b6-410c-a643-16f227870ca3',103,'f656f9df86ae4c53b02f471da5bd5ad7','gigabytes',-1,'2026-02-21 10:00:32','eb9df654-33ce-4f45-a990-326f72bd8165'),('2026-02-20 10:00:34.110694',NULL,'2026-02-20 10:00:34.127034',468,468,'3811bcf9aa084a2485b8e167851d7a4a','0c0d22e3-c2b0-4bc2-8675-2ae58e16c03c',139,'c46bf1229a0b4128b6de1b5e8bac25aa','shares',-1,'2026-02-21 10:00:33',NULL),('2026-02-20 10:00:34.114301',NULL,'2026-02-20 10:00:34.127034',469,469,'3811bcf9aa084a2485b8e167851d7a4a','8f69be14-d059-456f-a7a2-25ffb1d834bd',140,'c46bf1229a0b4128b6de1b5e8bac25aa','gigabytes',-1,'2026-02-21 10:00:33',NULL),('2026-02-20 10:00:34.119622',NULL,'2026-02-20 10:00:34.127034',470,470,NULL,'fa694a90-429e-4bfb-957d-204b21dd5e37',141,'c46bf1229a0b4128b6de1b5e8bac25aa','shares',-1,'2026-02-21 10:00:33','dee7b2d5-ce73-43ef-a94e-a69d40df2957'),('2026-02-20 10:00:34.120213',NULL,'2026-02-20 10:00:34.127034',471,471,NULL,'5899d3b9-03ca-450a-80ec-6e07e2f8ac21',142,'c46bf1229a0b4128b6de1b5e8bac25aa','gigabytes',-1,'2026-02-21 10:00:33','dee7b2d5-ce73-43ef-a94e-a69d40df2957'),('2026-02-20 10:00:35.662887',NULL,'2026-02-20 10:00:35.678393',472,472,'e2403c6acd6d4934a0d7baec8e166e83','b14bba92-434e-43fb-ad94-2b63c6bae55f',95,'8fac2513a3ab4162a13f560c6301f671','shares',-1,'2026-02-21 10:00:35',NULL),('2026-02-20 10:00:35.663698',NULL,'2026-02-20 10:00:35.678393',473,473,'e2403c6acd6d4934a0d7baec8e166e83','c0fca1dd-03cf-4844-a938-f95d07eb6b9a',96,'8fac2513a3ab4162a13f560c6301f671','gigabytes',-1,'2026-02-21 10:00:35',NULL),('2026-02-20 10:00:35.669849',NULL,'2026-02-20 10:00:35.678393',474,474,NULL,'8820168b-f40b-4a39-878a-64afc0469eea',99,'8fac2513a3ab4162a13f560c6301f671','shares',-1,'2026-02-21 10:00:35','eb9df654-33ce-4f45-a990-326f72bd8165'),('2026-02-20 10:00:35.670793',NULL,'2026-02-20 10:00:35.678393',475,475,NULL,'a8c13f54-fdd1-4996-8c17-78cd89565ff6',100,'8fac2513a3ab4162a13f560c6301f671','gigabytes',-1,'2026-02-21 10:00:35','eb9df654-33ce-4f45-a990-326f72bd8165'),('2026-02-20 10:00:39.716104',NULL,'2026-02-20 10:00:39.735919',476,476,'e2403c6acd6d4934a0d7baec8e166e83','17b7ecf7-1464-46c7-8044-ec6e1984bdf5',95,'8fac2513a3ab4162a13f560c6301f671','shares',-1,'2026-02-21 10:00:39',NULL),('2026-02-20 10:00:39.716805',NULL,'2026-02-20 10:00:39.735919',477,477,'e2403c6acd6d4934a0d7baec8e166e83','ca52ab65-0300-4157-b196-d041b34590fc',96,'8fac2513a3ab4162a13f560c6301f671','gigabytes',-1,'2026-02-21 10:00:39',NULL),('2026-02-20 10:00:39.721540',NULL,'2026-02-20 10:00:39.735919',478,478,NULL,'4cb1aab1-163a-415a-9f17-a48de7196418',97,'8fac2513a3ab4162a13f560c6301f671','shares',-1,'2026-02-21 10:00:39','bb3fe1e2-ba2f-415c-a2f0-e5751f7811cb'),('2026-02-20 10:00:39.722374',NULL,'2026-02-20 10:00:39.735919',479,479,NULL,'57fc4052-56a1-4283-b1aa-d028ee5dba83',98,'8fac2513a3ab4162a13f560c6301f671','gigabytes',-1,'2026-02-21 10:00:39','bb3fe1e2-ba2f-415c-a2f0-e5751f7811cb'),('2026-02-20 10:00:43.142415',NULL,'2026-02-20 10:00:43.177826',480,480,'7e30214830a74d3fb604356b76df7f6d','48a467e6-daa5-4c42-8384-b8798b9ba4c4',143,'39c25a9c9a99474ca081350edaed5ee1','share_networks',1,'2026-02-21 10:00:43',NULL),('2026-02-20 10:00:43.567371',NULL,'2026-02-20 10:00:43.574146',481,481,'7e30214830a74d3fb604356b76df7f6d','c9866d49-a7b2-4233-b8b8-2847ab77ced1',143,'39c25a9c9a99474ca081350edaed5ee1','share_networks',-1,'2026-02-21 10:00:43',NULL),('2026-02-20 10:00:43.623173',NULL,'2026-02-20 10:00:43.670263',482,482,'7e30214830a74d3fb604356b76df7f6d','081f2a2b-5105-49f1-8708-3bc28b90fe18',143,'39c25a9c9a99474ca081350edaed5ee1','share_networks',1,'2026-02-21 10:00:43',NULL),('2026-02-20 10:00:43.949078',NULL,'2026-02-20 10:00:43.955605',483,483,'7e30214830a74d3fb604356b76df7f6d','61a6ea86-1a51-4e80-8517-e063b1cdfa5e',143,'39c25a9c9a99474ca081350edaed5ee1','share_networks',-1,'2026-02-21 10:00:43',NULL),('2026-02-20 10:00:44.050944',NULL,'2026-02-20 10:00:44.087382',484,484,'7e30214830a74d3fb604356b76df7f6d','664c2711-e044-4d00-83ca-1b62044d6234',143,'39c25a9c9a99474ca081350edaed5ee1','share_networks',1,'2026-02-21 10:00:44',NULL),('2026-02-20 10:00:44.461984',NULL,'2026-02-20 10:00:44.467873',485,485,'7e30214830a74d3fb604356b76df7f6d','4546162c-02e5-43a0-a477-d31001729629',143,'39c25a9c9a99474ca081350edaed5ee1','share_networks',-1,'2026-02-21 10:00:44',NULL),('2026-02-20 10:00:46.630954',NULL,'2026-02-20 10:00:46.676307',486,486,'48484ad27c834387b5cd08bd9fa83ba2','a148bd87-e77a-476e-8b8a-9c942b85a010',144,'b025f7e649e14d85948ffdb8dffe9697','shares',1,'2026-02-21 10:00:46',NULL),('2026-02-20 10:00:46.632265',NULL,'2026-02-20 10:00:46.676307',487,487,'48484ad27c834387b5cd08bd9fa83ba2','4c3c5fe8-b053-4508-8b62-06aaa14374ff',145,'b025f7e649e14d85948ffdb8dffe9697','gigabytes',1,'2026-02-21 10:00:46',NULL),('2026-02-20 10:00:46.645621',NULL,'2026-02-20 10:00:46.676307',488,488,NULL,'3a419825-d353-4fef-b89b-8eb810510253',146,'b025f7e649e14d85948ffdb8dffe9697','shares',1,'2026-02-21 10:00:46','80d2aac3-de3a-4505-846d-041b2decb558'),('2026-02-20 10:00:46.647271',NULL,'2026-02-20 10:00:46.676307',489,489,NULL,'af86b74a-4580-464a-b4b5-ae51a543e3b0',147,'b025f7e649e14d85948ffdb8dffe9697','gigabytes',1,'2026-02-21 10:00:46','80d2aac3-de3a-4505-846d-041b2decb558'),('2026-02-20 10:00:48.000141',NULL,'2026-02-20 10:00:48.040909',490,490,'db5b4f7a88fb448daf836f6600f2fbe4','0028ef2f-4cce-468c-b3d9-d0a346a6ce88',148,'9ce5a52649bb4df9a705817aa7ecddca','shares',1,'2026-02-21 10:00:47',NULL),('2026-02-20 10:00:48.005931',NULL,'2026-02-20 10:00:48.040909',491,491,'db5b4f7a88fb448daf836f6600f2fbe4','945cb5f7-b75f-4dc2-be6f-c233dddc0cf9',149,'9ce5a52649bb4df9a705817aa7ecddca','gigabytes',1,'2026-02-21 10:00:47',NULL),('2026-02-20 10:00:48.019103',NULL,'2026-02-20 10:00:48.040909',492,492,NULL,'616eb935-a638-412c-87da-2fad59820054',150,'9ce5a52649bb4df9a705817aa7ecddca','shares',1,'2026-02-21 10:00:47','1053daf4-893c-4900-81d9-0b8d9f20986d'),('2026-02-20 10:00:48.020250',NULL,'2026-02-20 10:00:48.040909',493,493,NULL,'9214b8c8-4344-4c43-82d2-4c715d935175',151,'9ce5a52649bb4df9a705817aa7ecddca','gigabytes',1,'2026-02-21 10:00:47','1053daf4-893c-4900-81d9-0b8d9f20986d'),('2026-02-20 10:00:50.189660',NULL,'2026-02-20 10:00:50.209966',494,494,'48484ad27c834387b5cd08bd9fa83ba2','5ecebe2d-9500-4858-a248-7bc4bac47067',144,'b025f7e649e14d85948ffdb8dffe9697','shares',-1,'2026-02-21 10:00:50',NULL),('2026-02-20 10:00:50.190601',NULL,'2026-02-20 10:00:50.209966',495,495,'48484ad27c834387b5cd08bd9fa83ba2','c342e28e-524c-49b2-b52d-83946bae117c',145,'b025f7e649e14d85948ffdb8dffe9697','gigabytes',-1,'2026-02-21 10:00:50',NULL),('2026-02-20 10:00:50.197771',NULL,'2026-02-20 10:00:50.209966',496,496,NULL,'918567d1-a685-49ea-9e70-7dad5e1ad1c4',146,'b025f7e649e14d85948ffdb8dffe9697','shares',-1,'2026-02-21 10:00:50','80d2aac3-de3a-4505-846d-041b2decb558'),('2026-02-20 10:00:50.198899',NULL,'2026-02-20 10:00:50.209966',497,497,NULL,'c2c947a1-64fa-45b4-8ede-91bbbcb8b33a',147,'b025f7e649e14d85948ffdb8dffe9697','gigabytes',-1,'2026-02-21 10:00:50','80d2aac3-de3a-4505-846d-041b2decb558'),('2026-02-20 10:00:50.284459',NULL,'2026-02-20 10:00:50.330930',498,498,'cde95e9d1bec4875b75ef1941e7ac86f','9eddd7e8-5908-4a94-8d03-6e6fadc90125',152,'af9d55219a474f6a9c5ab0f5d5b13023','share_networks',1,'2026-02-21 10:00:50',NULL),('2026-02-20 10:00:50.311101',NULL,'2026-02-20 10:00:50.355867',499,499,'48484ad27c834387b5cd08bd9fa83ba2','5326cea7-f80b-4ba7-ba0d-8f5d56f9308a',144,'b025f7e649e14d85948ffdb8dffe9697','shares',1,'2026-02-21 10:00:50',NULL),('2026-02-20 10:00:50.312372',NULL,'2026-02-20 10:00:50.355867',500,500,'48484ad27c834387b5cd08bd9fa83ba2','b059d910-5005-485e-a29b-db0219f614a3',145,'b025f7e649e14d85948ffdb8dffe9697','gigabytes',1,'2026-02-21 10:00:50',NULL),('2026-02-20 10:00:50.325442',NULL,'2026-02-20 10:00:50.355867',501,501,NULL,'04518198-a5eb-4c15-a436-a0e9ed3e7c5a',153,'b025f7e649e14d85948ffdb8dffe9697','shares',1,'2026-02-21 10:00:50','1bbbaac3-edbf-47c0-829e-e170ed076081'),('2026-02-20 10:00:50.326634',NULL,'2026-02-20 10:00:50.355867',502,502,NULL,'9d90f9b3-569b-4f67-9621-323ae8859012',154,'b025f7e649e14d85948ffdb8dffe9697','gigabytes',1,'2026-02-21 10:00:50','1bbbaac3-edbf-47c0-829e-e170ed076081'),('2026-02-20 10:00:50.558788',NULL,'2026-02-20 10:00:50.576621',503,503,'cde95e9d1bec4875b75ef1941e7ac86f','29345a99-7a76-45c4-98fb-16d1f231f8b8',152,'af9d55219a474f6a9c5ab0f5d5b13023','share_networks',-1,'2026-02-21 10:00:50',NULL),('2026-02-20 10:00:50.726515',NULL,'2026-02-20 10:00:50.779533',504,504,'cde95e9d1bec4875b75ef1941e7ac86f','2fd84217-1c92-45fb-841a-b9d46ac2e18d',152,'af9d55219a474f6a9c5ab0f5d5b13023','share_networks',1,'2026-02-21 10:00:50',NULL),('2026-02-20 10:00:51.564067',NULL,'2026-02-20 10:00:51.573393',505,505,'cde95e9d1bec4875b75ef1941e7ac86f','2558a177-9bb0-4000-b8e0-bc4b456146bd',152,'af9d55219a474f6a9c5ab0f5d5b13023','share_networks',-1,'2026-02-21 10:00:51',NULL),('2026-02-20 10:00:51.708696',NULL,'2026-02-20 10:00:51.732954',506,506,'cde95e9d1bec4875b75ef1941e7ac86f','fbb71fee-b540-406e-b0e8-fece14b5c1b1',152,'af9d55219a474f6a9c5ab0f5d5b13023','share_networks',1,'2026-02-21 10:00:51',NULL),('2026-02-20 10:00:51.809581',NULL,'2026-02-20 10:00:51.817958',507,507,'cde95e9d1bec4875b75ef1941e7ac86f','6151f948-605d-4aae-961c-5829cea2cbbb',152,'af9d55219a474f6a9c5ab0f5d5b13023','share_networks',-1,'2026-02-21 10:00:51',NULL),('2026-02-20 10:00:53.585296',NULL,'2026-02-20 10:00:53.600724',508,508,'db5b4f7a88fb448daf836f6600f2fbe4','b4a50e05-10d4-4e79-bbfc-93372a323ef0',148,'9ce5a52649bb4df9a705817aa7ecddca','shares',-1,'2026-02-21 10:00:53',NULL),('2026-02-20 10:00:53.586231',NULL,'2026-02-20 10:00:53.600724',509,509,'db5b4f7a88fb448daf836f6600f2fbe4','b5646437-caa6-4c9b-8af1-b3c3e8cb0b08',149,'9ce5a52649bb4df9a705817aa7ecddca','gigabytes',-1,'2026-02-21 10:00:53',NULL),('2026-02-20 10:00:53.592930',NULL,'2026-02-20 10:00:53.600724',510,510,NULL,'eb05581e-526b-40c9-8943-c101d4c53089',150,'9ce5a52649bb4df9a705817aa7ecddca','shares',-1,'2026-02-21 10:00:53','1053daf4-893c-4900-81d9-0b8d9f20986d'),('2026-02-20 10:00:53.593669',NULL,'2026-02-20 10:00:53.600724',511,511,NULL,'6a831743-4372-46ff-84ff-b663fa089fb4',151,'9ce5a52649bb4df9a705817aa7ecddca','gigabytes',-1,'2026-02-21 10:00:53','1053daf4-893c-4900-81d9-0b8d9f20986d'),('2026-02-20 10:00:53.852825',NULL,'2026-02-20 10:00:53.868832',512,512,'48484ad27c834387b5cd08bd9fa83ba2','e7908848-6e4e-4680-9ed0-a88b50207de1',144,'b025f7e649e14d85948ffdb8dffe9697','shares',-1,'2026-02-21 10:00:53',NULL),('2026-02-20 10:00:53.854126',NULL,'2026-02-20 10:00:53.868832',513,513,'48484ad27c834387b5cd08bd9fa83ba2','2f5a7c46-ab19-442d-85f4-a9fd6e4bdca9',145,'b025f7e649e14d85948ffdb8dffe9697','gigabytes',-1,'2026-02-21 10:00:53',NULL),('2026-02-20 10:00:53.859038',NULL,'2026-02-20 10:00:53.868832',514,514,NULL,'1e843482-926d-4b33-a614-f7c2913e26a8',153,'b025f7e649e14d85948ffdb8dffe9697','shares',-1,'2026-02-21 10:00:53','1bbbaac3-edbf-47c0-829e-e170ed076081'),('2026-02-20 10:00:53.859636',NULL,'2026-02-20 10:00:53.868832',515,515,NULL,'f15473eb-3809-4363-a1d9-0707106dbe3f',154,'b025f7e649e14d85948ffdb8dffe9697','gigabytes',-1,'2026-02-21 10:00:53','1bbbaac3-edbf-47c0-829e-e170ed076081'),('2026-02-20 10:00:53.960794',NULL,'2026-02-20 10:00:54.026738',516,516,'48484ad27c834387b5cd08bd9fa83ba2','9f7b5b20-cdd1-4008-869a-d8847d297c51',144,'b025f7e649e14d85948ffdb8dffe9697','shares',1,'2026-02-21 10:00:53',NULL),('2026-02-20 10:00:53.961971',NULL,'2026-02-20 10:00:54.026738',517,517,'48484ad27c834387b5cd08bd9fa83ba2','0295fc74-2991-4af1-99ae-a59a3369a523',145,'b025f7e649e14d85948ffdb8dffe9697','gigabytes',1,'2026-02-21 10:00:53',NULL),('2026-02-20 10:00:53.978951',NULL,'2026-02-20 10:00:54.026738',518,518,NULL,'9ec7b8cd-e937-4131-865c-90589fa0a87e',155,'b025f7e649e14d85948ffdb8dffe9697','shares',1,'2026-02-21 10:00:53','e29102ba-e6d4-44ff-9288-84a47b6b5157'),('2026-02-20 10:00:53.980074',NULL,'2026-02-20 10:00:54.026738',519,519,NULL,'749e1934-7724-4efe-a3f2-64b2f4c3068c',156,'b025f7e649e14d85948ffdb8dffe9697','gigabytes',1,'2026-02-21 10:00:53','e29102ba-e6d4-44ff-9288-84a47b6b5157'),('2026-02-20 10:00:57.646538',NULL,'2026-02-20 10:00:57.666979',520,520,'48484ad27c834387b5cd08bd9fa83ba2','bc5179ea-41ab-49d4-b018-75ca879ce261',144,'b025f7e649e14d85948ffdb8dffe9697','shares',-1,'2026-02-21 10:00:57',NULL),('2026-02-20 10:00:57.647546',NULL,'2026-02-20 10:00:57.666979',521,521,'48484ad27c834387b5cd08bd9fa83ba2','5fa0191d-9d65-4a14-b9cd-bd5da704abe4',145,'b025f7e649e14d85948ffdb8dffe9697','gigabytes',-1,'2026-02-21 10:00:57',NULL),('2026-02-20 10:00:57.655496',NULL,'2026-02-20 10:00:57.666979',522,522,NULL,'458804c2-1fe4-4a52-b7e4-f8192295f565',155,'b025f7e649e14d85948ffdb8dffe9697','shares',-1,'2026-02-21 10:00:57','e29102ba-e6d4-44ff-9288-84a47b6b5157'),('2026-02-20 10:00:57.657182',NULL,'2026-02-20 10:00:57.666979',523,523,NULL,'1a25586a-3a8f-4bc3-b884-1b22080a30d3',156,'b025f7e649e14d85948ffdb8dffe9697','gigabytes',-1,'2026-02-21 10:00:57','e29102ba-e6d4-44ff-9288-84a47b6b5157'),('2026-02-20 10:00:57.996509',NULL,'2026-02-20 10:00:58.033688',524,524,'48484ad27c834387b5cd08bd9fa83ba2','0a6d1227-ae16-4d92-8a61-bc9c75b0002c',144,'b025f7e649e14d85948ffdb8dffe9697','shares',1,'2026-02-21 10:00:57',NULL),('2026-02-20 10:00:57.997633',NULL,'2026-02-20 10:00:58.033688',525,525,'48484ad27c834387b5cd08bd9fa83ba2','5f0462e3-4fd9-4d5e-b801-a94c546813f9',145,'b025f7e649e14d85948ffdb8dffe9697','gigabytes',1,'2026-02-21 10:00:57',NULL),('2026-02-20 10:00:58.010135',NULL,'2026-02-20 10:00:58.033688',526,526,NULL,'caeac22e-32ba-4a92-a720-838d59dceea5',158,'b025f7e649e14d85948ffdb8dffe9697','shares',1,'2026-02-21 10:00:57','702ce432-33c7-4e10-a03f-0854457649ac'),('2026-02-20 10:00:58.012103',NULL,'2026-02-20 10:00:58.033688',527,527,NULL,'bb00f684-98db-462c-9f3b-c34bb1ef1b02',157,'b025f7e649e14d85948ffdb8dffe9697','gigabytes',1,'2026-02-21 10:00:57','702ce432-33c7-4e10-a03f-0854457649ac'),('2026-02-20 10:00:59.799388',NULL,'2026-02-20 10:00:59.836380',528,528,'82f001ca71d44f64a2f5d622ba81e489','3c8a6bc3-c273-4344-9721-b59e183a054b',159,'766977986b8d4935995086e1b7f48c1d','shares',1,'2026-02-21 10:00:59',NULL),('2026-02-20 10:00:59.800425',NULL,'2026-02-20 10:00:59.836380',529,529,'82f001ca71d44f64a2f5d622ba81e489','cc9d6e9e-86ad-4734-a0c4-bcb38ea5d7aa',160,'766977986b8d4935995086e1b7f48c1d','gigabytes',1,'2026-02-21 10:00:59',NULL),('2026-02-20 10:00:59.811611',NULL,'2026-02-20 10:00:59.836380',530,530,NULL,'5b3f7dcf-1f95-4782-850b-905dc8ec420e',161,'766977986b8d4935995086e1b7f48c1d','shares',1,'2026-02-21 10:00:59','7e9bd417-8002-4d0b-99cc-e6bed442b5be'),('2026-02-20 10:00:59.812601',NULL,'2026-02-20 10:00:59.836380',531,531,NULL,'feb0963e-011a-4978-995f-0108c8716b93',162,'766977986b8d4935995086e1b7f48c1d','gigabytes',1,'2026-02-21 10:00:59','7e9bd417-8002-4d0b-99cc-e6bed442b5be'),('2026-02-20 10:01:03.047525',NULL,'2026-02-20 10:01:03.156890',532,532,'82f001ca71d44f64a2f5d622ba81e489','a71fbe85-53a7-4096-b21d-a9959795cde7',164,'766977986b8d4935995086e1b7f48c1d','snapshots',1,'2026-02-21 10:01:03',NULL),('2026-02-20 10:01:03.048679',NULL,'2026-02-20 10:01:03.156890',533,533,'82f001ca71d44f64a2f5d622ba81e489','f087b741-d568-48fb-b987-d5bfc62377be',163,'766977986b8d4935995086e1b7f48c1d','snapshot_gigabytes',1,'2026-02-21 10:01:03',NULL),('2026-02-20 10:01:03.058159',NULL,'2026-02-20 10:01:03.156890',534,534,NULL,'8e3ab40d-c1c2-43b1-a2e9-c82f679a4aaf',166,'766977986b8d4935995086e1b7f48c1d','snapshots',1,'2026-02-21 10:01:03','7e9bd417-8002-4d0b-99cc-e6bed442b5be'),('2026-02-20 10:01:03.059344',NULL,'2026-02-20 10:01:03.156890',535,535,NULL,'43b11795-a98e-4cfd-a6d0-1561f6a4075e',165,'766977986b8d4935995086e1b7f48c1d','snapshot_gigabytes',1,'2026-02-21 10:01:03','7e9bd417-8002-4d0b-99cc-e6bed442b5be'),('2026-02-20 10:01:04.417066',NULL,'2026-02-20 10:01:04.441009',536,536,'48484ad27c834387b5cd08bd9fa83ba2','fdd6f036-c52d-4f0c-85b0-0b859fa26293',144,'b025f7e649e14d85948ffdb8dffe9697','shares',-1,'2026-02-21 10:01:04',NULL),('2026-02-20 10:01:04.417883',NULL,'2026-02-20 10:01:04.441009',537,537,'48484ad27c834387b5cd08bd9fa83ba2','dc446052-6126-45ee-b6ad-236337bbb81c',145,'b025f7e649e14d85948ffdb8dffe9697','gigabytes',-1,'2026-02-21 10:01:04',NULL),('2026-02-20 10:01:04.424374',NULL,'2026-02-20 10:01:04.441009',538,538,NULL,'dd6a8866-3eaf-47d3-9e99-7513fbbff36a',158,'b025f7e649e14d85948ffdb8dffe9697','shares',-1,'2026-02-21 10:01:04','702ce432-33c7-4e10-a03f-0854457649ac'),('2026-02-20 10:01:04.425433',NULL,'2026-02-20 10:01:04.441009',539,539,NULL,'8985e890-b81f-46b9-b487-7fb5326e01f9',157,'b025f7e649e14d85948ffdb8dffe9697','gigabytes',-1,'2026-02-21 10:01:04','702ce432-33c7-4e10-a03f-0854457649ac'),('2026-02-20 10:01:04.536909',NULL,'2026-02-20 10:01:04.579442',540,540,'48484ad27c834387b5cd08bd9fa83ba2','d27b4aa4-3bdf-4218-ac47-73ebc510077c',144,'b025f7e649e14d85948ffdb8dffe9697','shares',1,'2026-02-21 10:01:04',NULL),('2026-02-20 10:01:04.538134',NULL,'2026-02-20 10:01:04.579442',541,541,'48484ad27c834387b5cd08bd9fa83ba2','f1ce696c-e3cb-4e85-8756-81f9795239c8',145,'b025f7e649e14d85948ffdb8dffe9697','gigabytes',1,'2026-02-21 10:01:04',NULL),('2026-02-20 10:01:04.548947',NULL,'2026-02-20 10:01:04.579442',542,542,NULL,'9ed570c7-bd23-454f-842e-cba9d2cd4ab5',167,'b025f7e649e14d85948ffdb8dffe9697','shares',1,'2026-02-21 10:01:04','34001302-113e-451c-849b-0ac909a65c2d'),('2026-02-20 10:01:04.550319',NULL,'2026-02-20 10:01:04.579442',543,543,NULL,'763bcf52-5a14-45c4-b4b9-59b6ac5283ef',168,'b025f7e649e14d85948ffdb8dffe9697','gigabytes',1,'2026-02-21 10:01:04','34001302-113e-451c-849b-0ac909a65c2d'),('2026-02-20 10:01:06.552378',NULL,'2026-02-20 10:01:06.581095',544,544,'82f001ca71d44f64a2f5d622ba81e489','fb47ed05-d21f-49c7-b127-8ecab2a21048',159,'766977986b8d4935995086e1b7f48c1d','shares',1,'2026-02-21 10:01:06',NULL),('2026-02-20 10:01:06.553815',NULL,'2026-02-20 10:01:06.581095',545,545,'82f001ca71d44f64a2f5d622ba81e489','c9406770-969e-4737-8129-5c862ef2044b',160,'766977986b8d4935995086e1b7f48c1d','gigabytes',1,'2026-02-21 10:01:06',NULL),('2026-02-20 10:01:06.559528',NULL,'2026-02-20 10:01:06.581095',546,546,NULL,'48b27585-c9ee-4d2f-9dda-72d4997a529e',161,'766977986b8d4935995086e1b7f48c1d','shares',1,'2026-02-21 10:01:06','7e9bd417-8002-4d0b-99cc-e6bed442b5be'),('2026-02-20 10:01:06.560526',NULL,'2026-02-20 10:01:06.581095',547,547,NULL,'4cba093a-d62a-4579-85ad-f6d6799ab440',162,'766977986b8d4935995086e1b7f48c1d','gigabytes',1,'2026-02-21 10:01:06','7e9bd417-8002-4d0b-99cc-e6bed442b5be'),('2026-02-20 10:01:08.999038',NULL,'2026-02-20 10:01:09.036481',548,548,'5eff6a7d4a954420a1461705b5b4d25e','31e40f63-04ab-4fb7-a796-a97a98a2f9dc',170,'8e04bc360fa14db4a793bc5de7a0a299','shares',1,'2026-02-21 10:01:08',NULL),('2026-02-20 10:01:09.000643',NULL,'2026-02-20 10:01:09.036481',549,549,'5eff6a7d4a954420a1461705b5b4d25e','956a5fef-38d0-46f7-8aef-1e5286b402d0',169,'8e04bc360fa14db4a793bc5de7a0a299','gigabytes',1,'2026-02-21 10:01:08',NULL),('2026-02-20 10:01:09.006298',NULL,'2026-02-20 10:01:09.036481',550,550,NULL,'ba717024-5434-4fa5-8850-8ac99f44f3f6',63,'8e04bc360fa14db4a793bc5de7a0a299','shares',1,'2026-02-21 10:01:08','48a549b7-2e24-48b0-bf7b-3dffd39b684c'),('2026-02-20 10:01:09.007510',NULL,'2026-02-20 10:01:09.036481',551,551,NULL,'ad172499-087c-4790-9fd4-0f94020a3d4b',62,'8e04bc360fa14db4a793bc5de7a0a299','gigabytes',1,'2026-02-21 10:01:08','48a549b7-2e24-48b0-bf7b-3dffd39b684c'),('2026-02-20 10:01:10.935326',NULL,'2026-02-20 10:01:10.950327',552,552,'48484ad27c834387b5cd08bd9fa83ba2','58609c50-796d-4d3d-bec3-8adb0fbf2b60',144,'b025f7e649e14d85948ffdb8dffe9697','shares',-1,'2026-02-21 10:01:10',NULL),('2026-02-20 10:01:10.936181',NULL,'2026-02-20 10:01:10.950327',553,553,'48484ad27c834387b5cd08bd9fa83ba2','e3545666-5a55-49fb-adf2-26199e330c7c',145,'b025f7e649e14d85948ffdb8dffe9697','gigabytes',-1,'2026-02-21 10:01:10',NULL),('2026-02-20 10:01:10.941432',NULL,'2026-02-20 10:01:10.950327',554,554,NULL,'882d8926-5054-4086-bce5-5d33802dc5f5',167,'b025f7e649e14d85948ffdb8dffe9697','shares',-1,'2026-02-21 10:01:10','34001302-113e-451c-849b-0ac909a65c2d'),('2026-02-20 10:01:10.942172',NULL,'2026-02-20 10:01:10.950327',555,555,NULL,'058e4c47-ce8f-452d-b356-97d450bfeb8a',168,'b025f7e649e14d85948ffdb8dffe9697','gigabytes',-1,'2026-02-21 10:01:10','34001302-113e-451c-849b-0ac909a65c2d'),('2026-02-20 10:01:14.697481',NULL,'2026-02-20 10:01:14.749766',556,556,'2e3a1a07e08b45baa885977013071b9f','c99938c5-75a7-46b8-9b90-b9430a5aec68',171,'e8035fa10e5f4d1aae154d58e76a9729','share_networks',1,'2026-02-21 10:01:14',NULL),('2026-02-20 10:01:21.195993',NULL,'2026-02-20 10:01:21.240375',557,557,'566b3c30231242a295579c321ac55f13','f5dfd75d-d3fe-434f-9bcc-084b89675ba4',173,'72f6de9a4d894029be8ca744061d09cb','shares',1,'2026-02-21 10:01:21',NULL),('2026-02-20 10:01:21.197891',NULL,'2026-02-20 10:01:21.240375',558,558,'566b3c30231242a295579c321ac55f13','16f74bd4-5502-4a0f-ad4e-19eb9a992e06',172,'72f6de9a4d894029be8ca744061d09cb','gigabytes',1,'2026-02-21 10:01:21',NULL),('2026-02-20 10:01:21.210964',NULL,'2026-02-20 10:01:21.240375',559,559,NULL,'133af188-4551-42da-bc6e-c643a22520f4',175,'72f6de9a4d894029be8ca744061d09cb','shares',1,'2026-02-21 10:01:21','3ed40b83-b9f0-43a5-b9a1-5fc31174a2a4'),('2026-02-20 10:01:21.212096',NULL,'2026-02-20 10:01:21.240375',560,560,NULL,'9f63c457-d6c6-4430-b14e-1de02e43336d',174,'72f6de9a4d894029be8ca744061d09cb','gigabytes',1,'2026-02-21 10:01:21','3ed40b83-b9f0-43a5-b9a1-5fc31174a2a4'),('2026-02-20 10:01:22.861851',NULL,'2026-02-20 10:01:22.880987',561,561,'5eff6a7d4a954420a1461705b5b4d25e','20152c36-30f6-46f5-b4c1-55dc12639bea',170,'8e04bc360fa14db4a793bc5de7a0a299','shares',-1,'2026-02-21 10:01:22',NULL),('2026-02-20 10:01:22.862822',NULL,'2026-02-20 10:01:22.880987',562,562,'5eff6a7d4a954420a1461705b5b4d25e','e42cbf9f-8521-4ef5-8be0-ae54348e8509',169,'8e04bc360fa14db4a793bc5de7a0a299','gigabytes',-1,'2026-02-21 10:01:22',NULL),('2026-02-20 10:01:22.868028',NULL,'2026-02-20 10:01:22.880987',563,563,NULL,'55b4667d-a98f-4816-b222-87724f482d48',63,'8e04bc360fa14db4a793bc5de7a0a299','shares',-1,'2026-02-21 10:01:22','48a549b7-2e24-48b0-bf7b-3dffd39b684c'),('2026-02-20 10:01:22.868994',NULL,'2026-02-20 10:01:22.880987',564,564,NULL,'308c5dff-d10c-4333-9eb3-45da1729ac36',62,'8e04bc360fa14db4a793bc5de7a0a299','gigabytes',-1,'2026-02-21 10:01:22','48a549b7-2e24-48b0-bf7b-3dffd39b684c'),('2026-02-20 10:01:24.501001',NULL,'2026-02-20 10:01:24.577089',565,565,'566b3c30231242a295579c321ac55f13','b9294671-ec67-4054-a6f6-c9a31a1a2c03',177,'72f6de9a4d894029be8ca744061d09cb','snapshots',1,'2026-02-21 10:01:24',NULL),('2026-02-20 10:01:24.503129',NULL,'2026-02-20 10:01:24.577089',566,566,'566b3c30231242a295579c321ac55f13','4d1f4883-aee5-4eb6-aef4-a763ce677ba1',176,'72f6de9a4d894029be8ca744061d09cb','snapshot_gigabytes',1,'2026-02-21 10:01:24',NULL),('2026-02-20 10:01:24.513825',NULL,'2026-02-20 10:01:24.577089',567,567,NULL,'f783dc83-9bbe-4b4e-8170-37fd42dd5b0e',179,'72f6de9a4d894029be8ca744061d09cb','snapshots',1,'2026-02-21 10:01:24','3ed40b83-b9f0-43a5-b9a1-5fc31174a2a4'),('2026-02-20 10:01:24.515078',NULL,'2026-02-20 10:01:24.577089',568,568,NULL,'9591eb13-37de-4fff-a40c-1c935e3f477e',178,'72f6de9a4d894029be8ca744061d09cb','snapshot_gigabytes',1,'2026-02-21 10:01:24','3ed40b83-b9f0-43a5-b9a1-5fc31174a2a4'),('2026-02-20 10:01:26.079881',NULL,'2026-02-20 10:01:26.094037',569,569,'c744dea67e504ed8bbe87eb5b0c1fc1e','d28cf184-3342-47a9-a3fd-63273d157545',61,'8e04bc360fa14db4a793bc5de7a0a299','shares',-1,'2026-02-21 10:01:26',NULL),('2026-02-20 10:01:26.080678',NULL,'2026-02-20 10:01:26.094037',570,570,'c744dea67e504ed8bbe87eb5b0c1fc1e','ffa364b0-f2c6-49fe-b74b-0f92bed5657f',60,'8e04bc360fa14db4a793bc5de7a0a299','gigabytes',-1,'2026-02-21 10:01:26',NULL),('2026-02-20 10:01:26.085906',NULL,'2026-02-20 10:01:26.094037',571,571,NULL,'e023fb08-0fe5-4c9d-9b39-e7199075105e',63,'8e04bc360fa14db4a793bc5de7a0a299','shares',-1,'2026-02-21 10:01:26','48a549b7-2e24-48b0-bf7b-3dffd39b684c'),('2026-02-20 10:01:26.086657',NULL,'2026-02-20 10:01:26.094037',572,572,NULL,'f56c3749-931b-4344-83d3-81a00341125b',62,'8e04bc360fa14db4a793bc5de7a0a299','gigabytes',-1,'2026-02-21 10:01:26','48a549b7-2e24-48b0-bf7b-3dffd39b684c'),('2026-02-20 10:01:28.088961',NULL,'2026-02-20 10:01:28.117546',573,573,'e4c734194bfd45018fd58baabce64bf6','66373597-45d6-4b14-a2b1-eb90ebe719d8',180,'ad1dd0d43ec7421b9a4a06c39e3657c6','shares',1,'2026-02-21 10:01:28',NULL),('2026-02-20 10:01:28.090052',NULL,'2026-02-20 10:01:28.117546',574,574,'e4c734194bfd45018fd58baabce64bf6','8cc19c31-47bd-4810-8498-eb330e1b52bd',181,'ad1dd0d43ec7421b9a4a06c39e3657c6','gigabytes',1,'2026-02-21 10:01:28',NULL),('2026-02-20 10:01:28.099040',NULL,'2026-02-20 10:01:28.117546',575,575,NULL,'7b0e1a2e-9146-42c0-8125-30953730781a',182,'ad1dd0d43ec7421b9a4a06c39e3657c6','shares',1,'2026-02-21 10:01:28','3e721ad7-11c2-42cf-956f-5aeeed7d1d0a'),('2026-02-20 10:01:28.100295',NULL,'2026-02-20 10:01:28.117546',576,576,NULL,'704475d6-dec6-4a2a-9612-da2086d552de',183,'ad1dd0d43ec7421b9a4a06c39e3657c6','gigabytes',1,'2026-02-21 10:01:28','3e721ad7-11c2-42cf-956f-5aeeed7d1d0a'),('2026-02-20 10:01:28.145383',NULL,'2026-02-20 10:01:28.192895',577,577,'566b3c30231242a295579c321ac55f13','2cb7de49-a5f8-4fa9-97a2-ed73e455565a',177,'72f6de9a4d894029be8ca744061d09cb','snapshots',-1,'2026-02-21 10:01:28',NULL),('2026-02-20 10:01:28.146354',NULL,'2026-02-20 10:01:28.192895',578,578,'566b3c30231242a295579c321ac55f13','3fc25a86-7f33-4232-97a8-042a40838503',176,'72f6de9a4d894029be8ca744061d09cb','snapshot_gigabytes',-1,'2026-02-21 10:01:28',NULL),('2026-02-20 10:01:28.161223',NULL,'2026-02-20 10:01:28.192895',579,579,NULL,'341f1979-d886-4e00-a579-9a664dd2a4ce',179,'72f6de9a4d894029be8ca744061d09cb','snapshots',-1,'2026-02-21 10:01:28','3ed40b83-b9f0-43a5-b9a1-5fc31174a2a4'),('2026-02-20 10:01:28.162871',NULL,'2026-02-20 10:01:28.192895',580,580,NULL,'41e0e50d-fbce-42db-9c49-90a3a22a8c7e',178,'72f6de9a4d894029be8ca744061d09cb','snapshot_gigabytes',-1,'2026-02-21 10:01:28','3ed40b83-b9f0-43a5-b9a1-5fc31174a2a4'),('2026-02-20 10:01:29.849724',NULL,'2026-02-20 10:01:29.882104',581,581,'596b7db794ec4a1ba2829af4b784b600','12ed7e9b-4a5a-4028-bafb-1945d51f2259',184,'8379be9e0a0543189f94c822f9c76f3f','shares',1,'2026-02-21 10:01:29',NULL),('2026-02-20 10:01:29.850928',NULL,'2026-02-20 10:01:29.882104',582,582,'596b7db794ec4a1ba2829af4b784b600','880052b5-2d92-4c8a-bb6c-05b5f21c1629',185,'8379be9e0a0543189f94c822f9c76f3f','gigabytes',1,'2026-02-21 10:01:29',NULL),('2026-02-20 10:01:29.862004',NULL,'2026-02-20 10:01:29.882104',583,583,NULL,'602ab056-6b80-44ba-b1b9-e64ada38e16c',186,'8379be9e0a0543189f94c822f9c76f3f','shares',1,'2026-02-21 10:01:29','dc030d02-f047-43f1-b057-eeeb15059384'),('2026-02-20 10:01:29.863163',NULL,'2026-02-20 10:01:29.882104',584,584,NULL,'c61c09a8-8a9c-4c71-9910-7d883c8fda9a',187,'8379be9e0a0543189f94c822f9c76f3f','gigabytes',1,'2026-02-21 10:01:29','dc030d02-f047-43f1-b057-eeeb15059384'),('2026-02-20 10:01:31.413725',NULL,'2026-02-20 10:01:31.440832',585,585,'566b3c30231242a295579c321ac55f13','0865e374-bd85-432a-8c81-4efdd4c44570',173,'72f6de9a4d894029be8ca744061d09cb','shares',-1,'2026-02-21 10:01:31',NULL),('2026-02-20 10:01:31.414590',NULL,'2026-02-20 10:01:31.440832',586,586,'566b3c30231242a295579c321ac55f13','1f445d31-caf1-43eb-a1e7-5d5f458c259f',172,'72f6de9a4d894029be8ca744061d09cb','gigabytes',-1,'2026-02-21 10:01:31',NULL),('2026-02-20 10:01:31.424671',NULL,'2026-02-20 10:01:31.440832',587,587,NULL,'70f6f11d-395d-4ab5-9814-71167245f315',175,'72f6de9a4d894029be8ca744061d09cb','shares',-1,'2026-02-21 10:01:31','3ed40b83-b9f0-43a5-b9a1-5fc31174a2a4'),('2026-02-20 10:01:31.425766',NULL,'2026-02-20 10:01:31.440832',588,588,NULL,'4523bf99-f243-481a-b411-283c7b0c6567',174,'72f6de9a4d894029be8ca744061d09cb','gigabytes',-1,'2026-02-21 10:01:31','3ed40b83-b9f0-43a5-b9a1-5fc31174a2a4'),('2026-02-20 10:01:31.873415',NULL,'2026-02-20 10:01:31.904983',589,589,'e4c734194bfd45018fd58baabce64bf6','f8986c26-aff1-411d-bf75-3929169bcf16',180,'ad1dd0d43ec7421b9a4a06c39e3657c6','shares',1,'2026-02-21 10:01:31',NULL),('2026-02-20 10:01:31.874489',NULL,'2026-02-20 10:01:31.904983',590,590,'e4c734194bfd45018fd58baabce64bf6','040672e7-7dc6-4f77-98d7-8f6d8c71ce24',181,'ad1dd0d43ec7421b9a4a06c39e3657c6','gigabytes',1,'2026-02-21 10:01:31',NULL),('2026-02-20 10:01:31.879300',NULL,'2026-02-20 10:01:31.904983',591,591,NULL,'4b58b8a2-f601-4751-ae84-54db37382053',182,'ad1dd0d43ec7421b9a4a06c39e3657c6','shares',1,'2026-02-21 10:01:31','3e721ad7-11c2-42cf-956f-5aeeed7d1d0a'),('2026-02-20 10:01:31.880601',NULL,'2026-02-20 10:01:31.904983',592,592,NULL,'977b0fd2-d935-40d5-b37d-e75182c884d6',183,'ad1dd0d43ec7421b9a4a06c39e3657c6','gigabytes',1,'2026-02-21 10:01:31','3e721ad7-11c2-42cf-956f-5aeeed7d1d0a'),('2026-02-20 10:01:33.066103',NULL,'2026-02-20 10:01:33.157487',593,593,'596b7db794ec4a1ba2829af4b784b600','c19b58a7-4638-44f3-8b0b-7d9aa8cc47e9',188,'8379be9e0a0543189f94c822f9c76f3f','snapshots',1,'2026-02-21 10:01:33',NULL),('2026-02-20 10:01:33.067913',NULL,'2026-02-20 10:01:33.157487',594,594,'596b7db794ec4a1ba2829af4b784b600','9ab88f5f-3be9-41a1-a359-3f79b9745334',189,'8379be9e0a0543189f94c822f9c76f3f','snapshot_gigabytes',1,'2026-02-21 10:01:33',NULL),('2026-02-20 10:01:33.079212',NULL,'2026-02-20 10:01:33.157487',595,595,NULL,'ddc63857-5ab0-403e-abc2-4340bf0bd70a',190,'8379be9e0a0543189f94c822f9c76f3f','snapshots',1,'2026-02-21 10:01:33','dc030d02-f047-43f1-b057-eeeb15059384'),('2026-02-20 10:01:33.080558',NULL,'2026-02-20 10:01:33.157487',596,596,NULL,'88ba3df3-38f6-4a9f-8bf0-f1e3d0a40cd7',191,'8379be9e0a0543189f94c822f9c76f3f','snapshot_gigabytes',1,'2026-02-21 10:01:33','dc030d02-f047-43f1-b057-eeeb15059384'),('2026-02-20 10:01:34.285220',NULL,'2026-02-20 10:01:34.350315',597,597,'566b3c30231242a295579c321ac55f13','8f522df2-8651-41bb-a9f7-923941f394b2',173,'72f6de9a4d894029be8ca744061d09cb','shares',1,'2026-02-21 10:01:34',NULL),('2026-02-20 10:01:34.286523',NULL,'2026-02-20 10:01:34.350315',598,598,'566b3c30231242a295579c321ac55f13','086ce601-275d-401d-8258-bdfdfee5f6b9',172,'72f6de9a4d894029be8ca744061d09cb','gigabytes',1,'2026-02-21 10:01:34',NULL),('2026-02-20 10:01:34.298982',NULL,'2026-02-20 10:01:34.350315',599,599,NULL,'7bd9505e-6b12-4828-b8c3-fc7bae8d6048',192,'72f6de9a4d894029be8ca744061d09cb','shares',1,'2026-02-21 10:01:34','15f2a171-553f-4457-9f33-a8801a176b4d'),('2026-02-20 10:01:34.301231',NULL,'2026-02-20 10:01:34.350315',600,600,NULL,'74e74761-7728-4f69-af78-c3e2c8e3cf40',193,'72f6de9a4d894029be8ca744061d09cb','gigabytes',1,'2026-02-21 10:01:34','15f2a171-553f-4457-9f33-a8801a176b4d'),('2026-02-20 10:01:35.358112',NULL,'2026-02-20 10:01:35.406270',601,601,'6e0a1e0ae3534b38bf1af0ecef725e03','b2b4e49a-1a14-4f22-af34-3577a5b4dfa6',195,'fa5f5f12701349488e6f9e875b4ddfa7','shares',1,'2026-02-21 10:01:35',NULL),('2026-02-20 10:01:35.360850',NULL,'2026-02-20 10:01:35.406270',602,602,'6e0a1e0ae3534b38bf1af0ecef725e03','714d2682-e165-4ef2-bf46-51c5de256766',194,'fa5f5f12701349488e6f9e875b4ddfa7','gigabytes',1,'2026-02-21 10:01:35',NULL),('2026-02-20 10:01:35.373189',NULL,'2026-02-20 10:01:35.406270',603,603,NULL,'5c170c03-8f86-49cb-bb9f-13c71c76f236',197,'fa5f5f12701349488e6f9e875b4ddfa7','shares',1,'2026-02-21 10:01:35','01aa61b1-cd56-4424-9115-78005fa90d7f'),('2026-02-20 10:01:35.375093',NULL,'2026-02-20 10:01:35.406270',604,604,NULL,'e0770acb-bcb4-4579-906b-9508c7a9ba2f',196,'fa5f5f12701349488e6f9e875b4ddfa7','gigabytes',1,'2026-02-21 10:01:35','01aa61b1-cd56-4424-9115-78005fa90d7f'),('2026-02-20 10:01:36.740795',NULL,'2026-02-20 10:01:36.784342',605,605,'345374ef0e4d4f488e63abd7bfa28b3f','cd48ccb1-e3ed-47f8-9ebe-a6e9706edf2b',198,'a986e1cee42e4d20a367d286ff5b4908','shares',1,'2026-02-21 10:01:36',NULL),('2026-02-20 10:01:36.742225',NULL,'2026-02-20 10:01:36.784342',606,606,'345374ef0e4d4f488e63abd7bfa28b3f','daf95f1b-2b14-4ede-bf82-58df0473bf21',199,'a986e1cee42e4d20a367d286ff5b4908','gigabytes',1,'2026-02-21 10:01:36',NULL),('2026-02-20 10:01:36.758589',NULL,'2026-02-20 10:01:36.784342',607,607,NULL,'949209fd-6632-4dbe-b8a1-7b9094f004aa',200,'a986e1cee42e4d20a367d286ff5b4908','shares',1,'2026-02-21 10:01:36','5a602670-2636-4d3f-a77e-f4467759e162'),('2026-02-20 10:01:36.761394',NULL,'2026-02-20 10:01:36.784342',608,608,NULL,'b25ae2f2-32b3-4b2f-8df3-2ac21e45cfc1',201,'a986e1cee42e4d20a367d286ff5b4908','gigabytes',1,'2026-02-21 10:01:36','5a602670-2636-4d3f-a77e-f4467759e162'),('2026-02-20 10:01:37.377816',NULL,'2026-02-20 10:01:37.403432',609,609,'596b7db794ec4a1ba2829af4b784b600','4f48e8f2-f839-499f-a2d6-0f1460a4bc0e',188,'8379be9e0a0543189f94c822f9c76f3f','snapshots',-1,'2026-02-21 10:01:37',NULL),('2026-02-20 10:01:37.380260',NULL,'2026-02-20 10:01:37.403432',610,610,'596b7db794ec4a1ba2829af4b784b600','9a66dfa0-a228-4373-9158-6e25fa65bf61',189,'8379be9e0a0543189f94c822f9c76f3f','snapshot_gigabytes',-1,'2026-02-21 10:01:37',NULL),('2026-02-20 10:01:37.388828',NULL,'2026-02-20 10:01:37.403432',611,611,NULL,'2bcfa229-607a-47b0-af49-cc5b8654f9aa',190,'8379be9e0a0543189f94c822f9c76f3f','snapshots',-1,'2026-02-21 10:01:37','dc030d02-f047-43f1-b057-eeeb15059384'),('2026-02-20 10:01:37.390429',NULL,'2026-02-20 10:01:37.403432',612,612,NULL,'dd7e60fe-1dfc-4d41-9d13-15029988c8ff',191,'8379be9e0a0543189f94c822f9c76f3f','snapshot_gigabytes',-1,'2026-02-21 10:01:37','dc030d02-f047-43f1-b057-eeeb15059384'),('2026-02-20 10:01:37.973792',NULL,'2026-02-20 10:01:37.985918',613,613,'566b3c30231242a295579c321ac55f13','39a0d1d3-be64-438f-8c2d-79f423473d9f',173,'72f6de9a4d894029be8ca744061d09cb','shares',-1,'2026-02-21 10:01:37',NULL),('2026-02-20 10:01:37.974604',NULL,'2026-02-20 10:01:37.985918',614,614,'566b3c30231242a295579c321ac55f13','594327fe-3e79-4e1f-ac8a-aba125f45bf6',172,'72f6de9a4d894029be8ca744061d09cb','gigabytes',-1,'2026-02-21 10:01:37',NULL),('2026-02-20 10:01:37.979686',NULL,'2026-02-20 10:01:37.985918',615,615,NULL,'d88622b7-b13f-4141-b19e-c05b794ae5dc',192,'72f6de9a4d894029be8ca744061d09cb','shares',-1,'2026-02-21 10:01:37','15f2a171-553f-4457-9f33-a8801a176b4d'),('2026-02-20 10:01:37.980315',NULL,'2026-02-20 10:01:37.985918',616,616,NULL,'122d4e33-ca0d-4122-b548-e7a4181d1a5a',193,'72f6de9a4d894029be8ca744061d09cb','gigabytes',-1,'2026-02-21 10:01:37','15f2a171-553f-4457-9f33-a8801a176b4d'),('2026-02-20 10:01:38.880000',NULL,'2026-02-20 10:01:39.135035',617,617,'f513bc846858471ca213b468a9b8b076','3f3ed292-29d4-4bcb-a8be-2efe360af61d',202,'cff212d1a4ec47a198eaffb5418f0f33','shares',1,'2026-02-21 10:01:38',NULL),('2026-02-20 10:01:38.881369',NULL,'2026-02-20 10:01:39.135035',618,618,'f513bc846858471ca213b468a9b8b076','18f90020-4138-4e68-b197-4e9aa9ea3142',203,'cff212d1a4ec47a198eaffb5418f0f33','gigabytes',1,'2026-02-21 10:01:38',NULL),('2026-02-20 10:01:38.918699',NULL,'2026-02-20 10:01:39.141950',619,619,'f513bc846858471ca213b468a9b8b076','90ab0b5c-a9e7-463f-be8e-a44a4b8cd683',204,'fa5f5f12701349488e6f9e875b4ddfa7','shares',-1,'2026-02-21 10:01:38',NULL),('2026-02-20 10:01:38.919526',NULL,'2026-02-20 10:01:39.141950',620,620,'f513bc846858471ca213b468a9b8b076','d78d548e-45ba-400a-a619-21ad8e975188',205,'fa5f5f12701349488e6f9e875b4ddfa7','gigabytes',-1,'2026-02-21 10:01:38',NULL),('2026-02-20 10:01:39.780155',NULL,'2026-02-20 10:01:39.812045',621,621,'f513bc846858471ca213b468a9b8b076','24a78e44-91d1-4f07-9230-2e0a5e959e93',202,'cff212d1a4ec47a198eaffb5418f0f33','shares',-1,'2026-02-21 10:01:39',NULL),('2026-02-20 10:01:39.785429',NULL,'2026-02-20 10:01:39.812045',622,622,'f513bc846858471ca213b468a9b8b076','1f409262-37f4-4087-8b4e-096b53bab6f5',203,'cff212d1a4ec47a198eaffb5418f0f33','gigabytes',-1,'2026-02-21 10:01:39',NULL),('2026-02-20 10:01:39.803751',NULL,'2026-02-20 10:01:39.812045',623,623,NULL,'5e1b50c3-63