/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('f7c2117f-6347-4837-bcd3-f3f1cd53a41e','2026-02-01 14:38:22','2026-02-01 14:38:22',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'consistent_group_snapshot_enabled','<is> True','ad208fb5-a83f-4d3a-8257-39d6ac8920a4','2026-02-01 14:38:27','2026-02-01 14:38:27',NULL,0);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('ad208fb5-a83f-4d3a-8257-39d6ac8920a4','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2026-02-01 14:38:27','2026-02-01 14:38:27',NULL,0,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`),
  KEY `ix_image_volume_cache_entries_host` (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2026-02-01 14:38:25',NULL,NULL,0,1,'default','volumes',10),('2026-02-01 14:38:25',NULL,NULL,0,2,'default','snapshots',10),('2026-02-01 14:38:25',NULL,NULL,0,3,'default','gigabytes',1000),('2026-02-01 14:38:25',NULL,NULL,0,4,'default','consistencygroups',10),('2026-02-01 14:38:25',NULL,NULL,0,5,'default','per_volume_gigabytes',-1),('2026-02-01 14:38:25',NULL,NULL,0,6,'default','groups',10);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`,`race_preventer`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2026-02-01 14:38:35','2026-02-01 15:27:39',NULL,0,1,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',290,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'2d3f70ff-ad37-4206-94b3-a338d735f7b6'),('2026-02-01 15:07:03','2026-02-01 15:27:35',NULL,0,2,'cinder-backup-0','cinder-backup','cinder-backup',123,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'7656d4fc-57c0-41c3-bc10-03b2756782eb'),('2026-02-01 15:07:03','2026-02-01 15:27:34',NULL,0,3,'hostgroup@ceph','cinder-volume','cinder-volume',123,0,'nova',NULL,NULL,'3.18','1.39','disabled',0,NULL,NULL,'1aa9d5c3-cf47-4242-8ce2-c2f918d39d00');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2026-02-01 14:38:27','2026-02-01 14:38:27',NULL,0,'c501af05-1714-4cc7-a8b8-4f970a7d6341','__DEFAULT__',NULL,1,'Default Volume Type');
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2026-02-01 14:38:27','2026-02-01 14:38:27.000123',NULL,0,1,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (1,'e61fc85f-710a-443c-aaef-e91e7594bfee','rbd://2bb4558a-e8c9-5691-acbc-5dcfb33a4f0f/images/e61fc85f-710a-443c-aaef-e91e7594bfee/snap','2026-02-01 15:12:43','2026-02-01 15:12:43',NULL,0,'{\"store\": \"default_backend\"}','active'),(2,'2cc09540-d598-406a-9af1-b4893234340d','rbd://2bb4558a-e8c9-5691-acbc-5dcfb33a4f0f/images/2cc09540-d598-406a-9af1-b4893234340d/snap','2026-02-01 15:12:45','2026-02-01 15:12:45',NULL,0,'{\"store\": \"default_backend\"}','active');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'e61fc85f-710a-443c-aaef-e91e7594bfee','hw_rng_model','virtio','2026-02-01 15:12:40','2026-02-01 15:12:40',NULL,0),(2,'2cc09540-d598-406a-9af1-b4893234340d','hw_rng_model','virtio','2026-02-01 15:12:43','2026-02-01 15:12:43',NULL,0);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('2cc09540-d598-406a-9af1-b4893234340d','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2026-02-01 15:12:43','2026-02-01 15:12:45',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','30c59c149b894baf8d438f7200c1a812',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('e61fc85f-710a-443c-aaef-e91e7594bfee','cirros-0.6.2-x86_64-disk.img',21430272,'active','2026-02-01 15:12:40','2026-02-01 15:12:43',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','30c59c149b894baf8d438f7200c1a812',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b');
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (1,1,'image','CIM_PASD_','2026-02-01 14:37:18',NULL),(1,2,'image','CIM_RASD_','2026-02-01 14:37:18',NULL),(1,3,NULL,'CIM_SASD_','2026-02-01 14:37:19',NULL),(1,9,'image','hw_','2026-02-01 14:37:19',NULL),(1,10,'image','hw_','2026-02-01 14:37:19',NULL),(1,14,'image',NULL,'2026-02-01 14:37:19',NULL),(1,19,'image','hw_','2026-02-01 14:37:20',NULL),(1,25,'image','hw_','2026-02-01 14:37:20',NULL),(1,29,'image',NULL,'2026-02-01 14:37:21',NULL),(1,30,'image',NULL,'2026-02-01 14:37:21',NULL),(1,31,'image',NULL,'2026-02-01 14:37:21',NULL),(1,32,'image',NULL,'2026-02-01 14:37:21',NULL),(2,1,NULL,'CIM_PASD_','2026-02-01 14:37:18',NULL),(2,8,NULL,'hw_','2026-02-01 14:37:19',NULL),(2,9,NULL,'hw_','2026-02-01 14:37:19',NULL),(2,10,NULL,'hw_','2026-02-01 14:37:19',NULL),(2,11,NULL,NULL,'2026-02-01 14:37:19',NULL),(2,13,NULL,NULL,'2026-02-01 14:37:19',NULL),(2,14,NULL,NULL,'2026-02-01 14:37:19',NULL),(2,15,NULL,NULL,'2026-02-01 14:37:19',NULL),(2,16,NULL,'hw_','2026-02-01 14:37:19',NULL),(2,19,NULL,'hw_','2026-02-01 14:37:20',NULL),(2,22,NULL,NULL,'2026-02-01 14:37:20',NULL),(2,23,NULL,'hw_','2026-02-01 14:37:20',NULL),(2,24,NULL,'traits:','2026-02-01 14:37:20',NULL),(2,25,NULL,'hw_','2026-02-01 14:37:20',NULL),(2,26,NULL,NULL,'2026-02-01 14:37:20',NULL),(2,28,NULL,NULL,'2026-02-01 14:37:21',NULL),(2,29,NULL,NULL,'2026-02-01 14:37:21',NULL),(2,30,NULL,NULL,'2026-02-01 14:37:21',NULL),(2,31,NULL,NULL,'2026-02-01 14:37:21',NULL),(2,32,NULL,NULL,'2026-02-01 14:37:21',NULL),(2,33,NULL,'cinder_','2026-02-01 14:37:21',NULL),(3,1,NULL,'CIM_PASD_','2026-02-01 14:37:18',NULL),(3,2,NULL,'CIM_RASD_','2026-02-01 14:37:19',NULL),(3,3,NULL,'CIM_SASD_','2026-02-01 14:37:19',NULL),(3,4,NULL,'CIM_VSSD_','2026-02-01 14:37:19',NULL),(3,5,NULL,NULL,'2026-02-01 14:37:19',NULL),(3,6,NULL,NULL,'2026-02-01 14:37:19',NULL),(3,7,NULL,NULL,'2026-02-01 14:37:19',NULL),(3,12,NULL,'aggregate_instance_extra_specs:','2026-02-01 14:37:19',NULL),(4,1,NULL,'CIM_PASD_','2026-02-01 14:37:18',NULL),(4,2,NULL,'CIM_RASD_','2026-02-01 14:37:19',NULL),(4,3,NULL,'CIM_SASD_','2026-02-01 14:37:19',NULL),(4,4,NULL,'CIM_VSSD_','2026-02-01 14:37:19',NULL),(4,8,NULL,'hw:','2026-02-01 14:37:19',NULL),(4,9,NULL,'hw:','2026-02-01 14:37:19',NULL),(4,10,NULL,'hw:','2026-02-01 14:37:19',NULL),(4,12,NULL,'capabilities:','2026-02-01 14:37:19',NULL),(4,16,NULL,'hw:','2026-02-01 14:37:19',NULL),(4,17,NULL,NULL,'2026-02-01 14:37:19',NULL),(4,18,NULL,NULL,'2026-02-01 14:37:19',NULL),(4,19,NULL,'hw:','2026-02-01 14:37:20',NULL),(4,20,NULL,NULL,'2026-02-01 14:37:20',NULL),(4,21,NULL,NULL,'2026-02-01 14:37:20',NULL),(4,23,NULL,'hw:','2026-02-01 14:37:20',NULL),(4,24,NULL,'traits:','2026-02-01 14:37:20',NULL),(4,25,NULL,'hw:','2026-02-01 14:37:20',NULL),(5,1,'scheduler_hints',NULL,'2026-02-01 14:37:18',NULL),(5,30,'metadata',NULL,'2026-02-01 14:37:21',NULL),(5,31,'metadata',NULL,'2026-02-01 14:37:21',NULL),(5,32,'metadata',NULL,'2026-02-01 14:37:21',NULL),(6,30,NULL,NULL,'2026-02-01 14:37:21',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (1,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2026-02-01 14:37:18',NULL),(2,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2026-02-01 14:37:18',NULL),(3,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2026-02-01 14:37:19',NULL),(4,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2026-02-01 14:37:19',NULL),(5,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2026-02-01 14:37:19',NULL),(6,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2026-02-01 14:37:19',NULL),(7,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2026-02-01 14:37:19',NULL),(8,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2026-02-01 14:37:19',NULL),(9,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2026-02-01 14:37:19',NULL),(10,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2026-02-01 14:37:19',NULL),(11,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2026-02-01 14:37:19',NULL),(12,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2026-02-01 14:37:19',NULL),(13,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2026-02-01 14:37:19',NULL),(14,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2026-02-01 14:37:19',NULL),(15,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-02-01 14:37:19',NULL),(16,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-02-01 14:37:19',NULL),(17,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-02-01 14:37:19',NULL),(18,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2026-02-01 14:37:19',NULL),(19,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2026-02-01 14:37:19',NULL),(20,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-02-01 14:37:20',NULL),(21,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-02-01 14:37:20',NULL),(22,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-02-01 14:37:20',NULL),(23,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2026-02-01 14:37:20',NULL),(24,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2026-02-01 14:37:20',NULL),(25,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-02-01 14:37:20',NULL),(26,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-02-01 14:37:20',NULL),(27,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2026-02-01 14:37:20',NULL),(28,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2026-02-01 14:37:21',NULL),(29,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2026-02-01 14:37:21',NULL),(30,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2026-02-01 14:37:21',NULL),(31,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2026-02-01 14:37:21',NULL),(32,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2026-02-01 14:37:21',NULL),(33,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2026-02-01 14:37:21',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (1,17,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2026-02-01 14:37:19',NULL),(2,17,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2026-02-01 14:37:19',NULL),(3,17,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2026-02-01 14:37:19',NULL),(4,30,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2026-02-01 14:37:21',NULL),(5,30,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2026-02-01 14:37:21',NULL),(6,30,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2026-02-01 14:37:21',NULL),(7,30,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2026-02-01 14:37:21',NULL),(8,30,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-02-01 14:37:21',NULL),(9,30,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-02-01 14:37:21',NULL),(10,30,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2026-02-01 14:37:21',NULL),(11,30,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2026-02-01 14:37:21',NULL),(12,30,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-02-01 14:37:21',NULL),(13,30,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2026-02-01 14:37:21',NULL),(14,30,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2026-02-01 14:37:21',NULL),(15,30,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2026-02-01 14:37:21',NULL),(16,31,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2026-02-01 14:37:21',NULL),(17,31,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2026-02-01 14:37:21',NULL),(18,31,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2026-02-01 14:37:21',NULL),(19,31,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2026-02-01 14:37:21',NULL),(20,31,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2026-02-01 14:37:21',NULL),(21,32,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-02-01 14:37:21',NULL),(22,32,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-02-01 14:37:21',NULL),(23,32,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-02-01 14:37:21',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (1,1,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2026-02-01 14:37:18',NULL),(2,1,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2026-02-01 14:37:18',NULL),(3,1,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2026-02-01 14:37:18',NULL),(4,2,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(5,2,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(6,2,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(7,2,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2026-02-01 14:37:19',NULL),(8,2,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2026-02-01 14:37:19',NULL),(9,2,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2026-02-01 14:37:19',NULL),(10,2,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(11,2,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2026-02-01 14:37:19',NULL),(12,2,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(13,2,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(14,2,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(15,2,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(16,2,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(17,2,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2026-02-01 14:37:19',NULL),(18,2,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(19,2,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(20,2,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(21,2,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(22,2,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(23,3,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2026-02-01 14:37:19',NULL),(24,3,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(25,3,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2026-02-01 14:37:19',NULL),(26,3,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2026-02-01 14:37:19',NULL),(27,3,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(28,3,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(29,3,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(30,3,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(31,3,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(32,3,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(33,3,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(34,3,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(35,3,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(36,4,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2026-02-01 14:37:19',NULL),(37,4,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2026-02-01 14:37:19',NULL),(38,4,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2026-02-01 14:37:19',NULL),(39,4,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(40,4,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(41,4,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(42,4,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(43,4,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(44,4,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(45,4,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(46,4,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(47,4,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(48,4,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(49,4,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(50,4,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(51,4,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(52,4,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(53,5,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2026-02-01 14:37:19',NULL),(54,6,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2026-02-01 14:37:19',NULL),(55,7,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2026-02-01 14:37:19',NULL),(56,8,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2026-02-01 14:37:19',NULL),(57,9,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2026-02-01 14:37:19',NULL),(58,9,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2026-02-01 14:37:19',NULL),(59,10,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(60,11,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2026-02-01 14:37:19',NULL),(61,12,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2026-02-01 14:37:19',NULL),(62,12,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2026-02-01 14:37:19',NULL),(63,12,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2026-02-01 14:37:19',NULL),(64,12,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-02-01 14:37:19',NULL),(65,12,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-02-01 14:37:19',NULL),(66,12,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-02-01 14:37:19',NULL),(67,12,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2026-02-01 14:37:19',NULL),(68,13,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2026-02-01 14:37:19',NULL),(69,13,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2026-02-01 14:37:19',NULL),(70,14,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2026-02-01 14:37:19',NULL),(71,14,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-02-01 14:37:19',NULL),(72,15,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2026-02-01 14:37:19',NULL),(73,15,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2026-02-01 14:37:19',NULL),(74,15,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2026-02-01 14:37:19',NULL),(75,15,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2026-02-01 14:37:19',NULL),(76,15,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(77,15,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2026-02-01 14:37:19',NULL),(78,15,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\", \"bochs\"]}','2026-02-01 14:37:19',NULL),(79,15,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2026-02-01 14:37:19',NULL),(80,15,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2026-02-01 14:37:19',NULL),(81,15,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2026-02-01 14:37:19',NULL),(82,15,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, virtio, e1000e and vmxnet3. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\", \"vmxnet3\"]}','2026-02-01 14:37:19',NULL),(83,15,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-02-01 14:37:19',NULL),(84,15,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-02-01 14:37:19',NULL),(85,15,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-02-01 14:37:19',NULL),(86,15,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2026-02-01 14:37:19',NULL),(87,15,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-02-01 14:37:19',NULL),(88,16,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2026-02-01 14:37:19',NULL),(89,16,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-02-01 14:37:19',NULL),(90,16,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-02-01 14:37:19',NULL),(91,18,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2026-02-01 14:37:19',NULL),(92,18,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2026-02-01 14:37:19',NULL),(93,18,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2026-02-01 14:37:19',NULL),(94,19,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2026-02-01 14:37:20',NULL),(95,19,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2026-02-01 14:37:20',NULL),(96,19,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2026-02-01 14:37:20',NULL),(97,19,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2026-02-01 14:37:20',NULL),(98,19,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2026-02-01 14:37:20',NULL),(99,19,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2026-02-01 14:37:20',NULL),(100,20,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2026-02-01 14:37:20',NULL),(101,20,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2026-02-01 14:37:20',NULL),(102,21,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2026-02-01 14:37:20',NULL),(103,21,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2026-02-01 14:37:20',NULL),(104,22,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2026-02-01 14:37:20',NULL),(105,22,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2026-02-01 14:37:20',NULL),(106,22,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2026-02-01 14:37:20',NULL),(107,22,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2026-02-01 14:37:20',NULL),(108,22,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2026-02-01 14:37:20',NULL),(109,22,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-02-01 14:37:20',NULL),(110,23,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2026-02-01 14:37:20',NULL),(111,24,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2026-02-01 14:37:20',NULL),(112,24,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2026-02-01 14:37:20',NULL),(113,25,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2026-02-01 14:37:20',NULL),(114,26,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2026-02-01 14:37:20',NULL),(115,27,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2026-02-01 14:37:20',NULL),(116,27,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2026-02-01 14:37:20',NULL),(117,27,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2026-02-01 14:37:20',NULL),(118,27,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2026-02-01 14:37:20',NULL),(119,27,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2026-02-01 14:37:20',NULL),(120,27,'hw_cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"This specifies the CPU Mode for the guest vm\", \"type\": \"string\"}','2026-02-01 14:37:20',NULL),(121,27,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2026-02-01 14:37:20',NULL),(122,27,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2026-02-01 14:37:20',NULL),(123,27,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2026-02-01 14:37:21',NULL),(124,27,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2026-02-01 14:37:21',NULL),(125,28,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2026-02-01 14:37:21',NULL),(126,28,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2026-02-01 14:37:21',NULL),(127,28,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2026-02-01 14:37:21',NULL),(128,28,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2026-02-01 14:37:21',NULL),(129,29,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2026-02-01 14:37:21',NULL),(130,29,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2026-02-01 14:37:21',NULL),(131,29,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2026-02-01 14:37:21',NULL),(132,33,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2026-02-01 14:37:21',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (1,'OS::Cinder::Volume',1,'2026-02-01 14:37:18',NULL),(2,'OS::Glance::Image',1,'2026-02-01 14:37:18',NULL),(3,'OS::Nova::Aggregate',1,'2026-02-01 14:37:18',NULL),(4,'OS::Nova::Flavor',1,'2026-02-01 14:37:18',NULL),(5,'OS::Nova::Server',1,'2026-02-01 14:37:18',NULL),(6,'OS::Trove::Instance',1,'2026-02-01 14:37:21',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `user_id` (`user_id`),
  KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','419f74b7c92e4081b8c92b5dea909597','8a984e5e6d8641aaa8eab606a9587c2e','07c61460ca6743c7ad05341988c1bb54',0),('UserProject','419f74b7c92e4081b8c92b5dea909597','8a984e5e6d8641aaa8eab606a9587c2e','42867102abe24930bd95aadeb03fec8a',0),('UserProject','41ca7e0caad74d90b292c4f1532a90e8','8a984e5e6d8641aaa8eab606a9587c2e','07c61460ca6743c7ad05341988c1bb54',0),('UserProject','41ca7e0caad74d90b292c4f1532a90e8','8a984e5e6d8641aaa8eab606a9587c2e','42867102abe24930bd95aadeb03fec8a',0),('UserProject','4d9c57e17ee1493893700c697d89628c','8a984e5e6d8641aaa8eab606a9587c2e','07c61460ca6743c7ad05341988c1bb54',0),('UserProject','4d9c57e17ee1493893700c697d89628c','8a984e5e6d8641aaa8eab606a9587c2e','42867102abe24930bd95aadeb03fec8a',0),('UserProject','576fa5a6d714434a8b2d8930b05daf0e','8a984e5e6d8641aaa8eab606a9587c2e','07c61460ca6743c7ad05341988c1bb54',0),('UserProject','576fa5a6d714434a8b2d8930b05daf0e','8a984e5e6d8641aaa8eab606a9587c2e','42867102abe24930bd95aadeb03fec8a',0),('UserProject','5b859fc0c0a149b7a0363a92e4dfd6fb','8a984e5e6d8641aaa8eab606a9587c2e','07c61460ca6743c7ad05341988c1bb54',0),('UserProject','5b859fc0c0a149b7a0363a92e4dfd6fb','8a984e5e6d8641aaa8eab606a9587c2e','42867102abe24930bd95aadeb03fec8a',0),('UserProject','685c8f1612474643b3544e7f2e3da70f','8a984e5e6d8641aaa8eab606a9587c2e','07c61460ca6743c7ad05341988c1bb54',0),('UserProject','685c8f1612474643b3544e7f2e3da70f','8a984e5e6d8641aaa8eab606a9587c2e','42867102abe24930bd95aadeb03fec8a',0),('UserProject','6b2d9ef024c743f28b406c123163d8c7','8a984e5e6d8641aaa8eab606a9587c2e','07c61460ca6743c7ad05341988c1bb54',0),('UserProject','6b2d9ef024c743f28b406c123163d8c7','8a984e5e6d8641aaa8eab606a9587c2e','42867102abe24930bd95aadeb03fec8a',0),('UserProject','6c5480d9c8e24961972dcf773c284580','30c59c149b894baf8d438f7200c1a812','42867102abe24930bd95aadeb03fec8a',0),('UserProject','6c5480d9c8e24961972dcf773c284580','30c59c149b894baf8d438f7200c1a812','c14d35f109b4414e82a98faf22fde26e',0),('UserProject','6c5480d9c8e24961972dcf773c284580','dccfb7956a704feea4173610d3df7ccf','42867102abe24930bd95aadeb03fec8a',0),('UserProject','756a39b6a47a4f44a5b18daaabd51e2d','8a984e5e6d8641aaa8eab606a9587c2e','07c61460ca6743c7ad05341988c1bb54',0),('UserProject','756a39b6a47a4f44a5b18daaabd51e2d','8a984e5e6d8641aaa8eab606a9587c2e','42867102abe24930bd95aadeb03fec8a',0),('UserProject','f6e6e2d33fad4ea5aaa43983ab62e42f','8a984e5e6d8641aaa8eab606a9587c2e','42867102abe24930bd95aadeb03fec8a',0),('UserProject','f6e6e2d33fad4ea5aaa43983ab62e42f','8a984e5e6d8641aaa8eab606a9587c2e','80add9730872481a83b39b8cb69bba78',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('019d61de3d704a22994288022dbbacd4',NULL,'public','e202ee4ef59042a5b143533b7cfdfc57','https://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('20e3aa2026ba4ef794725f45a0ef7c3c',NULL,'internal','e202ee4ef59042a5b143533b7cfdfc57','https://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('43f07fcb8f64468180cd4ecc6c0288c8',NULL,'public','4d84a4d4c81649508bb2ece4ccc72e8d','https://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('48586686d0fd41ef8d1900a4987b97fd',NULL,'internal','9cc01676e47f4f8d81a91188a8596259','https://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('5dd24014517e4559a16f9646385740bc',NULL,'internal','76f992b655724a7181d861b9230b1cf2','https://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('5f8e50de0aaa430daef98bb052a57bdf',NULL,'internal','4d84a4d4c81649508bb2ece4ccc72e8d','https://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('671fdff9c903400aa0d3d442376704d9',NULL,'internal','3ae2ffe993a241179ffbdcf6a8b14f13','https://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('86a6d3aaadc74a529161390747b624a6',NULL,'public','067d071a85294199a5f4559c9093b9fe','https://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('9113511fc3f44ae49bd7d70168bef3af',NULL,'internal','ab2a92077d4e4fe7b32c37638e30d257','https://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('936caea31cba40c4b407ca97916c1156',NULL,'public','3ae2ffe993a241179ffbdcf6a8b14f13','https://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('9b59f3fb82d94320a7ba6a9b78a011a7',NULL,'public','a2238bdfcc4c4c9f857e35a05dbb588d','https://manila-public-openstack.apps-crc.testing/v2','{\"name\": \"manilav2\"}',1,'regionOne'),('9bb693333083465ab57f8f7e337c634f',NULL,'public','76f992b655724a7181d861b9230b1cf2','https://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('a9386ae0002a47d8a8cf370aebeb9379',NULL,'internal','067d071a85294199a5f4559c9093b9fe','https://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('abe7d1d2fe8f4df48be3f9493619222c',NULL,'public','9cc01676e47f4f8d81a91188a8596259','https://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('afc1162d0c65463a94f89702cafa2591',NULL,'internal','a2238bdfcc4c4c9f857e35a05dbb588d','https://manila-internal.openstack.svc:8786/v2','{\"name\": \"manilav2\"}',1,'regionOne'),('c3cba13356ab4661afeacae4a44fecfa',NULL,'internal','0bf632b4c5174ce18d11ff5ce7521ab6','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('c9a24469b0f54d03bbbc151fb376a5c9',NULL,'internal','5bce741d0c6f43bfbfb8736ceedbd8fa','https://manila-internal.openstack.svc:8786/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne'),('d66ec2417628433181cf8b003c80627b',NULL,'public','5bce741d0c6f43bfbfb8736ceedbd8fa','https://manila-public-openstack.apps-crc.testing/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne'),('ed710e17e71e44a382776efb017b50fd',NULL,'public','ab2a92077d4e4fe7b32c37638e30d257','https://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('fe07dbad1bfa41fdaa5cfbc3a8fd8451',NULL,'public','0bf632b4c5174ce18d11ff5ce7521ab6','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('42867102abe24930bd95aadeb03fec8a','80add9730872481a83b39b8cb69bba78'),('80add9730872481a83b39b8cb69bba78','ae9fb8eb8e4f482bbf7e3ff32bf462db');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=233 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (1,'6c5480d9c8e24961972dcf773c284580','default','admin',0,NULL),(2,'5b859fc0c0a149b7a0363a92e4dfd6fb','default','glance',0,NULL),(3,'756a39b6a47a4f44a5b18daaabd51e2d','default','nova',0,NULL),(4,'6b2d9ef024c743f28b406c123163d8c7','default','ceilometer',0,NULL),(5,'4d9c57e17ee1493893700c697d89628c','default','barbican',0,NULL),(6,'685c8f1612474643b3544e7f2e3da70f','default','neutron',0,NULL),(7,'419f74b7c92e4081b8c92b5dea909597','default','cinder',0,NULL),(8,'576fa5a6d714434a8b2d8930b05daf0e','default','placement',0,NULL),(9,'f6e6e2d33fad4ea5aaa43983ab62e42f','default','swift',0,NULL),(10,'41ca7e0caad74d90b292c4f1532a90e8','default','manila',0,NULL),(11,'2a2c8fad446d4f4c9b74cfb4fb1d81fa','default','demo_tempestconf',0,NULL),(12,'c97c34d4fee8479085c0da830c8a103f','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=233 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (1,1,NULL,0,'$2b$12$HszxDZZho6Uuu/FojAUmxuwePwJp/vf5DNqvGzHOBZ1gp1C27suTK',1769956664969796,NULL,'2026-02-01 14:37:44'),(2,2,NULL,0,'$2b$12$jCz4br9g/cAOZB4kSthe4eZwqtLPP9smD7SeSrUlwTgkb/v/RAqZ.',1769956728007421,NULL,'2026-02-01 14:38:48'),(3,3,NULL,0,'$2b$12$Nx9uidfiupNOC.uu2E8hkO/nha/blqPoX.QHvHc/f5Mf1YXvUPjtu',1769956730992720,NULL,'2026-02-01 14:38:50'),(4,4,NULL,0,'$2b$12$ZZbVMIjrkG9jooM5hWB0ROqDXXff7.znd0PmGO0chcaEX2Dclus5C',1769956733601107,NULL,'2026-02-01 14:38:53'),(5,5,NULL,0,'$2b$12$PJ.QVv4W7zXek2LuVIZzTurM7da5lAAw24fI8DjzgJQyuZzSL5wj2',1769956736014934,NULL,'2026-02-01 14:38:56'),(6,6,NULL,0,'$2b$12$llxpwUllAD8GVMUMBEMqJOVE5qBHsgqrecgO5ArtwNohqVFEnSWi6',1769956738326755,NULL,'2026-02-01 14:38:58'),(7,7,NULL,0,'$2b$12$Mh2fc4.bUGCrw10m7BZyWOvFLQzN/v8JNDgI1m1XlYTFs/IJWsXIW',1769956742897824,NULL,'2026-02-01 14:39:02'),(8,8,NULL,0,'$2b$12$qC0wEvOyIk8jAylsfvh30Olp0IjsQqpetRDg7q4H4yF3MqbzjMtje',1769956753042655,NULL,'2026-02-01 14:39:13'),(9,9,NULL,0,'$2b$12$gAYs9oF6VsoK5razk5DCGOa0kJGjPp1jZ7WNB3jBHDmdAtwZVgynm',1769957529114818,NULL,'2026-02-01 14:52:09'),(10,10,NULL,0,'$2b$12$nLHzVihHMIYhc2r789skwOAVGimxohbFKOatQO6yFbPpzCYEYvc6e',1769958460163517,NULL,'2026-02-01 15:07:40'),(11,11,NULL,0,'$2b$12$2dg1h.QOxzhUrm/NQVftvuBsj3n9PjWATg/FXny2NR3e/E3bDDHZO',1769958637891943,NULL,'2026-02-01 15:10:37'),(12,12,NULL,0,'$2b$12$URsMSr8te48oJ1KzSBX/EOW5HxbVWiflD6vyehjBR9vVIhl92QAOa',1769958638639538,NULL,'2026-02-01 15:10:38');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('30c59c149b894baf8d438f7200c1a812','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0),('8a984e5e6d8641aaa8eab606a9587c2e','service','{}','service',1,'default','default',0),('9a416895d3ea4571af9f8b52029f4558','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('dccfb7956a704feea4173610d3df7ccf','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=395 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (1,NULL,NULL,'abb12cc9c4984919b529a696a46f5a60',NULL,NULL,NULL,NULL,'2026-02-01 15:13:08',NULL,'2026-02-01 15:13:08',NULL,NULL),(2,NULL,NULL,'c58982f9c4d24310b2a1c1c6f4e8d6b1',NULL,NULL,NULL,NULL,'2026-02-01 15:13:09',NULL,'2026-02-01 15:13:09',NULL,NULL),(3,NULL,NULL,'428bdbcaa4b74a26ad450ac69dd7538d',NULL,NULL,NULL,NULL,'2026-02-01 15:13:09',NULL,'2026-02-01 15:13:09',NULL,NULL),(4,NULL,NULL,'47f7f256e097465f865be2f7fb878a6c',NULL,NULL,NULL,NULL,'2026-02-01 15:13:09',NULL,'2026-02-01 15:13:09',NULL,NULL),(5,NULL,'d2f2db141b024e47aaf94c741ef09112',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:13:11',NULL,'2026-02-01 15:13:11',NULL,NULL),(6,NULL,'7787f58c37114017ba819bffbf5286e3',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:13:12',NULL,'2026-02-01 15:13:12',NULL,NULL),(7,NULL,NULL,'5ba82415fcab4b38ab3da70c2770336f',NULL,NULL,NULL,NULL,'2026-02-01 15:13:14',NULL,'2026-02-01 15:13:14',NULL,NULL),(8,NULL,'e1b2126455054e329e1b8f9f85dfdba2',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:13:15',NULL,'2026-02-01 15:13:15',NULL,NULL),(9,NULL,NULL,'8ab2a357b1e24f2a80dbc1010ad7a4a9',NULL,NULL,NULL,NULL,'2026-02-01 15:13:16',NULL,'2026-02-01 15:13:16',NULL,NULL),(10,NULL,NULL,'967e0c56555f4a89bb8f32dd5f071eab',NULL,NULL,NULL,NULL,'2026-02-01 15:13:19',NULL,'2026-02-01 15:13:19',NULL,NULL),(11,NULL,NULL,'0ffbfd4d539243e5aeead1c4f8cbd292',NULL,NULL,NULL,NULL,'2026-02-01 15:13:19',NULL,'2026-02-01 15:13:19',NULL,NULL),(12,NULL,NULL,'e19059c3227c4ea5b508cf825c284a38',NULL,NULL,NULL,NULL,'2026-02-01 15:13:19',NULL,'2026-02-01 15:13:19',NULL,NULL),(13,NULL,'7d7793c430934c04a024af92c3ca805f',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:13:21',NULL,'2026-02-01 15:13:21',NULL,NULL),(14,NULL,'d1910e8a2cfd4348a076706467d378ad',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:13:21',NULL,'2026-02-01 15:13:21',NULL,NULL),(15,NULL,'a050fa021c734e40978ede143fe14875',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:13:22',NULL,'2026-02-01 15:13:22',NULL,NULL),(16,NULL,NULL,'6f3d619d43ee4af7af2b221bbb1a321b',NULL,NULL,NULL,NULL,'2026-02-01 15:13:24',NULL,'2026-02-01 15:13:24',NULL,NULL),(17,NULL,NULL,'9fc34f4f7cd84d65bde662f6a4296ec6',NULL,NULL,NULL,NULL,'2026-02-01 15:13:24',NULL,'2026-02-01 15:13:24',NULL,NULL),(18,NULL,NULL,'cfc88dace67943ebb2cda941b51534e0',NULL,NULL,NULL,NULL,'2026-02-01 15:13:24',NULL,'2026-02-01 15:13:24',NULL,NULL),(19,NULL,NULL,'95329888e58d47be8188928b7af65e6d',NULL,NULL,NULL,NULL,'2026-02-01 15:13:24',NULL,'2026-02-01 15:13:24',NULL,NULL),(20,NULL,'1ec224e5df45416ab531b08672183ad4',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:13:25',NULL,'2026-02-01 15:13:25',NULL,NULL),(21,NULL,NULL,'542016a7b57c4d8992f53582d68f0e62',NULL,NULL,NULL,NULL,'2026-02-01 15:13:25',NULL,'2026-02-01 15:13:25',NULL,NULL),(22,NULL,'60ff490c9a77446f898ffa42bc7f5796',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:13:26',NULL,'2026-02-01 15:13:26',NULL,NULL),(23,NULL,'cf2f906871624fa0887af8f21afda469',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:13:26',NULL,'2026-02-01 15:13:26',NULL,NULL),(24,NULL,'eb9c4cafce6a4a6fab4e9972c2279b86',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:13:27',NULL,'2026-02-01 15:13:27',NULL,NULL),(25,NULL,NULL,'effc6cb9d20f42b5ab290bf742814e3e',NULL,NULL,NULL,NULL,'2026-02-01 15:13:27',NULL,'2026-02-01 15:13:27',NULL,NULL),(26,NULL,'87a1e7b6a8384d47a1b4ea9dc0057d2d',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:13:29',NULL,'2026-02-01 15:13:29',NULL,NULL),(27,NULL,NULL,'0c91559bef744d8294b36dd4da0a5179',NULL,NULL,NULL,NULL,'2026-02-01 15:13:29',NULL,'2026-02-01 15:13:29',NULL,NULL),(28,NULL,NULL,'2eb1c73810744f74ad98b1617f698bac',NULL,NULL,NULL,NULL,'2026-02-01 15:13:29',NULL,'2026-02-01 15:13:29',NULL,NULL),(29,NULL,NULL,'db757744746b4d28b301e021a0cec8a1',NULL,NULL,NULL,NULL,'2026-02-01 15:13:30',NULL,'2026-02-01 15:13:30',NULL,NULL),(30,NULL,NULL,'dd3dddd74c80436eae71170aed36a00b',NULL,NULL,NULL,NULL,'2026-02-01 15:13:30',NULL,'2026-02-01 15:13:30',NULL,NULL),(31,NULL,'08dbf386a4a64ef0ba535abdc7905a81',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:13:31',NULL,'2026-02-01 15:13:31',NULL,NULL),(32,NULL,NULL,'05de6c1adcf6484a9817f8d1e051612f',NULL,NULL,NULL,NULL,'2026-02-01 15:13:31',NULL,'2026-02-01 15:13:31',NULL,NULL),(33,NULL,'e97ebfd6a3764df8b7badde8319f1a16',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:13:31',NULL,'2026-02-01 15:13:31',NULL,NULL),(34,NULL,'0044b4c4d79e4ec8b28ab4a1fa19a2a5',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:13:32',NULL,'2026-02-01 15:13:32',NULL,NULL),(35,NULL,'b11a07c113704ac1a42601deb46f4fbc',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:13:32',NULL,'2026-02-01 15:13:32',NULL,NULL),(36,NULL,NULL,'f3708244e67c410bafdc310e7ee04e74',NULL,NULL,NULL,NULL,'2026-02-01 15:13:33',NULL,'2026-02-01 15:13:33',NULL,NULL),(37,NULL,'6dd0271bc52b4062837ed17ae6578c4f',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:13:33',NULL,'2026-02-01 15:13:33',NULL,NULL),(38,NULL,'f41a226af54c4fd4b98ba5beaf67c832',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:13:34',NULL,'2026-02-01 15:13:34',NULL,NULL),(39,NULL,NULL,'e0cba9cff2db4c679862e1bfb6091b24',NULL,NULL,NULL,NULL,'2026-02-01 15:13:35',NULL,'2026-02-01 15:13:35',NULL,NULL),(40,NULL,'c4c49e028eba445fae154706eaaca940',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:13:36',NULL,'2026-02-01 15:13:36',NULL,NULL),(41,NULL,NULL,'6cb54209a81b4de6be87a97ac85db553',NULL,NULL,NULL,NULL,'2026-02-01 15:13:38',NULL,'2026-02-01 15:13:38',NULL,NULL),(42,NULL,'c7090683a5794c678b18e950250f3987',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:13:39',NULL,'2026-02-01 15:13:39',NULL,NULL),(43,NULL,NULL,'afe884e00cb54653928158aa21bea810',NULL,NULL,NULL,NULL,'2026-02-01 15:13:41',NULL,'2026-02-01 15:13:41',NULL,NULL),(44,NULL,'6e00a97cb4c94033b6ef3b6ab43580f8',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:13:42',NULL,'2026-02-01 15:13:42',NULL,NULL),(45,NULL,NULL,'6c7a6c983b3a451a96f18889cebd862d',NULL,NULL,NULL,NULL,'2026-02-01 15:13:53',NULL,'2026-02-01 15:13:53',NULL,NULL),(46,NULL,'c24c8bba1312447c8305abcf7b1ff259',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:13:55',NULL,'2026-02-01 15:13:55',NULL,NULL),(47,NULL,NULL,'5ee6d35984d74b71aabad79065fd6869',NULL,NULL,NULL,NULL,'2026-02-01 15:13:57',NULL,'2026-02-01 15:13:57',NULL,NULL),(48,NULL,'a1615023a51b44a69decdb84b99a2341',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:13:59',NULL,'2026-02-01 15:13:59',NULL,NULL),(49,NULL,NULL,'2bbd6a9be41643a38007238edf9638fe',NULL,NULL,NULL,NULL,'2026-02-01 15:14:05',NULL,'2026-02-01 15:14:05',NULL,NULL),(50,NULL,'fc17e54c678d41c68e219a1686c0fe7d',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:14:06',NULL,'2026-02-01 15:14:06',NULL,NULL),(51,NULL,NULL,'378aec71dc80451ca85d88d7f344ee1e',NULL,NULL,NULL,NULL,'2026-02-01 15:14:08',NULL,'2026-02-01 15:14:08',NULL,NULL),(52,NULL,NULL,'fbd576f00c6b445aadb79ba9a35844e4',NULL,NULL,NULL,NULL,'2026-02-01 15:14:11',NULL,'2026-02-01 15:14:11',NULL,NULL),(53,NULL,NULL,'1afe20e32e7a49b19b7951b0c03c9716',NULL,NULL,NULL,NULL,'2026-02-01 15:14:12',NULL,'2026-02-01 15:14:12',NULL,NULL),(54,NULL,NULL,'0a80c8d72f5c450d833c03c8e4ab8c5c',NULL,NULL,NULL,NULL,'2026-02-01 15:14:12',NULL,'2026-02-01 15:14:12',NULL,NULL),(55,NULL,NULL,'d490148597b44e68bee9a9fe258ee233',NULL,NULL,NULL,NULL,'2026-02-01 15:14:12',NULL,'2026-02-01 15:14:12',NULL,NULL),(56,NULL,NULL,'aae7e5b1e0e642e3803627fa6b5cd4d5',NULL,NULL,NULL,NULL,'2026-02-01 15:14:12',NULL,'2026-02-01 15:14:12',NULL,NULL),(57,NULL,NULL,'b9c27b9c31ba4b0d84aba2a8798db60d',NULL,NULL,NULL,NULL,'2026-02-01 15:14:12',NULL,'2026-02-01 15:14:12',NULL,NULL),(58,NULL,NULL,'503ff085c2e846d09c3e561479e33121',NULL,NULL,NULL,NULL,'2026-02-01 15:14:12',NULL,'2026-02-01 15:14:12',NULL,NULL),(59,NULL,NULL,'12ad9a75cf93431e800147fb7fd12e28',NULL,NULL,NULL,NULL,'2026-02-01 15:14:12',NULL,'2026-02-01 15:14:12',NULL,NULL),(60,NULL,'b2e389a954404c1185b10157107ee036',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:14:12',NULL,'2026-02-01 15:14:12',NULL,NULL),(61,NULL,'9237de8150e9410d914ff18a84b1243e',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:14:13',NULL,'2026-02-01 15:14:13',NULL,NULL),(62,NULL,'a55d5732be084dbca049a3357bc64ef4',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:14:14',NULL,'2026-02-01 15:14:14',NULL,NULL),(63,NULL,'2f536ef171cb4746b41cd1a7fa9e1e10',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:14:14',NULL,'2026-02-01 15:14:14',NULL,NULL),(64,NULL,'33dee2adb273444a9cc64d32c45dea67',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:14:14',NULL,'2026-02-01 15:14:14',NULL,NULL),(65,NULL,'999f6f2ae9a8410ca0b94eca9aa23d7a',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:14:16',NULL,'2026-02-01 15:14:16',NULL,NULL),(66,NULL,'841f0659b4ee419fbffc0f2689809307',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:14:16',NULL,'2026-02-01 15:14:16',NULL,NULL),(67,NULL,NULL,'75fe74ea213b4d7b94624b480c2dd710',NULL,NULL,NULL,NULL,'2026-02-01 15:14:18',NULL,'2026-02-01 15:14:18',NULL,NULL),(68,NULL,'be62fc3db7604aa4b29d6801a58a1643',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:14:19',NULL,'2026-02-01 15:14:19',NULL,NULL),(69,NULL,NULL,'6d624c79a244410ea425e927de47849b',NULL,NULL,NULL,NULL,'2026-02-01 15:14:19',NULL,'2026-02-01 15:14:19',NULL,NULL),(70,NULL,'655ba61b322f4a8c9881fdd7f1412a14',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:14:21',NULL,'2026-02-01 15:14:21',NULL,NULL),(71,NULL,NULL,'435a807314d045b7b6183b8871d538b0',NULL,NULL,NULL,NULL,'2026-02-01 15:14:24',NULL,'2026-02-01 15:14:24',NULL,NULL),(72,NULL,'fda4ab42f467487d8e5d3007a76e3476',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:14:25',NULL,'2026-02-01 15:14:25',NULL,NULL),(73,NULL,NULL,'52393b023cd64393a0b3cc33f7cf9b0f',NULL,NULL,NULL,NULL,'2026-02-01 15:14:26',NULL,'2026-02-01 15:14:26',NULL,NULL),(74,NULL,'be07a91869e4476fbc553f85525ca866',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:14:27',NULL,'2026-02-01 15:14:27',NULL,NULL),(75,NULL,NULL,'cc0a452dee164345aea7407b68b035fd',NULL,NULL,NULL,NULL,'2026-02-01 15:14:27',NULL,'2026-02-01 15:14:27',NULL,NULL),(76,NULL,NULL,'04fb1aafc4a841a288491843b99b029f',NULL,NULL,NULL,NULL,'2026-02-01 15:14:28',NULL,'2026-02-01 15:14:28',NULL,NULL),(77,NULL,'dd8e21b7acfa46429ecf80207535322d',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:14:28',NULL,'2026-02-01 15:14:28',NULL,NULL),(78,NULL,'86e747a8839340c2a3bd553d37f352da',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:14:29',NULL,'2026-02-01 15:14:29',NULL,NULL),(79,NULL,NULL,'6e577da624444533a310e088f6442115',NULL,NULL,NULL,NULL,'2026-02-01 15:14:30',NULL,'2026-02-01 15:14:30',NULL,NULL),(80,NULL,'0322bb88bfc548849f627285c05f7752',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:14:31',NULL,'2026-02-01 15:14:31',NULL,NULL),(81,NULL,NULL,'8bb2899e7c0e4e4fb63ccde614728c31',NULL,NULL,NULL,NULL,'2026-02-01 15:14:33',NULL,'2026-02-01 15:14:33',NULL,NULL),(82,NULL,NULL,'bced690680b3499597e88dbf6acbaf84',NULL,NULL,NULL,NULL,'2026-02-01 15:14:33',NULL,'2026-02-01 15:14:33',NULL,NULL),(83,NULL,NULL,'8aed0688b51d4ff0a0a064f11d0b453b',NULL,NULL,NULL,NULL,'2026-02-01 15:14:34',NULL,'2026-02-01 15:14:34',NULL,NULL),(84,NULL,NULL,'08f88d0b6ec54c79a8bfec726694c073',NULL,NULL,NULL,NULL,'2026-02-01 15:14:34',NULL,'2026-02-01 15:14:34',NULL,NULL),(85,NULL,NULL,'ce10fbb6b38547f9a5941051a574973b',NULL,NULL,NULL,NULL,'2026-02-01 15:14:34',NULL,'2026-02-01 15:14:34',NULL,NULL),(86,NULL,'f4290717c8704d22bc3668a95b0f03b3',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:14:34',NULL,'2026-02-01 15:14:34',NULL,NULL),(87,NULL,'389354672a9f45998c217a07289430b9',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:14:35',NULL,'2026-02-01 15:14:35',NULL,NULL),(88,NULL,NULL,'ebbc55d5795d499ca2ef1b1d2dbb1452',NULL,NULL,NULL,NULL,'2026-02-01 15:14:35',NULL,'2026-02-01 15:14:35',NULL,NULL),(89,NULL,'55a91c9680a44bf488e98eacd5dedabb',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:14:36',NULL,'2026-02-01 15:14:36',NULL,NULL),(90,NULL,'9daf6f5120ad4addbf1be43b336ab548',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:14:37',NULL,'2026-02-01 15:14:37',NULL,NULL),(91,NULL,'ac308aafcc28434490e01326b32cf754',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:14:37',NULL,'2026-02-01 15:14:37',NULL,NULL),(92,NULL,NULL,'e6400935472f49cf84509b1f539c868c',NULL,NULL,NULL,NULL,'2026-02-01 15:14:40',NULL,'2026-02-01 15:14:40',NULL,NULL),(93,NULL,NULL,'137f5a8aae104e268ba0ea5d7e0522d2',NULL,NULL,NULL,NULL,'2026-02-01 15:14:41',NULL,'2026-02-01 15:14:41',NULL,NULL),(94,NULL,NULL,'fa65e9bb1fdb4e25b593534cc45a50ec',NULL,NULL,NULL,NULL,'2026-02-01 15:14:41',NULL,'2026-02-01 15:14:41',NULL,NULL),(95,NULL,NULL,'c4a21edeb1634648b6a34961e96316b9',NULL,NULL,NULL,NULL,'2026-02-01 15:14:41',NULL,'2026-02-01 15:14:41',NULL,NULL),(96,NULL,NULL,'6863140dd64a43a3944e05aaddb17e32',NULL,NULL,NULL,NULL,'2026-02-01 15:14:42',NULL,'2026-02-01 15:14:42',NULL,NULL),(97,NULL,NULL,'bd26a3fc2b9342fbb5e482028aff12fb',NULL,NULL,NULL,NULL,'2026-02-01 15:14:42',NULL,'2026-02-01 15:14:42',NULL,NULL),(98,NULL,NULL,'63ed71bc390f443f99fdba281ec1cf11',NULL,NULL,NULL,NULL,'2026-02-01 15:14:42',NULL,'2026-02-01 15:14:42',NULL,NULL),(99,NULL,NULL,'b87b973782ef4b399f083be8f2b55f55',NULL,NULL,NULL,NULL,'2026-02-01 15:14:42',NULL,'2026-02-01 15:14:42',NULL,NULL),(100,NULL,'aacc9867e0d444be9263344e4f8c5f3c',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:14:42',NULL,'2026-02-01 15:14:42',NULL,NULL),(101,NULL,'807ed4c214f74b16afc74a3fcdede185',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:14:43',NULL,'2026-02-01 15:14:43',NULL,NULL),(102,NULL,'4a91f36f4d3f4d078465f263b0656521',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:14:43',NULL,'2026-02-01 15:14:43',NULL,NULL),(103,NULL,'0a588a92c52d439aa2d00d1f7a76be9b',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:14:45',NULL,'2026-02-01 15:14:45',NULL,NULL),(104,NULL,'7770dd7dfc1046849de0e0a847f244da',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:14:45',NULL,'2026-02-01 15:14:45',NULL,NULL),(105,NULL,'8fa142dc2bca46a2ad193fa05d55f6dd',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:14:46',NULL,'2026-02-01 15:14:46',NULL,NULL),(106,NULL,NULL,'dcf2bd3831204b9ab184a7cc67131535',NULL,NULL,NULL,NULL,'2026-02-01 15:14:48',NULL,'2026-02-01 15:14:48',NULL,NULL),(107,NULL,'7a668bd74cf5418dac7e432188331a66',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:14:50',NULL,'2026-02-01 15:14:50',NULL,NULL),(108,NULL,NULL,'9adc3859370e4721915474700dd5efe0',NULL,NULL,NULL,NULL,'2026-02-01 15:15:00',NULL,'2026-02-01 15:15:00',NULL,NULL),(109,NULL,NULL,'26e3e1d8b04f4d09b6941b9eed4bed81',NULL,NULL,NULL,NULL,'2026-02-01 15:15:02',NULL,'2026-02-01 15:15:02',NULL,NULL),(110,NULL,'42d5324bd181499ca11dbc92c8e1556c',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:15:04',NULL,'2026-02-01 15:15:04',NULL,NULL),(111,NULL,NULL,'e47de2b4135b4005af9009853f7a18dd',NULL,NULL,NULL,NULL,'2026-02-01 15:15:04',NULL,'2026-02-01 15:15:04',NULL,NULL),(112,NULL,NULL,'1edb86b6d57742e2b8f08d4a1fba6b16',NULL,NULL,NULL,NULL,'2026-02-01 15:15:04',NULL,'2026-02-01 15:15:04',NULL,NULL),(113,NULL,NULL,'060eac8e1f1648d79761bae0909beb23',NULL,NULL,NULL,NULL,'2026-02-01 15:15:04',NULL,'2026-02-01 15:15:04',NULL,NULL),(114,NULL,'12a4a6d46b5f47c5a4365d9a9e2d65a4',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:15:05',NULL,'2026-02-01 15:15:05',NULL,NULL),(115,NULL,NULL,'2c641459542741e59f6414cbb91ed187',NULL,NULL,NULL,NULL,'2026-02-01 15:15:06',NULL,'2026-02-01 15:15:06',NULL,NULL),(116,NULL,'ea8b2999de524be38f5aad1a9d304d4d',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:15:06',NULL,'2026-02-01 15:15:06',NULL,NULL),(117,NULL,'4ed32334aab64e5388ef8e859555acf4',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:15:07',NULL,'2026-02-01 15:15:07',NULL,NULL),(118,NULL,'b3c21deb7cba41feaff782713b1775e6',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:15:07',NULL,'2026-02-01 15:15:07',NULL,NULL),(119,NULL,NULL,'7eefa8098d674990a0fdf48d271ba759',NULL,NULL,NULL,NULL,'2026-02-01 15:15:11',NULL,'2026-02-01 15:15:11',NULL,NULL),(120,NULL,'62d01f392211403ea747f08ee4926027',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:15:12',NULL,'2026-02-01 15:15:12',NULL,NULL),(121,NULL,NULL,'d96e6750de144571baa367a4390ad4c6',NULL,NULL,NULL,NULL,'2026-02-01 15:15:12',NULL,'2026-02-01 15:15:12',NULL,NULL),(122,NULL,NULL,'928da2f6147a4b708835fcbebf483d8a',NULL,NULL,NULL,NULL,'2026-02-01 15:15:17',NULL,'2026-02-01 15:15:17',NULL,NULL),(123,NULL,NULL,'4a4c03f0c7844e81b47bb47d50a1958e',NULL,NULL,NULL,NULL,'2026-02-01 15:15:17',NULL,'2026-02-01 15:15:17',NULL,NULL),(124,NULL,NULL,'ec0be7c705df458da4371aaba3468117',NULL,NULL,NULL,NULL,'2026-02-01 15:15:17',NULL,'2026-02-01 15:15:17',NULL,NULL),(125,NULL,NULL,'6441bd4d61df4c3e8ac49b9333f0ad1b',NULL,NULL,NULL,NULL,'2026-02-01 15:15:17',NULL,'2026-02-01 15:15:17',NULL,NULL),(126,NULL,'07d8902bb45647d39d1ef241c9ae00a3',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:15:18',NULL,'2026-02-01 15:15:18',NULL,NULL),(127,NULL,'8148327cebed4bb49e576111ce3edff1',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:15:19',NULL,'2026-02-01 15:15:19',NULL,NULL),(128,NULL,'99dbd8b2d24742d4a17ae1b433e9a8f1',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:15:19',NULL,'2026-02-01 15:15:19',NULL,NULL),(129,NULL,NULL,'dd29879b031e4b4f99a9732af2a529af',NULL,NULL,NULL,NULL,'2026-02-01 15:15:22',NULL,'2026-02-01 15:15:22',NULL,NULL),(130,NULL,NULL,'2c0b8b0ceab54be1881838f9f05283e2',NULL,NULL,NULL,NULL,'2026-02-01 15:15:22',NULL,'2026-02-01 15:15:22',NULL,NULL),(131,NULL,'dede9307e827419b8a25fe70b68c2f9e',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:15:23',NULL,'2026-02-01 15:15:23',NULL,NULL),(132,NULL,NULL,'d5883f440ad441fda1589bbf1c775a00',NULL,NULL,NULL,NULL,'2026-02-01 15:15:24',NULL,'2026-02-01 15:15:24',NULL,NULL),(133,NULL,NULL,'be487d61686f4614ab5a4dc9267c365c',NULL,NULL,NULL,NULL,'2026-02-01 15:15:24',NULL,'2026-02-01 15:15:24',NULL,NULL),(134,NULL,NULL,'32efe54ffae74acfbb12e72ef8334608',NULL,NULL,NULL,NULL,'2026-02-01 15:15:24',NULL,'2026-02-01 15:15:24',NULL,NULL),(135,NULL,NULL,'11f88fd8eb5e4e5a917950b3ca185810',NULL,NULL,NULL,NULL,'2026-02-01 15:15:25',NULL,'2026-02-01 15:15:25',NULL,NULL),(136,NULL,'fe9d125b7160441ca4f65e4592449354',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:15:25',NULL,'2026-02-01 15:15:25',NULL,NULL),(137,NULL,'a1864a026c91411cb8b3dd945f12f0d6',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:15:26',NULL,'2026-02-01 15:15:26',NULL,NULL),(138,NULL,NULL,'ea1b6f46cbbb4818a6a4403ec32a9024',NULL,NULL,NULL,NULL,'2026-02-01 15:15:26',NULL,'2026-02-01 15:15:26',NULL,NULL),(139,NULL,'803414aa6b584ca095a11fb7f37f3c31',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:15:26',NULL,'2026-02-01 15:15:26',NULL,NULL),(140,NULL,NULL,'bb0f7bbbfb804e11a5f1f270004f538c',NULL,NULL,NULL,NULL,'2026-02-01 15:15:27',NULL,'2026-02-01 15:15:27',NULL,NULL),(141,NULL,NULL,'3ffea631057a441cae6093c6335cb16e',NULL,NULL,NULL,NULL,'2026-02-01 15:15:27',NULL,'2026-02-01 15:15:27',NULL,NULL),(142,NULL,'46cbc131a820464a9b6cd0940829aea6',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:15:27',NULL,'2026-02-01 15:15:27',NULL,NULL),(143,NULL,'7ff48bca9e1b488e87b89779edbf65bf',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:15:28',NULL,'2026-02-01 15:15:28',NULL,NULL),(144,NULL,'e9440ed4c0664dec89a398d51ca34494',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:15:29',NULL,'2026-02-01 15:15:29',NULL,NULL),(145,NULL,NULL,'e67aa586237d4941ae24faaf8f67b180',NULL,NULL,NULL,NULL,'2026-02-01 15:15:29',NULL,'2026-02-01 15:15:29',NULL,NULL),(146,NULL,'e1146be9bbbd4bb78658dbd9892d1894',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:15:30',NULL,'2026-02-01 15:15:30',NULL,NULL),(147,NULL,'f1209ac97ba74afd8bdb92fc40834e86',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:15:30',NULL,'2026-02-01 15:15:30',NULL,NULL),(148,NULL,NULL,'e07fba909f9f4d1c9863cd639e4e657e',NULL,NULL,NULL,NULL,'2026-02-01 15:15:33',NULL,'2026-02-01 15:15:33',NULL,NULL),(149,NULL,'2933d20d93bc49f2a65bc74bc31f189a',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:15:34',NULL,'2026-02-01 15:15:34',NULL,NULL),(150,NULL,NULL,'db9629114dc3441b8ccfb577bd4ff37a',NULL,NULL,NULL,NULL,'2026-02-01 15:15:35',NULL,'2026-02-01 15:15:35',NULL,NULL),(151,NULL,NULL,'2f14b61aac5c41f78a2c8a4963295b65',NULL,NULL,NULL,NULL,'2026-02-01 15:15:35',NULL,'2026-02-01 15:15:35',NULL,NULL),(152,NULL,NULL,'29c4d56e65f247bfadd75aabb6edf140',NULL,NULL,NULL,NULL,'2026-02-01 15:15:35',NULL,'2026-02-01 15:15:35',NULL,NULL),(153,NULL,NULL,'6c83c28e021c4717b45ee6d416ec31f5',NULL,NULL,NULL,NULL,'2026-02-01 15:15:36',NULL,'2026-02-01 15:15:36',NULL,NULL),(154,NULL,'0dfd4148452647aa845013a982630bb0',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:15:37',NULL,'2026-02-01 15:15:37',NULL,NULL),(155,NULL,'e5e9968c2e9d4081aba18652d4ed25be',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:15:37',NULL,'2026-02-01 15:15:37',NULL,NULL),(156,NULL,'b60d48ce6ed84a0499e61efc92fe4ff7',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:15:38',NULL,'2026-02-01 15:15:38',NULL,NULL),(157,NULL,NULL,'3a766ab6e0814016aad7d6222fdcc2c0',NULL,NULL,NULL,NULL,'2026-02-01 15:15:42',NULL,'2026-02-01 15:15:42',NULL,NULL),(158,NULL,NULL,'427aa25dee44485da29616c59e4c7f32',NULL,NULL,NULL,NULL,'2026-02-01 15:15:43',NULL,'2026-02-01 15:15:43',NULL,NULL),(159,NULL,NULL,'bd6d40fb02cb4d73b45fc2758a272eb3',NULL,NULL,NULL,NULL,'2026-02-01 15:15:43',NULL,'2026-02-01 15:15:43',NULL,NULL),(160,NULL,NULL,'22516058211b47b28cd8b81b14c99db4',NULL,NULL,NULL,NULL,'2026-02-01 15:15:43',NULL,'2026-02-01 15:15:43',NULL,NULL),(161,NULL,'936fbee8acc442c2904744d78e2b8ade',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:15:44',NULL,'2026-02-01 15:15:44',NULL,NULL),(162,NULL,'7627d97455f2455fa4156595a87489e5',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:15:46',NULL,'2026-02-01 15:15:46',NULL,NULL),(163,NULL,'2a24445756fc4f06b51cf9eea1ba59d2',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:15:46',NULL,'2026-02-01 15:15:46',NULL,NULL),(164,NULL,NULL,'6f2dab9328424993aa458427358720d9',NULL,NULL,NULL,NULL,'2026-02-01 15:16:12',NULL,'2026-02-01 15:16:12',NULL,NULL),(165,NULL,'32087184504a4aabb8269aa5ef350c60',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:16:14',NULL,'2026-02-01 15:16:14',NULL,NULL),(166,NULL,NULL,'c768e3f3500c4bf19dcf4fcf64856998',NULL,NULL,NULL,NULL,'2026-02-01 15:16:16',NULL,'2026-02-01 15:16:16',NULL,NULL),(167,NULL,'0d63dabe67144e93ab3137e7893f5f60',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:16:17',NULL,'2026-02-01 15:16:17',NULL,NULL),(168,NULL,NULL,'c0f0f48ec2014e97a7777d56edeffd76',NULL,NULL,NULL,NULL,'2026-02-01 15:16:17',NULL,'2026-02-01 15:16:17',NULL,NULL),(169,NULL,'e707f9addc1d4f2e8815d92bb329e717',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:16:18',NULL,'2026-02-01 15:16:18',NULL,NULL),(170,NULL,NULL,'b6a1a42d63984621b9e097e6806b5763',NULL,NULL,NULL,NULL,'2026-02-01 15:16:19',NULL,'2026-02-01 15:16:19',NULL,NULL),(171,NULL,'bdf4b79bffc9438e8d392863955266f9',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:16:20',NULL,'2026-02-01 15:16:20',NULL,NULL),(172,NULL,NULL,'2d2b5d9a96e747e7a3110d99ce9f10b1',NULL,NULL,NULL,NULL,'2026-02-01 15:16:20',NULL,'2026-02-01 15:16:20',NULL,NULL),(173,NULL,'94933d303abf4309a35c192c3fca1a9c',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:16:21',NULL,'2026-02-01 15:16:21',NULL,NULL),(174,NULL,NULL,'a82cefccf4ae401cb1dba7786e33cdf1',NULL,NULL,NULL,NULL,'2026-02-01 15:16:22',NULL,'2026-02-01 15:16:22',NULL,NULL),(175,NULL,'b29cc8f7cf0a481cb65cf4bd998ccf90',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:16:23',NULL,'2026-02-01 15:16:23',NULL,NULL),(176,NULL,NULL,'e46f4a2321bd41a8992f9fb9f6532699',NULL,NULL,NULL,NULL,'2026-02-01 15:16:24',NULL,'2026-02-01 15:16:24',NULL,NULL),(177,NULL,NULL,'731e52be467d45fba84c52bf12506310',NULL,NULL,NULL,NULL,'2026-02-01 15:16:26',NULL,'2026-02-01 15:16:26',NULL,NULL),(178,NULL,'fd6906854f774fcb85eca95c0bddf502',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:16:26',NULL,'2026-02-01 15:16:26',NULL,NULL),(179,NULL,'25d49f15bde7447488f7d7203683e55f',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:16:27',NULL,'2026-02-01 15:16:27',NULL,NULL),(180,NULL,NULL,'400891ac38e84823bdcb0d328927d330',NULL,NULL,NULL,NULL,'2026-02-01 15:16:29',NULL,'2026-02-01 15:16:29',NULL,NULL),(181,NULL,NULL,'38a73e844744416d836b3aac0201b9e4',NULL,NULL,NULL,NULL,'2026-02-01 15:16:34',NULL,'2026-02-01 15:16:34',NULL,NULL),(182,NULL,NULL,'706799a1fee7408a935f7481d3910a50',NULL,NULL,NULL,NULL,'2026-02-01 15:16:38',NULL,'2026-02-01 15:16:38',NULL,NULL),(183,NULL,NULL,'15902b85ed0d4d548969d78d03c51542',NULL,NULL,NULL,NULL,'2026-02-01 15:16:39',NULL,'2026-02-01 15:16:39',NULL,NULL),(184,NULL,NULL,'9143810fbee74a7799490ac3fc1032dd',NULL,NULL,NULL,NULL,'2026-02-01 15:16:39',NULL,'2026-02-01 15:16:39',NULL,NULL),(185,NULL,'c12690bcab10459c81103ff11e371488',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:16:40',NULL,'2026-02-01 15:16:40',NULL,NULL),(186,NULL,'22f908b340ac4f29a5431ce38dcaa9af',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:16:41',NULL,'2026-02-01 15:16:41',NULL,NULL),(187,NULL,'108eaef08adb40da8008e82d1b78c24c',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:16:41',NULL,'2026-02-01 15:16:41',NULL,NULL),(188,NULL,NULL,'795592d89a1d46e4a844c4a238d332e3',NULL,NULL,NULL,NULL,'2026-02-01 15:16:44',NULL,'2026-02-01 15:16:44',NULL,NULL),(189,NULL,NULL,'e513aa3b998a4d7c9d1e07492d61bda1',NULL,NULL,NULL,NULL,'2026-02-01 15:16:44',NULL,'2026-02-01 15:16:44',NULL,NULL),(190,NULL,NULL,'277ccc0a574d4b5da8ca19ec693974e9',NULL,NULL,NULL,NULL,'2026-02-01 15:16:44',NULL,'2026-02-01 15:16:44',NULL,NULL),(191,NULL,NULL,'94e50185026b4e6ca95421ee93d0993b',NULL,NULL,NULL,NULL,'2026-02-01 15:16:45',NULL,'2026-02-01 15:16:45',NULL,NULL),(192,NULL,NULL,'63663d7f9d704a77a0065a41dbe8c03e',NULL,NULL,NULL,NULL,'2026-02-01 15:16:45',NULL,'2026-02-01 15:16:45',NULL,NULL),(193,NULL,NULL,'d7ccbce60d3b4dbcb5a2310275e4b226',NULL,NULL,NULL,NULL,'2026-02-01 15:16:45',NULL,'2026-02-01 15:16:45',NULL,NULL),(194,NULL,'e483891a9fd042d4a571a3d4655dc685',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:16:46',NULL,'2026-02-01 15:16:46',NULL,NULL),(195,NULL,'527381d885f94d95b43292545f281baf',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:16:47',NULL,'2026-02-01 15:16:47',NULL,NULL),(196,NULL,'3cfd6a87f0ae4788b5c4341a8d79f161',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:16:47',NULL,'2026-02-01 15:16:47',NULL,NULL),(197,NULL,'2731ddbed05046f3bee55c8f307163b2',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:16:48',NULL,'2026-02-01 15:16:48',NULL,NULL),(198,NULL,NULL,'e9e626045c924c8c981ad3f67a1dedd6',NULL,NULL,NULL,NULL,'2026-02-01 15:16:50',NULL,'2026-02-01 15:16:50',NULL,NULL),(199,NULL,NULL,'d0ba7fc249894e878d205d2ff950c24f',NULL,NULL,NULL,NULL,'2026-02-01 15:16:50',NULL,'2026-02-01 15:16:50',NULL,NULL),(200,NULL,NULL,'fa19fbbac9564e1e9438909ff722ffa6',NULL,NULL,NULL,NULL,'2026-02-01 15:16:50',NULL,'2026-02-01 15:16:50',NULL,NULL),(201,NULL,NULL,'132a8a81c12143f1841bd4500de9cedf',NULL,NULL,NULL,NULL,'2026-02-01 15:16:50',NULL,'2026-02-01 15:16:50',NULL,NULL),(202,NULL,'eafd3440026c4f97b26741c1e0312fa1',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:16:52',NULL,'2026-02-01 15:16:52',NULL,NULL),(203,NULL,'4dff4fbaf6404693810adc16f5b5d9eb',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:16:52',NULL,'2026-02-01 15:16:52',NULL,NULL),(204,NULL,NULL,'a4473152d5024d848b586f077b4cfb71',NULL,NULL,NULL,NULL,'2026-02-01 15:16:53',NULL,'2026-02-01 15:16:53',NULL,NULL),(205,NULL,'ced0c977898f4a12a8f69349079c8c04',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:16:53',NULL,'2026-02-01 15:16:53',NULL,NULL),(206,NULL,'f99925486e924480b84b05e1433af949',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:16:54',NULL,'2026-02-01 15:16:54',NULL,NULL),(207,NULL,NULL,'627361eeb4bc410fb28e040badc59d2c',NULL,NULL,NULL,NULL,'2026-02-01 15:16:54',NULL,'2026-02-01 15:16:54',NULL,NULL),(208,NULL,NULL,'e4ecc33a39654a49aece6549575ae8a0',NULL,NULL,NULL,NULL,'2026-02-01 15:16:54',NULL,'2026-02-01 15:16:54',NULL,NULL),(209,NULL,NULL,'3c3e3625201842e098eeb270b7dccf54',NULL,NULL,NULL,NULL,'2026-02-01 15:16:54',NULL,'2026-02-01 15:16:54',NULL,NULL),(210,NULL,'d8619226901f4987807454d91d99af93',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:16:56',NULL,'2026-02-01 15:16:56',NULL,NULL),(211,NULL,'8f7172c9db6b4bdea243ee115e6934bf',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:16:57',NULL,'2026-02-01 15:16:57',NULL,NULL),(212,NULL,NULL,'5d73f009819c42b7b5f8737214469e53',NULL,NULL,NULL,NULL,'2026-02-01 15:16:57',NULL,'2026-02-01 15:16:57',NULL,NULL),(213,NULL,NULL,'2e4cf23751d44fb6ae3284462b5aed9a',NULL,NULL,NULL,NULL,'2026-02-01 15:16:57',NULL,'2026-02-01 15:16:57',NULL,NULL),(214,NULL,NULL,'cea1d5d5281448058a12fedc0610e075',NULL,NULL,NULL,NULL,'2026-02-01 15:16:58',NULL,'2026-02-01 15:16:58',NULL,NULL),(215,NULL,NULL,'764f7a55e79948f6870d274763b17aa6',NULL,NULL,NULL,NULL,'2026-02-01 15:16:58',NULL,'2026-02-01 15:16:58',NULL,NULL),(216,NULL,'69a62b1260d846e9896ea90329ee68b2',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:16:58',NULL,'2026-02-01 15:16:58',NULL,NULL),(217,NULL,'f1db1e3238524e33ad83b6704069208c',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:16:59',NULL,'2026-02-01 15:16:59',NULL,NULL),(218,NULL,'776daa3a265d480697b3bdf0a769a1a7',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:17:00',NULL,'2026-02-01 15:17:00',NULL,NULL),(219,NULL,'2fe3c2b2ac8b42389caf31052fdb4ce5',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:17:01',NULL,'2026-02-01 15:17:01',NULL,NULL),(220,NULL,NULL,'09a6b5beaf9f4e96b8a8b3f1d67a192d',NULL,NULL,NULL,NULL,'2026-02-01 15:17:05',NULL,'2026-02-01 15:17:05',NULL,NULL),(221,NULL,'d3906373bc57497a8593cc485bc49810',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:17:06',NULL,'2026-02-01 15:17:06',NULL,NULL),(222,NULL,NULL,'69f331bcb74f4b289b93b8a3e7e226c7',NULL,NULL,NULL,NULL,'2026-02-01 15:17:13',NULL,'2026-02-01 15:17:13',NULL,NULL),(223,NULL,NULL,'43cb4707c1ff47498472a5c03dff4675',NULL,NULL,NULL,NULL,'2026-02-01 15:17:14',NULL,'2026-02-01 15:17:14',NULL,NULL),(224,NULL,NULL,'ca9572b1d68245119900179ee0e42054',NULL,NULL,NULL,NULL,'2026-02-01 15:17:14',NULL,'2026-02-01 15:17:14',NULL,NULL),(225,NULL,NULL,'b5039a994a2f4ba3a8ec15af2dbc3413',NULL,NULL,NULL,NULL,'2026-02-01 15:17:14',NULL,'2026-02-01 15:17:14',NULL,NULL),(226,NULL,'d09db0da089f4ce0a30eb5ed62745861',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:17:16',NULL,'2026-02-01 15:17:16',NULL,NULL),(227,NULL,'895c3691df1144b7a277855a6876b1e0',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:17:17',NULL,'2026-02-01 15:17:17',NULL,NULL),(228,NULL,'604576b4d1784f4fade7b9ece2b1679c',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:17:18',NULL,'2026-02-01 15:17:18',NULL,NULL),(229,NULL,NULL,'a5a42392655846988cd2d26888082221',NULL,NULL,NULL,NULL,'2026-02-01 15:17:27',NULL,'2026-02-01 15:17:27',NULL,NULL),(230,NULL,NULL,'78165cb2bbac42ca957ac7fa7010927e',NULL,NULL,NULL,NULL,'2026-02-01 15:17:32',NULL,'2026-02-01 15:17:32',NULL,NULL),(231,NULL,NULL,'c1db95e191a64ff7955bbf4464388960',NULL,NULL,NULL,NULL,'2026-02-01 15:17:32',NULL,'2026-02-01 15:17:32',NULL,NULL),(232,NULL,NULL,'75a51aa3ac544fc494f8f87823726130',NULL,NULL,NULL,NULL,'2026-02-01 15:17:32',NULL,'2026-02-01 15:17:32',NULL,NULL),(233,NULL,'557407533ddd4b83a57f3bf0896f77ac',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:17:33',NULL,'2026-02-01 15:17:33',NULL,NULL),(234,NULL,'1ab226d3d9754c57966f4f95aa31082f',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:17:35',NULL,'2026-02-01 15:17:35',NULL,NULL),(235,NULL,'30e7754f728d446fb15fcbd3f69b4039',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:17:35',NULL,'2026-02-01 15:17:35',NULL,NULL),(236,NULL,NULL,'f05ac6f0850e43aab2d65c677a83e102',NULL,NULL,NULL,NULL,'2026-02-01 15:17:40',NULL,'2026-02-01 15:17:40',NULL,NULL),(237,NULL,NULL,'769853c729ab454087819076eba1a6f7',NULL,NULL,NULL,NULL,'2026-02-01 15:17:40',NULL,'2026-02-01 15:17:40',NULL,NULL),(238,NULL,NULL,'e5fdd8f146f04ebe92c1a69e83a40b1b',NULL,NULL,NULL,NULL,'2026-02-01 15:17:40',NULL,'2026-02-01 15:17:40',NULL,NULL),(239,NULL,NULL,'5949ea09b80640d6822f22fd13810337',NULL,NULL,NULL,NULL,'2026-02-01 15:17:40',NULL,'2026-02-01 15:17:40',NULL,NULL),(240,NULL,'db50064d90ed4c5db10649b9117215b6',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:17:41',NULL,'2026-02-01 15:17:41',NULL,NULL),(241,NULL,'837c00984a10489ebe2409f84f7aa2b1',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:17:42',NULL,'2026-02-01 15:17:42',NULL,NULL),(242,NULL,'605e260c3f5742dd8351b731d9459909',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:17:43',NULL,'2026-02-01 15:17:43',NULL,NULL),(243,NULL,NULL,'1aea4e7217c54e1f8194231025a23058',NULL,NULL,NULL,NULL,'2026-02-01 15:17:55',NULL,'2026-02-01 15:17:55',NULL,NULL),(244,NULL,NULL,'60095238b9444c4bbf425950ca283c97',NULL,NULL,NULL,NULL,'2026-02-01 15:18:03',NULL,'2026-02-01 15:18:03',NULL,NULL),(245,NULL,NULL,'ae0ce63e72ed43ce8a48aea631b96258',NULL,NULL,NULL,NULL,'2026-02-01 15:18:03',NULL,'2026-02-01 15:18:03',NULL,NULL),(246,NULL,NULL,'27d4ec6a023d41e0b6d57c6687dc4014',NULL,NULL,NULL,NULL,'2026-02-01 15:18:03',NULL,'2026-02-01 15:18:03',NULL,NULL),(247,NULL,'f68533ffbf394ee490507fe32e13203d',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:18:04',NULL,'2026-02-01 15:18:04',NULL,NULL),(248,NULL,'5e1261fa63b348dd8c26883b016255c5',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:18:06',NULL,'2026-02-01 15:18:06',NULL,NULL),(249,NULL,'91bb7a32ff7141dfb6d37c38b3cff70a',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:18:07',NULL,'2026-02-01 15:18:07',NULL,NULL),(250,NULL,NULL,'17f39ddbb764465c88b655b768b6524d',NULL,NULL,NULL,NULL,'2026-02-01 15:18:11',NULL,'2026-02-01 15:18:11',NULL,NULL),(251,NULL,NULL,'e4314abe2f2c4f868e96e04f4bf69733',NULL,NULL,NULL,NULL,'2026-02-01 15:18:11',NULL,'2026-02-01 15:18:11',NULL,NULL),(252,NULL,NULL,'07ece489e6eb4b86963088a71d3ba4ef',NULL,NULL,NULL,NULL,'2026-02-01 15:18:11',NULL,'2026-02-01 15:18:11',NULL,NULL),(253,NULL,NULL,'949720707cf142ccbc729a6f83c5d23f',NULL,NULL,NULL,NULL,'2026-02-01 15:18:11',NULL,'2026-02-01 15:18:11',NULL,NULL),(254,NULL,NULL,'330058f6460549afa9e004b431cadb4e',NULL,NULL,NULL,NULL,'2026-02-01 15:18:11',NULL,'2026-02-01 15:18:11',NULL,NULL),(255,NULL,NULL,'d259803f49214b75b52753809201efab',NULL,NULL,NULL,NULL,'2026-02-01 15:18:12',NULL,'2026-02-01 15:18:12',NULL,NULL),(256,NULL,NULL,'746730afb3db4d7f80045269f8973474',NULL,NULL,NULL,NULL,'2026-02-01 15:18:12',NULL,'2026-02-01 15:18:12',NULL,NULL),(257,NULL,NULL,'fe705dfe72654bcea2ed5e5e4596db0f',NULL,NULL,NULL,NULL,'2026-02-01 15:18:12',NULL,'2026-02-01 15:18:12',NULL,NULL),(258,NULL,NULL,'f25834d3a80243b2837c30667e8951a9',NULL,NULL,NULL,NULL,'2026-02-01 15:18:12',NULL,'2026-02-01 15:18:12',NULL,NULL),(259,NULL,'7d6e4fede7cf495eada5ff5f864f4d05',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:18:13',NULL,'2026-02-01 15:18:13',NULL,NULL),(260,NULL,'f833624fa3314234b278157f9090963d',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:18:14',NULL,'2026-02-01 15:18:14',NULL,NULL),(261,NULL,'120c1822ab9548c2815485bc30d42a55',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:18:14',NULL,'2026-02-01 15:18:14',NULL,NULL),(262,NULL,'afb21e4cec3a4d3fb97382c2e2ee8c03',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:18:14',NULL,'2026-02-01 15:18:14',NULL,NULL),(263,NULL,'fdac0817a65044fd9c005c58b217903a',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:18:14',NULL,'2026-02-01 15:18:14',NULL,NULL),(264,NULL,'2cba935894174dc08c381582a2bf731e',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:18:15',NULL,'2026-02-01 15:18:15',NULL,NULL),(265,NULL,NULL,'5938ed46a998400bbbe31526b23394cf',NULL,NULL,NULL,NULL,'2026-02-01 15:18:16',NULL,'2026-02-01 15:18:16',NULL,NULL),(266,NULL,'171be73e76a2463085bb2bc543cd3bc5',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:18:17',NULL,'2026-02-01 15:18:17',NULL,NULL),(267,NULL,NULL,'3cf00994b85e4b779e6717ae76e983b5',NULL,NULL,NULL,NULL,'2026-02-01 15:18:18',NULL,'2026-02-01 15:18:18',NULL,NULL),(268,NULL,NULL,'01e8a6487b9f4b85bb515a7f6904f4b1',NULL,NULL,NULL,NULL,'2026-02-01 15:18:18',NULL,'2026-02-01 15:18:18',NULL,NULL),(269,NULL,NULL,'872335d5c3d4449691d00f9d710e0452',NULL,NULL,NULL,NULL,'2026-02-01 15:18:19',NULL,'2026-02-01 15:18:19',NULL,NULL),(270,NULL,'33750acff41b4b8abac955b4cf091d60',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:18:20',NULL,'2026-02-01 15:18:20',NULL,NULL),(271,NULL,'2d34a42954784fd580342c38b6efaf58',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:18:21',NULL,'2026-02-01 15:18:21',NULL,NULL),(272,NULL,'368b363545bf449ebeb73c7917747ead',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:18:21',NULL,'2026-02-01 15:18:21',NULL,NULL),(273,NULL,NULL,'6868c6d8625240428c32f8df11c67fd6',NULL,NULL,NULL,NULL,'2026-02-01 15:18:22',NULL,'2026-02-01 15:18:22',NULL,NULL),(274,NULL,'8b0415f100a1429bba93cf802c51baee',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:18:23',NULL,'2026-02-01 15:18:23',NULL,NULL),(275,NULL,NULL,'ac40a6535b084cee86b3827fa7625275',NULL,NULL,NULL,NULL,'2026-02-01 15:18:30',NULL,'2026-02-01 15:18:30',NULL,NULL),(276,NULL,NULL,'b941253886a049d88d77c1e476049e76',NULL,NULL,NULL,NULL,'2026-02-01 15:18:30',NULL,'2026-02-01 15:18:30',NULL,NULL),(277,NULL,NULL,'4055cc8bb5d547ebad7c962e12d0a6d7',NULL,NULL,NULL,NULL,'2026-02-01 15:18:30',NULL,'2026-02-01 15:18:30',NULL,NULL),(278,NULL,NULL,'f8ddc88924544ffa8336519f672c138f',NULL,NULL,NULL,NULL,'2026-02-01 15:18:30',NULL,'2026-02-01 15:18:30',NULL,NULL),(279,NULL,'bb2930f15c9c4eef8f497a38d49c042d',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:18:32',NULL,'2026-02-01 15:18:32',NULL,NULL),(280,NULL,'6d5c40ecdf9547859af9d1076692dd4e',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:18:33',NULL,'2026-02-01 15:18:33',NULL,NULL),(281,NULL,'563730bce3db420f8fb732bed1fdd719',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:18:34',NULL,'2026-02-01 15:18:34',NULL,NULL),(282,NULL,NULL,'5d99ab57f6fb401b9c42397956f64381',NULL,NULL,NULL,NULL,'2026-02-01 15:18:47',NULL,'2026-02-01 15:18:47',NULL,NULL),(283,NULL,NULL,'11897f289df4497f8f5488b56a132f0e',NULL,NULL,NULL,NULL,'2026-02-01 15:18:54',NULL,'2026-02-01 15:18:54',NULL,NULL),(284,NULL,NULL,'f6d8ffe9f1a64b1693065611bbe19c67',NULL,NULL,NULL,NULL,'2026-02-01 15:18:55',NULL,'2026-02-01 15:18:55',NULL,NULL),(285,NULL,NULL,'24edeab99fbb48d7b16cdeb517c6a575',NULL,NULL,NULL,NULL,'2026-02-01 15:18:55',NULL,'2026-02-01 15:18:55',NULL,NULL),(286,NULL,NULL,'b4519508f74d4e4bab6f8c3da6388d49',NULL,NULL,NULL,NULL,'2026-02-01 15:18:55',NULL,'2026-02-01 15:18:55',NULL,NULL),(287,NULL,NULL,'f1c472bc0f2746e0a81c1e60e23264ad',NULL,NULL,NULL,NULL,'2026-02-01 15:18:55',NULL,'2026-02-01 15:18:55',NULL,NULL),(288,NULL,NULL,'78ec5f9ae7c946e9b0f720a02f469764',NULL,NULL,NULL,NULL,'2026-02-01 15:18:55',NULL,'2026-02-01 15:18:55',NULL,NULL),(289,NULL,NULL,'fe92091b423d49feaf22a502d836127d',NULL,NULL,NULL,NULL,'2026-02-01 15:18:55',NULL,'2026-02-01 15:18:55',NULL,NULL),(290,NULL,'5d1e833d258140798bbddb15095488d9',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:18:57',NULL,'2026-02-01 15:18:57',NULL,NULL),(291,NULL,'7736a9c671f04e42b35558bfde737fc8',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:18:57',NULL,'2026-02-01 15:18:57',NULL,NULL),(292,NULL,'da3a3dccc7274a08beb410a126847d78',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:18:58',NULL,'2026-02-01 15:18:58',NULL,NULL),(293,NULL,'2c31b44d86274d9c9323bcb7f0a754dd',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:18:58',NULL,'2026-02-01 15:18:58',NULL,NULL),(294,NULL,'efc48ae084e74296827eff4c92a82451',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:18:59',NULL,'2026-02-01 15:18:59',NULL,NULL),(295,NULL,'2ff0daa106ea4ba5873bcbf1c6aa2d4e',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:18:59',NULL,'2026-02-01 15:18:59',NULL,NULL),(296,NULL,NULL,'dd42bc34a5f74af28809f327d2f9793d',NULL,NULL,NULL,NULL,'2026-02-01 15:19:20',NULL,'2026-02-01 15:19:20',NULL,NULL),(297,NULL,NULL,'97f4b78f19014a34a141891766483e17',NULL,NULL,NULL,NULL,'2026-02-01 15:19:32',NULL,'2026-02-01 15:19:32',NULL,NULL),(298,NULL,NULL,'5a9e48d8005d427fa422911dd04f4938',NULL,NULL,NULL,NULL,'2026-02-01 15:19:34',NULL,'2026-02-01 15:19:34',NULL,NULL),(299,NULL,NULL,'4a03d7d514fb49b7935a186e9e3affe6',NULL,NULL,NULL,NULL,'2026-02-01 15:19:34',NULL,'2026-02-01 15:19:34',NULL,NULL),(300,NULL,NULL,'92c9d642b6cb427a8300dafa5b10d9dd',NULL,NULL,NULL,NULL,'2026-02-01 15:19:35',NULL,'2026-02-01 15:19:35',NULL,NULL),(301,NULL,'5277934866b346c7bac918cadba66528',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:19:36',NULL,'2026-02-01 15:19:36',NULL,NULL),(302,NULL,'dee3dc8d056b4335af5fb486fbe84e4a',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:19:37',NULL,'2026-02-01 15:19:37',NULL,NULL),(303,NULL,'754e5daaf01d4d8e91ba62e9ca89a38d',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:19:38',NULL,'2026-02-01 15:19:38',NULL,NULL),(304,NULL,NULL,'a6d2572f8b864e0793ea67a069edbe05',NULL,NULL,NULL,NULL,'2026-02-01 15:19:47',NULL,'2026-02-01 15:19:47',NULL,NULL),(305,NULL,NULL,'ad7557b780714428abc55972efb6436f',NULL,NULL,NULL,NULL,'2026-02-01 15:19:47',NULL,'2026-02-01 15:19:47',NULL,NULL),(306,NULL,NULL,'d0914dc1987f46d1886cfce655daaf24',NULL,NULL,NULL,NULL,'2026-02-01 15:19:47',NULL,'2026-02-01 15:19:47',NULL,NULL),(307,NULL,'f0c45bbe7e79492484c7037ad48c7d50',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:19:49',NULL,'2026-02-01 15:19:49',NULL,NULL),(308,NULL,'40dced376e0d4d23b2b7de2c3fc8bd0e',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:19:50',NULL,'2026-02-01 15:19:50',NULL,NULL),(309,NULL,'78c60c23f25c4067be08ce2208223271',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:19:51',NULL,'2026-02-01 15:19:51',NULL,NULL),(310,NULL,NULL,'7fb9aabb992d4632b62058eed2108a1b',NULL,NULL,NULL,NULL,'2026-02-01 15:20:06',NULL,'2026-02-01 15:20:06',NULL,NULL),(311,NULL,NULL,'285a33e9d1bd42fb99f40147950702a7',NULL,NULL,NULL,NULL,'2026-02-01 15:20:06',NULL,'2026-02-01 15:20:06',NULL,NULL),(312,NULL,NULL,'465443f98ace4b989c787808b3cda30c',NULL,NULL,NULL,NULL,'2026-02-01 15:20:10',NULL,'2026-02-01 15:20:10',NULL,NULL),(313,NULL,NULL,'173940d59a1d4598835f9ee9135d10c2',NULL,NULL,NULL,NULL,'2026-02-01 15:20:10',NULL,'2026-02-01 15:20:10',NULL,NULL),(314,NULL,NULL,'40071a2cccc54e749b466a4ebce569a1',NULL,NULL,NULL,NULL,'2026-02-01 15:20:10',NULL,'2026-02-01 15:20:10',NULL,NULL),(315,NULL,'57db56ab716a4f1f8d3472c138c447fe',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:20:12',NULL,'2026-02-01 15:20:12',NULL,NULL),(316,NULL,'82a24dd1fd974048b6acfb7657cae2d0',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:20:14',NULL,'2026-02-01 15:20:14',NULL,NULL),(317,NULL,'7043f01f29d441a4801c5afbb65b54e3',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:20:16',NULL,'2026-02-01 15:20:16',NULL,NULL),(318,NULL,NULL,'49d67bde23484e9eb875baf2b9d37446',NULL,NULL,NULL,NULL,'2026-02-01 15:20:24',NULL,'2026-02-01 15:20:24',NULL,NULL),(319,NULL,NULL,'f69502b1cbbe4323a4b071a11a697d10',NULL,NULL,NULL,NULL,'2026-02-01 15:20:24',NULL,'2026-02-01 15:20:24',NULL,NULL),(320,NULL,NULL,'bcaf840947644060ad5c15b759234046',NULL,NULL,NULL,NULL,'2026-02-01 15:20:24',NULL,'2026-02-01 15:20:24',NULL,NULL),(321,NULL,NULL,'b6c2e445010a46f188728c8336831af0',NULL,NULL,NULL,NULL,'2026-02-01 15:20:25',NULL,'2026-02-01 15:20:25',NULL,NULL),(322,NULL,'2397fe23d9524898ac9446be92dbbc82',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:20:26',NULL,'2026-02-01 15:20:26',NULL,NULL),(323,NULL,'82efdf20300f4ffda9822c66d6f66684',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:20:26',NULL,'2026-02-01 15:20:26',NULL,NULL),(324,NULL,'ab45193f64cf425ab7261bdecab53b2c',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:20:27',NULL,'2026-02-01 15:20:27',NULL,NULL),(325,NULL,NULL,'f358517d239b4cafb78b21acdf941223',NULL,NULL,NULL,NULL,'2026-02-01 15:20:30',NULL,'2026-02-01 15:20:30',NULL,NULL),(326,NULL,NULL,'9b821b75762847c0a0cd8e793edbff6e',NULL,NULL,NULL,NULL,'2026-02-01 15:20:31',NULL,'2026-02-01 15:20:31',NULL,NULL),(327,NULL,NULL,'e2e3c4ce728141359d3c38c43bb1e08d',NULL,NULL,NULL,NULL,'2026-02-01 15:20:31',NULL,'2026-02-01 15:20:31',NULL,NULL),(328,NULL,NULL,'299cef2f231d4cfc98a3fbb3de5be936',NULL,NULL,NULL,NULL,'2026-02-01 15:20:31',NULL,'2026-02-01 15:20:31',NULL,NULL),(329,NULL,'e35ee090e5554e278d4b4d0088008af6',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:20:33',NULL,'2026-02-01 15:20:33',NULL,NULL),(330,NULL,NULL,'3154b4653ac340d3941adcac0181a3f6',NULL,NULL,NULL,NULL,'2026-02-01 15:20:33',NULL,'2026-02-01 15:20:33',NULL,NULL),(331,NULL,'fec1c52e18f14a31be729a8342182ca7',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:20:34',NULL,'2026-02-01 15:20:34',NULL,NULL),(332,NULL,NULL,'3ae1be73cfed433987aa97aa98b4c458',NULL,NULL,NULL,NULL,'2026-02-01 15:20:34',NULL,'2026-02-01 15:20:34',NULL,NULL),(333,NULL,NULL,'bd53f2729edb48c1bfe318c4473899c2',NULL,NULL,NULL,NULL,'2026-02-01 15:20:34',NULL,'2026-02-01 15:20:34',NULL,NULL),(334,NULL,NULL,'d64cbad90c54446aabfab19f7725f14c',NULL,NULL,NULL,NULL,'2026-02-01 15:20:34',NULL,'2026-02-01 15:20:34',NULL,NULL),(335,NULL,'b670fdf3792f449992d3fca1ff6004ee',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:20:34',NULL,'2026-02-01 15:20:34',NULL,NULL),(336,NULL,'9d2a60c4dccd4fb8aaea3f6b5e5d8f92',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:20:35',NULL,'2026-02-01 15:20:35',NULL,NULL),(337,NULL,'deabadd3bc654f6f83324fed114b20e0',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:20:36',NULL,'2026-02-01 15:20:36',NULL,NULL),(338,NULL,'35324aa513f1486a8ea7c66d69adea81',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:20:37',NULL,'2026-02-01 15:20:37',NULL,NULL),(339,NULL,NULL,'6cc6ef7d64d648bc90d5996643d06dcd',NULL,NULL,NULL,NULL,'2026-02-01 15:20:43',NULL,'2026-02-01 15:20:43',NULL,NULL),(340,NULL,NULL,'450cf379cbe94609a3c6e3b3d551a78f',NULL,NULL,NULL,NULL,'2026-02-01 15:20:43',NULL,'2026-02-01 15:20:43',NULL,NULL),(341,NULL,NULL,'6f958a41d78c4be0a08e982b45e1a5d2',NULL,NULL,NULL,NULL,'2026-02-01 15:20:43',NULL,'2026-02-01 15:20:43',NULL,NULL),(342,NULL,NULL,'589069a7861d4f64aff8d50675c886bf',NULL,NULL,NULL,NULL,'2026-02-01 15:20:44',NULL,'2026-02-01 15:20:44',NULL,NULL),(343,NULL,NULL,'98c57a7cb74e47bab829a9c8f501c4f7',NULL,NULL,NULL,NULL,'2026-02-01 15:20:44',NULL,'2026-02-01 15:20:44',NULL,NULL),(344,NULL,'ce7698959c3d4d0db7a022f2bca706e2',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:20:45',NULL,'2026-02-01 15:20:45',NULL,NULL),(345,NULL,'99dc510820ec4b9b8b6046c9b449dd48',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:20:45',NULL,'2026-02-01 15:20:45',NULL,NULL),(346,NULL,'df8c3ecdfab6413d85063f6a916bc871',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:20:47',NULL,'2026-02-01 15:20:47',NULL,NULL),(347,NULL,NULL,'bf5d1db5b7fe40f0ab31649c9864bbbb',NULL,NULL,NULL,NULL,'2026-02-01 15:20:48',NULL,'2026-02-01 15:20:48',NULL,NULL),(348,NULL,NULL,'b903f39cb67f4494ac6f3c32133da903',NULL,NULL,NULL,NULL,'2026-02-01 15:20:48',NULL,'2026-02-01 15:20:48',NULL,NULL),(349,NULL,NULL,'a845ca9e05f34e9d89942f61baf2e2cc',NULL,NULL,NULL,NULL,'2026-02-01 15:20:48',NULL,'2026-02-01 15:20:48',NULL,NULL),(350,NULL,'624202b32e62465ca01f75142b16617c',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:20:49',NULL,'2026-02-01 15:20:49',NULL,NULL),(351,NULL,'c9aea6a240dd42f9b7b3d599b0caa552',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:20:50',NULL,'2026-02-01 15:20:50',NULL,NULL),(352,NULL,'d3171a4f3a734b4c9e5b22b84bee507b',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:20:51',NULL,'2026-02-01 15:20:51',NULL,NULL),(353,NULL,NULL,'c8b57596611e422592176f29c44262d9',NULL,NULL,NULL,NULL,'2026-02-01 15:20:53',NULL,'2026-02-01 15:20:53',NULL,NULL),(354,NULL,NULL,'911582e6edec4359a74231aa06712ec7',NULL,NULL,NULL,NULL,'2026-02-01 15:20:53',NULL,'2026-02-01 15:20:53',NULL,NULL),(355,NULL,NULL,'b91723b0aaa044078667affca7b4dd73',NULL,NULL,NULL,NULL,'2026-02-01 15:20:54',NULL,'2026-02-01 15:20:54',NULL,NULL),(356,NULL,NULL,'75704b1dc967442eb512d7e35d75ac26',NULL,NULL,NULL,NULL,'2026-02-01 15:20:54',NULL,'2026-02-01 15:20:54',NULL,NULL),(357,NULL,'0db94360695a43ea89e283afc9df4110',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:20:55',NULL,'2026-02-01 15:20:55',NULL,NULL),(358,NULL,'01d0cfa107c84ac5a04318766207130d',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:20:57',NULL,'2026-02-01 15:20:57',NULL,NULL),(359,NULL,'f1e3b86feb89434bb0b718aad1396e26',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:20:57',NULL,'2026-02-01 15:20:57',NULL,NULL),(360,NULL,NULL,'4bffaa0ce31e4076bf71892cc143095e',NULL,NULL,NULL,NULL,'2026-02-01 15:21:06',NULL,'2026-02-01 15:21:06',NULL,NULL),(361,NULL,NULL,'88ec7b16b6fa416384d2369bc7447737',NULL,NULL,NULL,NULL,'2026-02-01 15:21:07',NULL,'2026-02-01 15:21:07',NULL,NULL),(362,NULL,NULL,'0449b261c81b46ff9803553c718be13c',NULL,NULL,NULL,NULL,'2026-02-01 15:21:07',NULL,'2026-02-01 15:21:07',NULL,NULL),(363,NULL,NULL,'b6d59b5ce971466a89afe318eedbc7fd',NULL,NULL,NULL,NULL,'2026-02-01 15:21:07',NULL,'2026-02-01 15:21:07',NULL,NULL),(364,NULL,'52ac7fb21e3442af82e9ccd9a67048b3',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:21:09',NULL,'2026-02-01 15:21:09',NULL,NULL),(365,NULL,'aa5bbd2feb3546b3b9c7795cf15e8829',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:21:09',NULL,'2026-02-01 15:21:09',NULL,NULL),(366,NULL,'3ea69957a6c44f7a9940dd8170733a36',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:21:12',NULL,'2026-02-01 15:21:12',NULL,NULL),(367,NULL,NULL,'f2d15f4377ff42d98244bb208b5fed5c',NULL,NULL,NULL,NULL,'2026-02-01 15:21:19',NULL,'2026-02-01 15:21:19',NULL,NULL),(368,NULL,NULL,'8c6a7c0dbc6a435d9d7adbff0811f887',NULL,NULL,NULL,NULL,'2026-02-01 15:21:19',NULL,'2026-02-01 15:21:19',NULL,NULL),(369,NULL,NULL,'5cd39ae4249342919393eb77a7ff25ae',NULL,NULL,NULL,NULL,'2026-02-01 15:21:20',NULL,'2026-02-01 15:21:20',NULL,NULL),(370,NULL,NULL,'cbb697e90bba496492eff23ba65227c8',NULL,NULL,NULL,NULL,'2026-02-01 15:21:20',NULL,'2026-02-01 15:21:20',NULL,NULL),(371,NULL,'5b354e96d8754cf0a01ccc8e15d99a2c',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:21:21',NULL,'2026-02-01 15:21:21',NULL,NULL),(372,NULL,'afbb7db8d7bb4a2bb751d7f0b83bd48f',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:21:21',NULL,'2026-02-01 15:21:21',NULL,NULL),(373,NULL,'faad57d670b14ffa80d6a90141f7fb49',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:21:22',NULL,'2026-02-01 15:21:22',NULL,NULL),(374,NULL,NULL,'b61897c265784414bb66e4b81bcb541d',NULL,NULL,NULL,NULL,'2026-02-01 15:21:28',NULL,'2026-02-01 15:21:28',NULL,NULL),(375,NULL,NULL,'993325b5a77046aa87e52a805b303ec3',NULL,NULL,NULL,NULL,'2026-02-01 15:21:29',NULL,'2026-02-01 15:21:29',NULL,NULL),(376,NULL,NULL,'ad42389b0c3d4238ad96a94713bfc173',NULL,NULL,NULL,NULL,'2026-02-01 15:21:29',NULL,'2026-02-01 15:21:29',NULL,NULL),(377,NULL,NULL,'30a0e4ce464a45c3ad309a3e951fb78e',NULL,NULL,NULL,NULL,'2026-02-01 15:21:29',NULL,'2026-02-01 15:21:29',NULL,NULL),(378,NULL,'56a9c686073d49c0b397b4a24c383081',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:21:32',NULL,'2026-02-01 15:21:32',NULL,NULL),(379,NULL,'f268d6a092914531b34a1c857947d022',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:21:33',NULL,'2026-02-01 15:21:33',NULL,NULL),(380,NULL,'2a6b18e25e544992bd1905a09335a866',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:21:34',NULL,'2026-02-01 15:21:34',NULL,NULL),(381,NULL,NULL,'a291e3288cd94d34ae8eab924bad7fd1',NULL,NULL,NULL,NULL,'2026-02-01 15:21:47',NULL,'2026-02-01 15:21:47',NULL,NULL),(382,NULL,NULL,'ea0ad1ffc7314e269b800f42e5e3fc3e',NULL,NULL,NULL,NULL,'2026-02-01 15:21:55',NULL,'2026-02-01 15:21:55',NULL,NULL),(383,NULL,NULL,'65077c9fa6774fcd911e6b45033ca890',NULL,NULL,NULL,NULL,'2026-02-01 15:21:55',NULL,'2026-02-01 15:21:55',NULL,NULL),(384,NULL,NULL,'37534013e90844b3bc5ed64ef55effcf',NULL,NULL,NULL,NULL,'2026-02-01 15:21:55',NULL,'2026-02-01 15:21:55',NULL,NULL),(385,NULL,'ebfaf803a1c84c12ac2c950d798c01a3',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:21:57',NULL,'2026-02-01 15:21:57',NULL,NULL),(386,NULL,'fe91c744675c4c02ba53f0d175201045',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:21:58',NULL,'2026-02-01 15:21:58',NULL,NULL),(387,NULL,'1067e3fe10bf47289963e096cf1fb409',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:22:00',NULL,'2026-02-01 15:22:00',NULL,NULL),(388,NULL,NULL,'7bca5be54be248c9a9f30b7004d6b052',NULL,NULL,NULL,NULL,'2026-02-01 15:22:13',NULL,'2026-02-01 15:22:13',NULL,NULL),(389,NULL,NULL,'bd6f5443e9144072bcf2104c071429b2',NULL,NULL,NULL,NULL,'2026-02-01 15:22:20',NULL,'2026-02-01 15:22:20',NULL,NULL),(390,NULL,NULL,'330f6798693a4b3f8157683ef16fbdad',NULL,NULL,NULL,NULL,'2026-02-01 15:22:20',NULL,'2026-02-01 15:22:20',NULL,NULL),(391,NULL,NULL,'496d2e47e67443449bb8143958ac8ed6',NULL,NULL,NULL,NULL,'2026-02-01 15:22:21',NULL,'2026-02-01 15:22:21',NULL,NULL),(392,NULL,'844f34f060ef46f0be5d950e48375eb5',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:22:22',NULL,'2026-02-01 15:22:22',NULL,NULL),(393,NULL,'c3cddd19c56e4aada1bf66d90423b85f',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:22:23',NULL,'2026-02-01 15:22:23',NULL,NULL),(394,NULL,'2d8694da92dd4832b614ce4ad4f8dc37',NULL,NULL,NULL,NULL,NULL,'2026-02-01 15:22:23',NULL,'2026-02-01 15:22:23',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('07c61460ca6743c7ad05341988c1bb54','service','{}','<<null>>',NULL),('42867102abe24930bd95aadeb03fec8a','admin','{}','<<null>>',NULL),('5f57964b5efe488fa780a1869a504070','ResellerAdmin','{}','<<null>>',NULL),('80add9730872481a83b39b8cb69bba78','member','{}','<<null>>',NULL),('ae9fb8eb8e4f482bbf7e3ff32bf462db','reader','{}','<<null>>',NULL),('c14d35f109b4414e82a98faf22fde26e','swiftoperator','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('42867102abe24930bd95aadeb03fec8a','IMMU','true'),('80add9730872481a83b39b8cb69bba78','IMMU','true'),('ae9fb8eb8e4f482bbf7e3ff32bf462db','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('067d071a85294199a5f4559c9093b9fe','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}'),('0bf632b4c5174ce18d11ff5ce7521ab6','object-store',1,'{\"name\": \"swift\", \"description\": \"OpenStack Object Storage\"}'),('3ae2ffe993a241179ffbdcf6a8b14f13','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}'),('4d84a4d4c81649508bb2ece4ccc72e8d','identity',1,'{\"name\": \"keystone\"}'),('5bce741d0c6f43bfbfb8736ceedbd8fa','share',1,'{\"description\": \"Manila V1 Service\", \"name\": \"manila\"}'),('76f992b655724a7181d861b9230b1cf2','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('966e188b29be43a9bdf465a0bcdf843b','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('9cc01676e47f4f8d81a91188a8596259','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}'),('a2238bdfcc4c4c9f857e35a05dbb588d','sharev2',1,'{\"description\": \"Manila V2 Service\", \"name\": \"manilav2\"}'),('ab2a92077d4e4fe7b32c37638e30d257','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('e202ee4ef59042a5b143533b7cfdfc57','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','6c5480d9c8e24961972dcf773c284580','system','42867102abe24930bd95aadeb03fec8a',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_trust_id` (`trust_id`),
  KEY `ix_token_expires` (`expires`),
  KEY `ix_token_expires_valid` (`expires`,`valid`),
  KEY `ix_token_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('2a2c8fad446d4f4c9b74cfb4fb1d81fa','{\"tenantId\": \"dccfb7956a704feea4173610d3df7ccf\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2026-02-01 15:10:38',NULL,'default'),('419f74b7c92e4081b8c92b5dea909597','{}',1,'8a984e5e6d8641aaa8eab606a9587c2e','2026-02-01 14:39:03','2026-02-01','default'),('41ca7e0caad74d90b292c4f1532a90e8','{}',1,'8a984e5e6d8641aaa8eab606a9587c2e','2026-02-01 15:07:40','2026-02-01','default'),('4d9c57e17ee1493893700c697d89628c','{}',1,'8a984e5e6d8641aaa8eab606a9587c2e','2026-02-01 14:38:56',NULL,'default'),('576fa5a6d714434a8b2d8930b05daf0e','{}',1,'8a984e5e6d8641aaa8eab606a9587c2e','2026-02-01 14:39:13','2026-02-01','default'),('5b859fc0c0a149b7a0363a92e4dfd6fb','{}',1,'8a984e5e6d8641aaa8eab606a9587c2e','2026-02-01 14:38:48','2026-02-01','default'),('685c8f1612474643b3544e7f2e3da70f','{}',1,'8a984e5e6d8641aaa8eab606a9587c2e','2026-02-01 14:38:58','2026-02-01','default'),('6b2d9ef024c743f28b406c123163d8c7','{}',1,'8a984e5e6d8641aaa8eab606a9587c2e','2026-02-01 14:38:53','2026-02-01','default'),('6c5480d9c8e24961972dcf773c284580','{}',1,NULL,'2026-02-01 14:37:45','2026-02-01','default'),('756a39b6a47a4f44a5b18daaabd51e2d','{}',1,'8a984e5e6d8641aaa8eab606a9587c2e','2026-02-01 14:38:51','2026-02-01','default'),('c97c34d4fee8479085c0da830c8a103f','{\"tenantId\": \"9a416895d3ea4571af9f8b52029f4558\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2026-02-01 15:10:38',NULL,'default'),('f6e6e2d33fad4ea5aaa43983ab62e42f','{}',1,'8a984e5e6d8641aaa8eab606a9587c2e','2026-02-01 14:52:09',NULL,'default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `manila`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `manila` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `manila`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('aebe2a413e13');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `async_operation_data`
--

DROP TABLE IF EXISTS `async_operation_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `async_operation_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `async_operation_data`
--

LOCK TABLES `async_operation_data` WRITE;
/*!40000 ALTER TABLE `async_operation_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `async_operation_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `availability_zones`
--

DROP TABLE IF EXISTS `availability_zones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `availability_zones` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `az_name_uc` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `availability_zones`
--

LOCK TABLES `availability_zones` WRITE;
/*!40000 ALTER TABLE `availability_zones` DISABLE KEYS */;
INSERT INTO `availability_zones` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`) VALUES ('2026-02-01 15:07:42.155334',NULL,NULL,'False','02c7f679-5981-4fd8-8760-626ef9ae59a0','nova');
/*!40000 ALTER TABLE `availability_zones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backend_info`
--

DROP TABLE IF EXISTS `backend_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backend_info` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `host` varchar(255) NOT NULL,
  `info_hash` varchar(255) NOT NULL,
  PRIMARY KEY (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backend_info`
--

LOCK TABLES `backend_info` WRITE;
/*!40000 ALTER TABLE `backend_info` DISABLE KEYS */;
INSERT INTO `backend_info` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `host`, `info_hash`) VALUES ('2026-02-01 15:07:50.099619',NULL,NULL,0,'hostgroup@cephfs','e66c0dfc0d422efa26af62f5a81dd60603e2d39a');
/*!40000 ALTER TABLE `backend_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `drivers_private_data`
--

DROP TABLE IF EXISTS `drivers_private_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `drivers_private_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `drivers_private_data`
--

LOCK TABLES `drivers_private_data` WRITE;
/*!40000 ALTER TABLE `drivers_private_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `drivers_private_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(255) DEFAULT NULL,
  `resource_id` varchar(36) DEFAULT NULL,
  `action_id` varchar(10) NOT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
INSERT INTO `messages` (`id`, `project_id`, `request_id`, `resource_type`, `resource_id`, `action_id`, `detail_id`, `message_level`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `expires_at`) VALUES ('00172a33-ef08-4a2b-80d2-c470e812148e','d8619226901f4987807454d91d99af93','req-b22de430-a48a-4717-b39e-537646007cc9','SHARE','b471dc19-2401-417a-96e5-e736bb147988','001','008','ERROR','2026-02-01 15:16:32.086902',NULL,NULL,'False','2026-03-03 15:16:32'),('05a28ad0-2610-479d-909b-95a6a753e0e6','d8619226901f4987807454d91d99af93','req-63f04a2c-993d-46be-a4b2-0d50e2896e2a','SHARE','958ab4ab-f5aa-4908-a2a1-1363ed9f1ad6','001','008','ERROR','2026-02-01 15:16:36.032213',NULL,NULL,'False','2026-03-03 15:16:36'),('1fba1d68-75ba-4e34-b19d-6f1705720824','32087184504a4aabb8269aa5ef350c60','req-b44076d7-96cd-4dbd-a324-7557c94f59f8','SHARE','3c436459-63a6-4ad6-adc8-8a42a7ab847a','001','008','ERROR','2026-02-01 15:15:59.945801',NULL,NULL,'False','2026-03-03 15:15:59'),('1ff88130-208e-42cd-a4ea-53a9e2c5e021','32087184504a4aabb8269aa5ef350c60','req-c0ff7127-2855-48a3-a59c-8b168b554b5b','SHARE','6f2a2b5c-0835-4de8-926c-dbdf461c7cd4','001','008','ERROR','2026-02-01 15:15:52.161232',NULL,NULL,'False','2026-03-03 15:15:52'),('46e939c8-5d70-4899-8b75-a37021ff1e82','d8619226901f4987807454d91d99af93','req-48efef9d-3ebd-4586-914c-f1d1cfbd02d8','SHARE','881bb209-1c46-4b4b-808a-d8660e3d8d46','001','008','ERROR','2026-02-01 15:16:49.131457',NULL,NULL,'False','2026-03-03 15:16:49'),('4d631a40-f518-4b16-9f98-f5116a26c1a8','32087184504a4aabb8269aa5ef350c60','req-f3b060f1-6d77-4dac-ae28-99d1b33e6f9f','SHARE','f6d21267-86b4-4a5b-b0bb-04567d756f96','001','008','ERROR','2026-02-01 15:15:32.502292',NULL,'2026-02-01 15:15:35.968289','4d631a40-f518-4b16-9f98-f5116a26c1a8','2026-03-03 15:15:32'),('5e01b320-97bb-45c9-b852-e9717a0e98d6','32087184504a4aabb8269aa5ef350c60','req-90ca76e6-1c24-453e-bfc5-30859e39511b','SHARE','f7bd8de1-9d03-4c74-a408-3d1b24011e23','001','008','ERROR','2026-02-01 15:15:44.544379',NULL,NULL,'False','2026-03-03 15:15:44'),('6f03ead6-6e90-42ec-ac93-2702eec34397','32087184504a4aabb8269aa5ef350c60','req-c7e62194-1714-482c-a970-40582c2fe0d0','SHARE','ab8e28a4-0b20-4886-b306-34d342be02ae','001','008','ERROR','2026-02-01 15:15:48.836359',NULL,NULL,'False','2026-03-03 15:15:48'),('8e2a8b11-2e6a-4dc9-8274-81312a38ff5b','32087184504a4aabb8269aa5ef350c60','req-e31368ca-e318-42ca-ac03-4616116a2f31','SHARE','d582acbc-9c90-4db6-9e3a-b99aad568f88','001','008','ERROR','2026-02-01 15:16:03.430291',NULL,NULL,'False','2026-03-03 15:16:03'),('a5640400-aaab-4445-b620-2d6432a66afd','32087184504a4aabb8269aa5ef350c60','req-57dc27c5-6d51-4e3c-a9ee-c720f2b42a1c','SHARE','80c6994e-ac3e-4df1-b8f0-3220a10b91d6','001','008','ERROR','2026-02-01 15:15:40.816300',NULL,NULL,'False','2026-03-03 15:15:40'),('afd0534c-c90f-4ad7-8fac-1e0e6d082c91','32087184504a4aabb8269aa5ef350c60','req-818d2302-9075-48b6-8fb8-f75783e9278f','SHARE','87bc00c7-ffd8-4d9c-a2b4-29c6bd5ddbd7','001','008','ERROR','2026-02-01 15:15:55.529338',NULL,NULL,'False','2026-03-03 15:15:55'),('bdf473d7-4447-4230-839b-123c88c837d2','32087184504a4aabb8269aa5ef350c60','req-ee8f5b32-cfd6-4ccb-8c41-23e1d69ff3f2','SHARE','452a5ef1-9894-470d-a6d7-5122ea8f2101','001','008','ERROR','2026-02-01 15:16:07.859401',NULL,'2026-02-01 15:16:11.085987','bdf473d7-4447-4230-839b-123c88c837d2','2026-03-03 15:16:07'),('c7f2d914-e05b-46bb-9cd1-4e84a6524795','32087184504a4aabb8269aa5ef350c60','req-1fc83654-01b0-49a9-88ae-ee2b4e3fcc34','SHARE','66030396-f1e3-4abe-a840-a120fdad9e5a','001','008','ERROR','2026-02-01 15:15:36.887090',NULL,NULL,'False','2026-03-03 15:15:36'),('cb29f602-43f8-4353-9c86-0c9fb2ff17aa','e483891a9fd042d4a571a3d4655dc685','req-e97a9a58-f62d-4576-b1d9-69935aba3ed2','SHARE','1dbc87f0-6d96-4be8-901e-294b9b434e06','010','020','ERROR','2026-02-01 15:16:07.239637',NULL,NULL,'False','2026-03-03 15:16:07'),('dd94ab99-0761-43df-96c9-fea46e02ac37','d8619226901f4987807454d91d99af93','req-c4e700e4-8cc9-49f5-bc13-8d7015f2851d','SHARE','e5786088-510e-4fe1-90e0-1b11281ce4ea','001','008','ERROR','2026-02-01 15:16:44.591996',NULL,NULL,'False','2026-03-03 15:16:44'),('eb92e130-74cc-42f4-bbd8-94e2ec8b7702','d8619226901f4987807454d91d99af93','req-6b4dc4aa-4b3d-403e-8834-b6557e228417','SHARE','d1b69db5-857a-4858-96bd-c44e33ddb3fa','001','008','ERROR','2026-02-01 15:16:40.190449',NULL,NULL,'False','2026-03-03 15:16:40');
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `network_allocations`
--

DROP TABLE IF EXISTS `network_allocations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `network_allocations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ip_address` varchar(64) DEFAULT NULL,
  `mac_address` varchar(32) DEFAULT NULL,
  `share_server_id` varchar(36) NOT NULL,
  `label` varchar(255) DEFAULT 'user',
  `network_type` varchar(32) DEFAULT NULL,
  `segmentation_id` int(11) DEFAULT NULL,
  `ip_version` int(11) DEFAULT NULL,
  `cidr` varchar(64) DEFAULT NULL,
  `gateway` varchar(64) DEFAULT NULL,
  `mtu` int(11) DEFAULT NULL,
  `share_network_subnet_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_server_id` (`share_server_id`),
  KEY `fk_network_allocation_subnet_id_share_network_subnets` (`share_network_subnet_id`),
  CONSTRAINT `fk_network_allocation_subnet_id_share_network_subnets` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`),
  CONSTRAINT `network_allocations_ibfk_1` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `network_allocations`
--

LOCK TABLES `network_allocations` WRITE;
/*!40000 ALTER TABLE `network_allocations` DISABLE KEYS */;
/*!40000 ALTER TABLE `network_allocations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_share_type_quotas`
--

DROP TABLE IF EXISTS `project_share_type_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_share_type_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uc_quotas_per_share_types` (`share_type_id`,`resource`,`deleted`,`project_id`),
  CONSTRAINT `share_type_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_share_type_quotas`
--

LOCK TABLES `project_share_type_quotas` WRITE;
/*!40000 ALTER TABLE `project_share_type_quotas` DISABLE KEYS */;
INSERT INTO `project_share_type_quotas` (`id`, `project_id`, `resource`, `hard_limit`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `share_type_id`) VALUES (1,'b2e389a954404c1185b10157107ee036','shares',2,'2026-02-01 15:13:37.243131',NULL,'2026-02-01 15:14:10.877779',1,'7f348200-99b9-44a8-a2c6-6a72a85cdd23'),(2,'b2e389a954404c1185b10157107ee036','gigabytes',4,'2026-02-01 15:13:37.249217',NULL,'2026-02-01 15:14:10.877779',2,'7f348200-99b9-44a8-a2c6-6a72a85cdd23'),(3,'b2e389a954404c1185b10157107ee036','shares',2,'2026-02-01 15:13:37.388355',NULL,'2026-02-01 15:14:10.721637',3,'e90f5e35-a2e5-4b1f-b6c6-9946da8a57e6'),(4,'b2e389a954404c1185b10157107ee036','gigabytes',4,'2026-02-01 15:13:37.392384',NULL,'2026-02-01 15:14:10.721637',4,'e90f5e35-a2e5-4b1f-b6c6-9946da8a57e6'),(5,'b2e389a954404c1185b10157107ee036','shares',53,'2026-02-01 15:13:53.339110',NULL,'2026-02-01 15:13:53.546170',5,'9114c675-bbd4-440c-9a05-4ed1fac81a44'),(6,'b2e389a954404c1185b10157107ee036','snapshots',53,'2026-02-01 15:13:53.361151',NULL,'2026-02-01 15:13:53.546170',6,'9114c675-bbd4-440c-9a05-4ed1fac81a44'),(7,'b2e389a954404c1185b10157107ee036','gigabytes',1003,'2026-02-01 15:13:53.394323',NULL,'2026-02-01 15:13:53.546170',7,'9114c675-bbd4-440c-9a05-4ed1fac81a44'),(8,'b2e389a954404c1185b10157107ee036','snapshot_gigabytes',1003,'2026-02-01 15:13:53.409439',NULL,'2026-02-01 15:13:53.546170',8,'9114c675-bbd4-440c-9a05-4ed1fac81a44'),(9,'b2e389a954404c1185b10157107ee036','share_replicas',103,'2026-02-01 15:13:53.417966',NULL,'2026-02-01 15:13:53.546170',9,'9114c675-bbd4-440c-9a05-4ed1fac81a44'),(10,'b2e389a954404c1185b10157107ee036','replica_gigabytes',1003,'2026-02-01 15:13:53.449463',NULL,'2026-02-01 15:13:53.546170',10,'9114c675-bbd4-440c-9a05-4ed1fac81a44'),(11,'b2e389a954404c1185b10157107ee036','shares',53,'2026-02-01 15:13:54.412029',NULL,'2026-02-01 15:13:54.736413',11,'9e90c581-8d78-460e-b301-defa031060ec'),(12,'b2e389a954404c1185b10157107ee036','snapshots',53,'2026-02-01 15:13:54.475854',NULL,'2026-02-01 15:13:54.736413',12,'9e90c581-8d78-460e-b301-defa031060ec'),(13,'b2e389a954404c1185b10157107ee036','gigabytes',1003,'2026-02-01 15:13:54.494933',NULL,'2026-02-01 15:13:54.736413',13,'9e90c581-8d78-460e-b301-defa031060ec'),(14,'b2e389a954404c1185b10157107ee036','snapshot_gigabytes',1003,'2026-02-01 15:13:54.528444',NULL,'2026-02-01 15:13:54.736413',14,'9e90c581-8d78-460e-b301-defa031060ec'),(15,'b2e389a954404c1185b10157107ee036','share_replicas',103,'2026-02-01 15:13:54.557110',NULL,'2026-02-01 15:13:54.736413',15,'9e90c581-8d78-460e-b301-defa031060ec'),(16,'b2e389a954404c1185b10157107ee036','replica_gigabytes',1003,'2026-02-01 15:13:54.574166',NULL,'2026-02-01 15:13:54.736413',16,'9e90c581-8d78-460e-b301-defa031060ec'),(17,'b2e389a954404c1185b10157107ee036','shares',12,'2026-02-01 15:13:56.263484',NULL,'2026-02-01 15:14:10.248429',17,'a3b7beff-4595-4850-98fa-669e777a38c9'),(18,'b2e389a954404c1185b10157107ee036','shares',49,'2026-02-01 15:14:01.582795',NULL,'2026-02-01 15:14:10.029081',18,'03c5147f-9e6b-4926-80d2-2e0e507b08d2'),(19,'b2e389a954404c1185b10157107ee036','gigabytes',999,'2026-02-01 15:14:01.773870',NULL,'2026-02-01 15:14:10.029081',19,'03c5147f-9e6b-4926-80d2-2e0e507b08d2'),(20,'b2e389a954404c1185b10157107ee036','snapshots',49,'2026-02-01 15:14:01.907376',NULL,'2026-02-01 15:14:10.029081',20,'03c5147f-9e6b-4926-80d2-2e0e507b08d2'),(21,'b2e389a954404c1185b10157107ee036','snapshot_gigabytes',999,'2026-02-01 15:14:01.992891',NULL,'2026-02-01 15:14:10.029081',21,'03c5147f-9e6b-4926-80d2-2e0e507b08d2'),(22,'b2e389a954404c1185b10157107ee036','share_replicas',99,'2026-02-01 15:14:02.224950',NULL,'2026-02-01 15:14:10.029081',22,'03c5147f-9e6b-4926-80d2-2e0e507b08d2'),(23,'b2e389a954404c1185b10157107ee036','replica_gigabytes',999,'2026-02-01 15:14:02.525989',NULL,'2026-02-01 15:14:10.029081',23,'03c5147f-9e6b-4926-80d2-2e0e507b08d2'),(24,'b2e389a954404c1185b10157107ee036','shares',49,'2026-02-01 15:14:02.938536',NULL,'2026-02-01 15:14:09.868763',24,'3b6eca57-06cd-4d6a-bf82-8e23cd5238d3'),(25,'b2e389a954404c1185b10157107ee036','gigabytes',999,'2026-02-01 15:14:03.048588',NULL,'2026-02-01 15:14:09.868763',25,'3b6eca57-06cd-4d6a-bf82-8e23cd5238d3'),(26,'b2e389a954404c1185b10157107ee036','snapshots',49,'2026-02-01 15:14:03.173322',NULL,'2026-02-01 15:14:09.868763',26,'3b6eca57-06cd-4d6a-bf82-8e23cd5238d3'),(27,'b2e389a954404c1185b10157107ee036','snapshot_gigabytes',999,'2026-02-01 15:14:03.324424',NULL,'2026-02-01 15:14:09.868763',27,'3b6eca57-06cd-4d6a-bf82-8e23cd5238d3'),(28,'b2e389a954404c1185b10157107ee036','share_replicas',99,'2026-02-01 15:14:03.414329',NULL,'2026-02-01 15:14:09.868763',28,'3b6eca57-06cd-4d6a-bf82-8e23cd5238d3'),(29,'b2e389a954404c1185b10157107ee036','replica_gigabytes',999,'2026-02-01 15:14:03.554655',NULL,'2026-02-01 15:14:09.868763',29,'3b6eca57-06cd-4d6a-bf82-8e23cd5238d3'),(30,'b2e389a954404c1185b10157107ee036','shares',11,'2026-02-01 15:14:04.007733',NULL,'2026-02-01 15:14:09.667074',30,'3bcbd413-15ba-4ae3-819c-9320c76eabc3'),(31,'b2e389a954404c1185b10157107ee036','shares',-1,'2026-02-01 15:14:04.367383',NULL,'2026-02-01 15:14:09.481713',31,'3ba0e84a-ff42-45fe-8a24-be94314611c1');
/*!40000 ALTER TABLE `project_share_type_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_user_quotas`
--

DROP TABLE IF EXISTS `project_user_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_user_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `resource` varchar(25) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_user_quotas`
--

LOCK TABLES `project_user_quotas` WRITE;
/*!40000 ALTER TABLE `project_user_quotas` DISABLE KEYS */;
INSERT INTO `project_user_quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `user_id`, `project_id`, `resource`, `hard_limit`) VALUES (1,'2026-02-01 15:13:37.106662',NULL,'2026-02-01 15:13:52.570846',1,'fbd576f00c6b445aadb79ba9a35844e4','b2e389a954404c1185b10157107ee036','shares',2),(2,'2026-02-01 15:13:37.111814',NULL,'2026-02-01 15:13:52.570846',2,'fbd576f00c6b445aadb79ba9a35844e4','b2e389a954404c1185b10157107ee036','gigabytes',7),(3,'2026-02-01 15:13:56.130294',NULL,'2026-02-01 15:13:56.334699',3,'fbd576f00c6b445aadb79ba9a35844e4','b2e389a954404c1185b10157107ee036','shares',11),(4,'2026-02-01 15:13:59.037117',NULL,'2026-02-01 15:13:59.250432',4,'fbd576f00c6b445aadb79ba9a35844e4','b2e389a954404c1185b10157107ee036','gigabytes',-1),(5,'2026-02-01 15:13:59.358045',NULL,'2026-02-01 15:13:59.516523',5,'fbd576f00c6b445aadb79ba9a35844e4','b2e389a954404c1185b10157107ee036','share_replicas',-1),(6,'2026-02-01 15:13:59.681573',NULL,'2026-02-01 15:13:59.821764',6,'fbd576f00c6b445aadb79ba9a35844e4','b2e389a954404c1185b10157107ee036','replica_gigabytes',-1),(7,'2026-02-01 15:13:59.927576',NULL,'2026-02-01 15:14:00.205327',7,'fbd576f00c6b445aadb79ba9a35844e4','b2e389a954404c1185b10157107ee036','share_networks',-1),(8,'2026-02-01 15:14:00.300289',NULL,'2026-02-01 15:14:00.469607',8,'fbd576f00c6b445aadb79ba9a35844e4','b2e389a954404c1185b10157107ee036','shares',-1),(9,'2026-02-01 15:14:00.574061',NULL,'2026-02-01 15:14:00.897331',9,'fbd576f00c6b445aadb79ba9a35844e4','b2e389a954404c1185b10157107ee036','snapshot_gigabytes',-1),(10,'2026-02-01 15:14:01.005191',NULL,'2026-02-01 15:14:01.268374',10,'fbd576f00c6b445aadb79ba9a35844e4','b2e389a954404c1185b10157107ee036','snapshots',-1),(11,'2026-02-01 15:14:05.849307',NULL,'2026-02-01 15:14:05.918427',11,'fbd576f00c6b445aadb79ba9a35844e4','b2e389a954404c1185b10157107ee036','gigabytes',999),(12,'2026-02-01 15:14:06.430212',NULL,'2026-02-01 15:14:06.518627',12,'fbd576f00c6b445aadb79ba9a35844e4','b2e389a954404c1185b10157107ee036','share_replicas',99),(13,'2026-02-01 15:14:07.153955',NULL,'2026-02-01 15:14:07.238716',13,'fbd576f00c6b445aadb79ba9a35844e4','b2e389a954404c1185b10157107ee036','replica_gigabytes',999),(14,'2026-02-01 15:14:07.434651',NULL,'2026-02-01 15:14:07.527093',14,'fbd576f00c6b445aadb79ba9a35844e4','b2e389a954404c1185b10157107ee036','share_networks',9),(15,'2026-02-01 15:14:07.815173',NULL,'2026-02-01 15:14:07.877019',15,'fbd576f00c6b445aadb79ba9a35844e4','b2e389a954404c1185b10157107ee036','shares',49),(16,'2026-02-01 15:14:08.065112',NULL,'2026-02-01 15:14:08.223124',16,'fbd576f00c6b445aadb79ba9a35844e4','b2e389a954404c1185b10157107ee036','snapshot_gigabytes',999),(17,'2026-02-01 15:14:08.408583',NULL,'2026-02-01 15:14:08.483148',17,'fbd576f00c6b445aadb79ba9a35844e4','b2e389a954404c1185b10157107ee036','snapshots',49),(18,'2026-02-01 15:14:08.812184',NULL,'2026-02-01 15:14:08.909766',18,'fbd576f00c6b445aadb79ba9a35844e4','b2e389a954404c1185b10157107ee036','shares',11),(19,'2026-02-01 15:14:09.220665',NULL,'2026-02-01 15:14:09.297017',19,'fbd576f00c6b445aadb79ba9a35844e4','b2e389a954404c1185b10157107ee036','shares',-1);
/*!40000 ALTER TABLE `project_user_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_usages_project_id` (`project_id`)
) ENGINE=InnoDB AUTO_INCREMENT=270 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `share_type_id`) VALUES ('2026-02-01 15:13:06.741463','2026-02-01 15:14:21.412587',NULL,0,1,'435a807314d045b7b6183b8871d538b0','fda4ab42f467487d8e5d3007a76e3476','gigabytes',0,0,NULL,NULL),('2026-02-01 15:13:06.744717','2026-02-01 15:14:21.412590',NULL,0,2,'435a807314d045b7b6183b8871d538b0','fda4ab42f467487d8e5d3007a76e3476','shares',0,0,NULL,NULL),('2026-02-01 15:13:06.754245','2026-02-01 15:14:21.412592','2026-02-01 15:14:24.313743',3,3,NULL,'fda4ab42f467487d8e5d3007a76e3476','gigabytes',0,0,NULL,'d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:06.756556','2026-02-01 15:14:21.412593','2026-02-01 15:14:24.313743',4,4,NULL,'fda4ab42f467487d8e5d3007a76e3476','shares',0,0,NULL,'d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:07.645457','2026-02-01 15:13:15.848925',NULL,0,5,'e19059c3227c4ea5b508cf825c284a38','7d7793c430934c04a024af92c3ca805f','gigabytes',0,0,NULL,NULL),('2026-02-01 15:13:07.649009','2026-02-01 15:13:15.848928',NULL,0,6,'e19059c3227c4ea5b508cf825c284a38','7d7793c430934c04a024af92c3ca805f','shares',0,0,NULL,NULL),('2026-02-01 15:13:07.663468','2026-02-01 15:13:15.848929','2026-02-01 15:13:19.230393',7,7,NULL,'7d7793c430934c04a024af92c3ca805f','gigabytes',0,0,NULL,'7c625ff0-e084-42b2-8f17-359cee73602b'),('2026-02-01 15:13:07.667254','2026-02-01 15:13:15.848930','2026-02-01 15:13:19.230393',8,8,NULL,'7d7793c430934c04a024af92c3ca805f','shares',0,0,NULL,'7c625ff0-e084-42b2-8f17-359cee73602b'),('2026-02-01 15:13:08.085793','2026-02-01 15:13:20.853975',NULL,0,9,'cfc88dace67943ebb2cda941b51534e0','cf2f906871624fa0887af8f21afda469','gigabytes',0,0,NULL,NULL),('2026-02-01 15:13:08.087809','2026-02-01 15:13:20.853978',NULL,0,10,'cfc88dace67943ebb2cda941b51534e0','cf2f906871624fa0887af8f21afda469','shares',0,0,NULL,NULL),('2026-02-01 15:13:08.098635','2026-02-01 15:13:20.853979','2026-02-01 15:13:24.026729',11,11,NULL,'cf2f906871624fa0887af8f21afda469','gigabytes',0,0,NULL,'a36752ae-228c-4fa4-8961-f141e5222f47'),('2026-02-01 15:13:08.100942','2026-02-01 15:13:20.853981','2026-02-01 15:13:24.026729',12,12,NULL,'cf2f906871624fa0887af8f21afda469','shares',0,0,NULL,'a36752ae-228c-4fa4-8961-f141e5222f47'),('2026-02-01 15:13:11.846307','2026-02-01 15:13:17.266314',NULL,0,13,'cfc88dace67943ebb2cda941b51534e0','cf2f906871624fa0887af8f21afda469','snapshot_gigabytes',0,0,NULL,NULL),('2026-02-01 15:13:11.850612','2026-02-01 15:13:17.266319',NULL,0,14,'cfc88dace67943ebb2cda941b51534e0','cf2f906871624fa0887af8f21afda469','snapshots',0,0,NULL,NULL),('2026-02-01 15:13:11.861203','2026-02-01 15:13:17.266322','2026-02-01 15:13:24.026729',15,15,NULL,'cf2f906871624fa0887af8f21afda469','snapshot_gigabytes',0,0,NULL,'a36752ae-228c-4fa4-8961-f141e5222f47'),('2026-02-01 15:13:11.864296','2026-02-01 15:13:17.266324','2026-02-01 15:13:24.026729',16,16,NULL,'cf2f906871624fa0887af8f21afda469','snapshots',0,0,NULL,'a36752ae-228c-4fa4-8961-f141e5222f47'),('2026-02-01 15:13:20.212742','2026-02-01 15:13:26.482564',NULL,0,17,'dd3dddd74c80436eae71170aed36a00b','e97ebfd6a3764df8b7badde8319f1a16','gigabytes',0,0,NULL,NULL),('2026-02-01 15:13:20.214708','2026-02-01 15:13:26.482567',NULL,0,18,'dd3dddd74c80436eae71170aed36a00b','e97ebfd6a3764df8b7badde8319f1a16','shares',0,0,NULL,NULL),('2026-02-01 15:13:20.228807','2026-02-01 15:13:26.482568','2026-02-01 15:13:29.721888',19,19,NULL,'e97ebfd6a3764df8b7badde8319f1a16','gigabytes',0,0,NULL,'3cd49bbe-54fc-43fb-9feb-ba0c28e6948f'),('2026-02-01 15:13:20.230967','2026-02-01 15:13:26.482569','2026-02-01 15:13:29.721888',20,20,NULL,'e97ebfd6a3764df8b7badde8319f1a16','shares',0,0,NULL,'3cd49bbe-54fc-43fb-9feb-ba0c28e6948f'),('2026-02-01 15:13:34.413382','2026-02-01 15:13:34.451278','2026-02-01 15:13:38.116975',21,21,'2bbd6a9be41643a38007238edf9638fe','fc17e54c678d41c68e219a1686c0fe7d','gigabytes',1,0,NULL,NULL),('2026-02-01 15:13:34.416121','2026-02-01 15:13:34.451281','2026-02-01 15:13:38.116975',22,22,'2bbd6a9be41643a38007238edf9638fe','fc17e54c678d41c68e219a1686c0fe7d','shares',1,0,NULL,NULL),('2026-02-01 15:13:34.424416','2026-02-01 15:13:34.451282','2026-02-01 15:13:38.116975',23,23,NULL,'fc17e54c678d41c68e219a1686c0fe7d','gigabytes',1,0,NULL,'b1712ae3-d38a-4543-bf30-4854aff75f83'),('2026-02-01 15:13:34.426842','2026-02-01 15:13:34.451283','2026-02-01 15:13:38.116975',24,24,NULL,'fc17e54c678d41c68e219a1686c0fe7d','shares',1,0,NULL,'b1712ae3-d38a-4543-bf30-4854aff75f83'),('2026-02-01 15:13:37.512576','2026-02-01 15:13:48.941520','2026-02-01 15:13:52.573085',25,25,'fbd576f00c6b445aadb79ba9a35844e4','b2e389a954404c1185b10157107ee036','gigabytes',0,0,NULL,NULL),('2026-02-01 15:13:37.514502','2026-02-01 15:13:48.941523','2026-02-01 15:13:52.573085',26,26,'fbd576f00c6b445aadb79ba9a35844e4','b2e389a954404c1185b10157107ee036','shares',0,0,NULL,NULL),('2026-02-01 15:13:37.522384','2026-02-01 15:13:45.650223','2026-02-01 15:13:52.720065',27,27,NULL,'b2e389a954404c1185b10157107ee036','gigabytes',0,0,NULL,'7f348200-99b9-44a8-a2c6-6a72a85cdd23'),('2026-02-01 15:13:37.524334','2026-02-01 15:13:45.650225','2026-02-01 15:13:52.720065',28,28,NULL,'b2e389a954404c1185b10157107ee036','shares',0,0,NULL,'7f348200-99b9-44a8-a2c6-6a72a85cdd23'),('2026-02-01 15:13:38.351667','2026-02-01 15:13:38.618046','2026-02-01 15:13:45.949304',29,29,'2bbd6a9be41643a38007238edf9638fe','fc17e54c678d41c68e219a1686c0fe7d','gigabytes',2,0,NULL,NULL),('2026-02-01 15:13:38.355574','2026-02-01 15:13:38.618049','2026-02-01 15:13:45.949304',30,30,'2bbd6a9be41643a38007238edf9638fe','fc17e54c678d41c68e219a1686c0fe7d','shares',2,0,NULL,NULL),('2026-02-01 15:13:38.589832','2026-02-01 15:13:38.618051','2026-02-01 15:13:45.949304',31,31,NULL,'fc17e54c678d41c68e219a1686c0fe7d','gigabytes',1,0,NULL,'3dda19bc-6043-431c-bdc6-b4dc346cfacf'),('2026-02-01 15:13:38.591741','2026-02-01 15:13:38.618052','2026-02-01 15:13:45.949304',32,32,NULL,'fc17e54c678d41c68e219a1686c0fe7d','shares',1,0,NULL,'3dda19bc-6043-431c-bdc6-b4dc346cfacf'),('2026-02-01 15:13:41.450413','2026-02-01 15:13:48.941524','2026-02-01 15:13:52.720065',33,33,NULL,'b2e389a954404c1185b10157107ee036','gigabytes',0,0,NULL,'e90f5e35-a2e5-4b1f-b6c6-9946da8a57e6'),('2026-02-01 15:13:41.452474','2026-02-01 15:13:48.941526','2026-02-01 15:13:52.720065',34,34,NULL,'b2e389a954404c1185b10157107ee036','shares',0,0,NULL,'e90f5e35-a2e5-4b1f-b6c6-9946da8a57e6'),('2026-02-01 15:13:42.323333','2026-02-01 15:13:42.418425','2026-02-01 15:13:45.949304',35,35,'2bbd6a9be41643a38007238edf9638fe','fc17e54c678d41c68e219a1686c0fe7d','snapshot_gigabytes',1,0,NULL,NULL),('2026-02-01 15:13:42.327046','2026-02-01 15:13:42.418428','2026-02-01 15:13:45.949304',36,36,'2bbd6a9be41643a38007238edf9638fe','fc17e54c678d41c68e219a1686c0fe7d','snapshots',1,0,NULL,NULL),('2026-02-01 15:13:42.339862','2026-02-01 15:13:42.418429','2026-02-01 15:13:45.949304',37,37,NULL,'fc17e54c678d41c68e219a1686c0fe7d','snapshot_gigabytes',1,0,NULL,'3dda19bc-6043-431c-bdc6-b4dc346cfacf'),('2026-02-01 15:13:42.344241','2026-02-01 15:13:42.418431','2026-02-01 15:13:45.949304',38,38,NULL,'fc17e54c678d41c68e219a1686c0fe7d','snapshots',1,0,NULL,'3dda19bc-6043-431c-bdc6-b4dc346cfacf'),('2026-02-01 15:13:42.794714','2026-02-01 15:14:20.342379',NULL,0,39,'435a807314d045b7b6183b8871d538b0','fda4ab42f467487d8e5d3007a76e3476','snapshots',0,0,NULL,NULL),('2026-02-01 15:13:42.798576','2026-02-01 15:14:20.342381',NULL,0,40,'435a807314d045b7b6183b8871d538b0','fda4ab42f467487d8e5d3007a76e3476','snapshot_gigabytes',0,0,NULL,NULL),('2026-02-01 15:13:42.814559','2026-02-01 15:14:20.342382','2026-02-01 15:14:24.313743',41,41,NULL,'fda4ab42f467487d8e5d3007a76e3476','snapshots',0,0,NULL,'d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:42.817857','2026-02-01 15:14:20.342384','2026-02-01 15:14:24.313743',42,42,NULL,'fda4ab42f467487d8e5d3007a76e3476','snapshot_gigabytes',0,0,NULL,'d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:45.092100','2026-02-01 15:13:50.364054',NULL,0,43,'6c7a6c983b3a451a96f18889cebd862d','c24c8bba1312447c8305abcf7b1ff259','gigabytes',0,0,NULL,NULL),('2026-02-01 15:13:45.093706','2026-02-01 15:13:50.364056',NULL,0,44,'6c7a6c983b3a451a96f18889cebd862d','c24c8bba1312447c8305abcf7b1ff259','shares',0,0,NULL,NULL),('2026-02-01 15:13:45.101702','2026-02-01 15:13:50.364057','2026-02-01 15:13:53.404897',45,45,NULL,'c24c8bba1312447c8305abcf7b1ff259','gigabytes',0,0,NULL,'b107dc0b-a3d2-4667-a455-9555f6c00178'),('2026-02-01 15:13:45.103956','2026-02-01 15:13:50.364058','2026-02-01 15:13:53.404897',46,46,NULL,'c24c8bba1312447c8305abcf7b1ff259','shares',0,0,NULL,'b107dc0b-a3d2-4667-a455-9555f6c00178'),('2026-02-01 15:13:54.802178','2026-02-01 15:13:54.886262',NULL,0,47,'2bbd6a9be41643a38007238edf9638fe','fc17e54c678d41c68e219a1686c0fe7d','snapshot_gigabytes',-1,0,NULL,NULL),('2026-02-01 15:13:54.805941','2026-02-01 15:13:54.886265',NULL,0,48,'2bbd6a9be41643a38007238edf9638fe','fc17e54c678d41c68e219a1686c0fe7d','snapshots',-1,0,NULL,NULL),('2026-02-01 15:13:54.850723','2026-02-01 15:13:54.886267','2026-02-01 15:14:01.471684',49,49,NULL,'fc17e54c678d41c68e219a1686c0fe7d','snapshot_gigabytes',-1,0,NULL,'3dda19bc-6043-431c-bdc6-b4dc346cfacf'),('2026-02-01 15:13:54.853759','2026-02-01 15:13:54.886268','2026-02-01 15:14:01.471684',50,50,NULL,'fc17e54c678d41c68e219a1686c0fe7d','snapshots',-1,0,NULL,'3dda19bc-6043-431c-bdc6-b4dc346cfacf'),('2026-02-01 15:13:58.230378','2026-02-01 15:14:02.134352',NULL,0,51,'2bbd6a9be41643a38007238edf9638fe','fc17e54c678d41c68e219a1686c0fe7d','gigabytes',0,0,NULL,NULL),('2026-02-01 15:13:58.235436','2026-02-01 15:14:02.134354',NULL,0,52,'2bbd6a9be41643a38007238edf9638fe','fc17e54c678d41c68e219a1686c0fe7d','shares',0,0,NULL,NULL),('2026-02-01 15:13:58.254760','2026-02-01 15:13:58.268640','2026-02-01 15:14:01.471684',53,53,NULL,'fc17e54c678d41c68e219a1686c0fe7d','gigabytes',0,0,NULL,'3dda19bc-6043-431c-bdc6-b4dc346cfacf'),('2026-02-01 15:13:58.258073','2026-02-01 15:13:58.268642','2026-02-01 15:14:01.471684',54,54,NULL,'fc17e54c678d41c68e219a1686c0fe7d','shares',0,0,NULL,'3dda19bc-6043-431c-bdc6-b4dc346cfacf'),('2026-02-01 15:14:02.107448','2026-02-01 15:14:02.134355','2026-02-01 15:14:05.241774',55,55,NULL,'fc17e54c678d41c68e219a1686c0fe7d','gigabytes',0,0,NULL,'b1712ae3-d38a-4543-bf30-4854aff75f83'),('2026-02-01 15:14:02.112211','2026-02-01 15:14:02.134357','2026-02-01 15:14:05.241774',56,56,NULL,'fc17e54c678d41c68e219a1686c0fe7d','shares',0,0,NULL,'b1712ae3-d38a-4543-bf30-4854aff75f83'),('2026-02-01 15:14:04.081389','2026-02-01 15:14:09.558581',NULL,0,57,'d490148597b44e68bee9a9fe258ee233','999f6f2ae9a8410ca0b94eca9aa23d7a','gigabytes',0,0,NULL,NULL),('2026-02-01 15:14:04.083349','2026-02-01 15:14:09.558585',NULL,0,58,'d490148597b44e68bee9a9fe258ee233','999f6f2ae9a8410ca0b94eca9aa23d7a','shares',0,0,NULL,NULL),('2026-02-01 15:14:04.091408','2026-02-01 15:14:09.558587','2026-02-01 15:14:12.266270',59,59,NULL,'999f6f2ae9a8410ca0b94eca9aa23d7a','gigabytes',0,0,NULL,'8c72e4a5-abce-45c1-bd37-67b1570e670b'),('2026-02-01 15:14:04.093202','2026-02-01 15:14:09.558589','2026-02-01 15:14:12.266270',60,60,NULL,'999f6f2ae9a8410ca0b94eca9aa23d7a','shares',0,0,NULL,'8c72e4a5-abce-45c1-bd37-67b1570e670b'),('2026-02-01 15:14:18.383896','2026-02-01 15:14:22.864851',NULL,0,61,'52393b023cd64393a0b3cc33f7cf9b0f','be07a91869e4476fbc553f85525ca866','gigabytes',0,0,NULL,NULL),('2026-02-01 15:14:18.388808','2026-02-01 15:14:22.864855',NULL,0,62,'52393b023cd64393a0b3cc33f7cf9b0f','be07a91869e4476fbc553f85525ca866','shares',0,0,NULL,NULL),('2026-02-01 15:14:18.399366','2026-02-01 15:14:22.864857','2026-02-01 15:14:26.043602',63,63,NULL,'be07a91869e4476fbc553f85525ca866','gigabytes',0,0,NULL,'ae5ac208-d3f1-42e4-bd31-25e0fbedb1a8'),('2026-02-01 15:14:18.402803','2026-02-01 15:14:22.864859','2026-02-01 15:14:26.043602',64,64,NULL,'be07a91869e4476fbc553f85525ca866','shares',0,0,NULL,'ae5ac208-d3f1-42e4-bd31-25e0fbedb1a8'),('2026-02-01 15:14:23.728687','2026-02-01 15:15:13.659848',NULL,0,65,'928da2f6147a4b708835fcbebf483d8a','8148327cebed4bb49e576111ce3edff1','gigabytes',0,0,NULL,NULL),('2026-02-01 15:14:23.731353','2026-02-01 15:15:13.659851',NULL,0,66,'928da2f6147a4b708835fcbebf483d8a','8148327cebed4bb49e576111ce3edff1','shares',0,0,NULL,NULL),('2026-02-01 15:14:23.746453','2026-02-01 15:15:13.659852','2026-02-01 15:15:16.816101',67,67,NULL,'8148327cebed4bb49e576111ce3edff1','gigabytes',0,0,NULL,'71a8cb03-a879-4fa1-9570-d4a2c3127be2'),('2026-02-01 15:14:23.748488','2026-02-01 15:15:13.659853','2026-02-01 15:15:16.816101',68,68,NULL,'8148327cebed4bb49e576111ce3edff1','shares',0,0,NULL,'71a8cb03-a879-4fa1-9570-d4a2c3127be2'),('2026-02-01 15:14:31.838361','2026-02-01 15:14:34.186830',NULL,0,69,'8aed0688b51d4ff0a0a064f11d0b453b','9daf6f5120ad4addbf1be43b336ab548','share_networks',0,0,NULL,NULL),('2026-02-01 15:14:32.398719','2026-02-01 15:14:32.444248',NULL,0,70,'08f88d0b6ec54c79a8bfec726694c073','389354672a9f45998c217a07289430b9','share_networks',1,0,NULL,NULL),('2026-02-01 15:14:39.472832','2026-02-01 15:14:59.522675',NULL,0,71,'26e3e1d8b04f4d09b6941b9eed4bed81','42d5324bd181499ca11dbc92c8e1556c','gigabytes',0,0,NULL,NULL),('2026-02-01 15:14:39.480840','2026-02-01 15:14:59.522679',NULL,0,72,'26e3e1d8b04f4d09b6941b9eed4bed81','42d5324bd181499ca11dbc92c8e1556c','shares',0,0,NULL,NULL),('2026-02-01 15:14:39.495134','2026-02-01 15:14:59.522681','2026-02-01 15:15:02.553411',73,73,NULL,'42d5324bd181499ca11dbc92c8e1556c','gigabytes',0,0,NULL,'c056af43-2681-4a32-98f6-e60c1f1a3560'),('2026-02-01 15:14:39.497690','2026-02-01 15:14:59.522683','2026-02-01 15:15:02.553411',74,74,NULL,'42d5324bd181499ca11dbc92c8e1556c','shares',0,0,NULL,'c056af43-2681-4a32-98f6-e60c1f1a3560'),('2026-02-01 15:14:43.137786','2026-02-01 15:14:56.193311',NULL,0,75,'26e3e1d8b04f4d09b6941b9eed4bed81','42d5324bd181499ca11dbc92c8e1556c','snapshot_gigabytes',0,0,NULL,NULL),('2026-02-01 15:14:43.141068','2026-02-01 15:14:56.193313',NULL,0,76,'26e3e1d8b04f4d09b6941b9eed4bed81','42d5324bd181499ca11dbc92c8e1556c','snapshots',0,0,NULL,NULL),('2026-02-01 15:14:43.153011','2026-02-01 15:14:56.193315','2026-02-01 15:15:02.553411',77,77,NULL,'42d5324bd181499ca11dbc92c8e1556c','snapshot_gigabytes',0,0,NULL,'c056af43-2681-4a32-98f6-e60c1f1a3560'),('2026-02-01 15:14:43.156395','2026-02-01 15:14:56.193316','2026-02-01 15:15:02.553411',78,78,NULL,'42d5324bd181499ca11dbc92c8e1556c','snapshots',0,0,NULL,'c056af43-2681-4a32-98f6-e60c1f1a3560'),('2026-02-01 15:14:47.368154','2026-02-01 15:15:03.231504',NULL,0,79,'2c641459542741e59f6414cbb91ed187','b3c21deb7cba41feaff782713b1775e6','gigabytes',0,0,NULL,NULL),('2026-02-01 15:14:47.370365','2026-02-01 15:15:03.231507',NULL,0,80,'2c641459542741e59f6414cbb91ed187','b3c21deb7cba41feaff782713b1775e6','shares',0,0,NULL,NULL),('2026-02-01 15:14:47.383998','2026-02-01 15:15:03.231510','2026-02-01 15:15:06.417175',81,81,NULL,'b3c21deb7cba41feaff782713b1775e6','gigabytes',0,0,NULL,'d8cb87c7-b9fa-4c1f-978a-61b318980e99'),('2026-02-01 15:14:47.386038','2026-02-01 15:15:03.231511','2026-02-01 15:15:06.417175',82,82,NULL,'b3c21deb7cba41feaff782713b1775e6','shares',0,0,NULL,'d8cb87c7-b9fa-4c1f-978a-61b318980e99'),('2026-02-01 15:14:55.563015','2026-02-01 15:15:00.983216',NULL,0,83,'e47de2b4135b4005af9009853f7a18dd','4ed32334aab64e5388ef8e859555acf4','gigabytes',0,0,NULL,NULL),('2026-02-01 15:14:55.564906','2026-02-01 15:15:00.983218',NULL,0,84,'e47de2b4135b4005af9009853f7a18dd','4ed32334aab64e5388ef8e859555acf4','shares',0,0,NULL,NULL),('2026-02-01 15:14:55.578200','2026-02-01 15:15:00.983220','2026-02-01 15:15:04.087532',85,85,NULL,'4ed32334aab64e5388ef8e859555acf4','gigabytes',0,0,NULL,'f6afe9eb-b901-4be4-a89a-bc6dc1369ca5'),('2026-02-01 15:14:55.581367','2026-02-01 15:15:00.983221','2026-02-01 15:15:04.087532',86,86,NULL,'4ed32334aab64e5388ef8e859555acf4','shares',0,0,NULL,'f6afe9eb-b901-4be4-a89a-bc6dc1369ca5'),('2026-02-01 15:15:09.372203','2026-02-01 15:15:21.258961',NULL,0,87,'32efe54ffae74acfbb12e72ef8334608','46cbc131a820464a9b6cd0940829aea6','gigabytes',0,0,NULL,NULL),('2026-02-01 15:15:09.374608','2026-02-01 15:15:21.258965',NULL,0,88,'32efe54ffae74acfbb12e72ef8334608','46cbc131a820464a9b6cd0940829aea6','shares',0,0,NULL,NULL),('2026-02-01 15:15:09.396564','2026-02-01 15:15:21.258967','2026-02-01 15:15:24.446944',89,89,NULL,'46cbc131a820464a9b6cd0940829aea6','gigabytes',0,0,NULL,'61d66fc8-1151-4700-8fe3-06f0671259ab'),('2026-02-01 15:15:09.398775','2026-02-01 15:15:21.258968','2026-02-01 15:15:24.446944',90,90,NULL,'46cbc131a820464a9b6cd0940829aea6','shares',0,0,NULL,'61d66fc8-1151-4700-8fe3-06f0671259ab'),('2026-02-01 15:15:12.718948','2026-02-01 15:15:24.042624',NULL,0,91,'6c83c28e021c4717b45ee6d416ec31f5','0dfd4148452647aa845013a982630bb0','gigabytes',0,0,NULL,NULL),('2026-02-01 15:15:12.720793','2026-02-01 15:15:24.042627',NULL,0,92,'6c83c28e021c4717b45ee6d416ec31f5','0dfd4148452647aa845013a982630bb0','shares',0,0,NULL,NULL),('2026-02-01 15:15:12.728316','2026-02-01 15:15:24.042629','2026-02-01 15:15:35.493011',93,93,NULL,'0dfd4148452647aa845013a982630bb0','gigabytes',0,0,NULL,'70f1e3e3-1df6-4e6a-972a-e4316600cd5d'),('2026-02-01 15:15:12.730237','2026-02-01 15:15:24.042630','2026-02-01 15:15:35.493011',94,94,NULL,'0dfd4148452647aa845013a982630bb0','shares',0,0,NULL,'70f1e3e3-1df6-4e6a-972a-e4316600cd5d'),('2026-02-01 15:15:13.179239','2026-02-01 15:15:17.619392',NULL,0,95,'32efe54ffae74acfbb12e72ef8334608','46cbc131a820464a9b6cd0940829aea6','snapshots',0,0,NULL,NULL),('2026-02-01 15:15:13.181460','2026-02-01 15:15:17.619396',NULL,0,96,'32efe54ffae74acfbb12e72ef8334608','46cbc131a820464a9b6cd0940829aea6','snapshot_gigabytes',0,0,NULL,NULL),('2026-02-01 15:15:13.189484','2026-02-01 15:15:17.619398','2026-02-01 15:15:24.446944',97,97,NULL,'46cbc131a820464a9b6cd0940829aea6','snapshots',0,0,NULL,'61d66fc8-1151-4700-8fe3-06f0671259ab'),('2026-02-01 15:15:13.191242','2026-02-01 15:15:17.619400','2026-02-01 15:15:24.446944',98,98,NULL,'46cbc131a820464a9b6cd0940829aea6','snapshot_gigabytes',0,0,NULL,'61d66fc8-1151-4700-8fe3-06f0671259ab'),('2026-02-01 15:15:16.389736','2026-02-01 15:15:31.899002',NULL,0,99,'2f14b61aac5c41f78a2c8a4963295b65','b60d48ce6ed84a0499e61efc92fe4ff7','gigabytes',0,0,NULL,NULL),('2026-02-01 15:15:16.392850','2026-02-01 15:15:31.899005',NULL,0,100,'2f14b61aac5c41f78a2c8a4963295b65','b60d48ce6ed84a0499e61efc92fe4ff7','shares',0,0,NULL,NULL),('2026-02-01 15:15:16.405567','2026-02-01 15:15:31.899008','2026-02-01 15:15:35.493011',101,101,NULL,'b60d48ce6ed84a0499e61efc92fe4ff7','gigabytes',0,0,NULL,'70f1e3e3-1df6-4e6a-972a-e4316600cd5d'),('2026-02-01 15:15:16.407781','2026-02-01 15:15:31.899010','2026-02-01 15:15:35.493011',102,102,NULL,'b60d48ce6ed84a0499e61efc92fe4ff7','shares',0,0,NULL,'70f1e3e3-1df6-4e6a-972a-e4316600cd5d'),('2026-02-01 15:15:32.364701','2026-02-01 15:16:11.306391',NULL,0,103,'6f2dab9328424993aa458427358720d9','32087184504a4aabb8269aa5ef350c60','gigabytes',0,0,NULL,NULL),('2026-02-01 15:15:32.366694','2026-02-01 15:16:11.306396',NULL,0,104,'6f2dab9328424993aa458427358720d9','32087184504a4aabb8269aa5ef350c60','shares',0,0,NULL,NULL),('2026-02-01 15:15:32.378047','2026-02-01 15:15:36.537036','2026-02-01 15:16:12.761349',105,105,NULL,'32087184504a4aabb8269aa5ef350c60','gigabytes',0,0,NULL,'e40bf1b4-fd26-4fd8-95d0-210613d1d862'),('2026-02-01 15:15:32.381490','2026-02-01 15:15:36.537037','2026-02-01 15:16:12.761349',106,106,NULL,'32087184504a4aabb8269aa5ef350c60','shares',0,0,NULL,'e40bf1b4-fd26-4fd8-95d0-210613d1d862'),('2026-02-01 15:15:35.193487','2026-02-01 15:16:40.746561',NULL,0,107,'795592d89a1d46e4a844c4a238d332e3','e483891a9fd042d4a571a3d4655dc685','gigabytes',0,0,NULL,NULL),('2026-02-01 15:15:35.195980','2026-02-01 15:16:40.746564',NULL,0,108,'795592d89a1d46e4a844c4a238d332e3','e483891a9fd042d4a571a3d4655dc685','shares',0,0,NULL,NULL),('2026-02-01 15:15:35.211355','2026-02-01 15:16:40.746603','2026-02-01 15:16:43.678073',109,109,NULL,'e483891a9fd042d4a571a3d4655dc685','gigabytes',0,0,NULL,'847063aa-e54d-49d1-b390-6611881b6691'),('2026-02-01 15:15:35.214921','2026-02-01 15:16:40.746605','2026-02-01 15:16:43.678073',110,110,NULL,'e483891a9fd042d4a571a3d4655dc685','shares',0,0,NULL,'847063aa-e54d-49d1-b390-6611881b6691'),('2026-02-01 15:15:36.793979','2026-02-01 15:15:40.511645','2026-02-01 15:16:12.611457',111,111,NULL,'32087184504a4aabb8269aa5ef350c60','gigabytes',0,0,NULL,'d3e4a564-7be4-42a0-848e-6cd396381438'),('2026-02-01 15:15:36.795787','2026-02-01 15:15:40.511646','2026-02-01 15:16:12.611457',112,112,NULL,'32087184504a4aabb8269aa5ef350c60','shares',0,0,NULL,'d3e4a564-7be4-42a0-848e-6cd396381438'),('2026-02-01 15:15:38.998635','2026-02-01 15:16:37.040792',NULL,0,113,NULL,'e483891a9fd042d4a571a3d4655dc685','gigabytes',0,0,NULL,'29b95f67-19b6-4d0c-881b-ecde5688f59a'),('2026-02-01 15:15:39.000720','2026-02-01 15:16:37.040793',NULL,0,114,NULL,'e483891a9fd042d4a571a3d4655dc685','shares',0,0,NULL,'29b95f67-19b6-4d0c-881b-ecde5688f59a'),('2026-02-01 15:15:40.695558','2026-02-01 15:15:48.430035','2026-02-01 15:16:12.395703',115,115,NULL,'32087184504a4aabb8269aa5ef350c60','gigabytes',0,0,NULL,'d3a796c1-974d-4d4f-86d6-31e24af5bf80'),('2026-02-01 15:15:40.699004','2026-02-01 15:15:48.430036','2026-02-01 15:16:12.395703',116,116,NULL,'32087184504a4aabb8269aa5ef350c60','shares',0,0,NULL,'d3a796c1-974d-4d4f-86d6-31e24af5bf80'),('2026-02-01 15:15:43.076072','2026-02-01 15:16:46.721384',NULL,0,117,'e9e626045c924c8c981ad3f67a1dedd6','f99925486e924480b84b05e1433af949','gigabytes',0,0,NULL,NULL),('2026-02-01 15:15:43.078253','2026-02-01 15:16:46.721387',NULL,0,118,'e9e626045c924c8c981ad3f67a1dedd6','f99925486e924480b84b05e1433af949','shares',0,0,NULL,NULL),('2026-02-01 15:15:43.087191','2026-02-01 15:16:46.721388','2026-02-01 15:16:50.233374',119,119,NULL,'f99925486e924480b84b05e1433af949','gigabytes',0,0,NULL,'a811e5d0-f6d5-4017-bb5f-544fc27e7e76'),('2026-02-01 15:15:43.089645','2026-02-01 15:16:46.721389','2026-02-01 15:16:50.233374',120,120,NULL,'f99925486e924480b84b05e1433af949','shares',0,0,NULL,'a811e5d0-f6d5-4017-bb5f-544fc27e7e76'),('2026-02-01 15:15:44.416500','2026-02-01 15:15:48.128401','2026-02-01 15:16:12.249653',121,121,NULL,'32087184504a4aabb8269aa5ef350c60','gigabytes',0,0,NULL,'275a2dc4-58d1-4887-a5f2-1450bb6710b6'),('2026-02-01 15:15:44.419298','2026-02-01 15:15:48.128402','2026-02-01 15:16:12.249653',122,122,NULL,'32087184504a4aabb8269aa5ef350c60','shares',0,0,NULL,'275a2dc4-58d1-4887-a5f2-1450bb6710b6'),('2026-02-01 15:15:45.915272','2026-02-01 15:16:33.463082',NULL,0,123,'e513aa3b998a4d7c9d1e07492d61bda1','2731ddbed05046f3bee55c8f307163b2','gigabytes',0,0,NULL,NULL),('2026-02-01 15:15:45.917047','2026-02-01 15:16:33.463085',NULL,0,124,'e513aa3b998a4d7c9d1e07492d61bda1','2731ddbed05046f3bee55c8f307163b2','shares',0,0,NULL,NULL),('2026-02-01 15:15:45.925376','2026-02-01 15:16:33.463086',NULL,0,125,NULL,'2731ddbed05046f3bee55c8f307163b2','gigabytes',0,0,NULL,'29b95f67-19b6-4d0c-881b-ecde5688f59a'),('2026-02-01 15:15:45.927506','2026-02-01 15:16:33.463087',NULL,0,126,NULL,'2731ddbed05046f3bee55c8f307163b2','shares',0,0,NULL,'29b95f67-19b6-4d0c-881b-ecde5688f59a'),('2026-02-01 15:15:48.688423','2026-02-01 15:15:59.618785','2026-02-01 15:16:12.065801',127,127,NULL,'32087184504a4aabb8269aa5ef350c60','gigabytes',0,0,NULL,'d66ef10c-1a48-4389-a804-c7ab5e8f314d'),('2026-02-01 15:15:48.690778','2026-02-01 15:15:59.618786','2026-02-01 15:16:12.065801',128,128,NULL,'32087184504a4aabb8269aa5ef350c60','shares',0,0,NULL,'d66ef10c-1a48-4389-a804-c7ab5e8f314d'),('2026-02-01 15:15:48.885173','2026-02-01 15:16:12.741452',NULL,0,129,'c768e3f3500c4bf19dcf4fcf64856998','0d63dabe67144e93ab3137e7893f5f60','gigabytes',0,0,NULL,NULL),('2026-02-01 15:15:48.889285','2026-02-01 15:16:12.741460',NULL,0,130,'c768e3f3500c4bf19dcf4fcf64856998','0d63dabe67144e93ab3137e7893f5f60','shares',0,0,NULL,NULL),('2026-02-01 15:15:48.913363','2026-02-01 15:16:12.741462','2026-02-01 15:16:15.911507',131,131,NULL,'0d63dabe67144e93ab3137e7893f5f60','gigabytes',0,0,NULL,'120a16ad-b887-4c32-bd69-d344d97a4eee'),('2026-02-01 15:15:48.916934','2026-02-01 15:16:12.741465','2026-02-01 15:16:15.911507',132,132,NULL,'0d63dabe67144e93ab3137e7893f5f60','shares',0,0,NULL,'120a16ad-b887-4c32-bd69-d344d97a4eee'),('2026-02-01 15:15:52.060893','2026-02-01 15:15:59.377058','2026-02-01 15:16:11.893848',133,133,NULL,'32087184504a4aabb8269aa5ef350c60','gigabytes',0,0,NULL,'45a106aa-92ee-46aa-8dbd-e51e979b3fbb'),('2026-02-01 15:15:52.062688','2026-02-01 15:15:59.377060','2026-02-01 15:16:11.893848',134,134,NULL,'32087184504a4aabb8269aa5ef350c60','shares',0,0,NULL,'45a106aa-92ee-46aa-8dbd-e51e979b3fbb'),('2026-02-01 15:15:52.259205','2026-02-01 15:16:09.237945',NULL,0,135,'c768e3f3500c4bf19dcf4fcf64856998','0d63dabe67144e93ab3137e7893f5f60','snapshots',0,0,NULL,NULL),('2026-02-01 15:15:52.260842','2026-02-01 15:16:09.237950',NULL,0,136,'c768e3f3500c4bf19dcf4fcf64856998','0d63dabe67144e93ab3137e7893f5f60','snapshot_gigabytes',0,0,NULL,NULL),('2026-02-01 15:15:52.269423','2026-02-01 15:16:09.237953','2026-02-01 15:16:15.911507',137,137,NULL,'0d63dabe67144e93ab3137e7893f5f60','snapshots',0,0,NULL,'120a16ad-b887-4c32-bd69-d344d97a4eee'),('2026-02-01 15:15:52.271159','2026-02-01 15:16:09.237955','2026-02-01 15:16:15.911507',138,138,NULL,'0d63dabe67144e93ab3137e7893f5f60','snapshot_gigabytes',0,0,NULL,'120a16ad-b887-4c32-bd69-d344d97a4eee'),('2026-02-01 15:15:55.422174','2026-02-01 15:15:59.053035','2026-02-01 15:16:11.764639',139,139,NULL,'32087184504a4aabb8269aa5ef350c60','gigabytes',0,0,NULL,'07adc9ef-2272-4b23-ba8b-3bc6ea05d153'),('2026-02-01 15:15:55.424453','2026-02-01 15:15:59.053037','2026-02-01 15:16:11.764639',140,140,NULL,'32087184504a4aabb8269aa5ef350c60','shares',0,0,NULL,'07adc9ef-2272-4b23-ba8b-3bc6ea05d153'),('2026-02-01 15:15:59.818298','2026-02-01 15:16:07.507268','2026-02-01 15:16:11.645186',141,141,NULL,'32087184504a4aabb8269aa5ef350c60','gigabytes',0,0,NULL,'64010b88-05ad-4c28-a92b-293b13eb246e'),('2026-02-01 15:15:59.820417','2026-02-01 15:16:07.507270','2026-02-01 15:16:11.645186',142,142,NULL,'32087184504a4aabb8269aa5ef350c60','shares',0,0,NULL,'64010b88-05ad-4c28-a92b-293b13eb246e'),('2026-02-01 15:16:03.341659','2026-02-01 15:16:07.179902','2026-02-01 15:16:11.521199',143,143,NULL,'32087184504a4aabb8269aa5ef350c60','gigabytes',0,0,NULL,'bb53296f-97b7-42cf-8d24-8b3c547491c9'),('2026-02-01 15:16:03.343752','2026-02-01 15:16:07.179903','2026-02-01 15:16:11.521199',144,144,NULL,'32087184504a4aabb8269aa5ef350c60','shares',0,0,NULL,'bb53296f-97b7-42cf-8d24-8b3c547491c9'),('2026-02-01 15:16:07.742391','2026-02-01 15:16:11.306398','2026-02-01 15:16:11.386254',145,145,NULL,'32087184504a4aabb8269aa5ef350c60','gigabytes',0,0,NULL,'5334ac45-44fc-49d0-95bb-7c266db24118'),('2026-02-01 15:16:07.744249','2026-02-01 15:16:11.306400','2026-02-01 15:16:11.386254',146,146,NULL,'32087184504a4aabb8269aa5ef350c60','shares',0,0,NULL,'5334ac45-44fc-49d0-95bb-7c266db24118'),('2026-02-01 15:16:14.129787','2026-02-01 15:16:29.956460','2026-02-01 15:16:43.678073',147,147,NULL,'2731ddbed05046f3bee55c8f307163b2','gigabytes',0,0,NULL,'847063aa-e54d-49d1-b390-6611881b6691'),('2026-02-01 15:16:14.133324','2026-02-01 15:16:29.956462','2026-02-01 15:16:43.678073',148,148,NULL,'2731ddbed05046f3bee55c8f307163b2','shares',0,0,NULL,'847063aa-e54d-49d1-b390-6611881b6691'),('2026-02-01 15:16:30.752340','2026-02-01 15:16:35.703091',NULL,0,149,'9143810fbee74a7799490ac3fc1032dd','c12690bcab10459c81103ff11e371488','gigabytes',0,0,NULL,NULL),('2026-02-01 15:16:30.754798','2026-02-01 15:16:35.703094',NULL,0,150,'9143810fbee74a7799490ac3fc1032dd','c12690bcab10459c81103ff11e371488','shares',0,0,NULL,NULL),('2026-02-01 15:16:30.764716','2026-02-01 15:16:35.703095','2026-02-01 15:16:38.711183',151,151,NULL,'c12690bcab10459c81103ff11e371488','gigabytes',0,0,NULL,'63d145b6-fb37-4811-991f-0edbfd2cd9ff'),('2026-02-01 15:16:30.766751','2026-02-01 15:16:35.703097','2026-02-01 15:16:38.711183',152,152,NULL,'c12690bcab10459c81103ff11e371488','shares',0,0,NULL,'63d145b6-fb37-4811-991f-0edbfd2cd9ff'),('2026-02-01 15:16:31.953045','2026-02-01 15:16:52.884480',NULL,0,153,'627361eeb4bc410fb28e040badc59d2c','d8619226901f4987807454d91d99af93','gigabytes',0,0,NULL,NULL),('2026-02-01 15:16:31.955724','2026-02-01 15:16:52.884482',NULL,0,154,'627361eeb4bc410fb28e040badc59d2c','d8619226901f4987807454d91d99af93','shares',0,0,NULL,NULL),('2026-02-01 15:16:31.970699','2026-02-01 15:16:35.677087','2026-02-01 15:16:54.297733',155,155,NULL,'d8619226901f4987807454d91d99af93','gigabytes',0,0,NULL,'6e4527c7-6f92-4531-b150-fbe437acbc5f'),('2026-02-01 15:16:31.973264','2026-02-01 15:16:35.677089','2026-02-01 15:16:54.297733',156,156,NULL,'d8619226901f4987807454d91d99af93','shares',0,0,NULL,'6e4527c7-6f92-4531-b150-fbe437acbc5f'),('2026-02-01 15:16:35.913552','2026-02-01 15:16:39.803823','2026-02-01 15:16:54.065001',157,157,NULL,'d8619226901f4987807454d91d99af93','gigabytes',0,0,NULL,'37d89b9e-0f7e-463d-91bf-eac4c891403e'),('2026-02-01 15:16:35.918336','2026-02-01 15:16:39.803825','2026-02-01 15:16:54.065001',158,158,NULL,'d8619226901f4987807454d91d99af93','shares',0,0,NULL,'37d89b9e-0f7e-463d-91bf-eac4c891403e'),('2026-02-01 15:16:40.067851','2026-02-01 15:16:44.027045','2026-02-01 15:16:53.876780',159,159,NULL,'d8619226901f4987807454d91d99af93','gigabytes',0,0,NULL,'6e184f8e-4cd9-43fc-856f-053e93d4bd03'),('2026-02-01 15:16:40.073572','2026-02-01 15:16:44.027046','2026-02-01 15:16:53.876780',160,160,NULL,'d8619226901f4987807454d91d99af93','shares',0,0,NULL,'6e184f8e-4cd9-43fc-856f-053e93d4bd03'),('2026-02-01 15:16:44.428185','2026-02-01 15:16:48.562232','2026-02-01 15:16:53.557552',161,161,NULL,'d8619226901f4987807454d91d99af93','gigabytes',0,0,NULL,'aceeeaf5-0220-422f-ad4e-febda069bdd9'),('2026-02-01 15:16:44.432436','2026-02-01 15:16:48.562233','2026-02-01 15:16:53.557552',162,162,NULL,'d8619226901f4987807454d91d99af93','shares',0,0,NULL,'aceeeaf5-0220-422f-ad4e-febda069bdd9'),('2026-02-01 15:16:49.010258','2026-02-01 15:16:52.884484','2026-02-01 15:16:53.338157',163,163,NULL,'d8619226901f4987807454d91d99af93','gigabytes',0,0,NULL,'1ee8abb9-5f19-4316-b114-c5b3500a2ff5'),('2026-02-01 15:16:49.012829','2026-02-01 15:16:52.884485','2026-02-01 15:16:53.338157',164,164,NULL,'d8619226901f4987807454d91d99af93','shares',0,0,NULL,'1ee8abb9-5f19-4316-b114-c5b3500a2ff5'),('2026-02-01 15:16:52.283707','2026-02-01 15:20:07.232747',NULL,0,165,'465443f98ace4b989c787808b3cda30c','7043f01f29d441a4801c5afbb65b54e3','gigabytes',0,0,NULL,NULL),('2026-02-01 15:16:52.286150','2026-02-01 15:20:07.232749',NULL,0,166,'465443f98ace4b989c787808b3cda30c','7043f01f29d441a4801c5afbb65b54e3','shares',0,0,NULL,NULL),('2026-02-01 15:16:52.293743','2026-02-01 15:20:07.232751',NULL,0,167,NULL,'7043f01f29d441a4801c5afbb65b54e3','gigabytes',1,0,NULL,'5b0c2719-9cba-4adb-b36c-2f65cfd23a4c'),('2026-02-01 15:16:52.295375','2026-02-01 15:20:07.232752',NULL,0,168,NULL,'7043f01f29d441a4801c5afbb65b54e3','shares',1,0,NULL,'5b0c2719-9cba-4adb-b36c-2f65cfd23a4c'),('2026-02-01 15:16:59.074558','2026-02-01 15:18:08.081172',NULL,0,169,'746730afb3db4d7f80045269f8973474','120c1822ab9548c2815485bc30d42a55','gigabytes',0,0,NULL,NULL),('2026-02-01 15:16:59.077110','2026-02-01 15:18:08.081174',NULL,0,170,'746730afb3db4d7f80045269f8973474','120c1822ab9548c2815485bc30d42a55','shares',0,0,NULL,NULL),('2026-02-01 15:16:59.089848','2026-02-01 15:17:10.189675','2026-02-01 15:17:13.418902',171,171,NULL,'120c1822ab9548c2815485bc30d42a55','gigabytes',0,0,NULL,'01cc7ed9-ffd6-4668-816c-0807ff3b9e16'),('2026-02-01 15:16:59.092786','2026-02-01 15:17:10.189677','2026-02-01 15:17:13.418902',172,172,NULL,'120c1822ab9548c2815485bc30d42a55','shares',0,0,NULL,'01cc7ed9-ffd6-4668-816c-0807ff3b9e16'),('2026-02-01 15:17:02.600482','2026-02-01 15:18:04.481583',NULL,0,173,'746730afb3db4d7f80045269f8973474','120c1822ab9548c2815485bc30d42a55','snapshot_gigabytes',0,0,NULL,NULL),('2026-02-01 15:17:02.602165','2026-02-01 15:18:04.481587',NULL,0,174,'746730afb3db4d7f80045269f8973474','120c1822ab9548c2815485bc30d42a55','snapshots',0,0,NULL,NULL),('2026-02-01 15:17:02.609207','2026-02-01 15:17:06.504718','2026-02-01 15:17:13.418902',175,175,NULL,'120c1822ab9548c2815485bc30d42a55','snapshot_gigabytes',0,0,NULL,'01cc7ed9-ffd6-4668-816c-0807ff3b9e16'),('2026-02-01 15:17:02.610947','2026-02-01 15:17:06.504720','2026-02-01 15:17:13.418902',176,176,NULL,'120c1822ab9548c2815485bc30d42a55','snapshots',0,0,NULL,'01cc7ed9-ffd6-4668-816c-0807ff3b9e16'),('2026-02-01 15:17:03.281787','2026-02-01 15:17:30.138101',NULL,0,177,'78165cb2bbac42ca957ac7fa7010927e','557407533ddd4b83a57f3bf0896f77ac','gigabytes',0,0,NULL,NULL),('2026-02-01 15:17:03.283514','2026-02-01 15:17:30.138105',NULL,0,178,'78165cb2bbac42ca957ac7fa7010927e','557407533ddd4b83a57f3bf0896f77ac','shares',0,0,NULL,NULL),('2026-02-01 15:17:03.296434','2026-02-01 15:17:30.138108','2026-02-01 15:17:31.919313',179,179,NULL,'557407533ddd4b83a57f3bf0896f77ac','gigabytes',0,0,NULL,'04283c6a-2cd4-4e89-807e-97c9144c5657'),('2026-02-01 15:17:03.298345','2026-02-01 15:17:30.138109','2026-02-01 15:17:31.919313',180,180,NULL,'557407533ddd4b83a57f3bf0896f77ac','shares',0,0,NULL,'04283c6a-2cd4-4e89-807e-97c9144c5657'),('2026-02-01 15:17:03.548823','2026-02-01 15:17:03.848656',NULL,0,181,'09a6b5beaf9f4e96b8a8b3f1d67a192d','d3906373bc57497a8593cc485bc49810','share_networks',1,0,NULL,NULL),('2026-02-01 15:17:13.794664','2026-02-01 15:17:18.274691','2026-02-01 15:18:12.273032',182,182,NULL,'120c1822ab9548c2815485bc30d42a55','gigabytes',0,0,NULL,'f74f4e50-b67a-4dd2-8817-d029903f2283'),('2026-02-01 15:17:13.797534','2026-02-01 15:17:18.274693','2026-02-01 15:18:12.273032',183,183,NULL,'120c1822ab9548c2815485bc30d42a55','shares',0,0,NULL,'f74f4e50-b67a-4dd2-8817-d029903f2283'),('2026-02-01 15:17:21.692543','2026-02-01 15:18:08.081176','2026-02-01 15:18:11.172295',184,184,NULL,'120c1822ab9548c2815485bc30d42a55','gigabytes',0,0,NULL,'9e8345c3-c425-444a-948b-e657e9fcd15d'),('2026-02-01 15:17:21.694341','2026-02-01 15:18:08.081177','2026-02-01 15:18:11.172295',185,185,NULL,'120c1822ab9548c2815485bc30d42a55','shares',0,0,NULL,'9e8345c3-c425-444a-948b-e657e9fcd15d'),('2026-02-01 15:17:22.682245','2026-02-01 15:18:15.434351',NULL,0,186,'3cf00994b85e4b779e6717ae76e983b5','368b363545bf449ebeb73c7917747ead','gigabytes',0,0,NULL,NULL),('2026-02-01 15:17:22.684268','2026-02-01 15:18:15.434354',NULL,0,187,'3cf00994b85e4b779e6717ae76e983b5','368b363545bf449ebeb73c7917747ead','shares',0,0,NULL,NULL),('2026-02-01 15:17:22.695413','2026-02-01 15:18:15.434355','2026-02-01 15:18:18.562604',188,188,NULL,'368b363545bf449ebeb73c7917747ead','gigabytes',0,0,NULL,'9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:17:22.697457','2026-02-01 15:18:15.434356','2026-02-01 15:18:18.562604',189,189,NULL,'368b363545bf449ebeb73c7917747ead','shares',0,0,NULL,'9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:17:25.160353','2026-02-01 15:18:04.481588','2026-02-01 15:18:11.172295',190,190,NULL,'120c1822ab9548c2815485bc30d42a55','snapshot_gigabytes',0,0,NULL,'9e8345c3-c425-444a-948b-e657e9fcd15d'),('2026-02-01 15:17:25.162176','2026-02-01 15:18:04.481589','2026-02-01 15:18:11.172295',191,191,NULL,'120c1822ab9548c2815485bc30d42a55','snapshots',0,0,NULL,'9e8345c3-c425-444a-948b-e657e9fcd15d'),('2026-02-01 15:17:26.195804','2026-02-01 15:18:11.903895',NULL,0,192,'3cf00994b85e4b779e6717ae76e983b5','368b363545bf449ebeb73c7917747ead','snapshot_gigabytes',0,0,NULL,NULL),('2026-02-01 15:17:26.200086','2026-02-01 15:18:11.903898',NULL,0,193,'3cf00994b85e4b779e6717ae76e983b5','368b363545bf449ebeb73c7917747ead','snapshots',0,0,NULL,NULL),('2026-02-01 15:17:26.418853','2026-02-01 15:18:11.903900','2026-02-01 15:18:18.562604',194,194,NULL,'368b363545bf449ebeb73c7917747ead','snapshot_gigabytes',0,0,NULL,'9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:17:26.421149','2026-02-01 15:18:11.903901','2026-02-01 15:18:18.562604',195,195,NULL,'368b363545bf449ebeb73c7917747ead','snapshots',0,0,NULL,'9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:17:48.331643','2026-02-01 15:18:00.279349',NULL,0,196,'60095238b9444c4bbf425950ca283c97','5e1261fa63b348dd8c26883b016255c5','gigabytes',0,0,NULL,NULL),('2026-02-01 15:17:48.333815','2026-02-01 15:18:00.279353',NULL,0,197,'60095238b9444c4bbf425950ca283c97','5e1261fa63b348dd8c26883b016255c5','shares',0,0,NULL,NULL),('2026-02-01 15:17:48.343317','2026-02-01 15:18:00.279355','2026-02-01 15:18:02.873999',198,198,NULL,'5e1261fa63b348dd8c26883b016255c5','gigabytes',0,0,NULL,'4a6a9091-c2d9-4ce4-85d0-0da2193297bc'),('2026-02-01 15:17:48.345698','2026-02-01 15:18:00.279356','2026-02-01 15:18:02.873999',199,199,NULL,'5e1261fa63b348dd8c26883b016255c5','shares',0,0,NULL,'4a6a9091-c2d9-4ce4-85d0-0da2193297bc'),('2026-02-01 15:17:51.663383','2026-02-01 15:17:56.448844',NULL,0,200,'60095238b9444c4bbf425950ca283c97','5e1261fa63b348dd8c26883b016255c5','snapshot_gigabytes',0,0,NULL,NULL),('2026-02-01 15:17:51.665515','2026-02-01 15:17:56.448846',NULL,0,201,'60095238b9444c4bbf425950ca283c97','5e1261fa63b348dd8c26883b016255c5','snapshots',0,0,NULL,NULL),('2026-02-01 15:17:51.675230','2026-02-01 15:17:56.448848','2026-02-01 15:18:02.873999',202,202,NULL,'5e1261fa63b348dd8c26883b016255c5','snapshot_gigabytes',0,0,NULL,'4a6a9091-c2d9-4ce4-85d0-0da2193297bc'),('2026-02-01 15:17:51.676992','2026-02-01 15:17:56.448849','2026-02-01 15:18:02.873999',203,203,NULL,'5e1261fa63b348dd8c26883b016255c5','snapshots',0,0,NULL,'4a6a9091-c2d9-4ce4-85d0-0da2193297bc'),('2026-02-01 15:18:19.664747','2026-02-01 15:18:22.418252',NULL,0,204,'6868c6d8625240428c32f8df11c67fd6','8b0415f100a1429bba93cf802c51baee','share_networks',0,0,NULL,NULL),('2026-02-01 15:18:20.040158','2026-02-01 15:19:44.036213',NULL,0,205,'a6d2572f8b864e0793ea67a069edbe05','40dced376e0d4d23b2b7de2c3fc8bd0e','gigabytes',0,0,NULL,NULL),('2026-02-01 15:18:20.042082','2026-02-01 15:19:44.036216',NULL,0,206,'a6d2572f8b864e0793ea67a069edbe05','40dced376e0d4d23b2b7de2c3fc8bd0e','shares',0,0,NULL,NULL),('2026-02-01 15:18:20.051232','2026-02-01 15:19:44.036217','2026-02-01 15:19:47.155083',207,207,NULL,'40dced376e0d4d23b2b7de2c3fc8bd0e','gigabytes',0,0,NULL,'83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:18:20.053651','2026-02-01 15:19:44.036218','2026-02-01 15:19:47.155083',208,208,NULL,'40dced376e0d4d23b2b7de2c3fc8bd0e','shares',0,0,NULL,'83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:18:23.610111','2026-02-01 15:19:40.416115',NULL,0,209,'a6d2572f8b864e0793ea67a069edbe05','40dced376e0d4d23b2b7de2c3fc8bd0e','snapshot_gigabytes',0,0,NULL,NULL),('2026-02-01 15:18:23.612993','2026-02-01 15:19:40.416120',NULL,0,210,'a6d2572f8b864e0793ea67a069edbe05','40dced376e0d4d23b2b7de2c3fc8bd0e','snapshots',0,0,NULL,NULL),('2026-02-01 15:18:23.622625','2026-02-01 15:19:40.416123','2026-02-01 15:19:47.155083',211,211,NULL,'40dced376e0d4d23b2b7de2c3fc8bd0e','snapshot_gigabytes',0,0,NULL,'83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:18:23.625863','2026-02-01 15:19:40.416126','2026-02-01 15:19:47.155083',212,212,NULL,'40dced376e0d4d23b2b7de2c3fc8bd0e','snapshots',0,0,NULL,'83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:18:26.219860','2026-02-01 15:18:51.815575',NULL,0,213,'24edeab99fbb48d7b16cdeb517c6a575','5d1e833d258140798bbddb15095488d9','gigabytes',0,0,NULL,NULL),('2026-02-01 15:18:26.222981','2026-02-01 15:18:51.815578',NULL,0,214,'24edeab99fbb48d7b16cdeb517c6a575','5d1e833d258140798bbddb15095488d9','shares',0,0,NULL,NULL),('2026-02-01 15:18:26.235282','2026-02-01 15:18:51.815579','2026-02-01 15:18:54.937225',215,215,NULL,'5d1e833d258140798bbddb15095488d9','gigabytes',0,0,NULL,'c2e98db5-6825-4e4c-8366-569c74530e00'),('2026-02-01 15:18:26.239463','2026-02-01 15:18:51.815580','2026-02-01 15:18:54.937225',216,216,NULL,'5d1e833d258140798bbddb15095488d9','shares',0,0,NULL,'c2e98db5-6825-4e4c-8366-569c74530e00'),('2026-02-01 15:18:28.326636','2026-02-01 15:18:29.693418',NULL,0,217,'b941253886a049d88d77c1e476049e76','563730bce3db420f8fb732bed1fdd719','share_networks',1,0,NULL,NULL),('2026-02-01 15:18:29.744516','2026-02-01 15:18:48.434293',NULL,0,218,'24edeab99fbb48d7b16cdeb517c6a575','5d1e833d258140798bbddb15095488d9','snapshot_gigabytes',0,0,NULL,NULL),('2026-02-01 15:18:29.747920','2026-02-01 15:18:48.434295',NULL,0,219,'24edeab99fbb48d7b16cdeb517c6a575','5d1e833d258140798bbddb15095488d9','snapshots',0,0,NULL,NULL),('2026-02-01 15:18:29.758310','2026-02-01 15:18:48.434297','2026-02-01 15:18:54.937225',220,220,NULL,'5d1e833d258140798bbddb15095488d9','snapshot_gigabytes',0,0,NULL,'c2e98db5-6825-4e4c-8366-569c74530e00'),('2026-02-01 15:18:29.761728','2026-02-01 15:18:48.434298','2026-02-01 15:18:54.937225',221,221,NULL,'5d1e833d258140798bbddb15095488d9','snapshots',0,0,NULL,'c2e98db5-6825-4e4c-8366-569c74530e00'),('2026-02-01 15:18:38.987080','2026-02-01 15:18:51.027169',NULL,0,222,'f6d8ffe9f1a64b1693065611bbe19c67','7736a9c671f04e42b35558bfde737fc8','gigabytes',1,0,NULL,NULL),('2026-02-01 15:18:38.989953','2026-02-01 15:18:51.027172',NULL,0,223,'f6d8ffe9f1a64b1693065611bbe19c67','7736a9c671f04e42b35558bfde737fc8','shares',1,0,NULL,NULL),('2026-02-01 15:18:39.008447','2026-02-01 15:18:51.027173','2026-02-01 15:18:54.974060',224,224,NULL,'7736a9c671f04e42b35558bfde737fc8','gigabytes',1,0,NULL,'deaa419b-0383-4513-8c9a-24b9d74cd8e2'),('2026-02-01 15:18:39.014754','2026-02-01 15:18:51.027174','2026-02-01 15:18:54.974060',225,225,NULL,'7736a9c671f04e42b35558bfde737fc8','shares',1,0,NULL,'deaa419b-0383-4513-8c9a-24b9d74cd8e2'),('2026-02-01 15:18:42.691130','2026-02-01 15:18:44.087369',NULL,0,226,'b4519508f74d4e4bab6f8c3da6388d49','2c31b44d86274d9c9323bcb7f0a754dd','gigabytes',0,0,NULL,NULL),('2026-02-01 15:18:42.692829','2026-02-01 15:18:44.087372',NULL,0,227,'b4519508f74d4e4bab6f8c3da6388d49','2c31b44d86274d9c9323bcb7f0a754dd','shares',0,0,NULL,NULL),('2026-02-01 15:18:42.712538','2026-02-01 15:18:42.838210',NULL,0,228,'b4519508f74d4e4bab6f8c3da6388d49','7736a9c671f04e42b35558bfde737fc8','gigabytes',-1,0,NULL,NULL),('2026-02-01 15:18:42.715161','2026-02-01 15:18:42.838212',NULL,0,229,'b4519508f74d4e4bab6f8c3da6388d49','7736a9c671f04e42b35558bfde737fc8','shares',-1,0,NULL,NULL),('2026-02-01 15:18:44.063136','2026-02-01 15:18:44.087373','2026-02-01 15:18:54.974060',230,230,NULL,'2c31b44d86274d9c9323bcb7f0a754dd','gigabytes',0,0,NULL,'deaa419b-0383-4513-8c9a-24b9d74cd8e2'),('2026-02-01 15:18:44.068183','2026-02-01 15:18:44.087374','2026-02-01 15:18:54.974060',231,231,NULL,'2c31b44d86274d9c9323bcb7f0a754dd','shares',0,0,NULL,'deaa419b-0383-4513-8c9a-24b9d74cd8e2'),('2026-02-01 15:19:03.451185','2026-02-01 15:19:31.332705',NULL,0,232,'5a9e48d8005d427fa422911dd04f4938','754e5daaf01d4d8e91ba62e9ca89a38d','gigabytes',0,0,NULL,NULL),('2026-02-01 15:19:03.454117','2026-02-01 15:19:31.332708',NULL,0,233,'5a9e48d8005d427fa422911dd04f4938','754e5daaf01d4d8e91ba62e9ca89a38d','shares',0,0,NULL,NULL),('2026-02-01 15:19:03.465481','2026-02-01 15:19:31.332710','2026-02-01 15:19:34.438162',234,234,NULL,'754e5daaf01d4d8e91ba62e9ca89a38d','gigabytes',0,0,NULL,'4f1b79a2-3597-416f-9735-5bd373e5c8ee'),('2026-02-01 15:19:03.468203','2026-02-01 15:19:31.332711','2026-02-01 15:19:34.438162',235,235,NULL,'754e5daaf01d4d8e91ba62e9ca89a38d','shares',0,0,NULL,'4f1b79a2-3597-416f-9735-5bd373e5c8ee'),('2026-02-01 15:19:48.929112','2026-02-01 15:20:20.334305',NULL,0,236,'f69502b1cbbe4323a4b071a11a697d10','82efdf20300f4ffda9822c66d6f66684','gigabytes',0,0,NULL,NULL),('2026-02-01 15:19:48.931184','2026-02-01 15:20:20.334308',NULL,0,237,'f69502b1cbbe4323a4b071a11a697d10','82efdf20300f4ffda9822c66d6f66684','shares',0,0,NULL,NULL),('2026-02-01 15:19:48.942285','2026-02-01 15:20:20.334311','2026-02-01 15:20:24.490163',238,238,NULL,'82efdf20300f4ffda9822c66d6f66684','gigabytes',0,0,NULL,'e6371ab2-3a9c-4858-bc71-54efe991623a'),('2026-02-01 15:19:48.945796','2026-02-01 15:20:20.334312','2026-02-01 15:20:24.490163',239,239,NULL,'82efdf20300f4ffda9822c66d6f66684','shares',0,0,NULL,'e6371ab2-3a9c-4858-bc71-54efe991623a'),('2026-02-01 15:19:51.323964','2026-02-01 15:19:51.363178',NULL,0,240,'285a33e9d1bd42fb99f40147950702a7','7043f01f29d441a4801c5afbb65b54e3','gigabytes',1,0,NULL,NULL),('2026-02-01 15:19:51.325857','2026-02-01 15:19:51.363180',NULL,0,241,'285a33e9d1bd42fb99f40147950702a7','7043f01f29d441a4801c5afbb65b54e3','shares',1,0,NULL,NULL),('2026-02-01 15:19:56.372252','2026-02-01 15:20:44.989056',NULL,0,242,'bf5d1db5b7fe40f0ab31649c9864bbbb','624202b32e62465ca01f75142b16617c','gigabytes',0,0,NULL,NULL),('2026-02-01 15:19:56.373965','2026-02-01 15:20:44.989059',NULL,0,243,'bf5d1db5b7fe40f0ab31649c9864bbbb','624202b32e62465ca01f75142b16617c','shares',0,0,NULL,NULL),('2026-02-01 15:19:56.382653','2026-02-01 15:20:44.989060','2026-02-01 15:20:48.169240',244,244,NULL,'624202b32e62465ca01f75142b16617c','gigabytes',0,0,NULL,'b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:19:56.384708','2026-02-01 15:20:44.989061','2026-02-01 15:20:48.169240',245,245,NULL,'624202b32e62465ca01f75142b16617c','shares',0,0,NULL,'b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:19:59.834180','2026-02-01 15:20:44.453319',NULL,0,246,'bf5d1db5b7fe40f0ab31649c9864bbbb','624202b32e62465ca01f75142b16617c','snapshots',0,0,NULL,NULL),('2026-02-01 15:19:59.836600','2026-02-01 15:20:44.453321',NULL,0,247,'bf5d1db5b7fe40f0ab31649c9864bbbb','624202b32e62465ca01f75142b16617c','snapshot_gigabytes',0,0,NULL,NULL),('2026-02-01 15:19:59.846524','2026-02-01 15:20:44.453323','2026-02-01 15:20:48.169240',248,248,NULL,'624202b32e62465ca01f75142b16617c','snapshots',0,0,NULL,'b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:19:59.849081','2026-02-01 15:20:44.453324','2026-02-01 15:20:48.169240',249,249,NULL,'624202b32e62465ca01f75142b16617c','snapshot_gigabytes',0,0,NULL,'b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:20:01.057933','2026-02-01 15:20:08.674681',NULL,0,250,'f69502b1cbbe4323a4b071a11a697d10','82efdf20300f4ffda9822c66d6f66684','share_groups',0,0,NULL,NULL),('2026-02-01 15:20:39.701450','2026-02-01 15:20:43.662000',NULL,0,251,'6f958a41d78c4be0a08e982b45e1a5d2','df8c3ecdfab6413d85063f6a916bc871','share_networks',0,0,NULL,NULL),('2026-02-01 15:21:02.414925','2026-02-01 15:21:06.841552',NULL,0,252,'88ec7b16b6fa416384d2369bc7447737','52ac7fb21e3442af82e9ccd9a67048b3','share_networks',0,0,NULL,NULL),('2026-02-01 15:21:16.723470','2026-02-01 15:21:18.627000',NULL,0,253,'8c6a7c0dbc6a435d9d7adbff0811f887','5b354e96d8754cf0a01ccc8e15d99a2c','share_networks',0,0,NULL,NULL),('2026-02-01 15:21:39.441789','2026-02-01 15:21:51.760058',NULL,0,254,'ea0ad1ffc7314e269b800f42e5e3fc3e','ebfaf803a1c84c12ac2c950d798c01a3','gigabytes',0,0,NULL,NULL),('2026-02-01 15:21:39.443760','2026-02-01 15:21:51.760060',NULL,0,255,'ea0ad1ffc7314e269b800f42e5e3fc3e','ebfaf803a1c84c12ac2c950d798c01a3','shares',0,0,NULL,NULL),('2026-02-01 15:21:39.453968','2026-02-01 15:21:51.760062','2026-02-01 15:21:54.888136',256,256,NULL,'ebfaf803a1c84c12ac2c950d798c01a3','gigabytes',0,0,NULL,'232f280e-a80b-4dbd-be5c-473370cb110d'),('2026-02-01 15:21:39.455916','2026-02-01 15:21:51.760063','2026-02-01 15:21:54.888136',257,257,NULL,'ebfaf803a1c84c12ac2c950d798c01a3','shares',0,0,NULL,'232f280e-a80b-4dbd-be5c-473370cb110d'),('2026-02-01 15:21:42.902389','2026-02-01 15:21:48.368321',NULL,0,258,'ea0ad1ffc7314e269b800f42e5e3fc3e','ebfaf803a1c84c12ac2c950d798c01a3','snapshot_gigabytes',0,0,NULL,NULL),('2026-02-01 15:21:42.904732','2026-02-01 15:21:48.368324',NULL,0,259,'ea0ad1ffc7314e269b800f42e5e3fc3e','ebfaf803a1c84c12ac2c950d798c01a3','snapshots',0,0,NULL,NULL),('2026-02-01 15:21:42.918591','2026-02-01 15:21:48.368326','2026-02-01 15:21:54.888136',260,260,NULL,'ebfaf803a1c84c12ac2c950d798c01a3','snapshot_gigabytes',0,0,NULL,'232f280e-a80b-4dbd-be5c-473370cb110d'),('2026-02-01 15:21:42.921264','2026-02-01 15:21:48.368328','2026-02-01 15:21:54.888136',261,261,NULL,'ebfaf803a1c84c12ac2c950d798c01a3','snapshots',0,0,NULL,'232f280e-a80b-4dbd-be5c-473370cb110d'),('2026-02-01 15:22:04.921721','2026-02-01 15:22:17.308211',NULL,0,262,'bd6f5443e9144072bcf2104c071429b2','844f34f060ef46f0be5d950e48375eb5','gigabytes',0,0,NULL,NULL),('2026-02-01 15:22:04.925303','2026-02-01 15:22:17.308214',NULL,0,263,'bd6f5443e9144072bcf2104c071429b2','844f34f060ef46f0be5d950e48375eb5','shares',0,0,NULL,NULL),('2026-02-01 15:22:04.936581','2026-02-01 15:22:17.308215','2026-02-01 15:22:20.490934',264,264,NULL,'844f34f060ef46f0be5d950e48375eb5','gigabytes',0,0,NULL,'b601a256-782e-4c57-86e2-e39b6a70a570'),('2026-02-01 15:22:04.939022','2026-02-01 15:22:17.308216','2026-02-01 15:22:20.490934',265,265,NULL,'844f34f060ef46f0be5d950e48375eb5','shares',0,0,NULL,'b601a256-782e-4c57-86e2-e39b6a70a570'),('2026-02-01 15:22:08.423061','2026-02-01 15:22:13.851657',NULL,0,266,'bd6f5443e9144072bcf2104c071429b2','844f34f060ef46f0be5d950e48375eb5','snapshot_gigabytes',0,0,NULL,NULL),('2026-02-01 15:22:08.425371','2026-02-01 15:22:13.851662',NULL,0,267,'bd6f5443e9144072bcf2104c071429b2','844f34f060ef46f0be5d950e48375eb5','snapshots',0,0,NULL,NULL),('2026-02-01 15:22:08.438124','2026-02-01 15:22:13.851665','2026-02-01 15:22:20.490934',268,268,NULL,'844f34f060ef46f0be5d950e48375eb5','snapshot_gigabytes',0,0,NULL,'b601a256-782e-4c57-86e2-e39b6a70a570'),('2026-02-01 15:22:08.440479','2026-02-01 15:22:13.851667','2026-02-01 15:22:20.490934',269,269,NULL,'844f34f060ef46f0be5d950e48375eb5','snapshots',0,0,NULL,'b601a256-782e-4c57-86e2-e39b6a70a570');
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
INSERT INTO `quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `project_id`, `resource`, `hard_limit`) VALUES (1,'2026-02-01 15:13:36.968982',NULL,'2026-02-01 15:13:52.716514',1,'b2e389a954404c1185b10157107ee036','shares',3),(2,'2026-02-01 15:13:36.974357',NULL,'2026-02-01 15:13:52.716514',2,'b2e389a954404c1185b10157107ee036','gigabytes',10),(3,'2026-02-01 15:13:37.891997',NULL,'2026-02-01 15:13:38.112185',3,'fc17e54c678d41c68e219a1686c0fe7d','shares',1),(4,'2026-02-01 15:13:42.194761',NULL,'2026-02-01 15:13:45.946042',4,'fc17e54c678d41c68e219a1686c0fe7d','snapshots',1),(5,'2026-02-01 15:13:51.349357',NULL,'2026-02-01 15:13:51.579677',5,'fc17e54c678d41c68e219a1686c0fe7d','shares',10),(6,'2026-02-01 15:13:51.800821',NULL,'2026-02-01 15:13:52.062777',6,'fc17e54c678d41c68e219a1686c0fe7d','shares',10),(7,'2026-02-01 15:13:53.010154',NULL,'2026-02-01 15:13:53.893611',7,'b2e389a954404c1185b10157107ee036','shares',55),(8,'2026-02-01 15:13:53.070346',NULL,'2026-02-01 15:13:53.893611',8,'b2e389a954404c1185b10157107ee036','snapshots',55),(9,'2026-02-01 15:13:53.079430',NULL,'2026-02-01 15:13:53.893611',9,'b2e389a954404c1185b10157107ee036','gigabytes',1005),(10,'2026-02-01 15:13:53.173518',NULL,'2026-02-01 15:13:53.893611',10,'b2e389a954404c1185b10157107ee036','snapshot_gigabytes',1005),(11,'2026-02-01 15:13:53.217351',NULL,'2026-02-01 15:13:53.893611',11,'b2e389a954404c1185b10157107ee036','share_replicas',105),(12,'2026-02-01 15:13:53.226317',NULL,'2026-02-01 15:13:53.893611',12,'b2e389a954404c1185b10157107ee036','replica_gigabytes',1005),(13,'2026-02-01 15:13:54.200981',NULL,'2026-02-01 15:13:54.985188',13,'b2e389a954404c1185b10157107ee036','shares',55),(14,'2026-02-01 15:13:54.218731',NULL,'2026-02-01 15:13:54.985188',14,'b2e389a954404c1185b10157107ee036','snapshots',55),(15,'2026-02-01 15:13:54.257066',NULL,'2026-02-01 15:13:54.985188',15,'b2e389a954404c1185b10157107ee036','gigabytes',1005),(16,'2026-02-01 15:13:54.261364',NULL,'2026-02-01 15:13:54.985188',16,'b2e389a954404c1185b10157107ee036','snapshot_gigabytes',1005),(17,'2026-02-01 15:13:54.267953',NULL,'2026-02-01 15:13:54.985188',17,'b2e389a954404c1185b10157107ee036','share_replicas',105),(18,'2026-02-01 15:13:54.304123',NULL,'2026-02-01 15:13:54.985188',18,'b2e389a954404c1185b10157107ee036','replica_gigabytes',1005),(19,'2026-02-01 15:13:55.309051',NULL,'2026-02-01 15:13:55.555662',19,'b2e389a954404c1185b10157107ee036','shares',52),(20,'2026-02-01 15:13:55.382859',NULL,'2026-02-01 15:13:55.555662',20,'b2e389a954404c1185b10157107ee036','snapshots',52),(21,'2026-02-01 15:13:55.413358',NULL,'2026-02-01 15:13:55.555662',21,'b2e389a954404c1185b10157107ee036','gigabytes',1002),(22,'2026-02-01 15:13:55.464629',NULL,'2026-02-01 15:13:55.555662',22,'b2e389a954404c1185b10157107ee036','snapshot_gigabytes',1002),(23,'2026-02-01 15:13:55.474030',NULL,'2026-02-01 15:13:55.555662',23,'b2e389a954404c1185b10157107ee036','share_networks',12),(24,'2026-02-01 15:13:55.483341',NULL,'2026-02-01 15:13:55.555662',24,'b2e389a954404c1185b10157107ee036','share_replicas',102),(25,'2026-02-01 15:13:55.492845',NULL,'2026-02-01 15:13:55.555662',25,'b2e389a954404c1185b10157107ee036','replica_gigabytes',1002),(26,'2026-02-01 15:13:56.008692',NULL,'2026-02-01 15:13:56.441651',26,'b2e389a954404c1185b10157107ee036','shares',13),(27,'2026-02-01 15:13:56.638662',NULL,'2026-02-01 15:13:56.852815',27,'b2e389a954404c1185b10157107ee036','gigabytes',-1),(28,'2026-02-01 15:13:57.165011',NULL,'2026-02-01 15:13:57.344277',28,'b2e389a954404c1185b10157107ee036','share_replicas',-1),(29,'2026-02-01 15:13:57.483027',NULL,'2026-02-01 15:13:57.702626',29,'b2e389a954404c1185b10157107ee036','replica_gigabytes',-1),(30,'2026-02-01 15:13:57.834341',NULL,'2026-02-01 15:13:57.973272',30,'b2e389a954404c1185b10157107ee036','share_networks',-1),(31,'2026-02-01 15:13:58.183253',NULL,'2026-02-01 15:13:58.374171',31,'b2e389a954404c1185b10157107ee036','shares',-1),(32,'2026-02-01 15:13:58.489920',NULL,'2026-02-01 15:13:58.635919',32,'b2e389a954404c1185b10157107ee036','snapshot_gigabytes',-1),(33,'2026-02-01 15:13:58.758772',NULL,'2026-02-01 15:13:58.937282',33,'b2e389a954404c1185b10157107ee036','snapshots',-1),(34,'2026-02-01 15:14:03.914786',NULL,'2026-02-01 15:14:04.071562',34,'b2e389a954404c1185b10157107ee036','shares',10),(35,'2026-02-01 15:14:04.258608',NULL,'2026-02-01 15:14:04.474697',35,'b2e389a954404c1185b10157107ee036','shares',10),(36,'2026-02-01 15:14:04.641375',NULL,'2026-02-01 15:14:04.706424',36,'b2e389a954404c1185b10157107ee036','gigabytes',1002),(37,'2026-02-01 15:14:04.878239',NULL,'2026-02-01 15:14:04.952156',37,'b2e389a954404c1185b10157107ee036','share_networks',12),(38,'2026-02-01 15:14:05.078088',NULL,'2026-02-01 15:14:05.136335',38,'b2e389a954404c1185b10157107ee036','shares',52),(39,'2026-02-01 15:14:05.284789',NULL,'2026-02-01 15:14:05.346766',39,'b2e389a954404c1185b10157107ee036','snapshot_gigabytes',1002),(40,'2026-02-01 15:14:05.550344',NULL,'2026-02-01 15:14:05.685110',40,'b2e389a954404c1185b10157107ee036','snapshots',52),(41,'2026-02-01 15:14:06.097662',NULL,'2026-02-01 15:14:06.213515',41,'b2e389a954404c1185b10157107ee036','share_replicas',99),(42,'2026-02-01 15:14:06.823178',NULL,'2026-02-01 15:14:06.913705',42,'b2e389a954404c1185b10157107ee036','replica_gigabytes',999),(43,'2026-02-01 15:14:08.565319',NULL,'2026-02-01 15:14:08.981825',43,'b2e389a954404c1185b10157107ee036','shares',10),(44,'2026-02-01 15:14:09.066606',NULL,'2026-02-01 15:14:09.387579',44,'b2e389a954404c1185b10157107ee036','shares',10);
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `usage_id` (`usage_id`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=976 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `share_type_id`) VALUES ('2026-02-01 15:13:06.746727',NULL,'2026-02-01 15:13:06.860958',1,1,'435a807314d045b7b6183b8871d538b0','646699f5-6f21-4368-ac9c-ce1028e0d3ab',2,'fda4ab42f467487d8e5d3007a76e3476','shares',1,'2026-02-02 15:13:06',NULL),('2026-02-01 15:13:06.748831',NULL,'2026-02-01 15:13:06.860958',2,2,'435a807314d045b7b6183b8871d538b0','52ad9ec7-826e-4c60-9c90-157ff4846290',1,'fda4ab42f467487d8e5d3007a76e3476','gigabytes',1,'2026-02-02 15:13:06',NULL),('2026-02-01 15:13:06.757950',NULL,'2026-02-01 15:13:06.860958',3,3,NULL,'8bc2ae66-dbf4-443d-a67a-a99a5b713faa',4,'fda4ab42f467487d8e5d3007a76e3476','shares',1,'2026-02-02 15:13:06','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:06.758901',NULL,'2026-02-01 15:13:06.860958',4,4,NULL,'c783b706-3d75-4323-88fd-55a262c4a3de',3,'fda4ab42f467487d8e5d3007a76e3476','gigabytes',1,'2026-02-02 15:13:06','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:07.651126',NULL,'2026-02-01 15:13:07.705437',5,5,'e19059c3227c4ea5b508cf825c284a38','2e3ce40c-c8b8-499e-b023-ea99aa0c24c3',6,'7d7793c430934c04a024af92c3ca805f','shares',1,'2026-02-02 15:13:07',NULL),('2026-02-01 15:13:07.653065',NULL,'2026-02-01 15:13:07.705437',6,6,'e19059c3227c4ea5b508cf825c284a38','e42f372a-2850-4233-a07f-7cfb7a805d6d',5,'7d7793c430934c04a024af92c3ca805f','gigabytes',1,'2026-02-02 15:13:07',NULL),('2026-02-01 15:13:07.669295',NULL,'2026-02-01 15:13:07.705437',7,7,NULL,'0903ef5e-4354-4248-a77f-e87ac8f839be',8,'7d7793c430934c04a024af92c3ca805f','shares',1,'2026-02-02 15:13:07','7c625ff0-e084-42b2-8f17-359cee73602b'),('2026-02-01 15:13:07.670629',NULL,'2026-02-01 15:13:07.705437',8,8,NULL,'1f85b8b6-1a09-40b2-b444-53ba83acd1bb',7,'7d7793c430934c04a024af92c3ca805f','gigabytes',1,'2026-02-02 15:13:07','7c625ff0-e084-42b2-8f17-359cee73602b'),('2026-02-01 15:13:08.089361',NULL,'2026-02-01 15:13:08.125141',9,9,'cfc88dace67943ebb2cda941b51534e0','0d7fe5c5-2ac0-426e-9948-4fa8bad2032e',10,'cf2f906871624fa0887af8f21afda469','shares',1,'2026-02-02 15:13:08',NULL),('2026-02-01 15:13:08.090625',NULL,'2026-02-01 15:13:08.125141',10,10,'cfc88dace67943ebb2cda941b51534e0','898d7493-c493-48e4-a389-a0dab62dc9ab',9,'cf2f906871624fa0887af8f21afda469','gigabytes',1,'2026-02-02 15:13:08',NULL),('2026-02-01 15:13:08.103098',NULL,'2026-02-01 15:13:08.125141',11,11,NULL,'7eef13cb-ef21-4a68-a0e7-af78519fc8dd',12,'cf2f906871624fa0887af8f21afda469','shares',1,'2026-02-02 15:13:08','a36752ae-228c-4fa4-8961-f141e5222f47'),('2026-02-01 15:13:08.104929',NULL,'2026-02-01 15:13:08.125141',12,12,NULL,'26a61e3b-8216-4016-a950-094fc00108bb',11,'cf2f906871624fa0887af8f21afda469','gigabytes',1,'2026-02-02 15:13:08','a36752ae-228c-4fa4-8961-f141e5222f47'),('2026-02-01 15:13:10.681961',NULL,'2026-02-01 15:13:10.724337',13,13,'435a807314d045b7b6183b8871d538b0','d302ec7a-c16c-4bcf-b395-d8360621897d',2,'fda4ab42f467487d8e5d3007a76e3476','shares',1,'2026-02-02 15:13:10',NULL),('2026-02-01 15:13:10.684471',NULL,'2026-02-01 15:13:10.724337',14,14,'435a807314d045b7b6183b8871d538b0','a2639128-bf09-4b2f-885b-f035e0639239',1,'fda4ab42f467487d8e5d3007a76e3476','gigabytes',1,'2026-02-02 15:13:10',NULL),('2026-02-01 15:13:10.692065',NULL,'2026-02-01 15:13:10.724337',15,15,NULL,'0ef072e0-a4b2-4d60-9bbe-0ab444ec8640',4,'fda4ab42f467487d8e5d3007a76e3476','shares',1,'2026-02-02 15:13:10','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:10.693254',NULL,'2026-02-01 15:13:10.724337',16,16,NULL,'d3bf7f0f-0a90-4142-87df-fcc00bf748cc',3,'fda4ab42f467487d8e5d3007a76e3476','gigabytes',1,'2026-02-02 15:13:10','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:11.852260',NULL,'2026-02-01 15:13:11.978250',17,17,'cfc88dace67943ebb2cda941b51534e0','6fe07657-5a81-4be5-a22c-b03edbc6e3b9',14,'cf2f906871624fa0887af8f21afda469','snapshots',1,'2026-02-02 15:13:11',NULL),('2026-02-01 15:13:11.853747',NULL,'2026-02-01 15:13:11.978250',18,18,'cfc88dace67943ebb2cda941b51534e0','8ebfd62c-9955-4b49-a14f-7c47b5b397ee',13,'cf2f906871624fa0887af8f21afda469','snapshot_gigabytes',1,'2026-02-02 15:13:11',NULL),('2026-02-01 15:13:11.867726',NULL,'2026-02-01 15:13:11.978250',19,19,NULL,'43305cb7-13f8-49c1-90ec-4f420f750b35',16,'cf2f906871624fa0887af8f21afda469','snapshots',1,'2026-02-02 15:13:11','a36752ae-228c-4fa4-8961-f141e5222f47'),('2026-02-01 15:13:11.870074',NULL,'2026-02-01 15:13:11.978250',20,20,NULL,'24169207-c563-45c2-88cd-d40f6c561af0',15,'cf2f906871624fa0887af8f21afda469','snapshot_gigabytes',1,'2026-02-02 15:13:11','a36752ae-228c-4fa4-8961-f141e5222f47'),('2026-02-01 15:13:14.357094',NULL,'2026-02-01 15:13:15.155982',21,21,'435a807314d045b7b6183b8871d538b0','03da6333-f789-4e57-b956-dc79f5e802b0',1,'fda4ab42f467487d8e5d3007a76e3476','gigabytes',1,'2026-02-02 15:13:14',NULL),('2026-02-01 15:13:14.367312',NULL,'2026-02-01 15:13:15.155982',22,22,NULL,'b07cf417-db24-46ad-a182-d1caf3912787',3,'fda4ab42f467487d8e5d3007a76e3476','gigabytes',1,'2026-02-02 15:13:14','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:15.834575',NULL,'2026-02-01 15:13:15.847970',23,23,'e19059c3227c4ea5b508cf825c284a38','98a627e7-5738-4fc9-b92a-286c0950f117',6,'7d7793c430934c04a024af92c3ca805f','shares',-1,'2026-02-02 15:13:15',NULL),('2026-02-01 15:13:15.835645',NULL,'2026-02-01 15:13:15.847970',24,24,'e19059c3227c4ea5b508cf825c284a38','02fbe624-8ece-4682-98e7-0ad31fa6c114',5,'7d7793c430934c04a024af92c3ca805f','gigabytes',-1,'2026-02-02 15:13:15',NULL),('2026-02-01 15:13:15.840430',NULL,'2026-02-01 15:13:15.847970',25,25,NULL,'a12d9e05-1006-4b1b-9d36-25c39f25dc18',8,'7d7793c430934c04a024af92c3ca805f','shares',-1,'2026-02-02 15:13:15','7c625ff0-e084-42b2-8f17-359cee73602b'),('2026-02-01 15:13:15.841130',NULL,'2026-02-01 15:13:15.847970',26,26,NULL,'5562afbc-93c7-46d2-84f7-ee456d0856b5',7,'7d7793c430934c04a024af92c3ca805f','gigabytes',-1,'2026-02-02 15:13:15','7c625ff0-e084-42b2-8f17-359cee73602b'),('2026-02-01 15:13:16.233506',NULL,'2026-02-01 15:13:16.248089',27,27,'435a807314d045b7b6183b8871d538b0','004b796b-a3e5-4a46-9afa-a4e0afe4bdd4',2,'fda4ab42f467487d8e5d3007a76e3476','shares',-1,'2026-02-02 15:13:16',NULL),('2026-02-01 15:13:16.234291',NULL,'2026-02-01 15:13:16.248089',28,28,'435a807314d045b7b6183b8871d538b0','ce172bc0-367e-4632-bf11-ed39505094ff',1,'fda4ab42f467487d8e5d3007a76e3476','gigabytes',-2,'2026-02-02 15:13:16',NULL),('2026-02-01 15:13:16.240301',NULL,'2026-02-01 15:13:16.248089',29,29,NULL,'9d2a39a6-1a49-4f8a-8414-bdedd5b29b11',4,'fda4ab42f467487d8e5d3007a76e3476','shares',-1,'2026-02-02 15:13:16','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:16.241164',NULL,'2026-02-01 15:13:16.248089',30,30,NULL,'1cbc0238-51ae-457d-a981-339a1d5280a6',3,'fda4ab42f467487d8e5d3007a76e3476','gigabytes',-2,'2026-02-02 15:13:16','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:17.245489',NULL,'2026-02-01 15:13:17.265150',31,31,'cfc88dace67943ebb2cda941b51534e0','6b985202-cb59-47f7-b523-13f1732bad55',14,'cf2f906871624fa0887af8f21afda469','snapshots',-1,'2026-02-02 15:13:17',NULL),('2026-02-01 15:13:17.246259',NULL,'2026-02-01 15:13:17.265150',32,32,'cfc88dace67943ebb2cda941b51534e0','da887b58-84c6-482e-8341-58317c9491b5',13,'cf2f906871624fa0887af8f21afda469','snapshot_gigabytes',-1,'2026-02-02 15:13:17',NULL),('2026-02-01 15:13:17.253218',NULL,'2026-02-01 15:13:17.265150',33,33,NULL,'ae9b4fcd-037c-48d0-8076-b19d8448ffbd',16,'cf2f906871624fa0887af8f21afda469','snapshots',-1,'2026-02-02 15:13:17','a36752ae-228c-4fa4-8961-f141e5222f47'),('2026-02-01 15:13:17.254102',NULL,'2026-02-01 15:13:17.265150',34,34,NULL,'20aac3e5-3eb7-4a77-b1e3-bc447cb750f7',15,'cf2f906871624fa0887af8f21afda469','snapshot_gigabytes',-1,'2026-02-02 15:13:17','a36752ae-228c-4fa4-8961-f141e5222f47'),('2026-02-01 15:13:19.387934',NULL,'2026-02-01 15:13:19.423070',35,35,'435a807314d045b7b6183b8871d538b0','e376be3c-6f9c-45da-9105-0029978e58c0',2,'fda4ab42f467487d8e5d3007a76e3476','shares',1,'2026-02-02 15:13:19',NULL),('2026-02-01 15:13:19.389286',NULL,'2026-02-01 15:13:19.423070',36,36,'435a807314d045b7b6183b8871d538b0','644e3d9c-67d2-4ff3-805b-7da0136f6ab5',1,'fda4ab42f467487d8e5d3007a76e3476','gigabytes',1,'2026-02-02 15:13:19',NULL),('2026-02-01 15:13:19.396145',NULL,'2026-02-01 15:13:19.423070',37,37,NULL,'7c1f1903-bb27-4451-a7a5-defdb708da01',4,'fda4ab42f467487d8e5d3007a76e3476','shares',1,'2026-02-02 15:13:19','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:19.397497',NULL,'2026-02-01 15:13:19.423070',38,38,NULL,'ca172a24-8989-4028-b3a9-4bba62420960',3,'fda4ab42f467487d8e5d3007a76e3476','gigabytes',1,'2026-02-02 15:13:19','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:20.216255',NULL,'2026-02-01 15:13:20.286906',39,39,'dd3dddd74c80436eae71170aed36a00b','b41e6081-0772-422f-9639-3e108bd3810f',18,'e97ebfd6a3764df8b7badde8319f1a16','shares',1,'2026-02-02 15:13:20',NULL),('2026-02-01 15:13:20.221350',NULL,'2026-02-01 15:13:20.286906',40,40,'dd3dddd74c80436eae71170aed36a00b','c5ba5977-73ae-4ad3-9992-f81d78419453',17,'e97ebfd6a3764df8b7badde8319f1a16','gigabytes',1,'2026-02-02 15:13:20',NULL),('2026-02-01 15:13:20.232732',NULL,'2026-02-01 15:13:20.286906',41,41,NULL,'e91274ce-69d4-46c5-9191-7d9eea38c131',20,'e97ebfd6a3764df8b7badde8319f1a16','shares',1,'2026-02-02 15:13:20','3cd49bbe-54fc-43fb-9feb-ba0c28e6948f'),('2026-02-01 15:13:20.234125',NULL,'2026-02-01 15:13:20.286906',42,42,NULL,'a855aedf-1274-45fc-b895-01111aff1393',19,'e97ebfd6a3764df8b7badde8319f1a16','gigabytes',1,'2026-02-02 15:13:20','3cd49bbe-54fc-43fb-9feb-ba0c28e6948f'),('2026-02-01 15:13:20.839654',NULL,'2026-02-01 15:13:20.853516',43,43,'cfc88dace67943ebb2cda941b51534e0','046c389a-55b2-49a3-86d5-50679a772b43',10,'cf2f906871624fa0887af8f21afda469','shares',-1,'2026-02-02 15:13:20',NULL),('2026-02-01 15:13:20.840419',NULL,'2026-02-01 15:13:20.853516',44,44,'cfc88dace67943ebb2cda941b51534e0','cb80a392-503c-4cfd-9462-0c6009e2b2b5',9,'cf2f906871624fa0887af8f21afda469','gigabytes',-1,'2026-02-02 15:13:20',NULL),('2026-02-01 15:13:20.845281',NULL,'2026-02-01 15:13:20.853516',45,45,NULL,'a8eb5a33-645b-4670-bfc4-a51828f72127',12,'cf2f906871624fa0887af8f21afda469','shares',-1,'2026-02-02 15:13:20','a36752ae-228c-4fa4-8961-f141e5222f47'),('2026-02-01 15:13:20.845949',NULL,'2026-02-01 15:13:20.853516',46,46,NULL,'9b4e2e2e-b8b7-482e-8060-a83802627987',11,'cf2f906871624fa0887af8f21afda469','gigabytes',-1,'2026-02-02 15:13:20','a36752ae-228c-4fa4-8961-f141e5222f47'),('2026-02-01 15:13:23.170909',NULL,'2026-02-01 15:13:23.478151',47,47,'435a807314d045b7b6183b8871d538b0','52f56dd6-2d6a-4cdb-b83d-64cdea4d720b',1,'fda4ab42f467487d8e5d3007a76e3476','gigabytes',1,'2026-02-02 15:13:23',NULL),('2026-02-01 15:13:23.284957',NULL,'2026-02-01 15:13:23.478151',48,48,NULL,'097d6242-6247-40ee-b0c6-4bc9ff0ebcd7',3,'fda4ab42f467487d8e5d3007a76e3476','gigabytes',1,'2026-02-02 15:13:23','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:24.831283',NULL,'2026-02-01 15:13:24.851391',49,49,'435a807314d045b7b6183b8871d538b0','90a1fc97-0730-4edb-9760-8d77c6a898e7',2,'fda4ab42f467487d8e5d3007a76e3476','shares',-1,'2026-02-02 15:13:24',NULL),('2026-02-01 15:13:24.832107',NULL,'2026-02-01 15:13:24.851391',50,50,'435a807314d045b7b6183b8871d538b0','f18b3db7-19c2-43dd-8fbc-f5b65bc43f31',1,'fda4ab42f467487d8e5d3007a76e3476','gigabytes',-2,'2026-02-02 15:13:24',NULL),('2026-02-01 15:13:24.841838',NULL,'2026-02-01 15:13:24.851391',51,51,NULL,'3e2a4d1d-ed30-410e-944c-5901f02fda48',4,'fda4ab42f467487d8e5d3007a76e3476','shares',-1,'2026-02-02 15:13:24','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:24.842611',NULL,'2026-02-01 15:13:24.851391',52,52,NULL,'50c97f67-bdfe-46f3-b715-596e778be590',3,'fda4ab42f467487d8e5d3007a76e3476','gigabytes',-2,'2026-02-02 15:13:24','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:26.456979',NULL,'2026-02-01 15:13:26.482158',53,53,'dd3dddd74c80436eae71170aed36a00b','790f0742-ba61-45c7-85f9-f28437be6bf6',18,'e97ebfd6a3764df8b7badde8319f1a16','shares',-1,'2026-02-02 15:13:26',NULL),('2026-02-01 15:13:26.457783',NULL,'2026-02-01 15:13:26.482158',54,54,'dd3dddd74c80436eae71170aed36a00b','ff5abcbb-63fe-4515-a3f3-67fa6d62016a',17,'e97ebfd6a3764df8b7badde8319f1a16','gigabytes',-1,'2026-02-02 15:13:26',NULL),('2026-02-01 15:13:26.464691',NULL,'2026-02-01 15:13:26.482158',55,55,NULL,'56e32696-bc63-4d4c-8cb7-4af60d783d96',20,'e97ebfd6a3764df8b7badde8319f1a16','shares',-1,'2026-02-02 15:13:26','3cd49bbe-54fc-43fb-9feb-ba0c28e6948f'),('2026-02-01 15:13:26.466170',NULL,'2026-02-01 15:13:26.482158',56,56,NULL,'4f504d99-ba77-4563-a569-5f9780c5ef60',19,'e97ebfd6a3764df8b7badde8319f1a16','gigabytes',-1,'2026-02-02 15:13:26','3cd49bbe-54fc-43fb-9feb-ba0c28e6948f'),('2026-02-01 15:13:28.165889',NULL,'2026-02-01 15:13:28.192076',57,57,'435a807314d045b7b6183b8871d538b0','d41c160d-1755-4200-ab73-dcbf6b53332d',2,'fda4ab42f467487d8e5d3007a76e3476','shares',1,'2026-02-02 15:13:28',NULL),('2026-02-01 15:13:28.167225',NULL,'2026-02-01 15:13:28.192076',58,58,'435a807314d045b7b6183b8871d538b0','c82d328f-9da8-4db8-94d5-daba80b6b075',1,'fda4ab42f467487d8e5d3007a76e3476','gigabytes',1,'2026-02-02 15:13:28',NULL),('2026-02-01 15:13:28.173225',NULL,'2026-02-01 15:13:28.192076',59,59,NULL,'3a1b1c9f-da02-4f42-b173-c0bff74b3890',4,'fda4ab42f467487d8e5d3007a76e3476','shares',1,'2026-02-02 15:13:28','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:28.174269',NULL,'2026-02-01 15:13:28.192076',60,60,NULL,'57325405-79f0-4824-935e-451155a7c62a',3,'fda4ab42f467487d8e5d3007a76e3476','gigabytes',1,'2026-02-02 15:13:28','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:32.210555',NULL,'2026-02-01 15:13:32.234755',61,61,'435a807314d045b7b6183b8871d538b0','b556b7f4-00de-4e91-a503-6e10d4a44548',2,'fda4ab42f467487d8e5d3007a76e3476','shares',-1,'2026-02-02 15:13:32',NULL),('2026-02-01 15:13:32.212288',NULL,'2026-02-01 15:13:32.234755',62,62,'435a807314d045b7b6183b8871d538b0','25e76130-4570-465d-a337-2a441650a362',1,'fda4ab42f467487d8e5d3007a76e3476','gigabytes',-1,'2026-02-02 15:13:32',NULL),('2026-02-01 15:13:32.226217',NULL,'2026-02-01 15:13:32.234755',63,63,NULL,'300d9195-4d9c-4fcb-a6d1-40f447093796',4,'fda4ab42f467487d8e5d3007a76e3476','shares',-1,'2026-02-02 15:13:32','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:32.227584',NULL,'2026-02-01 15:13:32.234755',64,64,NULL,'a93d2a4e-99dd-4a00-9ad1-93ebe8d4eef0',3,'fda4ab42f467487d8e5d3007a76e3476','gigabytes',-1,'2026-02-02 15:13:32','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:34.417918',NULL,'2026-02-01 15:13:34.450446',65,65,'2bbd6a9be41643a38007238edf9638fe','e5eb9566-25fb-4ddd-991b-348ef961e721',22,'fc17e54c678d41c68e219a1686c0fe7d','shares',1,'2026-02-02 15:13:34',NULL),('2026-02-01 15:13:34.419271',NULL,'2026-02-01 15:13:34.450446',66,66,'2bbd6a9be41643a38007238edf9638fe','b88e04c9-57d8-42e0-9b2d-ce9eabb85cca',21,'fc17e54c678d41c68e219a1686c0fe7d','gigabytes',1,'2026-02-02 15:13:34',NULL),('2026-02-01 15:13:34.428368',NULL,'2026-02-01 15:13:34.450446',67,67,NULL,'a818436c-72cc-412e-86e1-630a9700f3af',24,'fc17e54c678d41c68e219a1686c0fe7d','shares',1,'2026-02-02 15:13:34','b1712ae3-d38a-4543-bf30-4854aff75f83'),('2026-02-01 15:13:34.429447',NULL,'2026-02-01 15:13:34.450446',68,68,NULL,'25c3093c-2ecb-4d59-b5a2-043198ce3a2d',23,'fc17e54c678d41c68e219a1686c0fe7d','gigabytes',1,'2026-02-02 15:13:34','b1712ae3-d38a-4543-bf30-4854aff75f83'),('2026-02-01 15:13:35.456727',NULL,'2026-02-01 15:13:35.487923',69,69,'435a807314d045b7b6183b8871d538b0','1ae68dde-26ef-4f39-bbe1-73b41a3becf4',2,'fda4ab42f467487d8e5d3007a76e3476','shares',1,'2026-02-02 15:13:35',NULL),('2026-02-01 15:13:35.458011',NULL,'2026-02-01 15:13:35.487923',70,70,'435a807314d045b7b6183b8871d538b0','6af9fdf8-9d63-4d93-87e9-1c82876d0111',1,'fda4ab42f467487d8e5d3007a76e3476','gigabytes',1,'2026-02-02 15:13:35',NULL),('2026-02-01 15:13:35.465419',NULL,'2026-02-01 15:13:35.487923',71,71,NULL,'3e2ec87f-3e80-44f5-9c78-b6af004b1856',4,'fda4ab42f467487d8e5d3007a76e3476','shares',1,'2026-02-02 15:13:35','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:35.466608',NULL,'2026-02-01 15:13:35.487923',72,72,NULL,'2dbec85c-e407-460a-ba57-6b28947e9a97',3,'fda4ab42f467487d8e5d3007a76e3476','gigabytes',1,'2026-02-02 15:13:35','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:37.516042',NULL,'2026-02-01 15:13:37.554146',73,73,'fbd576f00c6b445aadb79ba9a35844e4','0ea9e03a-145f-4e31-bf62-7c733273c8b7',26,'b2e389a954404c1185b10157107ee036','shares',1,'2026-02-02 15:13:37',NULL),('2026-02-01 15:13:37.517184',NULL,'2026-02-01 15:13:37.554146',74,74,'fbd576f00c6b445aadb79ba9a35844e4','571036e9-875d-4637-8a43-123519cf1cb6',25,'b2e389a954404c1185b10157107ee036','gigabytes',4,'2026-02-02 15:13:37',NULL),('2026-02-01 15:13:37.525981',NULL,'2026-02-01 15:13:37.554146',75,75,NULL,'6cbb405a-1ced-44ed-a6eb-4cc5fdccd360',28,'b2e389a954404c1185b10157107ee036','shares',1,'2026-02-02 15:13:37','7f348200-99b9-44a8-a2c6-6a72a85cdd23'),('2026-02-01 15:13:37.527041',NULL,'2026-02-01 15:13:37.554146',76,76,NULL,'ffa3d697-23aa-4f8a-a664-3eaba70685e8',27,'b2e389a954404c1185b10157107ee036','gigabytes',4,'2026-02-02 15:13:37','7f348200-99b9-44a8-a2c6-6a72a85cdd23'),('2026-02-01 15:13:38.583142',NULL,'2026-02-01 15:13:38.617633',77,77,'2bbd6a9be41643a38007238edf9638fe','f5a9506a-3a89-4ee2-83fe-e2e65c05c6c7',30,'fc17e54c678d41c68e219a1686c0fe7d','shares',1,'2026-02-02 15:13:38',NULL),('2026-02-01 15:13:38.584483',NULL,'2026-02-01 15:13:38.617633',78,78,'2bbd6a9be41643a38007238edf9638fe','3f15f22d-9b96-4e13-a4da-10dea9d63187',29,'fc17e54c678d41c68e219a1686c0fe7d','gigabytes',1,'2026-02-02 15:13:38',NULL),('2026-02-01 15:13:38.593449',NULL,'2026-02-01 15:13:38.617633',79,79,NULL,'361c6145-5fc1-4163-bb90-3fce76f2cc81',32,'fc17e54c678d41c68e219a1686c0fe7d','shares',1,'2026-02-02 15:13:38','3dda19bc-6043-431c-bdc6-b4dc346cfacf'),('2026-02-01 15:13:38.594519',NULL,'2026-02-01 15:13:38.617633',80,80,NULL,'27f51062-4d63-464a-9cf1-09ee3c02fecb',31,'fc17e54c678d41c68e219a1686c0fe7d','gigabytes',1,'2026-02-02 15:13:38','3dda19bc-6043-431c-bdc6-b4dc346cfacf'),('2026-02-01 15:13:39.381750',NULL,'2026-02-01 15:13:39.398592',81,81,'435a807314d045b7b6183b8871d538b0','08992dad-d019-4498-be91-458a6216094a',2,'fda4ab42f467487d8e5d3007a76e3476','shares',-1,'2026-02-02 15:13:39',NULL),('2026-02-01 15:13:39.382400',NULL,'2026-02-01 15:13:39.398592',82,82,'435a807314d045b7b6183b8871d538b0','b5022ba7-706a-474f-b5f1-8c788c6e9ed4',1,'fda4ab42f467487d8e5d3007a76e3476','gigabytes',-1,'2026-02-02 15:13:39',NULL),('2026-02-01 15:13:39.388703',NULL,'2026-02-01 15:13:39.398592',83,83,NULL,'a6212b66-0072-402d-80b7-108c89893aba',4,'fda4ab42f467487d8e5d3007a76e3476','shares',-1,'2026-02-02 15:13:39','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:39.389512',NULL,'2026-02-01 15:13:39.398592',84,84,NULL,'711c22f7-48e9-46a6-ac83-9e34bdc76ca4',3,'fda4ab42f467487d8e5d3007a76e3476','gigabytes',-1,'2026-02-02 15:13:39','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:41.143571',NULL,'2026-02-01 15:13:41.158545',85,85,'fbd576f00c6b445aadb79ba9a35844e4','20ad158d-b555-4fd5-9269-8fe5fa875a4b',26,'b2e389a954404c1185b10157107ee036','shares',1,'2026-02-02 15:13:41',NULL),('2026-02-01 15:13:41.145496',NULL,'2026-02-01 15:13:41.158545',86,86,'fbd576f00c6b445aadb79ba9a35844e4','f8943bf8-57fb-4a88-8bf1-669cde831d5b',25,'b2e389a954404c1185b10157107ee036','gigabytes',3,'2026-02-02 15:13:41',NULL),('2026-02-01 15:13:41.441857',NULL,'2026-02-01 15:13:41.515381',87,87,'fbd576f00c6b445aadb79ba9a35844e4','aca03865-6955-4a76-b1e9-aad2f2759cca',26,'b2e389a954404c1185b10157107ee036','shares',1,'2026-02-02 15:13:41',NULL),('2026-02-01 15:13:41.443334',NULL,'2026-02-01 15:13:41.515381',88,88,'fbd576f00c6b445aadb79ba9a35844e4','2d119f7a-1166-4f17-b905-95b4d7bafa65',25,'b2e389a954404c1185b10157107ee036','gigabytes',3,'2026-02-02 15:13:41',NULL),('2026-02-01 15:13:41.454081',NULL,'2026-02-01 15:13:41.515381',89,89,NULL,'f9da3766-1622-41d1-b22a-8a3f54da58e4',34,'b2e389a954404c1185b10157107ee036','shares',1,'2026-02-02 15:13:41','e90f5e35-a2e5-4b1f-b6c6-9946da8a57e6'),('2026-02-01 15:13:41.456578',NULL,'2026-02-01 15:13:41.515381',90,90,NULL,'b358556e-4e48-4109-887b-e625f7a85776',33,'b2e389a954404c1185b10157107ee036','gigabytes',3,'2026-02-02 15:13:41','e90f5e35-a2e5-4b1f-b6c6-9946da8a57e6'),('2026-02-01 15:13:42.329140',NULL,'2026-02-01 15:13:42.417980',91,91,'2bbd6a9be41643a38007238edf9638fe','60c7c563-f88c-42c0-892a-7ef543ed68a3',36,'fc17e54c678d41c68e219a1686c0fe7d','snapshots',1,'2026-02-02 15:13:42',NULL),('2026-02-01 15:13:42.331937',NULL,'2026-02-01 15:13:42.417980',92,92,'2bbd6a9be41643a38007238edf9638fe','4f3cd97d-b216-4dd5-8c8d-b23667d8dd09',35,'fc17e54c678d41c68e219a1686c0fe7d','snapshot_gigabytes',1,'2026-02-02 15:13:42',NULL),('2026-02-01 15:13:42.346633',NULL,'2026-02-01 15:13:42.417980',93,93,NULL,'02fc209d-338e-444a-814e-31cd0ff813e6',38,'fc17e54c678d41c68e219a1686c0fe7d','snapshots',1,'2026-02-02 15:13:42','3dda19bc-6043-431c-bdc6-b4dc346cfacf'),('2026-02-01 15:13:42.348169',NULL,'2026-02-01 15:13:42.417980',94,94,NULL,'8921dee4-770e-49d8-b278-b8cd47da62b8',37,'fc17e54c678d41c68e219a1686c0fe7d','snapshot_gigabytes',1,'2026-02-02 15:13:42','3dda19bc-6043-431c-bdc6-b4dc346cfacf'),('2026-02-01 15:13:42.800832',NULL,'2026-02-01 15:13:42.895245',95,95,'435a807314d045b7b6183b8871d538b0','e3564736-c217-4ce4-b8bc-b12d0d0af29d',39,'fda4ab42f467487d8e5d3007a76e3476','snapshots',1,'2026-02-02 15:13:42',NULL),('2026-02-01 15:13:42.802591',NULL,'2026-02-01 15:13:42.895245',96,96,'435a807314d045b7b6183b8871d538b0','79b84ac3-3141-4fd6-8ff9-9b0a1465f974',40,'fda4ab42f467487d8e5d3007a76e3476','snapshot_gigabytes',1,'2026-02-02 15:13:42',NULL),('2026-02-01 15:13:42.819952',NULL,'2026-02-01 15:13:42.895245',97,97,NULL,'d91f0041-1703-4317-b332-b85459b39bdf',41,'fda4ab42f467487d8e5d3007a76e3476','snapshots',1,'2026-02-02 15:13:42','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:42.821404',NULL,'2026-02-01 15:13:42.895245',98,98,NULL,'3ebc8def-6e1d-435d-a36b-af02d5b610bb',42,'fda4ab42f467487d8e5d3007a76e3476','snapshot_gigabytes',1,'2026-02-02 15:13:42','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:43.715521',NULL,'2026-02-01 15:13:43.728286',99,99,'435a807314d045b7b6183b8871d538b0','39af8bf0-7a59-4e18-a9de-0ea150f08f65',39,'fda4ab42f467487d8e5d3007a76e3476','snapshots',-1,'2026-02-02 15:13:43',NULL),('2026-02-01 15:13:43.716245',NULL,'2026-02-01 15:13:43.728286',100,100,'435a807314d045b7b6183b8871d538b0','f68e67ed-0c97-4786-80bd-7be0cce2e29d',40,'fda4ab42f467487d8e5d3007a76e3476','snapshot_gigabytes',-1,'2026-02-02 15:13:43',NULL),('2026-02-01 15:13:43.721143',NULL,'2026-02-01 15:13:43.728286',101,101,NULL,'44750d17-3b9d-47ec-8d91-0b3fd8a635f5',41,'fda4ab42f467487d8e5d3007a76e3476','snapshots',-1,'2026-02-02 15:13:43','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:43.721851',NULL,'2026-02-01 15:13:43.728286',102,102,NULL,'675aa870-5142-47bf-aa99-0c2bdad3da09',42,'fda4ab42f467487d8e5d3007a76e3476','snapshot_gigabytes',-1,'2026-02-02 15:13:43','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:45.095141',NULL,'2026-02-01 15:13:45.132945',103,103,'6c7a6c983b3a451a96f18889cebd862d','31f117d9-582b-47ab-8dbc-816cbda89440',44,'c24c8bba1312447c8305abcf7b1ff259','shares',1,'2026-02-02 15:13:45',NULL),('2026-02-01 15:13:45.096222',NULL,'2026-02-01 15:13:45.132945',104,104,'6c7a6c983b3a451a96f18889cebd862d','74bb40c2-48a6-4e26-9b75-ca7b00c62e2f',43,'c24c8bba1312447c8305abcf7b1ff259','gigabytes',1,'2026-02-02 15:13:45',NULL),('2026-02-01 15:13:45.106070',NULL,'2026-02-01 15:13:45.132945',105,105,NULL,'7a65a3e8-758d-4889-9f16-990d06a322ae',46,'c24c8bba1312447c8305abcf7b1ff259','shares',1,'2026-02-02 15:13:45','b107dc0b-a3d2-4667-a455-9555f6c00178'),('2026-02-01 15:13:45.107298',NULL,'2026-02-01 15:13:45.132945',106,106,NULL,'21ec15ab-9b55-451f-9087-4d3590cb04eb',45,'c24c8bba1312447c8305abcf7b1ff259','gigabytes',1,'2026-02-02 15:13:45','b107dc0b-a3d2-4667-a455-9555f6c00178'),('2026-02-01 15:13:45.631992',NULL,'2026-02-01 15:13:45.649643',107,107,'fbd576f00c6b445aadb79ba9a35844e4','917ee779-fe4e-485b-bb05-3cd0ab53eda5',26,'b2e389a954404c1185b10157107ee036','shares',-1,'2026-02-02 15:13:45',NULL),('2026-02-01 15:13:45.633088',NULL,'2026-02-01 15:13:45.649643',108,108,'fbd576f00c6b445aadb79ba9a35844e4','e728f7d9-2326-4c3a-a6c8-bebea970938b',25,'b2e389a954404c1185b10157107ee036','gigabytes',-4,'2026-02-02 15:13:45',NULL),('2026-02-01 15:13:45.639772',NULL,'2026-02-01 15:13:45.649643',109,109,NULL,'89c61d5c-b1f4-40ee-83a4-41e8c4e5a5e0',28,'b2e389a954404c1185b10157107ee036','shares',-1,'2026-02-02 15:13:45','7f348200-99b9-44a8-a2c6-6a72a85cdd23'),('2026-02-01 15:13:45.640752',NULL,'2026-02-01 15:13:45.649643',110,110,NULL,'df3a584d-8a13-44f4-a216-96d34ca2dc1d',27,'b2e389a954404c1185b10157107ee036','gigabytes',-4,'2026-02-02 15:13:45','7f348200-99b9-44a8-a2c6-6a72a85cdd23'),('2026-02-01 15:13:48.925450',NULL,'2026-02-01 15:13:48.941187',111,111,'fbd576f00c6b445aadb79ba9a35844e4','46675614-6581-4555-af1d-06ec192cd310',26,'b2e389a954404c1185b10157107ee036','shares',-1,'2026-02-02 15:13:48',NULL),('2026-02-01 15:13:48.926322',NULL,'2026-02-01 15:13:48.941187',112,112,'fbd576f00c6b445aadb79ba9a35844e4','d59ef03b-9689-4778-a1c5-3fbe23e86940',25,'b2e389a954404c1185b10157107ee036','gigabytes',-3,'2026-02-02 15:13:48',NULL),('2026-02-01 15:13:48.933576',NULL,'2026-02-01 15:13:48.941187',113,113,NULL,'84ae6ae2-2895-414a-9392-06bf9dd8795c',34,'b2e389a954404c1185b10157107ee036','shares',-1,'2026-02-02 15:13:48','e90f5e35-a2e5-4b1f-b6c6-9946da8a57e6'),('2026-02-01 15:13:48.934336',NULL,'2026-02-01 15:13:48.941187',114,114,NULL,'1ef71c97-3aa9-47de-a8a3-df97852839e5',33,'b2e389a954404c1185b10157107ee036','gigabytes',-3,'2026-02-02 15:13:48','e90f5e35-a2e5-4b1f-b6c6-9946da8a57e6'),('2026-02-01 15:13:50.349333',NULL,'2026-02-01 15:13:50.363674',115,115,'6c7a6c983b3a451a96f18889cebd862d','5189357d-8ecd-449f-922c-50c02ccc9ad4',44,'c24c8bba1312447c8305abcf7b1ff259','shares',-1,'2026-02-02 15:13:50',NULL),('2026-02-01 15:13:50.350170',NULL,'2026-02-01 15:13:50.363674',116,116,'6c7a6c983b3a451a96f18889cebd862d','3273b0db-1b72-4ac9-96a4-c659b54db655',43,'c24c8bba1312447c8305abcf7b1ff259','gigabytes',-1,'2026-02-02 15:13:50',NULL),('2026-02-01 15:13:50.355630',NULL,'2026-02-01 15:13:50.363674',117,117,NULL,'6a46f036-55ae-460b-94a0-3f541e2de02b',46,'c24c8bba1312447c8305abcf7b1ff259','shares',-1,'2026-02-02 15:13:50','b107dc0b-a3d2-4667-a455-9555f6c00178'),('2026-02-01 15:13:50.356345',NULL,'2026-02-01 15:13:50.363674',118,118,NULL,'6b97bec5-ce2f-4e7c-a580-e68fc81e1fae',45,'c24c8bba1312447c8305abcf7b1ff259','gigabytes',-1,'2026-02-02 15:13:50','b107dc0b-a3d2-4667-a455-9555f6c00178'),('2026-02-01 15:13:51.444925',NULL,'2026-02-01 15:13:51.496471',119,119,'435a807314d045b7b6183b8871d538b0','8939f7f9-228d-4bdf-a92a-41f9438d82a5',39,'fda4ab42f467487d8e5d3007a76e3476','snapshots',1,'2026-02-02 15:13:51',NULL),('2026-02-01 15:13:51.445993',NULL,'2026-02-01 15:13:51.496471',120,120,'435a807314d045b7b6183b8871d538b0','0b58dc3d-bd9e-4524-8698-cd7366954447',40,'fda4ab42f467487d8e5d3007a76e3476','snapshot_gigabytes',1,'2026-02-02 15:13:51',NULL),('2026-02-01 15:13:51.450799',NULL,'2026-02-01 15:13:51.496471',121,121,NULL,'581a6bfe-1518-48d3-9396-b754a85c79a6',41,'fda4ab42f467487d8e5d3007a76e3476','snapshots',1,'2026-02-02 15:13:51','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:51.451735',NULL,'2026-02-01 15:13:51.496471',122,122,NULL,'048cf2ae-ea81-4de1-b766-da95cbc3b412',42,'fda4ab42f467487d8e5d3007a76e3476','snapshot_gigabytes',1,'2026-02-02 15:13:51','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:54.807710',NULL,'2026-02-01 15:13:54.885286',123,123,'2bbd6a9be41643a38007238edf9638fe','7e45581b-aaea-4528-9edf-508a0da4c524',48,'fc17e54c678d41c68e219a1686c0fe7d','snapshots',-1,'2026-02-02 15:13:54',NULL),('2026-02-01 15:13:54.808426',NULL,'2026-02-01 15:13:54.885286',124,124,'2bbd6a9be41643a38007238edf9638fe','a1811c3b-a056-4e4b-8990-9a369585bd6c',47,'fc17e54c678d41c68e219a1686c0fe7d','snapshot_gigabytes',-1,'2026-02-02 15:13:54',NULL),('2026-02-01 15:13:54.856138',NULL,'2026-02-01 15:13:54.885286',125,125,NULL,'b5ce45ac-e98e-4b8f-81fb-dfafc874864f',50,'fc17e54c678d41c68e219a1686c0fe7d','snapshots',-1,'2026-02-02 15:13:54','3dda19bc-6043-431c-bdc6-b4dc346cfacf'),('2026-02-01 15:13:54.856832',NULL,'2026-02-01 15:13:54.885286',126,126,NULL,'39f1fa0c-b4af-47f7-8800-59e8abff0e2c',49,'fc17e54c678d41c68e219a1686c0fe7d','snapshot_gigabytes',-1,'2026-02-02 15:13:54','3dda19bc-6043-431c-bdc6-b4dc346cfacf'),('2026-02-01 15:13:55.558399',NULL,'2026-02-01 15:13:55.624817',127,127,'435a807314d045b7b6183b8871d538b0','3494916f-e144-4394-b2ba-704f0c4dfce6',39,'fda4ab42f467487d8e5d3007a76e3476','snapshots',1,'2026-02-02 15:13:55',NULL),('2026-02-01 15:13:55.559565',NULL,'2026-02-01 15:13:55.624817',128,128,'435a807314d045b7b6183b8871d538b0','24fdb8e6-13b4-4874-a1ca-88dc4d7efc73',40,'fda4ab42f467487d8e5d3007a76e3476','snapshot_gigabytes',1,'2026-02-02 15:13:55',NULL),('2026-02-01 15:13:55.565955',NULL,'2026-02-01 15:13:55.624817',129,129,NULL,'2f290299-013f-4ce8-a68c-e08db3f39740',41,'fda4ab42f467487d8e5d3007a76e3476','snapshots',1,'2026-02-02 15:13:55','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:55.567081',NULL,'2026-02-01 15:13:55.624817',130,130,NULL,'70f672d7-f270-4887-97d5-a9d5e59283bd',42,'fda4ab42f467487d8e5d3007a76e3476','snapshot_gigabytes',1,'2026-02-02 15:13:55','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:56.747014',NULL,'2026-02-01 15:13:56.823075',131,131,'435a807314d045b7b6183b8871d538b0','4ed0b060-27c7-4789-af4a-36846eabe359',39,'fda4ab42f467487d8e5d3007a76e3476','snapshots',1,'2026-02-02 15:13:56',NULL),('2026-02-01 15:13:56.748465',NULL,'2026-02-01 15:13:56.823075',132,132,'435a807314d045b7b6183b8871d538b0','d1fac4fe-cb5c-4c6a-81ea-6ab7555581ae',40,'fda4ab42f467487d8e5d3007a76e3476','snapshot_gigabytes',1,'2026-02-02 15:13:56',NULL),('2026-02-01 15:13:56.754265',NULL,'2026-02-01 15:13:56.823075',133,133,NULL,'6979fe6d-53c1-4e07-a9d8-9fe2047d6d70',41,'fda4ab42f467487d8e5d3007a76e3476','snapshots',1,'2026-02-02 15:13:56','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:56.755413',NULL,'2026-02-01 15:13:56.823075',134,134,NULL,'47bdba98-6ae8-423b-873c-967c0caf1ff7',42,'fda4ab42f467487d8e5d3007a76e3476','snapshot_gigabytes',1,'2026-02-02 15:13:56','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:13:58.240515',NULL,'2026-02-01 15:13:58.268270',135,135,'2bbd6a9be41643a38007238edf9638fe','d12c765a-d31e-4c29-bece-4849385eeecc',52,'fc17e54c678d41c68e219a1686c0fe7d','shares',-1,'2026-02-02 15:13:58',NULL),('2026-02-01 15:13:58.241370',NULL,'2026-02-01 15:13:58.268270',136,136,'2bbd6a9be41643a38007238edf9638fe','cd4f3b6d-9281-423e-bf9c-6cc2f020116a',51,'fc17e54c678d41c68e219a1686c0fe7d','gigabytes',-1,'2026-02-02 15:13:58',NULL),('2026-02-01 15:13:58.261566',NULL,'2026-02-01 15:13:58.268270',137,137,NULL,'6f23e88c-fe35-4354-8e93-6b578d94d461',54,'fc17e54c678d41c68e219a1686c0fe7d','shares',-1,'2026-02-02 15:13:58','3dda19bc-6043-431c-bdc6-b4dc346cfacf'),('2026-02-01 15:13:58.262226',NULL,'2026-02-01 15:13:58.268270',138,138,NULL,'119d9a23-983f-4857-8fe1-5ce1ccc623e6',53,'fc17e54c678d41c68e219a1686c0fe7d','gigabytes',-1,'2026-02-02 15:13:58','3dda19bc-6043-431c-bdc6-b4dc346cfacf'),('2026-02-01 15:14:01.015370',NULL,'2026-02-01 15:14:01.084288',139,139,'435a807314d045b7b6183b8871d538b0','2c84a691-fb28-4fc6-9b3f-65edd9132596',39,'fda4ab42f467487d8e5d3007a76e3476','snapshots',1,'2026-02-02 15:14:00',NULL),('2026-02-01 15:14:01.017646',NULL,'2026-02-01 15:14:01.084288',140,140,'435a807314d045b7b6183b8871d538b0','cb9646d7-f459-484e-b2bc-a50382ddd194',40,'fda4ab42f467487d8e5d3007a76e3476','snapshot_gigabytes',1,'2026-02-02 15:14:00',NULL),('2026-02-01 15:14:01.028026',NULL,'2026-02-01 15:14:01.084288',141,141,NULL,'dbc619cd-752d-4285-b0eb-cd9f23f16429',41,'fda4ab42f467487d8e5d3007a76e3476','snapshots',1,'2026-02-02 15:14:00','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:14:01.029138',NULL,'2026-02-01 15:14:01.084288',142,142,NULL,'fc1ba531-067d-4ff6-8685-ba22d89acf52',42,'fda4ab42f467487d8e5d3007a76e3476','snapshot_gigabytes',1,'2026-02-02 15:14:00','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:14:01.954534',NULL,'2026-02-01 15:14:02.022828',143,143,'435a807314d045b7b6183b8871d538b0','b302d9ed-fb0a-426b-afb4-0ad3aba4afbd',39,'fda4ab42f467487d8e5d3007a76e3476','snapshots',1,'2026-02-02 15:14:01',NULL),('2026-02-01 15:14:01.955574',NULL,'2026-02-01 15:14:02.022828',144,144,'435a807314d045b7b6183b8871d538b0','ce19cb90-bb71-472e-9c6c-01b89e7a3404',40,'fda4ab42f467487d8e5d3007a76e3476','snapshot_gigabytes',1,'2026-02-02 15:14:01',NULL),('2026-02-01 15:14:01.960777',NULL,'2026-02-01 15:14:02.022828',145,145,NULL,'a2a6de0c-f0de-4137-8ad5-af341b144e92',41,'fda4ab42f467487d8e5d3007a76e3476','snapshots',1,'2026-02-02 15:14:01','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:14:01.961832',NULL,'2026-02-01 15:14:02.022828',146,146,NULL,'030d375e-2d22-4e83-924a-c5be7475c4f6',42,'fda4ab42f467487d8e5d3007a76e3476','snapshot_gigabytes',1,'2026-02-02 15:14:01','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:14:02.096842',NULL,'2026-02-01 15:14:02.133932',147,147,'2bbd6a9be41643a38007238edf9638fe','dcb4d298-6780-4840-873c-389dc53ae36f',52,'fc17e54c678d41c68e219a1686c0fe7d','shares',-1,'2026-02-02 15:14:02',NULL),('2026-02-01 15:14:02.098175',NULL,'2026-02-01 15:14:02.133932',148,148,'2bbd6a9be41643a38007238edf9638fe','d9ae59a3-9e80-4570-b028-a89a9f459d35',51,'fc17e54c678d41c68e219a1686c0fe7d','gigabytes',-1,'2026-02-02 15:14:02',NULL),('2026-02-01 15:14:02.117755',NULL,'2026-02-01 15:14:02.133932',149,149,NULL,'98851514-24c8-45f6-a83d-7c6663e61a43',56,'fc17e54c678d41c68e219a1686c0fe7d','shares',-1,'2026-02-02 15:14:02','b1712ae3-d38a-4543-bf30-4854aff75f83'),('2026-02-01 15:14:02.119229',NULL,'2026-02-01 15:14:02.133932',150,150,NULL,'bb4ce63b-cecb-4fe8-b3b2-85c38308804f',55,'fc17e54c678d41c68e219a1686c0fe7d','gigabytes',-1,'2026-02-02 15:14:02','b1712ae3-d38a-4543-bf30-4854aff75f83'),('2026-02-01 15:14:04.085116',NULL,'2026-02-01 15:14:04.113832',151,151,'d490148597b44e68bee9a9fe258ee233','05b095a1-352d-4ccf-9575-1169b790d23f',58,'999f6f2ae9a8410ca0b94eca9aa23d7a','shares',1,'2026-02-02 15:14:04',NULL),('2026-02-01 15:14:04.086338',NULL,'2026-02-01 15:14:04.113832',152,152,'d490148597b44e68bee9a9fe258ee233','f1da1b98-29df-4122-8177-db0ca860e7d7',57,'999f6f2ae9a8410ca0b94eca9aa23d7a','gigabytes',1,'2026-02-02 15:14:04',NULL),('2026-02-01 15:14:04.094630',NULL,'2026-02-01 15:14:04.113832',153,153,NULL,'70948c02-28cd-42b3-9aa0-869bf9fde161',60,'999f6f2ae9a8410ca0b94eca9aa23d7a','shares',1,'2026-02-02 15:14:04','8c72e4a5-abce-45c1-bd37-67b1570e670b'),('2026-02-01 15:14:04.095801',NULL,'2026-02-01 15:14:04.113832',154,154,NULL,'8207c5f7-d505-49e2-9312-f3d5051de718',59,'999f6f2ae9a8410ca0b94eca9aa23d7a','gigabytes',1,'2026-02-02 15:14:04','8c72e4a5-abce-45c1-bd37-67b1570e670b'),('2026-02-01 15:14:06.344313',NULL,'2026-02-01 15:14:06.360514',155,155,'435a807314d045b7b6183b8871d538b0','6d0d7ac8-6165-44d3-96bf-ab1aefea5c3c',39,'fda4ab42f467487d8e5d3007a76e3476','snapshots',-1,'2026-02-02 15:14:06',NULL),('2026-02-01 15:14:06.345096',NULL,'2026-02-01 15:14:06.360514',156,156,'435a807314d045b7b6183b8871d538b0','5f58198b-4614-41e5-853b-5c86e76f0fcb',40,'fda4ab42f467487d8e5d3007a76e3476','snapshot_gigabytes',-1,'2026-02-02 15:14:06',NULL),('2026-02-01 15:14:06.350963',NULL,'2026-02-01 15:14:06.360514',157,157,NULL,'6053790f-6c3d-4362-a4ce-bd02dff07519',41,'fda4ab42f467487d8e5d3007a76e3476','snapshots',-1,'2026-02-02 15:14:06','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:14:06.351670',NULL,'2026-02-01 15:14:06.360514',158,158,NULL,'8b59d8a9-3902-4947-8a42-a53c0ba6e1f5',42,'fda4ab42f467487d8e5d3007a76e3476','snapshot_gigabytes',-1,'2026-02-02 15:14:06','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:14:09.521734',NULL,'2026-02-01 15:14:09.557834',159,159,'d490148597b44e68bee9a9fe258ee233','6e390de2-a755-4ec2-a9a3-c38de2bceb4e',58,'999f6f2ae9a8410ca0b94eca9aa23d7a','shares',-1,'2026-02-02 15:14:09',NULL),('2026-02-01 15:14:09.522739',NULL,'2026-02-01 15:14:09.557834',160,160,'d490148597b44e68bee9a9fe258ee233','3b2a5796-d88b-4086-8e42-26e4878eb779',57,'999f6f2ae9a8410ca0b94eca9aa23d7a','gigabytes',-1,'2026-02-02 15:14:09',NULL),('2026-02-01 15:14:09.538865',NULL,'2026-02-01 15:14:09.557834',161,161,NULL,'cb53e932-55cb-4e93-a5b1-a0b7a67b9f6f',60,'999f6f2ae9a8410ca0b94eca9aa23d7a','shares',-1,'2026-02-02 15:14:09','8c72e4a5-abce-45c1-bd37-67b1570e670b'),('2026-02-01 15:14:09.541635',NULL,'2026-02-01 15:14:09.557834',162,162,NULL,'220f5cfb-8731-4069-8fc6-cf2c89ae020f',59,'999f6f2ae9a8410ca0b94eca9aa23d7a','gigabytes',-1,'2026-02-02 15:14:09','8c72e4a5-abce-45c1-bd37-67b1570e670b'),('2026-02-01 15:14:09.770584',NULL,'2026-02-01 15:14:09.787744',163,163,'435a807314d045b7b6183b8871d538b0','667d7b63-14e6-4b38-982a-a95b208ad81e',39,'fda4ab42f467487d8e5d3007a76e3476','snapshots',-1,'2026-02-02 15:14:09',NULL),('2026-02-01 15:14:09.771397',NULL,'2026-02-01 15:14:09.787744',164,164,'435a807314d045b7b6183b8871d538b0','b0e1c144-52c2-4948-b4b2-145b591b9e8f',40,'fda4ab42f467487d8e5d3007a76e3476','snapshot_gigabytes',-1,'2026-02-02 15:14:09',NULL),('2026-02-01 15:14:09.777819',NULL,'2026-02-01 15:14:09.787744',165,165,NULL,'4acec171-40ff-433b-9e1f-fd363ede8a6b',41,'fda4ab42f467487d8e5d3007a76e3476','snapshots',-1,'2026-02-02 15:14:09','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:14:09.778718',NULL,'2026-02-01 15:14:09.787744',166,166,NULL,'a8d6a8d1-284e-4945-807f-def2f987f4ed',42,'fda4ab42f467487d8e5d3007a76e3476','snapshot_gigabytes',-1,'2026-02-02 15:14:09','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:14:13.443989',NULL,'2026-02-01 15:14:13.456502',167,167,'435a807314d045b7b6183b8871d538b0','a038e035-65af-499f-9dcd-81b4ada59f78',39,'fda4ab42f467487d8e5d3007a76e3476','snapshots',-1,'2026-02-02 15:14:13',NULL),('2026-02-01 15:14:13.444655',NULL,'2026-02-01 15:14:13.456502',168,168,'435a807314d045b7b6183b8871d538b0','a6133505-055c-47de-878e-5448d4dd7c2f',40,'fda4ab42f467487d8e5d3007a76e3476','snapshot_gigabytes',-1,'2026-02-02 15:14:13',NULL),('2026-02-01 15:14:13.449369',NULL,'2026-02-01 15:14:13.456502',169,169,NULL,'f0685ae2-5d4a-4523-bc3e-3036a647966c',41,'fda4ab42f467487d8e5d3007a76e3476','snapshots',-1,'2026-02-02 15:14:13','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:14:13.450132',NULL,'2026-02-01 15:14:13.456502',170,170,NULL,'650b5a76-13d2-4655-8460-93ffba47522e',42,'fda4ab42f467487d8e5d3007a76e3476','snapshot_gigabytes',-1,'2026-02-02 15:14:13','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:14:16.908217',NULL,'2026-02-01 15:14:16.926797',171,171,'435a807314d045b7b6183b8871d538b0','0189addd-c810-4083-b497-91e0af700a3c',39,'fda4ab42f467487d8e5d3007a76e3476','snapshots',-1,'2026-02-02 15:14:16',NULL),('2026-02-01 15:14:16.909195',NULL,'2026-02-01 15:14:16.926797',172,172,'435a807314d045b7b6183b8871d538b0','bf15c1ee-1ba0-471d-9315-ad98eca100b9',40,'fda4ab42f467487d8e5d3007a76e3476','snapshot_gigabytes',-1,'2026-02-02 15:14:16',NULL),('2026-02-01 15:14:16.916196',NULL,'2026-02-01 15:14:16.926797',173,173,NULL,'46e78723-3b38-4564-9e51-9bfdf41daa1c',41,'fda4ab42f467487d8e5d3007a76e3476','snapshots',-1,'2026-02-02 15:14:16','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:14:16.917105',NULL,'2026-02-01 15:14:16.926797',174,174,NULL,'2a552eaa-4734-4916-bb2e-c35816e794b6',42,'fda4ab42f467487d8e5d3007a76e3476','snapshot_gigabytes',-1,'2026-02-02 15:14:16','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:14:18.390955',NULL,'2026-02-01 15:14:18.426170',175,175,'52393b023cd64393a0b3cc33f7cf9b0f','01905e91-2d48-45ef-b310-92aebfc43d8f',62,'be07a91869e4476fbc553f85525ca866','shares',1,'2026-02-02 15:14:18',NULL),('2026-02-01 15:14:18.392491',NULL,'2026-02-01 15:14:18.426170',176,176,'52393b023cd64393a0b3cc33f7cf9b0f','1e099eb4-f5e7-4734-9834-64bbd430fd18',61,'be07a91869e4476fbc553f85525ca866','gigabytes',1,'2026-02-02 15:14:18',NULL),('2026-02-01 15:14:18.405373',NULL,'2026-02-01 15:14:18.426170',177,177,NULL,'bc71a008-d388-4f51-9468-7aa961d58e41',64,'be07a91869e4476fbc553f85525ca866','shares',1,'2026-02-02 15:14:18','ae5ac208-d3f1-42e4-bd31-25e0fbedb1a8'),('2026-02-01 15:14:18.407027',NULL,'2026-02-01 15:14:18.426170',178,178,NULL,'5f6d19cc-f33b-4a27-877b-91d246bfd06d',63,'be07a91869e4476fbc553f85525ca866','gigabytes',1,'2026-02-02 15:14:18','ae5ac208-d3f1-42e4-bd31-25e0fbedb1a8'),('2026-02-01 15:14:20.322844',NULL,'2026-02-01 15:14:20.342023',179,179,'435a807314d045b7b6183b8871d538b0','d7d85652-63b4-4383-9944-b76ed4249253',39,'fda4ab42f467487d8e5d3007a76e3476','snapshots',-1,'2026-02-02 15:14:20',NULL),('2026-02-01 15:14:20.324831',NULL,'2026-02-01 15:14:20.342023',180,180,'435a807314d045b7b6183b8871d538b0','5e1b60ff-5821-4ad2-b529-c65ccb61f07b',40,'fda4ab42f467487d8e5d3007a76e3476','snapshot_gigabytes',-1,'2026-02-02 15:14:20',NULL),('2026-02-01 15:14:20.333721',NULL,'2026-02-01 15:14:20.342023',181,181,NULL,'62aeb3b9-b943-44af-856c-a7a203563525',41,'fda4ab42f467487d8e5d3007a76e3476','snapshots',-1,'2026-02-02 15:14:20','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:14:20.334486',NULL,'2026-02-01 15:14:20.342023',182,182,NULL,'0ab86e7a-561c-4922-b802-e1c591d070d3',42,'fda4ab42f467487d8e5d3007a76e3476','snapshot_gigabytes',-1,'2026-02-02 15:14:20','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:14:21.265178',NULL,'2026-02-01 15:14:21.412213',183,183,'435a807314d045b7b6183b8871d538b0','b53a79d1-251e-426a-acc6-f0272f8135e9',2,'fda4ab42f467487d8e5d3007a76e3476','shares',-1,'2026-02-02 15:14:21',NULL),('2026-02-01 15:14:21.265810',NULL,'2026-02-01 15:14:21.412213',184,184,'435a807314d045b7b6183b8871d538b0','59f4ffbf-64a7-4e93-8535-440bf68122ac',1,'fda4ab42f467487d8e5d3007a76e3476','gigabytes',-1,'2026-02-02 15:14:21',NULL),('2026-02-01 15:14:21.403578',NULL,'2026-02-01 15:14:21.412213',185,185,NULL,'b95f2e8c-7eef-453f-bd1d-f6ea1b1761ca',4,'fda4ab42f467487d8e5d3007a76e3476','shares',-1,'2026-02-02 15:14:21','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:14:21.404434',NULL,'2026-02-01 15:14:21.412213',186,186,NULL,'94de791d-89cb-4c9d-bdef-cd1645654b42',3,'fda4ab42f467487d8e5d3007a76e3476','gigabytes',-1,'2026-02-02 15:14:21','d12a5a5d-639b-477e-9123-330697ff0216'),('2026-02-01 15:14:22.851555',NULL,'2026-02-01 15:14:22.864338',187,187,'52393b023cd64393a0b3cc33f7cf9b0f','8be44eb1-2c05-4869-b961-d5663e30c393',62,'be07a91869e4476fbc553f85525ca866','shares',-1,'2026-02-02 15:14:22',NULL),('2026-02-01 15:14:22.852228',NULL,'2026-02-01 15:14:22.864338',188,188,'52393b023cd64393a0b3cc33f7cf9b0f','cc817c0e-299a-413a-a744-4b05bd6c95a8',61,'be07a91869e4476fbc553f85525ca866','gigabytes',-1,'2026-02-02 15:14:22',NULL),('2026-02-01 15:14:22.857049',NULL,'2026-02-01 15:14:22.864338',189,189,NULL,'fc8036bd-22d9-4165-a2af-861418fb6715',64,'be07a91869e4476fbc553f85525ca866','shares',-1,'2026-02-02 15:14:22','ae5ac208-d3f1-42e4-bd31-25e0fbedb1a8'),('2026-02-01 15:14:22.857687',NULL,'2026-02-01 15:14:22.864338',190,190,NULL,'ecfd2694-2bd6-4643-8d1a-52b81236dcef',63,'be07a91869e4476fbc553f85525ca866','gigabytes',-1,'2026-02-02 15:14:22','ae5ac208-d3f1-42e4-bd31-25e0fbedb1a8'),('2026-02-01 15:14:23.733024',NULL,'2026-02-01 15:14:23.768801',191,191,'928da2f6147a4b708835fcbebf483d8a','329503ce-18e1-4555-84c9-3530c244f6cf',66,'8148327cebed4bb49e576111ce3edff1','shares',1,'2026-02-02 15:14:23',NULL),('2026-02-01 15:14:23.734865',NULL,'2026-02-01 15:14:23.768801',192,192,'928da2f6147a4b708835fcbebf483d8a','a8031412-8fac-4bc1-8b25-5ce95830562c',65,'8148327cebed4bb49e576111ce3edff1','gigabytes',1,'2026-02-02 15:14:23',NULL),('2026-02-01 15:14:23.750093',NULL,'2026-02-01 15:14:23.768801',193,193,NULL,'ba0841de-0e1b-4e07-9258-575b1275cf76',68,'8148327cebed4bb49e576111ce3edff1','shares',1,'2026-02-02 15:14:23','71a8cb03-a879-4fa1-9570-d4a2c3127be2'),('2026-02-01 15:14:23.751198',NULL,'2026-02-01 15:14:23.768801',194,194,NULL,'315c163c-f5f8-44e4-8d17-1dd9fb4c48f1',67,'8148327cebed4bb49e576111ce3edff1','gigabytes',1,'2026-02-02 15:14:23','71a8cb03-a879-4fa1-9570-d4a2c3127be2'),('2026-02-01 15:14:27.252866',NULL,'2026-02-01 15:14:27.291463',195,195,'928da2f6147a4b708835fcbebf483d8a','5938e045-62a9-4fef-8cbe-f7f790741885',66,'8148327cebed4bb49e576111ce3edff1','shares',1,'2026-02-02 15:14:27',NULL),('2026-02-01 15:14:27.256516',NULL,'2026-02-01 15:14:27.291463',196,196,'928da2f6147a4b708835fcbebf483d8a','10786135-ebb0-4b26-8f90-f30ab404f0ca',65,'8148327cebed4bb49e576111ce3edff1','gigabytes',1,'2026-02-02 15:14:27',NULL),('2026-02-01 15:14:27.263330',NULL,'2026-02-01 15:14:27.291463',197,197,NULL,'4eab430a-1097-45b2-8e49-bd302d9c36f0',68,'8148327cebed4bb49e576111ce3edff1','shares',1,'2026-02-02 15:14:27','71a8cb03-a879-4fa1-9570-d4a2c3127be2'),('2026-02-01 15:14:27.267355',NULL,'2026-02-01 15:14:27.291463',198,198,NULL,'c45f82d9-b0e8-45d6-a1d4-f00b8a90c460',67,'8148327cebed4bb49e576111ce3edff1','gigabytes',1,'2026-02-02 15:14:27','71a8cb03-a879-4fa1-9570-d4a2c3127be2'),('2026-02-01 15:14:31.840963',NULL,'2026-02-01 15:14:31.902825',199,199,'8aed0688b51d4ff0a0a064f11d0b453b','2b082463-a245-4ccd-bad1-06484d9b53ad',69,'9daf6f5120ad4addbf1be43b336ab548','share_networks',1,'2026-02-02 15:14:31',NULL),('2026-02-01 15:14:32.113365',NULL,'2026-02-01 15:14:32.133038',200,200,'928da2f6147a4b708835fcbebf483d8a','37d5b7ff-bc9b-4d68-b331-e28adb26069e',66,'8148327cebed4bb49e576111ce3edff1','shares',-1,'2026-02-02 15:14:32',NULL),('2026-02-01 15:14:32.114186',NULL,'2026-02-01 15:14:32.133038',201,201,'928da2f6147a4b708835fcbebf483d8a','34a093be-e0d9-465c-a1c8-e64183ba57ef',65,'8148327cebed4bb49e576111ce3edff1','gigabytes',-1,'2026-02-02 15:14:32',NULL),('2026-02-01 15:14:32.119901',NULL,'2026-02-01 15:14:32.133038',202,202,NULL,'6d573563-7fe1-456b-9703-4e586da63b09',68,'8148327cebed4bb49e576111ce3edff1','shares',-1,'2026-02-02 15:14:32','71a8cb03-a879-4fa1-9570-d4a2c3127be2'),('2026-02-01 15:14:32.121943',NULL,'2026-02-01 15:14:32.133038',203,203,NULL,'dad361bb-c05a-49b7-9ae8-ce4a2b89e9d0',67,'8148327cebed4bb49e576111ce3edff1','gigabytes',-1,'2026-02-02 15:14:32','71a8cb03-a879-4fa1-9570-d4a2c3127be2'),('2026-02-01 15:14:32.402981',NULL,'2026-02-01 15:14:32.443390',204,204,'08f88d0b6ec54c79a8bfec726694c073','abe4601b-9f60-4960-822a-6f3c74f454e4',70,'389354672a9f45998c217a07289430b9','share_networks',1,'2026-02-02 15:14:32',NULL),('2026-02-01 15:14:34.178813',NULL,'2026-02-01 15:14:34.186211',205,205,'8aed0688b51d4ff0a0a064f11d0b453b','be76b784-781d-4233-8268-d9a9c5aa9047',69,'9daf6f5120ad4addbf1be43b336ab548','share_networks',-1,'2026-02-02 15:14:34',NULL),('2026-02-01 15:14:35.237123',NULL,'2026-02-01 15:14:35.269599',206,206,'928da2f6147a4b708835fcbebf483d8a','19020e13-1314-4e5f-8e7b-61855ccf7c95',66,'8148327cebed4bb49e576111ce3edff1','shares',1,'2026-02-02 15:14:35',NULL),('2026-02-01 15:14:35.239743',NULL,'2026-02-01 15:14:35.269599',207,207,'928da2f6147a4b708835fcbebf483d8a','eb9acf28-8729-443e-8242-ab6ae16c9f18',65,'8148327cebed4bb49e576111ce3edff1','gigabytes',1,'2026-02-02 15:14:35',NULL),('2026-02-01 15:14:35.247002',NULL,'2026-02-01 15:14:35.269599',208,208,NULL,'f757a6ec-2d32-460d-9b3b-0402d1e6df4f',68,'8148327cebed4bb49e576111ce3edff1','shares',1,'2026-02-02 15:14:35','71a8cb03-a879-4fa1-9570-d4a2c3127be2'),('2026-02-01 15:14:35.248094',NULL,'2026-02-01 15:14:35.269599',209,209,NULL,'c5ff9c51-2052-4b26-acf4-bd5ba381c4fa',67,'8148327cebed4bb49e576111ce3edff1','gigabytes',1,'2026-02-02 15:14:35','71a8cb03-a879-4fa1-9570-d4a2c3127be2'),('2026-02-01 15:14:39.484436',NULL,'2026-02-01 15:14:39.517777',210,210,'26e3e1d8b04f4d09b6941b9eed4bed81','d1908952-0ed2-45e8-ac97-3fb2c85b2a87',72,'42d5324bd181499ca11dbc92c8e1556c','shares',1,'2026-02-02 15:14:39',NULL),('2026-02-01 15:14:39.487681',NULL,'2026-02-01 15:14:39.517777',211,211,'26e3e1d8b04f4d09b6941b9eed4bed81','bb8e2041-f79a-47fa-a3e6-fe1aa24f3dc4',71,'42d5324bd181499ca11dbc92c8e1556c','gigabytes',1,'2026-02-02 15:14:39',NULL),('2026-02-01 15:14:39.499246',NULL,'2026-02-01 15:14:39.517777',212,212,NULL,'09d318cd-6969-461d-a06a-be8e334183fe',74,'42d5324bd181499ca11dbc92c8e1556c','shares',1,'2026-02-02 15:14:39','c056af43-2681-4a32-98f6-e60c1f1a3560'),('2026-02-01 15:14:39.500254',NULL,'2026-02-01 15:14:39.517777',213,213,NULL,'daf02991-0bb2-48c3-9786-776ad2565904',73,'42d5324bd181499ca11dbc92c8e1556c','gigabytes',1,'2026-02-02 15:14:39','c056af43-2681-4a32-98f6-e60c1f1a3560'),('2026-02-01 15:14:40.477698',NULL,'2026-02-01 15:14:40.491065',214,214,'928da2f6147a4b708835fcbebf483d8a','d90b30c1-1ed1-435a-965f-53451804e779',66,'8148327cebed4bb49e576111ce3edff1','shares',-1,'2026-02-02 15:14:40',NULL),('2026-02-01 15:14:40.478334',NULL,'2026-02-01 15:14:40.491065',215,215,'928da2f6147a4b708835fcbebf483d8a','cd98801b-b036-468b-95e0-c41f3457bfa4',65,'8148327cebed4bb49e576111ce3edff1','gigabytes',-1,'2026-02-02 15:14:40',NULL),('2026-02-01 15:14:40.484025',NULL,'2026-02-01 15:14:40.491065',216,216,NULL,'60c9d755-7bbd-4c86-8204-e4001bf22f90',68,'8148327cebed4bb49e576111ce3edff1','shares',-1,'2026-02-02 15:14:40','71a8cb03-a879-4fa1-9570-d4a2c3127be2'),('2026-02-01 15:14:40.484677',NULL,'2026-02-01 15:14:40.491065',217,217,NULL,'97f70161-0a1e-4085-bf22-22042e016225',67,'8148327cebed4bb49e576111ce3edff1','gigabytes',-1,'2026-02-02 15:14:40','71a8cb03-a879-4fa1-9570-d4a2c3127be2'),('2026-02-01 15:14:43.143155',NULL,'2026-02-01 15:14:43.241183',218,218,'26e3e1d8b04f4d09b6941b9eed4bed81','23664559-2cdb-4ac7-8851-6c388066dc99',76,'42d5324bd181499ca11dbc92c8e1556c','snapshots',1,'2026-02-02 15:14:43',NULL),('2026-02-01 15:14:43.144468',NULL,'2026-02-01 15:14:43.241183',219,219,'26e3e1d8b04f4d09b6941b9eed4bed81','830c003d-decd-4507-a2ee-00a685ed687e',75,'42d5324bd181499ca11dbc92c8e1556c','snapshot_gigabytes',1,'2026-02-02 15:14:43',NULL),('2026-02-01 15:14:43.161527',NULL,'2026-02-01 15:14:43.241183',220,220,NULL,'e23295d3-ff9f-497e-a9ee-8ada8fcdb03f',78,'42d5324bd181499ca11dbc92c8e1556c','snapshots',1,'2026-02-02 15:14:43','c056af43-2681-4a32-98f6-e60c1f1a3560'),('2026-02-01 15:14:43.169918',NULL,'2026-02-01 15:14:43.241183',221,221,NULL,'e61c8067-9608-4da5-81ab-5bd81c98a550',77,'42d5324bd181499ca11dbc92c8e1556c','snapshot_gigabytes',1,'2026-02-02 15:14:43','c056af43-2681-4a32-98f6-e60c1f1a3560'),('2026-02-01 15:14:43.593032',NULL,'2026-02-01 15:14:43.622268',222,222,'928da2f6147a4b708835fcbebf483d8a','a5caa118-508b-4fe9-a2fe-024221e51d22',66,'8148327cebed4bb49e576111ce3edff1','shares',1,'2026-02-02 15:14:43',NULL),('2026-02-01 15:14:43.594586',NULL,'2026-02-01 15:14:43.622268',223,223,'928da2f6147a4b708835fcbebf483d8a','99209037-1e37-4de6-b0b1-412872eda2dc',65,'8148327cebed4bb49e576111ce3edff1','gigabytes',1,'2026-02-02 15:14:43',NULL),('2026-02-01 15:14:43.600499',NULL,'2026-02-01 15:14:43.622268',224,224,NULL,'6e0117e9-1a74-4f93-9df6-bcd9e5af4663',68,'8148327cebed4bb49e576111ce3edff1','shares',1,'2026-02-02 15:14:43','71a8cb03-a879-4fa1-9570-d4a2c3127be2'),('2026-02-01 15:14:43.601491',NULL,'2026-02-01 15:14:43.622268',225,225,NULL,'94aa115c-9d10-4016-bd3c-dc37f72b39e5',67,'8148327cebed4bb49e576111ce3edff1','gigabytes',1,'2026-02-02 15:14:43','71a8cb03-a879-4fa1-9570-d4a2c3127be2'),('2026-02-01 15:14:47.371956',NULL,'2026-02-01 15:14:47.406997',226,226,'2c641459542741e59f6414cbb91ed187','aa22a882-fdf0-4b7a-a082-1cc22ea7d330',80,'b3c21deb7cba41feaff782713b1775e6','shares',1,'2026-02-02 15:14:47',NULL),('2026-02-01 15:14:47.374186',NULL,'2026-02-01 15:14:47.406997',227,227,'2c641459542741e59f6414cbb91ed187','d3d22bea-622c-439c-8c93-0bafdca8ee2b',79,'b3c21deb7cba41feaff782713b1775e6','gigabytes',1,'2026-02-02 15:14:47',NULL),('2026-02-01 15:14:47.388011',NULL,'2026-02-01 15:14:47.406997',228,228,NULL,'b67f3c81-38b5-409d-bbe5-93e83ea72b4a',82,'b3c21deb7cba41feaff782713b1775e6','shares',1,'2026-02-02 15:14:47','d8cb87c7-b9fa-4c1f-978a-61b318980e99'),('2026-02-01 15:14:47.389166',NULL,'2026-02-01 15:14:47.406997',229,229,NULL,'af24aabc-bd09-47ac-8c99-61ed35e2b7a5',81,'b3c21deb7cba41feaff782713b1775e6','gigabytes',1,'2026-02-02 15:14:47','d8cb87c7-b9fa-4c1f-978a-61b318980e99'),('2026-02-01 15:14:47.612309',NULL,'2026-02-01 15:14:47.702322',230,230,'26e3e1d8b04f4d09b6941b9eed4bed81','c353c4d6-cc93-45fa-9cf2-9511acc30890',76,'42d5324bd181499ca11dbc92c8e1556c','snapshots',1,'2026-02-02 15:14:47',NULL),('2026-02-01 15:14:47.614025',NULL,'2026-02-01 15:14:47.702322',231,231,'26e3e1d8b04f4d09b6941b9eed4bed81','68a3bab4-b194-4c46-8689-2c0865e3547d',75,'42d5324bd181499ca11dbc92c8e1556c','snapshot_gigabytes',1,'2026-02-02 15:14:47',NULL),('2026-02-01 15:14:47.627557',NULL,'2026-02-01 15:14:47.702322',232,232,NULL,'a0ff6cd6-21de-4871-874a-59ccc0c4a2ae',78,'42d5324bd181499ca11dbc92c8e1556c','snapshots',1,'2026-02-02 15:14:47','c056af43-2681-4a32-98f6-e60c1f1a3560'),('2026-02-01 15:14:47.631053',NULL,'2026-02-01 15:14:47.702322',233,233,NULL,'38d558ae-a5df-4594-b4e3-92121c374d4c',77,'42d5324bd181499ca11dbc92c8e1556c','snapshot_gigabytes',1,'2026-02-02 15:14:47','c056af43-2681-4a32-98f6-e60c1f1a3560'),('2026-02-01 15:14:47.900595',NULL,'2026-02-01 15:14:47.920166',234,234,'928da2f6147a4b708835fcbebf483d8a','f3242237-b114-4c27-aa8c-3dc1c6233247',66,'8148327cebed4bb49e576111ce3edff1','shares',-1,'2026-02-02 15:14:47',NULL),('2026-02-01 15:14:47.901952',NULL,'2026-02-01 15:14:47.920166',235,235,'928da2f6147a4b708835fcbebf483d8a','50524659-a783-4d09-a7c3-af692023bda6',65,'8148327cebed4bb49e576111ce3edff1','gigabytes',-1,'2026-02-02 15:14:47',NULL),('2026-02-01 15:14:47.911230',NULL,'2026-02-01 15:14:47.920166',236,236,NULL,'900d4714-8920-4416-a6ab-f17891d93fb3',68,'8148327cebed4bb49e576111ce3edff1','shares',-1,'2026-02-02 15:14:47','71a8cb03-a879-4fa1-9570-d4a2c3127be2'),('2026-02-01 15:14:47.912091',NULL,'2026-02-01 15:14:47.920166',237,237,NULL,'ee246663-a7cb-41e9-8759-b325ad433026',67,'8148327cebed4bb49e576111ce3edff1','gigabytes',-1,'2026-02-02 15:14:47','71a8cb03-a879-4fa1-9570-d4a2c3127be2'),('2026-02-01 15:14:50.874284',NULL,'2026-02-01 15:14:50.934278',238,238,'928da2f6147a4b708835fcbebf483d8a','2a5ca27e-05c0-4f01-92e8-f71b69dec395',66,'8148327cebed4bb49e576111ce3edff1','shares',1,'2026-02-02 15:14:50',NULL),('2026-02-01 15:14:50.876033',NULL,'2026-02-01 15:14:50.934278',239,239,'928da2f6147a4b708835fcbebf483d8a','48f84d98-e7bc-41fc-b682-4e7d995c1ddf',65,'8148327cebed4bb49e576111ce3edff1','gigabytes',1,'2026-02-02 15:14:50',NULL),('2026-02-01 15:14:50.888121',NULL,'2026-02-01 15:14:50.934278',240,240,NULL,'cd666936-47a3-4593-af5c-4aeac9eafc2f',68,'8148327cebed4bb49e576111ce3edff1','shares',1,'2026-02-02 15:14:50','71a8cb03-a879-4fa1-9570-d4a2c3127be2'),('2026-02-01 15:14:50.890945',NULL,'2026-02-01 15:14:50.934278',241,241,NULL,'613c30d9-4799-4a2a-a0a5-faeb19716146',67,'8148327cebed4bb49e576111ce3edff1','gigabytes',1,'2026-02-02 15:14:50','71a8cb03-a879-4fa1-9570-d4a2c3127be2'),('2026-02-01 15:14:52.446824',NULL,'2026-02-01 15:14:52.477816',242,242,'26e3e1d8b04f4d09b6941b9eed4bed81','e2f036d3-3104-41d0-86b1-5554c5557c8b',76,'42d5324bd181499ca11dbc92c8e1556c','snapshots',-1,'2026-02-02 15:14:52',NULL),('2026-02-01 15:14:52.447857',NULL,'2026-02-01 15:14:52.477816',243,243,'26e3e1d8b04f4d09b6941b9eed4bed81','fc25c3da-1b41-4039-9c73-7c19ddbeedf1',75,'42d5324bd181499ca11dbc92c8e1556c','snapshot_gigabytes',-1,'2026-02-02 15:14:52',NULL),('2026-02-01 15:14:52.462011',NULL,'2026-02-01 15:14:52.477816',244,244,NULL,'188f0585-c3fb-4579-9866-3ad499675727',78,'42d5324bd181499ca11dbc92c8e1556c','snapshots',-1,'2026-02-02 15:14:52','c056af43-2681-4a32-98f6-e60c1f1a3560'),('2026-02-01 15:14:52.463686',NULL,'2026-02-01 15:14:52.477816',245,245,NULL,'739d263f-6483-45b7-a6bb-b21846849979',77,'42d5324bd181499ca11dbc92c8e1556c','snapshot_gigabytes',-1,'2026-02-02 15:14:52','c056af43-2681-4a32-98f6-e60c1f1a3560'),('2026-02-01 15:14:55.567276',NULL,'2026-02-01 15:14:55.610324',246,246,'e47de2b4135b4005af9009853f7a18dd','2538d849-6a1f-46cb-915a-b9a27663ded7',84,'4ed32334aab64e5388ef8e859555acf4','shares',1,'2026-02-02 15:14:55',NULL),('2026-02-01 15:14:55.568436',NULL,'2026-02-01 15:14:55.610324',247,247,'e47de2b4135b4005af9009853f7a18dd','fcb1ba60-ced0-48f8-8c02-cfc07022138e',83,'4ed32334aab64e5388ef8e859555acf4','gigabytes',1,'2026-02-02 15:14:55',NULL),('2026-02-01 15:14:55.586592',NULL,'2026-02-01 15:14:55.610324',248,248,NULL,'0f3b7842-752b-452e-8ccf-8a78bd97edca',86,'4ed32334aab64e5388ef8e859555acf4','shares',1,'2026-02-02 15:14:55','f6afe9eb-b901-4be4-a89a-bc6dc1369ca5'),('2026-02-01 15:14:55.588290',NULL,'2026-02-01 15:14:55.610324',249,249,NULL,'845dd169-207f-4fdd-956d-83be9b72214c',85,'4ed32334aab64e5388ef8e859555acf4','gigabytes',1,'2026-02-02 15:14:55','f6afe9eb-b901-4be4-a89a-bc6dc1369ca5'),('2026-02-01 15:14:56.176104',NULL,'2026-02-01 15:14:56.192924',250,250,'26e3e1d8b04f4d09b6941b9eed4bed81','bc6f7cb3-d43f-476e-9a2d-6690563e1928',76,'42d5324bd181499ca11dbc92c8e1556c','snapshots',-1,'2026-02-02 15:14:56',NULL),('2026-02-01 15:14:56.176851',NULL,'2026-02-01 15:14:56.192924',251,251,'26e3e1d8b04f4d09b6941b9eed4bed81','d8f05769-0ea0-4a1e-9c5f-25e76c937504',75,'42d5324bd181499ca11dbc92c8e1556c','snapshot_gigabytes',-1,'2026-02-02 15:14:56',NULL),('2026-02-01 15:14:56.182807',NULL,'2026-02-01 15:14:56.192924',252,252,NULL,'05f1f09c-8626-440f-99ba-8738c1ebdf0d',78,'42d5324bd181499ca11dbc92c8e1556c','snapshots',-1,'2026-02-02 15:14:56','c056af43-2681-4a32-98f6-e60c1f1a3560'),('2026-02-01 15:14:56.184191',NULL,'2026-02-01 15:14:56.192924',253,253,NULL,'16f51d3f-4b56-4ed3-a566-5b248d4bac43',77,'42d5324bd181499ca11dbc92c8e1556c','snapshot_gigabytes',-1,'2026-02-02 15:14:56','c056af43-2681-4a32-98f6-e60c1f1a3560'),('2026-02-01 15:14:56.531373',NULL,'2026-02-01 15:14:56.547122',254,254,'928da2f6147a4b708835fcbebf483d8a','260fcbfc-4fe6-43d9-8b11-b6c9c809db89',66,'8148327cebed4bb49e576111ce3edff1','shares',-1,'2026-02-02 15:14:56',NULL),('2026-02-01 15:14:56.532330',NULL,'2026-02-01 15:14:56.547122',255,255,'928da2f6147a4b708835fcbebf483d8a','7837ae44-5385-4dca-9269-925e94466d8c',65,'8148327cebed4bb49e576111ce3edff1','gigabytes',-1,'2026-02-02 15:14:56',NULL),('2026-02-01 15:14:56.537853',NULL,'2026-02-01 15:14:56.547122',256,256,NULL,'664d9be8-79cc-40dc-aca7-a11ecd9f0ece',68,'8148327cebed4bb49e576111ce3edff1','shares',-1,'2026-02-02 15:14:56','71a8cb03-a879-4fa1-9570-d4a2c3127be2'),('2026-02-01 15:14:56.538594',NULL,'2026-02-01 15:14:56.547122',257,257,NULL,'4738dd3a-92f9-4da9-bd8b-da6e27325e38',67,'8148327cebed4bb49e576111ce3edff1','gigabytes',-1,'2026-02-02 15:14:56','71a8cb03-a879-4fa1-9570-d4a2c3127be2'),('2026-02-01 15:14:59.498117',NULL,'2026-02-01 15:14:59.521619',258,258,'26e3e1d8b04f4d09b6941b9eed4bed81','c45c257b-be5d-4119-bc04-e7e75491edba',72,'42d5324bd181499ca11dbc92c8e1556c','shares',-1,'2026-02-02 15:14:59',NULL),('2026-02-01 15:14:59.499917',NULL,'2026-02-01 15:14:59.521619',259,259,'26e3e1d8b04f4d09b6941b9eed4bed81','04d7499c-88e6-417e-aafd-060096c90344',71,'42d5324bd181499ca11dbc92c8e1556c','gigabytes',-1,'2026-02-02 15:14:59',NULL),('2026-02-01 15:14:59.507181',NULL,'2026-02-01 15:14:59.521619',260,260,NULL,'5475a664-7d3e-4b7a-b095-ed78e3c6d285',74,'42d5324bd181499ca11dbc92c8e1556c','shares',-1,'2026-02-02 15:14:59','c056af43-2681-4a32-98f6-e60c1f1a3560'),('2026-02-01 15:14:59.508004',NULL,'2026-02-01 15:14:59.521619',261,261,NULL,'55512fef-3bab-4f48-94b1-023ddbf72fbc',73,'42d5324bd181499ca11dbc92c8e1556c','gigabytes',-1,'2026-02-02 15:14:59','c056af43-2681-4a32-98f6-e60c1f1a3560'),('2026-02-01 15:15:00.960196',NULL,'2026-02-01 15:15:00.982759',262,262,'e47de2b4135b4005af9009853f7a18dd','de93f255-7ae9-4cbb-bf4f-8778ba11f495',84,'4ed32334aab64e5388ef8e859555acf4','shares',-1,'2026-02-02 15:15:00',NULL),('2026-02-01 15:15:00.961157',NULL,'2026-02-01 15:15:00.982759',263,263,'e47de2b4135b4005af9009853f7a18dd','aa76adaa-8eb9-4cea-90ad-ac22d6cbab12',83,'4ed32334aab64e5388ef8e859555acf4','gigabytes',-1,'2026-02-02 15:15:00',NULL),('2026-02-01 15:15:00.972202',NULL,'2026-02-01 15:15:00.982759',264,264,NULL,'b39ee8a1-6a8a-44b7-b667-779f5227bb81',86,'4ed32334aab64e5388ef8e859555acf4','shares',-1,'2026-02-02 15:15:00','f6afe9eb-b901-4be4-a89a-bc6dc1369ca5'),('2026-02-01 15:15:00.973059',NULL,'2026-02-01 15:15:00.982759',265,265,NULL,'9e33d34f-bc0e-4223-b5fb-c737e1f2f1ad',85,'4ed32334aab64e5388ef8e859555acf4','gigabytes',-1,'2026-02-02 15:15:00','f6afe9eb-b901-4be4-a89a-bc6dc1369ca5'),('2026-02-01 15:15:01.185282',NULL,'2026-02-01 15:15:01.223930',266,266,'928da2f6147a4b708835fcbebf483d8a','5b8e7f4f-5b2e-4916-b896-d584e7cb2cfb',66,'8148327cebed4bb49e576111ce3edff1','shares',1,'2026-02-02 15:15:01',NULL),('2026-02-01 15:15:01.187104',NULL,'2026-02-01 15:15:01.223930',267,267,'928da2f6147a4b708835fcbebf483d8a','45b73184-b901-44a2-a70e-73e9aae23825',65,'8148327cebed4bb49e576111ce3edff1','gigabytes',1,'2026-02-02 15:15:01',NULL),('2026-02-01 15:15:01.194829',NULL,'2026-02-01 15:15:01.223930',268,268,NULL,'478f5a45-3424-4b3d-931e-6788a1e8f59a',68,'8148327cebed4bb49e576111ce3edff1','shares',1,'2026-02-02 15:15:01','71a8cb03-a879-4fa1-9570-d4a2c3127be2'),('2026-02-01 15:15:01.197654',NULL,'2026-02-01 15:15:01.223930',269,269,NULL,'2970326a-e585-470a-a588-03edcce20a14',67,'8148327cebed4bb49e576111ce3edff1','gigabytes',1,'2026-02-02 15:15:01','71a8cb03-a879-4fa1-9570-d4a2c3127be2'),('2026-02-01 15:15:03.211621',NULL,'2026-02-01 15:15:03.230987',270,270,'2c641459542741e59f6414cbb91ed187','8963c263-1b2b-4f47-90dc-e13570db5484',80,'b3c21deb7cba41feaff782713b1775e6','shares',-1,'2026-02-02 15:15:03',NULL),('2026-02-01 15:15:03.212516',NULL,'2026-02-01 15:15:03.230987',271,271,'2c641459542741e59f6414cbb91ed187','64fe22d9-6cdd-470d-81ba-fe1323790211',79,'b3c21deb7cba41feaff782713b1775e6','gigabytes',-1,'2026-02-02 15:15:03',NULL),('2026-02-01 15:15:03.217854',NULL,'2026-02-01 15:15:03.230987',272,272,NULL,'08838d2c-50ac-4d1f-912a-1182a4c245ab',82,'b3c21deb7cba41feaff782713b1775e6','shares',-1,'2026-02-02 15:15:03','d8cb87c7-b9fa-4c1f-978a-61b318980e99'),('2026-02-01 15:15:03.220019',NULL,'2026-02-01 15:15:03.230987',273,273,NULL,'5cb44bce-1742-4c73-ad15-1423785832c1',81,'b3c21deb7cba41feaff782713b1775e6','gigabytes',-1,'2026-02-02 15:15:03','d8cb87c7-b9fa-4c1f-978a-61b318980e99'),('2026-02-01 15:15:07.616947',NULL,'2026-02-01 15:15:07.638624',274,274,'928da2f6147a4b708835fcbebf483d8a','09d62c72-69f6-488d-b6dc-ddd4f98a240a',66,'8148327cebed4bb49e576111ce3edff1','shares',-1,'2026-02-02 15:15:07',NULL),('2026-02-01 15:15:07.617647',NULL,'2026-02-01 15:15:07.638624',275,275,'928da2f6147a4b708835fcbebf483d8a','393346cb-1627-427e-b304-25ec4969dec0',65,'8148327cebed4bb49e576111ce3edff1','gigabytes',-1,'2026-02-02 15:15:07',NULL),('2026-02-01 15:15:07.630730',NULL,'2026-02-01 15:15:07.638624',276,276,NULL,'af6a6791-0217-4c57-97fe-27d7d25d6c0e',68,'8148327cebed4bb49e576111ce3edff1','shares',-1,'2026-02-02 15:15:07','71a8cb03-a879-4fa1-9570-d4a2c3127be2'),('2026-02-01 15:15:07.631571',NULL,'2026-02-01 15:15:07.638624',277,277,NULL,'aa341c55-423d-463e-810a-96418fc373fd',67,'8148327cebed4bb49e576111ce3edff1','gigabytes',-1,'2026-02-02 15:15:07','71a8cb03-a879-4fa1-9570-d4a2c3127be2'),('2026-02-01 15:15:09.376472',NULL,'2026-02-01 15:15:09.548096',278,278,'32efe54ffae74acfbb12e72ef8334608','ca09060b-987a-4ab7-bf1a-a3a520e51bd0',88,'46cbc131a820464a9b6cd0940829aea6','shares',1,'2026-02-02 15:15:09',NULL),('2026-02-01 15:15:09.389606',NULL,'2026-02-01 15:15:09.548096',279,279,'32efe54ffae74acfbb12e72ef8334608','caf99e9e-79ab-4f81-adbc-982aab40a98b',87,'46cbc131a820464a9b6cd0940829aea6','gigabytes',1,'2026-02-02 15:15:09',NULL),('2026-02-01 15:15:09.401060',NULL,'2026-02-01 15:15:09.548096',280,280,NULL,'44a037b7-d3d6-499a-b496-d5a1232891b0',90,'46cbc131a820464a9b6cd0940829aea6','shares',1,'2026-02-02 15:15:09','61d66fc8-1151-4700-8fe3-06f0671259ab'),('2026-02-01 15:15:09.402583',NULL,'2026-02-01 15:15:09.548096',281,281,NULL,'e4377a7c-28b4-4088-b958-9bb9413bb6bc',89,'46cbc131a820464a9b6cd0940829aea6','gigabytes',1,'2026-02-02 15:15:09','61d66fc8-1151-4700-8fe3-06f0671259ab'),('2026-02-01 15:15:12.722416',NULL,'2026-02-01 15:15:12.751420',282,282,'6c83c28e021c4717b45ee6d416ec31f5','0ce95498-f0ab-48d3-aa79-8c489d4c9f85',92,'0dfd4148452647aa845013a982630bb0','shares',1,'2026-02-02 15:15:12',NULL),('2026-02-01 15:15:12.723383',NULL,'2026-02-01 15:15:12.751420',283,283,'6c83c28e021c4717b45ee6d416ec31f5','87577617-17b3-4cfc-a930-75a243c3a5fb',91,'0dfd4148452647aa845013a982630bb0','gigabytes',1,'2026-02-02 15:15:12',NULL),('2026-02-01 15:15:12.731750',NULL,'2026-02-01 15:15:12.751420',284,284,NULL,'c8c67b33-e2ad-464c-8698-8d33f4906cff',94,'0dfd4148452647aa845013a982630bb0','shares',1,'2026-02-02 15:15:12','70f1e3e3-1df6-4e6a-972a-e4316600cd5d'),('2026-02-01 15:15:12.732634',NULL,'2026-02-01 15:15:12.751420',285,285,NULL,'bc467c14-271e-4856-ac72-c24b1f4270dc',93,'0dfd4148452647aa845013a982630bb0','gigabytes',1,'2026-02-02 15:15:12','70f1e3e3-1df6-4e6a-972a-e4316600cd5d'),('2026-02-01 15:15:13.183083',NULL,'2026-02-01 15:15:13.246517',286,286,'32efe54ffae74acfbb12e72ef8334608','c9766a79-8560-44cc-9a52-d05087cd985d',95,'46cbc131a820464a9b6cd0940829aea6','snapshots',1,'2026-02-02 15:15:13',NULL),('2026-02-01 15:15:13.184243',NULL,'2026-02-01 15:15:13.246517',287,287,'32efe54ffae74acfbb12e72ef8334608','5c0234cb-9224-42e5-aad8-a6f08fba1f9a',96,'46cbc131a820464a9b6cd0940829aea6','snapshot_gigabytes',1,'2026-02-02 15:15:13',NULL),('2026-02-01 15:15:13.192930',NULL,'2026-02-01 15:15:13.246517',288,288,NULL,'372cc799-8422-4b9a-9bef-0f356131ed66',97,'46cbc131a820464a9b6cd0940829aea6','snapshots',1,'2026-02-02 15:15:13','61d66fc8-1151-4700-8fe3-06f0671259ab'),('2026-02-01 15:15:13.194165',NULL,'2026-02-01 15:15:13.246517',289,289,NULL,'146e73be-d393-4999-bd5b-66acaf9ea1d6',98,'46cbc131a820464a9b6cd0940829aea6','snapshot_gigabytes',1,'2026-02-02 15:15:13','61d66fc8-1151-4700-8fe3-06f0671259ab'),('2026-02-01 15:15:13.647270',NULL,'2026-02-01 15:15:13.659504',290,290,'928da2f6147a4b708835fcbebf483d8a','affc90bf-3b5d-4e8a-8b81-7feef3d088cf',66,'8148327cebed4bb49e576111ce3edff1','shares',-1,'2026-02-02 15:15:13',NULL),('2026-02-01 15:15:13.648046',NULL,'2026-02-01 15:15:13.659504',291,291,'928da2f6147a4b708835fcbebf483d8a','b4b3e94a-72a0-4300-89dd-27d421f64157',65,'8148327cebed4bb49e576111ce3edff1','gigabytes',-1,'2026-02-02 15:15:13',NULL),('2026-02-01 15:15:13.652815',NULL,'2026-02-01 15:15:13.659504',292,292,NULL,'e73a9b62-e8bc-43f9-9fcb-35c3900636a8',68,'8148327cebed4bb49e576111ce3edff1','shares',-1,'2026-02-02 15:15:13','71a8cb03-a879-4fa1-9570-d4a2c3127be2'),('2026-02-01 15:15:13.653519',NULL,'2026-02-01 15:15:13.659504',293,293,NULL,'b10b8a3a-c449-44c2-a0df-5ebb6367244b',67,'8148327cebed4bb49e576111ce3edff1','gigabytes',-1,'2026-02-02 15:15:13','71a8cb03-a879-4fa1-9570-d4a2c3127be2'),('2026-02-01 15:15:16.396564',NULL,'2026-02-01 15:15:16.434231',294,294,'2f14b61aac5c41f78a2c8a4963295b65','4c478a33-d4ca-4c0c-b94f-3ffdadf229ca',100,'b60d48ce6ed84a0499e61efc92fe4ff7','shares',1,'2026-02-02 15:15:16',NULL),('2026-02-01 15:15:16.398245',NULL,'2026-02-01 15:15:16.434231',295,295,'2f14b61aac5c41f78a2c8a4963295b65','9f816575-9592-4881-b942-3f7318513e11',99,'b60d48ce6ed84a0499e61efc92fe4ff7','gigabytes',1,'2026-02-02 15:15:16',NULL),('2026-02-01 15:15:16.410153',NULL,'2026-02-01 15:15:16.434231',296,296,NULL,'eebab22f-faad-4efc-add9-5c1221411160',102,'b60d48ce6ed84a0499e61efc92fe4ff7','shares',1,'2026-02-02 15:15:16','70f1e3e3-1df6-4e6a-972a-e4316600cd5d'),('2026-02-01 15:15:16.411919',NULL,'2026-02-01 15:15:16.434231',297,297,NULL,'08fe7f18-719c-4965-b1e2-5a82928753fb',101,'b60d48ce6ed84a0499e61efc92fe4ff7','gigabytes',1,'2026-02-02 15:15:16','70f1e3e3-1df6-4e6a-972a-e4316600cd5d'),('2026-02-01 15:15:17.604360',NULL,'2026-02-01 15:15:17.618835',298,298,'32efe54ffae74acfbb12e72ef8334608','183e9bca-d659-44f6-9c24-70e54a745207',95,'46cbc131a820464a9b6cd0940829aea6','snapshots',-1,'2026-02-02 15:15:17',NULL),('2026-02-01 15:15:17.605184',NULL,'2026-02-01 15:15:17.618835',299,299,'32efe54ffae74acfbb12e72ef8334608','93a9df59-9e09-4bd0-ae7e-ea73ab442146',96,'46cbc131a820464a9b6cd0940829aea6','snapshot_gigabytes',-1,'2026-02-02 15:15:17',NULL),('2026-02-01 15:15:17.610816',NULL,'2026-02-01 15:15:17.618835',300,300,NULL,'8cda3180-d70a-4206-bebe-fdef76f86ea0',97,'46cbc131a820464a9b6cd0940829aea6','snapshots',-1,'2026-02-02 15:15:17','61d66fc8-1151-4700-8fe3-06f0671259ab'),('2026-02-01 15:15:17.611498',NULL,'2026-02-01 15:15:17.618835',301,301,NULL,'d0f0cbee-c64d-482a-9fdc-dea98148d37e',98,'46cbc131a820464a9b6cd0940829aea6','snapshot_gigabytes',-1,'2026-02-02 15:15:17','61d66fc8-1151-4700-8fe3-06f0671259ab'),('2026-02-01 15:15:20.420185',NULL,'2026-02-01 15:15:20.438636',302,302,'2f14b61aac5c41f78a2c8a4963295b65','1761b283-c64b-4eac-b288-f0297eeef161',100,'b60d48ce6ed84a0499e61efc92fe4ff7','shares',-1,'2026-02-02 15:15:20',NULL),('2026-02-01 15:15:20.421095',NULL,'2026-02-01 15:15:20.438636',303,303,'2f14b61aac5c41f78a2c8a4963295b65','874cdbd9-ed6e-4795-a578-672e59a73302',99,'b60d48ce6ed84a0499e61efc92fe4ff7','gigabytes',-1,'2026-02-02 15:15:20',NULL),('2026-02-01 15:15:20.429345',NULL,'2026-02-01 15:15:20.438636',304,304,NULL,'d160c18d-022e-4c59-a147-087077a34644',102,'b60d48ce6ed84a0499e61efc92fe4ff7','shares',-1,'2026-02-02 15:15:20','70f1e3e3-1df6-4e6a-972a-e4316600cd5d'),('2026-02-01 15:15:20.430147',NULL,'2026-02-01 15:15:20.438636',305,305,NULL,'16281597-63b5-4597-9191-042c42bbff6c',101,'b60d48ce6ed84a0499e61efc92fe4ff7','gigabytes',-1,'2026-02-02 15:15:20','70f1e3e3-1df6-4e6a-972a-e4316600cd5d'),('2026-02-01 15:15:21.242161',NULL,'2026-02-01 15:15:21.258543',306,306,'32efe54ffae74acfbb12e72ef8334608','2dd9401a-db99-4945-9f3d-5356af52cb23',88,'46cbc131a820464a9b6cd0940829aea6','shares',-1,'2026-02-02 15:15:21',NULL),('2026-02-01 15:15:21.243353',NULL,'2026-02-01 15:15:21.258543',307,307,'32efe54ffae74acfbb12e72ef8334608','a68847ca-92e5-4638-8b4b-6b05a902283d',87,'46cbc131a820464a9b6cd0940829aea6','gigabytes',-1,'2026-02-02 15:15:21',NULL),('2026-02-01 15:15:21.249635',NULL,'2026-02-01 15:15:21.258543',308,308,NULL,'2b0cb76c-a3ae-4daf-ba7f-1a3e82b64fc9',90,'46cbc131a820464a9b6cd0940829aea6','shares',-1,'2026-02-02 15:15:21','61d66fc8-1151-4700-8fe3-06f0671259ab'),('2026-02-01 15:15:21.250488',NULL,'2026-02-01 15:15:21.258543',309,309,NULL,'e610d110-593f-46e8-bdd1-efdbf036915a',89,'46cbc131a820464a9b6cd0940829aea6','gigabytes',-1,'2026-02-02 15:15:21','61d66fc8-1151-4700-8fe3-06f0671259ab'),('2026-02-01 15:15:24.027641',NULL,'2026-02-01 15:15:24.042248',310,310,'6c83c28e021c4717b45ee6d416ec31f5','627244e2-6269-4486-9e11-4709d69fa544',92,'0dfd4148452647aa845013a982630bb0','shares',-1,'2026-02-02 15:15:24',NULL),('2026-02-01 15:15:24.028473',NULL,'2026-02-01 15:15:24.042248',311,311,'6c83c28e021c4717b45ee6d416ec31f5','0ec56e5c-020b-402b-823d-e181cd5727ca',91,'0dfd4148452647aa845013a982630bb0','gigabytes',-1,'2026-02-02 15:15:24',NULL),('2026-02-01 15:15:24.033754',NULL,'2026-02-01 15:15:24.042248',312,312,NULL,'dc3fe513-2559-4e80-a805-26478ed3a002',94,'0dfd4148452647aa845013a982630bb0','shares',-1,'2026-02-02 15:15:24','70f1e3e3-1df6-4e6a-972a-e4316600cd5d'),('2026-02-01 15:15:24.034524',NULL,'2026-02-01 15:15:24.042248',313,313,NULL,'1d3f2471-887d-4dc9-85ac-05bc1fdde14f',93,'0dfd4148452647aa845013a982630bb0','gigabytes',-1,'2026-02-02 15:15:24','70f1e3e3-1df6-4e6a-972a-e4316600cd5d'),('2026-02-01 15:15:27.400342',NULL,'2026-02-01 15:15:27.441003',314,314,'2f14b61aac5c41f78a2c8a4963295b65','31be1709-760e-4221-af12-1e70550d0b31',100,'b60d48ce6ed84a0499e61efc92fe4ff7','shares',1,'2026-02-02 15:15:27',NULL),('2026-02-01 15:15:27.402367',NULL,'2026-02-01 15:15:27.441003',315,315,'2f14b61aac5c41f78a2c8a4963295b65','1c25978a-1de6-4398-8c11-32cbe15597c1',99,'b60d48ce6ed84a0499e61efc92fe4ff7','gigabytes',1,'2026-02-02 15:15:27',NULL),('2026-02-01 15:15:27.418135',NULL,'2026-02-01 15:15:27.441003',316,316,NULL,'c9bcd4f9-9356-4a0f-b99c-a9e132afde1a',102,'b60d48ce6ed84a0499e61efc92fe4ff7','shares',1,'2026-02-02 15:15:27','70f1e3e3-1df6-4e6a-972a-e4316600cd5d'),('2026-02-01 15:15:27.420133',NULL,'2026-02-01 15:15:27.441003',317,317,NULL,'05d9caa5-3fed-4b3d-b229-b78f9280b967',101,'b60d48ce6ed84a0499e61efc92fe4ff7','gigabytes',1,'2026-02-02 15:15:27','70f1e3e3-1df6-4e6a-972a-e4316600cd5d'),('2026-02-01 15:15:31.883460',NULL,'2026-02-01 15:15:31.898513',318,318,'2f14b61aac5c41f78a2c8a4963295b65','7bdcd4bf-f943-4083-85d4-85effddca64e',100,'b60d48ce6ed84a0499e61efc92fe4ff7','shares',-1,'2026-02-02 15:15:31',NULL),('2026-02-01 15:15:31.885387',NULL,'2026-02-01 15:15:31.898513',319,319,'2f14b61aac5c41f78a2c8a4963295b65','f9e0241a-8c9e-4c45-9f96-7f3f328059ca',99,'b60d48ce6ed84a0499e61efc92fe4ff7','gigabytes',-1,'2026-02-02 15:15:31',NULL),('2026-02-01 15:15:31.890793',NULL,'2026-02-01 15:15:31.898513',320,320,NULL,'a322bf7b-d296-4bfd-9acc-dc5523edace2',102,'b60d48ce6ed84a0499e61efc92fe4ff7','shares',-1,'2026-02-02 15:15:31','70f1e3e3-1df6-4e6a-972a-e4316600cd5d'),('2026-02-01 15:15:31.891573',NULL,'2026-02-01 15:15:31.898513',321,321,NULL,'2cc7994c-2e72-4ed4-a009-21789035ee1b',101,'b60d48ce6ed84a0499e61efc92fe4ff7','gigabytes',-1,'2026-02-02 15:15:31','70f1e3e3-1df6-4e6a-972a-e4316600cd5d'),('2026-02-01 15:15:32.368359',NULL,'2026-02-01 15:15:32.412933',322,322,'6f2dab9328424993aa458427358720d9','d01160dc-7908-4837-a0af-2a75670101ea',104,'32087184504a4aabb8269aa5ef350c60','shares',1,'2026-02-02 15:15:32',NULL),('2026-02-01 15:15:32.369855',NULL,'2026-02-01 15:15:32.412933',323,323,'6f2dab9328424993aa458427358720d9','b2d6db6a-0f5b-495f-82c2-6959f101afe7',103,'32087184504a4aabb8269aa5ef350c60','gigabytes',1,'2026-02-02 15:15:32',NULL),('2026-02-01 15:15:32.383794',NULL,'2026-02-01 15:15:32.412933',324,324,NULL,'b4f752c6-bab7-444d-9f9e-6dc472fb53d5',106,'32087184504a4aabb8269aa5ef350c60','shares',1,'2026-02-02 15:15:32','e40bf1b4-fd26-4fd8-95d0-210613d1d862'),('2026-02-01 15:15:32.385472',NULL,'2026-02-01 15:15:32.412933',325,325,NULL,'c1b91217-358f-4f4f-80be-9f459fd121cb',105,'32087184504a4aabb8269aa5ef350c60','gigabytes',1,'2026-02-02 15:15:32','e40bf1b4-fd26-4fd8-95d0-210613d1d862'),('2026-02-01 15:15:35.199925',NULL,'2026-02-01 15:15:35.244153',326,326,'795592d89a1d46e4a844c4a238d332e3','53a2ebd3-fadd-4e12-b793-3ba91ce47a13',108,'e483891a9fd042d4a571a3d4655dc685','shares',1,'2026-02-02 15:15:35',NULL),('2026-02-01 15:15:35.201630',NULL,'2026-02-01 15:15:35.244153',327,327,'795592d89a1d46e4a844c4a238d332e3','63e24195-f67c-4cdc-87c2-01b5809d973d',107,'e483891a9fd042d4a571a3d4655dc685','gigabytes',1,'2026-02-02 15:15:35',NULL),('2026-02-01 15:15:35.218596',NULL,'2026-02-01 15:15:35.244153',328,328,NULL,'4c97b94f-69ac-43fa-aae0-4a2ce00be455',110,'e483891a9fd042d4a571a3d4655dc685','shares',1,'2026-02-02 15:15:35','847063aa-e54d-49d1-b390-6611881b6691'),('2026-02-01 15:15:35.221706',NULL,'2026-02-01 15:15:35.244153',329,329,NULL,'afa9aca4-85cc-4360-b230-d60f3ca6bcd1',109,'e483891a9fd042d4a571a3d4655dc685','gigabytes',1,'2026-02-02 15:15:35','847063aa-e54d-49d1-b390-6611881b6691'),('2026-02-01 15:15:36.524698',NULL,'2026-02-01 15:15:36.536464',330,330,'6f2dab9328424993aa458427358720d9','9ce81302-9f04-4cd6-87a1-0ca570e7815d',104,'32087184504a4aabb8269aa5ef350c60','shares',-1,'2026-02-02 15:15:36',NULL),('2026-02-01 15:15:36.525353',NULL,'2026-02-01 15:15:36.536464',331,331,'6f2dab9328424993aa458427358720d9','756a0f78-17c8-4bc5-964d-79bf43cc17f8',103,'32087184504a4aabb8269aa5ef350c60','gigabytes',-1,'2026-02-02 15:15:36',NULL),('2026-02-01 15:15:36.529743',NULL,'2026-02-01 15:15:36.536464',332,332,NULL,'b955626d-f895-446a-abd8-7d9c75328e51',106,'32087184504a4aabb8269aa5ef350c60','shares',-1,'2026-02-02 15:15:36','e40bf1b4-fd26-4fd8-95d0-210613d1d862'),('2026-02-01 15:15:36.530335',NULL,'2026-02-01 15:15:36.536464',333,333,NULL,'d80da9f0-8785-43b9-883b-2ceb5dfba98b',105,'32087184504a4aabb8269aa5ef350c60','gigabytes',-1,'2026-02-02 15:15:36','e40bf1b4-fd26-4fd8-95d0-210613d1d862'),('2026-02-01 15:15:36.788002',NULL,'2026-02-01 15:15:36.816080',334,334,'6f2dab9328424993aa458427358720d9','c920887e-7228-47f7-aa2e-5234b4bf891c',104,'32087184504a4aabb8269aa5ef350c60','shares',1,'2026-02-02 15:15:36',NULL),('2026-02-01 15:15:36.789083',NULL,'2026-02-01 15:15:36.816080',335,335,'6f2dab9328424993aa458427358720d9','837524b6-ebae-4778-b73e-db2b9ffa89f6',103,'32087184504a4aabb8269aa5ef350c60','gigabytes',1,'2026-02-02 15:15:36',NULL),('2026-02-01 15:15:36.797171',NULL,'2026-02-01 15:15:36.816080',336,336,NULL,'a72739a3-6d4d-49a3-ae36-dae4c2668d22',112,'32087184504a4aabb8269aa5ef350c60','shares',1,'2026-02-02 15:15:36','d3e4a564-7be4-42a0-848e-6cd396381438'),('2026-02-01 15:15:36.798202',NULL,'2026-02-01 15:15:36.816080',337,337,NULL,'6e89cd5e-907b-4693-b5bd-80556699c757',111,'32087184504a4aabb8269aa5ef350c60','gigabytes',1,'2026-02-02 15:15:36','d3e4a564-7be4-42a0-848e-6cd396381438'),('2026-02-01 15:15:38.991284',NULL,'2026-02-01 15:15:39.031459',338,338,'795592d89a1d46e4a844c4a238d332e3','5c60d85e-e637-4eee-95b0-76cd276ba310',108,'e483891a9fd042d4a571a3d4655dc685','shares',1,'2026-02-02 15:15:38',NULL),('2026-02-01 15:15:38.993075',NULL,'2026-02-01 15:15:39.031459',339,339,'795592d89a1d46e4a844c4a238d332e3','86717bf0-a047-4950-bf90-cd7057309107',107,'e483891a9fd042d4a571a3d4655dc685','gigabytes',1,'2026-02-02 15:15:38',NULL),('2026-02-01 15:15:39.003701',NULL,'2026-02-01 15:15:39.031459',340,340,NULL,'aa893fa2-8fe9-47d8-ad42-effaed9ad680',114,'e483891a9fd042d4a571a3d4655dc685','shares',1,'2026-02-02 15:15:38','29b95f67-19b6-4d0c-881b-ecde5688f59a'),('2026-02-01 15:15:39.004806',NULL,'2026-02-01 15:15:39.031459',341,341,NULL,'2e27d580-7332-4e4f-99e1-f2d61c5c15e0',113,'e483891a9fd042d4a571a3d4655dc685','gigabytes',1,'2026-02-02 15:15:38','29b95f67-19b6-4d0c-881b-ecde5688f59a'),('2026-02-01 15:15:40.494669',NULL,'2026-02-01 15:15:40.511273',342,342,'6f2dab9328424993aa458427358720d9','67fca580-270b-4028-be14-bc3dcc03c43b',104,'32087184504a4aabb8269aa5ef350c60','shares',-1,'2026-02-02 15:15:40',NULL),('2026-02-01 15:15:40.495651',NULL,'2026-02-01 15:15:40.511273',343,343,'6f2dab9328424993aa458427358720d9','af566967-624d-495e-8310-c760d83b26fe',103,'32087184504a4aabb8269aa5ef350c60','gigabytes',-1,'2026-02-02 15:15:40',NULL),('2026-02-01 15:15:40.504146',NULL,'2026-02-01 15:15:40.511273',344,344,NULL,'cc115550-1a47-4e1b-bb4c-e8cf3aa80275',112,'32087184504a4aabb8269aa5ef350c60','shares',-1,'2026-02-02 15:15:40','d3e4a564-7be4-42a0-848e-6cd396381438'),('2026-02-01 15:15:40.504921',NULL,'2026-02-01 15:15:40.511273',345,345,NULL,'61852be5-6d47-48d9-b773-d7351d1f6712',111,'32087184504a4aabb8269aa5ef350c60','gigabytes',-1,'2026-02-02 15:15:40','d3e4a564-7be4-42a0-848e-6cd396381438'),('2026-02-01 15:15:40.684128',NULL,'2026-02-01 15:15:40.724936',346,346,'6f2dab9328424993aa458427358720d9','fa7463cf-93c8-4a84-ac65-def144abadf8',104,'32087184504a4aabb8269aa5ef350c60','shares',1,'2026-02-02 15:15:40',NULL),('2026-02-01 15:15:40.686103',NULL,'2026-02-01 15:15:40.724936',347,347,'6f2dab9328424993aa458427358720d9','d87c24e2-bd89-4390-a3f9-1b4c5e13a518',103,'32087184504a4aabb8269aa5ef350c60','gigabytes',1,'2026-02-02 15:15:40',NULL),('2026-02-01 15:15:40.701704',NULL,'2026-02-01 15:15:40.724936',348,348,NULL,'c4bdb8f3-27f3-478e-b0df-a439e3a1126c',116,'32087184504a4aabb8269aa5ef350c60','shares',1,'2026-02-02 15:15:40','d3a796c1-974d-4d4f-86d6-31e24af5bf80'),('2026-02-01 15:15:40.703397',NULL,'2026-02-01 15:15:40.724936',349,349,NULL,'bc8f0b4a-9d05-4ea1-92ab-a8e1b4e49f79',115,'32087184504a4aabb8269aa5ef350c60','gigabytes',1,'2026-02-02 15:15:40','d3a796c1-974d-4d4f-86d6-31e24af5bf80'),('2026-02-01 15:15:43.080040',NULL,'2026-02-01 15:15:43.115646',350,350,'e9e626045c924c8c981ad3f67a1dedd6','9a8804a1-84c4-4817-9d36-81894c857b28',118,'f99925486e924480b84b05e1433af949','shares',1,'2026-02-02 15:15:43',NULL),('2026-02-01 15:15:43.081448',NULL,'2026-02-01 15:15:43.115646',351,351,'e9e626045c924c8c981ad3f67a1dedd6','3dd8f50e-6e20-4a4e-9b60-399f29f4f13f',117,'f99925486e924480b84b05e1433af949','gigabytes',1,'2026-02-02 15:15:43',NULL),('2026-02-01 15:15:43.091678',NULL,'2026-02-01 15:15:43.115646',352,352,NULL,'c6da7193-004d-42ff-88fb-cf5c1cea7a9a',120,'f99925486e924480b84b05e1433af949','shares',1,'2026-02-02 15:15:43','a811e5d0-f6d5-4017-bb5f-544fc27e7e76'),('2026-02-01 15:15:43.092680',NULL,'2026-02-01 15:15:43.115646',353,353,NULL,'158091ed-b319-4547-b73c-bc0467b011a2',119,'f99925486e924480b84b05e1433af949','gigabytes',1,'2026-02-02 15:15:43','a811e5d0-f6d5-4017-bb5f-544fc27e7e76'),('2026-02-01 15:15:44.404278',NULL,'2026-02-01 15:15:44.461111',354,354,'6f2dab9328424993aa458427358720d9','55b7e75f-c606-44c1-8bd5-fd49c40ab52d',104,'32087184504a4aabb8269aa5ef350c60','shares',1,'2026-02-02 15:15:44',NULL),('2026-02-01 15:15:44.407064',NULL,'2026-02-01 15:15:44.461111',355,355,'6f2dab9328424993aa458427358720d9','3a96a484-1945-4b9b-a7b6-fd7c7f233d24',103,'32087184504a4aabb8269aa5ef350c60','gigabytes',1,'2026-02-02 15:15:44',NULL),('2026-02-01 15:15:44.424589',NULL,'2026-02-01 15:15:44.461111',356,356,NULL,'66037b06-ebe4-4383-951c-906dff188237',122,'32087184504a4aabb8269aa5ef350c60','shares',1,'2026-02-02 15:15:44','275a2dc4-58d1-4887-a5f2-1450bb6710b6'),('2026-02-01 15:15:44.426864',NULL,'2026-02-01 15:15:44.461111',357,357,NULL,'0e40344a-11d1-4cb7-ad6d-f50cd5a7ce0a',121,'32087184504a4aabb8269aa5ef350c60','gigabytes',1,'2026-02-02 15:15:44','275a2dc4-58d1-4887-a5f2-1450bb6710b6'),('2026-02-01 15:15:45.918627',NULL,'2026-02-01 15:15:45.953257',358,358,'e513aa3b998a4d7c9d1e07492d61bda1','cd9ed901-41df-485e-a324-3a264ac239c4',124,'2731ddbed05046f3bee55c8f307163b2','shares',1,'2026-02-02 15:15:45',NULL),('2026-02-01 15:15:45.919711',NULL,'2026-02-01 15:15:45.953257',359,359,'e513aa3b998a4d7c9d1e07492d61bda1','4179fa4e-7ed5-4d62-a7f4-cb0719f791fb',123,'2731ddbed05046f3bee55c8f307163b2','gigabytes',1,'2026-02-02 15:15:45',NULL),('2026-02-01 15:15:45.929366',NULL,'2026-02-01 15:15:45.953257',360,360,NULL,'c4b32c1c-7b7b-4e1a-9355-6d1711134ed8',126,'2731ddbed05046f3bee55c8f307163b2','shares',1,'2026-02-02 15:15:45','29b95f67-19b6-4d0c-881b-ecde5688f59a'),('2026-02-01 15:15:45.930548',NULL,'2026-02-01 15:15:45.953257',361,361,NULL,'bfa17cdf-46c6-43ee-86a3-b6406fab6619',125,'2731ddbed05046f3bee55c8f307163b2','gigabytes',1,'2026-02-02 15:15:45','29b95f67-19b6-4d0c-881b-ecde5688f59a'),('2026-02-01 15:15:47.253465',NULL,'2026-02-01 15:15:47.280003',362,362,'e9e626045c924c8c981ad3f67a1dedd6','6938c5b0-a4e6-40bb-8b8f-4a5605426a0e',118,'f99925486e924480b84b05e1433af949','shares',1,'2026-02-02 15:15:47',NULL),('2026-02-01 15:15:47.254850',NULL,'2026-02-01 15:15:47.280003',363,363,'e9e626045c924c8c981ad3f67a1dedd6','ccc55e6c-2e8b-4f89-b171-7d7a76fddf52',117,'f99925486e924480b84b05e1433af949','gigabytes',1,'2026-02-02 15:15:47',NULL),('2026-02-01 15:15:47.261242',NULL,'2026-02-01 15:15:47.280003',364,364,NULL,'4b4b9c59-ef8f-4ac8-82d9-6ae731d296f0',120,'f99925486e924480b84b05e1433af949','shares',1,'2026-02-02 15:15:47','a811e5d0-f6d5-4017-bb5f-544fc27e7e76'),('2026-02-01 15:15:47.262339',NULL,'2026-02-01 15:15:47.280003',365,365,NULL,'26884294-7bc6-4c0d-984a-2e6eaa02fdcf',119,'f99925486e924480b84b05e1433af949','gigabytes',1,'2026-02-02 15:15:47','a811e5d0-f6d5-4017-bb5f-544fc27e7e76'),('2026-02-01 15:15:48.110668',NULL,'2026-02-01 15:15:48.127366',366,366,'6f2dab9328424993aa458427358720d9','ff5ee61f-8515-4092-948f-d02186804867',104,'32087184504a4aabb8269aa5ef350c60','shares',-1,'2026-02-02 15:15:48',NULL),('2026-02-01 15:15:48.111496',NULL,'2026-02-01 15:15:48.127366',367,367,'6f2dab9328424993aa458427358720d9','2dfc7eb4-f859-4dae-afd0-d05a9ebcb2ef',103,'32087184504a4aabb8269aa5ef350c60','gigabytes',-1,'2026-02-02 15:15:48',NULL),('2026-02-01 15:15:48.117056',NULL,'2026-02-01 15:15:48.127366',368,368,NULL,'a845b54b-f3e8-4c21-8394-9e0af1cd6f39',122,'32087184504a4aabb8269aa5ef350c60','shares',-1,'2026-02-02 15:15:48','275a2dc4-58d1-4887-a5f2-1450bb6710b6'),('2026-02-01 15:15:48.117939',NULL,'2026-02-01 15:15:48.127366',369,369,NULL,'aca2cac4-0c70-4caf-81db-5bb0b2c148ae',121,'32087184504a4aabb8269aa5ef350c60','gigabytes',-1,'2026-02-02 15:15:48','275a2dc4-58d1-4887-a5f2-1450bb6710b6'),('2026-02-01 15:15:48.417142',NULL,'2026-02-01 15:15:48.429389',370,370,'6f2dab9328424993aa458427358720d9','22416968-f9f5-465a-99c0-ce01b09dcd37',104,'32087184504a4aabb8269aa5ef350c60','shares',-1,'2026-02-02 15:15:48',NULL),('2026-02-01 15:15:48.417836',NULL,'2026-02-01 15:15:48.429389',371,371,'6f2dab9328424993aa458427358720d9','b9979ffd-6dd1-4075-8e66-e9e831b1eb2e',103,'32087184504a4aabb8269aa5ef350c60','gigabytes',-1,'2026-02-02 15:15:48',NULL),('2026-02-01 15:15:48.422495',NULL,'2026-02-01 15:15:48.429389',372,372,NULL,'a739e596-bd0b-4b5c-b9be-a9606fd5a732',116,'32087184504a4aabb8269aa5ef350c60','shares',-1,'2026-02-02 15:15:48','d3a796c1-974d-4d4f-86d6-31e24af5bf80'),('2026-02-01 15:15:48.423091',NULL,'2026-02-01 15:15:48.429389',373,373,NULL,'27ee4b06-463b-4ef6-9cfb-4ff6caa8080a',115,'32087184504a4aabb8269aa5ef350c60','gigabytes',-1,'2026-02-02 15:15:48','d3a796c1-974d-4d4f-86d6-31e24af5bf80'),('2026-02-01 15:15:48.678398',NULL,'2026-02-01 15:15:48.715410',374,374,'6f2dab9328424993aa458427358720d9','9bcc97b1-9dcb-4d59-8d5b-140ff170c845',104,'32087184504a4aabb8269aa5ef350c60','shares',1,'2026-02-02 15:15:48',NULL),('2026-02-01 15:15:48.681215',NULL,'2026-02-01 15:15:48.715410',375,375,'6f2dab9328424993aa458427358720d9','15d57a64-a4b4-4d0f-9f28-7d054b527e89',103,'32087184504a4aabb8269aa5ef350c60','gigabytes',1,'2026-02-02 15:15:48',NULL),('2026-02-01 15:15:48.692752',NULL,'2026-02-01 15:15:48.715410',376,376,NULL,'3797dd72-97ed-4f0d-813a-7044303662a1',128,'32087184504a4aabb8269aa5ef350c60','shares',1,'2026-02-02 15:15:48','d66ef10c-1a48-4389-a804-c7ab5e8f314d'),('2026-02-01 15:15:48.694328',NULL,'2026-02-01 15:15:48.715410',377,377,NULL,'a361c7d8-801d-4e5c-a2ba-c6d965b5a7a2',127,'32087184504a4aabb8269aa5ef350c60','gigabytes',1,'2026-02-02 15:15:48','d66ef10c-1a48-4389-a804-c7ab5e8f314d'),('2026-02-01 15:15:48.899208',NULL,'2026-02-01 15:15:48.955366',378,378,'c768e3f3500c4bf19dcf4fcf64856998','49f2cd2e-a79c-416e-ae43-0ccccb2bcd99',130,'0d63dabe67144e93ab3137e7893f5f60','shares',1,'2026-02-02 15:15:48',NULL),('2026-02-01 15:15:48.901479',NULL,'2026-02-01 15:15:48.955366',379,379,'c768e3f3500c4bf19dcf4fcf64856998','95821084-25fa-4b90-a682-3c2a51f289a3',129,'0d63dabe67144e93ab3137e7893f5f60','gigabytes',1,'2026-02-02 15:15:48',NULL),('2026-02-01 15:15:48.920172',NULL,'2026-02-01 15:15:48.955366',380,380,NULL,'5b2a01ce-2544-4c01-9fad-96e532dce29b',132,'0d63dabe67144e93ab3137e7893f5f60','shares',1,'2026-02-02 15:15:48','120a16ad-b887-4c32-bd69-d344d97a4eee'),('2026-02-01 15:15:48.922460',NULL,'2026-02-01 15:15:48.955366',381,381,NULL,'606112a0-5a3e-4b1a-8f58-0575c107baeb',131,'0d63dabe67144e93ab3137e7893f5f60','gigabytes',1,'2026-02-02 15:15:48','120a16ad-b887-4c32-bd69-d344d97a4eee'),('2026-02-01 15:15:52.055060',NULL,'2026-02-01 15:15:52.081343',382,382,'6f2dab9328424993aa458427358720d9','2e7a5157-97ae-476b-88ba-f6522caedebf',104,'32087184504a4aabb8269aa5ef350c60','shares',1,'2026-02-02 15:15:52',NULL),('2026-02-01 15:15:52.056194',NULL,'2026-02-01 15:15:52.081343',383,383,'6f2dab9328424993aa458427358720d9','6465b823-b0f8-437f-b2f3-f5902c42aee5',103,'32087184504a4aabb8269aa5ef350c60','gigabytes',1,'2026-02-02 15:15:52',NULL),('2026-02-01 15:15:52.064588',NULL,'2026-02-01 15:15:52.081343',384,384,NULL,'aa0b8273-7659-4054-8dfa-44ef286b31f0',134,'32087184504a4aabb8269aa5ef350c60','shares',1,'2026-02-02 15:15:52','45a106aa-92ee-46aa-8dbd-e51e979b3fbb'),('2026-02-01 15:15:52.065519',NULL,'2026-02-01 15:15:52.081343',385,385,NULL,'17783d05-6ae0-4470-9b4d-8f80a51cae12',133,'32087184504a4aabb8269aa5ef350c60','gigabytes',1,'2026-02-02 15:15:52','45a106aa-92ee-46aa-8dbd-e51e979b3fbb'),('2026-02-01 15:15:52.262414',NULL,'2026-02-01 15:15:52.326504',386,386,'c768e3f3500c4bf19dcf4fcf64856998','45d8ebec-cd5d-42a8-aa52-d79dcee2333f',135,'0d63dabe67144e93ab3137e7893f5f60','snapshots',1,'2026-02-02 15:15:52',NULL),('2026-02-01 15:15:52.264438',NULL,'2026-02-01 15:15:52.326504',387,387,'c768e3f3500c4bf19dcf4fcf64856998','0f8bec54-061d-4b55-948f-a10a42777d10',136,'0d63dabe67144e93ab3137e7893f5f60','snapshot_gigabytes',1,'2026-02-02 15:15:52',NULL),('2026-02-01 15:15:52.272531',NULL,'2026-02-01 15:15:52.326504',388,388,NULL,'b61dfb81-d16e-4acc-b7d6-0046af69e087',137,'0d63dabe67144e93ab3137e7893f5f60','snapshots',1,'2026-02-02 15:15:52','120a16ad-b887-4c32-bd69-d344d97a4eee'),('2026-02-01 15:15:52.273454',NULL,'2026-02-01 15:15:52.326504',389,389,NULL,'23b4674f-3da8-4a42-a7e3-266d2ea46b9d',138,'0d63dabe67144e93ab3137e7893f5f60','snapshot_gigabytes',1,'2026-02-02 15:15:52','120a16ad-b887-4c32-bd69-d344d97a4eee'),('2026-02-01 15:15:54.839588',NULL,'2026-02-01 15:15:54.857457',390,390,'e9e626045c924c8c981ad3f67a1dedd6','6be20b61-9f77-4652-a55e-58ed072c72b0',118,'f99925486e924480b84b05e1433af949','shares',-1,'2026-02-02 15:15:54',NULL),('2026-02-01 15:15:54.840301',NULL,'2026-02-01 15:15:54.857457',391,391,'e9e626045c924c8c981ad3f67a1dedd6','2a4590ab-6b82-4af1-8be7-65e477a19907',117,'f99925486e924480b84b05e1433af949','gigabytes',-1,'2026-02-02 15:15:54',NULL),('2026-02-01 15:15:54.845243',NULL,'2026-02-01 15:15:54.857457',392,392,NULL,'ed5ec65b-4e62-4087-98e2-a0056df7e4b1',120,'f99925486e924480b84b05e1433af949','shares',-1,'2026-02-02 15:15:54','a811e5d0-f6d5-4017-bb5f-544fc27e7e76'),('2026-02-01 15:15:54.847548',NULL,'2026-02-01 15:15:54.857457',393,393,NULL,'40545d61-8da5-4d82-8490-c2531615dc01',119,'f99925486e924480b84b05e1433af949','gigabytes',-1,'2026-02-02 15:15:54','a811e5d0-f6d5-4017-bb5f-544fc27e7e76'),('2026-02-01 15:15:55.414479',NULL,'2026-02-01 15:15:55.453925',394,394,'6f2dab9328424993aa458427358720d9','dca0c75b-0c44-480c-86f3-7ee15a4c6dfc',104,'32087184504a4aabb8269aa5ef350c60','shares',1,'2026-02-02 15:15:55',NULL),('2026-02-01 15:15:55.415959',NULL,'2026-02-01 15:15:55.453925',395,395,'6f2dab9328424993aa458427358720d9','870ce9fa-be2a-4f41-9973-a68d1ee866e6',103,'32087184504a4aabb8269aa5ef350c60','gigabytes',1,'2026-02-02 15:15:55',NULL),('2026-02-01 15:15:55.426512',NULL,'2026-02-01 15:15:55.453925',396,396,NULL,'ef0cf17d-7deb-4ee7-a3b5-0804909074f7',140,'32087184504a4aabb8269aa5ef350c60','shares',1,'2026-02-02 15:15:55','07adc9ef-2272-4b23-ba8b-3bc6ea05d153'),('2026-02-01 15:15:55.427804',NULL,'2026-02-01 15:15:55.453925',397,397,NULL,'8a2973c8-a63f-4710-be12-279ca620c3d9',139,'32087184504a4aabb8269aa5ef350c60','gigabytes',1,'2026-02-02 15:15:55','07adc9ef-2272-4b23-ba8b-3bc6ea05d153'),('2026-02-01 15:15:55.719480',NULL,'2026-02-01 15:15:55.755865',398,398,'c768e3f3500c4bf19dcf4fcf64856998','e8127352-5225-400f-8f00-9ba881928b4f',130,'0d63dabe67144e93ab3137e7893f5f60','shares',1,'2026-02-02 15:15:55',NULL),('2026-02-01 15:15:55.722532',NULL,'2026-02-01 15:15:55.755865',399,399,'c768e3f3500c4bf19dcf4fcf64856998','8a529a71-8ee9-4dad-8a7c-07050eb5954f',129,'0d63dabe67144e93ab3137e7893f5f60','gigabytes',1,'2026-02-02 15:15:55',NULL),('2026-02-01 15:15:55.727507',NULL,'2026-02-01 15:15:55.755865',400,400,NULL,'94ce14dd-86e2-4251-ad36-282d408abfbf',132,'0d63dabe67144e93ab3137e7893f5f60','shares',1,'2026-02-02 15:15:55','120a16ad-b887-4c32-bd69-d344d97a4eee'),('2026-02-01 15:15:55.728555',NULL,'2026-02-01 15:15:55.755865',401,401,NULL,'79af7d10-fdf3-4452-ae26-cf58038c0590',131,'0d63dabe67144e93ab3137e7893f5f60','gigabytes',1,'2026-02-02 15:15:55','120a16ad-b887-4c32-bd69-d344d97a4eee'),('2026-02-01 15:15:57.560618',NULL,'2026-02-01 15:15:57.610894',402,402,'e9e626045c924c8c981ad3f67a1dedd6','0e7d40a4-b4b4-448a-a2d7-105ea044c179',118,'f99925486e924480b84b05e1433af949','shares',1,'2026-02-02 15:15:57',NULL),('2026-02-01 15:15:57.562112',NULL,'2026-02-01 15:15:57.610894',403,403,'e9e626045c924c8c981ad3f67a1dedd6','ba34e566-9bdf-4c0d-bb3b-020052cd3ed2',117,'f99925486e924480b84b05e1433af949','gigabytes',1,'2026-02-02 15:15:57',NULL),('2026-02-01 15:15:57.569330',NULL,'2026-02-01 15:15:57.610894',404,404,NULL,'d380dd3a-ff3c-428b-bfb5-6d0c46446c0d',120,'f99925486e924480b84b05e1433af949','shares',1,'2026-02-02 15:15:57','a811e5d0-f6d5-4017-bb5f-544fc27e7e76'),('2026-02-01 15:15:57.571009',NULL,'2026-02-01 15:15:57.610894',405,405,NULL,'91c7f1d2-e03c-4100-8bcc-7ed3178a8dac',119,'f99925486e924480b84b05e1433af949','gigabytes',1,'2026-02-02 15:15:57','a811e5d0-f6d5-4017-bb5f-544fc27e7e76'),('2026-02-01 15:15:59.033716',NULL,'2026-02-01 15:15:59.052272',406,406,'6f2dab9328424993aa458427358720d9','877ed4f9-4554-494e-a710-414384daf76e',104,'32087184504a4aabb8269aa5ef350c60','shares',-1,'2026-02-02 15:15:59',NULL),('2026-02-01 15:15:59.035175',NULL,'2026-02-01 15:15:59.052272',407,407,'6f2dab9328424993aa458427358720d9','859e107a-db41-4057-a148-ac6d1a8763e9',103,'32087184504a4aabb8269aa5ef350c60','gigabytes',-1,'2026-02-02 15:15:59',NULL),('2026-02-01 15:15:59.041143',NULL,'2026-02-01 15:15:59.052272',408,408,NULL,'ebb8609c-f4ec-4062-bfa9-cfa9fc4fbdb0',140,'32087184504a4aabb8269aa5ef350c60','shares',-1,'2026-02-02 15:15:59','07adc9ef-2272-4b23-ba8b-3bc6ea05d153'),('2026-02-01 15:15:59.042358',NULL,'2026-02-01 15:15:59.052272',409,409,NULL,'daf88cb2-dd4e-431d-be3d-a113443763e2',139,'32087184504a4aabb8269aa5ef350c60','gigabytes',-1,'2026-02-02 15:15:59','07adc9ef-2272-4b23-ba8b-3bc6ea05d153'),('2026-02-01 15:15:59.355004',NULL,'2026-02-01 15:15:59.376187',410,410,'6f2dab9328424993aa458427358720d9','40dd0101-1b6a-440c-847e-ee91f58f3d29',104,'32087184504a4aabb8269aa5ef350c60','shares',-1,'2026-02-02 15:15:59',NULL),('2026-02-01 15:15:59.357434',NULL,'2026-02-01 15:15:59.376187',411,411,'6f2dab9328424993aa458427358720d9','492f4b67-041e-42f1-9376-0c53e89d27d8',103,'32087184504a4aabb8269aa5ef350c60','gigabytes',-1,'2026-02-02 15:15:59',NULL),('2026-02-01 15:15:59.365094',NULL,'2026-02-01 15:15:59.376187',412,412,NULL,'ea1b84fd-3a19-4de1-94a2-db918ba7e7a7',134,'32087184504a4aabb8269aa5ef350c60','shares',-1,'2026-02-02 15:15:59','45a106aa-92ee-46aa-8dbd-e51e979b3fbb'),('2026-02-01 15:15:59.366271',NULL,'2026-02-01 15:15:59.376187',413,413,NULL,'a3e178c1-9533-4290-8072-67ebdeff6c80',133,'32087184504a4aabb8269aa5ef350c60','gigabytes',-1,'2026-02-02 15:15:59','45a106aa-92ee-46aa-8dbd-e51e979b3fbb'),('2026-02-01 15:15:59.604078',NULL,'2026-02-01 15:15:59.618334',414,414,'6f2dab9328424993aa458427358720d9','52cae2be-d19d-4bba-9be7-b649da9f386c',104,'32087184504a4aabb8269aa5ef350c60','shares',-1,'2026-02-02 15:15:59',NULL),('2026-02-01 15:15:59.604751',NULL,'2026-02-01 15:15:59.618334',415,415,'6f2dab9328424993aa458427358720d9','a7c33bf8-4fae-46ed-b19f-75cec67d4a7e',103,'32087184504a4aabb8269aa5ef350c60','gigabytes',-1,'2026-02-02 15:15:59',NULL),('2026-02-01 15:15:59.610161',NULL,'2026-02-01 15:15:59.618334',416,416,NULL,'957aa9d0-60cf-43d1-9298-6b8415720fca',128,'32087184504a4aabb8269aa5ef350c60','shares',-1,'2026-02-02 15:15:59','d66ef10c-1a48-4389-a804-c7ab5e8f314d'),('2026-02-01 15:15:59.611047',NULL,'2026-02-01 15:15:59.618334',417,417,NULL,'f386f7fb-2fe0-447f-8556-ce0bc1917a67',127,'32087184504a4aabb8269aa5ef350c60','gigabytes',-1,'2026-02-02 15:15:59','d66ef10c-1a48-4389-a804-c7ab5e8f314d'),('2026-02-01 15:15:59.812163',NULL,'2026-02-01 15:15:59.842083',418,418,'6f2dab9328424993aa458427358720d9','bc7c5a39-c12f-4786-8636-228a4c8f6bf0',104,'32087184504a4aabb8269aa5ef350c60','shares',1,'2026-02-02 15:15:59',NULL),('2026-02-01 15:15:59.813243',NULL,'2026-02-01 15:15:59.842083',419,419,'6f2dab9328424993aa458427358720d9','2080d6a3-c3d8-41d5-8698-3ca0d0f428ac',103,'32087184504a4aabb8269aa5ef350c60','gigabytes',1,'2026-02-02 15:15:59',NULL),('2026-02-01 15:15:59.822029',NULL,'2026-02-01 15:15:59.842083',420,420,NULL,'9d63e7bb-7e64-4037-ac79-4a43b89600fd',142,'32087184504a4aabb8269aa5ef350c60','shares',1,'2026-02-02 15:15:59','64010b88-05ad-4c28-a92b-293b13eb246e'),('2026-02-01 15:15:59.823034',NULL,'2026-02-01 15:15:59.842083',421,421,NULL,'9c850b39-3866-4cf7-9a4a-e6d7b5546125',141,'32087184504a4aabb8269aa5ef350c60','gigabytes',1,'2026-02-02 15:15:59','64010b88-05ad-4c28-a92b-293b13eb246e'),('2026-02-01 15:16:03.334604',NULL,'2026-02-01 15:16:03.363857',422,422,'6f2dab9328424993aa458427358720d9','50e511c1-57d4-492e-ad8f-98446688513f',104,'32087184504a4aabb8269aa5ef350c60','shares',1,'2026-02-02 15:16:03',NULL),('2026-02-01 15:16:03.335739',NULL,'2026-02-01 15:16:03.363857',423,423,'6f2dab9328424993aa458427358720d9','0d2a1fe4-d2bf-460b-a690-1f59859b1d45',103,'32087184504a4aabb8269aa5ef350c60','gigabytes',1,'2026-02-02 15:16:03',NULL),('2026-02-01 15:16:03.345266',NULL,'2026-02-01 15:16:03.363857',424,424,NULL,'79cda793-146f-49c3-9906-d91b5de27eb2',144,'32087184504a4aabb8269aa5ef350c60','shares',1,'2026-02-02 15:16:03','bb53296f-97b7-42cf-8d24-8b3c547491c9'),('2026-02-01 15:16:03.346367',NULL,'2026-02-01 15:16:03.363857',425,425,NULL,'3ea7ee5a-c8bd-4027-97fc-0b186b988fdc',143,'32087184504a4aabb8269aa5ef350c60','gigabytes',1,'2026-02-02 15:16:03','bb53296f-97b7-42cf-8d24-8b3c547491c9'),('2026-02-01 15:16:04.980022',NULL,'2026-02-01 15:16:04.995327',426,426,'e9e626045c924c8c981ad3f67a1dedd6','17ab4e52-6d0e-4bf4-9c63-991e62088e07',118,'f99925486e924480b84b05e1433af949','shares',-1,'2026-02-02 15:16:04',NULL),('2026-02-01 15:16:04.981037',NULL,'2026-02-01 15:16:04.995327',427,427,'e9e626045c924c8c981ad3f67a1dedd6','808b36b5-13b5-421a-a314-2c94f1984744',117,'f99925486e924480b84b05e1433af949','gigabytes',-1,'2026-02-02 15:16:04',NULL),('2026-02-01 15:16:04.988114',NULL,'2026-02-01 15:16:04.995327',428,428,NULL,'7f77b461-4598-484c-a48b-150bc5c497a4',120,'f99925486e924480b84b05e1433af949','shares',-1,'2026-02-02 15:16:04','a811e5d0-f6d5-4017-bb5f-544fc27e7e76'),('2026-02-01 15:16:04.988795',NULL,'2026-02-01 15:16:04.995327',429,429,NULL,'784794f0-c07f-4a1a-b847-005fe790569e',119,'f99925486e924480b84b05e1433af949','gigabytes',-1,'2026-02-02 15:16:04','a811e5d0-f6d5-4017-bb5f-544fc27e7e76'),('2026-02-01 15:16:05.821076',NULL,'2026-02-01 15:16:05.835613',430,430,'c768e3f3500c4bf19dcf4fcf64856998','8ad5fa15-7987-4e50-954e-0fcc510edc58',130,'0d63dabe67144e93ab3137e7893f5f60','shares',-1,'2026-02-02 15:16:05',NULL),('2026-02-01 15:16:05.821924',NULL,'2026-02-01 15:16:05.835613',431,431,'c768e3f3500c4bf19dcf4fcf64856998','ecfb5fff-1f3a-455b-9807-84b70b0421f4',129,'0d63dabe67144e93ab3137e7893f5f60','gigabytes',-1,'2026-02-02 15:16:05',NULL),('2026-02-01 15:16:05.827859',NULL,'2026-02-01 15:16:05.835613',432,432,NULL,'014af72f-b928-4da3-934b-8c53fe5ebb5c',132,'0d63dabe67144e93ab3137e7893f5f60','shares',-1,'2026-02-02 15:16:05','120a16ad-b887-4c32-bd69-d344d97a4eee'),('2026-02-01 15:16:05.828532',NULL,'2026-02-01 15:16:05.835613',433,433,NULL,'b5c55d8f-3eaa-4e25-a2a8-72903fa18447',131,'0d63dabe67144e93ab3137e7893f5f60','gigabytes',-1,'2026-02-02 15:16:05','120a16ad-b887-4c32-bd69-d344d97a4eee'),('2026-02-01 15:16:07.162271',NULL,'2026-02-01 15:16:07.179519',434,434,'6f2dab9328424993aa458427358720d9','add2b218-ba3c-409f-a51e-a936ddacf26d',104,'32087184504a4aabb8269aa5ef350c60','shares',-1,'2026-02-02 15:16:07',NULL),('2026-02-01 15:16:07.163298',NULL,'2026-02-01 15:16:07.179519',435,435,'6f2dab9328424993aa458427358720d9','99208f3a-acaa-4d08-86e8-78959848650b',103,'32087184504a4aabb8269aa5ef350c60','gigabytes',-1,'2026-02-02 15:16:07',NULL),('2026-02-01 15:16:07.171334',NULL,'2026-02-01 15:16:07.179519',436,436,NULL,'e561570e-e699-4c67-96e1-eb5e920c7908',144,'32087184504a4aabb8269aa5ef350c60','shares',-1,'2026-02-02 15:16:07','bb53296f-97b7-42cf-8d24-8b3c547491c9'),('2026-02-01 15:16:07.172084',NULL,'2026-02-01 15:16:07.179519',437,437,NULL,'512719a0-9a06-4f7e-814d-ea628297b419',143,'32087184504a4aabb8269aa5ef350c60','gigabytes',-1,'2026-02-02 15:16:07','bb53296f-97b7-42cf-8d24-8b3c547491c9'),('2026-02-01 15:16:07.490444',NULL,'2026-02-01 15:16:07.506862',438,438,'6f2dab9328424993aa458427358720d9','f1c5d7a3-af7a-49e5-9f36-56e922528e67',104,'32087184504a4aabb8269aa5ef350c60','shares',-1,'2026-02-02 15:16:07',NULL),('2026-02-01 15:16:07.491529',NULL,'2026-02-01 15:16:07.506862',439,439,'6f2dab9328424993aa458427358720d9','5444bc8a-67f1-4bda-8f72-c564cd257d37',103,'32087184504a4aabb8269aa5ef350c60','gigabytes',-1,'2026-02-02 15:16:07',NULL),('2026-02-01 15:16:07.497286',NULL,'2026-02-01 15:16:07.506862',440,440,NULL,'f31e3757-1b4e-4909-8c38-60b004cfb7a0',142,'32087184504a4aabb8269aa5ef350c60','shares',-1,'2026-02-02 15:16:07','64010b88-05ad-4c28-a92b-293b13eb246e'),('2026-02-01 15:16:07.498430',NULL,'2026-02-01 15:16:07.506862',441,441,NULL,'28f84b3f-6165-445a-b14e-71f05c1bf392',141,'32087184504a4aabb8269aa5ef350c60','gigabytes',-1,'2026-02-02 15:16:07','64010b88-05ad-4c28-a92b-293b13eb246e'),('2026-02-01 15:16:07.735957',NULL,'2026-02-01 15:16:07.768772',442,442,'6f2dab9328424993aa458427358720d9','eab1496a-16a7-44ae-9b40-3e2877e99ac2',104,'32087184504a4aabb8269aa5ef350c60','shares',1,'2026-02-02 15:16:07',NULL),('2026-02-01 15:16:07.737556',NULL,'2026-02-01 15:16:07.768772',443,443,'6f2dab9328424993aa458427358720d9','61ea7ac0-d5ba-470c-a8e3-68a109701bc9',103,'32087184504a4aabb8269aa5ef350c60','gigabytes',1,'2026-02-02 15:16:07',NULL),('2026-02-01 15:16:07.746220',NULL,'2026-02-01 15:16:07.768772',444,444,NULL,'986111af-0b7c-4975-ba19-b4193638de59',146,'32087184504a4aabb8269aa5ef350c60','shares',1,'2026-02-02 15:16:07','5334ac45-44fc-49d0-95bb-7c266db24118'),('2026-02-01 15:16:07.747216',NULL,'2026-02-01 15:16:07.768772',445,445,NULL,'ce10d75b-d840-47a9-9e87-1215cff76860',145,'32087184504a4aabb8269aa5ef350c60','gigabytes',1,'2026-02-02 15:16:07','5334ac45-44fc-49d0-95bb-7c266db24118'),('2026-02-01 15:16:07.798735',NULL,'2026-02-01 15:16:07.833288',446,446,'e9e626045c924c8c981ad3f67a1dedd6','1cbc24b9-8463-4152-910b-56507d5c6017',118,'f99925486e924480b84b05e1433af949','shares',1,'2026-02-02 15:16:07',NULL),('2026-02-01 15:16:07.800104',NULL,'2026-02-01 15:16:07.833288',447,447,'e9e626045c924c8c981ad3f67a1dedd6','d5a83590-929b-4c5a-adf0-b74ffb56d439',117,'f99925486e924480b84b05e1433af949','gigabytes',1,'2026-02-02 15:16:07',NULL),('2026-02-01 15:16:07.807259',NULL,'2026-02-01 15:16:07.833288',448,448,NULL,'f3b8d980-89be-4fb8-8fdf-c7fb6cf499d6',120,'f99925486e924480b84b05e1433af949','shares',1,'2026-02-02 15:16:07','a811e5d0-f6d5-4017-bb5f-544fc27e7e76'),('2026-02-01 15:16:07.808819',NULL,'2026-02-01 15:16:07.833288',449,449,NULL,'81ed2ac0-dbba-497a-8ca4-9a9c47af0067',119,'f99925486e924480b84b05e1433af949','gigabytes',1,'2026-02-02 15:16:07','a811e5d0-f6d5-4017-bb5f-544fc27e7e76'),('2026-02-01 15:16:09.216171',NULL,'2026-02-01 15:16:09.237215',450,450,'c768e3f3500c4bf19dcf4fcf64856998','9987cdc4-04ad-41c1-a59d-27b927d98ddd',135,'0d63dabe67144e93ab3137e7893f5f60','snapshots',-1,'2026-02-02 15:16:09',NULL),('2026-02-01 15:16:09.217520',NULL,'2026-02-01 15:16:09.237215',451,451,'c768e3f3500c4bf19dcf4fcf64856998','95f1dc0e-47a4-40d1-94b8-a6a5f67b69f1',136,'0d63dabe67144e93ab3137e7893f5f60','snapshot_gigabytes',-1,'2026-02-02 15:16:09',NULL),('2026-02-01 15:16:09.225739',NULL,'2026-02-01 15:16:09.237215',452,452,NULL,'a82e0c83-010d-4522-9336-3353c7a674a8',137,'0d63dabe67144e93ab3137e7893f5f60','snapshots',-1,'2026-02-02 15:16:09','120a16ad-b887-4c32-bd69-d344d97a4eee'),('2026-02-01 15:16:09.226928',NULL,'2026-02-01 15:16:09.237215',453,453,NULL,'0b7a4c3d-42a7-4d7a-994f-1859f20053aa',138,'0d63dabe67144e93ab3137e7893f5f60','snapshot_gigabytes',-1,'2026-02-02 15:16:09','120a16ad-b887-4c32-bd69-d344d97a4eee'),('2026-02-01 15:16:11.281028',NULL,'2026-02-01 15:16:11.305653',454,454,'6f2dab9328424993aa458427358720d9','b62a0167-a555-45c8-af44-817730bef09a',104,'32087184504a4aabb8269aa5ef350c60','shares',-1,'2026-02-02 15:16:11',NULL),('2026-02-01 15:16:11.282242',NULL,'2026-02-01 15:16:11.305653',455,455,'6f2dab9328424993aa458427358720d9','dcb31536-424c-4829-b017-beb2ce960d4a',103,'32087184504a4aabb8269aa5ef350c60','gigabytes',-1,'2026-02-02 15:16:11',NULL),('2026-02-01 15:16:11.294691',NULL,'2026-02-01 15:16:11.305653',456,456,NULL,'159d7c5c-4efa-4ec8-8b1e-740caf9b3c60',146,'32087184504a4aabb8269aa5ef350c60','shares',-1,'2026-02-02 15:16:11','5334ac45-44fc-49d0-95bb-7c266db24118'),('2026-02-01 15:16:11.295933',NULL,'2026-02-01 15:16:11.305653',457,457,NULL,'068784e2-665c-4c05-b339-bfa2a414548b',145,'32087184504a4aabb8269aa5ef350c60','gigabytes',-1,'2026-02-02 15:16:11','5334ac45-44fc-49d0-95bb-7c266db24118'),('2026-02-01 15:16:12.710972',NULL,'2026-02-01 15:16:12.740639',458,458,'c768e3f3500c4bf19dcf4fcf64856998','db4f6301-ac54-408d-b13e-2b9744c7d527',130,'0d63dabe67144e93ab3137e7893f5f60','shares',-1,'2026-02-02 15:16:12',NULL),('2026-02-01 15:16:12.712588',NULL,'2026-02-01 15:16:12.740639',459,459,'c768e3f3500c4bf19dcf4fcf64856998','8f499cea-12b9-4b3d-93f9-c6fa1524b814',129,'0d63dabe67144e93ab3137e7893f5f60','gigabytes',-1,'2026-02-02 15:16:12',NULL),('2026-02-01 15:16:12.726533',NULL,'2026-02-01 15:16:12.740639',460,460,NULL,'2df6e5bd-9c67-4a5f-9c09-f458aabedd25',132,'0d63dabe67144e93ab3137e7893f5f60','shares',-1,'2026-02-02 15:16:12','120a16ad-b887-4c32-bd69-d344d97a4eee'),('2026-02-01 15:16:12.727831',NULL,'2026-02-01 15:16:12.740639',461,461,NULL,'df0f5ea0-cd55-4197-ae1d-fb10a906d30b',131,'0d63dabe67144e93ab3137e7893f5f60','gigabytes',-1,'2026-02-02 15:16:12','120a16ad-b887-4c32-bd69-d344d97a4eee'),('2026-02-01 15:16:14.119233',NULL,'2026-02-01 15:16:14.177189',462,462,'e513aa3b998a4d7c9d1e07492d61bda1','71a96f76-c644-4085-b684-687c8fb27d8f',124,'2731ddbed05046f3bee55c8f307163b2','shares',1,'2026-02-02 15:16:14',NULL),('2026-02-01 15:16:14.121174',NULL,'2026-02-01 15:16:14.177189',463,463,'e513aa3b998a4d7c9d1e07492d61bda1','3d4b737d-6f5d-4831-ba72-1e750e60bf6d',123,'2731ddbed05046f3bee55c8f307163b2','gigabytes',1,'2026-02-02 15:16:14',NULL),('2026-02-01 15:16:14.137551',NULL,'2026-02-01 15:16:14.177189',464,464,NULL,'b988536b-7fe3-43ac-a645-53bf56ecb166',148,'2731ddbed05046f3bee55c8f307163b2','shares',1,'2026-02-02 15:16:14','847063aa-e54d-49d1-b390-6611881b6691'),('2026-02-01 15:16:14.142331',NULL,'2026-02-01 15:16:14.177189',465,465,NULL,'2e261115-80db-489b-86c9-d4d5ad8e278a',147,'2731ddbed05046f3bee55c8f307163b2','gigabytes',1,'2026-02-02 15:16:14','847063aa-e54d-49d1-b390-6611881b6691'),('2026-02-01 15:16:15.897716',NULL,'2026-02-01 15:16:15.910592',466,466,'e9e626045c924c8c981ad3f67a1dedd6','0055057f-6253-4db0-8264-f37ee5d5c8bd',118,'f99925486e924480b84b05e1433af949','shares',-1,'2026-02-02 15:16:15',NULL),('2026-02-01 15:16:15.898435',NULL,'2026-02-01 15:16:15.910592',467,467,'e9e626045c924c8c981ad3f67a1dedd6','aefd83d3-4ab0-4a5e-bbd1-29127a207041',117,'f99925486e924480b84b05e1433af949','gigabytes',-1,'2026-02-02 15:16:15',NULL),('2026-02-01 15:16:15.904083',NULL,'2026-02-01 15:16:15.910592',468,468,NULL,'828ba996-9b73-4f0f-a0ea-aa9390d91d27',120,'f99925486e924480b84b05e1433af949','shares',-1,'2026-02-02 15:16:15','a811e5d0-f6d5-4017-bb5f-544fc27e7e76'),('2026-02-01 15:16:15.904644',NULL,'2026-02-01 15:16:15.910592',469,469,NULL,'394f4187-5e52-4e9d-94a2-5c4d2685fbd0',119,'f99925486e924480b84b05e1433af949','gigabytes',-1,'2026-02-02 15:16:15','a811e5d0-f6d5-4017-bb5f-544fc27e7e76'),('2026-02-01 15:16:29.927904',NULL,'2026-02-01 15:16:29.955607',470,470,'e513aa3b998a4d7c9d1e07492d61bda1','2e6ab452-61ce-40d2-b723-60163fb4e0f0',124,'2731ddbed05046f3bee55c8f307163b2','shares',-1,'2026-02-02 15:16:29',NULL),('2026-02-01 15:16:29.929000',NULL,'2026-02-01 15:16:29.955607',471,471,'e513aa3b998a4d7c9d1e07492d61bda1','91892582-4dcc-40e4-b5f0-74691c766251',123,'2731ddbed05046f3bee55c8f307163b2','gigabytes',-1,'2026-02-02 15:16:29',NULL),('2026-02-01 15:16:29.936632',NULL,'2026-02-01 15:16:29.955607',472,472,NULL,'5527b437-4a79-4551-8bc1-8a80891aec73',148,'2731ddbed05046f3bee55c8f307163b2','shares',-1,'2026-02-02 15:16:29','847063aa-e54d-49d1-b390-6611881b6691'),('2026-02-01 15:16:29.939454',NULL,'2026-02-01 15:16:29.955607',473,473,NULL,'5ea665f9-7ee3-44eb-90da-01b56ab7e14a',147,'2731ddbed05046f3bee55c8f307163b2','gigabytes',-1,'2026-02-02 15:16:29','847063aa-e54d-49d1-b390-6611881b6691'),('2026-02-01 15:16:30.757024',NULL,'2026-02-01 15:16:30.796177',474,474,'9143810fbee74a7799490ac3fc1032dd','35e9fb20-9ced-456a-8397-81963a0e83f3',150,'c12690bcab10459c81103ff11e371488','shares',1,'2026-02-02 15:16:30',NULL),('2026-02-01 15:16:30.758358',NULL,'2026-02-01 15:16:30.796177',475,475,'9143810fbee74a7799490ac3fc1032dd','e9f5432e-016e-4dd3-a4b8-80bfba08d033',149,'c12690bcab10459c81103ff11e371488','gigabytes',1,'2026-02-02 15:16:30',NULL),('2026-02-01 15:16:30.768793',NULL,'2026-02-01 15:16:30.796177',476,476,NULL,'6a11a64d-dba3-4241-9023-d5d84966117e',152,'c12690bcab10459c81103ff11e371488','shares',1,'2026-02-02 15:16:30','63d145b6-fb37-4811-991f-0edbfd2cd9ff'),('2026-02-01 15:16:30.770458',NULL,'2026-02-01 15:16:30.796177',477,477,NULL,'73a7459c-7167-4f04-8c63-c6d406288499',151,'c12690bcab10459c81103ff11e371488','gigabytes',1,'2026-02-02 15:16:30','63d145b6-fb37-4811-991f-0edbfd2cd9ff'),('2026-02-01 15:16:31.958059',NULL,'2026-02-01 15:16:32.005622',478,478,'627361eeb4bc410fb28e040badc59d2c','95b830d1-1ece-43cd-9789-d2594003be48',154,'d8619226901f4987807454d91d99af93','shares',1,'2026-02-02 15:16:31',NULL),('2026-02-01 15:16:31.959610',NULL,'2026-02-01 15:16:32.005622',479,479,'627361eeb4bc410fb28e040badc59d2c','5dd6866a-787b-491b-84be-d0af08ea76ad',153,'d8619226901f4987807454d91d99af93','gigabytes',1,'2026-02-02 15:16:31',NULL),('2026-02-01 15:16:31.975950',NULL,'2026-02-01 15:16:32.005622',480,480,NULL,'14dd8127-83f7-4796-98af-b883ab880c0e',156,'d8619226901f4987807454d91d99af93','shares',1,'2026-02-02 15:16:31','6e4527c7-6f92-4531-b150-fbe437acbc5f'),('2026-02-01 15:16:31.977967',NULL,'2026-02-01 15:16:32.005622',481,481,NULL,'f7d56e71-102a-4af9-8ef3-7cb82e80fec2',155,'d8619226901f4987807454d91d99af93','gigabytes',1,'2026-02-02 15:16:31','6e4527c7-6f92-4531-b150-fbe437acbc5f'),('2026-02-01 15:16:33.443303',NULL,'2026-02-01 15:16:33.462641',482,482,'e513aa3b998a4d7c9d1e07492d61bda1','8b8121bc-0779-4454-960f-f7fb713ec7f4',124,'2731ddbed05046f3bee55c8f307163b2','shares',-1,'2026-02-02 15:16:33',NULL),('2026-02-01 15:16:33.444308',NULL,'2026-02-01 15:16:33.462641',483,483,'e513aa3b998a4d7c9d1e07492d61bda1','c320ed94-9a94-4508-b275-6522b465bba6',123,'2731ddbed05046f3bee55c8f307163b2','gigabytes',-1,'2026-02-02 15:16:33',NULL),('2026-02-01 15:16:33.454200',NULL,'2026-02-01 15:16:33.462641',484,484,NULL,'002a764a-eecc-42cb-bade-722ff770609a',126,'2731ddbed05046f3bee55c8f307163b2','shares',-1,'2026-02-02 15:16:33','29b95f67-19b6-4d0c-881b-ecde5688f59a'),('2026-02-01 15:16:33.455069',NULL,'2026-02-01 15:16:33.462641',485,485,NULL,'0561da5b-d4ac-4a0d-bcb2-d7b6003e0ecf',125,'2731ddbed05046f3bee55c8f307163b2','gigabytes',-1,'2026-02-02 15:16:33','29b95f67-19b6-4d0c-881b-ecde5688f59a'),('2026-02-01 15:16:35.654176',NULL,'2026-02-01 15:16:35.676515',486,486,'627361eeb4bc410fb28e040badc59d2c','8a04b778-054e-40b6-a842-472f7d17a335',154,'d8619226901f4987807454d91d99af93','shares',-1,'2026-02-02 15:16:35',NULL),('2026-02-01 15:16:35.655434',NULL,'2026-02-01 15:16:35.676515',487,487,'627361eeb4bc410fb28e040badc59d2c','ea1c05b4-5c6c-48eb-9c29-f6bdbc5b8432',153,'d8619226901f4987807454d91d99af93','gigabytes',-1,'2026-02-02 15:16:35',NULL),('2026-02-01 15:16:35.663957',NULL,'2026-02-01 15:16:35.676515',488,488,NULL,'00d33be3-9f17-4f20-8c2e-159c447c1639',156,'d8619226901f4987807454d91d99af93','shares',-1,'2026-02-02 15:16:35','6e4527c7-6f92-4531-b150-fbe437acbc5f'),('2026-02-01 15:16:35.665460',NULL,'2026-02-01 15:16:35.676515',489,489,NULL,'70fa58cc-e755-4107-90d6-3941922e0763',155,'d8619226901f4987807454d91d99af93','gigabytes',-1,'2026-02-02 15:16:35','6e4527c7-6f92-4531-b150-fbe437acbc5f'),('2026-02-01 15:16:35.684686',NULL,'2026-02-01 15:16:35.702696',490,490,'9143810fbee74a7799490ac3fc1032dd','da881edc-31f4-400b-93dc-1da180cde45d',150,'c12690bcab10459c81103ff11e371488','shares',-1,'2026-02-02 15:16:35',NULL),('2026-02-01 15:16:35.686390',NULL,'2026-02-01 15:16:35.702696',491,491,'9143810fbee74a7799490ac3fc1032dd','1baf8588-9aa9-4a3c-b453-5e061a9a2a35',149,'c12690bcab10459c81103ff11e371488','gigabytes',-1,'2026-02-02 15:16:35',NULL),('2026-02-01 15:16:35.693798',NULL,'2026-02-01 15:16:35.702696',492,492,NULL,'a894dc06-80d6-4c3f-a748-b156a3367113',152,'c12690bcab10459c81103ff11e371488','shares',-1,'2026-02-02 15:16:35','63d145b6-fb37-4811-991f-0edbfd2cd9ff'),('2026-02-01 15:16:35.695187',NULL,'2026-02-01 15:16:35.702696',493,493,NULL,'f5a9d9a4-0535-447e-8f83-0bc20dfff5b9',151,'c12690bcab10459c81103ff11e371488','gigabytes',-1,'2026-02-02 15:16:35','63d145b6-fb37-4811-991f-0edbfd2cd9ff'),('2026-02-01 15:16:35.904390',NULL,'2026-02-01 15:16:35.947908',494,494,'627361eeb4bc410fb28e040badc59d2c','083b2322-6b71-4601-9474-5a4899123a88',154,'d8619226901f4987807454d91d99af93','shares',1,'2026-02-02 15:16:35',NULL),('2026-02-01 15:16:35.905811',NULL,'2026-02-01 15:16:35.947908',495,495,'627361eeb4bc410fb28e040badc59d2c','d8de3b5d-22ec-4b2e-94b1-f51aa403e7d5',153,'d8619226901f4987807454d91d99af93','gigabytes',1,'2026-02-02 15:16:35',NULL),('2026-02-01 15:16:35.922202',NULL,'2026-02-01 15:16:35.947908',496,496,NULL,'0a7dc4ce-3b35-4ab5-984e-07a7fa133c21',158,'d8619226901f4987807454d91d99af93','shares',1,'2026-02-02 15:16:35','37d89b9e-0f7e-463d-91bf-eac4c891403e'),('2026-02-01 15:16:35.926168',NULL,'2026-02-01 15:16:35.947908',497,497,NULL,'27abd075-f9de-43ca-aa08-78586013f00a',157,'d8619226901f4987807454d91d99af93','gigabytes',1,'2026-02-02 15:16:35','37d89b9e-0f7e-463d-91bf-eac4c891403e'),('2026-02-01 15:16:37.024799',NULL,'2026-02-01 15:16:37.040190',498,498,'795592d89a1d46e4a844c4a238d332e3','f575bc8a-5b64-4a8a-97f9-ca9caaa1112d',108,'e483891a9fd042d4a571a3d4655dc685','shares',-1,'2026-02-02 15:16:37',NULL),('2026-02-01 15:16:37.025631',NULL,'2026-02-01 15:16:37.040190',499,499,'795592d89a1d46e4a844c4a238d332e3','6c7d37b7-d446-4292-b8f9-0b87d6bf1e87',107,'e483891a9fd042d4a571a3d4655dc685','gigabytes',-1,'2026-02-02 15:16:37',NULL),('2026-02-01 15:16:37.031094',NULL,'2026-02-01 15:16:37.040190',500,500,NULL,'e79c4d6e-c4b8-47cd-942d-9c95d1552c35',114,'e483891a9fd042d4a571a3d4655dc685','shares',-1,'2026-02-02 15:16:37','29b95f67-19b6-4d0c-881b-ecde5688f59a'),('2026-02-01 15:16:37.031749',NULL,'2026-02-01 15:16:37.040190',501,501,NULL,'da608398-79d6-4fed-b154-2a6fae2a3d92',113,'e483891a9fd042d4a571a3d4655dc685','gigabytes',-1,'2026-02-02 15:16:37','29b95f67-19b6-4d0c-881b-ecde5688f59a'),('2026-02-01 15:16:39.789678',NULL,'2026-02-01 15:16:39.803386',502,502,'627361eeb4bc410fb28e040badc59d2c','48c32d1c-a22b-4950-b9ae-ba6ebf35a7d4',154,'d8619226901f4987807454d91d99af93','shares',-1,'2026-02-02 15:16:39',NULL),('2026-02-01 15:16:39.791971',NULL,'2026-02-01 15:16:39.803386',503,503,'627361eeb4bc410fb28e040badc59d2c','32ea357f-1adb-4ab9-83a7-28bbe2d7f519',153,'d8619226901f4987807454d91d99af93','gigabytes',-1,'2026-02-02 15:16:39',NULL),('2026-02-01 15:16:39.796206',NULL,'2026-02-01 15:16:39.803386',504,504,NULL,'e2c5acb6-d80e-4fa5-99cd-2d1748f5b2a6',158,'d8619226901f4987807454d91d99af93','shares',-1,'2026-02-02 15:16:39','37d89b9e-0f7e-463d-91bf-eac4c891403e'),('2026-02-01 15:16:39.796762',NULL,'2026-02-01 15:16:39.803386',505,505,NULL,'c6d69aeb-01af-4c74-87b0-9ce6324011c6',157,'d8619226901f4987807454d91d99af93','gigabytes',-1,'2026-02-02 15:16:39','37d89b9e-0f7e-463d-91bf-eac4c891403e'),('2026-02-01 15:16:40.053141',NULL,'2026-02-01 15:16:40.113088',506,506,'627361eeb4bc410fb28e040badc59d2c','b3da357c-f4ca-47cf-bc42-b4ed780df722',154,'d8619226901f4987807454d91d99af93','shares',1,'2026-02-02 15:16:40',NULL),('2026-02-01 15:16:40.055423',NULL,'2026-02-01 15:16:40.113088',507,507,'627361eeb4bc410fb28e040badc59d2c','2d911fc3-47cc-47b0-a9c8-f143c1b85a05',153,'d8619226901f4987807454d91d99af93','gigabytes',1,'2026-02-02 15:16:40',NULL),('2026-02-01 15:16:40.076914',NULL,'2026-02-01 15:16:40.113088',508,508,NULL,'e29de96a-262e-44b1-b1d0-6b7233aa4455',160,'d8619226901f4987807454d91d99af93','shares',1,'2026-02-02 15:16:40','6e184f8e-4cd9-43fc-856f-053e93d4bd03'),('2026-02-01 15:16:40.078917',NULL,'2026-02-01 15:16:40.113088',509,509,NULL,'816a7a43-2eac-4a9c-853e-ad3566be740c',159,'d8619226901f4987807454d91d99af93','gigabytes',1,'2026-02-02 15:16:40','6e184f8e-4cd9-43fc-856f-053e93d4bd03'),('2026-02-01 15:16:40.724162',NULL,'2026-02-01 15:16:40.745920',510,510,'795592d89a1d46e4a844c4a238d332e3','5783213b-4a2f-403f-8bdc-7bef50efd682',108,'e483891a9fd042d4a571a3d4655dc685','shares',-1,'2026-02-02 15:16:40',NULL),('2026-02-01 15:16:40.725649',NULL,'2026-02-01 15:16:40.745920',511,511,'795592d89a1d46e4a844c4a238d332e3','82f113e0-2b19-4c96-81b8-540a544e305d',107,'e483891a9fd042d4a571a3d4655dc685','gigabytes',-1,'2026-02-02 15:16:40',NULL),('2026-02-01 15:16:40.733041',NULL,'2026-02-01 15:16:40.745920',512,512,NULL,'ae312ea6-afe1-40cb-acf0-2a2ea4b20e23',110,'e483891a9fd042d4a571a3d4655dc685','shares',-1,'2026-02-02 15:16:40','847063aa-e54d-49d1-b390-6611881b6691'),('2026-02-01 15:16:40.734652',NULL,'2026-02-01 15:16:40.745920',513,513,NULL,'0f2fa769-69ab-4816-b906-d48054863b2e',109,'e483891a9fd042d4a571a3d4655dc685','gigabytes',-1,'2026-02-02 15:16:40','847063aa-e54d-49d1-b390-6611881b6691'),('2026-02-01 15:16:44.015165',NULL,'2026-02-01 15:16:44.026603',514,514,'627361eeb4bc410fb28e040badc59d2c','76b4dbb0-3c52-4a22-941f-320223c38de3',154,'d8619226901f4987807454d91d99af93','shares',-1,'2026-02-02 15:16:43',NULL),('2026-02-01 15:16:44.015758',NULL,'2026-02-01 15:16:44.026603',515,515,'627361eeb4bc410fb28e040badc59d2c','c8f4bd3d-abc1-4897-839e-9d89fc56fe98',153,'d8619226901f4987807454d91d99af93','gigabytes',-1,'2026-02-02 15:16:43',NULL),('2026-02-01 15:16:44.020750',NULL,'2026-02-01 15:16:44.026603',516,516,NULL,'dd7b8389-4880-413f-8d5b-0fc89ddd054b',160,'d8619226901f4987807454d91d99af93','shares',-1,'2026-02-02 15:16:43','6e184f8e-4cd9-43fc-856f-053e93d4bd03'),('2026-02-01 15:16:44.021279',NULL,'2026-02-01 15:16:44.026603',517,517,NULL,'e0270aff-c567-4feb-8224-2a6da617de9f',159,'d8619226901f4987807454d91d99af93','gigabytes',-1,'2026-02-02 15:16:43','6e184f8e-4cd9-43fc-856f-053e93d4bd03'),('2026-02-01 15:16:44.406822',NULL,'2026-02-01 15:16:44.480584',518,518,'627361eeb4bc410fb28e040badc59d2c','f19db8e3-0958-4006-9587-cf35c5e033bf',154,'d8619226901f4987807454d91d99af93','shares',1,'2026-02-02 15:16:44',NULL),('2026-02-01 15:16:44.411747',NULL,'2026-02-01 15:16:44.480584',519,519,'627361eeb4bc410fb28e040badc59d2c','b0f09be9-9e40-4982-8890-941b701c2862',153,'d8619226901f4987807454d91d99af93','gigabytes',1,'2026-02-02 15:16:44',NULL),('2026-02-01 15:16:44.435801',NULL,'2026-02-01 15:16:44.480584',520,520,NULL,'3086db42-b7dc-4ccd-92c4-a7d6f0d8f751',162,'d8619226901f4987807454d91d99af93','shares',1,'2026-02-02 15:16:44','aceeeaf5-0220-422f-ad4e-febda069bdd9'),('2026-02-01 15:16:44.439852',NULL,'2026-02-01 15:16:44.480584',521,521,NULL,'8261d327-bd67-4bb5-a0fc-3e055ed2de5b',161,'d8619226901f4987807454d91d99af93','gigabytes',1,'2026-02-02 15:16:44','aceeeaf5-0220-422f-ad4e-febda069bdd9'),('2026-02-01 15:16:46.702405',NULL,'2026-02-01 15:16:46.721028',522,522,'e9e626045c924c8c981ad3f67a1dedd6','1ad849d1-c3a5-4314-a37c-f292eed19390',118,'f99925486e924480b84b05e1433af949','shares',-1,'2026-02-02 15:16:46',NULL),('2026-02-01 15:16:46.703783',NULL,'2026-02-01 15:16:46.721028',523,523,'e9e626045c924c8c981ad3f67a1dedd6','94400847-4e4b-4bfc-8cb4-d5f5fe9025cd',117,'f99925486e924480b84b05e1433af949','gigabytes',-1,'2026-02-02 15:16:46',NULL),('2026-02-01 15:16:46.713006',NULL,'2026-02-01 15:16:46.721028',524,524,NULL,'2532d24f-a1ac-41e9-a2cd-74481763c124',120,'f99925486e924480b84b05e1433af949','shares',-1,'2026-02-02 15:16:46','a811e5d0-f6d5-4017-bb5f-544fc27e7e76'),('2026-02-01 15:16:46.713693',NULL,'2026-02-01 15:16:46.721028',525,525,NULL,'3a4e9978-7f88-4573-b4de-681b8885f398',119,'f99925486e924480b84b05e1433af949','gigabytes',-1,'2026-02-02 15:16:46','a811e5d0-f6d5-4017-bb5f-544fc27e7e76'),('2026-02-01 15:16:48.541701',NULL,'2026-02-01 15:16:48.561836',526,526,'627361eeb4bc410fb28e040badc59d2c','16760f50-5256-4abd-afd4-a2492a36ab57',154,'d8619226901f4987807454d91d99af93','shares',-1,'2026-02-02 15:16:48',NULL),('2026-02-01 15:16:48.542511',NULL,'2026-02-01 15:16:48.561836',527,527,'627361eeb4bc410fb28e040badc59d2c','fb2ba3b1-7b96-41eb-b307-5095d3add5de',153,'d8619226901f4987807454d91d99af93','gigabytes',-1,'2026-02-02 15:16:48',NULL),('2026-02-01 15:16:48.553799',NULL,'2026-02-01 15:16:48.561836',528,528,NULL,'0859af7a-04c4-49b5-bde4-689124f05a38',162,'d8619226901f4987807454d91d99af93','shares',-1,'2026-02-02 15:16:48','aceeeaf5-0220-422f-ad4e-febda069bdd9'),('2026-02-01 15:16:48.554910',NULL,'2026-02-01 15:16:48.561836',529,529,NULL,'bcbc396e-a871-44c2-8bcb-6cf4bc79ca4e',161,'d8619226901f4987807454d91d99af93','gigabytes',-1,'2026-02-02 15:16:48','aceeeaf5-0220-422f-ad4e-febda069bdd9'),('2026-02-01 15:16:49.002862',NULL,'2026-02-01 15:16:49.046545',530,530,'627361eeb4bc410fb28e040badc59d2c','ecef1f4b-fa24-4f06-8540-0992a96d1f39',154,'d8619226901f4987807454d91d99af93','shares',1,'2026-02-02 15:16:48',NULL),('2026-02-01 15:16:49.004277',NULL,'2026-02-01 15:16:49.046545',531,531,'627361eeb4bc410fb28e040badc59d2c','6de03dd6-cc6d-4cb9-a22c-47c15e498a2f',153,'d8619226901f4987807454d91d99af93','gigabytes',1,'2026-02-02 15:16:48',NULL),('2026-02-01 15:16:49.015474',NULL,'2026-02-01 15:16:49.046545',532,532,NULL,'693f8f82-547b-48b7-9aea-4a34fa0e3ef2',164,'d8619226901f4987807454d91d99af93','shares',1,'2026-02-02 15:16:48','1ee8abb9-5f19-4316-b114-c5b3500a2ff5'),('2026-02-01 15:16:49.016933',NULL,'2026-02-01 15:16:49.046545',533,533,NULL,'00fc179a-3cc3-4bea-b332-60d99158f782',163,'d8619226901f4987807454d91d99af93','gigabytes',1,'2026-02-02 15:16:48','1ee8abb9-5f19-4316-b114-c5b3500a2ff5'),('2026-02-01 15:16:52.287769',NULL,'2026-02-01 15:16:52.316273',534,534,'465443f98ace4b989c787808b3cda30c','08715848-0447-4ce4-9dee-9c839c0248ed',166,'7043f01f29d441a4801c5afbb65b54e3','shares',1,'2026-02-02 15:16:52',NULL),('2026-02-01 15:16:52.288788',NULL,'2026-02-01 15:16:52.316273',535,535,'465443f98ace4b989c787808b3cda30c','8bc61a17-1e3e-4cca-9415-29fa17534301',165,'7043f01f29d441a4801c5afbb65b54e3','gigabytes',1,'2026-02-02 15:16:52',NULL),('2026-02-01 15:16:52.296786',NULL,'2026-02-01 15:16:52.316273',536,536,NULL,'d0e8ff80-e46b-4de6-9784-4f29217c4a34',168,'7043f01f29d441a4801c5afbb65b54e3','shares',1,'2026-02-02 15:16:52','5b0c2719-9cba-4adb-b36c-2f65cfd23a4c'),('2026-02-01 15:16:52.297664',NULL,'2026-02-01 15:16:52.316273',537,537,NULL,'e8bc3423-7acf-44d8-9c05-7de024b6f429',167,'7043f01f29d441a4801c5afbb65b54e3','gigabytes',1,'2026-02-02 15:16:52','5b0c2719-9cba-4adb-b36c-2f65cfd23a4c'),('2026-02-01 15:16:52.869629',NULL,'2026-02-01 15:16:52.884114',538,538,'627361eeb4bc410fb28e040badc59d2c','a65e5a10-3127-4fcd-be27-0f4580655e18',154,'d8619226901f4987807454d91d99af93','shares',-1,'2026-02-02 15:16:52',NULL),('2026-02-01 15:16:52.870438',NULL,'2026-02-01 15:16:52.884114',539,539,'627361eeb4bc410fb28e040badc59d2c','295e7fc9-7b75-4acd-86be-d39536708aca',153,'d8619226901f4987807454d91d99af93','gigabytes',-1,'2026-02-02 15:16:52',NULL),('2026-02-01 15:16:52.875287',NULL,'2026-02-01 15:16:52.884114',540,540,NULL,'31f339f4-40f1-4873-b0ba-0659363d2ca4',164,'d8619226901f4987807454d91d99af93','shares',-1,'2026-02-02 15:16:52','1ee8abb9-5f19-4316-b114-c5b3500a2ff5'),('2026-02-01 15:16:52.875839',NULL,'2026-02-01 15:16:52.884114',541,541,NULL,'5401314c-ce3d-4793-90f3-4dba1985452f',163,'d8619226901f4987807454d91d99af93','gigabytes',-1,'2026-02-02 15:16:52','1ee8abb9-5f19-4316-b114-c5b3500a2ff5'),('2026-02-01 15:16:59.080827',NULL,'2026-02-01 15:16:59.119775',542,542,'746730afb3db4d7f80045269f8973474','4f6fa1aa-4b70-4584-b702-4f5c999f897d',170,'120c1822ab9548c2815485bc30d42a55','shares',1,'2026-02-02 15:16:59',NULL),('2026-02-01 15:16:59.081983',NULL,'2026-02-01 15:16:59.119775',543,543,'746730afb3db4d7f80045269f8973474','8062019d-73d0-4c24-af85-10f176f29256',169,'120c1822ab9548c2815485bc30d42a55','gigabytes',1,'2026-02-02 15:16:59',NULL),('2026-02-01 15:16:59.094899',NULL,'2026-02-01 15:16:59.119775',544,544,NULL,'5e728402-93be-4209-acc1-496b76a79d44',172,'120c1822ab9548c2815485bc30d42a55','shares',1,'2026-02-02 15:16:59','01cc7ed9-ffd6-4668-816c-0807ff3b9e16'),('2026-02-01 15:16:59.096993',NULL,'2026-02-01 15:16:59.119775',545,545,NULL,'1b9e8f5b-a6c7-44bf-85a9-7dc83d43444a',171,'120c1822ab9548c2815485bc30d42a55','gigabytes',1,'2026-02-02 15:16:59','01cc7ed9-ffd6-4668-816c-0807ff3b9e16'),('2026-02-01 15:17:02.603604',NULL,'2026-02-01 15:17:02.714131',546,546,'746730afb3db4d7f80045269f8973474','45f78041-2c09-4ad2-a6f0-47d321dba251',174,'120c1822ab9548c2815485bc30d42a55','snapshots',1,'2026-02-02 15:17:02',NULL),('2026-02-01 15:17:02.604593',NULL,'2026-02-01 15:17:02.714131',547,547,'746730afb3db4d7f80045269f8973474','98a571ca-fccb-4f38-bb39-af29f87713ac',173,'120c1822ab9548c2815485bc30d42a55','snapshot_gigabytes',1,'2026-02-02 15:17:02',NULL),('2026-02-01 15:17:02.612507',NULL,'2026-02-01 15:17:02.714131',548,548,NULL,'14327880-b3f3-449d-bb35-6ff20f624b20',176,'120c1822ab9548c2815485bc30d42a55','snapshots',1,'2026-02-02 15:17:02','01cc7ed9-ffd6-4668-816c-0807ff3b9e16'),('2026-02-01 15:17:02.613668',NULL,'2026-02-01 15:17:02.714131',549,549,NULL,'92b792fb-7c67-456d-b015-b53f9a0e6352',175,'120c1822ab9548c2815485bc30d42a55','snapshot_gigabytes',1,'2026-02-02 15:17:02','01cc7ed9-ffd6-4668-816c-0807ff3b9e16'),('2026-02-01 15:17:03.284985',NULL,'2026-02-01 15:17:03.320494',550,550,'78165cb2bbac42ca957ac7fa7010927e','2ccd5f8e-3566-44aa-9dc7-11714c64b2e3',178,'557407533ddd4b83a57f3bf0896f77ac','shares',1,'2026-02-02 15:17:03',NULL),('2026-02-01 15:17:03.286123',NULL,'2026-02-01 15:17:03.320494',551,551,'78165cb2bbac42ca957ac7fa7010927e','d95b0682-d215-4936-ab39-e570ab04e784',177,'557407533ddd4b83a57f3bf0896f77ac','gigabytes',1,'2026-02-02 15:17:03',NULL),('2026-02-01 15:17:03.300050',NULL,'2026-02-01 15:17:03.320494',552,552,NULL,'6946116f-443f-4b78-8afc-377045378a8d',180,'557407533ddd4b83a57f3bf0896f77ac','shares',1,'2026-02-02 15:17:03','04283c6a-2cd4-4e89-807e-97c9144c5657'),('2026-02-01 15:17:03.301175',NULL,'2026-02-01 15:17:03.320494',553,553,NULL,'e8377430-1e21-4c92-9e80-3fc67b5afedd',179,'557407533ddd4b83a57f3bf0896f77ac','gigabytes',1,'2026-02-02 15:17:03','04283c6a-2cd4-4e89-807e-97c9144c5657'),('2026-02-01 15:17:03.550786',NULL,'2026-02-01 15:17:03.847935',554,554,'09a6b5beaf9f4e96b8a8b3f1d67a192d','1d589391-6fb1-417e-bcab-75be22e5c78f',181,'d3906373bc57497a8593cc485bc49810','share_networks',1,'2026-02-02 15:17:03',NULL),('2026-02-01 15:17:06.487192',NULL,'2026-02-01 15:17:06.504318',555,555,'746730afb3db4d7f80045269f8973474','4f48e631-2cc0-40b7-8173-a7aaf7d7b1be',174,'120c1822ab9548c2815485bc30d42a55','snapshots',-1,'2026-02-02 15:17:06',NULL),('2026-02-01 15:17:06.487854',NULL,'2026-02-01 15:17:06.504318',556,556,'746730afb3db4d7f80045269f8973474','ecf38642-ec90-4253-9a13-e3116c9c21eb',173,'120c1822ab9548c2815485bc30d42a55','snapshot_gigabytes',-1,'2026-02-02 15:17:06',NULL),('2026-02-01 15:17:06.493770',NULL,'2026-02-01 15:17:06.504318',557,557,NULL,'8cd81ae5-6cf9-411d-a8b8-7a3b5f0b16c6',176,'120c1822ab9548c2815485bc30d42a55','snapshots',-1,'2026-02-02 15:17:06','01cc7ed9-ffd6-4668-816c-0807ff3b9e16'),('2026-02-01 15:17:06.496040',NULL,'2026-02-01 15:17:06.504318',558,558,NULL,'837c9ac7-6d1b-4b7a-94e3-d2dc8f7d7da4',175,'120c1822ab9548c2815485bc30d42a55','snapshot_gigabytes',-1,'2026-02-02 15:17:06','01cc7ed9-ffd6-4668-816c-0807ff3b9e16'),('2026-02-01 15:17:10.172334',NULL,'2026-02-01 15:17:10.189305',559,559,'746730afb3db4d7f80045269f8973474','20e8270a-98fb-4796-9e25-eac6096e3550',170,'120c1822ab9548c2815485bc30d42a55','shares',-1,'2026-02-02 15:17:10',NULL),('2026-02-01 15:17:10.173254',NULL,'2026-02-01 15:17:10.189305',560,560,'746730afb3db4d7f80045269f8973474','ab6b8ccb-2e6d-4d1b-9366-a485b55fb7f4',169,'120c1822ab9548c2815485bc30d42a55','gigabytes',-1,'2026-02-02 15:17:10',NULL),('2026-02-01 15:17:10.180409',NULL,'2026-02-01 15:17:10.189305',561,561,NULL,'faa2007f-6d02-483a-885e-c40c71531a7d',172,'120c1822ab9548c2815485bc30d42a55','shares',-1,'2026-02-02 15:17:10','01cc7ed9-ffd6-4668-816c-0807ff3b9e16'),('2026-02-01 15:17:10.181236',NULL,'2026-02-01 15:17:10.189305',562,562,NULL,'86935b55-12b8-4618-8334-2ae67691e664',171,'120c1822ab9548c2815485bc30d42a55','gigabytes',-1,'2026-02-02 15:17:10','01cc7ed9-ffd6-4668-816c-0807ff3b9e16'),('2026-02-01 15:17:13.786288',NULL,'2026-02-01 15:17:13.834707',563,563,'746730afb3db4d7f80045269f8973474','5e94c0a5-629b-4afc-b26e-2abeac07d22f',170,'120c1822ab9548c2815485bc30d42a55','shares',1,'2026-02-02 15:17:13',NULL),('2026-02-01 15:17:13.787589',NULL,'2026-02-01 15:17:13.834707',564,564,'746730afb3db4d7f80045269f8973474','00ed3330-0a70-4b61-8f64-d1baf4163016',169,'120c1822ab9548c2815485bc30d42a55','gigabytes',1,'2026-02-02 15:17:13',NULL),('2026-02-01 15:17:13.799302',NULL,'2026-02-01 15:17:13.834707',565,565,NULL,'484b9a56-08cb-4ed8-8ca6-d5a18af67cdc',183,'120c1822ab9548c2815485bc30d42a55','shares',1,'2026-02-02 15:17:13','f74f4e50-b67a-4dd2-8817-d029903f2283'),('2026-02-01 15:17:13.801676',NULL,'2026-02-01 15:17:13.834707',566,566,NULL,'ef3d48d4-d7ff-4084-80c9-2225a6bd1fca',182,'120c1822ab9548c2815485bc30d42a55','gigabytes',1,'2026-02-02 15:17:13','f74f4e50-b67a-4dd2-8817-d029903f2283'),('2026-02-01 15:17:18.249230',NULL,'2026-02-01 15:17:18.274150',567,567,'746730afb3db4d7f80045269f8973474','e54d870b-c687-4a6d-bf1c-738df9c44ff5',170,'120c1822ab9548c2815485bc30d42a55','shares',-1,'2026-02-02 15:17:18',NULL),('2026-02-01 15:17:18.250545',NULL,'2026-02-01 15:17:18.274150',568,568,'746730afb3db4d7f80045269f8973474','df08e1be-55d4-4988-a087-fe1362df9bba',169,'120c1822ab9548c2815485bc30d42a55','gigabytes',-1,'2026-02-02 15:17:18',NULL),('2026-02-01 15:17:18.264060',NULL,'2026-02-01 15:17:18.274150',569,569,NULL,'330b8686-325f-4253-947e-f7b5d194115b',183,'120c1822ab9548c2815485bc30d42a55','shares',-1,'2026-02-02 15:17:18','f74f4e50-b67a-4dd2-8817-d029903f2283'),('2026-02-01 15:17:18.265554',NULL,'2026-02-01 15:17:18.274150',570,570,NULL,'ddfaf73f-8589-44e4-94bd-9800cfb72772',182,'120c1822ab9548c2815485bc30d42a55','gigabytes',-1,'2026-02-02 15:17:18','f74f4e50-b67a-4dd2-8817-d029903f2283'),('2026-02-01 15:17:21.685455',NULL,'2026-02-01 15:17:21.716595',571,571,'746730afb3db4d7f80045269f8973474','0fa7ad1a-d81c-48ab-9f5e-a34290e25a74',170,'120c1822ab9548c2815485bc30d42a55','shares',1,'2026-02-02 15:17:21',NULL),('2026-02-01 15:17:21.686829',NULL,'2026-02-01 15:17:21.716595',572,572,'746730afb3db4d7f80045269f8973474','bc56eb13-d023-400a-a755-a52b1e70d5e2',169,'120c1822ab9548c2815485bc30d42a55','gigabytes',1,'2026-02-02 15:17:21',NULL),('2026-02-01 15:17:21.695795',NULL,'2026-02-01 15:17:21.716595',573,573,NULL,'97891310-e211-45c6-a56b-8a35830814e9',185,'120c1822ab9548c2815485bc30d42a55','shares',1,'2026-02-02 15:17:21','9e8345c3-c425-444a-948b-e657e9fcd15d'),('2026-02-01 15:17:21.696942',NULL,'2026-02-01 15:17:21.716595',574,574,NULL,'7770a016-ac00-46c9-b552-f345eca1c097',184,'120c1822ab9548c2815485bc30d42a55','gigabytes',1,'2026-02-02 15:17:21','9e8345c3-c425-444a-948b-e657e9fcd15d'),('2026-02-01 15:17:22.686145',NULL,'2026-02-01 15:17:22.724759',575,575,'3cf00994b85e4b779e6717ae76e983b5','17d9abc6-7d5a-4b6b-96d7-a275ef07f0fa',187,'368b363545bf449ebeb73c7917747ead','shares',1,'2026-02-02 15:17:22',NULL),('2026-02-01 15:17:22.687631',NULL,'2026-02-01 15:17:22.724759',576,576,'3cf00994b85e4b779e6717ae76e983b5','67bcc36d-2f14-499e-8fd2-c5c2c7388a90',186,'368b363545bf449ebeb73c7917747ead','gigabytes',1,'2026-02-02 15:17:22',NULL),('2026-02-01 15:17:22.699287',NULL,'2026-02-01 15:17:22.724759',577,577,NULL,'a03e0542-ea3d-4e5a-87d9-dfa2c13b6b5b',189,'368b363545bf449ebeb73c7917747ead','shares',1,'2026-02-02 15:17:22','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:17:22.701339',NULL,'2026-02-01 15:17:22.724759',578,578,NULL,'ab71c045-f20c-409a-a766-e178e3e29609',188,'368b363545bf449ebeb73c7917747ead','gigabytes',1,'2026-02-02 15:17:22','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:17:25.154195',NULL,'2026-02-01 15:17:25.216864',579,579,'746730afb3db4d7f80045269f8973474','5e46e911-143a-4616-b968-f80bbb6d503f',174,'120c1822ab9548c2815485bc30d42a55','snapshots',1,'2026-02-02 15:17:25',NULL),('2026-02-01 15:17:25.155309',NULL,'2026-02-01 15:17:25.216864',580,580,'746730afb3db4d7f80045269f8973474','03e09580-eb5d-42ef-9b70-d6650faf4132',173,'120c1822ab9548c2815485bc30d42a55','snapshot_gigabytes',1,'2026-02-02 15:17:25',NULL),('2026-02-01 15:17:25.163792',NULL,'2026-02-01 15:17:25.216864',581,581,NULL,'3f3c00c3-74c7-422c-96d5-84aeaac84b95',191,'120c1822ab9548c2815485bc30d42a55','snapshots',1,'2026-02-02 15:17:25','9e8345c3-c425-444a-948b-e657e9fcd15d'),('2026-02-01 15:17:25.164806',NULL,'2026-02-01 15:17:25.216864',582,582,NULL,'54d8db4c-28ee-44da-8bba-f0a4186df3be',190,'120c1822ab9548c2815485bc30d42a55','snapshot_gigabytes',1,'2026-02-02 15:17:25','9e8345c3-c425-444a-948b-e657e9fcd15d'),('2026-02-01 15:17:26.204734',NULL,'2026-02-01 15:17:28.082908',583,583,'3cf00994b85e4b779e6717ae76e983b5','c67b4a6e-6505-45cc-a4ef-8bfe0e555919',193,'368b363545bf449ebeb73c7917747ead','snapshots',1,'2026-02-02 15:17:26',NULL),('2026-02-01 15:17:26.206490',NULL,'2026-02-01 15:17:28.082908',584,584,'3cf00994b85e4b779e6717ae76e983b5','2b28d41e-84f5-449c-986c-360b0107c3df',192,'368b363545bf449ebeb73c7917747ead','snapshot_gigabytes',1,'2026-02-02 15:17:26',NULL),('2026-02-01 15:17:26.422818',NULL,'2026-02-01 15:17:28.082908',585,585,NULL,'a6585bfd-fe17-4370-9398-cac72890b2fc',195,'368b363545bf449ebeb73c7917747ead','snapshots',1,'2026-02-02 15:17:26','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:17:26.424164',NULL,'2026-02-01 15:17:28.082908',586,586,NULL,'8cbbf309-9afb-41c0-aff2-1a43ff515ea2',194,'368b363545bf449ebeb73c7917747ead','snapshot_gigabytes',1,'2026-02-02 15:17:26','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:17:28.785170',NULL,'2026-02-01 15:17:28.811815',587,587,'746730afb3db4d7f80045269f8973474','e4085c9e-5db1-4608-876c-ee026db20e60',170,'120c1822ab9548c2815485bc30d42a55','shares',1,'2026-02-02 15:17:28',NULL),('2026-02-01 15:17:28.786512',NULL,'2026-02-01 15:17:28.811815',588,588,'746730afb3db4d7f80045269f8973474','a2a99f8e-8e7c-464b-b540-1db888dfda17',169,'120c1822ab9548c2815485bc30d42a55','gigabytes',1,'2026-02-02 15:17:28',NULL),('2026-02-01 15:17:28.792131',NULL,'2026-02-01 15:17:28.811815',589,589,NULL,'65542a79-4aa1-408d-9aee-daf6d76c4fbd',185,'120c1822ab9548c2815485bc30d42a55','shares',1,'2026-02-02 15:17:28','9e8345c3-c425-444a-948b-e657e9fcd15d'),('2026-02-01 15:17:28.793199',NULL,'2026-02-01 15:17:28.811815',590,590,NULL,'ae982c44-3cee-434d-b27c-46294bd97db1',184,'120c1822ab9548c2815485bc30d42a55','gigabytes',1,'2026-02-02 15:17:28','9e8345c3-c425-444a-948b-e657e9fcd15d'),('2026-02-01 15:17:30.119041',NULL,'2026-02-01 15:17:30.137262',591,591,'78165cb2bbac42ca957ac7fa7010927e','36d6a0c2-8934-4a3e-956a-5cf6ae25d555',178,'557407533ddd4b83a57f3bf0896f77ac','shares',-1,'2026-02-02 15:17:30',NULL),('2026-02-01 15:17:30.119758',NULL,'2026-02-01 15:17:30.137262',592,592,'78165cb2bbac42ca957ac7fa7010927e','e6e5b423-da58-417e-a62d-4beaebbfbcb3',177,'557407533ddd4b83a57f3bf0896f77ac','gigabytes',-1,'2026-02-02 15:17:30',NULL),('2026-02-01 15:17:30.125537',NULL,'2026-02-01 15:17:30.137262',593,593,NULL,'f650dd10-f294-40e6-989f-6e5eda33e4cc',180,'557407533ddd4b83a57f3bf0896f77ac','shares',-1,'2026-02-02 15:17:30','04283c6a-2cd4-4e89-807e-97c9144c5657'),('2026-02-01 15:17:30.126356',NULL,'2026-02-01 15:17:30.137262',594,594,NULL,'8f7b2b88-a930-47a2-a569-5deb4f075d5a',179,'557407533ddd4b83a57f3bf0896f77ac','gigabytes',-1,'2026-02-02 15:17:30','04283c6a-2cd4-4e89-807e-97c9144c5657'),('2026-02-01 15:17:33.256781',NULL,'2026-02-01 15:17:33.299249',595,595,'3cf00994b85e4b779e6717ae76e983b5','f9f7a601-daf5-44af-812a-700f2f8b86ad',187,'368b363545bf449ebeb73c7917747ead','shares',1,'2026-02-02 15:17:33',NULL),('2026-02-01 15:17:33.257976',NULL,'2026-02-01 15:17:33.299249',596,596,'3cf00994b85e4b779e6717ae76e983b5','2c1eaba3-c0aa-4410-afcc-3b5dc22fe7e1',186,'368b363545bf449ebeb73c7917747ead','gigabytes',1,'2026-02-02 15:17:33',NULL),('2026-02-01 15:17:33.266307',NULL,'2026-02-01 15:17:33.299249',597,597,NULL,'f4e4de53-f36c-452c-bc5b-8e1188b1f3c8',189,'368b363545bf449ebeb73c7917747ead','shares',1,'2026-02-02 15:17:33','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:17:33.267737',NULL,'2026-02-01 15:17:33.299249',598,598,NULL,'de50bb61-af34-40ee-893b-f7bdaccdbd40',188,'368b363545bf449ebeb73c7917747ead','gigabytes',1,'2026-02-02 15:17:33','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:17:37.342624',NULL,'2026-02-01 15:17:37.355840',599,599,'3cf00994b85e4b779e6717ae76e983b5','263b19c6-db1b-4ee6-82e5-a9660b14e964',187,'368b363545bf449ebeb73c7917747ead','shares',-1,'2026-02-02 15:17:37',NULL),('2026-02-01 15:17:37.343405',NULL,'2026-02-01 15:17:37.355840',600,600,'3cf00994b85e4b779e6717ae76e983b5','f9635db3-f350-47be-a9ed-df6930e40ee8',186,'368b363545bf449ebeb73c7917747ead','gigabytes',-1,'2026-02-02 15:17:37',NULL),('2026-02-01 15:17:37.348522',NULL,'2026-02-01 15:17:37.355840',601,601,NULL,'ca9f8f9d-b642-4e8f-af59-378e290866f8',189,'368b363545bf449ebeb73c7917747ead','shares',-1,'2026-02-02 15:17:37','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:17:37.349161',NULL,'2026-02-01 15:17:37.355840',602,602,NULL,'4524256c-0011-483d-b7fe-00292122633c',188,'368b363545bf449ebeb73c7917747ead','gigabytes',-1,'2026-02-02 15:17:37','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:17:41.321244',NULL,'2026-02-01 15:17:41.344278',603,603,'3cf00994b85e4b779e6717ae76e983b5','49227d83-2dca-415f-9891-2834fad79562',187,'368b363545bf449ebeb73c7917747ead','shares',1,'2026-02-02 15:17:41',NULL),('2026-02-01 15:17:41.322370',NULL,'2026-02-01 15:17:41.344278',604,604,'3cf00994b85e4b779e6717ae76e983b5','cacc6587-288f-446d-a237-da05a100b4a9',186,'368b363545bf449ebeb73c7917747ead','gigabytes',2,'2026-02-02 15:17:41',NULL),('2026-02-01 15:17:41.327286',NULL,'2026-02-01 15:17:41.344278',605,605,NULL,'d3c85381-b128-4e1b-b77d-59818a8ce5d0',189,'368b363545bf449ebeb73c7917747ead','shares',1,'2026-02-02 15:17:41','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:17:41.328231',NULL,'2026-02-01 15:17:41.344278',606,606,NULL,'8fed5444-6337-467d-9be6-8f694f94ac9f',188,'368b363545bf449ebeb73c7917747ead','gigabytes',2,'2026-02-02 15:17:41','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:17:45.914731',NULL,'2026-02-01 15:17:45.927249',607,607,'3cf00994b85e4b779e6717ae76e983b5','f3358f50-a19f-4dfd-9429-bd1c0203912e',187,'368b363545bf449ebeb73c7917747ead','shares',-1,'2026-02-02 15:17:45',NULL),('2026-02-01 15:17:45.915508',NULL,'2026-02-01 15:17:45.927249',608,608,'3cf00994b85e4b779e6717ae76e983b5','7a157c0c-bffe-4695-8f95-0969e1718ee7',186,'368b363545bf449ebeb73c7917747ead','gigabytes',-2,'2026-02-02 15:17:45',NULL),('2026-02-01 15:17:45.920176',NULL,'2026-02-01 15:17:45.927249',609,609,NULL,'92a0196f-4aeb-46f0-ae3b-660b1066cbb3',189,'368b363545bf449ebeb73c7917747ead','shares',-1,'2026-02-02 15:17:45','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:17:45.920741',NULL,'2026-02-01 15:17:45.927249',610,610,NULL,'0790eeba-b568-440f-b56f-d6e48a4aeb43',188,'368b363545bf449ebeb73c7917747ead','gigabytes',-2,'2026-02-02 15:17:45','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:17:48.335725',NULL,'2026-02-01 15:17:48.371367',611,611,'60095238b9444c4bbf425950ca283c97','28dbc3ce-35d2-48d8-bb26-5c77bd1cb908',197,'5e1261fa63b348dd8c26883b016255c5','shares',1,'2026-02-02 15:17:48',NULL),('2026-02-01 15:17:48.336988',NULL,'2026-02-01 15:17:48.371367',612,612,'60095238b9444c4bbf425950ca283c97','ea24fd0d-878e-4801-947c-e9bd454c544f',196,'5e1261fa63b348dd8c26883b016255c5','gigabytes',1,'2026-02-02 15:17:48',NULL),('2026-02-01 15:17:48.347841',NULL,'2026-02-01 15:17:48.371367',613,613,NULL,'16217dbe-7efc-4082-a989-5c3676cc01f6',199,'5e1261fa63b348dd8c26883b016255c5','shares',1,'2026-02-02 15:17:48','4a6a9091-c2d9-4ce4-85d0-0da2193297bc'),('2026-02-01 15:17:48.349401',NULL,'2026-02-01 15:17:48.371367',614,614,NULL,'68c19e2d-4591-4c8a-a3ca-31d734aad0a0',198,'5e1261fa63b348dd8c26883b016255c5','gigabytes',1,'2026-02-02 15:17:48','4a6a9091-c2d9-4ce4-85d0-0da2193297bc'),('2026-02-01 15:17:49.109088',NULL,'2026-02-01 15:17:49.138815',615,615,'3cf00994b85e4b779e6717ae76e983b5','8b1545a0-7553-4751-a15a-8febe8be4b16',187,'368b363545bf449ebeb73c7917747ead','shares',1,'2026-02-02 15:17:49',NULL),('2026-02-01 15:17:49.110431',NULL,'2026-02-01 15:17:49.138815',616,616,'3cf00994b85e4b779e6717ae76e983b5','ba110411-61fb-4ac1-ba59-f9951f98174f',186,'368b363545bf449ebeb73c7917747ead','gigabytes',1,'2026-02-02 15:17:49',NULL),('2026-02-01 15:17:49.116612',NULL,'2026-02-01 15:17:49.138815',617,617,NULL,'5312f8c4-6586-4d86-bed9-d6b114c066d0',189,'368b363545bf449ebeb73c7917747ead','shares',1,'2026-02-02 15:17:49','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:17:49.117712',NULL,'2026-02-01 15:17:49.138815',618,618,NULL,'961e6c4a-cdaf-405d-8bf3-f5d9a14caa13',188,'368b363545bf449ebeb73c7917747ead','gigabytes',1,'2026-02-02 15:17:49','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:17:51.667137',NULL,'2026-02-01 15:17:51.732847',619,619,'60095238b9444c4bbf425950ca283c97','64e69f74-f158-4a51-9167-5d5135eeda5b',201,'5e1261fa63b348dd8c26883b016255c5','snapshots',1,'2026-02-02 15:17:51',NULL),('2026-02-01 15:17:51.668262',NULL,'2026-02-01 15:17:51.732847',620,620,'60095238b9444c4bbf425950ca283c97','86adb475-7a56-458b-accc-b0b912d7ef45',200,'5e1261fa63b348dd8c26883b016255c5','snapshot_gigabytes',1,'2026-02-02 15:17:51',NULL),('2026-02-01 15:17:51.678650',NULL,'2026-02-01 15:17:51.732847',621,621,NULL,'173dacbc-e2e4-462b-a84e-eba81bfc6a1b',203,'5e1261fa63b348dd8c26883b016255c5','snapshots',1,'2026-02-02 15:17:51','4a6a9091-c2d9-4ce4-85d0-0da2193297bc'),('2026-02-01 15:17:51.679700',NULL,'2026-02-01 15:17:51.732847',622,622,NULL,'305c4ff8-c5f7-4032-b3b2-86f81a2020ff',202,'5e1261fa63b348dd8c26883b016255c5','snapshot_gigabytes',1,'2026-02-02 15:17:51','4a6a9091-c2d9-4ce4-85d0-0da2193297bc'),('2026-02-01 15:17:52.833006',NULL,'2026-02-01 15:17:52.846502',623,623,'3cf00994b85e4b779e6717ae76e983b5','6b0ff592-59d6-42c4-9d6f-e5b51046ca0f',187,'368b363545bf449ebeb73c7917747ead','shares',-1,'2026-02-02 15:17:52',NULL),('2026-02-01 15:17:52.833660',NULL,'2026-02-01 15:17:52.846502',624,624,'3cf00994b85e4b779e6717ae76e983b5','044c2ef9-3c60-4861-b748-86e1be75f479',186,'368b363545bf449ebeb73c7917747ead','gigabytes',-1,'2026-02-02 15:17:52',NULL),('2026-02-01 15:17:52.839352',NULL,'2026-02-01 15:17:52.846502',625,625,NULL,'9c37b666-226a-4430-83a6-f7d7bc65fb4e',189,'368b363545bf449ebeb73c7917747ead','shares',-1,'2026-02-02 15:17:52','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:17:52.839996',NULL,'2026-02-01 15:17:52.846502',626,626,NULL,'d0897866-a6d4-483f-97fe-e4ecc044fc84',188,'368b363545bf449ebeb73c7917747ead','gigabytes',-1,'2026-02-02 15:17:52','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:17:55.981099',NULL,'2026-02-01 15:17:56.015026',627,627,'3cf00994b85e4b779e6717ae76e983b5','4cd5bd48-78b7-45e7-a5eb-5299fb09e4c4',187,'368b363545bf449ebeb73c7917747ead','shares',1,'2026-02-02 15:17:55',NULL),('2026-02-01 15:17:55.982668',NULL,'2026-02-01 15:17:56.015026',628,628,'3cf00994b85e4b779e6717ae76e983b5','cb971137-9ce9-43be-b1da-22d91a7031f7',186,'368b363545bf449ebeb73c7917747ead','gigabytes',1,'2026-02-02 15:17:55',NULL),('2026-02-01 15:17:55.989643',NULL,'2026-02-01 15:17:56.015026',629,629,NULL,'a1ed09fb-ceb5-45fe-ab57-40dca7f6e9ef',189,'368b363545bf449ebeb73c7917747ead','shares',1,'2026-02-02 15:17:55','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:17:55.991095',NULL,'2026-02-01 15:17:56.015026',630,630,NULL,'c4737313-bc41-4eb2-bba2-fb79cfefd1e9',188,'368b363545bf449ebeb73c7917747ead','gigabytes',1,'2026-02-02 15:17:55','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:17:56.432565',NULL,'2026-02-01 15:17:56.448394',631,631,'60095238b9444c4bbf425950ca283c97','b5f1752e-c264-4b70-93e0-2a6f375514d8',201,'5e1261fa63b348dd8c26883b016255c5','snapshots',-1,'2026-02-02 15:17:56',NULL),('2026-02-01 15:17:56.434796',NULL,'2026-02-01 15:17:56.448394',632,632,'60095238b9444c4bbf425950ca283c97','7e488cdb-8dfa-47a3-892b-8231edef9152',200,'5e1261fa63b348dd8c26883b016255c5','snapshot_gigabytes',-1,'2026-02-02 15:17:56',NULL),('2026-02-01 15:17:56.440600',NULL,'2026-02-01 15:17:56.448394',633,633,NULL,'183f5cd1-6329-4fc1-8edf-3d23c1095106',203,'5e1261fa63b348dd8c26883b016255c5','snapshots',-1,'2026-02-02 15:17:56','4a6a9091-c2d9-4ce4-85d0-0da2193297bc'),('2026-02-01 15:17:56.441210',NULL,'2026-02-01 15:17:56.448394',634,634,NULL,'7a9f9eec-945e-4192-87d0-e74fd8b1ed5b',202,'5e1261fa63b348dd8c26883b016255c5','snapshot_gigabytes',-1,'2026-02-02 15:17:56','4a6a9091-c2d9-4ce4-85d0-0da2193297bc'),('2026-02-01 15:18:00.248773',NULL,'2026-02-01 15:18:00.278632',635,635,'60095238b9444c4bbf425950ca283c97','f53a9e1e-a422-47ee-9a39-f52d52354e37',197,'5e1261fa63b348dd8c26883b016255c5','shares',-1,'2026-02-02 15:18:00',NULL),('2026-02-01 15:18:00.252283',NULL,'2026-02-01 15:18:00.278632',636,636,'60095238b9444c4bbf425950ca283c97','ff972a7e-0ef5-4920-8a91-1847ea58fe9d',196,'5e1261fa63b348dd8c26883b016255c5','gigabytes',-1,'2026-02-02 15:18:00',NULL),('2026-02-01 15:18:00.264843',NULL,'2026-02-01 15:18:00.278632',637,637,NULL,'2aeb5191-33ec-4802-8dfe-25c41c6df1f1',199,'5e1261fa63b348dd8c26883b016255c5','shares',-1,'2026-02-02 15:18:00','4a6a9091-c2d9-4ce4-85d0-0da2193297bc'),('2026-02-01 15:18:00.266014',NULL,'2026-02-01 15:18:00.278632',638,638,NULL,'58903560-90f9-40ed-ba30-639b7d2402a3',198,'5e1261fa63b348dd8c26883b016255c5','gigabytes',-1,'2026-02-02 15:18:00','4a6a9091-c2d9-4ce4-85d0-0da2193297bc'),('2026-02-01 15:18:00.317472',NULL,'2026-02-01 15:18:00.340449',639,639,'3cf00994b85e4b779e6717ae76e983b5','07a77a1f-005c-4339-8a48-da38713545f5',187,'368b363545bf449ebeb73c7917747ead','shares',-1,'2026-02-02 15:18:00',NULL),('2026-02-01 15:18:00.318569',NULL,'2026-02-01 15:18:00.340449',640,640,'3cf00994b85e4b779e6717ae76e983b5','fba502e1-c346-4d49-a695-ce58dc870424',186,'368b363545bf449ebeb73c7917747ead','gigabytes',-1,'2026-02-02 15:18:00',NULL),('2026-02-01 15:18:00.327701',NULL,'2026-02-01 15:18:00.340449',641,641,NULL,'61282ed5-4d84-433e-9298-13609969b35b',189,'368b363545bf449ebeb73c7917747ead','shares',-1,'2026-02-02 15:18:00','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:18:00.328835',NULL,'2026-02-01 15:18:00.340449',642,642,NULL,'84279bf3-0388-4728-a61c-60e9af165f30',188,'368b363545bf449ebeb73c7917747ead','gigabytes',-1,'2026-02-02 15:18:00','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:18:01.014157',NULL,'2026-02-01 15:18:01.027700',643,643,'746730afb3db4d7f80045269f8973474','ec5a8cf8-bbff-4004-bdca-82ad46b4ee0b',170,'120c1822ab9548c2815485bc30d42a55','shares',-1,'2026-02-02 15:18:00',NULL),('2026-02-01 15:18:01.015079',NULL,'2026-02-01 15:18:01.027700',644,644,'746730afb3db4d7f80045269f8973474','74a89366-a346-4ba1-9f1a-b9dccf433dc6',169,'120c1822ab9548c2815485bc30d42a55','gigabytes',-1,'2026-02-02 15:18:00',NULL),('2026-02-01 15:18:01.020416',NULL,'2026-02-01 15:18:01.027700',645,645,NULL,'eaa139a4-c710-4b56-bff2-bf57e8e910b8',185,'120c1822ab9548c2815485bc30d42a55','shares',-1,'2026-02-02 15:18:00','9e8345c3-c425-444a-948b-e657e9fcd15d'),('2026-02-01 15:18:01.020971',NULL,'2026-02-01 15:18:01.027700',646,646,NULL,'0240175c-b53d-45ef-ac8f-0f1b55df3dfe',184,'120c1822ab9548c2815485bc30d42a55','gigabytes',-1,'2026-02-02 15:18:00','9e8345c3-c425-444a-948b-e657e9fcd15d'),('2026-02-01 15:18:03.235562',NULL,'2026-02-01 15:18:03.269326',647,647,'3cf00994b85e4b779e6717ae76e983b5','f15159b0-ea0b-442b-8bc6-f2698741af19',187,'368b363545bf449ebeb73c7917747ead','shares',1,'2026-02-02 15:18:03',NULL),('2026-02-01 15:18:03.236813',NULL,'2026-02-01 15:18:03.269326',648,648,'3cf00994b85e4b779e6717ae76e983b5','448aa444-c96b-42c5-9028-e3fe9b727ecf',186,'368b363545bf449ebeb73c7917747ead','gigabytes',1,'2026-02-02 15:18:03',NULL),('2026-02-01 15:18:03.246336',NULL,'2026-02-01 15:18:03.269326',649,649,NULL,'e8c91bea-97ee-4e62-850e-7fedaeb1e0dd',189,'368b363545bf449ebeb73c7917747ead','shares',1,'2026-02-02 15:18:03','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:18:03.248714',NULL,'2026-02-01 15:18:03.269326',650,650,NULL,'9a55b073-fc79-4c00-9ab9-73955211920a',188,'368b363545bf449ebeb73c7917747ead','gigabytes',1,'2026-02-02 15:18:03','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:18:04.458082',NULL,'2026-02-01 15:18:04.481062',651,651,'746730afb3db4d7f80045269f8973474','3df186d5-3cbf-4355-aeb5-8022192c84df',174,'120c1822ab9548c2815485bc30d42a55','snapshots',-1,'2026-02-02 15:18:04',NULL),('2026-02-01 15:18:04.459086',NULL,'2026-02-01 15:18:04.481062',652,652,'746730afb3db4d7f80045269f8973474','3a524572-989f-4928-b775-4af07deafd10',173,'120c1822ab9548c2815485bc30d42a55','snapshot_gigabytes',-1,'2026-02-02 15:18:04',NULL),('2026-02-01 15:18:04.467213',NULL,'2026-02-01 15:18:04.481062',653,653,NULL,'96087fab-c6a7-42f8-abb3-2422d52c6da4',191,'120c1822ab9548c2815485bc30d42a55','snapshots',-1,'2026-02-02 15:18:04','9e8345c3-c425-444a-948b-e657e9fcd15d'),('2026-02-01 15:18:04.471787',NULL,'2026-02-01 15:18:04.481062',654,654,NULL,'df892bdf-5a9d-4dde-95c2-85026abba02c',190,'120c1822ab9548c2815485bc30d42a55','snapshot_gigabytes',-1,'2026-02-02 15:18:04','9e8345c3-c425-444a-948b-e657e9fcd15d'),('2026-02-01 15:18:08.055020',NULL,'2026-02-01 15:18:08.074668',655,655,'3cf00994b85e4b779e6717ae76e983b5','c5d6a9c2-0a98-4d4e-97af-7ff625a391af',187,'368b363545bf449ebeb73c7917747ead','shares',-1,'2026-02-02 15:18:08',NULL),('2026-02-01 15:18:08.056120',NULL,'2026-02-01 15:18:08.074668',656,656,'3cf00994b85e4b779e6717ae76e983b5','c4b74d57-ba1a-454a-bc1a-3d8de1a93309',186,'368b363545bf449ebeb73c7917747ead','gigabytes',-1,'2026-02-02 15:18:08',NULL),('2026-02-01 15:18:08.060482',NULL,'2026-02-01 15:18:08.080780',657,657,'746730afb3db4d7f80045269f8973474','1d78835f-5796-4230-ad6f-a05d139e3b7c',170,'120c1822ab9548c2815485bc30d42a55','shares',-1,'2026-02-02 15:18:08',NULL),('2026-02-01 15:18:08.061168',NULL,'2026-02-01 15:18:08.080780',658,658,'746730afb3db4d7f80045269f8973474','cd301627-942c-4a13-a565-4794fd7bad66',169,'120c1822ab9548c2815485bc30d42a55','gigabytes',-1,'2026-02-02 15:18:08',NULL),('2026-02-01 15:18:08.064447',NULL,'2026-02-01 15:18:08.074668',659,659,NULL,'c822b575-afe3-4435-bd7b-47f588e996b2',189,'368b363545bf449ebeb73c7917747ead','shares',-1,'2026-02-02 15:18:08','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:18:08.065231',NULL,'2026-02-01 15:18:08.074668',660,660,NULL,'d9f4b6bb-01a2-45e7-aad8-e30682be7cbe',188,'368b363545bf449ebeb73c7917747ead','gigabytes',-1,'2026-02-02 15:18:08','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:18:08.070183',NULL,'2026-02-01 15:18:08.080780',661,661,NULL,'370ff873-5c82-4cce-b2eb-6f92b932e04c',185,'120c1822ab9548c2815485bc30d42a55','shares',-1,'2026-02-02 15:18:08','9e8345c3-c425-444a-948b-e657e9fcd15d'),('2026-02-01 15:18:08.071127',NULL,'2026-02-01 15:18:08.080780',662,662,NULL,'be6d9d7d-d939-42f8-a6c0-52ad95e17055',184,'120c1822ab9548c2815485bc30d42a55','gigabytes',-1,'2026-02-02 15:18:08','9e8345c3-c425-444a-948b-e657e9fcd15d'),('2026-02-01 15:18:11.889613',NULL,'2026-02-01 15:18:11.903486',663,663,'3cf00994b85e4b779e6717ae76e983b5','fad3960d-3091-45d2-9a8b-f92f41e9b71a',193,'368b363545bf449ebeb73c7917747ead','snapshots',-1,'2026-02-02 15:18:11',NULL),('2026-02-01 15:18:11.890307',NULL,'2026-02-01 15:18:11.903486',664,664,'3cf00994b85e4b779e6717ae76e983b5','d473b3a5-d6eb-45e4-a5a2-9fbd6548f462',192,'368b363545bf449ebeb73c7917747ead','snapshot_gigabytes',-1,'2026-02-02 15:18:11',NULL),('2026-02-01 15:18:11.895800',NULL,'2026-02-01 15:18:11.903486',665,665,NULL,'66469836-1f5b-4678-b70d-f9570db935b6',195,'368b363545bf449ebeb73c7917747ead','snapshots',-1,'2026-02-02 15:18:11','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:18:11.896654',NULL,'2026-02-01 15:18:11.903486',666,666,NULL,'17f5d3c7-d54e-4eec-a0e8-efa4a910d18f',194,'368b363545bf449ebeb73c7917747ead','snapshot_gigabytes',-1,'2026-02-02 15:18:11','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:18:15.421253',NULL,'2026-02-01 15:18:15.433900',667,667,'3cf00994b85e4b779e6717ae76e983b5','9ff93d99-7493-482a-b4e2-24898a7d69ad',187,'368b363545bf449ebeb73c7917747ead','shares',-1,'2026-02-02 15:18:15',NULL),('2026-02-01 15:18:15.422159',NULL,'2026-02-01 15:18:15.433900',668,668,'3cf00994b85e4b779e6717ae76e983b5','4f2f79cf-f5b4-4fd2-8494-7dd58bac4630',186,'368b363545bf449ebeb73c7917747ead','gigabytes',-1,'2026-02-02 15:18:15',NULL),('2026-02-01 15:18:15.427062',NULL,'2026-02-01 15:18:15.433900',669,669,NULL,'92f52ecc-e7c5-4fe3-a328-0beb46c852dd',189,'368b363545bf449ebeb73c7917747ead','shares',-1,'2026-02-02 15:18:15','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:18:15.427645',NULL,'2026-02-01 15:18:15.433900',670,670,NULL,'06c7eaca-30ec-412f-a569-0b1c0c1d2555',188,'368b363545bf449ebeb73c7917747ead','gigabytes',-1,'2026-02-02 15:18:15','9438b119-75d0-4d28-9efc-827b70bc86e1'),('2026-02-01 15:18:19.666488',NULL,'2026-02-01 15:18:19.697492',671,671,'6868c6d8625240428c32f8df11c67fd6','a9e0fe33-e82a-4934-805d-f4c3cf572dcb',204,'8b0415f100a1429bba93cf802c51baee','share_networks',1,'2026-02-02 15:18:19',NULL),('2026-02-01 15:18:20.043534',NULL,'2026-02-01 15:18:20.079956',672,672,'a6d2572f8b864e0793ea67a069edbe05','249ec2d5-8aa8-4c27-9814-415cf6c7d8d7',206,'40dced376e0d4d23b2b7de2c3fc8bd0e','shares',1,'2026-02-02 15:18:20',NULL),('2026-02-01 15:18:20.044707',NULL,'2026-02-01 15:18:20.079956',673,673,'a6d2572f8b864e0793ea67a069edbe05','28cf6367-dc92-4e36-b2ca-404806d5ccf2',205,'40dced376e0d4d23b2b7de2c3fc8bd0e','gigabytes',1,'2026-02-02 15:18:20',NULL),('2026-02-01 15:18:20.055102',NULL,'2026-02-01 15:18:20.079956',674,674,NULL,'bed30688-c42a-4276-8792-3e10aba419fc',208,'40dced376e0d4d23b2b7de2c3fc8bd0e','shares',1,'2026-02-02 15:18:20','83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:18:20.056082',NULL,'2026-02-01 15:18:20.079956',675,675,NULL,'4ca076b9-16c1-4be0-89b0-682809307e4d',207,'40dced376e0d4d23b2b7de2c3fc8bd0e','gigabytes',1,'2026-02-02 15:18:20','83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:18:20.347497',NULL,'2026-02-01 15:18:20.353017',676,676,'6868c6d8625240428c32f8df11c67fd6','6b4bb5b3-a821-41a3-b743-7b9c0ea9b505',204,'8b0415f100a1429bba93cf802c51baee','share_networks',-1,'2026-02-02 15:18:20',NULL),('2026-02-01 15:18:20.637544',NULL,'2026-02-01 15:18:20.681581',677,677,'6868c6d8625240428c32f8df11c67fd6','f6123edc-bb01-47df-8147-d8f87fdd031c',204,'8b0415f100a1429bba93cf802c51baee','share_networks',1,'2026-02-02 15:18:20',NULL),('2026-02-01 15:18:21.346613',NULL,'2026-02-01 15:18:21.354194',678,678,'6868c6d8625240428c32f8df11c67fd6','3c62ff0b-6a37-4e31-8871-a9f1828d74b1',204,'8b0415f100a1429bba93cf802c51baee','share_networks',-1,'2026-02-02 15:18:21',NULL),('2026-02-01 15:18:21.555190',NULL,'2026-02-01 15:18:21.599120',679,679,'6868c6d8625240428c32f8df11c67fd6','039be3d6-5f39-46b6-936f-0f5f62ad319e',204,'8b0415f100a1429bba93cf802c51baee','share_networks',1,'2026-02-02 15:18:21',NULL),('2026-02-01 15:18:22.410622',NULL,'2026-02-01 15:18:22.417644',680,680,'6868c6d8625240428c32f8df11c67fd6','de5df694-564d-409f-923b-3c53d98a08e0',204,'8b0415f100a1429bba93cf802c51baee','share_networks',-1,'2026-02-02 15:18:22',NULL),('2026-02-01 15:18:23.615038',NULL,'2026-02-01 15:18:23.698225',681,681,'a6d2572f8b864e0793ea67a069edbe05','43fcea16-2f9b-4fe4-9758-fa2897fb053b',210,'40dced376e0d4d23b2b7de2c3fc8bd0e','snapshots',1,'2026-02-02 15:18:23',NULL),('2026-02-01 15:18:23.616711',NULL,'2026-02-01 15:18:23.698225',682,682,'a6d2572f8b864e0793ea67a069edbe05','e95f3a65-86c5-49f1-a8cc-b05bc84e567a',209,'40dced376e0d4d23b2b7de2c3fc8bd0e','snapshot_gigabytes',1,'2026-02-02 15:18:23',NULL),('2026-02-01 15:18:23.628086',NULL,'2026-02-01 15:18:23.698225',683,683,NULL,'ef284635-4195-44f1-b558-863b23597bf7',212,'40dced376e0d4d23b2b7de2c3fc8bd0e','snapshots',1,'2026-02-02 15:18:23','83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:18:23.629276',NULL,'2026-02-01 15:18:23.698225',684,684,NULL,'5578fd34-5cb0-41f0-8e48-0a80bcae80dd',211,'40dced376e0d4d23b2b7de2c3fc8bd0e','snapshot_gigabytes',1,'2026-02-02 15:18:23','83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:18:24.266144',NULL,'2026-02-01 15:18:24.319757',685,685,'a6d2572f8b864e0793ea67a069edbe05','28590156-fedc-4aac-bcdc-6999516d1488',206,'40dced376e0d4d23b2b7de2c3fc8bd0e','shares',1,'2026-02-02 15:18:24',NULL),('2026-02-01 15:18:24.267768',NULL,'2026-02-01 15:18:24.319757',686,686,'a6d2572f8b864e0793ea67a069edbe05','1e74c346-f7bd-4928-bf9a-3fef3dd2833a',205,'40dced376e0d4d23b2b7de2c3fc8bd0e','gigabytes',1,'2026-02-02 15:18:24',NULL),('2026-02-01 15:18:24.287668',NULL,'2026-02-01 15:18:24.319757',687,687,NULL,'58f1bc08-4edc-4d95-a535-9249162d41e3',208,'40dced376e0d4d23b2b7de2c3fc8bd0e','shares',1,'2026-02-02 15:18:24','83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:18:24.290863',NULL,'2026-02-01 15:18:24.319757',688,688,NULL,'a1142592-70cc-4d67-9052-6a83889ee067',207,'40dced376e0d4d23b2b7de2c3fc8bd0e','gigabytes',1,'2026-02-02 15:18:24','83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:18:26.225218',NULL,'2026-02-01 15:18:26.278868',689,689,'24edeab99fbb48d7b16cdeb517c6a575','c07b2669-c4bc-4336-8f5d-07de6cd34f99',214,'5d1e833d258140798bbddb15095488d9','shares',1,'2026-02-02 15:18:26',NULL),('2026-02-01 15:18:26.226709',NULL,'2026-02-01 15:18:26.278868',690,690,'24edeab99fbb48d7b16cdeb517c6a575','a5828f72-ee89-4bca-9b29-13a109140e40',213,'5d1e833d258140798bbddb15095488d9','gigabytes',2,'2026-02-02 15:18:26',NULL),('2026-02-01 15:18:26.242234',NULL,'2026-02-01 15:18:26.278868',691,691,NULL,'379c827d-3ec4-4882-aa84-1c4be35e82d0',216,'5d1e833d258140798bbddb15095488d9','shares',1,'2026-02-02 15:18:26','c2e98db5-6825-4e4c-8366-569c74530e00'),('2026-02-01 15:18:26.243844',NULL,'2026-02-01 15:18:26.278868',692,692,NULL,'ccc55485-8e46-4365-9843-e95acca6da22',215,'5d1e833d258140798bbddb15095488d9','gigabytes',2,'2026-02-02 15:18:26','c2e98db5-6825-4e4c-8366-569c74530e00'),('2026-02-01 15:18:28.329681',NULL,'2026-02-01 15:18:28.358308',693,693,'b941253886a049d88d77c1e476049e76','02fb8bdb-2a1b-4037-80ab-c763efee0383',217,'563730bce3db420f8fb732bed1fdd719','share_networks',1,'2026-02-02 15:18:28',NULL),('2026-02-01 15:18:28.461727',NULL,'2026-02-01 15:18:28.489986',694,694,'b941253886a049d88d77c1e476049e76','2cc5a2ae-29f5-4e44-98f9-4d008a32437f',217,'563730bce3db420f8fb732bed1fdd719','share_networks',1,'2026-02-02 15:18:28',NULL),('2026-02-01 15:18:28.979599',NULL,'2026-02-01 15:18:28.987697',695,695,'b941253886a049d88d77c1e476049e76','64a1f5f5-bd57-4ddc-8eec-14081fc26960',217,'563730bce3db420f8fb732bed1fdd719','share_networks',-1,'2026-02-02 15:18:28',NULL),('2026-02-01 15:18:29.138732',NULL,'2026-02-01 15:18:29.168616',696,696,'b941253886a049d88d77c1e476049e76','fe358401-3c66-46f0-8c0e-98bffa178c18',217,'563730bce3db420f8fb732bed1fdd719','share_networks',1,'2026-02-02 15:18:29',NULL),('2026-02-01 15:18:29.686215',NULL,'2026-02-01 15:18:29.692851',697,697,'b941253886a049d88d77c1e476049e76','eba321bf-78c2-4209-9928-82f4a0d89e17',217,'563730bce3db420f8fb732bed1fdd719','share_networks',-1,'2026-02-02 15:18:29',NULL),('2026-02-01 15:18:29.750097',NULL,'2026-02-01 15:18:29.847516',698,698,'24edeab99fbb48d7b16cdeb517c6a575','aafe3cbb-6fe0-44bc-bff5-7c45534ea688',219,'5d1e833d258140798bbddb15095488d9','snapshots',1,'2026-02-02 15:18:29',NULL),('2026-02-01 15:18:29.751459',NULL,'2026-02-01 15:18:29.847516',699,699,'24edeab99fbb48d7b16cdeb517c6a575','d2fdd0ef-87f9-45a0-aa08-c6551d5c133c',218,'5d1e833d258140798bbddb15095488d9','snapshot_gigabytes',2,'2026-02-02 15:18:29',NULL),('2026-02-01 15:18:29.763868',NULL,'2026-02-01 15:18:29.847516',700,700,NULL,'ad55d284-f5e8-4a33-bea1-83f53d82b585',221,'5d1e833d258140798bbddb15095488d9','snapshots',1,'2026-02-02 15:18:29','c2e98db5-6825-4e4c-8366-569c74530e00'),('2026-02-01 15:18:29.765666',NULL,'2026-02-01 15:18:29.847516',701,701,NULL,'cec8349c-8c65-45f1-bb51-c5e4e3dbb4fc',220,'5d1e833d258140798bbddb15095488d9','snapshot_gigabytes',2,'2026-02-02 15:18:29','c2e98db5-6825-4e4c-8366-569c74530e00'),('2026-02-01 15:18:34.287379',NULL,'2026-02-01 15:18:34.321553',702,702,'24edeab99fbb48d7b16cdeb517c6a575','f61fd686-eb19-4a92-8cef-f93cf6ee18db',219,'5d1e833d258140798bbddb15095488d9','snapshots',-1,'2026-02-02 15:18:34',NULL),('2026-02-01 15:18:34.288159',NULL,'2026-02-01 15:18:34.321553',703,703,'24edeab99fbb48d7b16cdeb517c6a575','46153654-2273-4433-9ae2-ebcee530c835',218,'5d1e833d258140798bbddb15095488d9','snapshot_gigabytes',-2,'2026-02-02 15:18:34',NULL),('2026-02-01 15:18:34.296131',NULL,'2026-02-01 15:18:34.321553',704,704,NULL,'e19648fa-6af6-4946-86fa-a36b43f1fff9',221,'5d1e833d258140798bbddb15095488d9','snapshots',-1,'2026-02-02 15:18:34','c2e98db5-6825-4e4c-8366-569c74530e00'),('2026-02-01 15:18:34.296834',NULL,'2026-02-01 15:18:34.321553',705,705,NULL,'db48be74-5ca7-4d95-b0ba-9416018de6f7',220,'5d1e833d258140798bbddb15095488d9','snapshot_gigabytes',-2,'2026-02-02 15:18:34','c2e98db5-6825-4e4c-8366-569c74530e00'),('2026-02-01 15:18:37.434382',NULL,'2026-02-01 15:18:37.451232',706,706,'24edeab99fbb48d7b16cdeb517c6a575','e57a34ce-226e-4aaf-b5d1-71e1ecab7310',214,'5d1e833d258140798bbddb15095488d9','shares',-1,'2026-02-02 15:18:37',NULL),('2026-02-01 15:18:37.435157',NULL,'2026-02-01 15:18:37.451232',707,707,'24edeab99fbb48d7b16cdeb517c6a575','931ff28d-132a-405b-b7b9-d296efa6e931',213,'5d1e833d258140798bbddb15095488d9','gigabytes',-2,'2026-02-02 15:18:37',NULL),('2026-02-01 15:18:37.442950',NULL,'2026-02-01 15:18:37.451232',708,708,NULL,'4d0333ce-4891-48eb-bb6c-72dfb80281bf',216,'5d1e833d258140798bbddb15095488d9','shares',-1,'2026-02-02 15:18:37','c2e98db5-6825-4e4c-8366-569c74530e00'),('2026-02-01 15:18:37.443658',NULL,'2026-02-01 15:18:37.451232',709,709,NULL,'358bad1f-4536-40cf-87c3-54bcfb670186',215,'5d1e833d258140798bbddb15095488d9','gigabytes',-2,'2026-02-02 15:18:37','c2e98db5-6825-4e4c-8366-569c74530e00'),('2026-02-01 15:18:38.995645',NULL,'2026-02-01 15:18:39.051828',710,710,'f6d8ffe9f1a64b1693065611bbe19c67','d0dfad2e-9150-4d3d-880f-dab434d19e52',223,'7736a9c671f04e42b35558bfde737fc8','shares',1,'2026-02-02 15:18:38',NULL),('2026-02-01 15:18:38.997053',NULL,'2026-02-01 15:18:39.051828',711,711,'f6d8ffe9f1a64b1693065611bbe19c67','9add5500-5af4-47a5-8f13-0dc9e30b419a',222,'7736a9c671f04e42b35558bfde737fc8','gigabytes',1,'2026-02-02 15:18:38',NULL),('2026-02-01 15:18:39.018570',NULL,'2026-02-01 15:18:39.051828',712,712,NULL,'65e7c989-8639-4939-9e95-b3908dd553f5',225,'7736a9c671f04e42b35558bfde737fc8','shares',1,'2026-02-02 15:18:38','deaa419b-0383-4513-8c9a-24b9d74cd8e2'),('2026-02-01 15:18:39.021273',NULL,'2026-02-01 15:18:39.051828',713,713,NULL,'0f3a27aa-c9ef-450b-9a8d-b3c44eb471e3',224,'7736a9c671f04e42b35558bfde737fc8','gigabytes',1,'2026-02-02 15:18:38','deaa419b-0383-4513-8c9a-24b9d74cd8e2'),('2026-02-01 15:18:40.563010',NULL,'2026-02-01 15:18:40.606581',714,714,'24edeab99fbb48d7b16cdeb517c6a575','aec94025-c8c6-44e6-8044-f7631ccab4a0',214,'5d1e833d258140798bbddb15095488d9','shares',1,'2026-02-02 15:18:40',NULL),('2026-02-01 15:18:40.564625',NULL,'2026-02-01 15:18:40.606581',715,715,'24edeab99fbb48d7b16cdeb517c6a575','3d5bdeb6-802d-4b8b-8814-d2fb3b33a7e4',213,'5d1e833d258140798bbddb15095488d9','gigabytes',1,'2026-02-02 15:18:40',NULL),('2026-02-01 15:18:40.571992',NULL,'2026-02-01 15:18:40.606581',716,716,NULL,'a5ee12c8-36f0-4d2c-8f79-79a0a3a91fb4',216,'5d1e833d258140798bbddb15095488d9','shares',1,'2026-02-02 15:18:40','c2e98db5-6825-4e4c-8366-569c74530e00'),('2026-02-01 15:18:40.573657',NULL,'2026-02-01 15:18:40.606581',717,717,NULL,'8f2548c1-adb5-4065-86a9-181896c70108',215,'5d1e833d258140798bbddb15095488d9','gigabytes',1,'2026-02-02 15:18:40','c2e98db5-6825-4e4c-8366-569c74530e00'),('2026-02-01 15:18:42.694240',NULL,'2026-02-01 15:18:42.830313',718,718,'b4519508f74d4e4bab6f8c3da6388d49','ee1295f6-52b6-4a10-883f-dd2aba977011',227,'2c31b44d86274d9c9323bcb7f0a754dd','shares',1,'2026-02-02 15:18:42',NULL),('2026-02-01 15:18:42.696903',NULL,'2026-02-01 15:18:42.830313',719,719,'b4519508f74d4e4bab6f8c3da6388d49','2d3180b1-6e74-4e53-ac0d-2c95037a9b2a',226,'2c31b44d86274d9c9323bcb7f0a754dd','gigabytes',1,'2026-02-02 15:18:42',NULL),('2026-02-01 15:18:42.716854',NULL,'2026-02-01 15:18:42.837826',720,720,'b4519508f74d4e4bab6f8c3da6388d49','705f0722-173e-4f82-91ee-6e704f1664a9',229,'7736a9c671f04e42b35558bfde737fc8','shares',-1,'2026-02-02 15:18:42',NULL),('2026-02-01 15:18:42.717574',NULL,'2026-02-01 15:18:42.837826',721,721,'b4519508f74d4e4bab6f8c3da6388d49','96cec9e8-bd65-4cf1-ae02-8c69ccdda307',228,'7736a9c671f04e42b35558bfde737fc8','gigabytes',-1,'2026-02-02 15:18:42',NULL),('2026-02-01 15:18:44.054550',NULL,'2026-02-01 15:18:44.086908',722,722,'b4519508f74d4e4bab6f8c3da6388d49','ed38e4d2-cf53-47a7-8f95-d0dbafef7a06',227,'2c31b44d86274d9c9323bcb7f0a754dd','shares',-1,'2026-02-02 15:18:43',NULL),('2026-02-01 15:18:44.055666',NULL,'2026-02-01 15:18:44.086908',723,723,'b4519508f74d4e4bab6f8c3da6388d49','7973982c-9c1b-456a-86e7-e1ed36b61d1c',226,'2c31b44d86274d9c9323bcb7f0a754dd','gigabytes',-1,'2026-02-02 15:18:43',NULL),('2026-02-01 15:18:44.071709',NULL,'2026-02-01 15:18:44.086908',724,724,NULL,'b8ede42b-2295-4dcb-922c-31ad40485189',231,'2c31b44d86274d9c9323bcb7f0a754dd','shares',-1,'2026-02-02 15:18:43','deaa419b-0383-4513-8c9a-24b9d74cd8e2'),('2026-02-01 15:18:44.072561',NULL,'2026-02-01 15:18:44.086908',725,725,NULL,'222fcdf2-9394-4fc5-91ce-0a2b86e4f0a6',230,'2c31b44d86274d9c9323bcb7f0a754dd','gigabytes',-1,'2026-02-02 15:18:43','deaa419b-0383-4513-8c9a-24b9d74cd8e2'),('2026-02-01 15:18:44.072654',NULL,'2026-02-01 15:18:44.166529',726,726,'24edeab99fbb48d7b16cdeb517c6a575','cd59216e-3b63-4eaa-8a42-714ac1bbdfc0',219,'5d1e833d258140798bbddb15095488d9','snapshots',1,'2026-02-02 15:18:44',NULL),('2026-02-01 15:18:44.074246',NULL,'2026-02-01 15:18:44.166529',727,727,'24edeab99fbb48d7b16cdeb517c6a575','e160a57e-3a9c-4d64-9dd4-f80e5da15fc9',218,'5d1e833d258140798bbddb15095488d9','snapshot_gigabytes',1,'2026-02-02 15:18:44',NULL),('2026-02-01 15:18:44.082310',NULL,'2026-02-01 15:18:44.166529',728,728,NULL,'e5ea847a-4a98-4325-a4e3-2b78bcad2a8d',221,'5d1e833d258140798bbddb15095488d9','snapshots',1,'2026-02-02 15:18:44','c2e98db5-6825-4e4c-8366-569c74530e00'),('2026-02-01 15:18:44.083686',NULL,'2026-02-01 15:18:44.166529',729,729,NULL,'3ebc5388-6206-4677-98ea-499eb7e07c48',220,'5d1e833d258140798bbddb15095488d9','snapshot_gigabytes',1,'2026-02-02 15:18:44','c2e98db5-6825-4e4c-8366-569c74530e00'),('2026-02-01 15:18:46.659316',NULL,'2026-02-01 15:18:46.715106',730,730,'f6d8ffe9f1a64b1693065611bbe19c67','c6b432aa-a22c-44eb-8323-e08e16af6dc8',223,'7736a9c671f04e42b35558bfde737fc8','shares',1,'2026-02-02 15:18:46',NULL),('2026-02-01 15:18:46.661182',NULL,'2026-02-01 15:18:46.715106',731,731,'f6d8ffe9f1a64b1693065611bbe19c67','48f8b831-be7c-468d-ac3b-bf688d6f38af',222,'7736a9c671f04e42b35558bfde737fc8','gigabytes',1,'2026-02-02 15:18:46',NULL),('2026-02-01 15:18:46.689176',NULL,'2026-02-01 15:18:46.715106',732,732,NULL,'6cb58323-5a8a-4444-8445-eb5bd61bfdaa',225,'7736a9c671f04e42b35558bfde737fc8','shares',1,'2026-02-02 15:18:46','deaa419b-0383-4513-8c9a-24b9d74cd8e2'),('2026-02-01 15:18:46.691006',NULL,'2026-02-01 15:18:46.715106',733,733,NULL,'34703e1f-c871-46a6-8160-5b7c97d71496',224,'7736a9c671f04e42b35558bfde737fc8','gigabytes',1,'2026-02-02 15:18:46','deaa419b-0383-4513-8c9a-24b9d74cd8e2'),('2026-02-01 15:18:48.419894',NULL,'2026-02-01 15:18:48.433780',734,734,'24edeab99fbb48d7b16cdeb517c6a575','95503100-568d-444a-824b-b769038ed41c',219,'5d1e833d258140798bbddb15095488d9','snapshots',-1,'2026-02-02 15:18:48',NULL),('2026-02-01 15:18:48.420606',NULL,'2026-02-01 15:18:48.433780',735,735,'24edeab99fbb48d7b16cdeb517c6a575','7eb9d9fa-0d64-403d-8b51-3dc3ea14a5ce',218,'5d1e833d258140798bbddb15095488d9','snapshot_gigabytes',-1,'2026-02-02 15:18:48',NULL),('2026-02-01 15:18:48.425396',NULL,'2026-02-01 15:18:48.433780',736,736,NULL,'120b0dcd-2e47-47c8-bcf6-f3d365bc5770',221,'5d1e833d258140798bbddb15095488d9','snapshots',-1,'2026-02-02 15:18:48','c2e98db5-6825-4e4c-8366-569c74530e00'),('2026-02-01 15:18:48.426161',NULL,'2026-02-01 15:18:48.433780',737,737,NULL,'556d222f-ef4d-427d-9dee-b29239f6f027',220,'5d1e833d258140798bbddb15095488d9','snapshot_gigabytes',-1,'2026-02-02 15:18:48','c2e98db5-6825-4e4c-8366-569c74530e00'),('2026-02-01 15:18:51.013780',NULL,'2026-02-01 15:18:51.026790',738,738,'f6d8ffe9f1a64b1693065611bbe19c67','b0251ef4-d09f-4195-a364-aa5b268181bd',223,'7736a9c671f04e42b35558bfde737fc8','shares',-1,'2026-02-02 15:18:50',NULL),('2026-02-01 15:18:51.014508',NULL,'2026-02-01 15:18:51.026790',739,739,'f6d8ffe9f1a64b1693065611bbe19c67','f8ed219b-4696-42a5-94bb-38ecc9aba6f7',222,'7736a9c671f04e42b35558bfde737fc8','gigabytes',-1,'2026-02-02 15:18:50',NULL),('2026-02-01 15:18:51.019528',NULL,'2026-02-01 15:18:51.026790',740,740,NULL,'bdec0564-db81-4e0f-86fd-dac26ba4dbfa',225,'7736a9c671f04e42b35558bfde737fc8','shares',-1,'2026-02-02 15:18:50','deaa419b-0383-4513-8c9a-24b9d74cd8e2'),('2026-02-01 15:18:51.020286',NULL,'2026-02-01 15:18:51.026790',741,741,NULL,'a9decf3f-667d-4301-90c7-340ad6aa2fe2',224,'7736a9c671f04e42b35558bfde737fc8','gigabytes',-1,'2026-02-02 15:18:50','deaa419b-0383-4513-8c9a-24b9d74cd8e2'),('2026-02-01 15:18:51.801748',NULL,'2026-02-01 15:18:51.815234',742,742,'24edeab99fbb48d7b16cdeb517c6a575','048f8a5a-9813-4e62-878a-46cf201113e7',214,'5d1e833d258140798bbddb15095488d9','shares',-1,'2026-02-02 15:18:51',NULL),('2026-02-01 15:18:51.803075',NULL,'2026-02-01 15:18:51.815234',743,743,'24edeab99fbb48d7b16cdeb517c6a575','ba9587fb-3268-4576-8a7f-0f20aa1bdf05',213,'5d1e833d258140798bbddb15095488d9','gigabytes',-1,'2026-02-02 15:18:51',NULL),('2026-02-01 15:18:51.807662',NULL,'2026-02-01 15:18:51.815234',744,744,NULL,'e655d0ee-a601-40f1-8687-0ba6298b781b',216,'5d1e833d258140798bbddb15095488d9','shares',-1,'2026-02-02 15:18:51','c2e98db5-6825-4e4c-8366-569c74530e00'),('2026-02-01 15:18:51.808274',NULL,'2026-02-01 15:18:51.815234',745,745,NULL,'4a973684-bd6d-46e9-9306-a9f5f6de3010',215,'5d1e833d258140798bbddb15095488d9','gigabytes',-1,'2026-02-02 15:18:51','c2e98db5-6825-4e4c-8366-569c74530e00'),('2026-02-01 15:19:02.557273',NULL,'2026-02-01 15:19:02.597174',746,746,'a6d2572f8b864e0793ea67a069edbe05','d490bde4-47e8-4546-ae71-299f8cf118ad',206,'40dced376e0d4d23b2b7de2c3fc8bd0e','shares',1,'2026-02-02 15:19:02',NULL),('2026-02-01 15:19:02.558904',NULL,'2026-02-01 15:19:02.597174',747,747,'a6d2572f8b864e0793ea67a069edbe05','b275fcf1-ef1a-454b-8bdb-bb89549617ca',205,'40dced376e0d4d23b2b7de2c3fc8bd0e','gigabytes',1,'2026-02-02 15:19:02',NULL),('2026-02-01 15:19:02.573013',NULL,'2026-02-01 15:19:02.597174',748,748,NULL,'5f8c645b-e6e1-440b-abb4-4500543de1d8',208,'40dced376e0d4d23b2b7de2c3fc8bd0e','shares',1,'2026-02-02 15:19:02','83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:19:02.576558',NULL,'2026-02-01 15:19:02.597174',749,749,NULL,'d3edc8f9-3d53-40eb-ad88-abb8b8121354',207,'40dced376e0d4d23b2b7de2c3fc8bd0e','gigabytes',1,'2026-02-02 15:19:02','83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:19:03.456216',NULL,'2026-02-01 15:19:03.500837',750,750,'5a9e48d8005d427fa422911dd04f4938','a5bcd48a-9468-4de9-b108-9e9e5c2aeee6',233,'754e5daaf01d4d8e91ba62e9ca89a38d','shares',1,'2026-02-02 15:19:03',NULL),('2026-02-01 15:19:03.458318',NULL,'2026-02-01 15:19:03.500837',751,751,'5a9e48d8005d427fa422911dd04f4938','f1022e97-2592-44ab-af24-77668b13a922',232,'754e5daaf01d4d8e91ba62e9ca89a38d','gigabytes',1,'2026-02-02 15:19:03',NULL),('2026-02-01 15:19:03.470766',NULL,'2026-02-01 15:19:03.500837',752,752,NULL,'1f4a6cbe-e7f8-4f00-be05-081cc8d6c3db',235,'754e5daaf01d4d8e91ba62e9ca89a38d','shares',1,'2026-02-02 15:19:03','4f1b79a2-3597-416f-9735-5bd373e5c8ee'),('2026-02-01 15:19:03.472194',NULL,'2026-02-01 15:19:03.500837',753,753,NULL,'49a5315d-553c-4820-9d2b-5872bcd2be39',234,'754e5daaf01d4d8e91ba62e9ca89a38d','gigabytes',1,'2026-02-02 15:19:03','4f1b79a2-3597-416f-9735-5bd373e5c8ee'),('2026-02-01 15:19:06.087684',NULL,'2026-02-01 15:19:06.299578',754,754,'a6d2572f8b864e0793ea67a069edbe05','9c83162b-d6c0-47c2-897d-ce6e840cb498',205,'40dced376e0d4d23b2b7de2c3fc8bd0e','gigabytes',1,'2026-02-02 15:19:06',NULL),('2026-02-01 15:19:06.100750',NULL,'2026-02-01 15:19:06.299578',755,755,NULL,'db7dc662-abea-4ce6-bd26-2455f530097b',207,'40dced376e0d4d23b2b7de2c3fc8bd0e','gigabytes',1,'2026-02-02 15:19:06','83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:19:07.536288',NULL,'2026-02-01 15:19:07.573599',756,756,'5a9e48d8005d427fa422911dd04f4938','086caa87-f6ab-45b9-8e7c-e83032787c66',233,'754e5daaf01d4d8e91ba62e9ca89a38d','shares',1,'2026-02-02 15:19:07',NULL),('2026-02-01 15:19:07.537866',NULL,'2026-02-01 15:19:07.573599',757,757,'5a9e48d8005d427fa422911dd04f4938','feff345d-e82f-4b08-8290-6d210e6f8da6',232,'754e5daaf01d4d8e91ba62e9ca89a38d','gigabytes',1,'2026-02-02 15:19:07',NULL),('2026-02-01 15:19:07.544597',NULL,'2026-02-01 15:19:07.573599',758,758,NULL,'b20d4dd9-5187-4509-9d2f-c1d9a536fa30',235,'754e5daaf01d4d8e91ba62e9ca89a38d','shares',1,'2026-02-02 15:19:07','4f1b79a2-3597-416f-9735-5bd373e5c8ee'),('2026-02-01 15:19:07.546023',NULL,'2026-02-01 15:19:07.573599',759,759,NULL,'592336bd-7a12-4693-9e76-b57c775c1684',234,'754e5daaf01d4d8e91ba62e9ca89a38d','gigabytes',1,'2026-02-02 15:19:07','4f1b79a2-3597-416f-9735-5bd373e5c8ee'),('2026-02-01 15:19:09.972639',NULL,'2026-02-01 15:19:09.986865',760,760,'a6d2572f8b864e0793ea67a069edbe05','b271ad9f-7287-41bd-847c-31f4b0efe532',206,'40dced376e0d4d23b2b7de2c3fc8bd0e','shares',-1,'2026-02-02 15:19:09',NULL),('2026-02-01 15:19:09.973355',NULL,'2026-02-01 15:19:09.986865',761,761,'a6d2572f8b864e0793ea67a069edbe05','f887aa98-4f9d-44fc-9deb-353089136737',205,'40dced376e0d4d23b2b7de2c3fc8bd0e','gigabytes',-2,'2026-02-02 15:19:09',NULL),('2026-02-01 15:19:09.978914',NULL,'2026-02-01 15:19:09.986865',762,762,NULL,'ab5d2cf0-c1aa-4272-b0fe-944de89c0ddc',208,'40dced376e0d4d23b2b7de2c3fc8bd0e','shares',-1,'2026-02-02 15:19:09','83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:19:09.979608',NULL,'2026-02-01 15:19:09.986865',763,763,NULL,'9c7b7410-2f34-48c0-89a3-506c36e247ec',207,'40dced376e0d4d23b2b7de2c3fc8bd0e','gigabytes',-2,'2026-02-02 15:19:09','83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:19:11.465297',NULL,'2026-02-01 15:19:11.506431',764,764,'5a9e48d8005d427fa422911dd04f4938','cde03d76-ae2b-47e0-9d59-4a021e059ff2',233,'754e5daaf01d4d8e91ba62e9ca89a38d','shares',1,'2026-02-02 15:19:11',NULL),('2026-02-01 15:19:11.469393',NULL,'2026-02-01 15:19:11.506431',765,765,'5a9e48d8005d427fa422911dd04f4938','59b649ab-ad13-4d9c-9fc4-fadf9831d195',232,'754e5daaf01d4d8e91ba62e9ca89a38d','gigabytes',1,'2026-02-02 15:19:11',NULL),('2026-02-01 15:19:11.478478',NULL,'2026-02-01 15:19:11.506431',766,766,NULL,'854d610c-538d-414c-89dd-5ba63eb114f5',235,'754e5daaf01d4d8e91ba62e9ca89a38d','shares',1,'2026-02-02 15:19:11','4f1b79a2-3597-416f-9735-5bd373e5c8ee'),('2026-02-01 15:19:11.479851',NULL,'2026-02-01 15:19:11.506431',767,767,NULL,'bd9ffe1c-9cb8-4d85-9f22-4fb3a5f9b2e7',234,'754e5daaf01d4d8e91ba62e9ca89a38d','gigabytes',1,'2026-02-02 15:19:11','4f1b79a2-3597-416f-9735-5bd373e5c8ee'),('2026-02-01 15:19:15.560732',NULL,'2026-02-01 15:19:15.602615',768,768,'5a9e48d8005d427fa422911dd04f4938','6c5165d7-f6e6-4f4f-a2b5-6bb9c0deb7b0',233,'754e5daaf01d4d8e91ba62e9ca89a38d','shares',1,'2026-02-02 15:19:15',NULL),('2026-02-01 15:19:15.563053',NULL,'2026-02-01 15:19:15.602615',769,769,'5a9e48d8005d427fa422911dd04f4938','c8365459-bcbd-4735-921b-d06555e2c03d',232,'754e5daaf01d4d8e91ba62e9ca89a38d','gigabytes',1,'2026-02-02 15:19:15',NULL),('2026-02-01 15:19:15.570792',NULL,'2026-02-01 15:19:15.602615',770,770,NULL,'bf00f363-1b46-4238-958e-1c81566d33ab',235,'754e5daaf01d4d8e91ba62e9ca89a38d','shares',1,'2026-02-02 15:19:15','4f1b79a2-3597-416f-9735-5bd373e5c8ee'),('2026-02-01 15:19:15.572300',NULL,'2026-02-01 15:19:15.602615',771,771,NULL,'630c7cc3-0ee3-4577-bbe3-cc3fd80f2ba2',234,'754e5daaf01d4d8e91ba62e9ca89a38d','gigabytes',1,'2026-02-02 15:19:15','4f1b79a2-3597-416f-9735-5bd373e5c8ee'),('2026-02-01 15:19:17.840280',NULL,'2026-02-01 15:19:17.869086',772,772,'a6d2572f8b864e0793ea67a069edbe05','9eab7c9f-7a86-43c3-a7d4-01f23d4abc59',206,'40dced376e0d4d23b2b7de2c3fc8bd0e','shares',1,'2026-02-02 15:19:17',NULL),('2026-02-01 15:19:17.841890',NULL,'2026-02-01 15:19:17.869086',773,773,'a6d2572f8b864e0793ea67a069edbe05','0a45c7aa-6694-4833-9227-647d13d30538',205,'40dced376e0d4d23b2b7de2c3fc8bd0e','gigabytes',2,'2026-02-02 15:19:17',NULL),('2026-02-01 15:19:17.847209',NULL,'2026-02-01 15:19:17.869086',774,774,NULL,'02fd493a-0dc2-444a-9d6c-47b6b92f62d0',208,'40dced376e0d4d23b2b7de2c3fc8bd0e','shares',1,'2026-02-02 15:19:17','83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:19:17.848421',NULL,'2026-02-01 15:19:17.869086',775,775,NULL,'c89c7b83-c355-435c-b082-6b833a66d7d1',207,'40dced376e0d4d23b2b7de2c3fc8bd0e','gigabytes',2,'2026-02-02 15:19:17','83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:19:20.712921',NULL,'2026-02-01 15:19:20.727331',776,776,'5a9e48d8005d427fa422911dd04f4938','a24459cc-db55-4f05-a624-eccc6212da20',233,'754e5daaf01d4d8e91ba62e9ca89a38d','shares',-1,'2026-02-02 15:19:20',NULL),('2026-02-01 15:19:20.713680',NULL,'2026-02-01 15:19:20.727331',777,777,'5a9e48d8005d427fa422911dd04f4938','8e9d7e34-c050-41a0-adf6-cc6ebbd19734',232,'754e5daaf01d4d8e91ba62e9ca89a38d','gigabytes',-1,'2026-02-02 15:19:20',NULL),('2026-02-01 15:19:20.720033',NULL,'2026-02-01 15:19:20.727331',778,778,NULL,'cf7b03d0-d457-4e20-b725-b4d9d10dc42d',235,'754e5daaf01d4d8e91ba62e9ca89a38d','shares',-1,'2026-02-02 15:19:20','4f1b79a2-3597-416f-9735-5bd373e5c8ee'),('2026-02-01 15:19:20.720811',NULL,'2026-02-01 15:19:20.727331',779,779,NULL,'f139a0d6-661e-4011-9fc6-b6ee7227042e',234,'754e5daaf01d4d8e91ba62e9ca89a38d','gigabytes',-1,'2026-02-02 15:19:20','4f1b79a2-3597-416f-9735-5bd373e5c8ee'),('2026-02-01 15:19:21.350706',NULL,'2026-02-01 15:19:21.390397',780,780,'a6d2572f8b864e0793ea67a069edbe05','98528e7f-303d-401b-81a7-df333ac1f927',205,'40dced376e0d4d23b2b7de2c3fc8bd0e','gigabytes',-1,'2026-02-02 15:19:21',NULL),('2026-02-01 15:19:21.358292',NULL,'2026-02-01 15:19:21.390397',781,781,NULL,'2bb1065b-a386-4948-954a-412a0fc8c476',207,'40dced376e0d4d23b2b7de2c3fc8bd0e','gigabytes',-1,'2026-02-02 15:19:21','83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:19:24.304439',NULL,'2026-02-01 15:19:24.319440',782,782,'5a9e48d8005d427fa422911dd04f4938','24f6cb87-e63c-4ee5-9bca-a7dcc61dfbac',233,'754e5daaf01d4d8e91ba62e9ca89a38d','shares',-1,'2026-02-02 15:19:24',NULL),('2026-02-01 15:19:24.306727',NULL,'2026-02-01 15:19:24.319440',783,783,'5a9e48d8005d427fa422911dd04f4938','35bb5711-9465-4717-a682-5a292b34f14e',232,'754e5daaf01d4d8e91ba62e9ca89a38d','gigabytes',-1,'2026-02-02 15:19:24',NULL),('2026-02-01 15:19:24.312418',NULL,'2026-02-01 15:19:24.319440',784,784,NULL,'a8f9367d-a9ca-4127-8130-e3740ebc3cad',235,'754e5daaf01d4d8e91ba62e9ca89a38d','shares',-1,'2026-02-02 15:19:24','4f1b79a2-3597-416f-9735-5bd373e5c8ee'),('2026-02-01 15:19:24.313061',NULL,'2026-02-01 15:19:24.319440',785,785,NULL,'8b5ecd72-3d8d-4c68-b2fa-434b0bdf4e5c',234,'754e5daaf01d4d8e91ba62e9ca89a38d','gigabytes',-1,'2026-02-02 15:19:24','4f1b79a2-3597-416f-9735-5bd373e5c8ee'),('2026-02-01 15:19:25.229079',NULL,'2026-02-01 15:19:25.246223',786,786,'a6d2572f8b864e0793ea67a069edbe05','00710ff2-a143-41e4-bc96-30d826eaa857',206,'40dced376e0d4d23b2b7de2c3fc8bd0e','shares',-1,'2026-02-02 15:19:25',NULL),('2026-02-01 15:19:25.229935',NULL,'2026-02-01 15:19:25.246223',787,787,'a6d2572f8b864e0793ea67a069edbe05','9d7ba622-1150-4772-a202-e700fcc02e2a',205,'40dced376e0d4d23b2b7de2c3fc8bd0e','gigabytes',-1,'2026-02-02 15:19:25',NULL),('2026-02-01 15:19:25.238080',NULL,'2026-02-01 15:19:25.246223',788,788,NULL,'fe29ec02-2b9c-4cc7-ac9a-ba784ff849de',208,'40dced376e0d4d23b2b7de2c3fc8bd0e','shares',-1,'2026-02-02 15:19:25','83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:19:25.238825',NULL,'2026-02-01 15:19:25.246223',789,789,NULL,'8e52cee4-33b6-4d65-8dec-83c82f337bd0',207,'40dced376e0d4d23b2b7de2c3fc8bd0e','gigabytes',-1,'2026-02-02 15:19:25','83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:19:27.814462',NULL,'2026-02-01 15:19:27.835728',790,790,'5a9e48d8005d427fa422911dd04f4938','93d1486f-706b-462d-836c-8bb2fe7fd798',233,'754e5daaf01d4d8e91ba62e9ca89a38d','shares',-1,'2026-02-02 15:19:27',NULL),('2026-02-01 15:19:27.815487',NULL,'2026-02-01 15:19:27.835728',791,791,'5a9e48d8005d427fa422911dd04f4938','22948402-2e40-49ab-81b8-7796e0f47b85',232,'754e5daaf01d4d8e91ba62e9ca89a38d','gigabytes',-1,'2026-02-02 15:19:27',NULL),('2026-02-01 15:19:27.825260',NULL,'2026-02-01 15:19:27.835728',792,792,NULL,'9b923fce-b799-4417-8703-21a88baddbb4',235,'754e5daaf01d4d8e91ba62e9ca89a38d','shares',-1,'2026-02-02 15:19:27','4f1b79a2-3597-416f-9735-5bd373e5c8ee'),('2026-02-01 15:19:27.826274',NULL,'2026-02-01 15:19:27.835728',793,793,NULL,'5d6b00cc-b15c-451c-ad56-877a67d2e952',234,'754e5daaf01d4d8e91ba62e9ca89a38d','gigabytes',-1,'2026-02-02 15:19:27','4f1b79a2-3597-416f-9735-5bd373e5c8ee'),('2026-02-01 15:19:28.107071',NULL,'2026-02-01 15:19:28.141358',794,794,'a6d2572f8b864e0793ea67a069edbe05','43142edd-2708-41f0-a4b8-57bde1c0eb25',206,'40dced376e0d4d23b2b7de2c3fc8bd0e','shares',1,'2026-02-02 15:19:28',NULL),('2026-02-01 15:19:28.108752',NULL,'2026-02-01 15:19:28.141358',795,795,'a6d2572f8b864e0793ea67a069edbe05','6a6650e6-0eda-4222-af77-79f605e57a28',205,'40dced376e0d4d23b2b7de2c3fc8bd0e','gigabytes',1,'2026-02-02 15:19:28',NULL),('2026-02-01 15:19:28.115495',NULL,'2026-02-01 15:19:28.141358',796,796,NULL,'4f77ef1d-5bb3-475d-847d-89d3de44dfdf',208,'40dced376e0d4d23b2b7de2c3fc8bd0e','shares',1,'2026-02-02 15:19:28','83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:19:28.116579',NULL,'2026-02-01 15:19:28.141358',797,797,NULL,'65474529-88af-4aa7-a1c0-d8a49766eec2',207,'40dced376e0d4d23b2b7de2c3fc8bd0e','gigabytes',1,'2026-02-02 15:19:28','83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:19:31.290151',NULL,'2026-02-01 15:19:31.332246',798,798,'5a9e48d8005d427fa422911dd04f4938','f1cceec5-1a91-416c-8725-a3c7c642266b',233,'754e5daaf01d4d8e91ba62e9ca89a38d','shares',-1,'2026-02-02 15:19:31',NULL),('2026-02-01 15:19:31.291039',NULL,'2026-02-01 15:19:31.332246',799,799,'5a9e48d8005d427fa422911dd04f4938','7a861a04-ab38-4d3c-9739-2377d69fa0cf',232,'754e5daaf01d4d8e91ba62e9ca89a38d','gigabytes',-1,'2026-02-02 15:19:31',NULL),('2026-02-01 15:19:31.302707',NULL,'2026-02-01 15:19:31.332246',800,800,NULL,'6148b070-a05d-4f54-a5fd-50b8579ce91f',235,'754e5daaf01d4d8e91ba62e9ca89a38d','shares',-1,'2026-02-02 15:19:31','4f1b79a2-3597-416f-9735-5bd373e5c8ee'),('2026-02-01 15:19:31.303556',NULL,'2026-02-01 15:19:31.332246',801,801,NULL,'05921f22-fec5-4b5c-ac48-190dabcd6a71',234,'754e5daaf01d4d8e91ba62e9ca89a38d','gigabytes',-1,'2026-02-02 15:19:31','4f1b79a2-3597-416f-9735-5bd373e5c8ee'),('2026-02-01 15:19:33.421006',NULL,'2026-02-01 15:19:33.440032',802,802,'a6d2572f8b864e0793ea67a069edbe05','ffd5266b-220e-4271-bcd0-9582e78a48ec',206,'40dced376e0d4d23b2b7de2c3fc8bd0e','shares',-1,'2026-02-02 15:19:33',NULL),('2026-02-01 15:19:33.424295',NULL,'2026-02-01 15:19:33.440032',803,803,'a6d2572f8b864e0793ea67a069edbe05','fe1166ad-74a8-46a0-89dc-e54d980f362a',205,'40dced376e0d4d23b2b7de2c3fc8bd0e','gigabytes',-1,'2026-02-02 15:19:33',NULL),('2026-02-01 15:19:33.430791',NULL,'2026-02-01 15:19:33.440032',804,804,NULL,'efddfa2e-c922-4ad7-921c-c757ee50a7e1',208,'40dced376e0d4d23b2b7de2c3fc8bd0e','shares',-1,'2026-02-02 15:19:33','83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:19:33.431656',NULL,'2026-02-01 15:19:33.440032',805,805,NULL,'a2f91cf7-45cd-4dfc-8ddf-81d751ec4046',207,'40dced376e0d4d23b2b7de2c3fc8bd0e','gigabytes',-1,'2026-02-02 15:19:33','83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:19:36.985152',NULL,'2026-02-01 15:19:37.003837',806,806,'a6d2572f8b864e0793ea67a069edbe05','3feb78e3-60f2-4ca1-90a7-101a1eff7e64',206,'40dced376e0d4d23b2b7de2c3fc8bd0e','shares',-1,'2026-02-02 15:19:36',NULL),('2026-02-01 15:19:36.986240',NULL,'2026-02-01 15:19:37.003837',807,807,'a6d2572f8b864e0793ea67a069edbe05','31ee6a8d-3645-41d4-a53a-3788d121e7bb',205,'40dced376e0d4d23b2b7de2c3fc8bd0e','gigabytes',-1,'2026-02-02 15:19:36',NULL),('2026-02-01 15:19:36.996029',NULL,'2026-02-01 15:19:37.003837',808,808,NULL,'18b97aaa-b965-4d39-93db-81daa2bbed04',208,'40dced376e0d4d23b2b7de2c3fc8bd0e','shares',-1,'2026-02-02 15:19:36','83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:19:36.996771',NULL,'2026-02-01 15:19:37.003837',809,809,NULL,'79544d48-e452-426b-9130-07526ac2e63f',207,'40dced376e0d4d23b2b7de2c3fc8bd0e','gigabytes',-1,'2026-02-02 15:19:36','83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:19:40.396546',NULL,'2026-02-01 15:19:40.415424',810,810,'a6d2572f8b864e0793ea67a069edbe05','29b46d59-539d-4a80-99e2-b62c6e5068b3',210,'40dced376e0d4d23b2b7de2c3fc8bd0e','snapshots',-1,'2026-02-02 15:19:40',NULL),('2026-02-01 15:19:40.397564',NULL,'2026-02-01 15:19:40.415424',811,811,'a6d2572f8b864e0793ea67a069edbe05','f0f0f8d2-cd40-4bd5-999e-02ea06a0db3a',209,'40dced376e0d4d23b2b7de2c3fc8bd0e','snapshot_gigabytes',-1,'2026-02-02 15:19:40',NULL),('2026-02-01 15:19:40.404507',NULL,'2026-02-01 15:19:40.415424',812,812,NULL,'fecf4e56-2c68-4944-a4b9-05ffba585060',212,'40dced376e0d4d23b2b7de2c3fc8bd0e','snapshots',-1,'2026-02-02 15:19:40','83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:19:40.405517',NULL,'2026-02-01 15:19:40.415424',813,813,NULL,'823f1b57-a404-492c-bc9b-0dc5f940ca2e',211,'40dced376e0d4d23b2b7de2c3fc8bd0e','snapshot_gigabytes',-1,'2026-02-02 15:19:40','83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:19:44.006121',NULL,'2026-02-01 15:19:44.035740',814,814,'a6d2572f8b864e0793ea67a069edbe05','9c690988-0241-4e20-9b24-7c0c7a770ded',206,'40dced376e0d4d23b2b7de2c3fc8bd0e','shares',-1,'2026-02-02 15:19:43',NULL),('2026-02-01 15:19:44.006791',NULL,'2026-02-01 15:19:44.035740',815,815,'a6d2572f8b864e0793ea67a069edbe05','c7d8d4ba-78ff-4f38-aca0-09cb117a4fba',205,'40dced376e0d4d23b2b7de2c3fc8bd0e','gigabytes',-1,'2026-02-02 15:19:43',NULL),('2026-02-01 15:19:44.014837',NULL,'2026-02-01 15:19:44.035740',816,816,NULL,'887db47f-5d57-403c-8a25-4e12bccb71e2',208,'40dced376e0d4d23b2b7de2c3fc8bd0e','shares',-1,'2026-02-02 15:19:43','83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:19:44.015888',NULL,'2026-02-01 15:19:44.035740',817,817,NULL,'816632f3-f411-47a4-8b0b-610d88d2f436',207,'40dced376e0d4d23b2b7de2c3fc8bd0e','gigabytes',-1,'2026-02-02 15:19:43','83bac904-ede0-4c77-b192-b7b619e38cb3'),('2026-02-01 15:19:48.932811',NULL,'2026-02-01 15:19:48.983562',818,818,'f69502b1cbbe4323a4b071a11a697d10','03a5cf99-0de4-427c-b048-541f1406ba6e',237,'82efdf20300f4ffda9822c66d6f66684','shares',1,'2026-02-02 15:19:48',NULL),('2026-02-01 15:19:48.934190',NULL,'2026-02-01 15:19:48.983562',819,819,'f69502b1cbbe4323a4b071a11a697d10','7f6b33fd-d176-4463-8266-7ec7a64eed4b',236,'82efdf20300f4ffda9822c66d6f66684','gigabytes',1,'2026-02-02 15:19:48',NULL),('2026-02-01 15:19:48.947626',NULL,'2026-02-01 15:19:48.983562',820,820,NULL,'17ab9577-927a-4ad9-8c2b-334c9f194129',239,'82efdf20300f4ffda9822c66d6f66684','shares',1,'2026-02-02 15:19:48','e6371ab2-3a9c-4858-bc71-54efe991623a'),('2026-02-01 15:19:48.949555',NULL,'2026-02-01 15:19:48.983562',821,821,NULL,'7fb2416e-015e-43da-814e-d4f3e3830075',238,'82efdf20300f4ffda9822c66d6f66684','gigabytes',1,'2026-02-02 15:19:48','e6371ab2-3a9c-4858-bc71-54efe991623a'),('2026-02-01 15:19:51.327431',NULL,'2026-02-01 15:19:51.362348',822,822,'285a33e9d1bd42fb99f40147950702a7','73b1a176-9c2c-4894-aa67-00da85529b61',241,'7043f01f29d441a4801c5afbb65b54e3','shares',1,'2026-02-02 15:19:51',NULL),('2026-02-01 15:19:51.328552',NULL,'2026-02-01 15:19:51.362348',823,823,'285a33e9d1bd42fb99f40147950702a7','b8f26527-7e69-4c43-96cd-ccbd2aed2be2',240,'7043f01f29d441a4801c5afbb65b54e3','gigabytes',1,'2026-02-02 15:19:51',NULL),('2026-02-01 15:19:51.334027',NULL,'2026-02-01 15:19:51.362348',824,824,NULL,'d94a4baf-da8c-4d10-b47b-a8ad6a1cb057',168,'7043f01f29d441a4801c5afbb65b54e3','shares',1,'2026-02-02 15:19:51','5b0c2719-9cba-4adb-b36c-2f65cfd23a4c'),('2026-02-01 15:19:51.335415',NULL,'2026-02-01 15:19:51.362348',825,825,NULL,'e99bccf3-2415-40bd-ba61-416223995914',167,'7043f01f29d441a4801c5afbb65b54e3','gigabytes',1,'2026-02-02 15:19:51','5b0c2719-9cba-4adb-b36c-2f65cfd23a4c'),('2026-02-01 15:19:52.791771',NULL,'2026-02-01 15:19:52.836450',826,826,'f69502b1cbbe4323a4b071a11a697d10','4729aba5-260e-41da-b189-9c08a3a350a3',237,'82efdf20300f4ffda9822c66d6f66684','shares',1,'2026-02-02 15:19:52',NULL),('2026-02-01 15:19:52.794150',NULL,'2026-02-01 15:19:52.836450',827,827,'f69502b1cbbe4323a4b071a11a697d10','152c8c3b-1413-4515-8e17-19a59433bb6b',236,'82efdf20300f4ffda9822c66d6f66684','gigabytes',1,'2026-02-02 15:19:52',NULL),('2026-02-01 15:19:52.804789',NULL,'2026-02-01 15:19:52.836450',828,828,NULL,'90b807c0-5bd9-4eb4-af36-a95d02d2639f',239,'82efdf20300f4ffda9822c66d6f66684','shares',1,'2026-02-02 15:19:52','e6371ab2-3a9c-4858-bc71-54efe991623a'),('2026-02-01 15:19:52.807475',NULL,'2026-02-01 15:19:52.836450',829,829,NULL,'038ee389-8e09-41b0-a82e-894b7c42bea2',238,'82efdf20300f4ffda9822c66d6f66684','gigabytes',1,'2026-02-02 15:19:52','e6371ab2-3a9c-4858-bc71-54efe991623a'),('2026-02-01 15:19:53.693611',NULL,'2026-02-01 15:19:53.712550',830,830,'f69502b1cbbe4323a4b071a11a697d10','ee84a062-8a1b-44ed-bcf3-bf0099923bab',237,'82efdf20300f4ffda9822c66d6f66684','shares',-1,'2026-02-02 15:19:53',NULL),('2026-02-01 15:19:53.695995',NULL,'2026-02-01 15:19:53.712550',831,831,'f69502b1cbbe4323a4b071a11a697d10','9323dfed-c584-4127-98db-06f5ac8fb412',236,'82efdf20300f4ffda9822c66d6f66684','gigabytes',-1,'2026-02-02 15:19:53',NULL),('2026-02-01 15:19:53.704611',NULL,'2026-02-01 15:19:53.712550',832,832,NULL,'91cf508e-a750-47df-9dad-04492ac298ed',239,'82efdf20300f4ffda9822c66d6f66684','shares',-1,'2026-02-02 15:19:53','e6371ab2-3a9c-4858-bc71-54efe991623a'),('2026-02-01 15:19:53.705273',NULL,'2026-02-01 15:19:53.712550',833,833,NULL,'fe8bedea-272c-4878-8dba-6dcdc291cb51',238,'82efdf20300f4ffda9822c66d6f66684','gigabytes',-1,'2026-02-02 15:19:53','e6371ab2-3a9c-4858-bc71-54efe991623a'),('2026-02-01 15:19:56.375420',NULL,'2026-02-01 15:19:56.407609',834,834,'bf5d1db5b7fe40f0ab31649c9864bbbb','998810d4-cca3-4bcd-b74c-88406b6e569b',243,'624202b32e62465ca01f75142b16617c','shares',1,'2026-02-02 15:19:56',NULL),('2026-02-01 15:19:56.376484',NULL,'2026-02-01 15:19:56.407609',835,835,'bf5d1db5b7fe40f0ab31649c9864bbbb','e3f5c20c-cb80-4200-a00b-75891d23eef5',242,'624202b32e62465ca01f75142b16617c','gigabytes',1,'2026-02-02 15:19:56',NULL),('2026-02-01 15:19:56.386407',NULL,'2026-02-01 15:19:56.407609',836,836,NULL,'709c0398-12fe-4de5-aece-d74bdb80d831',245,'624202b32e62465ca01f75142b16617c','shares',1,'2026-02-02 15:19:56','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:19:56.387631',NULL,'2026-02-01 15:19:56.407609',837,837,NULL,'2fda25e1-fd0e-4831-b0d5-f027227c5085',244,'624202b32e62465ca01f75142b16617c','gigabytes',1,'2026-02-02 15:19:56','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:19:57.865054',NULL,'2026-02-01 15:19:57.886298',838,838,'f69502b1cbbe4323a4b071a11a697d10','478fa5c9-e542-4eb6-ad4d-dfd64fcf9743',237,'82efdf20300f4ffda9822c66d6f66684','shares',-1,'2026-02-02 15:19:57',NULL),('2026-02-01 15:19:57.866614',NULL,'2026-02-01 15:19:57.886298',839,839,'f69502b1cbbe4323a4b071a11a697d10','57dcde32-8fd3-44ba-94f0-1f04acb84424',236,'82efdf20300f4ffda9822c66d6f66684','gigabytes',-1,'2026-02-02 15:19:57',NULL),('2026-02-01 15:19:57.876256',NULL,'2026-02-01 15:19:57.886298',840,840,NULL,'e84fd1b6-9815-43f8-bb55-f2c303927b2e',239,'82efdf20300f4ffda9822c66d6f66684','shares',-1,'2026-02-02 15:19:57','e6371ab2-3a9c-4858-bc71-54efe991623a'),('2026-02-01 15:19:57.877483',NULL,'2026-02-01 15:19:57.886298',841,841,NULL,'551e0d20-b878-49d9-9362-4f5e33ca5b7f',238,'82efdf20300f4ffda9822c66d6f66684','gigabytes',-1,'2026-02-02 15:19:57','e6371ab2-3a9c-4858-bc71-54efe991623a'),('2026-02-01 15:19:59.838516',NULL,'2026-02-01 15:19:59.907961',842,842,'bf5d1db5b7fe40f0ab31649c9864bbbb','e48cf41b-32a3-4a85-b0f7-cd2292669e1b',246,'624202b32e62465ca01f75142b16617c','snapshots',1,'2026-02-02 15:19:59',NULL),('2026-02-01 15:19:59.839840',NULL,'2026-02-01 15:19:59.907961',843,843,'bf5d1db5b7fe40f0ab31649c9864bbbb','d5c19fa8-dec8-4d27-b290-376da7787f28',247,'624202b32e62465ca01f75142b16617c','snapshot_gigabytes',1,'2026-02-02 15:19:59',NULL),('2026-02-01 15:19:59.851255',NULL,'2026-02-01 15:19:59.907961',844,844,NULL,'462a89d1-a5c2-4369-98a5-8f022d29e1d4',248,'624202b32e62465ca01f75142b16617c','snapshots',1,'2026-02-02 15:19:59','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:19:59.852641',NULL,'2026-02-01 15:19:59.907961',845,845,NULL,'42a2d9e6-9fb9-4263-a160-a5eb438a3cb7',249,'624202b32e62465ca01f75142b16617c','snapshot_gigabytes',1,'2026-02-02 15:19:59','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:20:01.061652',NULL,'2026-02-01 15:20:01.230987',846,846,'f69502b1cbbe4323a4b071a11a697d10','e1b3e6ab-03d7-4f7e-bf1f-b1b08e3bb848',250,'82efdf20300f4ffda9822c66d6f66684','share_groups',1,'2026-02-02 15:20:01',NULL),('2026-02-01 15:20:03.284018',NULL,'2026-02-01 15:20:03.399588',847,847,'bf5d1db5b7fe40f0ab31649c9864bbbb','0f2b9ea7-fa48-4ca2-8c54-4ad7ab2b2dff',246,'624202b32e62465ca01f75142b16617c','snapshots',1,'2026-02-02 15:20:03',NULL),('2026-02-01 15:20:03.285378',NULL,'2026-02-01 15:20:03.399588',848,848,'bf5d1db5b7fe40f0ab31649c9864bbbb','3cfb5d5f-0d82-4443-a87a-5e9213774ca5',247,'624202b32e62465ca01f75142b16617c','snapshot_gigabytes',1,'2026-02-02 15:20:03',NULL),('2026-02-01 15:20:03.291415',NULL,'2026-02-01 15:20:03.399588',849,849,NULL,'431ed46d-454a-4e61-a2a1-adb8ec6a7c92',248,'624202b32e62465ca01f75142b16617c','snapshots',1,'2026-02-02 15:20:03','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:20:03.292633',NULL,'2026-02-01 15:20:03.399588',850,850,NULL,'7d7d3355-31ac-4916-9987-fbfc17226103',249,'624202b32e62465ca01f75142b16617c','snapshot_gigabytes',1,'2026-02-02 15:20:03','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:20:04.632851',NULL,'2026-02-01 15:20:04.643680',851,851,'f69502b1cbbe4323a4b071a11a697d10','ede9ee72-bade-42f5-ad0e-07bde0e35eab',250,'82efdf20300f4ffda9822c66d6f66684','share_groups',-1,'2026-02-02 15:20:04',NULL),('2026-02-01 15:20:04.989543',NULL,'2026-02-01 15:20:05.019618',852,852,'f69502b1cbbe4323a4b071a11a697d10','f505a1e7-f73c-4a24-b0b2-b3a96fd6cf80',250,'82efdf20300f4ffda9822c66d6f66684','share_groups',1,'2026-02-02 15:20:04',NULL),('2026-02-01 15:20:07.208968',NULL,'2026-02-01 15:20:07.231917',853,853,'465443f98ace4b989c787808b3cda30c','0f4ff84f-d4db-4bdc-990d-9f4b69ca87bd',166,'7043f01f29d441a4801c5afbb65b54e3','shares',-1,'2026-02-02 15:20:07',NULL),('2026-02-01 15:20:07.210747',NULL,'2026-02-01 15:20:07.231917',854,854,'465443f98ace4b989c787808b3cda30c','2a355a66-60fe-45a2-b04b-242b7f0e9d49',165,'7043f01f29d441a4801c5afbb65b54e3','gigabytes',-1,'2026-02-02 15:20:07',NULL),('2026-02-01 15:20:07.223116',NULL,'2026-02-01 15:20:07.231917',855,855,NULL,'048591bc-a76e-4aab-8a1b-6af9d2349c28',168,'7043f01f29d441a4801c5afbb65b54e3','shares',-1,'2026-02-02 15:20:07','5b0c2719-9cba-4adb-b36c-2f65cfd23a4c'),('2026-02-01 15:20:07.224069',NULL,'2026-02-01 15:20:07.231917',856,856,NULL,'337c827c-1a3f-4346-bc5f-1f033004dde9',167,'7043f01f29d441a4801c5afbb65b54e3','gigabytes',-1,'2026-02-02 15:20:07','5b0c2719-9cba-4adb-b36c-2f65cfd23a4c'),('2026-02-01 15:20:07.799958',NULL,'2026-02-01 15:20:07.815087',857,857,'bf5d1db5b7fe40f0ab31649c9864bbbb','9d3c20d9-e31c-4e61-be0f-4a19b899fd47',246,'624202b32e62465ca01f75142b16617c','snapshots',-1,'2026-02-02 15:20:07',NULL),('2026-02-01 15:20:07.800762',NULL,'2026-02-01 15:20:07.815087',858,858,'bf5d1db5b7fe40f0ab31649c9864bbbb','9597e81e-35ce-4670-9274-40126f8d076a',247,'624202b32e62465ca01f75142b16617c','snapshot_gigabytes',-1,'2026-02-02 15:20:07',NULL),('2026-02-01 15:20:07.805780',NULL,'2026-02-01 15:20:07.815087',859,859,NULL,'c490ffe0-11ab-4a15-b0e6-4671e9e5e595',248,'624202b32e62465ca01f75142b16617c','snapshots',-1,'2026-02-02 15:20:07','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:20:07.806646',NULL,'2026-02-01 15:20:07.815087',860,860,NULL,'dfce9b77-06fd-4a7e-9fbb-424910e45f63',249,'624202b32e62465ca01f75142b16617c','snapshot_gigabytes',-1,'2026-02-02 15:20:07','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:20:08.664024',NULL,'2026-02-01 15:20:08.674264',861,861,'f69502b1cbbe4323a4b071a11a697d10','5279656c-bf49-4e02-a2ff-fffbe76649b6',250,'82efdf20300f4ffda9822c66d6f66684','share_groups',-1,'2026-02-02 15:20:08',NULL),('2026-02-01 15:20:09.006424',NULL,'2026-02-01 15:20:09.044832',862,862,'f69502b1cbbe4323a4b071a11a697d10','b29ff6d8-dcdd-4dc1-a2dd-36032f28a627',237,'82efdf20300f4ffda9822c66d6f66684','shares',1,'2026-02-02 15:20:08',NULL),('2026-02-01 15:20:09.008618',NULL,'2026-02-01 15:20:09.044832',863,863,'f69502b1cbbe4323a4b071a11a697d10','63b7a754-1c0a-423a-aa58-644597859062',236,'82efdf20300f4ffda9822c66d6f66684','gigabytes',1,'2026-02-02 15:20:08',NULL),('2026-02-01 15:20:09.018615',NULL,'2026-02-01 15:20:09.044832',864,864,NULL,'83d950ae-d422-4dde-a932-d1eb564dde78',239,'82efdf20300f4ffda9822c66d6f66684','shares',1,'2026-02-02 15:20:08','e6371ab2-3a9c-4858-bc71-54efe991623a'),('2026-02-01 15:20:09.020442',NULL,'2026-02-01 15:20:09.044832',865,865,NULL,'1d1aee5b-a356-4b0c-978e-85e1650701fd',238,'82efdf20300f4ffda9822c66d6f66684','gigabytes',1,'2026-02-02 15:20:08','e6371ab2-3a9c-4858-bc71-54efe991623a'),('2026-02-01 15:20:11.064060',NULL,'2026-02-01 15:20:11.154626',866,866,'bf5d1db5b7fe40f0ab31649c9864bbbb','1a92587f-9e4b-451a-bcbe-14fdda8fd59b',246,'624202b32e62465ca01f75142b16617c','snapshots',1,'2026-02-02 15:20:11',NULL),('2026-02-01 15:20:11.065437',NULL,'2026-02-01 15:20:11.154626',867,867,'bf5d1db5b7fe40f0ab31649c9864bbbb','5e170770-f12f-4c1b-b4b9-24c87da34994',247,'624202b32e62465ca01f75142b16617c','snapshot_gigabytes',1,'2026-02-02 15:20:11',NULL),('2026-02-01 15:20:11.081235',NULL,'2026-02-01 15:20:11.154626',868,868,NULL,'0d3a454d-1d52-43a2-ba38-550828e1c0cf',248,'624202b32e62465ca01f75142b16617c','snapshots',1,'2026-02-02 15:20:11','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:20:11.082523',NULL,'2026-02-01 15:20:11.154626',869,869,NULL,'66eb6083-7afb-4c36-b24e-dae3a0137814',249,'624202b32e62465ca01f75142b16617c','snapshot_gigabytes',1,'2026-02-02 15:20:11','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:20:12.977513',NULL,'2026-02-01 15:20:12.994496',870,870,'f69502b1cbbe4323a4b071a11a697d10','c3648a60-e83e-4574-bd9e-c1fc5e74ca6f',237,'82efdf20300f4ffda9822c66d6f66684','shares',-1,'2026-02-02 15:20:12',NULL),('2026-02-01 15:20:12.978691',NULL,'2026-02-01 15:20:12.994496',871,871,'f69502b1cbbe4323a4b071a11a697d10','70295adf-8071-48bb-a9a8-f5c740ad19b2',236,'82efdf20300f4ffda9822c66d6f66684','gigabytes',-1,'2026-02-02 15:20:12',NULL),('2026-02-01 15:20:12.985310',NULL,'2026-02-01 15:20:12.994496',872,872,NULL,'c53644b6-e3ac-4d75-960f-65fe5931cb4a',239,'82efdf20300f4ffda9822c66d6f66684','shares',-1,'2026-02-02 15:20:12','e6371ab2-3a9c-4858-bc71-54efe991623a'),('2026-02-01 15:20:12.986374',NULL,'2026-02-01 15:20:12.994496',873,873,NULL,'96af4a3d-4b43-4736-945a-06f939a78122',238,'82efdf20300f4ffda9822c66d6f66684','gigabytes',-1,'2026-02-02 15:20:12','e6371ab2-3a9c-4858-bc71-54efe991623a'),('2026-02-01 15:20:16.258175',NULL,'2026-02-01 15:20:16.288561',874,874,'f69502b1cbbe4323a4b071a11a697d10','0f64e493-962a-4cd5-90c9-7de95ef45726',237,'82efdf20300f4ffda9822c66d6f66684','shares',1,'2026-02-02 15:20:16',NULL),('2026-02-01 15:20:16.259558',NULL,'2026-02-01 15:20:16.288561',875,875,'f69502b1cbbe4323a4b071a11a697d10','60027870-bf91-4d44-a83a-83b014e0a4de',236,'82efdf20300f4ffda9822c66d6f66684','gigabytes',1,'2026-02-02 15:20:16',NULL),('2026-02-01 15:20:16.266002',NULL,'2026-02-01 15:20:16.288561',876,876,NULL,'796e11f6-de08-4040-8928-3dc3ca38e7f7',239,'82efdf20300f4ffda9822c66d6f66684','shares',1,'2026-02-02 15:20:16','e6371ab2-3a9c-4858-bc71-54efe991623a'),('2026-02-01 15:20:16.267181',NULL,'2026-02-01 15:20:16.288561',877,877,NULL,'7b1be98f-516f-4b88-b422-a8dd2b749344',238,'82efdf20300f4ffda9822c66d6f66684','gigabytes',1,'2026-02-02 15:20:16','e6371ab2-3a9c-4858-bc71-54efe991623a'),('2026-02-01 15:20:16.759634',NULL,'2026-02-01 15:20:16.776150',878,878,'bf5d1db5b7fe40f0ab31649c9864bbbb','ec5cd7fb-6e5f-449b-92f3-6f3ddcc77b0a',246,'624202b32e62465ca01f75142b16617c','snapshots',-1,'2026-02-02 15:20:16',NULL),('2026-02-01 15:20:16.761104',NULL,'2026-02-01 15:20:16.776150',879,879,'bf5d1db5b7fe40f0ab31649c9864bbbb','59e08c40-c52c-43aa-b3e3-fa090598b3c3',247,'624202b32e62465ca01f75142b16617c','snapshot_gigabytes',-1,'2026-02-02 15:20:16',NULL),('2026-02-01 15:20:16.768253',NULL,'2026-02-01 15:20:16.776150',880,880,NULL,'90c39964-3e16-4fad-a8e8-eaa646085590',248,'624202b32e62465ca01f75142b16617c','snapshots',-1,'2026-02-02 15:20:16','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:20:16.768812',NULL,'2026-02-01 15:20:16.776150',881,881,NULL,'b449287b-d30d-4d15-be75-c6fa76a524d9',249,'624202b32e62465ca01f75142b16617c','snapshot_gigabytes',-1,'2026-02-02 15:20:16','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:20:19.897436',NULL,'2026-02-01 15:20:20.009188',882,882,'bf5d1db5b7fe40f0ab31649c9864bbbb','9f4366aa-39cb-4cca-bd42-116cde529abe',246,'624202b32e62465ca01f75142b16617c','snapshots',1,'2026-02-02 15:20:19',NULL),('2026-02-01 15:20:19.899501',NULL,'2026-02-01 15:20:20.009188',883,883,'bf5d1db5b7fe40f0ab31649c9864bbbb','d2820158-8652-43df-9a12-5ea6b80410a8',247,'624202b32e62465ca01f75142b16617c','snapshot_gigabytes',1,'2026-02-02 15:20:19',NULL),('2026-02-01 15:20:19.910266',NULL,'2026-02-01 15:20:20.009188',884,884,NULL,'525ae090-5d35-4a6a-8aac-c4b0d821966b',248,'624202b32e62465ca01f75142b16617c','snapshots',1,'2026-02-02 15:20:19','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:20:19.912069',NULL,'2026-02-01 15:20:20.009188',885,885,NULL,'bf8f3bfb-a0d1-4371-b33b-04a672c5ec85',249,'624202b32e62465ca01f75142b16617c','snapshot_gigabytes',1,'2026-02-02 15:20:19','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:20:20.316793',NULL,'2026-02-01 15:20:20.333904',886,886,'f69502b1cbbe4323a4b071a11a697d10','48fbb4f2-f91c-4524-806c-3ea615ef18c6',237,'82efdf20300f4ffda9822c66d6f66684','shares',-1,'2026-02-02 15:20:20',NULL),('2026-02-01 15:20:20.317720',NULL,'2026-02-01 15:20:20.333904',887,887,'f69502b1cbbe4323a4b071a11a697d10','e9794183-53e7-407f-800b-d3b3b603aa85',236,'82efdf20300f4ffda9822c66d6f66684','gigabytes',-1,'2026-02-02 15:20:20',NULL),('2026-02-01 15:20:20.326067',NULL,'2026-02-01 15:20:20.333904',888,888,NULL,'ad014ea5-6c9d-4bd8-983f-a427a674a36d',239,'82efdf20300f4ffda9822c66d6f66684','shares',-1,'2026-02-02 15:20:20','e6371ab2-3a9c-4858-bc71-54efe991623a'),('2026-02-01 15:20:20.326763',NULL,'2026-02-01 15:20:20.333904',889,889,NULL,'09345965-8a03-489e-b3e1-33869fd610c2',238,'82efdf20300f4ffda9822c66d6f66684','gigabytes',-1,'2026-02-02 15:20:20','e6371ab2-3a9c-4858-bc71-54efe991623a'),('2026-02-01 15:20:24.090349',NULL,'2026-02-01 15:20:24.105523',890,890,'bf5d1db5b7fe40f0ab31649c9864bbbb','a28da1e7-c61d-4981-b431-6eaf3673390e',246,'624202b32e62465ca01f75142b16617c','snapshots',-1,'2026-02-02 15:20:24',NULL),('2026-02-01 15:20:24.091088',NULL,'2026-02-01 15:20:24.105523',891,891,'bf5d1db5b7fe40f0ab31649c9864bbbb','40bef619-1839-42a0-ac6c-39d7eeedd25a',247,'624202b32e62465ca01f75142b16617c','snapshot_gigabytes',-1,'2026-02-02 15:20:24',NULL),('2026-02-01 15:20:24.097991',NULL,'2026-02-01 15:20:24.105523',892,892,NULL,'c5463154-1f07-46ab-91cd-debc469d9884',248,'624202b32e62465ca01f75142b16617c','snapshots',-1,'2026-02-02 15:20:24','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:20:24.098674',NULL,'2026-02-01 15:20:24.105523',893,893,NULL,'ef457269-be66-45d9-a8b8-9ac63ef7d382',249,'624202b32e62465ca01f75142b16617c','snapshot_gigabytes',-1,'2026-02-02 15:20:24','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:20:27.314557',NULL,'2026-02-01 15:20:27.413593',894,894,'bf5d1db5b7fe40f0ab31649c9864bbbb','be4ae1a2-b57b-48b2-b10c-53c80b93169c',246,'624202b32e62465ca01f75142b16617c','snapshots',1,'2026-02-02 15:20:27',NULL),('2026-02-01 15:20:27.315969',NULL,'2026-02-01 15:20:27.413593',895,895,'bf5d1db5b7fe40f0ab31649c9864bbbb','8912e103-7335-4d80-9541-1d8af54b767a',247,'624202b32e62465ca01f75142b16617c','snapshot_gigabytes',1,'2026-02-02 15:20:27',NULL),('2026-02-01 15:20:27.323290',NULL,'2026-02-01 15:20:27.413593',896,896,NULL,'e097299a-9759-42f4-9de4-2e031d3ed765',248,'624202b32e62465ca01f75142b16617c','snapshots',1,'2026-02-02 15:20:27','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:20:27.325551',NULL,'2026-02-01 15:20:27.413593',897,897,NULL,'cd8c5c66-bb27-44ba-8d12-23f3528450ad',249,'624202b32e62465ca01f75142b16617c','snapshot_gigabytes',1,'2026-02-02 15:20:27','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:20:30.157183',NULL,'2026-02-01 15:20:30.173865',898,898,'bf5d1db5b7fe40f0ab31649c9864bbbb','6de131a2-f13c-4f4e-95ae-6c6f8ac222c1',246,'624202b32e62465ca01f75142b16617c','snapshots',-1,'2026-02-02 15:20:30',NULL),('2026-02-01 15:20:30.158514',NULL,'2026-02-01 15:20:30.173865',899,899,'bf5d1db5b7fe40f0ab31649c9864bbbb','04d3f1fe-24e9-4b56-853b-a4edbebba6c4',247,'624202b32e62465ca01f75142b16617c','snapshot_gigabytes',-1,'2026-02-02 15:20:30',NULL),('2026-02-01 15:20:30.163763',NULL,'2026-02-01 15:20:30.173865',900,900,NULL,'d502d648-1eec-403d-a634-59abf6cbd15a',248,'624202b32e62465ca01f75142b16617c','snapshots',-1,'2026-02-02 15:20:30','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:20:30.164429',NULL,'2026-02-01 15:20:30.173865',901,901,NULL,'74e42985-b3b7-46c1-b4f9-aa17ac600515',249,'624202b32e62465ca01f75142b16617c','snapshot_gigabytes',-1,'2026-02-02 15:20:30','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:20:34.908502',NULL,'2026-02-01 15:20:34.992255',902,902,'bf5d1db5b7fe40f0ab31649c9864bbbb','66627650-d171-419e-8d7f-bfe555e94082',246,'624202b32e62465ca01f75142b16617c','snapshots',1,'2026-02-02 15:20:34',NULL),('2026-02-01 15:20:34.910070',NULL,'2026-02-01 15:20:34.992255',903,903,'bf5d1db5b7fe40f0ab31649c9864bbbb','67512548-e9dc-404d-ac95-acfa33145e82',247,'624202b32e62465ca01f75142b16617c','snapshot_gigabytes',1,'2026-02-02 15:20:34',NULL),('2026-02-01 15:20:34.916522',NULL,'2026-02-01 15:20:34.992255',904,904,NULL,'abf7ab2f-dce5-45be-8a48-e2bb18d854ea',248,'624202b32e62465ca01f75142b16617c','snapshots',1,'2026-02-02 15:20:34','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:20:34.917929',NULL,'2026-02-01 15:20:34.992255',905,905,NULL,'a42edf73-6512-4fb7-b146-c98b52bf49a9',249,'624202b32e62465ca01f75142b16617c','snapshot_gigabytes',1,'2026-02-02 15:20:34','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:20:38.363390',NULL,'2026-02-01 15:20:38.393256',906,906,'bf5d1db5b7fe40f0ab31649c9864bbbb','3035bd7f-87f4-430b-bd69-f258772e9c5f',246,'624202b32e62465ca01f75142b16617c','snapshots',-1,'2026-02-02 15:20:38',NULL),('2026-02-01 15:20:38.364968',NULL,'2026-02-01 15:20:38.393256',907,907,'bf5d1db5b7fe40f0ab31649c9864bbbb','e0a112c0-9002-4378-bf40-fc4cd1396cf9',247,'624202b32e62465ca01f75142b16617c','snapshot_gigabytes',-1,'2026-02-02 15:20:38',NULL),('2026-02-01 15:20:38.383255',NULL,'2026-02-01 15:20:38.393256',908,908,NULL,'b6c89e2e-51ad-491a-8f1b-ecdce7eceadc',248,'624202b32e62465ca01f75142b16617c','snapshots',-1,'2026-02-02 15:20:38','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:20:38.384188',NULL,'2026-02-01 15:20:38.393256',909,909,NULL,'83a3489b-5333-4aff-8c84-6b329ed512a7',249,'624202b32e62465ca01f75142b16617c','snapshot_gigabytes',-1,'2026-02-02 15:20:38','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:20:39.704924',NULL,'2026-02-01 15:20:39.742832',910,910,'6f958a41d78c4be0a08e982b45e1a5d2','af825a77-5a31-49d2-8f4d-4ff000b8a0f1',251,'df8c3ecdfab6413d85063f6a916bc871','share_networks',1,'2026-02-02 15:20:39',NULL),('2026-02-01 15:20:40.846642',NULL,'2026-02-01 15:20:40.902868',911,911,'6f958a41d78c4be0a08e982b45e1a5d2','903ae5a4-75fe-4490-9811-dbfef0954ab3',251,'df8c3ecdfab6413d85063f6a916bc871','share_networks',1,'2026-02-02 15:20:40',NULL),('2026-02-01 15:20:41.619786',NULL,'2026-02-01 15:20:41.628853',912,912,'6f958a41d78c4be0a08e982b45e1a5d2','10958c39-3c73-4e70-974d-06a03cefda1f',251,'df8c3ecdfab6413d85063f6a916bc871','share_networks',-1,'2026-02-02 15:20:41',NULL),('2026-02-01 15:20:41.796197',NULL,'2026-02-01 15:20:41.827693',913,913,'6f958a41d78c4be0a08e982b45e1a5d2','236d41c8-a0bb-4904-bda7-41d53ba361b1',251,'df8c3ecdfab6413d85063f6a916bc871','share_networks',1,'2026-02-02 15:20:41',NULL),('2026-02-01 15:20:42.617718',NULL,'2026-02-01 15:20:42.625310',914,914,'6f958a41d78c4be0a08e982b45e1a5d2','9bbe3df7-51ff-4718-aa0d-a4d41f0245a8',251,'df8c3ecdfab6413d85063f6a916bc871','share_networks',-1,'2026-02-02 15:20:42',NULL),('2026-02-01 15:20:43.653528',NULL,'2026-02-01 15:20:43.661553',915,915,'6f958a41d78c4be0a08e982b45e1a5d2','8fa325c8-742d-4de9-ba84-133177bb573f',251,'df8c3ecdfab6413d85063f6a916bc871','share_networks',-1,'2026-02-02 15:20:43',NULL),('2026-02-01 15:20:44.440027',NULL,'2026-02-01 15:20:44.452957',916,916,'bf5d1db5b7fe40f0ab31649c9864bbbb','8b11c6ed-8599-43aa-83da-a1a9cba2d470',246,'624202b32e62465ca01f75142b16617c','snapshots',-1,'2026-02-02 15:20:44',NULL),('2026-02-01 15:20:44.440815',NULL,'2026-02-01 15:20:44.452957',917,917,'bf5d1db5b7fe40f0ab31649c9864bbbb','2f02fcc4-b88e-45d3-805b-d0005d09a531',247,'624202b32e62465ca01f75142b16617c','snapshot_gigabytes',-1,'2026-02-02 15:20:44',NULL),('2026-02-01 15:20:44.445738',NULL,'2026-02-01 15:20:44.452957',918,918,NULL,'677df4a6-7e65-4145-8893-c5667034275d',248,'624202b32e62465ca01f75142b16617c','snapshots',-1,'2026-02-02 15:20:44','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:20:44.446419',NULL,'2026-02-01 15:20:44.452957',919,919,NULL,'b80f2d88-3862-46ae-b6a4-997d4b5c1c63',249,'624202b32e62465ca01f75142b16617c','snapshot_gigabytes',-1,'2026-02-02 15:20:44','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:20:44.975803',NULL,'2026-02-01 15:20:44.988594',920,920,'bf5d1db5b7fe40f0ab31649c9864bbbb','c8ee14c5-004b-4456-8037-0637140e1d2e',243,'624202b32e62465ca01f75142b16617c','shares',-1,'2026-02-02 15:20:44',NULL),('2026-02-01 15:20:44.976714',NULL,'2026-02-01 15:20:44.988594',921,921,'bf5d1db5b7fe40f0ab31649c9864bbbb','62267bec-7e04-4464-83f6-b2f416606756',242,'624202b32e62465ca01f75142b16617c','gigabytes',-1,'2026-02-02 15:20:44',NULL),('2026-02-01 15:20:44.982213',NULL,'2026-02-01 15:20:44.988594',922,922,NULL,'ef835fef-3aa1-4729-b75c-03a38cbd1ca9',245,'624202b32e62465ca01f75142b16617c','shares',-1,'2026-02-02 15:20:44','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:20:44.982828',NULL,'2026-02-01 15:20:44.988594',923,923,NULL,'a41ae170-2322-43fe-af5b-b801d1dbed8a',244,'624202b32e62465ca01f75142b16617c','gigabytes',-1,'2026-02-02 15:20:44','b9d443de-3e6e-4a4a-a894-066b97905353'),('2026-02-01 15:21:02.416949',NULL,'2026-02-01 15:21:02.450161',924,924,'88ec7b16b6fa416384d2369bc7447737','d3119799-4a55-4d01-902f-f889d6e891c9',252,'52ac7fb21e3442af82e9ccd9a67048b3','share_networks',1,'2026-02-02 15:21:02',NULL),('2026-02-01 15:21:02.695103',NULL,'2026-02-01 15:21:02.721955',925,925,'88ec7b16b6fa416384d2369bc7447737','7afe7efe-f928-43bd-97ac-ad80bedb0d95',252,'52ac7fb21e3442af82e9ccd9a67048b3','share_networks',1,'2026-02-02 15:21:02',NULL),('2026-02-01 15:21:02.938077',NULL,'2026-02-01 15:21:02.982166',926,926,'88ec7b16b6fa416384d2369bc7447737','92f45141-5605-4adb-89b7-8e5b820e7913',252,'52ac7fb21e3442af82e9ccd9a67048b3','share_networks',1,'2026-02-02 15:21:02',NULL),('2026-02-01 15:21:03.105989',NULL,'2026-02-01 15:21:03.113967',927,927,'88ec7b16b6fa416384d2369bc7447737','af169d34-df58-4655-bb6b-49199028d215',252,'52ac7fb21e3442af82e9ccd9a67048b3','share_networks',-1,'2026-02-02 15:21:03',NULL),('2026-02-01 15:21:03.351277',NULL,'2026-02-01 15:21:03.387173',928,928,'88ec7b16b6fa416384d2369bc7447737','14656f3a-4d59-44bc-bf35-c9c35c7c41a5',252,'52ac7fb21e3442af82e9ccd9a67048b3','share_networks',1,'2026-02-02 15:21:03',NULL),('2026-02-01 15:21:03.500900',NULL,'2026-02-01 15:21:03.525650',929,929,'88ec7b16b6fa416384d2369bc7447737','6c072e37-9bb3-40cf-9326-edd1d63cb79d',252,'52ac7fb21e3442af82e9ccd9a67048b3','share_networks',1,'2026-02-02 15:21:03',NULL),('2026-02-01 15:21:03.664555',NULL,'2026-02-01 15:21:03.670251',930,930,'88ec7b16b6fa416384d2369bc7447737','6b50712d-e260-41fb-8e81-af8761821ca0',252,'52ac7fb21e3442af82e9ccd9a67048b3','share_networks',-1,'2026-02-02 15:21:03',NULL),('2026-02-01 15:21:03.886460',NULL,'2026-02-01 15:21:03.892939',931,931,'88ec7b16b6fa416384d2369bc7447737','a9484504-f01f-468b-a1ea-b18699dc3eb6',252,'52ac7fb21e3442af82e9ccd9a67048b3','share_networks',-1,'2026-02-02 15:21:03',NULL),('2026-02-01 15:21:04.872290',NULL,'2026-02-01 15:21:04.900972',932,932,'88ec7b16b6fa416384d2369bc7447737','2c1596d2-1281-4569-b4bd-9ad60185285a',252,'52ac7fb21e3442af82e9ccd9a67048b3','share_networks',1,'2026-02-02 15:21:04',NULL),('2026-02-01 15:21:05.114591',NULL,'2026-02-01 15:21:05.121759',933,933,'88ec7b16b6fa416384d2369bc7447737','744f3943-00d2-4cbd-9f2a-e839c998a4d2',252,'52ac7fb21e3442af82e9ccd9a67048b3','share_networks',-1,'2026-02-02 15:21:05',NULL),('2026-02-01 15:21:05.192834',NULL,'2026-02-01 15:21:05.238420',934,934,'88ec7b16b6fa416384d2369bc7447737','a76acb1c-d257-4c60-be50-9e8ea7995bca',252,'52ac7fb21e3442af82e9ccd9a67048b3','share_networks',1,'2026-02-02 15:21:05',NULL),('2026-02-01 15:21:05.385098',NULL,'2026-02-01 15:21:05.391010',935,935,'88ec7b16b6fa416384d2369bc7447737','876bedf3-9a2c-4d6b-b168-3a77d58eb1f0',252,'52ac7fb21e3442af82e9ccd9a67048b3','share_networks',-1,'2026-02-02 15:21:05',NULL),('2026-02-01 15:21:06.537364',NULL,'2026-02-01 15:21:06.544819',936,936,'88ec7b16b6fa416384d2369bc7447737','4bec8159-2548-49e0-8947-0cd6af46cf7a',252,'52ac7fb21e3442af82e9ccd9a67048b3','share_networks',-1,'2026-02-02 15:21:06',NULL),('2026-02-01 15:21:06.834226',NULL,'2026-02-01 15:21:06.841087',937,937,'88ec7b16b6fa416384d2369bc7447737','a023d850-5038-432d-91da-e1b363a0914b',252,'52ac7fb21e3442af82e9ccd9a67048b3','share_networks',-1,'2026-02-02 15:21:06',NULL),('2026-02-01 15:21:16.726840',NULL,'2026-02-01 15:21:16.761011',938,938,'8c6a7c0dbc6a435d9d7adbff0811f887','51c64d59-b29e-4b15-a89c-32a1911cc887',253,'5b354e96d8754cf0a01ccc8e15d99a2c','share_networks',1,'2026-02-02 15:21:16',NULL),('2026-02-01 15:21:17.035462',NULL,'2026-02-01 15:21:17.041682',939,939,'8c6a7c0dbc6a435d9d7adbff0811f887','31ab5c14-55de-48a3-a13f-bdb107e98f37',253,'5b354e96d8754cf0a01ccc8e15d99a2c','share_networks',-1,'2026-02-02 15:21:17',NULL),('2026-02-01 15:21:17.338276',NULL,'2026-02-01 15:21:17.372776',940,940,'8c6a7c0dbc6a435d9d7adbff0811f887','be7acfac-8194-4c48-bebb-6fada9d0f99f',253,'5b354e96d8754cf0a01ccc8e15d99a2c','share_networks',1,'2026-02-02 15:21:17',NULL),('2026-02-01 15:21:18.096508',NULL,'2026-02-01 15:21:18.102320',941,941,'8c6a7c0dbc6a435d9d7adbff0811f887','e282868f-b23c-4e2d-87d7-807068b23606',253,'5b354e96d8754cf0a01ccc8e15d99a2c','share_networks',-1,'2026-02-02 15:21:18',NULL),('2026-02-01 15:21:18.463194',NULL,'2026-02-01 15:21:18.503042',942,942,'8c6a7c0dbc6a435d9d7adbff0811f887','1665ae0b-ebde-421b-848a-311573b8dda4',253,'5b354e96d8754cf0a01ccc8e15d99a2c','share_networks',1,'2026-02-02 15:21:18',NULL),('2026-02-01 15:21:18.619267',NULL,'2026-02-01 15:21:18.626610',943,943,'8c6a7c0dbc6a435d9d7adbff0811f887','ab50c303-0b26-45d6-b6af-b66e03eff6e5',253,'5b354e96d8754cf0a01ccc8e15d99a2c','share_networks',-1,'2026-02-02 15:21:18',NULL),('2026-02-01 15:21:39.445309',NULL,'2026-02-01 15:21:39.494541',944,944,'ea0ad1ffc7314e269b800f42e5e3fc3e','696c2b1e-a83c-44ac-913f-ed8c3f1684e3',255,'ebfaf803a1c84c12ac2c950d798c01a3','shares',1,'2026-02-02 15:21:39',NULL),('2026-02-01 15:21:39.446579',NULL,'2026-02-01 15:21:39.494541',945,945,'ea0ad1ffc7314e269b800f42e5e3fc3e','2cbf4b10-6a3b-455c-85fa-7ae77faa45bb',254,'ebfaf803a1c84c12ac2c950d798c01a3','gigabytes',1,'2026-02-02 15:21:39',NULL),('2026-02-01 15:21:39.457380',NULL,'2026-02-01 15:21:39.494541',946,946,NULL,'b0c56238-62d4-4323-b322-195e76879319',257,'ebfaf803a1c84c12ac2c950d798c01a3','shares',1,'2026-02-02 15:21:39','232f280e-a80b-4dbd-be5c-473370cb110d'),('2026-02-01 15:21:39.458372',NULL,'2026-02-01 15:21:39.494541',947,947,NULL,'178438e5-f399-4774-aa85-cdc09d73837d',256,'ebfaf803a1c84c12ac2c950d798c01a3','gigabytes',1,'2026-02-02 15:21:39','232f280e-a80b-4dbd-be5c-473370cb110d'),('2026-02-01 15:21:42.906820',NULL,'2026-02-01 15:21:42.994477',948,948,'ea0ad1ffc7314e269b800f42e5e3fc3e','7ad1423c-ad87-4e4f-8eed-fbb7352f774d',259,'ebfaf803a1c84c12ac2c950d798c01a3','snapshots',1,'2026-02-02 15:21:42',NULL),('2026-02-01 15:21:42.908138',NULL,'2026-02-01 15:21:42.994477',949,949,'ea0ad1ffc7314e269b800f42e5e3fc3e','dd30b8aa-de90-48ae-adce-63a2b73a63c8',258,'ebfaf803a1c84c12ac2c950d798c01a3','snapshot_gigabytes',1,'2026-02-02 15:21:42',NULL),('2026-02-01 15:21:42.923417',NULL,'2026-02-01 15:21:42.994477',950,950,NULL,'f7b2bb1a-f4ac-4a28-b8a6-c1d44cb04e0d',261,'ebfaf803a1c84c12ac2c950d798c01a3','snapshots',1,'2026-02-02 15:21:42','232f280e-a80b-4dbd-be5c-473370cb110d'),('2026-02-01 15:21:42.924668',NULL,'2026-02-01 15:21:42.994477',951,951,NULL,'1a71b006-a24f-4a5b-b883-d96045e86ea9',260,'ebfaf803a1c84c12ac2c950d798c01a3','snapshot_gigabytes',1,'2026-02-02 15:21:42','232f280e-a80b-4dbd-be5c-473370cb110d'),('2026-02-01 15:21:48.351615',NULL,'2026-02-01 15:21:48.367739',952,952,'ea0ad1ffc7314e269b800f42e5e3fc3e','95d87c06-135c-4f47-85f8-29dfc1452126',259,'ebfaf803a1c84c12ac2c950d798c01a3','snapshots',-1,'2026-02-02 15:21:48',NULL),('2026-02-01 15:21:48.352616',NULL,'2026-02-01 15:21:48.367739',953,953,'ea0ad1ffc7314e269b800f42e5e3fc3e','30a39139-2534-4f45-bc06-cfa6b595ea04',258,'ebfaf803a1c84c12ac2c950d798c01a3','snapshot_gigabytes',-1,'2026-02-02 15:21:48',NULL),('2026-02-01 15:21:48.358620',NULL,'2026-02-01 15:21:48.367739',954,954,NULL,'d3dd1cd3-4aa8-4fe3-98f4-482566697def',261,'ebfaf803a1c84c12ac2c950d798c01a3','snapshots',-1,'2026-02-02 15:21:48','232f280e-a80b-4dbd-be5c-473370cb110d'),('2026-02-01 15:21:48.359365',NULL,'2026-02-01 15:21:48.367739',955,955,NULL,'b97c0083-78fd-4460-b1c5-c58ea28770cc',260,'ebfaf803a1c84c12ac2c950d798c01a3','snapshot_gigabytes',-1,'2026-02-02 15:21:48','232f280e-a80b-4dbd-be5c-473370cb110d'),('2026-02-01 15:21:51.746033',NULL,'2026-02-01 15:21:51.759658',956,956,'ea0ad1ffc7314e269b800f42e5e3fc3e','0d4f3b52-985d-4aa2-815a-288c72d27b95',255,'ebfaf803a1c84c12ac2c950d798c01a3','shares',-1,'2026-02-02 15:21:51',NULL),('2026-02-01 15:21:51.746697',NULL,'2026-02-01 15:21:51.759658',957,957,'ea0ad1ffc7314e269b800f42e5e3fc3e','f3705fe4-1388-40dc-b0db-899c5a82ec64',254,'ebfaf803a1c84c12ac2c950d798c01a3','gigabytes',-1,'2026-02-02 15:21:51',NULL),('2026-02-01 15:21:51.752192',NULL,'2026-02-01 15:21:51.759658',958,958,NULL,'98b75f80-aff3-4819-b608-a06e59f4d9d0',257,'ebfaf803a1c84c12ac2c950d798c01a3','shares',-1,'2026-02-02 15:21:51','232f280e-a80b-4dbd-be5c-473370cb110d'),('2026-02-01 15:21:51.753020',NULL,'2026-02-01 15:21:51.759658',959,959,NULL,'3374c5f5-f9e9-43af-87d3-abc22816d393',256,'ebfaf803a1c84c12ac2c950d798c01a3','gigabytes',-1,'2026-02-02 15:21:51','232f280e-a80b-4dbd-be5c-473370cb110d'),('2026-02-01 15:22:04.928541',NULL,'2026-02-01 15:22:04.981100',960,960,'bd6f5443e9144072bcf2104c071429b2','1b217208-8a4b-45b0-a88f-3f9564f8c60d',263,'844f34f060ef46f0be5d950e48375eb5','shares',1,'2026-02-02 15:22:04',NULL),('2026-02-01 15:22:04.930309',NULL,'2026-02-01 15:22:04.981100',961,961,'bd6f5443e9144072bcf2104c071429b2','e1aa5b0c-8b72-4fb7-b55d-d727145f7209',262,'844f34f060ef46f0be5d950e48375eb5','gigabytes',1,'2026-02-02 15:22:04',NULL),('2026-02-01 15:22:04.941463',NULL,'2026-02-01 15:22:04.981100',962,962,NULL,'c1b2ade5-dcb1-4936-b0a8-7dd2635e002e',265,'844f34f060ef46f0be5d950e48375eb5','shares',1,'2026-02-02 15:22:04','b601a256-782e-4c57-86e2-e39b6a70a570'),('2026-02-01 15:22:04.942805',NULL,'2026-02-01 15:22:04.981100',963,963,NULL,'aa156010-00c7-46c7-b404-a6d0697f49d8',264,'844f34f060ef46f0be5d950e48375eb5','gigabytes',1,'2026-02-02 15:22:04','b601a256-782e-4c57-86e2-e39b6a70a570'),('2026-02-01 15:22:08.427808',NULL,'2026-02-01 15:22:08.510391',964,964,'bd6f5443e9144072bcf2104c071429b2','d9090b49-3e6e-494a-813a-99bdc2c61d7a',267,'844f34f060ef46f0be5d950e48375eb5','snapshots',1,'2026-02-02 15:22:08',NULL),('2026-02-01 15:22:08.429649',NULL,'2026-02-01 15:22:08.510391',965,965,'bd6f5443e9144072bcf2104c071429b2','699f8076-4542-4dd9-8c68-49e22b94cb73',266,'844f34f060ef46f0be5d950e48375eb5','snapshot_gigabytes',1,'2026-02-02 15:22:08',NULL),('2026-02-01 15:22:08.443270',NULL,'2026-02-01 15:22:08.510391',966,966,NULL,'3a5d6e61-490a-4e1a-96fc-73e657e76897',269,'844f34f060ef46f0be5d950e48375eb5','snapshots',1,'2026-02-02 15:22:08','b601a256-782e-4c57-86e2-e39b6a70a570'),('2026-02-01 15:22:08.444762',NULL,'2026-02-01 15:22:08.510391',967,967,NULL,'9acc8795-6ab8-4604-b180-8fe2ac657855',268,'844f34f060ef46f0be5d950e48375eb5','snapshot_gigabytes',1,'2026-02-02 15:22:08','b601a256-782e-4c57-86e2-e39b6a70a570'),('2026-02-01 15:22:13.830703',NULL,'2026-02-01 15:22:13.851049',968,968,'bd6f5443e9144072bcf2104c071429b2','fb6a0564-4810-4ccb-8a42-0e6f74aad49f',267,'844f34f060ef46f0be5d950e48375eb5','snapshots',-1,'2026-02-02 15:22:13',NULL),('2026-02-01 15:22:13.832192',NULL,'2026-02-01 15:22:13.851049',969,969,'bd6f5443e9144072bcf2104c071429b2','d82b7aad-1d90-4480-bf5b-028be71b505f',266,'844f34f060ef46f0be5d950e48375eb5','snapshot_gigabytes',-1,'2026-02-02 15:22:13',NULL),('2026-02-01 15:22:13.839907',NULL,'2026-02-01 15:22:13.851049',970,970,NULL,'a78ceeab-3da3-43e4-9d07-1057ef929137',269,'844f34f060ef46f0be5d950e48375eb5','snapshots',-1,'2026-02-02 15:22:13','b601a256-782e-4c57-86e2-e39b6a70a570'),('2026-02-01 15:22:13.840797',NULL,'2026-02-01 15:22:13.851049',971,971,NULL,'d42e0608-c47a-424d-86b9-9352243e6041',268,'844f34f060ef46f0be5d950e48375eb5','snapshot_gigabytes',-1,'2026-02-02 15:22:13','b601a256-782e-4c57-86e2-e39b6a70a570'),('2026-02-01 15:22:17.292324',NULL,'2026-02-01 15:22:17.307740',972,972,'bd6f5443e9144072bcf2104c071429b2','93f422a7-9e96-4081-9720-3249c0a1261b',263,'844f34f060ef46f0be5d950e48375eb5','shares',-1,'2026-02-02 15:22:17',NULL),('2026-02-01 15:22:17.293385',NULL,'2026-02-01 15:22:17.307740',973,973,'bd6f5443e9144072bcf2104c071429b2','1c05019d-cd72-4cfd-8aeb-5917b25f6523',262,'844f34f060ef46f0be5d950e48375eb5','gigabytes',-1,'2026-02-02 15:22:17',NULL),('2026-02-01 15:22:17.299213',NULL,'2026-02-01 15:22:17.307740',974,974,NULL,'7f19838a-d595-4005-bb7e-3dfceedc3119',265,'844f34f060ef46f0be5d950e48375eb5','shares',-1,'2026-02-02 15:22:17','b601a256-782e-4c57-86e2-e39b6a70a570'),('2026-02-01 15:22:17.300304',NULL,'2026-02-01 15:22:17.307740',975,975,NULL,'53e6ca29-53b6-4411-9008-389e4fe5145e',264,'844f34f060ef46f0be5d950e48375eb5','gigabytes',-1,'2026-02-02 15:22:17','b601a256-782e-4c57-86e2-e39b6a70a570');
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `security_services`
--

DROP TABLE IF EXISTS `security_services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `security_services` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `type` varchar(32) NOT NULL,
  `dns_ip` varchar(64) DEFAULT NULL,
  `server` varchar(255) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `user` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `ou` varchar(255) DEFAULT NULL,
  `default_ad_site` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `security_services`
--

LOCK TABLES `security_services` WRITE;
/*!40000 ALTER TABLE `security_services` DISABLE KEYS */;
INSERT INTO `security_services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `type`, `dns_ip`, `server`, `domain`, `user`, `password`, `name`, `description`, `ou`, `default_ad_site`) VALUES ('2026-02-01 15:20:21.957784','2026-02-01 15:20:22.623962','2026-02-01 15:20:22.623281','11ec6fd0-3eba-4f70-a071-d2239669596a','11ec6fd0-3eba-4f70-a071-d2239669596a','b670fdf3792f449992d3fca1ff6004ee','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-02-01 15:14:26.643148','2026-02-01 15:14:26.879639','2026-02-01 15:14:26.879262','166a96b5-68c6-44d3-8144-9d06bed269bc','166a96b5-68c6-44d3-8144-9d06bed269bc','86e747a8839340c2a3bd553d37f352da','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2026-02-01 15:20:22.038709','2026-02-01 15:20:22.453924','2026-02-01 15:20:22.453355','1823c8f8-68c5-44c3-9502-5111148f890a','1823c8f8-68c5-44c3-9502-5111148f890a','b670fdf3792f449992d3fca1ff6004ee','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-02-01 15:14:25.478576','2026-02-01 15:14:25.825236','2026-02-01 15:14:25.824664','1872aab9-f63d-4838-90bd-842743526ae8','1872aab9-f63d-4838-90bd-842743526ae8','86e747a8839340c2a3bd553d37f352da','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2026-02-01 15:14:27.318006','2026-02-01 15:14:27.650362','2026-02-01 15:14:27.650050','1bf36303-a2ce-4f89-aa07-fc98e28c48fe','1bf36303-a2ce-4f89-aa07-fc98e28c48fe','86e747a8839340c2a3bd553d37f352da','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2026-02-01 15:20:27.474209','2026-02-01 15:20:27.954110','2026-02-01 15:20:27.953573','1ee123e2-101e-42f4-9a64-c666016b8244','1ee123e2-101e-42f4-9a64-c666016b8244','b670fdf3792f449992d3fca1ff6004ee','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-02-01 15:20:26.935184','2026-02-01 15:20:27.351783','2026-02-01 15:20:27.351388','2136cd40-7088-4f44-a44a-fa6c17eb0bd9','2136cd40-7088-4f44-a44a-fa6c17eb0bd9','b670fdf3792f449992d3fca1ff6004ee','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-02-01 15:20:29.494743','2026-02-01 15:20:30.176491','2026-02-01 15:20:30.176103','22063ee0-85b7-4e73-bb79-ad16e7e3de1f','22063ee0-85b7-4e73-bb79-ad16e7e3de1f','b670fdf3792f449992d3fca1ff6004ee','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-02-01 15:14:24.037802','2026-02-01 15:14:24.174930','2026-02-01 15:14:24.173527','2e7f163f-df88-45f7-876b-b898b5236dd8','2e7f163f-df88-45f7-876b-b898b5236dd8','86e747a8839340c2a3bd553d37f352da','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2026-02-01 15:20:21.586729','2026-02-01 15:20:21.825061','2026-02-01 15:20:21.824763','2fd25429-58a0-442a-ab93-10f17be79c13','2fd25429-58a0-442a-ab93-10f17be79c13','b670fdf3792f449992d3fca1ff6004ee','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-02-01 15:20:27.617504','2026-02-01 15:20:27.792893','2026-02-01 15:20:27.792476','34cccc9a-2d68-4b3b-9d34-fc2f8c36b6e2','34cccc9a-2d68-4b3b-9d34-fc2f8c36b6e2','b670fdf3792f449992d3fca1ff6004ee','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-02-01 15:14:23.568339','2026-02-01 15:14:23.720764','2026-02-01 15:14:23.720051','37cc515c-3e13-48c5-9e1a-360fdce580bd','37cc515c-3e13-48c5-9e1a-360fdce580bd','86e747a8839340c2a3bd553d37f352da','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2026-02-01 15:14:26.592992','2026-02-01 15:14:27.094196','2026-02-01 15:14:27.093824','3a891319-1124-4d07-b94e-2f2e694b3579','3a891319-1124-4d07-b94e-2f2e694b3579','86e747a8839340c2a3bd553d37f352da','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2026-02-01 15:20:40.986406','2026-02-01 15:20:41.356566','2026-02-01 15:20:41.356218','3e642f75-ebc2-4a17-9e61-975ec01c80d6','3e642f75-ebc2-4a17-9e61-975ec01c80d6','df8c3ecdfab6413d85063f6a916bc871','ldap','203.0.113.235','203.0.113.213','tempest-ss-domain-2024000383','tempest-ss-user-1089391466','tempest-ss-password-7603002','tempest-ss-name-666162189','tempest-ss-desc-619210578',NULL,NULL),('2026-02-01 15:20:25.307530','2026-02-01 15:20:25.722017','2026-02-01 15:20:25.721665','3f744856-3444-4fa4-99f7-c5ea7fc046f0','3f744856-3444-4fa4-99f7-c5ea7fc046f0','b670fdf3792f449992d3fca1ff6004ee','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-02-01 15:20:52.422993','2026-02-01 15:20:52.493944','2026-02-01 15:20:52.493427','4ad96aec-1933-42cc-86bd-58b4e5a6c9d8','4ad96aec-1933-42cc-86bd-58b4e5a6c9d8','0db94360695a43ea89e283afc9df4110','ldap','203.0.113.43','203.0.113.12','tempest-ss-domain-863447931','tempest-ss-user-832232493','tempest-ss-password-1715767426','tempest-ss-name-1894978452','tempest-ss-desc-1580360101',NULL,NULL),('2026-02-01 15:14:24.419284','2026-02-01 15:14:24.872362','2026-02-01 15:14:24.871969','509f26f7-08e7-4e08-b0a2-5d205714f714','509f26f7-08e7-4e08-b0a2-5d205714f714','86e747a8839340c2a3bd553d37f352da','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2026-02-01 15:20:22.159963','2026-02-01 15:20:22.305958','2026-02-01 15:20:22.305553','52ab5f03-775a-4d39-a1fe-3f7e3ec31c00','52ab5f03-775a-4d39-a1fe-3f7e3ec31c00','b670fdf3792f449992d3fca1ff6004ee','ldap','203.0.113.98','203.0.113.164','tempest-ss-domain-1956342376','tempest-ss-user-203189162','tempest-ss-password-978208877','tempest-ss-name-449373777','tempest-ss-desc-451358719',NULL,NULL),('2026-02-01 15:18:20.766016',NULL,NULL,'False','56ff9bd7-19bd-498c-a01d-b029e41eec31','8b0415f100a1429bba93cf802c51baee','ldap','203.0.113.236','203.0.113.139','tempest-ss-domain-1801068515','tempest-ss-user-1072530813','tempest-ss-password-715387776','tempest-ss-name-113208597','tempest-ss-desc-1957478751',NULL,NULL),('2026-02-01 15:20:23.680990','2026-02-01 15:20:24.089197','2026-02-01 15:20:24.088858','57cdd502-7274-4f4b-b57d-b42e883058bb','57cdd502-7274-4f4b-b57d-b42e883058bb','b670fdf3792f449992d3fca1ff6004ee','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-02-01 15:20:28.682598','2026-02-01 15:20:29.127910','2026-02-01 15:20:29.127577','5c85a13e-80f3-4476-ba70-a2d6f514418b','5c85a13e-80f3-4476-ba70-a2d6f514418b','b670fdf3792f449992d3fca1ff6004ee','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-02-01 15:20:25.384931','2026-02-01 15:20:25.575318','2026-02-01 15:20:25.574951','5e9a391b-dc6c-49dd-bf6e-5fd05ddbaf81','5e9a391b-dc6c-49dd-bf6e-5fd05ddbaf81','b670fdf3792f449992d3fca1ff6004ee','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-02-01 15:20:26.444576','2026-02-01 15:20:26.720711','2026-02-01 15:20:26.720422','60b76acc-5694-4569-afa0-648c21db82cb','60b76acc-5694-4569-afa0-648c21db82cb','b670fdf3792f449992d3fca1ff6004ee','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-02-01 15:20:25.847454','2026-02-01 15:20:26.294961','2026-02-01 15:20:26.294078','636a7b18-319c-41cd-91c3-3d88f70c5892','636a7b18-319c-41cd-91c3-3d88f70c5892','b670fdf3792f449992d3fca1ff6004ee','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-02-01 15:20:22.886284','2026-02-01 15:20:23.029760','2026-02-01 15:20:23.029152','64c8b4ae-456e-47f9-8546-8fa8bc1321ca','64c8b4ae-456e-47f9-8546-8fa8bc1321ca','b670fdf3792f449992d3fca1ff6004ee','ldap','203.0.113.209','203.0.113.65','tempest-ss-domain-487937590','tempest-ss-user-1052388290','tempest-ss-password-909326390','tempest-ss-name-69051266','tempest-ss-desc-1457101210','tempest-ss-ou-2082721383',NULL),('2026-02-01 15:20:28.170400','2026-02-01 15:20:28.307363','2026-02-01 15:20:28.307068','66490ba6-946c-4f40-b60c-32c308f2ac81','66490ba6-946c-4f40-b60c-32c308f2ac81','b670fdf3792f449992d3fca1ff6004ee','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-02-01 15:20:29.441346','2026-02-01 15:20:30.399734','2026-02-01 15:20:30.399434','69bcce73-d817-47bd-90b6-7d81732e00ee','69bcce73-d817-47bd-90b6-7d81732e00ee','b670fdf3792f449992d3fca1ff6004ee','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-02-01 15:20:23.743680','2026-02-01 15:20:23.909778','2026-02-01 15:20:23.909258','6b13f0e9-7303-4fbc-83cb-cf4094d16d32','6b13f0e9-7303-4fbc-83cb-cf4094d16d32','b670fdf3792f449992d3fca1ff6004ee','ldap','203.0.113.58','203.0.113.177','tempest-ss-domain-1097485521','tempest-ss-user-2092264693','tempest-ss-password-73777754','tempest-ss-name-1776378102','tempest-ss-desc-562136737','tempest-ss-ou-1170580000',NULL),('2026-02-01 15:20:28.104694','2026-02-01 15:20:28.517344','2026-02-01 15:20:28.516804','6d6c1a75-1b11-4d72-81e8-4463ec7f6845','6d6c1a75-1b11-4d72-81e8-4463ec7f6845','b670fdf3792f449992d3fca1ff6004ee','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-02-01 15:20:20.796573','2026-02-01 15:20:20.862802','2026-02-01 15:20:20.862315','70aef48a-ef19-466a-b64b-7c63193b1e65','70aef48a-ef19-466a-b64b-7c63193b1e65','b670fdf3792f449992d3fca1ff6004ee','ldap','203.0.113.110','203.0.113.196','tempest-ss-domain-1088705078','tempest-ss-user-1622706038','tempest-ss-password-944164915','tempest-ss-name-1322743626','tempest-ss-desc-2011192136',NULL,NULL),('2026-02-01 15:14:26.039089','2026-02-01 15:14:26.215632','2026-02-01 15:14:26.215237','71dcaf9d-4927-4fdb-a24f-d1afd68bedfc','71dcaf9d-4927-4fdb-a24f-d1afd68bedfc','86e747a8839340c2a3bd553d37f352da','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2026-02-01 15:14:25.046405','2026-02-01 15:14:25.183165','2026-02-01 15:14:25.182768','744dfed8-914e-4a76-ab63-58610374054a','744dfed8-914e-4a76-ab63-58610374054a','86e747a8839340c2a3bd553d37f352da','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2026-02-01 15:14:23.982603','2026-02-01 15:14:24.319354','2026-02-01 15:14:24.318725','757201eb-acae-41fb-a308-74eaec7aa36b','757201eb-acae-41fb-a308-74eaec7aa36b','86e747a8839340c2a3bd553d37f352da','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2026-02-01 15:20:22.824333','2026-02-01 15:20:23.221594','2026-02-01 15:20:23.220769','757dffb3-fc6f-4dd8-a239-07d172eb8f3f','757dffb3-fc6f-4dd8-a239-07d172eb8f3f','b670fdf3792f449992d3fca1ff6004ee','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-02-01 15:14:24.487699','2026-02-01 15:14:24.705933','2026-02-01 15:14:24.705610','76b2c38d-faf2-4217-ad68-b8548309243d','76b2c38d-faf2-4217-ad68-b8548309243d','86e747a8839340c2a3bd553d37f352da','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2026-02-01 15:20:20.913791','2026-02-01 15:20:20.973332','2026-02-01 15:20:20.973064','76ca6002-c8dc-4238-a4d7-c55ab523d29e','76ca6002-c8dc-4238-a4d7-c55ab523d29e','b670fdf3792f449992d3fca1ff6004ee','kerberos','203.0.113.110','203.0.113.196','tempest-ss-domain-1088705078','tempest-ss-user-1622706038','tempest-ss-password-944164915','tempest-ss-name-1322743626','tempest-ss-desc-2011192136',NULL,NULL),('2026-02-01 15:20:24.543030','2026-02-01 15:20:24.688624','2026-02-01 15:20:24.688302','7d70f474-ecfc-4ce9-a24c-a8746cfaa6bc','7d70f474-ecfc-4ce9-a24c-a8746cfaa6bc','b670fdf3792f449992d3fca1ff6004ee','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-02-01 15:20:20.655268','2026-02-01 15:20:21.455024','2026-02-01 15:20:21.454715','806a209a-cdb9-4cfa-a12a-a068d7097922','806a209a-cdb9-4cfa-a12a-a068d7097922','b670fdf3792f449992d3fca1ff6004ee','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-02-01 15:20:28.628806','2026-02-01 15:20:29.267682','2026-02-01 15:20:29.267329','807061c9-80a0-4408-ba4b-bf61c396b654','807061c9-80a0-4408-ba4b-bf61c396b654','b670fdf3792f449992d3fca1ff6004ee','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-02-01 15:20:20.712511','2026-02-01 15:20:21.353098','2026-02-01 15:20:21.352786','89060225-d6bf-4c64-9957-d3b0c2add544','89060225-d6bf-4c64-9957-d3b0c2add544','b670fdf3792f449992d3fca1ff6004ee','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-02-01 15:20:39.840493',NULL,NULL,'False','8faa3d1d-617a-4d2e-ab84-da8dc4be510f','df8c3ecdfab6413d85063f6a916bc871','ldap',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('2026-02-01 15:20:21.658672','2026-02-01 15:20:21.714971','2026-02-01 15:20:21.714585','9344b479-933c-4b40-ae02-6ce28497d5ad','9344b479-933c-4b40-ae02-6ce28497d5ad','b670fdf3792f449992d3fca1ff6004ee','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-02-01 15:20:22.744868','2026-02-01 15:20:23.453593','2026-02-01 15:20:23.453205','9e9b10e6-fdfa-426a-a2d7-36339d37d8e6','9e9b10e6-fdfa-426a-a2d7-36339d37d8e6','b670fdf3792f449992d3fca1ff6004ee','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-02-01 15:14:25.604921','2026-02-01 15:14:25.676643','2026-02-01 15:14:25.676233','a7ad96c6-c588-43c1-8753-130e078126df','a7ad96c6-c588-43c1-8753-130e078126df','86e747a8839340c2a3bd553d37f352da','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2002-02-02 00:00:00.000000',NULL,NULL,'False','aa6966bb-084a-4d3c-9317-bd962887bc12','52ac7fb21e3442af82e9ccd9a67048b3','kerberos',NULL,NULL,NULL,NULL,NULL,'sn_with_ldap_ss','fake description',NULL,NULL),('2026-02-01 15:20:21.029861','2026-02-01 15:20:21.108912','2026-02-01 15:20:21.108570','baa62dab-1845-4038-b837-c0f70cf5cd74','baa62dab-1845-4038-b837-c0f70cf5cd74','b670fdf3792f449992d3fca1ff6004ee','active_directory','203.0.113.110','203.0.113.196','tempest-ss-domain-1088705078','tempest-ss-user-1622706038','tempest-ss-password-944164915','tempest-ss-name-1322743626','tempest-ss-desc-2011192136',NULL,NULL),('2026-02-01 15:18:21.771204',NULL,NULL,'False','bd99b6b8-fdeb-4573-81a0-0fbe2e4f034f','8b0415f100a1429bba93cf802c51baee','ldap','203.0.113.41','203.0.113.67','tempest-ss-domain-1556376737','tempest-ss-user-1783602247','tempest-ss-password-540137293','tempest-ss-name-1418288332','tempest-ss-desc-599770340',NULL,NULL),('2026-02-01 15:14:25.000719','2026-02-01 15:14:25.326625','2026-02-01 15:14:25.326342','c1204f84-8a5b-4db4-a037-a6b6f770045b','c1204f84-8a5b-4db4-a037-a6b6f770045b','86e747a8839340c2a3bd553d37f352da','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2026-02-01 15:14:25.976515','2026-02-01 15:14:26.463448','2026-02-01 15:14:26.462139','c21c3e93-70c7-4514-b93c-ae8557b0e846','c21c3e93-70c7-4514-b93c-ae8557b0e846','86e747a8839340c2a3bd553d37f352da','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2026-02-01 15:14:27.257930','2026-02-01 15:14:27.827507','2026-02-01 15:14:27.826871','c3ddf210-ec1c-4345-8768-d0e171f7ad4d','c3ddf210-ec1c-4345-8768-d0e171f7ad4d','86e747a8839340c2a3bd553d37f352da','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2026-02-01 15:20:41.922194',NULL,NULL,'False','c3eb336a-36a0-4bc4-8fbb-60d0c87a768e','df8c3ecdfab6413d85063f6a916bc871','ldap','203.0.113.181','203.0.113.144','tempest-ss-domain-1125792959','tempest-ss-user-358811149','tempest-ss-password-1437299209','tempest-ss-name-355849020','tempest-ss-desc-1988462660',NULL,NULL),('2026-02-01 15:20:28.793669','2026-02-01 15:20:29.007793','2026-02-01 15:20:29.007482','c6adf34e-34cc-4dd4-acc9-68b0b9208f23','c6adf34e-34cc-4dd4-acc9-68b0b9208f23','fec1c52e18f14a31be729a8342182ca7','ldap','203.0.113.154','203.0.113.221','tempest-ss-domain-1015079278','tempest-ss-user-819719045','tempest-ss-password-1007381626','tempest-ss-name-509579967','tempest-ss-desc-231688048',NULL,NULL),('2026-02-01 15:20:29.573344','2026-02-01 15:20:30.038893','2026-02-01 15:20:30.038551','cace1ee8-2743-4ae4-928f-49f6b6c76899','cace1ee8-2743-4ae4-928f-49f6b6c76899','b670fdf3792f449992d3fca1ff6004ee','ldap','203.0.113.27','203.0.113.234','tempest-ss-domain-1962365189','tempest-ss-user-818750148','tempest-ss-password-509621451','tempest-ss-name-1951364497','tempest-ss-desc-337514927','tempest-ss-ou-676778921',NULL),('2026-02-01 15:20:24.480508','2026-02-01 15:20:25.027261','2026-02-01 15:20:25.026755','d522973d-385f-4c83-838f-2593fbe164d4','d522973d-385f-4c83-838f-2593fbe164d4','b670fdf3792f449992d3fca1ff6004ee','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-02-01 15:20:23.629529','2026-02-01 15:20:24.362160','2026-02-01 15:20:24.361780','d572609a-ab45-4519-b6d3-850273e00cd1','d572609a-ab45-4519-b6d3-850273e00cd1','b670fdf3792f449992d3fca1ff6004ee','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-02-01 15:20:41.994534','2026-02-01 15:20:42.309755','2026-02-01 15:20:42.309408','d65d1f8e-3845-4bd2-b7a5-65d7c9ec54b2','d65d1f8e-3845-4bd2-b7a5-65d7c9ec54b2','df8c3ecdfab6413d85063f6a916bc871','ldap','203.0.113.125','203.0.113.114','tempest-ss-domain-910610613','tempest-ss-user-808423859','tempest-ss-password-1491071520','tempest-ss-name-505094685','tempest-ss-desc-1075062126',NULL,NULL),('2026-02-01 15:18:19.837829','2026-02-01 15:18:20.127437','2026-02-01 15:18:20.127007','d6e00696-a99c-4f4e-bb66-0e8b1a6d2495','d6e00696-a99c-4f4e-bb66-0e8b1a6d2495','8b0415f100a1429bba93cf802c51baee','ldap','203.0.113.98','203.0.113.226','tempest-ss-domain-250690331','tempest-ss-user-1607236607','tempest-ss-password-830778269','tempest-ss-name-1585534013','tempest-ss-desc-702952867',NULL,NULL),('2026-02-01 15:20:26.514494','2026-02-01 15:20:26.583171','2026-02-01 15:20:26.582848','e5df88ef-ee3a-4d34-a132-dd4f341c78c4','e5df88ef-ee3a-4d34-a132-dd4f341c78c4','b670fdf3792f449992d3fca1ff6004ee','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-02-01 15:14:23.428623','2026-02-01 15:14:23.856047','2026-02-01 15:14:23.855222','ed957133-43c5-4443-9dd5-8a761388dca2','ed957133-43c5-4443-9dd5-8a761388dca2','86e747a8839340c2a3bd553d37f352da','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2026-02-01 15:20:27.011656','2026-02-01 15:20:27.193483','2026-02-01 15:20:27.193106','f1119311-6d51-4ab1-a3c4-b97b98319aed','f1119311-6d51-4ab1-a3c4-b97b98319aed','b670fdf3792f449992d3fca1ff6004ee','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-02-01 15:14:31.769400',NULL,NULL,'False','f14382cc-8769-41e9-a7f3-cf7629f4c571','9daf6f5120ad4addbf1be43b336ab548','ldap','203.0.113.196','203.0.113.75','tempest-ss-domain-1252903523','tempest-ss-user-724688352','tempest-ss-password-1131464431','tempest-ss-name-2077021547','tempest-ss-desc-471296826',NULL,NULL),('2026-02-01 15:21:02.338315',NULL,NULL,'False','f7f98f15-37b5-47c0-8a6e-b0f30b7e42d4','52ac7fb21e3442af82e9ccd9a67048b3','ldap','203.0.113.40','203.0.113.216','tempest-ss-domain-456669907','tempest-ss-user-32261399','tempest-ss-password-723233856','tempest-ss-name-2027073725','tempest-ss-desc-1319599229',NULL,NULL),('2026-02-01 15:20:25.897108','2026-02-01 15:20:26.041076','2026-02-01 15:20:26.040667','f808f41d-8c5f-44d9-b13c-c57b5a6112ec','f808f41d-8c5f-44d9-b13c-c57b5a6112ec','b670fdf3792f449992d3fca1ff6004ee','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2002-02-02 00:00:00.000000',NULL,NULL,'False','ff13579b-ffa9-40fd-a208-bade022fd747','389354672a9f45998c217a07289430b9','kerberos',NULL,NULL,NULL,NULL,NULL,'sn_with_ldap_ss','fake description',NULL,NULL);
/*!40000 ALTER TABLE `security_services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  `state` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `service_az_id_fk` (`availability_zone_id`),
  CONSTRAINT `service_az_id_fk` FOREIGN KEY (`availability_zone_id`) REFERENCES `availability_zones` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone_id`, `state`) VALUES ('2026-02-01 15:07:42.156614','2026-02-01 15:27:38.889079',NULL,0,1,'hostgroup','manila-scheduler','manila-scheduler',119,0,'02c7f679-5981-4fd8-8760-626ef9ae59a0','up'),('2026-02-01 15:07:50.040900','2026-02-01 15:27:37.164063',NULL,0,2,'hostgroup@cephfs','manila-share','manila-share',118,0,'02c7f679-5981-4fd8-8760-626ef9ae59a0','up');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_access_map`
--

DROP TABLE IF EXISTS `share_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_access_map` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `share_id` varchar(36) NOT NULL,
  `access_type` varchar(255) DEFAULT NULL,
  `access_to` varchar(255) DEFAULT NULL,
  `access_level` varchar(2) DEFAULT NULL,
  `access_key` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_id` (`share_id`),
  CONSTRAINT `share_access_map_ibfk_1` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_access_map`
--

LOCK TABLES `share_access_map` WRITE;
/*!40000 ALTER TABLE `share_access_map` DISABLE KEYS */;
INSERT INTO `share_access_map` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_id`, `access_type`, `access_to`, `access_level`, `access_key`) VALUES ('2026-02-01 15:19:54.915720','2026-02-01 15:19:58.849746','2026-02-01 15:19:59.168852','0b203944-a85d-4b82-9607-d6e0b622abe3','0b203944-a85d-4b82-9607-d6e0b622abe3','99096eba-8e8a-4266-a1a9-b11ede8cde3e','cephx','bob','rw','AQASb39pDDOtLBAAUutbvER9tNxInBKoJfquiQ=='),('2026-02-01 15:16:37.585338','2026-02-01 15:16:41.443816','2026-02-01 15:16:46.671481','0e250eb4-32b6-47da-9443-d3ddb0a5469c','0e250eb4-32b6-47da-9443-d3ddb0a5469c','b468be17-5e14-4279-9c46-1b22b29f7b78','cephx','tempest-cephx-id-1870793908','rw','AQBVbn9pntjUNxAAAWKODOti5Oy2X7B1DijQ0Q=='),('2026-02-01 15:17:38.677669','2026-02-01 15:17:42.622706','2026-02-01 15:20:07.166539','10b177a3-90d2-42f0-9d29-522e5524aad5','10b177a3-90d2-42f0-9d29-522e5524aad5','e51ffba9-5f6c-4489-99fa-67b49bb7865e','cephx','alice','rw','AQCTbn9pKcn+ABAARo0XC6+06QoKT60oq6jJlA=='),('2026-02-01 15:17:15.916926','2026-02-01 15:17:19.867850','2026-02-01 15:20:07.166539','15cb5056-a239-4d79-8669-e899a20d9f66','15cb5056-a239-4d79-8669-e899a20d9f66','e51ffba9-5f6c-4489-99fa-67b49bb7865e','cephx','alice_bob','ro','AQB8bn9po+2eDxAAaY0bqUWRubrGycZl4/BoEA=='),('2026-02-01 15:17:31.609589','2026-02-01 15:17:35.345284','2026-02-01 15:20:07.166539','18f463ff-abac-4098-96f4-0d8276d94dbe','18f463ff-abac-4098-96f4-0d8276d94dbe','e51ffba9-5f6c-4489-99fa-67b49bb7865e','cephx','alice bob','ro','AQCLbn9pQjM4NxAAHNhp5fTp2ZHQf+UeoQNHvw=='),('2026-02-01 15:17:00.352636','2026-02-01 15:17:04.312133','2026-02-01 15:20:07.166539','1ae3cea3-ecff-40b4-854c-ead77ab9f08f','1ae3cea3-ecff-40b4-854c-ead77ab9f08f','e51ffba9-5f6c-4489-99fa-67b49bb7865e','cephx','alice','ro','AQBsbn9pBka3LBAAIZAWbT5TaTBi0lj5CDJHtw=='),('2026-02-01 15:17:10.358268','2026-02-01 15:17:14.327898','2026-02-01 15:17:30.091031','222f2bbb-ed2d-4da7-9664-2186deeeeaca','222f2bbb-ed2d-4da7-9664-2186deeeeaca','e3c73f2d-99be-4ecb-991f-ef6fb7d37db1','cephx','eve48','rw','AQB2bn9pCi5+KBAAkHGTcZ5w9B+GseqFqXd3ig=='),('2026-02-01 15:19:18.438632','2026-02-01 15:19:22.062586','2026-02-01 15:20:07.166539','289ffa28-89c2-47f8-bc55-ab031302379a','289ffa28-89c2-47f8-bc55-ab031302379a','e51ffba9-5f6c-4489-99fa-67b49bb7865e','cephx','alice_bob','rw','AQD2bn9pypeFKhAAudOqR08g/HC8Jlh9D6PVlA=='),('2026-02-01 15:17:17.853269','2026-02-01 15:17:22.515758','2026-02-01 15:17:30.091031','296ee5e9-a8bf-477d-a3ca-a6da59ad8a78','296ee5e9-a8bf-477d-a3ca-a6da59ad8a78','e3c73f2d-99be-4ecb-991f-ef6fb7d37db1','cephx','eve47','rw','AQB+bn9p4SMtFBAAIP7zgpMW/B1iwNPdBD1nTw=='),('2026-02-01 15:18:14.520847','2026-02-01 15:18:18.240257','2026-02-01 15:20:07.166539','386c24f3-9a3d-4b50-a003-283f0f84f3b6','386c24f3-9a3d-4b50-a003-283f0f84f3b6','e51ffba9-5f6c-4489-99fa-67b49bb7865e','cephx','alice bob','ro','AQC2bn9p+GcEMBAAiLL9izB9f3l4JCQEvxnpjA=='),('2026-02-01 15:18:50.243570','2026-02-01 15:18:53.947834','2026-02-01 15:20:07.166539','3a18ef65-1b7d-458a-9b23-0c52e9aedac6','3a18ef65-1b7d-458a-9b23-0c52e9aedac6','e51ffba9-5f6c-4489-99fa-67b49bb7865e','cephx','alice bob','rw','AQDabn9pqmWSHxAA7WnL1a26DLrXmGcijHMEKA=='),('2026-02-01 15:15:52.898322','2026-02-01 15:16:00.040448','2026-02-01 15:16:33.412640','3f099ffe-42cc-4646-b3be-b1283716ccd8','3f099ffe-42cc-4646-b3be-b1283716ccd8','dede97d8-5245-478c-a2ce-9bf99f2c6aa7','cephx','tempest-cephx-id-403687319','rw','AQApbn9pG+HNCBAAFfjnf98emukLKr04IYPh0A=='),('2026-02-01 15:16:17.848095','2026-02-01 15:16:21.776413','2026-02-01 15:16:29.899491','3fcd18f6-0442-4a35-b939-8c6dca36281e','3fcd18f6-0442-4a35-b939-8c6dca36281e','30ac0e47-abe2-4b5f-ba75-983911fa7443','cephx','david','rw',NULL),('2026-02-01 15:19:39.247328','2026-02-01 15:19:43.238671','2026-02-01 15:20:07.166539','6239c83a-13cc-4d33-99b3-2fe58c6a00a8','6239c83a-13cc-4d33-99b3-2fe58c6a00a8','e51ffba9-5f6c-4489-99fa-67b49bb7865e','cephx','alice bob','ro','AQALb39pQUVzMBAAgvuwolLY2jpebSOgm6xmpg=='),('2026-02-01 15:19:04.530641','2026-02-01 15:19:08.104937','2026-02-01 15:20:07.166539','65456819-a657-4a3d-852f-cdca058cb692','65456819-a657-4a3d-852f-cdca058cb692','e51ffba9-5f6c-4489-99fa-67b49bb7865e','cephx','alice','rw','AQDobn9pZEhJMRAAe3IHl/HKQmwedYC23vY0Yg=='),('2026-02-01 15:16:10.579311','2026-02-01 15:16:25.475130','2026-02-01 15:16:40.681977','683bfc07-5c5a-451a-ae0c-37f5c13ec197','683bfc07-5c5a-451a-ae0c-37f5c13ec197','1dbc87f0-6d96-4be8-901e-294b9b434e06','cephx','david','rw','AQA6bn9pDSIDNBAAueHbU6ykf9/J8Y/iSzWUjQ=='),('2026-02-01 15:18:07.283254','2026-02-01 15:18:11.145301','2026-02-01 15:20:07.166539','7116eba2-6e31-4f6e-8e38-019a2e0e70d2','7116eba2-6e31-4f6e-8e38-019a2e0e70d2','e51ffba9-5f6c-4489-99fa-67b49bb7865e','cephx','alice bob','rw','AQCvbn9p3GjRJxAAvzr3u4tsRq9TLZgYbUQXrg=='),('2026-02-01 15:16:11.166479','2026-02-01 15:16:14.933755','2026-02-01 15:16:15.860905','7a2b98f1-5570-488f-8b50-10c46df6e916','7a2b98f1-5570-488f-8b50-10c46df6e916','4c471ffa-1401-4eb7-bef0-5e4c93339d6a','cephx','tempest-cephx-id-1870793908','rw','AQA7bn9pRpchGxAAHQZfKKeAASddym6V4UOsGQ=='),('2026-02-01 15:19:32.058090','2026-02-01 15:19:35.792975','2026-02-01 15:20:07.166539','7c679ae4-722b-4c2c-a101-f87edc0d7815','7c679ae4-722b-4c2c-a101-f87edc0d7815','e51ffba9-5f6c-4489-99fa-67b49bb7865e','cephx','alice bob','rw','AQAEb39pQfOyExAAGrO/SWqBFpFcFNhk9ee38Q=='),('2026-02-01 15:17:06.696070','2026-02-01 15:17:28.929226','2026-02-01 15:17:30.091031','83cf2b72-0b38-4a65-abad-e53a9b8bdbb2','83cf2b72-0b38-4a65-abad-e53a9b8bdbb2','e3c73f2d-99be-4ecb-991f-ef6fb7d37db1','cephx','eve49','rw','AQBzbn9pImEgAhAA872lpPC8bls99FR2gzH+Hg=='),('2026-02-01 15:17:53.048097','2026-02-01 15:17:56.780431','2026-02-01 15:20:07.166539','893a43d3-c36d-4517-978b-748ae5cc1897','893a43d3-c36d-4517-978b-748ae5cc1897','e51ffba9-5f6c-4489-99fa-67b49bb7865e','cephx','alice_bob','rw','AQChbn9pBmD5HhAAZ7OcNbDfXxOBB2ZeckKBEQ=='),('2026-02-01 15:18:00.001480','2026-02-01 15:18:03.942756','2026-02-01 15:20:07.166539','8e1c4597-a52a-403c-89e8-6d9ab8c77fe7','8e1c4597-a52a-403c-89e8-6d9ab8c77fe7','e51ffba9-5f6c-4489-99fa-67b49bb7865e','cephx','alice_bob','ro','AQCobn9pi4t+GBAAtFAcOEx0mn2M0Dfrw+lQVA=='),('2026-02-01 15:14:07.548723','2026-02-01 15:14:09.112730','2026-02-01 15:14:09.486191','8fbd237a-a5eb-44b3-859b-e901f137fd20','8fbd237a-a5eb-44b3-859b-e901f137fd20','30280d5d-84b1-484d-90ed-38b66bbbbbfc','cephx','tempest-cephx-id-64491543','rw','AQC/bX9pysuUNRAAzdxY2bLjdAeTjpI1xlWIzw=='),('2026-02-01 15:18:43.115428','2026-02-01 15:18:47.025178','2026-02-01 15:20:07.166539','91cd5ccd-98f1-4089-ab6b-f3bbe9d7c739','91cd5ccd-98f1-4089-ab6b-f3bbe9d7c739','e51ffba9-5f6c-4489-99fa-67b49bb7865e','cephx','alice_bob','ro','AQDTbn9pJ2VKIxAAJLVMNgM12Z5cr8X89BDZAA=='),('2026-02-01 15:16:06.865497','2026-02-01 15:16:40.430826','2026-02-01 15:16:40.681977','936e94e7-db9e-4eb2-9478-66172f92077a','936e94e7-db9e-4eb2-9478-66172f92077a','1dbc87f0-6d96-4be8-901e-294b9b434e06','cephx','admin','rw',NULL),('2026-02-01 15:16:22.633984','2026-02-01 15:16:26.920349','2026-02-01 15:16:46.671481','9cd8c981-f06e-4520-8af0-ce0b4c0d6c9b','9cd8c981-f06e-4520-8af0-ce0b4c0d6c9b','b468be17-5e14-4279-9c46-1b22b29f7b78','cephx','tempest-cephx-id-1870793908','rw','AQBHbn9pTePXChAAPdiuCZ4uqh/vq5zWjOekuA=='),('2026-02-01 15:16:18.288109','2026-02-01 15:16:22.319975','2026-02-01 15:16:46.671481','9dcee3cc-e142-4d75-a4ce-a998b1d86e9c','9dcee3cc-e142-4d75-a4ce-a998b1d86e9c','b468be17-5e14-4279-9c46-1b22b29f7b78','cephx','tempest-cephx-id-1870793908','rw','AQBCbn9pUSGrIRAA1Yfy7Z/GCN1TWLBdTNnIuw=='),('2026-02-01 15:19:25.322596','2026-02-01 15:19:28.806296','2026-02-01 15:20:07.166539','a84427da-3729-40f2-a8e5-4c78681b47a6','a84427da-3729-40f2-a8e5-4c78681b47a6','e51ffba9-5f6c-4489-99fa-67b49bb7865e','cephx','alice_bob','ro','AQD9bn9pfGlVJBAAv6Rv/Tdti72xP/LV8Lt2lw=='),('2026-02-01 15:19:11.333116','2026-02-01 15:19:15.214760','2026-02-01 15:20:07.166539','ab821d58-3583-49b1-9a08-9824ab835325','ab821d58-3583-49b1-9a08-9824ab835325','e51ffba9-5f6c-4489-99fa-67b49bb7865e','cephx','alice','ro','AQDvbn9peZBLJxAAgHc18DRyzxxGbirDzcUzDA=='),('2026-02-01 15:16:00.972634','2026-02-01 15:16:04.602651','2026-02-01 15:16:04.949425','b5116cfa-30e1-4342-9ad0-bb61828cd4be','b5116cfa-30e1-4342-9ad0-bb61828cd4be','11fe694e-7f17-4b41-ba35-c9228ad1576c','cephx','tempest-cephx-id-1870793908','rw','AQAxbn9pVBd6EBAAqDjVWbS5NRBhtzlzRAfmmA=='),('2026-02-01 15:15:42.390104','2026-02-01 15:16:03.610725','2026-02-01 15:16:36.999794','b952e849-3b57-4003-8fd6-5d51e2401970','b952e849-3b57-4003-8fd6-5d51e2401970','e2030234-5cbe-44da-863b-b58df4bd353b','cephx','Joe','rw','AQAebn9psQYJKBAAU0FaoiyqFv9YwwariK4rsg=='),('2026-02-01 15:18:36.117646','2026-02-01 15:18:39.871812','2026-02-01 15:20:07.166539','beb27264-d112-49f2-ba38-1992c0d236a0','beb27264-d112-49f2-ba38-1992c0d236a0','e51ffba9-5f6c-4489-99fa-67b49bb7865e','cephx','alice_bob','rw','AQDMbn9pAvPGLhAAVj9X1srzY1i7zoElL6VgFg=='),('2026-02-01 15:18:28.729797','2026-02-01 15:18:32.389218','2026-02-01 15:20:07.166539','cc357d00-96a3-4ae9-bbdd-5ec1cae4c1d9','cc357d00-96a3-4ae9-bbdd-5ec1cae4c1d9','e51ffba9-5f6c-4489-99fa-67b49bb7865e','cephx','alice','ro','AQDFbn9peZCJBBAA4gV8CwMTny+x1WEwlQ1tLQ=='),('2026-02-01 15:18:57.389202','2026-02-01 15:19:01.300207','2026-02-01 15:20:07.166539','d11f5656-7242-4a89-8dc6-4c58b824f7e5','d11f5656-7242-4a89-8dc6-4c58b824f7e5','e51ffba9-5f6c-4489-99fa-67b49bb7865e','cephx','alice bob','ro','AQDkbn9pGqBDBhAAjh1W9Ukdfad7UDfBBD8z8g=='),('2026-02-01 15:16:52.787950','2026-02-01 15:16:56.774639','2026-02-01 15:20:07.166539','d3c366e4-ea2b-4b2d-8d9f-070524128f95','d3c366e4-ea2b-4b2d-8d9f-070524128f95','e51ffba9-5f6c-4489-99fa-67b49bb7865e','cephx','alice','rw','AQBlbn9pJbvXBRAA2ijZHocsJ2ab2KV6Rsugow=='),('2026-02-01 15:19:46.453395','2026-02-01 15:20:02.620203','2026-02-01 15:20:07.166539','dd3f822b-81dd-473f-b708-b2a2ee35b2d3','dd3f822b-81dd-473f-b708-b2a2ee35b2d3','e51ffba9-5f6c-4489-99fa-67b49bb7865e','cephx','bob','rw','AQASb39pDDOtLBAAUutbvER9tNxInBKoJfquiQ=='),('2026-02-01 15:18:21.670609','2026-02-01 15:18:25.460064','2026-02-01 15:20:07.166539','de068eb8-6341-4238-8f74-0e4a40b56b83','de068eb8-6341-4238-8f74-0e4a40b56b83','e51ffba9-5f6c-4489-99fa-67b49bb7865e','cephx','alice','rw','AQC+bn9ptNK/DhAAv1ygLq5Mp1tK87QHvTnbLA=='),('2026-02-01 15:16:30.289574','2026-02-01 15:16:34.317656','2026-02-01 15:16:46.671481','de0ddaf5-70d4-4579-a183-7748516363bd','de0ddaf5-70d4-4579-a183-7748516363bd','b468be17-5e14-4279-9c46-1b22b29f7b78','cephx','tempest-cephx-id-1870793908','rw','AQBObn9pi6KYIxAAsSNzIupECjcE3Dxrs3GGVQ=='),('2026-02-01 15:15:50.697940','2026-02-01 15:15:54.414032','2026-02-01 15:15:54.811983','f3d1cb92-5949-48a4-b64a-076e6fc7e95e','f3d1cb92-5949-48a4-b64a-076e6fc7e95e','eca477cd-78ff-4eb7-8da1-b1525a32f86f','cephx','tempest-cephx-id-1870793908','rw','AQAnbn9pERnsABAAKylwXPkq65BM2E5fuo1x8Q=='),('2026-02-01 15:17:46.229204','2026-02-01 15:17:49.853078','2026-02-01 15:20:07.166539','f9d37627-a8ae-472d-b95a-5227990d77d5','f9d37627-a8ae-472d-b95a-5227990d77d5','e51ffba9-5f6c-4489-99fa-67b49bb7865e','cephx','alice','ro','AQCabn9p0eZYIBAACcnZlh30LGxpaMuYQVFnRA=='),('2026-02-01 15:17:07.663658','2026-02-01 15:17:11.674588','2026-02-01 15:20:07.166539','fa0576c3-4f7c-47f1-a528-d8d090009d6b','fa0576c3-4f7c-47f1-a528-d8d090009d6b','e51ffba9-5f6c-4489-99fa-67b49bb7865e','cephx','alice_bob','rw','AQB0bn9pYdpJABAA+1ENHRZA0m9w9MQYK8lItg=='),('2026-02-01 15:17:23.218822','2026-02-01 15:17:28.412185','2026-02-01 15:20:07.166539','fe03ac65-4af8-47b3-96ac-15f9b5aeb018','fe03ac65-4af8-47b3-96ac-15f9b5aeb018','e51ffba9-5f6c-4489-99fa-67b49bb7865e','cephx','alice bob','rw','AQCDbn9ptSXgJRAAvg4fqwBOV9uftAU49nT1yQ=='),('2026-02-01 15:15:49.370738','2026-02-01 15:15:56.454984','2026-02-01 15:16:33.412640','ff6fb857-60cf-422c-91cf-25fdf67d2979','ff6fb857-60cf-422c-91cf-25fdf67d2979','dede97d8-5245-478c-a2ce-9bf99f2c6aa7','cephx','Joe','rw',NULL);
/*!40000 ALTER TABLE `share_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_access_rules_metadata`
--

DROP TABLE IF EXISTS `share_access_rules_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_access_rules_metadata` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `access_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `access_id` (`access_id`),
  CONSTRAINT `share_access_rules_metadata_ibfk_1` FOREIGN KEY (`access_id`) REFERENCES `share_access_map` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_access_rules_metadata`
--

LOCK TABLES `share_access_rules_metadata` WRITE;
/*!40000 ALTER TABLE `share_access_rules_metadata` DISABLE KEYS */;
INSERT INTO `share_access_rules_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `access_id`, `key`, `value`, `id`) VALUES ('2026-02-01 15:14:07.549757',NULL,'2026-02-01 15:14:09.339472','1','8fbd237a-a5eb-44b3-859b-e901f137fd20','key1','value1',1),('2026-02-01 15:16:30.290587',NULL,'2026-02-01 15:16:34.585984','2','de0ddaf5-70d4-4579-a183-7748516363bd','key1','v1',2),('2026-02-01 15:16:30.290975',NULL,'2026-02-01 15:16:34.585984','3','de0ddaf5-70d4-4579-a183-7748516363bd','key2','v2',3),('2026-02-01 15:16:37.587191',NULL,'2026-02-01 15:16:41.670386','4','0e250eb4-32b6-47da-9443-d3ddb0a5469c','key1','v1',4),('2026-02-01 15:16:37.587951',NULL,'2026-02-01 15:16:41.670386','5','0e250eb4-32b6-47da-9443-d3ddb0a5469c','key2','v2',5),('2026-02-01 15:17:06.697415',NULL,'2026-02-01 15:17:29.981997','6','83cf2b72-0b38-4a65-abad-e53a9b8bdbb2','key1','value1',6),('2026-02-01 15:17:06.698140','2026-02-01 15:17:25.785706','2026-02-01 15:17:29.981997','7','83cf2b72-0b38-4a65-abad-e53a9b8bdbb2','key2','value6_new',7),('2026-02-01 15:17:10.360689',NULL,'2026-02-01 15:17:14.726903','8','222f2bbb-ed2d-4da7-9664-2186deeeeaca','key3','v3',8),('2026-02-01 15:17:10.361348',NULL,'2026-02-01 15:17:14.726903','9','222f2bbb-ed2d-4da7-9664-2186deeeeaca','key4','value4',9),('2026-02-01 15:17:17.855749','2026-02-01 15:17:21.782403','2026-02-01 15:17:22.826275','10','296ee5e9-a8bf-477d-a3ca-a6da59ad8a78','key1','vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv',10),('2026-02-01 15:17:17.857432','2026-02-01 15:17:22.095510','2026-02-01 15:17:22.826275','11','296ee5e9-a8bf-477d-a3ca-a6da59ad8a78','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value2',11),('2026-02-01 15:17:25.775507',NULL,'2026-02-01 15:17:29.981997','12','83cf2b72-0b38-4a65-abad-e53a9b8bdbb2','key7','value7',12);
/*!40000 ALTER TABLE `share_access_rules_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_share_type_mappings`
--

DROP TABLE IF EXISTS `share_group_share_type_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_share_type_mappings` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_group_id` varchar(36) DEFAULT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_sgstm_share_group_id` (`share_group_id`),
  KEY `fk_sgstm_share_type_id` (`share_type_id`),
  CONSTRAINT `fk_sgstm_share_group_id` FOREIGN KEY (`share_group_id`) REFERENCES `share_groups` (`id`),
  CONSTRAINT `fk_sgstm_share_type_id` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_share_type_mappings`
--

LOCK TABLES `share_group_share_type_mappings` WRITE;
/*!40000 ALTER TABLE `share_group_share_type_mappings` DISABLE KEYS */;
INSERT INTO `share_group_share_type_mappings` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `share_group_id`, `share_type_id`) VALUES ('72096d44-9c78-4543-9bc4-27baa895e0fd','2026-02-01 15:20:01.075038',NULL,'2026-02-01 15:20:04.719084','72096d44-9c78-4543-9bc4-27baa895e0fd','1db05a86-0bcd-436c-91b4-4e5f418a5b3f','e6371ab2-3a9c-4858-bc71-54efe991623a'),('caab2644-7dbd-4df4-bd03-67a39ce224a4','2026-02-01 15:20:04.998452',NULL,'2026-02-01 15:20:08.733668','caab2644-7dbd-4df4-bd03-67a39ce224a4','93d4f46b-9bfd-433e-b5d5-9e9b76f62d85','e6371ab2-3a9c-4858-bc71-54efe991623a');
/*!40000 ALTER TABLE `share_group_share_type_mappings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_snapshots`
--

DROP TABLE IF EXISTS `share_group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_snapshots` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `share_group_id` varchar(36) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_share_group_snapshots_share_group_id` (`share_group_id`),
  CONSTRAINT `fk_share_group_snapshots_share_group_id` FOREIGN KEY (`share_group_id`) REFERENCES `share_groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_snapshots`
--

LOCK TABLES `share_group_snapshots` WRITE;
/*!40000 ALTER TABLE `share_group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_type_projects`
--

DROP TABLE IF EXISTS `share_group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sgtp_project_id_uc` (`share_group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `sgtp_id_fk` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_type_projects`
--

LOCK TABLES `share_group_type_projects` WRITE;
/*!40000 ALTER TABLE `share_group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_type_share_type_mappings`
--

DROP TABLE IF EXISTS `share_group_type_share_type_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_type_share_type_mappings` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_group_type_id` varchar(36) NOT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sgtp_id_sgt_id_uc` (`share_group_type_id`),
  KEY `sgtp_id_st_id_uc` (`share_type_id`),
  CONSTRAINT `sgtp_id_sgt_id_uc` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`),
  CONSTRAINT `sgtp_id_st_id_uc` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_type_share_type_mappings`
--

LOCK TABLES `share_group_type_share_type_mappings` WRITE;
/*!40000 ALTER TABLE `share_group_type_share_type_mappings` DISABLE KEYS */;
INSERT INTO `share_group_type_share_type_mappings` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `share_group_type_id`, `share_type_id`) VALUES ('515147fd-eeed-4b64-8982-b09769eb766e','2026-02-01 15:13:34.224953',NULL,'2026-02-01 15:14:05.091331','515147fd-eeed-4b64-8982-b09769eb766e','d5bae173-e2fa-468c-9c73-abec88d86615','b1712ae3-d38a-4543-bf30-4854aff75f83'),('9c1fa219-5ed2-46b9-9e06-5d50ef7dd066','2026-02-01 15:13:36.496972',NULL,'2026-02-01 15:14:11.023129','9c1fa219-5ed2-46b9-9e06-5d50ef7dd066','14fa9940-13cf-4752-b631-23af80d2c6ad','9e805c93-4b57-4421-a159-7bc8b285c972'),('a38cce1a-037b-4ef3-b67b-0290dd409547','2026-02-01 15:19:42.877493',NULL,'2026-02-01 15:20:24.339528','a38cce1a-037b-4ef3-b67b-0290dd409547','d6e18497-4b51-4062-908c-8e0da74cf6c0','e6371ab2-3a9c-4858-bc71-54efe991623a'),('de07b3b4-a286-43af-a7c5-83fd0425d93e','2026-02-01 15:17:11.774477',NULL,'2026-02-01 15:17:13.665626','de07b3b4-a286-43af-a7c5-83fd0425d93e','3b74137f-7464-4108-8402-d95e7d1e3ff9','9132f50b-18b6-4026-aa0a-09214a0bba42');
/*!40000 ALTER TABLE `share_group_type_share_type_mappings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_type_specs`
--

DROP TABLE IF EXISTS `share_group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `spec_key` varchar(255) DEFAULT NULL,
  `spec_value` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sgtp_id_extra_specs_fk` (`share_group_type_id`),
  CONSTRAINT `sgtp_id_extra_specs_fk` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_type_specs`
--

LOCK TABLES `share_group_type_specs` WRITE;
/*!40000 ALTER TABLE `share_group_type_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_types`
--

DROP TABLE IF EXISTS `share_group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_types` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_share_group_type_name` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_types`
--

LOCK TABLES `share_group_types` WRITE;
/*!40000 ALTER TABLE `share_group_types` DISABLE KEYS */;
INSERT INTO `share_group_types` (`id`, `created_at`, `updated_at`, `deleted_at`, `is_public`, `name`, `deleted`) VALUES ('14fa9940-13cf-4752-b631-23af80d2c6ad','2026-02-01 15:13:36.495463',NULL,'2026-02-01 15:14:11.028226',1,'tempest-unique_sgtype_name-1789125085','14fa9940-13cf-4752-b631-23af80d2c6ad'),('3b74137f-7464-4108-8402-d95e7d1e3ff9','2026-02-01 15:17:11.773832',NULL,'2026-02-01 15:17:13.668628',1,'tempest-unique_sgtype_name-1049012090','3b74137f-7464-4108-8402-d95e7d1e3ff9'),('d5bae173-e2fa-468c-9c73-abec88d86615','2026-02-01 15:13:34.223378',NULL,'2026-02-01 15:14:05.098549',1,'tempest-unique_sgtype_name-1719094686','d5bae173-e2fa-468c-9c73-abec88d86615'),('d6e18497-4b51-4062-908c-8e0da74cf6c0','2026-02-01 15:19:42.876254',NULL,'2026-02-01 15:20:24.345176',1,'tempest-unique_sgtype_name-930052160','d6e18497-4b51-4062-908c-8e0da74cf6c0');
/*!40000 ALTER TABLE `share_group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_groups`
--

DROP TABLE IF EXISTS `share_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_groups` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `host` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `source_share_group_snapshot_id` varchar(36) DEFAULT NULL,
  `share_network_id` varchar(36) DEFAULT NULL,
  `share_server_id` varchar(36) DEFAULT NULL,
  `share_group_type_id` varchar(36) DEFAULT NULL,
  `consistent_snapshot_support` enum('pool','host') DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_share_group_share_network_id` (`share_network_id`),
  KEY `fk_share_group_share_server_id` (`share_server_id`),
  KEY `sgt_id_sg_id_uc` (`share_group_type_id`),
  CONSTRAINT `fk_share_group_share_network_id` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`),
  CONSTRAINT `fk_share_group_share_server_id` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`),
  CONSTRAINT `sgt_id_sg_id_uc` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_groups`
--

LOCK TABLES `share_groups` WRITE;
/*!40000 ALTER TABLE `share_groups` DISABLE KEYS */;
INSERT INTO `share_groups` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `user_id`, `project_id`, `host`, `name`, `description`, `status`, `source_share_group_snapshot_id`, `share_network_id`, `share_server_id`, `share_group_type_id`, `consistent_snapshot_support`, `availability_zone_id`) VALUES ('1db05a86-0bcd-436c-91b4-4e5f418a5b3f','2026-02-01 15:20:01.327458','2026-02-01 15:20:04.716645','2026-02-01 15:20:04.715497','1db05a86-0bcd-436c-91b4-4e5f418a5b3f','f69502b1cbbe4323a4b071a11a697d10','82efdf20300f4ffda9822c66d6f66684','hostgroup@cephfs#cephfs',NULL,NULL,'deleting',NULL,NULL,NULL,'d6e18497-4b51-4062-908c-8e0da74cf6c0',NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0'),('93d4f46b-9bfd-433e-b5d5-9e9b76f62d85','2026-02-01 15:20:05.121671','2026-02-01 15:20:08.732762','2026-02-01 15:20:08.732256','93d4f46b-9bfd-433e-b5d5-9e9b76f62d85','f69502b1cbbe4323a4b071a11a697d10','82efdf20300f4ffda9822c66d6f66684','hostgroup@cephfs#cephfs',NULL,NULL,'deleting',NULL,NULL,NULL,'d6e18497-4b51-4062-908c-8e0da74cf6c0',NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0');
/*!40000 ALTER TABLE `share_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instance_access_map`
--

DROP TABLE IF EXISTS `share_instance_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instance_access_map` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `share_instance_id` varchar(36) DEFAULT NULL,
  `access_id` varchar(36) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `siam_instance_fk` (`share_instance_id`),
  KEY `siam_access_fk` (`access_id`),
  CONSTRAINT `siam_access_fk` FOREIGN KEY (`access_id`) REFERENCES `share_access_map` (`id`),
  CONSTRAINT `siam_instance_fk` FOREIGN KEY (`share_instance_id`) REFERENCES `share_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instance_access_map`
--

LOCK TABLES `share_instance_access_map` WRITE;
/*!40000 ALTER TABLE `share_instance_access_map` DISABLE KEYS */;
INSERT INTO `share_instance_access_map` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_instance_id`, `access_id`, `state`) VALUES ('2026-02-01 15:15:49.394972','2026-02-01 15:15:57.191191','2026-02-01 15:15:57.190438','006202f1-b578-4852-b371-240d1e194ad3','006202f1-b578-4852-b371-240d1e194ad3','66ba7d88-ae35-42fd-932a-84cc5334b587','ff6fb857-60cf-422c-91cf-25fdf67d2979','deleted'),('2026-02-01 15:18:21.684279','2026-02-01 15:18:25.812155','2026-02-01 15:18:25.811691','0689647c-cca9-4786-a8c8-a28aac5677b9','0689647c-cca9-4786-a8c8-a28aac5677b9','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280','de068eb8-6341-4238-8f74-0e4a40b56b83','deleted'),('2026-02-01 15:18:57.398568','2026-02-01 15:19:01.507033','2026-02-01 15:19:01.506398','0a25390c-2eb5-4e92-afc7-76436ce4a586','0a25390c-2eb5-4e92-afc7-76436ce4a586','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280','d11f5656-7242-4a89-8dc6-4c58b824f7e5','deleted'),('2026-02-01 15:16:00.986174','2026-02-01 15:16:04.840163','2026-02-01 15:16:04.839740','0c07f03a-7baa-4333-8977-95d497b5b6c5','0c07f03a-7baa-4333-8977-95d497b5b6c5','67e50812-4602-4dc4-b942-a78b28ddb769','b5116cfa-30e1-4342-9ad0-bb61828cd4be','deleted'),('2026-02-01 15:19:32.067802','2026-02-01 15:19:36.016444','2026-02-01 15:19:36.016058','0f799a72-1975-4dcf-bea5-0da7741e5180','0f799a72-1975-4dcf-bea5-0da7741e5180','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280','7c679ae4-722b-4c2c-a101-f87edc0d7815','deleted'),('2026-02-01 15:19:18.461965','2026-02-01 15:19:22.258774','2026-02-01 15:19:22.258412','1f60ce54-526b-4cd1-a70a-92ed82e79858','1f60ce54-526b-4cd1-a70a-92ed82e79858','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280','289ffa28-89c2-47f8-bc55-ab031302379a','deleted'),('2026-02-01 15:17:23.230177','2026-02-01 15:17:28.756109','2026-02-01 15:17:28.755633','2a47e758-d3aa-4995-b1d4-966d3b212d8a','2a47e758-d3aa-4995-b1d4-966d3b212d8a','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280','fe03ac65-4af8-47b3-96ac-15f9b5aeb018','deleted'),('2026-02-01 15:17:07.681012','2026-02-01 15:17:11.928445','2026-02-01 15:17:11.927790','2fdfb5c4-d21c-4510-b00a-e5a70de46960','2fdfb5c4-d21c-4510-b00a-e5a70de46960','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280','fa0576c3-4f7c-47f1-a528-d8d090009d6b','deleted'),('2026-02-01 15:17:10.375111','2026-02-01 15:17:14.724390','2026-02-01 15:17:14.723933','32779fa7-a718-451e-a26e-ee801eff7002','32779fa7-a718-451e-a26e-ee801eff7002','c9b2fd01-3509-428e-b915-0b74e783dc19','222f2bbb-ed2d-4da7-9664-2186deeeeaca','deleted'),('2026-02-01 15:17:00.385152','2026-02-01 15:17:04.528601','2026-02-01 15:17:04.528193','33581634-86bf-43fc-b3b9-00c49f4072a4','33581634-86bf-43fc-b3b9-00c49f4072a4','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280','1ae3cea3-ecff-40b4-854c-ead77ab9f08f','deleted'),('2026-02-01 15:14:07.559475','2026-02-01 15:14:09.337030','2026-02-01 15:14:09.336316','36c34a26-3d6a-4bdc-9cf1-e01e961afa11','36c34a26-3d6a-4bdc-9cf1-e01e961afa11','c19a0244-e063-4af0-8894-414616a3f2b3','8fbd237a-a5eb-44b3-859b-e901f137fd20','deleted'),('2026-02-01 15:16:30.299982','2026-02-01 15:16:34.584148','2026-02-01 15:16:34.583677','402112eb-b9b3-462e-a647-78cb0580f602','402112eb-b9b3-462e-a647-78cb0580f602','fda2fd7c-38e4-46f7-bc0a-f227e5de8aa7','de0ddaf5-70d4-4579-a183-7748516363bd','deleted'),('2026-02-01 15:18:00.020349','2026-02-01 15:18:04.139456','2026-02-01 15:18:04.139105','449d19e3-8371-4172-9898-35ca91daae70','449d19e3-8371-4172-9898-35ca91daae70','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280','8e1c4597-a52a-403c-89e8-6d9ab8c77fe7','deleted'),('2026-02-01 15:17:38.693188','2026-02-01 15:17:42.878250','2026-02-01 15:17:42.877739','4d2c6597-935a-45bb-b1de-b70db0103033','4d2c6597-935a-45bb-b1de-b70db0103033','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280','10b177a3-90d2-42f0-9d29-522e5524aad5','deleted'),('2026-02-01 15:18:28.748026','2026-02-01 15:18:32.597128','2026-02-01 15:18:32.596615','59fa799e-f982-4c0c-b4d7-da9657b07db2','59fa799e-f982-4c0c-b4d7-da9657b07db2','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280','cc357d00-96a3-4ae9-bbdd-5ec1cae4c1d9','deleted'),('2026-02-01 15:16:37.602644','2026-02-01 15:16:41.668251','2026-02-01 15:16:41.667711','698df2f0-5da9-408a-b443-c01a43282975','698df2f0-5da9-408a-b443-c01a43282975','fda2fd7c-38e4-46f7-bc0a-f227e5de8aa7','0e250eb4-32b6-47da-9443-d3ddb0a5469c','deleted'),('2026-02-01 15:17:17.874447','2026-02-01 15:17:22.823471','2026-02-01 15:17:22.822987','6fd77bfb-3b0e-4afa-97f4-493f7ec9461f','6fd77bfb-3b0e-4afa-97f4-493f7ec9461f','c9b2fd01-3509-428e-b915-0b74e783dc19','296ee5e9-a8bf-477d-a3ca-a6da59ad8a78','deleted'),('2026-02-01 15:19:11.349744','2026-02-01 15:19:15.456562','2026-02-01 15:19:15.456098','73eb0cb4-1f70-4328-8b06-b7c1b97f064a','73eb0cb4-1f70-4328-8b06-b7c1b97f064a','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280','ab821d58-3583-49b1-9a08-9824ab835325','deleted'),('2026-02-01 15:18:14.530281','2026-02-01 15:18:18.486493','2026-02-01 15:18:18.486134','8a3fec8b-b380-400e-b487-a89bdb238acf','8a3fec8b-b380-400e-b487-a89bdb238acf','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280','386c24f3-9a3d-4b50-a003-283f0f84f3b6','deleted'),('2026-02-01 15:18:43.130918','2026-02-01 15:18:47.286222','2026-02-01 15:18:47.285862','8c039d5d-c386-4465-8aa7-aca7d14c3e05','8c039d5d-c386-4465-8aa7-aca7d14c3e05','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280','91cd5ccd-98f1-4089-ab6b-f3bbe9d7c739','deleted'),('2026-02-01 15:16:18.298282','2026-02-01 15:16:22.492451','2026-02-01 15:16:22.492007','9a6f4823-96ea-406f-865f-5b0916ac848f','9a6f4823-96ea-406f-865f-5b0916ac848f','fda2fd7c-38e4-46f7-bc0a-f227e5de8aa7','9dcee3cc-e142-4d75-a4ce-a998b1d86e9c','deleted'),('2026-02-01 15:17:46.240818','2026-02-01 15:17:50.059323','2026-02-01 15:17:50.058949','9bf7c8fb-a86b-47ee-a4e0-07f14ad5cc05','9bf7c8fb-a86b-47ee-a4e0-07f14ad5cc05','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280','f9d37627-a8ae-472d-b95a-5227990d77d5','deleted'),('2026-02-01 15:18:50.258182','2026-02-01 15:18:54.264182','2026-02-01 15:18:54.263077','9dd0f161-809a-47d5-8d79-eed9c63a283f','9dd0f161-809a-47d5-8d79-eed9c63a283f','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280','3a18ef65-1b7d-458a-9b23-0c52e9aedac6','deleted'),('2026-02-01 15:19:39.267644','2026-02-01 15:19:43.580362','2026-02-01 15:19:43.579855','a06c8e84-9414-4a2e-9d10-5586f644d691','a06c8e84-9414-4a2e-9d10-5586f644d691','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280','6239c83a-13cc-4d33-99b3-2fe58c6a00a8','deleted'),('2026-02-01 15:15:52.912855','2026-02-01 15:16:00.231306','2026-02-01 15:16:00.230817','acbf9022-3d85-46e5-a21e-25a3b4cd967a','acbf9022-3d85-46e5-a21e-25a3b4cd967a','66ba7d88-ae35-42fd-932a-84cc5334b587','3f099ffe-42cc-4646-b3be-b1283716ccd8','deleted'),('2026-02-01 15:16:22.649289','2026-02-01 15:16:27.145029','2026-02-01 15:16:27.144505','b3068cc5-7c1d-4cb2-ba10-3092cbc06563','b3068cc5-7c1d-4cb2-ba10-3092cbc06563','fda2fd7c-38e4-46f7-bc0a-f227e5de8aa7','9cd8c981-f06e-4520-8af0-ce0b4c0d6c9b','deleted'),('2026-02-01 15:17:06.716571','2026-02-01 15:17:29.980270','2026-02-01 15:17:29.979846','b5e4b403-15bb-49fa-8d49-0acad465d94c','b5e4b403-15bb-49fa-8d49-0acad465d94c','c9b2fd01-3509-428e-b915-0b74e783dc19','83cf2b72-0b38-4a65-abad-e53a9b8bdbb2','deleted'),('2026-02-01 15:19:54.926042','2026-02-01 15:19:59.163787','2026-02-01 15:19:59.163206','bb1717e8-5002-4e2a-90e3-94d0ec7f5b80','bb1717e8-5002-4e2a-90e3-94d0ec7f5b80','5f542ebc-7768-479b-a371-3e911afa4848','0b203944-a85d-4b82-9607-d6e0b622abe3','deleted'),('2026-02-01 15:18:07.297362','2026-02-01 15:18:11.363524','2026-02-01 15:18:11.363111','c1d49739-0641-4628-9a90-8dcfb811fa6e','c1d49739-0641-4628-9a90-8dcfb811fa6e','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280','7116eba2-6e31-4f6e-8e38-019a2e0e70d2','deleted'),('2026-02-01 15:16:06.888019','2026-02-01 15:16:40.577714','2026-02-01 15:16:40.577023','c26311ea-f31b-46bc-9422-d69b5c9632e0','c26311ea-f31b-46bc-9422-d69b5c9632e0','f13e6643-de3c-4836-add7-2244ceca3720','936e94e7-db9e-4eb2-9478-66172f92077a','deleted'),('2026-02-01 15:19:25.337929','2026-02-01 15:19:28.977295','2026-02-01 15:19:28.976849','c2a56f6b-f21c-416e-acfd-5ddb171a9457','c2a56f6b-f21c-416e-acfd-5ddb171a9457','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280','a84427da-3729-40f2-a8e5-4c78681b47a6','deleted'),('2026-02-01 15:19:04.543237','2026-02-01 15:19:08.300128','2026-02-01 15:19:08.299708','c46e95fd-5d73-4f36-b2b8-634264a35d50','c46e95fd-5d73-4f36-b2b8-634264a35d50','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280','65456819-a657-4a3d-852f-cdca058cb692','deleted'),('2026-02-01 15:19:46.468606','2026-02-01 15:20:02.854465','2026-02-01 15:20:02.853680','c798f643-fe74-49c8-a8a9-ee670d63266c','c798f643-fe74-49c8-a8a9-ee670d63266c','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280','dd3f822b-81dd-473f-b708-b2a2ee35b2d3','deleted'),('2026-02-01 15:17:53.062975','2026-02-01 15:17:56.959607','2026-02-01 15:17:56.959242','ce24318d-ac88-4d2b-9c80-2761a2d04184','ce24318d-ac88-4d2b-9c80-2761a2d04184','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280','893a43d3-c36d-4517-978b-748ae5cc1897','deleted'),('2026-02-01 15:16:52.798336','2026-02-01 15:16:56.984554','2026-02-01 15:16:56.984192','d7558bb7-3e9c-431d-ac71-02a92bb14de7','d7558bb7-3e9c-431d-ac71-02a92bb14de7','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280','d3c366e4-ea2b-4b2d-8d9f-070524128f95','deleted'),('2026-02-01 15:16:10.598171','2026-02-01 15:16:25.678270','2026-02-01 15:16:25.677866','df8bb974-49f7-440c-8c8b-a88c3e0de629','df8bb974-49f7-440c-8c8b-a88c3e0de629','f13e6643-de3c-4836-add7-2244ceca3720','683bfc07-5c5a-451a-ae0c-37f5c13ec197','deleted'),('2026-02-01 15:15:50.718624','2026-02-01 15:15:54.661210','2026-02-01 15:15:54.660815','e0ff8ed9-6deb-4264-ab2b-f1f223c7d0dc','e0ff8ed9-6deb-4264-ab2b-f1f223c7d0dc','bcfe09f7-b95d-44d4-88ff-9ddff7f38222','f3d1cb92-5949-48a4-b64a-076e6fc7e95e','deleted'),('2026-02-01 15:18:36.134217','2026-02-01 15:18:40.093897','2026-02-01 15:18:40.093534','e226b48b-2c9f-4adb-81fb-60e62339449d','e226b48b-2c9f-4adb-81fb-60e62339449d','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280','beb27264-d112-49f2-ba38-1992c0d236a0','deleted'),('2026-02-01 15:17:31.621126','2026-02-01 15:17:35.562388','2026-02-01 15:17:35.561903','e963f8cc-bf36-431a-be8f-3a77e19cdab9','e963f8cc-bf36-431a-be8f-3a77e19cdab9','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280','18f463ff-abac-4098-96f4-0d8276d94dbe','deleted'),('2026-02-01 15:15:42.411043','2026-02-01 15:16:03.799136','2026-02-01 15:16:03.798695','ea3eb50e-4034-467e-ba0e-9ccf4333c529','ea3eb50e-4034-467e-ba0e-9ccf4333c529','cc8298b6-cd36-4e3a-b5fa-1906378c83d8','b952e849-3b57-4003-8fd6-5d51e2401970','deleted'),('2026-02-01 15:16:17.857754','2026-02-01 15:16:21.939738','2026-02-01 15:16:21.939315','fa81b049-fb0c-40e9-8dfb-4ec6624c2bcf','fa81b049-fb0c-40e9-8dfb-4ec6624c2bcf','53873f8b-858c-4fab-a187-a58acce7cad2','3fcd18f6-0442-4a35-b939-8c6dca36281e','deleted'),('2026-02-01 15:16:11.175753','2026-02-01 15:16:15.712136','2026-02-01 15:16:15.711446','fad89264-267d-409e-9af2-94b523335050','fad89264-267d-409e-9af2-94b523335050','90ad7db4-01ea-4e02-bd1a-db4113b80713','7a2b98f1-5570-488f-8b50-10c46df6e916','deleted'),('2026-02-01 15:17:15.940067','2026-02-01 15:17:20.102200','2026-02-01 15:17:20.101801','fd703cc1-a45b-4500-bcf9-6f5267badcbf','fd703cc1-a45b-4500-bcf9-6f5267badcbf','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280','15cb5056-a239-4d79-8669-e899a20d9f66','deleted');
/*!40000 ALTER TABLE `share_instance_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instance_export_locations`
--

DROP TABLE IF EXISTS `share_instance_export_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instance_export_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `path` varchar(2000) DEFAULT NULL,
  `share_instance_id` varchar(36) DEFAULT NULL,
  `is_admin_only` tinyint(1) DEFAULT NULL,
  `uuid` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `sel_instance_id_fk` (`share_instance_id`),
  CONSTRAINT `sel_instance_id_fk` FOREIGN KEY (`share_instance_id`) REFERENCES `share_instances` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instance_export_locations`
--

LOCK TABLES `share_instance_export_locations` WRITE;
/*!40000 ALTER TABLE `share_instance_export_locations` DISABLE KEYS */;
INSERT INTO `share_instance_export_locations` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `path`, `share_instance_id`, `is_admin_only`, `uuid`) VALUES (1,'2026-02-01 15:13:07.269138','2026-02-01 15:14:21.156524','2026-02-01 15:14:21.150839',1,'192.168.122.100:6789:/volumes/_nogroup/0d8696eb-14a5-4abf-b5f8-d5c0093d2c06/20a8c9a2-cfa0-44d6-b2f2-a4472dc96dd6','0d8696eb-14a5-4abf-b5f8-d5c0093d2c06',0,'f3ea6c5c-aa41-42df-8a29-3b34009eeccb'),(2,'2026-02-01 15:13:08.006132','2026-02-01 15:13:15.762296','2026-02-01 15:13:15.760779',2,'192.168.122.100:6789:/volumes/_nogroup/915665b7-ff70-4faa-88a3-0d32becf6f29/49597151-cba1-48e5-979e-cda79388de34','915665b7-ff70-4faa-88a3-0d32becf6f29',0,'a2a1b012-625c-4d8e-aa8f-e80ab31e18fb'),(3,'2026-02-01 15:13:08.425195','2026-02-01 15:13:20.788311','2026-02-01 15:13:20.787160',3,'192.168.122.100:6789:/volumes/_nogroup/618c0e6c-2fb1-44ff-85f4-15df368e2591/0d56fdbc-9c41-43b1-9fb0-657d8d49f4ff','618c0e6c-2fb1-44ff-85f4-15df368e2591',0,'91752f71-6619-41a1-9d11-9cf3f989b7cf'),(4,'2026-02-01 15:13:10.976274','2026-02-01 15:13:16.179743','2026-02-01 15:13:16.178763',4,'192.168.122.100:6789:/volumes/_nogroup/bde02bc8-059b-4cad-a246-c96036843cf2/beffe961-0742-4156-ad43-3b52285fd640','bde02bc8-059b-4cad-a246-c96036843cf2',0,'f3fc30f4-9e1d-4d55-8c6d-40f0f70f26f5'),(5,'2026-02-01 15:13:19.738195','2026-02-01 15:13:24.779434','2026-02-01 15:13:24.771993',5,'192.168.122.100:6789:/volumes/_nogroup/bd6fb31c-809d-4c83-9761-28c8527a3b81/b210dff2-6407-4abe-a039-ae386c608b9f','bd6fb31c-809d-4c83-9761-28c8527a3b81',0,'5f5f0730-b210-4ced-a9e6-2c01a21dade6'),(6,'2026-02-01 15:13:20.608702','2026-02-01 15:13:26.399048','2026-02-01 15:13:26.398075',6,'192.168.122.100:6789:/volumes/_nogroup/55a7edb3-0742-4b44-9cb7-64d96e0ec803/4aec6ca1-043b-4958-8d9c-898a56795b18','55a7edb3-0742-4b44-9cb7-64d96e0ec803',0,'bbce4572-426e-4dc1-af81-3cf3ab4ecb33'),(7,'2026-02-01 15:13:28.396826','2026-02-01 15:13:32.146177','2026-02-01 15:13:32.145344',7,'192.168.122.100:6789:/volumes/_nogroup/3147dea9-81aa-476a-8ff6-685b8fe5fd2e/cc27705c-3e9e-4106-8c7b-7566003143da','3147dea9-81aa-476a-8ff6-685b8fe5fd2e',0,'4edf09b9-d84e-42fb-b066-37ace12d2fdd'),(8,'2026-02-01 15:13:34.705005','2026-02-01 15:14:02.007037','2026-02-01 15:14:02.005749',8,'192.168.122.100:6789:/volumes/_nogroup/b6c72970-f609-412a-968d-5d3fe02bddc0/d2950875-19b2-4633-8278-a9181fa57d3d','b6c72970-f609-412a-968d-5d3fe02bddc0',0,'6d3ab41f-2be0-4d3e-8853-42da72258d56'),(9,'2026-02-01 15:13:35.870374','2026-02-01 15:13:39.341544','2026-02-01 15:13:39.340603',9,'192.168.122.100:6789:/volumes/_nogroup/dc838023-ada6-4f22-947b-32f93b678270/fec65527-d4a9-4f7c-a85e-6e18557fd6b3','dc838023-ada6-4f22-947b-32f93b678270',0,'b43f1b8f-77b9-4966-b91b-f659d7f321c8'),(10,'2026-02-01 15:13:37.825236','2026-02-01 15:13:45.555470','2026-02-01 15:13:45.554546',10,'192.168.122.100:6789:/volumes/_nogroup/c14d6f49-4f6c-4972-908b-48b473f08bc0/2f852e97-4db6-4d48-a89b-3b24b6eaae9b','c14d6f49-4f6c-4972-908b-48b473f08bc0',0,'b68e6dd5-b2e2-448f-870a-a6d6be2468ad'),(11,'2026-02-01 15:13:38.916414','2026-02-01 15:13:58.182901','2026-02-01 15:13:58.181470',11,'192.168.122.100:6789:/volumes/_nogroup/1cd77113-e6d6-4345-8483-5f1b1ddb866c/366c0b13-828c-411b-9570-e2a15ce26320','1cd77113-e6d6-4345-8483-5f1b1ddb866c',0,'9606620d-5348-46b9-a18b-b22dde70ce0c'),(12,'2026-02-01 15:13:41.704257','2026-02-01 15:13:48.870619','2026-02-01 15:13:48.869751',12,'192.168.122.100:6789:/volumes/_nogroup/2dbe4c39-4709-4ce8-bbd5-f96172636c6f/6f2ed66e-0dd2-4363-8246-72938d7418e0','2dbe4c39-4709-4ce8-bbd5-f96172636c6f',0,'d0e0c91e-3a47-422b-a1b3-6379945adda0'),(13,'2026-02-01 15:13:45.367928','2026-02-01 15:13:50.300635','2026-02-01 15:13:50.299715',13,'192.168.122.100:6789:/volumes/_nogroup/6044dbcf-cf6c-4aa2-a3c7-fa7e2cb2faf4/072f93e0-e115-4462-882b-057e50ec20e0','6044dbcf-cf6c-4aa2-a3c7-fa7e2cb2faf4',0,'a5fcbbf9-4847-4fb8-bf29-8ee85e41346f'),(14,'2026-02-01 15:14:04.413550','2026-02-01 15:14:09.449654','2026-02-01 15:14:09.447045',14,'192.168.122.100:6789:/volumes/_nogroup/c19a0244-e063-4af0-8894-414616a3f2b3/46f111b0-0ab2-4efd-b156-f926f784a2ea','c19a0244-e063-4af0-8894-414616a3f2b3',0,'490fa8b3-74af-4a57-9241-069234c4e378'),(15,'2026-02-01 15:14:18.687161','2026-02-01 15:14:22.801189','2026-02-01 15:14:22.800282',15,'192.168.122.100:6789:/volumes/_nogroup/aa2fa960-5933-441d-ba7d-210a851e8867/102aa16c-b8d8-4a6c-80e3-ae8484f4e160','aa2fa960-5933-441d-ba7d-210a851e8867',0,'b3520d07-82b9-40a0-870c-92f0045ce9a3'),(16,'2026-02-01 15:14:24.044787','2026-02-01 15:15:13.598926','2026-02-01 15:15:13.597857',16,'192.168.122.100:6789:/volumes/_nogroup/14f2cf47-b452-4ed6-a42d-a978bd461803/63782069-23d1-48cb-bfe3-e74b20e4e487','14f2cf47-b452-4ed6-a42d-a978bd461803',0,'bc96db38-fd86-4389-a17e-c4c816b9fcd6'),(17,'2026-02-01 15:14:27.532205','2026-02-01 15:14:32.053957','2026-02-01 15:14:32.052154',17,'192.168.122.100:6789:/volumes/_nogroup/62d0c62a-1088-49db-8483-cc680a52ec63/b3263236-0a75-46ae-ab59-83a44da59eb1','62d0c62a-1088-49db-8483-cc680a52ec63',0,'e7bcd33b-05d3-46ff-870e-df399daa3e80'),(18,'2026-02-01 15:14:35.841425','2026-02-01 15:14:40.436596','2026-02-01 15:14:40.435692',18,'192.168.122.100:6789:/volumes/_nogroup/234ef068-f24e-4b9f-8f83-1f4a01701b53/5f28e54f-2195-45a3-b703-e4eee7e9f6dd','234ef068-f24e-4b9f-8f83-1f4a01701b53',0,'dcaf509d-e561-4c7a-8c68-4368a55e477c'),(19,'2026-02-01 15:14:39.765310','2026-02-01 15:14:59.426739','2026-02-01 15:14:59.425374',19,'192.168.122.100:6789:/volumes/_nogroup/02a9afaa-78ab-4c60-9b65-efddd9ffb5df/86c82a78-ed68-479a-856d-a96ae3edab27','02a9afaa-78ab-4c60-9b65-efddd9ffb5df',0,'de62c57f-7fbe-45f8-bac4-1b4ab76ff204'),(20,'2026-02-01 15:14:43.911117','2026-02-01 15:14:47.800937','2026-02-01 15:14:47.799560',20,'192.168.122.100:6789:/volumes/_nogroup/986a6f65-322a-44eb-81bc-bb6e9d6f221a/8a0117e1-bdfc-47e2-9388-b50bb03f2da5','986a6f65-322a-44eb-81bc-bb6e9d6f221a',0,'db80003d-6090-48e2-8fc9-15642879cc0a'),(21,'2026-02-01 15:14:47.704705','2026-02-01 15:15:03.156478','2026-02-01 15:15:03.155414',21,'192.168.122.100:6789:/volumes/_nogroup/a0be7a54-7b29-45e1-9605-eb7321d359f2/bf7a0fa6-935f-438c-a9e0-4f04fe55824e','a0be7a54-7b29-45e1-9605-eb7321d359f2',0,'69d8028f-cfc5-479c-9c5d-61071bdd1381'),(22,'2026-02-01 15:14:51.350341','2026-02-01 15:14:56.470461','2026-02-01 15:14:56.469392',22,'192.168.122.100:6789:/volumes/_nogroup/bc96901b-a655-4999-93d2-e6667ec9f6a9/c7ded93a-afbe-41b1-ad33-9bd7a71748e6','bc96901b-a655-4999-93d2-e6667ec9f6a9',0,'02860f2f-8a1a-46b4-92f6-8d8baeb40d32'),(23,'2026-02-01 15:14:56.107782','2026-02-01 15:15:00.885795','2026-02-01 15:15:00.884721',23,'192.168.122.100:6789:/volumes/_nogroup/eb102253-6a1f-49e8-ab97-331a8e4964d4/343d7908-3f6a-4ee6-ae99-98e6f37f0d79','eb102253-6a1f-49e8-ab97-331a8e4964d4',0,'b318f26d-c5ba-4b30-bf05-fa18f89c46f5'),(24,'2026-02-01 15:15:01.483783','2026-02-01 15:15:07.556107','2026-02-01 15:15:07.554839',24,'192.168.122.100:6789:/volumes/_nogroup/ef425026-5828-4f43-8ed3-bad0eb8046b9/a4ef6e04-7742-4e57-b0b4-6785fe4b593f','ef425026-5828-4f43-8ed3-bad0eb8046b9',0,'f5d024bc-6d06-4f84-9b3c-55728eb4973f'),(25,'2026-02-01 15:15:09.825802','2026-02-01 15:15:21.167285','2026-02-01 15:15:21.166030',25,'192.168.122.100:6789:/volumes/_nogroup/7371576d-9b9d-4a2b-b2a0-dbf1c35daed8/d1d2aa30-3fda-423c-98e7-19123ab0f35e','7371576d-9b9d-4a2b-b2a0-dbf1c35daed8',0,'e10e3002-fd4c-4079-9b87-cbe2e7ec6fea'),(26,'2026-02-01 15:15:13.015726','2026-02-01 15:15:23.973943','2026-02-01 15:15:23.972751',26,'192.168.122.100:6789:/volumes/_nogroup/5dbda7ea-8a4a-45b6-808f-bba1d8cd95f4/a1249ef8-0fd1-4988-8b76-452c96f79331','5dbda7ea-8a4a-45b6-808f-bba1d8cd95f4',0,'be4254dc-3044-4c25-b2ad-9566e5360997'),(27,'2026-02-01 15:15:16.711438','2026-02-01 15:15:20.355325','2026-02-01 15:15:20.352594',27,'192.168.122.100:6789:/volumes/_nogroup/876b1428-1377-472c-b335-dfa9653f4509/cd46af17-607e-4852-a03f-51369d24dcbc','876b1428-1377-472c-b335-dfa9653f4509',0,'a334c037-08a2-4bbe-9b8e-07c3a3495827'),(28,'2026-02-01 15:15:27.678219','2026-02-01 15:15:31.832290','2026-02-01 15:15:31.831261',28,'192.168.122.100:6789:/volumes/_nogroup/f230efa5-4f47-4fa4-820a-fbfacc27744c/3d7a4d56-3b54-44b4-b837-eb1b19c5bef9','f230efa5-4f47-4fa4-820a-fbfacc27744c',0,'fea88125-6e9f-4f0b-9c6c-7b5344410a2c'),(29,'2026-02-01 15:15:35.458659','2026-02-01 15:16:40.660286','2026-02-01 15:16:40.659301',29,'192.168.122.100:6789:/volumes/_nogroup/f13e6643-de3c-4836-add7-2244ceca3720/aab2a1e1-5b57-40ad-8d7a-9d89f95d2b23','f13e6643-de3c-4836-add7-2244ceca3720',0,'c264ed03-7ac4-4e05-adf8-9a726b64a5d3'),(30,'2026-02-01 15:15:39.294985','2026-02-01 15:16:36.973577','2026-02-01 15:16:36.972596',30,'192.168.122.100:6789:/volumes/_nogroup/cc8298b6-cd36-4e3a-b5fa-1906378c83d8/225e29d2-d9a9-491f-bae7-2cbc01e3d01a','cc8298b6-cd36-4e3a-b5fa-1906378c83d8',0,'3c763863-5e8f-49b8-81e9-585990efe5e0'),(31,'2026-02-01 15:15:43.360167','2026-02-01 15:16:46.648041','2026-02-01 15:16:46.647101',31,'192.168.122.100:6789:/volumes/_nogroup/fda2fd7c-38e4-46f7-bc0a-f227e5de8aa7/a4042ccc-8fdb-40f2-b5da-d525eebcfdcb','fda2fd7c-38e4-46f7-bc0a-f227e5de8aa7',0,'75e621e1-8ba9-4c4b-b5ce-e9b0217a3cb3'),(32,'2026-02-01 15:15:46.260358','2026-02-01 15:16:33.388132','2026-02-01 15:16:33.387094',32,'192.168.122.100:6789:/volumes/_nogroup/66ba7d88-ae35-42fd-932a-84cc5334b587/8e410b52-d8de-4cae-8508-0fb58ac5241f','66ba7d88-ae35-42fd-932a-84cc5334b587',0,'696a9fac-7798-4635-9c2c-ae8fe333fca8'),(33,'2026-02-01 15:15:47.491255','2026-02-01 15:15:54.789387','2026-02-01 15:15:54.778502',33,'192.168.122.100:6789:/volumes/_nogroup/bcfe09f7-b95d-44d4-88ff-9ddff7f38222/895c1713-5e9a-4aa7-9027-9cea3dd8b5ea','bcfe09f7-b95d-44d4-88ff-9ddff7f38222',0,'2bbd2d3d-7521-4de6-a743-c7e8d21ca162'),(34,'2026-02-01 15:15:49.246735','2026-02-01 15:16:12.619573','2026-02-01 15:16:12.618353',34,'192.168.122.100:6789:/volumes/_nogroup/a8330130-cd80-47bb-ab6d-4bb6b88724d1/121881e8-6836-4fd0-8d00-03d9039e7468','a8330130-cd80-47bb-ab6d-4bb6b88724d1',0,'4d3ac138-94ae-4eec-89ee-f1ddca721234'),(35,'2026-02-01 15:15:59.871414','2026-02-01 15:16:05.768120','2026-02-01 15:16:05.767265',35,'192.168.122.100:6789:/volumes/_nogroup/0c14589f-b0af-4342-affb-d81a226bb4b2/e8f29e95-6292-426b-b4e0-b055082f1eee','0c14589f-b0af-4342-affb-d81a226bb4b2',0,'b7de5c01-2bbd-40ce-bad3-0602bad4a43f'),(36,'2026-02-01 15:15:59.995951','2026-02-01 15:16:04.927325','2026-02-01 15:16:04.926334',36,'192.168.122.100:6789:/volumes/_nogroup/67e50812-4602-4dc4-b942-a78b28ddb769/e36c6f1f-d00d-4b20-b8ba-f9207feca0ed','67e50812-4602-4dc4-b942-a78b28ddb769',0,'f3b5f476-b8d3-4632-9ecd-e4c644823a4f'),(37,'2026-02-01 15:16:08.114178','2026-02-01 15:16:15.833837','2026-02-01 15:16:15.832680',37,'192.168.122.100:6789:/volumes/_nogroup/90ad7db4-01ea-4e02-bd1a-db4113b80713/3ad32f37-d508-488d-a064-3cc2c5fb01ed','90ad7db4-01ea-4e02-bd1a-db4113b80713',0,'6ed3a1c1-dfe3-4c35-b18b-8c33e4de4b81'),(38,'2026-02-01 15:16:14.517279','2026-02-01 15:16:29.868947','2026-02-01 15:16:29.867572',38,'192.168.122.100:6789:/volumes/_nogroup/53873f8b-858c-4fab-a187-a58acce7cad2/52e2d3d9-e8df-4982-b844-eab1575eaea8','53873f8b-858c-4fab-a187-a58acce7cad2',0,'faf73bb6-10b3-4da0-8f2a-0df47217eff1'),(39,'2026-02-01 15:16:31.051372','2026-02-01 15:16:35.615584','2026-02-01 15:16:35.614311',39,'192.168.122.100:6789:/volumes/_nogroup/0bd1c69e-9d87-420b-8cc7-eab8d429d2d0/e66436b8-aa27-44ad-a68b-5fc46f0da8d3','0bd1c69e-9d87-420b-8cc7-eab8d429d2d0',0,'4a28859c-47da-4782-9fbb-f6f5621b1ed2'),(40,'2026-02-01 15:16:52.570289','2026-02-01 15:20:07.135307','2026-02-01 15:20:07.134141',40,'192.168.122.100:6789:/volumes/_nogroup/c5365cf8-68f4-4bb7-b1f2-7a560b4f3280/f4a26dae-3174-4ba3-b05a-4b9c53c9d5a2','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280',0,'166fcc6b-c414-4d6e-bb83-ad160b04597a'),(41,'2026-02-01 15:16:59.371650','2026-02-01 15:17:10.126729','2026-02-01 15:17:10.125698',41,'192.168.122.100:6789:/volumes/_nogroup/af1fdb5d-a0b1-4be1-a773-3eafab00aae8/43092e54-1971-4f06-9465-62c98a7959e3','af1fdb5d-a0b1-4be1-a773-3eafab00aae8',0,'0923cdff-6950-4db2-8296-68e0a6e09d3f'),(42,'2026-02-01 15:17:03.591381','2026-02-01 15:17:30.072186','2026-02-01 15:17:30.071218',42,'192.168.122.100:6789:/volumes/_nogroup/c9b2fd01-3509-428e-b915-0b74e783dc19/08d80c53-80dc-4183-9c16-84cb7c2a762c','c9b2fd01-3509-428e-b915-0b74e783dc19',0,'2957a2e9-e36f-4fae-a2e8-75575e52259b'),(43,'2026-02-01 15:17:14.120565','2026-02-01 15:17:18.145399','2026-02-01 15:17:18.142517',43,'192.168.122.100:6789:/volumes/_nogroup/6dbb3e62-b996-4ace-bb16-037502f09dce/2de0a33b-53fe-4bbd-9974-0c024599c273','6dbb3e62-b996-4ace-bb16-037502f09dce',0,'df68389d-84fe-4524-82e7-f0fc7d4ed4a8'),(44,'2026-02-01 15:17:22.186132','2026-02-01 15:18:07.967024','2026-02-01 15:18:07.964734',44,'192.168.122.100:6789:/volumes/_nogroup/eaae1ab0-0f33-4607-9838-62c2bdc360fb/8a0240ed-5f88-4931-965b-b8f7feb2baae','eaae1ab0-0f33-4607-9838-62c2bdc360fb',0,'e3e32ee4-062a-480e-a81c-aa95e6892b4e'),(45,'2026-02-01 15:17:22.992686','2026-02-01 15:18:15.375624','2026-02-01 15:18:15.374732',45,'192.168.122.100:6789:/volumes/_nogroup/85ddb4b4-f1ca-4471-8fc6-5c185f91fcdb/c9a3a2d8-1885-4fd7-9e5b-aba6a99f983b','85ddb4b4-f1ca-4471-8fc6-5c185f91fcdb',0,'9d39f516-8448-4cd5-bb33-f3a377da77f0'),(46,'2026-02-01 15:17:33.585730','2026-02-01 15:17:37.282241','2026-02-01 15:17:37.281352',46,'192.168.122.100:6789:/volumes/_nogroup/8c24d660-d99e-4a84-8d8a-dd162ef7a432/78726976-b5a8-431b-96ab-e953f68fd3ff','8c24d660-d99e-4a84-8d8a-dd162ef7a432',0,'ab09f52e-9006-40a8-a7a9-07be3f47dc6c'),(47,'2026-02-01 15:17:41.584978','2026-02-01 15:17:45.869759','2026-02-01 15:17:45.868829',47,'192.168.122.100:6789:/volumes/_nogroup/86350af1-da40-441c-befe-cde1cbd30541/d292e24c-a6d4-450e-a222-6c2b805383e3','86350af1-da40-441c-befe-cde1cbd30541',0,'1a8e1c4b-4f2d-4ad0-8aae-e47bdfc53580'),(48,'2026-02-01 15:17:48.646198','2026-02-01 15:18:00.042295','2026-02-01 15:18:00.040320',48,'192.168.122.100:6789:/volumes/_nogroup/ff89896c-730f-4d0f-b5d3-5b63ed6c492d/861fb7cb-7d04-4083-bc0f-ab5d8a2821b0','ff89896c-730f-4d0f-b5d3-5b63ed6c492d',0,'b610f7fc-b384-438f-9969-96a9587dd7b1'),(49,'2026-02-01 15:17:49.335906','2026-02-01 15:17:52.785953','2026-02-01 15:17:52.785010',49,'192.168.122.100:6789:/volumes/_nogroup/887d0676-527e-47b5-bf80-254c50cf4633/383e1c99-f6dd-41d8-9eef-e85139cf1415','887d0676-527e-47b5-bf80-254c50cf4633',0,'cbff8506-750e-4b1e-948d-3dc5df7e6c7b'),(50,'2026-02-01 15:17:56.355387','2026-02-01 15:18:00.200457','2026-02-01 15:18:00.198035',50,'192.168.122.100:6789:/volumes/_nogroup/92466679-2a01-470b-96b5-c6d88c0b6509/1fbe2a21-7c37-459f-8e2c-6b17c0091c4a','92466679-2a01-470b-96b5-c6d88c0b6509',0,'728d0ea8-1522-48e8-b0ea-437c8e1645f2'),(51,'2026-02-01 15:17:59.864556','2026-02-01 15:18:00.946206','2026-02-01 15:18:00.944881',51,'192.168.122.100:6789:/volumes/_nogroup/57b6c133-b657-4e29-ab3e-f40863c80360/b946c66e-6da4-4a91-b4c8-4c95fea0475d','57b6c133-b657-4e29-ab3e-f40863c80360',0,'105c5ed9-8f34-491b-9aac-e10f78c298ef'),(52,'2026-02-01 15:18:03.556483','2026-02-01 15:18:07.944297','2026-02-01 15:18:07.942689',52,'192.168.122.100:6789:/volumes/_nogroup/f71d70ca-3bed-407e-bd13-18c8cbf0995f/4a423dca-0a02-4c3b-a2ec-997402614fd5','f71d70ca-3bed-407e-bd13-18c8cbf0995f',0,'98fe5927-40d9-4820-a776-eb3eca3af241'),(53,'2026-02-01 15:18:20.331944','2026-02-01 15:19:43.927422','2026-02-01 15:19:43.925900',53,'192.168.122.100:6789:/volumes/_nogroup/e1bb4ab8-c449-4ad1-83d0-cba448059572/7d6b8a93-2239-49a1-a970-ce3d1b5be304','e1bb4ab8-c449-4ad1-83d0-cba448059572',0,'a72fb0fa-58ec-49fd-bb5b-1358f4700920'),(54,'2026-02-01 15:18:26.514129','2026-02-01 15:18:37.367092','2026-02-01 15:18:37.364108',54,'192.168.122.100:6789:/volumes/_nogroup/cc1a1612-4970-46ec-aefe-db2d1c0f8688/b7cb2b49-e944-42cc-9aea-91bc5616fa3a','cc1a1612-4970-46ec-aefe-db2d1c0f8688',0,'89d75b59-188a-4e19-a4a1-18f4cd45494e'),(55,'2026-02-01 15:18:39.352086','2026-02-01 15:18:43.927274','2026-02-01 15:18:43.925932',55,'192.168.122.100:6789:/volumes/_nogroup/c38a331c-6d1f-4342-961a-602e5b4f62e5/839cb248-0acc-449c-9f35-9972fc8e8c70','c38a331c-6d1f-4342-961a-602e5b4f62e5',0,'7e3b7534-aa50-4249-bfef-edee151acd66'),(56,'2026-02-01 15:18:40.893099','2026-02-01 15:18:51.756003','2026-02-01 15:18:51.755146',56,'192.168.122.100:6789:/volumes/_nogroup/b77cdfcb-ad1c-46a1-b6bd-1d432fc4f565/e581cce0-6e5d-4f0c-9f72-b6f802b6db39','b77cdfcb-ad1c-46a1-b6bd-1d432fc4f565',0,'ae8585e8-2b72-4a58-b713-7cb1bcf672ea'),(57,'2026-02-01 15:18:47.047515','2026-02-01 15:18:50.943632','2026-02-01 15:18:50.942370',57,'192.168.122.100:6789:/volumes/_nogroup/f7b904c4-a5f8-4c39-a831-93f4c8a9a0a9/68e0a21d-a250-4452-852e-a3bef2850322','f7b904c4-a5f8-4c39-a831-93f4c8a9a0a9',0,'71a0d1f3-6020-46f0-b8d1-67ba0f81fcda'),(58,'2026-02-01 15:18:59.891364','2026-02-01 15:19:36.922503','2026-02-01 15:19:36.920612',58,'192.168.122.100:6789:/volumes/_nogroup/e91ca10f-a5ab-4efe-a6b7-448ed904538e/461aa132-07e7-4d84-b5b6-931252a109cb','e91ca10f-a5ab-4efe-a6b7-448ed904538e',0,'0e057269-a854-4a7a-9162-607e6aa8f5be'),(59,'2026-02-01 15:19:02.919682','2026-02-01 15:19:09.919696','2026-02-01 15:19:09.918747',59,'192.168.122.100:6789:/volumes/_nogroup/d707ecfe-f6ee-49fe-a02c-3c565e379dff/ddd00d22-d077-475e-a668-ba7be553860a','d707ecfe-f6ee-49fe-a02c-3c565e379dff',0,'66fd1105-85e9-40df-b47b-e9b34514320d'),(60,'2026-02-01 15:19:03.791806','2026-02-01 15:19:31.231123','2026-02-01 15:19:31.230115',60,'192.168.122.100:6789:/volumes/_nogroup/5f371bcf-0672-4b5f-9567-1fcaf6940905/ca3ae955-cb00-4008-bc9e-6ebd7fc60edf','5f371bcf-0672-4b5f-9567-1fcaf6940905',0,'5052c0cd-2e67-4e05-a65c-513460f7c448'),(61,'2026-02-01 15:19:07.846959','2026-02-01 15:19:27.750365','2026-02-01 15:19:27.748859',61,'192.168.122.100:6789:/volumes/_nogroup/7b1b736a-26a1-4658-8b8f-779a2b222e80/0af9b831-6215-4111-ba2a-47cc2086c878','7b1b736a-26a1-4658-8b8f-779a2b222e80',0,'40e720c7-c94f-49ed-a0a9-8e37bf459eaa'),(62,'2026-02-01 15:19:11.878248','2026-02-01 15:19:24.246680','2026-02-01 15:19:24.245460',62,'192.168.122.100:6789:/volumes/_nogroup/d57288c1-6475-4afc-b89b-63e0397aa3d5/24b4e50d-218b-41bb-b9dd-f25fddccd8d7','d57288c1-6475-4afc-b89b-63e0397aa3d5',0,'54f17582-b15f-4d58-afe7-aa2d3b34e68a'),(63,'2026-02-01 15:19:15.887039','2026-02-01 15:19:20.657827','2026-02-01 15:19:20.656945',63,'192.168.122.100:6789:/volumes/_nogroup/7bb072d4-78e4-494f-ab70-eb9c366fac63/3168f927-e301-452a-884c-a434cfe97158','7bb072d4-78e4-494f-ab70-eb9c366fac63',0,'5e21ec08-94d7-420a-bba2-6081f7a22396'),(64,'2026-02-01 15:19:18.102592','2026-02-01 15:19:24.996581','2026-02-01 15:19:24.995353',64,'192.168.122.100:6789:/volumes/_nogroup/db1d1fea-0e00-4e6b-b733-ef0fe090c2f5/10b4830f-ffdf-472e-bb12-472493dd5549','db1d1fea-0e00-4e6b-b733-ef0fe090c2f5',0,'1dd8a2b0-5665-4878-9d36-db6ee7ae8ef1'),(65,'2026-02-01 15:19:28.451353','2026-02-01 15:19:33.369624','2026-02-01 15:19:33.368612',65,'192.168.122.100:6789:/volumes/_nogroup/69f497f0-f1d5-405b-b865-e545c0627b3a/a80aa19e-424e-4e1a-a7e9-653f5a86eda0','69f497f0-f1d5-405b-b865-e545c0627b3a',0,'f44a7849-222c-47ed-b18b-a0e96b9e7fc5'),(66,'2026-02-01 15:19:49.282672','2026-02-01 15:19:57.768853','2026-02-01 15:19:57.767502',66,'192.168.122.100:6789:/volumes/_nogroup/5b1172f7-abae-4452-a7de-df2b972dd4b6/a22da935-3d14-467d-800a-8fe6059d4763','5b1172f7-abae-4452-a7de-df2b972dd4b6',0,'6914b090-9cdc-4b6e-b7a6-40452a06d324'),(67,'2026-02-01 15:19:51.678911','2026-02-01 15:19:51.677764',NULL,0,'192.168.122.100:6789:/volumes/_nogroup/5f542ebc-7768-479b-a371-3e911afa4848/88f8d8b2-1944-472d-8ceb-5fdb60ce8202','5f542ebc-7768-479b-a371-3e911afa4848',0,'1e364dfa-b2ac-44f4-9302-b88a4ed57373'),(68,'2026-02-01 15:19:53.080985','2026-02-01 15:19:53.644268','2026-02-01 15:19:53.643410',68,'192.168.122.100:6789:/volumes/_nogroup/a8d162ed-6915-4c91-85d0-a5648c53b8d8/5b65efb9-bab8-427f-8dd7-fedcb50bea0f','a8d162ed-6915-4c91-85d0-a5648c53b8d8',0,'54328913-b8b2-4f6d-80b2-7a8528ca9f22'),(69,'2026-02-01 15:19:56.646185','2026-02-01 15:20:44.872417','2026-02-01 15:20:44.871249',69,'192.168.122.100:6789:/volumes/_nogroup/eae18ccb-38ff-41a6-9b8e-4ea12cbf2edd/aaba7f52-5353-40f7-aa14-6d95137a862b','eae18ccb-38ff-41a6-9b8e-4ea12cbf2edd',0,'e3d8bc41-260c-48b2-8b79-05cd793c92c4'),(70,'2026-02-01 15:20:09.280349','2026-02-01 15:20:12.884071','2026-02-01 15:20:12.882794',70,'192.168.122.100:6789:/volumes/_nogroup/56740215-53be-496a-bb36-0fdd2c1498f9/7fe7cc3e-ade4-459d-8ee4-4b9d4afebbf6','56740215-53be-496a-bb36-0fdd2c1498f9',0,'6c5dedce-9f15-4874-ad8d-30c4d41f36cf'),(71,'2026-02-01 15:20:16.632475','2026-02-01 15:20:20.263411','2026-02-01 15:20:20.262368',71,'192.168.122.100:6789:/volumes/_nogroup/81f31f1a-09e0-4333-ae71-05dc6131f94c/7b4dae3c-af1f-4fca-9e91-24f56e0bd08e','81f31f1a-09e0-4333-ae71-05dc6131f94c',0,'142ff8fa-a4fb-408d-bce5-397db5a4e177'),(72,'2026-02-01 15:21:39.806899','2026-02-01 15:21:51.699942','2026-02-01 15:21:51.697635',72,'192.168.122.100:6789:/volumes/_nogroup/091d85e3-6421-421c-a022-3095345db8aa/6f3fb38f-4fb5-428d-af1f-466faa7d1587','091d85e3-6421-421c-a022-3095345db8aa',0,'9667f3a5-e9bf-4d81-bddc-9ef289cee7f5'),(73,'2026-02-01 15:22:05.342432','2026-02-01 15:22:17.233336','2026-02-01 15:22:17.232375',73,'192.168.122.100:6789:/volumes/_nogroup/e03e65cf-03e2-407f-9515-a854a7393b45/efb0581a-17af-495b-a4b5-cac17d7af446','e03e65cf-03e2-407f-9515-a854a7393b45',0,'b99d6419-5d4d-4517-876e-8b13881805bb');
/*!40000 ALTER TABLE `share_instance_export_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instance_export_locations_metadata`
--

DROP TABLE IF EXISTS `share_instance_export_locations_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instance_export_locations_metadata` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `export_location_id` int(11) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `elm_el_id_uc` (`export_location_id`,`key`,`deleted`),
  CONSTRAINT `elm_id_fk` FOREIGN KEY (`export_location_id`) REFERENCES `share_instance_export_locations` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instance_export_locations_metadata`
--

LOCK TABLES `share_instance_export_locations_metadata` WRITE;
/*!40000 ALTER TABLE `share_instance_export_locations_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_instance_export_locations_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instances`
--

DROP TABLE IF EXISTS `share_instances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instances` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `share_id` varchar(36) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `share_network_id` varchar(36) DEFAULT NULL,
  `share_server_id` varchar(36) DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  `access_rules_status` varchar(255) DEFAULT NULL,
  `replica_state` varchar(255) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  `cast_rules_to_readonly` tinyint(1) NOT NULL,
  `progress` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `si_share_network_fk` (`share_network_id`),
  KEY `si_share_server_fk` (`share_server_id`),
  KEY `si_az_id_fk` (`availability_zone_id`),
  KEY `si_st_id_fk` (`share_type_id`),
  KEY `share_instances_share_id_idx` (`share_id`),
  CONSTRAINT `si_az_id_fk` FOREIGN KEY (`availability_zone_id`) REFERENCES `availability_zones` (`id`),
  CONSTRAINT `si_share_fk` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`),
  CONSTRAINT `si_share_network_fk` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`),
  CONSTRAINT `si_share_server_fk` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`),
  CONSTRAINT `si_st_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instances`
--

LOCK TABLES `share_instances` WRITE;
/*!40000 ALTER TABLE `share_instances` DISABLE KEYS */;
INSERT INTO `share_instances` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_id`, `host`, `status`, `scheduled_at`, `launched_at`, `terminated_at`, `share_network_id`, `share_server_id`, `availability_zone_id`, `access_rules_status`, `replica_state`, `share_type_id`, `cast_rules_to_readonly`, `progress`) VALUES ('2026-02-01 15:14:39.527557','2026-02-01 15:14:59.445215','2026-02-01 15:14:59.444373','02a9afaa-78ab-4c60-9b65-efddd9ffb5df','02a9afaa-78ab-4c60-9b65-efddd9ffb5df','b9e29865-8feb-4a35-b719-26ba10e308bf','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:14:39','2026-02-01 15:14:39','2026-02-01 15:14:59',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'c056af43-2681-4a32-98f6-e60c1f1a3560',0,'100%'),('2026-02-01 15:21:39.503854','2026-02-01 15:21:51.712141','2026-02-01 15:21:51.711612','091d85e3-6421-421c-a022-3095345db8aa','091d85e3-6421-421c-a022-3095345db8aa','af4e3236-7c5d-4b62-9828-44f21ee7a89e','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:21:39','2026-02-01 15:21:39','2026-02-01 15:21:51',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'232f280e-a80b-4dbd-be5c-473370cb110d',0,'100%'),('2026-02-01 15:16:30.802854','2026-02-01 15:16:35.635399','2026-02-01 15:16:35.634676','0bd1c69e-9d87-420b-8cc7-eab8d429d2d0','0bd1c69e-9d87-420b-8cc7-eab8d429d2d0','0aaab4f5-8dee-46a6-8e16-748176e8927c','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:16:30','2026-02-01 15:16:31','2026-02-01 15:16:35',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'63d145b6-fb37-4811-991f-0edbfd2cd9ff',0,'100%'),('2026-02-01 15:15:55.766071','2026-02-01 15:16:05.793216','2026-02-01 15:16:05.792707','0c14589f-b0af-4342-affb-d81a226bb4b2','0c14589f-b0af-4342-affb-d81a226bb4b2','afee7923-6ff7-4cad-905b-2c64c71cbc85','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:15:55','2026-02-01 15:15:56','2026-02-01 15:16:05',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'120a16ad-b887-4c32-bd69-d344d97a4eee',0,'100%'),('2026-02-01 15:13:06.868577','2026-02-01 15:14:21.230140','2026-02-01 15:14:21.229519','0d8696eb-14a5-4abf-b5f8-d5c0093d2c06','0d8696eb-14a5-4abf-b5f8-d5c0093d2c06','0d466b60-2648-465b-aef7-5ba809864391','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:13:06','2026-02-01 15:13:07','2026-02-01 15:14:20',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'d12a5a5d-639b-477e-9123-330697ff0216',0,'100%'),('2026-02-01 15:14:23.773466','2026-02-01 15:15:13.613769','2026-02-01 15:15:13.613139','14f2cf47-b452-4ed6-a42d-a978bd461803','14f2cf47-b452-4ed6-a42d-a978bd461803','fcd5b66f-69eb-467b-8a17-b7c7c3d3f328','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:14:23','2026-02-01 15:14:24','2026-02-01 15:15:13',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'71a8cb03-a879-4fa1-9570-d4a2c3127be2',0,'100%'),('2026-02-01 15:13:38.638011','2026-02-01 15:13:58.199756','2026-02-01 15:13:58.199063','1cd77113-e6d6-4345-8483-5f1b1ddb866c','1cd77113-e6d6-4345-8483-5f1b1ddb866c','1215de86-6ef2-4d6a-8dcb-b2bcf82846c1','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:13:38','2026-02-01 15:13:38','2026-02-01 15:13:58',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'3dda19bc-6043-431c-bdc6-b4dc346cfacf',0,'100%'),('2026-02-01 15:15:32.420035','2026-02-01 15:15:36.482452','2026-02-01 15:15:36.481318','1f173666-6376-4135-9a7c-affde91a684c','1f173666-6376-4135-9a7c-affde91a684c','f6d21267-86b4-4a5b-b0bb-04567d756f96','','deleted','2026-02-01 15:15:32',NULL,NULL,NULL,NULL,NULL,'active',NULL,'e40bf1b4-fd26-4fd8-95d0-210613d1d862',0,NULL),('2026-02-01 15:14:35.275244','2026-02-01 15:14:40.448843','2026-02-01 15:14:40.448306','234ef068-f24e-4b9f-8f83-1f4a01701b53','234ef068-f24e-4b9f-8f83-1f4a01701b53','ee2ee742-7ede-4f5f-aba6-102f266b036a','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:14:35','2026-02-01 15:14:35','2026-02-01 15:14:40',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'71a8cb03-a879-4fa1-9570-d4a2c3127be2',0,'100%'),('2026-02-01 15:15:59.850416','2026-02-01 15:16:07.451086','2026-02-01 15:16:07.450219','28a27dd3-fe1c-432f-9496-1767b8d5d0ee','28a27dd3-fe1c-432f-9496-1767b8d5d0ee','3c436459-63a6-4ad6-adc8-8a42a7ab847a','','deleted','2026-02-01 15:15:59',NULL,NULL,NULL,NULL,NULL,'active',NULL,'64010b88-05ad-4c28-a92b-293b13eb246e',0,NULL),('2026-02-01 15:16:35.954061','2026-02-01 15:16:39.761337','2026-02-01 15:16:39.760623','29d0995f-463a-427a-a641-d0917221f4b1','29d0995f-463a-427a-a641-d0917221f4b1','958ab4ab-f5aa-4908-a2a1-1363ed9f1ad6','','deleted','2026-02-01 15:16:35',NULL,NULL,NULL,NULL,NULL,'active',NULL,'37d89b9e-0f7e-463d-91bf-eac4c891403e',0,NULL),('2026-02-01 15:13:41.524832','2026-02-01 15:13:48.888051','2026-02-01 15:13:48.887507','2dbe4c39-4709-4ce8-bbd5-f96172636c6f','2dbe4c39-4709-4ce8-bbd5-f96172636c6f','eaada3c9-76df-46bd-b05e-e97f16f97303','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:13:41','2026-02-01 15:13:41','2026-02-01 15:13:48',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'e90f5e35-a2e5-4b1f-b6c6-9946da8a57e6',0,'100%'),('2026-02-01 15:13:28.198954','2026-02-01 15:13:32.163272','2026-02-01 15:13:32.162235','3147dea9-81aa-476a-8ff6-685b8fe5fd2e','3147dea9-81aa-476a-8ff6-685b8fe5fd2e','95b00e29-de3a-4052-9491-e19c17654b49','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:13:28','2026-02-01 15:13:28','2026-02-01 15:13:31',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'d12a5a5d-639b-477e-9123-330697ff0216',0,'100%'),('2026-02-01 15:15:40.731465','2026-02-01 15:15:48.373682','2026-02-01 15:15:48.372426','485ffd97-03c3-46cc-b65e-d1887cac0370','485ffd97-03c3-46cc-b65e-d1887cac0370','80c6994e-ac3e-4df1-b8f0-3220a10b91d6','','deleted','2026-02-01 15:15:40',NULL,NULL,NULL,NULL,NULL,'active',NULL,'d3a796c1-974d-4d4f-86d6-31e24af5bf80',0,NULL),('2026-02-01 15:15:36.821947','2026-02-01 15:15:40.463337','2026-02-01 15:15:40.462766','4caf8669-6cd3-47b6-a09e-0e5d51788418','4caf8669-6cd3-47b6-a09e-0e5d51788418','66030396-f1e3-4abe-a840-a120fdad9e5a','','deleted','2026-02-01 15:15:36',NULL,NULL,NULL,NULL,NULL,'active',NULL,'d3e4a564-7be4-42a0-848e-6cd396381438',0,NULL),('2026-02-01 15:15:55.461233','2026-02-01 15:15:58.984744','2026-02-01 15:15:58.983609','4d4ab105-d6de-496f-8e98-c67402ee1bea','4d4ab105-d6de-496f-8e98-c67402ee1bea','87bc00c7-ffd8-4d9c-a2b4-29c6bd5ddbd7','','deleted','2026-02-01 15:15:55',NULL,NULL,NULL,NULL,NULL,'active',NULL,'07adc9ef-2272-4b23-ba8b-3bc6ea05d153',0,NULL),('2026-02-01 15:16:14.194529','2026-02-01 15:16:29.892172','2026-02-01 15:16:29.891467','53873f8b-858c-4fab-a187-a58acce7cad2','53873f8b-858c-4fab-a187-a58acce7cad2','30ac0e47-abe2-4b5f-ba75-983911fa7443','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:16:14','2026-02-01 15:16:14','2026-02-01 15:16:29',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'847063aa-e54d-49d1-b390-6611881b6691',0,'100%'),('2026-02-01 15:13:20.294596','2026-02-01 15:13:26.417420','2026-02-01 15:13:26.416724','55a7edb3-0742-4b44-9cb7-64d96e0ec803','55a7edb3-0742-4b44-9cb7-64d96e0ec803','f2b934af-baf5-452c-a0dd-7c6d84e45aaf','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:13:20','2026-02-01 15:13:20','2026-02-01 15:13:26',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'3cd49bbe-54fc-43fb-9feb-ba0c28e6948f',0,'100%'),('2026-02-01 15:20:09.075998','2026-02-01 15:20:12.904679','2026-02-01 15:20:12.903983','56740215-53be-496a-bb36-0fdd2c1498f9','56740215-53be-496a-bb36-0fdd2c1498f9','06eb3108-1fb0-4cc9-802d-0d29a3e86c17','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:20:09','2026-02-01 15:20:09','2026-02-01 15:20:12',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'e6371ab2-3a9c-4858-bc71-54efe991623a',0,'100%'),('2026-02-01 15:17:28.828142','2026-02-01 15:18:00.969396','2026-02-01 15:18:00.967638','57b6c133-b657-4e29-ab3e-f40863c80360','57b6c133-b657-4e29-ab3e-f40863c80360','a92fd102-7531-4d03-a3d1-67447454e228','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:17:28','2026-02-01 15:17:29','2026-02-01 15:18:00',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'9e8345c3-c425-444a-948b-e657e9fcd15d',0,'100%'),('2026-02-01 15:19:48.990203','2026-02-01 15:19:57.792599','2026-02-01 15:19:57.791707','5b1172f7-abae-4452-a7de-df2b972dd4b6','5b1172f7-abae-4452-a7de-df2b972dd4b6','a34da5d4-cbdc-49b1-af14-452229f21807','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:19:49','2026-02-01 15:19:49','2026-02-01 15:19:57',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'e6371ab2-3a9c-4858-bc71-54efe991623a',0,'100%'),('2026-02-01 15:15:12.756685','2026-02-01 15:15:23.988714','2026-02-01 15:15:23.988138','5dbda7ea-8a4a-45b6-808f-bba1d8cd95f4','5dbda7ea-8a4a-45b6-808f-bba1d8cd95f4','b0b174d4-b800-499f-9f56-e082e24700da','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:15:12','2026-02-01 15:15:13','2026-02-01 15:15:23',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'70f1e3e3-1df6-4e6a-972a-e4316600cd5d',0,'100%'),('2026-02-01 15:19:03.506172','2026-02-01 15:19:31.250152','2026-02-01 15:19:31.249563','5f371bcf-0672-4b5f-9567-1fcaf6940905','5f371bcf-0672-4b5f-9567-1fcaf6940905','62d30550-2210-40f2-83b1-24b67cb16735','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:19:03','2026-02-01 15:19:03','2026-02-01 15:19:31',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'4f1b79a2-3597-416f-9735-5bd373e5c8ee',0,'100%'),('2026-02-01 15:19:51.369162','2026-02-01 15:19:59.207442',NULL,'False','5f542ebc-7768-479b-a371-3e911afa4848','99096eba-8e8a-4266-a1a9-b11ede8cde3e','hostgroup@cephfs#cephfs','available','2026-02-01 15:19:51','2026-02-01 15:19:51',NULL,NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'5b0c2719-9cba-4adb-b36c-2f65cfd23a4c',0,'100%'),('2026-02-01 15:13:45.138707','2026-02-01 15:13:50.315740','2026-02-01 15:13:50.315182','6044dbcf-cf6c-4aa2-a3c7-fa7e2cb2faf4','6044dbcf-cf6c-4aa2-a3c7-fa7e2cb2faf4','83161a20-ce0c-4c83-aca6-ee7e0d66a73c','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:13:45','2026-02-01 15:13:45','2026-02-01 15:13:50',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'b107dc0b-a3d2-4667-a455-9555f6c00178',0,'100%'),('2026-02-01 15:13:08.130050','2026-02-01 15:13:20.801633','2026-02-01 15:13:20.801018','618c0e6c-2fb1-44ff-85f4-15df368e2591','618c0e6c-2fb1-44ff-85f4-15df368e2591','ed775457-44d0-495d-ad2f-880aebb5c6c4','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:13:08','2026-02-01 15:13:08','2026-02-01 15:13:20',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'a36752ae-228c-4fa4-8961-f141e5222f47',0,'100%'),('2026-02-01 15:14:27.297966','2026-02-01 15:14:32.068078','2026-02-01 15:14:32.067484','62d0c62a-1088-49db-8483-cc680a52ec63','62d0c62a-1088-49db-8483-cc680a52ec63','14a2235d-24be-4744-8e29-d36fdcb47054','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:14:27','2026-02-01 15:14:27','2026-02-01 15:14:31',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'71a8cb03-a879-4fa1-9570-d4a2c3127be2',0,'100%'),('2026-02-01 15:15:45.958921','2026-02-01 15:16:33.402034','2026-02-01 15:16:33.401347','66ba7d88-ae35-42fd-932a-84cc5334b587','66ba7d88-ae35-42fd-932a-84cc5334b587','dede97d8-5245-478c-a2ce-9bf99f2c6aa7','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:15:46','2026-02-01 15:15:46','2026-02-01 15:16:33',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'29b95f67-19b6-4d0c-881b-ecde5688f59a',0,'100%'),('2026-02-01 15:15:57.618349','2026-02-01 15:16:04.941616','2026-02-01 15:16:04.940837','67e50812-4602-4dc4-b942-a78b28ddb769','67e50812-4602-4dc4-b942-a78b28ddb769','11fe694e-7f17-4b41-ba35-c9228ad1576c','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:15:57','2026-02-01 15:16:00','2026-02-01 15:16:04',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'a811e5d0-f6d5-4017-bb5f-544fc27e7e76',0,'100%'),('2026-02-01 15:19:28.146700','2026-02-01 15:19:33.383429','2026-02-01 15:19:33.382632','69f497f0-f1d5-405b-b865-e545c0627b3a','69f497f0-f1d5-405b-b865-e545c0627b3a','6d3162f4-a7f0-42c5-8ae9-bcccd79571a2','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:19:28','2026-02-01 15:19:28','2026-02-01 15:19:33',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'83bac904-ede0-4c77-b192-b7b619e38cb3',0,'100%'),('2026-02-01 15:17:13.841534','2026-02-01 15:17:18.167459','2026-02-01 15:17:18.166792','6dbb3e62-b996-4ace-bb16-037502f09dce','6dbb3e62-b996-4ace-bb16-037502f09dce','9d558349-221a-4a98-8731-9363b32b3eae','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:17:13','2026-02-01 15:17:14','2026-02-01 15:17:17',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'f74f4e50-b67a-4dd2-8817-d029903f2283',0,'100%'),('2026-02-01 15:15:09.572608','2026-02-01 15:15:21.197706','2026-02-01 15:15:21.197202','7371576d-9b9d-4a2b-b2a0-dbf1c35daed8','7371576d-9b9d-4a2b-b2a0-dbf1c35daed8','c33bbc3d-caeb-43d8-aff9-0eb1aca90ec2','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:15:09','2026-02-01 15:15:09','2026-02-01 15:15:20',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'61d66fc8-1151-4700-8fe3-06f0671259ab',0,'100%'),('2026-02-01 15:16:07.775730','2026-02-01 15:16:11.248372','2026-02-01 15:16:11.247696','7825dc80-7769-4b1b-9ea2-6f12faa35dea','7825dc80-7769-4b1b-9ea2-6f12faa35dea','452a5ef1-9894-470d-a6d7-5122ea8f2101','','deleted','2026-02-01 15:16:07',NULL,NULL,NULL,NULL,NULL,'active',NULL,'5334ac45-44fc-49d0-95bb-7c266db24118',0,NULL),('2026-02-01 15:19:07.581699','2026-02-01 15:19:27.767242','2026-02-01 15:19:27.766552','7b1b736a-26a1-4658-8b8f-779a2b222e80','7b1b736a-26a1-4658-8b8f-779a2b222e80','ef02fcc2-7d7d-46b1-9994-e24d68e5b43f','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:19:07','2026-02-01 15:19:07','2026-02-01 15:19:27',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'4f1b79a2-3597-416f-9735-5bd373e5c8ee',0,'100%'),('2026-02-01 15:19:15.610721','2026-02-01 15:19:20.671824','2026-02-01 15:19:20.671341','7bb072d4-78e4-494f-ab70-eb9c366fac63','7bb072d4-78e4-494f-ab70-eb9c366fac63','8f16715d-9b52-40a1-a5b4-5d4cfa9e7098','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:19:15','2026-02-01 15:19:15','2026-02-01 15:19:20',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'4f1b79a2-3597-416f-9735-5bd373e5c8ee',0,'100%'),('2026-02-01 15:20:16.296582','2026-02-01 15:20:20.277116','2026-02-01 15:20:20.276547','81f31f1a-09e0-4333-ae71-05dc6131f94c','81f31f1a-09e0-4333-ae71-05dc6131f94c','5a3a6e00-42bf-4a75-8d4a-3812e97dd737','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:20:16','2026-02-01 15:20:16','2026-02-01 15:20:20',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'e6371ab2-3a9c-4858-bc71-54efe991623a',0,'100%'),('2026-02-01 15:16:44.491304','2026-02-01 15:16:48.505327','2026-02-01 15:16:48.504288','842ff534-2c37-4a3f-ace8-366d454627c2','842ff534-2c37-4a3f-ace8-366d454627c2','e5786088-510e-4fe1-90e0-1b11281ce4ea','','deleted','2026-02-01 15:16:44',NULL,NULL,NULL,NULL,NULL,'active',NULL,'aceeeaf5-0220-422f-ad4e-febda069bdd9',0,NULL),('2026-02-01 15:17:22.731923','2026-02-01 15:18:15.388594','2026-02-01 15:18:15.387953','85ddb4b4-f1ca-4471-8fc6-5c185f91fcdb','85ddb4b4-f1ca-4471-8fc6-5c185f91fcdb','02ed6534-95a8-4e9b-9349-6e1c0bb2c8e7','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:17:22','2026-02-01 15:17:23','2026-02-01 15:18:15',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'9438b119-75d0-4d28-9efc-827b70bc86e1',0,'100%'),('2026-02-01 15:17:41.348757','2026-02-01 15:17:45.883898','2026-02-01 15:17:45.883336','86350af1-da40-441c-befe-cde1cbd30541','86350af1-da40-441c-befe-cde1cbd30541','17e2b644-71c7-41fe-b778-caad6d93fe7c','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:17:41','2026-02-01 15:17:41','2026-02-01 15:17:45',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'9438b119-75d0-4d28-9efc-827b70bc86e1',0,'100%'),('2026-02-01 15:15:16.439282','2026-02-01 15:15:20.377756','2026-02-01 15:15:20.377047','876b1428-1377-472c-b335-dfa9653f4509','876b1428-1377-472c-b335-dfa9653f4509','21ab09e5-1ca2-4aa9-98cf-47edc7e15053','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:15:16','2026-02-01 15:15:16','2026-02-01 15:15:20',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'70f1e3e3-1df6-4e6a-972a-e4316600cd5d',0,'100%'),('2026-02-01 15:17:49.144301','2026-02-01 15:17:52.801185','2026-02-01 15:17:52.800536','887d0676-527e-47b5-bf80-254c50cf4633','887d0676-527e-47b5-bf80-254c50cf4633','bfddc711-d955-4cc4-b66a-b9154e64b8b0','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:17:49','2026-02-01 15:17:49','2026-02-01 15:17:52',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'9438b119-75d0-4d28-9efc-827b70bc86e1',0,'100%'),('2026-02-01 15:15:48.721451','2026-02-01 15:15:59.571418','2026-02-01 15:15:59.570682','8bd1618c-4bc4-40ce-9685-813d5ddbafd1','8bd1618c-4bc4-40ce-9685-813d5ddbafd1','ab8e28a4-0b20-4886-b306-34d342be02ae','','deleted','2026-02-01 15:15:48',NULL,NULL,NULL,NULL,NULL,'active',NULL,'d66ef10c-1a48-4389-a804-c7ab5e8f314d',0,NULL),('2026-02-01 15:17:33.307591','2026-02-01 15:17:37.294566','2026-02-01 15:17:37.294043','8c24d660-d99e-4a84-8d8a-dd162ef7a432','8c24d660-d99e-4a84-8d8a-dd162ef7a432','2e25175d-3f59-4475-bdeb-25a4cd2f3111','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:17:33','2026-02-01 15:17:33','2026-02-01 15:17:37',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'9438b119-75d0-4d28-9efc-827b70bc86e1',0,'100%'),('2026-02-01 15:16:07.844164','2026-02-01 15:16:15.851126','2026-02-01 15:16:15.850346','90ad7db4-01ea-4e02-bd1a-db4113b80713','90ad7db4-01ea-4e02-bd1a-db4113b80713','4c471ffa-1401-4eb7-bef0-5e4c93339d6a','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:16:07','2026-02-01 15:16:08','2026-02-01 15:16:14',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'a811e5d0-f6d5-4017-bb5f-544fc27e7e76',0,'100%'),('2026-02-01 15:16:03.370679','2026-02-01 15:16:07.126518','2026-02-01 15:16:07.125600','90f8d38e-35af-44a2-af0e-7d1c285bb611','90f8d38e-35af-44a2-af0e-7d1c285bb611','d582acbc-9c90-4db6-9e3a-b99aad568f88','','deleted','2026-02-01 15:16:03',NULL,NULL,NULL,NULL,NULL,'active',NULL,'bb53296f-97b7-42cf-8d24-8b3c547491c9',0,NULL),('2026-02-01 15:13:07.712821','2026-02-01 15:13:15.782221','2026-02-01 15:13:15.781308','915665b7-ff70-4faa-88a3-0d32becf6f29','915665b7-ff70-4faa-88a3-0d32becf6f29','074f8578-066c-49d2-bdfd-7a203d4617b0','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:13:07','2026-02-01 15:13:08','2026-02-01 15:13:15',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'7c625ff0-e084-42b2-8f17-359cee73602b',0,'100%'),('2026-02-01 15:17:56.021759','2026-02-01 15:18:00.223813','2026-02-01 15:18:00.223297','92466679-2a01-470b-96b5-c6d88c0b6509','92466679-2a01-470b-96b5-c6d88c0b6509','ae386790-d6fe-4af9-8ba5-295736474267','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:17:56','2026-02-01 15:17:56','2026-02-01 15:17:59',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'9438b119-75d0-4d28-9efc-827b70bc86e1',0,'100%'),('2026-02-01 15:16:32.011452','2026-02-01 15:16:35.611722','2026-02-01 15:16:35.611119','94aa1ba1-ecec-4056-bc3e-efa2d3677c0a','94aa1ba1-ecec-4056-bc3e-efa2d3677c0a','b471dc19-2401-417a-96e5-e736bb147988','','deleted','2026-02-01 15:16:32',NULL,NULL,NULL,NULL,NULL,'active',NULL,'6e4527c7-6f92-4531-b150-fbe437acbc5f',0,NULL),('2026-02-01 15:14:43.631619','2026-02-01 15:14:47.819284','2026-02-01 15:14:47.818721','986a6f65-322a-44eb-81bc-bb6e9d6f221a','986a6f65-322a-44eb-81bc-bb6e9d6f221a','0dec4fa2-3ef7-4e76-aaab-2fd7ae13dd52','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:14:43','2026-02-01 15:14:43','2026-02-01 15:14:47',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'71a8cb03-a879-4fa1-9570-d4a2c3127be2',0,'100%'),('2026-02-01 15:14:47.414160','2026-02-01 15:15:03.173950','2026-02-01 15:15:03.173412','a0be7a54-7b29-45e1-9605-eb7321d359f2','a0be7a54-7b29-45e1-9605-eb7321d359f2','b7f5d04c-0b5a-47f1-8f38-9796f6e87234','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:14:47','2026-02-01 15:14:47','2026-02-01 15:15:02',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'d8cb87c7-b9fa-4c1f-978a-61b318980e99',0,'100%'),('2026-02-01 15:16:40.123058','2026-02-01 15:16:43.981828','2026-02-01 15:16:43.981084','a5bd3e46-4873-4452-af77-d1df718cf07b','a5bd3e46-4873-4452-af77-d1df718cf07b','d1b69db5-857a-4858-96bd-c44e33ddb3fa','','deleted','2026-02-01 15:16:40',NULL,NULL,NULL,NULL,NULL,'active',NULL,'6e184f8e-4cd9-43fc-856f-053e93d4bd03',0,NULL),('2026-02-01 15:15:48.965813','2026-02-01 15:16:12.640521','2026-02-01 15:16:12.639960','a8330130-cd80-47bb-ab6d-4bb6b88724d1','a8330130-cd80-47bb-ab6d-4bb6b88724d1','3af5147f-2af3-4b2a-92e0-0a472ae560d9','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:15:49','2026-02-01 15:15:49','2026-02-01 15:16:12',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'120a16ad-b887-4c32-bd69-d344d97a4eee',0,'100%'),('2026-02-01 15:19:52.844205','2026-02-01 15:19:53.657136','2026-02-01 15:19:53.656449','a8d162ed-6915-4c91-85d0-a5648c53b8d8','a8d162ed-6915-4c91-85d0-a5648c53b8d8','dce671b3-e788-4d44-a3e9-ff4232d7271c','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:19:52','2026-02-01 15:19:53','2026-02-01 15:19:53',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'e6371ab2-3a9c-4858-bc71-54efe991623a',0,'100%'),('2026-02-01 15:14:18.439333','2026-02-01 15:14:22.821234','2026-02-01 15:14:22.820641','aa2fa960-5933-441d-ba7d-210a851e8867','aa2fa960-5933-441d-ba7d-210a851e8867','e36b1e07-1312-4f93-901f-7cfad44e0ce1','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:14:18','2026-02-01 15:14:18','2026-02-01 15:14:22',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'ae5ac208-d3f1-42e4-bd31-25e0fbedb1a8',0,'100%'),('2026-02-01 15:16:59.126341','2026-02-01 15:17:10.139748','2026-02-01 15:17:10.139239','af1fdb5d-a0b1-4be1-a773-3eafab00aae8','af1fdb5d-a0b1-4be1-a773-3eafab00aae8','34f43339-6642-416c-b3cf-973a80d4f1af','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:16:59','2026-02-01 15:16:59','2026-02-01 15:17:09',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'01cc7ed9-ffd6-4668-816c-0807ff3b9e16',0,'100%'),('2026-02-01 15:13:34.458015','2026-02-01 15:14:02.023233','2026-02-01 15:14:02.022648','b6c72970-f609-412a-968d-5d3fe02bddc0','b6c72970-f609-412a-968d-5d3fe02bddc0','2792af0f-47d9-4201-8534-b0c899e799a9','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:13:34','2026-02-01 15:13:34','2026-02-01 15:14:01',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'b1712ae3-d38a-4543-bf30-4854aff75f83',0,'100%'),('2026-02-01 15:18:40.615842','2026-02-01 15:18:51.769720','2026-02-01 15:18:51.769172','b77cdfcb-ad1c-46a1-b6bd-1d432fc4f565','b77cdfcb-ad1c-46a1-b6bd-1d432fc4f565','0c5173b4-0251-4eb2-9e82-b1a7644830aa','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:18:40','2026-02-01 15:18:40','2026-02-01 15:18:51',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'c2e98db5-6825-4e4c-8366-569c74530e00',0,'100%'),('2026-02-01 15:14:50.940860','2026-02-01 15:14:56.485564','2026-02-01 15:14:56.484978','bc96901b-a655-4999-93d2-e6667ec9f6a9','bc96901b-a655-4999-93d2-e6667ec9f6a9','084ea16f-5b60-466f-bd43-c7d8b9a9002f','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:14:50','2026-02-01 15:14:51','2026-02-01 15:14:56',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'71a8cb03-a879-4fa1-9570-d4a2c3127be2',0,'100%'),('2026-02-01 15:15:44.470983','2026-02-01 15:15:48.056190','2026-02-01 15:15:48.055336','bcbfe477-bb77-475a-91b4-109c337cc801','bcbfe477-bb77-475a-91b4-109c337cc801','f7bd8de1-9d03-4c74-a408-3d1b24011e23','','deleted','2026-02-01 15:15:44',NULL,NULL,NULL,NULL,NULL,'active',NULL,'275a2dc4-58d1-4887-a5f2-1450bb6710b6',0,NULL),('2026-02-01 15:15:47.285865','2026-02-01 15:15:54.805213','2026-02-01 15:15:54.804527','bcfe09f7-b95d-44d4-88ff-9ddff7f38222','bcfe09f7-b95d-44d4-88ff-9ddff7f38222','eca477cd-78ff-4eb7-8da1-b1525a32f86f','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:15:47','2026-02-01 15:15:47','2026-02-01 15:15:54',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'a811e5d0-f6d5-4017-bb5f-544fc27e7e76',0,'100%'),('2026-02-01 15:13:19.430904','2026-02-01 15:13:24.796053','2026-02-01 15:13:24.795515','bd6fb31c-809d-4c83-9761-28c8527a3b81','bd6fb31c-809d-4c83-9761-28c8527a3b81','9f36509b-0363-43b8-836a-6ffc90146bbe','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:13:19','2026-02-01 15:13:19','2026-02-01 15:13:24',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'d12a5a5d-639b-477e-9123-330697ff0216',0,'100%'),('2026-02-01 15:13:10.733580','2026-02-01 15:13:16.199643','2026-02-01 15:13:16.199102','bde02bc8-059b-4cad-a246-c96036843cf2','bde02bc8-059b-4cad-a246-c96036843cf2','34e42d1e-d889-4ca6-b405-86e8c07778e3','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:13:10','2026-02-01 15:13:10','2026-02-01 15:13:15',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'d12a5a5d-639b-477e-9123-330697ff0216',0,'100%'),('2026-02-01 15:13:37.561323','2026-02-01 15:13:45.580606','2026-02-01 15:13:45.579667','c14d6f49-4f6c-4972-908b-48b473f08bc0','c14d6f49-4f6c-4972-908b-48b473f08bc0','eb44e8a1-f84a-4ad5-aae6-5d31a049a1ec','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:13:37','2026-02-01 15:13:37','2026-02-01 15:13:45',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'7f348200-99b9-44a8-a2c6-6a72a85cdd23',0,'100%'),('2026-02-01 15:14:04.118900','2026-02-01 15:14:09.477048','2026-02-01 15:14:09.475962','c19a0244-e063-4af0-8894-414616a3f2b3','c19a0244-e063-4af0-8894-414616a3f2b3','30280d5d-84b1-484d-90ed-38b66bbbbbfc','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:14:04','2026-02-01 15:14:04','2026-02-01 15:14:08',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'8c72e4a5-abce-45c1-bd37-67b1570e670b',0,'100%'),('2026-02-01 15:18:39.061499','2026-02-01 15:18:43.965128','2026-02-01 15:18:43.964049','c38a331c-6d1f-4342-961a-602e5b4f62e5','c38a331c-6d1f-4342-961a-602e5b4f62e5','7ffeeb4c-77d5-4378-af95-4e59e11fb3c3','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:18:39','2026-02-01 15:18:39','2026-02-01 15:18:43',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'deaa419b-0383-4513-8c9a-24b9d74cd8e2',0,'100%'),('2026-02-01 15:16:52.322270','2026-02-01 15:20:07.158237','2026-02-01 15:20:07.157541','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280','c5365cf8-68f4-4bb7-b1f2-7a560b4f3280','e51ffba9-5f6c-4489-99fa-67b49bb7865e','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:16:52','2026-02-01 15:16:52','2026-02-01 15:20:06',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'5b0c2719-9cba-4adb-b36c-2f65cfd23a4c',0,'100%'),('2026-02-01 15:17:03.325663','2026-02-01 15:17:30.084494','2026-02-01 15:17:30.083728','c9b2fd01-3509-428e-b915-0b74e783dc19','c9b2fd01-3509-428e-b915-0b74e783dc19','e3c73f2d-99be-4ecb-991f-ef6fb7d37db1','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:17:03','2026-02-01 15:17:03','2026-02-01 15:17:28',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'04283c6a-2cd4-4e89-807e-97c9144c5657',0,'100%'),('2026-02-01 15:15:52.087141','2026-02-01 15:15:59.271234','2026-02-01 15:15:59.270351','ca869a2a-8e49-4ca7-8aa7-6203542c3064','ca869a2a-8e49-4ca7-8aa7-6203542c3064','6f2a2b5c-0835-4de8-926c-dbdf461c7cd4','','deleted','2026-02-01 15:15:52',NULL,NULL,NULL,NULL,NULL,'active',NULL,'45a106aa-92ee-46aa-8dbd-e51e979b3fbb',0,NULL),('2026-02-01 15:18:26.289310','2026-02-01 15:18:37.380490','2026-02-01 15:18:37.379956','cc1a1612-4970-46ec-aefe-db2d1c0f8688','cc1a1612-4970-46ec-aefe-db2d1c0f8688','37fbd9e7-28ca-49bd-889e-a1db61e1ab39','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:18:26','2026-02-01 15:18:26','2026-02-01 15:18:37',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'c2e98db5-6825-4e4c-8366-569c74530e00',0,'100%'),('2026-02-01 15:15:39.036405','2026-02-01 15:16:36.991863','2026-02-01 15:16:36.991308','cc8298b6-cd36-4e3a-b5fa-1906378c83d8','cc8298b6-cd36-4e3a-b5fa-1906378c83d8','e2030234-5cbe-44da-863b-b58df4bd353b','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:15:39','2026-02-01 15:15:39','2026-02-01 15:16:36',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'29b95f67-19b6-4d0c-881b-ecde5688f59a',0,'100%'),('2026-02-01 15:19:11.518232','2026-02-01 15:19:24.262813','2026-02-01 15:19:24.261847','d57288c1-6475-4afc-b89b-63e0397aa3d5','d57288c1-6475-4afc-b89b-63e0397aa3d5','99eedc5a-b918-4040-a83b-96644a9ed910','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:19:11','2026-02-01 15:19:11','2026-02-01 15:19:24',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'4f1b79a2-3597-416f-9735-5bd373e5c8ee',0,'100%'),('2026-02-01 15:19:02.603000','2026-02-01 15:19:09.932487','2026-02-01 15:19:09.931962','d707ecfe-f6ee-49fe-a02c-3c565e379dff','d707ecfe-f6ee-49fe-a02c-3c565e379dff','2c7b7476-d95d-47be-94e2-33f9a6d247d4','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:19:02','2026-02-01 15:19:02','2026-02-01 15:19:09',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'83bac904-ede0-4c77-b192-b7b619e38cb3',0,'100%'),('2026-02-01 15:19:17.874428','2026-02-01 15:19:25.136796','2026-02-01 15:19:25.135846','db1d1fea-0e00-4e6b-b733-ef0fe090c2f5','db1d1fea-0e00-4e6b-b733-ef0fe090c2f5','84f79712-a38b-454b-ad14-8dea84f64d02','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:19:17','2026-02-01 15:19:18','2026-02-01 15:19:24',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'83bac904-ede0-4c77-b192-b7b619e38cb3',0,'100%'),('2026-02-01 15:13:35.494731','2026-02-01 15:13:39.354423','2026-02-01 15:13:39.353955','dc838023-ada6-4f22-947b-32f93b678270','dc838023-ada6-4f22-947b-32f93b678270','c93a5e0e-945d-4c72-9ff0-c298f61ff8da','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:13:35','2026-02-01 15:13:35','2026-02-01 15:13:39',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'d12a5a5d-639b-477e-9123-330697ff0216',0,'100%'),('2026-02-01 15:22:04.991905','2026-02-01 15:22:17.254236','2026-02-01 15:22:17.253376','e03e65cf-03e2-407f-9515-a854a7393b45','e03e65cf-03e2-407f-9515-a854a7393b45','57395ad9-8383-40ff-9646-5aea2c7edb82','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:22:05','2026-02-01 15:22:05','2026-02-01 15:22:17',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'b601a256-782e-4c57-86e2-e39b6a70a570',0,'100%'),('2026-02-01 15:18:20.086313','2026-02-01 15:19:43.968677','2026-02-01 15:19:43.968085','e1bb4ab8-c449-4ad1-83d0-cba448059572','e1bb4ab8-c449-4ad1-83d0-cba448059572','6182d01b-245a-494b-bb81-378b267f898a','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:18:20','2026-02-01 15:18:20','2026-02-01 15:19:43',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'83bac904-ede0-4c77-b192-b7b619e38cb3',0,'100%'),('2026-02-01 15:18:24.328842','2026-02-01 15:19:36.937995','2026-02-01 15:19:36.937467','e91ca10f-a5ab-4efe-a6b7-448ed904538e','e91ca10f-a5ab-4efe-a6b7-448ed904538e','8fe176c7-8bfa-4ff4-b4c4-d293c0ff505b','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:18:24','2026-02-01 15:18:24','2026-02-01 15:19:36',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'83bac904-ede0-4c77-b192-b7b619e38cb3',0,'100%'),('2026-02-01 15:16:49.051760','2026-02-01 15:16:52.843026','2026-02-01 15:16:52.842453','e959ee31-ee54-4509-8c44-74075aeb1817','e959ee31-ee54-4509-8c44-74075aeb1817','881bb209-1c46-4b4b-808a-d8660e3d8d46','','deleted','2026-02-01 15:16:49',NULL,NULL,NULL,NULL,NULL,'active',NULL,'1ee8abb9-5f19-4316-b114-c5b3500a2ff5',0,NULL),('2026-02-01 15:17:21.723593','2026-02-01 15:18:07.994656','2026-02-01 15:18:07.994167','eaae1ab0-0f33-4607-9838-62c2bdc360fb','eaae1ab0-0f33-4607-9838-62c2bdc360fb','39c6cc76-f1bc-40bb-ab96-c41894504a86','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:17:21','2026-02-01 15:17:22','2026-02-01 15:18:07',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'9e8345c3-c425-444a-948b-e657e9fcd15d',0,'100%'),('2026-02-01 15:19:56.413864','2026-02-01 15:20:44.888455','2026-02-01 15:20:44.887695','eae18ccb-38ff-41a6-9b8e-4ea12cbf2edd','eae18ccb-38ff-41a6-9b8e-4ea12cbf2edd','df1892ce-5021-49d0-8383-4875e362a7fa','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:19:56','2026-02-01 15:19:56','2026-02-01 15:20:44',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'b9d443de-3e6e-4a4a-a894-066b97905353',0,'100%'),('2026-02-01 15:14:55.615343','2026-02-01 15:15:00.902185','2026-02-01 15:15:00.901557','eb102253-6a1f-49e8-ab97-331a8e4964d4','eb102253-6a1f-49e8-ab97-331a8e4964d4','eb4de22a-fb3a-422e-a9da-34dc439f0abb','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:14:55','2026-02-01 15:14:56','2026-02-01 15:15:00',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'f6afe9eb-b901-4be4-a89a-bc6dc1369ca5',0,'100%'),('2026-02-01 15:15:01.234984','2026-02-01 15:15:07.573486','2026-02-01 15:15:07.572748','ef425026-5828-4f43-8ed3-bad0eb8046b9','ef425026-5828-4f43-8ed3-bad0eb8046b9','c2db2486-3b0e-428e-9fea-b8bdc0d4f5fd','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:15:01','2026-02-01 15:15:01','2026-02-01 15:15:07',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'71a8cb03-a879-4fa1-9570-d4a2c3127be2',0,'100%'),('2026-02-01 15:15:35.250811','2026-02-01 15:16:40.672572','2026-02-01 15:16:40.671955','f13e6643-de3c-4836-add7-2244ceca3720','f13e6643-de3c-4836-add7-2244ceca3720','1dbc87f0-6d96-4be8-901e-294b9b434e06','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:15:35','2026-02-01 15:15:35','2026-02-01 15:16:40',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'847063aa-e54d-49d1-b390-6611881b6691',0,'100%'),('2026-02-01 15:15:27.448231','2026-02-01 15:15:31.850922','2026-02-01 15:15:31.850069','f230efa5-4f47-4fa4-820a-fbfacc27744c','f230efa5-4f47-4fa4-820a-fbfacc27744c','71ad0f8e-e1fc-419d-a459-ceb1763cd47c','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:15:27','2026-02-01 15:15:27','2026-02-01 15:15:31',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'70f1e3e3-1df6-4e6a-972a-e4316600cd5d',0,'100%'),('2026-02-01 15:18:03.279689','2026-02-01 15:18:07.974121','2026-02-01 15:18:07.973612','f71d70ca-3bed-407e-bd13-18c8cbf0995f','f71d70ca-3bed-407e-bd13-18c8cbf0995f','b8fbce29-0056-4b4f-bd2c-8c8b27b374f7','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:18:03','2026-02-01 15:18:03','2026-02-01 15:18:07',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'9438b119-75d0-4d28-9efc-827b70bc86e1',0,'100%'),('2026-02-01 15:18:46.722240','2026-02-01 15:18:50.962655','2026-02-01 15:18:50.961943','f7b904c4-a5f8-4c39-a831-93f4c8a9a0a9','f7b904c4-a5f8-4c39-a831-93f4c8a9a0a9','4de7a064-1350-4ec3-b928-d924446e2825','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:18:46','2026-02-01 15:18:47','2026-02-01 15:18:50',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'deaa419b-0383-4513-8c9a-24b9d74cd8e2',0,'100%'),('2026-02-01 15:15:43.120668','2026-02-01 15:16:46.663916','2026-02-01 15:16:46.663305','fda2fd7c-38e4-46f7-bc0a-f227e5de8aa7','fda2fd7c-38e4-46f7-bc0a-f227e5de8aa7','b468be17-5e14-4279-9c46-1b22b29f7b78','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:15:43','2026-02-01 15:15:43','2026-02-01 15:16:46',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'a811e5d0-f6d5-4017-bb5f-544fc27e7e76',0,'100%'),('2026-02-01 15:17:48.376625','2026-02-01 15:18:00.067119','2026-02-01 15:18:00.066506','ff89896c-730f-4d0f-b5d3-5b63ed6c492d','ff89896c-730f-4d0f-b5d3-5b63ed6c492d','21db73d0-f6cc-4863-9c54-f1f6ce871fdd','hostgroup@cephfs#cephfs','deleted','2026-02-01 15:17:48','2026-02-01 15:17:48','2026-02-01 15:17:59',NULL,NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','active',NULL,'4a6a9091-c2d9-4ce4-85d0-0da2193297bc',0,'100%');
/*!40000 ALTER TABLE `share_instances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_metadata`
--

DROP TABLE IF EXISTS `share_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_metadata` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `share_id` (`share_id`),
  CONSTRAINT `share_metadata_ibfk_1` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=108 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_metadata`
--

LOCK TABLES `share_metadata` WRITE;
/*!40000 ALTER TABLE `share_metadata` DISABLE KEYS */;
INSERT INTO `share_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_id`, `key`, `value`) VALUES ('2026-02-01 15:13:07.249779',NULL,'2026-02-01 15:14:21.243944',1,1,'0d466b60-2648-465b-aef7-5ba809864391','__mount_options','fs=cephfs'),('2026-02-01 15:13:07.989559',NULL,'2026-02-01 15:13:15.793922',2,2,'074f8578-066c-49d2-bdfd-7a203d4617b0','__mount_options','fs=cephfs'),('2026-02-01 15:13:08.410191',NULL,'2026-02-01 15:13:20.812171',3,3,'ed775457-44d0-495d-ad2f-880aebb5c6c4','__mount_options','fs=cephfs'),('2026-02-01 15:13:10.964099',NULL,'2026-02-01 15:13:16.211963',4,4,'34e42d1e-d889-4ca6-b405-86e8c07778e3','__mount_options','fs=cephfs'),('2026-02-01 15:13:19.724222',NULL,'2026-02-01 15:13:24.805563',5,5,'9f36509b-0363-43b8-836a-6ffc90146bbe','__mount_options','fs=cephfs'),('2026-02-01 15:13:20.584491',NULL,'2026-02-01 15:13:26.429370',6,6,'f2b934af-baf5-452c-a0dd-7c6d84e45aaf','__mount_options','fs=cephfs'),('2026-02-01 15:13:28.389219',NULL,'2026-02-01 15:13:32.173296',7,7,'95b00e29-de3a-4052-9491-e19c17654b49','__mount_options','fs=cephfs'),('2026-02-01 15:13:34.695197',NULL,'2026-02-01 15:14:02.033336',8,8,'2792af0f-47d9-4201-8534-b0c899e799a9','__mount_options','fs=cephfs'),('2026-02-01 15:13:35.855289',NULL,'2026-02-01 15:13:39.363258',9,9,'c93a5e0e-945d-4c72-9ff0-c298f61ff8da','__mount_options','fs=cephfs'),('2026-02-01 15:13:37.816557',NULL,'2026-02-01 15:13:45.595401',10,10,'eb44e8a1-f84a-4ad5-aae6-5d31a049a1ec','__mount_options','fs=cephfs'),('2026-02-01 15:13:38.905432',NULL,'2026-02-01 15:13:58.208267',11,11,'1215de86-6ef2-4d6a-8dcb-b2bcf82846c1','__mount_options','fs=cephfs'),('2026-02-01 15:13:41.695871',NULL,'2026-02-01 15:13:48.897588',12,12,'eaada3c9-76df-46bd-b05e-e97f16f97303','__mount_options','fs=cephfs'),('2026-02-01 15:13:45.358341',NULL,'2026-02-01 15:13:50.324144',13,13,'83161a20-ce0c-4c83-aca6-ee7e0d66a73c','__mount_options','fs=cephfs'),('2026-02-01 15:14:04.366240',NULL,'2026-02-01 15:14:09.492481',14,14,'30280d5d-84b1-484d-90ed-38b66bbbbbfc','__mount_options','fs=cephfs'),('2026-02-01 15:14:18.678807',NULL,'2026-02-01 15:14:22.831117',15,15,'e36b1e07-1312-4f93-901f-7cfad44e0ce1','__mount_options','fs=cephfs'),('2026-02-01 15:14:24.033419',NULL,'2026-02-01 15:15:13.626706',16,16,'fcd5b66f-69eb-467b-8a17-b7c7c3d3f328','__mount_options','fs=cephfs'),('2026-02-01 15:14:27.523487',NULL,'2026-02-01 15:14:32.081004',17,17,'14a2235d-24be-4744-8e29-d36fdcb47054','__mount_options','fs=cephfs'),('2026-02-01 15:14:30.998595',NULL,'2026-02-01 15:14:32.081004',18,18,'14a2235d-24be-4744-8e29-d36fdcb47054','key5','value5'),('2026-02-01 15:14:31.001988',NULL,'2026-02-01 15:14:32.081004',19,19,'14a2235d-24be-4744-8e29-d36fdcb47054','key6','value6'),('2026-02-01 15:14:31.363817',NULL,'2026-02-01 15:14:32.081004',20,20,'14a2235d-24be-4744-8e29-d36fdcb47054','key7','value7'),('2026-02-01 15:14:31.369214',NULL,'2026-02-01 15:14:32.081004',21,21,'14a2235d-24be-4744-8e29-d36fdcb47054','key8','value8'),('2026-02-01 15:14:35.831106',NULL,'2026-02-01 15:14:40.459041',22,22,'ee2ee742-7ede-4f5f-aba6-102f266b036a','__mount_options','fs=cephfs'),('2026-02-01 15:14:38.942748',NULL,'2026-02-01 15:14:40.459041',23,23,'ee2ee742-7ede-4f5f-aba6-102f266b036a','key3','value3'),('2026-02-01 15:14:38.946562',NULL,'2026-02-01 15:14:40.459041',24,24,'ee2ee742-7ede-4f5f-aba6-102f266b036a','key4','value4'),('2026-02-01 15:14:38.950144',NULL,'2026-02-01 15:14:40.459041',25,25,'ee2ee742-7ede-4f5f-aba6-102f266b036a','key.5.1','value.5'),('2026-02-01 15:14:39.743755',NULL,'2026-02-01 15:14:59.458026',26,26,'b9e29865-8feb-4a35-b719-26ba10e308bf','__mount_options','fs=cephfs'),('2026-02-01 15:14:43.606974',NULL,'2026-02-01 15:14:47.830986',27,27,'0dec4fa2-3ef7-4e76-aaab-2fd7ae13dd52','key1','value1'),('2026-02-01 15:14:43.607452',NULL,'2026-02-01 15:14:47.830986',28,28,'0dec4fa2-3ef7-4e76-aaab-2fd7ae13dd52','key2','value2'),('2026-02-01 15:14:43.898555',NULL,'2026-02-01 15:14:47.830986',29,29,'0dec4fa2-3ef7-4e76-aaab-2fd7ae13dd52','__mount_options','fs=cephfs'),('2026-02-01 15:14:47.691724',NULL,'2026-02-01 15:15:03.185534',30,30,'b7f5d04c-0b5a-47f1-8f38-9796f6e87234','__mount_options','fs=cephfs'),('2026-02-01 15:14:51.340100',NULL,'2026-02-01 15:14:56.497260',31,31,'084ea16f-5b60-466f-bd43-c7d8b9a9002f','__mount_options','fs=cephfs'),('2026-02-01 15:14:54.370962','2026-02-01 15:14:54.891093','2026-02-01 15:14:56.497260',32,32,'084ea16f-5b60-466f-bd43-c7d8b9a9002f','key9','value13'),('2026-02-01 15:14:54.375627',NULL,'2026-02-01 15:14:56.497260',33,33,'084ea16f-5b60-466f-bd43-c7d8b9a9002f','key10','value10'),('2026-02-01 15:14:54.903162',NULL,'2026-02-01 15:14:56.497260',34,34,'084ea16f-5b60-466f-bd43-c7d8b9a9002f','key11','value11'),('2026-02-01 15:14:56.053530',NULL,'2026-02-01 15:15:00.918124',35,35,'eb4de22a-fb3a-422e-a9da-34dc439f0abb','__mount_options','fs=cephfs'),('2026-02-01 15:14:59.604960',NULL,'2026-02-01 15:15:13.626706',36,36,'fcd5b66f-69eb-467b-8a17-b7c7c3d3f328','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value'),('2026-02-01 15:14:59.954201','2026-02-01 15:15:00.821095','2026-02-01 15:15:13.626706',37,37,'fcd5b66f-69eb-467b-8a17-b7c7c3d3f328','key','v'),('2026-02-01 15:15:00.312656',NULL,'2026-02-01 15:15:13.626706',38,38,'fcd5b66f-69eb-467b-8a17-b7c7c3d3f328','k','value'),('2026-02-01 15:15:01.472031',NULL,'2026-02-01 15:15:07.586540',39,39,'c2db2486-3b0e-428e-9fea-b8bdc0d4f5fd','__mount_options','fs=cephfs'),('2026-02-01 15:15:04.838237',NULL,'2026-02-01 15:15:07.586540',40,40,'c2db2486-3b0e-428e-9fea-b8bdc0d4f5fd','key9','value9'),('2026-02-01 15:15:04.841502',NULL,'2026-02-01 15:15:07.586540',41,41,'c2db2486-3b0e-428e-9fea-b8bdc0d4f5fd','key10','value10'),('2026-02-01 15:15:05.290223',NULL,'2026-02-01 15:15:07.586540',42,42,'c2db2486-3b0e-428e-9fea-b8bdc0d4f5fd','key11','value11'),('2026-02-01 15:15:05.297315',NULL,'2026-02-01 15:15:07.586540',43,43,'c2db2486-3b0e-428e-9fea-b8bdc0d4f5fd','key12','value12'),('2026-02-01 15:15:09.812937',NULL,'2026-02-01 15:15:21.206698',44,44,'c33bbc3d-caeb-43d8-aff9-0eb1aca90ec2','__mount_options','fs=cephfs'),('2026-02-01 15:15:10.990780',NULL,'2026-02-01 15:15:13.626706',45,45,'fcd5b66f-69eb-467b-8a17-b7c7c3d3f328','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value'),('2026-02-01 15:15:11.362638',NULL,'2026-02-01 15:15:13.626706',46,46,'fcd5b66f-69eb-467b-8a17-b7c7c3d3f328','key','vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv'),('2026-02-01 15:15:11.885262',NULL,'2026-02-01 15:15:13.626706',47,47,'fcd5b66f-69eb-467b-8a17-b7c7c3d3f328','k','value'),('2026-02-01 15:15:12.284897',NULL,'2026-02-01 15:15:13.626706',48,48,'fcd5b66f-69eb-467b-8a17-b7c7c3d3f328','key','v'),('2026-02-01 15:15:13.001650',NULL,'2026-02-01 15:15:23.999267',49,49,'b0b174d4-b800-499f-9f56-e082e24700da','__mount_options','fs=cephfs'),('2026-02-01 15:15:16.701802',NULL,'2026-02-01 15:15:20.389399',50,50,'21ab09e5-1ca2-4aa9-98cf-47edc7e15053','__mount_options','fs=cephfs'),('2026-02-01 15:15:27.667524',NULL,'2026-02-01 15:15:31.860412',51,51,'71ad0f8e-e1fc-419d-a459-ceb1763cd47c','__mount_options','fs=cephfs'),('2026-02-01 15:15:35.448113',NULL,'2026-02-01 15:16:40.687611',52,52,'1dbc87f0-6d96-4be8-901e-294b9b434e06','__mount_options','fs=cephfs'),('2026-02-01 15:15:39.283513',NULL,'2026-02-01 15:16:37.003096',53,53,'e2030234-5cbe-44da-863b-b58df4bd353b','__mount_options','fs=cephfs'),('2026-02-01 15:15:43.347583',NULL,'2026-02-01 15:16:46.675317',54,54,'b468be17-5e14-4279-9c46-1b22b29f7b78','__mount_options','fs=cephfs'),('2026-02-01 15:15:46.252278',NULL,'2026-02-01 15:16:33.416510',55,55,'dede97d8-5245-478c-a2ce-9bf99f2c6aa7','__mount_options','fs=cephfs'),('2026-02-01 15:15:47.482843',NULL,'2026-02-01 15:15:54.815705',56,56,'eca477cd-78ff-4eb7-8da1-b1525a32f86f','__mount_options','fs=cephfs'),('2026-02-01 15:15:48.932653',NULL,'2026-02-01 15:16:12.650834',57,57,'3af5147f-2af3-4b2a-92e0-0a472ae560d9','foo_key_share_1','foo_value_share_1'),('2026-02-01 15:15:48.933163',NULL,'2026-02-01 15:16:12.650834',58,58,'3af5147f-2af3-4b2a-92e0-0a472ae560d9','bar_key_share_1','foo_value_share_1'),('2026-02-01 15:15:49.236163',NULL,'2026-02-01 15:16:12.650834',59,59,'3af5147f-2af3-4b2a-92e0-0a472ae560d9','__mount_options','fs=cephfs'),('2026-02-01 15:15:55.734443',NULL,'2026-02-01 15:16:05.801258',60,60,'afee7923-6ff7-4cad-905b-2c64c71cbc85','foo_key_share_2','foo_value_share_2'),('2026-02-01 15:15:55.735429',NULL,'2026-02-01 15:16:05.801258',61,61,'afee7923-6ff7-4cad-905b-2c64c71cbc85','bar_key_share_2','foo_value_share_2'),('2026-02-01 15:15:56.027035',NULL,'2026-02-01 15:16:05.801258',62,62,'afee7923-6ff7-4cad-905b-2c64c71cbc85','__mount_options','fs=cephfs'),('2026-02-01 15:15:59.985351',NULL,'2026-02-01 15:16:04.954792',63,63,'11fe694e-7f17-4b41-ba35-c9228ad1576c','__mount_options','fs=cephfs'),('2026-02-01 15:16:08.103775',NULL,'2026-02-01 15:16:15.866157',64,64,'4c471ffa-1401-4eb7-bef0-5e4c93339d6a','__mount_options','fs=cephfs'),('2026-02-01 15:16:14.504145',NULL,'2026-02-01 15:16:29.903262',65,65,'30ac0e47-abe2-4b5f-ba75-983911fa7443','__mount_options','fs=cephfs'),('2026-02-01 15:16:30.777939',NULL,'2026-02-01 15:16:35.648528',66,66,'0aaab4f5-8dee-46a6-8e16-748176e8927c','key','value'),('2026-02-01 15:16:31.041598',NULL,'2026-02-01 15:16:35.648528',67,67,'0aaab4f5-8dee-46a6-8e16-748176e8927c','__mount_options','fs=cephfs'),('2026-02-01 15:16:52.558310',NULL,'2026-02-01 15:20:07.171926',68,68,'e51ffba9-5f6c-4489-99fa-67b49bb7865e','__mount_options','fs=cephfs'),('2026-02-01 15:16:59.362928',NULL,'2026-02-01 15:17:10.149050',69,69,'34f43339-6642-416c-b3cf-973a80d4f1af','__mount_options','fs=cephfs'),('2026-02-01 15:17:03.580722',NULL,'2026-02-01 15:17:30.094298',70,70,'e3c73f2d-99be-4ecb-991f-ef6fb7d37db1','__mount_options','fs=cephfs'),('2026-02-01 15:17:14.104584',NULL,'2026-02-01 15:17:18.184585',71,71,'9d558349-221a-4a98-8731-9363b32b3eae','__mount_options','fs=cephfs'),('2026-02-01 15:17:22.169389',NULL,'2026-02-01 15:18:08.014551',72,72,'39c6cc76-f1bc-40bb-ab96-c41894504a86','__mount_options','fs=cephfs'),('2026-02-01 15:17:22.980187',NULL,'2026-02-01 15:18:15.397836',73,73,'02ed6534-95a8-4e9b-9349-6e1c0bb2c8e7','__mount_options','fs=cephfs'),('2026-02-01 15:17:29.106015',NULL,'2026-02-01 15:18:00.983545',74,74,'a92fd102-7531-4d03-a3d1-67447454e228','__mount_options','fs=cephfs'),('2026-02-01 15:17:33.571675',NULL,'2026-02-01 15:17:37.315545',75,75,'2e25175d-3f59-4475-bdeb-25a4cd2f3111','__mount_options','fs=cephfs'),('2026-02-01 15:17:41.568834',NULL,'2026-02-01 15:17:45.894551',76,76,'17e2b644-71c7-41fe-b778-caad6d93fe7c','__mount_options','fs=cephfs'),('2026-02-01 15:17:48.637222',NULL,'2026-02-01 15:18:00.135980',77,77,'21db73d0-f6cc-4863-9c54-f1f6ce871fdd','__mount_options','fs=cephfs'),('2026-02-01 15:17:49.328117',NULL,'2026-02-01 15:17:52.812574',78,78,'bfddc711-d955-4cc4-b66a-b9154e64b8b0','__mount_options','fs=cephfs'),('2026-02-01 15:17:56.339671',NULL,'2026-02-01 15:18:00.266387',79,79,'ae386790-d6fe-4af9-8ba5-295736474267','__mount_options','fs=cephfs'),('2026-02-01 15:18:03.531564',NULL,'2026-02-01 15:18:07.995372',80,80,'b8fbce29-0056-4b4f-bd2c-8c8b27b374f7','__mount_options','fs=cephfs'),('2026-02-01 15:18:20.065919',NULL,'2026-02-01 15:19:43.979197',81,81,'6182d01b-245a-494b-bb81-378b267f898a','foo_key_share_1','foo_value_share_1'),('2026-02-01 15:18:20.066304',NULL,'2026-02-01 15:19:43.979197',82,82,'6182d01b-245a-494b-bb81-378b267f898a','bar_key_share_1','foo_value_share_1'),('2026-02-01 15:18:20.323632',NULL,'2026-02-01 15:19:43.979197',83,83,'6182d01b-245a-494b-bb81-378b267f898a','__mount_options','fs=cephfs'),('2026-02-01 15:18:24.298783',NULL,'2026-02-01 15:19:36.951968',84,84,'8fe176c7-8bfa-4ff4-b4c4-d293c0ff505b','foo_key_share_2','foo_value_share_2'),('2026-02-01 15:18:24.299150',NULL,'2026-02-01 15:19:36.951968',85,85,'8fe176c7-8bfa-4ff4-b4c4-d293c0ff505b','bar_key_share_2','foo_value_share_2'),('2026-02-01 15:18:24.855710',NULL,'2026-02-01 15:19:36.951968',86,86,'8fe176c7-8bfa-4ff4-b4c4-d293c0ff505b','__mount_options','fs=cephfs'),('2026-02-01 15:18:26.497007',NULL,'2026-02-01 15:18:37.390486',87,87,'37fbd9e7-28ca-49bd-889e-a1db61e1ab39','__mount_options','fs=cephfs'),('2026-02-01 15:18:39.343256',NULL,'2026-02-01 15:18:43.991675',88,88,'7ffeeb4c-77d5-4378-af95-4e59e11fb3c3','__mount_options','fs=cephfs'),('2026-02-01 15:18:40.881653',NULL,'2026-02-01 15:18:51.779683',89,89,'0c5173b4-0251-4eb2-9e82-b1a7644830aa','__mount_options','fs=cephfs'),('2026-02-01 15:18:47.031746',NULL,'2026-02-01 15:18:50.976112',90,90,'4de7a064-1350-4ec3-b928-d924446e2825','__mount_options','fs=cephfs'),('2026-02-01 15:19:02.896576',NULL,'2026-02-01 15:19:09.943065',91,91,'2c7b7476-d95d-47be-94e2-33f9a6d247d4','__mount_options','fs=cephfs'),('2026-02-01 15:19:03.780174',NULL,'2026-02-01 15:19:31.259437',92,92,'62d30550-2210-40f2-83b1-24b67cb16735','__mount_options','fs=cephfs'),('2026-02-01 15:19:07.832087',NULL,'2026-02-01 15:19:27.778222',93,93,'ef02fcc2-7d7d-46b1-9994-e24d68e5b43f','__mount_options','fs=cephfs'),('2026-02-01 15:19:11.866384',NULL,'2026-02-01 15:19:24.275387',94,94,'99eedc5a-b918-4040-a83b-96644a9ed910','__mount_options','fs=cephfs'),('2026-02-01 15:19:15.871951',NULL,'2026-02-01 15:19:20.681001',95,95,'8f16715d-9b52-40a1-a5b4-5d4cfa9e7098','__mount_options','fs=cephfs'),('2026-02-01 15:19:18.094405',NULL,'2026-02-01 15:19:25.195747',96,96,'84f79712-a38b-454b-ad14-8dea84f64d02','__mount_options','fs=cephfs'),('2026-02-01 15:19:28.440176',NULL,'2026-02-01 15:19:33.394581',97,97,'6d3162f4-a7f0-42c5-8ae9-bcccd79571a2','__mount_options','fs=cephfs'),('2026-02-01 15:19:49.250612',NULL,'2026-02-01 15:19:57.815747',98,98,'a34da5d4-cbdc-49b1-af14-452229f21807','__mount_options','fs=cephfs'),('2026-02-01 15:19:51.669152',NULL,NULL,0,99,'99096eba-8e8a-4266-a1a9-b11ede8cde3e','__mount_options','fs=cephfs'),('2026-02-01 15:19:53.072408',NULL,'2026-02-01 15:19:53.667322',100,100,'dce671b3-e788-4d44-a3e9-ff4232d7271c','__mount_options','fs=cephfs'),('2026-02-01 15:19:56.636481',NULL,'2026-02-01 15:20:44.900271',101,101,'df1892ce-5021-49d0-8383-4875e362a7fa','__mount_options','fs=cephfs'),('2026-02-01 15:20:09.270550',NULL,'2026-02-01 15:20:12.927327',102,102,'06eb3108-1fb0-4cc9-802d-0d29a3e86c17','__mount_options','fs=cephfs'),('2026-02-01 15:20:16.617739',NULL,'2026-02-01 15:20:20.285851',103,103,'5a3a6e00-42bf-4a75-8d4a-3812e97dd737','__mount_options','fs=cephfs'),('2026-02-01 15:21:39.757740',NULL,'2026-02-01 15:21:51.721729',104,104,'af4e3236-7c5d-4b62-9828-44f21ee7a89e','__mount_options','fs=cephfs'),('2026-02-01 15:22:04.951763',NULL,'2026-02-01 15:22:17.266149',105,105,'57395ad9-8383-40ff-9646-5aea2c7edb82','foo_key_share_1','foo_value_share_1'),('2026-02-01 15:22:04.952202',NULL,'2026-02-01 15:22:17.266149',106,106,'57395ad9-8383-40ff-9646-5aea2c7edb82','bar_key_share_1','foo_value_share_1'),('2026-02-01 15:22:05.333492',NULL,'2026-02-01 15:22:17.266149',107,107,'57395ad9-8383-40ff-9646-5aea2c7edb82','__mount_options','fs=cephfs');
/*!40000 ALTER TABLE `share_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_network_security_service_association`
--

DROP TABLE IF EXISTS `share_network_security_service_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_network_security_service_association` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_network_id` varchar(36) NOT NULL,
  `security_service_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `share_network_id` (`share_network_id`),
  KEY `security_service_id` (`security_service_id`),
  CONSTRAINT `share_network_security_service_association_ibfk_1` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`),
  CONSTRAINT `share_network_security_service_association_ibfk_2` FOREIGN KEY (`security_service_id`) REFERENCES `security_services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_network_security_service_association`
--

LOCK TABLES `share_network_security_service_association` WRITE;
/*!40000 ALTER TABLE `share_network_security_service_association` DISABLE KEYS */;
INSERT INTO `share_network_security_service_association` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_network_id`, `security_service_id`) VALUES ('2026-02-01 15:14:32.205856','2026-02-01 15:14:34.136574','2026-02-01 15:14:34.135524',1,1,'d560e4d1-368e-4513-babe-0737daee570a','f14382cc-8769-41e9-a7f3-cf7629f4c571'),('2026-02-01 15:14:32.554086',NULL,NULL,0,2,'cfaee64a-1f3e-49cb-a6f1-9d267d645feb','ff13579b-ffa9-40fd-a208-bade022fd747'),('2026-02-01 15:18:19.942731','2026-02-01 15:18:20.036772','2026-02-01 15:18:20.036041',3,3,'b4eb00a2-9bfd-4c04-a4bd-d0b3c69ea3a6','d6e00696-a99c-4f4e-bb66-0e8b1a6d2495'),('2026-02-01 15:18:20.869512','2026-02-01 15:18:21.275750','2026-02-01 15:18:21.275323',4,4,'2789b4f4-387a-4925-9266-ef1c8c843fba','56ff9bd7-19bd-498c-a01d-b029e41eec31'),('2026-02-01 15:18:21.874658','2026-02-01 15:18:22.004084','2026-02-01 15:18:22.003786',5,5,'d4629127-7c97-46ae-ae12-663465d3b45a','bd99b6b8-fdeb-4573-81a0-0fbe2e4f034f'),('2026-02-01 15:18:22.105621','2026-02-01 15:18:22.370782','2026-02-01 15:18:22.369904',6,6,'d4629127-7c97-46ae-ae12-663465d3b45a','bd99b6b8-fdeb-4573-81a0-0fbe2e4f034f'),('2026-02-01 15:20:40.379926','2026-02-01 15:20:43.596782','2026-02-01 15:20:43.596551',7,7,'ce8edd6a-e244-4f64-b48d-d4d2b5c97b25','8faa3d1d-617a-4d2e-ab84-da8dc4be510f'),('2026-02-01 15:20:41.085512','2026-02-01 15:20:41.280356','2026-02-01 15:20:41.280037',8,8,'ca7a6b1d-97a8-4cd9-9c4f-c51d08b983c3','3e642f75-ebc2-4a17-9e61-975ec01c80d6'),('2026-02-01 15:20:42.104279','2026-02-01 15:20:42.590392','2026-02-01 15:20:42.589695',9,9,'57cc0700-eda1-4d1b-98be-21d3f0eb420d','c3eb336a-36a0-4bc4-8fbb-60d0c87a768e'),('2026-02-01 15:21:02.559942','2026-02-01 15:21:06.796168','2026-02-01 15:21:06.795812',10,10,'68ea3014-46bd-4f10-a4ab-10ed8472bfa3','f7f98f15-37b5-47c0-8a6e-b0f30b7e42d4'),('2026-02-01 15:21:02.840267','2026-02-01 15:21:06.499220','2026-02-01 15:21:06.498794',11,11,'8b1728b8-2d64-4531-92ed-4df9a317688e','aa6966bb-084a-4d3c-9317-bd962887bc12');
/*!40000 ALTER TABLE `share_network_security_service_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_network_subnet_metadata`
--

DROP TABLE IF EXISTS `share_network_subnet_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_network_subnet_metadata` (
  `deleted` varchar(36) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_network_subnet_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `share_network_subnet_id` (`share_network_subnet_id`),
  CONSTRAINT `share_network_subnet_metadata_ibfk_1` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_network_subnet_metadata`
--

LOCK TABLES `share_network_subnet_metadata` WRITE;
/*!40000 ALTER TABLE `share_network_subnet_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_network_subnet_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_network_subnets`
--

DROP TABLE IF EXISTS `share_network_subnets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_network_subnets` (
  `id` varchar(36) NOT NULL,
  `neutron_net_id` varchar(36) DEFAULT NULL,
  `neutron_subnet_id` varchar(36) DEFAULT NULL,
  `network_type` varchar(32) DEFAULT NULL,
  `cidr` varchar(64) DEFAULT NULL,
  `segmentation_id` int(11) DEFAULT NULL,
  `gateway` varchar(64) DEFAULT NULL,
  `mtu` int(11) DEFAULT NULL,
  `share_network_id` varchar(36) DEFAULT NULL,
  `ip_version` int(11) DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_share_network_subnets_share_network_id_share_networks` (`share_network_id`),
  KEY `fk_share_network_subnets_availaility_zone_id_availability_zones` (`availability_zone_id`),
  CONSTRAINT `fk_share_network_subnets_availaility_zone_id_availability_zones` FOREIGN KEY (`availability_zone_id`) REFERENCES `availability_zones` (`id`),
  CONSTRAINT `fk_share_network_subnets_share_network_id_share_networks` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_network_subnets`
--

LOCK TABLES `share_network_subnets` WRITE;
/*!40000 ALTER TABLE `share_network_subnets` DISABLE KEYS */;
INSERT INTO `share_network_subnets` (`id`, `neutron_net_id`, `neutron_subnet_id`, `network_type`, `cidr`, `segmentation_id`, `gateway`, `mtu`, `share_network_id`, `ip_version`, `availability_zone_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES ('0bea3706-d364-4d47-8079-c2ed66bd7e68',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'9495f5a9-a798-44d1-9131-9fd696f6a3f0',NULL,NULL,'2026-02-01 15:18:29.160033',NULL,NULL,'False'),('11df16de-1bce-4a10-bd67-e1002f30ef15','tempest-net-id-1614095822','tempest-subnet-id-1414157813',NULL,NULL,NULL,NULL,NULL,'b4eb00a2-9bfd-4c04-a4bd-d0b3c69ea3a6',NULL,NULL,'2026-02-01 15:18:19.686325',NULL,NULL,'False'),('30be4d54-e2f4-4c56-ab6d-1495c9c73457',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'7c377bb5-e452-48a6-b966-6fa8a4d4d9c3',NULL,NULL,'2026-02-01 15:21:17.360284',NULL,NULL,'False'),('33ecf25e-6eac-4720-bec7-850bb70e621c','1111','2222','vlan','10.0.0.0/24',1000,NULL,NULL,'d560e4d1-368e-4513-babe-0737daee570a',4,NULL,'2002-02-02 00:00:00.000000',NULL,NULL,'False'),('3afc45a6-537c-414a-9440-fc4bd602d114',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2b28502f-d41f-49fd-89c4-df0ad5220ba6',NULL,NULL,'2026-02-01 15:18:28.481467',NULL,NULL,'False'),('49ff36da-1f09-4a84-98f0-13545588b55f','test net id','test subnet id','local','10.0.0.0/13',2000,NULL,NULL,'8b1728b8-2d64-4531-92ed-4df9a317688e',6,NULL,'2003-03-03 00:00:00.000000',NULL,NULL,'False'),('4ff8a6c7-8ca0-4124-9acd-025d342fdb49','tempest-net-id-904072049','tempest-subnet-id-1553617549',NULL,NULL,NULL,NULL,NULL,'57cc0700-eda1-4d1b-98be-21d3f0eb420d',NULL,NULL,'2026-02-01 15:20:41.815243',NULL,NULL,'False'),('6f5e4837-f785-435d-8b90-64292b6c052e',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'8bdf6cb4-2ed5-41a4-a748-5eb10c3902da',NULL,NULL,'2026-02-01 15:21:16.750501',NULL,NULL,'False'),('7db55640-af86-4ae4-812c-ebfa382acba8',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2def9311-f049-4874-9073-10f2913799ff',NULL,NULL,'2026-02-01 15:18:28.349293',NULL,NULL,'False'),('88aecc60-3fee-4619-a6b6-0d69f9a3627e','tempest-net-id-298801136','tempest-subnet-id-86684466',NULL,NULL,NULL,NULL,NULL,'3740ae6d-9a90-4092-86ea-9cc4d9350b6c',NULL,NULL,'2026-02-01 15:21:02.968177',NULL,NULL,'False'),('8c3261e4-7268-4942-937a-dc6cb1adc1cd','tempest-net-id-419921795','tempest-subnet-id-1171206230',NULL,NULL,NULL,NULL,NULL,'9883c2fa-6ff7-4fcd-b8fe-9c2452f4fea7',NULL,NULL,'2026-02-01 15:21:18.492216',NULL,NULL,'False'),('9162b34b-e54b-42a7-a3ea-891179711402','tempest-net-id-1579542277','tempest-subnet-id-573437826',NULL,NULL,NULL,NULL,NULL,'087b0380-d690-44ca-85ff-025bd37bf739',NULL,NULL,'2026-02-01 15:21:04.891798',NULL,NULL,'False'),('9ca452a2-9f64-4bbd-8fd0-286b378b90ef','tempest-net-id-482656807','tempest-subnet-id-939463935',NULL,NULL,NULL,NULL,NULL,'9495f5a9-a798-44d1-9131-9fd696f6a3f0',NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','2026-02-01 15:18:29.311836','2026-02-01 15:18:29.490607','2026-02-01 15:18:29.490129','9ca452a2-9f64-4bbd-8fd0-286b378b90ef'),('9d064f05-c29f-42eb-acb1-75ecadc38d02','tempest-net-id-1579542277','tempest-subnet-id-573437826',NULL,NULL,NULL,NULL,NULL,'38a6005e-af43-41db-8ed0-7332e81039d1',NULL,NULL,'2026-02-01 15:21:05.222559',NULL,NULL,'False'),('9e5c716a-9ebc-4612-936b-9963f5bb0c4a','tempest-net-id-1186170258','tempest-subnet-id-1606862266',NULL,NULL,NULL,NULL,NULL,'ca7a6b1d-97a8-4cd9-9c4f-c51d08b983c3',NULL,NULL,'2026-02-01 15:20:40.868419',NULL,NULL,'False'),('a99f611f-5ce5-4d88-9399-76e5e450a53e',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'ce8edd6a-e244-4f64-b48d-d4d2b5c97b25',NULL,NULL,'2026-02-01 15:20:39.730791',NULL,NULL,'False'),('ba8cb42d-ecaa-4c74-925a-98d782bd2cec','test net id','test subnet id','local','10.0.0.0/13',2000,NULL,NULL,'cfaee64a-1f3e-49cb-a6f1-9d267d645feb',6,NULL,'2003-03-03 00:00:00.000000',NULL,NULL,'False'),('c6579b8c-10ef-46e0-9d85-744943b63771','tempest-net-id-1578108551','tempest-subnet-id-143936791',NULL,NULL,NULL,NULL,NULL,'be057be4-0f6e-4829-b3bd-a958541cc2e1',NULL,NULL,'2026-02-01 15:21:03.372160',NULL,NULL,'False'),('ca6d0842-5214-42ac-a62e-f2d331e56086','tempest-net-id-1840566924','tempest-subnet-id-1437660309',NULL,NULL,NULL,NULL,NULL,'7c377bb5-e452-48a6-b966-6fa8a4d4d9c3',NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','2026-02-01 15:21:17.564639','2026-02-01 15:21:17.824959','2026-02-01 15:21:17.824318','ca6d0842-5214-42ac-a62e-f2d331e56086'),('d43a7748-8d00-41ee-a525-329589ea771a','tempest-net-id-843772576','tempest-subnet-id-50799898',NULL,NULL,NULL,NULL,NULL,'2b28502f-d41f-49fd-89c4-df0ad5220ba6',NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','2026-02-01 15:18:28.708915','2026-02-01 15:18:28.791004','2026-02-01 15:18:28.790261','d43a7748-8d00-41ee-a525-329589ea771a'),('d5268f46-d7e6-494a-a2d4-93824c07ee7b','tempest-net-id-1578108551','tempest-subnet-id-143936791',NULL,NULL,NULL,NULL,NULL,'8a2c670a-c02b-4381-bfc9-7f0c2a31dfe2',NULL,NULL,'2026-02-01 15:21:03.517777',NULL,NULL,'False'),('d569fc0a-18ea-4d5a-9205-8c0be099ac51','tempest-net-id-1401848823','tempest-subnet-id-313180721',NULL,NULL,NULL,NULL,NULL,'997c8f8e-5e24-469d-956e-743940c888c1',NULL,'02c7f679-5981-4fd8-8760-626ef9ae59a0','2026-02-01 15:17:04.582081','2026-02-01 15:17:04.677555','2026-02-01 15:17:04.676613','d569fc0a-18ea-4d5a-9205-8c0be099ac51'),('ecd2a3db-613e-4e00-b1c7-df71b477b67c','tempest-net-id-1749111296','tempest-subnet-id-497050659','vlan','10.0.0.0/24',1000,NULL,NULL,'68ea3014-46bd-4f10-a4ab-10ed8472bfa3',4,NULL,'2002-02-02 00:00:00.000000','2026-02-01 15:21:05.638546',NULL,'False'),('f3320682-9196-4bf3-8a55-bc18948db0a8',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'997c8f8e-5e24-469d-956e-743940c888c1',NULL,NULL,'2026-02-01 15:17:03.837435',NULL,NULL,'False'),('f562a5da-70d2-4d1a-9695-dfd32e65e153','tempest-net-id-170266653','tempest-subnet-id-491347052',NULL,NULL,NULL,NULL,NULL,'2789b4f4-387a-4925-9266-ef1c8c843fba',NULL,NULL,'2026-02-01 15:18:20.667332',NULL,NULL,'False'),('fd7e9270-6d1f-4e6f-9cfb-b3a811ea808d','tempest-net-id-1098870952','tempest-subnet-id-1664409699',NULL,NULL,NULL,NULL,NULL,'d4629127-7c97-46ae-ae12-663465d3b45a',NULL,NULL,'2026-02-01 15:18:21.585360',NULL,NULL,'False');
/*!40000 ALTER TABLE `share_network_subnets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_networks`
--

DROP TABLE IF EXISTS `share_networks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_networks` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(36) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_networks`
--

LOCK TABLES `share_networks` WRITE;
/*!40000 ALTER TABLE `share_networks` DISABLE KEYS */;
INSERT INTO `share_networks` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `user_id`, `name`, `description`, `status`) VALUES ('2026-02-01 15:21:04.878652','2026-02-01 15:21:05.096306','2026-02-01 15:21:05.095679','087b0380-d690-44ca-85ff-025bd37bf739','087b0380-d690-44ca-85ff-025bd37bf739','52ac7fb21e3442af82e9ccd9a67048b3','88ec7b16b6fa416384d2369bc7447737','tempest-sn-name-547251019','tempest-sn-desc-1412029213','active'),('2026-02-01 15:18:20.642173','2026-02-01 15:18:21.309702','2026-02-01 15:18:21.308238','2789b4f4-387a-4925-9266-ef1c8c843fba','2789b4f4-387a-4925-9266-ef1c8c843fba','8b0415f100a1429bba93cf802c51baee','6868c6d8625240428c32f8df11c67fd6','tempest-sn-name-1360816329','tempest-sn-desc-1419053622','active'),('2026-02-01 15:18:28.467684',NULL,NULL,'False','2b28502f-d41f-49fd-89c4-df0ad5220ba6','563730bce3db420f8fb732bed1fdd719','b941253886a049d88d77c1e476049e76',NULL,NULL,'active'),('2026-02-01 15:18:28.334782','2026-02-01 15:18:28.963962','2026-02-01 15:18:28.963523','2def9311-f049-4874-9073-10f2913799ff','2def9311-f049-4874-9073-10f2913799ff','563730bce3db420f8fb732bed1fdd719','b941253886a049d88d77c1e476049e76',NULL,NULL,'active'),('2026-02-01 15:21:02.944728','2026-02-01 15:21:03.091440','2026-02-01 15:21:03.090986','3740ae6d-9a90-4092-86ea-9cc4d9350b6c','3740ae6d-9a90-4092-86ea-9cc4d9350b6c','52ac7fb21e3442af82e9ccd9a67048b3','88ec7b16b6fa416384d2369bc7447737','tempest-sn-name-1856496763','tempest-sn-desc-110603657','active'),('2026-02-01 15:21:05.197696','2026-02-01 15:21:05.362729','2026-02-01 15:21:05.362325','38a6005e-af43-41db-8ed0-7332e81039d1','38a6005e-af43-41db-8ed0-7332e81039d1','52ac7fb21e3442af82e9ccd9a67048b3','88ec7b16b6fa416384d2369bc7447737','tempest-sn-name-547251019','tempest-sn-desc-1412029213','active'),('2026-02-01 15:20:41.799949','2026-02-01 15:20:42.602208','2026-02-01 15:20:42.601847','57cc0700-eda1-4d1b-98be-21d3f0eb420d','57cc0700-eda1-4d1b-98be-21d3f0eb420d','df8c3ecdfab6413d85063f6a916bc871','6f958a41d78c4be0a08e982b45e1a5d2','tempest-sn-name-1691045266','tempest-sn-desc-2040662388','active'),('2002-02-02 00:00:00.000000','2026-02-01 15:21:06.814863','2026-02-01 15:21:06.814350','68ea3014-46bd-4f10-a4ab-10ed8472bfa3','68ea3014-46bd-4f10-a4ab-10ed8472bfa3','52ac7fb21e3442af82e9ccd9a67048b3','88ec7b16b6fa416384d2369bc7447737','tempest-sn-name-1306947365','tempest-sn-desc-1858668128','active'),('2026-02-01 15:21:17.342652','2026-02-01 15:21:18.078193','2026-02-01 15:21:18.077582','7c377bb5-e452-48a6-b966-6fa8a4d4d9c3','7c377bb5-e452-48a6-b966-6fa8a4d4d9c3','5b354e96d8754cf0a01ccc8e15d99a2c','8c6a7c0dbc6a435d9d7adbff0811f887',NULL,NULL,'active'),('2026-02-01 15:21:03.504652','2026-02-01 15:21:03.644764','2026-02-01 15:21:03.644324','8a2c670a-c02b-4381-bfc9-7f0c2a31dfe2','8a2c670a-c02b-4381-bfc9-7f0c2a31dfe2','52ac7fb21e3442af82e9ccd9a67048b3','88ec7b16b6fa416384d2369bc7447737','tempest-sn-name-883552712','tempest-sn-desc-1479237348','active'),('2003-03-03 00:00:00.000000','2026-02-01 15:21:06.517199','2026-02-01 15:21:06.516686','8b1728b8-2d64-4531-92ed-4df9a317688e','8b1728b8-2d64-4531-92ed-4df9a317688e','52ac7fb21e3442af82e9ccd9a67048b3','88ec7b16b6fa416384d2369bc7447737','sn_with_kerberos_ss','fake description','active'),('2026-02-01 15:21:16.733047','2026-02-01 15:21:17.015965','2026-02-01 15:21:17.015497','8bdf6cb4-2ed5-41a4-a748-5eb10c3902da','8bdf6cb4-2ed5-41a4-a748-5eb10c3902da','5b354e96d8754cf0a01ccc8e15d99a2c','8c6a7c0dbc6a435d9d7adbff0811f887',NULL,NULL,'active'),('2026-02-01 15:18:29.143324','2026-02-01 15:18:29.663404','2026-02-01 15:18:29.662990','9495f5a9-a798-44d1-9131-9fd696f6a3f0','9495f5a9-a798-44d1-9131-9fd696f6a3f0','563730bce3db420f8fb732bed1fdd719','b941253886a049d88d77c1e476049e76',NULL,NULL,'active'),('2026-02-01 15:21:18.471594','2026-02-01 15:21:18.602329','2026-02-01 15:21:18.601948','9883c2fa-6ff7-4fcd-b8fe-9c2452f4fea7','9883c2fa-6ff7-4fcd-b8fe-9c2452f4fea7','5b354e96d8754cf0a01ccc8e15d99a2c','8c6a7c0dbc6a435d9d7adbff0811f887','tempest-sn-name-1206786732','tempest-sn-desc-1502866953','active'),('2026-02-01 15:17:03.555046',NULL,NULL,'False','997c8f8e-5e24-469d-956e-743940c888c1','d3906373bc57497a8593cc485bc49810','09a6b5beaf9f4e96b8a8b3f1d67a192d',NULL,NULL,'active'),('2026-02-01 15:18:19.670292','2026-02-01 15:18:20.326321','2026-02-01 15:18:20.325172','b4eb00a2-9bfd-4c04-a4bd-d0b3c69ea3a6','b4eb00a2-9bfd-4c04-a4bd-d0b3c69ea3a6','8b0415f100a1429bba93cf802c51baee','6868c6d8625240428c32f8df11c67fd6','tempest-sn-name-81049354','tempest-sn-desc-290675202','active'),('2026-02-01 15:21:03.356527','2026-02-01 15:21:03.868415','2026-02-01 15:21:03.867980','be057be4-0f6e-4829-b3bd-a958541cc2e1','be057be4-0f6e-4829-b3bd-a958541cc2e1','52ac7fb21e3442af82e9ccd9a67048b3','88ec7b16b6fa416384d2369bc7447737','tempest-sn-name-883552712','tempest-sn-desc-1479237348','active'),('2026-02-01 15:20:40.852373','2026-02-01 15:20:41.590517','2026-02-01 15:20:41.589729','ca7a6b1d-97a8-4cd9-9c4f-c51d08b983c3','ca7a6b1d-97a8-4cd9-9c4f-c51d08b983c3','df8c3ecdfab6413d85063f6a916bc871','6f958a41d78c4be0a08e982b45e1a5d2','tempest-sn-name-1922216454','tempest-sn-desc-298301396','active'),('2026-02-01 15:20:39.710225','2026-02-01 15:20:43.632431','2026-02-01 15:20:43.632054','ce8edd6a-e244-4f64-b48d-d4d2b5c97b25','ce8edd6a-e244-4f64-b48d-d4d2b5c97b25','df8c3ecdfab6413d85063f6a916bc871','6f958a41d78c4be0a08e982b45e1a5d2',NULL,NULL,'active'),('2003-03-03 00:00:00.000000',NULL,NULL,'False','cfaee64a-1f3e-49cb-a6f1-9d267d645feb','389354672a9f45998c217a07289430b9','08f88d0b6ec54c79a8bfec726694c073','sn_with_kerberos_ss','fake description','active'),('2026-02-01 15:18:21.561288','2026-02-01 15:18:22.388505','2026-02-01 15:18:22.387592','d4629127-7c97-46ae-ae12-663465d3b45a','d4629127-7c97-46ae-ae12-663465d3b45a','8b0415f100a1429bba93cf802c51baee','6868c6d8625240428c32f8df11c67fd6','tempest-sn-name-589829728','tempest-sn-desc-1084682067','active'),('2002-02-02 00:00:00.000000','2026-02-01 15:14:34.159629','2026-02-01 15:14:34.158548','d560e4d1-368e-4513-babe-0737daee570a','d560e4d1-368e-4513-babe-0737daee570a','9daf6f5120ad4addbf1be43b336ab548','8aed0688b51d4ff0a0a064f11d0b453b','sn_with_ldap_ss','fake description','active');
/*!40000 ALTER TABLE `share_networks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_server_backend_details`
--

DROP TABLE IF EXISTS `share_server_backend_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_server_backend_details` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_server_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `share_server_id` (`share_server_id`),
  CONSTRAINT `share_server_backend_details_ibfk_1` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_server_backend_details`
--

LOCK TABLES `share_server_backend_details` WRITE;
/*!40000 ALTER TABLE `share_server_backend_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_server_backend_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_server_share_network_subnet_mappings`
--

DROP TABLE IF EXISTS `share_server_share_network_subnet_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_server_share_network_subnet_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_server_id` varchar(36) NOT NULL,
  `share_network_subnet_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_ss_sns_m_share_server_id_share_servers` (`share_server_id`),
  KEY `fk_ss_sns_m_share_network_subnet_id_share_network_subnets` (`share_network_subnet_id`),
  CONSTRAINT `fk_ss_sns_m_share_network_subnet_id_share_network_subnets` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`),
  CONSTRAINT `fk_ss_sns_m_share_server_id_share_servers` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_server_share_network_subnet_mappings`
--

LOCK TABLES `share_server_share_network_subnet_mappings` WRITE;
/*!40000 ALTER TABLE `share_server_share_network_subnet_mappings` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_server_share_network_subnet_mappings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_servers`
--

DROP TABLE IF EXISTS `share_servers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_servers` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `host` varchar(255) DEFAULT NULL,
  `status` varchar(32) DEFAULT NULL,
  `is_auto_deletable` tinyint(1) DEFAULT NULL,
  `identifier` varchar(255) DEFAULT NULL,
  `task_state` varchar(255) DEFAULT NULL,
  `source_share_server_id` varchar(36) DEFAULT NULL,
  `security_service_update_support` tinyint(1) NOT NULL DEFAULT 0,
  `network_allocation_update_support` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `fk_share_servers_source_share_server_id` (`source_share_server_id`),
  CONSTRAINT `fk_share_servers_source_share_server_id` FOREIGN KEY (`source_share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_servers`
--

LOCK TABLES `share_servers` WRITE;
/*!40000 ALTER TABLE `share_servers` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_servers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_access_map`
--

DROP TABLE IF EXISTS `share_snapshot_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_access_map` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_snapshot_id` varchar(36) DEFAULT NULL,
  `access_type` varchar(255) DEFAULT NULL,
  `access_to` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ssam_snapshot_fk` (`share_snapshot_id`),
  CONSTRAINT `ssam_snapshot_fk` FOREIGN KEY (`share_snapshot_id`) REFERENCES `share_snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_access_map`
--

LOCK TABLES `share_snapshot_access_map` WRITE;
/*!40000 ALTER TABLE `share_snapshot_access_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_snapshot_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_instance_access_map`
--

DROP TABLE IF EXISTS `share_snapshot_instance_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_instance_access_map` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_snapshot_instance_id` varchar(36) DEFAULT NULL,
  `access_id` varchar(36) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ssiam_snapshot_instance_fk` (`share_snapshot_instance_id`),
  KEY `ssam_access_fk` (`access_id`),
  CONSTRAINT `ssam_access_fk` FOREIGN KEY (`access_id`) REFERENCES `share_snapshot_access_map` (`id`),
  CONSTRAINT `ssiam_snapshot_instance_fk` FOREIGN KEY (`share_snapshot_instance_id`) REFERENCES `share_snapshot_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_instance_access_map`
--

LOCK TABLES `share_snapshot_instance_access_map` WRITE;
/*!40000 ALTER TABLE `share_snapshot_instance_access_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_snapshot_instance_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_instance_export_locations`
--

DROP TABLE IF EXISTS `share_snapshot_instance_export_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_instance_export_locations` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_snapshot_instance_id` varchar(36) DEFAULT NULL,
  `path` varchar(2000) DEFAULT NULL,
  `is_admin_only` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ssiel_snapshot_instance_fk` (`share_snapshot_instance_id`),
  CONSTRAINT `ssiel_snapshot_instance_fk` FOREIGN KEY (`share_snapshot_instance_id`) REFERENCES `share_snapshot_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_instance_export_locations`
--

LOCK TABLES `share_snapshot_instance_export_locations` WRITE;
/*!40000 ALTER TABLE `share_snapshot_instance_export_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_snapshot_instance_export_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_instances`
--

DROP TABLE IF EXISTS `share_snapshot_instances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_instances` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `share_instance_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `share_proto` varchar(255) DEFAULT NULL,
  `share_group_snapshot_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ssi_snapshot_fk` (`snapshot_id`),
  KEY `ssi_share_instance_fk` (`share_instance_id`),
  CONSTRAINT `ssi_share_instance_fk` FOREIGN KEY (`share_instance_id`) REFERENCES `share_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_instances`
--

LOCK TABLES `share_snapshot_instances` WRITE;
/*!40000 ALTER TABLE `share_snapshot_instances` DISABLE KEYS */;
INSERT INTO `share_snapshot_instances` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `snapshot_id`, `share_instance_id`, `status`, `progress`, `provider_location`, `user_id`, `project_id`, `size`, `share_proto`, `share_group_snapshot_id`) VALUES ('2026-02-01 15:17:51.698987','2026-02-01 15:17:56.325461','2026-02-01 15:17:56.324955','028bb641-87db-46c7-9018-3f8d054e8e72','028bb641-87db-46c7-9018-3f8d054e8e72','337552e6-dd85-4f6d-9610-99737469dd80','ff89896c-730f-4d0f-b5d3-5b63ed6c492d','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-02-01 15:17:02.634262','2026-02-01 15:17:06.436641','2026-02-01 15:17:06.436190','05a837c1-3311-42f7-8cdb-24af5bea7bca','05a837c1-3311-42f7-8cdb-24af5bea7bca','f022aa77-e100-4ec5-bc9a-94f939ba4cfc','af1fdb5d-a0b1-4be1-a773-3eafab00aae8','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-02-01 15:14:01.050908','2026-02-01 15:14:09.730001','2026-02-01 15:14:09.729474','0c3f4871-3746-4345-899c-cde05e7ab29a','0c3f4871-3746-4345-899c-cde05e7ab29a','5f8d76a2-690b-4d7e-8c67-40b563fa4add','0d8696eb-14a5-4abf-b5f8-d5c0093d2c06','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-02-01 15:14:47.649602','2026-02-01 15:14:52.383633','2026-02-01 15:14:52.382691','1ed659b6-e30b-4f53-ae01-83823d19486c','1ed659b6-e30b-4f53-ae01-83823d19486c','e2132102-39e4-41f4-a6d3-e7a2a8df27cc','02a9afaa-78ab-4c60-9b65-efddd9ffb5df','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-02-01 15:13:56.774344','2026-02-01 15:14:13.413439','2026-02-01 15:14:13.412981','2401e4d9-9c2d-4644-befb-68ed41585c58','2401e4d9-9c2d-4644-befb-68ed41585c58','f1f3c043-c4de-4c8e-b742-6b2aba8a90bd','0d8696eb-14a5-4abf-b5f8-d5c0093d2c06','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-02-01 15:20:34.943061','2026-02-01 15:20:38.318625','2026-02-01 15:20:38.318151','3c99591e-4443-46aa-892b-59f2735dca00','3c99591e-4443-46aa-892b-59f2735dca00','59b862f6-24f2-457d-8400-334f4d4f6ea3','eae18ccb-38ff-41a6-9b8e-4ea12cbf2edd','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-02-01 15:20:03.333106','2026-02-01 15:20:07.763374','2026-02-01 15:20:07.762941','412605f1-3f08-4d5b-b5fa-295e1cba97d5','412605f1-3f08-4d5b-b5fa-295e1cba97d5','a8272d77-fba1-474d-b266-1d9f610d6489','eae18ccb-38ff-41a6-9b8e-4ea12cbf2edd','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-02-01 15:13:51.466857','2026-02-01 15:14:20.267341','2026-02-01 15:14:20.266946','6055dc83-b33d-4c1e-b4e8-46b0bf50f6e2','6055dc83-b33d-4c1e-b4e8-46b0bf50f6e2','5f853247-8fbf-41cc-a044-d26afb9421d6','0d8696eb-14a5-4abf-b5f8-d5c0093d2c06','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-02-01 15:19:59.874230','2026-02-01 15:20:44.391135','2026-02-01 15:20:44.390544','62d967c2-993a-452f-a738-a621dc2deead','62d967c2-993a-452f-a738-a621dc2deead','57052b66-4ef2-422d-b6cb-d8da260acde1','eae18ccb-38ff-41a6-9b8e-4ea12cbf2edd','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-02-01 15:14:43.200047','2026-02-01 15:14:56.120343','2026-02-01 15:14:56.119931','7452b405-63e8-464b-8fbd-4019869a8486','7452b405-63e8-464b-8fbd-4019869a8486','00151c93-f474-433b-9073-c4743a80f8a9','02a9afaa-78ab-4c60-9b65-efddd9ffb5df','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-02-01 15:13:42.367631','2026-02-01 15:13:54.737046','2026-02-01 15:13:54.736453','765a0401-6123-4825-9702-0df27b7178b8','765a0401-6123-4825-9702-0df27b7178b8','7191da11-ab02-4a73-964f-85bc2cf8226c','1cd77113-e6d6-4345-8483-5f1b1ddb866c','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-02-01 15:18:29.794479','2026-02-01 15:18:34.228128','2026-02-01 15:18:34.227429','7fcd119c-0e43-4007-8ec8-3d4fbb59c309','7fcd119c-0e43-4007-8ec8-3d4fbb59c309','b86e68d4-3845-4b37-bc61-babe728af73e','cc1a1612-4970-46ec-aefe-db2d1c0f8688','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-02-01 15:17:25.183721','2026-02-01 15:18:04.421093','2026-02-01 15:18:04.420653','83c92ce7-3e64-4538-8f22-ddff58a7c70b','83c92ce7-3e64-4538-8f22-ddff58a7c70b','c61fb956-cb54-4a69-b984-796f123291a0','eaae1ab0-0f33-4607-9838-62c2bdc360fb','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-02-01 15:20:19.955643','2026-02-01 15:20:24.046618','2026-02-01 15:20:24.046199','85344f13-853b-4a08-8ae5-5931230f8f33','85344f13-853b-4a08-8ae5-5931230f8f33','a38fa840-3a94-4f26-a23d-fd03823471c0','eae18ccb-38ff-41a6-9b8e-4ea12cbf2edd','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-02-01 15:13:55.583639','2026-02-01 15:14:16.859365','2026-02-01 15:14:16.858803','8622dc9d-aad8-45b9-8bf6-4ce20c111ec2','8622dc9d-aad8-45b9-8bf6-4ce20c111ec2','fbe6d350-ea63-4fce-8220-3c83f15d3afc','0d8696eb-14a5-4abf-b5f8-d5c0093d2c06','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-02-01 15:13:11.895976','2026-02-01 15:13:17.200151','2026-02-01 15:13:17.199415','89fefdfc-5a05-4ed0-8819-b63c5620160b','89fefdfc-5a05-4ed0-8819-b63c5620160b','6676d9d7-897a-4be1-9444-f94c4c5eb9e9','618c0e6c-2fb1-44ff-85f4-15df368e2591','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-02-01 15:13:42.843463','2026-02-01 15:13:43.666337','2026-02-01 15:13:43.665787','8c23c0e7-dc6a-4f86-92c2-9b90697f38d7','8c23c0e7-dc6a-4f86-92c2-9b90697f38d7','5a46fbbf-9ff7-4e87-be5d-e5e24f824870','0d8696eb-14a5-4abf-b5f8-d5c0093d2c06','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-02-01 15:20:27.355944','2026-02-01 15:20:30.111785','2026-02-01 15:20:30.111342','9883d1fb-bbfe-49b8-87f6-937369add4a2','9883d1fb-bbfe-49b8-87f6-937369add4a2','4d19973b-9f66-4818-a82a-a0723e2292db','eae18ccb-38ff-41a6-9b8e-4ea12cbf2edd','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-02-01 15:14:01.982949','2026-02-01 15:14:06.280086','2026-02-01 15:14:06.279140','999c7871-ceb7-40d5-8403-0424caa50678','999c7871-ceb7-40d5-8403-0424caa50678','de13f642-4dd6-425f-b2a2-695e92172306','0d8696eb-14a5-4abf-b5f8-d5c0093d2c06','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-02-01 15:15:52.290223','2026-02-01 15:16:09.158458','2026-02-01 15:16:09.158005','9edff701-b45a-4597-ae78-08c7150fd6a2','9edff701-b45a-4597-ae78-08c7150fd6a2','09169dc3-0948-42ec-b7eb-9bb0391d7a50','a8330130-cd80-47bb-ab6d-4bb6b88724d1','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-02-01 15:15:13.212152','2026-02-01 15:15:17.560280','2026-02-01 15:15:17.559760','9f047d51-0b94-405e-b75c-b64696ffced9','9f047d51-0b94-405e-b75c-b64696ffced9','bac99b88-a326-4fdb-ac75-b388970b7d3b','7371576d-9b9d-4a2b-b2a0-dbf1c35daed8','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-02-01 15:21:42.949595','2026-02-01 15:21:48.307153','2026-02-01 15:21:48.306520','a8b1ef42-1e25-4f11-8838-77f94c29ebe4','a8b1ef42-1e25-4f11-8838-77f94c29ebe4','0e53ce9d-659d-4efa-bf51-1e666e409ac3','091d85e3-6421-421c-a022-3095345db8aa','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-02-01 15:22:08.468154','2026-02-01 15:22:13.775497','2026-02-01 15:22:13.774750','b24e846b-f29d-418f-a067-565f2a42532d','b24e846b-f29d-418f-a067-565f2a42532d','c6222879-ed29-4cfb-9aea-5793593bdf51','e03e65cf-03e2-407f-9515-a854a7393b45','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-02-01 15:17:26.935357','2026-02-01 15:18:11.845294','2026-02-01 15:18:11.844853','b6d4e46b-8d52-41c3-ae82-52a9e57131ed','b6d4e46b-8d52-41c3-ae82-52a9e57131ed','1e96b528-01bb-4d75-b3fa-211a85006c95','85ddb4b4-f1ca-4471-8fc6-5c185f91fcdb','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-02-01 15:18:44.116029','2026-02-01 15:18:48.376169','2026-02-01 15:18:48.375721','c0b5a8ad-609c-4622-bb29-29375e2fdb31','c0b5a8ad-609c-4622-bb29-29375e2fdb31','c21d430b-3b4d-4d2f-8c15-58fdd24843b4','b77cdfcb-ad1c-46a1-b6bd-1d432fc4f565','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-02-01 15:20:11.109551','2026-02-01 15:20:16.722791','2026-02-01 15:20:16.722408','ec81534c-37e1-436f-8b77-bcabec4a8b35','ec81534c-37e1-436f-8b77-bcabec4a8b35','f6dd2a46-7c0a-4607-8275-a93a5c9b55f1','eae18ccb-38ff-41a6-9b8e-4ea12cbf2edd','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-02-01 15:18:23.659892','2026-02-01 15:19:40.335759','2026-02-01 15:19:40.335064','f84678b0-2860-4390-8392-13cdcac44563','f84678b0-2860-4390-8392-13cdcac44563','383b4f57-c12d-4143-bc64-f94b56aa4406','e1bb4ab8-c449-4ad1-83d0-cba448059572','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `share_snapshot_instances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_metadata`
--

DROP TABLE IF EXISTS `share_snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_metadata` (
  `deleted` varchar(36) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `share_snapshot_id` (`share_snapshot_id`),
  CONSTRAINT `share_snapshot_metadata_ibfk_1` FOREIGN KEY (`share_snapshot_id`) REFERENCES `share_snapshots` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_metadata`
--

LOCK TABLES `share_snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `share_snapshot_metadata` DISABLE KEYS */;
INSERT INTO `share_snapshot_metadata` (`deleted`, `created_at`, `updated_at`, `deleted_at`, `share_snapshot_id`, `key`, `value`, `id`) VALUES ('1','2026-02-01 15:20:06.882248','2026-02-01 15:20:07.127330','2026-02-01 15:20:07.775136','a8272d77-fba1-474d-b266-1d9f610d6489','key5','value5',1),('2','2026-02-01 15:20:06.887721','2026-02-01 15:20:07.171856','2026-02-01 15:20:07.775136','a8272d77-fba1-474d-b266-1d9f610d6489','key6','value6',2),('3','2026-02-01 15:20:07.205989',NULL,'2026-02-01 15:20:07.775136','a8272d77-fba1-474d-b266-1d9f610d6489','key7','value7',3),('4','2026-02-01 15:20:07.209516',NULL,'2026-02-01 15:20:07.775136','a8272d77-fba1-474d-b266-1d9f610d6489','key8','value8',4),('5','2026-02-01 15:20:14.693073','2026-02-01 15:20:15.802036','2026-02-01 15:20:16.733829','f6dd2a46-7c0a-4607-8275-a93a5c9b55f1','key3','value3',5),('6','2026-02-01 15:20:14.694781','2026-02-01 15:20:15.951704','2026-02-01 15:20:16.733829','f6dd2a46-7c0a-4607-8275-a93a5c9b55f1','key4','value4',6),('7','2026-02-01 15:20:14.696408','2026-02-01 15:20:16.084313','2026-02-01 15:20:16.733829','f6dd2a46-7c0a-4607-8275-a93a5c9b55f1','key.5.1','value.5',7),('8','2026-02-01 15:20:19.953521',NULL,'2026-02-01 15:20:24.064452','a38fa840-3a94-4f26-a23d-fd03823471c0','key1','value1',8),('9','2026-02-01 15:20:19.954251',NULL,'2026-02-01 15:20:24.064452','a38fa840-3a94-4f26-a23d-fd03823471c0','key2','value2',9),('10','2026-02-01 15:20:27.760376','2026-02-01 15:20:29.114143','2026-02-01 15:20:30.129350','4d19973b-9f66-4818-a82a-a0723e2292db','key9','value13',10),('11','2026-02-01 15:20:27.762614','2026-02-01 15:20:29.305633','2026-02-01 15:20:30.129350','4d19973b-9f66-4818-a82a-a0723e2292db','key10','value10',11),('12','2026-02-01 15:20:28.367976','2026-02-01 15:20:29.556736','2026-02-01 15:20:30.129350','4d19973b-9f66-4818-a82a-a0723e2292db','key11','value11',12),('13','2026-02-01 15:20:33.389156','2026-02-01 15:20:41.714653','2026-02-01 15:20:44.407546','57052b66-4ef2-422d-b6cb-d8da260acde1','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value',13),('14','2026-02-01 15:20:33.777407','2026-02-01 15:20:41.749516','2026-02-01 15:20:44.407546','57052b66-4ef2-422d-b6cb-d8da260acde1','key','v',14),('15','2026-02-01 15:20:34.095108','2026-02-01 15:20:41.779347','2026-02-01 15:20:44.407546','57052b66-4ef2-422d-b6cb-d8da260acde1','k','value',15),('16','2026-02-01 15:20:35.329484','2026-02-01 15:20:36.957513','2026-02-01 15:20:38.329567','59b862f6-24f2-457d-8400-334f4d4f6ea3','key9','value9',16),('17','2026-02-01 15:20:35.332275','2026-02-01 15:20:37.133704','2026-02-01 15:20:38.329567','59b862f6-24f2-457d-8400-334f4d4f6ea3','key10','value10',17),('18','2026-02-01 15:20:35.803064','2026-02-01 15:20:37.270694','2026-02-01 15:20:38.329567','59b862f6-24f2-457d-8400-334f4d4f6ea3','key11','value11',18),('19','2026-02-01 15:20:35.805427','2026-02-01 15:20:37.722407','2026-02-01 15:20:38.329567','59b862f6-24f2-457d-8400-334f4d4f6ea3','key12','value12',19),('20','2026-02-01 15:20:41.816277','2026-02-01 15:20:42.163581','2026-02-01 15:20:44.407546','57052b66-4ef2-422d-b6cb-d8da260acde1','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value',20),('21','2026-02-01 15:20:42.198494','2026-02-01 15:20:42.569493','2026-02-01 15:20:44.407546','57052b66-4ef2-422d-b6cb-d8da260acde1','key','vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv',21),('22','2026-02-01 15:20:42.611392','2026-02-01 15:20:42.980277','2026-02-01 15:20:44.407546','57052b66-4ef2-422d-b6cb-d8da260acde1','k','value',22),('23','2026-02-01 15:20:43.011910',NULL,'2026-02-01 15:20:44.407546','57052b66-4ef2-422d-b6cb-d8da260acde1','key','v',23);
/*!40000 ALTER TABLE `share_snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshots`
--

DROP TABLE IF EXISTS `share_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshots` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `share_id` varchar(36) NOT NULL,
  `size` int(11) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `share_size` int(11) DEFAULT NULL,
  `share_proto` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_id` (`share_id`),
  CONSTRAINT `share_snapshots_ibfk_1` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshots`
--

LOCK TABLES `share_snapshots` WRITE;
/*!40000 ALTER TABLE `share_snapshots` DISABLE KEYS */;
INSERT INTO `share_snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `share_id`, `size`, `display_name`, `display_description`, `share_size`, `share_proto`) VALUES ('2026-02-01 15:14:43.198839','2026-02-01 15:14:56.140185','2026-02-01 15:14:56.139797','00151c93-f474-433b-9073-c4743a80f8a9','00151c93-f474-433b-9073-c4743a80f8a9','26e3e1d8b04f4d09b6941b9eed4bed81','42d5324bd181499ca11dbc92c8e1556c','b9e29865-8feb-4a35-b719-26ba10e308bf',1,'tempest-tempest-created-share-snap-1357550824','Tempest\'s snapshot',1,'CEPHFS'),('2026-02-01 15:15:52.289476','2026-02-01 15:16:09.174022','2026-02-01 15:16:09.173347','09169dc3-0948-42ec-b7eb-9bb0391d7a50','09169dc3-0948-42ec-b7eb-9bb0391d7a50','c768e3f3500c4bf19dcf4fcf64856998','0d63dabe67144e93ab3137e7893f5f60','3af5147f-2af3-4b2a-92e0-0a472ae560d9',1,'tempest-tempest-snapshot-name-739093145','tempest-tempest-snapshot-description-1156660936',1,'CEPHFS'),('2026-02-01 15:21:42.948563','2026-02-01 15:21:48.321172','2026-02-01 15:21:48.320670','0e53ce9d-659d-4efa-bf51-1e666e409ac3','0e53ce9d-659d-4efa-bf51-1e666e409ac3','ea0ad1ffc7314e269b800f42e5e3fc3e','ebfaf803a1c84c12ac2c950d798c01a3','af4e3236-7c5d-4b62-9828-44f21ee7a89e',1,'tempest-tempest-new-name-for-snapshot-1358908285','tempest-tempest-new-description-for-snapshot-907932389',1,'CEPHFS'),('2026-02-01 15:17:26.934344','2026-02-01 15:18:11.859972','2026-02-01 15:18:11.859546','1e96b528-01bb-4d75-b3fa-211a85006c95','1e96b528-01bb-4d75-b3fa-211a85006c95','3cf00994b85e4b779e6717ae76e983b5','368b363545bf449ebeb73c7917747ead','02ed6534-95a8-4e9b-9349-6e1c0bb2c8e7',1,'tempest-tempest-snapshot-name-1881915573','tempest-tempest-snapshot-description-1638455524',1,'CEPHFS'),('2026-02-01 15:17:51.697775','2026-02-01 15:17:56.342092','2026-02-01 15:17:56.341635','337552e6-dd85-4f6d-9610-99737469dd80','337552e6-dd85-4f6d-9610-99737469dd80','60095238b9444c4bbf425950ca283c97','5e1261fa63b348dd8c26883b016255c5','21db73d0-f6cc-4863-9c54-f1f6ce871fdd',1,'tempest-tempest-created-share-snap-797559409','Tempest\'s snapshot',1,'CEPHFS'),('2026-02-01 15:18:23.658730','2026-02-01 15:19:40.354220','2026-02-01 15:19:40.353657','383b4f57-c12d-4143-bc64-f94b56aa4406','383b4f57-c12d-4143-bc64-f94b56aa4406','a6d2572f8b864e0793ea67a069edbe05','40dced376e0d4d23b2b7de2c3fc8bd0e','6182d01b-245a-494b-bb81-378b267f898a',1,'tempest-tempest-snapshot-name-385259821','tempest-tempest-snapshot-description-1662496029',1,'CEPHFS'),('2026-02-01 15:20:27.354951','2026-02-01 15:20:30.131763','2026-02-01 15:20:30.131267','4d19973b-9f66-4818-a82a-a0723e2292db','4d19973b-9f66-4818-a82a-a0723e2292db','bf5d1db5b7fe40f0ab31649c9864bbbb','624202b32e62465ca01f75142b16617c','df1892ce-5021-49d0-8383-4875e362a7fa',1,'tempest-tempest-created-share-snap-1558823743','Tempest\'s snapshot',1,'CEPHFS'),('2026-02-01 15:19:59.873162','2026-02-01 15:20:44.410208','2026-02-01 15:20:44.409344','57052b66-4ef2-422d-b6cb-d8da260acde1','57052b66-4ef2-422d-b6cb-d8da260acde1','bf5d1db5b7fe40f0ab31649c9864bbbb','624202b32e62465ca01f75142b16617c','df1892ce-5021-49d0-8383-4875e362a7fa',1,'tempest-tempest-snapshot-name-1619869796','tempest-tempest-snapshot-description-173541762',1,'CEPHFS'),('2026-02-01 15:20:34.941051','2026-02-01 15:20:38.330944','2026-02-01 15:20:38.330594','59b862f6-24f2-457d-8400-334f4d4f6ea3','59b862f6-24f2-457d-8400-334f4d4f6ea3','bf5d1db5b7fe40f0ab31649c9864bbbb','624202b32e62465ca01f75142b16617c','df1892ce-5021-49d0-8383-4875e362a7fa',1,'tempest-tempest-created-share-snap-1946579264','Tempest\'s snapshot',1,'CEPHFS'),('2026-02-01 15:13:42.841337','2026-02-01 15:13:43.687380','2026-02-01 15:13:43.686889','5a46fbbf-9ff7-4e87-be5d-e5e24f824870','5a46fbbf-9ff7-4e87-be5d-e5e24f824870','435a807314d045b7b6183b8871d538b0','fda4ab42f467487d8e5d3007a76e3476','0d466b60-2648-465b-aef7-5ba809864391',1,'tempest-tempest-created-share-snap-633384361','Tempest\'s snapshot',1,'CEPHFS'),('2026-02-01 15:13:51.465932','2026-02-01 15:14:20.280776','2026-02-01 15:14:20.280384','5f853247-8fbf-41cc-a044-d26afb9421d6','5f853247-8fbf-41cc-a044-d26afb9421d6','435a807314d045b7b6183b8871d538b0','fda4ab42f467487d8e5d3007a76e3476','0d466b60-2648-465b-aef7-5ba809864391',1,'tempest-tempest-created-share-snap-589799351','Tempest\'s snapshot',1,'CEPHFS'),('2026-02-01 15:14:01.050010','2026-02-01 15:14:09.744080','2026-02-01 15:14:09.743575','5f8d76a2-690b-4d7e-8c67-40b563fa4add','5f8d76a2-690b-4d7e-8c67-40b563fa4add','435a807314d045b7b6183b8871d538b0','fda4ab42f467487d8e5d3007a76e3476','0d466b60-2648-465b-aef7-5ba809864391',1,'tempest-tempest-created-share-snap-1231736306','Tempest\'s snapshot',1,'CEPHFS'),('2026-02-01 15:13:11.894397','2026-02-01 15:13:17.214345','2026-02-01 15:13:17.213533','6676d9d7-897a-4be1-9444-f94c4c5eb9e9','6676d9d7-897a-4be1-9444-f94c4c5eb9e9','cfc88dace67943ebb2cda941b51534e0','cf2f906871624fa0887af8f21afda469','ed775457-44d0-495d-ad2f-880aebb5c6c4',1,'tempest-tempest-created-share-snap-66176487','Tempest\'s snapshot',1,'CEPHFS'),('2026-02-01 15:13:42.366201','2026-02-01 15:13:54.752046','2026-02-01 15:13:54.751581','7191da11-ab02-4a73-964f-85bc2cf8226c','7191da11-ab02-4a73-964f-85bc2cf8226c','2bbd6a9be41643a38007238edf9638fe','fc17e54c678d41c68e219a1686c0fe7d','1215de86-6ef2-4d6a-8dcb-b2bcf82846c1',1,'tempest-tempest-created-share-snap-880192298','Tempest\'s snapshot',1,'CEPHFS'),('2026-02-01 15:20:19.951639','2026-02-01 15:20:24.066275','2026-02-01 15:20:24.065775','a38fa840-3a94-4f26-a23d-fd03823471c0','a38fa840-3a94-4f26-a23d-fd03823471c0','bf5d1db5b7fe40f0ab31649c9864bbbb','624202b32e62465ca01f75142b16617c','df1892ce-5021-49d0-8383-4875e362a7fa',1,'tempest-tempest-created-share-snap-205771721','Tempest\'s snapshot',1,'CEPHFS'),('2026-02-01 15:20:03.331597','2026-02-01 15:20:07.776842','2026-02-01 15:20:07.776382','a8272d77-fba1-474d-b266-1d9f610d6489','a8272d77-fba1-474d-b266-1d9f610d6489','bf5d1db5b7fe40f0ab31649c9864bbbb','624202b32e62465ca01f75142b16617c','df1892ce-5021-49d0-8383-4875e362a7fa',1,'tempest-tempest-created-share-snap-365605717','Tempest\'s snapshot',1,'CEPHFS'),('2026-02-01 15:18:29.793335','2026-02-01 15:18:34.247485','2026-02-01 15:18:34.246802','b86e68d4-3845-4b37-bc61-babe728af73e','b86e68d4-3845-4b37-bc61-babe728af73e','24edeab99fbb48d7b16cdeb517c6a575','5d1e833d258140798bbddb15095488d9','37fbd9e7-28ca-49bd-889e-a1db61e1ab39',2,'tempest-tempest-created-share-snap-1378773872','Tempest\'s snapshot',2,'CEPHFS'),('2026-02-01 15:15:13.211310','2026-02-01 15:15:17.575369','2026-02-01 15:15:17.574823','bac99b88-a326-4fdb-ac75-b388970b7d3b','bac99b88-a326-4fdb-ac75-b388970b7d3b','32efe54ffae74acfbb12e72ef8334608','46cbc131a820464a9b6cd0940829aea6','c33bbc3d-caeb-43d8-aff9-0eb1aca90ec2',1,'tempest-tempest-created-share-snap-2082205173','Tempest\'s snapshot',1,'CEPHFS'),('2026-02-01 15:18:44.114813','2026-02-01 15:18:48.387072','2026-02-01 15:18:48.386699','c21d430b-3b4d-4d2f-8c15-58fdd24843b4','c21d430b-3b4d-4d2f-8c15-58fdd24843b4','24edeab99fbb48d7b16cdeb517c6a575','5d1e833d258140798bbddb15095488d9','0c5173b4-0251-4eb2-9e82-b1a7644830aa',1,'tempest-tempest-created-share-snap-1482257121','Tempest\'s snapshot',1,'CEPHFS'),('2026-02-01 15:17:25.182943','2026-02-01 15:18:04.431985','2026-02-01 15:18:04.431510','c61fb956-cb54-4a69-b984-796f123291a0','c61fb956-cb54-4a69-b984-796f123291a0','746730afb3db4d7f80045269f8973474','120c1822ab9548c2815485bc30d42a55','39c6cc76-f1bc-40bb-ab96-c41894504a86',1,'tempest-tempest-created-share-snap-1761099036','Tempest\'s snapshot',1,'CEPHFS'),('2026-02-01 15:22:08.466866','2026-02-01 15:22:13.792971','2026-02-01 15:22:13.792415','c6222879-ed29-4cfb-9aea-5793593bdf51','c6222879-ed29-4cfb-9aea-5793593bdf51','bd6f5443e9144072bcf2104c071429b2','844f34f060ef46f0be5d950e48375eb5','57395ad9-8383-40ff-9646-5aea2c7edb82',1,'tempest-tempest-snapshot-name-1851212181','tempest-tempest-snapshot-description-1488729002',1,'CEPHFS'),('2026-02-01 15:14:01.982025','2026-02-01 15:14:06.297539','2026-02-01 15:14:06.297058','de13f642-4dd6-425f-b2a2-695e92172306','de13f642-4dd6-425f-b2a2-695e92172306','435a807314d045b7b6183b8871d538b0','fda4ab42f467487d8e5d3007a76e3476','0d466b60-2648-465b-aef7-5ba809864391',1,'tempest-tempest-created-share-snap-1250850051','Tempest\'s snapshot',1,'CEPHFS'),('2026-02-01 15:14:47.648541','2026-02-01 15:14:52.408851','2026-02-01 15:14:52.407962','e2132102-39e4-41f4-a6d3-e7a2a8df27cc','e2132102-39e4-41f4-a6d3-e7a2a8df27cc','26e3e1d8b04f4d09b6941b9eed4bed81','42d5324bd181499ca11dbc92c8e1556c','b9e29865-8feb-4a35-b719-26ba10e308bf',1,'tempest-tempest-created-share-snap-560938249','Tempest\'s snapshot',1,'CEPHFS'),('2026-02-01 15:17:02.633469','2026-02-01 15:17:06.457680','2026-02-01 15:17:06.457109','f022aa77-e100-4ec5-bc9a-94f939ba4cfc','f022aa77-e100-4ec5-bc9a-94f939ba4cfc','746730afb3db4d7f80045269f8973474','120c1822ab9548c2815485bc30d42a55','34f43339-6642-416c-b3cf-973a80d4f1af',1,'tempest-tempest-created-share-snap-806954102','Tempest\'s snapshot',1,'CEPHFS'),('2026-02-01 15:13:56.772912','2026-02-01 15:14:13.424181','2026-02-01 15:14:13.423781','f1f3c043-c4de-4c8e-b742-6b2aba8a90bd','f1f3c043-c4de-4c8e-b742-6b2aba8a90bd','435a807314d045b7b6183b8871d538b0','fda4ab42f467487d8e5d3007a76e3476','0d466b60-2648-465b-aef7-5ba809864391',1,'tempest-tempest-created-share-snap-324624695','Tempest\'s snapshot',1,'CEPHFS'),('2026-02-01 15:20:11.108564','2026-02-01 15:20:16.735137','2026-02-01 15:20:16.734819','f6dd2a46-7c0a-4607-8275-a93a5c9b55f1','f6dd2a46-7c0a-4607-8275-a93a5c9b55f1','bf5d1db5b7fe40f0ab31649c9864bbbb','624202b32e62465ca01f75142b16617c','df1892ce-5021-49d0-8383-4875e362a7fa',1,'tempest-tempest-created-share-snap-986532356','Tempest\'s snapshot',1,'CEPHFS'),('2026-02-01 15:13:55.582718','2026-02-01 15:14:16.875623','2026-02-01 15:14:16.875221','fbe6d350-ea63-4fce-8220-3c83f15d3afc','fbe6d350-ea63-4fce-8220-3c83f15d3afc','435a807314d045b7b6183b8871d538b0','fda4ab42f467487d8e5d3007a76e3476','0d466b60-2648-465b-aef7-5ba809864391',1,'tempest-tempest-created-share-snap-911024067','Tempest\'s snapshot',1,'CEPHFS');
/*!40000 ALTER TABLE `share_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_type_extra_specs`
--

DROP TABLE IF EXISTS `share_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_type_extra_specs` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_type_id` varchar(36) NOT NULL,
  `spec_key` varchar(255) DEFAULT NULL,
  `spec_value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `st_id_fk` (`share_type_id`),
  CONSTRAINT `st_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=293 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_type_extra_specs`
--

LOCK TABLES `share_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `share_type_extra_specs` DISABLE KEYS */;
INSERT INTO `share_type_extra_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_type_id`, `spec_key`, `spec_value`) VALUES ('2026-02-01 15:09:13.452294',NULL,NULL,0,1,'29b95f67-19b6-4d0c-881b-ecde5688f59a','driver_handles_share_servers','False'),('2026-02-01 15:09:18.729942',NULL,NULL,0,2,'29b95f67-19b6-4d0c-881b-ecde5688f59a','snapshot_support','True'),('2026-02-01 15:09:18.734625',NULL,NULL,0,3,'29b95f67-19b6-4d0c-881b-ecde5688f59a','create_share_from_snapshot_support','True'),('2026-02-01 15:13:05.495458',NULL,'2026-02-01 15:14:24.303719',4,4,'d12a5a5d-639b-477e-9123-330697ff0216','driver_handles_share_servers','False'),('2026-02-01 15:13:05.496091',NULL,'2026-02-01 15:14:24.303719',5,5,'d12a5a5d-639b-477e-9123-330697ff0216','snapshot_support','True'),('2026-02-01 15:13:07.536506',NULL,'2026-02-01 15:13:19.216963',6,6,'7c625ff0-e084-42b2-8f17-359cee73602b','driver_handles_share_servers','False'),('2026-02-01 15:13:07.995013',NULL,'2026-02-01 15:13:24.007389',7,7,'a36752ae-228c-4fa4-8961-f141e5222f47','driver_handles_share_servers','False'),('2026-02-01 15:13:07.995843',NULL,'2026-02-01 15:13:24.007389',8,8,'a36752ae-228c-4fa4-8961-f141e5222f47','snapshot_support','True'),('2026-02-01 15:13:20.061678',NULL,'2026-02-01 15:13:29.708058',9,9,'3cd49bbe-54fc-43fb-9feb-ba0c28e6948f','driver_handles_share_servers','False'),('2026-02-01 15:13:34.094445',NULL,'2026-02-01 15:14:05.220904',10,10,'b1712ae3-d38a-4543-bf30-4854aff75f83','driver_handles_share_servers','False'),('2026-02-01 15:13:36.394278',NULL,'2026-02-01 15:14:11.289159',11,11,'9e805c93-4b57-4421-a159-7bc8b285c972','driver_handles_share_servers','False'),('2026-02-01 15:13:36.394777',NULL,'2026-02-01 15:14:11.289159',12,12,'9e805c93-4b57-4421-a159-7bc8b285c972','snapshot_support','True'),('2026-02-01 15:13:36.395262',NULL,'2026-02-01 15:14:11.289159',13,13,'9e805c93-4b57-4421-a159-7bc8b285c972','create_share_from_snapshot_support','True'),('2026-02-01 15:13:36.717726',NULL,'2026-02-01 15:14:10.871552',14,14,'7f348200-99b9-44a8-a2c6-6a72a85cdd23','driver_handles_share_servers','False'),('2026-02-01 15:13:36.823451',NULL,'2026-02-01 15:14:10.715111',15,15,'e90f5e35-a2e5-4b1f-b6c6-9946da8a57e6','driver_handles_share_servers','False'),('2026-02-01 15:13:38.452857',NULL,'2026-02-01 15:14:01.461411',16,16,'3dda19bc-6043-431c-bdc6-b4dc346cfacf','driver_handles_share_servers','False'),('2026-02-01 15:13:38.453197',NULL,'2026-02-01 15:14:01.461411',17,17,'3dda19bc-6043-431c-bdc6-b4dc346cfacf','snapshot_support','True'),('2026-02-01 15:13:44.981781',NULL,'2026-02-01 15:13:53.386559',18,18,'b107dc0b-a3d2-4667-a455-9555f6c00178','driver_handles_share_servers','False'),('2026-02-01 15:13:46.095647',NULL,'2026-02-01 15:13:54.179809',19,19,'3fdd3111-ff7b-4f4d-b59b-26496d361c4a','driver_handles_share_servers','False'),('2026-02-01 15:13:46.306243',NULL,'2026-02-01 15:13:53.935595',20,20,'aaf012e0-c2f8-4b70-a69a-205e9c8f38b3','driver_handles_share_servers','False'),('2026-02-01 15:13:46.467836',NULL,'2026-02-01 15:13:53.677132',21,21,'06540009-06b3-4424-8b0c-54ff9a5d9f37','driver_handles_share_servers','False'),('2026-02-01 15:13:47.535727',NULL,'2026-02-01 15:13:53.542126',22,22,'92a79f60-629b-4ad8-85a7-4f43c6b3b252','driver_handles_share_servers','False'),('2026-02-01 15:13:47.650457',NULL,'2026-02-01 15:13:53.368731',23,23,'033a15e9-a710-465b-a9b4-86248e3c9d2e','driver_handles_share_servers','False'),('2026-02-01 15:13:47.789446',NULL,'2026-02-01 15:13:53.129464',24,24,'734285b9-f3eb-45ec-8320-81fb330cd709','driver_handles_share_servers','False'),('2026-02-01 15:13:49.790432',NULL,'2026-02-01 15:13:53.003491',25,25,'03ed2827-795f-4cd4-9ede-93f2d909e148','driver_handles_share_servers','False'),('2026-02-01 15:13:50.027217',NULL,'2026-02-01 15:13:52.840513',26,26,'5251b3fa-67c4-4bfd-9678-6fd5177858a2','driver_handles_share_servers','False'),('2026-02-01 15:13:50.247202',NULL,'2026-02-01 15:13:52.687139',27,27,'58202eae-f486-4387-91ec-6e10ef49a758','driver_handles_share_servers','False'),('2026-02-01 15:13:50.443437',NULL,'2026-02-01 15:13:52.514416',28,28,'e81125d5-c450-4c01-a64e-7b4710fa9ad4','driver_handles_share_servers','False'),('2026-02-01 15:13:51.271336',NULL,'2026-02-01 15:13:52.335667',29,29,'13bd4ec3-9bcb-481b-8b11-64efbdd63cb1','driver_handles_share_servers','False'),('2026-02-01 15:13:51.643062',NULL,'2026-02-01 15:13:52.168914',30,30,'780716bb-d65d-40d7-b251-6ba94b4fec21','driver_handles_share_servers','False'),('2026-02-01 15:13:52.825490',NULL,'2026-02-01 15:14:10.574115',31,31,'9114c675-bbd4-440c-9a05-4ed1fac81a44','driver_handles_share_servers','False'),('2026-02-01 15:13:53.982092',NULL,'2026-02-01 15:14:10.457300',32,32,'9e90c581-8d78-460e-b301-defa031060ec','driver_handles_share_servers','False'),('2026-02-01 15:13:55.858690',NULL,'2026-02-01 15:14:10.242350',33,33,'a3b7beff-4595-4850-98fa-669e777a38c9','driver_handles_share_servers','False'),('2026-02-01 15:14:01.358954',NULL,'2026-02-01 15:14:10.023734',34,34,'03c5147f-9e6b-4926-80d2-2e0e507b08d2','driver_handles_share_servers','False'),('2026-02-01 15:14:02.652397',NULL,'2026-02-01 15:14:09.864209',35,35,'3b6eca57-06cd-4d6a-bf82-8e23cd5238d3','driver_handles_share_servers','False'),('2026-02-01 15:14:03.810277',NULL,'2026-02-01 15:14:09.656736',36,36,'3bcbd413-15ba-4ae3-819c-9320c76eabc3','driver_handles_share_servers','False'),('2026-02-01 15:14:03.904489',NULL,'2026-02-01 15:14:12.258558',37,37,'8c72e4a5-abce-45c1-bd37-67b1570e670b','driver_handles_share_servers','False'),('2026-02-01 15:14:04.151240',NULL,'2026-02-01 15:14:09.466565',38,38,'3ba0e84a-ff42-45fe-8a24-be94314611c1','driver_handles_share_servers','False'),('2026-02-01 15:14:16.706711',NULL,'2026-02-01 15:14:19.413189',39,39,'1413f1ba-1e54-4f5d-ba84-0e1d61d795e2','driver_handles_share_servers','False'),('2026-02-01 15:14:16.984529',NULL,'2026-02-01 15:14:19.286968',40,40,'f0e2884e-b874-4e86-b543-2ca7a5d2386f','driver_handles_share_servers','False'),('2026-02-01 15:14:17.136535',NULL,'2026-02-01 15:14:19.070652',41,41,'af24cf60-0064-4452-81de-0bed9195a94c','driver_handles_share_servers','False'),('2026-02-01 15:14:17.359838',NULL,'2026-02-01 15:14:18.916543',42,42,'2916f4fa-c43e-4526-b757-abe76f3b5685','driver_handles_share_servers','False'),('2026-02-01 15:14:17.524655',NULL,'2026-02-01 15:14:18.767661',43,43,'5ee1bf8c-5d84-4070-a702-de9a90f5bb83','driver_handles_share_servers','False'),('2026-02-01 15:14:17.525043',NULL,'2026-02-01 15:14:18.767661',44,44,'5ee1bf8c-5d84-4070-a702-de9a90f5bb83','share_backend_name','tempest-fake_name-491656283'),('2026-02-01 15:14:17.642860',NULL,'2026-02-01 15:14:18.630982',45,45,'30631df6-7528-4d05-b0d9-854ee2a7ccdd','driver_handles_share_servers','False'),('2026-02-01 15:14:17.643295',NULL,'2026-02-01 15:14:18.630982',46,46,'30631df6-7528-4d05-b0d9-854ee2a7ccdd','share_backend_name','tempest-fake_name-1481059314'),('2026-02-01 15:14:17.824827',NULL,'2026-02-01 15:14:18.452747',47,47,'e363664a-c7a8-4f52-b283-a3895d8359bc','driver_handles_share_servers','False'),('2026-02-01 15:14:17.825384',NULL,'2026-02-01 15:14:18.452747',48,48,'e363664a-c7a8-4f52-b283-a3895d8359bc','share_backend_name','tempest-fake_name-200475703'),('2026-02-01 15:14:18.026311',NULL,'2026-02-01 15:14:18.314141',49,49,'284913e1-0501-40b9-a30a-9466d1235582','driver_handles_share_servers','False'),('2026-02-01 15:14:18.026709',NULL,'2026-02-01 15:14:18.314141',50,50,'284913e1-0501-40b9-a30a-9466d1235582','share_backend_name','tempest-fake_name-1844230907'),('2026-02-01 15:14:18.276693',NULL,'2026-02-01 15:14:26.036835',51,51,'ae5ac208-d3f1-42e4-bd31-25e0fbedb1a8','driver_handles_share_servers','False'),('2026-02-01 15:14:23.595497',NULL,'2026-02-01 15:15:16.808231',52,52,'71a8cb03-a879-4fa1-9570-d4a2c3127be2','driver_handles_share_servers','False'),('2026-02-01 15:14:33.802705',NULL,'2026-02-01 15:14:35.583230',53,53,'6da05b34-2a71-4bd5-a814-4a664dfadb89','driver_handles_share_servers','False'),('2026-02-01 15:14:34.673170',NULL,'2026-02-01 15:14:35.000511',54,54,'e87841f0-a681-4b67-aeff-7b66b8dbf3ee','driver_handles_share_servers','False'),('2026-02-01 15:14:35.201398',NULL,'2026-02-01 15:14:35.466629',55,55,'4d5b2d2d-36a0-42cf-9edf-924a644b26ed','driver_handles_share_servers','False'),('2026-02-01 15:14:39.374612',NULL,'2026-02-01 15:15:02.531981',56,56,'c056af43-2681-4a32-98f6-e60c1f1a3560','driver_handles_share_servers','False'),('2026-02-01 15:14:39.375185',NULL,'2026-02-01 15:15:02.531981',57,57,'c056af43-2681-4a32-98f6-e60c1f1a3560','snapshot_support','True'),('2026-02-01 15:14:47.264420',NULL,'2026-02-01 15:15:06.402114',58,58,'d8cb87c7-b9fa-4c1f-978a-61b318980e99','driver_handles_share_servers','False'),('2026-02-01 15:14:47.264765',NULL,'2026-02-01 15:15:06.402114',59,59,'d8cb87c7-b9fa-4c1f-978a-61b318980e99','storage_protocol','cephfs'),('2026-02-01 15:14:51.369377',NULL,'2026-02-01 15:15:02.465945',60,60,'5be82ae1-e71e-401f-ad61-a488ed8ce4ef','driver_handles_share_servers','False'),('2026-02-01 15:14:51.370077',NULL,'2026-02-01 15:15:02.465945',61,61,'5be82ae1-e71e-401f-ad61-a488ed8ce4ef','key','value'),('2026-02-01 15:14:52.385844',NULL,'2026-02-01 15:14:52.477444',62,62,'01d40cef-106d-4955-8bd5-a3ebf2ea2c17','driver_handles_share_servers','False'),('2026-02-01 15:14:52.878022',NULL,'2026-02-01 15:15:02.316893',63,63,'2b4a783e-c9d6-4d94-b805-3c8205edf462','driver_handles_share_servers','False'),('2026-02-01 15:14:52.878477',NULL,'2026-02-01 15:15:02.316893',64,64,'2b4a783e-c9d6-4d94-b805-3c8205edf462','key','value'),('2026-02-01 15:14:52.878861',NULL,'2026-02-01 15:15:02.316893',65,65,'2b4a783e-c9d6-4d94-b805-3c8205edf462','snapshot_support','True'),('2026-02-01 15:14:53.098549',NULL,'2026-02-01 15:15:02.179012',66,66,'94357dfa-46c5-44ee-9654-159535895471','driver_handles_share_servers','False'),('2026-02-01 15:14:53.099408',NULL,'2026-02-01 15:15:02.179012',67,67,'94357dfa-46c5-44ee-9654-159535895471','key','value'),('2026-02-01 15:14:53.099944',NULL,'2026-02-01 15:15:02.179012',68,68,'94357dfa-46c5-44ee-9654-159535895471','snapshot_support','True'),('2026-02-01 15:14:53.444783',NULL,'2026-02-01 15:15:02.046106',69,69,'fe617d3e-e4df-4d41-8ba1-b8f82c221d70','driver_handles_share_servers','False'),('2026-02-01 15:14:53.445241',NULL,'2026-02-01 15:15:02.046106',70,70,'fe617d3e-e4df-4d41-8ba1-b8f82c221d70','key','value'),('2026-02-01 15:14:53.446576',NULL,'2026-02-01 15:15:02.046106',71,71,'fe617d3e-e4df-4d41-8ba1-b8f82c221d70','snapshot_support','True'),('2026-02-01 15:14:53.637048',NULL,'2026-02-01 15:15:01.866333',72,72,'c947f15f-1e63-4f76-8049-c26a8bf4ac90','driver_handles_share_servers','False'),('2026-02-01 15:14:53.637607',NULL,'2026-02-01 15:15:01.866333',73,73,'c947f15f-1e63-4f76-8049-c26a8bf4ac90','key','value'),('2026-02-01 15:14:53.850978',NULL,'2026-02-01 15:15:01.739798',74,74,'4ba638a7-be41-4526-95df-e0ea0b08f2b1','driver_handles_share_servers','False'),('2026-02-01 15:14:53.851314',NULL,'2026-02-01 15:15:01.739798',75,75,'4ba638a7-be41-4526-95df-e0ea0b08f2b1','key','value'),('2026-02-01 15:14:53.961534',NULL,'2026-02-01 15:15:01.589994',76,76,'3b693a47-a9d0-4c90-878f-7c38bae77f7c','driver_handles_share_servers','False'),('2026-02-01 15:14:53.962494',NULL,'2026-02-01 15:15:01.589994',77,77,'3b693a47-a9d0-4c90-878f-7c38bae77f7c','snapshot_support','True'),('2026-02-01 15:14:54.111471',NULL,'2026-02-01 15:15:01.419771',78,78,'928a00d6-4469-4ab5-b68b-74423fc4b40a','driver_handles_share_servers','False'),('2026-02-01 15:14:54.112548',NULL,'2026-02-01 15:15:01.419771',79,79,'928a00d6-4469-4ab5-b68b-74423fc4b40a','snapshot_support','True'),('2026-02-01 15:14:54.496775',NULL,'2026-02-01 15:15:01.255356',80,80,'d3e470a5-d3dc-40e4-b692-19f3cbf94f39','driver_handles_share_servers','False'),('2026-02-01 15:14:54.497388',NULL,'2026-02-01 15:15:01.255356',81,81,'d3e470a5-d3dc-40e4-b692-19f3cbf94f39','snapshot_support','True'),('2026-02-01 15:14:54.674390',NULL,'2026-02-01 15:15:01.051997',82,82,'45d0ada1-edc0-4fb1-b6ee-f7a05496281e','driver_handles_share_servers','False'),('2026-02-01 15:14:54.831489',NULL,'2026-02-01 15:15:00.878379',83,83,'a22b96ae-6f86-4e38-a404-3de6e1cc01f1','driver_handles_share_servers','False'),('2026-02-01 15:14:54.972083',NULL,'2026-02-01 15:15:00.574224',84,84,'e96993d4-c2e7-4424-896b-ecae96db44fd','driver_handles_share_servers','False'),('2026-02-01 15:14:55.217359',NULL,'2026-02-01 15:15:00.334011',85,85,'f3a426cb-7429-476b-b4b3-783c3248df21','driver_handles_share_servers','False'),('2026-02-01 15:14:55.393742',NULL,'2026-02-01 15:15:04.063775',86,86,'f6afe9eb-b901-4be4-a89a-bc6dc1369ca5','driver_handles_share_servers','False'),('2026-02-01 15:14:55.569165',NULL,'2026-02-01 15:15:00.070534',87,87,'a841d750-30ea-4dcb-b2a4-b52094a9a805','driver_handles_share_servers','False'),('2026-02-01 15:14:55.785927',NULL,'2026-02-01 15:14:59.889399',88,88,'260ab3e1-34b1-44ad-bedf-d795f73a94ac','driver_handles_share_servers','False'),('2026-02-01 15:14:55.786498',NULL,'2026-02-01 15:14:59.889399',89,89,'260ab3e1-34b1-44ad-bedf-d795f73a94ac','key','value'),('2026-02-01 15:14:55.912413',NULL,'2026-02-01 15:14:59.701018',90,90,'95bf4bc4-77b5-462d-b3b2-8b8d3a4866ff','driver_handles_share_servers','False'),('2026-02-01 15:14:55.912933',NULL,'2026-02-01 15:14:59.701018',91,91,'95bf4bc4-77b5-462d-b3b2-8b8d3a4866ff','key','value'),('2026-02-01 15:14:56.085819',NULL,'2026-02-01 15:14:59.501039',92,92,'223077e5-b699-41ae-a0ee-51e35718360d','driver_handles_share_servers','False'),('2026-02-01 15:14:56.086734',NULL,'2026-02-01 15:14:59.501039',93,93,'223077e5-b699-41ae-a0ee-51e35718360d','key','value'),('2026-02-01 15:14:56.267798',NULL,'2026-02-01 15:14:59.260760',94,94,'24015525-2547-4679-81ca-455acf611670','driver_handles_share_servers','False'),('2026-02-01 15:14:56.268392',NULL,'2026-02-01 15:14:59.260760',95,95,'24015525-2547-4679-81ca-455acf611670','key','value'),('2026-02-01 15:14:56.431572',NULL,'2026-02-01 15:14:58.998817',96,96,'b19c92d2-a477-49ce-8357-5dcb4397c4a9','driver_handles_share_servers','False'),('2026-02-01 15:14:56.432636',NULL,'2026-02-01 15:14:58.998817',97,97,'b19c92d2-a477-49ce-8357-5dcb4397c4a9','key','value'),('2026-02-01 15:14:56.611904',NULL,'2026-02-01 15:14:58.820300',98,98,'8faa07fc-c6fb-43b3-85f6-4af46c0c7961','driver_handles_share_servers','False'),('2026-02-01 15:14:56.631638',NULL,'2026-02-01 15:14:58.820300',99,99,'8faa07fc-c6fb-43b3-85f6-4af46c0c7961','key','value'),('2026-02-01 15:14:56.883624',NULL,'2026-02-01 15:14:58.626259',100,100,'45b6b3b7-583d-4484-801e-23c7d74e639a','driver_handles_share_servers','False'),('2026-02-01 15:14:56.884003',NULL,'2026-02-01 15:14:58.626259',101,101,'45b6b3b7-583d-4484-801e-23c7d74e639a','key','value'),('2026-02-01 15:14:57.002780',NULL,'2026-02-01 15:14:58.471844',102,102,'5102bb4b-5b06-4190-a68f-383fedb2118d','driver_handles_share_servers','False'),('2026-02-01 15:14:57.003183',NULL,'2026-02-01 15:14:58.471844',103,103,'5102bb4b-5b06-4190-a68f-383fedb2118d','key','value'),('2026-02-01 15:14:57.120273',NULL,'2026-02-01 15:14:58.279043',104,104,'7e0bfba0-23c2-482e-b780-8af1d254cb94','driver_handles_share_servers','False'),('2026-02-01 15:14:57.120615',NULL,'2026-02-01 15:14:58.279043',105,105,'7e0bfba0-23c2-482e-b780-8af1d254cb94','key','value'),('2026-02-01 15:14:57.290491',NULL,'2026-02-01 15:14:58.110336',106,106,'16773dd7-602c-4706-a43c-2c35a7f289f3','driver_handles_share_servers','False'),('2026-02-01 15:14:57.291038',NULL,'2026-02-01 15:14:58.110336',107,107,'16773dd7-602c-4706-a43c-2c35a7f289f3','key','value'),('2026-02-01 15:14:57.471145',NULL,'2026-02-01 15:14:57.952257',108,108,'10a8f669-fb05-419e-a2cb-baa217ab162e','driver_handles_share_servers','False'),('2026-02-01 15:14:57.471556',NULL,'2026-02-01 15:14:57.952257',109,109,'10a8f669-fb05-419e-a2cb-baa217ab162e','key','value'),('2026-02-01 15:14:57.639014',NULL,'2026-02-01 15:14:57.802346',110,110,'e3a25134-f57d-4cb8-a888-bb8a94edd416','driver_handles_share_servers','False'),('2026-02-01 15:14:57.639650',NULL,'2026-02-01 15:14:57.802346',111,111,'e3a25134-f57d-4cb8-a888-bb8a94edd416','key','value'),('2026-02-01 15:15:09.128795',NULL,'2026-02-01 15:15:24.436034',112,112,'61d66fc8-1151-4700-8fe3-06f0671259ab','driver_handles_share_servers','False'),('2026-02-01 15:15:09.132138',NULL,'2026-02-01 15:15:24.436034',113,113,'61d66fc8-1151-4700-8fe3-06f0671259ab','snapshot_support','True'),('2026-02-01 15:15:10.502399',NULL,'2026-02-01 15:15:11.029738',114,114,'afdd42a0-59d7-41ee-98b2-9f82eaa2a893','driver_handles_share_servers','False'),('2026-02-01 15:15:10.665753',NULL,'2026-02-01 15:15:11.029738',115,115,'afdd42a0-59d7-41ee-98b2-9f82eaa2a893','key1','value1'),('2026-02-01 15:15:10.669295',NULL,'2026-02-01 15:15:11.029738',116,116,'afdd42a0-59d7-41ee-98b2-9f82eaa2a893','key2','value2'),('2026-02-01 15:15:12.617351',NULL,'2026-02-01 15:15:35.485460',117,117,'70f1e3e3-1df6-4e6a-972a-e4316600cd5d','driver_handles_share_servers','False'),('2026-02-01 15:15:17.246276',NULL,'2026-02-01 15:15:26.675164',118,118,'d10e3efc-0c4e-4c0d-8107-efedbb1c3f82','driver_handles_share_servers','False'),('2026-02-01 15:15:17.246753',NULL,'2026-02-01 15:15:26.675164',119,119,'d10e3efc-0c4e-4c0d-8107-efedbb1c3f82','key','value'),('2026-02-01 15:15:17.594287',NULL,'2026-02-01 15:15:26.504184',120,120,'b515061e-9329-44d6-81c0-997abdf67302','driver_handles_share_servers','False'),('2026-02-01 15:15:17.594906',NULL,'2026-02-01 15:15:26.504184',121,121,'b515061e-9329-44d6-81c0-997abdf67302','key','value'),('2026-02-01 15:15:17.728645',NULL,'2026-02-01 15:15:26.321222',122,122,'b61a3898-9d53-410e-ae08-2904b76a2523','driver_handles_share_servers','False'),('2026-02-01 15:15:17.729199',NULL,'2026-02-01 15:15:26.321222',123,123,'b61a3898-9d53-410e-ae08-2904b76a2523','key','value'),('2026-02-01 15:15:18.033705',NULL,'2026-02-01 15:15:25.991256',124,124,'8ad071e8-6e20-4a9d-86c4-b4a3212b6763','driver_handles_share_servers','False'),('2026-02-01 15:15:18.034081',NULL,'2026-02-01 15:15:25.991256',125,125,'8ad071e8-6e20-4a9d-86c4-b4a3212b6763','key','value'),('2026-02-01 15:15:18.172734',NULL,'2026-02-01 15:15:25.680329',126,126,'0339587a-2e37-4834-b230-fa8f35d29a8f','driver_handles_share_servers','False'),('2026-02-01 15:15:18.173447',NULL,'2026-02-01 15:15:25.680329',127,127,'0339587a-2e37-4834-b230-fa8f35d29a8f','key','value'),('2026-02-01 15:15:18.308911',NULL,'2026-02-01 15:15:25.500782',128,128,'b2da4eab-d771-4044-92d2-3b2cbfcb9179','driver_handles_share_servers','False'),('2026-02-01 15:15:18.309264',NULL,'2026-02-01 15:15:25.500782',129,129,'b2da4eab-d771-4044-92d2-3b2cbfcb9179','key','value'),('2026-02-01 15:15:18.444280',NULL,'2026-02-01 15:15:25.346866',130,130,'1f6cd12d-f184-4889-bbf1-2d2f9d06d575','driver_handles_share_servers','False'),('2026-02-01 15:15:18.444968',NULL,'2026-02-01 15:15:25.346866',131,131,'1f6cd12d-f184-4889-bbf1-2d2f9d06d575','key','value'),('2026-02-01 15:15:18.638968',NULL,'2026-02-01 15:15:25.209260',132,132,'d4249ab8-1001-4d54-a931-b4081090d406','driver_handles_share_servers','False'),('2026-02-01 15:15:18.639313',NULL,'2026-02-01 15:15:25.209260',133,133,'d4249ab8-1001-4d54-a931-b4081090d406','key','value'),('2026-02-01 15:15:18.769290',NULL,'2026-02-01 15:15:25.031520',134,134,'31c42ea7-2f12-46f1-8759-cdafa6cc0315','driver_handles_share_servers','False'),('2026-02-01 15:15:18.769806',NULL,'2026-02-01 15:15:25.031520',135,135,'31c42ea7-2f12-46f1-8759-cdafa6cc0315','key','value'),('2026-02-01 15:15:18.917720',NULL,'2026-02-01 15:15:24.719000',136,136,'77b6aa2b-04cb-459e-b2e7-f4e48701d63b','driver_handles_share_servers','False'),('2026-02-01 15:15:18.918517',NULL,'2026-02-01 15:15:24.719000',137,137,'77b6aa2b-04cb-459e-b2e7-f4e48701d63b','key','value'),('2026-02-01 15:15:19.046806',NULL,'2026-02-01 15:15:24.507683',138,138,'75769a27-9e52-4ab0-8c71-09d962214422','driver_handles_share_servers','False'),('2026-02-01 15:15:19.047403',NULL,'2026-02-01 15:15:24.507683',139,139,'75769a27-9e52-4ab0-8c71-09d962214422','key','value'),('2026-02-01 15:15:19.363965',NULL,'2026-02-01 15:15:24.387949',140,140,'17f2bd3d-09ff-44e8-9747-fc101f17ca3a','driver_handles_share_servers','False'),('2026-02-01 15:15:19.364281',NULL,'2026-02-01 15:15:24.387949',141,141,'17f2bd3d-09ff-44e8-9747-fc101f17ca3a','key','value'),('2026-02-01 15:15:19.794826',NULL,'2026-02-01 15:15:23.988452',142,142,'ad66fc70-0367-4ade-99ba-a30a06bb221a','driver_handles_share_servers','False'),('2026-02-01 15:15:19.796904',NULL,'2026-02-01 15:15:23.988452',143,143,'ad66fc70-0367-4ade-99ba-a30a06bb221a','key','value'),('2026-02-01 15:15:20.094577',NULL,'2026-02-01 15:15:23.834732',144,144,'7ffb87f0-72ec-4e28-bb1e-a719cce2b10c','driver_handles_share_servers','False'),('2026-02-01 15:15:20.095321',NULL,'2026-02-01 15:15:23.834732',145,145,'7ffb87f0-72ec-4e28-bb1e-a719cce2b10c','key','value'),('2026-02-01 15:15:20.267151',NULL,'2026-02-01 15:15:23.679620',146,146,'abb0d653-681f-4bee-a4e2-9ab279a140de','driver_handles_share_servers','False'),('2026-02-01 15:15:20.267597',NULL,'2026-02-01 15:15:23.679620',147,147,'abb0d653-681f-4bee-a4e2-9ab279a140de','key','value'),('2026-02-01 15:15:20.386662',NULL,'2026-02-01 15:15:23.490125',148,148,'9e7649e8-c935-4946-a01c-1aa89e254197','driver_handles_share_servers','False'),('2026-02-01 15:15:20.387091',NULL,'2026-02-01 15:15:23.490125',149,149,'9e7649e8-c935-4946-a01c-1aa89e254197','key','value'),('2026-02-01 15:15:20.526349',NULL,'2026-02-01 15:15:23.279716',150,150,'67df08c4-28cd-4b99-b5d2-99898a44dae9','driver_handles_share_servers','False'),('2026-02-01 15:15:20.526754',NULL,'2026-02-01 15:15:23.279716',151,151,'67df08c4-28cd-4b99-b5d2-99898a44dae9','key','value'),('2026-02-01 15:15:20.714354',NULL,'2026-02-01 15:15:22.996283',152,152,'4a9d2f7b-cf73-450a-a466-9a92676fedee','driver_handles_share_servers','False'),('2026-02-01 15:15:20.719274',NULL,'2026-02-01 15:15:22.996283',153,153,'4a9d2f7b-cf73-450a-a466-9a92676fedee','key','value'),('2026-02-01 15:15:21.022639',NULL,'2026-02-01 15:15:22.850229',154,154,'d4fdef2a-18da-4b1d-b285-ee4fd466bf2b','driver_handles_share_servers','False'),('2026-02-01 15:15:21.025313',NULL,'2026-02-01 15:15:22.850229',155,155,'d4fdef2a-18da-4b1d-b285-ee4fd466bf2b','key','value'),('2026-02-01 15:15:21.216101',NULL,'2026-02-01 15:15:22.680154',156,156,'84dee859-d956-4264-8de3-706083935bab','driver_handles_share_servers','False'),('2026-02-01 15:15:21.216426',NULL,'2026-02-01 15:15:22.680154',157,157,'84dee859-d956-4264-8de3-706083935bab','key','value'),('2026-02-01 15:15:21.473335',NULL,'2026-02-01 15:15:22.539030',158,158,'6eeaf06b-52f1-4a12-a608-e3a6e7bc922f','driver_handles_share_servers','False'),('2026-02-01 15:15:21.474164',NULL,'2026-02-01 15:15:22.539030',159,159,'6eeaf06b-52f1-4a12-a608-e3a6e7bc922f','key','value'),('2026-02-01 15:15:21.824498',NULL,'2026-02-01 15:15:22.383910',160,160,'c5bcfd6b-0cad-40fb-b780-810ccb506431','driver_handles_share_servers','False'),('2026-02-01 15:15:21.825471',NULL,'2026-02-01 15:15:22.383910',161,161,'c5bcfd6b-0cad-40fb-b780-810ccb506431','key','value'),('2026-02-01 15:15:29.918216',NULL,'2026-02-01 15:15:33.018322',162,162,'7ebc3690-bdc3-45a9-9125-20512e7e9ed0','driver_handles_share_servers','False'),('2026-02-01 15:15:30.011715',NULL,'2026-02-01 15:15:30.088207',163,163,'7ebc3690-bdc3-45a9-9125-20512e7e9ed0','key1','value1'),('2026-02-01 15:15:30.014498',NULL,'2026-02-01 15:15:33.018322',164,164,'7ebc3690-bdc3-45a9-9125-20512e7e9ed0','key2','value2'),('2026-02-01 15:15:30.231361',NULL,'2026-02-01 15:15:32.877608',165,165,'28c5b571-5e95-4081-9ab9-e924a8a154c9','driver_handles_share_servers','False'),('2026-02-01 15:15:30.324381',NULL,'2026-02-01 15:15:32.877608',166,166,'28c5b571-5e95-4081-9ab9-e924a8a154c9','key1','value1'),('2026-02-01 15:15:30.327480',NULL,'2026-02-01 15:15:32.877608',167,167,'28c5b571-5e95-4081-9ab9-e924a8a154c9','key2','value2'),('2026-02-01 15:15:30.514509',NULL,'2026-02-01 15:15:30.739076',168,168,'28c5b571-5e95-4081-9ab9-e924a8a154c9','snapshot_support','True'),('2026-02-01 15:15:30.916082',NULL,'2026-02-01 15:15:32.697789',169,169,'e73e4286-1595-45f5-b12b-a1b75672c6d6','driver_handles_share_servers','False'),('2026-02-01 15:15:30.990165',NULL,'2026-02-01 15:15:32.697789',170,170,'e73e4286-1595-45f5-b12b-a1b75672c6d6','key1','value1'),('2026-02-01 15:15:30.992395',NULL,'2026-02-01 15:15:32.697789',171,171,'e73e4286-1595-45f5-b12b-a1b75672c6d6','key2','value2'),('2026-02-01 15:15:31.071622',NULL,'2026-02-01 15:15:31.364050',172,172,'e73e4286-1595-45f5-b12b-a1b75672c6d6','snapshot_support','True'),('2026-02-01 15:15:31.594612',NULL,'2026-02-01 15:15:32.575199',173,173,'0844004f-941e-4281-9798-3383320cbc58','driver_handles_share_servers','False'),('2026-02-01 15:15:31.724354',NULL,'2026-02-01 15:15:32.575199',174,174,'0844004f-941e-4281-9798-3383320cbc58','key1','value1'),('2026-02-01 15:15:31.727173','2026-02-01 15:15:31.799316','2026-02-01 15:15:32.575199',175,175,'0844004f-941e-4281-9798-3383320cbc58','key2','value2_updated'),('2026-02-01 15:15:32.017564',NULL,'2026-02-01 15:15:32.339558',176,176,'ae15e194-06ca-44da-84f3-1c57b2f9dbaf','driver_handles_share_servers','False'),('2026-02-01 15:15:32.082734','2026-02-01 15:15:32.181003','2026-02-01 15:15:32.339558',177,177,'ae15e194-06ca-44da-84f3-1c57b2f9dbaf','key1','fake_value1_updated'),('2026-02-01 15:15:32.085309',NULL,'2026-02-01 15:15:32.339558',178,178,'ae15e194-06ca-44da-84f3-1c57b2f9dbaf','key2','value2'),('2026-02-01 15:15:32.262134',NULL,'2026-02-01 15:16:12.755031',179,179,'e40bf1b4-fd26-4fd8-95d0-210613d1d862','driver_handles_share_servers','False'),('2026-02-01 15:15:32.262599',NULL,'2026-02-01 15:16:12.755031',180,180,'e40bf1b4-fd26-4fd8-95d0-210613d1d862','vendor_name','foobar'),('2026-02-01 15:15:35.042606',NULL,'2026-02-01 15:16:43.666842',181,181,'847063aa-e54d-49d1-b390-6611881b6691','driver_handles_share_servers','False'),('2026-02-01 15:15:36.690753',NULL,'2026-02-01 15:16:12.604616',182,182,'d3e4a564-7be4-42a0-848e-6cd396381438','driver_handles_share_servers','False'),('2026-02-01 15:15:36.691221',NULL,'2026-02-01 15:16:12.604616',183,183,'d3e4a564-7be4-42a0-848e-6cd396381438','vendor_name','foobar'),('2026-02-01 15:15:40.088969',NULL,'2026-02-01 15:15:42.858419',184,184,'8960c663-396a-4ed5-be7f-868d73c7db69','driver_handles_share_servers','False'),('2026-02-01 15:15:40.090083',NULL,'2026-02-01 15:15:42.858419',185,185,'8960c663-396a-4ed5-be7f-868d73c7db69','key','value'),('2026-02-01 15:15:40.567959',NULL,'2026-02-01 15:16:12.384365',186,186,'d3a796c1-974d-4d4f-86d6-31e24af5bf80','driver_handles_share_servers','False'),('2026-02-01 15:15:40.569396',NULL,'2026-02-01 15:16:12.384365',187,187,'d3a796c1-974d-4d4f-86d6-31e24af5bf80','vendor_name','foobar'),('2026-02-01 15:15:40.739402',NULL,'2026-02-01 15:15:42.619972',188,188,'05d02bf6-0096-4a46-b2bb-4dd1d50c6092','driver_handles_share_servers','False'),('2026-02-01 15:15:41.367327',NULL,'2026-02-01 15:15:42.427275',189,189,'e347d6b4-c1b5-49c7-a80a-4a750eb6a430','driver_handles_share_servers','False'),('2026-02-01 15:15:41.368243',NULL,'2026-02-01 15:15:42.427275',190,190,'e347d6b4-c1b5-49c7-a80a-4a750eb6a430','key','value'),('2026-02-01 15:15:41.569478',NULL,'2026-02-01 15:15:42.261951',191,191,'416aac0f-7935-43d9-b8c6-4efc81dab2c1','driver_handles_share_servers','False'),('2026-02-01 15:15:41.570087',NULL,'2026-02-01 15:15:42.261951',192,192,'416aac0f-7935-43d9-b8c6-4efc81dab2c1','key','value'),('2026-02-01 15:15:42.870128',NULL,'2026-02-01 15:16:50.221278',193,193,'a811e5d0-f6d5-4017-bb5f-544fc27e7e76','driver_handles_share_servers','False'),('2026-02-01 15:15:44.224980',NULL,'2026-02-01 15:16:12.232183',194,194,'275a2dc4-58d1-4887-a5f2-1450bb6710b6','driver_handles_share_servers','False'),('2026-02-01 15:15:44.225367',NULL,'2026-02-01 15:16:12.232183',195,195,'275a2dc4-58d1-4887-a5f2-1450bb6710b6','vendor_name','foobar'),('2026-02-01 15:15:48.581347',NULL,'2026-02-01 15:16:12.054099',196,196,'d66ef10c-1a48-4389-a804-c7ab5e8f314d','driver_handles_share_servers','False'),('2026-02-01 15:15:48.581722',NULL,'2026-02-01 15:16:12.054099',197,197,'d66ef10c-1a48-4389-a804-c7ab5e8f314d','vendor_name','foobar'),('2026-02-01 15:15:48.739625',NULL,'2026-02-01 15:16:15.905038',198,198,'120a16ad-b887-4c32-bd69-d344d97a4eee','driver_handles_share_servers','False'),('2026-02-01 15:15:48.740018',NULL,'2026-02-01 15:16:15.905038',199,199,'120a16ad-b887-4c32-bd69-d344d97a4eee','storage_protocol','cephfs'),('2026-02-01 15:15:48.740326',NULL,'2026-02-01 15:16:15.905038',200,200,'120a16ad-b887-4c32-bd69-d344d97a4eee','snapshot_support','True'),('2026-02-01 15:15:48.740642',NULL,'2026-02-01 15:16:15.905038',201,201,'120a16ad-b887-4c32-bd69-d344d97a4eee','create_share_from_snapshot_support','True'),('2026-02-01 15:15:51.985285',NULL,'2026-02-01 15:16:11.888270',202,202,'45a106aa-92ee-46aa-8dbd-e51e979b3fbb','driver_handles_share_servers','False'),('2026-02-01 15:15:51.985866',NULL,'2026-02-01 15:16:11.888270',203,203,'45a106aa-92ee-46aa-8dbd-e51e979b3fbb','vendor_name','foobar'),('2026-02-01 15:15:55.305493',NULL,'2026-02-01 15:16:11.758294',204,204,'07adc9ef-2272-4b23-ba8b-3bc6ea05d153','driver_handles_share_servers','False'),('2026-02-01 15:15:55.305938',NULL,'2026-02-01 15:16:11.758294',205,205,'07adc9ef-2272-4b23-ba8b-3bc6ea05d153','vendor_name','foobar'),('2026-02-01 15:15:59.705442',NULL,'2026-02-01 15:16:11.637647',206,206,'64010b88-05ad-4c28-a92b-293b13eb246e','driver_handles_share_servers','False'),('2026-02-01 15:15:59.707631',NULL,'2026-02-01 15:16:11.637647',207,207,'64010b88-05ad-4c28-a92b-293b13eb246e','vendor_name','foobar'),('2026-02-01 15:16:03.257496',NULL,'2026-02-01 15:16:11.514765',208,208,'bb53296f-97b7-42cf-8d24-8b3c547491c9','driver_handles_share_servers','False'),('2026-02-01 15:16:03.257916',NULL,'2026-02-01 15:16:11.514765',209,209,'bb53296f-97b7-42cf-8d24-8b3c547491c9','vendor_name','foobar'),('2026-02-01 15:16:07.601637',NULL,'2026-02-01 15:16:11.378981',210,210,'5334ac45-44fc-49d0-95bb-7c266db24118','driver_handles_share_servers','False'),('2026-02-01 15:16:07.602792',NULL,'2026-02-01 15:16:11.378981',211,211,'5334ac45-44fc-49d0-95bb-7c266db24118','vendor_name','foobar'),('2026-02-01 15:16:30.558448',NULL,'2026-02-01 15:16:38.697743',212,212,'63d145b6-fb37-4811-991f-0edbfd2cd9ff','driver_handles_share_servers','False'),('2026-02-01 15:16:31.739307',NULL,'2026-02-01 15:16:54.290668',213,213,'6e4527c7-6f92-4531-b150-fbe437acbc5f','driver_handles_share_servers','False'),('2026-02-01 15:16:31.739724',NULL,'2026-02-01 15:16:54.290668',214,214,'6e4527c7-6f92-4531-b150-fbe437acbc5f','vendor_name','foobar'),('2026-02-01 15:16:35.785748',NULL,'2026-02-01 15:16:54.054364',215,215,'37d89b9e-0f7e-463d-91bf-eac4c891403e','driver_handles_share_servers','False'),('2026-02-01 15:16:35.786159',NULL,'2026-02-01 15:16:54.054364',216,216,'37d89b9e-0f7e-463d-91bf-eac4c891403e','vendor_name','foobar'),('2026-02-01 15:16:39.924334',NULL,'2026-02-01 15:16:53.864173',217,217,'6e184f8e-4cd9-43fc-856f-053e93d4bd03','driver_handles_share_servers','False'),('2026-02-01 15:16:39.924835',NULL,'2026-02-01 15:16:53.864173',218,218,'6e184f8e-4cd9-43fc-856f-053e93d4bd03','vendor_name','foobar'),('2026-02-01 15:16:44.210265',NULL,'2026-02-01 15:16:53.546296',219,219,'aceeeaf5-0220-422f-ad4e-febda069bdd9','driver_handles_share_servers','False'),('2026-02-01 15:16:44.212036',NULL,'2026-02-01 15:16:53.546296',220,220,'aceeeaf5-0220-422f-ad4e-febda069bdd9','vendor_name','foobar'),('2026-02-01 15:16:48.733693',NULL,'2026-02-01 15:16:53.324979',221,221,'1ee8abb9-5f19-4316-b114-c5b3500a2ff5','driver_handles_share_servers','False'),('2026-02-01 15:16:48.734453',NULL,'2026-02-01 15:16:53.324979',222,222,'1ee8abb9-5f19-4316-b114-c5b3500a2ff5','vendor_name','foobar'),('2026-02-01 15:16:52.073982',NULL,NULL,0,223,'5b0c2719-9cba-4adb-b36c-2f65cfd23a4c','driver_handles_share_servers','False'),('2026-02-01 15:16:58.880445',NULL,'2026-02-01 15:18:12.265690',224,224,'f74f4e50-b67a-4dd2-8817-d029903f2283','driver_handles_share_servers','False'),('2026-02-01 15:16:58.935844',NULL,'2026-02-01 15:17:13.409558',225,225,'01cc7ed9-ffd6-4668-816c-0807ff3b9e16','driver_handles_share_servers','False'),('2026-02-01 15:16:58.936262',NULL,'2026-02-01 15:17:13.409558',226,226,'01cc7ed9-ffd6-4668-816c-0807ff3b9e16','snapshot_support','True'),('2026-02-01 15:17:03.099787',NULL,'2026-02-01 15:17:31.909102',227,227,'04283c6a-2cd4-4e89-807e-97c9144c5657','driver_handles_share_servers','False'),('2026-02-01 15:17:03.984263',NULL,'2026-02-01 15:17:05.248658',228,228,'cce11e56-2a3a-44e1-bdff-c22593bfec7f','driver_handles_share_servers','False'),('2026-02-01 15:17:11.695981',NULL,'2026-02-01 15:17:13.840728',229,229,'9132f50b-18b6-4026-aa0a-09214a0bba42','driver_handles_share_servers','False'),('2026-02-01 15:17:12.266368','2026-02-01 15:17:12.675817','2026-02-01 15:17:13.840728',230,230,'9132f50b-18b6-4026-aa0a-09214a0bba42','availability_zones','az_that_doesnt_exist'),('2026-02-01 15:17:12.335148',NULL,'2026-02-01 15:17:12.497889',231,231,'90a94627-0849-434c-97e8-7e492740e03a','driver_handles_share_servers','False'),('2026-02-01 15:17:21.561962',NULL,'2026-02-01 15:18:11.161328',232,232,'9e8345c3-c425-444a-948b-e657e9fcd15d','driver_handles_share_servers','False'),('2026-02-01 15:17:21.562587',NULL,'2026-02-01 15:18:11.161328',233,233,'9e8345c3-c425-444a-948b-e657e9fcd15d','snapshot_support','True'),('2026-02-01 15:17:21.563462',NULL,'2026-02-01 15:18:11.161328',234,234,'9e8345c3-c425-444a-948b-e657e9fcd15d','create_share_from_snapshot_support','True'),('2026-02-01 15:17:22.532085',NULL,'2026-02-01 15:18:18.554583',235,235,'9438b119-75d0-4d28-9efc-827b70bc86e1','driver_handles_share_servers','False'),('2026-02-01 15:17:22.533036',NULL,'2026-02-01 15:18:18.554583',236,236,'9438b119-75d0-4d28-9efc-827b70bc86e1','snapshot_support','True'),('2026-02-01 15:17:48.167072',NULL,'2026-02-01 15:18:02.863809',237,237,'4a6a9091-c2d9-4ce4-85d0-0da2193297bc','driver_handles_share_servers','False'),('2026-02-01 15:17:48.167789',NULL,'2026-02-01 15:18:02.863809',238,238,'4a6a9091-c2d9-4ce4-85d0-0da2193297bc','snapshot_support','True'),('2026-02-01 15:18:19.898717',NULL,'2026-02-01 15:19:47.146018',239,239,'83bac904-ede0-4c77-b192-b7b619e38cb3','driver_handles_share_servers','False'),('2026-02-01 15:18:19.899228',NULL,'2026-02-01 15:19:47.146018',240,240,'83bac904-ede0-4c77-b192-b7b619e38cb3','snapshot_support','True'),('2026-02-01 15:18:19.899596',NULL,'2026-02-01 15:19:47.146018',241,241,'83bac904-ede0-4c77-b192-b7b619e38cb3','create_share_from_snapshot_support','True'),('2026-02-01 15:18:26.008548',NULL,'2026-02-01 15:18:54.929553',242,242,'c2e98db5-6825-4e4c-8366-569c74530e00','driver_handles_share_servers','False'),('2026-02-01 15:18:26.009223',NULL,'2026-02-01 15:18:54.929553',243,243,'c2e98db5-6825-4e4c-8366-569c74530e00','snapshot_support','True'),('2026-02-01 15:18:26.013303',NULL,'2026-02-01 15:18:54.929553',244,244,'c2e98db5-6825-4e4c-8366-569c74530e00','create_share_from_snapshot_support','True'),('2026-02-01 15:18:28.195417',NULL,'2026-02-01 15:18:30.243986',245,245,'7627787b-66e7-4152-84ee-791b30d18969','driver_handles_share_servers','False'),('2026-02-01 15:18:38.717331',NULL,'2026-02-01 15:18:54.965662',246,246,'deaa419b-0383-4513-8c9a-24b9d74cd8e2','driver_handles_share_servers','False'),('2026-02-01 15:19:03.248689',NULL,'2026-02-01 15:19:34.429674',247,247,'4f1b79a2-3597-416f-9735-5bd373e5c8ee','driver_handles_share_servers','False'),('2026-02-01 15:19:42.778405',NULL,'2026-02-01 15:20:24.483553',248,248,'e6371ab2-3a9c-4858-bc71-54efe991623a','driver_handles_share_servers','False'),('2026-02-01 15:19:43.271339',NULL,'2026-02-01 15:19:43.461426',249,249,'256b3ac1-770a-4674-8dcf-758e31cd4d7f','driver_handles_share_servers','False'),('2026-02-01 15:19:43.271706',NULL,'2026-02-01 15:19:43.461426',250,250,'256b3ac1-770a-4674-8dcf-758e31cd4d7f','availability_zones','az1,az2,az 3'),('2026-02-01 15:19:43.641237',NULL,'2026-02-01 15:19:43.791039',251,251,'0238c80b-bbd0-424e-b4e6-b23a59721aef','driver_handles_share_servers','False'),('2026-02-01 15:19:43.641675',NULL,'2026-02-01 15:19:43.791039',252,252,'0238c80b-bbd0-424e-b4e6-b23a59721aef','availability_zones','az1,az2,az 3'),('2026-02-01 15:19:43.987750',NULL,'2026-02-01 15:19:44.314507',253,253,'0f0b83a6-8e47-4269-917f-54b4bf5c249a','driver_handles_share_servers','False'),('2026-02-01 15:19:43.988148',NULL,'2026-02-01 15:19:44.314507',254,254,'0f0b83a6-8e47-4269-917f-54b4bf5c249a','availability_zones','az1,az2,az 3'),('2026-02-01 15:19:44.577032',NULL,'2026-02-01 15:19:44.965277',255,255,'076800a0-f682-4581-afd3-d63a7b0d63cb','driver_handles_share_servers','False'),('2026-02-01 15:19:44.577395',NULL,'2026-02-01 15:19:44.965277',256,256,'076800a0-f682-4581-afd3-d63a7b0d63cb','availability_zones','az1,az2,az 3'),('2026-02-01 15:19:44.643380',NULL,'2026-02-01 15:19:44.827506',257,257,'d83171f4-dece-4e6f-94da-79a52afc657a','driver_handles_share_servers','False'),('2026-02-01 15:19:45.152159',NULL,'2026-02-01 15:19:45.632829',258,258,'7329db41-e32e-48c0-8a34-5b0bd93f1977','driver_handles_share_servers','False'),('2026-02-01 15:19:45.152658',NULL,'2026-02-01 15:19:45.632829',259,259,'7329db41-e32e-48c0-8a34-5b0bd93f1977','availability_zones','az1,az2,az 3'),('2026-02-01 15:19:45.274121',NULL,'2026-02-01 15:19:45.457257',260,260,'912a6610-a30f-4a83-80dc-68dda4198959','driver_handles_share_servers','False'),('2026-02-01 15:19:45.770291',NULL,'2026-02-01 15:19:46.304623',261,261,'438c6187-b2bf-4f6e-8770-3a120657f9a4','driver_handles_share_servers','False'),('2026-02-01 15:19:45.770788',NULL,'2026-02-01 15:19:46.304623',262,262,'438c6187-b2bf-4f6e-8770-3a120657f9a4','availability_zones','az1,az2,az 3'),('2026-02-01 15:19:45.857352',NULL,'2026-02-01 15:19:46.079709',263,263,'1d477d0b-25ed-48a9-b0da-f1bf8e8a58c1','driver_handles_share_servers','False'),('2026-02-01 15:19:46.469970',NULL,'2026-02-01 15:19:47.006217',264,264,'40053396-7684-426f-af42-7bc15f4aaf91','driver_handles_share_servers','False'),('2026-02-01 15:19:46.470409',NULL,'2026-02-01 15:19:47.006217',265,265,'40053396-7684-426f-af42-7bc15f4aaf91','availability_zones','az1,az2,az 3'),('2026-02-01 15:19:46.551500',NULL,'2026-02-01 15:19:46.727748',266,266,'9b59b39a-6667-4f06-8229-415a9d1479f0','driver_handles_share_servers','False'),('2026-02-01 15:19:47.264783',NULL,'2026-02-01 15:19:47.931986',267,267,'e0b57567-68f1-41a2-b532-96b28da2b2d1','driver_handles_share_servers','False'),('2026-02-01 15:19:47.265409',NULL,'2026-02-01 15:19:47.931986',268,268,'e0b57567-68f1-41a2-b532-96b28da2b2d1','availability_zones','az1,az2,az 3'),('2026-02-01 15:19:47.343511',NULL,'2026-02-01 15:19:47.586489',269,269,'622202e1-fb6f-4944-b42e-d858f44dabb8','driver_handles_share_servers','False'),('2026-02-01 15:19:48.195530',NULL,'2026-02-01 15:19:48.624129',270,270,'f2d39541-1971-476c-a7c9-2bc4af497c9f','driver_handles_share_servers','False'),('2026-02-01 15:19:48.195907',NULL,'2026-02-01 15:19:48.624129',271,271,'f2d39541-1971-476c-a7c9-2bc4af497c9f','availability_zones','az1,az2,az 3'),('2026-02-01 15:19:48.282050',NULL,'2026-02-01 15:19:48.433000',272,272,'a5f1a1f5-23b4-4794-9a4f-bc3f00fc95b6','driver_handles_share_servers','False'),('2026-02-01 15:19:48.784577','2026-02-01 15:20:00.912143','2026-02-01 15:20:24.483553',273,273,'e6371ab2-3a9c-4858-bc71-54efe991623a','availability_zones','nova'),('2026-02-01 15:19:56.001293',NULL,'2026-02-01 15:20:48.161939',274,274,'b9d443de-3e6e-4a4a-a894-066b97905353','driver_handles_share_servers','False'),('2026-02-01 15:19:56.001856',NULL,'2026-02-01 15:20:48.161939',275,275,'b9d443de-3e6e-4a4a-a894-066b97905353','snapshot_support','True'),('2026-02-01 15:19:56.002355',NULL,'2026-02-01 15:20:48.161939',276,276,'b9d443de-3e6e-4a4a-a894-066b97905353','create_share_from_snapshot_support','True'),('2026-02-01 15:20:20.546212',NULL,'2026-02-01 15:20:31.178181',277,277,'6037d96d-f585-4197-9f61-6388033ebf82','driver_handles_share_servers','False'),('2026-02-01 15:20:31.948411',NULL,'2026-02-01 15:20:34.280731',278,278,'73f9faad-1d01-48c5-880a-7299eb2691e8','driver_handles_share_servers','False'),('2026-02-01 15:20:32.043949',NULL,'2026-02-01 15:20:34.084970',279,279,'91657f68-a2eb-496a-ab0c-6f87c9b2acef','driver_handles_share_servers','False'),('2026-02-01 15:20:32.044377',NULL,'2026-02-01 15:20:34.084970',280,280,'91657f68-a2eb-496a-ab0c-6f87c9b2acef','provisioning:max_share_size','5'),('2026-02-01 15:20:32.045080',NULL,'2026-02-01 15:20:34.084970',281,281,'91657f68-a2eb-496a-ab0c-6f87c9b2acef','provisioning:min_share_size','2'),('2026-02-01 15:20:39.937795',NULL,'2026-02-01 15:20:43.341827',282,282,'32dae5a2-0049-4f6f-8a47-80af3e2a1cfe','driver_handles_share_servers','False'),('2026-02-01 15:20:52.316797',NULL,'2026-02-01 15:20:53.620785',283,283,'3d7b424c-d14e-4803-b800-ed2654750b8a','driver_handles_share_servers','False'),('2026-02-01 15:21:02.174591',NULL,'2026-02-01 15:21:07.078971',284,284,'69055d1a-5f0f-4fb0-ac86-7dce1ca47366','driver_handles_share_servers','False'),('2026-02-01 15:21:16.546469',NULL,'2026-02-01 15:21:19.742758',285,285,'d200f3e2-8cbd-4606-a4fe-7659c962190d','driver_handles_share_servers','False'),('2026-02-01 15:21:26.984517',NULL,'2026-02-01 15:21:29.062730',286,286,'de8c64d4-fdd3-48ca-b3d2-7a08bfffb8b7','driver_handles_share_servers','False'),('2026-02-01 15:21:27.120074',NULL,'2026-02-01 15:21:28.889237',287,287,'36ded882-fb52-4786-9b8a-3a39009f1cea','driver_handles_share_servers','False'),('2026-02-01 15:21:39.255243',NULL,'2026-02-01 15:21:54.879295',288,288,'232f280e-a80b-4dbd-be5c-473370cb110d','driver_handles_share_servers','False'),('2026-02-01 15:21:39.257297',NULL,'2026-02-01 15:21:54.879295',289,289,'232f280e-a80b-4dbd-be5c-473370cb110d','snapshot_support','True'),('2026-02-01 15:22:04.714165',NULL,'2026-02-01 15:22:20.477938',290,290,'b601a256-782e-4c57-86e2-e39b6a70a570','driver_handles_share_servers','False'),('2026-02-01 15:22:04.715010',NULL,'2026-02-01 15:22:20.477938',291,291,'b601a256-782e-4c57-86e2-e39b6a70a570','snapshot_support','True'),('2026-02-01 15:22:04.715644',NULL,'2026-02-01 15:22:20.477938',292,292,'b601a256-782e-4c57-86e2-e39b6a70a570','create_share_from_snapshot_support','True');
/*!40000 ALTER TABLE `share_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_type_projects`
--

DROP TABLE IF EXISTS `share_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `stp_project_id_uc` (`share_type_id`,`project_id`,`deleted`),
  CONSTRAINT `stp_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_type_projects`
--

LOCK TABLES `share_type_projects` WRITE;
/*!40000 ALTER TABLE `share_type_projects` DISABLE KEYS */;
INSERT INTO `share_type_projects` (`id`, `created_at`, `updated_at`, `deleted_at`, `share_type_id`, `project_id`, `deleted`) VALUES (1,'2026-02-01 15:14:51.650942',NULL,'2026-02-01 15:14:52.043444','5be82ae1-e71e-401f-ad61-a488ed8ce4ef','b3c21deb7cba41feaff782713b1775e6',1);
/*!40000 ALTER TABLE `share_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_types`
--

DROP TABLE IF EXISTS `share_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_types` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `st_name_uc` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_types`
--

LOCK TABLES `share_types` WRITE;
/*!40000 ALTER TABLE `share_types` DISABLE KEYS */;
INSERT INTO `share_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `is_public`, `description`) VALUES ('2026-02-01 15:16:58.935204',NULL,'2026-02-01 15:17:13.412751','01cc7ed9-ffd6-4668-816c-0807ff3b9e16','01cc7ed9-ffd6-4668-816c-0807ff3b9e16','tempest-typeshare-type-35333548',1,NULL),('2026-02-01 15:14:52.385198',NULL,'2026-02-01 15:14:52.480601','01d40cef-106d-4955-8bd5-a3ebf2ea2c17','01d40cef-106d-4955-8bd5-a3ebf2ea2c17','tempest-tempest-manila-541325128',1,NULL),('2026-02-01 15:19:43.640355',NULL,'2026-02-01 15:19:43.795031','0238c80b-bbd0-424e-b4e6-b23a59721aef','0238c80b-bbd0-424e-b4e6-b23a59721aef','tempest-az_share_type-1277011043',1,NULL),('2026-02-01 15:15:18.171442',NULL,'2026-02-01 15:15:25.684102','0339587a-2e37-4834-b230-fa8f35d29a8f','0339587a-2e37-4834-b230-fa8f35d29a8f','tempest-typeshare-type-2023890487',1,NULL),('2026-02-01 15:13:47.649584',NULL,'2026-02-01 15:13:53.370725','033a15e9-a710-465b-a9b4-86248e3c9d2e','033a15e9-a710-465b-a9b4-86248e3c9d2e','tempest-typeshare-type-1894706771',1,NULL),('2026-02-01 15:14:01.357980',NULL,'2026-02-01 15:14:10.026120','03c5147f-9e6b-4926-80d2-2e0e507b08d2','03c5147f-9e6b-4926-80d2-2e0e507b08d2','tempest-typeshare-type-782636499',1,NULL),('2026-02-01 15:13:49.789647',NULL,'2026-02-01 15:13:53.006572','03ed2827-795f-4cd4-9ede-93f2d909e148','03ed2827-795f-4cd4-9ede-93f2d909e148','tempest-typeshare-type-1374062920',1,NULL),('2026-02-01 15:17:03.098759',NULL,'2026-02-01 15:17:31.911860','04283c6a-2cd4-4e89-807e-97c9144c5657','04283c6a-2cd4-4e89-807e-97c9144c5657','tempest-typeshare-type-150363070',1,NULL),('2026-02-01 15:15:40.736514',NULL,'2026-02-01 15:15:42.622970','05d02bf6-0096-4a46-b2bb-4dd1d50c6092','05d02bf6-0096-4a46-b2bb-4dd1d50c6092','tempest-share-type-1213194661',0,NULL),('2026-02-01 15:13:46.467136',NULL,'2026-02-01 15:13:53.679564','06540009-06b3-4424-8b0c-54ff9a5d9f37','06540009-06b3-4424-8b0c-54ff9a5d9f37','tempest-typeshare-type-1236469691',1,NULL),('2026-02-01 15:19:44.574016',NULL,'2026-02-01 15:19:44.968179','076800a0-f682-4581-afd3-d63a7b0d63cb','076800a0-f682-4581-afd3-d63a7b0d63cb','tempest-support_some_azs_share_type-112823862',1,NULL),('2026-02-01 15:15:55.304731',NULL,'2026-02-01 15:16:11.760641','07adc9ef-2272-4b23-ba8b-3bc6ea05d153','07adc9ef-2272-4b23-ba8b-3bc6ea05d153','tempest-share-type-938947661',1,NULL),('2026-02-01 15:15:31.593766',NULL,'2026-02-01 15:15:32.577431','0844004f-941e-4281-9798-3383320cbc58','0844004f-941e-4281-9798-3383320cbc58','tempest-share-type-584671953',1,NULL),('2026-02-01 15:19:43.987164',NULL,'2026-02-01 15:19:44.317049','0f0b83a6-8e47-4269-917f-54b4bf5c249a','0f0b83a6-8e47-4269-917f-54b4bf5c249a','tempest-az_share_type-1055121769',1,NULL),('2026-02-01 15:14:57.470091','2026-02-01 15:14:57.555614','2026-02-01 15:14:57.956330','10a8f669-fb05-419e-a2cb-baa217ab162e','10a8f669-fb05-419e-a2cb-baa217ab162e','tempest-tempest-manila-535266807',1,NULL),('2026-02-01 15:15:48.738708',NULL,'2026-02-01 15:16:15.907536','120a16ad-b887-4c32-bd69-d344d97a4eee','120a16ad-b887-4c32-bd69-d344d97a4eee','tempest-typeshare-type-1806979981',1,NULL),('2026-02-01 15:13:51.270501',NULL,'2026-02-01 15:13:52.338304','13bd4ec3-9bcb-481b-8b11-64efbdd63cb1','13bd4ec3-9bcb-481b-8b11-64efbdd63cb1','tempest-typeshare-type-155606187',1,NULL),('2026-02-01 15:14:16.703293',NULL,'2026-02-01 15:14:19.415647','1413f1ba-1e54-4f5d-ba84-0e1d61d795e2','1413f1ba-1e54-4f5d-ba84-0e1d61d795e2','tempest-typeshare-type-1004440877',1,NULL),('2026-02-01 15:14:57.289423','2026-02-01 15:14:57.382839','2026-02-01 15:14:58.122047','16773dd7-602c-4706-a43c-2c35a7f289f3','16773dd7-602c-4706-a43c-2c35a7f289f3','tempest-tempest-manila-1205634417',0,'Description for share type'),('2026-02-01 15:15:19.363318',NULL,'2026-02-01 15:15:24.391978','17f2bd3d-09ff-44e8-9747-fc101f17ca3a','17f2bd3d-09ff-44e8-9747-fc101f17ca3a','tempest-typeshare-type-216330740',1,NULL),('2026-02-01 15:19:45.856443',NULL,'2026-02-01 15:19:46.083181','1d477d0b-25ed-48a9-b0da-f1bf8e8a58c1','1d477d0b-25ed-48a9-b0da-f1bf8e8a58c1','tempest-support_any_az_share_type-1371136873',1,NULL),('2026-02-01 15:16:48.732198',NULL,'2026-02-01 15:16:53.330664','1ee8abb9-5f19-4316-b114-c5b3500a2ff5','1ee8abb9-5f19-4316-b114-c5b3500a2ff5','tempest-share-type-2035064237',1,NULL),('2026-02-01 15:15:18.443586',NULL,'2026-02-01 15:15:25.348831','1f6cd12d-f184-4889-bbf1-2d2f9d06d575','1f6cd12d-f184-4889-bbf1-2d2f9d06d575','tempest-typeshare-type-1916388204',1,NULL),('2026-02-01 15:14:56.084938','2026-02-01 15:14:56.196682','2026-02-01 15:14:59.504826','223077e5-b699-41ae-a0ee-51e35718360d','223077e5-b699-41ae-a0ee-51e35718360d','tempest-tempest-manila-1031597823',1,'description_updated'),('2026-02-01 15:21:39.254326',NULL,'2026-02-01 15:21:54.882322','232f280e-a80b-4dbd-be5c-473370cb110d','232f280e-a80b-4dbd-be5c-473370cb110d','tempest-typeshare-type-939490887',1,NULL),('2026-02-01 15:14:56.266819','2026-02-01 15:14:56.348552','2026-02-01 15:14:59.264603','24015525-2547-4679-81ca-455acf611670','24015525-2547-4679-81ca-455acf611670','tempest-tempest-manila-1841210385',1,'Description for share type'),('2026-02-01 15:19:43.270627',NULL,'2026-02-01 15:19:43.464145','256b3ac1-770a-4674-8dcf-758e31cd4d7f','256b3ac1-770a-4674-8dcf-758e31cd4d7f','tempest-az_share_type-121593401',1,NULL),('2026-02-01 15:14:55.784855','2026-02-01 15:14:55.857956','2026-02-01 15:14:59.892290','260ab3e1-34b1-44ad-bedf-d795f73a94ac','260ab3e1-34b1-44ad-bedf-d795f73a94ac','tempest-type_updated-1855061985',1,'description_updated'),('2026-02-01 15:15:44.224239',NULL,'2026-02-01 15:16:12.238835','275a2dc4-58d1-4887-a5f2-1450bb6710b6','275a2dc4-58d1-4887-a5f2-1450bb6710b6','tempest-share-type-252528374',1,NULL),('2026-02-01 15:14:18.025314',NULL,'2026-02-01 15:14:18.319651','284913e1-0501-40b9-a30a-9466d1235582','284913e1-0501-40b9-a30a-9466d1235582','tempest-unique_st_name-136352300',1,NULL),('2026-02-01 15:15:30.230521',NULL,'2026-02-01 15:15:32.880441','28c5b571-5e95-4081-9ab9-e924a8a154c9','28c5b571-5e95-4081-9ab9-e924a8a154c9','tempest-share-type-838019030',1,NULL),('2026-02-01 15:14:17.359273',NULL,'2026-02-01 15:14:18.934525','2916f4fa-c43e-4526-b757-abe76f3b5685','2916f4fa-c43e-4526-b757-abe76f3b5685','tempest-typeshare-type-814394903',1,NULL),('2026-02-01 15:09:13.450728',NULL,NULL,'False','29b95f67-19b6-4d0c-881b-ecde5688f59a','default',1,NULL),('2026-02-01 15:14:52.877245',NULL,'2026-02-01 15:15:02.319453','2b4a783e-c9d6-4d94-b805-3c8205edf462','2b4a783e-c9d6-4d94-b805-3c8205edf462','tempest-tempest-manila-885462966',1,NULL),('2026-02-01 15:14:17.642030',NULL,'2026-02-01 15:14:18.633104','30631df6-7528-4d05-b0d9-854ee2a7ccdd','30631df6-7528-4d05-b0d9-854ee2a7ccdd','tempest-unique_st_name-1258462702',1,NULL),('2026-02-01 15:15:18.768477',NULL,'2026-02-01 15:15:25.033690','31c42ea7-2f12-46f1-8759-cdafa6cc0315','31c42ea7-2f12-46f1-8759-cdafa6cc0315','tempest-typeshare-type-1871516528',1,NULL),('2026-02-01 15:20:39.936775',NULL,'2026-02-01 15:20:43.344265','32dae5a2-0049-4f6f-8a47-80af3e2a1cfe','32dae5a2-0049-4f6f-8a47-80af3e2a1cfe','tempest-typeshare-type-1172884676',1,NULL),('2026-02-01 15:21:27.118690',NULL,'2026-02-01 15:21:28.891728','36ded882-fb52-4786-9b8a-3a39009f1cea','36ded882-fb52-4786-9b8a-3a39009f1cea','tempest-typeshare-type-842616161',1,NULL),('2026-02-01 15:16:35.784985',NULL,'2026-02-01 15:16:54.058393','37d89b9e-0f7e-463d-91bf-eac4c891403e','37d89b9e-0f7e-463d-91bf-eac4c891403e','tempest-share-type-1091867425',1,NULL),('2026-02-01 15:14:53.960650',NULL,'2026-02-01 15:15:01.609824','3b693a47-a9d0-4c90-878f-7c38bae77f7c','3b693a47-a9d0-4c90-878f-7c38bae77f7c','tempest-tempest-manila-550304978',1,NULL),('2026-02-01 15:14:02.650471',NULL,'2026-02-01 15:14:09.866429','3b6eca57-06cd-4d6a-bf82-8e23cd5238d3','3b6eca57-06cd-4d6a-bf82-8e23cd5238d3','tempest-typeshare-type-613318838',0,NULL),('2026-02-01 15:14:04.150237',NULL,'2026-02-01 15:14:09.475051','3ba0e84a-ff42-45fe-8a24-be94314611c1','3ba0e84a-ff42-45fe-8a24-be94314611c1','tempest-typeshare-type-933166303',1,NULL),('2026-02-01 15:14:03.809050',NULL,'2026-02-01 15:14:09.659765','3bcbd413-15ba-4ae3-819c-9320c76eabc3','3bcbd413-15ba-4ae3-819c-9320c76eabc3','tempest-typeshare-type-1150886474',1,NULL),('2026-02-01 15:13:20.058510',NULL,'2026-02-01 15:13:29.713342','3cd49bbe-54fc-43fb-9feb-ba0c28e6948f','3cd49bbe-54fc-43fb-9feb-ba0c28e6948f','tempest-typeshare-type-122201129',1,NULL),('2026-02-01 15:20:52.316157',NULL,'2026-02-01 15:20:53.626205','3d7b424c-d14e-4803-b800-ed2654750b8a','3d7b424c-d14e-4803-b800-ed2654750b8a','tempest-typeshare-type-212775573',1,NULL),('2026-02-01 15:13:38.452232',NULL,'2026-02-01 15:14:01.465949','3dda19bc-6043-431c-bdc6-b4dc346cfacf','3dda19bc-6043-431c-bdc6-b4dc346cfacf','tempest-typeshare-type-125408448',1,NULL),('2026-02-01 15:13:46.094809',NULL,'2026-02-01 15:13:54.182763','3fdd3111-ff7b-4f4d-b59b-26496d361c4a','3fdd3111-ff7b-4f4d-b59b-26496d361c4a','tempest-typeshare-type-150830725',1,NULL),('2026-02-01 15:19:46.469277',NULL,'2026-02-01 15:19:47.009619','40053396-7684-426f-af42-7bc15f4aaf91','40053396-7684-426f-af42-7bc15f4aaf91','tempest-support_some_azs_share_type-1461751657',1,NULL),('2026-02-01 15:15:41.568459',NULL,'2026-02-01 15:15:42.264066','416aac0f-7935-43d9-b8c6-4efc81dab2c1','416aac0f-7935-43d9-b8c6-4efc81dab2c1','tempest-typeshare-type-1285870976',1,NULL),('2026-02-01 15:19:45.769103',NULL,'2026-02-01 15:19:46.306688','438c6187-b2bf-4f6e-8770-3a120657f9a4','438c6187-b2bf-4f6e-8770-3a120657f9a4','tempest-support_some_azs_share_type-1022743699',1,NULL),('2026-02-01 15:15:51.984437',NULL,'2026-02-01 15:16:11.890203','45a106aa-92ee-46aa-8dbd-e51e979b3fbb','45a106aa-92ee-46aa-8dbd-e51e979b3fbb','tempest-share-type-881952964',1,NULL),('2026-02-01 15:14:56.882901','2026-02-01 15:14:56.937046','2026-02-01 15:14:58.628829','45b6b3b7-583d-4484-801e-23c7d74e639a','45b6b3b7-583d-4484-801e-23c7d74e639a','tempest-type_updated-359347282',1,'Description for share type'),('2026-02-01 15:14:54.673301',NULL,'2026-02-01 15:15:01.056360','45d0ada1-edc0-4fb1-b6ee-f7a05496281e','45d0ada1-edc0-4fb1-b6ee-f7a05496281e','tempest-tempest-manila-695433487',1,NULL),('2026-02-01 15:17:48.165311',NULL,'2026-02-01 15:18:02.867948','4a6a9091-c2d9-4ce4-85d0-0da2193297bc','4a6a9091-c2d9-4ce4-85d0-0da2193297bc','tempest-typeshare-type-319423984',1,NULL),('2026-02-01 15:15:20.705438',NULL,'2026-02-01 15:15:22.999145','4a9d2f7b-cf73-450a-a466-9a92676fedee','4a9d2f7b-cf73-450a-a466-9a92676fedee','tempest-typeshare-type-933510614',1,NULL),('2026-02-01 15:14:53.850252',NULL,'2026-02-01 15:15:01.742334','4ba638a7-be41-4526-95df-e0ea0b08f2b1','4ba638a7-be41-4526-95df-e0ea0b08f2b1','tempest-tempest-manila-1526146107',1,'Description for share type'),('2026-02-01 15:14:35.200615',NULL,'2026-02-01 15:14:35.470123','4d5b2d2d-36a0-42cf-9edf-924a644b26ed','4d5b2d2d-36a0-42cf-9edf-924a644b26ed','tempest-tempest-manila-2096645170',0,NULL),('2026-02-01 15:19:03.247306',NULL,'2026-02-01 15:19:34.433135','4f1b79a2-3597-416f-9735-5bd373e5c8ee','4f1b79a2-3597-416f-9735-5bd373e5c8ee','tempest-typeshare-type-1037834668',1,NULL),('2026-02-01 15:14:57.001971','2026-02-01 15:14:57.061048','2026-02-01 15:14:58.474942','5102bb4b-5b06-4190-a68f-383fedb2118d','5102bb4b-5b06-4190-a68f-383fedb2118d','tempest-tempest-manila-1532936140',1,'description_updated'),('2026-02-01 15:13:50.026303',NULL,'2026-02-01 15:13:52.843467','5251b3fa-67c4-4bfd-9678-6fd5177858a2','5251b3fa-67c4-4bfd-9678-6fd5177858a2','tempest-typeshare-type-94924595',1,NULL),('2026-02-01 15:16:07.599396',NULL,'2026-02-01 15:16:11.381197','5334ac45-44fc-49d0-95bb-7c266db24118','5334ac45-44fc-49d0-95bb-7c266db24118','tempest-share-type-1585544296',1,NULL),('2026-02-01 15:13:50.246507',NULL,'2026-02-01 15:13:52.691098','58202eae-f486-4387-91ec-6e10ef49a758','58202eae-f486-4387-91ec-6e10ef49a758','tempest-typeshare-type-1617148171',1,NULL),('2026-02-01 15:16:52.072515',NULL,NULL,'False','5b0c2719-9cba-4adb-b36c-2f65cfd23a4c','tempest-typeshare-type-1952702819',1,NULL),('2026-02-01 15:14:51.363716',NULL,'2026-02-01 15:15:02.468681','5be82ae1-e71e-401f-ad61-a488ed8ce4ef','5be82ae1-e71e-401f-ad61-a488ed8ce4ef','tempest-tempest-manila-1313710542',0,NULL),('2026-02-01 15:14:17.524004',NULL,'2026-02-01 15:14:18.772415','5ee1bf8c-5d84-4070-a702-de9a90f5bb83','5ee1bf8c-5d84-4070-a702-de9a90f5bb83','tempest-unique_st_name-1719554787',1,NULL),('2026-02-01 15:20:20.545585',NULL,'2026-02-01 15:20:31.180408','6037d96d-f585-4197-9f61-6388033ebf82','6037d96d-f585-4197-9f61-6388033ebf82','tempest-typeshare-type-829914533',1,NULL),('2026-02-01 15:15:09.128019',NULL,'2026-02-01 15:15:24.439594','61d66fc8-1151-4700-8fe3-06f0671259ab','61d66fc8-1151-4700-8fe3-06f0671259ab','tempest-typeshare-type-587968198',1,NULL),('2026-02-01 15:19:47.342457',NULL,'2026-02-01 15:19:47.589292','622202e1-fb6f-4944-b42e-d858f44dabb8','622202e1-fb6f-4944-b42e-d858f44dabb8','tempest-support_any_az_share_type-2025238132',1,NULL),('2026-02-01 15:16:30.557587',NULL,'2026-02-01 15:16:38.704343','63d145b6-fb37-4811-991f-0edbfd2cd9ff','63d145b6-fb37-4811-991f-0edbfd2cd9ff','tempest-typeshare-type-1377000335',1,NULL),('2026-02-01 15:15:59.703960',NULL,'2026-02-01 15:16:11.639725','64010b88-05ad-4c28-a92b-293b13eb246e','64010b88-05ad-4c28-a92b-293b13eb246e','tempest-share-type-752819574',1,NULL),('2026-02-01 15:15:20.525449',NULL,'2026-02-01 15:15:23.282106','67df08c4-28cd-4b99-b5d2-99898a44dae9','67df08c4-28cd-4b99-b5d2-99898a44dae9','tempest-typeshare-type-831246797',1,NULL),('2026-02-01 15:21:02.173722',NULL,'2026-02-01 15:21:07.082787','69055d1a-5f0f-4fb0-ac86-7dce1ca47366','69055d1a-5f0f-4fb0-ac86-7dce1ca47366','tempest-typeshare-type-1512511564',1,NULL),('2026-02-01 15:14:33.801966',NULL,'2026-02-01 15:14:35.585140','6da05b34-2a71-4bd5-a814-4a664dfadb89','6da05b34-2a71-4bd5-a814-4a664dfadb89','tempest-typeshare-type-1024611400',1,NULL),('2026-02-01 15:16:39.923124',NULL,'2026-02-01 15:16:53.870038','6e184f8e-4cd9-43fc-856f-053e93d4bd03','6e184f8e-4cd9-43fc-856f-053e93d4bd03','tempest-share-type-1270708832',1,NULL),('2026-02-01 15:16:31.738455',NULL,'2026-02-01 15:16:54.293134','6e4527c7-6f92-4531-b150-fbe437acbc5f','6e4527c7-6f92-4531-b150-fbe437acbc5f','tempest-share-type-1556444760',1,NULL),('2026-02-01 15:15:21.470729',NULL,'2026-02-01 15:15:22.541097','6eeaf06b-52f1-4a12-a608-e3a6e7bc922f','6eeaf06b-52f1-4a12-a608-e3a6e7bc922f','tempest-typeshare-type-2071078959',1,NULL),('2026-02-01 15:15:12.614328',NULL,'2026-02-01 15:15:35.488422','70f1e3e3-1df6-4e6a-972a-e4316600cd5d','70f1e3e3-1df6-4e6a-972a-e4316600cd5d','tempest-typeshare-type-1696413997',1,NULL),('2026-02-01 15:14:23.594621',NULL,'2026-02-01 15:15:16.810479','71a8cb03-a879-4fa1-9570-d4a2c3127be2','71a8cb03-a879-4fa1-9570-d4a2c3127be2','tempest-typeshare-type-401049861',1,NULL),('2026-02-01 15:19:45.150801',NULL,'2026-02-01 15:19:45.634948','7329db41-e32e-48c0-8a34-5b0bd93f1977','7329db41-e32e-48c0-8a34-5b0bd93f1977','tempest-support_some_azs_share_type-668973918',1,NULL),('2026-02-01 15:13:47.788692',NULL,'2026-02-01 15:13:53.132511','734285b9-f3eb-45ec-8320-81fb330cd709','734285b9-f3eb-45ec-8320-81fb330cd709','tempest-typeshare-type-648651975',1,NULL),('2026-02-01 15:20:31.946457',NULL,'2026-02-01 15:20:34.282696','73f9faad-1d01-48c5-880a-7299eb2691e8','73f9faad-1d01-48c5-880a-7299eb2691e8','tempest-typeshare-type-1338842654',1,NULL),('2026-02-01 15:15:19.045259',NULL,'2026-02-01 15:15:24.509839','75769a27-9e52-4ab0-8c71-09d962214422','75769a27-9e52-4ab0-8c71-09d962214422','tempest-typeshare-type-1797677361',1,NULL),('2026-02-01 15:18:28.194595',NULL,'2026-02-01 15:18:30.246482','7627787b-66e7-4152-84ee-791b30d18969','7627787b-66e7-4152-84ee-791b30d18969','tempest-typeshare-type-627827388',1,NULL),('2026-02-01 15:15:18.916479',NULL,'2026-02-01 15:15:24.721077','77b6aa2b-04cb-459e-b2e7-f4e48701d63b','77b6aa2b-04cb-459e-b2e7-f4e48701d63b','tempest-typeshare-type-1484263785',1,NULL),('2026-02-01 15:13:51.642162',NULL,'2026-02-01 15:13:52.171741','780716bb-d65d-40d7-b251-6ba94b4fec21','780716bb-d65d-40d7-b251-6ba94b4fec21','tempest-typeshare-type-722959777',1,NULL),('2026-02-01 15:13:07.533417',NULL,'2026-02-01 15:13:19.221815','7c625ff0-e084-42b2-8f17-359cee73602b','7c625ff0-e084-42b2-8f17-359cee73602b','tempest-typeshare-type-1004991048',1,NULL),('2026-02-01 15:14:57.119573','2026-02-01 15:14:57.212818','2026-02-01 15:14:58.285928','7e0bfba0-23c2-482e-b780-8af1d254cb94','7e0bfba0-23c2-482e-b780-8af1d254cb94','tempest-tempest-manila-496998361',1,'Description for share type'),('2026-02-01 15:15:29.917491',NULL,'2026-02-01 15:15:33.021201','7ebc3690-bdc3-45a9-9125-20512e7e9ed0','7ebc3690-bdc3-45a9-9125-20512e7e9ed0','tempest-share-type-992637253',1,NULL),('2026-02-01 15:13:36.716162',NULL,'2026-02-01 15:14:10.874184','7f348200-99b9-44a8-a2c6-6a72a85cdd23','7f348200-99b9-44a8-a2c6-6a72a85cdd23','tempest-typeshare-type-2117954717',1,NULL),('2026-02-01 15:15:20.093866',NULL,'2026-02-01 15:15:23.836763','7ffb87f0-72ec-4e28-bb1e-a719cce2b10c','7ffb87f0-72ec-4e28-bb1e-a719cce2b10c','tempest-typeshare-type-824060161',1,NULL),('2026-02-01 15:18:19.897784',NULL,'2026-02-01 15:19:47.148912','83bac904-ede0-4c77-b192-b7b619e38cb3','83bac904-ede0-4c77-b192-b7b619e38cb3','tempest-typeshare-type-255086181',1,NULL),('2026-02-01 15:15:35.041638',NULL,'2026-02-01 15:16:43.670421','847063aa-e54d-49d1-b390-6611881b6691','847063aa-e54d-49d1-b390-6611881b6691','tempest-typeshare-type-2038659222',1,NULL),('2026-02-01 15:15:21.215413',NULL,'2026-02-01 15:15:22.683785','84dee859-d956-4264-8de3-706083935bab','84dee859-d956-4264-8de3-706083935bab','tempest-typeshare-type-1326207152',1,NULL),('2026-02-01 15:15:40.087938',NULL,'2026-02-01 15:15:42.863074','8960c663-396a-4ed5-be7f-868d73c7db69','8960c663-396a-4ed5-be7f-868d73c7db69','tempest-typeshare-type-1220044275',1,NULL),('2026-02-01 15:15:18.033026',NULL,'2026-02-01 15:15:25.993859','8ad071e8-6e20-4a9d-86c4-b4a3212b6763','8ad071e8-6e20-4a9d-86c4-b4a3212b6763','tempest-typeshare-type-2053012864',1,NULL),('2026-02-01 15:14:03.903355',NULL,'2026-02-01 15:14:12.261135','8c72e4a5-abce-45c1-bd37-67b1570e670b','8c72e4a5-abce-45c1-bd37-67b1570e670b','tempest-typeshare-type-815028694',1,NULL),('2026-02-01 15:14:56.600293','2026-02-01 15:14:56.824935','2026-02-01 15:14:58.823325','8faa07fc-c6fb-43b3-85f6-4af46c0c7961','8faa07fc-c6fb-43b3-85f6-4af46c0c7961','tempest-type_updated-1092130404',1,'description_updated'),('2026-02-01 15:17:12.333764',NULL,'2026-02-01 15:17:12.500204','90a94627-0849-434c-97e8-7e492740e03a','90a94627-0849-434c-97e8-7e492740e03a','tempest-support_any_az_share_type-1406746040',1,NULL),('2026-02-01 15:13:52.824706',NULL,'2026-02-01 15:14:10.576220','9114c675-bbd4-440c-9a05-4ed1fac81a44','9114c675-bbd4-440c-9a05-4ed1fac81a44','tempest-typeshare-type-1307850390',1,NULL),('2026-02-01 15:19:45.272844',NULL,'2026-02-01 15:19:45.460494','912a6610-a30f-4a83-80dc-68dda4198959','912a6610-a30f-4a83-80dc-68dda4198959','tempest-support_any_az_share_type-775454397',1,NULL),('2026-02-01 15:17:11.695053',NULL,'2026-02-01 15:17:13.847186','9132f50b-18b6-4026-aa0a-09214a0bba42','9132f50b-18b6-4026-aa0a-09214a0bba42','tempest-typeshare-type-1977630828',1,NULL),('2026-02-01 15:20:32.042823',NULL,'2026-02-01 15:20:34.087600','91657f68-a2eb-496a-ab0c-6f87c9b2acef','91657f68-a2eb-496a-ab0c-6f87c9b2acef','tempest-typeshare-type-133868346',1,NULL),('2026-02-01 15:14:54.110571',NULL,'2026-02-01 15:15:01.422033','928a00d6-4469-4ab5-b68b-74423fc4b40a','928a00d6-4469-4ab5-b68b-74423fc4b40a','tempest-tempest-manila-2018020696',1,NULL),('2026-02-01 15:13:47.534919',NULL,'2026-02-01 15:13:53.545651','92a79f60-629b-4ad8-85a7-4f43c6b3b252','92a79f60-629b-4ad8-85a7-4f43c6b3b252','tempest-typeshare-type-1308163595',1,NULL),('2026-02-01 15:14:53.096478',NULL,'2026-02-01 15:15:02.182740','94357dfa-46c5-44ee-9654-159535895471','94357dfa-46c5-44ee-9654-159535895471','tempest-tempest-manila-1349290729',1,NULL),('2026-02-01 15:17:22.531226',NULL,'2026-02-01 15:18:18.557843','9438b119-75d0-4d28-9efc-827b70bc86e1','9438b119-75d0-4d28-9efc-827b70bc86e1','tempest-typeshare-type-1743583969',1,NULL),('2026-02-01 15:14:55.911288','2026-02-01 15:14:56.009773','2026-02-01 15:14:59.703437','95bf4bc4-77b5-462d-b3b2-8b8d3a4866ff','95bf4bc4-77b5-462d-b3b2-8b8d3a4866ff','tempest-type_updated-401293797',1,'Description for share type'),('2026-02-01 15:19:46.550545',NULL,'2026-02-01 15:19:46.730626','9b59b39a-6667-4f06-8229-415a9d1479f0','9b59b39a-6667-4f06-8229-415a9d1479f0','tempest-support_any_az_share_type-884708607',1,NULL),('2026-02-01 15:15:20.385865',NULL,'2026-02-01 15:15:23.492574','9e7649e8-c935-4946-a01c-1aa89e254197','9e7649e8-c935-4946-a01c-1aa89e254197','tempest-typeshare-type-1140856834',1,NULL),('2026-02-01 15:13:36.393299',NULL,'2026-02-01 15:14:11.292499','9e805c93-4b57-4421-a159-7bc8b285c972','9e805c93-4b57-4421-a159-7bc8b285c972','tempest-typeshare-type-931462242',1,NULL),('2026-02-01 15:17:21.561178',NULL,'2026-02-01 15:18:11.164124','9e8345c3-c425-444a-948b-e657e9fcd15d','9e8345c3-c425-444a-948b-e657e9fcd15d','tempest-typeshare-type-879397560',1,NULL),('2026-02-01 15:13:53.981300',NULL,'2026-02-01 15:14:10.459250','9e90c581-8d78-460e-b301-defa031060ec','9e90c581-8d78-460e-b301-defa031060ec','tempest-typeshare-type-1019214413',0,NULL),('2026-02-01 15:14:54.830555',NULL,'2026-02-01 15:15:00.882009','a22b96ae-6f86-4e38-a404-3de6e1cc01f1','a22b96ae-6f86-4e38-a404-3de6e1cc01f1','tempest-tempest-manila-756244170',1,'Description for share type'),('2026-02-01 15:13:07.994254',NULL,'2026-02-01 15:13:24.018732','a36752ae-228c-4fa4-8961-f141e5222f47','a36752ae-228c-4fa4-8961-f141e5222f47','tempest-typeshare-type-199760695',1,NULL),('2026-02-01 15:13:55.857591',NULL,'2026-02-01 15:14:10.244968','a3b7beff-4595-4850-98fa-669e777a38c9','a3b7beff-4595-4850-98fa-669e777a38c9','tempest-typeshare-type-342383530',1,NULL),('2026-02-01 15:19:48.281396',NULL,'2026-02-01 15:19:48.437519','a5f1a1f5-23b4-4794-9a4f-bc3f00fc95b6','a5f1a1f5-23b4-4794-9a4f-bc3f00fc95b6','tempest-support_any_az_share_type-1027105288',1,NULL),('2026-02-01 15:15:42.868537',NULL,'2026-02-01 15:16:50.224146','a811e5d0-f6d5-4017-bb5f-544fc27e7e76','a811e5d0-f6d5-4017-bb5f-544fc27e7e76','tempest-typeshare-type-599721795',1,NULL),('2026-02-01 15:14:55.568497',NULL,'2026-02-01 15:15:00.075655','a841d750-30ea-4dcb-b2a4-b52094a9a805','a841d750-30ea-4dcb-b2a4-b52094a9a805','tempest-tempest-manila-1058475896',1,NULL),('2026-02-01 15:13:46.305130',NULL,'2026-02-01 15:13:53.937955','aaf012e0-c2f8-4b70-a69a-205e9c8f38b3','aaf012e0-c2f8-4b70-a69a-205e9c8f38b3','tempest-typeshare-type-70532483',1,NULL),('2026-02-01 15:15:20.266121',NULL,'2026-02-01 15:15:23.681827','abb0d653-681f-4bee-a4e2-9ab279a140de','abb0d653-681f-4bee-a4e2-9ab279a140de','tempest-typeshare-type-2108948466',1,NULL),('2026-02-01 15:16:44.207945',NULL,'2026-02-01 15:16:53.550044','aceeeaf5-0220-422f-ad4e-febda069bdd9','aceeeaf5-0220-422f-ad4e-febda069bdd9','tempest-share-type-1460591298',1,NULL),('2026-02-01 15:15:19.792430',NULL,'2026-02-01 15:15:23.990649','ad66fc70-0367-4ade-99ba-a30a06bb221a','ad66fc70-0367-4ade-99ba-a30a06bb221a','tempest-typeshare-type-1545416923',1,NULL),('2026-02-01 15:15:32.016610',NULL,'2026-02-01 15:15:32.341781','ae15e194-06ca-44da-84f3-1c57b2f9dbaf','ae15e194-06ca-44da-84f3-1c57b2f9dbaf','tempest-share-type-1790744903',1,NULL),('2026-02-01 15:14:18.275008',NULL,'2026-02-01 15:14:26.038982','ae5ac208-d3f1-42e4-bd31-25e0fbedb1a8','ae5ac208-d3f1-42e4-bd31-25e0fbedb1a8','tempest-typeshare-type-316178573',1,NULL),('2026-02-01 15:14:17.135818',NULL,'2026-02-01 15:14:19.072949','af24cf60-0064-4452-81de-0bed9195a94c','af24cf60-0064-4452-81de-0bed9195a94c','tempest-typeshare-type-1376852555',1,NULL),('2026-02-01 15:15:10.501768',NULL,'2026-02-01 15:15:11.031993','afdd42a0-59d7-41ee-98b2-9f82eaa2a893','afdd42a0-59d7-41ee-98b2-9f82eaa2a893','tempest-share-type-581834581',1,NULL),('2026-02-01 15:13:44.979490',NULL,'2026-02-01 15:13:53.389337','b107dc0b-a3d2-4667-a455-9555f6c00178','b107dc0b-a3d2-4667-a455-9555f6c00178','tempest-typeshare-type-549758129',1,NULL),('2026-02-01 15:13:34.092063',NULL,'2026-02-01 15:14:05.234016','b1712ae3-d38a-4543-bf30-4854aff75f83','b1712ae3-d38a-4543-bf30-4854aff75f83','tempest-typeshare-type-767231557',1,NULL),('2026-02-01 15:14:56.429802','2026-02-01 15:14:56.509530','2026-02-01 15:14:59.001709','b19c92d2-a477-49ce-8357-5dcb4397c4a9','b19c92d2-a477-49ce-8357-5dcb4397c4a9','tempest-tempest-manila-1199651157',0,'Description for share type'),('2026-02-01 15:15:18.308197',NULL,'2026-02-01 15:15:25.503848','b2da4eab-d771-4044-92d2-3b2cbfcb9179','b2da4eab-d771-4044-92d2-3b2cbfcb9179','tempest-typeshare-type-1644244335',1,NULL),('2026-02-01 15:15:17.592070',NULL,'2026-02-01 15:15:26.506369','b515061e-9329-44d6-81c0-997abdf67302','b515061e-9329-44d6-81c0-997abdf67302','tempest-typeshare-type-1916529005',1,NULL),('2026-02-01 15:22:04.712929',NULL,'2026-02-01 15:22:20.482529','b601a256-782e-4c57-86e2-e39b6a70a570','b601a256-782e-4c57-86e2-e39b6a70a570','tempest-typeshare-type-129080098',1,NULL),('2026-02-01 15:15:17.727706',NULL,'2026-02-01 15:15:26.323451','b61a3898-9d53-410e-ae08-2904b76a2523','b61a3898-9d53-410e-ae08-2904b76a2523','tempest-typeshare-type-89707163',1,NULL),('2026-02-01 15:19:56.000132',NULL,'2026-02-01 15:20:48.164706','b9d443de-3e6e-4a4a-a894-066b97905353','b9d443de-3e6e-4a4a-a894-066b97905353','tempest-typeshare-type-1083375413',1,NULL),('2026-02-01 15:16:03.256744',NULL,'2026-02-01 15:16:11.516809','bb53296f-97b7-42cf-8d24-8b3c547491c9','bb53296f-97b7-42cf-8d24-8b3c547491c9','tempest-share-type-1095879278',1,NULL),('2026-02-01 15:14:39.373756',NULL,'2026-02-01 15:15:02.544966','c056af43-2681-4a32-98f6-e60c1f1a3560','c056af43-2681-4a32-98f6-e60c1f1a3560','tempest-typeshare-type-839188571',1,NULL),('2026-02-01 15:18:26.006496',NULL,'2026-02-01 15:18:54.931807','c2e98db5-6825-4e4c-8366-569c74530e00','c2e98db5-6825-4e4c-8366-569c74530e00','tempest-typeshare-type-756098931',1,NULL),('2026-02-01 15:15:21.823718',NULL,'2026-02-01 15:15:22.385991','c5bcfd6b-0cad-40fb-b780-810ccb506431','c5bcfd6b-0cad-40fb-b780-810ccb506431','tempest-typeshare-type-694065889',1,NULL),('2026-02-01 15:14:53.636231',NULL,'2026-02-01 15:15:01.868354','c947f15f-1e63-4f76-8049-c26a8bf4ac90','c947f15f-1e63-4f76-8049-c26a8bf4ac90','tempest-tempest-manila-835226287',1,NULL),('2026-02-01 15:17:03.983563',NULL,'2026-02-01 15:17:05.254378','cce11e56-2a3a-44e1-bdff-c22593bfec7f','cce11e56-2a3a-44e1-bdff-c22593bfec7f','tempest-typeshare-type-181798303',1,NULL),('2026-02-01 15:15:17.245545',NULL,'2026-02-01 15:15:26.679746','d10e3efc-0c4e-4c0d-8107-efedbb1c3f82','d10e3efc-0c4e-4c0d-8107-efedbb1c3f82','tempest-typeshare-type-178257430',1,NULL),('2026-02-01 15:13:05.494068',NULL,'2026-02-01 15:14:24.306017','d12a5a5d-639b-477e-9123-330697ff0216','d12a5a5d-639b-477e-9123-330697ff0216','tempest-typeshare-type-1665212584',1,NULL),('2026-02-01 15:21:16.545703',NULL,'2026-02-01 15:21:19.746777','d200f3e2-8cbd-4606-a4fe-7659c962190d','d200f3e2-8cbd-4606-a4fe-7659c962190d','tempest-typeshare-type-848453599',1,NULL),('2026-02-01 15:15:40.567216',NULL,'2026-02-01 15:16:12.387102','d3a796c1-974d-4d4f-86d6-31e24af5bf80','d3a796c1-974d-4d4f-86d6-31e24af5bf80','tempest-share-type-531311425',1,NULL),('2026-02-01 15:14:54.495717',NULL,'2026-02-01 15:15:01.258064','d3e470a5-d3dc-40e4-b692-19f3cbf94f39','d3e470a5-d3dc-40e4-b692-19f3cbf94f39','tempest-tempest-manila-1359728096',1,NULL),('2026-02-01 15:15:36.689063',NULL,'2026-02-01 15:16:12.606917','d3e4a564-7be4-42a0-848e-6cd396381438','d3e4a564-7be4-42a0-848e-6cd396381438','tempest-share-type-243207528',1,NULL),('2026-02-01 15:15:18.638323',NULL,'2026-02-01 15:15:25.213864','d4249ab8-1001-4d54-a931-b4081090d406','d4249ab8-1001-4d54-a931-b4081090d406','tempest-typeshare-type-1234970117',1,NULL),('2026-02-01 15:15:21.020314',NULL,'2026-02-01 15:15:22.852363','d4fdef2a-18da-4b1d-b285-ee4fd466bf2b','d4fdef2a-18da-4b1d-b285-ee4fd466bf2b','tempest-typeshare-type-1707541273',1,NULL),('2026-02-01 15:15:48.580670',NULL,'2026-02-01 15:16:12.058300','d66ef10c-1a48-4389-a804-c7ab5e8f314d','d66ef10c-1a48-4389-a804-c7ab5e8f314d','tempest-share-type-2027691218',1,NULL),('2026-02-01 15:19:44.642619',NULL,'2026-02-01 15:19:44.829901','d83171f4-dece-4e6f-94da-79a52afc657a','d83171f4-dece-4e6f-94da-79a52afc657a','tempest-support_any_az_share_type-2068718364',1,NULL),('2026-02-01 15:14:47.263736',NULL,'2026-02-01 15:15:06.404423','d8cb87c7-b9fa-4c1f-978a-61b318980e99','d8cb87c7-b9fa-4c1f-978a-61b318980e99','tempest-share-type-400041048',1,NULL),('2026-02-01 15:21:26.983682',NULL,'2026-02-01 15:21:29.065705','de8c64d4-fdd3-48ca-b3d2-7a08bfffb8b7','de8c64d4-fdd3-48ca-b3d2-7a08bfffb8b7','tempest-typeshare-type-1360625559',1,NULL),('2026-02-01 15:18:38.716524',NULL,'2026-02-01 15:18:54.968806','deaa419b-0383-4513-8c9a-24b9d74cd8e2','deaa419b-0383-4513-8c9a-24b9d74cd8e2','tempest-typeshare-type-2117819638',1,NULL),('2026-02-01 15:19:47.258944',NULL,'2026-02-01 15:19:47.934969','e0b57567-68f1-41a2-b532-96b28da2b2d1','e0b57567-68f1-41a2-b532-96b28da2b2d1','tempest-support_some_azs_share_type-561410637',1,NULL),('2026-02-01 15:15:41.366217',NULL,'2026-02-01 15:15:42.430099','e347d6b4-c1b5-49c7-a80a-4a750eb6a430','e347d6b4-c1b5-49c7-a80a-4a750eb6a430','tempest-typeshare-type-487993501',1,NULL),('2026-02-01 15:14:17.823293',NULL,'2026-02-01 15:14:18.455472','e363664a-c7a8-4f52-b283-a3895d8359bc','e363664a-c7a8-4f52-b283-a3895d8359bc','tempest-unique_st_name-314183124',1,NULL),('2026-02-01 15:14:57.637486','2026-02-01 15:14:57.713249','2026-02-01 15:14:57.806977','e3a25134-f57d-4cb8-a888-bb8a94edd416','e3a25134-f57d-4cb8-a888-bb8a94edd416','tempest-tempest-manila-1247865443',1,NULL),('2026-02-01 15:15:32.261263',NULL,'2026-02-01 15:16:12.757044','e40bf1b4-fd26-4fd8-95d0-210613d1d862','e40bf1b4-fd26-4fd8-95d0-210613d1d862','tempest-share-type-321838506',1,NULL),('2026-02-01 15:19:42.777511',NULL,'2026-02-01 15:20:24.485710','e6371ab2-3a9c-4858-bc71-54efe991623a','e6371ab2-3a9c-4858-bc71-54efe991623a','tempest-typeshare-type-355836218',1,NULL),('2026-02-01 15:15:30.915503',NULL,'2026-02-01 15:15:32.700516','e73e4286-1595-45f5-b12b-a1b75672c6d6','e73e4286-1595-45f5-b12b-a1b75672c6d6','tempest-share-type-305778718',1,NULL),('2026-02-01 15:13:50.442613',NULL,'2026-02-01 15:13:52.516648','e81125d5-c450-4c01-a64e-7b4710fa9ad4','e81125d5-c450-4c01-a64e-7b4710fa9ad4','tempest-typeshare-type-364733313',1,NULL),('2026-02-01 15:14:34.672450',NULL,'2026-02-01 15:14:35.003315','e87841f0-a681-4b67-aeff-7b66b8dbf3ee','e87841f0-a681-4b67-aeff-7b66b8dbf3ee','tempest-tempest-manila-978614936',1,NULL),('2026-02-01 15:13:36.822312',NULL,'2026-02-01 15:14:10.718247','e90f5e35-a2e5-4b1f-b6c6-9946da8a57e6','e90f5e35-a2e5-4b1f-b6c6-9946da8a57e6','tempest-typeshare-type-1932644882',1,NULL),('2026-02-01 15:14:54.970452',NULL,'2026-02-01 15:15:00.578296','e96993d4-c2e7-4424-896b-ecae96db44fd','e96993d4-c2e7-4424-896b-ecae96db44fd','tempest-tempest-manila-1819221763',1,NULL),('2026-02-01 15:14:16.983940',NULL,'2026-02-01 15:14:19.291199','f0e2884e-b874-4e86-b543-2ca7a5d2386f','f0e2884e-b874-4e86-b543-2ca7a5d2386f','tempest-typeshare-type-1777224362',1,NULL),('2026-02-01 15:19:48.194805',NULL,'2026-02-01 15:19:48.629329','f2d39541-1971-476c-a7c9-2bc4af497c9f','f2d39541-1971-476c-a7c9-2bc4af497c9f','tempest-support_some_azs_share_type-1073477696',1,NULL),('2026-02-01 15:14:55.216605',NULL,'2026-02-01 15:15:00.336361','f3a426cb-7429-476b-b4b3-783c3248df21','f3a426cb-7429-476b-b4b3-783c3248df21','tempest-tempest-manila-285557184',1,NULL),('2026-02-01 15:14:55.392962',NULL,'2026-02-01 15:15:04.067181','f6afe9eb-b901-4be4-a89a-bc6dc1369ca5','f6afe9eb-b901-4be4-a89a-bc6dc1369ca5','tempest-typeshare-type-1435215020',1,NULL),('2026-02-01 15:16:58.879777',NULL,'2026-02-01 15:18:12.269003','f74f4e50-b67a-4dd2-8817-d029903f2283','f74f4e50-b67a-4dd2-8817-d029903f2283','tempest-typeshare-type-431822547',1,NULL),('2026-02-01 15:14:53.444066',NULL,'2026-02-01 15:15:02.048754','fe617d3e-e4df-4d41-8ba1-b8f82c221d70','fe617d3e-e4df-4d41-8ba1-b8f82c221d70','tempest-tempest-manila-951519667',1,NULL);
/*!40000 ALTER TABLE `share_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shares`
--

DROP TABLE IF EXISTS `shares`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `shares` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `share_proto` varchar(255) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `snapshot_support` tinyint(1) DEFAULT NULL,
  `share_group_id` varchar(36) DEFAULT NULL,
  `source_share_group_snapshot_member_id` varchar(36) DEFAULT NULL,
  `task_state` varchar(255) DEFAULT NULL,
  `replication_type` varchar(255) DEFAULT NULL,
  `create_share_from_snapshot_support` tinyint(1) DEFAULT NULL,
  `revert_to_snapshot_support` tinyint(1) DEFAULT NULL,
  `mount_snapshot_support` tinyint(1) DEFAULT NULL,
  `is_soft_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `scheduled_to_be_deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_shares_share_group_id` (`share_group_id`),
  CONSTRAINT `fk_shares_share_group_id` FOREIGN KEY (`share_group_id`) REFERENCES `share_groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shares`
--

LOCK TABLES `shares` WRITE;
/*!40000 ALTER TABLE `shares` DISABLE KEYS */;
INSERT INTO `shares` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `size`, `display_name`, `display_description`, `snapshot_id`, `share_proto`, `is_public`, `snapshot_support`, `share_group_id`, `source_share_group_snapshot_member_id`, `task_state`, `replication_type`, `create_share_from_snapshot_support`, `revert_to_snapshot_support`, `mount_snapshot_support`, `is_soft_deleted`, `scheduled_to_be_deleted_at`) VALUES ('2026-02-01 15:17:22.708985','2026-02-01 15:18:15.399584','2026-02-01 15:18:15.399208','02ed6534-95a8-4e9b-9349-6e1c0bb2c8e7','02ed6534-95a8-4e9b-9349-6e1c0bb2c8e7','3cf00994b85e4b779e6717ae76e983b5','368b363545bf449ebeb73c7917747ead',1,'tempest-tempest-share-name-350224895','tempest-tempest-share-description-243053164',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:20:09.025830','2026-02-01 15:20:12.930056','2026-02-01 15:20:12.929474','06eb3108-1fb0-4cc9-802d-0d29a3e86c17','06eb3108-1fb0-4cc9-802d-0d29a3e86c17','f69502b1cbbe4323a4b071a11a697d10','82efdf20300f4ffda9822c66d6f66684',1,'tempest-tempest-created-share-2055250075','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:13:07.676699','2026-02-01 15:13:15.796602','2026-02-01 15:13:15.795923','074f8578-066c-49d2-bdfd-7a203d4617b0','074f8578-066c-49d2-bdfd-7a203d4617b0','e19059c3227c4ea5b508cf825c284a38','7d7793c430934c04a024af92c3ca805f',1,'tempest-tempest-created-share-1929754767','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:14:50.904367','2026-02-01 15:14:56.498723','2026-02-01 15:14:56.498285','084ea16f-5b60-466f-bd43-c7d8b9a9002f','084ea16f-5b60-466f-bd43-c7d8b9a9002f','928da2f6147a4b708835fcbebf483d8a','8148327cebed4bb49e576111ce3edff1',1,'tempest-tempest-created-share-1411606045','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:16:30.775954','2026-02-01 15:16:35.650394','2026-02-01 15:16:35.649947','0aaab4f5-8dee-46a6-8e16-748176e8927c','0aaab4f5-8dee-46a6-8e16-748176e8927c','9143810fbee74a7799490ac3fc1032dd','c12690bcab10459c81103ff11e371488',1,'public_share','public_share_desc',NULL,'CEPHFS',1,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:18:40.578653','2026-02-01 15:18:51.781191','2026-02-01 15:18:51.780838','0c5173b4-0251-4eb2-9e82-b1a7644830aa','0c5173b4-0251-4eb2-9e82-b1a7644830aa','24edeab99fbb48d7b16cdeb517c6a575','5d1e833d258140798bbddb15095488d9',1,'tempest-tempest-created-share-212909844','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-02-01 15:13:06.764795','2026-02-01 15:14:21.245279','2026-02-01 15:14:21.244953','0d466b60-2648-465b-aef7-5ba809864391','0d466b60-2648-465b-aef7-5ba809864391','435a807314d045b7b6183b8871d538b0','fda4ab42f467487d8e5d3007a76e3476',1,'tempest-tempest-created-share-905225522','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:14:43.605799','2026-02-01 15:14:47.832621','2026-02-01 15:14:47.832252','0dec4fa2-3ef7-4e76-aaab-2fd7ae13dd52','0dec4fa2-3ef7-4e76-aaab-2fd7ae13dd52','928da2f6147a4b708835fcbebf483d8a','8148327cebed4bb49e576111ce3edff1',1,'tempest-tempest-created-share-1986742747','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:15:57.576698','2026-02-01 15:16:04.956668','2026-02-01 15:16:04.956252','11fe694e-7f17-4b41-ba35-c9228ad1576c','11fe694e-7f17-4b41-ba35-c9228ad1576c','e9e626045c924c8c981ad3f67a1dedd6','f99925486e924480b84b05e1433af949',1,'tempest-tempest-created-share-1936585624','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:13:38.598902','2026-02-01 15:13:58.209555','2026-02-01 15:13:58.209250','1215de86-6ef2-4d6a-8dcb-b2bcf82846c1','1215de86-6ef2-4d6a-8dcb-b2bcf82846c1','2bbd6a9be41643a38007238edf9638fe','fc17e54c678d41c68e219a1686c0fe7d',1,'tempest-tempest-created-share-10899043','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:14:27.275370','2026-02-01 15:14:32.082891','2026-02-01 15:14:32.082447','14a2235d-24be-4744-8e29-d36fdcb47054','14a2235d-24be-4744-8e29-d36fdcb47054','928da2f6147a4b708835fcbebf483d8a','8148327cebed4bb49e576111ce3edff1',1,'tempest-tempest-created-share-1493237225','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:17:41.331792','2026-02-01 15:17:45.896818','2026-02-01 15:17:45.896509','17e2b644-71c7-41fe-b778-caad6d93fe7c','17e2b644-71c7-41fe-b778-caad6d93fe7c','3cf00994b85e4b779e6717ae76e983b5','368b363545bf449ebeb73c7917747ead',2,'tempest-tempest-created-share-1624778544','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:15:35.229214','2026-02-01 15:16:40.690348','2026-02-01 15:16:40.689521','1dbc87f0-6d96-4be8-901e-294b9b434e06','1dbc87f0-6d96-4be8-901e-294b9b434e06','795592d89a1d46e4a844c4a238d332e3','e483891a9fd042d4a571a3d4655dc685',1,'tempest-tempest-created-share-1496180284','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:15:16.417506','2026-02-01 15:15:20.391230','2026-02-01 15:15:20.390763','21ab09e5-1ca2-4aa9-98cf-47edc7e15053','21ab09e5-1ca2-4aa9-98cf-47edc7e15053','2f14b61aac5c41f78a2c8a4963295b65','b60d48ce6ed84a0499e61efc92fe4ff7',1,'private_share','private share in the primary user project',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:17:48.356009','2026-02-01 15:18:00.141918','2026-02-01 15:18:00.141233','21db73d0-f6cc-4863-9c54-f1f6ce871fdd','21db73d0-f6cc-4863-9c54-f1f6ce871fdd','60095238b9444c4bbf425950ca283c97','5e1261fa63b348dd8c26883b016255c5',1,'tempest-tempest-created-share-1117194176','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:13:34.433934','2026-02-01 15:14:02.035937','2026-02-01 15:14:02.035219','2792af0f-47d9-4201-8534-b0c899e799a9','2792af0f-47d9-4201-8534-b0c899e799a9','2bbd6a9be41643a38007238edf9638fe','fc17e54c678d41c68e219a1686c0fe7d',1,'tempest-tempest-created-share-2055400919','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:19:02.582941','2026-02-01 15:19:09.944503','2026-02-01 15:19:09.944159','2c7b7476-d95d-47be-94e2-33f9a6d247d4','2c7b7476-d95d-47be-94e2-33f9a6d247d4','a6d2572f8b864e0793ea67a069edbe05','40dced376e0d4d23b2b7de2c3fc8bd0e',2,'tempest-tempest-created-share-1580601768','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-02-01 15:17:33.281188','2026-02-01 15:17:37.317257','2026-02-01 15:17:37.316818','2e25175d-3f59-4475-bdeb-25a4cd2f3111','2e25175d-3f59-4475-bdeb-25a4cd2f3111','3cf00994b85e4b779e6717ae76e983b5','368b363545bf449ebeb73c7917747ead',1,'tempest-tempest-created-share-1007800819','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:14:04.100644','2026-02-01 15:14:09.494534','2026-02-01 15:14:09.494021','30280d5d-84b1-484d-90ed-38b66bbbbbfc','30280d5d-84b1-484d-90ed-38b66bbbbbfc','d490148597b44e68bee9a9fe258ee233','999f6f2ae9a8410ca0b94eca9aa23d7a',1,'tempest-tempest-created-share-1073248561','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:16:14.151548','2026-02-01 15:16:29.904762','2026-02-01 15:16:29.904354','30ac0e47-abe2-4b5f-ba75-983911fa7443','30ac0e47-abe2-4b5f-ba75-983911fa7443','e513aa3b998a4d7c9d1e07492d61bda1','2731ddbed05046f3bee55c8f307163b2',1,'tempest-tempest-created-share-1407496085','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:13:10.697852','2026-02-01 15:13:16.213387','2026-02-01 15:13:16.213025','34e42d1e-d889-4ca6-b405-86e8c07778e3','34e42d1e-d889-4ca6-b405-86e8c07778e3','435a807314d045b7b6183b8871d538b0','fda4ab42f467487d8e5d3007a76e3476',2,'tempest-tempest-created-share-1604710367','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:16:59.102860','2026-02-01 15:17:10.150389','2026-02-01 15:17:10.150014','34f43339-6642-416c-b3cf-973a80d4f1af','34f43339-6642-416c-b3cf-973a80d4f1af','746730afb3db4d7f80045269f8973474','120c1822ab9548c2815485bc30d42a55',1,'tempest-tempest-created-share-423806143','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:18:26.253759','2026-02-01 15:18:37.392121','2026-02-01 15:18:37.391729','37fbd9e7-28ca-49bd-889e-a1db61e1ab39','37fbd9e7-28ca-49bd-889e-a1db61e1ab39','24edeab99fbb48d7b16cdeb517c6a575','5d1e833d258140798bbddb15095488d9',2,'tempest-tempest-created-share-1971121964','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-02-01 15:17:21.701514','2026-02-01 15:18:08.016613','2026-02-01 15:18:08.016301','39c6cc76-f1bc-40bb-ab96-c41894504a86','39c6cc76-f1bc-40bb-ab96-c41894504a86','746730afb3db4d7f80045269f8973474','120c1822ab9548c2815485bc30d42a55',1,'tempest-tempest-created-share-106609333','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-02-01 15:15:48.931129','2026-02-01 15:16:12.652361','2026-02-01 15:16:12.651936','3af5147f-2af3-4b2a-92e0-0a472ae560d9','3af5147f-2af3-4b2a-92e0-0a472ae560d9','c768e3f3500c4bf19dcf4fcf64856998','0d63dabe67144e93ab3137e7893f5f60',1,'tempest-tempest-share-name-2143122305','tempest-tempest-share-description-1289048694',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-02-01 15:15:59.826668','2026-02-01 15:16:07.466519','2026-02-01 15:16:07.466075','3c436459-63a6-4ad6-adc8-8a42a7ab847a','3c436459-63a6-4ad6-adc8-8a42a7ab847a','6f2dab9328424993aa458427358720d9','32087184504a4aabb8269aa5ef350c60',1,'tempest-tempest-created-share-1533593573','tempest-tempest-created-share-desc-723717592',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:16:07.751420','2026-02-01 15:16:11.259668','2026-02-01 15:16:11.258863','452a5ef1-9894-470d-a6d7-5122ea8f2101','452a5ef1-9894-470d-a6d7-5122ea8f2101','6f2dab9328424993aa458427358720d9','32087184504a4aabb8269aa5ef350c60',1,'tempest-tempest-created-share-437431040','tempest-tempest-created-share-desc-1203562114',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:16:07.814003','2026-02-01 15:16:15.867789','2026-02-01 15:16:15.867454','4c471ffa-1401-4eb7-bef0-5e4c93339d6a','4c471ffa-1401-4eb7-bef0-5e4c93339d6a','e9e626045c924c8c981ad3f67a1dedd6','f99925486e924480b84b05e1433af949',1,'tempest-tempest-created-share-1931708180','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:18:46.695816','2026-02-01 15:18:50.978484','2026-02-01 15:18:50.978031','4de7a064-1350-4ec3-b928-d924446e2825','4de7a064-1350-4ec3-b928-d924446e2825','f6d8ffe9f1a64b1693065611bbe19c67','7736a9c671f04e42b35558bfde737fc8',1,'tempest-tempest-share-name-1971151031','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:22:04.950677','2026-02-01 15:22:17.268026','2026-02-01 15:22:17.267372','57395ad9-8383-40ff-9646-5aea2c7edb82','57395ad9-8383-40ff-9646-5aea2c7edb82','bd6f5443e9144072bcf2104c071429b2','844f34f060ef46f0be5d950e48375eb5',1,'tempest-tempest-share-name-1505911667','tempest-tempest-share-description-2032253335',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-02-01 15:20:16.272289','2026-02-01 15:20:20.287379','2026-02-01 15:20:20.286933','5a3a6e00-42bf-4a75-8d4a-3812e97dd737','5a3a6e00-42bf-4a75-8d4a-3812e97dd737','f69502b1cbbe4323a4b071a11a697d10','82efdf20300f4ffda9822c66d6f66684',1,'tempest-tempest-created-share-2090955093','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:18:20.062173','2026-02-01 15:19:43.983357','2026-02-01 15:19:43.982941','6182d01b-245a-494b-bb81-378b267f898a','6182d01b-245a-494b-bb81-378b267f898a','a6d2572f8b864e0793ea67a069edbe05','40dced376e0d4d23b2b7de2c3fc8bd0e',1,'tempest-tempest-share-name-1573705066','tempest-tempest-share-description-987027782',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-02-01 15:19:03.482502','2026-02-01 15:19:31.262947','2026-02-01 15:19:31.262535','62d30550-2210-40f2-83b1-24b67cb16735','62d30550-2210-40f2-83b1-24b67cb16735','5a9e48d8005d427fa422911dd04f4938','754e5daaf01d4d8e91ba62e9ca89a38d',1,'tempest-tempest-share-name-481967310','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:15:36.801813','2026-02-01 15:15:40.472323','2026-02-01 15:15:40.472051','66030396-f1e3-4abe-a840-a120fdad9e5a','66030396-f1e3-4abe-a840-a120fdad9e5a','6f2dab9328424993aa458427358720d9','32087184504a4aabb8269aa5ef350c60',1,'tempest-tempest-created-share-758175648','tempest-tempest-created-share-desc-465905502',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:19:28.122336','2026-02-01 15:19:33.396367','2026-02-01 15:19:33.395990','6d3162f4-a7f0-42c5-8ae9-bcccd79571a2','6d3162f4-a7f0-42c5-8ae9-bcccd79571a2','a6d2572f8b864e0793ea67a069edbe05','40dced376e0d4d23b2b7de2c3fc8bd0e',1,'tempest-tempest-created-share-1633215661','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-02-01 15:15:52.069046','2026-02-01 15:15:59.319851','2026-02-01 15:15:59.318739','6f2a2b5c-0835-4de8-926c-dbdf461c7cd4','6f2a2b5c-0835-4de8-926c-dbdf461c7cd4','6f2dab9328424993aa458427358720d9','32087184504a4aabb8269aa5ef350c60',1,'tempest-tempest-created-share-678980865','tempest-tempest-created-share-desc-1414817914',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:15:27.424523','2026-02-01 15:15:31.862058','2026-02-01 15:15:31.861520','71ad0f8e-e1fc-419d-a459-ceb1763cd47c','71ad0f8e-e1fc-419d-a459-ceb1763cd47c','2f14b61aac5c41f78a2c8a4963295b65','b60d48ce6ed84a0499e61efc92fe4ff7',1,'tempest-tempest-new-share-name-1183432654','share is now updated',NULL,'CEPHFS',1,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:18:39.027838','2026-02-01 15:18:43.996806','2026-02-01 15:18:43.996212','7ffeeb4c-77d5-4378-af95-4e59e11fb3c3','7ffeeb4c-77d5-4378-af95-4e59e11fb3c3','b4519508f74d4e4bab6f8c3da6388d49','2c31b44d86274d9c9323bcb7f0a754dd',1,'tempest-tempest-share-name-1461275253','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:15:40.708193','2026-02-01 15:15:48.400040','2026-02-01 15:15:48.399372','80c6994e-ac3e-4df1-b8f0-3220a10b91d6','80c6994e-ac3e-4df1-b8f0-3220a10b91d6','6f2dab9328424993aa458427358720d9','32087184504a4aabb8269aa5ef350c60',1,'tempest-tempest-created-share-1868551548','tempest-tempest-created-share-desc-673924652',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:13:45.113447','2026-02-01 15:13:50.325382','2026-02-01 15:13:50.325086','83161a20-ce0c-4c83-aca6-ee7e0d66a73c','83161a20-ce0c-4c83-aca6-ee7e0d66a73c','6c7a6c983b3a451a96f18889cebd862d','c24c8bba1312447c8305abcf7b1ff259',1,'tempest-tempest-created-share-552659442','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:19:17.853311','2026-02-01 15:19:25.197233','2026-02-01 15:19:25.196816','84f79712-a38b-454b-ad14-8dea84f64d02','84f79712-a38b-454b-ad14-8dea84f64d02','a6d2572f8b864e0793ea67a069edbe05','40dced376e0d4d23b2b7de2c3fc8bd0e',1,'tempest-tempest-created-share-1567661929','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-02-01 15:15:55.432428','2026-02-01 15:15:59.010527','2026-02-01 15:15:59.009553','87bc00c7-ffd8-4d9c-a2b4-29c6bd5ddbd7','87bc00c7-ffd8-4d9c-a2b4-29c6bd5ddbd7','6f2dab9328424993aa458427358720d9','32087184504a4aabb8269aa5ef350c60',1,'tempest-tempest-created-share-1988680677','tempest-tempest-created-share-desc-263871233',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:16:49.031450','2026-02-01 15:16:52.852744','2026-02-01 15:16:52.852431','881bb209-1c46-4b4b-808a-d8660e3d8d46','881bb209-1c46-4b4b-808a-d8660e3d8d46','627361eeb4bc410fb28e040badc59d2c','d8619226901f4987807454d91d99af93',1,'tempest-tempest-created-share-1457464602','tempest-tempest-created-share-desc-509891371',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:19:15.580773','2026-02-01 15:19:20.682307','2026-02-01 15:19:20.681970','8f16715d-9b52-40a1-a5b4-5d4cfa9e7098','8f16715d-9b52-40a1-a5b4-5d4cfa9e7098','5a9e48d8005d427fa422911dd04f4938','754e5daaf01d4d8e91ba62e9ca89a38d',1,'tempest-tempest-share-name-1443735265','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:18:24.297840','2026-02-01 15:19:36.956900','2026-02-01 15:19:36.956467','8fe176c7-8bfa-4ff4-b4c4-d293c0ff505b','8fe176c7-8bfa-4ff4-b4c4-d293c0ff505b','a6d2572f8b864e0793ea67a069edbe05','40dced376e0d4d23b2b7de2c3fc8bd0e',1,'tempest-tempest-share-name-1533530041','tempest-tempest-share-description-1720214447','383b4f57-c12d-4143-bc64-f94b56aa4406','CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-02-01 15:16:35.933463','2026-02-01 15:16:39.773024','2026-02-01 15:16:39.772655','958ab4ab-f5aa-4908-a2a1-1363ed9f1ad6','958ab4ab-f5aa-4908-a2a1-1363ed9f1ad6','627361eeb4bc410fb28e040badc59d2c','d8619226901f4987807454d91d99af93',1,'tempest-tempest-created-share-135447681','tempest-tempest-created-share-desc-909533704',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:13:28.179051','2026-02-01 15:13:32.174734','2026-02-01 15:13:32.174228','95b00e29-de3a-4052-9491-e19c17654b49','95b00e29-de3a-4052-9491-e19c17654b49','435a807314d045b7b6183b8871d538b0','fda4ab42f467487d8e5d3007a76e3476',1,'tempest-tempest-created-share-1520157790','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:19:51.340091',NULL,NULL,'False','99096eba-8e8a-4266-a1a9-b11ede8cde3e','285a33e9d1bd42fb99f40147950702a7','7043f01f29d441a4801c5afbb65b54e3',1,'tempest-tempest-created-share-1819730267','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:19:11.485073','2026-02-01 15:19:24.278066','2026-02-01 15:19:24.277138','99eedc5a-b918-4040-a83b-96644a9ed910','99eedc5a-b918-4040-a83b-96644a9ed910','5a9e48d8005d427fa422911dd04f4938','754e5daaf01d4d8e91ba62e9ca89a38d',1,'tempest-tempest-share-name-2133269758','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:17:13.814098','2026-02-01 15:17:18.187157','2026-02-01 15:17:18.186606','9d558349-221a-4a98-8731-9363b32b3eae','9d558349-221a-4a98-8731-9363b32b3eae','746730afb3db4d7f80045269f8973474','120c1822ab9548c2815485bc30d42a55',1,'tempest-tempest-created-share-891470324','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:13:19.402145','2026-02-01 15:13:24.806922','2026-02-01 15:13:24.806528','9f36509b-0363-43b8-836a-6ffc90146bbe','9f36509b-0363-43b8-836a-6ffc90146bbe','435a807314d045b7b6183b8871d538b0','fda4ab42f467487d8e5d3007a76e3476',2,'tempest-tempest-created-share-2137532576','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:19:48.959891','2026-02-01 15:19:57.818492','2026-02-01 15:19:57.817783','a34da5d4-cbdc-49b1-af14-452229f21807','a34da5d4-cbdc-49b1-af14-452229f21807','f69502b1cbbe4323a4b071a11a697d10','82efdf20300f4ffda9822c66d6f66684',1,'tempest-tempest-created-share-2068191993','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:17:28.796620','2026-02-01 15:18:00.985326','2026-02-01 15:18:00.984803','a92fd102-7531-4d03-a3d1-67447454e228','a92fd102-7531-4d03-a3d1-67447454e228','746730afb3db4d7f80045269f8973474','120c1822ab9548c2815485bc30d42a55',1,'tempest-tempest-created-share-480176673','Tempest\'s share','c61fb956-cb54-4a69-b984-796f123291a0','CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-02-01 15:15:48.700316','2026-02-01 15:15:59.585861','2026-02-01 15:15:59.585411','ab8e28a4-0b20-4886-b306-34d342be02ae','ab8e28a4-0b20-4886-b306-34d342be02ae','6f2dab9328424993aa458427358720d9','32087184504a4aabb8269aa5ef350c60',1,'tempest-tempest-created-share-1439611341','tempest-tempest-created-share-desc-1980938013',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:17:55.996744','2026-02-01 15:18:00.268518','2026-02-01 15:18:00.268179','ae386790-d6fe-4af9-8ba5-295736474267','ae386790-d6fe-4af9-8ba5-295736474267','3cf00994b85e4b779e6717ae76e983b5','368b363545bf449ebeb73c7917747ead',1,'tempest-tempest-created-share-1377771605','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:21:39.470769','2026-02-01 15:21:51.723357','2026-02-01 15:21:51.722973','af4e3236-7c5d-4b62-9828-44f21ee7a89e','af4e3236-7c5d-4b62-9828-44f21ee7a89e','ea0ad1ffc7314e269b800f42e5e3fc3e','ebfaf803a1c84c12ac2c950d798c01a3',1,'tempest-tempest-new-name-552145885','tempest-tempest-new-description-1780185306',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:15:55.733672','2026-02-01 15:16:05.802556','2026-02-01 15:16:05.802252','afee7923-6ff7-4cad-905b-2c64c71cbc85','afee7923-6ff7-4cad-905b-2c64c71cbc85','c768e3f3500c4bf19dcf4fcf64856998','0d63dabe67144e93ab3137e7893f5f60',1,'tempest-tempest-share-name-1214357837','tempest-tempest-share-description-1754955945','09169dc3-0948-42ec-b7eb-9bb0391d7a50','CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-02-01 15:15:12.736452','2026-02-01 15:15:24.000686','2026-02-01 15:15:24.000307','b0b174d4-b800-499f-9f56-e082e24700da','b0b174d4-b800-499f-9f56-e082e24700da','6c83c28e021c4717b45ee6d416ec31f5','0dfd4148452647aa845013a982630bb0',1,'public_share - must be visible to all projects in the cloud','public_share_desc',NULL,'CEPHFS',1,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:15:43.098224','2026-02-01 15:16:46.677959','2026-02-01 15:16:46.677553','b468be17-5e14-4279-9c46-1b22b29f7b78','b468be17-5e14-4279-9c46-1b22b29f7b78','e9e626045c924c8c981ad3f67a1dedd6','f99925486e924480b84b05e1433af949',1,'tempest-tempest-created-share-1484441696','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:16:31.983851','2026-02-01 15:16:35.627832','2026-02-01 15:16:35.627449','b471dc19-2401-417a-96e5-e736bb147988','b471dc19-2401-417a-96e5-e736bb147988','627361eeb4bc410fb28e040badc59d2c','d8619226901f4987807454d91d99af93',1,'tempest-tempest-created-share-2092332547','tempest-tempest-created-share-desc-1293643866',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:14:47.393213','2026-02-01 15:15:03.187283','2026-02-01 15:15:03.186784','b7f5d04c-0b5a-47f1-8f38-9796f6e87234','b7f5d04c-0b5a-47f1-8f38-9796f6e87234','2c641459542741e59f6414cbb91ed187','b3c21deb7cba41feaff782713b1775e6',1,'tempest-share-1389367624','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:18:03.252486','2026-02-01 15:18:07.999212','2026-02-01 15:18:07.998565','b8fbce29-0056-4b4f-bd2c-8c8b27b374f7','b8fbce29-0056-4b4f-bd2c-8c8b27b374f7','3cf00994b85e4b779e6717ae76e983b5','368b363545bf449ebeb73c7917747ead',1,'tempest-tempest-created-share-1368396201','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:14:39.503959','2026-02-01 15:14:59.460280','2026-02-01 15:14:59.459701','b9e29865-8feb-4a35-b719-26ba10e308bf','b9e29865-8feb-4a35-b719-26ba10e308bf','26e3e1d8b04f4d09b6941b9eed4bed81','42d5324bd181499ca11dbc92c8e1556c',1,'tempest-tempest-created-share-523102037','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:17:49.121654','2026-02-01 15:17:52.814383','2026-02-01 15:17:52.813974','bfddc711-d955-4cc4-b66a-b9154e64b8b0','bfddc711-d955-4cc4-b66a-b9154e64b8b0','3cf00994b85e4b779e6717ae76e983b5','368b363545bf449ebeb73c7917747ead',1,'tempest-tempest-created-share-1823818761','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:15:01.205326','2026-02-01 15:15:07.589198','2026-02-01 15:15:07.588508','c2db2486-3b0e-428e-9fea-b8bdc0d4f5fd','c2db2486-3b0e-428e-9fea-b8bdc0d4f5fd','928da2f6147a4b708835fcbebf483d8a','8148327cebed4bb49e576111ce3edff1',1,'tempest-tempest-created-share-1854603206','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:15:09.407223','2026-02-01 15:15:21.208156','2026-02-01 15:15:21.207747','c33bbc3d-caeb-43d8-aff9-0eb1aca90ec2','c33bbc3d-caeb-43d8-aff9-0eb1aca90ec2','32efe54ffae74acfbb12e72ef8334608','46cbc131a820464a9b6cd0940829aea6',1,'tempest-tempest-created-share-2080518285','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:13:35.471614','2026-02-01 15:13:39.364593','2026-02-01 15:13:39.364232','c93a5e0e-945d-4c72-9ff0-c298f61ff8da','c93a5e0e-945d-4c72-9ff0-c298f61ff8da','435a807314d045b7b6183b8871d538b0','fda4ab42f467487d8e5d3007a76e3476',1,'tempest-tempest-created-share-1459654412','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:16:40.088238','2026-02-01 15:16:43.994428','2026-02-01 15:16:43.994069','d1b69db5-857a-4858-96bd-c44e33ddb3fa','d1b69db5-857a-4858-96bd-c44e33ddb3fa','627361eeb4bc410fb28e040badc59d2c','d8619226901f4987807454d91d99af93',1,'tempest-tempest-created-share-2123724283','tempest-tempest-created-share-desc-2017986782',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:16:03.350519','2026-02-01 15:16:07.140142','2026-02-01 15:16:07.139656','d582acbc-9c90-4db6-9e3a-b99aad568f88','d582acbc-9c90-4db6-9e3a-b99aad568f88','6f2dab9328424993aa458427358720d9','32087184504a4aabb8269aa5ef350c60',1,'tempest-tempest-created-share-414307457','tempest-tempest-created-share-desc-564749215',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:19:52.815132','2026-02-01 15:19:53.669206','2026-02-01 15:19:53.668271','dce671b3-e788-4d44-a3e9-ff4232d7271c','dce671b3-e788-4d44-a3e9-ff4232d7271c','f69502b1cbbe4323a4b071a11a697d10','82efdf20300f4ffda9822c66d6f66684',1,'tempest-tempest-created-share-1372368113','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:15:45.935145','2026-02-01 15:16:33.418191','2026-02-01 15:16:33.417691','dede97d8-5245-478c-a2ce-9bf99f2c6aa7','dede97d8-5245-478c-a2ce-9bf99f2c6aa7','e513aa3b998a4d7c9d1e07492d61bda1','2731ddbed05046f3bee55c8f307163b2',1,'tempest-tempest-created-share-933598401','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-02-01 15:19:56.392579','2026-02-01 15:20:44.903388','2026-02-01 15:20:44.902845','df1892ce-5021-49d0-8383-4875e362a7fa','df1892ce-5021-49d0-8383-4875e362a7fa','bf5d1db5b7fe40f0ab31649c9864bbbb','624202b32e62465ca01f75142b16617c',1,'tempest-tempest-share-name-1834810990','tempest-tempest-share-description-1343339171',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-02-01 15:15:39.012073','2026-02-01 15:16:37.004727','2026-02-01 15:16:37.004310','e2030234-5cbe-44da-863b-b58df4bd353b','e2030234-5cbe-44da-863b-b58df4bd353b','795592d89a1d46e4a844c4a238d332e3','e483891a9fd042d4a571a3d4655dc685',1,'tempest-tempest-created-share-2096659568','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-02-01 15:14:18.410949','2026-02-01 15:14:22.832777','2026-02-01 15:14:22.832358','e36b1e07-1312-4f93-901f-7cfad44e0ce1','e36b1e07-1312-4f93-901f-7cfad44e0ce1','52393b023cd64393a0b3cc33f7cf9b0f','be07a91869e4476fbc553f85525ca866',1,'tempest-tempest-created-share-1836097204','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:17:03.304718','2026-02-01 15:17:30.095621','2026-02-01 15:17:30.095256','e3c73f2d-99be-4ecb-991f-ef6fb7d37db1','e3c73f2d-99be-4ecb-991f-ef6fb7d37db1','78165cb2bbac42ca957ac7fa7010927e','557407533ddd4b83a57f3bf0896f77ac',1,'tempest-tempest-created-share-470786664','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:16:52.301562','2026-02-01 15:20:07.173709','2026-02-01 15:20:07.173248','e51ffba9-5f6c-4489-99fa-67b49bb7865e','e51ffba9-5f6c-4489-99fa-67b49bb7865e','465443f98ace4b989c787808b3cda30c','7043f01f29d441a4801c5afbb65b54e3',1,'tempest-tempest-created-share-1193770586','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:16:44.447984','2026-02-01 15:16:48.519407','2026-02-01 15:16:48.519036','e5786088-510e-4fe1-90e0-1b11281ce4ea','e5786088-510e-4fe1-90e0-1b11281ce4ea','627361eeb4bc410fb28e040badc59d2c','d8619226901f4987807454d91d99af93',1,'tempest-tempest-created-share-1801457875','tempest-tempest-created-share-desc-1916344448',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:13:41.462029','2026-02-01 15:13:48.899164','2026-02-01 15:13:48.898775','eaada3c9-76df-46bd-b05e-e97f16f97303','eaada3c9-76df-46bd-b05e-e97f16f97303','fbd576f00c6b445aadb79ba9a35844e4','b2e389a954404c1185b10157107ee036',3,'tempest-tempest-created-share-341903488','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:13:37.531664','2026-02-01 15:13:45.597119','2026-02-01 15:13:45.596607','eb44e8a1-f84a-4ad5-aae6-5d31a049a1ec','eb44e8a1-f84a-4ad5-aae6-5d31a049a1ec','fbd576f00c6b445aadb79ba9a35844e4','b2e389a954404c1185b10157107ee036',4,'tempest-tempest-created-share-763006529','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:14:55.595257','2026-02-01 15:15:00.921039','2026-02-01 15:15:00.920513','eb4de22a-fb3a-422e-a9da-34dc439f0abb','eb4de22a-fb3a-422e-a9da-34dc439f0abb','e47de2b4135b4005af9009853f7a18dd','4ed32334aab64e5388ef8e859555acf4',1,'tempest-tempest-created-share-2033647789','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:15:47.266279','2026-02-01 15:15:54.817913','2026-02-01 15:15:54.817444','eca477cd-78ff-4eb7-8da1-b1525a32f86f','eca477cd-78ff-4eb7-8da1-b1525a32f86f','e9e626045c924c8c981ad3f67a1dedd6','f99925486e924480b84b05e1433af949',1,'tempest-tempest-created-share-1271133943','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:13:08.111562','2026-02-01 15:13:20.813953','2026-02-01 15:13:20.813497','ed775457-44d0-495d-ad2f-880aebb5c6c4','ed775457-44d0-495d-ad2f-880aebb5c6c4','cfc88dace67943ebb2cda941b51534e0','cf2f906871624fa0887af8f21afda469',1,'tempest-tempest-created-share-750217422','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:14:35.252420','2026-02-01 15:14:40.460368','2026-02-01 15:14:40.460004','ee2ee742-7ede-4f5f-aba6-102f266b036a','ee2ee742-7ede-4f5f-aba6-102f266b036a','928da2f6147a4b708835fcbebf483d8a','8148327cebed4bb49e576111ce3edff1',1,'tempest-tempest-created-share-1903107811','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:19:07.554010','2026-02-01 15:19:27.780477','2026-02-01 15:19:27.779922','ef02fcc2-7d7d-46b1-9994-e24d68e5b43f','ef02fcc2-7d7d-46b1-9994-e24d68e5b43f','5a9e48d8005d427fa422911dd04f4938','754e5daaf01d4d8e91ba62e9ca89a38d',1,'tempest-tempest-share-name-686852322','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:13:20.238372','2026-02-01 15:13:26.431216','2026-02-01 15:13:26.430722','f2b934af-baf5-452c-a0dd-7c6d84e45aaf','f2b934af-baf5-452c-a0dd-7c6d84e45aaf','dd3dddd74c80436eae71170aed36a00b','e97ebfd6a3764df8b7badde8319f1a16',1,'tempest-tempest-created-share-1263027328','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:15:32.391902','2026-02-01 15:15:36.507680','2026-02-01 15:15:36.507114','f6d21267-86b4-4a5b-b0bb-04567d756f96','f6d21267-86b4-4a5b-b0bb-04567d756f96','6f2dab9328424993aa458427358720d9','32087184504a4aabb8269aa5ef350c60',1,'tempest-tempest-created-share-937269997','tempest-tempest-created-share-desc-566291155',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:15:44.435763','2026-02-01 15:15:48.087132','2026-02-01 15:15:48.086599','f7bd8de1-9d03-4c74-a408-3d1b24011e23','f7bd8de1-9d03-4c74-a408-3d1b24011e23','6f2dab9328424993aa458427358720d9','32087184504a4aabb8269aa5ef350c60',1,'tempest-tempest-created-share-1668973880','tempest-tempest-created-share-desc-4416795',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-02-01 15:14:23.755618','2026-02-01 15:15:13.628321','2026-02-01 15:15:13.627967','fcd5b66f-69eb-467b-8a17-b7c7c3d3f328','fcd5b66f-69eb-467b-8a17-b7c7c3d3f328','928da2f6147a4b708835fcbebf483d8a','8148327cebed4bb49e576111ce3edff1',1,'tempest-tempest-created-share-379684893','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL);
/*!40000 ALTER TABLE `shares` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `resource_id` varchar(36) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime(6) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
INSERT INTO `transfers` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `resource_id`, `resource_type`, `display_name`, `salt`, `crypt_hash`, `expires_at`, `source_project_id`, `destination_project_id`, `accepted`) VALUES ('0d3e4e22-7502-44a6-8ccf-8920199f38bf','2026-02-01 15:19:15.016328',NULL,'2026-02-01 15:19:15.306213','0d3e4e22-7502-44a6-8ccf-8920199f38bf','99eedc5a-b918-4040-a83b-96644a9ed910','share','tempest-tempest-created-share-transfer-413487548','3e3760a0','a59fdbf4316e9ba9585e7b757fabf9ece9bd39e23ad178d074309b60988f6791','2026-02-01 15:24:15.015385','754e5daaf01d4d8e91ba62e9ca89a38d',NULL,0),('23ace129-8106-4113-babe-45e3e4e20c30','2026-02-01 15:19:10.904744',NULL,'2026-02-01 15:19:11.182311','23ace129-8106-4113-babe-45e3e4e20c30','ef02fcc2-7d7d-46b1-9994-e24d68e5b43f','share','tempest-tempest-created-share-transfer-1068762267','68e2674d','9d558013446a966b2ddbd1dcb24121d400ff4ad991bd983b5b3a28aa7eb9c837','2026-02-01 15:24:10.903970','754e5daaf01d4d8e91ba62e9ca89a38d',NULL,0),('3f8f08a0-d0c2-4b2c-b2d3-becd59424d09','2026-02-01 15:19:19.080663',NULL,'2026-02-01 15:19:19.368076','3f8f08a0-d0c2-4b2c-b2d3-becd59424d09','8f16715d-9b52-40a1-a5b4-5d4cfa9e7098','share','tempest-tempest-created-share-transfer-1952225655','63046da1','f7c1635db75c0ad9e4ac20504d85d4cf179bb6dcae4cc75155fa6080b7058f4f','2026-02-01 15:24:19.079553','754e5daaf01d4d8e91ba62e9ca89a38d',NULL,0),('9e3f80d7-fada-403d-b38a-5cd73f85109a','2026-02-01 15:19:06.857606',NULL,'2026-02-01 15:19:07.275167','9e3f80d7-fada-403d-b38a-5cd73f85109a','62d30550-2210-40f2-83b1-24b67cb16735','share','tempest-tempest-created-share-transfer-1091148091','4bd71a32','b81e58ed8086968c1f76a979352fc933553ecee0ace5b79fe3830d2bfd63645e','2026-02-01 15:24:06.856235','754e5daaf01d4d8e91ba62e9ca89a38d',NULL,0),('c7b8748a-7f55-491c-b4ff-63129ea2bc4d','2026-02-01 15:18:42.408443','2026-02-01 15:18:42.822373','2026-02-01 15:18:42.822372','1','7ffeeb4c-77d5-4378-af95-4e59e11fb3c3','share','tempest-tempest-created-share-transfer-1643883320','3ccc89df','329e46aa1bf54ea30f3952edf5d04fc236b3212c22cda135ceadf0dcf1d2196a','2026-02-01 15:23:42.406667','7736a9c671f04e42b35558bfde737fc8','2c31b44d86274d9c9323bcb7f0a754dd',1),('f90e41bc-8e27-45d6-9fe4-a3504746a2f0','2026-02-01 15:18:50.205185',NULL,'2026-02-01 15:18:50.448749','f90e41bc-8e27-45d6-9fe4-a3504746a2f0','4de7a064-1350-4ec3-b928-d924446e2825','share','tempest_share_transfer','ba2fddd5','a6aca8dca6ea0ba50e71260ed57abf3db1e5d2fd1e4fd46e0cb57e1c74bcd47a','2026-02-01 15:23:50.203741','7736a9c671f04e42b35558bfde737fc8',NULL,0);
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `mysql`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `mysql` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;

USE `mysql`;

--
-- Table structure for table `general_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `general_log` (
  `event_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `command_type` varchar(64) NOT NULL,
  `argument` mediumtext NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='General log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slow_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `slow_log` (
  `start_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `query_time` time(6) NOT NULL,
  `lock_time` time(6) NOT NULL,
  `rows_sent` bigint(20) unsigned NOT NULL,
  `rows_examined` bigint(20) unsigned NOT NULL,
  `db` varchar(512) NOT NULL,
  `last_insert_id` int(11) NOT NULL,
  `insert_id` int(11) NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `sql_text` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `rows_affected` bigint(20) unsigned NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Slow log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `column_stats`
--

DROP TABLE IF EXISTS `column_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `column_stats` (
  `db_name` varchar(64) NOT NULL,
  `table_name` varchar(64) NOT NULL,
  `column_name` varchar(64) NOT NULL,
  `min_value` varbinary(255) DEFAULT NULL,
  `max_value` varbinary(255) DEFAULT NULL,
  `nulls_ratio` decimal(12,4) DEFAULT NULL,
  `avg_length` decimal(12,4) DEFAULT NULL,
  `avg_frequency` decimal(12,4) DEFAULT NULL,
  `hist_size` tinyint(3) unsigned DEFAULT NULL,
  `hist_type` enum('SINGLE_PREC_HB','DOUBLE_PREC_HB') DEFAULT NULL,
  `histogram` varbinary(255) DEFAULT NULL,
  PRIMARY KEY (`db_name`,`table_name`,`column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='Statistics on Columns';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `column_stats`
--

LOCK TABLES `column_stats` WRITE;
/*!40000 ALTER TABLE `column_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `column_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `columns_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Table_name` char(64) NOT NULL DEFAULT '',
  `Column_name` char(64) NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `db` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_history_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT INTO `db` (`Host`, `Db`, `User`, `Select_priv`, `Insert_priv`, `Update_priv`, `Delete_priv`, `Create_priv`, `Drop_priv`, `Grant_priv`, `References_priv`, `Index_priv`, `Alter_priv`, `Create_tmp_table_priv`, `Lock_tables_priv`, `Create_view_priv`, `Show_view_priv`, `Create_routine_priv`, `Alter_routine_priv`, `Execute_priv`, `Event_priv`, `Trigger_priv`, `Delete_history_priv`) VALUES ('localhost','glance','glance_7cb0','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','glance','glance_7cb0','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','keystone','keystone_6a2e','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','keystone','keystone_6a2e','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','placement','placement_d75a','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','placement','placement_d75a','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','barbican','barbican_dda1','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','barbican','barbican_dda1','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','cinder','cinder_2f44','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','cinder','cinder_2f44','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','neutron','neutron_b3a6','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','neutron','neutron_b3a6','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_cell0','nova_cell0_0b48','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_cell0','nova_cell0_0b48','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_api','nova_api_f893','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_api','nova_api_f893','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','manila','manila_3bac','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','manila','manila_3bac','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` char(141) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','IGNORE_BAD_TABLE_OPTIONS','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH','EMPTY_STRING_IS_NULL','SIMULTANEOUS_ASSIGNMENT','TIME_ROUND_FRACTIONAL') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob DEFAULT NULL,
  PRIMARY KEY (`db`,`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `func` (
  `name` char(64) NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT 0,
  `dl` char(128) NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `global_priv`
--

DROP TABLE IF EXISTS `global_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Priv` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '{}' CHECK (json_valid(`Priv`)),
  PRIMARY KEY (`Host`,`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_priv`
--

LOCK TABLES `global_priv` WRITE;
/*!40000 ALTER TABLE `global_priv` DISABLE KEYS */;
INSERT INTO `global_priv` (`Host`, `User`, `Priv`) VALUES ('localhost','mariadb.sys','{\"access\":0,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"\",\"account_locked\":true,\"password_last_changed\":0}'),('localhost','root','{\"access\": 549755813887, \"plugin\": \"mysql_native_password\", \"authentication_string\": \"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\", \"auth_or\": [{}],\"version_id\":100529,\"password_last_changed\":1769956617}'),('%','root','{\"access\":549755813887,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\",\"password_last_changed\":1769956617}'),('localhost','glance_7cb0','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*40E328CE9D147599695050CD16062EB8549F7FAC\",\"password_last_changed\":1769956616}'),('%','glance_7cb0','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*40E328CE9D147599695050CD16062EB8549F7FAC\",\"password_last_changed\":1769956616}'),('localhost','keystone_6a2e','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*BE51002250D5340171F6C67AE6E1A0545DC4B8A0\",\"password_last_changed\":1769956620}'),('%','keystone_6a2e','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*BE51002250D5340171F6C67AE6E1A0545DC4B8A0\",\"password_last_changed\":1769956620}'),('localhost','placement_d75a','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*1759A8E4DB77D339DCDC0C6C22D511C855C4F6D1\",\"password_last_changed\":1769956621}'),('%','placement_d75a','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*1759A8E4DB77D339DCDC0C6C22D511C855C4F6D1\",\"password_last_changed\":1769956621}'),('localhost','barbican_dda1','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*3237761D5F034BDAC263CE87F17D6086EDA89C98\",\"password_last_changed\":1769956648}'),('%','barbican_dda1','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*3237761D5F034BDAC263CE87F17D6086EDA89C98\",\"password_last_changed\":1769956648}'),('localhost','cinder_2f44','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*561E5CD0488EB055FFBEA6A651A911257FEC04FB\",\"password_last_changed\":1769956648}'),('%','cinder_2f44','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*561E5CD0488EB055FFBEA6A651A911257FEC04FB\",\"password_last_changed\":1769956648}'),('localhost','neutron_b3a6','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*5EAFD78418C46A1FDE2E883FCAE779FD83B80883\",\"password_last_changed\":1769956648}'),('%','neutron_b3a6','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*5EAFD78418C46A1FDE2E883FCAE779FD83B80883\",\"password_last_changed\":1769956648}'),('localhost','nova_cell0_0b48','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*51A8560CBDF066907732E13E74AB7F43583A8D6D\",\"password_last_changed\":1769956739}'),('%','nova_cell0_0b48','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*51A8560CBDF066907732E13E74AB7F43583A8D6D\",\"password_last_changed\":1769956739}'),('localhost','nova_api_f893','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*CA62DD466AD638F19579F7E3B54494E07C6224AF\",\"password_last_changed\":1769956739}'),('%','nova_api_f893','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*CA62DD466AD638F19579F7E3B54494E07C6224AF\",\"password_last_changed\":1769956739}'),('localhost','manila_3bac','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B5B359B84B723032249D6FE93D9E386A90DC714D\",\"password_last_changed\":1769958418}'),('%','manila_3bac','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B5B359B84B723032249D6FE93D9E386A90DC714D\",\"password_last_changed\":1769958418}');
/*!40000 ALTER TABLE `global_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gtid_slave_pos`
--

DROP TABLE IF EXISTS `gtid_slave_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gtid_slave_pos` (
  `domain_id` int(10) unsigned NOT NULL,
  `sub_id` bigint(20) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `seq_no` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`domain_id`,`sub_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Replication slave GTID position';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gtid_slave_pos`
--

LOCK TABLES `gtid_slave_pos` WRITE;
/*!40000 ALTER TABLE `gtid_slave_pos` DISABLE KEYS */;
/*!40000 ALTER TABLE `gtid_slave_pos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT INTO `help_category` (`help_category_id`, `name`, `parent_category_id`, `url`) VALUES (1,'Contents',0,''),(2,'Polygon Properties',34,''),(3,'WKT',34,''),(4,'Numeric Functions',37,''),(5,'Plugins',1,''),(6,'MBR',34,''),(7,'Control Flow Functions',37,''),(8,'Transactions',1,''),(9,'Help Metadata',1,''),(10,'Account Management',1,''),(11,'Point Properties',34,''),(12,'Encryption Functions',37,''),(13,'LineString Properties',34,''),(14,'Miscellaneous Functions',37,''),(15,'Logical Operators',47,''),(16,'Functions and Modifiers for Use with GROUP BY',1,''),(17,'Information Functions',37,''),(18,'Assignment Operators',47,''),(19,'Comparison Operators',47,''),(20,'Bit Functions',37,''),(21,'Table Maintenance',1,''),(22,'User-Defined Functions',1,''),(23,'Data Types',1,''),(24,'Compound Statements',1,''),(25,'Geometry Constructors',34,''),(26,'Administration',1,''),(27,'Data Manipulation',1,''),(28,'Utility',1,''),(29,'Language Structure',1,''),(30,'Geometry Relations',34,''),(31,'Date and Time Functions',37,''),(32,'WKB',34,''),(33,'Procedures',1,''),(34,'Geographic Features',1,''),(35,'Geometry Properties',34,''),(36,'String Functions',37,''),(37,'Functions',1,''),(38,'Data Definition',1,''),(39,'Sequences',1,''),(40,'JSON Functions',37,''),(41,'Window Functions',37,''),(42,'Spider Functions',37,''),(43,'Dynamic Column Functions',37,''),(44,'Galera Functions',37,''),(45,'Temporal Tables',1,''),(46,'GeoJSON',34,''),(47,'Operators',1,''),(48,'Arithmetic Operators',47,''),(49,'Replication',1,''),(50,'Prepared Statements',1,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT INTO `help_keyword` (`help_keyword_id`, `name`) VALUES (1,'work'),(2,'locks'),(3,'locking'),(4,'drop'),(5,'super'),(6,'usage'),(7,'binlog admin'),(8,'binlog monitor'),(9,'binlog replay'),(10,'connection admin'),(11,'federated admin'),(12,'grant option'),(13,'read_only admin'),(14,'replica monitor'),(15,'replication replica'),(16,'roles'),(17,'values'),(18,'value'),(19,'not'),(20,'and'),(21,'or'),(22,':='),(23,'assignment operator'),(24,'='),(25,'!='),(26,'<>'),(27,'not equal'),(28,'less than'),(29,'less than or equal'),(30,'NULL-safe equal'),(31,'equal'),(32,'greater than'),(33,'greater than or equal'),(34,'bitwise and'),(35,'shift left'),(36,'shift right'),(37,'bitwise xor'),(38,'bitwise or'),(39,'bitwise not'),(40,'returns'),(41,'udfs'),(42,'udf calling sequences'),(43,'udf security'),(44,'int1'),(45,'int2'),(46,'int3'),(47,'integer'),(48,'int4'),(49,'int8'),(50,'dec'),(51,'numeric'),(52,'fixed'),(53,'number'),(54,'real'),(55,'double precision'),(56,'nchar'),(57,'long'),(58,'long varchar'),(59,'repeat'),(60,'declare'),(61,'cursor'),(62,'show'),(63,'columns'),(64,'kill connection'),(65,'kill query'),(66,'delete returning'),(67,'sql_big_result'),(68,'minus'),(69,'cte'),(70,'insert returning'),(71,'queries'),(72,'query'),(73,'explain format'),(74,'explain format json'),(75,'rlike'),(76,'character_length'),(77,'escape'),(78,'mode'),(79,'trim_oracle'),(80,'schedule'),(81,'row_format'),(82,'starts'),(83,'host'),(84,'generated columns'),(85,'virtual columns'),(86,'computed columns'),(87,'hidden columns'),(88,'nextval'),(89,'lastval'),(90,'+'),(91,'addition operator'),(92,'/'),(93,'division operator'),(94,'%'),(95,'modulo operator'),(96,'*'),(97,'multiplication operator'),(98,'-'),(99,'subtraction operator'),(100,'master_ssl_verify_cert'),(101,'start replica'),(102,'stop replica'),(103,'reset slave'),(104,'reset replica'),(105,'drop prepare'),(106,'deallocate prepare');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`),
  KEY `help_topic_id` (`help_topic_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT INTO `help_relation` (`help_topic_id`, `help_keyword_id`) VALUES (94,1),(97,2),(99,2),(101,2),(116,2),(147,2),(152,2),(157,2),(161,2),(162,2),(338,2),(438,2),(97,3),(99,3),(101,3),(116,3),(147,3),(152,3),(157,3),(161,3),(162,3),(338,3),(438,3),(106,4),(112,4),(250,4),(687,4),(697,4),(713,4),(714,4),(715,4),(716,4),(717,4),(718,4),(719,4),(720,4),(722,4),(723,4),(731,4),(107,5),(107,6),(107,7),(107,8),(107,9),(107,10),(107,11),(107,12),(107,13),(107,14),(107,15),(115,16),(166,17),(166,18),(167,19),(168,20),(170,21),(210,22),(210,23),(211,23),(211,24),(212,25),(212,26),(212,27),(213,28),(214,29),(215,30),(216,31),(217,32),(218,33),(232,34),(233,35),(234,36),(236,37),(237,38),(238,39),(249,40),(251,41),(252,42),(253,43),(255,44),(257,45),(258,46),(259,47),(259,48),(260,49),(261,50),(261,51),(261,52),(261,53),(263,54),(263,55),(269,56),(275,57),(275,58),(304,59),(664,59),(311,60),(311,61),(331,62),(332,62),(333,62),(334,62),(335,62),(342,62),(343,62),(344,62),(345,62),(346,62),(347,62),(354,62),(356,62),(357,62),(358,62),(359,62),(360,62),(361,62),(362,62),(363,62),(364,62),(365,62),(366,62),(367,62),(368,62),(369,62),(370,62),(371,62),(372,62),(373,62),(374,62),(375,62),(376,62),(377,62),(378,62),(379,62),(380,62),(381,62),(382,62),(383,62),(384,62),(385,62),(386,62),(387,62),(388,62),(389,62),(390,62),(391,62),(392,62),(393,62),(394,62),(395,62),(396,62),(397,62),(398,62),(408,62),(409,62),(333,63),(403,64),(403,65),(410,66),(414,67),(425,68),(431,69),(432,69),(433,69),(453,70),(460,71),(460,72),(466,73),(466,74),(622,75),(632,76),(651,77),(657,78),(678,79),(689,80),(696,81),(701,82),(707,83),(711,84),(711,85),(711,86),(712,87),(732,88),(733,89),(804,90),(804,91),(805,92),(805,93),(806,94),(806,95),(807,96),(807,97),(808,98),(808,99),(809,100),(810,101),(811,102),(812,103),(812,104),(816,105),(816,106);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
INSERT INTO `help_topic` (`help_topic_id`, `name`, `help_category_id`, `description`, `example`, `url`) VALUES (1,'HELP_DATE',9,'Help Contents generated from the MariaDB Knowledge Base on 23 January 2023.','',''),(2,'HELP_VERSION',9,'Help Contents generated for MariaDB 10.5 from the MariaDB Knowledge Base on 23 January 2023.','',''),(3,'AREA',2,'A synonym for ST_AREA.\n\nURL: https://mariadb.com/kb/en/polygon-properties-area/','','https://mariadb.com/kb/en/polygon-properties-area/'),(4,'CENTROID',2,'A synonym for ST_CENTROID.\n\nURL: https://mariadb.com/kb/en/centroid/','','https://mariadb.com/kb/en/centroid/'),(5,'ExteriorRing',2,'A synonym for ST_ExteriorRing.\n\nURL: https://mariadb.com/kb/en/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/polygon-properties-exteriorring/'),(6,'InteriorRingN',2,'A synonym for ST_InteriorRingN.\n\nURL: https://mariadb.com/kb/en/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/polygon-properties-interiorringn/'),(7,'NumInteriorRings',2,'A synonym for ST_NumInteriorRings.\n\nURL: https://mariadb.com/kb/en/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/polygon-properties-numinteriorrings/'),(8,'ST_AREA',2,'Syntax\n------\n\nST_Area(poly)\nArea(poly)\n\nDescription\n-----------\n\nReturns as a double-precision number the area of the Polygon value poly, as\nmeasured in its spatial reference system.\n\nST_Area() and Area() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\n\nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/st_area/','','https://mariadb.com/kb/en/st_area/'),(9,'ST_CENTROID',2,'Syntax\n------\n\nST_Centroid(mpoly)\nCentroid(mpoly)\n\nDescription\n-----------\n\nReturns a point reflecting the mathematical centroid (geometric center) for\nthe MultiPolygon mpoly. The resulting point will not necessarily be on the\nMultiPolygon.\n\nST_Centroid() and Centroid() are synonyms.\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0 0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n+--------------+\n| center       |\n+--------------+\n| POINT(10 10) |\n+--------------+\n\nURL: https://mariadb.com/kb/en/st_centroid/','','https://mariadb.com/kb/en/st_centroid/'),(10,'ST_ExteriorRing',2,'Syntax\n------\n\nST_ExteriorRing(poly)\nExteriorRing(poly)\n\nDescription\n-----------\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() and ExteriorRing() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_exteriorring/','','https://mariadb.com/kb/en/st_exteriorring/'),(11,'ST_InteriorRingN',2,'Syntax\n------\n\nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n\nDescription\n-----------\n\nReturns the N-th interior ring for the Polygon value poly as a LineString.\nRings are numbered beginning with 1.\n\nST_InteriorRingN() and InteriorRingN() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_interiorringn/','','https://mariadb.com/kb/en/st_interiorringn/'),(12,'ST_NumInteriorRings',2,'Syntax\n------\n\nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n\nDescription\n-----------\n\nReturns an integer containing the number of interior rings in the Polygon\nvalue poly.\n\nNote that according the the OpenGIS standard, a POLYGON should have exactly\none ExteriorRing and all other rings should lie within that ExteriorRing and\nthus be the InteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several \'ExteriorRings\'. In the case of\nthere being multiple, non-overlapping exterior rings ST_NumInteriorRings()\nwill return 1.\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/st_numinteriorrings/','','https://mariadb.com/kb/en/st_numinteriorrings/'),(14,'AsText',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-astext/','','https://mariadb.com/kb/en/wkt-astext/'),(15,'AsWKT',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-aswkt/','','https://mariadb.com/kb/en/wkt-aswkt/'),(16,'GeomCollFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/wkt-geomcollfromtext/'),(17,'GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromtext/','','https://mariadb.com/kb/en/geometrycollectionfromtext/'),(18,'GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/geometryfromtext/','','https://mariadb.com/kb/en/geometryfromtext/'),(19,'GeomFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomfromtext/','','https://mariadb.com/kb/en/wkt-geomfromtext/'),(20,'LineFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/wkt-linefromtext/','','https://mariadb.com/kb/en/wkt-linefromtext/'),(21,'LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/linestringfromtext/','','https://mariadb.com/kb/en/linestringfromtext/'),(22,'MLineFromText',3,'Syntax\n------\n\nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n\nMLineFromText() and MultiLineStringFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\nINSERT INTO gis_multi_line VALUES\n  (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16\n23,16 48))\')),\n  (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n  (MLineFromWKB(AsWKB(MultiLineString(\n   LineString(Point(1, 2), Point(3, 5)),\n   LineString(Point(2, 5), Point(5, 8), Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/mlinefromtext/','','https://mariadb.com/kb/en/mlinefromtext/'),(23,'MPointFromText',3,'Syntax\n------\n\nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nMPointFromText() and MultiPointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/mpointfromtext/','','https://mariadb.com/kb/en/mpointfromtext/'),(13,'WKT Definition',3,'Description\n-----------\n\nThe Well-Known Text (WKT) representation of Geometry is designed to exchange\ngeometry data in ASCII form. Examples of the basic geometry types include:\n\n+-----------------------------------------------------------------------------+\n| Geometry Types                                                              |\n+-----------------------------------------------------------------------------+\n| POINT                                                                       |\n+-----------------------------------------------------------------------------+\n| LINESTRING                                                                  |\n+-----------------------------------------------------------------------------+\n| POLYGON                                                                     |\n+-----------------------------------------------------------------------------+\n| MULTIPOINT                                                                  |\n+-----------------------------------------------------------------------------+\n| MULTILINESTRING                                                             |\n+-----------------------------------------------------------------------------+\n| MULTIPOLYGON                                                                |\n+-----------------------------------------------------------------------------+\n| GEOMETRYCOLLECTION                                                          |\n+-----------------------------------------------------------------------------+\n| GEOMETRY                                                                    |\n+-----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/wkt-definition/','','https://mariadb.com/kb/en/wkt-definition/'),(24,'MPolyFromText',3,'Syntax\n------\n\nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nMPolyFromText() and MultiPolygonFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(\n   LineString(Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/mpolyfromtext/','','https://mariadb.com/kb/en/mpolyfromtext/'),(25,'MultiLineStringFromText',3,'A synonym for MLineFromText.\n\nURL: https://mariadb.com/kb/en/multilinestringfromtext/','','https://mariadb.com/kb/en/multilinestringfromtext/'),(26,'MultiPointFromText',3,'A synonym for MPointFromText.\n\nURL: https://mariadb.com/kb/en/multipointfromtext/','','https://mariadb.com/kb/en/multipointfromtext/'),(27,'MultiPolygonFromText',3,'A synonym for MPolyFromText.\n\nURL: https://mariadb.com/kb/en/multipolygonfromtext/','','https://mariadb.com/kb/en/multipolygonfromtext/'),(28,'PointFromText',3,'A synonym for ST_PointFromText.\n\nURL: https://mariadb.com/kb/en/wkt-pointfromtext/','','https://mariadb.com/kb/en/wkt-pointfromtext/'),(29,'PolyFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/wkt-polyfromtext/','','https://mariadb.com/kb/en/wkt-polyfromtext/'),(30,'PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/polygonfromtext/','','https://mariadb.com/kb/en/polygonfromtext/'),(31,'ST_AsText',3,'Syntax\n------\n\nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKT representation and\nreturns the string result.\n\nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all synonyms.\n\nExamples\n--------\n\nSET @g = \'LineString(1 1,4 4,6 6)\';\n\nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6)        |\n+--------------------------------+\n\nURL: https://mariadb.com/kb/en/st_astext/','','https://mariadb.com/kb/en/st_astext/'),(32,'ST_ASWKT',3,'A synonym for ST_ASTEXT().\n\nURL: https://mariadb.com/kb/en/st_aswkt/','','https://mariadb.com/kb/en/st_aswkt/'),(33,'ST_GeomCollFromText',3,'Syntax\n------\n\nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(), GeomCollFromText() and\nGeometryCollectionFromText() are all synonyms.\n\nExample\n-------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/st_geomcollfromtext/','','https://mariadb.com/kb/en/st_geomcollfromtext/'),(34,'ST_GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/st_geometrycollectionfromtext/'),(35,'ST_GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/st_geometryfromtext/','','https://mariadb.com/kb/en/st_geometryfromtext/'),(36,'ST_GeomFromText',3,'Syntax\n------\n\nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKT representation and SRID.\n\nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n\nExample\n-------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nURL: https://mariadb.com/kb/en/st_geomfromtext/','','https://mariadb.com/kb/en/st_geomfromtext/'),(37,'ST_LineFromText',3,'Syntax\n------\n\nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nST_LineFromText(), ST_LineStringFromText(), ST_LineFromText() and\nST_LineStringFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_line  (g LINESTRING);\nSHOW FIELDS FROM gis_line;\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/st_linefromtext/','','https://mariadb.com/kb/en/st_linefromtext/'),(38,'ST_LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/st_linestringfromtext/','','https://mariadb.com/kb/en/st_linestringfromtext/'),(39,'ST_PointFromText',3,'Syntax\n------\n\nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKT representation and SRID.\n\nST_PointFromText() and PointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_point  (g POINT);\nSHOW FIELDS FROM gis_point;\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/st_pointfromtext/','','https://mariadb.com/kb/en/st_pointfromtext/'),(40,'ST_PolyFromText',3,'Syntax\n------\n\nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\'));\n\nURL: https://mariadb.com/kb/en/st_polyfromtext/','','https://mariadb.com/kb/en/st_polyfromtext/'),(41,'ST_PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/st_polygonfromtext/','','https://mariadb.com/kb/en/st_polygonfromtext/'),(42,'DIV',4,'Syntax\n------\n\nDIV\n\nDescription\n-----------\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for non-integer operands that exceed BIGINT range.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a division by zero produces\nan error. Otherwise, it returns NULL.\n\nThe remainder of a division can be obtained using the MOD operator.\n\nExamples\n--------\n\nSELECT 300 DIV 7;\n+-----------+\n| 300 DIV 7 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT 300 DIV 0;\n+-----------+\n| 300 DIV 0 |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/div/','','https://mariadb.com/kb/en/div/'),(43,'ABS',4,'Syntax\n------\n\nABS(X)\n\nDescription\n-----------\n\nReturns the absolute (non-negative) value of X. If X is not a number, it is\nconverted to a numeric type.\n\nExamples\n--------\n\nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n|      42 |\n+---------+\n\nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n|       42 |\n+----------+\n\nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n|               19940101 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/abs/','','https://mariadb.com/kb/en/abs/'),(44,'ACOS',4,'Syntax\n------\n\nACOS(X)\n\nDescription\n-----------\n\nReturns the arc cosine of X, that is, the value whose cosine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n|         NULL |\n+--------------+\n\nSELECT ACOS(0);\n+-----------------+\n| ACOS(0)         |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234)      |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/acos/','','https://mariadb.com/kb/en/acos/'),(45,'ASIN',4,'Syntax\n------\n\nASIN(X)\n\nDescription\n-----------\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns NULL if\nX is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2)          |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n\nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n\nSHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n\nURL: https://mariadb.com/kb/en/asin/','','https://mariadb.com/kb/en/asin/'),(46,'ATAN',4,'Syntax\n------\n\nATAN(X)\n\nDescription\n-----------\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nExamples\n--------\n\nSELECT ATAN(2);\n+--------------------+\n| ATAN(2)            |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n\nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2)            |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/atan/','','https://mariadb.com/kb/en/atan/'),(47,'ATAN2',4,'Syntax\n------\n\nATAN(Y,X), ATAN2(Y,X)\n\nDescription\n-----------\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both arguments\nare used to determine the quadrant of the result.\n\nExamples\n--------\n\nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2)          |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n\nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0)      |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/atan2/','','https://mariadb.com/kb/en/atan2/'),(48,'CEIL',4,'Syntax\n------\n\nCEIL(X)\n\nDescription\n-----------\n\nCEIL() is a synonym for CEILING().\n\nURL: https://mariadb.com/kb/en/ceil/','','https://mariadb.com/kb/en/ceil/'),(49,'CEILING',4,'Syntax\n------\n\nCEILING(X)\n\nDescription\n-----------\n\nReturns the smallest integer value not less than X.\n\nExamples\n--------\n\nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n|             -1 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/ceiling/','','https://mariadb.com/kb/en/ceiling/'),(51,'COS',4,'Syntax\n------\n\nCOS(X)\n\nDescription\n-----------\n\nReturns the cosine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n|        -1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/cos/','','https://mariadb.com/kb/en/cos/'),(52,'COT',4,'Syntax\n------\n\nCOT(X)\n\nDescription\n-----------\n\nReturns the cotangent of X.\n\nExamples\n--------\n\nSELECT COT(42);\n+--------------------+\n| COT(42)            |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n\nSELECT COT(12);\n+---------------------+\n| COT(12)             |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n\nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in \'cot(0)\'\n\nURL: https://mariadb.com/kb/en/cot/','','https://mariadb.com/kb/en/cot/'),(54,'DEGREES',4,'Syntax\n------\n\nDEGREES(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from radians to degrees.\n\nThis is the converse of the RADIANS() function.\n\nExamples\n--------\n\nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n|           180 |\n+---------------+\n\nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n|                90 |\n+-------------------+\n\nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45)     |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/degrees/','','https://mariadb.com/kb/en/degrees/'),(55,'EXP',4,'Syntax\n------\n\nEXP(X)\n\nDescription\n-----------\n\nReturns the value of e (the base of natural logarithms) raised to the power of\nX. The inverse of this function is LOG() (using a single argument only) or\nLN().\n\nIf X is NULL, this function returns NULL.\n\nExamples\n--------\n\nSELECT EXP(2);\n+------------------+\n| EXP(2)           |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n\nSELECT EXP(-2);\n+--------------------+\n| EXP(-2)            |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n\nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n|      1 |\n+--------+\n\nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/exp/','','https://mariadb.com/kb/en/exp/'),(50,'CONV',4,'Syntax\n------\n\nCONV(N,from_base,to_base)\n\nDescription\n-----------\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base to_base.\n\nReturns NULL if any argument is NULL, or if the second or third argument are\nnot in the allowed range.\n\nThe argument N is interpreted as an integer, but may be specified as an\ninteger or a string. The minimum base is 2 and the maximum base is 36. If\nto_base is a negative number, N is regarded as a signed number. Otherwise, N\nis treated as unsigned. CONV() works with 64-bit precision.\n\nSome shortcuts for this function are also available: BIN(), OCT(), HEX(),\nUNHEX(). Also, MariaDB allows binary literal values and hexadecimal literal\nvalues.\n\nExamples\n--------\n\nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010           |\n+----------------+\n\nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172             |\n+-----------------+\n\nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H               |\n+------------------+\n\nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42                           |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/conv/','','https://mariadb.com/kb/en/conv/'),(53,'CRC32',4,'Syntax\n------\n\n<= MariaDB 10.7\n\nCRC32(expr)\n\nFrom MariaDB 10.8\n\nCRC32([par,]expr)\n\nDescription\n-----------\n\nComputes a cyclic redundancy check (CRC) value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is expected to\nbe a string and (if possible) is treated as one if it is not.\n\nUses the ISO 3309 polynomial that used by zlib and many others. MariaDB 10.8\nintroduced the CRC32C() function, which uses the alternate Castagnoli\npolynomia.\n\nMariaDB starting with 10.8\n--------------------------\nOften, CRC is computed in pieces. To facilitate this, MariaDB 10.8.0\nintroduced an optional parameter: CRC32(\'MariaDB\')=CRC32(CRC32(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n|       4227209140 |\n+------------------+\n\nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n|       2594253378 |\n+------------------+\n\nFrom MariaDB 10.8.0\n\nSELECT CRC32(CRC32(\'Maria\'),\'DB\');\n+----------------------------+\n| CRC32(CRC32(\'Maria\'),\'DB\') |\n+----------------------------+\n|                 4227209140 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/crc32/','','https://mariadb.com/kb/en/crc32/'),(56,'FLOOR',4,'Syntax\n------\n\nFLOOR(X)\n\nDescription\n-----------\n\nReturns the largest integer value not greater than X.\n\nExamples\n--------\n\nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n|           -2 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/floor/','','https://mariadb.com/kb/en/floor/'),(57,'LN',4,'Syntax\n------\n\nLN(X)\n\nDescription\n-----------\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X. If X\nis less than or equal to 0, or NULL, then NULL is returned.\n\nThe inverse of this function is EXP().\n\nExamples\n--------\n\nSELECT LN(2);\n+-------------------+\n| LN(2)             |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n|   NULL |\n+--------+\n\nURL: https://mariadb.com/kb/en/ln/','','https://mariadb.com/kb/en/ln/'),(58,'LOG',4,'Syntax\n------\n\nLOG(X), LOG(B,X)\n\nDescription\n-----------\n\nIf called with one parameter, this function returns the natural logarithm of\nX. If X is less than or equal to 0, then NULL is returned.\n\nIf called with two parameters, it returns the logarithm of X to the base B. If\nB is <= 1 or X <= 0, the function returns NULL.\n\nIf any argument is NULL, the function returns NULL.\n\nThe inverse of this function (when called with a single argument) is the EXP()\nfunction.\n\nExamples\n--------\n\nLOG(X):\n\nSELECT LOG(2);\n+-------------------+\n| LOG(2)            |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LOG(-2);\n+---------+\n| LOG(-2) |\n+---------+\n|    NULL |\n+---------+\n\nLOG(B,X)\n\nSELECT LOG(2,16);\n+-----------+\n| LOG(2,16) |\n+-----------+\n|         4 |\n+-----------+\n\nSELECT LOG(3,27);\n+-----------+\n| LOG(3,27) |\n+-----------+\n|         3 |\n+-----------+\n\nSELECT LOG(3,1);\n+----------+\n| LOG(3,1) |\n+----------+\n|        0 |\n+----------+\n\nSELECT LOG(3,0);\n+----------+\n| LOG(3,0) |\n+----------+\n|     NULL |\n+----------+\n\nURL: https://mariadb.com/kb/en/log/','','https://mariadb.com/kb/en/log/'),(59,'LOG10',4,'Syntax\n------\n\nLOG10(X)\n\nDescription\n-----------\n\nReturns the base-10 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG10(2);\n+-------------------+\n| LOG10(2)          |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n\nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n|          2 |\n+------------+\n\nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/log10/','','https://mariadb.com/kb/en/log10/'),(60,'LOG2',4,'Syntax\n------\n\nLOG2(X)\n\nDescription\n-----------\n\nReturns the base-2 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n|                  42 |\n+---------------------+\n\nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n|          16 |\n+-------------+\n\nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n|       NULL |\n+------------+\n\nURL: https://mariadb.com/kb/en/log2/','','https://mariadb.com/kb/en/log2/'),(62,'OCT',4,'Syntax\n------\n\nOCT(N)\n\nDescription\n-----------\n\nReturns a string representation of the octal value of N, where N is a longlong\n(BIGINT) number. This is equivalent to CONV(N,10,8). Returns NULL if N is NULL.\n\nExamples\n--------\n\nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42      |\n+---------+\n\nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14      |\n+---------+\n\nURL: https://mariadb.com/kb/en/oct/','','https://mariadb.com/kb/en/oct/'),(63,'PI',4,'Syntax\n------\n\nPI()\n\nDescription\n-----------\n\nReturns the value of π (pi). The default number of decimal places displayed is\nsix, but MariaDB uses the full double-precision value internally.\n\nExamples\n--------\n\nSELECT PI();\n+----------+\n| PI()     |\n+----------+\n| 3.141593 |\n+----------+\n\nSELECT PI()+0.0000000000000000000000;\n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n|      3.1415926535897931159980 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/pi/','','https://mariadb.com/kb/en/pi/'),(64,'POW',4,'Syntax\n------\n\nPOW(X,Y)\n\nDescription\n-----------\n\nReturns the value of X raised to the power of Y.\n\nPOWER() is a synonym.\n\nExamples\n--------\n\nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n|        8 |\n+----------+\n\nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n|      0.25 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/pow/','','https://mariadb.com/kb/en/pow/'),(65,'POWER',4,'Syntax\n------\n\nPOWER(X,Y)\n\nDescription\n-----------\n\nThis is a synonym for POW(), which returns the value of X raised to the power\nof Y.\n\nURL: https://mariadb.com/kb/en/power/','','https://mariadb.com/kb/en/power/'),(61,'MOD',4,'Syntax\n------\n\nMOD(N,M), N % M, N MOD M\n\nDescription\n-----------\n\nModulo operation. Returns the remainder of N divided by M. See also Modulo\nOperator.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any number modulus zero\nproduces an error. Otherwise, it returns NULL.\n\nThe integer part of a division can be obtained using DIV.\n\nExamples\n--------\n\nSELECT 1042 % 50;\n+-----------+\n| 1042 % 50 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n|            4 |\n+--------------+\n\nSELECT 253 % 7;\n+---------+\n| 253 % 7 |\n+---------+\n|       1 |\n+---------+\n\nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n|         2 |\n+-----------+\n\nSELECT 29 MOD 9;\n+----------+\n| 29 MOD 9 |\n+----------+\n|        2 |\n+----------+\n\nURL: https://mariadb.com/kb/en/mod/','','https://mariadb.com/kb/en/mod/'),(66,'RADIANS',4,'Syntax\n------\n\nRADIANS(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from degrees to radians. Note that π radians\nequals 180 degrees.\n\nThis is the converse of the DEGREES() function.\n\nExamples\n--------\n\nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45)       |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n\nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90)     |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI())      |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n\nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180)     |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/radians/','','https://mariadb.com/kb/en/radians/'),(67,'RAND',4,'Syntax\n------\n\nRAND(), RAND(N)\n\nDescription\n-----------\n\nReturns a random DOUBLE precision floating point value v in the range 0 <= v <\n1.0. If a constant integer argument N is specified, it is used as the seed\nvalue, which produces a repeatable sequence of column values. In the example\nbelow, note that the sequences of values produced by RAND(3) is the same both\nplaces where it occurs.\n\nIn a WHERE clause, RAND() is evaluated each time the WHERE is executed.\n\nStatements using the RAND() function are not safe for statement-based\nreplication.\n\nPractical uses\n--------------\n\nThe expression to get a random integer from a given range is the following:\n\nFLOOR(min_value + RAND() * (max_value - min_value +1))\n\nRAND() is often used to read random rows from a table, as follows:\n\nSELECT * FROM my_table ORDER BY RAND() LIMIT 10;\n\nNote, however, that this technique should never be used on a large table as it\nwill be extremely slow. MariaDB will read all rows in the table, generate a\nrandom value for each of them, order them, and finally will apply the LIMIT\nclause.\n\nExamples\n--------\n\nCREATE TABLE t (i INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.255651095188829 |\n|    2 | 0.833920199269355 |\n|    3 |  0.40264774151393 |\n+------+-------------------+\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.511478140495232 |\n|    2 | 0.349447508668012 |\n|    3 | 0.212803152588013 |\n+------+-------------------+\n\nUsing the same seed, the same sequence will be returned:\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nGenerating a random number from 5 to 15:\n\nSELECT FLOOR(5 + (RAND() * 11));\n\nURL: https://mariadb.com/kb/en/rand/','','https://mariadb.com/kb/en/rand/'),(68,'ROUND',4,'Syntax\n------\n\nROUND(X), ROUND(X,D)\n\nDescription\n-----------\n\nRounds the argument X to D decimal places. D defaults to 0 if not specified. D\ncan be negative to cause D digits left of the decimal point of the value X to\nbecome zero.\n\nThe rounding algorithm depends on the data type of X:\n\n* for floating point types (FLOAT, DOUBLE) the C libraries rounding function\nis used, so the behavior *may* differ between operating systems\n* for fixed point types (DECIMAL, DEC/NUMBER/FIXED) the \"round half up\" rule\nis used, meaning that e.g. a value ending in exactly .5 is always rounded up.\n\nExamples\n--------\n\nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n|           -1 |\n+--------------+\n\nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n|           -2 |\n+--------------+\n\nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n|           2 |\n+-------------+\n\nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n|             1.3 |\n+-----------------+\n\nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n|                20 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/round/','','https://mariadb.com/kb/en/round/'),(69,'SIGN',4,'Syntax\n------\n\nSIGN(X)\n\nDescription\n-----------\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X is\nnegative, zero, or positive.\n\nExamples\n--------\n\nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n|        -1 |\n+-----------+\n\nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n|       0 |\n+---------+\n\nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/sign/','','https://mariadb.com/kb/en/sign/'),(70,'SIN',4,'Syntax\n------\n\nSIN(X)\n\nDescription\n-----------\n\nReturns the sine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT SIN(PI());\n+----------------------+\n| SIN(PI())            |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n\nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n|                0 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/sin/','','https://mariadb.com/kb/en/sin/'),(71,'SQRT',4,'Syntax\n------\n\nSQRT(X)\n\nDescription\n-----------\n\nReturns the square root of X. If X is negative, NULL is returned.\n\nExamples\n--------\n\nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n|       2 |\n+---------+\n\nSELECT SQRT(20);\n+------------------+\n| SQRT(20)         |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n\nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n|         42 |\n+------------+\n\nURL: https://mariadb.com/kb/en/sqrt/','','https://mariadb.com/kb/en/sqrt/'),(72,'TAN',4,'Syntax\n------\n\nTAN(X)\n\nDescription\n-----------\n\nReturns the tangent of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n|      0.9999999999999999 |\n+-------------------------+\n\nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI())             |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n\nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1)     |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n\nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/tan/','','https://mariadb.com/kb/en/tan/'),(73,'TRUNCATE',4,'This page documents the TRUNCATE function. See TRUNCATE TABLE for the DDL\nstatement.\n\nSyntax\n------\n\nTRUNCATE(X,D)\n\nDescription\n-----------\n\nReturns the number X, truncated to D decimal places. If D is 0, the result has\nno decimal point or fractional part. D can be negative to cause D digits left\nof the decimal point of the value X to become zero.\n\nExamples\n--------\n\nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n|               1.2 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n|               1.9 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n|               -1.9 |\n+--------------------+\n\nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n|              100 |\n+------------------+\n\nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n|                  1028 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/truncate/','','https://mariadb.com/kb/en/truncate/'),(74,'INSTALL PLUGIN',5,'Syntax\n------\n\nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement installs an individual plugin from the specified library. To\ninstall the whole library (which could be required), use INSTALL SONAME. See\nalso Installing a Plugin.\n\nplugin_name is the name of the plugin as defined in the plugin declaration\nstructure contained in the library file. Plugin names are not case sensitive.\nFor maximal compatibility, plugin names should be limited to ASCII letters,\ndigits, and underscore, because they are used in C source files, shell command\nlines, M4 and Bourne shell scripts, and SQL environments.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension can be omitted (which makes the statement look\nthe same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nINSTALL PLUGIN causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nPLUGIN only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a note instead of\nan error if the specified plugin already exists. See SHOW WARNINGS.\n\nExamples\n--------\n\nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n\nThe extension can also be omitted:\n\nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected (0.104 sec)\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------+\n| Level | Code | Message                            |\n+-------+------+------------------------------------+\n| Note  | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n\nURL: https://mariadb.com/kb/en/install-plugin/','','https://mariadb.com/kb/en/install-plugin/'),(78,'Plugin Overview',5,'Plugins are server components that enhance MariaDB in some way. These can be\nanything from new storage engines, plugins for enhancing full-text parsing, or\neven small enhancements, such as a plugin to get a timestamp as an integer.\n\nQuerying Plugin Information\n---------------------------\n\nThere are a number of ways to see which plugins are currently active.\n\nA server almost always has a large number of active plugins, because the\nserver contains a large number of built-in plugins, which are active by\ndefault and cannot be uninstalled.\n\nQuerying Plugin Information with SHOW PLUGINS\n---------------------------------------------\n\nThe SHOW PLUGINS statement can be used to query information about all active\nplugins.\n\nFor example:\n\nSHOW PLUGINS\\G;\n********************** 1. row **********************\n Name: binlog\n Status: ACTIVE\n Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n********************** 2. row **********************\n Name: mysql_native_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n********************** 3. row **********************\n Name: mysql_old_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n...\n\nIf a plugin\'s Library column has a NULL value, then the plugin is built-in,\nand it cannot be uninstalled.\n\nQuerying Plugin Information with information_schema.PLUGINS\n-----------------------------------------------------------\n\nThe information_schema.PLUGINS table can be queried to get more detailed\ninformation about plugins.\n\nFor example:\n\nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row ***************************\n     PLUGIN_NAME: CSV\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: Brian Aker, MySQL AB\n  PLUGIN_DESCRIPTION: CSV storage engine\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row ***************************\n     PLUGIN_NAME: MEMORY\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: MySQL AB\n  PLUGIN_DESCRIPTION: Hash based, stored in memory, useful for temporary\ntables\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n\nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value, then the plugin is\nbuilt-in, and it cannot be uninstalled.\n\nQuerying Plugin Information with mysql.plugin\n---------------------------------------------\n\nThe mysql.plugin table can be queried to get information about installed\nplugins.\n\nThis table only contains information about plugins that have been installed\nvia the following methods:\n\n* The INSTALL SONAME statement.\n* The INSTALL PLUGIN statement.\n* The mysql_plugin utility.\n\nThis table does not contain information about:\n\n* Built-in plugins.\n* Plugins loaded with the --plugin-load-add option.\n* Plugins loaded with the --plugin-load option.\n\nThis table only contains enough information to reload the plugin when the\nserver is restarted, which means it only contains the plugin name and the\nplugin library.\n\nFor example:\n\nSELECT * FROM mysql.plugin;\n\n+------+------------+\n| name | dl         |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n\nInstalling a Plugin\n-------------------\n\nThere are three primary ways to install a plugin:\n\n* A plugin can be installed dynamically with an SQL statement.\n* A plugin can be installed with a mysqld option, but it requires a server\nrestart.\n* A plugin can be installed with the mysql_plugin utility, while the server is\ncompletely offline.\n\nWhen you are installing a plugin, you also have to ensure that:\n\n* The server\'s plugin directory is properly configured, and the plugin\'s\nlibrary is in the plugin directory.\n* The server\'s minimum plugin maturity is properly configured, and the plugin\nis mature enough to be installed.\n\nInstalling a Plugin Dynamically\n-------------------------------\n\nA plugin can be installed dynamically by executing either the INSTALL SONAME\nor the INSTALL PLUGIN statement.\n\nIf a plugin is installed with one of these statements, then a record will be\nadded to the mysql.plugins table for the plugin. This means that the plugin\nwill automatically be loaded every time the server restarts, unless\nspecifically uninstalled or deactivated.\n\nInstalling a Plugin with INSTALL SONAME\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL SONAME\nstatement. INSTALL SONAME installs all plugins from the given plugin library.\nThis could be required for some plugin libraries.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin), you could execute the\nfollowing:\n\nINSTALL SONAME \'server_audit\';\n\nInstalling a Plugin with INSTALL PLUGIN\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL PLUGIN\nstatement. INSTALL PLUGIN installs a single plugin from the given plugin\nlibrary.\n\nFor example, to install the server_audit audit plugin from the server_audit\nplugin library, you could execute the following:\n\nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n\nInstalling a Plugin with Plugin Load Options\n--------------------------------------------\n\nA plugin can be installed with a mysqld option by providing either the\n--plugin-load-add or the --plugin-load option.\n\nIf a plugin is installed with one of these options, then a record will not be\nadded to the mysql.plugins table for the plugin. This means that if the server\nis restarted without the same option set, then the plugin will not\nautomatically be loaded.\n\nInstalling a Plugin with --plugin-load-add\n------------------------------------------\n\nYou can install a plugin with the --plugin-load-add option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load-add option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nSpecial care must be taken when specifying both the --plugin-load option and\nthe --plugin-load-add option together. The --plugin-load option resets the\nplugin load list, and this can cause unexpected problems if you are not aware.\nThe --plugin-load-add option does not reset the plugin load list, so it is\nmuch safer to use. See Specifying Multiple Plugin Load Options for more\ninformation.\n\nInstalling a Plugin with --plugin-load\n--------------------------------------\n\nYou can install a plugin with the --plugin-load option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load=\'server_audit;ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option together. The --plugin-load option resets the plugin\nload list, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use. See Specifying Multiple Plugin Load Options for more information.\n\nSpecifying Multiple Plugin Load Options\n---------------------------------------\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use.\n\nThis can have the following consequences:\n\n* If the --plugin-load option is specified multiple times, then only the last\ninstance will have any effect. For example, in the following case, the first\ninstance of the option is reset:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* If the --plugin-load option is specified after the --plugin-load-add option,\nthen it will also reset the changes made by that option. For example, in the\nfollowing case, the --plugin-load-add option does not do anything, because the\nsubsequent --plugin-load option resets the plugin load list:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* In contrast, if the --plugin-load option is specified before the\n--plugin-load-add option, then it will work fine, because the\n--plugin-load-add option does not reset the plugin load list. For example, in\nthe following case, both plugins are properly loaded:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nInstalli